﻿USE sofia;
DROP TABLE IF EXISTS sofia.iqw_vpl;
CREATE TABLE iqw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES iqw_vpl WRITE;
INSERT INTO iqw_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Lẹ mbụlembu; bẹ Nchileke meru igwe; bya emee mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mgboko te nwe ụgbugba; to nwe iphe nọ iya nụ. Yọ bụru mini jiru ẹkemeke ọbule. Eli mini ono agbakọta ọchi. Ume Nchileke eruphelephu l'eli mini ono ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tọ dụ iya bụ; Nchileke asụ: “T'iphoro dụ.” Iphoro adụwaphu. ");
INSERT INTO iqw_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iphoro ono adụ Nchileke mma. Yọ bya edokahu iphoro ono yẹ l'ọchi ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nchileke abya agụa iphoro ono “Eswe;” gụa ọchi ono “Ẹnyashi.” Nchi ejihu bya abọhu. Ono abụru mbọku kẹ mbụ. ");
INSERT INTO iqw_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ya ndono; Nchileke asụ: “T'iphe nọdu l'echi mini ono; nọ-buhu iya ẹbo.” ");
INSERT INTO iqw_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tọ dụ iya bụ; Nchileke abya emee ìphè ono; yo dobuhu mini ọphu nọ l'imeli; l'ọphu nọ l'alị. Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nchileke eworu ìphè ono gụa “Akpamigwe.” Nchi abya ejihu; bya abọhu. Ono abụru mbọku k'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nchileke asụ: “Tẹ mini ọphu nọ lẹ mgboko nọkobe l'ẹkalanu; tẹ ẹke, kpọhuru nkụ mifuta.” Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nchileke agụa ẹke ono, kpọhuru nkụ ono “Alị;” gụa mini phụ “Eze Ẹnyimu.” Nchileke abya elee ya ẹnya; yọ dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nchileke asụ: “T'alị fushia ụnwu iru; iphe, eye nebyi; mẹ oshi-ọmi; t'ọphu nọnu mịshia akpụru l'ụgbagba nkiya.” Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Alị abya efushia ụnwu iru; fushia oshi, eye nebyi; mẹ oshi-ọmi; ọphu nọnu amịshia akpụru l'ụgbugba nk'iya. Yọ dụ Nchileke mma. ");
INSERT INTO iqw_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nchi abya ejihu; bya abọhu. Ono abụru mbọku k'ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nchileke asụ: “T'iphoro nọdu l'akpamigwe dokahuje eswe l'ẹnyashi; shi ẹge ono koshije teke bụ ògè iphe; mẹ ụboku; mẹ teke bụ l'afa gvụru. ");
INSERT INTO iqw_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","T'iphoro ono, nọ l'akpamigwe ono chije lẹ mgboko.” Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nchileke abya emee iphoro labụ, shihuru ike. Iphoro ọphu ka nshinu b'o meru t'o chije l'eswe; bya emee iphoro ọphu k'ọla alị t'o chije l'ẹnyashi. Yọ bya emekwaaphu ụnwu mkpọ-kpodo. ");
INSERT INTO iqw_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nchileke abya eworu iphoro dobe l'akpamigwe t'o chije lẹ mgboko: ");
INSERT INTO iqw_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","eswe l'ẹnyashi; mẹkwaphu ẹge ẹphe edokahu iphoro l'ọchi. Nchileke abya elee ya ẹnya; yọ dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nchi abya ejihu; bya abọhu. Ono abụru mbọku k'ẹno. ");
INSERT INTO iqw_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nchileke asụ: “Tẹ mini kpofuta anụ l'ọ́tú t'o buru lẹ mini; ụnwenu awata ophe lẹ mgboko lẹ mkpuli akpamigwe.” ");
INSERT INTO iqw_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tọ dụ iya bụ; Nchileke emeshia ẹjo anụ, bugbaa l'eze ẹnyimu; mẹ iphe, nọ ndzụ, awụ awụwu l'ụdu iya l'ụdu iya; ẹphe eburu lẹ mini. Ụnwenu, ephe l'eli l'ọ ha ekpofutakwaphu l'ụdu iya l'ụdu iya; ọphu nọnu l'ụgbugba nk'iya. Nchileke abya elee ya ẹnya; yọ dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yọ bya agọoru iya ọnu; sụ iya: “T'ọ zụa; zụ-jishia mini, nọ l'eze ẹnyimu; ụnwenu azụkwaaphu zụ-jia mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nchi abya ejihu; bya abọhu. Ono abụru mbọku k'ise. ");
INSERT INTO iqw_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nchileke abya asụ: “Tẹ mgboko kpofuta iphe, nọgbaa ndzụ l'ụdu iya l'ụdu iya. T'iphe bụ elu kpofuta; mẹ ndu ọphu awụ l'ẹpho; mẹ anụ ndu ọphu bu l'ẹgbudu. T'ọphu nọnu kpofuta l'ụgbugba nk'iya.” Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nchileke meshiru anụ-ẹgu-ẹgbudu l'ụdu iya l'ụdu iya; mee elu l'ụdu iya l'ụdu iya; mekwaaphu anụ ọphu awụ l'ẹpho l'ụdu iya l'ụdu iya. Nchileke abya elee ya ẹnya; yọ dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nchileke asụ: “T'ayi mee madzụ t'o yeru ayi; mbụ t'ọ dụ ẹge ayi dụ. T'ọ bụru ishi, l'achị iphe, bụ ẹma, nọ l'eze ẹnyimu; ụnwenu, ephe l'eli; iphe, bụ elu l'ọ ha; mẹ eliphe gbaa mgburumgburu jeyekpo l'iphe bụ iphe, awụ l'ẹpho.” ");
INSERT INTO iqw_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tọ dụ iya bụ; Nchileke ekee madzụ; yo yeru iya. Yọ bụru ẹge Nchileke dụ bụ ẹge o keru iya; yọ dụ. Yo kee ẹphe nwoke lẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nchileke abya agọoru ẹphe ọnu; sụ ẹphe: “T'ẹphe zụa ha l'igwe. T'ẹphe zụa zụ-jia mgboko; bụru ishi iya. T'ẹphe bụru ishi, ẹma, bu l'eze ẹnyimu; bụru ishi ụnwenu, ephe l'eli; bụru ishi iphemiphe ọbule, e meru dobe lẹ mgboko-a.” ");
INSERT INTO iqw_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ya ndono; Nchileke asụ: “L'iphe, bụ iphe, amị akpụru lẹ mgboko-a; mẹ iphe, bụ oshi-ọmi; mẹ akpụru iya l'ọ ha; bẹ ya nụkotawaru unu t'ọ bụru unu nri. ");
INSERT INTO iqw_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Iphe, bụ anụ, nọ lẹ mgboko-a; mẹ iphe, bụ ụnwenu, ephe l'eli; mẹ iphemiphe ọbule, awụ l'ẹpho; mbụ iphe bụ iphe nọ ndzụ l'ọ ha; bẹ ya nụkotaru iru ẹswa t'ọ bụru ẹphe nri.” Yọ dụwaphu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nchileke abya elee ẹnya; phụ iphemiphe ọbule, o meru; yọ dụkota mma. Nchi abya ejihu; bya abọhu. Ono abụru mbọku k'ishingu. ");
INSERT INTO iqw_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ono abụru ẹge e gude mee igwe yẹle mgboko; mẹ iphemiphe ọbule, nọ iya nụ. ");
INSERT INTO iqw_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Lẹ mbọku k'ẹsaa bẹ Nchileke jegewaru ozi, o shi eje. Yo be lẹ mbọku k'ẹsaa ono; yọ tụa ume ozi ono, o jekotaru ono. ");
INSERT INTO iqw_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nchileke agọoru mbọku k'ẹsaa ono ọnu; bya emee ya; yọ dụ nsọ; kẹ l'ọ bụ mbọku ono b'ọ tụru ume kẹ iphemiphe ọbule ono, o meshiru ono. ");
INSERT INTO iqw_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ọwaa ẹge o gude mee igwe yẹle mgboko teke o meru iya. Mbọku Ojejoje, bụ Nchileke meru mgboko yẹle igwe; ");
INSERT INTO iqw_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","b'ẹ to nwedu oshi, shiwa gvuru l'alị; ọphu o nwedu iru, ruwaru l'ẹgu; kẹle Ojejoje, bụ Nchileke te shidu mewa tẹ mini chịje lẹ mgboko; madzụ ta nọwa k'ọkobe iphe l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yọ bụru mini, shi l'alị mụfuta bẹ oogudeje agba mini l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tọ dụ iya bụ; Ojejoje, bụ Nchileke abya egude ẹja, shi l'alị kpụa madzụ; bya ekuru ume ndzụ ye iya l'imi; onye ono abya abụru madzụ, nọ ndzụ. ");
INSERT INTO iqw_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ojejoje, bụ Nchileke abya eworu mgbabu gbaa l'ụzo ẹnyanwu-ahata lẹ Ídẹnu; bya eworu nwoke ono, ọ kpụru ono dobe iya. ");
INSERT INTO iqw_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ojejoje, bụ Nchileke abya emee t'oshi, dụtsua iche iche fushia l'alị ono; mbụ oshi, dụ mma ole ẹnya; bya adụ mma eriri. L'echi mgbabu ono; bẹ oshi, anụje ndzụ nọ; mẹ oshi, emeje t'a maru iphe, dụ mma yẹle iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yọ bụru l'alị Ídẹnu bẹ nggele, agba mini lẹ mgbabu ono eshije atsọshi. Nggele ono abya amakahụ ụzo ẹno lẹ mgbabu ono. ");
INSERT INTO iqw_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ẹpha nggele kẹ mbụ bụ Pishọnu ghajahụru alị Havila, bụ ẹke mkpọla-ododo nọ. ");
INSERT INTO iqw_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ọkpobe mkpọla-ododo nọ l'alị ono. Bedelọmu, bụ etse, eshi mkpọ anọdu iya; ónìkùsù, bụ mkpuma, aswa nọ anọdukwa iya phụ. ");
INSERT INTO iqw_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ẹpha nggele k'ẹbo bụ Gihọnu. Yẹbedua ghajahụru echi alị Kúshi. ");
INSERT INTO iqw_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ẹpha nggele k'ẹto bụ Táyigirisu; yẹbedua tsọru shia ụzo ẹnyanwu-ahata l'ibyiya kẹ Ashuru. Nggele k'ẹno abụru Yufurétusu. ");
INSERT INTO iqw_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ojejoje, bụ Nchileke abya eduta nwoke ono je edobe lẹ mgbabu Ídẹnu t'o jeje iya ozi; letaje iya ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ojejoje, bụ Nchileke abya atụaru nwoke ono ekemu; sụ iya: “L'a haru iya t'o rije akpụru oshi, nọkota lẹ mgbabu-wa; ");
INSERT INTO iqw_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ọbu lẹ nanụ ọphu ẹ too ridu bụ oshi ono, emeje t'a maru iphe, dụ mma yẹle iphe, dụ ẹji ono; kẹle mbọku, o riru iya bẹ ọo-nwụhukwa.” ");
INSERT INTO iqw_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ya ndono; Ojejoje, bụ Nchileke abya asụ: “L'ẹ tọ dụkwa mma tẹ nwoke ono nọdu nwẹnkinyi iya. Lẹ ya e-metaru iya onye n-yemẹka, gbaru iya nụ.” ");
INSERT INTO iqw_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tọ dụ iya bụ; Ojejoje, bụ Nchileke egudetsua ẹja, shi l'alị mee ụnwu anụmanu; mẹ ụnwenu, ephe l'eli; bya achịtaru iya Ádamu t'ọ maru iphe, ọo-gụshi iya. Yọ bụru iphe, Ádamu gụshiru iphemiphe ọbule ono, nọ ndzụ ono bẹ ẹphe wataru azaza. ");
INSERT INTO iqw_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Tọ dụ iya bụ; Ádamu abya eworu ẹpha gụshia elu l'ọ ha; mẹ ụnwenu, ephe l'eli; mẹ anẹgu-ẹgbudu l'ọ ha. Obenu lẹ Ádamu te nwedu onye n-yemẹka, gbaru iya nụ, a chọ-vuru iya. ");
INSERT INTO iqw_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tọ dụ iya bụ; Ojejoje, bụ Nchileke abya emee Ádamu; ọkpobe mgbẹnya atsụ iya. Yọ nọdu lẹ mgbẹnya ono; Nchileke abya ahata iya ọkpu-nggara; gude anụ ẹhu rachita iya. ");
INSERT INTO iqw_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ojejoje, bụ Nchileke abya egude ọkpu-nggara ono, ọ hataru Ádamu l'ẹhu ono mee nwanyi; bya edutaru iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ádamu echia mkpu; sụ: “Onye ọwaa bụ ọkpu, shi mu l'ọkpu; bụru ẹhu, shi mu l'ẹhu mu. Iphe, ee-ku iya bụ ‘nwanyi’; kẹ l'e shi l'ẹhu nwoke wofuta iya.” ");
INSERT INTO iqw_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ọo ya kparu iphe, nwoke a-hajẹ nne iya; haa nna iya; yẹle nyee ya atụgbabe; bụru ugwẹhu lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nwoke ono yẹle nyee ya ono ajịko gbaru ọtu; ọphu iphere 'adụdu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Agwọ bụ anụ, shi kakọta ẹregede l'iphe, bụ anẹgu-ẹgbudu, Ojejoje, bụ Nchileke meshiru l'ọ ha. Ya ndono; yọ jị nwanyi ono: “Nchileke; ?ọ sụru t'ẹ b'ọ dụshi akpụru oshi, nọ lẹ mgbabu-wa, unu e-rije tọo?” ");
INSERT INTO iqw_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nwanyi ono asụ agwọ ono: “Lẹ Nchileke sụkwaru t'ayi rije iphe, bụ akpụru, shi l'oshi, nọ lẹ mgbabu-a. ");
INSERT INTO iqw_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Obenu lẹ Nchileke sụkwanuru t'ayi be erikwa akpụru oshi, shi l'oshi ọphu nọ l'echi mgbabu ono. Mbụ t'ayi be edenyikwa iya ẹka edenyi lẹ phuu; l'ayi denyiwa iya ẹka bẹ ayi a-nwụhukwa.” ");
INSERT INTO iqw_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Agwọ asụ nwanyi ono: “Ẹ tọ dụkwa anwụhu, unu a-nwụhu. ");
INSERT INTO iqw_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Iphe gbe mechia nụ bụ lẹ Nchileke marua l'unu -ria ya; bẹ ẹnya a-sahụ unu; unu adụ l'ọ bụ Nchileke; maru iphe, dụ mma; mẹ ọphu dụ ẹji.” ");
INSERT INTO iqw_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nwanyi ono abya elee ẹnya l'akpụru oshi ono; phụ l'ọ dụ mma k'eriri; l'amakwaphu mma ole ẹnya. Yọ gụkfuru iya tẹ ya ria akpụru oshi ono; maru mmamiphe. Yọ bya awọta iya taa; bya awọtakwaphu nụ nji iya, yẹle iya tụko nọdu l'ẹke ono; yọ takwaaphu. ");
INSERT INTO iqw_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ẹnya abya asahụkota ẹphe; ẹphe abya amaru l'ẹphe gba ọtu. Ẹphe abya adzụkobewaphu mkpẹkwo figu weru. ");
INSERT INTO iqw_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ẹphe abya anụa ụkporo Ojejoje, bụ Nchileke l'ẹke oojephe lẹ mgbabu ono lẹ gẹrigeri urẹnyashi; je eworu onwẹphe domishia l'azụ oshi, nọtsua lẹ mgbabu ono tẹ Ojejoje, bu Nchileke ba aphụ ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ojejoje, bụ Nchileke abya ekua Ádamu; sụ iya: “?Bụ awe b'ị nọ?” ");
INSERT INTO iqw_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ádamu asụ iya: “Lẹ ya nụkwaru ụkporo ngu lẹ mgbabu ono; je eworu onwiya domia l'ẹke ya atsụ egvu; kẹle ya gba ọtu.” ");
INSERT INTO iqw_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ojejoje asụ iya: “?Bụ onye sụru ngu l'ị gba ọtu? ?Ti riakwa nụ akpụru oshi ono, ya sụru t'ẹ b'i ri ono?” ");
INSERT INTO iqw_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ádamu asụ iya: “L'ọ kwa nwanyi-a, i doberu iya l'ẹka-wa bẹ wọtaru iya nụ iya; ya ataa ya.” ");
INSERT INTO iqw_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ojejoje, bụ Nchileke abya ajị nwanyi ono: “?Nanụ ẹge ọ dụ b'i meru iya ẹge ono?” Nwanyi ono asụ iya: “L'ọ kwa agwọ deru iya ye; ya eje eria ya.” ");
INSERT INTO iqw_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ojejoje, bụ Nchileke asụ agwọ: “Lẹ keshinu ọphu i meru egbe iphe ọwaa; bẹ: Bụ nggụbedua nwẹnkinyi ngu; b'a tụru ọnu l'iphe, bụ elu; mẹ anẹgu-ẹgbudu l'ọ ha. Ịi-wata ọwu l'ẹpho. Yọ bụru ẹja, nọ l'alị bẹ ịi-nọdu eri gbururu jeye ẹge ịi-nọ-bebe. ");
INSERT INTO iqw_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ya mewaru tẹ nggu lẹ nwanyi-a nọdu l'okfu. Awa ngu yẹle kẹ nwanyi-a a-nọdukwaphu l'okfu. Ọo-dzọpyaje ngu ishi; nggụbedua emeka iya iphe l'ichirukfu.” ");
INSERT INTO iqw_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Nwanyi ono b'ọ sụru: “Ya e-me tẹ ọpa ẹpho-ime karụ ngu ẹhuka. Ii-jenwuje ẹhu tẹmanu nggu amụa nwa. Obenu lẹ nji ngu a-nọdujele-e agụ ngu ẹgu. Yọ bụru nji ngu ono a-bụru ngu onye ishi.” ");
INSERT INTO iqw_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ádamu b'ọ sụru: “Keshinu ọphu i kwetaru ngabẹru nyee ngu nchị; je eria akpụru oshi ono, ya sụru tẹ b'i rishi ono bẹ Ya gudeekwa okfu ẹka ngu tụ alị ọnu. Ii-jeje ntakfuru; tẹmanu nggu esebuta iphe, ii-ri. Yọ bụru ẹge ịi-nọduje eje iya ndono gbururu jeye ẹge ịi-nọ-bebe.” ");
INSERT INTO iqw_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","“Alị a-wataru ngu ofushiru ẹjo ẹgbudu; mẹ ogvu. Yọ bụru akpụru iphe, mịtaru l'ẹgu a-bụjeru ngu nri. ");
INSERT INTO iqw_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ii-gbutaje ẹphuru phee tẹmanu nggu eria nri; gbururu jeye teke ịi-lata azụ l'alị; keshinu ọphu ọ bụ l'ẹja b'i shi; yọ bụru ẹja b'ị bụ. Ọ bụkwaphu l'ẹja ono; bẹ ịi-laphu azụ.” ");
INSERT INTO iqw_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tọ dụ iya bụ; Ádamu agụa nyee ya ono Ívu; kẹ l'ọo-bụru nne ọha mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ojejoje, bụ Nchileke abya eworu akpọ anụ mee ẹkwa webe Ádamu yẹle nyee ya. ");
INSERT INTO iqw_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ya ndono; Ojejoje, bụ Nchileke asụ: “Nta-a bẹ madzụ dụwa l'ọ bụ ayịbedua; mbụ l'ọ mawaru iphe, dụ mma; maru ọphu, dụ ẹji. Ẹ ta ahakwa iya t'ọ wọtafua akpụru oshi, emeje t'a nọdu ndzụ ria; nọdu ndzụ ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tọ dụ ya bụ; Ojejoje, bụ Nchileke achịfu iya lẹ mgbabu Ídẹnu; t'o je ejeje ozi l'alị, bụ ẹke e shiru wota ẹja kpụa ya. ");
INSERT INTO iqw_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yọ chịfutsulephu nwoke ono lẹ mgbabu ono; bya eworu ojozi-imigwe, bụ Cherobu dobe l'ụzo ẹnyanwu-ahata mgbabu ono; bya eworu ogu-mbeke, enwu ọku; l'egbu ifu l'azụ dobe t'o cheje ụzo, e shi eje l'oshi-ndzụ phụ nche. ");
INSERT INTO iqw_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ádamu yẹle nyee ya; mbụ Ivu abya azẹe; yọ tsụta ime; mụa Kenu. Ivu asụ: “Lẹ Ojejoje yewaru iya ẹka; ya amụa nwata nwoke.” ");
INSERT INTO iqw_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","E metsua; yọ bya amụa Ébẹlu, bụ nwunne Kenu. Ebẹlu abụru onye akpa elu; Kenu abụru onye akọ okfu. ");
INSERT INTO iqw_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yo be ujiku lanụ; Kenu ahata iphe, ọ kọtaru l'alị tẹ ya je anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ébẹlu akpụta nwa ọdungu l'atụru iya gbua; bushia ya anụ iya l'ẹke, ọ katsụa ọgba ẹ̀bà bya anụ Ojejoje. Ébẹlu; mẹ iphe, ono ọ nụru ono adụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Obenu lẹ Kenu; mẹ iphe ọphu ọ nụru b'ọ jịkaru. Ya ndono; ẹhu eghulahaa Kenu eghughu; yọ swịkobe. ");
INSERT INTO iqw_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ojejoje asụ Kenu: “?Bụ ngụnu kparu iphe ẹhu eghu ngu eghughu? ?Nanụ ẹge ọ dụ b'ị swịkoberu? ");
INSERT INTO iqw_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ọ -bụru l'i meru iphe, dụ mma; ?bụ ngụnu meru iphe ẹhu ta ga atsọdu ngu ẹna. Obekwanu; ọ -bụru l'ẹ ti medu iphe, dụ mma; makwaru amaru l'ẹjo iphe vudokwa l'ọnu ụzo ngu; l'eme tẹ ya ripyabe ngu. Ọlobu; kakwa iya ike!” ");
INSERT INTO iqw_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tọ dụ iya bụ; Kenu asụ nwunne iya; mbụ Ébẹlu t'ẹphe je l'ẹgu. Ephe atụgbua; shi rua; Kenu egude nwunne iya ono gbua. ");
INSERT INTO iqw_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ya ndono; Ojejoje asụ Kenu: “?Nanụ nwunne ngu Ébẹlu?” Kenu asụ iya lẹ ya ta amakwa. Wo iya: “?Bụ yẹbedua bụ onye eche nwunne iya nche tọo?” ");
INSERT INTO iqw_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ojejoje asụ iya: “?Bụ onye ziru ngu ome egbe iya ọwaa?” Wo iya: “Ngabẹkwa nchị! Mee nwunne ngu ono bẹ nọ l'alị l'echiku iya lẹ mkpu. ");
INSERT INTO iqw_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nta-a b'ị bụakwa onye, a tụru ọnu. Alị ono, ghecharu ọnu; ngụa mee nwunne ngu ono a-tụkwa ngu ụchi. ");
INSERT INTO iqw_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ị -kọo alị ono b'ẹ tọ dụkwa iphe, i meta iya. Ịi-nọdulephu agba ọso ndzụ; l'agha ngvudangvu lẹ mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kenu asụ Ojejoje: “Ahụhu ọwaa, ịihu iya ọwaa bẹ karikwaru iya ẹka. ");
INSERT INTO iqw_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ẹge ịichifuwa iya l'alị-a ntanụ tẹ ya gbeshi ngu l'ifu; wata ọgha ngvudangvu lẹ mgboko-a; bẹ iphe, bụ onye -phụru iya nụ e-gbukwa iya.” ");
INSERT INTO iqw_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ojejoje asụ iya: “L'ẹ tọ dụkwa ẹge ono. L'o -nweru onye gburu nggụbe Kenu bẹ aa-gwatakwa onye ọbu ụgwo iya ugbo ẹsaa.” Ojejoje abya emee Kenu iphe-ọhubama; k'ọphu bụ l'ẹ-tọ dụdu onye, phụru iya nụ e-je iya egbugbu. ");
INSERT INTO iqw_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tọ dụ iya bụ; Kenu eshi l'ẹke, Ojejoje nọ gbeshi; je eburu lẹ Nọdu l'ụzo ẹnyanwu-ahata Ídẹnu. ");
INSERT INTO iqw_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kenu yẹle nyee ya abya azẹe. Yọ tsụta ime; mụa Ínọku. Kenu bẹ nweru mkpụkpu, ọokpu teke ono. Yo woru mkpụkpu ono gụa nwatibe iya; mbụ Ínọku. ");
INSERT INTO iqw_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ínọku abya amụta Iradu; Iradu abya amụta Mehujayẹlu; Mehujayẹlu abya amụta Metushẹlu; Metushẹlu abya amụta Lamẹku. ");
INSERT INTO iqw_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamẹku lụru ụnwanyi labụ. Onye lanụ bụ Ada; onye ọphu abụru Zela. ");
INSERT INTO iqw_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada abya amụta Jabẹlu. Jabẹlu ono bụ iya bụ nna ndu ebuje l'ụlo-ẹ́kwà; l'akpa iphe-edobe. ");
INSERT INTO iqw_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nwunne Jabẹlu bụ Jubalu. Yẹbedua, bụ Jubalu bụ nna ndu akpọje ogumogu; l'aphụ opu. ");
INSERT INTO iqw_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ọphube Zila bẹ mụtaru nwata nwoke, ẹpha iya bụ Tubalu-Kenu. Yẹbedua bụ onye gude ope; mẹ ígwè kpụshia iphe, dụ iche l'iche, eegudeje eje ozi. Ẹpha nwunne Tubalu-Kenu kẹ nwanyi bụ Naama. ");
INSERT INTO iqw_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ya ndono; Lamẹku asụ unyomu iya ono: “Ada; nggu lẹ Zela; unu gebe nchị! Unubẹ unyomu Lamẹku; unu lọo ẹka lẹ nchị! Ya gbukwaru madzụ; kẹ l'o mekaru iya iphe. Ọ kwa nwokorọbya, meru; ẹhu afụa iya ọnya; bẹ ya gburu. ");
INSERT INTO iqw_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ọ -bụru lẹ Kenu b'a gwataru ụgwo-ọchi iya ugbo ẹsaa; bẹ kẹ yẹbe Lamẹku a-bụkwaru ugbo ụkporo ẹto l'ugbo iri l'ẹsaa!” ");
INSERT INTO iqw_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Tọ dụ iya bụ; Ádamu yẹle nyee ya abya azẹe ọdo. Yọ bya atsụta ime mụa nwata nwoke; gụa ya Sẹtu; sụ: “Lẹ Nchileke nụwaru iya nwata nwoke ọdo, a-nọdu ọzori Ébẹlu ono, Kenu gburu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sẹtu abya amụta nwata nwoke; gụa ya Ẹ́noshi. Madzụ eshiwaphu teke ono wata ọkpo-ku ẹpha Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ọwaa bụ iphe, e deru lẹ kẹ ndu eri Ádamu; mẹ iphe, ẹphe meshiru. Teke Nchileke meru madzụ b'o meru iya; yọ dụ ẹge Nchileke dụ. ");
INSERT INTO iqw_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","O meru ẹphe nwoke lẹ nwanyi; bya agọoru ẹphe ọnu; kua ẹphe “madzụ.” ");
INSERT INTO iqw_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ádamu anọtsulephu ụkporo afa ishingu l'afa iri bya amụta nwata nwoke, dụlephu ẹge ọ dụ. Yo woru iya gụa Sẹtu. ");
INSERT INTO iqw_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A mụtsua Sẹtu; Ádamu abya anọo ụnu afa ẹbo. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Sẹtu. ");
INSERT INTO iqw_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ádamu nọru ụnu afa ẹbo l'ụkporo afa ishingu l'afa iri b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sẹtu anọtsulephu ụkporo afa ise l'afa ise bya amụta Ẹ́noshi. ");
INSERT INTO iqw_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Yọ mụtsua Ẹ́noshi; bya anọfua ụnu afa ẹbo l'afa ẹsaa. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Ẹnoshi. ");
INSERT INTO iqw_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sẹtu nọru ụnu afa ẹbo l'ụkporo afa ise l'afa iri l'ẹbo b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ẹ́noshi anọtsulephu ụkporo afa ẹno l'afa iri bya amụta Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Yọ mụtsua Kénanu; bya anọfua ụnu afa ẹbo l'afa iri l'ise. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ẹ́noshi nọru ụnu afa ẹbo l'ụkporo afa ise l'afa ise b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénanu anọtsulephu ụkporo afa ẹto l'afa iri bya amụta Mahálalẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Yọ mụtsua Mahálalẹlu; bya anọfua ụnu afa ẹbo l'ụkporo afa ẹbo. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Mahálalẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kénanu nọru ụnu afa ẹbo l'ụkporo afa ise l'afa iri b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahálalẹlu anọtsulephu ụkporo afa ẹto l'afa ise bya amụta Jaredi. ");
INSERT INTO iqw_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yọ mụtsua Jaredi; bya anọfua ụnu afa ẹbo l'ụkporo afa l'afa iri. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Jaredi. ");
INSERT INTO iqw_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahálalẹlu nọru ụnu afa ẹbo l'ụkporo afa ẹno l'afa iri l'ise b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredi anọtsulephu ụkporo afa ẹsato l'afa ẹbo; bya amụta Ínọku. ");
INSERT INTO iqw_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yọ mụtsua Ínọku; bya anọfua ụnu afa ẹbo. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Ínọku. ");
INSERT INTO iqw_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jaredi nọru ụnu afa ẹbo l'ụkporo afa ẹsato l'afa ẹbo b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ínọku anọtsulephu ụkporo afa ẹto l'afa ise bya amụa Metúsela. ");
INSERT INTO iqw_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Yọ mụtsua Metúsela yẹle Nchileke abya ayịa ayịyi ụkporo afa iri l'ise. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Metúsela. ");
INSERT INTO iqw_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Mkpakọ iphe Ínọku nọru bụ ụkporo afa iri l'ẹsato l'afa ise. ");
INSERT INTO iqw_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ínọku bẹ yẹle Nchileke yịru ayịyi. A nọnyaa; ta phụhe iya; kẹle Nchileke kutaru iya. ");
INSERT INTO iqw_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metúsela anọtsulephu ụkporo afa tete l'afa ẹsaa bya amụta Lamẹku. ");
INSERT INTO iqw_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Yọ mụtsua Lamẹku; bya anọfua ụnu afa l'ụkporo afa iri l'etete l'afa ẹbo. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Lamẹku. ");
INSERT INTO iqw_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metúsela nọru ụnu afa ẹbo l'ụkporo afa ẹsato l'afa tete b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamẹku anọtsulephu ụkporo afa tete l'afa ẹbo bya amụta nwata nwoke; ");
INSERT INTO iqw_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","gụa ya Nówa; sụ: “L'ọo-dụ ẹphe ike lẹ nsegbu-akanya-a, ẹphe ese l'alị-a, Ojejoje tụru ọnu-a.” ");
INSERT INTO iqw_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Yọ mụtsua Nówa; bya anọfua ụnu afa l'ụkporo afa tete l'afa iri l'ise. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Nówa. ");
INSERT INTO iqw_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamẹku nọru ụnu afa l'ụkporo afa iri l'ẹsato l'afa iri l'ẹsaa b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nówa anọtsulephu ụnu afa l'ụkporo afa ise bya amụta Shemu; mẹ Hamu; mẹ Jafẹtu. ");
INSERT INTO iqw_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tọ dụ iya bụ; ndiphe l'aka nshinu eje lẹ mgboko; aamụshi ụnwanyi l'eyeru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ụnwu Nchileke abya aphụ l'ụnwanyi ono, ndiphe amụshitsua ono amagbaa mma; onyenọnu eje alụtatsua onye ọphu, dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ojejoje asụ: “Lẹ ya ta ahahẹdu Ume yẹbe Ojejoje t'ọ nọdu madzụ l'ẹhu mgbe-'agvụ-agvụ; kẹle madzụ bụlephu anụ-ẹhu mmanu b'ọ bụ. Tsube nta-a bẹ iphe ọo-nọje bụ ụkporo afa ishingu.” ");
INSERT INTO iqw_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Teke ono bẹ ndu mkparawa, shi emeje iphe-kpaa nọkwadua lẹ mgboko; nọdukwa iya rụ kwasẹru; teke ụnwu Nchileke wataru ojekfu ụnwanyi kẹ ndiphe; ẹphe amụshilahaaru ẹphe ụnwu. Ndu ono bụ ndu ọgbo-mkparawa, e shi maru amaru teke ndiche. ");
INSERT INTO iqw_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ojejoje abya elee ẹnya; phụ ẹge madzụ dụ-tabewa ẹji lẹ mgboko; l'iphe, ẹphe anọduje arị tekenteke bụ ẹge ẹphe e-shi mee iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yọ bụru Ojejoje iphe-aphụ lẹ ya meru madzụ dobe lẹ mgboko; yọ tsụa ya l'ẹhu nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ojejoje asụ: “Lẹ ya e-melephu tẹ madzụ, ya meru dobe lẹ mgboko chịhu. Madzụ a-chịhu; anụ achịhu; iphe, bụ iphe awụ l'ẹpho achịhu; je akpaa lẹ nwẹnu, ephe l'eli; kẹ l'ọ bụwa iya iphe-aphụ lẹ ya meru ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Obenu lẹ Nówa bẹ tụbaru Ojejoje l'obu. ");
INSERT INTO iqw_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ọwaa akọ ẹhu Nówa: Nówa bụ onye doberu ẹka ndoo; onye ụta ẹ ta dụdu l'ẹhu l'ọgbo nk'iya. Yẹle Nchileke yịru ayịyi. ");
INSERT INTO iqw_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ọ mụtaru ụnwegirima unwoke ẹto: Shemu; Hamu; mẹ Jafẹtu. ");
INSERT INTO iqw_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Teke ono bẹ mgboko mebyishihuwaru l'ẹnya Nchileke; yọ bụru iphe-kpaa bẹ jiru ẹkemeke ọbule. ");
INSERT INTO iqw_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nchileke aphụa ẹge mgboko rehubetaru; kẹle ndiphe metoshiwaru onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tọ dụ iya bụ: Nchileke asụ Nówa: “Lẹ ya abyaakwa tẹ ya bya ekpochafu ndiphe; kẹ l'iphe, jiru mgboko bụlephu iphe-kpaa, shitaru ẹphebedua l'ẹka. Ya e-kpochafu ndiphe; mebyishia mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ọo ya bụ; gude oshi gofa kụa eze ụgbo. Nggu atụ-bushia ya mkpura mkpura; gude ụmu chia ya l'ime iya; mẹ l'azụ iya. ");
INSERT INTO iqw_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ọwaa ẹge ii-gude kụa ya ndọ-ọ: eze ụgbo ono a-dụ ụkporo nkwo-ẹka iri l'ise l'ogologo; ụsa iya adụ ụkporo nkwo-ẹka ẹbo lẹ nkwo-ẹka iri; eli iya adụ ụkporo nkwo-ẹka lẹ nkwo-ẹka iri. ");
INSERT INTO iqw_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nggu abya akụ-chia eli ụgbo ono akụ-chi t'o gude nkwo-ẹka lanụ ka l'eli. Ịi-kụ ụgbo ono t'ọ dụ mkpọ-kfu ẹto; nggu eye ibo lẹ mgberemẹku iya. ");
INSERT INTO iqw_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ya e-gude utso bya lẹ mgboko bya erigbushikota iphe, bụ iphe nọ ndzụ lẹ mkpuli igwe-a; mbụ iphemiphe ọbule, e meru ememe, atụ ume. Iphemiphe ọbule, nọ lẹ mgboko a-bụru kpurupyata. ");
INSERT INTO iqw_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Obenu lẹ nggụbedua bẹ nggu l'iya a-gba ndzụ; nggu abahụ l'ụgbo ono; nggụbedua; mẹ ụnwu ngu; mẹ nyee ngu; mẹ unyomu ụnwu ngu. ");
INSERT INTO iqw_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nggu abya afọo iphemiphe ọbule, nọ ndzụ ẹbo ẹbo; okee lẹ nyee; dobe ndzụ l'ẹke ị nọ. ");
INSERT INTO iqw_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nwẹnu, ephe l'eli a-dụ ẹbo ẹbo dụ l'ụdu iya l'ụdu iya byakfuta ngu; anẹgu-ẹgbudu yẹle anụ, awụ l'ẹpho adụkwaphu ẹbo ẹbo byakfutakota ngu t'i dobe ẹphe ndzụ. ");
INSERT INTO iqw_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nggu abya afọo nri iche l'iche dobe t'ọ bụru nri, unu l'ẹphe a-nọdu eri.” ");
INSERT INTO iqw_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nówa abya emekota iphemiphe ọbule ono ẹge ono, Nchileke sụru t'o mee ya ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E meebe; Ojejoje asụ Nówa: “T'ọ bahụ l'ụgbo ono yẹle ndibe iya l'ẹphe ha; kẹ l'ọ bụphu yẹbedua nwẹnkinyi iya bẹ ya phụru, bụ onye doberu ẹka ndoo l'ọgbo-wa. ");
INSERT INTO iqw_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Fọta anụ, ẹ ta sọdu nsọ ẹsaa ẹsaa: oke lẹ nyee. Nggu afọta anụ, aasọ nsọ ẹbo ẹbo: oke lẹ nyee. ");
INSERT INTO iqw_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Fọta ụnwenu ẹsaa ẹsaa l'ụdu iya l'ụdu iya: okee lẹ nyee; k'ọphu ọo-bya azụfuta ụdu iya lẹ mgboko ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","A -nọlephu ujiku ẹsaa nta-a bẹ ya e-me tẹ mini chịa lẹ mgboko ụkporo abalị ẹbo: eswe l'ẹnyashi; gude rigbushikota iphemiphe ọbule, nọ ndzụ, ya meru dobe lẹ mgboko-a.” ");
INSERT INTO iqw_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nówa abya ajịko iphemiphe ọbule ono, Ojejoje sụru t'o mee ono mekota. ");
INSERT INTO iqw_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nówa gbawaru ụnu afa l'ụkporo afa iri teke utso ono byaru lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nówa yẹle ụnwu iya; mẹ nyee ya; mẹ unyomu ụnwu iya awụba l'ụgbo ono; t'ẹphe gbalaaru utso ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Anụ ẹbo ẹbo l'ọphu ẹ ta sọdu nsọ; mẹ ọphu aasọ nsọ; mẹ l'ụnwenu; mẹkpo iphemiphe ọbule, awụ l'ẹpho: ");
INSERT INTO iqw_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","okee lẹ nyee abyakfutakota Nówa bya awụba l'ụgbo ono ẹge ono, Nchileke ziru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A nọtsulephu ujiku ẹsaa ono; utso abya eji mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","L'afa, kwe Nówa ụnu afa l'ụkporo afa iri; lẹ mbọku, ọnwa k'ẹbo dụlephu l'abalị iri l'ẹsaa bẹ ọgba-mini, nọtsua l'ime ime alị gbafushihuru; a gụhashia iphe, bụ ọnu-ụzo mini k'akpamigwe. ");
INSERT INTO iqw_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Igwe achịa mini lẹ mgboko ụkporo abalị ẹbo: eswe l'ẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lẹ mbọku ono gẹdegede bẹ Nówa yẹle ụnwu iya, bụ iya bụ Shemu; Hamu; mẹ Jafẹtu; mẹ nyee ya; mẹ unyomu ụnwu iya ono ẹphe ẹto jịko wụba l'ụgbo ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Anẹgu-ẹgbudu, dụtsua l'ụdu iya l'ụdu iya; mẹ elu, dụtsua l'ụdu iya l'ụdu iya; mẹ iphemiphe ọbule, bụ iphe awụ l'ẹpho, dụtsua l'ụdu iya l'ụdu iya; mẹ ụnwenu, dụtsua l'ụdu iya l'ụdu iya; mbụ iphemiphe ọbule, furu ẹ́bà bẹ tụkoru tsoru ẹphe bahụ l'ụgbo ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Iphemiphe ọbule, e meru ememe, nọ ndzụ dụ ẹbo ẹbo byakfuta Nówa; bya abahụ l'ụgbo ono. ");
INSERT INTO iqw_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anụ, wụbakotaru l'ụgbo ono bụkotalephu okee lẹ nyee iphemiphe ọbule, nọ ndzụ; ẹge ono, Nchileke sụru Nówa t'ọ dụ ono. E meebe; Ojejoje abya agụ-chia ụgbo ono gụ-buru ẹphe ye l'ime iya. ");
INSERT INTO iqw_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ụkporo abalị ẹbo bẹ utso ono byakọtaru lẹ mgboko; mini ono l'aka nshinu akaka l'eje; ụgbo ono l'ese atụgbu. ");
INSERT INTO iqw_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Yọ bụru ẹge utso ono abya kulakula l'atụgbu bụ ẹge ụgbo ono ese l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Utso ono byataberu; k'ọphu bụ l'o kpukotaru iphe, bụ ugvu ha l'eli lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ọ byataberu; k'ọphu bụ l'o gude nkwo-ẹka iri l'ise kakọta ugvu l'eli. ");
INSERT INTO iqw_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Iphemiphe ọbule, nọ ndzụ lẹ mgboko-a; bẹ lakọtaru l'iyi. Mbụ ụnwenu; elu; anẹgu-ẹgbudu; iphe, bụ iphe nọ lẹ mgboko; je akpaa lẹ madzụ bẹ bụkotaru kpurupyata. ");
INSERT INTO iqw_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Iphemiphe ọbule, nọ l'eli alị, gude imi atụ ume anwụshihukota. ");
INSERT INTO iqw_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Iphemiphe ọbule nọ ndzụ lẹ mgboko agvụ. Mbụ madzụ; mẹ anụ; iphemiphe ọbule, awụ l'ẹpho; mẹ ụnwenu b'e mebyishikotaru lẹ mgboko. Yọ bụru Nówa yẹle iphemiphe ọbule ono, ẹphe l'iya nọ l'ụgbo ono wafụru. ");
INSERT INTO iqw_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Utso ono dọru lẹ mgboko ụkporo abalị ẹsaa l'abalị iri. ");
INSERT INTO iqw_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Obenu lẹ Nchileke nyatarua Nówa; mẹ ụnwu-anụ-ẹgu; mẹ elu, ẹphe l'iya jịko nọdu l'ụgbo ono. Yọ bya emee; phẹrephere awata ephephe lẹ mgboko; mini ono awata alala. ");
INSERT INTO iqw_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nchileke abya eworu ọgba-mini ime alị phụ zụ-chishia; woru ọnu-ụzo mini k'akpamigwe phụ gụ-chishikwaaphu. Mini ono achị-buhu; ");
INSERT INTO iqw_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","watawaphu alala. A nọlephu ụkporo abalị ẹsaa l'abalị iri; mini ono alawa nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ọnwa k'ẹsaa agbalẹphu abalị iri l'ẹsaa; ụgbo ono eje je asụru l'ugvu Araratu. ");
INSERT INTO iqw_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mini ono alakpẹlephu jeye l'ọnwa k'iri. Yọ bụru lẹ mbọku mbụ l'ọnwa k'iri ono b'e beberu phụa ọnungonu ọnungonu ugvu. ");
INSERT INTO iqw_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","A nọlephu ụkporo abalị ẹbo; Nówa abya agụhaa windo, o yeru l'ụgbo ono; ");
INSERT INTO iqw_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bya ezifu ọphegu. Yo je ephephelahaa l'imeli: o -pheru jee; yo pheru laa; gbururu jeye teke mini ono tashịhukotaru lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Yọ bya ezifu ndo t'ọ maru mẹ mini ono; ?ọ tahụkotawaru l'eli alị? ");
INSERT INTO iqw_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Obenu lẹ ndo ono ta phụdu ẹke, oo-beru; kẹle mini kpukwaduru mgboko ekpukpu. Ya ndono; yọ lashia azụ lakfube Nówa l'ụgbo ono. Nówa amachịa ẹka; nwụta ndo ono ye l'ime ụgbo ono ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yọ bya anọo ujiku ẹsaa; bya eshikwa l'ụgbo ono zifu ndo ono ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ndo ono alatashia l'urẹnyashi; takpụru mkpẹkwo oshi olivu ọphungu l'ọnu. Nówa amaru lẹ mini tahụwaru lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yọ nọkwaa ujiku ẹsaa ọdo; bya ezifukwa ndo ono ọdo. Ndo ono ta latahe. ");
INSERT INTO iqw_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yo be lẹ mbọku mbụ l'ọnwa mbụ l'afa, kwe Nówa ụnu afa l'ụkporo afa iri l'afa lanụ; mini ono atashịhuwa l'alị. Nówa abya ewofu iphe, e gude kuchia ụgbo ono; bya aphụ lẹ mini tashịhuwaru lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Yo rua l'ọnwa k'ẹbo gbaru ụkporo abalị l'abalị ẹsaa; alị akpọshihukotawa nkụ. ");
INSERT INTO iqw_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ya ndono; Nchileke asụ Nówa: ");
INSERT INTO iqw_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Unu lụfuta l'ụgbo ono; nggu lẹ nyee ngu; mẹ ụnwu ngu; ẹphe l'unyomu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nggu achịfuta iphemiphe ọbule, nọ ndzụ, unu l'iya nọ l'ẹke ono: ụnwenu; mẹ anụ; mẹkpo iphemiphe ọbule, awụ l'ẹpho; t'ẹphe bya azụa azụzu zụ-jia mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tọ dụ iya bụ; Nówa abya alụfuta yẹle ụnwu iya; mẹ nyee ya; mẹ l'unyomu ụnwu iya. ");
INSERT INTO iqw_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Anụ ono l'ọ ha; mẹ iphemiphe ọbule, awụ l'ẹpho; mẹ ụnwenu kpamukpamu; mbụ iphemiphe ọbule, ejephe ejephe lẹ mgboko eshikota l'ụgbo ono lụfutakota l'ụdu iya l'ụdu iya. ");
INSERT INTO iqw_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nówa abya akpụaru Ojejoje ẹnya-ngwẹja; bya ahata anụ yẹle ụnwenu ndu ọphu ẹ taa sọdu nsọ; gwoo ngwẹja-ukfuru l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ojejoje anụlephu mkpọ iya; kfua l'ime obu iya; sụ: “Lẹ ya te egudehedu okfu ẹhu madzụ tụa alị ọnu ọdo; kẹ l'iphe, madzụ anọdujekpelephu arị l'obu iya shita lẹ nwata bụlephu ẹjo iphe. Ọphu ya te emebyishihedu iphemiphe ọbule, ya meru ememe, nọ ndzụ ẹge-a ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Jeye ẹge mgboko a-nọ-bebe; bẹ oge ọkobe iphe l'alị a-nọ; oge akpata iya anọdu. Oge oyi a-nọ; oge okpomọku anọdu. Udzu-mini anọ; winta anọdu. Eswe a-nọ; ẹnyashi anọdukwaphu; Ẹ to nwedu ọphu a-nọnyaa; tọo nọhe.” ");
INSERT INTO iqw_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nchileke abya agọoru Nówa yẹle ụnwu iya ọnu; sụ ẹphe: “Unu zụa; zụ-jishia mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ụnwu anụ-ẹgu-ẹgbudu, nọkota lẹ mgboko; ụnwenu, ephe l'eli; iphemiphe ọbule, awụ l'ẹpho; mẹ iphe bụ ẹma, bu lẹ mini bẹ biribiri unu e-gudeje; ẹphe atsụhu unu egvu. ");
INSERT INTO iqw_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iphemiphe ọbule, nọ ndzụ; l'eme ụkporo a-bụkotaru unu nri. Ọ bụ ẹge ya nụkotaru unu iphe, bụ oshi-ọmi bụ ẹge ya anụ unu iphemiphe ọbule. ");
INSERT INTO iqw_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ọlobu; unu ba atajẹkwa anụ; taa ndzụ iya; bụ iya bụ mee ya. ");
INSERT INTO iqw_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ya a-jịkwa ajị ishi unu. Iphe bụ anẹgu, gburu madzụ bẹ ya a-jịkwa ajị ishi onye ono. Madzụ -gburu madzụ ibe iya bẹ ya a-jịkwaphu ajị ishi onye ono. ");
INSERT INTO iqw_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Iphe bu onye -gburu madzụ kwaphụ madzụ e-gbu iya; kẹle Nchileke meru madzụ; yọ dụ l'ọ bụ Nchileke. ");
INSERT INTO iqw_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A -bya l'unubẹdua; unu jaa àjàjà; ka ẹswa l'igwe; unu azụa azụzu zụ-jia mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ya ndono; Nchileke asụ Nówa yẹle ụnwu iya, ẹphe l'iya jịko nọdu l'ẹke ono: ");
INSERT INTO iqw_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nta-a bẹ unu l'iya agba ndzụ; unubẹdua unu l'ụnwu unu ndu ọphu nọ l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ẹge ono bẹ yẹle iphe, bụ iphe nọ ndzụ, unu l'iya shi jịko nọdu gbakwaruphu ndzụ; mbụ nwẹnu; elu; anẹgu-ẹgbudu; mẹ iphemiphe ọbule ono, unu l'iya jịko shi l'ụgbo ono lụfuta ono; mbụ iphemiphe ọbule, nọ lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Unu l'iya gbaakwaru ndzụ. E te egudehedu utso rigbushia iphe, bụ iphe, nọ ndzụ ọdo. Ọphu o nwedu l'utso, e-mebyishikwadua mgboko-a ọdo.” ");
INSERT INTO iqw_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nchileke asụ: “Ọwaa iphe, a-nọdu ekoshi ndzụ ono, unu l'iya gbaru ono; mbụ ndzụ ono unu l'iya; mẹ iphe bụ iphe nọ ndzụ; mẹ l'ọgbo ọphu nọ l'ifu agba ono ndọ-ọ: ");
INSERT INTO iqw_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ya wowaru evu-mini dobe l'akpamigwe. Ọ bụ evu-mini ono a-nọdu ekoshi ndzụ ono yẹle mgboko mgburumgburu gbaru ono. ");
INSERT INTO iqw_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Teke igwe ruru eruru; -gbaa evu-mini ono; ");
INSERT INTO iqw_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ya anyata ndzụ, unu l'iya gbaru; unubẹdua; mẹ iphe, bụ iphe, nọ ndzụ l'ụdu iya l'ụdu iya. Mbụ l'ẹ to nwehedu lẹ mini erigbushia iphe, nọ ndzụ ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Iphe bụ teke evu-mini gbaru l'urukpu bẹ ya a-phụ iya; nyata ndzụ tutu yoyo ono, yẹbe Nchileke yẹle iphe, bụ iphe, nọ ndzụ l'ụdu iya l'ụdu iya lẹ mgboko-a gbaru ono.” ");
INSERT INTO iqw_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nchileke asụ Nówa: “Ọ bụ evu-mini ono a-nọdu ekoshi ndzụ ono yẹle iphemiphe ọbule, nọ ndzụ lẹ mgboko-a gbaru ono.” ");
INSERT INTO iqw_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ụnwu Nówa, shi l'ụgbo ono lụfuta bụ Shemu; Hamu; mẹ Jafẹtu. Yọ bụru Hamu bẹ mụru Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ọ bụ shita l'ẹka ụnwu Nówa; ẹphe unwoke ẹto bẹ madzụ shi dzuru mgboko kpamukpamu. ");
INSERT INTO iqw_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nówa, bụ onye akọje okfu, bụ iya bụ onye ọdungu, vuru ụzo wata ọko mgbo vayịnu. ");
INSERT INTO iqw_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Yo be ujiku lanụ; yọ ngụa mẹe, shi l'akpụru vayịnu ono. Mẹe ono egude iya; k'ọphu o wefuru iphe; gbaru ọtu je adaburu l'ụlo-ẹ́kwà iya. ");
INSERT INTO iqw_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, bụ nna Kénanu aphụa nna iya l'ẹke ọ gba ọtu; je ekfuaru iya unwunne iya ẹphe ẹbo l'etezi. ");
INSERT INTO iqw_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shemu; mẹ Jafẹtu achịta ẹkwa kobetsua onwẹphe l'ukuvu; kpọo l'azụ l'azụ je aphụ-kpua ya nna ẹphe ono. Ẹphe eworu ifu ghaa l'ibyiya ọdo t'ẹphe ba phụ nna ẹphe l'ẹke ọ gba ọtu. ");
INSERT INTO iqw_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mẹe ono ephohulephu Nówa l'ẹnya; yọ bya anụa iphe ono, mbuhu-ime iya meru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Yọ sụ: “Kénanu bụakwa onye a tụru ọnu. Ọo-bụru ohu laaru ohu l'ẹke unwunne iya phẹ nọ.” ");
INSERT INTO iqw_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yọ sụkwaphu: “T'e tua Ojejoje, bụ Nchileke kẹ Shemu ẹpha! Tẹ Kénanu bụkwaru ohu Shemu! ");
INSERT INTO iqw_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tẹ Nchileke mekwaa tẹ Jafẹtu jaa ajaja! Tẹ Jafẹtu buru l'ụlo-ẹ́kwà Shemu; Kénanu abụru ohu iya!” ");
INSERT INTO iqw_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","L'utso ono byatsụaru ono bẹ Nówa nọru ụkporo afa iri l'ẹsaa l'afa iri. ");
INSERT INTO iqw_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mkpakọ afa, Nówa nọru bụ ụnu afa ẹbo l'ụkporo afa ẹsaa l'afa iri b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ọwaa eri ụnwu Nówa, bụ iya bụ Shemu; Hamu; mẹ Jafẹtu, bụ ndu ẹphe mụshiru l'utso ono latsụaru. ");
INSERT INTO iqw_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ụnwu Jafẹtu bụ Goma; Mágọgu; Madayi; Javanu; Tubalu; Mẹ́sheku; mẹ Tirasu. ");
INSERT INTO iqw_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ụnwu kẹ Goma bụ Ashukenazu; Rifatu; mẹ Togarama. ");
INSERT INTO iqw_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ụnwu kẹ Javanu bụ ndu Elisha; ndu Tashishi; ndu Kítimu; mẹ ndu Ródu. ");
INSERT INTO iqw_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ndu ono bụ ndu eri Jafẹtu. Yọ bụru l'ẹphe; bẹ iphe bụ ọha ndu eli-alị; mẹ ndu butsua l'ikfuli shiru jakashịa. Ndu nọnu enwetsuaru ókè-alị nk'ẹphe; nweru okfu-alị nk'ẹphe; nwekwaruphu ikfu nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ụnwu kẹ Hamu bụ Kúshi; Íjiputu; Putu; mẹ Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ụnwu kẹ Kúshi bụ Séba; Havila; Sabúta; mẹ Réma yẹle Sabuteka. Ụnwu kẹ Réma bụ Sheba; mẹ Dedanu. ");
INSERT INTO iqw_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kúshi bụ iya mụru Nimurọdu, bụ onye ọdungu, byaru bya abụru oke mkparawa lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimurọdu bẹ Ojejoje meru; yọ bụru onye achị nta nshinu. Ọ bụ iya kparu iphe aanọduje anma iya l'ẹtu; sụ: “L'onye ọwaa dụ l'ọ bụ Nimurọdu, Ojejoje meru; yọ bụru iya ka lẹ kẹ ọchi nta.” ");
INSERT INTO iqw_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ẹke alị-eze iya byidoru bụ lẹ Babẹlu; Ẹreku; Akadu; mẹ Kalune. Ẹke ono nọkota l'alị Shịna. ");
INSERT INTO iqw_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Yo shi l'ẹke ono jaa jarua Asiriya, bụ ẹke ọ nọ meta mkpụkpu Nínive; Rehobọtu-Iye; Kala; ");
INSERT INTO iqw_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","mẹ Resenu. Resenu ono nọ lẹ mgbaku Nínive yẹle Kala, bụ iya bụ oke mkpụkpu ono. ");
INSERT INTO iqw_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Íjiputu bụ iya bụ nna ndu Ludu; ndu Anamu; ndu Lehabu; ndu Nafutu; ");
INSERT INTO iqw_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ndu Paturọsu; ndu Kafuto; mẹ ndu Kasuluhu. Ndu Kasuluhu bụ ẹphe metaru ndu Filisutayịnu. ");
INSERT INTO iqw_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kénanu bụ yẹbedua mụru Sayịdonu. Yọ bụru Sayịdonu ono bụ ọkpara iya. Ọ bụkwaphu Kénanu bụ nna ndu Hetu; ");
INSERT INTO iqw_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ndu Jebusu; ndu Amọru; ndu Gigashi; ");
INSERT INTO iqw_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ndu Hevu; ndu Arụka; ndu Sinu; ");
INSERT INTO iqw_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ndu Avadu; ndu Zéma; mẹ ndu Hámatu. A nọnyaa; ikfu ndu Kénanu abya ajakashịa. ");
INSERT INTO iqw_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ókè-alị ndu Kénanu shi lẹ Sayịdonu nọo jeye e gude ala Géra; mbụ jerua Gáza. O shikwaphu lẹ Gáza nọo jeye e gude ala Sódomu; Gọmóra; Adama; mẹ Zeboyimu; mbụ jeyewaru lẹ Lasha. ");
INSERT INTO iqw_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ono bụ ụnwu Hamu ndono; mẹ ikfu, ẹphe shitsua; okfu-alị ẹphe; mkpụkpu ẹphe; mẹ mba ẹphe l'iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu mụshikwaruphu ụnwegirima unwoke. Nwunne Jafẹtu k'ọgurenya bụ Shemu. Yọ bụru Shemu bụ ochechoroche ụnwu Eba l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ụnwu Shemu bụ Élamu; Ashuru; Afakusadu; Ludu; mẹ Áramu. ");
INSERT INTO iqw_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ụnwu kẹ Áramu bụ Uzu; Hulu; Geta; mẹfua Mashu. ");
INSERT INTO iqw_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afakusadu bụ yẹbedua mụru Shela. Shela amụa Eba. ");
INSERT INTO iqw_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba mụtaru unwoke labụ. Onye lanụ b'ọ gụru Pẹ́legu; kẹ l'a mụru iya teke ndu mgboko kekashihuru. Nwunne kẹ Pẹ́legu ono bụ Jọkutanu. ");
INSERT INTO iqw_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jọkutanu bụ yẹbedua mụru Alumodadu; Shẹlefu; Hazamaveti; Jera; ");
INSERT INTO iqw_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu; Uzalu; Dikila; ");
INSERT INTO iqw_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obalu; Abímẹlu; Sheba; ");
INSERT INTO iqw_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi; Havila; mẹfua Jobabu. Ẹphe l'ẹphe ha bụkota ụnwu Jọkutanu. ");
INSERT INTO iqw_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ẹphe buru tsube lẹ Mésha jerua e gude ala Sefa laa l'ọha, bu l'ugvu, nọ l'ụzo ẹnyanwu-ahata. ");
INSERT INTO iqw_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yọ bụru ụnwu Shemu ndono; l'ikfu l'ikfu; okfu-alị ẹphe; alị ẹphe; mẹ mba ẹphe l'iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ndu ono l'ẹphe ha bụkota eri ụnwu Nówa; l'ẹge ẹphe, shi fọkashia bụtsuaru ikfu; shikwaphu ẹge ono ghọtsua mba iche l'iche. Ọ bụ ẹphebedua bẹ bakashịhuru nụ; ghọo mbakeshi; dzuru mgboko l'utso ono byatsụaru. ");
INSERT INTO iqw_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ndiphe gbaa mgburumgburu bụ okfu-alị lanụ bẹ ẹphe shi ekfu; olu ẹphe abụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ya ndono; yo be teke ndiphe tụgburu ụzo ẹnyanwu-ahata; je aphụa ẹke alị daburu swanmangu l'alị Shịna; ẹphe eje ebukobe l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ẹphe asụ onwẹphe: “Unu bya t'ayi yọo ẹja hụa ya l'ọku hụ-ghee ya ahụ-ghe.” Yọ bụru ẹja ono, ẹphe yọshiru ayọyo ono bẹ nọ ọzori mkpuma. Ẹphe abya egude korota nyịa ya ọzori ẹpoto. ");
INSERT INTO iqw_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ẹphe asụ: “Unu bya t'ayi metaru onwayi mkpụkpu; t'ayi kpụa origodo ụlo-eli, e-je etsukfuru l'igwe. Ọo ya bụ; ayi abụru ndu aa-maru ẹpha ayi; k'ọphu ayi ta agbakashịhudu dzuru mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tọ dụ iya bụ; Ojejoje abya enyizita tẹ ya phụ mkpụkpu ono yẹle origodo ụlo-eli ono, ụnwu eliphe akpụ ono. ");
INSERT INTO iqw_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yọ bya asụ: “Ndu-a bụkwa ndu lanụ; l'ekfukota okfu-alị lanụ; bya awata ome iphe-a. Ẹ to nwekwa iphe, ẹphe chịru idzu ememe, ẹphe ẹ-te meghedu. ");
INSERT INTO iqw_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Unu t'ayi nyizita je akpakaa okfu ẹphe; t'ẹ b'ọ dụhe onye a-nọdu anụkwadu iphe ibe iya ekfu.” ");
INSERT INTO iqw_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","To du iya bụ; Ojejoje abya achịkashia ẹphe; ẹphe edzuru mgboko; paru ọkpu mkpụkpu ono haa. ");
INSERT INTO iqw_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ọ bụ iya kparu iphe e gude kua ẹke ono Babẹlu; kẹ l'ọ bụ l'ẹke ono bẹ Ojejoje gbaghashịru ụnwu eliphe okfu; shi l'ẹke ono chịkashia ẹphe; ẹphe edzuru mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ọwaa eri Shemu: A nọleruphu afa ẹbo l'utso ono byatsuaru lẹ Shemu nọwaru ụkporo afa ise; Shemu abya amụa Afakusadu. ");
INSERT INTO iqw_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Yọ mụtsua Afakusadu; bya anọfua ụnu afa l'ụkporo afa ise. Ọ mụshikwaruphu ụnwegirima unwoke ọdo; mẹ ụnwegirima ụnwanyi ọdo tsobe Afakusadu. ");
INSERT INTO iqw_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Afakusadu abya anọo ụkporo afa l'afa iri ise; bya amụa Shela. ");
INSERT INTO iqw_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Yọ mụtsua Shela; bya anọfua ụnu afa l'afa ẹto. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Shela. ");
INSERT INTO iqw_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela abya anọo ụkporo afa l'afa iri; bya amụa Eba. ");
INSERT INTO iqw_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Yọ mụtsua Eba; bya anọfua ụnu afa l'afa ẹto. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Eba. ");
INSERT INTO iqw_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eba abya anọo ụkporo afa l'afa iri l'ẹno; bya amụa Pẹ́legu. ");
INSERT INTO iqw_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Yọ mụtsua Pẹ́legu; bya anọfua ụnu afa l'ụkporo afa l'afa iri. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Pẹ́legu. ");
INSERT INTO iqw_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pẹ́legu abya anọo ụkporo afa l'afa iri; bya amụa Rewu. ");
INSERT INTO iqw_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Yọ mụtsua Rewu; bya anọfua ụkporo afa iri l'afa tete. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Rewu. ");
INSERT INTO iqw_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rewu abya anọo ụkporo afa l'afa iri l'ẹbo; bya amụa Sérugu. ");
INSERT INTO iqw_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Yọ mụtsua Sérugu; bya anọfua ụkporo afa iri l'afa ẹsaa. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Sérugu. ");
INSERT INTO iqw_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sérugu abya anọo ụkporo afa l'afa iri; bya amụa Nahọ. ");
INSERT INTO iqw_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Yọ mụtsua Nahọ; bya anọfua ụkporo afa iri. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Nahọ. ");
INSERT INTO iqw_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahọ abya anọo ụkporo afa l'afa tete; bya amụa Téra. ");
INSERT INTO iqw_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Yọ mụtsua Téra; bya anọfua ụkporo afa ise l'afa iri lẹ tete. Ọ mụshikwaruphu ụnwegirima unwoke; mẹ ụnwegirima ụnwanyi ọdo tsobe Téra. ");
INSERT INTO iqw_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Téra abya anọo ụkporo afa ẹto l'afa iri; bya amụa Ébiramu; Nahọ; mẹ Háranu. ");
INSERT INTO iqw_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ọwaa eri Téra: Téra bụ iya mụru Ébiramu; Nahọ; mẹ Háranu. Háranu bụ iya mụru Lọ́tu. ");
INSERT INTO iqw_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Háranu bẹ nwụhuru nụ lẹ Úru l'alị Kalúdiya, bụ ẹke a mụru iya teke nna iya; mbụ Téra nọkwaduru ndzụ. ");
INSERT INTO iqw_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ébiramu yẹle Nahọ abya ajịko lụa nwanyi. Ẹpha nyee Ébiramu bụ Seráyi; ẹpha nyee kẹ Nahọ abụru Milika. Onye mụru Milika bụ Háranu. Yọ bụkwaruphu Háranu ono mụru Isuka. ");
INSERT INTO iqw_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ọphu Seráyi amụtadu nwa; kẹ l'ẹ tọo tsụdu ime. ");
INSERT INTO iqw_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ya ndono; Téra eduta nwatibe iya, bụ Ébiramu; dutakwaphu Lọ́tu, bụ nwanwa iya. Lọ́tu ono bụ nwatibe Háranu. O dutakwaruphu Seráyi, bụ nyee-nwa iya; mbụ nyee Ébiramu. Ẹphe ajịko shi lẹ Úru lẹ Kalúdiya jeshia Kénanu. Obenu l'ẹphe ruru Háranu bukwaduaruphu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Téra anọlephu ụkporo afa iri l'afa ise; nwụhu lẹ Háranu. ");
INSERT INTO iqw_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Tọ dụ iya bụ; Ojejoje asụ Ébiramu: “T'ọ haa mkpụkpu iya; haa ndibe ẹphe; haa ndu ufu ẹphe; lashia alị, yẹbe Ojejoje e-koshi iya. ");
INSERT INTO iqw_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ya e-me ngu; nggu abụru mba, ha nshinu. Ya a-gọru ngu ọnu; mee t'ẹpha ngu dee ude. Nggu abụru ọnu-ọma nụ ndu ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ndu gọru ngu ọnu; bẹ ya a-gọru ọnu. Ndu tụru ngu ọnu; bẹ ya a-tụ ọnu. Ya e-gude okfu ẹhu ngu gọoru ndiphe mgburumgburu ọnu.” ");
INSERT INTO iqw_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tọ dụ iya bụ; Ébiramu atụgbua ẹge Ojejoje kfuru iya. Lọ́tu etsoru iya. Teke ono, Ébiramu shi Háranu tụgbua ono b'ọ nọwaru ụkporo afa ẹto l'afa iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tọ dụ iya bụ; Ébiramu achịko ẹku, ẹphe kpataru l'ọ ha gwota; duta nyee ya, bụ Seráyi; duta Lọ́tu, bụ nwa nwunne iya; mẹ ndu, ẹphe shi lẹ Háranu gude. Ẹphe atụgbua; yọ bụru ẹphe ọla alị Kénanu. Ẹphe ejee jeye ẹphe ejerua ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ébiramu phẹ etsoru alị ono kwasẹru gbururu jeye; ẹphe erua ẹke eze oshi More gvuru lẹ mgboro Shékemu. Teke ono bẹ ndu Kénanu bukwadu l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ojejoje abyakfuta Ébiramu bya asụ iya: “Ọ kwa eri ngu bẹ ya a-nụkota alị-a.” Ébiramu abya akpụaru Ojejoje, ono byakfutaru iya nụ ono ẹnya-ngwẹja l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ébiramu phẹ eshi l'ẹke ono tụgbua kwasẹru ụzo ẹnyanwu-ahata ugvu Bẹ́telu; je atụa ụlo-ẹ́kwà ẹphe l'ụzo ẹnyanwu-arịba Bẹ́telu; l'ibya kẹ ẹnyanwu-ahata Eyayi. Ébiramu erua ẹke ono bya akpụaru Ojejoje ẹnya-ngwẹja; nọdu l'ẹke ono kpọ-kua ya. ");
INSERT INTO iqw_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tọ dụ iya bụ; Ébiramu atụgbua chebe ifu l'ụzo echi-ẹgu ọhuda. ");
INSERT INTO iqw_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tọ dụ iya bụ; ẹjo-ẹgu awata ememe l'alị ono; Ébiramu phẹ alashia Íjiputu t'ẹphe je ebutota; kẹ l'ẹgu ono ajawa madzụ agba l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ẹphe abahụdelephu Íjiputu; Ébiramu asụ nyee ya, bụ Seráyi: “Ya makwarụa l'ị bụ nwanyi, manụkaru mma. ");
INSERT INTO iqw_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ndu Íjiputu -phụa ngu bẹ ẹphe a-sụkwa l'ị bụ nyee ya. Ẹphe eshi ẹge ono woru iya gbua; haa ngu t'ị nọdu. ");
INSERT INTO iqw_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sụjekwa lẹ nggu l'iya bụ nwunne; k'ọphu ẹphe e-gude okfu ẹhu ngu meeru iya ọhuma; nggu eshikwaphu ẹge ono mee t'ishi iya kpọ-kfuru.” ");
INSERT INTO iqw_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ébiramu phẹ abya erua Íjiputu; ndu Íjiputu aphụa lẹ Seráyi bụ nwanyi, manụkaru mma. ");
INSERT INTO iqw_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ndu bụ ishi l'ọchichi Fero aphụlephu Seráyi; je atụaru Fero ọnu iya. A bya eduta iya lashia kẹ Fero. ");
INSERT INTO iqw_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fero egude okfu ẹhu Seráyi meeru Ébiramu ọhuma: kpẹe ya atụru; kpẹe ya eswi; kpẹkwaa ya phụ nkakfụ-ịgara: oke lẹ nyee; bya eduru unwoke yẹle ụnwanyi, a-nọdu ejeru iya ozi nụ iya. Ọ kpẹkwaru iya phụ ịnya-ivu. ");
INSERT INTO iqw_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Obenu lẹ Ojejoje byaru bya alọru ẹjo iphe-ememe tụ Fero yẹle ndibe iya; okfu l'o dutaru nyee Ébiramu, bụ Seráyi. ");
INSERT INTO iqw_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ya ndono; Fero abya ekua Ébiramu; sụ iya: “?Nanụ ẹge ọ dụ b'i meru iya egbe iya ọwaa? ?Bụ ngụnu b'ẹ tị kadụru iya l'ọo nyee ngu? ");
INSERT INTO iqw_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","?Nanụ ẹge ọ dụ b'ị sụru l'ọo nwunne ngu nwanyi; nggu ahaa; ya eduta iya tẹ ya je alụa ya? Ọwaa nyee ngu! Duta iya tụgbua!” ");
INSERT INTO iqw_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fero atụa iwu tẹ ndu ozi iya chịfu Ébiramu. Ẹphe abya achịfu yẹle nyee ya; mẹ iphemiphe ọbule, o nweru. ");
INSERT INTO iqw_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ya ndono; Ébiramu yẹle nyee ya eshi lẹ Íjiputu chịta iphemiphe ọbule, ẹphe nweru; yọ bụru ẹphe ọla echi-ẹgu ọhuda. Lọ́tu etsoru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Teke ono bẹ Ébiramu bụwa eze madzụ l'elu; mkpọla-ọcha; mẹ mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ẹphe eshi l'echi-ẹgu ọhuda ono kwasẹru: ẹphe -shi l'ibyiya ọwaa; ẹphe alụfu l'ibyiya ọphu jeye ẹphe ejerua Bẹ́telu l'ẹke ono, ọ kpọbejehawaru ụlo-ẹ́kwà iya lẹ mgbaku Bẹ́telu yẹle Eyayi ono. ");
INSERT INTO iqw_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ọ bụ l'ẹke ono bẹ Ébiramu vuru ụzo kpụa ẹnya-ngwẹja. Yọ nọdu l'ẹke ono kpọ-kua Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ya ndono; Lọ́tu-wa yẹle Ébiramu yị-wa bẹ nwekwaruphu atụru l'igwe; mẹ eswi; mẹ ụlo-ẹ́kwà. ");
INSERT INTO iqw_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yo mee; alị ono te dzuhe ẹphe ẹbo; kẹ l'elu ẹphe hatabe l'uru; k'ọphu bụ l'ẹphe ta anọkota-ghehedu l'ẹkalanu. ");
INSERT INTO iqw_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ya ndono; okfu awata ọdaru ndu echeru Ébiramu elu; ẹphe lẹ ndu ọphu echeru Lọ́tu nk'iya. Teke ono bẹ ndu Kénanu ẹphe lẹ ndu Pẹ́rezu shikwaphu buru l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","A nọnyaa; Ébiramu asụ Lọ́tu: “T'okfu ba adashịnuru nggu l'iya; ọphu ọ daru ndu echeru ngu atụru yẹle ndu echeru yẹbedua nk'iya; kẹ lẹ nggu l'iya bụkwa ndu ọnu-ụlo lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","?Tọ bụdu alị daburu ngu ẹge-a l'ifu. T'ayi nọkahunu anọkahu; t'ayi bẹ akwọkfuhenuru l'ẹkalanu ẹge-a. Hatakpẹlephu ẹkiya ọphu ịi-la je eburu. Ọ -bụru l'ịi-la l'ẹka-ibyita; yẹbedua alaa l'ẹka-ụtara. Teke bụ l'ị laru l'ẹka-ụtara; yẹbedua alaa l'ẹka-ibyita.” ");
INSERT INTO iqw_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lọ́tu apalia ẹnya bya aphụ l'ọkpa-ugvu Jọ́danu, nọru je kpaa lẹ Zówa bẹ mini nọkota ọhuma. Yọ dụlephu l'ọbu mgbabu Ojejoje; dụkwaphu l'ọbu alị Íjiputu. Teke ono bẹ Ojejoje te emebyidua Sódomu mẹ Gọmóra. ");
INSERT INTO iqw_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tọ du iya bụ; Lọ́tu egude ẹka iya hata ọkpa ugvu Jọ́danu kpamukpamu; bya egwota lashia ụzo ẹnyanwu-ahata. Yọ bụru iya bụ lẹ yẹle Ébiramu ebukahu: ");
INSERT INTO iqw_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ébiramu eburu l'alị Kénanu; Lọ́tu eje eburu lẹ mkpụkpu lanụ lẹ mkpụkpu, nọtsua l'ọkpa ugvu ono; woru ụlo-ẹ́kwà iya kpọbe lẹ mgboro Sódomu. ");
INSERT INTO iqw_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ndu Sódomu bụ ndu, teru iphe, dụ ẹji ote uswe; bụru ndu menukaru ẹjo iphe l'ẹke Ojejoje nọ. ");
INSERT INTO iqw_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ya ndono; Lọ́tu alụfutsulephu; Ojejoje asụ Ébiramu: “Palia ẹnya lee l'ụzo isheli; mẹ l'ụzo ọhuda; mẹ l'ụzo ẹnyanwu-ahata; mẹ l'ụzo ẹnyanwu-arịba. ");
INSERT INTO iqw_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Alị ono, ị phụru ono bẹ yẹbe Ojejoje a-nụkota nggu l'awa ngu t'unu nweru jeye lẹ tutu yoyo. ");
INSERT INTO iqw_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ya e-me awa ngu t'ẹphe ha l'igwe l'ọ bụ ẹja, nọ l'alị; k'ọphu bụ l'ọo onye dụru ike gụta ẹja, nọ l'alị bẹ a-dụ ike gụta awa ngu. ");
INSERT INTO iqw_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Gbeshi; tsophekota alị ono maru ẹge ogologo iya ha; nggu amakwarụphu ẹge ụsa iya ha; kẹle ya a-nụkota ngu iya.” ");
INSERT INTO iqw_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tọ dụ iya bụ; Ébiramu ekwe bya afọta ụlo-ẹ́kwà nk'iya tụgbua je eburu l'iku ọswa Mamure l'iku Hẹ́buronu. Yọ nọdu l'ẹke ono kpụaru Ojejoje ẹnya-ngwẹja. ");
INSERT INTO iqw_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Yọ bụru teke ono bẹ Amurafẹlu, bụ eze ndu Shịna; chịtaru ndu eze ndu ọdo; ẹphe ejeshia ọgu. Ndu eze ndu ọphu bụ Arịyoku, bụ eze ndu Elasa; Kedolawoma, bụ eze ndu Élamu; mẹ Tidalu, bụ eze ndu Goyimu. ");
INSERT INTO iqw_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ndu ẹphe jeru je etso ọgu bụ: Bera, bụ eze ndu Sódomu; Bisha, bụ eze ndu Gọmóra; Shinabu, bụ eze ndu Adama; Sheméba, bụ eze ndu Zeboyimu; ọwaa eze ndu Béla, bụkwa iya phụ bẹ eekuje Zówa. ");
INSERT INTO iqw_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ndu eze k'ikperazụ-wa abya edzukoo chịta ndibe ẹphe jeshia ọgu lẹ nsụda Sidimu, bụ iya megeeru bụru Eze Ẹnyimu Únú. ");
INSERT INTO iqw_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Iphe, kparu ọgu ono bụ l'ẹphe nọru Kedolawoma l'ẹka afa iri l'ẹbo. Yo be l'afa k'iri l'ẹto ya; ẹphe ekwefu íkè l'ẹphe ta nọhedu ẹphe l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yo rua l'afa k'iri l'ẹno; Kedolawoma yẹle ndu eze ono, wụ-kfutaru iya nụ ono eje anọdu lẹ Ashịterotu Kanayimu lụ-gbua ndu Réfa; nọdu lẹ Hamu lụ-gbua ndu Zuzu; je anọdukwaphu lẹ Shave Kiriyatayimu lụ-gbua ndu Emimu. ");
INSERT INTO iqw_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ẹphe abya eje anọdu l'alị ugvu Séyi lụ-gbua ndu Họru; lụa ẹphe je akpaa lẹ Ẹlu-Paranu, nọ l'iku echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ẹphe alatashia azụ bya eje anọdu lẹ Ẹnu-Mishupatu, bụ iya bụ Kadẹ́shi; lụtakota alị ndu Amalẹku kpamukpamu; bya emekputa ndu Amọru, bu lẹ Hazazọnu Táma. ");
INSERT INTO iqw_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tọ dụ iya bụ; eze ndu Sódomu; eze ndu Gọmóra; eze ndu Adama; eze ndu Zeboyimu; mẹfua eze ndu Béla, bụ iya bụ Zówa; awụfuta bya eje akwaa k'ọgu lẹ nsụda Sidimu. ");
INSERT INTO iqw_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ndu ẹphe kwabẹru abụru Kedolawoma, bụ eze ndu Élamu; Tidalu, bụ eze ndu Goyimu; Amurafẹlu, bụ eze ndu Shịna; ọwaa Arịyoku, bụ eze ndu Elasa. Ẹphe adụ ndu eze ẹno l'etso ndu eze ise ọgu. ");
INSERT INTO iqw_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nsụda Sidimu ono bẹ iduma iduma, ẹpoto korota hatsụa nshinu. Yo be teke ndu eze Sódomu mẹ Gọmóra ono; ẹphe lẹ ndibe ẹphe jederu t'ẹphe gbalaa; ụphodu ẹphe adalashịhu l'iduma ono. Ndu ọphu phọduru nụ agbaru laa l'ugvu ugvu je anọdu. ");
INSERT INTO iqw_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ndu eze ẹno ono abya ajịko ẹku ndu Sódomu mẹ kẹ ndu Gọmóra; mẹ nri ẹphe gwoo tụgbua. ");
INSERT INTO iqw_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ẹphe kpụtakwaruphu Lọ́tu, bụ nwa nwunne Ébiramu; gwoo ẹku iya; keshinu ọphu o bu lẹ Sódomu. ");
INSERT INTO iqw_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Onye lanụ lẹ ndu ono, gbalaru nụ ono; abya ekfuaru iya Ébiramu, bụ onye Híburu. Ébiramu bu lẹ mgboro eze ọswa Mamure. Mamure bụkwanu onye Amọru; bụru nwunne Ẹshukolu mẹ Ana. Ndu ono bẹ ẹphe lẹ Ébiramu tụgbaru bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ébiramu anụlephu lẹ nwa nwunne iya b'a kpụtaru l'ọgu; yo kua ụkporo unwoke iri l'ise l'unwoke iri l'ẹsato, a mụshiru lẹ nk'iya, bụkwaruphu ndu e ziru ẹge aalụje ọgu; ẹphe achịpyabe ẹphe; gbakfu ẹphe lẹ Dánu. ");
INSERT INTO iqw_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Yo rua l'ẹnyashi; Ébiramu abya ekekashia unwoke ono ẹge ẹphe e-shi tso ndu ono ọgu. Ndu kẹ Ébiramu ono alụa ẹphe; chịa ẹphe gbururu jeye ẹphe agbarua Hoba, bụ isheli Damásukọsu. ");
INSERT INTO iqw_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yọ nakọta ẹphe ivu ono, ẹphe gworu ono; bya edulata Lọ́tu, bụ nwa nwunne iya yẹle ẹku kẹ yẹbe Lọ́tu; mẹ ụnwanyi; mẹwaru ndu ọdo, ẹphe kpụtaru. ");
INSERT INTO iqw_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ébiramu alụ-gbutsua Kedolawoma yẹle ndu eze ono, tso iya nụ ono bya alatashia; eze ndu Sódomu abya iya ndzuta lẹ Nsụda Shave, bụkwa iya phụ bẹ eekuje Nsụda Eze. ");
INSERT INTO iqw_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tọ dụ iya bụ; Melikízedeku, bụ eze ndu Salemu egude buredi; mẹ mẹe byakfuta ẹphe. Melikízedeku ono bụ onye achịjeru Nchileke, bụ Ọkaribe-Kakọta-Nụ ẹja. ");
INSERT INTO iqw_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yọ bya agọoru Ébiramu ọnu; sụ iya: “Tẹ Nchileke, bụ Ọkaribe-Kakọta-Nụ gọru ọnu-ọma nụ nggụbe Ébiramu; Mbụ Nchileke ọphu bụ iya meru igwe bya emee mgboko. ");
INSERT INTO iqw_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","T'e tua Nchileke, bụ Ọkaribe-Kakọta-Nụ ẹpha; Mbụ onye ono, woru ndu ọhogu ngu ye ngu l'ẹka ono!” Ébiramu eworu iphemiphe ọbule ono, ọ lụtaru l'ọgu ono kee ụzo iri; gworu ụzo lanụ nụ iya. ");
INSERT INTO iqw_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Eze Sódomu asụ Ébiramu t'ọ haaru iya ndu ọphu bụ madzụ; gwotawaru ọphu bụ ivu nworu. ");
INSERT INTO iqw_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ébiramu asụ eze ndu Sódomu: “Ya riakwaru Ojejoje angụ; mbụ Nchileke, bụ Ọkaribe-Kakọta-Nụ; onye meru igwe bya emee mgboko; ");
INSERT INTO iqw_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","l'ẹ tọ dụdu iphe, shi ngu l'ẹka ya a-nata; mbụ m'ọo eri owu; m'ọ kwanu eri akpọkpa; t'ẹ b'ọ dụ teke ịi-sụ l'ọo nggu meru yẹbe Ébiramu; ya abaa eze. ");
INSERT INTO iqw_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ẹ tọ dụkwa iphe, ya anata; gbahaa ọphu ndu ẹphe l'iya yị riwaru eriri; mẹ òkè ọphu ruberu Ana yẹle Ẹshukolu; mẹ Mamure. Tẹ ndu onanu hata òkè-iphe ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","E mebetsua; Ébiramu abya aphụa àphụ̀. L'àphụ̀ ono; bẹ Ojejoje sụru iya: “Ébiramu; ba atsụkwa egvu. Ọ bụ yẹbe Ojejoje bụ onye egbochitaje ngu nụ; bụru iya bụ obunggo ngu, ha nshinu.” ");
INSERT INTO iqw_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ébiramu asụ iya: “Nnajiufu, bụ Ojejoje; ?bụ ngụnu bẹ ịi-nụ iya, ka nwa-a, ya ta mụtadu-a? ?Tọ bụdu Eliyéza-a, bụ onye Damásukọsu-a e-mekochaa ria ẹku iya?” ");
INSERT INTO iqw_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ébiramu asụkwaphu: “Keshinu ẹ tị nụdu iya nwa; bụnu l'ọo ohu ono, a mụru l'ufu iya ono e-mekochaa ria iphe iya.” ");
INSERT INTO iqw_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ojejoje asụ iya: “L'ẹ tọkwa onye ono e-ri iphe ngu. Onye e-ri iphe ngu kwa nwata nwoke ọphu shi nggụbedua l'ẹhu gẹdegede.” ");
INSERT INTO iqw_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yọ bya eduta iya lụfu etezi; sụ iya: “T'ọ palia ẹnya lee l'akpamigwe; yọ gụa mkpọ-kpodo, nọ iya nụ ọgu; m'ọ -bụru l'ọo-dụ ike gụkota iya.” Sụ iya: “Ono bụ ẹge awa iya a-ha.” ");
INSERT INTO iqw_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ébiramu ekweta iphe ono, Ojejoje kfuru ono. Yọ gụaru iya ẹya l'odobe-ẹka-ndo. ");
INSERT INTO iqw_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ojejoje asụkwa iya phụ: “Ọo yẹbe Ojejoje bẹ shi lẹ Úru l'alị Kalúdiya dufuta ngu tẹ ya bya anụ ngu alị-a t'ọ bụru nke ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ébiramu asụ iya: “Nnajiufu, bụ Ojejoje; ?nanụ ẹge ya e-shi maru l'alị ono a-bụ nk'iya?” ");
INSERT INTO iqw_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ojejoje asụ iya: “Kpụtaru iya ada eswi; mẹ ada eghu; mẹ ebyila, gbatsụaru afa ẹto ẹto; nggu eyekwa iya phụ ndo; ọwaa kparakobe.” ");
INSERT INTO iqw_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ébiramu ajịko iphe ono wotaru iya; bya atụkota iya ìbè. Yọ bya eworu ìbè iya ono doo; k'ọphu o chegbatsuaru onwiya ifu. Ndu ọphu bụ ụnwenu b'ẹ tọ tụdu ìbè. Ọ haru ẹphe ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yo be teke ụnwenu, erije anụ byaru t'ọ bya avụkaa anụ ono; Ébiramu achịkashia ya. ");
INSERT INTO iqw_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ẹnyanwu anyịhudelephu; oke mgbẹnya abya avọta Ébiramu. Ọchi, dụ egvu abya agbaa l'ẹke ono; k'ọphu bụ l'egvu iya gbe bya egude iya. ");
INSERT INTO iqw_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ojejoje asụ iya: “T'o doo ngu ẹnya ọhuma l'eri ngu e-mekochaa bụru mbyamụmbya l'alị, ẹ tabụdu nk'ẹphe. Ee-me ẹphe ohu; kpaa ẹphe ẹhu l'ẹke ono ụnu afa. ");
INSERT INTO iqw_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Obenu l'ọha ono, ẹphe e-jeru ozi l'ọ bụ ohu ono bẹ ya a-nụ aphụ. E -megelephu bẹ ẹphe e-vu ẹku, ha nshinu lata. ");
INSERT INTO iqw_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A -bya lẹ nggụbedua; ịi-ka nka; laa l'oge nka-ezekuna nke ngu l'ẹhu-gudangu. ");
INSERT INTO iqw_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","O -rua l'ọgbo k'ẹno bẹ eri ngu a-lata azụ l'ẹke-a; kẹ l'iphe, dụ ẹji, ndu Amọru eme te ebuhudua.” ");
INSERT INTO iqw_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yo rua l'ẹnyanwu nyịhutsuaru; ọchi abyawa; ite, a kpọberu ọku, akpọ tụtutu yẹle itsu-ọku, enwu phophopho abya eshijahu ìbè anụ ono ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Yọ bụru mbọku ono bẹ Ojejoje yẹle Ébiramu gbaru ndzụ. Yọ sụ Ébiramu: “Ọ bụ eri ngu bẹ ya nụru alị-a; tsube lẹ Ẹnyimu Íjiputu jeye lẹ Ẹnyimu Yufurétusu. ");
INSERT INTO iqw_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Mbụ alị ndu Kenu; kẹ ndu Kenazu; kẹ ndu Kadumọnu; ");
INSERT INTO iqw_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kẹ ndu Hetu; kẹ ndu Pẹ́rezu; kẹ ndu Réfa; ");
INSERT INTO iqw_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kẹ ndu Amọru; kẹ ndu Kénanu; ọwaa kẹ ndu Gigashi; mẹ kẹ ndu Jebusu.” ");
INSERT INTO iqw_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Seráyi, bụ nyee Ébiramu ta mụtaduru iya nwa. Ọ bụ lẹ Seráyi nwekwanuru nwamgbọko Íjiputu, ọ gbaru ohu. Ẹpha nwamgbọko ono bụ Héga. ");
INSERT INTO iqw_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ya ndono; Seráyi asụ Ébiramu: “Ẹge Ojejoje mewaru; ya ta mụta nwa; bẹ nggu l'ohu iya-a a-zẹkwa t'a maru; ?ya e-shi iya l'ẹka nweru ụnwegirima?” Ébiramu ekweta iphe, Seráyi kfuru. ");
INSERT INTO iqw_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ébiramu buwaru afa iri lẹ Kénanu teke Seráyi, bụ nyee ya dutaru nwamgbọko Íjiputu ono, bụ ohu iya ono dee ya t'ọ lụru. ");
INSERT INTO iqw_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ébiramu yẹle Héga abya azẹe; yọ tsụta ime. Yọ malẹruphu lẹ ya dụwa ime; to nwehe iphe ọ gụbekwaduru nnufu iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Seráyi asụ Ébiramu: “Iphe-ẹhuka-wa, ya eje-wa kwa nggu b'o shi l'ẹka. Ya dutaru ohu iya dee ngu. Yọ malẹruphu lẹ ya dụwa ime; to nwehe iphe ọ gụbekwaduru iya. Ọ kwa Ojejoje e-kpe ikpe ẹhu nggu l'iya.” ");
INSERT INTO iqw_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ébiramu asụ Seráyi: “Ohu ngu ono kwa nggu b'ọ nọ l'ẹka. Ọ kwa ẹge dụ ngu mma; nggu emee ya.” Ya ndono; Seráyi awata ọkpo Héga mkpọnwu; k'ọphu bụ l'a nọnyaaru; Héga akwata gbalaa. ");
INSERT INTO iqw_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tọ dụ iya bụ; ojozi Ojejoje aphụa Héga l'iku ọgba-mini, nọ l'echi-ẹgu. Ọgba ono, nọ l'ụzo, shiru jee Shu. ");
INSERT INTO iqw_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yọ bya eku iya: “Héga; nggụbe ohu Seráyi; ?bụ awe b'i shi? ?Bụkwanu awe b'i je?” Héga asụ iya: “Lẹ ya agbalaru nnufu iya; Seráyi.” ");
INSERT INTO iqw_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ya ndono; ojozi ono asụ iya: “Laphu azụ lakfu nnufu ngu. Nggu ewozita onwongu alị meje iphe, ọ sụru t'i mee.” ");
INSERT INTO iqw_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ojozi ono asụkwa iya phụ: “Lẹ ya e-me tẹ awa iya ha l'igwe; k'ọphu ẹphe a-bụru 'agụta agụta.” ");
INSERT INTO iqw_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ojozi Ojejoje ono asụ iya: “Ị dụkwa ime; iphe ịi-mụ abụru nwata nwoke. Iphe, ịi-gụ iya bụ ‘Ishimẹlu’; kẹle Ojejoje nụwaru ẹkwa, ịira t'a gbaaru ngu mkpu. ");
INSERT INTO iqw_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ọo-bụru nkakfụ-ịgara ọswa; l'etso onyemonye ọbule okfu; onyemonye ọbule l'etsokwa iya phụ okfu. Yẹle unwunne iya e-buru lẹ mgba-l'ọgu.” ");
INSERT INTO iqw_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yo woru ẹpha gụa Ojejoje, bụ onye ono, kfuru yeru iya ono. Iphe, ọ gụru iya bụ Ẹlu-Rọyi, bụ iya bụ “Nchileke, ẹnya iya dụ l'ẹke, ya nọ;” kẹle Héga sụkwanuru: “?Ya gbe phụwanu Nchileke; nọdukwadua ndzụ.” ");
INSERT INTO iqw_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ọo ya kparu iphe, a gụru wẹlu ono “Biye-Lahayi-Rọyi” Ọ nọ lẹ mgbaku Kadẹ́shi yẹle Beredu jeye nta-a. ");
INSERT INTO iqw_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ya ndono; Héga abya amụaru Ébiramu nwata nwoke. Ébiramu agụa nwata ono Ishimẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Iphe Ébiramu nọwaru teke Héga mụru iya Ishimẹlu bụ ụkporo afa ẹno l'afa ishingu. ");
INSERT INTO iqw_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ébiramu anọlephu ụkporo afa ẹno l'afa iri lẹ tete; Ojejoje abyakfuta iya bya asụ iya: “L'ọ kwa yẹbedua, bụ Nchileke bụ Ọkaribe-Kakọta-Ike. Tsoje iya t'ụta ba dụ lẹ ndzụ ngu. ");
INSERT INTO iqw_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ya e-me tẹ ndzụ, nggu l'iya gbaru vuru ire. Ya emee ngu t'ị jàà ájaja ha l'igwe.” ");
INSERT INTO iqw_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ébiramu adaa kpube ifu l'alị; Nchileke asụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ndzụ ọwaa, nggu l'iya gbaru-wa bẹ bụwa nke ngu: ịi-bụru nna mba, ha l'igweligwe. ");
INSERT INTO iqw_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ẹpha ngu ta abụhedu Ébiramu. Ẹpha ngu bụwa Ébirihamu; kẹle ya mewaru ngu nna mba, dụ l'igweligwe. ");
INSERT INTO iqw_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ya e-me ngu t'ị zụa azụzu nshinu. Ya eshi l'eri ngu mee ọha, dụ iche l'iche; ndu eze eshikwaphu l'eri ngu lụfuta. ");
INSERT INTO iqw_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ya e-me ndzụ ono, nggu l'iya gbaru ono t'ọ bụru ọgba-ndzụ, a-nọ gbururu jeye lẹ gbururu. Ọgba-ndzụ ono a-bụru kẹ nggu l'iya; bụru k'ụnwu ngu l'ọgbo ọphu nọ l'ifu; k'ọphu ya a-bụru Nchileke ngu; bụru Nchileke k'ụnwu ngu ndu ọphu abya l'ụzo ifu. ");
INSERT INTO iqw_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Alị Kénanu l'ọ ha; mbụ ẹke ono, unu bụ mbyamụmbya nta-a ono bẹ ya a-nụ nggu l'eri ngu; t'ọ bụru òkè-iphe unu jeyewaru; yẹbedua abụru Nchileke ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nchileke asụ Ébirihamu: “A bya lẹ nggụbedua; dobekwa ọgba-ndzụ mu ono; nggụbedua; nggu l'ụnwu ngu ndu ọphu a-bya nụ l'ọgbo ọphu nọ l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ọwaa bụ iphe unu e-meje gude dobe ndzụ ono unu l'iya gbaru ono; nggụbedua mẹ l'ụnwu ngu ndu ọphu tso ngu l'azụ: Tẹ ndibe ngu ndu k'unwoke l'ẹphe ha bujekwa útsù. ");
INSERT INTO iqw_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nggụbedua l'onwongu e-bukwaphu útsù t'ọ bụru iphe-ọhubama, a-nọdu ekoshi ndzụ ono, nggu l'iya gbaru ono. ");
INSERT INTO iqw_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Iphe bụ nwata nwoke, a mụru lẹ nke ngu bẹ ee-bufutaje útsù; m'ọ -nọlephu abalị ẹsato. Iphe, bụ onye nwoke, nọ lẹ nke ngu b'e bufutaje útsù; m'ọ -bụ onye a mụru lẹ nke ngu; m'ọ -bụ onye ọhodo, ẹ-te shidu l'eri ngu, i gude okpoga zụta azụta; ");
INSERT INTO iqw_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","m'a mụru iya lẹ nke ngu; m'i gude okpoga ngu zụta iya; e bufutaje iya útsù. Ọgba-ndzụ kẹ yẹbe Nchileke ono, iphe-ọhubama iya nọ ngu l'ẹhu ono a-bụru ọgba-ndzụ, a-nọ gbururu jeye lẹ gbururu. ");
INSERT INTO iqw_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Iphe, bụ nwoke, bụ akpapyị; mbụ onye ẹ te budu útsù; t'e bufukwa iya ebufu; kẹ l'ọ dakawaru ọgba-ndzụ ono.” ");
INSERT INTO iqw_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nchileke asụkwaphu Ébirihamu: “A bya lẹ kẹ Seráyi, bụ nyee ngu; be ekujehekwa iya Seráyi. Ẹpha iya bụakwa Séra. ");
INSERT INTO iqw_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ya a-gọru ọnu-ọma nụ iya; mee ya t'ọ mụtaru ngu nwata nwoke. Ya a-gọru iya ọnu-ọma; mee ya t'ọ bụru nne, mụru ọha, dụ iche l'iche. Ya e-shikwa iya phụ l'ẹhu fọta ndu eze.” ");
INSERT INTO iqw_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ébirihamu adaa kpube ifu l'alị; chịa ọchi; sụ onwiya: “?Bụ yẹbe nwoke, nọwaru ụkporo afa ise bẹ aa-mụtaru nwa nta-a tọo? Tẹmanu; ?bụ Séra ọphu nọwaru ụkporo afa ẹno l'afa iri bẹ a-mụ-ghekwadu nwa?” ");
INSERT INTO iqw_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ébirihamu asụ Nchileke: “Byiko; tẹ Ishimẹlu nọdukpooru iya nụ ndzụ; ẹnya ngu anọdu l'ẹke ọ nọ!” ");
INSERT INTO iqw_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nchileke asụ: “Ọ dụa mma. Ọbule nyee ngu; mbụ Séra a-mụtaru ngu nwata nwoke. Iphe ịi-gụ iya bụ Áyizaku. Áyizaku ono; mẹ eri iya ndu ọphu etso iya l'azụ bẹ ẹphe l'iya a-gba ndzụ, a-nọ gbururu jeye lẹ gbururu. ");
INSERT INTO iqw_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ọ -bụru kẹ Ishimẹlu bẹ ya nụwaru iphe, i kfuru. Ya a-gọru ọnu-ọma nụ iya; mee ya t'ọ zụa bụru ọ-jaa-jagba-ẹgu; mbụ t'ọ zụa ịnyinwuru. Ọo-bụru nna ndu ishi iri l'ẹbo; ya emekwa ya phụ t'ọ bụru mba, ha nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Obenu l'ọ bụ lẹ Áyizaku bẹ ya a-kpọbe ọgba-ndzụ iya ono; mbụ onye Séra a-mụtaru ngu egbe nta afa ọdo.” ");
INSERT INTO iqw_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Nchileke ekfuebetsuaru Ébirihamu iphe ono; paru iya haa tụgbua. ");
INSERT INTO iqw_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mbọku ono gẹdegede bẹ Ébirihamu dutaru nwatibe iya kẹ nwoke; mbụ Ishimẹlu; ndu ohu ọdo, a mụshiru lẹ nk'iya; mẹ ndu ọphu o gude okpoga iya zụta azụta bushikota útsù. Iphe bụ unwoke, nọ lẹ nk'iya b'o bukotaru útsù, bụ iya bụ ẹge Nchileke sụru t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ébirihamu nọwaru ụkporo afa ẹno l'afa iri lẹ tete b'o buderu útsù. ");
INSERT INTO iqw_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Nwatibe iya; mbụ Ishimẹlu bẹ gbaru afa iri l'ẹto; bua nkiya. ");
INSERT INTO iqw_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ọ bụ ujiku lanụ ono b'e buru Ébirihamu yẹle nwatibe iya, bụ Ishimẹlu útsù. ");
INSERT INTO iqw_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Unwoke, bukota lẹ kẹ Ébirihamu l'ẹphe ha: ndu ọphu a mụru amụmu lẹ nk'iya; mẹ ndu ọphu a zụtaru azụta l'ẹka ndu ọhodo; bẹ ẹphe l'iya jịko bukota útsù. ");
INSERT INTO iqw_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ya ndono; Ojejoje abya abyakfuta Ébirihamu lẹ mgboro ọswa Mamure; l'ẹke ọ nọ l'ọnu ụlo-ẹ́kwà iya l'echi oke-eswe. ");
INSERT INTO iqw_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ébirihamu apalia ẹnya phụa unwoke ẹto, vudonyabe iya nụ. Yọ phụlephu ẹphe; zilihu l'ọnu-ụzo iya gbakfushia ẹphe. Yọ gbakfu ẹphe bya ebyiaru ẹphe ikpere; ");
INSERT INTO iqw_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","sụ ẹphe: “Onye nwe mu nụ; ọ -bụru lẹ ya tụbaru ngu l'obu; be eswetakwa kẹ yẹbe nwozi ngu. ");
INSERT INTO iqw_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","T'e kutaru unu nwa mini t'unu kwọo ọkpa; tụta ume lẹ mkpuli oshi-a. ");
INSERT INTO iqw_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yẹbedua achọkwanuaru unu iphe t'unu ria; ẹge ike a-dụ unu t'unu jeshia iphe, unu eje; keshinu ọphu unu batawaru kẹ yẹbe nwozi unu.” Ẹphe asụ iya l'ẹge o kfuru dụa mma. ");
INSERT INTO iqw_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ébirihamu emewaphu ẹgwegwa bahushia lẹ ụlo-ẹ́kwà iya; jekfube Séra; je asụ iya: “Ngwaa; mee ẹgwegwa tụta ntụ iphe eegudeje eme buredi ogbonga ẹto; gwọo; gude mee buredi.” ");
INSERT INTO iqw_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Yọ bya agbaru jeshia l'ẹke eswi iya dọru; je afọta nwada eswi, dụ nwa pẹlepele; kpẹe nwozi iya. Yọ kpụta iya je egbua; bọkashia; woru iya shia. ");
INSERT INTO iqw_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yọ bya apata ẹra eswi yẹle manụ, e gude ẹra eswi mee; mẹ anụ nwada eswi ono doberu ẹphe. L'ẹphe wataru ori nri ono; b'ọ byaru bya evudonyabe ẹphe lẹ mkpuli oshi ono. ");
INSERT INTO iqw_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ẹphe ajị Ébiriham ẹke nyee ya nọ. Yọ sụ ẹphe l'ọ nọkwa lẹ ụlo-ẹ́kwà phụ l'ẹkaphu. ");
INSERT INTO iqw_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ojejoje asụ iya: “L'egbe nta-a akele; bẹ ya a-lata azụ; nyee ngu; mbụ Séra amụa nwata nwoke.” Séra bẹ nọ l'ọnu-ụzo ụlo-ẹ́kwà ono, Ojejoje gharu azụ ono gebe nchị. ");
INSERT INTO iqw_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ébirihamu yẹle Séra bẹ kahụwaru nụ; ọgurenya ẹphe ahatsụwa nshinu; k'ọphu bụ lẹ Séra ta aphụjehedu nsọ iya. ");
INSERT INTO iqw_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Séra egude obu iya tụ-kpee ọchi; sụ: “?Bụ nta-a lẹ ya kahụtsuaru; nnajiufu iya akahụkwaphu ẹge-a bẹ ọo-lakwadụru iya l'ụlo ọdo.” ");
INSERT INTO iqw_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ojejoje asụ Ébirihamu: “?Bụ ngụnu kparu iphe Séra chịru ọchi; l'ajị ẹge ya e-shikwadu mụta nwa nta-a, ya kahụwaru ẹge-a? ");
INSERT INTO iqw_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","?O nweru iphe, akpọje Ojejoje ẹka? Ya a-laphuta azụ l'ògè teke ono, ya tụru ono l'akele; teke ono bẹ Séra a-mụ nwata nwoke.” ");
INSERT INTO iqw_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Séra egude ọtsu egvu; tụa ẹgo lẹ ya ta chịdu ọchi. Nchileke asụ iya l'ọ chịrua ọchi. ");
INSERT INTO iqw_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Unwoke ono aladẹlephu; chebe ifu l'ụzo Sódomu. Ébirihamu etsoru ẹphe t'o duribe ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ojejoje asụ: “?Nanụ ẹge ya e-shi domiaru Ébirihamu iphe, ya abya ememe edomi; ");
INSERT INTO iqw_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","keshinu Ébirihamu e-mekochaa bụru eze mba; bụru l'ẹka iya bẹ ya e-shi gọoru iphe bụ mbakeshi lẹ mgboko-a ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ya fọtawaru iya t'ọ bụru onye a-kpọ-ziru ụnwu iya ụzo; yẹle ndibe iya ndu ọphu etso iya l'azụ; t'ẹphe tsoru ụzo kẹ yẹbe Ojejoje, bụ iya bụ t'ẹphe meje iphe, vudo nhamụnha; mẹ iphe, gbaru ẹphe; k'ọphu yẹbe Ojejoje e-mekwanuru Ébirihamu iphe, ya kweru iya ụkwa iya.” ");
INSERT INTO iqw_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","To dụ iya bụ; Ojejoje asụ: “Lẹ mkpu, e chiwaru kpua ya l'okfu ẹhu ndu Sódomu mẹ Gọmóra bẹ hawa nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ya ejewa tẹ ya je amaru: Ẹjo iphe, ẹphe eme; ?ọ dụ-tabe ẹji ẹge aatụ ọnu iya? Teke ẹ tọ dụdu; ya amakwarụphu.” ");
INSERT INTO iqw_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Unwoke ono aghachi kwasẹru ụzo Sódomu. Obenu lẹ Ébirihamu vudophu Ojejoje l'ifu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ébirihamu abya akpịrita iya ntse; sụ iya: “?Ii-gbukobe ndu doberu ẹka ndoo; ẹphe lẹ ndu eme iphe, dụ ẹji tọo? ");
INSERT INTO iqw_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ọ -bụru lẹ ndu doberu ẹka ndoo ruru ụkporo ụmadzu ẹbo l'ụmadzu iri lẹ mkpụkpu ono; ?ii-mebyishikwa iya phụ tọo? ?Tii gudedu okfu ẹhu ụkporo madzụ ẹbo l'ụmadzu iri ọphu doberu ẹka ndoo, nọ iya nụ phụ haa ẹphe? ");
INSERT INTO iqw_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tụsweka; ba ejekwa ome iphe, dụ ẹge ono; mbụ kẹ t'i gbua ndu doberu ẹka ndoo; ẹphe lẹ ndu ẹjo madzụ; m'ọ bụ t'i mee ndu doberu ẹka ndoo ẹge i meru ndu eme iphe, dụ ẹji. Tẹ ẹjo nrọ kwakwaa lẹ maa! Nggụbe Onye Ikpe kẹ mgboko-a e-menu iphe, vudo nhamụnha.” ");
INSERT INTO iqw_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ojejoje asụ: “Ọ -bụru lẹ ya phụru ụkporo madzụ ẹbo l'ụmadzu iri, bụ ndu doberu ẹka ndoo lẹ Sódomu bẹ ya e-gudekwa-a okfu ẹhu ẹphe haa mkpụkpu ono l'ọha.” ");
INSERT INTO iqw_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ébirihamu ekfukwaaphu ọdo; sụ: “Ọwaa ya bya azịgabe k'okfu l'anụ nggụbe Nnajiufu; lẹ yẹbe onye ẹ-ta dụdu iphe ọdo, ya bụ; gbahaa udzu-ẹja; mẹ ntụ-a; ");
INSERT INTO iqw_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ọ bụ; ?ọ -bụkwanuru lẹ ndu ono te rudu ụkporo madzụ ẹbo l'ụmadzu ire; mbụ ọ -bụru l'ẹphe phọduru ụmadzu ise; t'ẹphe rua ẹge ono eghe-e?” Ojejoje asụ iya: “Ya -phụa ụkporo madzụ ẹbo l'ụmadzu ise l'ẹke ono bẹ ya te emebyikwa iya.” ");
INSERT INTO iqw_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ébirihamu abyakwa bya ajị iya ọdo; sụ: “?Ọ -bụkwanuru ụkporo madzụ ẹbo damu b'a phụru eghe-e?” Ojejoje asụ iya: “Lẹ ya e-gudekwa-a okfu ẹhu ụkporo madzụ ẹbo ono haa ya ememe.” ");
INSERT INTO iqw_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ébirihamu asụ iya: “Nnajiufu byiko; t'ẹhu be ejekwa ngu oghu eghughu; tẹ ya kfufukwaaru ọdo. ?Ọ -bụkwanuru ụkporo madzụ l'ụmadzu iri b'a phụru l'ẹke ono eghe-e?” Ojejoje asụ: “L'ẹ ya te emebyikwa iya mẹ ya phụa ụkporo madzụ l'ụmadzu iri l'ẹke ono.” ");
INSERT INTO iqw_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ébirihamu asụ: “Keshinu ọphu ya gbe kerebewanu k'okfu anụ Nnajiufu; ?ọ -bụkwanuru l'ọo ụkporo madzụ b'a phụru l'ẹke ono eghe-e?” Ojejoje asụ iya: “Lẹ ya e-gude okfu ẹhu ụkporo madzụ ono haa ya emebyi.” ");
INSERT INTO iqw_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ébirihamu asụ iya: “Nnajiufu byiko; t'ẹhu be ejekwa ngu oghu eghughu; tẹ ya kfufukwaa kẹ nwugbo lanụ-a: ?Ọ -bụkwanuru l'ọo ụmadzu iri nwẹnkinyi b'a phụru l'ẹke ono eghe-e?” Ojejoje asụ iya: “Lẹ ya e-gudekwa-a okfu ẹhu madzụ iri ono haa ya emebyi.” ");
INSERT INTO iqw_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ojejoje yẹle Ébirihamu ekfugetsulephu; yọ tụgbua; Ébirihamu alashia ufu. ");
INSERT INTO iqw_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yo be l'urẹnyashi teke ụnwu ojozi labụ ono jeruru Sódomu; Lọ́tu anọduwa l'obu-edukfu mkpụkpu ono. Yọ phụlephu ẹphe; gbakfube ẹphe; bya ebyia ikpere; kpuberu ẹphe ifu l'alị; ");
INSERT INTO iqw_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","sụ ẹphe: “Ndu nwe mu nụ; ya arọ unu t'unu bataru lẹ kẹ yẹbe nwozi unu; bya akwọo ọkpa; unu aradu. O -rua l'oswi ụtsu; unu atụgbuwaru jeshia iphe, unu eje.” Ẹphe asụ iya: “Wawa; l'ẹphe a-radụa l'edukfu.” ");
INSERT INTO iqw_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yọ rọnyaa ẹphe; ẹphe ekwe tsoru iya bahụ nk'iya. Yọ bya akwaaru ẹphe ẹbyee, ha nshinu; gheeru ẹphe buredi, e te yedu iphe, ekoje buredi; ẹphe ataa. ");
INSERT INTO iqw_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ẹphe abyadẹ ọla l'ụlo; unwoke ndu Sódomu: nwata mẹ ọgurenya eshi l'ẹke, dụ l'iche l'iche bya agbaa ụlo ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ẹphe abya ekua Lọ́tu; jịa ya ẹke unwoke ono, bataru nk'iya l'urẹnyashi ono nọ. Wo iya t'o je edufuta ẹphe t'ẹphe l'ẹphe zẹe! ");
INSERT INTO iqw_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lọ́tu abya alụfu etezi; woru ụzo gụ-chia jekfushia ẹphe; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Ndu mu; unu be emebukwaa egbe akpamara ọwaa! ");
INSERT INTO iqw_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Unu lekwa; lẹ ya nwekwaru ụnwu-mgbọko labụ, ẹphe lẹ nwoke ta azẹbua. Tẹ ya dufutachiaru unu ẹphebedua; t'unu mee ẹphe ẹge dụ unu mma. Ọ -bụru k'unwoke ọwaa; unu be ebyikwa ẹphe ẹka; kẹ l'ẹphe kabẹkwa byaru iya ẹbyee.” ");
INSERT INTO iqw_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ẹphe asụ iya t'ọ kpịriberu ẹphe l'ụzo. Wo iya: “?Bụ nggụbedua, bụ mbyamubya-a; gbe emewa nụ t'ị tụru ẹphe ọnu iphe, ẹphe a-nọdu eme tọo.” Wo iya t'ọ kpịribekwaru ẹphe l'ụzo; ọdumeka bẹ ẹphe e-mekwa iya iphe ka ọphu ẹphe g'e-me ndu ọphu. Ẹphe enwube Lọ́tu ẹka ikike; l'enwu iya t'ẹphe gbakpọfu ibo ono. ");
INSERT INTO iqw_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Unwoke labụ ono amachịwaphu ẹka lọbata Lọ́tu l'ụlo; woru ibo ono gụ-chia. ");
INSERT INTO iqw_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ẹphe emee; iphe bụ ndu ono, vudokota l'ọnu ibo ono atsụlahaa ìshì: nwata mẹ ọgurenya; k'ọphu ẹphe ta phụhedu ọnu ibo ono. ");
INSERT INTO iqw_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Unwoke labụ ono ajị Lọ́tu: “?O nweru ndu ọdo, i nweru l'ẹke-a? ?O nweru ndu i keru nwanyi; ụnwu ngu ndu k'unwoke; ndu kẹ ụnwanyi; m'ọ kwanu ndu ọdo, bu lẹ mkpụkpu-wa, nggu l'ẹphe bụ abụbu. Tụkokwa ẹphe dufuta; ");
INSERT INTO iqw_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","l'ẹphe abyakwa omebyi ẹke-a. Lẹ mkpu, eechi anụ Ojejoje lẹ k'iphe, dụ ẹji ndu ẹke-a eme haakwa nshinu; k'ọphu o ziru ẹphe t'ẹphe bya emebyishia ya.” ");
INSERT INTO iqw_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tọ dụ iya bụ; Lọ́tu atụgbua je ekfutsuaru iya ndu abya ọlu ụnwu iya; sụ ẹphe: “Unu mekwaa ẹgwegwa lụfu lẹ mkpụkpu-a; kẹle Ojejoje abyaakwa iya emebyishi.” Obenu lẹ ndu ọgo iya ono gbe rịle-ẹ l'ọo ụja bẹ ọobo. ");
INSERT INTO iqw_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Yo be lẹ gẹrigeri nchi-abọhu; ojozi ono achịshilahaa Lọ́tu ọku; sụ iya: “T'o mee ẹgwegwa duta nyee ya; mẹ ụnwu-mgbọko ono ẹphe ẹbo lụfu. Ọdumeka bẹ unu l'unu ha a-bụkwaru kpurupyata teke aa-nụ mkpụkpu-a aphụ.” ");
INSERT INTO iqw_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lọ́tu ejeshia ome mgbụgbu; unwoke ono akpụta iya l'ẹka; kpụta nyee ya; mẹ ụnwu-mgbọko ẹbo phụ; kpụfu lẹ mkpụkpu ono; kẹle Ojejoje aphụru ẹphe imiko. ");
INSERT INTO iqw_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ẹphe alụfutatsulephu; onye lanụ asụ ẹphe t'ẹphe gbakwaa ọso ndzụ ẹphe! T'ẹphe ba aghakwa ẹnya l'azụ; ọphu ẹphe ejekwa ovudo evudo l'oghẹgu! T'ẹphe gbakwaru latsụa l'ugvu! Ọdumeka bẹ ẹphe a-bụkwaru kpurupyata! ");
INSERT INTO iqw_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lọ́tu asụ ẹphe: “Wawakwa; ndu nwe mu nụ! ");
INSERT INTO iqw_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Keshinu ọphu yẹbe nwozi unu tụbaru unu l'obu; unu ekoshiwa l'unu yeru iya obu; dzọwa iya ndzụ; bẹ ya ta agbaghekwa ala l'ugvu: kẹ l'ẹjo iphe-ẹhuka-a a-byakfutakwa iya; bya egbua ya. ");
INSERT INTO iqw_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Unu lekwa mkpụkpu phụ, nọ l'ẹkaphu. Ẹ to tekwa ẹnya; tọ ba nwishi. Tẹ ya gbanụru laa l'ẹke ono ẹge ndzụ e-dzua ya rụ.” ");
INSERT INTO iqw_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nwoke ono asụ iya: “L'ọ dụa mma. Lẹ ya te emebyishidu mkpụkpu ono, ookfu okfu iya ono; ");
INSERT INTO iqw_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ọ bụphu t'ọ gbachịlekwaphu lashia ya. L'ẹ to nwekwa iphe, ya eje ememe jeye teke ọ gbaruru ẹke ono.” Ọ bụ okfu lẹ Lọ́tu kfuru lẹ mkpụkpu ono ha nwanshị; meru iphe aawataru oku mkpụkpu ono Zówa. ");
INSERT INTO iqw_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lọ́tu abya eru Zówa; ẹnyanwu-ahata-wa. ");
INSERT INTO iqw_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tọ dụ iya bụ; Ojejoje eshi l'imigwe chịa ọku nshị-egbe ọchi mini lẹ Sódomu mẹ Gọmóra. ");
INSERT INTO iqw_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yọ bụru ẹge ono b'o gude mebyishikota mkpụkpu ono; mẹ iphe, bụ nsụda, nọ iya nụ; mẹ iphe bụ ndu bu iya nụ; jeyekpo l'iphe bụ iphe, futaru efuta l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ya ndono; nyee Lọ́tu eje eworu ẹnya ghaa l'azụ; ghọo únú; gvuru l'ọ bụ itso. ");
INSERT INTO iqw_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Yo be l'ọnma-ẹwa ụtsu echile iya; Ébirihamu egbeshi lashia azụ l'eke, o shi nọduhawa Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Yọ nọdu l'ẹke ono lee ẹnya l'ụzo Sódomu mẹ Gọmóra; lekota ẹnya l'ụzo ọkpa ugvu ono. Iphe ọ phụru abụleruphu ẹnwuru-ọku, akpọ tụtutu l'ọ bụ ọ-tata-kfukfu ọku. ");
INSERT INTO iqw_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Obenu lẹ teke ono, Nchileke mebyishiru mkpụkpu, nọkota l'ụzo nsụda ono; b'ọ nyataru-a Ébirihamu; bya edufuta Lọ́tu l'ẹke ono, o shi buru teke ono, o gude ụmuruku bya ekpoo mkpụkpu ono okpo-ntụ ono. ");
INSERT INTO iqw_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","A nọnyaa; Lọ́tu awata ọtsu egvu lẹ Zówa. Yo kwe tụgbua yẹle ụnwegirima ụnwanyi iya ono ẹphe ẹbo; je eburu l'ime ọgba. ");
INSERT INTO iqw_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yo be ujiku lanụ; onye k'ọgurenya l'ụnwegirima ono asụ onye kẹ nwata: “Lẹ nna ẹphe bụakwa ọgurenya; tọ bụ l'o nweru nwoke, nọ l'uswe iya ọwaa gbaa mgburumgburu, ẹphe l'iya a-zẹ, bụ ẹge emejekpo ya lẹ mgboko, gba mgburumgburu.” ");
INSERT INTO iqw_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Wo iya t'ẹphe chee nna ẹphe ono mẹe. Teke o gudeleru iya phụ; ẹphe eje t'ẹphe l'iya zẹe; k'ọphu ẹphe e-shi ẹge ono mụta nwa t'ẹphe be ribuhu. ");
INSERT INTO iqw_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Yo be l'ẹnyashi iya; ẹphe abya echee nna ẹphe ono mẹe; yo gude iya. Onye k'ọgurenya ejekfushia ya yẹle iya azẹe. Ọphu nna iya ono amadụ teke ọ byaru bya azẹnyabe iya; tọ ma teke o gbeshiru. ");
INSERT INTO iqw_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yo be echile iya; onye k'ọgurenya phụ asụ onye kẹ nwata: “Lẹ yẹle nna ẹphe zẹkwaru l'ẹnyashi. T'ẹphe chefukwaa ya phu mẹe l'ẹnyashi-a; nggu eje tẹ nggu l'iya zẹe; k'ọphu ẹphe e-shi ẹge ono mụta nwa; t'ẹphe be ribuhu.” ");
INSERT INTO iqw_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ẹphe eworu mẹe chee nna ẹphe ono l'ẹnyashi ono; yo gude iya. Onye kẹ nwata ejekfu iya yẹle iya azẹe. Ọphu nna iya ono amadụ teke ọ byaru bya azẹnyabe iya; tọ ma teke o gbeshiru. ");
INSERT INTO iqw_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tọ dụ iya bụ lẹ Lọ́tu eyee ụnwegirima iya ono ime; ẹphe ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Onye k'ọgurenya abya amụa nwata nwoke; gụa ya Móabu. Yọ bụru Móabu ono bụ iphe, metaru ndu Móabu ntanụ. ");
INSERT INTO iqw_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Onye kẹ nwata abya amụkwaaphu nwata nwoke; gụa ya Benu-Amị. Yọ bụru Benu-Amị bụ iphe, metaru ndu Amọnu ntanụ. ");
INSERT INTO iqw_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ébirihamu eshi l'ẹke ono tụgbua shia ụzo ọhuda; je eburu lẹ mgbaku Kadẹ́shi yẹle Shu. Yọ nọnyaa tụgbua je ebutota lẹ Géra. ");
INSERT INTO iqw_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yọ bụru l'ẹke ono bẹ Ébirihamu nọ sụ lẹ nyee ya; mbụ Séra bụ nwunne iya. Abímẹleku, bụ eze ndu Géra ezia; e je edutaru iya Séra. ");
INSERT INTO iqw_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Yo be l'ẹnyashi; Nchileke abyakfutashia Abímẹleku lẹ nrọ; bya asụ iya: “L'ị bụakwa maa. Ishi iya abụru nwanyi ono, i dutaru ono. Nwanyi ono kwa nyee madzụ.” ");
INSERT INTO iqw_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Obenu lẹ Abyímẹleku yẹle nwanyi ono ta zẹdua. Tọ dụ iya bụ; Abímẹleku asụ iya: “Nnajiufu; ?ii-gbu ndu, ẹ-te nwedu iphe, ẹphe meru tọo? ");
INSERT INTO iqw_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","?Mẹ Ébirihamu sụkwaru iya lẹ nwanyi ono bụ nwunne iya. Nwanyi l'onwiya asụkwa iya phụ lẹ nwoke ono bụ nwunne iya? Iphe-a bẹ ya te lebezikwa ẹnya mee; tọ bụ lẹ ya meru iya tẹ ya mebata madzụ.” ");
INSERT INTO iqw_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nchileke asụ iya lẹ nrọ ono: “L'ọ bụ oswi-okfu l'ẹ to lebezidu ẹnya mee ya. L'ọo ya kparu iphe, ya meru t'ẹ b'o meswe yẹbe Nchileke; mbụ tẹ yẹle nwanyi ono ba azẹshi. ");
INSERT INTO iqw_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngwaa; dulaaru nwoke ono nyee ya; kẹle nwoke ono bụkwa onye nkfuchiru Nchileke. L'oo-kfurua nụ yẹbe Nchileke l'okfu ẹhu kẹ nggụbe Abyímẹleku tẹ ndzụ dzua ngu. Teke ẹ ti duladuru iya ẹya; makwaru amaru lẹ nggu lẹ ndibe ngu bụakwa maa.” ");
INSERT INTO iqw_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yo be l'ọnmewa ụtsu; Abímẹleku abya ekukoo ndu ozi iya l'ẹphe ha; woru nrọ ono zeeru ẹphe. Ẹphe anụle ya phụ; egvu erua ẹphe l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abímẹleku abya ekua Ébirihamu; sụ iya: “?Bụ egbe ngụnu? ?Bụ awe bẹ ya mesweru ngu, meru iphe i wotaru iphe, dụ ẹji ọphu ha ẹge-a bya ebobe yẹle ndu alị iya? I mekwaru iya iphe ta dụdu kẹ t'i mee ya ẹya!” ");
INSERT INTO iqw_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abímẹleku abya ajị Ébirihamu; sụ iya: “?Bụ ngụnu kpakpọoru iphe, i meru iphe ono?” ");
INSERT INTO iqw_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ébirihamu asụ iya lẹ ya rịru lẹ keshinu ẹ to nwedu ndu atsụ Nchileke egvu, bu l'ẹke-a bẹ ẹphe e-gbu iya l'okfu ẹhu nyee ya. ");
INSERT INTO iqw_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ọdo abụkpooru nụ lẹ nwanyi ono kwa nwanna iya gẹdegede. Ọ kwa nna lanụ mụru yẹle iya; ọbule ẹphe te shidu lẹ nne lanụ; ya alụkwanuru iya. ");
INSERT INTO iqw_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yo be teke Nchileke meru tẹ mu gbeshi l'ufu nna mu wata ọgha-phe ẹge-a; mu asụ nyee mu ono l'ẹge oo-gude koshi lẹ ya yeru mu obu bụ tẹ ọosuje lẹ mu l'iya bụ nwunne iphe bụ ẹke, ayi jejeru. ");
INSERT INTO iqw_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abímẹleku abya ahata atụru iya; mẹ eswi iya nụ Ébirihamu; bya ahatakwaphu ndu ohu iya: ndu k'unwoke mẹ ndu k'ụnwanyi yeru iya ẹya; metsua bya edulataru iya nyee ya, bụ Séra. ");
INSERT INTO iqw_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Yọ bya asụ Ébirihamu l'ọ bụ yẹbe Abímẹleku bẹ nwekota alị ono, oole ẹnya ono. T'o je ahata ẹke, dụ iya mma buru. ");
INSERT INTO iqw_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Yọ bya asụ Séra lẹ ya nụakwaru nwunne ngu ụnu mkpọla-ọcha labụ l'ụkporo mkpọla-ọcha iri. Ono iphe, ya gude asụ ngu paru haa l'ifu ndu unu l'ẹphe yị l'emeswe, e mesweru ngu. L'iswi dụkotakwa ngu mma. ");
INSERT INTO iqw_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Tọ dụ iya bụ; Ébirihamu abya ekfuru nụ Nchileke; Nchileke abya emee Abímẹleku; mẹ nyee ya; mẹ ụnwanyi ndu ọphu bụ ohu iya; ẹphe awata ọmu nwa ọdo; ");
INSERT INTO iqw_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kẹle Ojejoje shi mee; iphe bụ unyomu Abímẹleku l'ẹphe ha ekekotaru ekeru l'okfu ẹhu nyee Ébirihamu; mbụ Séra. ");
INSERT INTO iqw_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ojejoje abya emeeru Séra ẹge o kfuru; bya emeeru iya ẹge o kweru iya ụkwa iya. ");
INSERT INTO iqw_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Séra abya atsụta ime; mụaru Ébirihamu nwata nwoke lẹ nka; l'ògè teke ono, Nchileke kweru iya ụkwa iya ono gẹdegede. ");
INSERT INTO iqw_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ébirihamu agụa nwata ono, Séra mụru iya ono Áyizaku. ");
INSERT INTO iqw_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Áyizaku anọlephu abalị ẹsato; Ébirihamu ebua ya útsù, bụ iya bụ ẹge Nchileke sụru t'o meje iya. ");
INSERT INTO iqw_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iphe Ébirihamu nọru b'a mụderu iya Áyizaku bụ ụkporo afa ise. ");
INSERT INTO iqw_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Séra asụ: “Lẹ Nchileke meekwaru tẹ ya mụa ọnu-ọchi. Ọ kwaphụ ẹge ono bẹ iphe, bụ onye nụru iya nụ e-tsokwaru iya phụ mụa ọnu-ọchi.” ");
INSERT INTO iqw_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Yọ sụkwaphu: “?Bụ onye photajeru Ébirihamu lẹ ya e-mekochaa chee nwa ẹra? Ya egbe byalẹ bya amụtaru iya nwata nwoke lẹ nka.” ");
INSERT INTO iqw_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nwata ono abya evua; a mịfu iya ọnu l'ẹra. Mbọku ono, a mịfuru iya ọnu l'ẹra ono; bẹ Ébirihamu gbaru ajị, dụ egvu. ");
INSERT INTO iqw_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Séra abya aphụa lẹ nwata nwoke ono, Héga, bụ nwanyi Íjiputu mụtaru Ébirihamu ono ajalahaa Áyizaku ewena; ");
INSERT INTO iqw_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","sụ Ébirihamu: “Chịfukwa nwanyi ohu-wa yẹle nwa iya; kẹle nwatibe nwanyi ohu-a yẹle nwatibe nk'iya; mbụ Áyizaku ta agbakwaru mgba l'iphe ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Iphe ono atsụa Ébirihamu l'ẹhu nshinu; kẹle ọ bụ okfu ẹhu nwatibe iya b'e ekfu. ");
INSERT INTO iqw_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Obenu lẹ Nchileke sụru iya: “Tẹ kẹ nwata ono yẹle nwanyi ono, bụ ohu ngu ono ba atsụkwa ngu l'ẹhu. Mekwaa iphe, Séra kfuru ngu; kẹ l'ọ bụ lẹ Áyizaku bẹ awa ngu e-shi jaa. ");
INSERT INTO iqw_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ya e-mekwaphu nwatibe kẹ nwanyi ohu phụ t'ọ bụru mba k'ẹka iya; kẹ l'ọ bụkwaphu nwatibe ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yo rua l'ọnma-ẹwa ụtsu echile iya; Ébirihamu ewota nri; kuru mini ye l'ẹda-akpọ, eeyeje mini woru nụ Héga; bya eworu iya dẹe ya l'ukuvu; chịfu iya yẹle nwata ono. Ẹphe atụgbua je etsoru echi-ẹgu Besheba ghaphelahaa. ");
INSERT INTO iqw_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mini, nọ l'ẹda-akpọ ono agvụlephu; yọ tọgbo nwata ono lẹ mkpuli iru lanụ l'ẹke ono; ");
INSERT INTO iqw_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","tụgbua je anọdu iche l'iku ẹke ono; l'ẹke bụ a -gbaa akfụ; yo jerua ya; kẹ l'o kpeburu lẹ ya ta anọdudu ele nwata ono ẹnya t'ọ nwụhu. Yo kpọ-kfuru l'iku ẹke ono; wata ọra ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nchileke anụa nwata ono ẹkwa. Ojozi Nchileke anọdu l'imigwe kua Héga; sụ iya: “?Bụ ngụnu Héga? Ba atsụshi egvu; kẹle Nchileke nụwaru olu nwata ono l'ẹke ono, ọ zẹ l'ara ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Gbeshi; je ekulia nwata ono; heta; kẹle ya e-me iya t'ọ bụru mba, ha nshinu.” ");
INSERT INTO iqw_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nchileke abya emee; ẹnya asahụ Héga. Yọ phụa wẹlu, mini nọ; je ekujia mini l'ẹda-akpọ ono; bya echebe nwata ono. ");
INSERT INTO iqw_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nchileke echee nwata ono jeye yo vufuta. Yo bua l'echi-ẹgu ono ghọo ọ-ka-ibe l'ọgba akfụ. ");
INSERT INTO iqw_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yọ bụru l'echi-ẹgu Paranu b'o bu; nne iya eje alụaru iya nwanyi lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Abímẹleku yẹle Fịkolu, bụ onye ishi ndu sọja iya asụ Ébirihamu lẹ mgbaku ono: “Lẹ Nchileke nọkwa swiru ngu eswiru l'iphemiphe ọbule, iime ememe. ");
INSERT INTO iqw_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Rinuaru yẹbe Abyímẹleku angụ l'ifu Nchileke l'ẹke-a l'ẹ to nwedu l'ị gbaaru iya ẹregede; yẹbedua yẹle ụnwegirima iya; mẹ ndu awa iya l'ẹphe ha. Ọ bụchia t'i koshi l'i yeru iya obu; bya eyeru mkpụkpu-a obu; mbụ mkpụkpu-a, ị byaru abyabya-a; ẹge ono, ya koshiru lẹ ya yeru ngu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ébirihamu ekweta lẹ ya e-ri-a nte ono. ");
INSERT INTO iqw_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ébirihamu abya echia Abímẹleku ichi kẹ wẹlu, ndu ozi Abyímẹleku nataru iya. ");
INSERT INTO iqw_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abímẹleku asụ iya: “Lẹ ya ta makwa onye meru iya nụ; ọphu i kfubukwaaru iya ẹya. Ọ kwa ntanụ ọwaa bẹ ya bebe anụ iya.” ");
INSERT INTO iqw_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tọ dụ iya bụ; Ébirihamu akpụta atụru yẹle eswi kpẹe Abímẹleku; ẹphe ẹbo ono abya agbaa ndzụ. ");
INSERT INTO iqw_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ébirihamu abya eshi l'igwe atụru iya fọta ada atụru ẹsaa dobe iche. ");
INSERT INTO iqw_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abímẹleku asụ Ébirihamu: “?Bụ ngụnu kparu iphe ị fọtaru ada atụru ẹsaa ono dobe iche?” ");
INSERT INTO iqw_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ébirihamu asụ iya t'ọ nata ada atụru ẹsaa ono t'ọ bụru iphe, a-nọdu agba ekebe l'ọ bụ iya tụru wẹlu-a. ");
INSERT INTO iqw_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tọ dụ iya bụ; e woru ẹke ono gụa Besheba; kẹ l'ẹke ono bụ ẹke unwoke ẹbo ono riru nte. ");
INSERT INTO iqw_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ẹphe agbatsulẹphu ndzụ ono lẹ Besheba; Abímẹleku; mẹ Fịkolu mbụ onye ishi ndu sọja iya alashia Filisutayịnu. ");
INSERT INTO iqw_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ébirihamu abya eworu oshi tamarisuku dzaa lẹ Besheba; nọdu l'ẹke ono kpọ-kua Ojejoje, bụ onye a-nọ jeye tutu yoyo. ");
INSERT INTO iqw_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ébirihamu ebua l'alị Filisutayịnu ụlori. ");
INSERT INTO iqw_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","A nọnyaa; Nchileke abya ahụ̀a Ébirihamu ama; kua ya: “Ébirihamu!” Ébirihamu aza iya. ");
INSERT INTO iqw_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Yọ sụ iya: “Duta nwatibe ngu ono, bụ Áyizaku; mbụ nwananụ ngu ono, i yeru obu ono gude je l'alị Moriya. Teke i ruru bẹ ya e-koshi ngu-a ugvu ẹke ịi-nọdu gude nwatibe ngu ono gwooru iya ngwẹja-ukfuru.” ");
INSERT INTO iqw_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yo be l'ọnma-ẹwa ụtsu echile iya; Ébirihamu enyikobe nkakfụ-ịgara iya; duta nwatibe iya ono; mbụ Áyizaku; duta ụmadzu labụ lẹ ndu ejeru iya ozi; yọ bụru ẹphe oje ẹke ono, Nchileke kfuru iya ono. Ọ watakwarụphu nkụ, oo-gude gwoo ngwẹja-ukfuru ono. ");
INSERT INTO iqw_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Yo be mbọku, kwe ẹphe ẹto l'ije ono; Ébirihamu ejenyaa bya apalia ẹnya; phụa ẹke ono l'ẹke teru ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yọ sụ ndu ozi iya ono t'ẹphe nọdukwa l'ẹke-a; ẹphe lẹ nkakfụ-ịgara ono; tẹ yẹle nwata-a jeribefua l'ẹkaphu je abaaru Ojejoje ẹja. Teke ẹphe metsuaru bẹ ẹphe a-lata-a azụ byakfuta ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ébirihamu apata nkụ ngwẹja-ukfuru ono bo nwatibe iya ono; mbụ Áyizaku. Yẹbedua egude ọku yẹle mma. Ẹphe ẹbo ayịru tụgbua. ");
INSERT INTO iqw_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ẹphe ejenyaa; Áyizaku eku iya: “Nna!” Yọ za iya. Áyizaku asụ iya: “Ọku bẹ nọwa nụ; nkụ anọdu. Ọ bụ; ?nanụhunu atụru, ee-gude gwoo ngwẹja-ukfuru ọbu?” ");
INSERT INTO iqw_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ébirihamu asụ iya: “Nwa mu; Nchileke a-nụ-a atụru, ee-gude gwoo ngwẹja-ukfuru ọbu.” Ẹphe ẹbo atụgbua; yọ bụru ẹphe ejeje. ");
INSERT INTO iqw_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ẹphe erua ẹke ono, Nchileke kfuru iya ono; Ébirihamu abya akpụa ẹnya-ngwẹja l'ẹke ono; bya eworu nkụ doo ya. Yọ bya ekee nwatibe iya ono; mbụ Áyizaku ẹgbu; pata iya tụ-kobe l'eli nkụ ono, edoru l'eli ẹnya-ngwẹja ono; ");
INSERT INTO iqw_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","bya amachịa ẹka; wota mma tẹ ya gbua nwatibe ya. ");
INSERT INTO iqw_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ojozi Ojejoje anọduwaphu l'imigwe kua ya; sụ iya: “Ébirihamu! Ébirihamu!” Yọ za iya. ");
INSERT INTO iqw_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yọ sụ iya: “Be byikwa nwata ono ẹka! Ba dụkwa iphe, ii-me iya. Nta-a bẹ ya mawaru l'ịitsu Nchileke egvu; kẹ l'i tii seladuru iya ẹka azụ l'ẹke nwatibe ngu ono nọ; mbụ nwananụ ngu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ébirihamu abya apalia ẹnya; phụa ebyila, mpo iya gbagaru l'iphe. Yo je akpụta ebyila ono gbua ọzori nwatibe iya ono gude gwoo ngwẹja-ukfuru ono. ");
INSERT INTO iqw_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ya ndono; Ébirihamu eworu ẹke ono gụa: “Ojejoje bụ Ọ-kwọ-lẹ-mkpa.” Gbururu jeye ntanụ ọwaa bẹ aasụje: “L'eli ugvu Ojejoje bẹ aa-kwọ ngu lẹ mkpa.” ");
INSERT INTO iqw_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ojozi Ojejoje anọdu l'imigwe kua Ébirihamu k'ugbo ẹbo; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Lẹ yẹbe Ojejoje gudeekwa onwiya ria angụ lẹ keshinu ọphu i du-gheru ike mee egbe iphe ọwaa; ti selaru iya ẹka azụ l'ẹke nwatibe ngu ono nọ; mbụ nwa-nanụ ngu ono; ");
INSERT INTO iqw_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","bẹ ya gọfutajeru ngu ọnu; mee t'awa ngu ha l'igwe l'ọ bụ mkpọ-kpodo, nọ l'igwe; ha l'ọ bụ eveve mgbogidi ẹnyimu. Awa ngu phẹ a-lụje ọgu lụta mkpụkpu ndu ọhogu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ọ bụ l'eri ngu bẹ ee-shi gọoru iphe bụ mbakeshi lẹ mgboko-a ọnu. Ishi iya abụru l'ị nụru yẹbe Ojejoje okfu.” ");
INSERT INTO iqw_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","E mebetsua; Ébirihamu yẹle Áyizaku ejekfushia ndu ozi iya ono; ẹphe ayịru lashia azụ lẹ Besheba. Ébirihamu ebuwaruru lẹ Besheba. ");
INSERT INTO iqw_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","A nọokwaru-o jeye; a bya ezia Ébirihamu lẹ Milika mụshiakwaru nwunne iya, bụ Nahọ ụnwegirima. ");
INSERT INTO iqw_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uzu bụ ọkpara. Buzu abụru nwunne iya nwoke yẹle Kemuwẹlu. Kemuwẹlu bụ iya bụ nna Áramu. ");
INSERT INTO iqw_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","A bya amụa Kẹsedu tsobe Kemuwẹlu; bya amụa Házọ; ọwaa Piludashu yẹle Jidulafu; mẹ Bétuwẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bétuwẹlu ono bụ yẹbedua bụ nna, mụru Ribéka. Yọ bụru ụnwegirima ẹsato ono bẹ Milika mụtaru Nahọ, bụ nwunne Ébirihamu. ");
INSERT INTO iqw_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nnufu iya ọphu aza Ruma bẹ mụtaru iya Teba; Gahamu; Tahashu; mẹ Maaka. ");
INSERT INTO iqw_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Séra nọru ụkporo afa ishingu l'afa ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ẹke ọ nọdu nwụhu bụ lẹ Kiriyatu Araba, bụ iya bụ Hẹ́buronu, nọ l'alị Kénanu. Ébirihamu agụa aphụ Séra; kwaa ẹkwa iya. ");
INSERT INTO iqw_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ébirihamu ahaa odzu nyee ya ono; jekfu ndu Hetu; je asụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Lẹ ya bụkwa mbyamụmbya, shi eshishi lakfuta unu l'ẹke-a. Byiko; unu renua ya alị; tẹ ya lia nyee ya-a.” ");
INSERT INTO iqw_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ndu Hetu asụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Onye nwe mu nụ; ẹphebe ndu Hetu sụru: L'ị kwa eze madzụ l'ẹphe. Hatalẹphu ili ndibe ayi ọphu katsụa ngu mma je elia nyee ngu. Ẹ to nwedu onye ndu-ẹphe, a-jịka sụ t'ẹ b'i lishi nyee ngu l'ili iya.” ");
INSERT INTO iqw_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ébirihamu egbeshi bya ebyiaru ndu alị ono, bụ iya bụ ndu Hetu ikpere; ");
INSERT INTO iqw_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","sụ ẹphe: “Ọ -bụru l'ọ dụ unu tẹ ya lia nyee ya bẹ ya ekfu t'unu rọoru iya Éfurọnu Zóha; ");
INSERT INTO iqw_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","t'o ree ya ọgba Makupela iya phụ, nọ l'ishi alị iya phụ. Iphe, bụ iphe ọ hụru iya ẹya bẹ ya a-kfụ iya l'ifu unu l'ẹke-a; t'ọ bụru ẹke ayi a-nọduje eli odzu.” ");
INSERT INTO iqw_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Éfurọnu ono, bụ onye Hetu ono bẹ yẹle ndu ndu-ẹphe jịkokwa-a nọdukota l'obu-edukfu mkpụkpu ono. Éfurọnu araa ya arara; k'ọphu ndu Hetu, nọ l'ẹke ono nụkotaru iya; sụ Ébirihamu: ");
INSERT INTO iqw_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Onye nwe mu nụ; wawakwa! Ya sụru lẹ ya nọ l'ifu ndu alị iya-a l'ekfu iya; sụ t'i nwekotaru alị ono l'ọ ha; nggu enworu ọgba ono, nọ iya nụ ono; lia nyee ngu!” ");
INSERT INTO iqw_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ébirihamu abya ebyiaru ndu alị ono ikpere; ");
INSERT INTO iqw_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","sụ Éfurọnu: “T'ọ ngabe nchị. Ya a-kfụ aswa alị ono. Nata iya rụ aswa iya; k'ọphu ya e-je elia nyee ya l'ẹke ono.” O kfuru iya; k'ọphu ndu alị ono nụkotaru iya. ");
INSERT INTO iqw_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Éfurọnu asụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Onye nwe mu nụ; alị ono dzukwaru ụnu mkpọla-ọcha. Ọlobu; ?bụ ngụnu b'ọ bụ l'ẹke nggu l'iya nọ? Jeru je elia nyee ngu l'ẹke ono.” ");
INSERT INTO iqw_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ébirihamu ekweta iphe, Éfurọnu hụru iya l'alị ono; bya eworu iya kfụa ya l'ifu ndu Hetu l'ẹke ono. Iphe, ọ kfụru iya bụ ụnu mkpọla-ọcha, bụ ẹra iphe, a tụtaru l'iphe, eegude ere aswa teke ono. ");
INSERT INTO iqw_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tọ dụ ya bụ; e woru alị Éfurọnu, nọ lẹ Makupela ree Ébirihamu. Makupela ọbu nọ l'ụzo ẹnyanwu-ahata Mamure. E reru iya alị ọbu yẹle ọgba, nọ iya nụ; mẹ iphe, bụ oshi, nọ iya nụ je akpaa l'ẹke oke iya jeberu. ");
INSERT INTO iqw_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Iphe, bụ ndu Hetu, nọ l'ọnu edukfu mkpụkpu ono aphụa teke e reru Ébirihamu alị ono t'ọ bụru alị iya. ");
INSERT INTO iqw_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E metsua; Ébirihamu elia nyee ya; mbụ Séra l'ọgba ono, nọ l'alị Makupela ono l'ụzo ẹnyanwu-ahata Mamure, bụ iya bụ Hẹ́buronu l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tọ dụ iya bụ lẹ ndu Hetu eworu alị ono yẹle ọgba, nọ iya nụ rekota Ébirihamu; yọ bụru alị iya ẹke ee-lije odzu. ");
INSERT INTO iqw_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nta-a bẹ Ébirihamu kahụwaru ọhuma; Ojejoje agọwaru iya ọnu l'iphemiphe ọbule. ");
INSERT INTO iqw_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Yọ bya ekua onye ọphu kage ọbu ọgurenya lẹ ndu ejeru iya ozi; mbụ onye ọphu elekotaru iya ẹnya l'iphemiphe ọbule, o nweru enweru; sụ iya: “Gude iya ẹka l'ụtakfu; ");
INSERT INTO iqw_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","gude ẹpha Ojejoje, bụ Nchileke k'imigwe; bụru Nchileke k'eliphe riaru iya angụ l'ẹ tịi lụduru nwatibe iya Áyizaku nwanyi lẹ Kénanu-a, ẹphe bu-a; ");
INSERT INTO iqw_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","mbụ l'ii-jechia l'alị yẹbe Ébirihamu; mbụ lẹ kẹ ndu abụbu iya gẹdegede je alụtaru nwatibe iya Áyizaku nwanyi.” ");
INSERT INTO iqw_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Nwozi iya ono ajị iya: “Ọ -bụkwanuru lẹ nwanyi ọbu te kwedu l'oo-tsoru iya lata ẹke-a; ?ya e-duta Áyizaku gude lashia l'alị ono, i shi ono tọo?” ");
INSERT INTO iqw_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ébirihamu asụ iya t'ẹ b'o dutakwa nwatibe iya laa ẹke ono ọdo! ");
INSERT INTO iqw_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“Lẹ Ojejoje, bụ Nchileke k'igwe, bụ onye dufutaru iya l'ufu nna iya; mẹ l'alị ẹke, a mụru iya; mbụ onye kfuru nụ iya; bya ekwee ya ụkwa; riru angụ yeru iya ẹya: ‘Lẹ awa iya bẹ ya a-nụ alị-a;’ Nchileke e-zi-a ojozi iya t'unu l'iya yịru; k'ọphu ịi-lụ-ghe nwanyi l'ẹke ono dulataru Áyizaku l'ẹke-a. ");
INSERT INTO iqw_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ọ -bụru lẹ nwanyi ọbu te ekwedu tsoru ngu; ẹvu ngu ẹvu ogu. Ọ bụphu t'ẹ b'i dukwa Áyizaku laa ẹke ono.” ");
INSERT INTO iqw_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tọ dụ iya bụ; nwozi ono abya egude nnajiufu iya ono mbụ Ébirihamu ẹka l'ụtakfu; riaru iya angụ l'okfu ono. ");
INSERT INTO iqw_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ya ndono; nwozi iya ono abya akpụta ịnya-ivu nnajiufu iya ono iri gude tụgbua; bya egwokwaaphu iphe ọdo, dụtsua mma, nnajiufu iya ono nụtsuaru iya gude; yọ bụru iya oje Mesopotémiya. Yo jerua bya abahụ lẹ ẹke Nahọ bu. ");
INSERT INTO iqw_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Yo rua; bya eruta ịnya-ivu ono jeshia l'iku wẹlu, nọ l'azụ mkpụkpu ono. Yo rua iku wẹlu ono; bya emee ya; yo byishikota ikpere; k'ọphu ọo-dụ ike nyizita. Teke ono bẹ bụwa urẹnyashi teke ụnwanyi awụfuje je oseta mini. ");
INSERT INTO iqw_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Onye ozi Ébirihamu ono abya ekfuru nụ Nchileke; sụ iya: “Ojejoje, bụ Nchileke kẹ nnajiufu iya Ébirihamu. Mekwaa t'ije iya-a nweru ishi ntanụ! Koshinu l'i yeru nnajiufu iya, bụ Ébirihamu obu! ");
INSERT INTO iqw_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mbụ; ọ kwa l'iku wẹlu-a bẹ ya nọ ẹge-a; ụnwu-mgbọko mkpụkpu-a awụ abya oseta mini. ");
INSERT INTO iqw_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Menua t'ụnwu-mgbọko ono onye ọphu ya sụru: ‘Byiko t'o zinua ite iya tẹ ya ngụta mini’; teke nwamgbọko ọbu kweru chebe iya mini ono; bya asụ lẹ ya e-chebefua ịnya-ivu iya mini; ya amaru l'ọo onye onanu b'ị fọtaru nwozi ngu, bụ Áyizaku. Ọ bụ iya e-me tẹ ya maru l'i yeruphu nnajiufu iya, bụ Ébirihamu obu.” ");
INSERT INTO iqw_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Yo gudekwadua ẹge ono ekfu anụ Nchileke; ọwaa bụ-wa Ribéka yẹle ite, o tukoberu l'ukuvu. Ribéka ono bụ nwatibe Bétuwẹlu. Betuwẹlu bụkwanu nwatibe Milika. Milika bụ nyee Nahọ. Nahọ abụru nwunne Ébirihamu. ");
INSERT INTO iqw_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nwamgbọko ono ama mma nshinu; bụru onye doberu onwiya ọ̀gà; kẹle ẹ to nwedu nwoke, chịkahujewaru iya ọkpa. Yọ bya eje lẹ wẹlu ono sejia mini l'ite iya gude lụfuta. ");
INSERT INTO iqw_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Onye ozi ono abya agbakfukebe iya; sụ iya: “Byiko t'o kenua ya nwa mini l'ite iya ono tẹ ya ngụa.” ");
INSERT INTO iqw_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ribéka asụ iya: “Onye nwe mu nụ; ngụta nụ iya!” Teke ono phụ; yọ pazitawaphu ite ono; paru iya l'ẹka; yọ ngụta iya. ");
INSERT INTO iqw_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Yo chebetsua ya mini ono; sụ iya: “Tẹ ya setafukwaaruphu ịnya-ivu iya t'ọ ngụa; k'ọphu oo-dzuru iya.” ");
INSERT INTO iqw_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Yọ bya awụfu-kebe mini l'ite iya ono ye l'ochi-eswi, nọ l'ẹke ono; bya agbaphu azụ lẹ wẹlu ono je esetafua mini ọdo. Yo see mini; jeye yo setakotaru ịnya-ivu ono mini, dzuru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Onye ozi ono anọdukpelephu nwandoo l'ege iya t'ọ maru: ?Bụ-a ya bẹ Ojejoje fọtaru iya ọbu? ");
INSERT INTO iqw_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ịnya-kamẹlu ono angụtsua mini ono; nwoke ono abya achịfuta echi-imi, e gude mkpọla-ododo, ere ire mee; mẹ mgbalẹka labụ, e gude mkpọla-ododo iri mee gbabẹ iya. ");
INSERT INTO iqw_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Yọ bya ajị Ribéka onye mụru iya nụ. Jị iya; ?m'o nweru ẹke ẹphe a-zẹ lẹ kẹ nna iya t'ẹphe je aradu l'ẹnyashi-a? ");
INSERT INTO iqw_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ribéka asụ iya lẹ ya kwa nwatibe Bétuwẹlu ọphu Milika mụtaru Nahọ; ");
INSERT INTO iqw_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","sụkwa iya phụ l'ẹphe nwekwaru ẹwu onyingu; mẹ k'ọkponku nshinu; nwekwaruphu ụlo, ẹphe a-zẹ l'ẹnyashi-a. ");
INSERT INTO iqw_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nwoke ono abya efozeta; baaru Ojejoje ẹja; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“T'ajaja bụru kẹ Ojejoje, bụ Nchileke nnajiufu mu Ébirihamu; mbụ Ojejoje ono, n-yemobu iya ẹ-ta agvụdu agvụgvu l'ẹke nnajiufu mu bụ Ébirihamu nọ. O koshiwaru l'ọ gbaru tẹ nnajiufu mu ono gude ire iya ẹka. A bya lẹ mbẹdua; Ojejoje duwaru mu; mu eruta lẹ k'abụbu nnajiufu mu.” ");
INSERT INTO iqw_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nwamgbọko ono agbaru lashia l'ụlo nne iya je atụko iphe ono l'ọ ha kọoru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribéka nweru nwunne iya kẹ nwoke, aza Lébanu. Lébanu agbachịwaphu jeshia nwoke ono ndzuta lẹ wẹlu ono; ");
INSERT INTO iqw_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","kẹ l'ọ phụru echi-imi phụ; mẹ mgbalẹka ono, Ribéka gba ono; bya anụkwaaphu iphe ono, ọ sụru lẹ nwoke ono kfuru iya ono. Yọ tụgbua jekfushia nwoke ono; rua; yo vudonyabewa ịnya-ivu iya l'iku wẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Lébanu asụ iya: “Bata abata; nggụbe onye Ojejoje gọru ọnu-ọma nụ! ?Nanụ ẹge ọ dụ b'i vudo ẹke-a? Ya doziakwaru ngu ụlo ẹke ịi-zẹ; dozikwaaphu ẹke ịnya-ivu ngu a-dọru.” ");
INSERT INTO iqw_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tọ dụ iya bụ; nwoke ono abya abahụ l'ụlo ọbu. Lébanu abya atọshia ịnya-ivu iya ono iphe, o vu; bya achịtaru ịnya-ivu ono l'ẹphe ha ẹwu onyingu; mẹ k'ọkponku; bya apataru yẹbedua; mẹ unwoke, yẹle iya yị mini t'ẹphe gude kwọo ọkpa. ");
INSERT INTO iqw_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","E mebetsua; a bya egwota nri doberu nwoke ono. Yọ sụ lẹ ya te erikwa nri jeye teke ya kfuodoru iphe, ya byaru. Lébanu asụ iya t'o kfuedu iphe ọbu! ");
INSERT INTO iqw_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yọ sụ Lébanu lẹ ya bụkwa nwozi Ébirihamu. ");
INSERT INTO iqw_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Lẹ Ojejoje mewaru nnajiufu iya ono iphe-ọma, dụ biribiri. Ọ bụwa onye nweru iphe nweshia ya ike. Ojejoje mewaru; yo nweru atụru; nweru eswi; nweru mkpọla-ọcha; mẹ mkpọla-ododo. Ọ nụkwaru iya phụ ndu ejeru iya ozi: unwoke l'ụnwanyi; b'ọ byakwarụphu bya anụshia ya ịnya-ivu; mẹ nkakfụ-ịgara. ");
INSERT INTO iqw_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Séra, bụ nyee nnajiufu mu; bẹ mụtaru iya nwata nwoke l'ishi ẹwo. Ébirihamu ewowaru iphemiphe ọbule, o nweru enweru nụkota nwata ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nnajiufu mu ono bẹ meru; mu eriaru iya angụ; lẹ mu ta alụduru nwatibe iya ono nwanyi Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","L'ọbu ndu ufu nna iya; mbụ l'ẹnya ufu ẹphe gẹdegede bẹ mu e-je alụaru nwatibe iya ono nwanyi. ");
INSERT INTO iqw_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mu ajị nnajiufu mu ono; sụ iya: ‘?Ọ -bụkwanuru lẹ nwanyi ọbu te ekwedu l'oo-tsoru mụbe nwozi ngu-a ala ẹke ono eghe?’ ");
INSERT INTO iqw_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Yọ sụ mu lẹ Ojejoje ono, bụ onye, ya abaru ẹja ono e-duru-a ojozi iya ye tẹ mu l'iya yịru; k'ọphu oo-me t'ije mu nweru ishi; k'ọphu mu a-lụkwanuru nwatibe iya nwanyi l'abụbu ẹphe; mbụ l'ẹnya ufu ẹphe gẹdegede. ");
INSERT INTO iqw_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Lẹ mu -jekpowaa l'ufu ẹphe; ndibe ẹphe te kwe bẹ ẹvu mu; bụakwa ẹvu ogu. ");
INSERT INTO iqw_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ya ndono; mu abya abyaruta lẹ wẹlu-a ntanụ; bya ekfuru Nchileke; sụ iya: ‘Nggụbe Ojejoje, bụ Nchileke nnajiufu mu Ébirihamu; ọ -bụru l'ọ dụ ngu mma; byiko menua tẹ ije-a, mu byaru-a nweru ishi. ");
INSERT INTO iqw_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nta-a bẹ mu vudowa l'iku wẹlu-wa; ọ -bụru l'o nweru nwamgbọko, byaru oseta mini; mu -sụ iya: “Byiko tẹ mu ngụtanu mini l'ite ngu ono;” ");
INSERT INTO iqw_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ọ -bụru l'o kwetaru chebe mu iya; bya asụ lẹ yẹbe nwamgbọko ono e-jekwa echebefua ịnya-ivu mu; t'onye ono bụkwaru onye nggụbe Ojejoje fọtaru nwatibe nnajiufu mu.’ ");
INSERT INTO iqw_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Mu egudekwadua ẹge ono ekfu anụ Nchileke l'ime obu; Ribéka l'abyawaphu yẹle ite, ọ dẹru l'ukuvu. Yọ bya ejeshia lẹ wẹlu ono je eseta mini. Mu asụ iya: ‘Byiko t'o chebe mu nụ mini.’ ");
INSERT INTO iqw_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Yọ pazitakebewaphu ite ono, ọ pa l'ukuvu ono; sụ mu tẹ mu ngụta iya; ẹge ya e-je esetakwaruphu ịnya-ivu mu t'ẹphe ngụa.” ");
INSERT INTO iqw_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mu ajị iya nwatibe onye ọ bụ. “Yọ sụ mu lẹ ya bụ nwatibe Bétuwẹlu Nahọ; onye ọphu Milika mụtaru iya.” “Mu abya eworu echi-imi ye iya l'imi; bya agbabẹ iya mgbalẹka. ");
INSERT INTO iqw_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mu abya efozeta; baaru Ojejoje ẹja; jaa Ojejoje, bụ Nchileke nnajiufu mu Ébirihamu ajaja; mbụ Ojejoje, bụ onye duru mu; mu eshia ụzo, dụ mma byaruta ẹke-a; bya aphụa nwata, bụ nwanwa nwunne nnajiufu mu, mu a-lụru nwatibe nnajiufu mu ono. ");
INSERT INTO iqw_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nta-a bụ: ọ -bụru l'unu e-koshi l'unu yeru nnajiufu mu obu; mbụ l'ọ gbaru t'e gude ire unu ẹka; unu kfua tẹ mu maru. Teke ẹ tọ dụdu; unu kfukwaa ya phụ tẹ mu maru ụzo ọphu mu e-shi iya.” ");
INSERT INTO iqw_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lébanu yẹle Bétuwẹlu asụ: “Ọ kwa Ojejoje bẹ iphe ọwaa shi l'ẹka; ?bụkwadu ngụnu ọdo bẹ ẹphe e-kfu? ");
INSERT INTO iqw_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ọwaa Ribéka ndọ-ọ; duta iya lashia t'o je alụru nwatibe nnajiufu ngu ọbu; keshinu ọphu ọ bụ ẹge Ojejoje sụru l'ọo-dụ ndono.” ");
INSERT INTO iqw_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Onye ozi Ébirihamu ono anụlephu ọnu, ẹphe yeru; byishi ikpere l'alị; baaru Ojejoje ẹja. ");
INSERT INTO iqw_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Yọ bya egwota ngwa, e gude mkpọla-ododo; mẹ mkpọla-ọcha mee chẹe Ribéka; chẹkwa ya phụ ẹkwa. Ọ nụtsukwaaruphu nwunne Ribéka kẹ nwoke; mẹ nne iya iphe, eretsua ire nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ọ bụ teke ono bẹ yẹle ndu ẹphe l'iya yị tụkoru bya eria nri; ngụa iphe. E metsua; ẹphe aradu l'ẹke ono mbọku ono. Yo be l'ụtsu; nwozi ono asụ t'ẹphe ha ya rụ tẹ ya laa lakfu nnajiufu iya. ");
INSERT INTO iqw_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nwunne Ribéka ono yẹle nne iya arọo ya t'ọ haa t'ẹphe lẹ Ribéka nọfukpoonu m'ọ bụ abalị iri; tẹmanu ẹphe ayịwaruru lashia. ");
INSERT INTO iqw_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yọ sụ ẹphe t'ẹphe be esedeshi iya; l'ẹke Ojejoje meekwaru ije iya; yo nweru ishi? Wo ẹphe t'ẹphe hanụa ya tẹ ya lakfu nnajiufu iya. ");
INSERT INTO iqw_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ẹphe asụ iya t'ẹphe kukpooduanu nwata jịedu iya; t'a maru iphe, oo-kfu. ");
INSERT INTO iqw_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ẹphe abya ekua Ribéka; jị iya: “?M'oo-tsoru nwoke-a tọo?” Yọ sụ ẹphe lẹ ya e-tsoru iya-a. ");
INSERT INTO iqw_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tọ dụ iya bụ; ẹphe abya eduru Ribéka nụ iya; mẹkwaphu nwanyi, bụ iya heru Ribéka teke ọ ha nwanshị. Onye ozi Ébirihamu ono; mẹ ndu yẹle iya yị eduta ẹphe lashia. ");
INSERT INTO iqw_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ẹphe abyadẹ alala; ndu nwe Ribéka agọoru iya ọnu; sụ iya: “Nwunne ayi nwanyi; zụkwaa azụzu bụru nne ụnukurunu! T'awa ngu lụjeekwa ọgu lụta mkpụkpu ndu ọhogu ẹphe!” ");
INSERT INTO iqw_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ya ndono; Ribéka yẹle ndu ozi iya akwakọbe bya enyihu ịnya-ivu ẹphe; tsoru nwozi Ébirihamu ono. Yo duta ẹphe; yọ bụru ẹphe alala. ");
INSERT INTO iqw_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Teke ono bẹ Áyizaku shiwa l'ụzo wẹlu Byiye-Lahayi-Rọyi bya; kẹ l'ẹke o bu ebubu bụ l'echi-ẹgu ụzo ọhuda. ");
INSERT INTO iqw_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Yo be l'urẹnyashi ujiku lanụ; Áyizaku ejeshia oghe-ẹgu tẹ ya je amachịa ukfu. Yọ bya ele ẹnya phụa ịnya-ivu, liberu l'abya. ");
INSERT INTO iqw_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribéka apalikwaaphụ ẹnya; phụ Áyizaku; bya eshi l'eli ịnya-ivu ono nyizita; ");
INSERT INTO iqw_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","jị nwozi ono: “Nwoke ono, shi l'ẹgu eje abya ono; ?bụ onye b'ọ bụ?” Onye ozi ono asụ iya l'ọ kwa nnajiufu iya. Ribéka achịtawaphu ụlari-ifu iya phụ-kpua onwiya ifu. ");
INSERT INTO iqw_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Onye ozi ono abya akọkotaru Áyizaku ẹge ya jeru iya. ");
INSERT INTO iqw_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Áyizaku eduta Ribéka duba l'ụlo-ẹ́kwà nne iya; mbụ Séra; yọ ghọwaphu nyee ya. Yo yeeru Ribéka obu nshinu. Yọ bụru iya bụ l'obu agọ-zita Áyizaku lẹ kẹ nne iya ono, nwụhuru nụ ono. ");
INSERT INTO iqw_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ya ndono; Ébirihamu abya alụa nwanyi ọdo, ẹpha iya bụ Ketúra. ");
INSERT INTO iqw_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketúra amụtaru iya Zimuranu; Jọkushanu; Medanu; Mídiya; Ishibaku; mẹ Shuwa. ");
INSERT INTO iqw_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jọkushanu bụ nna Sheba; mẹ Dedanu. Ndu bụ ndu eri Dedanu bụ ndu Ashuru; ndu Letushi; mẹ ndu Leyumu. ");
INSERT INTO iqw_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ụnwu Mídiya bụ Ifa; Ẹfa; Hanọku; Abída; mẹ Ẹludaa. Ẹphe l'ẹphe ha tụko bụru ụnwu Ketúra. ");
INSERT INTO iqw_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ébirihamu atụko iphe, bụ iphe o nweru enweru haaru Áyizaku. ");
INSERT INTO iqw_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Obenu lẹ teke ọ nọkwadua ndzụ b'ọ hataru iphe keeru ụnwegirima iya; ndu ọphu nnufu iya phẹ mụshiru iya. Yọ bya edufushia ụnwegirima ono je edobe l'ụzo ẹnyanwu-ahata t'ẹphe lẹ Áyizaku be ebushiru l'ẹkalanu. ");
INSERT INTO iqw_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iphe Ébirihamu nọru bụ ụkporo afa ẹsato l'afa iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ọ karu nka lịkpahu alịkpahu b'ọ nwụhuderu lakfu ndiche iya phẹ ");
INSERT INTO iqw_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yọ nwụhutsua ono; ụnwegirima iya; mbụ Áyizaku yẹle Ishimẹlu elia ya l'ọgba Makupela l'alị Éfurọnu Zóha, bụ onye Hetu. Ọgba Makupela nọ l'ụzo ẹnyanwu-ahata Mamure. ");
INSERT INTO iqw_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Alị ono bụ alị, Ébirihamu zụru ndu Hetu. Yọ bụru l'ẹke ono b'e liru Ébirihamu; mẹ nyee ya, bụ Séra. ");
INSERT INTO iqw_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ébirihamu anwụhutsulephu; Nchileke abya agọoru nwatibe iya; mbụ Áyizaku ọnu. Teke ono bẹ Áyizaku bu l'iku wẹlu Byiye-Lahayi-Rọyi. ");
INSERT INTO iqw_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ọwaa eri Ishimẹlu ọphu nwanyi Íjiputu; mbụ Héga, bụ ohu Séra mụtaru Ébirihamu: ");
INSERT INTO iqw_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ọwaa ụnwu Ishimẹlu l'ẹge e shi mụa ẹphe: Nebayọtu bụ ọkpara iya. Ndu ọphu etso iya nụ bụ Kéda; Adụbelu; Mibusamu; ");
INSERT INTO iqw_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima; Duma; Masa; ");
INSERT INTO iqw_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadu; Téma; Jeturu; Nafishi; ọwaa Kedema. ");
INSERT INTO iqw_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ẹphe l'ẹphe ha bụkota ụnwu Ishimẹlu; bụkotaru ishi l'ikfu ẹke ẹphe shi. Ọ bụ ẹpha ẹphe b'e gudetsua maru mkpụkpu; mẹ edukfu ẹke ẹphe butsua l'iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Iphe Ishimẹlu nọru bụ ụkporo afa ishingu l'afa iri l'ẹsaa b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Eri iya shilephu lẹ Havila bua jeye lẹ Shu lẹ mgboro oke onye lẹ Íjiputu; l'e gude eje Asiriya. Ẹphe l'ụnwu Ébirihamu ndu ọphu ta dụbua lẹ mma. ");
INSERT INTO iqw_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ọwaa eri Áyizaku Ébirihamu: Ébirihamu bụ iya bụ nna Áyizaku. ");
INSERT INTO iqw_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Iphe, Áyizaku gbaru bụ ụkporo afa labụ teke ọ lụru Ribéka, bụ nwatibe Bétuwẹlu. Ribéka ono bụ nwunne Lébanu. Ẹke ẹphe shi bụ Áramu lẹ Padanu Áramu. ");
INSERT INTO iqw_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Áyizaku abya ekfuru nụ Ojejoje l'okfu ẹhu nyee ya; kẹle o keru ekeru. Ojejoje anụa iphe ono, o kfuru iya ono; bya emee nyee ya; mbụ Ribéka; yọ tsụta ime. ");
INSERT INTO iqw_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ụnwegirima ono anọdu iya l'ẹpho l'akpa onwẹphe mkpa. A nọnyaa; yọ sụ: “?Bụ ngụnu kparu iphe, egbe iphe ọwaa amụru iya ẹge-a?” Yọ tụgbua jeshia ọkpata Ojejoje ishi iya. ");
INSERT INTO iqw_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ojejoje asụ iya: “L'ọ kwa mkpụkpu labụ nọ ngu l'ẹpho; mbụ l'ọ bụ ụmadzu labụ e-shi ngu l'ẹhu; kee onwẹphe ẹbo. Onye lanụ a-ka onye ọphu ike; onye k'ọgurenya a-nọdu ejeru onye kẹ nwata ozi.” ");
INSERT INTO iqw_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Yo rua ya l'ezeda; yo zeda mụa ejima; yọ bụkotaru unwoke. ");
INSERT INTO iqw_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Onye ọphu vu ụzo eke meemee; gbakọta ẹji l'ẹhu iya. Tọ dụ iya bụ; ẹphe agụa ya Ị́so. ");
INSERT INTO iqw_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Amụ-tsuta, aamụ-tsuta iya; nwunne iya etsowa iya phụ; sụ-de iya ẹka l'ichirukfu. Tọ dụ iya bụ; a gụa ya Jékọpu. Iphe Áyizaku nọwaru bụ ụkporo afa ẹto teke Ribéka mụshiru iya ụnwegirima ono. ");
INSERT INTO iqw_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ụnwegirima ono abya evufuta. Ị́so abụru onye maru ẹnya nta; onye anọduje achị nta l'ẹgu ẹke daburu adaburu. Jékọpu abụru onye eme nggujingguji; l'anọduje l'ufu. ");
INSERT INTO iqw_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Áyizaku yeru Ị́so obu; kẹ l'anụ ono, oogbuje ono atsọje iya ẹna. Obekwanu lẹ Ribéka bụ Jékọpu b'o yeru obu. ");
INSERT INTO iqw_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yo be ujiku lanụ; Jékọpu l'agwọ ine. Ị́so eshi nta bata; l'abya ọda mba. ");
INSERT INTO iqw_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yọ sụ Jékọpu: “T'ọ kọnua ya ine iya ono, nwuru vịi ono tẹ ya ria; lẹ ya adaakwa mba.” Ọ bụ iya meru iphe a wataru iya oku Édọmu. ");
INSERT INTO iqw_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jékọpu asụ iya: “L'ọ kwa; m'ọ -bụru l'ọ haru tẹ yẹbedua bụru ọgurenya.” ");
INSERT INTO iqw_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ị́so asụ t'o lekwa; lẹ ya anwụhuakwa. ?Ya gude k'ọgurenya eme ngụnu? ");
INSERT INTO iqw_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jékọpu asụ iya t'o rioduru iya angụ; woru ọgurenya, gbaru iya nụ nụ yẹbe Jékọpu. Yo kwe; riaru iya angụ; shi ẹge ono woru ọgurenya iya ọbu nụ Jékọpu. ");
INSERT INTO iqw_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jékọpu abya awẹe Ị́so buredi; bya akọo ya ine azakụ ono, ọ gwọru ono; yo ria. Yo riebetsua ya; ngụru mini ye iya; gbeshi; tụgbua. Yọ bụru ẹge ono bẹ Ịso shi; woru ọgurenya, gbaru iya nụ gbaa mgbukuma. ");
INSERT INTO iqw_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A nọnyaa; ẹjo-ẹgu abya abya l'alị ono; t'a gụfukwa ọphu byajẹru l'oge kẹ Ébirihamu. Áyizaku alakfu Abímẹleku, bụ eze ndu Filisutayịnu lẹ Géra. ");
INSERT INTO iqw_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ojejoje abyakfuta Áyizaku bya asụ iya t'ẹ b'ọ lakwa Íjiputu. T'o bukwaru l'alị ono, ya a-sụ iya t'o buru ono! ");
INSERT INTO iqw_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Wo iya t'o butota l'alị-a; lẹ ya a-nọdu-a swiru iya; ya agọkwaruphu ọnu-ọma nụ iya. Kẹ l'ọ bụ nggụbedua; nggu l'awa ngu bẹ ya a-nụkota alị-a l'ọ ha. Ọdo bụ l'iphe, ya riru Ébirihamu angụ lẹ ya e-meru iya bẹ ya e-mekotakwa. ");
INSERT INTO iqw_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ya e-me awa ngu t'ẹphe ha l'igwe l'ọ bụ mkpọ-kpodo, nọ l'igwe. Ya anụ ẹphe alị-a l'ọ ha. Ọ bụ l'eri ngu bẹ ee-shi gọoru iphe bụ mbakeshi lẹ mgboko-a ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ishi iya abụru lẹ Ébirihamu nụru yẹbe Ojejoje okfu; mekota iphemiphe ọbule, ya tọru iya ọkpa iya; dobekotakwaphu ekemu iya l'ọha. ");
INSERT INTO iqw_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tọ dụ iya bụ; Áyizaku eburu lẹ Géra. ");
INSERT INTO iqw_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Unwoke ndu ẹke ono akpalahaa ya ishi nyee ya. Yọ sụ ẹphe l'ọ kwa nwunne iya; kẹ l'ọotsu egvu lẹ ya -su l'ọ bụ nyee ya bẹ ẹphe e-gbu iya; nata iya Ribéka. Ribéka ọphu bụkwa nụ nwanyi l'ẹke ọoma mma. ");
INSERT INTO iqw_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yo be ujiku lanụ; Abímẹleku, bụ eze ndu Filisutayịnu epyofu ẹnya lẹ windo iya; phụ Áyizaku l'ẹke ọokpabashi nyee ya, bụ Ribéka. Teke ono bẹ Áyizaku buakwaru l'ẹke ono ụlori. ");
INSERT INTO iqw_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ya ndono; Abímẹleku abya ekua Áyizaku; sụ iya: “?Ọ kwa lẹ nwanyi ono bẹ ịilu alụlu? ?Bụ ngụnu kparu iphe ị sụru l'ọ bụ nwunne ngu?” Áyizaku asụ iya: “Lẹ ya rịkwaru l'ee-gude okfu iya kpaphua ya?” ");
INSERT INTO iqw_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abímẹleku asụ iya: “?Bụ ngụnu b'i meru ẹphe ẹge-a? Ndẹge ọ -bụru l'onye lanụ l'unwoke-wa bẹ jeru yẹle nyee ngu ono azẹe; mẹ ịi-ga emekwa t'a taa ayi ụta.” ");
INSERT INTO iqw_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tọ dụ iya bụ; Abímẹleku abya atụaru ndu ẹke ono l'ẹphe ha ekemu; sụ l'onye chọru nwoke-a; m'ọ bụ nyee ya okfu bẹ ee-gbukwa egbugbu! ");
INSERT INTO iqw_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Áyizaku abya emebe iphe l'alị ono; iphe emehuru iya nshinu l'afa ono; mbụ mehu gbaa mgburumgburu ugbo ụkporo ise; kẹle Ojejoje gọru iya ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yọ bya enweru iphe; ẹku l'abyaru iya; jeye yọ bụru ọbaba. ");
INSERT INTO iqw_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","O nweru atụru l'igweligwe; nweru eswi; bya agbashịa ohu dobe. A nọnyaa; ndu Filisutayịnu ejilahaaru iya ijimẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ẹphe abya egude ẹja vuchishikota iphe, bụ wẹlu, ụnwu ohu nna iya; mbụ Ébirihamu, tụshiru teke ọ nọ ndzụ. ");
INSERT INTO iqw_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abímẹleku asụ Áyizaku t'ọ kwata kwafụru ẹphe l'alị; kẹ l'ọ kawa ẹphe ẹkuku! ");
INSERT INTO iqw_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tọ dụ iya bụ; Áyizaku abya akwafụ je akpọbe ụlo-ẹ́kwà iya lẹ nsụda Géra; buru l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Áyizaku abya atụkwazikota wẹlu ono, a tụshiru teke nna iya; mbụ Ébirihamu shi nọdu ndzụ ono; mbụ wẹlu ono, ndu Filisutayịnu yechishiru lẹ nna iya nwụhutsuaru ono. Yọ bya agụkwata wẹlu ono ẹpha ono, nna iya shi gụshia ya ono. ");
INSERT INTO iqw_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ndu ozi Áyizaku egvua nsụda ono; gvuvu mini, doru edodo l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Obenu lẹ ndu, echeru ndu Jira elu; mẹ ndu, echeru Áyizaku elu nk'iya wataru ọdzo wẹlu ono adzọdzo. Ẹphe asụ lẹ mini ono bụ mini ẹphebe ndu Géra. Tọ dụ iya bụ; Áyizaku agụa wẹlu ono Isẹku kẹ l'a swọru iya ụswo. ");
INSERT INTO iqw_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ẹphe abya egvua wẹlu ọdo; ndu Jira adzọkfukwaru iya phụ. Áyizaku agụa onanu Sitina. ");
INSERT INTO iqw_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Yo gbeshi l'ẹke ono je atụa wẹlu ọdo; tọ dụhe onye dzọru onanu. Yọ gụa onanu Rehobọtu bya asụ: “Lẹ nta-a bẹ Ojejoje mewaru t'ẹphe tụsaru ẹhu l'alị-a nọdu iya bụru ọ-jaa-jagba-ẹgu.” ");
INSERT INTO iqw_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yo gbeshi l'ẹke ono; yọ bụru iya ọla Besheba. ");
INSERT INTO iqw_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ojejoje abyakfuta iya l'ẹnyashi ono; bya asụ iya: “L'ọ kwa yẹbedua bụ Nchileke kẹ nna ngu, bụ Ébirihamu.” Wo iya t'ẹ b'ọ tsụkwa egvu; kẹle ya nọ-ọ swiru iya. Ya e-gude okfu ẹhu nwozi iya; mbụ Ébirihamu gọru ọnu-ọma nụ yẹbe Áyizaku; mee t'awa iya ha igweligwe. ");
INSERT INTO iqw_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Áyizaku abya akpụa ẹnya-ngwẹja l'ẹke ono; bya akpọ-kua ẹpha Ojejoje. Yọ bya egvube ụlo-ẹ́kwà iya l'ẹke ono. Ndu ozi iya abya atụa wẹlu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yọ bụru teke ono bẹ Abímẹleku yẹle Ahụzatu; onye akpọ-zijeru iya ụzo; mẹ Fịkolu, bụ onye ishi ndu sọja iya shi Géra kpakfuta iya. ");
INSERT INTO iqw_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Áyizaku ajị ẹphe: “?Bụ ngụnu kparu iphe unu abya nk'iya; l'ẹke ya dụkwa unu ashị; unu achịfu iya l'alị unu.” ");
INSERT INTO iqw_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ẹphe asụ iya: “L'ẹphe makpọoru ọhuma lẹ Ojejoje nọ swiru iya eswiru. Ọo ya kparu iphe ẹphe sụru l'ọ dụ mma tẹ nggu l'ẹphe ria nte; tẹ nggu l'ẹphe gbaa ndzụ; ");
INSERT INTO iqw_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","l'ẹ tịi medu ẹphe ẹji ẹge ono, ẹ tọ dụdu iphe ẹphe mejeru unu teke ono, unu shi buru ndu-ẹphe ono. Yọ bụleruphu ọhuma bẹ ẹphe mekotaru unu; bya edufu unu lẹ domangu lẹ rimangu ono. Nta-a bẹ Ojejoje byawaru bya agọwaru ngu ọnu.” ");
INSERT INTO iqw_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Áyizaku abya agbaaru ẹphe ajị; ẹphe eria; ngụa. ");
INSERT INTO iqw_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yo be l'ọnmewa ụtsu echile iya; ẹphe agbaa ndzụ. Áyizaku abya edube ẹphe; ẹphe alashia l'ẹhu-gudangu. ");
INSERT INTO iqw_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Yọ bụru mbọku ono bẹ ndu ozi Áyizaku bya ekfuaru iya kẹ wẹlu phụ, ẹphe tụru phụ; sụ iya l'ẹphe phụkwaru iya mini. ");
INSERT INTO iqw_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yọ gụa ya Shiba. Ẹpha mkpụkpu ono abụru Besheba jeye ntanụ-a. ");
INSERT INTO iqw_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ị́so anọlephu ụkporo afa labụ; je alụa Juditu, bụ ada Beri onye Hetu; bya alụkwaaphu Basematu, bụ ada Elọnu, bụkwaphu onye Hetu. ");
INSERT INTO iqw_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ẹphe abụru iphe-ẹhuka nọduru Áyizaku yẹle Ribéka. ");
INSERT INTO iqw_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yo rua teke Áyizaku kahụwaru; k'ọphu bụ lẹ nka lawaru iya l'ẹnya; yo kua Ị́so, bụ ọkpara iya. Yọ za iya. ");
INSERT INTO iqw_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Áyizaku asụ iya: “Nta-a bẹ ya bụakwa nwoke ọgurenya; tọ bụ lẹ ya maru mbọku, ya a-nwụhu. ");
INSERT INTO iqw_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ngwaa; wota iphe, iigudeje achị nta; mbụ ẹda-akfụ ngu; mẹ akfụ ngu; gude je l'ẹgbudu je egbua anụ; ");
INSERT INTO iqw_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","gude iya shia nri, atsọ ẹna; mbụ egbe iya ọphu adụje iya mma. Teke i shitsuaru iya; nggu egwotaru iya ẹya; tẹ ya ria; gọoru ngu ọnu; tẹmanu ya anwụhude!” ");
INSERT INTO iqw_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yọ bụru lẹ teke Áyizaku ekfuru Ịso iphe ono bẹ Ribéka nụkotaru iphe ookfu. Ị́so atụgbulephu jeshia nta ono; ");
INSERT INTO iqw_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribéka asụ nwatibe iya Jékọpu: “Lenu; lẹ ya nụkwaru ẹke nna ngu shi ekfuru nwunne ngu Ị́so; ");
INSERT INTO iqw_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","t'o je egbua anụ gude shiaru iya nri, atsọ ẹna tẹ ya ria; ẹge ya a-gọru iya ọnu l'ifu Ojejoje; tẹmanu ya anwụhude.” ");
INSERT INTO iqw_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nwa mu; nta-a kwa t'ị ngabekwa nchị ọhuma; mee iphe-a, ya abyaru ngu ekfuru-a! ");
INSERT INTO iqw_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Jee l'ẹke, elu dọru; fọta ada eghu labụ, dụ mma; tẹ ya gude shiaru nna ngu nri, dụ mma. Ya e-shile iya phụ ẹge ọo-dụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Teke ya shituaru iya; nggu egwota iya je anụ nna ngu t'o ria; k'ọphu ọo-gọru ngu ọnu; tẹmanu yọ nwụhude. ");
INSERT INTO iqw_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jékọpu asụ nne iya; mbụ Ribéka: “Mẹ nwunne iya; mbụ Ị́so gbakwaru ẹji; yẹbedua abụru onye ẹhu kwọru akwọkwo. ");
INSERT INTO iqw_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","O nwekwaru ẹge ọo-dụ; nna mu ejeshia mu ọra ẹka l'ẹhu; ọo-makwa l'ọ bụ ụgho bẹ mu aghọru iya. ?T'oo-medu nụ; yo gbe tụ mu ọnu l'ọzori ọnu, ọo-ga agọru mu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nne iya asụ iya: “Nwa mu; ọ -tụa ngu ọnu tẹ ya vukwaru iya! Ọ bụlephu t'i mee iphe, ya sụru t'i mee. Tụgbua je akpụtaru iya eghu ono!” ");
INSERT INTO iqw_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ya ndono; yọ tụgbua je akpụtaru nne iya eghu ono. Nne iya abya egude iya mee kẹ nri, atsọ ẹna; mee ya ẹge adụje nna iya mma. ");
INSERT INTO iqw_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ribéka abya achịta uwe Ịso, bụ ọkpara iya; mbụ uwe iya ọphu kakọta ọma mma; yee onye kẹ nwata, bụ iya bụ Jékọpu. Uwe Ị́so ono bẹ shi koru l'ụlo Ribéka. ");
INSERT INTO iqw_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yọ bya eworu akpọ eghu ono kwee ya l'ẹka; bya aphụ-kpua ya ẹya l'olu ẹke kwọru iya akwọkwo. ");
INSERT INTO iqw_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Yọ bya aparu nri ono, o shiru, a tsọ ntụmatu ono pẹe Jékọpu; nụkwa iya phụ buredi, o gheru ye iya. ");
INSERT INTO iqw_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jékọpu egwota iya gwojeru nna iya; je eku iya: “Nna!” Yọ za iya; bya ajị iya: “?Ị bụ onye; nwa mu?” ");
INSERT INTO iqw_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jékọpu asụ iya: “L'ọ kwa yẹbedua, bụ Ị́so, bụ ọkpara ngu. Ya meekwaru ẹge i ziru iya. Gbeshi nụ nọdu anọdu taa anụ ọbu, ya gburu ọbu; k'ọphu ịi-gọru iya ọnu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Áyizaku ajị iya: “Nwa mu; ?nanụ ẹge i meru gbukebewa anụ ọbu ẹgwegwa ẹge-a?” Jékọpu asụ iya: “L'ọ kwa Ojejoje, bụ Nchileke ngu yetaru iya ẹka.” ");
INSERT INTO iqw_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Áyizaku asụ Jékọpu t'ọ kpịritaedu tẹ ya raẹdu iya ẹka; maru: ?m'ị bụ-a nwatibe iya Ị́so tẹ tị bụdu? ");
INSERT INTO iqw_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jékọpu abya ejekfube nna iya, bụ Áyizaku ntse. Yọ bya araphee ya ẹka l'ẹhu; sụ iya: “L'olu ngu kwa olu Jékọpu; obenu l'ẹka ngu bụkwanu kẹ Ị́so.” ");
INSERT INTO iqw_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ẹ tọ hụbehedu Jékọpu ama; kẹ l'ẹka iya dụ ẹji ẹji l'ọ bụ kẹ nwunne iya; mbụ Ịso. Yọ gọoru iya ọnu; l'arị l'ọ bụ Ị́so. ");
INSERT INTO iqw_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Yọ jị iya: “?Bụ-a nggu bụ nwatibe iya Ị́so?” Jékọpu asụ iya: “Iye-e!” ");
INSERT INTO iqw_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yọ sụ iya: “Nwa iya; patanụru iya anụ ọbu, i gburu; bya eshia ọbu; k'ọphu ya a-ta iya; gọoru ngu ọnu ọbu!” Jékọpu abya apataru iya ẹya; yọ taa. Yọ bya anụ iya mẹe; yọ ngụru ye iya. ");
INSERT INTO iqw_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nna iya ono; mbụ Áyizaku asụ iya t'ọ bya bya anmaa ya akpa! ");
INSERT INTO iqw_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yo jenyabe iya ntse je anmaa ya akpa. Áyizaku anụa mkpọ uwe iya; bya agọoru iya ọnu; sụ iya: “Ha! Mkpọ nwatibe iya dụkwa l'ọ bụ mkpọ ẹgu, Ojejoje gọru ọnu-ọma nụ. ");
INSERT INTO iqw_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tẹ Ojejoje mekwaa tẹ igwe chịjeru ngu mini; Yo mekwaaphu ẹke, i meberu iphe t'o mehujeru ngu. T'o mee t'i nweru nri; nweru mẹe; nweru k'etsushi iya. ");
INSERT INTO iqw_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tẹ iphe bụ mbakeshi jejeru ngu ozi; iphe, bụ ọha, nọnu ebyijeru ngu ikpere! T'ọ bụru nggụbedua a-bụru nnajiufu unwunne ngu phẹ; unwunne ngu phẹ ebyijeru ngu ikpere! Iphe, bụ onye tụru ngu ọnu bụakwa onye a tụru ọnu; onye gọru ngu ọnu abụru onye a gọru ọnu!” ");
INSERT INTO iqw_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Áyizaku agọebetsuaru Jékọpu ọnu ono; ọ bụkwadua alụfu, ọ lụfu l'ẹke, nna iya ono nọ; ọwaa bụwa nwunne iya; mbụ Ị́so l'ẹke o shi nta ono ala. ");
INSERT INTO iqw_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ịso abya eshikwaaphu nri, atsọ ẹna gwojeru nna iya; sụ iya: “Nna; gbeshi bya ataa anụ, ya gburu; shiaru ngu ọbu; ẹge ịi-gọru iya ọnu ọbu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Áyizaku ajị iya: “?Bụ onye b'ị bụ?” Yọ sụ iya: “L'ọ kwa yẹbedua bụ nwa ngu nwoke; mbụ ọkpara ngu, bụ Ị́so.” ");
INSERT INTO iqw_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ẹhu anmahu Áyizaku kpakpakpa. Yọ jị: “?Bụhunu onye gburu anụ wotaru iya, ya gudekwadua l'ẹka ata; nggu abata-a? Ya gọokwaru onye ono ọnu; mbụ l'onye ono bụakwa onye a gọru ọnu-ọma nụ.” ");
INSERT INTO iqw_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ị́so anụlephu iphe ono, nna iya kfuru ono; gude aphụ; gude ẹkwa; sụ nna iya ono: “T'ọ gọoru iya rụ ọnu. T'ọ gọoru iya rụ ọnu nk'iya!” ");
INSERT INTO iqw_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Áyizaku asụ iya: “Lẹ nwunne ngu gudeekwa ụgho bya anata ọnu-ọma ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ịso asụ iya: “L'ọ bụlephu Jékọpu ono, a gụru iya ono bẹ gbaru iya nụ. ?Ọwaa te kweedua ugbo ẹbo, o kputaru iya. Ọ nataru iya ọgurenya, ya bụ. Nta-a b'ọ byawaru bya anatafụa ya ọnu, a ga agọru iya.” Yo kfutsua ẹge ono bya ajị nna iya ono: “?To nwekpodua nwọnu ọphu phọduru nụ, ị gọru iya tọo?” ");
INSERT INTO iqw_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Áyizaku asụ iya: “Lẹ ya meekwaru Jékọpu t'ọ bụru nnajiufu ngu; bya emekwaaphu tẹ ndu abụbu iya l'ẹphe ha jejeru iya ozi. Ya gọokwaru ọnu nụ iya lẹ nri; mẹ lẹ mẹe. ?Bụ ngụnu bẹ ya e-meru ngu nta-a nggụbe nwa iya?” ");
INSERT INTO iqw_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ị́so asụ nna iya ono: “Nna; ?bụlephu ọnu-ọma lanụ b'i nweru kpụ? Nna; gọnuaru iya ọnu nk'iya!” Ịso awata ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nna iya mbụ Áyizaku asụ iya: “Ẹke ii-bu bẹ bụ alị ẹke, ẹ-te emehujedu iphe; ẹke mini ta achịduru ngu. ");
INSERT INTO iqw_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ọ bụ ogu-mbeke bẹ ii-gude buru; nwunne ngu bẹ ịi-nọdu agbaru mbọyi. Obenu lẹ teke ọ wataru ngu ọtsu l'ẹhu; bẹ ii-kwefuru iya íkè; nggu l'iya ebukahu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ị́so abya akpọo Jékọpu ashị lẹ k'ọnu ono, nna iya gọru nụ iya ono. Yọ sụ onwiya: “?Ọ kwa lẹ nna iya abyawa anwụhu? Teke ono bẹ ya e-gbu-a nwunne iya; mbụ Jékọpu.” ");
INSERT INTO iqw_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ribéka anụlephu iphe, Ị́so kfuru; bya ezia t'e je ekuaru iya nwa iya kẹ nwata; mbụ Jékọpu. Yo rua; Ribéka asụ iya: “Lekwa l'iphe nwunne ngu Ịso gude l'adụ onwiya ike; bụkwa lẹ ya e-gbu ngu. ");
INSERT INTO iqw_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ọo ya bụ; nggụbe nwa iya; mekwaa iphe-a, ya abyaru ngu ekfuru-a: Gbalaa nta-a lakfu nwunne iya, bụ Lébanu lẹ Háranu; ");
INSERT INTO iqw_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","tẹ nggu l'iya butota; t'e gude t'obu dazita nwunne ngu. ");
INSERT INTO iqw_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Teke o ghubuhuru iya eghughu; yọ zahawa iphe ono, i meru iya ono bẹ ya ezia t'ị lata. ?Bụ ngụnu a-kpakwanụ iphe ya a-nọdu t'unu nwụshihu l'ujiku lanụ?” ");
INSERT INTO iqw_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ya ndono; Ribéka asụ Áyizaku l'ike ọnodu ndzụ ta dụhekwa iya; kẹ l'ike ụnwanyi Hetu-a gvụakwaru iya. Ọ -bụru lẹ Jékọpu e-je alụfua nwanyi Hetu ọdo; ?ya a-nọkwadu ndzụ k'ome ngụnu ọdo? ");
INSERT INTO iqw_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tọ dụ iya bụ; Áyizaku abya ekua Jékọpu; gọoru iya ọnu; bya anmaaru iya ọkwa; sụ iya: “Ba alụkwa nwanyi Kénanu! ");
INSERT INTO iqw_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tụgbulekwaphu jeshia kẹ Lébanu, bụ nwunne nne ngu lẹ Padanu-Áramu t'o kee ngu nwanyi; mbụ l'ufu nna, mụru nne ngu, bụ iya bụ Bétuwẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Tẹ Nchileke, bụ Ọkaribe-Kakọta-Ike gọkwaru ọnu-ọma nụ ngu lẹ nwa; yo mee t'ị jaa ajaja bụru nna igweligwe mba. ");
INSERT INTO iqw_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tẹ Nchileke mekwaa t'ọnu ono, ọ gọru nụ Ébirihamu ono bụkwaruphu nke ngu; nggu l'ụnwu ngu; k'ọphu alị ono, iibu nta-a l'ọ bụ onye mbyamụmbya ono a-bụru nke ngu; mbụ alị ono, Nchileke nụru Ébirihamu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ya ndono; Áyizaku abya ezifu Jékọpu; yọ tụgbua jeshia kẹ Lébanu lẹ Padanu-Áramu. Lébanu ono bụ nwatibe Bétuwẹlu, bụ onye Áramu; bụkwaruphu nwunne Ribéka, bụ nne Jékọpu yẹle Ị́so. ");
INSERT INTO iqw_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ya ndono; Ị́so abya amaru lẹ Áyizaku gọwaru Jékọpu ọnu; bya ezifuwa iya t'o je Padanu-Áramu; je alụa nwanyi; bya amaru lẹ teke ono, ọ gọru iya ọnu ono b'ọ nmaru iya ọkwa t'ẹ b'ọ lụkwa nwanyi Kénanu; ");
INSERT INTO iqw_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","bya amaru lẹ Jékọpu nụwaru nna iya mẹ nne iya okfu; tụgbuwa jeshia Padanu-Áramu. ");
INSERT INTO iqw_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ọ bụ teke ono b'ọ bya edoo Ị́so ẹnya ẹge ụnwanyi Kénanu dụ-be nna iya; mbụ Áyizaku ẹji. ");
INSERT INTO iqw_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yọ tụgbua jeshia kẹ Ishimẹlu; je alụa Mahalatu yekobe l'ụnwanyi ndu ọphu ọoluhawa. Mahalatu ono bụ nwunne Nebayọtu, bụ ọkpara Ishimẹlu; bụru nwanwa Ébirihamu. ");
INSERT INTO iqw_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ya ndono; Jékọpu egbeshi lẹ Besheba; yọ bụru iya oje Háranu. ");
INSERT INTO iqw_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yo jenyaa; nchi ejikfu iya l'ụzo; yọ nọdu tẹ ya radụ. Yo je apata mkpuma lanụ l'ẹke ono; dobe; zẹ-zita; chebe iya ishi kuru mgbẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yọ bya arọo nrọ phụa ubube, e gvuberu l'alị; yo je adụ-kfuru l'igwe. Ụnwu ojozi Nchileke l'enyi iya gòdógòdó; ndu enyihu enyihu; ndu enyizita enyizita. ");
INSERT INTO iqw_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ojejoje evudo l'ọnungonu ubube ono; sụ: “L'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke kẹ nna ngu, bụ Ébirihamu; bụkwaruphu Nchileke kẹ Áyizaku. Alị ono, ị zẹ ono bẹ ya a-nụ nggu l'awa ngu. ");
INSERT INTO iqw_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Awa ngu a-ha igweligwe l'ọ bụ ẹja, nọ l'alị. Unu e-bu jeye ụzo ẹnyanwu-arịba; bya ebua jerua ụzo ẹnyanwu-ahata. Unu e-bukwaphu jeye ụzo isheli; bua jerukwaaphu ụzo ọhuda. Ya e-shi l'ẹka nggu l'awa ngu gọoru ndiphe mgburumgburu ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ya e-swiru ngu eswiru; l'eleta ngu ẹnya l'iphe, bụ ẹke ii-jekpo. Ọdo abụru lẹ ya e-dulata ngu azụ l'alị-a. Ẹ to nwedu lẹ ya aha ngu jeye teke ya e-mekotaru ngu iphe ono, ya kweru ngu ụkwa iya ono.” ");
INSERT INTO iqw_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jékọpu etehu; bya asụ: “Ha! ?Ọo ya bụ lẹ Ojejoje nọ l'ẹke-a; ya ta ama.” ");
INSERT INTO iqw_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yọ wata ọtsu egvu; sụ: “L'akpaji ẹke-a bẹ dụkwa egvu! Ẹ to nwekwa iphe ọdo, ẹke-a bụ; 'abụdu ụlo Nchileke. Ọ kwa ẹke-a bụ ọnu-ụzo imigwe!” ");
INSERT INTO iqw_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yo be l'ọnmewa ụtsu echile iya; Jékọpu apata mkpuma ono, o shi chebe ishi ono; gvube l'ọ bụ itso; bya eworu manụ gbashị l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yọ gụa ẹke ono Bẹ́telu; e guderu l'iphe, e shi ekuje ẹke ono bụ Luzu. ");
INSERT INTO iqw_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jékọpu abya eribua ya lẹ nte; sụ: “Ọ -bụru lẹ Nchileke e-swiru iya; leta iya ẹnya l'ije iya-a; mee tẹ ya phụje iphe oye l'ọnu; mẹ iphe owe l'ukfu; ");
INSERT INTO iqw_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","k'ọphu bụ lẹ ya jeru iphe ọwaa lata l'ufu nna iya l'ẹhu-gudangu; bẹ Ojejoje a-bụkwaru Nchileke iya! ");
INSERT INTO iqw_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mkpuma-wa, ya gvuberu l'ọ bụ itso-wa a-bụru ụlo Nchileke; iphe bụ iphe, nggụbe Nchileke nụru iya bẹ ya e-ke ụzo iri nụ ngu ụzo lanụ.” ");
INSERT INTO iqw_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ya ndono; Jékọpu akwasẹru ije iya jeye yọ bya erua alị ndu ụzo ẹnyanwu-ahata. ");
INSERT INTO iqw_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yo rua ẹke ono bya aphụ wẹlu, nọ l'oghe-ẹgu l'ẹke ono; mẹ uzi atụru ẹto l'iku iya; kẹ l'atụru ono bụ lẹ wẹlu ono b'ọ ngụje mini. Mkpuma, e gude swichia ọnu wẹlu ono aha nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yọo buje; atụru ono -dzukolephu l'ẹke ono; ndu eche iya nụ abya agbakọ ẹka swifu mkpuma ono l'ọnu wẹlu ono; seta mini doberu atụru ono. Ẹphe -megee; ẹphe abya eswikwazi mkpuma ono l'ọnu wẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jékọpu abya ajị ndu eche atụru ono ẹke ẹphe shi. Ẹphe asụ iya l'ẹphe shikwa Háranu. ");
INSERT INTO iqw_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yọ sụ ẹphe mẹ ẹphe maru Lébanu, bụ nwanwa Nahọ? Ẹphe asụ iya l'ẹphe makwaru iya-a. ");
INSERT INTO iqw_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jékọpu ajị ẹphe: “?Mẹ ẹhu dụ iya-a mma?” Ẹphe asụ iya l'ẹhu dụkwa iya-a mma; l'ọ kwa nwatibe iya; mbụ Rechẹlu bẹ chị atụru abya ẹgaphu. ");
INSERT INTO iqw_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yọ sụ ẹphe: “?Unu ta phụdu l'ụboku hakwadua nshinu; l'ẹ tọ gbadụa teke, aachịkobeje atụru. Unu setanu mini doberu atụru ono t'ọ ngụa. Teke e metsuaru; unu achịru iya je ẹke ọokpaje nri t'ọ kpafụa nri!” ");
INSERT INTO iqw_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ẹphe asụ iya: “L'ẹphe te emeghekwa iya ẹge ono. L'ọ kwa teke atụru ono dzuleruphu edzudzu l'ẹke-a; e swifu mkpuma ono l'ọnu wẹlu ono. Teke ono; e setaru iya mini t'ọ ngụa.” ");
INSERT INTO iqw_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yọ bụru teke ono, ẹphe l'iya ekfu ono bẹ Rechẹlu chị atụru nna iya byaruta; kẹ l'ọ bụ nwamgbọko eche atụru. ");
INSERT INTO iqw_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jékọpu aphụlephu Rechẹlu; mẹ atụru Lébanu ono, ọ chị ono; tụgbua je eswifu mkpuma ono l'ọnu wẹlu ono; bya eseta mini doberu atụru nwunne nne iya ono; yọ ngụa. ");
INSERT INTO iqw_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jékọpu abya anmaa Rechẹlu akpa; wata ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jékọpu asụ Rechẹlu lẹ yẹle nna iya bụkwa; lẹ ya bụkwa nwatibe Ribéka. Rechẹlu agbagbụa je akọoru iya nna iya. ");
INSERT INTO iqw_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lébanu anụlephu kẹ nwa nwunne iya ono; mbụ Jékọpu; gbagbụwaphu gbakfutashia ya. Yo rua je anmaa ya akpa; tsuta iya ọnu; duta iya jeshia nk'iya. Ẹphe erua; Jékọpu abya akọkotaru iya iphemiphe ọbule ono, meru nụ ono. ");
INSERT INTO iqw_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lébanu asụ iya lẹ yẹle iya bụkwa mee lanụ; mbụ e -kee; e-kehe-ọdo. Jékọpu ebulephu ọnwa ophu lẹ kẹ Lébanu; ");
INSERT INTO iqw_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lébanu asụ iya: “?Bụ okfu lẹ nggu l'iya bụ abụbu b'ịi-nọdu ejeru iya ozi kẹ mmanu tọo?” Wo iya t'o kfua iphe, ya a-nọdu akfụ iya. ");
INSERT INTO iqw_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lébanu bẹ mụtaru ụnwu-mgbọko labụ. Ẹpha onye k'ọgurenya bụ Lii; onye kẹ nwata abụru Rechẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lii bẹ ẹnya dụ ẹruru-ẹruru; obenu lẹ Rechẹlu ama mma; dụ ugvu. ");
INSERT INTO iqw_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rechẹlu bẹ shi tụbahawa Jékọpu l'ẹnya. Yọ sụ Lébanu: “Tẹ ya jenuaru iya ozi afa ẹsaa; t'o kee ya nwatibe iya kẹ nwata; mbụ Rechẹlu.” ");
INSERT INTO iqw_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lébanu asụ iya: “L'o gbe kakwa mma lẹ ya keru ngu iya; malẹ ya keru iya akataka onye ọdo. Ngwanụ; t'ẹphe buwaruru.” ");
INSERT INTO iqw_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tọ dụ iya bụ; Jékọpu ejee ozi afa ẹsaa changụ t'e kee ya Rechẹlu. Afa ẹsaa ono adụle-ẹ Jékọpu l'ọ bụ nwujiku olemole; kẹ l'o yeru Rechẹlu obu nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ya ndono; Jékọpu asụ Lébanu: “Lẹ ya nọ-dzuakwaru afa ẹsaa ọbu. Dee ya nyee ya; k'ọphu yẹ ya a-zẹ.” ");
INSERT INTO iqw_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tọ dụ iya bụ; Lébanu abya ekua ndu ẹke ono; shiaru ẹphe nri. ");
INSERT INTO iqw_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Yo be l'urẹnyashi; yo duta ada iya; mbụ Lii; dee Jékọpu; yẹ ya azẹe. ");
INSERT INTO iqw_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lébanu abya eshi lẹ ndu ohu iya duta nwamgbọko ọphu aza Zilipa duru nụ Lii t'o jejeru iya ozi-ụlo. ");
INSERT INTO iqw_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nchi abọhulephu; Jékọpu abya amaru l'ọ bụ Lii b'e gbe dee ya. Yọ sụ Lébanu: “?Bụ ngụnu b'i meru iya egbe iya ọwaa. ?Tọ bụdu Rechẹlu bẹ ya jeru ngu ozi iya. ?Nanụ ẹge ọ dụ b'ị gbaru iya egbe ẹregede ọwaa.” ");
INSERT INTO iqw_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lébanu asụ iya: “Tị madu l'ẹ tọ bụdu ome-l'alị ayi l'ẹke-a t'e vuru ụzo kee onye kẹ nwata nji; tẹmanu e kede onye kẹ ọgurenya. ");
INSERT INTO iqw_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Taa nshi megeodu ẹswa-nwanyi k'onye ọwaa l'idzu-wa. E megee; ya ekefua ngu onye kẹ nwata; ọbule ii-jekwaru iya phụ ozi afa ẹsaa ọdo.” ");
INSERT INTO iqw_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jékọpu ekweta; bya emee ẹswa-nwanyi l'ẹhu Lii idzu ophu. Lébanu abya ekefua ya Rechẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lébanu abya eshi lẹ ndu ohu iya duta nwamgbọko ọphu aza Biliha duru nụ Rechẹlu t'o jejeru iya ozi-ụlo. ");
INSERT INTO iqw_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jékọpu yẹle Rechẹlu abya azẹe. Yọ ka oyeru Rechẹlu obu; malẹ Lii. Yọ bya ejeeru Lébanu ozi afa ẹsaa ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ojejoje abya elee ẹnya phụ l'e te yeduru Lii obu; mee ya; yọ wata ọtsu ime; Rechẹlu ekeru ekeru. ");
INSERT INTO iqw_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lii abya atsụta ime; mụa nwata nwoke; gụa ya Rúbẹnu; kẹ l'ọ sụru: “Lẹ Ojejoje phụwaru iphe-ẹhuka, ya eje. Nta-a bẹ ya maru lẹ nji iya a-kabẹ-ẹ yeru iya obu.” ");
INSERT INTO iqw_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yọ bya atsụta ime ọdo; mụkwaaphu nwata nwoke; sụ: “Lẹ Ojejoje nụwaru l'ẹ t'e yeduru iya obu kparu iphe ọ nụfukwaaru iya phụ onye ọwaa.” Yọ gụa ya Símiyọnu. ");
INSERT INTO iqw_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yọ bya atsụtakwa ime ọdo; mụkwaaphu nwata nwoke. Yọ sụ: “Nta-a bẹ ya maru lẹ nji iya e-kwe-e rụkota iya; kẹle ya mụtawaru iya unwoke ẹto.” Yọ gụa ya Lívayi. ");
INSERT INTO iqw_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yọ tsụta ime ọdo; mụkwaaphu nwata nwoke; bya asụ: “Ugbiya-a bẹ ya e-tu Ojejoje ẹpha.” Yọ gụa ya Júda. Yọ mụtsua Júda; tsụ-buhu ime. ");
INSERT INTO iqw_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rechẹlu aphụa lẹ ya ta amụtaduru Jékọpu nwa; kolahaaru nwunne iya ono okopho. Yọ sụ Jékọpu: “L'o -yedu iya ime bẹ ya a-nwụhukwa!” ");
INSERT INTO iqw_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iphe ono, o kfuru ono eghua Jékọpu eghughu. Yọ sụ Rechẹlu: “?Bụ iya bụ Nchileke, meru t'ẹ b'ị mụta nwata?” ");
INSERT INTO iqw_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ya ndono; Rechẹlu asụ iya: “Ọwaa Biliha ndọ-ọ, bụ nwata ejeru iya ozi-ụlo. Duta iya tẹ nggu l'iya zẹe t'ọ mụtaru iya nwa; k'ọphu ya e-shi l'ẹka iya nweru akọ.” ");
INSERT INTO iqw_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tọ dụ iya bụ; yọ bya eduta Biliha, bụ nwata mgbọko, ejeru iya ozi-ụlo dee ya; yọ lụru. Jékọpu yẹle Biliha abya azẹe; ");
INSERT INTO iqw_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","yọ tsụta ime; mụaru iya nwata nwoke. ");
INSERT INTO iqw_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rechẹlu asụ: “Nta-a bẹ Nchileke hawaru iya enge. Ọ ngabẹwaru nchị nụa iphe, ya rọru iya; bya anụ iya nwata nwoke.” Yo gude k'ono gụa ya Dánu. ");
INSERT INTO iqw_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A nọnyakwaa; Biliha abya atsụta ime ọdo; mụaru Jékọpu nwata nwoke k'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rechẹlu asụ: “Lẹ yẹle nwunne iya kparu ẹnya nshinu; ọbule nta-a bẹ ya kaakwanu iya ẹkuku.” Yọ gụa ya Náfutali. ");
INSERT INTO iqw_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Teke Lii bya amaru lẹ ya tsu-buwaru ime; b'o dutaru nwata ọphu ejeru iya ozi-ụlo; mbụ Zilipa dee Jékọpu t'ọ lụru. ");
INSERT INTO iqw_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Onye ozi-ụlo kẹ Lii ono; mbụ Zilipa abya amụtaru Jékọpu nwata nwoke. ");
INSERT INTO iqw_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lii asụ: “Ọwaa kwa iphe-ekweru.” Yọ gụa nwata ono Gádu. ");
INSERT INTO iqw_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Onye ozi kẹ Lii ono; mbụ Zilipa abya amụtaru Jékọpu nwata nwoke k'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lii asụ: “Ẹhu atsọkwa nụ yẹbe Lii ntụmatu. Nta-a bẹ ụnwanyi a-nọdu eku iya onye ẹhu atsọ ẹna.” Yọ gụa nwata ono Ásha. ");
INSERT INTO iqw_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yo be teke eebuje witu; Rúbẹnu atụgbua jeshia l'ẹgu; je aphụa akpụru mandureku; wọta iya wolataru nne iya Lii. Rechẹlu asụ Lii: “T'ọ hẹnua ya mandureku ono, nwatibe iya wọtaru ono.” ");
INSERT INTO iqw_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lii asụ iya: “Nji iya b'ị nataru iya. Onanu te dzu ngu; ?iime t'ị natafụa ya mandureku, nwatibe iya wọtaru iya tọo?” Rechẹlu asụ iya: “T'ọ laarụru nji iya l'ụlo l'ẹnyashi-a ụgwo mandureku nwatibe iya ọbu.” ");
INSERT INTO iqw_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ya ndono; Jékọpu eshilephu l'ẹgu lata l'urẹnyashi ono; Lii agbakfube iya; je asụ iya: “L'ọo-lakwaru iya l'ụlo l'ẹnyashi-a; kẹle ya gudeekwa mandureku, nwatibe iya zụta iya.” Ya ndono; yo be l'ẹnyashi; yọ laaru iya ụlo ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nchileke anụa ekfukfu, Lii kfuru nụ iya; yọ tsụtawaphu ime; mụaru Jékọpu nwata nwoke k'ise. ");
INSERT INTO iqw_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lii asụ: “Lẹ Nchileke buakwaru iya nggo; kẹle ya dutaru nwamgbọko, e jeru iya ozi-ụlo dee nji iya.” Lii agụa nwata ono Ísaka. ");
INSERT INTO iqw_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lii abyakwa bya atsụta ime ọdo; mụaru Jékọpu nwata nwoke k'ishingu. ");
INSERT INTO iqw_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lii asụ: “Nchileke mewaru iya iphe-ọma, dụ biribiri. Nta-a bẹ ya maru lẹ nji iya a-nọdu akwabẹ iya ugvu; keshinu ọphu ya mụtawaru iya obodo okoro ishingu.” Tọ dụ iya bụ; yọ gụa nwata ono Zébulọnu. ");
INSERT INTO iqw_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","A nọnyakwaa; yọ bya atsụta ime ọdo; mụa nwamgbọko; gụa ya Dayina. ");
INSERT INTO iqw_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nchileke abya anyata Rechẹlu; ngabẹru iya nchị; bya emee ya; yọ wata ọtsu ime. ");
INSERT INTO iqw_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yọ bya atsụta ime; mụa nwata nwoke; bya asụ: “Nta-a bẹ Nchileke wofuwaru iya iphe-iphere.” ");
INSERT INTO iqw_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Yọ gụa nwata ono Jósẹfu; sụ: “Tẹ Ojejoje yekwafukwaaru iya nwata nwoke ọdo l'ọwaa.” ");
INSERT INTO iqw_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rechẹlu amụtsulephu Jósẹfu; Jékọpu asụ Lébanu t'ọ ha ya tẹ ya la kẹ nna iya, bụ ẹke a mụru iya. ");
INSERT INTO iqw_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","T'ọ haaru iya unyomu iya; haaru iya ụnwegirima iya, bụ ndu ya jeru iya ozi l'ishi ẹphe; tẹ ya chịta la. L'ọ phụwaru ẹge ya jeberu iya ozi. ");
INSERT INTO iqw_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Obenu lẹ Lébanu sụru iya: “Ọ -bụru lẹ ya tụbaru ngu l'obu; byiko nọnyafunua! Lẹ ya phụwaru l'ọ bụ l'okfu ẹhu ngu bẹ Ojejoje gude gọoru iya ọnu ẹge-a.” ");
INSERT INTO iqw_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Sụkwa iya phụ t'o kfua iphe, ya a-kfụje iya tẹ ya kfụje iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jékọpu asụ iya: “L'ị mawaru ẹge ya jeberu ngu ozi; maru ẹge elu ngu gude zụta-be lẹ ya echeru ngu iya. ");
INSERT INTO iqw_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nwiphe ono, i shi nweru bẹ ya byadẹru ono abarahụ bya aha ẹge-a; kẹ l'ọobuje; ibyiya ọphu ya shiru; Ojejoje agọoru ngu ọnu. Nta-a bụ; ?bụhunu teke ole bẹ ya a-wata ọgba mkpu ẹhu kẹ yẹle ndibe iya?” ");
INSERT INTO iqw_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lébanu ajị iya iphe ya a-kfụ iya? Jékọpu asụ iya t'ẹ b'ọ dụshi iphe ọo-kfụ iya. “L'iphe e-gbe mechianu bụ lẹ ya a-nọdu echeleru ngu-a atụru ẹge ya eche iya; m'ọ -bụru l'i kwetaru iphe-a, ya abya ekfukfu-wa: ");
INSERT INTO iqw_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tẹ ya tsoo iphe bụ ẹke elu ngu kụru ntanụ; fọshikota atụru ndu ọphu tụru iphe poopoo; mẹ ndu ọphu deberu iphe edebe; mẹ iphe bụ nwatụru ndu ọphu eji uji; mẹ iphe, bụ eghu, deberu iphe edebe; mẹ ọphu tụru iphe poopoo. Ndu onanu a-bụru aswa ozi iya. ");
INSERT INTO iqw_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","O -rua l'ụzo ifu bẹ ịi-ma-a mẹ ya bụ onye ire-lanụ. Teke ịi-bya ọphu elu ndu onanu, i gude kfụa ya ụgwo ozi iya ono; ọ -bụru l'ị phụru iya eghu, ẹ ta atụdu iphe poopoo; ọ dụdu bụru ọphu ẹ te edebedu iphe edebe; m'ọ bụ nwatụru ọphu ẹ te ejidu uji; malẹruphu l'ọ bụ ezita bẹ ya zitaru iya.” ");
INSERT INTO iqw_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lébanu ekweta; sụ iya tọ dụ ẹge ono, o kfuru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mbọku ono gẹdegede bẹ Lébanu tụgburu je afọshikota mkpi, dengashiru iphe edengashi; ndu ọphu debetsuaru iphe edebe; ndu ọphu tụru iphe poopoo; mẹ nebyi eghu ndu ọphu tụshiru iphe ọcha; ọwaa iphe bụ ụnwu atụru ndu ọphu eji uji; chịru iya nụ ụnwu iya t'ẹphe cheje. ");
INSERT INTO iqw_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yọ chịta elu ono tụgbua. Iphe o jeru ije bụ abalị ẹto b'o jeruru ẹke ooje, bụkwanu ẹke yẹle Jékọpu a-nọdu onwẹphe ote-ẹnya. Jékọpu anọdu l'ẹke ono, ọ gharu iya ono chelahaaru iya eghu ndu ọphu ọ chị-phodoru. ");
INSERT INTO iqw_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jékọpu abya egbuta ẹkali-oshi pọpula onyingu; mẹ oshi alụmondu; mẹ oshi pulenu. Yọ bya aswashịa ẹkali-oshi ono ụ̀gbò; mee ya; yọ dụ l'a kashịru iya iphe ọcha. ");
INSERT INTO iqw_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yọ bya achịta ẹkali-oshi ono, ọ swashịru ụ̀gbò ono yetsua l'ochi, elu angụje mini; dobe iya ẹge ọo-nọduje ẹphe nhamụnha l'ifu teke ẹphe byaru ọngu mini; kẹ l'ọ bụ teke ono, ẹphe byaru ọngu mini ono bẹ ẹphe agbajẹ l'òkéé. ");
INSERT INTO iqw_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Yọo bụje; teke ẹphe nọ l'ifu ẹkali-oshi ono gbaa l'òkéé; ẹphe -bya amụ nwa; ẹphe amụshia ndu ọphu dengashiru iphe edengashi; ndu ọphu tụshiru iphe poopoo; mẹ ndu ọphu debetsuaru iphe edebe. ");
INSERT INTO iqw_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jékọpu abya afọshia ụnwu elu ono dobe iche; bya achịru ndu ọphu yeru ndu ọphu dengashiru iphe edengashi; mẹ kẹ ojingu yeru ndu kẹ Lébanu l'ifu. Yo shiwaphu ẹge ono nweru elu k'ẹka iya; t'ọ chịkobejehe iya lẹ kẹ Lébanu. ");
INSERT INTO iqw_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yọo bụje teke ndu ọphu bụ nyee ya, shihuru ike byaru ọgba l'òkéé; Jékọpu achịta ẹkali-oshi ono yetsua l'ochi, elu ono angụje mini; dobetsua ẹge ifu ẹphe l'iya e-chekotsua; k'ọphu ẹphe a-nọduje l'iku ẹkali-oshi ono gbaa l'òkéé. ");
INSERT INTO iqw_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Teke ọ bụru elu ndu ọphu dụ nyẹgenyege; too dobeduru ẹphe ẹkali-oshi ono. E shiwaphu ẹge ono; elu ndu ọphu dụ nyẹgenyege alaaru Lébanu; ndu ọphu shihuru ike alaaru Jékọpu. ");
INSERT INTO iqw_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ya ndono; Jékọpu eshiwaphu ẹge ono báhụ́; bụru ụbabanyi; nwee elu igweligwe; gbashịa ohu: ndu k'ụnwanyi mẹ ndu k'unwoke; bya enweshia ịnya-ivu; mẹ nkakfụ-ịgara. ");
INSERT INTO iqw_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","A nọnyaa; Jékọpu anụlahaa l'ụnwu Lébanu ekfu l'ọ jịkowaru iphe, nna ẹphe nweru chịta; l'iphemiphe ọbule ono, o nweru ono bụkota ẹku nna ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jékọpu abya aphụkwaaphu l'ẹ tọ bụhedu umere, Lébanu shi emejeru iya b'o mekwaduru iya. ");
INSERT INTO iqw_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ya ndono; Ojejoje asụ Jékọpu: “Tụgbua lakfu ndibe unu l'alị nna ngu phẹ. Ya a-nọ-ọ swiru ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tọ dụ iya bụ; Jékọpu abya ezia t'e je ekuaru iya Rechẹlu yẹle Lii t'ẹphe byakfuta iya l'ẹgu l'ẹke elu iya nọ. ");
INSERT INTO iqw_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ẹphe erua; yọ sụ ẹphe: “Lẹ ya phụwaru l'ẹ tọ bụhedu ẹge nna unu shi emejeru iya umere bẹ oomeru iya ẹya nta-a. Ọbule Nchileke kẹ nna iya bẹ swiru iya-a. ");
INSERT INTO iqw_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Unu makọtaru-a lẹ ya gude ike iya l'ọ ha jeeru nna unu ozi. ");
INSERT INTO iqw_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","E megee; nna unu ekputale iya-a; gbanwee aswa ozi iya ugbo iri. Obenu lẹ Nchileke te kwekwanu t'o merua ya ẹhu. ");
INSERT INTO iqw_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ọobuje; ọ -sụ l'ọo elu ndu ọphu tụru iphe poopoo bụ aswa ozi iya; elu ono -bya ọmu ụnwu; yọ mụshikota ụnwu, tụru iphe poopoo. Teke ọ sụru l'ọ bụ ndu ọphu dengashiru iphe edengashi a-bụru aswa ozi iya; elu ndu onanu -bya ọmu ụnwu; yọ mụshilephu ụnwu, dengashiru iphe edengashi. ");
INSERT INTO iqw_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ọo ya bụ; l'ọ bụ Nchileke rutaru elu nna unu nụ yẹbedua. ");
INSERT INTO iqw_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Oge teke elu agbajẹ l'òkéé; bẹ ya rọjeru nrọ; phụa mkpi ndu ọphu dengashiru iphe edengashi; phụa ndu ọphu tụru iphe poopoo; mẹ ndu ọphu deberu iphe edebe; l'ẹke oochi ndu ọphu. ");
INSERT INTO iqw_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ojozi Nchileke abya ekua ya lẹ nrọ ono; sụ iya: ‘Jékọpu!’ Ya aza iya. ");
INSERT INTO iqw_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Yọ sụ iya: ‘Paliduduphu ẹnya apali; phụ lẹ mkpi ono, echikota elu ono bẹ bụkota mkpi, dengashiru iphe edengashi; ndu ọphu tụru iphe poopoo; mẹ ndu deberu iphe edebe. Iphe kparu iphe ọ dụ ẹge ono bụ lẹ ya phụwaru iphe Lébanu eme ngu. ");
INSERT INTO iqw_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ọ bụ yẹbedua bụ Nchileke kẹ Bẹ́telu. Bẹ́telu bụ ẹke ono, ị wụru manụ l'eli mkpuma; bya abụru ẹke ono, i kweru yẹbe Nchileke ụkwa ono. Gbeshilekwaphu nta-a lụfu l'alị-a; la ẹke, a mụru ngu.’ ” ");
INSERT INTO iqw_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tọ dụ iya bụ; Rechẹlu yẹle Lii abya eyeeru iya ọnu; sụ iya: “?O nwekwaduru òkè, gbaru ẹphe l'iphe nna ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","?Nna ẹphe ta agụbedua ẹphe ndu ọhodo. Ẹ t'ọ bụlekwa l'e reru ẹphe erere; obenu l'okpoga, a kwaru l'ishi ẹphe b'ọ kpaphushiwaru. ");
INSERT INTO iqw_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","O doru ẹnya l'iphe, bụ ẹku ono, Nchileke nataru nna ẹphe ono; bẹ bụ nk'ẹphe; mẹ k'ụnwu ẹphe. Ọo ya bụ t'i mee iphe, bụ iphe, Nchileke sụru t'i mee!” ");
INSERT INTO iqw_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Tọ dụ iya bụ; Jékọpu abya achịta ụnwu iya; mẹ unyomu iya ye l'eli ịnya-ivu; ");
INSERT INTO iqw_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","bya achịru elu iya l'ọ ha yee l'ifu; mẹ l'iphemiphe ọbule, o setakotaru lẹ Padanu Áramu; yọ bụru ẹphe ọla kẹ nna iya, bụ Áyizaku l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Teke Lébanu jeru tẹ ya je ebyishia atụru iya ẹji bẹ Rechẹlu jeru je ezikoo ụnwu ntẹkpe nna iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jékọpu agbakpuru Lébanu, bụ onye Áramu l'akọ; kẹ l'ẹ to kfuduru iya lẹ ya abyawa agbala. ");
INSERT INTO iqw_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yọ chịta iphemiphe ọbule, o nweru gbalaa; je adaa Ẹnyimu Yufurétusu; tụgbua ụzo, nọ l'e gude eje l'alị ugvu Gíledu. ");
INSERT INTO iqw_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ya ndono; yo be mbọku k'ẹto k'ọphu Jékọpu gbalaru; ama eje agbaaru Lébanu lẹ Jékọpu gbalaakwaru. ");
INSERT INTO iqw_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yọ chịtawaphu ndu abụbu iya; ẹphe achịru Jékọpu tụgbua. Yo be lẹ mbọku k'ẹsaa ya; ẹphe agbakfu iya l'alị ugvu Gíledu. ");
INSERT INTO iqw_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Obenu lẹ Nchileke byakfutaru Lébanu, bụ onye Áramu lẹ nrọ l'ẹnyashi; sụ iya: “T'ọ kwabẹnuphu ẹnya: t'ẹ b'ọ dụkwa iphe, oo-kfuru nụ Jékọpu! T'ẹ b'o kfukwaru iya k'ọma; to kfuru iya k'ẹjo iya!” ");
INSERT INTO iqw_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Teke Lébanu chị-kfuru Jékọpu bẹ Jékọpu gvubewaru ụlo-ẹ́kwà iya l'alị ugvu Gíledu. Lébanu yẹle ndu abụbu iya ono ẹphe l'iya yị ono abya egvukwaaphu ụlo-ẹ́kwà nk'ẹphe l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lébanu asụ Jékọpu: “?Bụ ngụnu b'i meru iya ẹge-a; gude ụgho; chịta ụnwu iya, ya keru ngu l'ọ bụ ndu a lụtaru l'ọgu? ");
INSERT INTO iqw_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","?Bụ ngụnu meru iphe ị ghọru iya ụgho; gbalaa l'edomi? ?Bụ ngụnu kparu iphe ẹ ti kfuduru iya ẹya; k'ọphu ya ga egude ẹhu-ọtso-ẹna; gude egvu; mẹ nkwa; mẹ une dua unu? ");
INSERT INTO iqw_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nggu emee tẹ ya ba anma ụnwunwa iya; mẹ ụnwegirima ono, ya keru ngu ono akpa; sụ ẹphe t'ẹphe lawaru. I mekwaru umere onye eswe. ");
INSERT INTO iqw_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ya ga emekwa ngu iphe; ọ kwa-a lẹ Nchileke kẹ nna ngu bẹ byakfutaru iya nụ lẹ nrọ l'ẹnyashi; sụ iya: ‘Tẹ ya kwabẹnuphu ẹnya: t'ẹ b'ọ dụkwa iphe, ya e-kfuru nụ ngu! Tẹ ya be ekfukwaru ngu k'ọma; ya te ekfuru ngu k'ẹjo iya!’ ");
INSERT INTO iqw_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nta-a b'ị tụgburu alala; kẹ l'obu ufu nna ngu dụwa ngu. Ọ bụ; ?bụ ngụnu kparu iphe i zitaru ụnwu ntẹkpe iya.” ");
INSERT INTO iqw_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jékọpu asụ Lébanu: “L'ọ kwa égvù bẹ ya shi atsụ; kẹle ya rịru l'ịi-nata iya ụnwu ngu ono, i keru iya ono k'ẹhuka. ");
INSERT INTO iqw_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","A bya lẹ k'ụnwu ntẹkpe ngu; ọ -bụru l'ị phụru onye gude iya nụ bẹ ndzụ ta aphọdukwaru onye ọbu. Nta-a kwa t'ị nọdu l'ifu ndu abụbu ayi-wa; gude ẹka ngu chọo t'ị maru; ?o nweru iphe ngu, ya gude? O -nweru ọphu i phụru; nggu ewota iya!” Jékọpu ta ma lẹ Rechẹlu zikoru ụnwu ntẹkpe ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tọ dụ iya bụ; Lébanu abya abahụ l'ụlo-ẹ́kwà Jékọpu; mẹ kẹ Lii; mẹ k'ụnwanyi labụ ono, ejeru unyomu iya ozi ono; chọkota iya; ọphu ọ dụdu iphe, ọ phụru. Yo shi l'ụlo-ẹ́kwà Lii bahụ lẹ kẹ Rechẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ama lẹ Rechẹlu bẹ woru ụnwu ntẹkpe ono nwua l'iphe, aanọduje anọdu l'eli ịnya-ivu; nọpyabe iya. Lébanu abya achịko iphe, nọ l'ụlo-ẹ́kwà ono vọshia avọshi; tọ dụ iphe ọ phụru. ");
INSERT INTO iqw_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rechẹlu asụ nna iya ono: “Onye nwe mu nụ; t'ẹ b'o ghukwa ngu eghughu; lẹ ya te gbeshidu egbeshi l'ị byaru-a; ọ kwa nsọ eme iya.” Lébanu ekwe iya; bya achọo ụnwu ntẹkpe ono nta; chọo ya imo; tọ phụ iya. ");
INSERT INTO iqw_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iphe awata oghu Jékọpu eghughu; yọ sụ Lébanu: “?Bụkpo awe bẹ ya mesweru ngu ono?” Mbụ; “?bụ egbe ẹjo iphe ngụnu bẹ ya mekpooru, kparu iphe ịichi iya kẹ kparakpara ẹge-a? ");
INSERT INTO iqw_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nta-a, ị tụkowa iphe iya vọo avọvo-a; ?bụ ngụnu b'ị phụru, bụ nke ngu, nọ iya nụ. Ọ -bụru l'o nweru iphe ị phụru; wofuta nụ iya l'ifu ndibe unu-a mẹ ndu nk'iya-a; t'ẹphe kfua onye achọ ibe iya okfu lẹ nggu l'iya! ");
INSERT INTO iqw_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“L'ime ụkporo afa-a, nggu lẹ iya buru-a; ?o nweru atụru ngu; mẹ eghu ngu m'ọo nanụ, phejeru nwa. ?Tẹ ya wotajeru anụ ebyila ngu m'ọo nanụ taa. ");
INSERT INTO iqw_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ọ -bụru l'o nweru elu ngu ọphu anụ-ẹgu-ẹgbudu taru; ?ya vulatajeru ngu odzu iya; ?tọ bụdu yẹbedua gẹdegede bẹ ọobujeru ụsu sụa. Iphe bụ iphe ngu, e zitaru l'eswe; m'ọ bụ l'ẹnyashi: ?o nweru ọphu ẹ tịi sụjedu tẹ ya kfụa ngu ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lewaru iphe yẹbe Jékọpu shi ejeje: Anwụ shi egheje iya egheghe l'eswe; oyi eshi abyajẹ iya atsụ-gbu l'ẹnyashi; mgbẹnya te edzubua ya. ");
INSERT INTO iqw_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ọ bụ ẹge ono bẹ ya jekotaru ngu iya ụkporo afa ophu. L'ime ụkporo afa ono bẹ ya gude afa iri l'ẹno jeeru ngu ozi l'ishi ụnwu ngu ẹphe ẹbo. Afa ishingu ọphu phọduru nụ bẹ ya gude cheeru ngu elu ngu. Ụgwo ozi yẹbe Jékọpu b'i gbanweru ugbo l'ugbo iri. ");
INSERT INTO iqw_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ndẹge Nchileke kẹ nna mu; mbụ Nchileke kẹ Ébirihamu; mbụ onye Áyizaku atsụ egvu ta anọru swiru mu; m'ị gbabẹ mu ẹka ọtu; chịa mu. Obenu lẹ Nchileke phụwaru ntakfuru, mu eje; mẹ ẹge mu esetabe akanya, kparụ iphe ọ baru ngu mba l'ẹnyashi ụnyaphua.” ");
INSERT INTO iqw_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lébanu asụ Jékọpu: “Ụnwanyi-a kwa ụnwu mu; ụnwegirima-a abụru ụnwegirima mu; elu-a abụkotaru elu mu. Iphemiphe ọbule-a, iile ẹnya-a l'ọ ha bụkota nke mu. Ọ bụ; ?bụ ngụnu bẹ mu e-me l'okfu ẹhu ụnwu mu-a; mẹ ụnwegirima-a, ẹphe mụshiru-a. ");
INSERT INTO iqw_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ngwa-a; bya t'ayi gbaa ndzụ t'ọ bụru ekebe nọduru nggu l'iya!” ");
INSERT INTO iqw_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tọ dụ iya bụ; Jékọpu abya apata mkpuma gvube; yo gvuru l'ọ bụ itso. ");
INSERT INTO iqw_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yọ sụ ndibe ẹphe ono t'ẹphe kpakọo mkpuma. Ẹphe abya akpaa mkpuma kụbe. Ẹphe anọdu l'iku ikpo mkpuma ono ria nri. ");
INSERT INTO iqw_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lébanu agụa ẹke ono Jega Sahaduta; Jékọpu agụa ya Gálidu. ");
INSERT INTO iqw_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lébanu asụ: “Ikpo mkpuma-a bẹ bụ ekebe nggu l'iya ntanụ-a.” Ọ bụ iya kparu iphe a gụru iya Gíledu ");
INSERT INTO iqw_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","E kukwaru iya phụ Mizúpa kẹ l'ọ sụru: “Tẹ Ojejoje chejekwa ẹphe nche teke ẹphe gbakahụtsuaru tụgbua. ");
INSERT INTO iqw_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","I -mee ụnwu mu-a ẹji; ọ dụdu bụru l'i jeru je alụa ụnwanyi ọdo; a gụfu ẹphe ẹbo; a makwaru-a l'ẹ tọ nwedu onye, ayi ẹya nọ l'ẹke-a; ọ bu; nyatakwa lẹ Nchileke bụ onye ekebe nggu l'iya.” ");
INSERT INTO iqw_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lébanu asụkwaphu Jékọpu: “Ọwaa bụ ikpo mkpuma-a; mẹ itso-mkpuma-a, ya kpọberu t'ọ nọkahu nggu l'iya. ");
INSERT INTO iqw_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ikpo mkpuma-a bụ iphe ekebe. Ẹge ono kwaphu bẹ itso mkpuma ono bụ iphe ekebe l'ẹke nggu l'iya nọ. Ya te eswetakwa ikpo mkpuma-a bya ọcho iphe e-me ngu nụ l'ẹka iya ọphu. Ọphu nggụbedua 'eswetakwanu ikpo mkpuma ono; mẹ itso mkpuma ono bya ọcho iphe e-me mu nụ. ");
INSERT INTO iqw_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Tẹ Nchileke kẹ Ébirihamu, bụ Nchileke kẹ Nahọ; bụkwaruphu Nchileke kẹ nna ẹphe kpee nggu l'iya ikpe!” Tọ dụ iya bụ: Jékọpu abya egude ẹpha Nchileke ono, nna iya, bụ Áyizaku atsụ egvu ono riaru iya angụ lẹ ya ta adakadu ndzụ ono, ẹphe gbaru ono. ");
INSERT INTO iqw_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jékọpu abya anọdu l'eli ugvu ono gwoo ẹja; bya ekukoo ndu abụbu iya; ẹphe abya eria nri. Ẹphe eriebetsua nri ono; jịko radụ l'ẹke ono l'ẹnyashi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Yo be l'ọnmewa ụtsu; Lébanu abya anmatatsụa ụnwunwa iya; mẹ ụnwu iya ono akpa; bya agọoru ẹphe ọnu. Yo metsua; laphushia azụ l'ufu iya. ");
INSERT INTO iqw_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jékọpu atụgbua; yọ bụru iya alala. Yo jenyaa; ụnwu ojozi Nchileke awụ-kfuta iya. ");
INSERT INTO iqw_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jékọpu aphụlephu ụnwu ojozi ono; sụ: “Ha! Ẹke-a bụkwa ọdu ndu sọja Nchileke!” Yọ gụa ẹke ono Mahanayimu. ");
INSERT INTO iqw_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jékọpu abya eyefu ndu ozi iya t'ẹphe vuru iya ụzo jekfu nwunne iya; mbụ Ị́so lẹ Séyi l'alị Édọmu. ");
INSERT INTO iqw_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yo zia ẹphe; sụ: “Ọwaa iphe, unu e-kfuru nnajiufu iya; mbụ Ị́so. Unu sụ iya lẹ nwozi iya; mbụ Jékọpu sụru l'ọ bụ l'ẹke Lébanu bẹ ya shi keshinu ono butaru jeye nta-a. ");
INSERT INTO iqw_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Lẹ nta-a bẹ ya nwewaru eswi; nweru nkakfụ-ịgara; nweru atụru; mẹ eghu; nweru ohu: unwoke l'ụnwanyi. Ya eyefu ndu ozi iya-a t'ẹphe byakfuta nggụbe onye nwe mu nụ t'a maru; ?m'i kwee tẹ ya bata?” ");
INSERT INTO iqw_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ndu ozi ono ejeebe; lata bya asụ Jékọpu: “L'ẹphe jekfukwaru nwunne ngu ọbu; mbụ Ị́so. Lẹ nta-a b'ọ chịkwa ụnu madzụ l'abya ngu ndzuta.” ");
INSERT INTO iqw_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Meji atọfu Jékọpu; yọ tsụlahaa egvu. Yọ bya ekekahu ndu yẹle iya yị uzi labụ; bya ekee atụru iya; eghu iya; eswi iya; mẹ ịnya-ivu iya uzi ẹbo ẹbo kwaphu. ");
INSERT INTO iqw_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yọ rịa; sụ: “Teke ọ -bụnuru lẹ Ị́so byaru bya etso uzi lanụ ọgu; t'uzi lanụ ọphu phọduru nụ gbalaa.” ");
INSERT INTO iqw_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jékọpu abya ekfuru nụ Nchileke; sụ iya: “Nggụbe Nchileke kẹ nna mu oche, bụ Ébirihamu; Nchileke kẹ nna mu, bụ Áyizaku; nggụbe Ojejoje; onye sụru tẹ mu lashia azụ l'alị, a mụru mu; lakfu abụbu mu phẹ; l'ii-me-e t'iphe dụru mu lẹ mma; ");
INSERT INTO iqw_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","mbụ mụbe onye ta agbadu kẹ t'i meeru mu ọhuma ono, i mekotaru mu ono; ọphu mu 'adụkpodua nụ kẹ t'i mekotaru mu iphe ono, i kwekotaru mu ụkwa, l'ii-meru mụbe nwozi ngu ono. Teke mu daru Ẹnyimu Jọ́danu-a; bẹ bụ mgbọro bẹ mu kpakfụ. Obenu lẹ nta-a bẹ mu jakawaru ọkpa ụzo labụ. ");
INSERT INTO iqw_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ya ekfu anụ ngu sụ t'ị dzọta iya l'ẹka nwunne iya Ị́so; kẹle ya atsụ egvu l'ọo-bya bya afụaru iya; mẹ ụnwanyi iya-a; mẹ ụnwegirima ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Obenu l'i kfuru sụ l'ii-me t'iphe dụru mu lẹ mma; mekwaaphu t'awa mu ha l'igwe l'ọ bụ eveve mgbogidi ẹnyimu; bụru 'agụta agụta.” ");
INSERT INTO iqw_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yọ radụ l'ẹke ono l'ẹnyashi ono. Yọ bya eshi l'iphe ono, o nweru ono fọta iphe, oo-gude meeru Ị́so iphe-ọma. ");
INSERT INTO iqw_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Iphe, ọ fọtaru bụ: ụkporo nne eghu iri; ụkporo mkpi; ụkporo nne atụru iri; ọwaa ụkporo ebyila. ");
INSERT INTO iqw_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Yọ bya afọtakwaphu ụkporo nne ịnya-ivu; lẹ nne ịnya-ivu iri yẹle l'ụnwu iya; ụkporo nne eswi ẹbo; oke eswi iri; ụkporo nne nkakfụ-ịgara; mẹ oke nkakfụ-ịgara iri. ");
INSERT INTO iqw_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Jékọpu edokota elu ono iche l'iche; yeshia ndu ozi iya t'ẹphe switsuaru iya iche iche. Yọ sụ ẹphe: “T'ẹphe vuru iya ụzo tụgbua! Wo ẹphe t'ephe tụshiaru onwẹphe ụbara; t'ẹ b'ọ dụ onye yẹle k'ibe iya a-tụgbabe.” ");
INSERT INTO iqw_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yọ sụ onye ọphu vu ụzo: “Ọ -bụru l'unu lẹ nwunne iya; mbụ Ị́so dzudaru; yọ jị ngu: ‘?Unu bụ ndibe onye? ?bụ awe bẹ unu eje? ?bụ onye nwekota elu-a, kụru unu l'ifu-a;’ ");
INSERT INTO iqw_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","unu sụ iya: ‘L'ọ kwa nwozi iya; mbụ Jékọpu nwe iya. Ọle ọ kwanu iphe ọ nụru t'e wotaru onye nwe mu nụ Ị́so; lẹ yẹbedua abyakwa-a; ọbu l'ọ nọkwadua l'ụzo azụ.’ ” ");
INSERT INTO iqw_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yo kfukwaruphu ndu k'ẹbo; ndu k'ẹto; mẹ iphe, bụ ẹge ẹphe hakọta, etso elu ono: “L'ọ kwaphu iphe ono ya kfuru ono bẹ unu e-kfukotaru Ị́so teke unu l'iya dzudaru. ");
INSERT INTO iqw_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ọlobu; unu nyatakwa sụ iya lẹ nwozi iya; mbụ Jékọpu abyakwa-a.” Iphe Jékọpu rịru bụ l'iphe ono, ya nụru; yo vuta ụzo ono e-mee Ị́so t'obu jizita iya; k'ọphu bụ teke Ịso phụru iya; t'o kweru nata iya. ");
INSERT INTO iqw_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tọ dụ iya bụ; e rutakota iphe ono, o gude eje ome iphe ọma ono; ẹphe evuru iya ụzo tụgbua; yẹbedua, bụ Jékọpu aradụ l'ọdu ẹphe l'ẹnyashi ono. ");
INSERT INTO iqw_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Jékọpu abya eduta unyomu iya ẹphe ẹbo l'ẹnyashi ono; duta ụnwanyi labụ ono, e deru iya t'ẹphe jejeru unyomu iya ozi ono; dutakwaphu ụnwegirima nk'iya ẹphe iri lẹ nanụ; duta ẹphe je adaa Ẹnyimu Jábọku dafụ azụ iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yo dughatsua ẹphe ẹnyimu ono; latashia azụ bya egwotakota iphemiphe ọbule, o nweru gwofu azụ ẹnyimu ono azụ iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tọ dụ iya bụ; Jékọpu anọdu l'ẹke ono nwẹnkinyi iya. Yo nweru nwoke lanụ, byaru nụ yẹle iya agbalẹphu mgba jeye nchi abụru pẹtekengu. ");
INSERT INTO iqw_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nwoke ono abya amaru lẹ ya te egudeghedu Jékọpu; woru ẹka byia ya l'ọkpu-nka l'ẹphe agbakwadụa mgba ono; nka agbụfu iya. ");
INSERT INTO iqw_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yọ sụ Jékọpu t'ọ haa ya tẹ ya la; lẹ nchi abyawa abọhu! Jékọpu asụ iya “Lẹ ya ta ahakwa iya t'ọ la; gbahaa l'ọ gọru iya ọnu.” ");
INSERT INTO iqw_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nwoke ono ajị iya ẹpha iya. Yọ sụ iya l'ẹpha iya bụ Jékọpu. ");
INSERT INTO iqw_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nwoke ono asụ iya l'ẹpha iya ta abụhedu Jékọpu. Iphe ọo-bụ bụ Ízurẹlu; kẹle yẹle Nchileke ghawaru iya; yẹle madzụ aghaa ya; yo mekputakota. ");
INSERT INTO iqw_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jékọpu asụ iya: “Byiko; t'ọ kọnuaru iya ẹpha iya.” Nwoke ono ajị iya: “?I gude ẹpha iya eme ngụnu?” Yọ bya agọoru Jékọpu ọnu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ya ndono; Jékọpu agụa ẹke ono Penuwẹlu; sụ: “Lẹ yẹle Nchileke phụru ifu l'ifu; ya anọdukwadua ndzụ.” ");
INSERT INTO iqw_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jékọpu eswedelephu Penuwẹlu; ẹnyanwu-ahata-wa. Yo gbe etewa nụ ọkpa; lẹ k'ọkpu-nka ono, a gbụfuru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ọ bụ iphe ono kparu iphe ndu Ízurẹlu ta atajẹdu ájị́, likfuru l'ẹnu nka; mbụ jeye ntanụ ọwaa; kẹ l'ọ bụ l'ẹke ájị́ anọje l'ẹnu nka b'e byiru Jékọpu ẹka ono. ");
INSERT INTO iqw_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jékọpu apalia ẹnya; phụa Ị́so yẹle ụnu madzụ, ọ chị abya. Yọ bya achịta ụnwegirima iya keeru Lii yẹle Rechẹlu; mẹ ụnwanyi ẹbo phụ, bụ ndu ejeru unyomu iya ozi phụ. ");
INSERT INTO iqw_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yọ bya achịru ụnwanyi ẹbo ono, bụ ndu ejeru unyomu iya ozi ono yẹle ụnwu ẹphe ye l'ụzo ifu. Yọ bya edobe Lii yẹle ụnwu iya l'azụ ndu ọphu; bya edobe Rechẹlu yẹle Jósẹfu; ẹphe ekpechi azụ. ");
INSERT INTO iqw_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yẹbedua evutaru ẹphe ụzo. Yo jekfudelephu nwunne iya ono; bya ebyiaru iya ikpere ugbo ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ya ndono; Ị́so agbakfube iya; je atụ iya gbirimu; gbakụa ya ẹka l'olu; nmaa ya akpa; bya etsua ya ọnu. Ẹphe ẹbo ajịko wata ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ịso abya apalia ẹnya; phụa ụnwanyi ono yẹle ụnwegirima ono; bya ajị ya: “?Bụ ndu ole; mbụ ndu ọwaa, nggu l'ẹphe yị-a?” Jékọpu asụ iya: “L'ọ kwa ụnwegirima, Nchileke gude k'eze-iphe-ọma nk'iya nụ yẹbe nwozi ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ụnwanyi labụ phụ, ejeru unyomu iya ozi phụ yẹle ụnwegirima ẹphe abyaruta; bya efooru iya ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lii yẹle ụnwegirima nk'iya abyakwaphu bya efokwaaru iya phụ ifu l'alị. Jósẹfu yẹle Rechẹlu abyakpe azụ bya efokwaaru iya phụ ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ịso ajị iya: “Igweligwe elu phuu, yẹle iya dzuru l'ụzo phụ; ?bụ kẹ ngụnu?” Jékọpu asụ iya l'ọo iphe, ya gude eme t'obu dụ nggụbe onye nwe mu nụ mma l'ẹke ya nọ. ");
INSERT INTO iqw_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ị́so asụ iya: “Nwunne mu; mẹ ya gbe nweekwaru iphe nshinu; wotaru iphe ngu nweru.” ");
INSERT INTO iqw_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jékọpu asụ iya: “Wawakwa! Ọ -bụru lẹ ya bụphu nwunne ngu l'oswiya; natanu iphe-a, ya nụru ngu-a! L'ẹge i shiru nabata iya bẹ ifu ngu dụlekwa iya phụ l'ọ bụ ifu Nchileke. ");
INSERT INTO iqw_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Byiko; t'ọ nataru iphe ono, ya wotaru iya ono; kẹle Nchileke meekwaru iya eze-iphe-ọma; ya enwekotawa iphemiphe ọbule, mkpa iya dụru iya.” Jékọpu arọnyaa ya; yo kwa nata iya. ");
INSERT INTO iqw_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ịso asụ: “Unu t'ayi la! Yẹbedua e-vutaru unu ụzo.” ");
INSERT INTO iqw_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jékọpu asụ iya: “Onye nwe mu nụ; ị marua l'ụnwegirima-a te shihudua ike ọhuma. Ọdo abụru lẹ ya eme tẹ ya leta atụru-a; mẹ eswi ndu ọwaa, mụshiru ụnwu k'ọphungu-a ẹnya; kẹ l'e -gude ike chịta iya ẹge ono tụgbua; mbụ-a m'ọo ujiku lanụ bẹ ẹphe a-nwụshihukotakwa. ");
INSERT INTO iqw_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ọo ya bụ; onye nwe mu nụ; vururu yẹbe nwozi ngu ụzo tụgbua. Yẹbedua a-tọkpelephu nwẹhu l'etso elu-a; mẹ ụnwegirima-a gbururu jeye ya abyakfuta ngu lẹ Séyi.” ");
INSERT INTO iqw_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ị́so asụ iya: “Tẹ ya hanụru unwoke ndu nk'iya haaru iya t'ẹphe l'ẹphe yịru.” Jékọpu asụ iya: “T'ọ haaru. L'iphe, bụ iphe dụ iya mkpa bụphu tẹ nggụbe onye nwe mu nụ kweru nabata iya l'oswiya.” ");
INSERT INTO iqw_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tọ dụ iya bụ; Ị́so egbeshi mbọku ono; yọ bụru iya ọla Séyi. ");
INSERT INTO iqw_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jékọpu aswịa ya lẹ Súkọtu. Yo rua Súkọtu bya akwata ufu buru l'ẹke ono; bya atụshiaru elu iya mkpu. Ọ bụ iya meru iphe eeku ẹke ono Súkọtu. ");
INSERT INTO iqw_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jékọpu eshi lẹ Padanu Áramu; laruta Shékemu l'alị Kénanu; to nwe iphe meru iya nụ. Ị -nọdu l'ọdu ẹke ẹphe nọ; nggu ele mkpụkpu ono ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yo gude ụkporo mkpọla-ọcha ise zụta ụnwu Hamọ alị ẹke o gvuberu ụlo-ẹ́kwà iya. Hamọ ono bụ iya bụ nna Shékemu. ");
INSERT INTO iqw_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yọ bụru l'ẹke ono b'ọ kpụru ẹnya-ngwẹja; kua ya Elu-Elohe kẹ Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yo be ujiku lanụ; Dayina bụ, nwata mgbọko, Lii mụtaru Jékọpu akpafushia ụri l'ẹke ụnwanyi alị ono. ");
INSERT INTO iqw_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shékemu aphụa ya; gude iya k'ẹhuka; raa; shi ẹge ono mebyishia ya. Shékemu ono bụ nwatibe Hamọ; onye Hevu, bụ eze achị ọnu-ogo ono. ");
INSERT INTO iqw_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nwatibe Jékọpu ono; mbụ Dayina atsọmahu Shékemu; yọ bya eyeru iya obu; swalahaaru iya aswaru. ");
INSERT INTO iqw_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ya ndono; Shékemu asụ nna iya; mbụ Hamọ t'ọ lụaru iya nwamgbọko ono t'ọ bụru nyee ya. ");
INSERT INTO iqw_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Tọ dụ iya bụ; Jékọpu abya anụa lẹ nwatibe iya; mbụ Dayina b'e gudekwaru k'ẹhuka; fatọshia; kwe nọ-kirishia nwandoo jeye ụnwegirima iya ndu k'unwoke eshi l'ẹke ẹphe shi nọdu eche elu lata. ");
INSERT INTO iqw_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ya ndono; Hamọ, bụ nna Shékemu atụgbua jeshia tẹ yẹle Jékọpu kfugba. ");
INSERT INTO iqw_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ụnwu Jékọpu anụlephu iphe ono, meru nụ ono; wụ-latashia. Ndụmashi; mẹ ẹhu-eghughu eji ẹphe obu; kẹle Shékemu meru ndu Ízurẹlu iphe-iphere l'ọ raru nwatibe Jékọpu, bụ iphe, ẹ ta gbadu t'o mee. ");
INSERT INTO iqw_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamọ asụ ẹphe: “Lẹ nwatibe iya-a; mbụ Shékemu bẹ obu iya dụkwa l'ẹke nwatibe unu-a nọ. Byiko; unu kenua yẹ ẹya t'ọ lụa. ");
INSERT INTO iqw_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","T'unu l'ẹphe lụgbaje nụ nwanyi: mbụ t'unu kejee ẹphe nwanyi; ẹphebedua ekee unu. ");
INSERT INTO iqw_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ọ -bụru l'ọ dabaru unu l'obu; unu eburu l'alị ayi l'ẹke-a. Alị b'ẹ te gbe achọdu achọcho. Ọ -bụru nghọ; unu agba iya. Ọ -bụru alị; unu azụshia ya.” ");
INSERT INTO iqw_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shékemu asụ nna Dayina; mẹ unwunne iya: “Unu kweru t'unu l'ẹphe gbaru. Iphe, bụ iphe unu sụkpooru tẹ ya nụ unu bẹ ya a-nụkwa unu. ");
INSERT INTO iqw_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Unu kfua iphe, ya a-kwaru unu lẹ nwada unu; unu ekfukwaaphu iphe, ọ dụ unu tẹ ya meeru unu. Iphe, bụ iphe, unu sụru tẹ ya kwaa bẹ ya a-kwaru unu. Ọ bụlephu t'unu kee ya nwamgbọko ọwaa tẹ ya lụa.” ");
INSERT INTO iqw_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ụnwegirima Jékọpu abya oyeru Shékemu yẹ nna iya mbụ Hamọ ọnu; woru akọ ye iya; okfu k'egude ono, e guderu nwunne ẹphe mebyishia ono. ");
INSERT INTO iqw_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ụnwegirima Jékọpu ono asụ ẹphe: “Tụswekwa! L'ẹphe te ewotakwa nwunne ẹphe kee onye akpapyị. Ọo-bụkwaru ẹphe iphe-iphere mẹ ẹphe -mee ya. ");
INSERT INTO iqw_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ẹge ee-me iya; ẹphe ekweta bụ t'unu wata ome l'ọ bụ ẹphebedua: mbụ t'iphe, bụ nwoke l'unubẹdua buje ugvu. ");
INSERT INTO iqw_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Teke ono; unu l'ẹphe alụgbalahaa nwanyi. Teke ono kwaphu; unu l'ẹphe abya ebua ẹghirigha; ghọo ndu lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ọlobu; ọ -bụru l'unu te ekwedu ẹge ono, ẹphe kfuru ono; bushia útsù; bẹ ẹphe e-dutakwa nwunne ẹphe lashia.” ");
INSERT INTO iqw_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Iphe ono, ẹphe kfuru ono adụ Hamọ yẹle nwatibe iya Shékemu mma. ");
INSERT INTO iqw_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nwokorọbya ono, bụ iya b'a kakọta ọkwabe ugvu l'ufu nna iya ono te emekpodua mbekwa l'iphe ono, ẹphe kfuru iya ono; kẹle nwatibe Jékọpu ono bẹ dụ l'iya phụ mma. ");
INSERT INTO iqw_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tọ dụ iya bụ; Hamọ yẹle nwatibe iya Shékemu atụgbua jeshia l'obu-edukfu mkpụkpu ẹphe; t'ẹphe kfuru iya ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ẹphe erua je asụ ẹphe: “Lẹ ndu-a bẹ umere ẹphe dụkwa mma. L'aa-hakwa ẹphe t'ẹphe buru l'alị-a; tụsaru ẹhu; nọdu iya agba nghọ; keshinu ọphu alị daburu phorongu, ẹphe e-buru. Ọdo abụru l'ẹphe l'ẹphe a-nọdu alụgba nwanyi. ");
INSERT INTO iqw_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Obenu lẹ tẹmanu ndu ono ekwe l'ẹphe l'ẹphe e-buru; tụko bụru ndu lanụ bẹ ndu k'unwoke ayi l'ẹphe ha e-bukota útsù; l'ọ bụ ẹphebedua. ");
INSERT INTO iqw_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","?Unu ta amadụ l'elu ẹphe; ẹku ẹphe; mẹ iphe bụ anụ ọdo, ẹphe nweru enweru a-bụkotaru nk'ayi? Ọo ya bụ; unu t'ayi kweta iphe, ẹphe kfuru; k'ọphu ẹphe e-kweta buru l'alị ayi-a.” ");
INSERT INTO iqw_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Iphe, bụ unwoke mkpụkpu ono l'ẹphe ha, bụ ndu lụfutaru l'obu-edukfu ono ekwetakota iphe Hamọ yẹle nwatibe iya kfuru; a bya ebushikota ẹphe útsù. ");
INSERT INTO iqw_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","A nọlephu abalị ẹto teke ẹphe nọkwadua ọnya ugvu ono; ụnwu Jékọpu ụmadzu labụ; ndu ọphu ẹphe lẹ Dayina shi lẹ nne lanụ, bụ iya bụ Símiyọnu; mẹ Lívayi egbeshi mịta ogu-mbeke ẹphe je afụaru ndu mkpụkpu ono l'ọtu-l'ụkfu. Ẹphe eje etso ndu mkpụkpu ono ọgu; jịko iphe, bụ unwoke, nọ iya nụ gbugee. ");
INSERT INTO iqw_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ẹphe egbua Hamọ yẹle nwatibe iya Shékemu; bya eduta Dayina l'ụlo Shékemu; yọ bụru ẹphe alala. ");
INSERT INTO iqw_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ụnwu Jékọpu awụda lẹ mkpụkpu ono yẹle odzu ono, kụru iya nụ ono; je akwaa ẹphe l'ọkwata l'okfu nwunne ẹphe ono, e guderu k'ẹhuka mebyishia ono. ");
INSERT INTO iqw_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ẹphe kpụkoru atụru ẹphe; kpụkoo eswi ẹphe; mẹ nkakfụ-ịgara ẹphe; jịko iphemiphe ọbule, bụ kẹ ndu mkpụkpu ono gwoo; mbụ gwoo gwoo mẹ iphe ọphu nọtsua l'ẹgu. ");
INSERT INTO iqw_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ẹphe gwokotaru ẹku ẹphe; kpụkota ụnwanyi ẹphe; mẹ ụnwegirima ẹphe lẹ ndzụ; bya egwoo tụtua l'ụlo ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tọ dụ iya bụ; Jékọpu asụ Símiyọnu yẹle Lívayi: “Ọwaa egbe iphe ọphu unu kpataru iya nta-a! Nta-a bẹ unu meru tẹ ya bụru ẹjo madzụ l'ẹke ndu alị-a nọ; mbụ ndu Kénanu yẹle ndu Pẹ́rezu. ?Mgbẹ unu marua lẹ ya ha nwanshị. Ẹphe -zakọta nta-a bya afụaru iya bẹ yẹle ndibe iya a-bụkwaru kpurupyata!” ");
INSERT INTO iqw_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ẹphe asụ iya: “?Ọ gbakwanụru t'o mee nwunne ẹphe l'ọ bụ nwanyi ọkpara ẹge ono, o meru iya ono?” ");
INSERT INTO iqw_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ya ndono; Nchileke asụ Jékọpu: “T'ọ kwalia lashia Bẹ́telu je eburu.” Sụ iya: “O -rua; t'ọ kpụaru yẹbe Nchileke ẹnya-ngwẹja; mbụ yẹbe Nchileke ono, byakfutaru iya nụ l'o shi agbaru nwunne iya Ị́so ọso ono.” ");
INSERT INTO iqw_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tọ dụ iya bụ; Jékọpu asụ ndibe iya; mẹ ndu ẹphe l'iya bu: “T'ephe pakọtakwaru iphe, bụ nte ndu ọhodo, ẹphe gude haa; ẹphe emee onwẹphe t'ẹphe dụ nsọ; yeshia uwe ẹphe; chịtatsua ọphu ka mma yee. ");
INSERT INTO iqw_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","L'ẹphe abyakwa oje Bẹ́telu, ẹke ya a-kpụru Nchileke ẹnya-ngwẹja. Nchileke bụ onye ono, dzọru iya nụ teke ono, ya shi eje ntakfuru ono; bụru onye, chekotaru iya nụ l'iphe bụ ẹge ya jekotaru iya.” ");
INSERT INTO iqw_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ya ndono; ẹphe atụko iphe, bụ nte ndu ọhodo ono, ẹphe doru ono nụ Jékọpu; tụkokwaphu iphe-nchị ẹphe yeshia nụ Jékọpu. Jékọpu achịta iya lia lẹ mkpuli achị, nọ lẹ Shékemu. ");
INSERT INTO iqw_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ẹphe akwalia tụgbua; Nchileke emee; egvu egudekota iphe, bụ ndu mkpụkpu, nọ-pheru ẹphe mgburumgburu; k'ọphu bụ l'ẹ t'ọ dụdu ndu tụru iya ámà k'oje ẹphe ọchi ọso. ");
INSERT INTO iqw_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tọ dụ iya bụ; Jékọpu yẹle ndu ẹphe l'iya yị ejee bya ejerua Luzu, bụ iya bụ Bẹ́telu l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yọ kpụa ẹnya-ngwẹja l'ẹke ono; bya agụa ẹke ono Ẹlu Bẹ́telu; kẹ l'ọ bụ l'ẹke ono bẹ Nchileke koshiru iya onwiya teke o shi agbaru nwunne iya ọso. ");
INSERT INTO iqw_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ya ndono; Debóra, bụ nwanyi, heru Ribéka teke o shi bụru nwata abya anwụhu. E woru iya lia lẹ mkpuli ukfu achị, nọ lẹ nsụda Bẹ́telu. Ọo ya meru; e woru ẹke ono gụa Alọnu Bakutu. ");
INSERT INTO iqw_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jékọpu eshitsulephu Padanu-Áramu lata; Nchileke abyakfuta iya ọdo bya agọoru iya ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nchileke asụ iya: “Ẹpha ngu bụ Jékọpu; ọle tsube nta-a bẹ ẹpha ngu ta abụhedu Jékọpu; ẹpha ngu a-bụru Ízurẹlu.” Yọ bụru iya bụ lẹ Nchileke agụa ya Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nchileke asụ iya: “L'ọo yẹbedua, bụ Nchileke bụ Ọkaribe-Kakọta-Ike. Ịi-zụ azụzu bya adụ l'ọtu. Ii-meta ndu a-bụru mba; metakwaphu mbakeshi. Ndu eze e-shi ngu l'ẹhu lụfuta. ");
INSERT INTO iqw_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Alị ono, ya nụru Ébirihamu; mẹ Áyizaku ono bẹ ya anụkwa ngu phụ; l'anụkwa iya phụ ụnwu nwanwanwaranwa ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Nchileke ekfutsuaru yeru iya; haa ya l'ẹke ono tụgbua. ");
INSERT INTO iqw_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jékọpu abya apalia mkpuma gvube l'ẹke ono, Ojejoje nọdu kfuru yeru iya ono; bya awụa mẹe l'eli iya; wụkwaa ya phụ manụ; gude gwaa ya. ");
INSERT INTO iqw_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jékọpu agụa ẹke ono, Nchileke nọ kfuru yeru iya ono Bẹ́telu. ");
INSERT INTO iqw_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ẹphe egbeshi lẹ Bẹ́telu tụgbua. Efuratu adụdelephu ẹphe ntse; ime awata ome Rechẹlu. Ime ono ataa ya ike. ");
INSERT INTO iqw_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Teke ono, ime ono shiru ike ono bẹ nwanyi, eswi iya ime sụru iya: “T'ẹ b'ọ tsụshi egvu. L'ọ kwa nwata nwoke ọdo bẹ ọo-mụ.” ");
INSERT INTO iqw_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Yọ byadẹ ọtu-bu ume; gụa nwata ono Benoni; E mebetsua; nna nwata ono abya agụa ya Bénjaminu. ");
INSERT INTO iqw_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ya ndono; Rechẹlu anwụhu; e lia ya l'ụzo, e shi eje Efuratu, bụ iya bụ Bẹ́tulehemu. ");
INSERT INTO iqw_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jékọpu eswita mkpuma gvube l'eli ili ono. Mkpuma ono nọphu l'eli ili ono jeye ntanụ-a l'ekoshi l'ọ bụ ili Rechẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ízurẹlu atụgbukwaa ọdo; je egvube ụlo-ẹ́kwà l'azụ ụlo-eli mkpụkpu Eda. ");
INSERT INTO iqw_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yọ bụru teke Ízurẹlu bu l'ẹke ono bẹ Rúbẹnu raru Biliha, bụ nnufu nna iya. Nna iya; mbụ Ízurẹlu anụa ya. Jékọpu mụtaru unwoke iri l'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ụnwegirima kẹ Lii bụ Rúbẹnu, bụ iya bụ ọkpara Jékọpu; mẹ Símiyọnu; Lívayi; Júda; Ísaka; mẹ Zébulọnu. ");
INSERT INTO iqw_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ụnwegirima kẹ Rechẹlu abụru Jósẹfu; mẹ Bénjaminu. ");
INSERT INTO iqw_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ụnwegirima kẹ Biliha; mbụ onye Rechẹlu guderu egude bụ Dánu; mẹ Náfutali. ");
INSERT INTO iqw_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ụnwegirima kẹ Zilipa; mbụ onye Lii guderu egude abụru Gádu; mẹ Ásha. Ndu onanu bụ unwoke, a mụshikotaru Jékọpu lẹ Padanu-Áramu. ");
INSERT INTO iqw_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jékọpu alakfuta nna iya, bụ Áyizaku lẹ Mamure l'iku Kiriyatu Arụba, bụ iya bụ Hẹ́buronu, bụ ẹke Ébirihamu yẹle Áyizaku shi jịko buru. ");
INSERT INTO iqw_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Iphe Áyizaku nọru bụ ụkporo afa tete; ");
INSERT INTO iqw_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","b'ọ nwụhuderu; lakfushia ndiche iya phẹ. Ọ kakpọoru nka ọhuma. Yọ nwụhutsua ono; ụnwu iya; mbụ Ị́so yẹle Jékọpu elia ya. ");
INSERT INTO iqw_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ọwaa bụ eri Ị́so, bụ iya bụ Édọmu. ");
INSERT INTO iqw_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ị́so lụru ụnwanyi ndu Kénanu. Nwanyi k'ọdungu bụ Ada, bụ nwatibe Elọnu onye Hetu. Nwanyi k'ẹbo bụ Oholibama, bụ nwatibe Ana; bụkwaruphu nwanwa Zibiyọnu onye Hevu. ");
INSERT INTO iqw_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Nwanyi k'ẹto bụ Basematu, bụ nwatibe Ishimẹlu; bụkwaruphu nwunne Nebayọtu. ");
INSERT INTO iqw_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada mụtaru Ị́so Elifazu; Basematu amụtaru iya Ruwẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama amụtaru iya Jewushi; mụtaru iya Jelamu; mẹfua Kora. Ndu ono bụkota ụnwu, a mụtaru Ị́so lẹ Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ị́so abya eduta unyomu iya; mẹ ụnwegirima iya ndu k'unwoke; mẹ ndu k'ụnwanyi; duta iphe, bụ ndibe iya l'ẹphe ha; ruta elu iya; mẹ iphe bụ anụ, ọ kpataru lẹ Kénanu; yọ bụru iya ọla ẹke, teru ẹnya l'ẹke nwunne iya; mbụ Jékọpu bu. ");
INSERT INTO iqw_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iphe ẹphe nweru hatabewa nshinu; k'ọphu bụ l'ẹphe ẹbo te ebukotahedu l'ẹkalanu. Elu ẹphe emee; alị ono, ẹphe bụ ndu mbyamụmbya ono te edzuhe ẹphe ebubu. ");
INSERT INTO iqw_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yọ bụru iya meru iphe Ị́so, bụ iya bụ Édọmu jeru je eburu l'alị ugvu Séyi. ");
INSERT INTO iqw_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ọwaa eri Ị́so, bụ nna ndu Édọmu teke o bu l'alị ugvu Séyi: ");
INSERT INTO iqw_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ọwaa ẹpha ụnwu Ị́so: Elifazu bụ nwata nwoke ọphu Ada mụtaru iya. Ruwẹlu bụ nwata nwoke ọphu Basematu mụtaru iya. ");
INSERT INTO iqw_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ụnwegirima unwoke ọphu Elifazu mụshiru bụ: Témanu; Omaru; Zefo; Getamu; mẹ Kenazu. ");
INSERT INTO iqw_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazu nweru nwanyi ọphu bụ nnufu iya. Onye onanu bụ Tìmína. Tìmína mụtaru iya nwata nwoke lanụ, aza Amalẹku. Ndu onanu bụ ụnwu-nwa Ada, bụ nyee Ị́so. ");
INSERT INTO iqw_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ụnwegirima unwoke ọphu Ruwẹlu mụtaru bụ: Nehatu; Zera; Shama; mẹ Miza. Ndu onanu bụ ụnwu-nwa Basematu, bụ nyee Ị́so. ");
INSERT INTO iqw_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ụnwegirima unwoke ọphu Oholibama mụtaru Ị́so bụ: Jewushi; Jelamu; mẹ Kora. Oholibama ono bụ nwatibe Ana bya abụru nwanwa Zibiyọnu. ");
INSERT INTO iqw_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ọwaa ndu bụ ishi l'eri Ị́so ndọ-ọ: Ụnwegirima kẹ Elifazu, bụ ọkpara Ịso bụ: Témanu; Omaru; Zefo; Kenazu; ");
INSERT INTO iqw_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora; Getamu; mẹ Amalẹku. Ndu ono bụ ndu bụ ishi l'eri Elifazu l'alị Édọmu. Ẹphe bụ ụnwunwa Ada. ");
INSERT INTO iqw_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ndu ọphu bụ ndu ishi l'ụnwegirima kẹ Ruwẹlu bụ: Nehatu; Zera; Shama; mẹ Miza. Ndu onanu bụ ndu bụ ishi l'eri Ruwẹlu l'alị Édọmu. Ẹphe bụ ụnwunwa nyee Ị́so, bụ iya bụ Basematu. ");
INSERT INTO iqw_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ụnwegirima ọphu Oholibama mụtaru Ị́so bụ: Jewushi; Jelamu; mẹ Kora. Ndu onanu bụ ndu bụ ishi l'eri nyee Ịso, bụ iya bụ Oholibama, bụ nwatibe Ana. ");
INSERT INTO iqw_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ndu ono l'ẹphe ha bụkota ụnwu Ị́so, bụ iya bụ Édọmu; bụru ẹphe bụgbaa ndu ishi l'ikfu ẹphe iche iche. ");
INSERT INTO iqw_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ụnwegirima kẹ Séyi, onye Họru, bụ iya bụ onye nwe alị ono bụ: Lotanu; Shobalu; Zibiyọnu; Ana; ");
INSERT INTO iqw_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishọnu; Eza; mẹ Dishanu. Ụnwegirima Séyi ono, bu lẹ Édọmu ono bụ ẹphe bụgbaa ndu ishi ndu Họru. ");
INSERT INTO iqw_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ụnwegirima kẹ Lotanu bụ: Hori; mẹ Hemanu. Tìmína bụ nwunne Lotanu kẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ụnwegirima kẹ Shobalu bụ: Aluvanu; Manahatu; Ebalu; Shefo; mẹ Onamu. ");
INSERT INTO iqw_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ụnwegirima kẹ Zibiyọnu bụ: Aya; mẹ Ana. Ana ọwananu bụ iya chọ-vuru nwogvu ọbu, ekpo ọku l'echi-ẹgu l'ẹke oocheru nna iya, bụ Zibiyọnu nkakfụ-ịgara. ");
INSERT INTO iqw_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ụnwegirima kẹ Ana bụ: Dishọnu; mẹ Oholibama, bụ nwatibe iya kẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ụnwegirima Dishọnu bụ Hẹmudanu; Ẹshubanu; Ituranu; mẹ Keranu. ");
INSERT INTO iqw_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ụnwegirima kẹ Eza bụ: Bilihanu; Zevanu; mẹ Ekanu. ");
INSERT INTO iqw_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ụnwegirima kẹ Dishanu bụ: Uzu; mẹ Aranu. ");
INSERT INTO iqw_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ọwaa ndu ishi ndu Họru: Lotanu; Shobalu; Zibiyọnu; Ana; ");
INSERT INTO iqw_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishọnu; Eza; mẹ Dishanu. Ọ bụ ẹphebedua bụ ndu ishi ndu Họru l'ẹge ẹphe shitsua l'ikfu l'ikfu l'alị Séyi ono. ");
INSERT INTO iqw_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ọwaa bụ ndu eze, vuru ụzo chịa ndu Édọmu; bẹ eze ọdo, shi Ízurẹlu chịderu ẹphe: ");
INSERT INTO iqw_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla Beyo bụru eze ndu Édọmu. Mkpụkpu iya bụ Dinuhaba. ");
INSERT INTO iqw_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla anwụhulephu; Jobabu Zera, bụ onye Bọzura abya abụru eze l'ọzori iya. ");
INSERT INTO iqw_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabu anwụhulephu; Hushamu, bụ onye Témanu abya anọdu l'ọzori iya chịlahaa. ");
INSERT INTO iqw_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu anwụhulephu; Hadadu Bedadu, bụ iya lụ-gburu ndu Mídiya lẹ Móabu abya abụru eze l'ọzori iya. Mkpụkpu nk'iya bụ Avitu. ");
INSERT INTO iqw_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadu anwụhulephu; Samúla kẹ Masureka abya anọdu l'ọzori iya chịlahaa. ");
INSERT INTO iqw_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samúla anwụhulephu; Shawulu kẹ Rehobọtu, nọ l'iku Ẹnyimu Yufurétusu abya anọdu l'ọzori iya chịlahaa. ");
INSERT INTO iqw_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shawulu anwụhulephu; Bálụ-Hananu Akụbo abya abụru eze l'ọzori iya. ");
INSERT INTO iqw_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bálụ-Hananu anwụhulephu; Hada abụru eze l'ọzori iya. Mkpụkpu iya bẹ eekuje Pawu. Ẹpha nyee ya abụru Mehetabẹlu, bụ nwatibe Maturedi. Maturedi bụkwanu ada Mezahabu. ");
INSERT INTO iqw_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ọwaa ẹpha ndu bụ ishi l'eri Ị́so l'ẹge ẹphe shitsua l'ikfu l'ikfu; mẹ ẹke ẹphe butsua, eekutsua ẹpha ẹphe alaru: Tìmína; Aluva; Jitẹtu; ");
INSERT INTO iqw_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama; Ela; Pinọnu; ");
INSERT INTO iqw_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazu; Témanu; Mibiza; ");
INSERT INTO iqw_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magudẹlu; mẹ Iramu. Ndu-a l'ẹphe ha bụkota ndu ishi ndu Édọmu; l'ẹge ẹphe gude bua l'alị ono, ẹphe lụtaru ono. Ẹphe l'ẹphe ha tụko bụru ndibe Ị́so, bụ nna ndu Édọmu. ");
INSERT INTO iqw_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Tọ dụ iya bụ; Jékọpu eburu l'alị ono, nna iya shi buru ono, bụ iya bụ alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ọwaa akọ ẹhu Jékọpu: Jósẹfu anọlephu afa iri l'ẹsaa wata otso ụnwanna iya phẹ l'eche atụru. Ụnwanna iya phẹ ono bụ ụnwegirima nyee nna iya phẹ; mbụ Biliha; mẹ Zilipa. Yọo bụje; ẹphe -lata; yo dooru nna ẹphe ẹjo iphe, ụnwanna iya ndu ọphu anọduje eme. ");
INSERT INTO iqw_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ízurẹlu aka oyeru Jósẹfu obu mẹ l'ẹge o yeru ụnwu iya ndu ọphu. Ishi iya abụru l'ọ bụ nwa, a mụru iya lẹ nka. Yọ bya akwaaru Jósẹfu uwe-nlọkpuru ẹka-ogologo, e dengashiru edengashi. ");
INSERT INTO iqw_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Teke ụnwanna iya bya amaru lẹ nna ẹphe ka iya oyeru obu mẹ l'ẹge o yeru ẹphebedua; ẹphe abya akpọo ya ashị; ẹphe te ekfujeheru iya okfu ọma. ");
INSERT INTO iqw_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yo be ujiku lanụ; Jósẹfu arọo nrọ; bya ezeeru iya ụnwanna iya ono. Nrọ ono emee; ẹphe akabakpọ ya rụ ọkpo ashị. ");
INSERT INTO iqw_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yọ sụ ẹphe t'ẹphe gebe tẹ ya zeeru ẹphe nrọ, ya rọru. ");
INSERT INTO iqw_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Wo ẹphe: “Lẹ ya rọru nrọ; ẹphe ajịko l'esweshi oshiwitil'ẹgu. A nọnyaa; iswe witu nk'iya egbeshi vudo evudo; iswe iya nk'ẹphe abya anọ-phee nk'iya mgburumgburu; l'eforu nk'iya ono ifu l'alị.” ");
INSERT INTO iqw_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ụnwanna iya ono asụ iya: “?Bụ iya bụ l'ịiri l'ọo nggu e-mekochaa bụru eze l'achị ẹphe tọo? Mbụ; ?bụ nggu e-mekochaa bụru ishi ẹphe tọo?” Nrọ ono, ọ rọru ono yẹle okfu ono, o kfuru ono emee; ẹphe akabaa ya rụ ọkpo ashị. ");
INSERT INTO iqw_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yo be mbọku ọdo; yọ byakwa bya arọo nrọ ọdo; bya ezekwaaru iya phụ ụnwanna iya ono. Ono b'ọ sụru ẹphe: “Unu gebe tẹ ya zeeru unu nrọ ọdo, ya rọru. Ya rọru nrọ; ẹnyanwu; mẹ ọnwa; ọwaa mkpọ-kpodo iri lẹ nanụ abya efooru iya ifu l'alị.” ");
INSERT INTO iqw_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Teke o zeru nna iya nrọ ono ẹge o zeru iya ụnwanna iya phẹ bẹ nna iya baru iya mba; sụ iya: “?Bụ egbe nrọ ngụnu dụ ẹge onanu? ?Ọ bụ lẹ nne ngu; mẹ yẹbedua, bụ nna ngu; mẹ ụnwunna ngu phẹ e-mekochaa bya efooru ngu ifu l'alị tọo?” ");
INSERT INTO iqw_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ụnwanna iya ono awataru iya okoru okopho. Obenu lẹ nna iya wotaru iphe ono kwachia l'ọkpoma. ");
INSERT INTO iqw_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ya ndono; ụnwanna iya achịta atụru nna ẹphe jeshia echeche l'iku Shékemu. ");
INSERT INTO iqw_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ízurẹlu asụ Jósẹfu: “?Mgbẹ ị marua l'ụnwanna ngu phẹ eche atụru l'iku Shékemu. Ngwaa; bya tẹ ya zi ngu t'i je agbaphee ẹphe.” Jósẹfu ekwe iya. ");
INSERT INTO iqw_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Nna iya asụ iya t'o je agbaphee ụnwanna iya l'ẹke ẹphe nọ l'eche atụru; maru ẹge ẹphe dụ; ẹphe l'atụru ono. Teke ọ phụtsuaru ẹphe; yọ lata bya akọoru iya. Yọ bụru lẹ nsụda Hẹ́buronu b'ọ nọ zia ya ozi ono. Jósẹfu erua Shékemu; ");
INSERT INTO iqw_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","nwoke ọbu aphụ iya l'ẹke ọogha-phe l'ẹgu l'ẹke ono; jị iya: “?Bụ ngụnu bẹ ịicho?” ");
INSERT INTO iqw_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yọ sụ iya: “L'ọ kwa ụnwanna iya phẹ; bẹ ya achọ. Ọ -bụru l'ị maru ẹke ẹphe nọ l'eche atụru ẹphe; byiko tụnuru iya ọnu iya.” ");
INSERT INTO iqw_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nwoke ono asụ iya: “L'ẹphe lụfuakwaru l'ẹke-a. Lẹ ya nụkwaru teke ẹphe shi ekfu t'ẹphe je Dótanu.” Tọ dụ iya bụ; Jósẹfu achọru ẹphe tụgbua; je achọ-vu ẹphe l'ụzo Dótanu. ");
INSERT INTO iqw_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ẹphe aphụ l'iya phụ l'ụzenya; wata ọchi idzu ẹge ẹphe e-shi gbua ya. ");
INSERT INTO iqw_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ẹphe asụ onwẹphe: “Ọ-rọ-nrọ-a abyakwa-a! ");
INSERT INTO iqw_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Unu bya t'ayi gbua ya; chee lẹ nsụ lanụ l'ẹke-a. Teke e metsuaru; ayi asụ l'ọ bụ anụ-ẹgu-ẹgbudu gburu iya. T'ayi mawarụru ẹge nrọ iya ono e-shi vụa.” ");
INSERT INTO iqw_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rúbẹnu anụle iya phụ; chọlahaa ẹge ya e-shi dzọo ya t'ẹphe bẹ egbu iya. Yọ sụ: “Unu t'ayi be egbukwa iya egbugbu. ");
INSERT INTO iqw_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Unu be egbukwa ọchi. Iphe unu e-mechia bụ t'unu paru iya chee l'iduma-wa, nọ l'echi-ẹgu ẹke-a. Ọlobu; unu be emekakwa iya iphe.” Iphe kparu iphe Rúbẹnu kfuru ẹge ono bụ k'ọphu ọo-dzọfuta iya; duta iya dulaaru nna iya. ");
INSERT INTO iqw_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ya ndono; Jósẹfu abyarutalephu ẹke ụnwanna iya ono nọ; ẹphe egude iya; yefu iya uwe-nlọkpuru ẹka-ogologo iya ono, e dengashiru edengashi ono; ");
INSERT INTO iqw_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","kpụta iya chee l'iduma. Iduma ono kpọhuru nkụ; to nwe iphe nọ iya nụ. ");
INSERT INTO iqw_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ẹphe anọdukwadua k'ori nri; bya apalia ẹnya; phụa ndu Ishimẹlu, liberu shi lẹ Gíledu; ẹphe l'ịnya-ivu ẹphe, vutsua manụ, eshi mkpọ; manụ bamụ; yeru mẹeru gude l'eje Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Júda asụ ụnwanna iya ndu ọphu; “?Bụ ngụnu bẹ ayi e-rita iya mẹ ayi gbua nwanna ayi woru odzu iya lia? ");
INSERT INTO iqw_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Unu bya t'ayi ree ya ndu Ishimẹlu. T'ẹ b'ọ dụkwa iphe ayi e-je iya ememe; l'ọ kwa nwanna ayi, ayi ẹya bụ mee lanụ.” Ụnwanna iya ono ekwe. ");
INSERT INTO iqw_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ndu Mídiya ono, l'agba nghọ ono eswedelephu; ụnwanna Jósẹfu ono akpụfuta iya l'iduma ono; woru iya ree ndu Ishimẹlu ono ụkporo pọngu. Ẹphe eduta iya lashia Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rúbẹnu abya enyoo iduma ono; bya aphụ lẹ Jósẹfu ta anọhedu iya; yo gude ẹhu-eghughu woru uwe iya lajaa. ");
INSERT INTO iqw_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Yo jekfushia ụnwanna iya phẹ ono; je sụ ẹphe: “Mẹ nwata ono ta anọhekwa l'ẹke ono. ?Nanụ ụzo, ya e-shi iya nta-a?” ");
INSERT INTO iqw_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ya ndono; ẹphe akpụta eghu lanụ gbua; chịta uwe Jósẹfu tsẹe lẹ mee eghu ono. ");
INSERT INTO iqw_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ẹphe achịta uwe-nlọkpuru ẹka ogologo ono chịlaaru nna ẹphe; sụ iya: “T'o lekwa uwe, ẹphe detataru. T'o leedu iya ẹnya; maru m'ọ bụ kẹ nwatibe iya tẹ t'ọ bụdu iya.” ");
INSERT INTO iqw_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jékọpu abya elee ya ẹnya; yọ bụru iya. Yọ sụ: “L'ọ kwa uwe nwatibe iya! Ọ dụkwa l'ọ bụ ẹjo anụ-ẹgu-ẹgbudu gburu iya. L'ọ kwa anụ-ẹgu-ẹgbudu labushiru Jósẹfu vịriviri!” ");
INSERT INTO iqw_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jékọpu egude aphụ lajaa uwe iya; chịta uwe-aphụ yee; kwaa ẹkwa nwa iya ono abalị olemole. ");
INSERT INTO iqw_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ụnwegirima iya: ndu k'unwoke; mẹ ndu k'ụnwanyi abya egboo ya nta; gboo ya imo; to kwe t'e gbota iya. Yọ sụ ẹphe: “T'ẹphe haa ya tẹ ya gụa aphụ nwa iya ono jeye teke ya a-lakfu iya l'ili.” Ọ bụ ẹge ono bẹ nna iya gude kwaa ẹkwa iya. ");
INSERT INTO iqw_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ya ndono; ndu Mídiya ono eje eworu Jósẹfu ree Pọtifa lẹ Íjiputu. Pọtifa ono bụ onye lanụ lẹ ndu ejeru Fero ozi; bụru iya bụ onye ishi ndu sọja, eche Fero nche. ");
INSERT INTO iqw_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ya ndono; yọ bụru teke ono bẹ Júda haru ụnwunna iya; tụgbua jeshia kẹ nwoke Adulámu, eeku Hira je eburu. ");
INSERT INTO iqw_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yọ bụru l'ẹke ono bẹ Júda nọ phụa nwatibe nwoke, eeku Shuwa, bụ onye Kénanu. Yọ lụa nwata ono; yẹle iya abya azẹe; ");
INSERT INTO iqw_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","yọ tsụta ime; bya amụtaru iya nwata nwoke, ọ gụru Ẹru. ");
INSERT INTO iqw_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yọ bya atsụta ime ọdo; mụa nwata nwoke; gụa ya Onanu. ");
INSERT INTO iqw_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yọ bya atsụta ime ọdo; mụkwaaphu nwata nwoke; gụa ya Shela. Yọ bụru lẹ Kezibu b'ọ nọ mụa nwata ono. ");
INSERT INTO iqw_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Júda abya alụaru Ẹru, bụ ọkpara iya nwanyi. Ẹpha nwanyi, ọ lụru iya bụ Táma. ");
INSERT INTO iqw_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Obenu lẹ Ẹru, bụ ọkpara Júda bụ onye menukaru ẹjo iphe. Ojejoje eworu iya chigbua. ");
INSERT INTO iqw_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tọ dụ iya bụ; Júda asụ Onanu: “T'ọ lụpyabe nyee nwunne iya ono; k'ọphu oo-shi ẹge ono tọgboru nwunne iya ono akọ lẹ mgboko.” ");
INSERT INTO iqw_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Obenu lẹ Onanu mawaru lẹ nwata, nwanyi ono a-mụta ta abụdu nk'iya. Yọo bụje yẹle nyee nwunne iya ono zẹru; ọ -gbaa teke ọo-nyị iphe; yọ nyịru iya wụshi l'alị; k'ọphu ẹ too doberu nwunne iya ono akọ. ");
INSERT INTO iqw_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Iphe ono, ọonoduje eme ono adụ Ojejoje ẹji; yo wokwaru iya phụ chigbua. ");
INSERT INTO iqw_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ya ndono; Júda asụ nyee nwa iya ono; mbụ Táma t'ọ la kẹ nna iya je anọdu jeye tẹ Shela, bụ nwatibe iya vufuta. Ishi iya abụru l'ọ rịru; sụ: “A maru; ?onye onanu ta anwụhufuduanu ẹge unwunne iya ndu ọphu nwụshihuru.” Tọ dụ iya bụ; Táma atụgbua; lashia kẹ nna iya. ");
INSERT INTO iqw_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A bya anọokwaru ọphu baru ishi; nyee Júda, bụ iya bụ nwatibe Shuwa abya anwụhu. Júda akwagetsua ẹkwa iya; tụgbua; yọ buru iya oje Timina ọgba-phe ndu akpụru iya atụru iya ẹji. Ọnya iya; mbụ Hira, bụ onye Adulámu etsoru iya; yọ bụru ẹphe ejeje. ");
INSERT INTO iqw_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ya ndono; ama abya agbaaru Táma lẹ nna nji iya ejekwa Timina obyishi atụru iya ẹji. ");
INSERT INTO iqw_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Yo yefuwaphu uwe, nwanyi, nọ l'ụlo-maa, o yeru; chịta ụlari-ifu phụ-kpua onwiya ifu t'ẹ ba ahụbe iya ama; je adụgaru l'ọnu ẹke, eeshije abahụ Enému, bụkwanu ụzo, e shi eje Tìmína; kẹ l'ọ mawaru lẹ Shela vufutawaru; ọbule e te eduduaru iya nụ iya t'ọ lụpyabe ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Júda abya aphụa Táma tubesu l'ọo nwanyi ọkpara; kẹ l'ọ phụ-kpuru onwiya ụlari l'ifu; ");
INSERT INTO iqw_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","tọ ma l'ọ bụ nyee nwa iya. Yo jekfube iya l'iku ụzo ono; sụ iya t'ẹphe zẹe. Táma ajị iya iphe ọo-kfụ iya t'ẹphe zẹe ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Júda asụ iya: “Lẹ ya e-shi l'elu iya kpẹe ya nwada-eghu lanụ.” Táma asụ iya t'o wofuta iphe-itumo, ya e-gude jeye teke ọo-kpụtaru iya nwada-eghu ọbu? ");
INSERT INTO iqw_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yọ jị Táma; sụ iya: “?Bụ ngụnu b'ọ dụ ngu tẹ ya yeru ngu l'itumo ọbu?” Yọ sụ iya: “L'ọ bụ iphe-olu iya; iphe-ọhubama, tso iya nụ; mẹ mgbọro ono, o gude l'ẹka ono.” Júda ekwe iya; chịru iphe ono nụ iya; yẹle iya eje azẹe. Táma atsụtawaphu ime. ");
INSERT INTO iqw_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Júda atụgbulephu; Táma aphụfu ụlari-ifu ono, o shi phụ-kpua ifu ono; chịta uwe nwanyi, nọ l'ụlo-maa phụ, o shi yee phụ yephu azụ. ");
INSERT INTO iqw_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E metsua; Júda abya akpụta nwada-eghu ono kpẹe ọnya iya phụ; mbụ Hira t'o je akpẹe nwanyi ono; chịtakwanuru iya iphe phụ, o yeru iya l'itumo phụ. Yo shi rua ẹke ono; tọ phụhe nwanyi ono. ");
INSERT INTO iqw_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Yọ jị ndu ẹke ono: “Nanụ nwanyi ọkpara ono, shi nọdu l'iku ụzo Enému ono?” Ẹphe asụ iya l'ẹ to nwekwa nwanyi ọkpara, nọjeru l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tọ dụ iya bụ; yọ laphushia azụ; je asụ Júda: “Lẹ ya ta aphụkwa iya. Ọdo abụru lẹ ndu, bu l'ẹke ono sụkwaru l'ẹ to nwekwa nwanyi ọkpara, nọjeru l'ẹke ono.” ");
INSERT INTO iqw_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Júda asụ: “T'a haa ya t'o nwewaruru iphe ọphu, o gude; a nọnyakwaa; e gude iya nụ chịlahaa ayi ọchi. Mbụ; ?ya ta kpẹdunua ngu-a nwada-eghu-a; nggu egude iya je achọo ya; t'ị phụ iya?” ");
INSERT INTO iqw_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","A nọlephu iphe ruru ọnwa ẹto; a bya asụ Júda lẹ nyee nwa iya-a; mbụ Táma gbe agbaakwanu ọkpara; l'o gbe dụakwanu ime. Júda asụ t'a kpụfuta iya; je akpọo ya ọku! ");
INSERT INTO iqw_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A kpụfutadele iya phụ; yo gworu iphe ono, Júda chẹjeru iya ono nụ t'e gwojeru iya; sụ t'e kfuru iya: “L'ọ kwa onye nwe iphe-a bẹ yeru iya ime.” Sụ t'e kfuru iya: “T'o gbuedu iphe-olu-wa igo; iphe-ọhubama, tso iya nụ; mẹ mgbọro-wa t'ọ maru: ?ọo-maghe onye nwe iya nụ?” ");
INSERT INTO iqw_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Júda aphụlephu iphe ono; maru l'ọo nk'iya; bya asụ: “Ha! Nwanyi-a kakwa iya ọbu onye doberu ẹka ndoo; kẹle ya sụtsuaru lẹ Shela a-lụpyabe iya; e metsua; ya te emehe iya.” ");
INSERT INTO iqw_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Yọ gbaa teke oo-zeda; a maru l'ọ bụ ejima unwoke labụ, nọ iya l'ẹpho ono. ");
INSERT INTO iqw_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Yo zedade; onye lanụ evuru ụzo wofuta ẹka. Nwanyi, eswi iya ime ono abya ewota òwúú uswe gbabẹ iya l'ẹka; sụ l'ọo onye onanu vu ụzo. ");
INSERT INTO iqw_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nwata ono ewobalephu ẹka ono; nwunne iya eyewaphu ishi; kwofuta. Nwanyi ono, eswi ime ono asụ: “?Ọwaa ẹge i shiru kpataru onwongu ụzo?” Ya ndono; a gụa onye onanu Pẹ́rezu. ");
INSERT INTO iqw_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nwunne iya ọphu a gbabẹru eri owu uswe l'ẹka phụ etsowa iya phụ. A gụa yẹbedua Zera. ");
INSERT INTO iqw_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tọ dụ iya bụ; e duru Jósẹfu rua Íjiputu; Pọtifa azụ-ghachi iya ndu Ishimẹlu ono. Pọtifa bụ onye Íjiputu, tso lẹ ndu Fero nụru oke-ọkwa. Yọ bụru iya bụ onye ishi ndu sọja, echeje Fero nche. ");
INSERT INTO iqw_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ojejoje eswiru Jósẹfu; iphemiphe ọbule, o yeru ẹka l'ajahụjeru iya. Yo buru l'ụlo onye Íjiputu ono, bụ nnajiufu iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nnajiufu iya ono abya aphụ lẹ Ojejoje swiru Jósẹfu eswiru; bya aphụ l'iphemiphe ọbule, o yeru ẹka agajẹru iya; ");
INSERT INTO iqw_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Jósẹfu abya atụba iya l'obu; yo woru iya mee nwozi iya; mbụ mee ya onye, elekota ufu iya kpamukpamu ẹnya; bya ewokwaruphu iphemiphe ọbule, o nweru enweru ye iya l'ẹka t'o letajeru iya ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tsube teke ono, Pọtifa meru Jósẹfu onye ishi, eletaru iya ufu iya ẹnya; mẹ iphemiphe ọbule, o nweru enweru ono bẹ Ojejoje bya egude okfu ẹhu Jósẹfu gọoru nwoke Íjiputu ono ọnu. Ọnu ono, Ojejoje gọru iya ono emee iphemiphe ọbule, Pọtifa nweru l'ufu; mẹ ọphu nọ l'ẹgu; yo kweru iya. ");
INSERT INTO iqw_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Pọtifa ahakọtaru Jósẹfu iphemiphe ọbule, o nweru enweru t'o letajeru iya ẹnya; k'ọphu bụ l'ẹ tọ dụhedu iphe, ọokpajekwadu ishi ẹge ee-me iya. Iphe, ọ malẹruphu nwẹnkinyi bụ tẹ ya ria nri. Jósẹfu bẹ gbaru ụgbugba ọma; l'amashi mma ike. ");
INSERT INTO iqw_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","A nọnyalephu; Jósẹfu atụba nyee nnajiufu iya ono l'ẹnya. Yọ sụ iya t'ọ bya t'ẹphe zẹe. ");
INSERT INTO iqw_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Jósẹfu ajịka; sụ iya: “Lẹ keshinu nnajiufu iya meru iya onye ishi iphemiphe ọbule, o nweru enweru b'ẹ tọ ọkpajehekwa ishi iphe eme nụ l'ufu iya. Iphemiphe ọbule, o nweru enweru b'o yekotaru iya l'ẹka tẹ ya letaru iya ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ọ bụ ẹge ike kẹ nnajiufu iya ha l'ụlo-wa bụ ẹge ike nk'iya ha. To nwe iphe o wohajeru iya ewoha; a gụfuphu nggụbedua; kẹ l'ị bụ nyee ya. ?Nanu ẹge ya e-shi bya emee egbe akpamara ọwaa; kpua Nchileke?” ");
INSERT INTO iqw_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iphe bụ mbọku-mbọku, mụtaru amụta; yo kfukwaruphu Jósẹfu tẹ yẹle iya zẹe. Obenu lẹ Jósẹfu te kwedu; mbụkponu tẹ yẹle iya nọdu l'ẹkalanu. ");
INSERT INTO iqw_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Yo be ujiku lanụ; Jósẹfu abahụ l'ụlo tẹ ya jee ozi, nọru iya nụ. Teke ono b'ẹ tọ dụdu ndu ejeje ozi l'ụlo ono m'ọo onye lanụ, nọ l'ime ụlo ono. ");
INSERT INTO iqw_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nyee Pọtifa ono awọ iya l'uwe iya; sụ iya t'ọ bya t'ẹphe zẹe. Jósẹfu eyefu uwe iya ono haa ya l'ẹka gbafụ etezi. ");
INSERT INTO iqw_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yọ phụlephu lẹ Jósẹfu yefuru uwe iya haa ya l'ẹka kfụfu etezi; ");
INSERT INTO iqw_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kukowaphu ndu ozi ụlo iya; sụ ẹphe: “Unu lenu! Nwohu-a, shi Híburu-a b'e dutaru t'ọ bya emeru ẹjo ahụma kpua ẹphe. Ọ bakfutaru iya l'ime ụlo l'ẹke-a tẹ yẹ l'iya zẹe. Ya eworu mkpu chia. ");
INSERT INTO iqw_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Yọ nụlephu lẹ ya echi mkpu t'a bya agbaaru iya mkpu; paru uwe iya haaru iya; kfụfu etezi.” ");
INSERT INTO iqw_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nwanyi ono egude uwe ono gbururu jeye nnajiufu Jósẹfu abata. ");
INSERT INTO iqw_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Yọ bya akọoru iya iphe, mụru nụ; sụ iya: “Lẹ nwohu Híburu-a, i dubataru ayi l'ẹke-a bẹ byakwaru t'o mee mu ẹjo ahụma ntanụ-a. ");
INSERT INTO iqw_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ya echilephu mkpu t'a bya agbaaru iya mkpu; yọ haaru iya uwe iya kfụfu etezi.” ");
INSERT INTO iqw_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nnajiufu Jósẹfu anụlephu iphe ono, nyee ya kfuru iya l'ọ bụ ẹge ohu iya meru iya ndono; vọru ọku ghụa ẹhu. ");
INSERT INTO iqw_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Pọtifa akpụta Jósẹfu je eye l'ọka-mkpọro, eze atụ-chije ndu mkpọro iya. Obenu lẹ Jósẹfu nọ lẹ mkpọro ono; ");
INSERT INTO iqw_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ojejoje eswiru iya; l'ekoshi iya lẹ ya yeru iya obu. Yo mee onye eche ọka-mkpọro ono; yo yeru Jósẹfu obu. ");
INSERT INTO iqw_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Onye ono, eche ọka-mkpọro ono emee Jósẹfu ishi ndu nọkota l'ọka-mkpọro ono. Iphemiphe ọbule, eeme l'ẹke ono abụru Jósẹfu b'ọ nọkota l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Iphe nọwa Jósẹfu l'ẹka bẹ onye eche ọka-mkpọro ono ta akpajẹhedu ishi ẹge ee-me iya; kẹle Ojejoje swiru Jósẹfu; iphemiphe ọbule, o yeru ẹka l'agajẹru iya. ");
INSERT INTO iqw_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","A nọnyaa; onye, agbajẹru eze ndu Íjiputu mẹe; mẹ onye eghejeru iya buredi emeswee nnajiufu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Iphe eghulahaa Fero eghughu l'ẹke ụmadzu labụ ono, ejeru iya ozi ono nọ; mbụ onye ishi ndu agbajẹru iya mẹe; mẹ onye ishi ndu ọphu eghejeru iya buredi. ");
INSERT INTO iqw_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Yọ chịta ẹphe je atuchishia l'ufu onye ishi ndu sọja, echeje Fero nche. Ọ kwaphu l'ẹke ono b'a tụ-chiru Jósẹfu. ");
INSERT INTO iqw_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Onye ishi ndu sọja ono, echeje Fero nche ono eduru Jósẹfu yeru ẹphe t'ẹphe zije iya ozi. Ẹphe anọnyaa lẹ mkpọro ono; ");
INSERT INTO iqw_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","unwoke labụ ono; mbụ onye ono, agbajẹru Eze ndu Íjiputu mẹe; mẹ onye ọphu eghejeru iya buredi abya ajịko rọo nrọ l'ẹnyashi ujiku lanụ. Iphe nrọ ono ekfu adụgbaa iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yo be l'ụtsu iya; Jósẹfu abya aphụ l'ẹhu ta atsọdu ẹphe ẹna. ");
INSERT INTO iqw_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yọ jị ndu ono, ọkwa ẹphe kpọ-litaru l'ọru Fero ono; mbụ ndu ono, a jịko ẹphe l'iya tuchia lẹ kẹ nnajiufu iya ono; sụ: “?Bụ ngụnu meru iphe ẹhu ta atsọdu unu ẹna ntanụ?” ");
INSERT INTO iqw_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ephe asụ iya l'ẹphe ẹbo tụkoru rọo nrọ; tọ dụ onye a-karu ẹphe iphe nrọ ono bụtsua. Jósẹfu asụ ẹphe: “?Tọ dụ Nchileke bụ onye akọje nrọ? Unu zenuaru iya nrọ ọbu.” ");
INSERT INTO iqw_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Onye ishi ndu ono, agbajẹru Fero mẹe ono abya ezeeru Jósẹfu nrọ nk'iya; sụ iya: “Lẹ ya rọru nrọ; phụa onwiya oshi vayịnu l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Oshi vayịnu ono nweru ẹkali ẹto. Yọ bya erua iru; tsụa igu; mịshia akpụru l'ọfoko l'ọfoko; bya achashịa. ");
INSERT INTO iqw_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ya ndono; ya egude okoro Fero l'ẹka; bya ewota akpụru vayịnu ono pyịa ya apyịpyi; pyịta iya mini ye l'okoro ono; nụ Fero.” ");
INSERT INTO iqw_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jósẹfu asụ iya: “Ọwaa iphe nrọ ono bụ ndọ-ọ: Ẹkali oshi ẹto ono bụ ujiku ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Abalị ẹto ntanụ bẹ Fero a-bya edufuta ngu l'ẹke-a; mee t'ị laphu azụ l'ọru ngu; gbalaharu Fero mẹe ẹge, i shi agbaru iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ọlobu; teke ono, iphe a-dụru ngu lẹ mma ẹge ono, ọo-dụru ngu iya ono; nyatabụkwa yẹbe Jósẹfu; kfuaru Fero okfu ẹhu iya; k'ọphu aa-tụfu iya l'ọka-mkpọro-a; ");
INSERT INTO iqw_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","kẹ l'ọ kwa ezita b'e zitaru iya l'alị Híburu. A bya erua ẹke-a; bya ekwekputa iya chee lẹ mkpọro l'ẹ b'ọ dụ iphe, ya meru.” ");
INSERT INTO iqw_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ya ndono; onye ishi ndu ọphu eghejeru Fero buredi aphụlephu lẹ Jósẹfu kọru nrọ ono ọhuma; sụ iya: “Lẹ yẹbedua rọkwaruphu nrọ; vuru nkata buredi ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nkata ọphu kpọ-kfuru l'eli iya b'e yeru iphe dụ iche l'iche, e gheshiru Fero. Ụnwenu abya avụkalahaa iphe, nọ lẹ nkata k'eli iya ono.” ");
INSERT INTO iqw_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jósẹfu asụ iya: “Ọwaa iphe nrọ ono bụ ndọ-ọ: Nkata ẹto ono bụ abalị ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Abalị ẹto ntanụ bẹ Fero a-bya akpụfuta ngu; woru ngu swigbua l'eli oshi. Ụnwenu abya avụkaa anụ ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ya ndono; yo be mbọku k'ẹto ono; yọ gbaa lẹ mbọku, a mụru Fero. Yọ bya anọdu l'agbaru ndu ozi iya ajị, o gude ekoshi l'ọo mbọku ono b'a mụru iya. L'aanọkwadu l'agba ajị ono b'o ziru; e je edufutaru iya onye ishi ndu onanu, agbajẹru iya mẹe ono; mẹ onye ishi ndu ọphu eghejeru iya buredi. E je edufuta ẹphe dobe l'ifu ndu ozi iya ndu ọphu. ");
INSERT INTO iqw_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yọ bya anụ-phu onye ishi ndu onanu, agbajẹru iya mẹe ono ọkwa iya azụ; yọ wataru iya ọgbaru mẹe ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Obenu l'onye ishi ndu ọphu eghejeru iya buredi b'ọ swị-gbukwanuru. Yọ bụru iya bụ lẹ nrọ ono avụkota l'ẹge ono, Jósẹfu kfuru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Obenu l'onye ishi ndu ono, agbajẹru Fero mẹe ono ta nyatahẹdu Jósẹfu; yo woru iya zahaa. ");
INSERT INTO iqw_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","A nọlephu afa ẹbo; Fero abya arọo nrọ; phụ ẹke o vudo l'iku Ẹnyimu Náyịlu. ");
INSERT INTO iqw_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A bya ele ẹnya; eswi ẹsaa, bukotaru ẹji tayịngu; dụkota bẹmubemu eshi lẹ Ẹnyimu Náyịlu ono rufuta; bya awụshiru l'iku ẹke ono l'akpa nri. ");
INSERT INTO iqw_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A nọnyaa; eswi ẹsaa ọdo, dụtsua ẹjo adụdu; dụkota nyagọ-nyagọ-nyagọ eshikwaphu l'ẹnyimu ono rufuta bya anọnyabe ndu ọphu l'iku ẹnyimu ono. ");
INSERT INTO iqw_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eswi ẹsaa ono, dụtsua ẹjo adụdu; bya adụkota nyagọ-nyagọ-nyagọ ono abya ajịko eswi ẹsaa ọphu, bukotaru ẹji tayịngu phụ; dụkota bẹmubemu phụ takọta. E megee; Fero abya elutehu. ");
INSERT INTO iqw_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A nọnyakwaa; mgbẹnya abya eziru iya ọdo. Yọ rọo nrọ k'ẹbo. L'onanu b'ọ rọru nrọ; oke-akpe ẹsaa, hakọta ọkporokpo; dụ mma fọkotaru l'ishi akpe lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A nọnyaa; oke akpe ẹsaa ọdo, bụkota mgbapya akpe, phẹrephere ụzo ẹnyanwu-ahata mebyishiru emebyishi afọshikwaaphu; ");
INSERT INTO iqw_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","oke akpe ẹsaa ono, bụgbaa mgbapya akpe ono abya ajịko oke akpe ẹsaa ọphu dụ ọkporokpo; fọo afọfo phụ lekota. Fero elutehu; bya amaru l'ọ bụ nrọ. ");
INSERT INTO iqw_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Yo be l'ụtsu; nrọ ono akwata tsụlahaa ya l'ẹhu nshinu. Yo zia t'e je ekuaru iya ndu njibya; mẹ ndu Íjiputu, maru mmamiphe. Fero abya ezeeru ẹphe nrọ ono. Tọ dụ ẹphe onye dụru ike kọoru iya iphe, nrọ ono bụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tọ dụ iya bụ; onye ishi ndu agbajẹru Fero mẹe asụ iya: “L'ọ kwa ntanụ-a bẹ ya nyataru iphe, ya meru, ẹ ta dụdu mma. ");
INSERT INTO iqw_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Teke ono, ẹhu ghujeru nggụbe Fero eghughu l'ẹke yẹbe nwozi ngu nọ, a gbajẹru ngu mẹe; mẹ onye ọphu eghejeru ngu buredi. Iphe eghutabe ngu eghughu; k'ọphu ị chịtaru ẹphe je atuchia l'ufu onye ishi ndu sọja, echeje ngu nche. ");
INSERT INTO iqw_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yo be ẹnyashi ujiku lanụ; ẹphe ẹbo arọo nrọ; nrọ ono enwekotaru iphe, ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Yo nweru nwokorọbya, bụ onye Híburu, ejeru onye ishi ndu sọja, echeje ngu nche ozi, ayi l'iya tụko nọdu l'ẹke ono. Ayi ezeeru iya nrọ ono; yọ kọoru ayi iphe, ọ bụ. Onyenọnu b'ọ kọru iphe, nrọ nk'iya bụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yọ bụleruphu ẹge ono, o kọru iya ono b'ọ vụkotaru. Mbẹdua, agbajẹru ngu mẹe-a b'ị nụ-phuru ọkwa mu azụ; bya eworu onye ọphu kfụ-gbua.” ");
INSERT INTO iqw_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tọ dụ iya bụ; Fero abya ezia t'e je ekua Jósẹfu. Nta-a nta-a b'a tọfuwaru iya lẹ mkpọro ono. Yọ bya akpụa ishi; chịta uwe ọdo yee; yọ bụru iya oje l'ifu Fero. ");
INSERT INTO iqw_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fero asụ Jósẹfu: “Lẹ ya rọru nrọ; tọ dụ onye dụru ike kọoru iya iphe ọ bụ. Obenu lẹ ya nụwaru l'ọobuje; e zeeru ngu nrọ; nggu akọoru onye ọphu iphe nrọ ọphu bụ.” ");
INSERT INTO iqw_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jósẹfu asụ Fero: “L'ẹ tọ kwa yẹbedua akọje iya. L'ọ kwa Nchileke bẹ a-kọru nggụbe Fero iphe nrọ ono bụ ẹge oo-ji ngu ẹpho.” ");
INSERT INTO iqw_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Fero asụ Jósẹfu: “Lẹ ya rọru nrọ; vudo l'iku Ẹnyimu Náyịlu; ");
INSERT INTO iqw_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","phụa eswi ẹsaa, bukotaru ẹji tayịngu, dụkota bẹmubemu ẹke ẹphe shi lẹ mini ono rufuta bya anọdu l'iku mini ono l'akpa nri. ");
INSERT INTO iqw_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Eswi ẹsaa ọdo, dụtsulephu ẹjo adụdu; dụkota nyagọ-nyagọ-nyagọ erufutakwaphu. Ya ta aphụbudua eswi, dụjeru ẹji ẹge ono lẹ Íjiputu! ");
INSERT INTO iqw_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eswi ẹsaa onanu, dụtsua ẹjo adụdu; dụkwaphu nyagọ-nyagọ-nyagọ ono; abya ajịko eswi ẹsaa k'ivuzọ phụ takọta. ");
INSERT INTO iqw_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Yọ tatsụa ya; dụkwaphu ẹjo adụdu ẹge ọ dụhawa; k'ọphu bụ l'ẹ tọ dụdu onye e-kweta l'ọo ya taru eswi ndu ọphu. Ya ndono; ya elutehu. ");
INSERT INTO iqw_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ya abyakwa bya ekuru mgbẹnya ọdo; watakwa ọro nrọ ọdo. Lẹ k'ugbiya-a bẹ ya phụru oke-akpe ẹsaa, fọru afọfo; dụ mma; l'ẹke ọ bya apakọta l'ukfu akpe lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A nọnyaa; ya abya aphụkwaaphu oke-akpe ẹsaa ọdo, dụtsua mgbapya mgbapya; bụkotaru mkpegbafu akpe; phẹrephere ụzo ẹnyanwu-ahata ephenwushia ya ephenwushi l'ẹke ọ patakọtakwaruphu. ");
INSERT INTO iqw_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Oke-akpe ẹsaa ono, dụkota mgbapya mgbapya ono abya ajịko ndu ọphunanu, dụ mma phụ lekota. Ya ezekotaru ndu njibya nrọ ono; tọ dụ onye dụru ike kọo iphe ọ bụ.” ");
INSERT INTO iqw_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tọ dụ iya bụ; Jósẹfu asụ Fero: “Lẹ nrọ ẹbo ono, nggụbe Fero rọru ono bụkwa iphe lanụ b'ọ bụ. L'ọ kwa Nchileke eme tẹ ya koshi nggụbe Fero iphe, ya abya ememe. ");
INSERT INTO iqw_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Eswi ẹsaa phụ, dụkota mma phụ bụ afa ẹsaa. Ẹge ono kwaphu bẹ oke-akpe ẹsaa phụ, dụkota mma phụ bụkwaphu afa ẹsaa. Ọo ya bụ lẹ nrọ ono jịko bụru nrọ lanụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Eswi ẹsaa phụ, dụtsua nyagọ-nyagọ-nyagọ; bya adụ ẹjo adụdu, wụfutaru nụ lẹ ndu ọphu wụfutatsuaru phụ; mẹ l'oke-akpe ẹsaa phu, dụtsua mgbapya mgbapya; phẹrephere, shi ụzo ẹnyanwu-ahata phepyashiru ephepyashi phụ bụ afa ẹsaa, ẹjo-ẹgu e-me. ");
INSERT INTO iqw_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ọ dụa l'ọ bụ ẹge ono, ya kfuhawaru ngu ono: L'ọ kwa Nchileke koshiru nggụbe Fero iphe, ya abya ememe. ");
INSERT INTO iqw_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Afa ẹsaa bẹ nri a-ha nshinu lẹ Íjiputu gbaa mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Obenu l'afa ẹsaa ọphu tso iya nụ bẹ ẹjo-ẹgu e-me. Afa ẹsaa phụ, nri a-ha nshinu lẹ Íjiputu phụ bẹ aa-zahakọta; ẹgu emee madzụ ẹge ono jaa ya eze. ");
INSERT INTO iqw_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ẹjo-ẹgu, a-byanụ e-me to nwedu onye a-nyatakwadu teke ono, nri shi ha nshinu ono. ");
INSERT INTO iqw_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Iphe kparu iphe e meru tẹ Fero rọo nrọ ono uzi labụ ẹge ono bụ tẹ Fero maru lẹ Nchileke ribuwaru ẹtomu iya; mbụ l'ẹ tọ dụdu ẹge aa-nọ-be; Nchileke emee ya. ");
INSERT INTO iqw_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nta-a bụkwa tẹ nggụbe Fero lee ẹnya; fọta onye iphe edoje ẹnya; bụru onye maru iphe; mee ya t'ọ bụru onye ishi l'alị Íjiputu mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Nggu afọtakwaphu ndu a-nọ-tsota onye ishi Íjiputu ono; t'ẹphe keje iphe bụ iphe, ndu Íjiputu kpataru l'okfu ẹphe ụzo ise wota ụzo lanụ l'ime afa ẹsaa phụ, nri a-ha nshinu phu. ");
INSERT INTO iqw_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","T'ẹphe nakọo nri ono l'afa ono, nri a-ha nshinu ono. Teke ẹphe nakọtsuaru iya; t'ẹphe gude ikike kẹ nggụbe Fero jee l'edukfu l'edufu l'alị-a gbaa mgburumgburu je akwakọbetsua ya. ");
INSERT INTO iqw_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nri ono bẹ ee-doberu ndu alị-a kwabẹru afa ẹsaa ono, ẹjo-ẹgu e-me lẹ Íjiputu ono; k'ọphu ẹgu te eyechidu alị-a.” ");
INSERT INTO iqw_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iphe ono, Jósẹfu kfuru ono adụ Fero yẹle ndu ozi iya l'ẹphe ha mma. ");
INSERT INTO iqw_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Fero ajị ẹphe; sụ: “?O nweru onye ọdo, ẹphe a-phụ ọdo, e-gbe ka nwoke ọwaa, bụ onye Ume Nchileke nọ l'ẹhu ẹge-a?” ");
INSERT INTO iqw_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tọ dụ iya bụ; Fero asụ Jósẹfu: “Keshinu ọphu Nchileke meru t'ị makọtaru iphemiphe ọbule-a l'ọ ha b'ẹ to nwehekwa onye ọdo gbe ka ngu nụ lẹ k'iphe-odo-ẹnya; to nwe onye ọdo, ka ngu ọmaru iphe. ");
INSERT INTO iqw_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ọo nggụbedua l'a-bụru ishi l'ufu iya. Onyemonye ọbule, nọ l'alị-eze yẹbe Fero a-nọdu anụru ngu okfu. Iphe yẹbe Fero e-gude ka ngu nwẹnkinyi bụwa kẹ l'ọo ya bụ eze.” ");
INSERT INTO iqw_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ya ndono; Fero asụ Jósẹfu: “Alị Íjiputu l'ọ ha; bẹ ya yeekwaru ngu l'ẹka.” ");
INSERT INTO iqw_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Fero agbata echi mkpụshi-ẹka iya gbabẹ Jósẹfu; bya eyee ya akpawuru uwe; bya anyabẹ iya iphe-olu mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Yọ bya ewota ụgbo-ịnya k'ẹbo nụ Jósẹfu t'ọogbaje. Ndu madzụ awata ọra t'e fooru Jósẹfu ifu l'alị. Yọ bụru iya bụ l'o woru alị Íjiputu l'ọ ha ye Jósẹfu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ya ndono; Fero asụ Jósẹfu: “L'ọo yẹbe Fero bụ eze. Obenu l'ẹ to nwedu onye ha k'ome iphe l'alị Íjiputu gbaa mgburumgburu; a -gụfu l'ị sụru t'e mee iphe ọbu.” ");
INSERT INTO iqw_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fero abya agụ-kwazi Jósẹfu ẹpha; kulahaa ya Zafunatu-Paniya; byakwaphu bya eduta Asenatu, bụ nwatibe Pọtifera, agwajẹru ndu Ọnu iphe dee ya t'ọ lụru. Jósẹfu abya atụko alị Íjiputu l'ọ ha jegbakota. ");
INSERT INTO iqw_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jósẹfu nọwaru ụkporo afa l'afa iri teke ọ wataru ojeru Fero, bụ eze ndu Íjiputu ozi. Jósẹfu eshi lẹ kẹ Fero jegbakota alị Íjiputu mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","L'afa ẹsaa ono, nri nọ ono bẹ alị mehukotaru iphe ntụmatu. ");
INSERT INTO iqw_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jósẹfu ajịko nri, a kọtaru lẹ Íjiputu l'afa ẹsaa ono, nri nọ ono kwakọkota; doo ya l'ụlo ẹke, eedobeje nri l'edukfu l'edukfu. Yọo bụje; ọ -bya l'edukfu; yọ tụko iphe, bụ nri, a kọtaru l'ẹgu, nọ l'ụzo ibyiya onanu kwakọbe. ");
INSERT INTO iqw_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jósẹfu wụleruphu akpe, e gbutaru egbuta jeye yọ kụru l'ikpo, ha l'ọ bụ eveve mgbogidi ẹnyimu. Nri ono hatabe nshinu; k'ọphu a nọnyaaru; e debuhu iya l'ẹkwo; kẹ l'ọ kpọwaru ẹka ẹge ee-me gụta iya agụta. ");
INSERT INTO iqw_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","T'afa ẹjo-ẹgu ono kwaa bya bẹ Asenatu, bụ nwatibe Pọtifera, agwajẹru ndu Ọnu iphe mụtawaru Jósẹfu ụnwegirima unwoke labụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jósẹfu gụru ọkpara iya Manásẹ; sụ: “Lẹ Nchileke mewaru tẹ ya zahaa iphe-ẹhuka, byaru iya nụ; zahaakwaphu ufu nna iya.” ");
INSERT INTO iqw_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Onye k'ẹbo b'ọ gụru Ífuremu; sụ: “Ọo Nchileke bẹ meru tẹ ya barahụ l'alị-a, ya shi eje ntakfuru-wa.” ");
INSERT INTO iqw_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Afa ẹsaa ono, nri nọ lẹ Íjiputu ono abya agvụ. ");
INSERT INTO iqw_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Afa ẹsaa k'ẹjo-ẹgu phụ abya abya. Yọ bụleruphu ẹge ono, Jósẹfu kfuru ono b'o meru. Ẹjo ẹgu ono emekota ndu mkpụkpu ọdo; yọ bụru Íjiputu nwẹnkinyi bụ ẹke nri nọ. ");
INSERT INTO iqw_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ẹjo ẹgu ono emedelephu ndu Íjiputu; ẹphe eje aralahaaru Fero ẹkwa nri. Fero asụ ndu Íjiputu kpamukpamu: “Unu jekfuje Jósẹfu. Iphe ọ sụjeru t'unu mee; unu emee ya!” ");
INSERT INTO iqw_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ẹjo ẹgu ono edzuleruphu alị ono; Jósẹfu eworu ụlo ono, e doru nri ono tụhashia; reshilahaa ndu Íjiputu nri; kẹ l'ẹjo-ẹgu ono ajawa madzụ eze l'alị Íjiputu gbaa mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Iphe bụ mbakeshi abyajẹ Íjiputu ọkpata Jósẹfu nri; kẹ l'ẹjo-ẹgu ono ajawa madzụ eze l'iphe bụ mgboko mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jékọpu anụa lẹ nri nọ lẹ Íjiputu; bya ajị ụnwu iya ẹge ọ dụ bẹ ẹphe nọdu; chịru ẹnya yeru onwẹphe ẹge ono? ");
INSERT INTO iqw_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Wo ẹphe: “Lẹ ya nụkwaru lẹ nri nọ lẹ Íjiputu. Unu jekwa ẹke ono je akpata nri; k'ọphu ẹgu te egbushidu ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tọ dụ iya bụ; ụnwanna Jósẹfu ẹphe iri atụgbua jeshia ọkpata nri lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Obenu lẹ Jékọpu te kwedu tẹ Bénjaminu, bụ nwunne Jósẹfu tsoru ẹphe; kẹ l'ọotsu egvu l'iphe e-me iya. ");
INSERT INTO iqw_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tọ dụ iya bụ; ụnwu Ízurẹlu etsoru lẹ ndu jeru ọkpata nri; kẹ l'ẹjo-ẹgu ono rukwaruphu alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ya ndono; yọ bụru Jósẹfu bụ gọvano ndu Íjiputu; bụru iya ereje ndu alị ono nri. Tọ dụ iya bụ; ụnwanna iya phẹ ono erua bya ebyishi ikpere; puaru iya ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Jósẹfu aphụlephu ụnwanna iya ono; hụbewaphu ẹphe ama; melahaa l'ẹ tọ madu ẹphe; kfulahaaru ẹphe ntanwụ ntanwụ; ji ẹphe ẹke ẹphe shi? Ẹphe asụ iya l'ẹphe shikwa alị Kénanu abya ọkpata nri. ");
INSERT INTO iqw_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ọ bụ oswi-okfu lẹ Jósẹfu hụbekotaru ụnwanna iya ono ama; obenu l'ẹphebedua ta hụbehedu iya ama. ");
INSERT INTO iqw_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tọ dụ iya bụ; Jósẹfu abya anyata nrọ ono, ọ rọjeru l'ẹhu ẹphe ono; sụ ẹphe: “L'ẹphe bụ ndu ngge. L'iphe, ẹphe byaru bụ t'ẹphe maru ẹke, a tụzoru ẹhu l'alị-a!” ");
INSERT INTO iqw_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ẹphe asụ iya: “Onye nwe mu nụ; wawakwa; l'ọ kwa nri bẹ ẹphebe ndu ozi ngu byaru akpata. ");
INSERT INTO iqw_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","L'ọ kwa nna lanụ bẹ mụkotaru ẹphe. L'ẹphebe ndu ozi ngu bụkwa ndu ire-lanụ; l'ẹphe ta bụkwa ndu ngge.” ");
INSERT INTO iqw_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jósẹfu asụ ẹphe: “L'ọo ẹjo-ire! L'iphe ẹphe byaru bụ t'ẹphe maru ẹke, a tụzoru ẹhu l'alị-a!” ");
INSERT INTO iqw_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ẹphe asụ iya: “L'ẹphebe ndu ozi ngu dụkwa iri l'ẹbo shi lẹ nna lanụ l'alị Kénanu. Onye kẹ nwata bẹ yẹle nna ẹphe nọ l'ufu; onye lanụ bẹ ta anọhedu nụ.” ");
INSERT INTO iqw_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jósẹfu asụ ẹphe: “L'ọ bụ iphe ono, ya kfuru ono bẹ unu bụ; mbụ l'unu bụ ndu ngge! ");
INSERT INTO iqw_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ọwaa ẹge ee-shi maru ire unu ndọ-ọ: Ọ -bụrua lẹ Fero nọ-ọ ndzụ ẹge ọ nọ iya; bẹ unu ta aladu l'ẹ ba bụ lẹ nwanna unu kẹ nwata phụ b'e dutaru bya l'ẹke-a. ");
INSERT INTO iqw_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Iphe unu e-me bụ t'unu zi onye lanụ l'ime unu t'o je eduta nwanna unu ono; unu bẹ ndu ọphu l'unu ha bẹ a-nọdukota lẹ mkpọro. Ọo ya bụ; t'e shi ẹge ono; maru mẹ iphe, unu ekfu; ?ọ bụa oswi-okfu. Teke ẹ t'ọ -dụdu; Fero -nọdu-a ndzụ ẹge-a, ọ nọnu iya-a bẹ unu bụkwa ndu ngge l'oswiya.” ");
INSERT INTO iqw_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yọ chịta ẹphe je eye lẹ mkpọro; ẹphe anọo abalị ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Yo be mbọku k'ẹto; Jósẹfu asụ ẹphe: “Unu -mewa iphe-a, ya abya ekfukfu-a bẹ ndzụ e-dzukwa-a unu; kẹle yẹbe Jósẹfu bụkwa onye atsụ Nchileke egvu. ");
INSERT INTO iqw_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ọ -bụru l'unu bụ ndu ire-lanụ l'oswiya; t'onye lanụ l'unu nọdu lẹ mkpọro l'ẹke-a; tẹ ndu ọphu wota nri wolaaru ndibe unu ọphu ẹgu eme l'ufu. ");
INSERT INTO iqw_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Obenu lẹ nwanna unu kẹ nwata ono bẹ unu dutafuje dutaru iya l'ẹke-a. Teke unu meru iya ẹge ono; ya amaru l'unu bụ ndu ire-lanụ; haa t'ẹ b'e egbushi unu.” Ẹphe ekweta; ");
INSERT INTO iqw_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","kfulahaaru onwẹphe: “L'ọ kwa iphe ẹphe meru nwanna ẹphe bẹ aanụ ẹphe aphụ iya ẹge-a. L'ẹphe phụru egbe aphụ, ọ gụru kpua ẹphe teke ono, o shi arọo t'e dobe iya ndzụ ono; ọphu ẹphe angadụru iya nchị. L'ọ kwa iphe ono kparu iphe ẹphe eje egbe iphe-ẹhuka-a ntanụ-a.” ");
INSERT INTO iqw_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rúbẹnu asụ ẹphe: “?Ya te kfuduru unu t'ẹ b'ọ dụ iphe unu e-me nwata ono; unu te yeru iya ọnu? Nta-a bẹ ọchi iya nọnu ẹphe l'ishi.” ");
INSERT INTO iqw_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ẹphe ta ma lẹ Jósẹfu anụ iphe ẹphe ekfu; keshinu ọphu o nweru onye atụ-nweru iya iphe ẹphe ekfu. ");
INSERT INTO iqw_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jósẹfu eshi l'ẹke ẹphe nọ lụfu je awata ọra ẹkwa; metsua laphutashia azụ bya ekfuru yeru ẹphe ọdo. Yọ sụ t'a kpụfuta Símiyọnu; kee ya ẹgbu l'ifu ẹphe l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jósẹfu abya asụ t'e yejishiaru ẹphe nri l'ẹda ẹphe; yephukotaru ẹphe okpoga ẹphe azụ l'ẹda ẹphe; a nụ ẹphe nri, ẹphe e-ri l'ụzo. E megetsulephu ẹge ono, o kfuru ono; ");
INSERT INTO iqw_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ẹphe apatsụaru ẹda nri ẹphe ono doo l'eli nkakfụ-ịgara ẹphe; tụgbua; yọ bụru ẹphe alala. ");
INSERT INTO iqw_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ẹphe erua l'ẹke ẹphe nọ-zitaru k'aradu; onye lanụ l'ime ẹphe abya atọshia ẹda iya tẹ ya hata nri nụ nkakfụ-ịgara iya; okpoga iya anọduwa l'ọnu ẹda ono. ");
INSERT INTO iqw_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Yọ sụ unwunne iya ndu ọphu: “Inhii; mẹ okpoga iya b'e gbe yephukwaru iya azụ! Ọwaa ya l'ẹda iya l'ẹke-a!” Meji atọfu ẹphe; ẹhu anmalahaa ẹphe anmanma. Ẹphe asụ onwẹphe: “?Bụ egbe ngụnu bẹ Nchileke meru ẹphe ẹge-a?” ");
INSERT INTO iqw_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ẹphe alaruta Kénanu; bya atụko iphemiphe ọbule, meru nụ kọoru nna ẹphe; mbụ Jékọpu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“L'onye bụ ishi l'alị ono bẹ kfukwaru ẹphe ntanwụ ntanwụ; mee ẹphe l'ọ bụ ndu byaru ngge l'alị ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Obenu l'ẹphe kfukwaru iya l'ẹphe kwa ndu ire-lanụ; l'ẹphe ta bụkwa ndu ngge. ");
INSERT INTO iqw_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","L'ẹphe dụkwa unwoke iri l'ẹbo shi lẹ nna lanụ. Onye lanụ ta nọhedu; onye kẹ nwata bẹ yẹle nna ẹphe nọ l'ufu lẹ Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ya ndono; onye ishi ono, achị ndu alị ono asụ: ‘L'ẹge ya e-shi maru mẹ ayi bụ ndu ire-lanụ bụ t'ayi haa onye lanụ l'ayi tẹ yẹle iya nọdu l'ẹke ono; ayịbe ndu ọphu ewota nri wolaaru ndibe ayi, ẹgu eme. ");
INSERT INTO iqw_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ọlobu t'ayi dutakwaru iya nwanna ayi kẹ nshịi phụ. Ọo ya bụ; ya amaru l'ayi ta bụdu ndu byaru ngge; l'ayi bụ-a ndu ire-lanụ l'oswiya. Teke ono; ya eduru nwunne ayi ọphu nụ ayi; ayi ejelahawaru ẹge dụ ayi mma l'alị ono.’ ” ");
INSERT INTO iqw_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","L'ẹphe wataru ọtoshi ẹda ẹphe ono; bẹ ẹphe phụtsuaru ẹkpa okpoga ẹphe l'ime ẹda ẹphe ono. Egvu egude ẹphe; gudekwaphu nna ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nna ẹphe; mbụ Jékọpu asụ ẹphe: “Nta-a bẹ unu emewa t'unu nagee ya ụnwu iya. Jósẹfu ta nọhedu; Símiyọnu ta nọhe; nta-a bẹ unu emefua t'unu natafụa ya Bénjaminu. Ẹ to nwehedu ẹke ya shiru iya nta-a, ọ dụkwaduru iya lẹ ntse.” ");
INSERT INTO iqw_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rúbẹnu asụ nna iya: “Ọ -bụru lẹ ya te edulataduru ngu Bénjaminu; gbulephu ụnwegirima kẹ yẹbe Rúbẹnu; ẹphe ẹbo-ọ. Ye iya Bénjaminu l'ẹka; ya e-dulataru ngu iya-a.” ");
INSERT INTO iqw_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Obenu lẹ Jékọpu sụru: “Wawa; nwa mu; Bénjaminu te tsodu unu; kẹle nwunne iya nwụhuhawaru; nta-a bụwa-a yẹbedua nwẹnkinyi iya. O -nweru iphe meru iya nụ l'ụzo; bụwa iphe unu eme bụ tẹ ya gude ishi-ẹwo iya-a gụa aphụ laa maa.” ");
INSERT INTO iqw_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ya ndono; ẹjo-ẹgu ono te kwe ekwekwe l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ndibe Jékọpu erigelephu nri ono, ẹphe shi lẹ Íjiputu wolata ono; Jékọpu asụ ụnwu iya t'ẹphe la azụ lẹ Íjiputu je azụtafuaru ẹphe nri! ");
INSERT INTO iqw_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Júda asụ iya: “Lẹ nwoke ono nmakwaru ẹphe ọkwa nmashia ya ike: l'ẹ te ekwekwa t'ẹphe phụ iya ọdo; m'ọ -bụru l'ẹphe lẹ nwanna ẹphe ono ta ayịdu.” ");
INSERT INTO iqw_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wo iya: “I -kwe t'ẹphe lẹ Bénjaminu yịru; bẹ ẹphe e-jekwa-a je akpata ngu nri ọbu. ");
INSERT INTO iqw_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ọ -bụru l'i ti kwedu; bẹ ẹphe te ejekwa; kẹle nwoke ono nmakwaru ẹphe ọkwa nmashia ya ike: l'ẹ te ekwekwa t'ẹphe phụ iya ọdo; m'ọ -bụru l'ẹphe lẹ nwanna ẹphe ono ta ayịdu.” ");
INSERT INTO iqw_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ízurẹlu ajị ẹphe: “?Nanu ẹge ọ dụ; bẹ unu kfulahaaru nwoke ono l'unu nweru nwanna ọdo; shi ẹge ono wolataru iya egbe iphe-ẹhuka ọwaa?” ");
INSERT INTO iqw_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ẹphe asụ: “L'ọ kwa nwoke ono jịlahaaru ẹphe njịkponu; l'akpa ẹphe ishi ẹhu ẹphe; mẹ kẹ ndibe ẹphe. Ọ jịru ẹphe: ‘Mẹ nna ayi; ?ọ nọkwadu-a ndzụ? Mẹ ayi nwefuaru nwunne ọdo?’ Ayi ekwelephu l'eyekotaru iya ọnu l'iphe ọoji. ?O nweru teke ayi maru l'ọo-sụ t'ayi duta nwanna ayi ọbu byatashia ẹke ono?” ");
INSERT INTO iqw_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ya ndono; Júda asụ Ízurẹlu; mbụ nna iya: “T'ọ haa tẹ yẹle nwata ono yịru; ẹge ẹphe a-tụgbu nta-a jeshia; k'ọphu nggụbedua; yẹbedua; mẹ ụnwu ẹphe a-waru; t'ẹgu be egbushi ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mbẹdua, bụ Júda asụberu ngu ndzụ mu l'ishi nwata ono. Ọ -bụru lẹ mu te dulataduru ngu iya; taa mu ụta iya jeye lẹ gbururu. ");
INSERT INTO iqw_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","“Ndẹge ayi te eshi keshinu ono nọduta ẹke-a; mgbẹ nta-a bẹ ayi ge ejewa nụ gbe latawanụ ugbo ẹbo.” ");
INSERT INTO iqw_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tọ dụ iya bụ; nna ẹphe ono; mbụ Ízurẹlu asụ ẹphe: “Ọ -bụru l'ọ bụ ẹge ono; bẹ ee-mefutaje iya; bụkwa iya bụ t'unu wotatsua iphe katsụa mma l'iphe, a kọtaru l'alị-a ye l'ẹda, unu a-nụ nwoke ono. Unu gude nwa manụ bamụ; nwa manụ-ẹngu; etse; mẹeru; akpụru pisutasho; mẹ akpụru alụmondu. ");
INSERT INTO iqw_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Unu egude okpoga, ha l'ọ bụ ọphu unu gudehawa ugbo labụ; k'ọphu unu a-dụ ike nụ-phu ẹphe okpoga ono azụ; mbụ okpoga ono, e yetsuaru unu l'ọnu ẹda unu ono; kẹ l'o nweru ike bụru l'ẹphe te elebezidu ẹnya mee ya. ");
INSERT INTO iqw_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","“Unu duta nwanna unu ọbu; tụgbua jekfu nwoke ọbu nta-a! ");
INSERT INTO iqw_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Tẹ Nchileke, bụ Ọkaribe-Kakọta-Ike mee t'imiko unu dụ nwoke ono t'o kwe t'unu lẹ Símiyọnu; mẹ Bénjaminu jịko yịru lata. A bya lẹ mbẹdua; ọ -bụru l'ọo ume-nwa; t'o menua mu.” ");
INSERT INTO iqw_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","To dụ iya bụ; ẹphe abya egwota iphe ono, ẹphe a-nụ Jósẹfu ono; bya ewota okpoga, ha l'ọ bụ ọphu ẹphe gudehewa ugbo labụ; bya eduta Bénjaminu; yọ bụru ẹphe oje Íjiputu. Ẹphe erua bya evudo Jósẹfu l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Jósẹfu aphụlephu Bénjaminu l'ẹke ẹphe l'iya yị; sụ nwozi ụlo iya: “T'o duta ndu ono je nk'iya.” Wo iya: “T'o gbua anụ gude meeru ẹphe kẹ nri; kẹ l'ẹphe l'iya e-riko nri l'eswe.” ");
INSERT INTO iqw_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nwoke ono abya emee ẹge ono, Jósẹfu kfuru iya ono; duta ẹphe lashia kẹ Jósẹfu. ");
INSERT INTO iqw_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","E dutalephu ẹphe je edobe l'ụlo Jósẹfu ono; egvu abya ẹphe l'ẹhu. Ẹphe arịlahaa l'iphe, kparu iphe e dutaru ẹphe dobe l'ẹke ono bụ k'okpoga phụ, e yekwaziru ẹphe azụ l'ẹda ẹphe lẹ mbọku k'ivuzọ phụ; l'ẹphe mawaru l'iphe, oome t'o mee bụ t'o shi ẹge ono tso ẹphe ọgu lụ-gbua ẹphe t'ẹphe bụru ohu iya; kpụtakota nkakfụ-ịgara ẹphe nworu. ");
INSERT INTO iqw_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ya ndono; ẹphe ejekfu nwozi Jósẹfu ono l'ọnu ụlo ono; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Byiko nna; l'ugbiya ọphu l'ẹphe byajẹru ọkpata nri phu; ");
INSERT INTO iqw_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","bẹ ẹphe ruru ẹke ẹphe a-radụ; bya atọhaa ẹkpa ẹphe; phụ l'okpoga, ẹphe gudetsua kpata nri bẹ nọtsua l'ọnu ẹkpa ẹphe; to gbe nwedu ọphu e wofuru m'ọo afụ. Lẹ nta-a bẹ ẹphe wolatakotakwaru iya unu.” ");
INSERT INTO iqw_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Wo iya: “L'ẹphe gudekwaphu okpoga ọdo, ẹphe e-gude kpatafua nri. L'ẹphe ta makwa onye yekwaziru ẹphe okpoga ono azụ l'ẹkpa.” ");
INSERT INTO iqw_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Onye ọru Jósẹfu ono asụ ẹphe: “Unu nọduru nwandoo; unu ba atsụshi egvu! Ọ bụ Nchileke unu; mbụ Nchileke kẹ nna unu bẹ yeshiru unu okpoga ono l'ẹda unu; kẹ l'okpoga unu l'ọgiya ọphu bẹ bụ yẹbedua nataru iya.” Tọ dụ iya bụ; yo je atụfuta Símiyọnu; duta iya jekfube ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Onye ozi ono eduta ẹphe je edobe l'ụlo Jósẹfu; bya ekee ẹphe mini; ẹphe akwọo ọkpa; bya anụ nkakfụ-ịgara ẹphe nri. ");
INSERT INTO iqw_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ẹphe abya akwakọbe iphe ono, ẹphe gude, ẹphe a-nụ Jósẹfu ono; mbụ iphe, ẹphe a-nụ iya teke ọ lataru l'eswe; kẹ l'ẹphe nụru l'ọ bụ l'ẹke ono bẹ ẹphe e-ri nri. ");
INSERT INTO iqw_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Jósẹfu alatalẹphu; ẹphe abya egworu iphe ono, ẹphe guderu iya ono nụ iya; bya efooru iya ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yọ jị ẹphe ẹge ẹphe dụ; jịkwaphu ẹphe ẹge nna ẹphe dụ; mbụ nwoke ọgurenya ono, ẹphe kfuru iya okfu iya ono? “?Ọ nọkwadua ndzụ?” ");
INSERT INTO iqw_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ẹphe asụ iya: “L'o nwozi iya ono; mbụ nna ẹphe nọkwa-a ndzụ; ẹhu adụ iya mma.” Ẹphe abya efokwaaru iya phụ ifu l'alị ọdo. ");
INSERT INTO iqw_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yọ bya apalia ẹnya phụa Bénjaminu; onye ọphu bụ nwunne iya l'ẹpho. Yọ jị ẹphe: “?Bụ nwunne unu kẹ nwata, unu shi ekfuru iya ọbu ndọ-ọ?” Yọ bya asụ Bénjaminu: “Nwa mu; tẹ Nchileke meeru ngu eze-iphe-ọma!” ");
INSERT INTO iqw_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Imiko nwunne iya ono adụ iya l'ọ phụru iya. Jósẹfu alụfu-kebe; jeshia ọcho ẹke ọo-nọdu raa ẹkwa. Yọ bya abahụ l'ime mkpura iya je anọdu raa ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yo metsua bya aswaa ifu; lụfuta; kpade onwiya; sụ t'e gwofutaru ẹphe nri. ");
INSERT INTO iqw_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","E doberu Jósẹfu nri nk'iya iche; doberu ụnwanna iya nk'ẹphe iche; bya edoberu ndu Íjiputu, nọ l'ẹke ono nk'ẹphe iche; kẹ l'ọoduje ndu Íjiputu oyi t'ẹphe lẹ ndu Híburu rigbabe nri. ");
INSERT INTO iqw_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ndu ono b'e doru; ẹphe aghaaru Jósẹfu ifu; nọo l'ẹge ẹphe bụ ọgurenya. Ẹphe shi l'ọkpara nọo jeye l'onye ọphu katsụkpo ọburu nwata. Yọ dụkota ẹphe biribiri. ");
INSERT INTO iqw_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","A bya eshi lẹ teburu kẹ Jósẹfu keeru ẹphe nri; oke iya kẹ Bénjaminu aka kẹ ndu ọphu ugbo ise. Ẹphe etsoru Jósẹfu ria; ngụa; tee ẹswa. ");
INSERT INTO iqw_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ya ndono; Jósẹfu asụ onye ejeru iya ozi l'ụlo: “T'o yejishiaru ndu ono nri l'ẹda ẹphe; yetabe l'iya phụ ẹge ẹphe e-gudeghe.” ");
INSERT INTO iqw_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Wo iya: “T'o wota okoro mkpọla-ọcha kẹ yẹbe Jósẹfu ye l'ọnu ẹda onye kẹ nwata; mẹkwaphu okpoga, o gude bya ọkpata nri.” Yọ bya emee ya ẹge ono, Jósẹfu kfuru iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Yo be l'ọnma-ẹwa ụtsu echile iya; a bya edube ndu ono; ẹphe alashia; ẹphe lẹ nkakfụ-ịgara ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ẹphe eshilephu lẹ mkpụkpu ono tụgbua; ọle ẹ to nwedua ẹge ẹphe jeberu; Jósẹfu asụ nwozi iya ono: “Tsopyabe ndu ono nta-a nta-a. Teke i gbakfuru ẹphe; nggu ajị ẹphe: ‘?Ẹge ọ dụ bẹ ẹphe gbe gude ẹjo iphe kfụa ụgwo ọhuma, e meru ẹphe? ");
INSERT INTO iqw_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","?Tọ bụdu okoro, nnajiufu iya angụje mini ndọ-ọ; mbụ okoro oogudeje aphụ ẹnya-labụ? Iphe ono, unu meru ono bụkwa ishi iphe, dụ ẹji b'ọ bụ!’ ” ");
INSERT INTO iqw_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Onye ozi ono abya agbakfu ẹphe; bya ewotalephu iphe ono, Jósẹfu ziru iya ono kfuaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ẹphe asụ iya: “Onye nwe mu nụ; ?nanụ ẹge ọ dụ bẹ iikfu ẹge ono? Tẹ njọ gbakwa ẹgbudu; l'ọo ẹphebedua, bụ ndu ozi ngu e-je ome egbe iphe onanu! ");
INSERT INTO iqw_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mkpọla-ọcha, ẹphe phụtsuaru l'ẹda ẹphe l'iche l'iche bẹ ẹphe shiru lẹ Kénanu wolataru unu. ?Nanụ ẹge ẹphe e-gbe bya eshi l'ụlo nnajiufu ngu zita mkpọla-ododo iya; m'ọ kwanụ mkpọla-ọcha iya? ");
INSERT INTO iqw_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ọ -bụru l'a chọru iphe ono; yo nweru ẹphebe ndu ozi ngu-a onye, a chọ-vuru iya l'ẹka; t'ishi onye ọbu lakwaa ya; ẹphebe ndu ọphu l'ẹphe ha aghọo ohu nggụbe onye nwe mu nụ.” ");
INSERT INTO iqw_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yọ sụ ẹphe: “L'ọ dụ mma; t'ọ dụ ẹge ono, ẹphe kfuru iya ono. Ọlobu l'ọo onye a phụru, gude iya nụ bẹ a-bụru iya ohu; unu bẹ ndu ọphu l'unu ha ta dụdu iphe eeme unu.” ");
INSERT INTO iqw_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Onyenọnu abya apazitawaphu ẹda iya ẹgwegwa ono; tọhaa ya. ");
INSERT INTO iqw_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Onye ozi ono abya awata iya achọcho. Yo shi l'ẹda k'onye ọphu kakọta ọbu ọgurenya chọo ya jeye l'ẹda k'onye ọphu kakọta ọ bụ nwata. Yo rua l'ẹda kẹ Bénjaminu; je aphụa okoro ono l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ya ndono; ẹphe eworu uwe ẹphe lajashịa; bya apaa ivu ẹphe tukobetsua nkakfụ-ịgara ẹphe l'okpurukpu-azụ; yọ bụru ẹphe ọla azụ lẹ mkpụkpu ono. ");
INSERT INTO iqw_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Teke Júda yẹle unwunne iya rutaru bẹ Jósẹfu nọdukwadua l'ụlo. Ẹphe abya adashịa ya kpurumu kpurumu l'ifu. ");
INSERT INTO iqw_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jósẹfu ajị ẹphe ẹge ọ dụ bẹ ẹphe meru egbe iphe onanu? Wo ẹphe: “?Unu ta amadụ lẹ nwoke, dụ l'ọ bụ yẹbedua aphụje ẹnya labụ tọo.” ");
INSERT INTO iqw_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Júda asụ: “?Onye nwe mu nụ; ?bụ ngụnu bẹ ẹphe makwadụru, ẹphe e-kfuru ngu nta-a? ?Bụkwadu ngụnu bẹ ẹphe e-kfu? Nanụkwadu ẹge ẹphe e-shi dofu onwẹphe? Nchileke meekwaru t'iphe, dụ ẹji, ndu ozi ngu meru vọo. Nta-a bẹ ẹphe bụakwa ohu nggụbe onye ishi; ẹphebedua; mẹ onye a phụru okoro ono l'ẹka iya.” ");
INSERT INTO iqw_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Jósẹfu asụ ẹphe: “Tụswekwa! Lẹ ya te emekwa iya ẹge ono. L'ọ kwa onye ono, a phụru okoro ono l'ẹka ono a-bụru iya ohu. Unubẹ ndu ọphu; unu lakfu nna unu lẹ chịriru lẹ werere.” ");
INSERT INTO iqw_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ya ndono; Júda ejekfube Jósẹfu je asụ iya: “Onye nwe mu nụ; byiko; tẹ yẹbe nwozi ngu kfunuru yeru ngu. Ọ bụ oswi-okfu lẹ nggu lẹ Fero ha. Ọlobu; byiko; t'ẹhu be eghukwa ngu eghughu l'ẹke ya nọ. ");
INSERT INTO iqw_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Onye nwe mu nụ: ‘Ọ bụ nggụbedua bẹ jịru ayịbe ndu ozi ngu; ?mẹ ayi nweru nna; m'ọ bụ nwunne nwoke?’ ");
INSERT INTO iqw_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ayi asụ ngu lẹ nna ayi nọkwa-a; ọle ọ bụwa nwoke ọgurenya; l'o nweru nwata nwoke, a mụru iya lẹ nka. Nwunne nwata ono bẹ nwụhuwarunu; yọ bụwarua yẹbedua nkịnyi iya bẹ phọduru nụ lẹ ndu ọphu shi l'ẹpho nne iya; nna iya eyekwanuru iya obu nshinu. ");
INSERT INTO iqw_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Tọ dụ iya bụ; nggu abya asụ ayịbe ndu ozi ngu t'ayi dutaru ngu nwata ono l'ẹke-a t'ị phụ. ");
INSERT INTO iqw_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ayi asụ nggụbe onye nwe mu nụ lẹ nwata ono te egbeshijekwa egbeshi l'ẹke nna iya nọ; l'o -gbeshi bẹ nna iya a-hakwa ishi. ");
INSERT INTO iqw_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Obenu l'ị sụru ayịbe ndu ozi ngu: ‘L'ọ -bụru lẹ nwanna ayi kẹ nwata ono te etsodu ayi bya bẹ ayi ta aphụhekwa ngu ọdo.’ ");
INSERT INTO iqw_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","L'ayi ruru ufu bẹ ayi jeru je ekfuaru nwozi ngu, bụ iya bụ nna ayi ẹge nggụbe onye nwe mu nụ kfuru. ");
INSERT INTO iqw_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Onye ozi ngu ono, bụ iya bụ nna ayi asụ ayi: ‘T'ayi tụgbua je azụtafua nri ọdo!’ ");
INSERT INTO iqw_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ayi asụ iya l'ayi te ejekwa; a gụfukwa lẹ nwanna ayi kẹ nwata ono tso ayi; kẹ l'ayi ta adụdu ike ọphu nwoke ono; l'ẹbe abụ lẹ nwanna ayi kẹ nwata ono tso ayi. ");
INSERT INTO iqw_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Onye ozi ngu ono, bụ iya bụ nna ayi asụ ayi: ‘L'ayi marua lẹ nyee ya mụtaru iya ụnwegirima unwoke labụ. ");
INSERT INTO iqw_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Onye lanụ bẹ ya ta phụhedu; ya asụ lẹ ya mawaru l'ọ bụ anụ-ẹgu-ẹgbudu bẹ fọ-gburu iya nụ. Keshinu teke ono bẹ ya ta phụkwa iya. ");
INSERT INTO iqw_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Wo ayi: L'ọ -bụru l'ayi dutafuaru onye ọwaa tụgbua; o -nweru iphe meru iya nụ bụnu iya bụ l'unu mewaru tẹ ya gude ishi ẹwo; gụa aphụ laa.’ ");
INSERT INTO iqw_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ọo ya bụ; ọ -bụru lẹ nwata ono te etsodu ayi laa; lakfu nwozi ngu ono, bụ iya bụ nna ayi ono; mbụ; ọ -bụru lẹ nna ayi ono, ndzụ iya yẹle kẹ nwata ono bụwa iphe lanụ ono; ");
INSERT INTO iqw_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","-phụ ayi; ayi lẹ nwata ono ta yị lata; bẹ ọo-hakwa ishi. Iphe ọ bụ abụru l'ọo ayịbedua bẹ meru t'o gude nggụmaphu laa lẹ nka. ");
INSERT INTO iqw_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mubẹ nwozi ngu, bụ Júda bẹ kwekwaru nna mu ụkwa l'ẹ tọ dụdu iphe e-me nwata-a. Mu sụru iya: ‘L'ọ -bụru lẹ mu te edulataduru iya ẹya; t'ọ taa mu ụta iya gbururu jeye lẹ gbururu.’ ");
INSERT INTO iqw_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Ọo ya bụ; byiko tẹ mụbe nwozi ngu nọdunu l'ẹke-a bụru ngu ohu l'ọzori nwata ono; tẹ nwata ono tsoruru ụnwunna mu ndu ọphu la. ");
INSERT INTO iqw_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","?Nanụkpoo ẹge mu e-me lakfu nna mu; lẹ mu lẹ nwata ono ẹbe ayị? Byiko be emekwa tẹ mu phụ egbe aphụ ọwaa a-byakfuta nna mu ẹge-a!” ");
INSERT INTO iqw_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ya ndono; Jósẹfu ta dụhe ike kpade onwiya l'ẹke ndu, ejeru iya ozi nọ; yo chia mkpu; sụ t'e mee t'onyemonye ọbule lụfu iya l'ifu. Ẹphe awụfu; to nwehe onye yẹle iya nọkwadu l'ẹke ono. Ọ bụ teke b'o meru t'ụnwunna iya maru onye ya bụ. ");
INSERT INTO iqw_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yọ wata ẹkwa; rashịa ya ike; k'ọphu bụ lẹ ndu Íjiputu nụru iya; ndibe Fero anụkwaa ya phụ. ");
INSERT INTO iqw_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jósẹfu asụ ụnwunna iya ono: “L'ọ kwa yẹbedua bụ Jósẹfu! Nna iya; ?ọ nọkwadua ndzụ?” Yọ kpọo ụnwunna iya ono okfu; kẹ l'egvu gudekotaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Jósẹfu abya asụ ẹphe t'ẹphe kpịrita iya ntse. Ẹphe ekwe bya akpịrita. Yọ sụ ẹphe: “L'ọ kwa yẹbedua bụ nwanna unu phụ; mbụ Jósẹfu ono, unu reru ndu Íjiputu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Wo ẹphe: “Unu ba awakwa obu; ọphu unu 'atakwa onwunu ụta; k'erere, unu reru iya. Kẹ l'ọ kwa ẹge ee-shi t'a dzọo ndiphe ndzụ kparu iphe Nchileke zifuru iya tẹ ya vuru unu ụzo bya. ");
INSERT INTO iqw_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ọwaa kwewa afa ẹbo, ẹjo-ẹgu-a mewaru l'alị-a. L'ime afa ise ọphu abya nụ b'ẹ to nwekwa onye emebe iphe l'alị; k'ọphu ọ bụru k'akpata iya. ");
INSERT INTO iqw_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ọ bụ Nchileke zifuru yẹbe Jósẹfu tẹ ya vuru unu ụzo bya; k'ọphu ya e-me t'eri unu phọdu lẹ mgboko; mekwaaphu t'unu lẹ ndu eri unu dụ l'igwe wafụ. ");
INSERT INTO iqw_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ọo ya bụ; l'ẹ tọ bụkwa unubẹdua bẹ ziru iya tẹ ya bya ẹke-a; ọ kwa Nchileke. Ọ bụ Nchileke ono meru iya; ya anọdu ọnodu nna Fero; mee ya; ya abụru ishi l'ufu eze; bụkwaru iya phụ l'alị Íjiputu l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nta-a bụkwa t'unu tụgbua ẹgwegwa je ekfuru nna iya: ‘Lẹ nwatibe iya; mbụ Jósẹfu sụru lẹ Nchileke mewaru yẹbe Jósẹfu onye ishi ndu Íjiputu kpamukpamu. T'ọ byalẹkwaphu nta-a lakfuta iya; t'ẹ b'o jekwa ọkpo ụkfu! ");
INSERT INTO iqw_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ẹke oo-buru bụ lẹ Gọ́shenu ẹke yẹbedua yẹle ụnwu iya; mẹ ụnwu nwanwa iya e-bunyabe iya ebunyabe; mbụ jeye l'atụru iya; eswi iya; mẹwaru iphemiphe ọbule, unu nweru enweru l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I -nọdu lẹ Góshẹnu bẹ ya e-leta ngu ẹnya; kẹ l'ẹjo-ẹgu-a, byaru nụ-a e-mefukwaa afa ise nta-a. Ọdumeka bẹ yẹbedua; ndibe iya; mẹ iphemiphe ọbule, bụ nk'iya bẹ ẹgu e-gbukwa.’ ");
INSERT INTO iqw_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Unubẹdua l'onwunu jeye lẹ nwunne iya; mbụ Bénjaminu gudewa ẹnya unu ele l'ọ bụ yẹbedua, bụ Jósẹfu gẹdegede ekfu okfu-a anụ unu. ");
INSERT INTO iqw_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Unu kọoru nna iya k'egbe ugvu, a kwabẹru yẹbe Jósẹfu lẹ Íjiputu; mẹ k'iphemiphe ọbule, unu phụkotaru l'onwunu. Unu dutakwa nna iya bya ẹke-a ẹgwegwa!” ");
INSERT INTO iqw_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yọ bya agbakụa nwunne iya; mbụ Bénjaminu ẹka l'olu; wata ọra ẹkwa. Bénjaminu arụkotakwa iya phụ; wata ẹkwa nk'iya. ");
INSERT INTO iqw_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Jósẹfu abya anmakọta ụnwanna iya ono akpa l'ẹphe ha; l'arakwaphụ ẹkwa. E metsua yẹle ụnwanna iya ono abya akọo akọ. ");
INSERT INTO iqw_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nzi abya erua kẹ Fero lẹ unwunne Jósẹfu bẹ byaru nụ; ẹhu atsọo Fero yẹle ndu ozi iya l'ẹphe ha ẹna. ");
INSERT INTO iqw_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fero asụ Jósẹfu: “T'o kfuru ụnwanna iya phẹ t'ẹphe gwoo ivu ẹphe doo l'eli elu ẹphe; la Kénanu; ");
INSERT INTO iqw_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","je eduta nna ẹphe; mẹ ndibe ẹphe kpamukpamu gude bya. Ya a-nụ ẹphe alị Íjiputu ẹke ọphu kakọta mma; k'ọphu ẹphe e-buru iya l'eriji ẹpho. ");
INSERT INTO iqw_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kfuru ẹphe t'ẹphe pata ụgbo-ịnya ndu Íjiputu gude je achịta ụnwegirima ẹphe; unyomu ẹphe; mẹ nna ẹphe bya. ");
INSERT INTO iqw_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","T'ẹphe ba yọkwa ọshi ẹge ẹphe e-me iphe, ẹphe a-ha l'ufu; kẹ l'iphe, bụ alị, katsụkpo mma lẹ Íjiputu a-bụru nk'ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tọ dụ iya bụ; ụnwu Ízurẹlu abya emee ẹge ono, Fero kfuru ono. Jósẹfu abya anụ ẹphe ụgbo-ịnya ẹge ono, Fero kfuru ono; bya anụkwaphu ẹphe nri, ẹphe e-ri l'ije ẹphe ono. ");
INSERT INTO iqw_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yọ bya anụkota ẹphe uwe ọphungu iche l'iche. Bénjaminu b'ọ nụru ụkporo mkpọla-ọcha iri l'ise; ọwaa uwe, dụ iche iche ụzo ise. ");
INSERT INTO iqw_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iphe ọ nụru t'a nụ nna iya bụ: nkakfụ-ịgara iri, e dojishiru iphe katsụkpo mma lẹ Íjiputu edoji; mẹ nne nkakfụ-ịgara iri, e dojikotaru witu; buredi; mẹwaru iphe ọdo, nna iya a-nọdu eri l'ụzo teke ọo-nọdu abya. ");
INSERT INTO iqw_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E metsua; yọ bya edube ụnwanna iya ono; ẹphe alashia. Yọ sụ ẹphe t'ẹphe ba aswọkwa ụswo l'esu-ụzo. ");
INSERT INTO iqw_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tọ dụ iya bụ; ẹphe egbeshi lẹ Íjiputu; yọ bụru ẹphe ọla kẹ nna ẹphe; mbụ Jékọpu l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ẹphe erua je asụ nna ẹphe: “Lẹ Jósẹfu nọkwa ndzụ! L'ọ kwa iya bụ onye ishi ndu Íjiputu mgburumgburu.” Yo tee Jékọpu ụkfu; to kweta l'ọ bụ oswi-okfu bẹ ẹphe ekfu. ");
INSERT INTO iqw_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Obenu l'ẹphe bya akọkotaru iya iphe, Jósẹfu kfushiru; yọ phụlephu ụgbo-ịnya, Jósẹfu nụru t'e gude pata iya; woru ume zụa; meji alatashia ya l'ọru iya. ");
INSERT INTO iqw_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ízurẹlu asụ: “Ya kwetawaru lẹ nwa iya; mbụ Jósẹfu nọkwadua ndzụ. Ya e-je aphụ iya; tẹmanu ya anwụhude.” ");
INSERT INTO iqw_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ya ndono; Ízurẹlu abya egwokoo iphemiphe ọbule, o nweru tụgbua. Yo rua Besheba bya egwooru Nchileke kẹ nna iya, bụ Áyizaku ẹja. ");
INSERT INTO iqw_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nchileke abya eshi l'àphụ̀ kfuru yeru Ízurẹlu l'ẹnyashi ono; sụ iya: “Jékọpu! Jékọpu!” Yọ za iya. ");
INSERT INTO iqw_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nchileke asụ iya: “L'ọ kwa yẹbe Nchileke bụ Nchileke kẹ nna ngu. Ba atsụkwa egvu ọla Íjiputu; kẹle ya e-me ngu t'ị bụru mba, ha nshinu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ya e-duru ngu je Íjiputu ono; dulatakwa ngu phụ azụ. Ọ bụ Jósẹfu a-nọ swiru ngu teke ịi-nwụhu.” ");
INSERT INTO iqw_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ya ndono; Jékọpu egbeshi lẹ Besheba; yọ bụru iya atụgbu. Ụnwu Ízurẹlu eduta nna ẹphe ono, bụ iya bụ Jékọpu ye l'ụgbo-ịnya ono, Fero nụru t'e gude pata iya ono. Ẹphe edutakwaphu ụnwu ẹphe; mẹ unyomu ẹphe ye l'ụgbo-ịnya ono; yọ bụru iya ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ẹphe erutakota elu ẹphe; mẹ iphemiphe ọbule, ẹphe setaru l'alị Kénanu. Jékọpu yẹle ụnwu iya kpamukpamu ekpolihu; yọ bụru ẹphe ọla Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","O dutaru ụnwu iya: ndu kẹ unwoke; mẹ ụnwu nwanwa iya ndu k'unwoke; duta ndu k'ụnwanyi; mẹ ụnwu nwanwa iya ndu k'ụnwanyi; tụko iphe bụ iphe, shi l'eri iya; ruta; yọ bụru ẹphe ọla Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ọwaa ụnwu Ízurẹlu, bụ iya bụ Jékọpu; mẹ iphe bụ iphe, shi l'eri iya, tso iya la Íjiputu: Rúbẹnu, bụ ọkpara iya. ");
INSERT INTO iqw_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ụnwu Rúbẹnu bụ: Hanọku; Palu; Hézurọnu; mẹ Kami. ");
INSERT INTO iqw_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ụnwu kẹ Símiyọnu bụ: Jimuwẹlu; Jaminu; Ohadu; mẹ Jakinu; Zoharu; mẹ Shọlu, bụ nwatibe nwanyi kẹ Kénanu. ");
INSERT INTO iqw_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ụnwu kẹ Lívayi bụ: Geshọnu; Kohatu; mẹ Merari. ");
INSERT INTO iqw_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ụnwu kẹ Júda bụ: Ẹru; Onanu; Shela; Pẹ́rezu; mẹ Zera. Ẹru yẹle Onanu; bẹ nwụhuhawaru lẹ Kénanu. Ụnwu Pẹ́rezu bụ: Hézurọnu; ọwaa Hamulu. ");
INSERT INTO iqw_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ụnwu kẹ Ísaka bụ: Tola; Puwa; Jashubu; ọwaa Shimurọnu. ");
INSERT INTO iqw_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ụnwu kẹ Zébulọnu bụ: Sẹredu; Elọnu; mẹ Jahulẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ndu ono l'ẹphe ha bụkota ụnwu, Lii mụshiru Jékọpu lẹ Padanu-Áramu; a gụfukwa nwatibe iya kẹ nwanyi, bụ iya Dayina. Ụnwegirima iya ono l'ẹphe ha: unwoke l'ụnwanyi bụ iphe ẹphe kpakọru dụ bụ ụkporo madzụ l'ụmadzu iri l'ẹto. ");
INSERT INTO iqw_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ụnwu kẹ Gádu bụ: Zefọnu; Hagi; Shuni; Ezubọnu; Éri; Arodi; mẹ Areli. ");
INSERT INTO iqw_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ụnwu kẹ Ásha bụ: Imuna; Ishiva; Ishivi; ọwaa Beríya. Nwunne ẹphe kẹ nwanyi bụ Séra. Ụnwu kẹ Beraya abụru: Heba; mẹ Milikiyẹlu. ");
INSERT INTO iqw_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ndu ono bụkota ụnwu, Zilipa mụtaru Jékọpu. Zilipa bụ nwanyi ono, Lébanu duru yeru nwatibe iya kẹ nwanyi; mbụ Lii l'ụlo t'ọ bụru iya ohu ono. Iphe ẹphe kpakọru dụ bụ ụmadzu iri l'ishingu. ");
INSERT INTO iqw_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ụnwu kẹ Rechẹlu, bụ nyee Jékọpu bụ: Jósẹfu yẹle Bénjaminu. ");
INSERT INTO iqw_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Jósẹfu nọ lẹ Íjiputu mụta Manásẹ; mẹ Ífuremu. Nwanyi, mụru Jósẹfu ụnwegirima ono bụ Asenatu, bụ nwatibe Pọtifera. Pọtifera bụ onye agwajẹru ndu Ọnu iphe. ");
INSERT INTO iqw_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ụnwu kẹ Bénjaminu bụ: Béla; Beka; Ashibẹlu; Gera; Námanu; Ehi; Roshi; Mupimu; Hupimu; mẹ Arudu. ");
INSERT INTO iqw_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ndu ono l'ẹphe ha bụ ụnwu, Rechẹlu mụtaru Jékọpu. Iphe ẹphe kpakọru dụ bụ ụmadzu iri l'ẹno. ");
INSERT INTO iqw_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nwatibe kẹ Dánu bụ Hushimu. ");
INSERT INTO iqw_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ụnwu kẹ Náfutali bụ: Jazẹlu; Guni; Jeza; ọwaa Shilemu. ");
INSERT INTO iqw_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ndu ono bụ ụnwegirima, Biliha mụtaru Jékọpu. Biliha bụ nwanyi ono, Lébanu duru yeru nwatibe iya kẹ nwanyi; mbụ Rechẹlu l'ụlo t'ọ bụru iya ohu ono. Iphe ẹphe kpakọru dụ bụ ụmadzu ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iphe ẹphe kpakọru dụ mbụ ndu tsoru Jékọpu laa Íjiputu bụ ụkporo ụmadzu ẹto l'ụmadzu ishingu; mbụ ndu bẹ ụnwu iya; a gụfukwa unyomu ụnwu iya phẹ. ");
INSERT INTO iqw_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A -gụkobe iya ụmadzu labụ ono, a mụtaru Jósẹfu lẹ Íjiputu ono bẹ iphe ẹphe kpakọru dụ; mbụ ndibe Jékọpu, laru Íjiputu bụ ụkporo ụmadzu ẹto l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tọ dụ iya bụ; Jékọpu abya eyefu Júda t'o vuru ụzo je eduta Jósẹfu t'ọ bya ekoshi ẹphe ẹke e shi eje Góshẹnu. Ẹphe erulephu alị Gọ́shenu; ");
INSERT INTO iqw_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jósẹfu abya ewota ụgbo-ịnya iya mee ya ẹge ọo-dụ t'o gude iya je ẹphe ndzuta. Yo rua je atụ nna iya ono gbirimu; rụkua ya ẹka; wata ẹkwa; raa ẹkwa ono ogologo. ");
INSERT INTO iqw_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ízurẹlu asụ Jósẹfu: “Tẹ ya nwụhuwaru nta-a; keshinu ọphu ya gudewa ẹnya iya phụ l'ị nọkwadua ndzụ!” ");
INSERT INTO iqw_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tọ dụ iya bụ; Jósẹfu asụ ụnwunna iya; mẹ ndibe nna iya l'ẹphe ha: “Lẹ ya e-je ekfuru Fero l'ụnwunna iya; mẹ ndibe nna iya, shi l'alị Kénanu bẹ lakfutaakwaru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ya e-kfuru iya l'ẹphe bụkwa ndu eche atụru; mbụ l'ẹphe bụ ndu azụ elu; l'ẹphe chịkwa atụru ẹphe; mẹ eswi ẹphe; mẹ iphemiphe ọbule, ẹphe nweru enweru l'ọ ha.” ");
INSERT INTO iqw_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wo ẹphe: “Ọ -bụru lẹ Fero kuru unu; jị unu iphe bụ ẹka-ọru unu; ");
INSERT INTO iqw_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","unu sụkwa iya l'unubẹ ndu ozi iya shikwaru lẹ dẹedeedee bụtaru ndu azụ elu; ẹge nna unu oche phe shihawa bụru. Ono kwa ẹge ee-shi; e kwe t'unu buru lẹ Gọ́shenu; kẹle ndu eche atụru adụjekwa ndu Íjiputu ashị.” ");
INSERT INTO iqw_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jósẹfu abya ejekfu Fero je asụ iya: “Lẹ nna iya yẹle unwunne iya; atụru ẹphe; eswi ẹphe; mẹ l'iphemiphe ọbule, ẹphe nweru enweru bẹ shiakwa Kénanu byaruta Gọ́shenu.” ");
INSERT INTO iqw_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yọ bya afọta unwunne iya ono ụmadzu ise gude jekfu Fero. ");
INSERT INTO iqw_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Fero abya ajị ẹphe iphe bụ ẹka-ọru ẹphe. Ẹphe asụ iya: “L'ẹphebe ndu ozi iya bụkwa ndu eche atụru. L'ọ kwa ẹge ono bẹ nna ẹphe oche phẹ cheru iya.” ");
INSERT INTO iqw_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ẹphe asụkwa iya phụ: “L'ẹphe byaru t'ẹphe butota l'ẹke-a; kẹ l'ẹjo-ẹgu, eme l'alị Kénanu ta dụdu k'ekfukfu; k'ọphu bụ l'ẹ to nwedu ẹke atụru ndu ozi ngu a-kpajẹ nri. Ọo ya bẹ ẹphe ekfu; sụ byiko t'ị haaru t'ẹphebe ndu ozi ngu buru lẹ Gọ́shenu.” ");
INSERT INTO iqw_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Fero asụ Jósẹfu: “Lẹ nna ngu; mẹ unwunne ngu byakfutaakwaru ngu. ");
INSERT INTO iqw_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Alị Íjiputu bụ nggu b'ọ nọ l'ẹka. Hata ẹke kagee mma l'alị-a nụ nna ngu yẹle unwunne ngu t'ẹphe buru. Woru alị Gọ́shenu nụ ẹphe t'ẹphe buru. Ọ -bụru l'o nweru ndu ọphu, i maru l'ẹphe ha, ike-ozi dụ; nggu eye ẹphe t'ẹphe chejeru iya elu nk'iya.” ");
INSERT INTO iqw_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Tọ dụ iya bụ; Jósẹfu abya eduru nna iya; mbụ Jékọpu jekfu Fero. Jékọpu abya agọoru Fero ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fero ajị iya afa ole, ọ nọwaru. ");
INSERT INTO iqw_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jékọpu asụ iya “L'ọ kwadua ụkporo afa ishingu l'afa iri bẹ ya nọwaru; ọle ọ bụlephu iphe-ẹhuka l'ọ ha; k'ọphu bụ l'oo-se tẹ ya ba anọ-ruhe ẹge nna iya oche phe nọ-ruru.” ");
INSERT INTO iqw_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jékọpu abya agọoru Fero ọnu ọdo; lụfushia. ");
INSERT INTO iqw_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","To dụ iya bụ; Jósẹfu abya emee tẹ nna iya; mẹ ụnwunna iya phẹ buru lẹ Íjiputu. Yọ nụ ẹphe alị Íjiputu, ẹke kagee mma t'ẹphe buru, bụ iya bụ alị Ramesẹsu, bụ ẹge Fero sụru t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jósẹfu l'anụ ndu ono nri l'ẹphe ha; bụ iya bụ nna iya; mẹ ụnwunna iya; mẹ iphe bụ ndibe nna iya l'ẹphe ha. Ọonoduje anụ ẹphe nri l'ẹge ụnwegirima ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nri agvụkota l'alị ono gbaa mgburumgburu; kẹ l'ẹgu ono kpọru ẹka. Alị Íjiputu mẹ alị Kénanu ajịko gbajọshihu; l'okfu ẹjo-ẹgu ono. ");
INSERT INTO iqw_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ndu Íjiputu; ẹphe lẹ ndu Kénanu atụko okpoga, ẹphe nweru kpafọkota lẹ nri l'ẹka Jósẹfu. Jósẹfu evuta okpoga ono je akụbe l'ụlo Fero. ");
INSERT INTO iqw_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Okpoga onyemonye ọbule agvụlephu; ndu Íjiputu abyakfutashia Jósẹfu bya asụ iya: “T'ọ nụ ẹphe nri! Ọ -dụdu bẹ ẹphe a-nwụshihukwa; kẹ l'okpoga ẹphe gvụakwaru lẹ nri.” ");
INSERT INTO iqw_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jósẹfu asụ ẹphe: “Ọ -bụru l'okpoga ẹphe gvụwaru; t'ẹphe kpụtajeru iya elu ẹphe l'ụgwo nri, ya a-nụ ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tsube teke ono; ẹphe akpụtalahaaru iya elu ẹphe; mbụ ịnya ẹphe; atụru; eghu; eswi; mẹ nkakfụ-ịgara ẹphe. Yọo natajẹ ẹphe elu ẹphe; nụ ẹphe nri ọzori iya. Yọ bụru ẹge ono b'o gude zụa ẹphe afa ophu. ");
INSERT INTO iqw_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Afa ono agvụlephu; ẹphe abyakfuta iya l'afa ọphu tso iya nụ bya asụ iya: “L'ẹ to nwekwa iphe ẹphe edomiru nggụbe onye nwe-ẹphe edomi. Lẹ keshinu ọphu okpoga ẹphe gvụru; elu ẹphe abụkotawaru nke ngu; b'ẹ tọ dụhekwa iphe ẹphe tọkfu ẹka, ee-gudeje akfụ nggụbe nnajiufu ụgwo; a gụfu ẹphebedua l'onwẹphe; mẹ alị ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Wo iya: “?Ọ dụ l'oo-kwe t'ẹphe bụru kpurupyata; ẹphebedua; mẹ alị ẹphe? L'iphe, ẹphe ekfu bụ t'o wota ẹphebedua; mẹ alị ẹphe gude kfụa ụgwo nri ono; t'alị ẹphe bụwaruru kẹ Fero; ẹphebedua abụru iya ohu. Yọ nụ ẹphe iphe t'ẹphe mebe l'alị tẹ ndzụ dzuaru ẹphe; k'ọphu alị-a ta adabuduru ochobo.” ");
INSERT INTO iqw_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tọ dụ iya bụ; ndu Íjiputu l'ẹphe ha erekota alị ẹphe; kẹ l'ẹgu ono ta bụdu iphe e gude ọnu ekfu ekfukfu. Jósẹfu azụkota iphe, bụ alị, nọ lẹ Íjiputu l'ọ ha; yọ bụru kẹ Fero. ");
INSERT INTO iqw_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jósẹfu emee ndu Íjiputu l'ẹphe ha; ẹphe abụru ohu. ");
INSERT INTO iqw_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Alị ndu ọphu ẹ tọ zụdu nwẹnkinyi bụ alị ndu achịjeru ndiphe ẹja; kẹ l'ọ bụ Fero anụje ẹphe nri. Nri ono, Fero anụje ẹphe ono edzujekwanuru ẹphe. Yọ bụru iya meru iphe ẹphe te eredu alị nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jósẹfu asụ ẹphe: “Lẹ keshinu ọphu ya zụwaru unu; zụa alị unu nụ Fero; ọwaa iphe, unu e-gude mebe l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Teke unu kpatajẹru iphe ono; unu ekee ya ụzo ise; nụ Fero ụzo lanụ. Ụzo ẹno ọphu bẹ unu e-shi l'eri nri; shi iya l'anụ ndibe unu; mẹ ụnwegirima unu nri; shikwa iya phụ wofu ọphu unu e-dobe akụ.” ");
INSERT INTO iqw_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ẹphe asụ iya: “L'ọ dzọwaru ẹphe ndzụ! Byiko; t'ọ dụnu nggụbe onye nwe-ẹphe mma t'ẹphe bụru ohu Fero.” ");
INSERT INTO iqw_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jósẹfu abya atụa ya; yọ bụru ekemu l'alị Íjiputu. Ekemu ono bẹ vukwa ìrè jeye ntanụ-a; mbụ ekemu ono, a tụru sụ l'ụzi lanụ l'ụzo ise l'iphe a kpataru l'okfu a-bụjeru kẹ Fero. Ọ bụphu alị ndu achịjeru ọha ẹja nwẹnkinyi bẹ ta bụdu alị kẹ Fero. ");
INSERT INTO iqw_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ya ndono; ndu Ízurẹlu abya eburu Gọ́shenu lẹ Íjiputu. Ẹphe eburu l'ẹke ono nweru ẹku; nọdu iya zụshia; bya aka l'igwe. ");
INSERT INTO iqw_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jékọpu ebua lẹ Íjiputu afa iri l'ẹsaa; teke ọ gbaru ụkporo afa ẹsaa l'afa ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yọ gbadẹlephu Ízurẹlu l'anwụhu; yo kua nwatibe iya; mbụ Jósẹfu; sụ iya: “Ọ -bụru lẹ ya nọ ngu-a l'obu l'oswiya; gude nụ iya ẹka l'ụtakfu; riaru iya angụ l'ẹ tii lidu iya l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","L'ịi-patachia ya je elia l'ẹke e liru nna iya oche phe.” Jósẹfu asụ iya l'ọ bụlephu ẹge ono, o kfuru iya ono bụ ẹge ya e-me iya. ");
INSERT INTO iqw_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yọ sụ iya t'o riaru iya angụ l'oo-me iya-a. Jósẹfu abya eriaru ya ẹya. Ízurẹlu abya efoo ifu l'oshi-azẹe ya; baaru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yo be ujiku lanụ; a bya ezia Jósẹfu lẹ nna iya bẹ ẹhu ta dụdu mma. Yo duta ụnwegirima iya ẹphe ẹbo, bụ iya bụ Manásẹ; mẹ Ífuremu; yọ bụru ẹphe ejeje. ");
INSERT INTO iqw_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ẹphe erua; e je ezia Jékọpu lẹ nwatibe iya; mbụ Jósẹfu bẹ byakwaru iya ajịji. Yo keshia ẹhu gbeshi bya anọdu l'oshi-azẹe ya. ");
INSERT INTO iqw_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jékọpu asụ Jósẹfu: “Lẹ Nchileke, bụ Ọkaribe-Kakọta-Ike byakfutaru yẹbe Jékọpu lẹ Luzu l'alị Kénanu; bya agọoru iya ọnu l'ẹke ono; ");
INSERT INTO iqw_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","sụ iya: ‘Lẹ ya e-me iya tẹ ya zụa azụzu; ya ha l'igwe. Lẹ ya e-me iya tẹ ya bụru mba k'ẹka iya; nụ iya alị-a t'ọ bụru òkè-iphe ndu eri iya jeye lẹ tutu yoyo.’ ");
INSERT INTO iqw_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Ụnwegirima labụ ono, ọ mụtaru lẹ Íjiputu tẹmanu ya abyadẹ ono; bụ iya bụ Ífuremu mẹ Manásẹ bẹ ya gụwaru yeru ụnwu kẹ yẹbe Jékọpu. Ífuremu yẹle Manásẹ bụwa ụnwu iya ẹge ono, Rúbẹnu; mẹ Símiyọnu bụ iya ono. ");
INSERT INTO iqw_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ọ bụ ndu ọphu aa-mụtaru ngu nta-a tsobe ndu ọwaa a-bụru ụnwu ngu. Òkè-alị, ẹphe a-hata bẹ e-shi l'ẹka unwunne ẹphe ono, bụ iya bụ Ífuremu; mẹ Manásẹ. ");
INSERT INTO iqw_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ọ bụ lẹ ya shi Padanu alata; bẹ ụmuruku mụru iya; kẹle Rechẹlu nahụru iya nwụhu lẹ Kénanu l'ẹphe nọkwaduru l'ụzo lẹ mgboro Efuratu. Ya eworu iya lia l'iku ụzo ono, eeshi eje Efuratu ono, bụ iya bụ Bẹ́tulehemu.” ");
INSERT INTO iqw_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ízurẹlu aphụlephu ụnwu Jósẹfu ono; jị iya: “?Bụ ndu ole ndọ-ọ?” ");
INSERT INTO iqw_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jósẹfu asụ iya: “L'ọ kwa ụnwegirima, Nchileke nụru iya l'ẹke-a.” Ízurẹlu asụ iya t'o dutaru iya ẹphe tẹ ya gọoru ẹphe ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Teke ono bẹ nka lawaru Ízurẹlu l'ẹnya; t'ọ phụfuhe ụzo ọhuma. Jósẹfu abya eduta ụnwegirima ono donyabe iya ntse; nna iya ono abya etsuta ẹphe ọnu; nmaa ẹphe akpa. ");
INSERT INTO iqw_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ízurẹlu asụ Jósẹfu: “Lẹ ya te shikwa arịkwadu lẹ ya a-phụkwadu ngu ifu ọdo; Nchileke abya emewa nụ nta-a; ya egbe phụfua ụnwu ngu yekobe iya.” ");
INSERT INTO iqw_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jósẹfu abya edufuta ụnwegirima ono l'ụtakfu Ízurẹlu; bya efurita; wota ifu kpube l'alị; ");
INSERT INTO iqw_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","bya esekputa ẹphe ẹbo; gude ẹphe ẹge ono machịaru Ízurẹlu. Ífuremu b'o sekpu l'ẹka-ụtara; nụ iya Ízurẹlu l'ẹka-ibyita. Manásẹ b'o sekpu l'ẹka-ibyita; nụ iya Ízurẹlu l'ẹka-ụtara. ");
INSERT INTO iqw_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Obenu lẹ teke Ízurẹlu wataru ẹphe ọgoru ọnu; b'ọ kụ-swiberu ẹka iya akụ-sibe; woru ẹka-ụtara iya byibe Ífuremu, bụ onye kẹ nwata l'ishi; woru ẹka-ibyita iya byibe Manásẹ, bụ ọkpara. ");
INSERT INTO iqw_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yọ bya agọoru Jósẹfu ọnu; sụ: “Tẹ Nchileke ono, nna iya oche phẹ, bụ iya bụ Ébirihamu; mẹ Áyizaku tsoru ụzo iya ono; mbụ Nchileke ono, shi keshinu ya bụ nwata chee ya jeye ntanụ-a ono; ");
INSERT INTO iqw_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","mẹ Ojozi-imigwe ono, dzọkotaru iya nụ l'iphe, bụ iphe-ẹhuka ono, byaru iya nụ ono; gọkwaru ọnu-ọma nụ ụnwegirima-a. T'e kujekwa ẹpha ụnwegirima-a laa l'ẹpha kẹ yẹbe Jékọpu yẹle kẹ nna iya oche phẹ, bụ Ébirihamu; mẹ Áyizaku; ẹphe azụa ịnyinwuruku lẹ mgboko-a.” ");
INSERT INTO iqw_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jósẹfu aphụlephu lẹ nna iya byiberu Ífuremu ẹka-ụtara l'ishi; ẹhu adaa ya kọo. Yo je azụ nna iya l'ẹka; tẹ ya lọfuta iya ẹka ono, o byiberu Ífuremu l'ishi ono byibe iya l'ishi kẹ Manásẹ. ");
INSERT INTO iqw_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Jósẹfu asụ iya: “Wawakwa nna; ọ kwa onye ọphu bụ ọkpara ndọ-ọ. Ọ kwa yẹbedua bẹ ii-byibe ẹka-ụtara l'ishi!” ");
INSERT INTO iqw_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Obenu lẹ nna iya jịkaru; sụ iya: “Nwa mu; ya marua. Ya marua. Ọo-zụ-a azụzu; bụru mba k'ẹka iya; bya aha nshinu. Obenu lẹ nwunne iya kẹ nwata a-ka iya; ẹge ono kwaphu bẹ eri iya abụru igweligwe mba.” ");
INSERT INTO iqw_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yọ bya agọoru ẹphe ọnu mbọku ono; sụ: “Ndu Ízurẹlu l'e-gudeje ẹpha ngu agọ ọnu; sụ: ‘Tẹ Nchileke mekwaa ngu t'i dụ l'ọ bụ Ífuremu yẹle Manásẹ.’ ” Ya ndono; yo mee; Ífuremu aka Manásẹ. ");
INSERT INTO iqw_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ízurẹlu abya asụ Jósẹfu: “Lẹ ya abyaakwa anwụhu; ọbule Nchileke e-swikwaru-a unu; dulaa unu azụ l'alị nna unu. ");
INSERT INTO iqw_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ya nụwaru ngu ókè-alị lanụ t'i gude ka unwunne ngu phẹ. Alị ono bẹ ya gude ogu-mbeke; mẹ akfụ lụta l'ẹka ndu Amọru.” ");
INSERT INTO iqw_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ya ndono; Jékọpu abya ekua ụnwu iya; sụ ẹphe: “Unu dzukobe tẹ ya kọoru unu iphe, a-mụru unu l'ụzo l'ifu! ");
INSERT INTO iqw_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Unu dzukoo; ngabẹru iya nchị; unubẹ ụnwu yẹbe Jékọpu! Unu ngabẹru iya nchị; yẹbe nna unu Ízurẹlu! ");
INSERT INTO iqw_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rúbẹnu; ọ bụ nggu bụ ọkpara iya; bya agbụru-ike iya; Ọ bụ nggu vu ụzo kpọ iya ifu; koshi lẹ ya bụ nwoke. Ọ bụ nggu bẹ aa-kakọta ọkwabe ugvu; bụru nggu a-kakọta ike. ");
INSERT INTO iqw_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Keshinu ọphu ịitu akpara l'ọ bụ utso; b'ẹ tịi kahẹdu ndu ọphu. Ishi iya abụru lẹ nggu lẹ nyee nna ngu zẹru; nggu eshi ẹge ono farụa oshi-azẹe nna ngu. ");
INSERT INTO iqw_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Símiyọnu; mẹ Lívayi bụ unwunne. Ẹphe e-gudeje ogu-mbeke l'eme iphe-kpaa. ");
INSERT INTO iqw_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ya te etsokwa l'ẹjo idzu, ẹphe achị; to nwe lẹ ya anọo l'ẹke ẹphe nọ; kẹ l'ẹphe gude ẹhu-iwe gbushia ndiphe; bushia oke-eswi akwara-achị kẹ manụ. ");
INSERT INTO iqw_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","T'ẹhu-eghughu ẹphe ono vukwaru mburọnu; kẹ l'ẹphe nwenukaru ọkpoma-ọku. T'ọkpoma-ọku ẹphe ono vukwaru mburọnu; kẹ l'ẹphe nwụnukaru ọnwuu. Ya a-chịkashi ẹphe t'ẹphe dzuru alị Jékọpu; dokashia ẹphe; t'ẹphe dzuru alị Ízurẹlu kpamu. ");
INSERT INTO iqw_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Júda; ụnwunna ngu phẹ a-nọdu aja ngu ajaja. Ndu ọhogu ngu; bẹ ịi-pyịtaje l'ẹkpiri. Ụnwunna ngu l'ẹphe ha a-nọdu ebyiru ngu ikpere l'alị. ");
INSERT INTO iqw_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Júda; ị bụ nwa agụ. Nwa mu; i shiwa l'ẹke i gbushiru anụ lata. Nta-a b'i byishiwaru ikpere l'ọ bụ agụ. Ị zẹwa l'ọbu nne agụ; ?bụ onye ha kẹ t'ọ kpatee ngu? ");
INSERT INTO iqw_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Júda ta abụ-buhudu eze abụ-buhu. Mgbọro-eze ono te nwedu l'ọ lụfu ngu l'ẹka; gbururu jeye teke onye ọ kụru ishi l'ẹka a-bya. Ọ -byalẹphu bẹ iphe bụ mbakeshi a-nọdu anụru iya okfu. ");
INSERT INTO iqw_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Oo-libeje nkakfụ-ịgara iya l'oshi vayịnu; Nwa nkakfụ-ịgara iya ono; bẹ oo-libeje l'oshi vayịnu, katsụkpo amịmi. Oo-gudeje mẹe saa uwe iya; gude mini akpụru vayịnu ono, ekeje kfụu ono l'asa uwe-eze iya. ");
INSERT INTO iqw_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ọo-ngụtaje mẹe; ẹnya achaa ya vịi; yọ ngụa ẹra eswi; eze acha iya pemu-pemu. ");
INSERT INTO iqw_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zébulọnu e-buru l'iku eze ẹnyimu. Ọnu-ẹnyimu iya a-bụru ọdu ụgbo-mini; Ókè-alị iya eje akpaa lẹ Sayịdonu. ");
INSERT INTO iqw_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ísaka bụ nkakfụ-ịgara, shihuru ike. Ọoze azẹe lẹ mgbaku ẹkpa-ivu labụ. ");
INSERT INTO iqw_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Teke ọ phụru ẹge ẹke ọonoduje atụta ume dụta-be mma; mẹ ẹge alị iya dụ-be ugvu; bẹ ọo-pata ivu-ẹra iya tukobe onwiya l'ukuvu; ghọo ohu; jelahaa ozi mkpọ-nyi-ẹnya. ");
INSERT INTO iqw_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dánu a-nọduje ekpe ndu nk'iya ikpe, dụ mma; l'ọ bụ ndu ikfu ndu Ízurẹlu ndu ọphu. ");
INSERT INTO iqw_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dánu a-dụ l'ọ bụ agwọ, nọ l'iku ụzo; mbụ l'ọ bụ ogiji, nọ l'iku ụzo, abụje: ọ -taa ịnya ẹra l'ichirukfu; ịnya ọbu atụfu onye agba iya nụ. ");
INSERT INTO iqw_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Nggụbe Ojejoje; ya ele ẹnya tii dzọo yẹbe Jékọpu. ");
INSERT INTO iqw_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gádu bẹ ndu ọ-lụa-ọlaa a-fụru; Obenu l'ịi-chị ẹphe agada-eru-alị. ");
INSERT INTO iqw_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ásha a-nọdu akọfuta nri, dụ mma. Nri, ọo-nọdu akọ bụ nri, atsọ ẹna; bụru nri, gbaru ndu eze. ");
INSERT INTO iqw_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Náfutali bụ ele, akfụ ẹge ọ dụ iya. Ọonoduje amụshi ụnwu, ama mma. ");
INSERT INTO iqw_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jósẹfu bụ oshi vayịnu, mịru akpụru wọkfuru awọkfuru. Ọ bụ vayịnu, gvuru l'iku mini l'amị akpụru ntụmatu; Ẹkali iya abakahụ; tụko ụpho-mkpuma sweta. ");
INSERT INTO iqw_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ndu akfụ gude ẹhu-eghughu tso iya ọgu. Ẹphe egude akfụ ono gbanwụa ya ẹhu; ");
INSERT INTO iqw_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Obenu l'akfụ iya shihulerua ike ẹge o shihuru iya; ọkpu ẹka iya eshihu ike. Yọ bụru ike kẹ Ọkaribe kẹ Jékọpu; bẹ kparu iya nụ; mbụ onye ono, bụ iya bụ onye nche atụru; bụru iya bụ oke mkpuma kẹ Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Onye ike ono shi l'ẹka bụ Nchileke kẹ nna nggụbe Jósẹfu, bụ onye eyejeru ngu ẹka; Mbụ onye ono, bụ Ọkaribe-Kakọta-Ike, bụ iya agọjeru ngu ọnu-ọma. Ooshije lẹ mini achịchi gọoru ngu ọnu; shi lẹ mini ime-alị; gọoru ngu ọnu; shi l'elu; mẹ nwa gọoru ngu ọnu. ");
INSERT INTO iqw_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ọnu ọphu nna ngu gọru ngu kakwa k'eze ugvu ndiche; ka ụkwa k'ugvu, shi l'oge ndiche. T'iphe-ọma ono l'ọ ha bụkwaru kẹ Jósẹfu; mbụ kẹ onye ono, a fọfuru; dobe iche l'ẹke unwunne iya phẹ nọ ono. ");
INSERT INTO iqw_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bénjaminu bụ ẹjo nkụta-ọswa, ẹgu egvu akụrepho kfurukfuru. O -bee l'ụtsu; yọ taa anụ, o gburu. O -bee l'urẹnyashi; yo kee iphe, ọ lụtaru l'ọgu.” ");
INSERT INTO iqw_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ndu ono bụkota ndu ikfu Ízurẹlu; ẹphe iri l'ẹbo. Iphe ono bụkota iphe nna ẹphe kfuru nụ ẹphe teke ọogoru ẹphe ọnu. Iphe, bụ onyenọnu b'ọ gọru ọnu, gbaru iya nụ nụ. ");
INSERT INTO iqw_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ya ndono; yọ bya ekeeru ẹphe ekpe; sụ ẹphe: “Lẹ ya abyaakwa ọla-kfu ndiche iya phẹ. Unu likwa-a ya l'ẹke e liru nna iya l'ọgba, nọ l'alị Éfurọnu, bụ onye Hetu; ");
INSERT INTO iqw_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","mbụ ọgba ono, nọ l'alị Makupela l'iku Mamure lẹ Kénanu, bụ ẹke Ébirihamu zụru Éfurọnu onye Hetu yẹle alị, tso iya nụ t'ọ bụru ẹke ee-lije odzu. ");
INSERT INTO iqw_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ọ bụ l'ẹke ono b'e liru Ébirihamu yẹle nyee ya; mbụ Séra; bụru l'ẹke ono b'e liru Áyizaku yẹle nyee ya; mbụ Ribéka; bụkwaruphu l'ẹke ono bẹ ya liru Lii. ");
INSERT INTO iqw_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Alị ono yẹle ọgba ono, nọ iya nụ ono b'a zụru ndu Hetu.” ");
INSERT INTO iqw_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jékọpu eketsuaru ụnwu iya ekpe ono; chịru ọkpa dobe l'oshi azẹe ya; tụ-bua ume; lakfushia ndiche iya phẹ. ");
INSERT INTO iqw_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jósẹfu abya atụ nna iya gbirimu; bya etsuta iya ọnu; wata ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ya ndono; Jósẹfu abya ezia ndu dọkinta, ejeru iya ozi t'ẹphe kwakọbe odzu nna iya t'ẹ b'o rehu. Ẹphe ekwe bya akwakọbe odzu ono. ");
INSERT INTO iqw_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Iphe ọ nataru ẹphe bụ ụkporo abalị ẹbo t'ẹphe gude kwakọbe odzu ono; kẹ l'ọ kwanụ ẹge ono bẹ ọonataje; t'e gude kwakọbe odzu. Ndu Íjiputu akwaa ẹkwa iya ụkporo abalị ẹto l'abalị iri. ");
INSERT INTO iqw_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","A ratsụlephu ẹkwa iya ono; Jósẹfu asụ ndu ozi Fero: “Ọ -bụru lẹ ya nọ unu l'obu; unu kfuru Fero ");
INSERT INTO iqw_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","lẹ teke nna iya abya anwụhu b'ọ sụkwaru tẹ ya riaru iya angụ lẹ ya e-jee je eli-a ya l'ili, ọ tụru doberu onwiya l'alị Kénanu. Ọo ya bụ t'a haa ya tẹ ya je elia ya. Teke ya litsuaru iya; ya alata.” ");
INSERT INTO iqw_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fero asụ iya: “T'o jekwa je elia nna iya l'ẹke, ọ sụru t'o riaru iya angụ l'oo-je je elia ya.” ");
INSERT INTO iqw_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tọ dụ iya bụ; Jósẹfu atụgbua jeshia oli nna iya. Iphe, bụ ndu, bụ ishi l'ọru Fero awụ-tsoru iya. Ndu, bụ ọgurenya l'ufu eze; ndu, bụ ọgurenya l'alị Íjiputu; ");
INSERT INTO iqw_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ndibe Jósẹfu kpamukpamu; unwunne iya; mẹ iphe bụ ndu nna iya l'ẹphe ha awụ-lihu tsoru Jósẹfu; ẹphe ejeshia oli nna iya ono. Ọ bụphu ụnwegirima ẹphe; mẹ elu ẹphe bẹ ẹphe haru lẹ Gọ́shenu. ");
INSERT INTO iqw_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ụgbo-ịnya; mẹ ndu l'agba ịnya; bẹ ẹphe l'iya yịkwaphu. Ọ bụlephu l'ẹphe zaru l'igwe je. ");
INSERT INTO iqw_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ẹphe erua ẹke, eetsuje balị lẹ Atadu l'iku Ẹnyimu Jọ́danu; nọdu l'ẹke ono raa ẹkwa Jékọpu rashịa ya ike. Jósẹfu anọo l'ẹke ono abalị ẹsaa; nọoru nna iya l'ụlo-ẹ̀kwà. ");
INSERT INTO iqw_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ndu Kénanu, bu l'ẹke ono anụa ẹkwa-aphụ, aara l'ẹke ono, eetsuje balị lẹ Atadu ono; sụ: “Ọ kwa ẹkwa-anwụhu bẹ ndu Íjiputu akwa ẹge ono.” Ọo ya kparu iphe eekuje ẹke ono, nọ l'iku Jọ́danu ono “Ébẹlu-Mizaremu.” ");
INSERT INTO iqw_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tọ dụ iya bụ; ụnwu Jékọpu emee ẹge ono, ọ sụru t'ẹphe mee ono; ");
INSERT INTO iqw_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","pata odzu iya jeshia Kénanu je elia ya l'ọgba, nọ l'ẹgu Makupela l'iku Mamure, bụ ẹke Ébirihamu zụtaru Éfurọnu onye Hetu yẹle alị, tso iya nụ; t'ọ bụru ẹke, ee-lije odzu. ");
INSERT INTO iqw_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Jósẹfu elitsua nna iya ono yẹle ụnwanna iya; mẹ iphe bụ ndu ono, tso iya je oli odzu ono alashia azụ lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ụnwanna Jósẹfu abya aphụa lẹ nna phẹ nwụhuwaru; bya asụ: “L'o nwekwaru ẹge ọo-dụ; Jósẹfu evukwaduru ẹjo iphe ono, ẹphe meru iya ono l'obu; bya kfụa ẹphe ụgwo iya.” ");
INSERT INTO iqw_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tọ dụ iya bụ; ẹphe abya ezia ozi t'e je ezia Jósẹfu; sụ iya: “L'o nwekwaru ọkwa, nna ngu nmaru b'ọ nwụhuderu. ");
INSERT INTO iqw_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ọ sụru t'ayi kfuru ngu: “Lẹ yẹbedua, bụ Jékọpu arọ ngu t'ị gụaru ụnwanna ngu-a nvụ l'iphe, dụ ẹji ono, ẹphe meru ngu ono; mẹ l'iphe bụ ẹke, ẹphe meru ngu ẹji.” ’ “Nta-a bẹ ẹphe arọ ngu t'ị gụaru ẹphe nvụ l'iphe, dụ ẹji ono, ẹphe meru ngu ono; l'ẹphe bụkwa-a ndu ozi kẹ Nchileke kẹ nna ngu.” Ozi ono erua Jósẹfu nchị; yọ wata ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ụnwanna iya ono awụ-kfuta iya; bya ebyishiru iya ikpere; sụ iya: “L'ẹphe l'ẹphe ha bụkotaakwa ohu ngu.” ");
INSERT INTO iqw_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jósẹfu asụ ẹphe: “Unu ba atsụshi egvu; kẹ l'ẹ tọ bụdu iya bụ Nchileke. ");
INSERT INTO iqw_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ọ bụ oswi-okfu l'unu rịru t'unu mee yẹbe Jósẹfu ẹjo iphe; ọbu lẹ Nchileke meru t'ọ bụru iphe-ọma; k'ọphu ee-shi ẹge ono dzọta ndu, dụ l'igwe, bụnu iya bụ iphe-a, eme nta-a. ");
INSERT INTO iqw_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ọo ya bụ t'unu ba atsụshi egvu. Ya a-nọdu anụ-a unu nri; unu l'ụnwu unu.” Yo gude olu-odoo kfuru yeru ẹphe; mee t'obu rua ẹphe alị. ");
INSERT INTO iqw_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jósẹfu eburu lẹ Íjiputu yẹle ndibe nna iya. Iphe ọ nọru bụ ụkporo afa ise l'afa iri. ");
INSERT INTO iqw_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ọ nọ ndzụ; phụ ụnwunwa Ífuremu; nọdukwaphu ndzụ; a mụshia ụnwegirima kẹ Makiru, bụ nwatibe Manásẹ; yo hetatsua ẹphe. ");
INSERT INTO iqw_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ya ndono; Jósẹfu asụ ụnwanna iya: “Lẹ ya abyaakwa anwụhu. Ọle ya marua lẹ Nchileke e-yerua unu ẹka dufuta unu l'alị-a; dulala unu azụ l'alị ono, o kweru Ébirihamu; mẹ Áyizaku; mẹ Jékọpu ụkwa iya; tsua ya ẹtomu ono.” ");
INSERT INTO iqw_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jósẹfu emee; ụnwu Ízurẹlu eriaru iya nte lẹ Nchileke e-yeru-a ẹphe ẹka; t'ẹphe vuta odzu iya vulaa teke ẹphe a-nọdu ala. ");
INSERT INTO iqw_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tọ dụ iya bụ; Jósẹfu anwụhu l'ọ nọtsuaru ụkporo afa ise l'afa iri. Ẹphe abya akwakọbe iya; tee ya manụ banụ; kụa ya l'igbe-odzu dobe lẹ Íjiputu.");
INSERT INTO iqw_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ọwaa bụ ẹpha ụnwu Ízurẹlu; ndu tso Jékọpu laa Íjiputu. Onyenọnu bẹ chị ndibe nk'iya lashia ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rúbẹnu; Símiyọnu; Lívayi; Júda; ");
INSERT INTO iqw_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ísaka; Zébulọnu; Bénjaminu; ");
INSERT INTO iqw_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dánu; Náfutali; Gádu; mẹ Ásha. ");
INSERT INTO iqw_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ndu bụ o-shi-l'eri Jékọpu dụ ụkporo madzụ ẹto l'ụmadzu iri l'ẹphe ha. Jósẹfu nọhawa lẹ Íjiputu anọno. ");
INSERT INTO iqw_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tọ dụ iya bụ; Jósẹfu l'unwunne iya; mẹ ndu ọgbo onanu l'ẹphe ha anwụshihukota. ");
INSERT INTO iqw_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Obenu lẹ ndu Ízurẹlu nọlee l'azụshi; bya abarahụ l'eje. Ẹphe abya azụa kwatakpọo ha nshinu; k'ọphu ẹphe bya achịko alị ono dzuru. ");
INSERT INTO iqw_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ya ndono; onye eze ọphungu, ẹ-ta madu kẹ Jósẹfu achịlahaa ndu Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yọ sụ ndu alị iya: “Unu lenu lẹ ndu Ízurẹlu-a kaakwa ayi l'igwe; l'abyawa ayi ọka ike. ");
INSERT INTO iqw_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Unu byakwa t'ayi gude àkọ̀ lepyabe ẹphe ẹnya; ọdumeka bẹ ẹphe a-kakwa l'igwe. Ọ -bụru l'a nọnyaaru; ọgu daa bẹ ẹphe e-tsokwaru ndu ọhogu ayi; tso ayi ọgu; shi ẹge ono haa alị-a wụfu.” ");
INSERT INTO iqw_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ya ndono; ndu Íjiputu abya afọo madzụ; mee ẹphe udumalị; sụ t'ẹphe dzujeru ndu Ízurẹlu ozi mkpọ-nyi-ẹnya. Ẹphe bya akpụaru Fero mkpụkpu Pyị́tomu; mẹ mkpụkpu Ramesẹsu t'ọ bụru ẹke aa-kwakọbejeru Fero ẹku iya. ");
INSERT INTO iqw_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Obenu l'o gbe abụje; a -ka ẹphe ọkpa ẹhu; ẹphe egbe ka azụzu; ka l'igwe; ji ẹkemeke ọbule. Ndu Íjiputu akabakpọoru ọtsu ndu Ízurẹlu egvu; ");
INSERT INTO iqw_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","bya akabakpọoru ẹphe odzuru ozi mkpọ-nyi-ẹnya. ");
INSERT INTO iqw_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ẹphe egude ozi mkpọ-nyi-ẹnya mee; ndzụ abụru ẹphe nggụmaphu. Ẹphe akpabẹ ẹphe ozi l'ọyo bụloku; mẹ l'ọdzo ẹja; mẹkwaphu ozi ẹgu. Ozi, ndu Íjiputu edzuru ẹphe abụkotaru ozi mkpọ-nyi-ẹnya. ");
INSERT INTO iqw_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Eze ndu Íjiputu asụ ụnwanyi, eswije ndu Ízurẹlu ime, ẹpha ẹphe bụ Shifura; mẹ Puwa: ");
INSERT INTO iqw_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Teke unu a-nọdu eswi ụnwanyi Ízurẹlu ime; unu lejee ẹnya; phụ iphe ẹphe mụru. Ọ -bụru nwoke; unu egbua ya. Teke ọ bụ nwanyi; unu ahaa ya t'ọ nọdu ndzụ!” ");
INSERT INTO iqw_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Obenu l'ụnwanyi ono, eswi ime ono atsụ Nchileke egvu; k'ọphu ẹphe ta adụjedu ike ome iphe ono, eze ndu Íjiputu ziru ẹphe ono. Ẹphe ahajẹ ụnwegirima unwoke; t'ẹphe nọdu ndzụ. ");
INSERT INTO iqw_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ya ndono; eze ndu Íjiputu abya ekukobe ụnwanyi ono, eswije ime ono; sụ ẹphe: “?Nanụ ẹge ọ dụ bẹ unu eme ẹge-a? ?Nanụ ẹge ọ dụ bẹ unu ahaje ụnwegirima unwoke; t'ẹphe nọdu ndzụ?” ");
INSERT INTO iqw_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ụnwanyi ono, eswije ime ono asụ Fero l'ụnwanyi Híburu ta dụkwa l'ọ bụ ụnwanyi Íjiputu. L'ẹphe shihukwaru ike; k'ọphu bụ lẹ tẹmanu tẹ ụnwanyi, eswi ime ruta; bẹ ẹphe gbe zedawa nụ. ");
INSERT INTO iqw_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nchileke emeeru ụnwanyi ono, eswi ime ono iphe-ọma; ndu kẹ Ízurẹlu abya azụa; kabaaru l'igwe. ");
INSERT INTO iqw_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Nchileke egude kẹ l'ụnwanyi ono, eswi ime ono atsụ iya egvu; mee ẹphe; ẹphe abya amụtatsua nwa nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ya ndono; Fero abya atụaru ndu nk'iya l'ẹphe ha ekemu; sụ: “Ọ -bụru lẹ ndu Híburu mụru nwa; ọ -bụru nwoke; t'e jeje je echee ya lẹ Ẹnyimu Náyịlu! Ọ -bụru nwanyi; t'a haa ya t'ọ nọdu ndzụ!” ");
INSERT INTO iqw_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ya ndono; nwoke, shi l'ọnu-ụlo Lívayi abya alụa nwanyi, shikwaphu l'ọnu-ụlo Lívayi. ");
INSERT INTO iqw_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nwanyi ono abya atsụta ime; mụa nwata nwoke. Yọ phụlephu lẹ nwata ono ama mma nshinu; hee ya l'edomi ọnwa ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","A nọnyaa; tọ duhẹ ike domikota iya. Yọ bya egbuta èjì; kpaaru iya nkata; bya echia ya ụra mbeke. Yo kuta nwata ono ye lẹ nkata ono; pata je edobe l'iku Ẹnyimu Náyịlu ẹke èjì zeru ezeze. ");
INSERT INTO iqw_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nwunne Mósisu kẹ nwanyi eje evudo ote-ẹnya t'ọ maru iphe, e-eme nwata ono. ");
INSERT INTO iqw_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ya ndono; nwatibe Fero kẹ nwanyi ejeshia ọghu ẹhu lẹ Ẹnyimu Náyịlu ono. Yẹle ụnwu-mgbọko, ejeru iya ozi ayịru eje l'iku ẹnyimu ono. Yọ phụa nkata ono l'ẹke ọ nọ l'ime ejì ono; zi nwamgbọko, bụ ohu iya t'o je wotaẹduru iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Yo kpuhaa ya; bya aphụa nwata ono. Nwata ono l'ara ẹkwa; imiko iya egude iya. Yọ sụ: “Ọ kwa nwatibe onye Híburu ndọ-ọ!” ");
INSERT INTO iqw_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nwunne nwata ono kẹ nwanyi asụ nwatibe Fero ono: “?Tẹ ya jewaru je ekuaru ngu nwanyi Híburu, e-heru ngu nwata ono tọo?” ");
INSERT INTO iqw_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Yọ sụ iya t'o je. Nwamgbọko ono atụgbua je ekua nne nwata ono. ");
INSERT INTO iqw_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nwatibe Fero ono asụ nne nwata ono t'o kuta nwata ono je ehefutaru iya; lẹ ya a-kfụ ya-a ụgwo. Ya ndono; nwanyi ono ekuta nwata ono je ehelahaa. ");
INSERT INTO iqw_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nwata ono evutalephu; yo duta iya dulaaru nwatibe Fero; yọ bụru nwa iya. Yọ gụa ya Mósisu; kẹ l'ọ sụru l'ọo nwata, ya gụtaru lẹ mini. ");
INSERT INTO iqw_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ya ndono; yo be ujiku lanụ lẹ Mósisu vufutawaru; yo jeshia ẹke ndu nk'iya nọ l'ẹke ono, ẹphe eje ozi mkpọ-nyi-ẹnya ono. Yọ phụa onye Íjiputu ẹke oochi onye Híburu iphe, bụ onye lanụ lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Yọ chịkaa ẹnya; chịkaa ẹnya; t'ọ dụ onye ọ phụru. Yo gbua onye Íjiputu ono; kpota ẹja kpochia ya. ");
INSERT INTO iqw_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Yo be echile iya; yọ tụgbua ọdo je aphụa ndu Híburu ụmadzu labụ ẹke ẹphe alụ ọgu. Yọ jị onye ọphu achọ okfu: “?Nanụ ẹge ọ dụ bẹ iichi onye Híburu ibe ngu iphe?” ");
INSERT INTO iqw_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Onye onanu asụ iya: “?Bụ onye meru ngu onye ishi; mẹ onye ikpe l'ẹke ẹphe nọ? ?T'i mewa t'i gbua ya ẹge i gburu onye Íjiputu phụ?” Ya ndono; Mósisu atsụlahaa egvu; rịa; sụ: “Iphe-a, ya meru-a b'e gbe madzuwaru nụ.” ");
INSERT INTO iqw_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Fero anụlephu iphe ono; melahaa tẹ ya gbua Mósisu. Obenu lẹ Mósisu gbalaru l'ufu Fero; gbaru lashia alị ndu Mídiya je eburu. Yo rua je adụgaru anọdu l'iku wẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yo nweru onye agwajẹru ndu Mídiya iphe, mụtaru ụnwu-mgbọko ẹsaa. Ụnwu-mgbọko ono abya lẹ wẹlu ono okuta mini ye l'iphe eeyejeru anụ mini tẹ atụru nna ẹphe ngụa. ");
INSERT INTO iqw_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Yo nweru ndu ọdo, eche atụru, byaru bya achịfu ẹphe. Ya ndono; Mósisu egbeshi je eyetaru ẹphe ẹka; kuta mini doberu atụru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ụnwu-mgbọko ono alatalẹphu; nna ẹphe; mbụ Ruwẹlu; ajị ẹphe: “?Nanụ ẹge ọ dụ bẹ unu latakeberu ẹgwegwa ẹge-a ntanụ?” ");
INSERT INTO iqw_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ẹphe asụ iya l'o nweru nwoke Íjiputu, nafụtaru ẹphe l'ẹka ndu eche atụru ndu ọphu; bya esetakwaphu mini doberu atụru ẹphe; t'ọ ngụa. ");
INSERT INTO iqw_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yọ jị ụnwada iya ono: “?Nanụ onye ọphu? ?Bụ ngụnu kparu iphe unu paru iya haa? Unu je ekua ya t'ọ bya eria nri.” ");
INSERT INTO iqw_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mósisu ekweta tẹ yẹle nwoke ono e-buru. Yo duta nwatibe iya ọphu eeku Zipora kee Mósisu; yọ lụru. ");
INSERT INTO iqw_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora abya amụtaru Mósisu nwata nwoke. Mósisu agụa ya Geshọmu; kẹle Mósisu sụru: “Ya bụ mbyamụmbya l'alị ndu ọhodo.” ");
INSERT INTO iqw_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A nọnyaa; eze ndu Íjiputu anwụhu. Ndu Ízurẹlu anọdu l'ude; l'echi mkpu; l'ara t'e yeru ẹphe ẹka l'iphe-ẹhuka, ẹphe eje k'abụbu ono, ẹphe bụ ohu ono. Ẹkwa ono, ẹphe ara ono abya erua Nchileke nchị. ");
INSERT INTO iqw_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nchileke anụa aphụ ono, ẹphe agụ ono; bya anyata ndzụ, ẹphe lẹ Ébirihamu; mẹ Áyizaku; mẹ Jékọpu gbaru. ");
INSERT INTO iqw_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nchileke abya aghaa ẹnya; lee ndu Ízurẹlu; rịlahaa ọriri ẹhu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ya ndono; Mósisu l'eche atụru Jeturo, bụ nna nyee ya, bụkwa iya phụ bụ onye agwajẹru ndu Mídiya iphe. Yo be ujiku lanụ; Mósisu achịta atụru ono jeshia ẹke, teru ẹnya l'echi-ẹgu. Yọ bya ejerua l'ugvu Họ́rebu, bụ iya bụ ugvu Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yọ nọdu l'ẹke ono; ojozi Ojejoje egude ire-ọku, enwu l'iru nwoshi hee ya l'ifu. Mósisu aphụa l'ọku ono enwu l'iru nwoshi ono; obenu l'ẹ to kedu iya ekeke. ");
INSERT INTO iqw_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mósisu asụ tẹ ya jeedu je aphụ iphe ọwaa, dụ biribiri, eme nụ-a; tẹ ya maẹduru iphe, meru iphe, ọku ono te ekedu nwoshi ono ekeke. ");
INSERT INTO iqw_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ojejoje aphụlephu l'ọ kpịritawaru ntse tẹ ya phụ iphe ono; Nchileke eshi l'iru ono kua ya: “Mósisu! Mósisu!” Mósisu aza iya; sụ iya: “L'ọ kwa iya ndọ-ọ.” ");
INSERT INTO iqw_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nchileke asụ iya: “Ba akpịritahekwa ntse ọdo! Yefu akpọkpa ngu; kẹ l'ẹke ono, iivudo ono bụ alị, dụ nsọ.” ");
INSERT INTO iqw_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Yọ sụkwaphu Mósisu: “Ọo yẹbedua bụ Nchileke kẹ nna ngu; bụru Nchileke kẹ Ébirihamu; bụru Nchileke kẹ Áyizaku; bụkwaruphu Nchileke kẹ Jékọpu.” Mósisu a-nụ l'iya phụ; wohaa ifu; kẹ l'ọotsu egvu ole Nchileke ẹnya. ");
INSERT INTO iqw_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ojejoje asụ iya: “Lẹ ya phụwaru iphe-ẹhuka, ndu nk'iya eje lẹ Íjiputu. Ya nụwaru mkpu, ẹphe echi; sụ t'a dzọfuta ẹphe l'ẹka ndu udumalị. Iphe-ẹhuka, ẹphe eje bẹ ruwaru iya l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ọo ya bụ; lẹ ya byawaru tẹ ya nafụta ẹphe l'ẹka ndu Íjiputu; duru ẹphe lashia l'alị, dụ mma; ha nshinu; bya abụru alị-ọtsu ndu Kénanu; mẹ kẹ ndu Hetu; kẹ ndu Amọru; kẹ ndu Pẹ́rezu; kẹ ndu Hevu; mẹ kẹ ndu Jebusu. ");
INSERT INTO iqw_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nta-a bẹ mkpu, ndu Ízurẹlu echi ruwaru iya nchị. Ya aphụwa ẹge ndu Íjiputu gude akpa ẹphe ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nta-a bẹ ya ezi ngu t'i jekfube Fero je edufuta ndu nk'iya, bụ ndu Ízurẹlu lẹ Íjiputu!” ");
INSERT INTO iqw_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Obenu lẹ Mósisu sụru Nchileke: “?Bụ onye bẹ ya bụ k'oje ọkpofu Fero l'ifu; dufuta ndu Ízurẹlu lẹ Íjiputu?” ");
INSERT INTO iqw_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nchileke asụ iya: “Ya e-swiru ngu-a eswiru. Ọdo bụ l'ọwaa a-bụru iphe-ọhubama, ii-gude maru l'ọo yẹbedua ziru ngu: I -dufutalẹphu ndu ono lẹ Íjiputu bẹ unu a-baru yẹbe Nchileke ẹja l'ugvu-a.” ");
INSERT INTO iqw_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mósisu asụ Nchileke: “Ọ -bụkwanuru lẹ ya jekfuberu ndu Ízurẹlu je asụ ẹphe: ‘Lẹ Nchileke kẹ nna ẹphe zikwaru iya tẹ ya byakfuta ẹphe.’ Ẹphe -jịkwanu iya ẹpha ngu; ?bụ ngụnu bẹ ya e-kfuru ẹphe?” ");
INSERT INTO iqw_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nchileke asụ Mósisu: “YA BỤ ONYE YA BỤ. Iphe, ii-kfuru ndu Ízurẹlu bụ: ‘L'ọo YẸBEDUA bẹ ziru ngu t'ị byakfuta ẹphe.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nchileke asụkwaphu Mósisu t'ọ sụ ndu Ízurẹlu: “L'ọo Ojejoje, bụ Nchileke kẹ nna unu phẹ; mbụ Nchileke kẹ Ébirihamu; Nchileke kẹ Áyizaku; mẹ Nchileke kẹ Jékọpu; bẹ ziru ngu t'ị byakfuta ẹphe. Ọ bụ ẹpha iya ndono gbururu jeye lẹ gbururu; bụru ẹpha ono bẹ ee-gude maru iya tsube l'ọgbo rua l'ọgbo. ");
INSERT INTO iqw_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tụgbua je ekukobe ndu bụ ọgurenya lẹ Ízurẹlu; sụ ẹphe lẹ Ojejoje, bụ Nchileke kẹ nna unu phẹ; mbụ Nchileke kẹ Ébirihamu; mẹ kẹ Áyizaku; mẹ kẹ Jékọpu byakfutaru ngu bya asụ lẹ ya lewaru unu ẹnya; bya aphụ egbe iphe, eeme unu lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ya kwewaru ụkwa lẹ ya e-dufuta unu l'iphe-ẹhuka, unu eje lẹ Íjiputu; duru unu je edobe l'ẹgiri alị ndu Kénanu; mẹ kẹ ndu Hetu; kẹ ndu Amọru; kẹ ndu Pẹ́rezu; kẹ ndu Hevu; mẹ kẹ ndu Jebusu. ");
INSERT INTO iqw_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ndu bụ ọgurenya lẹ Ízurẹlu e-geberu ngu-a nchị. Ọo ya bụ lẹ nggụbedua; mẹ ndu bụ ọgurenya a-yị jekfube eze ndu Íjiputu je asụ iya: ‘Lẹ Ojejoje, bụ Nchileke kẹ ndu Híburu; bẹ byakfutakwaru unu. T'ọ hanụa unu t'unu jee ije ujiku ẹto lụfu l'echi-ẹgu; je egwooru Ojejoje, bụ Nchileke unu ẹja.’ ");
INSERT INTO iqw_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ya makwaru-a l'eze ndu Íjiputu te ekwedu t'unu je; gbahaa l'e meru iya l'ẹka ike. ");
INSERT INTO iqw_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ọo ya bụ lẹ ya a-machị ẹka; gude iphe, dụ biribiri, ya e-me lẹ Íjiputu nụa ẹphe chịkfuu. Teke iphe ono -metsuaru bẹ oo-kwetaa haa unu t'unu la. ");
INSERT INTO iqw_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ya e-me tẹ ndu Ízurẹlu nọdu ndu Íjiputu l'obu; k'ọphu bụ; unu -ladẹlephu; t'unu ba agba ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Iphe, bụ nwanyi Ízurẹlu, nọnu a-rọta onye obutobu iya; m'ọ bụ nwanyi, bu l'ụlo iya iphe, e meru lẹ mkpọla-ọcha; mẹ ọphu e meru lẹ mkpọla-ododo; mẹ uwe, unu e-ye ụnwegirima unu. Ọo ya bụ unu eshi ẹge ono gwoo iphe ndu Íjiputu gude la.” ");
INSERT INTO iqw_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mósisu asụ: “?Ọ -bụkwanuru l'ẹphe te kwetadu iphe, ya kfuru; m'ọ bụkwanu l'ẹphe te kwedu ngabẹru iya nchị; sụ l'ọ bụ ẹjo-ire; lẹ Ojejoje ta abyakfutadu iya-e?” ");
INSERT INTO iqw_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ojejoje ajị iya: “?Bụ ngụnu b'i gude l'ẹka ẹge ono?” Yọ sụ iya l'ọ kwa mgbọro. ");
INSERT INTO iqw_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ojejoje asụ iya t'ọ tọgbo iya l'alị! Yọ tọgbo iya. Yọ ghọo agwọ. Yo ye ọkpa l'ọso. ");
INSERT INTO iqw_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ojejoje asụ iya: “Machịa ẹka gude iya lẹ mgbọdzu!” Mósisu abya amachịa ẹka; zụ agwọ ono. Yọ ghọo; bya abụru mgbọro ẹge o shi bụru. ");
INSERT INTO iqw_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ojejoje asụ iya l'iphe ono bụ k'ọphu ẹphe e-kweta lẹ Ojejoje, bụ iya bụ Nchileke kẹ nna ẹphe; mbụ Nchileke kẹ Ébirihamu; Nchileke kẹ Áyizaku; mẹ Nchileke kẹ Jékọpu bẹ byakfutaru ngu nụ. ");
INSERT INTO iqw_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ojejoje asụkwaphu Mósisu t'o nwua ẹka lẹ mkpuli uwe iya! Mósisu abya enwua ya. T'o wofuta ẹka; bẹ ẹhu-labụ mewaru iya ẹka; yọ chahụwa phorophoro. ");
INSERT INTO iqw_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nchileke asụ iya: “Ngwaa; yephu ẹka ngu azụ lẹ mkpuli-ẹpho ngu!” Mósisu abya eyephu iya azụ. Yo wofuta iya; ẹhu-labụ ono emishihuwa; ẹka iya adụkotawa iya ẹge ẹhu iya ibe iya ọphu dụ. ");
INSERT INTO iqw_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ya ndono; Ojejoje asụ: “Ọ -bụru l'ẹphe te ekwetadu nke ngu; m'ọ kwanu l'ẹphe ta angabẹduru ngu nchị l'iphe-ọphulenya kẹ mbụ phụ bẹ ẹphe e-kweta-a k'ẹbo-wa. ");
INSERT INTO iqw_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ọbu; ọ -bụru l'ẹphe te kwetadu; ọ -bụkwanuru l'ẹphe ta ngabẹduru ngu nchị l'iphe-ọphulenya labụ-wa; nggu eje ekuta mini lẹ Ẹnyimu Náyịlu; bya awụshi l'alị ọkponku. Mini ono, i kutaru l'ẹnyimu ono a-ghọ mee l'alị l'ẹke ono.” ");
INSERT INTO iqw_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mósisu asụ Ojejoje; “Nnajiufu; ya ta amakwa ẹge aasajẹ okfu. Tsubekpoo lẹ mbụ byeye nta-a, iikfu eyeru yẹbe nwozi ngu-a bẹ ya bụlephu onye apa ire apapa; bya abụru onye atsụ ntsụ.” ");
INSERT INTO iqw_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ojejoje asụ iya: “?Bụ onye meru ọnu madzụ? ?Bụ onye emeje madzụ t'ọoda nkịchi; m'ọ bụ t'ọnu bụru iya kpụrukuduku? ?Bụ onye emeje madzụ t'ọ phụ ụzo; m'ọ bụ t'ọ tsụ ìshì? ?Tọ bụdu yẹbedua, bụ Ojejoje? ");
INSERT INTO iqw_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ngwaa; je! Ya e-yetaru ngu-a ẹka t'i kfua okfu; zikwa ngu phụ iphe, ii-kfu.” ");
INSERT INTO iqw_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Obenu lẹ Mósisu sụru iya: “Byiko; Onye nwe mu-nụ; zia ya rụ onye ọdo t'o je iya.” ");
INSERT INTO iqw_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ya ndono; ẹhu eghulahaa Ojejoje eghughu l'ẹke Mósisu nọ. Yọ sụ Mósisu: “?Nwunne ngu; mbụ Érọnu, bụ o-shi-l'eri Lívayi eghe-e? Ya makwarua lẹ Érọnu maru ẹge eekfuje okfu. Ọ nọokwa l'ụzo l'abya ngu ndzuta. Ọdo bụ l'ẹhu a-tsọ iya ẹna m'ọ -phụa ngu. ");
INSERT INTO iqw_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ii-kfuje yeru iya; karu iya iphe, oo-kfu. Ya a-nọdua eyeru unu ẹbo ẹka l'okfu okfu; l'ezijekwaphu unu iphe, unu e-meje. ");
INSERT INTO iqw_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ọ bụ Érọnu e-kfuchitajeru ngu l'ẹke ndu Ízurẹlu nọ. Ọ bụ iya a-bụru ọnu ngu; nggụbedua adụ l'ọ bụ Nchileke l'ẹke, ọono. ");
INSERT INTO iqw_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ọlobu t'i gude mgbọro-wa, i gude l'ẹka-wa; k'ọphu ii-gude iya mee iphe-ọphulenya ono.” ");
INSERT INTO iqw_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Tọ dụ iya bụ; Mósisu abya ejekfu Jeturo, bụ nna nyee ya je asụ iya t'ọ haa ya tẹ ya jekfu ndibe ẹphe Íjiputu je amaru; ?mẹ ẹphe nọ-kwadu-a ndzụ. Jeturo ekweta; sụ iya t'ọ tọkwa ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Teke ono bẹ Ojejoje nọhawa l'alị Mídiya; sụ Mósisu t'ọ tụgbua laphu azụ lẹ Íjiputu; kẹ l'iphe bụ ndu ono, shi achọ ndzụ iya ono nwụshihukotawaru. ");
INSERT INTO iqw_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tọ dụ iya bụ; Mósisu abya eduta nyee ya; mẹ ụnwu iya; ẹphe enyikobe nkakfụ-ịgara; yọ bụru ẹphe ọla Íjiputu. Yo wota mgbọro Nchileke ono gude l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ojejoje sụ Mósisu: “Ị -lalẹphu Íjiputu; chịkokwa iphe, dụ biribiri ono, ya nụru ngu ike t'i mee l'ifu Fero ono mekota. Ọle ya a-kpọ-chi iya ọkpoma akpọ-chi; k'ọphu bụ l'ẹ too kwedu aha ndu Ízurẹlu t'ẹphe la. ");
INSERT INTO iqw_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Iphe, ii-kfuru Fero bụ l'ọo yẹbe Ojejoje sụru l'ọo Ízurẹlu bụ ọkpara iya. ");
INSERT INTO iqw_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ya kfuwaru ngu sụ t'ị haa ọkpara iya ono t'ọ la; k'ọphu ọo-baru iya ẹja. Ị -jịka l'ẹ tịi hadu iya t'ọ la bẹ ya e-gbukwa ọkpara nkengu.” ");
INSERT INTO iqw_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ya ndono; yo rua l'ụzo ẹke ẹphe radụru; Ojejoje abyakfuta Mósisu; melahaa tẹ ya gbua ya. ");
INSERT INTO iqw_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Zipora ewota mkpuma, atsụ nkọ; bya ebuta nwatibe iya akpapyị; denyi Mósisu l'ọkpa; sụ iya lẹ nta-a bẹ ẹphe lụwaru l'ẹhu mee. ");
INSERT INTO iqw_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ya ndono; Ojejoje ahaa ya. Teke ono, Zipora sụru l'ẹphe lụwaru l'ẹhu mee ono bẹ iphe, ọoru ẹka bụ k'obu útsù phụ. ");
INSERT INTO iqw_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ojejoje asụ Érọnu t'o je Mósisu ndzuta l'echi-ẹgu. Tọ dụ iya bụ; Érọnu agbakfu Mósisu l'ugvu Nchileke; je anmaa ya akpa. ");
INSERT INTO iqw_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mósisu abya akọkotaru Érọnu iphemiphe ọbule, Ojejoje ziru iya t'o je ekfua; mẹkwaphu k'iphe-ọphulenya ono, Nchileke sụru t'o meshia ono. ");
INSERT INTO iqw_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mósisu yẹle Érọnu abya ekukota ndu bụ ọgurenya Ízurẹlu l'ẹphe ha; ");
INSERT INTO iqw_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Érọnu abya atụko iphemiphe ọbule ono, Ojejoje kfushiru Mósisu ono kfukotaru ẹphe. Yọ bya emee iphe-ọphulenya ono l'ifu ndu Ízurẹlu; ");
INSERT INTO iqw_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ẹphe ekweta. Ẹphe anụlephu lẹ Ojejoje akpa ishi ẹphe; mẹ l'ọ phụwaru iphe-ẹhuka, ẹphe eje; fuzita; baaru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","E metsua; Mósisu yẹle Érọnu ejekfu Fero je asụ iya: “Lẹ Ojejoje, bụ Nchileke kẹ Ízurẹlu sụkwaru t'ọ haa ndibe iya t'ẹphe je agbaaru iya ajị l'echi-ẹgu.” ");
INSERT INTO iqw_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Fero ajị ẹphe: “?Bụ onye bụ Ojejoje; k'ọphu ya a-ngabẹru iya nchị; haa ndu Ízurẹlu t'ẹphe tụgbua? Ya ta makwa Ojejoje ono; ya ta aha ndu Ízurẹlu t'ẹphe tụgbua.” ");
INSERT INTO iqw_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ẹphe asụ iya: “Nchileke ndu Híburu byakfutakwaru ẹphe. Hanụa ẹphe t'ẹphe lụfu l'echi-ẹgu jee ije abalị ẹto je agbaru Ojejoje, bụ Nchileke ẹphe ẹja. Ọdumeka bẹ oo-gudekwa o-me-l'ẹhu; m'ọ bụ ọgu gbushia ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Obenu l'eze ndu Íjiputu kuru Mósisu yẹle Érọnu; jị ẹphe: “?Bụ ngụnu kparu iphe unu jeru je achịfuta ndu ono l'ozi ẹphe? Ngwaa; unu tụgbua laphu azụ l'ozi unu!” ");
INSERT INTO iqw_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Yọ sụkwaphu ẹphe: “Unu lewaru! Nta-a bẹ ndu Ízurẹlu hawaa l'igwe; unu abya akpọshilahaa ẹphe ozi, ẹphe eje!” ");
INSERT INTO iqw_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ọ kwaphụ mbọku ono bẹ Fero kuru ndu udumalị; mẹ ndu bụ ishi l'ozi ndu Ízurẹlu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Unu ba anụjehe ndu Ízurẹlu ẹswa, ẹphe e-gudeje ayọ ẹja! T'ẹphe jeje je achọo ẹswa chịta l'onwẹphe! ");
INSERT INTO iqw_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ọle t'ọ bụkwaru ẹja ole, ẹphe shi ayọtajehawaa lẹ mbụ bẹ unu e-me ẹphe t'ẹphe yọtaje. Unu be egbubotakwa iphe l'ẹja ole, ẹphe shi ayọtajehawaa. Ẹphe bụ ndu ẹnyiru. Yọ bụru iya kparu iphe, ẹphe echi mkpu t'a haa ẹphe t'ẹphe je egwooru Nchileke ẹphe ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Unu kabaa ẹphe ọkpabe ozi; k'ọphu ụzo k'oje ọngabe nchị lẹ ntụmatu ta dụheduru ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ya ndono; ndu udumalị; mẹ ndu bụ ishi l'ozi ono asụ ndu Ízurẹlu: “Ọwaa iphe, Fero ekfu. Ọ sụru t'ẹ ba nụjehe unu ẹswa. ");
INSERT INTO iqw_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","T'unu jeje je achịta iya l'onwunu l'ẹke unu phụru iya. Ọle ozi unu; b'e te egbubotakwa iphe m'ọo nanụ.” ");
INSERT INTO iqw_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tọ dụ iya bụ; ndu Ízurẹlu agbakashịhu tsoru alị Íjiputu l'ọ ha; chọlahaa ẹswa, ẹphe e-vuta gude ayọ ẹja ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ndu udumalị achịlahaa ẹphe kpabẹkpabe; sụ ẹphe: “T'ẹphe yọta-dzua ẹja ole, ẹphe shi ayọtaje l'ụboku teke phụ, e shi evutajeru ẹphe ẹswa phụ!” ");
INSERT INTO iqw_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ndu udumalị Fero abya echilahaa ndu ishi l'ozi ndu Ízurẹlu ono iphe; mbụ ndu ono, ẹphe fọtaru dobe t'ẹphe letaje ndu Ízurẹlu ẹnya ono; sụ ẹphe: “?Bụ ngụnu kparu iphe, unu ta yọ-dzudu ẹja unu ụnyaphua; mẹ ntanụ ẹge unu shi ayọ-dzujehawa iya?” ");
INSERT INTO iqw_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ndu ishi l'ozi ndu Ízurẹlu ono abya awukfu Fero; sụ iya: “?Bụ ngụnu bẹ iime ẹphebe ndu ozi ngu ẹge-a? ");
INSERT INTO iqw_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ndu ozi ngu b'e te vutajeheduru ẹswa; tẹmanu a sụkwaphu t'ẹphe yọo ẹja. E chilahaa ndu ozi ngu iphe; l'ẹke ọ kwa ndu nke ngu b'o shi l'ẹka.” ");
INSERT INTO iqw_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Fero asụ: “Ọ bụ kẹ mmanu ono, unu nọ ono kparu iphe, unu wataru okfu t'a haa unu t'unu je egwooru Ojejoje ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Unu tụgbua nta-a je eje ozi, unu eje. E te evutaheduru unu ẹswa. Ọle mkpakọ bụkwa t'unu yọta-dzujee ẹja ole, unu shi ayọtaje!” ");
INSERT INTO iqw_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ndu ishi l'ozi ndu Ízurẹlu abya amaru l'ẹphe nmawaru lẹ gangu; l'ẹphe nụtsuaru l'e te egbubotadu iphe l'ẹja ole, ẹphe shi ayọtaje l'ụboku. ");
INSERT INTO iqw_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ẹphe alụfutalephu l'ufu Fero; phụa Mósisu yẹle Érọnu l'ẹke ẹphe vudo l'eche ẹphe; ");
INSERT INTO iqw_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","su ẹphe: “Tẹ Ojejoje lekwaa ẹnya l'iphe-a, unu meru-wa; kpee unu ikpe iya! Kẹ l'unu kpatawaru; ẹphe abya adụ Fero yẹle ndu ozi iya ashị. Nta-a bẹ unu wowaru mma ye ẹphe l'ẹka t'ẹphe gbushia ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mósisu ejekfu Ojejoje bya asụ iya: “Nggụbe Nnajiufu! ?Bụ ngụnu kparu iphe, i wotaru ndu-a egbe iphe-ẹhuka ọwaa? ?Bụ ngụnu kparu iphe, i ziru iya egbe ozi ọwaa? ");
INSERT INTO iqw_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Keshinu teke ya jekfutsuaru Fero je egude ẹpha ngu kfuru yeru iya b'o wotaru iphe-ẹhuka, dụ ẹge-a tukobe ẹphe l'ishi. Ọphu 'onwedu iphe, i meru lẹ phuu gude dzọfuta ndu nke ngu.” ");
INSERT INTO iqw_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ya ndono; Ojejoje asụ Mósisu: “Nta-a bẹ ịi-phụnua iphe, ya e-me Fero. Kẹ l'ọo ẹka-ike bẹ ya e-gude mee; yọ haa ẹphe; mbụ l'ọo ẹka-ike bẹ ya e-gude mee; yọ chịfu ẹphe l'alị iya.” ");
INSERT INTO iqw_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nchileke asụ Mósisu: “L'ọo yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ya seru Ébirihamu l'ifu; see Áyizaku l'ifu; sekwaaphu Jékọpu l'ifu; kfuru ẹphe l'ẹpha iya bụ Nchileke, bụ Ọkaribe-Kakọta-Ike. Obenu l'ẹpha iya ono, bụ Ojejoje ono bẹ ya te medu t'ẹphe maru. ");
INSERT INTO iqw_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ẹphe l'iya abya agbaa ndzụ lẹ ya a-nụ ẹphe alị Kénanu, bụ ẹke ẹphe shi buru l'ọ bụ ndu laru alala. ");
INSERT INTO iqw_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ọdo abụru lẹ ya nụwaru ude, ndu Ízurẹlu atsụ; mbụ ndu ono, ndu Íjiputu meru; ẹphe abụru ohu ono; nyata ọgba-ndzụ iya ono. ");
INSERT INTO iqw_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Ọo ya bụ; unu sụ ndu Ízurẹlu: ‘L'ọ bụ yẹbedua bụ Ojejoje. Ya a-nafụta unu l'ozi mkpọ-nyi-ẹnya ono, ndu Íjiputu dzuberu unu ono; mee t'unu nweru onwunu; t'unu ba bụhe ohu ẹphe. Ya a-machị ẹka iya gude dzọfuta unu; bya emeshia iphe, dụ biribiri gude nụa ẹphe aphụ. ");
INSERT INTO iqw_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ya e-me unu; unu abụru ndu nk'iya; yẹbedua abụru Nchileke unu. Ọo ya bụ; unu amaru l'ọo yẹbedua, bụ Ojejoje bụ Nchileke unu; mbụ onye ono, nafụtaru unu l'ozi mkpọ-nyi-ẹnya ono, ndu Íjiputu dzuberu unu ono. ");
INSERT INTO iqw_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ya e-duta unu dubata l'alị ono, ya paliru ẹka iya imeli; ria angu lẹ ya a-nụ Ébirihamu; mẹ Áyizaku; mẹ Jékọpu ono. Ya a-nụ iya unu t'ọ bụru òkè-iphe unu. Ọo yẹbedua bụ Ojejoje.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mósisu abya ezia ndu Ízurẹlu, iphe ono, Nchileke ziru ono. Obenu l'ẹphe te yeduru iya ọnu; kẹle meji tọfuwaru ẹphe; l'ozi mkpọ-nyi-ẹnya ono, e dzuberu ẹphe ono. ");
INSERT INTO iqw_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ojejoje asụ Mósisu ");
INSERT INTO iqw_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","t'o je ekfuaru Fero, bụ eze ndu Íjiputu t'ọ haa ndu Ízurẹlu t'ẹphe tụgbua lụfu lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mósisu asụ Ojejoje: “Ọ -bụru lẹ ndu Ízurẹlu ta ngaduru iya nchị; ?nanụ ẹge Fero e-shi ngaaru iya nchị ẹge-a ya atsụ ntsụ-a?” ");
INSERT INTO iqw_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tọ dụ iya bụ; Ojejoje abya ekfuaru Mósisu yẹle Érọnu okfu ẹhu ndu Ízurẹlu; mẹ okfu ẹhu Fero bụ, eze ndu Íjiputu; sụ t'ẹphe dufuta ndu Ízurẹlu lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ọwaa bụ ndu, bụ ishi l'ẹnya-ufu nna ẹphe. Ụnwu kẹ Rúbẹnu, bụ ọkpara Ízurẹlu bụ Hanọku; Palu; Hézurọnu; mẹ Kami. Ndu ono bụkota ndu ikfu Rúbẹnu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ụnwu kẹ Símiyọnu bụ Jimẹlu; Jaminu; Ohadu; Jakinu; Zoharu; mẹ Shọlu, bụ nwanyi Kénanu mụtaru iya. Ndu ono bụkota ndu ikfu Símiyọnu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ọwaa bụ ẹpha ụnwu Lívayi l'ẹge e deru ẹphe l'ẹkwo: Geshọnu; Kohatu; mẹ Merari. Lívayi nọru ụkporo afa ishingu l'afa iri l'ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ụnwu Geshọnu l'ẹnya-ufu l'ẹnya-ufu bụ Libuni; waa Shimeyi. ");
INSERT INTO iqw_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ụnwu Kohatu bụ Amuramu; Izuha; Hẹ́buronu; mẹ Uzẹlu. Kohatu nọru ụkporo afa ishingu l'afa iri l'ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ụnwu Merari bụ Mahuli; mẹ Mushi. Ono bụ ndu ikfu Lívayi l'ẹge e deru iya l'ẹkwo. ");
INSERT INTO iqw_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu bẹ lụru nwunne nna iya, bụ Jokebẹdu. Yọ mụtaru iya Érọnu; mẹ Mósisu. Amụramu nọru ụkporo afa ishingu l'afa iri l'ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ụnwu Izuha bụ Kora; mẹ Nefẹgu; ọwaa Zikiri. ");
INSERT INTO iqw_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ụnwu Uzẹlu bụ Mishẹlu; mẹ Eluzafanu; ọwaa Sitiru. ");
INSERT INTO iqw_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Érọnu bẹ lụru Elisheba, bụ nwatibe Amínadabu; bụkwaruphu nwunne Náshọnu kẹ nwanyi. Elisheba ono amụtaru iya Nadabu; Abihu; Eliyéza; mẹ Itama. ");
INSERT INTO iqw_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ụnwu Kora bụ Asiru; mẹ Ẹlukana; ọwaa Abiyasafu. Ndu ono bụ ndu ẹnya-ufu Kora. ");
INSERT INTO iqw_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliyéza Érọnu lụru nwatibe Putẹlu. Yọ bya amụtaru iya Finehasu. Ndu ono bụkota ndu ishi ufu ndibe Lívayi l'ikfu l'ikfu. ");
INSERT INTO iqw_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ọ bụ Érọnu ono; yẹle Mósisu bụ ndu Ojejoje sụru t'ẹphe shi lẹ Íjiputu dufuta ndu Ízurẹlu l'ẹphe ha! ");
INSERT INTO iqw_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ọ bụ ẹphe bụ ndu, kfuru Fero, bụ eze ndu Íjiputu kẹ odufuta ndu Ízurẹlu l'alị Íjiputu. Ọ kwaphụ Mósisu yẹle Érọnu lanụ ono b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ya ndono; teke ono, Ojejoje kfuru yeru Mósisu l'alị ndu Íjiputu ono ");
INSERT INTO iqw_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","bẹ Ojejoje sụru iya: “Ọ bụ yẹbedua bụ Ojejoje. Zikota Fero, bụ eze Íjiputu iphemiphe ọbule ono, ya ziru ngu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Obenu lẹ Mósisu sụru Ojejoje: “Keshinu ya bụ onye atsụ ntsụ; ?nanụ ẹge Fero e-shi ngabẹru iya nchị?” ");
INSERT INTO iqw_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “Lekwa lẹ ya mewaru ngu; t'ị dụ Fero l'ọ bụ Nchileke. Nwunne ngu Érọnu abụru onye a-nọdu ekfuchitaru ngu okfu. ");
INSERT INTO iqw_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kfukotakwa iphemiphe ọbule, ya kfuru ngu. Nwunne ngu Érọnu e-kfuru Fero t'ọ haa ndu Ízurẹlu t'ẹphe lụfu l'alị iya. ");
INSERT INTO iqw_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Obenu lẹ ya a-kpọ-chi Fero ọkpoma. Ya e-meshi iphe-ọphulenya; mẹ iphe dụgbaa biribiri l'alị Íjiputu; ");
INSERT INTO iqw_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","obenu lẹ Fero ta angadụru unu nchị. Ọ bụ teke ono bẹ ya e-byi ndu Íjiputu ẹka; meshia iphe, dụ biribiri; gude nụa ẹphe aphụ; shi ẹge ono dufuta ndibe iya, bụ ndu Ízurẹlu l'ẹphe ha lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ndu Íjiputu a-marua l'ọ bụ yẹbedua bụ Ojejoje teke ya machịleruphu ẹka; byia ndu Íjiputu; dufuta ẹphe ndu Ízurẹlu l'ẹka.” ");
INSERT INTO iqw_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mósisu yẹle Érọnu abya emee iphe Ojejoje ziru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mósisu nọwaru ụkporo afa ẹno; Érọnu anọwa ụkporo afa ẹno l'afa ẹto teke ẹphe jeru je ekfuru nụ Fero. ");
INSERT INTO iqw_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ojejoje asụ Mósisu yẹle Érọnu: ");
INSERT INTO iqw_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ọ -bụru lẹ Fero sụru unu t'unu mee iphe-ọphulenya gude koshi iphe, unu ekfu; nggu asụ Érọnu t'o wota mgbọro iya tọgbo Fero l'ifu; t'ọ ghọo agwọ!” ");
INSERT INTO iqw_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ya ndono; Mósisu yẹle Érọnu abya ejekfu Fero je emekota ẹge Ojejoje ziru ẹphe. Érọnu atọgbo Fero yẹle ndu ozi iya mgbọro ono l'ifu; yọ ghọo agwọ. ");
INSERT INTO iqw_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Fero abya ekukoo ndu mmamiphe; mẹ ndu amamanshi. Ndu njibya Íjiputu ono egude ụzo, ẹphe egudeje eme amamanshi; mekwaaphu iphe ono. ");
INSERT INTO iqw_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Onyenọnu l'ẹphe ha abya atọgbokota mgbọro nk'iya l'alị; yọ ghọshia agwọ. Ọle mgbọro kẹ Érọnu bya achịko mgbọro kẹ ndu ono lekota. ");
INSERT INTO iqw_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Obekwanu l'obu Fero kpọ-chileru-a ẹge ọ kpọ-chiru; tọ ngarụ ẹphe nchị, bụ iya bụ ẹge ono, Ojejoje kfuhawaru ono. ");
INSERT INTO iqw_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ya ndono; Ojejoje asụ Mósisu l'obu Fero kpọ-chikwaru akpọ-chi. Ọ jịkakwaru lẹ ya ta ahadu ndu Ízurẹlu t'ẹphe la. ");
INSERT INTO iqw_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sụ iya: “Jekfu Fero l'ụtsu teke ọo-nọdu eje l'ẹnyimu. Nọdu l'iku Náyịlu kwabẹru iya; nggu ewota mgbọro phụ, shi ghọo agwọ phụ gude l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Nggu asụ iya lẹ Ojejoje, bụ Nchileke kẹ ndu Híburu zikwaru ngu t'ị bya asụ iya t'ọ haa ndibe iya t'ẹphe la; k'ọphu ẹphe a-baru iya ẹja l'echi-ẹgu. Obenu lẹ keshinu teke ono b'ẹ to kwedu. ");
INSERT INTO iqw_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ọwaa iphe, Ojejoje ekfu: ‘Lẹ shita l'iphe-a; bẹ ịi-maru l'ọo yẹbedua bụ Ojejoje. Yẹbe Mósisu e-woru mgbọro-a, ya gude l'ẹke-a chia lẹ mini Náyịlu. Mini ono aghọo mee. ");
INSERT INTO iqw_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ẹma, nọkota lẹ Náyịlu a-nwụshihukota. Ẹnyimu ono eshihu erehu erehu; k'ọphu bụ lẹ ndu Íjiputu ta adụdu ike ọngu mini, shi iya nụ.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ojejoje asụ Mósisu: “T'o kfuaru Érọnu t'o wota mgbọro iya machịa l'iphe, bụ mini, nọkota l'alị Íjiputu: l'iphe, bụ ẹnyimu; iphe, bụ nggele; iphe, bụ okpuru; mẹ iphe bụ mgbakọbe-mini nọnu; t'ọ ghọo mee. Mee a-tụko ẹkemeke ọbule dzuru l'alị Íjiputu; mbụ je akpaa l'iphe bụ ọdo-mini; ndu ọphu a pyịru apyịpyi; mẹ ndu ọphu a kpụru akpụkpu.” ");
INSERT INTO iqw_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mósisu yẹle Érọnu abya emee ẹge ono, Ojejoje ziru ẹphe ono. Yọ bya eworu mgbọro iya malia l'ifu Fero yẹle ndu ozi iya; bya echia ya lẹ Ẹnyimu Náyịlu. Mini, nọ l'ẹnyimu ono l'ọ ha agbanwee bụru mee. ");
INSERT INTO iqw_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ẹma, nọkota lẹ Náyịlu anwụshihukota. Mini ono eshikota erehu erehu; k'ọphu bụ lẹ ndu Íjiputu ta dụdu ike ngụa mini, shi iya nụ. Mee ono achịko ẹkemeke ọbule sweta l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ndu njibya kẹ ndu Íjiputu abya egude amamanshi mekwaaphu ẹge ono. Tọ dụ ya bụ; Fero akpọ-chilee obu iya ẹge ọ kpọ-chiru iya; k'ọphu bụ l'ẹ tọ ngaduru Mósisu yẹle Érọnu nchị ẹge ono, Ojejoje kfuhawaru ono. ");
INSERT INTO iqw_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Fero aghakọbe; laphushia azụ l'ufu iya; ọphu iphe ono 'erukpodua ya nụ l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ndu Íjiputu abya atụshia nwogvu l'iku Náyịlu; ẹke ẹphe achọ mini, ẹphe a-ngụ; kẹle mini ẹnyimu ono ta dụdu k'angụngu. ");
INSERT INTO iqw_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","A nọlephu abalị ẹsaa; k'ọphu Ojejoje byiru ẹka lẹ Ẹnyimu Náyịlu. ");
INSERT INTO iqw_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ojejoje asụ Mósisu: “T'o jekfu Fero je asụ iya: ‘Ọwaa iphe Ojejoje ekfu: Haa ndibe iya t'ẹphe la; k'ọphu ẹphe eje a-baru iya ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ọ -bụru l'ị jịkaru t'ẹphe ba alashị; bẹ ya e-gudekwa mbara bya ọgu l'alị ngu l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mbara a-tụko Ẹnyimu Náyịlu ji; kposhia bya eji ufu ngu; ji ime ụlo ẹke ịizeje; ji oshi-azẹe ngu; ji ụlo ndu ozi ngu; ji ufu ndu alị ngu l'ẹphe ha; ji ọnu ekfu, eeshijeru ngu ite; mẹ l'ochi, eegudeje agwọ iphe, e gude emeru ngu buredi. ");
INSERT INTO iqw_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mbara ono a-nọduje akfụ-kogbaa ngu l'ẹhu; mẹ l'ẹhu ndu alị ngu; mẹ l'ẹhu ndu ozi ngu l'ẹphe ha.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ojejoje asụ Mósisu: “T'o kfuru Érọnu t'o wolia mgbọro iya ono; maa l'ẹnyimu ẹnyimu; mẹ nggele nggele; mẹ l'okpuru okpuru; mee tẹ mbara bya edzuru alị Íjiputu.” ");
INSERT INTO iqw_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Érọnu abya amachịa ẹka lẹ mini, nọkota l'alị Íjiputu. Mbara awụfuta bya edzuru alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Obenu lẹ ndu amamanshi ono gude amamanshi ẹphe mekwaaphu ẹge ono. Ẹphe emekwaaphu; mbara awụbata l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Fero ekua Mósisu yẹle Érọnu; sụ ẹphe: “T'ẹphe kfuru nụ Ojejoje t'o wofuru yẹle ndu alị iya l'ẹphe ha mbara-wa; ẹge ya ahaa ndibe unu t'ẹphe je agwaa Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mósisu asụ Fero: “Lẹ ya a-hakpọo ngu t'ị kọo teke ya e-kfuru nụ Nchileke l'okfu ẹhu ngu; l'okfu ẹhu ndu ozi ngu; mẹ l'okfu ẹhu ndu alị ngu; k'ọphu mbara ono a-ha ngu; haa ufu ngu; wụlala lẹ Ẹnyimu Náyịlu nwẹnkinyi.” ");
INSERT INTO iqw_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Fero asụ: “L'ọ bụ echile.” Mósisu asụ: “T'ọ dụ ẹge i kfuru; k'ọphu ii-shi ẹge ono maru l'ẹ tọ dụdu onye dụ l'ọ bụ Ojejoje, bụ Nchileke ayi. ");
INSERT INTO iqw_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mbara ono a-ha ngu; haa ufu ngu; haa ndu ozi ngu; haa ndu alị ngu. Ẹke ọo-phọdu nwẹnkinyi bụ lẹ Ẹnyimu Náyịlu.” ");
INSERT INTO iqw_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mósisu yẹle Érọnu alụfulephu l'ifu Fero; Mósisu abya araku Ojejoje lẹ kẹ mbara ono, o meru; yọ bya ọgu l'alị-eze Fero ono. ");
INSERT INTO iqw_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ojejoje abya emeeru Mósisu iphe, ọ rọru iya. Mbara ono anwụshihukota l'ụlo; mẹ l'ogbodufu; mẹ l'ẹgu. ");
INSERT INTO iqw_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","A bya akụa ẹphe l'ikpo l'ikpo. Alị ono l'ọ ha eshihu kẹ rụkurugbangu. ");
INSERT INTO iqw_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Obenu lẹ Fero phụleruphu lẹ mbara ono gwụwaru; woru ọkpoma iya kpọ-chia. Ọphu o kwehedu ngabẹru Mósisu yẹle Érọnu nchị, bụ iya bụ ẹge ono, Ojejoje kfuhawaru ono. ");
INSERT INTO iqw_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","To dụ iya bụ; Ojejoje asụ Mósisu t'o kfuru Érọnu t'ọ machịa mgbọro iya chia l'ẹja, nọ l'alị; k'ọphu ẹja ono a-ghọ mkpụrúmkpu; dzuru alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ẹphe emee ya ẹge ono. Érọnu abya amachịa mgbọro ono; chia l'ẹja, nọ l'alị. Mkpụrúmkpu abya erikputa madzụ yẹle anụ. Iphe, bụ ẹja nọ l'alị Íjiputu mgburumgburu aghọo mkpụrúmkpu. ");
INSERT INTO iqw_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ndu amamanshi ono abya emelahaa t'ẹphe gude amamanshi mekwaaphu ẹge ono. Ẹphe ta dụ ike mee ya. Mkpụrúmkpu ono achịko madzụ yẹle anụ rikputa. ");
INSERT INTO iqw_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ndu amamanshi ono asụ Fero: “L'iphe-wa bẹ ẹka Nchileke dụkwa.” Obenu lẹ Fero kpọ-chilerua obu; to kwe ngabẹ nchị; bụ iya bụ ẹge ono, Ojejoje kfuhawaru ono. ");
INSERT INTO iqw_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ya ndono; Ojejoje asụ Mósisu t'o tehu l'ọnmewa ụtsu; jekfu Fero m'o jedelephu l'ẹnyimu; sụ iya lẹ Ojejoje sụru: “T'ọ haa ndibe iya t'ẹphe laa; je abaaru iya ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ọ -bụru l'ẹ tị hadu ndibe yẹbe Ojejoje t'ẹphe la bẹ ya e-zikwa ijiji t'o tsuru dududu; wụ-kfuta ngu; wụ-kfuta ndu ozi ngu; wụ-kfuta ndu alị ngu; mẹkwaphu ụlo ngu l'ọ ha. Ụlo ndu Íjiputu bẹ ijiji e-jikota l'etsu dududu; mbụ jeye l'alị ẹke ẹphe adzọje ọkpa. ");
INSERT INTO iqw_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Obenu lẹ mbọku ono bẹ ya e-me t'alị Gọ́shenu dụ iche. Mbụ l'ẹke ndibe iya bu b'ẹ ta aphụdu ijiji; k'ọphu ịi-maru lẹ yẹbedua, bụ Ojejoje nọ l'alị-a. ");
INSERT INTO iqw_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ya a-kpa ókè l'ẹke ndibe iya mẹ ndibe ngu nọ. Iphe-ọphulenya-wa bụ echile bẹ oo-me.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ojejoje abya emee ya ẹge ono. Ijiji etsuru dududu wụbata l'ufu Fero; mẹ l'ụlo ndu ozi iya; mẹ l'alị Íjiputu l'ọ ha. Ijiji ono achịkolephu alị Íjiputu l'ọ ha mebyishikota. ");
INSERT INTO iqw_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Fero abya ekua Mósisu yẹle Érọnu; sụ ẹphe: “Unu je agwaa Nchileke unu ọbu l'alị ẹke-a!” ");
INSERT INTO iqw_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Obenu lẹ Mósisu sụru iya: “L'ẹ tọ dụkwa mma ẹge ono; kẹ l'iphe, ẹphe egudeje agwa Ojejoje, bụ Nchileke ẹphe bụkwa akpamara l'ẹnya kẹ ndu Íjiputu. Ẹphe -gudekwanu iphe, bụ akpamara gwoo ẹja; ?ndu Íjiputu ta atụ-gbukwa nụ ẹphe lẹ mkpuma. ");
INSERT INTO iqw_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ayi e-jekwa ije abalị ẹto jerua l'echi-ẹgu je egwooru Ojejoje, bụ Nchileke ayi ẹja l'ẹke ono; ẹge ọ tụru l'ekemu t'ayi mee.” ");
INSERT INTO iqw_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Fero asụ: “Ya a-ha unu t'unu je egwooru Ojejoje, bụ Nchileke unu ẹja l'echi-ẹgu. Ọle t'unu be ejenukakwa ote-ẹnya. Unu kfuru nụru iya Nchileke nta-a!” ");
INSERT INTO iqw_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mósisu asụ iya: “Ya -shilephu l'ẹke ịino lụfu bẹ ya e-kfurua nụ Ojejoje; k'ọphu ijiji ono, etsu dududu ono a-ha nggụbe Fero; haa ndu ozi ngu; hakwaaphu ndu alị ngu. Ọle tẹ nggụbe Fero ba agbahẹkwa ẹregede; shi ẹge ono jịka tẹ ndu Ízurẹlu be eje egwooru Ojejoje ẹja!” ");
INSERT INTO iqw_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mósisu eshi l'ẹke Fero nọ lụfu; je ekfuru nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ojejoje emee iphe, Mósisu rọru iya. Ijiji ono aparu Fero; mẹ ndu ozi iya; mẹ ndu alị iya haa; to nwehe m'ọo ijiji lanụ, phọduru nụ. ");
INSERT INTO iqw_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Fero akpọ-chikwaaphu obu; to kwe tẹ ndu Ízurẹlu tụgbua. ");
INSERT INTO iqw_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ya ndono; Ojejoje asụ Mósisu: “T'o jekfu Fero je asụ iya: ‘Ọwaa iphe, Ojejoje, bụ Nchileke kẹ ndu Híburu ekfu. Ọ sụru “T'a aa ndibe iya t'ẹphe je; je abaaru iya ẹja!” ");
INSERT INTO iqw_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ị -jịka t'ẹphe be eje; lọ-gude ẹphe ");
INSERT INTO iqw_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","bẹ Ojejoje e-gudekwa ẹka iya ye ẹjo ome-l'ẹhu t'ọ bya achịko elu unu gbushia. Mbụ l'oo-gbushi ịnya unu; gbushia nkakfụ-ịgara unu; ịnya-ivu unu; eswi unu; atụru unu; mẹ eghu unu. ");
INSERT INTO iqw_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ọbule Ojejoje a-kpa oke l'ẹke elu ndu Ízurẹlu; mẹ l'ẹke kẹ ndu Íjiputu nọ; k'ọphu bụ l'ẹ to nwedu elu kẹ ndu Ízurẹlu m'ọo nanụ a-nwụhu nụ.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ojejoje abya eyee teke oo-mee iphe ono; sụ l'ọo echile bẹ yẹbe Ojejoje e-me iphe ono l'alị-a. ");
INSERT INTO iqw_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yo be echile iya; Ojejoje emee ya. Elu ndu Íjiputu anwụshihukota. Obenu l'ẹ to nwedu kẹ ndu Ízurẹlu m'ọo nanụ, nwụhuru nụ. ");
INSERT INTO iqw_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Fero eye ndu jeru je aphụ l'ẹ to nwedu elu kẹ ndu Ízurẹlu m'ọo nanụ, nwụhuru nụ. Obenu lẹ Fero kpọ-chilerua obu; to kwe tẹ ndu Ízurẹlu tụgbua. ");
INSERT INTO iqw_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ya ndono; Ojejoje asụ Mósisu mẹ Érọnu: “Unu kpota ntụ, jiru mkpoji ẹka l'ovo-vọku; tẹ Mósisu ghaa ya l'ifu ẹke, Fero nọ. ");
INSERT INTO iqw_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Oo-tsukashihu l'ọ bụ udzu; jegbaru alị Íjiputu; ghọo iphe-etsetse tseshia madzụ yẹle anụ, bu l'alị ono l'ọ ha; fushihu bụgbaaru ẹphe ọnya l'ẹhu.” ");
INSERT INTO iqw_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ya ndono; ẹphe eje ekpota ntụ-ọku; bya evudo Fero l'ifu. Mósisu eworu ntụ-ọku ono phekashia l'imeli. Iphe-etsetse abya etsekashia madzụ; mẹ anụ; fushihu bụru ẹphe ọnya l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ndu amamanshi ta dụ ike vudo Mósisu l'ifu; kẹ l'iphe-etsetse ono tseshikwaruphu ẹphe ẹge o tseshiru ndu Íjiputu ọphu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Obenu lẹ Ojejoje kpọ-chiru Fero obu; tọ ngaru Mósisu yẹle Érọnu nchị, bụ iya bụ ẹge ono, Ojejoje kfuhawaru iya Mósisu ono. ");
INSERT INTO iqw_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “Nmaa ẹwa l'ụtsu je evudo Fero l'ifu; sụ iya: ‘Ọwaa iphe, Ojejoje, bụ Nchileke kẹ ndu Híburu kfuru: Haa ndibe iya t'ẹphe je; je abaaru iya ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ọdumeka bẹ ọgiya-a bẹ ya e-wota ẹjo mkpakẹhu, a-lọ nggu lẹ ndu ozi ngu; mẹ ndu alị ngu ẹka l'obu; k'ọphu ịi-makwanụru l'ẹ tọ dụdu onye dụ l'ọ bụ yẹbedua lẹ mgboko-a. ");
INSERT INTO iqw_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ishi ya abụru lẹ nta-a bẹ ya ga amachịhawa ẹka; gude ẹjo ome-l'ẹhu gbushia nggu lẹ ndu alị ngu; unu achịhu lẹ mgboko-a. ");
INSERT INTO iqw_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Obenu l'iphe, kparu iphe, ya gude haa ngu bụ k'ọphu ya e-koshi ngu ẹge ike kẹ yẹbe Ojejoje habe nshinu; ee-kfudzuru ẹpha iya lẹ mgboko l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Obenu l'iipalikwadu onwongu imeli l'ẹke ndibe iya nọ; jịka l'ẹ tịi hadu ẹphe t'ẹphe la. ");
INSERT INTO iqw_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Egbe nta-a echile bẹ ya e-me t'ẹjo aka-mini tụa l'alị-a; mbụ egbe aka-mini ọphu ẹ ta tụbua l'alị Íjiputu keshinu teke ọ dụberu nọdu byeye ntanụ-a. ");
INSERT INTO iqw_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Zikwaa ozi nta-a t'e je achịbata elu ngu dobe l'ẹke iphe e-gbochita iya; kẹ l'aka-mini ono a-tụ-gbushikota madzụ; tụ-gbushia elu, nọ l'ẹgu, ẹ ta chịbatadu l'ufu; ẹphe anwụshihu.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ndu ozi Fero ndu ọphu atsụ Ojejoje egvu achịbata-kebewaphu ohu ẹphe; mẹ elu ẹphe l'ime ụlo. ");
INSERT INTO iqw_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Obenu lẹ ndu ẹ-te nwedu iphe ẹphe gụberu Ojejoje haru ohu ẹphe; mẹ elu ẹphe l'ẹgu. ");
INSERT INTO iqw_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ya ndono; Ojejoje asụ Mósisu t'ọ machịa ẹka l'akpamigwe tẹ aka-mini wata adashị l'alị Íjiputu tụ-gbushia madzụ; mẹ elu; mẹ iru, nọkota l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mósisu amachịlephu mgbọro iya l'akpamigwe; Ojejoje ezia egbe-igwe yẹle aka-mini; yọ wata adada. Ebemu-igwe l'eku mẹremu mẹremu. Ojejoje emee aka-mini; yọ chịa l'ọ bụ mini l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Aka-mini ono l'ada; ebemu l'eku o-ji-l'ẹka-tọgbo ono. Yọ bụru ẹjo oke phẹrephere, ha nshinu; kẹ l'ọ bụ ono bụ oke phẹrephere, kakọta nshinu lẹ phẹrephere, phejewaru nụ l'alị Íjiputu keshinu ọphu ọ dụberu bụru mba k'ẹka iya. ");
INSERT INTO iqw_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","L'alị Íjiputu mgburumgburu bẹ aka-mini ono tụ-gbushikotaru iphemiphe ọbule, nọkota l'ẹgu: madzụ mẹ elu. Yọ tụpyashia iphemiphe ọbule, futaru l'ẹgu; zijashitsua iphe bụ oshi, nọ l'ẹgu ezijashi. ");
INSERT INTO iqw_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ẹke, ẹ tọ tụdu aka-mini ono nwẹnkinyi bụ l'alị Gọ́shenu, bụ ẹke ndu Ízurẹlu bu. ");
INSERT INTO iqw_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ya ndono; Fero ezia t'e je ekuaru iya Mósisu yẹle Érọnu; bya asụ ẹphe: “Lẹ ya mewaru ẹji. Lẹ Ojejoje bẹ iswi dụ maa; yẹbedua, bụ Fero yẹle ndu nk'iya achọ okfu. ");
INSERT INTO iqw_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Unu kfuru nụ Ojejoje; kẹ l'egbe-igwe ono yẹle aka-mini ono tụta-shiwaru. Ya a-ha unu t'unu laa; unu ba anọhe ọdo.” ");
INSERT INTO iqw_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mósisu asụ iya: “Lẹ ya -lụfulephu lẹ mkpụkpu-a bẹ ya a-chili ẹka imeli; kfuru nụ Ojejoje. Egbe-igwe a-ha agbagba; aka-mini adabuhu; k'ọphu ịi-maru lẹ mgboko-a bụ kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Obenu lẹ ya marua lẹ nggụbedua; nggu lẹ ndu ozi ngu ta awatadụa ọtsu Ojejoje, bụ Nchileke egvu.” ");
INSERT INTO iqw_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Òghù balị yẹle oghu fulakusu bẹ aka-mini ono mebyishikotaru; kẹ lẹ balị eyeshiwa nebyi; ọphu bẹ fulakusu abụkwaduru-a igu bẹ ọotsu. ");
INSERT INTO iqw_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Obenu lẹ witu; mẹ supélutu b'ẹ to mebyishidu; kẹ l'ẹ tọ bụdu teke ono bẹ ọomije. ");
INSERT INTO iqw_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mósisu aparu Fero haa; shi lẹ mkpụkpu ono lụfu; je apalia ẹka imeli machịaru Ojejoje. Egbe-igwe ono yẹle aka-mini ono abụru kẹ nyonyoronyongu; mini ono abụru kengu l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Fero aphụlephu lẹ mini ono chị-buhuwaru; aka-mini ono yẹle egbe-igwe ono ebuhuwa; yo mekwaa iphe, dụ ẹji ọdo. Yẹbedua yẹle ndu ozi iya akpọ-chikwaa obu ẹphe ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ọkpoma Fero abya akpọ-chikwaa; ọphu o kwedu haa ndu Ízurẹlu t'ẹphe la; bụ iya bụ ẹge ono, Ojejoje shihawa Mósisu l'ọnu kfua ono. ");
INSERT INTO iqw_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ya ndono; Ojejoje asụ Mósisu: “Jekfu Fero; kẹle ya kpọ-chiru iya obu; kpọ-chia obu kẹ ndu ozi iya; k'ọphu ya e-mekota oke iphe-ọphulenya, dụgbaa biribiri l'ẹke ẹphe nọ; ");
INSERT INTO iqw_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","k'ọphu unu a-kọru ụnwu unu; mẹ ụnwu nwanwa unu ẹge ya gude meshia ndu Íjiputu ike; mẹ ẹge ya gude mee oke iphe-ọphulenya l'ẹke ẹphe nọ. Unu amakwanụru l'ọ bụ yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ya ndono; Mósisu yẹle Érọnu abya ejekfu Fero; je asụ iya: “Ọwaa iphe, Ojejoje, bụ Nchileke kẹ ndu Híburu ekfu. Ọoji: ‘?Bụ jeye teke ole; bẹ ịi-jịka-be owozita onwongu alị l'ẹke ya nọ? Haa ndibe iya t'ẹphe la; k'ọphu ẹphe a-baru iya ẹja! ");
INSERT INTO iqw_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ọ -bụru l'ị jịkaru t'ẹphe ba lashị bẹ ya e-gude igube bata l'alị ngu echile. ");
INSERT INTO iqw_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ọo-bya achịko alị ono nyịnwukota; k'ọphu bụ l'ẹ tọ dụdu ẹke aaphụ ụzo l'alị ono. Yọ chịko iphe, aka-mini mebyishiphodoru tapyashịkota; tapyashịkwaaphu iphe bụ oshi, futaru l'ẹgu unu. ");
INSERT INTO iqw_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ọo-bya atụko ụlo ngu; ụlo ndu ozi ngu; mẹ alị Íjiputu l'ọ ha nakọta. Iphe ono bụ iphe, nna ngu; mẹ nna ngu oche phẹ ta aphụbua l'alị-a; eshinu teke ẹphe laru ẹke-a byeye nta-a.’ ” Mósisu aparu Fero haa; ghakọbe; yọ bụru iya alala. ");
INSERT INTO iqw_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ndu ozi Fero asụ Fero: “?Bụ teke ole bẹ nwoke-a a-chọ-beru ayi ọkpu-akpọhu-a? Haa ndu-a t'ẹphe laa je abaaru Ojejoje, bụ Nchileke ẹphe ẹja. ?Tị madu l'alị Íjiputu bụwa kpurupyata?” ");
INSERT INTO iqw_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ya ndono; a bya eduphuta Mósisu yẹle Érọnu azụ l'ifu Fero. Yọ sụ ẹphe: “Unu je abaaru Nchileke unu ẹja! Ọlobu; ?bụ ndu ole; ẹphe lẹ ndu ole e-je?” ");
INSERT INTO iqw_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mósisu asụ: “Ayi l'ụnwegirima ayi; mẹ ndu k'ọgurenya; mẹ ụnwu ayi: ndu k'unwoke; mẹ ndu k'ụnwanyi a-tụkokwa yịru. Ayi atụkokwaphu atụru ayi; mẹ eswi ayi ruta; kẹ l'ayi a-gbaru Ojejoje ayi ajị.” ");
INSERT INTO iqw_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Fero asụ ẹphe: “Tẹ Ojejoje swibukwaaru unu; m'ọ bụru lẹ ya a-ha unu t'unu l'ụnwegirima unu yịru tụgbua. Nta-a b'o doru ẹnya l'ọo iphe, dụ ẹji bẹ unu arị k'ememe. ");
INSERT INTO iqw_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Waawa-o; t'ọ bụru ndu k'unwoke nwẹnkinyi bẹ unu e-gude je abaaru Ojejoje ẹja; keshinu ọphu ọ bụ iphe ono bẹ unu shi ime-teke-wa rọta!” Ya ndono; a chịfu Mósisu yẹle Érọnu l'ifu Fero. ");
INSERT INTO iqw_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ojejoje asụ Mósisu t'ọ machịa ẹka maa l'alị Íjiputu; tẹ igube wụbata l'alị ono bya achịko iphe, futaru l'ẹgu l'alị ono tapyashịkota; mbụ iphe, aka-mini mebyishiphodoru. ");
INSERT INTO iqw_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ya ndono; Mósisu abya eworu mgbọro iya maa l'alị Íjiputu. Ojejoje abya emee; phẹrephere, shi l'ụzo ẹnyanwu-ahata awata ephephe. Phẹrephere ono ephekota l'alị ono: eswe l'ẹnyashi. A lụfutashia l'ụtsu; phẹrephere ono evubatawa igube l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Igube atụko Íjiputu nata; nyịnwukota ẹkemeke ọbule l'alị ono. Ẹtu egbe igube onanu ta adụbua; t'ọ bya l'adụ ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Yọ nyịnwukota alị ono l'ọ ha; gbururu jeye; ẹkemeke ọbule ejihu kẹ kpalungu. Ẹphe abya atụko iphe, phọduru nụ l'aka-mini ono byatsụaru tapyashịkota; mbụ iphemiphe ọbule, rutakpooru iru l'ẹgu; mẹkwaphu akpụru oshi. Ẹkwo oshi; mẹ iphe, a kọru l'ẹgu te nwedu m'ọo nanụ, phọduru nụ l'alị Íjiputu l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Fero etsopyabewaphu kua Mósisu yẹle Érọnu; sụ ẹphe: “Lẹ ya meswewaru Ojejoje, bụ Nchileke; bya emeswekwaaphu unubẹdua. ");
INSERT INTO iqw_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Byiko; gụfuaru iya nvụ k'ugbo lanụ-a; nggu ekfuru nụ Ojejoje, bụ Nchileke unu t'o wofuru iya ẹjo iphe-ẹhuka-a!” ");
INSERT INTO iqw_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mósisu aparu Fero haa; lụfu je ekfuru nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ojejoje abya agbanwee phẹrephere ono; mee ya; yọ bụru eze phẹrephere, ha nshinu, shi l'ụzo ẹnyanwu-arịba bya evuta igube ono l'ọ ha je enwuru ye lẹ Eze Ẹnyimu Uswe. Tọ dụhe m'ọo igube lanụ, phọduru nụ l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ọle Ojejoje kpọ-chilerua Fero obu; k'ọphu bụ l'ẹ to kwedu; haa ndu Ízurẹlu t'ẹphe la. ");
INSERT INTO iqw_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ya ndono; Ojejoje asụ Mósisu t'ọ machịa ẹka maa l'akpamigwe; t'ọchi gbaa l'ẹkemeke ọbule l'alị Íjiputu. Ọchi, e-me tẹ ẹkemeke ọbule gbahụ tsụkiribangu. ");
INSERT INTO iqw_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mósisu abya amachịa ẹka maa l'akpamigwe. Alị Íjiputu mgburumgburu abụru tsịrikiti; nọ abalị ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tọ dụ onye phụru ibe iya; t'o nwe onye phụru ụzo; k'ẹ t'o shi l'ẹke o bu lụfu; jeye abalị ẹto eswee. Obenu lẹ ndu Ízurẹlu bẹ iphoro nọ l'ẹke ẹphe bu. ");
INSERT INTO iqw_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ya ndono; Fero ekua Mósisu; sụ iya: “Unu je abaaru Ojejoje ẹja! Unu dutakota ụnwanyi; mẹ ụnwegirima unu t'unu l'ẹphe yịru! Iphe, unu a-ha nwẹnkinyi bụ atụru; mẹ eswi unu.” ");
INSERT INTO iqw_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Obenu lẹ Mósisu sụru iya: “Ịi-hafụkwaaphu ayi t'ayi gude iphe ayi e-gude gwooru Ojejoje, bụ Nchileke ayi ngwẹja-ukfuru; mẹ ngwẹja mmanu ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ọo ya bụ l'ayi e-ruta elu ayi. Ayi ta ahakwa m'ọ bụ eswi lanụ l'ẹke-a; k'ọphu ayi e-shi iya hata ọphu ayi e-gude baaru Ojejoje, bụ Nchileke ayi ẹja. Ọ -bụdu l'ayi jeruru ẹke ono bẹ ayi ta amadụ ndu ọphu ayi e-gude baaru Nchileke ẹja.” ");
INSERT INTO iqw_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ọle Ojejoje kpọ-chilerua Fero obu; k'ọphu ẹ to kwedu haa ndu Ízurẹlu t'ẹphe tụgbua. ");
INSERT INTO iqw_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Fero asụ Mósisu: “Gbeshi iya l'ifu nta-a. T'ẹ b'ọ dụhekwa mbọku, ịi-bya bya evudo iya l'ifu ọdo. Mbọku, ị byaru iya ẹge ono ọdo bẹ aa-chọkwa ngu achọcho!” ");
INSERT INTO iqw_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mósisu asụ iya t'ọ dụ nụ ẹge o kfuru. Lẹ ya ta abyahẹkwa iya ovudo l'ifu ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ya ndono; Ojejoje asụ Mósisu: “Lẹ ya e-gudefua oke iphe-ẹhuka lanụ byakfuta Fero yẹle ndu Íjiputu. E -metsulephu bẹ oo-kwee t'unu shi l'ẹke-a wụfu. O -kwelephu bẹ ọo-chịshikota unu l'unu ha. ");
INSERT INTO iqw_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kfuaru ndu Ízurẹlu; tẹ unwoke ẹphe; mẹ ụnwanyi ẹphe jekfu ndu obutobu ẹphe je arọta ẹphe iphe, e meru lẹ mkpọla-ọcha; mẹ ọphu e meru lẹ mkpọla-ododo.” ");
INSERT INTO iqw_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ojejoje abya emee; ndu Ízurẹlu atụba ndu Íjiputu l'ẹnya; mekwaaphu tẹ ndu ozi Fero; mẹ ndu Íjiputu l'ẹphe ha kwabẹ Mósisu l'onwiya eze ugvu, ha nshinu. ");
INSERT INTO iqw_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tọ dụ iya bụ; Mósisu asụ: “Ọwaa iphe, Ojejoje ekfu: ‘L'ụzo echi-abalị bẹ yẹbe Ojejoje a-tụko alị Íjiputu jekota. ");
INSERT INTO iqw_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Iphe bụ ndu, bụ ọkpara l'alị Íjiputu a-nwụshihukota; shita l'ọkpara Fero, bụ eze; je akpaa l'ọkpara nwanyi, bụ ohu, bụ onye akwọjeru iya iphe; mẹkwaphu elu, bụ iya vuru ụzo waa nne iya ọswa. ");
INSERT INTO iqw_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Oke ụzu-ẹkwa, dụ egvu a-da l'alị Íjiputu gbaa mgburumgburu; mbụ egbe ụzu-ẹkwa, ẹtu iya ẹ-ta dụbua; tọ bụ l'ọo-bya l'adụ ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Obenu l'ẹke ndu Ízurẹlu nọ b'ẹ to nwedu m'ọo nkụta, a-gbọru madzụ; m'ọ bụ anụ ọgbo.’ Teke ono; unu amaru lẹ Ojejoje bẹ kparu ókè l'ẹke ndu Íjiputu; ẹphe lẹ ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Iphe, bụ ndu ozi ngu-a l'ẹphe ha a-wukfuta iya bya ebyiaru iya ikpere; sụ: ‘Tẹ ya tụgbuwaru; yẹle ndu tso iya nụ l'ẹphe ha!’ O -metsulephu ẹge ono; ya atụgbua.” Ya ndono; Mósisu egude ẹhu-eghughu; shi Fero l'ifu lụfu-shia. ");
INSERT INTO iqw_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tọ dụ iya bụ; Ojejoje asụ Mósisu lẹ Fero te ekwekwa angarụ iya nchị; k'ọphu ya e-shikwanu ẹge ono meshia igweligwe iphe-ọphulenya l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mósisu yẹle Érọnu emeshikota Fero iphe-ọphulenya ono l'ifu. Obenu lẹ Ojejoje kpọ-chilerua iya-a obu; to kwe haa ndu Ízurẹlu t'ẹphe shi l'alị iya lashia. ");
INSERT INTO iqw_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ojejoje asụ Mósisu yẹle Érọnu lẹ Íjiputu: ");
INSERT INTO iqw_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ọnwa-a, ayi nọ nta-a a-bụjeru unu ọnwa mbụ l'afa. ");
INSERT INTO iqw_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kfuaru ndu Ízurẹlu l'ẹphe ha l'o -rua mbọku, ọnwa-a a-gba abalị iri; tẹ nwoke, nọnu kpụta nwatụru lanụ doberu yẹle ndibe iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ọ -bụru lẹ ndibe onye ọbu ta hadu l'igwe; k'ọphu bụ lẹ nwatụru ọphu kariru ẹphe ẹka; ẹphe ejekfu ndu katsụa ẹphe obunyabe ntse t'ẹphe l'ẹphe gbaru mgba lẹ nwatụru lanụ; mẹ ẹphe gụ-gee onwẹphe ọgu; maru ole, ẹphe dụ. Unu lee ẹnya; maru l'ẹge onyemonye a-dụ ike taa. ");
INSERT INTO iqw_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Anụ, unu a-fọta a-bụru anụ, gbarụ afa; bụru okee ya; bya abụru ọphu ẹ te nwedu ntụpo. Unu -eshidu l'atụru; unu eshi lẹ nnebyi eghu fọta iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Unu leta iya ẹnya gbururu jeye mbọku, ọnwa-a a-gba abalị iri l'ẹno. Ọ bụ mbọku ono bẹ iphe, bụ ndu nọnu lẹ Ízurẹlu e-gbushikota nk'ẹphe l'ụzo-ẹnyashi iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ẹphe aharu mee ya nata; tee lẹ mgboro oshi-ibo; mẹ l'eli oshi-ibo, nọkota l'ụlo, ẹphe nọ ata anụ nwatụru ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ẹnyashi ono bẹ ẹphe a-hụ anụ nwatụru ono ahụhu taa yẹle ẹkwo oshi, atsọ ile; mẹ buredi, ẹ te yedu iphe, ekoje buredi. ");
INSERT INTO iqw_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Unu be eshikwa anụ ono eshishi; ọphu unu atakwa iya l'onyingu. Ọ bụlephu t'unu hụshia ya l'ọku; mbụ ishi iya; mẹ ọkpa iya; mẹkpo iphe-ẹpho iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","T'ẹ b'o nwekwa ọphu unu a-ha t'ọ bọo nchi. Ọ -bụru l'o nweru ọphu a haru; yọ nọo lụfuta l'ụtsu; unu kpọkwaa ya ọku. ");
INSERT INTO iqw_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ọwaa ẹge unu e-gude taa ya ndọ-ọ: Unu gude akpọ tubuta uwe unu; unu eyee akpọkpa unu l'ọkpa; paru mgbọro unu l'ẹka. Unu ataa ya wobuwobuwobu; kẹ l'ọ bụ Ajị Esweta kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ẹnyashi ono kwaphu; bẹ ya e-jekota l'alị Íjiputu; gbushikota iphe bụ ọkpara; lẹ madzụ mẹ l'elu. Iphe, bụ agwa ndu Íjiputu l'ọ ha; bẹ a-nụ chịkikfuu. Ọ bụ yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mee ono a-bụru iphe-ọhubama, e-koshije ụlo ọphu unu nọ; k'ọphu bụ; ya -phụlephu mee ono; ya esweta unu. Ẹ to nwedu ẹjo iphe-ememe, e-ru unu l'ẹhu teke ono, ya a-nọdu egbushi ndu Íjiputu ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Mbọku ono a-bụru unu mbọku eswe-iphe, unu e-gudeje nyata iphe-a; tsube l'ọgbo rua l'ọgbo bẹ unu a-gbajẹ iya; yọ bụru ajị kẹ Ojejoje. Ekemu ono a-nọdu gbururu jeye lẹ gbururu. ");
INSERT INTO iqw_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Abalị ẹsaa bẹ unu a-ta buredi, ẹ te yedu iphe, ekoje buredi. Mbọku kẹ mbụ bẹ unu e-wofukota iphe, ekoje buredi l'ụlo unu. Kẹ l'iphe bụ onye taru iphe, e yeru iphe, ekoje buredi shita lẹ mbọku mbụ ono jeye lẹ mbọku k'ẹsaa ono bẹ ee-bufu lẹ Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Mbọku kẹ mbụ bẹ unu e-nweru ndzuko, dụ nsọ; bya enwekwaruphu ọdo mbọku k'ẹsaa. T'ẹ b'ọ dụkwa iphe, unu e-je ujiku labụ ono; gbahalẹphu nri, unu e-ri bẹ unu e-shije. Yọ bụru iphe, unu e-meje ndono nwẹnkinyi. ");
INSERT INTO iqw_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Unu gbaje Ajị Buredi, ẹ te kodu ekoko; kẹle ọ bụ mbọku ono gẹdegede bẹ ya dufutaru unu l'unu ha l'alị Íjiputu. Unu dobe mbọku ono; t'ọ bụru mbọku, unu a-gbajẹ ajị; t'ọ bụru ekemu unu e-dobe shita l'ọgbo rua l'ọgbo. ");
INSERT INTO iqw_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","L'ọnwa mbụ phụ bẹ unu a-tajẹ buredi, ẹ te yedu iphe, ekoje buredi; shita l'urẹnyashi mbọku, ọnwa ono gbaru abalị iri l'ẹno jeye l'urẹnyashi mbọku, ọ gbaru ụkporo abalị l'abalị lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Abalị ẹsaa b'ẹ ta aphụdu iphe, ekoje buredi l'ụlo unu. Onye rikpooru iphe, e yeru iphe ekoje buredi bẹ ee-bufu lẹ ndu Ízurẹlu; mẹ onye ono: ọ bụ mbyamụmbya; m'ọ bu onye a mụru l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","T'ẹ b'o nwekwa iphe, e yeru iphe, ekoje buredi, unu e-de ọnu. Ẹke unu bu; ẹke unu bu; unu taa buredi, ẹ te kodu ekoko!” ");
INSERT INTO iqw_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tọ dụ iya bụ; Mósisu abya ekua ndu, bụ ọgurenya Ízurẹlu l'ẹphe ha; sụ ẹphe: “Unu tụgbua nta-a nta-a je afọta anụ ọphu unu lẹ ndibe unu e-gbu gude gbaa Ajị Esweta nk'unu. ");
INSERT INTO iqw_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Unu ewota ẹkwo isopu, dụ jịkfujikfu tsẹe lẹ mee anụ phụ, a nakọberu l'eze-efere phụ tee l'eli oshi-ibo ono; mẹ mgboro iya ẹphe ẹbo. T'ẹ b'o nwekwa l'unu ha; onye a-lụfu etezi jeye l'ụtsu; ");
INSERT INTO iqw_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","k'ọphu bụ; teke Ojejoje a-nọdu eswe; eje ogbushi ndu Íjiputu; ọ -phụwa mee, e teru l'eli oshi-ibo; mẹ mgboro iya; yo sweta ibo onanu. Ẹ too kwedu tẹ mgbugbu-madzụ ono bata l'ụlo unu bya unu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Unu mejekwa iphe-a t'ọ bụru nsọ, a-dụru unu l'eri unu gbururu jeye lẹ gbururu. ");
INSERT INTO iqw_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Unu -bahụlephu l'alị ono, Ojejoje a-nụ unu ono; bụ iya bụ iphe ono, o kweru ụkwa iya ono; unu mejekwa ome-l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ọ -bụru l'ụnwu unu jịru unu; sụ: ‘?Bụ ngụnu bẹ ome-l'alị ono bụ l'ẹke unu nọ?’ ");
INSERT INTO iqw_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Unu sụ ẹphe: ‘L'ọ bụ ngwẹja ogbu anụ Ajị Esweta, aachịru Ojejoje, bụ onye swetaru ụlo ndu Ízurẹlu l'alị Íjiputu je egbushia ndu Íjiputu; t'o nwe ndibe ayi, o gburu.’ ” Ndu Ízurẹlu anụlephu iphe ono; fozita ishi; baaru Ojejoje ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ndu Ízurẹlu abya emee iphe ono ẹge Ojejoje tọru Mósisu yẹle Érọnu ọkpa iya; yọ bụru ẹge ono bẹ ẹphe meru iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Yo rua l'echi-abalị; Ojejoje abya egbushikota ọkpara ndu Íjiputu l'ẹphe ha; shita l'ọkpara Fero, bụ onye nọ l'aba-eze; jeye l'ọkpara onye mkpọro, a tụ-chiru l'ọka-mkpọro; mẹkwaphu iphe, waru elu ẹphe ọswa. ");
INSERT INTO iqw_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Fero yẹle ndu ozi iya; mẹ ndu Íjiputu l'ẹphe ha etehu l'ẹnyashi; ụzu-ẹkwa adawa l'alị Íjiputu gbaa mgburumgburu; kẹ l'ẹ to nwedu ufu, nọ l'alị ono m'ọ nanụ; madzụ ta nwụhudu. ");
INSERT INTO iqw_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Fero abya ekua Mósisu yẹle Érọnu l'ẹnyashi ono; sụ ẹphe: “Unu gbeshi; tụgbua; unu lẹ ndu Ízurẹlu. Unu haa ndu alị iya; tụgbua je abaaru Ojejoje ẹja, bụ iphe, unu shi keshinu ono rọta. ");
INSERT INTO iqw_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Unu ruta atụru unu; mẹ eswi unu; bụ iya bụ iphe, unu shi ekfu gude tụgbua. Ọlobu; unu gọkwaaru iya ọnu-ọma.” ");
INSERT INTO iqw_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ndu Íjiputu l'achịshi ndu Ízurẹlu ọku t'ẹphe mee ẹgwegwa lụfu l'alị ẹke ono; kẹ l'ẹphe sụru l'ọdumeka bẹ ẹphebe ndu Íjiputu a-gwụkwa. ");
INSERT INTO iqw_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ndu Ízurẹlu ekpota iphe, eegudeje eghe buredi kpojia ochi buredi; gude uwe ẹphe kechia ya; paru iya l'ukuvu; ọphu ẹphe eyedu iya iphe, ekoje buredi. ");
INSERT INTO iqw_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ndu Ízurẹlu emee ẹge Mósisu ziru ẹphe; bya arọkoo ndu Íjiputu iphe, e meru lẹ mkpọla-ọcha; mẹ kẹ mkpọla-ododo; mẹ uwe. ");
INSERT INTO iqw_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ojejoje emee; ndu Ízurẹlu atụba ndu Íjiputu l'obu; ndu Íjiputu anụkota ẹphe iphe, ẹphe rọru ẹphe. Ẹphe eshi ẹge ono gwoo iphe ndu Íjiputu; lashia. ");
INSERT INTO iqw_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ndu Ízurẹlu eshi lẹ Ramesẹsu jeshia Súkọtu. Unwoke ndu ọphu gude ọkpa eje rukwaru ụkporo ụnu madzụ ụkporo ẹto l'ụkporo ụnu madzụ iri l'ise; a gụfukwa ụnwanyi; mẹ ụnwegirima. ");
INSERT INTO iqw_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ndu ọdo dụkwaphu l'igwe tsoru ẹphe; wakwaphu ikpotima elu; mbụ atụru; mẹ eswi. ");
INSERT INTO iqw_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Iphe, eegheje buredi, ẹphe shi l'alị Íjiputu gude bẹ ẹphe gude ghee akara, ẹ te yedu iphe, ekoje buredi. Iphe meru iphe; iphe, ekoje buredi ta nọdu iya bụ l'a chịfuru ẹphe achịfu l'alị Íjiputu; ụzo ta dụhe ẹphe k'ọkwakobe nri, ẹphe e-ri. ");
INSERT INTO iqw_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Iphe, ndu Ízurẹlu nọru lẹ Íjiputu bụ ụnu afa l'ụkporo afa l'afa iri. ");
INSERT INTO iqw_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Yo rulephu mbọku, ụnu afa l'ụkporo afa l'afa iri ono gvụru gẹdegede; ndibe Ojejoje l'ẹphe ha, bụ iya bụ ndu Ízurẹlu; awụfukota l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Keshinu ọphu Ojejoje mụru ẹnya l'ẹnyashi ono ẹge oo-me dufuta ẹphe lẹ Íjiputu bẹ ẹphebe ndu Ízurẹlu l'ẹphe ha a-mụjekwaruphu Ojejoje ẹnya ẹge ono l'ẹnyashi ono; gude kwabẹ iya ugvu; tsube l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ojejoje asụ Mósisu yẹle Érọnu: “Ọwaa ẹge unu e-meje kẹ ọgba Ajị Esweta ndọ-ọ: “T'ẹ b'o nwekwa onye mbyamụmbya, e-tsoru ria iphe ajị ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ohu, unu gbataru agbata bẹ unu e-bujeodu útsù; tẹmanu yọ taa ya. ");
INSERT INTO iqw_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ọle tẹ onye, byaru abyabya; m'ọ bụ onye e butaru ebuta ba atakwa iya. ");
INSERT INTO iqw_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Aa-nọduje l'ụlo lanụ taa ya. T'ẹ b'o nwekwa anụ ọbu; ọphu unu ee-gude lụfuta etezi. Ọphu ọ dụkwa ọkpu iya m'ọo nanụ, unu e-jikwo ejikwo. ");
INSERT INTO iqw_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ndu Ízurẹlu a-tụkoje l'ẹphe ha gbaa Ajị Esweta ono. ");
INSERT INTO iqw_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Onye laru alala, unu ẹya bu, chọru tẹ ya gbaa Ajị Esweta kẹ Ojejoje bẹ e-bushikota ndibe iya ndu kẹ unwoke útsù l'ẹphe ha; tẹmanu yo tsoru gbaa ajị l'ọ bụ onye a mụru l'alị ono. T'ẹ b'ọ dụkwa nwoke, bụ onye akpapyị, a-ta iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ọo ekemu lanụ ono, dụru onye a mụru amụmu l'alị-a; dụkwaruphu onye laru alala; unu ẹya atụko buru.” ");
INSERT INTO iqw_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ndu Ízurẹlu l'ẹphe ha abya atụko iphe, Ojejoje kfuru Mósisu yẹle Érọnu mekota. ");
INSERT INTO iqw_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Yọ bụru mbọku ono gẹdegede bẹ Ojejoje dufutaru ndu Ízurẹlu l'ẹphe ha l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Unu doberu iya ọkpara unu iche. Iphe mbụ, vu ụzo waa nne iya ọswa lẹ Ízurẹlu; m'ọ -bụ madzụ; m'ọ -bụ elu; bụ kẹ yẹbe Nchileke.” ");
INSERT INTO iqw_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ya ndono; Mósisu asụ ndu Ízurẹlu: “Unu nyata ntanụ-a; mbụ mbọku, unu wụfuru lẹ Íjiputu, bụ ẹke unu shi bụru ohu. Ntanụ-a bụ mbọku, Ojejoje gude ẹka-ike dufuta unu. T'ẹ b'ọ dụkwa onye a-ta iphe, e yeru iphe, ekoje buredi. ");
INSERT INTO iqw_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ọ bụ ntanụ-a l'ime ọnwa Abibu-a bẹ unu atụgbu. ");
INSERT INTO iqw_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Teke Ojejoje duruleruphu unu l'alị ndu Kénanu; mẹ kẹ ndu Hetu; mẹ kẹ ndu Amọru; mẹ kẹ ndu Hevu; mẹ kẹ ndu Jebusu; mbụ ẹgiri alị ono, o riburu nna unu oche phẹ angụ lẹ ya a-nụ unu ono; unu dobejekwa nsọ-wa l'ọnwa-a. ");
INSERT INTO iqw_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ujiku ẹsaa bẹ unu a-takọta buredi, ẹ te yedu iphe, ekoje buredi. O -rua lẹ mbọku k'ẹsaa; unu agbaaru Ojejoje ajị. ");
INSERT INTO iqw_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unu takọtaje buredi, ẹ te yedu iphe, ekoje buredi l'ime abalị ẹsaa ono. T'ẹ b'o nwekwa iphe, e yeru iphe, ekoje buredi, aa-phụ l'ẹke unu nọ; ọphu ọ dụkwa iphe, ekoje buredi, aa-phụ l'alị unu. ");
INSERT INTO iqw_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mbọku ono bẹ unu a-sụ ụnwu unu l'iphe, kparu iphe, unu gude eme iya bụ iphe, Ojejoje meru unu mbọku, unu lụfutaru l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tẹ ome-l'alị ono bụkwaru iphe-ọhubama, e byiru unu l'ọ bụ mbo l'ẹka; dee ya unu l'ọ bụ uri l'ifu; t'e gude nyatajẹru unu l'ekemu Ojejoje bụ iphe, unu a-kpụjeru l'ọnu; kẹ l'ọ bụ Ojejoje ono bẹ gude ẹka-ike dzọfuta unu l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ọo ya bụ t'unu meje ekemu-a mẹ oge iya rulephu afa l'afa. ");
INSERT INTO iqw_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Ojejoje -durutsulephu unu alị Kénanu ono; bya anụ iya unu ẹge o riburu iya unu lẹ nna unu oche phe lẹ nte; ");
INSERT INTO iqw_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bụkwa t'unu nụje Ojejoje iphe mbụ, vu ụzo waa nne iya ọswa. Anụ mbụ, bụ okee ya, vuru ụzo waa nne iya ọswa l'elu unu a-bụru kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Iphe, bụ nkakfụ-ịgara, bụ iya vu ụzo waa nne iya ọswa bẹ unu e-gudeje nwatụru gbata. Ọ -bụru l'unu ta agbatadu iya; unu aswị-kwoo ya olu aswị-kwo. Iphe, bụ ọkpara unu lẹ nwoke bẹ unu a-gbatajẹkwaphu agbata. ");
INSERT INTO iqw_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“O -rua l'ụzo-ifu; ụnwu unu -jị unu: ‘?Bụ ngụnu bẹ iphe-a bụ?’ Unu asụ ẹphe: ‘Lẹ Ojejoje gude ike-ẹka iya dufuta unu lẹ Íjiputu; mbụ dufuta unu l'ẹke ono, unu shi bụru ohu ono. ");
INSERT INTO iqw_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lẹ teke Fero kpọ-chiru obu; jịka lẹ ya ta ahadu ayi t'ayi la bẹ Ojejoje gbushiru iphe, bụ ọkpara l'alị ndu Íjiputu: madzụ l'elu. Ọ bụ iya meru iphe ayi akpụtaje anụ, bụ okee ya, vuru ụzo waa nne iya ọswa gbuaru Ojejoje; l'egudeje iphe gbata ndu, bụ ọkpara l'ẹpho nne ẹphe lẹ madzụ.’ ");
INSERT INTO iqw_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","T'ome-l'alị ono bụkwaru iphe-ọhubama, e byiru unu l'ọ bụ mbo l'ẹka; dee ya unu l'ọ bụ uri l'ifu; gude koshi lẹ Ojejoje gude ike-ẹka iya dufuta unu l'alị Íjiputu.” ");
INSERT INTO iqw_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Fero ahalẹphu ndu Ízurẹlu; ẹphe atụgbua; Ojejoje te du ẹphe shia ụzo alị ndu Filisutayịnu; e guderu l'ono ka ntse. Kẹle Ojejoje sụru: “?A maru: ọgu -dakfu ẹphe; ẹphe ta agbanwedu nụ obu; lashia azụ lẹ Íjiputu?” ");
INSERT INTO iqw_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tọ dụ iya bụ; Ojejoje eduru ndu Ízurẹlu jee mgburumgburu; shia ụzo echi-ẹgu; tụgbua ụzo Eze Ẹnyimu Uswe. Ndu Ízurẹlu eshi lẹ Íjiputu tụgbua kwakọbe onwẹphe k'ọgu. ");
INSERT INTO iqw_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mósisu abya achịta ọkpu Jósẹfu gude; kẹle Jósẹfu meru ụnwu Ízurẹlu; ẹphe eriaru iya nte. Ọ sụru iya: “Ya maru lẹ Nchileke e-mekochaa bya eyeru unu ẹka. Ọle t'unu chịtakwa ọkpu iya l'ẹke-a teke unu a-nọdu ala.” ");
INSERT INTO iqw_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ẹphe awụfulephu lẹ Súkọtu; je akpọbe ụlo-ẹ́kwà ẹphe lẹ Etamu l'iku echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","O -rua l'eswe; Ojejoje egude urukpu, kpụru rogbodongu edu ẹphe ụzo. O -rua l'ẹnyashi; yo gude ọku, kpụru rogbodongu nụlahaa ẹphe iphoro; k'ọphu ẹphe a-nọduje eje ije: eswe l'ẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Urukpu ono, kpụru rogbodongu, oogudeje edu ẹphe l'eswe; mẹ l'ọku ono, kpụru rogbodongu, oogudeje edu ẹphe l'ẹnyashi ono ta alụfubua ndu Ízurẹlu alụfu l'ifu. ");
INSERT INTO iqw_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kfuaru ndu Ízurẹlu t'ẹphe laphu azụ je akpọbe ụlo-ẹ́kwà ẹphe lẹ mgboro Payi-Hahirotu, nọ lẹ mgbaku Migidọlu. Ẹphe akpọbe ụlo-ẹ́kwà ẹphe ono l'iku eze ẹnyimu; t'o chebe ifu lẹ Bálụ-Zefọnu nhamụnha; ");
INSERT INTO iqw_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","kẹle Fero a-rị lẹ ndu Ízurẹlu bẹ ẹkwo-njị jịru; l'ẹphe kwawaru l'echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ya a-kpọ-chi Fero obu; yọ chịkfuru ẹphe. Obenu l'ee-shi l'iphe, e-me l'ẹhu Fero yẹle ndu sọja iya; kwabẹ yẹbe Ojejoje ugvu; ndu Íjiputu amaru l'ọ bu yẹbedua bụ Ojejoje.” Ndu Ízurẹlu emee ẹge ono, o kfuru ono. ");
INSERT INTO iqw_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","A bya ekfuaru eze ndu Íjiputu lẹ ndu Ízurẹlu gbalaakwaru. Fero yẹle ndu ozi iya agbanwee obu ẹphe l'ẹke ẹphe nọ; sụ: “?Bụ ngụnu bẹ ẹphe meru ẹge-a? ?Ẹphe gbe haa ndu Ízurẹlu t'ẹphe tụgbua; paru ozi, ẹphe eje haa tọo.” ");
INSERT INTO iqw_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tọ dụ iya bụ; Fero asụ t'a kwakọberu iya ụgbo-ịnya iya ọhuma. A kwakọbebetsua ya; yọ chịta ndu sọja yeru onwiya; ");
INSERT INTO iqw_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","chịta ụgbo-ịnya, katsụa mma l'ụgbo-ịnya iya; ụnu ụgbo-ịnya ụkporo l'iri; mẹwaru ụgbo-ịnya ndu Íjiputu l'ọ ha. Yọ bya achịru ndu ishi sọja yegbaa l'ụgbo-ịnya ono. ");
INSERT INTO iqw_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ojejoje akpọ-chia obu Fero, bụ eze ndu Íjiputu; yọ chịpyabe ndu Ízurẹlu l'ẹke ẹphe adzọ garamu garamu; awụfu. ");
INSERT INTO iqw_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ịnya Fero l'ọ ha; mẹ ndu agba iya nụ; mẹ ụgbo-ịnya iya; mẹ igweligwe ndu sọja iya; mbụ ndu Íjiputu l'ẹphe ha achịpyabe ndu Ízurẹlu bya agbakfu ẹphe l'ẹke ẹphe kpọberu ụlo-ẹ́kwà ẹphe l'iku eze ẹnyimu; lẹ mgboro Payi-hahirotu, cheru ifu lẹ Bálụ-Zefọnu nhamụnha. ");
INSERT INTO iqw_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Fero abyarutadelephu ntse; ndu Ízurẹlu apalia; yọ bụwaru ndu Íjiputu etso ẹphe. Egvu abya ẹphe l'ẹhu; ẹphe araku Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ẹphe asụ Mósisu: “?Bụ l'ili ta nọdu l'alị Íjiputu meru iphe i dufutaru ẹphe t'ẹphe bya anwụshihu l'echi-ẹgu? ?Bụnua ngụnu meru; nggu edufuta ẹphe l'alị Íjiputu? ");
INSERT INTO iqw_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","?Ẹphe te kfuduru ngu l'alị Íjiputu t'ị paru ẹphe haa; t'ẹphe jejeru ndu Íjiputu ozi? ?T'ọ ga akadụru ẹphe mma l'ẹphe ejeru ndu Íjiputu ozi; ma l'ẹphe nwụshihuru l'echi-ẹgu?” ");
INSERT INTO iqw_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mósisu asụ ẹphe: “Unu ba atsụshi egvu! Unu vudo vudoshia ike; phụ iphe, Ojejoje e-me gude dzọfuta unu ntanụ. Ndu Íjiputu-a, unu ele ẹnya ntanụ-a bẹ unu ta aphụhekwa ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Unu nọdu nggujingguji; lẹ Ojejoje a-lụru-a unu ọgu!” ");
INSERT INTO iqw_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “?Ngụnu meru iphe ịiraru iya ẹkwa? Kfuru ndu Ízurẹlu t'ẹphe tụgbua jeshia iphe, ẹphe eje. ");
INSERT INTO iqw_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Wolia mgbọro ngu; maa l'eze ẹnyimu ono t'o kekahu mini ono ẹbo; k'ọphu ndu Ízurẹlu e-gude ọkpa ẹphe jee ije l'alị ọkponku l'ẹnyimu ono; wụ-sweta. ");
INSERT INTO iqw_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ya a-kpọ-chi ndu Íjiputu obu; k'ọphu ẹphe e-tsopyabe ẹphe. E shi l'iphe, a-mụru Fero yẹle ndu sọja iya; mẹ ụgbo-ịnya iya; mẹ ndu agbaru iya ịnya; kwabẹ yẹbe Ojejoje ugvu. ");
INSERT INTO iqw_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ọo ya bụ; ndu Íjiputu eshi ẹge ono maru l'ọo ya bụ Ojejoje; mbụ teke ẹphe e-shi l'iphe, a-mụru Fero yẹle ndu sọja iya; mẹ ụgbo-ịnya iya; mẹ ndu agbaru iya ịnya; kwabẹ yẹbe Ojejoje ugvu.” ");
INSERT INTO iqw_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ya ndono; Ojozi Nchileke phụ, shi nọdu ndu Ízurẹlu l'ifu phụ abya esweta ẹphe; je etsoru ẹphe l'azụ. Urukpu phụ, kpụru rogbodongu phụ abya eshikwaphu l'ụzo ifu; je anọdu ẹphe l'azụ; ");
INSERT INTO iqw_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","je anọkahu ndu sọjandu Íjiputu; mẹ ndu Ízurẹlu. L'ẹnyashi ono mgburumgburu bẹ urukpu ono gbakọtaru ọchi l'ẹke lanụ; l'acha ọku l'ẹka iya ọphu. Iphe ono emee; k'ọphu ẹ tọ dụdu ndu ọphu jekfuberu ibe ẹphe ntse l'ẹnyashi ono phuu. ");
INSERT INTO iqw_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tọ dụ iya bụ; Mósisu abya amachia ẹka iya l'eli eze ẹnyimu ono. Ẹnyashi ono l'ọ ha bẹ Ojejoje gude oke phẹrephere, shi l'ụzo ẹnyanwu-ahata ziphu eze ẹnyimu ono azụ; yọ bya aghọo alị ọkponku. Mini ono ekekahu ẹbo. ");
INSERT INTO iqw_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ndu Ízurẹlu abya abahụ l'eze ẹnyimu ono; gude ọkpa jee l'alị ọkponku jeye ẹphe eswegee. Mini eze ẹnyimu ono akpụa l'ọ bụ ụpho-mkpuma; nọdu ẹphe l'ẹka-ụtara; mẹ l'ẹka-ibyita teke ẹphe eswe. ");
INSERT INTO iqw_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ndu Íjiputu achịpyabe ẹphe. Ịnya Fero; mẹ ụgbo-ịnya iya; mẹ ndu agbaru iya ịnya; atụko tsoru ẹphe wụba l'ime eze ẹnyimu ono. ");
INSERT INTO iqw_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yo rua l'ụzo nchi-abọhu; Ojejoje eshi l'ọku; mẹ l'urukpu ono, kpụru rogbodongu ono; lee ndu sọja ndu Íjiputu ẹnya; mee ẹphe; ẹphe aghahụ phuringu. ");
INSERT INTO iqw_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yo mee; ọkpa ụgbo-ịnya ẹphe ono awata ọgba mgburumgburu; k'ọphu agbagba iya tsụlahaaru ẹphe l'ẹhu. Ndu Íjiputu asụ: “T'ẹphe hakwaa ndu-a; laphu azụ; kẹ l'ọ kwa Ojejoje etso ẹphebe ndu Íjiputu ọgu l'okfu ẹhu ndu Ízurẹlu!” ");
INSERT INTO iqw_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tọ dụ iya bụ; Ojejoje asụ Mósisu t'ọ machịa ẹka; maa l'eze ẹnyimu ono; tẹ mini ono bya atsọ-kputa ndu Íjiputu; mẹ ụgbo-ịnya ẹphe; mẹ ndu agbaru iya ịnya. ");
INSERT INTO iqw_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mósisu abya amachịa ẹka; maa l'eze ẹnyimu ono. Yo rua l'ụtsu; mini ono atsọlahaa ẹge o shi atsọhawa. Ndu Íjiputu agbalahaa t'ẹphe gbafụ lẹ mini ono; Ojejoje azaru ẹphe ye l'eze ẹnyimu ono. ");
INSERT INTO iqw_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mini ono abya atsọgbabe; rikota ụgbo-ịnya ono yẹle ndu agbaru iya ịnya. Ndu sọja Fero, chịpyaberu ndu Ízurẹlu; chịa ẹphe jeye l'eze ẹnyimu ono te nwedu m'ọo onye lanụ, wafụru nụ. ");
INSERT INTO iqw_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Obenu lẹ ndu Ízurẹlu jeru ije l'alị ọkponku sweta eze ẹnyimu ono. Mini eze ẹnyimu ono akpụa l'ọ bụ ụpho-mkpuma; vudo ẹphe l'ẹka-ụtara; mẹ l'ẹka-ibyita. ");
INSERT INTO iqw_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mbọku ono bẹ Ojejoje dzọfutaru ndu Ízurẹlu l'ẹka ndu Íjiputu. Ndu Ízurẹlu aphụa ndu Íjiputu l'ẹke ẹphe nwụshihuru; dabutsuaru lẹ mgbogidi ẹnyimu. ");
INSERT INTO iqw_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ndu Ízurẹlu aphụa egbe ike, Ojejoje gude mekputa ndu Íjiputu; tsụlahaa Ojejoje egvu; bya ekweta nk'iya; mẹ kẹ nwozi iya, bụ Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ya ndono; Mósisu; mẹ ndu Ízurẹlu agụa egvu-a nụ Ojejoje; sụ: Ya a-gụ egvu nụ Ojejoje; kẹ l'o koshiwaru l'ọ ha nshinu. Ịnya; mẹ ndu agba iya nụ; b'o nwuru ye l'eze ẹnyimu. ");
INSERT INTO iqw_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ọ bụ Ojejoje bụ agburu-ẹhu mu; bụru onye mu agụ-ku l'egvu. Ọ bụ iya bụ onye dzọfutaru mu nụ. Ọ bụ iya bụ Nchileke mu; mu a-jajẹ iya ajaja. Ọ bụ iya bụ Nchileke nna mu; mu a-nọdu apali ẹpha iya eli. ");
INSERT INTO iqw_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ojejoje bụ sọja. Ọo Ojejoje bụ ẹpha iya. ");
INSERT INTO iqw_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ụgbo-ịnya Fero yẹle ndu sọja iya; b'o nwuru ye l'eze ẹnyimu. Ndu, katsụa mma lẹ ndu ishi ụgbo-ịnya Fero; bẹ mini rigbushiru lẹ Eze Ẹnyimu Uswe. ");
INSERT INTO iqw_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ebo mini riru ẹphe; ẹphe abụru tụbukungu l'ọhu-mini l'ọ bụ mkpuma. ");
INSERT INTO iqw_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ẹka-ụtara ngu nggụbe Ojejoje; bẹ agburu-ẹhu, nọ iya nụ dụ biribiri. Ẹka-ụtara nggụbe Ojejoje; bẹ gweru ndu ọhogu ngu ogwe uji. ");
INSERT INTO iqw_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I gude ọdu-biribiri ngu, ha nshinu kwatsushia ndu wụ-lihuru nụ; tso ngu okfu. Nggu ahaa oke ẹhu-eghughu ngu, enwu l'ọ bụ ọku; yọ bya etsua ẹphe l'ọ bụ ẹswa ọkponku. ");
INSERT INTO iqw_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ọ bụ ume b'i ziru; eze ẹnyimu akọo ogiji. Utso ono akfụru l'ọ bụ ụpho-mkpuma. Ebo mini ahụkoo l'ọhu eze ẹnyimu. ");
INSERT INTO iqw_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ndu ọhogu saru nsasa; sụ: “L'ẹphe a-chị ayi; gude ayi. L'ẹphe e-ke iphe ayi; gude ayi mee ẹge dụ ẹphe mma. Ẹphe a-mị ogu-mbeke ẹphe gude gbushia ayi.” ");
INSERT INTO iqw_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Obenu l'ị tụru ume; eze ẹnyimu atụko ẹphe rigbushia. Ẹphe abụru tụbukungu l'eze ẹnyimu l'ọ bụ ọta-njele. ");
INSERT INTO iqw_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","?Nanu agwa, atụru nggụbe Ojejoje? “?Bụ onye dụ l'ọ bụ nggu? Ẹge ị dụ-be nsọ dụ biribiri. Ẹge ị dụ-be akpabiri adụ egvu. Iimeje iphe, dụ biribiri. ");
INSERT INTO iqw_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ẹka-ụtara ngu b'ị machịru; mgboko abya atụko ndu ọhogu ayi lee. ");
INSERT INTO iqw_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Ndu ị gbafutaru; bẹ ii-gude n-yemobu ngu; dua. Yọ bụru l'ẹke ono, i bu, dụ nsọ ono; bẹ ii-gude agburu-ẹhu ngu durua ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Iphe bụ mbakeshi, nụru iya nụ; bẹ egvu e-ru l'ẹhu. Egvu e-gude ndu Filísutiya. ");
INSERT INTO iqw_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ndu achị ndu Édọmu; bẹ meji a-tọfu. Ẹhu anmaa ndu ishi Móabu anmanma. Ndu Kénanu erushihu. ");
INSERT INTO iqw_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ọtsu egvu; mẹ ẹhu-anmanma e-gude ẹphe. Yọ bụru agburu-ẹhu, nọ ngu l'ẹka-ụtara; bẹ ii-gude mee t'ẹphe dabutsuaru l'ọ bụ mkpuma; gbururu jeye teke ndu kẹ nggụbe Ojejoje a-wụ-sweta; mbụ ndu ono, ị gbafụtaru l'ohu, ẹphe shi bụru ono. ");
INSERT INTO iqw_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ii-dubata ẹphe; bya eye ẹphe l'ugvu nke ngu; mbụ ẹke nggụbe Ojejoje fọtaru t'ọ bụru ufu ngu; mbụ ụlo, dụ nsọ ọphu i gude ẹka ngu kpụa. ");
INSERT INTO iqw_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ọ bụ nggụbe Ojejoje a-bụru eze gburu jeye lẹ gbururu.” ");
INSERT INTO iqw_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Teke ịnya Fero; mẹ ụgbo-ịnya iya; mẹ ndu agbaru iya ịnya bahụru l'eze ẹnyimu ono bẹ Ojejoje vutaru mini ono byabẹ ẹphe. Obenu lẹ ndu Ízurẹlu jeru ije l'alị ọkponku sweta eze ẹnyimu ono. ");
INSERT INTO iqw_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ya ndono; Miriyamu, bụ nwanyi, ekfuchiru Nchileke, bụ nwunne Érọnu abya ewota nkwa; ụnwanyi l'ẹphe ha awụ-tsoru iya; l'akụ nkwa; l'ete iya etete. ");
INSERT INTO iqw_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyamu l'agụru ẹphe egvu ono; l'asụje: “Unu gụa egvu nụ Ojejoje; kẹ l'o koshiwaru l'ọ ha nshinu. Ịnya yẹle ndu agba iya nụ b'o nwuru ye l'echi eze ẹnyimu.” ");
INSERT INTO iqw_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Tọ dụ iya bụ; Mósisu eshi lẹ Eze Ẹnyimu Uswe dua ndu Ízurẹlu; bahụ l'echi-ẹgu Shu. Ẹphe ejee ije abalị ẹto l'echi-ẹgu; ẹphe ta phụ mini. ");
INSERT INTO iqw_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ẹphe erua Mára; ẹphe ta dụ ike ngụa mini iya; kẹle mini ono atsọ ile. Ọ bụ iya kparu iphe, a gụru ẹke ono Mára. ");
INSERT INTO iqw_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ẹphe agụlaaharu Mósisu aphụ; sụ iya: “?Bụ ngụnu bẹ ẹphe a-ngụ?” ");
INSERT INTO iqw_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ya ndono; Mósisu araku Ojejoje. Ojejoje abya ekoshi iya mkpirikpi oshi. Yo wota iya chee lẹ mini ono. Mini ono atsọlahaa ụtso-mini. Ọ kwa l'ẹke ono bẹ Ojejoje tụru ekemu nụ ẹphe; bya atọoru ẹphe ọkpa iya. Yọ bụkwaruphu l'ẹke ono b'ọ nọdu data ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ojejoje asụ ẹphe: “Ọ -bụru l'unu ngabẹru nchị l'okfu yẹbe Ojejoje, bụ Nchileke unu; l'eme iphe, vudo nhamụnha l'ẹnya iya; ọ -bụru l'unu anga nchị l'iphe, ya sụru t'unu meje; l'etso iphe, ya tọru ọkpa sụ t'unu tsoje; b'ẹ tọ dụkwa ẹjo iphe-ememe ono, ya gude byakfuta ndu Íjiputu ono, ya egude abyakfuta unu; kẹ l'ọ bụ yẹbedua bụ Ojejoje: onye emeje unu t'unu ka mma l'iphe eme unu.” ");
INSERT INTO iqw_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","E metsua; ẹphe abya ejerua Élimu; ẹke ọgba-mini iri l'ẹbo nọ; ụkporo nkfụ ẹto lẹ nkfụ iri anọdu iya. Ẹphe abya akpọbe ụlo-ẹ́kwà ẹphe lẹ mgboro mini ono. ");
INSERT INTO iqw_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ndu Ízurẹlu l'ẹphe ha awụfu lẹ Élimu; bya erua echi-ẹgu Sinu, nọ lẹ mgbaku Élimu yẹle Ugvu Sáyịnayi lẹ mbọku, ọnwa k'ẹbo gbaru abalị iri l'ise l'ẹphe shitsulephu l'alị Íjiputu lụfuta. ");
INSERT INTO iqw_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ẹphe l'ẹphe ha agụlahaaru Mósisu yẹle Érọnu aphụ l'echi-ẹgu ono; ");
INSERT INTO iqw_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","sụ ẹphe: “Ndẹge Ojejoje gude ẹka iya gbushia ẹphe l'alị Íjiputu; mẹ ẹhu akakwa ẹphe mma! Ẹke ono bẹ ẹphe anọ-pheje ite-anụ mgburumgburu; l'eriji ẹpho. Obenu l'unu chịfutaru ẹphe bya edobe l'echi-ẹgu l'ẹke-a t'unu kpọ-gbushia ẹphebe igwe ọha-a l'ẹgu.” ");
INSERT INTO iqw_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ojejoje asụ Mósisu: “Ya e-shi l'imigwe chịaru unu nri l'ọ bụ mini. Ndu Ízurẹlu a-lụfutaje mbọku-mbọku bya ekpota ọphu e-dzuru ẹphe eriri kẹ mbọku ono. Ya e-shi ẹge ono data ẹphe; maru: ?mẹ ẹphe e-kweta-a meje iphe, ya tụru ẹphe l'ekemu. ");
INSERT INTO iqw_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","O -rua mbọku k'ishingu; ẹphe eshia ọphu ẹphe kpotaru. Mbọku ono bẹ ẹphe e-kpota iya t'ọ ha l'ọ bụ ọphu ẹphe ekpotajehawa mbọku ọdo ugbo labụ.” ");
INSERT INTO iqw_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tọ dụ iya bụ; Mósisu yẹle Érọnu asụ ndu Ízurẹlu l'ẹphe ha: “L'urẹnyashi-a bẹ unu a-phụ l'ọ bụ Ojejoje bụ onye dufutaru unu l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","O -rua l'ụtsu bẹ unu a-phụ ọdu-biribiri Ojejoje; kẹ l'ọ nụwaru aphụ, unu agụ ekpu iya. ?Bụ onye bẹ ẹphebedua bụ; ọphu unu a-nọdu agụru ẹphe aphụ?” ");
INSERT INTO iqw_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mósisu asụkwaphu: “Unu a-maru l'ọ bụ Ojejoje l'oswiya teke ọo-nụ unu anụ, unu a-ta l'urẹnyashi-a; nụ unu nri, e-dzu unu eriri l'ụtsu; kẹ l'ọ nụwaru aphụ, unu gụru kpua ya. ?Bụ onye bẹ ẹphe bụ? Ẹ tọ kwa ẹphebedua bẹ unu agụru aphụ; ọ kwa Ojejoje bẹ unu agụru iya!” ");
INSERT INTO iqw_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mósisu asụ Érọnu: “Kfuru ndu Ízurẹlu l'ẹphe ha t'ẹphe tụko bya Ojejoje l'ifu; kẹ l'ọ nụwaru kẹ aphụ, ẹphe agụ.” ");
INSERT INTO iqw_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Érọnu ekfukwadua eyeru ndu Ízurẹlu l'ẹphe ha; ẹphe aghaa ẹnya l'echi-ẹgu; phụ ọdu-biribiri Ojejoje l'ẹke ọ charu phoo l'urukpu ono, kpụru rogbodongu ono. ");
INSERT INTO iqw_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Lẹ ya nụwaru aphụ, ndu Ízurẹlu agụ. Kfuru ẹphe l'ẹphe a-ta anụ lẹ nchi-ejihu. O -rua l'ụtsu; e gude nri nụ-jia ẹphe ẹpho; k'ọphu ẹphe a-maru l'ọ bụ yẹbedua bụ Ojejoje, bụ Nchileke ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Yo be l'urẹnyashi ono; ọ̀kwà abya atụko ọdu ndu Ízurẹlu ono dzuru. A lụfuta l'ụtsu; iji adashịwa; dzuru ẹke ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Iji ono akọrohulephu; yo nweru nwa iphe, wụshiru l'alị l'echi-ẹgu ono, dụgbaa yẹriyeri; bya adụ l'ọ bụ iji, oyi meru; yọ nmakọo anmakọ. ");
INSERT INTO iqw_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ndu Ízurẹlu aphụa iphe ono; jịlahaa ibe ẹphe; sụ: “?Bụ ngụnu ndọ-ọ?” Kẹ l'ẹphe te shihadua maru iphe ọbu. Mósisu asụ ẹphe: “Ọo nri, Ojejoje nụru unu t'unu ria. ");
INSERT INTO iqw_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ọwaa ekemu, Ojejoje tụru ndọ-ọ: ‘Onyenọnu e-kpotaje ọphu e-dzuru iya nụ. Ndu, bu l'ụlo-ẹ́kwà unu bẹ unu e-kpotajeru ogbonga lanụ ogbonga lanụ.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ya ndono; ndu Ízurẹlu emee ya ẹge e kfuru ẹphe. O nweru ndu ọphu kpotaru nshinu; nweru ndu ọphu kpotaru nwanshị. ");
INSERT INTO iqw_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E metsua; ẹphe egude ogbonga gbaa ya; onye kpotaru nshinu; te kpoghatadu; ọphu onye kpotaru nwanshị; 'ekpopetakwanu. Onyenọnu kpotaleruphu ọphu dzuru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mósisu asụ ẹphe: “T'ẹ b'o nwekwa onye e-dobe nk'iya t'o rua l'ụtsu.” ");
INSERT INTO iqw_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Obenu l'o nwelerua ndu ọphu ẹ-ta ngabẹduru Mósisu nchị; haphodo nk'ẹphe dobe; yọ nọdu lụfuta l'ụtsu. A lụfutashia l'ụtsu; ẹhonwu ejiwa iya ejiji; yo shikwaphu nshi. Ẹhu eghulahaa Mósisu eghughu lẹ k'iphe ono, ẹphe meru ono. ");
INSERT INTO iqw_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ụtsu mbọku-mbọku; onyenọnu eje ekpota ọphu e-dzuru yẹle ndibe iya eriri. Anwụ chishidelephu ike; ọphu phọduru l'alị azashịhu. ");
INSERT INTO iqw_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Yo rua mbọku kẹ ishingu; ẹphe ekpota ọphu ha l'ọ bụ ọphu ẹphe ekpotaje ugbo labụ; onye lanụ ogbonga labụ. Ndu ishi ndu Ízurẹlu abya ekfuaru iya Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Yọ sụ ẹphe: “Ọwaa ekemu, Ojejoje tụru ndọ-ọ: ‘Echile bụ eswe Sábatu; mbụ mbọku ọtu-ume, dụ nsọ kẹ Ojejoje. Ọo ya bụ; unu ghee iphe, dụ unu kẹ egheghe; shia, iphe dụ unu kẹ eshishi ntanụ. Unu edobe ọphu ghuduru nụ jeye l'ụtsu.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ẹphe ahaa ya; yọ bọo nchi, bụ ẹge Mósisu kfuru ẹphe; too shi nshi; ẹhonwu ta la iya. ");
INSERT INTO iqw_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mósisu asụ ẹphe: “Unu ria ono ntanụ; kẹle ntanụ bụ mbọku ọtu-ume kẹ Ojejoje. Ẹ to nwekwa nri, unu a-phụ l'etezi ntanụ-a. ");
INSERT INTO iqw_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Unu e-kpotaje nri ono abalị ishingu; ọle mbọku k'ẹsaa, bụ mbọku ọtu-ume b'ẹ tọo nọdu.” ");
INSERT INTO iqw_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ọle o nwelerua ndu tụgburu lẹ mbọku k'ẹsaa jeshia okpota nri ono; to nwe ọphu ẹphe phụru. ");
INSERT INTO iqw_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ojejoje asụ Mósisu: “?Bụ teke ole bẹ unu a-jịkabe ome ekemu iya; mẹ l'okfu iya? ");
INSERT INTO iqw_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nyatakwa l'ọo Ojejoje bẹ nụru unu mbọku ọtu-ume. Ọo ya meru iphe ọobuje: o -rua mbọku k'ishingu; yọ nụ unu nri, e-dzuru unu abalị ẹbo. O -rua mbọku k'ẹsaa; tẹ onyenọnu nọdujelephu l'ẹke ọ nọ. T'ẹ b'o nweshi onye a-lụfuje alụfu.” ");
INSERT INTO iqw_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tọ dụ iya bụ; ndu ono atụa ume lẹ mbọku k'ẹsaa ono. ");
INSERT INTO iqw_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ndu Ízurẹlu ekua nri ono mana. Ọocha ụcha l'ọ bụ akpụru koriyanda; l'atsọ l'ọ bụ ẹcha mbeke, e gude manụ-ẹngu mee. ");
INSERT INTO iqw_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mósisu asụ: “Ọwaa iphe, Ojejoje ekfu: ‘Unu kpota ogbonga mana lanụ doberu ọgbo ọphu nọ l'ifu; k'ọphu ẹphe a-phụ nri, ya nụru unu t'unu ria l'echi-ẹgu; teke ya dufutaru unu l'alị Íjiputu.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ya ndono; Mósisu asụ Érọnu: “Wota ite; kporu ogbonga mana lanụ ye iya. Dobe iya Ojejoje l'ifu; t'e doberu iya ọgbo ọphu nọ l'ifu.” ");
INSERT INTO iqw_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Érọnu eworu iya dobe l'ifu Okpoko Ekemu, bụkwanu iya bụ ẹge Ojejoje kfuru iya Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ndu Ízurẹlu eria mana ono ụkporo afa labụ; gbururu jeye ẹphe ejerua alị ẹke e bu ebubu. Mbụ l'ẹphe riru mana gbururu jeye ẹphe erua l'ókè-alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ogbonga lanụ bụ oke lanụ l'ụzo iri l'iphe jiru efere nkwo-ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ndu Ízurẹlu l'ẹphe ha awụ-lihu l'echi-ẹgu Sinu tụgbua; ẹphe -shi l'ibyiya ọwaa; ẹphe abahụ l'ibyiya ọphu; ẹge Ojejoje ziru ẹphe. Ẹphe eje adọo lẹ Réfidimu. Obenu lẹ mini ta nọdu l'ẹke ono, ẹphe a-ngụ. ");
INSERT INTO iqw_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ya ndono; ẹphe abalahaaru Mósisu mba; sụ iya t'ọ nụ ẹphe mini t'ẹphe ngụa. Mósisu asụ ẹphe: “?Bụ ngụnu bẹ unu abaru iya mba? ?Bụ ngụnu kparu iphe unu adata Ojejoje adata?” ");
INSERT INTO iqw_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Obenu lẹ mini wataru ọgu ndu Ízurẹlu; ẹphe agụlahaaru Mósisu aphụ; sụ iya: “?Bụnua ngụnu kparu iphe i dufutaru ayi; ayi l'ụnwu ayi; mẹ elu ayi l'alị Íjiputu bya edobe ayi t'ẹgu mini gbushia ayi?” ");
INSERT INTO iqw_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tọ dụ iya bụ; Mósisu araku Ojejoje; sụ iya: “?Bụ ngụnu bẹ ya e-me ndu-a; kẹ l'ẹphe a-byaakwa iya ọtu mkpuma.” ");
INSERT INTO iqw_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ojejoje asụ Mósisu: “T'o vuta ụzo tẹ ndu Ízurẹlu tsoru iya l'azụ. T'ọ haru ndu bụ ọgurenya Ízurẹlu duta; yo wota mgbọro ono, o chiru lẹ Ẹnyimu Náyịlu ono gude jeshia. ");
INSERT INTO iqw_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ya e-vudo ngu l'ifu lẹ mkpuma Họ́rebu. Teke i ruru ẹke ono; nggu echia mgbọro ono lẹ mkpuma ono. Mini, ndu Ízurẹlu a-ngụ e-shi iya-a gbalahaa.” Mósisu abya emee ẹge ono l'ifu ndu bụ ọgurenya ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yọ bya agụa ẹke ono “Masa;” gụkwaa ya phụ “Meriba;” kẹle ndu Ízurẹlu swọru ụswo; bya adata Ojejoje; sụ: “?Ayi lẹ Ojejoje nọ-ọ; t'ọ bụ ịbagha?” ");
INSERT INTO iqw_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ndu Amalẹku abya etso ndu Ízurẹlu ọgu lẹ Réfidimu. ");
INSERT INTO iqw_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mósisu asụ Jóshuwa: “Haru unwoke ayi fọta t'unu je awọta ndu Amalẹku ọgu. Echile bẹ ya e-gude mgbọro Ojejoje l'ẹka je evudo l'eli ugvu.” ");
INSERT INTO iqw_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tọ dụ iya bụ; Jóshuwa eje awọta ndu Amalẹku ọgu ẹge Mósisu ziru iya. Mósisu; Érọnu; mẹ Huru enyihu eli ugvu; je anọdu l'ọnungonu iya. ");
INSERT INTO iqw_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Yọo bụje; Mósisu chilia ẹka imeli; ndu Ízurẹlu emukputalahaa. Teke ọ chizitaru ẹka; ndu Amalẹku emekputalahaa. ");
INSERT INTO iqw_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","A nọnyaa; ẹka atsụhu Mósisu ụme; ẹphe apata mkpuma; doberu iya; yọ nọdu anọdu. Érọnu; mẹ Huru abya apalia ya ẹka imeli; onye lanụ l'ẹka-ụtara; onye ọphu l'ẹka-ibyita. Ya ndono; ẹka anọdule iya phụ l'imeli ẹge ono gbururu jeye l'ẹnyanwu-arịba. ");
INSERT INTO iqw_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yọ bụru iya bụ lẹ Jóshuwa phẹ emekputa ndu Amalẹku. ");
INSERT INTO iqw_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ya ndono; Ojejoje asụ Mósisu: “Dee iphe-a l'ẹkwo t'ọ bụru iphe, ee-gudeje nyata iya. Nggu emekwaaphu tẹ Jóshuwa maru lẹ ya e-me tẹ ndu Amalẹku chịhu lẹ mgboko; t'ẹ ba nyatajẹhe ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mósisu abya akpụa ẹnya-ngwẹja; gụa ya “Ọ kwa Ojejoje bụ onye emeje tẹ ẹka mu kangoo l'ọgu.” ");
INSERT INTO iqw_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Yọ sụ: “Lẹ ya gụru iya ẹpha ono; kẹle a chị-liru ẹka kfuru nụ Ojejoje l'aba-eze iya. Ojejoje a-nọdulephu etso ndu Amalẹku ọgu; tsube l'ọgbo rua l'ọgbo.” ");
INSERT INTO iqw_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ya ndono; Jeturo, bụ onye agwajẹru ndu Mídiya iphe, bụkwaphu nna nyee Mósisu; abya anụkota k'iphemiphe ọbule, Nchileke meshiru Mósisu; mẹ ndu nk'iya, bụ ndu Ízurẹlu; ọwaa ẹge Ojejoje gude dufuta ẹphe lẹ Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Teke Mósisu dularu nyee ya; mbụ Zipora lẹ kẹ nna nyee ya, bụ Jeturo; bẹ Jeturo nabataru nwanyi ono; ");
INSERT INTO iqw_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","waa ụnwu iya unwoke labụ. Onye lanụ bẹ ẹpha iya bụ Geshọmu; kẹle Mósisu sụru lẹ ya bụ onye laru alala l'alị ndu ọhodo. ");
INSERT INTO iqw_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Onye ọphu bẹ ẹpha iya bụ Eliyéza; kẹ l'ọ sụru l'ọ bụ Nchileke nna iya bụ onye yeru iya ẹka. Ọ dzọfutaru iya tẹ Fero be gbu iya. ");
INSERT INTO iqw_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jeturo, bụ nna nyee Mósisu duru ụnwu Mósisu; mẹ nyee Mósisu ọbu byakfuta iya l'echi-ẹgu l'ẹke ọ kpọberu ụlo-ẹ́kwà l'iku ugvu Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jeturo zihawaru t'e je asụ iya: “Lẹ yẹbe Jeturo, bụ nna nyee ngu bẹ dukwa nyee ngu; waa ụnwegirima ngu l'abya.” ");
INSERT INTO iqw_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tọ dụ iya bụ; Mósisu agba iya ndzuta; bya ebyishi ikpere; nmaa ya akpa. Ẹphe ekeletsua; bahụshia l'ụlo-ẹ́kwà Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mósisu akọkotaru nna nyee ya ono kẹ iphemiphe ọbule, Ojejoje meru Fero waa ndu Íjiputu l'okfu ẹhu ndu Ízurẹlu; ọwaa kẹ iphe-ẹhuka, ẹphe jekotaru l'ụzo; mẹ ẹge Ojejoje gude dzọfuta ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ẹhu atsọo Jeturo ẹna l'ọ nụru kẹ iphe, dụ mma, Ojejoje mekotaru ndu Ízurẹlu; dzọfuta ẹphe l'ẹka ndu Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yọ sụ tẹ ajaja bụru kẹ Ojejoje, bụ onye nafụtaru ngu l'ẹka ndu Íjiputu yẹle ẹka Fero; mbụ onye nafụtaru ndu Ízurẹlu l'ẹka ndu Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nta-a bẹ ya maru lẹ Ojejoje bẹ kakọta agwa l'ọ ha nshinu. Kẹ l'ọ bụ ndu nmaru ndu Ízurẹlu kulakula b'o meru iphe-a. ");
INSERT INTO iqw_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ya ndono; Jeturo, bụ nna nyee Mósisu abya egwooru Ojejoje ngwẹja-ukfuru; gwokwaaru iya phụ ngwẹja ọdowaru. Érọnu eduta ndu bụ ọgurenya Ízurẹlu bya; ẹphe lẹ Jeturo eria nri l'ifu Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Yo rua echile iya; Mósisu abya anọdu l'oshi iya; kpelahaaru ndu Ízurẹlu ikpe. Ẹphe anọ-phee ya mgburumgburu shita l'ụtsu jeye l'urẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nna nyee Mósisu aphụ iphe, Mósisu emeru ndu Ízurẹlu; bya ajị: “?Bụ ngụnu bẹ iimeru ndu Ízurẹlu ẹge-a? ?Bụ ngụnu kparu iphe ọ bụ nggụbedua nwẹnkinyi ngu bụ onye ikpe; ndu-a l'ẹphe ha abya anọ-phe ngu mgburumgburu shita l'ụtsu jeye l'urẹnyashi?” ");
INSERT INTO iqw_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mósisu asụ iya l'iphe kparu iya nụ kwa l'ẹphe abyajẹ iya ọkpata ishi iphe, bụ uche-obu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Teke ọ bụ l'ọo okfu adaru ẹphe; ẹphe ewotaru iya ẹya; ya edoshiaru iya ẹphe; karu ẹphe iphe, Ojejoje tọru ọkpa sụ t'e tsoje; waa ekemu iya. ");
INSERT INTO iqw_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nna nyee Mósisu asụ iya: “L'ẹge iime iya ta dụkwa mma. ");
INSERT INTO iqw_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ọ kwa egbugbu bẹ nggụbedua; waa ndu ono, awụ-kfutaje ngu nụ ono egbu onwunu. Ozi ono karikwaru ngu ẹka; ẹ tii jekotakwa iya nwẹnkinyi ngu. ");
INSERT INTO iqw_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ngabe nchị tẹ ya kpọ-ziaru ngu ụzo ẹge ii-meje iya. Tẹ Ojejoje swikwaru ngu. Ọ bụ nggụbedua a-nọ-chi ẹnya ndu-a l'ifu Nchileke. Ii-wotaje iphe, adaru ẹphe dooru iya. ");
INSERT INTO iqw_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Zia ẹphe iphe, Ojejoje tọru ọkpa sụ t'e tsoje; ọwaa ekemu iya; nggu ekoshi ẹphe ụzo, ẹphe e-tsoru; mẹ iphe, gbaru ẹphe l'ememe. ");
INSERT INTO iqw_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nggu abya eshi lẹ ndu Ízurẹlu l'ẹphe ha fọta ndu ike dụ; ndu atsụ Nchileke egvu; ndu e gude ire ẹphe ẹka; bya abụru ndu ẹ te eridu nggọlazu. Shi l'ẹphe fọta ndu a-bụru ndu ishi ụnu madzụ labụ l'ụkporo madzụ iri iri; ndu a-bụru ndu ishi ụkporo ụmadzu ise ise; ndu a-bụru ndu ishi ụkporo madzụ ẹbo l'iri iri; mẹ ndu ọphu a-bụru ndu ishi ụmadzu iri iri. ");
INSERT INTO iqw_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Fọta ẹphe t'ẹphe doshijeru ndu Ízurẹlu okfu tekenteke. Okfu ọphu dụ nphe; ẹphe edoshia ya l'onwẹphe. Okfu ọphu shihuru ike; ẹphe ewotaru ngu iya. Ono bụ ẹge -bụ; unu -mee ya; ivu iya akaru ngu lẹ nphe; kẹ l'unu l'ẹphe tụkoru evu iya. ");
INSERT INTO iqw_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","I -mee ya ẹge ono, bụkwanu ẹge ọ bụ uche-obu Nchileke bẹ ịi-dụkwa ike vua ivu ẹra ono. Teke ndu ono a-nọdu ala; ẹphe egude ẹhu-ọtso-ẹna l'ala.” ");
INSERT INTO iqw_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mósisu anụa iphe nna nyee ya kfuru; bya emekota iphe ono, o kfuru ono. ");
INSERT INTO iqw_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Yọ bya eshi lẹ ndu Ízurẹlu fọta ndu ike dụ; bya emeshia ẹphe ndu ishi ndu dụ ụnu labụ l'ụkporo iri iri; mẹ ndu ishi ndu dụ ụkporo ise ise; mẹ ndu ishi ndu dụ ụkporo ẹbo l'iri iri; ọwaa ndu ishi ndu dụ iri iri. ");
INSERT INTO iqw_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Yọ bụru ẹphe anọduje edoshiru ndu Ízurẹlu okfu. Okfu ọphu shihuru ike; ẹphe ewojeru iya Mósisu. Okfu ọphu dụ ntse; ẹphe edoshia ya l'onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ya ndono; Mósisu ahaa nna nyee ya ono; yọ lashia alị iya. ");
INSERT INTO iqw_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Yo be mbọku, kwe ndu Ízurẹlu ọnwa ẹto gẹdegede; k'ọphu ẹphe shi lẹ Íjiputu wụfuta; ẹphe abyaruta echi-ẹgu Sáyịnayi. ");
INSERT INTO iqw_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ẹphe eshi lẹ Réfidimu bya erua echi-ẹgu Sáyịnayi; bya akpọbe ụlo-ẹ́kwà ẹphe l'ẹke ono l'ọkpa ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mósisu enyihu eli ugvu ono nyikfu Nchileke. Ojejoje abya l'ugvu ono kua ya; sụ iya: “Ọwaa iphe, ii-zi ndu ọnu-ọlu Jékọpu; mbụ iphe, ii-kfuru ndu Ízurẹlu: ");
INSERT INTO iqw_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Unubẹdua l'onwunu phụru iphe, ya meru ndu Íjiputu; mẹ ẹge ya gude hee unu l'ọ bụ ugo, he nwa iya; hekfuta onwiya. ");
INSERT INTO iqw_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ọ -bụru l'unu ngabẹru iya nchị; bya edobe ọgba-ndzụ iya bẹ unu a-bụru òkè-iphe, dụru iya iche l'iphe bụ mbakeshi. A makwaru-a lẹ mgboko l'ọ ha bụ nk'iya; ");
INSERT INTO iqw_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ọle unu a-bụru iya alị-eze ndu achịjeru Nchileke ẹja; bụru mba, dụ nsọ. Ono iphe, ii-kfuru ndu Ízurẹlu ndono.” ");
INSERT INTO iqw_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Tọ dụ iya bụ; Mósisu abya alaphu azụ; bya ekukoo ndu bụ ọgurenya ndu Ízurẹlu; bya atụko iphemiphe ọbule ono, Ojejoje ziru iya t'o kfua ono; kfukotaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ndu Ízurẹlu atụko zụa mgbede; sụ: “L'iphe, bụ iphe Ojejoje kfuru bẹ ẹphe e-mekota.” Mósisu abya egude ọnu, ẹphe yeru jekfushia Ojejoje ọdo. ");
INSERT INTO iqw_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ojejoje asụ Mósisu: “Lẹ ya a-nọdu l'urukpu, jihuru kpalungu byakfuta ngu; k'ọphu ndu Ízurẹlu a-nọdu anụ ẹke, ya ekfu eyeru ngu; bya achịru ụkfu kwẹe ngu.” Mósisu abya ekfuaru Ojejoje k'ọnu, ẹphe yeru. ");
INSERT INTO iqw_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ojejoje asụ Mósisu: “T'o jekfu ndu Ízurẹlu je edoo ẹphe nsọ ntanụ yẹle echile. Yo kfuaru ẹphe t'ẹphe saa uwe ẹphe asasa. ");
INSERT INTO iqw_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","O -rua mbọku k'ẹto; t'ẹphe kwakọbe-gewa; kẹle mbọku ono bẹ Ojejoje e-nyizita; nọdu lẹ Ugvu Sáyịnayi; ndu Ízurẹlu aphụkota iya l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kpaaru ẹphe oke l'ugvu ono mgburumgburu. Kfuaru ẹphe: ‘T'ẹphe letakwa ẹnya tẹ ọkpa ẹphe be erukwa lẹ mgboro ugvu ono; k'ọphu ọ bụru kẹ onyihu iya enyihu. Onye ẹhu iya rutaru l'ugvu ono bẹ ee-gbukwa egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","T'a tụ-gbukwaa onye ọbu lẹ mkpuma; m'ọ bụ gbagbua ya l'arwa. T'ẹ b'e denyikwa iya ẹka. Ọ -bụru madzụ; bụru anụ; t'ẹ b'e kwekwa t'ọ nọdu ndzụ.’ Ọ bụlephu teke e gburu ụpyoku; ẹphe ejeshia l'eli ugvu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mósisu eshitsulephu l'eli ugvu ono nyifuta byakfuta ndu Ízurẹlu; bya edoo ẹphe nsọ t'ẹphe dụru Nchileke iche; ẹphe bya asashịa uwe ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Yọ sụ ẹphe l'o -rua mbọku k'ẹto; t'ẹphe kwakọbe-geekwa onwẹphe. T'ẹ b'ọ dụkwa ẹphe onye e-jekfu nwanyi! ");
INSERT INTO iqw_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Yo be l'ụtsu mbọku k'ẹto ono; ebemu awata ekuku; egbe-igwe l'agba; urukpu, jihuru kpalungu atsọ-kputa eli ugvu ono. Ọda ụpyoku, shi l'ugvu ono l'ada l'adashi ike. Onyemonye ọbule; l'ọdu ndu Ízurẹlu ono anmalahaa kpakpakpa. ");
INSERT INTO iqw_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mósisu abya edufuta ẹphe l'ọdu ndu Ízurẹlu ono; t'ẹphe byakfuta Nchileke. Ẹphe eje evudo l'ọkpa ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ẹnwuru-ọku achịko Ugvu Sáyịnayi nata; kẹle Ojejoje gude ọku nyifuta lẹ Ugvu Sáyịnayi ono. Ẹnwuru-ọku ono akpụlephu tụu l'ọ bụ ẹke a kpọberu ọku icheku. Ugvu ono l'ọ ha anmakọta jijiji l'anmashi iya ike. ");
INSERT INTO iqw_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ọda ụpyoku ono l'aka nshinu akaka l'eje; Mósisu l'ekfu okfu; aanụ olu Nchileke l'ẹke ookfu eyeru Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ojejoje enyizita l'eli Ugvu Sáyịnayi ono; bya ekua Mósisu t'o nyikfuta iya l'eli eli ugvu ono. Mósisu enyikfushia ya eli ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ojejoje asụ iya t'o nyizita l'alị je anmaaru ndu Ízurẹlu ọkwa t'ẹphe ba akpahẹ ụzo t'ẹphe phụ Ojejoje; ọdumeka; bẹ ẹphe a-dụkwa l'igwe bụru kpurupyata. ");
INSERT INTO iqw_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Mbụkponu ndu achịjeru Nchileke ẹja, eme t'ẹphe byakfuta yẹbe Ojejoje ntse bẹ e-do onwẹphe nsọ t'ẹphe dụru iya iche; ọdumeka bẹ ya a-nụkwa ẹphe aphụ. ");
INSERT INTO iqw_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mósisu asụ Ojejoje: “Ndu Ízurẹlu te enyihukwa Ugvu Sáyịnayi; kẹ l'ị tụru ayi ekemu sụ t'ayi dobe ugvu ono nsọ; tẹmanu ayi akpaa ya oke gbaphee mgburumgburu.” ");
INSERT INTO iqw_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ojejoje asụ iya: “Nyizita l'alị je eduta Érọnu tẹ nggu l'iya yịru. Ọle be ekwekwa tẹ ndu achịjeru Nchileke ẹja; mẹ ndu Ízurẹlu ọdo sweta ẹke ono nyikfuta yẹbe Ojejoje; ọdumeka bẹ ya a-nụkwa ẹphe aphụ.” ");
INSERT INTO iqw_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mósisu enyizita bya ekfuaru ndu Ízurẹlu iphe, Ojejoje kfuru. ");
INSERT INTO iqw_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ojejoje abya ekfukota iphe ono l'ọ ha; sụ: ");
INSERT INTO iqw_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ọ bụ yẹbedua bụ Ojejoje, bụ Nchileke unu; onye dufutaru unu l'alị Íjiputu; mbụ alị ono, unu shi bụru ohu ono. ");
INSERT INTO iqw_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ba adụkwa iphe ịi-baru ẹja; gbahaa yẹbe Nchileke kpụrumu. ");
INSERT INTO iqw_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Be emetakwaru onwongu ntẹkpe, e meru; yọ dụ l'ọ bụ iphe, nọ l'imigwe; m'ọ bụ ọphu, nọ lẹ mgboko; m'ọ bụ iphe, bu lẹ mini-ime-alị. ");
INSERT INTO iqw_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ba abakwaru iphe ọphu ẹja; ọphu i jekwaru iya ozi; kẹle yẹbe Ojejoje, bụ Nchileke unu ekokwa okopho. Ya anụje ndu kpọru iya ashị aphụ k'ẹjo iphe, ẹphe meru iya; shi iya nụa ụnwu ẹphe aphụ; nụa ya ụnwu nwa ẹphe; nụa ya ụnwu nwanwanwaranwa ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Obenu l'iphe bụ ndu yeru iya obu; l'eme iphe, ekemu iya kfuru; bẹ ya emejekwanu t'obu, ya yeru ẹphe bụru o-je-lẹ-nwanwa. ");
INSERT INTO iqw_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Be ekukwa ẹpha yẹbe Ojejoje, bụ Nchileke unu kẹ mkpẹ. Kẹle yẹbe Ojejoje ta ahakwa ndu eme ẹge ono; tẹ ya ba nụ ẹphe aphụ. ");
INSERT INTO iqw_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Nyatajẹkwa mee mbọku ọtu-ume t'ọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ujiku ishingu; bẹ ii-seje akanya; jee ozi ngu. ");
INSERT INTO iqw_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Obenu lẹ mbọku k'ẹsaa, bụ mbọku ọtu-ume kẹ yẹbe Ojejoje, bụ Nchileke unu. T'ẹ b'ọ dụkwa ozi, ii-jeje mbọku ono. Ọphu i kwekwa t'ụnwegirima ngu; ndu ọphu ị gbaru ohu; elu ngu; jeye lẹ ndu ọphu laru alala, bu lẹ nke ngu; jee ozi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kẹ l'ọ bụ ujiku ishingu; bẹ yẹbe Ojejoje meru igwe; bya emee eliphe yẹle eze ẹnyimu; mẹ iphemiphe ọbule, nọ iya nụ. Yo be mbọku k'ẹsaa; ya atụta ume. Yọ bụru iya kparu iphe yẹbe Ojejoje gọru ọnu-ọma nụ mbọku ọtu-ume; bya emee ya; yọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kwabẹjekwa nne lẹ nna ngu ugvu; k'ọphu ịi-ka nka l'alị ono, Ojejoje, bụ Nchileke unu abya unu anụnu ono. ");
INSERT INTO iqw_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Be egbukwa ọchi. ");
INSERT INTO iqw_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Be erikwa ogori. ");
INSERT INTO iqw_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Be ezikwa iphura. ");
INSERT INTO iqw_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Be ebobekwa madzụ ibe ngu ibo. ");
INSERT INTO iqw_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Be ejikwaru madzụ ibe unu ijimẹnya l'ụlo iya; m'ọ bụ lẹ nyee ya; ohu, ọ gbataru agbata; elu iya; mẹkpo iphe, bụ iphe o nweru enweru l'ọ ha.” ");
INSERT INTO iqw_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ndu Ízurẹlu aphụlephu egbe-igwe ono; mẹ ebemu ono; nụa ọda ụpyoku ono; bya aphụ ẹnwuru-ọku, shi l'ugvu ono akpụshi; ẹhu anmahu ẹphe anmanma l'ẹke ẹphe atsụ egvu. Ẹphe evudo ote-ẹnya; ");
INSERT INTO iqw_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","sụ Mósisu t'o kfujeru yeru ẹphe yẹbedua l'onwiya; l'ẹphe a-ngabẹjee nchị. Tẹ Nchileke be ekfukwaru yeru ẹphe l'onwiya; ọdumeka bẹ ẹphe a-nwụshihukwa. ");
INSERT INTO iqw_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mósisu asụ ndu Ízurẹlu: “T'ẹphe ba atsụshi egvu; kẹle Nchileke byaru t'ọ data ẹphe; k'ọphu ẹphe a-nọdu atsụ yẹbe Nchileke egvu; haa omee ẹjo iphe.” ");
INSERT INTO iqw_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ndu Ízurẹlu evudo ote-ẹnya; Mósisu abya ejekfube ọchi ono ntse, bụ ẹke Nchileke nọ. ");
INSERT INTO iqw_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ojejoje asụ Mósisu t'ọ sụ ndu Ízurẹlu l'ẹphe phụwaru l'onwẹphe lẹ ya shi l'imigwe kfuru yeru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","T'ẹ b'ọ dụkwa agwa, unu e-meta donyabe iya. T'ẹphe be egudekwa mkpọla-ọcha; m'ọ bụ mkpọla-ododo meta agwa doberu onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Ọ bụ ẹja, shi l'alị bẹ ee-gudeje kpụaru iya ẹnya-ngwẹja, bụ ẹke ee-gbuje atụru; mẹ eghu; mẹ eswi; gude gwooru iya ngwẹja-ukfuru; mẹ ngwẹja ẹhu-agu. Iphe bụ ẹke ya meru t'a anyatajẹ ẹpha iya bẹ ya a-byakfutaje unu bya agọoru unu ọnu-ọma. ");
INSERT INTO iqw_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ọ -bụru l'ẹphe gude mkpuma l'akpụru iya ẹnya-ngwẹja; t'ẹphe be egudekwa mkpuma, a kpụcharu akpụcha. Kẹ l'ẹphe -tsua ya ọngu bẹ ẹphe tụruwaru iya. ");
INSERT INTO iqw_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ọphu ẹphe akpụkwa ẹnya-ngwẹja ono t'ọ ha l'eli; k'ọphu aa-gbakobeje iphe l'eje iya; a nọnyaa; ẹphe ajịhaa onwẹphe ajịha l'ẹnya-ngwẹja ono.” ");
INSERT INTO iqw_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ọwaa ekemu, ii-zi ẹphe ndọ-ọ: ");
INSERT INTO iqw_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ọ -bụru l'ị gbaru onye Híburu ohu bẹ iphe, oo-jeru ngu ozi bụ afa ishingu. O -rua l'afa k'ẹsaa; yo nweru onwiya; ẹ taa kfụdu ụgwo l'ishi iya. ");
INSERT INTO iqw_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ọ -bụru l'ẹ tọ lụdu nwanyi teke ọ dụberu bụru ngu ohu; t'ọ bụkwaruphu yẹbedua bẹ aa-ha t'ọ la. Ọ -bụkwanuru lẹ yẹle nyee ya yị teke ọobya; tẹ nyee ya ono tsokwaru iya teke ọo-nọdu ala. ");
INSERT INTO iqw_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ọ -bụru lẹ nnajiufu iya lụru iya nwanyi; yọ mụtaru iya ụnwegirima; nyee ya ono mẹ ụnwegirima iya ono a-tụko bụru kẹ nnajiufu iya. Yọ bụru nwoke a-la nwẹnkinyi iya. ");
INSERT INTO iqw_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Ọ -bụkwanuru l'ohu ono sụru lẹ ya yeru nnajiufu iya obu; yeru nwanyi ono, ọolu ono obu; mẹ ụnwegirima iya; ya ta chọ tẹ ya lụfu je nweru onwiya; ");
INSERT INTO iqw_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","t'onye nwe iya nụ duta iya je l'ifu ndu ikpe. T'o duru iya je l'ọnu-ibo; m'ọ bụ l'oshi-ibo gude oji kpọ-fua ya nchị. Yọ bụru ohu iya jeye teke ọo-nọ-bebe.” ");
INSERT INTO iqw_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ọ -bụru lẹ nwoke reru nwa iya nwanyi t'ọ bụru ohu; ẹ ta byadụ bya aha iya t'ọ laa; ẹge aahaje ndu ọphu bụ unwoke. ");
INSERT INTO iqw_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Teke e reru iya onye arị kẹ t'ọ lụa iya; a nọnyaa; t'ọ dụhe iya mma k'alụlu; t'ọ hakwaa t'a gbata iya. Ẹ tọ gbakwa tẹ nnajiufu iya ono ree ya ndu ọhodo; kẹ l'e to meduru ohu iya ono iphe, o kweru ụkwa iya. ");
INSERT INTO iqw_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ọ -bụru l'ọo nwatibe iya kẹ nwoke b'ọ gbaru iya doberu t'ọ lụa; t'o mejekwa nwamgbọko ọbu l'ọ bụ nwa iya nwanyi. ");
INSERT INTO iqw_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ọ -bụru lẹ nwoke lụru nwanyi ọdo; t'ọ nụjekwa nyee ya kẹ mbụ nri; nmajẹru iya ẹkwa; l'emekwaru iya phụ iphe, bụ iphe emejeru nwanyi aalụ alụlu. ");
INSERT INTO iqw_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","O -bụru l'ẹ too meduru nwanyi ono ụzo iphe ẹto ono; tẹ nwanyi ono lụfukwa. Ọle t'ẹ b'ọ dụkwa m'ọo afụ, aa-kfụ nwoke ono.” ");
INSERT INTO iqw_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Onye chiru madzụ iphe chigbua ya; t'ọ lakwaa l'ọchi iya. ");
INSERT INTO iqw_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ọ -bụkwanuru l'ẹ to lebezidu ẹnya; ọ -bụru l'ọo Nchileke haru iya t'ọ mee ẹge ono; b'o nweru ẹke ya e-koshi unu tẹ onye dụ ẹge ono gbajẹru laa. ");
INSERT INTO iqw_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Obenu; ọ -bụru lẹ madzụ kwabẹru ẹnya; gude ẹregede; gbua madzụ ibe iya; unu kpụta onye ọbu kpụfu l'ẹnya-ngwẹja yẹbe Nchileke; je egbua ya l'ẹke ọdo.” ");
INSERT INTO iqw_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Onye tsoru nne iya; m'ọ bụ nna iya ọgu bẹ ee-gbu egbugbu.” ");
INSERT INTO iqw_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Onye pataru madzụ ibe iya je eree; m'ọ bụ l'ọ nọkwadu iya l'ẹka teke e guderu iya; t'e gbua onye ọbu egbugbu.” ");
INSERT INTO iqw_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Onye phuru nne iya; m'ọ bụ nna iya iphu; t'e gbukwaa onye ono egbugbu.” ");
INSERT INTO iqw_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ọ -bụru l'unwoke labụ bẹ okfu adaru; onye lanụ atụa onye ọphu mkpuma; m'ọ bụ l'ọ kfụkfuberu ẹka tsua ya; ọphu onye ono anwụhudu; yọ bụ-chiaru iphe b'o mekaru iya; yọ zẹeru iya azẹe; t'ẹ b'ọ dụkwa iphe, ee-me onye ono, mekaru iya iphe ono; ");
INSERT INTO iqw_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","m'ọ bụru l'onye ono mekochaaru l'adụje ike gude mgbọro ejephe l'etezi. Ọle onye ọphu mekaru iya iphe phụ a-kfụkwanu iya ụgwo kẹ azẹe ono, o shi zẹe ono; bya aghakwaa ya phụ jeye teke ọo-kagee mma ọhuma.” ");
INSERT INTO iqw_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ọ -bụru l'o nweru onye chiru ohu iya iphe; m'ọ bụ ohu iya kẹ nwoke; m'ọ kẹ nwanyi; ohu ono eshi l'iphe ono, e chiru iya ono nwụhu; t'a nụ̀kwaa onye ono, chigburu iya nụ ono àphụ̀. ");
INSERT INTO iqw_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Obenu l'ọ -bụru l'ohu ono nọru abalị ẹbo; m'ọ bụ ẹto bya akọrohu; t'ẹ b'ọ dụkwa iphe, ee-me onye ono, chiru iya iphe ono; eshinu ohu ono bụ ẹku iya.” ");
INSERT INTO iqw_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ọ -bụru l'o nweru unwoke, alụ ọgu; ẹphe emeka nwanyi, dụ ime iphe; mee k'ọphu ẹpho lụfuru iya; ọphu o nwedu ẹke a kwataru meka iya iphe ọdo; t'e eretakwa onye ọphu mekaru iya iphe ọbu nre; ẹge dụ nji nwanyi ọbu mma; mẹ ẹge ndu ikpe kpeburu. ");
INSERT INTO iqw_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Obenu; ọ -bụru l'e mekaru iya iphe nshinu; t'ẹ ndzụ lakwaaru ndzụ; ");
INSERT INTO iqw_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ẹnya alaaru ẹnya; eze alaaru eze; ẹka alaaru ẹka; ọkpa alaaru ọkpa. ");
INSERT INTO iqw_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ọ -bụru ọku b'ọ hụru iya; t'a hụlatakwa iya. Teke o mefuru iya ọnya l'ẹhu; t'e melatakwa iya. Teke o tsuru mkpukpu-mee ye iya l'ẹhu; t'e tsukwaruphu mkpukpu-mee ye iya l'ẹhu.” ");
INSERT INTO iqw_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ọ -bụru l'o nweru onye chiru ohu iya iphe l'ẹnya; k'ọphu o chipyaru iya ẹnya lanụ; tẹ onye ono hakwaa ohu ono t'o je enweru onwiya; t'ọ bụru ụgwo ẹnya ono, o chipyaru iya ono. ");
INSERT INTO iqw_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ọ -bụru l'o chikwofuru iya eze lanụ; t'ọ hakwaa ohu ono t'o je enweru onwiya; t'ọ bụru ụgwo eze iya ono.” ");
INSERT INTO iqw_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ọ -bụru l'oke-eswi gude mpo dụ-gbua madzụ; t'a tụ-gbukwaa eswi ono lẹ mkpuma; ọle t'ẹ ba atakwa anụ iya atata; ọphu ọ dụkwa iphe, ee-me onye nwe iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Obenu; ọ -bụru l'oke-eswi ọbu eme ẹnari; e kfuhawaru iya onye nwe iya nụ; t'o kwe kpọ-chia ya l'ọka; ọ -bụru l'eswi ono dụ-gburu madzụ; t'a tugbukwaa eswi ono lẹ mkpuma; onye nwe iya nụ alaa l'ọchi onye ọ dụ-gburu. ");
INSERT INTO iqw_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ọle; ọ -bụru l'ọ dụ ndu ono t'ẹphe gbuaru onye nwe eswi ono nre; t'ọ kfụkotakwa iphe, bụ iphe, e gbuburu iya; shi ẹge ono gbata onwiya. ");
INSERT INTO iqw_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ekemu ono bụkwaphu iphe lanụ m'ọ -bụru l'oke-eswi dụ-gburu nwata nwoke madzụ; m'ọ bụ nwata nwanyi kẹ madzụ. ");
INSERT INTO iqw_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ọ -bụru l'oke-eswi ono bẹ dụ-gburu ohu; t'onye nwe eswi ono kfụa onye nwe ohu ono ụkporo mkpọla-ọcha lẹ mkpọla-ọcha iri. T'a tụ-gbukwaaphu eswi ono lẹ mkpuma.” ");
INSERT INTO iqw_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ọ -bụru lẹ madzụ kpufuru iphe lẹ nsụ; m'ọ bụ l'onye ono tụru nsụ; ghebe iya ọnu; oke-eswi; m'ọ bụ nkakfụ-ịgara eje adalahu iya; nwụhu; ");
INSERT INTO iqw_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","tẹ onye nwe nsụ ono kfụkwaa ụgwo anụ ono. T'onye ono kfụkwaa onye nwe anụ ono, dalahụru lẹ nsụ ono ụgwo iya; pata ono, nwụhuru nụ ono. ");
INSERT INTO iqw_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ọ -bụru lẹ madzụ bẹ oke-eswi iya dụ-gburu oke-eswi onye ọdo; tẹ ụmadzu labụ ono gbaru mgba ree oke-eswi ọphu nọ ndzụ; kee aswa iya ẹnya-nhamụnha. Ẹphe ekekwaaphu anụ iya ọphu nwụhuru anwụhu ẹnya-nhamụnha. ");
INSERT INTO iqw_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ọle; ọ -bụru lẹ onye, nwe oke-eswi ono mahawaru l'oke-eswi iya eme ẹnari; jịka lẹ ya ta akpọ-chidu iya l'ọka; tẹ onye nwe oke-eswi ono kpẹkwaa onye ọphu oke-eswi ọdo; pata onanu, nwụhuru anwụhu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ọ -bụru l'o nweru onye kpụru eswi; m'ọ bụ atụru onye ọdo l'iphura gbua; m'ọ bụ l'o reru iya erere; t'o gudekwa eswi ise kfụa ụgwo eswi lanụ ono. Ọ -bụru atụru; yọ bụru atụru ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ọ -bụru l'a phụru iphura l'ẹke ootsukpo ụlo onye ọdo tẹ ya bahụ; ọ -bụru l'e mekaru iya iphe; yo shi ẹge ono nwụhu bẹ onye ono, gburu iya nụ ono te gbukwa ọchi. ");
INSERT INTO iqw_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Obenu; ọ -bụru l'o meru teke ẹnyanwu hatawaru bụakwa ọchi bẹ onye ono gburu. “Onye iphura kfụfutaje ụgwo iphe, o zitaru. Ọ -bụru l'ẹ to nwedu iphe, o nweru; e ree yẹbedua l'onwiya; gude aswa iya kfụa ụgwo iphe, o zitaru. ");
INSERT INTO iqw_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ọ -bụru l'iphe ono, o zitaru ono b'a phụru iya l'ẹka; yọ nọdukwadu ndzụ; m'ọ bụ oke eswi-o; m'ọ bụ nkakfụ-ịgara-o; m'ọ bụ atụru; onye ono a-kfụ ụgwo iya nkfụkwase. ");
INSERT INTO iqw_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ọ -bụru lẹ madzụ chịru elu iya ye; yo je ataa iphe, e meberu l'okfu onye ọdo; m'ọ bụ lẹ mgbo vayịnu onye ọdo; m'ọ bụ l'ọ haru iya ẹka; yo je ataa iphe, e meberu l'okfu onye ọdo; tẹ onye nwe elu ono gude iphe, katsụa mma l'okfu iya; m'ọ bụ lẹ mgbo vayịnu iya; kfụa onye ọphu ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ọ -bụru l'ọku nahụru laa l'ẹgbudu; k'ọphu o keru witu, e butawaru ebuta; m'ọ bụ ọphu ẹ te butadua; m'ọ bụ l'o kekotaru okfu ono l'ọ ha; tẹ onye tụru ọku ono kfụkwaa ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ọ -bụru l'o nweru onye nụru madzụ okpoga; m'ọ bụ iphe ọdo t'o doberu iya; a bya ezita iya l'ụlo onye ono; ọ -bụru l'e guderu onye oshi ono; t'ọ kfụkwaa ụgwo iya nkfụkwase. ");
INSERT INTO iqw_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Teke bụkwanu l'ẹ te gudedu onye iphura ọbu; t'onye nwe ụlo ono lụfuta l'ifu ndu ikpe; bya egude ẹpha Ojejoje gụa ẹnwa t'a maru l'ẹ tọ dụ iya kpamiru iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ọ -bụru l'o nweru iphe, aachọ achọcho; a phụa ya onye ọdo l'ẹka; mbụ iphe, dụ l'ọ bụ eswi; m'ọ bụ nkakfụ-ịgara; m'ọ bụ atụru; m'ọ bụ iphe eye l'ẹhu; mbụ iphe bụ iphe, eenweru enweru; t'e duta ụmadzu labụ, adzọ iphe ono bya l'ifu ndu ikpe. Onye ọphu ikpe nmaru; yọ kfụa onye ọphu nkfụkwase. ");
INSERT INTO iqw_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ọ -bụru l'o nweru onye kpẹru madzụ nkakfụ-ịgara; m'ọ bụ oke-eswi; ọdoo atụru; mẹwaru elu ọdo t'o doberu iya; yọ nwụhu; m'ọ bụ l'e mekaru iya iphe; m'ọ bụ l'o phuhuru; to nwe onye maru iphe meru iya nụ; ");
INSERT INTO iqw_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ẹge ee-shi doshia okfu ono bụ tẹ onye ono bya Ojejoje l'ifu je agụa ẹnwa l'ẹ t'ọ makwa iphe, meru ẹku onye ọphu; t'onye nwe iya nụ kwetakwa ẹge ono; t'ẹ b'ọ kfụkwa iya ụgwo. ");
INSERT INTO iqw_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ọle; ọ -bụkwanuru l'a kpụru iya l'iphura lẹ k'onye ono, e doberu iya ono; tẹ onye ono kfụkwaa onye nwe iya nụ ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ọ -bụru l'ọ bụ anụ-ẹgu-ẹgbudu tagburu iya; t'o wota anụ iya ọphu ọ taphoduru je ekoshi; t'a maru l'ọo anụ tagburu iya. T'ẹ b'a sụkwa t'ọ kfụa ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ọ -bụru l'o nweru onye rọtaru elu onye ọdo; iphe emeka iya; m'ọ bụ l'ọ nwụhuru teke onye nwe iya nụ ta nọdu l'ẹke ono; tẹ onye rọtaru iya nụ kfụkwaa ụgwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Obenu; ọ -bụru l'onye nwe iya nụ nọ l'ẹke ono teke ono; t'onye rọtaru iya nụ ba akfụkwa ụgwo iya. Teke bụ l'ọ kfụru ụgwo; ngụta eswi ono; tẹ okpoga ono, a kfụru ono nọ-chiakwaru iyi, yitaru onye ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ọ -bụru l'o nweru onye kpaguderu nwamgbọko, nwoke ta achịkahubua ọkpa; to nwewa onye eje iya alụlu; ẹphe l'iya azẹe; t'ọ kwakwaa aswa nụ ndibe ẹphe; duta iya je alụru. ");
INSERT INTO iqw_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ọ -bụru lẹ nna nwamgbọko ono jịkaru; sụ lẹ ya te ekedu iya ẹya; t'ọ kwakwaaphu aswa, aakwajẹ l'ishi nwamgbọko, yẹle nwoke ta zẹbua; nụ nna iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Unu ba ahajẹkwa nwanyi, eme amamanshi t'ọ nọdu ndzụ. ");
INSERT INTO iqw_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Onye yẹle anụ zẹru bẹ ee-gbuje egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Onye gworu ẹja nụ iphe ọdo, ẹ-ta bụdu yẹbedua, bụ Ojejoje bẹ ee-gbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Unu ba akpajẹkwa ndu laru alala ẹhu; ọphu unu emegbujekwa ẹphe emegbu; kẹ l'unu shikwa-a bụru ndu laru alala l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Unu be emegbujekwa ụnwanyi, maa tụfuru; ọphu unu emegbujekwa ndu a tọru ogbe. ");
INSERT INTO iqw_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Teke unu emegbu ẹphe emegbu; ẹphe araa; raku yẹbe Ojejoje bẹ ya a-nụkwa olu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ẹhu-eghughu iya a-vọ-lihukwa; ya egude ọgu bya achịko unu gbugee. Unyomu unu abụru ndu, maa tụfuru; ụnwegirima unu abụru ụnwu ogbe. ");
INSERT INTO iqw_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ọ -bụru l'unu jeru ndu kẹ yẹbe Ojejoje, mkpa byaru ụgwo l'ime onwunu; unu be emekwa l'ọbu ndu ejeje ụgwo ọ-mụru-nwa. Unu ba asụkwa t'ẹphe kfụru ọ-mụru-nwa yeru iya unu. ");
INSERT INTO iqw_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ọ -bụru lẹ madzụ ibe unu yeru unu uwe l'itumo; unu wolaaru iya ẹya tẹmanu ẹnyanwu arịba. ");
INSERT INTO iqw_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Kẹ l'ọ bụ uwe ono bụ iphe, oogudeje egbochita ẹhu iya. ?Bụhunu ngụnu bẹ oo-gude kuru mgbẹnya? Ọ -raku yẹbe Ojejoje bẹ ya a-nụkwa olu iya; kẹle ya aphụje imiko. ");
INSERT INTO iqw_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Unu be ekfubyishijekwa Nchileke ekfubyishi; ọphu unu akọjekwa onye achị ndu alị unu ọnu. ");
INSERT INTO iqw_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Unu ba ahakwa ogworu yẹbe Ojejoje ngwẹja, shi l'akpụru iphe, unu kpataru l'okfu; waa ọphu shi lẹ mẹe, unu pyịtaru apyịta. “Ụnwegirima unu ndu ọphu bụ ọkpara; bẹ unu a-nụje iya. ");
INSERT INTO iqw_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ono kwaphu ẹge unu e-meje iya l'eswi unu; mẹ l'atụru unu. Unu hajẹe ya t'ọ nọo l'ẹhu nne iya abalị ẹsaa. O -rua lẹ k'ẹsato iya; unu akpụta iya kpụtaru yẹbe Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Unu a-bụ ndu dụru yẹbe Ojejoje lẹ nsọ. Unu ba atajẹkwa iphe, anụ-ẹgu-ẹgbudu gburu. Unu tọgbojeru iya nkụta. ");
INSERT INTO iqw_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ba atụjekwa ntụmatu. Ba agbajẹkwa ẹjo ekebe gude eyeru ẹjo madzụ ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Be etsojekwaru igwe-ọha ye ẹka l'ome iphe ẹ ta dụdu mma. Teke i vudo l'ifu ndu ikpe; be egudekwa l'iime t'i kfua iphe a-dụ ọha mma; mee tẹ ikpe laaru onye iswi ẹ-ta dụdu mma. ");
INSERT INTO iqw_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Be egudekwa l'ọo lẹ madzụ bụ onye ụkpa; gbachiaru iya l'ifu ndu ikpe. ");
INSERT INTO iqw_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ọ -bụru l'ị phụru oke-eswi; m'ọ bụ nkakfụ-ịgara onye ọhogu ngu ẹke ọokpa-phuhuwa akpaphuhu; kpụtakwa iya kpụ-jeru iya. ");
INSERT INTO iqw_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ọ -bụru l'ị phụru nkakfụ-ịgara onye ị dụ ashị; ẹke ivu, o vu nyị-tsutaru iya; ba ahakwa iya. Tụgbukwaa je eyeru iya ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Unu ba ajịkakwa okperu onye ụkpa ikpe ọhuma l'ụlo ikpe. ");
INSERT INTO iqw_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Sekwaa ẹka; mẹ ọkpa l'okpe ẹjo ikpe. Be egbujekwa onye, ẹ te nwedu iphe o meru; m'ọ bụ onye doberu ẹka ndoo; kẹle ya ta ahakwa onye meru iphe, dụ ẹji tẹ ya ba nma iya ikpe. ");
INSERT INTO iqw_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ba anakwa ẹka-azụ; kẹle ẹka-azụ emejekwa tẹ madzụ mee ẹnya l'ẹ t'ọ phụdu iphe, ọ phụchacharua; l'emejekwaphu t'a nma onye doberu ẹka ndoo ikpe. ");
INSERT INTO iqw_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Unu be emegbujekwa ndu laru alala emegbu; kẹ l'unu maru ẹge ọoduje onye laru alala; unubẹdua eshiwa bụru ndu laru alala l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Afa ishingu bẹ unu a-kọje alị unu; kpata iya iphe, e meberu iya. ");
INSERT INTO iqw_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","O -be l'afa k'ẹsaa; unu ahaa ya akọko; k'ọphu ndu Ízurẹlu ndu ọphu akpa ụkpa e-jeje akpaa l'ẹke ono. Ọphu wuduru nụ; anụ-ẹgu-ẹgbudu erifufuwa iya rụ. Unu mekwaaphu mgbo vayịnu unu; mẹ ẹgu-olivu unu ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Abalị ishingu bẹ unu e-jeje ozi; o -be lẹ mbọku k'ẹsaa; unu be ejekwa ozi; k'ọphu oke eswi unu; mẹ nkakfụ-ịgara unu a-tụtaje ume; mẹkwaphu k'ọphu ohu, a mụru lẹ nk'unu; mẹ onye bụ mbyamụmbya a-tụtakwaphu ume. ");
INSERT INTO iqw_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Unu kwabẹkwa ẹnya mekota iphemiphe ọbule-a, ya ekfuru unu-a. Unu ba adụkwa iphe, bụ iphe aagwa agwagwa, unu a-kpọ-kuje. Unu be ephotajekwa iya ẹpha ephota lẹ phuu. ");
INSERT INTO iqw_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ugbo ẹto l'afa; bẹ unu a-gbajẹru iya ajị. ");
INSERT INTO iqw_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Unu a-gba Ajị Buredi, ẹ te kodu ekoko. Ujiku ẹsaa; bẹ unu a-tajẹ buredi, ẹ te yedu iphe, ekoje buredi; bụ iya bụ ẹge ya tụru unu l'ekemu. Unu meje iya teke ono, aagbajẹ ajị ono l'ọnwa Abibu; kẹ l'ọ bụ l'ọnwa ono; bẹ unu lụfutaru lẹ Íjiputu. “T'ẹ b'ọ dụkwa onye a-gbajẹru ẹka bya iya l'ifu. ");
INSERT INTO iqw_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Unu gudeje iphe ọdungu, unu kpataru l'iphe, unu meberu l'alị gbaa Ajị O-je-l'ẹgu. “Unu gbaa Ajị M̀kpù l'ishi-afa teke unu akpata iphe, unu meberu l'alị. ");
INSERT INTO iqw_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ugbo ẹto l'afa bẹ unwoke unu l'ẹphe ha a-chịkoje bya l'ifu Nnajiufu, bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“T'ẹ b'ọ dụkwa iphe e yeru iphe ekoje buredi, unu e-yekobe lẹ mee anụ, unu gude egworu iya ngwẹja. “T'ẹ b'ọ dụkwa ẹ̀bà anụ ono, e gude gbaa ajị ono, aa-ha t'ọ bọo nchi. ");
INSERT INTO iqw_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Iphe mbụ, vuru ụzo kaa l'okfu unu bẹ unu e-gudeje bya l'ụlo Ojejoje, bụ Nchileke unu. “Unu be egudejekwa mini-ẹra nne eghu shia nwa iya. ");
INSERT INTO iqw_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Unu lekwaa; lẹ ya e-zi ojozi-imigwe t'o vutaru unu ụzo; l'eche unu; dua unu durua ẹke ono, ya kwakọbewaru akwakọbe ono. ");
INSERT INTO iqw_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Unu ngabẹjekwaru ojozi-imigwe ono nchị; meje iphemiphe ọbule, ọ sụru t'unu mee. Unu be ekwefujekwaru iya íkè; kẹ l'ẹ tọo gụkwaru unu nvụ; keshinu ọphu ọ bụ ẹpha yẹbe Ojejoje b'o gude eje. ");
INSERT INTO iqw_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ọ -bụru l'unu jiru obu oyi; ngabẹru ojozi-imigwe ono nchị; l'emekota iphe, yẹbe Ojejoje sụru t'unu meje; bẹ ya a-bụru ọhogu ndu ọhogu unu; ẹphe adụ iya ashị; mbụ ndu unu dụ ashị. ");
INSERT INTO iqw_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ojozi iya e-vutaru unu ụzo; duru unu bahụ l'alị ndu Amọru; kẹ ndu Hetu; kẹ ndu Pẹ́rezu; kẹ ndu Kénanu; kẹ ndu Hevu; mẹ kẹ ndu Jebusu. Ya a-chịkolephu ndu ono mee t'ẹphe chịhu l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Unu be efozitajekwaru iphe, bụ iphe aagwa agwagwa; ọphu unu abajẹkwaru ẹphe ẹja; ọphu unu etsojekwaru ẹphe mee ome-l'alị ẹphe. Unu mebyishia agwa ẹphe; unu etsukposhia mkpuma, ẹphe doberu l'ẹnya-ngwẹja ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Unu bajẹru yẹbe Ojejoje, bụ Nchileke unu ẹja. Ya e-meru unu iphe-ọma lẹ nri; mẹ mini; bya ewofu ome-l'ẹhu l'ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ẹ to nwedu l'ẹpho alụfu madzụ l'alị unu; to nwe nwanyi, a-nọnu t'ọ tsụ ime. Ya e-me t'unu kajẹe nka lịkpahu alikpahu. ");
INSERT INTO iqw_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ya e-me t'a atsụje unu egvu. Iphe bụ mbakeshi, unu l'ẹphe alụ ọgu bẹ ya e-me; ẹphe emehu ririri. Ya emee ndu ọhogu unu l'ẹphe ha t'ẹphe ghakọbeje; gbaaru unu ọso. ");
INSERT INTO iqw_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ya e-zi evu t'o vuru unu ụzo je achịshiaru unu ndu Hevu; mẹ ndu Kénanu; mẹ ndu Hetu l'ụzo. ");
INSERT INTO iqw_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ọle ya ta achịfu-gedu ẹphe l'afa lanụ; kẹ l'alị ono a-bya abụru okorobo-ẹgu; anụ-ẹgu-ẹgbudu, nọ iya nụ aka unu ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ya a-tọkpelephu nwẹhu achịshi ẹphe; jeye teke unu a-ka l'igwe; dụ ike nwekotaru alị ono. ");
INSERT INTO iqw_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ya e-me tẹ ókè-alị unu tsube lẹ Eze Ẹnyimu Uswe je akpaa lẹ Eze Ẹnyimu Filisutayịnu; mẹ shita l'echi-ẹgu jeye lẹ Ẹnyimu Yufurétusu. Ya e-woru ndu alị ono ye unu l'ẹka; t'unu chịfu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Unu l'ẹphe ba agbakwa ndzụ; unu l'agwa ẹphe ta agba. ");
INSERT INTO iqw_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Unu be ekwekwa t'ẹphe buru l'alị unu; ọdumeka bẹ ẹphe a-kpatakwa t'unu mee ẹjo iphe meswee yẹbe Ojejoje. Kẹ l'unu -baaru agwa ẹphe ẹja; bẹ ọo-bụkwaru ọnya nmata unu.” ");
INSERT INTO iqw_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Tọ dụ iya bụ; Ojejoje asụ Mósisu tẹ yẹle Érọnu; Nadabu; Abihu; mẹ ndu bụ ọgurenya Ízurẹlu ẹphe ụkporo madzụ ẹto l'ụmadzu iri nyikfuta yẹbe Ojejoje; nọdu ote-ẹnya; baaru iya ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ọ bụ Mósisu nwẹnkinyi iya bụ onye a-byakfuta yẹbe Ojejoje; tẹ ndu ọphu be ejekwa iya ọkpirita ntse. Tẹ ndu Ízurẹlu be etsokwaru iya nyikota eli ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mósisu eje ekfukotaru ndu Ízurẹlu iphe, Ojejoje kfushiru; mẹ ekemu iya. Ẹphe atụko gude olu lanụ zụa; sụ: “L'iphe, bụ iphe, Ojejoje kfuru bẹ ẹphe e-mekota.” ");
INSERT INTO iqw_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mósisu abya atụko iphe, bụ iphe ono, Ojejoje kfuru ono dekota l'ẹkwo. Yo gbeshi l'ọnmewa ụtsu; bya akpụa ẹnya-ngwẹja l'ọkpa ugvu ono; bya akfụbe mkpuma iri l'ẹbo, nọ-chiru ẹnya ọkpa-ikfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yọ bya ezia ụnwu-okorọbya ndu Ízurẹlu; ẹphe eje egwooru Ojejoje ngwẹja-ukfuru; gbushikwaaphu ụnwu oke-eswi gude gwooru iya ngwẹja-ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mósisu abya ekee mee anụ ono ẹbo; woru ụzo lanụ wụru ye l'efere; bya ewota ọphu phee l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Yọ bya ewota Ẹkwo Ọgba-ndzụ ono gụaru ndu Ízurẹlu. Ẹphe azụa mgbede; sụ l'ẹphe a-nọdu angabẹru Ojejoje nchị; l'eme iphemiphe ọbule, o kfuru. ");
INSERT INTO iqw_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mósisu abya ewota mee ono phee ndu Ízurẹlu l'ẹhu; sụ: “Ọwaa bụ mee, ekoshi ndzụ, Ojejoje shi l'ekemu ono, ọ tụru ono; unu l'iya agbaa l'ẹge o kfuru.” ");
INSERT INTO iqw_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mósisu yẹle Érọnu; Nadabu; Abihu; mẹ ndu bụ ọgurenya Ízurẹlu ẹphe ụkporo madzụ ẹto l'ụmadzu iri abya enyihu eli ugvu ono; ");
INSERT INTO iqw_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","bya aphụa Nchileke kẹ ndu Ízurẹlu. Iphe o vudo l'eli iya bụ iphe e meru lẹ mkpuma, aswa nọ, eekuje sáfàyà; yo gbulephu samu l'ọ bụ akpamigwe. ");
INSERT INTO iqw_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ọphu ọ dụdu iphe, Nchileke meru ndu bụ ọgurenya Ízurẹlu ono. Ẹphe aphụ Nchileke; bya eria; ngụa. ");
INSERT INTO iqw_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ojejoje asụ Mósisu: “Nyikfuta iya l'ugvu-a bya anọdu l'ẹke-a tẹ ya nụ ngu mkpuma, dụ balịbali, ya deru ekemu; mẹ iphe, ya sụru t'ẹphe meje, a-nọduje akpọ-ziru ẹphe ụzo.” ");
INSERT INTO iqw_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ya ndono; Mósisu yẹle Jóshuwa, bụ onye anyajẹru iya ẹkpa ayịru tụgbua; je enyihu ugvu Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mósisu asụ ndu bụ ọgurenya ono: “Unu nọdu l'ẹke-a ngabẹru ẹphe jeye teke ẹphe a-byakfuta unu ọdo. Érọnu yẹle Huru bẹ unu l'ẹphe nọo l'ẹke-a; onye okfu dakfutaru; t'o jekfu ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mósisu enyihulephu ugvu ono; urukpu atsọ-kputa iya. ");
INSERT INTO iqw_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ọdu-biribiri Ojejoje abya atụko Ugvu Sáyịnayi ono ji. Urukpu ono anọo l'ugvu ono ujiku ishingu. Yo be lẹ mbọku k'ẹsaa; Ojejoje eshi l'urukpu ono kua Mósisu. ");
INSERT INTO iqw_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ndu Ízurẹlu bẹ ọdu-biribiri Ojejoje ono dụlephu l'ọ bụ ọku, enwu enwunwu l'eli ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mósisu enyia eli ugvu ono jeye teke urukpu ono kpuchitaru iya. Yọ nọo l'eli ugvu ono ụkporo abalị ugbo ẹbo: eswe l'ẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“T'o kfuaru ndu Ízurẹlu t'ẹphe wota iphe bya anụ yẹbe Ojejoje. Iphe, ọo-natajẹ bụ iphe, onye gude obu iya wota bya anụ. ");
INSERT INTO iqw_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Iphe, ẹphe a-nụje bụ mkpọla-ododo; mkpọla-ọcha; ope; ");
INSERT INTO iqw_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; ọkpobe òwúú ọcha; ẹji eghu; ");
INSERT INTO iqw_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","akpọ ebyila, a tsẹru l'uswe; akpọ umoro-ẹnyimu; oshi akesha; ");
INSERT INTO iqw_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","manụ olivu, ee-gudeje amụ ọku; iphe, eeyeje lẹ manụ k'ọwu l'ishi t'o shi mkpọ; ọphu eeyeje l'ínsẹnsu t'o shi kwẹkwekwe; ");
INSERT INTO iqw_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mkpuma ónìkùsù; mẹwaru mkpuma ọdo, aswa nọgbaa. Mkpuma ono bẹ ee-me gbapyabẹ l'uwe-ukuvu onye achịjeru Nchileke ẹja yẹle uwe-ọkpoma. ");
INSERT INTO iqw_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Kfuru ẹphe t'ẹphe rụaru yẹbe Ojejoje ụlo, dụ nsọ; tẹ ya buru l'ẹke ẹphe bu. ");
INSERT INTO iqw_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Unu mekwaa ụlo-ẹ́kwà ono yẹle iphemiphe ọbule, a-nọ l'ime iya t'ọ dụlephu ẹge ya e-koshi nggụbe Mósisu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“T'ẹphe gude oshi akesha gbaa okpoko. Tẹ ogologo iya dụ nkwo-ẹka labụ lẹ mkpirikpi iya. Ụsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. Eli iya adụkwaphu nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Wụa ọkpobe mkpọla-ododo l'ime iya; mẹ l'azụ iya. Nggu egudekwaphu mkpọla-ododo wụa lẹ mgberemẹku iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Nggu akpụta echi mkpọla-ododo ẹno hebe l'ọkpa iya ẹphe ẹno. Mbụ t'i wota ẹbo hebe l'ibe lanụ; wota ẹbo ọphu hebe l'ibe iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Gude oshi akeshia pyịta mgbọro labụ; wụa ya mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Nggu eworu mgbọro ono ẹphe ẹbo pyoshia l'echi ono, e hebetsuaru lẹ mgberemẹku okpoko ono t'ọ bụru iphe, ee-gudeje apa iya. ");
INSERT INTO iqw_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mgbọro ono a-nọduwaru l'echi okpoko ono. T'ẹ b'e wofukwa iya ewofu. ");
INSERT INTO iqw_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ọ bụ ekemu ono, yẹbe Ojejoje a-nụ ngu ono bẹ ii-dobe l'ime okpoko ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Gude ọkpobe mkpọla-ododo meta okfu okpoko; ẹke, aa-kfụje ụgwo iphe, dụ ẹji, madzụ meru. T'ogologo iya dụ nkwo-ẹka labụ lẹ mkpirikpi iya. Ụsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Nggu egude mkpọla-ododo mee cherobimu labụ, a-nọdutsua l'ishi okfu okpoko ono. T'ọ bụkwaru mkpọla-ododo, e tsusaru etsusa bẹ ii-gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Woru cherobimu lanụ dobe l'ishi lanụ; nggu eworu ọphu dobe l'ishi iya ọphu. Ii-me tẹ cherobimu labụ ono, nọtsua l'ishishi okpoko ono yẹle okpoko ono t'ẹphe bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherobimu ono bẹ ẹ́bà iya a-jakashịhu ajakashịhu laa imeli; gude kpuchita okfu okpoko ono. Cherobimu ono; bẹ ee-dobe; k'ọphu ẹphe a-gharu onwẹphe ifu; tụko l'ele ẹnya l'eli okpoko ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Nggu ewota okfu okpoko ono kpuchia ya; woru iphe ono, e deru ekemu yẹbe Ojejoje ono, bụ ọphu, ya e-mekochaa nụ unu ono; yekwaphu l'ime okpoko ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Yọ bụru l'eli okfu okpoko ono; mbụ lẹ mgbaku cherobimu labụ ono, nọ l'eli okpoko ono; bụ iya bụ ẹke ono, e doberu iphe, e deru ekemu iya ono bẹ ya a-byakfuta ngu bya ekfuru ngu iphemiphe ọbule, ndu Ízurẹlu e-meje. ");
INSERT INTO iqw_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Gude oshi akesha meta teburu. Tẹ ogologo iya dụ nkwo-ẹka labụ. Ụsa iya adụ nkwo-ẹka lanụ. Eli iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Nggu awụa ya ọkpobe mkpọla-ododo; bya egudekwaphu mkpọla-ododo wụa lẹ mgberemẹku iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Nggu ewota oshi, dụ gbịriri, ụsa iya ha l'ọ bụ ọbechere-ẹka swephee mgberemẹku iya mgburumgburu; nggu egudekwaphu mkpọla-ododo wụ-phee oshi ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kpụta echi mkpọla-ododo ẹno hebegbaa lẹ mgberemẹku ọkpa teburu ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Echi ono a-nọnyabetsukwaa oshi ono, dụ gbịriri ono; k'ọphu ọo-dụkwanu ike gudeshia mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ii-gude oshi akesha pyịshia mgbọro ono; wụa ya mkpọla-ododo t'ọ bụru mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nggu egude ọkpobe mkpọla-ododo meshia efere; ite; okoro; mẹ nkwọ-ẹka, aa-tụ-kobeje l'eli teburu ono. Iphe ono l'ọ ha bụ iphe, ee-gudeje gwooru yẹbe Ojejoje ngwẹja-mẹe. ");
INSERT INTO iqw_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tẹ eedobeje buredi l'ifu yẹbe Ojejoje. Ọ bụ l'eli teburu ono bẹ aa-tụ-kobeje iya; k'ọphu ọo-nọduje iya l'ifu tekenteke. ");
INSERT INTO iqw_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Gude ọkpobe mkpọla-ododo, e tsusaru etsusa mee iphe, ee-gvubeje urọku. Mee ya t'o nweru oshi; nweru ẹkali. Yo nweru efere; nweru nkwo iya; nweru iphe, dụ l'ọ bụ nwopu okoko-oshi; mẹ iphe, dụ l'ọ bụ igu oshi, jawaru ajaja. Tụkokwa iphe ono l'ọ ha mee tẹ yẹle iphe ono, eegvubeje urọku ono dzekfua bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Oshi iya ono e-nweru ẹkali ishingu: ẹto l'ẹka iya ọwaa; ẹto l'ẹka iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tẹ ẹkali iya ono nwejeru okoro ẹto. Okoro ono bẹ ee-metsua t'ọ dụgbaa l'ọ bụ igu-oshi alụmondu. E mekwaaphu nwopu okoko-oshi ye iya; ọwaa iphe, dụ l'ọ bụ igu oshi, jawaru ajaja. Yọ bụru ẹge ono bẹ ọo-dụkota l'ẹkali iya ono ẹphe ishingu, dzekfugbaaru l'oshi iya ono. ");
INSERT INTO iqw_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tẹ oshi iya ono nwekwaru okoro ẹno, e meru; yọ dụ l'ọ bụ igu alụmondu. Yo nwekwaruphu iphe, e meru; yọ dụ l'ọ bụ nwopu okoko-oshi; ọwaa iphe, dụ l'ọ bụ igu oshi, jawaru ajaja. ");
INSERT INTO iqw_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nwopu okoko-oshi lanụ bẹ ee-me t'ọ nọdu lẹ mkpuli ẹkali iya labụ ono k'alị. K'ẹbo anọdu lẹ mkpuli ẹkali iya labụ k'echi. K'ẹto anọdu lẹ mkpuli ẹkali iya labụ k'eli. Mbụ l'ọo-nọdutsua lẹ mkpuli ẹkali iya ono ẹphe ishingu. ");
INSERT INTO iqw_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nwopu okoko-oshi ono yẹle ẹkali iya ẹkali iya ono bẹ ee-me tẹ yẹle oshi iya tụko dzekfuru. Yọ bụru ọkpobe mkpọla-ododo, e tsusaru etsusa bẹ ee-gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Nggu emeta urọku ẹsaa gvubegbaa l'eli iphe ono, eegvubeje urọku ono. T'e dobekwa iya k'ọphu iphoro iya a-ngakọtaje ifu ẹke ọono. ");
INSERT INTO iqw_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ákpà iya; mẹ iphe, aagụjeru ọku iya ye bụkwa ọkpobe mkpọla-ododo bẹ ee-gude mekwaa ya phụ. ");
INSERT INTO iqw_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Iphe, eegvubeje urọku ono yẹle ngwa iya l'ọ ha bụ ụnu ọkpobe mkpọla-ododo ẹsaa l'ụkporo iri bẹ ee-gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Letakwa ẹnya t'e mee iphe ono l'ọ ha t'ọ dụ ẹge e koshiru ngu iya l'eli ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ii-meta ụlo-ẹ́kwà. Gude òwúú ọcha, a swịru l'ọ bụ ụdo; mẹ òwúú, eke urukpu-urukpu; ọphu eke uswuswe; mẹ ọphu eke mee-mee; kwee ẹkwa kweta iya ukfu-ẹkwa iri. T'onye maru ome nka gude òwúú ono kwee cherobimu ye l'ukfu-ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tẹ ukfu-ẹkwa ono tụkokwa hakọ ẹnya-nhamụnha. T'ogologo iya dụ nkwo-ẹka ụkporo l'ẹsato. Ụsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Wota ukfu-ẹkwa ono ise gbagbabe t'ọ bụru ishimishi lanụ; nggu ewotakwaphu ụzo ise ọphu gbagbabe; t'ọ bụru ishimishi lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ishimishi iya ono kẹ mbụ b'ii-gude òwúú, eke urukpu-urukpu yeshia ya nkolaba l'igbirimọnu ukfu-ẹkwa iya ono kẹ ikperazụ. Nggu emekwaaphu ẹge ono l'ukfu-ẹkwa kẹ ikperazụ l'ishimishi iya k'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Nkoloba ụkporo labụ l'iri bẹ ii-ye l'ishishi ishimishi lanụ; nggu eyekwaphu nkolaba ụkporo labụ l'iri l'ishishi ishimishi lanụ ọphu. Nkoloba ono a-chịko chegbabe ifu. ");
INSERT INTO iqw_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Gude mkpọla-ododo meta iphe, kweru nko ishi labụ ụzo ụkporo labụ l'iri. Nggu egude iya dzegbabe ishimishi ẹ́kwà ono ẹphe ẹbo t'ọ bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Nggu egude ẹji eghu kwee ẹ́kwà; kweta iya ukfu-ẹkwa iri lẹ nanụ, ee-gude phụ-chita eli ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tẹ ukfu-ẹkwa ono ẹphe iri lẹ nanụ tụkokwa hakọ ẹnya-nhamụnha. Tẹ ogologo iya dụ nkwo-ẹka ụkporo l'iri. Ụsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Chịta ukfu-ẹkwa ono ise gbagbabe t'ọ bụru ishimishi lanụ; nggu achịta ukfu-ẹkwa ishingu ọphu gbagbabẹkwaphu t'ọ bụru ishimishi lanụ. Ukfu-ẹ́kwà kẹ ishingu phụ; bẹ ịi-pyaji ẹbo t'o gboru l'ifu ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Nkoloba ụkporo labụ l'iri bẹ ii-ye l'ishishi ishimishi lanụ; nggu eyekwaphu nkolaba ụkporo labụ l'iri l'ishishi ishimishi lanụ ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nggu egude ope meta iphe, kweru nko ishi labụ ụzo ụkporo labụ l'iri. Nggu egude iya kotagbaa nkolaba ishimishi ẹ́kwà ono ẹphe ẹbo; gude iya dzegbabẹ ụlo-ẹ́kwà ono t'ọ bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","A bya l'ukfu-ẹkwa, tsufuru l'ụlo-ẹ́kwà ono; mbụ nkere-ẹbo l'ukfu-ẹkwa ono bẹ ee-me t'ọ wụ-zita l'azụ ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ishimishi ono, e gude phụ-chita ụlo-ẹ́kwà ono e-gude nkwo-ẹka lanụ ka k'ime iya phụ ụsa lẹ mgberemẹku iya ẹphe ẹbo. Ndu k'ono bẹ aa-ha t'ọ wụ-zita l'ụzo alị t'e gude iya kwechia mgberemẹku iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Nggu ewota akpọ ebyila, e meru; yo ke uswuswe; phụ-chia ụlo-ẹ́kwà ono ọdo. Nggu ewota akpọ umoro-ẹnyimu kwechita iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Gude oshi akesha rụshia oshi, ee-gudeje kpọbe ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Oshi ono bẹ aa-rụgbaa ogologo iya t'ọ dụ nkwo-ẹka iri. Ụsa iya adụ nkwo-ẹka lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Oshi ono bẹ aa-pyịtatsua ọkpa ye ẹka labụ. Yọ bụru ẹge ono bẹ ii-mekota oshi ụlo-ẹ́kwà ono l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","A bya l'ụlo-ẹ́kwà ono ibyiya ọphu gharu ifu l'ụzo ọhuda; bụ ụkporo oshi bẹ ịi-rụta; yeshia ya. ");
INSERT INTO iqw_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Nggu egude mkpọla-ọcha meshia ẹnya ẹke ee-gvubetsua oshi ono. Nggu emeta iya ụzo ụkporo labụ. Iphe bụ oshi ọphu nọnu e-nweru ẹnya ẹke ee-gvubeje iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A bya l'ibyiya ọphu; mbụ ibyiya ọphu gharu ifu l'ụzo isheli; bụkwaphu ụkporo oshi bẹ ịi-rụta; yeshia ya. ");
INSERT INTO iqw_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Gude mkpọla-ọcha meshia ẹnya ẹke ee-gvubetsua oshi ono ye. Nggu emeta iya ụzo ụkporo labụ. Iphe bụ oshi nọnu e-nweru ẹnya ẹke ee-gvubeje iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","A bya l'azụ ụlo-ẹ́kwà ono; mbụ ibyiya ọphu gharu ifu l'ụzo ẹnyanwu-arịba bụ oshi ishingu bẹ ịi-rụta; yeshia ya. ");
INSERT INTO iqw_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nggu arụshia oshi ẹbo ẹbo; yeshia l'iku iku ụlo-ẹ́kwà ono l'ụzo azụ iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Oshi labụ ono, ee-yeshi l'iku iya ono bẹ a-dụgbaa nkwegba ẹbo ẹbo. Oo-shi l'ụzo alị dụ nkwegba ẹbo jeye l'imeli. Yọ bụru echi lanụ bẹ aa-kụbe iya. Ẹphe ẹbo a-chịko dụkota ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ọo ya bụ l'ọo-dụ oshi ẹsato l'ụzo azụ ụlo-ẹ́kwà ono. T'e gude mkpọla-ọcha meshia ẹnya ẹke ee-gvubetsua oshi ono ye. Nggu emeta iya ụzo iri l'ishingu. Iphe bụ oshi nọnu e-nweru ẹnya ẹke ee-gvubeje iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Gude oshi akesha rashia oshi, dụgbaa gbịriri, ee-gude swebushia l'oshi ono. Ụzo ise bẹ ii-swebetsua l'oshi ẹka ụlo-ẹ́kwà ono ẹkalanu; ");
INSERT INTO iqw_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","nggu eswebekwaphu ụzo ise ọdo l'ẹka iya ọphu. Ụzo ise ọdo abụru k'azụ ụlo-ẹ́kwà ono; ibyiya ọphu gharu ifu l'ụzo ẹnyanwu-arịba. ");
INSERT INTO iqw_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Oshi ọphu dụ gbịriri, ee-swebe l'echi iya bẹ aa-pyị t'o shi l'ishi lanụ lụfu l'ishi iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Nggu awụkota mkpọla-ododo l'oshi ono, eegudeje kpọbe ụlo-ẹ́kwà ono. Nggu egudekwaphu mkpọla-ododo meshia echi, e-gudetsua gbịriri oshi ono. Nggu abya awụkwaaphu mkpọla-ododo lẹ gbịriri oshi ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Rụkwaa ụlo-ẹ́kwà ono ẹge a tụru ngu ọnu iya l'eli Ugvu Sáyịnayi. ");
INSERT INTO iqw_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Nggu egude òwúú, eke urukpu-urukpu; ọphu eke uswuswe; ọphu eke mee-mee yẹle k'ọcha, a swịru l'ọ bụ ụdo; kwee ẹ́kwà. T'onye maru ome nka gudekwa òwúú ono kwee cherobimu ye l'ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Nggu egude oshi akesha pyịa itso ẹno; wụa ya mkpọla-ododo. Nggu eworu itso ono kpọbetsua l'ẹnya ẹke e meshiru lẹ mkpọla-ọcha. Nggu egude iphe, kweru nko, e gude mkpọla-ododo mee kobe ẹkwa ono l'itso ono ");
INSERT INTO iqw_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","lẹ mkpuli iphe phụ, kweru nko ishi labụ phụ, e gude dzegbabe ishimishi phụ, e gude phụ-chita ụlo-ẹ́kwà ono. Nggu eworu Okpoko Ekemu ono sụbe l'ẹke ono, e gebutaru ẹ́kwà ono. Ẹkwa ono bẹ ee-gude kekahu Ẹke-dụ-Nsọ lẹ Ẹke-Kakọta-ọdu-Nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nggu ewota okfu okpoko ono, aakfụje ụgwo iphe, dụ ẹji, madzụ meru ono; kpube l'eli Okpoko Ekemu ono, a sụberu lẹ Ẹke-Kakọta-ọdu-Nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Nggu apata teburu phụ sụbe l'ifu ẹ́kwà ono, e gude gebuta Ẹke-Kakọta-ọdu-Nsọ ono. Ẹke aa-sụbe iya bụ l'ime ụlo-ẹ́kwà ono l'ibyiya ọphu gharu ifu l'ụzo isheli. Nggu eworu iphe ono, eegvubeje urọku ono gvube l'ibyiya ọphu gharu ifu l'ụzo ọhuda; t'ẹphe lẹ teburu phụ chegbabe ifu. ");
INSERT INTO iqw_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“A -bya l'ọnu ụlo-ẹ́kwà ono; t'e gude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; kwee ẹ́kwà gude kochita iya. ");
INSERT INTO iqw_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Nggu egude mkpọla-ododo meshia iphe, kweru nko, ee-gude kobe ẹ́kwà ono l'itso. Nggu egude oshi akesha pyịta itso ise; wụkwaa ya phụ mkpọla-ododo; gude ope kpụshia ẹnya ẹke aa-kpọbeje itso ono; ẹphe ise. ");
INSERT INTO iqw_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Gude oshi akesha rụta ẹnya-ngwẹja. Tẹ eli iya dụ nkwo-ẹka ẹto. Tẹ ogologo iya yẹle ụsa iya hakwaru ẹnya-nhamụnha. Iphe, ọo-dụtsua bụ nkwo-ẹka ise ise. ");
INSERT INTO iqw_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Nggu emeta mpo dobetsua l'ishi ishi iku iya ụzo ẹno. Tẹ mpo ono yẹle ẹnya-ngwẹja ono ragbabe aragbabe bụru nanụ. I -metsua; nggu eworu ope wụa ya. ");
INSERT INTO iqw_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nggu egude ope meshia iphe, bụ iphe, ee-gudeje eje ozi l'ẹnya-ngwẹja ono, bụ iya bụ ite okpo ntụ; mẹ iphe, eegudeje ekpo ntụ eye l'ite ono; mẹ efere; mẹ oji; ọwaa iphe, aagụje ọku. ");
INSERT INTO iqw_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Nggu egude ope meta iphe, dụ nggafu nggafu l'ọ bụ ụgbu; bya enweru mgberemẹku ẹno. Nggu egudekwaphu ope meta echi ẹno hebetsua lẹ mgberemẹku iphe ono. ");
INSERT INTO iqw_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Nggu ewota iphe ono kwechia ụzo alị mgberemẹku ẹnya-ngwẹja ono. T'e shi l'ụzo alị iya kwechia ya jeye l'echilabu iya. ");
INSERT INTO iqw_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nggu egude oshi akesha pyịta mgbọro labụ, ee-gudeje apa iya. Nggu awụkwaaphu ope lẹ mgbọro ono. ");
INSERT INTO iqw_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","T'e wotsuaru mgbọro ono nwua l'ẹnya echi phụ lẹ mgberemẹku iya ẹphe ẹbo. Mgbọro ono ẹphe ẹbo a-nọdujetsua lẹ mgberemẹku ẹnya-ngwẹja ono ẹphe ẹbo teke aapa iya apapa. ");
INSERT INTO iqw_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mekwaa ẹnya-ngwẹja ono tẹ ụzo nọdu iya l'echi. Nggu egude ibiribe oshi rụa ya; mee ya t'ọ dụ ẹge ono, ya koshiru ngu l'eli ugvu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Meeru ụlo-ẹ́kwà ono ogbodufu. Gude òwúú ọcha, a swịru l'ọ bụ ụdo; kwee ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo; gude gebuta ibyia ọphu ogbodufu ono gharu ifu l'ụzo ọhuda. ");
INSERT INTO iqw_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Nggu egude ope meta ụkporo itso, aa-kpọbe iya yẹle ẹnya ẹke aa-kpọbetsua itso ono. Nggu egude mkpọla-ọcha meshia iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono yẹle iphe, ee-swebe l'itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ụzo isheli iya bụkwaphu ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo bẹ ee-kwe; gude gebuta iya. Itso, aa-kpọbe l'ụzo isheli ono yẹle ẹnya ẹke aa-kpọbe itso ono a-dụtsua ụkporo ụkporo. Yọ bụkwaruphu ope bẹ aa-wụkota iya; bụkwanuru mkpọla-ọcha bẹ ee-gude meshia iphe, nweru nkolaba, ee-gude kobe ẹkwa l'itso ono yẹle iphe, ee-swebe iya. ");
INSERT INTO iqw_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“A -bya l'ụsa ogbodufu ono l'ụzo ẹnyanwu-arịba iya; bụkwa ẹkwa, dụ ụkporo nkwo-ẹka labụ lẹ nkwo-ẹka iri l'ogologo bẹ ee-kwe; gude gebuta iya. T'e meta itso iri, aa-kpọbe l'ụzo ẹnyanwu-arịba ono; metakwaphu ẹnya ẹke aa-kpọbetsua itso ono ụzo iri. ");
INSERT INTO iqw_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ụsa ogbodufu ono l'ụzo ẹnyanwu-ahata iya a-dụkwaphu ụkporo nkwo-ẹka labụ lẹ nkwo-ẹka iri l'ogologo. ");
INSERT INTO iqw_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","T'e kwee ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo; gude gebuta ọnu, ẹke e shi abata l'ogbodufu ono ẹke iya ọphu. Itso, aa-kpọbe iya yẹle ẹnya ẹke aa-kpọbetsua itso ono a-dụtsua ẹto ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","A -bya l'ẹke, eeshije abata ogbodufu ono ẹke iya ọphu; bụkwaphu ẹkwa, dụ nkwo-ẹka iri l'ise bẹ ee-kwe; gude gebuta iya. Itso, aa-kpọbe iya; yẹle ẹnya ẹke aa-kpọbetsua itso ono a-dụtsukwaaphu ẹto ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“T'e gude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe yẹle k'ọcha, a swịru l'ọ bụ ụdo; gude kwee ẹkwa, dụ nkwo-ẹka ụkporo l'ogologo; gude gechita ẹke eeshije abahụ l'ogbodufu ono. T'ọ bụkwaru onye maru ogude ngga kpaa ẹkwa bẹ e-eme iya nụ. Ẹke ono, eeshije abahụ iya ono bẹ ee-metaru itso ẹno; ọwaa ẹnya ẹno, aa-kpọbetsua itso ẹno ono. ");
INSERT INTO iqw_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Iphe, ee-swebegbaa l'itso, ee-gude kpọ-buta ogbodufu ono mgburumgburu yẹle iphe, nweru nkolaba, ee-gudegbaa kobe ẹkwa ono l'itso ono; bụkota mkpọla-ọcha bẹ ee-gude meta iya. Ẹnya nsụ, aa-kpọbetsua itso ono bẹ aa-wụkota ope. ");
INSERT INTO iqw_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ogbodufu ono a-dụ ụkporo nkwo-ẹka ise l'ogologo; dụ ụkporo nkwo-ẹka labụ l'iri l'ụsa. Ee-gude ẹkwa, e kweru l'òwúú ọcha, a swịru l'ọ bụ ụdo; gebuta iya. Eli ẹkwa ono a-dụ nkwo-ẹka ise; a wụkota ope l'ẹnya ẹke aa-kpọbetsua itso iya. ");
INSERT INTO iqw_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Iphe, bụ ngwa ọdo, ee-gude eje ozi l'ụlo-ẹ́kwà ono; m'o -ruhuru; ọ bụru ngụnu b'e gude iya eme; je akpaa lẹ nggu, ee-libegbaa eri ụlo-ẹ́kwà ono; mẹkwaphu kẹ ogbodufu ono bụ ope bẹ ee-gude mekota iya.” ");
INSERT INTO iqw_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Kfuaru ndu Ízurẹlu t'ẹphe wotaru ngu ọkpobe manụ olivu, e megheru emeghe; t'e yeje l'urọku; tẹ ọku urọku ono nwuje mkpụrumkpuru. ");
INSERT INTO iqw_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","T'ọ bụru Érọnu yẹle ụnwu iya e-yeje ọku l'urọku ono l'ifu Ojejoje l'ime Ụlo-Ẹ́kwà Ndzuko ono; mbụ l'azụ ẹkwa phụ, e gude kebuta Okpoko Ekemu phụ. T'ẹphe mejekwaa urọku ono t'o shi l'urẹnyashi nwua jeye l'ụtsu. Tẹ ndu Ízurẹlu dobekwa ekemu-a; shita l'ọgbo sweru ọgbo.” ");
INSERT INTO iqw_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“T'e shi lẹ ndu Ízurẹlu dufutaru ngu nwunne ngu, bụ Érọnu yẹle ụnwu iya; mbụ Nadabu; Abihu; Eliyéza; ọwaa Itama t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","T'a kwaaru nwunne ngu, bụ Érọnu uwe, dụ nsọ; t'e shi ẹge ono mee ya t'ọ dụ biribiri l'ẹnya; dụ ugvu. ");
INSERT INTO iqw_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kfuaru ndu maru ome nka; mbụ ndu ya nụru mmamiphe l'ụzo iya onanu; t'ẹphe kwaaru Érọnu uwe, ee-gude doo ya nsọ; k'ọphu ọo-bụru onye a-chịjeru yẹbe Ojejoje ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ọwaa egbe uwe, ẹphe a-kwashịru iya ndọ-ọ: uwe-ọkpoma; uwe-ukuvu; uwe-nlọkpuru; uwe ime-ẹhu; okpu-ẹkwa yẹle gbịriri ẹkwa-ukfu. T'ẹphe kwaaru nwunne ngu, bụ Érọnu; me ụnwu iya; uwe ono, dụ nsọ ono; t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Iphe, ẹphe e-gude kwee ẹkwa l'uwe ono bụ mkpọla-ododo, a tụru l'ọ bụ òwúú; mẹ òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru; yọ dụ l'ọ bụ ụdo. ");
INSERT INTO iqw_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“T'onye maru ome nka gude òwúú mkpọla-ododo; ọphu eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; dzụa uwe-ukuvu. ");
INSERT INTO iqw_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","T'a dzụa uwe ukuvu ono; woru gbịriri ẹkwa labụ ye iya l'ishi l'ukuvu iya ẹphe ẹbo. Eegudeje gbịriri ẹkwa ono ẹphe ẹbo ligbabe k'ifu yẹle k'azụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","T'e kwekwaaphu gbịriri ẹkwa, ee-gudeje kebuta iya l'ukfu ye iya. Gbịriri ẹkwa ono bẹ yẹle uwe ukuvu ono a-tụko bụru iphe lanụ. T'e gude òwúú mkpọla-ododo yẹle òwúú, eke urukpu-urukpu; ọphu eke mee-mee yẹle ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo. ");
INSERT INTO iqw_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Wota mkpuma ónìkùsù labụ; deshia ẹpha ụnwu Ízurẹlu l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Deshia ẹpha ono l'ẹge e gude mụa ẹphe. Ẹpha ishingu bẹ ii-de lẹ mkpuma lanụ. Nggu edee ẹpha ishingu ọphu lẹ mkpuma ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ọo ẹge onye apyịje mkpuma, vu oke aswa akashịje iya ẹpha; gude mee ya iphe-ọhubama bụ ẹge ịi-kakọta ẹpha ụnwu Ízurẹlu l'ẹphe ha lẹ mkpuma labụ ono. Nggu awụa mkpọla-ododo l'igburumọnu mkpuma ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Nggu adzụpyabe mkpuma labụ ono l'eli uwe-ukuvu phụ ẹphe ẹbo; k'ọphu yẹbe Ojejoje e-gudeje iya nyata ụnwu Ízurẹlu. Ẹpha ụnwu Ízurẹlu ono a-nọ l'ukuvu Érọnu ẹphe ẹbo t'ọ bụru iphe, ya e-gudeje nyata ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Nggu awụa mkpọla-ododo l'igburumọnu mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Nggu egude òwúú ọkpobe mkpọla-ododo swịta gwọgirigwo labụ; swịa ya t'ọ dụ l'ọ bụ onye swịru ụdo. Nggu eworu mkpa ono likfubetsua lẹ mkpọla-ododo ono, a wụru l'igburumọnu mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“T'onye maru ome nka kwee uwe-ọkpoma, ee-gudeje achọ iphe, bụ uche yẹbe Ojejoje. T'e gude iphe ono, e gude kwee uwe-ukuvu ono kwee ya; bụ iya bụ mkpọla-ododo, a tụru l'ọ bụ òwúú yẹle òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo. ");
INSERT INTO iqw_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","T'e kwekwaa ya t'o nweru mgberemẹku ẹno; dụ nkwegba labụ. Tẹ mgberemẹku iya ono ẹphe ẹno hakọkwa ẹnya-nhamụnha. T'ogologo iya dụ nkwo-ẹka lanụ; ụsa iya adụkwaphu nkwo-ẹka lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","“Dzụpyabe mkpuma, vugbaa oke aswa t'ọ kpọo giriri ụzo ẹno l'ẹ́kwà ono. Ọzo mkpuma kẹ mbụ bụ rubi; tópàzù; mẹ bérìlù. ");
INSERT INTO iqw_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","K'ẹbo bụ tọ̀kwásù; sáfàyà; mẹ émèràlùdù. ");
INSERT INTO iqw_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","K'ẹto abụru jásìntù; ágètù; ọwaa ámìtìsùtù. ");
INSERT INTO iqw_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","K'ẹno abụru kìrị́sòlàyìtù; ónìkùsù; mẹ jásụ̀pà. T'a wụa mkpọla-ododo l'igburumọnu mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Iphe, ọo-dụ bụ mkpuma iri l'ẹbo. Ẹphe l'ẹphe ha nanụ nanụ nọ-chitsuaru ẹpha ụnwu Ízurẹlu. T'e deshia ẹpha ụnwu Ízurẹlu ono lẹ mkpuma ono t'ọ dụ l'ọ bụ iphe-ọhubama nọ-chia ẹnya ọkpa-ikfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Nggu egude ọkpobe mkpọla-ododo swịshia gwọgirigwo, ee-likfubegbaa l'uwe-ọkpoma ono. T'a swịshia ya t'ọ dụ l'ọ bụ ụdo. ");
INSERT INTO iqw_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nggu egude mkpọla-ododo meta echi labụ; yetsua l'ishi uwe-ọkpoma ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nggu eworu gwọgirigwo phụ libetsua l'echi ono, e yegbaaru l'ishi uwe-ọkpoma ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nggu ewota ishi gwọgirigwo ono ishi iya ọphu likfubekwaphu lẹ mkpọla-ododo phụ, a wụru l'igburumọnu mkpuma labụ phụ, e likfuberu l'eli uwe-ukuvu phụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Nggu egude mkpọla-ododo meta echi labụ ọdo; likfube l'ishi uwe-ọkpoma ọbu l'ụzo alị iya. Likfubekwa iya l'ime uwe-ọkpoma ọbu; ibyiya ọphu tukoru l'eli uwe-ukuvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Nggu egude mkpọla-ododo metafua echi ẹbo ọdo; libetsua l'ishishi gbịriri ẹkwa labụ phụ l'ụzo alị iya; mbụ gbịriri ẹkwa ono, e liberu l'eli uwe-ukuvu ono. Libekwa iya l'eli ẹke ono, a nmaru gbịriri ẹkwa, a tụ-butaru l'ukfu uwe-ukuvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Echi k'uwe-ọkpoma phụ bẹ ee-gude eri, e gude òwúú, eke urukpu-urukpu swịa; libetsua l'echi uwe-ukuvu ọbu; k'ọphu ọo-nọdu lẹ mgboro gbịriri ẹkwa, a tụ-butaru l'ukfu phụ; tẹ uwe-ọkpoma phụ ba anọdujekwa akụ lọkpalokpa l'eli uwe-ukuvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Ọo ya bụ; iphe bụ teke Érọnu abahụ lẹ Ẹke-dụ-Nsọ ono; ẹpha ụnwu Ízurẹlu anọdu iya l'obu; mbụ l'ẹpha ono a-nọdu l'uwe-ọkpoma, eegudeje achọ iphe, bụ uche-obu Nchileke; shi ẹge ono mee tẹ Ojejoje gudeje iya l'anyata ẹphe tekenteke. ");
INSERT INTO iqw_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Nggu eyekobefukwaaphu ido Urimu mẹ Tumimu l'uwe-ọkpoma ono; t'ọ tụ-kojeru Érọnu l'obu iphe bụ teke ọobya Ojejoje l'ifu. Ẹge ono bẹ Érọnu e-gudeje paru iphe, eegudeje achọ iphe, bụ uche-obu Nchileke l'ẹhu ndu Ízurẹlu bya Ojejoje l'ifu tekenteke. ");
INSERT INTO iqw_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Gude ẹkwa, dụ urukpu-urukpu kwee uwe-nlọkpuru, ee-yeje uwe-ukuvu ono l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kwekwaa ya tẹ ẹke eepyoje iya ishi nọdu iya l'echilabu. Nggu eswia igburumọnu iya ẹge eeswije olu uwe-a; t'ẹ b'ọ lakahụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gude òwúú, eke urukpu-urukpu; ọphu eke mee-mee yẹle ọphu eke uswuswe; kpatagbaa akpụru ụtara-okumu; dophee ọnu uwe ono mgburumgburu. Nggu egudekwaphu mkpọla-ododo meshia mgbịrigba gude dokahu iya edokahu. ");
INSERT INTO iqw_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Tẹ mgbịrigba mkpọla-ododo ono; mẹ ụtara-okumu ono; nọ-phekwaa igburumọnu uwe ono mgburumgburu. T'e dongakota ẹphe edonga l'ọnu uwe ono. ");
INSERT INTO iqw_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Tẹ Érọnu yeje iya teke ooje ozi l'ifu Ojejoje; t'ẹ b'ọ nwụhu. Ọda mgbịrigba ono bẹ aa-nọduje anụ teke ọobahu lẹ Ẹke-dụ-Nsọ ono l'ifu Ojejoje ono; mẹ teke ọolufuta alụfuta. ");
INSERT INTO iqw_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Gude ọkpobe mkpọla-ododo meta iphe, dụ l'ọ bụ ekwekwerekwe; dee ya iphe ẹge eedeje gude mee iphe-ọhubama. Iphe, ee-de iya bụ: ‘Onye-a dụru Ojejoje lẹ nsọ.’ ");
INSERT INTO iqw_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Nggu ewota eri, e gude òwúú, eke urukpu-urukpu swịa; libe l'iphe ono, dụ l'ọ bụ ekwekwerekwe ono; woru iya lipyabe l'ifu okpu-ẹkwa phụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Érọnu -kpuru okpu-ẹkwa ono; t'ọ nọdu iya l'egedege ifu; t'ọ bụru yẹbedua bẹ ọo-tụ-koru l'ishi; mbụ emeru, e meruru iphe, ndu Ízurẹlu doberu yẹbe Ojejoje nsọ; m'o -ruhuduru ọ bụru iphe, dụ ịdagha bẹ ẹphe doberu iya nsọ ọbu. Iphe ono, dụ l'ọ bụ ekwekwerekwe ono a-nọdujelephu Érọnu l'egedege ifu; t'iphe ono, e doberu nsọ ono dụkwanu yẹbe Ojejoje mma k'anata. ");
INSERT INTO iqw_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Nggu egude òwúú ọcha kwee uwe-ime-ẹhu phụ yẹle okpu-ẹkwa phụ. T'ọ bụkwaru onye maru ogude ngga kwee ẹkwa bẹ e-me gbịriri ẹkwa-ukfu phụ. ");
INSERT INTO iqw_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","A -bya lẹ k'ụnwu Érọnu; kweeru ẹphe uwe-ime-ẹhu yẹle gbịriri ẹkwa-ukfu; mẹ okpu ndu achịjeru Nchileke ẹja; t'e shi ẹge ono mee ẹphe t'ẹphe dụ biribiri l'ẹnya; dụkwaphu ugvu. ");
INSERT INTO iqw_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I -yetsulephu nwunne ngu Érọnu; mẹ ụnwu iya uwe ono; nggu awụa ẹphe manụ l'ishi; gude mee t'ẹphe bụru ndu achịjeru Nchileke ẹja. Nggu edobe ẹphe iche; t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Nggu egude ẹkwa ọcha metaru ẹphe nwịba, ẹphe e-yeje. T'ẹphe yeje iya t'o shi ẹphe l'ukfu rua ẹphe l'ụtakfu. ");
INSERT INTO iqw_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Tẹ Érọnu yẹle ụnwu iya yejekwa nwịba ono teke ẹphe abahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono; m'ọ bụ l'ẹphe ejeru yẹbe Ojejoje ozi l'ẹnya-ngwẹja Ẹke-dụ-Nsọ; k'ọphu ẹphe te emetadu iphe-ụta kpua onwẹphe; shi ẹge ono nwụshihu. “Tẹ ekemu ono dụkwaru Érọnu yẹle awa iya jeye lẹ tutu yoyo.” ");
INSERT INTO iqw_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Ọwaa iphe, ii-me gude dobe ẹphe nsọ; t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya ndọ-ọ: Kpụta nwa oke-eswi lanụ; mẹ ebyila ẹbo, ẹ te nwedu ẹke ntụpo nọ iya l'ẹhu; ");
INSERT INTO iqw_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","nggu egude witu, e gweru egwegwe, ẹ te yedu iphe, ekoje buredi; gude ghee buredi. Hatakwa iya phụ gwọkobe manụ; gude ghee akara. Nggu egudekwa iya phụ ghee ẹcha-mbeke, a gbashịru manụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nggu achịko iya gworu ye lẹ nkata pataru yẹbe Ojejoje; ẹphe l'oke-eswi phụ; mẹ ebyila ẹbo phụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Teke e metsuaru; nggu eduta Érọnu yẹle ụnwu iya bya l'ọnu Ụlo-Ẹ́kwà Ndzuko; gude mini ghụa ẹphe ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nggu achịta uwe ndu achịjeru Nchileke ẹja yee Érọnu. Vuru ụzo yee ya uwe ime-ẹhu phụ; tẹmanu nggu eyedu iya uwe-nlọkpuru phụ, ee-ye uwe-ukuvu l'eli iya phụ. Nggu abya teke ono bya eyee ya uwe-ukuvu ono l'onwiya; mẹfua uwe-ọkpoma phụ. Nggu egude gbịriri ẹkwa phụ, e kweru t'e gudeje tụ-buta uwe-ukuvu ono; gude tụ-buta iya. ");
INSERT INTO iqw_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Nggu ewota okpu-ẹkwa phụ kpube iya; wota iphe phụ, dụ l'ọ bụ ekwekwerekwe phụ, e doru nsọ phụ libe l'okpu ono. ");
INSERT INTO iqw_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nggu ewota manụ, aawụje l'ishi wụa ya l'ishi gude mee ya onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Nggu eduta ụnwu iya yeshia ẹphe uwe-nlọkpuru; ");
INSERT INTO iqw_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","bya eworu okpu ndu achịjeru Nchileke ẹja kpubegbaa ẹphe l'ishi. Nggu ewotakwaphu gbịriri ẹkwa-ukfu phụ; webegbaa Érọnu yẹle ụnwu iya l'ukfu. Ekemu, yẹbe Ojejoje tụru ẹphe bụ t'ẹphe bụru ndu achịjeru Nchileke ẹja jeye lẹ tutu yoyo. Ọ kwa ẹge ono bẹ ii-me Érọnu yẹle ụnwu iya t'ẹphe bụru ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Teke e metsuaru; nggu akpụta oke-eswi phụ gude bya l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. Tẹ Érọnu yẹle ụnwu iya byabẹ iya ẹka l'ishi; ");
INSERT INTO iqw_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","nggu anọdu Ojejoje l'ifu gbua ya l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Nggu emeta mee oke-eswi ono gude mkpụshi-ẹka ngu tee ya lẹ mpo, nọgbaa l'ẹnya-ngwẹja ono. Nggu eworu ọphu phọduru nụ wụshia l'ukfu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Meshikota iya ẹ̀bà, nọ iya l'iphe-ẹpho iya l'ọ ha. Nggu abọtakwaphu anyị iya; mẹ àkpụ̀rù-ose iya ẹphe ẹbo yẹle ẹ̀bà, nọkota iya nụ; kpọo ọku l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Anụ oke-eswi ono; mẹ akpọ iya yẹle nshị iya; bẹ ii-gude je akpọo ọku l'azụ ọdu ndu Ízurẹlu ono. Iphe ọ bụ bụ ngwẹja iphe dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Nggu akpụta ebyila phụ nanụ gude bya tẹ Érọnu yẹle ụnwu iya byabẹ iya ẹka l'ishi; ");
INSERT INTO iqw_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","nggu egbua ya; nata mee ya phedzuru lẹ mgberemẹku ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Nggu ebushia anụ ebyila ono ibiribe ibiribe; chịta iphe-ẹpho iya yẹle ọkpa iya; saa asasa. Nggu eworu iphe-ẹpho iya ono yẹle ọkpa iya ono; chịkobe l'ishi iya yẹle ibiribe ibiribe iya phụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nggu achịko anụ ebyila ono l'ọ ha kpọo ọku l'ẹnya-ngwẹja ono. Iphe ọ bụ kwa ngwẹja-ukfuru; bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Nggu akpụta ebyila ọphu gude bya tẹ Érọnu yẹle ụnwu iya byabẹkwa iya phụ ẹka l'ishi; ");
INSERT INTO iqw_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","nggu egbua ya; meta mee ya; tee Érọnu yẹle ụnwu iya l'atakpa-nchị ẹka-ụtara; ezeke-ẹka ẹka-ụtara; mẹ l'ezeke-ọkpa ẹka-ụtara. Nggu eworu mee ono phedzuru lẹ mgberemẹku ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Nggu emeta mee ono, sụru l'ẹnya-ngwẹja ono; metakwaphu manụ phụ, aawụje l'ishi phụ phedzuru Érọnu yẹle uwe iya; phedzukwaru iya phụ ụnwu Érọnu yẹle uwe ẹphe. Ọ bụ ẹge ono bẹ ee-shi mee tẹ Érọnu yẹle ụnwu iya; mẹ uwe ẹphe; dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ebyila ono bẹ ii-heshikota ẹ̀bà; hetatsua ẹ̀bà, nọ l'ukfumọdzu iya; mẹ ẹ̀bà, nọkota l'iphe-ẹpho iya l'ọ ha; bọtakwaphu anyị iya; ọwaa àkpụ̀rù-ose iya ẹphe ẹbo yẹle ẹ̀bà, nọkota iya nụ; wota ụtakfu ẹka-ụtara iya tụkwase iya. Ebyila ono bụkwa ọphu e gude eme Érọnu yẹle ụnwu iya t'ẹphe bụru ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nggu eje lẹ nkata ono, e yeru buredi, ẹ te gudedu iphe, ekoje buredi ghee ono, nọwa Ojejoje l'ifu ono; wota iya ishi buredi lanụ; hatakwaphu ishi akara lanụ l'akara ono, a gwọkoberu manụ ghee ono; ọwaa ishi ẹcha-mbeke lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Nggu atụko iphe ono l'ọ ha dẹe Érọnu yẹle ụnwu iya l'ẹka t'ẹphe woru iya maa Ojejoje l'ifu t'ọ bụru ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Teke e metsuaru; nggu anata ẹphe iphe ono l'ọ ha; chịta yẹle ngwẹja-ukfuru phụ kpọo ọku l'ẹnya-ngwẹja ono. T'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","E -metsua; nggu ewota ǹdụ́ ebyila ono, e gude mee Érọnu t'ọ bụru onye achịjeru Nchileke ẹja ono; maa Ojejoje l'ifu t'ọ bụru ngwẹja-amama. Ono a-bụru oke iya nke ngu. ");
INSERT INTO iqw_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Anụ ebyila ono, e gude mee Érọnu t'ọ bụru onye achịjeru Nchileke ẹja ono bẹ ii-do nsọ; mbụ ẹke ono, ruberu Érọnu yẹle ụnwu iya ono; bụ iya bụ ǹdụ́ iya phụ, a màru àmàmà phụ; mẹ ụtakfu iya phụ, e doberu yẹbe Ojejoje phụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ndu Ízurẹlu -gude iphe ẹja bya; tẹ ǹdụ́ iya; mẹ ụtakfu iya bụjekwaru oke, aa-hẹjeru Érọnu yẹle ụnwu iya. Ono bụ òkè-iphe ọphu ndu Ízurẹlu e-dobejeru yẹbe Ojejoje iche mẹ ẹphe bya ogwo ngwẹja-ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Uwe, dụ nsọ kẹ Érọnu a-bụkwaruphu k'awa iya. Yọ bụru uwe ono bẹ ẹphe e-yeje teke aawụ ẹphe manụ gude eme ẹphe t'ẹphe bụru ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Tẹ nwa Érọnu onye ọphu eeme t'ọ nọ-chia ẹnya iya l'ọ bụ onye achịjeru Nchileke ẹja jeje lẹ Ụlo-Ẹ́kwà Ndzuko je ejee ozi lẹ Ẹke-dụ-Nsọ ono; yejekwa uwe ono abalị ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Wota anụ ebyila ono, e gude mee Érọnu; yọ bụru onye achịjeru Nchileke ẹja ono; shia l'ẹke dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Tẹ Érọnu yẹle ụnwu iya nọdu l'ọnu Ụlo-Ẹ́kwà Ndzuko taa anụ ebyila ono; mẹ buredi phụ, e yeru lẹ nkata phụ. ");
INSERT INTO iqw_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ọ kwa ẹphebedua a-ta anụ ngwẹja ono, e gude kfụa ụgwo iphe, dụ ẹji ẹphe teke ono, aawụ ẹphe manụ l'ishi ono; e shi ẹge ono dobe ẹphe nsọ t'ẹphe bụru ndu achịjeru Nchileke ẹja. T'ẹ b'ọ dụkwa onye ọdo, a-ta iya nụ; kẹ l'ọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ọ -bụru l'o nweru anụ ebyila ono, e gude mee Érọnu; t'ọ bụru onye achịjeru Nchileke ẹja ono; m'ọ bụ buredi phụ; ọphu a taphodoru; yọ kwaa akwakwa lụfuta l'ụtsu; t'a akpọkwaa ya ọku. T'ẹ b'ọ dụkwa onye a-ta iya nụ; kẹ l'ọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Meeru Érọnu yẹle ụnwu iya iphe, ya tụru ngu ekemu sụ t'i meeru ẹphe. Gude abalị ẹsaa mee ẹphe t'ẹphe bụru ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Gbujekwa oke-eswi mbọku-mbọku l'ime abalị ẹsaa ono t'ọ bụru ngwẹja, e gude akfụ ụgwo iphe, dụ ẹji. Ọ kwaphụ ẹge ono bẹ ii-gwo ngwẹja gude kfụa ụgwo iphe, dụ ẹji; shi ẹge ono safu mmeru, nọ l'ẹnya-ngwẹja ono. Nggu awụkwaa ya phụ manụ gude mee ya t'ọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Gude abalị ẹsaa gwoo ngwẹja, e gude akfụ ụgwo iphe, dụ ẹji; shi ẹge ono safu mmeru, nọ l'ẹnya-ngwẹja ono; k'ọphu ọo-dụ nsọ; iphe, bụ iphe, ruru iya nụ a-dụkwaphu nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Iphe, ii-gudeje egwo ngwẹja ono l'ẹnya-ngwẹja ono mbọku-mbọku kwa ụnwu atụru labụ, gbagbaaru afa. ");
INSERT INTO iqw_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","I -gbua nanụ l'ụtsu; nggu egbua nanụ l'urẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Atụru kẹ mbụ phụ bẹ ii-yekobeje witu, e gweru egwegwe je agbaa; mbụ ụzo lanụ l'ụzo iri ogbonga witu, a gwọkoberu manụ olivu, a tsụru l'ikwe, jiru konggo labụ. Nggu ewotakwaphu mẹe, jiru konggo labụ; ye iya t'ọ bụru ngwẹja-mẹe. ");
INSERT INTO iqw_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","O -be l'urẹnyashi; nggu akpụta atụru ọphu gbua. Nggu eyekobekwa iya phụ ngwẹja-nri; mẹ ngwẹja-mẹe ẹge e yeru l'ụtsu phụ; t'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“T'e gwojekwa ngwẹja-ukfuru-a tekenteke l'ọnu Ụlo-Ẹ́kwà Ndzuko, bụ iya bụ l'ifu yẹbe Ojejoje; shita l'ọgbo sweru ọgbo. Ọ bụ l'ẹke ono bẹ ya a-byakfutaje ngu bya ekfuru yeru ngu. ");
INSERT INTO iqw_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ọ bụkwaphu l'ẹke ono bẹ ya a-byakfuta ndu Ízurẹlu; ọdu-biribiri iya emee ẹke ono; yọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Yọ bụru ẹge ono bẹ ya e-shi mee tẹ Ụlo-Ẹ́kwà Ndzuko ono yẹle ẹnya-ngwẹja ono dụ nsọ; mekwaaphu tẹ Érọnu; yẹle ụnwu iya; dụ nsọ; bụru ndu achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Teke ono; ya eburu l'ẹke ndu Ízurẹlu bu; bụru Nchileke ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ẹphe amaru l'ọ bụ yẹbedua bụ Ojejoje, bụ Nchileke ẹphe; onye dufutaru ẹphe l'alị Íjiputu; k'ọphu ya e-buru l'ẹke ẹphe bu. Ọ kwa yẹbedua bụ Ojejoje, bụ Nchileke ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Gude oshi akesha kụa ẹnya-ngwẹja, bụ ẹke aa-kpọje ínsẹnsu ọku. ");
INSERT INTO iqw_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","T'ogologo iya mẹ ụsa iya hakwaru ẹnya-nhamụnha. Iphe, ọo-bụru bụ nkwo-ẹka lanụ. Eli iya adụ nkwo-ẹka ẹbo. Tẹ mpo iya yẹle ẹnya-ngwẹja ono ragbabe bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Wụkotakwa ọkpobe mkpọla-ododo l'eli iya yẹle mgberemẹku iya; mẹ mpo iya. Nggu egudekwaphu mkpọla-ododo kpụ-phee mgberemẹku iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nggu emeta echi mkpọla-ododo ẹbo ẹbo yegbaa lẹ mgberemẹku iya ẹphe ẹbo. Yekwaa ya t'ọ nọdutsua lẹ mkpuli iphe ono, a kpụ-pheru iya mgburumgburu ono. Ọ bụ l'echi ono bẹ ee-yeje mgbọro, ee-gudeje apa iya. ");
INSERT INTO iqw_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gude oshi akesha pyịta mgbọro ono; nggu awụa ya mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Dobe ẹnya-ngwẹja ono l'ifu ẹ́kwà phụ, e gude gechita Okpoko Ekemu phụ; mbụ okfu okpoko phụ, aa-nọduje akfụ ụgwo iphe, dụ ẹji phụ, e gude kpuchia Okpoko Ekemu phụ. Ọ bụ ẹke ono bẹ ya a-byakfutaje ngu. ");
INSERT INTO iqw_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Tẹ Érọnu kpọjekwa ínsẹnsu, eshi mkpọ ọku l'ẹnya-ngwẹja ono l'ụtsu m'o jeshia omezi urọku phụ. ");
INSERT INTO iqw_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","T'ọ kpọjekwaphu ínsẹnsu ọku l'ẹnya-ngwẹja ono l'urẹnyashi m'o jeshia oye ọku l'urọku ono; k'ọphu ọku ínsẹnsu a-nọduje enwu Ojejoje l'ifu shita l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Une be egudekwa ínsẹnsu ọdo; ngwẹja-ukfuru ọdo; ngwẹja-nri ọdo; m'ọ bụ ngwẹja-mẹe ọdo, bya egwogwo l'ẹnya-ngwẹja-a. ");
INSERT INTO iqw_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ugbo lanụ l'afa bẹ Érọnu e-teje mee lẹ mpo ẹnya-ngwẹja ono gude kfụa ụgwo iphe, dụ ẹji. Ọ kwa mee anụ ngwẹja-iphe, dụ ẹji, e gude akfụ ụgwo iphe, dụ ẹji bẹ ee-teje lẹ mpo ono afa l'afa. T'e mejekwa iya ẹge ono shita l'ọgbo sweru ọgbo. Ẹke ono bụkwa ẹke katsụa ọduru yẹbe Ojejoje nsọ.” ");
INSERT INTO iqw_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Teke ịi-gụ ndu Ízurẹlu ọgu t'ị maru ẹge ẹphe ha; t'onyenọnu kfụjekwa yẹbe Ojejoje aswa ishi onwiya gude gbata onwiya; m'a gụ l'iya phụ; t'ẹ b'ọ dụ ẹjo iphe-ẹhuka, a-byakfuta ẹphe teke aa-nọdu agụ ẹphe ọgu ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","T'onye a gụru kfụjekwa nkere-ẹbo mkpọla-ọcha; tẹmanu yo jekfube ndu ọphu a gụhawaru. Tẹ nkere-ẹbo mkpọla-ọcha ono, onye ono a-nụ ono bụkwaru ọphu ha l'ọ bụ k'eze-ụlo yẹbe Nchileke. Mkpọla-ọcha ono b'e -jeshia ya ebubu; e buta iya ụkporo. Tẹ nkere-ẹbo mkpọla-ọcha ono bụkwaru iphe, ee-doberu yẹbe Ojejoje iche. ");
INSERT INTO iqw_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Iphe bụ onye a gụru ọgu; shita l'onye nọru ụkporo afa jeye bẹ a-nụ yẹbe Ojejoje iphe. ");
INSERT INTO iqw_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Teke unu anụ yẹbe Ojejoje iphe gude akfụ ụgwo iphe, dụ ẹji, unu meru; tẹ ndu nweru iphe ba anụghatakwa nkere-ẹbo mkpọla-ọcha; ọphu ndu ụkpa anụ-petekwa. ");
INSERT INTO iqw_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nata okpoga ndu Ízurẹlu ono, e gude akfụ ụgwo iphe, dụ ẹji ẹphe ono; gude jee ozi lẹ Ụlo-Ẹ́kwà Ndzuko ono. Ọ bụ iphe ono bẹ yẹbe Ojejoje e-gudeje l'anyata ndu Ízurẹlu; bụru iya bẹ ee-gude kfụa ụgwo iphe, dụ ẹji, ẹphe meru.” ");
INSERT INTO iqw_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Gude ope mee eze efere, ee-gudeje ghụa ẹhu. Ọ kwaphụ ope bẹ ee-gude mee ọkpa eze efere ono. Nggu asụbe iya l'echi Ụlo-Ẹ́kwà Ndzuko ono yẹle ẹnya-ngwẹja ono; kuru mini ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","T'ọ bụru mini ono bẹ Érọnu yẹle ụnwu iya e-gudeje kwọo ẹka; mẹ ọkpa. ");
INSERT INTO iqw_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Teke ẹphe abahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono; m'ọ bụ l'ẹphe ejenyabe ẹnya-ngwẹja ono; ọnu yẹbe Ojejoje ngwẹja-ọku; t'ẹphe kwọshijekwa onwẹphe mini; k'ọphu ẹphe ta anwụshihudu. ");
INSERT INTO iqw_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","T'ẹphe kwọjekwaaphu ẹka; kwọo ọkpa; k'ọphu ẹphe ta anwụshihudu. Ono bụ ekemu, a-nọduru Érọnu yẹle awa iya; shita l'ọgbo sweru ọgbo.” ");
INSERT INTO iqw_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Gwota ọkpobe iphe, eshi mkpọ gude bya. Iphe ii-gude bya bụ: Mẹeru mini ọphu ẹra iya dụ ụnu shẹkelu l'ụkporo shẹkelu ise; mẹ sinamọnu, eshi mkpọ ọphu ẹra iya dụ ụkporo shẹkelu iri l'ẹbo lẹ shẹkelu iri, bụ iya bụ nkere-ẹbo mẹru phụ; mẹ oshi ọmanko, eshi mkpọ ọphu ẹra iya dụ ụkporo shẹkelu iri l'ẹbo lẹ shẹkelu iri; ");
INSERT INTO iqw_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","mẹ kashiya ọphu ẹra iya dụ ụnu l'ụkporo iri. Iphe ono l'ọ ha bụ iphe, eegudeje atụ ẹra iphe l'eze-ụlo yẹbe Nchileke bẹ ee-gude tụa ya. Nggu ewotakwaphu manụ olivu, jiru konggo ẹsato. ");
INSERT INTO iqw_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","T'onye maru ome manụ-mbeleke tụko iya l'ọ ha gwakọbe t'ọ bụru manụ, dụ nsọ l'eshi mkpọ, aawụje l'ishi. Ọo-bụru manụ, dụ nsọ, aa-wụje l'ishi. ");
INSERT INTO iqw_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Nggu egude manụ ono wụkota lẹ Ụlo-Ẹ́kwà Ndzuko; mẹ Okpoko Ekemu; ");
INSERT INTO iqw_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mẹ teburu yẹle ngwa iya l'ọ ha; mẹ iphe eegvubeje urọku yẹle ngwa iya l'ọ ha; mẹ ẹnya-ngwẹja ínsẹnsu; ");
INSERT INTO iqw_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mẹ ẹnya-ngwẹja, bụ ẹke ee-gwoje ngwẹja-ukfuru yẹle ngwa iya l'ọ ha; mẹ eze efere yẹle ọkpa iya. ");
INSERT INTO iqw_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Iphe ono l'ọ ha bẹ ii-dobe iche; t'ọ bụru iphe, kakọta ọdu nsọ; k'ọphu iphe, bụ iphe denyiru iya nụ a-dụkwaphu nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Wụa Érọnu yẹle ụnwu iya manụ l'ishi; nggu edoo ẹphe nsọ; k'ọphu ẹphe a-bụru ndu achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kfuaru ndu Ízurẹlu l'ọwaa bụ manụ, dụ nsọ yẹbe Ojejoje, aa-wụje madzụ l'ishi shita l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","T'ẹ b'a wụjekwa iya madzụ mmanu; ọphu aagwajẹkwa manụ ọdo t'ọ dụ l'ọ bụ ọwaa. Ọ kwa manụ, dụ nsọ. Ọo ya bụ t'e dobeje iya nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","O -nweru onye gwaru manụ ọdo; yọ dụ l'ọ bụ manụ ọwaa; m'ọ bụ l'ọ wụru iya madzụ mmanu l'ishi, abụdu onye achịjeru Nchileke ẹja; t'e bufukwa onye ọbu lẹ ndu nk'iya.” ");
INSERT INTO iqw_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ya ndono; Ojejoje asụ Mósisu: “Wota iphe, eshi mkpọ gude bya. Iphe ii-wota bụ: etse; onika; galubanumu; mẹ ọkpobe furakínsẹnsu. Tụa ya l'iphe, eegudeje atụ ẹra iphe t'ọ hakọta ẹnya-nhamụnha. ");
INSERT INTO iqw_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","T'onye maru ome manụ-mbeleke tụko iphe ono l'ọ ha gwakọbe t'ọ bụru ínsẹnsu, eshi mkpọ. T'a pyashi iya únú. T'ọ bụkwaru iphe ono, a gụshiru ono nkịnyi iya; bẹ ee-gude mee ínsẹnsu ọbu. Ọo-bụru ínsẹnsu, dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Haru iya gwee egwegwe dobe l'ifu Okpoko Ekemu, nọ lẹ Ụlo-Ẹ́kwà Ndzuko, bụ iya bụ ẹke ono, ya a-byakfuta unu ono. T'ọ bụkwaru unu ínsẹnsu, kakọta ọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Unu be emekwa ínsẹnsu nk'unu t'ọ dụ l'ọ bụ ọwaa. Unu doberu iya yẹbe Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ọ -bụru l'o nweru onye meru ínsẹnsu ọdo, dụ l'ọ bụ ọwaa doberu onwiya l'ọ bụ manụ-mbeleke; t'e bufukwa iya lẹ ndu nk'iya.” ");
INSERT INTO iqw_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Lekwa; ya fọtawaru Bezalẹlu Úri Họru, bụ onye ikfu Júda; ");
INSERT INTO iqw_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","bya emewa; tẹ ume Nchileke ji iya ẹhu; k'ọphu oo-nweru mmamiphe; kwaa ẹnya; bụru onye iphe edoje iya ẹnya ọhuma l'ome nka l'iphemiphe ọbule; ");
INSERT INTO iqw_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","t'ọ maru ẹge eeshije gude mkpọla-ododo yẹle mkpọla-ọcha; mẹ ope ememashi iphe ememashi; ");
INSERT INTO iqw_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","makwarụphu ẹge aawajẹ mkpuma, aswa nọ; mẹ ẹge aawụje mkpọla-ododo l'igburumọnu iya; bya amakwarụphu ẹge aapyịje iphe apyịpyi; mẹwaru ẹge eeshije emekota nka ọdo, dụgbaa iche iche. ");
INSERT INTO iqw_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ya fọtafukwaaruphu Oholiyabu Ahisamaku, bụ onye ikfu Dánu; t'o yeru iya ẹka. Ndu maru ome nka l'ẹphe ha bẹ ya nụkotakwaruphu ike t'ẹphe mekota iphemiphe ọbule, ya sụru t'unu mee; ");
INSERT INTO iqw_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","dụnua l'ọ bụ Ụlo-ẹ́kwà Ndzuko; Okpoko Ekemu yẹle okfu okpoko ono, aanọduje akfụ ụgwo iphe, dụ ẹji ono; mẹwaru iphemiphe ọbule ọdo, eegudeje eje ozi l'ime ụlo-ẹ́kwà ono; ");
INSERT INTO iqw_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bụ iya bụ teburu yẹle ngwa iya l'ọ ha; mẹ iphe eegvubeje urọku, e meru l'ọkpobe mkpọla-ododo yẹle ngwa iya l'ọ ha; mẹ ẹnya-ngwẹja ínsẹnsu; ");
INSERT INTO iqw_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","mẹ ẹnya-ngwẹja-ukfuru yẹle ngwa iya l'ọ ha; mẹ eze efere ono yẹle ọkpa iya; ");
INSERT INTO iqw_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","wafụa uwe, e kweru ekwekwe; mbụ uwe, dụ nsọ, Érọnu, bụ onye achịjeru Nchileke ẹja e-yeje; mẹ uwe, ụnwu iya e-yeje gude eje ozi ndu achịjeru Nchileke ẹja; ");
INSERT INTO iqw_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mẹ manụ ọwu l'ishi; mẹ ínsẹnsu, eshi mkpọ kẹ Ẹke-dụ-Nsọ ono. Ọ bụlephu t'ẹphe mee ya t'ọ dụ ẹge ya sụru ngu t'e mee ya.” ");
INSERT INTO iqw_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Kfuaru ndu Ízurẹlu t'ẹphe dobeje mbọku ọtu-ume yẹbe Ojejoje. Kẹ l'ọo-bụru iphe-ọhubama, nọduru unu l'iya tsube l'ọgbo sweru ọgbo. Ọo ya bụ t'unu maru l'ọ bụ yẹbedua bụ Ojejoje, bụ onye emeje unu t'unu dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Unu nyatajẹ mbọku ọtu-ume; kẹle mbọku ono dụru unu lẹ nsọ. O -nweru onye dakaru iya nụ; t'e gbukwaa onye ọbu egbugbu. Iphe bụ onye jeru ozi mbọku ono bẹ ee-bufu ebufu lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ọ bụ abalị ishingu bẹ unu e-gudeje jee ozi unu. Mbọku k'ẹsaa bụ mbọku ọtu-ume; bya abụru mbọku, dụru yẹbe Ojejoje lẹ nsọ. Iphe bụ onye jeru ozi lẹ mbọku ọtu-ume; t'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Tẹ ndu Ízurẹlu dobeje mbọku ọtu-ume; mee ekemu iya shita l'ọgbo sweru ọgbo; t'ọ bụru iphe, a-nọdu ekoshi ọgba-ndzụ unu l'iya gbururu jeyewaru. ");
INSERT INTO iqw_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ọo-bụru iphe-ọhubama nọduru yẹle ndu Ízurẹlu jeye lẹ tutu yoyo; kẹ l'ọ bụ abalị ishingu bẹ yẹbe Ojejoje gude mee igwe yẹle alị. Yo be mbọku k'ẹsaa; ya ahaa ozi; tụta ume.” ");
INSERT INTO iqw_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ya ndono; Ojejoje ekfugetsulephu nụ Mósisu l'eli Ugvu Sáyịnayi; bya anụ iya ekwekwerekwe mkpuma labụ, e deru Ekemu. Mkpuma ono bụ Nchileke nwẹke-iya gude ẹka iya dee ya iphe. ");
INSERT INTO iqw_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Teke ndu Ízurẹlu leru ẹnya bya aphụ lẹ Mósisu anọnukawa ọdu l'eli ugvu ono; ẹphe abya agbaphee Érọnu mgburumgburu; sụ iya: “Ngwaa; t'o metaru ẹphe Nchileke, a-nọdu edu ẹphe! Lẹ Mósisu-a, dufutaru ẹphe l'alị Íjiputu-a bẹ ẹphe ta makwa iphe, meru iya nụ.” ");
INSERT INTO iqw_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Érọnu asụ ẹphe t'ẹphe yeshia iphe-nchị mkpọla-ododo, unyomu ẹphe yeru lẹ nchị; mẹ kẹ ụnwu ẹphe unwoke; mẹ k'ụnwu ẹphe ụnwanyi; chịtaru iya. ");
INSERT INTO iqw_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ya ndono; ndu ono l'ẹphe ha abya eyeshia iphe-nchị ẹphe; chịjeru Érọnu. ");
INSERT INTO iqw_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Yọ chịta iphe ono, ẹphe nụru iya ono gude kpụta agwa; yọ dụ l'ọ bụ nweswi. Yọ bya egude ngwa-ọru memashia ya ememashi. Ya ndono; ẹphe asụ: “Unubẹ ndu Ízurẹlu; ọwaa Nchileke unu ndọ-ọ; mbụ onye dufutaru unu l'alị Íjiputu!” ");
INSERT INTO iqw_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Érọnu aphụlephu iphe ono bya akpụa ẹnya-ngwẹja l'ifu nweswi ono bya araa ya arara; sụ: “Echile bẹ aa-gbaru Ojejoje ajị-o!” ");
INSERT INTO iqw_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tọ dụ iya bụ; yo be echile iya; ndu Ízurẹlu etehu l'ụtsu; bya egwoo ngwẹja-ukfuru; mẹ ngwẹja ẹhu-agu. E metsua; ẹphe abya anọshia ria; ngụa; bya awụ-lihu; wata ome k'ẹnyishi. ");
INSERT INTO iqw_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ya ndono; Ojejoje asụ Mósisu: “Nyizita l'alị; kẹle ndu nke ngu ono; mbụ ndu ono, i dufutaru l'alị Íjiputu ono bẹ merushiakwaru onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ẹphe hakebewaru ekemu ono, ya tụru ẹphe ono; metawaru onwẹphe agwa, ẹphe kpụru; yọ dụ l'ọ bụ nweswi. Ẹphe fuzitawaru ishi baaru iya ẹja; bya agwawa iya agwagwa; sụ: ‘Unubẹ ndu Ízurẹlu; ọwaa Nchileke unu ndọ-ọ; mbụ onye dufutaru unu l'alị Íjiputu ono!’ ” ");
INSERT INTO iqw_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ojejoje asụ Mósisu: “Ya phụwaru lẹ ndu-a bụnukaru ndu obu-kpọkponyi. ");
INSERT INTO iqw_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Pakwaru yẹbe Ojejoje haa tẹ ya gude oke ẹhu-eghughu iya dakfu ẹphe; kpukpoo ẹphe. Nggụbedua, bụ Mósisu bẹ ya e-me ọha, ha nshinu.” ");
INSERT INTO iqw_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mósisu arọlahaa Ojejoje, bụ Nchileke iya; sụ iya: “Byiko Ojejoje; t'ẹhu be eghunukakwa ngu eghughu ẹge ono l'ẹke ndu nke ngu nọ; mbụ ndu ono, i gude ike-ẹka ngu dufuta lẹ Íjiputu ono! ");
INSERT INTO iqw_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ndu Íjiputu a-sụkwa l'iphe, kparu iphe, i dufutaru ẹphe bụ t'ị bya egbushia ẹphe l'ugvu ugvu-a; k'ọphu ẹphe a-chịhu lẹ mgboko. Byiko; gbanụa mini l'obu; paru haa; be mebyishikwa ndu nke ngu. ");
INSERT INTO iqw_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nyatakwa ndu ozi ngu, bụ Ébirihamu; mẹ Áyizaku; mẹ Ízurẹlu, bụ ndu i gude onwongu ria angụ; sụ: ‘L'ii-me awa ẹphe t'ẹphe ha l'ọbu mkpọ-kpodo, nọ l'igwe; tẹmanu nggu anụ awa ẹphe alị-a, i kwekotaru ẹphe ụkwa iya; t'ọ bụru òkè-iphe ẹphe jeye lẹ tutu yoyo.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ya ndono; Ojejoje abya arị-phu ọriri azụ; to mebyishihe ẹphe ẹge ono, o shi rịa lẹ ya e-mebyishi ẹphe ono. ");
INSERT INTO iqw_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mósisu abya aghachi; shi l'eli ugvu ono nyizita yẹle ekwekwerekwe mkpuma labụ ono, e deru ekemu ono, o gude l'ẹka ono. Mkpuma ono b'e deru iphe: ifu; mẹ azụ. ");
INSERT INTO iqw_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ekwekwerekwe mkpuma ono bụ Nchileke gude ẹka iya mee ya. Iphe, e deru iya abụru Nchileke gude ẹka iya dee ya. ");
INSERT INTO iqw_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ya ndono; Jóshuwa anụlephu ụzu, ndu Ízurẹlu atụ; sụ Mósisu: “Aatụkwa ụzu ọgu l'ọdu ndu Ízurẹlu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mósisu asụ iya: “Ẹ tọo dakwa l'ọ bụ ụzu ndu emekputa emekputa l'ọgu. Tọo da l'ọ bụ ụzu ndu, eemekputa emekputa. Iphe, ya anụ kwa egvu.” ");
INSERT INTO iqw_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mósisu abya erua l'iku ọdu ndu Ízurẹlu ono; bya aphụa nweswi ono; ọwaa ndu ono; l'ẹke ẹphe ete egvu. Ẹhu enwuhu iya ọku; yo woru mkpuma ono, o gude l'ẹka ono tụkposhia l'ọkpa ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Yọ bya ewota nweswi ono, ẹphe kpụru ono kpọo ọku. Yọ kpọtsua ya ọku; bya egwee ya; yọ dụ l'ọ bụ ntụ. Yọ bya awụru iya ye lẹ mini; mee ndu Ízurẹlu; ẹphe ngụa ya. ");
INSERT INTO iqw_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Yọ jị Érọnu: “?Bụ ngụnu bẹ ndu-a kabẹkpoo mee ngu, kparu; nggu eduru ẹphe ye l'ome iphe, dụ ẹji, habe ẹge-a?” ");
INSERT INTO iqw_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Érọnu asụ iya: “Onye nwe mu nụ; ba avọkwaru ọku ghụa ẹhu. L'ị mahawaru lẹ ndu-a bẹ ome iphe, dụ ẹji kwọwaru ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ẹphe sụru tẹ ya metaru ẹphe Nchileke, a-nọdu edu ẹphe; kẹle Mósisu ọphu, dufutaru ẹphe Íjiputu bẹ ẹphe ta madu iphe, meru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ya ndono; ya sụ ẹphe: ‘T'onye nweru iphe, e meru lẹ mkpọla-ododo; yefuta iya.’ Ẹphe achịtaru iya mkpọla-ododo ono. Ya achịru iya ye l'ọku; iphe shi iya lụfuta abụru nweswi-a.” ");
INSERT INTO iqw_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mósisu aphụ lẹ ndu Ízurẹlu nahụwaru; kẹle Érọnu hawaru ẹphe; ẹphe te kwehe t'a chịkobe ẹphe; ẹphe eshiwa ẹge ono bụwaru ndu, ndu ọhogu ẹphe gude eme iphe-ọchi. ");
INSERT INTO iqw_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mósisu evudo l'ọnu obu-edukfu ọdu ndu Ízurẹlu ono; sụ: “T'onye bụ kẹ Ojejoje byakfuta iya!” Ndu Lívayi l'ẹphe ha awụ-kfube iya. ");
INSERT INTO iqw_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Yọ sụ ẹphe: “Ọwaa iphe, Ojejoje, bụ Nchileke kẹ ndu Ízurẹlu ekfu: ‘T'onyenọnu turu ogu-mbeke ya l'ukfu; unu ejephee ọdu ndu Ízurẹlu ono mgburumgburu; tsube l'ishi iya ọwaa; rua l'ishi iya ọphu. T'onyenọnu gbushia nwanna iya; mẹ ọnya iya; mẹ obutobu iya.’ ” ");
INSERT INTO iqw_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ndu Lívayi abya emee ẹge Mósisu ziru ẹphe. Ndu e gburu mbọku ono rukwaru iphe, dụ l'ọ bụ ụnu ẹsaa l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mósisu asụ: “A fọtawaru unu doberu Ojejoje iche ntanụ; kẹ l'unu tsoru ụnwu unu; mẹ unwunne unu ọgu. Ojejoje gọwaru ọnu-ọma nụ unu ntanụ-a.” ");
INSERT INTO iqw_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Yo be echile iya; Mósisu asụ ndu Ízurẹlu: “Iphe, dụ ẹji, unu meru, hakwa l'uru. Nta-a bẹ ya ejekfuwa Ojejoje t'a maru; ?ya a-dụ ike rọ-buta iya t'ọ gụaru unu nvụ l'iphe, dụ ẹji ono, unu meru ono.” ");
INSERT INTO iqw_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ya ndono; Mósisu abya ejekfu Ojejoje je asụ iya: “L'ẹjo iphe, ndu-a meru ta dụkwa k'ekfukfu! Ẹphe gudeekwa mkpọla-ododo metaru onwẹphe agwa. ");
INSERT INTO iqw_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ọlobu; byiko; gụaruru ẹphe nvụ l'ẹjo iphe ono, ẹphe meru ono. Teke ẹ tọ dụdu; nggu efuchafukwa ẹpha yẹbe Mósisu l'ẹkwo, i deru ẹpha ndu nke ngu.” ");
INSERT INTO iqw_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ojejoje asụ Mósisu: “L'ọ kwa onye mesweru iya nụ bẹ ya e-fufu ẹpha iya l'ẹkwo iya. ");
INSERT INTO iqw_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tụgbua nta-a je eduta ndu Ízurẹlu je ẹke ono, ya kfuru ngu okfu iya ono; lẹ Ojozi iya a-nọdu-a edu unu. Ọle oge teke, ya a-nụ ẹphe aphụ -rulephu; bẹ ya a-nụa ẹphe aphụ k'iphe, dụ ẹji, ẹphe meru.” ");
INSERT INTO iqw_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ojejoje abya egude ẹjo iphe-ememe byakfuta ndu Ízurẹlu; k'iphe ono, ẹphe gude nweswi ono, Érọnu kpụru ono mee. ");
INSERT INTO iqw_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “Shi l'ẹke-a tụgbua; nggu lẹ ndu ono, i dufutaru l'alị Íjiputu ono! Unu tụgbua jeshia l'alị ono, ya kweru ụkwa bya eriru angụ yeru iya Ébirihamu; mẹ Áyizaku; mẹ Jékọpu phẹ; sụ ẹphe: ‘Lẹ ya a-nụ iya awa ẹphe ono.’ ");
INSERT INTO iqw_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ya e-zi ojozi t'o duru unu je; je achịshiaru unu ndu Kénanu; ndu Amọru; ndu Hetu; ndu Pẹ́rezu; ndu Hevu; mẹ ndu Jebusu. ");
INSERT INTO iqw_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Unu tụgbua jeshia l'ẹgiri alị ono. Ọle ya ta etsokwa unu; a -nọnyakwaa; ya ekpukpoo unu l'ụzo; kẹ l'unu bụnukaru ndu obu-kpọkponyi.” ");
INSERT INTO iqw_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ndu Ízurẹlu anụlephu ẹjo-nzi ono; wata ọgu aphụ; k'ọphu bụ l'ẹ to nwedu ẹphe onye kwakwaduru ngwa gude memashia onwiya. ");
INSERT INTO iqw_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ishi iya abụru lẹ Ojejoje sụru Mósisu: “T'o kfuru ndu Ízurẹlu l'ẹphe bụnuka ndu obu-kpọkponyi. L'ọ -bụru l'ọo tẹ ya tsoru ẹphe b'o nwekwaru ẹge ọo-dụ; ya ekpukpoo ẹphe. Ọo ya bụ; t'ẹphe kwashịa ngwa ono, ẹphe kwaru gude memashia onwẹphe ono; tẹ ya rịa ọriri; maru iphe, ya e-me ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ya ndono; ndu Ízurẹlu eworu ngwa, ẹphe kwaru gude memashia onwẹphe kwashia l'ugvu Họ́rebu. ");
INSERT INTO iqw_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Yọ bụru Mósisu shi aphụtaje ụlo-ẹ́kwà ono; je akpọbe l'azụ ọdu ndu Ízurẹlu; kua ya “Ụlo-Ẹ́kwà Ndzuko.” Iphe bụ onye eje ọkpata Ojejoje ishi; ejeje lẹ Ụlo-Ẹ́kwà Ndzuko ono, nọ l'azụ ọdu ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Yọo bụje; Mósisu -gbeshi l'eje lẹ Ụlo-Ẹ́kwà Ndzuko ono; ndu Ízurẹlu l'ẹphe ha awụ-lihu; vudogbaa l'ọnu ụlo-ẹ́kwà ẹphe l'ele Mósisu jeye teke ọo-bahu lẹ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mósisu -bahụlephu lẹ Ụlo-Ẹ́kwà Ndzuko ono; urukpu ono, kpụru rogbodongu ono alazita bya anọ-chia ọnu Ụlo ono; Ojejoje ekfuru nụ iya. ");
INSERT INTO iqw_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ndu Ízurẹlu -phụlephu urukpu ono, kpụru rogbodongu ono l'ẹke ọ nọ l'ọnu Ụlo-Ẹ́kwà Ndzuko ono; onyenọnu anọdu l'ọnu ụlo-ẹ́kwà iya wụ-lihu; baaru Ojejoje ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ojejoje shi anọduje ekfu eyeru Mósisu ifu l'ifu ẹge ono, madzụ anọduje ekfu eyeru ọnya iya ono. Teke e metsuaru; Mósisu alaphuta azụ l'ọdu ndu Ízurẹlu. Ọle nwata okoro ono, e yejeru iya ẹka ono; mbụ Jóshuwa Nunu; ta alụfujedu alụfu lẹ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mósisu asụ Ojejoje: “I shilephu teke-wa kfutaru iya tẹ ya dua ndu-a; ọle ẹ ti mekpodua tẹ ya maru onye ii-yeru iya tẹ yẹle iya dua ẹphe ọbu; nggu asụkwaru l'ị maru yẹbe Mósisu ọhuma; ya abawa ngu l'obu. ");
INSERT INTO iqw_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ọ -bụru phụ lẹ ya nọ ngu l'obu l'oswiya; koshinu iya ụzo ngu; k'ọphu ya a-maru ngu; nọduwa ngu rụ l'obu gbururu jeye. Nyatakwa l'ọha-wa bụ ndu nke ngu.” ");
INSERT INTO iqw_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ojejoje asụ iya: “Lẹ ya e-tsoru-a unu yẹbedua l'onwiya; ya emee tẹ meji nmakfuru ngu anmakfuru.” ");
INSERT INTO iqw_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ya ndono; Mósisu asụ iya: “Ọ -bụru l'ẹ tii tsoduru ayi eje nggụbedua l'onwongu; be ekwekwa tẹ ayi shi l'ẹke-a hata ọkpa lụfu alụfu! ");
INSERT INTO iqw_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","?Nanụ ẹge ee-shi maru lẹ yẹbedua yẹle ndu nke ngu nọ ngu l'obu; abụdu l'i tso ayi? ?Bụ ngụnu ọdo e-koshi lẹ yẹbedua yẹle ndu nke ngu dụ iche l'ẹke ndu mgboko l'ẹphe ha nọ?” ");
INSERT INTO iqw_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ojejoje asụ Mósisu: “Lẹ ya e-melephu iphe ono, ị sụru tẹ ya meeru ngu ono; kẹ l'ị nọwa iya l'obu; ya amakwaru ngu phụ ọhuma.” ");
INSERT INTO iqw_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mósisu asụ iya: “Byiko; koshinu iya ọdu-biribiri ngu.” ");
INSERT INTO iqw_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ojejoje asụ iya: “Lẹ ya e-me t'ị phụ ẹge yẹbe Ojejoje dụ-tabe mma; ya anọdu ngu l'ifu kua onwiya iphe ya aza. Onye ọ dụ iya tẹ ya meeru eze-iphe-ọma; ya emeeru iya ẹya; onye ọ dụ iya tẹ ya phụaru imiko; ya aphụaru iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ọle ị tịi phụdu ifu iya; kẹ l'ẹ to nwedu onye gude ẹnya iya phụ iya nụ, a-nọnu.” ");
INSERT INTO iqw_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ojejoje asụ: “O nweru mkpuma, nọnyabe iya nụ, ịi-vudo l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ọdu-biribiri iya swetadelephu; ya eworu ngu ye lẹ mgbaku mkpuma; gude ẹka iya gbochita ngu; gbururu jeye ya esweta-gee. ");
INSERT INTO iqw_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Teke ono; ya ewofu ẹka iya; nggu aphụ iya okpurukpu-azụ. Obenu l'ifu iya b'ẹ t'a phụjekwa aphụphu.” ");
INSERT INTO iqw_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ojejoje asụ Mósisu: “T'o je awata balịbali mkpuma labụ ọdo, a-dụ l'ọ bụ kẹ mbụ phụ. Tẹ ya dekwaa ya phụ iphe, shi nọdu lẹ kẹ mbụ phụ, ị tụkporu phụ. ");
INSERT INTO iqw_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kwakọbe l'ụtsu echile; nyikobe Ugvu Sáyịnayi; bya ekoshi iya onwongu l'eli ugvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","T'ẹ b'o nwekwa onye e-tsoru ngu nụ; ọphu ọ dụkwa onye aa-phụ l'ugvu ono lẹ phuu; t'ẹ b'o nwekwa atụru; m'ọ bụ eswi, a-nọdu ata nri l'ọkpa ugvu ono.” ");
INSERT INTO iqw_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ya ndono; Mósisu abya awata ekwekwerekwe mkpuma labụ ọdo, dụlephu l'ọ bụ kẹ mbụ phụ; gude iya nyihu Ugvu Sáyịnayi l'ọnmewa ụtsu; paru ekwekwerekwe mkpuma labụ ono l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ya ndono; Ojejoje eshi l'urukpu nyifuta; bya evudonyabe iya; raa ya arara l'ẹpha iya bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yọ bya esweta Mósisu l'ifu; bya agbakụshi onwiya ẹpha; sụ: “Ọo yẹbedua bụ Ojejoje! Ọo yẹbedua bụ Ojejoje; bya abụru Nchileke, aphụjeru madzụ imiko; bụkwaruphu Nchileke, emejeru madzụ eze-iphe-ọma. Ya ta bụkwa agụ-ọnwuu. Ya bụ onye n-yemobu iya nyịberu anyịbe; bụru o-me-g'o-kfuru! ");
INSERT INTO iqw_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ya ekoshije ụnukurunu madzụ lẹ ya yeru ẹphe obu. Ya agụjeru ẹphe nvụ kẹ ẹjo ọkpoma ẹphe; mẹ kẹ íkè, ẹphe kwefuru iya; mẹ kẹ iphe, dụ ẹji, ẹphe meru iya. Ọbule ya ta ahajẹkwanu onye ikpe nmaru tẹ ya ba hụ̀ iya àhụ̀hù. Ndu iphe, dụ ẹji bẹ ya ahụ̀je àhụ̀hù k'iphe, dụ ẹji, ẹphe meru iya; hụ̀-rua ya l'ẹke ụnwu nwanwa ẹphe nọ; mẹ l'ẹke nwanwanwaranwa ẹphe nọ; hụ̀-rua ẹphe l'ọgbo k'ẹno.” ");
INSERT INTO iqw_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mósisu abya eforita ifu l'alị teke ono teke ono; baaru Ojejoje ẹja; ");
INSERT INTO iqw_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","sụ iya: “Nggụbe Ojejoje; ọ -bụru-a lẹ ya nọ ngu l'obu l'oswiya; byiko tẹ nggụbe Ojejoje tsonuru ayi. A makwaru-a lẹ ndu-a bụnukaru ndu obu-kpọkponyi; ọle; byiko gụnuaru ayi nvụ kẹ ẹjo ọkpoma ayi; mẹ iphe, dụ ẹji ayi. Nggu ewotaru ayi t'ayi bụru òkè-iphe ngu.” ");
INSERT INTO iqw_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ojejoje asụ: “Lẹ nggu l'iya a-gba ndzụ. Ya a-nọdu l'atatifu ndu nkengu; mee eze iphe, dụ biribiri, ya te mebudua l'iphe bụ mbakeshi l'ọ ha. Mba ndu ono, unu l'ẹphe gbaru ọgbu-ụpho ono a-phụkota ẹge iphe, yẹbe Ojejoje e-me dụ-be egvu. ");
INSERT INTO iqw_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Unu ngabẹ nchị mee ekemu-a, ya atụru unu ntanụ-a. Ya a-chịfuru unu ndu Amọru; ndu Kénanu; ndu Hetu; ndu Pẹ́rezu; ndu Hevu; mẹ ndu Jebusu. ");
INSERT INTO iqw_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ọle t'unu kwabẹkwa ẹnya t'unu lẹ ndu bu l'alị ono, unu ala ono bẹ gba ndzụ; ọdumeka bẹ ẹphe a-bụkwaru ọnya hata unu. ");
INSERT INTO iqw_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Unu gvukposhia ẹnya-ngwẹja ẹphe; unu etsukposhia mkpuma, ẹphe doberu nsọ; unu afọkashikwaaphu itso, e doberu agwa ẹphe, bụ Ashera. ");
INSERT INTO iqw_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","T'ẹ b'ọ dụkwa iphe ọdo, unu a-bajẹru ẹja ọdo; gbahaa yẹbe Ojejoje. Ishi iya abụru lẹ yẹbe Ojejoje, ẹpha iya bụ Okopho bẹ bụkwa Nchileke, ekoje okopho. ");
INSERT INTO iqw_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Unu kwabẹkwa ẹnya t'ẹ b'ọ dụ ndu bu l'alị ono, unu l'ẹphe a-gba ndzụ. Kẹ l'ẹphe -gwadẹlephu agwa ẹphe; bẹ ẹphe e-kukwa unu t'unu bya; unu eje eria iphe, ẹphe gude gwaa agwa ẹphe ono. ");
INSERT INTO iqw_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ọ -bụru l'unu haru ụnwanyi ẹphe lụtaru ụnwu unu t'ẹphe bụru unyomu ẹphe; bẹ ẹphe e-me ụnwu unu ono; ẹphe te kwehe nke mu; ẹphe abalahaaru agwa ẹphe ono ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Unu ba akpụtakwa ntẹkpe, unu a-nọdu agwa agwagwa! ");
INSERT INTO iqw_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Unu gbajẹ Ajị Buredi, ẹ te kodu ekoko. Abalị ẹsaa bẹ unu a-tajẹ buredi, ẹ te yedu iphe, ekoje buredi ẹge ono, ya sụru t'unu meje iya ono. Unu agbajẹ ajị ono teke ono, e doberu iya ono l'ọnwa Abibu; kẹ l'ọbu l'ọnwa ono bẹ unu shi l'alị Íjiputu wụfuta. ");
INSERT INTO iqw_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Iphe, bụ iphe, vuru ụzo waa nne iya ọswa bụkwa kẹ yẹbe Ojejoje. Iphe bụ anụ, bụ okee ya, vuru ụzo waa nne iya ọswa bụkwa kẹ yẹbe Ojejoje: m'ọ bụ eswi; m'ọ bụ atụru; m'ọ bụ eghu. ");
INSERT INTO iqw_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Unu gudeje nwatụru gbata nkakfụ-ịgara, vuru ụzo waa nne iya ọswa. Ọ -bụru l'unu ta agbatadu iya agbata; unu aswị-kwoo ya olu. Iphe, bụ nwata nwoke, vuru ụzo waa nne iya ọswa bẹ unu a-gbatajẹ agbata. “T'ẹ b'ọ dụkwa onye a-gbajẹ ẹka bya l'ifu yẹbe Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Abalị ishingu bẹ unu e-jeje ozi unu; o -rua mbọku k'ẹsaa; unu atụta ume. Unu be ejejekwa ozi lẹ mbọku k'ẹsaa; m'o -ruhuru; ọ bụru teke aakọbe iphe akọbe; m'ọ bụ teke aakpata iphe, e meberu l'alị akpata. ");
INSERT INTO iqw_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Witu ọdungu, unu butaru; bẹ unu e-gudeje gbaa Ajị Ídzù. Unu agbaa ajị k'iphe, a kpataru l'okfu l'ishi-afa. ");
INSERT INTO iqw_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ugbo ẹto l'afa; bẹ unwoke unu l'ẹphe ha a-chịkoje bya l'ifu Nnajiufu, bụ Ojejoje; mbụ Nchileke kẹ ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ya a-chịshiru unu iphe bụ mbakeshi; bya emee t'alị unu kabaa nshinu. Ọphu 'onwedu onye eje unu ọnata alị unu teke ono, unu e-jeje l'ifu Ojejoje, bụ Nchileke unu ugbo ẹto l'afa ono. ");
INSERT INTO iqw_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Unu be eyekobejekwa iphe ekoje buredi lẹ mee anụ, unu gude egworu iya ngwẹja. “Ọphu ọ dụkwa anụ, e gude gwoo ẹja Ajị Esweta, aa-ha t'ọ bọo nchi. ");
INSERT INTO iqw_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Iphe, bụ iphe vuru ụzo kaa l'iphe, unu meberu l'alị; bẹ unu e-gudeje bya l'ụlo Ojejoje, bụ Nchileke unu. “Unu be egudejekwa mini-ẹra nne eghu shia nwa iya.” ");
INSERT INTO iqw_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ya ndono; Ojejoje asụ Mósisu: “Dee okfu ono l'ọ ha l'ẹkwo; kẹ l'ọo okfu ono bẹ nggu l'iya; mẹ ndu Ízurẹlu gude gbaa ndzụ.” ");
INSERT INTO iqw_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mósisu bẹ yẹle Ojejoje nọru l'ẹke ono ụkporo abalị labụ: eswe l'ẹnyashi; ọphu Mósisu 'eridu nri; t'ọ ngụ mini. Yo dee okfu ọgba-ndzụ ono, bụ iya bụ ekemu iri ono, shi l'ẹka Nchileke ono l'eli ekwekwerekwe mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Teke Mósisu shi lẹ Ugvu Sáyịnayi nyifuta; gude ekwekwerekwe mkpuma labụ ono, e deru ekemu Ojejoje ono l'ẹka; b'ẹ t'ọ madu l'ifu egbu iya nwịinwii; keshinu ọphu yẹle Ojejoje shi akọ akọ. ");
INSERT INTO iqw_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Érọnu yẹle ndu Ízurẹlu l'ẹphe ha aphụ ẹge ifu egbu Mósisu nwịinwii; tsụlahaa egvu ẹge ẹphe e-shi jekfube iya ntse. ");
INSERT INTO iqw_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mósisu abya ekua ẹphe; Érọnu yẹle ndu ishi ọha ono l'ẹphe ha atụgbua teke ono jekushia ya; yọ bya ekfuru yeru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","E metsua; ndu Ízurẹlu l'ẹphe ha abyakfuta iya ntse; yọ bya atụshiaru ẹphe ekemu ono, Ojejoje nụru iya lẹ Ugvu Sáyịnayi ono. ");
INSERT INTO iqw_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mósisu ekfugetsua yeru ẹphe; chịta ụlari-ifu phụ-chia onwiya ifu. ");
INSERT INTO iqw_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ọle ọobuje; teke Mósisu bahụru lẹ Ụlo-Ẹ́kwà Ndzuko ẹke ono, Ojejoje nọ ono tẹ yẹle iya kfugba; yọ phụfu onwiya ụlari-ifu ono; gbururu jeye teke ọo-lụfuta. Ọ -lụfutalephu; yọ bya ekfukotaru ndu Ízurẹlu iphe, e ziru iya; ");
INSERT INTO iqw_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ẹphe aphụkwaaphu ẹge ifu egbu iya nwịinwii. Mósisu ewotaje ụlari-ifu ono phụ-chia ifu ọdo jeye; yo jeshia tẹ yẹle Ojejoje kfugba. ");
INSERT INTO iqw_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mósisu abya ekukobe ndu Ízurẹlu l'ẹphe ha; sụ ẹphe: “Ọwaa iphe, Ojejoje sụru t'unu mee ndọ-ọ: ");
INSERT INTO iqw_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Abalị ishingu bẹ unu e-jeje ozi unu. O -be lẹ mbọku k'ẹsaa; unu edobe iya nsọ; t'ọ bụru mbọku ọtu-ume kẹ Ojejoje. O -nweru onye jeru ozi mbọku ono; t'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","T'ẹ b'ọ dụkwa onye a-phụ-nwu ọku l'ufu iya mbọku ọtu-ume.” ");
INSERT INTO iqw_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mósisu asụ ndu Ízurẹlu l'ẹphe ha: “Ọwaa iphe, Ojejoje sụru t'e mee ndọ-a: ");
INSERT INTO iqw_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Unu shi l'iphe, unu nweru hata iphe bya anụ yẹbe Ojejoje. Onye oohe uhere t'ọ nụ yẹbe Ojejoje iphe bẹ iphe, oo-gude bya bụ mkpọla-ododo; m'ọ bụ mkpọla-ọcha; ope; ");
INSERT INTO iqw_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","òwúú, eke urukpu-urukpu; ọphu eke uswuswe; ọphu eke mee-mee; òwúú ọcha; ẹji eghu; ");
INSERT INTO iqw_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","akpọ ebyila, a tsẹru l'uswe; akpọ umoro-ẹnyimu; oshi akesha; ");
INSERT INTO iqw_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","manụ olivu, eegudeje amụ ọku; iphe, eeyeje lẹ manụ kẹ ọwu l'ishi t'o shi mkpọ; ọphu eeyeje l'ínsẹnsu, eshi kwẹkwekwe; ");
INSERT INTO iqw_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mkpuma ónìkùsù; mẹwaru mkpuma ọdo, aswa nọgbaa. Mkpuma ono bẹ ee-mekochaa dzụpyabe l'uwe-ukuvu onye ishi ndu achịjeru Nchileke ẹja yẹle uwe-ọkpoma iya. ");
INSERT INTO iqw_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“T'iphe bụ ndu maru ome nka l'unu lụfuta bya emee iphemiphe ọbule-a, Ojejoje tụru ọnu t'e mee-wa; ");
INSERT INTO iqw_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","mbụ ụlo-ẹ́kwà-dụ-nsọ ono; ẹkwa, aa-phụ-chi l'eli iya; iphe, ee-gude kwechia ya; iphe, ee-gude kota nkolaba iya; iphe, ee-gude gụ-chita iya; oshi-ibo iya; ọkpa iya; ẹnya ẹke aa-kpọgbaaru iya ye; ");
INSERT INTO iqw_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","mẹwaru Okpoko Ọgba-ndzụ ono; mgbọro ono, ee-gudeje apa iya ono; okfu okpoko ono, aa-nọduje akfụ ụgwo iphe, dụ ẹji ono; ẹkwa ono, ee-gudeje gebuta iya ono; ");
INSERT INTO iqw_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","teburu ono; mgbọro ono, ee-gudeje apa iya ono yẹle ngwa iya; mẹ buredi ono, ee-dobeje Ojejoje l'ifu ono; ");
INSERT INTO iqw_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","iphe ono, eegvubeje urọku ono, e-meje tẹ iphoro nọdu ono yẹle ngwa iya l'ọ ha; urọku iya ono; manụ ono, ee-gudeje amụ ọku ono; ");
INSERT INTO iqw_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ẹnya-ngwẹja ínsẹnsu ono; mgbọro ono, ee-gudeje apa iya ono; manụ ono, aa-wụje l'ishi ono yẹle ínsẹnsu ono, eshi kwẹkwekwe ono; ẹkwa ono, ee-gbobutaje ọnu ụlo-ẹ́kwà-dụ-nsọ ono; ");
INSERT INTO iqw_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ẹnya-ngwẹja-ukfuru ono yẹle iphe ono, dụ l'ọ bụ ụgbu, ee-gude ope mee ono; mgbọro ono, ee-gudeje apa ẹnya-ngwẹja ono yẹle ngwa iya l'ọ ha; eze efere ono, ee-gude ope mee ono; yẹ l'ọkpa iya; ");
INSERT INTO iqw_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ẹkwa ono, ee-gude gebuta ogbodufu iya; itso ogbodufu ono yẹle ẹnya ẹke aa-kpọbetsua itso ono; mẹ ẹkwa ono, ee-gude gebuta ọnu-nggamgbo ogbodufu ono; ");
INSERT INTO iqw_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","mẹ nggu ụlo-ẹ́kwà-dụ-nsọ ono yẹle k'ogbodufu iya; mẹ eri iya; ");
INSERT INTO iqw_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","mẹ uwe ono, e kweru ekwekwe, ee-yeje gude eje ozi l'ụlo-nsọ ono; mbụ uwe, e doberu nsọ tẹ Érọnu, bụ onye achịjeru Nchileke ẹja yẹle ụnwu iya yeje gude eje ozi ndu achịjeru Nchileke ẹja.” ");
INSERT INTO iqw_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Tọ dụ iya bụ; ndu Ízurẹlu eshi l'ifu ẹke Mósisu nọ wụkashihu. ");
INSERT INTO iqw_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Iphe bụ onye oohe uhere; mẹ onye o ruru l'ẹhu t'ọ nụ Ojejoje iphe; egudegbaa iphe bya; mbụ iphe, ee-gude rụa Ụlo-Ẹ́kwà Ndzuko ono; iphe, ee-gude eje ozi l'ime iya; mẹkwaphu ọphu ee-gude kwee uwe, dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Iphe bụ ndu oohe uhere: unwoke mẹ ụnwanyi; egudegbaa iphe, e gude mkpọla-ododo mee bya anụ; mbụ iphe, dụgbaa l'ọ bụ ọjaga; iphe-nchị; echi; mẹwaru iphe ọdo, dụgbaa iche iche, e gude mkpọla-ododo mee. Ẹphe egudegbaa mkpọla-ododo ẹphe ono bya anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ndu nweru òwúú ewotagbakwaa ya phụ; mbụ òwúú eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; m'ọ bụ k'ọcha; m'ọ bụ ẹji eghu; m'ọ bụ akpọ ebyila, a tsẹru l'uswe; m'ọ bụ kẹ umoro-ẹnyimu. ");
INSERT INTO iqw_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ndu ẹka ruru lẹ mkpọla-ọcha; m'ọ bụ ope; ewotakwa iya phụ bya anụ Ojejoje. Ndu nweru oshi akesha, nweru ẹke ee-gude iya rụa ọru ono anụkwa iya phụ. ");
INSERT INTO iqw_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Iphe bụ ụnwanyi, maru ome nka egudetsua ẹka ẹphe kwee ẹkwa bya anụ. O nweru ndu, bụ òwúú, eke urukpu-urukpu bẹ ẹphe gude kwee nk'ẹphe; nweru ndu bụ kẹ mee-mee; nweru ndu bụ k'uswe; nweru ndu bụ k'ọcha bẹ ẹphe gude kwee nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ụnwanyi, oohe uhere; bụkwaruphu ndu, maru ome nka; bụ ẹji eghu bẹ ẹphe gude kwee ẹkwa nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ọphube ndu ishi wotagbaaru mkpuma ónìkùsù; mẹwaru mkpuma ọdo, aswa dụgbaa; t'a gbapyabẹ l'uwe-ukuvu onye ishi ndu achịjeru Nchileke ẹja; yẹle uwe-ọkpoma iya. ");
INSERT INTO iqw_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ẹphe nụfukwaaruphu iphe, eshi mkpọ; manụ olivu, ee-gudeje amụ ọku; ọphu ee-yeje lẹ manụ ọwu l'ishi; mẹ k'ínsẹnsu, eshi kwẹkwekwe. ");
INSERT INTO iqw_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ndu Ízurẹlu l'ẹphe ha: unwoke mẹ ụnwanyi; mbụ ndu oohe uhere ewotakotaru Ojejoje iphe, ẹphe tụru obu ẹphe onyo l'ẹphe a-nụ t'e gude rụaru Ojejoje iphe ono, o shi l'ọnu Mósisu kfua t'e meeru iya ono. ");
INSERT INTO iqw_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mósisu asụ ndu Ízurẹlu: “Unu lekwa lẹ Ojejoje fọtaakwaru Bezalẹlu Úri Họru; bụru onye ikfu Júda; ");
INSERT INTO iqw_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","bya emewa; ume Nchileke eji iya ẹhu; t'o nweru mmamiphe; kwaa ẹnya; iphe edoje iya ẹnya ọhuma; k'ọphu ọo-ma ome nka l'iphemiphe ọbule; ");
INSERT INTO iqw_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","maru ẹge ee-shije gude mkpọla-ododo; mẹ mkpọla-ọcha; mẹ ope l'ememashi iphe; ");
INSERT INTO iqw_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","makwarụphu ẹge aawajẹ mkpuma, aswa nọ; mẹ ẹge aawụje mkpọla-ododo l'igburumọnu iya; bya amakwarụphu ẹge aapyịje iphe apyịpyi; mẹwaru ẹge eeshije emekota nka ọdo, dụgbaa iche iche. ");
INSERT INTO iqw_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ọ nụkwaruphu yẹle Oholiyabu Ahisamaku, bụ onye ikfu Dánu mmamiphe t'ẹphe zije ndu ọdo ome nka ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","O mewaru tẹ mmamiphe kẹ ẹge e shi eme nka l'ụzo, dụ iche iche; mẹ mmamiphe kẹ ẹge e gude ememashi iphe ememashi rube ẹphe ẹka; mẹ t'ẹphe maru ẹge eegudeje òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha dengashia iphe edengashi. Ẹphe ẹbo bụ ndu makọtaru ẹge eemeje iphe nka t'ọ maa mma. ");
INSERT INTO iqw_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Ọ bụ Bezalẹlu yẹle Oholiyabu; mẹ iphe bụ ndu maru ome nka; mbụ ndu Ojejoje nụru mmamiphe; bya emee tẹ iphe doo ẹphe ẹnya l'iphe, bụ iphe, laru lẹ kẹ ọkpu ụlo-nsọ ono: ọ bụ ẹphe a-rụ ọru ono; mee ya ẹge Ojejoje sụru t'e mee ya.” ");
INSERT INTO iqw_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Tọ dụ iya bụ; Mósisu ekua Bezalẹlu yẹle Oholiyabu; mẹ iphe bụ ndu maru ome nka; ndu Ojejoje nụru mmamiphe; bụru ndu oohe uhere t'ẹphe jee ozi ono; ");
INSERT INTO iqw_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","chịru iphe ono, ndu Ízurẹlu tụtaru t'e gude kpụa ụlo-nsọ ono nụ ẹphe. L'ụtsu mbọku-mbọku bẹ ndu Ízurẹlu anọduje atụko iphe ono l'anụ Mósisu l'ẹge ẹphe chịru obu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Iphe, bụ ndu maru ome nka ọkpu ụlo-nsọ ono atụko l'ẹphe ha paru ọru ẹphe haa; ");
INSERT INTO iqw_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","tụgbua je asụ Mósisu: “Lẹ ndu-a tụtaakwaru iphe, dzuru t'e gude rụa ọru ọbu, Ojejoje sụru t'a rụa ọbu; mbụ l'ẹphe gbe tụwa k'etsutsu iya ye iya.” ");
INSERT INTO iqw_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mósisu atụa ekemu; sụ: “T'ẹ b'ọ dụkwa nwoke; m'ọ bụ nwanyi, nweru iphe, oo-wotakwadu bya anụ; sụ l'ọ bụ iphe, o gude eyeta ẹka l'ụlo-nsọ ono.” E woru iphe ono, Mósisu kfuru ono radzuru l'ọdu ndu Ízurẹlu ono. E shi ẹge ono kpọshia ndu Ízurẹlu t'ẹ b'ọ dụhe iphe, ẹphe a-tụtakwadu; ");
INSERT INTO iqw_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kẹ l'iphe, a tụtawaru t'e gude rụkota ọru ono bẹ dzuwaru nụ; tsufu etsufu. ");
INSERT INTO iqw_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Iphe bụ ndu ọphu maru iphe lẹ ndu ọru ono egude ukfu-ẹkwa iri mee ụlo-ẹ́kwà-dụ-nsọ ono. Ukfu-ẹkwa iri ono b'e kweru l'òwúú ọcha, a swịru l'ọ bụ ụdo; mẹ òwúú, eke urukpu-urukpu; ọphu eke uswuswe; mẹ ọphu eke mee-mee. Yọ bụru onye maru ome nka gude òwúú ono kwee cherobimu ye l'ukfu-ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ukfu-ẹkwa ono achịko haru ẹnya-nhamụnha. Ogologo iya dụ nkwo-ẹka ụkporo l'ẹsato; ụsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ẹphe ewota ukfu-ẹkwa ono ise gbagbabe; yọ bụru ishimishi lanụ; bya ewotakwaphu ụzo ise ọphu gbagbabe nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ishimishi iya ono kẹ mbụ bẹ ẹphe gude òwúú, eke urukpu-urukpu yeshia ya nkolaba l'igburumọnu iya; mekwaa ya phụ ẹge ono l'ishimishi iya k'ẹbo. ");
INSERT INTO iqw_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Nkoloba ụkporo labụ l'iri bẹ ẹphe yeru l'ishishi ishimishi lanụ; bya eyekwaphu nkolaba ụkporo labụ l'iri l'ishishi ishimishi lanụ ọphu. Nkoloba ono atụko ghaaru onwẹphe ifu. ");
INSERT INTO iqw_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ẹphe egude mkpọla-ododo meta iphe, nweru nkolaba ishi labụ ụzo ụkporo labụ l'iri; gude iya dzegbabe ishimishi ẹkwa ono ẹphe ẹbo t'ọ tụko bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ẹphe abya egude ẹji eghu kwee ẹkwa kweta iya ukfu-ẹkwa iri lẹ nanụ, ee-gude phụ-chita eli ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ukfu-ẹkwa ono ụzo iri lẹ nanụ ono achịko haru ẹnya-nhamụnha. Ogologo iya dụ nkwo-ẹka ụkporo l'iri. Ụsa iya adụ nkwo-ẹka ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ẹphe abya achịta ukfu-ẹkwa ono ise gbagbabẹ; yọ bụru ishimishi lanụ; chịta ụzo ukfu-ẹkwa ishingu ọphu gbagbabẹkwaphu nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Nkoloba ụkporo labụ l'iri bẹ ẹphe yeru l'ishishi ishimishi lanụ; yekwaphu nkolaba ụkporo labụ l'iri l'ishishi ishimishi lanụ ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ẹphe egude ope meta iphe, nweru nkolaba ishi labụ ụzo ụkporo labụ l'iri; gude iya kotagbaa nkolaba ishimishi ẹkwa ono ẹphe ẹbo; gude iya dzegbabe ụlo-ẹ́kwà ono; yọ bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E metsua; ẹphe egude akpọ ebyila, a tsẹru l'uswe; mee iphe, ee-gude phụ-chia eli ụlo-ẹ́kwà ono; bya egudekwaphu akpọ umoro-ẹnyimu mee iphe, ee-gude kwechita eli akpọ k'ebyila ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ẹphe egude oshi akesha rụshia oshi-ibo, ee-ye l'ụlo-ẹ́kwà-dụ-nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Oshi-ibo ono b'a rụru; yọ dụtsua nkwo-ẹka iri iri l'eli. Ụsa iya adụ nkwo-ẹka lẹ mkpirikpi lẹ mkpirikpiri. ");
INSERT INTO iqw_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Oshi-ibo ono bẹ ẹphe pyịtatsuaru ọkpa ẹbo ẹbo ye ẹka labụ. Yọ bụru ẹge ono bẹ ẹphe mekotaru oshi-ibo ụlo-ẹ́kwà-dụ-nsọ ono l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","A bya lẹ ụlo-ẹ́kwà-dụ-nsọ ono ibyiya ọphu gharu ifu l'ụzo ọhuda bụ ụkporo oshi-ibo bẹ ẹphe rụtaru t'e ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ẹphe egude mkpọla-ọcha meshia ẹnya ẹke aa-kpọgbaaru ọkpa oshi-ibo k'ụzo ọhuda ono ye; meta iya ụzo ụkporo labụ. Iphe bụ oshi-ibo, nọnu nwetsuaru ẹnya labụ ẹke, aa-kpọtsuaru ọkpa iya ye. ");
INSERT INTO iqw_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","A bya l'ibe iya ọphu; mbụ ibyiya ọphu gharu ifu l'ụzo isheli bụkwaphu ụkporo oshi-ibo bẹ ẹphe rụtaru t'e ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ẹphe egude mkpọla-ọcha meshia ẹnya ẹke aa-kpọgbaaru ọkpa ibo ono; meta iya ụzo ụkporo labụ. Iphe bụ oshi-ibo, nọnu enweru ẹnya labụ ẹke, aa-kpọtsuaru ọkpa iya ye. ");
INSERT INTO iqw_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","A bya l'azụ ụlo-ẹ́kwà-dụ-nsọ ono; ibyiya ọphu gharu ifu l'ụzo ẹnyanwu-arịba bụ oshi-ibo ishingu bẹ ẹphe rụtaru t'e ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Iku azụ ụlo-ẹ́kwà-dụ-nsọ ono ẹphe ẹbo bụ oshi-ibo labụ bẹ ẹphe rụtaru t'e ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Oshi-ibo labụ ono, ee-ye l'iku iya ono bẹ ẹphe rụru; yọ dụ nkwegba labụ. O shi l'ụzo alị dụ nkwegba labụ jeye l'ụzo imeli. Yọ bụru echi lanụ b'e gude kụ-gbabe iya; ẹphe ẹbo. Ẹphe ẹbo ono b'a rụru; yọ dụkota ẹge ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ọo ya bụ l'o nweru oshi-ibo ẹsato l'azụ ụlo-ẹ́kwà-dụ-nsọ ono. E gude mkpọla-ọcha meshia ẹnya ẹke aa-kpọru ọkpa oshi-ibo ono ye ụzo iri l'ishingu. Iphe bụ oshi-ibo, nọnu enweru ẹnya labụ ẹke, aa-kpọru ọkpa iya ye. ");
INSERT INTO iqw_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ẹphe egude oshi akesha pyịshia oshi, ee-gude swebushia oshi-ibo ono. Ụzo ise bẹ ẹphe sweberu l'oshi-ibo mgberemẹku ụlo-ẹ́kwà-dụ-nsọ ono ibe lanụ; ");
INSERT INTO iqw_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","swebekwaphu ụzo ise ọdo lẹ mgboro iya ọphu. Ụzo ise ọdo bụ l'azụ ụlo-ẹ́kwà-dụ-nsọ ono; ibyiya ọphu gharu ifu l'ụzo ẹnyanwu-arịba bẹ ẹphe sweberu iya. ");
INSERT INTO iqw_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Oshi ọphu ee-swebe l'echi iya bẹ ẹphe pyịru t'o shi l'ishi lanụ lụfu l'ishi iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ẹphe awụa mkpọla-ododo l'oshi-ibo ono; bya egudekwaphu mkpọla-ododo meshia echi, e-gudetsua oshi ono, ee-gude swebushia l'oshi-ibo ono. Ẹphe abya awụkwaaphu mkpọla-ododo l'oshi ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ẹphe egude òwúú, eke urukpu-urukpu; ọphu eke uswuswe; ọphu eke mee-mee yẹle k'ọcha, a swịru l'ọ bụ ụdo; kwee ukfu-ẹkwa. Onye maru ome nka abya egude òwúú ono kwee cherobimu ye l'ukfu-ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ẹphe egude oshi akesha pyịa itso ẹno; bya awụa ya mkpọla-ododo; bya egudekwaphu mkpọla-ododo meshia iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono. Ẹphe abya egude mkpọla-ọcha kpụshia ẹnya ẹke aa-kpọbe itso ono ụzo ẹno. ");
INSERT INTO iqw_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Onye maru okwe ẹkwa ọhuma egude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; kwee ẹkwa, ee-gudeje gebuta ọnu ụlo-ẹ́kwà-dụ-nsọ ono. Yọ bụru ndu gude ngga ekwe ẹkwa bẹ meru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ẹphe egude oshi akesha pyịta itso ise; bya emetakwaphu iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono. Ishi itso ono; mẹ iphe, ee-swebe l'itso ono bẹ ẹphe wụru mkpọla-ododo; bya egude ope meshia ẹnya ẹke aa-kpọbe itso ono ụzo ise. ");
INSERT INTO iqw_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalẹlu abya egude oshi akesha gbaa okpoko. Ogologo iya dụ nkwo-ẹka labụ lẹ mkpirikpi iya. Ụsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. Eli iya adụkwaphu nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Yọ wụa ọkpobe mkpọla-ododo l'ime iya mẹ l'azụ iya. Yo gudekwaphu mkpọla-ododo kpụ-phee mgberemẹku iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Yọ kpụta echi mkpọla-ododo ẹno dukfubegbaa l'ọkpa iya ẹphe ẹno; mbụ wota ẹbo dukfube l'ibe lanụ; wota ẹbo ọphu dukfube l'ibe iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","B'ọ bya egude oshi akesha ono pyịta mgbọro labụ; wụa ya mkpọla-ododo; ");
INSERT INTO iqw_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","bya ewota mgbọro ono ẹphe ẹbo pyotsua l'echi ono, e dukfubegbaaru lẹ mgberemẹku okpoko ono t'ọ bụru iphe, ee-gudeje apa iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Yo gude ọkpobe mkpọla-ododo meta okfu okpoko, aa-nọduje akfụ ụgwo iphe, dụ ẹji. Ogologo iya dụ nkwo-ẹka labụ lẹ mkpirikpi iya. Ụsa iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Yo gude mkpọla-ododo mee cherobimu labụ, a-nọdutsua l'ishi okfu okpoko ono. Yọ bụru mkpọla-ododo, e tsusaru etsusa b'o gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Yo woru cherobimu lanụ dobe l'ishi ibe lanụ; woru ọphu dobe l'ishi iya ọphu; bya emee; cherobimu labụ ono, nọtsua l'ishishi okpoko ono ẹphe ẹbo yẹle okpoko ono abụru iphe lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherobimu ono b'o meru; yọ jashịa ẹ́bà l'ụzo imeli; agu iya edochita eli okpoko ono. Ẹphe echegba onwẹphe ifu; chịru ẹnya ye l'eli okpoko ono. ");
INSERT INTO iqw_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ẹphe egude oshi akesha pyịa teburu. Ogologo iya dụ nkwo-ẹka labụ. Ụsa iya adụ nkwo-ẹka lanụ. Eli iya adụ nkwo-ẹka lanụ lẹ mkpirikpi iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ẹphe awụa ya ọkpobe mkpọla-ododo; bya egudekwaphu mkpọla-ododo kpụ-phee eli iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ẹphe ewota oshi, dụ gbịriri, ụsa iya ha l'ọ bụ ọbechere-ẹka swiphee mgberemẹku iya mgburumgburu; bya egudekwaphu mkpọla-ododo kpụ-phee oshi ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ẹphe akpụta echi mkpọla-ododo ẹno dekfubegbaa lẹ mgberemẹku ọkpa teburu ono. ");
INSERT INTO iqw_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Echi ono nọnyabetsua oshi ono, dụ gbịriri ono; k'ọphu ọo-dụkwanu ike gudeshia mgbọro, ee-gudeje apa teburu ono. ");
INSERT INTO iqw_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mgbọro, ee-gudeje apa teburu ono bụ oshi akesha b'e gude pyịshia ya; bya awụa ya mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ẹphe egude ọkpobe mkpọla-ododo meshia ngwa kẹ teburu ono; mbụ efere; mẹ ite; mẹ okoro; mẹ nkwọ-ẹka, aa-tụ-kobe l'eli teburu ono. Iphe ono l'ọ ha bụ iphe, ee-gudeje gwooru Ojejoje ngwẹja-mẹe. ");
INSERT INTO iqw_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ẹphe egude ọkpobe mkpọla-ododo, e tsusaru etsusa mee iphe, eegvubeje urọku. Ẹphe meru iya; yo nweru oshi; nweru ẹkali. Yo nweru efere; nweru iphe, dụ l'ọ bụ nwopu okoko-oshi; mẹ iphe, dụ l'ọ bụ igu oshi. Ẹphe atụko iphe ono l'ọ ha mee tẹ yẹle iphe ono, eegvubeje urọku ono bụru iphe lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Oshi iya ono nweru ẹkali ishingu. Ẹkali ẹto nọ lẹ mgberemẹku iya lanụ; ẹto k'ọphu anọdu iya lẹ mgberemẹku ọphu. ");
INSERT INTO iqw_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ẹkali iya ono nweru efere ẹto. Efere ono b'e meru; yọ dụgbaa l'ọ bụ igu alụmondu. E mekwaaphu nwopu okoko-oshi ye iya; ọwaa iphe, dụ l'ọ bụ igu oshi. Yọ bụru ẹge ono b'ọ dụkota l'ẹkali iya ono ẹphe ishingu, jakashịru l'oshi iya ono. ");
INSERT INTO iqw_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Oshi iya ono nweru efere ẹno, e meru; yọ dụ l'ọ bụ igu alụmondu. Yo nwekwaruphu iphe, e meru; yọ dụ l'ọ bụ nwopu okoko-oshi; ọwaa iphe, dụ l'ọ bụ igu oshi. ");
INSERT INTO iqw_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nwopu okoko-oshi lanụ b'e meru; yọ nọdu lẹ mkpuli ẹkali iya labụ ono k'alị. K'ẹbo anọdu lẹ mkpuli ẹkali iya labụ k'echi. K'ẹto anọdu lẹ mkpuli ẹkali iya labụ k'eli. Mbụ l'ọ nọkota lẹ mkpuli ẹkali iya ono ẹphe ishingu. ");
INSERT INTO iqw_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nwopu okoko-oshi ono yẹle ẹkali iya ẹkali iya ono b'e meru yẹle oshi iya aragba nanụ. Yọ bụru ọkpobe mkpọla-ododo, e tsusaru etsusa b'e gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ẹphe gudekwaphu ọkpobe mkpọla-ododo meta urọku ẹsaa, ee-gvubegbaa l'eli iphe ono, eegvubeje urọku ono; bya emetakwaphu ákpà iya; mẹ ashanga, aagụje ọku iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Iphe, eegvubeje urọku ono yẹle ngwa iya l'ọ ha bụ ụnu ọkpobe mkpọla-ododo ẹsaa l'ụkporo iri b'e gude mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ẹphe egude oshi akesha kụa ẹnya-ngwẹja, bụ ẹke aa-kpọje ínsẹnsu ọku. Ogologo iya; mẹ ụsa iya chịkokwa haru ẹnya-nhamụnha. Iphe, ọ bụ bụ nkwo-ẹka lanụ. Eli iya dụ nkwo-ẹka ẹbo. Mpo iya yẹle ẹnya-ngwẹja ono aragbabe bụru nanụ. ");
INSERT INTO iqw_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ẹphe awụkota ọkpobe mkpọla-ododo l'eli iya; mgberemẹku iya; mẹ mpo iya. Ẹphe egudekwaphu mkpọla-ododo kpụ-phee mgberemẹku iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ẹphe emeta echi mkpọla-ododo ẹbo ẹbo dekfubegbaa lẹ mgberemẹku iya ẹphe ẹbo. Ẹphe dekfuberu iya; yọ nọdutsua lẹ mkpuli iphe ono, a kpụ-pheru iya mgburumgburu ono. Ọ bụ l'echi ono bẹ ee-yeje mgbọro, ee-gudeje apa iya. ");
INSERT INTO iqw_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ẹphe egude oshi akesha pyịta mgbọro ono; wụa ya mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ẹphe emekwaaphu manụ ono, dụ nsọ, eshi mkpọ, aawụje l'ishi ono; mẹ ọkpobe ínsẹnsu ono, eshi mkpọ ono; bụ iya bụ ọru onye maru ome manụ-mbeleke. ");
INSERT INTO iqw_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ẹphe egude oshi akesha kụa ẹnya-ngwẹja. Eli iya dụ nkwo-ẹka ẹto. Ogologo iya; mẹ ụsa iya achịko haru ẹnya-nhamụnha. Iphe, ọ dụtsua bụ nkwo-ẹka ise ise. ");
INSERT INTO iqw_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ẹphe akpụtatsua mpo l'iku iku iya ẹphe ẹno. Ẹphe emee; mpo ono yẹle ẹnya-ngwẹja ono aragbabẹ bụru nanụ. Ẹphe emetsua ya ẹge ono; bya eworu ope wụa ya. ");
INSERT INTO iqw_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ẹphe egude ope meshia iphemiphe ọbule, ee-gudeje eje ozi l'ẹnya-ngwẹja ono, bụ iya bụ ite okpo ntụ; mẹ eku; efere; oji; mẹ ashanga, aagụje ọku. ");
INSERT INTO iqw_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ẹphe egude ope meta iphe, dụ l'ọ bụ ụgbu, nweru mgberemẹku ẹno; woru iya kwechia ụzo alị mgberemẹku ẹnya-ngwẹja ono. Ẹphe shi l'echilabu iya kwechia ya jeye l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ẹphe egudekwaphu ope kpụshia echi ẹno hebetsua lẹ mgberemẹku iphe ono, dụ l'ọ bụ ụgbu ono, e meru l'ope ono ẹphe ẹno; t'ọ bụru ẹnya ẹke ee-pyotsua mgbọro, ee-gudeje apa ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ẹphe egude oshi akesha pyịta mgbọro labụ; wụa ya ope; ");
INSERT INTO iqw_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","wotsuaru mgbọro ono nwua l'ẹnya echi phụ lẹ mgberemẹku ẹbo ya. Mgbọro ono ẹphe ẹbo a-nọdujetsua lẹ mgberemẹku iya ẹphe ẹbo mẹ aaparu iya. Ẹphe meru ẹnya-ngwẹja ono; ụzo anọdu iya l'echi; mbụ l'ẹphe gude ibiribe oshi rụa ya. ");
INSERT INTO iqw_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ẹphe egude ope mee eze efere yẹle ọkpa iya. Ope ono shi l'onyo ụnwanyi, anọduje eje ozi l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ẹphe abya emeeru ụlo-ẹ́kwà ono ogbodufu; gude òwúú ọcha, a swịru l'ọ bụ ụdo; kwee ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo; t'e gude gebuta ụzo ọhuda l'ogbodufu ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ẹphe egude ope meta ụkporo itso, aa-kpọbe iya yẹle ẹnya ẹke aa-kpọbetsua itso ono; bya egude mkpọla-ọcha meshia iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono yẹle iphe, ee-swebetsua l'itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ụzo isheli iya bụkwaphu ẹkwa, dụ ụkporo nkwo-ẹka ise l'ogologo b'e kweru; gude gebuta iya. Itso, aa-kpọbe l'ụzo isheli ono yẹle ẹnya ẹke aa-kpọbe itso ono dụtsua ụkporo ụkporo. Yọ bụkwaruphu ope b'e gude metatsua ya. Yọ bụkwanuru mkpọla-ọcha b'e gude meshia iphe, nweru nkolaba, ee-gude kobe ẹkwa l'itso ono yẹle iphe, ee-swebetsua ya. ");
INSERT INTO iqw_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","A bya l'ụsa ogbodufu ono l'ụzo ẹnyanwu-arịba iya bụkwa ẹkwa, dụ ụkporo nkwo-ẹka labụ lẹ nkwo-ẹka iri l'ogologo b'e kweru; gude gebuta iya. Ẹphe abya emeta itso iri, aa-kpọbe l'ụzo ẹnyanwu-arịba ono; metakwaphu ẹnya ẹke aa-kpọbetsua itso ono ụzo iri. Ẹphe abya egude mkpọla-ọcha meshia iphe, nweru nkolaba, ee-gudeje kobe ẹkwa ono l'itso ono; mẹ iphe, ee-swebetsua l'itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ụsa ogbodufu ono l'ụzo ẹnyanwu-ahata iya dụkwaphu ụkporo nkwo-ẹka labụ lẹ nkwo-ẹka iri l'ogologo. ");
INSERT INTO iqw_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ẹphe abya ekwee ẹkwa, dụ nkwo-ẹka iri l'ise l'ogologo t'e gude gebuta ẹka ọnu ogbodufu ono ẹke iya ọphu. Itso, aa-kpọbe iya yẹle ẹnya ẹke aa-kpọbetsua itso ono dụtsua ẹto ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","A bya l'ọnu ogbodufu ono ẹka iya ọphu; bụkwaphu ẹkwa, dụ nkwo-ẹka iri l'ise bẹ ẹphe kweru t'e gude gebuta iya. Itso, aa-kpọbe iya yẹle ẹnya ẹke aa-kpọbetsua itso ono dụtsukwaaphu ẹto ẹto. ");
INSERT INTO iqw_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Iphe bụ ẹkwa, ee-gude gebuta ogbodufu ono mgburumgburu bụkota òwúú ọcha, a swịru l'ọ bụ ụdo bẹ ẹphe gude kwee ya. ");
INSERT INTO iqw_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ẹnya ẹke aa-kpọbetsua itso, ee-gude kpọ-buta ogbodufu ono mgburumgburu bụ ope bẹ ẹphe gude meshia ya. Iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono yẹle iphe, ee-swebetsua l'itso ono abụkwanuru mkpọla-ọcha bẹ ẹphe gude meshia iya. Ishi itso ono bẹ ẹphe wụru mkpọla-ọcha. Iphe, ee-swebegbaa l'itso ono, ee-gude kpọ-buta ogbodufu ono mgburumgburu bụ mkpọla-ọcha bẹ ẹphe gude meshia ya. ");
INSERT INTO iqw_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","E gude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe yẹle k'ọcha, a swịru l'ọ bụ ụdo; gude kwee ẹkwa, dụ nkwo-ẹka ụkporo l'ogologo; t'e gude gechita ọnu ogbodufu ono. Yọ bụru ndu gude ngga ekwe ẹkwa bẹ meru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Ọnu-abata iya ono bẹ ẹphe metaru itso ẹno; ọwaa ẹnya ẹke aa-kpọbetsua itso ono ụzo ẹno. Iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono; mẹ iphe, ee-swebetsua l'itso ono bẹ ẹphe mekotaru lẹ mkpọla-ọcha. Ẹphe awụkotakwaphu mkpọla-ọcha l'eli itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Iphe bụ nggu, ee-libegbaa eri ụlo-ẹ́kwà ono; mẹkwaphu k'ogbodufu ono bẹ ẹphe gude ope mekota. ");
INSERT INTO iqw_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ọwaa bụ mkpakọ iphe, e gude mee ụlo-ẹ́kwà ọbu; mbụ ụlo-ẹ́kwà Ekemu ono. Ọ bụ Mósisu sụru tẹ ndu ikfu Lívayi dekota iphemiphe ọbule ono l'ẹkwo. Onye ishi ẹphe bụ Itama Érọnu, bụ onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalẹlu Úri Họru; bụru onye ikfu Júda mekotaru iphemiphe ọbule, Ojejoje tụru Mósisu ọnu t'e mee. ");
INSERT INTO iqw_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Onye ẹphe l'iya tụkoru mee ya bụ Oholiyabu Ahisamaku, bụ onye ikfu Dánu. Ọ maru ome nka; maru ẹrengete; bya abụru onye maru ẹge eegudeje òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha dengashia iphe edengashi. ");
INSERT INTO iqw_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Mkpọla-ododo, a tụtaru lẹ ngwẹja-amama, a nụru t'e gude mee ụlo ono, dụ nsọ ono dụ ụkporo ụnu iri; l'ụnu iri lẹ tete; l'ụkporo ishingu l'iri. Mkpọla-ododo ono abụru ọphu ha l'ọ bụ k'eze-ụlo Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Mkpọla-ọcha, ndu Ízurẹlu tụtaru teke ono, a gụru ẹphe ọgu ono dụ ụkporo ụnu ẹto; l'ụnu iri lẹ tete; l'ụkporo ẹsato l'iri l'ise. Mkpọla-ọcha ono abụru ọphu ha l'ọ bụ k'eze-ụlo Nchileke. ");
INSERT INTO iqw_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Iphe, mkpọla-ọcha ọbu gbaru ẹphe l'ẹhu l'ẹhu bụ nkere-ẹbo mkpọla-ọcha. Mkpọla-ọcha ono abụru ọphu ha l'ọ bụ k'eze-ụlo Nchileke. Ndu a gụru teke ono, a gụru ndu Ízurẹlu ọgu ono bụ shita lẹ ndu nọru ụkporo afa tụgburu. Iphe, ẹphe dụ bụ ụkporo ụnu madzụ ugbo ụkporo ẹto l'iri l'ise; l'ụnu madzụ ẹsato; l'ụkporo madzụ iri l'ẹsaa; lẹ ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ụkporo ụnu mkpọla-ọcha ugbo ụkporo l'iri l'ẹsaa; l'ụnu mkpọla-ọcha ugbo iri bẹ ẹphe gude kpụshigbaa ẹnya ẹka aa-kpọbegbaa ọkpa ibo ono, ee-gude kụ-chita ụlo-ẹ́kwà ono ụzo ụkporo ise. Ụnu mkpọla-ọcha ẹsaa l'ụkporo mkpọla-ọcha iri bẹ ẹphe gude kpụa ẹnya lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ẹphe egude ụnu mkpọla-ọcha ẹno; l'ụkporo mkpọla-ọcha ẹsato; lẹ mkpọla-ọcha iri l'ise kpụshia iphe, nweru nkolaba, ee-gude kobe ẹkwa ono l'itso ono; bya egudekwa iya phu wụkota l'ishi itso ono; bya egude iya mekwaaphu iphe, ee-swebegbaa l'itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ẹphe tụtakwaruphu ụkporo unu ope ugbo ụkporo l'ishingu; l'ụnu ope ise lẹ ngwẹja-amama ono. ");
INSERT INTO iqw_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ẹphe egude iya kpụa ẹnya ẹka aa-kpọbegbaa itso k'ọnu Ụlo-Ẹ́kwà Ndzuko ono; bya egudekwa iya phu kpụa ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono yẹle iphe ono, dụ l'ọ bụ ụgbu ono; waa ngwa ẹnya-ngwẹja ono l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Ẹphe egudekwa iya phụ kpụa ẹnya ẹke aa-kpọbegbaa itso, ee-gude kpọ-buta ogbodufu ono; wakwaphu k'ọnu iya; mẹ nggu, ee-libegbaa eri ụlo-ẹ́kwà ono; mẹkwaphu k'ogbodufu iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ẹphe egude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; mẹ ọphu eke uswuswe; kweeru ndu achịjeru Nchileke ẹja uwe, ẹphe e-yeje gude eje ozi l'ụlo-ẹ́kwà ono. Ẹphe kwekwaruphu Érọnu uwe, dụ nsọ; bụ iya bụ ẹge Ojejoje sụru Mósisu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ẹphe egude òwúú mkpọla-ododo; òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; kwee uwe-ukuvu. ");
INSERT INTO iqw_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ẹphe eworu mkpọla-ododo tsusaa etsusa; mee ya; yọ dụ phẹripheri; woru iya washịa agwara; t'ẹphe gude agwara ono tsokota lẹ mgbaku òwúú urukpu-urukpu; kẹ mee-mee; kẹ uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo. Yọ bụru onye maru ome nka meru iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ẹphe eworu gbịriri ẹkwa labụ gude ligbabe; k'ọphu aa-nyajẹ iya l'ukuvu ẹphe ẹbo; gude gbịriri ẹkwa ono ẹphe ẹbo ligbabe lẹ k'ifu yẹle k'azụ. ");
INSERT INTO iqw_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ẹphe abya ekwekwaphu gbịriri ẹkwa, ee-gudeje kebuta iya l'ukfu ye iya. Gbịriri ẹkwa ono bẹ yẹle ifọdu ono chịko bụru iphe lanụ. Iphe, e gude kwee ya bụ òwúú mkpọla-ododo yẹle òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mkpuma ónìkùsù phụ bẹ ẹphe wụru mkpọla-ododo l'igburumọnu iya. Yọ bụru ẹge ono, onye apyị mkpuma, vu oke aswa akashịje ẹpha lẹ mkpuma; gude mee ya iphe-ọhubama ono bụ ẹge ẹphe kakọtaru ẹpha ụnwu Ízurẹlu lẹ mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ẹphe abya adzụpyabe mkpuma labụ ono l'eli uwe-ukuvu phụ ẹphe ẹbo; k'ọphu Ojejoje e-gudeje iya nyata ụnwu Ízurẹlu; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ẹphe abya ekwee uwe-ọkpoma phụ, ee-gudeje achọ iphe, bụ uche-obu yẹbe Ojejoje phụ. Ẹphe kweru iya; yọ dụ l'ọ bụ uwe-ukuvu phụ, e kweru l'òwúú mkpọla-ododo yẹle òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo. Yọ bụru onye maru ome nka meru iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","O nweru mgberemẹku ẹno; dụ nkwegba labụ. Mgberemẹku iya ono ẹphe ẹno chịkokwa hakọta ẹnya-nhamụnha. Ogologo iya dụ nkwo-ẹka lanụ; ụsa iya adụkwaphu nkwo-ẹka lanụ. ");
INSERT INTO iqw_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ẹphe abya adzụa mkpuma, vugbaa oke aswa; yọ kpọo giriri ụzo ẹno l'ẹ́kwà ono. Mkpuma, nọ l'ogiri kẹ mbụ bụ rubi; tópàzù; mẹ bérìlù. ");
INSERT INTO iqw_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","K'ẹbo bụ tọ̀kwásù; sáfàyà; mẹ émèràlùdù. ");
INSERT INTO iqw_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","K'ẹto abụru jásìntù; ágètù; ọwaa ámìtìsùtù. ");
INSERT INTO iqw_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","K'ẹno abụru kìrị́sòlàyìtù yẹle ónìkùsù; mẹ jásụ̀pà. Ẹphe abya awụa mkpọla-ododo l'igburumọnu mkpuma ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Iphe, ọ dụ bụ mkpuma iri l'ẹbo. Ephe l'ẹphe ha nọ-chitsuaru ẹnya ẹpha ụnwu Ízurẹlu nanụ nanụ. Ẹphe abya edetsua ẹpha ụnwu Ízurẹlu ono lẹ mkpuma ono; yọ dụ l'ọ bụ iphe-ọhubama nọ-chia ẹnya ikfu iri l'ẹbo ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ẹphe egude òwúú ọkpobe mkpọla-ododo swịshia gwọgirigwo, ee-likfubegbaa l'uwe-ọkpoma ọbu; mbụ swịshia ya; yọ dụ l'ọ bụ onye swịru ụdo. ");
INSERT INTO iqw_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ẹphe egude mkpọla-ododo meta echi labụ; yetsua l'ishi uwe-ọkpoma ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","bya eworu gwọgirigwo phụ libetsua l'echi ono, e yegbaaru l'ishi uwe-ọkpoma ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ẹphe abya ewota ishi gwọgirigwo ono ishi iya ọphu likfubekwaphu lẹ mkpọla-ododo phụ, a wụru l'igburumọnu mkpuma labụ phụ, e likfuberu l'eli uwe-ukuvu phụ. ");
INSERT INTO iqw_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ẹphe abya egude mkpọla-ododo meta echi labụ ọdo; likfube l'ishi uwe-ọkpoma ọbu l'ụzo alị. Ẹphe likfuberu iya l'ime uwe-ọkpoma ọbu; ibyiya ọphu tukoru l'eli uwe-ukuvu phụ. ");
INSERT INTO iqw_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ẹphe abya egude mkpọla-ododo metafua echi ẹbo ọdo; libetsua l'ishishi gbịriri ẹkwa labụ phụ l'ụzo alị; mbụ gbịriri ẹkwa ono, e liberu l'eli uwe-ukuvu ono. Ẹphe liberu iya tẹmanu e rua ẹke ono, a nmaru gbịriri ẹkwa, a tụ-butaru l'ukfu uwe-ukuvu ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Echi uwe-ọkpoma phụ bẹ ẹphe gude eri, e gude òwúú urukpu-urukpu swịa; libetsua l'echi uwe-ukuvu phụ; k'ọphu ọo-nọdu lẹ mgboro gbịriri ẹkwa, a tụ-butaru l'ukfu phụ; k'ọphu uwe-ọkpoma phụ ta anọdujeshi akụ lọkpalokpa l'eli uwe-ukuvu ono; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ẹphe egude ẹkwa, dụ urukpu-urukpu mee uwe-nlọkpuru, ee-yeje uwe-ukuvu ono l'eli iya. Yọ bụru onye maru okwe ẹkwa ọhuma kweru iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ẹphe kweru iya; ẹke eepyoje iya ishi anọdu l'echilabu iya; bya eswia igburumọnu iya ẹge eeswije olu uwe-a; t'ẹ b'ọ lakahụ. ");
INSERT INTO iqw_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ẹphe egude òwúú, eke urukpu-urukpu; ọphu eke mee-mee; ọphu eke uswuswe; mẹ k'ọcha, a swịru l'ọ bụ ụdo; metatsua iphe, dụgbaa l'ọ bụ akpụru ụtara-okumu; dophee ọnu uwe ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ẹphe abya egude ọkpobe mkpọla-ododo meshia mgbịrigba dophee igburumọnu uwe ono mgburumgburu lẹ mgbaku iphe ono, dụgbaa l'ọ bụ akpụru ụtara-okumu ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Mgbịrigba ono; ọwaa iphe ono, e meru; yọ dụ l'ọ bụ akpụru ụtara-okumu ono; anọ-phee igbirimọnu uwe ono mgburumgburu. E dengashiru iya edengashi l'ọnu uwe ono, ee-yeje ejeru Ojejoje ozi ono; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ẹphe egude òwúú ọcha kweeru Érọnu yẹle ụnwu iya uwe-nlọkpuru. Yọ bụru onye maru okwe ẹkwa ọhuma kweru iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ẹphe gudekwaphu òwúú ọcha kwee okpu-ẹkwa ono; mẹ okpu ndu ono, achịjeru Nchileke ẹja ono; gude òwúú ọcha, a swịru l'ọ bụ ụdo kwee nwịba ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ẹphe gude òwúú ọcha, a swịru l'ọ bụ ụdo; ọphu eke urukpu-urukpu; ọphu eke mee-mee; mẹ ọphu eke uswuswe; mee ẹkwa-ukfu ono; bụ iya bụ ozi onye maru odengashi iphe edengashi; bya abụru ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ẹphe egude ọkpobe mkpọla-ododo meta iphe, dụ l'ọ bụ ekwekwerekwe; yọ bụru okpu, dụ nsọ; bya edee ya iphe ẹge-a, eedeje l'iphe-ọhubama-a. Iphe, ẹphe deru iya bụ: IPHE, DỤRU OJEJOJE NSỌ. ");
INSERT INTO iqw_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ẹphe abya ewota eri, e gude òwúú, eke urukpu-urukpu swịa; libe l'iphe ono, dụ l'ọ bụ ekwekwerekwe ono; woru iya lipyabe l'ifu okpu-ẹkwa. ");
INSERT INTO iqw_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nta-a bẹ ụlo-ẹ́kwà ono; mbụ Ụlo-Ẹ́kwà Ndzuko ono b'e meghewaru. Ndu Ízurẹlu mekotawaru iya ẹge Ojejoje sụru Mósisu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ya ndono; ẹphe achịta iphe ụlo-ẹ́kwà ono l'ọ ha chịtaru Mósisu; mbụ ụlo-ẹ́kwà ono; mẹ ngwa, tso iya nụ; dụ l'ọ bụ iphe iya ono, nweru nkolaba ono; mẹ ibo ono, ee-gude kụ-chita ụlo-ẹ́kwà ono; mẹ oshi ono, ee-gudegbaa swebushia lẹ mgbo ono; mẹ itso iya ono; mẹ ẹnya ẹke aa-kpọbe itso ono; mẹ ọkpa ibo ono. ");
INSERT INTO iqw_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ẹphe chịtakwaruphu akpọ ebyila ono, a tsẹru l'uswe, ee-gude kpua ụlo-ẹ́kwà ono; akpọ umoro-ẹnyimu ono; ẹkwa ono, ee-gude gebuta Ẹke-Kakọta-ọdu-Nsọ; ");
INSERT INTO iqw_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Okpoko Ekemu ono yẹle mgbọro ono, ee-gudeje apa iya ono; okfu okpoko ono, aa-nọduje akfụ ụgwo iphe, dụ ẹji ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","teburu ono yẹle ngwa, tso iya nụ; buredi ono, ee-dobeje Ojejoje l'ifu ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","iphe ono, eegvubeje urọku ono, e meru l'ọkpobe mkpọla-ododo ono; urọku iya ono yẹle ngwa iya l'ọ ha; manụ ono, ee-gudeje amụ ọku ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ẹnya-ngwẹja ono, e meru lẹ mkpọla-ododo ono; manụ ono, aa-wụ l'ishi ono; ínsẹnsu ono, eshi mkpọ ono; ẹkwa ono, ee-kochita ọnu ụlo-ẹ́kwà ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono, e gude ope mee ono; iphe iya ono, dụ l'ọ bụ ụgbu ono; mgbọro iya ono yẹle ngwa iya l'ọ ha; eze efere ono yẹle iphe ono, aa-sụbeje iya ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ẹkwa ono, ee-gude gebuta ogbodufu ono yẹle itso iya; ẹnya ẹke aa-kpọbetsua itso ono l'ọ ha; ẹkwa ono, ee-gude gechita ọnu ogbodufu ono; eri iya; nggu iya yẹle iphemiphe, ee-gude eje ozi l'ụlo-ẹ́kwà ono; mbụ Ụlo-Ẹ́kwà Ndzuko ono; ");
INSERT INTO iqw_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","mẹ uwe ono, e kweru ekwekwe, ee-yeje gude eje ozi l'ụlo-nsọ ono; mbụ uwe, dụ nsọ kẹ Érọnu, bụ onye achịjeru Nchileke ẹja yẹle k'ụnwu iya, ẹphe e-yeje teke ẹphe eje ozi ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ndu Ízurẹlu achịko iphe ono rụkota l'ẹge Ojejoje tụru Mósisu ọnu iya. ");
INSERT INTO iqw_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mósisu abya elee ẹnya l'ozi ono; phụa l'ẹphe jekotawaru iya ẹge Ojejoje sụru t'e jee ya. Yọ bya agọoru ẹphe ọnu; gude kele ẹphe ekele k'ozi ono, ẹphe jeru ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ya ndono; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“T'ọ kpọbe ụlo-ẹ́kwà ono; mbụ Ụlo-Ẹ́kwà Ndzuko ono mbọku mbụ l'ọnwa kẹ mbụ. ");
INSERT INTO iqw_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Paru Okpoko Ekemu ono sụbe l'ime iya; nggu ewota ẹkwa ono gude gebuta iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Nggu apabata teburu ono yẹle ngwa iya. Nggu apabatakwaphụ iphe ono, eegvubeje urọku ono; dozitsua urọku, nọ iya nụ. ");
INSERT INTO iqw_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Nggu apatakwaphu ẹnya-ngwẹja ínsẹnsu ono, e meru lẹ mkpọla-ododo ono; sụbe l'ifu Okpoko Ekemu ono; gude ẹkwa ono gebuta ọnu ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Nggu asụbe ẹnya-ngwẹja, bụ iya bụ ẹke ono, ee-gwoje ngwẹja-ukfuru ono l'ifu ọnu ụlo-ẹ́kwà ono; mbụ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Nggu apata eze efere ono sụbe lẹ mgbaku Ụlo-Ẹ́kwà Ndzuko ono yẹle ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono; kuru mini ye iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Nggu achịta ẹkwa ogbodufu ono gude gebuta ogbodufu ono mgburumgburu; nggu ewotakwaphu ẹkwa ọnu ogbodufu ono kochita ọnu iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Nggu ewota manụ ono, aawụje l'ishi ono; wụa l'ụlo-ẹ́kwà ono yẹle iphemiphe ọbule, nụ iya nụ; shi ẹge ono doo yẹle iphe, bụ iphe, nọ iya nụ nsọ; t'ọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Nggu awụkwaaphu ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono manụ yẹle ngwa iya l'ọ ha; shikwaphu ẹge ono doo ya nsọ; t'ọ bụru iphe, dụ nsọ nshinu. ");
INSERT INTO iqw_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nggu awụkwaaphu eze efere ono yẹle ọkpa iya manụ; shi ẹge ono doo ya nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Nggu eduta Érọnu yẹle ụnwu iya bya l'ọnu Ụlo-Ẹ́kwà Ndzuko ono; ghụa ẹphe ẹhu. ");
INSERT INTO iqw_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nggu achịta uwe ono, dụ nsọ ono yee Érọnu; wụa ya manụ l'ishi gude doo ya nsọ; t'ọ bụru onye achịjeru Nchileke ẹja l'ozi iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Nggu edutakwaphu ụnwu iya yeshia ẹphe uwe-nlọkpuru phụ. ");
INSERT INTO iqw_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nggu awụa ẹphe manụ l'ishi ẹge ị wụru nna ẹphe; t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya. Manụ ono, ịi-wụ ẹphe l'ishi ono e-me ẹphe; t'ẹphe bụru ndu achịjeru Nchileke ẹja l'ozi iya; tsube l'ọgbo sweru ọgbo.” ");
INSERT INTO iqw_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mósisu atụko iphe ono l'ọ ha mekota ẹge Ojejoje tụru iya ọnu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Yo be mbọku mbụ; l'ọnwa kẹ mbụ l'afa k'ẹbo; e woru ụlo-ẹ́kwà ono kpọbe. ");
INSERT INTO iqw_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mósisu eworu ẹnya ẹke aa-kpọbetsua ibo ụlo-ẹ́kwà ono; mẹ itso iya; kfụbegbaa; bya akpọbe iya ibo ono; bya eye iya iphe ono, ee-gude swebushia l'ibo ono; bya akpọbekwa iya phụ itso ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Yo wota ẹkwa ono phụshia l'eli ụlo-ẹ́kwà ono; bya achịta iphe phụ-chita ụlo-ẹ́kwà ono, bụ iya bụ ẹge Ojejoje sụru t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yọ pata ekemu ono ye l'ime Okpoko Ọgba-ndzụ ono; woru mgbọro iya ono pyotsua l'okpoko ono; bya apata okfu okpoko ono, aa-nọdu akfụ ụgwo iphe, dụ ẹji ono; sụbe l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Yọ bya teke ono bya apata okpoko ono pabata l'ụlo-ẹ́kwà ono; bya ewota ẹkwa ono gebuta Okpoko Ekemu ono; bụ iya bụ ẹge Ojejoje sụru iya t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mósisu abya apata teburu ono sụbe lẹ Ụlo-Ẹ́kwà Ndzuko ono l'ụzo isheli; l'azụ ẹkwa, e gude gebuta Ẹke-Kakọta-ọdu-Nsọ. ");
INSERT INTO iqw_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Yo woru buredi ono dobe Ojejoje l'ifu; bụ iya bụ ẹge Ojejoje sụru iya t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Yọ pata iphe ono, eegvubeje urọku ono sụbe lẹ Ụlo-Ẹ́kwà Ndzuko ono l'ụzo ọhuda yẹle teburu ono ghagbabe iya ifu; ");
INSERT INTO iqw_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","bya anọdu Ojejoje l'ifu l'ẹke ono mezitsua urọku, nọ iya nụ; bụ iya bụ ẹge Ojejoje tụru iya ọnu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Yọ patakwaphu ẹnya-ngwẹja ono, e meru lẹ mkpọla-ododo ono sụbe l'ifu ẹkwa ono, e gude gebuta Ẹke-Kakọta-ọdu-Nsọ ono; ");
INSERT INTO iqw_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","bya akpọo ínsẹnsu ọku l'ẹnya-ngwẹja ono; bụ iya bụ ẹge Ojejoje ziru iya t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Yo wota ẹkwa ono gude kochita ọnu ụlo-ẹ́kwà ono; ");
INSERT INTO iqw_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","bya eworu ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono sụbe lẹ mgboro ọnu Ụlo-Ẹ́kwà Ndzuko ono; bya egwooru Ojejoje ngwẹja-ukfuru yẹle ngwẹja-nri l'ẹnya-ngwẹja ono; bụ iya bụ ẹge Ojejoje tụru iya ekemu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Yọ bya apata eze efere ono sụbe lẹ mgbaku Ụlo-Ẹ́kwà Ndzuko ono yẹle ẹnya-ngwẹja ono, bụ ẹke ee-gwoje ngwẹja-ukfuru ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Yọ bụru eze efere ono bẹ Érọnu yẹle ụnwu iya; mẹ Mósisu gude kwọo ẹka; kwọo ọkpa. ");
INSERT INTO iqw_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Yọo bụje; teke ẹphe eme t'ẹphe bahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono; m'ọ bụ t'ẹphe jenyabe ẹnya-ngwẹja ono, bụ ẹke ono, eegwoje ngwẹja-ukfuru ono ntse; ẹphe akwọ-odu ẹka; kwọo ọkpa; bụ iya bụ ẹge Ojejoje tụru ẹphe ekemu t'ẹphe meje iya. ");
INSERT INTO iqw_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mósisu abya achịtakwaphu ẹkwa ogbodufu ono gude gebuta ogbodufu ụlo-ẹ́kwà ono; mẹ ẹnya-ngwẹja ono mgburumgburu; wotakwaphu ẹkwa ọnu ogbodufu ono kochita ọnu iya. Yọ bụru iya bụ lẹ Mósisu arụ-ghee ọru ọbu. ");
INSERT INTO iqw_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ya ndono; urukpu ono abya atsọ-kputa Ụlo-Ẹ́kwà Ndzuko ono; ọdu-biribiri Ojejoje abya eji ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mósisu ta dụ ike ye ishi lẹ Ụlo-Ẹ́kwà Ndzuko ono; kẹ l'urukpu tsọ-kputaru iya; ọdu-biribiri Ojejoje eji Ụlo-Ẹ́kwà Ndzuko ono ejiji. ");
INSERT INTO iqw_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Yọo bụje teke urukpu ono wụkahuru l'eli ụlo-ẹ́kwà ono; ndu Ízurẹlu akwalia. ");
INSERT INTO iqw_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ọ -bụru l'urukpu ono ta tụgbudu; ẹphe anọdu l'ẹke ẹphe nọ jeye mbọku, ọo-tụgbu. ");
INSERT INTO iqw_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ọ bụ iya bụ l'urukpu Ojejoje shi anọduje l'eli ụlo-ẹ́kwà ono l'eswe mgburumgburu. O -be l'ẹnyashi; yọ chalahaa l'ọbu ọku; dzuru ụlo ndu Ízurẹlu l'ọ ha. Yọ bụru ẹge ono b'o mekotaru iya jeye ndu Ízurẹlu ejegee ije ẹphe ono.");
INSERT INTO iqw_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ojejoje eshi lẹ Ụlo-Ẹ́kwà Ndzuko kua Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu ndọ-ọ: ‘O -nweru l'unu ha onye gude ngwẹja bya ọnu Ojejoje; t'onye ono kpụta eswi; m'ọ bụ atụru; m'ọ bụ eghu gude bya anị iya. ");
INSERT INTO iqw_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Ọ -bụru onye, bụ eswi b'o gude l'abyaru iya ogworu ngwẹja-ukfuru; t'onye ono kpụtakwa oke-eswi, ẹ ta adụdu ntụpo, nọ iya l'ẹhu; bya anụ l'ọnu Ụlo-Ẹ́kwà Ndzuko; k'ọphu Ojejoje a-natakwanu iya. ");
INSERT INTO iqw_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","T'onye ono byibe anụ ono, ọ nụru t'ọ bụru ngwẹja-ukfuru ono ẹka l'ishi. Aa-nata iya t'ọ nọ-chia ẹnya onye ono; bụru iphe, ee-gude akfụ ụgwo iphe, dụ ẹji, onye ono meshiru. ");
INSERT INTO iqw_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","T'onye ono nọdu Ojejoje l'ifu gbua oke-eswi ono. Ụnwu Érọnu, bụ ndu achịjeru Nchileke ẹja egude mee oke-eswi ono phephee mgburumgburu l'ẹnya-ngwẹja l'ifu Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","T'ọ swakwaa anụ ono akpọ; bushia anụ iya ibiribe ibiribe. ");
INSERT INTO iqw_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ụnwu Érọnu, bụ onye achịjeru Nchileke ẹja abya akpọbe ọku l'ẹnya-ngwẹja ono; woru nkụ doo ya. ");
INSERT INTO iqw_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ndu ono, achịjeru Nchileke ẹja ono, bụ iya bụ ụnwu Érọnu abya eworu anụ ono, e bushiru ebushi ono; mẹ ishi iya; mẹ ẹ̀bà iya doo lẹ nkụ ono, e doru l'eli l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Iphe-ẹpho iya; ọwaa ẹka iya; mẹ ọkpa iya bẹ onye ono e-gude mini saa asasa. Teke e metsuaru; t'onye achịjeru Nchileke ẹja tụko iya l'ọ ha kpọo ọku l'ẹnya-ngwẹja ono; t'ọ bụru ngwẹja-ukfuru; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Ọ -bụru l'ọo eghu; m'ọ bụ atụru bẹ onye ọbu gude abya ogwo ngwẹja-ukfuru; t'ọ bụkwaru iphe, oo-wota bụ okee ya, ẹ to nwedu ẹke, ntụpo nọ iya l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","T'onye ono kpụta iya je l'ụzo isheli ẹnya-ngwẹja ono gbua ya Ojejoje l'ifu. Ndu ono, achịjeru Nchileke ẹja ono eworu mee anụ ono phephee mgburumgburu l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","T'onye ono bushia anụ ono ibiribe ibiribe. T'onye achịjeru Nchileke ẹja chịru yẹle ishi iya; mẹ ẹ̀bà iya doo l'eli nkụ ono, a kpọberu l'eli ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Iphe-ẹpho iya; ọwaa ẹka iya; mẹ ọkpa iya bẹ onye ono e-gude mini saa asasa. Onye achịjeru Nchileke ẹja atụko iya l'ọ ha kpọo ọku l'ẹnya-ngwẹja ono; t'ọ bụru ngwẹja-ukfuru; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Ọ -bụru l'ọo anụ-ẹ́bà bẹ onye ọbu gude bya ogworu Ojejoje ngwẹja-ukfuru ọbu; t'ọ bụkwaru ndo; m'ọ kwanu kparakobe bẹ oo-gude bya. ");
INSERT INTO iqw_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","T'onye achịjeru Nchileke ẹja nwụta iya bya l'ẹnya-ngwẹja ono; bya aswị-bufu iya ishi; kpọo ya ọku l'ẹnya-ngwẹja ono. Yọ haa mee ya t'ọ lashị lẹ mgboro ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","T'ọ chịfuta iya ọ̀kpá-nri; nmashịa ya ẹ́bà; woru iya wụshi l'ụzo ẹnyanwu-ahata ẹnya-ngwẹja ono; mbụ l'ẹke ono, aawụshije ntụ ono. ");
INSERT INTO iqw_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","T'o shi l'ẹ́bà iya ono lajaa ya ẹbo t'o gheru ọnu. Ọle t'ẹ b'ọ lajashị iya ẹbo t'ọ nọdu iche iche. T'onye achịjeru Nchileke ẹja woru iya kpọo ọku l'ẹnya-ngwẹja; mbụ l'eli nkụ ono, e doberu l'eli iya ono; t'ọ bụru ngwẹja-ukfuru; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Ọ -bụru ngwẹja-nri bẹ onye ọbu gude bya ogworu Ojejoje; t'ọ bụkwaru ntụ akpe; bẹ oo-gude bya. T'ọ gbashị iya manụ; yekwa iya phụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Teke o -metsuaru; t'o woru iya nụ ụnwu Érọnu, bụ ndu achịjeru Nchileke ẹja. T'onye achịjeru Nchileke ẹja hata ntụ akpe ọphu jiru ẹka; gbashị iya manụ; ye iya ínsẹnsu; kpọo ya ọku l'ẹnya-ngwẹja ono; t'ọ nọ-chia ẹnya-ngwẹja-nri; bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ngwẹja-nri ono ọphu wuduru nụ a-bụwaru kẹ Érọnu yẹle ụnwu iya. Ọ dụ nsọ nshinu; kẹ l'o shi lẹ ngwẹja-ọku, e gworu nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Teke ọ bụ ngwẹja-nri, e gheru lẹ ntụ-ọku b'i gude bya; t'ọ bụkwaru akara, e gude ntụ witu, ẹ te yedu iphe, ekoje buredi. T'e yekwa iya manụ. Ọdumeka; t'ọ bụru ẹcha-mbeke, ẹ te yedu iphe, ekoje buredi. T'e yekwa iya phụ manụ. ");
INSERT INTO iqw_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Teke ọ bụ lẹ ngwẹja ngu bụ ngwẹja-nri, e gheru lẹ mbeji; t'ọ bụkwaru ntụ akpe, a gwọkoberu manụ; mbụ ọphu ẹ te yedu iphe, ekoje buredi. ");
INSERT INTO iqw_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ii-gwepyashi iya egwepyashi; gbashị iya manụ; kẹ l'ọ kwa ngwẹja-nri b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ọ -bụru lẹ ngwẹja ngu bụ ngwẹja-nri, e shiru l'ite; t'ọ bụkwaru ntụ akpe, e yeru manụ bẹ ee-gude shia ya. ");
INSERT INTO iqw_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ọ bụ ngwẹja-nri, dụgbaa ẹge ono bẹ unu e-gudeje wotaru Ojejoje. Teke e gwotaru iya bya anụ onye achịjeru Nchileke ẹja; yo gude iya bya l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Onye ono, achịjeru Nchileke ẹja ono eshi lẹ ngwẹja ono hata ọphu ọo-hata je akpọo ọku l'ẹnya-ngwẹja ono; t'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ngwẹja-nri ono ọphu phọduru nụ bụwa kẹ Érọnu yẹle ụnwu iya. Ọ dụ nsọ nshinu; kẹ l'o shi lẹ ngwẹja-ọku, unu anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘T'ẹ b'ọ dụkwa ngwẹja-nri, unu gude bya ogworu Ojejoje ẹja, unu e-yeje iphe, ekoje buredi. Unu be eyejekwa iphe, ekoje buredi; m'ọ bụ manụ-ẹngu lẹ ngwẹja-ọku, unu anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Unu e-shije l'iphe ọdungu, unu kpataru l'okfu unu bya egwooru Ojejoje ngwẹja akpụru-mbụ. Ọlobu; unu ba akpọkwa iya ọku l'ẹnya-ngwẹja t'ọ bụru ngwẹja, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Unu yejekwa únú l'iphe bụ ngwẹja-nri, unu abya ọnu Ojejoje; kẹ l'únú dụ ụdudu ndzụ unu lẹ Nchileke gbaru. Unu yejekwa únú l'iphe, bụ ngwẹja, unu egwo egwogwo. ");
INSERT INTO iqw_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Ọ -bụru l'unu gude iphe ọdungu, unu kpataru l'okfu unu l'abya ogworu Ojejoje ngwẹja-nri; unu gbutakwa akpe, nọkwadu l'onyingu; hụa ahụhu; m'ọ kwanu tsua ya etsutsu gude gwoo ngwẹja-nri ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Unu gbashịjekwa iya manụ; unu eyekwa iya phụ ínsẹnsu; kẹ l'ọ kwa ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","T'onye achịjeru Nchileke ẹja wotakota ínsẹnsu ono; yọ hata akpe ono, e tsuru etsutsu ono; meta manụ gbashị iya; kpọo ya ọku l'ọzori ngwẹja ono. Ọ bụakwa ngwẹja-ọku, unu anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Ọ -bụru ngwẹja-ẹhu-agu bẹ madzụ abya egwogwo; ọ -bụru oke-eswi; m'ọ bụ nne-eswi b'o gude bya; t'onye ono gudekwa ọphu ẹ-te nwedu ntụpo. ");
INSERT INTO iqw_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","T'onye ono byibe anụ ono ẹka l'ishi; gbua l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. Teke e gbutsuaru iya; t'ụnwu Érọnu, bụ ndu achịjeru Nchileke ẹja gude mee anụ ono phephee l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","T'o shi l'anụ ono, e gude gwoo ngwẹja-ẹhu-agu ono bọta anụ, ngwẹja-ọku nụ Ojejoje. Iphe, ọo-bọta bụ ẹ̀bà, kwechiru iphe-ẹpho iya; waa ọphu nọkota l'iphe-ẹpho iya l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","T'ọ bọtakwaphu àkpụ̀rù-ose iya ẹphe ẹbo ye iya; mẹ ẹ̀bà ọphu nọ l'ụzo ose iya. T'o butakwaphu anyị iya yẹle àkpụ̀rù-ose iya. ");
INSERT INTO iqw_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","T'ụnwu Érọnu woru iya kpọo ọku l'ẹnya-ngwẹja l'eli ngwẹja-ukfuru ono, nọ l'eli nkụ ono, e doru l'ọku ono; t'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Ọ -bụru l'ọo anụ-ufu: okee ya; m'ọ bụ nyee ya bẹ madzụ gude l'abya ogworu Ojejoje ngwẹja-ẹhu-agu; t'ọ nụkwa ọphu ẹ-te nwedu ntụpo. ");
INSERT INTO iqw_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ọ -bụru nwatụru bẹ onye ọbu kpụ bya ọnu kẹ ngwẹja ọbu; t'ọ kpụkwaru iya bya Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","T'onye ono byibe atụru ono ẹka l'ishi; woru iya gbua l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. Teke e metsuaru; t'ụnwu Érọnu gude mee anụ ono phephee l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","T'o shi lẹ ngwẹja ẹhu-agu ono buta anụ, ee-gude gwooru Ojejoje ngwẹja-ọku. Ẹ̀bà iya l'ọ ha bẹ ee-wotakota; bya eshi l'ọkpu ukfu iya gbujita ukfumọdzu iya l'ọ ha, bụ ẹke ẹ̀bà anọje. Ee-wotakota ẹ̀bà, kwechiru iphe-ẹpho iya; mẹ ọphu nọkota l'iphe-ẹpho iya. ");
INSERT INTO iqw_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","T'ọ bọtakwaphu àkpụ̀rù-ose iya ẹphe ẹbo ye iya; mẹ ẹ̀bà, nọ l'ụzo ose iya. T'ọ tụko anyị iya yẹle àkpụ̀rù-ose iya bọfuta. ");
INSERT INTO iqw_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","T'onye achịjeru Nchileke ẹja wota iya je akpọoru Ojejoje ọku l'ẹnya-ngwẹja l'ọ bụ nri; mbụ ngwẹja-ọku, unu anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ọ -bụru eghu bẹ onye ọphu kpụ bya; t'onye ono kpụtakwa iya phụ bya Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","T'onye ono byibe eghu ono ẹka l'ishi; woru iya gbua l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. Teke e gbutsuaru iya; t'ụnwu Érọnu wota mee ya phephee l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Iphe, oo-shi l'eghu ono wota gude gwooru Ojejoje ngwẹja-ọku bụ ẹ̀bà, kwechiru iphe-ẹpho iya; mẹ ọphu nọkota l'iphe-ẹpho iya. ");
INSERT INTO iqw_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Yọ bọtakwaphu àkpụ̀rù-ose iya ẹphe ẹbo ye iya; mẹ ẹ̀bà, nọ iya nụ, bụ ọphu nọ l'ụzo ose iya. T'ọ tụko anyị iya yẹle àkpụ̀rù-ose iya ono bọfuta. ");
INSERT INTO iqw_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","T'onye achịjeru Nchileke ẹja wota iya je akpọo ọku l'ẹnya-ngwẹja; t'ọ bụru nri, e gworu ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. Ẹ̀bà anụ l'ọ ha bụkota kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ekemu-a bụ ekemu, a-dụru unu tsube l'ọgbo sweru ọgbo l'iphe bụ ẹke unu nọ; bụ iya bụ t'unu ba atajẹkwa ẹ̀bà iphe; unu te eri mee iphe.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Tọ dụ iya bụ; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ọwaa iphe, ii-kfuru ndu Ízurẹlu ndọ-ọ: ‘Teke o nweru onye meru ẹjo iphe l'amagama; daka-a ekemu Ojejoje tụru; ọwaa ẹge ọo-dụru iya: ");
INSERT INTO iqw_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ọ -bụru l'ọo eze onye ishi ndu achịjeru Nchileke ẹja bẹ meru iphe dụ ẹji; b'o shiakwa ẹge ono mee tẹ ikpe nma ọha l'ophu. T'onye ono kpụtakwa oke-eswi, ẹ-te nwedu ntụpo wotaru Ojejoje t'ọ bụru ngwẹja ẹjo iphe ono, o meru ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","T'onye ono kpụta oke-eswi ono gude bya Ojejoje l'ifu l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. T'o byibe oke-eswi ono ẹka l'ishi; gbua Ojejoje l'ifu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","T'o meta mee oke-eswi ono gude bahụ l'ime Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Teke o ruru; t'ọ tsẹe mkpụshi-ẹka lẹ mee ono phee ugbo ẹsaa l'ifu Ojejoje; mbụ l'ifu ẹkwa ono, dụ nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","T'o metakwaphu mee anụ ono wụru ye lẹ mpo ẹnya-ngwẹja ínsẹnsu phụ; mbụ ẹnya-ngwẹja ono, nọ Ojejoje l'ifu lẹ Ụlo-Ẹ́kwà Ndzuko phụ. T'ọ pata mee ọphu wuduru nụ je awụru ye l'ukfu ẹnya-ngwẹja ẹke eegwoje ngwẹja-ukfuru, nọ l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ẹ̀bà oke-eswi ono, e gude egwo ngwẹja-iphe, dụ ẹji ono; mbụ ẹ̀bà, kwechiru iphe-ẹpho iya; mẹ ẹ̀bà, nọ iya l'ẹpho l'ọ ha bẹ oo-heshikota. ");
INSERT INTO iqw_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","T'ọ bọfu iya àkpụ̀rù-ose iya ẹphe ẹbo; woshikota iya ẹ̀bà, nọ iya nụ; mbụ ọphu nọ l'ụzo ose iya. T'ọ tụko anyị iya yẹle àkpụ̀rù-ose iya ono bọfuta. ");
INSERT INTO iqw_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ọ bụ ẹge ono, eeheshije ẹ̀bà l'oke-eswi, e gude egwo ngwẹja-ẹhu-agu ono bụ ẹge ee-heshikwaphu ọwaa. Teke e metsuaru; t'onye ono, achịjeru Nchileke ẹja ono wota iya je akpọo ọku l'ẹnya-ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ọphu bụ akpọ oke-eswi ono; anụ iya l'ọ ha jeye l'ishi iya; ẹka iya; ọkpa iya; iphe-ẹpho iya; mẹ nshị iya; ");
INSERT INTO iqw_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mbụ anụ eswi ono l'ọ ha; bẹ oo-gude lụfu alụfu l'ọdu ndu Ízurẹlu ono. T'o gude iya je l'ẹke ẹ te merudu emeru; mbụ l'ẹke ono, aawụshije ntụ ono; je akpọo ya ọku l'eli ntụ ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ọ -bụru l'ọo ndu Ízurẹlu mgburumgburu bẹ dakaru ekemu Ojejoje l'amagama; bẹ ikpe nmaakwaru ẹphe; e guderu l'ẹphe ta amadụ amama. ");
INSERT INTO iqw_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ọ -bụru l'ọ byaru bya edoo ẹphe ẹnya mbụ iphe, ẹphe meru; t'ẹphe kpụtakwa nwa oke-eswi gude bya egwooru Nchileke ngwẹja-iphe, dụ ẹji ono l'ifu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Tẹ ndu bụ ọgurenya Ízurẹlu byibe oke-eswi ono ẹka l'ishi l'ifu Ojejoje; gbua ya l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Tẹ eze onye ishi ndu achịjeru Nchileke ẹja meta mee oke-eswi ono bahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Teke o ruru; t'ọ tsẹe mkpụshi-ẹka lẹ mee anụ ono; phee ya ugbo ẹsaa l'ifu Ojejoje; mbụ l'ifu ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","T'o metakwaphu mee ono wụru ye lẹ mpo ẹnya-ngwẹja phụ; mbụ ẹnya-ngwẹja ono, nọ Ojejoje l'ifu lẹ Ụlo-Ẹ́kwà Ndzuko ono. T'ọ pata mee ono ọphu wuduru nụ; wụru ye l'ukfu ẹnya-ngwẹja-ukfuru, bụ ọphu nọ l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","T'onye ono, achịjeru Nchileke ẹja ono woshikota ẹ̀bà anụ ono l'ọ ha kpọo ọku l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ọ bụlephu ẹge o meru oke-eswi ono, e gude gwoo ngwẹja-iphe, dụ ẹji ono bụ ẹge oo-me oke-eswi ọwaa. Ọ bụ ẹge ono bẹ onye ono, achịjeru Nchileke ẹja ono e-shi kfụaru ẹphe ụgwo ẹjo iphe ọbu, ẹphe meru ọbu; a gụkwanuaru ẹphe nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","T'ọ pata anụ oke-eswi ono gude lụfu l'azụ ọdu ndu Ízurẹlu ono; je akpọo ya ọku ẹge a kpọru oke-eswi k'ivuzọ phụ. Ọ kwa ngwẹja iphe, dụ ẹji ọha; b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Ọ -bụru l'ọo onye ishi bẹ dakaru ekemu Ojejoje l'amagama; mee iphe Ojejoje, bụ Nchileke tụru l'ekemu t'ẹ b'e meshi bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ọ -bụru l'iphe, dụ ẹji ono, o meru ono b'e meru; yo doo ya ẹnya; iphe, oo-wota bụ mkpi, ẹ ta dụdu ẹke ntụpo nọ iya l'ẹhu t'ọ bụru ngwẹja iya. ");
INSERT INTO iqw_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","T'o byibe mkpi ono ẹka l'ishi woru iya gbua l'ẹke eegbuje anụ, e gude egwo ngwẹja-ukfuru l'ifu Ojejoje. Ọ kwa ngwẹja-iphe, dụ ẹji b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","T'onye achịjeru Nchileke ẹja tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpo ẹnya-ngwẹja-ukfuru ono. Yo woru mee ono, wuduru nụ ono ye l'ukfu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ẹbà anụ ono l'ọ ha bẹ oo-heshikota kpọo ọku l'ẹnya-ngwẹja; ẹge a kpọru kẹ ngwẹja-ẹhu-agu phụ. Onye achịjeru Nchileke ẹja eshi ẹge ono kfụa ụgwo iphe, dụ ẹji ọbu, onye ọphu meru ọbu; t'e shi ẹge ono gụkwanuaru onye ono nvụ l'iphe, dụ ẹji iya ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Ọ -bụru l'o nweru onye Ízurẹlu mmanu ọdo, meru iphe, dụ ẹji l'amagama; mbụ mee iphe, Ojejoje tụru ekemu t'e b'e meshi bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ọ -bụru l'iphe, dụ ẹji ono, o meru ono b'e meru; yo doo ya ẹnya; iphe, oo-wota bụ nyee eghu, ẹ ta dụdu ẹke ntụpo nọ iya l'ẹhu; t'ọ bụru ngwẹja k'iphe, dụ ẹji ono, o meru ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","T'o byibe ẹka l'ishi anụ ono; woru iya gbua l'ẹke eegbuje anụ, e gude egwo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","T'onye achịjeru Nchileke ẹja tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpo ẹnya-ngwẹja-ukfuru ono. Yo woru mee ono ọphu wuduru nụ wụru ye l'ukfu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","T'o heshikota ẹ̀bà, nọ l'anụ ono; mbụ ẹge ono, eemeje kẹ ngwẹja-ẹhu-agu ono. Tẹ onye achịjeru Nchileke ẹja kpọo ya ọku l'ẹnya-ngwẹja; t'ọ bụru ngwẹja, mkpọ iya dụ Ojejoje maa; t'o shi ẹge ono kfụa ụgwo iphe, dụ ẹji, onye ọbu meru; k'ọphu aa-gụkwanuru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Teke ọ bụ atụru bẹ onye ọbu gude bya anụnu kẹ ngwẹja-iphe, dụ ẹji ọbu; tẹ onye ono gudekwa ada atụru, ẹ ta dụdu ẹke ntụpo nọ iya l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","T'o byibe ẹka l'ishi anụ ono; woru iya gbua; t'ọ bụru ngwẹja-iphe, dụ ẹji. Ẹke ọo-nọdu gbua ya bụ ẹke eegbuje anụ, e gude egwo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","T'onye achịjeru Nchileke ẹja tsẹe mkpụshi-ẹka lẹ mee anụ ono tee lẹ mpo ẹnya-ngwẹja-ukfuru ono. T'ọ wụru mee ono, wuduru nụ ono ye l'ukfu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Yo heshikota ẹ̀bà, nọ l'anụ ono ẹge ono, eemeje kẹ ngwẹja-ẹhu-agu ono. Onye achịjeru Nchileke ẹja akpọo ya ọku l'ẹnya-ngwẹja; t'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje maa; t'o shi ẹge ono kfụa ụgwo iphe, dụ ẹji, onye ọbu meru; k'ọphu aa-gụkwanuru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ọ -bụru lẹ madzụ phụru iphe, meru nụ; m'ọ bụ l'e meru t'ọ maru iphe, meru nụ; a raa ya arara t'onye phụru nụ bya agbaa ekebe; onye ọbu ta bya; bẹ iphe ọbu tukookwaru iya l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Ọ -bụkwanuru l'o nweru onye denyiru ẹka l'iphe, aasọ nsọ; m'ọ bụ odzu anụ-ẹgu-ẹgbudu, aasọ nsọ; odzu iphe-edobe, aasọ nsọ; m'ọ kwanụ l'odzu iphe, awụ l'ẹpho, aasọ nsọ; l'amagama bẹ onye ọbu bụakwa onye aasọ nsọ; bụkwaruphu onye ikpe nmaru. ");
INSERT INTO iqw_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Teke bụ l'o denyiru ẹka l'iphe, aasọ nsọ, shi madzụ l'ẹhu l'amagama; m'o -ruhuru; iphe, aasọ nsọ ọbu dụ ịduagha bẹ ọo-bụakwa onye ikpe nmaru m'ọ malẹruphu. ");
INSERT INTO iqw_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Onye ẹ-ta rịdu iphe arịri; kfụ-buhulephu je eria angụ l'ọwaa iphe ya e-me; m'ọ bụ iphe, dụ mma; m'ọ bụ iphe, dụ ẹji; ẹ tọ dụkpodua m'o -ruhuru; ọ bụru egbe ngụnu bẹ onye ọbu riru angụ ememe; l'ẹ b'o vuoduru ụzo rịa ya arịri; bẹ ikpe nmaakwaru iya; m'ọ malẹruphu. ");
INSERT INTO iqw_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Iphe, bụ teke a nọnyaaru; madzụ abya amaru l'o nweru iphe ono, a gụshiru ono ọphu o meru; tẹ onye ono kfukwaa ya. ");
INSERT INTO iqw_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Teke o kfutsuaru iya; t'ọ kpụta ada eghu iya; m'ọ bụ ada atụru iya bya anụ Ojejoje t'ọ bụru ngwẹja-iphe, dụ ẹji. Onye achịjeru Nchileke ẹja eshi ẹge ono kfụa ụgwo iphe dụ ẹji ọbu, onye ọbu meru ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Ọ -bụru l'ẹka te rudu onye ọbu lẹ nwatụru; t'o wotaru Ojejoje ndo labụ; m'ọ bụ kparakobe ẹbo k'ẹjo iphe ono, o meru ono. Nanụ bụ kẹ ngwẹja-iphe, dụ ẹji; ọphu abụru kẹ ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","T'onye ono chịru ụnwenu ono je achẹe onye achịjeru Nchileke ẹja. Onye ono, achịjeru Nchileke ẹja ono e-vuru ụzo gwoo ọphu bụ ngwẹja-iphe, dụ ẹji. T'ọ swị-kwoo ya olu; ọle t'ẹ b'o bufukwa iya ishi. ");
INSERT INTO iqw_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yo meta mee ngwẹja-iphe, dụ ẹji ono phee l'iku ẹnya-ngwẹja ono. Mee ọphu wuduru nụ bẹ ọo-ha t'ọ lashị l'ukfu ẹnya-ngwẹja ono. Ọ kwa ngwẹja-iphe, dụ ẹji b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Yo wota nwẹnu k'ẹbo gwoo ngwẹja-ukfuru; mee ya ẹge eemeje iya; shi ẹge ono gude iya kfụa ụgwo iphe, dụ ẹji, onye ọbu meru; t'a gụaru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Ọ -bụkwanuru l'onye ono ta adụdu ike gbata ndo labụ; m'ọ bụ kparakobe labụ; t'onye ono wota ntụ akpe, jiru ogbonga, e keru uzi iri; t'ọ bụru ngwẹja-iphe, dụ ẹji, kẹ iphe ono, o meru ono. T'ẹ b'o yekwa iya manụ; ọphu o yekwa iya ínsẹnsu; kẹ l'ọ kwa ngwẹja-iphe, dụ ẹji b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","T'onye ono gude iya wojeru onye achịjeru Nchileke ẹja. T'onye ono, achịjeru Nchileke ẹja ono hata iya ọphu jiru iya ẹka t'ọ nọ-chia ẹnya-ngwẹja ono; yọ kpọo ya ọku l'eli ẹnya-ngwẹja; t'ọ bụru ngwẹja-ọku, unu anụ Ojejoje; kẹ l'ọ kwa ngwẹja iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ọ kwa ẹge ono bẹ onye achịjeru Nchileke ẹja e-shije kfụa ụgwo iphe, dụ ẹji, onye ono meshiru; a gụaru iya nvụ. Iphe phọduru nụ lẹ ngwẹja ono a-bụru kẹ onye ono, achịjeru Nchileke ẹja ono; ẹge ono, eemeje kẹ ngwẹja-nri ono.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ojejoje abya ekfuru nụ Mósisu; sụ; iya: ");
INSERT INTO iqw_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ọ -bụru l'o nweru onye ta nụdu Ojejoje iphe, gbaru iya nụ; shi ẹge ono mee iphe, dụ ẹji l'amagama; t'onye ono kpụta eghu iya; m'ọ bụ ebyila iya, ẹ ta dụdu ntụpo, nọ iya l'ẹhu; bya anụ Ojejoje t'ọ bụru ngwẹja-ụgwo. T'e gudekwa mkpọla-ọcha k'eze-ụlo Nchileke maru aswa ebyila ono. Ọ kwa ngwẹja-ụgwo b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","T'onye ono mekwazi iphe ono, o mesweru ono; kẹ l'ẹ tọ nụdu Ojejoje iphe, gbaru iya nụ. Yo yekwakwa iya phụ oke lanụ l'ụzo ise l'iphe ono; tụko iya chịru nụ onye achịjeru Nchileke ẹja. Onye ono, achịjeru Nchileke ẹja ono egude ebyila phụ gwoo ngwẹja-ụgwo; shi ẹge ono kfụa ụgwo iphe, dụ ẹji, onye ono meru; a gụaru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“O -nweru onye meru iphe, dụ ẹji; mbụ l'o meru iphe, Ojejoje tụru ekemu t'ẹ b'e meshi; m'o -ruhuduru tọ ma amama; bẹ ikpe nmaakwaru iya; iphe, dụ ẹji ono atukokwaru iya phụ l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","T'onye ono shikwa l'ẹke eghu iya mẹ atụru iya nọ; kpụta ebyila, ẹ ta dụdu ntụpo, nọ iya l'ẹhu; t'ọ bụru ngwẹja-ụgwo. T'e gudekwa mkpọla-ọcha k'eze-ụlo Nchileke maru aswa ebyila ono. T'ọ nụ iya onye achịjeru Nchileke ẹja t'o gude iya kfụa ụgwo iphe ono, o meru l'amagama ono; t'a gụaru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ọ kwa ngwẹja onye ikpe-nmaru b'ọ bụ; kẹ l'ikpe nmaru onye ono l'ifu Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ọ -nweru onye meru iphe, dụ ẹji; shi ẹge ono meswee Ojejoje; mbụ l'ọ dzụru madzụ ibe iya ẹjo-ire l'iphe, a nụru iya t'o dobe; m'ọ bụ t'o leta ẹnya; ọdoo l'ọ naru madzụ ibe iya nfụ; m'ọ kwanụ l'o riru madzụ ibe iya uru; ");
INSERT INTO iqw_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","m'ọ bụ l'ọ tụtutaru iphe, tufahuru etufahụ; to kwe lẹ ya phụru iya; ọdoo l'ọ kpapyabẹru iphe, o meru gụa ẹnwa; ọdoo l'o meru iphe, dụgbaa ẹge ono; shi ẹge ono mee iphe, dụ ẹji: ");
INSERT INTO iqw_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","onye ono, meru iphe, dụ ẹji ono; shi ẹge ono meta iphe, ikpe nmaru iya; bụ iphe, oo-me bụ t'o wolata iphe, o nataru lẹ nfụ; m'ọ bụ ọphu o ritaru l'uru; m'ọ bụ ọphu a nụru iya t'o leta ẹnya; yo ria ya; m'ọ bụ iphe onye ọdo, tufahuru nụ; yọ tụtuta iya; ");
INSERT INTO iqw_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","m'ọ bụ iphe, dụgbaa ẹge ono, o meru; kpapyabẹ iya gụa ẹnwa. T'onye ono kfụkwaa ụgwo iphe ono l'ọ ha. Yo wotafua ọphu ha ẹge ono ugbo ise; tukobe iya; woru nụ onye nwe iphe ono. Mbọku, ọo-kfụ ụgwo ono bụ mbọku ono, oo-gude ngwẹja-ụgwo bya anụnu ono. ");
INSERT INTO iqw_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ngwẹja-ụgwo ono, oo-gworu Ojejoje ono bẹ oo-wotaru onye achịjeru Nchileke ẹja. T'o shi l'ẹke eghu iya mẹ atụru iya nọ kpụta ebyila, ẹ ta dụdu ẹke ntụpo nọ iya l'ẹhu. T'e gudekwa mkpọla-ọcha k'eze-ụlo Nchileke maru aswa ebyila ono. ");
INSERT INTO iqw_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Onye ono, achịjeru Nchileke ẹja ono abya anọdu Ojejoje l'ifu kfụa ụgwo iphe, dụ ẹji, onye ono meru; l'a gụkotaru iya nvụ l'iphemiphe ọbule ono, o meru, ikpe iya nmaru iya ono.” ");
INSERT INTO iqw_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ojejoje abya ekfuru nụ Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Ọwaa ekemu, ịi-tụru Érọnu yẹle ụnwu iya: Ekemu ọwaa bụ kẹ ngwẹja-ukfuru b'a tụ-doru iya: Tẹ ngwẹja-ukfuru nọdujekwa l'ọku l'ẹnya-ngwẹja ẹnyashi mgburumgburu jeye tẹ nchi bọhu. Ọku, nọ l'ẹnya-ngwẹja ono bẹ ee-me t'o nwu enwunwu tekenteke. ");
INSERT INTO iqw_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Teke o ruru l'ụtsu; t'onye ono, achịjeru Nchileke ẹja ono chịta uwe iya ono, e meru l'òwúú ọcha ono yẹle nwịba phụ yee. Yọ bya ekpota ntụ, shi lẹ ngwẹja-ukfuru ono, bụ ọphu ọku kepyashiru l'ẹnya-ngwẹja phụ; je asụbe l'iku ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Yọ bya eyefu uwe iya ono; chịta uwe ọdo yee; pata ntụ ono lụfu l'ọdu ndu Ízurẹlu ono; je asụbe l'ẹke ẹ te merudu emeru. ");
INSERT INTO iqw_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","T'ọku ono, nọ l'ẹnya-ngwẹja ono nwulekwaphu ẹge oonwu l'eli iya; t'ẹ b'e menyikwa iya emenyi. T'onye achịjeru Nchileke ẹja yejekwa iya nkụ l'ụtsu mbọku-mbọku. Yọ bya eworu anụ ngwẹja-ukfuru doo giriri l'eli iya; l'ọ kpọkwaaphu ẹ̀bà, shi l'anụ ngwẹja ẹhu-agu ọku l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","T'ọku ono nwujelephu l'eli ẹnya-ngwẹja ono mkpụrumkpuru; t'ẹ b'ọ nyịhujekwa anyịhu. ");
INSERT INTO iqw_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Ọwaa ekemu l'ẹge ee-gudeje egwo ngwẹja-nri ndọ-ọ: Ọ bụ ụnwu Érọnu a-nọduje Ojejoje l'ifu gwoo ngwẹja ono; l'ifu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","T'onye achịjeru Nchileke ẹja hata ntụ akpe ono, a gwọkoberu manụ ono ọphu jiru mkpoji-ẹka; wotakwaphu iphe bụ ínsẹnsu, e yeru lẹ ngwẹja-nri ono; je akpọo ọku l'ẹnya-ngwẹja ono t'ọ nọ-chia ẹnya-ngwẹja ono; bụru ngwẹja, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","E -metsua; tẹ Érọnu yẹle ụnwu iya ria ọphu wuduru nụ. Ọle t'ẹphe be yekwa iya iphe, ekoje buredi; ẹke ẹphe a-nọdu ria ya abụkwaru ẹke dụ nsọ. T'ẹphe nọdukwa l'etezi Ụlo-Ẹ́kwà Ndzuko ria ya. ");
INSERT INTO iqw_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","T'ẹ b'e yekobekwa iya iphe, ekoje buredi; ghee. Ono bẹ mu nụru ẹphe t'ọ bụru òkè iya nk'ẹphe lẹ ngwẹja-ọku ono. Ọ kakọta ọdu nsọ l'ọ bụ ngwẹja iphe, dụ ẹji; mẹ kẹ ngwẹja onye ikpe nmaru. ");
INSERT INTO iqw_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Iphe bụ onye, bụ nwoke l'eri Érọnu bẹ e-rije iya nụ. Ọ bụ ẹge ono bẹ ee-meje iphe, bụ ngwẹja-ọku, a nụ Ojejoje gbururu jeyewaru. Iphe bụ onye denyiru ẹka lẹ ngwẹja ono bẹ dụakwa nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Tọ dụ iya bụ; Ojejoje abya ekfuru nụ Mósisu ọdo; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ọwaa bụ ngwẹja, ndu eri Érọnu e-gudeje gwooru Ojejoje mbọku, a wụru ẹphe manụ l'ishi: Iphe, ẹphe e-gudeje bụ ntụ akpe, jiru nkere-iri ogbonga; t'ọ bụru ngwẹja-nri; ẹge eegwoje iya mbọku-mbọku. Nkere-ẹbo ya bẹ l'ee-gwo l'ụtsu; gwoo nkere-ẹbo ya ọphu l'urẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","T'e ye iya lẹ mbeji; gwọkobe iya manụ ọhuma; woru iya ghee egheghe pabata. Nggu abya eworu iya gwepyashia egwepyashi; gude bya egwooru Ojejoje; t'ọ bụru ngwẹja-nri, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Yọ bụru onye ono, bụ eri Érọnu ono, a wụru manụ t'ọ nọ-chia ẹnya iya bụru onye achịjeru Nchileke ẹja ono bẹ e-gwo ngwẹja ono l'onwiya. Iphe ono bụ iphe, a tọru ọkpa iya t'e tsoje jeye lẹ tutu yoyo. T'a kpọkotajekwa iya ọku l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Mbụ l'iphe bụ ngwẹja-nri, onye achịjeru Nchileke ẹja gworu bẹ aa-kpọ ọku l'ophu; t'ẹ b'e rikwa iya eriri.” ");
INSERT INTO iqw_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Tọ dụ iya bụ; Ojejoje abya ekfuru nụ Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Kfuru Érọnu yẹle ụnwu iya: L'ọwaa bụ ekemu kẹ ngwẹja-iphe, dụ ẹji. Ọ bụ l'ẹke ono, eegbuje anụ, e gude egwo ngwẹja-ukfuru ono bụkwaphu ẹke ee-gbuje anụ, e gude egwo ngwẹja-iphe, dụ ẹji; mbụ l'aa-nọduje Ojejoje l'ifu gbua anụ ọbu. Ọ kwa ngwẹja, kakọta ọdu nsọ b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","T'onye achịjeru Nchileke ẹja, bụ iya gworu ngwẹja-iphe, dụ ẹji ono rikwaa ya. T'ọ bụru l'ẹke dụ nsọ bẹ ọo-nọdu ria ya. Ẹke ọo-nọdu ria ya bụ l'etezi Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Iphe bụ onye denyiru ẹka l'anụ ono dụakwa nsọ. Ọ -bụru lẹ mee anụ ono daru l'uwe; t'a nọdukwa l'ẹke dụ nsọ saa uwe ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ọ -bụru ite, a kpụru l'ụra b'e gude shia anụ ono; t'a tụkpokwaa ite ọbu. Teke ọ bụ ite-igwe; t'e fuchaodu iya efucha; tẹmanu e gude mini nmasaa ya anmasa. ");
INSERT INTO iqw_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Iphe bụ ndu k'unwoke lẹ ndibe onye achịjeru Nchileke ẹja l'ẹphe ha a-ta iya. Ọ kwa ngwẹja, kakọta ọdu nsọ b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ọle; t'ẹ b'e erikwa anụ ngwẹja-iphe, dụ ẹji, e wobataru lẹ Ụlo-Ẹ́kwà Ndzuko gude kfụa ụgwo iphe, dụ ẹji lẹ Ẹke-dụ-Nsọ. T'a kpọkwaa ya ọku. ");
INSERT INTO iqw_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ọwaa bụ ekemu kẹ ngwẹja-ụgwo. Ọ kwa ngwẹja, kakọta ọdu nsọ b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ọ bụ l'ẹke, eegbuje anụ, e gude egwo ngwẹja-ukfuru ee-gbuje anụ, e gude egwo ngwẹja-ụgwo. E phephee mee ya l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ẹ̀bà anụ ono l'ọ ha bẹ ee-gude gwokotaru Nchileke; mbụ ẹ̀bà, shi l'ukfumọdzu iya; mẹ ọphu kwechiru iphe-ẹpho iya; ");
INSERT INTO iqw_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mẹ àkpụ̀rù-ose iya ẹphe ẹbo yẹle ẹ̀bà, nọ iya l'ụzo ose iya; waa anyị iya bẹ aa-tụko yẹle àkpụ̀rù-ose iya wota. ");
INSERT INTO iqw_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","T'onye achịjeru Nchileke ẹja tụkokwa iya kpọo ọku l'ẹnya-ngwẹja; t'ọ bụru ngwẹja-ọku; nụ Ojejoje. Ọ kwa ngwẹja-ụgwo b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Iphe bụ nwoke lẹ ndu achịjeru Nchileke ẹja e-rije iya. Ọ bụ l'ẹke dụ nsọ bẹ aa-nọduje ria ya; kẹ l'ọ bụ ngwẹja, dụshi nsọ ike. ");
INSERT INTO iqw_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Ọ bụlekwaphu ẹge ono, a tụru ọnu t'e meje iphe ngwẹja iphe, dụ ẹji ono bụ ẹge ee-meje kẹ ngwẹja ikpe-anmanma. Yọ bụru onye achịjeru Nchileke ẹja, gude iya akfụ ụgwo iphe, dụ ẹji ono bẹ e-nweru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ọ bụ onye achịjeru Nchileke ẹja, gworu madzụ ngwẹja-ukfuru e-nweru akpọ iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Iphe bụ ngwẹja-nri, e gheru lẹ ntụ-ọku; ọphu e shiru l'ite; m'ọ kwanụ ọphu e gheru lẹ mbeji bụkwa onye achịjeru Nchileke ẹja, gworu iya nụ nwe iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Iphe bụ ngwẹja-nri, a gwọkoberu manụ; mẹ k'ọkponku; tụkokwaruphu bụru k'ụnwu Érọnu l'ẹphe ha. T'ẹphe kejekwa iya ẹnya-nhamụnha. ");
INSERT INTO iqw_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ọwaa bụ ekemu kẹ ngwẹja-ẹhu-agu, madzụ gude bya ọnu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ọ -bụru l'onye ọbu anụ iya t'o gude kele Ojejoje ekele; bẹ iphe, onye ono e-gude tsoru iphe ngwẹja ono bụ akara, a gwọkoberu manụ. T'e ye iya iphe, ekoje buredi; ẹcha-mbeke, e meru manụ; ye iya iphe ekoje buredi; waa akara, e gude ntụ akpe, a gwọkoberu manụ ọhuma ọhuma. ");
INSERT INTO iqw_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Oo-gudekwaphu akara, e yekoberu iphe, ekoje buredi lẹ ngwẹja-ẹhu-agu ono, o gude kele Ojejoje ono. ");
INSERT INTO iqw_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","T'o shije lẹ ngwẹja ono wota akara lanụ l'iphe ngwẹja ono l'iche l'iche woru gwoo t'ọ bụru ngwẹja, e gworu nụ Ojejoje. Ọ bụ onye ono, achịjeru Nchileke ẹja, pheru mee ngwẹja ẹhu-agu phụ e-ri iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Anụ ngwẹja-ẹhu-agu ono, o gude bya okele Ojejoje ekele ono bẹ aa-takọta lẹ mbọku, a nụru iya Ojejoje. T'ẹ b'ọ dụkwa ọphu aa-ha t'ọ nọdu jeye l'ụtsu. ");
INSERT INTO iqw_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Ọle; ọ -bụkwanuru lẹ ngwẹja onye ọbu bụ ngwẹja, o gude eme iphe, o riburu angụ ememe; m'ọ kwanụ ngwẹja, ọ tụru obu iya ama bya agwagwa; t'a taa anụ ono mbọku, a nụru iya. Ọ -bụru l'ẹ ta tagedu iya; t'a tafụfua ya nchi-ta-abọhu iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Teke ọ bụ l'ọ phọdukwaduru-a lẹ mbọku k'ẹto ya; t'a kpọo ya ọku. ");
INSERT INTO iqw_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ọ -bụru l'o nweru anụ ngwẹja ẹhu-agu ono ọphu a taru lẹ mbọku k'ẹto bẹ aa-jịkakwa ngwẹja ọbu; ta gụ iya eyeru onye gworu iya nụ. Ọo-bụru ahụma b'o meru; yọ bụru onye riru iya nụ bẹ iphe, dụ ẹji, o meru a-tụ-koru l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Anụ ono ọphu ruru l'iphe, aasọ nsọ; t'ẹ b'a atakwa iya atata; t'e wokwaru iya kpọo ọku. Ọle ọ -bụkwanuru l'ọo anụ ọdo; t'onye ẹ taa sọdu nsọ taa ya. ");
INSERT INTO iqw_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","O -nweru onye aasọ nsọ, taru anụ ngwẹja-ẹhu-agu kẹ Ojejoje; t'e bufukwa iya lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","O -nweru onye denyiru ẹka l'iphe, aasọ nsọ; mbụ iphe dụ l'ọ bụ iphe, aasọ nsọ, shi madzụ l'ẹhu; m'ọ kwanụ anụ, aasọ nsọ; m'ọ bụ iphe ọdo, bụgbaa iphe, aasọ nsọ; o -metsua bya ataa anụ ono, e gude gwooru Ojejoje ngwẹja-ẹhu-agu ono; t'e bufukwa onye ọbu lẹ ndu nk'iya.” ");
INSERT INTO iqw_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kfuaru ndu Ízurẹlu sụ ẹphe-a: Unu ba atajẹkwa ẹ̀bà iphe; mbụ iphe, dụ l'ọ bụ ẹ̀bà eswi; m'ọ kwanụ ẹ̀bà atụru; m'ọ bụ ẹ̀bà eghu. ");
INSERT INTO iqw_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ọ -bụru ẹ̀bà anụ, nwụhuru l'onwiya; m'ọ bụ ọphu anụ-ẹgu-ẹgbudu gburu; bẹ unu nwekwaru ike gude iya mee iphe ọdo; ọlobu; unu ba atsọkwa iya ọnu. ");
INSERT INTO iqw_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Iphe bụ onye taru ẹ̀bà anụ, e gude gwoo ngwẹja-ọku; nụ Ojejoje; t'e bufukwa iya lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Iphe bụ ẹke unu laru; ẹke unu laru; unu be erijekwa mee-iphe; mbụ mee ẹnu; m'ọ bụ mee anụ. ");
INSERT INTO iqw_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Onye riru mee-iphe; unu bufukwa onye ono lẹ ndu nk'iya.” ");
INSERT INTO iqw_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Kfuaru ndu Ízurẹlu sụ ẹphe-a: Onye gude ngwẹja-ẹhu-agu abya ogworu nụ Ojejoje; t'o wotakwa ẹka iya ọphu ruberu Ojejoje gwooru iya; ");
INSERT INTO iqw_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","mbụ t'o gude ẹka iya wota ngwẹja-ọku nụ Ojejoje. Yo wota ẹ̀bà iya; waa ǹdụ́ iya nụ Ojejoje; woru ǹdụ́ iya ono màà àmàmà l'ifu Ojejoje t'ọ bụru ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Onye achịjeru Nchileke ẹja ewota ẹ̀bà iya ono kpọo ọku l'ẹnya-ngwẹja. Ọbule ǹdụ́ iya bụ kẹ Érọnu yẹle ụnwu iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","T'unu kwata ụtakfu ẹka-ụtara anụ ngwẹja-ẹhu-agu unu ono woru nụ onye ono, achịjeru Nchileke ẹja ono t'ọ bụru ụtu, a tụru iya. ");
INSERT INTO iqw_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Nwatibe Érọnu onye ọphu gude mee anụ ono yẹle ẹ̀bà iya je egwoo ngwẹja-ẹhu-agu ọbu bẹ aa-nụ ụtakfu ẹka-ụtara iya ono t'ọ bụru òkè iya nk'iya; ");
INSERT INTO iqw_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","kẹle ya shiwa lẹ ngwẹja-ẹhu-agu ono, ndu Ízurẹlu egwojeru nụ iya ono wota ǹdụ́ iya ono, aamàjẹ àmàmà ono yẹle ụtakfu iya ono, a tụru l'ụtu ono; woru nụ Érọnu yẹle ụnwu iya; t'ọ bụru òkè-iphe, ẹphe e-ketaje l'ẹka ndu Ízurẹlu jeye lẹ tutu yoyo. ");
INSERT INTO iqw_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ọwaa bụ òkè-iphe, shi lẹ ngwẹja-ọku, aanụ Ojejoje, bụ ọphu e doberu t'a nụje Érọnu yẹle ụnwu iya; keshinu mbọku, a fọfutaru ẹphe iche; t'ẹphe bụru ndu achịjeru Nchileke ẹja jejeru Ojejoje ozi. ");
INSERT INTO iqw_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Mbọku ono, a wụru ẹphe manụ l'ishi ono bẹ Ojejoje tụru ekemu sụ tẹ ndu Ízurẹlu nụje ẹphe ẹke ono t'ọ bụru òkè-iphe ẹphe; mẹ t'ọ bụkwaruphu ẹge ono bẹ aa-nụje iya ụnwu ẹphe shita l'ọgbo sweru ọgbo jeye lẹ tutu yoyo.” ");
INSERT INTO iqw_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ono bụ ekemu, ee-tsoje teke eegwo ngwẹja-ukfuru; ngwẹja-nri; ngwẹja-iphe, dụ ẹji; ngwẹja-ụgwo; ngwẹja, e gude eme madzụ t'ọ bụru onye achịjeru Nchileke ẹja; mẹ ngwẹja-ẹhu-agu; ");
INSERT INTO iqw_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","bụ iya bụ ekemu ono, Ojejoje tụru nụ Mósisu lẹ Ugvu Sáyịnayi lẹ mbọku ono, ọ sụru tẹ ndu Ízurẹlu wotaru yẹbe Ojejoje ngwẹja l'echi-ẹgu Sáyịnayi ono. ");
INSERT INTO iqw_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Duta Érọnu yẹle ụnwu iya; nggu achịta uwe ndu achịjeru Nchileke ẹja; nggu ewota manụ ọwu l'ishi ono; nggu akpụta oke-eswi ono, ee-gude gwoo ngwẹja-iphe, dụ ẹji ono; waa ebyila labụ ono; nggu apata nkata buredi ono, ẹ te yedu iphe, ekoje buredi ono. ");
INSERT INTO iqw_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Nggu ekukoo ndu Ízurẹlu l'ẹphe ha t'ẹphe dzukobe l'ọnu Ụlo-Ẹ́kwà Ndzuko.” ");
INSERT INTO iqw_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mósisu abya emekota ẹge ono, Ojejoje ziru iya t'o mee ono. Ndu Ízurẹlu abya edzua l'ifu Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mósisu asụ ndu Ízurẹlu: “Ọwaa iphe, Ojejoje sụru t'e mee ndọ-ọ.” ");
INSERT INTO iqw_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Yọ bya eduta Érọnu yẹle ụnwu iya lụfuta; bya egude mini ghụa ẹphe ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Yo wota uwe ime-ẹhu ono yee Érọnu; bya egude gbịriri ẹkwa-ukfu ono kebuta iya. Yọ bya ewota uwe-nlọkpuru yepyabe iya; bya ewota uwe-ukuvu ono yechita l'uwe-nlọkpuru ono; gude wẹrere ẹkwa ono, ee-gude tụ-buta uwe-ukuvu ono l'ukfu ono; gude tụ-buta iya. ");
INSERT INTO iqw_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Yo wota uwe-ọkpoma ono yekwaa ya phu; bya ewota ido Urimu; mẹ Tumimu ye l'uwe-ọkpoma ono. ");
INSERT INTO iqw_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Yọ bya eworu okpu-ẹkwa ono kpube iya; bya eworu iphe ono, dụ l'ọ bụ ekwekwerekwe, e meru lẹ mkpọla-ododo ono; mbụ okpu ono, dụ nsọ ono; libe l'okpu-ẹkwa ono l'ụzo ifu, bụ iya bụ ẹge Ojejoje tụru Mósisu ekemu sụ t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ya ndono; Mósisu ewota manụ ọwu l'ishi ọbu; bya awụkota l'ụlo-ẹ́kwà ono; mẹ iphemiphe ọbule, nọkota iya nụ; shi ẹge ono mee ya; yọ dụkota nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Yo meta manụ ono phee ugbo ẹsaa l'ẹnya-ngwẹja ono; yeru ngwa iya l'ọ ha; mẹ eze efere ono yẹle ọkpa iya; shi ẹge ono mee ya; yọ dụkota nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Yọ bya ewota manụ ọwu l'ishi ono wụa Érọnu l'ishi gude mee ya; yọ dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ya ndono; Mósisu abyakwaphu bya eduta ụnwu Érọnu dufuta; bya eworu uwe-nlọkpuru yeshia ẹphe; bya egude gbịriri ẹkwa-ukfu webegbaa ẹphe; bya ewota ẹkwa-okpu kpubegbaa ẹphe l'ishi; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Yọ bya akpụta oke-eswi ono, ee-gude gwoo ngwẹja-iphe, dụ ẹji ono bya; Érọnu yẹle ụnwu iya eworu ẹka byabẹ oke-eswi ono l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mósisu eworu oke-eswi ono gbua; bya emeta mee ya gude mkpụshi-ẹka iya tee ya lẹ mpo, nọgbaa l'ẹnya-ngwẹja ono; shi ẹge ono swafụ mmeru, nọ iya nụ. Yọ bya eworu ọphu phọduru nụ wụa l'ukfu ẹnya-ngwẹja ono; gude mee ya; yọ dụ nsọ; kfụa ụgwo iphe, dụ ẹji; shi ẹge ono swafụ mmeru, nọ iya nụ. ");
INSERT INTO iqw_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mósisu abya eheshikota ẹ̀bà, nọ l'iphe-ẹpho iya l'ọ ha; bọtakwaphu anyị iya; mẹ àkpụ̀rù-ose iya ẹphe ẹbo; mẹ ẹ̀bà, nọkota iya nụ; woru kpọo ọku l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Yọ bụru anụ oke-eswi ono; waa akpọ iya yẹle nshị iya; b'o gude je akpọo ọku l'azụ ọdu ndu Ízurẹlu; bụ iya bụ ẹge Ojejoje kfuru Mósisu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Yọ bya akpụta ebyila ono, ee-gude gwoo ngwẹja-ukfuru ono; Érọnu yẹle ụnwu iya abya eworu ẹka byabẹ ebyila ono l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mósisu egbua ebyila ono; nakọbe mee; pata mee ya ono phedzuru lẹ mgberemẹku ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Yo gbubushia anụ ebyila ono ibiribe ibiribe; bya eworu ishi iya yẹle ibiribe ibiribe iya ono; mẹ ẹ̀bà iya kpọkota ọku. ");
INSERT INTO iqw_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Yo gude mini saa iphe-ẹpho iya; mẹ ẹka iya yẹle ọkpa iya asasa; bya achịko anụ ebyila ono kpọo ọku l'ẹnya-ngwẹja ono; yọ bụru ngwẹja-ukfuru, a nụru Ojejoje; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma; bụ iya bụ ẹge Ojejoje tụru Mósisu ekemu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Yọ bya akpụta ebyila ọdo. Ebyila onanu bụ ọphu ee-gude mee Érọnu yẹle ụnwu iya t'ẹphe bụru ndu achịjeru Nchileke ẹja. Érọnu yẹle ụnwu iya eje eworu ẹka byabe iya l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mósisu egbua ebyila ono; bya ewota mee ya gbashị Érọnu l'atakpa-nchị ẹka-ụtara; mkpụshi-ẹka ezeke-ẹka ẹka-ụtara; mẹ mkpụshi-ọkpa ezeke-ọkpa ẹka-ụtara. ");
INSERT INTO iqw_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mósisu edufutakwaphu ụnwu Érọnu; bya etekwaaphu ẹphe mee ono l'atakpa-nchị ẹka-ụtara; mkpụshi-ẹka ezeke-ẹka ẹka-ụtara; mẹ mkpụshi-ọkpa ezeke-ọkpa ẹka-ụtara. Mósisu abya eworu mee ono phedzuru lẹ mgberemẹku ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Yo wota ẹ̀bà iya; mbụ ẹ̀bà, shi l'ukfumọdzu iya; mẹ ọphu nọkota l'iphe-ẹpho iya l'ọ ha; bọtakwaphu anyị iya; waa àkpụ̀rù-ose iya ẹphe ẹbo yẹle ẹ̀bà, nọkota iya nụ; wota ụtakfu ẹka-ụtara iya tụkwase iya. ");
INSERT INTO iqw_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Yo je lẹ nkata ono, e yeru buredi, ẹ te gudedu iphe, ekoje buredi ghee, nọ Ojejoje l'ifu ono; bya ewota ishi buredi lanụ; wotakwaphu ishi akara lanụ l'akara ono, a gwọkoberu manụ ghee ono; waa ẹcha-mbeke lanụ. Yo wota iya yekobe l'ẹ̀bà iya phụ yẹle ụtakfu ẹka-ụtara iya phụ. ");
INSERT INTO iqw_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Yọ tụko iphemiphe ono l'ọ ha dẹe Érọnu yẹle ụnwu iya l'ẹka; ẹphe abya eworu iya maa amama l'ifu Ojejoje t'ọ bụru ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mósisu abya anata ẹphe iphemiphe ono; chịkota yẹle ngwẹja-ukfuru phụ kpọo ọku l'ẹnya-ngwẹja ono; yọ bụru ngwẹja, e gude mee madzụ t'ọ bụru onye achịjeru Nchileke ẹja; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Yo wotakwaphu ǹdụ́ iya, bụ iya bụ oke, a hẹru Mósisu l'ebyila ono, e gude mee Érọnu phẹ t'ẹphe bụru ndu achịjeru Nchileke ẹja ono; makwaaphu amama l'ifu Ojejoje; t'ọ bụru ngwẹja-amama; bụ iya bụ ẹge Ojejoje tụru Mósisu l'ekemu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ya ndono; Mósisu abya emeta manụ, ọwu l'ishi ono; bya emetakwaphu mee ono, nọ l'ẹnya-ngwẹja ono; bya eworu phee Érọnu yẹle ụnwu iya l'ẹhu; mẹ l'uwe ẹphe. Yo mee Érọnu yẹle uwe iya; mee ụnwu iya phẹ l'uwe ẹphe; ẹphe adụkota nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mósisu asụ Érọnu yẹle ụnwu iya: “Unu je eshia anụ ono l'ifu Ụlo-Ẹ́kwà Ndzuko. Unu anọdu l'ẹke ono taa ya yẹle buredi ono, nọ lẹ nkata ono, e yeru ngwẹja, e gude mee unu t'unu bụru ndu achịjeru Nchileke ẹja ono; bụ iya bụ ẹge ya tụru ekemu sụ tẹ Érọnu yẹle ụnwu iya rije iya. ");
INSERT INTO iqw_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Anụ ono yẹle buredi ono ọphu phọduru nụ; bẹ unu e-woru je akpọo ọku. ");
INSERT INTO iqw_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Unu be egbeshikwa l'ifu Ụlo-Ẹ́kwà Ndzuko ono jeye ujiku ẹsaa; teke ee-mege k'ome unu t'unu bụru ndu achịjeru Nchileke ẹja; kẹ l'ọ bụ ujiku ẹsaa; bẹ ee-gude megee ya. ");
INSERT INTO iqw_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Iphe, e meru ntanụ-a bụ iphe, Ojejoje tụru ekemu t'e mee; gude kfụa ụgwo iphe, dụ ẹji, unu meru. ");
INSERT INTO iqw_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ọo ya meru iphe, unu a-nọ l'ọnu Ụlo-Ẹ́kwà Ndzuko: eswe l'ẹnyashi ujiku ẹsaa; shi ẹge ono mee iphe, Ojejoje sụru t'e meje; t'ọnwu be egbu unu; kẹ l'ọ kwa ẹge a tụru iya l'ekemu ndono.” ");
INSERT INTO iqw_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ya ndono; Érọnu yẹle ụnwu iya emekota iphe, Ojejoje shi l'ọnu Mósisu sụ t'ẹphe mee. ");
INSERT INTO iqw_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Yo be lẹ mbọku k'ẹsato; Mósisu ekua Érọnu yẹle ụnwu iya; mẹ ndu bụ ọgurenya Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Yọ sụ Érọnu: “T'ọ kpụta nwa oke-eswi gude gwoo ngwẹja-iphe, dụ ẹji yẹle ebyila, ii-gude gwoo ngwẹja-ukfuru. Oke-eswi ono mẹ ebyila ono a-bụ ọphu ẹ-te nwedu ntụpo, nọ iya l'ẹhu; kpụru iya bya Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kfuaru ụnwu Ízurẹlu: T'ẹphe kpụta mkpi t'e gude gwoo ngwẹja-iphe, dụ ẹji; unu akpụta nweswi yẹle nwatụru. Ẹphe ẹbo a-bụgbaa ọphu nọwaru afa lanụ; mbụ ọphu ẹ-te nwedu ntụpo, nọ iya l'ẹhu; gude je t'e gwoo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Unu akpụtakwaphu oke-eswi; waa ebyila, ee-gude gwoo ngwẹja-ẹhu-agu; t'e gude gwoo ngwẹja l'ifu Ojejoje; mẹkwaphu ngwẹja-nri, a gwọkoberu manụ; kẹle ntanụ ọwaa bẹ Ojejoje e-koshikwa unu onwiya.” ");
INSERT INTO iqw_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ẹphe egwota iphe ono, Mósisu gụshiru ono bya l'ifu Ụlo-Ẹ́kwà Ndzuko. Iphe bụ ndu Ízurẹlu l'ẹphe ha awụfuta bya akụru Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mósisu asụ: “Ọwaa iphe, Ojejoje sụru t'unu mee ndọ-ọ; tẹ ya koshikwanu unu ọdu-biribiri iya.” ");
INSERT INTO iqw_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Tọ dụ iya bụ; Mósisu asụ Érọnu: “Tụgbua je l'ẹnya-ngwẹja ono je egwoo ngwẹja-iphe, dụ ẹji ngu ọbu yẹle ngwẹja-ukfuru ngu ọbu; gude kfụaru onwongu ụgwo iphe, dụ ẹji yẹle ụgwo iphe, dụ ẹji ndu Ízurẹlu. Gwoo ngwẹja ono gude kfụa ụgwo iphe, dụ ẹji ẹphe; bụ iya bụ ẹge Ojejoje kfuru sụ t'e mee ya.” ");
INSERT INTO iqw_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ya ndono; Érọnu abya ejee l'ẹnya-ngwẹja ono; je egbua nwa oke-eswi ono, oo-gude gwoo ngwẹja-iphe, dụ ẹji nk'iya ono. ");
INSERT INTO iqw_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ụnwu iya abya apataru iya mee nwa oke-eswi ono. Yo gude mkpụshi-ẹka meta mee ono tee lẹ mpo, e mobegbaaru l'ẹnya-ngwẹja ono; bya eworu mee ono ọphu wuduru nụ; wụru ye l'ukfu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yọ bya eworu ẹ̀bà anụ ono, o gude gwoo ngwẹja-iphe, dụ ẹji ono; ọwaa àkpụ̀rù-ose iya ẹphe ẹbo; mẹ anyị iya; kpọo ọku l'ẹnya-ngwẹja ono; bụ iya bụ ẹge Ojejoje tụru Mósisu ọnu t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Anụ iya; mẹ akpọ iya; b'ọ kpọru ọku l'azụ ọdu ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Érọnu akpụta anụ ono, oo-gude gwoo ngwẹja-ukfuru ono gbua. Ụnwu iya abya apataru iya mee anụ ono; yọ bya ephephee ya l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ẹphe ahaa anụ ngwẹja-ukfuru ono nanụ nanụ chịtaru iya; jeye l'ishi iya. Yọ tụko iya l'ọ ha kpọo ọku l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Yo gude mini saa iphe-ẹpho iya asasa; mẹ ẹka iya; mẹ ọkpa iya; bya akpọkwaa ya phụ ọku l'eli ngwẹja-ukfuru ono, nọhawa l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Érọnu egwofuta iphe ngwẹja ndu Ízurẹlu; kpụta eghu ono, oo-gude gwoo ngwẹja-iphe, dụ ẹji nk'ẹphe ono gbua; gude iya gwoo ngwẹja-iphe, dụ ẹji; ẹge ono, o gworu kẹ mbụ phụ. ");
INSERT INTO iqw_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yọ bya akpụta anụ ono, oo-gude gwoo ngwẹja-ukfuru ono; gude iya gwoo ngwẹja ọbu ẹge a tụru ọnu t'e meje iya. ");
INSERT INTO iqw_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Yo wotakwaphu ngwẹja-nri ono; bya ahata iya ọphu jiru mkpoji-ẹka; kpọo ya ọku l'ẹnya-ngwẹja; a gụfukwaru ngwẹja-ukfuru, eegwoje l'ụtsu. ");
INSERT INTO iqw_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Yọ bya egbua oke-eswi phụ yẹle ebyila phụ; gude gwooru ndu Ízurẹlu ngwẹja-ẹhu-agu. Ụnwu iya apataru iya mee anụ ono; yọ nata iya ẹphe phephee l'ẹnya-ngwẹja ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ẹphe ewotakwaru iya phụ ẹ̀bà oke-eswi ono yẹle k'ebyila ono; mbụ ẹ̀bà, shi l'ukfumọdzu iya; mẹ ẹ̀bà, kwechiru iphe-ẹpho iya; mẹfua àkpụ̀rù-ose iya ẹphe ẹbo; mẹ anyị iya. ");
INSERT INTO iqw_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Ẹphe eworu ẹ̀bà anụ ono tukobe lẹ ǹdụ́ iya. Érọnu abya eworu ẹ̀bà ono kpọo ọku l'ẹnya-ngwẹja ono; ");
INSERT INTO iqw_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ọle ǹdụ́ iya ono; ọwaa ụtakfu ẹka-ụtara iya; b'o woru maa amama l'ifu Ojejoje t'ọ bụru ngwẹja-amama; bụ iya bụ ẹge Mósisu sụru t'e mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Tọ dụ iya bụ; Érọnu achilia ẹka imeli l'ụzo ẹke ndu Ízurẹlu nọ; bya agọoru ẹphe ọnu; bya eshi l'ẹke o shi ogwo ngwẹja-iphe, dụ ẹji phụ yẹle ngwẹja-ukfuru phụ; mẹ ngwẹja-ẹhu-agu phụ; nyizita. ");
INSERT INTO iqw_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mósisu yẹle Érọnu atụko bahụ l'ime Ụlo-Ẹ́kwà Ndzuko ono. Ẹphe alụfutalephu; bya agọoru ndu Ízurẹlu ọnu; Ojejoje ekoshi ndu ono l'ẹphe ha ọdu-biribiri iya. ");
INSERT INTO iqw_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ọku eshi Ojejoje l'ẹka daa bya ekee ngwẹja-ukfuru ono yẹle ẹ̀bà ono, nọ l'eli ẹnya-ngwẹja ono. Ndu Ízurẹlu aphụa iphe, meru nụ; gude ẹhu-ọtso-ẹna tụa ụzu; dakọta kpurumu; kpubekota ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ụnwu Érọnu, bụ Nadabu; mẹ Abihu ewotatsua mbeji, aagụje ọku ẹphe l'ẹhu l'ẹhu; bya amụru ọku ye iya; ye iya ínsẹnsu. Obenu l'ọku ono, ẹphe gude bya l'ifu Ojejoje ono bụ ọku, ẹ-ta dudu nsọ; bụ iphe Ojejoje sụru tẹ ẹphe bẹ emejeshi. ");
INSERT INTO iqw_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Ya ndono; ọku eshi Ojejoje l'ẹka bya eworu ẹphe tsua; ẹphe anọdu Ojejoje l'ifu l'ẹke ono nwụshihu. ");
INSERT INTO iqw_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mósisu asụ Érọnu: “Ọ kwa iphe-a bẹ Ojejoje shi ekfu teke ono, ọ sụru: ‘Lẹ ndu abya iya ntse bẹ ya e-me t'ẹphe maru lẹ ya dụ nsọ. Ya e-me tẹ ndu Ízurẹlu l'ẹphe ha phụ ọdu-biribiri iya.’ ” Érọnu anọdulephu nwa nggujingguji. ");
INSERT INTO iqw_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mósisu ekua Mishẹlu; mẹ Ẹluzafanu, bụ ụnwu Uzẹlu; sụ ẹphe: “Unu pata odzu unwunne unu l'ụlo-ẹ́kwà Nchileke; pafụ l'ọdu ndu Ízurẹlu.” Uzẹlu ono bụ nwunne nna Érọnu. ");
INSERT INTO iqw_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ya ndono; ẹphe abya egude ẹka l'uwe-nlọkpuru ndu ono; pata ẹphe pafụshia l'ọdu ndu Ízurẹlu; bụ iya bụ ẹge Mósisu kfuru t'ẹphe mee ya. ");
INSERT INTO iqw_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mósisu asụ Érọnu yẹle ụnwu iya; mbụ Eliyéza yẹle Itama: “Unu ba ahakwa ẹgbushi unu t'ọ yagashịhu ayagashịhu; ọphu unu alakakwa uwe unu alaka. Ọ dụdu bẹ unu a-nwụshihukwa; Ojejoje atụ-koshi ndu Ízurẹlu l'ẹphe ha oke ẹhu-eghughu iya. Ọ kwa ụnwunna unu; mbụ ndu Ízurẹlu l'ẹphe ha a-ra ẹkwa ndu ono, Ojejoje gude ọku kegbushia ono. ");
INSERT INTO iqw_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Unu ba alụfukwa alụfu l'ifu Ụlo-Ẹ́kwà Ndzuko; a -nọnyakwaa; unu anwụshihu; kẹle Ojejoje wụru unu manụ l'ishi.” Yọ bụleruphu ẹge ono, Mósisu kfuru ono; bẹ ẹphe meru. ");
INSERT INTO iqw_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Tọ dụ iya bụ; Ojejoje abya ekfuru nụ Érọnu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Nggụbedua l'onwongu; mẹ ụnwu ngu; unu ba angụjekwa mẹe; ọphu unu 'angụjekwa iphe, eme l'ẹnya; teke unu abahụ lẹ Ụlo-Ẹ́kwà Ndzuko. Ọdumeka bẹ unu a-nwụshihukwa. Ọ bụ ẹge ono bẹ ọo-dụ jeyewaru l'ọgbo ọphu etso unu. ");
INSERT INTO iqw_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ọo ya bụ; t'unu dokahuje iphe, dụ nsọ; yẹle iphe, ẹ-ta adụdu nsọ. Unu edokahukwaphu iphe, aasọ nsọ yẹle iphe, ẹ ta asọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Unu ezije ụnwu Ízurẹlu iphe, bụ ekemu ono l'ọ ha, bụ ọphu Ojejoje shi l'ẹka Mósisu tụaru ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mósisu abya ekfuru yeru Érọnu; mẹ ụnwu iya ndu ọphu phọduru nụ, bụ iya bụ Eliyéza yẹle Itama; sụ ẹphe: “Unu wota ngwẹja-nri ọphu phọduru nụ lẹ ngwẹja-ọku ono, a kpọru ọku nụ Ojejoje ono. Unu ria ya lẹ mgboro ẹnya-ngwẹja ono. Ọle t'unu be eyekwa iya iphe, ekoje buredi. Ishi iya abụru l'ọ bụ ngwẹja, dụ nsọ nshinu. ");
INSERT INTO iqw_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Unu nọdukwa l'ẹke dụ nsọ ria ya; kẹ l'ọo iphe, ruberu ngu nụ; bya abụru iphe, ruberu ụnwu ngu; mbụ ngwẹja-ọku, aanụ Ojejoje; kẹ l'ọo ẹge a tụru iya l'ekemu iya ndono. ");
INSERT INTO iqw_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Obenu l'ọ bụ nggụbedua; nggu l'ụnwu ngu: ndu k'unwoke; mẹ ndu k'ụnwanyi; a-tajẹ ǹdụ́ anụ ono, e gude gwoo ngwẹja-amama ono yẹle ụtakfu iya ono, a nụru ono. Unu nọdujekwa l'ẹke dụ nsọ taa ya; kẹ l'ọo iphe, ruberu ngu nụ; bya abụru iphe, ruberu ụnwu ngu l'iphe, ụnwu Ízurẹlu gude bya ogwo ngwẹja-ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ụtakfu iya ono, a nụru ono; waa ǹdụ́ iya ono, a màru àmàmà ono bẹ ẹphe e-yekobeje ẹ̀bà anụ ngwẹja-ọku ono wota; t'a maa amama l'ifu Ojejoje t'ọ bụru ngwẹja-amama. Ono abụru nke ngu yẹle k'ụnwu ngu; bụru iphe, ruberu unu gbururu jeye lẹ gbururu, bụ iya bụ ẹge Ojejoje tụru ekemu sụ t'e meje iya.” ");
INSERT INTO iqw_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mósisu akpaa ishi ẹge e meru eghu phụ, e gude gwoo ngwẹja-iphe, dụ ẹji phụ; bya amaru l'a kpọru iya ọku; ẹhu eghulahaa ya eghughu l'iphe, ụnwu Érọnu ndu ọphu nọkwadu ndzụ meru; bụ iya bụ Eliyéza yẹle Itama. Yọ jị ẹphe: ");
INSERT INTO iqw_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“?Bụ ngụnu kparu iphe, unu ta nọdudu l'ime ụlo-ẹ́kwà Nchileke taa anụ ono, gude gwoo ngwẹja-iphe, dụ ẹji ono; keshinu ọ bụ iphe, dụ nsọ nshinu; bya abụru iphe, a nụru unu t'unu gude safu iphe, dụ ẹji, ndu ọha meru; shi iya kfụa ụgwo iphe, dụ ẹji ẹphe l'ifu Ojejoje? ");
INSERT INTO iqw_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Keshinu ẹ te gudedu mee anụ ono bahụ lẹ Ẹke-dụ-Nsọ bẹ unu ga anọdu l'ụlo-ẹ́kwà Nchileke taa ya, bụ iya bụ ẹge ya tụru l'ekemu.” ");
INSERT INTO iqw_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Érọnu asụ Mósisu: “Ọ kwa ntanụ-a bẹ ẹphe nọdu Ojejoje l'ifu gwoo ngwẹja-iphe, dụ ẹji ẹphe yẹle ngwẹja-ukfuru ẹphe; yọ bya adakfuta iya ẹge-a! Ndẹge ya taru anụ ngwẹja-iphe, dụ ẹji ono ntanụ; Ojejoje; ?ọ ga anata iya-a?” ");
INSERT INTO iqw_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mósisu anụtsulephu iphe ono, o kfuru ono; yo ji iya ẹpho. ");
INSERT INTO iqw_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Unu kfuru ndu Ízurẹlu; sụ ẹphe: Ọwaa bụ egbe anụ, unu a-tajẹ l'iphe, bụ anụ, nọkota lẹ mgboko: ");
INSERT INTO iqw_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Unu tajẹ iphe, bụ anụ, nweru ụjaragvu-ọkpa; mbụ anụ, l'anwafụtaje nri taphu azụ l'iphe, bụ ụnwu anụ. ");
INSERT INTO iqw_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","O nwekwaru ndu ọphu anwafụtaje nri taphu azụ; ọphu ẹphe 'enwedu ụjaragvu-ọkpa; nwekwanuru ndu ọphu nweru ụjaragvu-ọkpa; ọphu ẹphe 'anwafụtajedu nri taphu azụ. Unu ba atajẹkwa ndu onanu. Ịnya-kamẹlu bẹ anwafụtaje nri taphu azụ; obenu l'o to nwedu ụjaragvu-ọkpa. Ọo ya bụ l'ọ bụ anụ, aasọ nsọ l'ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Unu ba atajẹkwa nchi-ọ̀gbà; kẹ l'ọonwafutaje nri taphu azụ; obenu l'ẹ to nwedu ụjaragvu-ọkpa. Ọ bụ anụ, aasọ nsọ l'ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Nggamanchị bụkwaphu anụ, aasọ nsọ l'ẹke unu nọ; kẹ l'ọonwafutaje nri taphu azụ; obenu l'ẹ to nwedu ụjaragvu-ọkpa. ");
INSERT INTO iqw_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ezi bụkwaphu anụ, aasọ nsọ l'ẹke unu nọ; kẹ l'o nweru ụjaragvu-ọkpa; obenu l'ẹ tọo nwafụtajedu nri taphu azụ. ");
INSERT INTO iqw_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Anụ ono l'ọ ha bụkota anụ, aasọ nsọ l'ẹke unu nọ; unu ba atajẹkwa anụ iya; ọphu unu 'edenyijekwa odzu iya ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ndu ọwaa bụ anụ ndu ọphu unu a-tajẹ ndọ-ọ l'anụ ndu ọphu, bu lẹ mini; anụ nweru m̀kpọ́ yẹle ọphu nweru ẹkiri; buru l'eze ẹnyimu; mẹ nggele. Unu tajẹ ndu onanu. ");
INSERT INTO iqw_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Obenu lẹ ndu ọphu l'ẹphe ha; mbụ ndu ọphu bu l'eze ẹnyimu; mẹ nggele; to nwe m̀kpọ́; to nwe ẹkiri; mẹkpo iphemiphe ọbule, bụ iphe eje lẹ mini; mẹ iphe, bụ iphe, nọ ndzụ; buru lẹ mini l'ọ ha bụkotakwa akpamara l'ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Keshinu ọ bụ unu akpamara; unu ba atajẹkwa anụ iya. T'odzu iya bụkwaruphu unu akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Mbụ l'iphe bụ iphe, bu lẹ mini, ẹ-te nwedu m̀kpọ́; to nwe ẹkiri a-bụkotakwaru unu akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Ọwaa ụnwenu ndu ọphu a-bụru unu akpamara: unu ba atajẹkwa ndu onanu; kẹ l'ọ bụ akpamara. Ndu onanu bụ ugo; udele; udele-ojingu; ");
INSERT INTO iqw_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mẹ egbe; ọwaa ivu l'ụdu iya l'ụdu iya; ");
INSERT INTO iqw_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","mẹkpo ọphegu l'ụdu iya l'ụdu iya; ");
INSERT INTO iqw_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","18","mẹ mgbashị-ujiku l'ụdu iya l'ụdu iya; mẹ ẹnu gọlu; mẹ egbe-nwọku l'ụdu iya l'ụdu iya; mẹ ọgu-ịkporo; mẹ ugo-mini; ");
INSERT INTO iqw_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","eze ọku-eswi-ụda; mẹ apyara-nhọko l'ụdu iya l'ụdu iya; ovu; ọwaa ụtsu-nwankụta. ");
INSERT INTO iqw_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Iphe, bụ ogu, furu ẹ́bà; gude ọkpa ẹno eje ije a-bụkotaru unu akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ọle o nwekwaru-a ogu, furu ẹ́bà, gude ọkpa ẹno l'eje ije, unu a-tajẹ. Ọphu unu a-tajẹ bụ ọphu nweru ọgbatingu, oogudeje akfụ nkfụ. ");
INSERT INTO iqw_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ọphu unu a-tajẹ bụ igube l'ụdu iya l'ụdu iya; mẹ ịnyarinya l'ụdu iya l'ụdu iya; mẹ atsụ-ẹgu l'ụdu iya l'ụdu iya; waa mkpakparamatsụ l'ụdu iya l'ụdu iya. ");
INSERT INTO iqw_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Iphe bụ ogu ọdo, furu ẹ́bà; gude ọkpa ẹno eje a-bụkotaru unu akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ụnwu iphe ono l'ọ ha e-me unu; unu abụru ndu aasọ nsọ. Onye denyiru odzu iya ẹka bẹ aa-nọdu asọ nsọ jeye l'urẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Iphe bụ onye pataru odzu iya a-sa uwe iya asasa. Onye ono a-bụru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Iphe bụ anụ, nweru ụpyi-ọkpa; to nwe ụjaragvu-ọkpa; ọwaa ọphu ta anwafụtajedu nri taphu azụ; t'ọ bụkwaru unu anụ, aasọ nsọ. Iphe bụ onye denyiru odzu iya ẹka a-bụkwaruphu onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Iphe bụ anụ, nweru ọkpa ẹno, bụ ndu ọphu akọbeje nvọ eje ije a-bụkwaru unu anụ, aasọ nsọ. Onye denyiru odzu iya ẹka a-bụkwaru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Onye pataru odzu iya a-sa uwe iya asasa; yọ bụru onye aasọ nsọ jeye nchi ejihu. Ụnwu anụmanu ono a-bụkotaru unu anụ, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“A -bya l'anụ, awụ l'ẹpho; ndu ọwaa bụ ndu ọphu unu a-nọdu asọ nsọ: ọphegu; okerekfu; ngwere l'ụdu iya l'ụdu iya; ");
INSERT INTO iqw_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","agụ-ụlo; awala; aghụ; orinvụru waa ogube. ");
INSERT INTO iqw_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ndu onanu bụkota anụ, unu a-nọduje asọ nsọ l'anụ, awụ l'ẹpho. Onye nweru ọphu o denyiru ẹka teke ọ nwụhuru anwụhu l'a-bụru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Iphe bụ iphe ọphu nwụhuru anwụhu dapyabẹru bụakwa iphe, aasọ nsọ; m'ọ bụ iphe, e gude oshi pyịa; m'ọ bụ uwe; m'ọ bụ akpọ anụ; m'ọ bụ ẹda ukpo; mbụkpo iphe, bụ ngwo, e gude eme iphe; t'e dekwaa ya lẹ mini; yọ bụru iphe, aasọ nsọ jeye nchi ejihu; a tụrua ya. ");
INSERT INTO iqw_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Teke o nweru l'ẹphe ha ọphu daru l'ite-ụra; iphe bụ iphe, nọ l'ite ono bụkotaakwa iphe, aasọ nsọ; unu tụkpokwaa ite ọbu atụkpo. ");
INSERT INTO iqw_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nri, mini shi l'ite ono denyiru bụakwa nri, aasọ nsọ. Iphe, bụ iphe, aangụ angụngu shi l'ite ono bụakwa iphe-angụngu, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Iphe, odzu anụ ono, a gụshiru ono daru bụakwa iphe, aasọ nsọ. Ọ -bụru l'ọ daru l'ite-ọku; m'ọ bụ l'ekfu, eeshi ite t'a fọtakwa iya je atụkposhia. Ọ bụakwa iphe, aasọ nsọ. Unubẹdua a-nọdukwanu asọ iya nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ẹnya ẹke mini eshije awụshi; m'ọ bụ nwogvu, mini ha nshinu ta bụkwa ẹke, aasọ nsọ. Ọle onye denyiru odzu, daburu iya nụ ẹka bẹ bụakwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","O -nweru akpụru iphe, aakụ akụku, odzu anụ ono daru bẹ nebyi iphe ono ta bụkwa iphe aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Obenu; ọ -bụru l'e yewaru mini lẹ nebyi iphe ọbu; odzu anụ ono adalahu iya b'ọ bụakwa unu iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Ọ -bụru l'ọo anụ ọphu a haru t'unu tajẹ anụ iya bẹ nwụhuru nụ bẹ onye denyiru iya ẹka a-bụkwaru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Onye takwanụru odzu iya l'a-sa uwe iya asasa; bụru onye aasọ nsọ jeye nchi ejihu. Onye patakwanụru odzu iya apata l'a-sakwaphụ uwe iya; bụru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Iphe, bụ iphe, awụ l'ẹpho a-bụkotakwaru unu akpamara; t'ẹ b'ọ dụkwa onye e-ri iya eriri. ");
INSERT INTO iqw_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Unu ba atajẹkwa iphe, bụ iphe, awụ awụwu l'alị: ọphu gude ẹpho awụ; m'ọ bụ ọphu gude ọkpa ẹno l'eje; m'ọ kwanụ ọphu gude igweligwe ọkpa eje; kẹ l'ọ tụkoru bụru akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","T'ẹ b'ọ dụkwa iphe, awụ l'ẹpho, unu e-gude merua onwunu. Ọphu unu 'egudekwa ẹphe mee onwunu ndu aasọ nsọ; t'unu be shi iya bụru ndu e meruru emeru; ");
INSERT INTO iqw_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. Ọo ya bụ; unu dobe onwunu iche; unu adụ nsọ; kẹle yẹbedua dụ nsọ. Unu be egudekwa iphe, awụ l'ẹpho; mbụ ọphu akpụ wuruwuru l'alị merua onwunu; ");
INSERT INTO iqw_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","kẹ l'ọ kwa yẹbedua bụ Ojejoje, shi lẹ Íjiputu dufuta unu tẹ ya bụru Nchileke unu. Ọo ya bụ: ‘Unu dụkwa nsọ; kẹ lẹ yẹbedua dụkwa nsọ.’ ");
INSERT INTO iqw_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ono bụ ekemu, a tụru swibe anụ; waa ẹnu; mẹ iphe, bụ iphe, nọ ndzụ, bu lẹ mini; mẹkpo iphe ọdo, bụ iphe, awụ l'ẹpho; mbụ ọphu akpụ wuruwuru l'eliphe; ");
INSERT INTO iqw_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","t'e gude dokahu iphe, aasọ nsọ yẹle iphe, ẹ taa sọdu nsọ; dokahu anụmanu, bụ ọphu ee-rije eriri; mẹ ọphu ẹ tee rijedu eriri.” ");
INSERT INTO iqw_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Kfuru yeru ụnwu Ízurẹlu ẹge-a: Lẹ nwanyi -tsụta ime bya amụa nwata nwoke; t'ọ nọkwaa abalị ẹsaa bụru onye aasọ nsọ; ẹge ono, ọonoje teke nsọ eme iya ono; kẹle ntụru nọ iya l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","O -rua lẹ mbọku k'ẹsato; e bua nwata ọbu útsù. ");
INSERT INTO iqw_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Teke ono; nwanyi ono abya anọo ụkporo abalị l'abalị iri l'ẹto t'e gude swafụ iya ntụru kẹ mee, laru iya nụ. T'ẹ b'ọ dụkwa iphe, e doberu nsọ, oo-denyi ẹka; ọphu t'ẹ b'ọ bahụkwa lẹ Ụlo-dụ-nsọ jeye mbọku, nsọ k'ọsafu ntụru iya a-gvụ. ");
INSERT INTO iqw_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Ọ -bụru l'ọo nwata nwanyi b'ọ mụru bẹ ọo-nọ ujiku iri l'ẹno bụru onye aasọ nsọ; bụ iya bụ ẹge aanọduje asọ iya nsọ teke nsọ eme iya. Iphe, ọo-nọ t'e gude safu iya mee, larụ iya nụ bụ ụkporo abalị ẹto l'abalị ishingu. ");
INSERT INTO iqw_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Eswe mbọku ọsafu ntụru iya ono gvụlephu; m'ọ bụ nwata nwoke b'ọ mụru; m'ọ bụ nwata nwanyi; tẹ nwanyi ono kpụta nwatụru, nọru afa lanụ t'e gude gwoo ngwẹja-ukfuru. Yọ nwẹkwaaphu nwa ndo; m'ọ bụ kparakobe; t'e gude gwoo ngwẹja-iphe, dụ ẹji. T'o gude iya bya l'ifu Ụlo-Ẹ́kwà Ndzuko bya anụ onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Onye ono, achịjeru Nchileke ẹja ono egude iphe ono gwoo ngwẹja nụ Ojejoje gude kfụa ụgwo iphe, dụ ẹji, nwanyi ono meru. Teke ono; yọ bya abụru onye a safụru ntụru lẹ mee, laru iya nụ. Ono bụ ekemu, nọru nwanyi, mụru nwata nwoke; m'ọ bụ nwata nwanyi. ");
INSERT INTO iqw_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Teke bụ l'onye ọbu ta adụdu ike ọgbata nwatụru; t'ọ nwụtaru iya kparakobe ẹbo; m'ọ bụ ndo labụ. T'a nwụta nanụ gude gwoo ngwẹja-ukfuru; gude ọphu gwoo ngwẹja-iphe, dụ ẹji. Onye achịjeru Nchileke ẹja egude iya kfụa ụgwo iphe, dụ ẹji iya; yọ bụru onye, a safụru ntụru.” ");
INSERT INTO iqw_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ọ -bụru l'o nweru ọnya, nọ madzụ l'ẹhu; m'ọ bụ iphe, dụ l'ọ bụ ẹkpa; m'ọ bụ iphe tụkashiru iya poopoo l'ẹhu, bụ iphe nweru ẹge ọo-dụ; yọ ghọo ẹhu-labụ; nọdu onye ono l'akpọ-ẹhu; t'e dutakwa onye ọbu jekfu Érọnu, bụ onye achịjeru Nchileke ẹja; m'ọ bụ onye lanụ l'ụnwu iya, bụ onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","T'onye ono, achịjeru Nchileke ẹja ono lee ẹnya l'ẹke iphe ọbu, nọ onye ono l'akpọ-ẹhu ọbu. Ọ -bụru l'ẹji, futaru l'ẹke ono ghọru aghọhu l'acha ụcha; tẹmanu ọ -bụru l'ẹke ono miru iya emimi; b'ọ bụkwa ẹhu-labụ; nọdu onye ono l'akpọ-ẹhu. T'onye ono, achịjeru Nchileke ẹja ono lee ya ẹnya; gụa onye ono onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Teke ọ bụ l'akpọ-ẹhu acha iya ụcha l'ẹke ọbu; e lee ya ẹnya t'o mi iya emimi; ọphu ẹji, nọ iya nụ 'aghọdu aghọhu l'acha ụcha; t'onye achịjeru Nchileke ẹja gụ-chia onye ono ụlo abalị ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","O -be lẹ mbọku k'ẹsaa; t'onye achịjeru Nchileke ẹja je elefua onye ono ẹnya l'ẹhu. Teke ẹhu-labụ ono dụkwadua ẹge ọ dụ; t'ọ bakahụ iya abakahu l'akpọ-ẹhu; tẹ onye ono, achịjeru Nchileke ẹja ono gụ-chifua ya ụlo ujiku ẹsaa ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","O -be lẹ mbọku k'ẹsaa; t'onye ono, achịjeru Nchileke ẹja ono jekwaphu je elefua onye ono ẹnya l'ẹhu. Ọ -bụru l'ẹke ono, iphe ono nọ iya ono ekpekputawa iya ekpekputa; tọ bakahụ iya abakahu; t'onye achịjeru ono, Nchileke ẹja ono gụa ya onye ẹ taa sọdu nsọ. Iphe, ọ bụ bụ iphe-ememe mmanu. T'onye ono saa uwe iya asasa; bụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ọ -bụkwanuru l'iphe ono byaru bya abakahu abakahu; l'onye achịjeru Nchileke ẹja phụtsuaru iya sụ l'ẹ taa sọdu iya nsọ phụ; t'o lakwa azụ je ekoshifua onwiya onye ono, achịjeru Nchileke ẹja ono ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Teke onye ono, achịjeru Nchileke ẹja ono leru iya ẹnya bya aphụa l'iphe ọbu aba iya ababa; t'onye ono, achịjeru Nchileke ẹja ono gụkwaa ya l'onye aasọ nsọ; ọ kwa ẹhu-labụ eme onye ono. ");
INSERT INTO iqw_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ọ -bụru lẹ madzụ bẹ iphe eme iya l'akpọ-ẹhu, bụ iphe, eswe nswe; t'e dukwaru onye ọbu jekfu onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","T'onye ono, achịjeru Nchileke ẹja ono lee ya ẹnya. Ọ -bụru l'o nweru ọnya, nọ onye ono l'ẹhu, kweru ịgbagba-ọcha; bya emewaa; ẹji, nọ iya nụ; yọ ghọshiwa aghọshi l'acha ụcha; ájị̀ anọdu iya; ");
INSERT INTO iqw_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","b'ọ kwa 'alagala ẹhu-labụ, eswe nswe nọ onye ono l'akpọ-ẹhu. T'onye ono, achịjeru Nchileke ẹja ono gụkwaa ya l'onye aasọ nsọ. T'ẹ b'o jekwa iya ọtu-chi ụlo; kẹ l'ọ bụakwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ọ -bụru l'ẹhu-labụ ono vọshiru madzụ l'akpọ-ẹhu; tụko iya ẹhu dzuru; mbụ shi iya l'ishi dzuru iya ẹhu lụfu l'ọkpa; iphe bụ ẹke onye ono, achịjeru Nchileke ẹja ono leru iya ẹnya abụkotaru iya; ");
INSERT INTO iqw_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","t'onye ono, achịjeru Nchileke ẹja ono lerekwaa ya ẹnya elere. Ọ -bụru l'iphe-ememe ono mewaru iya; kpọhu; ẹke ono achawa iya ụcha; t'ọ gụkwaa onye ono onye ẹ taa sọdu nsọ; kẹ l'ọ bụwa ichii-iphe nọ iya l'ẹhu; ẹ tọ bụhedu ẹhu-labụ. ");
INSERT INTO iqw_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ọ -bụkwanuru l'o nweru teke a nọnyaaru; ájị̀ alụfuta iya l'ẹhu; b'ọ bụakwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Onye ono, achịjeru Nchileke ẹja ono -phụlephu ájị̀ ono; t'ọ gụa onye ono onye aasọ nsọ; kẹ l'ájị̀ bụ iphe, aasọ nsọ. Ọ kwa ẹhu-labụ eme onye ono. ");
INSERT INTO iqw_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ọ -bụru l'ájị̀ ono nọnyaaru gbanwee; chalahaa ụcha; tẹ onye ọbu jekfukwa onye ono, achịjeru Nchileke ẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","T'onye ono, achịjeru Nchileke ẹja ono lee ya ẹnya; ọ -bụru l'ẹjo-ẹhu ọbu kpọhuwaru; chalahaa ụcha; tẹ onye ono, achịjeru Nchileke ẹja ono kfukwaa l'onye ono b'ẹ taa sọhedu nsọ. Teke ono; onye ono abụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“A bya l'onye bụ iphe-etsetse shi tsee ya; yọ kawaa mma; ");
INSERT INTO iqw_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a bya l'ẹke ono, iphe-etsetse shi tsee ya ono; yọ -bụru l'ọ byaru bya afulia wata ọcha ụcha; m'ọ bụ l'o nweru ẹke acha kpalakpala; l'ekekwaphu nwuswuswe; t'o jekwa je ekoshi iya onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","T'onye ono, achịjeru Nchileke ẹja ono lekwaa ya ẹnya. Ọ -bụru l'ẹke ono miru iya emimi; ẹji, nọ iya nụ aghọo aghọgho l'acha ụcha; t'onye ono, achịjeru Nchileke ẹja ono gụa onye ono onye aasọ nsọ; kẹ l'ọ kwa ẹhu-labụ lụfutaru onye ono l'ẹke ono, iphe-etsetse shi tseta iya ono. ");
INSERT INTO iqw_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ọle; ọ -bụru l'onye ono, achịjeru Nchileke ẹja ono leru ẹnya l'ẹke ọbu; ẹji, furu l'ẹke ono ta ghọ aghọgho; to mi iya emimi; yo kpekputa ekpekputa; tẹ onye achịjeru ono, Nchileke ẹja ono gụ-chia onye ono ụlo ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ọ -bụru l'ẹke iphe ọphu nọ iya byaru bya abakahu iya abakahụ; tẹ onye ono, achịjeru Nchileke ẹja ono kfukwaa l'ọ bụ onye aasọ nsọ; kẹ l'ọ bụ ẹhu-labụ eme iya. ");
INSERT INTO iqw_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ọ -bụru l'ẹke iphe ọphu nọ iya dụlephu ẹge ọ dụ; tọ bakahu abakahu; a maru l'ọo ichii iphe-etsetse phụ b'ọ bụ. Tẹ onye ono, achịjeru Nchileke ẹja ono gụa ya onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Teke bụ l'ọku hụru madzụ l'ẹhu; ẹke ono, ọku hụru iya ono achalahaa ya kpalakpala; l'ekekwa iya phu nwuswuswe; m'ọ kwanụ chalahaa ya ụcha; ");
INSERT INTO iqw_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","t'onye achịjeru Nchileke ẹja lekwaa ya ẹnya. Ọ -bụru l'ẹji, nọ l'ẹke ono ghọru aghọgho chalahaa ụcha; bya emia emimi b'ọ bụkwa ẹhu-labụ laru onye ono l'ẹke ono, ọku hụru iya ono. T'onye ono, achịjeru Nchileke ẹja ono gụkwaa ya onye aasọ nsọ; kẹ l'ọ kwa ẹhu-labụ eme onye ono. ");
INSERT INTO iqw_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Obekwanu l'ọ -bụru l'onye ono, achịjeru Nchileke ẹja ono leru iya ẹnya; ẹji, nọ l'ẹke ono ta ghọ aghọgho l'acha ụcha; to mi iya emimi; yo gbe kpekputawa ekpekputa; tẹ onye ono, achịjeru Nchileke ẹja ono gụ-chia ya l'ụlo ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","O -be lẹ mbọku k'ẹsaa tẹ onye ono, achịjeru Nchileke ẹja ono lebaa ya ẹnya l'ẹhu. Ọ -bụru l'ọoba iya ababa l'ẹhu; tẹ onye ono, achịjeru Nchileke ẹja ono gụkwaa ya onye aasọ nsọ. Ọ kwa ẹhu-labụ eme iya. ");
INSERT INTO iqw_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ọle; ọ -bụkwanuru l'ẹke ono, iphe nọ iya ono dụlephu ẹge ọ dụ; ọphu ọ bakahụdu abakahu; yo gbechianu ekpekputawa ekpekputa; b'ọ bụkwa ọku ono, hụru iya nụ ono switaru iya eswita. T'onye ono, achịjeru Nchileke ẹja ono gụkwaa ya onye ẹ taa sọdu nsọ; kẹ l'ọo ichii ọku phụ b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ọ -bụru lẹ nwoke; m'ọ bụ nwanyi bẹ ọnya nọ l'ishi; m'ọ bụ l'agba; ");
INSERT INTO iqw_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","t'onye achịjeru Nchileke ẹja lekwaa ẹnya l'ọnya ọbu. Ọ -bụru l'o miru emimi; ẹji, nọ onye ono l'ẹke ono adụ manụ-manụ; bya adụtsua nwụlanwula; t'onye ono, achịjeru Nchileke ẹja ono gụkwaa ya onye aasọ nsọ; kẹ l'ọo ẹjo ẹkuluba; mbụ l'ọo ẹhu-labụ tụru onye ono l'ishi; m'ọ bụ l'agba. ");
INSERT INTO iqw_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Teke bụkwanu l'onye ono, achịjeru Nchileke ẹja ono letsuaru ẹnya l'ẹjo ẹkuluba ono; tọ dụ iya l'o miru emimi; ẹji, nọ iya nụ te eji uji; t'onye ono, achịjeru Nchileke ẹja ono gụ-chikwaa onye ono l'ụlo ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","O -be lẹ mbọku k'ẹsaa t'onye ono, achịjeru Nchileke ẹja ono lebaa ya ẹnya. Ọ -bụru l'ẹjo ẹkuluba ono ta bakahụdu abakahu; ẹji, nọ iya nụ te ke manụ-manụ; tọ dụ iya l'o miru emimi; ");
INSERT INTO iqw_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","t'a kpụshia onye ono ishi; kpụ-buru ẹke ẹkuluba ono nọ haa; t'onye ono, achịjeru Nchileke ẹja ono gụ-chifua ya l'ụlo t'ọ nọo ujiku ẹsaa ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Teke o ruru mbọku k'ẹsaa; t'onye ono, achịjeru Nchileke ẹja ono lee ẹnya l'ẹkuluba ono. Ọ -bụru l'ẹ tọ bakahụdu abakahu; e lee ya ẹnya; to mi iya emimi; t'onye ono, achịjeru Nchileke ẹja ono gụa ya onye ẹ taa sọdu nsọ. T'onye ono saa uwe iya; bụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ọlobu; ọ -bụru l'ẹkuluba ono bakahụru iya abakahu l'ẹhu; l'a gụtsuaru iya l'onye ẹ taa sọdu nsọ-a; ");
INSERT INTO iqw_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","t'onye ono, achịjeru Nchileke ẹja ono lebaa ya ẹnya ọdo. Ọ -bụru l'ẹkuluba ono bakahụru iya abakahu l'ẹhu l'oswiya; tẹ onye ono, achịjeru Nchileke ẹja ono be jehekwa ole ẹnya t'a maru m'ẹji iya; ?ooke manụ-manụ. Onye ono bụakwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ọle; ọ -bụkwanuru l'ẹkuluba ọbu bẹ dụlephu ẹge ọ dụ l'ẹnya; ẹji ojingu erutawaa l'ẹke ono bẹ ẹkuluba ọbu kpọhuakwaru; ọ bụakwa onye ẹ taa sọdu nsọ. T'onye ono, achịjeru Nchileke ẹja ono gụa ya onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ọ -bụru lẹ nwoke; m'ọ bụ nwanyi bẹ iphe-ọcha tụkashiru poopoo l'ẹhu; l'achagbaa ụcha; ");
INSERT INTO iqw_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","tẹ onye achịjeru Nchileke ẹja lekwaa onye ọbu ẹnya l'ẹhu. Ọ -bụru l'ẹke ọbu ta chadu ọkpobe ụcha; a maru l'ọo ngwọ bẹ tụkashiru onye ọbu l'ẹhu; l'onye ọbu b'ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Ẹgbushi -rishihu onye nwoke l'ishi; bụkwa ishi-ọnma b'ọ bụ. Ẹ tọ bụkwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ọ -bụru l'ọo l'ọnu-ifu bẹ ẹgbushi rishihuru iya; bẹ onye ọbu bụkwa ishi-ọnma ọnu-ifu. Obenu l'ẹ taa sọdu iya nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ọle; ọ -bụru l'o nweru ọnya, acha kpalakpala; l'ekekwaphu nwuswuswe, nọ iya l'ishi-ọnma ọbu; m'ọ bụ ọnu-ifu ọbu; b'ọ bụakwa ẹhu-labụ bẹ tụru iya l'ishi-ọnma ọbu; m'ọ bụ l'ọnu-ifu. ");
INSERT INTO iqw_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","T'onye ono, achịjeru Nchileke ẹja ono lee ya ẹnya. Ọ -bụru l'ọnya ono, nọ onye ono l'ishi; m'ọ bụ l'ọnu-ifu ono acha iya kpalakpala; l'ekekwaphu nwuswuswe; mbụ dụ l'ọ bụ ẹhu-labụ ono, eswe nswe, emeje madzụ l'akpọ-ẹhu ono; ");
INSERT INTO iqw_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ọo ya bụ l'onye ọbu bụ onye ẹhu-labụ; bụru onye aasọ nsọ. T'onye ono, achịjeru Nchileke ẹja ono gụa ya l'onye aasọ nsọ; kẹle ẹhu-labụ nk'iya tụru iya l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“T'onye ono lakakwaa uwe iya; haa ẹgbushi iya t'ọ yagashịhu ayagashịhu; woru ẹkwa gbochita ụgbo-ọnu; chia mkpu sụ lẹ ya bụkwa onye aasọ nsọ; ya bụkwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ọ bụ ẹge iphe ono nọ-beru iya l'ẹhu bụ ẹge ọo-bụ-beru onye aasọ nsọ. Yo shi l'ọdu ndu Ízurẹlu lụfu; je eburu iche. ");
INSERT INTO iqw_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ọ -bụru l'o nweru uwe, tsụru evu; m'ọ bụ uwe ẹji anụ; m'ọ bụ uwe ọcha; ");
INSERT INTO iqw_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","m'ọ bụ ẹkwa, e kweru l'òwúú ọcha; m'ọ bụ ọphu e gude ẹji anụ kwee; m'ọ bụ l'akpọ; m'ọ bụ l'iphe, e meru l'akpọ; ");
INSERT INTO iqw_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","teke ọ bụ l'ẹke ono, tsụru evu ono eke ẹwu-ẹwu; m'ọ bụ l'ooke uswuswe; b'ọ bụkwa ẹjo-ẹhu, eswe nswe. T'e jekwa je ekoshi iya onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","T'onye ono, achịjeru Nchileke ẹja ono lekwaa ẹnya l'ẹke ono, tsụru evu ono; woru iphe ọbu, tsụru evu ọbu gụ-chia l'ụlo t'ọ nọo abalị ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","O -be lẹ mbọku k'ẹsaa; tẹ onye ono, achịjeru Nchileke ẹja ono je elefua ya ẹnya ọdo. Ọ -bụru l'evu ọbu haru bakahụ l'uwe ọbu; t'a makwaru l'ọ bụ ẹhu-labụ. Iphe ono, tsụru evu ono bụakwa iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","T'onye ono kpọkwaa uwe ono ọku; m'ọ bụ uwe ẹji anụ; m'ọ bụ uwe ọcha; m'ọ bụ ẹkwa, e kweru l'òwúú ọcha; m'ọ bụ ọphu e gude ẹji anụ kwee; m'ọ bụ iphe, e meru l'akpọ bụ ọphu evu ono nọ; t'a kpọkwaa ya ọku; kẹ l'ọ kwa ẹhu-labụ. ");
INSERT INTO iqw_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ọle ọ -bụru l'onye achịjeru Nchileke ẹja leru iya ẹnya; evu ono ta bakahụdu l'iphe ono; ");
INSERT INTO iqw_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","t'o zia t'a saa iphe ono, tsụru evu ono asasa. Yọ bya agụ-chia ya l'ụlo t'ọ nọo abalị ẹsaa ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","T'onye ono, achịjeru Nchileke ẹja ono lee ẹnya l'iphe ono teke a satsụaru iya. Ọ -bụru l'iphe ọbu ta gbanwedu ẹge ooke; m'o -ruhuduru ọ bụru l'ẹ tọ bakahụdu abakahu; b'ọ bụkwa iphe, aasọ nsọ. T'a kpọkwaa ya ọku; mẹ evu ọbu; ?ọ nọ iya l'ifu; m'ọ nọ iya l'azụ. ");
INSERT INTO iqw_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ọ -bụru l'onye ono, achịjeru Nchileke ẹja ono leru iya ẹnya; ẹke ono, tsụru evu ono ekpekputawa ekpekputa l'a satsụaru iya ono; t'ọ lakafụ ẹke ono, tsụru evu l'uwe ono; m'ọ bụ l'akpọ ono; m'ọ bụ l'ẹ́kwà ono, e kweru ekwekwe ono; m'ọ bụ l'ọphu a kparu akpakpa. ");
INSERT INTO iqw_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ọle; ọ -bụru l'evu ono avụa ọdo l'uwe ono; m'ọ bụ l'iphe ono, e kweru ekwekwe ono; m'ọ bụ l'ọphu a kparu akpakpa; m'ọ bụ l'iphe ono, e meru l'akpọ anụ ono; a maru l'ọ bụ iphe, abakahu abakahu. T'a kpọkwaa iphe bụ iphe ono, tsụru evu ono ọku. ");
INSERT INTO iqw_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Iphe, bụ iphe, tsụru evu, a sawaru asasa; evu ono ta nọhe iya; t'a saa ya k'ugbo ẹbo t'ọ bụru iphe, ẹ taa sọdu nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ono bụ ekemu, nọru iphe bụ evu, tsụru l'uwe ẹji anụ; m'ọ bụ l'uwe ọcha; m'ọ bụ l'ẹ́kwà, e kweru ekwekwe; m'ọ bụ l'ọphu a kparu akpakpa; m'ọ bụ l'ọphu e gude akpọ mee; k'ọphu a gụ iya l'iphe, aasọ nsọ; m'ọ bụ ọphu ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ọwaa bụ ekemu, ee-tsoje mbọku, eeme t'a sọ-buhu onye ẹhu-labụ shi eme nsọ: T'e duru onye ọbu dutaru onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","T'onye ono, achịjeru Nchileke ẹja ono shikwa l'ọdu ndu Ízurẹlu lụfu; je elee ya ẹnya ọhuma. Ọ -bụru l'onye ono kọrohuwaru l'ẹjo-ẹhu ono, eswe nswe ono; ");
INSERT INTO iqw_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","t'onye ono, achịjeru Nchileke ẹja ono zia t'e wotaru onye ọphu eeme t'a sọ-buhu nsọ ọbu ụnwenu labụ, nọ ndzụ, ẹ taa sọdu nsọ; waa oshi sida; mẹ ẹkwa uswe; mẹ ẹswa isopu. ");
INSERT INTO iqw_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","T'o onye ono, achịjeru Nchileke ẹja ono sụ t'e gbua nwẹnu ono nanụ l'eli ite, a kpụru l'ụra, e yeru mini, doru rịsangu. ");
INSERT INTO iqw_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Nwẹnu ọphu nọ ndzụ phụ bẹ ọo-nwụta; wota oshi sida phụ; wota ẹkwa uswe phụ; mẹ ẹswa isopu phụ; tụko tsẹe lẹ mee nwẹnu onanu, e gburu l'eli mini ono, e kutaru k'ọphungu ono. ");
INSERT INTO iqw_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Yọ bya ephee ya onye ono, eeme t'ẹ b'a sọhe nsọ l'ẹhu-labụ, eme iya nụ ono ugbo ẹsaa. Yọ sụ l'onye ono bụwa onye, ẹ taa sọdu nsọ; haa nwẹnu onanu, nọ ndzụ ono t'o pheba l'ẹgu. ");
INSERT INTO iqw_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Onye ono, byaru t'e mee ya t'ẹ ba sọhe iya nsọ ono eje eworu uwe iya saa; kpụshikota ẹji, nọ iya l'ẹhu l'ọ ha; mẹ ẹgbushi iya; ghụa ẹhu; shi ẹge ono bụru onye ẹ taa sọdu nsọ. E -metsua ẹge ono; t'ọ batawaru l'ọdu ndu Ízurẹlu. Ọle t'ọ nọfukwa anọfu l'ọdu ndu Ízurẹlu ono abalị ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ọ -nọ-gee abalị ẹsaa t'ọ kpụshikwaa ẹji, nọ iya l'ẹhu l'ọ ha ọdo; kpụshia ishi; kpụshia ẹji-agba; mẹ ẹjibu-ẹnya; mẹwaru ẹji ọdo, nọgbaa ya l'ẹhu. Yọ saa uwe iya; ghụa ẹhu; bya abụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Teke o ruru lẹ mbọku k'ẹsato; tẹ onye ọbu kpụta ụnwu ebyila labụ, ẹ-te nwedu ntụpo; waa ada atụru, gbaru afa, ẹ-te nwedu ntụpo. Yo gude nkere-ẹto ogbonga ntụ akpe, a gwọkoberu manụ; t'e gude iya gwoo ngwẹja-nri. Yo wotakwaphu manụ, jiru konggo ejiji tukobe iya. ");
INSERT INTO iqw_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Onye ono, achịjeru Nchileke ẹja ono eduta onye ono, eeme t'ẹ ba sọhe nsọ ono yẹle iphe ono, o gude bya ono; bya eworu dobe Ojejoje l'ifu l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Yọ bya akpụta nwa ebyila ono nanụ yẹle konggo phụ, manụ jiru ejiji phụ; gude gwoo ngwẹja-ụgwo. Yọ maa ngwẹja ono l'ifu Ojejoje t'ọ bụru ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yọ bya eworu nwa ebyila ono gbua lẹ Ẹke-dụ-Nsọ; mbụ l'ẹke ono, eegbuje anụ, e gude egwo ngwẹja-iphe, dụ ẹji; mẹ kẹ ngwẹja-ukfuru ono. Ọ bụ ẹge ono, ngwẹja-iphe, dụ ẹji bụ k'onye achịjeru Nchileke ẹja ono bụ ẹge ngwẹja-ụgwo bụkwaphu nk'iya. Ọ bụ ngwẹja, dụshi nsọ ike. ");
INSERT INTO iqw_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Onye ono, achịjeru Nchileke ẹja ono emeta mee anụ ono, e gude gwoo ngwẹja-ụgwo ono; ye onye ono, eeme t'ẹ ba asọhe nsọ ono l'atakarama-nchị ẹka-ụtara; mkpụshi-ẹka ezeke-ẹka ẹka-ụtara mẹ mkpụshi-ọkpa ezeke-ọkpa ẹka-ụtara iya. ");
INSERT INTO iqw_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Onye ono, achịjeru Nchileke ẹja ono abya emeta konggo manụ ono; meru iya ye onwiya l'ọbechere-ẹka ẹka-ibyita; ");
INSERT INTO iqw_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","woru mkpụshi-ẹka ẹka-ụtara tsẹe lẹ manụ ono; meta iya phee ugbo ẹsaa l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Manụ ọphu ghuduru iya l'ọbechere-ẹka phụ bẹ ọo-tada onye ono, eeme t'ẹ ba sọhe nsọ ono l'atakarama-nchị ẹka-ụtara; mkpụshi-ẹka ezeke-ẹka ẹka-ụtara; mkpụshi-ọkpa ezeke-ọkpa ẹka-ụtara; mẹ l'eli mee anụ ono, e gude gwoo ngwẹja-ụgwo ono. ");
INSERT INTO iqw_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Manụ ọphu ghuduru nụ bẹ oo-fu onye ono, eeme t'ẹ ba sọhe nsọ ono l'ishi; gude kfụa ụgwo iphe, dụ ẹji onye ono l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Onye ono, achịjeru Nchileke ẹja ono abya egwoo ngwẹja-iphe, dụ ẹji ono; gude kfụa ụgwo iphe, dụ ẹji, onye ono meru; mbụ onye ono, eeme t'ẹ ba sọhe nsọ ono. Teke e metsuaru; yo woru anụ ono, ee-gude gwoo ngwẹja-ukfuru ono gbua; ");
INSERT INTO iqw_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","woru ngwẹja-ukfuru ono yẹle ngwẹja-nri, tso iya nụ l'ẹnya-ngwẹja gwoo gude kfụa ụgwo iphe, dụ ẹji iya. Onye ono abya abụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ọle; ọ -bụru l'onye ọbu bụ onye ụkpa; tọ dụ ike ọnu iphe ono, a gụshiru ono; t'onye ọbu kpụta nwa ebyila lanụ nụ t'ọ bụru kẹ ngwẹja-ụgwo. E woru iya maa t'ọ bụru ngwẹja-amama, e gude akfụ ụgwo iphe, dụ ẹji. Yọ byakwaphu bya ewota nkere-iri ogbonga ntụ akpe, a gwọkoberu manụ; t'ọ bụru ngwẹja nri; waa manụ, jiru konggo; ");
INSERT INTO iqw_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","mẹ ndo labụ; m'ọ bụ kparakobe ẹbo; ọphu rukpeleru iya phụ ẹka. Nanụ bẹ ee-gude gwoo ngwẹja-iphe, dụ ẹji. E gude ọphu gwoo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","O -be lẹ mbọku k'ẹsato; yọ chịru iphe bụ iphe ono byakfuta onye ono, achịjeru Nchileke ẹja ono t'e gude mee ya t'ẹ ba sọhe iya nsọ; gude iya bya l'ifu Ụlo-Ẹ́kwà Ndzuko l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","T'onye ono, achịjeru Nchileke ẹja ono kpụta nwatụru ono yẹle konggo ono, manụ jiru ejiji ono je amaa Ojejoje l'ifu t'ọ bụru ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yo woru nwatụru ono gbua; meta mee ya tada onye ọbu, eeme t'ẹ ba sọhe nsọ ọbu l'atakarama-nchị ẹka-ụtara; waa lẹ mkpụshi-ẹka ezeke-ẹka ẹka-ụtara; wafụa lẹ mkpụshi-ẹka ezeke-ọkpa ẹka-ụtara. ");
INSERT INTO iqw_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Onye ono, achịjeru Nchileke ẹja ono abya emeta manụ ono meru ye onwiya l'ọbechere-ẹka ẹka-ibyita; ");
INSERT INTO iqw_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","gude mkpụshi-ẹka ẹka-ụtara iya phee manụ ono ugbo ẹsaa l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Onye ono, achịjeru Nchileke ẹja ono emeta manụ ono, nọ iya l'ọbechere-ẹka ono tada l'ẹke ono, ọ tadaru mee anụ ono, e gude gwoo ngwẹja-ụgwo ono; bụ iya bụ l'atakarama-nchị ẹka-ụtara onye ono, eeme t'ẹ b'a sọhe nsọ ono; mkpụshi-ẹka ezeke-ẹka ẹka-ụtara iya; mẹ mkpụshi-ọkpa ezeke-ọkpa ẹka-ụtara iya. ");
INSERT INTO iqw_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Manụ ọphu ghuduru iya l'ọbechere-ẹka bẹ oo-fu onye ono, eeme t'ẹ b'a sọhe nsọ ono l'ishi; gude kfụa ụgwo iphe, dụ ẹji iya l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Yọ nwụta ndo ono; m'ọ bụ kparakobe ono, onye ono dụru ike gbata ono; gude gwoo ngwẹja ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nanụ bẹ oo-gude gwoo ngwẹja-iphe, dụ ẹji; gude ọphu gwoo ngwẹja-ukfuru yẹle ngwẹja-nri. Ọ bụ ẹge ono bụ ẹge onye achịjeru Nchileke ẹja e-shi kfụa ụgwo onye ono, eeme t'ẹ b'a sọhe nsọ ono l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ono bụ ekemu, nọru onye oome; mbụ ẹhu-labụ; tọ dụ ike gbata iphe, ee-gude mee t'ẹ b'a sọhe iya nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Unu -lalẹphu alị Kénanu, bụ ẹke ono, ya abya unu anụnu t'ọ bụru òkè-iphe unu ono; ọ -bụru l'o nweru ụlo, nọ l'alị ono, ya meru; yọ tsụa evu; ");
INSERT INTO iqw_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","tẹ onye nwe ụlo ọbu jekwa akọoru onye achịjeru Nchileke ẹja l'ụlo iya dụkwa iya l'ọ tsụru evu. ");
INSERT INTO iqw_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Onye ono, achịjeru Nchileke ẹja ono a-sụ t'e gwoshikota iphe l'ụlo ono; tẹmanu yọ bahu je aphụ ẹke tsụru evu ọbu; k'ọphu t'ọ tụkodu ụlo ono yẹle iphe, nọ iya nụ gụa l'iphe, aasọ nsọ. E -gwoshitsua iphe l'ụlo ono; t'onye ono, achịjeru Nchileke ẹja ono bahụ l'ụlo ono je elee ya ẹnya. ");
INSERT INTO iqw_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","T'o lee ẹnya l'igbo-ụlo ẹke tsụru evu ọbu. Ọ -bụru l'ooke ẹwu-ẹwu; m'ọ kwanụ uswuswe; ẹke ọbu emia emimi; ");
INSERT INTO iqw_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","tẹ onye ono, achịjeru Nchileke ẹja ono lụfuta l'ụlo ono; woru iya gụ-chia t'ọ nọo ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","O -rua lẹ mbọku k'ẹsaa; tẹ onye ono, achịjeru Nchileke ẹja ono laphu azụ je elee ẹnya l'ụlo ọbu ọdo. Ọ -bụru l'evu ọbu bakahụru l'igbo-ụlo ono; ");
INSERT INTO iqw_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","t'ọ sụ t'e gvufu mkpuma ono, tsụru evu ono je etufaa l'ẹke aasọ nsọ l'azụ mkpụkpu. ");
INSERT INTO iqw_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","T'e kwoshia ime ụlo ono ekwoshi l'igbo-ụlo iya mgburumgburu; kpota iphe, e kwoshiru iya je awụshia l'azụ mkpụkpu l'ẹke aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","T'e wota mkpuma ọdo gude tụ-chishia ẹnya iya ọphu e gvukposhiru phụ; a kụtakwaphu ẹpoto ọdo gude techia ụlo ọbu ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ọ -bụru l'evu ọbu chafụtaru l'ụlo ono ọdo l'e gvukpofutsuaru mkpuma phụ; e kwoshitsua ya; bya etechita iya azụ ọbu; ");
INSERT INTO iqw_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","tẹ onye ono, achịjeru Nchileke ẹja ono laphu azụ jee elee ya ẹnya ọdo. Ọ -bụru l'evu ọbu bakahụru l'ụlo ọbu b'ọ bụkwa evu, abakahu abakahu nọ l'ụlo ono. Ọo ya bụ l'ụlo ọbu bụwa ụlo, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","T'e gbukaa ụlo ọbu; vuta mkpuma iya; mẹ oshi iya; waa ẹja, e gude techia ya je awụshia l'azụ mkpụkpu l'ẹke aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Onye bahụru l'ụlo ono teke ono, a gụ-chikwadụru iya agụ-chi ono; a-bụru onye aasọ nsọ jeye nchi ejihu. ");
INSERT INTO iqw_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Onye zẹru l'ụlo ono kua mgbẹnya; m'ọ kwanụ nọdu iya ria nri; tẹ onye ono sakwaa uwe iya asasa. ");
INSERT INTO iqw_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Teke bụ l'onye ono, achịjeru Nchileke ẹja ono byaru t'o lee ụlo ono ẹnya; bya aphụ l'evu ono te nwehedu ẹke ọ nọkwadu l'ụlo ono l'e techitsuaru iya ono; t'ọ gụa ụlo ono ụlo, ẹ taa sọdu nsọ; kẹ l'evu ọbu ta nọhedu iya. ");
INSERT INTO iqw_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Iphe, oo-gude mee ụlo ono t'ẹ b'a sọhe iya nsọ; bụkwa t'ọ nwụta ụnwenu labụ; wotakwaphu oshi sida; mẹ ẹkwa uswe; waa ẹswa isopu. ");
INSERT INTO iqw_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Yo woru nwẹnu lanụ gbua lẹ ite, a kpụru l'ụra, e yeru mini, dụ mma. ");
INSERT INTO iqw_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","E wota oshi sida phụ; mẹ ẹswa isopu phụ; waa ẹkwa uswe phụ yẹle nwẹnu ọphu nọ ndzụ; tụko tsẹe lẹ mee nwẹnu ọphu e gburu egbugbu phụ yẹle mini phụ dụ mma phụ; woru iya phee l'ụlo ono ugbo ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Oo-gude mee nwẹnu phụ; mẹ mini phụ, dụ mma phụ; mẹ nwẹnu ọphu nọ ndzụ phụ; mẹ oshi sida phụ; mẹ ẹswa isopu phụ; waa ẹkwa uswe phụ; mee ụlo ono t'ẹ b'a sọhe iya nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Yo gude nwẹnu ọphu nọ ndzụ phụ lụfu azụ mkpụkpu je ahaa ya t'o pheba l'ẹgu. Ọ kwa ẹge ono bẹ oo-shi kfụa ụgwo iphe, dụ ẹji; shi ẹge ono safu mmeru, nọ l'ụlo ono; ụlo ono abụru ụlo, ẹ taa sọdu nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ono bụ ekemu, ee-gudeje etso ẹhu-labụ l'ụdu iya ụdu iya; jeye l'ẹjo ẹkuluba; ");
INSERT INTO iqw_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","mẹ k'evu, tsụru l'uwe yẹle ọphu tsụru l'ụlo; ");
INSERT INTO iqw_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","mẹ k'onye ọnya nọ l'ẹhu; m'ọ bụ iphe, dụ l'ọ bụ ẹkpa; m'ọ bụ onye iphe tụkashiru poopoo l'ẹhu; ");
INSERT INTO iqw_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","t'e shi ẹge ono koshi teke iphe bụ iphe, aasọ nsọ; m'ọo teke ọ bụ iphe, ẹ taa sọdu nsọ. Ono bụ ekemu ẹge ee-meje kẹ ẹhu-labụ; mẹ k'iphe, tsụru evu. ");
INSERT INTO iqw_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Unu kfuru yeru ndu Ízurẹlu; sụ ẹphe-a: Ọ -nweru onye nweru iphe, atsọshi iya atsọshi l'ẹhu; bẹ iphe ono, atsọshi iya l'ẹhu ono bụkwa iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Iphe ono meekwaru onye ọbu; yọ bụru onye aasọ nsọ; mẹ iphe ọbu atsọshikwadu iya-a ẹge ọotsoshi; m'ọ kwanụ l'o nweru iphe, e gude gbobuta iya b'ọ bụlekwaa iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Iphe bụ oshi-azẹe, onye ono zẹru bụakwa iphe, aasọ nsọ. Iphe, bụ iphe, ọ nọduru anọdu a-bụkwaruphu iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","T'onye denyiru ẹka l'oshi-azẹe onye ọbu; sakwaa uwe iya asasa; ghụa ẹhu. Onye ono abụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Onye nọduru anọdu l'iphe, onye iphe shi l'ẹhu alashị nọduru; t'onye ono sakwaa uwe iya; ghụa ẹhu. Yọ bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","T'onye denyiru onye iphe shi l'ẹhu l'atsọshi ẹka sakwaa uwe iya asasa; ghụa ẹhu. Yọ bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Onye ono, iphe atsọshi atsọshi l'ẹhu ono -gbụshi onye ẹ taa sọdu nsọ ọnu-mini; t'onye ọbu sakwaa uwe iya; ghụa ẹhu. Yọ bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Iphe, bụ iphe aagba agbagba, onye ono nọduru l'eli iya gbaa bụakwa iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Iphe bụ onye ẹhu iya ruru l'iphe onye ọbu shi nọdu a-bụru onye aasọ nsọ jeye l'urẹnyashi. Onye wotaru iphe ọbu a-sakwa uwe iya asasa; ghụa ẹhu. Yọ bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Onye o denyiru ẹka; mbụ onye iphe shi l'ẹhu atsọshi; l'ẹ b'ọ kwọ ẹka; t'onye ono sakwaa uwe iya asasa; ghụa ẹhu. Ọo-bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ọ -bụru ite-ụra; bẹ onye ọbu denyiru ẹka; t'a tụkpokwaa ya. Teke ọ bụ iphe, e gude oshi mee; t'e gudekwa mini saa iphe ọbu asasa. ");
INSERT INTO iqw_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Onye ono, iphe alashị l'ẹhu ono -kalẹphu mma; t'ọ gụtaru onwiya ujiku ẹsaa nọo t'e gude mee ya t'ẹ ba sọhe iya nsọ. Yọ saa uwe iya; gude mini, e kutaru k'ọphungu ghụa ẹhu. Yọ bụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","O -be lẹ mbọku k'ẹsato; yọ nwụta kparakobe labụ; m'ọ bụ ndo labụ gude bya Ojejoje l'ifu l'ọnu Ụlo-Ẹ́kwà Ndzuko; bya anụ iya onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Onye ono, achịjeru Nchileke ẹja ono anwụta iya gude gwoo ngwẹja. Nanụ bẹ oo-gude gwoo ngwẹja-iphe, dụ ẹji. Yo gude ọphu gwoo ngwẹja-ukfuru. Ọ bụ ẹge ono bẹ ee-shi; yọ kfụa ụgwo iphe, dụ ẹji onye ono, iphe atsọshi l'ẹhu ono l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Teke nwoke nyịru iphe; t'ọ ghụkwaa ẹhu ọhuma; bụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ẹkwa; m'ọ bụ akpọ, a nyịru iphe kpua bẹ ee-gude mini saa asasa. Ẹkwa ono; m'ọ bụ akpọ ono a-bụru iphe aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Teke nwoke yẹle nwanyi zẹru; nyịa iphe; t'ẹphe ẹbo jekwa je aghụa ẹhu. Ẹphe ẹbo a-bụru ndu aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Ọ -bụru lẹ nwanyi bẹ nsọ eme bẹ ọo-bụru onye mmeru nọ l'ẹhu abalị ẹsaa. Onye denyiru iya ẹka a-bụkwaruphu onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Iphe bụ iphe, ọ zẹkpooru azẹe teke ono, nsọ eme iya ono; m'ọ bụ iphe, ọ nọduru anọdu tụkookwaru bụru iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Onye denyiru oshi-azẹe ya ẹka; a-sa uwe iya asasa; ghụa ẹhu. Onye ono abụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Onye denyiru iphe, ọ nọduru anọdu ẹka; a-sa uwe iya asasa; ghụa ẹhu. Onye ono abụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Onye denyiru ẹka l'oshi-azẹe ya; m'ọ bụ l'oshi, ọonodu anọdu bẹ bụakwa onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ọ -bụru lẹ nwoke jekfuru nwanyi, nsọ eme; mee ono, ala nwanyi ono erua ya l'ẹhu; t'a sọkwaa nwoke ono nsọ abalị ẹsaa. Iphe bụ oshi, nwoke ono zẹru azẹe l'ọ ha a-bụkota iphe, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Ọ -bụru lẹ nwanyi bẹ mee laru ujiku olemole lẹ teke nsọ te emedu iya; m'ọ bụ lẹ mee ọbu laghataru iya ujiku ole, ọonoje lẹ nsọ iya; t'a sọkwaa onye ọbu nsọ ẹge aasọje iya teke nsọ eme iya. ");
INSERT INTO iqw_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Iphe bụ oshi, ọ zẹru azẹe teke mee ono ala iya; bẹ aa-sọkwaphu nsọ ẹge a sọru oshi-azẹe, ọozeje teke nsọ eme iya. Iphe bụ iphe, ọ nọduru anọdu; t'a sọkwaa ya phụ nsọ ẹge ono, aasọje iya teke nsọ eme iya ono. ");
INSERT INTO iqw_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Iphe bụ onye denyiru ẹka l'iphe ono bụakwa onye aasọ nsọ. T'onye ono sakwaa uwe iya; ghụa ẹhu. Onye ono abụru onye aasọ nsọ jeye tẹ nchi jihu. ");
INSERT INTO iqw_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Obenu l'agha; mee ọbu -labuhule iya phụ; t'ọ gụtaru onwiya ujiku ẹsaa nọo. Teke e metsuaru; yọ bụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","O -be lẹ mbọku k'ẹsato t'onye ọbu nwụta kparakobe labụ; m'ọ bụ ndo labụ; nwụtaru onye achịjeru Nchileke ẹja l'ifu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","T'onye ono, achịjeru Nchileke ẹja ono nwụta nwẹnu lanụ gude gwoo ngwẹja-iphe, dụ ẹji. Yo gude ọphu gwoo ngwẹja-ukfuru. Onye ono, achịjeru Nchileke ẹja ono e-shi ẹge ono kfụa ụgwo iphe, dụ ẹji nwanyi ono l'ifu Ojejoje lẹ kẹ mee ono, laru iya nụ ono; yọ bụru onye aasọ nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Ono bụ ẹge unu e-shije dokahu ụnwu Ízurẹlu l'iphe, e-me t'ẹphe bụru ndu aasọ nsọ; t'ẹphe be evuta mmeru vubata l'ụlo-ẹ́kwà ono, nọ l'ẹke ono, ẹphe nọ ono; shi ẹge ono bụru ndu aasọ nsọ nwụshihu.” ");
INSERT INTO iqw_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ono bụ ekemu, a tụru doberu nwoke, iphe atsọshi l'ẹhu yẹle nwoke, nyịru iphe; shi ẹge ono bụru onye aasọ nsọ; ");
INSERT INTO iqw_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","bya abụkwaruphu kẹ nwanyi, nsọ eme; bụru kẹ nwoke; m'ọ bụ nwanyi iphe alashị l'ẹhu; m'ọ bụ nwoke, jekfuru nwanyi, aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ojejoje abya ekfuru nụ Mósisu l'ụnwu Érọnu ẹphe ẹbo nwụshihutsuaru teke ono, ẹphe jeru Ojejoje l'ifu ono; ");
INSERT INTO iqw_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","sụ ẹphe: “Kfuru nwunne ngu Érọnu; t'ẹ b'ọ bụjelekwaphu teke dụ iya mma; yọ bahụ lẹ Ẹke-Kakọta-ọdu-Nsọ; mbụ l'ẹke ono, e gude ẹkwa kebuta l'ifu ẹke ono, aakfụje ụgwo iphe, dụ ẹji, nọ l'eli Okpoko Ọgba-ndzụ ono. Ọdumeka bẹ ọo-nwụhukwa. Ishi iya abụru lẹ ya anọduje l'urukpu bya l'eli ẹke ono, aakfụje ụgwo iphe, dụ ẹji ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ọwaa bụ ẹge Érọnu e-gudeje bahụ lẹ Ẹke-Kakọta-ọdu-Nsọ: Oo-gude nwa oke-eswi, oo-gude gwoo ngwẹja-iphe, dụ ẹji; bya egude ebyila, oo-gude gwoo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Yọ chịta uwe-ime-ẹhu ọcha phụ, e doberu nsọ phụ yee; bya eyekwaaphu nwịba ọcha, eeyeje l'ime ukfu. Yo wota ẹkwa ọcha, gbịriri ẹkwa-ukfu tubuta onwiya; bya ewota okpu-ẹkwa kee. Uwe ono l'ọ ha bẹ dụkota nsọ. Oo-gudejeodu mini ghụa ẹhu; tẹmanu yo yede iya. ");
INSERT INTO iqw_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Tẹ ndu Ízurẹlu kpẹe Érọnu mkpi labụ t'o gude gwoo ngwẹja-iphe, dụ ẹji; waa ebyila lanụ, oo-gude gwoo ngwẹja-ukfuru. ");
INSERT INTO iqw_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Tẹ Érọnu kpụta oke-eswi phụ gude gwoo ngwẹja-iphe, dụ ẹji kẹ nk'iya; shi ẹge ono kfụa ụgwo iphe, dụ ẹji, o meru yẹle kẹ ndibe iya l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Yọ bya akpụta mkpi labụ phụ bya l'ifu Ojejoje l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Tẹ Érọnu wota ẹnwa tụa lẹ mkpi labụ ono. Ido lanụ a-bụru kẹ Ojejoje. Ido ọphu abụru kẹ Azazẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Mkpi ọphu ẹnwa iya laru Ojejoje; bẹ Érọnu e-gude gwoo ngwẹja-iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ọphu ẹnwa iya laru Azazẹlu; bẹ aa-kpụta lẹ ndzụ bya Ojejoje l'ifu t'e gude iya kfụa ụgwo iphe, dụ ẹji; tẹmanu a kpụtawa iya rụ je ahaa l'echi-ẹgu t'ọ bụru ẹja-enwenwe lakfu Azazẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Érọnu a-kpụta oke-eswi phụ, oo-gude gwoo ngwẹja-iphe, dụ ẹji phụ; gude kfụa ụgwo iphe, dụ ẹji k'onwiya mẹ kẹ ndibe iya. Yo woru oke-eswi ono gbua t'ọ bụru ngwẹja-iphe, dụ ẹji nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Yo wota mbeji, aagụje ọku; vọta icheku-ọku l'ẹnya-ngwẹja l'ifu Ojejoje; vọ-jia ya avọ-ji; bya ahata ínsẹnsu, e gwemaru egwema; yo ji mkpoji ẹka labụ; gude bahụ l'ẹke ono, e gebutaru ẹkwa ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","T'o woru ínsẹnsu ono tukobe l'eli ọku ono, nọ Ojejoje l'ifu ono; k'ọphu ẹnwuru-ọku ínsẹnsu ono a-kpụ tụu rachia ẹke ono, aanọduje akfụ ụgwo iphe, dụ ẹji l'eli Okpoko Ekemu ono; k'ọphu ẹ tọ nwụhudu. ");
INSERT INTO iqw_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","T'o meta mee oke-eswi ono; gude mkpụshi-ẹka phee ya l'eli ẹke ono, aakfụje ụgwo iphe, dụ ẹji ono. Yo gudekwaphu mkpụshi-ẹka phee mee-iphe ono ugbo ẹsaa l'ifu ẹke ono, aakfụje ụgwo iphe, dụ ẹji ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“T'o woru mkpi phụ, o gude gwoo ngwẹja-iphe, dụ ẹji ndu Ízurẹlu phụ; gbua; gude mee ya bahụ l'ẹke ono, e gebutaru ẹkwa ono; woru mee ya ono mee ẹge o meru mee oke-eswi phụ: mbụ phee ya l'eli ẹke ono, aakfụje ụgwo iphe, dụ ẹji ono; phekwaa ya phụ l'ifu iya. ");
INSERT INTO iqw_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yọ bụru ẹge ono bẹ oo-shi kfụa ụgwo iphe, dụ ẹji kẹ Ẹke-Kakọta-ọdu-Nsọ; kẹle ndu Ízurẹlu bụwa ndu aasọ nsọ; bụru ndu kwefuru íkè l'iphe, dụ ẹji, ẹphe mekotaru l'ọ ha. Yọ bụkwaruphu ẹge ono bụ ẹge oo-me iya lẹ kẹ Ụlo-Ẹ́kwà Ndzuko, bụ ọphu nọ ẹphe l'echi teke ono, ẹphe bụ ndu aasọ nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","T'ẹ b'ọ dụkwa onye a-nọdu l'ime Ụlo-Ẹ́kwà Ndzuko ono; mẹ Érọnu bahụlephu lẹ Ẹke-Kakọta-ọdu-Nsọ je ọkfu ụgwo iphe, dụ ẹji; jeye yọ kfu-gee ụgwo iphe, dụ ẹji k'onwiya yẹle kẹ ndibe iya mẹ kẹ ndu Ízurẹlu l'ẹpha ha; lụfuta. ");
INSERT INTO iqw_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Teke e metsuaru; yo jeshia l'ẹnya-ngwẹja ono, nọ Ojejoje l'ifu ono; je akfụa ụgwo iphe, dụ ẹji k'ẹke ono. Yo meta mee oke-eswi phụ yẹle mee mkpi phụ; wụru ye lẹ mpo, e mobegbaaru l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Yo meta mee ono gude mkpụshi-ẹka iya phee ya l'ẹnya-ngwẹja ono ugbo ẹsaa; shi ẹge ono safu iya ntụru kẹ ndu Ízurẹlu; dobe iya nsọ ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Érọnu -kfụ-gelephu ụgwo iphe, dụ ẹji, e meru lẹ Ẹke-Kakọta-ọdu-Nsọ yẹle kẹ Ụlo-Ẹ́kwà Ndzuko ono; mẹ k'ẹnya-ngwẹja ono; yọ bya akpụfuta mkpi phụ, nọ ndzụ phụ; ");
INSERT INTO iqw_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","woru ẹka labụ byabẹ mkpi onanu, nọ ndzụ ono l'ishi; bya atụko ẹjo iphe, ndu Ízurẹlu meru kfushikota kpua ya yẹle íkè, ẹphe kwefuru Nchileke; mẹkpo iphe, dụ ẹji, ẹphe mekotaru l'ọ ha. Yọ tụko iya byabẹ mkpi ono l'ishi; kpụru iya kpẹe onye a tụru ẹka t'o je ahaa ya l'echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Yọ bụru mkpi ono e-vutakota iphe, dụ ẹji ẹphe l'ọ ha laa lẹ mgbẹgu ẹke ẹ te budu ebubu; je anọdu. Ẹke oo-je ahaa mkpi ono bụ l'echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Teke ono; Érọnu abahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono je eyefu uwe ọcha ono, o yeru b'ọ bahụderu lẹ Ẹke-Kakọta-ọdu-Nsọ. O -yefutsua ya; yọ haa ya l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Yọ nọdu l'ẹke dụ nsọ ghụa ẹhu; woru uwe iya yee; lụfuta bya egwoo ngwẹja-ukfuru kẹ nk'iya yẹle kẹ ndu Ízurẹlu; shi ẹge ono kfụa ụgwo iphe, dụ ẹji k'onwiya yẹle kẹ ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yo woru ẹ́bà anụ, e gude gwoo ngwẹja-iphe, dụ ẹji phụ kpọo ọku l'ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Onye phụ, jeru je enwuhaa mkpi phụ t'ọ bụru eghu-enwenwe phụ; a-sakwaphụ uwe iya; ghụa ẹhu; tẹmanu yọ batadẹ l'ọdu ndu Ízurẹlu ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Oke-eswi phụ yẹle mkpi phụ, e gude gwoo ngwẹja iphe, dụ ẹji phụ; mbụ ọphu e wobataru; mee ya lẹ Ẹke-Kakọta-ọdu-Nsọ t'e gude kfụa ụgwo iphe, dụ ẹji phụ; bẹ aa-paru pafụ l'ọdu ndu Ízurẹlu; woru akpọ iya; mẹ anụ iya; mẹ nshị iya kpọo ọku. ");
INSERT INTO iqw_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","T'onye ono, jeru je akpọo ya ọku ono sakwaa uwe iya asasa; ghụa ẹhu; tẹmanu yọ batadẹ l'ọdu ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Ọo ya bụ t'iphe-a bụkwaru iphe, Nchileke tọru ọkpa iya sụ t'unu meje gbururu jeyewaru. O -rujee l'abalị k'iri l'ọnwa k'ẹsaa; unu aswịa aswịswi. T'ẹ b'ọ dụkwa unu onye e-jeje ozi mbọku ono; tsube lẹ ndu ọphu a mụru lẹ Ízurẹlu; je akpaa lẹ ndu laru alala, unu l'ẹphe bu; ");
INSERT INTO iqw_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","kẹ l'ọo mbọku ono bẹ aa-kfụ ụgwo iphe, dụ ẹji, unu meru; t'e gude sachafu unu iphe, dụ ẹji, unu meru l'ọ ha; unu abụru ndu ẹ taa sọdu nsọ l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Mbọku ono a-bụru unu eswe Sábatu; mbọku ọtu-ume, unu a-swịje aswịswi. Iphe ono bụ iphe, Nchileke tọru ọkpa iya; sụ t'unu meje iya gbururu jeyewaru. ");
INSERT INTO iqw_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Onye a-kfụ ụgwo iphe, dụ ẹji ono bụ onye achịjeru Nchileke ẹja, a wụru manụ l'ishi; dobe iya nsọ t'ọ bụru eze onye achịjeru Nchileke ẹja l'ọzori nna iya bụ iya. Oo-yeje uwe ọcha ono, dụ nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Ọo-kfụ ụgwo iphe, dụ ẹji kẹ Ẹke-Kakọta-ọdu-Nsọ; mẹ kẹ Ụlo-Ẹ́kwà Ndzuko; mẹ k'ẹnya-ngwẹja; yọ bya akfụa ụgwo iphe, dụ ẹji, ndu achịjeru Nchileke ẹja; mẹ kẹ ndu Ízurẹlu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ono a-bụwaruru iphe, Nchileke tọru ọkpa iya sụ t'e tsoje, unu a-nọdu emewaru gbururu jeye; mbụ l'aa-kfụje ụgwo iphe, dụ ẹji, ụnwu Ízurẹlu l'ẹpha ha. Yọ bụru ugbo lanụ l'afa bẹ ee-meje iya.” Yọ bụleruphu ẹge Ojejoje kfuru iya bẹ Mósisu meru iya. ");
INSERT INTO iqw_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Ọwaa iphe, ii-kfuru Érọnu yẹle ụnwu iya; mẹ l'ụnwu Ízurẹlu l'ẹphe ha: Kfuru ẹphe l'ọ kwa iphe, Ojejoje tụru ekemu iya ndọ-ọ: ");
INSERT INTO iqw_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ọ -nweru onye Ízurẹlu gburu eswi; m'ọ bụ nwatụru; m'ọ bụ eghu l'ọdu ndu Ízurẹlu; m'ọ bụ l'ọ pafụru iya apafụ; gbua; ");
INSERT INTO iqw_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","onye ono te gude iya bya l'ifu Ụlo-Ẹ́kwà Ndzuko; t'e gude gwoo ngwẹja; nụ Ojejoje l'ifu ụlo-ẹ́kwà Ojejoje ono; onye ono bẹ ikpe ọchi nmaakwaru. Ọ bụakwa ọchi b'o gburu. T'e bufukwa iya lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Iphe, meru iphe, a tụru ekemu-a bụ t'o mee tẹ ndu Ízurẹlu wotaje ngwẹja ono, ẹphe anọduje egwo l'ẹgu ono bya egwooru Ojejoje; mbụ t'ẹphe woru iya nụ onye achịjeru Nchileke ẹja l'ifu Ụlo-Ẹ́kwà Ndzuko; t'o gbua ya t'ọ bụru ngwẹja-ẹhu-agu, e gworu nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Onye ono, achịjeru Nchileke ẹja ono ephee mee anụ ono l'ẹnya-ngwẹja l'ifu Ụlo-Ẹ́kwà Ndzuko; bya akpọo ẹba iya ọku t'ọ bụru ngwẹja, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Tẹ ndu Ízurẹlu haa ogwo ngwẹja l'anụ agwa, a kpụru; yọ dụgbaa l'ọ bụ eghu; mbụ agwa ono, ẹphe gbadoru Nchileke wata ọbaru ẹja ono. Ono bụ iphe, Ojejoje tọru ọkpa iya sụ t'e tsoje; kfube l'ọgbo rua l'ọgbo. ");
INSERT INTO iqw_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Kfuru ẹphe: L'onye bụ onye Ízurẹlu; m'ọ bụ onye laru alala, ẹphe l'ẹphe bu, bụ onye gworu ngwẹja-ukfuru; m'ọ bụ l'o nweru ngwẹja ọdo, ọ nụru; ");
INSERT INTO iqw_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ọphu o gudedu iya bya l'ifu Ụlo-Ẹ́kwà Ndzuko bya egwooru Ojejoje; t'e bufukwa onye ọbu ebufu lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Iphe bụ onye bụ onye Ízurẹlu; m'ọ bụ onye laru alala l'alị ẹphe, riru mee-iphe; onye ono bẹ ya e-bufu iya lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ishi iya abụru l'ẹke ndzụ iphe, bụ iphe, e keru ekeke nọ bụ lẹ mee. Ya anụakwanu unu mee ono t'unu gudeje bya akfụa ụgwo iphe, dụ ẹji unu l'ẹnya-ngwẹja. Yọ bụru mee bẹ eegudeje akfụ ụgwo ndzụ madzụ. ");
INSERT INTO iqw_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ọo ya kparụ iphe, ya sụru unubẹ ndu Ízurẹlu: T'ẹ b'ọ dụkwa l'unu ha onye e-rije mee-iphe. Ọphu ọ dụkwa onye laru alala, unu l'ẹphe bu, e-rije mee-iphe. ");
INSERT INTO iqw_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Onye Ízurẹlu; m'ọ bụ onye laru alala, unu l'iya bu, akpa l'ẹgbudu; -gbua anụ; m'ọ bụ nwẹnu, ẹ taa sọdu nsọ; t'onye ono wụshikwaa mee ya l'alị kpochia ya ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ishi iya abụru l'ẹke ndzụ iphe, bụ iphe, e keru ekeke nọ bụ lẹ mee. Yọ bụru iya kparụ, iphe, ya sụru ndu Ízurẹlu: T'ẹ b'ọ dụkwa mee iphe, unu e-rije; kẹ l'ẹke ndzụ iphe, bụ iphe, e keru ekeke nọ bụ lẹ mee; l'iphe, bụ onye, riru iya nụ bẹ ee-bufukwa ebufu. ");
INSERT INTO iqw_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Onyemonye kpọ; m'ọ bụ onye a mụru lẹ Ízurẹlu; m'ọ bụ onye laru alala, bụ onye taru iphe, bụ iphe, nwụhuru anwụhu; m'ọ bụ iphe, anụ dzugburu adzugbu a-sakwa uwe iya asasa; ghụa ẹhu; bụru onye aasọ nsọ jeye nchi ejihu. Teke ono; yọ bụru onye ẹ taa sọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ọle ọ -bụru l'onye ọbu ta sadụ uwe iya; tọ ghụ ẹhu bẹ iphe, dụ ẹji ọbu, o meru ọbu tukokwaru iya l'ishi.” ");
INSERT INTO iqw_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu ndọ-ọ. Sụ ẹphe: L'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Unu be emekwa ẹge eemeje lẹ Íjiputu l'ẹke ono, unu shi buru ono. Ọphu unu 'emekwa ẹge eemeje l'alị Kénanu, bụ ẹke ono, ya edu unu ala ono. Unu be etsokwa ẹka ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Unu mejekwa iphe, ya tụru l'ekemu; mẹ iphe, ya tọru ọkpa iya sụ tẹ eetsoje; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Unu tsojekwa iphe, ya tọru ọkpa iya sụ t'e tsoje; l'emekwaphu iphe, ya tụru l'ekemu, bụ: onye meru iya nụ; ndzụ abụru nk'iya. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“T'ẹ b'ọ dụkwa onye e-jekfu onye yẹle ya bụ abụbu azẹe; kẹ l'ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ba arakwa nne ngu; shi ẹge ono mee nna ngu iphe-iphere; kẹ l'onye ono bụ nne ngu. Tẹ nggu lẹ nne ngu ba azẹkwa azẹe nwoke yẹle nwanyi. ");
INSERT INTO iqw_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ba arakwa nyee nna ngu; kẹ l'ọ kwa ome nna ngu iphe-iphere. ");
INSERT INTO iqw_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ba arakwa nwunne ngu; m'ọ bụ nwanna ngu; m'a mụru unu l'ufu lanụ; m'a mụru unu iche iche. ");
INSERT INTO iqw_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ba arakwa nwanwa ngu; m'ọ bụ nwa ngu kẹ nwoke; m'ọ bụ nwa ngu kẹ nwanyi mụru iya; kẹ l'ono bụkwa ome onwongu iphe-iphere. ");
INSERT INTO iqw_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ba arakwa nwada nyee nna ngu; mbụ onye bụ nna lanụ mụru nggu l'iya; kẹ l'ọ bụ nwanna ngu kẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ba arakwa nwunne nna ngu kẹ nwanyi; kẹle yẹle nna ngu bụ mee lanụ. ");
INSERT INTO iqw_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ba arakwa nwunne nne ngu; kẹle yẹle nne ngu bụ mee lanụ. ");
INSERT INTO iqw_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ba arakwa nyee nwunne nna ngu; shi ẹge ono mee nwunne nna ngu ono iphe-iphere; kẹ l'ọo nyee nwunne nna ngu. ");
INSERT INTO iqw_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ba arakwa nyee nwa ngu; kẹ l'ọo nyee nwa ngu b'ọ bụ. Ba arakwa iya. ");
INSERT INTO iqw_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ba arakwa nyee nwunne ngu; kẹ l'ọ kwa ome nwunne ngu iphe-iphere. ");
INSERT INTO iqw_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ba arakwa nwanyi; bya arakwaaphu nwatibe iya. Ọphu ị rakwa nwanwa nwanyi ono; m'ọ bụ onye ọphu nwa iya kẹ nwoke mụru; m'ọ bụ onye ọphu nwa iya kẹ nwanyi mụru; kẹ l'ẹphe l'iya bụ mee lanụ. Onye eme ẹge ono bụkwa ahụma bẹ oome. ");
INSERT INTO iqw_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ba alụkwa nwunne nyee ngu tẹ yẹle nwunne iya bya anọdu l'akpa ẹnya; yọ laru ngu l'ụlo l'ẹke nyee ngu ono nọkwadu ndzụ. ");
INSERT INTO iqw_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Be arakwa nwanyi teke nsọ eme iya; mbụ teke aasọkwadu iya nsọ kẹ nsọ ono, eme iya nụ ono. ");
INSERT INTO iqw_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ba arakwa nyee onye obutobu ngu; shi ẹge ono merua onwongu. ");
INSERT INTO iqw_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ba adụkwa ụnwu ngu ọphu ii-kwe t'a kpọo ọku gude gwaa Mólẹ̀ku; shi ẹge ono merua ẹpha Nchileke ngu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Ba arakwa nwoke ibe ngu; kẹ l'ono kwa akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Be arakwa anụ; shi ẹge ono merua onwongu. T'ẹ b'ọ dụkwa nwanyi, e-jekfu anụ tẹ yẹle iya zẹe; kẹ l'ono bụkwa ẹjo ahụma b'ọ bụ. ");
INSERT INTO iqw_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“T'ẹ b'ọ dụkwa iphe ono m'ọo nanụ, unu e-gude merua onwunu. Ishi iya abụru l'ọo iphe-a l'ọ ha bẹ iphe bụ mbakeshi-a, ya abya achịfu l'ifu unu-a gude merushia onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ọ kwa iphe ono bẹ ẹphe meru; shi ẹge ono merushia alị ono. Ya egude k'iphe, dụ ẹji ono, ẹphe meru ono gwaa alị ono ọchi. Alị ono agbọkwanua ẹphe l'ọ bụ onye gbọru ẹgbo. ");
INSERT INTO iqw_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ọlobu; unubẹdua; unu tsojekwa iphe, ya tọru ọkpa iya t'e tsoje; mẹ iphe, ya tụru l'ekemu. Ọphu ọ dụkwa onye e-je ome iphe ono, bụ ahụma ono m'ọo nanụ; m'ọ bụ onye a mụru lẹ Ízurẹlu; m'ọ bụ onye laru alala, unu l'iya bu; ");
INSERT INTO iqw_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","kẹ l'ọo ahụma ahụma ono l'ọ ha bẹ ndu alị-a meru; merushia alị-a; mbụ ndu ono, vuru unu ụzo bua l'ẹke-a ono. ");
INSERT INTO iqw_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Unu -merua alị ono emeru bẹ ọo-gbọkwa unu l'ọ bụ onye gbọru ẹgbo ẹge ono, ọ gbọshiru mba ono, vuru unu ụzo bua l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Kẹ l'o -nweru onye meru iphe ono, bụ ahụma ono m'ọo nanụ; bẹ ee-bufukwa onye ọbu lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Ọo ya meru iphe, unu e-meje iphe, ya sụru t'e meje; t'ẹ b'ọ dụ ẹjo ome-l'alị ono ọphu unu e-meje, bụ ọphu e shi emeje bẹ unu latadẹru. Ọphu unu 'egudekwa iya merushia onwunu; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu.” ");
INSERT INTO iqw_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu l'ẹphe ha: Unu bụkwaru ndu dụ nsọ; kẹle yẹbe Ojejoje, bụ Nchileke unu dụkwa nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","T'onyenọnu l'unu ha kwabẹjekwa nne iya lẹ nna iya ugvu. Unu edobeje ekemu mbọku ọtu-ume iya; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Unu ba aghachijekwa jelahaa lẹ nte; ọphu unu akpụjekwa ọgvu doberu onwunu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Teke unu egworu Ojejoje ngwẹja-ẹhu-agu; unu gwojekwa iya l'ụzo, ọo-nata iya unu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Unu rijekwa iphe ngwẹja ọbu lẹ mbọku, unu gworu iya; m'ọ kwanụ lẹ nchi-ta-abọhu iya. Ọ -bụru l'o nweru ọphu phọduru nụ jeye lẹ mbọku k'ẹto ya; t'a kpọkwaa ya ọku. ");
INSERT INTO iqw_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","O -nweru ọphu e riru lẹ mbọku k'ẹto ya b'ọ bụakwa ahụma b'e meru; ẹ taa natahẹkwa iya. ");
INSERT INTO iqw_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ọo ya bụ l'iphe bụ onye riru iya nụ bẹ iphe, dụ ẹji, o meru a-tukokwaru l'ishi; kẹ l'o meruru iphe, dụru Ojejoje nsọ. Onye ono bẹ ee-bufukwa lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Teke unu akpata iphe, unu meberu l'alị; unu ba akpajẹkwa iya jịa ẹka l'alị. Ọphu unu atụtujekwa ọphu nashịhuru ndu akparu iya unu daa l'alị. ");
INSERT INTO iqw_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Unu be ejejekwa mkpakwa akpụru vayịnu lẹ mgbo vayịnu unu. Ọphu unu 'atụtutajekwa ọphu dashịru l'alị. Unu hajẹru ndu onanu haaru ndu ụkpa; mẹ ndu laru alala; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Unu be ezijekwa iphura; unu ta adzụje ẹjo-ire. Ọphu unu 'aghọjekwaru madzụ ibe unu ụgho. ");
INSERT INTO iqw_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Unu ba akpapyabẹjekwa iphe, unu meru; gude ẹpha iya gụa ẹnwa; shi ẹge ono merua ẹpha Nchileke unu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Be erijekwa madzụ ibe ngu uru; ọphu ị najẹkwa iya nfụ. Tẹ aswa-ozi onye i buru ozi ba anọkwa ngu l'ẹka jeye l'ụtsu echile iya. ");
INSERT INTO iqw_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ba akọjekwa onye ada nkịchi ọnu; ọphu iigudejekwa iphe dochia onye ìshì ụzo. Tsụje Nchileke ngu egvu; kẹ l'ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Unu be ekpejekwa ẹjo ikpe. Unu be elejekwa madzụ ẹnya l'ifu; kpee ikpe; shi iya nma onye ụkpa ikpe; kẹ l'ọ bụ onye ụkpa; bya ekperu yeru eze madzụ; kẹ l'ọ bụ eze madzụ. Tẹ ikpe unu bụjekwaru ikpe, dụ mma. ");
INSERT INTO iqw_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ba abụkwa onye ntụmatu l'ẹke madzụ ibe ngu nọ; ọphu ịinokwa l'idzu t'e wota madzụ ibe ngu tsebe l'ifu ọgu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Be evukwaru nwunne ngu okfu l'ọkpoma. Jekfuje onye ọ daru nggu l'iya; t'unu kpeshia; t'ẹ b'i shi l'ẹhu iya je eye ẹka l'iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Be emelatajekwa ndibe unu iphe, ẹphe meru ngu; ọphu ọ dụkwa onye ọphu ii-vujeru iphe l'obu. Yejechiaru madzụ ibe ngu obu ẹge i yeru onwongu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Unu mejekwa iphe, ya tọru ọkpa iya t'e tsoje. Unu ba ahajẹkwa tẹ elu chia ọphu yẹ l'iya ẹ-ta abụdu ụdu lanụ. Ba akụjekwa uzi iphe labụ l'okfu ngu; ọphu iiyejekwa uwe, ẹ-ta abụdu ụdu ẹkwa lanụ b'e gude kwaa ya. ");
INSERT INTO iqw_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Ọ -bụru lẹ madzụ raru nwamgbọko, a gbaru ohu; bya edobewaru iya nwoke ọdo; t'ọ bụ l'a gbafụtawaru iya t'o nweru onwiya; t'e kpekwaa ya ekpekpe; hụ̀a ẹphe àhụ̀hù ẹge gbaru nụ. Ọle t'ẹ b'e egbukwa ẹphe egbugbu. Ishi iya abụru lẹ nwamgbọko ono bụkwadu ohu. ");
INSERT INTO iqw_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","T'onye kẹ nwoke kpụtakwa ebyila bya anụ l'ifu Ụlo-Ẹ́kwà Ndzuko; t'e gude gwooru iya ngwẹja ọkfu-ụgwo-iphe, dụ ẹji l'ifu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Onye achịjeru Nchileke ẹja egude ebyila ono, e gude gwoo ngwẹja ọkfu-ụgwo-iphe, dụ ẹji ono kfụa ụgwo iphe, dụ ẹji onye ono l'ifu Ojejoje; a gụaru iya nvụ l'iphe, dụ ẹji ono, o meru ono. ");
INSERT INTO iqw_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Unu -bahụlephu l'alị ono; dzashia ya oshi-ọmi, dụgbaa iche l'iche; unu sọjekwa nebyi iya nsọ. Afa ẹto bẹ unu a-sọ iya nsọ; ha ya eriri. ");
INSERT INTO iqw_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","O -be l'afa k'ẹno t'e doo akpụru, oshi ono mịtaru nsọ; gude gwooru Ojejoje ngwẹja-ekele. ");
INSERT INTO iqw_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","O -be l'afa k'ise; unu awatawaru ori akpụru oshi ọbu; k'ọphu oshi ono a-nọdu eyeru unu nebyi kẹ yọkfu-yọkfu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Unu ba atajẹkwa anụ, mee nọkwadu. Unu ba agwọjekwa ọgwu; ọphu unu emejekwa mgbashị. ");
INSERT INTO iqw_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Unu ba akpụfubebejekwa ẹgbushi, nọ unu lẹ mgboro ishi; ọphu unu akpụshijekwa iku ẹji-agba unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Unu be egbubatajekwa onwunu ọnya l'ẹhu; okfu lẹ madzụ nwụhuru; ọphu unu edejekwa onwunu mbo. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Be emekwa nwa ngu nwanyi t'ọ bụru nwanyi ọkpara; shi ẹge ono merua nwa ngu ọbu; a nọnyakwaa; ndu ọkpara abya eji alị unu; ụru-alị abya eji iya. ");
INSERT INTO iqw_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Unu dobeje ekemu mbọku ọtu-ume iya; unu akwabẹje ụlo iya ono, dụ nsọ ono ugvu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Unu be ejejekwa ọkpata ishi l'ẹka ndu aphụ àphụ̀; mẹ ndu njibya; kẹ l'ẹphe e-merukwa unu. Ọ kwa yẹbedua bụ Ojejoje, bụ Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Gbeshijekwaru ndu bụ ọgurenya l'oshi. Kwabẹjeru ndu bụ ọgurenya ugvu; nggu atsuje Nchileke egvu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Teke o nweru onye laru alala l'alị unu; unu ba akpakwa iya ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","T'e emejekwa onye laru alala, bu l'alị unu ẹge eemeje onye a mụru lẹ Ízurẹlu. Unu yekwaru onye ono obu ẹge unu yeru onwunu. Ishi iya abụru l'unubẹdua shikwaphu bụru ndu larụ alala l'alị Íjiputu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Teke unu atụ ẹge iphe hatabe ogologo; m'ọ bụ ẹge ẹra iya habe; m'ọ bụ ẹge iphe hatabe l'igwe; unu be emejekwa iya l'ụzo aghụgho. ");
INSERT INTO iqw_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Unu gudejekwa iphe, bụ ọkpobe iya tụa ya; mẹ ọkpobe nkwo-ẹka; mẹ ọkpobe ekpemu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu; onye dufutaru unu l'alị Íjiputu. ");
INSERT INTO iqw_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ọo ya bụ t'unu tsokotaje iphe, bụ iphe, ya tọru ọkpa iya sụ t'e tsoje; mẹ iphe, ya tụru l'ekemu l'ọ ha. Unu meje iya ẹge ono; kẹ l'ọo yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu ndọ-ọ: Iphe bụ onye Ízurẹlu; m'ọ bụ onye laru alala lẹ Ízurẹlu, kpụtaru nwa iya je anụ Mólẹ̀ku; t'e gbukwaa onye ono egbugbu. Tẹ ndu mkpụkpu ono wụfutakwa je atụ-gbua ya lẹ mkpuma. ");
INSERT INTO iqw_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Yẹbe Nchileke l'onwiya a-tachi ifu l'eke onye ọbu nọ; bufu iya lẹ ndu nk'iya; kẹ l'o gude nwa iya gwaa Mólẹ̀ku; shi ẹge ono merua ụlo iya ono, dụ nsọ ono; bya arụtoshia ẹpha iya ono, dụ nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ọ -bụru lẹ ndu mkpụkpu ono phụru onye kpụtaru nwa iya je anụ Mólẹ̀ku; bya anyịa nchị manụ; ẹphe te gbu onye ọbu; ");
INSERT INTO iqw_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","bẹ ya a-gbanwụkwaru onye ọbu ifu yẹle ndibe iya; bufu ẹphe lẹ ndu nk'ẹphe; mẹkpo iphe, bụ ndu ono yẹle iya eshiswe ụzo ono; mbụ ndu ono, jeru je egwolahaaru Mólẹ̀ku ẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Iphe, bụ onye jelahaaru ọkpata ishi l'ẹka ndu aphụ àphụ̀; mẹ l'ẹka ndu njibya; shi ẹge ono gwolahaa ẹja bẹ ya a-tachi ifu; bufu iya lẹ ndu nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Unu dobekwa onwunu iche; unu adụ nsọ; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Unu dobe iphe, ya tọru ọkpa iya t'e tsoje; meje iya ememe; kẹ l'ọo yẹbedua bụ Ojejoje, emeje unu t'unu dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Onye phuru nna iya; m'ọ bụ nne iya iphu; t'e gbukwaa onye ọbu egbugbu. Yo vuru ọchi onwiya; keshinu o phuru nna iya; m'ọ bụ nne iya iphu. ");
INSERT INTO iqw_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Ọ -bụru lẹ nwoke raru nyee nwoke ibe iya; ẹphe eshi ẹge ono ria ogori; t'e gbukwaa nwoke ọbu yẹle nwanyi ọbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Onye raru nyee nna iya bụkwa nna iya b'o meru iphe-iphere. T'e gbukwaa ẹphe ẹbo egbugbu; ẹphe evuru ọchi onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Onye raru nyee nwa iya; t'e gbukwaa ẹphe ẹbo. Ọchi onwẹphe atụ-koru ẹphe l'ishi; kẹ l'iphe ẹphe meru bụ akpamara. ");
INSERT INTO iqw_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Ọ -bụru lẹ nwoke jekfuru nwoke ibe iya; ẹphe azẹe azẹe nwoke yẹle nwanyi bẹ ẹphe ẹbo meekwaru akpamara. T'e gbukwaa ẹphe egbugbu. Ọchi onwẹphe atụ-koru ẹphe l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Onye lụru nwanyi; bya alụfua nne nyee ya ono bụkwa ahụma b'ọ bụ. T'a kpọkwaa nwoke ono yẹle ụnwanyi ono ọku ẹphe ẹbo; k'ọphu ẹ ta hadu ahụma t'ọ tọo ọkpa l'ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Teke ọ bụ lẹ nwoke jekfuru anụ; t'e gbukwaa ya egbugbu. E gbukwaaphu anụ ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Ọ -bụru lẹ nwanyi jekfuru anụ; t'e gbukwaa nwanyi ọbu; gbua anụ ọbu. Teke e gbutsuaru ẹphe; ọchi onwẹphe atụ-koru ẹphe l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Ọ -bụru lẹ nwoke lụru nwunne iya; m'ọ bụ nwanna iya yẹle iya azẹe; b'ọ bụkwa iphe-iphere. T'a nọdukwa l'edzudzu ọha bufu ẹphe. Ọ kwa nwunne iya b'o meru iphe-iphere. Tẹ iphe, o meru tụ-kokwaru iya l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Onye jekfuru nwanyi teke nsọ eme iya bẹ gvuakwaru ẹnu-mee nwanyi ono; mbụ lẹ nwanyi ọbu kpuhawaru ẹnu-mee ya ghebe ọnu. Ọo ya bụ; t'e bufukwa ẹphe ẹbo lẹ ndu nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Ba arakwa nwunne nne ngu; m'ọ bụ nwunne nna ngu; kẹ l'ọ kwa iphe-iphere l'ẹke ọkpobe abụbu ngu. Iphe, unu meru kwa unu b'ọ tụ-koru l'ishi. ");
INSERT INTO iqw_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Onye raru nyee nwunne nna iya; m'ọ bụ nyee nwunne nne iya; bẹ bụkwa nwunne nna iya ono; m'ọ bụ nwunne nne iya ono b'o meru iphe-iphere. Iphe, ẹphe meru kwa ẹphe b'ọ tụkoru l'ishi. Ẹphe ta atọgbokwa akọ lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Onye lụru nyee nwunne iya bẹ mekwaru iphe, aasọ nsọ; bya emee nwunne iya ọbu iphe-iphere. Ẹphe ta atọgbokwa akọ lẹ mgboko. ");
INSERT INTO iqw_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Ọo ya bụ; unu dobekota iphe, ya tọru ọkpa iya; mẹ iphe, ya tụru l'ekemu; k'ọphu alị ono, ya edu unu ala ono ta agbọdu unu l'ọ bụ onye gbọru ẹgbo. ");
INSERT INTO iqw_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Unu be emejekwa l'ọ bụ ndu mba ono, ya abya achịfu l'ifu unu ono; kẹ l'ọ kwa iphe ono l'ọ ha bẹ meru nụ; ẹphe adụ iya oyi. ");
INSERT INTO iqw_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ya kfuhawaru unu: “L'unu e-nweru alị ẹphe; ya anụ iya unu t'ọ bụru òkè-iphe unu; mbụ ẹgiri alị ono.” Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu, bụ onye shi l'iphe, bụ mba fọta unu dobe iche. ");
INSERT INTO iqw_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Ọo ya bụ; unu mejekwa iya t'o doo ẹnya; mbụ iphe, dụ iche l'anụ, aasọ nsọ; l'ọphu ẹ taa sọdu nsọ; mẹ iphe, dụ iche lẹ nwẹnu, aasọ nsọ; l'ọphu ẹ taa sọdu nsọ. Unu be egudekwa anụ; m'ọ bụ nwẹnu; m'ọ kwanu iphe, awụ l'ẹpho merua onwunu; mbụ ụnwu iphe ono, mu gụshiru unu sụ t'unu sọje nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Unu dobekwaru iya onwunu nsọ; kẹle yẹbe Ojejoje dụkwa nsọ. Ya shiwa l'iphe, bụ mba fọfuta unu dobe iche t'unu bụru nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Nwoke; m'ọ bụ nwanyi, aphụ àphụ̀; m'ọ bụ l'ọ bụ nwanjibya l'unu; t'e gbukwaa ya egbugbu. T'e gudekwa mkpuma tụ-gbushia ẹphe; ọchi ẹphe atụ-koru ẹphe l'ishi.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: “Ọwaa iphe, ii-kfuru ndu achịjeru Nchileke ẹja; mbụ ụnwu Érọnu: T'ẹ b'ọ dụkwa onye e-gudeje onye nk'iya, nwụhuru anwụhu mee onwiya onye aasọ nsọ; ");
INSERT INTO iqw_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","gbahalẹkwaphu l'onye ọbu bụ ọkpobe abụbu iya: ọ dụ g'ọo nna iya; m'ọ bụ nne iya; m'ọ bụ nwa iya kẹ nwoke; nwa iya kẹ nwanyi; nwunne iya nwoke; ");
INSERT INTO iqw_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","m'ọ kwanụ nwunne iya kẹ nwanyi, ẹ-ta alụdua nji; yọ bụru iya b'ọ nọ l'ẹka; kẹ l'ẹ tọ lụdua nji. Odzu egbe onye ono nwekwaru ike; yo gude iya mee onwiya onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","T'ẹ b'o mekwa onwiya onye aasọ nsọ l'odzu onye ọgo iya; shi ẹge ono merua onwiya. ");
INSERT INTO iqw_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“T'ẹphe ba akpụshijekwa ishi; ọphu ẹphe akpụ-shijekwa ẹji-agba ẹphe; ọphu ẹphe ebujekwa mbo l'ẹhu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","T'ẹphe dụkwaru Nchileke ẹphe nsọ; k'ọphu ẹphe te emerudu ẹpha iya. Ishi iya abụru l'ọo ẹphe egwoje ngwẹja-ọku nụ Ojejoje; mbụ nri ono, ẹphe anụje Nchileke ẹphe ono. Ọo ya bụ; t'ẹphe bụkwaru ndu dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","T'onye achịjeru Nchileke ẹja ba alụkwa nwanyi, shiwa l'ọgba ọkpara merushiwa onwiya. Ọphu ọ lụkwa nwanyi, nji iya chịfuru achịfu; kẹ l'onye achịjeru Nchileke ẹja dụkwaru Nchileke iya lẹ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Unu wotakwa onye achịjeru Nchileke ẹja l'ọ bụ onye dụ nsọ; kẹ l'ọo yẹbedua agwaru unu Nchileke. T'ọ bụkwaru onye dụru unu nsọ; kẹle yẹbedua, bụ Ojejoje, bụ onye doru unu nsọ bụkwa onye dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Ọ -bụru lẹ nwatibe onye achịjeru Nchileke ẹja wataru ọgba ọkpara; shi ẹge ono merua onwiya bụakwa nna iya b'o meruru. T'a kpọkwaa nwata nwanyi ọbu ọku. ");
INSERT INTO iqw_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“T'onye bụ onye ishi ndu achịjeru Nchileke ẹja l'unwunne iya; mbụ onye a wụru manụ l'ishi; bụru onye e meru t'o yeje uwe ndu achịjeru Nchileke ẹja; tẹ onye ono ba ahajẹkwa ẹgbushi iya t'ọ yagashịhu ayagashịhu; ọphu ọ lajajẹkwa uwe iya alaja. ");
INSERT INTO iqw_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","T'onye ono ba abahụjekwa l'ẹke odzu zẹ. T'ẹ b'ọ dụkwa m'o -ruhuru; ọ bụru nna iya; m'ọ bụ nne iya nwụhuru; ọo-bahụ l'ẹke ono je ome onwiya onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","T'ẹ b'ọ lụfujekwa alụfu l'ụlo, dụ nsọ kẹ Nchileke; ọphu o merukwa ụlo ọbu emeru; kẹ l'ọo manụ Nchileke iya b'a wụru iya l'ishi. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Tẹ nwanyi, ọo-lụ bụkwaru nwanyi yẹle nwoke ta zẹbua. ");
INSERT INTO iqw_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","T'ẹ b'ọ lụkwa nwanyi, nji iya ta nọhedu; ọphu ọolukwa nwanyi, a chịfuru achịfu; m'ọ kwanụ nwanyi, shi l'ọgba ọkpara merua onwiya. Tẹ nwanyi, ọo-lụ bụkwaru nwanyi yẹle nwoke ta zẹbua; nwanyi, shi l'ikfu nk'iya; ");
INSERT INTO iqw_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","k'ọphu ụnwegirima iya ta bụdu ndu aasọ nsọ. Yo shi ẹge ono merua ikfu iya. Ọ kwa yẹbedua, bụ Ojejoje bụ onye meru iya; yọ dụ nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Ọwaa iphe, ii-kfuru Érọnu ndọ-ọ: Iphe bụ onye bụ eri ngu tsube l'ọgbo rua l'ọgbo, bụ onye nweru ẹke iphe mebyiru iya; t'ẹ b'ọ byakwa t'ọ nụ Nchileke iya nri. ");
INSERT INTO iqw_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","T'iphe bụ onye nweru ẹke iphe mebyiru iya ba byakwa ntse; mbụ onye ìshì; onye ngvụru; m'ọ bụ onye, nweru ẹke ẹhu ẹ-te dzudu iya oke; ");
INSERT INTO iqw_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","onye iphe lọnwuru ọkpa lanụ; m'ọ bụ ẹka lanụ; ");
INSERT INTO iqw_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","onye ekwebe; onye, gbaru l'ọ bụ ọha-ikirima; onye iphe eme l'ẹnya; onye iphe eme l'akpọ ẹhu; m'ọ bụ onye a haru aháhá. ");
INSERT INTO iqw_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","T'ẹ b'ọ dụkwa onye eri Érọnu, bụ onye achịjeru Nchileke ẹja, nweru ẹke iphe mebyiru iya, a-byajẹ ntse bya ogworu Ojejoje ngwẹja-ọku. Keshinu o nweru ẹke iphe mebyiru iya t'ẹ b'ọ kpịritakwa ntse k'ogworu Nchileke iya ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ọle t'o rijekwaru nri, a nụru Nchileke iya; mbụ nri ọphu dụ nsọ; mẹ ọphu kakọta ọdu nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ọle keshinu o nweru ẹke iphe mebyiru iya; t'ẹ b'o jenyabejekwa mgboro ẹkwa, e gude kpụ-buta Ẹke-Kakọta-ọdu-Nsọ; ọphu oojenyabejekwa ẹnya-ngwẹja; t'ẹ b'o shi ẹge ono merua ụlo iya ono, dụ nsọ ono; kẹ l'ọ kwa yẹbedua bụ Ojejoje, bụ onye emeje ẹphe; t'ẹphe adụ nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Tọ dụ iya bụ; Mósisu abya eworu iphe ono l'ọ ha kfuaru Érọnu yẹle ụnwu iya; mẹ ndu Ízurẹlu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Kfuaru Érọnu yẹle ụnwu iya t'ẹphe kwabẹjekwaru iphe ono, ndu Ízurẹlu doberu iya nsọ ono ẹnya; t'ẹphe be gude iya merua ẹpha iya ono, dụ nsọ ono; kẹ l'ọ kwa yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Sụ ẹphe: “L'iphe bụ onye bụ eri unu; tsube l'ọgbo sweru ọgbo, bụ onye aasọ nsọ, byanyabẹru iphe, ndu Ízurẹlu doberu yẹbe Ojejoje nsọ; t'e bufukwa onye ono ebufu l'ifu iya. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ọ -bụru l'o nweru onye, shi l'eri Érọnu, iphe, eswe nswe eme l'akpọ-ẹhu; m'ọ kwanụ l'iphe alashị iya l'ẹhu; t'onye ono be erikwa iphe, dụ nsọ jeye teke ọo-kọrohu; bụru onye ẹ ta asọhedu nsọ. Onye denyiru ẹka l'iphe, aasọ nsọ; dụ l'ọ bụ odzu; m'ọ kwanu l'ẹhu iya ruru l'iphe-anyịnyi; ");
INSERT INTO iqw_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","m'ọ bụ l'o denyiru iphe, awụ l'ẹpho ẹka, bụ iphe, ee-me iya t'ọ bụru onye aasọ nsọ; m'ọ bụ l'o denyiru onye aasọ nsọ ẹka; m'ọ bụ l'o nweru iphe ọdo, meru iya; yọ bụru onye aasọ nsọ; b'ọ bụakwa onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Onye denyiru iphe, dụ ẹge ono ẹka a-bụru onye aasọ nsọ jeye tẹ nchi jihu. T'ẹ b'ọ dụkwa iphe, e doberu nsọ, oo-ri; gbahaa l'o gude mini ghụa ẹhu. ");
INSERT INTO iqw_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ẹnyanwu -nyịhulephu; b'ẹ ta asọhekwa onye ọbu nsọ. Ọ bụ teke ono bẹ onye ọbu a-watawaru ori iphe, e doberu nsọ; kẹ l'ọo ono bụ nri iya. ");
INSERT INTO iqw_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","T'ẹ b'o rijekwa iphe, nwụhuru anwụhu; m'ọ bụ iphe, anụ-ẹgu-ẹgbudu dzugburu adzugbu; t'ẹ b'o shi ẹge ono merua onwiya. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Tẹ ndu achịjeru Nchileke ẹja mejekwa iphe, ya sụru t'ẹphe meje. Ọ -bụru l'ẹphe te emedu iya bẹ ẹphe e-metakwa iphe, dụ ẹji kpua onwẹphe; yo gbushia ẹphe. Ọ kwa yẹbedua bụ Ojejoje, bụ onye meru ẹphe; ẹphe adụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“T'ẹ b'ọ dụkwa onye ẹ-ta abụdu onye eri ndu achịjeru Nchileke ẹja, e-ri iphe, e doberu nsọ. T'onye byaru ẹbyee lẹ k'onye achịjeru Nchileke ẹja; m'ọ bụ onye byaru iya ozi be erikwa iya. ");
INSERT INTO iqw_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ọle; ọ -bụru l'onye achịjeru Nchileke ẹja gude okpoga iya gbata ohu; m'ọ bụ l'a mụru ohu l'ufu iya; tẹ ndu onanu rijekwa iya. ");
INSERT INTO iqw_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ọ -bụru lẹ nwa nwanyi onye achịjeru Nchileke ẹja lụru onye ẹ-ta abụdu onye achịjeru Nchileke ẹja; tẹ nwanyi ọbu be erijekwa iphe ono, dụ nsọ ono, aanụje ndu achịjeru Nchileke ẹja ono. ");
INSERT INTO iqw_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ọle; ọ -bụkwanuru lẹ nwa nwanyi onye ono, achịjeru Nchileke ẹja ono ta mụtadu nwa; nji iya anwụhuwa; m'ọ kwanụ l'a chịfuru iya achịfu; yọ laa kẹ nna iya; t'o rijekwa nri ono ẹge o shi erije iya teke ọ bụ nwata. Ọle; tẹ onye ẹ ta abụdu onye eri ndu achịjeru Nchileke ẹja be erikwa iya. ");
INSERT INTO iqw_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Onye riru iphe, e doberu nsọ l'amagama; tẹ onye ono kfụkwaa onye achịjeru Nchileke ẹja ụgwo iya; kfụru nkere-ise tukobe iya. ");
INSERT INTO iqw_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Tẹ ndu achịjeru Nchileke ẹja be emerukwa ngwẹja, dụ nsọ, shi l'ẹka ndu Ízurẹlu, bụ ọphu ẹphe nụru Ojejoje; ");
INSERT INTO iqw_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","shi ẹge ono haa tẹ ndu, ẹ ta gbadụ nụ ria iphe ono, dụ nsọ ono; shi iya rita iphe, dụ ẹji tukobe onwẹphe; bụru ndu ikpe nmaru. Ọ kwa yẹbedua bụ Ojejoje, bụ onye meru ẹphe; ẹphe adụ nsọ.” ");
INSERT INTO iqw_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Ọwaa iphe, ii-kfuru Érọnu yẹle ụnwu iya; mẹ ndu Ízurẹlu l'ẹphe ha: Ọ -bụru l'onye Ízurẹlu; m'ọ bụ onye laru alala, bu lẹ Ízurẹlu gude iphe bya t'e gwooru Ojejoje ngwẹja-ukfuru k'iphe, o kweru ụkwa iya; m'ọ kwanụ iphe, ọ tụru obu iya ama kẹ anụnu; ");
INSERT INTO iqw_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","t'onye ono kpụtakwa anụ, bụ okee ya, ẹ-ta adụdu ẹke iphe mebyiru iya emebyi bya. Iphe, oo-gude bya bụ oke-eswi; m'ọ bụ ebyila; m'ọ bụ mkpi; k'ọphu aa-natakwa nụ iya unu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Unu be ewotakwa iphe, nweru ntụpo gude bya ogwo ngwẹja ọbu; kẹ l'ẹ taa natakwa iya unu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Onye kpụtaru eswi; m'ọ bụ atụru; m'ọ bụ eghu gude bya ogworu Ojejoje ngwẹja-ẹhu-agu; t'o shi ẹge ono medzua iphe, o kweru ụkwa iya; m'ọ bụ iphe, ọ tụru obu iya ama; t'ọ bụkwaru ọphu ẹ te nwedu ntụpo; k'ọphu aa-nata iya ẹya l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Unu ba anụjekwa Ojejoje anụ, atsụ ìshì; m'ọ bụ ọphu e mekaru iphe; m'ọ bụ ọphu iphe mebyiru ibe-ẹhu iya nanụ embeyi; m'ọ bụ ọphu iphe alashị l'ẹhu; m'ọ bụ ọphu iphe eme l'akpọ-ẹhu iya. Unu be egudekwa anụ, dụ ẹge ono bya ogworu Ojejoje ngwẹja-ọku l'eli ẹnya-ngwẹja. ");
INSERT INTO iqw_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ọ -bụru ngwẹja, madzụ tụru obu iya ama l'anụ; bẹ onye ọbu nwekwaru ike nụ eswi; m'ọ bụ atụru, nweru ntụpo. Ọle; teke bụ l'ọ -bụ ọphu onye ono gude emedzu iphe, o kweru ụkwa iya b'ẹ taa natakwa iya ẹya. ");
INSERT INTO iqw_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Unu ba anụjekwa Ojejoje anụ, e mekaru iphe l'akpụru-akụ; m'ọ bụ ọphu e tsupyaru nk'iya etsupya; m'ọ bụ ọphu iphe lajaru nk'iya alaja; m'ọ bụ ọphu e bufuru nk'iya ebufu. Unu be emejekwa iphe, dụ ẹge ono l'alị unu-wa. ");
INSERT INTO iqw_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Unu ba anụjekwa anụ, shi l'ẹka onye ọhodo; t'ọ bụru nri, unu anụ Nchileke unu. Lẹ keshinu egbe anụ ono dụ l'ọ bụ anụ, nweru ntụpo b'ẹ ta anatakwa iya unu l'ẹka.” ");
INSERT INTO iqw_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“A -mụa nwa eswi k'ọphungu; m'ọ bụ nwa atụru; ọdo nweghu; t'a hajẹkwaa ya tẹ yẹle nne iya nọo abalị ẹsaa. Tsube lẹ mbọku k'ẹsato tụgburu b'e nweru ike kpụta iya je anụ t'e gude gwooru Ojejoje ngwẹja-ọku. Teke ono bẹ aa-natakwa iya-a. ");
INSERT INTO iqw_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Unu ba atụkojekwa nne eswi yẹle nwa iya; m'ọ bụ atụru yẹle nwa iya gbua ujiku lanụ. ");
INSERT INTO iqw_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Teke unu egworu Ojejoje ngwẹja-ekele; unu mejekwa iya l'ụzo, dụ mma; k'ọphu aa-nata iya unu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Unu tụkokwa anụ, e gude gwoo ngwẹja ọbu takọta mbọku ono. T'ẹ b'ọ dụkwa ọphu aa-ha t'ọ nọo lụfuta l'ụtsu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Unu dobekwa ekemu iya; unu emeje iya ememe. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Unu be emerukwa ẹpha iya ono, dụ nsọ ono emeru. Tẹ ndu Ízurẹlu dobe ẹpha iya nsọ; kẹ l'ọ kwa yẹbedua bụ Ojejoje, bụ onye meru unu; unu adụ nsọ; ");
INSERT INTO iqw_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","bya abụru onye dufutaru unu lẹ Íjiputu tẹ ya bụru Nchileke unu. Ọ kwa yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ọwaa iphe, ii-kfuru ndu Ízurẹlu ndọ-ọ: Sụ ẹphe: ‘L'ọwaa bụ ajị, yẹbe Ojejoje dobetsuaru ndọ-ọ; mbụ ajị, unu a-ra arara l'ọo ya a-bụ ndzuko, dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ujiku ishingu bẹ unu e-jeje ozi; mbọku k'ẹsaa abụru eswe Sábatu, bụ mbọku ọtu-ume. Mbọku ono a-bụru eswe ndzuko ọphu dụ nsọ. Unu be ejejekwa ozi mbọku ono; kẹ l'ọ bụ mbọku ọtu-ume kẹ Ojejoje l'iphe bụ ẹke unu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ọwaa bụ ajị, Ojejoje doberu; mbụ ndzuko, dụ nsọ, unu e-dzukobeje m'o rua teke e doberu iya. ");
INSERT INTO iqw_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“ ‘Ajị Esweta Ojejoje bụ mbọku, aa-watajẹ iya bụ l'urẹnyashi mbọku ọnwa mbụ gbaru l'abalị iri l'ẹno. ");
INSERT INTO iqw_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","O -be lẹ mbọku k'iri l'ise l'ọnwa ono kwaphụ; unu agbajẹeru Ojejoje Ajị Buredi, ẹ te kodu ekoko. Ujiku ẹsaa bẹ unu a-ta buredi, ẹ te yedu iphe, ekoje buredi. ");
INSERT INTO iqw_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mbọku mbụ l'oge ajị ono bẹ unu e-nweru ndzuko, dụ nsọ. T'ẹ b'ọ dụkwa ozi, unu e-jeje mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ujiku ẹsaa bẹ unu a-nọdulephu egworu Ojejoje ngwẹja-ọku. O -be lẹ mbọku k'ẹsaa; unu enwee ndzuko, dụ nsọ. T'ẹ b'ọ dụkwa ozi, unu e-je mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","“ ‘Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Ọwaa iphe, ii-kfuru ndu Ízurẹlu ndọ-ọ: L'ẹphe -bahụlephu l'alị ono, ya abya ẹphe anụnu ono; teke ẹphe kpataru iphe, e meberu l'alị ono; ẹphe ewota ukfu lanụ l'iphe ọdungu, ẹphe kpataru je anụ onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","T'onye ono, achịjeru Nchileke ẹja ono wota ukfu iphe ono maa Ojejoje l'ifu; k'ọphu Nchileke a-nata iya unu l'ẹka. Ọ bụ lẹ nchi-ta-abọhu mbọku ọtu-ume ono b'ọo-ma iya ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Mbọku ono, unu a-ma ukfu iphe ono l'ifu Ojejoje ono bẹ unu e-gudekwaphu nwa ebyila, nọru afa lanụ, ẹ-te nwedu ntụpo bya egwoo ngwẹja-ukfuru nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ngwẹja nri, a-yị nụ a-bụru ntụ akpe, a gwọkoberu manụ; yo ji nkwọ-ẹka, e keru ụzo iri wota uzi labụ, ee-gude gwooru Ojejoje ngwẹja-ọku, mkpọ iya dụ mma. E yekobekwa iya phụ mẹe, jiru konggo labụ t'ọ bụru ngwẹja-mẹe. ");
INSERT INTO iqw_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","T'ẹ b'ọ dụkwa buredi, unu a-ta; ọphu unu atakwa akpe, a hụru ahụhu; ọphu unu erikwa ọphu nọ l'onyingu; gbururu jeye mbọku ono, unu e-wotaru Nchileke unu ngwẹja ono. Ono a-bụru iphe, ya tọru ọkpa iya t'e tsoje tsube l'ọgbo sweru ọgbo l'iphe bụ ẹke unu bụ. ");
INSERT INTO iqw_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Idzu ẹsaa -swelephu; tsube lẹ nchi-ta-abọhu mbọku ọtu-ume ono, unu gworu ngwẹja-amama ono; ");
INSERT INTO iqw_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","teke a nọ-dzuleruphu ụkporo abalị labụ l'abalị iri; o -rua lẹ nchi-ta-abọhu mbọku ọtu-ume k'ẹsaa; unu byakwa bya egwooru Ojejoje ngwẹja-nri, unu e-gude akpe ọphungu gwoo. ");
INSERT INTO iqw_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Unu shi l'ẹke unu bu wota ishi buredi ẹbo, e gheru lẹ ntụ akpe, jiru nkwo-ẹka, e keru ụzo iri; wota uzi labụ, e yeru iphe, ekoje buredi; bya anụ t'e gude gwoo ngwẹja-amama t'ọ bụru akpụru iphe mbụ, a nụru Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Iphe, unu e-yekobefua l'ishi buredi ono bụ ụnwu ebyila ẹsaa, nọtsuaru afa ophu; bụkwaruphu ọphu ẹ-ta dụdu ẹke ntụpo nọ iya; waa nwa oke-eswi lanụ; mẹ ebyila labụ. T'e gude anụ ono l'ọ ha; gude ngwẹja-nri; mẹ ngwẹja-mẹe gwoo ngwẹja-ukfuru nụ Ojejoje; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Unu akpụta mkpi lanụ gude gwoo ngwẹja-iphe, dụ ẹji; kpụtakwaphu ụnwu ebyila labụ, gbagbaaru afa gude gwoo ngwẹja-ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","T'onye ono, achịjeru Nchileke ẹja ono woru ụnwu ebyila labụ ono; waa buredi ono, e meru l'akpụru iphe mbụ, a kpataru l'okfu ono maa Ojejoje l'ifu t'ọ bụru ngwẹja-amama. Iphe ngwẹja ono bụ bụ ngwẹja, dụ nsọ kẹ Ojejoje. T'ọ bụru onye achịjeru Nchileke ẹja bụ onye e-ri iya nụ. ");
INSERT INTO iqw_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mbọku ono kwaphụ bẹ unu e-nweru ndzuko, dụ nsọ. T'ẹ b'ọ dụkwa ozi, unu e-je mbọku ono l'ọ ha. Ono a-bụru iphe, a tọru ọkpa iya t'e tsoje tsube l'ọgbo sweru ọgbo; unu emeje iya l'iphe bụ ẹke unu bu. ");
INSERT INTO iqw_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Teke unu akpata iphe, unu meberu l'alị; unu ba akpajẹkwa iya jịa ẹka l'alị. Ọphu unu atụtujekwa ọphu nashịhuru ndu akparu iya unu daa l'alị. Unu hajẹeru ndu ụkpa yẹle ndu laru alala ọphu darụ l'alị. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu ndọ-ọ: Sụ ẹphe: ‘L'iphe bụ mbọku mbụ l'ọnwa k'ẹsaa bụkwa ẹphe mbọku ọtu-ume; mbụ mbọku, ẹphe e-nweru ndzuko, dụ nsọ. O -be mbọku ono t'e gbua ụpyoku gude karu onyemonye. ");
INSERT INTO iqw_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","T'ẹ b'ọ dụkwa ozi, unu e-jeje mbọku ono l'ọ ha. Iphe, unu e-mejechia bụ l'unu e-gwojeru Ojejoje ngwẹja-ọku.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Tọ dụ iya bụ; Ojejoje bya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Mbọku, ọnwa ẹsaa ono dụ l'abalị iri a-bụjeru unu Eswe Ọkfu Ụgwo Ẹjo iphe. Mbọku ono bẹ unu e-nwe ndzuko, dụ nsọ; swịa aswịswi; gwoo ngwẹja-ọku; nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","T'ẹ b'ọ dụkwa ozi, unu e-jeje mbọku ono; kẹ lẹ mbọku ono bụ Eswe Ọkfu Ụgwo; mbụ mbọku, unu a-nọdu l'ifu Ojejoje kfụa ụgwo iphe, dụ ẹji, unu meru. ");
INSERT INTO iqw_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Kẹ l'iphe bụ onye ẹ-ta aswịdu aswịswi mbọku ono bẹ ee-bufukwa ebufu lẹ ndibe ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Onye jeru ozi mbọku ono bẹ ya e-kwofukwa l'ẹke ndibe ẹphe nọ. ");
INSERT INTO iqw_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","T'ẹ b'ọ dụkwa ozi, unu e-je lẹ phuu. Ono a-bụru iphe, a tọru ọkpa iya t'e tsoje tsube l'ọgbo sweru ọgbo. Unu a-nọdu eme iya iphe bụ l'ẹke unu bu. ");
INSERT INTO iqw_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mbọku ono a-bụru unu mbọku ọtu-ume. Unu swịjee aswịswi mbọku ono. Unu e-shije l'urẹnyashi mbọku, ọnwa dụ l'abalị tete tụa ume jeye l'urẹnyashi kẹ mbọku, ọnwa a-gba abalị iri.” ");
INSERT INTO iqw_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ọwaa iphe, ii-kfuru ụnwu Ízurẹlu ndọ-ọ: Sụ ẹphe: ‘L'ọnwa ẹsaa ono -gbalẹphu abalị iri l'ise; t'a gbaa Ajị M̀kpù kẹ Ojejoje. Iphe, aa-gbaru iya Ojejoje bụ ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mbọku mbụ; bẹ unu e-nwe ndzuko, dụ nsọ. T'ẹ b'ọ dụkwa ozi, unu e-je mbọku ono l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ujiku ẹsaa ono; bẹ unu e-gwojeru Ojejoje ngwẹja-ọku. O -be lẹ mbọku k'ẹsato; unu enwee ndzuko, dụ nsọ; gwokwaaruphu Ojejoje ngwẹja-ọku. Ndzuko ono bụkwa ndzuko, dụ nsọ. Ọo ya bụ t'ẹ b'ọ dụkwa ozi, unu e-jeje mbọku ono l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Ono bụ ajị, Ojejoje doberu; mbụ ọphu unu a-ra arara t'ọ bụru ndzuko, dụ nsọ. T'e gwooru Ojejoje ngwẹja-ọku; bụ iya bụ ngwẹja-ukfuru; ngwẹja-nri; ngwẹja-mẹe; mẹwaru ngwẹja ọdo. Ngwẹja ono l'ọ ha bẹ aa-nọduje egwo lẹ mbọku, gbaru iya nụ. ");
INSERT INTO iqw_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Iphe ono l'ọ ha b'a gụfukpokwaaru ngwẹja kẹ mbọku ọtu-ume; bya agụfu iphe, unu anụje Ojejoje anụnu; gụfu lẹ madzụ akfụ ụgwo iphe, o kweru ụkwa iya; gụfu iphe unu chịru obu unu l'unu a-nụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘L'abalị ise l'ọnwa ẹsaa teke unu kpatatsụaru iphe, unu meberu l'alị; unu agbaaru Ojejoje ajị ono ujiku-ẹsaa. Mbọku abahụ iya; mẹ mbọku k'ẹsato iya bẹ unu a-tụtakota ume ozi. ");
INSERT INTO iqw_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Mbọku mbụ l'ajị ono bẹ unu a-hata akpụru oshi, katsụa mma l'akpụru oshi, unu wọtaru; gbuta igu; mẹ ẹkali-oshi, ẹkwo dụ nshinu; waa ẹkali-oshi wilo. Unu gwota iphe ono gude je anọdu Ojejoje, bụ Nchileke unu l'ifu tee ẹswa ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Unu gbajẹkwaru Ojejoje ajị ono ujiku ẹsaa afa l'afa. Ono bụ iphe, a tọru ọkpa iya t'e tsoje tsube l'ọgbo sweru l'ọgbo. Ọnwa, aa-gbajẹ iya bụ l'ọnwa k'ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Yọ bụru lẹ m̀kpù bẹ unu a-nọduje abalị ẹsaa ono; mbụ l'iphe bụ ndu a mụru lẹ Ízurẹlu a-nọdukotaje lẹ m̀kpù teke ono; ");
INSERT INTO iqw_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","k'ọphu iphe bụ ọgbo l'ụfutaru nụ a-maru lẹ ya meru tẹ ụnwu Ízurẹlu bua lẹ m̀kpù teke ono, ya shi lẹ Íjiputu dufuta ẹphe ono. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu.’ ” ");
INSERT INTO iqw_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Tọ dụ iya bụ; Mósisu abya atụko ajị, Ojejoje doberu kfukotaru ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Kfuru ndu Ízurẹlu t'ẹphe wotaru ngu ọkpobe manụ olivu, a tsụru l'ikwe, ee-yeje l'urọku ono; k'ọphu ọo-nọduje enwu mkpụrumkpuru. ");
INSERT INTO iqw_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Tẹ Érọnu yẹle ụnwu iya yeje ọku l'urọku ono l'ifu Ojejoje l'ime Ụlo-Ẹ́kwà Ndzuko ono; mbụ l'azụ ẹkwa phụ, e gude gebuta Okpoko Ekemu phụ. T'ẹphe mejekwa urọku ono t'o nwu mkpụrumkpuru; shita l'urẹnyashi jeye l'ụtsu. Tẹ ndu Ízurẹlu dobekwa ekemu-a tsube l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Tẹ Érọnu dozije ọku l'urọku ono l'eli iphe, eegvubeje urọku ono, e meru lẹ mkpọla-ododo ono; t'o nwuje Ojejoje l'ifu mkpụrumkpuru. ");
INSERT INTO iqw_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Gudeje ntụ akpe gheta ishi buredi iri l'ẹbo. L'ishi buredi lanụ bẹ ii-yeje ntụ akpe, jiru nkwo-ẹka, e keru ụzo iri wota uzi labụ. ");
INSERT INTO iqw_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Nggu eworu buredi ọbu doo ọkpa labụ l'eli teburu ono, e gude ọkpobe mkpọla-ododo mee ono dobe Ojejoje l'ifu. Ishi buredi ishingu l'ẹkalanu; ishi buredi ishingu ọphu l'ẹka iya ọphu. ");
INSERT INTO iqw_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nggu abya eworu ọkpobe ínsẹnsu doo l'ọkpa l'ọkpa; t'ọ bụru iphe, nọ-chiru ẹnya buredi ono; t'e gude iya gwooru Ojejoje ngwẹja-ọku. ");
INSERT INTO iqw_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Iphe bụ mbọku ọtu-ume, sweru esweswe bẹ Érọnu e-dozije iya l'ifu Ojejoje. Yọ bụru ndu Ízurẹlu bẹ ọo-nọdu emeru iya; t'ọ bụru ọgba-ndzụ, a-nọ gbururu jeyewaru. ");
INSERT INTO iqw_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","“Buredi ono bụ Érọnu yẹle ụnwu iya nwe iya. T'ẹphe nọdujekwa l'ẹke dụ nsọ taa ya; kẹ l'ọ dụ nsọ nshinu; bụru òkè iya nk'ẹphe lẹ ngwẹja, aakpọ ọku anụ Ojejoje jeye lẹ tutu yoyo.” ");
INSERT INTO iqw_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Yo nweru nwoke, nne iya bụ onye Ízurẹlu; nna iya abụru onye Íjiputu, ẹphe lẹ ndu Ízurẹlu yị. A nọnyaa; ọgu adaru yẹle onye Ízurẹlu ono l'ọdu ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Onye ono, nne iya bụ onye Ízurẹlu ono ekfubyishilahaa ẹpha Ojejoje. A kpụta iya kpụ-jeru Mósisu. Ẹpha nne nwata ono bụ Shelomitu, bụ nwatibe Dibiri l'ikfu Dánu. ");
INSERT INTO iqw_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","A kpụta iya je atụ-chia; kwabẹru Ojejoje t'ọ karu ẹphe iphe, bụ uche iya. ");
INSERT INTO iqw_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kpụta onye ono, kfubyiru ẹpha yẹbe Ojejoje ono kpụfu l'ọdu ndu Ízurẹlu. Tẹ iphe bụ ndu nụru teke ookfubyi ẹpha iya ono; byabẹ iya ẹka l'ishi; tẹ ọha wụ-lihu; tụ-gbua ya lẹ mkpuma. ");
INSERT INTO iqw_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kfuru ndu Ízurẹlu: L'iphe bụ onye kfubyiru ẹpha Nchileke bụkwa onye ono e-vuru iphe, tso iya nụ. ");
INSERT INTO iqw_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Iphe, bụ onye kfubyiru ẹpha Ojejoje bẹ ee-gbukwa egbugbu. Tẹ ọha zefutakwa tụ-gbua onye ọbu lẹ mkpuma. Onye ọbu -bụru onye laru alala; m'ọ bụ onye a mụru lẹ Ízurẹlu; o -kfubyia ẹpha yẹbe Ojejoje; t'e gbukwaa ya egbugbu. ");
INSERT INTO iqw_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Iphe, bụ onye gburu madzụ; t'e gbukwaa yẹbedua. ");
INSERT INTO iqw_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Iphe, bụ onye gburu anụmanu onye ọdo t'ọ kfụkwaa ụgwo iya. T'ọ bụkwaru ọphu nọ ndzụ bẹ oo-gude dochia ẹnya ọphu nwụhuru nụ. ");
INSERT INTO iqw_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Madzụ -yee ibe iya ọru l'ẹhu; t'e yekwaa ya phụ ọru l'ẹke o yeru onye ọphu. ");
INSERT INTO iqw_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Madzụ -gbajia madzụ ibe iya ọkpu; t'a gbajilatakwa iya phụ. Teke ọ bụ ẹnya b'o meru; yọ pyahu onye ọbu; t'e mekwaaphu tẹ nk'iya pyahụlata iya. Ọ -bụru eze b'o chikworu onye ono; t'e chikwolatakwa iya phụ. Ọ bụ ẹge o mekaberu onye ọdo iphe bụ ee-mekatabekwa iya phụ. ");
INSERT INTO iqw_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Onye gburu anụ madzụ ibe iya; t'ọ kfụkwaa ụgwo iya. Ọ -bụru l'ọo madzụ b'o gburu t'e gbukwaaphụ yẹbedua. ");
INSERT INTO iqw_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ekemu-a bẹ nọdu swiru ndu a mụru amụmu lẹ Ízurẹlu yẹle ndu laru iya alala. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu.” ");
INSERT INTO iqw_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mósisu ekfutsuaru iya ndu Ízurẹlu; ẹphe akpụta onye ono, kfubyiru ẹpha Nchileke ono; kpụfu l'ọdu ndu Ízurẹlu; je eworu iya tụ-gbua lẹ mkpuma. Ndu Ízurẹlu eshi ẹge ono mee iphe, Ojejoje tụru Mósisu ekemu t'ẹphe mee. ");
INSERT INTO iqw_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu l'eli Ugvu Sáyịnayi; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Kfuru ụnwu Ízurẹlu; sụ ẹphe: Teke unu bahụleruphu l'alị ono, ya abya unu anụnu ono; unu hajẹkwa-a alị ono t'ọ nọoru Ojejoje afa ọtuta-ume. ");
INSERT INTO iqw_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Unu mebeje iphe l'alị unu afa ishingu; unu akọchajee mgbo vayịnu unu akọcha afa ishingu; wọo akpụru iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","O -be l'afa k'ẹsaa; a haa alị ono t'ọ tụta ume. Ono bụ afa ọtuta-ume kẹ Ojejoje. Unu be emebekwa iphe l'alị unu afa ono; ọphu unu akọchakwa mgbo vayịnu unu. ");
INSERT INTO iqw_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Unu be ejejekwa ọkpata iphe, daru ẹda. Teke oshi vayịnu, ẹ te mekwadu emekwa mịru amịmi; unu ba awọtakwa iya. Ishi iya bụ l'afa ono bẹ alị ono atụta ume. ");
INSERT INTO iqw_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Iphe, alị mịtaru l'afa onanu, alị atụta ume ono a-bụru unu nri; bụru kẹ ndu ohu unu; mẹ kẹ ndu ozi, unu butaru ebuta; mẹ ndu laru alala, unu l'ẹphe bu. ");
INSERT INTO iqw_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ọ kwaphụ iphe shi l'alị ono a-bụru nri ụnwu elu unu; mẹ k'ụnwu anụ ẹgu, bu l'alị unu.” ");
INSERT INTO iqw_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Unu gụa afa ọtuta-ume gụta afa ẹsaa; mbụ afa ẹsaa ẹsaa ugbo ẹsaa. Afa ọtuta-ume ẹsaa ono bụ iphe, ọo-dụ bụ ụkporo afa labụ l'afa tetee. ");
INSERT INTO iqw_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ọnwa k'ẹsaa -dụlephu l'abalị iri, bụ iya bụ Eswe Ọkfu Ụgwo Ẹjo iphe; nggu ezia t'e gbua ụpyoku gude jedzuru l'alị unu. ");
INSERT INTO iqw_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Unu edoo afa k'ụkporo ẹbo l'iri nsọ; unu araa ya arara t'onyenọnu nweru onwiya l'alị ono gbaa mgburumgburu. Afa ono a-bụru unu afa eswe-ajị; teke iphe bụ onyenọnu e-nweru alị iya; lakfu ndibe iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Tẹ afa k'ụkporo ẹbo l'iri ono bụkwaru unu afa eswe-ajị. Unu be emebekwa iphe l'alị; ọphu unu 'ejejekwa ọkpata ọphu daru ẹda l'afa ono; m'ọ bụ ọphu mịtaru lẹ vayịnu, ẹ ta kọchadu akọcha. ");
INSERT INTO iqw_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Keshinu afa ono a-bụru unu afa eswe-ajị; unu dobekwa iya nsọ. Ọ bụ iphe, daru ẹda l'alị ono bẹ unu e-ri l'afa ono. ");
INSERT INTO iqw_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“O -rua l'afa eswe-ajị ono; t'onyenọnu je enweru alị iyare. ");
INSERT INTO iqw_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Ọ -bụru l'o nweru iphe, i reru madzụ ibe ngu; m'ọ kwanụ l'o nweru iphe, madzụ ibe ngu zụtaru ngu l'ẹka; unu mekwaa ya t'ẹ b'ọ dụ onye e-ri ibe iya uru. ");
INSERT INTO iqw_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Onye azụ onye ọdo alị a-nọdu azụ iya l'ele ẹnya l'afa ole, alị ọbu nọwaru k'ọphu a gbaru afa eswe-ajị. Onye ọphu ere erere elekwaaphu ẹnya l'afa ole, aa-nọfua tẹmanu yọ laphu iya azụ l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Teke bụ l'oo-te ẹnya tẹmanu yo rua afa ẹhu-ọtso-ẹna; aswa alị ọbu aha nshinu. Teke bụ l'ẹ too tedu ẹnya tẹmanu yo rua afa ẹhu-ọtso-ẹna ọdo; nggu egbuzita aswa iya; kẹ l'iphe, ọ kwata azụta ngu bụ iphe, ọo-kọta l'ẹke ono l'oge, phọduru nụ. ");
INSERT INTO iqw_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","T'ẹ b'ọ dụkwa onye ọphu e-rita ibe iya uru. Iphe, unu e-mejechia bụ t'unu tsụje Nchileke unu egvu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Ọo ya bụ t'unu mejekwa iphe, ya tọru ọkpa iya sụ t'e tsoje. Unu emeje iphe, ya tụru l'ekemu; k'ọphu unu e-buru l'alị ono; t'ẹ b'ọ dụ iphe, e-me unu. ");
INSERT INTO iqw_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ọo ya bụ; alị emehulahaa iphe, e meberu iya; unu erijilahaa ẹpho; buru iya lẹ domangu-rimangu. ");
INSERT INTO iqw_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Unu a-jịkwaru: ‘?Bụ ngụnu bẹ unu e-ri l'afa k'ẹsaa ọbu; m'o -nwedu iphe, unu meberu l'alị; to nwe iphe, unu a-kpata akpata?’ ");
INSERT INTO iqw_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","L'afa k'ishingu ono bẹ ya a-gọru ọnu-ọma iya nụ unu; k'ọphu alị ono e-mehu iphe, e-dzuru unu afa ẹto. ");
INSERT INTO iqw_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Teke o beru l'afa k'ẹsato; unu awata ọkobe iphe l'alị. Yọ bụru iphe, unu kọtahawaru bẹ unu a-nọdu eri jeye l'afa kẹ tete teke unu a-kpata iphe, unu meberu.” ");
INSERT INTO iqw_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“T'ẹ b'ọ dụkwa onye e-reje alị iya nre-lanụ; kẹ l'alị bụkwa yẹbedua nwe iya. Unubẹdua bụ abyabya bẹ unu byaru. Yọ bụru anụnu bẹ ya nụru iya unu t'unu buru. ");
INSERT INTO iqw_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","L'iphe, bụ alị unu l'ọ ha; unu hajẹkwaa alị, e reru erere t'onye ọdungu shi nweru iya nụ gbata iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Ọ -bụru lẹ nwunne ngu bẹ ụkpa guderu; k'ọphu o butaru alị iya ree; t'onye a-bya ọgbata alị ono bụkwaru onye yẹle iya bụ ọkpobe abụbu. ");
INSERT INTO iqw_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ọ -bụru l'onye ọbu te nwedu onye e-je ọgbata alị ono; yẹbedua emekochaa bya enweru iphe oo-gude gbata iya; ");
INSERT INTO iqw_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","t'ọ gbakọkwaa afa ole, swewaru nụ keshinu teke o reru iya; kfụa onye o reru alị ono ụgwo afa ọphu ẹ t'ọ kọdua ya; laphu azụ l'alị iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ọ -bụru l'onye ọbu ta madu ụzo, oo-shi gbafụta iya; tẹ alị ono, o reru ono nọdukwa l'ẹka onye zụru iya nụ jeye l'afa eswe-ajị. O -rua l'afa eswe-ajị; tẹ onye zụru iya nụ haa ya; tẹ onye ono, nwe iya nụ ono laphu azụ l'alị iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“O -nweru onye reru ụlo ebubu lẹ mkpụkpu, e gude ụpho-mkpuma; kpụ-phee mgburumgburu; b'o nwekwaru ike gbata iya l'afa ono, o reru iya ono. Ọ bụ l'afa ono bẹ ọo-gbata iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Teke bụ l'ẹ tọ gbatadu iya jeye afa agvụ; ọo ya bụ l'ụlo ono, nọ lẹ mkpụkpu, a kpụ-pheru mgburumgburu ono a-bụwaruru k'onye zụru iya nụ gbururu jeye. Ẹ ta natakwa iya ẹya l'afa eswe-ajị. ");
INSERT INTO iqw_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Obenu l'ụlo ndu ọphu nọgbaa lẹ mkpụkpu ndu ẹ te gudedu ụpho-mkpuma; kpụ-phee mgburumgburu bụ ẹge eemeje ọma ẹgu bẹ ee-meje iya. Yẹbedua bẹ aa-gbatajẹ agbata. O -rua l'afa eswe-ajị; onye zụru iya nụ akụfu iya ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“A -bya lẹ mkpụkpu kẹ ndu Lívayi; tẹ ndu Lívayi gbatajẹkwa ụlo, nọ iya nụ teke dụ ẹphe mma. ");
INSERT INTO iqw_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ọ -bụru l'onye Lívayi ta adụdu ike gbata ụlo, o reru lẹ mkpụkpu ndu Lívayi l'ẹka onye zụru iya nụ; o -rua l'afa eswe-ajị tẹ ụlo ono laphukwa iya azụ l'ẹka. Ishi iya abụru l'iphe bụ ụlo, nọ lẹ mkpụkpu ndu Lívayi bụkwa iphe ẹphe l'ẹke ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","T'ẹ b'ọ dụkwa iphe, e-me t'ẹphe ree alị ẹke ẹphe echeje atụru ẹphe; mbụ ọphu nọ lẹ mkpụkpu ẹphe; kẹ l'ono bụ òkè-iphe ẹphe gbururu jeye lẹ gbururu.” ");
INSERT INTO iqw_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Ọ -bụru l'onye Ízurẹlu ibe ngu bẹ ụkpa byaru; tọ dụhe ike ọnu onwiya nri; yejeru iya ẹka ẹge ono, eeyejeru onye laru alala; m'ọ bụ onye byaru abyabya ono; k'ọphu ọo-dụ ike buru l'obutobu unu ẹge o bu iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ba anatajẹkwa iya ọ-mụru-nwa. Tsụje-chia Nchileke ngu egvu; k'ọphu nwanna ngu ono a-dụ ike bunyabe ngu. ");
INSERT INTO iqw_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Be ejekwa iya ụgwo okpoga; sụ t'ọ tụkwaseru ngu iya iphe; ọphu i lekwa ẹnya uru lẹ nri, i reru iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu, bụ onye dufutaru unu l'alị Íjiputu tẹ ya nụ unu alị Kénanu; bụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Ọ-bụru l'onye Ízurẹlu ibe ngu, nggu l'iya bu obutobu bẹ ụkpa guderu; k'ọphu o woru onwiya ree ngu; be emekwa iya t'o jejeru ngu ozi l'ọ bụ ohu. ");
INSERT INTO iqw_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Dobechia ya l'ọ bụ onye i buru ozi; m'ọ bụ onye byaru abyabya; t'o jeeru ngu ozi ẹge ono jeye l'afa eswe-ajị. ");
INSERT INTO iqw_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","O -rua teke ono; nggu ahaa ya; haa jeye l'ụnwu iya; t'ọ lakfu ndibe ẹphe; lakfu òkè-iphe nna iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Lẹ keshinu ndu Ízurẹlu bụ ohu nk'iya, ya shi l'alị Íjiputu dufuta b'e te erekwe ẹphe t'ẹphe bụru ohu. ");
INSERT INTO iqw_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ba adụkwaru onye Ízurẹlu ibe ngu ẹhuka; nggu atsụjekwa Nchileke ngu egvu. ");
INSERT INTO iqw_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Ndu unu a-gbajẹ ohu; unwoke l'ụnwanyi; bụkwaru ndu ọhodo-a, nọ-pheru unu mgburumgburu-a. Ono kwa ndu unu a-gbajẹ ohu ndono. ");
INSERT INTO iqw_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Ndu ọdo, unu a-gbajẹfua ohu bụ ndu byaru abyabya, unu l'ẹphe tụko buru; m'ọ kwanụ ụnwu, ẹphe nọ l'alị unu mụshia. Unu -gbaa ẹphe ohu; unu enwewaruru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ndu onanu bẹ unu e-me t'ẹphe bụru òkè-iphe, unu ketaru ụnwu unu; t'ẹphe bụru ohu ẹphe gbururu jeyewaru. A -bya lẹ ndu nk'unu, bụ ụnwu Ízurẹlu; unu ba adụkwaru ẹphe ẹhuka. ");
INSERT INTO iqw_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Ọ -bụru l'onye laru alala; m'ọ bụ onye byaru abyabya, unu l'iya tụko buru nọnyaaru bya enweru iphe; onye Ízurẹlu ibe ngu yẹle iya bunyabe adaa ụkpa bya eworu onwiya ree onye ono, laru alala ono; m'ọ kwanụ l'o woru onwiya ree abụbu onye ono, laru alala ono; ");
INSERT INTO iqw_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","b'e nwelekwaru-a ike gbafụta iya. Onye abụbu iya nanụ nwekwaru ike gbafụta iya. ");
INSERT INTO iqw_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Tẹ nwunne nna onye ọbu; m'ọ bụ nwa nwunne nna iya; m'ọ bụ onye ọdo, ẹphe l'iya bụ abụbu jekwa je agbafụta iya. Ọ -bụru l'onye ọbu nọnyaaru bya enweru iphe k'ọphu ọo-dụ ike gbafụta onwiya; tẹ onye ọbu gbafụtakwa onwiya. ");
INSERT INTO iqw_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Tẹ yẹle onye gbaru iya ohu gbakọkwaa afa ole ọ dụ tsube l'afa, a gbaru iya ohu jeye l'afa eswe-ajị. T'e tsube l'iphe, onye o-gburu-mịta ejetaje l'ụboku; gbakọo okpoga afa, wuduru nụ; karu iya iphe, ọo-kfụ; gude gbata onwiya. ");
INSERT INTO iqw_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ọ -bụru l'afa, ghuduru nụ hakwadu nshinu; t'onye ono keta okpoga ono, o shi gude ree onwiya ono ọphu kwata ka nshinu kfụa gude gbata onwiya. ");
INSERT INTO iqw_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Teke ọ -bụkwanu l'afa, ghuduru nụ habewa t'o rua l'afa eswe-ajị; t'ẹphe l'iya gbakọo ya; t'ọ kfụa kẹ afa ole, ghuduru nụ; gbata onwiya. ");
INSERT INTO iqw_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","T'e mejekwa onye ono ẹge eemeje nwozi, e butaru ebuta afa l'afa. T'e letakwa ẹnya tẹ onye ono, ọ nọ l'ẹka ono ba dụkwaru iya ẹhuka. ");
INSERT INTO iqw_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Ọ -bụru l'ẹ te eshidu ẹge ono gbafụta iya; t'a hakwaa yẹle ụnwegirima iya m'o rulephu l'afa eswe-ajị. ");
INSERT INTO iqw_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ishi iya abụru lẹ ndu Ízurẹlu bụ ohu iya. Ẹphe bụ ohu iya, ya dufutaru lẹ Íjiputu. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu.” ");
INSERT INTO iqw_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","T'ẹ b'ọ dụkwa agwa; m'ọ bụ ntẹkpe, a pyịru apyịpyi; m'ọ bụ mkpuma, a kpọberu l'ọ bụ itso, unu e-dobe l'alị unu. T'ẹ b'ọ dụkwa mkpuma, a pyịru apyịpyi, unu ee-dobe l'alị unu; wata iya ọbaru ẹja. Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu. ");
INSERT INTO iqw_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Unu dobeje mbọku ọtu-ume iya iche; unu akwabẹje ụlo iya, dụ nsọ ugvu. Ọ kwa yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Ọ -bụru l'unu eme iphe, ya tụru ọkpa iya; bya edobe ekemu iya; l'eme iya ememe; ");
INSERT INTO iqw_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","bẹ ya a-nọdu achịru unu mini l'oruberu iya. Iphe, e meberu l'alị e-mehu emehu; oshi, nọ l'ẹgu amịshi nebyi l'oruberu iya. ");
INSERT INTO iqw_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Iphe a-nọdu emehuru unu nshinu; k'ọphu bụ l'unu a-nọdu etsu balị jeye; ògè ọwo akpụru vayịnu erua. Unu egude ọwo akpụru vayịnu jeye; ògè omebe iphe l'alị erua ọdo. Unu a-nọdu eri nri; l'eriji ẹpho; buru l'alị ono lẹ domangu-rimangu. ");
INSERT INTO iqw_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Ya e-me t'unu buru l'ẹhu-agu l'alị ono; k'ọphu bụ l'unu a-zẹ azẹe; tọ dụ onye eye unu egvu. Ya e-me t'ẹjo anụ ẹgu chịhu l'alị ono; ọphu ọgu ta byadụ bya ada l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Unu a-chị ndu ọhogu unu; gbushia ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Unu -dụ ise; unu achịa ụkporo madzụ ise. Teke unu dụ ụkporo ise; unu achịa ụnu ụkporo madzụ l'ise. Unu e-gude nkogo gbushigee ndu ọhogu unu. ");
INSERT INTO iqw_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Ya a-nọdu eleta unu ẹnya; mee unu t'unu zụ̀a azụ̀zù kabaa l'igwe. Ndzụ, unu l'iya gbaru bẹ ya e-me t'ọ ngụru angụru. ");
INSERT INTO iqw_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Unu a-nọduje eri iphe, unu kpataru jeye unu akpata k'ọphungu; k'ọphu bụ; a -nọnyaa; unu achịshilahaa akahụ iya; k'ọphu unu e-wobata k'ọphungu. ");
INSERT INTO iqw_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ya a-bya; unu l'iya eburu eburu; ọphu unu 'adụhedu iya oyi. ");
INSERT INTO iqw_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ya a-nọdu ejephe ejephe l'ẹke, unu nọ; bụru Nchileke unu; unu abụru ndibe iya. ");
INSERT INTO iqw_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke unu, bụ onye dufutaru unu l'alị Íjiputu; t'unu ba bụheru ohu ndu Íjiputu. Ya mebyiwaru ike ono, ẹphe shi gude mee t'unu bụru ohu ẹphe ono; shi ẹge ono mee unu t'unu phafụta ishi.” ");
INSERT INTO iqw_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ọ -bụru l'unu ta ngabẹduru iya nchị; unu te eme iphe, ya sụru tẹ unu meje l'ọ ha; ");
INSERT INTO iqw_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","mbụ; ọ -bụru l'unu ta gụbedu iphe, ya tọru ọkpa iya iphe; k'ọphu unu woru iphe, ya tụru l'ekemu mee; yọ bụru iphe-mmanu; unu te emeje iphe, ya sụru t'unu meje l'ọ ha; shi ẹge ono woru ndzụ, unu l'iya gbaru mebyia; ");
INSERT INTO iqw_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","bụkwa iphe, ya e-me unu ndọ-ọ: Ya e-me t'unu wata ọtsu egvu; ụkwaranta alọlahaa unu yẹle ẹjo ẹhu-ọku, e-woru unu ẹnya mebyishia; ndzụ unu alaa kẹ mmanu. Unu -kọbe iphe l'alị; yọ bụru iphe-mmanu; kẹ l'ọo ndu ọhogu unu e-ri iya. ");
INSERT INTO iqw_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ya a-swịnwuru unu ifu; ndu ọhogu unu emekputa unu l'ọgu. Ndu unu dụ ashị achịlahaa unu; unu agbalahaa ọso teke ẹ tọ dụdu onye achị unu. ");
INSERT INTO iqw_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ọ -bụru lẹ ya metsuaru unu ono; unu ta angaru iya nchị; bẹ ya e-me unu iphe, ha l'ọ bụ ono ugbo ẹsaa gude nụa unu aphụ k'iphe, dụ ẹji unu. ");
INSERT INTO iqw_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ya e-me t'unu kubuhu onwunu ekuku; mbụ mee akpamigwe, unu vu l'ishi t'ọ dụ l'ọ bụ ígwè; bya emee alị unu t'ọ dụ l'ọ bụ ope. ");
INSERT INTO iqw_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ike, unu gude kọo alị a-bụru unu kẹ mmanu; kẹ l'alị te nwedu iphe, oo-meta; tẹmanu bẹ oshi-ọmi, gvuru l'alị ono a-mị-buhu mebyi. ");
INSERT INTO iqw_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Ọ -bụru l'unu emekwaphu iphe, ya sụru t'unu be emejeshi; jịka l'unu ta angadụru iya nchị bẹ ya e-gude iphe-ẹhuka, ka iphe, dụ ẹji, unu meru ugbo ẹsaa nụa unu aphụ. ");
INSERT INTO iqw_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ya a-chịru anụ-ẹgu-ẹgbudu ye t'ọ bya eripyabe unu; t'ọ gbabẹ unu ẹka ụnwegirima unu; tụko elu unu tagbushia; mee; unu ta abahẹdu ishi; esu-ụzo unu adaburu ophorokpo. ");
INSERT INTO iqw_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“E -meebe unu iphe ono l'ọ ha; unu ta agbanwe; l'emekwaphu iphe, ya sụru t'unu be meshi; ");
INSERT INTO iqw_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","bẹ ya e-me unu iphe, ya ta g'emedu; mbụ gude iphe-ẹhuka, ka iphe, dụ ẹji, unu meru ugbo ẹsaa nụa unu aphụ. ");
INSERT INTO iqw_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ya a-ha tẹ ọgu dakfu unu; gude iya gwata unu ụgwo ọgba-ndzụ ono, unu mebyiru ono. Unu -dzukobelephu lẹ mkpụkpu unu; ya emee t'ẹjo iphe-ememe dakfu unu; shi ẹge ono woru unu yee ndu ọhogu unu l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ya a-nọchi unu ụzo nri; k'ọphu bụ l'ụnwanyi iri e-gudeje ite lanụ shia iphe. Ẹphe egude iphe, eegudeje atụ ẹra iphe keeru iya unu; unu -rigee ya; ẹpho te ji unu. ");
INSERT INTO iqw_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ọ -bụru lẹ mu metsuaru unu iphemiphe ọbule ono; unu emekwaphu iphe, ya sụru t'unu be eme; ");
INSERT INTO iqw_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","bẹ ya e-gude ẹhu-eghughu mee unu iphe, ya ta g'emedu unu; mbụ gude iphe-ẹhuka, ka iphe, dụ ẹji, unu meru ugbo ẹsaa nụa unu aphụ. ");
INSERT INTO iqw_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ono teke unu a-wata ori anụ ụnwu unu unwoke; mẹ anụ ụnwu unu ụnwanyi. ");
INSERT INTO iqw_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ya e-mebyishi ẹke unu agwajẹ nte; nwutsushia ẹnya-ngwẹja ẹke unu aakpọje ínsẹnsu ọku. Ya a-tụkwashi odzu unu l'eli nte unu, bụhukwaphu odzu l'onwiya. Unubẹdua adụ iya oyi. ");
INSERT INTO iqw_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ya e-me mkpụkpu unu t'ọ dabugbaaru ophorokpo. Ya emee ụlo unu, dụ nsọ t'ọ bụru okorobo ụlo. Teke ono bẹ mkpọ ngwẹja, unu gworu ta byadụ l'adụ iya mma. ");
INSERT INTO iqw_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Alị ono bẹ ya e-me t'ọ daburu ophorokpo; k'ọphu bụ lẹ ndu ọhogu unu, bụ ndu e-buchi iya nụ bẹ ọo-dụ biribiri. ");
INSERT INTO iqw_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ya a-tụka unu nanụ nanụ l'iphe bụ mbakeshi. Yọ bụru nkogo bẹ ya a-mịta gude tsoru unu. Alị unu bẹ ẹgbara a-kfụ. Iphe, bụ mkpụkpu unu l'ọ ha adaburu ochobo. ");
INSERT INTO iqw_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Teke ono bẹ ẹhu a-wata ọtso alị ono ẹna lẹ ya atụta ume; mbụ teke ono, ọ daburu ochobo ono. Unubẹdua anọdu l'alị ndu ọhogu unu ono. Teke ono bẹ alị ono a-nọdu ete ẹswa lẹ ya atụta ume. ");
INSERT INTO iqw_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Teke ono, alị ono daburu ochobo ono bụ ume bẹ ọotuta; kẹ l'ẹ to shidu atụtajekwadu ume l'afa ọtuta-ume unu teke unu shi buru iya. ");
INSERT INTO iqw_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“A bya lẹ ndu ọphu wuduru nụ l'unu; ndu onanu bẹ ya e-me tẹ meji tọfu ẹphe l'alị ndu ọhogu ẹphe; k'ọphu bụ lẹ mkpẹkwo -mee ụkporo; ẹphe eye ọkpa l'ọso l'ọ bụ ndu e gude nkogo l'achị. Ẹphe a-nọdu ada l'ẹ ba dụ onye achị ẹphe ọso. ");
INSERT INTO iqw_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ẹphe e-vukotaje ibe ẹphe daa l'ọ bụ ndu e gude nkogo l'achị; l'ẹ b'ọ dụ onye achị ẹphe. T'ọ bụhe l'unu a-dụkwadu ike ovudo ndu ọhogu unu l'ifu. ");
INSERT INTO iqw_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Unu a-nwụshihu l'alị ndu ọhodo. Yọ bụru alị ndu ọhogu unu e-ri unu ishi. ");
INSERT INTO iqw_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Nwa ndu ọphu phọduru nụ l'unu a-nọdu eyifu eyifu l'alị ndu ọhogu unu. Yọ bụru iphe, dụ ẹji, ẹphe meshiru; mẹ ọphu nna ẹphe oche phẹ meshiru bẹ ẹphe e-gude yifu ono. ");
INSERT INTO iqw_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ọ -bụru l'ẹphe kọshiru iphe, dụ ẹji, ẹphe meshiru yẹle iphe, dụ ẹji, nna phẹ oche meshiru; mẹ emeswe, ẹphe mesweshiru iya yẹle ememe, ẹphe emeje iphe, ya sụru t'ẹphe be meshi, ");
INSERT INTO iqw_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","bụ iphe, meru; ya emee ẹphe iphe, ya t'e g'emedu ẹphe; chịru ẹphe je eye l'alị ndu ọhogu ẹphe. Ọ -bụru l'ẹjo ọkpoma ẹphe ono bẹ ẹphe e-wozita alị; bya akfụa ụgwo iphe, dụ ẹji, ẹphe meshiru; ");
INSERT INTO iqw_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","bẹ ya a-nyatakwa-a ndzụ yẹle Jékọpu gbaru; nyata ndzụ yẹle Áyizaku gbaru; nyata ndzụ yẹle Ébirihamu gbaru; nyatakwaphụ alị ono. ");
INSERT INTO iqw_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Obenu l'alị ono bẹ ẹphe a-ha t'ọ daburu ochobo; gude ẹhu-ọtso-ẹna tụta ume. Ono teke ẹphe a-kfụ ụgwo iphe, dụ ẹji, ẹphe meru; kẹ l'ẹ tọ dụdu iphe, ẹphe gụberu iphe, ya tụru l'ekemu; wafụa l'ẹphe woru iphe, ya tọru ọkpa iya sụ t'e tsoje mee; yọ dụkota oyi. ");
INSERT INTO iqw_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ọle ẹge ọ dụ; ẹge ọ dụ bẹ teke ono, ẹphe a-nọdu l'alị ndu ọhogu ẹphe ono bẹ ya ta ajịkakwa ẹphe; ọphu ya edobekwa ẹphe l'ọ bụ ndu dụ oyi; kẹ tẹ ya mebyishikota ẹphe l'ẹphe ha; mebyia ndzụ, ẹphe l'iya gbaru; kẹ l'ọ kwa yẹbedua bụ Ojejoje; bya abụru Nchileke ẹphe. ");
INSERT INTO iqw_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ọle ya e-gude okfu ẹhu ẹphe nyata ndzụ yẹle ndu ndiche ẹphe gbaru; mbụ ndu ono, ya shi l'alị Íjiputu dufuta; iphe bụ mbakeshi egude ẹnya ẹphe phụ iya ono; k'ọphu ya a-bụru Nchileke ẹphe. Ọ kwa yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ono kwa iphe, Ojejoje tọru ọkpa iya ndono; mẹ iphe, ọ tụru l'ekemu; waa ekemu, o shi l'ẹka Mósisu tụaru ndu Ízurẹlu l'eli Ugvu Sáyịnayi. ");
INSERT INTO iqw_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Tọ dụ iya bụ; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Kfuaru ụnwu Ízurẹlu; sụ ẹphe: “Ọ -bụru lẹ madzụ riru angụ lẹ ya e-woru madzụ nụ Ojejoje; t'ọ kfụkwaa ụgwo l'ishi onye ọbu. ");
INSERT INTO iqw_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","“Ọ -bụru nwoke, nọwaru tsube l'ụkporo afa rua ụkporo afa ẹto; bụ ụkporo mkpọla-ọcha ẹbo lẹ mkpọla-ọcha iri bẹ aa-kfụ l'ishi iya. T'ọ bụkwaru iphe eegudeje átụ̀ ẹra iphe l'eze-ụlo Nchileke b'ee-gude tụ̀a ya. ");
INSERT INTO iqw_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","“Ọ -bụru nwanyi; bụ ụkporo mkpọla-ọcha lẹ mkpọla-ọcha iri bẹ aa-kfụ l'ishi iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","“Ọ -bụru nwokoro, nọru tsube l'afa ise jeye l'ụkporo afa; bụ ụkporo mkpọla-ọcha bẹ aa-kfụ l'ishi iya. Ọ -bụru nwanyi; bụ mkpọla-ọcha iri. ");
INSERT INTO iqw_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“Ọ -bụru nwata nwoke, nọru tsube l'ọnwa lanụ jeye l'afa ise; bu mkpọla-ọcha ise bẹ aa-kfụ l'ishi iya. Ọ -bụru nwata nwanyi; bụ mkpọla-ọcha ẹto. ");
INSERT INTO iqw_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“Nwoke, kariwaru ụkporo afa ẹto bụ mkpọla-ọcha iri l'ise bẹ aa-kfụ l'ishi iya. Teke ọ bụ nwanyi; bụ mkpọla-ọcha iri. ");
INSERT INTO iqw_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Ọ -bụru l'onye ono, riburu angụ ono akpa nri; k'ọphu bụ l'ẹ tọ dụdu ike ọkfu iphe, a sụru t'ọ kfụa; t'o duru onye ọbu, o riru angụ iya ọbu; dujeru onye achịjeru Nchileke ẹja. Onye ono, achịjeru Nchileke ẹja ono elee ya ẹnya; kọoru iya iphe, ọo-kfụ. T'ọ bụru ẹge ike onye ono, riburu angụ ono ha b'ee-gburu iya t'ọ kfụa. ");
INSERT INTO iqw_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Ọ -bụru l'ọo anụ bẹ madzụ riburu nte lẹ ya a-nụ Ojejoje; mbụ anụ, gbaru iya nụ; iphe, bụ anụ, a nụru Ojejoje ẹge ono dụkotaakwa nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","T'ẹ b'o wotakwa anụ ọdo dochia ẹnya iya. T'ẹ b'o wotakwa anụ ọdo ka ẹji; m'ọ bụ ọphu ka mma gude gbanweta anụ onanu, o riburu angụ lẹ ya a-nụ ono. Ọ -bụru l'o gude anụ ọdo gbanweta iya bẹ anụ ọphu o gude gbanweta yẹle anụ, o jeru agbanweta tụkookwa bụru anụ, dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Obenu; ọ -bụru l'iphe, o riburu angụ lẹ ya a-nụ bụ anụ, aasọ nsọ; mbụ anụ ọphu e tee gudejedu egworu Ojejoje ẹja; t'a kpụtakwa anụ ọbu kpụ-jeru onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","T'onye ono, achịjeru Nchileke ẹja ono lee ya ẹnya; maru m'ọ dụ mma; t'ẹ tọ dụdu. Ọ bụ iphe onye ono, achịjeru Nchileke ẹja ono sụkpeleruphu t'ọ kfụa bẹ ọo-kfụ. ");
INSERT INTO iqw_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ọ -bụru l'onye nwe iya nụ b'ọ dụ t'ọ gbata iya; tẹ onye ono kee aswa iya ụzo ise; wota òkè lanụ tụkwase l'aswa iya kfụa; gude gbata iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Ọ -bụru lẹ madzụ woru ụlo iya nụ t'ọ dụru Ojejoje nsọ; bụkwa onye achịjeru Nchileke ẹja e-kfu mẹ ụlo ono: ?ọ dụ mma; t'ẹ tọ dụdu. Ọ bụ iphe, onye achịjeru Nchileke ẹja sụru l'ọo aswa iya; bụ aswa iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ọ -bụru l'onye ono, doberu Ojejoje ụlo ono nsọ ono b'ọ dụ t'ọ gbata iya; tẹ onye ọbu kee aswa iya ụzo ise; yekobe l'aswa iya kfụa; ụlo ọbu abụru nk'iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Ọ -bụru lẹ madzụ butaru alị iya nụ t'ọ bụru kẹ Ojejoje; ẹge e-gude maru iphe, bụ aswa iya bụ ẹge iphe, aa-kọbe l'alị ono habe nshinu. Alị, aa-kọ balị, jiru nkwo-ẹka iri bẹ aswa iya bụ ụkporo mkpọla-ọcha ẹbo lẹ mkpọla-ọcha iri. ");
INSERT INTO iqw_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ọ -bụru l'ọo afa eswe-ajị b'ọ nụru alị iya t'ọ bụru kẹ Ojejoje ọbu; bụlephu iphe, a sụru t'a kfụa bẹ aa-kfụ. ");
INSERT INTO iqw_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ọle; ọ -bụru l'afa eswe-ajị swewaru; b'o ribuderu angụ lẹ ya e-woru alị ono doberu Nchileke nsọ; tẹ onye achịjeru Nchileke ẹja gụa afa ole, phọduru nụ; tẹmanu yo rua l'afa eswe-ajị ọdo; shi ẹge ono karu onye ono iphe, aswa iya bụ. Ọo ya bụ l'ee-gbubota iphe l'iphe, a sụru t'ọ kfụa. ");
INSERT INTO iqw_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ọ -bụru l'onye woru alị ono doberu Nchileke nsọ b'ọ dụ t'ọ gbata iya; t'o kekwaa aswa iya ụzo ise; woru òkè lanụ yekobe l'aswa iya; kfụa gude gbata iya. O metsua ya ẹge ono; alị ono abụwaruru nk'iya ẹge o shi bụru iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ọle; ọ -bụru l'onye ono ta gbatadu alị ono; woru iya ree onye ọdo; bẹ alị ọbu kwaakwaru. Ẹ ta gbatahẹkwa iya ọdo. ");
INSERT INTO iqw_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","O -rulephu l'afa eswe-ajị; bẹ alị ono a-dụru Ojejoje nsọ. Yọ bụru ndu achịjeru Nchileke ẹja b'ọo-nọdu l'ẹka; keshinu ọ bụ alị, e dobehawaru Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Ọ -nweru onye riburu angụ ọnu Ojejoje alị, ọ zụru azụzu, ẹ-ta bụdu alị, shi l'ẹnya ikfu ẹphe; ");
INSERT INTO iqw_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","tẹ onye achịjeru Nchileke ẹja gụa afa ole, phọduru nụ; tẹmanu yo rua l'afa eswe-ajị; shi ẹge ono karu onye ono iphe, aswa iya bụ. Ọ bụ mbọku ono bẹ onye ono a-kfụ aswa iya t'ọ bụru iphe, dụru Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","O -rua l'afa eswe-ajị; tẹ alị ono laphu azụ l'ẹka onye reru iya nụ; mbụ onye alị ono bụ nk'iya gẹdegede. ");
INSERT INTO iqw_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“T'iphe bụ aswa, aakfụ akfụkfu bụkwaru ọphu ha l'ọ bụ k'eze-ụlo Nchileke. Mkpọla-ọcha ono b'e -jeshia ya ebubu; e buta iya ụkporo. ");
INSERT INTO iqw_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“T'ẹ b'ọ dụkwa onye a-kpụtaje anụ, vuru ụzo waa nne iya ọswa; bya anụ t'e doberu Nchileke nsọ; kẹ l'anụ, vuru ụzo waa nne iya ọswa bụhaakwa kẹ Ojejoje; m'ọ bụ eswi; m'ọ bụ atụru. L'ẹphe ha tụko bụru kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ọ -bụru anụ, aasọ nsọ; tẹ onye ono kfụa iphe, a sụru t'ọ kfụa gude gbata iya. Yo kekwaaphu aswa iya ụzo ise; wota òkè lanụ yekobe l'aswa iya ono kfụa. Teke ọ bụ l'ẹ tọo dụdu ike agbata iya; t'e ree ya onye ọdo iphe, a sụru l'ọ bụ aswa iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Ọle; t'ẹ b'ọ dụkwa iphe, madzụ gọru nụ Ojejoje, ee-re erere; m'ọ kwanụ gbata iya agbata. Mbụ iphe, shi l'iphe, madzụ nweru enweru; m'ọ bụ madzụ; m'ọ bụ anụ; m'ọ bụ alị, bụ iya nwe iya. Iphemiphe, a gọru nụ Ojejoje dụkwaru Ojejoje nsọ nshinu. ");
INSERT INTO iqw_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","T'ẹ b'ọ dụkwa onye a gọru nụ Ojejoje, aa-gbata agbata. T'e gbukwaa onye ọbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Okè lanụ l'ụzo iri l'iphe, e metaru l'alị; m'o -ruhuru; ọ bụru nebyi iphe, a kpataru l'iphe, a kọru l'alị; m'ọ bụ akpụru, oshi mịtaru; bụkotakwa kẹ Ojejoje. Ọ dụru Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","O -nweru onye eme tẹ ya gbata òkè lanụ l'ụzo iri nk'iya; tẹ onye ono kekwaa iphe, bụ aswa iya ụzo ise; wota òkè lanụ yekobe l'aswa iya ono gude gbata iya. ");
INSERT INTO iqw_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ụzo lanụ l'ụzo iri, shi l'eswi; mẹ l'eghu; mẹ l'atụru; mẹkpo anụ k'iri l'iphe, bụ anụ, onye eche elu gude mgbọro iya gụta a-dụkotakwaru Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","T'ẹ b'o jejekwa iya enyocha kẹ woo: ?a maru; ọ dụa mma; t'ẹ tọ dụdu. Ọphu ọ gbakwa iya inwe. A -gbakwanua ya inwe agbagba; bẹ onanu yẹle ọphu e gude angbanweta iya tụkookwa bụru iphe, dụ nsọ. Ọphu a byadụ bya agbata iya agbata.” ");
INSERT INTO iqw_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ono bụ ekemu, Ojejoje tụshiru nụ Mósisu lẹ Ugvu Sáyịnayi t'o je anụ ndu Ízurẹlu.");
INSERT INTO iqw_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","L'abalị mbụ l'ọnwa k'ẹbo l'afa, kwe ndu Ízurẹlu afa ẹbo k'ọphu ẹphe shi l'alị Íjiputu lụfuta; bẹ Ojejoje kfuru yeru Mósisu lẹ Ụlo-Ẹ́kwà Ndzuko ndu Ízurẹlu l'echi-ẹgu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Gụa ndu Ízurẹlu l'ẹphe ha ọgu. Gụa ẹphe l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. Gụa unwoke l'ẹphe ha; nggu edeshikota ẹpha ẹphe nanụ nanụ. ");
INSERT INTO iqw_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Nggụbe Mósisu; nggu lẹ Érọnu; unu tụko iphe, bụ unwoke lẹ Ízurẹlu gụkota; mbụ unwoke ndu nọwaru ụkporo afa m'ọ kwanụ karia; bya abụru ndu a-dụ ike oje ọgu. ");
INSERT INTO iqw_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Unu shi l'iphe, bụ ikfu ono l'ọ ha fọta onye nwoke lanụ t'o yetajeru unu ẹka. Ndu unu a-fọta bụ ndu bụ ishi l'ụnwunna ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ọwaa bụ ẹpha ndu unu a-fọta t'ẹphe yeru unu ẹka: “Onye unu a-fọta l'ikfu Rúbẹnu bụ Elizuru Shediyọ. ");
INSERT INTO iqw_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","“Onye unu a-fọta l'ikfu Símiyọnu abụru Shelumẹlu Zurishadayi. ");
INSERT INTO iqw_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","“Onye unu a-fọta l'ikfu Júda bụ Náshọnu Amínadabu. ");
INSERT INTO iqw_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","“Onye unu a-fọta l'ikfu Ísaka abụru Netanẹlu Zuwa. ");
INSERT INTO iqw_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","“Onye unu a-fọta l'ikfu Zébulọnu bụ Eliyabu Helọnu. ");
INSERT INTO iqw_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","“A -bya l'ikfu k'ụnwu Jósẹfu; onye unu a-fọta l'ikfu Ífuremu bụ Elishama Amihudu. Unu afọta Gamalẹlu Pedazọ l'ikfu Manásẹ. ");
INSERT INTO iqw_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","“Onye unu a-fọta l'ikfu Bénjaminu bụ Abidanu Gidiyọ́ni. ");
INSERT INTO iqw_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","“Onye unu a-fọta l'ikfu Dánu abụru Ahiyeza Amishadayi. ");
INSERT INTO iqw_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","“Onye unu a-fọta l'ikfu Ásha bụ Pagẹlu Ọkuranu. ");
INSERT INTO iqw_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","“Onye unu a-fọta l'ikfu Gádu abụru Ẹliyasafu Diyuwẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","“Onye unu a-fọta l'ikfu Náfutali bụ Ahira Enanu.” ");
INSERT INTO iqw_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ndu ono bẹ bụ unwoke, a fọtaru lẹ Ízurẹlu gbaa mgburumgburu. Ẹphe bụkota ndu ishi l'ikfu ndiche ẹphe; bya abụgbaaru ishi l'ẹnya ụnwunna, nọ lẹ Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mósisu yẹle Érọnu abya achịta ndu ono, a gụshiru ono. ");
INSERT INTO iqw_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Yo rua l'abalị mbụ l'ọnwa k'ẹbo ono; ẹphe ekua ndu Ízurẹlu l'ẹphe ha; deshia ẹpha ẹphe l'ẹkwo. Ẹphe deshiru iya l'ikfu l'ikfu; mẹ l'ụnwunna ụnwunna. Iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru b'e dekotaru ẹpha ẹphe nanụ nanụ; ");
INSERT INTO iqw_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ẹge ono, Ojejoje sụru Mósisu t'o mee ya ono. Yọ bụru iya bụ lẹ Mósisu agụa ndu Ízurẹlu ọgu l'echi-ẹgu Sáyịnayi. ");
INSERT INTO iqw_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","A -bya l'ikfu Rúbẹnu, bụ ọkpara Ízurẹlu; iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru; mbụ ndu a-dụ ike oje ọgu b'a gụru; deshikota ẹpha ẹphe nanụ nanụ. E deshiru iya l'ikfu l'ikfu; deshikwaa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Iphe, a gụtaru l'ikfu Rúbẹnu bụ ụkporo ụnu madzụ ise l'ụnu iri l'ishingu l'ụkporo ụmadzu ise. ");
INSERT INTO iqw_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","L'ikfu Símiyọnu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe nanụ nanụ l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ndu a gụtaru l'ikfu Símiyọnu dụ ụkporo ụnu madzụ ẹsaa l'ụnu ẹsato l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","L'ikfu Gádu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe nanụ nanụ l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwaa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ndu a gụtaru l'ikfu Gádu dụ ụkporo ụnu madzụ ise l'ụnu iri l'ẹno l'ụkporo madzụ ẹbo l'iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","L'ikfu Júda b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe nanụ nanụ l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ndu a gụtaru l'ikfu Júda dụ ụkporo ụnu madzụ tete l'ụnu ishingu l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","L'ikfu Ísaka b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ndu a gụtaru l'ikfu Ísaka dụ ụkporo ụnu madzụ ishingu l'ụnu madzụ iri l'ishingu. ");
INSERT INTO iqw_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","L'ikfu Zébulọnu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ndu a gụtaru l'ikfu Zébulọnu dụ ụkporo ụnu madzụ ẹsaa l'ụnu ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","A -bya l'ikfu Jósẹfu; mbụ anma Ífuremu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ndu a gụtaru l'ikfu Ífuremu dụ ụnu madzụ ụkporo ise l'ụnu lanụ l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Anma Manásẹ b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ndu a gụtaru l'ikfu Manásẹ dụ ụkporo ụnu madzụ ẹno l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","A -bya l'ikfu Bénjaminu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu dzuwaru oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ndu a gụtaru l'ikfu Bénjaminu dụ ụkporo ụnu madzụ ẹno l'ụnu madzụ ẹsato l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","L'ikfu Dánu b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu dzuwaru oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ndu a gụtaru l'ikfu Dánu dụ ụkporo ụnu madzụ ẹsaa l'ụnu iri l'ishingu l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","L'ikfu Ásha b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ndu a gụtaru l'ikfu Ásha dụ ụkporo ụnu madzụ ise l'ụnu madzụ ẹto l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","L'ikfu Náfutali b'a gụkotaru iphe, bụ unwoke, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike oje ọgu; bya edeshia ẹpha ẹphe l'ẹkwo. E deshiru iya l'ikfu l'ikfu; deshikwa ya phụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ndu a gụtaru l'ikfu Náfutali dụ ụkporo ụnu madzụ ishingu l'ụnu madzụ iri l'ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ndu ono bẹ bụ ndu Mósisu yẹle Érọnu gụru ọgu. Ndu yetaru ẹphe ẹka gụa ọgu ono bụ ndu ishi ndu Ízurẹlu ụmadzu iri l'ẹbo ono, nọ-chigbaaru ẹnya ụnwunna ẹphe nanụ nanụ ono. ");
INSERT INTO iqw_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Iphe, bụ unwoke Ízurẹlu l'ẹphe ha, nọwaru ụkporo afa kwasẹru, bụ ndu a-dụ ike ojeru ndu Ízurẹlu ọgu b'a gụkotaru l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Mkpakọ iphe, ẹphe dụ l'ẹphe ha bụ ụkporo ụnu madzụ ụkporo ugbo ẹto l'ụkporo ugbo iri l'ise; l'ụnu ẹsato; l'ụkporo madzụ iri l'ẹsaa l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ikfu Lívayi b'ẹ ta gụdu teke a gụru ndu Ízurẹlu ndu ọphu. ");
INSERT INTO iqw_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ishi iya abụru lẹ Ojejoje sụru Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“T'ẹ b'ọ gụkwa ndu ikfu Lívayi; ọphu ọ gụkwa ẹphe teke ọo-nọdu agụ ndu Ízurẹlu ndu ọphu. ");
INSERT INTO iqw_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Iphe, oo-mechia bụ t'ọ fọta ndu Lívayi ono t'ẹphe letaje ụlo-ẹ́kwà, eedobeje ẹkwo-ekemu Nchileke ẹnya; t'ẹphe letaje iphe nọ iya nụ ẹnya; mẹ iphe bụ iphe, anọje l'ụlo-ẹ́kwà ono. Ọ bụ ẹphe a-nọduje apa ụlo-ẹ́kwà ono; mẹ iphe, bụ iphe, nọ iya nụ. Yọ bụru ẹphe a-nọdu eleta iya ẹnya; ẹphe e-gudeje ụlo-ẹ́kwà nk'ẹphe kpọ-phee ụlo-ẹ́kwà ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Iphe, bụ teke ụlo-ẹ́kwà ono abya atụgbu; t'ọ bụru ndu Lívayi a-fọ-tsutaje iya. Iphe, bụ teke aakpọbe iya akpọbe; t'ọ bụkwaruphu ndu Lívayi a-kpọbe iya. Onye ọdo mmanu, jekfuberu iya ntse; bẹ ee-gbu egbugbu. ");
INSERT INTO iqw_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Ndu Ízurẹlu a-kpọbetsua ụlo-ẹ́kwà ẹphe l'ọkpa l'ọkpa l'ọdu ndu Ízurẹlu ono. Onye, nọnu a-kpọbeje nk'iya; t'ọ gbakfuru lẹ kẹ ndu ikfu iya; gbakfukwaruphu l'ẹ́kwà-ọhubama kẹ ndu ikfu iya. ");
INSERT INTO iqw_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Obenu lẹ ndu Lívayi bẹ e-gude ụlo-ẹ́kwà nk'ẹphe kpọ-pheta ụlo-ẹ́kwà ono, eedobeje ẹkwo-ekemu Nchileke ono mgburumgburu; k'ọphu Nchileke ẹ-ta atụ-koshidu edzudzu ọha Ízurẹlu oke ẹhu-eghughu iya. Ọ bụ ndu Lívayi a-nọdu eleta ụlo-ẹ́kwà ẹke eedobeje ẹkwo-ekemu Nchileke ono ẹnya.” ");
INSERT INTO iqw_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Yọ bụru ẹge ono, Ojejoje sụru Mósisu t'e mee ya ono bẹ ndu Ízurẹlu meru iya l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ojejoje abya ekfuru yeru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Tẹ ndu Ízurẹlu kpọo ụlo-ẹ́kwà ẹphe t'ọ nọ-phee Ụlo-Ẹ́kwà Ndzuko ono mgburumgburu. Onyenọnu a-kpọbe nk'iya l'ẹke ndu ikfu nk'iya iya nọ; dobe iya ẹkwa-ọhubama, e gude maru ndu ọnu-ụlo ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","L'ụzo ẹnyanwu-ahata; bụ ndu ikfu Júda a-kpọ iya ụlo-ẹ́kwà nk'ẹphe l'ọnu-ụlo ọnu-ụlo. Onye bụ ishi kẹ ndu Júda bụ Náshọnu Amínadabu. ");
INSERT INTO iqw_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ndu a gụtaru l'ikfu Júda ono dụ ụkporo ụnu madzụ tete l'ụnu madzụ ishingu l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“Ndu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsota ẹphe bụ ndu ikfu kẹ Ísaka. Onye bụ ishi l'ikfu kẹ Ísaka bụ Netanẹlu Zuwa. ");
INSERT INTO iqw_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ndu a gụtaru l'ikfu Ísaka dụ ụkporo ụnu madzụ ishingu l'ụkporo madzụ iri l'ishingu. ");
INSERT INTO iqw_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“Ndu ọdo, a-kpọbe nk'ẹphe tsota ẹphe bụ ndu ikfu Zébulọnu. Onye bụ ishi l'ikfu Zébulọnu bụ Eliyabu Helọnu. ");
INSERT INTO iqw_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ndu a gụtaru l'ikfu Zébulọnu dụ ụkporo ụnu madzụ ẹsaa l'ụnu ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“Ikfu ono, a fọtaru t'ẹphe lẹ ndu ikfu Júda kpọnyabe ụlo-ẹ́kwà ẹphe l'ọnu-ụlo ọnu-ụlo ono; bẹ kpakọru dụ ụkporo ụnu madzụ ugbo ụkporo l'ụnu madzụ ishingu. Ọ bụ ẹphebedua e-vuru ụzo tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“A bya l'ụzo ọhuda; ọ bụ ndu ikfu Rúbẹnu a-kpọ ụlo-ẹ́kwà nk'ẹphe laa ụzo ọhuda. Ẹphe a-kpọ iya l'ọnu-ụlo ọnu-ụlo. Onye bụ ishi l'ikfu Rúbẹnu bụ Elizuru Shediyọ. ");
INSERT INTO iqw_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ndu a gụtaru l'ikfu Rúbenu dụ ụkporo ụnu madzụ ise l'ụnu iri l'ishingu l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“Ndu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsota ndu ikfu Rúbẹnu bụ ndu ikfu Símiyọnu. Onye bụ ishi l'ikfu Símiyọnu bụ Shelumẹlu Zurishadayi. ");
INSERT INTO iqw_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ndu a gụtaru l'ikfu Símiyọnu dụ ụkporo ụnu madzụ ẹsaa l'ụnu ẹsato l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“Ndu ọphu a-kpọbe nk'ẹphe tsota ẹphe bụ ndu ikfu Gádu. Onye bụ ishi l'ikfu Gádu bụ Ẹliyasafu Duwẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ndu a gụtaru l'ikfu Gadụ dụ ụkporo ụnu madzụ ise l'ụnu iri l'ẹno l'ụkporo madzụ ẹbo l'iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“Ikfu ono, a fọtaru t'ẹphe l'ikfu Rúbẹnu kpọnyabe ụlo-ẹ́kwà ẹphe l'ọnu-ụlo ọnu-ụlo ẹphe ono; bẹ kpakọru dụ ụkporo ụnu madzụ iri l'ẹsato l'ụnu iri l'ụkporo madzụ iri l'ẹbo l'ụmadzu iri. Ọ bụ ẹphebedua bụ ndu k'ẹbo, a-gbalihuje wata ije. ");
INSERT INTO iqw_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Ndu Lívayi e-vuta Ụlo-Ẹ́kwà Ndzuko nọdu ndu ikfu ono l'echi; tụgbua. Ọ bụ ẹge ẹphe kpọru ụlo-ẹ́kwà ẹphe; bụ ẹge ẹphe e-gudeje gbeshi: tụgbua; ikfu, nọnu; anọdu l'ẹge ẹphe tso. ");
INSERT INTO iqw_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Ndu ọphu a-kpọbe ụlo-ẹ́kwà nk'ẹphe l'ụzo ẹnyanwu-arịba bụ ndu ikfu Ífuremu. Ẹphe a-kpọ iya l'ọnu-ụlo ọnu-ụlo. Onye bụ ishi l'ikfu Ífuremu bụ Elishama Amihudu. ");
INSERT INTO iqw_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ndu a gụtaru l'ikfu Ífuremu dụ ụkporo ụnu madzụ ise; l'ụkporo ụnu madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“Ndu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsota ikfu Ífuremu bụ ndu ikfu Manásẹ. Onye bụ ishi l'ikfu Manásẹ bụ Gamalẹlu Pedazọ. ");
INSERT INTO iqw_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ndu a gụtaru l'ikfu Manásẹ dụ ụkporo ụnu madzụ ẹno; l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“Ndu ọphu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsobe ẹphe bụ ndu ikfu Bénjaminu. Onye bụ ishi l'ikfu Bénjaminu bụ Abidanu Gidiyọ́ni. ");
INSERT INTO iqw_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ndu a gụtaru l'ikfu Bénjaminu dụ ụkporo ụnu madzụ ẹno; l'ụnu ẹsato l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“Ikfu ono, a fọtaru t'ẹphe lẹ ndu ikfu Ífuremu kpọnyabe ụlo-ẹ́kwà ẹphe l'ọnu-ụlo ọnu-ụlo ẹphe ono; kpakọru dụ ụkporo ụnu madzụ iri l'ẹto l'ụnu iri. Ọ bụ ẹphebedua bụ ndu k'ẹto; mẹ ẹphe tụgbua ije. ");
INSERT INTO iqw_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Ndu ọphu a-kpọbe ụlo-ẹ́kwà nk'ẹphe l'ụzo isheli bụ ndu ikfu Dánu. Ẹphe a-kpọ iya l'ọnu-ụlo ọnu-ụlo. Onye bụ ishi l'ikfu Dánu bụ Ahiyeza Amishadayi. ");
INSERT INTO iqw_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ndu a gụtaru l'ikfu Danụ dụ ụkporo ụnu madzụ ẹsaa; l'ụnu iri l'ishingu l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“Ndu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsota ikfu Dánu bụ ikfu Ásha. Onye bụ ishi l'ikfu Ásha bụ Pagẹlu Ọkuranu. ");
INSERT INTO iqw_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ndu a gụtaru l'ikfu Ásha dụ ụkporo ụnu madzụ ise; l'ụnu ẹto l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“Ndu ọphu a-kpọbe ụlo-ẹ́kwà nk'ẹphe tsota ẹphe bụ ndu ikfu Náfutali. Onye bụ ishi l'ikfu Náfutali bụ Ahira Enanu. ");
INSERT INTO iqw_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ndu a gụtaru l'ikfu Náfutali dụ ụkporo ụnu madzụ ishingu; l'ụnu iri l'ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“Ikfu ono, a fọtaru t'ẹphe l'ikfu Dánu kpọnyabe ụlo-ẹ́kwà ẹphe; kpọo ya l'ọnu-ụlo ọnu-ụlo; kpakọru dụ ụkporo ụnu madzụ iri lẹ tete l'ụnu madzụ iri. Ọ bụ ẹphebedua; bẹ e-kpejeru azụ l'ije ẹphe; dzee onwẹphe l'ọnu-ụlo ọnu-ụlo.” ");
INSERT INTO iqw_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ndu ono bụ ndu Ízurẹlu l'ẹge e gude gụa ẹphe ọgu l'ẹnya-ufu ẹnya-ufu. Mkpakọ ndu nọkota l'ọdu ndu Ízurẹlu, bụ ndu a gụru ọgu l'ọnu-ụlo ọnu-ụlo; dụ ụkporo ụnu madzụ ẹto l'ụkporo madzụ iri l'ise l'ụnu madzụ ẹsato. ");
INSERT INTO iqw_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ọle ndu Lívayi b'ẹ ta gụduru yeru ndu Ízurẹlu ọphu l'ẹphe ha. Yọ bụru ẹge ono; bẹ Ojejoje sụru Mósisu t'o mee ya. ");
INSERT INTO iqw_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Tọ dụ iya bụ; ndu Ízurẹlu emekotalephu iphemiphe ọbule, Ojejoje tụru Mósisu ekemu iya. Yọ bụru ẹge ono bẹ ẹphe kpọshiru ụlo-ẹ́kwà ẹphe l'ikfu l'ikfu. Ọ kwaphụ ẹge ono bẹ ẹphe eshije egbeshi atụgbu; ndu ọphu nọnu ẹphe lẹ ndu ikfu nk'ẹphe; mẹ ndu ọnu-ụlo nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ọwaa bụ eri ndu ikfu Érọnu yẹle Mósisu teke ono, Ojejoje kfuru yeru Mósisu lẹ Ugvu Sáyịnayi ono: ");
INSERT INTO iqw_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ẹpha ụnwu Érọnu bụ Nadabu, bụ iya bụ ọkpara iya; ọwaa Abihu; Eliyéza; mẹ Itama. ");
INSERT INTO iqw_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ono bụ ẹpha ụnwu Érọnu, bụ ndu a wụru manụ l'ishi; mbụ ndu ono, a fọtaru dobe t'ẹphe bụru ndu achịjeru Nchileke ẹja ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ọle Nadabu yẹle Abihu bẹ daru Ojejoje l'ifu; nwụshihu; kẹ l'ẹphe gude ọku, ẹ-ta dụdu nsọ kpọoru Ojejoje ngwẹja ọku l'echi-ẹgu Sáyịnayi. Ẹphebedua ta mụtadu ụnwegirima. Yọ bụru Eliyéza yẹle Itama bẹ jelahaaru ozi ndu achịjeru Nchileke ẹja teke ono, nna ẹphe, bụ Érọnu nọkwadu ndzụ ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ya ndono; Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“T'ọ chịta ndu ikfu Lívayi je eye l'ẹka Érọnu, bụ onye achịjeru Nchileke ẹja; k'ọphu ẹphe a-nọdu ejeru iya ozi. ");
INSERT INTO iqw_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ẹphe a-nọdu ejeru Érọnu ozi; l'ejeru ndu Ízurẹlu l'ẹphe ha ozi lẹ Ụlo-Ẹ́kwà Ndzuko; mbụ l'ẹphe a-nọdu eje ozi, gbaru ẹphe l'ụlo-ẹ́kwà Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ẹphe a-nọduje eleta iphe, nọ lẹ Ụlo-Ẹ́kwà Ndzuko ono ẹnya; shi ẹge ono l'ejeru ndu Ízurẹlu ozi, gbaru ẹphe l'ụlo-ẹ́kwà Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Wo Mósisu t'o woru ndu Lívayi l'ẹphe ha ye Érọnu yẹle ụnwu iya l'ẹka. E shiwa lẹ ndu Ízurẹlu wota ẹphe l'ẹphe ha ye iya l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","T'ọ fọta Érọnu mẹ ụnwu iya t'ẹphe bụru ndu achịjeru Nchileke ẹja. Iphe bụ onye ọdo, jenyaberu mgboro ụlo-nsọ ono ntse bẹ ee-gbu egbugbu.” ");
INSERT INTO iqw_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ojejoje abyakwa bya ekfuru yeru Mósisu ọdo; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Lenu; lẹ ya shiwa lẹ ndu Ízurẹlu fọta ndu Lívayi t'ẹphe nọ-chia ẹnya iphe, bụ nwoke, vuru ụzo waa nne iya ọswa lẹ Ízurẹlu. Ọo ya bụ lẹ ndu Lívayi bẹ bụ nk'iya; ");
INSERT INTO iqw_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kẹle ndu, bụ ọkpara bụkota nk'iya. Mbọku ono, ya gbushiru ndu bụ ọkpara l'alị Íjiputu ono bẹ ya wotaru iphe, bụ ọkpara ndu Ízurẹlu; doberu onwiya; mbụ shitakpoo lẹ madzụ je akpaa l'anụ. Ẹphe a-bụru nk'iya. Ọ bụ yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ya ndono; Ojejoje abya ekfuru yeru Mósisu l'echi-ẹgu Sáyịnayi; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Gụa ndu Lívayi ọgu. Gụa ẹphe l'ụnwunna l'ụnwunna; mẹ l'ikfu l'ikfu. Ndu ịi-gụ bụ unwoke, nọwaru ọnwa lanụ kwasẹru.” ");
INSERT INTO iqw_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Tọ dụ iya bụ; Mósisu agụa ẹphe ẹge ono, Ojejoje kfuru iya ẹya ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ọwaa ẹpha ụnwu Lívayi: Geshọnu; mẹ Kohatu; ọwaa Merari. ");
INSERT INTO iqw_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ọwaa bụ ẹpha ụnwu Geshọnu l'ụnwunna l'ụnwunna: Libini mẹ Shimeyi. ");
INSERT INTO iqw_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ụnwu kẹ Kohatu l'ụnwunna l'ụnwunna bụ Amuramu; Izaha; Hẹ́buronu; mẹ Uzẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ụnwu kẹ Merari l'ụnwunna l'ụnwunna bụ Mahuli waa Mushi. Ndu ono tụkoru bụru ikfu Lívayi; ẹge ẹphe dụ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ụnwu Geshọnu bụ ẹphe mụru ndu Libíni; mẹ ndu Shimeyi. Yọ bụru ndu ono bẹ bụ ndu ikfu Geshọnu. ");
INSERT INTO iqw_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Unwoke, nọwaru ọnwa lanụ kwasẹru l'ikfu Geshọnu dụ ụnu madzụ iri l'ẹsato l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ikfu Geshọnu bẹ a-kpọbeje ụlo-ẹ́kwà ẹphe l'ụzo ẹnyanwu-arịba; l'azụ ụlo-ẹ́kwà Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Onye bụ ishi l'ikfu Geshọnu bụ Ẹliyasafu Layelu. ");
INSERT INTO iqw_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ozi, e yeru ụnwu Geshọnu l'ẹka t'ẹphe jeje lẹ Ụlo-Ẹ́kwà Ndzuko ono bụ oleta ụlo-ẹ́kwà Nchileke ẹnya; waa ẹkwa, e gude kpua ya; mẹ oleta ẹkwa, e gude gbobuta ọnu Ụlo-Ẹ́kwà Ndzuko ono ẹnya; ");
INSERT INTO iqw_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","mẹ oleta ẹkwa, e gude gbobuta ogbodufu; waa ẹkwa, e gude gbobuta ọnu ogbodufu ono, nọ-pheru ụlo-ẹ́kwà Nchileke ono; waa ẹnya-ngwẹja mgburumgburu; mẹ oleta ụdo, e gude gebe ẹkwa ono ẹnya; waa iphe bụ ozi, gbaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ụnwu kẹ Kohatu bụ ẹphe mụru ndu Amaramu; ndu Izuha; ndu Hẹ́buronu; mẹ ndu Uzẹlu. Yọ bụru ndu ono bụ ikfu Kohatu. ");
INSERT INTO iqw_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Unwoke, nọwaru ọnwa lanụ kwasẹru l'ikfu Kohatu dụ ụkporo ụnu l'ụnu madzụ lanụ l'ụkporo madzụ iri. Ọ bụ ẹphebedua bẹ nwe ozi k'oje l'ụlo-nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ndu ikfu Kohatu b'a sụru t'ẹphe kpọbe ụlo-ẹ́kwà ẹphe l'ụzo ọhali ụlo-ẹ́kwà Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Onye bụ ishi l'ikfu Kohatu bụ Elizafanu Uzẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ozi nk'ẹphe abụru oleta Okpoko Ọgba-ndzụ ẹnya; mẹ teburu; mẹ iphe, eegvubeje urọku; mẹ ẹnya-ngwẹja; mẹ iphe, nọ l'ụlo-nsọ, ndu achịjeru Nchileke ẹja egudeje eje ozi; mẹ ẹkwa, e gude gebuta Ẹke-Kakọta-ọdu-Nsọ; mẹwaru iphe bụ ozi ọdo, gbaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Onye ishi ndu ishi ndu Lívayi kpamukpamu bụ Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja. Ọo yẹbedua b'a fọtaru t'ọ bụru onye ishi ndu eleta ẹnya l'ụlo-nsọ ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ụnwu kẹ Merari bụ ẹphe mụru ndu Mahuli; mẹ ndu Mushi. Yọ bụru ndu ono bụ ikfu Merari. ");
INSERT INTO iqw_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Unwoke, nọwaru ọnwa lanụ kwasẹru l'ikfu Merari dụ ụnu madzụ iri l'ise l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Onye bụ ishi kẹ ndibe Merari bụ Zuriyẹlu Abihelu. Ndibe Merari b'a sụru t'ẹphe kpọbe ụlo-ẹ́kwà ẹphe l'ụzo isheli ụlo-ẹ́kwà Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ozi, e yeru ụnwu Merari l'ẹka bụ: oleta ibo ụlo-ẹ́kwà Nchileke ono ẹnya; mẹ oshi, e swebushiru l'ibo ono; mẹ itso iya; mẹ ẹnya ẹke aakpọbeje ọkpa ibo ono; mẹ itso ono; mẹ ibiribe iphe ụlo, nọkota iya nụ; mẹwaru ozi ọdo, gbaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Ozi ọdo, e yeru ẹphe l'ẹka bụ: oleta ẹnya l'itso, e gude kpọ-phekota ogbodufu ụlo-ẹ́kwà Nchileke ono mgburumgburu; ọkpa iya; nggu iya; mẹ eri, e kegbaaru iya. ");
INSERT INTO iqw_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mósisu; mẹ Érọnu; mẹ ụnwu Érọnu b'a sụru t'ẹphe kpọbe ụlo-ẹ́kwà nk'ẹphe l'ụzo ẹnyanwu-ahata ụlo-ẹ́kwà Nchileke; mbụ l'ifu Ụlo-Ẹ́kwà Ndzuko ono. Ozi, dụru ndu Ízurẹlu lẹ Ẹke-dụ-Nsọ ono; bụ ẹphebedua e-jechijeru iya ẹphe. Onye ọdo mmanu -jenyabe Ẹke-dụ-Nsọ ono ntse; e gbua ya. ");
INSERT INTO iqw_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Mkpakọ ndu a gụru ọgu l'eri Lívayi; mbụ ndu ono, Mósisu yẹle Érọnu gụru l'ikfu l'ikfu ẹge ono, Ojejoje sụru t'ẹphe gụa ya ono; mbụ unwoke, nọwaru ọnwa lanụ kwasẹru dụ ụkporo ụnu madzụ ẹbo l'ụnu iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ojejoje abya ekfuru yeru Mósisu; sụ iya: “T'ọ gụkota unwoke, bụ ọkpara l'alị Ízurẹlu l'ẹphe ha ọgu; mbụ unwoke, nọwaru tsube l'ọnwa lanụ kwasẹru; woru ẹpha ẹphe deshia. ");
INSERT INTO iqw_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Wo iya t'o wofuta eri Lívayi doberu yẹbe Ojejoje l'ọnodu ọkpara l'alị Ízurẹlu mgburumgburu. Yo wota anụ ufu kẹ ndu Lívayi dobe l'ọnodu anụ ivuzọ l'anụ, bụ elu l'alị Ízurẹlu kpamukpamu. Ọo yẹbedua bụ Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Tọ dụ iya bụ; Mósisu agụa iphe bụ ọkpara l'alị Ízurẹlu kpamukpamu ọgu ẹge ono, Ojejoje sụru t'ọ gụa ya ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mkpakọ ndu bụ ọkpara l'iphe, bụ unwoke l'alị Ízurẹlu gbaa mgburumgburu; mbụ unwoke, nọwaru tsube l'ọnwa lanụ kwasẹru dụ ụkporo ụnu madzụ labụ; l'ụnu iri l'ise; l'ụkporo madzụ iri l'ẹto l'ụmadzu iri l'ẹto. A gụru ẹphe ọgu; deshia ẹpha ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tọ dụ iya bụ; Ojejoje abya asụ Mósisu ");
INSERT INTO iqw_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","t'o wofuta eri Lívayi doberu yẹbe Ojejoje l'ọnodu ọkpara l'alị Ízurẹlu kpamukpamu. Yo wota anụ ufu kẹ ndu Lívayi dobe l'ọnodu anụ ivuzọ l'anụ ufu l'alị Ízurẹlu mgburumgburu. Ọo yẹbedua bụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","A -bya abya l'ụkporo ụmadzu iri l'ẹto l'ụmadzu iri l'ẹto ono, bụ iphe, ọkpara ndu Ízurẹlu gude ka ndu ikfu Lívayi nshinu ono; iphe, aa-kfụ gude gbata ẹphe bụ: ");
INSERT INTO iqw_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","mkpọla-ọcha ise, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra mkpọla-ọcha ụlo-nsọ Nchileke, ẹra iya dụ ụkporo gera. Aa-kfụ iya l'ishi onye lanụ l'ẹhu l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Wo iya t'o woru okpoga ono, ee-gude gbata ụmadzu ole ono, ẹphe gude ka ndu Lívayi nshinu ono nụ Érọnu yẹle ụnwu iya. ");
INSERT INTO iqw_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ya ndono; Mósisu anakọo okpoga ono, ee-gude gbata ndu ono; l'ẹka ndu ono, a gụru ọgu; ẹphe aka ndu Lívayi nshinu ono. ");
INSERT INTO iqw_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Iphe, Mósisu natakọtaru l'ẹka ndu bụ ọkpara l'alị Ízurẹlu bụ ụnu mkpọla-ọcha ẹto; l'ụkporo mkpọla-ọcha ẹsato l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha ise, bụ: a -tụde iya atụtu; ẹra iya aha l'ọ bụ ẹra mkpọla-ọcha ụlo-nsọ Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mósisu ewota okpoga ono, ee-gude gbata ndu ono nụ Érọnu yẹle ụnwu iya; ẹge ono, Ojejoje tụru iya l'ekemu ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ojejoje abya ekfuru yeru Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Unu gụa ụnwu Kohatu, bụ ndu shi l'eri Lívayi ọgu. Unu gụa ẹphe l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ndu unu a-gụ bụ iphe, bụ unwoke ndu, nọwaru tsube l'ụkporo afa l'afa iri je akpaa l'ụkporo afa labụ l'afa iri; mbụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ozi, ụnwu Kohatu a-nọdu eje lẹ Ụlo-Ẹ́kwà Ndzuko ono bụ: oleta iphe, kakọta ọdu nsọ ẹnya. ");
INSERT INTO iqw_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Teke ẹphe abya t'ẹphe shi l'ọdu ndu Ízurẹlu tụgbua; tẹ Érọnu yẹle ụnwu iya bahụ lẹ Ụlo-Ẹ́kwà Ndzuko ono; je atọfuta ẹkwa, eegudeje gebuta Ẹke-Kakọta-ọdu-Nsọ; gude iya phụ-chia Okpoko Ekemu ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Teke ono; ẹphe ewota akpọ umoro-ẹnyimu phụ-kputa iya; gude ẹkwa, dụkota urukpu-urukpu phụa ya l'eli; bya eworu mgbọro, eegudeje apa iya ye iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“L'eli teburu ono, eedobeje buredi, e gude chịaru Ojejoje ẹja ono bẹ ee-kwebeje ẹkwa, eke urukpu-urukpu; wota efere tukobe l'eli iya; mẹ agọ; mẹ ọkwa; waa otumu, ngwẹja iphe-angụngu anọje. A tukobekwa iya phụ buredi ọphu anọje l'ifu Nchileke tekenteke. ");
INSERT INTO iqw_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ẹphe abya eworu ẹkwa uswe tụsaa l'eli iphe ono l'ọ ha; kwechita iya akpọ umoro-ẹnyimu; wota mgbọro, eegudeje apa iya ye iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ẹphe abya egude ẹkwa, eke urukpu-urukpu kwechia iphe, aatukobeje urọku, e gude amụ ọku; gude iya kwechia urọku l'onwiya; mẹ iphe, apajẹ òwúú iya; mẹ gbangụgbangu, aagụjeru ọku ye; mẹ iphemiphe ọbule, eeyeje manụ, e gude amụ ọku. ");
INSERT INTO iqw_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Teke ono; ẹphe egude akpọ umoro-ẹnyimu phụ-kputa iphe ono l'ọ ha; mẹ ngwa iya l'ọ ha; woru dobe l'eli iphe, eedobeje iya gude apa iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“L'eli ẹnya-ngwẹja ono, e meru lẹ mkpọla-ododo ono bẹ ẹphe a-phụshi ẹkwa, eke urukpu-urukpu; gude akpọ umoro-ẹnyimu kwechia ya; woru mgbọro, eegudeje apa iya; ye iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ẹphe ewotakota iphe, bụ ngwa, eegudeje eje ozi l'ẹke-dụ-nsọ; gude ẹkwa, eke urukpu-urukpu kekobe iya; bya egude akpọ umoro-ẹnyimu kwechita iya; woru iya tukobe l'eli iphe, eegudeje apa iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“A -bya l'ẹnya-ngwẹja ono; t'ẹphe kpofu ntụ, nọ iya nụ; woru ẹkwa uswe tụsaa l'eli iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Teke ono; ẹphe ewota iphe, bụ iphe, eegudeje eje ozi l'ẹnya-ngwẹja ono; tukobe l'eli ẹkwa uswe ono. Mbụ l'ẹphe a-tukobe iya gbangụgbangu, aagụjeru ọku ye; mẹ oji; mẹ shọvelu; mẹ efere nkwọ-ẹka. Iphemiphe ọbule ono bẹ ee-kwechita akpọ umoro-ẹnyimu; woru mgbọro, eegudeje apa iya; ye iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Érọnu yẹle ụnwu iya -kwechishitsulephu Ẹke-dụ-Nsọ; mẹ iphe, nọ iya nụ; ndu Ízurẹlu -byadẹlephu oshi l'ọdu ẹphe; tụgbua; t'ụnwu Kohatu bya evuta iphe ono. Ọle t'ẹphe be denyikwa ẹka l'iphe ono, dụ nsọ ono. Ọdumeka; bẹ ẹphe a-nwụshihukwa. Ọ bụ ụnwu Kohatu e-vutaje iphe ono, dụ lẹ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja bẹ kẹ manụ, eegudeje amụ ọku nọ l'ẹka; mẹ ínsẹnsu, eshije mkpọ; mẹ ngwẹja nri, eegwoje mbọku-mbọku; mẹ manụ, aawụje l'ishi. Ọ bụ yẹbedua a-nọdu eleta ụlo-ẹ́kwà Nchileke ẹnya; mẹ iphemiphe ọbule, nọ iya nụ; mbụ Ẹke-dụ-Nsọ; mẹ iphe nọkota iya nụ.” ");
INSERT INTO iqw_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ojejoje asụ Mósisu yẹle Érọnu: ");
INSERT INTO iqw_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Unu be ekwekwa tẹ ikfu Kohatu chịhu l'eri ndu Lívayi. ");
INSERT INTO iqw_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ọwaa iphe, unu e-meru ẹphe; k'ọphu ẹphe ta anwụshihudu m'ọ -bụru l'ẹphe -jenyaberu iphe, kakọta ọdu nsọ ntse: T'ọ bụru Érọnu yẹle ụnwu iya a-bahụje l'ime Ẹke dụ Nsọ; je ekfuru onyenọnu ozi ọphu oo-je; mẹ ivu, oo-vuta. ");
INSERT INTO iqw_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ọle tẹ ndu ikfu Kohatu ba abahụkwa je ole ẹnya l'iphe ono, dụ nsọ ono; m'o -ruhuru; ọ bụru t'ẹphe lee ya ẹnya ugbo lanụ; ọdumeka bẹ ẹphe a-nwụshihukwa.” ");
INSERT INTO iqw_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ojejoje bya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gụkwaaphu ụnwu Geshọnu ọgu. Gụa ẹphe l'ụnwunna ụnwunna; mẹ l'ikfu l'ikfu. ");
INSERT INTO iqw_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ndu unu a-gụ bụ iphe, bụ unwoke ndu, nọwaru tsube l'ụkporo afa l'afa iri je akpaa l'ụkporo afa labụ l'afa iri; mbụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Iphe, a-bụru ozi ndu ikfu Geshọnu l'ozi, eeje ejeje l'ụlo-ẹ́kwà ndzuko; mẹ iphe, eevu evuvu bụ: ");
INSERT INTO iqw_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ovutaje ẹkwa, e gude mee ụlo-ẹ́kwà Nchileke; vuta ụlo-ẹ́kwà-dụ-nsọ ono; mẹ ẹkwa, e gude kpua ya; mẹ akpọ umoro-ẹnyimu, e gude kwechia ya; mẹ ẹkwa, eegudeje gbobuta ọnu Ụlo-Ẹ́kwà Ndzuko; ");
INSERT INTO iqw_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","mẹ ẹkwa, eegebutaje mgburumgburu l'ogbodufu ono, nọ-pheru ụlo-ẹ́kwà Nchileke ono; mẹ ẹnya-ngwẹja ono; waa ẹkwa, eegebutaje l'ọnu-ụzo; mẹ eri, eegebeje iya; mẹ iphe, bụ ngwa, nọ iya nụ, eegudeje eje ozi. Ọ bụ ndu Geshọnu e-gudeje iphe ono l'ọ ha mee iphe, ọ gbaru t'e gude iya mee. ");
INSERT INTO iqw_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Iphe, bụ ozi, ụnwu Geshọnu ejekpo ejeje; m'o -ruhuru; ọ bụru ovu ivu; m'ọ bụ oje ozi ọdo bẹ bụ Érọnu yẹle ụnwu iya bẹ e-koshije ẹge ẹphe e-je iya. Ọo unubẹdua e-koshije ẹphe ivu, gbaru ẹphe l'evuvu. ");
INSERT INTO iqw_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ono bụ ozi, ndu ikfu Geshọnu a-nọduje eje lẹ Ụlo-Ẹ́kwà Ndzuko ono. Ọ bụ Itama Érọnu, bụ onye achịjeru Nchileke ẹja a-nọdu ekoshije ẹphe iphe bụ ozi ẹphe; mẹ ẹge ẹphe e-shije eje iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“A -bya abya l'ụnwu Merari; unu gụa ẹphe l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ndu unu a-gụ bụ iphe, bụ unwoke ndu, nọwaru tsube l'ụkporo afa l'afa iri je akpaa l'ụkporo afa labụ l'afa iri; mbụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ọwaa iphe, gbaru ụnwu Merari l'ememe teke ẹphe eje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. Ẹphe e-vutaje oshi, e gude gbaa ụlo-ẹ́kwà-dụ-nsọ Nchileke; mẹ oshi, e swebushiru iya eswebushi; mẹ itso iya; mẹ ọkpa iya. ");
INSERT INTO iqw_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Ẹphe e-vutajekwaphu itso, nọ-pheru ogbodufu ono mgburumgburu; mẹ ọkpa itso ono; mẹ nggu, a kpọru l'ụlo-ẹ́kwà ono; mẹ ụdo iya; mẹwaru ivu, etsoje iya nụ l'ọ ha; mẹ iphemiphe ọbule, e gude eje egbe ozi ono. Unu ketajeru onyemonye ọbule iphe, gbaru iya l'evuvu. ");
INSERT INTO iqw_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ono bụ ozi, ụnwu Merari a-nọduje eje lẹ Ụlo-Ẹ́kwà Ndzuko ono. Itama Érọnu, bụ onye achịjeru Nchileke ẹja bẹ a-nọduje ekoshi ẹphe ẹge ẹphe e-je ozi ono.” ");
INSERT INTO iqw_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ya ndono; Mósisu yẹle Érọnu; mẹ ndu ishi ndu Ízurẹlu abya agụkota awa Kohatu ọgu. A gụru ẹphe l'ikfu l'ikfu; gụa ẹphe l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Ndu bụ unwoke, nọwaru shita l'ụkporo afa l'afa iri jeye l'ụkporo afa ẹbo l'afa iri; mbụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko; ");
INSERT INTO iqw_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","mbụ ndu a gụru l'ikfu Kohatu dụ ụnu madzụ ishingu; l'ụkporo madzụ iri l'ẹsaa l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ono bụ mkpakọ unwoke, a gụru ọgu l'ikfu Kohatu; mbụ ndu jeru ozi lẹ Ụlo-Ẹ́kwà Ndzuko. Mósisu yẹle Érọnu gụru ọgu ono ẹge ono, Ojejoje tụru Mósisu ekemu t'ọ gụa ya ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ụnwu Geshọnu b'a gụkwaruphu l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Iphe, bụ unwoke, nọwaru ụkporo afa l'afa iri jeye l'ụkporo afa ẹbo l'afa iri, bụ ndu a-dụ ike oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko; ");
INSERT INTO iqw_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","b'a gụru ọgu l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. Ndu a gụtaru dụ ụnu madzụ ishingu l'ụkporo iri lẹ nanụ l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ono bụ mkpakọ unwoke, a gụru ọgu l'ikfu Geshọnu; mbụ ndu jeru ozi lẹ Ụlo-Ẹ́kwà Ndzuko. Mósisu yẹle Érọnu gụru ọgu ono ẹge ono, Ojejoje tụru iya ẹya ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ikfu ụnwu Merari b'a gụkwaruphu l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Iphe bụ unwoke, nọwaru shita l'ụkporo afa l'afa iri jeye l'ụkporo afa ẹbo l'afa iri, bụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko ");
INSERT INTO iqw_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","b'a gụru ọgu l'ikfu l'ikfu. Ndu a gụtaru dụ ụnu madzụ ẹsato. ");
INSERT INTO iqw_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ono bụ mkpakọ unwoke, a gụru ọgu l'ikfu Merari. Mósisu yẹle Érọnu gụru ọgu ono ẹge ono, Ojejoje sụru Mósisu t'ẹphe gụa ya ono. ");
INSERT INTO iqw_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ya ndono; Mósisu yẹle Érọnu; mẹ ndu ishi ndu Ízurẹlu agụkota ndu Lívayi l'ẹphe ha ọgu. A gụru ẹphe l'ikfu l'ikfu; mẹ l'ụnwunna l'ụnwunna. ");
INSERT INTO iqw_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Ndu ẹphe gụru bụ iphe, bụ unwoke, nọwaru shita l'ụkporo afa l'afa iri jeye l'ụkporo afa ẹbo l'afa iri, bụ ndu dzuwaru oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko mẹ ovu ivu. ");
INSERT INTO iqw_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Iphe, ẹphe kpakọru dụ bụ ụkporo ụnu; l'ụnu madzụ l'ụmadzu ụkporo tetee. ");
INSERT INTO iqw_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ndu nọnu l'ẹhu l'ẹhu b'e koshitsuaru ozi, ẹphe a-nọdu eje; mẹ iphe, ẹphe a-nọduje evu ẹge ono, Ojejoje sụru Mósisu t'o mee ya ono. Tọ dụ iya bụ; a gụa ẹphe ọgu ono ẹge Ojejoje sụru Mósisu t'a gụa ya. ");
INSERT INTO iqw_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ojejoje abya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Kfuaru ẹphe t'ẹphe chịshia iphe, bụ ndu ẹhu-labụ l'ọdu ndu Ízurẹlu ono; ẹphe achịshia ndu iphe alashị alashị l'ẹhu. Ẹphe achịshikwaaphu ndu denyiru ẹke l'odzu; shi ẹge ono merua onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Unu chịfukota ẹphe; unwoke; mẹ ụnwanyi. Unu chịta ẹphe chịfu l'ọdu ndu Ízurẹlu; t'ẹphe be meru ẹke ono yẹle ndu nk'iya bu ono.” ");
INSERT INTO iqw_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ẹphe ekwe; chịta ndu ono chịfu l'ọdu ndu Ízurẹlu ono. Yọ bụru ẹge ono, Ojejoje kfuru iya Mósisu ono bẹ ẹphe meru iya. ");
INSERT INTO iqw_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“T'o kfuaru ndu Ízurẹlu lẹ teke madzụ: m'ọ bụ nwoke; m'ọ nwanyi mesweru ibe iya ẹge ono, ndiphe emeje; shi ẹge ono meswee Ojejoje ono; bẹ ikpe nmaakwaru onye ọbu. ");
INSERT INTO iqw_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Onye ọbu kfufutaje iphe, dụ ẹji ono, o meru ono; kfụ-dzukwaaphu ụgwo iphe, dụ ẹji ono, o meru ono l'ọ ha; wota ụzo lanụ l'ụzo ise l'iphe iya yekobe iya; nụ onye ono, o mesweru ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ọ -bụru l'onye ono, e mesweru ono te nwedu abụbu, bụ onye aa-kfụ ụgwo iphe ono; ọo ya bụ; ụgwo ono abụru kẹ Ojejoje. Onye aa-nụ iya bụ onye achịjeru Nchileke ẹja. Aa-kpụru ebyila yekobe iya; t'o gbua gude doshiaru iya okfu ẹhu iya. ");
INSERT INTO iqw_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Iphe, bụ iphe, ndu Ízurẹlu doberu nsọ t'ẹphe nụ Ojejoje, bụ iphe, ẹphe wotaru bya anụ onye achịjeru Nchileke ẹja bụkota k'onye ono, achịjeru Nchileke ẹja ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Iphe, bụ iphe, madzụ doberu nsọ tẹ ya nụ Nchileke bụ onye achịjeru Nchileke ẹja bẹ nwe iya nụ; mbụ l'iphe, madzụ nụru onye achịjeru Nchileke ẹja bụ onye ono, achịjeru Nchileke ẹja ono nwe iya.” ");
INSERT INTO iqw_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Tọ dụ iya bụ; Ojejoje abya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“T'o kfuru ndu Ízurẹlu l'ọ -bụru lẹ nwoke bẹ nyee ya akpa ẹjo ụri; nji iya te gudehe ire iya ẹka; ");
INSERT INTO iqw_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mbụ; ọ -bụru lẹ yẹle nwoke ọdo zẹru; yo shi ẹge ono merua onwiya; nji iya ta ma; to nwe onye agba ekebe l'ọo iphe o meru ndono keshinu ẹ tọ dụdu onye guderu iya nụ teke oome iya; ");
INSERT INTO iqw_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","mbụ; ọ -bụru lẹ nwoke ono bẹ nọnyaaru; kolahaaru nyee ya ono okopho; lelahaa ya ẹnya l'o meruwaru onwiya; lẹ teke nwanyi ono meruru onwiya l'oswiya; m'ọ kwanụ l'a nọnyaaru; kolahaaru nyee ya ono okopho; lelahaa ya ẹnya l'o meruru onwiya l'ẹ b'o meru onwiya; ");
INSERT INTO iqw_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","tẹ nwoke ono duta nyee ya ono jekfu onye achịjeru Nchileke ẹja. Yo gude ụzo lanụ l'ụzo iri l'ụtu balị, jiru efere nkwo-ẹka, ee-gude gwoo ẹja l'okfu ẹhu nyee ya ono. T'ẹ b'o yekwa manụ l'ụtu balị ono; ọphu o yekwa iya ínsẹnsu; kẹ l'ọ bụ ngwẹja nri, e gworu lẹ k'okopho; mbụ ngwẹja, e gude anyata iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Nwanyi ono bẹ onye achịjeru Nchileke ẹja e-durita ntse t'o vudo Ojejoje l'ifu. ");
INSERT INTO iqw_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Tẹ onye ono, achịjeru Nchileke ẹja ono kuta mini, e doberu nsọ l'ite, a kpụru l'ụra; kpota udzu-ẹja, shi l'ọgbodo-ụlo ụlo-ẹ́kwà Nchileke wụru ye lẹ mini ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Onye ono, achịjeru Nchileke ẹja ono -kfụbetsulephu nwanyi ono l'ifu Ojejoje; yọ tọfu iya iphe, o keberu l'ishi; pata ngwẹja nri ono, e gude anyata iphe, dụ ẹji ono nụ iya t'ọ paru l'ẹka; mbụ ngwẹja nri ono, e gworu lẹ k'okopho ono. Onye ono, achịjeru Nchileke ẹja ono l'onwiya aparu mini ono, atsọ ile, emeje tẹ madzụ bụru onye a tụru ọnu ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ọ bụ teke ono bẹ onye ono, achịjeru Nchileke ẹja ono a-nụ nwanyi ono nte t'o ria: ‘L'ọ -bụru l'ẹ tọ dụdu nwoke ọdo, nggu l'iya zẹjeru; tọ bụ l'ị kpajẹru ẹjo ụri; shi ẹge ono merua onwongu l'ẹhu nwoke ọdo, gbahakwaa nji ngu-a; tẹ mini-wa, atsọ ile, emeje tẹ madzụ bụru onye a tụru ọnu-a ba dụkwa iphe, oo-me ngu. ");
INSERT INTO iqw_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Teke bụkwanu l'ị nọ l'ẹka nji ngu-a; l'akpa ẹjo ụri; nggu lẹ nwoke ọdo zẹjewa; gbahakwaa nji ngu-a; nggu eshi ẹge ono merua onwongu; ");
INSERT INTO iqw_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","tẹ Ojejoje mekwaa tẹ ẹkpa-nwa chihu ngu; mbụ t'ẹ b'i heshi nwa l'ụtakfu; t'ị bụru onye ndibe unu e-gude l'akọ l'ọnu; gude ngu l'anma ẹjo ẹtu. Ono bụ teke onye ono, achịjeru Nchileke ẹja ono a-sụ nwanyi ono t'ọ gụaru onwiya ẹnwa. ");
INSERT INTO iqw_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mbụ; tẹ mini-a, atsọ ile, emeje tẹ madzụ bụru onye a tụru ọnu-a kpobakwa ngu l'ẹpho; k'ọphu ẹkpa-nwa e-chihu; to he nwa l'ụtakfu.’ “Teke ono; nwanyi ono asụ: ‘Ọ -bụru l'ọ bụ ẹge ọ dụ b'i kfuru; t'ọ dụ ẹge ono.’ ");
INSERT INTO iqw_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Onye ono, achịjeru Nchileke ẹja ono abya atụko mburọnu ono dekota l'ẹkwo; bya asaa ya asasa saru ye lẹ mini ono, atsọ ile ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Yọ bya eworu mini ono, atsọ ile ono, emeje madzụ t'ọ bụru onye a tụru ọnu ono nụ nwanyi ono t'ọ ngụa. Ọ -ngụ-ge l'iya phụ; mini ono anọdu iya l'ẹpho; mee t'ẹjo iphe-ẹhuka, atsọ ile dakfuta iya. ");
INSERT INTO iqw_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Teke ono bẹ onye ono, achịjeru Nchileke ẹja ono a-nata nwanyi ono ngwẹja-nri ono, o gworu lẹ k'okopho ono, nwanyi ono pa l'ẹka ono. Yọ bya amaa ya amama l'ifu Ojejoje; woru iya je edobe l'ẹnya-ngwẹja. ");
INSERT INTO iqw_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Onye ono, achịjeru Nchileke ẹja ono abya ahajia ngwẹja ono l'ẹka; woru kpọo ọku l'ẹnya-ngwẹja ono. Ngwẹja ono a-bụru ngwẹja, e gude anyata iphe, dụ ẹji ono. O -metsulephu ẹge ono; yọ bya anụ nwanyi ono mini ono t'ọ ngụa. ");
INSERT INTO iqw_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ọ -bụru lẹ nwanyi ono meruruphu onwiya; mbụ; ọ -bụru l'o riruphu ogori l'oswiya bẹ bụ teke a nụleru iya phụ mini ono; yọ ngụa; teke ọ bahụleru iya phụ l'ẹpho bẹ oo-me t'ẹjo iphe-ẹhuka, atsọ ile dakfuta iya. Oo-me tẹ ẹkpa-nwa iya chihu; mee t'ẹ b'o heshi nwa l'ụtakfu. Yọ ghọo onye a tụru ọnu l'ufu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Teke ọ bụ lẹ nwanyi ono te merudu onwiya; mbụ; ọ -bụru lẹ nwanyi ono doberu onwiya ndo-o; b'ẹ t'ọ dụdu iphe e-me iya nụ. Ọo-nọdu amụshilee ụnwegirima. ");
INSERT INTO iqw_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Ono bụ ekemu, a tụru swiberu nwanyi, nji iya ekoru okopho; mbụ nwanyi, nọ l'ẹka nji iya; l'akpa ẹjo ụri; l'emerushi onwiya; ");
INSERT INTO iqw_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ọdo bụ l'a nọnyaaru; nwoke ekolahaaru nyee ya okopho; lelahaa ya ẹjo ẹnya. T'onye achịjeru Nchileke bya edobe nwanyi ọbu l'ifu Ojejoje; mekota iya iphe bụ iphe ono, a tụru l'ekemu ono. ");
INSERT INTO iqw_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Nwoke ono l'onwiya bẹ ta dụkwa iphe, dụ ẹji, a-tukoru iya l'ishi. Ọ bụ nwanyi ono e-vuru iphe, dụ ẹji, o metaru kpua onwiya.” ");
INSERT INTO iqw_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“T'o kfuru ndu Ízurẹlu l'o -nweru nwoke; m'ọ bụ nwanyi, kweru ụkwa, gbaru iche lẹ ya a-dụru Ojejoje iche; mbụ lẹ ya e-dobe onwiya tẹ ya bụru onye dụ iche l'ẹke Ojejoje nọ; ");
INSERT INTO iqw_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","t'onye ọbu ba angụjekwa mẹe; m'ọ bụ iphe ọdo, aangụ angụngu, eme l'ẹnya. T'onye ọbu ba angụjekwa mẹe, anwụ ọnu, e meru lẹ mẹe vayịnu; m'ọ bụ iphe ọdo, aangụ angụngu, eme l'ẹnya. T'ẹ b'ọ ngụjekwa mini akpụru vayịnu; ọphu o rijekwa akpụru vayịnu onyingu; m'ọ bụ k'ọkponku. ");
INSERT INTO iqw_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","T'ẹ b'o rijekwa iphe, shi l'oshi vayịnu; m'ọ bụ akpụru vayịnu ọbu l'onwiya; m'ọ bụ ẹgbo vayịnu jeye teke ọo-bụ-beru onye doberu onwiya Ojejoje iche. ");
INSERT INTO iqw_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Tẹ ákwọ̀ be erukwa iya l'ishi jeye teke ono, ọo-bụ-beru onye doberu onwiya iche ono. Ọo-dụlephu nsọ ẹge ọ dụ iya jeye teke ono, o doberu onwiya Ojejoje iche ono e-dzu. Ẹgbushi, nọ iya l'ishi bẹ ọo-ha t'o ruchia eruchi. ");
INSERT INTO iqw_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","L'ògè teke ono, o doberu onwiya Ojejoje iche ono b'ẹ to jekwa ẹke odzu nọ; ");
INSERT INTO iqw_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","m'o -ruhuru; ọ bụru l'ọo nna iya; m'ọo nne iya; ọdudu l'ọo nwunne iya kẹ nwoke; m'ọ nwunne iya kẹ nwanyi bẹ nwụhuru nụ. Ẹ too gudedu okfu l'ọo ẹphe jekfube odzu ẹphe ntse; shi ẹge ono merua onwiya; kẹ l'e gude ishi iya maru l'o doberu onwiya Nchileke iche. ");
INSERT INTO iqw_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Lẹ teke ono ọo-nọkotakpo bụru onye doberu onwiya iche ono b'ọ bụ onye dụru Ojejoje nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Ọ -bụru l'o -nweru onye gbabuhuru nwụhu lẹ mgboro ẹke ọ nọ; shi ẹge ono merua ẹgbushi ono, o doberu nsọ ono bẹ bụ: o -rulephu lẹ mbọku k'ẹsaa; yọ kpụshia ẹgbushi ono; shi ẹge ono safu onwiya mmeru l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","O -be lẹ mbọku k'ẹsato; yo wota ndo ẹbo; m'ọ bụ kparakobe ẹbo wojeru onye achịjeru Nchileke ẹja l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Onye ono, achịjeru Nchileke ẹja ono ewota nanụ gwoo ngwẹja iphe, dụ ẹji. Yo wota nanụ ọphu gwoo ngwẹja-ukfuru gude kfụa ụgwo iphe, dụ ẹji, o meru; kẹ l'ọ nọru l'ẹke madzụ nwụhuru. Yọ bụru mbọku ono kwaphu bẹ oo-me t'ishi iya dụ-phu nsọ azụ. ");
INSERT INTO iqw_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Oo-doberu onwiya Ojejoje iche jeye teke ono, ọ tụ-buru lẹ ya e-doberu onwiya Ojejoje iche ono. Yo wota ebyila, gbaru afa nụ t'e gude gwoo ngwẹja ikpe-anmanma. Oge ọphu, ọ nọhawaruphu b'ẹ taa gụ-kwaru eye iya. Ishi iya abụru l'o meruru onwiya teke ono, o shi dobe onwiya iche ono. ");
INSERT INTO iqw_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Ọwaa bụ ekemu, dụru onye doberu onwiya Ojejoje iche ndọ-ọ; mẹ oge, o doberu onwiya Ojejoje iche dzulephu. Ee-duru iya bya l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Yọ bụru l'ẹke ono bẹ ọo-nọdu woru iphe, ọonu Ojejoje nụ iya. Ọo-nụ iya ebyila, gbaru afa; to nwe ntụpo t'e gude gwoo ngwẹja-ukfuru. Yọ nụ nwada atụru, nọwaru afa; to nwe ntụpo t'e gude gwoo ngwẹja iphe, dụ ẹji. Yọ nụ ebyila, ẹ-te enwedu ntụpo t'e gude gwoo ngwẹja ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Iphe ọdo, oo-yekobe iya bụ nkata buredi, ẹ-te kodu ekoko; waa akara witu, a gwọru lẹ manụ; mẹ ẹcha-mbeke, a wụru manụ l'eli; waa ngwẹja-nri yẹle ngwẹja-mẹe, l'etsoje iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Iphe ono l'ọ ha bẹ onye achịjeru Nchileke ẹja e-gworu nụ Ojejoje. Yo gwoo ngwẹja iphe, dụ ẹji ono; mẹ ngwẹja-ukfuru ono. ");
INSERT INTO iqw_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Onye ono, achịjeru Nchileke ẹja ono e-woru nkata buredi ono, ẹ-te kodu ekoko ono nụ Ojejoje; bya egbua ebyila phụ gude gwoo ngwẹja ẹhu-agu nụ Ojejoje; bya eyekobekwa iya phụ ngwẹja-nri yẹle ngwẹja-mẹe, etsoje iya nụ tụko gwoo. ");
INSERT INTO iqw_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Yọ bụru l'ọnu Ụlo-Ẹ́kwà Ndzuko bẹ onye ono, doberu onwiya Ojejoje iche ono a-nọdu kpụshia ẹgbushi ono, o doberu iche ono. Yo kpota ẹgbushi iya ono ye l'ọku, nọ lẹ mkpuli ẹke iphe, e gude gwoo ngwẹja ẹhu-agu phụ nọ. ");
INSERT INTO iqw_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Onye ono, dụru Ojejoje iche ono -kpụshitsulephu ẹgbushi iya ono, o doberu iche ono; tẹ onye achịjeru Nchileke ẹja wota ẹka ebyila ono ọphu e shiru eshishi dẹe ya l'ẹka; wotafua akara lanụ; mẹ ẹcha-mbeke lanụ, ẹ te kodu ekoko lẹ nkata ono nụ iya. ");
INSERT INTO iqw_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ọo ya bụ; onye ono, achịjeru Nchileke ẹja ono abya amàà ya àmàmà l'ifu Ojejoje t'ọ bụru ngwẹja-amama. Iphe ono bẹ dụ nsọ; yọ bụru onye achịjeru Nchileke ẹja bẹ nwe iya nụ yẹle ǹdụ́ ebyila ono, a maru amama; mẹ ụtakfu iya ono, a nụru Ojejoje ono. E -metsua ẹge ono bẹ onye ono, dụru Ojejoje iche ono nweru ike ngụa mẹe. ");
INSERT INTO iqw_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Ono bụ ekemu, dụru onye doberu onwiya Ojejoje iche; mbụ onye kweru ụkwa lẹ ya e-doberu onwiya Ojejoje iche; waa iphe, ọo-nụje Ojejoje teke oge iya dzuleruphu; a gụfukwa iphe ọdo, ọo-dụ ike gbatafụa. Ọle o medzufutaje iphe, o kweru ụkwa iya; l'ẹge ekemu onye dụru Ojejoje iche gude dụ.” ");
INSERT INTO iqw_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“T'o kfuru Érọnu yẹle ụnwu iya l'ọ waa bụ ẹge ẹphe e-shije agọru ndu Ízurẹlu ọnu-ọma: ");
INSERT INTO iqw_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Tẹ Ojejoje gọoru unu ọnu; yo chekwaje unu. ");
INSERT INTO iqw_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tẹ Ojejoje mụaru unu ọnu-ọchi; yo meeru unu eze-iphe-ọma. ");
INSERT INTO iqw_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Tẹ Ojejoje lee unu ẹnya-ọma; yo mee t'ẹhu dụ unu agu. ");
INSERT INTO iqw_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ọ bụ ẹge ono bẹ ẹphe e-shije kpọ-kua ẹpha iya l'ẹke ndu Ízurẹlu nọ; ya agọoru ẹphe ọnu-ọma.” ");
INSERT INTO iqw_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Tọ dụ iya bụ; Mósisu egvubetsulephu ụlo-ẹ́kwà Ojejoje ono; bya awụa ya manụ; bya edobe iya iche; bya edobekwaphu iphe, bụ iphe, nọ iya nụ l'ọ ha iche. Ọ kwaphụ ẹge ono b'ọ wụru manụ l'ẹnya-ngwẹja; dobe iya iche; bya edobekwaphu iphe bụ iphe, nọ l'ẹnya-ngwẹja ono l'ọ ha iche. ");
INSERT INTO iqw_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ndu ishi ndu Ízurẹlu, bụ ndu ishi l'ụnwunna l'ụnwunna; mbụ ndu ishi l'ikfu l'ikfu; bụ iya bụ ndu ono, bụ ishi ndu ọphu a gụru ọgu ono ");
INSERT INTO iqw_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","bẹ byaru bya eworu iphe nụ Ojejoje. Iphe, ẹphe nụru bụ ọ-gba-kperekpere ishingu, ekpuchiru iphe; mẹ oke-eswi iri l'ẹbo. Ndu ishi ono bẹ nụtsuaru oke-eswi nanụ nanụ l'ẹhu l'ẹhu. Ẹphe dụtsua ẹbo ẹbo nụ ọ-gba-kperekpere lanụ. Ono bụ iphe, ẹphe wotaru bya anụ l'ifu ụlo-ẹ́kwà Ojejoje ono. ");
INSERT INTO iqw_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“T'ọ natakọta ẹphe iphe ono, ẹphe nụru ono; k'ọphu ee-gude iya eje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. T'o woru iya nụ ndu Lívayi. Onyenọnu bẹ ọo-nụ iya l'ẹge ozi iya gbaru.” ");
INSERT INTO iqw_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ya ndono; Mósisu abya ewota ọ-gba-kperekpere ono; mẹ oke-eswi ono nụ ndu Lívayi. ");
INSERT INTO iqw_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ụnwu Geshọnu b'ọ nụru ọ-gba-kperekpere ẹbo; waa oke-eswi ẹno t'ẹphe gude jeje ozi, gbaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Ụnwu Merari b'ọ nụru ọ-gba-kperekpere ẹno; waa oke-eswi ẹsato t'ẹphe gude jeje ozi, gbaru ẹphe. L'ẹphe ha bẹ nọkota l'ẹka Itama Érọnu, bụ onye achịjeru Nchileke ẹja eje ozi, gbaru ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Obenu l'ẹ t'ọ dụdu ọphu ọ nụru ụnwu Kohatu; kẹ l'ọo ẹphebedua b'ọ nọ l'ẹka; mbụ oleta iphe, dụ nsọ ẹnya; bụ iya bụ ovu iphe ono, dụ nsọ ono l'ukuvu. ");
INSERT INTO iqw_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Mbọku, a wụru manụ l'ẹnya-ngwẹja Nchileke gude woru iya ye Nchileke l'ẹka bẹ ndu ishi ono wotagbaaru iphe bya anụ Nchileke l'ifu ẹnya-ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ojejoje abya ekfuru yeru Mósisu; sụ iya: “Iphe bụ mbọku-mbọku tẹ onye ishi lanụ wotaje iphe nk'iya bya anụ t'e gude woru ẹnya-ngwẹja ono ye Nchileke l'ẹka.” ");
INSERT INTO iqw_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Onye wotaru iphe nk'iya bya anụ lẹ mbọku kẹ mbụ bụ Náshọnu Amínadabu, bụ onye ishi ndu Júda. ");
INSERT INTO iqw_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; bya anụkwaphu ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","A nụru nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","mẹ mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","mẹ oke-eswi ẹbo; ebyila ise; mkpi ise; mẹ ụnwu ebyila ise, gbatsuaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Náshọnu Amínadabu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Yo be lẹ mbọku k'ẹbo; Netanẹlu Zuwa, bụ onye ishi l'ikfu Ísaka ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Iphe ọdo, ọ nụru bẹ bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu, ");
INSERT INTO iqw_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","oke-eswi ẹbo; ebyila ise; mkpi ise; mẹ ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono bụ iphe, Netanẹlu Zuwa gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Yo be lẹ mbọku k'ẹto; Eliyabu Helọnu, bụ onye ishi ndu kẹ Zébulọnu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Yọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","oke-eswi ẹbo; ebyila ise; mkpi ise; mẹ ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Eliyabu Helọnu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Yo be lẹ mbọku k'ẹno; Elizuru Shediyọ, bụ onye ishi, ụnwu Rúbẹnu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Yọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Elizuru Shediyọ gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Yo be lẹ mbọku k'ise; Shelumẹlu Zurishadayi, bụ onye ishi ụnwu Símiyọnu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Yọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","oke-eswi ẹbo; mẹ ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Shelumẹlu Zurishadayi gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Yo be lẹ mbọku k'ishingu; Ẹliyasafu Diyuwẹlu, bụ onye ishi ndu Gádu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Ẹliyasafu Diyuwẹlu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Yo be lẹ mbọku k'ẹsaa; Elishama Amihudu, bụ onye ishi ndu Ífuremu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Elishama Amihudu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Yo be lẹ mbọku k'ẹsato; Gamalẹlu Pedazọ, bụ onye ishi ndu ikfu Manásẹ ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","oke-eswi ẹbo; ebyila ise, mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Gamalẹlu Pedazọ gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Yo be lẹ mbọku kẹ tete; Abidanu Gidiyọ́ni, bụ onye ishi ndu Bénjaminu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; waa nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","oke-eswi ẹbo; mẹ ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono iphe, Abidanu Gidiyọ́ni gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Yo be lẹ mbọku k'iri; Ahiyeza Amishadayi, bụ onye ishi ndu ikfu Dánu ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono bụ iphe, Ahiyeza Amishadayi gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Yo be lẹ mbọku k'iri lẹ nanụ; Pagẹlu Ọkuranu, bụ onye ishi ndu ikfu Ásha ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono bụ iphe, Pagẹlu Ọkuranu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Yo be lẹ mbọku k'iri l'ẹbo; Ahira Enanu, bụ onye ishi ndu ikfu Náfutali ewota iphe nk'iya bya anụ. ");
INSERT INTO iqw_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Iphe, ọ nụru bụ: efere lanụ, e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mẹ ochi lanụ, e meru l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Ọphu nọnu b'e yejishikotaru akpe, e gweru egwegwe; gwọkobe iya manụ; t'e gude gwoo ngwẹja-nri. ");
INSERT INTO iqw_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Iphe ọdo, ọ nụru bụ agọ lanụ, e meru lẹ mkpọla-ododo iri. Iphe, jiru iya nụ bụ ínsẹnsu. ");
INSERT INTO iqw_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","B'ọ bya anụ nwa oke-eswi lanụ; ebyila lanụ; nwa ebyila lanụ, gbaru afa, ee-gude gwoo ngwẹja-ukfuru; ");
INSERT INTO iqw_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","mkpi lanụ, ee-gude gwoo ngwẹja iphe, dụ ẹji; ");
INSERT INTO iqw_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","oke-eswi ẹbo; ebyila ise; mkpi ise; waa ụnwu ebyila ise, gbatsụaru afa, ee-gude gwoo ngwẹja ẹhu-agu. Ono bụ iphe, Ahira Enanu gude bya anụ ndono. ");
INSERT INTO iqw_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Iphe ono bẹ bụ iphe, ndu ishi ndu Ízurẹlu gudetsua bya anụ t'e gude woru ẹnya-ngwẹja ono ye Nchileke l'ẹka; mbụ teke ono, a wụru iya manụ ono. Iphe, ẹphe nụru bụ: efere iri l'ẹbo, e meru lẹ mkpọla-ọcha; ochi iri l'ẹbo, e meru lẹ mkpọla-ọcha; waa agọ iri l'ẹbo, e meru lẹ mkpọla-ododo. ");
INSERT INTO iqw_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Efere lanụ b'e meru l'ụkporo mkpọla-ọcha ishingu lẹ mkpọla-ọcha iri; mee ochi lanụ l'ụkporo mkpọla-ọcha ẹto lẹ mkpọla-ọcha iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Agọ iri l'ẹbo ono, e meru lẹ mkpọla-ododo, e yejishikotaru ínsẹnsu eyejishi ono bẹ iphe, e gude mee ya bụ mkpọla-ododo iri iri. Mbụ mkpọla-ọcha, bụ: a -tụa ya atụtu; ẹra iya aha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ. Mkpọla-ododo, e gude mekota iphe ono l'ọha bẹ dụ ụkporo mkpọla-ododo ishingu. ");
INSERT INTO iqw_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Iphe, iphe bụ mkpakọ anụ, ee-gude gwoo ngwẹja-ukfuru dụkota bụ ụnwu oke-eswi iri l'ẹbo; ebyila iri l'ẹbo; ụnwu ebyila iri l'ẹbo, gbatsụaru afa yẹle ngwẹja-nri, tso iya nụ; waa mkpi iri l'ẹbo, ee-gude gwoo ngwẹja iphe-ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Anụ, ee-gude gwoo ngwẹja ẹhu-agu bẹ kpakọru dụ ụkporo oke-eswi l'oke-eswi ẹno; ụkporo ebyila ẹto; ụkporo mkpi ẹto; waa ụkporo ụnwu ebyila ẹto, gbatsụaru afa. Ono bụ iphe, a nụru t'e gude woru ẹnya-ngwẹja ono ye Nchileke l'ẹka teke ono, a wụru iya manụ ono. ");
INSERT INTO iqw_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Teke Mósisu bahụru lẹ Ụlo-Ẹ́kwà Ndzuko ono tẹ yẹle Ojejoje kfugbabe b'ọ nụru olu, e shi l'eli iphe, e gude kpuchia ẹke aanọduje akfụ ụgwo iphe, dụ ẹji kfuru yeru iya. Okfu ono b'a nọ lẹ mgbaku cherobimu ẹbo phụ kfua. Olu ono ekfuru yeru iya. ");
INSERT INTO iqw_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kfuru Érọnu; sụ iya teke oo-dobe urọku ẹsaa ono; t'o dobe iya; k'ọphu iphoro iya a-nga ifu iphe ono, a tukoberu iya ono.” ");
INSERT INTO iqw_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Érọnu emee ya ẹge ono, o kfuru ono; bya edobe urọku ono; k'ọphu iphoro iya ngashịru ifu iphe ono, a tukoberu iya ono, bụ iya bụ ẹge Ojejoje tụru Mósisu l'ekemu. ");
INSERT INTO iqw_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ọwaa bụ ẹge e gude mee iphe ono, aatukobeje urọku ono: Ọo mkpọla-ododo, a kụsaru akụsa b'e gude mekota iya shita l'ike iya jeye lẹ nchị iya. Iphe ono, aatukobeje urọku ono b'e meleruphu ẹge Ojejoje koshiru iya Mósisu. ");
INSERT INTO iqw_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ojejoje abya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“T'o shi l'ẹke ndu Ízurẹlu nọ fọfuta ndu Lívayi; mechaa ẹphe emecha. ");
INSERT INTO iqw_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ọwaa ẹge ii-shi mechaa ẹphe ndọ-ọ: Wota mini-ntụru phee ẹphe l'ẹhu; ẹphe akpụshikota iphe, bụ ẹji, nọ ẹphe l'ẹhu; sashịkota uwe ẹphe; shi ẹge ono mechaa onwẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","T'ẹphe wota nwa oke-eswi yẹle ngwẹja nri, tso iya nụ; bụ iya bụ akpe, e gweru egwegwe gwọkobe iya manụ. Nggụbe Mósisu ewota nwa oke-eswi ọdo, ee-gude gwoo ngwẹja iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Duru ndu Lívayi je l'ifu Ụlo-Ẹ́kwà Ndzuko; nggu ekukobe iphe, bụ ndu Ízurẹlu l'ẹphe ha t'ẹphe dzua l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Nggu eduru ndu Lívayi bya l'ifu Ojejoje. Ndu Ízurẹlu ebyibe ẹphe ẹka l'ishi. ");
INSERT INTO iqw_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Érọnu bẹ e-wota ndu Lívayi ono nụ yẹbe Ojejoje t'ẹphe bụru iya ngwẹja-amama, shi l'ẹka ndu Ízurẹlu; k'ọphu ẹphe a-nọdu ejeru yẹbe Ojejoje ozi. ");
INSERT INTO iqw_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Teke ono bẹ ndu Lívayi a-bya ebyibegbaa oke-eswi ono ẹka l'ishi; nggu egude oke-eswi lanụ gwoo ngwẹja iphe, dụ ẹji; gude ọphu gwoo ngwẹja-ukfuru nụ Ojejoje; shi ẹge ono kfụa ụgwo iphe, dụ ẹji ndu Lívayi. ");
INSERT INTO iqw_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Tẹ ndu Lívayi vudo l'ifu Érọnu yẹle ụnwu iya; nggu ewota ẹphe nụ Ojejoje t'ẹphe nọdu ọnodu ngwẹja-amama. ");
INSERT INTO iqw_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ono ẹge ii-shi dobe ndu Lívayi iche l'ẹke ndu Ízurẹlu ndu ọphu nọ ndono. Ndu Lívayi a-bụru kẹ yẹbe Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Teke i mechatsuaru ndu Lívayi ono; nggu ewofuta ẹphe dobe t'ẹphe dụ l'ọ bụ ngwẹja-amama ono; ẹphe ejelahaa ozi lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ọo ẹphebedua bụ ndu, e shi lẹ ndu Ízurẹlu nụ yẹbe Ojejoje. Ya wotawaru ẹphe t'ẹphe bụru nk'iya. Ya gudewa ẹphe dochia ẹnya ndu, bụ ọkpara l'alị Ízurẹlu gbaa mgburumgburu; mbụ iphe, bụ unwoke, vu ụzo waa nne ẹphe ọswa l'alị Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Iphe, bụ iphe, bụ oke ya, bụ iya vu ụzo waa nne iya ọswa l'alị Ízurẹlu gbaa mgburumgburu: m'ọ bụ madzụ; m'ọ bụ anụ bẹ bụkota kẹ yẹbe Ojejoje. Lẹ teke ono, ya gbushikotaru iphe, bụ ọkpara l'alị Íjiputu ono bẹ ya doberu ẹphe iche t'ẹphe bụru nk'iya. ");
INSERT INTO iqw_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nta-a bẹ ya wowaru ndu Lívayi t'ẹphe nọ-chia ẹnya ndu, bụ ọkpara l'alị Ízurẹlu gbaa mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ya shiwa lẹ ndu Ízurẹlu l'ẹphe ha wota ndu Lívayi nụ Érọnu yẹle ụnwu iya; t'ẹphe jeje ozi lẹ Ụlo-Ẹ́kwà Ndzuko l'ọzori ndu Ízurẹlu; ẹphe akfụje ụgwo iphe dụ ẹji, ụnwu Ízurẹlu meru; k'ọphu mgbọnwu ete egbudu ẹphe mẹ ẹphe -byaa ntse l'ẹke ono, dụ-nsọ ono.” ");
INSERT INTO iqw_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mósisu yẹle Érọnu; mẹ iphe, bụ ndu Ízurẹlu l'ẹphe ha abya emeru yeru ndu Lívayi ẹge ono, Ojejoje tụru iya Mósisu l'ekemu l'okfu ẹhu ndu Lívayi ono. ");
INSERT INTO iqw_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ndu Lívayi abya asashịa onwẹphe iphe, dụ ẹji, ẹphe meshiru; bya asashịa uwe ẹphe. Érọnu abya eworu ẹphe ye Ojejoje l'ẹka t'ẹphe dụ l'ọ bụ ngwẹja-amama; bya akfụa ụgwo iphe dụ ẹji, ẹphe meshiru; shi ẹge ono safu ẹphe ntụru. ");
INSERT INTO iqw_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","E metsua; ndu Lívayi abya anọdu Érọnu yẹle ụnwu iya l'ẹka wata oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. Yọ bụru ẹge Ojejoje tụru iya Mósisu l'ekemu bụ ẹge ẹphe meru ndu Lívayi ono. ");
INSERT INTO iqw_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ojejoje abya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Iphe-a bẹ bụ ndu Lívayi b'ọ dụru: Unwoke, nọwaru ụkporo afa l'afa ise tụgburu bẹ a-watajẹ oje ozi lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ẹphe -gbawa ụkporo afa ẹbo l'afa iri; ẹphe a-haa oje ozi, ẹphe shi eje l'ụlo-ẹ́kwà ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ọle; ọ -bụru l'ọ dụ onye ọbu t'o yeru ụnwunna iya ẹka l'ozi Ụlo-Ẹ́kwà Ndzuko ono; t'o yetajekwaru ẹphe ẹka. Obenu lẹ yẹbedua l'onwiya e-jebuhu ozi. Ọ bụ ẹge ono bẹ ii-shije nụ ndu Lívayi ozi, ẹphe a-nọduje eje.” ");
INSERT INTO iqw_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","L'ọnwa mbụ l'afa, kwe ndu Ízurẹlu afa ẹbo, ẹphe shi lẹ Íjiputu lụfuta bẹ Ojejoje kfuru yeru Mósisu l'echi-ẹgu Sáyịnayi; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Tẹ ndu Ízurẹlu gbakwaa Ajị Esweta l'oge iya. ");
INSERT INTO iqw_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ọnwa ọwaa -gbalẹphu abalị iri l'ẹno; unu gbaa Ajị Esweta ono l'oge iya. Teke unu a-wata iya agbagba bụ mẹ ẹnyanwu rịbadelephu. Unu gbaa ajị ono l'ẹge ekemu iya dụ; mẹ l'ẹge nsọ iya dụ.” ");
INSERT INTO iqw_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Tọ dụ iya bụ; Mósisu abya ekfuaru ndu Ízurẹlu t'ẹphe gbaa Ajị Esweta ono. ");
INSERT INTO iqw_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ẹphe agbaa Ajị Esweta ono l'echi-ẹgu Sáyịnayi l'ọnwa mbụ ono gbaru abalị iri l'ẹno; l'ẹnyanwu abyawa arịba. Ndu Ízurẹlu atụko iphemiphe ọbule ono mekota l'ẹge Ojejoje kfuru iya Mósisu. ");
INSERT INTO iqw_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ọle; o nwekwanuru ndu ọphu te tsodu gbaa Ajị Esweta ono mbọku ono. Ishi iya abụru lẹ mmeru nọ ẹphe l'ẹhu; kẹ l'ẹphe denyiru onye nwụhuru anwụhu ẹka. Ndu ono abyakfutashia Mósisu yẹle Érọnu mbọku ono; ");
INSERT INTO iqw_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","bya asụ Mósisu: “Lẹ mmeru nọkwa ẹphe l'ẹhu; kẹ l'ẹphe denyiru onye nwụhuru anwụhu ẹka. Ọ bụ; ?nanụ ẹge e meru te kwe t'ẹphe tsoru ndu Ízurẹlu ndu ọphu; nụ Ojejoje ngwẹja lẹ teke bụ oge iya?” ");
INSERT INTO iqw_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mósisu asụ ẹphe: “Unu ngabe tẹ ya maru iphe, Ojejoje e-kfu l'okfu ẹhu unu.” ");
INSERT INTO iqw_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Tọ dụ iya bụ; Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“T'o kfuaru ndu Ízurẹlu l'ọ -bụru l'o -nweru onye l'ime ẹphe; m'ọ bụ l'eri ẹphe, denyiru odzu ẹka; shi ẹge ono merua onwiya; ọ dụdu l'ọo iphe ọdo bẹ onye ọbu jeru bẹ onye ono a-gbalẹkwa-a Ajị Esweta kẹ Ojejoje ono. ");
INSERT INTO iqw_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Teke ẹphe a-gba iya bụ l'abalị iri l'ẹno l'ọnwa k'ẹbo; mẹ ẹnyanwu rịbadelephu. Iphe, ẹphe e-gude gbaa ya bụ: buredi, ẹ-te kodu ekoko; yẹle mkpẹkwo, atsọgbaa ile. ");
INSERT INTO iqw_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","T'ẹ b'ọ dụkwa iphe ono ọphu ẹphe a-ha t'ọ bọo nchi; ọphu ọ dụkwa ọkpu iya ọphu ẹphe a-nyakwo anyakwo. Ọ bụ ẹge ekemu Ajị Esweta ono dụkota bụ ẹge ẹphe e-gude gbaa ya. ");
INSERT INTO iqw_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ọle; onye mmeru ta nọdu l'ẹhu; to nwe ẹke o jeru; to tsokwanu gbaa Ajị Esweta ono bẹ ee-bufukwa ebufu l'ẹke ndibe ẹphe nọ; kẹ l'ẹ tọ nụdu Ojejoje ngwẹja iya l'oge iya. Ọ kwa onye ono bẹ iphe, dụ ẹji, o meru a-tukoru l'ishi. ");
INSERT INTO iqw_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘A -bya abya lẹ k'onye mbyamubya, unu l'iya bu ebubu: ọ -bụru l'onye mbyamụmbya ono bẹ chọru t'o tsoru unu gbaa Ajị Esweta kẹ Ojejoje; t'onye ọbu mekwaa ya ẹge ekemu iya; mẹ nsọ iya dụ. Ọ bụ nsọ lanụ, dụru onye a mụru amụmu l'alị-a; dụkwaruphu onye laru alala.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Mbọku ono, a kpọberu ụlo-ẹ́kwà Ojejoje, bụ iya bụ ụlo-ẹ́kwà, ẹke eedobeje ẹkwo ekemu Ojejoje bẹ urukpu byaru bya ekpuchia iya. Yo be l'urẹnyashi; urukpu ono adụlephu l'ọ bụ ọku l'eli ụlo-ẹ́kwà ono; dụ ẹge ono jeye l'ụtsu. ");
INSERT INTO iqw_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Yọ bụru ẹge ono b'ọ dụru kwasẹwaruru. O -be l'eswe; urukpu ono ekpuchia ụlo-ẹ́kwà Ojejoje ono. Teke o beru l'ẹnyashi; yọ chaa too l'ọ bụ ọku. ");
INSERT INTO iqw_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Yọ bụje teke urukpu ono shi l'eli ụlo-ẹ́kwà ono palihu imeli imeli; ndu Ízurẹlu awụ-lihu tụgbua. Ẹke ẹphe jeberu; urukpu ono keshiru; ẹphe akpọshia ụlo-ẹ́kwà ẹphe l'ẹke ono; nọshia. ");
INSERT INTO iqw_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Yọ bụje; Ojejoje -sụ ndu Ízurẹlu t'ẹphe palia ije; ẹphe awụ-lihu tụgbua. Teke ọ sụru t'ẹphe nọdu; ẹphe akpọshia ụlo-ẹ́kwà ẹphe; nọshia l'ọdu ndu Ízurẹlu ono. Yọ bụru ẹge urukpu ono nọ-beru l'eli ụlo-ẹ́kwà Ojejoje ono bụ ẹge ẹphe anọ-beje l'ọdu ụlo-ẹ́kwà ono. ");
INSERT INTO iqw_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Teke urukpu ono nọru anọno l'eli ụlo-ẹ́kwà Nchileke ono; ndu Ízurẹlu emee ẹge Ojejoje kfuru ẹphe; nọpyabe; ẹphe ta atụgbudu. ");
INSERT INTO iqw_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Teke ọ bụ l'urukpu ono nọru l'eli ụlo-ẹ́kwà Ojejoje ono; nọo ya nwujiku olemole; bụ Ojejoje -sụ ẹphe t'ẹphe nọdu; ẹphe akwaa l'ọdu ndu Ízurẹlu ono; nọshia. Ọ -sụ ẹphe t'ẹphe wụ-lihu; ẹphe awụ-lihu tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ọ -bụru l'urukpu ono nọru shita l'urẹnyashi jeye l'ụtsu; o -rua l'ụtsu; yọ palihu; ẹphe awụ-lihu tụgbua. Ọ -bụru l'eswe bẹ urukpu ono palihuru; m'ọ kwanu l'ẹnyashi bẹ bụlephu teke ọ palihuru; ndu Ízurẹlu awụ-lihu tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","M'o -ruhuduru urukpu ono nọdu l'eli ụlo-ẹ́kwà Ojejoje ono nọo ya abalị ẹbo; m'ọ bụ ọnwa lanụ; m'ọ bụ l'ọo afa ophu; ẹphe anọdu nọshia l'ọdu ndu Ízurẹlu ono ẹge ẹphe nọ iya. Obenu l'a -nọnyawaa; urukpu ono paliwa; ẹphe awụ-lihu; tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Yọ bụje; Ojejoje -sụ ẹphe t'ẹphe nọdu; ẹphe akwaa l'odu ụlo-ẹ́kwà ẹphe; nọshia. Teke ọ sụru ẹphe t'ẹphe tụgbua; ẹphe awụ-lihu tụgbua. Iphe, bụ iphe, Ojejoje kfuru ẹphe bẹ ẹphe mekotaru l'ẹge ọ tụru iya Mósisu l'ekemu. ");
INSERT INTO iqw_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“T'o gude mkpọla-ọcha, e tsusaru etsusa meta ụpyoku; k'ọphu oo-gudeje iya eku ndu Ízurẹlu t'ẹphe dzukoo; gudejekwa iya phụ kfuru ẹphe teke ẹphe a-phụtaje ụlo-ẹ́kwà ẹphe tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Teke e gburu ụpyoku labụ ono bụ iphe, ookfu bụ t'iphe, bụ ndu Ízurẹlu l'ẹphe ha dzua l'ifu nggụbe Mósisu l'ọnu Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ọ -bụru l'ọo ụpyoku lanụ nwẹnkinyi b'e gburu; iphe, ookfu bụ t'iphe, bụ ndu ishi, l'achịnu dzua l'ẹke, ịino; mbụ ndu ishi, achịgbaa ikfu l'ikfu ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Teke, e gburu ụpyoku ono ugbo lanụ; iphe, ookfu bụ t'iphe, bụ ikfu ndu ọphu kpọberu ụlo-ẹ́kwà ẹphe l'ụzo ẹnyanwu-ahata wụ-lihu tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Teke e gburu iya k'ugbo labụ; bụ iphe ọ bụ bụ tẹ ndu ọphu kpọru ụlo-ẹ́kwà nk'ẹphe l'ụzo ọhuda wụ-lihu; tụgbua. Ee-gbuje ụpyoku ono gude koshi teke ẹphe a-wụ-lihu; tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ọ -bụru l'unu eku ndu ọha t'ẹphe dzukoo; unu egbua ụpyoku ono. Ọle t'ẹ b'ọ dakwa l'ọ bụ ọphu e gude agba ama. ");
INSERT INTO iqw_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ọ bụ ụnwu Érọnu, bụ iya bụ ndu, achịjeru Nchileke ẹja e-gbuje ụpyoku ono. Yọ bụru ome-l'alị, a-dụru unu shita l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Teke ọ bụ l'unu eje otso ndu ọhogu unu ọgu l'alị unu; mbụ ndu akpa unu ẹhu; unu gbua ụpyoku ono t'ọ dashia ọda ike; k'ọphu Ojejoje, bụ Nchileke unu a-nyata unu; bya adzọfuta unu l'ẹka ndu ọhogu unu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ọ kwaphụ ẹge ono bẹ unu ee-gbuje ụpyoku teke ẹhu atsọ unu ẹna; teke unu agba Ajị Ọnwa Ọphungu; mẹ unu -gwotsulephu ngwẹja-ukfuru; mẹ ngwẹja ẹhu-agu, unu egwoje; k'ọphu Nchileke e-gude iya nyata unu. Ọo yẹbedua bụ Ojejoje, bụ Nchileke unu.” ");
INSERT INTO iqw_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Yo rua teke ọnwa k'ẹbo gbaru ụkporo abalị l'afa k'ẹbo ya; urukpu ono eshi l'eli ụlo-ẹ́kwà Ojejoje ono, bụ ẹke ẹkwo ekemu ono anọje palia. ");
INSERT INTO iqw_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ndu Ízurẹlu abya eshi l'echi-ẹgu Sáyịnayi ono; yọ bụru ẹphe atụgbu. Ẹphe ejee jeye l'echi-ẹgu Paranu; urukpu ono anọ-kirishia l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ono bụ kẹ mbụ, ẹphe tụgburu ije ẹphe ono; ẹge ono, Ojejoje tụru iya Mósisu l'ekemu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yọ bụru ndu onanu, ẹphe lẹ ndu ikfu Júda nọ lẹ ntso-lanụ ono; bụ ẹphebedua vutuaru ụzo; gude ẹkwa-ọhubama ndu ikfu ẹphe; yọ bụru ẹphe atụgbu. Náshọnu Amínadabu bụ onye ishi ndu ikfu Júda ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netanẹlu Zuwa bụ onye ishi ndu ikfu Ísaka; ");
INSERT INTO iqw_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliyabu Helọnu abụru onye ishi ndu ikfu Zébulọnu. ");
INSERT INTO iqw_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Tọ dụ iya bụ; a bya afọ-tsuta ụlo-ẹ́kwà Ojejoje ono; ụnwu Geshọnu; mẹ ụnwu Merari apata iya; yọ bụru ẹphe atụgbu. ");
INSERT INTO iqw_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ikfu ọdo, tsotaru ẹphe bụ ndu ono, ẹphe lẹ ndu ikfu kẹ Rúbẹnu gba lẹ ntso-lanụ ono. Ẹphe egude ẹkwa-ọhubama ndu ikfu ẹphe; yọ bụru ẹphe atụgbu. Elizuru Shediyọ bụ onye ishi ndu ikfu Rúbẹnu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumẹlu Zurishadayi bụ onye ishi ndu ikfu Símiyọnu; ");
INSERT INTO iqw_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ẹliyasafu Diyuwẹlu abụru onye ishi ndu ikfu Gádu. ");
INSERT INTO iqw_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Tọ dụ iya bụ; ndu ikfu Kohatu apata iphe ono, dụ nsọ ono tụgbua. Ẹphe erua; a kpọbewa nụ ụlo-ẹ́kwà Ojejoje ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ikfu ọdo, l'etsota nụ abụru ndu ono, ẹphe lẹ ndu ikfu Ífuremu gba l'odze lanụ ono. Ẹphe egude ẹkwa-ọhubama ndu ikfu ẹphe; yọ bụru ẹphe atụgbu. Elishama Amihudu bụ onye ishi ndu ikfu Ífuremu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalẹlu Pedazọ bụ onye ishi ndu ikfu Manásẹ; ");
INSERT INTO iqw_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidanu Gidiyọ́ni abụru onye ishi ndu ikfu Bénjaminu. ");
INSERT INTO iqw_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ikfu ọdo, l'etsota iya nụ; abụru ikfu ọphu ekpejeru azụ l'ije ono, bụ ndu ono ẹphe lẹ ndu ikfu Danu gba l'odze lanụ ono. Ẹphe egude ẹkwa-ọhubama ẹphe; yọ bụru ẹphe atụgbu. Ahiyeza Amishadayi bụ onye ishi ndu ikfu Dánu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagẹlu Ọkuranu bụ onye ishi ndu ikfu Ásha; ");
INSERT INTO iqw_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira Enanu abụru onye ishi ndu ikfu Náfutali. ");
INSERT INTO iqw_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ọ bụ ẹge ono bẹ ndu Ízurẹlu awụjeru l'odze l'odze tụgburu ije ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mósisu abya ekfuaru Hobabu Ruwẹlu, bụ onye Mídiya; mbụ onye ọgo iya ono; sụ iya: “Nta-a bẹ ẹphe atụgbuwa ala alị ono, Ojejoje kfuru ẹphe l'ọo-nụ ẹphe ono. Tsonuru ẹphe; ẹphe e-meru ngu-a ọhuma; kẹle Ojejoje kweshiwaru ndu Ízurẹlu ụkwa iphe, dụgbaa mma.” ");
INSERT INTO iqw_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu asụ iya: “Waawa; lẹ ya te ejedu. Ya alaphuwa azụ lakfu abụbu iya phẹ l'alị iya.” ");
INSERT INTO iqw_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Obenu lẹ Mósisu sụru iya: “Byiko; ba ahakwa ayi. Keshinu ọphu ị maru ẹke ayi a-kpọbeje ụlo-ẹ́kwà ayi l'echi-ẹgu-a; nọdunu tụ-zijeru ayi ụzo. ");
INSERT INTO iqw_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","I -tsoru ẹphe bẹ nggu l'ẹphe a-gbakwaru mgba l'iphe, bụ iphe-ọma, Ojejoje e-meru ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ya ndono; ẹphe eshi l'ugvu Ojejoje ono tụgbua; jee ije abalị ẹto. Okpoko Ọgba-ndzụ Ojejoje evutaru ẹphe ụzo l'ime abalị ẹto ono; k'ọphu ọo-chọ-vuru ẹphe ẹke ẹphe a-nọdu tụta ume. ");
INSERT INTO iqw_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Yọ bụje; o -be l'eswe; urukpu, shi l'ẹka Ojejoje abya atụkoru ẹphe l'ishi; teke ono, ẹphe shi l'ọdu ndu Ízurẹlu atụgbu ono. ");
INSERT INTO iqw_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Teke e vutaleruphu Okpoko Ọgba-ndzụ ono tụgbua; Mósisu asụ: “Zilihu nggụbe Ojejoje. Tẹ ndu ọhogu ngu gbakashịhukwa nanụ nanụ. Tẹ ndu ono, ị dụ ashị ono shikwa ngu l'ifu gbakashịhu.” ");
INSERT INTO iqw_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Teke a pazetaru Okpoko Ọgba-ndzụ ono; Mósisu asụ: “Laphuta azụ nggụbe Ojejoje; lakfuta ụnukurunu ndu Ízurẹlu-a.” ");
INSERT INTO iqw_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Tọ dụ iya bụ; ndu Ízurẹlu awata ọgu aphụ k'iphe-ẹhuka, ẹphe eje. Aphụ ono, ẹphe agụ ono abya erua Ojejoje nchị; ẹhu eghulahaa ya eghughu. Ojejoje eye ọku; yọ bya ekekota ọdu ndu Ízurẹlu ndu ọphu nọfuru anọfu. ");
INSERT INTO iqw_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ndu Ízurẹlu abya araku Mósisu; yo kfuru nụ Ojejoje. Ọku ono anyịshihu. ");
INSERT INTO iqw_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ọo ya meru; a wata oku ẹke ono Tabera; kẹ l'ọku, shi Ojejoje l'ẹka bya ekee ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","O nweru igweligwe ndu ọdo, ẹ ta bụdu ndu Ízurẹlu, ẹphe l'ẹphe tso l'ije ono. Ndu ono awata ọra kẹ nri. Ndu Ízurẹlu ẹphebedua awata ọra ẹkwa anụ. ");
INSERT INTO iqw_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Sụ: “L'ẹphe nyataru teke ẹphe shi nọdu lẹ Íjiputu. Teke ono bẹ ẹphe shi anọduje ata anụ ẹma kẹ mmanu; l'ata kukumba; akpụru-iphe; liku; alịbasa; mẹ galiku. ");
INSERT INTO iqw_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ọle nta-a b'ẹ t'ọ dụhedu iphe, agụjekwadu ẹphe agụgu; ọphu ọ dụdu iphe, ẹphe aphụjekwadu ria; gbahaa mana-a!” ");
INSERT INTO iqw_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana bẹ ụgbugba iya dụ l'ọ bụ akpụru koriyanda. I -lee ya ẹnya; yọ nyaku anyakụ; l'eshi mkpọ l'ọ bụ etse bedelọmu. ");
INSERT INTO iqw_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ndu Ízurẹlu l'ejeje je ekpokoo ya; gwee ya egwegwe; m'ọ kwanụ tsua ya etsutsu l'ikwe. Ẹphe ahajẹru shia ya eshishi; m'ọ kwanụ ghee ya egheghe. Ọonoduje atsọ l'ọ bụ iphe, e gude manụ olivu ghee. ");
INSERT INTO iqw_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Teke mana ono adajẹru ẹphe bụ teke iji datsụaru l'ọdu ndu Ízurẹlu ono l'ẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mósisu abya anụa ẹge ndu Ízurẹlu wụshigbaaru l'ọnu ụlo-ẹ́kwà ẹphe l'ara ẹkwa; ẹhu akwata ghushilahaa Ojejoje eghughu ike. Yọ tsụlahaa Mósisu l'ẹhu. ");
INSERT INTO iqw_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mósisu ajịa Ojejoje iphe, kpataru iphe, o wokfutaru yẹbe nwozi iya egbe iphe-ẹhuka ọwaa? “?Nanụ ẹge ya mekataru nggụbe Ojejoje, kparu iphe, ị pataru ivu ẹhu ndu-a l'ẹphe ha bo iya? ");
INSERT INTO iqw_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","?Bụ yẹbedua yeshiru ime ndu-a l'ẹphe ha. ?Tọo ya mụshiru ẹphe. ?Bụ ngụnu meru iphe ị sụru tẹ ya heru ẹphe l'ọ bụ onye he nwata jeye teke ya e-heru ẹphe l'alị ono, i kweru ụkwa iya; bya eribua nte l'ịi-nụ nna ẹphe ono? ");
INSERT INTO iqw_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Tekenteke bẹ ndu-a anọduje ararụ iya ẹkwa anụ. ?Bụ awe bẹ ya a-phụ anụ, ya a-nụ ndu-a l'ẹphe ha? ");
INSERT INTO iqw_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ya ta adụkwa ike ohekota ndu-a nwẹnkinyi iya; ivu ẹhu ẹphe anyị-gbuakwa iya anyị-gbu. ");
INSERT INTO iqw_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ọ -bụru l'ọo ẹge-a bẹ ii-mee iya; gbuchikwaa ya egbugbu nta-a. Ọ -bụru lẹ ya nọ ngu-a l'obu; tẹ ya ba anọdukwa ndzụ gude ẹnya iya phụ ẹjo ọnodu iya.” ");
INSERT INTO iqw_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ojejoje abya eyeeru Mósisu ọnu; sụ iya: “Chịta ndu bụ ọgurenya Ízurẹlu ụkporo madzụ ẹto lẹ madzụ iri t'ẹphe byakfuta iya. Ndu ono a-bụ ndu ị hụberu ama l'ẹphe bụphu ndu bụ ọgurenya; bụru ndu ishi ẹphe. Chịta ẹphe tẹ nggu l'ẹphe bya evudo lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ya e-nyizita byakfuta ngu l'ẹke ono; nggu l'iya ekfugba; ya aharu ume, nọ ngu l'ẹhu habọta woru ye ndu ono l'ẹhu; k'ọphu ẹphe e-yeta ẹka vuede ngu ivu ono; t'ẹ b'i vuhe iya nkịnyi ngu. ");
INSERT INTO iqw_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Nggu ekfuaru ndu Ízurẹlu t'ẹphe dobe onwẹphe iche kwabẹru echile; l'o -rua echile bẹ ẹphe a-ta anụ. Ishi iya bụ lẹ yẹbe Ojejoje bẹ nụwaru ẹkwa ono, ẹphe shi ara; l'ajị onye a-nụ ẹphe anụ t'ẹphe taa ono? Lẹ teke ẹphe shi nọdu lẹ Íjiputu b'o shikwa karu ẹphe mma. Nta-a bẹ Ojejoje a-nụ ẹphe anụ t'ẹphe taa. ");
INSERT INTO iqw_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Anụ ono ta bụkwa anụ k'ujiku lanụ; tọ bụ k'ujiku ẹbo; tọ bụ k'ujiku ise; tọ bụ k'ujiku iri; tọ bụ k'ujiku ụkporo. ");
INSERT INTO iqw_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Unu a-ta anụ ono ọnwa ophu; taa ya jeye; yo shi unu l'imi ebushihu ebushihu; mbụ jeye yọ tụshihu unu; kẹ l'unu jịkaru Ojejoje, bụ onye swiru unu; unu ararụ ẹkwa kpua ya; l'ajị iphe menarua bẹ ẹphe shi lẹ Íjiputu lụfuta?” ");
INSERT INTO iqw_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mósisu asụ Ojejoje: “T'ọ phụwaru l'ọ kwa ụkporo ụnu madzụ ugbo ụkporo ẹto; l'ụkporo ụnu madzụ iri l'ise bẹ ẹphe l'iya gude ọkpa eje ẹge-a. Yọ bụru ẹphe b'ị sụru l'ịi-nụ anụ, ẹphe a-ta ọnwa ophu. ");
INSERT INTO iqw_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","E -gbushigee atụru; mẹ eswi, nọnu; ?oo-dzu ẹphe tọo? Mbụ; ọ -bụru l'e gbushikotaru ẹphe ẹma, nọkota l'eze ẹnyimu; ?oo-dzu ẹphe tọo.” ");
INSERT INTO iqw_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ojejoje asụ Mósisu: “Ẹka yẹbe Ojejoje; ?ọodu mkpirikpi tọo. Nta-a bẹ ịi-phụ mẹ iphe, ya kfuru; doo-me t'ẹ to medu tọo.” ");
INSERT INTO iqw_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ya ndono; Mósisu alụfu je ekfuaru ndu Ízurẹlu iphe, Ojejoje kfuru. Yọ chịta ndu bụ ọgurenya ụkporo ẹto l'iri ono; ẹphe abya evudo; gbaa ụlo-ẹ́kwà Nchileke ono mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ya ndono; Ojejoje egude urukpu nyizita bya ekfuru yeru Mósisu; bya habọta ume, nọ Mósisu l'ẹhu; ye ndu bụ ọgurenya ụkporo ẹto l'iri ono l'ẹhu. Teke ume ono byaru ẹphe l'ẹhu bẹ ẹphe wataru okfuchiru Nchileke. Ọ bụ l'ẹphe te kfudu iya tụgburu. ");
INSERT INTO iqw_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Obenu l'o nweru ụmadzu ẹbo ọdo, kwaru l'ụlo-ẹ́kwà ẹphe. Onye lanụ bụ Ẹludadu. Onye ọphu abụru Medadu. Ẹphe tso lẹ ndu bụ ọgurenya, e deshiru iya; ọbu l'ẹphe te tsodu jee l'ụlo-ẹ́kwà Nchileke. Obenu lẹ Ume ono byalẹru-a bya eji ẹphe ẹhu; ẹphe anọdu l'ụlo-ẹ́kwà ono; kfuchilahaaru Nchileke. ");
INSERT INTO iqw_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Nwata-okoro lanụ agbagbụa je asụ Mósisu: “Lẹ Ẹludadu yẹle Medadu nọkwa l'ọdu ndu Ízurẹlu ekfuchiru Nchileke.” ");
INSERT INTO iqw_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Jóshuwa Nunu, bụ onye shi teke ọ bụ nwata jetaru Mósisu ozi atụfulekwaphu ọnu; sụ: “Nggụbe onye nwe mu nụ, bụ Mósisu; kfunuru ẹphe t'ẹphe dobe ọnu ndo.” ");
INSERT INTO iqw_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mósisu asụ iya: “?L'iikoru iya okopho tọo? Ọ gẹge adụ iya mma; ndẹge ndu kẹ Ojejoje l'ẹphe ha gbe bụkotaru ndu nkfuchiru; mbụ tẹ Ojejoje yekota ẹphe Ume nk'iya l'ẹhu.” ");
INSERT INTO iqw_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","E metsua; Mósisu yẹle ndu bụ ọgurenya Ízurẹlu ono alaphushia azụ l'ọdu ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ya ndono; phẹrephere abya eshi l'ẹke Ojejoje nọ phelahaa. Yo shi l'eze ẹnyimu chịkashia ọ̀kwà; ẹphe abya adashịa lẹ mgboro ọdu ndu Ízurẹlu ono. Ẹphe atụko ẹke ono l'ọ ha dzuru rua iphe, ha l'ọ bụ ẹke madzụ a-dụ ike jee l'ọkpa ujiku lanụ. Ẹge ẹphe epheberu l'eli bụ iphe, ruru ntụ-ọkpa ẹto m'e shi l'alị l'agụ iya. ");
INSERT INTO iqw_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mbọku ono l'ọ ha; mẹ echile iya: eswe l'ẹnyashi; bẹ ẹphe tsoru je anwụkoo ọ̀kwà ono. Onye nwụtanukaru nwanshị; bẹ anwụ-jije ụkporo efere nkwo-ẹka ise. Ẹphe eworu iya kpasaa t'ọ kpọhu nkụ. Yọ tụko ọdu ndu Ízurẹlu ono dzuru. ");
INSERT INTO iqw_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ẹphe akpụkwadurua anụ ono l'ọnu ata; ẹhu awata oghu Ojejoje eghughu l'ẹke ndu Ízurẹlu nọ. Yo meru ẹjo mgbọnwu tụ ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","E kulahaa ẹke ono Kíburọtu Hatava; kẹ l'ọo l'ẹke ono b'e liru iphe, bụ ndu kụru photophoto nri. ");
INSERT INTO iqw_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ẹphe eshi lẹ Kíburọtu Hatava l'ẹke ono tụgbua jeshia Házerọtu je anọshia. ");
INSERT INTO iqw_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Tọ dụ iya bụ; Miriyamu yẹle Érọnu awata okfuru Mósisu ẹji lẹ kẹ nwanyi Kúshi, ọ lụru. Ishi iya abụru lẹ Mósisu lụru nwanyi Kúshi. ");
INSERT INTO iqw_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ẹphe asụ: “?Bụ Mósisu nwẹnkinyi bẹ Ojejoje eshije l'ọnu iya kfua okfu tọo? ?Too shidua ẹphebedua l'ọnu kfuaa okfu tọo?” Ojejoje anụa iphe ono, ẹphe kfuru ono. ");
INSERT INTO iqw_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mósisu l'onwiya bụnukaru onye odoo. Ọo ya katsụkpo ometa odoo lẹ mgboko gbaa mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","E ji ekfu-a; Ojejoje ekfuaru Mósisu yẹle Érọnu; mẹ Miriyamu; sụ ẹphe t'ẹphe lụfuta; bya lẹ Ụlo-Ẹ́kwà Ndzuko ono. Ẹphe ẹto ono abya alụfuta jeshia. ");
INSERT INTO iqw_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tọ dụ iya bụ; Ojejoje anọdu l'urukpu, kpụru oronmono nyizita bya evudo l'ọnu ụlo-ẹ́kwà ndzuko ono; kua Érọnu yẹle Miriyamu t'ẹphe bya. Ẹphe erutalephu ntse l'ẹke ono; ");
INSERT INTO iqw_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ojejoje asụ ẹphe t'ẹphe ngabẹ nchị nụa iphe, ya ekfu: “L'ọobuje; unu l'onye nkfuchiru -nọdu; ya eshi l'àphụ̀ koshi iya onwiya; shi lẹ nrọ kfuru yeru iya. ");
INSERT INTO iqw_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Obenu l'ẹ tọ dụdu ẹge ono l'ẹke nwozi iya; mbụ Mósisu nọ. Ọo ya bẹ ya wokotaru ndibe iya l'ẹphe ha ye l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ọo yẹbedua bẹ yẹle iya anọduje l'ifu l'ifu l'ekfu. Ẹphe egudeje okfu, doru ẹnya l'ekfu eyeru onwẹphe. Ẹphe te egudejedu ẹtu-okfu ekfu eyeru onwẹphe. Ọophuje ẹge yẹbe Ojejoje gbaru ụgbugba. ?Bụ ngụnu meru iphe unu etso nwozi iya; mbụ Mósisu okfu; unu ta tsụ egvu?” ");
INSERT INTO iqw_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ojejoje atukoshi ẹphe ẹhu-eghughu iya; yọ bụru iya atụgbu. ");
INSERT INTO iqw_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Yọ bụru l'urukpu ono shi l'eli ụlo-ẹ́kwà ono palia; b'a bya amaru; Miriyamu egbe bụwarunu onye ẹhu-labụ; ẹhu achahụwa iya nụ oswi kẹ phorophoro. Érọnu abya elee Miriyamu ẹnya; phụ ẹge ẹhu-labụ tụkowa iya nụ ẹhu gvuru; ");
INSERT INTO iqw_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","bya asụ Mósisu: “Onye nwe mu nụ; be egudekwa kẹ iphe dụ ẹji, ayi meru l'ẹ b'a ama amama; nụa ayi aphụ. ");
INSERT INTO iqw_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Be ekwekwa tẹ Miriyamu dụ l'ọ bụ nwata, a bya bya amụ; yọ nwụhuwa; reshihu nne iya l'ẹpho.” ");
INSERT INTO iqw_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tọ dụ iya bụ; Mósisu abya araku Ojejoje; sụ iya: “Byiko; nggụbe Nchileke; menua ya t'ọ ka mma!” ");
INSERT INTO iqw_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ojejoje asụ Mósisu: “Ọ -bụru lẹ nna nwanyi-a vụru ọnu-mini kpua ya l'ifu; ?iphere iya ta ga dụdu iya abalị ẹsaa tọo. Shi l'ọdu ndu Ízurẹlu chịfu iya; t'o je anọo abalị ẹsaa l'ẹke ono. Ọ -nọtsulephu abalị ẹsaa ono; yọ lata azụ.” ");
INSERT INTO iqw_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Tọ dụ iya bụ; a bya eshi l'ọdu ndu Ízurẹlu ono nwufu Miriyamu. Yọ nọo l'ẹke ono abalị ẹsaa; ọphu ndu Ízurẹlu 'alụfudu alụfu jeye teke e duphutaru iya azụ. ");
INSERT INTO iqw_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","E metsua; ẹphe eshi lẹ Házerọtu l'ẹke ono lụfu je akpọo ụlo-ẹ́kwà ẹphe l'echi-ẹgu Paranu. ");
INSERT INTO iqw_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ojejoje asụ Mósisu ");
INSERT INTO iqw_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“T'o ye ndu e-je ngge l'alị Kénanu; mbụ alị ono, ya eme tẹ ya nụ ndu Ízurẹlu ono. T'o shi l'iphe, bụ ikfu ndiche ẹphe fọtatsua onye lanụ, e-je nụ. Ndu ọo-fọta bụ unwoke, bụgbaa ishi l'ikfu, nọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mósisu abya eyefu ẹphe ẹge ono, Ojejoje kfuru ono; ẹphe eshi l'echi-ẹgu Paranu tụgbua. Ndu ono, o yeru ono bụkota ndu ishi ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ọwaa bụ ẹpha ẹphe: Onye shi l'ikfu kẹ Rúbẹnu bụ Shamuwa Zaku; ");
INSERT INTO iqw_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","onye shi l'ikfu kẹ Símiyọnu abụru Shafatu Hori. ");
INSERT INTO iqw_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Onye shi l'ikfu kẹ Júda bụ Kálẹbu Jefune; ");
INSERT INTO iqw_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","onye shi l'ikfu kẹ Ísaka abụru Igalu Jósẹfu. ");
INSERT INTO iqw_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Onye shi l'ikfu kẹ Ífuremu bụ Hosáya Nunu; ");
INSERT INTO iqw_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","onye shi l'ikfu kẹ Bénjaminu abụru Paliti Ráfu. ");
INSERT INTO iqw_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Onye shi l'ikfu kẹ Zébulọnu bụ Gadiyẹlu Sodi; ");
INSERT INTO iqw_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","onye shi l'ikfu kẹ Manásẹ, bụ iya bụ ikfu kẹ Jósẹfu abụru Gadi Susi. ");
INSERT INTO iqw_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Onye shi l'ikfu kẹ Dánu bụ Amiyẹlu Gemali; ");
INSERT INTO iqw_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","onye shi l'ikfu kẹ Ásha abụru Sẹtu Máyikelu. ");
INSERT INTO iqw_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Onye shi l'ikfu kẹ Náfutali bụ Nahubi Vofusi; ");
INSERT INTO iqw_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","onye shi l'ikfu kẹ Gádu abụru Geyuwẹlu Maki. ");
INSERT INTO iqw_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ono bụ ẹpha unwoke ono, Mósisu yeru t'ẹphe je ngge l'alị Kénanu ono. Hosáya Nunu bẹ Mósisu gụru Jóshuwa. ");
INSERT INTO iqw_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mósisu abya ezia ẹphe t'ẹphe je ngge l'alị Kénanu; sụ ẹphe: “Unu tsoru echi-ẹgu, nọ l'ụzo ọhuda bahụ l'alị ugvu l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Unu je amaru ẹge alị ono gbaru; unu amaru ẹge ndu bu iya nụ dụ. Unu maru mẹ ẹphe bụ ndu ike nọ; t'ẹphe bụ ndu ike ta nọdu; unu amaru mẹ ẹphe dụ l'igwe; t'ọo l'ẹphe habe nwahabe. ");
INSERT INTO iqw_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Unu amaru egbe alị ẹke ẹphe bu: ?bụ alị, dụ mma; tọo alị, dụ ẹji. Unu amaru egbe mkpụkpu, ẹphe bugbaa: ?bụ mkpụkpu, gheru ọnu; tọo mkpụkpu, a kpụru ụpho-mkpuma ");
INSERT INTO iqw_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Unu amaru ẹge alị ẹphe dụ. Unu amaru bụ alị emehuje iphe; t'ẹ t'ọ bụdu. Unu amaru mẹ oshi nọ iya; ?tẹ tọo nọdu iya. T'obu shihukwa unu ike; unu egude akpụru oshi, shi l'alị ono lata.” Teke ono bụ oge, akpụru vayịnu anọduje acha. ");
INSERT INTO iqw_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ya ndono; ẹphe atụgbua jeshia je egekota alị ono ngge; shita l'echi-ẹgu Zinu je akpaa lẹ Rehobu l'ụzo Lebo-Hámatu. ");
INSERT INTO iqw_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ẹphe etsoru echi-ẹgu, nọ l'ụzo ọhuda jeye ẹphe erua Hẹ́buronu, bụ ẹke Ahimanu; Sheshayi; mẹ Talumayi, bụ ndu shi l'eri Anaku bu. (A kpụru mkpụkpu Hẹ́buronu; yọ nọo afa ẹsaa; b'a kpụderu mkpụkpu Zowanu ọphu nọ l'alị Íjiputu.) ");
INSERT INTO iqw_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ẹphe ejerulephu lẹ nsụda Ẹshukolu; gbukwota ẹkali vayịnu lanụ, akpụru wọkfuru awọkfuru. Ụmadzu ẹbo l'ime ẹphe epyokafu iya l'oshi, dụ ogologo paru; onye lanụ aparu iya l'ishi lanụ; onye ọphu aparu iya l'ishi iya ọphu. Ẹphe awọkokwaaphu akpụru ụtara-okumu; mẹ akpụru figu wolata. ");
INSERT INTO iqw_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","A gụa ẹke ono nsụda Ẹshukolu; kẹ l'ọ bụ l'ẹke ono bẹ ndu Ízurẹlu gbukwotaru ẹkali vayịnu, akpụru wọkfuru awọkfuru vulata. ");
INSERT INTO iqw_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Iphe ẹphe nọru l'ẹphe jeru ngge l'alị ono bụ ụkporo abalị ẹbo bẹ ẹphe ladẹru. ");
INSERT INTO iqw_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ẹphe abya alakfuta Mósisu mẹ Érọnu; mẹ ndu Ízurẹlu l'ẹphe ha l'echi-ẹgu Paranu lẹ mkpụkpu Kadẹ́shi. Ẹphe abya edooru Mósisu; mẹ Érọnu; mẹ ndu Ízurẹlu l'ẹphe ha ẹge ẹphe jeru iya; bya ekoshi ẹphe akpụru oshi, shi alị ono; ");
INSERT INTO iqw_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","bya asụ Mósisu: “Lẹ ẹphe jewaru je aphụ alị ono, ị sụru t'ẹphe je aphụ ono. Alị ono bụ alị, emehuje iphe; bya abụru alị, iphe nọ. Ọwaa akpụru oshi, shi l'alị ono ndọ-ọ. ");
INSERT INTO iqw_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ọle ndu bu l'alị ono bẹ ike nọ; mkpụkpu, nọ iya nụ hagbaa nshinu; bya abụru mkpụkpu, e gude ụpho-mkpuma; kpụ-phee mgburumgburu. Ẹphe phụtsuaruru ndu shi l'eri Anaku l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ndu Amalẹku bu l'alị, nọ l'ụzo ọhuda. Ndu Hetu; ndu Jebusu; mẹ ndu Amọru eburu l'alị ugvu l'ẹke ono. Ndu kẹ Kénanu bunyabe eze ẹnyimu; bukwaruphu l'iku Ẹnyimu Jọ́danu.” ");
INSERT INTO iqw_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tọ dụ iya bụ; Kálẹbu abya emee ndu Ízurẹlu; ẹphe adaa shịkongu l'ifu Mósisu; bya asụ ẹphe: “Unu t'ẹphe je alụta alị ono t'ọ bụru nk'ẹphe; kẹ l'ẹphe a-dụa ike lụta iya.” ");
INSERT INTO iqw_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Obenu lẹ ndu ono, ẹphe lẹ Kálẹbu yị jee ije ono sụru l'ẹphe ta adụkwa ike oje otso ndu ono ọgu; kẹ l'ẹphe kakwa ẹphe ike. ");
INSERT INTO iqw_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ozi, ẹphe byaru bya ezia ndu Ízurẹlu lẹ k'alị ono, ẹphe jeru ngge ono abụru ẹjo iya. Ẹphe sụru: “L'alị ono, ẹphe jeru ngge ono bẹ egbushikwa ndu bu iya nụ. Ndu ẹphe phụkotaru l'ẹke ono bụkotakwa ndu hagbaa ẹjo ahaha. ");
INSERT INTO iqw_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ẹphe phụru ndu gbaru mkparawa, shi emeje iphe-kpaa l'ẹke ono. (Ndu ono bụ ndu eri Anaku.) Ẹphe dehutsukwaaru onwẹphe edehu l'ẹnya; dụgbaa onwẹphe l'ọ bụ ụnwu ogu l'ẹnya. Yọ bụru ẹge ono bẹ ẹphe dụ ndu ono.” ");
INSERT INTO iqw_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tọ dụ iya bụ; ndu Ízurẹlu l'ẹphe ha arakọta ẹkwa l'ẹnyashi ono rashịa ya ike. ");
INSERT INTO iqw_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ẹphe l'ẹphe agụlahaaru Mósisu yẹle Érọnu aphụ; sụ: “L'ọ ga akakwaru ẹphe mma l'ẹphe nwụshihuru l'alị Íjiputu; m'ọ kwanụ l'echi-ẹgu-a! ");
INSERT INTO iqw_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","?Bụ ngụnu meru iphe Ojejoje eme t'o duru ẹphe je edobe l'alị ono t'e gbushia ẹphe? Unyomu ẹphe; mẹ ụnwegirima ẹphe a-bụru ndu a kpụru lẹ ndzụ. ?Tọ ga akadụru ẹphe mma l'ẹphe daphu azụ lẹ Íjiputu?” ");
INSERT INTO iqw_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ẹphe ekfulahaaru onwẹphe: “T'ẹphe fọta onye lanụ; mee ya onye ishi t'o duru ẹphe laphu azụ lẹ Íjiputu.” ");
INSERT INTO iqw_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mósisu yẹle Érọnu adaa kpube ifu l'alị; l'echi ẹke ono, ndu Ízurẹlu l'ẹphe ha dzuru edzudzu ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jóshuwa Nunu; mẹ Kálẹbu Jefune, tso lẹ ndu ono, jeru ngge lẹ Kénanu ono egude ẹhu-eghughu lajashịa uwe, ẹphe yeru l'ẹhu; ");
INSERT INTO iqw_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","sụ ndu Ízurẹlu ono l'ẹphe ha: “L'alị ono, ẹphe jeru ngge ono bụkwa alị, dụshikpoo mma ike. ");
INSERT INTO iqw_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ọ -bụru l'ẹphe dụ Ojejoje mma l'obu bẹ oo-du ẹphe durua alị ono; mbụ ẹgiri alị ono; nụ iya ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ọ bụlephu t'unu be kwefukwaru Ojejoje íkè. Ọdo abụru t'unu ba atsụkwa ndu alị ono egvu; kẹ l'ẹphe te gbe dzudu ayi ọkori ụtsu. Ẹphebedua te gbe nwedu onye egbochita ẹphe; ayịbedua bẹ Ojejoje nọ swiru eswiru. Ọo ya bụ; t'unu ba tsụshi ẹphe egvu.” ");
INSERT INTO iqw_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Obenu l'iphe bụ ndu Ízurẹlu ono l'ẹphe ha bẹ sụru t'a tụ-gbushia Mósisu phẹ lẹ mkpuma. Tọ dụ iya bụ; ọdu-biribiri kẹ Ojejoje abya enwuaru ndu Ízurẹlu l'ẹphe ha kẹ phoo lẹ Ụlo-Ẹ́kwà Ndzuko ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ojejoje abya ekfuru yeru Mósisu; sụ iya: “?Bụ jeye teke ole bẹ ndu-a a-ha iya ọkpo ẹbo-ẹbo-l'afụ? ?Bụkpo teke ole bẹ ẹphe a-jịka-beru okweta nk'iya; yekwaru iphe-ọphulenya ono, ya meshibeberu l'ẹke ẹphe nọ ono? ");
INSERT INTO iqw_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ya e-gude iphe-ememe gbuchafu ẹphe; woru ẹphe mebyishia. Ọle nggụbedua l'onwongu bẹ ya e-mee t'ị bụru ọha, ha nshinu; bya aka ẹphebedua agburu-ẹhu.” ");
INSERT INTO iqw_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mósisu asụ Ojejoje: “Lẹ ndu Íjiputu a-nụkwa iya m'i -mee ya ẹge ono. Nyatakwa l'i gude ike ngu; shi l'ẹke ndu Íjiputu nọ dufuta ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ẹphe e-kfukwaru iya ndu, bu l'alị-a; kẹ l'ẹphe nụkotawaru lẹ nggụbe Ojejoje swiru ẹphe eswiru; nụwa l'ẹphe egudeje ẹnya ẹphe phụa nggụbe Ojejoje; mẹ l'urukpu nke ngu bẹ anọduje ẹphe l'eli. Yọ buje; o -rua l'eswe; nggu egude urukpu, kpụru oronmono l'edu ẹphe; o -rua l'ẹnyashi; nggu egude ọku, kpụru oronmono edukwaphu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","I -gbushia ndu-a ugbo lanụ nta-a bẹ ọha ono, nụhawaru ụdu ngu ono a-sụkwa: ");
INSERT INTO iqw_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Lẹ nggụbe Ojejoje ta dụhedu ike durua ẹphe l'alị ono, i kweru ẹphe ụkwa iya; ribua ya lẹ nte l'ịi-nụ ẹphe ono; nggu egbe woru ẹphe gbushia l'echi-ẹgu.’ ");
INSERT INTO iqw_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Nta-a; nggụbe Nnajiufu; ya ekfu anụ ngu sụ t'i koshinu eze ike ngu ono; mbụ ono, i kweru ụkwa; sụ: ");
INSERT INTO iqw_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Lẹ Ojejoje ta bụkwa agụ-ọnwuu. Ọ bụ onye n-yemobu iya kariru akari; onye agụje nvụ l'iphe, dụ ẹji; mẹ l'íkè, ekwefuru iya. Obenu l'ọ bụkwaphu onye ta ahajẹdu onye ikpe nmaru t'ọ laa kẹ mmanu. Ọohuje ụnwegirima àhụ̀hù k'iphe, dụ ẹji, ndu mụru ẹphe nụ meru jeye l'ọgbo k'ẹto rua lẹ k'ẹno.’ ");
INSERT INTO iqw_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Gudenu obu-imiko ngu ono, nyịberu anyịbe ono gụaru ndu-a nvụ l'iphe, dụ ẹji, ẹphe meru ngu; mbụ ẹge ono, i shi l'alị Íjiputu gụtaru ẹphe nvụ jeye nta-a ono.” ");
INSERT INTO iqw_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ojejoje abya ekfuru yeru Mósisu; sụ iya: “Lẹ ya gụwaru ẹphe nvụ l'ẹge o kfuru. ");
INSERT INTO iqw_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ọle; lẹ ndzụ-a, ya nọnu-a; ọdu-biribiri iya edzuru mgboko ẹge o dzuru iya-a; ");
INSERT INTO iqw_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","b'ẹ t'ọ dụdu onye ọphu gudewa ẹnya iya phụa ọdu-biribiri iya; mẹ iphe-ọphulenya ono, ya meshiru l'alị Íjiputu ono; mẹ ọphu ya meshiru l'echi-ẹgu; mbụ ndu ono, metsuaru bya adata iya ugbo iri; ọphu ẹphe 'angadụru iya nchị ono; ");
INSERT INTO iqw_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ẹ tọ dụdu m'ọo onye lanụ l'ime ẹphe e-gude ẹnya iya phụ alị ono, ya riburu nte; kwe nna ẹphe ụkwa iya ono. Ọphu ọ dụdu iphe, bụ ndu kpọru iya ẹbo-ẹbo-l'afụ, a-phụ ya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ọle; a -bya l'ẹhu kẹ nwozi iya ono; mbụ Kálẹbu; keshinu ọphu ọ bụ onye obu iya gbaru iche; bụru onye gude obu iya l'ọ ha l'etso yẹbe Ojejoje bẹ ya e-duru iya bahụ l'alị ono, o jeru ngge ono. Yọ bụru eri iya bẹ e-nweru alị ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ọo ya bụ; keshinu ndu Amalẹku; mẹ ndu Kénanu bu lẹ nsụda nsụda; o -rulephu echile; unu ghakọbe shia ụzo echi-ẹgu ono, nọ l'ụzo, e shi eje Eze Ẹnyimu Uswe ono.” ");
INSERT INTO iqw_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ojejoje abya ajị Mósisu yẹle Érọnu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“?Bụ teke ole bẹ ndu ẹjo-obu-wa a-gụ-buhuru iya aphụ? Ya nụkotawaru aphụ, ndu Ízurẹlu agụ. ");
INSERT INTO iqw_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Unu kfuru ẹphe lẹ yẹbe Ojejoje sụru: ‘L'ẹga-a, ya nọ ndzụ-a; bẹ ya a-tụko iphemiphe ọbule ono, ẹphe kfushiru ono mee ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ọ bụ l'echi-ẹgu-wa bẹ odzu ẹphe a-wụshiru; mbụ iphe, bụ ndu ono, nọwaru tsube l'ụkporo afa kwasẹru ono; mbụ ndu ono, a gụru ọgu teke aagụ ọgu ono; mbụ ndu ono, tso gụaru iya aphụ ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ẹ tọ dụdu m'ọo onye lanụ l'unu ha, byaru bya a-bahụ l'alị ono, ya woliru ẹka iya imeli kweta lẹ ya a-nụ unu t'unu buru ono; gbahalẹphu Kálẹbu Jefune; mẹ Jóshuwa Nunu. ");
INSERT INTO iqw_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","A bya abya lẹ k'ụnwegirima unu ono, unu yọru ọshi; sụ l'aa-kpụ lẹ ndzụ ono bẹ ya e-duru bahụ t'ẹphe je amaru alị ono, unu jịkaru ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ọle; unubẹdua l'onwunu bẹ odzu unu a-wụshiru l'echi-ẹgu-wa. ");
INSERT INTO iqw_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ụnwegirima unu a-nọdu l'echi-ẹgu-wa ghaa ngvudangvu ụkporo afa labụ; jee iphe-ẹhuka; kẹ l'unu bụ 'ekwegekwe; mbụ jeye teke odzu unu a-dabukotaru l'echi-ẹgu-wa. ");
INSERT INTO iqw_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Unu e-je iphe-ẹhuka ono ụkporo afa ẹbo lẹ k'ẹjo iphe ono, unu meru ono. Afa ophu a-nọ-chi ẹnya ujiku lanụ l'ime ụkporo abalị ẹbo ono, unu gude jee ngge l'alị ono. Ọo ya bụ; unu amakwanụru iphe, ọ bụ lẹ ya ta natadu iphe unu meru. ");
INSERT INTO iqw_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Yẹbe Ojejoje bẹ kfuakwaru nk'iya! Ya mefutajekwa iphemiphe ọbule ono l'ẹke ndu ẹjo-obu-wa nọ; mbụ ndu ono, chịkoberu onwẹphe l'etso iya okfu ono. Ẹphe a-tụko bụru kpurupyata l'echi-ẹgu-wa; mbụ l'ọo l'ẹke-a bẹ ẹphe a-tụko nwụshihu.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Tọ dụ iya bụ; iphe, bụ ndu ono, Mósisu yeru; ẹphe ejee ngge l'alị ono; mbụ ndu ono, lataru bya atụa ọnu alị ono ẹji ẹji; shi ẹge ono mee tẹ ndu Ízurẹlu gụaru Mósisu aphụ ono; ");
INSERT INTO iqw_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ndu ono, bụ ẹphe tụru ọnu alị ono ẹji ẹji ono bẹ Nchileke tụwaru mgbọnwu nụ; ẹphe anwụshihu. ");
INSERT INTO iqw_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Yọ bụru Jóshuwa Nunu yẹle Kálẹbu Jefune bụ ndu waru nụ l'iphe, bụ ndu ono, jeru ngge l'alị ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mósisu abya eworu iphe ono kfuaru ndu Ízurẹlu l'ẹphe ha; yo rukpoo ẹphe l'ẹhu nshinu. ");
INSERT INTO iqw_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Yo rua l'ọnma-ẹwa ụtsu; ẹphe egbeshi jeshia l'alị ugvu Kénanu je anọdu; sụ: “L'ẹphe mewaru iphe dụ -ẹji. T'ẹphe tụgbukwaa jeshia ẹke ono, Ojejoje kweru ẹphe ụkwa iya ono.” ");
INSERT INTO iqw_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mósisu asụ: “?Bụ ngụnu meru iphe unu eme t'unu mebyia iphe, ekemu Ojejoje kfuru? Ẹ tọo dụkwaru unu lẹ mma! ");
INSERT INTO iqw_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Unu be ejekwa; kẹle Ojejoje taa nọkwa swiru unu. Unu -jee; bẹ ndu ọhogu unu e-mekputakwa unu. ");
INSERT INTO iqw_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ishi iya abụru lẹ ndu Amalẹku mẹ ndu Kénanu bẹ nọkwa unu l'ụzo ifu l'ẹke ono. Ẹphe e-gude ogu-mbeke gbugbushia unu. Ojejoje te eswikwaru unu; kẹ l'unu gbakutawaru iya azụ.” ");
INSERT INTO iqw_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Obenu l'ẹphe te gbe kpadu ishi. Ẹphe atụgbua jeshia l'alị ugvu ono. Ọ bụ lẹ Mósisu yẹle Okpoko Ọgba-ndzụ Ojejoje te tsodu ẹphe lụfu l'ọdu ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tọ dụ iya bụ; ndu Amalẹku mẹ ndu Kénanu, bu l'alị ugvu ono abya etso ẹphe ọgu; mekputa ẹphe; chịa ẹphe jeye lẹ Họma. ");
INSERT INTO iqw_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“T'o kfuaru ndu Ízurẹlu; sụ ẹphe: ‘Unu -lalẹphu je eburu l'alị ono, ya eme tẹ ya nụ unu ono; ");
INSERT INTO iqw_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","unu -gwojelephu ngwẹja nụ Ojejoje; unu eshi l'elu unu fọta anụ gbua; gude gwoo ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. Unu e-meje iya ẹge ono lẹ ngwẹja-ukfuru; teke unu anụ iphe, unu gude emedzu ụkwa, unu kweru; mẹ teke unu anụ iphe, shi unu l'obu; m'ọ bụ teke unu egwo ngwẹja-ajị. ");
INSERT INTO iqw_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Onye wotaru ngwẹja ono e-yekobeje iya ngwẹja nri bya anụ Ojejoje; mbụ wota nkwo-ẹka akpe, e gweru egwegwe kee ụzo iri; wota ụzo iri iya; gwọkobe iya nkere-ẹno ekpemu manụ. ");
INSERT INTO iqw_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","“ ‘Iphe, bụ nwatụru, e gude egwo ngwẹja-ukfuru; m'ọ bụ ngwẹja mmanu bẹ unu e-yekobeje ngwẹja-mẹe; mbụ nkere-ẹno otumu mẹe. ");
INSERT INTO iqw_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘A bya l'iphe, bụ ebyila, e gude egwo ngwẹja; unu yekobeje iya ngwẹja nri; mbụ ụzo labụ l'ime nkwo-ẹka akpe, e gweru egwegwe kee ụzo iri; bya agwọkobe iya nkere-ẹto ekpemu manụ. ");
INSERT INTO iqw_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ngwẹja-mẹe ono bẹ unu e-gude nkere-ẹto otumu mẹe gwoo. Unu meje iya t'ọ bụru ngwẹja, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Teke ọ bụ l'ọo nwa oke-eswi bẹ unu gude abya ogworu Ojejoje ngwẹja-ukfuru; m'ọ bụ ngwẹja, unu gude emedzu ụkwa, unu kweru Ojejoje; m'ọ bụ ọphu e gude egwo ngwẹja ẹhu-agu; ");
INSERT INTO iqw_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","t'onye egwo iya nụ yekobekwa iya ngwẹja nri; mbụ ụzo ẹto l'ime nkwo-ẹka akpe, e gweru egwegwe kee ụzo iri; bya agwọkobe iya nkere-ẹbo ekpemu manụ. ");
INSERT INTO iqw_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Ono kwaphụ ẹge unu e-wota nkere-ẹbo otumu mẹe gude gwoo ngwẹja-mẹe. Ngwẹja ono a-bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“ ‘Yọ bụru ẹge ono bẹ unu e-medzujeru iya l'iphe, bụ oke-eswi; ebyila; nwatụru; m'ọ bụ nweghu, unu gude egwo ẹja. ");
INSERT INTO iqw_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ono ẹge unu e-medzujeru iya l'iphe bụ ngwẹja, unu egwokpoo egwogwo; m'o -ruhuru; ọ ha igwe ịha-a. ");
INSERT INTO iqw_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Iphe, bụ onye a mụru lẹ Ízurẹlu bụ ẹge ono bẹ oo-meje ngwẹja, oogwo anụ Ojejoje; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Shita l'ọgbo nk'unu je akpaa lẹ ndu ọphu a-bya nụ; onye bụ onye laru alala, unu l'iya bu -wota ngwẹja tẹ ya gwooru Ojejoje; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma; t'ọ bụkwaru ẹge unu emeje bẹ oo-me. ");
INSERT INTO iqw_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ọo ome-l'alị lanụ ono bẹ dụru unubẹ ndu Ízurẹlu l'unu ha; mẹ iphe, bụ ndu laru alala, unu l'ẹphe bu. Ome-l'alị ono a-nọdulephu shita l'ọgbo unu sweru ọgbo ọphu abya nụ gbururu jewaru. Ọo ẹge unu dụ l'ifu Ojejoje bụ ẹge ndu, laru alala dụkwaphu. ");
INSERT INTO iqw_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Yọ bụru ekemu lanụ yẹle ome-l'alị lanụ bẹ dụru unu lẹ ndu, laru alala, unu l'ẹphe bu.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“T'o kfuru ndu Ízurẹlu sụ ẹphe: ‘Unu -rulephu alị ono, ya du unu eje ono; ");
INSERT INTO iqw_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","unu ridelephu nri, shi l'alị ono; unu ketakwa oke iya bya anụ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Unu gude ụtu iphe, shi l'akpụru iphe mbụ, unu metaru l'alị ono gheta buredi nụ Ojejoje t'ọ bụru ngwẹja, shi l'ẹke eetsuje balị. ");
INSERT INTO iqw_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ngwẹja-nri mbụ, unu metaru l'alị ono bẹ unu a-nụje Ojejoje gbururu jeyewaru; mbụ shita l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Ọ -bụru l'unu ta madu amama; haa odobekota ekemu-a, Ojejoje tụshiru ye Mósisu l'ẹka-a; ");
INSERT INTO iqw_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","mbụ ekemu ono l'ọ ha, Ojejoje shi l'ẹka Mósisu nụ unu; tsube lẹ mbọku ono, Ojejoje tụru iya nụ unu ono jeyewaru; ");
INSERT INTO iqw_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","b'ọ -bụru lẹ ndu Ízurẹlu l'ẹphe ha ta madu; mbụ l'ẹphe te lebezidu ẹnya mebyia ekemu ono; t'unubẹ ndu Ízurẹlu wota nwa oke-eswi gude gwoo ngwẹja-ukfuru; mbụ ngwẹja, e meru; mkpọ iya adụ Ojejoje mma. Unu yekobeje iya ngwẹja-nri; mẹ ngwẹja-mẹe, l'etsoje iya nụ; mẹ mkpi, ee-gude gwoo ngwẹja iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","T'onye achịjeru Nchileke ẹja gwoo ngwẹja ono gude kfụa ụgwo iphe, dụ ẹji ndu Ízurẹlu l'ẹphe ha; t'a gụaru ẹphe nvụ l'iphe, dụ ẹji, ẹphe meru; kẹ l'ẹphe ta madu amama mee ya; byawa bya egwoo ngwẹja nụ Ojejoje lẹ kẹ emeswe ono, ẹphe mesweru ono; mbụ ngwẹja-ọku; mẹ ngwẹja iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ndu Ízurẹlu l'ẹphe ha; mẹ ndu laru alala, ẹphe l'ẹphe bu bẹ aa-gụkotaru nvụ; kẹ l'ẹphe l'ẹphe ha tụkowaru mee iphe, dụ ẹji ono l'amagama. ");
INSERT INTO iqw_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Ọle agha; ọ -bụru l'ọo onye lanụ bẹ meru iphe, dụ ẹji ono l'amagama; t'onye ọbu wota nwada eghu, gbaru afa t'e gude gwoo ngwẹja iphe, dụ ẹji ono, o meru ono. ");
INSERT INTO iqw_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Onye achịjeru Nchileke ẹja bẹ a-nọdu l'ifu Ojejoje kfụa ụgwo iphe, dụ ẹji, onye ono meru l'amagama. A -kfụwa ụgwo iphe, dụ ẹji ono, onye ono meru ono b'a gụwaru iya nvụ. ");
INSERT INTO iqw_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ọo ekemu lanụ ono bẹ dụru iphe, bụ onye meru iphe, dụ ẹji l'amagama; m'ọ bụ onye a mụru lẹ Ízurẹlu; m'ọ bụ onye laru alala. ");
INSERT INTO iqw_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Obekwanu l'onye maru amaru mee iphe, dụ ẹji; m'a mụru onye ọbu amụmu lẹ Ízurẹlu; m'ọ bụ onye laru alala bẹ onye ọbu kfusweekwaru ẹpha Ojejoje. Onye dụ ẹge ono bẹ ee-bufu ebufu l'ẹke ndibe ẹphe nọ. ");
INSERT INTO iqw_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Keshinu ọphu onye ono ta dụdu iphe, ọ gụberu Ojejoje; bya emebyiwa ekemu Ojejoje; bẹ ee-bufuje onye ọbu ebufu; iphe, o metaru atukoru iya l'ishi.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Lẹ teke ndu Ízurẹlu nọkwadu l'echi-ẹgu b'o nweru nwoke lanụ, e guderu l'ẹke ọokpa nkụ lẹ mbọku ọtu-ume. ");
INSERT INTO iqw_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ndu phụru iya l'ẹke ọokpa nkụ ono akpụta iya kpụ-kfushiaru Mósisu yẹle Érọnu; mẹ ndu Ízurẹlu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ẹphe akpụta iya tụ-chia atụ-chi; kẹ l'ẹ te medua t'o doo ẹnya iphe, ee-me iya. ");
INSERT INTO iqw_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “Lẹ nwoke ono; bẹ ee-gbu egbugbu. Tẹ ndu Ízurẹlu l'ẹphe ha kpụfu iya l'ọdu ndu Ízurẹlu je atụ-gbua ya lẹ mkpuma.” ");
INSERT INTO iqw_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ya ndono; ẹphe eshi l'ọdu ndu Ízurẹlu; kpụta iya kpụfu; je atụ-gbua ya lẹ mkpuma ẹge ono, Ojejoje kfuru iya Mósisu ono. ");
INSERT INTO iqw_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ojejoje abya ekfuru yeru Mósisu; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“T'o kfuaru ndu Ízurẹlu; sụ ẹphe: ‘T'ephe kpaa iphe-akpakpa l'igburumọnu uwe unu. Unu adzụru òwúú, eke urukpu-urukpu ye l'eli òwúú ono, unu kpangashịru akpangashị dzụpyabe l'uwe ono. Ono bụ ẹge unu e-meje iya ndono tsube l'ọgbo sweru ọgbo. ");
INSERT INTO iqw_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Iphe-akpakpa ono bẹ unu e-leje ẹnya gude nyatakọta ekemu yẹbe Ojejoje; k'ọphu unu a-nọduje eme iya ememe; haa ẹgu iphe, dụ ẹji ono, anọduje agụgbaa obu unu ono; mẹ ọphu ẹnya unu aphụje; mbụ iphe, dụ ẹji ono, unu shi anọduje emegbaa ono. ");
INSERT INTO iqw_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ọo ya bụ; k'ọphu unu a-nyatajẹ ekemu yẹbe Ojejoje; l'eme iya ememe; shi ẹge dụru Nchileke unu nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ọo yẹbedua bụ Ojejoje; bụ Nchileke unu; mbụ onye ono, dufutaru unu l'alị Íjiputu; tẹ ya bụru Nchileke unu ono. Ọo ya bụ Ojejoje, bụ Nchileke unu.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Yo be teke ono; Kora Izaha Kohatu; onye eri Lívayi; waa Detanu; mẹ Ebiramu, bụ ụnwu Eliyabu; mẹ Ọnu Pelẹtu, bụ ndu ikfu Rúbẹnu achịta madzụ yeru onwẹphe; ");
INSERT INTO iqw_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ẹphe awụ-lihu tsolahaa Mósisu okfu. Ndu ono, tso ẹphe ono bụgbaa ndu a fọtaru t'ẹphe bụru ndu ishi, achị ndu Ízurẹlu; bya abụru ndu a maru ẹpha ẹphe lẹ Ízurẹlu gbaa mgburumgburu. Iphe, ẹphe dụ bụ ụkporo ụmadzu iri l'ẹbo l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ẹphe achịkobe onwẹphe byakfutashia Mósisu yẹle Érọnu bya asụ ẹphe: “L'unu metawaru iphe ọbu; yọ kabẹ kpọo akpọkpo! Ndu Ízurẹlu l'ẹphe ha bẹ unu maru l'ẹphe dụ nsọ l'ẹhu l'ẹhu; Ojejoje eswiru ẹphe eswiru. ?Bụ ngụnu meru iphe unu paliru onwunu dobe l'ishi ndu kẹ Ojejoje ẹge ono?” ");
INSERT INTO iqw_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mósisu anụlephu iphe ono, ẹphe kfuru ono; daa kpupyabe ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Yọ sụ Kora yẹle ndu tso iya nụ: “Teke o beru l'ụtsu bẹ Ojejoje e-koshi nụ onye ọphu bụ nk'iya; waa onye dụ nsọ. Onye ọ fọtaru bẹ oo-mee t'ọ byanyabe iya ntse. ");
INSERT INTO iqw_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ọwaa iphe, unu ee-me ndọ-ọ: Tẹ nggụbedua, bụ Kora; nggu lẹ ndu otu ngu phẹ wota efere, aagụjeru ọku ye; ");
INSERT INTO iqw_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","o -be echile; unu agụru ọku ye iya; ye iya ínsẹnsu l'ifu Ojejoje. Ayi a-maa onye ọphu Ojejoje fọtaru. Ọ chikwaa unubẹdua, bụ ndu Lívayi metawaru iphe ọbu; yọ kabẹ kariwa ẹka akari!” ");
INSERT INTO iqw_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mósisu asụkwaphu Kora phẹ: “Unu ngabẹ nchị; unubẹ ndu eri Lívayi! ");
INSERT INTO iqw_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","?To dzudu unu l'ọo unubẹdua bẹ Nchileke kẹ ndu Ízurẹlu fọtaru dobe iche lẹ Ízurẹlu mgburumgburu; mee t'unu nọdu iya ntse; l'eje ozi, nọ l'ụlo-ẹ́kwà kẹ Ojejoje; mẹ t'unu vudoje ndu Ízurẹlu l'ẹphe ha l'ifu l'ejeru ẹphe ozi? ");
INSERT INTO iqw_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","O meru tẹ nggụbe Kora; mẹ ndu eri Lívayi, bụ ndibe unu nọdu iya ntse. Nta-a bẹ unu achọwa ụzo, unu e-shi bụru ndu achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ọ kwa Ojejoje bẹ nggu lẹ ndu otu ngu l'unu ha kpakọru etso okfu. ?Bụ onye bẹ Érọnu bụ kẹ t'unu l'agụru iya aphụ?” ");
INSERT INTO iqw_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Tọ dụ iya bụ; Mósisu abya ezia t'e je ekua Detanu; mẹ Ebiramu, bụ ụnwu Eliyabu. Ẹphe asụ l'ẹphe ta abyadụ; ");
INSERT INTO iqw_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","sụ iya: “?T'o gbe dzudua ngu l'i dufutaru ẹphe l'ẹgiri alị Íjiputu ono; t'i bya egbushia ẹphe l'echi-ẹgu l'ẹke-a? Nta-a b'ị chọfukwaaphu t'i mee onwongu onye ishi l'ẹke ẹphe nọ. ");
INSERT INTO iqw_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ọphu ka njọ abụru l'ẹ ti dubadu ẹphe l'ẹgiri alị ono, i shi keshinu ono kfuta okfu iya ono; tọ bụ l'i koshiru ẹphe ẹke ẹphe a-kọbeje iphe; mẹ ẹke ẹphe e-me mgbo vayịnu. ?Iime t'i mee ndu-a nphuruphuru-ẹnya tọo? Waawa-o! Ẹphe ta abyadu-o!” ");
INSERT INTO iqw_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Tọ dụ iya bụ; ẹhu enwuhu Mósisu ọku. Yọ sụ Ojejoje: “T'ẹ b'ọ dụkwa ngwẹja, ndu-a gworu nụ iya, ọo-nata. L'ẹ to nwekwa ẹphe onye ya mejewaru ẹji; to nwe ẹphe onye ya natajẹwaru m'ọo mẹ nkakfụ-ịgara iya.” ");
INSERT INTO iqw_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mósisu asụ Kora: “Tẹ yẹle ndu otu iya l'ẹphe ha lụfutakota l'ifu Ojejoje echile. Tẹ nggụbe Kora; mẹ ẹphebedua; ọwaa Érọnu tụko byakọta. ");
INSERT INTO iqw_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","T'onyenọnu gudekwa efere, aagụjeru ọku ye; ye iya ínsẹnsu gude bya l'ifu Ojejoje. Iphe, ọo-dụ; mbụ efere ono, aagụjeru ọku ye ono bụ ụkporo iri l'ẹbo l'iri. Nggụbedua, bụ Kora l'onwongu e-gude nke ngu; Érọnu egude nk'iya bya.” ");
INSERT INTO iqw_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Tọ dụ iya bụ; onyenọnu ewota efere ono, aagụjeru ọku ye ono; bya agụru ọku ye iya; ye iya ínsẹnsu je evudogbaa l'ọnu Ụlo-Ẹ́kwà Ndzuko ono. Ẹphe lẹ Mósisu mẹ Érọnu atụko vudo l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora abya achịkobe ikpoto ndu Ízurẹlu ono l'ọnu Ụlo-Ẹ́kwà Ndzuko ono t'ẹphe tso Mósisu yẹle Érọnu okfu. Tọ dụ iya bụ; o-gbu-nwịi-nwịi kẹ Ojejoje abya enwua kẹ phoo l'edzudzu ọha ono. ");
INSERT INTO iqw_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ojejoje asụ Mósisu yẹle Érọnu: ");
INSERT INTO iqw_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“T'ẹphe shi l'edzudzu ọha ono lụfuta tẹ ya bya atụko ndu ono l'ẹphe ha mebyishikota nta-a.” ");
INSERT INTO iqw_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mósisu yẹle Érọnu adaa; kpube ifu l'alị chishia mkpu; sụ: “Nggụbe Nchileke; nggụbe Nchileke, bụ nggu anụje ndiphe ndzụ. ?Ii-gude k'iphe, onye lanụ metaru tụ-koshi ndu-a l'ẹphe ha ẹhu-eghughu ngu tọo?” ");
INSERT INTO iqw_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ojejoje asụ Mósisu ");
INSERT INTO iqw_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","t'o kfuaru ọha ono t'ẹphe lụfuta l'ibyiya ọphu ụlo-ẹ́kwà Kora; mẹ kẹ Detanu; mẹ kẹ Ebiramu nọ. ");
INSERT INTO iqw_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mósisu agbalihu yẹle ndu bụ ọgurenya Ízurẹlu ayịru jekfushia Detanu; mẹ Ebiramu. ");
INSERT INTO iqw_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mósisu asụ ọha ono t'ẹphe lụfutakwa l'ụlo-ẹ́kwà ndu ẹjo iya ono! Sụ ẹphe: “Unu be edenyikwa ẹka l'iphe, bụ kẹ ndu ono; ọdumeka bẹ Ojejoje e-gudekwa k'ẹjo-iphe, ẹphe meshiru woru unu mebyishia.” ");
INSERT INTO iqw_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Tọ dụ iya bụ; ẹphe awụfu l'ụlo-ẹ́kwà Kora; mẹ kẹ Detanu; mẹ kẹ Ebiramu. Detanu yẹle Ebiramu abya alụfuta vudo l'ọnu ụlo-ẹ́kwà ẹphe; ẹphe l'unyomu ẹphe; mẹ ụnwu ẹphe; mẹ ụnwegirima ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mósisu asụ: “Ọwaa iphe, unu e-gude maru l'ọo Ojejoje ziru iya tẹ ya mee iphemiphe ọbule ono; mbụ l'ẹ t'ọ bụdu iphe, gbataru iya l'uche bẹ ya eme. ");
INSERT INTO iqw_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ọ -bụru lẹ ndu-a bẹ nwụhuru anwụhu-ugboshi; ọ -bụru l'ọo iphe adakfuje madzụ ba dakfuru ẹphe; ọo ya bụ t'a maru l'ẹ t'ọ bụdu Ojejoje ziru iya iphe ono, ya eme ono. ");
INSERT INTO iqw_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ọle; teke bụ lẹ Ojejoje meru t'iphe ẹ-te emejedu nụ mee; alị ekpuhaa ọnu lekota ẹphe; lee iphemiphe ọbule, ẹphe nweru enweru; mbụ; ẹphe abụru ndu wụbaru l'alị-maa lẹ ndzụ. Teke ono; unu amaru lẹ ndu-a te nwedu iphe ẹphe gụberu Ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ekfuge, Mósisu ekfugelephu iphe ono; alị ẹke Detanu phẹ vudo ekejahu ẹbo; ");
INSERT INTO iqw_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kpuhaa ọnu lekota ẹphe; mẹ ndibe ẹphe; mẹ ndu kẹ Kora; mẹ iphe ẹphe l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ẹphe awụbakọta l'alị-maa lẹ ndzụ; mẹ iphe, bụ iphe, ẹphe nweru enweru; alị ekpupyabe ẹphe; ẹphe l'ẹphe ha atụko lakọta l'iyi edzudu ọha. ");
INSERT INTO iqw_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Yọ bụru mkpu, ẹphe echi bẹ meru; ndu Ízurẹlu, nọ-pheru ẹke ono mgburumgburu eye ọkpa l'ọso; ara l'alị abyawa ẹphe elele! ");
INSERT INTO iqw_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ya ndono; ọku, shi Ojejoje l'ẹka abya ekegbushikota ụkporo madzụ iri l'ẹbo l'ụmadzu iri phụ, shi akpọ ínsẹnsu ọku phụ. ");
INSERT INTO iqw_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Ojejoje asụ Mósisu ");
INSERT INTO iqw_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","t'o kfuru Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja t'ọ lọshia efere ono, aagụjeru ọku ye l'ọku ono; vọshia icheku-ọku, nọ iya nụ tụkaa nanụ nanụ; kẹ l'iphe ono dụ nsọ; ");
INSERT INTO iqw_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","mbụ efere ono, aagụjeru ọku ye, bụ kẹ ndu ono, meru iphe, dụ ẹji; shi ẹge ono tufashia ndzụ ẹphe ono. Teke ọ lọshitsuaru iya; t'a kụa ya t'o chisaa echisa; k'ọphu ee-kpubeje iya l'eli ẹnya-ngwẹja Ojejoje. Ishi iya abụru l'a nụwaru iya Ojejoje; yọ dụwa nsọ. Iphe ono bẹ a-bụru iphe-ọhubama l'ẹke ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Tọ dụ iya bụ; Eliyéza, bụ onye achịjeru Nchileke ẹja abya achịkoo efere ono, aagụjeru ọku ye ono, bụ ope b'e gude meshia ya ono; mbụ iphe ono, ndu ono, ọku kepyashiru ono gude bya ọkpo ínsẹnsu ọku. A kụsaa ya ụsa; k'ọphu ee-kpubeje iya l'eli ẹnya-ngwẹja Ojejoje; ");
INSERT INTO iqw_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","t'ọ bụru iphe, ndu Ízurẹlu e-gudeje nyata l'ẹ t'ọ dụdu onye ọdo, ẹ-ta bụdu onye eri Érọnu, a-kpụritaje ntse bya ọkpo ínsẹnsu ọku l'ifu Ojejoje; ọdumeka bẹ ọo-dụkwaru onye ọbu ẹge ọ dụru Kora yẹle ndu otu iya phẹ; mbụ ẹge ono, Ojejoje shi l'ẹka Mósisu kfua ya ono. ");
INSERT INTO iqw_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Yo be echile iya; ndu Ízurẹlu l'ẹphe ha awata ọguru Mósisu yẹle Érọnu aphụ; sụ l'ẹphe gbushiwaru ndibe Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Teke ndu ono byaru bya edzukoo t'ẹphe tso Mósisu yẹle Érọnu okfu; chebe ifu l'ụzo Ụlo-Ẹ́kwà Ndzuko; b'a bya amaru; urukpu atsọ-kputawa iya; o-gbu-nwịi-nwịi kẹ Ojejoje abya enwua kẹ phoo. ");
INSERT INTO iqw_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mósisu yẹle Érọnu ejeshia l'ọnu Ụlo-Ẹ́kwà Ndzuko ono; ");
INSERT INTO iqw_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Unu shi edzudu ọha ono lụfuta tẹ ya bya atụko ẹphe mebyishia nta-a.” ");
INSERT INTO iqw_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mósisu asụ Érọnu: “Wota efere, ịigujeru ọku ye; shi l'ẹnya-ngwẹja Ojejoje gụta ọku ye iya. Woru ínsẹnsu ye iya; nggu emee ẹgwegwa gude iya jekfu ọha ono; gude iya kfụa ụgwo ẹjo iphe ẹphe. Ishi iya abụru l'ẹhu eghushikwa Ojejoje eghughu ike; mgbọnwu awataakwa.” ");
INSERT INTO iqw_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Érọnu ewota efere ono ẹge ono, Mósisu kfuru iya ono; gbagbụa gbaba l'edzudzu ọha ono. T'ọ kwaa rua bẹ mgbọnwu ono watawaru ogbushi ndu ono. Yọ bya akpọoru Ojejoje ínsẹnsu ono ọku; bya akfụa ụgwo iphe, dụ ẹji ndu ono. ");
INSERT INTO iqw_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Yo vudo lẹ mgbaku ndu ọphu nwụhuwaru anwụhu; mẹ ndu ọphu nọ ndzụ; mgbọnwu ono egbubuhu. ");
INSERT INTO iqw_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ndu mgbọnwu ono gburu bẹ dụ ụkporo ụnu madzu l'ụnu madzụ iri l'ishingu; l'ụkporo madzụ iri l'ise; t'a gụfukwa ndu ọphu nwụhuru nụ l'okfu ẹka Kora. ");
INSERT INTO iqw_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","E megee; Érọnu ejekfushia Mósisu l'ọnu Ụlo-Ẹ́kwà Ndzuko; kẹ lẹ mgbọnwu ono buhuwaru. ");
INSERT INTO iqw_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kfuaru ndu Ízurẹlu t'ẹphe chẹ ngu mgbọro iri l'ẹbo. Tẹ ndu bụtsua ishi l'iphe bụ ikfu, nọnu nụgbaa ngu mgbọro lanụ. Deshia ẹpha onyenọnu lẹ mgbọro nk'iya. ");
INSERT INTO iqw_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Onyenọnu l'iphe, bụ ndu ishi ono, achịgbaa ikfu ono e-nweru mgbọro lanụ. Teke a byaru lẹ mgbọro kẹ ndu ikfu Lívayi; nggu edee ya ẹpha Érọnu. ");
INSERT INTO iqw_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Chịta mgbọro ono je awụshi lẹ Ụlo-Ẹ́kwà Ndzuko l'ifu Okpoko Ekemu, bụ ẹke ono, ya abyakfutaje unu ono. ");
INSERT INTO iqw_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Onye mgbọro nk'iya futaru ome; a maru l'ọo onye ọphu ya fọtaru ndono. Teke e metsuaru; ya te eyeheduru ndu Ízurẹlu ọnu l'aphụ ono, ẹphe anọje agụ l'ekpu unu ono.” ");
INSERT INTO iqw_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Tọ dụ iya bụ; Mósisu abya ekfuru yeru ndu Ízurẹlu. Ndu, bụ ishi l'iphe, bụ ikfu nọnu anụgbaa ya mgbọro nanụ nanụ. Iphe, ọ dụ bụ mgbọro iri l'ẹbo. Mgbọro kẹ Érọnu l'ikfu kẹ ndu Lívayi tsokwa iya phụ. ");
INSERT INTO iqw_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mósisu achịta iya je edobe l'ifu Ojejoje l'ụlo-ẹ́kwà l'ẹke ono, Okpoko Ekemu Nchileke nọ ono. ");
INSERT INTO iqw_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Yo rua echile iya; Mósisu abahụ l'ụlo-ẹ́kwà l'ẹke ono, Okpoko Ekemu Nchileke nọ ono; bya aphụa ẹge mgbọro kẹ Érọnu, bụ onye nọ-chiru ẹnya ikfu kẹ ndu Lívayi fushiru ome; rushia iru; tụshikwaaphu igu; bya amịshia akpụru alụmondu, gbe chashịtsuanu achashị. ");
INSERT INTO iqw_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mósisu abya eshi l'ifu Ojejoje chịfuta mgbọro ono chị-jeru ndu Ízurẹlu l'ẹpha ha. Ẹphe elee ya ẹnya; onyenọnu ewotatsua mgbọro ọphu bụ nk'iya. ");
INSERT INTO iqw_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ojejoje asụ Mósisu: “T'o woru mgbọro kẹ Érọnu dobephu azụ l'ifu Okpoko Ekemu ono; t'ọ nọdu l'ẹke ono bụru iphe-ọhubama l'ẹke ndu ono, ekwefuje íkè ono nọ; t'ọ bụru iphe, a-nọduje alọ ẹphe ẹka lẹ nchị t'ẹphe haa ọgu-phe aphụ l'ekpu yẹbe Ojejoje; a -nọnyaa; ẹphe anwụshu.” ");
INSERT INTO iqw_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Yọ bụleruphu ẹge Ojejoje sụru tẹ Mósisu mee ya b'o meru iya. ");
INSERT INTO iqw_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ndu Ízurẹlu asụ Mósisu: “Ẹphe a-nwụshihukwa! Ẹphe gvụakwaru! Ẹphe gvụakwaru l'ẹphe ha! ");
INSERT INTO iqw_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Iphe bụ onye, jekfuberu ụlo-ẹ́kwà Ojejoje ntse a-nwụhukwa. ?Ẹphe a-nwụshihukota l'ẹphe ha tọo?” ");
INSERT INTO iqw_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ojejoje asụ Érọnu: “Nggụbedua l'onwongu; mẹ ụnwu ngu; mẹ iphe, bụ ọnu-ụlo nna ngu l'ẹphe ha bẹ ọo-tụ-koru l'ishi; mbụ iphe, dụ ẹji, e meru l'ẹke-dụ-nsọ nk'iya; yọ bụru nggụbedua l'onwongu kwaphụ; mẹ ụnwu ngu bẹ ọo-tụ-kokwaruphu l'ishi; mbụ iphe, dụ ẹji, e meru meswee k'ọbu onye achịje ẹja. ");
INSERT INTO iqw_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Duta ụnwunna ngu phẹ, bụ iya bụ ndu ikfu Lívayi, bụ ikfu nna ngu t'ẹphe yejeru ngu ẹka; nggụbedua; mẹ ụnwu ngu phẹ a-nọdu l'ọnu ụlo-ẹ́kwà ẹke Okpoko Ekemu Nchileke nọ eje ozi. ");
INSERT INTO iqw_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ọ bụ nggu bẹ ẹphe a-nọdu l'ẹka; l'eje iphe, bụ ozi, nọ l'ụlo-ẹ́kwà ono. Ọle t'ẹphe be eshitakwa iku ẹke iphe ẹke-dụ-nsọ nọ; ẹphe te shita mgboro ẹnya-ngwẹja Nchileke; ọ -dụdu bẹ nggu l'ẹphe a-nwụshihukwa. ");
INSERT INTO iqw_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ẹphe e-tsoje ngu l'eje ozi, nọ lẹ Ụlo-Ẹ́kwà Ndzuko ono; mbụ iphe, bụ ozi, nọ l'ụlo-ẹ́kwà ono. T'onye ọdo, ẹ ta bụdu onye Lívayi be eyetakwaru unu ẹka l'ọru ono. ");
INSERT INTO iqw_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ọ bụ unubẹdua a-nọdu eje ozi, nọ l'ẹke-dụ-nsọ; mẹ ozi k'ẹnya-ngwẹja Nchileke; k'ọphu Nchileke ẹte atụ-koshihedu ndu Ízurẹlu oke ẹhu-eghughu iya ọdo. ");
INSERT INTO iqw_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ọo yẹbe Ojejoje l'onwiya bẹ shi lẹ ndu Ízurẹlu fọta ụnwunna unu bẹ ndu Lívayi. Ẹphe bụ ndu e woru nụ unu; bụru ndu e doberu yẹbe Ojejoje iche t'ẹphe jeje ozi, nọ lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ọ bụ nggụbedua; nggu l'ụnwu ngu a-nọdu eje ozi kẹ ogworu Nchileke ẹja; mbụ l'unu a-nọdu ejekota ozi k'ẹnya-ngwẹja Nchileke; waa ozi, nọ l'ime ẹke ẹkwa-mgbochi nọ. Ono bụ ozi, unu a-nọdu eje ndono. Ya yeru unu kẹ ogwo ngwẹja ono l'ẹka t'ọ bụru iphe-ọma, ya meru unu. Onye ọdo, ẹ ta bụdu onye Lívayi, byaru lẹ mgboro ẹke-dụ-nsọ a-nwụhukwa.” ");
INSERT INTO iqw_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Tọ dụ iya bụ; Ojejoje asụ Érọnu: “Nta-a bẹ ya wowaru iphemiphe ọbule, bụ iphe, aanụje iya anụnu ye ngu l'ẹka. Iphe, bụ iphe, ndu Ízurẹlu dobejeru nsọ nụ iya bẹ ya nụwaru ngu t'ọ bụru òkè-iphe ngu; nggu l'ụnwu ngu phẹ gbururu jeyewaru. ");
INSERT INTO iqw_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ọwaa bẹ a-bụfuaru òkè-iphe unu l'iphe, kakọta ọdu nsọ ono, bụ ọphu ẹ ta kpọdu ọku: Iphe, ẹphe gudekota bya ogwo ngwẹja nụ iya; mbụ iphe, shi lẹ ngwẹja nri; mẹ ngwẹja iphe, dụ ẹji; mẹ ọphu shi lẹ ngwẹja ikpe-anmanma; mbụ iphe, bụ iphe ono, ẹphe nụru t'ọ bụru ngwẹja, kakọta ọdu nsọ ono. Ndu onanu bẹ bụkota òkè-iphe, ruberu nggụbe Érọnu; mẹ ụnwu ngu phẹ. ");
INSERT INTO iqw_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Unu nọduje l'ẹke, kakọta ọdu nsọ ria ya. Yọ bụru unwoke nwẹnkinyi bẹ e-rije iya nụ. T'ọ bụkwaru unu iphe, dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Iphe, bụ iphe, ndu Ízurẹlu doberu mu iche; mbụ iphe, shikota lẹ ngwẹja-amama bẹ bụ nke ngu. Ya wowaru iya nụ nggu l'ụnwu ngu: ndu k'unwoke; mẹ ndu k'ụnwanyi gbururu jeye lẹ gbururu. Iphe, bụ ndibe ngu, mmeru ta nọdu l'ẹhu bẹ e-tsoje ria ya. ");
INSERT INTO iqw_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Iphe, bụ iphe, ndu Ízurẹlu nụru Ojejoje l'ọo iphe mbụ, shi l'iphe, ẹphe metaru l'alị bẹ bụ nggu nwe iya; mbụ iphe, bụ manụ olivu, kakọta mma; mẹ iphe, bụ mẹe ọphungu, kakọta mma; mẹ iphe, bụ akpe, kakọta mma. ");
INSERT INTO iqw_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Iphe, bụ iphe, ẹphe wotaru Ojejoje l'ọo akpụru iphe mbụ, ẹphe metaru l'alị ẹphe bụ nke ngu. Iphe, bụ ndibe ngu, mmeru ta nọdu l'ẹhu bẹ e-tsoje ria ya. ");
INSERT INTO iqw_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Iphe, bụ iphe, e yeru Ojejoje l'ẹka l'alị Ízurẹlu bẹ bụkota nke ngu. ");
INSERT INTO iqw_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Iphe, bụ iphe, kpọru nne iya ifu; m'ọ bụ madzụ; m'ọ bụ anụmanu; mbụ ọphu e woru nụ yẹbe Ojejoje bẹ a-bụru nke ngu. Obenu aa-kfụje ụgwo gude gbata iphe, bụ ọkpara, shi l'ẹhu madzụ. Ọ kwaphụ ẹge ono bẹ aa-kfụje ụgwo gude gbata iphe, bụ anụ mbụ, shi l'ẹhu anụ, aasọ nsọ lụfuta. ");
INSERT INTO iqw_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ẹphe -nọwa ọnwa ophu bẹ aa-kfụje mkpọla-ọcha, dụ shẹkelu ise gude gbata iya; mbụ mkpọla-ọcha, bụ a -tụde ẹra iya; yọ ha l'ọ bụ ẹra shẹkelu ẹke-dụ-nsọ, dụ gera ụkporo. ");
INSERT INTO iqw_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Obenu lẹ nweswi; nwatụru; mẹ nweghu k'ọdungu bẹ aa-hajẹ agbata. Ndu onanu bẹ dụ nsọ. Unu phejee mee ya l'eli ẹnya-ngwẹja ono; unu akpọje ẹba iya ọku gude gwoo ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Anụ iya a-bụru nke ngu; yekoberu ǹdụ́-iphe, e gude gwoo ngwẹja-amama; mẹ ụtakfu ẹka-ụtara iya. ");
INSERT INTO iqw_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Iphe, bụ iphe, ndu Ízurẹlu doberu nsọ t'ẹphe nụ Ojejoje bẹ ya nụwaru ngu; nggu l'ụnwu ngu: ndu k'unwoke; mẹ ndu k'ụnwanyi; t'ọ bụru nk'unu gbururu jeye lẹ gbururu. Ono bụ ọgba-ndzụ, yẹbedua, bụ Ojejoje gbaru l'ẹke ị nọ; mẹ l'ẹke awa ngu nọ. Ọgba-ndzụ ono a-bụru ojejoje.” ");
INSERT INTO iqw_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ojejoje asụ Érọnu: “Unu be etsokwa ndu Ízurẹlu wata alị; ọphu ọ dụkwa òkè, unu etso ẹphe eketa. Ọo yẹbe Ojejoje bẹ bụ òkè, unu nweru; bụru iya bụ òkè, unu ketaru l'ẹke ndu Ízurẹlu nọ.” ");
INSERT INTO iqw_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“A -bya abya l'ẹke ndu Lívayi; keshinu ẹphe eje ozi, nọ lẹ Ụlo-Ẹ́kwà Ndzuko bẹ ya nụkotawaru ẹphe iphe, ndu Ízurẹlu anụje Ojejoje lẹ k'òkè lanụ l'ụzo iri t'ọ bụru òkè-iphe ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Tsube nta-a kwasẹru b'ẹ t'ọ dụdu onye Ízurẹlu ọdo, e-jenyabe mgboro Ụlo-Ẹ́kwà Ndzuko ono; ọdumeka bẹ iphe, dụ ẹji onye ọbu meru a-tukokwaru iya l'ishi; yọ nwụhu. ");
INSERT INTO iqw_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ọo ndu Lívayi bẹ ozi Ụlo-Ẹ́kwà Ndzuko nọ l'ẹka; bụru ẹphe bẹ iphe, dụ ẹji, e meru l'ẹke ono tukoru l'ishi. Iphe ono, a-bụ nsọ, a-dụ nụ jasụru asụru; mbụ tsube l'ọgbo sweru ọgbo. Ẹphe te enwedu òkè l'ẹke ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Iphe, ndu Ízurẹlu nụru yẹbe Ojejoje, bụ òkè lanụ l'ụzo iri bẹ ya nụru ndu Lívayi t'ọ bụru òkè-iphe ẹphe. Ọo ya meru iphe, ya kfuru okfu ẹhu ẹphe; sụ: ‘Ẹphe te eketadu òkè-iphe l'ẹke ndu Ízurẹlu nọ.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“T'o kfuaru ndu Lívayi; sụ ẹphe: ‘L'ọ -bụru l'ẹphe nataru ndu Ízurẹlu òkè lanụ l'ụzo iri ono, ya nụru ẹphe t'ọ bụru òkè-iphe ẹphe ono; t'ẹphe shije l'ime iya woru òkè lanụ l'ụzo iri nụkwaphu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Iphe, ẹphe nụru bẹ aa-nọje agụru ẹphe l'o bụ iphe, shi l'ẹke eetsuje balị; a gụkwaa ya phụ l'ọ bụ mẹe, shi l'ẹke aakụ mẹe. ");
INSERT INTO iqw_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ọo ya bụ l'ẹphe e-shije l'òkè lanụ l'ụzo iri ono, ẹphe anatajẹ l'ẹka ndu Ízurẹlu ono woru òkè lanụ l'ụzo iri iya nụkwaphu Ojejoje. Yọ bụru l'òkè lanụ l'ụzo iri ono bẹ ẹphe e-shi woru kẹ Ojejoje nụ Érọnu, bụ onye achịjeru Nchileke ẹja. ");
INSERT INTO iqw_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","T'ẹphe wojekwaru iphe, gbaru Ojejoje nụ iya l'iphe bụ iphe, a nụru ẹphe. T'ẹphe shije l'ọphu bụ iya kakọta mma nụ iya; mẹ l'ọphu kakọta ọdu nsọ.’ ");
INSERT INTO iqw_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Kfuru ndu Lívayi; sụ ẹphe: ‘Lẹ teke ẹphe woru iphe, kakọta mma nụ Ojejoje bẹ aa-gụru iya ẹphe l'ọ bụ iphe, shi l'ẹke eetsuje balị; a gụkwaa ya phụ l'ọ bụ mẹe, shi l'ẹke aakụ mẹe. ");
INSERT INTO iqw_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ẹphe lẹ ndibe unu a-nọduje l'ẹke dụ ẹphe mma ria ndu ọphu; kẹ l'ọo obunggo ozi, ẹphe eje lẹ Ụlo-Ẹ́kwà Ndzuko. ");
INSERT INTO iqw_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ẹ tọ dụdu iphe, dụ ẹji, a-tukoru ẹphe l'ishi; m'ọ -bụru l'ẹphe wotaru iphe ono ọphu katsụa mma nụ yẹbe Ojejoje. Ọle t'ẹphe kwabẹkwa ẹnya t'ẹphe be emeru iphe, ndu Ízurẹlu doberu nsọ t'ẹphe nụ Ojejoje; ọdumeka b'ọ kwa ọnwu.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ojejoje asụ Mósisu yẹle Érọnu: ");
INSERT INTO iqw_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ọwaa ekemu, Ojejoje tụru; sụ: ‘Unu kfuru ndu Ízurẹlu t'ẹphe kpụtaru nggụbe Mósisu nwada eswi, eke uswuswe; ọphu te enwedu ọru, nọ iya l'ẹhu; to nwe ntụpo, o nweru; t'ọ bụ l'e gudejewa iya jee ozi. ");
INSERT INTO iqw_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Unu kpụta nwada eswi ono kpẹe Eliyéza, bụ onye achịjeru Nchileke ẹja. T'a kpụta iya kpụfu l'ọdu ndu Ízurẹlu; je egbua ya ẹya l'ifu. ");
INSERT INTO iqw_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Tẹ Eliyéza, bụ onye achịjeru Nchileke ẹja tsẹe mkpụshi-ẹka iya lẹ mee ya phee ya l'ụzo ifu Ụlo-Ẹ́kwà Ndzuko ono ugbo ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nwada eswi ono bẹ aa-kpọ ọku l'ifu iya; kpọo akpọ-ẹhu iya ọku; mẹ anụ iya; mẹ mee ya; mẹ nshị iya. ");
INSERT INTO iqw_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Onye ono, achịjeru Nchileke ẹja ono e-wota oshi sida; mẹ ẹswa isopu; mẹ òwúú uswe chịru chee l'ọku ono, e gude akpọ nwada eswi ono ọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Teke ono; bẹ onye ono, achịjeru Nchileke ẹja ono e-gude mini saa uwe iya; gude mini ghụa ẹhu. O -metsule iya phụ ẹge ono; yọ batawaru l'ọdu ndu Ízurẹlu. Ọle ọo-nọdu ọnodu onye aasọ nsọ jeye l'urẹnyashi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Onye bụ iya kpọru nwada eswi ono ọku e-gudekwaphu mini saa uwe iya; gude mini ghụa ẹhu; yọ nọdukwaphu ọnodu onye aasọ nsọ jeye l'urẹnyashi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Onye ọphu ẹ taa sọdu nsọ e-kpota ntụ nwada eswi ono je awụshi l'ẹke ẹ te merudu emeru l'azụ ọdu ndu Ízurẹlu. Yọ bụru l'ẹke ono; bẹ aa-wụshiru iya ndu Ízurẹlu t'ẹphe gude meje kẹ mini, eegudeje asafụ madzụ ntụru; gude iya eme kẹ ọsafu iphe, dụ ẹji. ");
INSERT INTO iqw_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Onye bụ iya kpotaru ntụ ono a-sa uwe iya asasa; yọ nọdu ọnodu onye aasọ nsọ jeye l'urẹnyashi mbọku ono. Ome-l'alị ono a-nọduwaru gbururu jeyewaru. Ọo-nọduru ndu Ízurẹlu; nọduru ndu laru alala, ẹphe l'ẹphe bu. ");
INSERT INTO iqw_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ ‘Onye denyiru odzu onye nwụhuru anwụhu ẹka a-bụru onye aasọ nsọ ujiku ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Onye ọbu e-gude mini ono, eegudeje asafụ ntụru ono saa onwiya lẹ mbọku k'ẹto ya; mẹ lẹ mbọku k'ẹsaa ya; tẹmanu yọ dụ mma. Ọle; ọ -bụru l'ẹ t'ọ safụdu onwiya lẹ mbọku k'ẹto; mẹ lẹ mbọku k'ẹsaa ya ono; b'ọ bụkwaphu onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Iphe, bụ onye meru odzu onye nwụhuru anwụhu ẹka; tọ safu onwiya bụkwa ụlo-ẹ́kwà Ojejoje bẹ oomeru emeru. Onye ọbu bẹ ee-bufu l'ẹke ndu Ízurẹlu nọ. Ọo-bụru onye aasọ nsọ; kẹ l'e te phedu iya mini, eegudeje asafu madzụ ntụru l'ẹhu. Ntụru ono nọkwadu iya-a l'ẹhu ẹge ọono iya ẹya.’ ");
INSERT INTO iqw_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ọwaa bụ ekemu lẹ k'onye nọ l'ime ụlo-ẹ́kwà nwụhu. ‘Iphe, bụ onye nọ l'ẹke ono teke ono; mẹ onye bahụru l'ime ụlo-ẹ́kwà ono teke ono kwaphu a-bụru onye aasọ nsọ abalị ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Iphe, bụ iphe, nọ l'ụlo-ẹ́kwà ono, e gheberu ọnu; te kpuchi iya ekpuchi bẹ aa-sọkwaphu nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ ‘Iphe, bụ onye nọ l'ẹgu denyi ẹka l'odzu onye e gburu lẹ mma; ọdo bụ odzu onye nwụhuru anwụhu mmanu; m'ọ kwanụ l'o denyiru ẹka l'ọkpu onye nwụhuru anwụhu; m'ọ bụ l'ili a-bụru onye aasọ nsọ abalị ẹsaa.’ ");
INSERT INTO iqw_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“A -bya l'ẹke ndu aasọ nsọ; t'ẹphe kpota ntụ ono, shi l'ọku, e gude kpọo ngwẹja iphe, dụ ẹji ọku ono ye l'iphe; ẹphe eje l'ẹke mini, atsọ atsọtso nọ; kuta mini ye iya. ");
INSERT INTO iqw_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ọo ya bụ; onye ẹ ta asọdu nsọ ewota ẹswa isopu tsẹe l'ime mini ono; phee ya l'eli ụlo-ẹ́kwà ono; mẹ l'eli iphe, nọ l'ụlo-ẹ́kwà ono; mẹ l'ẹhu ndu nọ l'ime ụlo-ẹ́kwà ono. Ọ kwaphụ ẹge ono bẹ oo-phe iya iphe bụ onye denyiru ẹka l'ọkpu onye nwụhuru anwụhu; mẹ onye denyiru ẹka l'odzu onye e gburu lẹ mma; ọdo bụ onye denyiru onye nwụhuru anwụhu mmanu ẹka; mẹ onye denyiru ẹka l'ili. ");
INSERT INTO iqw_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Onye ọbu, ẹ taa sọdu nsọ ọbu e-phe onye ono, aasọ nsọ ono mini ono lẹ mbọku k'ẹto; mẹ mbọku k'ẹsaa. O -rua lẹ mbọku k'ẹsaa ya; yọ safu iya ntụru ono. Onye ono, a saru ono asaa uwe iya asasa; gude mini ghụa ẹhu; yọ bya adụ mma l'urẹnyashi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Obenu l'onye aasọ nsọ; ọphu ọ safụdu onwiya asafu bẹ ee-bufu lẹ ndu Ízurẹlu; kẹ l'ọ tụruwaru ẹke-dụ-nsọ kẹ Ojejoje. Eshinu ẹ te phedu iya mini, eegudeje asafu madzụ ntụru b'ọ bụ onye aasọ nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ono bụ ekemu, a-dụru ẹphe gbururu jeyewaru. Onye ono, bụ iya epheje mini ono, eegudeje asafu madzụ ntụru ono bẹ a-sakwaphụ uwe iya asasa. Onye meru ẹka lẹ mini ono, eegudeje asafu ntụru ono a-bụru onye aasọ nsọ jeye l'urẹnyashi mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Iphe, onye aasọ nsọ denyiru ẹka b'e meruwaru emeru; onye denyiru ẹka l'iphe ọbu bẹ aa-nọdu asọ nsọ jeye l'urẹnyashi mbọku ono.” ");
INSERT INTO iqw_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Tọ dụ iya bụ; yo rua l'ọnwa mbụ l'afa; ndu Ízurẹlu l'ẹphe ha ejerua echi-ẹgu Zinu. Ẹphe anọshia lẹ Kadẹ́shi. Miriyamu anwụhu l'ẹke ono; e lia ya l'ẹke ono kwaphu. ");
INSERT INTO iqw_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Teke ono b'ẹ to nwedu mini, nọnu k'ọphu ndu Ízurẹlu a-ngụ. Ẹphe achịkobe onwẹphe tsolahaa Mósisu yẹle Érọnu okfu. ");
INSERT INTO iqw_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ẹphe awata ọbashiru Mósisu mba; sụ: “L'ọ ga akakwaru ẹphe mma; ọ bụ l'ẹphe nwụshihuru teke phụ ndibe ẹphe nwụshihuru l'ifu Ojejoje phụ. ");
INSERT INTO iqw_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","?Bụ gụnu meru; nggu achịta ẹphebe ndu kẹ Ojejoje bya awụshi l'echi-ẹgu ẹke-a t'ẹphe lẹ elu ẹphe nwụshihu? ");
INSERT INTO iqw_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","?Bụ gụnu meru; nggu edufuta ẹphe lẹ Íjiputu bya eduru ẹphe dobe lẹ mkpọkoro ẹke-a, akpe ta nọdu; tọ nọ iya mbụ oshi figu; vayịnu ta nọ iya; ụtara-okumu ta nọ iya; mini, ẹphe a-ngụ, ta nọ iya-a?” ");
INSERT INTO iqw_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Tọ dụ iya bụ; Mósisu yẹle Érọnu alụfu l'ẹke ono, ndu Ízurẹlu dọru ono jeshia l'ọnu Ụlo-Ẹ́kwà Ndzuko je adashịa l'ẹke ono; kpubetsua ifu l'alị. O-gbu-nwịi-nwịi kẹ Ojejoje enwuaru ẹphe kẹ phoo. ");
INSERT INTO iqw_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Wota mgbọro phụ tẹ nggu lẹ nwunne ngu Érọnu chịkobe ndu Ízurẹlu. Kfuru yeru mkpuma l'ẹke ẹphe ele ngu ẹnya tẹ mini shi iya tsọfuta. Ono bụ ẹge ii-shi mee tẹ mkpuma ono tsọfutaru ẹphe mini; k'ọphu ndu Ízurẹlu mẹ elu ẹphe a-ngụ mini.” ");
INSERT INTO iqw_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Tọ dụ iya bụ; Mósisu abya ewota mgbọro ono l'ifu Ojejoje ẹge o kfuru iya. ");
INSERT INTO iqw_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mósisu yẹle Érọnu abya achịkobe ndu Ízurẹlu l'ifu mkpuma ono. Mósisu asụ ẹphe: “Unu ngabẹ nchị nta-a; unubẹ o-kwefuru-íkè phẹ ono. ?Bụ t'ẹphe shi lẹ mkpuma-wa kufutaru unu mini tọo?” ");
INSERT INTO iqw_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Tọ dụ iya bụ; Mósisu ahalia ẹka iya; chia mgbọro ono ugbo labụ l'eli mkpuma ono. Mini eshi lẹ mkpuma ono nwụshihu; ndu Ízurẹlu; mẹ elu ẹphe angụa ya. ");
INSERT INTO iqw_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ọle Ojejoje sụru Mósisu yẹle Érọnu: “Keshinu ọphu unu te ekwetadu nk'iya; mbụ mee tẹ ya dụ nsọ l'ẹnya ndu Ízurẹlu bẹ unu tee duru-hekwa ẹphe alị ono, ya nụru ẹphe ono.” ");
INSERT INTO iqw_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ọwaa bụ mini Meriba; kẹ l'ọo l'ẹke ono bẹ ndu Ízurẹlu nọ tsoru Ojejoje ụswo; Ojejoje ekoshikwanu ẹphe lẹ ya dụ nsọ. ");
INSERT INTO iqw_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mósisu abya eshi lẹ Kadẹ́shi zia ozi t'e je ezia eze ndu Édọmu; sụ: “Ọwaa bụ iphe nwunne ngu, bụ Ízurẹlu kfuru: Unu mawaru egbe iphe-ẹhuka, byakfutaru ẹphe l'ọ ha. ");
INSERT INTO iqw_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Unu mawaru ẹge nna ẹphe oche phẹ gude jeshia Íjiputu; ẹphe ebua lẹ Íjiputu l'ẹke ono nọo ọdu. Ndu Íjiputu akpaa nna ẹphe ono ẹhu nshinu; bya akpakwaa ya phụ ẹphebedua. ");
INSERT INTO iqw_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Obenu lẹ teke ẹphe rakuru Ojejoje b'ọ nụru olu ẹphe; bya ezia ojozi; yọ bya edufuta ẹphe lẹ Íjiputu. Nta-a bẹ ẹphe nọwa lẹ Kadẹ́shi, bụ mkpụkpu, unu l'ẹphe riru ókè-alị. ");
INSERT INTO iqw_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Byiko; hanụa t'ẹphe shia alị unu sweta. Ẹphe te eshikwa ẹgu unu sweta; m'ọ bụ ẹke unu gbaru mgbo vayịnu; ọphu ọ dụdu wẹlu unu, ẹphe e-kuta mini ngụa. Ẹphe e-tsoleruphu echi-gbororo sweta. Ẹphe ta aswịbakwa l'ụzo ẹka-ụtara; ẹphe ta aswịba l'ụzo ẹka-ibyita jeye ẹphe eswekota l'alị unu.” ");
INSERT INTO iqw_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ọle eze ndu Édọmu sụru iya: “Unu be eswetakwa l'alị ẹphe; ọ dụdu bẹ ya e-gudekwa ogu-mbeke byakfuta unu ọgu.” ");
INSERT INTO iqw_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ndu Ízurẹlu asụ iya: “Ẹphe e-shia oje sweta. Ọ -bụru l'ẹphe ngụru mini unu; ọdo l'ọo elu ẹphe ngụru mini unu; ẹphe a-kfụa unu ụgwo iya. Haaru t'ẹphe gude ọkpa sweta; ẹ tọ dụkwa iphe ọdo.” ");
INSERT INTO iqw_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ọle; eze ndu Édọmu sụru t'ẹphe be swetashi. Tọ dụ iya bụ; ndu Édọmu achịta unwoke ẹphe l'igwe, bụ ndu ike dụ; jekfushia ndu Ízurẹlu ọgu. ");
INSERT INTO iqw_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Keshinu ọphu ndu Édọmu te kwedu tẹ ndu Ízurẹlu sweta l'alị ẹphe bẹ ndu Ízurẹlu ghachiru l'ẹke ẹphe nọ. ");
INSERT INTO iqw_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ndu Ízurẹlu awụ-lihu lẹ Kadẹ́shi tụgbua jeye; ẹphe ejerua l'ugvu Họru. ");
INSERT INTO iqw_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","L'ugvu Họru ono, nọnyabe ókè-alị Édọmu bẹ Ojejoje nọ sụ Mósisu yẹle Érọnu: ");
INSERT INTO iqw_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Érọnu bẹ a-nwụhu nụ lakfu ndiche iya phẹ. Ẹ to jerudu alị ono, ya nụru ndu Ízurẹlu ono; kẹ l'unu kwefuru íkè l'ekemu, ya tụru lẹ kẹ mini Meriba. ");
INSERT INTO iqw_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Duta Érọnu yẹle Eliyéza, bụ nwatibe iya t'unu nyihu eli ugvu Họru. ");
INSERT INTO iqw_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Yeshia Érọnu uwe iya woru yee Eliyéza, bụ nwa iya; kẹle Érọnu a-nọdu l'ẹke ono nwụhu lakfu ndiche iya phẹ.” ");
INSERT INTO iqw_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mósisu emee iphe, Ojejoje sụru t'o mee. Ndu Ízurẹlu anọdu ele ẹphe ẹnya; ẹphe enyihu eli ugvu Họru ono. ");
INSERT INTO iqw_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mósisu eyeshia Érọnu uwe iya woru yee Eliyéza, bụ nwatibe iya. Érọnu anwụhu l'eli ugvu l'ẹke ono. Mósisu yẹle Eliyéza eshi l'eli ugvu ono nyizita. ");
INSERT INTO iqw_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ndu Ízurẹlu aphụlephu lẹ Érọnu bẹ nwụhuwaru nụ; iphe, bụ ọnu-ụlo Ízurẹlu araa ẹkwa iya ụkporo abalị l'abalị iri. ");
INSERT INTO iqw_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Teke onye eze Kénanu, l'achị ndu Áradu; mbụ onye ono, bu l'ụzo ọhuda nụru lẹ ndu Ízurẹlu shi l'ụzo Atarimu abya; b'o tsoru ndu Ízurẹlu ọgu; kpụta ndu ọphu ọ kpụtaru lẹ ndzụ. ");
INSERT INTO iqw_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ndu Ízurẹlu eribuaru Ojejoje nte; sụ iya: “Ọ -bụru l'i woru ndu-a yee ẹphe l'ẹka bẹ ẹphe e-mebyishikota mkpụkpu ẹphe l'ọ ha.” ");
INSERT INTO iqw_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ojejoje anụa iphe ndu Ízurẹlu kfuru; woru ndu Kénanu ye ẹphe l'ẹka. Ẹphe emee ndu ono; mẹ mkpụkpu ẹphe; yọ bụru kpurupyata. Tọ dụ iya bụ; e kulahaa ẹke ono Họma. ");
INSERT INTO iqw_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ndu Ízurẹlu abya eshi l'ugvu Họru tụgbua; tsoru ụzo, laru Eze Ẹnyimu Uswe; k'ọphu ẹphe e-shi ẹge ono gbangoo Édọmu. Ẹphe ejenyaa; ẹphe ta dụhe ike takọta nshi. ");
INSERT INTO iqw_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ẹphe awata okfurushi Nchileke yẹle Mósisu; sụ: “?Bụ ngụnu kparu iphe unu dufutaru ẹphe lẹ Íjiputu bya awụshi l'echi-ẹgu-wa t'ẹphe nwụshihu? Nri ta nọdu l'ẹke-a! Mini ta nọ iya! Ẹjo nri-a, ẹphe eriphe-wa bẹ gụ-buhuakwaru ẹphe!” ");
INSERT INTO iqw_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Tọ dụ iya bụ; Ojejoje achịru ẹjo agwọ ye; t'ọ byaru ndu Ízurẹlu ọgu. Yọ taa ẹphe; tagbushia ẹphe l'igwe. ");
INSERT INTO iqw_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ndu Ízurẹlu abyakfuta Mósisu bya asụ iya: “Ẹphe mewaru iphe, dụ ẹji; kẹ l'ẹphe kfurushiru Ojejoje; kfurushia nggụbedua. Kfunuru nụ Ojejoje; k'ọphu oo-wofuru ẹphe agwọ ono.” Ya ndono; Mósisu abya ekfuru nụ Ojejoje l'okfu ẹhu ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ojejoje asụ Mósisu: “T'o meta ẹjo agwọ dobe l'eli itso lanụ; k'ọphu bụ: onye agwọ phụ taru; teke o leru ẹnya l'agwọ kẹ ope ono; yọ dzụru.” ");
INSERT INTO iqw_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ya ndono; Mósisu egude ope meta agwọ; tukobe l'eli itso lanụ. Yọ bụjeru; onye agwọ ono taru; o -lewa ẹnya l'agwọ ono, e meru l'ope ono; yọ dzụru. ");
INSERT INTO iqw_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ndu Ízurẹlu atụgbua; rua Obótu; bya akpọo ụlo-ẹ́kwà ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ẹphe eshi lẹ Obótu tụgbua; je akpọo ụlo-ẹ́kwà ẹphe lẹ Iye-Abarimu l'echi-ẹgu ono, nọ chebe ifu lẹ Móabu l'ụzo ẹnyanwu-ahata. ");
INSERT INTO iqw_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Ẹphe eshi l'ẹke ono tụgbua; rua ọkpa-ugvu Zeredu; bya akpọbe ụlo-ẹ́kwà ẹphe l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ẹphe eshikwaphu l'ẹke ono tụgbua je akpọbe ụlo-ẹ́kwà ẹphe l'azụ Ẹnyimu Amọ́nu azụ iya ọphu; ẹke ono, nọ l'echi-ẹgu, nọ kpaa l'ókè-alị ndu Amọru; kẹ l'ọo Ẹnyimu Amọ́nu bụ ókè-alị ndu Móabu, nọkahuru ndu Móabu ẹphe lẹ ndu Amọru. ");
INSERT INTO iqw_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ọo ya meru iphe e kfuru lẹ Ẹkwo ọ̀gù, Ojejoje; sụ: “Mkpụkpu Wahebu ono, nọ lẹ Sufa yẹle nsụda nsụda Ẹnyimu Amọ́nu; ");
INSERT INTO iqw_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","mẹ lẹ mkpọ-ze mkpọ-ze ono, nọ lẹ nsụda nsụda, nọ je akpaa lẹ mkpụkpu Aru; bya anọo jeye l'ókè-alị ndu Móabu.” ");
INSERT INTO iqw_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ẹphe egbeshi l'ẹke ono kwasẹru bya ejerua Byiye, bụ iya bụ wẹlu ono, Ojejoje sụru Mósisu: “T'ọ chịkobe ndu Ízurẹlu l'ẹkalanu; tẹ ya nụ ẹphe mini t'ẹphe ngụa ono.” ");
INSERT INTO iqw_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Tọ dụ iya bụ; ndu Ízurẹlu agụa egvu-wa; sụ: Nggụbe wẹlu! Wụfuta mini; T'a gụru egvu nụ iya. ");
INSERT INTO iqw_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ọ bụ wẹlu, bụ ndu eze gvuru iya; mbụ l'ọo ndu a maru ẹpha ẹphe lẹ Ízurẹlu bẹ tụru iya nụ. Ọ bụ mgbọro ndu eze; mẹ mgbọro nk'ẹphe; bẹ ẹphe gude tụa ya. Tọ dụ iya bụ; ẹphe eshi l'echi-ẹgu jeshia Mátana; ");
INSERT INTO iqw_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","shi lẹ Mátana lụfu lẹ Nahalẹlu; shi lẹ Nahalẹlu lụfu lẹ Bamọtu; ");
INSERT INTO iqw_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","shi lẹ Bamọtu lụfu lẹ nsụda, nọ l'alị Móabu lẹ mgboro Ugvu Pishiga, bụ ẹke eeshije ele alị, daburu swanmangu. ");
INSERT INTO iqw_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Tọ dụ iya bụ; ndu Ízurẹlu ezia ozi t'e je zia Sihọnu, bụ eze ndu Amọru; sụ iya: ");
INSERT INTO iqw_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“T'ẹphe swetanu l'alị unu. Ẹphe ta aswịbakwa l'ẹgu unu; ẹphe ta aswịba lẹ mgbo vayịnu unu. Ọphu ọ dụdu wẹlu unu, ẹphe bya l'e-kuta mini ngụa. Ọ bụlephu esu-ụzo bẹ ẹphe e-tsoru jeye ẹphe eswekota alị unu.” ");
INSERT INTO iqw_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Obenu lẹ Sihọnu te kwedu tẹ ndu Ízurẹlu sweta l'alị iya. Yọ chịkobe ndu nk'iya l'ẹphe ha; ẹphe ejekfushia ndu Ízurẹlu ọgu l'echi-ẹgu. Ẹphe erulẹphu mkpụkpu Jahazu; yo tso ndu Ízurẹlu ọgu. ");
INSERT INTO iqw_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ndu Ízurẹlu egude ogu-mbeke gbua ya; nata iya alị iya ono; shita lẹ Ẹnyimu Amọ́nu je akpaa lẹ Ẹnyimu Jábọku; jeyewaru l'alị ndu Amọnu; kẹ l'ókè-alị ndu Amọnu b'e gude ụpho-mkpuma kpụa mgburumgburu; yo shihu ike. ");
INSERT INTO iqw_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ndu Ízurẹlu alụtakota mkpụkpu ndu Amọru l'ọ ha; buchikota iya; lụtakota Hẹ́shibonu; mẹ iphe, bụ mkpụkpu, nọ-pheru iya mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hẹ́shibonu bẹ bụ mkpụkpu Sihọnu, eze ndu Amọru. Yẹle onye, shi bụru eze ndu Móabu lụjeru ọgu; Sihọnu alụtakota alị iya je akpaa lẹ Ẹnyimu Amọ́nu. ");
INSERT INTO iqw_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ọo ya meru iphe ndu ẹvu-egvu agụje; sụ: “Bya Hẹ́shibonu; t'a kpụa ya; mbụ t'a kpụa mkpụkpu Sihọnu; t'o shihu ike. ");
INSERT INTO iqw_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Kẹ l'ọku shi lẹ Hẹ́shibonu kpụfu; ọku eshi lẹ Sihọnu kpụfu. O tsuwaru mkpụkpu Aru kẹ ndu Móabu; mbụ ndu nwe ugvu, nọgbaa l'iku Ẹnyimu Amọ́nu. ");
INSERT INTO iqw_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Nshọo unubẹ ndu Móabu! E mebyishiwaru unu; unubẹ ndu anọduje agwa agwa Kemọshu! Ụnwegirima unwoke unu b'o mewaru; ẹphe agbakashịhu lashia alị ọdo. Ụnwegirima ụnwanyi unu b'o mewaru; ẹphe abụwaru ndu a kpụru lẹ ndzụ nụ Sihọnu, bụ eze ndu Amọru. ");
INSERT INTO iqw_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ayi gweekwaru ẹphe egwegwe; tsube lẹ Hẹ́shibonu je akpaa lẹ Díbọnu. Ẹphe gwewaru ẹphe ogwe ẹkfu jeye lẹ Nofa; mbụ je akpaa lẹ Médebà.” ");
INSERT INTO iqw_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Tọ dụ iya bụ; ndu Ízurẹlu eburu l'alị ndu Amọru. ");
INSERT INTO iqw_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mósisu abya ezia ndu e-je ngge lẹ mkpụkpu Jáza; ẹphe ejetsulephu; ndu Ízurẹlu eje alụa mkpụkpu, nọ iya nụ; chịkashia ndu Amọru, shi buru l'ẹke ono. ");
INSERT INTO iqw_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Tọ dụ iya bụ; ndu Ízurẹlu aghakọbe shia ụzo ọphu shiru jeshia alị Báshanu. Ọgu, bụ eze ndu Báshanu achịta ndu nk'iya l'ẹphe ha jekfushia ẹphe ọgu lẹ mkpụkpu Edereyi. ");
INSERT INTO iqw_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ojejoje asụ Mósisu: “Ba atsụkwa Ọgu egvu; kẹle ya wowaru iya ye ngu l'ẹka; mẹ ndu nk'iya; mẹ alị iya. Mekwaa ya iphe, i meru Sihọnu, bu eze, bu lẹ Hẹ́shibonu achị ndu Amọru.” ");
INSERT INTO iqw_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ya ndono; ndu Ízurẹlu egbua Ọgu; gbushia ụnwegirima iya; mẹ ndu nk'iya l'ẹphe ha; k'ọphu bụ l'ẹ tọ dụdu onye wafụru nụ l'ime ẹphe. Ndu Ízurẹlu anata alị iya nweru. ");
INSERT INTO iqw_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ndu Ízurẹlu atụgbua jerua phorokoto alị ndu Móabu; bya akpọo ụlo-ẹ́kwà ẹphe l'iku Ẹnyimu Jọ́danu, nọ chebe ifu lẹ Jériko. ");
INSERT INTO iqw_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balaku Zipo aphụa iphe bụ iphe, ndu Ízurẹlu meru ndu Amọru. ");
INSERT INTO iqw_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ndu Móabu atsụlahaa egvu; kẹle ndu Ízurẹlu dụ l'igwe. Ẹhu erushihu ndu Móabu l'ẹke ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ndu Móabu ejekfu ndu bụ ọgurenya ndu Mídiya je asụ ẹphe: “Lẹ nta-a bẹ ikpoto ndu Ízurẹlu-a a-tụko iphe, bụ ndu gbaru ẹphe mgburumgburu lụ-gbushikota ẹge eswi, atụkoje ẹswa, nọ l'ẹgu taa.” L'oge teke ono bụ Balaku Zipo bẹ bụ eze ndu Móabu. ");
INSERT INTO iqw_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Yo zia t'e eje ekua Bélamu Beyọ, bụ onye nọ lẹ mkpụkpu Petọ l'alị Amawu lẹ mgboro Ẹnyimu Yufurétusu. Balaku ezia ya; sụ: “L'o nweru ndu shi Íjiputu lụfuta; bya atụko mgboko dzuru. Nta-a bẹ ẹphe nọokwa iya lẹ mgboro. ");
INSERT INTO iqw_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Iphe, ya arọ ngu nta-a bụ t'ị bya atụaru iya ndu ono ọnu; kẹ l'ẹphe ka iya ike. O nwekwaru ẹge ọo-dụ; ya alụ-gbua ẹphe; chịa ẹphe l'alị-a. Ishi iya abụru lẹ ya maru l'onye ị gọru ọnu bẹ bụwa onye a gọru ọnu; onye ị tụru ọnu abụru onye a tụru ọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Tọ dụ iya bụ; ndu bụ ọgurenya ndu Móabu; mẹ ndu bụ ọgurenya ndu Mídiya egude ụgwo, aakfụje t'a gbaa ẹja jekfushia Bélamu; je ezia ya ozi ono, Balaku ziru ono. ");
INSERT INTO iqw_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bélamu asụ ẹphe: “Unu radụ l'ẹke-a l'ẹnyashi-a; k'ọphu ya a-karu unu iphe, Ojejoje e-kfuru iya.” Tọ dụ iya bụ; Bélamu yẹle ndu ishi Móabu ono atụko nọdu. ");
INSERT INTO iqw_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nchileke abyakfuta Bélamu bya ajịa ya; sụ: “?Bụ ndu ole bẹ nggu l'ẹphe nọ ono?” ");
INSERT INTO iqw_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bélamu asụ Nchileke: “Lẹ Balaku Zipo, bụ eze ndu Móabu bẹ ziru iya ozi; sụ ");
INSERT INTO iqw_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","l'o nweru ndu shi lẹ Íjiputu lụfuta bya atụko mgboko dzuru. L'ọo tẹ ya bya atụaru iya ndu ono ọnu; l'o nweru ẹge ọo-dụ; ya emekputa ẹphe; chịshia ẹphe l'alị ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nchileke asụ Bélamu: “Be etsokwa ẹphe je; ba atụkwa ndu ono ọnu; kẹ l'ẹphe bụkwa ndu a gọru ọnu-ọma nụ.” ");
INSERT INTO iqw_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Yo rua l'ụtsu iya; Bélamu alụfuta bya ekfuaru ndu ishi ono, ejeru Balaku ozi ono; sụ ẹphe: “Unu lashia alị unu; lẹ Ojejoje te kwekwa tẹ ya tsoru unu je.” ");
INSERT INTO iqw_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Tọ dụ iya bụ; ndu ishi Móabu ono atụgbua lashia je asụ Balaku: “Lẹ Bélamu jịkakwaru le ya te etsodu ẹphe.” ");
INSERT INTO iqw_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaku abya ezifu ndu ishi ọdo, kaba l'igwe; mbụ ndu a ka ọkwabe ugvu ama lẹ ndu kẹ mbụ phụ. ");
INSERT INTO iqw_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ẹphe abyakfuta Bélamu bya asụ iya: “Ọwaa iphe, Balaku Zipo kfuru. Ọ sụru: T'ẹ b'ọ dụkwa iphe, ii-kwe t'ọ kpọshia ngu ọbya nk'iya. ");
INSERT INTO iqw_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ishi iya abụru lẹ ya a-kwabẹ ngu ugvu, ha nshinu; bya emeeru ngu iphe, ị sụru tẹ ya meeru ngu. Byiko; byanụ bya atụaru iya ndu-a ọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bélamu asụ ndu ozi Balaku ono: “M'o -ruhuru Balaku bya a-nụ iya ụlo iya ono, mkpọla-ododo waa mkpọla-ọcha jiru ejiji ono; bẹ ya te emeghatadụ iphe Ojejoje, bụ Nchileke iya kfuru. Ya te ewofudu iya iphe; ọphu ya 'eyekwakwa iya iphe. ");
INSERT INTO iqw_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Unu radụ ẹge ndu ọphunanu radụjeru phụ tẹ ya maru m'o -nweru iphe, Ojejoje e-kfubaa yeru iya.” ");
INSERT INTO iqw_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Nchileke abyakfuta Bélamu l'ẹnyashi bya asụ iya: “Ọ -bụru l'ọo oku; bẹ ndu-a byaru ngu ekuku; gbeshi tsoru ẹphe; ọo l'ọo iphe, ya sụru t'i mee bẹ ii-me nwẹnkinyi.” ");
INSERT INTO iqw_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bélamu egbeshi l'ụtsu dozia nkakfụ-ịgara iya tsoru ndu ishi Móabu ono; ẹphe tụgbua. ");
INSERT INTO iqw_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ọle ẹhu ghuru Nchileke eghughu nshinu l'ọ tụgburu jeshia ono. Ojozi Ojejoje eje akfụchia ya ụzo. Teke ono bẹ Bélamu nọ l'eli nkakfụ-ịgara iya agba eje yẹle ndu ozi iya ụmadzu ẹbo ayịru. ");
INSERT INTO iqw_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nkakfụ-ịgara ono aphụlephu ojozi Ojejoje ono; l'ẹke oovudo l'esu-ụzo; mịfuta ogu-mbeke ya gude l'ẹka; haa ụzo ono swịba l'ẹgbudu. Bélamu echilahaa nkakfụ-ịgara ono iphe t'ọ ghazia ya t'ọ laphu azụ l'ụzo. ");
INSERT INTO iqw_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ojozi Ojejoje ono eje evudo l'owere ụzo, nọ lẹ mgbaku mgbo vayịnu ẹbo, ụpho-mkpuma nọgbaa ẹka labụ. ");
INSERT INTO iqw_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Nkakfụ-ịgara ono aphụlephu ojozi Ojejoje ono; nwuta onwiya laa l'ụpho-mkpuma ono; nwuta Bélamu ọkpa tsua l'ụpho-mkpuma ono; Bélamu echia ya iphe ọdo. ");
INSERT INTO iqw_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ojozi Ojejoje ono atụgbukwaa je evudo l'ẹke dụ gbịriri. Ẹke ono te nwedu ụzo, ee-shi swịa ẹka-ụtara; m'ọ kwanụ swịa l'ẹka-ibyita. ");
INSERT INTO iqw_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Nkakfụ-ịgara ono aphụlephu ojozi Ojejoje ono; bya anmakpuru lẹ mkpuli Bélamu; ẹhu eghulahaa Bélamu eghughu; yo chilahaa ya mgbọro iya. ");
INSERT INTO iqw_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ojejoje akụhaa nkakfụ-ịgara ono ọnu; yo kfuru okfu nụ Bélamu; sụ iya: “?Bụ ngụnu bẹ ya meru ngu, meru iphe, i chiru iya iphe ugbo ẹto?” ");
INSERT INTO iqw_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bélamu asụ nkakfụ-ịgara ono: “Iphe, ya gude echi ngu iphe bẹ bụ l'iime iya eswe. Ọ -bụru t'a sụ lẹ ya gude ogu-mbeke l'ẹka mẹ ya eworu ngu gbua nta-a.” ");
INSERT INTO iqw_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nkakfụ-ịgara ono asụ Bélamu: “?Ya ta bụdu nkakfụ-ịgara, i nwe enwenwe, i shihawa keshinu ụwa gbata jeye ntanụ-a. ?Ya mejewaru ngu ẹge-a?” Bélamu asụ iya: “Waawa.” ");
INSERT INTO iqw_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ya ndono; Ojejoje abya emee t'ẹnya sahụ Bélamu. Yọ phụa ojozi Ojejoje ono l'ẹke o vudo l'ụzo; mịfuta ogu-mbeke ya paru l'ẹka. Bélamu efozita ishi; daa; kpube ifu l'alị. ");
INSERT INTO iqw_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ojozi Ojejoje ono ajị iya; sụ: “?Bụ ngụnu meru iphe, i chiru nkakfụ-ịgara ngu iphe ugbo ẹto-a? Ya byaru tẹ ya bya anọ-chia ngu ụzo; kẹ l'ụzo, i cheberu ifu bẹ gberu nggọ l'ẹnya mu. ");
INSERT INTO iqw_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ugbo ẹto bẹ nkakfụ-ịgara-wa phụru iya; tọchikotaru iya. Ndẹge ẹ tọ tọduru iya l'ụzo; mẹ ya ewowaru ngu gbua nta-a; haa yẹbedua t'ọ nọdu ndzụ.” ");
INSERT INTO iqw_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bélamu asụ ojozi Ojejoje ono: “Ya mewaru iphe, dụ ẹji; kẹle ya ta madu l'i vudo nọ-chia iya ụzo. Ọo ya bụ; ọ -bụru l'ẹ tọ dụdu ngu mma tẹ ya jee; ya alaphu azụ.” ");
INSERT INTO iqw_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ojozi Ojejoje ono asụ Bélamu: “T'o tsoruru ndu ono je; ọle t'ọ bụkwaru iphe, ya sụru t'o kfua bẹ oo-kfu nwẹnkinyi.” Tọ dụ iya bụ; Bélamu yẹle ndu ishi ono, ejeru Balaku ozi ono atụgbua; yọ bụru ẹphe ejeje. ");
INSERT INTO iqw_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaku anụlephu lẹ Bélamu abyawa; lụfu jeshia ya ndzuta lẹ mkpụkpu, nọ l'alị Móabu l'oke Ẹnyimu Amọ́nu; mbụ l'ime ime ẹke ókè-alị ono. ");
INSERT INTO iqw_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaku asụ Bélamu: “Ya ziru ozi, dụ ọku-ọku t'a bya ekua ngu t'ị bya. ?Bụhunu ngụnu meru iphe, ẹ tị byakebedu? ?Bụ lẹ ya ta adụdu ike akwabẹ ngu ugvu tọo?” ");
INSERT INTO iqw_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bélamu asụ Balaku: “Ọ dụ mma; ya byawaru. Ọlobu; ?bụlephu iphe dụ iya mma bẹ ya e-kfu tọo? Ọ bụlekwaphu okfu, Nchileke yeru iya l'ọnu bẹ ya e-kfu.” ");
INSERT INTO iqw_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Tọ dụ iya bụ; Bélamu etsoru Balaku; ẹphe ejeshia Kiriyatu Huzotu. ");
INSERT INTO iqw_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaku egbushia eswi; mẹ atụru gude gwoo ngwẹja; bya aharu nụ Bélamu yẹle ndu ishi ono yẹle iya yị ono. ");
INSERT INTO iqw_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Yo be l'ụtsu echile iya; Balaku eduta Bélamu; ẹphe atụgbua jeshia Bamọtu-Bálụ; Bélamu eshi l'ẹke ono haru phụ ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bélamu asụ Balaku: “Kpụaru iya ẹnya-ngwẹja ẹsaa. Nggu akpụtaru iya oke-eswi ẹsaa; waa ebyila ẹsaa.” ");
INSERT INTO iqw_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaku abya emee ẹge Bélamu kfuru. Ẹphe ẹbo egbua oke-eswi; mẹ ebyila ono nanụ nanụ l'ẹnya-ngwẹja ono iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Bélamu asụ Balaku: “Vudo lẹ mgboro ngwẹja-ukfuru ono tẹ ya tụgbua. O nweru ẹge ọo-dụ; Ojejoje abyakfuta iya. Iphe, bụ iphe, o koshiru iya bẹ ya a-kọru ngu-a.” Yọ tụgbua jeshia l'eli nwugvu, ẹ-ta adụdu iphe, nọ iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nchileke abyakfuta Bélamu. Bélamu asụ Nchileke: “Ya doziwaru ẹnya-ngwẹja ụzo ẹsaa; bya egbuwa oke-eswi yẹle ebyila nanụ nanụ l'ẹnya-ngwẹja ono ẹphe ẹsaa.” ");
INSERT INTO iqw_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Tọ dụ iya bụ; Ojejoje eye Bélamu okfu l'ọnu sụ iya: “Laphu azụ jekfu Balaku je ezia ya ozi-wa.” ");
INSERT INTO iqw_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Yo jekfushia Balaku; bya aphụ iya ẹge oovudo lẹ mgboro ngwẹja-ukfuru ono yẹle ndu ishi Móabu l'ẹphe ha. ");
INSERT INTO iqw_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Bélamu ekfulahaa; sụ: “Lẹ Balaku byaru bya eduta iya lẹ Áramu; Eze ndu Móabu; eduta iya l'alị ugvu ụzo ẹnyanwu-ahata; sụ iya: ‘Tẹ ya tụaru iya ụnwu Jékọpu ọnu; ya ekfubyi-a ụnwu Ízurẹlu ekfubyi!’ ");
INSERT INTO iqw_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ọ bụ; ?nanụ ẹge ya e-shi tụa ndu Nchileke ẹ-ta atụdu ọnu ọnu. ?Nanụ ẹge ya e-shi kfubyia ndu Ojejoje ẹ-te kfubyidu? ");
INSERT INTO iqw_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ọo l'eli eze mkpuma; bẹ ya anọduje phụ ẹphe. Yọ bụru l'eli ugvu; bẹ ya anọduje ele ẹphe ẹnya; mbụ ndu ono, dụ iche ono. Ẹphe ta agụjeduru onwẹphe eyeru ndu ọhodo. ");
INSERT INTO iqw_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","?Bụ onye a-dụ ike gụta ụnwu Jékọpu l'ọgu; mbụ ndu ha l'ọ bụ evevee, nọ l'alị. Mbụ; ?bụ onye a-dụ ike gụta nkere-ẹno ụnwu Ízurẹlu l'ọgu. Tẹ ya nwụhukwa anwụhu onye doberu ẹka ndoo! Tẹ ya lakwaa ẹge ndu doberu ẹka ndoo alajẹ!” ");
INSERT INTO iqw_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaku asụ Bélamu: “?Bụ ngụnu b'i meru iya ẹge ono? Ya sụru ngu t'ị bya atụa ndu ọhogu iya ọnu; yo gbe bụru ọnu b'ị gọru nụ ẹphe!” ");
INSERT INTO iqw_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Bélamu asụ: “?Bụ tẹ ya be kfushi iphe, Ojejoje yeru iya l'ọnu tẹ ya kfua tọo?” ");
INSERT INTO iqw_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaku asụ Bélamu: “Tsoru iya t'ẹphe je l'ẹke ọdo, ịi-nọdu phụ ẹphe. Ẹ tịi phụkotakwa ẹphe l'ẹphe ha. Ọ kwa ụphodu l'ime ẹphe bẹ ịi-phụ. Shi l'ẹke ono tụaru iya ẹphe ọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Balaku eduta Bélamu; ẹphe ejeshia l'ẹgu mkpụkpu Zofimu, nọ l'eli ugvu Pishiga; yọ kpụa ẹnya-ngwẹja ụzo ẹsaa. Ẹphe egbushia oke-eswi yẹle ebyila nanụ nanụ l'ẹnya-ngwẹja ono iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bélamu asụ Balaku: “Vudo lẹ mgboro ngwẹja-ukfuru ono tẹ ya jekfu Ojejoje l'ẹkaphu.” ");
INSERT INTO iqw_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ojejoje abyakfuta Bélamu; bya eye iya okfu l'ọnu; sụ: “Laphu azụ ọdo je ezia Balaku ozi-a.” ");
INSERT INTO iqw_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Bélamu abya ejekfu Balaku; phụa ya l'ẹke oovudo lẹ mgboro ngwẹja-ukfuru ono yẹle ndu ishi Móabu, yẹle iya tụko nọdu. Balaku asụ Bélamu: “?Bụ ngụnu bẹ Ojejoje kfuru?” ");
INSERT INTO iqw_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bélamu ekfushilahaa; sụ: “Nggụbe Balaku; gbeshi egbeshi ngabẹ nchị! Nụa iphe, ya ekfu; nggụbe nwatibe Zipo. ");
INSERT INTO iqw_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nchileke ta abụkwa madzụ mmanu; k'ọphu ọo-bya adzụlahaa ẹjo-ire. Ọphu ọ bụkwanu nwa ndiphe; kẹ t'ọ gbanwee obu iya. ?O kfujewaru okfu; to me iya ẹge o kfuru? ?O kwejeru ụkwa iphe; to medzu ụkwa iphe ọbu tọo? ");
INSERT INTO iqw_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Mbụ l'agha; ozi, ya nataru bụkwa tẹ ya gọoru ndu ono ọnu. Nchileke gọwaru ẹphe ọnu; ọphu ya ta a-dụkwa ike agbanwe iya. ");
INSERT INTO iqw_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ẹ tọ dụdu iphe, dụ ẹji, ọ phụru l'ẹhu ụnwu Jékọpu; ọphu ọ dụdu iphe, ẹ-ta dụdu mma, ọ phụru l'ẹhu ụnwu Ízurẹlu. Ojejoje, bụ Nchileke ẹphe swiru ẹphe ọkpobe eswiru. Ẹphe anọduje atụ ụzu l'ọ bụ eze ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nchileke; bẹ dufutaru ẹphe lẹ Íjiputu; bya emee ẹphe; ẹphe enweru ọkpehu l'ọ bụ atsụ. ");
INSERT INTO iqw_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ẹ te egudeghedu ọgvu gwọta ụnwu Jékọpu. Ọphu eegudeghedu agwụgwo mekata ụnwu Ízurẹlu. Nta-a bẹ ee-kfu okfu ẹhu ụnwu Jékọpu; kfua okfu ẹhu ụnwu Ízurẹlu; sụ: ‘Unu leduduphu iphe, Nchileke meeberu!’ ");
INSERT INTO iqw_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ndu Ízurẹlu angụ-lihuje l'ọ bụ nne agụ. Ẹphe anọduje ebu nggada l'ọ bụ agụ, ẹ-ta azẹjedu azẹe jeye yọ labushia anụ, o gburu; mbụ jeye; yọ ngụa mee-iphe, o guderu.” ");
INSERT INTO iqw_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Tọ dụ iya bụ; Balaku asụ Bélamu: “Ba tụkwa ẹphe ọnu lẹ phuu; ọphu ị gọkwaru ẹphe ọnu lẹ phuu!” ");
INSERT INTO iqw_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bélamu asụ Balaku: “?Ya te kfuduru ngu l'ọo iphe, Ojejoje kfuru bẹ ya e-me?” ");
INSERT INTO iqw_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Tọ dụ iya bụ; Balaku asụ Bélamu: “Bya tẹ ya duru ngu je ẹke ọdo. O nweru ike; yọ dụ Nchileke mma t'i shi l'ẹke ono tụaru iya ẹphe ọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaku eduta Bélamu; ẹphe enyihu ọnonu ugvu Peyọ; mbụ ugvu ono, nọ chebe ifu l'alị, daburu swanmangu ono. ");
INSERT INTO iqw_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bélamu asụ Balaku: “Kpụaru iya ẹnya-ngwẹja ẹsaa l'ẹke-a; nggu akpụtaru iya oke-eswi ẹsaa; ọwaa ebyila ẹsaa.” ");
INSERT INTO iqw_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaku emee ya ẹge Bélamu sụru t'o mee ya. Ẹphe egbua oke-eswi ono yẹle ebyila ono nanụ nanụ l'ẹnya-ngwẹja ono iche l'iche. ");
INSERT INTO iqw_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bélamu abya aphụa l'iphe, dụ Ojejoje mma bụ t'a gọru ọnu-ọma nụ ndu Ízurẹlu; o jeheduru ọji ẹge ọojijehawa. Iphe, o meru bụ l'o woru ifu ghaa l'ụzo echi-ẹgu. ");
INSERT INTO iqw_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bélamu abya apalia ẹnya imeli; phụa ndu Ízurẹlu l'ẹke ẹphe kpọbegbaaru ụlo-ẹ́kwà ẹphe l'ikfu l'ikfu. Ume Nchileke abya iya l'ẹhu; ");
INSERT INTO iqw_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","yo kfulahaa; sụ: “Ọwaa iphe Bélamu Beyọ l'ekfu; Ọ kwa onye ono, e meru; ẹnya asahụ ono ekfu iya. ");
INSERT INTO iqw_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ọwaa okfu, onye ono, anụje okfu, shi l'ẹka Nchileke ono ekfu; mbụ onye ono, aphụje iphe, Ọkaribe-Kakọta-Ike ekoshi ono; mbụ onye ono, adaje kpurumu l'alị; bya abụru onye e meru; ẹnya asahụ iya. ");
INSERT INTO iqw_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ẹge ụlo-ẹ́kwà ngu amabe mma; nggụbe Jékọpu; mbụ ẹke nggụbe Ízurẹlu bu ebubu! ");
INSERT INTO iqw_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ọo ẹge nsụda nsụda adụje-a bụ ẹge ọ sụsaru asụsa. Ọ dụ l'ọ bụ mgbabu, a gbaru l'iku ẹnyimu. Ọ dụ l'ọ bụ oshi alowe, Ojejoje yeru l'onwiya; bya adụ l'ọ bụ oshi sida, gvuru l'iku ẹnyimu. ");
INSERT INTO iqw_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Mini e-shije l'ite-mini Ízurẹlu l'atsọshi atsọshi. Ẹphe e-nweru mini nweru k'etsubo iya. Eze ẹphe a-ka eze Agagu. Alị-eze ẹphe bẹ aa-pali eli. ");
INSERT INTO iqw_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Nchileke dufutaru ẹphe lẹ Íjiputu; bya emee ẹphe; ẹphe enweru ọkpehu l'ọ bụ atsụ. Iphe, bụ mbakeshi ndu ọphu ẹphe dụ ashị; bẹ ẹphe e-ripya eripya; tsua ọkpu ẹphe yọgiriyogiri. Ẹphe e-gude arwa ẹphe nmafushia ẹphe anmafushi. ");
INSERT INTO iqw_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ízurẹlu nmakpuru anmakpuru; zẹru l'ọ bụ agụ. Ọ zẹ l'ọ bụ nne agụ; ?bụ onye a-dụ ike kpatsua ya. Tẹ iphe, bụ ndu gọru ụnwu Ízurẹlu ọnu bụkwaru ndu a gọru ọnu. Tẹ iphe, bụ ndu tụru unu ọnu bụkwaruphu ndu a tụru ọnu.” ");
INSERT INTO iqw_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tọ dụ iya bụ; ẹhu eghulahaa Balaku eghughu l'ẹke Bélamu nọ. Yọ kụa ẹka pamụ; sụ Bélamu: “Nta-a bẹ ya kuru ngu t'ị bya atụaru iya ndu ọhogu iya ọnu; yo gbe bụru ọnu b'ị gọru nụ ẹphe ugbo ẹto-a. ");
INSERT INTO iqw_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ngwaa; gude ọso gbagbụa lashia nk'unu nta-a! Ya shi rịa kẹ tẹ ya kwabẹ ngu ugvu, ha nshinu; obenu lẹ Ojejoje bẹ nafụwaru ngu ugvu ono.” ");
INSERT INTO iqw_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bélamu ajị Balaku sụ iya: “?Ya te kfuduru iya ndu i ziru t'ẹphe bya ekua ya; sụ: ");
INSERT INTO iqw_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘M'o -ruhuduru Balaku nụ iya ụlo iya ono, mkpọla-ododo mẹ mkpọla-ọcha jiru ejiji ono bẹ ya te emeghatakwa iphe, Ojejoje sụru tẹ ya mee; ya te egudedu uche k'onwiya l'eme iphe, dụ mma; m'ọ kwanụ iphe, dụ ẹji. Ọ bụlephu iphe, Ojejoje kfuru bẹ ya e-kfu.’ ");
INSERT INTO iqw_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nta-a bẹ ya a-lakfuakwa ndibe iya. Ọle byakwa tẹ ya nmaaru ngu ọkwa iphe, ndu ono e-mekochaa mee ndibe unu lẹ teke nọ l'ifu.” ");
INSERT INTO iqw_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Tọ dụ iya bụ; Bélamu ekfulahaa; sụ: “?Ọwaa bụ iphe, Bélamu Beyọ ekfu; mbụ okfu, onye e meru; ẹnya asahụ asahụ ekfu. ");
INSERT INTO iqw_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ọwaa bụ okfu, onye ono, anụje okfu, Nchileke ono ekfu; mbụ onye ono, maru iphe, shi Ọkaribe-Kakọta-Nụ l'ẹka; mbụ onye ono, aphụje iphe, Ọkaribe-Kakọta-Ike ekoshi; onye ono, daru kpurumu; bya abụleru-a onye ono, e meru; ẹnya asahụ ono. ");
INSERT INTO iqw_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ya phụru onye ono; ẹ-tọ bụdu nta-a. Ya ele onye ọbu ẹnya; ọle ẹ tọ nọdu ntse. Mkpọro eze e-shi l'ọnu-ụlo Jékọpu lụfuta. Onye eze a-lụfuta lẹ Ízurẹlu. Móabu bẹ ọo-tụko ókè-alị iya rakaa araka; tụko ụnwu Sheti l'ophu mebyishia. ");
INSERT INTO iqw_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ndu Édọmu bẹ aa-lụta l'ọgu; Ọ kwaphụ ẹge ono; bẹ aa-lụta ndu Séyi, bụ ndu ọhogu Ízurẹlu. Obenu lẹ ndu Ízurẹlu; bẹ a-nọdu aka ike l'eje. ");
INSERT INTO iqw_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Onye ishi e-shi l'ọnu-ụlo Jékọpu lụfuta; bya emebyishia ndu ọphu wafụru nụ lẹ mkpụkpu ono.” ");
INSERT INTO iqw_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Bélamu abya aphụa ndu Amalẹku; kfushilahaa; sụ: “Ndu Amalẹku bụ ivuzọ l'iphe bụ mbakeshi; obenu l'ẹphe a-bụru kpurupyata l'ikperazụ.” ");
INSERT INTO iqw_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Yọ bya aphụa ndu Kenu; sụ: “Ẹke unubẹ ndu Kenu, bu ebubu b'e meru; yo shihu kẹ dụngudungu. Nwamkpu, unu tụru; bẹ unu tụru l'eli mkpuma. ");
INSERT INTO iqw_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ọle unubẹ ndu Kenu; bẹ aa-lụkwa alụlu. Ndu Asiriya a-kpụko unu lẹ ndzụ.” ");
INSERT INTO iqw_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Bélamu ekfutsua ono; bya asụ: “?Bụ onye a-nọ ndzụ teke Nchileke a-nọdu eme iphe ono? ");
INSERT INTO iqw_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ụgbo-mini e-shi lẹ Kítimu bya; bya emeshia ndu Asiriya yẹle ndu Eba ike. Obenu l'ẹphebedua a-bụkwaruphu kpurupyata.” ");
INSERT INTO iqw_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Tọ dụ iya bụ; Bélamu ekfutsua ẹge ono; gbeshi; yọ bụru iya alala; Balaku atụgbua lashia. ");
INSERT INTO iqw_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","A nọnyaa lẹ teke ndu Ízurẹlu bu lẹ nsụda Shitimu; ẹphe awata ome k'ẹnyishi ẹji; ẹphe l'ụnwanyi ndu Móabu. ");
INSERT INTO iqw_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ụnwanyi Móabu ono ekuje ndu Ízurẹlu t'ẹphe tsoru ẹphe je ọgwa nte ẹphe. Ndu Ízurẹlu l'erije iphe, a gwaru lẹ nte ono; l'abaru nte ndu Móabu ono ẹja. ");
INSERT INTO iqw_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Tọ dụ iya bụ; ndu Ízurẹlu eworu onwẹphe tụgbabe l'agwa Bálụ-Peyọ. E shi ẹge ono; ẹhu awata oghu Ojejoje eghughu l'ẹke ndu Ízurẹlu nọ. ");
INSERT INTO iqw_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ojejoje asụ Mósisu: “Chịta ndu ishi ndu Ízurẹlu l'ẹphe ha je egbushia l'ifu Ojejoje l'echi oke-eswe; k'ọphu Ojejoje e-wofu ẹhu-eghughu iya, enwu kfukfukfu l'ẹhu ndu Ízurẹlu.” ");
INSERT INTO iqw_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Tọ dụ iya bụ; Mósisu asụ ndu ọgbo ikpe ndu Ízurẹlu: “T'onyenọnu l'unu ha gbushia ndu nk'iya, bụ ndu woru onwẹphe tụgbabe l'agwa Bálụ-Peyọ ono.” ");
INSERT INTO iqw_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Teke ono, ndu Ízurẹlu nọ l'ọnu Ụlo-Ẹ́kwà Ndzuko aragbaa ẹkwa ono; bẹ nwoke Ízurẹlu lanụ dutaru nwanyi Mídiya dubata lẹ nk'iya; l'ẹke Mósisu yẹle ndu Ízurẹlu l'ẹphe ha ele iya ẹnya. ");
INSERT INTO iqw_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasu Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja aphụlephu iphe ono; gbalihu l'ẹke ono, ọha ono kụru ono; je adzụta arwa iya. ");
INSERT INTO iqw_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Yo tsopyabe nwoke Ízurẹlu ono bahụ l'ime ụlo-ẹ́kwà ono; je eworu arwa ono nmaa ẹphe. Yo shi l'ẹhu kẹ nwoke baa lẹ kẹ nwanyi ono. E shiwaphu ẹge ono; mgbọnwu ono ahaa ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ọle ndu mgbọnwu ono gburu dụkwa ụkporo ụnu madzụ ugbo ẹto. ");
INSERT INTO iqw_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasu Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja bẹ mewaru; ẹhu eghubuhu mu eghughu l'ẹke ndu Ízurẹlu nọ; kẹ l'o wotaru okopho, ya ge ekoru ndu Ízurẹlu kooru ẹphe; shi ẹge ono mee; ya te gudehe okopho iya ono mee tẹ ndu Ízurẹlu laa l'iyi. ");
INSERT INTO iqw_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ọo ya bụ t'i kfuru Finehasu lẹ yẹle iya gbawaru ndzụ ẹhu-agu. ");
INSERT INTO iqw_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ọgba-ndzụ ono a-bụru nk'iya waa k'awa iya phẹ, bụ ndu ọphu etso iya nụ. Ọgba-ndzụ ono bụ l'ẹphe a-bụru ndu achịjeru Nchileke ẹja gbururu jeyewaru; kẹ l'o gude okfu-ẹhu Nchileke iya koo okopho; shi ẹge ono kfụa ụgwo iphe, dụ ẹji, ndu Ízurẹlu meru.” ");
INSERT INTO iqw_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ẹpha nwoke Ízurẹlu ono, e gburu yẹle nwanyi Mídiya ono bụ Zimuri Salu. Nna iya; mbụ Salu bụ onye ishi l'ẹnya-ufu, nọ l'ikfu Símiyọnu. ");
INSERT INTO iqw_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ẹpha kẹ nwanyi Mídiya ono, e gburu ono bụ Kozubi nwatibe Zuru. Nna iya; mbụ Zuru bụ onye ishi l'ẹnya-ufu ndu Mídiya. ");
INSERT INTO iqw_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ojejoje abya asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Kpaa ndu Mídiya ẹhu; woru ẹphe gbushia. ");
INSERT INTO iqw_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Ishi iya abụru l'ẹphe gude ẹregede kpaa unubẹdua ẹhu; shi lẹ kẹ nte Bálụ ono, nọ lẹ Peyọ ono duphua unu ụzo. Ọdo abụru lẹ kẹ Kozubi, bụ nwada onye ishi ndu Mídiya; mbụ nwunne ndu Mídiya kẹ nwanyi; mbụ onye ono, e gburu l'oge teke ono, kẹ Peyọ meru mgbọnwu abya ono.” ");
INSERT INTO iqw_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Lẹ mgbọnwu ono latsuaru bẹ Ojejoje kfuru Mósisu yẹle Eliyéza Érọnu, bụ onye achịjeru Nchileke ẹja; sụ: ");
INSERT INTO iqw_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Unu gụa ndu Ízurẹlu kpamukpamu ọgu l'ẹnya-ufu l'ẹnya-ufu; tsube lẹ ndu nọwaru ụkporo afa kwasẹru; mbụ ndu dzuwaru oje ọgu lẹ Ízurẹlu.” ");
INSERT INTO iqw_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Yọ bụru lẹ baswangu alị Móabu, nọ l'iku Ẹnyimu Jọ́danu lẹ mgboro Jériko bẹ Mósisu yẹle Eliyéza, bụ onye achịjeru Nchileke ẹja nọdu kfuaru ndu Ízurẹlu; sụ ẹphe: ");
INSERT INTO iqw_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Unu gụa ndu Ízurẹlu kpamukpamu ọgu; tsube lẹ ndu nọwaru ụkporo afa kwasẹru; mbụ ẹge ono, Ojejoje tụru iya Mósisu l'ekemu ono.” Ọwaa ndu Ízurẹlu, shi lẹ Íjiputu lụfuta: ");
INSERT INTO iqw_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ndu eri kẹ Rúbẹnu, bụ ọkpara Ízurẹlu bụ: Hanọku, metaru ikfu Hanọku; Palu, metaru ikfu Palu; ");
INSERT INTO iqw_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hẹzuronu, metaru ikfu Hézurọnu. Kami emeta ikfu Kami. ");
INSERT INTO iqw_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ndu ono l'ẹphe ha tụko bụru ndu ikfu Rúbẹnu. Ndu ọphu a gụru ọgu tụkoru dụ ụkporo ụnu madzụ ise l'ụnu madzụ tete; l'ụkporo madzụ ishingu lẹ madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Nwatibe Palu kẹ nwoke bụ Eliyabu. ");
INSERT INTO iqw_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Ụnwegirima Eliyabu ndu k'unwoke bụ: Nemẹlu; Detanu; mẹ Ebiramu. Ọ bụ Detanu; mẹ Ebiramu-a b'a fọtajeru t'ẹphe bụru ishi lẹ Ízurẹlu; ẹphe etsoru ndu kẹ Kora; kwefuru Mósisu yẹle Érọnu íkè teke ono, ẹphe kwefujeru Ojejoje íkè; ");
INSERT INTO iqw_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","alị asaa ọnu tụko ẹphe lẹ Kora lekota ono. Ndu shi etso iya nụ bẹ nwụshihuru nụ; teke ono ọku kegbushijeru ụkporo madzụ iri l'ẹbo l'ụmadzu iri ono. Iphe ono abụru iphe alọ ẹka lẹ nchị. ");
INSERT INTO iqw_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Obenu l'ụnwu kẹ Kora ta nwụshihukwa. ");
INSERT INTO iqw_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ndu ikfu Símiyọnu l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Nemẹlu, metaru ndu ufu Nemẹlu; Jaminu, metaru ndu ufu Jaminu; Jakinu, metaru ndu ufu Jakinu; ");
INSERT INTO iqw_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, metaru ndu ufu Zera; mẹ Shawulu, metaru ndu ufu Shawulu. ");
INSERT INTO iqw_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ndu ono tụko bụru ndu ikfu Símiyọnu. Ndu ọphu a gụru ọgu bẹ dụ ụkporo ụnu madzụ ugbo labụ l'ụnu iri madzụ l'ise l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ndu ikfu Gádu l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Zefọnu, metaru ndu ufu Zefọnu; Hagi, metaru ndu ufu Hagi; Shuni, metaru ndu ufu Shuni; ");
INSERT INTO iqw_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozuni, metaru ndu ufu Ozuni; Éri, metaru ndu ufu Éri; ");
INSERT INTO iqw_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi, metaru ndu ufu Arodi; Areli, metaru ndu ufu Areli. ");
INSERT INTO iqw_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ndu ono bẹ tụko bụru ndu ikfu Gádu. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ise l'ụnu madzụ l'ụkporo ise. ");
INSERT INTO iqw_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Júda bẹ mụtaru unwoke labụ, ẹpha ẹphe bụ Ẹru; mẹ Onanu. Ọle ẹphe ẹbo nwụshihuru l'alị Kénanu. ");
INSERT INTO iqw_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ndu kẹ ikfu Júda l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Shela metaru ndu ufu Shela; Pẹ́rezu emeta ndu ufu Pẹ́rezu; mẹ Zera, metaru ndu ufu Zera. ");
INSERT INTO iqw_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ụnwu kẹ Pẹ́rezu bụ: Hézurọnu, metaru ndu ufu Hézurọnu; mẹ Hamulu, metaru ndu ufu Hamulu. ");
INSERT INTO iqw_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ndu ono tụko bụru ndu ikfu Júda. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo tete l'ụnu madzụ iri lẹ nanụ l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ndu ikfu kẹ Ísaka l'ọnu-ufu l'ọnu-ufu bụ: Tola, metaru ndu ufu Tola; Puwa, metaru ndu ufu Puwa; ");
INSERT INTO iqw_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashubu, metaru ndu ufu Jashubu; mẹ Shimurọnu, metaru ndu ufu Shimurọnu. ");
INSERT INTO iqw_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ndu ono bẹ tụko bụru ndu ikfu kẹ Ísaka. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ẹsato l'ụkporo madzụ ugbo iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ndu ikfu kẹ Zébulọnu l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Sẹredu, metaru ndu ufu Sẹredu; Elọnu, metaru ndu ufu Elọnu; mẹ Jahulẹlu, metaru ndu ufu Jahulẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ndu ono tụko bụru ndu ikfu Zébulọnu. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ẹsaa l'ụnu madzụ iri lẹ nanụ l'ụkporo madzụ ise. ");
INSERT INTO iqw_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ndu ikfu kẹ Jósẹfu l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Manásẹ; mẹ Ífuremu. ");
INSERT INTO iqw_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ụnwu kẹ Manásẹ bụ: Makiya, metaru ndu ufu Makiru. Makiru bụ nna Gíledu. Gíledu abụru iya metaru ndu Gíledu. ");
INSERT INTO iqw_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ụnwu Gíledu bụ: Iyeza, metaru ndu ufu Iyeza; Helẹku, metaru ndu ufu Helẹku; ");
INSERT INTO iqw_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asurẹlu, metaru ndu ufu Asurẹlu; Shékemu, metaru ndu ufu Shékemu; ");
INSERT INTO iqw_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida, metaru ndu ufu Shemida; mẹ Hefa, metaru ndu ufu Hefa. ");
INSERT INTO iqw_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehadu Hefa ta mụtadu nwata nwoke. Ọ bụ ụnwanyi b'ọ mụshiru. Ẹpha ụnwanyi ono, ọ mụshiru ono bụ Mahula; Nówa; Họgula; Milika; mẹ Tíza. ");
INSERT INTO iqw_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ndu ono tụko bụru ndu eri Manásẹ. Ndu ọphu a gụru ọgu tụko dụ ụkporo ụnu madzụ ishingu l'ụnu madzụ iri lẹ nanụ l'ụkporo madzụ iri l'ise. ");
INSERT INTO iqw_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ụnwu kẹ Ífuremu l'ọnu-ufu l'ọnu-ufu bụ: Shutela, metaru ndu ufu Shutela; Beka, metaru ndu ufu Beka; waa Tahanu, metaru ndu ufu Tahanu. ");
INSERT INTO iqw_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ụnwu Shutela bụ Eranu, metaru ndu ufu Eranu. ");
INSERT INTO iqw_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ndu ono bẹ tụko bụru ndu ikfu Ífuremu. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ẹno l'ụnu madzụ l'ụkporo madzụ ise. Ndu ono tụko bụru ndu eri Jósẹfu l'ọnu-ufu l'ọnu-ufu. ");
INSERT INTO iqw_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ndu ikfu kẹ Bénjaminu bụ: Béla, metaru ndu ufu Béla; Ashibẹlu, metaru ndu ufu Ashibẹlu; Ahiramu, metaru ndu ufu Ahiramu; ");
INSERT INTO iqw_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shefufamu, metaru ndu ufu Shefufamu; waa Hufamu, metaru ndu ufu Hufamu. ");
INSERT INTO iqw_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ụnwu Béla bụ: Arudu; mẹ Námanu. Arudu, bụ iya metaru ndu ufu Arudu; Namanu abụru iya metaru ndu ufu Namanu. ");
INSERT INTO iqw_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ndu ono tụko bụru ndu ikfu Bénjaminu l'ọnu-ufu l'ọnu-ufu ẹphe. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ise l'ụnu madzụ iri l'ẹno. ");
INSERT INTO iqw_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ndu ikfu kẹ Dánu l'ọnu-ufu l'ọnu-ufu ẹphe bụ: Shuhamu, metaru ndu ufu Shuhamu. Ndu ono tụko bụru ndu ikfu Dánu l'ọnu-ufu l'ọnu-ufu ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ẹphe tụko bụru ndu ufu Shuhamu. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ẹsato l'ụnu madzụ. ");
INSERT INTO iqw_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ndu ikfu kẹ Ásha bụ: Imuna metaru ndu ufu Ịmuna; Ishivi metaru ndu ufu Ishivi; waa Beríya, metaru ndu ufu Beríya. ");
INSERT INTO iqw_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ụnwu Beríya bụ: Heba, metaru ndu ufu Heba; waa Malikẹlu, metaru ndu ufu Malikẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ọ bụ nwata nwanyi lanụ bẹ Ásha mụtaru. Ẹpha nwata ono bụ Séra. ");
INSERT INTO iqw_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ndu ono tụko bụru ndu ikfu Ásha. Ndu ọphu a gụru ọgu dụ ụkporo ụnu ugbo ishingu l'ụnu madzụ iri l'ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ndu bụ ndu eri Náfutali l'ọnu-ufu l'ọnu ẹphe bụ: Jahuzẹlu, metaru ndu ufu Jahuzẹlu; Guni, metaru ndu ufu Guni; ");
INSERT INTO iqw_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jeza, metaru ndu ufu Jeza; waa Shilemu, metaru ndu ufu Shilemu. ");
INSERT INTO iqw_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ndu ono tụko bụru ndu ikfu Náfutali l'ọnu-ufu l'ọnu-ufu ẹphe. Ndu ọphu a gụru ọgu dụ ụkporo ụnu madzụ ugbo ise l'ụnu madzụ iri l'ẹto l'ụkporo madzụ iri. ");
INSERT INTO iqw_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Iphe, ndu Ízurẹlu kpakọru dụ abụru ụkporo ụnu madzụ ugbo ụkporo ẹto l'ụkporo ụnu madzụ iri l'ise l'ụnu madzụ ẹno l'ụkporo madzụ ishingu l'ụmadzu iri. ");
INSERT INTO iqw_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ọo ndu-a bẹ aa-washịru alị ono t'ọ bụru òkè-iphe, ẹphe ketaru. Ndu nọnu e-keta l'ẹge ẹphe ha l'ọnu-ọgu. ");
INSERT INTO iqw_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ndu ha nshinu bẹ ịi-wẹ alị, ha nshinu. Ndu ọphu ha nwanshị; bẹ ịi-wẹ alị, ha nwanshịi. Ndu ọphu nọnu e-keta l'ẹge ẹphe ha l'ọnu-ọgu. ");
INSERT INTO iqw_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Alị ono bụ ẹnwa bẹ aa-tụ gude washịa ya. Aa-wa iya l'ikfu l'ikfu; ndu ọphu nọnu; ẹphe eketa òkè iya nk'ẹphe l'ikfu nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ọ bụ ẹnwa bẹ aa-tụ gude washịaru ndu ọphu ha nshinu; mẹ ndu ọphu ha nwanshịi alị ono.” ");
INSERT INTO iqw_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ọwaa ẹge e gude gụa ndu ikfu kẹ Lívayi l'ọnu-ufu l'ọnu-ufu: Geshọnu metaru ndu ufu Geshọnu; Kohatu, metaru ndu ufu Kohatu; Merari emeta ndu ufu Merari. ");
INSERT INTO iqw_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ndu ọwaa bẹ bụkwaphu ndu ikfu Lívayi: Ndu ufu Libíni; ndu ufu Hẹ́buronu; ndu ufu Mahuli; ndu ufu Mushi; mẹ ndu ufu Kora. Kora bụ iya metaru Amuramu. ");
INSERT INTO iqw_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Ẹpha nyee Amaramu bụ Jekobẹdu, bụ nwatibe Lívayi. Jokebẹdu bụ nwata nwanyi, a mụtaru Lívayi lẹ Íjiputu. Ndu ọ mụtaru Amuramu bụ Érọnu; mẹ Mósisu; waa Miriyamu, bụ nwunne ẹphe kẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Érọnu bụ nna Nadabu; Abihu; Eliyéza; waa Itama. ");
INSERT INTO iqw_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabu yẹle Abihu bẹ nwụhuru nụ teke ẹphe gude ọku, ẹ-ta dụdu nsọ kpọoru Ojejoje ngwẹja ọku. ");
INSERT INTO iqw_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ndu a gụru ọgu l'eri Lívayi; mbụ unwoke ẹphe, nọwaru shita l'ọnwa lanụ kwasẹru bẹ kpakọru dụ ụkporo ụnu madzụ ugbo labụ l'ụnu madzụ iri l'ẹsaa l'ụkporo madzụ iri. Ẹ ta gụdu ẹphebedua teke a gụru ndu Ízurẹlu ndu ọphunanu; kẹ l'e te kevuduru ẹphe òkè lẹ Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ndu ono bụ ndu Mósisu yẹle Eliyéza, bụ onye achịjeru Nchileke ẹja gụru ọgu; mbụ ndu ono, gụru ndu Ízurẹlu ọgu lẹ baswangu alị Móabu l'iku Ẹnyimu Jọ́danu lẹ mgboro Jériko. ");
INSERT INTO iqw_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ndu ono ta dụdu l'ẹphe ha, tso lẹ ndu ọphu Mósisu yẹle Érọnu, bụ onye achịjeru Nchileke ẹja gụru ọgu teke ono, ẹphe gụru ndu Ízurẹlu l'echi-ẹgu ono. ");
INSERT INTO iqw_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ishi iya abụru lẹ Ojejoje sụru ndu Ízurẹlu ono l'ẹphe nwụhufutaje l'echi-ẹgu ono. Ẹ tọ dụdu m'ọo onye lanụ, phọduru nụ l'ime ndu ono; a gụfu Kálẹbu Jefune yẹle Jóshuwa Nunu. ");
INSERT INTO iqw_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ụnwada Zelofehadu ejerua l'ọnu ụlo-ẹ́kwà ndzuko. Zelofehadu l'onwiya bụ nwatibe Hefa; Hefa abụru nwatibe Gíledu; Gíledu abụru nwatibe Makiru; Makiru abụru nwatibe Manásẹ. Ndu ono bụ ndu eri Manásẹ. Manásẹ abụru nwatibe Jósẹfu. Ẹpha ụnwada Zelofehadu ono bụ: Mahula; Nówa; Họgula; Milika; waa Tíza. ");
INSERT INTO iqw_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ụnwada Zelofehadu ono abya evudo Mósisu l'ifu; mẹ lẹ Eliyéza, bụ onye achịjeru Nchileke ẹja; mẹ l'ifu ndu ishi; mẹ l'ifu ndu Ízurẹlu kpamukpamu l'ọnu Ụlo-Ẹ́kwà Ndzuko; kfulahaa; sụ: ");
INSERT INTO iqw_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nna ẹphe bẹ nwụhuru l'echi-ẹgu. Ọle; ẹ to tsokwa ndu ono, chịkoberu onwẹphe tso Ojejoje okfu ono; mbụ ndu otu Kora. Ọ kwa k'iphe, dụ ẹji, o metaru l'onwiya b'o gude nwụhu; tọ mụta unwoke. ");
INSERT INTO iqw_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","?Bụ kẹle nna ẹphe ta mụtadu nwata nwoke meru iphe ẹpha iya e-chihu tọo? T'a hẹkwa-a ẹphe òkè l'ẹke ndu nna ẹphe nọ.” ");
INSERT INTO iqw_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Tọ dụ iya bụ; Mósisu ewota okfu ụnwada Zelofehadu ono pakfu Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Lẹ ụnwada Zelofehadu kfuru iphe, gbaru nụ. Unu shi l'òkè-iphe ndibe nna ẹphe woru iphe nụ ẹphe t'ẹphe nweru. Unu nụ ẹphe òkè-iphe, ruberu nna ẹphe t'ọ bụru nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Kfuaru ndu Ízurẹlu sụ ẹphe-a: ‘Ọ -bụru lẹ nwoke nwụhuru; tọ mụta nwata nwoke; t'e wotaje òkè, ruberu iya nụ nụ nwatibe iya kẹ nwanyi. ");
INSERT INTO iqw_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ọ -bụru l'onye ọbu ta mụtadu nwa-nwanyi; t'e wotaje òkè, ruberu iya nụ nụ unwunne iya kẹ nwoke t'ọ bụru iphe ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Teke ọbu l'ẹ to nwedu unwunne nwoke; t'e woru òkè ono, ruberu iya nụ ono nụ nwunne nna iya ẹphe kẹ unwoke t'ọ bụru nk'ẹphe. ");
INSERT INTO iqw_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ọ -bụru lẹ nna, mụru onye ono te nwedu unwunne nwoke; t'e woru òkè, ruberu iya nụ nụ ndu ẹphe l'iya bụ ọkpobe abụbu t'ọ bụru iphe ẹphe. Iphe ono bụ ome-l'alị, a tọru ọkpa iya doberu ndu Ízurẹlu; ẹge Ojejoje tụru iya Mósisu l'ekemu.’ ” ");
INSERT INTO iqw_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “T'o nyihu eli ugvu Abarimu-a je anọdu phụkota alị ono, ya nụru ndu Ízurẹlu ono. ");
INSERT INTO iqw_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ị -phụtsule iya phụ; bẹ ịi-nwụhu lakfushia ndibe unu; ẹge ono nwunne ngu; mbụ Érọnu jeru iya ono. ");
INSERT INTO iqw_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Iphe, kparu iya nụ abụru l'unu kwefuru íkè l'okfu iya teke ono, ndu Ízurẹlu gụjeru aphụ lẹ mgboro mini ono, nọ l'echi-ẹgu Zinu ono. Unu ta dụ ike dobe iya nsọ l'ẹnya ẹphe.” (Mini ono bụ mini Meriba, nọ lẹ Kadẹ́shi l'echi-ẹgu Zinu.) ");
INSERT INTO iqw_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mósisu asụ Ojejoje: ");
INSERT INTO iqw_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Tẹ Ojejoje; mbụ Nchileke ọphu gude ndzụ onyemonye fọta nụ onye a-nọdu edu ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Onye e-vutajeru ẹphe ụzo l'ejeje; mẹ l'alala; mbụ onye a-nọdu edu ẹphe l'eje ejeje; l'ala alala; tẹ ndibe nggụbe Ojejoje ta adụshi l'ọ bụ atụru, ẹ-te nwedu onye eche iya nụ.” ");
INSERT INTO iqw_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Tọ dụ iya bụ; Ojejoje asụ Mósisu: “Duta Jóshuwa Nunu, bụ onye Ume kẹ yẹbe Ojejoje nọ l'ẹhu; byibe iya ẹka l'ishi. ");
INSERT INTO iqw_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Duru iya t'o je evudo Eliyéza, bụ onye achịjeru Nchileke ẹja l'ifu; mẹ l'ifu ndu Ízurẹlu kpamukpamu; nggu anọdu ndu ono l'ifu woru ozi ono ye iya l'ẹka. ");
INSERT INTO iqw_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Haru ike nke ngu ye iya l'ẹka; k'ọphu iphe, bụ ndu Ízurẹlu l'ẹphe ha a-nọdu anụru iya okfu. ");
INSERT INTO iqw_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Tẹ Jóshuwa vudo Eliyéza, bụ onye achịjeru Nchileke ẹja l'ifu. Eliyéza egude ido urimu jee ajịta ajị l'ifu Ojejoje t'ọ maru iphe, o kpeburu l'okfu ẹhu iya. Yọ bụru iphe, Jóshuwa sụru tẹ ndu Ízurẹlu mee bẹ ẹphe e-meje. Ọ -sụ tẹ ndu Ízurẹlu tụgbua; ẹphe atụgbua; ọ -sụ t'ẹphe bata yẹle ẹphe atụko bata.” ");
INSERT INTO iqw_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mósisu emee ẹge Ojejoje kfuru iya. Yo duta Jóshuwa kfụbe Eliyéza, bụ onye achịjeru Nchileke ẹja l'ifu; mẹ l'ifu edzudzu ọha ndu Ízurẹlu. ");
INSERT INTO iqw_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ya ndono; yo byibe Jóshuwa ẹka l'ishi woru ozi ono ye iya l'ẹka ẹge Ojejoje kfuru shita l'ẹka Mósisu. ");
INSERT INTO iqw_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ojejoje asụ Mósisu: ");
INSERT INTO iqw_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Tụru ekemu nụ ndu Ízurẹlu; sụ ẹphe: ‘Unu leta ẹnya nụje iya ngwẹja, ruberu iya nụ; mbụ nri, e gude egworu iya ngwẹja-ọku, mkpọ iya dụ iya mma. Unu nụje iya ẹya l'ògè iya.’ ");
INSERT INTO iqw_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Kfuaru ẹphe ẹge-a: ‘Ọwaa ngwẹja-ọku, unu e-gwoje nụ Ojejoje: ụnwu ebyila labụ, gbatsuaru afa, ẹ te nwedu ntụpo l'ẹhu. Unu gwoje iya mbọku-mbọku t'ọ bụru ngwẹja-ukfuru, unu a-nọduje egwo tekenteke. ");
INSERT INTO iqw_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Unu gbujee ebyila lanụ l'ụtsu; unu egbua ebyila lanụ l'urẹnyashi. ");
INSERT INTO iqw_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Unu yeje iya ngwẹja nri gwoo; mbụ ụzo lanụ l'ụzo iri nkwo-ẹka ntụ akpe; bya agwọkobe iya nkere-ẹno ekpemu manụ, a pyịshiru l'olivu. ");
INSERT INTO iqw_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ọo ya bụ ngwẹja-ukfuru, unu a-nọduje egwo tekenteke, bụ iya bụ ẹge a tụru iya dobe lẹ Ugvu Sáyịnayi; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Unu -gbua ebyila lanụ; unu eyekobe iya ngwẹja-mẹe gwoo; mbụ nkere-ẹno ekpemu mẹe. Ọo l'ẹke-dụ-nsọ bẹ unu a-gbashịjeru Ojejoje ngwẹja-mẹe ono; mbụ mẹe, shihuru ike. ");
INSERT INTO iqw_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Unu egbua ebyila lanụ l'urẹnyashi; yekobekwa iya phụ ngwẹja nri; mẹ ngwẹja-mẹe ẹge ono, ọ dụ lẹ k'ụtsu ono. Unu gwoo ya t'ọ bụru ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘A -bya lẹ mbọku ọtu-ume; unu gbuje ebyila labụ, gbatsuaru afa, ntụpo ẹ-ta nọdu l'ẹhu gude gwoo ngwẹja; unu egude ụzo labụ lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri gwọkobe iya manụ gude gwoo ngwẹja nri. Unu eyekobe iya ngwẹja-mẹe, etsoje iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ono bụ ngwẹja-ukfuru, unu e-gwoje mbọku ọtu-ume; yekwaru ngwẹja-ukfuru, eegwoje tekenteke yẹle ngwẹja-mẹe, etsoje iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘O rujee mbọku mbụ l'ọnwa; unu egwooru Ojejoje ngwẹja-ukfuru. Unu gudeje ụnwu oke-eswi labụ; mẹ ebyila lanụ; mẹ ụnwu ebyila ẹsaa, gbatsuaru afa, ntụpo ẹ-ta nọdu l'ẹhu gude gwoo ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Unu -gbua oke-eswi ono nanụ bẹ unu e-yekobeje iya ngwẹja nri gwoo; mbụ ụzo ẹto l'ime nkwo-ẹka ntụ akpe, e keru ụzo iri; bya agwọkobe iya manụ. Unu -gbua ebyila ono; unu eyekobe iya ngwẹja nri gwoo; mbụ ụzo labụ lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri, a gwọkoberu manụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Unu -gbua nwebyila lanụ; unu eyekobe iya ngwẹja nri gwoo; mbụ ụzo lanụ l'ụzo iri nkwo-ẹka akpe, e gweru egwegwe; gwọkobe iya manụ. Ono bụ ngwẹja-ukfuru; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. ");
INSERT INTO iqw_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ngwẹja-mẹe, e-tsojeru iya nụ bụ: unu -gbua oke-eswi; unu eyekobe iya nkere-ẹbo ekpemu mẹe. Ọ -bụru ebyila; unu eyekobe iya nkere-ẹto ekpemu mẹe gwoo. Unu -gbua nwebyila; unu e-yekobe iya nkere-ẹno ekpemu mẹe gwoo. Ono abụru ngwẹja-ukfuru, unu e-gwoje l'ọnwa l'ọnwa; afa gbaa mgburumgburu. ");
INSERT INTO iqw_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Unu gbuje mkpi lanụ gude gwoo ngwẹja iphe, dụ ẹji nụ Ojejoje; a gụfukwa ngwẹja-ukfuru, eegwoje tekenteke yẹle ngwẹja-mẹe, etsoje iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Mbọku kẹ iri l'ẹno l'ọnwa mbụ bụ Ajị Esweta kẹ Ojejoje. ");
INSERT INTO iqw_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Mbọku kẹ iri l'ise l'ọnwa mbụ ono bẹ bụ ajị. Ujiku ẹsaa bẹ unu a-takọtaje buredi, ẹ-te ekodu ekoko. ");
INSERT INTO iqw_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Mbọku mbụ, unu wataru ajị ono bẹ unu e-nwejeru ndzuko, dụ nsọ. Tẹ b'ọ dụkwa ozi, unu e-jeje mbọku ono lẹ phuu. ");
INSERT INTO iqw_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Unu gwoje ngwẹja-ọku; mbụ ngwẹja-ukfuru nụ Ojejoje. Unu gudeje ụnwu oke-eswi labụ; ebyila lanụ; mẹ ụnwu ebyila ẹsaa, gbatsuaru afa, ntụpo ẹ-ta nọdu l'ẹhu gude gwoo ya. ");
INSERT INTO iqw_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ngwẹja nri, e-yekobeje l'oke-eswi lanụ gwoo bụ ụzo ẹto lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri; bya agwọkobe iya manụ. Teke ọ bụ ebyila lanụ; unu eyekobe iya ụzo labụ lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri; bya agwọkobe iya manụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Yọ bụru ụzo lanụ l'ụzo iri bẹ unu e-gwoje l'ishi ụnwu-ebyila ono nanụ nanụ ẹphe ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Unu e-gbukwaaphu mkpi lanụ gude gwoo ngwẹja iphe, dụ ẹji; shi ẹge ono kfụa ụgwo iphe, dụ ẹji unu. ");
INSERT INTO iqw_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","“ ‘Unu a-tụkoje ngwẹja ono gwokota; yekobe lẹ ngwẹja-ukfuru ono, eegwoje l'ụtsu, bụ iya bụ ngwẹja ono, eegwoje tekenteke ono. ");
INSERT INTO iqw_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ọ bụ ẹge ono bẹ unu a-nọduje egwo ngwẹja ono mbọku-mbọku abalị ẹsaa ono; t'ọ bụru ngwẹja nri; mbụ ngwẹja-ọku, mkpọ iya dụ Ojejoje mma. Unu gwoje ngwẹja ono yekobe lẹ ngwẹja-ukfuru ono, unu egwoje tekenteke ono; mẹ ngwẹja-mẹe, etsoje iya nụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","O -rua mbọku kẹ ẹsaa; unu nweru ndzuko, dụ nsọ; t'ẹ b'ọ dụkwa ozi, eeje ejeje, unu e-je mbọku ono. ");
INSERT INTO iqw_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Mbọku, unu eme k'akpụru iphe mbụ unu; unu nwejeru ndzuko, dụ nsọ; tẹ b'ọ dụkwa ozi, eeje ejeje, unu e-jeje mbọku ono. Mbọku ono; bẹ unu a-nụje Ojejoje akpụru iphe ọphungu unu lẹ teke unu agba Ajị Ídzù. ");
INSERT INTO iqw_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Unu gwoo ngwẹja-ukfuru; mbụ ngwẹja, mkpọ iya dụ Ojejoje mma. Unu gbuje ụnwu oke-eswi ẹbo; waa ebyila lanụ; mẹ ụnwu-ebyila ẹsaa, gbatsuaru afa gude gwoo ngwẹja ono. ");
INSERT INTO iqw_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ngwẹja nri, e-yekobeje l'oke-eswi lanụ bụ ụzo ẹto lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri, a gwọkoberu manụ. Teke ọ bụ ebyila; unu yekobe iya ụzo ẹbo lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri, a gwọkoberu manụ. ");
INSERT INTO iqw_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Yọ bụru ụzo lanụ lẹ nkwo-ẹka ntụ akpe, e keru ụzo iri; bya agwọkobe iya manụ bẹ unu e-yekobeje l'ụnwu-ebyila ono nanụ nanụ gwoo ẹphe ẹsaa. ");
INSERT INTO iqw_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Unu gbujee mkpi lanụ gude kfụa ụgwo iphe, dụ ẹji, unu meru. ");
INSERT INTO iqw_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Unu tụkoje ngwẹja ono l'ọ ha gwokotaje; yekoberu ngwẹja-ukfuru ono, unu egwoje tekenteke; mẹ ngwẹja nri ono, etsoje iya nụ ono; mẹ ngwẹja-mẹe ono, etsoje iya nụ ono. Ọle; t'unu kwabẹkwa ẹnya phụ l'ẹ t'ọ dụdu anụ ono, nweru 