﻿USE sofia;
DROP TABLE IF EXISTS sofia.ipi_vpl;
CREATE TABLE ipi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ipi_vpl WRITE;
INSERT INTO ipi_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","(Sapeta 1 - 4) Josepe bala Isipi kanditi okonena wamba poto atenenga, matili Jekopo bala iwanane tupa towa Isipi peaini-pia. Utupane yakamana wanda andopane tupa pitaka atu peaini-pia. Iwanane peaini utupanena gene utupa, Lupene, Simiyone, Lipai, Juta, Isaka, Sepulane, Benjamene, Dana, Napatali, Gata, Asete, utupane peaini-pia. Okone angi Jekopo bala yame Isatale akali angu, payisa yanasia (70) peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Matili Josepe balapi, balana amene tupapi, wandakali okone angi ateaini utupane pitaka omokoyo peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Omokoyo penenga, matili Isatale yame utupanena mandiyene yame ateaini tupamane andopane kambua wete mandeaini-pia. Isatale utupane, yame tai kambua wete kanditi Isipi okonena ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Matili ee ana kambua penenga, kiŋi wenene mindimane kanditi Isipi okone ando ateae-pia. Kiŋi okone mane wamba Isipi yuu okonena Josepe-to piape mina ika layawa pua ateane tupa balato anda napeae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kiŋi okone mane balana wandakali tupa lamawuato, matili Isatale yame wandakali yakama kambua tai wete atoto nanima yanda pinguto sia minulu peyai. ");
INSERT INTO ipi_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Yanda pene mindi tupamane nanima yanda pingeindo, Isatale yame utupa mane yame utupane tako puato, nanima peyo sia minoto, yuu oko tepa alu yakama palaka polopeyai. Isatale yame utupa yakama kambua gulo ata napeakale, nanimato asini mindi ayia puato jia lamakale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Isipi tane akali kawane tupa mane, Isatale yame tupamane piape pulai tupa bosa-lo ando ateakale loto akali mindi tupa ate leaini-pia. Akali utupane mane Isatale yame tupa piape andane tandaka pene peakale leaini-pia. Wuane peai-kola Isatale yame utupane mane kiŋi okonena tomo mindi taka tupa mandu amunguli pua yata yakale loto, tano andane Pitomo Lamesese-la pimayaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isipi yame mane Isatale yame tupa mino koyaini tekeko, yakama yame andane kambua tumbi-lo wete ateaini-pia. Kambua wete gulea-kola, Isipi tane tupamane Isatale yame tupa ando yuku wete yaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Yuku wato, Isipi tane tupamane Isatale yame tupa ondo naene piape tai-lo peakale leai-kola, Isatale yame tupamane bitiki waa piki, ee anda tupa pimaiki peakale leai-kola, utupane kuilo ata-napene tandaka koo noo ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kiŋi okone mane Isatale wanda yamena andopane mandeakale-lo moyo pitiyapele, Iputu wanda Siputa, Pua-la epeakale loto wua lamayae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Liyambato Iputu wanda mindi mane andopane mandeakale loto moyolapi-kola wanda mindimane iwana mindi mandeando liyambato andopane iwana okone peyo ome lalapape. Wana mandeando, peteakale kondalapape leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Wuane leane tekeko, wanda okone lapo mane Gote yuku wato, kiŋi-to iwana tupa peyo ome lalapape leane pua napene konda yapele-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kondeaepi-kola, kiŋi okomane wanda okone lapo epeakale loto, anupiakale liyambato andopane iwana tupa ateakale ando kondala pipe-lo pii tai mane loto tipa peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tipa pea-kola, wanda okone lapomane kiŋi okone lamawuato, Iputu wanda tupa Isipi wanda yale jia, Iputu wanda utupane tai yuku pene. Wanda utupane mane andopane baini mandiki piyaini. Andopane yakama tane ini mandiki penenga nalipa matili puku piyapale leapele-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Wanda okone lapomane Gote yuku wato wuane piki peapi-kola, Gote-to wanda okone lapo moo kui laya wato, liyambato-pi andopane mandeakale lea-kola, Isatale wandakali tupa yame kambua puato tai yuku pene mindi tupa ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Matili kiŋi okone mane Isipi tane wandakali tupa lamawuato, Iputu yamena andopane iwana mandulaini tupa pitaka moto ipa Naile-na awua aindaka lalapape. Andopane wana tupa peteakale ando kondala-pape leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Okone angi, Lipai yame akali mindimane, wanda Lipai yame teke mindi kee leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Matili wanda okone mane iwana epene payia mindi mandeae-pia. Angini mane iwana payia okone oma napeakale nembo toto, ana tepo too pua yatawa peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Balato andopane okone katu-lo too pua yatawa napitipe-pene guleae-pia. Wuane pea-kola, kembolo itane mane waa pene basekete mindina, kolota mane asia titi tupa mina-ombo wato iwana okone basekete okonena palekale loto ipa matene mandaka enjo tombene mindisa too pua yata yaeae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Iwana okonena imalini wana okomane iwana okone anu pua paleyape-lo andoyale bala aŋa amonga yale andatawa ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kiŋi wanane bala wasa-wasa peyoyale balana piape wanda tupa towa ipa okonena peaini-pia. Balana piape wanda utupane ipa matene ongane epoko pua ateai-kola balato ipa okonena basekete mindi enjo tombenenga yakola andeae-pia. Andoto balana piape wanda mindi mane molo peakale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kiŋi wanane okone mane basekete okone lumboto andea-kola iwana mindi basekete okonena paleae-pia. Paleane okone ika loto ai lea-kola andoto ondo yae-pia. Ondo wato, iwana oko Iputu yame tupana andopane mindi yako leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Wuane lea-kola, andopane okonena imalini amonga ateane okone epoto kiŋi wanane oko lamawuato, iwana oko andu mayakale nambato Iputu wanda mindi ayia pua andolo poape-lo tipa peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kiŋi wanane okone mane, katu-lo leleko nimbato andolo puu lea-kola, wana okone mane angini atu epeae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Angini atu epea-kola, kiŋi wanane okone mane angini okone lamawuato, nambato nimba yole pukaleko. Andopane oko nimbato kui-lo andu maula mia leae-pia. Wuane lea-kola, angini okone mane andopane okone moto andu mawua yatawa peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Iwana okone andane guu lele pea-kola, angini mane kiŋi wanane oko peteanga atu peae-pia. Pea-kola kiŋi wanane okone mane iwana okone balana andopane gulaya wato wua leae-pia. Andopane ipa pangosia pene oko nambato moo ayu lewa okonena balana gene oko Mosesa lokale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mosesa bala andane atoto matili bala yame Iputu tupa andolo peae-pia. Bala yame Iputu utupane mane kiŋi okonena piape tandaka wete pene pua ateai-kola andeae-pia. Isipi mindi mane, Mosesa bala yangone Iputu mindi wayumane wete mino-koyo pelea-kola andeae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosesa-to wandakali mindi ateyaipe-lo anda amo-nena puato andea-kola, wandakali mindi ongane ata napeaini-pia. Ata napeai-kola, kapoyale balato Isipi tane akali okone peyo ome loto, ipamau mane yame peyo ombo yae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Anate-lene Mosesa bala peke loto andea-kola, Iputu yame akali mindi lapo liyamba tane lapo-lapo peya-peya peapele-pia. Akali bulupane tee-yane okone lamawuato, anu piakale nimbato nimbana Iputu yangone oko pelelepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Lea-kola akali okone mane Mosesana pii okone yano peyoto, apito nimba jasa atoto nanima ando, atape lapiape. Nimbato Isipi tane akali mindi tuni peyo ome lapiko, andipa nimbato namba wuane pua teke, peyo ome lokale nembo toto lelepe leae-pia. Wuane lea-kola, nambato akali peyawuako wandakali mane andapiainiya nembo toto bala yuku yae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Matili, Isipi tane kiŋi okone mane Mosesa-to peane tupa ale wato Mosesa peyo ome loyale pea-kola Mosesa bala kiŋi tepa alu palaka Midiana yamena yuu okona peae-pia. Bala palaka poto ipa yuli tombayene mindina mandaka peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Kanditi okonena Pitisa, akali Jesoto lene mindi ateae-pia. Pitisa okonena wanane yanasia peteaini-pia. Mosesa bala ipa yuli ongane poto petea-kola wana yanasia utupane yakama ayianena sipisipi meme, tupa ipa neakale ipa ambu gae-lo maiyiani bokisa okonena maimakale loto peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Petea-kola sipisipi waka yatawa atalaini akali mindi tupa epoto wana utupane pulupa-lo peyo wateai-kola, Mosesa balato akali utupane peakale-lo peyo watoto, matili wana utupanena meme, sipisipi tupa ipa neakale-lo ambu mayae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Matili wana utupane yakama ayiane Jesoto ateanga andaka ini peke leai-kola, yakamana ayiane okomane wana utupane tipa puato, andipa anu pua yakama ini andaka peke leyaipe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Utupane mane yano peyoto, Isipi tane akali mindi mane nanima moyoto sipisipi waka ando atalaini akali tupa watoto, nanimana sipisipi meme tupa ipa neakale ambu mayia-kola nanima baini andaka epeyama leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wuane leai-kola, ayiane okone mane wana utupane tipa puato, akali okone aninga ateyape, anu piakale yakamato bala amonga ateakale epalaipe. Bala nanima towa tomo namakale epeakale ee-lolo pulupa, lea-kola utupane mane Mosesa atu epeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Jesoto bala towa Mosesa atu atapakale nembo teyo lea-kola, Mosesa-to okone katu yalua leae-pia. Katu lea-kola, Jesoto-to bala wanane Sipota Mosesa maya-kola Mosesa-to wana okone kee leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Matili Sipota-to iwana mindi mandeae-pia. Mosesa bala tane nembo toto wua leae-pia. Namba akali kanditi waka tane oko yuu okona epo ateyo, tene okonena nambato balana gene oko Getesomo leyo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ee ana mindi tupa wamba penenga matili Isipi tane kiŋi okone omeae-pia. Okone angi Isipi yame tupa mane Isatale yame tupa piape tandaka pene peakale leai-kola tandaka noo atoto, Gote nimbato nanima moya-lo ai-lo ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Gote-to aii leaini okone ale wato wamba Apatakame, Aisake, Jekopo, utupane towa pii-loyake peaini okone nembo teae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Gote-to, Isatale yame tandaka noo ateai tupa andoto moyokale nembo teae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Okone angi Mosesa-to bala imane Midiana tane pitisa akali Jesotona, meme sipisipi tupa yatawa ateae-pia. Ole mindi Mosesa-to sipisipi meme tupa atu yuu kapu mindi kalo piyu poto, Gote atalane yuu wangiane, Otepe okona peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Mosesa ongane atea-kola, Akali Andane okona enjole mindi ita lungu-gulo ita mindina yokone kembone, tupana ita-lungu too ika lea-kola andeae-pia. Mosesa-to ita lungu teya-lo andeane tekeko, ita lungu okone mane ita okonena kembone, yokonepi, tanapeae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ita lungu okone mane ita okone taa-napea-kola, Mosesato nembo kambua toto, wakataka mindi peyako, nambato mandaka poto andolo poa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Akali Andane bala ita lungu okonena tombenesa ateae-pia. Atoto andea-kola Mosesa-to ita lungu okone andolo mandaka epeae-pia. Epea-kola, Gote-to Mosesa, Mosesa, leakola, Mosesa-to yaa, namba ateyoko, anu peyape, leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Wuane leakola, Gote-to namba ateyo mandaka onga nimba naepene konda. Nimbana sendolo peleko yoko-yata. Andipa yuu nimba atele oko nambana yuu epene wete, jia latane okona ateleko leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Namba nimbana yumbane Apatakame, Aisake, Jekopo, utupanena Gote oko ateyo leae-pia. Wuane lea-kola Mosesa-to Gote andolo wane-lo yuku wato, balana lee-inga yame peleae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Akali Andane okomane bala lamawuato, nambana wandakali tupa Isipi yame tupamane tandaka mawua mino koyo atapiai-kola, nambato andawua. Akali kawane utupanena kininga nanima tandaka koo wete noo ataimako, nimbato nanima molo peke laa-lo namba ee-lapiai-kola nambato wamba ale awua. ");
INSERT INTO ipi_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Isatale yame yakama Isipi yamena kininga andi latane atapiai oko, andipa nambato yakama atu kamaka epeyo. Atu epoto yuu andane ipane petene tomo tende pene pitaka yalane, yuu okone yakama gukale. Yuu okonena anduane akali yame Kenane, Iti, Amoto, Petesa, Ipi, Jembusa utupane yakamana yuu tene utupanena ateyai. ");
INSERT INTO ipi_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isipi yame tupamane Isatale yame utupanga mana koo mino atapiai tupa nambato wamba andawua. Andoto utupane mane aii-lo atapiaiko nambato ale wua. ");
INSERT INTO ipi_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Andipa, Mosesa, nimba puu. Isipi tane kiŋi okomane namba yame Isatale tupa nimbanga tepa yakale, nimbato utupane atu epola lamolo puu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Wuane lea-kola, Mosesa-to Gote lamawuato, namba apipe, namba yalemane anupua katu-lo Isipi tane kiŋi oko ateyanga poto, Isatale yame tupa Isipi tepa yakale atu epokalepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Wuane lea-kola, Gote-to bala lamawuato, namba nimba towa atokaleko. Yakamato Isipi tepa alu yuu wangiane okona epoto namba-lo lotu lolai okone angi, nimba Isipi tane kiŋi oko ateyanga nambato puu lapiya-lo nimbato andolo-pele. ");
INSERT INTO ipi_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Wuane lea-kola, Mosesa-to Gote lamawuato, nambato Isatale yame tupa ateyainga Isipi yuu okona poto, nanima yumbanena Gote okomane yakama lamolo pulupa lalakola nambato yakama Iamolo epeyo lokale. Wuane lolowa-kola, utupane mane balana gene apipe-lo namba tipa peindo, nambato aki loto yano peyokalepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Wuane lea-kola, Gote-to wua leae-pia. Namba Ateyo oko Namba. Nimba-to Isatale yame tupa lamawuato nambana gene oko, Namba Ateyo Oko lape. Gote okone mane namba yakama ateayai-nga puu lala. ");
INSERT INTO ipi_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nimba poto Isatale yame tupa lamawuato, yakama ayianena yumbane Apatakame, Aisake, Jekopo, utupanena Akali Andane Gote okomane yakama lamolo puu lala-kola, nambato yakama lamolo epeyo lape. Nambana gene, Akali Andane, atapowa-atapowa atalawane oko yakamana yumbane atolai utupane mane atapowa atapowa atalane gene oko teke lolopeyai leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Nimbato Isatale yame akali kawane tupa ando amunguli puato wua lamaipe. Nanimana yumbane Apatakame, Aisake, Jekopo, utupanena Gote Akali Andane oko nambanga ipupia. Epoto wua lapia. Isipi yame tupa mane mana koo pitaka yakamanga miniyai-kola andatawa atalawane lapia. ");
INSERT INTO ipi_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kanditi Isipi okona andi-latane atoto, tandaka noo ateyaiko, tepa alapale. Nambato yakama atu poto, akali yame Kenane, Iti, Amoto, Petesa, Ipi, Jembusapi, akali utupanena yuu andane epene ipane petene eya okonena atu poto atalapale lokale lapia. ");
INSERT INTO ipi_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Nimbato Isatale yame akali kawane tupa lamaule-kola utupane mane nimbana pii loleko ale olopeyai. Nimbato Isatale yame akali kawane tupa atu, Isipi tane kiŋi oko pitulanga poto, wua lalapape, Iputu yamena Akali Andane Gote oko nanima ataimanga ipupia. Okonena andipa nanimato ole tepo angu wandakali napalene yuu okona poto, nanimana Gote okone opa malu makale, nimbato pulupa lola loto nimba tipa pulu epeyama lalapape. ");
INSERT INTO ipi_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Isipi tane kiŋi okone mane yakama pulupa-lo tepa naolo-peya-lo nembo-teyo tekeko, nambato balanga piape tai mindi tupa puluwa-kola balato yakama pulupa-lo tepa olopeya. ");
INSERT INTO ipi_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kanditi Isipi okona mangene-taka, tai mindi-pene mindi-pene tupa nambato piyu, Isipi yame tupanga nambato mana mawuakale. Wuane puluwa-kola, kiŋi okone mane yakama pulupa loto tepe olopeya. ");
INSERT INTO ipi_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Isipi tepa alu yakama mee ipu-napulu peyai. Isipi tane utupanena wenonga nambato gene andane yakama guluwa-kola, Isipi tepa-alu epolo-peyai. ");
INSERT INTO ipi_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isipi wanda yakama towa anda mindiki paliyaini tupapi, wanda yakama towa mandaka atolaini tupa pitaka mane, tonapi, yati epene silipa, golo tupamane waa-pene tupa Isatale wanda yame yakama geakale-lo tipa pua mialapape. Yati epene utupane moto, yakamana andopane tupa mane yati peakale, piyia mayiapape. Wuane pulaini mana okone mane yakamana yandapene tupa sia minoto, mindaka milaini pua Isipi yamena minditaka yola tupa pitaka yakamato molopeyai, Gote-to wuane leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosesa-to Gote lamawuato wua leae-pia. Isatale yame tupamane, namba andayo, nimbato Akali Andane oko anda-napene ato, owato pii nanima langulu epele loto, nambana pii ale nayaindo, nambato anu pukalepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Wuane lea-kola, Akali Andane-to Mosesa tipa pulu peke loto, nimbato aki mindi nimbana kininga aelepe. Wuane lea-kola, Mosesa-to kalango ayo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kalango okone yuunga tepa-aa lea-kola, Mosesa-to kalango okone yuunga tepaya-kola, puya guleae-pia. Okone andoto bala palaka peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Palaka pea-kola Akali Andane okomane Mosesa lamawuato, nimba palaka punapene nimbana kini tepa wato puya okonena etenenga mina leae-pia. Wuane lea-kola Mosesa-to puya okonena etenenga minia-kola puya okone kalango guleae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Isatale yame tupa ateyainga poto, nimbato pilipua pipe. Wuane pule-kola enene wete, yakamana yumbane Apatakame, Aisake, Jekopo, utupanena Gote Akali Andane oko nimbanga ipupiya-lo nembo tolopeyai leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Akali Andane-to Mosesa lamawuato, nimbana kini saketenga aindaka laa leae-pia. Leane pua Mosesa-to kini aindaka loto molo peke lea-kola, balana kini akepuato tapa pitanane ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Lapone teke Akali Andane okomane nimbana kini oko saketenga aindaka lolo peke laa leae-pia. Aindaka loto molo peke lea-kola, balana ombaini epene atalane okone pene atolo peke leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Akali Andane oko mane wua leae-pia. Nimbato pii lole tupa ale nayaindo, metekolo piape bulupane okone pipe. Nimbato wuane pule-kola, andoto nimbana pii ale nayaindo, nimbato metekolo piape lapone okone pipe. Wuane pule-kola, wandakali utupane mane andoto nembo tolopeyai. ");
INSERT INTO ipi_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Utupane mane metekolo piape lapo nimbato pule okone lapo andoto teke, nimbana pii lolene tupa ale nayaindo, nimbato ipa andane Naile ambu moto yuu tai mindinga gae lape. Gae lole-kola ipa utupane wandakali tundupa gulolopeya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Wuane lea-kola Mosesa-to loto, Akali Andane, nambato wandakali wenonga pii kuai-lo lanapi-yawane. Andipa pii lape-lo nimbato namba langeleko. Nambato pii tenga-mane lalawane tekeko, anu pua pii lokalepe-lo nembo nateyo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Wuane lea-kola Akali Andane okomane bala lamawuato, apito wandakalina ambulini lenepi, ateakale leaepe. Apito wandakalina alene, ambulinipi, tuma-pene atekale leaepe. Apito wandakalina lene teakale lata, tuma pita peakale leaepe. Akali Andane namba-to angu utupane pitaka piyawane. ");
INSERT INTO ipi_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Andipa nimba baini puu. Nimbato wandakali pitaka pii lamaula tupa, wua lape-lo nambato nimba moyo langukale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Wuane lea-kola, Mosesa-to Gote lamawuato, Akali Andane, nambato pii katulo pitaka lamai napulu peyoko, nimbato akali waka mindi peakale laa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Wuane lea-kola Akali Andane-to Mosesa towa yataka wato, nimba amene miniyene Atone bala Lipai yame ateya oko dee. Andipa teke balato nimba ayiapima epeyako, balato nimba andoto epele wete olopeya. Balato nimba moyoto pii tupa pitaka katu-lo wandakali tupa lamalu peya nembo teyo. ");
INSERT INTO ipi_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Balato pii leakale nimbato bala lamaipe. Liyambato pii kui-lo lalapale, liyambana ambulini lumboyawa tai laya wakale. Liyambato wua piyapape-lo nambato liyamba mana langukale. ");
INSERT INTO ipi_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Atone bala nimbana ambulini gulo atoto, nimbato pii lole tupa pitaka wandakali utupane lamayakale. Atone wenonga nimba Gote gulo atoto, pii nimbato lole tupa pitaka, balato wandakali tupa lamayakale, nimbato bala lamaiki pipe. ");
INSERT INTO ipi_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Matili nimbato metekolo piape mindi tupa kalango okomane pulako, andipa kalango oko ayu, nimba puu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Akali Andane-to puu lea-kola, Mosesa bala imane Jesoto ateanga peke loto wua leae-pia. Namba yame Isipi kanditi okona ateakale epewane tupa wamba omo koyo peaipe, ateyaipe-lo nambato andolo pokale nimbato puu-laa leae-pia. Wuane leakola, bala imane okone mane katuko, nimba mini epene palu puu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mosesa bala Isipi ini puu napene Midiana yuu okona mee atea-kola Akali Andane oko mane Mosesa lamawuato, nimba peyo ome loyale pua atapiai akali tupa yakama wamba omapiako, andipa nimba Isipi kanditi okona puu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Puu lea-kola Mosesa bala wetenepi, balana andopane okolapopi, utupane dongi mindina peteakale laya alu, Gotena kalango oko moo ayu kanditi Isipi okona peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Akali Andane oko mane Mosesa lamawuato, nimba Isipi peke lole okone angi, nimbato metekolo pula nambato nimba tai laya wakaleko, nimba poto kiŋi oko wenonga metekolo piape tupa pipe. Pule-kola teke, kiŋi oko mane pii tanga leakale lolowa-kola, balato Isatale yame tupa peakale-lo tepa naolopeya. ");
INSERT INTO ipi_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Wuane pulupe-yako, matili Mosesa nimbato kiŋi oko lamawuato, Akali Andane okomane Isatale yame utupane nambana iwana bulupane yame ateyai. ");
INSERT INTO ipi_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nambana andopane yame utupane mane namba-lo lotu lolo epeakale, nimbato utupane tepa ape. Nimbato utupane tepa nawakale lendo, nambato nimbana iwanane bulupane oko peyo ome lokale, wuane lala-lo nimbato kiŋi oko lamaipe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Isipi poyale asini poto paliyaini yuu ongane, Akali Andane oko mane Mosesa malanda wato peyo ome loyale peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Wuane pea-kola, Sipota-to ana nene atene mindi moto bala iwanane okonena yalapene ombaini katuto Mosesana kee tokonga yata wato wua leae-pia. Nimba nambana akalini tekeko, nimba tundupa akali leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Akali Andane-to Mosesa peya napene ando kondayae-pia. Wanda Sipota-to ombaini katiyaini mana okonena, Akali Andane-to Mosesa peyo ome lanapene kondeya nembo toto, akali tundupa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Akali Andane-to Atone lamawuato, Mosesa bala yuu kapu okona epeyako nimbato bala malanda ola puu leae-pia. Atone bala Gotena yuu wangiane okonena epoto Mosesa malanda wato ope-lo nunu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Wuane piyu, Akali Andane okomane Isipi yame tupanga pii lalapape leane tupapi, metekolo piyapape leane tupa, pitaka Mosesa-to Atone lamayae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Matili Mosesa, Atone-la Isipi poto Isatale yame akali kawane tupa moo amunguli peapele-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Akali Andane-to pii Mosesa lamayane utupane pitaka Atone-to Isatale yame tupa lamawuato, utupane wenonga metekolo piape tupa peae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Akali Andane okomane pii Mosesa lamayane tupa pitaka Atone-to Isatale yame tupa lamaya-kola, enene leya loto nembo teaini-pia. Isipi yame tupa mane mana koo Isatale yame tupanga minapi tupa Akali Andane balato andatawa atalawane-lo Atone lamayane pii okone ale wato, Isatale yame yakama yuunga tombawua loto Akali Andane-lo lotu leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","(Sapeta 5:1 - 15:21) Matili Mosesa, Atone-la Isipi tane kiŋi okone ateanga poto, wua leapele-pia. Nanima Isatale yamena Akali Andane, Gote okomane wua lala. Minditaka ata-napene yuu kapu okonena, nambana wandakali tupamane nambana gene minayu-lo lotu lolo peakale nimbato wandakali utupa tepa ape lala leapele-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Wuane leapi-kola, kiŋi okomane lapeke loto, Akali Andane okone bala apipe. Anu piakale nambato balana pii alewato yakama pulupale-lo tepa wakalepe. Nambato Akali Andane okone bala anda-napeyawaneko, yakama pulupa-lo tepa naeyo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Wuane lea-kola, Mosesa, Atone-lamane loto, nanima Iputu yamena Gote oko nalipa ataipanga ipupia. Gote Akali Andane okone opa malu, ole tepo angu yuu kapu okonena makale, nimbato nanima pulupa-lo tepa-aa. Nanima tepa naendo, siki andane mindi yandopi, yanda-pene andane mindi yandopi, nanimanga epeakale lola-kola nanima koyolomane leapele-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kiŋi okomane Mosesa, Atone-la lamawuato, wandakali tupamane nambana piape anupua konda yakale loto, liyambato wuane leyapipe. Taimane yakama atalaini yanga piape pima peke lalapa. ");
INSERT INTO ipi_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Andipa Isatale yame yakama kambua ateyama loto, nambana piape napene kondamakale nembo teyaipe. ");
INSERT INTO ipi_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Okone angi teke, Isipi tane kiŋi okone mane andi-latane ando atalaini Isatale yame akali kawane tupapi, Isipi tane akali kawane tupapi, epo amunguli piyapa loto wua leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Bitiki waa peakale loto, tani kaputene Isatale yame mayiani pua, andipa mainapene kondala-pape, yakama tane molo peakale. ");
INSERT INTO ipi_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","9","Piape puyale kepa wato Gote opa malu makale tepa-aa leyai-ko, piape kambua wete tandaka noo pulai okone mane, owato pii ale-apepene oto mindi yanapekale. Utupane mane bitiki wamba kambua waa piyani pua teke waa peakale lalapape leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Isatale yame piape peakale-lo ando atalaini akali kawane, utupane mane Isatale yame tupa ateainga poto, kiŋi-to tani kaputene bitiki waa piyapale giyae piako maulaini jia lala-lo lamayaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Yakama tane tani saka katu mandulu poto, bitiki wamba waa piyaini mana mindiki okone pene teke waa peakale lalapape lala leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Wuane leai-kola Isatale yame tupamane Isipi yamena yuu tupa pitakana poto tani aŋako mindi-mindi ateane tupa pitaka molo-tone pua ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Akali kawane piape ando atalaini utupane mane Isatale yame tupa andatawa ata-ta puato, wamba tani eya-kola bitiki kambua waa piyaini wuane pua teke waa piyapa laka pua ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Isipi tane akali kawane tupa mane anu peakale yakama-to bitiki wamba kambua waa piyaini pua, andipa, tuni-la waa napiyaipe, loto Isatale yame piape ando atalaini akali kawane tupa peleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Wuane peai-kola Isatale yamena akali kawane utupane kiŋi oko petenga poto, anu peakale nimbato mana okone nanimanga minelepe leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Yakamato tani nanima ginapene ato, bitiki wamba waa piyaini pua teke waa piyapa loto, nanima peleyaipe. Yakama tane kopeta puato, nanima mee wete peleyaiko leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Wuane leai-kola, kiŋi okone mane utupane lamawuato, yakama palako yame, yakama kepa-wato Akali Andane opa malu makale tepa aa-lo namba tipa peyai-pe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Baini yakama piape pima peke lalapa. Yakama tani ginapea-kaleko, yakamato bitiki wamba waa piyaini wuane pua teke waa piyapape leae-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isatale yame ando atalane akali kawane tupa mane kiŋi-to bitiki wamba waa piyaini mana okonena teke waa peakale laene pii okone ale wato, kenda pene andane wete mindi nanimanga baa ipulua-lo nembo teaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Utupane mane kiŋi okone tepa alu, Mosesa, Atone-la maliyo ateapele ongane peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Isatale yamena akali kawane tupamane okone lapo lamawuato, wua leaini-pia. Kiŋi balapi, balana akali kawane tupa pitaka mane wandakali nanima minditaka koo wete, mindiya nembo toto, nanima peyo ome leakale loto yandate toko maipia-peleya. Liyambato mana minapiapele tupa Akali Andane okomane wamba andapiya. Okonena kenda pene mindi balato liyamba geakale leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Wuane leai-kola, Mosesa-to utupane tepa-alu poto Akali Andane-lo pote wua leae-pia. Akali Andane, anu peakale nimbana wandakali tupanga mana koo oko minelepe. Anu piakale namba puu lapipe. ");
INSERT INTO ipi_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nambato pii lamalu puu lee okone angi ato tewa, kiŋi okone mane nimbana wandakali utupa tandaka andane neakale mayako, nimbato utupane ondo wato aŋa mindi moo yanapele okonde leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Wamba Isatale yamena kiŋi mindi ata napea-kola, yakamana akali kawane mindi ataka puato, Isatale yame yakama tane ando ataka peaini-pia. Oto okone angi, yuu okonena ulia nono andane wete mindi yae-pia. Juta yuu Beteleme tano okonena tane, akali mindi balana wetenepi, iwanane lapo towa Moapa kanditi okonena atama peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Akali okone balana gene oko Elemeleke. Bala wetene okona gene oko Naomi. Balana iwanane oko lapona gene Malono, Kilione-la. Utupane yakama Epalata yame, Juta yuu okonena tano Beteleme ukusane ato epoto, Moapa yuu okonena ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Moapa yuu okonena ateai-kola, Elemeleke bala omeae-pia. Omea-kola, Naomi bala iwanane okone lapo towa yakama angu ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Yuu okonena atoto, matili bala iwanane oko lapomane Moapa wanda lapo kee leapele-pia. Wanda okone lapo liyambana gene Lutu, Opa-la. Utupane yakama ee ana payisapi mindi, yuu okonena peteai-kola matili iwana Malono, Kilione-lapi omeapele teke-pia. Naomi bala akalinipi, iwanane okone lapopi, utupane pitaka oma yake lea-kola, bala angu peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Matili Naomi bala Moapa yuu okona pituto aleya-kola, Akali Andane-to balana wandakali tupa moyoto, tomo kambua wete balana yuu okonena ika leakale lapia-kola, tomo nolane kambua eya leai-ko aleyae-pia. Ale wato, bala ayane wanda okone lapo towa Moapa yuu okone tepa alu, balana yuu tene okonena poyale mandeke peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Naomi bala ayane wanda okone lapo towa Moapa yuu okone tepa alu Juta yuu okona peke loyale asini peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Asininga poto Naomi-to wanda okone lapo lamawuato, liyamba angini towa pitima liyamba andaka peke lalapa leae-pia. Liyamba akalini omeapiapi okone lapo ondo wato, namba moyo pitipiapi wuane pua teke, Akali Andane okomane liyamba ondo wato moyo kui laya yakale. ");
INSERT INTO ipi_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Akali Andane okomane liyamba ondo wato moyo yola-kola, liyamba katulo akali waka poto, akali okone lapona andaka kuilo pitulu peyapi leae-pia. Wuane lalu Naomi-to bala yamena mana mindi wato minoto, wanda okone lapo pulupa loto nunu lea-kola, wanda okone lapo mane ai andane loto, ");
INSERT INTO ipi_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","jia, nalipa nimba yame ateyainga Juta yuu okonena atu makale leapele-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Wuane leapi-kola, Naomi-to namba wanane liyamba andaka peke lalapa leae-pia. Anu piakale liyambato namba watama epeyapipe. Nambato iwana mindilapo mandulu peke lolowa-kola okone lapo mane liyamba kee leakale nembo toto, liyambato namba watama epeyapipe. ");
INSERT INTO ipi_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Namba wanane lapo, liyamba andaka peke lalapa. Namba wanda miniyene peteyoko, nambato katulo akali waka mindi na-polopeya. Nambato andipa utulu oko angi teke akali waka mindina poto, iwana mindi lapo mande-wando, ");
INSERT INTO ipi_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","okone lapo anda yakale, liyambato maliyo mee pitulu-peyapipe, jia katu-lo liyambato napitulu peyapipe. Akali Andanena tailene oko nambanga ika loto, andipa namba mino koyeya. Kenda pene nambanga epeya okomane liyambanga kendane epeya oko sia miniya, okonena nambato liyamba ondo wete eyo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Naomi-to wuane lea-kola, Lutu Opala, lapone teke, ai leapele-pia. Matili Opa-to nimba yuunga pupe loto, Naomi nunu lalu, bala andaka peke leae-pia. Tekeko, Lutu-to Naomi tepa naene minatawa mee ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Lutu-to minatawa atea-kola, Naomi-to Lutu lamawuato, nimba akini Opa bala, balana yamepi, balana gote tupa ateyainga pekeleya pua, nimba atu peke lalapa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Wuane lea-kola, Lutu-to Naomi lamawuato, nimbato namba tepa alu puu, lele oko konda. Nimba pole tupana namba atu polo-peyapa. Nimba pitule yuu okonena namba atu teke pitulu-peyapa. Nimba yame tupa namba yame teke atolo-peyai. Nimbana Gote okopi nambana Gote teke atolo-peya. ");
INSERT INTO ipi_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Nimba omole yuu okonena teke namba omoto mali atokale. Omene mane angu nalipa tale pulupeya. Nambato nimba tepa alu mindisa pewando Akali Andane-to kenda pene andane wete mindi nambanga yata yakale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Lutu-to bala atu bakale-lo tai wete lea-kola, Naomi-to Lutu towa pii mindi lanapene kondayai-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Okone lapo liyamba poto, Beteleme tano okona peke ayu leapele-pia. Pekayu leapi-kola, Beteleme tane wandakali pitaka mane moko-lo andeaini-pia. Andoto yuu okonena wanda peteaini tupamane wanda okone apiya, okone enene Naomi yape, api yape, laka peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Wuane laka peai-kola, Naomi-to utupane lamawuato namba ando Naomi laka napene kondalapa leae-pia. Gote tai lene tupa pitaka yene oko mane namba mino koyapiane, tene okonena nambana gene oko Mata lalapa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Wamba nambato yuu oko tepa alu pewa okone-angi, mindi taka kambua yene pewane tekeko, andipa nambanga mindi taka yanapeya-kola, Akali Andane-to namba mee atu peke leya. Gote tai lene tupa pitaka yene oko mane namba mino koyoto mee atu peke leya okonena anu peakale namba ando Naomi-lo ee leayaipe. ");
INSERT INTO ipi_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Lasia bali dini yapepene oto okone tewa epea-kola, Naomi bala ayane Moapa wanda Lutu liyamba Moapa tepa alu Beteleme tano okonena pekaiyu leapele-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Boasa bala Naomi akalini Elemeleke yame akali amango gene yene mindi yuu okonena ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Oto mindi angi, Lutu-to Naomi lamawuato, lasia katu puta pua mandu ateyai, ee tupana namba pokale konda leae-pia. Namba lasia ee okonena polowa-kola, piape akali tupa mane namba ondo wato katulo piape pi-leaindo, lasia yuunga tepaene yolane tupa nambato yapa-lo puta pua yatawakale. Wuane lea-kola, Naomi-to bala lamawuato ayane, okone katu-lo leleko nimbato wuane pipe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Lutu bala lasia ee okonena piape akali tupa masianga watama poto lasia dini itane towa yuunga tepa yaini tupa, yapa-lo puta pua ateae-pia. Lutu-to, bala ayane Elemeleke yame tundupa mindiki Boasana eenga piape pua ateyo-lo nembo natene ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Okone angi teke Boasa bala Beteleme ato balana piape akali tupa piape pua ateainga epoto, wua leae-pia. Otonga, Akali Andane yakama towa ateya, wuane lea-kola, utupane mane balana pii yano peyoto, Akali Andane-to nimba mo kui leakale teke leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boasa-to balana piape ando atalane akali bulupane okone tipa puato wanda oo epo ateyako api yamepe-lo tipa peae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Tipa pea-kola, ee ando atalane akali okone mane, wanda ateya oko bala Naomi towa ipupia-pele, Moapa tane mindi ateya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Wanda okomane namba tipa puato, nimbana piape akali utupa watama poto, lasia dini itane towa yuunga tepa olane tupa mo yake pua yatawakale okone katupe-lo namba tipa piya. Wanda oko mane upapitane piape angu puato, epapu wete, oto mialaini anda okonena aŋa oto mo peteyako. ");
INSERT INTO ipi_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Wuane-lo lamaya-kola, Boasa-to Lutu lamawuato namba wanane, nambato pii leyoko ale-aa. Nambana ee oko tepa alu, ee waka mindina nimba polene. Nambana piape wanda oo ateyai utupa towa nambana ee okona angu nimbato piape pua atape. ");
INSERT INTO ipi_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nambana piape akali tupa aninga lasia mandu ate yaipe-lo andoto nambana piape wanda atolaini tupa towa pipe pua atape. Nambana piape akali tupa mane nimbanga mana koo mindi mina napeakale-lo nambato utupane lamayo. Nimba ipa nono peando, ipa nalaini sisopenenga wamba ambu yata apiani peteya tupana nape. ");
INSERT INTO ipi_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Wuane lea-kola, Lutu bala aiki lekawa tombawua loto, Boasa ando wua leae-pia. Namba, wanda yuu waka tane, anu piakale nimbato namba ando, namba towa mini epene paluto epele elepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Wuane lea-kola, Boasa-to pii okone yano peyoto wua leae-pia. Nimba akalini omea-kola nimbato nimbana wanda ayane towa mana minalene tupa wamba wandakali mane temane langipiai-kola, nambato ale awua. Nimbana, ayiane, angini, yuu-pi, utupane pitaka tepa alu, wandakali wamba lee-inga anda napelene tupana yuunga ipupi. ");
INSERT INTO ipi_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Isatale yamena Akali Andane Gote oko ateyanga nimba epele. Balana papakane pangosia nimba kuilo pitula yame peyo ando ateakale. Akali Andane-to nimbana mana epene minapi tupa andoto balato yole epene mindi nimba geakale. Balato mindi taka kambu nimba geakale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Lutu-to Boasa lamawuato wua leae-pia. Akali andane, nimba-to pii epene langele okone mane nambana yamapane moo tambo laya ele. Namba nimbana piape wanda epene peteyai okone-pene mindi jia tekeko, nimbana pii oko mane namba mino tai laya ele leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Otonga ulia nalaini angi, Boasa-to Lutu lamawuato, nimba onga epoto betesa mindi tupa moto waene ipa okona ate-lo naa leae-pia. Wuane lea-kola, piape wandakali peteaini ongane, Lutu bala poto utupane towa atu peteae-pia. Petea-kola, Boasa-to lasia dini muti-lo yangene minditupa Lutu neakale mayae-pia. Laisa utupane ini ato katulo noo-embo yakola akenane yangi tepa yae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Lutu bala tomo noo koyo piyu, lasia dini itane towa yuunga tepa yane tupa yake puyale ika lea-kola, Boasa-to balana piape wandakali tupa lamawuato, wua leae-pia. Lasia dini itane towa yake pua yata olaini tupana mindi tupa yuunga tepa ene yolane tupa Lutu-to yapalo yake peando, yakamato bala loo yala olaini leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Yakamato lasia dini itane towa yake pene tupana minditupa meakale yuunga aya-lo tepa alapape. Yuunga tepane tupa yapa-lo moo puta pula-kola yakamato yateka wato laiya lolaini leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","18","Lutu-to lasia dini puta pua yomowa atea-kola, ole leae-pia. Ole lene lasia imbuni angane tupa peyo papaka loto nuu andane mindina lasia utupane tumbi-lo manduyu Beteleme tano poto, bala ayane wanda okone andawa leae-pia. Andawa lalu, lasia akenane otonga noto mandeane tupa bala ayane mayae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Maya-kola, balana wanda ayane okone mane bala tipa puato, andipa nimbato lasia utupa aninga mandilipe. Akali api eenga nimba piape pulu pelepe-lo tipa peae-pia. Nimba moyo atalaya akali okone bala, Akali Andane-to moo kui laya yakale leae-pia. Wuane lea-kola, Lutu-to pii okone yano peyoto, akali Boasa lene mindina eenga piape pua ata-lo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Wuane lea-kola, Naomi-to, akali okone bala Akali Andane-to moo kui laya yakale leae-pia. Akali Andane-to wandakali omene, sakapi, utupane towa potomisa pii leyane tupa embesawa konda napiyaneko. Akali Boasa okone nanima yame tundupa mindiki oko, balato nanima katu-lo moyolo peya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Boasa-to pii mindi namba languto wua lala. Lasia dini tupa mandu koyo puato witi dini tupa tewa mandu koyo pulai angi kondola nimba nambana piape wandakali utupa towa atu pipe pua atalapape-lo langiya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi-to bala ayane Lutu lamawuato, nimba akali waka mindina eenga piape pua atole-kola, ee okonena piape akali atolaini tupane mane nimbanga mana koo minulaini nimba Boasa balana eenga piape wanda tupa towa atu piape pua atape leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Lutu-to Boasana piape wanda tupa towa atu atoto, lasia mandu koyo piyu, witi dini tupa mandulu tone puato mandu koyo peaini-pia. Bali witi utupane mandu koyo piyu bala ayane wanda okone towa atu peteapele-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Oto mindi angi, Naomi-to Lutu lamawuato wua leae-pia. Ayane, nimba kui-lo pitula nambato nimbana akali mindi ayia pingukale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ayane, andipa nimbato ale-aa, piape wanda tupa towa nimbato piape pimawua atapi, akali Boasa bala nanima yame tundupa mindiki. Andipa utulu akali okone bala lasia taki loto, yata alaini ama okonena imbuni angane tupa peyo papaka lolo polopeya. ");
INSERT INTO ipi_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Andipa nimbato wasa-wasa kui-lo peyoto, wele tunduma epene piyane tupa ayia alu, tona epene tupa moo piyu, lasia taki-lo, yata alaini ama okonena nimba poto pitipe. Balato nimba pituleko andolane ando, topua pitipe. Bala, tomo ipapi ini nokoyo peakale nimba maliyo topua pitipe. ");
INSERT INTO ipi_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Tomo nalu, bala aninga paleyape-lo nimbato kuilo andape. Bala pangula ongane tengamane wete poto, balana kene yolane ongane palangisa minayu loto nimba palipe. Matili, wua pipe lo balato nimba langulu peya. ");
INSERT INTO ipi_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Lutu-to, pii okone yano peyoto wua leae-pia. Nimbato pipe lele pua nambato wuane pukale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Naomi-to pipe leane pua Lutu bala lasia imbuni peyo papaka lalaini ama okona poto ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boasa bala, ulia ipa tupa nokoyo piyu, mini epene pelea-kola, lasia yata yaini mandaka ongane bala poto palia-ondo yae-pia. Palia-ondo yakola, Lutu bala tengamane wete poto, Boasana kene yanenga palangisa minayu loto, paleae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Matili utulu tombene wete okona Boasa bala moo peke loto andea-kola, wanda mindi balana kene yanga palea-kola, andoto bala moko leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Moko loto, nimba apipe-lo tipa pea-kola, namba nimbana piape wanda Lutu leae-pia. Nimba Elemeleke yame tundupa mindiki, nimbato namba moyo ando atape peneko, nimbato namba keela leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boasa-to pii okone ale wato, wana Akali Andane okomane nimba moo kui laya yakale. Mana epene nimbato andipa minele oko mane, wamba nimbana ayane wanda oko towa mana epene minapi tupa sia miniya. Iwana patane minditaka kambua yenepi, yaa napenepi, ateyai utupanena mindimane nimba kee leakale-lo nembo natapiniya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Wana, tano okona, wandakali pitakamane nimba wanda epene mindi petele-lo andeyaiko, nimba yuku olene, nimbato lele pua nambato pukale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Nimbato enene wete lele. Nimba akalini bala namba yame tundupa mindiki, nambato kuilo nimba ando atape pene. Tekeko balana tundupa mindiki wetete akali mindi ateya okone mane piape okone pipe-pene. ");
INSERT INTO ipi_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Andipa nimba onga piti. Anati upapene nambato akali okone tipa pulu pokale. Balato nimba kee loto moyo ando atokale leando, katu. Tekeko, balato jia leando nambato nimba kee loto moyo ando atokale. Akali Andane-to andeya-kola nambato enene wete leyoko. Waa leakale andipa nimba pangulu peke laa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Yuu waa-lo muna pea-kola, Lutu bala ika leae-pia. Ika lea-kola, Boasa-to bala lamawuato, nimba onga epoto paliliya-lo mindi mane andolaini andopupe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boasa-to Lutu lamawuato, lasia mindi tupa gukale, lapo-lapo duni oko lapona kinimane duli-lo minatawa-ata leae-pia. Boasa-to lapolapo okonena lasia 30 kg gaelo yataya-pia. Yata wato bala andaka awua peakale loto Lutuna kawanenga moo aiyamaiyu Boasa bala tanonga peke leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Lutu bala andaka peke lea-kola, bala ayane wanda okone mane, namba wanane, nimba anu pua pele-pe. Wuane lea-kola, Boasa-to peane tupa pitaka bala ayane oko lamayae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Namba ayane, nimba peteleyanga namba mee peke nalola nembo toto, Boasa-to lasia utupa mandu puu loto namba giya-kola, mandu epeyo leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Wuane lea-kola, Naomi-to ayane, aki mindi nimbanga pulupeyape-lo nalipato nembo nateyapa tekeko mangene pula tupa andolanga mali yaa. Boasa bala mee ata napulu-peya. Jia. Piape okone baini kapoyale balato moo tika pulu peyako, leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Wandakali amunguli piyaini tano asia lomba, ama okonena Boasa bala poto peteae-pia. Petea-kola, Elemeleke yame tundupa mindiki akali okone bala epea-kola, Boasa-to amene, nambato pii aŋako mindi nimba langukale nimba pitipakale onga ipu-lo ee leae-pia. Wuane lea-kola akali okone bala poto Boasa peteane ongane peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Petea-kola, Boasa-to yuu okonena akali kawane paiyasa epeakale loto, yakama epoto pitiyapa lea-kola, utupane ongane peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Peteai-kola, akali Elemelekena yame tundupa mindiki okone lamawuato, Naomi bala Moapa tepa alu peke loto peteya. Bala akalini Elemelekena yuu okone balana tundupa mindiki, nalimbana mindi mane kambo mialapale-lo nembo teya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Okonena nambato nimba ini tipa peyo. Nimbato yuu okone kambokale nembo-tendo nimbato akali kawane oo peteayai tupana wenonga yuu okone kambokale-la, jia nimbato kambo miana pukale lendo, nambato kambo miana pukale-lo nanima yame wandakali ateyai utupa pitakana wenonga yuu okone kamba napukale-lo namba langule-kola nambato yuu okone kambo mokale. Anu peakale-pe, yuu okonena pii nalipato lo-tika pipe pene. Nimbato ini lole-kola namba nimbana masianenga atape pene. Boasa-to wuane lea-kola akali okone mane loto nambato yuu okone kambo mokale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Wuane lea-kola, Boasa-to wua leae-pia: Nimbato Naomi-na yuu okone kambo mole angi Moapa tane wanda yalo Lutu balapi molopele teke. Wuane pule okomane akali omene okonena yuu paluni okone bala yame tupana yamalupeya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Wuane lea-kola, akali okone mane loto, enene wete mindi taka utupane nambana tekeko, mindi taka nambana tupa andopane waka tupa towa tale pua mai napukaleko. Nambato katu-lo yuu okone kamba napukale. Andipa mindi taka utupane nimbana eyako nimbato kambo mia leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Wamba Isatale yame tupa mane yuu-pi, mindi taka mindi akali mindi mauyale pii ini lo tika piyu yakamana sendolo yokoto mayiani mana mindi yalae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Akali okone mane mana okone wato minoto balana sendolo yoko, Boasa mawuato, nimba tane yuu okone kambo mia leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Wuane lea-kola, Boasa-to akali kawane peteaini tupapi, wandakali ateaini tupa pitaka lamawuato, Elemelekepi Kilione, Malonopi utupanena mindi taka tupa pitaka Naomi-to ando yatawa pitipiako. Andipa nambato utupane pitaka yakamana wenonga kambo meyo oko, yakama pitaka mane andeyai-koni leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Andipa nambato yakamana wenonga pii mindi teke tako pua leyo. Moapa tane wanda yalo Lutu, Malono wetene oko nambato kee leyo, Malono balana yuu tene oko, balana paluni yolopeya. Bala yame tupamane yuu okone balana gene atene eyalo nembo tatawa atolo peyai. Andipa nambato peyoko yakamato andeyai-koni leae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Wandakali peteaini tupapi, akali kawane yame utupane pitaka mane wua leaini-pia. Andipa nanimato andeyama, wanda oko bala nimba andaka epeya. Akali Andane-to Isatale yame nanimana wanda awuane, Liya, Lesolo-la yale guu laya ola-kola, Epalata yuu okona nimba akali andane gene yene mindi Beteleme tano okona atolopele. ");
INSERT INTO ipi_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Akali Andane okomane andopane kambua liyamba gula-kola, nimba yame tupa gene andane yene nimba yumbane Juta, Tamala iwanane Petesa yame ateane pua atolopeyai leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Boasa-to Lutu kee lea-kola, Akali Andane-to Lutuna ini moo tika peae-pia. Wuane pea-kola, balato iwana mindi mandeae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Wanda minditupa mane Naomi lamawuato, nanimato Akali Andane nimbana gene layu lama. Balato nimba angu pitula-lo ando kondanapeya. Jia. Nimba moyo ando ateakale nimba yumbane iwana mindi Akali Andane okomane nimba geya. Iwana okone bala Isatale yamena gene yene akali mindi ateakale leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nimbana ayane okone mane nimba wayu mane wete epele eya-kola nimbato-pi, bala epele alane teke. Nimbato iwana yanasia mandipi-yale, epele-ene nimbana wanda ayane okonga eya okone mane utupane sia minapiyale. Tekeko, andipa balato iwana mandeya okomane nimba saka lee taya olo peke laya eya. Nimba mini yole okone angi, iwana okone mane moyo ando atolo-peya. ");
INSERT INTO ipi_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi-to andopane okone moto, yatawa peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Wanda yuu okonena mandaka peteaini tupa mane Naomi-to iwana mindi wamba opelo aiya leaini-pia. Wuane loto iwana okonena gene Opeta leaini-pia. Opeta-to Jesi mandeae-pia. Jesi-to Dapiti mandea-kola, bala Isatale yamena kiŋi andane mindi ateae-pia. ");
INSERT INTO ipi_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Petesa-to Esetone mandeae-pia. Esetone-to Lamo mandeae-pia. Lamo-to Aminatape mandeae-pia. Aminatape-to Nasono mandeae-pia. Nasono-to Salamone mandeae-pia. Salamone-to Boasa mandeae-pia. Boasa-to Opeta mandeae-pia. Opeta-to Jesi mandeae-pia. Jesi-to Dapiti mandeae-pia. Akali utupane pitaka Petesana mandi-yene yumbane yame tupa ateaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_1","033_1_1","JON","1","1","2","Sapeta 1-2 Ole mindi Gote-to akali Amaita iwanane Jona bala lamawuato, Ninipe tano andane okona tane wandakali tupamane koo andane wetete pua atapiai tupa nambato wamba andawuako. Mana koo utupane konda yakale nimbato nambana pii oko tailo lamalu puu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Jona-to Gote-na pii lamaulu pupe-pene tekeko, Gote tepa alu, palaka Tasisa tano okonena poyale, solewata ayatenenga Jopa tano okona peae-pia. Poto sipi mindi Tasisa poyale pea okonena sipi anduane okonenga yole mayu, bala sipi okonena pekayu lo peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Jona bala limu wato, sipi okonena tene anda-pangosa poto, limu paliondowa paleae-pia. Limu paliondo ya-kola, matili Gote-to popo tai andane wete mindi epeakale leae-pia. Popo okone-mane sipi okone peyo-keao laka peae-pia. Piape akali tupamane sipi okone keao leya-lo andoto, yakama yuku yaini-pia. Yuku wato, yakamana gote tupamane yakama moyakale loto yale-yale pote laka peaini-pia. Wuane piyu, pinju kenda peane mandeaini okomane sipi okone landa peyoto ipa pangosa polane lo yuku wato, pinju yane tupa solewatanga moo tepaka peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Wuane pua ateai-kola, sipi ingane minalane akali okomane Jona ayia pua andoto, anu piakale nimba pali-ondowa elepe leae-pia. Nanima omolomane nimbato pote laa. Nanimanga kendane epeyako nimbana gote okomane andoto nanima ondo wato moyakale, nimba ika loto, nimbana gote oko-lo ee-lo pote laa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Okone angi, piape akali tupamane wua leaini-pia. Kendapene nanimanga epeya okona tene oko apinga eyape-lo andamakale, nanima pitakana gene tupa yale-yale pepa tupana peyoto, pene mindina aindaka lamakale. Pene okonena gene molomane akali okone balanga tene atola-kola, nanimanga kendapene mee epeya-lo nanimato katulo andolo-peyama leaini-pia. Utupane-mane wuane peai-kola Jona balana gene oko epeanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Andoto, utupane-mane Jona lamawuato, kenda-pene nanimanga epeya okona tene oko nimbato nanima langi. Nimba onga aki pua atalepe, nimba akali ani-tanepe. Nimba akali yame andokope-lo tipa peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Wuane lo tipa peai-kola, Jona-to utupanena pii yano peyoto, namba akali yame Iputu. Ati-kenga Gote ateya okomane yuu-pi, ipa solewata-pi, yakale lalane, Gote okone tungi peyo nambato lotu lo atalawane. ");
INSERT INTO ipi_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Gote okone tepa alu, namba palaka poyale epo peteyoko leae-pia. Wuane lea-kola, akali utupane yakama yuku wete yaini-pia. Yuku wato, utupane-mane Jona lamawuato nimbato kopeta pipi-kola, Gote-to solewata mina ika loto nimba peyo ome loyale peyape leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Popo tai towa-towa ipa sii andane ika leayako tepa ola-kola nanima kuilo makale nanimato nimbanga anu pimape-lo akali utupane-mane Jona tipa peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Balato pii okone yano peyoto, popo andane tai oko towa-towa ipa kingi epeya okona tene oko nambanga ateya. Popo kingi okolapo tepa ola-kola, yakama epene pulupalenga yakamato namba ipa solewata okona awua aindaka lalapa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Piape akali tupa mane sipi okone ingane minu-awua ayatenenga makale nembo toto makande peaini tekeko, sii-andane wete ika lea-kola utupane-mane katulo ipa ayatenenga napupe-pene guu leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Utupane mane katulo ipa ayatenenga napolo-peyama yaa-lo andoto, Gote ee loto, wua leaini-pia. Gote nimba tane pukale-lo nembo tapi pua teke pele oko. Akali okomane koo mindi napiya-kola nanimato bala ipa solewata okona omea-kale loto aindaka leyama. Bala omola okonena tene oko nanimanga eya loto, nimbato nanima omamakale-lo ando konda napipe-lo pote leyama leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Utupane-mane wuane lo pote lokoyo piyu, Jona minoto, ipa solewatanga awua aindaka leai-kola, sii andane ika leane okone kapoyale okone angi teke tepa yae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Akali utupane mane ipa solewata ika lea oko kapoyale tepaya-kola andoto Gote yukuwa, opa maiyu, potomisa loto, balana pii wato minamakale leaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Oto okone angi, Gote-to pisa andane wetete mindimane Jona goae leakale laya ya-kola, Jona bala pisa andane wetete okonena ini andapangosa utulu otongapi, ole tepoi paleae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona bala pisa andane wetete okona ini anda pangosa paluto, balana Gote Akali Andane okone-lo pote leae-pia: ");
INSERT INTO ipi_vpl VALUES ("JH2_2","033_2_2","JON","2","2","3","Akali Andane nambanga kendapene ipupia-kola nimba ee lawuako, nimbato yano peyapi. Namba wandakali omene atalaini yuu okona atoto, nimbato namba moyola-lo ai lawua-kola, nimbato nambana ai lawuako alewato yano peyapi. Nimbato solewatanga namba awua aindaka lapi-kola solewata mane namba ombo atane pango nenanga wete ateyo. ");
INSERT INTO ipi_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Nimbato namba wato apipini-yalo lawua tekeko, nambato nimbana lotu anda andane ateya oko andolo peke lokaleya. ");
INSERT INTO ipi_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Solewata ika loto, namba yame peya mangua wato namba peyo ome loyale pi-pia. Solewata okona tani kamalumbi ateane tupamane nambana kawanenga epoto, yame peyo ombo apiya. ");
INSERT INTO ipi_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Solewata kundu pango nenanga wete okona namba andi lapia-kola, solewata mandaka ati peleya tupana pini tupamane namba andi latane atauwa tekeko, nambana Gote, nimbato namba molo peke lapi. ");
INSERT INTO ipi_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Namba omape-pene guu-lo yoto nambato Gote nimba nembo tolo-peke loto, pote lawuako nimbana lotu anda andane okona atoto, ale apini yaa. ");
INSERT INTO ipi_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Owato gote tupamane katulo wandakali tupa moya napiyaini tekeko, wandakali minditupa-mane utupane-lo lotu lalaini. Gote-to owato gote lotu lalaini wandakali utupane ondo wato, moyapia-yale tekeko, utupane-mane balana ondo ene oko masia mayiaini. ");
INSERT INTO ipi_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Gote nimbato angu nanima molo peke lalene. Tene okonena nambato wee-tomo tupa loto, opa nimba giyu, nimbana gene oko layu lokale. Minditaka pukale-lo nimba towa potomisa lawua tupa pukale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Jona-to wuane lea-kola, Gote-to ale wato, pisa andane wetete okomane Jona miangu-tangu, solewata ayatenenga aikamaka leakale lea-kola pisa okone mane Jona miangu-tangu aikamaka leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Sapeta 3-4 Gote-to lapone teke Jona lamawuato, ");
INSERT INTO ipi_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Nimbato tano andane Ninipe okonena puu. Poto, nambato nimba pii giwa tupa tano okonena tane wandakali tupa lamaipe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Gote-na pii okone wato minuto, Jona bala Ninipe tano okonena peae-pia. Ninipe tano okone, tano andane gene yene mindi yaepia. Wandakali mindimane tano okonena ayatene ukusa tole ato kee asini angu poto, tano okonena ayatene amoyangisia poyale peando, katulo, ole-tepo pitaka palane. ");
INSERT INTO ipi_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Tano andane okonena Jona-to ole-mindikina angu poto, pii taimane wandakali ee-loto wua leae-pia. Matili ole payisia tukumindi (40) tupa pokoyo pula-kola, Ninipe tano oko wete koyolo-peya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninipe tane wandakali utupamane Gotena pii okone alewa nembo minoto, wua leaini-pia. Akali gene yenepi, nayenepi, nanima pitaka mane tomo nanene jia loto, nanima tane ondo leyama-lo andawa loto, nanima pitaka mane ondo tona pimakale leaini-pia. Pimakale leaini wuane pua, teke peaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ninipe tane kiŋi okomane pii okone ale wato kiŋi pitiyane sia toko okone tepa yae-pia. Balana tona piyane tupa yata wato, yamapane peke leyo-lo andawa loyale laisa beke mane waa-pene ondo tona moo-puato, bala ita talane pete-yanenga peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_7","033_3_7","JON","3","7","8","Wuane piyu, Ninipe tane kiŋi okomane wandakali pitakanga pii wua-lo awu tawe yakale leae-pia: Nambapi, nambana akali kawane yame, nanima pitaka mane pii oko yakama langeyama. Yakama pitaka mane tomo ipapi nanene kondalapape. Wandakali yakamapi, dee, yakamana bulumakao, sipisipi, memepi, utupane pitaka mane tomo ipapi, jia-loto nanene konda yakale lalapape. Yakama pitaka mane yamapane peke leyama-lo andawa loyale, laisa beke mane waa pene ondo tona piyaini taka tupa pua atalapape. Wuane piyu, yakamato yakamana sipisipi, bulumakao, memepi, utupane pitaka beke mane waa pene lapolapo tupamane yame peyamai yapape. Yakama pitaka mane koo piyaini tupa pitaka kondalapape. Gote-to nanima ondo wato koo nanimana apia-ngeakale yakamato pote tai-lo lalapape. ");
INSERT INTO ipi_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Nanima pitaka-mane wuane puluma-kola, Gote-to nembo-tene lawa puato, nanima peyo ome lanapene kondeyape-lo andamakale leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Utupane-mane koo pua ateaini tupa awua tepa alu lawa peyama-lo wuane pua atea-kola, Gote-to andoto, balana nembo-tene lawa puato, utupane peyo ome naleae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Gote-to balana nembo tene lawa puato, Ninipe tano okone mino koya napea-kola, Jona bala mini koo paluto, yataka wete yae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Balato Gote ando pote wua leae-pia. Gote nimbato ini kapoyale embo aa-napilini. Jia. Ole dindi lo nimbato wandakali tupa wayumane wete ondowato epelewa yamapane yoo atalene. Nimbato wamba ini wandakali tupa minu koyoyale mandeke pitawa atoto teke, matili mino koya napilini. Wamba namba andaka atoto, wua lo nembo tewa: Namba yame towa yandapene Ninipe tano okona poto, nimbana pii oko wandakali utupane lamae-wando, nimbato Ninipe tane wandakali tupa peyo ome nalolo-pele-yalo nembo toto, nambato nimba tepa alu, palaka Tasisa tano okona poyale pewako. ");
INSERT INTO ipi_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Namba yame towa yanda pene Ninipe tane tupa Gote nimbato peyo ome lanapene kondele okonena, namba omewando, katu lolo peyako nimbato namba ini mino ome laa leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Jona-to wuane lea-kola, Gote-to balana pii okone yano peyoto, Jona nimbato katu-lo yataka elepe leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Tano okonena aki mindi peyape-lo andoyale, Jona bala tano okone tepa alu poto, nai-epalanesia anda mindi pitawato okonena peteae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Gote-to Jona nai toto olane loto, eyaka yokone pata atalane okone taka mindi, ayiakame okone yame peyo ombo yakale leae-pia. Jona bala eyaka okonena tambo pangosa pitoto bala epele wete yae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Anate-lene upanda wete Gote-to eyaka yokone nalane sau-nana mindimane eyaka okone noo kapu teakale lea-kola, kapu teae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Matili nai tea angi, Gote-to nai epalanesia ato popo toto pene wetete mindi epekale lea-kola, nai toto peane okone mane Jonana kawane tandaka piya wato, moo malawai laya yae-pia. Malawai lea-kola yuunga lombape-pene yoto, namba omokale okone mane katu-lo namba moyolopeya. Namba omanape-wando katu-lo namba moya napulu-peya leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Wuane lea-kola, Gote-to Jona lamawuato, eyaka kapu tala oko towa nimbato yataka eleko. Nimbato tika pua yataka elepe lea-kola, Jona-to pii okone yano peyoto, namba yataka wete eyoko, namba omewando okone kuai leae-pia. ");
INSERT INTO ipi_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Jona-to wuane lea-kola, Gote-to Jona lamawuato, utulu mindiki okona ato eyaka oko ikalo anda-yoo atala, utulu lapone okona eyaka oko omala. Nimbato piape aŋako mindikipi mindi eyaka okona pinapili, dee andane guleakale-lopi mindi lanapili tekeko, aŋako okona nimbato wayumane wete ondo elepe. ");
INSERT INTO ipi_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Nambatopi Ninipe tano oko ondo wete eyo. Tano oko andane wete mindi eyakola, wandakali andita tuaindi tausene (120,000) wata aipeke-lo ateyai. Wandakali utupane pitaka mane mana epene mindi anda napeyaini. Bulumakaopi, kambua wete tano okonena ateya leae-pia. Yakamato pii temane okone ale wato, pii ukupini pepa pelene eya tupa dii loto ale-alapape. Gote-to lapone Jona lamawuato, nimbato nambana pii oko Ninipe tane wandakali tupa lamalu puu leae-pia. Jona-to Gotena pii wato minuto, Ninipe tane bala towa yanda pene wandakali tupa Gotena pii lamaiyae-pia. Utupane mane yamapane moo peke leai-kola, Gote-to utupane ondo wato, minu koya napeae-pia. Wuane pua teke, nanimatopi yanda pene tupa ondo wato, moyape-pene leya. ");
INSERT INTO ipi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisasa Kataisana yumbane yame atama epeaini tupana gene tupa pepa okona peyatane eya. Jisasa bala Dapiti yame okona mandiyene mindi ateaipia. Dapiti bala Apatakame yame okona mandiyene mindi ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Wamba Apatakameto Aisake mandeaipia. Aisaketo Jekopo mandeaipia. Jekopoto Jutapi, Jutana amene tupapi, utupane mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juta-la, wanda Tema-la, okonelapo-mane Petesa, Seto-la, okonelapo mandeapele-pia. Petesato Esotone mandeaipia. Esotoneto Lamo mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamoto Aminatape mandeaipia. Aminatapeto Nasone mandeaipia. Nasoneto Salamone mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamone-la, wanda Leapa-la, okonelapo-mane Boasa mandeapele-pia. Boasa-la, wanda Luta-la, okonelapo-mane Opeta mandeapele-pia. Opetato Jesi mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_6a","070_1_6a","MAT","1","6a","6a","Jesito kiŋi Dapiti mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","6b","Dapitito Solomone mandeaipia. Wamba Solomone okona angini oko bala akali Yutaya okona wetene oko peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoneto Leapome mandeaipia. Leapometo Apiya mandeaipia. Apiyato Asa mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asato Josapata mandeaipia. Josapatato Jotama mandeaipia. Jotamato Usaya mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usayato Jotama mandeaipia. Jotamato Easa mandeaipia. Easato Esakaya mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esakayato Manasa mandeaipia. Manasato Emone mandeaipia. Emoneto Josaya mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josayato Jekonayapi, balana amene tupapi, utupane mandeaipia. Okone angi, Bapilone yuu okona tane tupamane Isatale tane wandakali tupa andi lo awua peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bapilone yuu okona tane tupamane Isatale tane tupa andi lo awua peai-kola, Jekonayato Siatele mandeaipia. Siateleto Setapa-pele mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Setapa-peleto Apiata mandeaipia. Apiatato Elaya-kimi mandeaipia. Elaya-kimito Eso mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esoto Setoko mandeaipia. Setokoto Ekimi mandeaipia. Ekimito Eliyutu mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyututo Eliasa mandeaipia. Eliasato Matane mandeaipia. Mataneto Jekopo mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopoto Josepe mandeaipia. Josepe bala wanda Matiya okona akalini. Matiyato Jisasa mandeaipia. Wandakali-mane Jisasana gene mindi Kataisa lalaini. ");
INSERT INTO ipi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wamba wetete Apatakame atea-angi ipapo wato, Dapiti atea-angi giau loto, yumbane yame atama epeaini utupane yame ingasa ateainipia. Dapiti ateane okone angi atama ipapo wato, Bapilone tane tupamane Isatale tane tupa andi lo awua peaini-angi giau loto, yumbane yame atama epeaini tupa yame ingasa teke ateainipia. Bapilone tane tupamane Isatale tane tupa andi lo awua peaini okone angi atoto, ipapo wato, Matiyato Kataisa mandeane-angi giau loto, yumbane yame atama epeaini tupa yame ingasa teke ateainipia. Jisasana yumbane yame ingasa tepo tupa pitaka wuane pua atama epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Matiyato Jisasa Kataisa mandeane pii temane okomane wua leya: Wamba Matiya yame tupamane bala Josepena peakale leaini tekeko, liyamba mina mindiki naleapi wete, Oli Sipitisa okomane andopane mindi Matiyana ininga pete lea-kola, wandakali-mane Matiya bala andopane mindi mandulu-peya ya lo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Bala bakale lene Josepe oko bala akali epene tika-pene mindi atoto, Matiya mo yala aya na-wakale loto, wanda oko kee nalene, mee tenga-mane tepa wakale nembo tatawa paleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josepeto wuane nembo tatawa palea wete, kombeya-mane Akali Andane okona enjole mindi epoto, Dapiti yamena mandiyene Josepe nimbato Matiya nimbana bakale lene oko lamoyale yuku naene, lamiape leaipia. Andopane mindi balana ininga peteya oko Oli Sipitisa okomane pete laya apiane mindi peteya. ");
INSERT INTO ipi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Balato iwana okone mandula-kola, matili iwana okonemane bala yame tupana koo tupa apoto, utupane molo-peke lolopeya-ko. Nimbato balana gene Jisasa lape. Enjole okonemane wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Wamba potopesa akali mindimane Akali Andane okona pii mindi leane oko loto, ale alapape, wana mapokae akali mindi towa mina mindiki nalene mindina ininga andopane mindi pitulu-peya leaipia. Wana okonemane iwana mindi mandula-kola, wandakali-mane balana gene oko Emanuale lolopeyai. Gene Emanuale okonena tene oko Gote nanima towa atu ateyama leaipia. Potopesa akali okonemane pii leane okone enene guleakale loto, Goteto mangene utupane pitaka wuane piya yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josepe bala limu paliyu, ika loto, Akali Andane okona enjole okonemane bala lamaiyane pua, wanda Matiya oko kee leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Balato bala kee leane tekeko, Matiya bala Josepe towa mina mindiki nalene teke pitima pulu, iwana oko mandeaipia. Mandea-kola, Josepeto iwana okonena gene oko Jisasa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Etote bala kiŋi atea-angi, Matiya bala Jutiya disitiki tano Beselekeme okona pituto, Jisasa mandeaipia. Mandea-kola, kaiyanda tupana mana andene akali minditupa nai epelanesa-tole yuu mindina ato Jutusaleme epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Epoto, utupane-mane pii mindi loto, nanimato andaima-kola, Juta yame kiŋi okona kaiyanda oko nai epalanesa-tole epo atapia leainipia. Kaiyanda okone andalu, iwana mindi matili Juta yamena kiŋi atolopeya okone bala mandiyene eya nembo teyama. Wuane nembo toto, nanimato iwana okone lo lotu lolo epeyama-ko. Bala aninga mandiyene eyape lo tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jutusaleme tane wandakali tupamane pii okone ale wato, utupane pitaka-mane nembo kambua teainipia. Kiŋi Etote balatopi pii okone ale wato, anu puape lo nembo kambua teke teaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nembo kambua toto, balato pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane pitaka epeakale loto, mo amunguli peaipia. Amunguli peai-kola, balato utupane tipa puato, angini-mane Mesaya oko yuu andokona mandulu-peya layene eyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Wuane lea-kola, utupane-mane bala lamawuato, wamba potopesa akali mindimane Gotena pii mindi pepa peyoto, wanda mindimane Jutiya disitiki tano Beselekeme okona pituto, ando atolane akali mindi mandulu-peya. Mandula-kola, akali okonemane Isatale tane wandakali nambana yame ateakale lata ewane tupa moyo ando atolopeya leane leainipia. Akali okonemane wuane pua atala-kola, Beselekeme tano nimba Jutiya disitiki okona tano kambua tupa sia minuto, nimba tano gene yene wete mindi yolopele lo pepa pelene eya. Nanimato pepa okone dii lo andoto, angini-mane Mesaya oko bala Jutiya disitiki tano Beselekeme okona mandulu-peya layene eya lo andeyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wuane leai-kola, Etoteto kaiyanda tupana mana andene akali utupane angu epeakale loto, utupane tenga-mane too pua tipa puato, andoko angi kaiyanda okone epo atapiape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Utupane-mane balana pii okone yano peleai-kola, balato utupane lamawuato, nambatopi andopane okone lo lotu lokale-ko. Yakamato Beselekeme yuu okona poto, bala aninga eyape lo wayumane aiya piyapape. Yakamato bala aiya pua andolai-angi, namba langima peke lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wuane lea-kola, utupane-mane kiŋi okona pii okone ale alu, Beselekeme tano okona poyale asini peainipia. Asini peai-kola, wamba nai epalanesa-tole atoto epeane kaiyanda andeaini okone ingane peaipia. Ingane pea-kola, kaiyanda tupana mana andene akali utupane-mane kaiyanda okone andoto, epele wete wato, kaiyanda okone watama peainipia. Watama peai-kola, kaiyanda okone ingane poto, andopane yane anda okona tokonga ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Atea-kola, akali utupane yakama anda okonena kolandaka loto, andopane okola, balana angini Matiya-la, okonelapo andeaini-pia. Andoto, akali utupane-mane aiki leka wato, andopane okone lo lotu leainipia. Lotu lo koyo piyu, utupane-mane yakamana nuu tupa tanguto, golopi, tua tunduma-pene pautapi, ita tongone tunduma-pene yole andane-mane kambene minditupapi, utupane moto, andopane okone bala petesene mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Maiyu, utulu paleai-kola, Goteto akali utupane kombeya pimawuato, yakama kiŋi Etote ateya okona peke lolaini leaipia. Wuane lea-kola, akali utupane-mane ika loto, asini waka mindina yakama yuunga peke leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Akali utupane peke leai-kola, Goteto Josepe kombeya mindi pimaya-kola, Akali Andane okona enjole mindimane panakame epoto, Josepe lamawuato, Etoteto andopane oko peyo ome lokale nembo toto, bala aninga eyape lo aiya puyale mandeke peya leaipia. Balato andopane okone peyo ome lolane. Nimba ika loto, andopane angini-la atu aiyu, Isipi yuu okona palaka poto atalapape. Matili nambato yakama peke lalapa lolowa-angi, yakama peke lalapale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Enjole okomane wuane lea-kola, utulu okone angi teke Josepe bala ika loto, andopane angini-la atu aiyu, Isipi yuu okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Poto, utupane Isipi yuu okona ateai wete, Etote bala omeaipia. Wamba potopesa akali mindimane Akali Andane okona pii mindi leane oko loto, nambana iwanane oko bala Isipi yuu oko tepa alu, epeakale lewa leaipia. Pii okone enene guleakale loto, matili Etote omenenga, Goteto Jisasapi, balana angini ayianepi, utupane Isipi yuu oko tepa alu epeakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","18","Wamba potopesa akali Jetemayato pii mindi loto, wanda Lesolo okona andopane tupa omolai-kola, bala yali ee lo ai andane lo pitulu-peya leaipia. Ai lo pitula-kola, Lama tano okona tane wandakali tupamane ale wato, balana yamapane mo epele piya amakale nembo tolopeyai tekeko, balana andopane tupa ata napulai-kola, Lesolo bala mini epene pali napene, mini kendawa pitulu-peya leaipia. Kaiyanda tupana mana andene akali tupamane Etote minakasa wato, asia waka mindina peke leai-kola, Etoteto utupanena mana okone andoto, yataka wete yaepia. Yataka wete wato, kaiyanda tupana mana andene akali tupamane kaiyanda okone ole oko angi epo atapia lo bala lamai-yaini okone nembo tolo-peke leaipia. Okone nembo tolo-peke loto, balato akali minditupa lamawuato, yakama Beselekeme tano okonapi, Beselekeme ongane mandaka yuu yalane tupanapi, yuu utupane pitakana poto, iwanaŋa mali lapo penepi, mali lapo napenepi, utupane pitaka peyo ome lalapape leaipia. Wuane lea-kola, akali utupane-mane iwana utupane pitaka peyo ome leaini okomane pii wamba potopesa akali Jetemayato leane okone enene guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Kiŋi Etote omea-kola, Josepe bala Isipi yuu okona atoto, kombeya mindi pea wete, Akali Andane okona enjole mindi epoto, andopane oko peyo ome loyale makande pua atapiai akali tupa omapiai-ko. Nimba ika lalu, andopane angini-la atu aiyu, Isatale yuu okona peke laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Balato wuane leane oko ale wato, Josepe bala ika loto, andopane angini-la atu aiyu, Isatale yuu okona peke leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josepe bala peke loto, ale ya-kola, Etote iwanane Akele-yasa lene oko bala ayianena panda moto, Jutiya disitiki oko ando ateya lene oko ale yaepia. Ale wato, Josepe bala yuu okonena poyale yukuwa atea-kola, Goteto Josepe kombeya mindi pimawuato, Josepe nimba Jutiya disitiki okona polene leaipia. Wuane lea-kola, Josepe bala ika loto, andopane angini-la atu aiyu, Galili disitiki okona peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Poto, utupane Nasatesa tano okona ateainipia. Wamba potopesa akali tupamane pii mindi loto, wandakali tupamane Mesaya oko bala Nasatesa tane mindi ateya lolopeyai leainipia. Jisasa bala Nasatesa tano okona poto atea-kola, potopesa akali utupanena pii okone enene guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","4","Okone angi, ipa peya-maiyane akali Jone oko bala Jutiya disitiki okona epoto, wandakali napalene yuu mindina ateaipia. Balana tona yia kamele itini-mane waa-pene mindi umbaininga piyu, matipu bulumako umbaini-mane waa-pene mindi pua atalaepia. Balato neme ipane-mane waa-pene tomo oni lene siapusa lialane tupapi, palai tupapi, utupane no atalaepia. Wamba potopesa akali Aisayato Jone andayo, Gotena pii mindi loto, akali mindimane wandakali napalene yuu mindina atoto, pii taimane loto, yakamato Akali Andane oko epolane asini mindi mandeke pua yata mawuato, balana asini aŋako tupa mo tika piyapape lo atolopeya leaipia. Potopesa akali Aisayato pii okone leane pua teke, Jone bala wandakali napalene yuu okonena atoto, Gotena pii oko wandakali tupa lamaiki puato, ati kenga yuu epene okona atalane akali okomane yakama moyo ando atoyale mandaka gulo epeya-ko. Yakamato yamapane peke lalapa lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Joneto wuane loto, pii lamaiki pea-kola, Jutusaleme tanepi, Jutiya tanepi, ipa Jotane mandaka atalaini wandakali tupapi, utupane pitaka bala ateanga ipuku peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ipuku puato, utupane-mane yakamana koo piyaini tupa lo pana aka peai-kola, Joneto ipa Jotane okona atoto, utupane ipa peya-maiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Joneto utupane ipa peya maiki pea-kola, Patasai tupapi, Satusi tupapi, utupanena kambua minditupa ipa mia-makale lama epeainipia. Epeai-kola, Joneto utupa andoto, yakama etulu gepo-mane mandiyene yame ateyai leaipia. Goteto yakama towa yataka wato, kenda-pene minditupa yakama gulupeya-ko. Apito wuane lo yakama langipia-kola, Goteto kenda-pene utupane yakamanga epeakale lolane lo yuku wato, yakama palaka epoto, ipa mia-makale leyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","10","Goteto ana oo eya utupa Apatakame yame gulalapa leando, ana utupa-mane katulo Apatakame yamena mandiyene wandakali tupa gulolo-peyai. Wuaneko, yakama teke-teke pii lalawa puato, nanima Apatakame yame wandakali ateyama-ko. Goteto nanima towa yataka wato, kenda-pene mindi nanima gii napulu-peya lolaini, ando atalapape. Goteto ita koo tupa yokoyale, uu mindi ita tenenga yata yane eya. Dini epene lia napiyane ita tupa pitaka balato yoko wato, ita too atene okona yangolo-peyako. Ita epene tupanga dini epene lialaini pua, yakama mini peke loto, mana epene tupa wato minalapape. ");
INSERT INTO ipi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Akali mindi epolopeya okonena tai-lene okomane nambana tai-lene oko sia minulu-peyako. Nambato balana sukee pula oko ai maipe-pene namba akali epene mindi jia. Yakama yamapane peke leyai-kola, nambato ipa-mane yakama ipa peya-geyo tekeko, akali matili epolopeya okomane Oli Sipitisa okola, ita kaiyapiane okola, okonelapo-mane yakama ipa peya-gulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Balato sapolo mindi awua ateya okomane witi dini epene tupa balana tomo yalane anda okona yata wato, witi imbuni tupa aki puato, ita too koyo napiyane mindina yangolo-peya. Wuane piyu, balato utupanena minditupa balana piape piyane ama okonena mee yakale lo ando konda napulu-peya. Jia. Joneto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Okone angi, Joneto bala ipa peya-geakale nembo toto, Jisasa bala Galili disitiki oko tepa alu, ipa Jotane okona epeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jisasa ipa molo epeane tekeko, Joneto bala lamawuato, nimbato namba ipa peya gipi-yale, okone kuai lapia-yaleko. Anu peakale nambato nimba ipa peya-gii lama epelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimbato namba ipa peya-geendo, mana okonemane Gotena mana epene tika-pene oko nalipato wato minulupa-kola pulu-peyako. Andipa nambato leyo pua nimbato nambanga pii leaipia. Wuane lea-kola, Joneto balana pii okone wato minuto, bala ipa peya-maiyaepia. ");
INSERT INTO ipi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisasa bala ipa mialu, ipa oko tepa wato, andea-kola, ati iyu oko yapu lo toko lea-kola, Gotena Sipitisa oko eka uya gulo balanga epo peteanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Okone angi, pii layene mindi ati kenga atala epeane okomane Jisasa andayo pii mindi loto, akali oo ateya oko bala nambana iwanane yamapane yene oko. Nambato balana mana tupa andoto, epele wetete eyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Okone angi, Sataneto Jisasa minu mandeke peakale loto, Oli Sipitisa okomane Jisasa atu aiyu wandakali napalene yuu mindina peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yuu okonena atoto, ole paiyasa tukumindi utulu otongapi, Jisasa bala ulia nanene atea-kola, matili bala ulia nono wete yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ulia nono wete ya-kola, mandeke piyane akali koo Satane oko bala Jisasa ateanga epoto, enene, nimba Gotena iwanane ateendo, nimbato ana oo eya utupa betesa guleakale laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wuane lea-kola, Jisasato balana pii okone yano peyoto, tomo-mane angu wandakali mindi saka ateakale lo ataya na-alane. Jia. Gotena pii layene epene tupa pitaka-mane wandakali mindi saka ateakale lo ataya alane lo pepa pelene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wuane lea-kola, Sataneto bala atu aiyu Gotena tano epene wete Jutusaleme okona poto, lotu anda andane okona kenga wete ate leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ate lalu, balato Jisasa lamawuato, Gotena pii pepa pelene eya mindimane loto, ana-mane nimbana kee nolane nembo toto, Goteto balana enjole tupa lamawuato, yakamato kii wanga latawa atalapape lolopeya layene eya-ko. Enene, nimba Gotena Iwanane ateendo, anda kenga wete okona atoto, peaka nena laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimbana Akali Andane Gote oko minu mandeke napipe lo pepa pelene eya teke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wuane lea-kola, Sataneto Jisasa atu aiyu yuu wangiane kenga wete mindina poto, kanditi yane tupa pitakapi, kanditi utupanena minditaka epene wete yane tupapi, utupane pitaka balanga andawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Andawa loto, balato Jisasa lamawuato, nimbato tombawua loto, namba lo lotu leendo, nambato utupa pitaka nimba gukale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wuane lea-kola, Jisasato bala lamawuato, nimbana Akali Andane Gote oko angu lotu lo atoto, balana piape oko angu pimawua atape lo pepa pelene eya-ko. Satane nimbato namba tepa alu puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wuane lea-kola, Sataneto Jisasa tepa alu pea-kola, enjole minditupa epoto, Jisasa moyaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","16","Wamba Galili disitiki okona wandakali yame waka minditupa ipa Jotane amo yangi ateai-kola, potopesa akali Aisayato pii mindi utupane lamawuato, Sepulane, Napatali-la, yame okone-lapona yuu mindi ipa angini Galili okona matenenga mandaka atalaini wandakali yame waka tupa yakamato ale alapape. Wamba wandakali minditupa undupi pangosa atoto, omene gulo ateaini tekeko, matili tii-pene andane mindi epea-kola, utupane-mane tii-pene okone andeaini leaipia. Matili Etoteto Jone andi lea-angi, Jisasato pii temane okone ale wato, Galili disitiki okona peke leaipia. Peke loto, balato pii wamba Aisayato leane okone enene guleakale nembo toto, Nasatesa tano oko tepa alu, Sepulane, Napatali-la, yame okone-lapona yuu okonena peaipia. Poto, ipa angini Galili okona matenenga Kapaneame tano okona ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kapaneame tano okonena atoto, Jisasato balana piape tupa bulupane tewa puato, Gotena pii oko wandakali tupa lamawuato, ati kenga yuu epene okona atalane akali okomane yakama moyo ando atoyale mandaka epeya-ko. Yakamato yamapane peke lalapa laka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Saimone balana gene mindi Pita lene okola, balana amene Endutu okola, okonelapo-mane pisa moto, bisanisa piape pua atalapele-pia. Alu mindi okonelapo-mane pisa mialapele umbene nuu andane wete mindi ipa angini okona aindaka lo ateapi-kola, Jisasa bala ipa angini Galili okona ayatenenga epo poto, okonelapo andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Andoto, balato okonelapo lamawuato, liyambato wandakali mialapale lo nambato mana langukalenga, namba watama ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wuane lea-kola, okone angi teke akali okonelapo-mane pisa mialapele umbene nuu tupa yakale tepa alu, bala watama peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bala aŋa amonga-yale poto, akali Sepiti iwanane Jemesa, balana amene Jone-la, okonelapo andeaipia. Akali okonelapo liyambana ayiane Sepiti oko towa sipi mindina pituto, yakamana pisa mialaini umbene nuu tupa tambu lo peteai-kola, Jisasato akali okonelapo ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ipulupa lea-kola, okone angi teke, akali okonelapo-mane sipi okola, liyamba ayiane okola, okonelapo awua tepa alu, Jisasa watama peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisasa bala Galili disitiki okona yuu tupa pitakana epoko pua atoto, Juta yamena lotu anda tupana poto, Goteto wandakali tupa moyo ando atalane lo, Gotena pii layene epene oko lamawua ateaipia. Pii lamawua atoto, balato wandakali siki waka-waka pelene tupa pitaka mo atu yaka pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wuane pua atea-kola, wandakali minditupa Sitiya potopinjia okona yuu tupa pitakana poto, balato wuane peya loto, pii lo tawe yainipia. Pii okone lo tawe yai-kola, wandakali-mane yangone siki pelene tupa pitaka Jisasa ateanga atu aiyu ipuku peainipia. Tandaka andane no atalaini wandakali tupapi, sipitisa koo atene wandakali tupapi, yuunga lomba-pene yoto, putiti peyalaini wandakali tupapi, kulini manda-tene wandakali tupapi, wandakali okonepene tupa atu ipuku peai-kola, Jisasato wandakali utupane pitaka mo atu yaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mo atu yaka pea-kola, Galili tanepi, Dekapolisa tanepi, Jutusaleme tanepi, ipa Jotane amo yangi tanepi, Jutiya disitiki okona tanepi, yuu utupane pitakana tane wandakali kambua-mane bala watama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wandakali yame kambua-mane bala watama epeaini tupa andalu, Jisasa yuu wangiane mindina poto, petea-kola, utupane-mane bala peteanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","3","Epeai-kola, balato utupane mana lamawuato, wandakali minditupa-mane Gotena wenonga tipia ateyama nembo teaindo, Goteto utupane moyo ando atolopeya leaipia. Balato utupane moyo ando atolopeya nembo toto, wandakali utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Goteto wandakali ai lo atalaini tupana yamapane mo epene pale lolopeya-ko. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Matili Goteto yuu tupa pitaka wandakali tambo lo atalaini tupanga maulu-peyako. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wandakali tomo ipapi nauwa lakae lo nemboto talaini pua teke, Gotena mana epene tika-pene tupa wato minauwa lakae lo nemboto ateaindo, Goteto utupane moyolo-peya. Moyola-kola, utupane-mane katulo mana epene tika-pene utupane wato minulu-peyako. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wandakali yangone ondo wato moyalaini wandakali tupa Goteto ondo wato moyolo-peya-ko. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Goteto andola-kola, wandakali minditupana yamapanenga koo tene mindi nayando, utupane-mane Gote andolo-peyaiko. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wandakali minditupa-mane yanda pua atolai-kola, wandakali waka minditupa-mane yanda kondalapa loto, yanda pua atolaini okone minu koyo piya yaindo, Goteto wandakali utupane balana andopane ateyai lolopeya-ko. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wandakali minditupa-mane Gotena mana epene tika-pene tupa wato minu atolai-kola, wandakali waka minditupa-mane kenda-pene andane tupa utupane mai-yaindo, Goteto wandakali epene utupane moyo ando atolo-peyako. Utupane-mane epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Wamba yakama ata napenenga, wandakali minditupa-mane potopesa akali ateaini tupa andayo owato pii kambua loto, utupane koo ya loto, kenda-pene andane minditupa utupanenga mayainipia. Wuane pua teke, andipa ateyai wandakali yakama nambana yame ateyai lo andoto, wandakali minditupa-mane kenda-pene andane okonepene tupa yakamanga gulupeyai tekeko, namba yamena yole andane mindi ati kenga yuu epene okona yolopeya. Tene okonena, wandakali minditupa-mane kenda-pene andane okonepene tupa yakamanga gulai-angi, namba yame wandakali yakamato ati kenga poto, yole andane oko molopeyama nembo toto, epelewa atape-pene. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Okone angi, Jisasato pii mindi tako pua loto, yakama wandakali pitakana sole gulo ateyai tekeko, sole minditupa tende napene guleando, nanimato anu puato, sole okone dee lapone mo tende piya olo-peyamape leaipia. Sole koo okonemane wandakali mindi moya napulu-peya nembo toto, wandakali-mane apeyai-kola, wandakali waka tupamane asininga epo poto, kee-mane ango alaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wuane lalu, Jisasato pii mindi tako pua loto, tano mindi yuu wangiane mindinga yando, tano okone katulo too pua nayalane leaipia. Ale tii peya-kola, wandakali-mane asia katulo andalaini pua teke, yakamato Gotena pii lamai-yaikola, wandakali pitaka-mane balana asia epene oko katulo andalaini. ");
INSERT INTO ipi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wandakali-mane lamu mindi kayuto, sisopene mindimane lamu okone ombowa yata na-alaini. Jia. Utupane-mane lamu mindi kayuto, tepolo tokonga yata eyai-kola, wandakali andaka pitulai tupa pitakanga tii pikoyo piyane. ");
INSERT INTO ipi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wuane piyane pua teke, wandakali-mane yakamana mana epene tupa andoto, yakamana ayiane ati kenga atalane okona gene oko laiyu leakale nembo toto, yakama lamu gulo atoto, wandakali tupa tii piyawa atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Wuane lalu, Jisasato pii mindi tako pua loto, nambato Gotena loo tupapi, potopesa akali tupana pii tupapi, utupane mo mee gulaya olo epeae-ya lo yakamato nembo na-talapape leaipia. Pii utupane enene guleakale nembo toto, nambato Gotena loo tupapi, potopesa akali tupana pii tupapi, utupane-mane leaini pua pulu epewane. ");
INSERT INTO ipi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nambato pii enene mindi yakama langeyo. Gotena loo okomane leya pua mindimane piyiake lola-kola, loo okona piape oko koyo pulupeya tekeko, yuu ati-la alu napula-kola, Goteto balana loo utupanena pii aŋako wete mindi yandopi, pepa maki aŋako mindi yandopi, utupanena mindikipi mindi mo apia napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","20","Tene okonena, yakamana mana epene tika-pene tupamane loo tupana mana andene akali tupapi, Patasai tupapi, utupanena mana epene tika-pene tupa sia minape-pene. Yakamana mana tupamane akali utupanena mana tupa sia mina napeaindo, Goteto yakama moyo ando ateakale nembo toto, yakama tane ando konda napulai-kola pulupeya lo nambato yakama langeyo. Tene okonena, wandakali mindimane Gotena loo aŋako wete mindi kalo puato, wandakali waka tupamane wuane teke peakale lo mana lamai-yando, Goteto wandakali okone balana wandakali waka tupana napinga yale ateya lolopeya. Balato wuane lolopeya tekeko, wandakali mindimane Gotena loo utupane wato minuto, wandakali waka tupamane wuane teke peakale lo mana lamai-yando, Goteto wandakali okone bala gene andane mindi mawuato, bala wandakali waka tupana lipinga-yale ateya lolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wuane lalu, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupamane nanimana yumbane tupa mana lamawuato, nimbato wandakali peyo ome nalape leainipia. Wandakali mindimane balana yangone mindi peyo ome leando, bala kote lape-pene leainipia. Yakamato pii okonelapo wamba ale yai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yakamato pii okone ale yai tekeko, andipa nambato pii mindi tako pua loto, wandakali mindimane balana yangone mindi towa yataka yando, bala kote lape-pene leyo. Dee, wandakali mindimane balana yangone mindi ando nimba kee ene ya leando, Juta yamena kanjole okomane balana pii okone lo tika pipe-pene. Wandakali mindimane balana yangone mindi ando lamba loto, pii koo mindi leando, bala yuu koo ita too atapowa atene okona pupe-pene. ");
INSERT INTO ipi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Tene okonena, nimbato minditaka Gote opa mauyale balana alata toko yalane okona mandaka gulo pole-angi, nimbato nembo tolo-peke lape. Nembo tolo-peke lole-kola, wandakali yangone mindimane nimba towa yatakawa ateando, nimbato minditaka opa mauyale awua polene okone ongane yakale lape. Yakale lalu, nimba poto, wandakali yangone okone towa pii ini lo tika puato, liyamba yamapane mindiki paliyapape. Wuane piyu, nimba peke loto, minditaka Gote opa mauyale awua polene okone opa maipe. ");
INSERT INTO ipi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Wandakali mindimane nimba kosimi leando, balato nimba atu poto, pii lo tika piyane jasa okonga malupeya. Jasa okomane nimbana kote ale wato, nimba yanda yene tupanga malua-kola, utupane-mane nimba andi loto, katapusa pua aindaka lolopeyai. Aindaka lolai-kola, nimbato akali okonena yano nimbanga yola tupa pitaka wete yano peya napene konda eendo, nimba katapusa anda okone tepa alu, takita naepolo-pele lo nambato pii enene mindi nimba langeyo. Tene okonena, wandakali mindimane nimba kosimi loyale peando, kenda-pene lalo utupane nimbanga epolane nembo toto, liyamba kote loyale asininga polapi-angi, nimbato akali okone towa wamba ini pii lo tika puato, liyamba yamapane mindiki paliyapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Okone angi, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupamane yakama mana languato, wanda akali-la, liyambato pamuku na-piyapape lalaini leaipia. Yakamato pii okone wamba ale yai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yakamato pii okone ale yaini tekeko, nambato yakama mana languato, akali mindimane wanda mindi andoto, okone towa pamuku piwa lakae lo nembo teando, nembo-mane wanda okone pamuku pula-kola pulupeya leyo. ");
INSERT INTO ipi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wuaneko, nimbato mana koo okonepene mindi minula loto, nimbana lene tika-mane mo piya yando, Goteto nimbana umbaini utumane ata-pata yuu koo wetete okona awua aindaka lola-kola, nimba kopeta wetete atolopele. Nimba lene mindiki tene atole-kola, Goteto nimba yuu koo wetete okona awua aindaka nalene konda yando, katu lolopeya-ko. Nimbana lene tika okonemane nimbato koo mindi pula lo mo piya oyale peando, lene okone luku apiape. ");
INSERT INTO ipi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wuane pua teke, nimbato koo mindi pula loto, nimbana kii tika okomane mo piya yando, Goteto nimbana umbaini utumane ata-pata yuu koo wetete okona awua aindaka lola-kola, nimba kopeta wetete atolopele. Nimba kini mundu atole-kola, Goteto nimba yuu koo wetete okona awua aindaka nalene konda yando, katu lolopeya-ko. Nimbato koo mindi pula loto, nimbana kii tika okomane mo piya oyale peando, nimbana kini tika okone kando lo apiape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Wuane lalu, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupamane yakama mana languato, akali mindimane balana wetene oko peyo wateando, wanda peyo watolane pepa mindi moto maipe-pene lalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Utupane-mane wuane lalaini tekeko, nambato yakama mana languato, akali mindina wetene okomane pamuku napula-kola, akali okonemane bala peyo wateando, akali mambele wanda okonemane akali waka mindi pola oko towa pamuku pula-kola pulupeya leyo. Dee, akali mindimane wanda peyo watene mindi kee leando, akali okonemane wanda okone pake mola-kola pulupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wuane lalu, Jisasato pii mindi tako pua loto, wamba loo tupana mana andene akali tupamane nanimana yumbane tupa mana lamawua ateaini leaipia. Utupane-mane mana lamawua atoto, nimbana weno minuto, nimbato mangene mindi enene wete pukale lo Akali Andane oko lamaindo, nimbato konda naene, pukale lolene pua pipe leainipia. Yakamato pii okone wamba ale yai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Utupane-mane wuane leaini tekeko, yakamana weno minuto, yakamato enene wete leyo oko Goteto andeya, laa na-piyapape lo nambato yakama langeyo. Ati kenga oko Gotena pitulane toko eya-kola, balato pitaka taka bosa lo ando pitiyane-ko. Yakamana pii lolai tupa lo tai laya oyale yakamato ati kenga okona gene oko na-lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yuu oko Gotena kene yata olane toko mindi eya okonena, yakamana pii lolai tupa lo tai laya oyale yakamato yuu okona gene oko laa na-piyapape. Jutusaleme oko kiŋi andane wete okona tano eya okonena, yakamana pii lolai mindi lo tai laya oyale, yakamato Jutusaleme okona gene oko laa na-piyapape. ");
INSERT INTO ipi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dee, nimbana kawa itini tupana mindikipi mindi nimbato mo kama atayawapi, pombo tayawapi, mindi katulo napulu-peleko. Nimbato nimbana pii lole mindi lo tai laya oyale, nimbana weno oko minuto, enene wete leyo oko Goteto andeya nalape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wandakali mindimane bala tanena pii lolane mindi lo tai laya oyale, mangene mindi peando, Sataneto bala minu mandeke pula-kola pulu-peyako. Yakamato wandakali mindina pii okone yano peyoto, atu yalua leaindo, atu yalua angu lalapape. Yakamato jia leaindo, jia angu loto, balana pii okone yano peyalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wuane lalu, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupamane yakama mana languato, wandakali mindimane balana yangone mindina lene peyo lukeando, yakamato paini balana lene peyo luku ape. Dee, wandakali mindimane balana yangone mindina nene peyo longeando, yakamato paini balana nene mindi peyo longape lalaini. Loo tupana mana andene akali tupamane wuane leai-kola, yakamato pii okonelapo wamba ale yai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yakamato pii okone ale yaini tekeko, nambato yakama mana languato, wandakali mindimane nimbanga koo mindi peando, wuane peakale lo ando kondape leyo. Wandakali mindimane nimbana wakenane tikasa-tole kii apene-mane peleando, yangisa-tolepi wetete peleakale loto, nimbana kawane oko mopeke lape. ");
INSERT INTO ipi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wandakali mindimane nimbana singilisa mokale nembo toto, nimba kosimi leando, balato nimbana sakesa okopi wetete meakale lo ando kondape. ");
INSERT INTO ipi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dee, wandakali mindimane pii mindi nimba langeyo nayu languato, nimbato nambana pinju oko awua mandaka ambinga kilomita mindiki angu puu leando, nimbato bala wayumane moyoto, balana pinju okone amonga yale kilomita lapo auwa apeyape. ");
INSERT INTO ipi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wandakali mindimane yano mindi gii lo tee leando, nimbato bala masia mawuato, jia nalape. Wandakali mindimane minditaka mindi gii lo tee leando, okone maipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wuane lalu, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupamane yakama mana languato, nimbana yame tupa towa epelewa yamapane yo ato, nimbana yanda-pene tupa towa embo wete wa atape lalaini leaipa. Yakamato pii okone wamba ale yai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","45","Yakamato pii okone ale yaini tekeko, andipa nambato yakama mana languato, yakamana ayiane ati kenga ateya okomane wandakali tika-penepi, tika napenepi, utupane pitakanga nai oko teakale lalane leyo. Dee, wandakali tika-penepi, tika napenepi, utupane pitakanga balato kingi epeakale lalane. Yakama ayiane okonena andopane tupa atamakale nembo toto, yakama towa yanda-pene wandakali tupa towa epelewa yamapane yo atalapape. Utupane-mane kenda-pene andane tupa yakama giki peaindo, Goteto utupanena mana koo utupane apeakale lo yakamato pote lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wandakali minditupa-mane takisa muni mialaini akali tupa towa epelewa yamapane yo ateyai-kola, takisa muni mialaini akali utupane-mane wandakali utupane towa epelewa yamapane yo atalaini teke. Yakamato wuane teke puato, yakama towa epelewa yamapane yo atalaini wandakali tupa towa angu epelewa yamapane yo ateaindo, yakamato yole epene andoko molo-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dee, Gote lo bilipi nalene wandakali tupamane yakamana yame tupa angu epele wato, utupane towa pii lalawa pua atalaini. Wuane pua teke, yakamato yakamana yame tupa angu epele wato, utupane towa pii lalawa pua ateaindo, yakamato mana epene wete andoko wato minuto, Gote lo bilipi nalene wandakali tupa sia minulu-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yakamana ayiane ati kenga ateya oko bala tika-pene wetete ateya pua, yakamapi tika wetete pua atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","2","Wuane lalu, Jisasato pii mindi tako pua loto, wandakali minditupa-mane mana koo mindi minuto, wandakali waka tupa minakasa wato, wandakali epene tika-pene gulo atalaini leaipia. Wandakali-mane utupanena gene tupa laiyu leakale nembo toto, utupane-mane lotu andakapi, asiningapi, utupanena poto, biakulu mindi peyoto, wandakali tipia tupa moyo minditaka mayaini. Mayai-kola, wandakali waka tupamane utupanena mana okone andoto, utupanena gene tupa laiyu lalaini okone angu utupanena yole yalane lo, nambato pii enene mindi yakama langeyo. Yakamato minakasa alaini wandakali utupanena mana okone wato mina na-piyapape. Jia. Wandakali waka tupamane yakamana mana epene tupa andeakale nembo toto, yakamato mana epene utupane wandakali waka tupana wenonga mineaindo, yakamana ayiane ati kenga ateya okomane yakamana mana epene minulai utupanena yole mindi yakama gii napulu-peyako. Wandakali-mane yakama epene ya lo andeakale nembo toto, yakamana mana epene tupa wandakalina wenonga mina na-piyape. ");
INSERT INTO ipi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Nimbato too pua moyo minditaka maindo, nimbana ayiane okomane nimbana mana epene okone andoto, yole mindi nimba gulupeya-ko. Nimbato wandakali tipia tupa moyo minditaka mindi maule-angi, nimbana mana epene okone too pitane ateakale nembo tape. Wuane nembo toto, nimbana kii tika okomane wandakali tipia tupa moyo minditaka maule okone nimbana kii koya okomane anda napeakale lo too pua moyo maipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wuane lalu, Jisasato pii mindi tako pua loto, minakasa alaini wandakali tupamane pote leyai-angi, wandakali waka tupamane utupane andapiai lakae lo nembo toto, utupane-mane lotu anda tupanapi, asia kembo tupanapi, utupanena atoto, pote lo atalaini leaipia. Wandakali waka tupamane utupanena mana okone andalaini okone angu minakasa alaini wandakali utupanena yole gulo yalane loto, nambato pii enene mindi yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nimbato pote lole-angi, wandakali utupane-mane piyaini pua napipe. Jia. Nimba palilini lumu okona kolandaka loto, asia tuma puato, Ayiane Gote oko ando pote lape. Nimbato too pua pote lole-kola, balato nimbana mana okone andoto, yole mindi nimba gulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wandakali yame waka tupamane pote loto, pii kambua leyama mambele, Goteto ale olopeya nembo toto, pii tene andane napalene kambua lalaini. Yakamato pote lolai-angi, wandakali utupane-mane piyaini pua na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yakamato minditaka gii lo tee nalolai-kola teke, yakamana ayiane Goteto yakamanga minditaka jia eya tupa wamba ini nembo talane-ko. Yakamato wandakali yame waka tupana mana tupa wato mina na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yakamato pote lolai-angi, wua lalapape: Nanimana ayiane ati kenga atene oko, nimbana gene oko tika pua yakale. ");
INSERT INTO ipi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nimbato nanima moyo ando atape. Ati kenga ateyai tupamane nimbato nembo tele pua piyaini. Wuane pua teke, yuu okona wandakali-mane piyapa lape. ");
INSERT INTO ipi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nanima tomo andipa namakale gipe. ");
INSERT INTO ipi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nanimato wandakali wakana koo tupa apialamane pua teke, nimbato nanimana koo piyamane tupa apia-gipe. ");
INSERT INTO ipi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Koo tupamane nanima minu makande pulu epolaini. Nimbato ando atape. Koo tupamane nanima minu koyoyale peaindo, nimbato nanima moyape. Yakamato wuane loto, pote lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wandakali-mane yakamanga koo pulai-kola, yakamato utupanena koo tupa apia-maiyaindo, yakamana ayiane okomane yakamana koo pulaini tupa apia-gulupeya teke. ");
INSERT INTO ipi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Balato wuane pulupeya tekeko, yakamato wandakali waka tupana koo pulaini tupa apia-mai napeaindo, yakamana ayiane ati kenga ateya okomane yakamana koo pulaini tupa apia-gii napulu-peyako. Yakamato wandakali waka tupana koo tupa apia-maiyapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wuane lalu, Jisasato pii mindi tako pua loto, minakasa alaini wandakali tupamane pote kambua lamakale nembo toto, ole ukupini mindilapo tomo nanene konda olai-angi, tomo nanene ateyai lo wandakali waka tupamane andeakale nembo toto, utupane-mane wenonga yo epoko piyaini leaipia. Wandakali waka tupamane utupanena mana okone andalaini okone angu utupanena yole gulo yalane lo nambato pii enene mindi yakama langeyo. Utupane-mane wuane piyaini tekeko, yakamato pote kambua lamakale nembo toto, ole ukupini mindilapo tomo nanene kondolai-angi, wandakali utupane-mane piyaini pua na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Nimbato pote kambua lokale nembo toto, oto ukupini mindi tomo nanene kondalu atole-angi, nimbato wuane pule oko wandakali waka tupamane anda napeakale nembo toto, nimbana lee-inga wasa-wasa peyalu, nimbana kawa itininga wele epene mindi gae lo aiya wato, mo kuai laya ape. Ole ukupini mindilapo nimbato pote kambua lokale nembo toto, tomo nanene kondalu atole-angi, wandakali-mane anda na-piyaini ayiane okomane angu nimbana mana okone andoto, yole mindi nimba gulupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","21","Wuane lalu, Jisasato pii mindi tako pua loto, yakamato yuu okona tawe minditaka epene tupa mo yomowa ateaindo, puya-puya tupamane minditupa nalu, minditupa ipakula tolopeya leaipia. Pake mialane akali tupamane yakamana anda tupa keao loto, minditupa pake molopeyai tekeko, yakamato ati kenga tawe minditaka epene tupa mo yomowa ateaindo, mindimane pake mia napulu-peyai. Puyapuya-mane nanolo-peyai. Ipakula taa napulu-peyako. Yakamato yuu okona tawe minditaka epene tupa mo yomowa ata na-piyapape. Jia. Yakamato ati kenga tawe minditaka epene tupa mo yomowa atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Wuane lalu, Jisasato pii mindi tako pua loto, lene oko umbaini pitakana lamu gulene. Lamu mindimane kuai lo tii peando, minditaka yola tupa nimbato kuai lo andolopele. Wuane pua teke, nimbana lene kuai lo teando, nimbato pitaka taka kuai lo andolopele. ");
INSERT INTO ipi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wuane tekeko, nimba lee koo ateendo, nimbana umbaini utumane undupi pangosa wete atene gulo atolopele. Goteto tii-pene oko nimba gula-kola, nimbato anda napeendo, nimba undupi-lene andane wete okona atolopele. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wuane lalu, Jisasato pii mindi tako pua loto, wandakali mindimane akali andane lapona piape pimawua ateando, balato akali andane mindi epelewa yamapane yoto, balana piape kuai lo pimaulu-peya leaipia. Akali okonena piape kuai lo pimawuato, akali andane mindoko koo ya lo embo wete wato, masia malu-peyako. Mindimane akali andane lapona piape akali ata napepe-pene. Tene okonena, yakamato Gote-la, muni-la, okonelapo lapotakana piape akali guleaindo, mana okone kuai nalolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","27","Yakamato eka tupa andalapape. Eka utupane-mane ee mindi na-piyaini. Dee, utupane-mane tomo minditupa matili namakale loto, mandu epoto, yakamana anda tupana yata aa na-piyaini tekeko, yakamana ayiane ati kenga ateya okomane utupane tomo neakale maiyane. Wandakali yakamato eka tupa sia minu, utupanena lipinga yale ateyai. Goteto yakamana umbaini oko waa puato, yakama saka ataya yaepia. Piape pitete-pene okone wamba ini puato, andipa balato pitete wato, tomopi, tonapi yakama gii napene kondolo-peyape. Jia. Goteto mali ana atola lo giyane tupa atalu, wandakali mindi bala tanena tai-lene okomane ana mindikipi mindi katulo kimbu pua ata napulu-peyako. Yakamato umbaininga tona pulane tupapi, tomo ipa nolane tupapi, utupane ani tawe mia-makalepe lo nembo kambua tatawa atolaini. ");
INSERT INTO ipi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Anu peakale yakamato tona ani tawe mia-makalepe lo nembo kambua teyaipe. Yakamato palawa dini epene yati-pene siapusa liya tupa nembo talapape. Utupane yakama tane piape pii, yati pii, mindi na-piyaini. Jia. Goteto utupane kuai lo wete yati piya maiyane. ");
INSERT INTO ipi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Utupane mee lialaini tekeko, palawa dini utupanena yati epene wetete okomane kiŋi Solomone balana tona yati-pene epene wete wamba pua ateane tupa sia miniya lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Palawa dini utupane angini mindi jia. Palawa dini utupane andipa angu epene lialaini. Anate-lene wandakali-mane palawa utupane yokowa apoto, yangalaini. Goteto palawa dini utupanena yati wayumane piya maiyu, wandakali yakamana yati tona tupa gii napene kondolo-peyape. Jia. Goteto yakamana tona gii napene kondolo-peya nembo teaindo, yakamato balanga wayumane tungi peyo bilipi lo ata napulai-kola pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Gotena pii ale naene aitene wandakali tupamane tomo ipa nolane tupapi, umbaininga pulane tona tupapi, utupane ani tawe mia-makalepe lo nembo kambua too atalaini. Utupane-mane wuane nemboto atalaini tekeko, Gotena wandakali yakamato okonetaka pitaka miape-pene lo yakamana ayiane ati kenga ateya okomane nembo teya-ko. Yakamato tomo ipa nolane tupapi, tona pulane tupapi, utupane ani tawe mia-makalepe lo nembo kambua tatawa ata na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wuane nembo natene, Goteto yakama moyo ando ateakale nembo toto, balana mana tika-pene tupa wato minuyale mandeke pua atalapape. Yakamato wuane pua ateaindo, balato yakamana tomo ipa nolane tupapi, tona pulane tupapi, utupane pitaka yakama gulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ole dindi lo kenda-pene waka-waka tupa epalane tekeko, kenda-pene anati epolopeya tupa anati teke nembo tapa-peneko. Anati kenda-pene mindi epolane nembo toto, andipa yakamato nembo kambua tatawa ata na-piyapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Wuane lalu, Jisasato pii mindi tako pua loto, yakamato wandakali yangone tupanga mana minulai pua, Goteto mana okone teke yakamanga minulu-peya leaipia. Yakamato wandakali waka tupa koo ya lo yapa leaindo, Goteto yakamapi koo ya lo yapa lolopeya-ko. Goteto yakama koo ya lo yapa lolane. Yakamato wandakali waka tupa koo ya lo yapa na-lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nimba amene mindina lenenga lee kunu aŋako mindi eya-kola, nimbato okone andoto, mo apokale lalene tekeko, nimba tanena lenenga ita palaŋa andane mindi eya-kola, nimbato okone mo apokale nembo natalene. Anu peakale nimbato wuane pilinipe. ");
INSERT INTO ipi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nimba tanena lenenga ita palaŋa andane mindi eya-kola, nimbato kuai lo anda napilini-ko. Anu peakale nimbato amene okone lamawuato, nimbana lenenga lee kunu eya oko nambato mo apia-gua lalenepe. ");
INSERT INTO ipi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wandakali yangone tupamane nimbana pii okone ale wato, nimbanga koo mindi naeya nembo teakale nayuto, nimbato wuane lalene-ko. Nimba tanena lenenga ita palaŋa andane mindi eya oko nimba tane wamba ini mo apiape. Apialu, nimbana lene epene toto, nimba amene okona lee kunu yola oko katulo mo apolopele. Jisasa wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yakamato mamaku epene wete tupa yia kapua tupa ateyainga peyamo leaindo, utupane-mane minditaka epene wete utupane mee kee-mane ango mangua alu, mopeke loto, yakama nolopeyai-ko. Yakamato wuane na-piyapape. Dee, yakamato Gotena minditaka epene wete tupa piango anatope gulene wandakali tupa mai na-piyapape. ");
INSERT INTO ipi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Wuane lalu, Jisasato pii mindi tako pua loto, wua leaipia: Wandakali-mane pote loto, Gote nimbato mangene mindi pipe leyai-kola, Goteto mangene okone piyane. Yakamato pote loto, Gote nimbato mangene mindi pipe leaindo, Goteto mangene okone pulupeya-ko. Gote nimbato mangene mindi pipe lo pote lalapape. Minditaka ayia pua atalaini wandakali tupa pitaka-mane minditaka ando mialaini. Yakamato aiya pua ateaindo, yakamato minditaka ando molopeyai-ko. Yakamato minditaka ayia pua atalapape. Wandakali-mane anda asia lomba peya geao-geao lo atalaini tupa pitakana asia Goteto lumba maiyane. Yakamato asia lomba peya geao-geao lo ateaindo, Goteto asia lumbulu-peyako. Yakamato asia lomba peya geao-geao lo atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Akali mindina iwanane okomane balana ayiane oko tee loto, ulia nokale gii leando, balana ayiane okonemane ana mindi malupeyape. ");
INSERT INTO ipi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Dee, iwanane okonemane pisa mindi nokale gii leando, balana ayiane okomane etelu koo nanimato naa na-piyamane mindi malupeyape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yuu okona ateyai Ayiane koo tupa yakamato minditaka epene tupa yakamana andopane tupanga mayaini. Wuane pua teke, yakamana minditupa-mane ayiane ati kenga ateya oko tee loto, minditaka epene tupa nanima gii leaindo, balato yuu okona ayiane ateyai tupa sia minuto, minditaka epene utupane yakama gulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yakamana yangone tupamane yakama moyoyale, mana epene minditupa mineakale nembo teaindo, yakamato wandakali yangone utupane moyoyale, mana epene utupane pitaka minalapape. Gotena loo tupapi, potopesa akali tupana pii pepa pelene eya tupapi, utupane pitaka-mane pii mindiki okone teke langiyaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Wuane lalu, Jisasato pii mindi tako pua loto, yuu koo okona polane asini oko andane wete eya leaipia. Yuu koo okonena kolandaka lolane geta okopi andane teke eya. Okonelapo andane eya-kola, wandakali kambua-mane polane asini andane okone watama poto, kolandaka lolane geta andane okonena poto, koyalaini. Wandakali saka atapowa atolane yuu okona polane asini oko aŋako eya. Gotena yuu epene okonena kolandaka lolane geta okopi aŋako teke eya. Aŋako eya-kola, wandakali aŋalapo minditupa-mane angu polane asini aŋako okone andalaini. Yakamato saka atapowa atene yuu okona polane asini aŋako okone watama poto, yuu okonena kolandaka lolane geta aŋako okona pulupape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","20","Wuane lalu, Jisasato wandakali tupa tipa puato, eyaka ikilimbu ani atene mindina butusa dini epene tupa lialaepe leaipia. Pee, taweyame itane mindina apate dini epene tupa lialaepe. Jia. Ita koo mindina dini epene mindi katulo lia napene, dini koo teke lialane. Dini epene lia napiyane ita tupa pitaka wandakali-mane yoko wato yangalaini. Dee, ita epene mindinga dini koo mindi katulo lia napiyane. Jia. Ita epene mindinga dini epene teke lialane. Tene okonena, yakamato ita tupana dini tupa andoto, ita mindi epene ya, ita mindoko koo ya loto, ita tupa katulo yapa lo tale piyaini. Wuane pua teke, potopesa akali tupana mana minulai tupa andoto, yakamato akali mindi bala potopesa akali enene mindi ya, akali mindoko bala owato potopesa akali mindi ya lo potopesa akali tupa katulo yapa lo tale pulupeyai. Owato potopesa akali tupamane yakama minakasa oyale, yia sipisipi gulene epolopeyai tekeko, utupanena yamapane anda-pangosa peango anatope gulo epolopeyai. Akali utupane-mane yakama minu koyolaini. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","22","Wandakali yapa lo tale pulane oto oko epola-angi, wandakali kambua-mane namba languato, Akali Andane, Akali Andane, nanimato nimbana gene oko loto, potopesa akali atoto, piape pua atema. Nanimato nimbana gene oko loto, wandakali tupanga yama koo atene tupa peyo watoto, metekolo piape tai-lene kambua tupa pemane lolopeyai. Wandakali kambua-mane wuane lolopeyai tekeko, wandakali utupanena minditupa Gotena yuu epene okona napolo-peyai. Jia. Nambana ayiane ati kenga ateya okona nembo-tene oko wato minalaini wandakali tupa angu balana yuu epene okona polopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ayiane ati kenga ateya okona nembo-tene oko wato mina na-piyaini wandakali minditupa-mane Akali Andane, Akali Andane lolopeyai tekeko, nambato utupane panakame lamawuato, Gotena loo angowa atalaini wandakali yakama nambato anda na-peyawaneko. Yakama namba tepa alu, pulupa lokale. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Wuane lalu, Jisasato pii mindi tako pua loto, wamba akali wai-ene mindimane balana anda oko yuu tai ana tokonga peane leaipia. Matili popo taimane lea-kola, kingi andane epeaipia. Epea-kola, ipa lii andane mindi lua awua epoto, anda okone peyo keao loyale peane tekeko, anda okone yuu tai ana tokonga pitane ateane okomane tai duli lo atea-kola, peyo keao naleaipia. Wandakali mindimane nambana pii oko ale wato, wato minu ateando, bala akali wai-ene wamba ateane okonepene teke atolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Wuane tekeko, wamba akali wai naene kuati minene mindimane balana anda oko yuu kayiki ipa mau mindinga peaipia. Matili, popo taimane lea-kola, kingi andane epeane okomane ipa lii andane mindi lua awua epeaipia. Epoto, anda okone taimane pelea-kola, anda okone lai loto, yuunga kapoyale tepa yaepia. Wandakali mindimane nambana pii oko ale wato, tailo wato minu ata napeando, bala akali wai naene wamba ateane okonepene teke atolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Loo tupana mana andene akali tupamane mana lamai-yaini pua, Jisasato mana lamai napeaipia. Jia. Mana lamaulane tai-lene tupa balanga ya-kola, balato utupane sia minuto, pii manapi utupane lamai-yaepia. Tene okonena, balato pii utupane pitaka lo koyo pea-angi, wandakali kambua peteaini tupamane mana balato lamaiyane utupane nembo toto, moko andane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisasa bala yuu wangiane okone tepa alu, puu nena lea-angi, wandakali kambua-mane bala watama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Watama peai-kola, akali tapa-pene mindi bala Jisasa ateane ongane mandaka epoto, aikini leka wato, Akali Andane, nimbato namba mo atu yokale nembo teendo, nimbato katulo wuane pulupele leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wuane lea-kola, Jisasato balana kini oko akali okonenga yata wato, nambato wuane pukale. Nimba atu yaa lea-kola, okone angi teke akali okonena tapa peane oko atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Atu ya-kola, Jisasato akali okone lamawuato, nambato nimba mo atu eyo oko nimbato wandakali mindikipi mindi lamaulene andape leaipia. Nimba Gotena pitisa piape piyane akali oko ateyanga poto, nimbana umbaini oko balanga andawa lape. Andawa lalu, Goteto nimbana tapa tupa mo atu yala lo wandakali tupamane andeakalenga, Mosesato opa maipe leane pua nimbato maipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisasa bala Kapaneame tano okona peakaiyu lea-angi, Lomo tane ami yanda yene andete mindiki ando atalane opisa mindimane epoto, pii mindi bala lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Balato pii okone bala lamawuato, Akali Andane, nambana piape akali oko bala kusuku pituto, tandaka andane wete no andaka peteane oko mee peteya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wuane lea-kola, Jisasato namba epoto, bala mo atu yokale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Wuane lea-kola, ami opisa okonemane balana pii okone yano peyoto, namba akali epene mindi jia leaipa. Nimba akali epene oko nambana andaka epeendo, mana okone katu nalolo-peya. Akali mindimane namba ando atalane pua teke, nambatopi ami yanda yene minditupa ando atalawane. Nambato ami yanda yene mindi peakale leyo-kola, bala palane. Nambato ami yanda yene mindi epeakale leyo-kola, bala epalane. Nambato nambana piape akali oko lamawuato, nimbato piape oko pii leyo-kola, balato piape okone piyane. Wuane pua teke, nimbato mee nambana piape akali oko atu yakale lole-kola, bala atu yolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wuane lea-kola, Jisasato moko loto, wandakali bala watama epeaini tupa lamawuato, nambato pii enene mindi yakama langeyo leaipia. Ami opisa oko bala Isatale tane mindi jia tekeko, balato nambanga tungi peyoto, bilipi leya pua, Isatale tane wandakali mindikipi mindimane nambanga tungi peyoto, bilipi leyainga nambato anda napewane. ");
INSERT INTO ipi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Matili Goteto wandakali pitaka yapa lo tale pula-angi, nai epalanesa tanepi, nai andaka palanesa tanepi, wandakali yame waka kambua epoto, Gotena yuu epene ati kenga eya okona poto, Apatakamepi, Aisakepi, Jekopopi, utupane towa atu tomo kambua no pitulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Utupane-mane wuane pulupeyai tekeko, Isatale tane minditupa ati kenga yuu epene okona polo-peyama nemboto atolai-kola teke, Goteto utupane yuu koo undupi-lene okona pulupa loto, wata nena lolopeya. Wata nena lola-kola, wandakali utupane yuu koo okonena atoto, yamataka lo nene geleto laka pua atolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wuane lalu, Jisasato ami opisa oko lamawuato, nimbato nambanga tungi peyoto, bilipi lele pua, nimbana piape akali oko atu yolopeya-ko. Nimba andaka puu leaipia. Wuane lea-kola, okone angi teke ami opisa okonena piape akali oko atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisasa bala Pita andaka kolandaka loto andea-kola, Pitana wanda imane oko siki omoto, umbaini toto andane pea-kola, tokonga palu yanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Andoto, Jisasato wanda okonena kininga minea-kola, balana umbaini toto andane peane okone atu yaepia. Atu ya-kola, wanda okone ika loto, Jisasana tomo yanga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","17","Matili, nai andaka pea-kola, wandakali minditupa-mane sipitisa koo atene wandakali yangone kambua Jisasa ateanga atu aiyu epeainipia. Wamba potopesa akali Aisayato pii mindi pepa peyoto, nanima siki omoto, tandaka no atema-kola, balato nanimana siki mindipene-mindipene tupa mo atu yane leaipia. Gotena pii layene okone enene guleakale nembo toto, Jisasato wandakali utupanena sipitisa koo ateaini tupa peakale lo peyo wataka piyu, wandakali siki pelene tupa pitaka mo atu yaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wandakali kambua-mane Jisasa bala ato mapu peainga andoto, balato balana disaipolo tupa lamawuato, nanima ipa angini okona amo yangi maa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wuane lea-kola, loo tupana mana andene akali mindimane Jisasa ateanga epoto, tisa, namba nimbana disaipolo atoto, yuu nimba pole tupa pitakana namba atu bakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bakale lea-kola, Jisasato bala lamawuato, peango anatope tupana pangulane yuli tomba-yene yalane. Dee, eka tupana paliyaini anda atalane tekeko, Akalina Iwanane oko oto mo kawane yata olane kawa kanda mindi nayalane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wuane lea-kola, Jisasa watama epoko pua atalane akali waka mindimane bala lamawuato, Akali Andane, namba wamba ini poto, nambana ayiane oko mali pukale. Mali piyu, matili namba nimbana disaipolo atoto, yuu nimba pole tupa pitakana atu pepando, okone katu lolo-peyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wuane lea-kola, Jisasato bala lamawuato, omene gulo atalaini wandakali tupamane yakamana yangone omene tupa mali peakale lo ando kondalu, nimbato namba watama ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wuane lalu, Jisasa bala sipi mindina peakaiyu lea-kola, balana disaipolo tupa bala towa atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ipa angini okona tombenenga peai-kola, popo andane wete mindi lo awua epeane okomane ipa andane wete mindi taimane ika leaipia. Ipa ika leane okonemane sipi oko ango mangua yane tekeko, Jisasa bala sipi okonena limu paleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Limu palu ya-kola, balana disaipolo tupamane bala peya ika loto, Akali Andane, nanima omoyale peyama-ko. Nimbato nanima molo-peke laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wuane leai-kola, balato utupane tipa puato, anu peakale yakamato Gote lo bilipi leyama nayu nalene, yukuwa ateyaipe leaipia. Wuane lalu, bala ika loto, popo andane leane okola, ipa taimane ika leane okola, lapotaka laiya loto, tepa alapa lea-kola, popo andane leane oko tepa yaepia. Tepa ya-kola, ipa taimane ika leane okopi tepa alu, ema aŋakopi mindi napeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wuane pea-kola, sipi okona peteaini akali tupamane nembo kambua toto, pii mindi leaini oko loto, Jisasato popo andane lala okola, ipa taimane ika lala okola, okonelapo laiya loto, tepa alapa leya-kola, lapotaka-mane balana pii ale eyapi-ko. Bala akali anu-pene mindi ya andeyamape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisasa bala ipa angini Galili okona amo yangi poto, Gatata yamena yuu okona peakaiyu leaipia. Sipitisa koo atene akali lapo yuu okonena atoto, wandakali omene tupa mali pitane ateaini ongane mandaka atalapele-pia. Ole dindi lo akali okonelapo-mane wandakali tupa taimane peyoyale peyapi-kola, wandakali tupa katulo ongane mandaka gulo na-palainipia. Jisasa bala Gatata yuu okonena peakaiyu lea-kola, akali okonelapo-mane wandakali mali tupana atalu epoto, bala malanda yapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jisasa malanda wato, akali okonelapo-mane pii taimane loto, Gote Iwanane nimbato nalipanga aki pulape. Nimbato tandaka andane nalipanga gulane oto oko naepeya-kola teke, nimbato nalipa tandaka andane gulu epelepe leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Amonga-yale yia yomo andane mindi tani no ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ateai-kola, sipitisa koo utupane-mane pii taimane loto, Jisasa nimbato nanima akali okolapo tepa alu pulupa lo peyo wateendo, nanima yia ateyai utupana ini anda-pangosa kolandaka lalapa lape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wuane leai-kola, Jisasato yakama pulupa leaipia. Pulupa lea-kola, sipitisa koo utupane-mane akali okonelapo tepa alu poto, yia utupanena ini pangosa kolandaka leainipia. Kolandaka leai-kola, yia utupane pitaka yuu wangiane mindina atoto, taimane puu nena loto, ipa angini mindi peteane okona peakoto, ipa nalu, omeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Omeai-kola, yia yatawa atalaini akali tupamane okone andoto, tano okona taimane peainipia. Poto, utupane-mane wandakali tupa lamawuato, Jisasato sipitisa koo atene akali okone-lapona sipitisa koo ateaini tupa peyo wateane okopi, mangene waka peane tupapi, utupane pitaka wua piya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wuane leai-kola, tano okonena tane wandakali tupa pitaka-mane Jisasa malanda olo epoto, bala andeaini-pia. Andoto, utupane-mane bala taimane lamawuato, nimba nanimana yuu oko tepa alu puu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wandakali tupamane Jisasa nimba puu leai-kola, bala sipi mindina peakaiyu lo pitiyu, ipa angini okona amo maita bala atalane Kapaneame tano okona peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Peke lea wete, akali minditupa-mane akali kusuku mindi takeanga awua Jisasa ateanga epeainipia. Jisasato andea-kola, akali utupane-mane bilipi loto, akali okone awua epeyai lo andoto, balato akali okone lamawuato, iwana, nambato nimbana koo pilini tupa apeyo-ko. Nimba mini epene pali leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisasato wuane lea-kola, loo tupana mana andene akali ongane ateaini tupana minditupa-mane yakama tane teke-teke pii lalawa puato, Goteto angu wandakali tupana koo tupa apialane-ko. Jisasato akali kusuku oko lamawuato, nimbana koo tupa apeyo leya okomane Gote ando lamba leya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wuane leai-kola, Jisasato utupane tipa puato, anu peakale yakamato nembo koo palu ateyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nambato akali kusuku oko lamawuato, nimbana koo tupa apeyo leyo oko piape pitete-pene mindi jia. Nambato bala lamawuato, nimba ika lalu, andaka puu loto, balana siki oko mo atu yewando, piape okone pitete-pene yolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wuane tekeko, Goteto yuunga wandakalina koo tupa apolane tai-lene oko Akalina Iwanane nambanga geane oko yakamato andalapale nembo teyo leaipia. Wuane lalu, balato akali kusuku okone lamawuato, nimba ika lalu, nimbana takea toko mo awua andaka puu, leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wuane lea-kola, akali okone bala ika lalu, andaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jisasato akali kusuku okone mo atu yane oko andoto, wandakali kambua ateaini tupamane moko andane wete leainipia. Moko loto, mo atu yolane tai-lene okonepene tupa Goteto yuu okona akali mindinga mayae-ya nembo toto, utupane-mane Gotena gene oko laiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisasa poto andea-kola, akali Matiyu lene mindi takisa muni mialaini anda mindina peteanga andoto, namba watama ipu lea. Wuane lea-kola, Matiyu ika lalu, Jisasa watama pea. ");
INSERT INTO ipi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisasapi, balana disaipolo tupapi, utupane Matiyu towa atu balana andaka peai-kola, takisa muni mialaini akalipi, koo piyaini wandakalipi, wandakali okonepene kambua epoto, utupane towa atu tomo no peteai. ");
INSERT INTO ipi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jisasato utupane towa atu tomo no peteai-kola, Patasai tupamane andoto, Jisasana disaipolo tupa tipa puato, anu peakale yakamana tisa oko bala takisa muni mialaini akalipi, koo piyaini wandakalipi, utupane towa atu tomo no peteyaipe leai. ");
INSERT INTO ipi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, dokosa-mane wandakali siki napalene tupa mo atu yolane tene mindi ata napeya lea. Dokosa-mane wandakali siki pelene tupa angu mo atu yalaini. ");
INSERT INTO ipi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wuane pua teke, namba epewane oko wandakali epene tika-pene tupa ee lo molo na-epewane. Jia. Koo piyaini wandakali tupa ee lo molo namba epewane. Gotena pii pepa pelene eya mindimane loto, wandakali-mane mee opa angu namba giyaini mana oko nambato epele aa na-piyawane. Jia. Wandakali-mane yakamana yangone tupa ondo wato moyalaini mana oko nambato epele alawane layene eya. Pii okonena tene oko andoko paleyape lo yakamato mana molo pulupa. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Okone angi, Jonena disaipolo tupa Jisasa ateanga epoto, alu minditupa Patasai tupamane pote kambua loyale, ole ukupini mindilapo tomo nanene atalaini leai. Nanimatopi wuane teke piyamane-ko. Anu peakale nimbana disaipolo tupamane wuane na-piyainipe leai. ");
INSERT INTO ipi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wuane leai-kola, Jisasato utupane tipa puato, akali mindimane wanda mindi kee loto, balana amene tupa towa atu ateyai-kola, balana amene utupane-mane mini kenda alainipe lea. Jia. Okone angi utupane-mane mini kenda aa na-piyaini tekeko, matili akali minditupa-mane bala andi lo awua polai-angi, balana amene tupamane pote kambua loyale, ole ukupini mindilapo tomo nanene atolopeyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wandakali mindimane lapa-lapa palai-lene wenene mindi moto, tona wambane asia titi yene mindina ataenge lo tambu leando, balato tona okone wasa-wasa peyola-angi, lapa-lapa palai-lene wenene oko kingi tupi loto, tona wambane okone lapone lete laya ola-kola, asia titi wamba yane okone andane gulolo-peya. Wuane pulane nembo toto, wandakali mindikipi mindimane wuane napiyane. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dee, wandakali-mane ipa waene wenene tupa ipa pene wambane meme umbaini-mane waa-pene tupana ambu pete leaindo, ipa waene wenene okonena popone-mane anda yoto, pene wambane utupane tula lolai-kola, ipa waene oko alu pulupeya. Wuane pulane nembo toto, wandakali mindikipi mindimane wuane napiyane. Jia. Wandakali-mane ipa waene wenene tupa pene wenene tupana ambu pete leyai-kola, ipa waene tupapi, ipa pene tupapi, utupane pitaka kuai lo yalane. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisasato pii utupane Jonena disaipolo tupa lamawua atea-kola, Juta yamena lotu anda ando atalane akali Jaitusa lene oko epea. Epoto, bala Jisasa ateanga aiki leka wato, nambana wanane oko epapu omala tekeko, nimba epoto, balanga kini yata eendo, bala dee lapone saka atolo-peke lolopeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wuane lea-kola, Jisasa ika lalu, akali okone towa atu peapi-kola, Jisasana disaipolo tupapi atu peai. ");
INSERT INTO ipi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Okone angi, mali alesa pitakana ole dindi lo kii kalo teke pitiyane wanda mindi tano okonena peteaipia. Wanda okonemane Jisasa epo peanga andoto, nambato balana tonanga wata ewando, nambana siki oko koyo pulupeya nembo toto, Jisasana masianesa epoto, balana tona okona duninga wata ya. ");
INSERT INTO ipi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wata ya-kola, Jisasa bala mopeke loto, wanda okone andoto, wana nimbato namba lo bilipi lele mambele, nambato nimbana siki oko mo atu eyo-ko. Nimba mini epene palu puu lea. Wuane lea-kola, okone angi teke wanda okone atu ya. ");
INSERT INTO ipi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Atu ya-kola, Jisasa bala Jaitusa okona andaka poto, anda-pango kolandaka loto andea-kola, akali minditupa-mane wana omene oko mali puyale pupe tupa lo ateai-kola, wandakali waka tupamane ai lo yaya peyo yamataka lo ateai. ");
INSERT INTO ipi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wuane pua ateai-kola, Jisasato utupane lamawuato, wana oko oma napene, mee limu paleya-ko. Yakama pulupa lea. Wuane lea-kola, balato kopeta leya nayuto, wandakali utupane-mane bala andayo giwa yai. ");
INSERT INTO ipi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Giwa yai-kola, balato utupane pitaka kamaka peakale lo peyo watalu, wana omene yane lumu okona kolandaka loto, balana kininga minia-kola, wana omene yane oko saka pitulu-peke lalu, ika leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jisasato wana okone saka pitulu-peke laya ya-kola, wuane piya lo wandakali tupamane pii temane okone yuu ukusane yene tupa pitakana lo tawe yainipia. ");
INSERT INTO ipi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisasa bala yuu okone tepa alu pea-angi, lee koo lapo akali-mane bala watama epoto, Dapiti yame akali nimbato nalipa ondo aa lo pii taimane leapi. ");
INSERT INTO ipi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisasa bala andaka kolandaka lea-angi, akali lee koo okonelapo bala ateanga epeapi-kola, balato okonelapo tipa puato, nambato katulo liyambana lene mo tee laya olopeya lo liyambato bilipi leyapipe lea. Wuane lea-kola, okonelapo-mane balana pii okone yano peyoto, enene, Akali Andane, nimbato katulo wuane pulupele lo nalipato bilipi leyapa leapi. ");
INSERT INTO ipi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wuane leapi-kola, Jisasato balana kini oko akali okone-lapona lenenga yata wato, nambato katulo liyambana lene oko mo tee laya olopeya lo liyambato bilipi leyapi pua teke, nambato liyambana lene oko mo tee laya eyo lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wuane lea wete, akali okone-lapona lene teapi-kola, Jisasato akali okonelapo pii lamaiyo nayu lamawuato, nambato liyambana lee mo tee laya eyo oko liyambato wandakali mindikipi mindi lamaulapele lea. ");
INSERT INTO ipi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jisasato wuane leane tekeko, akali okonelapo liyamba poto, Jisasato liyambana lee mo tee laya apiane lo pii temane okone yuu ukusane yene tupa pitakana lo tawe yapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Akali okonelapo Jisasa tepa alu, peapi-angi, wandakali minditupa-mane yangone mindi atu aiyu Jisasa ateanga epeai. Sipitisa koo mindi akali okonenga atea-kola, balato katulo pii na-lalaepia. ");
INSERT INTO ipi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisasato akali okonenga sipitisa koo ateane okone peyo watea-kola, akali okonemane pii lea. Pii lea-kola, wandakali amunguli pua ateaini tupamane moko wete loto, nanima Isatale tane tupamane andema-kola, alu mindikipi mindi akali mindimane pii na-lalane akali mindi pii laya yanga anda napema leai. ");
INSERT INTO ipi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wandakali utupane-mane wuane leaini tekeko, akali Patasai tupamane loto, sipitisa koo yame ando atalane sipitisa kawane Belesa-pulu balato Jisasa minu tai laya eya-kola, Jisasato sipitisa koo tupa katulo peyo wata alane leai. ");
INSERT INTO ipi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Okone angi, Jisasa bala tano andanepi, aŋakopi, utupane pitakana epoko puato, Juta yamena lotu anda tupana poto, Gotena pii layene epene oko wandakali tupa mana lamawuato, Goteto wandakali tupa moyo ando atalane lea. Wuane loto, balato wandakali siki pelene tupa pitaka mo atu yaka pea. ");
INSERT INTO ipi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Okone angi, balato andea-kola, wandakali kambua ateaini tupa yakama sipisipi yatawa atalane akali mindi ata napene manyani gulo atoto, anu pimape lo tatake aka pua ateaininga andoto, balato utupane ondo ya. ");
INSERT INTO ipi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ondo wato, balato balana disaipolo tupa lamawuato, eenga tomo kambua mandipe-pene eya tekeko, tomo mandulane wandakali aŋalapo angu ateyai-ko. ");
INSERT INTO ipi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ee anduane okomane bala eenga tomo mandulane wandakali minditupa mo tako peakalenga, yakamato bala lo pote lalapape lea. ");
INSERT INTO ipi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","4","Aposolo akali bulupane oko Saimone balana gene mindi Pita lene oko. Balana amene Endutupi, Sepiti iwanane Jemesapi, balana amene Jonepi, utupane aposolo akali ateaini teke. Dee, Pilipipi, Batolo-miyupi, Tomasapi, Tatiyusapi, takisa muni mialane akali Matiyu okopi, Alipusa iwanane Jemesapi, Selote yamena akali Saimone okopi, Jutasa gene mindi Isaka-tiyote lene matili Jisasa ene peteane okopi, akali alesa utupane pitaka aposolo akali ateai. Jisasato utupane bala ateane ongane mandaka ipulupa loto, yakamato sipitisa koo tupa peyo watoto, wandakali tupana siki mindipene-mindipene tupa pitaka mo atu yaka pua atalapape lea. Wuane loto, balato piape okonelapo pulane tai-lene oko akali utupanenga maya. ");
INSERT INTO ipi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Jisasato akali alesa utupane piape pulu pulupa loto, yakamato Samatiya tane wandakali tupana tano mindi yandopi, wandakali yame waka tupana yuu mindi yandopi, utupanena puu napene kondalapape. Yakamato Isatale tane wandakali sipisipi alu pene gulo ateyai tupanga angu pulupa lea. ");
INSERT INTO ipi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","10","Wandakali mindimane wandakali waka mindina piape pimai-yando, piape anduane okomane bala yole maipe-peneko. Yakamato muni yandopi, ane pausa mindi yandopi, nuu mindi yandopi, singilisa lapo yandopi, sukee lapone yandopi, utupanena mindi mandi napene, kalango mindi ai napene, mee pulupape. Yakamato Isatale tane wandakali tupa ateyainga poto, Gote ati kenga ateya okomane pitaka taka ando atolane gii oko wamba mandaka guleya lo lamai-yapape. Lamaiyu, yakamato wandakali siki pelene tupa mo atu yalu, wandakali omene tupa ika laya alu, wandakali tapa-pene tupa mo atu yalu, sipitisa koo tupa peyo watalu, piyapape. Yakamato piape utupane piyapale loto, nambato tai-lene yakamanga geyo okonena yole mindi yakamato namba giyapa naleyo. Wuane pua teke, yakamato wandakali tupa moyo piape utupane pulai-angi, yakamato yole mindi giyapa nalene, utupane mee moyo piape utupane pua atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","13","Yakama tano mindina polai-angi, wandakali epene tika-pene mindi aiya piyapape. Wandakali mindimane yakama andaka ipulupa lola-kola, yakamato balana andaka kolandaka leaindo, yakamato wandakali anda okonena pitulai tupa lamawuato, yakama mini epene palu atalapa lalapape. Wandakali utupane-mane yakama wayu epalai ya leaindo, yakamana yamapane tambo laya olane pii epene oko utupanenga yolopeya oko yakale lalapape. Yakale lalu, yakama anda waka mindina pali-pali napene, anda mindiki okonena angu palu atoto, tano okonena epoko pua atalapape. Matili yakamato piape pikoyo pulai-angi, tano okone tepa alu pulupape. Yakama anda mindina kolandaka lolai-angi, wandakali anda okonena pitulai tupamane yakama wayu epalaiya lo lamia napeaindo, yakamana yamapane tambo laya alane pii okone yakama tanenga peke leakale lo ando kondalapape. ");
INSERT INTO ipi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tano mindina wandakali mindikipi mindimane yakamana pii lolai tupa ale naene, yakama yatawa pali napeaindo, yakamato tano okone tepa alu poyale atolai-angi, yakamana sukee okona yuu kangalamu atolane tupa tanda lo tepa alu, yakama yuu waka mindinga pulupape. ");
INSERT INTO ipi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nambato pii enene mindi yakama langeyo. Matili Goteto wandakali tupa yapa lo tale pulu epola-angi, Goteto Sotomo, Gomota-la, tano okone-lapona tane wandakali tupa malinga ika laya wato, kenda-pene mindi utupanenga malupeya. Wuane tekeko, yakamato pii mindi lolai-kola, tano mindina wandakali tupamane yakamana pii okone ale naene, yakama yatawa pali napeaindo, matili Goteto kenda-pene andane wete mindi wandakali utupanenga maulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, sipisipi gulene akali tupa yakama peango anatope gulene wandakali tupana tombenenga poto, piape pua atalapape leyo-ko. Etelu tupamane tenga-mane waiwa yalaini pua teke, yakamatopi waiwa atalapape. Dee, eka iti puluma tupamane mana koo mindi paini mina na-piyaini pua, yakamatopi mana koo mindi paini mina na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Yakamato namba lo bilipi leyai oko awua tepa alapale nembo toto, Juta yame-mane yakama andi lo awua poto, yakamana kanjole tupana wenonga kosimi loto, yakamana lotu anda tupana atoto, yakama kunju-mane peyolo-peyai. Utupane-mane wuane pulaini. Yakama waiwa ando atalapape. Yakamato nambana pii layene epene oko gapomane akali andanepi, kiŋipi, wandakali yame waka tupapi, utupane pitaka lamai-yapale nembo toto, alu minditupa Goteto ando konda ola-kola, wandakali minditupa-mane yakama andi lo awua poto, yakama kosimi loyale, akali utupanena wenonga ataya olopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Yakama akali utupanena wenonga atolai-angi, yakamato pii lolai tupa yakama tane nembo toto, laa napulu-peyai. Jia. Ayiane Gotena Sipitisa yakamanga ateya okomane yakamana nembo-tene tupa mina ika laya wato, yakamato wua lalapa lolopeya-ko. Wandakali-mane yakama kosimi lolai-angi, yakamato aki loto, wandakali utupanena pii lolai utupane yano peya-makalepe lo nembo kambua na-talapape. ");
INSERT INTO ipi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Okone angi, akali mindimane namba lo bilipi lola-kola, balana amene okomane bala kosimi loto, gapomane okomane bala peyo ome leakale lo malupeya. Ayiane mindimane balana andopane oko kosimi loto, wuane teke pulupeya. Andopane minditupana angini, ayiane-la, okonelapo liyamba nambana yame atolapi-kola, andopane utupane-mane okonelapo masia mawuato, kosimi loto, gapomane okomane okonelapo peyo ome leakale lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yakama nambana yame atolai-kola, wandakali kambua longo-mane yakama towa embo wetete olopeyai tekeko, wandakali-mane namba awua tepa naene, nambanga tungi peyo bilipi lo atapowa atolai-kola, Goteto utupane molo-peke lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nambato pii enene mindi yakama langeyo. Yakamato Isatale yuu okona tano tupa pitakana poto, piape pikoyo napulai-kola, Akalina Iwanane oko peke lolopeya-ko. Tano mindina wandakali tupamane kenda-pene andane tupa yakama giki peaindo, yakama tano waka mindina palaka pulupape. ");
INSERT INTO ipi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Mana kambua tisa tupanga eya-kola, mana aŋalapo angu sukulu pai tupanga yalane. Wuaneko, mana mene wandakali mindimane balana tisa oko sia minuto, bala lipinga yale ata napiyane. Jia. Mana mene mindimane mana moto, balana tisa ateya okopene teke guleando, okone katu. Wuane pua teke, piape akali mindimane balana piape ando atalane akali ateya okopene teke guleando, okone katu. Namba anda anduane ateyo-kola, wandakali minditupa-mane nambana gene Belesa-pulu geyai-ko. Wuane pua teke, yakama nambana yame ateyai lo andoto, utupane-mane gene koo wete minditupa yakama gulupeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wuane lalu, Jisasato pii mindi tako pua loto, andipa wandakali-mane mana too pua miniyai tupa pitaka matili panakame yolopeya lea. Pii andipa too pene eya tupa pitaka matili wandakali-mane ale wato, nembo tolo-peyaiko. Yakamato wandakali mindikipi mindi ando yuku olaini. ");
INSERT INTO ipi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Andipa undupi pangosa nambato pii minditupa yakama langeyo tekeko, matili nai tola-angi, yakamato pii utupane panakame lamai-yapape. Andipa nambato pii minditupa akatete-mane yakama langeyo tekeko, matili wandakali pitaka-mane ale yakale nembo toto, yakamato anda tokonga atoto, pii utupane taimane lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","31","Wandakali-mane katulo eka pilipimbi lapo ana mindiki-mane kambalaini tekeko, yakamana Ayiane Goteto eka aŋako utupanena mindi oma napeakale nembo teando, eka okone oma napulu-peya. Wandakali yakamato eka pilipimbi kambua tupa sia minuto, lipinga-yale ateyai-kola, Goteto yakamana kawa itini ateya tupa dii lo andalane-ko. Wandakali-mane yakama peyo ome lolaini loto, yakamato yuku aa na-piyapape. Enene, wandakali-mane katulo yakamana umbaini oko peyo ome lolopeyai tekeko, utupane-mane yakamana tandini oko katulo peyo ome nalolo-peyai. Goteto katulo yakamana umbaini, tandini-la, lapotaka yuu koo wetete okona awua aindaka loto, minu koyolo-peyako. Wandakali-mane yakama peyo ome lolaini lo yuku naene, yakamato Gote angu yukuwa atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","33","Wandakali tupana wenonga atoto, wandakali mindimane namba Jisasa yame ata napeyo leando, matili nambana ayiane ati kenga ateya okona wenonga atoto, nambato wandakali okone bala namba yame ata napeya lolo-peyawa. Wuane tekeko, wandakali tupana wenonga atoto, wandakali mindimane namba Jisasa yame ateyo leando, matili nambana ayiane ati kenga ateya okona wenonga atoto, nambato wandakali oko bala namba yame ateya lolo-peyawa teke. ");
INSERT INTO ipi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","36","Yuu okona wandakali tupamane yanda napene atoto, yame mindiki ateakale nayuto, namba epeane lo yakamato nembo na-talapape. Jia. Ayiane mindimane nambana yame atola-kola, balana iwanane okomane bala yanda pimalu-peya. Angini mindimane nambana yame pitula-kola, balana wanane okomane bala yanda pimalu-peya. Akali mindina angini okomane nambana yame pitula-kola, akali okonena wetene okomane balana wanda imane okone yanda pimalu-peya. Akali mindimane nambana yame atola-kola, balana yame anda mindikina paliyaini tupamane bala yanda pimalu-peyai. Wandakali yame palu pula tupa pitaka yapu lo lapo peakale nembo toto, namba epewane. Wandakali minditupa-mane yanda pimakale nembo toto, kandepa luu tupa awua epalaini pua teke, nambana pii oko kandepa luu mindi guleya-kola, nambato okone awua epewane. ");
INSERT INTO ipi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wandakali mindimane balana ayiane yandopi, angini yandopi, okone-lapona mindi wayumane epelewa yamapane yo atalane wuane pua teke, balato namba towa epelewa yamapane yo ata napeando, wandakali okone bala katulo nambana yame ata napulu-peya. Mindimane balana iwanane yandopi, wanane yandopi, okone-lapona mindi wayumane epelewa yamapane yo atalane wuane pua teke, balato namba towa epelewa yamapane ata napeando, wandakali okone bala katulo nambana yame ata napulu-peya teke. ");
INSERT INTO ipi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wandakali mindi bala nambana yame atola mambele, kenda-pene minditupa balanga epoto, balana ita malamanda oko gulo yolopeya. Balato kenda-pene utupane mo awua, namba watama na-epeando, bala nambana yame atolane wandakali epene mindi jia. ");
INSERT INTO ipi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wandakali mindi bala nambana yame ateando, namba towa yanda piyaini akali tupamane katulo bala peyo ome lolopeya. Wandakali mindi bala omolowane nembo toto, nambana yame ata napeando, bala epene saka atapowa ata napulu-peya. Wandakali mindi bala nambana yame atola mambele, wandakali mindimane bala peyo ome leando, wandakali okone bala epene saka atapowa atolane tene oko ando molopeya. ");
INSERT INTO ipi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wandakali mindimane yakama wayu epalai ya loto, yakama yatawa paleando, balato namba wayu epeleya loto, yatawa palula-kola pulupeya. Wandakali mindimane namba wayu epeleya loto, namba yatawa paleando, balato namba ati kenga atala yuunga puu leane Gote oko wayu epeleya loto, yatawa palula-kola teke pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mindimane potopesa akali mindi moyokale nembo toto, bala wayu epeleya loto, yatawa paleando, Goteto balana potopesa akali tupa yole epene mindi maulupeya mindiki okonepene teke wandakali okone maulupeya. Dee, wandakali mindimane Gotena wandakali epene tika-pene mindi moyokale nembo toto, bala wayu epeleya loto, yatawa paleando, Goteto wandakali epene tika-pene mindi yole epene mindi maulupeya mindiki okone teke wandakali okone maulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nambato pii enene mindi yakama langeyo. Wandakali mindimane nambana yame wandakali tupana mindi moyokale nembo toto, ipa kaka-ene ambuto, nambana yame wandakali gene nayene wete mindi neakale mayando, Goteto yole epene mindi wandakali okone maulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yakamato wua piyapape loto, Jisasato balana disaipolo alesa akali tupa mana lamai koyo piyu, bala yuu okone tepa alu, yuu ongane mandaka tano yane tupana poto, Gotena pii mana tupa lamawua atea. ");
INSERT INTO ipi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Okone angi, ipa peya-maiyane akali Jone oko bala andi latane atoto, Jisasa Kataisato piape pua ateya lene oko ale yaepia. Ale wato, balana disaipolo lapo akali lamawuato, liyamba Jisasa ateyanga poto, bala tipa puato, nimba akali mindi epolopeya layene pia okope. Pee, matili akali waka mindi epolopeya lo nanimato maliyo atamakalepe lo tipa piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","6","Wuane lea-kola, akali okonelapo Jisasa ateanga epoto, bala tipa peapi-kola, Jisasato okone-lapona pii okone yano peyoto, nambato piape pua ateyo-kola, wandakali lee koo tupamane kuai lo andeyai lea. Wandakali kee koo tupa asini peyai. Wandakali tapa-pene tupa umbaini epene ateyai. Wandakali ale tuma tupamane pii ale eyai. Wandakali omene tupa malinga ika loto, saka ateyai. Wandakali koo tipia tupamane Gotena pii layene oko ale eyai. Wandakali mindimane nembo lapo pali napene, namba Mesaya oko ateya lo bilipi leando, matili bala epele wete olopeya-ko. Liyamba Jone ateyanga peke loto, nambana piape lee-mane andeyapi tupapi, nambana pii ale-mane ale eyapi tupapi, utupane pitaka bala lamai-yapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wuane lea-kola, Jonena disaipolo okonelapo Jone ateanga peke leapi-kola, Jisasato wandakali kambua ateaini tupa tipa puato, wamba Jone bala wandakali napalene yuu okona atea-angi, bala akali anu-pene mindi atea-kola, yakamato bala andolo peaipe lea. Popo leya-kola, kambe tundupalina dini tupa pua amo nena piyane pua, Jone bala akali nembo lapo palu atea-kola, yakamato bala andolo peaipe. Jia. Bala nembo mindiki palu atoto, piape pua atea. ");
INSERT INTO ipi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Balato tona epene wete minditupa pua atea-kola, yakamato bala andolo peaipe. Jia. Tona epene wete piyaini akali tupa kiŋi tupana andaka pitiyaini. ");
INSERT INTO ipi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","10","Jone bala potopesa akali mindi atea-kola, yakamato bala andolo peaipe. Enene. Jone balato potopesa piape pua atolopeya nembo toto, Gotena pii pepa pelene eya mindimane loto, Ale alapape. Nambana pii wai lo awua epolane akali oko bala wamba ingane epeakale lolowa-kola, balato nimbana asini oko mandeke pua yata olopeya layene eya. Joneto potopesa piape okone puato, potopesa akali wamba ateaini tupa pitaka sia minea. ");
INSERT INTO ipi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nambato pii enene mindi yakama langeyo. Ipa peya-maiyane akali Jone oko balato yuu okona wandakali tupa pitaka sia minu ateya tekeko, Goteto wandakali gene nayene wetete tupa moyo ando atola-kola, utupane-mane Jone sia minuto, kuai lo wetete atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Wamba Mosesapi, potopesa akali tupa pitakapi, utupane-mane pii minditupa pepa peleai-kola, akali minditupa-mane pii utupane wandakali tupa lamawua atama ipulu, ipa peya-maiyane akali Jone oko bala ateane gii okona giau leainipia. Jone bala epoto, Goteto pitaka taka ando atalane lo pii lamawua ateane okone angi tewa atoto, wandakali pitaka-mane balana pii okone ale wato, Goteto utupane moyo ando ateakale lo taimane atete pima epeaini oko epoto, oto andipa ateyama okona giau leya. ");
INSERT INTO ipi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wamba potopesa akali tupamane pii mindi loto, matili potopesa akali Ilainja bala peke lolopeya leainipia. Yakamato utupanena pii okone enene ya lo nembo teaindo, ipa peya-maiyane akali Jone bala Ilainja peke lene gulo ateane nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wandakali ale asia yene tupa yakamato pii okone ale alapape. ");
INSERT INTO ipi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","19","Ipa peya-maiyane akali Jone bala ipa waene naa napene atea. Ole ukupini mindilapo balato pote angu lokale nembo toto, ulia nanene kondea. Kondea-kola, wandakali tupamane bala lamba loto, sipitisa koo mindi balanga ateya-kola, balato ipa waene ulia ima nanene kondalane leainipia. Andipa Akalina Iwanane oko epo atoto, ipa waenepi, uliapi neya-kola, wandakali andipa ateyai tupamane balapi lamba loto, akali okomane ipa waenepi, uliapi kambua wete no atoto, takisa muni mialaini akali tupapi, koo piyaini wandakali tupapi, utupane towa yandeke ando atalane leyai. Wuane leyai-kola, nambato andipa ateyai wandakali yakama andopane yame towa makande peyo. Andopane tupamane makesa ama tupana pituto, andopane yangone tupa lamawuato, yakamato nanima towa kindi pua mali lialapale loto, nanimato yakama mina kindi pua musiki lalama tekeko, yakamato nanima towa kindi pua mali lia napiyai lalaini. Nanimato kindi puato, wandakali mali puyale wee lalaini mindi lalama tekeko, yakamato nanima towa kindi pua ai lama na-lalai. Wandakali andipa ateyai tupa yakama andopane okonepene gulo atoto, pii okonepene leyai tekeko, wandakali wai-ene tupamane Gotena pii layene oko tika-pene ya lo nembo toto, Goteto leya pua piape piyaini. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Wamba Jisasa bala Kotasinipi, Betesaitapi, Kapaneamepi, tano utupanena atoto, metekolo piape tai-lene andane kambua wete peane tekeko, tano utupanena tane wandakali tupamane yamapane peke naleai. Yamapane peke naleai-kola, balato wandakali utupane laiya loto, Kotasini, Betesaita-la, tano okone-lapona tane wandakali yakamato ale alapape lea. Wamba namba yakamana yuu okone-lapona atoto, metekolo piape andane minditupa pewa tekeko, yakamato utupane andoto teke, yamapane peke naleai. Akali mindimane Taya, Saitone-la, tano koo okone-lapona poto, metekolo piape andane utupane pea-yale, tano okone-lapona tane wandakali tupamane mana koo minu atalamae-ya nayu, mini kenda wato, yakamana angati itini pundi loto, wamba wete yamapane peke leai-yale. Yali, ae, Kotasini, Betesaita-la, tano okone-lapona tane wandakali yakama yamapane peke naleyai okonena, yakama koyolo-peyai nembo toto, nambato yakama ondo eyo. ");
INSERT INTO ipi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Goteto wandakali tupa yapa lo tale pula-angi, balato Taya, Saitone-la, tano okone-lapona tane wandakali tupa kenda-pene minditupa maulupeya tekeko, balato kenda-pene andane wete minditupa Kotasini, Betesaita-la, tano okone-lapona tane wandakali yakamanga gulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Okone angi, Goteto Kapaneame tano okona tane wandakali yakamana gene tupa ati kenga laiyu lolo-peyape. Jia. Yakamapi yamapane peke naleyai okonena, balato yakamapi yuu koo wetete okona wata ai nena lolopeya. Wamba namba yakamana tano okona atoto, metekolo piape andane minditupa pewa okoni. Wandakali mindimane Sotomo tano okona atoto, metekolo piape andane utupane pea-yale, wandakali utupane yakamapi yamapane peke leai-yale. Wuane peai-yale, Goteto Sotomo tano oko minu koya napea-kola, tano okone mee yapia-yale. ");
INSERT INTO ipi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Goteto wandakali yapa lo tale pula-angi, balato Sotomo tano okona tane wandakali tupa malinga ika laya alu, utupanenga kenda-pene minditupa maulupeya tekeko, balato kenda-pene andane wete mindi Kapaneame tano okona tane wandakali yakamanga gulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","27","Okone angi, Jisasato pii mindi tako pua loto, minditaka eya tupa pitaka nambato ando atola loto, Ayiane Goteto utupane pitaka nambanga geane lea. Wandakali mindikipi mindimane bala tanena tai-lene okomane Ayiane Gote oko bala okopene lo anda napiyane. Jia. Gote Iwanane oko balana tai-lene okomane Ayiane Gote oko bala okopene ateya lo andalane. Andoto, balana ayiane oko bala okopene ateya lo wandakali mindinga andawa leando, wandakali okonemane Ayiane Gote oko bala okopene ateya lo andolopeya teke. Wuane pua teke, wandakali mindikipi mindi bala tanena tai-lene okomane Gote Iwanane oko bala okopene ateya lo anda napiyane. Jia. Ayiane Gotena tai-lene okomane bala Iwanane okopene ateya lo andalane. Andoto, balana Iwanane oko bala okopene ateya lo wandakali mindinga andawa leando, wandakali okonemane Iwanane oko bala okopene ateya lo andolopeya teke. Wuane lalu, Jisasato pote loto, Ayiane Gote, nimbato yuu ati-la, lapotaka ando atelene lea. Wandakali wai-enepi, mana kambua andenepi, utupane-mane pii lalo utupane anda napeakale nembo toto, wamba nimbato pii utupane mo too pee. Andipa andopane aŋako yale gulo ateyai wandakali tupamane nimbana pii utupane andeakale nembo toto, nimbato pii utupane wandakali utupanenga andawa lele. Enene, ayiane, nimbato kuai lo nembo toto, wuane pele okonena, nambato nimbana gene oko laiyu leyo. Jisasato pote loto, wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pote lalu, Jisasato wandakali tupa lamawuato, kenda-pene andane awua atalaini wandakali yakama oto mialapale lokalenga, yakama namba ateyonga ipulupa lea. ");
INSERT INTO ipi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Nambato wandakali tupana napinga yale gulo atoto, utupane towa tenga-mane tambo lo atene mana oko minu atalawane. Yakama nambana pangosa ateaindo, piape nambato yakama guluwa oko kenda napene, yambo-yambo gulola-kola, yakama oto mo atene gulo atolo-peyaiko. Yakama nambana pangosa atoto, piape nambato yakamanga guluwa okone puato, mana nambato yakama languluwa tupa mo atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sambasa mindina, Jisasa bala witi ee tupana tombenenga asia epo pea-kola, balana disaipolo tupamane bala watama epoto, ulia nono wato, witi dini tupa yoto, naka pima peai. ");
INSERT INTO ipi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yoto naka pima peai-kola, Patasai tupamane andoto, Gotena loo okomane loto, Sambasa angi wandakali-mane piape napipe-pene leya tekeko, nimbana disaipolo tupamane witi dini tupa yoto, naka pima peyai okonde leai. ");
INSERT INTO ipi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gotena loo okomane loto, Gotena lotu anda okona betesa Gote maiyene yalaini tupa pitisa akali tupamane angu nape-pene layene eya lea. Wandakali waka mindimane betesa utupane naa na-piyapape layene eya tekeko, wamba Dapitipi, akali bala towa atu ateaini tupapi, utupane yakama ulia nono yai-kola, balato Gotena lotu anda okonena kolandaka loto, betesa utupane noto, bala towa atu ateaini akali tupapi neakale mayane lo pepa pelene eya. Yakamato pii okone wamba dii lo anda napeaipe. ");
INSERT INTO ipi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dee, Mosesato pii mindi pepa peyoto, Sambasa angi pitisa akali tupamane lotu anda andane okona atoto, piape piyaini tekeko, Goteto koo tene mindi utupanenga yata na-alane leaipia. Yakamato pepa okone wamba dii lo anda napeaipe. ");
INSERT INTO ipi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","Yakamato lotu anda andane oko angini wete mindi ateya nembo teyai tekeko, namba epo atoto, lotu anda andane oko sia minuto, piape andane wete tupa piyawane lo nambato yakama langeyo. Akalina Iwanane nambato Sambasa oko ando atalawane. Gotena pii pepa pelene eya mindimane loto, wandakali-mane namba opa gipia lakae lo nambato nembo nateyo. Jia. Wandakali-mane yakamana yangone tupa ondo wato moyapiai lakae lo nambato nembo teyo layene eya. Yakamato pii okonena tene oko nembo tapiai-yale, koo tene mindi nambana disaipolo tupanga yaa napeya lo andapia-yale. Andoto, yakamato koo tene mindi utupanenga mee yata aa napiyiai-yale. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wuane lalu, Jisasa bala yuu okone tepa alu poto, Juta yamena lotu anda okona kolandaka lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kolandaka loto andea-kola, kini yangisa angu manda-tene akali mindi petea. Petea-kola, akali peteaini tupamane Jisasa kosimi lamakale nembo toto, bala tipa puato, Gotena loo okomane aki leyape. Sambasa angi akali mindimane wandakali siki pelene tupa mo atu yando, mana okone katupe, nakatupe leai. ");
INSERT INTO ipi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wuane leai-kola, Jisasato utupane tipa puato, Sambasa angi yakamana sipisipi mindi kundu mindina peakeando, yakamato sipisipi okone mia napene, kundu okonena yakale lo ando kondolo-peyaipe. Jia. Yakamato sipisipi okone yo lo molopeyai okoni. ");
INSERT INTO ipi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wandakali-mane yia sipisipi tupa sia minu, lipinga wete ateyai. Tene okonena, Gotena loo tupamane nanima languato, Sambasa angi, wandakali mindimane mana epene mindi minuto, yangone mindi mo atu yando, mana okone katu lolopeya leya. ");
INSERT INTO ipi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisasato wuane lalu, akali kii koo okone lamawuato, nimbana kii koo oko tiyongo laa lea-kola, akali okonemane balana kii tiyongo lea. Balato balana kii okone tiyongo lea wete, balana kii koo okone atu yoto, yangisa epene ateane okopene teke gulea. ");
INSERT INTO ipi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sambasa angi Jisasato akali okonena kini mo atu ya-kola, Patasai utupane lotu anda oko tepa alu poto, nanimato anu puato, Jisasa peyo ome lamakalepe lo asia mindi aiya peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","21","Patasai tupamane Jisasa peyo ome lamakale lo asia aiya pua ateai oko Jisasato andoto, yuu okone tepa alu pea. Pea-kola, wandakali kambua-mane bala watama epeyai oko andoto, Jisasato pii mindi Goteto bala andayo leane oko nembo tolo-peke lea. Pii okone nembo tolo-peke loto, balato Patasai utupane lamawuato, wamba potopesa akali Aisayato pii mindi pepa peyoto, nambato akali oo ateya oko towa epelewa yamapane yo atoto, balana mana tupa epele wete alawane leaipia. Nambato bala nambana piape akali ateakale lata ewane. Matili nambana sipitisa oko balanga epeakale lolowa-kola, balato nambana mana tika-pene tupa wandakali yame tupa pitaka lamaulu-peya. Balato utupane towa pii yanda pimawua, taimane nalolo-peya. Kambaiya mindi aŋa leka-getane atola-kola, balato okone minu leka wete na-olopeya. Ita lengane mindi tee puyale pula-kola, balato okone minu tee wete piya na-olopeya. Balato mana epene tika-pene tupa wato minu atama pulu, mana koo tupa sia minula gii okona giau lolopeya. Wuane pula-kola, wandakali yame tupa pitaka-mane balanga tungi peyoto, balato utupane moyolo-peya lo maliyo atolopeyai. Wamba potopesa akali Aisayato wuane loto, pepa okone peleane nembo tolo-peke loto, Jisasato Gotena pii okone enene guleakale nembo toto, wandakali siki pelene tupa pitaka mo atu yaka pea. Utupane mo atu yaka piyu, balato utupane lamawuato, nambato yakama mo atu eyo oko yakamato mindi wandakali lamaulaini. Jia wete lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Okone angi wandakali minditupa-mane akali sipitisa koo atene mindi Jisasa ateanga atu aiyu epeai. Sipitisa koo mindi akali okonenga atea-kola, akali okone bala katulo pii na-lalaepia. Jisasato sipitisa koo okone peyo watalu, akali okone mo atu ya-kola, akali okone bala lee talu, pii lalu, pea. ");
INSERT INTO ipi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Okone andoto, wandakali amunguli pua ateaini tupa pitaka-mane moko leai. Wandakali minditupa-mane akali oko bala kiŋi Dapiti yame mindi epolopeya layene yene pia okope lo tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tipa peai-kola, Patasai tupamane ale wato, Belesa-pulu bala sipitisa koo tupana akali kawane atoto, Jisasa minu tai laya eya-kola, balato sipitisa koo tupa peyo wata alane leai. ");
INSERT INTO ipi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wuane leai-kola, Jisasato utupane lamawuato, kiŋi mindikina yame oko yapu lo lapo puato, yakama teke-teke yanda peapindo, yame okone koyolo-peya lea. Dee, tano mindikina yandopi, anda mindikina yandopi, wandakali paliyaini tupa yapu lo lapo puato, yanda peapindo, utupane tai ata napulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Belesa-puluto namba minu tai laya apia-kola, nambato sipitisa koo yame oko peyo watauwa-yale, Satane yame okone yapu lo lapo puato, yanda-pene gulapia-yale, anu puato balana yame oko tai atapia-yalepe. ");
INSERT INTO ipi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Belesa-pulu balato namba minu tai laya eya-kola, nambato sipitisa koo tupa peyo watauwa-yale, Belesa-puluto Patasai yame yakamana disaipolo tupa minu tai laya eya-kola, utupane-mane sipitisa koo tupa peyo watapiai-yale. Yakama tanena disaipolo tupamane yakamana pii okone yapa lo tale puato, yakamato pii kopeta leyai lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","29","Anu puato, wandakali mindimane akali tai mindina andaka kolandaka loto, minditaka yola tupa katulo mo awua polo-peyape. Balato akali tai oko wamba ini eyaka-mane andi lata yando, balato akali okonena andaka kolandaka loto, minditaka yolane tupa katulo mo awua polopeya. Wuane pua teke, Gotena Sipitisa okomane namba minu tai laya eya-kola, nambato akali tai Belesa-pulu oko wamba ini andi lata wato, balana andaka kolandaka loto, balana sipitisa koo tupa peyo wata alawane-ko. Goteto yakama moyo ando atolo ipupia lo yakamato nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nambana yame ata na-piyaini wandakali tupamane namba yanda pingiyaini. Nambana sipisipi tupa mo amunguli na-piyaini wandakali tupamane nambana sipisipi tupa puu toko leakale loto, wata apialaini. ");
INSERT INTO ipi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wandakali mindimane mana koo okonepene mindi miniandopi, yangone mindi lamba leandopi, mana koo waka minditupa mineandopi, Goteto balana mana koo utupane pitaka apia-malupeya tekeko, wandakali mindimane Oli Sipitisa oko lamba leando, Goteto balana koo okone apia-mai napulu-peya lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dee, wandakali mindimane Akalina Iwanane oko andayo pii koo mindi leando, Goteto balana koo okone apia-malupeya tekeko, wandakali mindimane Oli Sipitisa oko andayo pii koo mindi leando, andipapi, matili-matilipi, Goteto balana mana koo okone apia-mai napulu-peya. Oli Sipitisa okomane namba minu tai laya eya-kola, nambato sipitisa koo tupa peyo wata alawane. Wuane tekeko, yakama Patasai tupamane loto, sipitisa koo Belesa-puluto namba minu tai laya eya-kola, nambato sipitisa koo tupa peyo wato apialane leyai. Yakamato wuane leyai okomane Oli Sipitisa gene koo Belesa-pulu mawuato, bala lamba leyai okonde. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ita epene tupanga dini epene teke lialane. Ita koo tupanga dini koo teke lialane. Ita utupanena dini lula tupa andoto, wandakali-mane ita tupa yapa lo tale puato, ita oko epene ya, ita oko koo ya lalaini. ");
INSERT INTO ipi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Wuane pua teke, wandakali epene tupana nembo-tene epene kambua paleya-kola, utupane-mane mana epene kambua minuto, pii epene teke lalaini. Wandakali koo tupana nembo-tene koo kambua paleya-kola, utupane-mane mana koo kambua minuto, pii koo teke lalaini. Tene okonena, Patasai yame yakama etelu koo gepo-mane mandiyene gulene atoto, pii epene mindi katulo na-lalaini. ");
INSERT INTO ipi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","Nimbato pii lolene tupa Goteto ale wato, nimba yapa lo tale pulupeya. Nimbato pii epene tupa lalene yando, Goteto nimba wandakali epene ya lolopeya. Nimbato pii koo tupa lalene yando, balato nimba wandakali koo ya lolopeya. Tene okonena, matili Goteto wandakali tupa yapa lo tale pula-angi, balato wandakali mindiki-mindiki lo tipa puato, anu peakale nimbato pii koo tupa wuane leepe lolopeya. Balato wuane lo tipa pula-angi, wandakali mindiki-mindiki lo balana pii okone yano peyoto, tene mindi wua pea-kola, nambato wuane lewa lape-pene gulolo-peya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Okone angi, loo tupana mana andene akalipi, Patasaipi, utupanena minditupa-mane Jisasa lamawuato, tisa, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andamakale-ko. Nimbato metekolo piape mindi pula leai. ");
INSERT INTO ipi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wuane leai-kola, balato utupanena pii okone yano peyoto, wandakali yame koo andipa ateyai tupa yakamato Gote enene oko awua tepa alu, gote waka tupanga tungi peyo bilipi lalaini okomane yakama pamuku piyaini wandakali gulo atalaini lea. Yakamato namba languato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loyale, metekolo piape mindi pula lalaini tekeko, nambato metekolo piape mindi andipa napukale. Jia. Wamba Goteto potopesa akali Jona balanga metekolo piape peane okonepene mindiki nambato matili pukale. ");
INSERT INTO ipi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wamba Goteto metekolo piape andane okone pea-angi, Potopesa akali Jona bala utulu otongapi oto tepo pisa andane mindina ini anda-pangosa paliyu, kamaka epeaipia. Wuane pua teke, matili Akalina Iwanane oko bala utulu otongapi ole tepo yuu pangosa paliyu, kamaka epolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Wamba Jona balato Gotena pii oko Ninipa tane wandakali tupa lamaiya-kola, utupane-mane ale wato, yamapane peke leainipia. Andipa Jona sia minene akali mindi epoto, Gotena pii lamawua ateya tekeko, wandakali andipa ateyai tupa yakamato ale wato, yamapane peke naleyai. Tene okonena, matili Goteto wandakali tupa yapa lo tale pula-angi, Ninipa tane wandakali tupamane wandakali andipa ateyai tupa yakamanga koo tene minditupa yata olopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wamba kuwini wanda mindimane Simba yuu oko ando peteane-angi, wandakali-mane kiŋi Solomone bala akali mana andene mindi ateya leainipia. Wuane leai-kola, kuwini wanda okonemane balana pii ale wakale nembo toto, Simba yuu oko tepa alu, asia luu wete mindina pea-kola, Solomoneto Gotena pii oko bala lamai-yaepia. Andipa kiŋi Solomone sia minene akali mindi epo ateya tekeko, wandakali andipa ateyai tupa yakamato balana pii ale naeyai. Tene okonena, matili Goteto wandakali tupa pitaka malinga ika laya wato, utupane yapa lo tale pula-angi, kuwini wanda okonemane koo tene minditupa wandakali andipa ateyai tupanga yata olopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Wuane lalu, Jisasato pii mindi tako pua loto, sipitisa koo mindi wandakali mindi balanga atolane oko awua tepa alu peya-angi, bala wandakali napalene yuu tupana epoko puato, oto mo atolane panda mindi aiya piyane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aiya pitete wato, anda nambato wamba awua tepa alu epewa okonena namba peke loto atokale lalane. Wuane lalu, bala anda okonena peke loto andeya-kola, anda ukuna okonena kangalamu yane tupa mindimane aki pua apea-kola, anda okone yati pitane epene ateyanga andalane. ");
INSERT INTO ipi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Andalu, balato sipitisa koo wete yanasa bala sia minene tupa lamoto, utupane towa atu anda okonena peke loto atalaini. Wamba sipitisa koo mindiki akali okonenga atea-angi, bala kopeta ateane tekeko, andipa sipitisa koo kitupasa utupane balanga ateyai-kola, bala kopeta wete atalane. Wuane pua teke, wandakali yame koo andipa ateyai tupa matili kopeta wete atolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisasato wandakali kambua ateaini tupanga pii lamawua atea-kola, balana angini amene ima epoto, bala towa pii lamakale lo kamaka maliyo ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Maliyo ateai-kola, mindimane Jisasa lamawuato, nimbana angini, amene, utupane-mane nimba towa pii lamakale loto, kamaka maliyo ateyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nambana angini amene ima tupa api tupape lea. ");
INSERT INTO ipi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Nambana Ayiane ati kenga ateya okona nembo-tene wato minalaini wandakali tupa nambana angini, amene, imalini, ima ateyai-ko. Yakamato nambana angini amene ima andalapa loto, Jisasato balana disaipolo tupa balana kii-mane waiyataka pea. ");
INSERT INTO ipi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ole okone angi teke, Jisasa bala andaka atalu, kamaka poto, ipa angini okona matenenga petea. ");
INSERT INTO ipi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Petea-kola, wandakali kambua wetete bala peteanga epo amunguli puato, ipa matene okonena ateai-kola, Jisasa bala sipi mindina peakaiyu lo petea. ");
INSERT INTO ipi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bala pituto, pii kokoli kambua utupane lamaiya. Bulupane balato pii kokoli mindi loto, akali mindimane tomo waini minditupa balana ee okona papaka lolo peane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Papaka lea-kola, tomo waini minditupa ambe asininga tepa ya-kola, eka minditupa epoto, utupane neainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tomo waini minditupa ambe ana tokonga yuu aŋako yane ongane tepa wato, wamba kapoyale poka lo ika leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Waini utupane poka lo ika leaini tekeko, pini ana okona pea-kola, nai-mane ana oko toto peane okomane utupane kapu tamangua yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tomo waini minditupa ambe tani koo ani atene tupa ika lalane yuu mindina tepa wato, poka lo ika leaini tekeko, tani koo ani atene tupa kapoyale anda yoto, utupane peyayo neaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tomo waini minditupa yuu epene mindinga tepa yaepia. Waini utupanena minditupanga dini paiyasa tepo liaepia. Minditupanga dini paiyasa wataka liaepia. Minditupanga dini wane andete liaepia. ");
INSERT INTO ipi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ale asia yene wandakali yakamato pii okone pai lo ale wato, pii okonena tene oko nembo talapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisasato pii kokoli okone lea-kola, balana disaipolo tupamane bala ateanga epoto, anu peakale nimbato pii kokoli angu loto, wandakali tupa lamailini lo tipa peai. ");
INSERT INTO ipi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Tipa peai-kola, balato utupanena pii okone yano peyoto, wandakali mindimane Gotena pii oko bilipi leyo nayu leando, Goteto balana bilipi oko minu tai laya ola-kola, wandakali okonemane Gotena pii oko bilipi leyo nayu lolopeya lea. Disaipolo tupa yakamato Gotena pii oko bilipi leyama nayu leyai okonena, Goteto pitaka taka ando atalane loto, nambato pii mana wamba too pene yane tupa yakamanga andawa lalawane. Wuane tekeko, wandakali waka tupamane Gotena pii oko bilipi leyama nayu naleyai okonena, Sataneto akali utupanena bilipi oko mo alu piya olopeya. Tene okonena, Goteto pitaka taka ando atalane lo pii mana wamba too pene yane tupa nambato wandakali utupanenga panakame lamai napene, pii kokoli lo angu lamai-yawane. ");
INSERT INTO ipi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","15","Wamba Goteto wandakali okonepene tupa nembo toto, pii mindi potopesa akali Aisayanga lamaiya-kola, Aisayato pii okone pepa peleaipia. Balato Gotena pii okone loto, wandakali utupane-mane nambana piape tupa lee-mane andalu, nambana pii oko ale-mane ale alu, nambana pii okona tene tupa kuai lo nembo toto, yamapane peke lapiai-yale, nambato utupane mo kuai lauwa-yale lea. Nambato utupane mo atu yauwa-yale tekeko, nambato wuane pulane nembo toto, utupane-mane nambana pii ale ape-pene kepa alu, lene mungu lalu, yakamana nembo-tene tupa ana yale gulo ateaini. Tene okonena, wandakali utupane-mane nambana pii oko ole kambuanga ale wato teke, pii okonena tene oko matili-matilipi nembo natolo-peyai. Utupane-mane piape nambato piyawane tupa ole kambuanga andoto teke, namba api ateyape lo matili-matilipi anda napulu-peyai layene eya. Andipa nambato piape peyo-kola, wandakali minditupa-mane andoto teke, namba api ateyape lo anda napeyai. Utupane-mane nambana pii oko ale wato teke, pii okonena tene oko nembo nateyai. Utupane-mane wuane peyai okomane pii Aisayato wamba leane okone enene guleya-kola, nambato pii kokoli lo angu lamai-yawane. ");
INSERT INTO ipi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","Wamba potopesa akali tupapi, wandakali epene tika-pene tupapi, utupanena wandakali kambua-mane pii andipa yakamato ale eyai tupa ale aima lakae lo nembo teaini tekeko, utupane-mane ale nayainipia. Andipa nambato mangene minditupa peyo-kola, yakamato lee-mane andeyai. Wamba potopesa akali tupapi, wandakali tika-pene tupapi, utupane-mane mangene utupane andaima lakae lo nembo teaini tekeko, utupane-mane anda napeaini. Nambato pii enene mindi yakama langeyo-kola, yakamato minditaka lee-mane andeyai oko andoto, minditaka alene-mane ale eyai oko ale wato, yakama kuai lo ateyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wuane lalu, Jisasato pii mindi tako pua loto, akali mindimane tomo waini papaka leane lo kokoli pii lalo okonena tene oko wua yalua lo yakamato ale alapape lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Akali mindimane tomo waini papaka lea-kola, minditupa ambe asininga tepa ya-kola, eka minditupa epoto, utupane neainipia. Wuane pua teke, akali mindimane Gotena pii oko loto, Goteto pitaka taka ando atalane leya-kola, wandakali minditupa-mane ale wato, pii okonena tene tupa wayumane nembo nateyai-kola, Satane epoto, Gotena pii utupanena nembo-tenenga eya oko mo alu piya alane. ");
INSERT INTO ipi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tomo waini minditupa ambe ana tokonga yuu aŋako yane mindina tepa wato, poka lo anda yane tekeko, ana toto peane okomane pini tupa kapu teaipia. Wuane pua teke, wandakali minditupa-mane Gotena pii oko wamba ini bulupane epelewa ale wato, bilipi lalaini. ");
INSERT INTO ipi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wuane tekeko, utupane-mane Gotena pii oko bilipi lo ateyai-kola, wandakali waka minditupa-mane kenda-pene andane tupa utupane maiki piyaini. Wuane peyai-kola, Gotena pii bilipi leyama nayu nalene wandakali utupane wayumane pini peya napene gulo atoto, ole ukupini aŋalapo angu bilipi lalu, wamba kapoyale bala awua tepa alaini. ");
INSERT INTO ipi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tomo waini minditupa ambe tani koo ani atene tupa ika lalane yuu mindina tepa wato, poka lo ika leane tekeko, tani koo ani atene tupa kapoyale anda yoto, utupane peyayo neaipia. Wuane pua teke, wandakali minditupa-mane Gotena pii ale wato, bulupane bilipi lalaini tekeko, matili munipi, waka minditaka tupapi, utupane kambua miaima lakae lo nembo talaini mana okomane wandakali utupane minakasa wato, Gotena pii oko ombo alane. Tene okonena, wandakali utupane-mane yuu okona minditaka eya tupa anu pua mia-makalepe lo nembo kambua teyai-kola, Gotena pii yakamanga eya okomane dini lia napiyane. ");
INSERT INTO ipi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tomo waini minditupa yuu epene mindinga tepa wato, dini kambua lialane pua teke, wandakali minditupa-mane Gotena pii oko ale wato, pii okonena tene oko pailo nembo toto, bilipi leyama nayu lalaini. Wandakali utupanena minditupanga dini paiyasa tepo lialane. Minditupanga dini paiyasa wataka lialane. Minditupanga dini wane andete lialane. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wuane lalu, Jisasato pii kokoli waka mindi wandakali tupa lamawuato, Goteto wandakali tupa wua pua ando atalane lo nambato pii kokoli mindi leyo. Akali mindimane witi waini epene tupa balana ee okona papaka leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Papaka lalu palea-kola, utulu okona akali okone towa yanda-pene akali mindi epoto, tani koo waini tupa ee mindiki okonena teke papaka lo tako piyu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Matili witi oko poka lalu, anda yoto, dini luyale pea-kola, tani koo tupa towa atu andayo ateanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Andoto, piape akali tupa poto, ee anduane oko lamawuato, akali andane, wamba nimbana ee okona nimbato tomo waini epene tupa angu papaka lee-kola, nanimato andema-ko. Tani koo ateya tupa apito papaka leape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wuane leai-kola, balato utupane lamawuato, yanda-pene mindimane tani koo waini utupane papaka lo tako pipiae yalua leaipia. Wuane lea-kola, balana piape akali tupamane bala tipa puato, nanimato tani koo utupane lopolo pupiai lakae lo nembo telepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wuane leai-kola, balato utupane lamawuato, yakamato tani koo tupa angu lopo apeyama nayuto, witi minditupa towa ambe lopo apolaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lopo apolomane. Andipa lapotaka ateakale lo ando kondalapa. Matili tomo mandu yolane oto oko epola-angi, nambato tomo mandulai akali tupa lamawuato, wamba ini bulupane yakamato tani koo tupa lopoto, utupane yangoyale puta piyapape. Puta piyu, witi dini tupa mo yomo wato, nambana tomo waini yalawane anda okona yata alapape lokale. Ee anduane okomane wuane leane lo Jisasato pii kokoli okone lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Wuane lalu, Jisasato pii kokoli waka mindi wandakali tupa lamawuato, maseta waini tupamane tomo waini waka yalane tupa pitaka sia minuto, aŋako wetete eya lea. Aŋako wete eya tekeko, wandakali-mane maseta waini tupa balana eenga papaka leyai-kola, utupane anda yoto, eenga tomo waka tupa pitaka sia minuto, andane ita yale guleya-kola, eka tupa epoto, maseta kembone tupana anda piyaini. Wuane pua teke, Goteto wamba ini bulupane wandakali aŋalapo minditupa angu ando atoto, piape pua ateya-kola, matili balana yame tupa andane wetete gulalaini. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wuane lalu, Jisasato pii kokoli waka mindi wandakali tupa lamawuato, wanda mindimane palawa yangoyale, palawa kambua disa andane mindina gae lalane lea. Gae lalu, balato palawa yangalaini pauta yisa lene okona aŋako mindi palawa utupanena tombenesa tepa wato, palawa ipa minu yata eya-kola, matili pauta aŋako okonemane palawa okone mo anda yalane. Wuane pua teke, wamba ini Goteto wandakali aŋalapo minditupa angu ando ateya-kola, matili balato piape pua ateya-kola, balana yame andane wetete gulalane. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Wamba potopesa akali mindimane Gotena pii mindi loto, Goteto yuu oko yakale lea-angi, pii minditupa too pitane ateane oko atama ipapo wato, andipa ateyama okona giau leya leaipia. Andipa nambato pii kokoli loto, pii too pitane utupane wandakali tupa lamauwakale lea. Gotena pii okonemane wuane leane pua, Jisasato wandakali kambua epo ateaini tupa mana lamawuato, Goteto wandakali tupa ando atoto, wua piyane lo pii mee mindi wandakali tupa mana lamai napea. Jia. Balato pii kokoli angu loto, mana lamawua ateane okomane potopesa akali okonena pii leane okone enene gulea. ");
INSERT INTO ipi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wandakali kambua amunguli pua ateaini tupa yakama andaka pulupa lalu, Jisasa bala andaka kolandaka lea. Kolandaka lea-kola, balana disaipolo tupa bala peteanga epoto, tani koo eenga ateane okona pii kokoli lale okonena tene oko nimbato nanima langi leai. ");
INSERT INTO ipi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wuane leai-kola, balato utupanena pii okone yano peyoto, tomo waini epene papaka leane akali lalo okone bala Akalina Iwanane oko lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ee lalo okone yuu eya tupa pitaka makande pua lalo. Tomo waini epene lalo tupa wandakali Goteto moyo ando atalane tupa makande pua lalo. Dee, tani koo lalo tupa wandakali Sataneto ando atalane tupa makande pua lalo. ");
INSERT INTO ipi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tani koo waini papaka leane akali yanda-pene lalo okone bala Satane. Tomo mandulane gii lalo okone yuu koyo pulane gii oko makande pua lalo. Dee, tomo mandulaini akali lalo utupane enjole tupa makande pua lalo. ");
INSERT INTO ipi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Wandakali-mane tani koo tupa lopoto, yangalaini pua, oto andipa eya oko koyo pula-angi, Akalina Iwanane okomane balana enjole tupa lamawuato, yakamato piape pulu pulupa lolopeya. Pulupa lola-kola, utupane-mane yuu balato ando atalane tupa pitakana poto, yangone-mane koo peakale lo mo piya alaini wandakali ateyai tupapi, Gotena loo ango alaini wandakali tupapi, utupane pitaka mo amunguli pulupeyai. ");
INSERT INTO ipi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Enjole utupane-mane wandakali utupane mo amunguli puato, ita too atapowa atene yuu koo okona wato aindaka lolopeyai. Aindaka lolai-kola, wandakali utupane ita too atapowa atene okonena atoto, yamataka lo nene geleto laka pua atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Okone angi, nai tii piyane pua, Ayiane Goteto ando atalane yuu okona atoto, wandakali epene tika-pene tupa tii pua atolopeyai. Ale asia yene wandakali yakamato ale alapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wuane lalu, Jisasato pii kokoli mindi tako pua loto, Goteto pitaka taka ando atalane mana oko epene wete eya loto, nambato wua leyo lea. Minditaka epene wetete mindi ee mindina too pitane ya-kola, akali mindimane okone ando moto, ee okonena teke too pulu-peke leaipia. Too piyu, bala epele ama poto, balana minditaka wamba yatawa ateane tupa pitaka wandakali waka tupamane kambeakale leaipia. Kambeai-kola, balato muni meane okonemane ee okone kambeaipia. Wuane pua teke, wandakali mindimane andola-kola, Goteto wandakali tupa kuai lo moyo ando atalane lo andolopeya. Andalu, balato epele wato, balana minditaka yuu okona eya tupa pitaka masia mawuato, Goteto bala moyo ando ateakale lo atolopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wuane lalu, Jisasato pii kokoli waka mindi loto, Goteto pitaka taka ando atalane mana oko epene wete eya loto, nambato wua leyo lea. Bisanisa piape piyane akali mindimane mamaku epene paiya wete mindi aiya pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mamaku epene wete mindi aiya pua andalu, bala poto, balana minditaka yane tupa pitaka wandakali waka tupamane kambeakale leaipia. Kambeai-kola, balato muni meane okonemane mamaku epene wete okone kambo meaipia. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Wuane lalu, Jisasato pii kokoli waka mindi loto, Goteto wandakali tupa wua pua ando atalane lo nambato pii kokoli mindi leyo lea. Wamba akali minditupa-mane pisa mialaini umbene nuu mindi ipa angininga aindaka loto, pisa yame mindipene-mindipene tupa pitaka meainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pisa mialane umbene nuu okone tumbi lea-kola, utupane-mane nuu okone kilau lo ipa matenenga mo yata yainipia. Mo yata alu, utupane-mane, pisa epene yame tupa yakamana pene tupana aindaka lalu, pisa koo yame tupa apeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wuane pua teke, yuu oko koyo puyale pula-angi, koo piyaini wandakali atolai tupa wandakali tika-pene tupa towa atu atolai-kola, enjole tupa epoto, utupane yapa lo tale pulupeyai. ");
INSERT INTO ipi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tale piyu, enjole tupamane wandakali koo tupa ita too atapowa atalane yuu koo okona wato aindaka lolai-kola, wandakali utupane-mane yamataka lo nene geleto laka pua atolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wuane lalu, Jisasato balana disaipolo tupa tipa puato, yakamato pii kokoli utupane pitakana tene tupa nembo teyaipe lea. Wuane lea-kola, utupane-mane bala lamawuato, nanimato nembo teyama leai. ");
INSERT INTO ipi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wuane leai-kola, balato utupane lamawuato, anda anduane mindimane balana minditaka epene yalane lumu okona poto, minditaka wambanepi, wenenepi, lapotaka mo awua epalane. Wuane pua teke, loo tupana mana andene akali mindimane mana moto, Goteto wua pua wandakali moyo ando atalane lo mana mola-angi, balato mana wambanepi, wenenepi, lapotaka wandakali tupa mana lamaiyane. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisasato pii kokoli utupane lamai koyo piyu, yuu okone tepa alu pea. ");
INSERT INTO ipi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","56","Yuu okone tepa alu, balana yuu tene okona poto, yakamana lotu anda okona pea. Poto, mana lamawua atea-kola, wandakali tupamane moko wete loto, pii lalawa puato, akali oko bala kamanda okona iwanane pia oko andeyama leai. Bala angini oko Matiya. Jemesapi, Josepi, Saimonepi, Jutasapi, utupane balana amene tupa ateyai. Balana imalini tupa pitaka nanima towa atu wali pitiyamae pia oko yako. Akali okomane pii mana utupa ani tawe meae-yape. Balato tai-lene andane oko ani tawe moto, metekolo piape andane tupa piyanepe leai. ");
INSERT INTO ipi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wuane loto, utupane-mane bala towa yamapane koo paleai-kola, Jisasato utupane lamawuato, potopesa akali mindimane piape peya-kola, balana yuu tene okona atalaini wandakali tupapi, balana anda okona atalaini wandakali tupapi, utupane-mane balana gene oko na-lalaini tekeko, yuu waka pitakana wandakali tupamane balana gene oko laiyu lalaini lea. ");
INSERT INTO ipi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Balana yuu tene okona tane wandakali tupamane bala lo bilipi naleai-kola, Jisasa bala yuu okonena atoto, metekolo piape tai-lene kambua pii napene, konda ya. ");
INSERT INTO ipi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Okone angi, wandakali minditupa-mane pii temane loto, Jisasato metekolo piape tupa pua ateya leai-kola, gapomane akali andane Etoteto pii okone ale yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ale wato, balato balana piape akali tupa lamawuato, metekolo piape pua ateya akali okone bala ipa peya-maiyane akali Jone yalua. Goteto bala malinga ika laya wato, minu tai laya ya-kola, balato katulo metekolo piape utupane pua atalua leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Etoteto Jone peyo ome leane okona tene oko andipa nambato yakama langeyo. Wamba Etoteto bala amene Pilipina wetene Etoti-yasa lene oko tondo moto, kee lea-kola, Joneto Etote lamawuato, nimbato wanda oko tondo moto, kee lalu atele okomane Gotena loo oko angowa atele okonde lo lamaiki peaipia. Wuane lo lamaiki pea-kola, Etoteto Jone peyo ome lokale nembo teane tekeko, wandakali kambua-mane Jone bala potopesa akali mindi ateya nemboto ateainipia. Tene okonena, Etoteto utupane ando yuku wato, Jone peyo ome nalene, mee andi loto, katapusa anda okona aindaka leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Matili alu mindi Etote angini-mane bala mandeane oto oko epea-kola, wandakali kambua epoto, bala towa atu tomo no peteaini-pia. Tomo no peteai-kola, Etoti-yasa wanane oko bala epoto, wandakali utupanena tombenenga atoto, danisa lea-kola, Etote bala epele-mane omeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Epele-mane omoto, balana weno minuto, potomisa pii mindi wana okone lamawuato, nimbato minditaka mindi gii leendo, enene wete nambato okone gukale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wuane lea-kola, Etoti-yasato balana wanane okone lamawuato, nimbato Etote lamawuato, ipa peya-maiyane akali Jonena kawane oko pelesa andane mindina yata wato, onga awua epoto, namba gii lo bala lamai leaipia. Wuane lea-kola, wana okonemane Etote lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Lamaiya-kola, kiŋi Etote bala yamapane kenda yane tekeko, wamba wandakali kambua alewa peteai-kola, balana weno minuto, nimbato minditaka mindi gii leendo, enene wete nambato okone gukale leane oko nembo teaipia. Wuane nembo toto, balato akali mindi lamawuato, nimba katapusa andaka poto, ami yanda yene mindi ando, nimbato Jonena maa pai loto, balana kawane mo awua ipu lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wuane lea-kola, akali mindimane Jonena kawane pelesa andane mindina yata wato, awua epoto, wana oko mayaepia. Maya-kola, wana okonemane Jonena kawane oko awua poto, balana angini oko mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wuane pea-kola, Jonena disaipolo tupa epoto, balana umbaini oko mo mali piyu, Jisasa ateanga poto, bala lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jonena disaipolo tupamane Jone omapia leai-kola, Jisasato ale alu, sipi mindina pitiyu, yuu okone tepa alu, wandakali napalene yuu mindina bala angu pokale nembo toto, peane. Wuane tekeko, wandakali tupamane bala yuu okonena poyale peya ale wato, tano tupa tepa alu, asini poto, yuu bala poyale peane okonena peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisasa bala sipi oko tepa alu, ipa matenenga pea-angi, wandakali kambua wete epo ateainga andoto, ondo wato, utupanena siki tupa mo atu ya. ");
INSERT INTO ipi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ole lea-kola, balana disaipolo tupamane bala ateanga poto, bala lamawuato, wandakali napalene yuu okona ateyama-kola, andipa ole leya-ko. Wandakali utupa tano aŋako tupana poto, yakamana ulia nolane tupa kambolo peakalenga, nimbato utupane peakale laa leai. ");
INSERT INTO ipi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wuane leai-kola, Jisasato utupane lamawuato, wandakali utupane-mane tomo kambolo polane tene mindi ata napeya-ko. Yakamato utupane tomo neakale mayapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wuane lea-kola, utupane-mane bala lamawuato, nanimanga betesa yau, pisa lapo angu eyama okonde leai. ");
INSERT INTO ipi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wuane leai-kola, balato tomo utupane mo awua ipulupa lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tomo utupane awua epeai-kola, balato wandakali tupa lamawuato, yakama tani tupana pitiyapa lea. Peteai-kola, balato betesa yau tupapi, pisa lapo okolapopi, utupane moto, ati kenga andaiyu loto, Gote wayu pele loto, betesa tupa konde lea. Konde loto, balana disaipolo tupa maya-kola, utupane-mane tomo tupa tale puato, wandakali tupa neakale mayai. ");
INSERT INTO ipi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Mayai-kola, wanda andopane ima dii nalene, akali angu tausene yaupi mindi tomo utupane neai. Wandakali utupane pitaka-mane no embo yai-kola, balana disaipolo tupamane akenane yane tupa moto, basaketa nuu alesa mandu tumbi laya wato, yata yai. ");
INSERT INTO ipi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Okone angi teke, Jisasato balana disaipolo tupa lamawuato, nambato wandakali tupa peakale lokalenga, yakama sipi okona peakaiyu lo pitiyu, ipa angini okona amo-yangi ingane pulupa lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wuane lalu, balato wandakali kambua ateaini tupa pulupa lalu, bala angu yuu wangiane mindina pote lolo peaipia. Undupi lea-kola, bala angu wangiane okonena ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Balana disaipolo tupa sipi okona pitiyu, ipa matene oko tepa alu, ipa angini okona tombenenga peai wete, utupane poyale peaini ukusane ato popo andane mindi lo awua epeane okonemane ipa taimane awua ika laka puato, sipi okone mo mindisa aimo laka piki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Matili yuu waa loyale muna pea-angi, Jisasato utupane peteaini sipi okona epoyale, ipa angini okonena tokonga kee atama epea. ");
INSERT INTO ipi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bala utupane mandaka epea-kola, balana disaipolo tupamane bala ipa angini okona tokonga kee atama epeanga andoto, yama mindi epeya loto, yuku-mane omoto, taimane kalae leai. ");
INSERT INTO ipi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kalae leai-kola, Jisasato utupane wamba kapoyale lamawuato, namba Jisasa epeyo-ko. Yakama yuku naene, mini palu pitiyapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wuane lea-kola, Pitato bala lamawuato, Akali Andane nimba teke epeendo, nimbato namba ipa okona tokonga kee atama nimba atelenga ipu laa lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wuane lea-kola, Jisasato nimba ipu lea wete, Pita bala sipi okone tepa alu, ipa okona tokonga kee atama Jisasa ateanga poyale pea. ");
INSERT INTO ipi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Balato poyale peane tekeko, popo andane leane oko andoto, bala yuku wato, ipa pangosa poyale poto, Akali Andane nimbato namba moya pii taimane lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wuane lea-kola, Jisasato Pita wamba ini kapoyale minata wato, anu peakale nimbato namba lo bilipi leyo nayu nalene, nembo lapo palelepe lea. ");
INSERT INTO ipi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Liyamba sipi okona peakaiyu leapi-kola, popo andane leane oko tepa ya. ");
INSERT INTO ipi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tepa ya lo andoto, sipi okona peteaini akali tupamane bala lo lotu loto, enene wetete, nimba Gotena iwanane atele leai. ");
INSERT INTO ipi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisasapi, balana disaipolo tupapi, utupane yakama ipa angini okona amo-yangi poto, Genesa-leta yuu okona peakaiyu leai. ");
INSERT INTO ipi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Peakaiyu leai-kola, yuu okonena tane wandakali tupamane akali epeya oko bala Jisasa ya lo andeai. Andoto, Utupane-mane Jisasa epo ateya lo yuu mandaka yane tupa pitakana wai laka peai-kola, wandakali-mane utupanena yangone siki pelene tupa pitaka awua epeai. ");
INSERT INTO ipi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Awua ipulu, utupane-mane Jisasa lamawuato, wandakali siki pelene tupamane nimbana tona duninga wata yakale lo nimbato ando kondape leai. Jisasato katu yalua lea-kola, bala wataka peaini wandakali tupa pitakana siki tupa atu yaka pea. ");
INSERT INTO ipi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Okone angi, loo tupana mana andene akali tupapi, Patasai tupapi, utupanena minditupa Jutusaleme tepa alu, Jisasa ateanga epeai. Utupane-mane bala lamawuato, Gotena wenonga nanimana yumbane tupana kii kalato atene guu naleakale nembo toto, utupane-mane kini wasa-wasa ini peyoto, tomo nalaini mana mindi yata yaini-ko. Anu peakale nimbana disaipolo tupamane mana okone wato mina napene kondeyaipe leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, anu peakale yakamato yumbane tupana mana mindi wato minuyale, Gotena loo mindi kalo piyainipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wamba Goteto loo okone yata wato, nimbana angini, ayiane-la, okone-lapona pangosa atoto, nimbato okone-lapona pii ale amawua atape leaipia. Dee, wandakali mindimane balana angini yandopi, ayiane yandopi, okone-lapona mindi ando pii koo mindi leando, yakamato bala peyo ome lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Goteto wuane leane tekeko, yakamato wuane na-piyaini. Jia. Yakamato loto, wandakali mindimane balana angini yandopi, ayiane yandopi, okone-lapona mindi moyo minditaka maipe-pene guleya-kola teke, okonelapo lamawuato, nambato liyamba moyo minditaka gipe-pene tupa Gote mauyale mandeke pua yata ewa lalu, balato okonelapo moya napene konda yando, okone katu lalaini. Yakamato wuane lalaini okonemane yumbane tupana mana tupa wato minuyale, Gotena pii layene oko mo mee gulaya alaini. ");
INSERT INTO ipi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yakamato wuane piyaini mana okonemane yakamana yangone tupa minakasa alaini wandakali gulo atalaini. Wamba potopesa akali Aisayato yakamana mana okone wayumane nembo toto, wua leaipia: ");
INSERT INTO ipi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Wandakali utupane yakamana ambulini-mane nambana gene oko laiyu lalaini tekeko, yakamana nembo-tene, yamapane-la, okonelapo nambanga yaa napene, amonga waka gulo atalaini. ");
INSERT INTO ipi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wamba yakamana yumbane-mane mana minditupa yata yai-kola, yakamato mana utupane wandakali tupa lamawuato, Gotena loo tupa mana langeyama lalaini. Wuaneko, utupane-mane namba lo lotu lalaini mana okonemane dini angini mindi liya napiyane. Wamba potopesa akali Aisayato wuane leane lo Jisasato pii okone lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wandakali kambua amunguli peai-kola, Jisasato utupane mandaka ipulupa lea. Epeai-kola, balato utupane lamawuato, yakamato nambana pii ale wato, wayumane nembo talapape lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wandakali-mane minditaka mindi nee asianga mo aindaka loto, nalaini okomane wandakali okone Gotena wenonga mo kalato ataya na-alane. Jia. Minditaka mindi wandakalina nee asianga ato kamaka epalane tupamane Gotena wenonga bala mo kalato ataya alane lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jisasato wuane lea-kola, balana disaipolo tupa epoto, Patasai tupamane nimbana pii okone ale wato, nimba towa yamapane koo paleyai oko nimbato andelepe leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Wuane leai-kola, balato utupanena pii okone yano peyoto, nambana ayiane oko bala ati kenga atoto, balana ee oko ando atalane lea. Balato minditaka yanda napeya-kola, mee ika leando, balato utupane pitaka pini towa lopalane. ");
INSERT INTO ipi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Patasai tupa lee koo gulo atoto teke, asia epene tupa wandakali waka tupa andawa lamakale nembo talaini tekeko, wandakali lee koo mindimane lee koo yangone mindi asia andawa loyale, atu peapindo, wandakali okonelapo lapotaka kundu mindina aiya peyolo-peyapiko. Patasai utupane-mane namba towa yamapane koo paleakale lo yakamato ando kondalapa. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wuane lea-kola, Pitato bala lamawuato, nimbato pii kokoli wamba lale okonena tene oko nanima langi lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wuane lea-kola, Jisasato balana disaipolo tupa tipa puato, yakamapi wai naene atoto, pii kokoli okonena tene oko nembo nateyaipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Minditaka wandakalina nee asia okona aindaka leyai tupa pitaka ini anda-pango okona poto paleya-kola, ii too apialaini oko yakamato nembo nateyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","20","Wandakali mindimane kii wasa-wasa napelene, tomo nalu, matili balato tomo okone ii too apialane. Tene okonena, kii wasa-wasa peya napene tomo nalane mana okonemane Gotena wenonga bala mo kalato ataya na-alane. Wuane tekeko, minditaka wandakalina ambulininga ato kamaka epalane tupamane Gotena wenonga wandakali tupa mo kalato ataya alane. Anu peakale nambato wuane leyope. Wandakali-mane nembo koo toto, wandakali mindi peyo ome lokale, yangone mindi ando owato pii lokale, yangone mindi layangokale, minditaka pake nokale, pamuku pukale nembo talaini. Nembo-tene koo utupane pitaka wandakalina yamapanenga paleya-kola, balato nembo-tene koo utupane wato minukale nembo talaini mana okomane Gotena wenonga bala mo kalato ataya alane. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisasa bala yuu okone tepa alu, Taya, Saitone-la, tano okonelapo mandaka yuu mindina pea. ");
INSERT INTO ipi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yuu okonena pitiyane Kenane tane wanda mindi Jisasa ateanga epoto, pii taimane loto, sipitisa koo mindimane nambana wanane oko wete minu koyalane-ko. Kiŋi Dapiti yame Akali Andane, nimbato namba ondo wato, moyape lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wanda okonemane wuane laka pima epea-kola teke, Jisasato balana pii okone yano peyo, pii mindikipi mindi lamai napene konda ya. Konda ya-kola, Jisasana disaipolo tupamane Jisasa lamawuato, wanda okomane nanima watama epoto, pii taimane laka peya-ko. Bala nanima tepa alu peakale. Nimbato bala lamai leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Wuane leai-kola, Jisasato wanda okonena pii okone yano peyoto, Goteto namba languato, yia sipisipi alu pene gulo Isatale tane wandakali ateyai tupa angu moyolo puu leane lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jisasato wuane leane tekeko, wanda okone bala Jisasa ateane ongane epoto, aikini leka wato, Akali Andane, nimbato namba moya lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Namba moya lea-kola, Jisasato lapeke loto, nambato andopane tupana tomo tupa moto, peango tupamane neakale lo peya-amo lewando, kuai nalolo-peya lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wuane lea-kola, wanda okonemane lapeke loto, Akali Andane, nimbato enene lele tekeko, akali andane mindimane tepolo tokonga tomo no peteya-kola, balana peango tupa toko pangosa atoto, tomo pulu-lene tepa eya tupa nalaini lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wuane lea-kola, Jisasato bala lamawuato, wanda nimbato namba lo bilipi leyo nayu lele-ko. Nambato nimba moyo pingipia lakae lo nembo tele pua pingeyo lea. Wuane lea-kola, okone angi teke wanda okonena wanane okone atu ya. ");
INSERT INTO ipi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisasa bala yuu okone tepa alu, Galili ipa angini okona mandaka ongane poto, yuu wangiane mindina puu iyu lalu, petea. ");
INSERT INTO ipi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Petea-kola, wandakali siki pelene tupa atu aiyu epoto, wandakali kambua longo bala peteanga epo amunguli peai. Utupane-mane wandakali kee koopi, kulini wuanga-penepi, lee koopi, pii na-lalainipi, dee wandakali siki waka-waka pelene kambua atu aiyu epoto, Jisasana kee yane ongane yata aka peai-kola, balato utupane pitaka mo atu yaka pea. ");
INSERT INTO ipi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mo atu yaka pea-kola, pii na-lalaini wandakali tupamane pii lalu, kulini wuanga-pene tupa mo tika piyu, kee koo tupa asia pulu, lee koo tupa lee talu, peai-kola, wandakali kambua ateaini tupamane andeai. Andoto, utupane moko wete loto, Isatale tane tupana Gote okona gene oko laiyu leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Okone angi Jisasato balana disaipolo tupa ipulupa loto, pii mindi utupane lamawuato, wandakali utupa namba towa ole tepoai atalai-kola, utupane ulia nolane naeya lea. Nambato utupane ulia naa napene, mee andaka peakale lewando, utupane asininga ulia nono wato, lemowa malawai lo lomba-pene yolaini lo ondo piyua-ko. Nambato utupane ulia nanene mee peakale na-lokale lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wuane lea-kola, balana disaipolo tupamane bala tipa puato, wandakali napalene yuu okona ateyama-ko. Nanimato betesa kambua wete ani tawe moto, wandakali kambua wetete utupa neakale malu-peyamape leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wuane leai-kola, balato utupane tipa puato, yakamanga betesa aki-tupi eyape lea. Wuane lea-kola, utupane-mane betesa yanasa tupa towa pisa aŋalapo nanimanga eya leai. ");
INSERT INTO ipi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wuane leai-kola, balato wandakali tupa lamawuato, yakama yuunga pitiyapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Peteai-kola, balato betesa yanasa tupapi, pisa tupapi, utupane moto, Gote wayu lalu, utupane konde lea. Konde loto, balana disaipolo tupa maya-kola, utupane-mane tomo utupane tale puato, wandakali tupa neakale mayai. ");
INSERT INTO ipi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Mayai-kola, wanda andopane ima dii nalene, akali angu tausene tukumindi-mane tomo neai. Wandakali utupane pitaka-mane no embo yai-kola, Jisasana disaipolo tupamane tomo akenane yane tupa mo yomo wato, basaketa nuu andane yanasa tumbi laya wato yata yai. ");
INSERT INTO ipi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yata yai-kola, Jisasato wandakali utupane pitaka pulupa lalu, bala sipi mindina peakaiyu lo pitiyu, Makatana yuu okona pea. ");
INSERT INTO ipi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Matili Patasai tupapi, Satusi tupapi, utupane-mane Jisasa ateanga epeai. Bala minu mandeke puyale, utupane-mane bala lamawuato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loyale, nimbato ati kenga tawe metekolo piape mindi pula leai. ");
INSERT INTO ipi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Utupane-mane wuane leaini tekeko, balato utupanena pii okone yano peyoto, ole-lene nai oko andaka peya-kola, ati ate pele peya-kola, yakamato utupane yapa lo andoto, anati panyu pulupeya ya lalaini lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dee, upa pitane, mole yoto, yuu undupi leando, yakamato mole utupane yapa lo andoto, andipa popo loto, kingi epolopeya ya lalaini. Yakamato mole okonepene eya oko andoto, wua pulupeya ya lo kuai lo yapa lalaini-ko. Anu peakale yakamato mangene nambato pua ateyo tupa andoto, wua pulupeya ya lo katulo yapa naleyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wandakali yame koo andipa ateyai tupa yakamato Gote enene oko awua tepa alu, gote waka tupanga tungi peyo bilipi lalaini okomane yakama pamuku piyaini wandakali gulo ateyai. Yakamato namba languato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loyale, metekolo piape mindi pula lalaini tekeko, nambato metekolo piape mindi andipa napukale. Jia. Wamba Goteto potopesa akali Jona balanga metekolo piape peane okonepene mindiki angu nambato matili pukale. Wuane lalu, Jisasa bala utupane tepa alu pea. ");
INSERT INTO ipi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisasana disaipolo tupa bala towa ipa angini okona amo-yangi poyale peai-angi, utupane-mane betesa mo mandi napene, embesa yai. ");
INSERT INTO ipi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Embasa yai-kola, Jisasato utupane lamawuato, Patasai tupapi, Satusi tupapi, utupanena palawa yangalaini pauta okomane yakama mo lawa piya olane. Waiwa ando atalapape lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wuane lea-kola, balana disaipolo tupamane ale apulu, yakama teke-teke pii lalawa puato, nanimato betesa mo mandi napene, mee epalama okonena, balato wuane leya leai. ");
INSERT INTO ipi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wuane leyai nembo toto, Jisasato utupane tipa puato, anu peakale yakamato betesa mandi na-piyama loto, yakama teke-teke pii lalawa pua ateyaipe lea. Nambato katulo betesa yakama gii napulu-peya nayuto, yakamato nambanga wayumane tungi peyo ata napeyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Wamba nambato betesa yau angu tale puato, akali tausene yau tupamane no embo yakale maewa-kola, yakamato akenane yane tupa basaketa nuu alesa tumbi laya wato, yata yai oko embesa eyaipe. Dee, nambato betesa yanasa angu tale puato, akali tausene tukumindi tupamane no embo yakale maewa-kola, yakamato akenane yane tupa basaketa nuu wataka tumbi laya wato, yata yai oko embesa eyaipe. Pii nambato leyo oko yakamato tatake eyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nambato betesa enene andayo pii naleyo-ko. Anu peakale yakamato wuane nembo nateyaipe. Nambato pii kokoli mindi yakama languato, Patasai tupapi, Satusi tupapi, utupane-mane mana langulai tupa palawa yangalaini pauta gulo yoto, yakama mo lawa piya olane. Waiwa ando atalapape leyo okoni. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wuane lea-kola, balana disaipolo tupamane palawa yangalaini pauta okomane nanima mo lawa piya olane Jisasato naleya nembo teai. Patasai tupapi, Satusi tupapi, utupane-mane nanima mana langulai okone palawa yangalaini pauta gulo yoto, nanima mo lawa piya olane. Waiwa ando atalapape leya nembo teai. ");
INSERT INTO ipi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisasa bala Sisatiya Pilipai tano okona mandaka poto, balana disaipolo tupa tipa puato, wandakali-mane Akalina Iwanane namba andayo api ateya lalainipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wuane lea-kola, utupane-mane bala lamawuato, wandakali minditupa-mane nimba ipa peya-maiyane akali Jone atele lalaini leai. Minditupa-mane nimba Ilainja atele lalaini. Minditupa-mane nimba Jetemaya yandopi, potopesa akali waka mindi yandopi, utupanena mindi atele lalaini leai. ");
INSERT INTO ipi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wuane leai-kola, Jisasato utupane lamawuato, utupane-mane wuane lalaini tekeko, yakamato namba andayo api ateya lalainipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Wuane lea-kola, Saimone Pitato balana pii okone yano peyoto, nimba Gote saka atapowa atalane okona Iwanane Mesaya oko atele lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wuane lea-kola, Jisasato bala lamawuato, Jone iwanane Saimone, yuu okona wandakali mindimane namba Gote Iwanane Mesaya oko ateya lo nimba andawa naleya lea. Nambana Ayiane ati kenga ateya okomane namba Gote Iwanane Mesaya oko ateya lo nimba andawa langeya-ko. Nimbato epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Andipa nambato pii mindi nimba langeyo. Akali mindimane anda mindi ana tokonga peando, anda okone tai atolopeya. Wuane pua teke, nambana yame tupa tai ateakale, nimbato ando atola loto, nambato nimbana gene mindi Pita geyo. Nambana yame utupane tai gulolai-kola, wandakali omalaini mana okona tai-lene okomane katulo nambana yame oko minu koya wete napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nambato wandakali moyo ando atalawane kii tupa nimba gukale. Nimba yuu okona atoto, kii utupane-mane asini mindi loko peleendo, ati kenga ateya Gote okomane asini okone loko peyola-kola teke pulupeya. Dee, nimbato yuu okona atoto, kii utupane-mane asini mindi lumbu tepa eendo, ati kenga ateya Gote okomane asini okone lumbu tepa olo-kola teke pulupeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wuane lalu, Jisasato balana disaipolo tupa pii mindi lamaiyo nayu lamawuato, namba Mesaya oko ateya lo yakamato wandakali mindikipi mindi lamai na-piyapape. Jia wete lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Okone angi, Jisasato pii wenene mindi balana disaipolo tupa bulupane tewa lamawuato, namba Jutusaleme pupe-pene guleya lea. Polowa-kola, Juta yame ando atalaini akali tupapi, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane namba kosimi lolai-kola, namba tandaka kambua nape-pene guleya. Akali-mane namba peyo ome lolai-kola, ole tepo penenga, Goteto namba malinga ika laya olopeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wuane lea-kola, Pitato Jisasa atu aiyu amonga yale poto, bala laiya loto, Akali Andane, Goteto nimba ondo wato moyola-kola, matili-matilipi kenda-pene okone nimbanga na-epeakale lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wuane lea-kola, Jisasato mopeke loto, Pita andata wato, nimbato Gotena nembo-tene oko wato minuto nalele lea. Nimbato wandakalina nembo-tene wato minuto, nambana polane asini oko kando lokale nembo toto, Satane gulo pii okone lele-ko. Nimba nambana masianesa puu lea. ");
INSERT INTO ipi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","26","Wuane lalu, Jisasato balana disaipolo tupa tipa puato, wandakali mindimane yuu okona minditaka eya tupa pitaka mialu, bala saka atapowa ata napeando, matili balana minditaka utupane pitaka-mane anu puato bala moyolo-peyape lea. Balato aki mindi mawuato, balana saka atapowa atolane oko kambo molo-peyape. Wandakali mindi bala omolowane lo yuku wato, nambana yame ata napeando, bala saka atapowa ata napulu-peya. Wuane tekeko, wandakali mindi bala namba yame atola oko andoto, wandakali-mane bala peyo ome leaindo, bala saka atapowa atolo-peyako. Wandakali mindimane namba polowa okona epokale nembo teando, bala tane nembo natene, kenda-pene balanga epola tupa balana ita malamanda gulo yola oko mo awua, namba watama ipupe-pene. ");
INSERT INTO ipi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anu peakale nambato wuane leyope. Matili Ayiane Gotena tai-lene andane oko Akalina Iwanane okonga yola-kola, balana enjole tupa towa atu epolopeya. Epoto, balato wandakali pitakana mana minalaini tupa nembo toto, utupane mindiki-mindiki lo yole epene yandopi, yole koo yandopi, mindi malupeya. ");
INSERT INTO ipi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nambato pii enene mindi yakama langeyo. Matili wandakali oo ateyai utupanena minditupa wamba ini oma napene andolai-kola, Akalina Iwanane oko bala akali andane kiŋi mindi gulalu epola-kola, utupane-mane andolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ole wataka pea-kola, Jisasato Pitapi, Jemesapi, Jemesa amene Jonepi, utupane atu aiyu yuu wangiane kenga wete mindina iyu poto, yakama angu ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Utupane yakama angu ateai-kola, Jisasana tona peane tupa ake wete puato, tii pikoyo peaipia. Dee, nai-lene tii wete piyane pua, balana lee-ingapi tii wete pea-kola, bala waka guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Waka gulea-kola, Mosesa Ilainja-la, okonelapo panakame epoto, Jisasa towa atu pii lalawa pua ateai-kola, Jisasana disaipolo tepo tupamane okonelapo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Andoto, Pitato Jisasa lamawuato, Akali Andane, nanima yuu okona ateyama-kola, kuai leya-ko. Nambato anda aiyakame tepo pipia lakae lo nimbato nembo teendo, aiyakame tepo utupanena mindi nimbana, mindi Mosesana, mindi Ilainjana pingukale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitato pii okone lo atea-kola, mole tii-pene wete mindi epoto, akali utupane yame peyo, ombo yaepia. Ombo ya-kola, mole okonena tombenesa ato pii leane mindimane loto, akali oo ateya oko bala nambana iwanane yamapane yene oko ateya leaipia. Nambato balana mana tupa andoto, epele wete alawane. Yakamato balana pii oko ale amai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wuane lea-kola, balana disaipolo tupamane pii okone ale wato, yakama yuku wete wato, yuunga tombawua leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tombawua lo yai-kola, Jisasa epoto, balana kini-mane utupane wata wato, yakama yuku naene, ika lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jisasato wuane lea-kola, disaipolo tepo utupane-mane andeai-kola, akali waka mindi Jisasa towa ata napeaipia. Jia. Bala angu yakama towa atu ateanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jisasa balana disaipolo tepo utupane towa atu yuu wangiane okone tepa oyale, asini puu nena loto, balato utupane pii lamaiyo nayu lamawuato, yakamato minditaka andalai oko wandakali mindikipi mindi lamai napene atama pulu, matili Akalina Iwanane oko malinga ika lola-angi, yakamato wandakali tupa lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wuane lea-kola, disaipolo utupane-mane Jisasa tipa puato, Akalina Iwanane oko malinga ika lalu, wamba ini epolopeya yando, anu peakale loo tupana mana andene akali tupamane loto, potopesa akali Ilainja wamba ini ingane yuunga peke lola-kola, Akalina Iwanane oko matili ipupe-pene lalainipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, enene, Gotena pii pepa pelene eya mindimane loto, matili Ilainja bala epoto, Akalina Iwanane oko epeakale lo minditaka kambua mo tika pulupeya layene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gotena pii okonemane wuane leya tekeko, Ilainja bala wamba epea-kola, wandakali-mane akali okone bala Ilainja ya lo anda napeaini lo nambato yakama langeyo. Bala Ilainja ya lo anda napene, utupane-mane balanga mana koo mina-makale nembo teaini tupa pitaka balanga miniaini-pia. Wuane pua teke, wandakali-mane Akalina Iwanane oko balanga mana koo minditupa minulai-kola, bala tandaka nolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wuane lea-kola, balana disaipolo tupamane ale wato, balato ipa peya-maiyane akali Jone oko andayo wuane leya nembo teainipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wandakali kambua amunguli pua ateai-kola, Jisasapi, balana disaipolo tepo tupapi, utupane epo peakaiyu leai. Peakaiyu leai-kola, akali mindi bala Jisasa ateanga epoto, aiki leka ya. ");
INSERT INTO ipi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","16","Akali okonemane Jisasa lamawuato, Akali Andane, ole kambuanga nambana iwanane oko peango-ngo puato, aiya peyoto, ipanga pulu, itanga talu, peya-kola, balana umbaini oko koyalane lea. Nambato bala nimbana disaipolo tupa atalainga atu polo tekeko, utupane-mane bala katulo mo atu nayalai-ko. Nimbato bala ondo wato, mo atu yaa lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wuane lea-kola, Jisasato pii mindi loto, wandakali yame koo andipa ateyai tupamane kuai lo nembo natene, mana koo tupa minuto, Gote lo bilipi na-lalaini lea. Ole aki-tupinga namba yakama towa atokale yape. Dee, ole aki-tupi nambato yakamana kenda-pene tupa awua ata gukalepe. Iwana okone atu aiyu namba ateyonga ipulupa lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Utupane-mane iwana okone atu aiyu Jisasa ateanga epeai-kola, Jisasato iwana okonenga sipitisa koo ateane oko laiya loto, puu lea-kola, sipitisa koo okonemane iwana okone tepa alu, peaipia. Pea-kola, okone angi teke iwana okonena siki okone atu ya. ");
INSERT INTO ipi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Atu ya-kola, matili disaipolo tupa yakama angu Jisasa ateanga epoto, bala tipa puato, anu peakale nanimato sipitisa koo okone katulo peyo wata na-piyamape leai. ");
INSERT INTO ipi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wuane leai-kola, balato utupane lamawuato, yakamato Gote bilipi leyama nayu naleyai mambele, yakamato katulo sipitisa koo okone peyo wata napiyai lea. Nambato pii enene mindi yakama langeyo. Yakamana bilipi oko aŋako mee komba dini okopene angu yando, okone katu teke. Yakamato Gote mee teke bilipi leaindo, yakamato mangene minditupa pimakale nembo tolai tupa pitaka katulo pulupeyai. Yakamato yuu wangiane oo eya oko lamawuato, nimba lopalu, amonga peyolo puu leaindo, yuu wangiane okone katulo lopalu, amonga peyolo polopeya. ");
INSERT INTO ipi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yakamato Gote angu nembo tamakale loto, ole ukupini mindi tomo nanene atoto, Gote lo pote lapiai-yale, yakamato sipitisa koo okonepene tupa katulo peyo watapiai-yale. Sipitisa koo okonepene peyo watolane asia waka mindi naeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Alu mindi Jisasana disaipolo tupa Galili disitiki okona amunguli peai-kola, balato utupane lamawuato, akali mindimane Akalina Iwanane oko ene pituto, bala towa yanda-pene akali tupana kininga maulupeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Maula-kola, akali utupane-mane bala peyo ome lolopeyai. Bala omalu, ole lapo mali pitane atola-kola, ole teponena, Goteto bala malinga ika laya olopeya lea. Wuane lea-kola, balana disaipolo tupamane mini kenda wete yai. ");
INSERT INTO ipi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Matili Jisasa balana disaipolo tupa towa Kapaneame tano okona peakaiyu leai-angi, lotu anda andane okona takisa muni mialaini akali tupa Pita ateanga peainipia. Poto, utupane-mane Pita tipa puato, yakamana tisa okomane lotu anda andane okona takisa muni peyalanepe, peya na-piyanepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wuane leai-kola, Pitato utupane lamawuato, uli, balato takisa muni okone peyalane leaipia. Wuane lalu, Pita bala anda Jisasa ateane okona kolandaka loto, pii mindi lata naya-kola teke, Jisasato pii mindi Pita tipa puato, Saimone, nimbato aki nembo telepe lea. Yuu okona kiŋi tupamane apinga takisa muni mialainipe. Utupane-mane yakamana iwanane tupa lamawuato, takisa muni giyapa lalainipe. Pee, utupane-mane wandakali yame waka tupa lamawuato, takisa muni giyapa lalainipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jisasato wuane lea-kola, Pitato balana pii okone yano peyoto, yuu okona kiŋi tupamane wandakali yame waka tupa lamawuato, takisa muni giyapa lalaini tekeko, yakamana iwanane tupamane takisa muni geakale na-lalaini lea. Wuane lea-kola, Jisasato utupane lamawuato, kiŋi tupana andopane tupamane takisa muni bala mai na-piyaini okonena, namba Gotena iwanane okomane namba ayiane okona lotu anda andane okona takisa muni mai napipe-pene. ");
INSERT INTO ipi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mai napipe-pene tekeko, nanimato akali utupane mo yataka olomane. Nimba ipa angini okona poto, pisa mialaini uku mindi aindaka lape. Pisa bulupane mole okonena nene minu angatawa puato, muni mindi pangula oko ando molopele. Moto, nalipana takisa peyoto, akali utupanenga maipe. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Okone angi teke, Jisasana disaipolo tupamane bala ateanga poto, bala tipa puato, Goteto balana wandakali tupa moyo ando ateya tupana gene andane wetete apina eyape leai. ");
INSERT INTO ipi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wuane leai-kola, Jisasato andopane mindi epeakale loto, balana disaipolo tupana tombenenga ata lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","Andopane okone epo atea-kola, Jisasato balana disaipolo tupa lamawuato, andopane oo ateya oko bala tane wandakali waka tupana napinga ateyo nembo teya. Wuane pua teke, Gotena wandakali mindi bala tane Gotena wandakali waka tupana napinga ateyo nembo teando, Gote ati kenga ateya okomane wandakali okonena gene andane wete eya lolopeya. Wuaneko, yakama gene yene ateyama nembo talaini mana oko lawa puato, andopane tupamane wandakali waka tupana napinga ateyama nembo talaini pua yakamato nembo tape-pene. Nambato pii enene mindi yakama langeyo. Yakama tane wandakali waka tupana napinga eyama nembo nateaindo, matili-matilipi Gote ati kenga ateya okomane yakama moyo ando ata napulu-peya. Jia wete. ");
INSERT INTO ipi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wandakali mindimane namba lo nembo toto, andopane oo ateyo okopene mindi moyando, balato namba moyola-kola teke pulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, wandakali minditupa-mane utupanena yangone tupamane koo peakale lo mo piya eyai-kola, utupane-mane mana koo tupa wato minalaini lea. Utupane-mane wuane piyaini okonena, wandakali pitaka ondo ape-pene tekeko, koo peakale lo mo piya alaini wandakali tupamane yole koo wetete mindi molopeyai nembo toto, utupane ondo wete ape-pene. Tene okonena, andopane oo ateyai utupana mindimane nambanga tungi peyo ateya-kola, andopane okonemane koo peakale lo wandakali mindimane bala mo piya oyale peando, wandakali okonemane wuane napeakale nembo toto, akali minditupa-mane ana andane mindi wandakali okonena manenga andi loto, ipa solewata angini okona tombenenga wete awua aindaka leaindo, andopane okonemane koo peakale lo balato katulo mo piya na-olopeya. Wuane napula-kola, Goteto yole koo wetete yuku-pene mindi wandakali okone mai napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nimbana kinipi, kenepi, lapotaka atene atole-kola, Goteto nimba ita too atapowa atene yuu koo okona awua aindaka leando, nimba kopeta wete atolo-peleko. Nimbana kini yandopi, kene yandopi, utupanena mindimane nimbato koo pula lo mo piya oyale peando, nimbato okone pai lo apiape. Pai lo apialu, nimbana kini yandopi, kene yandopi, mindiki angu atene atoto, nimba saka atapowa kuai lo wete atolopele. ");
INSERT INTO ipi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dee, nimbana lene lapotaka tene atole-kola, Goteto nimba ita too atapowa atene yuu koo wetete okona awua aindaka leando, nimba kopeta wete atolopele-ko. Nimbato koo pula lo nimbana lene okomane mo piya oyale peando, nimbato lene okone luku apiape. Luku apialu, nimbana lene mindiki angu tene atoto, nimba saka atapowa kuai lo wete atolopele. ");
INSERT INTO ipi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Akalina Iwanane okomane wandakali alu pitane ateyai tupa molo-peke lolo epea. Wuaneko, nambato pii kokoli mindi yakama langeyo. Enjole minditupa ati kenga atoto, ole dindi lo nambana ayiane ati kenga ateya oko towa atu atoto, andopane oo ateyai utupa moyo atalaini-ko. Yakamato andopane utupanena mindikipi mindi bala angini mindi jia ya, bala mee ya lo nembo tolaini. Waiwa ando atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wuane lalu, Jisasato pii mindi loto, akali mindimane sipisipi (100) wane andete yatawa atola-kola, utupanena mindiki angu alu peando, balato anu pulu-peyape. Balato sipisipi (99) paiyasa pilisanga pilisa tupa yuu wangiane mindina ateakale lalu, sipisipi mindiki alu pulane okone aiya pulu polopeya. ");
INSERT INTO ipi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nambato pii enene mindi yakama langeyo. Balana sipisipi (99) paiyasa pilisanga pilisa tupa alu napulai-kola, balato epele olopeya tekeko, balato sipisipi mindiki alu pulane okone aiya puato, ando meando, bala epele wete olopeya. ");
INSERT INTO ipi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wuane pua teke, yakamana ayiane ati kenga ateya okomane andopane ateyai utupana mindikipi mindi alu napipia lakae lo nembo talane. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wuane lalu, Jisasato pii mindi tako pua loto, Kitisene wandakali mindimane nimbanga koo mindi peando, nimbato bala atolanga pupe lea. Poto, liyamba angu mindinga pituto, nimbato nambanga koo mindi wua pipini lo bala lamaipe. Lamaule-kola, balato nimbana pii lolene okone ale yando, nimbato bala molo-peke lole-kola, bala nimbana amene gulo atolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wuane pulupeya tekeko, balato nimbana pii okone ale nayando, matili nimbana wisanisa tupamane nimbana pii tupa pitaka lo tai laya yakale nembo toto, nimbato wandakali mindiki yandopi, lapo yandopi, mindi lamialu, wandakali okone atolanga atu peke lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nimbana wisanisa tupamane nimbana pii okone bala towa atu mo tika puyale makande pulai-kola, balato ale na-wakale nembo teando, nimbato sosa oko lamaipe. Amunguli pitane okomane bala towa atu pii okone lo tika puyale makande pulai-kola, balato ale na-wakale nembo teando, nimbato bala aitene wandakali mindi yandopi, takisa muni mialane akali mindi yandopi, okonepene mindi ateya nembo tape. ");
INSERT INTO ipi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nambato pii enene mindi yakama langeyo. Yakamato yuu okona atapuluto, asini mindi loko peleaindo, ati kenga ateya Gote okomane asini okone loko peyola-kola teke pulupeya. Yakamato yuu okona atoto, asini mindi lumbu tepa yaindo, ati kenga ateya Gote okomane asini okone lumbu tepa olo-kola teke pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Dee, nambato pii mindi tako puato, wandakali lapo yandopi, tepo yandopi, namba nembo toto, mindinga amunguli pulai ongane namba tane wandakali utupanena tombenenga atolo-peyawa leyo. Tene okonena, yuu okona wandakali lapo liyambato namba nembo toto, nembo mindiki paluto, nambana ayiane ati kenga ateya okomane mangene mindi peakale loto, liyambato tee lo pote leapindo, balato mangene okone pulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Okone angi, Pita bala Jisasa ateanga poto, bala tipa puato, Akali Andane, wandakali yangone mindimane ole kambuanga nambanga koo piki peando, ole aki-tupinga nambato balana koo utupane apia-maiki pukalepe. Ole kambuanga balato nambanga koo piki peando, nambato balana koo utupane ole yanasanga angu apia-maiki piyu, konda wakalepe lea. ");
INSERT INTO ipi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wuane lea-kola, Jisasato bala lamawuato, wandakali yangone mindimane ole kambuanga koo nimbanga piki peando, ole yanasanga angu nimbato balana koo utupane apia-maiki piyu, kondape lo nambato nimba langi napeyo. Jia. Balato ole kambuanga koo nimbanga piki pua atapowa ateando, ole paiyasa yanasanga balana koo pulane tupa apia-maiki piyu, balana koo pulane okone tuma teke ole yanasanga apia-maiki pua atape-pene leyo. ");
INSERT INTO ipi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anu peakale nimbato wuane pipe leyope. Wamba akali andane kiŋi mindimane balana piape akali tupa ando ateane pua teke, ati kenga ateya Gote okomane yuu okona wandakali tupa ando atalane. Wamba kiŋi okonemane yano minditupa balana piape akali tupa maiyu, matili balana muni mia-peke lokale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kiŋi okonemane piape okone tewa pua atea-angi, akali mindimane kiŋi okonena piape akali mindi lamo atu epeaipia. Piape akali epeane okone balanga yano andane kambua longo wetete kina miliyone paiyasa yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Piape akali okone balana yano andane okone peyolane muni naya-kola, kiŋi okonemane balana piape akali yangone tupa lamawuato, akali waka mindimane piape akali okonepi, balana wetene andopanepi, utupane pitaka kambola-kola, utupane-mane akali okonena katapusa piape pua ateakale leaipia. Dee, akali mindimane piape akali okonena andapi, pinjupi, minditaka eya tupa pitaka kambeakale teke. Kambola-kola, muni epola okomane piape akali okonena yano oko peleakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wuane lea-kola, piape akali okonemane kiŋi oko peteane ongane poto, aiki lekawa, bala tee lamawuato, matili nambato yano okone pitaka peyokalenga, nimbato namba towa wamba ini kapoyale yataka naene, maliyo ata-kae leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wuane lea-kola, kiŋi okomane balana piape akali okone ondo wato, balana yano oko peleakale nalene kondalu, bala mee peakale tepa yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kiŋi okonemane wuane peane tekeko, balana piape akali okone kamaka poto, piape akali yangone balana yano yene mindi andeaipia. Yangone okonenga yano tene kina angu yane tekeko, piape akali okonemane piape akali yangone okonena pendokone mina pai loto, nimbato nambana yano tupa pitaka gii leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wuane lea-kola, balana yangone okonemane aikini leka wato, matili nambato nimbana yano okone peyokalenga, nimbato namba towa wamba ini kapoyale yataka naene, maliyo ata-kae leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wuane lea-kola, piape akali okonemane maliyo ata napukale nembo toto, balana piape akali yangone okone katapusa pua aindaka lalu, balana yano peyo koyo pula-angi, bala takita epeakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Piape akali okonemane wuane pea-kola, balana piape akali yangone waka tupamane balana mana okone andoto, mini kenda wete yainipia. Mini kenda wete wato, utupane-mane poto, piape akali okomane wuane piya lo yakamana akali andane kiŋi oko lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","Lamai-yaikola, akali andane okonemane balana piape akali okone epeakale leaipia. Epea-kola, akali andane okomane bala lamawuato, wamba nimbato namba ondo aa lale-kola, nambato nambana yano andane nimbanga yapia tupa pitaka mia napene yakale kondalo-ko leaipia. Nambato nimba ondo alo pua teke, nimbatopi nimbana piape akali yangone okone ondo ape-pene tekeko, nimbato wuane napene kondele-ko. Nimba piape akali koo wete mindi ya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wuane lalu, akali andane okonemane yataka wato, balana piape akali okomane balana yano peleakale nembo toto, akali minditupa-mane bala tandaka mawua ateakale leaipia. Akali okonemane balana yano pitaka peyo koyo pula-angi, utupane-mane tandaka mawua ateaini okone kondeakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kiŋi okonemane wuane leane loto, Jisasato pii kokoli leane okone lo koyo piyu, pii mindi tako pua loto, wandakali yangone mindimane yakamanga koo mindi pula-kola, yakamato mindiki-mindiki lo balana koo okone apia-mai napeaindo, nambana ayiane ati kenga ateya okomanepi wuane pua teke, yakamana koo tupa apia-gii napulu-peya lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisasato pii utupane lo koyo piyu, Galili disitiki oko tepa alu, ipa Jotane amo-yangi Jutiya disitiki okona pea. ");
INSERT INTO ipi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Poto, balato wandakali kambua bala watama peaini utupanena siki tupa mo atu yaka pea. ");
INSERT INTO ipi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Okone angi, Patasai minditupa-mane Jisasa minu makande pimakale nembo toto, bala ateanga epeai. Utupane-mane bala tipa puato, tene mindi ata napula-kola, akali mindimane balana wetene oko mee peyo wateando, loo Goteto yata yane okomane akali okonena mana okone yapa lo tale puato, katu lolo-peyape leai. ");
INSERT INTO ipi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gotena pii pepa pelene eya mindimane loto, wamba wete Goteto pitaka taka yakale leane-angi, balato wanda, akali-la, lapotaka waa peane layene eya lea. Yakamato pii temane okone dii lo anda napeaipe. ");
INSERT INTO ipi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Okonelapo waa piyu, Goteto pii mindi loto, akali mindimane balana angini, ayiane-la, okonelapo tepa alu, balana wetene oko towa mina mindiki lolapi-angi, liyamba umbaini mindiki gulo pitulu-peyapi leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wamba Goteto wuane leane oko nembo toto, andipa wanda, akali-la, liyamba lapo gulo napeteyapi. Liyamba umbaini mindiki gulo peteyapi-ko. Goteto wanda, akali-la, okonelapo mina mindiki leane nembo toto, wandakali-mane okonelapo mo toko nalape-pene. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wuane lea-kola, Patasai tupamane bala lamawuato, wamba Mosesato loo mindi yata wato, akali mindimane wetene peyo watolane pepa mindi mo maiyu, bala puu leando, mana okone katu leane leainipia. Wanda, akali-la, okonelapo toko nalapa-pene yando, anu peakale Mosesato mana okone katu loto, loo okone yata yaepiape leai. ");
INSERT INTO ipi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wuane leai-kola, Jisasato utupane lamawuato, yakamato tuu pua Gotena pii tanga loto, yakamana wetene tupa peyo wata alaini. Wuaneko, akali tupamane yakamana wetene tupa peyo wateakale lo Mosesato ando konda yane tekeko, Goteto wandakali tupa wamba ini bulupane waa peane-angi, akali-mane wanda peyo wateakale loto, mana mindi yata nayaepia. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tene okonena, nambato yakama languato, wanda mindimane pamuku napula-kola teke, balana akalini okomane bala mee peyo watalu, wanda waka mindi kee leando, akali okone bala tane pamuku pula-kola pulupeya leyo. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wuane lea-kola, balana disaipolo tupamane bala lamawuato, wanda peyo watolane asini mindi nayando, akali-mane wanda kee nalene, kondeaindo, utupane kuai lo atolopeyai leai. ");
INSERT INTO ipi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Wuane leai-kola, Jisasato utupane lamawuato, akali minditupa-mane katulo wanda kee nalene, mee ata na-piyaini. Jia. Goteto mana okone akali minditupanga maya-kola, utupane-mane angu katulo wanda mindi kee nalene, mee atalaini. ");
INSERT INTO ipi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wanda mindimane iwanaŋa umbaini koyene mindi mandeando, matili iwana okone andayola-angi, balato wanda katulo mia napepe-pene gulola-kola, wanda kee nalene, bala mee atolopeya. Akali mindina wangali tolo apene yando, bala wanda kee nalene, mee atolopeya teke. Dee, Gote ati kenga ateya okomane wandakali tupa moyo ando ateakale nembo toto, akali minditupa-mane balana piape oko pua atamakale loto, wanda kee nalene, mee atalaini. Mana okone katulo wato minula akali okomane mana okone wato minape-pene. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Okone angi, Jisasato andopane aŋako tupanga kii yata wato, pote leakale nembo toto, wandakali-mane andopane tupa atu aiyu bala ateanga epeai-kola, balana disaipolo tupamane wandakali utupane laiya loto, yakamato andopane tupa atu aiyu naepene kondalapa leai. ");
INSERT INTO ipi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kondalapa leai-kola, Jisasato utupane lamawuato, ati kenga ateya Gote okomane andopane aŋako okopene gulo atalaini wandakali tupa moyo ando atalane-ko. Yakamato andopane utupa minandi nalene, namba ateyonga epeakale lo ando kondalapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wuane lalu, Jisasato andopane aŋako utupanena kawanenga kii yata wato, pote lalu, bala yuu okone tepa alu, pea. ");
INSERT INTO ipi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Alu mindi akali amango mindi bala Jisasa ateanga epoto, bala tipa puato, tisa, namba saka atapowa atokalenga, nambato mana epene andoko minu atokalepe lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wuane lea-kola, Jisasato akali okone tipa puato, anu peakale nimbato mana epene andoko minu atokalepe lo namba tipa pelepe lea. Gote bala angu epene. Nimba saka atapowa atokale nembo teendo, nimbato balana loo tupa pitaka wato minu atape lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wuane lea-kola, akali okonemane bala tipa puato, nimbato loo andutupa andayo lelepe lea. Wuane lea-kola, Jisasato bala lamawuato, nimbato wandakali yangone mindi peyo ome nalape lea. Nimbato pamuku napipe. Nimbato pake mia napipe. Nimbato wandakali yangone mindi kosimi loto, owato pii nalape. ");
INSERT INTO ipi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nimbana angini, ayiane-lana pangosa atoto, nimbato okone-lapona pii lolapi tupa wato minu atape. Dee, nimba tane epelewa atalene pua teke, nimbato wandakali yangone tupa towa epelewa yamapane yo atape layene eya lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wuane lea-kola, akali okonemane bala lamawuato, nambato loo utupane pitaka wato minu atalawane. Nambato mana epene andoko tako pua wato minape-penepe lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wuane lea-kola, Jisasato bala lamawuato, nimba akali epene tika-pene wete mindi atokale nembo teendo, nimba poto, wandakali waka tupamane nimbana minditaka eya tupa pitaka kambeakale lape lea. Kambolai-kola, nimbato muni mole tupa wandakali koo tipia tupa maipe. Wuane peendo, matili nimbana minditaka epene wetete tupa ati kenga yolopeya-ko. Nimbato namba watama ipupe lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wuane lea-kola, akali amango okonemane balana pii okone ale alu, balana minditaka kambua wetete yane tupa pitaka awua tepa na-wakale nembo toto, bala mini kenda wato, Jisasa tepa alu, pea. ");
INSERT INTO ipi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pea-kola, Jisasato balana disaipolo tupa lamawuato, nambato pii enene mindi yakama langeyo. Goteto utupane moyo ando ateakale lo akali amango tupamane ando kondape-pene oko pitete alaini. ");
INSERT INTO ipi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dee, nambato pii mindi tako puato, yia kamele mindi bala yana asia titi aŋako mindina kolandaka loyale makande pipia-yale, pitete apia-yale tekeko, Goteto utupane moyo ando ateakale lo akali amango tupamane ando kondape-pene oko pitete wete alaini lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wuane lea-kola, balana disaipolo tupamane balana pii okone ale wato, moko wete loto, Jisasa tipa puato, wuane yando, api katulo saka atapowa atolo-peyape leai. ");
INSERT INTO ipi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wuane leai-kola, Jisasato utupane andapeyo yoto, pii mindi loto, wandakali yakama tane katulo saka atapowa atamakale lo saka ataya na-olopeyai tekeko, Goteto katulo pitaka taka piyane. Tene okonena, akali amango mindimane Gotenga tungi peyo bilipi leando, Goteto katulo bala saka atapowa ateakale lo ataya olopeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wuane lea-kola, Pitato bala tipa puato, nanimana minditaka yemane tupa pitaka awua tepa alu, nanimato nimba watama epeyama okone nimbato andee oko yako. Matili nanimato aki mindi molo-peyamape lea. ");
INSERT INTO ipi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, nambato pii enene mindi yakama langeyo lea. Matili minditaka eya tupa pitaka wenene gulola-angi, Akalina Iwanane oko bala gene andane wetete mialu, kiŋi pitiyane toko epene wetete mindina pitulu-peya. Okone angi, namba watama epeyai akali alesa tupa yakamato kiŋi pitiyaini toko alesa tupanga pituto, Isatale tane alesa tupa ando atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dee, wandakali minditupa-mane nambana piape oko pukale nembo toto, yakamana ee anda yandopi, amene imalini yandopi, angini ayiane yandopi, andopane yandopi, utupanena mindi tepa alaini. Wuane piyaini wandakali utupane pitaka-mane matili okonetaka kambua longo wete konda pua moto, saka atapowa atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Utupane-mane wuane pulupeyai tekeko, wandakali andipa gene andane wetete yene ateyai utupanena kambua minditupa matili gene nayene wetete atolai-kola, wandakali andipa gene nayene wetete ateyai utupanena kambua minditupa matili gene andane wetete yene atolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Wuane lalu, Jisasato pii mindi tako pua loto, wamba getepe ee anduane mindimane balana piape akali tupa ando ateane pua teke, ati kenga ateya Gote okomane yuu okona wandakali tupa ando atalane lea. Wamba upa pitane wete ee anduane okone bala ika loto, akali minditupa-mane balana ee okona piape pingeakale lo utupane lamolo peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Poto, akali mee ateaini tupa lamawuato, yakamato ole mindiki nambana piape pingeaindo, nambato yakama mindiki-mindiki lo wandakali-mane ole mindikina yole mialiani pua, Lomo tane wandakali muni silipa-mane waa-pene mindi gukale leaipia. Akali utupane-mane yole okone atu yalua leai-kola, ee anduane okonemane akali utupane lamawuato, yakamato nambana ee okona piape pulu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Matili upa pitane naini kilokopi mindi lea-kola, ee anduane okonemane wandakali epo amunguli piyaini ama okona poto andea-kola, akali waka minditupa mee ateainga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Balato utupane lamawuato, yakamato nambana piape pingeaindo, nambato yole tika pua gukale-ko. Nambana ee okona piape pulu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wuane lea-kola, utupane-mane balana piape pulu peainipia. Matili otonga tualo kiloko lea-kolapi, ole-lene siti kiloko lea-kolapi, ee anduane okonemane pai pua wuane teke peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wuane piyu, ole-lene taeme paepe kilokopi mindi lea-kola, bala poto andea-kola, akali waka minditupa mee ateainga andeaipia. Andoto, balato utupane tipa puato, anu peakale yakama ole luu oko pitaka mee atalaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wuane lea-kola, utupane-mane balana pii okone yano peyoto, akali mindimane piape mindi nanima gii napiya-kola, nanima mee atalama leainipia. Wuane leai-kola, balato yakamapi nambana ee okona piape pulu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Sikisa kiloko lea-angi, ee anduane okomane balana ee ando atalane akali oko lamawuato, nimbato piape akali tupa ipulupa loto, yole maipe. Akali matili ole-lene wete piape pulu epalai tupa wamba ini bulupane yole maiyu, yole maima pulu, akali wamba ini bulupane wete piape pulu epalai utupane yole mai-koyo pipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wuane lea-kola, matili ole lene wete paepe kilokopi mindi tewa piape pulu peaini akali tupa mindiki-mindiki lo yole muni silipa-mane waa-pene mindi miaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akali utupane yakama muni silipa-mane waa-pene mindi yole meainga andoto, akali wamba ini bulupane wete epoto, piape pua ateaini tupamane yakama yole minditupa tako pua molopeyama ya lo nembo teaini tekeko, utupane pitaka mindiki-mindiki lo muni silipa-mane waa-pene mindiki teke yole miaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yole mindiki wuane pua teke meaini okone andoto, akali utupane-mane ee anduane okona mana okone andoto, mulu-mulu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mulu-mulu loto, akali utupanena mindimane ee anduane oko lamawuato, nai popo piya-kola teke, nanima wamba upa pitane wete tewa, ole luu oko pitaka piape ayawa wete pua atalama-ko. Akali matili wete epalai utupane yakama awa mindiki angu piape piyai tekeko, nimbato yole nanima gele mindiki okone tuma teke akali utupane yole maele okonde leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","15","Wuane lea-kola, ee anduane okomane piape akali okonena pii okone yano peyoto, amene, namba tanena muni tale pukale nembo teyo pua tale peyo-kola, Gotena loo okomane jia leyape. Akali okomane ole-lene wete epoto, piape piyai-kola, nambato bala moyo yole nimba geyo okone tuma teke bala mauwakale nembo toto, maeyo. Nambato wuane peyo-kola, anu peakale nimbato akali okone towa apiangu pimailepe. Wamba nambato muni silipa-mane waa-pene mindi gukale lalo-kola, nimbato yole okone atu yalua lale okoni. Tene okonena, andipa nambato muni silipa-mane waa-pene mindi nimba yole geyo okomane nimbanga koo mindi napeyo-ko. Nimbana yole oko mialu, puu leaipia. Ee anduane okomane wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ee anduane okonemane balana piape akali tupa yole mayane pua teke, ati kenga ateya Gote okomane balana piape akali tupa yole malupeya. Maula-angi, wandakali wamba bulupane balana piape pua ateaini tupana minditupa gene nayene wete atolai-kola, wandakali matili masianenga balana piape pimaulaini tupana minditupa gene andane wete yene atolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Wandakali kambua Jisasa towa atu Jutusaleme poyale asini peai-kola, balato wandakali waka tupa tepa alu, balana disaipolo alesa akali tupa angu atu aiyu amonga-yale poto, utupane lamawuato, ale alapape. Andipa nanima Jutusaleme poyale asini peyama lea. Poloma-kola, akali mindimane Akalina Iwanane oko ene pituto, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupanena kininga malupeya. Maula-kola, utupane-mane bala kosimi loto, omeakale lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Omeakale lalu, akali yame waka tupamane bala lamba loto, kunju-mane peyalu, ita malamanda okona peyo yuka yakale nembo toto, utupane-mane bala akali yame waka tupana kininga maulu-peyai. Bala omola-kola, ole teponena, Goteto bala malinga ika laya olopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Okone angi, Sepiti okona wetene okomane balana iwanane lapo lamo atu Jisasa ateanga epoto, aiki leka wato, nimbato mangene mindi pipi lakae lo nembo teyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wuane lea-kola, Jisasato bala tipa puato, nimbato mangene aki mindi nambato pipia lakae lo nembo telepe leaipia. Wuane lea-kola, wanda okonemane bala lamawuato, nimba akali andane kiŋi gulole-angi, nimbato nambana iwanane okolapona mindi nimbana kii tikasa-tole peteakale lalu, mindoko nimbana kii koyasa-tole peteakale lapi lakae lo nembo teyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nambato wuane pipia lakae lo yakamato nembo teyai tekeko, matili mangene anu-pene tupa pulu-peyape lo yakamato wayumane nembo natene, mee tee leyai leaipia. Wuane lalu, balato Sepiti iwanane okolapo tipa puato, minditaka mindi kapo penenga petene nambato nolowa oko liyambato katulo nolo-peyapipe leaipia. Wuane lea-kola, okonelapo-mane Jisasa lamawuato, nalipato okonetaka katulo nolo-peyapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wuane leapi-kola, Jisasato akali okonelapo lamawuato, enene, minditaka mindi kapo penenga petene gulola oko nambato nolowa-kola, liyambatopi nolo-peyapi tekeko, nambana kii tikasa-tole yandopi, nambana kii koyasa-tole yandopi, akali mindi bala peteakale lolane piape oko nambana jia. Wamba nambana ayiane okomane akali lapo toko okone-lapona peteakale lata yane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Amene okonelapo-mane akali andane atapakale leapi-kola, matili Jisasana disaipolo waka paiyasa tupamane pii temane okone ale wato, disaipolo okonelapo towa yataka yai. ");
INSERT INTO ipi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yataka yai-kola, Jisasato balana disaipolo tupa pitaka ipulupa loto, wua leaipia: Wandakali yame waka tupamane akali kawane tupana pii wato mineakale loto, akali kawane tupamane wandakali utupanena lipinga atoto, utupane taimane ando atalaini lo yakamato nembo teyai. ");
INSERT INTO ipi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Utupane-mane wuane piyaini tekeko, yakamato mana okone wato mina na-piyapape. Jia. Yakamana mindimane akali andane mindi atauwa lakae lo nembo teando, bala yakamana piape akali gulo atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","28","Akalina Iwanane oko epoto, wandakali-mane balana piape pingeakale nembo nateaipia. Jia. Balato utupanena piape pimawuato, wandakali kambua kambo molo-peke lokale nembo toto, bala omolo epea. Wuane pua teke, yakamana mindimane akali andane wetete mindi atauwa lakae lo nembo teando, balato yole mia napene, yakamana piape tupa mee wetete pingua atape-pene. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Matili Jisasa balana disaipolo tupa towa atu Jetiko tano oko tepa alu peai-kola, wandakali kambua longo-mane bala watama peai. ");
INSERT INTO ipi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Okone angi, wandakali-mane Jisasa epeya leai-kola, lene koo akali lapo-mane asini okona mandaka gulo pituto, pii okone ale wato, Dapiti yame Akali Andane nimbato nalipa ondo ape lo pii taimane laka peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wuane laka peapi-kola, asini epeaini wandakali kambua tupamane okonelapo laiya loto, liyamba pii nalene kondalapa leaini tekeko, okonelapo-mane pii taimane wete loto, Dapiti yame Akali Andane nimbato nalipa ondo ape leapi. ");
INSERT INTO ipi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wuane leapi-kola, Jisasa bala asini puapo naene, ongane atoto, akali lee koo okonelapo lamawuato, liyamba ipulupa lea. Epeapi-kola, balato akali okonelapo tipa puato, nambato liyamba moyo, anu pipi lakae lo nembo teyapipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wuane lea-kola, akali okonelapo-mane bala bilipi loto, Akali Andane, nimbato nalipana lene mo tee laya api lakae lo nembo teyapa leapi. ");
INSERT INTO ipi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wuane leapi-kola, Jisasato akali okonelapo ondo wato, balana kini okomane liyambana lenenga yata ya-kola, wamba kapoyale okone angi teke, liyamba lene toto, Jisasa watama peapi. ");
INSERT INTO ipi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","5","Wamba potopesa akali mindimane pii mindi loto, yakamato Sayone tano okona tane tupa lamawuato, yakamana kiŋi oko bala akali gene nayene gulo atoto, bala yia dongi mindina masianenga pitiyu epeya. Bala dongi talua okona masianenga pitiyu epeya oko andalapa lo lamai-yapape leaipia. Potopesa akali okonemane pii leane okone enene guleakale nembo toto, Jisasa balana disaipolo tupa towa Jutusaleme poyale Olipi wangiane okona puu iyu loto, Betepasi tano okona peakaiyu leai-angi, balato balana disaipolo lapo akali lamawuato, liyamba tano aŋako amo eya okona pulupa lea. Poto andolapi-kola, dongi mindi balana andopane oko towa atu andi latane atolapinga liyambato wamba kapoyale andolo-peyapi. Liyambato dongi okone-lapona ende tita lolapi-angi, akali mindimane liyamba tipa puato, anu peakale liyambato wuane peyapipe leando, liyambato bala lamawuato, Akali Andane okomane dongi mindina pituto, mangene mindi pukale nembo teya lalapape. Wuane lolapi-kola, akali okonemane dongi okonelapo wamba ini atu pulupa lolopeya. Wuane lola-kola, liyambato okonelapo atu namba ateyonga ipulupape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wuane lea-kola, disaipolo okonelapo-mane poto, balato piyapape leane pua peapilipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Liyambato dongi angini, andopane-la, okonelapo atu epoto, Jisasa dongi talua okonena masianenga peteakale nembo toto, akali okonelapo-mane liyambana tona luu kenga peapili okolapo yokoto, dongi okonena masianenga yata yapili. Yata yapi-kola, Jisasa bala dongi okona masianenga pitiyu, Jutusaleme poyale pea. ");
INSERT INTO ipi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bala Jutusaleme poyale pea-angi, wandakali kambua longo-mane yakamana tona luu kenga peaini tupa yokoto, Jisasa poyale peane asininga panda pima peai. Dee, wandakali minditupa-mane ita kembone aŋako tupa yando moto, asininga panda pua yatama peai. ");
INSERT INTO ipi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wandakali bala poyale peane okona asininga ingane peaini tupapi, bala masianenga watama epeaini tupapi, utupane-mane pii taimane lama poto, yakamato kiŋi Dapiti yumbane oko laiyu lalapa leai. Akali Andane Goteto bala epeakale leya-kola, bala epeya-ko. Goteto bala wayumane moyo ateakalenga, ati kenga wetete ateya Gote okona gene oko laiyu lalapa lama peai. ");
INSERT INTO ipi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wuane lama poto, utupane yakama Jisasa towa atu Jutusaleme peakaiyu leai-kola, Jutusaleme tane wandakali pitakana nembo-tene ika lea-kola, akali epeya oko apipe lo tipa peai. ");
INSERT INTO ipi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tipa peai-kola, Jisasa towa atu epeaini wandakali tupamane utupane lamawuato, akali oko bala Galili disitiki tano Nasatesa tane potopesa akali Jisasa oko ateya leai. ");
INSERT INTO ipi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Okone angi, Jisasa bala lotu anda andane okona ende anda-pangosa kolandaka loto andea-kola, minditaka makesa yo peteaini wandakali tupapi, minditaka kambo ateaini wandakali tupapi, utupane pitaka peyo watea. Utupane peyo watoto, muni lawa pua peteaini akali tupana tepolo toko tupapi, eka uya salimi lo peteaini akali tupana pitiyaini toko tupapi, utupane kulembo lo apea. ");
INSERT INTO ipi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Apialu, balato wandakali utupane lamawuato, Gotena pii pepa pelene eya mindimane loto, wandakali-mane nambana anda oko bala pote lo pitulane anda mindi ateya lolopeyai layene eya tekeko, yakamato nambana anda oko pake nene wandakali tupa epo pitiyaini anda mindi gulaya eyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wuane lalu, Jisasa bala lotu anda andane okonena atea-kola, wandakali lee koopi, kee koopi, utupane bala ateanga epeai. Epeai-kola, balato utupane mo atu ya. ");
INSERT INTO ipi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jisasato metekolo piape andane utupane pea-kola, andopane minditupa lotu anda andane okonena ende anda-pangosa atoto, balana gene oko laiyu loto, Dapitina yumbane oko laiyu lalapa, laka peai. Wuane laka peai-kola, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane andoto, yataka-mane omeai. ");
INSERT INTO ipi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yataka-mane omoto, utupane-mane Jisasa tipa puato, andopane tupamane pii leyai okone nimbato ale naelepe leai. Wuane leai-kola, Jisasato utupane lamawuato, nambato utupanena pii okone ale eyo tekeko, Gotena pii pepa pelene eya mindimane loto, Gote nimbato andopane andanepi, kambolopi, utupane-mane nimbana gene oko laiyu leakale laya alene layene eya lea. Yakamato pii layene okone alu mindikipi mindi wamba dii lo anda napeaipe lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wuane lalu, balato pitisa akali kawanepi, loo tupana mana andene akalipi, utupane ateakale loto, Jutusaleme tepa alu, Betani tano okona poto, palea. ");
INSERT INTO ipi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Upa pitane wete Jisasa bala Jutusaleme peke loyale asini poto, ulia nono ya. ");
INSERT INTO ipi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ulia nono wato, balato ita piki mindi asia ayatenenga ateane oko andoto, dini liyape lo andolo mandaka pea-kola, ita okonena dini mindikipi mindi lia napene, yokone angu ateanga andea. Andoto, balato ita piki okone lamawuato, matili-matilipi nimbato dini mindikipi mindi lia napula lea-kola, ita piki okone wamba ini kapoyale okone angi teke kuu lo kapu tea. ");
INSERT INTO ipi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kuu lo kapu tea-kola, balana disaipolo tupamane andoto, yakama moko wete loto, anu puato ita piki oko wamba ini andipa teke kapoyale wete kuu lo kapu teyape lo bala tipa peai. ");
INSERT INTO ipi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tipa peai-kola, Jisasato utupanena pii okone yano peyoto, nambato pii enene mindi yakama langeyo lea. Yakamato mini lapo palu ata napene, Gote lo bilipi leyama nayu leaindo, nambato ita piki okonga mangene mindi piyo okopene yakamatopi katulo pulupeyai. Dee, yakamato yuu wangiane oo eya oko lamawuato, nimba lopalu poto, ipa solewata angini andane okona tombenenga peaka nena laa leaindo, Goteto yuu wangiane oko lopalu, ipa solewata andane okona tombenenga aindaka lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yakamato pote lolai pua Goteto pulupeya lo bilipi leyama nayu loto, Gote nimbato mangene mindi pula lo pote laka peaindo, Goteto mangene utupane pitaka piki pulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisasa bala lotu anda andane okonena ende anda-pangosa poto, wandakali tupa mana lamawua atea-kola, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane yakama Jisasa ateanga epeai. Epoto, utupane-mane bala tipa puato, nimbato apina pii wato minuto, wandakali utupa mana lamawua atelepe. Apito nimba languato, piape utupa pipe lapia-kola, nimbato piape utupa pua atelepe leai. ");
INSERT INTO ipi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wuane leai-kola, Jisasato utupane lamawuato, nambato pii mindiki yakama tipa peyo lea. Yakamato nambana pii okone kuai lo yano peleaindo, piape utupane pipe lo namba langeane akali okona gene oko langukale. ");
INSERT INTO ipi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","26","Wamba Goteto Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wandakali tupa ipa peya-mauwa ateape. Pee, wandakali-mane bala lamawuato, ipa peya-maipe leai-kola, balato wuane peape lea. Wuane lea-kola, akali utupane yakama teke-teke pii lalawa puato, wandakali pitaka-mane Jone bala potopesa akali mindi ateane nembo talaini-ko. Nanimato Jisasana pii okone yano peyoto, wandakali-mane Jone lamawuato, nimbato wandakali tupa ipa peya-maipe leai-kola, balato wandakali tupa ipa peya-mawua ateane lemando, wandakali pitaka-mane nanima towa yataka olopeyai lo yuku eyama. Wuane tekeko, nanimato balana pii okone yano peyoto, Goteto Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wandakali tupa ipa peya-mawua ateane lemando, Jisasato nanima tipa puato, wuane yando, anu peakale yakamato Jonena pii oko bilipi naleaipe lolopeya leai. ");
INSERT INTO ipi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wuane lo yakama teke-teke pii lalawa piyu, utupane-mane Jisasana pii okone yano peyoto, nanima nembo nateyama leai. Wuane leai-kola, balato utupane lamawuato, wuane yando, piape utupa pipe lo namba langeane akali okona gene oko nambato yakama langi napukale teke lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","30","Jisasato pitisa akali kawane tupapi, Isatale tanena akali kawane waka tupapi, utupane pii mindi tako pua lamawuato, wamba akali mindina iwana lapo ateapele lea. Balato balana iwanane mindi ateanga poto, iwana, andipa nimbato getepe ee okona piape pulu puu leaipia. Wuane lea-kola, iwana okonemane balana ayiane lamawuato, akali andane, nambato piape pulu pokale leane tekeko, bala puu napene, konda yaepia. Balato piape pulu napea-kola, ayiane okomane balana iwanane mindoko ateanga poto, iwana, nimbato getepe ee okona piape pulu puu leaipia. Wuane lea-kola, iwanane okonemane balana ayiane lamawuato, nambato piape okone pulu napokale leane tekeko, matili balana nembo lawa piyu, piape pulu peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Iwanane okone-lapona andoko-mane ayiane-mane nembo teane pua peaipiape. Yakamato aki nembo teyaipe. Jisasato akali utupane tipa puato, wuane lea-kola, utupane-mane bala lamawuato, iwana piape pulu peane okomane bala ayiane okomane nembo teane pua peaipia leai. Wuane leai-kola, Jisasato utupane lamawuato, nambato pii enene mindi yakama langeyo lea. Wamba Joneto mana tika-pene tupa yakama langulu epea-kola, yakamato pii balato leane tupa bilipi naleaini tekeko, takisa muni mialaini akalipi, pamuku wandapi, utupane-mane Jonena pii leane oko ale wato, bilipi leai. Utupane-mane bilipi leaini okone andoto, Pitisa akali kawanepi, Isatale tanena akali kawanepi, yakamato yamapane lawa puato, pii balato leane tupa bilipi naleai. Tene okonena, takisa muni mialaini akalipi, pamuku wandapi, utupane-mane Gotena yuu epene okona makale nembo toto, yakama sia minuto, Gote nimbato nanima moyo ando atape ini kapoyale lalaini. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wuane lalu, Jisasato pitisa akali kawane tupapi, Isatale tanena akali kawane tupapi, utupane pii mindi tako pua lamawuato, yakamato pii kokoli waka mindi ale alapa lea. Yuu anduane mindimane getepe ee mindi yandoto, ende pua wata aindaka leaipia. Wuane piyu, matili dini tupana ipane penge lo mokale nembo toto, balato ana andane mindi kua peaipia. Kua piyu, akali mindimane ee okone ando ateakale loto, balato anda kenga luu wete mindi peaipia. Wuane piyu, balato akali minditupa lamawuato, yakamato nambana ee oko ando atalapape lalu, bala yuu tepanda waka mindinga poto ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Matili getepe dini tupa mandulane oto oko epea-angi, ee anduane okomane balana piape akali minditupa lamawuato, nambana getepe ee ando atalaini akali tupamane getepe dini minditupa yo geakalenga, yakamato molo pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Balato wuane leane tekeko, ee ando atalaini akali tupamane balana piape akali utupane minuto, mindi kunju-mane peyalu, mindi peyo ome lalu, mindi ana-mane peyalu, peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wamba ee anduane okomane piape akali aŋalapo angu pulupa lea-kola, balana ee ando atalaini akali utupane-mane akali utupane minu koyainipia. Tene okonena, ee anduane okomane balana piape akali kambua tako pua lamawuato, akali utupane-mane getepe dini minditupa yo geakalenga, yakamato molo pulupa leane tekeko, balana ee ando atalaini akali utupane-mane wamba peaini pua teke puato, balana piape akali utupane minu koyaini tekepia. ");
INSERT INTO ipi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wuane peai-kola, matili ee anduane okomane pii mindi loto, nambana ee ando atalaini akali utupane-mane nambana iwanane okona pii ale olopeyai lea. Wuane loto, balato balana iwanane oko lamawuato, akali utupane-mane getepe dindi minditupa yo geakalenga, nimbato molo puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Balato wuane leane tekeko, balana ee ando atalaini akali utupane-mane balana iwanane oko epeanga andoto, yakama teke-teke pii lalawa puato, matili iwana epeya okomane bala ayiane okona minditaka eya tupa pitaka paluni tane molopeya-ko. Nanimato bala peyo ome lalu, ee oko nanima wetete mia-makale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wuane lalu, utupane-mane bala minata wato, ee okonena ende kamaka awua poto, bala peyo ome leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pii kokoli okone lalu, Jisasato pitisa akali kawane tupapi, Isatale tanena akali kawane waka tupapi, utupane tipa puato, balana ee ando atalaini akali utupane-mane wuane peaini okonena, matili ee anduane oko epola-angi, balato akali utupane towa anu pulu-peyape lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wuane lea-kola, utupane-mane bala lamawuato, balato akali koo utupane tandaka andane mawuato, peyo ome lalu, akali waka minditupa-mane balana getepe ee okone ando ateakale lolopeya. Wuane lola-kola, getepe dini mandulane oto oko epola-angi, akali utupane-mane getepe dini tupa yoto, minditupa bala malupeyai leai. ");
INSERT INTO ipi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wuane leai-kola, Jisasato utupane lamawuato, Gotena pii pepa pelene eya mindimane loto, anda piyaini akali tupamane anda mindi puato, ita mindi andoto, oko koo ya loto, mo apeaini mindiki okone teke, Goteto moto, anda okonena pingina gulaya yane. Nanimato andeyama-kola, Gotena mana okone kuai-lene wete eya andeyama layene eya. Yakamato Gotena pii layene okone wamba alu mindikipi mindi dii lo anda napeaipe. ");
INSERT INTO ipi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Piape akali utupane-mane piape kopeta peaini pua teke, yakamato Gotena piape oko kuai lo ando ata na-piyaini. Tene okonena, yakamato balana ee oko ando atalapale lo balato ando konda napulu-peya. Jia. Wandakali yame waka mindimane balana ee oko ando ateakale lo maula-kola, utupane-mane balana ee okona dini tupa yoto, bala maulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wandakali mindi aiya peyoto, anda pingina okona tokonga lomba-pene yando, wandakali okone bala tele lo toko lolopeya tekeko, anda pingina okone tepa wato, wandakali mindi peyo tele lola-kola, wandakali okone bala yuu kangalamu gulolo-peya lea. ");
INSERT INTO ipi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jisasato wuane lea-kola, pitisa akali kawane tupapi, Patasai tupapi, utupane-mane ale wato, balato pii kokoli utupane nanima andayo leya nembo teai. ");
INSERT INTO ipi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wuane nembo toto, utupane-mane bala andi laima lakae lo nembo teaini tekeko, wandakali kambua ateaini tupamane Jisasa bala potopesa akali mindi ateya nembo teai-kola, Juta yamena akali kawane tupamane bala andi loyale yuku wato, konda yai. ");
INSERT INTO ipi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Okone angi, Jisasato pii kokoli waka mindi Juta yamena akali andane tupa lamawuato, wamba kiŋi mindina iwanane okomane wanda mindi kee loyale pea-kola, kiŋi okonemane tomo kambua yangeane lea. Tomo yangalu, balato wandakali tupa lamawuato, yakama tomo nolo ipulupa leaipia. Wuane leane pua teke, ati kenga ateya Gote okomane wandakali tupa moyo ando atokale nembo toto, utupane lamawuato, yakama ipulupa lalane. ");
INSERT INTO ipi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kiŋi okonemane tomo yangoyale atoto, wandakali yame mindi wamba ini lamawuato, matili nambato tomo yandolo-wakola, yakama tomo nolo ipulupale leaipia. Wuane lalu, matili wandakali utupane-mane balana tomo okone nolo epeakale nembo toto, kiŋi okonemane balana piape akali tupa lamawuato, yakamato wandakali utupane ipulupa lolo pulupa leaipia. Wuane lea-kola, akali utupane-mane poto, yakama ipulupa leaini tekeko, wandakali utupane-mane na-ipumakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na-ipumakale leai-kola, kiŋi okonemane balana piape akali waka minditupa lamawuato, yakama poto, wandakali wamba nambato epeakale lauwa tupa lamawuato, kiŋi okomane pii mindi yakama langiya oko yakamato ale alapape lala lalapape leaipia. Nambana iwanane okomane wanda mindi kee loyale peya-kola, nambana yia bulumako maipa tupapi, sipisipi kataiya atene tupapi, utupane peyoto, nambato tomo kambua makande piyo. Pitaka taka wamba makande pitane eya-ko. Yakamato tomo nolo ipulupape. Kiŋi okomane wuane lala lo yakamato utupane lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wuane lea-kola, balana piape akali tupa poto, wandakali utupane wuane lo lamaiyai tekeko, wandakali utupane-mane pii okone ale oyale embo alu, waka-waka puku peainipia. Wandakali mindi bala eenga peaipia. Wandakali mindi balana bisanisa piape pulu peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dee, wandakali waka tupa pitaka-mane kiŋi okona piape akali utupane minu koyalu, peyo ome leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tene okonena, kiŋi okonemane yataka wete wato, balana ami yanda yene tupa lamawuato, yakamato wandakali utupane minu koyolo pulupa leaipia. Pulupa lea-kola, utupane-mane poto, balana piape akali peyo leaini wandakali utupane paini peyo ome loto, utupanena tano oko yango apeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Wuane peai-kola, kiŋi okomane balana piape akali waka tupa lamawuato, nambana iwanane okomane wanda kee loyale peya-kola, tomo kambua makande piyene mee eya tekeko, wandakali tomo nolo epeakale lauwa utupane yakama wandakali koo wete atalaini ya leaipia. Wandakali koo okonepene tupamane nambana tomo tupa naneakale. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tene okonena, yakamato asia kembo tupana poto, wandakali yame waka yakamato andolai tupa pitaka lamawuato, nambato tomo kambua yangeyo-ko. Yakamato nolo ipulupa lala lo lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wuane lea-kola, balana piape akali utupane-mane asini tupana poto, wandakali koo epenepi andeaini tupa pitaka mo amunguli peainipia. Amunguli peai-kola, kiŋi okona iwanane okomane wanda kee lea-angi, tomo no peteaini anda oko tumbi wete leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Akali mindimane wanda mindi kee leya-angi, akali waka tupamane tona epene mindi piyainipia. Utupane-mane wuane piyaini tekeko, wandakali tomo no peteaini tupa andokale nembo toto, kiŋi okomane anda okona anda-pango kolandaka loto andea-kola, akali mindimane tona epene okonepene mindi pii napene, mee peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tona epene okonepene napea-kola, kiŋi okomane akali okone tipa puato, amene, anu peakale nimbato tona epene mindi napene, tona koo wambane mindi puato, anda okona kolandaka lalepe leaipia. Wuane lea-kola, akali okonemane balana pii okone yano peyolane asia mindi nayaepia. ");
INSERT INTO ipi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Asia naya-kola, kiŋi okomane balana piape akali tupa lamawuato, akali okone bala yuu koo undupi-lene okonena atoto, bala yamataka lo nene geleto laka pua ateakale. Yakamato balana kini kene tupa yake puato, bala takita awua apialapape. Kiŋi okomane wuane leane lo Jisasato lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pii kokoli okone lalu, Jisasato wandakali tupa lamawuato, Goteto wandakali kambua ee lalane tekeko, balato wandakali aŋalapo angu balana anda okona anda-pango epeakale lalane lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Okone angi, akali Patasai tupa poto, pii mindi lo yake puato, nanimato Jisasa langa-langa pimawua pii mindi loloma-kola, balato gapomane oko andayo pii koo mindi lolopeya. Pii koo mindi lola-kola, balana pii lolane okonemane teke nanimato bala kosimi lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wuane lalu, Patasai utupane-mane yakamana disaipolo minditupa kiŋi Etote yame akali minditupa towa atu Jisasa ateanga peakale leainipia. Akali utupane yakama epoto, Jisasa lamawuato, tisa, wandakali mindi bala gene yene yandopi, nayene yandopi, okonena tene mindi ata napeya nembo toto, nimbato wandakali mindikipi mindi ando yuku aa napilini leai. Yuku naene atoto, nimbato pii enene angu loto, Goteto nanima wua pipiai lakae lo nembo talane loto, mana kuai lo lamailini nembo teyama. ");
INSERT INTO ipi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tene okonena, nimbato aki nembo telepe lo nanimato nimba tipa peyama. Juta yame wandakali nanimato takisa muni tupa Lomo tane gapomane akali kawane Sisa oko maipe-penepe, mai napipe-penepe leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Akali utupane-mane nembo-tene koo palu, bala tipa peai lo andoto, Jisasato utupane lamawuato, yakama minakasa alaini akali ateyai lea. Anu peakale yakamato namba langa-langa pinguyale minu makande peyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yakamato takisa peyalaini muni mindi namba andawa lalapa lea. Wuane lea-kola, akali utupane-mane muni mindi awua epoto, bala andawa leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Andawa leai-kola, Jisasato utupane tipa puato, apina lee-inga waa pitane okola, gene peyatane okola, okonelapo muni okona ateyape lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wuane lea-kola, utupane-mane bala lamawuato, Lomo tane gapomane akali kawane Sisa okona lee-inga waa pitane okola, balana gene peyatane okola, okonelapo muni okona eya leai. Wuane leai-kola, Jisasato utupane lamawuato, wuane yando, yakamato Sisana minditaka yolai tupa bala maiyu, Gotena minditaka yolai tupa Gote maiyapape leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wuane lea-kola, akali utupane-mane ale wato, nembo kambua wete toto, bala tepa alu peai. ");
INSERT INTO ipi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","25","Ole okone angi teke, Satusi yamena akali minditupa Jisasa ateanga epeai. Utupane-mane wandakali omene tupa malinga ika nalolo-peyai lalainipia. Akali utupane epoto, Jisasa tipa puato, tisa, wamba akali mindina iwanane yanasa nanima towa wali atema leai. Amene bulupane okomane wanda mindi kee lalu, andopane mandi napene, omea-kola, balana wetene oko yalo petea. Wamba Mosesato pii mindi loto, akali mindimane wanda mindi kee lalu, andopane mindi mandi napene omeando, andopane mindimane akali omolane okonena panda meakale nembo toto, balana amene mindimane wanda yalo oko kee loto, andopane mindi mandi maiyakale lea. Pii okone nembo toto, akali omeane okonena amene okomane wanda yalo okone kee lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kee leane tekeko, wuane pua teke balato andopane mandi napene omea-kola, amene tepone-mane wuane teke pea. Wuane teke pima pulu, amene yanasa tupa pitaka-mane wanda mindiki okone teke kee lama pulu, oma yiake leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Matili wanda yalo okone balapi omea. ");
INSERT INTO ipi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Amene yanasa utupane pitaka-mane wanda mindiki okone teke kee leai-ko. Matili wandakali omene tupa malinga ika lolai-angi, wanda okone bala amene yanasa utupanena mindi andokona wetene pitulu-peyape leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, yakamato Gotena pii pepa pelene eya tupapi, balana tai-lene okopi, okonelapo nembo natene ato, kopeta nembo toto, pii okone nambanga tipa peyai. ");
INSERT INTO ipi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matili wandakali omene tupa malinga ika lolai-angi, wanda-mane akali napulu, akali-mane wanda kee na-lalu, utupane-mane ati kenga enjole atalaini pua teke atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Gote bala wandakali omene tupana Gote jia. Bala wandakali saka ateyai tupana Gote oko ateya. Tene okonena, wamba Goteto yakama languato, namba Apatakame, Aisake, Jekopo ima utupanena Gote oko ateyo lea. Gotena pii okone pepa pelene eya-kola teke, yakamato pii okone wamba dii lo anda napeaipe. Akali tepo omeaini utupanena tandini tupa saka ata napea-yale, Goteto bala akali utupanena Gote ateyo nalene, bala akali utupanena Gote atewa lea-yale. Tene okonena, nanimato balana pii pepa pelene eya okone dii loto, matili wandakali tupa malinga ika lolopeyai nembo teyama lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisasato wuane lea-kola, wandakali amunguli pua peteaini tupamane balana pii okone ale wato, moko wete leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisasato pii lala okonemane Satusi yamena nee asia tambu lala lo wandakali-mane pii lo tawe yai-kola, Patasai yame okomane pii okone ale wato, Jisasa ateanga epo amunguli peai. ");
INSERT INTO ipi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Akali utupanena mindi bala loo tupana mana kambua andene akali loya mindi ateaipia. Balato Jisasa minu makande puyale pii mindi bala tipa pea. ");
INSERT INTO ipi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Balato Jisasa tipa puato, tisa, Gotena loo tupana andoko-mane loo waka tupa pitaka sia minuto, lipinga wete eyape lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimbana Akali Andane Gote oko towa wayumane wetete epelewa yamapane yo atoto, nimbana yamapanepi, tandinipi, nembo-tenepi, utupane pitaka bala angu mawua atape lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Loo bulupane okonemane loo waka tupa pitaka sia minuto, lipinga wetete eya. ");
INSERT INTO ipi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gotena loo lapone oko mindiki okopene teke eya. Loo okonemane loto, nimba tane wayumane epelewa yamapane yo atalene pua teke, nimbato wandakali yangone tupa towa epelewa yamapane yo atape leya. ");
INSERT INTO ipi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gotena loo okonelapo balana loo waka tupapi, potopesa akali tupana pii tupapi, utupane pitakana tene oko eya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Patasai yame tupa amunguli piyu, ongane ateai-kola, Jisasato utupane tipa puato, Mesaya oko bala apina mandi-yenepe. Yakamato aki nembo teyaipe lea-kola, utupane-mane balana pii okone yano peyoto, Mesaya oko bala Dapitina yamena mandiyene mindi ateya leai. ");
INSERT INTO ipi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Wuane leai-kola, Jisasato utupane lamawuato, wamba Oli Sipitisa okomane Dapitina nembo-tene mina ika laya ya-kola, balato pii mindi loto, Akali Andane Gote okomane nambana Akali Andane Mesaya oko lamawuato, nambato nimba towa yanda-pene wandakali tupa nimbana kene pangosa ateakale lokalenga, nimbato nambana kii tikasa-tole pitipe leaipia. Matili Dapitina yame okomane Mesaya oko mandula-kola, bala mee Dapiti yamena mandiyene mindi atolopeya yando, anu peakale Oli Sipitisa okomane Dapitina nembo-tene mina ika laya ya-kola, Dapitito Mesaya oko balana Akali Andane oko ateya leaipiape. ");
INSERT INTO ipi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dapitito Mesaya oko andayo, bala nambana Akali Andane ateya leaipia-ko. Anu pua, Mesaya oko bala katulo mee Dapiti yamena mandiyene mindi atolo-peyape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wuane lea-kola, akali mindikipi mindimane katulo balana pii okone yano napeleai-kola, ole okone angi ato tewa, Juta yame wandakali pitaka-mane pii mindi Jisasanga tipa puyale yuku yai. ");
INSERT INTO ipi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Okone angi, wandakali kambua Jisasana disaipolo tupa towa atu amunguli peai-kola, balato utupane lamawuato, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane Mosesana panda moto, Gotena loo tupamane wua leya lo mana langiyaini lea. ");
INSERT INTO ipi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","4","Utupane-mane mana epene tupa yakama langeyai-kola, yakamato utupanena pii pitaka ale wato, wato minape-pene tekeko, yakamato utupanena mana koo tupa wato mina na-piyapape. Jia. Akali utupane-mane wandakali tupa mana lamawuato, loo kambua wetete wayumane wato minalapape loto, kenda-pene andane tupa utupanena paiyanenga yata-maiyaini tekeko, yakama tane-mane kenda-pene okonepene tupana aŋakopi mindi aimakale lo makande pua ai na-piyaini. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Akali utupane-mane Gotena pii pepa pelene eya minditupa puta andane-yale lapo puato, mindi yakama tanena wenonga yake pua ate lata alu, mindoko yakama tanena kininga kitambu ayu, piyaini. Dee, utupane-mane yakamana tona luu piyaini okona duninga eyaka luu minditupa andi lo tepa aka piyaini. Wandakali waka tupamane utupanena mana okonelapo andolai-kola, loo tupana mana andene akalipi, Patasaipi, utupane-mane Gotena pii wayumane wato minalaini ya lo andeakale nembo toto, utupane-mane mangene okonepene tupa pitaka piyaini. ");
INSERT INTO ipi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wandakali kambua-mane tomo andane mindi no peteyai-angi, akali utupane yakama akali kawane pitiyaini toko tupana pitima lakae lo nembo talaini. Utupane yakama Juta yamena lotu andaka poto, toko bulupane tupana pituyale epele wete alaini. ");
INSERT INTO ipi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wandakali waka tupamane utupane andoto, akali andane, nimba ani pelepe lapiai lakae lo nembo toto, akali utupane-mane wandakali kambua amunguli piyaini ama tupana palaini. Dee, akali utupane yakama gene yene ataima lakae lo nembo toto, wandakali-mane yakama andayo tisa lapiai lakae lo nembo talaini teke. ");
INSERT INTO ipi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Akali utupane-mane wuane piyaini tekeko, yakamana tisa mindiki angu ateya-kola, yakama pitaka amene teke-teke ateyai-ko. Wandakali-mane yakama andayo tisa leakale lo yakamato ando konda na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yakamana ayiane mindiki angu bala ati kenga ateya-ko. Yakamato yuu okona akali mindina gene oko laiyu loyale, ayiane na-lalapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dee, Kataisa bala yakamana akali andane mindiki angu ateya-ko. Wandakali-mane yakama ando akali andane leakale lo yakamato ando konda na-piyapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yakamana akali andane wete atola oko bala yakamana piape akali atape-pene. ");
INSERT INTO ipi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wandakali mindimane bala tanena gene oko laiyu leando, Goteto balana gene oko mee gulaya olopeya tekeko, wandakali mindi bala gene nayene gulo ateando, Goteto balana gene oko andane gulaya olopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wuane lalu, Jisasato pii mindi tako pua loto, loo tupana mana andene akali tupapi, Patasai tupapi, yakamato ale alapape lea. Ati kenga ateya Gote okomane yakama moyo ando ateakale lo yakama tane ando konda na-piyaini. Wandakali waka minditupa-mane Gotena pangosa atamakale nembo talaini tekeko, Goteto utupane moyo ando ateakale lo yakamato ando konda na-piyaini. Jia. Yakamato utupane mana kopeta lamawuato, Goteto utupane moyo ando atolane asini oko tuma piyaini. Yakamato wuane piyaini okonena, Goteto yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Loo tupana mana andene akali tupapi, Patasai tupapi, yakamato wanda yalo tupana anda tupa pake moyale utupane minakasa alaini. Yakamato utupane minakasa eyai-kola teke, wandakali waka tupamane yakama akali epene ateyai lo andapiai lakae lo nembo toto, yakamato pote andane luu tupa lalaini. Tene okonena, Goteto kenda-pene andane wete mindi yakamanga gulupeya-ko. Balato yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wandakali mindi bala yakamana disaipolo guleakale nembo toto, yakamato ipa solewata angini andane tupa kalo piyu, yuu tepanda tupana palaini. Poto, yakama asini luu tupana epoko pua atoto, yame waka tupana wandakali mindiki yakamana disaipolo gulaya alaini. Bala yakamana disaipolo guleya-kola, yakamato bala mo lawa puato, wandakali koo wete mindi gulaya alaini. Loo tupana mana andene akali tupapi, Patasai tupapi, yakamato wandakali tupa minakasa wato, epene gulo atalaini. Tene okonena, yakama tane yuu koo wete okona pupe-pene tekeko, yakamana disaipolo okomane yakama sia wete minuto, yuu koo wete okonena wamba kapoyale wete pupe-pene gulo atalane. Yakamato wandakali tupa wuane pua minu koyalaini okonena, Goteto yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","Minditaka golo-mane waa-pene mindi lotu anda andane okona yalane yando, okone Gotena gulalane. Tene okonena, lotu anda andane okomane minditaka golo-mane waa-pene tupa sia minuto, angini wete eya. Gotena lotu anda andane oko angini wete eya tekeko, loo tupana mana andene akali tupapi, Patasai tupapi, yakama lee koo gulo atoto, kee wato, wandakali tupa mana lamai-yaini. Yakamato mana lamawuato, wandakali mindimane mangene mindi pukale loto, pii okone mo tai laya wakale nembo toto, balato lotu anda andane oko mawua leyo loto, nambato pii enene wete leyo lapulu, mangene okone napene konda yando, yakamato okone katu lalaini. Wuane tekeko, balato minditaka golo-mane waa-pene lotu anda andane okona yalane tupa mawua leyo loto, nambato pii enene wete leyo leando, wandakali okonemane mangene okone pipe-pene lalaini. Wuane loto, wandakali lee koo tupamane wandakali yangone tupa asini kopeta andawa lalaini pua teke, yakamato mana kopeta lamawuato, yangone tupa asini kopeta andawa lalaini okonena, Goteto yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","19","Dee, wandakali-mane opa mindi Gotena alata toko okona yata yando, opa okone Gotena gulalane. Tene okonena, alata toko okomane opa okone sia minuto, angini wete eya. Alata toko oko angini wete yalane tekeko, loo tupana mana andene akali tupapi, Patasai tupapi, yakamato wandakali tupa mana lamawuato, wandakali mindimane mangene mindi pukale loto, balana pii okone mo tai laya wakale nembo toto, balato alata toko oko mawua leyo loto, nambato pii enene wete leyo leando, balato mangene okone pii napene konda yando, yakamato okone katu lalaini. Wuane tekeko, balato alata toko okonena opa yolane oko mawua leyo loto, nambato pii enene wete leyo leando, balato mangene okone pipe-pene. Yakamato wuane lalaini nembo toto, nambato yakama lee koo gulo ateyai leyo. ");
INSERT INTO ipi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wandakali mindimane balana pii mo tai laya wakale nembo toto, alata toko oko mawua leyo loto, nambato pii enene wete leyo leando, alata toko okopi, pitaka taka alata toko okona tokonga yola tupapi, utupane pitaka mawua leyo loto, nambato pii enene wete leyo lola-kola pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dee, wandakali mindimane lotu anda andane oko mawua leyo loto, nambato pii enene wete leyo leando, balato lotu anda andane okola, anda okonena atalane Gote okola, okonelapo lapotaka mawua leyo loto, nambato pii enene wete leyo lola-kola pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ati kenga yuu iyu oko bala Gotena pitiyane toko mindi eya. Tene okonena, wandakali mindimane ati kenga yuu iyu oko mawua leyo loto, nambato pii enene wete leyo leando, balato Gotena pitiyane toko okola, toko okonena pitiyane Gote okola, okonelapo lapotaka mawua leyo loto, nambato enene wete leyo lola-kola pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","24","Lee koo wandakali tupamane wandakali yangone tupa asia kopeta andawa lalaini pua teke, loo tupana mana andene akali tupapi, Patasai tupapi, yakamato wandakali yangone tupa minakasa wato, asia kopeta andawa lalaini. Oyo aŋako mindi yakamana ipa nolane kapo okona epo peteya-kola, yakamato okone angini mindi ya lo nembo toto, mo apialaini tekeko, yia kamele andane mindi yakamana ipa nolane kapo okona epo peteya-kola, yakamato okone angini mindi jia ya lo nembo toto, ipa towa mee goae lalaini. Anu peakale nambato wuane leyope. Yakamato Gotena loo andane tupa mee ya lo nembo toto, wandakali yangone tupa ondo naene atoto, utupane wayumane yapa lo tale na-piyaini. Yakamato Gote lo bilipi leyama nayu na-lalaini teke. Yakamato mana utupane wato mina napene, Gotena loo andane tupa awua tepa alaini tekeko, wandakali waka tupamane andolai-kola, yakamato Gotena loo kuai lo wato minalaini ya lo andeakale nembo talaini. Wuane nembo toto, yakamana eenga tomo aŋako wete yalane tupa yomo paiyasanga tale pua yata wato, yakamato yomo mindi Gote mayaini. Yakamato wuane puato, Gotena loo andane tupa wato minapiai-yale, yakamana mana okone kuai lapia-yale tekeko, yakamato wuane na-piyainiko. Goteto yakama minu koyolane. Yakamato ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","Loo tupana mana andene akali tupapi, Patasai tupapi, yakama tane angu nembo toto, tomopi, ipa tende-penepi, kambua pake gulo moto, yakamana kapo pelesa tupana tumbi laya alaini. Yakamato wuane piyaini tekeko, wandakali-mane yakamana mana andolai-kola, yakama akali epene ateyai lo andeakale nembo toto, yakamato utupane andakasa oyale, kapo pelesapi, kengasa wayumane wasa-wasa peyalaini. Patasai yame yakama lee koo gulo atoto, yakamana mana okone koo ya lo anda na-piyaini. Loo tupana mana andene akalipi, Patasaipi, yakamato wuane na-piyaini okonena, Goteto yakama minu koyolane. Waiwa ando atalapape. Yakamana kapo tupa kengasa kalato ata napene guleakale nembo toto, utupanena anda-pangosa wamba ini wayumane wasa-wasa peyalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Wandakali omene mindina mali anda-pangosa balana umbaini tamenepi, kulinipi, minditaka kalato atene utupane pitaka tumbi latane yalane. Wuane tekeko, wandakali-mane yangone mindina mali kenga oko ake wete peakale lo pende ake-pene mindimane pende leyai-kola, wandakali waka tupamane mali okonena kengasa angu andoto, mali paiya wete ateya lo andalaini. Wuane pua teke, loo tupana mana andene akali tupapi, Patasai tupapi, yakamato wandakali tupa minakasa eyai-kola, utupane-mane yakamana umbaini kenga angu andoto, yakama wandakali epene tika-pene ateyai nembo talaini. Utupane-mane wuane nembo talaini tekeko, yakamato Gotena loo tupa ango alaini okonemane yakamana ini anda-pangosa mana koo tupa tumbi latane atalane-ko. Goteto yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Wandakali waka tupamane andolai-kola, yakama akali epene ateyai lo andeakale nembo toto, loo tupana mana andene akali tupapi, Patasai tupapi, yakamato potopesa akali wamba omeaini tupana mali anda epene tupa piyaini. Dee, yakamato wandakali epene tika-pene wamba omeaini tupana mali tupa yati pimai-yaini teke. Wuane puato, yakamato wandakali tupa minakasa oyale, pii mindi loto, wamba nanimana yumbane tupa ateai-angi, nanima utupane towa atu atema-yale, utupane-mane potopesa akali tupa peyo ome leakale lo, nanimato utupane moya napema-yale lalaini okonena, Goteto yakama minu koyolane. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yakamato wuane lalaini okonemane yakama tane potopesa akali tupa peyo ome leaini akali utupanena mandiyene yame ateyama loto, mo pana alaini-ko. ");
INSERT INTO ipi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yakamana yumbane tupamane koo pua ateaini pua teke, yakamatopi koo puato, utupanena piape koo tupa pikoyo piyapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","36","Wamba bulupane tewa, yakamana yumbane mindimane akali epene tika-pene Epolo lene oko peyo ome leaipia. Okone angi tewa, yakamana yumbane tupamane akali epene tika-pene kambua peyo ome laka peainipia. Koyonga, akali Betekayana iwanane Sakataya bala lotu anda andane okola, Gotena alata toko okola, okone-lapona tombenenga atea-kola, utupane-mane bala peyo ome leainipia. Yuu pitakana wandakali epene tika-pene tupa omeaini okona tene oko Juta yame akali andipa ateyai tupa yakamanga yakale nembo toto, nambato potopesa akalipi, akali wai-enepi, loo tupana mana andene akalipi, utupanena minditupa yakama atolainga epeakale lolo-peyawa. Utupane epolai-kola, yakamato utupanena minditupa ita malamanda okona peyo yuka alu, waka minditupa mee peyo ome lolopeyai. Dee, akali utupanena minditupa yakamana lotu anda tupana atolai-kola, yakamato utupane kunju-mane peyolo-peyai. Wandakali utupane tano waka tupana palaka polai-kola, yakamato utupane watama poto, kenda-pene andane tupa maiki pulupeyai. Mana koo utupane pitakana yole koo oko Goteto wandakali andipa ateyai tupa yakamanga gulupeya lo nambato pii enene oko yakama langeyo. Yakama puya koo tupana mandiyene tupa gulo ateyai okonena, Goteto yakama kosimi loto, yakama yuu koo wetete okona pulupa lo wata ainena lolopeya. Balato wuane pula-angi, yakamato kenda-pene okone peya wanju olane asia mindi nayolopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Okone angi, Jisasato pii mindi tako pua loto, Jutusaleme tane wandakali yakamato potopesa akali tupa peyo ome lalaini leaipia. Dee, Goteto balana piape akali minditupa yakama ateyainga epeakale laka peya-kola, yakamato utupane ana-mane peyo ome lalaini. Eka angini mindimane balana andopane tupa papakane pangosa paleakale loto, mo amunguli piyane pua teke, ole kambuanga nambato Jutusaleme tane wandakali yakama namba atewanga mo amunguli piwa lakae lo nembo tewa tekeko, yakamato embo yai. ");
INSERT INTO ipi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tene okonena, nambato yakama tepa alu polowa-kola, yakamana anda oko mee ukuna atolopeya leyo okone yakamato ale alapape. ");
INSERT INTO ipi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Andipa oko angi tewa, nambato yakama tepa alu polowa-kola, yakamato namba anda napene atama pulu, matili yakamato pii mindi loto, Goteto akali epeya oko bala epeakale loto, wayumane moyapia lolopeyai. Yakamato wuane lolai-angi, namba dee lapone andolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisasa bala lotu anda andane ende okona kamaka poto, mindisa poyale pea-kola, balana disaipolo tupamane epoto, lotu anda andane ateya okona anda waka pua kimbu pitane ateyai tupa anda-kae leai. ");
INSERT INTO ipi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wuane leai-kola, Jisasato utupane lamawuato, andipa yakamato anda epene wete ana-mane pitane ateya utupa pitaka andeyai tekeko, nambato pii enene mindi yakama langeyo. Matili akali minditupa epoto, anda utupana ana mindikipi mindi balana ana yangone tokonga yakale lo ando konda na-olopeyai. Jia wete. Utupane-mane ana utupa pitaka keao loto, yuunga tepa ayiake laya olopeyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Matili, Jisasa bala angu Olipi wangiane okona petea-kola, balana disaipolo tupa yakama angu bala peteanga epeai. Epoto, utupane-mane bala tipa puato, andoko angi akali minditupa-mane lotu anda andane oko minu koyolo-peyaipe leai. Mangene anu-pene mindi wamba ini bulupane pula-kola, nanimato andoto, nimba dee lapone epoyale pele lo andolo-peyamape. Dee, mangene anu-pene tupa pula-kola, nanimato andoto, andipa yuu oko koyo puyale peya lo andolo-peyamape. Nimbato nanima langi leai. ");
INSERT INTO ipi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, matili akali kambua mindiki-mindiki lo yale-yale ipuku puato, namba Mesaya oko epeyo loto, wandakali kambua minakasa olopeyai-ko. Akali mindimane namba Mesaya oko epeyo loto, yakama minakasa olaini. Waiwa ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","7","Matili wandakali yame mindimane wandakali yame waka mindi yanda pimaulai-kola, tili-tula lo atola tupa yakamato ale olopeyai. Dee, yuu andane wete mindina tane wandakali tupamane yuu andane wete waka mindina tane wandakali tupa yanda pimaulai-kola, wandakali utupane-mane yanda andane mindi pua ateyai lene oko yakamato ale olopeyai. Wandakali utupane-mane wuane pipe-pene guleya tekeko, okone angi teke yuu oko wamba kapoyale koyo napulu-peyako. Wandakali-mane yanda pua atolai-angi, yakamato okone ale wato, nembo kambua toto, yuku aa na-piyapape. Jia. Okone angi, yuu minditupana ulia nono andane tupa yolopeya. Dee, yuu minditupana yuu titiwali tupa lolopeya teke. ");
INSERT INTO ipi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kenda-pene utupane pitaka wanda-mane andopane manduyale wamba ini masia peyalane okonepene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Okone angi, yakama nambana yame atolai mambele, wandakali yame palu peyai tupa pitaka-mane yakama towa mini koo wete palu atoto, kenda-pene andane tupa yakama gulupeyai. Akali waka minditupa-mane yakama tandaka andane guato, yakama peyo ome leakale nembo toto, wandakali minditupa-mane yakama ene pitulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wuane pulai-kola, wandakali kambua-mane namba lo bilipi lalaini mana oko awua tepa alu, namba lo bilipi lene wandakali yangone tupa towa mini koo wete paluto, utupane ene pituto, utupane towa yanda-pene akali tupanga malupeyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Owato potopesa akali kambua epoto, wandakali kambua minakasa olopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wandakali kambua-mane Gotena loo tupa ango olai-kola, wandakali kambua-mane wandakali yangone towa epelewa yamapane yo atalaini mana okone awua tepa olopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Utupane-mane wuane pulupeyai tekeko, wandakali mindimane kenda-pene utupane awua atoto teke, namba lo bilipi lalaini mana oko awua tepa nayando, Goteto bala molo-peke lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wandakali pitaka-mane Gotena pii epene okone ale yakale nembo toto, wandakali minditupa yuu eya tupa pitakana atoto, ati kenga ateya Gote okomane pitaka taka ando atalane lolopeya. Matili utupane-mane pii okone wandakali tupa pitaka lamai-koyo pulai-angi, yuu oko koyo pulupeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pii oko dii lo andolai wandakali yakamato pii nambato andipa pepa peleyo oko wayumane nembo tape-pene. Jisasato pii mindi wamba potopesa akali Daniyele okomane leane okonena tako pua loto, matili wandakali yame waka tupamane owato gote mindi waa puato, Gotena lotu anda andane epene wete okona ate lolopeyai lea. Goteto andola-kola, owato gote okonemane lotu anda andane epene wete okone balana wenonga mo kalato ataya ola-kola pulupeya. Pepa oko dii lo andolai wandakali yakamato andolai-kola, minditaka koo wete okone lotu anda andane okona atolanga andolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yakamato okone andolai-angi, Jutiya disitiki okona atolai wandakali yakama yuu wangiane tupana palaka pupe-pene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Palaka pupe-pene gulola-angi, wandakali mindi balana anda okona takita ateando, balana minditaka andaka yolane tupa mokale nembo toto, anda-pango kolandaka nalene, mee palaka pupe-pene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dee, wandakali mindi bala eenga ateando, balana tona kenga piyane oko moyale, andaka peke nalene, mee palaka pupe-pene teke. ");
INSERT INTO ipi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Okone angi, wanda andopane ininga piti-pata tupapi, wanda andopane andu no atene tupapi, utupane palaka pupe-pene pitete wato, ondo wete ape-pene gulo pitulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Wamba wetete Goteto yuu ati-la yakale lea-angi tewa, kenda-pene waka-waka kambua yama ipulu, andipa ateyama oto okona giau leya tekeko, kenda-pene epola okonemane utupane pitaka sia minuto, andane wete mindi epolopeya. Kenda-pene andane okonepene mindi matili-matilipi lapone naepolo-peya. Upa wete puato, pipiya peleando, palaka pupe-pene pitete pulupeya. Sambasa-angi, asia luu pupe-pene jia lene eya-ko. Pipiya peyola-kola yandopi, Sambasa oko epola-kola yandopi, kenda-pene andane okone epolane. Yakamato pote lo atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Goteto kenda-pene utupane ee ana kambua tupana epeakale lo ando konda yando, wandakali pitaka omolo-peya tekeko, balana yame ateakale lata atane wandakali tupa pitaka omolaini nembo toto, Goteto kenda-pene utupane ana ukupini mindilapo angu epeakale lo ando kondolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Matili owato Mesayapi, owato potopesa akalipi, utupanena minditupa-mane wandakali tupa minakasa amakale nembo toto, mindiki-mindiki lo yale-yale ipuku pulupeyai. Epoto, Mesaya oko namba epeyo leandopi, potopesa akali enene mindi namba epeyo leandopi, okone-lapona mindi epeyo lo andawa loyale, utupane-mane metekolo piape andane minditupa pulupeyai. Wuane puato, utupane-mane katulo Gotena yame ateakale lata atane wandakali tupapi minakasa olopeyai pia-yale, utupane-mane wuane pulupeyai. Tene okonena, wandakali mindimane yakama languato, Mesaya oko bala onga ateya oko andalapa leandopi, dee bala amokusa ateya oko andalapa leandopi, akali okonemane enene leya lo yakamato nembo na-talapape. Jia. ");
INSERT INTO ipi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ale alapape. Matili wandakali minditupa-mane wuane pulupeyai lo nambato yakama wamba ini langeyo okoni. ");
INSERT INTO ipi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Ati tapale oko nai epalanesa ato tewa, tii pima pulu, nai andaka palane ukusane puapo peya-kola, wandakali pitaka-mane katulo ati tapale okone andalaini pua teke, matili Akalina Iwanane oko panakame epola-kola, wandakali pitaka-mane katulo bala epola oko andolopeya. Tene okonena, wandakali-mane yakama languato, Akalina Iwanane oko bala wandakali napalene yuu okona epo ateya leaindo, yakamato bala andamakale nembo toto, yuu okonena puu na-piyapape. Dee, utupane-mane bala anda mindina epo peteya leaindo, utupane-mane enene leyai lo yakamato nembo na-talapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Minditaka omene mindi yolanga, eka aiyawe tupa amunguli pulai-kola, yakamato andolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wuane lalu, Jisasato pii mindi tako pua loto, kenda-pene andane utupane epo koyo pula-kola, Goteto iyu okona minditaka tai ateya tupa mo ema-ema piya ola-kola, nai, ana-la, lapotaka undupi lalu, atinga kaiyanda ateya tupa yuunga ondo tepa aka pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wuane pula-angi, Akalina Iwanane oko epeyo lo andawa loyale ati kenga iyu okona minditaka mo pana ola-kola, yuu okona wandakali palu pula tupa pitaka-mane okone andoto, ai lolopeyai. Utupane-mane andolai-kola, Akalina Iwanane oko bala ati kenga tawe mole tupana tokonga atoto, balana tai-lene andane okopi, tii-pene andane okopi, okonelapo towa epolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Okone angi, biakulu mindi taimane wete peyola-kola, Akalina Iwanane okomane balana enjole tupa lamawuato, yakamato nambana yame ateakale lata atane wandakali tupa lamolo pulupa lolopeya. Wuane lola-kola, enjole utupane-mane yuu tupa pitakana poto, Gotena wandakali utupane pitaka lamo atu epolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wuane lalu, Jisasato pii kokoli mindi loto, yakamato ita piki tupa andoto, mana mialapape lea. Ita piki tupana kembonenga ipane epo peteya-kola, yokone wenene tupa kome piyane. Yakamato yokone utupane andoto, panyu puyale peya lo andalaini. ");
INSERT INTO ipi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wuane pua teke, matili mangene minditupa wamba ini pulupeya leyo tupa pula-angi, yakamato mangene utupane pitaka andoto, Akalina Iwanane oko bala mandaka epoto, asia lombanga atalua nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nambato pii enene mindi yakama langeyo. Wandakali yame andipa ateyai tupa pitaka oma yiake nalolai-kola, mangene utupane pitaka pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Matili yuu ati-la alu pulupeya tekeko, matili-matilipi nambana pii oko alu napulu-peya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wuane lalu, Jisasato pii mindi tako pua loto, mangene minditupa pulupeya lalo utupane oto andokona pulu-peyape, taeme andokona pulu-peyape lo wandakali mindikipi mindimane nembo nateya lea. Ati kenga enjole ateyai tupapi, Akalina Iwanane okopi, utupane-mane nembo nateyai teke. Jia. Ayiane okomane angu nembo teya. ");
INSERT INTO ipi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wamba akali Nowa atea-angi, Goteto mangene andane mindi peane pua teke, matili Akalina Iwanane oko epola-angi, Goteto mangene andane mindi pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa ateane okone angi, ipa andane wetete oko wamba ika laa napenenga, wandakali-mane Gote masia mawua ateainipia. Gote masia mawua atoto, akali-mane wanda kee laka, wanda-mane akali puku, wandakali-mane tomo ipapi naka, piki pua atama pulu, Nowa bala sipi andane wete okona kolandaka leane oto okona giau leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nowa bala sipi andane wete okona kolandaka leane-angi, Goteto mangene andane mindi pulupeya lo wandakali utupane-mane nembo nateaini tekeko, ipa andane wetete mindi yuungapi, atingapi, lapotakanga ika loto, utupane pitaka peyo pulu peaipia. Wuane pua teke, matili Goteto mangene andane mindi pulupeya nembo natene, wandakali-mane ole dindi lo mana minalaini tupa minu atolai-kola, Akalina Iwanane oko bala epolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bala epola-angi, akali lapo eenga atolapi-kola, balana enjole tupamane mindi lamialu, mindoko ateakale kondolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dee, wanda lapo palawa waa puyale witi dini taki lo pitulapi-kola, balana enjole tupamane mindi lamialu, mindoko peteakale kondolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yakamana Akali Andane okone andoko angi epoto, wuane pulupeya lo yakamato nembo nateyai-ko. Yakamato lee too ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anda anduane mindimane andola-kola, pake nene akali mindi utulu oko angi epolopeya lo wamba ini andapia-yale, pake nene akali okonemane balana anda okone keao lolane lo bala tane andatawa atapia-yale lo yakamato nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wuane pua teke, yakamato Akalina Iwanane oko naepolo-peya nembo tolai-angi, bala epolo-peyako. Bala epolopeya nembo toto, yakamato makande pitawa atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wuane lalu, Jisasato pii minditupa tako pua loto, piape akali mindimane wai-ene atoto, ole dindi lo piape kuai lo piyane yando, balana akali andane okomane bala lamawuato, nimbana piape akali yangone tupa ando atoto, ole dindi lo tomo nolane taeme oko epola-angi, utupanena tomo tale pua maipe lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Piape akali okonemane piape kuai lo pua ateando, matili balana akali andane oko peke loto, minditaka epene tupa bala maula-kola, piape akali okone bala epele wete olopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Akali andane okonemane piape akali epene okone lamawuato, nimbato nambana minditaka eya tupa pitaka ando atape lolopeya lo nambato pii enene mindi yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wuane pulupeya tekeko, piape akali okone bala akali koo mindi ateando, balato akali andane oko wamba ini peke nalolo-peya nembo tolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wuane nembo toto, balana piape akali yangone tupa minu peyaka puato, bia ipa tai no kewa atalaini akali tupa towa atu tomo ipa ima nolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Oto mindina balana akali andane oko naepolo-peya nembo toto, piape akali okonemane mandeke napene atolopeya. Okone angi teke, balana akali andane oko epoto, piape akali okone wete minu koyoto, minakasa alaini wandakali tupa towa ateakale lolopeya. Wuane lola-kola, piape akali koo okone bala yuu koo okonena atoto, yamataka lo nene geleto laka pua atolopeya. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Wuane lalu, Jisasato pii kokoli mindi tako pua loto, wana mapokae paiyasa-mane wanda kee lolane akali mindi asininga malanda olo makale nembo toto, yakamana lamu tupa kaiyu awua poto, bala epeakale lo maliyo peteaini-pia. Wuane pua teke, matili Akalina Iwanane okomane wandakali tupa moyo ando atokale nembo toto, bala dee lapone epolopeya oto oko wandakali minditupa-mane maliyo atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Wana mapokae paiyasa utupanena yau yangisa tupa yakama wai-ene pituto, katasini minditupa pene mindina ambu pete loto, lamu tupa towa awua peainipia. Utupane-mane wuane peaini tekeko, wana mapokae yau yangisa tupa yakama wai naene pituto, katasini minditupa pene mindina ambu pete lo awua naepene, yakamana lamu tupana angu peteakale loto, awua peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wana mapokae paiyasa tupamane wanda kee lolane akali okone epeakale lo maliyo peteaini tekeko, bala ini naepea-kola, utupane pitaka limu wato, palu ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Limu palu ateai-kola, utulu tombe wete okona mindimane ee loto, wanda kee lolane akali oko bala epeya-ko. Yakama bala malanda olo pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wuane lea-kola, wana mapokae utupane pitaka ika loto, yakamana lamu tupa mo mandeke peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yakamana lamu tupa mandeke puato, wana wai naene tupamane wana wai-ene tupa lamawuato, nanimana lamu tupana katasini koyo puyale peya-ko. Yakamato katasini minditupa nanima giyapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wuane leai-kola, wana wai-ene tupamane utupanena pii okone yano peyoto, katasini utupa-mane nanimana lamu tupapi, yakamana lamu tupapi, pitaka katulo tumbi nalolo-peya yako. Yakama tane sisoa anda tupana poto, katasini minditupa kambalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wuane leai-kola, wanda wai naene utupane yakama katasini kambolo peainipia. Peai-kola, wanda kee lolane akali okone bala epoto, wana mapokae yau yangisa makande pitawa peteaini utupane towa atu peainipia. Poto, wanda kee lolane tomo andane yango yaini anda okona anda-pango kolandaka leai-kola, wanda kee lolane akali okomane anda okonena asia pii leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Matili wana mapokae yau wamba mandeke napene peteaini utupane epoto, wanda kee lolane akali okone lamawuato, akali andane, akali andane, nanima andaka ipumakale, nimbato asia lumba leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Utupane-mane wuane leaini tekeko, balato utupanena pii okone yano peyoto, nambato pii enene mindi yakama langeyo. Nambato yakama anda na-peyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wuane pua teke, Akalina Iwanane oko bala dee lapone epolane oto okopi, taeme okopi, okonelapo yakamato nembo nateyai-ko. Bala epolopeya nembo toto, yakamato makande pitawa atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Wuane lalu, Jisasato pii kokoli mindi tako puato, akali mindimane yuu tepanda mindisa pokale nembo toto, balana piape akali tupa epeakale leane leaipia. Balato utupane epeakale loto, utupane-mane balana minditaka yane tupana minditupa ando ateakale lo tale pua mayaepia. Wuane pua teke, Akalina Iwanane okomane wandakali tupa moyo ando atokale nembo toto, utupane-mane balana minditaka yane tupa ando ateakale lo tale pua mayane. ");
INSERT INTO ipi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yuu tepanda mindisa poyale peane akali okonemane balana piape akali mindiki-mindiki lo katulo piape oko-tuma pulupeya nembo toto, piape akali mindi (5,000) paepe tausene kina maiyu, akali mindi (2,000) tu tausene kina maiyu, akali mindi (1,000) wane tausene kina maiyu, bala yuu tepanda okonena peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pea-kola, (5,000) paepe tausene kina meane akali okomane wamba kapoyale bisanisa piape puato, (5,000) paepe tausene kina teke tako pua meaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wuane pua teke, (2,000) tu tausene kina meane akali okomane bisanisa piape puato, (2,000) tu tausene kina teke tako pua meaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Akali okonelapo-mane wuane peapele tekeko, (1,000) wane tausene kina angu meane akali okonemane poto, yuli mindi tomboto, balana akali andane okona muni meane tupa mali peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Matili ana kambua pea-kola, piape akali utupanena akali andane oko bala peke loto, utupane mindiki-mindiki lo tipa puato, nimbato potopisa muni aki-tupi meepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wuane lea-kola, (5,000) paepe tausene kina meane akali okomane potopisa muni (5,000) paepe tausene kina teke tako pua meane oko awua epoto, akali andane, nimbato (5,000) paepe tausene kina namba gee okonemane nambato bisanisa piape puato, (5,000) paepe tausene kina teke tako pua mewane oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wuane lea-kola, balana akali andane okomane bala lamawuato, nimba piape akali epene atoto, nambana piape kuai lo wete pingeene ya leaipia. Nimbato nambana minditaka aŋalapo tupa kuai lo ando atapini okonena, nimbato nambana minditaka kambua tupa ando atola lokale. Nimba namba towa atu epelewa atapakale ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wuane pua teke, (2,000) tu tausene kina meane akali oko epoto, akali andane, nimbato (2,000) tu tausene kina namba gee okonemane nambato bisanisa piape puato, 2,000 kina teke tako pua mewane oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wuane lea-kola, balana akali andane okomane bala lamawuato, nimba piape akali epene atoto, nambana piape kuai lo wete pingeene ya leaipia. Nimbato nambana minditaka aŋalapo tupa kuai lo ando atapini okonena, nimbato nambana minditaka kambua tupa ando atola lokale. Nimba namba towa atu epelewa atapakale ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Wuane lea-kola, (1,000) wane tausene kina meane akali oko balapi epoto, bala lamawuato, akali andane, wandakali waka tupamane ee mindi yandeyai-kola, nimbato utupanena tomo tikayu mandalini leaipia. Dee, wandakali waka tupamane tomo waini papaka leyai-kola, nimbato utupanena tomo tikayu mandalini. Nimbato wuane pilini okonena, nimba tane angu nembo toto, nimbato kenda-pene tupa wandakali waka tupa mailini lo nambato andeyawane. ");
INSERT INTO ipi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tene okonena, namba yuku wato, nimbana muni tupa too puato, yuli mindi tombalu, mali pewa. Nimbana muni tupa oo eya oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wuane lea-kola, balana akali andane okomane balana pii okone yano peyoto, nimba piape akali koo kepa-ene ya leaipia. Wandakali waka tupamane ee mindi yandeyai-kola, nambato utupanena tomo tikayu mandiyane lo nimbato andalenepe. Wandakali waka tupamane tomo waini papaka leyai-kola, nambato utupanena tomo tupa tikayu mandiyane lo nimbato andalenepe. ");
INSERT INTO ipi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wuane yando, nimbato nambana muni tupa potopisa mandeakale loto, beŋe mindina yata ee-yale, namba peke loto, nambana muni utupana potopisa minditupa towa miauwa-yale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","Wuane lalu, akali andane okonemane balana piape akali waka tupa lamawuato, minditaka kambua nayene wandakali okona minditaka aŋalapo yolane tupa nambato molo-peke lokale tekeko, minditaka kambua yene wandakali tupanga nambato minditupa konda pua maluwa-kola, utupanenga minditaka kambua wete yolopeya leaipia. Nambana piape akali koo okomane piape kuai lo napipia-ko. (1,000) wane tausene meane balato awua ateya oko yakamato moto, (10,000) tene tausene kina awua ateya akali okonenga mayapa. ");
INSERT INTO ipi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Maiyu, yakamato piape akali koo oko bala yuu koo undupi-lene okona awua aindaka lalapa. Bala yuu koo okonena atoto, yamataka lo nene geleto laka pua atolopeya. Akali andane okonemane wuane leane lo Jisasato lea. ");
INSERT INTO ipi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wuane lalu, Jisasato pii minditupa tako pua loto, matili Akalina Iwanane oko balana tai-lene oko towa epoto, bala akali andane kiŋi atolopeya lea. Balana enjole tupa pitaka towa atu epoto, bala kiŋi pitiyane toko epene wete mindina pitulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pitula-kola, balana enjole tupamane wandakali yame palu peyai tupa pitaka balana wenonga mo amunguli pulupeyai. Amunguli pulai-kola, sipisipi, meme-la, okonelapo lapotaka yatawa atalaini akali tupamane utupane yame lapo ateakale loto, utupane yapa lo tale piyaini pua teke, Akalina Iwanane okomane wandakali tupa pitaka yame lapo ateakale loto, yapa lo tale pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Utupane yapa lo tale puato, balato sipisipi gulene wandakali epene tika-pene atolaini tupa balana kii tikasa-tole ateakale loto, meme gulene wandakali atolaini tupa balana kii koyasa-tole ateakale lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Balato wandakali tupa pitaka yapa lo tale pikoyo pula-angi, kiŋi okomane balana kii tikasa-tole wandakali atolaini tupa lamawuato, namba tomo ipapi nonowa atewa-kola, yakamato tomo ipapi namba geai lolopeya. Namba akali opene gulo epewa-kola, yakamato namba yatawa paleai. Namba tona jia yo atewa-kola, yakamato tona geai. Namba siki omewa-kola, yakamato namba moyai. Namba katapusa atewa-kola, yakamato namba andolo epeai. Yakamato wuane pulupeyai nembo toto, wamba nambana ayiane okomane yuu ati-la yakale lea-angi, ati kenga yuu epene wetete atolane panda mindi yakamana paluni yakale leane. Andipa yakamato yakamana paluni okone molo ipulupa. Kiŋi okonemane wuane lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wuane lola-kola, wandakali epene tika-pene tupamane balana pii okone yano peyoto, akali andane, andoko angi nimba tomo ipapi nonowa atee-kola, nanimato andoto, tomo ipapi gemape lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Andoko angi nimba akali opene gulo epee-kola, nanimato andoto, nimba yatawa palemape. Andoko angi nimba tona jia yo atee-kola, nanimato tona gemape. ");
INSERT INTO ipi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dee, andoko angi nimba siki omee-kolapi, katapusa atee-kolapi, nanimato nimba andolo epemape lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wuane lolai-kola, kiŋi okonemane utupane lamawuato, nambato pii enene mindi yakama langeyo. Wamba yakamato nambana wandakali yangone gene nayene wete utupanena mindi moyai okomane yakamato namba moyai-kola peai lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Wuane lalu, kiŋi okomane balana kii koyasa atolaini wandakali utupane lamawuato, wamba namba tomo ipapi nonowa atewa-kola, yakamato tomo ipapi gii napeai lolopeya. Namba akali opene gulo epewa-kola, yakamato namba yatawa napaleai. Namba tona jia yo atewa-kola, yakamato tona gii napeai. Namba siki omewa-kola, yakamato namba moya napeai. Dee, namba katapusa atewa-kola, yakamato namba andolo naepeai. Wamba Goteto Satanepi, balana enjole koo tupapi, utupane ita too atapowa atene yuu koo okona peakale lo makande pua yata yane. Wandakali nambana kii koyasa ateyai tupa yakamato namba moya napeaini okonena, Goteto kenda-pene andane wete mindi yakamanga epeakale leya-ko. Yakama namba tepa alu, yuu koo wete okonena pulupa. Kiŋi okonemane wuane lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wuane lola-kola, utupane-mane balana pii okone yano peyoto, Akali andane, andoko angi nimba opene gulo epee-kola, nanimato nimba yatawa pali napemape lolopeyai. Andoko angi nimba tomo ipapi, tonapi, utupane jia yo atee-kola, nanimato gii napemape. Andoko angi nimba siki omee-kolapi, katapusa atee-kolapi, nanimato nimba andolo na-epemape lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wuane lolai-kola, kiŋi okonemane utupane lamawuato, yakamato wandakali gene nayene wete tupa moya napeai okonemane yakamato namba moya napeai-kola teke pea lo nambato pii enene mindi yakama langeyo lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wuane lalu, Goteto wandakali utupane yole koo wetete mindi maula-kola, wandakali utupane yakama yuu koo okona poto, tandaka andane wete no atapowa atolopeyai tekeko, wandakali epene tika-pene tupa saka atapowa atolopeyai. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Jisasato pii manapi utupane pitaka lamai koyo piyu, balana disaipolo tupa lamawuato, ole lapo angu pola-kola, Pasopa tomo nolane oto andane oko epolopeya lo yakamato nembo teyai. Ole okone angi, gapomane okomane Akalina Iwanane oko ita malamanda okona peyo yuka yakale loto, bala towa yanda-pene akali tupamane bala gapomane okona piape akali tupana kininga malupeya lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Balato pii okone balana disaipolo tupa lamawua atea-angi, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane yakama pitisa akali kawane Kayapasa lene okona andaka amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Amunguli piyu, utupane-mane pii mindi lo puta puato, nanimato langa-langa puato, Jisasa andi lalu, peyo ome lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Utupane-mane wuane lalu, pii mindi tako pua loto, Pasopa tomo nolane oto andane okona nanimato Jisasa andi loto, peyo ome lemando, wandakali tupamane andoto, nanima towa yataka wato, yanda pingulaini. Ole waka mindina, nanimato bala andi loto, peyo ome lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Matili Jisasa bala Betani tano okona atoto, akali wamba tapa peane Saimone okona andaka petea. ");
INSERT INTO ipi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisasa bala akali okonena andaka tomo no petea-kola, wanda mindimane wele tunduma-pene muni andane wete-mane kambalaini mindi awua epea. Wele okone botolo epene wete mindina piti-pata Jisasa peteanga awua epoto, balato wele okone Jisasana kawanenga gae loto, aiya maya. ");
INSERT INTO ipi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Wuane pea-kola, Jisasana disaipolo tupamane andoto, yataka wato, wandakali mindimane wele okone kambapia-yale, wanda okonemane muni kambua mipia-yale. Moto, balato katulo wandakali koo tipia tupa moyapia-yaleko. Anu peakale balato wele okone Jisasana kawanenga gae lo apeyape leai. ");
INSERT INTO ipi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","12","Wuane leai-kola, Jisasato utupane lamawuato, wandakali tipia tupa ole dindi lo yakama towa atu atolopeyai tekeko, namba ole dindi lo yakama towa atu ata napulu-peyama. Matili wandakali-mane namba mali pulai-angi, wele nambana umbaininga gae loto, mali pulupeyai oko makande pua, wanda okomane mana epene wete oko nambanga miniya-ko. Anu peakale yakamato balanga kenda-pene mindi mayaipe. ");
INSERT INTO ipi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Matili-matilipi, wandakali minditupa yuu eya tupa pitakana atoto, Gotena pii layene epene oko lamawuato, wanda okona mana okone nembo tolo-peke loto, balato wuane peane lolopeyai lo nambato pii enene mindi yakama langeyo. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Okone angi, Jisasana disaipolo alesa akali tupana Jutasa Isaka-tiyote lene oko bala pitisa akali kawane tupa ateainga peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Poto, balato utupane tipa puato, nambato Jisasa ene petewando, yakamato aki minditaka namba gulu-peyaipe lea-kola, utupane-mane muni silipa-mane waa-pene paiyasa tepo mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mayai-kola, okone angi ato tewa, Jutasato Jisasa ene pituyale asini mindi aiya peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Betesanga yisa napalene nalaini oto bulupane oko epea-kola, disaipolo tupamane Jisasa ateanga epoto, nimba Pasopa tomo tupa nola nanimato aninga makande pipiai lakae lo nembo telepe leai. ");
INSERT INTO ipi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wuane leai-kola, balato utupane lamawuato, yakamato Jutusaleme poto andolai-kola, akali mindi atolopeya. Yakamato akali okone lamawuato, nanimana tisa okomane pii mindi loto, nambato mangene mindi pula nayuto, oto Goteto yata yane oko mandaka epeya-kola, nambato Pasopa tomo tupa nambana disaipolo tupa towa nimbana andaka namakale lala lo lamai-yapape lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wuane lea-kola, balato leane pua puato, utupane-mane Pasopa tomo tupa makande peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Matili nai andaka pea-kola, Jisasato balana disaipolo alesa tupa towa atu tomo no peteai. ");
INSERT INTO ipi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tomo no pituto, balato utupane lamawuato, nambato pii enene mindi yakama langeyo. Yakamana mindimane namba ene pitulu-peyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wuane lea-kola, disaipolo tupa yakama yamapane kenda wete wato, mindiki-mindiki lo Akali Andane, nimbato namba andayo nalolo-pele yalua laka peai. ");
INSERT INTO ipi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","24","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gotena pii pepa pelene eya mindimane loto, Akalina Iwanane oko bala wua pua omolo-peya layene eya pua omolo-peya tekeko, ene pitula akali oko bala ondo wete ape-pene. Angini-mane akali okone mandi napea-yale, katu lapia-yale layene eya. Namba towa disa mindiki okona betesa tanda puato, neyapa akali okomane namba ene pitulu-peya lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wuane lea-kola, bala ene peteane akali Jutasato bala lamawuato, tisa, nimbato namba andayo nalolo-pele yalua lea. Wuane lea-kola, Jisasato balana pii okone yano peyoto, nambato nimba andayo leyo lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisasato balana disaipolo tupa towa atu tomo no pituto, betesa mindi moto, Gote wayu pele loto, betesa okone konde lea. Konde loto, balana disaipolo tupa mawuato, oko nambana umbaini oko. Yakamato mo nalapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Wuane lalu, balato kapo waene petene mindi moto, Gote wayu pele loto, balana disaipolo tupa mawuato, nambana tundupa gae lolowa okomane wandakali kambua tupana koo tupa apolopeya lo nambato pii wenene mindi lo yata eyo-ko lea. Yakama pitaka-mane mo nalapa. ");
INSERT INTO ipi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Andipa ato tewa, nambato waene oko nanene atama pulu, matili nambana Ayiane okomane wandakali tupa pitaka moyo ando atola-angi, nambato yakama towa atu waene waka mindi nolo-peyama lo nambato yakama langeyo lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wuane lalu, Jisasato utupane towa soŋo mindi lalu, Jutusaleme tepa alu, Olipi wangiane okona peai. ");
INSERT INTO ipi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Okone angi, Jisasato balana disaipolo tupa lamawuato, wamba Goteto pii mindi loto, nambato sipisipi yatawa atalane akali oko peyo ome lolowa-kola, sipisipi tupa palaka puu toko lolopeyai lea. Potopesa akali mindimane pii okone pepa peleane pua teke, andipa utulu yakama pitaka-mane nambanga tungi peleyai oko awua tepa alu, palaka puu toko lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yakamato wuane pulupeyai tekeko, Goteto namba malinga ika laya ola-angi, namba wamba ini ingane Galili disitiki okona polowa-kola, yakama matili epolopeyai lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wuane lea-kola, Pitato balana pii okone yano peyoto, akali waka tupa pitaka-mane nimbanga tungi peleyai oko auwu tepa alu, palaka peaindopi, matili-matilipi nambato wuane napulu-peyawa. Jia wete lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wuane lea-kola, Jisasato bala lamawuato, nambato pii enene mindi nimba langeyo. Andipa utulu oko angi teke eka pauli maipa mindimane pii wene lola-kola, ole tepoainga nimbato wandakali minditupana wenonga atoto, Jisasa anda na-peyawane lolopele lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wuane lea-kola, Pitato balana pii okone yano peyoto, namba nimba towa atu omape-pene guleandopi, okone atu tekeko, nambato nimba anda na-peyawane nalolo-peyawa. Jia wete lea. Wuane lea-kola, disaipolo waka tupa pitaka-mane wuane teke leai. ");
INSERT INTO ipi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Okone angi, Jisasa balana disaipolo tupa towa atu yuu Gesemani lene okona peai. Pulu, balato utupane lamawuato, namba amonga pote lolo peyo-ko. Yakama onga pitiyapa lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wuane lalu, balato Pitapi, Sepiti iwanane lapo okolapopi, utupane bala atu aiyu amonga-yale peai. Pulu, okone angi ato tewa, bala yamapane kenda andane wete wato, anu puape lo nembo kambua teaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nembo kambua toto, balato balana disaipolo tupa lamawuato, nambana yamapane oko kenda andane wetete peya okomane namba omape-pene gulalua-ko. Anu pulu-peyape lo andamakalenga, yakama onga atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wuane lalu, bala ambinga-yale poto, yuunga tombawua lo pote loto, nambana Ayiane Gote, kapo penenga petene gulo tandaka nambato nape-pene oko peya wanju olane asini mindi yando, nimbato asini okone lumbape. Nimbato wuane pula lo nambato nembo teyo tekeko, nambato nembo teyo pua napene, nimba tane nembo tele pua pipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wuane lalu, bala peke loto andea-kola, balana disaipolo tepo akali utupane limu palu yainga andoto, balato Pita tipa puato, namba pote lo ateyo-kola, yakamato katulo awa mindiki ando ata napeyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Enene, yakamato ando ataima lakae lo nembo teyai tekeko, yakamana umbaini tai naleya-kola, yakamato ando ata napene, limu paleyai. Sataneto yakama minu makande pula-kola, yakama yuunga peakolaini. Yakamato pote lo atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wuane lalu, balato dee lapone ambinga-yale poto, pote loto, nambana Ayiane, kapo penenga petene gulo tandaka nambato nape-pene oko peya wanju olane asini mindi nayola-kola, nambato tandaka okone nape-pene guleando, nimbato nembo tele pua pipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wuane lalu, Jisasa balana disaipolo tepo akali tupa ateainga peke loto andea-kola, utupane yakama dee lapone limu wete wato, palu yainga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Andoto, bala pai pua utupane tepa alu poto, pote wamba leane wuane pua teke pote lolo-peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pote lokoyo piyu, balana disaipolo tupa ateainga peke loto, balato utupane tipa puato, yakama mee oto mo limu teke palu ateyaipe leaipia. Akali mindimane Akalina Iwanane ene pitulane oto oko ipupia-kola, koo piyaini akali tupamane namba andi leakale loto, utupanena kininga malupeya. ");
INSERT INTO ipi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Namba ene pitipia akali oko bala wamba mandaka epeya oko andalapa. Nanimato bala malanda olo makale-ko. Ika lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisasato wuane lo atea-kola teke, balana disaipolo alesa tupana akali Jutasa lene oko bala akali kambua wete tupa towa atu epea. Pitisa akali kawane tupapi, Juta yame ando atalaini akalipi, utupane-mane akali utupane epeakale leai-kola, utupane-mane kandepa luupi, mulipi, utupane awua epeai. ");
INSERT INTO ipi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jisasa ene pitukale nembo toto, wamba Jutasato akali utupane lamawuato, nambato akali mindi nunu lolowa oko Jisasa yolopeya-ko. Yakamato bala minalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Wuane lalu, Jutasa bala Jisasa ateanga wamba kapoyale epoto, tisa, utulu wete lalu, bala nunu lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Balato Jisasa nunu leane tekeko, Jisasato bala lamawuato, amene, nimbato mangene mindi pulu epele oko kapoyale pipe lea. Wuane lea-kola, Jutasa towa atu epeaini akali tupamane epoto, Jisasa minuto, andi leai. ");
INSERT INTO ipi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Andi leai-kola, Jisasa towa atu ateaini akali utupanena mindimane balana kandepa luu mandeane oko kilau lo moto, pitisa akali kawane okona piape akali mindina alene yoko taka lo tepa yaa. ");
INSERT INTO ipi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wuane pea-kola, Jisasato bala laya loto, kandepa moto, yanda pulai akali tupa pitaka kandepa-mane teke omolo-peyai lea. Nimbana kandepa okone paliyane andanenga pale lolo-peke laa. ");
INSERT INTO ipi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nambato nambana ayiane oko lamawuato, enjole yame andane wetete alesa tupamane namba moyolo epeakale laa lauwa-yale, oko angi teke balato enjole utupanepi, dee waka minditupa wete tako puato, yakamato Jisasa moyolo pulupa lapia-yale oko nimbato nembo natelepe. ");
INSERT INTO ipi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gotena pii pepa pelene eya mindimane loto, akali utupa-mane mangene koo utupa nambanga pulupeyai layene eya tekeko, enjole kambua-mane namba moyolo epeaindo, Gotena pii okone anu puato, enene gulolo-peyape lea. ");
INSERT INTO ipi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wuane lalu, Jisasato akali kambua epeaini tupa lamawuato, ole dindi lo nambato lotu anda andane okona ende anda-pangosa pituto, wandakali tupa mana lamawua atauwa tekeko, okone angi, yakamato namba andi na-lapiai lea. Andipa nambato minditaka pake neya nembo toto, yakamato kandepa luupi, mulipi, utupane awua, namba andi lolo epeyaipe. ");
INSERT INTO ipi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yakamato okonetaka awua naepene, mee ipupiai-yale, yakamato katulo namba andi lapia-yale tekeko, wamba potopesa akali tupamane Gotena pii oko pepa peyoto, yakamato wuane pulupeyai leainipia. Utupanena pii enene guleakale nembo toto, yakamato mangene utupa pitaka piyapale lo Goteto ando kondeya lea. Akali epeaini tupamane Jisasa andi leai-kola, balana disaipolo tupa pitaka-mane bala awua tepa alu, palaka peai. ");
INSERT INTO ipi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Loo tupana mana andene akali tupapi, Juta yame ando atalaini akali tupapi, utupane pitisa akali kawane Kayapasa okona andaka epo amunguli peai-kola, Jisasa andi leaini akali tupamane bala atu aiyu anda okonena peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Utupane-mane Jisasa atu aiyu peai-kola, Pita bala amonga-yale ata iki lama watama peaipia. Akali utupane pitisa akali kawane okona anda ende pitane okona kolandaka leai-kola, akali utupane-mane Jisasanga anu pulu-peyaipe lo andokale nembo toto, Pita balapi kolandaka loto, piape wandakali minditupa towa atu peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pitisa akali kawane tupapi, Juta yame okona kanjole akali waka tupapi, utupane pitaka-mane Jisasa peyo ome lamakale nembo toto, owato wisanisa minditupa aiya peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Ayia peai-kola, owato wisanisa kambua epoto, owato pii loto, Jisasa kosimi leaini tekeko, kanjole akali utupane-mane bala peyo ome lolane tene mindi ando mia napeainipia. Matili owato wisanisa lapo akali epoto, bala kosimi loto, wamba Jisasato pii mindi loto, nambato katulo Gotena lotu anda andane ateya oko wamba ini lai lalu, ole tepo angu piape puato, pulu-peke lolo-peyawa leane leapilipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wuane leapi-kola, pitisa akali kawane oko bala ika loto, Jisasa tipa puato, akali okolapo-mane nimba kosimi loto, koo tene mindi nimbanga yata eyapi tekeko, nimbato utupanena pii okone yano peyoyale, pii mindikipi mindi laa napele okonde leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Balato wuane leane tekeko, Jisasato balana pii okone yano peyo, pii mindikipi mindi laa napea-kola, pitisa akali kawane okomane bala lamawuato, nimba Gotena Iwanane Mesaya oko atelepe lo nambato nimba tipa peyo-ko. Nimbana weno minuto, enene wete, Gote saka ateya okomane andeya loto, nimbato nanima langi leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wuane lea-kola, Jisasato bala lamawuato, nimbato wuane lele tekeko, matili yakamato andolai-kola, Akalina Iwanane oko bala Gote tai wetete okona kii tikasa-tole pitiyu, ati kenga tawe mole tupana tokonga epolanga yakamato andolopeyai lo nambato yakama langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wuane lea-kola, pitisa akali kawane okomane yataka wato, bala tanena tona peane oko minu liti loto, Juta yamena kanjole akali tupa lamawuato, balato Gote lamba leya-kola, andipa yakamato ale eyai okoni leaipia. Anu peakale wandakali waka mindimane wisanisa atoto, bala tane Mesaya oko ateyo lalane lo nanima langeakale maliyo atamakalepe. ");
INSERT INTO ipi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Balato Gote lamba leya-ko. Yakamato aki nembo teyaipe leaipia. Wuane lea-kola, Juta yamena akali kanjole tupamane balana pii okone yano peyoto, koo tene andane mindi balanga eya-ko. Bala omape-pene leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wuane lalu, utupane-mane Jisasana lee-inganga apesango soo lo peyalu, kii momanga-mane peyalu, kii apene-mane bala peyalu teke, peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Wuane piyu, utupane-mane bala lamawuato, nimbato Gotena piape pula lo Goteto nimba Mesaya oko atola lata yane yando, nimbato potopesa pii mindi loto, akali okomane namba peleya lo nimbato nanima langi leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita bala takita atoto, anda ende pitane okona anda-pangosa petea-kola, piape wanda mindi Pita peteanga epoto, nimbapi Galili disitiki tane Jisasa oko towa atu atalapele leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wanda okonemane wuane leane tekeko, wandakali ongane peteaini tupa pitakana wenonga atoto, Pitato balana pii okone tanga loto, nimbato aki nembo toto, wuane lelepe lo nambato nembo nateyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wuane lalu, bala ende pitane asia lomba okona mandaka poto atea-kola, piape wanda waka mindimane bala andoto, wandakali ongane ateaini tupa lamawuato, akali oko bala Nasatesa tano okona tane Jisasa oko towa atu atapia leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wuane lea-kola, Pitato balana pii okonepi tanga lapeke loto, balana weno minuto, nambato akali okone anda na-peyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aŋa matili yale akali ongane ateaini tupamane epoto, Pita lamawuato, enene, nanimato nimbana pii ale eyama-kola, nimbana pii okomane nimba Nasatesa tane Jisasana yame mindi atele lo pana alua leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Wuane leai-kola, Pitato weno minuto, utupane lamawuato, enene wete, nambato akali okone anda na-peyawane. Goteto andeya. Pii leyo oko owato pii mindi lewae yando, balato namba minu koyakale leaipia. Wuane lea-kola, okone angi teke eka pauli maipa mindimane pii leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pauli okonemane pii lea-kola, wamba Jisasato pii mindi loto, matili eka pauli maipa mindimane pii wene loyale pula-kola, ole tepoainga nimbato wandakali minditupana wenonga atoto, nambato Jisasa anda na-peyawane lolopele leane okone Pitato nembo tolo-peke loto, bala ende kamaka poto, ai lo yamataka leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yuu waa lea-kola, upa pitane wete pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane pitaka-mane Jisasa omeakale loto, pii lo puta peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pii okone lo puta piyu, utupane-mane bala eyaka-mane andi lo awua, Lomo gapomane akali andane Pailate oko ateanga atu aiyu poto, balanga mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Juta yame-mane Jisasa omeakale leai-kola, Jisasa ene peteane akali Jutasa okomane ale wato, mini kenda wete yaepia. Mini kenda wato, balato muni paiyasa tepo silipa-mane waa-pene wamba meane tupa mandu poto, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane ateainga peaipia. Poto, balato utupane lamawuato, wamba Jisasato koo mindikipi mindi napeane tekeko, nambato mana koo wete mindi minuto, bala ene pitiwa-kola, bala omolo-peya leaipia. Balato wuane leane tekeko, utupane-mane okone nanimana piape jia. Okone nimbana piape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wuane leai-kola, Jutasato muni silipa-mane waa-pene tupa lotu anda andane okona anda-pangosa peya andaka lalu, akali utupane tepa alu poto, bala tane nongo nalu, omeaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jutasa omea-kola, pitisa akali kawane tupamane muni silipa-mane waa-pene utupane moto, akali mindi peyo ome lamakale loto, nanimato muni utupa bala maima-ko leainipia. Nanimana loo okomane loto, muni okopene tupa lotu anda andane okona muni waka tupa towa mina mindiki lolaini leya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wuane lalu, akali utupane-mane wandakali opene omolai tupa mali pulane yuu mindi yakale nembo toto, pii mindi lo puta puato, sisopene yuu-mane waa piyane akali mindina yuu mindi muni utupane-mane kambeainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Akali mindi peyo ome lamakale loto, muni mayaini okonemane yuu oko kambeaini okonena, utupane-mane yuu okonena gene tundupa yuu leai-kola, andipapi wandakali-mane yuu okonena gene mindiki okone teke leyai. ");
INSERT INTO ipi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Wamba potopesa akali Jetemayato pii mindi loto, Isatale tane tupamane pii mindi lo puta puato, akali mindimane akali oko peyo ome leando, nanimato muni paiyasa tepo silipa-mane waa-pene maimakale leainipia. Wuane lalu, Akali Andane okomane yuu mindi kambape lo namba langeane pua, matili utupane-mane muni utupane moto, yuu-mane sisopene waa piyane akali okona yuu oko kambeaini layene eya. Pitisa akali kawane tupamane muni silipa-mane waa-pene utupane moto, yuu mindi kambeaini okonemane pii wamba potopesa akali Jetemayato leane okone enene gulaya yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasa bala Lomo gapomane akali andane Pailate okona wenonga atea-kola, Pailateto bala tipa puato, nimba Juta yamena kiŋi okope leaipia. Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimba tane wuane lele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wuane lea-kola, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane-mane bala kosimi loto, pii kambua leaini tekeko, balato utupanena pii utupane yano peyoyale, pii mindikipi mindi lapeke naleaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lapeke nalea-kola, Pailateto bala tipa puato, utupane-mane nimba kosimi loto, pii kambua leyai utupane nimbato ale naelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Balato wuane leane tekeko, Jisasato balana pii okone yano peyoyale, pii mindikipi mindi nalea-kola, Pailateto moko wete loto, nembo kambua teaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mali dindi lo Pasopa tomo nalaini oto oko epeya-angi, Juta yame-mane akali katapusa atalaini tupana mindiki makimi loto, Pailate nimbato akali oko tita lo tepa ape leyai-kola, balato akali okone tita lo tepa alaepia. ");
INSERT INTO ipi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","19","Balato pai pua akali mindi tita lo tepa olane oto okone epea-angi, wandakali tupa bala ateanga amunguli peai-kola, Pailate bala kote alewa pitiyane sia toko okona peteaipia. Petea-kola, balana wetene okomane pepa mindi peyo epe loto, kombeya-mane nambato akali tika-pene Jisasa oko andalo leaipia. Andipa nambato bala ondo wato, mini kenda wete eyo-ko. Nimbato kenda-pene mindi bala mai napene, tita lo tepa ape leaipia. Dee, Pailateto andea-kola, pitisa akali kawanepi, Juta yame ando atalaini akali tupapi, utupane-mane Jisasa towa apiangu puato, bala mee kosimi leai. Tene okone-lapona, Pailateto Jisasa tita lo tepa wakale nembo teaipia. Mana koo wete minalane akali Batapasa lene mindi andi latane palea-kola, wandakali tupamane bala tita lo tepa ape nalolo-peyai nembo toto, Pailateto wandakali amunguli pua ateaini tupa tipa puato, nambato Batapasa tita lo tepa wape. Pee, nambato Jisasa gene mindi Kataisa lalaini oko tita lo tepa wape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wuane lea-kola, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, utupane-mane wandakali amunguli pua ateaini utupanena nembo-tene mo lawa pimai-pulu, yakamato Pailate lamawuato, nimbato Batapasa tita lo tepa alu, Jisasa peyo ome laa lalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wuane leai-kola, gapomane akali andane Pailateto utupane tipa puato, nambato akali okolapona andoko tita lapia lakae lo nembo teyaipe leaipia. Wuane lea-kola, utupane-mane balana pii okone yano peyoto, Batapasa tita lo tepa aa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Wuane leai-kola, Pailateto utupane tipa puato, Batapasa tita lo tepa ewando, nambato akali Jisasa gene mindi Kataisa lalaini okonga anu pipia lakae lo nembo teyaipe leaipia. Wuane lea-kola, wandakali ateaini utupane pitaka-mane loto, nimbato bala ita malamanda okona peyo yuka aa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wuane leai-kola, Pailateto utupane tipa puato, anu peakale nambato bala ita malamanda okona peyo yuka wape. Balato mana koo wete andoko wato minapiape leaipia. Balato wuane leane tekeko, utupane-mane pii taimane wete loto, bala ita malamanda okona peyo yuka aa laka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wuane laka puato, wandakali utupa-mane Pailatena pii ale naene, bala towa yanda puyale peyai-kola, balato disa ipa piti-pata mindi moto, wandakali utupanena wenonga atoto, bala tanena kini wasa-wasa pelea. Wasa-wasa peyoto, balato wandakali utupane lamawuato, akali oko omola-kola, koo tene oko nambanga nayolopeya. Yakamanga yolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wuane lea-kola, wandakali utupane pitaka-mane loto, andipa koo tene okone nanimanga yalu, matili nanimana andopane mandiyene tupangapi yalu, peakale teke leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wuane leai-kola, Pailateto Batapasa tita lo tepa amaiyu, ami yanda yene minditupa lamawuato, yakamato Jisasa kunju-mane peyalu, ita malamanda okona peyo yuka alapa loto, bala utupanenga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Okone angi, gapomane akali kawane Pailate okona ami yanda yene minditupa-mane Jisasa atu aiyu gapomane anda mindina kolandaka loto, utupanena ami yanda yene yangone tupa ipulupa loto, pitaka Jisasana wenonga amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Amunguli piyu, utupane-mane balana tona peane tupa yoko moto, tona kala pepolo kiŋi tupamane piyaini okonepene mindi balanga piya mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Piya maiyu, utupane-mane eyaka ani atene mindi mo umange pua kiŋi tupamane piyaini tangi gulene mindi waa puato, balana kawanenga tangi gulo aiya mayainipia. Ayia maiyu, kelewa kanda mindi balana kii tikasa aiyakale lo maiyu, utupane-mane aiki leka wato, bala lamba loto, Juta yamena kiŋi nimba wayu epeleya. Nimba kuai lo atape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wuane loto, utupane-mane bala apesango soo lo peyoto, kelewa kanda balato aiyane okone moto, balana kawanenga peleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Utupane-mane bala lamba lo koyo piyu, tona balanga piya mayaini okone yoko moto, balana tona piyane oko mo piya maiyu, bala ita malamanda okona peyo yuka oyale atu aiyu peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ami yanda yene tupamane Jisasa atu aiyu Jutusaleme tepa alu poto, Saitini tano okona tane akali Saimone lene mindi andoto, balato Jisasana ita malamanda oko aiyakale lo mo aiya mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aiya mayai-kola, aiyu utupane towa yuu Golokota lene mindina peakaiyu leai. Gene Golokota okonena tene oko kawane kulini wangiane. ");
INSERT INTO ipi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Golokota yuu okonena peakaiyu lalu, utupane-mane matasini kaa-pene wete mindi waene minditupa towa mina mindiki loto, Jisasa neakale mayaini tekeko, balato okone no makande piyu, naa napene, konda ya. ");
INSERT INTO ipi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ami yanda yene tupamane Jisasa ita malamanda okona peyo yuka alu, laki loto, wini leaini akali tupa mindiki-mindiki lo balana tona mindi miaka peai. ");
INSERT INTO ipi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","37","Wamba Lomo gapomane okomane Jisasa kosimi loto, bala tane Juta yamena kiŋi oko ateyo leya leainipia. Wuane leaini oko nembo tolo-peke loto, ami yanda yene tupamane akali Jisasa oko bala Juta yamena kiŋi oko ateya lo pepa peyoto, pepa okone Jisasana ita malamanda okona kawanenga ate lalu, Jisasa andapeyo peteai. ");
INSERT INTO ipi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Okone angi, ami yanda yene waka minditupa-mane pake nene akali lapo atu aiyu epoto, akali okone-lapona mindi Jisasana kii tikasa-tole peyo yuka alu, mindoko balana kii koyasa-tole yuka yai. ");
INSERT INTO ipi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Jisasa peyo yuka atane ateane ongane mandaka epo peaini wandakali tupamane yakamana kawane taimane ema puato, bala lamba loto, nimbato lotu anda andane oko keao loto, ole tepo angu piape puato, pulu-peke lolo-peyawa lalene piako. Nimba Gotena iwanane yando, nimba tane taputi pua, ita malamanda oko tepa alu, yuunga ipu leai. ");
INSERT INTO ipi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Wuane pua teke, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, Juta yame ando atalaini akali tupapi, utupane-mane Jisasa lamba loto, balato wandakali waka tupa moyalane tekeko, bala tane katulo moya napeya okonde leai. Epapu bala ita malanda oko tepa alu, yuunga epeando, nanimato bala Isatale tanena kiŋi oko ateya lo bilipi lolo-peyama. ");
INSERT INTO ipi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Balato Gote bilipi loto, bala tane Gotena iwanane ateyo lalane-ko. Goteto bala epelewa yamapane yo ateando, andipa bala molo-peke lape-pene leai. ");
INSERT INTO ipi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Utupane-mane wuane loto, Jisasa lamba leai-kola, ongane mandaka ita malamanda laponga peyo yuka atane ateapili pake nene akali okolapo-mane bala lamba leapi teke. ");
INSERT INTO ipi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","50","Otonga oto kulini okona yuu undupi lamangua atane angu atama pea-kola, ole-lene siti kilokopi mindi lea-angi, Jisasato pii taimane wete loto, Eli, Eli lama sapa-katani lea. Pii okone nanimato mopeke loto, nambana Gote, nambana Gote, anu peakale nimbato namba tepa elepe lea. Wuane lea-kola, wandakali ongane mandaka ateaini utupanena minditupa-mane ale wato, akali okomane potopesa akali Ilainja ee leya leai. Wandakali utupanena mindimane taimane poto, sapanjia mindi moto, waene kaa-pene pinika lene okona tanda pua pete loto, ita kai mindina tutuku puato, Jisasa bala duu lo neakale maulu peane tekeko, wandakali waka tupamane bala lamawuato, Ilainjato bala moyolo epeyape lo andamakale. Mali yo ata leai. Okone angi, Jisasato lapone taimane wete kalae lalu, omoto, balana tandini oko peakale lo tepa ya wete, yuu tii pulu-peke lea. ");
INSERT INTO ipi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Okone angi teke, lotu anda andane okona lumu oko tombo peyoto, lapa-lapa andane yuka atane ateane oko kawanenga ato tewa, atutu kao lo lapo peaipia. Dee, yuu titiyawi andane wete mindi lea-kola, ana andane tupa longo paiya pea. ");
INSERT INTO ipi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yuu titiyawi andane okonemane wandakali mali pitane asini kambua lumbu tepa ya-kola, Goteto balana wandakali wamba omeaini tupana kambua malinga ika laya yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ika loto, utupane-mane yakamana mali tupa tepa alu peainipia. Matili Jisasa malinga ika lea-angi, wandakali utupane yakama Gotena tano Jutusaleme okona peai-kola, wandakali kambua-mane utupane andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mindimane Jisasana umbaini oko pake mo awua polaini lo ando ateaini ami yanda yene tupapi, utupanena akali kawane okopi, utupane-mane yuu titiyawi leane okopi, mangene waka peane tupapi, utupane andeaini-pia. Andoto, yakama yuku wete wato, enene wete, akali oko Gotena Iwanane ya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Wamba wanda kambua-mane Jisasa moya-makale nembo toto, Galili disitiki okona atalu, bala towa atu epeai. Wanda utupanena mindi Makatala tano okona tane Matiya okopi, mindi Jemesa, Josepe-la, okone-lapona angini Matiya okopi, mindi Sepiti iwanane okolapona angini okopi, wanda tepo utupane yakama wanda waka tupa towa atu amonga-yale atoto, anu peyaipe lo andatawa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Atimatiya tano okona tane akali amango Josepe lene oko balapi Jisasa bilipi lo atalaepia. Ole-lene akali okone bala Pailate ateanga poto, Jisasana umbaini oko namba gulape lo tee lea-kola, Pailateto ami yanda yene tupa lamawuato, Jisasana umbaini oko Josepenga maiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wuane lea-kola, Josepeto Jisasana umbaini oko moto, lapa-lapa epene wete kalato naene mindimane yake pua ombo yaepia. ");
INSERT INTO ipi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wamba Josepeto akali minditupa lamawuato, yakamato namba mali pulane panda mindi mandeke pingiyapape lea-kola, utupane-mane bala mali pulane panda mindi ana ati mindina kua pua mandeke pima-yainipia. Josepeto Jisasana umbaini oko awua poto, bala tanena mali pulane panda wenene okonena yata alu, ana pata andane mindi minu pendeke lo awua epoto, mali okonena asini tuma piyu, bala peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Josepeto wuane pea-angi, Makatala tano okona tane Matiya okola, Matiya mindi okola, okonelapo liyamba Jisasana mali okonena mandaka peteapele-pia. ");
INSERT INTO ipi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sambasa pitimakale lo minditaka makande pulane oto oko koyo pea-kola, anate-lene pitisa akali kawane tupapi, Patasai yamepi, utupane Pailate peteanga epo amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Amunguli piyu, utupane-mane Pailate lamawuato, akali andane, wamba wandakali minakasa alane akali Jisasa oko saka atea-angi, balato pii mindi loto, ole tepo pola-kola, namba malinga ika lolo-peyawa leane oko nanimato nembo tolo-peke lalama leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Andipa balana disaipolo tupamane bala pake mo too pipulu, wandakali tupa lamawuato, bala malinga ika lapia leaindo, wandakali minakasa olai okonemane wamba balato wandakali tupa minakasa yane oko sia minulu-peyako. Balana disaipolo tupamane bala pake molaini. Akali minditupa-mane balana mali oko ole tepo tupana wayumane andapeyo angu atapowa ateakale lape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wuane leai-kola, Pailateto utupane lamawuato, balana mali asia lomba oko lumbalu, balana umbaini pake molaini. Yakamato mangene mindi piyu, ami yanda yene tupamane balana mali okone andapeyo ateakale lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wuane lea-kola, utupane-mane poto, wakaiya minditupa mali okonena asia lombanga pata mangua alu, ami yanda yene tupamane mali okone andapeyo ateakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambasa oto oko koyo pea-kola, Sande angi upa pitane nai epoyale peai-angi, Makatala tano okona tane Matiya okola, Matiya mindoko-la, okonelapo liyamba Jisasana mali oko andoyale asini peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Asini peapi wete, yuu titiyawi andane mindi lea-kola, Gotena enjole mindi ati kenga atala epoto, Jisasana mali asia lomba tuma peane ana andane wete oko minu pendeke lo mo aiyangi loto, ana okonena tokonga peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ati tapale piyane pua, balana lee-inga tii wetete pikoyo pea-kola, balana tona peane tupa ake wete peaipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jisasana umbaini pake molaini ando ateaini ami yanda yene tupamane enjole okone andoto, yuku wete wato, putu-putu peyoto, omene gulo yainipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ami yanda yene utupane-mane wuane peaini tekeko, enjole okonemane wanda okolapo lamawuato, liyamba yuku olapele leaipia. Ita malamanda okona peyo yuka apiai akali Jisasa okone liyambato aiya pulu epeyapi lo nambato andeyo. ");
INSERT INTO ipi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wamba balato malinga ika lolo-peyawa leane pua, bala malinga ika lalu, pala. Bala onga yaa napeya-ko. Liyambato bala yala panda oko andolo ipulupa. ");
INSERT INTO ipi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Andalu, liyambato wamba kapoyale poto, balana disaipolo tupa lamawuato, Jisasa bala malinga ika lalu, wamba ingane Galili disitiki okona pala. Yakamato yuu okonena poto, bala andolo-peyaiko. Liyambato pii okone balana disaipolo tupa lamai-yapape lo nambato liyamba langeyo okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wuane lea-kola, wanda okonelapo liyamba yuku yapele tekeko, pii okone ale wato, liyamba epele wete yapelepia. Epele wete wato, liyamba mali okone wamba kapoyale tepa alu taimane poto, balana disaipolo tupa lamaulu peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lamaulu peapi-kola, Jisasato okonelapo asininga malamanda wato, upa pitane wete leaipia. Wuane lea-kola, wanda okonelapo liyambato bala mandaka gulo poto, aiki leka wato, balana kene minata wato, bala lo lotu leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bala lo lotu leapi-kola, balato okonelapo lamawuato, liyamba yuku naene, nambana disaipolo tupa atolainga poto, utupane Galili disitiki okona epeakale lamai-yapape. Namba yuu okonena poto atolowa-kola, matili utupane epoto, namba andolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wanda okonelapo asini peapi-kola, Jisasana mali oko andatawa ateaini ami yanda yene tupana minditupa-mane Jutusaleme tano okona poto, mangene peane utupane pitaka pitisa akali kawane tupa lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lamai-yaikola, pitisa akali kawane tupa yakamato Juta yame ando atalaini akali tupa towa amunguli puato, pii mindi lo puta piyu, muni kambua minditupa yanda yene utupane mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Maiyu, utupane-mane yanda yene tupa lamawuato, yakamato loto, utulu nanima limu paliyama-kola, Jisasana disaipolo tupa epoto, balana umbaini oko mo awua palai yala lalapape. ");
INSERT INTO ipi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yakamato wuane lolai-kola, gapomane akali kawane okomane pii okone ale yando, nanimato bala towa pii loloma-kola, kenda-pene mindi yakamanga naepolo-peya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wuane leai-kola, ami yanda yene utupane-mane muni utupane mialu, Juta yamena akali kawane tupamane utupane lamai-yaini pua, owato pii mindi loto, utulu nanima limu paliyama-kola, Jisasana disaipolo tupa epoto, balana umbaini oko mo awua palai yala leainipia. Wuane leai-kola, Juta yame tupamane pii okone lo tawe yaini oko lo tawe yama teke ipulu, andipapi wuane teke lalaini. ");
INSERT INTO ipi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wamba Jisasato balana disaipolo masia tupa lamawuato, yakama Galili disitiki okona yuu wangiane mindina pulupape leane wangiane okonena peai. ");
INSERT INTO ipi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pulu, utupane-mane Jisasa andoto, bala lo lotu leaini tekeko, minditupa-mane mini lapo paleai. ");
INSERT INTO ipi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mini lapo paleai-kola, Jisasato utupane ateaini mandaka ongane epoto, pii mindi utupane lamawuato, yuu ati-la, okolapona minditaka eya tupa pitaka ando atolane tai-lene tupa pitaka Goteto namba gipia lea. ");
INSERT INTO ipi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tene okonena, yakama poto, wandakali palu pula tupa pitaka nambana disaipolo tupa ateakale lo piape pua atalapape. Piape okone pua atoto, Aiyane okopi, Ini okopi, Oli Sipitisa okopi, utupanena gene oko loto, wandakali ipa peya-maiyapape. ");
INSERT INTO ipi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Peya-maiyu, pii manapi wato minu atalapape lo nambato yakama langewa tupa pitaka wandakali utupane-mane wato minu ateakale lo yakamato mana lamai-yapape. Yakamato wuane pua atolai-kola, namba yakama towa atu atama pulu, yuu koyo pula oto oko ando molopeyama nemboto atalapape. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gotena pii layene epene oko bala iwanane Jisasa Kataisa andayo layene eya. Nambato pii oko bulupane tewa yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","4","Wamba Goteto balana iwanane Jisasa Kataisanga pii mindi lamaiya-kola, potopesa akali Aisayato pii okone pepa peyoto, wua leaipia: Ale ape. Nambato nambana wai lo awua epeakale lolane akali oko wamba ingane ini epeakale lolowa-kola, balato nimbana asini oko makande pua yata olopeya. Bala wandakali napalene yuu mindina atoto, pii taimane loto, yakamato Akali Andane oko epolane asini mindi mandeke pimawuato, bala epolane asini aŋako tupa mo tika piyapape lolopeya layene eya. Wamba Aisayato pii okone pepa peleane pua teke, ipa peya-maiyane akali Jone oko bala wandakali napalene yuu okona epo atoto, Gotena pii oko wandakali tupa lamaiki peaipia. Lamaiki puato, Goteto yakamana koo piyaini tupa apia-geakalenga, yakamato yamapane peke loto, ipa mialapa lo lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pii okone lamaiki pea-kola, Jutusaleme tano okona tanepi, Jutiya disitiki yuu tupa pitakana tanepi, utupane pitaka bala ateanga poto, yakamana koo tupa lapana yai-kola, Joneto ipa Jotane okona atoto, utupane ipa peya-maiyaepia. ");
INSERT INTO ipi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Balato yia kamele itini-mane waa-pene tona tupa piyu, bulumako umbaini-mane waa-pene matipu mindi pua atalaepia. One neme tupamane palawa dini tupana ipane moto, tomo gene ani lene mindi waa piyane oko moto, Joneto palai tupa towa naka pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Balato Gotena pii oko wandakali tupa lamawuato, akali matili epolopeya okonena tai-lene okomane nambana tai-lene oko sia minulu-peya laka peaipia. Nambato aiki leka wato, sukee balana pula okona eyaka tita lolane namba akali epene mindi jia. ");
INSERT INTO ipi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nambato ipa-mane yakama ipa peya-geyo tekeko, balato Oli Sipitisa okomane yakama ipa peya-gulupeya. Joneto wuane lo pii lamaiki pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Alu mindi Jisasa bala Galili disitiki tano Nasatesa oko tepa alu epea-kola, Joneto ipa Jotane okona atoto, bala ipa peya-maiyaepia. ");
INSERT INTO ipi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Okone angi, Goteto ati iyu oko yapu lo toko laya ya-kola, Jisasato ipa oko tepa alu, andea-kola, Oli Sipitisa oko eka uya gulo balanga epo tepa yanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Okone angi teke, pii mindi ati kenga atala epoto, Jisasa ando, nimba nambana iwanane yamapane yalawane oko. Nambato nimbana mana tupa andoto, epele wetete eyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Okone angi teke, Oli Sipitisa okomane Jisasa bala wandakali napalene yuu mindisa atu aiyu peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisasa bala wandakali napalene yuu okonena poto, ole paiyasa tukumindi piango anatope tupapi, yia kapua tupapi, utupane towa atu ateaipia. Bala yuu okonena atea wete, Sataneto bala minu makande pea-kola, matili enjole tupamane bala moyaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Matili Jone andi latane atea-kola, Jisasa bala Galili disitiki okona poto, Gotena pii layene epene oko lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Pii lamaiki pua atoto, oto Goteto yata yane oko ipupia-kola, balato pitaka taka ando atolane oto oko wamba mandaka epo eya-ko. Yakamato yamapane peke loto, Gotena pii layene epene oko bilipi lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saimone, balana amene Endutu-la, okonelapo pisa moto, bisanisa piape pua ateapele-pia. Alu mindi Jisasa bala Galili ipa angini okona matenenga epo poto andea-kola, akali okonelapo-mane pisa mialapele umbene nuu andane wete mindi ipa angini okona aindaka leapinga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Andoto, balato akali okonelapo lamawuato, liyambato wandakali mialapale, nambato mana langukalenga, liyamba namba watama ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wuane lea-kola, okone angi teke akali okonelapo-mane pisa mialapele umbene nuu tupa yakale tepa alu, bala watama peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Watama peapi-kola, Jisasa bala amonga-yale poto andea wete, Sepiti iwanane Jemesa, bala amene Jone-la, okonelapo sipi mindina pitiyu, pisa mialapele umbene nuu tupa tambu lo peapinga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Andoto, ipulupa lea-kola, okonelapo liyamba ayiane Sepiti oko balana piape akali tupa towa sipi okona peteakale tepa alu, Jisasa watama peapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Matili Jisasa balana disaipolo tupa towa Kapaneame tano okona peainipia. Sambasa oko epea-angi, bala Juta yamena lotu anda okona kolandaka loto, pii manapi lamawua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Loo tupana mana andene akali tupamane pii mana lamai-yaini pua, balato mana lamai napeaipia. Jia. Wamba Goteto bala ando, nimbato nambana pii mana lamawua atape lea-kola, balato mana kuai lo lamawua ateaipia. Tene okonena, wandakali tupamane pii balato leane tupa ale wato, moko wete loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Okone angi, sipitisa koo atene akali mindi yakamana lotu anda okonena peteane okomane pii taimane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Pii okone loto, balato Nasatesa tane Jisasa, nambato nimba andeyawane leaipia. Nimba Gotena akali epene tika-pene wetete atele. Nimbato nanimanga anu pulu epelepe. Nimbato nanima minu koyolo epelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wuane lea-kola, Jisasato sipitisa koo okone laiya loto, nimbato pii nalene, kondalu, akali oko tepa alu puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wuane lea-kola, sipitisa koo okonemane akali okone taimane mo malawai loto, kalae andane lalu, bala tepa alu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pea-kola, wandakali tupa pitaka-mane moko wete loto, yakama teke-teke pii lalawa puato, anu puato, Jisasato wuane piyape leainipia. Oko mana wenene waka mindi ya. Sipitisa koo tupa bosa lo ando atolane tai-lene oko balanga eya-kola, balato sipitisa koo tupa pulupa leya-kola, utupane-mane balana pii okone wato minalaini ya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wuane loto, wandakali utupane-mane Galili disitiki yuu tupa pitakana poto, pii okone lo tawe yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Utupane yakama Juta yamena lotu anda oko tepa alu, takita peai-angi, Jisasa bala Jemesa, Jone-la, okonelapo towa atu Saimone, Endutu-la, okone-lapona andaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Peai-kola, Saimonena wanda imane oko siki omoto, umbuaini toto andane pea-kola, tokonga palu ya-kola, wandakali tupamane Jisasa kapoyale lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lamai-yaikola, Jisasa poto, wanda okonena kininga minuto, mina ika laya ya-kola, balana umbuaini toto andane wete peane oko atu yaepia. Atu ya-kola, wanda okonemane akali utupanena tomo mandeke pima-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Nai andaka pea-kola, Kapaneame tano okona tane wandakali tupa pitaka-mane wandakali siki pelene tupapi, sipitisa koo atene tupapi, utupane pitaka atu aiyu epoto, anda Jisasa peteane okona asia lombanga epo amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Amunguli peai-kola, Jisasato siki waka-waka pelene wandakali tupa mo atu yaepia. Balato sipitisa koo atene wandakali kambua tupana sipitisa koo ateaini tupa peyo watea-kola, sipitisa koo utupane-mane bala Gotena iwanane ateya lo andeaini-pia Andeai-kola, balato utupane lamawuato, namba Gotena iwanane ateya lo yakamato wandakali tupa lamaulaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Waa loyale pea-kola, Jisasa bala ika lalu, kamaka poto, wandakali napalene yuu mindina pote lo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Matili Saimonepi, akali bala towa ateaini tupapi, utupane-mane Jisasa aiya pima poto, andeaini-pia. Andoto, wandakali tupa pitaka-mane nimba aiya peyai lo lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lamai-yaikola, balato utupane lamawuato, namba tano waka mandaka eya tupana poto, Gotena pii lamauwakale nembo toto ipuwa-ko. Nanimato Kapaneame tano oko tepa alu, maa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wuane lalu, balato Galili disitiki okona yuu tupa pitakana poto, Juta yamena lotu anda tupana kolandaka loto, Gotena pii oko wandakali tupa lamaiki puato, sipitisa koo tupa peyo wataka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Akali tapa mindimane Jisasa ateanga epoto, aiki leka wato, nimbato namba mo atu yokale nembo teendo, nimbato katulo wuane pulupele leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wuane lea-kola, Jisasato akali okone ondo wete wato, wuane pukale loto, balana kini oko balanga yata wato, nimba atu ya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wuane lea-kola, okone angi teke akali okonena tapa peane oko atu ya-kola, Gotena wenonga bala kalato ata napene guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Wuane pea-kola, Jisasato pii keato mindi bala lamawuato, nimba Gotena pitisa piape piyane akali oko ateyanga kapoyale poto, nimbana umbaini oko balanga andawa lape leaipia. Andawa lalu, Goteto nimbana tapa peane oko mo atu yapia lo wandakali tupamane andeakale nembo toto, Mosesato opa mindi maiyapape leane pua teke maipe. Nimbato wuane pipe-pene tekeko, nambato nimba mo atu eyo oko wandakali mindikipi mindi lamaulene andape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisasato wuane leane tekeko, akali okonemane poto, Jisasato bala mo atu yane oko lo tawe yaepia. Tene okonena, Jisasa bala tano mindina panakame pupe-pene guu nalea-kola, bala wandakali napalene yuu tupana atea-kola, yuu pitakana tane wandakali tupa bala ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ole minditupa pea-kola, Jisasa bala Kapaneame tano okona peke leaipia. Peke lea-kola, wandakali-mane Jisasa bala andaka ateya lene oko ale yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ale wato, wandakali kambua wete epo amunguli peai-kola, anda okone tumbi wete leaipia. Takita atoto, anda asia lombanga mandaka gulo atolane panda mindi mee nayaepia. Wandakali utupane pitaka amunguli peai-kola, Jisasato Gotena pii layene epene oko utupanenga lamawua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pii lamawua atea-kola, akali tukumindi-mane akali kusuku mindi awua epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wandakali kambua wete ateai-kola, akali utupane-mane bala Jisasa ateanga awua epolane asia mindi nayaepia. Naya wete, akali utupane-mane akali kusuku okone awua poto, anda tokonga peakaiyu loto, anda yame peyatane ateane minditupa lai lo yata yainipia. Wuane piyu, takea toko okona eyaka tukumindi andi lo tepa wato, akali okone takea tokonga pali-pata Jisasa ateanga tengamane tepa yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisasato andea-kola, akali utupane-mane bala lo bilipi loto, akali okone awua epeai lo andoto, akali kusuku okone lamawuato, iwana, nambato nimbana koo pilini tupa apia-geyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wuane lea-kola, loo tupana mana andene akali ongane peteaini tupamane wua lo nembo teainipia: ");
INSERT INTO ipi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Anu peakale Jisasato wuane leyape. Akali-mane katulo wandakali yangone tupana koo tupa apia-mai na-piyaini. Jia. Goteto angu katulo wuane piyane-ko. Nambato nimbana koo tupa apia-geyo loto, Jisasato Gote lamba leya. Loo tupana mana andene akali tupamane wuane nembo teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wuane nembo teyai lo andoto, Jisasato utupane tipa puato, anu peakale yakamato wuane nembo teyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nambato akali kusuku oko lamawuato, nimbana koo pilini tupa apia-geyo leyo oko piape pitete-pene mindi jia. Nambato bala lamawuato, nimba ika lalu, nimbana takea toko oko mo aiyu puu loto, balana siki oko mo atu yewando, piape okone pitete-pene. ");
INSERT INTO ipi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Wuane tekeko, Goteto yuunga wandakalina koo piyaini tupa apia-maulane tai-lene oko Akalina Iwanane okonga mayane oko yakamato andalapale nembo teyo leaipia. Wuane lalu, balato akali kusuku oko lamawuato, nimba ika lalu, nimbana takea toko oko mo awua andaka puu leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wuane lea-kola, wandakali peteaini tupa pitakana wenonga akali kusuku oko kapoyale ika lalu, balana takea toko oko mo awua pea-kola, wandakali utupane pitaka-mane moko wete leainipia. Moko loto, utupane-mane Gotena gene oko laiyu loto, nanimato mana okonepene mindi wamba anda napemane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisasa bala ipa angini okona matenenga lapone pea-kola, wandakali kambua bala ateanga epeainipia. Epeai-kola, balato utupane mana lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mana lamaiyu, matili Jisasa poto andea-kola, Alipusa iwanane Lipai oko takisa muni mialaini anda okona peteanga andeaipia. Andoto, nimba namba watama ipu lea-kola, Lipai ika lalu, bala watama peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Takisa mialaini akalipi, koo piyaini wandakali waka tupapi, utupanena kambua-mane Jisasa towa atu epoko pua atalainipia. Alu mindi wandakali utupanepi, Jisasana disaipolo tupapi, utupane Jisasa towa Lipai andaka tomo no peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tomo no peteai-kola, Patasai tupapi, loo tupana mana andene akali tupapi, utupane-mane andoto, Jisasana disaipolo tupa tipa puato, anu peakale Jisasa bala takisa muni mialaini akalipi, koo piyaini wandakali waka tupapi, utupane towa atu tomo no peteyaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, dokosa-mane wandakali siki napelene tupa mo atu yolane tene mindi ata napeya. Jia. Dokosa-mane wandakali siki pelene tupa mo atu yalane. Wuane pua teke, namba epewane oko wandakali epene tika-pene tupa ee lo molo na-epewane. Jia. Koo piyaini wandakali tupa ee lo molo namba epewane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Alu mindi Jonena disaipolo tupapi, Patasai tupapi, utupane-mane pote kambua loyale, ole ukupini mindilapo tomo nanene ateainipia. Tomo nanene ateai-kola, wandakali minditupa epoto, Jisasa tipa puato, Jonena disaipolo tupapi, Patasai tupana disaipolo tupapi, utupane-mane pote kambua loyale, ole ukupini mindilapo tomo nanene atalaini-ko. Anu peakale nimbana disaipolo tupamane wuane na-piyainipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wuane leai-kola, Jisasato utupane tipa puato, akali mindimane wanda mindi kee loto, balana yangone tupa towa atu atolai-kola, yangone utupane-mane pote kambua lamakale nembo toto, katulo ole ukupini mindilapo tomo nanene atolo-peyaipe. Jia. Akali okone balana yangone utupane towa atu atolai-angi, utupane-mane katulo wuane napulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wuane tekeko, matili akali minditupa-mane wanda kee lolane akali oko bala andi lo awua polai-kola, ole okone angi balana amene tupamane pote kambua loyale, ole ukupini mindilapo tomo nanene atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wandakali mindimane lapa-lapa palai-lene wenene mindi moto, tona wambane asia titi yene mindina ataenge lo tambu leando, balato tona okone wasa-wasa peyola-angi, lapa-lapa palai-lene wenene okomane kingi tupi loto, tona wambane okone lapone lete laya ola-kola, asia titi wamba yolane okone andane gulolo-peya. Tene okonena, wandakali mindikipi mindimane wuane na-piyaini. Jia. ");
INSERT INTO ipi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dee, wandakali mindimane ipa waene wenene tupa ipa pene wambane meme umbaini-mane waa-pene tupana pete leando, ipa waene wenene okonena popone okomane ipa pene wambane tupa tula laya ola-kola, ipa waene oko alu pulupeya. Tene okonena, wandakali mindikipi mindimane wuane na-piyaini. Jia. Wandakali-mane ipa waene wenene tupa ipa pene wenene tupana pete lalaini. ");
INSERT INTO ipi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sambasa mindina, Jisasa bala witi ee tupana tombenenga asini epo pea-kola, balana disaipolo tupamane bala watama epoto, witi dini minditupa yo miaka pima peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yo miaka pima peai-kola, Patasai tupamane Jisasa lamawuato, Gotena loo okomane loto, Sambasa angi wandakali-mane piape napipe-pene leya-ko. Anu peakale nimbana disaipolo tupamane loo okone ango wato, witi dini tupa yo miaka pima peyaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gotena loo okomane loto, Gote wenonga yata alaini betesa tupa pitisa akali tupamane angu nape-pene layene eya leaipia. Wandakali waka mindikipi mindimane betesa utupane mo naa na-piyapape layene eya tekeko, wamba Apayata bala Gotena pitisa akali kawane atea-angi, Dapitipi, akali bala towa atu ateaini tupapi, utupane-mane ulia nono yainipia. Nono wato, Dapitito Gotena lotu anda okona kolandaka loto, betesa utupane nalu, bala towa atu ateaini akali tupapi neakale maya lo pepa pelene eya. Yakamato pii okone alu mindikipi mindi wamba dii lo anda napeaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wuane lalu, Jisasato utupane lamawuato, Akalina Iwanane nambato Sambasa oko moyokale nembo toto, wandakali waa napewa. Jia. Nambato wandakali tupa moyokale nembo toto, Sambasa oko yata ewa. ");
INSERT INTO ipi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tene okonena, namba tane Sambasa oko bosa lo ando atalawane teke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Alu mindi Jisasa bala Juta yamena lotu anda mindina kolandaka lea-kola, akali kii koo mindi peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Petea-kola, akali minditupa-mane Jisasa kosimi lamakale nembo toto, Sambasa angi balato akali okone mo atu eyape lo andatawa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Andatawa peteai-kola, Jisasato akali kii koo oko lamawuato, nimba wandakali peteyai utupana wenonga ika lo ata leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ika lo atea-kola, Jisasato wandakali tupa tipa puato, Gotena loo okomane aki leyape leaipia. Sambasa angi mana epene tupa minalapape leyape. Pee, Sambasa angi, mana koo tupa minalapape leyape. Sambasa angi yakamato wandakali tupa molo-peke lalapape leyape. Pee, Sambasa angi wandakali tupa peyo ome lalapape leyape leaipia. Jisasato wuane leane tekeko, wandakali utupane-mane balana pii utupane yano napeleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Utupane-mane akali okone ondo naene atoto, balana pii okone yano napeleai-kola, Jisasa bala mini kenda yaepia. Balato utupane towa yataka wato, lee-mane anda peyoto, akali kii koo okone lamawuato, nimbana kini yo laa leaipia. Akali okomane balana kini yo lea-kola, atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sambasa angi Jisasato akali okonena kini mo atu ya-kola, Patasai tupamane takita poto, okone angi teke kiŋi Etotena yame akali tupa towa pii lalawa puato, nanimato anu puato, bala peyo ome lamakalepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisasa balana disaipolo tupa towa yuu okone tepa alu, ipa angini okona matenenga peai-kola, Galili disitiki okona tane wandakali kambua longo waka-mane bala watama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Okone angi, wandakali minditupa-mane pii lo tawe yoto, Jisasato siki pelene wandakali kambua mo atu yalane leai-kola, Jutiya tanepi, Jutusaleme tanepi, Itumia tanepi, ipa Jotane amo-yangi tanepi, Taya tanepi, Saitone tanepi, yuu utupane pitakana tane wandakali kambua tupamane ale wato, bala ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Wamba Jisasato wandakali kambua mo atu yane oko nembo toto, wandakali siki pelene tupamane bala wata oyale ato pitu-pitu peainipia. Wandakali kambua-mane mandaka gulo epeai-kola, balato balana disaipolo tupa lamawuato, wandakali utupane-mane namba ango oyale peyai-ko. Namba sipi mindina peakaiyu loto atokalenga, sipi mindi namba ateyonga mandaka epoto, mali yo yakalenga, epeakale lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sipitisa koo tupamane Jisasa andoto, tombawua lo yoto, pii taimane loto, nimba Gote iwanane oko atele laka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wuane laka peai-kola, Jisasato utupane laiya loto, pii keato mindi utupane lamawuato, namba Gotena Iwanane ateya lo yakamato lapana olaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Akali minditupa balana disaipolo ateakale nembo toto, Jisasa bala yuu wangiane mindina iyu poto, utupane ipulupa lea-kola, utupane-mane bala ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Alesa akali tupa bala towa atu atoto, sipitisa koo tupa peyo watolane tai-lene oko moto, Gotena pii layene oko wandakali tupa lamaulu peakale lokale nembo toto, balato utupane yapa lo meaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Alesa akali utupane yapa lo mialu, balato akali Saimone lene oko gene mindi Pita leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Balato Sepiti iwanane Jemesa, bala amene Jone-la, okone-lapona gene mindi Bonengesa leaipia. Gene okonena tene oko, ati kulu lalane pua, akali okonelapo-mane kapoyale yataka alapele. ");
INSERT INTO ipi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Endutupi, Pilipipi, Batolo-miyupi, Matiyupi, Tomasapi, Tatiyusapi, Alipusa iwanane Jemesapi, Lomo gapomane oko towa yanda piyaini Selote yame akali Saimone okopi, Jutasa gene mindi Isaka-tiyote lene matili Jisasa ene peteane okopi, akali alesa utupane pitaka Jisasato balana disaipolo ateakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisasa bala anda mindina pea-kola, pai pua teke, wandakali kambua epo amunguli peai-kola, balapi, balana disaipolo tupapi, utupane-mane tomo nolane oto mindi nayaepia. ");
INSERT INTO ipi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bala tomo nanene, piape angu pua ateya-kola, balana yame tupamane ale wato, bala keewa atalua loto, bala lamolo peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Okone angi, loo tupana mana andene akali minditupa Jutusaleme atala epoto, pii mindi loto, sipitisa koo yame tupa ando atalane akali kawane Belesa-pulu bala Jisasanga ateya. Balato Jisasa minu tai laya eya-kola, Jisasato sipitisa koo waka tupa peyo wata alane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wuane leai-kola, Jisasato akali utupane ipulupa loto, pii kokoli minditupa utupane lamawuato, Sataneto anu pua, bala tane katulo peyo watolo-peyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kanjiti mindina tane wandakali tupa yapu lo lapo puato, yakama teke-teke yanda peaindo, kanjiti okone katulo tai ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wandakali yame anda mindikina paliyaini tupa yapu lo lapo puato, yakama teke-teke yanda peaindo, yame okonelapo katulo tai ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dee, Satane yame oko yapu lo lapo puato, yakama teke-teke yanda peapindo, balana yame okone tai ata napene, koyo pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wandakali mindikipi mindimane katulo akali tai mindina andaka kolandaka loto, akali okonena pinju tupa mee tikayo moto, awua napolo-peya. Wuane tekeko, balato akali tai okone wamba ini andi lata yando, balato katulo minditaka akali okonena andaka yolane tupa mee tikayo moto, awua polopeya. Wuane pua teke, nambato akali tai Satane oko sia minuto, wandakali balato andi lalane tupa tita lo mialawane. ");
INSERT INTO ipi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nambato pii enene mindi yakama langeyo. Wandakali mindimane Ayiane Gote ando lamba leandopi, mana koo waka mindi mineandopi, Goteto balana mana koo utupane pitaka apia-maulupeya. ");
INSERT INTO ipi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wuane tekeko, wandakali mindimane Oli Sipitisa oko lamba leando, andipapi, matilipi, Goteto balana koo okone apia-mai napulu-peya. Jia. Balana koo okone balanga yapowa yolopeya. ");
INSERT INTO ipi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Oli Sipitisa oko Jisasanga atea-kola teke, loo tupana mana andene akali tupamane akali koo yame tupa ando atalane akali kawane Belesa-pulu bala Jisasanga ateya loto, Oli Sipitisa oko lamba leyai nembo toto, Jisasato pii okone leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jisasana angini amene ima takita epo atoto, bala epeakale lamaiyapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wuane leai-kola, wandakali kambua Jisasa ateanga pitu mapu peaini tupana mindimane bala lamawuato, nimbana angini, amene, imalini ima, utupane takita epo atoto, nimba ipu leyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wuane lea-kola, balato lapeke loto, nambana angini, amene ima, utupane apipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Wuane lalu, balato wandakali bala pitu mapu peaini tupa andamo-nena puato, Gotena nembo-tene oko wato minalaini wandakali yakama nambana angini, amene, imalini ima oo peteyai utupa andalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisasa bala ipa angini okona matenenga atoto, pai pua teke pii mana lamaiya-kola, wandakali kambua moke-ene bala ateanga epo amunguli peainipia. Amunguli peai-kola, wandakali utupane pitaka ipa matene okona ateakale lalu, bala sipi mindina peakaiyu loto, peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Pituto, balato pii kokoli minditupa loto, mana kambua utupane lamawuato, ale alapape leaipia. Akali mindimane tomo waini papaka lolo peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Papaka lea-kola, tomo waini minditupa ambe asininga tepa ya-kola, eka minditupa epoto, utupane neainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tomo waini minditupa ambe ana tokonga yuu aŋako yane okona tepa yaepia. Yuu aŋako ya-kola, waini utupane kapoyale poka loto, ika leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Utupane kapoyale ika leaini tekeko, pini tupa ana tokonga poto, yuu pangosa wayumane puu napea-kola, matili ana utupane nai-mane toto pea-angi, waini utupane kapu tamangua yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tomo waini minditupa ambe tani koo ani atene ika lalane yuu mindina tepa yaepia. Utupane poka loto, ika leaini tekeko, tani koo ani atene tupa anda yoto, utupane peyayo neai-kola, waini utupane-mane dini lia napeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tomo waini minditupa yuu epene mindina tepa wato, poka lo anda yoto, dini liaepia. Waini utupanena minditupanga dini paiyasa tepo liaepia. Minditupanga dini paiyasa liaepia. Minditupanga dini andete mindiki liaepia. ");
INSERT INTO ipi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wuane lalu, Jisasato utupane lamawuato, ale asia yene wandakali yakamato pii okone pai lo ale wato, pii okonena tene oko wayumane nembo talapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Matili Jisasana disaipolo alesa akali tupapi, bala towa atu atalaini wandakali waka tupapi, utupane yakama angu bala towa atu pituto, pii kokoli lale tupana tene oko akipe lo bala tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Tipa peai-kola, balato utupanena pii okone yano peyoto, takita atalaini wandakali tupamane yamapane peke leaindo, Goteto utupanena koo tupa apolopeya leaipia. Tene okonena, utupane-mane yamapane peke naleakale nembo toto, nambato pii kokoli tupa angu utupane lamalu-wakola, ole kambuanga utupane-mane nambana pii okone ale wato teke, pii okonena tene tupa katulo nembo natolo-peyai. Ole kambuanga utupane-mane nambana piape andoto teke, Goteto pitaka taka ando atalane lo katulo anda napulu-peyai. Wuane tekeko, Goteto pitaka taka ando atalane lo pii wamba too pene yane oko nambana disaipolo tupa yakamanga lapana yane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wuane lalu, Jisasato utupane lamawuato, yakamato pii kokoli okonena tene oko nembo nateaindo, anu puato, yakamato pii kokoli waka tupa pitakana tene tupa nembo tolopeyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Akali mindimane tomo waini papaka lalane pua teke, akali mindimane Gotena pii layene oko lalane. ");
INSERT INTO ipi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Akali mindimane tomo waini papaka lea-kola, minditupa ambe asininga tepa ya-kola, eka minditupa epoto, utupane neaini. Wuane pua teke, akali mindimane Gotena pii oko leya-kola, wandakali minditupa-mane pii okone ale wato, bilipi lalaini tekeko, okone angi teke Satane epoto, Gotena pii utupanena nembo-tenenga eya okone mo alu piya alane. ");
INSERT INTO ipi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tomo waini minditupa ambe ana tokonga yuu aŋako yane mindina tepa wato, poka loto, anda yane tekeko, ana tupa nai-mane toto pea-kola, waini utupane kapu tamangua yaepia. Wuane pua teke, wandakali minditupa-mane Gotena pii oko ale wato, wamba ini bulupane epele wato, bilipi lalaini. ");
INSERT INTO ipi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wuane tekeko, utupane-mane Gotena pii oko bilipi lo ateyai-kola, wandakali waka minditupa-mane kenda-pene andane tupa wandakali utupanenga maiki piyaini. Maiki peyai-kola, Gotena pii oko bilipi leyama nayu nalene wandakali utupane yakama pini wayumane peya napene gulo atoto, ole ukupini aŋalapo angu bilipi lo atalu, Gote wamba ini kapoyale awua tepa alaini. ");
INSERT INTO ipi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Tomo waini minditupa ambe tani koo ani atene tupa ika lalane yuu mindina tepa wato, poka lo ika leaini tekeko, tani koo ani atene tupa andayoto, utupane peyayo neaipia. Wuane pua teke, wandakali minditupa-mane Gotena pii oko ale wato, wamba bulupane bilipi lalaini tekeko, matili kenda-pene minditupa utupanenga epeya-kola, utupane-mane anu pimape lo nembo kambua talaini. Minditaka kambua mo yatawa atalaini mana oko epele wete wato, utupane-mane munipi, waka minditakapi, utupane kambua miaima lakae lo nembo talaini mana okonemane Gotena pii oko ombo alane. Tene okonena, wandakali utupane-mane yuu okona minditaka eya tupa anu pua mia-makalepe lo nembo kambua teyai-kola, Gotena pii yakamanga eya okomane dini lia napiyane. ");
INSERT INTO ipi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tomo waini minditupa yuu epene mindinga tepa wato, dini kambua lialane pua teke, wandakali minditupa-mane Gotena pii oko ale wato, bilipi leyama nayu leyai-kola, utupanenga dini kambua lialane. Minditupanga dini paiyasa tepo lialane. Minditupanga dini paiyasa wataka lialane. Minditupanga dini andete mindiki lialane. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","22","Wuane lalu, Jisasato wandakali utupane tipa puato, sisopene mindimane lamu mindi ombo yakale nembo toto, wandakali-mane lamu okone kayuto, awua epalaepe leaipia. Pee, lamu okone yalane toko mindina pangosa yata wakale nembo toto, balato lamu awua epalaepe. Jia. Wandakali-mane lamu okone tepolo tokonga yata wakale nembo toto, kayu awua epalane. Wuane pua teke, andipa minditaka mindi too pitane yando, Goteto okone too pitane atapowa ateakale lo ando konda napulu-peya. Jia. Minditaka andipa too pua, ombo atane eya tupa pitaka matili panakame yolopeya-ko. ");
INSERT INTO ipi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wandakali ale asia yene tupa yakamato pii okone wayumane ale alapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Wuane lalu, balato utupane lamawuato, yakamato wandakali yangone mindinga mana minulai pua teke, Goteto mana okone teke yakamanga wayumane wete minulu-peya. Wandakali mindimane Gotena pii oko wayumane bilipi leando, Goteto balana bilipi oko minu tai laya ola-kola, wandakali okonemane Gotena pii oko bilipi leyo nayu lolopeya. Wuane tekeko, wandakali mindimane Gotena pii oko bilipi leyo nayu naleando, Sataneto wandakali okonena bilipi oko mo alu piya yakale lo Goteto ando kondolo-peyako. Yakamato Gotena pii oko ale wato, wayumane nembo talapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wuane lalu, Jisasato pii kokoli waka mindi utupane lamawuato, akali mindimane tomo waini papaka lalane pua teke, Goteto nanima ando atalane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Akali mindimane tomo waini papaka lalu, ole dindi lo bala utulu paliki, upa pitane ika laka, peya-kola, tomo waini utupa poka loto, anda yalane tekeko, anu puato, poka lo anda eyape lo akali okonemane anda napiyane. ");
INSERT INTO ipi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bulupane yuu-mane dini tupa poka laya wato, anda eya-kola, papula peyalane. Papula peyalu, dini lialane. ");
INSERT INTO ipi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dini nape yola-angi, tomo mandipe-pene guleya oko andoto, akali okonemane napia awua poto, wamba kapoyale yalane. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wuane lalu, Jisasato pii kokoli waka mindi utupane lamawuato, Goteto wandakali ando atalane piape oko aki mindi towa makande pimape leaipia. Nanimato pii kokoli andoko loto, Goteto wua pua, wandakali tupa ando atalane lamape. ");
INSERT INTO ipi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maseta waini oko yuu okona tomo waini waka yalane tupa pitaka sia minuto, aŋako wete eya-kola, wandakali-mane yandalaini. ");
INSERT INTO ipi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yandeyai-kola, maseta waini okone poka lo anda yoto, eenga tomo waka tupa pitaka sia minalane. Kembone tupa andane peleya-kola, eka tupa kembone tupana anda puato, tambosa pitiyaini. Wuane pua teke, ini bulupane Goteto wandakali aŋalapo angu ando atoto, piape pua ateya-kola, matili balana yame tupa andane kambua wete atalaini pua atolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wandakali-mane pii kokoli okonepene tupa ale wato, katulo pii utupanena tene oko nembo tolopeyai nayuto, Jisasato pii kokoli okonepene kambua loto, Gotena pii layene oko utupane lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Balato pii mindikipi mindi panakame nalene, pii kokoli angu lamaiki peane tekeko, matili balana disaipolo tupa bala towa angu ataka peai-angi, balato pii kokoli utupanena tene tupa lapana aka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ole okone angi teke, nai andaka pea-kola, Jisasato balana disaipolo tupa lamawuato, nanima ipa angini okona amo yangi maa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Maa lea-kola, wandakali amunguli peaini tupa ateakale lalu, balana disaipolo tupa sipi bala peteane okona peakaiyu lalu, bala towa atu peai-kola, sipi waka minditupa utupane towa atu teke peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ipa angini okona tombenenga peai-kola, popo andane wete mindi lo awua epeane okomane ipa andane wete mindi taimane mina ika laya yaepia. Ipa ika leane okonemane sipi oko ango mangua wato, ipa pangosa mo landa peyoyale peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Okone angi, Jisasa bala sipi okona tipinisa kanda yane okona palea-kola, balana disaipolo tupamane bala peya ika loto, tisa, nanima omoyale peyama oko nimbato mee ya nembo telepe lo bala tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tipa peai-kola, bala ika loto, popo leane oko laiya lalu, ipa okone lamawuato, ema napene, mee yaa leaipia. Wuane lea-kola, popo leane oko tepa ya-kola, ipa taimane ika leane oko tepa alu, ema aŋakopi mindi napeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wuane pea-kola, balato akali utupane tipa puato, anu peakale yakama yuku eyaipe. Yakamato Gote lo bilipi naleyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wuane lea-kola, utupane-mane yuku wete wato, yakama teke-teke pii lalawa puato, popo andane lala okola, ipa taimane ika lala okola, okonelapo lapotaka-mane balana pii ale eyapi-ko. Akali oko api wete ateyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisasa balana disaipolo tupa towa ipa angini Galili okona amo-yangi poto, Getasa tano okona tane wandakali tupana yuu okona peakaiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","5","Sipitisa koo mindi yuu okonena tane akali mindinga ateya-kola, balato wandakali mali tupana tombenga ataka piyaepia. Wamba ole kambuanga akali minditupa-mane anangapupi, sene endepi, utupane-mane akali okone andi leaini tekeko, balato sene tupa minu toae lo apiaka piyu, anangapu tupa minu koyoto, apiaka piki piya ya-kola, wandakali-mane dee lapone sene ende-mane akali okone katulo andi nalape-pene guleaipia. Utulupi, otongapi, ole dindi lo bala wandakali mali tupana tombenga atoto yandopi, yuu wangiane tupana atoto yandopi, bala kalae loto, bala tane ana-mane katiki pua atalaepia. Jisasa bala sipi oko tepa alu, ipa matenenga epea-kola, sipitisa koo atene akali okonemane wandakali mali piyaini ama okone tepa alu, bala malanda olo epeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bala amonga wete atoto, Jisasa andalu, taimane epoto, bala ateanga aiki leka yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aiki leka ya-kola, Jisasato sipitisa koo mindi akali okonenga atene oko lamawuato, nimbato akali oko tepa alu, puu leaipia. Wuane lea-kola, sipitisa koo okonemane pii taimane wete loto, Gote andane wetete okona Iwanane Jisasa nimbato nambanga aki pulape. Nimbana weno minuto, nambato tandaka andane nimba gii napulu-peyawa. Goteto andeya laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wuane lea-kola, Jisasato bala tipa puato, nimba gene apipe leaipia. Wuane lea-kola, akali okonemane balana pii okone yano peyoto, sipitisa koo kambua nambanga ateya-kola, nambana gene oko ami lalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akali okonemane Jisasa-o-o, sipitisa koo tupa yuu oko tepa yakale loto, nimbato utupane peyo watolene leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Okone angi, yia yomo andane mindi amonga-yale atoto, yuu wangiane mindina tani no ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ateai-kola, sipitisa koo utupane-mane Jisasa lamawuato, nanima yia utupanenga kolandaka lamakale nembo teyama-ko. Nimbato nanima utupanenga kolandaka lalapa laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wuane leai-kola, utupane-mane wuane peakale lo balato ando konda ya-kola, sipitisa koo utupane-mane akali okone tepa alu, yia utupanenga kolandaka leainipia. Kolandaka leai-kola, yia tausene lapo utupane pitaka wangiane okona taimane nena pulu, ipa angini peteane okona peakoto, ipa nalu, omeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Omeai-kola, yia yatawa atalaini akali tupamane tano okonapi, yuu waka tupanapi, utupanena taimane poto, mangene Jisasato peane tupa lo tawe yai-kola, anu piyape lo tatake wato, wandakali tupamane andolo epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Utupane-mane Jisasa ateanga epoto andeai-kola, akali wamba sipitisa koo kambua wete atene ateane oko bala mini palu, tona puato, peteanga andoto, utupane-mane yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yuku yai-kola, mangene wamba peane oko andeaini wandakali tupamane wandakali epeaini tupa lamawuato, Jisasato akali wamba sipitisa koo atene ateane oko mo atu yala-kola, yia tupa ipasa poto, omalai lo lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","lamaiya-kola, wandakali utupane-mane Jisasa taimane lamawuato, nimba nanimana yuu oko tepa alu puu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Puu leai-kola, Jisasa bala sipi okona peakaiyu lea-kola, akali wamba sipitisa koo atene atu yane okomane Jisasa tee loto, namba nimba towa atu baape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Baape lea-kola, Jisasato jia lalu, nimba andaka poto, Akali Andane okomane nimba ondo wato, nimba moyo wua piya lo nimbana yame tupa lamaiki pua atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wuane lea-kola, akali okone bala poto, Dekapolisa disitiki okona tane wandakali tupa lamawuato, Jisasato namba moyo wua piya lea-kola, wandakali pitaka-mane ale wato, epele wato, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisasa bala sipi mindina pitiyu, lapone ipa angini okona amo-yangi poto, matenenga atea-kola, wandakali kambua wete epo amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Amunguli peai-kola, Juta yamena lotu anda oko ando atalane akali gene Jaitusa lene mindi epoto, Jisasa andoto, bala ateanga aiki lekawa tombawua leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tombawua loto, balato Jisasa taimane lamawuato, namba wanane oko omoyale peya-ko. Nimbato bala mo atu yole-kola, bala saka peteakalenga, nimba epoto, nimbana kini balanga yata ola leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wuane lea-kola, Jisasa bala akali okone towa peapi-kola, wandakali kambua longo waka-mane bala ata tongope lama-lama atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Peai-kola, ee ana alesa kii kalo teke pitiyane wanda mindi bala wandakali utupane atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wamba balato dokosa waka-waka kambua andolo puku puato, balana munipi, waka minditaka yane tupapi, utupane pitaka maya-kola, utupane-mane ole kambuanga tandaka andane bala mayaini tekeko, balana siki okone atu nayene, andane teke guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Wandakali-mane bala lamawuato, Jisasato wandakali tupa mo atu yalane leai-kola, wanda okonemane ale wato, nambato balana tonanga wata ewando, nambana siki oko atu yolopeya nembo teaipia. Wuane nembo toto, balato wandakali kambua asini peaini tupana tombenenga Jisasana masianenga epoto, balana tonanga wata yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wata ya-kola, okone angi teke wanda okonena siki oko atu ya-kola, balana umbaininga siki okone atu yala nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisasana tai-lene minditupa wanda okonenga pea-kola, balato wandakali kambua tupana tombenenga atoto, mopeke loto, apito nambana tonanga wata alape lo tipa peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tipa pea-kola, balana disaipolo tupamane balana pii okone yano peyoto, wandakali kambua-mane nimba ata tongope lama peyai oko nimbato andele-ko. Anu peakale nimbato wandakali tupa tipa puato, apito namba wata alape lelepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Utupane-mane wuane leaini tekeko, apito bala wata alape lo andoyale, balato andamo nena pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jisasana tai-lene minditupa nambanga epala-kola, balato namba ani ateyape lo andamo nena pua ateya lo andoto, wanda okonemane yuku wato, putu-putu peyoto, Jisasa ateanga epeaipia. Epoto, aiki lekawa, tombawua loto, mangene enene peane tupa pitaka bala lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","lamaiya-kola, Jisasato bala lamawuato, wanane, nimbato nambanga tungi peyoto, bilipi lele okonena, nambato nimbana siki oko mo atu yalo-ko. Nimba mini epene palu puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Balato pii okone lo atea-kola, akali minditupa-mane Jaitusa okona andaka atala epoto, bala lamawuato, nimba wanane oko omala-ko. Tisa oko nimba towa atu masia-pene epolane konda yakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wuane leai-kola, Jisasato Jaitusa nimbato nembo kambua natene, mee nambanga tungi peyoto, bilipi lo atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wuane lalu, balato Pitapi, Jemesapi, balana amene Jonepi, utupane angu makale ipulupa loto, wandakali waka mindikipi mindi bala watama epeakale lo ando konda nayaepia. ");
INSERT INTO ipi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bala utupane towa atu Jaitusa okona andaka peakaiyu loto andeai-kola, wandakali tupamane yamataka lo ai taimane leainga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Andoto, bala anda-pango kolandaka loto, wandakali utupane lamawuato, andopane oko oma napene, mee limu paleya-ko. Anu peakale yakamato yamataka lo ai taimane leyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wuane lea-kola, utupane-mane bala lamba loto, giwa yai-kola, balato utupane pitaka kamaka peakale lo peyo watalu, balana disaipolo tepo tupapi, wana okonena angini, ayianepi, utupane angu atu poto, wana omene yane lumu okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jisasato wana okonena kininga minuto, talita kumi leaipia. Nanimana pii lo mopeke loto, wana nimba ika laa leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wana okone bala mali ana alesa angu pene petea-kola, Jisasato wana lea. Ika laa lea-kola, okone angi teke wana okone bala ika loto, epoko pea-kola, balana angini, ayiane-la, liyamba moko andane wete leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wana okone ika lea-kola, Jisasato balana angini, ayiane-la, okonelapo lamawuato, nambato wana omene oko mina ika leyo oko liyambato wandakali mindikipi mindi lamaulapele. Jia wete leaipia. Wuane lalu, wana oko ulia neakale maiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisasa bala yuu okone tepa alu, balana yuu tene okona pea-kola, balana disaipolo tupamane bala watama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Sambasa angi, balato Juta yamena lotu anda okona poto, pii mana lamaiya-kola, wandakali kambua-mane ale wato, moko wete loto, pii lalawa puato, akali oko bala kamanda pia oko andeyama leainipia. Bala Matiya iwanane. Bala Jemesapi, Josepepi, Jutasapi, Saimonepi, utupanena amene. Bala imalini tupa nanima towa wali atu pitiyamane. Pii mana balanga eya tupa waka mindi-pene yalua-ko. Balato pii mana utupane ani tawe meae-yape. Balato anu puato, metekolo piape tupa piyanepe. Wuane loto, utupane-mane balana pii oko ale oyale embo yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Balana pii ale oyale embo yai-kola, balato utupane lamawuato, potopesa akali mindimane pii leya-kola, balana yuu tene okona tane wandakali tupapi, balana anda okona atalaini wandakali tupapi, bala tanena yame tupapi, utupane-mane balana gene oko laiyu na-lalaini tekeko, yuu waka tupa pitakana tane wandakali tupamane balana gene oko laiyu lalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Balana yuu tene okona tane wandakali kambua-mane bala lo bilipi naleai-kola, bala moko loto, nembo kambua teaipia. Wandakali kambua-mane bala lo bilipi naleai-kola, balato balana kini oko wandakali siki pelene aŋalapo minditupanga angu yata wato, mo atu yalu, metekolo piape waka mindi katulo napene, konda yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Jisasa balana yuu tene oko tepa alu, tano aŋako waka tupana puku puato, Gotena pii mana lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wuane puato, balana disaipolo alesa tupa ipulupa loto, sipitisa koo tupa peyo watolane tai-lene oko utupane maiyu, yakama lapo-lapo lo piape pulu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pulupa loto, balato utupane lamawuato, yakamato asia polai tupana ulia yandopi, nuu yandopi, muni yandopi, waka minditaka yandopi, utupane mandi napene, kalango angu aiyu pulupape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yakamato sukee piyapale tekeko, singilisa lapo na-piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wuane lalu, balato pii mindi tako pua loto, yakama yuu mindina polai-angi, anda anduane mindimane yakama yatawa paleando, yakama anda waka mindina pali-pali napene, anda mindiki okonena angu palu atoto, yuu okonena epoko puato, piape pua atalapape leaipia. Yakama yuu okone tepa alu, polai-angi, anda okone tepa alu, pulupape. ");
INSERT INTO ipi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yuu mindina tane wandakali tupamane Gotena pii yakamato lamaulai tupa ale naene, yakama yatawa pali napeaindo, utupane yakama tane mana koo mineyama lo andeakalenga, yakamana kenenga yuu kangalamu atolane tupa tanda lo tepa alu, yuu okone tepa alu, pulupape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wuane lea-kola, balana disaipolo alesa akali tupamane poto, wandakali tupa lamawuato, yakama yamapane peke lalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wuane loto, utupane-mane sipitisa koo kambua peyo wataka, olipi dini ipane tupa wandakali siki pelene kambua tupanga aiya amawuato, utupanena siki tupa mo atu yaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Jisasato metekolo piape kambua piki pua atea-kola, wandakali kambua-mane balana gene oko laiyu leainipia. Yangi-mane akali okone bala Ilainja ateya leainipia. Yangi-mane bala potopesa akali wamba ateaini okonepene mindi ateya leainipia. Yangi-mane pii waka mindi loto, Goteto ipa peya-maiyane akali Jone malinga ika laya wato, bala minu tai laya eya-kola, balato katulo metekolo piape utupane pua atalua leainipia. Wuane leai-kola, kiŋi Etoteto ale wato, wamba nambato Jone maa pai lewa oko bala malinga ika lapia yalua leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Anu peakale Etoteto Jone maa pai leaipiape. Wamba Etoteto balana amene Pilipi okona wetene Etoti-yasa oko tondo moto, kee lea-kola, Joneto Etote lamawuato, nimbato wanda oko tondo moto, kee lalu atele okomane Gotena loo oko angowa atele okonde lo lamaiki peaipia. Wuane lo lamaiki pea-kola, Etoti-yasato Jone towa yataka wato, bala peyo ome lokale nembo teane tekeko, Etoteto Jone bala Gotena akali epene tika-pene mindi ya lo nembo teaipia. Wuane nembo toto, bala ando yukuwa atoto, balana pii ale wato, nembo kambua teane tekeko, balana pii epelewa ale aka peaipia. Tene okonena, Etoti-yasato Jone peyo ome lolane lo yuku wato, Etoteto ami yanda yene minditupa lamawuato, mindimane Jone peyo ome lolane. Yakamato bala katapusa pua aindaka loto, bala ando atalapape lea-kola, Etoti-yasato katulo Jone peyo ome naleaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","24","Matili Etote bala angini-mane mandeane oto oko epea-kola, Etoteto tomo kambua yangalapa loto, gapomane piape akali gene yene tupapi, ami ando atalaini akali tupapi, Galili disitiki okona akali kawane tupapi, utupane bala towa atu tomo nolo epeakale leaipia. Utupane epoto, tomo no peteai-kola, Etoti-yasa wanane oko epoto, danisa lea-kola, Etotepi, bala towa atu tomo no peteaini tupapi, utupane-mane andoto, epele yainipia. Epele wato, kiŋi Etoteto balana weno minuto, wana okone lamawuato, nimbato minditaka mindi mokale gii leendo, enene wete, nambato okone gukale. Yuu nambato ando atalawane oko tombo peyoto, yangisa gii leendo, nambato yangisa gukale leaipia. Wuane lea-kola, wana okone bala takita poto, balana angini tipa puato, nambato aki mindi gii loape leaipia. Wuane lea-kola, Etoti-yasato Jone peyo ome lolane asia mindi eya ya lo andoto, nimbato ipa peya-maiyane akali Jone okona kawane gii lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wuane lea-kola, wana okonemane kiŋi oko peteanga kapoyale peke loto, epapu oko angi teke, ipa peya-maiyane akali Jone okona kawane oko pelesa andane mindina yata wato, namba gula leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wuane lea-kola, kiŋi oko bala mini kenda wete yane tekeko, akali utupane pitaka towa pituto, weno minuto, nimbato minditaka mokale gii leendo, enene wete nambato okone gukale lalo oko nembo toto, wana okona pii tanga na-lokale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wuane nembo toto, okone angi teke, kiŋi okomane ami yanda yene mindi lamawuato, nimbato Jonena maa oko pai loto, balana kawane oko mo awua ipu leaipia. Wuane lea-kola, ami yanda yene okone bala katapusa andaka poto, Jonena maa pai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pai loto, balana kawane oko pelesa mindina yata wato, awua epoto, wana oko maya-kola, wana okomane kawane oko balana angini oko mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Etoteto Jone peyo ome lea-kola, Jonena disaipolo tupamane ale wato, balana umbuaini oko mo awua poto, mali peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Matili Jisasana aposolo akali alesa tupa peke loto, bala ateanga epo amunguli puato, utupane-mane piape waka-waka peaini tupapi, pii mana lamai-yaini tupapi, utupane pitaka bala lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Okone angi, wandakali kambua wete Jisasa ateanga po ipu pua ateai-kola, Jisasapi, balana disaipolo tupapi, utupane yakama tomo nolane oto mindi yaa napeaipia. Yaa napea-kola, Jisasato balana disaipolo tupa lamawuato, nanima angu wandakali napalene yuu mindina poto, gii ukupini mindi oto mo atamakale ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ipulupa lea-kola, utupane angu sipi mindina pitiyu, wandakali napalene yuu mindina makale loto, peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Utupane yakama angu sipi mindina pitiyu peaini tekeko, wandakali kambua-mane Jisasapi, balana disaipolo tupapi, utupane ukusane poyale peyai lo andeaini-pia. Andoto, tano tupa pitakana tane wandakali kambua asini tai loto, Jisasa poyale peane yuu okonena yakama wamba ini ingane poto ateai-kola, Jisasapi, balana disaipolo tupapi, utupane matili epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Epoto, Jisasa bala sipi oko tepa alu, ipa matene okona poto andea-kola, wandakali kambua wete ateaini tupa sipisipi yatawa atalane akali mindi ata napene gulo ateainga andoto, balato utupane ondo wato, pii mana kambua lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Matili nai andaka poyale pea-kola, balana disaipolo tupamane bala ateanga poto, wua leainipia: Wandakali napalene yuu mindina ateyama-kola, andipa ole leya-ko. ");
INSERT INTO ipi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wandakali utupa tano aŋako mindina yandopi, wandakali mindina eenga yandopi, okonelapo mindina poto, yakamana ulia nolane tupa kambea-kalenga, nimbato utupane peakale laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, yakama tane wandakali utupa tomo neakale maiyapa leaipia. Wuane lea-kola, balana disaipolo tupamane akali angu tausene yaupi mindi ongane ateainga andoto, nanimato mindisa poto, muni kambua wete-mane betesa kamboto, wandakali utupa pitaka-mane neakale maipe-penepe lo bala tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tipa peai-kola, balato utupane lamawuato, yakamanga betesa aki-tupi eyape lo andolo pulupa leaipia. Wuane lea-kola, utupane-mane andolo poto, nanimanga betesa yau, pisa lapo eya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wuane leai-kola, balato utupane lamawuato, wandakali tupa yomo waka-waka gulo tani kaka-ene okona peteakale lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wuane lea-kola, wandakali minditupa wane andete, wane andete lo yomowa peteaini-pia. Minditupa paiyasa yau, paiyasa yau lo yomowa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Peteai-kola, balato betesa yau tupapi, pisa lapo okolapi, utupane moto, ati kenga andaiyu loto, Gote wayu pele lalu, betesa tupa konde leaipia. Konde loto, balana disaipolo tupa mawuato, betesa utupa tale puato, wandakali tupa neakale maiyapa leaipia. Wuane lalu, balato pisa okonelapo konde loto, balana disaipolo tupa mayaepia. Mawuato, balato utupane lamawuato, yakamato pisa okonelapo tale puato, wandakali tupa pitaka-mane neakale maiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Akali tupa angu dii loto, tausene yau tupa tomo neainipia. Wandakali utupane pitaka-mane tomo no embo yai-kola, balana disaipolo tupamane betesapi, pisapi, mee akenane yane tupa mo yomo wato, basaketa nuu andane alesa tumbi laya wato, yata yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Okone angi, Jisasato balana disaipolo tupa lamawuato, nambato wandakali utupa peakale lokalenga, yakamato sipi okona pitiyu, ipa angini okona amo-yangi poto, Betesaita tano okona ingane pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pulupa lalu, bala yuu wangiane mindina pote lolo peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nai andaka pea-kola, disaipolo tupa sipi okona pitiyu, ipa angini okona tombenenga peai-kola, Jisasa bala angu yuu wangiane okonena ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yuu wangiane okonena ato andea-kola, balana disaipolo tupa poyale peaini ukusane ato popo andane mindi lo awua epea-kola, utupane-mane sipi okone pulu lama poyale pitete wete yainga andeaipia. Matili yuu waa loyale muna pea-kola, balato akali utupane peteaini sipi okona poyale, ipa tokonga kee atama poto, utupane peaini mandaka gulo poto, utupane wata ai-peke lokale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Balana disaipolo tupa pitaka-mane andeai-kola, bala ipa angini okona tokonga kee atama epeanga andoto, yama mindi epeya nembo toto, yuku wete wato, kalae leainipia. Kalae leai-kola, balato utupane kapoyale lamawuato, namba Jisasa epeyo-ko. Yakama yuku naene, yamapane tuu pua pitiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wuane lalu, bala sipi okona peakaiyu lalu, utupane towa atu peteai-kola, popo andane leane oko tepa yaepia. Tepa ya-kola, balana disaipolo tupa moko wete loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wamba balato wandakali kambua wete tupa betesa mayane-angi, balana disaipolo tupamane bala Gotena Iwanane ya lo nembo natene, piape okone anu pua peyape lo tatake yainipia. Tene okonena, bala epea-kola, popo andane leane oko tepa ya-angi, utupane-mane moko wete loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisasapi, balana disaipolo tupapi, utupane sipi okona pitiyu, Genesa-leta yuu okona peai-kola, ipa okomane sipi okone mindisa awua polane nembo toto, utupane-mane sipi okone ende mindimane andi leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jisasa balana disaipolo utupane towa sipi okone tepa yai-kola, yuu okonena tane wandakali tupamane akali epeya oko bala Jisasa ya lo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Andalu, wandakali utupane yakamana yuu tene tupana peke loto, Jisasa wali epoyale peya lo wandakali tupa lamaiki peainipia. Lamaiki peai-kola, matili Jisasa bala tano andane tupapi, tano aŋako tupapi, yuu waka tupapi, utupanena puku pea-kola, wandakali-mane bala yuu mindina epo ateya laka peainipia. Wuane laka peai-kola, wandakali waka tupamane ale wato, wandakali siki pelene tupa takea tokonga paleakale laka puato, awua epoto, yuu utupanena wandakali epo amunguli piyaini ama tupana yata aka peainipia. Yata alu, utupane-mane Jisasa lamawuato, wandakali siki pelene tupamane nimbana tona duninga wata yakale lo nimbato ando kondape leainipia. Jisasato atu yalua lea-kola, bala wata yaini wandakali tupa pitakana siki tupa atu yaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Patasai tupapi, Juta yame wandakali waka tupapi, utupane pitaka-mane yakama yumbanena mana kambua tupa wato minalaini. Mana utupane wato minuto, utupanena kapopi, siso-penepi, pene aene botonja-mane waa-penepi, utupane Gotena wenonga kalato ata napeakale nembo toto, utupane pai lo wete wasa-wasa peyalaini. Dee, utupane-mane yakama yumbanena mana wato minuto, makesanga atalu, peke loto, Gotena wenonga utupanena kii kalato ata napeakale nembo toto, utupanena kii pai lo wete wasa-wasa peyoto, tomo nalaini. Yakamana kii pai lo wete wasa-wasa napelene, tomo naa na-piyaini. Alu mindi loo tupana mana andene akali minditupa Jutusaleme atala epoto, Patasai minditupa towa Jisasa ateanga epeainipia. Epoto andeai-kola, balana disaipolo tupamane kii pai lo wete wasa-wasa peya napene, Gotena wenonga yakamana kii kalato ate peta atene gulo atoto teke, tomo no ateainga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Andoto, utupane-mane Jisasa tipa puato, anu peakale nimbana disaipolo tupamane nanima yumbanena mana yata-ene tupa wato mina napene, Gotena wenonga yakamana kii kalato ate peta atoto teke, tomo nalainipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","8","Wuane leai-kola, Jisasato utupane lamawuato, wamba potopesa akali Aisayato andakasa alaini wandakali yakama andayo pii enene wete mindi lo pepa peyoto, wandakali utupane-mane yakamana ambulini-mane nambana gene oko laiyu lalaini tekeko, utupanena mini, yamapane-la, okonelapo nambanga yaa napene, amonga yakale atalaini leaipia. Wamba utupanena yumbane-mane mana minditupa yata yai-kola, yakamato mana utupane wandakali waka tupa lamawuato, Gotena loo tupa mana langeyama lalaini. Tene okonena, utupane-mane namba lo lotu lalaini mana okomane dini angini mindi lia napiyane. Aisayato wuane lo pepa okone peleane pua teke, yakamato Gotena loo tupa masia mawuato, yakamana yumbane tupana mana yata ene tupa wato minu atalaini. ");
INSERT INTO ipi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yakamato mana epene tupa wato mineyama nembo toto, yakama yumbanena mana utupane wato minuyale, Gotena loo tupa masia maiyaini. ");
INSERT INTO ipi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wamba Mosesato Gotena loo utupanena mindi yata wato, nimbana angini, ayiane-la, okone-lapona pangosa atoto, okone-lapona pii ale amawua atape leaipia. Wandakali mindimane bala angini yandopi, ayiane yandopi, okone-lapona mindi andayo pii koo mindi leando, yakamato bala peyo ome lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Goteto wuane leane tekeko, yakamato wuane na-lalaini. Jia. Yakamato loto, wandakali mindimane balana angini yandopi, ayiane yandopi, okone-lapona mindi moyo maulane minditaka yatawa ateya-kola teke, balato okonelapo lamawuato, nambato liyamba moyo minditaka gipe-pene tupa Gote mauwakale lo mandeke pua yata auwa lape-pene. Wuane leando, balato balana angini, ayiane-la, okonelapo mee aŋakopi mindi moya napeakale lalaini. ");
INSERT INTO ipi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yakamato yakamana yumbane tupana mana okone wandakali tupa lamai-yaini okomane Gotena pii layene oko mee gulaya alaini. Yakamato mana okonepene kambua wato minalaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wuane lalu, Jisasato wandakali tupa bala ateanga pai pua teke ipulupa loto, utupane andayo, yakama pitaka-mane nambana pii oko ale wato, pii okonena tene oko wayumane nembo talapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wandakali-mane minditaka moto, yakamana nee asianga aindaka loto, nalaini okomane Gotena wenonga utupane mo kalato ataya aa napiyane. Jia. Minditaka wandakalina nee asianga ato kamaka epalane tupamane Gotena wenonga wandakali utupane mo kalato ataya alane. ");
INSERT INTO ipi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wandakali ale asia yene tupamane pii oko ale wato, wayumane nembo talapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wuane lalu, Jisasa bala wandakali amunguli pua ateaini utupane tepa alu, anda mindina kolandaka lea-kola, balana disaipolo tupamane bala tipa puato, pii kokoli lale okonena tene oko akipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Wuane leai-kola, balato utupane tipa puato, yakamatopi pii kokoli okonena tene oko nembo nateyaipe leaipia. Wandakali-mane tomo neyai-kola, tomo okone utupanena yamapane okona anda-pango napalane. Jia. Minditaka moto, utupanena nee asia okona aindaka leyai tupa pitaka utupanena ini anda-pangosa peya-kola, ii too apialaini-ko. Wandakali-mane tomo mindi neya-kola, tomo okonemane Gotena wenonga utupane mo kalato ataya na-alane. Jisasato wuane leane okomane tomo yame tupa pitaka Gotena wenonga kalato ata napene teke-teke eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wuane lalu, Jisasato pii mindi tako pua loto, minditaka wandakalina anda-pangosa ato kamaka epalane tupamane Gotena wenonga utupane mo kalato ataya alane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wandakali-mane nembo koo toto, pamuku pimakale, minditaka pake namakale, wandakali mindi peyo ome lamakale, wandakali waka mindina wetene yandopi, akalini yandopi, bala towa pamuku pimakale nembo talaini. ");
INSERT INTO ipi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Dee, wandakali minditupa-mane minditaka kambua wete tupa mia-makale nembo talaini. Minditupa-mane yangone tupa minu koyamakale nembo talaini. Minditupa-mane yangone tupa andakasa amakale nembo talaini. Minditupa-mane mana yala-pene tupa mina-makale nembo talaini. Minditupa-mane wandakali waka tupa towa apiangu piyaini. Minditupa-mane wandakali waka tupa sia mineyama nembo talaini. Minditupa-mane wandakali waka tupa layangoto, lamba lalaini. Minditupa-mane kee aka pua atamakale nembo talaini. ");
INSERT INTO ipi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nembo-tene koo utupane pitaka wandakalina anda-pangosa paleya-kola, wandakali-mane mana koo utupane wato minalaini. Wato miniyai-kola, Gotena wenonga mana koo utupane-mane wandakali utupane mo kalato ataya alane. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisasa bala yuu okone tepa alu, Taya tano okona peaipia. Wandakali-mane bala epo ateya lo anda napeakale nembo toto, bala anda mindina kolandaka leane tekeko, wandakali mindimane bala andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Andoto, Jisasa epo ateya lea-kola, wanda mindimane ale yaepia. Bala Pinisia yame wanda mindi pituto, Sitiya potopinja okona peteane tekeko, balato Gitiki yamena mana tupa wato minalaepia. Sipitisa koo mindi wanda okonena wanane okonga atea-kola, wanda okone bala Jisasa ateanga poto, aiki leka wato, namba wanane okonga sipitisa koo ateya oko nimbato peyo watola leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Bala Juta yame wanda mindi jia ya lo andoto, Jisasato bala lamawuato, nambato andopane tupana tomo tupa moto, peango tupamane neakale lo peya-amo lewando, kuai nalolo-peyako. Andopane tupamane tomo wamba ini no embo yakale lo nimbato ando kondaa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wuane lea-kola, wanda okonemane balana pii okone yano peyoto, Akali Andane, nimbato enene lele tekeko, andopane tupamane tomo no peteyai-kola, peango tupa toko pangosa atoto, tomo pulu-lene tepa olane tupa nalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wuane lea-kola, Jisasato bala lamawuato, nimbato wuane lele okonena, nambato sipitisa koo nimbana wanane okonga ateya oko peyo wateyo-ko. Nimba andaka peke laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wuane lea-kola, wanda okone andaka peke loto andea-kola, sipitisa koo okomane bala wanane oko tepa alu pea-kola, wana oko atu yoto, toko okona palu yanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Okone angi, Jisasa bala Taya yuu oko tepa alu, Saitone tano okona puapo wato, Dekapolisa disitiki okona tombenenga poto, Galili ipa angini okona peakaiyu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Peakaiyu lea-kola, wandakali minditupa-mane akali ale tuma mindi atu epeainipia. Akali okone bala katulo pii kuai lo na-lalaepia. Bala atu epeaini wandakali tupamane Jisasa tee loto, nimbana kii oko akali okonga yata olape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wuane leai-kola, amunguli pua ateaini wandakali tupa ateakale tepa alu, Jisasato akali okone atu aiyu poto, liyamba angu amonga-yale peapelepia. Amongane atoto, Jisasato balana kii ondene oko akali okonena ale asia okolapona pee lalu, apesango soo loto, akali okonena ekenenga wata yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Wata alu, Jisasato ati kenga andaiyu loto, angamai minuto, epata leaipia. Pii okonena tene oko ale lumba leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ale lumba lea-kola, akali okonena ale lumbea-kola, okone angi teke balana ambuli asia tuma pitane ateane oko lumbu tepa ya-kola, balato pii kuai lo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wuane pea-kola, Jisasato wandakali tupa lamawuato, yakamato mangene nambato piyo oko wandakali mindikipi mindi lamai na-piyapape leane tekeko, utupane-mane wandakali minditupa lamai-yainipia. Lamai-yaikola, balato jia wete leane tekeko, utupane-mane balana pii okone tanga loto, wandakali kambua lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lamai-yaikola, pii okone ale yaini wandakali tupa moko wete loto, Jisasato wandakali ale tuma tupa pii ale yakale leya-kola, ale alaini. Balato wandakali pii na-lalaini tupamane pii leakale leya-kola, pii ale alaini. Balato piape pitaka kuai lo piyane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Okone angi, wandakali kambua wete pai pua teke epo amunguli peai-kola, utupane-mane tomo nolane mindi nayaepia. Naya-kola, Jisasato balana disaipolo tupa ipulupa loto, utupane lamawuato, wandakali utupa namba towa ole tepoai ataima leaipia. Utupa ulia nolane yaa napeya-ko. Wandakali yuu tepanda ato ipupiai tupa tomo nanene, andaka peakale lewando, utupane asininga ulia nono wato, lemowa lomba-pene yolaini. Nambato utupa ondo eyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wuane lea-kola, balana disaipolo tupamane bala tipa puato, wandakali napalene yuu okona atoto, akali mindimane betesa kambua wete ani tawe moto, wandakali utupa no embo yakale malupeyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wuane leai-kola, balato utupane tipa puato, yakamanga betesa aki-tupi eyape leaipia. Wuane lea-kola, utupane-mane nanimanga betesa yanasa eya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wuane leai-kola, balato wandakali tupa lamawuato, yakama yuunga pitiyapa leaipia. Peteai-kola, balato betesa yanasa tupa moto, Gote wayu pele lalu, utupane konde leaipia. Konde loto, balana disaipolo tupa mawuato, utupa neakale maiyapa lea-kola, utupane-mane betesa tupa tale puato, wandakali tupa neakale mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Balana disaipolo tupanga pisa aŋako mindilapo ya-kola, Jisasato utupane moto, Gote wayu pele lalu, konde leaipia. Konde loto, balana disaipolo tupa mawuato, utupa neakale maiyapa lea-kola, utupane-mane pisa utupane tale puato, neakale mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mayai-kola, akali angu tausene tukumindipi mindi ateaini tupamane no embo yai-kola, balana disaipolo tupamane tomo akenane yane tupa mo yomo wato, basaketa nuu andane yanasa tumbi laya yainipia. Wuane peai-kola, Jisasato wandakali tupa pulupa lo lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pulupa lalu, Jisasa balana disaipolo tupa towa sipi mindina peakaiyu lo pitiyu, Dalamanusa disitiki okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dalamanusa disitiki okona peai-kola, Patasai minditupa epoto, Jisasa towa pii yanda peainipia. Utupane-mane bala minu mandeke puato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loto, metekolo piape mindi pula leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wuane leai-kola, bala yamapane kenda wato, utupane tipa puato, anu peakale wandakali andipa ateyai tupa yakamato namba languato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loto, metekolo piape mindi pula lalainipe leaipia. Nambato pii enene mindi yakama langeyo. Goteto namba moyo ateya-kola, nambato piape piyawane tupa wandakali andipa ateyai tupa yakama andawa loto, nambato metekolo piape mindi napulu-peyawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wuane lalu, bala Patasai tupa tepa alu, pai pua teke sipi mindina peakaiyu lo pitiyu, ipa angini okona amo-yangi peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisasana disaipolo tupamane betesa embesa wato, sipi okona peakaiyu leai-kola, betesa mindiki sipi okonena yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Okone angi, Jisasato balana disaipolo tupa taimane lamawuato, Patasai tupapi, Etotepi, utupanena palawa yangalaini pauta okomane yakama mo lawa pulane. Waiwa ando atalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wuane lea-kola, balana disaipolo tupa yakama teke-teke pii lalawa puato, nanimanga betesa naeya-kola, balato wuane leya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wuane leyai nembo toto, balato utupane tipa puato, anu peakale yakama teke-teke pii lalawa puato, nanimanga betesa naeya leyaipe leaipia. Yakamato namba akali oko ateya nembo natene, tatake eyaipe. Yakamato kuai lo nembo nateyaipe. ");
INSERT INTO ipi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yakama lee tene tupamane anda napeyaipe. Yakama ale asia yene tupamane ale naeyaipe. Yakama embesa eyaipe. ");
INSERT INTO ipi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wamba nambato betesa yau tupa konde loto, akali tausene yau tupamane neakale maewa-angi, yakamato akenane yane tupa mo yomo wato, basaketa nuu andane aki-tupi tumbi laya yaipe leaipia. Wuane lea-kola, utupane-mane basaketa nuu alesa tumbi laya ema leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wuane leai-kola, balato utupane tipa puato, wamba nambato betesa yanasa tupa konde loto, akali angu tausene tukumindi tupamane neakale maewa-angi, yakamato akenane yane tupa mo yomo wato, basaketa nuu andane aki-tupi tumbi laya yaipe leaipia. Wuane lea-kola, utupane-mane basaketa nuu andane yanasa tumbi laya ema leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wuane leai-kola, balato utupane tipa puato, nambato metekolo piape okonelapo pewa oko andoto teke, yakamato namba Mesaya epolopeya leaini oko ateya nembo nateyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisasa balana disaipolo tupa towa Betesaita tano okona peai-kola, wandakali minditupa-mane akali lee koo mindi Jisasa ateanga atu aiyu epoto, nimbana kini-mane akali oko wata ape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wuane leai-kola, Jisasato akali lee koo okone kii minu atu aiyu poto, tano oko tepa alu, amonga-yale peapelepia. Poto, Jisasato akali lee koo okona leenga apesango soo loto, balana kii lapotaka-mane akali okonena lenenga wata yaepia. Wuane piyu, balato akali okone tipa puato, nimbato minditaka mindi andelepe, anda napelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wuane lea-kola, akali okomane balana pii okone yano peyoto, nambato akali minditupa andeyo tekeko, wayumane anda napeyo-kola, utupane ita gulene atoto, epoko peyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Wuane lea-kola, Jisasato balana kii lapotaka-mane akali okona lee okolapo lapone teke wata ya-kola, akali okonemane kuai lo andeaipia. Balana lee kuai lo tea-kola, pitaka taka kuai lo andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Andea-kola, Jisasato bala lamawuato, nimba tano okona peke nalene, andaka puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Okone angi, Jisasapi, balana disaipolo tupapi, utupane Sisatiya Pilipai tano andane okona mandaka tano aŋako yane tupana epoko peainipia. Asininga poto, balato utupane tipa puato, wandakali-mane namba andayo api ateya lalainipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wuane lea-kola, utupane-mane bala lamawuato, wandakali minditupa-mane nimba ipa peya-maiyane akali Jone oko atele lalaini leainipia. Minditupa-mane nimba Ilainja atele lalaini. Minditupa-mane nimba akali potopisa wamba ateaini tupana waka mindi atele lalaini leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wuane leai-kola, balato utupane lamawuato, utupane-mane wuane lalaini tekeko, yakamato namba api ateya lalainipe leaipia. Wuane lea-kola, Pitato balana pii okone yano peyoto, nimba Mesaya oko atele leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wuane lea-kola, Jisasato pii tai mindi utupane lamawuato, namba Mesaya oko ateya lo yakamato wandakali mindikipi mindi lamai na-piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Okone angi, Jisasato pii wenene mindi balana disaipolo tupa bulupane tewa lamawuato, Juta yame ando atalaini akali tupapi, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane Akalina Iwanane oko masia maulai-kola, bala tandaka kambua nape-pene guleya. Akali-mane bala peyo ome lolai-kola, ole teponena, bala malinga ika lolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wuane pulupeya lo panakame lea-kola, Pitato bala atu aiyu amonga-yale poto, bala laiya loto, nimbato wuane nalape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wuane lea-kola, Jisasa bala mopeke loto, balana disaipolo waka tupa andeaipia. Andoto, balato Pita laiya loto, nimbato Gotena nembo-tene oko wato mina napene, wuane lele leaipia. Nimbato wandakalina nembo-tene oko wato minuto, Satane gulo wuane lele-ko. Nimba nambana masianesa puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","38","Wuane lalu, balato balana disaipolo tupapi, wandakali waka amunguli peaini tupapi, utupane pitaka ipulupa loto, pii mindi utupane lamawuato, wandakali yame koo andipa ateyai tupamane Aiyane Gote angu lotu na-lalaini. Jia. Utupane-mane gote waka tupa lotu lalaini mana okomane pamuku pima epoko piyane yame gulo atoto, mana koo kambua tupa wato minu atalaini. Wuane pua ateyai oko andoto, wandakali waka minditupa-mane nambapi, nambana pii okopi, okonelapo bilipi leyama loyale yala wato, nanima Jisasana yame ata napeyama lolopeyai. Wuane lolai-kola, matili Ayiane Gotena tai-lene oko Akalina Iwanane okonga yola-kola, balana enjole epene wete tupa towa epola-angi, balato wandakali utupane nambana yame ateyai loyale yala ola-kola, wandakali utupane katulo Gote towa saka atapowa ata napulu-peyai. Jia. Wandakali mindimane yuu okona minditaka eya tupa pitaka mo yata wato teke, matili bala saka atapowa ata napeando, balana minditaka yola tupa pitaka-mane anu puato bala moyolo-peyape. Balato aki mindi mawuato, balana saka atapowa atolane oko katulo kambo molo-peke lolo-peyape. Wandakali mindi nambana yame atola-kola, namba yanda pingiyaini akali tupamane bala peyo ome lamakale lolopeyai. Wuane lolai-kola, wandakali mindi bala omolowane nembo toto, nambana yame ata napeando, Gote towa bala saka atapowa ata napulu-peya. Wuane tekeko, wandakali mindi bala Gotena pii layene epene oko bilipi loto, nambana yame ateya lo andoto, wandakali-mane bala peyo ome leaindo, bala Gote towa saka atapowa atolopeya. Tene okonena, wandakali mindimane namba polowa okona epokale nembo teando, bala tane nembo natene, kenda-pene balanga epola tupa balana ita malamanda gulo aiyu, namba watama epeakale. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wuane lalu, Jisasato pii mindi tako pua loto, nambato pii enene mindi yakama langeyo. Wandakali oo ateya tupana minditupa wamba ini oma napene atoto andolai-kola, Goteto wandakali tupa taimane ando atolanga andolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ole wataka pea-kola, Jisasato Pita, Jemesa, Jone ima utupane atu aiyu yuu wangiane kenga wete mindina iyu poto, yakama angu ateainipia. Okone angi, bala utupanena wenonga atoto, waka guleaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Balana tona peane tupa ake wete puato, tii pikoyo peaipia. Yuunga wandakali mindimane lapa-lapa mindi ake okonepene katulo gulaya aa napiyane. ");
INSERT INTO ipi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jisasa waka gulea-kola, Ilainja, Mosesa-la, okonelapo epo pana wato, Jisasa towa pii lalawa pua ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Wuane pea-kola, balana disaipolo tepo tupamane yuku-mane omeainipia. Yuku-mane omoto, aki loape tatake wato, Pitato Jisasa lamawuato, tisa, nanimato yuu okona ateyama-kola, kuai leya-ko. Nanima tepo akali tupamane anda aiyakame tepo pimakale. Mindi nimbana, mindi Mosesana, mindi Ilainjana, pingimakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wuane lea-kola, mole mindimane epoto, utupane yame peyoto, ombo ya-kola, mole okonena ato pii mindi leane okomane loto, akali oo ateya oko bala namba iwanane yamapane yene oko. Yakamato balana pii ale amai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wuane lea-kola, okone angi teke, disaipolo tepo tupamane anda amo-nena peai-kola, akali waka mindi Jisasa towa atu ata napeaipia. Jia. Bala angu ateanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jisasato balana disaipolo tepo utupane towa atu yuu wangiane oko tepa alu, puu nena loto, pii tai mindi utupane lamawuato, yakamato minditaka andalai oko wandakali mindikipi mindi lamai napene atama pulu, matili Akalina Iwanane oko malinga ika lola-angi, yakamato wandakali tupa lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wuane lea-kola, disaipolo tepo tupamane ale wato, yakama teke-teke pii lalawa puato, anu peakale balato Akalina Iwanane oko malinga ika lolopeya leyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wuane lalu, utupane-mane Jisasa tipa puato, Akalina Iwanane oko wamba ini epoto, omalu, malinga ika lolopeya yando, anu peakale loo tupana mana andene akali tupamane loto, potopesa akali Ilainja bala ini ingane yuunga peke lola-kola, matili Akalina Iwanane oko epolopeya lalainipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Wuane leai-kola, balato utupanena pii okone yano peyoto, enene, Gotena pii pepa pelene eya mindimane loto, Akalina Iwanane oko epeakale nembo toto, Ilainja bala ini ingane epoto, pitaka taka mo tika pulupeya layene eya tekeko, Ilainja bala epeane lo nambato yakama langeyo leaipia. Bala epea-kola, Gotena pii pepa pelene eya okomane layene eya pua, akali minditupa-mane balanga mana koo mina-makale nembo teaini tupa pitaka mineaini-ko. Anu peakale Gotena pii pepa pelene eya mindimane loto, wandakali-mane Akalina Iwanane oko minu koyolai-kola, bala tandaka nape-pene layene eyape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisasa, Pita, Jemesa, Jone ima utupane epoto andeai-kola, loo tupana mana andene akali tupamane Jisasana disaipolo waka tupa towa pii yanda pua ateai-kola, wandakali kambua longo waka-mane utupane ato mapu pua ateainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jisasa epea-kola, wandakali utupane-mane bala andalu, moko wete loto, bala ateanga taimane poto, nimba wayu epeleya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wuane leai-kola, balato utupane tipa puato, yakamato aki loto, utupane towa pii yanda pua ateyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wuane lea-kola, wandakali kambua wete ateaini tupana mindimane balana pii okone yano peyoto, tisa, namba iwanane okomane pii laa napeakale loto, sipitisa koo mindimane balana ambulini minu tambu leya-kola, nambato bala atu aiyu nimba atelenga epeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sipitisa koo okonemane bala minuto, mo lombeya-kola, apesango namba iwanane oko ambulininga epalane. Epeya-kola, balana nene tupa giti gete loto, tiyongo latane yalane. Nambato nimbana disaipolo tupa lamawuato, sipitisa koo oko peyo wata alapa lalo tekeko, utupane-mane katulo bala peyo wata napiyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wuane lea-kola, Jisasato wandakali tupa tipa puato, ole aki-tupinga namba lo bilipi nalene wandakali yakama towa namba atokale yape leaipia. Ole aki-tupinga nambato yakamana kenda-pene tupa awua atokale yape. Iwana okone bala atu aiyu namba ateyonga ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Utupane-mane iwana okone Jisasa ateanga atu aiyu epeai-kola, sipitisa koo okomane Jisasa andoto, iwana okone taimane mo lombea-kola, iwana okone bala peango-ngo pua ya-kola, apesango balana ambulininga epeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wuane pea-kola, Jisasato iwana okona ayiane oko tipa puato, andoko angi bulupane tewa bala wuane peape leaipia. Wuane lea-kola, ayiane okomane balana pii okone yano peyoto, wamba bulupane bala iwana aŋakonga ato, wuane peane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sipitisa koo okomane bala peyo ome loyale, ole kambuanga itanga peyo yangaka, ipanga peyo pee laka, piyane. Nimbato katulo bala moyeendo, nanima ondo wato, moyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wuane lea-kola, Jisasato bala tipa puato, anu peakale nimbato namba tee loto, nimbato katulo bala moyeendo, moyape lelepe. Wandakali mindimane namba lo bilipi leando, bala moyoyale nambato katulo pitaka taka piyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wuane lea-kola, iwana okona ayiane okomane pii taimane loto, nambato bilipi leyo tekeko, bilipi leyo nayu naleyo. Nimbato nambana bilipi oko minu tai laya wato, namba moyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wuane lea-kola, wandakali kambua taimane epo amunguli peainga andoto, Jisasato sipitisa koo oko laiya loto, sipitisa koo, nimbato iwana okona ale tuma pimaiyu, pii naleakale laya alene yako. Nambato nimba langeyo nayu leyo-ko. Nimbato iwana oko tepa alu pulu, dee lapone balanga peke lolene leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wuane lea-kola, sipitisa koo okomane kalae loto, iwana oko taimane mo malawai loto, bala tepa alu, peaipia. Pea-kola, iwana oko omene gulene ya-kola, wandakali kambua-mane bala omala ya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Utupane-mane wuane leaini tekeko, Jisasato iwana okonena kii minuto, bala mina ika lea-kola, iwana okone ika leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Matili Jisasa bala anda mindina kolandaka lea-kola, balana disaipolo tupa angu bala towa atu pituto, anu peakale nanimato katulo sipitisa koo okone peyo wata na-piyamape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wuane leai-kola, balato utupanena pii okone yano peyoto, wandakali-mane pote leyai-kola, sipitisa koo okonepene tupamane wandakali tupa tepa alu, palaini. Mangene waka mindi peyai-kola, na-palaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Okone angi, Jisasato balana disaipolo tupa angu mana lamauwakale nayuto, bala asia okona peya lo wandakali waka mindimane anda napeakale nembo teaipia. Wuane nembo toto, balana disaipolo tupa towa anda okone tepa alu, Galili disitiki okona tombenga peainipia. Asini poto, balato utupane angu mana lamawuato, akali mindimane Akalina Iwanane oko ene pitula-kola, akali minditupa-mane bala peyo ome lolai-kola, ole teponena bala malinga ika lolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wuane lea-kola, utupane-mane ale wato, balato aki nembo toto, wuane leyape lo tatake yaini tekeko, utupane-mane bala tipa puyale yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisasa balana disaipolo tupa towa Kapaneame tano okona poto, anda mindina kolandaka leainipia. Anda okonena atoto, balato utupane tipa puato, asini epalama-angi, yakamato aki loto, pii yanda pima epalaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Balato wuane leane tekeko, wamba utupane-mane nanima disaipolo ateyama tupana akali gene andane wete yene api ateyamape lo pii yanda pima epalama okona leya nembo toto, yala wato, yakama balana pii okone yano napeleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Balana pii okone yano napeleai-kola, bala pituto, balana disaipolo alesa tupa lamawuato, ipulupa leaipia. Epeai-kola, balato utupane lamawuato, akali mindimane gene andane wete yene atokale nembo teando, bala akali gene nayene gulo atoto, wandakali pitakana piape akali gulo atape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Wuane lalu, balato andopane mindi kii minu atu aiyu epoto, balana disaipolo tupana tombenenga bala towa atu ateapele-pia. Balato andopane okone ope loto, balana disaipolo tupa lamawuato, wandakali mindimane namba nembo toto, andopane okopene mindi moyando, balato namba moyola-kola teke pulupeya. Namba moyando, balato namba ati kenga atala yuunga puu leane Gote oko moyola-kola teke pulupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Okone angi, Joneto Jisasa lamawuato, tisa, nanimato andalama-kola, akali mindimane nimbana gene oko loto, sipitisa koo tupa peyo wato atala tekeko, bala nanima watama na-epalane. Tene okonena, nanimato bala lamawuato, nimbato Jisasana gene loto, sipitisa koo tupa peyo watolene lalama leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, wandakali mindimane kenda-pene mindi nanima gii napeando, balato nanima moyalane leaipia. Wuaneko, akali mindimane kenda-pene mindi nanima gii napene, nambana gene oko loto, metekolo piape mindi peando, balato namba andayo pii koo mindi wamba ini nalolo-peyako. Akali mindimane nambana gene oko loto, piape epene mindi pua ateando, yakamato jia nalene, balato wuane peakale lo ando kondalapape. ");
INSERT INTO ipi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nambato pii enene mindi yakama langeyo. Yakama Kataisana yame ateyai okonena, wandakali mindimane ipa ambuto, yakama nalapale geando, Goteto yole epene mindi wandakali okone maulupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wuane lalu, Jisasato pii mindi tako pua loto, andopane namba lo bilipi leyai tupana mindimane koo mindi peakale loto, wandakali mindimane mo piya yando, Goteto kenda-pene andane wete mindi wandakali okonenga malupeya leaipia. Andopane mindimane koo peakale loto, wandakali mindimane bala mo piya oyale pula-kola, wandakali okonemane wuane napeakale loto, akali waka mindimane ana andane wete mindi wandakali okonena mane okona andi loto, ipa solewata andane okona awua aindaka leando, wandakali okone omolo-peya. Omalu, mana koo okone mina napula-kola, kenda-pene andane wete okone balanga naepolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Goteto wandakali mindi yuu koo wetete okona awua aindaka leando, imi-mane wandakali okone no atapowa atola-kola, ita too atapowa atene mindimane bala yango atapowa atolopeya tekeko, bala oma napene, tandaka andane wetete no atapowa atolopeya. Tene okonena, nimbana kini lapotaka ateakale kondole-kola, Goteto nimba yuu koo wetete ita too atapowa atene okonena awua aindaka leando, nimba koo wetete atolopele. Nimba kini mundu atene atoto, Gotena yuu epene okona saka atapowa ateendo, kuai lolopeya-ko. Nimbana kini-mane koo pula lo mo piya yando, kini okone kando lo apiape. Kene lapotaka ateakale kondole-kola, Goteto nimba yuu koo okona awua aindaka leando, nimba koo wetete atolopele. Nimba kene mundu atene atoto, Gotena yuu epene okona atapowa ateendo, kuai lolopeya-ko. Nimbana kene-mane koo pula lo mo piya yando, kene okone kando lo apiape. Lene lapotaka teakale kondole-kola, Goteto nimba yuu koo wetete okona awua aindaka leando, koo wetete atolopele. Nimba lene mindiki tene atoto, Gotena yuu epene okona saka atapowa ateendo, kuai lolopeya-ko. Nimbana lene-mane koo pula lo mo piya yando, lene okone luku apiape. ");
INSERT INTO ipi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Juta yame-mane tomo mindi Gote opa mawua-yale atoto, Gotena wenonga koo tene mindi opa okonena nayakale nembo toto, sole minditupa tomo okonena ate loto, Gote lo opa maiyaini. Wuane pua teke, Gotena wenonga koo tene mindi wandakali tupanga nayakale nembo toto, ita tapeta gulene kenda-pene minditupa utupane pitakanga ipupe-pene. ");
INSERT INTO ipi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sole-mane tomo mo tende piya alane tekeko, sole minditupa tende napene guleando, nanimato anu puato, sole okone lapone mo tende piya olo-peyamape. Minjuni minditupa kapoyale tamualane nembo toto, wandakali-mane sole kambua minjuni okonena ate loto yata eyai-kola, minjuni okone kapoyale tamua napene, kuai lo yalane. Wuane pua teke, sole kambua yakamanga atene gulo atoto, yakamato mindi akali towa yanda napene, kuai lo atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisasa bala yuu okone tepa alu, Jutiya disitiki okona poto, ipa Jotane okona amo-yangi peaipia. Pea-kola, wandakali kambua pai pua epo amunguli peai-kola, balato wandakali tupa mana lamaiyane pua teke utupane mana lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mana lamawua atea-kola, Patasai minditupa-mane bala minu mandeke pimakale nembo toto, bala ateanga epeainipia. Utupane-mane bala tipa puato, akali mindimane balana wetene oko mee puu leando, loo Goteto yata yane okomane akali okonena mana okone yapa lo tale puato, katu lolo-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wuane leai-kola, balato utupane tipa puato, loo Mosesato yakama geane okomane aki leyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wuane lea-kola, utupane-mane balana pii okone yano peyoto, Mosesato loto, akali mindimane wetene peyo watolane pepa mindi peyoto, bala maiyu, puu leaindo, mana okone katu leane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wuane leai wete, balato utupane lamawauto, yakamato tuu puato, balana pii tanga leainga andoto, Mosesato loo okone pepa peyoto, yakamanga geane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wuane tekeko, wamba wetete Goteto pitaka taka yakale loto, wanda, akali-la, okonelapo waa peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Wuaneko, akali mindi balana angini, ayiane-la, okonelapo tepa alu, balana wetene oko towa mina mindiki lalane. Wamba okonelapo waka-waka atalapele tekeko, mina mindiki leyapi-kola, liyamba umbuaini mindiki gulalane. ");
INSERT INTO ipi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Goteto wanda, akali-la, okonelapo mina mindiki leya okone wandakali-mane okonelapo mo toko laya napipe-pene layene eya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wuane lea-kola, matili anda mindina pituto, balana disaipolo tupamane Jisasa lamawuato, pii wamba lale okona pii minditupa tako pua laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wuane leai-kola, balato utupane lamawuato, akali mindimane wetene peyo watolane pepa mindi mo mawuato, puu lalu, wanda waka mindi kee leaindo, balana wetene wambane oko kenda-pene mindi maiyu, wanda mindoko towa pamuku pula-kola pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dee, wanda mindimane akalini tepa alu poyale pepa mindi moto, akalini oko maiyu, bala akali waka mindi peando, wanda okonemane akali mindoko towa pamuku pula-kola pulupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Alu mindi Jisasato andopane tupanga kii yata yakale nembo toto, wandakali minditupa-mane andopane tupa atu aiyu bala ateanga epeaini tekeko, balana disaipolo tupamane wandakali utupane laiya loto, yakamato andopane tupa atu aiyu naepene, kondalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wuane leai-kola, Jisasato utupanena mana okone embo wato, utupane lamawuato, Goteto andopane okopene gulene wandakali tupa ando atalane leaipia. Yakamato andopane utupa minandi nalene, namba ateyonga epeakale lo ando kondalapa. ");
INSERT INTO ipi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nambato pii enene mindi yakama langeyo. Goteto utupane ando ateakale lo andopane-mane ando konda alaini pua teke, Goteto bala ando ateakale lo wandakali mindimane ando konda yaindo, Goteto bala moyo ando atolopeya. Wuane tekeko, Goteto bala ando ateakale lo wandakali mindimane ando konda nayando, Goteto bala moyo ando atalane lo wandakali okonemane anda napulu-peya. Jia wete leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wuane lalu, balato andopane tupa mindiki-mindiki ope lo miaka puato, balana kini utupanenga yata wato, Goteto nimba moyo ateakale loto, belesini maiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Matili Jisasa bala yuu waka mindina poyale asini pea-kola, akali mindi taimane epoto, Jisasa ateanga aiki leka wato, tisa epene, namba saka atapowa atokalenga, nambato anu puape lo tipa peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tipa pea-kola, Jisasato bala lamawuato, wandakali epene mindikipi mindi ata napeya leaipia. Gote bala angu epene ateya-ko. Anu peakale nimbato namba andayo, tisa epene lelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nimbato Gotena loo tupa andelene pia okoni. Nimbato wandakali peyo ome nalape. Wanda, akali-la, liyambato pamuku na-piyapape. Nimbato pake namiape. Nimbato wandakali yangone mindi kosimi loto, owato pii nalape. Nimbato owato pii loto, minditaka namiape. Nimbato nimbana angini, ayiane-la, okone-lapona pangosa atoto, okone-lapona pii lolapi tupa wato minu atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wuane lea-kola, akali okonemane bala lamawuato, tisa, wamba namba aŋakonga atoto, Gotena loo utupane pitaka wato minu atama ipulu, andipa giau lo minu teke atalawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wuane lea-kola, Jisasato bala andatawa atoto, bala towa epelewa yamapane yoto, nimbato mana epene mindiki angu mina napene atele leaipia. Nimba poto, wandakali waka tupamane nimbana minditaka eya tupa pitaka kambeakale lape. Kambolai-kola, nimbato muni mole tupa wandakali tipia tupa maipe. Wuane peendo, nimbana minditaka epene wetete tupa ati kenga yolopeya-ko. Nimba namba watama ipupe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wuane lea-kola, akali okonemane balana minditaka kambua wetete yane tupa awua tepa na-wakale nembo toto, bala mini kenda wato, wenongo yalu, Jisasa tepa alu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pea-kola, Jisasato balana disaipolo tupa anda amo-nena puato, Goteto utupane ando ateakale lo wandakali amango tupamane ando kondape-pene oko pitete alaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wuane leane oko ale wato, balana disaipolo tupamane moko wete leaini tekeko, Jisasato pii okone lolo-peke loto, iwana yame, Goteto utupane ando ateakale lo wandakali-mane ando kondape-pene oko pitete alaini. ");
INSERT INTO ipi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yia kamele mindimane yana asia titi mindina kolandaka loyale makande pipia-yale, bala pitete apia-yale tekeko, Goteto utupane moyo ando ateakale lo akali amango tupamane ando kondape-pene oko pitete wete alaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wuane lea-kola, balana disaipolo tupamane moko wetete loto, yakama teke-teke pii lalawa puato, wuane yando, api katulo saka atapowa atolo-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Wuane leai-kola, Jisasato utupane andatawa yoto, wandakali yakama tane katulo saka atapowa atamakale lo saka ataya na-olopeyai tekeko, Goteto katulo pitaka taka piyane. Tene okonena, wandakali mindimane Gotenga tungi peyo nayu bilipi leando, Goteto katulo bala saka atapowa ateakale lo ataya olopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wuane lea-kola, Pitato bala tipa puato, nanimana minditaka yalamane tupa pitaka awua tepa alu, nanimato nimba watama epeyama okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, nambato pii enene mindi yakama langeyo leaipia. Wandakali minditupa-mane Gotena pii layene epene oko nembo toto, nambana piape oko puyale utupanena anda yandopi, amene, imalini yandopi, angini, ayiane yandopi, andopane yandopi, ee yandopi, utupanena mindi tepa alaini. ");
INSERT INTO ipi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Wuane piyaini wandakali tupa yuu okona atolai-kola, matili Goteto andapi, amene, imalinipi, anginipi, andopanepi, eepi, utupane andete lo wandakali utupane pitakanga malupeya. Wandakali minditupa-mane kenda-pene andane minditupa wandakali utupane maiki pulupeyai tekeko, matili Goteto balana yame wandakali utupane saka atapowa ateakale lo ataya olopeya. ");
INSERT INTO ipi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Okone angi, wandakali andipa gene andane wetete yene ateyai utupana kambua gene nayene wetete atolopeyai. Dee, wandakali andipa gene nayene wetete ateyai tupana kambua gene andane wetete yene atolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Matili Jisasapi, balana disaipolo tupapi, wandakali waka minditupapi, utupane Jutusaleme poyale asini peainipia. Jutusaleme poloma-kola, kenda-pene minditupa yakamanga epolane nembo toto, balana disaipolo tupamane yuku wato, asini peaini tekeko, Jisasa bala yuku naene atoto, ini ingane peaipia. Bala ini ingane pea-kola, utupane-mane moko wete loto, yukuwa nembo kambua teai-kola, Jisasato wandakali waka tupa tepa alu, balana disaipolo tupa angu atu aiyu amonga-yale peaipia. Poto, kenda-pene minditupa balanga epolopeya loto, balato utupane lamawuato, ale alapa, andipa nanima Jutusaleme poyale asini peyama leaipia. Poloma-kola, akali mindimane Akalina Iwanane oko ene pituto, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupanena kininga maula-kola, utupane-mane namba kosimi loto, omeakale lalu, akali yame waka tupana kininga malupeyai. ");
INSERT INTO ipi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Maulai-kola, akali utupane-mane namba lamba loto, apesango nambanga soo lo peyalu, kunju-mane peyalu, peyo ome lolai-kola, ole teponena namba malinga ika lolo-peyawa. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jisasato wuane lea-kola, matili Sepiti iwanane Jemesa, Jone-la, okonelapo epoto, tisa, nimbato nalipa moyo, mangene mindi pula lo tee leyapa oko nimbato pipi lakae lo nembo teyapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wuane leapi-kola, balato okonelapo tipa puato, nambato liyamba moyoyale, aki mindi pipi lakae lo nembo teyapipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wuane lea-kola, okonelapo-mane bala lamawuato, matili nimba kiŋi tai wetete atole-angi, nalipana mindi nimbana kii tikasa piti lalu, mindoko nimbana kii koyasa piti lapi lakae lo nembo teyapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wuane leapi-kola, balato okonelapo lamawuato, matili mangene anu-pene tupa pulu-peyape lo liyambato nembo natene, mee nambato wuane pipia lakae lo nembo toto, tee leyapi leaipia. Minditaka mindi kapo penenga petene gulola oko nambato nolo-peyawa oko liyambato katulo nolo-peyapipe. Ipa nambato molowa oko liyambato katulo molo-peyapipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wuane lea-kola, okonelapo-mane balana pii okone yano peyoto, nalipato katulo wuane pulu-peyapa leapelepia. Wuane leapi-kola, balato okonelapo lamawuato, enene, minditaka mindi kapo penenga petene gulola oko nambato nolowa-kola, liyambatopi okone nolo-peyapi. Nambato ipa mindi molowa-kola, liyambatopi ipa okone molo-peyapi teke. ");
INSERT INTO ipi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Liyambato wuane pulu-peyapi tekeko, nambana kii tikasa yandopi, nambana kii koyasa yandopi, akali mindi bala peteakale lolane piape oko nambana jia. Toko okone-lapona namba ayiane okomane akali lapo peteakale lata yane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jemesa, Jone-la, okonelapo-mane akali gene yene atapakale leapi-kola, matili Jisasana disaipolo waka tupamane pii temane okone ale wato, disaipolo okonelapo towa yataka yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yataka yai-kola, Jisasato balana disaipolo tupa pitaka ipulupa loto, wandakali yame waka tupa ando atalane akali tupamane wandakali utupanena lipinga ateyama nembo toto, utupane taimane bosa lo ando atalaini lo yakamato nembo teyai okoni leaipia. Dee, wandakali utupane-mane yakamana pii wato mineakale loto, wandakali yame waka tupana akali kawane tupamane utupane taimane lamawuato, yakamato wua piyapa lalaini lo yakamato nembo teyai teke. ");
INSERT INTO ipi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","45","Utupane-mane wuane piyaini tekeko, yakamato mana okone wato mina na-piyapape. Jia. Akalina Iwanane epeane oko balana wandakali-mane piape pingeakale nembo toto na-epeane. Jia. Balato wandakali kambua tupa moyo, utupanena piape pimawuato, utupane kambo molo-peke loyale, omolo epeane-ko. Disaipolo yakamana mindimane akali gene yene atauwa lakae lo nembo teando, bala yakamana piape akali gulo atape-pene. Yakamana mindimane akali gene andane wetete yene atauwa lakae lo nembo teando, bala yole mia napene, wandakali tupa pitaka mee moyo, utupanena piape tupa pimawua atape-pene. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisasa balana disaipolo tupa towa Jetiko tano okona peainipia. Matili utupane-mane wandakali kambua towa atu Jetiko tepa alu peai-kola, Timiasa iwanane Batimiasa bala asia ayatenenga peteaipia. Bala akali lee koo mindi pituto, wandakali tupa tee loto, muni giyapa laka piki pua piti-yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wandakali mindimane Nasatesa tane Jisasa oko epeya lea-kola, Batimiasato ale wato, pii taimane loto, Dapiti yame Jisasa nimbato namba ondo aa laka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wuane laka pea-kola, wandakali kambua-mane bala laiya loto, pii nalene, kondaa leaini tekeko, balato ole kambuanga pii taimane wete laka puato, Dapiti yame akali nimbato namba ondo aa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wuane laka pea-kola, Jisasa bala asini puu apo naene, ongane atoto, akali lee koo okone bala namba ateyonga epeakale lalapa leaipia. Wuane lea-kola, wandakali tupamane akali lee koo oko lamawuato, balato nimba ee leya-ko. Mini epene palu, ika laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wuane leai-kola, balana sakesa piyane oko yoko tepa alu, bala taimane ika lalu, Jisasa ateanga epeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Epea-kola, Jisasato bala tipa puato, nambato nimba moyo, anu pipi lakae lo nembo telepe leaipia. Wuane lea-kola, akali lee koo okomane bala lamawuato, tisa, nimbato nambana lene tee laya api lakae lo nembo teyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Wuane lea-kola, Jisasato bala lamawuato, nimbato namba lo bilipi lele okonena, nambato nimbana lee mo tee laya eyo-ko. Nimba puu leaipia. Wuane lea-kola, okone angi teke, akali okone lee toto, Jisasa watama peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisasapi, balana disaipolo tupapi, utupane yakama Jutusaleme poyale Olipi wangiane okona pulu, Betani tano aŋako okona peakaiyu leainipia. Betepasi tano aŋako oko mandaka ya-kola, Jisasato balana disaipolo lapo akali wamba ingane pulupa loto, wua leaipia: Liyambato tano aŋako amo eya okona peakaiyu loto andolapi-kola, yia dongi talua wandakali mindi masianenga napetene mindi andi latane atolanga liyambato kapoyale andolo-peyapi. Andalu, liyambato okone tita loto, atu ipulupape. ");
INSERT INTO ipi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wandakali mindimane liyamba tipa puato, anu peakale liyambato dongi oko tita leyapipe leaindo, liyambato bala lamawuato, Akali Andane okomane dongi mindina masianenga pituto, mangene mindi pukale nembo teya tekeko, nanimanga dongi mindi ata napeya-kola, balato dongi oko molo pulupa lala-kola, nalipato dongi oko tita lo meyapa. Balato mangene okone pikoyo pula-angi, balato nalipa languato, dongi oko nimba atelenga atu kapoyale peke lalapa lolopeya lo lamai-yapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wuane lea-kola, okonelapo-mane tano okonena asininga poto andeapi-kola, dongi talua mindi anda mindina asia lomba okona mandaka gulo andi latane ateanga andoto, tita leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tita leapi-kola, wandakali ongane ateaini minditupa-mane okonelapo tipa puato, anu peakale liyambato dongi talua okone tita leyapipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wuane leai-kola, okonelapo-mane Jisasato lalapape leane pua teke lamaiyapi-kola, wandakali utupane-mane atu yalua-ko. Atu pulupa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wuane leai-kola, akali okonelapo-mane dongi okone Jisasa ateanga atu peke loto, liyambana tona luu kenga peapili okolapo yokoto, dongi talua okonena masianenga yata yapi-kola, Jisasa bala dongi okonena masianenga pitiyu, Jutusaleme poyale, asini peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Asini pea-kola, wandakali kambua-mane yakamana tona luu kenga peaini tupa yokoto, bala poyale peane asininga panda pima peainipia. Dee, wandakali minditupa-mane wayu epeleya loto, ita kembone aŋako yokone kambua atene tupa yando awua epoto, asininga panda pua yatama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bala poyale peane asini okona ingane peaini wandakali tupapi, bala masianenga watama epeaini wandakali tupapi, utupane-mane pii taimane lama poto, Akali Andane Goteto akali oko epeakale leya-kola, bala epeya leainipia. Goteto bala moyo ateakale. Balana gene oko laiyu lalapa. ");
INSERT INTO ipi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wamba nanimana yumbane Dapitito nanimana yame oko moyo ando ateane pua teke, andipa Jisasato nanima moyo ando atolopeya. Gote ati kenga wetete ateya okomane bala moyo ateakale. Balana gene oko laiyu lalapa lama peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wuane lama poto, utupane yakama Jisasa towa atu Jutusaleme peakaiyu leainipia. Peakaiyu lalu, bala Juta yamena lotu anda andane okona ende anda-pangosa kolandaka loto, minditaka yane tupa pitaka andamo-nena pua andeane tekeko, nai andaka poyale pea-kola, Jisasapi, balana disaipolo alesa tupapi, utupane Jutusaleme tepa alu, Betani tano okona peke leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Anate-lene Jisasapi, balana disaipolo tupapi, utupane Betani tano oko tepa alu, asininga peainipia. Poto, Jisasa bala ulia nono yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nono wato, balato ita piki mindi amonga-yale ateanga andeapia. Ita okonena yokone kambua ateanga andoto, dini liyape lo andolo peaipia. Ita piki tupana dini lia napiyane oto okone angi, balato ita okone andolo pea-kola, yokone angu ateanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dini nalianga andoto, balato ita piki okone lamawuato, matili-matilipi, nimbanga dini lia napule-kola, wandakali mindikipi mindimane nimbana dini tupa nanolo-peyai. Jia wete lea-kola, balana disaipolo tupamane ale yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Matili Jisasapi, balana disaipolo tupapi, utupane Jutusaleme peakaiyu leainipia. Peakaiyu lalu, Jisasa bala lotu anda andane okona ende anda-pangosa kolandaka loto, andea-kola, wandakali minditupa-mane sipisipi tupapi, bulamakao tupapi, eka uya tupapi, okonetaka tupa yatawa, makesa yo ateainga andeaipia. Makesa yo ateai-kola, balato wandakali utupanepi, wandakali minditaka kambo ateaini tupapi, utupane pitaka lotu anda okona ende kamaka peakale lo peyo wateaipia. Peyo watalu, balato muni lawa pua peteaini akali tupana tepolo toko tupapi, uya makesa yo ateaini wandakali tupana pitiyaini toko tupapi, utupane minu kulembo leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wuane piyu, lotu anda andane okona ende anda-pango okona wandakali-mane minditaka awua epo peakale lo balato ando konda nayaepia. Jia. ");
INSERT INTO ipi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Balato utupane mana lamawuato, Gotena pii pepa pelene eya mindimane loto, nambana anda oko wandakali yame pitaka-mane pote lo pitulane anda mindi atolopeya layene eya tekeko, yakamato nambana anda oko pake nene epo pitiyaini anda mindi gulaya eyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wuane lea-kola, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane bala minu koyolane asia mindi aiya peaini tekeko, wandakali waka tupa pitaka-mane balana pii ale wato, balato kuai lo wete leya nembo teainipia. Tene okonena, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane Jisasa ando yuku wato, bala peyo ome lamakale nembo teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Matili nai andaka pea-kola, Jisasapi, balana disaipolo tupapi, utupane Jutusaleme tepa alu, peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Anate-lene upanda wete Jisasapi, balana disaipolo tupapi, utupane-mane Jutusaleme poyale asia poto andeai-kola, ita piki okona yokonepi, pinipi, pitaka kuu loto, kapu teanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tuni Jisasato ita okone koyakale lapia oko nembo tolo-peke loto, Pitato bala lamawuato, tisa, tuni nimbato ita piki oko dini lia napeakale lapi-ko. Andipa kuu loto, kapu teya oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, yakamato Gote lo bilipi lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nambato pii enene mindi yakama langeyo. Wandakali minditupa-mane nembo lapo pali napene, utupane-mane pote lolai pua teke Goteto pulupeya nembo tatawa atalaini. Wandakali utupanena mindimane yuu wangiane oo peleya oko lamawuato, nimba lopalu, ipa solewata andane okona peaka nena laa leaindo, Goteto yuu wangiane oko lopoto, ipa sole wata andane okona aindaka lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yakamatopi pote lolai pua, Goteto pulupeya nembo toto, Gote nimbato mangene minditupa pula lo pote laka peaindo, balato mangene utupane pitaka piki pulupeya lo nambato yakama langeyo-ko. Yakamato pote lolai pua teke balato pulupeya nembo tatawa atalapape. ");
INSERT INTO ipi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Yakamato pote lolai-angi, nembo tolo-peke loto, wamba wandakali mindimane mana koo mindi yakamanga minalae yando, yakamana Ayiane Gote ati kenga ateya okomane yakama tanena koo tupa apia-geakale nembo toto, yakamato wandakali okonena koo okone apia-miayapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisasa balana disaipolo tupa towa pai pua teke Jutusaleme peakaiyu leainipia. Peakaiyu loto, bala lotu anda andane okona ende anda-pangosa epo pea-kola, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, Juta yame ando atalaini akali waka tupapi, utupane bala ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Epoto, utupane-mane bala tipa puato, nimbato apina pii wato minuto, wandakali utupa mana lamawua atelepe. Apito nimba piape utupa pipe langipia-kola, nimbato piape utupa pua atelepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wuane leai-kola, balato utupane lamawuato, nambato pii mindiki yakama tipa peyo leaipia. Yakamato nambana pii okone kuai lo yano peleaindo, nambato yakama languato, piape utupane pipe lo namba langeane akali okona gene oko yakama langukale. ");
INSERT INTO ipi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wamba Goteto Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wandakali tupa ipa peya-maiyaepiape. Pee, wandakali-mane bala lamawuato, nimbato wandakali tupa ipa peya-maipe leai-kola, balato wuane peaipiape. Yakamato namba langiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","32","Wandakali tupa pitaka-mane Jone bala potopesa akali enene mindi ateane lo nemboto minu ateai-kola, Juta yamena akali kawane tupa yakama yuku wato, yakama teke-teke pii lalawa peainipia. Nanimato Jisasana pii okone yano peyoto, wandakali-mane Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wuane peane lemando, wandakali tupamane nanima ana-mane peyo ome lolopeyai. Nanimato balana pii okone yano peyoto, Goteto Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wuane peane lemando, balato nanima tipa puato, wuane yando, anu peakale yakamato Jonena pii oko bilipi naleaipe lolopeya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wuane lalu, utupane-mane Jisasana pii okone yano peyoto, nanima nembo nateyama leainipia. Wuane leai-kola, balato utupane lamawuato, wuane yando, piape utupa pipe lo langeane akali okona gene oko nambato yakama langi napukale teke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wuane lalu, Jisasato pii kokoli mindi Juta yamena akali kawane tupa lamawuato, akali mindimane getepe ee mindi yandoto, ende pua wata aindaka leaipia. Wuane piyu, matili dini tupana ipane penge lo mokale nembo toto, balato ana andane mindi kua peaipia. Kua piyu, wandakali-mane epoto, getepe dini minditupa pake yolaini nembo toto, akali mindimane anda luu kenga mindina atoto, ee okone ando ateakale loto, balato anda luu mindi pita yaepia. Piyu, balato akali minditupa lamawuato, yakamato nambana ee oko ando ata-giyapape. Matili dini lula-angi, yakamato minditupa yoto, namba giyu, akenane yolane tupa yakama tane mialapale leaipia. Wuane lalu, bala yuu tepanda mindina atama peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pea-kola, matili getepe dini mandulane oto oko epea-angi, balana ee okone ando ateaini akali tupamane getepe dini minditupa yoo geakale nembo toto, ee anduane okomane balana piape akali mindi lamawuato, nimbato getepe dini minditupa molo puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wuane lea-kola, piape akali okonemane dini minditupa molo peane tekeko, ee okone ando ateaini akali tupamane dini minditupa yoo mai napene, bala minu peyalu, mee peke leakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Peke lea-kola, ee anduane okomane piape akali waka mindi lamawuato, dini minditupa molo puu lea-kola, ee okone ando ateaini akali tupamane balana kawane peyo yangi puato, mana koo yala-pene minditupa balanga mineaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wuane peai-kola, ee anduane okomane piape akali waka mindi teke lamawuato, dini minditupa molo puu lea-kola, ee okone ando ateaini akali tupamane piape akali okone peyo ome leainipia. Wuane peai-kola, ee anduane okomane piape akali mindiki-mindiki lo kambua peakale laka peane tekeko, ee okone ando ateaini akali tupamane minditupa minu peyalu, minditupa peyo ome leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wuane peai-kola, matili akali mindiki angu ee anduane oko towa ateapele-pia. Akali okone balana iwanane yamapane yene oko. Bala atea-kola, ee anduane okomane loto, nambana ee okone ando ateyai akali tupamane namba iwanane okona pii ale wato, dini minditupa yoo malupeyai leaipia. Wuane loto, koyonga bala peakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Balana iwanane okonemane dini minditupa molo peane tekeko, ee okone ando ateaini akali tupa yakama teke-teke pii lalawa puato, akali epeya okomane bala ayiane okona minditaka eya tupa pitaka paluni molopeya-ko. Nanimato bala peyo ome loloma-kola, ee oko nanimana yolopeya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wuane lalu, utupane-mane bala minuto, peyo ome lalu, bala awua poto, ee okonena takita apeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Utupane-mane wuane peai-kola, ee anduane okonemane utupane towa anu pulu-peyape. Bala epoto, balana ee okone ando ateaini akali utupane peyo ome lalu, akali waka minditupa-mane balana getepe ee oko ando ateakale lo malupeya. ");
INSERT INTO ipi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Gotena pii pepa pelene eya mindimane loto, anda piyaini akali tupamane ita posa mindi andoto, oko koo ya loto, mo apeaini oko Goteto moto, anda pingina oko ate laya yane. Nanimato andeyama-kola, Gotena mana okone kuai-lene wete eya andeyama layene eya. Yakamato Gotena pii okone wamba alu mindikipi mindi dii lo anda napeaipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wuane lea-kola, Juta yamena akali kawane tupamane ale wato, balato nanima andayo pii kokoli okone leya nembo teainipia. Tene okonena, utupane-mane bala andi laima lakae lo nembo teaini tekeko, nanimato bala andi lemando, wandakali kambua ateyai tupamane kenda-pene mindi nanima gulupeyai nembo teainipia. Wuane nembo toto, Juta yamena akali kawane tupamane bala andi loyale yuku wato, bala tepa alu, peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Matili Juta yamena akali kawane tupamane pii lalawa puato, nanimato langa-langa puato, pii mindi Jisasanga tipa pimakale. Tipa puluma-kola, balato nanimana pii okone yano peyoto, Juta yame wandakali nanimato Lomo tane gapomane akali kawane Sisa oko takisa muni mai napipe-pene lola-kola, bala tanena pii lolane okomane teke nanimato bala kosimi lamakale leainipia. Wuane loto, utupane-mane kiŋi Etote yame akali tupapi, Patasai tupapi, utupanena minditupa Jisasa ateanga peakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Akali utupane epoto, Jisasa lamawuato, tisa, wandakali mindi bala gene yene yandopi, gene nayene yandopi, okone tene mindi ata napeya nembo toto, nimbato pii enene oko angu lalene. Nanimato wua pipiai lakae lo Goteto nembo talane tupa nimbato mana kuai lo langilini nembo teyama. Wuane nembo toto, andipa nanimato nimba tipa puato, Gotena loo okomane aki leyape leyama leainipia. Juta yame wandakali nanimato Lomo tane gapomane akali kawane Sisa oko takisa muni maipe-penepe, mai napipe-penepe. Mana andoko tika-penepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Utupane-mane langa-langa puato, pii okone tipa peyai nembo toto, Jisasato utupane tipa puato, anu peakale yakamato namba minu mandeke peyaipe. Nambato muni ondene mindi andokalenga, mindi awua ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Muni ondene mindi awua epeai-kola, balato utupane tipa puato, apina lee-inga waa pitane okola, gene peyatane okola, okonelapo muni okona ateyape leaipia. Wuane lea-kola, utupane-mane balana pii okone yano peyoto, Lomo tane gapomane akali kawane Sisa okona lee-inga waa pitane okola, gene peyatane okola, okonelapo muni okona eya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wuane leai-kola, balato utupane lamawuato, wuane yando, yakamato Sisana minditaka yolai tupa bala maiyu, Gotena minditaka yolai tupa Gote maiyapape leaipia. Wuane lea-kola, utupane-mane balana pii okone ale wato, moko loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","20","Okone angi, Satusi minditupa Jisasa ateanga epeainipia. Satusi yame-mane wandakali omene tupa katulo malinga ika nalolo-peyai lalainipia. Utupane-mane bala lamawuato, tisa, amene yanasa ateai-kola, amene bulupane okomane wanda mindi kee lalu, andopane mandi napene omeane leainipia. Wamba Mosesato nanimana pepa mindi peyoto, mana mindi yata wato, akali mindimane wanda mindi kee loto, andopane mandi napene omeando, balana amene mindimane wanda yalo oko kee loto, amene omeane okonena andopane mindi mandi maiyakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wamba Mosesato wuane leane oko nembo toto, akali omeane okonena amene okomane wanda yalo okone kee leane tekeko, balatopi andopane mindi mandi napene teke omeaipia. Omea-kola, amene tepone okomane wuane teke peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Amene yanasa utupane pitaka-mane wuane teke pima pulu, wanda mindiki okone teke kee lalu, andopane mindi mandi napene oma yiake leainipia. Matili wanda yalo okone balapi omeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Amene yanasa utupane pitaka-mane wanda mindiki okone teke kee leai-ko. Matili wandakali omene tupa malinga ika lolai-angi, wanda okone bala amene yanasa utupane andokona wetene pitulu-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, yakamato Gotena pii pepa pelene eya okola, balana tai-lene okola, okonelapo nembo natene, kopeta nembo toto, namba tipa peyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Matili wandakali omene tupa malinga ika lolai-angi, wanda-mane akali napolo-peyai. Akali-mane wanda kee nalolo-peyai teke. Jia. Utupane ati kenga enjole tupa atalaini pua teke atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","Gote bala wandakali omene tupana Gote jia. Bala wandakali saka atene tupana Gote ateya. Tene okonena, Apatakame, Aisake, Jekopo ima wamba omeai-kola teke, matili ita saka aŋako mindi ita lungu-mane teane okone angi, Goteto Mosesa lamawuato, namba Apatakame, Aisake, Jekopo ima utupanena Gote ateyo leaipia. Mosesato Gotena pii okone pepa pelea-kola, yakamato pii okone wamba alu mindikipi mindi dii lo anda napeaipe. Akali tepo utupane saka ata napeai-yale, Goteto namba utupanena Gote ateyo nalene, namba akali utupanena Gote atewa lea-yaleko. Goteto bala akali utupanena Gote ateyo leane okomane wandakali omene tupa malinga ika lalaini lo andawa leya. Tene okonena, yakamato wandakali omene tupa malinga ika nalolo-peyai lalaini oko kopeta wete lalaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Satusi utupane-mane Jisasa towa pii yanda pua ateai-kola, loo tupana mana andene akali mindi epoto, ale yaepia. Jisasato Satusi utupanena pii tika pua yano pelea-kola, loo tupana mana andene akali okonemane bala tipa puato, Gotena loo tupana andoko-mane waka tupa pitaka sia minuto, lipinga wetete eyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wuane lea-kola, Jisasato balana pii okone yano peyoto, Gotena loo bulupane okomane Isatale tane wandakali yakamato ale alapape leya leaipia. Akali Andane oko bala angu nanimana Gote enene oko ateya. ");
INSERT INTO ipi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nimbana Akali Andane Gote okone towa wayumane wetete epelewa yamapane yoto, nimbana yamapanepi, tandinipi, nembo-tenepi, tai-lenepi, utupane pitaka bala angu mawua atape leya. ");
INSERT INTO ipi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gotena loo lapone okomane loto, nimbato nimba tane epelewa yamapane yo atalene wuane pua teke, nimbana wandakali yangone tupa towa epelewa yamapane yo atape leya. Balana loo eya tupa pitakana waka mindimane loo okonelapo sia minuto, lipinga naeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wuane lea-kola, loo tupana mana andene akali okomane bala lamawuato, tisa, nimbato kuai lo lele leaipia. Enene, nanimana Akali Andane Gote oko bala angu Gote enene oko ateya. Gote waka mindi ata napeya. ");
INSERT INTO ipi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nanimato bala towa wayumane wetete epelewa yamapane yoto, nanimana yamapanepi, nembo-tenepi, tai-lenepi, utupane pitaka bala mawua atoto, nanima tane epelewa yamapane yo atalamane pua teke, nanimana wandakali yangone tupa towa epelewa yamapane yo atape-pene. Gote wayu pele lo sipisipi maputane yangalamane mana tupapi, Gote wayu pele lo waka minditaka maiyamane mana tupapi, mana okonepene tupa pitaka napinga-yale eyai-kola, Gotepi, wandakalipi, utupane towa epelewa yamapane yo atalamane mana oko lipinga wetete eya. Loo tupana mana andene akali okomane wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wuane lea-kola, akali okonemane pii okone kuai lo leanga andoto, Jisasato bala lamawuato, Goteto nimba moyo ando ateakale lo nimbato ando konda oyale pele oko nambato andeyo leaipia. Jisasato akali utupane pitakana pii kuai lo yano pelea-kola, wandakali pitaka-mane pii waka mindi balanga tipa puyale yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisasa bala lotu anda andane okona ende anda-pangosa atoto, pii mana lamawuato, anu peakale loo tupana mana andene akali tupamane Mesaya oko bala kiŋi Dapitina mandiyene oko ateya lalainipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wamba Oli Sipitisa okomane Dapitina nembo-tene mina ika laya ya-kola, balato pii mindi leaipia. Loto, Akali Andane Gote okomane nambana Akali Andane Mesaya oko lamawuato, matili nambato nimba towa yanda pingulaini wandakali tupa nimbana kee pangosa peteakale lokalenga, nimba nambana kii tikasa-tole pituto, maliyo atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dapitito Mesaya oko andayo, bala nambana Akali Andane ateya leaipia-ko. Anu pua, Mesaya oko bala Dapiti yamena mandiyene ateyape. Jisasato wuane lea-kola, wandakali kambua wete amunguli pua ateaini tupamane balana pii okone ale wato, epele yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","40","Jisasato wandakali tupa mana lamawuato, loo tupana mana andene akali tupamane tona epene kii kee puyoko lene tupa piyu, epoko puyale epele wete alaini leaipia. Wandakali waka tupamane utupane andoto, akali andane, nimba ani pelepe lapiai lakae lo nembo toto, loo tupana mana andene akali tupa wandakali kambua amunguli piyaini ama tupana palaini. Utupane yakama Juta yamena lotu anda tupana poto, toko bulupane tupana pitima lakae lo nembo talaini. Dee, wandakali kambua-mane tomo andane mindi no peteyai-angipi, utupane yakama akali kawane pitiyaini toko tupana pitima lakae lo nembo talaini. Wandakali waka tupamane utupanena mana utupane andoto, yakama akali epene ateyai nembo teakale loto, akali utupane-mane pote luu tupa lalaini tekeko, utupane-mane wanda yalo tupa andakasa wato, utupanena anda tupa mee mialaini. Tene okonena, matili Goteto wandakali tupa kosimi lola-angi, balato akali utupanenga kenda-pene andane wete mindi yata olopeya-ko. Yakamato loo tupana mana andene akali utupanena mana koo tupa wato minulaini. Tika ando atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wandakali kambua lotu anda andane okona ipuku puato, Gote wayu pele lo muni aŋalapo minditupa aindaka laka peai-kola, Jisasa bala ongane mandaka anda peyo peteaipia. Anda peyo atea-kola, akali amango kambua-mane muni kambua teke aindaka leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Utupane-mane wuane peaini tekeko, Jisasato andea-kola, wanda yalo tipia wete mindi epoto, muni aŋako wete one-pene lapo angu aindaka leanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jisasato okone andoto, balana disaipolo tupa ipulupa loto, utupane lamawuato, nambato pii enene mindi yakama langeyo leaipia. Akali amango tupa pitaka-mane muni kambua wete yakama tanenga yakale loto, minditupa angu aindaka lalai tekeko, wanda yalo okonga bala tane tomo kambo nolane muni mindi nayala-kola teke, muni aŋako one-pene lapo angu balanga yapiane okonelapo lapotaka aindaka lala. Wuane piya okomane balato wandakali waka tupa pitaka sia minuto, muni kambua wetete aindaka lala. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisasa bala lotu anda andane okona ende kamaka pulu, mindisa poyale pea-kola, balana disaipolo tupana mindimane bala lamawuato, tisa, akali minditupa-mane ana andane wete tupa moto, anda epene wete utupa peaini oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wuane lea-kola, Jisasato bala lamawuato, andipa nimbato anda andane wete utupa andele tekeko, matili akali minditupa-mane anda utupanena ana mindikipi mindi balana ana yangone mindi tokonga yakale lo ando konda napulu-peyai. Jia Wete. Utupane-mane ana utupa pitaka keao loto, yuunga tepa ayiake laya olopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Matili Jisasa bala lotu anda andane oko tepa alu, Olipi wangiane okona iyu poto petea-kola, Pita, Jemesa, Jone, Endutu ima utupane angu bala peteanga peainipia. Poto, utupane-mane bala tipa puato, andoko angi akali minditupa-mane lotu anda andane oko minu koyolai-kola, mangene waka minditupa pulu-peyaipe leainipia. Nanimato mangene anu-pene mindi wamba ini bulupane andoto, andipa mangene waka tupa pitaka puyale peya lo andolo-peyamape. Nimbato nanima langi leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Wuane leai-kola, balato utupane lamawuato, akali kambua yale-yale ipuku puato, namba Mesaya oko epeyo loto, wandakali kambua minakasa olopeyai-ko. Wandakali mindimane Mesaya oko namba epeyo loto, yakama minakasa olaini. Waiwa ando atalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","Matili wandakali yame minditupa-mane wandakali yame waka minditupa yanda pimaulai-kola, tili-tula lo atola tupa yakamato ale olopeyai. Kanjiti mindina tane wandakali tupamane kanjiti waka mindina tane tupa yanda andane pimawua ateyai lene pii popone oko yakamato ale olopeyai teke. Wandakali-mane mangene utupane wamba ini pulupeyai tekeko, okone angi teke yuu oko koyo napulu-peyako. Wandakali-mane yanda pua atolai-angi, yakamato ale wato, andipa yuu oko koyo peya nembo toto, yakama yuku olaini. Jia. Yuu minditupana yuu yundukumi tupa minulu-peya. Yuu waka minditupana ulia nono andane tupa yolopeya. Kenda-pene utupane pitaka wanda-mane andopane manduyale peya-kola, wamba ini masia peyalane okonepene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","10","Akali minditupa-mane wamba ini poto, Gotena pii layene epene oko wandakali yame palu peya tupa pitaka lamaipe-pene guleya tekeko, yakama nambana yame ateyai okonena, Juta yame-mane yakama andi lo awua polopeyai. Utupane-mane yakamana kanjole tupana wenonga yakama kosimi loto, yakamana lotu anda tupana atalapa loto, yakama kunju-mane peyolo-peyai. Utupane-mane wuane pulaini. Waiwa ando atalapape. Yakamato nambana pii layene epene oko gapomane akali kawane tupapi, kiŋipi, utupanenga lamai-yapale nembo toto, alu minditupa Goteto ando konda ola-kola, wandakali minditupa-mane yakama andi lo awua poto, gapomane akali kawane utupanena wenonga yakama kosimi lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wandakali tupamane yakama andi lo awua poto, yakama kosimi loyale pulai-angi, yakamato aki lamakalepe lo nembo kambua tolaini. Jia. Yakama tane wua lamakale nembo toto, pii nalolo-peyai. Jia. Oli Sipitisa okomane yakamana nembo-tene tupa mina ika loto, wua lalapa lola-kola, yakamato pii lolo-peyaiko. Wandakali utupane-mane yakama kosimi lolai-angi, Oli Sipitisa okomane pii yakama langula tupa lalapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Okone angi, akali mindi nambana yame atola-kola, balana amene okomane bala kosimi loto, gapomane okomane bala peyo ome leakale lo malupeya. Andopane mindi nambana yame atola-kola, balana ayiane okomane andopane okone kosimi loto, wuane teke pulupeya. Andopane minditupana angini, ayiane-la, okonelapo nambana yame atolapi-kola, liyambana andopane utupane-mane okonelapo yanda pimawua, kosimi loto, gapomane okomane okonelapo peyo ome leakale lolopeyai teke. ");
INSERT INTO ipi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yakama nambana yame atolai oko andoto, wandakali kambua-mane yakama ando yamapane koo wete palu atolopeyai tekeko, wandakali mindimane namba awua tepa naene, kenda-pene epola tupa awua atoto, bala omolane oto okona giau leando, matili bala saka atapowa atolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pepa oko ando dii lolai wandakali yakamato pii nambato andipa pepa peleyo oko wayumane nembo talapape. Wamba Jisasato pii mindi tako pua loto, wandakali yame waka tupamane owato gote mindi waa puato, Gotena lotu anda andane okona ate lolopeyai leaipia. Wuane napipe-pene tekeko, matili utupane-mane wuane pulupeyai. Goteto andola-kola, balana wenonga owato gote okonemane balana lotu anda epene wete okone mo kalato ataya ola-kola pulupeya. Yakamato andolai-kola, minditaka koo wetete okone lotu anda okona atolanga andolai-angi, Jutiya disitiki okona atolaini wandakali tupa yuu wangiane tupana palaka pupe-pene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Palaka pupe-pene gulola-angi, wandakali mindi balana anda takita okona ateando, balana minditaka andaka yolane tupa mokale nembo toto, anda-pangosa kolandaka nalene, mee palaka pupe-pene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dee, wandakali mindi bala eenga ateando, balana tona kenga piyane oko molo-peke nalene, mee palaka pupe-pene gulolo-peya teke. ");
INSERT INTO ipi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Okone angi, wanda andopane ininga piti-pata pitulai tupapi, wanda andopane andu no atene pitulai tupapi, utupane-mane palaka pupe-pene pitete olai-kola, ondo wete ape-pene gulolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Upa wete puato, pipiya peleando, yakama palaka pupe-pene pitete olopeyai-ko. Pipiya peyola-kola, kenda-pene okone yakamanga epolane lo loma yo atalapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wamba wetete Goteto yuu ati-la, okonelapo yakale leane okone angi ato tewa, kenda-pene waka-waka kambua yama ipulu, andipa ateyama oto okona giau leya tekeko, kenda-pene epola okonemane utupane pitaka sia minu andane mindi epolopeya. Kenda-pene andane wetete okonepene mindi matili-matilipi lapone naepolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Akali Andane Goteto kenda-pene utupane ee ana kambua tupana epeakale lo ando konda yando, wandakali pitaka omolo-peyai tekeko, balana wandakali ateakale lata yane tupa pitaka oma yiake lolaini nembo toto, balato kenda-pene utupane ee ana aŋalapo angu epeakale lo ando kondolo-peya. ");
INSERT INTO ipi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Matili owato Mesayapi, owato potopesa akalipi, utupanena minditupa-mane wandakali tupa minakasa amakale nembo toto, mindiki-mindiki lo yale-yale ipuku pulupeyai. Epoto, namba Mesaya oko epeyo leandopi, namba potopesa akali enene mindi epeyo leandopi, okone-lapona mindi epeyo lo andawa loyale, utupane-mane metekolo piape minditupa pulupeyai. Wuane puato, utupane-mane katulo Gotena wandakali ateakale lata yane tupa minakasa olane asini mindi yando, utupane-mane wuane pulu-peyaiko. Wandakali mindimane yakama languato, Mesaya oko bala onga ateya oko andolo ipulupa leandopi, bala amokusa ateya oko andolo pulupa leandopi, akali okonemane enene leya lo yakamato nembo na-talapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Matili wandakali minditupa-mane wuane pulupeya lo nambato yakama wamba bulupane langeyo-ko. Utupane-mane yakama minakasa olaini. Waiwa ando atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Wuane lalu, Jisasato pii mindi tako pua loto, kenda-pene andane utupane koyo pula-angi, Goteto minditaka tai ati kenga okona ateya tupa mo ema-ema piya ola-kola, nai, ana-la, okolapo lapotaka undupi lalu, atinga kaiyanda ateyai tupa yuunga ondo tepa aka pulupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Okone angi, wandakali-mane andolai-kola, Akalina Iwanane oko mole tupana tokonga atoto, balana tai-lene andane okola, tii-pene andane okola, okonelapo towa atu epolanga andolopeyai. ");
INSERT INTO ipi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Epoto, balato balana enjole tupa lamawuato, yakamato nambana wandakali ateakale lata yane tupa lamolo pulupa lola-kola, utupane-mane yuu yoo peya tupa pitakana poto, balana wandakali utupane lamo atu epolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wuane lalu, Jisasato pii kokoli mindi loto, yakamato ita piki tupa andoto, mana mialapape leaipia. Ita piki tupana kembonenga ipane epo peteya-kola, yokone wenene tupa kome piyane. Yakamato yokone utupane andoto, panyu puyale peya lo andalaini. ");
INSERT INTO ipi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wuane pua teke, matili mangene minditupa wamba ini pulupeya leyo tupa pula-angi, yakamato utupane pitaka andoto, Akalina Iwanane oko bala mandaka epoto, asia lombanga atalua nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nambato pii enene mindi yakama langeyo. Wandakali yame andipa ateyai tupa oma yiake nalolai-kola, mangene utupane pitaka pulupeya. ");
INSERT INTO ipi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Matili yuu ati-la, okonelapo alu pulupeya tekeko, matili-matilipi nambana pii oko alu napulu-peya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wuane lalu, Jisasato pii mindi tako pua loto, mangene minditupa pulupeya leyo tupa oto andokona pulu-peyape, taeme andokona pulu-peyape lo, wandakali mindikipi mindimane nembo nateya leaipia. Enjole ati kenga ateyai tupapi, Gote iwanane nambapi, nanimato nembo nateyama teke. Jia. Ayiane Gote balato angu nembo teya. ");
INSERT INTO ipi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Goteto mangene utupane andoko angi pulu-peyape lo yakamato nembo nateyai-ko. Yakamato lee too ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Anda anduane mindimane yuu waka mindina poyale atoto, balana piape tale puato, balana piape akali tupa mindiki-mindiki lo lamawuato, nimbato piape oko ando atape lo lamaiki peaipia. Wuane puato, balato balana anda asia lomba ando atalane akali oko lamawuato, nimbato nambana anda asia lomba oko pai lo ando atape lalu peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Pea-kola, bala andoko angi peke lolo-peyape lo, balana piape akali tupamane nembo nateainipia. Wuane pua teke, anda anduane okonemane balana piape tale puato, minditupa yakama mindiki-mindiki lo giyane. Matili bala peke lolopeya tekeko, nai andaka pola-kola yandopi, utulu tombe yandopi, muna pula-kola yandopi, upanda yandopi, andoko angi bala epolo-peyape lo yakamato nembo nateyai. Yakama limu palu yolai-kola, bala kapoyale epoto andolane. Yakamato pai lo ando atalapape. ");
INSERT INTO ipi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wandakali pitaka-mane pii oko ale yakale nembo toto, nambato pii oko yakama langeyo-ko. Yakamato ando atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Okone angi, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane Jisasa langa-langa puato, bala minuto, peyo ome lolane asini mindi aiya peainipia. Oto lapo angu pola-kola, Pasopa tomo nolane oto oko epola-kola, nanimato yisa napalene betesa nolo-peyama nembo toto, utupane-mane pii mindi loto, Pasopa oto okona nanimato Jisasa minu peyo ome lemando, wandakali tupamane nanima towa yataka wato, yanda pingulaini. Ole waka mindi angi, nanimato bala andi lalu, peyo ome lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Matili Jisasa bala Betani tano okona atoto, akali Saimone wamba tapa peane akali okona andaka tomo no peteaipia. Petea-kola, wanda mindimane wele tunduma-pene muni andane-mane wete kambalaini mindi awua epeaipia. Wandakali-mane nata pini tupana ipane penge lo moto, wele tunduma-pene okonepene tupa waa piyainipia. Wele okone botolo pene epene wete mindina piti-pata yane. Botolo okone lumbolane asia tuma ata napene ya-kola, wanda okomane botolo okonena ene luu oko minu kundu loto, wele okone Jisasana kawanenga gae lo aiya mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Wuane pea-kola, wandakali ongane peteaini minditupa-mane yataka wato, yakama teke-teke pii lalawa puato, wandakali waka tupamane wele okone kambeakale loto, wanda okomane yole kambua wete moto, nanima gipia-yale, nanimato katulo muni okone wandakali tipia tupa moyo tale pua maima-yaleko. Anu peakale wanda okomane wele oko mee mo ole peyape leainipia. Wuane loto, utupane-mane wanda okone laiya leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","8","Laiya leai-kola, Jisasato utupane lamawuato, wandakali tipia tupa ole dindi lo yakama towa atolopeyai leaipia. Matili yakamato utupane moya-makale nembo toto, katulo moyolo-peyai. Namba yakama towa ole dindi lo yuu okona ata napulu-peyama. Wanda okomane namba moyo, mana epene wete mindi nambanga mineya-ko. Anu peakale yakamato bala mini mo kenda piya eyaipe. Matili akali minditupa-mane namba mali pulupeyai nembo toto, andipa balato nambana umbuaini oko mandeke puato, wele oko nambanga gae loto, aiya eya. Balato katulo wuane pukale nembo toto, peya oko peakale lo yakamato ando kondalapa. ");
INSERT INTO ipi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nambato pii enene mindi yakama langeyo. Gotena pii layene epene oko yuu pitakana lo tawe yolai-angi, wanda okomane mangene oko peae-ya nembo tolo-peke loto, wandakali-mane pii temane oko lo tawe yolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Okone angi, disaipolo alesa akali tupana mindi Jutasa Isaka-tiyote lene okomane Jisasa ene pitukale nembo toto, pitisa akali kawane tupa ateainga peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Poto, Jisasa ene pitukale lea-kola, utupane-mane balana pii okone ale wato, epele wete wato, nimbato Jisasa ene peteendo, nanimato muni minditupa gulupeyama leainipia. Wuane leai-kola, balato Jisasa ene pituyale asia mindi aiya peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yisa napalene betesa nalaini oto bulupane oko epeya-kola, Juta yame-mane Pasopa tomo tupa namakale nembo toto, sipisipi andopane mindi peyo yangoto, nalainipia. Oto okone epea-kola, Jisasana disaipolo tupamane bala tipa puato, nimbato Pasopa tomo tupa nola loto, nanimato aninga mandeke pipiai lakae lo nembo telepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wuane leai-kola, balato balana disaipolo tupana lapo akali lamawuato, liyamba Jutusaleme pulupape leaipia. Polapi-kola, akali mindimane ipa pene andane mindina ipa piti-pata awua epoto, liyamba malanda olopeya. Liyambato bala watama pulupape. ");
INSERT INTO ipi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bala anda mindina kolandaka lola-kola, liyambato anda okonena anduane oko lamawuato, tisa okomane pii mindi loto, nambana disaipolo tupa towa Pasopa tomo tupa nolane lumu oko aninga eyape lala lalapape. ");
INSERT INTO ipi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wuane lolapi-kola, balato liyamba atu poto, dapolo anda kenga lumu andane mindi liyamba andawa lolopeya. Lumu okonena tepolo tokopi, pitulane tokopi, okonetaka tupa mandeke pitane yolopeya-ko. Liyambato Pasopa tomo nolane tupa mandeke piyapape. ");
INSERT INTO ipi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wuane lea-kola, balana disaipolo okonelapo-mane Jutusaleme poto, andeapi-kola, Jisasato minditaka yolopeya leane tupa pitaka ya-kola, akali okonelapo-mane Pasopa tomo nolane tupa mandeke piyu, peke leapelepia. ");
INSERT INTO ipi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Matili nai andaka pea-kola, Jisasa balana disaipolo alesa akali tupa towa anda okonena peakaiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Peakaiyu lalu, utupane-mane tomo no peteaini-pia. Tomo no pituto, balato utupane lamawuato, nambato pii enene mindi yakama langeyo. Namba towa atu tomo no peteyama akali yakamana mindimane namba towa yanda pene akali tupanga namba malupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wuane lea-kola, utupane-mane yamapane kenda wato, mindiki-mindiki lo bala lamawuato, nimbato namba andayo nalolo-pele yalua laka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","21","Wuane laka peai-kola, balato utupanena pii okone yano peyoto, Gotena pii pepa pelene eya mindimane loto, Akalina Iwanane okomane wua pua omolo-peya layene eya pua bala omolo-peya tekeko, ene pitulane akali oko bala ondo wete ape-pene leaipia. Angini-mane bala mandi napea-yale, katu lapia-yale. Akali okone bala alesa akali yakamana mindi. Namba towa disa mindiki okona betesa tanda peyapa akali okomane nambana yanda pene tupanga malupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jisasa balana disaipolo tupa towa tomo no pituto, betesa mindi moto, Gote wayu pele lalu, betesa okone konde leaipia. Konde loto, balana disaipolo tupa mawuato, oko nambana umbuaini oko. Yakamato mo nalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Wuane lalu, balato kapo waene petene mindi moto, Gote wayu pele loto, balana disaipolo tupa mai-yaepia. Mawuato, nambato pii wenene mindi lo yata wato, nambana tundupa oko gae lolowa okomane wandakali kambua moyolo-peyawa leaipia. Wuane lea-kola, utupane pitaka-mane waene okone neainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Neai-kola, balato utupane lamawuato, nambato pii enene mindi yakama langeyo leaipia. Andipa ato tewa, nambato waene nanene atama pulu, matili Goteto wandakali pitaka moyo ando atola-angi, nambato waene waka mindi nolo-peyawa. ");
INSERT INTO ipi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wuane lalu, balato utupane towa soŋo mindi lalu, Jutusaleme tepa alu, Olipi wangiane okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Okone angi, Jisasato balana disaipolo tupa lamawuato, Gotena pii pepa pelene eya mindimane loto, nambato sipisipi ando atalane akali oko peyo ome lolowa-kola, sipisipi tupa palaka puu toko lolopeyai layene eya leaipia. Pii okonemane wuane leya okonena, yakama pitaka-mane nambanga tungi peleyai oko awua tepa alu, yakama palaka puu toko lolopeyai nembo teyo. ");
INSERT INTO ipi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yakamato wuane pulupeyai tekeko, matili Goteto namba malinga ika laya ola-angi, namba wamba ini ingane Galili disitiki okona polowa-kola, matili yakama epolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wuane lea-kola, Pitato bala lamawuato, akali waka tupa pitaka-mane nimbanga tungi peleyai oko awua tepa yaindopi, nambato wuane napulu-peyawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wuane lea-kola, Jisasato bala lamawuato, nambato pii enene mindi nimba langeyo. Andipa utulu, eka pauli maipa mindimane pii lapone gulo wene loyale pula-kola, ole tepoainga nimbato wandakali minditupa lamawuato, nambato Jisasa anda na-peyawane lolopele leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wuane lea-kola, Pitato bala lamawuato, namba nimba towa atu omape-pene guleando, okone katu. Nambato nimba anda na-peyawane nalolo-peyawa. Jia wete leaipia. Wuane lea-kola, disaipolo waka tupa pitaka-mane wuane teke leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Okone angi, Jisasapi, balana disaipolo tupapi, utupane yuu Gesemani lene okona peainipia. Pulu, balato utupane lamawuato, namba pote lolo peyo-ko. Yakama onga pitiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wuane lalu, balato Pita, Jemesa, Jone ima utupane atu aiyu amonga-yale poto, yamapane kenda wetete wato, anu puape lo nembo kambua teaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nembo kambua toto, balato utupane lamawuato, nambana yamapane kenda wetete peya okonena, namba omape-pene gulalua-ko. Anu peyape lo andoyale, yakamato onga atoto, ando atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wuane lalu, bala ambinga-yale peaipia. Bala tandaka nape-pene oko peyo wanju olane asini mindi yando, asini okonena pokale nembo toto, balato yuunga tombawua loto, pote leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pote loto, Ayiane Gote, nimbato katulo pitaka taka pilini-ko. Tandaka nambato nape-pene oko peyo wanju olane asini mindi yando, nimbato asini okone lumbape. Nimbato wuane pula lo nambato nembo teyo tekeko, nambato nembo teyo pua napene, nimba tane nembo tele pua pipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wuane lalu, bala peke loto andea-kola, balana disaipolo tepo akali utupane limu palu yainga andoto, balato Pita tipa puato, Saimone, nimbato katulo awa mindiki angu ando ata napene, wamba kapoyale pangelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Enene, yakamato ando ataima lakae lo nembo teyai tekeko, yakamana umbaini tai naleya-kola, yakamato ando ata napene, limu paleyai. Sataneto yakama minu mandeke pula-kola, yakama yuunga peakolaini. Pote lo ando atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wuane lalu, bala lapone ambinga-yale poto, pote bulupane leane mindiki okone teke lolo-peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pote lalu, bala peke loto andea-kola, utupane limu wete wato, lapone limu palu yainga andeaipia. Andoto, balato utupane peya ika leane tekeko, utupane-mane aki lamape lo nembo nateainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nembo nateai-kola, balato ole tepone gulo pote lolo pulu, peke loto, utupane tipa puato, yakama mee oto mo limu teke palu ateyaipe leaipia. Yakamato wuane pua ateyai oko kondalapa. Akali mindimane Akalina Iwanane namba yanda pene tupanga maulane oto oko epeya-kola, namba ene pitipia akali okomane koo piyaini akali tupamane namba andi leakale loyale peya. ");
INSERT INTO ipi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Namba ene pitipia akali oko bala wamba mandaka epeya oko andalapa. Nanimato bala malanda olo makale. Ika lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisasato pii okone lo atea-kola teke, balana disaipolo alesa tupana akali Jutasa bala akali kambua tupa towa atu epeainipia. Wamba pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, Juta yame ando atalaini akali tupapi, utupane-mane akali utupane lamawuato, yakamato Jisasa andi lolo pulupa leai-kola, utupane-mane kandepa luupi, mulipi, utupane awua epeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jutasato utupane lamawuato, nambato akali mindi nunu lolowa oko Jisasa yolopeya-ko. Bala palaka polane. Yakamato bala duli lo minuto, atu aiyu pulupape leaipia. Wuane lalu, bala utupane towa Jisasa andi lolo poyale peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jutasato Jisasa ateanga epoto, bala ando, tisa loto, bala nunu leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nunu lea-kola, akali utupane-mane Jisasa taimane minuto, andi leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Andi leai-kola, Jisasa ateanga mandaka ateaini akali tupana mindimane kandepa luu mandeane oko kilau lo moto, pitisa akali kawane okona piape akali okona alene mindi yoko taka lo tepa yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Akali utupane-mane Jisasa andi leai-kola, balato akali epeaini utupane tipa puato, yakamato kandepa luupi, mulipi, utupane awua poto, pake nene akali mindi andi lalaini pua, namba andi lolo epeyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ole dindi lo lotu anda andane okona ende anda-pangosa namba yakama towa atu atoto, wandakali tupa mana lamawua atalawane tekeko, okone angi yakamato namba minu andi na-lapiai. Wuane tekeko, bala tanena pii pepa pelene eya mindi enene guleakale nembo toto, Goteto ando kondeya-kola, yakamato mangene utupa peyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Akali utupane-mane Jisasa andi leai-kola, balana disaipolo tupa pitaka bala awua tepa alu, palaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Okone angi, akali mindimane iwana patane Jisasa towa atu ateane mindi andi lokale nembo toto, iwana okonena tona peane oko minata yaepia. ");
INSERT INTO ipi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Minata ya-kola, iwana okonemane balana tona peane okone yoko tepa alu, bala papata palaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Akali utupane-mane Jisasa andi loto, pitisa akali kawane oko ateanga atu aiyu peai-kola, pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, loo tupana mana andene akali tupapi, utupane pitaka epo amunguli peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita bala amonga-yale ata iki lama Jisasa watama poto, pitisa akali kawane okona anda ende pitane atene okona kolandaka leaipia. Piape akali minditupa-mane ongane ita yango peteai-kola, bala utupane towa endo yo peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Pitisa akali kawane tupapi, kanjole waka tupapi, utupane pitaka-mane Jisasa peyo ome lolane tene mindi aiya peainipia. Owato wisanisa kambua epoto, owato pii loto, Jisasa kosimi leaini tekeko, utupane-mane pii mindiki okone teke nalene, pii waka-waka leai-kola, Juta yamena kanjole tupamane bala peyo ome lolane tene mindi ale nayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Matili akali minditupa-mane ika loto, Jisasa andayo owato pii mindi loto, wamba nanimato ale ema-kola, akali okomane pii mindi loto, nambato Gotena lotu anda andane wandakali-mane pene oko keao lalu, ole tepo angu piape puato, Gotena lotu anda andane waka wandakali-mane napene mindi pulu-peyawa leane leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Utupane-mane wuane leaini tekeko, akali utupane pitaka-mane pii mindiki okone teke naleai-kola, kanjole tupamane Jisasa peyo ome lolane tene mindi anda napeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Okone angi, pitisa akali kawane okomane akali peteaini tupana wenonga ika loto, Jisasa tipa puato, akali utupa-mane nimba kosimi loto, koo tene mindi nimbanga yata eyai tekeko, nimbato utupanena pii okone yano peyoyale, pii mindikipi mindi laa napele okonde leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Balato wuane leane tekeko, Jisasato pii mindikipi mindi lapeke naleaipia. Balana pii okone yano napelea-kola, pitisa akali kawane okomane bala tipa puato, nimba Gote nanimato laiyu lalamane okona iwanane Mesaya oko atelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Wuane lea-kola, Jisasato balana pii okone yano peyoto, uli. Matili yakamato andolai-kola, Akalina Iwanane namba Gote tai wetete okona kii tikasa-tole pitiyu, atinga kenga tawe mole tupana tokonga epolowanga yakamato andolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Wuane lea-kola, pitisa akali kawane okomane yataka wato, bala tanena tona peane oko minu liti loto, Juta yamena kanjole akali tupa lamawuato, balato Gote lamba leya-kola, yakama tane ale eyai oko yako. Anu peakale wandakali waka mindimane wisanisa atoto, bala tane Mesaya oko ateyo lalane lo nanima langeakale maliyo atamakalepe. Balato Gote lamba leya-ko. Yakamato aki nembo teyaipe leaipia. Wuane lea-kola, akali kanjole tupa pitaka-mane balana pii okone yano peyoto, koo tene andane balanga eya-ko. Bala omape-pene leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wuane leai-kola, akali minditupa-mane Jisasa apesango soo lo peleaini-pia. Akali mindimane Jisasana lee-inga yake pua ombo ya-kola, akali waka tupamane bala kii momanga-mane peyalu, nimba potopesa akali mindi gulo atoto, akali nimba peleya okona gene laa leainipia. Wuane lalu, ami yanda yene tupamane bala minu peleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jisasa bala pitisa akali kawane okona dapolo anda kenga lumu mindina atea-kola, Pita bala napinga anda okonena ende anda-pangosa ateaipia. Atea-kola, pitisa akali kawane okona piape wanda tupana mindi epeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Epoto, balato Pita endo yo peteanga andeaipia. Balato Pita pai lo andoto, bala lamawuato, nimbapi, Nasatesa tane Jisasa oko towa atu atapiapi leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wuane lea-kola, Pitato balana pii okone tanga loto, nambato akali okone anda na-peyawane. Nimbato aki nembo toto, wuane lelepe lo namba tatake eyo leaipia. Wuane lalu, bala ende pitane okona asia lomba okona mandaka poto atea-kola, eka pauli maipa mindimane pii leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita ongane atea-kola, piape wanda okonemane bala lapone teke andoto, wandakali mandaka ongane ateaini tupa lamawuato, akali oko bala Jisasana disaipolo tupana mindi ateya leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wuane lea-kola, Pitato balana pii okone tanga loto, lapone teke nambato Jisasa anda na-peyawane leaipia. Aŋa matili yale, wandakali ongane ateaini tupamane Pita lamawuato, nimba Galili disitiki tane mindi ya lo andeyama. Enene wete, nimba Jisasana disaipolo tupana mindi atele leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wuane leai-kola, Pitato balana weno minuto, pii taimane loto, enene wete, yakamato akali mindi andayo pii leyai okone nambato anda na-peyawane leaipia. Goteto andeya. Nambato pii leyo oko owato pii lewando, balato namba minu koyakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pitato wuane lea wete, okone angi teke eka pauli maipa mindimane lapone teke pii lea-angi, Pitato pii Jisasato wamba leane oko nembo tolo-peke leaipia. Wamba Jisasato eka pauli maipa mindimane pii lapone gulo wene loyale pula-kola, ole tepoainga nimbato namba anda na-peyawane lolopele leane okone enene guleya nembo toto, Pita bala ai leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Upanda wete pitisa akali kawane tupapi, Juta yame ando atalaini akali tupapi, loo tupana mana andene akali tupapi, kanjole waka tupapi, utupane pitaka-mane pii mindiki lo yake puato, Jisasana kini eyaka-mane andi loto, bala atu aiyu poto, Pailate mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mayai-kola, Pailateto Jisasa tipa puato, nimba Juta yamena kiŋi okope leaipia. Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimba tane wuane lele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wuane lea-kola, pitisa akali kawane tupamane koo tene kambua balanga yata yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yata yai-kola, Pailateto bala lapone tipa puato, akali utupane-mane koo tene kambua nimbanga yata eya oko nimba tane ale ele okoni. Nimbato utupanena pii okone yano peyoto, pii mindikipi mindi nalolape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Balato wuane leane tekeko, Jisasato balana pii okone yano peyoto, pii mindikipi mindi nalea-kola, Pailate moko wete leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ee ana dindi lo Juta yame wandakali tupamane Pasopa tomo nalaini oto oko epeya-angi, utupane-mane akali katapusa atalaini tupana mindi makimi loto, Pailate nimbato akali okone tita lo tepa ape leai-kola, balato utupane moyoto, akali okone tita lo tepa alaepia. ");
INSERT INTO ipi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","10","Tene okonena, wandakali kambua epo amunguli puato, balato akali mindi tita lo tepa yakale leainipia. Pailateto andea-kola, pitisa akali kawane tupamane Jisasa towa apiangu puato, mee kosimi leainga andoto, wandakali utupane tipa puato, nambato Juta yamena kiŋi oko tita lo tepa apia lakae lo nembo teyaipe leaipia. Balato wuane leane tekeko, wamba akali minditupa-mane Lomo gapomane oko yanda pimawuato, wandakali minditupa peyo ome leai-kola, gapomane okomane akali utupane pitaka andi loto, katapusa anda okona aindaka leainipia. Akali utupanena mindi gene Batapasa lenepia. ");
INSERT INTO ipi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bala katapusa atea-kola, pitisa akali kawane tupamane wandakali tupana nembo-tene mina ika laya wato, yakamato Pailate lamawuato, nimbato Batapasa tita lo tepa aa lalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Wandakali tupamane Batapasa tita lo tepa aa leai-kola, Pailateto utupane lamawuato, yakamato Jisasa bala Juta yamena kiŋi oko ateya lalaini-ko. Nambato Batapasa tita lo tepa ewando, nambato Jisasanga anu pipia lakae lo nembo teyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wuane lea-kola, utupane-mane pii taimane loto, bala ita malamanda okona peyo yuka aa leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wuane leai-kola, Pailateto utupane tipa puato, anu peakale nambato bala ita malamandanga peyo yuka ape-penepe. Balato mana koo wete andoko minapiape leane tekeko, utupane-mane balana pii okone yano peya napene, mee pii taimane wete loto, bala ita malamanda okona peyo yuka aa laka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Wuane laka peai-kola, Pailateto utupane mo epele aya wakale nembo toto, Batapasa tita lo tepa amaiya. Wuane piyu, balato ami yanda yene minditupa lamawuato, yakamato Jisasa kunju-mane peyalu, ita malamanda okona peyo yuka alapa loto, utupanenga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami yanda yene utupane-mane Jisasa atu aiyu gapomane anda okona ende anda-pangosa poto, utupanena ami yanda yene yangone tupa pitaka epeakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Epeai-kola, tona kiŋi tupamane kala pepolo piyaini okonetaka nembo toto, utupane-mane tona okonepene mindi balanga piya mayainipia. Piya maiyu, utupane-mane eyaka ani atene mindi mo umange pua, kiŋina tangi gulene mindi waa puato, balana kawanenga tangi gulo anda aiya mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wuane piyu, utupane-mane bala lamba loto, Juta yamena kiŋi nimba wayu epeleya. Nimba kuai lo atape leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wuane lalu, utupane-mane kelewa kanda mindimane balana kawanenga peyaka, apesango soo lo peyaka peainipia. Wuane piyu, utupane-mane mee owato balana gene oko laiyu lele pua, aikini leka aka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Utupane-mane bala lamba lo koyo piyu, tona pepolo balanga piya mayaini oko yoko moto, bala tanena tona piyane tupa piya maiyu, bala ita malamanda okona peyo yuka oyale atu aiyu peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Okone angi, Saitini tano okona tane Saimone lene mindi bala Jutusaleme poyale asini epeaipia. Bala Aleke-sanda, Lupasa-la, okone-lapona ayiane pia. Bala epea-kola, balato Jisasana ita malamanda oko aiyakale loto, ami yanda yene tupamane okone balanga mo aiya mayainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Saimoneto Jisasana ita malamanda oko awuato, bala towa atu pea-kola, ami yanda yene tupamane okonelapo atu aiyu poto, Golokota yuu okona peakaiyu leainipia. Gene Golokota okona tene oko kawane kulini wangiane oko eya. ");
INSERT INTO ipi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Golokota wangiane okonena peakaiyu lalu, utupane-mane ipa waene minditupa moto, matasini towa mina mindiki loto, Jisasa neakale mayaini tekeko, balato naa napeaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","Upanda taeme naini kiloko lea-kola, ami yanda yene tupamane Jisasa ita malamanda okona peyo yuka yainipia. Wamba pitisa akali tupamane Jisasa kosimi loto, Pailate lamawuato, Jisasato bala Juta yamena kiŋi ateyo lalane leainipia. Wuane leaini oko nembo toto, ami yanda yene tupamane akali oko bala Juta yamena kiŋi oko ateya lo pepa peyoto, pepa okone Jisasana ita malamanda okona kawanenga ate leainipia. Ate lalu, utupane-mane bala ita malamanda okona peyo yuka alu, tasu peyoto, wini leane akali tupamane mindiki-mindiki lo balana tona mindi miaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wuane piyu, utupane-mane pake nene akali lapona mindi ita malamanda Jisasana kii tikasa-tole ateane mindina peyo yuka alu, mindoko ita malamanda Jisasana kii koyasa-tole ateane mindina peyo yuka yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wuane peai-kola, Gotena pii pepa pelene eya mindi enene guleaipia. Pepa okonemane loto, wandakali-mane andeai-kola, bala koo piyane akali mindi gulo ateya lo andeaini layene eya. ");
INSERT INTO ipi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jisasa bala ita malamanda okona peyo yuka atane ateane ongane mandaka epo peaini wandakali tupamane yakamana kawane taimane ema puato, bala lamba loto, nimbato lotu anda andane oko keao lalu, ole tepo angu piape puato, pulu-peke lolo-peyawa lalene akali piako. ");
INSERT INTO ipi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nimba tane moyoto, ita malamanda oko tepa alu, yuunga ipu leainipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wuane pua teke, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane-mane pii lalawa puato, Jisasa lamba loto, balato wandakali waka tupa moyane tekeko, bala tane katulo moya napeya. ");
INSERT INTO ipi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bala ita malamanda oko andipa tepa alu, yuunga epeando, nanimato okone andoto, bala Isatale tanena kiŋi atoto, Mesaya oko ateya lo bilipi lolo-peyamako. Bala yuunga epeakale leainipia. Wuane loto, bala lamba leai-kola, bala peyo yuka atane ateane ongane mandaka gulo ita malamandanga lapo akali peyo yuka atane ateapili akali okonelapo-manepi bala lamba leapele tekepia. ");
INSERT INTO ipi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","37","Otonga oto kulini okona ato tewa, yuu tupa pitaka undupi latane angu atea-kola, matili ole lene taeme siti kilokopi mindi lea-kola, Jisasato pii taimane wete loto, Eli, Eli, lama sapa-katani leaipia. Pii okone nanimato mopeke loto, nambana Gote, nambana Gote, anu peakale nimbato namba tepa elepe leaipia. Wuane lea-kola, wandakali ongane ateaini tupana minditupa-mane ale wato, balato Ilainja ee lalua-ko. Ale alapa leainipia. Okona angi, akali mindi taimane poto, sapanjia mindi moto, waene kaa-pene pinika lene okona tanda pua moto, ita kai mindina tutuku puato, Jisasa bala duu lo neakale mayaepia. Maiyu, balato wandakali waka tupa lamawuato, pii kondalapa. Ilainjato bala ondo molo epeyape lo andamakalenga, maliyo atalapa leaipia. Balato wuane leane tekeko, Jisasa bala taimane wete kalae lalu, omeaipia. Okone angi, ole-lene taeme siti kiloko lea-kola, yuu waa lolo-peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Jisasato pii minditupa lalu, omea-angi, ami yanda yene ando atalane akali oko bala Jisasana ita malamanda okona wenonga ateaipia. Ongane atoto andea-kola, enene wete, akali oko bala Gote Iwanane yala leaipia. Okone angi teke, lotu anda andane okona asia lomba gulene lapa-lapa andane yuka atane ateane oko iyunga ato tewa, atutu lete lo lapo peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Wamba Jisasa bala Galili disitiki okona piape pua epoko pua atea-angi, wanda minditupa-mane bala watama poto, bala moyalaini-pia. Bala Jutusaleme tano okona peane-angi, wanda utupanena mindi bala Jose, balana amene aŋako Jemesa-la, okone-lapona angini Matiya okopi, mindi Makatala tano okona tane Matiya okopi, mindi Salomepi, wanda tepo utupane yakama wanda waka kambua tupa towa atu Jisasa watama Jutusaleme peainipia. Wanda utupane pitaka amonga-yale andapeyo atoto, bala wua pua omeya ya lo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Atimatiya tano okona tane Josepe oko bala Juta yamena kanjole akali gene yene mindi ateaipia. Bala Gote lo bilipi loto, matili balato pitaka taka taimane wete ando atolopeya nayuto, maliyo ateaipia. Ole lea-kola, anate-lene Sambasa atokale lo mandeke pipe-pene nembo toto, bala yuku naene, Pailate ateanga poto, nambato Jisasana umbaini oko ondo mokalenga, nimbato ando kondape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wuane lea-kola, Jisasa wamba kapoyale omeane oko nembo natene, Pailateto tatake wato, ami yanda yene kawane oko epeakale loto, bala tipa puato, Jisasa wamba omalape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wuane lea-kola, ami yanda yene kawane okomane balana pii okone yano peyoto, enene, Jisasa wamba omala leaipia. Wuane lea-kola, Pailateto Josepe lamawuato, nimbato balana umbaini ondo miape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wuane lea-kola, Josepeto lapa-lapa epene wete ake-pene mindi kambalu, Jisasa ondo moto, yuunga awua epoto, lapa-lapa okonemane yake pua ombo yaepia. Wamba akali minditupa-mane wandakali mali pulane panda mindi ana ati mindina kua pua yainipia. Josepeto Jisasana umbaini oko mali okonena yata yaepia. Yata alu, balato ana andane wete mindi minu pendeke lo awua epoto, mali okonena asia lomba oko tuma peaipia. ");
INSERT INTO ipi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Josepeto Jisasa mali pea-angi, Jose angini Matiya okola, Makatala tano okona tane Matiya okola, okonelapo-mane balana mali okone andeapele-pia. ");
INSERT INTO ipi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambasa oto oko koyo pea-kola, Salomepi, Jemesa angini Matiya okopi, Makatala tano okona tane Matiya okopi, utupane-mane wele tunduma-pene minditupa Jisasana umbuaini okona aiya oyale minditupa kambeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","4","Sande angi upa pitane wete, nai peakata ya-kola, wanda utupane Jisasana mali okona poyale asini peainipia. Ana andane wete mindimane mali okona asia lomba oko tuma pitiyaini oko nembo toto, utupane yakama teke-teke pii lalawa puato, apito nanima moyo, ana andane okone minu pendeke loto, mo aiyangi lolo-peyape leainipia. Utupane-mane wuane leaini tekeko, mali okona peakaiyu loto andeai-kola, mali okona asia lomba tuma pua ana andane wete yane oko minu pendeke lo aiyangi layene yanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Andalu, utupane-mane ana anda mali okona kolandaka loto andeai-kola, iwana patane tona luu ake-pene mindi kii tikasa-tole peteanga andoto, moko wete loto, yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Moko wete leai-kola, iwana okonemane utupane lamawuato, yakama moko loto, yuku olaini leaipia. Nasatesa tane Jisasa bala ita malamanda okona peyo yuka apiai oko yakamato aiya pima epalai ya tekeko, Goteto bala malinga ika laya ala-kola, bala pala-ko. Bala onga naeya. Bala yata apiapi panda oko andalapa. ");
INSERT INTO ipi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yakamato Pitapi, disaipolo waka tupapi, utupane ateyainga poto, Jisasa bala Galili disitiki okona wamba ingane pala-ko. Balato lapia pua teke, yakamato yuu okonena poto, bala andolopeyai lo lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iwana patane okomane wuane lea-kola, anu piyape lo tatake wato, wanda utupane yakama putu-putu peyoto, mali oko tepa alu, palaka peainipia. Yuku wato, utupane-mane minditaka andeani tupa wandakali mindikipi mindi lamai napeainipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wamba Makatala tano okona tane Matiya balanga sipitisa koo yanasa atea-kola, Jisasato utupane peyo wateaipia. Sande angi wamba upa pitane Jisasa bala malinga ika lalu, wanda okonemane bala wamba ini andeakale lo panakame ateaipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Jisasana disaipolo tupamane yamapane kenda wato, ai lo ateai-kola, wanda okone poto, utupane lamawuato, Jisasa bala saka ateyanga andalo leane tekeko, utupane-mane balana pii okone ale wato, bilipi naleainipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Matili Jisasa bala waka gulo epea-kola, balana disaipolo lapo akali Jutusaleme tepa alu poto, bala asininga andeapele-pia. ");
INSERT INTO ipi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Andalu, okonelapo-mane poto, balana disaipolo waka tupa lamaiyapi-kola, utupane-mane akali okone-lapona pii okone bilipi naleainipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wamba Jisasa bala malinga ika lea-angi, wandakali minditupa-mane bala andoto, Jisasana disaipolo masia tupa lamai-yaini tekeko, utupane-mane wandakali utupanena pii okone bilipi naleainipia. Matili balana disaipolo utupane tomo no peteai-kola, bala epoto, utupane laiya loto, anu peakale yakama tuu puato, wandakali utupanena pii okone bilipi na-lapiaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yakamato yuu yoo peya tupa pitakana poto, Gotena pii layene epene oko wandakali tupa pitaka lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wandakali mindimane pii okone bilipi loto, ipa meando, Goteto bala molo-peke lolopeya tekeko, wandakali mindimane bilipi naleando, Goteto bala kosimi lalu, yuu koo okona puu lolopeya. ");
INSERT INTO ipi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Namba lo bilipi lolai wandakali tupamane nambana gene oko loto, sipitisa koo tupa peyo watolo-peyai. Utupane-mane katulo wandakali yame waka tupana pii lalaini tupa mo lolopeyai. Utupane-mane etulu gepo mindi kini-mane miniaindopi, wandakali omaya alane ipa koo mindi neaindopi, okonetaka tupamane utupane minu koya napulu-peya. Utupane-mane yakamana kini tupa wandakali siki pelene tupanga yata olai-kola, siki utupane atu yolopeyai. Wandakali-mane andolai-kola, wandakali mindimane mangene utupanena mindi peando, wandakali okonemane Gote lo bilipi loto, mangene okone pula-kola pulupeyai. ");
INSERT INTO ipi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Akali Andane Jisasato pii utupane balana disaipolo tupa lamai koyo pea-angi, Goteto bala ati kenga iyu okona epeakale lea-kola, bala poto, Gotena kii tikasa peteaipia. ");
INSERT INTO ipi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Balana disaipolo tupa yuu tupa pitakana poto, Gotena pii layene epene oko wandakali tupa lamaiki peai-kola, Jisasa bala Gotena kii tikasa pituto, balana disaipolo tupa moyoto, metekolo piape pulane tai-lene oko utupane maiki peaipia. Maiki pea-kola, utupane-mane metekolo piape tupa piki peaini mana okomane pii utupane-mane leaini tupa enene ya lo andawa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Tiapolesa, andipa nambato pii pepa peleyo tupa nimbato dii lo andoto, nembo tape. Wamba nanima tombenenga Goteto piape kambua mina ika lo peaipia. Piape bulupane peane tupapi, matili peane tupapi, utupane pitaka wandakali minditupa-mane lee-mane andeaini-pia. Andoto, akali utupanena minditupa-mane pii akali atoto, Goteto wua peane lo nanima langeai. Akali kambua-mane pii temane utupane ale wato, pepa peleaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Wamba Goteto piape peane utupane pitaka anu pua peape lo nambato wayumane nembo tokale loto, balana piape lee-mane andeani wandakali tupa tipa piki pua atewa. Akali minditupa-mane piape Goteto peane tupa nimba langeai-kola, Goteto piape utupane anu pua peape lo Tiapolesa nimbato wayumane nembo tola loto, andipa nambato nimbana pepa oko tika pua peyo epe leyo. ");
INSERT INTO ipi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wamba Etote bala Jutiya disitiki okona kiŋi ateane okone angi, Gotena piape piyane pitisa akali Sakataya lene mindi ateaipia. Bala pitisa piape piyane Apaisa yame okona mindi ateaipia. Bala wetene Elisambesa oko bala Etone yame peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Elisambesa, Sakataya-la, okonelapo-mane Gotena loo tupapi, pii layene tupapi, utupane pitaka tika pua minu peteapele-pia. Liyambanga koo tene mindi naya-kola, Goteto okonelapo wandakali tika-pene peteyapi leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wanda Elisambesa oko ini tai lea-kola, bala akalini okola, liyambato andopane mindi mandi napene pitiyu mini yapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Alumindi Sakataya bala akali minditupa towa pitisa piape piyaini oto oko epea-kola, Gote lo tama pua, pitisa piape puyale epo ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ateai-kola, pitisa akali tupamane piape puyale tale piyaini pua tale puato, Sakataya, nimbato Gotena lotu anda andane okona kolandaka loto, Gote tama pua, ita dini tunduma-pene tupa yango atape leainipia. Wuane leai-kola, Sakataya bala Gotena lotu anda okona kolandaka leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Okone angi, wandakali kambua wete epo amunguli puato, takita pote lo ateainipa. ");
INSERT INTO ipi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakatayato Gotena pitisa piape oko pua atea-kola, enjole mindi epoto, ita dini tunduma-pene yangalaini alata toko okona kii tikasa-tole epo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Atea-kola, Sakatayato enjole okone andalu, moko loto, yuku yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yuku ya-kola, enjole okonemane bala lamawuato, Sakataya, nimba yuku naene kondaa leaipia. Nimbato tee lo pote lapi oko Goteto ale apia. Tene okonena, nimba wetene Elisambesato nimbana iwana mindi mandulu-peyako. Nimbato iwana okonena gene Jone lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","Jone bala angini okona ininga pitula-kola, Oli Sipitisa oko balanga epo tumbi lolopeya. Wamba Oli Sipitisa okomane Ilainja minu tai laya yane pua teke, balato Jonepi minu tai laya olopeya. Tai laya ola-kola, wamba Ilainjato piape taimane peane pua teke, Jone balatopi piape taimane pulupeya. Balato ipa taipi, waenepi, utupane nanene wete ateakale. Akali Andane okomane Gotena piape puyale atola-angi, Joneto piape minditupa wamba ini pulupeya. Akali Andane oko epolopeya nembo toto, wandakali-mane mandeke pua ateakale loto, Joneto Gotena piape puato, Gotena mana wato mina na-piyaini wandakali tupa mana lamaulu-peya. Mana lamawuato, Gotena mana tika pua wato minalaini wandakali tupamane nembo talaini pua teke nembo talapa lolopeya. Balato ayianepi, iwananepi, waka gulo atalaini tupa lamawuato, yakama yamapane mindiki palu atalapa lolopeya. Wuane loto, balato Isatale tane wandakali kambua tupana yamapane mina ika laya ola-kola, utupane-mane yakamana Akali Andane Gote oko lo bilipi lolopeyai. Bilipi lolai-kola, Akali Andane okomane Jonena gene oko laiyu lolopeya. Joneto Gotena piape kuai lo pula-kola, Sakataya nimbato bala mandeene nembo toto, wandakali-mane epele olopeyai. Nimbato balana piape utupane pitaka andoto, bala mandewa lo epele-mane omolopele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Enjole okomane wuane lea-kola, Sakatayato namba mini eyo leaipia. Namba wetenepi, mini-yene teke peteya-ko. Nimbato andopane mindi mandulu-peyapi lele okone anu pua nambato enene ya lo andokalepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wuane lea-kola, enjole okomane Sakatayana pii leane okone yano peyoto, namba Gapatele leaipia. Namba Gotena wenonga atalawane. Goteto pii okone Gapatele nimbato Sakataya lamaulu puu lala-kola, nambato pii leyo tupa langulu epeyo. ");
INSERT INTO ipi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Andipa nambato pii leyo tupa nimbato enene ya lo bilipi nalele okonena, nimbana nee asia tuma pula-kola, nimbato pii katulo nalolo-pele. Pii leyo utupa enene gulola-angi, matili nimbato pii katulo lolo-peke lolopele. Enjole okonemane wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakataya ini takita naepea-kola, wandakali takita pote lo ateaini tupamane nembo kambua toto, lotu anda andane okona aki mindimane bala minandi leyape lo maliyo ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Balana nee asia tuma pitane atea-kola, bala takita epoto, pii mindi katulo laa napeaipia. Balato mee kii-mane mandeke piki pea-kola, lotu anda anda-pango okona mangene mindi andalaya lo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Andeai-kola, Sakatayato balana pitisa piape pikoyo piyu, bala andaka peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Sakataya bala wetene Elisambesa towa paleapi-kola, ininga andopane peteaipia. Petea-kola, Elisambesato pii mindi loto, wamba namba andopane mindi mandi napene pituto, wandakali wenonga yalawa pitiyawane-ko. Andipa namba yalawa teke pituluwane loto, Akali Andane okomane namba ondo wato, andopane mindi geya leaipia. Wuane lalu, Elisambesa bala takita puu napene, ana yau andaka peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Wana mapokae Matiya lene mindi bala Galili disitiki okona tano aŋako Nasatesa lene okona peteaipia. Bala akali Josepena bakale lene peteaipia. Josepe bala kiŋi Dapiti yame mindi ateaipia. Elisambesa bala andopane tongotaka ana wataka petea-kola, Goteto enjole Gapatele andayo, nimbato pii mindi Matiya lamalu puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lamalu puu lea-kola, enjole okonemane Matiya peteanga poto, Akali Andane oko nimba towa atu atoto, mini epene pale laya eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wuane lea-kola, Matiya bala moko loto, balato pii anu-pene mindi namba langeyape lo nembo kambua teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nembo kambua tea-kola, enjole okomane bala lamawuato, Matiya, Goteto nimba towa mini epene paleya-ko. Nimba yuku olene. ");
INSERT INTO ipi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nimbana ininga andopane mindi pitula-kola, nimbato iwana mindi mandulu-pele. Mandule-angi, balana gene oko Jisasa lape. ");
INSERT INTO ipi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Balana gene oko andane wete yolopeya. Wandakali tupamane bala Gote Ati Kenga Ateya okona iwanane lolopeyai. Wamba Goteto iwana okona yumbane Dapiti bala kiŋi ateakale leane pua teke, Goteto nimbana iwanane okone bala kiŋi ateakale lolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bala kiŋi atoto, matili-matilipi Jekopo yame tupa ando atapowa atolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wuane lea-kola, Matiyato enjole okone lamawuato, namba akali mindi towa piti napeyo-ko. Nambato anu puato, iwana okone mandulu-peyawape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","37","Wuane lea-kola, enjole okomane balana pii okone yano peyoto, Goteto piape mindikipi mindi puyale pitete naene piyane leaipia. Nimba aini Elisambesa bala andopane mindi mandi napene mee kinambuli petea-kola, wandakali tupamane Elisambesa bala andopane mindi mandi napulu-peya lalaini tekeko, andipa bala mini-yene angi, iwana mindi manduyale tongotaka peteya-kola, ana wataka peya. Nimbatopi iwana mindi mandula loto, Oli Sipitisa oko nimbanga epola-kola, Gote ati kenga wete ateya okona tai-lene okomane nimba ando atolopeya. Goteto iwana epene wete okone nimbana ininga pete lola-kola, wandakali tupamane bala Gote iwanane ateya lolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Enjole okonemane wuane lea-kola, Matiyato bala lamawuato, namba Akali Andane okona piape wanda pitiyawane-ko. Nimbato pii lele okone atu yalua leaipia. Wuane lea-kola, enjole okone bala Matiya tepa alu peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Okone angi, Matiya bala Galili disitiki oko tepa alu, Jutiya disitiki okona yuu wangiane tano yene mindina wamba ini peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Poto, bala Sakatayana andaka kolandaka loto, Elisambesa andayo, nimba kuai lo petelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisambesato pii okone ale ya-kola, iwana balana ininga peteane okomane ema taimane peaipia. Okone angi, Oli Sipitisa oko Elisambesa balanga epo tumbi leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","44","Tumbi lea-kola, Elisambesato epelewa pii taimane loto, nimbato namba ando pii lele oko ale eyo-angi, andopane nambana ininga peteya okomane epele wato, ema peya. Namba wanda epene andoko peteyonga nambana Akali Andane okona angini nimbato namba andolo epelepe. Goteto nimba moyola-kola, nimbato Gotena iwanane mandule okomane wanda waka tupa pitaka sia minulu-pele. Andopane nimbana ininga peteya okone Goteto wayumane moyo ateya. ");
INSERT INTO ipi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Akali Andane okomane pii nimba langipia tupa matili enene gulolo-peya lo bilipi lele okonena, nimba epelewa petele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","50","Elisambesato wuane lea-kola, Matiyato pii mindi loto, namba gene nayene mee balana piape wanda pitiwa-kola, Gote tai wetete ateya okomane namba moyo piape andane minditupa peya leaipia. Piape peya utupane wandakali pitaka-mane nembo toto, Goteto wanda okone moyaepia lolopeyai. Goteto namba molo-peke leane nembo toto, nambato bala epele wete wato, Akali Andane okona gene oko laiyu leyo. Bala ando yukuwa atalaini wandakali tupa pitaka balato ondo wato, moyalane. Balana gene epene wete eya. ");
INSERT INTO ipi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Balana kini-mane piape taimane piyane. Wai-ene gulo, luawa atalaini wandakali tupa pitaka balato peyo wata alane. ");
INSERT INTO ipi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Balato kiŋi tai tupa mo tepa wato, wandakali gene nayene tupa minu tai laya alane. ");
INSERT INTO ipi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tomo nonowa atalaini wandakali tupa pitaka balato minditaka kambua maiyu, minditaka kambua yene wandakali tupa mee peakale lalane. ");
INSERT INTO ipi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Wamba balato nanimana yumbane Apatakamenga pii mindi lamawuato, nambato nimbapi, nimbana mandiyene tupapi, moyo atapowa ando atokale leane pua teke, balana piape wandakali Isatale tane tupa ondo wato moyo ando ateya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Wuane lalu, Matiya bala Elisambesa towa atu ana tepopi mindi pitiyu, bala andaka peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisambesa bala andopane mandulane ana oko epea-kola, balato iwana mindi mandeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mandea-kola, Elisambesana yamepi, wandakali mandaka atalaini tupapi, utupane-mane ale wato, Akali Andane okomane bala ondo apia ya lo, bala towa atu epele yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ole kitupasa pea-kola, wandakali utupane-mane iwana okonena yala-pene umbaini katulu epeainipia. Epoto, utupane-mane bala ayianena gene Sakataya lalaini pua teke lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wuane leai-kola, iwana okona angini okomane wandakali utupane lamawuato, jia, balana gene Jone lamakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wuane lea-kola, utupane-mane bala lamawuato, nimba yame akali gene Jone lene mindi ata napeya okonde leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wuane loto, utupane-mane Sakataya ando kii-mane mandeke puato, iwana okona gene api lolape lo tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tipa peai-kola, balato kii-mane mandeke puato, pepa peyalaini selesa mindi mo giyapa leaipia. Selesa okone mo mayai-kola, balato iwana okona gene Jone lo pepa peleaipia. Pelea-kola, wandakali utupane-mane gene peleane oko andoto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Okone angi teke, Sakatayana ambulini lumbea-kola, balato Gote epelewa tama peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wuane pea-kola, wandakali yuu ongane ateaini tupamane mangene okone andoto, yuku yainipia. Jutiya disitiki wangiane tupana wandakali atalaini tupa pitaka-mane pii okone ale wato, lo tawe yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pii okone ale yaini wandakali pitaka-mane nembo kambua toto, Akali Andane okomane iwana okone moyo atola-kola, matili iwana okonemane anu pulu-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oli Sipitisa oko iwana okonena ayiane Sakatayanga epo tumbi lea-kola, balato potopesa pii mindi wua leaipia: ");
INSERT INTO ipi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","72","Wamba Gotena potopesa akali tupamane balana potomisa pii mindi nanimana yumbane tupa lamawuato, wandakali-mane yakama towa yamapane koo wete palu atoto, yakama towa yanda-pene gulo atolai-kola, nambato yakama molo-peke lolopeyo leane leainipia. Wamba Goteto wuane leane pua teke, andipa balato potomisa pii leane okone nembo tolo-peke loto, nanimana yumbane tupa ondo wato moyokale nembo teya-ko. Balato kiŋi Dapiti yame okona akali tai wete mindimane nanima molo-peke leakale lapia. Akali okonemane balana wandakali andolo epoto, nanima kambo molo-peke lolo ipupia. Balato wuane pipia okonena, nanimato Isatale tane wandakali tupana Akali Andane Gote oko lo tama pimakale. ");
INSERT INTO ipi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Nanima yuku naene atoto, ole dindi lo balana mana epene tika-pene tupa wato minuto, balana piape tupa pimawua atape-pene. Nanimato wuane pua atape-pene nembo toto, wamba Goteto nanimana yumbane Apatakame lamawuato, enene wetete nambato yakama towa yanda pua atalaini wandakali tupa peyo watalu, yakama molo-peke lokale. Wamba Goteto wuane leane loto, Sakatayato pii okone leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","79","Wuane lalu, Sakatayato bala iwanane Jone andayo, pii mindi loto, yuunga wandakali nanima undupi pangosa atoto, omolomane lo yukuwa atalamane leaipia. Yukuwa atolomane nembo toto, Goteto nanima ondo wato, ati kenga tawe tii-pene okomane asia epene oko nanima andawa lolo epeakale lolopeya. Goteto nanima ondo wato, nanimana koo tupa apialane. Gotena wandakali tupamane balana mana okone andeakale loto, iwanaŋa Jone nimbato wandakali tupa mana lamawua atolopele. Akali Andane oko bala epeakale loto, asini mandeke puyale, nimba ingane ini poto, piape okone pulupele. Tene okonena, wandakali tupamane loto, nimba Gote ati kenga ateya okona potopesa akali atele lolopeyai. Sakatayato bala iwanane Jone andayo wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Matili iwanane okone anda ya-kola, balana nembo-tene tai leaipia. Isatale tane wandakali tupana wenonga balato piape pulane oto oko naepea-kola, bala wandakali napalene yuu tupana poto ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Sisa Okasatasa bala Lomo tane gapomane akali kawane ateane-angi, balato mana mindi yata wato, yuu pitakana atalaini wandakali tupa yakamana yuu tene tupana poto, gene yalapape leaipia. Akali Saitiniasa lene oko bala Sitiya potopinja okona gapomane akali kawane ateane okone angi bulupane tewa, wandakali pitaka yakamana gene yoyale, yakamana yuu tene tupana puku peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josepe bala kiŋi Dapiti yamena mandiyene mindi ateaipia. Jutiya disitiki tano Beselekeme Dapitina yuu tene oko yaepia. Tene okonena, Josepe bala bakale lene wana mapokae Matiya towa atu Galili disitiki tano Nasatesa oko tepa alu, liyambana gene Beselekeme tano okona yolo peapelepia. Matiya bala andopane mandipe-pene petea-kola, liyamba peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Peapi-kola, wandakali opene epo paliyaini anda tupa pitaka tumbi lea-kola, liyamba bulumako anda mindina poto, peteapele-pia. Anda okonena peteapi-kola, Matiya bala andopane mandulane gii oko epea-kola, balana iwana bulupane oko mandeaipia. Manduto, Matiyato andopane okone lapalapa-mane kau puato, bulumako tomo nalaini bokisa mindina yata yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yuu ongane teke utulu okona yia sipisipi yatawa atalaini akali minditupa-mane yakamana yia sipisipi tupa yuu maliwa mindina yatawa ando ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ateai-kola, Gotena enjole mindi akali utupane ateainga epea-angi, Gotena tii-pene okomane akali utupanenga tii pikoyo pea-kola, akali utupane-mane okone andoto, yuku andane wete yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Yuku yai-kola, enjole okomane utupane lamawuato, yakama yuku naene kondalapa leaipia. Andipa Dapitina tano okona pituto, wanda mindimane yakama molo-peke lolane iwana oko mandiya. Iwana okonena gene oko Kataisa. Bala nanimana Akali Andane. Nambato pii epene oko yakama langulu epeyo okomane wandakali pitaka mo epele aya olopeya. ");
INSERT INTO ipi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yakamato iwana okone ayia pima poto andolai-kola, bulumako tomo nalaini bokisa mindina bala lapalapa-mane kau pitane pangulanga andolopeyai. Iwana okone andolai-angi, pii nambato leyo okone enene ya lo yakamato nembo tolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Enjole okomane pii okone lo koyo pea wete, enjole kambua wete ati kenga atala, kapoyale epoto, bala towa atu atoto, Gotena gene oko laiyu lo, tama peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Tama puato, Gote ati kenga ateya okomane wandakali balana yame ateakale lo lata yane tupa towa epele wato, yakamana yamapane mo epene pale leya-ko. Balana gene oko laiyu lo atalapape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Enjole utupane ati kenga peke leai-kola, sipisipi yatawa atalaini akali tupamane yakama teke-teke pii lalawa puato, mangene mindi piya lo, Goteto nanima lapanawa langiya oko nanimato Beselekeme tano okona andolo maa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wuane lalu, akali utupane taimane poto andeai-kola, Josepe Matiya-lamane iwanaŋa oko bulumako tomo nalaini bokisa okona paleakale peteapinga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Andoto, enjole okomane matili iwanaŋa okomane wua pulupeya lo pii leane oko sipisipi yatawa atalaini akali tupamane lapana yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lapana yai-kola, pii okone ale yaini wandakali tupa pitaka-mane nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Matiyato pii utupane pitaka ale wato, balana yamapanenga mo yata wato, nemboto peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipisipi yatawa atalaini akali tupamane minditaka lee-mane andeaini tupapi, pii ale yaini tupapi, utupane pitaka nembo toto, Gotena gene oko laiyu loto, tama pima yakama peke leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Matiyato Jisasa mandu yatawa petea-kola, ole kitupasa peaipia. Ole kitupanena iwanaŋa oko bala Juta yame guleakale loto, balana yala-pene umbaini katu apolane oto oko epeaipia. Epea-kola, wamba Jisasa bala Matiya ininga piti napea-kola, enjole okomane iwanaŋa okona gene lalapape leane pua teke, balana gene Jisasa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Gotena loo pepa pelene eya okomane pii mindi loto, wanda-mane andopane mindi mandula-angi, Gotena wenonga okonelapo kalato atalapele layene eya. Okone-lapona kalato kunu apolane oto oko epola-angi, pitisa akali okomane liyambana kalato atolane tupa kunu apia-geakale lo eka itapuluma lapo yandopi, uya andopane lapo yandopi, mindi opa Gote maiyapape layene eya. Gotena loo pepa pelene eya waka mindimane loto, iwana bulupane mandulai oko manduto, Gote maipe-pene layene eya. Wuane layene eya pua, iwanane angini-lana kalato kunu apolane oto oko epea-kola, Matiya Josepe-lamane Gotena mana Mosesato pepa peleane oko wato minuto, Jisasa bala Gotena lapakale loto, bala mandiyu, Jutusaleme peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Okone angi, akali Simiyone lene mindi Jutusaleme tano okona ateaipia. Oli Sipitisa oko balanga atea-kola, Simiyone bala akali epene tika-pene mindi atoto, Gote lo pote lalaepia. Wamba Oli Sipitisa okomane Simiyone lamawuato, nimba ini oma napulupele. Gotena iwanane Kataisa oko andalu, omolopele leaipia. Wuane lea-kola, Isatale tane wandakali mini kendawa ateyai tupa Kataisato moyolo epolopeya lo, Simiyone bala maliyo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maliyo ateaneko, alu mindi Oli Sipitisa okomane akali Simiyone balana nembo-tene oko mina ika laya ya-kola, bala lotu anda andane okona kolandaka leaipia. Okone angi, Gotena loo okomane layene yene pua pipakale nembo toto, Jisasana angini ayiane-lamane bala awua, lotu anda andane okona kolandaka leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kolandaka leapi-kola, Simiyoneto Jisasa ope lo moto, Gote lo tama peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","Tama puato, Ayiane Gote, wamba nimbato molo-peke lolane akali mindi epeakale lokale lee leaipia. Andipa nimbato akali okone wandakali pitakana wenonga epeakale lele oko namba nimbana piape akali okomane lee-mane andalu, mini epene paleyo-ko. Andipa namba omewando, okone katu. ");
INSERT INTO ipi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ale mindi awua peyama-kola, ale tii peya okomane asia andawa lalane. Wuane pua teke, Jisasato nimbana asia epene oko wandakali yame waka tupanga andawa lolopeya. Bala Isatale tane ateya okonena, Isatale tane wandakali tupana gene andane yolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simiyoneto Jisasa andayo pii utupane lea-kola, Matiya Josepe-lamane nembo kambua teapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nembo kambua teapi-kola, Simiyoneto pote loto, Gote nimbato wandakali okolapo moyape leaipia. Wuane lalu, balato Jisasa angini Matiya lamawuato, matili iwanaŋa oko anda yoto, Gotena piape pua atolopeya leaipia. Gotena piape pua atola-kola, Isatale tane wandakali kambua-mane bala akali koo mindi ya lolai-kola, utupanena nembo-tene koo tupa panakame yolopeya. Panakame yola-kola, nimbana yamapanenga yandate atene gulo tandaka pulupeya. Matili Jisasato Gotena piape pua atoto, nembo-tene koo palene wandakali utupane yuunga peakeakale laya wato, Isatale tane wandakali kambua minditupa ika laya olopeya. Wuane peakale nembo toto, Goteto bala epeakale lapia. Simiyoneto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Okone angi potopisa wanda gene Ana lene mindi lotu anda okonena peteaipia. Bala Asa yame Panule lene okona wanane peteaipia. Wamba bala mapokae pitiyu, akali poto, mali yanasa angu akalini towa peteapi wete, balana akalini oko omeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Omea-kola, bala wanda yalo pituto, utulu otongapi, Gotena piape tupa pimawua piti-yaepia. Ole minditupa balato tomo nanene pitiki puato, ole dindi lo lotu anda andane okona poto, pote lo piti-yaepia. Mali paiyasa kitupasanga tukumindi pea-kola, wanda okone bala mini-yene wete peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ee ana kambua wete Lomo tane gapomane okomane Jutusaleme tane wandakali tupa taimane bosa lo ando atea-kola, Jutusaleme tane wandakali tupamane utupane embo wato, Mesaya okomane yakama moyolo epeakale lo mali yo ateainipia. Jisasana angini ayiane-lamane bala awua epeapele-angi, potopesa wanda Ana okomane bala andoto, Gote ando wayu pele leaipia. Wayu pele lalu, potopesa pii mindi Mesaya oko maliyo ateaini wandakali tupa lamawuato, matili iwanaŋa oko anda yola-angi, balato yakama molo-peke lolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Matiya, Josepe-lamane Gotena loo okomane piyapape layene tupa pitaka pikoyo piyu, Galili disitiki okona poto, liyambana Nasatesa tano okona peke loto peteapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Peteapi-kola, Goteto iwanaŋa okone epelewa moyo ando atea-kola, bala anda yoto, mana kambua mialu, iwana wai-ene tai mindi ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wamba Isatale tane wandakali tupamane Pasopa tomo oko no ateai-kola, enjole okomane Isipi tane wandakali tupana iwanane bulupane tupa peyo ome loto, Isatale tane wandakali tupana iwana bulupane tupa peyo ome nalene konda yaepia. Wamba Goteto wuane peane nembo toto, mali dindi lo Pasopa tomo nalaini oto okone epea-kola, Jisasana angini, ayiane-lamane atu Jutusaleme puku piyapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Matili Jisasa mali alesa penenga, Pasopa tomo nalaini oto okona mana yene okone wato minuto, Jisasa bala angini, ayiane-la towa Jutusaleme peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Pasopa tomo nalaini gii koyo pea-angi, Jisasa angini ayiane-lamane liyambana amenepi, yamepi, wandakali kambua utupane towa Jutusaleme tepa alu, ole mindiki asini peainipia. Okonelapo-mane Jisasa atu andaka peyama nembo teaini tekeko, bala wandakali utupane towa atu asini puu napene, Jutusaleme tano okona ateaipia. Atea-kola, matili ole lene balana angini, ayiane-lamane bala liyambana yamepi, amenepi, utupane towa atu epalaipe lo ayia peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jisasa bala liyamba yame tupa towa atu ata napea-kola, angini ayiane-lamane Jutusaleme tano okona ayia pulu-peke leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Bala ayia pua ateapi-kola, ole lapo peaipia. Ole teponena angini, ayiane-lamane Jutusaleme lotu anda andane okona kolandaka loto andeapi-kola, Jisasa bala mana lalaini akali tisa tupana tombenenga peteanga andeapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Andeapi-kola, balato akali utupanena pii leaini tupa ale wato, pii minditupa tipa pita piki pua peteaipia. Bala mana andene akali gulo atoto, pii kuai lo wete lea-kola, wandakali balana pii ale yaini tupa pitaka-mane moko loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jisasa bala mana lamayaini tisa tupa towa pii lo ateanga andoto, angini ayiane-lamane moko andane teke leapelepia. Moko loto, Jisasana angini-mane bala lamawuato, iwana, nimba ayiane nalipa yamapane kendawa, nimba ayia pua ataipa-ko. Tene anu pipia-kola, nimba nalipa towa andaka atu makale ipu napene, wali mee atapipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wuane lea-kola, Jisasato okonelapo lamawuato, anu peakale liyambato namba ayia pua atapiapipe. Namba ayiane okona andaka namba atolopeya nembo na-tapiapipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wuane lea-kola, bala angini ayiane-lamane pii balato leane okonena tene oko nembo nateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Okone angi, Jisasa bala angini, ayiane-la towa Nasatesa yuu okona peke loto, okonelapo-mane pii leapele tupa wato minu atea-kola, Matiyato Jisasana pii leane tupapi, mana mineane tupapi, utupane pitaka balana yamapanenga yakale lo, nembo tatawa peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisasa bala anda yama-yama, mana mima-mima pea-kola, Gotepi, wandakali tupapi, utupane pitaka-mane bala epele wete yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Wamba Pondiasa Pailateto Jutiya disitiki oko ando ateane okone angi, Laisaniasa balato Apilini disitiki oko ando ateaipia. Etoteto Galili disitiki oko ando atea-kola, balana amene Pilipito Tekonaitasa, Itulia-la, disitiki okonelapo ando ateaipia. Anasa, Kayapasa-la, okonelapo liyamba Gotena pitisa akali kawane ateapele-pia. Sisa Taipi-tiasa bala ee ana paiyasanga yau Lomo tane gapomane akali kawane oko atea wete, Sakataya iwanane Jone bala wandakali napalene yuu tupana atea-kola, Goteto bala lamawuato, nimbato nambana pii oko wandakali tupa lamawua atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","6","Wamba potopesa akali Aisayato Gotena pii mindi pepa peyoto, matili akali mindi wandakali napalene yuu okona atoto, pii taimane lolopeya leaipia. Pii okone loto, yakamato Akali Andane oko epolane asini mindi mandeke pua yata mawuato, bala epolane asini aŋako tupa peya tika piyapa. Yuu wangiane aŋakopi, andanepi, utupane ayoto, yuu yuli-yene tupa pulu pua, momowa piape piyapape. Asini liki leka-ene tupa pitaka peya tika piyapape. Asini kikua-pene tupa pitaka waa piyapape. Yakamato wuane pulai-kola, Goteto wandakali tupa molo-peke loyale piape pula oko wandakali pitaka-mane andolopeyai leaipia. Aisayato wuane leane pua teke, matili ipa peya-maiyane akali Joneto ipa Jotane matenenga yuu yane tupa pitakana poto, wandakali tupa lamawuato, Goteto yakamana koo piyaini tupa apia-geakaleko. Yakama mini peke loto, ipa mialapa lo lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ipa mialapa lea-kola, wandakali kambua-mane nanima ipa peya-gii lama epeainipia. Wandakali utupanena minditupa-mane yamapane peke nalene, mee ipa peya-gii lama epeai-kola, Joneto utupane laiya loto, yakama etelu gepo-mane mandiyene yame ateyai leaipia. Goteto yakama towa yataka wato, kenda-pene minditupa yakama gulupeya. Apito pii okone yakama langipia-kola, Goteto kenda-pene okone yakamanga epeakale lolane lo yuku wato, yakama palaka epoto, ipa mia-makale leyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","9","Goteto ana oo eya utupa Apatakame yame gulalapa leando, ana utupa-mane katulo Apatakame yame gulolo-peyai. Tene okonena, yakama teke-teke pii lalawa puato, nanima Apatakame yame ateyama-ko. Goteto nanima towa yataka wato, kenda-pene mindi gii napulu-peya lolaini andalapape. Goteto yataka wato, ita koo tupa yokowa apoyale, uu mindi ita tenenga yata yane eya. Ita dini epene lia napene tupa pitaka balato yoko wato, itanga yangolo-peyako. Ita epene tupamane dini epene lialaini pua, yakama mini peke loto, mana epene tupa wato minalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Joneto wuane lea-kola, wandakali kambua epo amunguli peaini tupamane Jone tipa puato, wuane yando, nanimato mana epene andoko wato minamape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wuane leai-kola, Joneto utupanena pii leaini okone yano peyoto, singilisa lapo yolane wandakali okomane singilisa nayene atolane wandakali okone tale pua maipe-pene. Tomo no atolane wandakali okomane balana tomo tale puato, minditupa tomo nanene nonowa atola wandakali oko maipe-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wuane lea-kola, takisa muni mialane akali ipa molo epeaini tupamane Jone tipa puato, tisa, nanima anu pimape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wuane leai-kola, balato utupane lamawuato, gapomane okomane takisa muni oko tuma mialapape lola pua, yakamato moto, minditupa konda pua molaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wuane lea-kola, ami yanda yene minditupa-mane bala tipa puato, nanima anu pimape leainipia. Wuane leai-kola, balato utupane lamawuato, yakamato wandakali tupa peyoyale puato yandopi, owato kote loto yandopi, utupanena minditaka tupa pake gulo mia na-piyapape. Yakamana piape pulai okona yole gulai tupa moto, okone atu ya nembo talapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Joneto wuane lea-kola, wandakali pitaka-mane akali oko bala Kataisa epolopeya lo maliyo ataima okope, wakape, lo nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wuane nembo teai-kola, Joneto utupane pitaka lamawuato, akali mindi epolopeya okonena tai-lene okomane nambana tai-lene oko sia minulu-peya leaipia. Balana sukee pula okona eyaka tinga lolane namba akali epene mindi jia. Nambato ipa-mane yakama ipa peya-geyo tekeko, akali matili epolopeya okonemane Oli Sipitisa okola, ita kaiyapiane okola, okonelapo-mane yakama ipa peya-gulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Balato witi dini epene tupa balana andaka yatawakale nembo toto, witi imbuni tupa aki pua apoyale, sapolo mindi awua epeya. Balato witi dini epene tupa balana andaka yata wato, witi imbuni tupa ita too koyo napiyane mindina yangolo-peya. Joneto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","22","Wandakali tupa pitaka ipa meai-kola, Jisasapi ipa mialu, pote lo atea wete, ati iyu oko yapu lo toko lea-kola, Oli Sipitisa oko eka uya gulo, balanga epo tepa yaepia. Epo tepa ya-kola, pii layene mindi ati kenga atala epeane okomane loto, nimba nambana iwanane yamapane yene oko atele. Nambato nimbana mana tupa andoto, epele wetete eyo leaipia. Matili, ipa peya-maiyane akali Joneto Gotena pii layene epene oko wandakali tupa lamawuato, pii mana kambua lamawua ateaipia. Okone angi, Gapomane akali andane Etote okomane bala amene okona wetene Etoti-yasa oko tondo moto, kee lalu, mana koo waka-waka kambua minea-kola, Joneto Etote lamawuato, nimbato mana koo kambua minele tupa kondaa leaipia. Wuane lea-kola, Etoteto mana koo mindi tako pua minuto, Jone andi leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Wamba yuu ati-la ungi leane-angi, Goteto Atame waa peaipia. Waa pea-kola, Atameto Sete mandeaipia. Seteto Inosa mandeaipia. Inosato Kenana mandeaipia. Kenanato Mala-lili mandeaipia. Mala-lilito Jateta mandeaipia. Jatetato Inoko mandeaipia. Inokoto Metusala mandeaipia. Metusalato Lameke mandeaipia. Lameketo Nowa mandeaipia. Nowato Sema mandeaipia. Semato Apasata mandeaipia. Apasatato Kenana mandeaipia. Kenanato Sela mandeaipia. Selato Epa mandeaipia. Epato Peleke mandeaipia. Peleketo Leyu mandeaipia. Leyuto Setuku mandeaipia. Setukuto Neto mandeaipia. Netoto Teta mandeaipia. Tetato Apatakame mandeaipia. Apatakameto Aisake mandeaipia. Aisaketo Jekopo mandeaipia. Jekopoto Juta mandeaipia. Jutato Petesa mandeaipia. Petesato Esotone mandeaipia. Esotoneto Ani mandeaipia. Anito Atamina mandeaipia. Ataminato Aminatape mandeaipia. Aminatapeto Nasone mandeaipia. Nasoneto Salamone mandeaipia. Salamoneto Boasa mandeaipia. Boasato Opeta mandeaipia. Opetato Jesi mandeaipia. Jesito Dapiti mandeaipia. Dapitito Netane mandeaipia. Netaneto Matata mandeaipia. Matatato Mena mandeaipia. Menato Melea mandeaipia. Meleato Elaya-kimi mandeaipia. Elaya-kimito Joname mandeaipia. Jonameto Josepe mandeaipia. Josepeto Juta mandeaipia. Jutato Simiyone mandeaipia. Simiyoneto Lipai mandeaipia. Lipaito Matate mandeaipia. Matateto Jotimi mandeaipia. Jotimito Eliyesa mandeaipia. Eliyesato Jasua mandeaipia. Jasuato Eta mandeaipia. Etato Elema-tame mandeaipia. Elema-tameto Kosame mandeaipia. Kosameto Atai mandeaipia. Ataito Melekai mandeaipia. Melekaito Netai mandeaipia. Netaito Siatele mandeaipia. Siateleto Setapa-pele mandeaipia. Setapa-peleto Lesa mandeaipia. Lesato Jonane mandeaipia. Jonaneto Jota mandeaipia. Jotato Joseke mandeaipia. Joseketo Semene mandeaipia. Semeneto Mata-tayasa mandeaipia. Mata-tayasato Meata mandeaipia. Meatato Nakai mandeaipia. Nakaito Esili mandeaipia. Esilito Neame mandeaipia. Neameto Emosa mandeaipia. Emosato Mata-tayasa mandeaipia. Mata-tayasato Josepe mandeaipia. Josepeto Janai mandeaipia. Janaito Melekai mandeaipia. Melekaito Lipai mandeaipia. Lipaito Matate mandeaipia. Matateto Eli mandeaipia. Elito Josepe mandeaipia. Wandakali minditupa-mane Jisasa bala Josepe iwanane ateya ya lo nembo teainipia. Jisasa bala mali paiyasa tepo atoto, piape bulupane tewa peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oli Sipitisa oko Jisasanga epo tumbi lea-kola, bala ipa Jotane oko tepa alu, peke leaipia. Peke lea-kola, Oli Sipitisa okomane bala atu aiyu, wandakali napalene yuu mindina peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","3","Poto, ole paiyasa tukumindi Oli Sipitisa oko bala towa atu epoko pua atea-kola, Jisasa bala ulia nanene atoto, nono wetete yaepia. Ulia nono wetete ya-kola, Sataneto bala minu mandeke puato, nimba Gote iwanane ateendo, ana oo eya oko betesa guleakale laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wuane lea-kola, Jisasato balana pii okone yano peyoto, tomo-mane angu wandakali mindi saka ateakale lo ataya na-alane lo pepa pelene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wuane lea-kola, Sataneto Jisasa atu aiyu ati andane iyu kenga wete mindina poto, okone angi teke yuu andane yane tupa pitaka balanga andawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Andawa loto, balato Jisasa lamawuato, wamba Goteto yuu eya tupa pitaka namba giyu atoto, nimbato yuu utupa wandakali mindi mauwakale nembo tole pua maipe leane-ko. ");
INSERT INTO ipi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Andipa nimbato namba lo lotu leendo, nambato yuu eya utupane pitaka nimba gukale. Guluwa-kola, yuu utupa nimbana yola-kola, nimbato utupane ando atolopele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimbato nimbana Akali Andane Gote oko angu lotu lo atoto, balana piape pimawua atape lo, pepa pelene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Jisasato wuane lea-kola, Sataneto bala atu aiyu Jutusaleme poto, lotu anda andane okona kenga wete ate leaipia. Ate lalu, balato Jisasa lamawuato, Gotena pii pepa pelene eya mindimane loto, ana-mane nimbana kee nolane nembo toto, Goteto balana enjole tupa lamawuato, yakama kii wanga latawa atalapa lolopeya layene eya-ko. Enene, nimba Gotena Iwanane ateendo, anda kenga wete okona atoto, peaka nena laa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wuane lea-kola, Jisasato Satanena pii okone yano peyoto, nimbato nimbana Akali Andane Gote oko minu mandeke napipe layene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wuane lea-kola, Sataneto Jisasa minu mandeke pikoyo piyu, bala tepa alu poto, alu mindi bala lapone mandeke pukale lo maliyo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Oli Sipitisa okomane Jisasa minu tai laya ya-kola, bala Galili disitiki okona peke loto, Juta yamena lotu anda tupana poto, pii mana lamawua ateaipia. Pii mana lamawua atea-kola, balana pii ale yaini wandakali tupa pitaka-mane balana gene oko laiyu loto, Jisasato wua lapia leai-kola, Galili disitiki okona wandakali ateaini tupa pitaka-mane ale yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Matili Jisasa bala yuu okone tepa alu, Nasatesa peke leaipia. Wamba Jisasa bala aŋakonga tano okonena atoto, anda yaepia. Sambasa dindi lo bala Juta yamena lotu anda okona palane pua poto, alu mindi balato Gotena pii mindi dii loyale ika leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ika lea-kola, lotu anda ando atalane akali okomane potopesa akali Aisayato pepa peleane buku yane oko bala mo mayaepia. Maya-kola, Jisasato buku okone opimi loto, pii mindi ayia pua andoto, wandakali tupamane ale yakale dii loto, wua leaipia: ");
INSERT INTO ipi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","Wamba Akali Andane Gote okomane namba languato, Akali Andane okomane balana wandakali tupa moyokale nembo toto, oto mindi wamba yata yane oko andipa epeya loto, nimbato wandakali tupa pitaka lamalu puu leaipia. Nimbato nambana pii layene epene oko wandakali tipia tupa lamawua atape. Nimbato wandakali lee koo tupa lamawuato, Goteto yakamana lee epene talapa leya lape. Nimbato wandakali andi latane paleyai tupa lamawuato, Goteto yakama tinga lo molo-peke leya loto, wandakali utupane tinga lo molo-peke lape. Goteto wuane lape lea-kola, balana Sipitisa oko nambanga eya. ");
INSERT INTO ipi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisasato pii okone dii loto, buku okone leka wato, ando atalane akali okonga malu-peke leaipia. Malu-peke lalu, balato pii dii leane okona dini tupa lamauwakale lo petea-kola, lotu anda okona wandakali peteaini tupa pitaka-mane bala angu andatawa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Andatawa peteai-kola, balato utupane lamawuato, Gotena pii layene, nambato dii lalo oko andipa enene guleya lalu, pii okonena tene oko utupane lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pii okonena tene oko kuai lo lamaiya-kola, wandakali peteaini tupamane moko andane loto, balana gene oko laiyu leaini tekeko, akali mindimane loto, akali oko bala Josepe iwanane piako. Balato pii epene utupa anu pua leyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wuane lea-kola, Jisasato utupane lamawuato, matili yakamato namba ando pii kokoli mindi lolopeyai leaipia. Kokoli okone loto, yakamato nimba dokosa atalene piako lolopeyai. Nimba tanena siki oko mo atu yaa. Wamba nimba Kapaneame tano okona atoto, piape andane peene tupa nanimato ale aima. Andipa nimbana yuu tene okona atele-angi, nimbato piape andane peene utupane lapone pulu-peke laa lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nambato pii enene mindi yakama langeyo. Potopesa akali mindimane balana yuu tene okona atoto, Gotena pii lamaiya-kola, wandakali utupane-mane balana pii ale wato, akali oko bala potopisa akali ya lo anda na-piyaini. ");
INSERT INTO ipi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Wamba potopesa akali Ilainjato Isatale yuu okona piape pua ateane-angi, mali teponga ana wataka kingi naepene, panyu angu pea-kola, ulia nono andane mindi yaepia. Okone angi, Isatale yuu okona wanda yalo kambua peteaini tekeko, wanda yalo utupanena mindi peteanga Goteto Ilainja bala peakale naleaipia. Jia. Wanda yalo mindi Saitone yuu okona tano aŋako Satepata lene okona petea-kola, Goteto Ilainja bala wanda yalo okone peteanga peakale leane lo nambato yakama enene langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Wuane pua teke, potopesa akali Ilaisato piape pua ateane-angi, Isatale tane wandakali tapa-pene kambua ateaini tekeko, Goteto Isatale tane wandakali tapa-pene utupanena mindi mo kuai nalene kondoto, Sitiya tane akali tapa-pene gene Nemane lene oko angu mo kuai leane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisasato wuane lea-kola, lotu anda okona wandakali peteaini tupa pitaka-mane balana pii leane tupa ale wato, bala towa yataka andane wete yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","Yataka wete wato, wandakali utupane-mane ika loto, Jisasa nimba Nasatesa tano okona ata napene puu lo wata takita leainipia. Tano oko yuu wangiane mindina ya-kola, wandakali utupane-mane Jisasa ati okonena minu pende lamakale nembo toto, bala atu aiyu peaini tekeko, bala utupanena tombenenga langatete piyu peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Okone angi, Jisasa bala Galili disitiki tano Kapaneame okona puu nena leaipia. Sambasa-angi, balato Juta yamena lotu anda okona kolandaka loto, Gotena pii mana tupa lamawua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wamba Goteto bala lamawuato, nimbato nambana pii mana lamawua atape leane pua teke, balato mana kuai lo lamawua atea-kola, wandakali tupamane moko wete loto, nembo kambua teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Okone angi, akali sipitisa koo atene mindi lotu anda okonena peteane okomane pii taimane wete loto, ae, Nasatesa tane Jisasa nimba Gotena akali epene tika-pene wete atelenga nambato andeyawane leaipia. Nimbato nanimanga anu puyale epelepe. Nimbato nanima minu koyolo epelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wuane lea-kola, Jisasato bala laiya loto, nimbato pii nalene, akali oko tepa alu puu leaipia. Wuane lea-kola, sipitisa koo okomane akali okone minu koya napene, mee mo patawa yatalu, bala tepa alu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pea-kola, wandakali tupa pitaka-mane moko wete loto, yakama teke-teke pii lalawa puato, Jisasa bala akali tai mindi atoto, sipitisa koo tupa pulupa leya-kola, palaini yako. Anu pua, balato wuane piyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wuane loto, utupane-mane Kapaneame tano okona mandaka-yale yuu yane tupa pitakana poto, pii okone lo tawe yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisasa bala Juta yamena lotu anda oko tepa alu, Saimone andaka peaipia. Saimonena wanda imane oko siki omoto, umbaini toto andane wete pea-kola, wandakali tupamane Jisasa tipa puato, nimbato wanda oko moyolape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wuane leai-kola, Jisasato wanda okone mandaka poto, balana umbaini toto andane peane oko laiya lea-kola, umbaini toto andane peane okone atu yaepia. Atu ya-kola, okone angi teke wanda okone bala ika loto, utupanena tomo yanga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ole lene nai andaka poyale pea-kola, wandakali minditupa-mane yakamana yangone siki waka-waka pelene tupa Jisasa bala ateanga atu aiyu epeainipia. Wandakali siki pelene tupa mindiki-mindiki lo Jisasa ateanga atu aiyu epeai-kola, balato balana kini utupanenga yata wato, utupane mo atu yaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wandakali kambua tupanga sipitisa koo ateaini tupamane Jisasa bala Mesaya oko ateya lo andeai-kola, Jisasato sipitisa koo utupane peyo wateapia. Wato pelea-kola, utupane-mane wandakali utupane tepa wato, pii taimane loto, nimba Gotena iwanane atele leainipia. Wuane leai-kola, utupane-mane bala Mesaya oko ateya lo lapana olaini nembo toto, Jisasato sipitisa koo utupane laiya loto, yakamato pii kondalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Upa pitane nai peakata ya-kola, Jisasa bala Kapaneame tano oko tepa alu, wandakali ata napene yuu mindina pea-kola, wandakali minditupa-mane bala ayia pua andoto, bala ateanga peainipia. Poto, Jisasato utupane tepa alu, yuu waka mindina polane loto, utupane-mane bala minandi leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Minandi leai-kola, Jisasato utupane lamawuato, Goteto namba languato, nimba tano waka tupana poto, Goteto pitaka taka ando atalane oko wandakali tupa lamaipe lo namba langea-kola, nambato tano waka tupana poto, Gotena pii oko lamauwakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wuane lalu, Jisasa bala Jutiya disitiki okona poto, Juta yamena lotu anda waka-waka tupana kolandaka laka puato, Gotena pii lamaiki peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","3","Alumindi pisa mialaini akali minditupa-mane yakamana sipi okonelapo ipa angini Genesa-leta lene okona matenenga yakale tepa alu, yakamana pisa mialaini umbene nuu tupana kangalamu pata yane tupa tanda lo mo apo ateainipia. Okone angi, Jisasa bala ipa matene ongane atoto, Gotena pii lamawua atea-kola, wandakali kambua tupamane balana pii ale amakale lo, bala ateanga epoyale, mindi minu pitu-pitu pima epeainipia. Epeai-kola, pisa mialaini akali tupana sipi okonelapo ipa matene okona yanga andoto, Jisasa bala Saimonena sipi yane okona peakaiyu loto, Saimone, nimbato sipi oko aŋa ipa tombeka-yale pele pii leaipia. Saimoneto Jisasana pii ale wato, wuane pea-kola, Jisasa bala sipi okonena pituto, wandakali tupa pii mana lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Matili pii mana lamai koyo piyu, Jisasato Saimone lamawuato, yakamato pisa mialapale. Sipi okona pitiyu, ipa tombeka poto, umbene nuu tupa ipa okona tepa alapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Wuane lea-kola, Saimoneto balana pii okone yano peyoto, Akali Andane, andipa utulu nanima limu pali napene, ayiawa wete, pisa angu ayia pua atalama tekeko, nanimato pisa mindikipi mindi mia na-piyama leaipia. Pisa mia piyama tekeko, nambato nimbana pii oko wato minuto, umbene nuu tupa tepa olo peyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jisasato leane pua Pitapi, bala towa atu peape peaini akali tupapi, utupane-mane umbene nuu tupa ipanga tepa yai wete, pisa kambua wete umbene nuu tupana epo paleai-kola, umbene nuu tupa tumbi loto, lete loyale peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wuane pea-kola, piape piyaini akali sipi mindokona peteaini tupamane yakama moyolo epeakale loto, utupane-mane kii pundi peainipia. Kii pundi peai-kola, akali utupane epoto, sipi okonelapo lapotakana pisa mo mandeai-kola, sipi okonelapo ipa pangosa landa peyoyale peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Okone angi, akali Sepiti iwanane Jemesa, Jone-la, okonelapo Saimone Pita towa atu piape pua ateainipia. Saimonepi, bala towa atu ateaini akali tupapi, utupane pitaka-mane pisa kambua meaini tupa andoto, moko leainipia. Moko loto, Saimone bala Jisasa ateanga mandaka poto, aiki lekawa tombawua loto, Akali Andane, namba akali koo wete ateyo-ko. Nimbato namba tepa alu puu leaipia. Wuane lea-kola, Jisasato Saimone lamawuato, andipa ato tewa, nimbato wandakali tupa saka atapowa ateakale lo mo amunguli pula-ko. Nimba yuku olene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wuane lea-kola, utupane-mane sipi okonelapo kilau lo moto, ipa matenenga yata alu, minditaka yakamana yaini tupa pitaka ongane yakale leainipia. Yakale lalu, Saimone, Jemesa, Jone ima, Jisasa watama peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisasa bala tano mindina atea-kola, akali tapa-mane koyene mindimane bala andoto, aiki leka wato, tombawua leaipia. Wuane puato, balato Akali Andane, nimbato namba mo atu yokale nembo teendo, nimbato katulo wuane pulupele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wuane lea-kola, Jisasato balana kini akali okonenga yata wato, nambato wuane peyo-ko. Nimba atu yaa lea-kola, akali okonena tapa peane oko atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atu ya-kola, Jisasato akali okone lamawuato, nimbato Gotena pitisa piape piyane akali oko ateyanga poto, nimbana umbaini oko balanga andawa lape leaipia. Andawa lalu, Goteto nimbana tapa peane oko mo atu yapia lo wandakali tupamane andeakale nembo toto, opa maipe lo Mosesato leane pua maipe. Nambato nimba mo atu eyo oko nimbato wandakali mindikipi mindi lamai napipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Balato wuane leane tekeko, akali okonemane balana pii tanga loto, Jisasato bala mo atu yane lo pii lo tawe yaepia. Lo tawe ya-kola, Jisasato yakamana siki tupa mo atu yakale nembo toto, ole dindi lo wandakali kambua wetete balana pii ale olo ipuku peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Utupane ipuku peaini tekeko, ole kambuanga balato wandakali napalene yuu tupana pote lolo puku peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Alumindi Jisasato wandakali tupa mana lamawua atea-kola, akali Patasai tupapi, loo tupana mana andene akali tupapi, utupanena minditupa Jutusaleme tepa alu epoto, Jisasana pii alewa peteaini-pia. Dee, minditupa Galili, Jutiya-la, disitiki okone-lapona tano tupa pitaka tepa alu epoto, Jisasana pii alewa peteaini tekepia. Alewa peteai-kola, Goteto Jisasa minu tai laya ya-kola, balato wandakali siki pelene tupa mo atu yaka pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jisasato utupane mo atu yaka pua atea-kola, akali minditupa-mane akali kusuku mindi takeanga awua epoto, Jisasa ateanga anda-pango awua epoyale makande peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Makande peai-kola, wandakali kambua wete peteai-kola, akali okone anda-pango awua epolane asia mindi naya-kola, akali utupane-mane akali kusuku oko awua anda tokonga peakaiyu loto, anda yame pelene minditupa keao lo yata yainipia. Wuane piyu, takea okona eyaka atawa tepa wato, wandakali kambua ateaini tupa tombenenga bala takea okona yapata Jisasa ateanga tepa yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisasato andea-kola, akali utupane-mane balanga tungi peyoto, wuane peyai lo andeaipia. Andoto, balato akali okone lamawuato, amene, nambato nimbana koo tupa apeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisasato wuane lea-kola, loo tupana mana andene akalipi, Patasaipi, utupane-mane wua nembo teainipia: Goteto angu wandakali tupana koo piyaini tupa apialane-ko. Akali oko apito Gote ando lamba leyape nembo teainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Wuane nembo teyai lo andoto, Jisasato utupane tipa puato, anu peakale yakamato wuane nembo teyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nambato akali kusuku oko lamawuato, nimbana koo pilini tupa apeyo leyo oko piape pitete-pene mindi jia. Nambato bala lamawuato, nimba ika lalu, andaka puu loto, balana siki oko mo atu yewando, piape okone pitete-pene yolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wuane tekeko, Akalina Iwanane namba yuu okona atoto, wandakalina koo piyaini tupa katulo apialawane-ko. Yakamato okone andalapale nembo teyo leaipia. Wuane lalu, balato akali kusuku okone lamawuato, nimba ika lalu, nimbana takea toko mo awua andaka puu leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wuane lea-kola, okone angi teke, wandakali peteaini tupana wenonga akali okone ika lalu, balana panda mo aiyu, Gotena gene oko laiyu lama, bala andaka peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wuane pea oko andoto, wandakali pitaka-mane moko wete loto, Gotena gene oko laiyu loto, andipa nanimato mana epene waka wete mindi andeyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisasa bala anda okone tepa alu poto andea-kola, takisa muni mialane akali Lipai lene oko bala takesa muni mialaini anda okona peteanga andoto, namba watama ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wuane lea-kola, Lipai ika lalu, balana minditaka yane tupa pitaka yakale lalu, Jisasa watama peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lipai bala andaka poto, Jisasana tomo andane mindi yanga maya-kola, takisa muni mialaini akali kambuapi, wandakali wakapi, utupane Jisasa towa atu tomo no peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jisasapi, balana disaipolo tupapi, utupane-mane wandakali koo tupa towa atu tomo no peteai-kola, akali Patasaipi, loo tupana mana andene akalipi, utupane-mane mini koo paluto, Jisasana disaipolo tupa tipa puato, anu peakale yakamato takisa muni mialaini akalipi, koo piyaini akalipi, utupane towa atu tomo ipapi, no peteyaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, dokosa-mane wandakali siki napalene tupa mo atu yolane tene mindi ata napeya. Jia. Dokosa-mane wandakali siki pelene tupa angu mo atu yalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wuane pua teke, wandakali epene tika-pene tupa yamapane peke leakale lo namba na-epewane. Jia. Koo piyaini wandakali tupa yamapane peke leakale lo namba epewane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jisasato wuane lea-kola, Patasaipi, loo tupana mana andene akalipi, utupane-mane bala lamawuato, ole kambuanga Jonena disaipolo tupapi, Patasai tupana disaipolo tupapi, utupane-mane pote kambua loyale, ole ukupini mindi tomo nanene atalaini tekeko, nimbana disaipolo tupamane tomo ipapi naa teke-teke piyaini okonde leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Wuane leai-kola, Jisasato utupane tipa puato, akali mindimane wanda mindi kee loto, balana amene tupamane bala towa atu atolopeyai. Atolai-kola, yakamato katulo balana amene utupane lamawuato, yakama pote kambua loyale, ole ukupini mindilapo tomo nanene atalapa lolo-peyaipe leaipia. Okone angi, yakamato katulo wuane nalolo-peyai tekeko, matili akali minditupa-mane wanda kee lolane akali okone andi lo awua polopeyai. Okone angi, balana amene tupamane pote kambua loyale, ole ukupini mindilapo tomo nanene atolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wuane lalu, Jisasato pii kokoli mindi akali utupane lamawuato, wandakali mindina tona wambane okona asia titi mindi yola-kola, balato okone tambu lokale nembo toto, balana singilisa wenene okona aŋako mindi lete lo meando, balato tona wenene okone minu koyolo-peya. Dee, balato tona wenene okona aŋako mindi lete lo molane okone balana tona wambane asia titi yolane okone ataenge lo tambu leando, tona wenene lete lo aŋako mindi molane okone-la, tona wambane okone-la, okonelapo mindiki okonepene teke guu nalolo-peya. Jia. Tene okonena, wandakali mindikipi mindimane balana tona wenene lete lo aŋako mindi moto, balana tona wambane asia titi yene okonena ataenge lo tambu laa napiyane. ");
INSERT INTO ipi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dee, wandakali mindimane ipa waene wenene tupa ipa pene wambane meme umbaini-mane waa-pene tupana ambu pete leando, ipa waene wenene okonena popone-mane anda yoto, pene wambane okone tula lola-kola, ipa waene oko alu pulupeya. Wuane pulane nembo toto, wandakali mindikipi mindimane wuane napiyane. Jia. ");
INSERT INTO ipi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wandakali-mane ipa waene wenene tupa ipa pene wenene tupana ambu pete lape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ipa waene wambane nalaini wandakali tupamane waene wambane oko epene nembo toto, waene wenene oko naima lakae lo nembo natalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sambasa mindina, Jisasa bala witi ee tupana tombenenga epo peai-kola, balana disaipolo tupamane bala watama epoto, witi dini minditupa yo moto, imbuni kini-mane kokope lo apoto, angini tupa naka pima peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Wuane peai-kola, Patasai minditupa-mane andoto, Gotena loo okomane loto, Sambasa angi wandakali-mane piape napipe-pene leya-ko. Anu peakale yakamato loo okone ango wato, witi dini tupa moto, imbuni kini-mane kokope lo apeyaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gotena loo okomane loto, Gotena lotu anda okona betesa Gote maiyene yalaini tupa pitisa akali tupamane angu nape-pene layene eya leaipia. Wandakali waka mindimane betesa utupane naa na-piyapape layene eya tekeko, wamba Dapitipi, bala towa atu ateaini akali tupapi, utupane yakama ulia nono yai-kola, balato Gotena lotu anda okona kolandaka loto, betesa utupane mo noto, bala towa atu ateaini akali tupapi neakale mayane layene eya. Yakamato pii okone wamba dii lo anda napeaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wuane lalu, Jisasato utupane lamawuato, Akalina Iwanane nambato Sambasa oko bosa lo ando atalawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sambasa waka mindina, Jisasa bala Juta yamena lotu anda mindina kolandaka loto, wandakali tupa mana lamawua ateaipia. Okone angi akali kii tikasa-tole koo kapu-tene mindi lotu anda okonena peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Petea-kola, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane Jisasa kosimi lamakale nembo toto, Sambasa angi balato akali okone mo atu eyape lo andatawa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Utupane-mane bala kosimi lamakale nembo teyai lo andoto, Jisasato akali kii koo okone lamawuato, nimba wandakali peteyai tupana tombenenga ika lo ata lea-kola, akali okone ika lo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ika lo atea-kola, Jisasato wandakali peteaini tupa tipa puato, Gotena loo okomane aki leyape. Sambasa angi yakamato mana epene minalapape leyape. Pee, Sambasa angi yakamato mana koo minalapape leyape. Sambasa angi yakamato wandakali moyalapape leyape. Pee, Sambasa angi yakamato wandakali mindi minu koyalapape leyape lo nambato yakama tipa peyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wuane lalu, Jisasato wandakali peteaini tupa pitaka lee-mane anda amo nena piyu, akali okone lamawuato, nimbana kii oko yo laa leaipia. Akali okonemane Jisasato leane pua pea-kola, balana kii oko atu wete yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sambasa angi, Jisasato akali okone mo atu ya-kola, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane yataka-mane omoto, yakama teke-teke mindi lamai-lamai puato, nanimato bala towa anu pimape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ole mindina Jisasa bala yuu wangiane mindina pote lolo peaipia. Poto, utulu bala limu pali napene, pote angu lo atea-kola, waa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","16","Waa lea-kola, balana atu atene tupa epeakale loto, balato akali alesa yapa lo meaipia. Balato akali Saimone oko gene mindi Pita leaipia. Jemesapi, Jonepi, Pilipipi, Batolo-miyupi, Matiyupi, Tomasapi, Saimone amene Endutu okopi, Alipusa iwanane Jemesa okopi, Jemesa waka mindina iwanane Jutasa okopi, Selote yamena akali Saimone okopi, Jutasa Isaka-tiyote lene matili Jisasa ene peteane okopi, akali alesa utupane pitaka Jisasato yapa lo moto, gene aposolo akali leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","19","Jisasa balana disaipolo tupa towa yuu wangiane okone tepa alu, puu nena loto, yuu lama tika-pene mindina ateaipia. Atea-kola, solewata matenenga Taya, Saitone-la, tano okone-lapona tanepi, Jutusaleme tanepi, Jutiya disitiki pitakana tanepi, bala towa atu atalaini wandakali kambua wete balana pii ale olo epeainipia. Wandakali siki palene tupamane Jisasa wata yai-kola, Gotena tai-lene andane balanga paleane okomane utupanena siki tupa mo atu yaka peaipia. Wamba sipitisa koo tupamane wandakali minditupa minu koyaini tekeko, wandakali utupane-mane Jisasa wata yai-kola, sipitisa koo utupane-mane wandakali utupane tepa alu peai-kola, utupane atu yainipia. Tene okonena, utupanena siki tupa atu yakale nembo toto, wandakali siki pelene tupa pitaka-mane balanga wata aka puyale epeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wandakali kambua epo ateai-kola, Jisasato balana disaipolo tupa lamawuato, Goteto wandakali tipia yakama moyo ando ateya-ko. Yakama epelewa atape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ulia nonowa ateyai wandakali yakama matili ulia no embowa atolo-peyaiko. Yakama epelewa atape-pene. Ai lo ateyai wandakali yakama matili epelewa giwawa atolo-peyaiko. Yakama epelewa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Yakamato Akalina Iwanane oko bilipi lo atolai-kola, wandakali minditupa-mane yakama towa yataka andane wete wato, yakama ando meke pua, yakamana gene minu koyolo-peyai. Wuane puato, utupane-mane yakama nanima towa atu ata napimakale lo peyo watolo-peyai. ");
INSERT INTO ipi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wamba wandakali utupanena yumbane tupamane potopesa akali tupa minu koyainipia. Wuane pua teke andipa wandakali utupane-mane yakamapi minu koyaindo, yakama epelewa atape-pene. Yakamato Akalina Iwanane oko bilipi lo atolai-kola, wandakali-mane yakama minu koyaindo, matili yakama ati kenga yuu epene okona polai-angi, Goteto yole andane mindi yakama gulupeya nembo toto, yakama epelewa atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yakama epelewa atolopeyai tekeko, minditaka kambua yatawa ateyai wandakali yakama matili minditaka mindi mia napulu-peyama nembo toto, yakama mini kendawa atape-pene. Tomo kambua akenane yo peakale lo no ateyai wandakali yakama matili ulia nonowa atolo-peyama nembo toto, yakama mini kendawa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Epelewa, giwawa ateyai wandakali yakama matili mini kenda wato, ai lo atolo-peyama nembo toto, yakama mini kendawa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wamba wandakali pitaka-mane owato potopisa tupana gene tupa laiyu lo ateaini pua, andipa wandakali pitaka-mane yakamana gene tupa laiyu lo ateaindo, yakamapi owato potopesa akali ateyama lo mini kendawa atape-pene. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Wuane lalu, Jisasato balana pii alewa ateaini wandakali tupa lamawuato, yakamana yanda-pene tupa towa epelewa, yamapane yo atalapape leaipia. Wandakali mindimane yakama towa yamapane koo paleando, yakamato mana epene mindi wato minu, bala moyo atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wandakali-mane yakama ando pii koo mindi leando, yakamato utupane moyo pote lalapape. Wandakali-mane poto loto, Goteto yakama minu koyakale leaindo, Goteto utupane moyakale lo yakamato pote lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Akali mindimane nimbana wakenanenga peleando, yangisa wetete peleakale lo, nimbato mopeke lape. Akali mindimane nimbana sakesa oko meando, nimbana singilisa oko wetete meakale lo ando kondape. ");
INSERT INTO ipi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wandakali mindimane minditaka mindi nimbanga gii lo tee leando, nimbato okone maipe. Wandakali mindimane nimbana minditaka mindi meando, nimbato ole kambuanga yano peyo gii laa apo naene kondape. ");
INSERT INTO ipi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wandakali tupamane yakamanga mana epene mineakale nembo tolai pua, yakamatopi utupanenga mana epene teke minu atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","33","Wandakali mindimane koo piyaini wandakali tupa towa epelewa yamapane yo ateando, koo piyaini wandakali utupane-mane bala towa epelewa yamapane yo atalaini teke. Wuane pua teke, wandakali yakama towa epelewa yamapane yo atalaini tupa towa angu yakamato epelewa yamapane yo ateaindo, apito yakama ando, kuai lo peyai lolo-peyape. Wandakali mindimane koo piyaini wandakali tupa moyoyale, mana epene mindi mineando, koo piyaini wandakali utupane-mane balapi moyo, mana epene teke minalaini. Wuane pua teke, yakamato wandakali yakama towa mana epene minalaini tupa angu moyoyale, mana epene mineaindo, apito yakama ando, kuai lo peyai lolo-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Koo piyaini wandakali tupanena yangone tupamane minditaka mindi matili yakama geakale nembo toto, utupane-mane yangone utupanenga yano maiyaini. Wuane pua teke, yakamana yangone tupamane minditaka mindi matili yakama geakale nembo toto, yakamato yangone utupanenga yano mai-yaindo, apito yakama languato, yakamato kuai lo peyai lolo-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Gote ati kenga ateya okomane bala lo bilipi leyama nayu na-lalaini wandakali tupapi, koo piyaini wandakali tupapi, utupane pitaka ondo wato moyalane. Yakamana ayiane ati kenga ateya okomane wandakali tupa ondo alane pua teke, yakamato wandakali yangone tupa ondo wato moyo atalapape. Wuane puato, yakama towa yanda-pene wandakali tupa towa epelewa yamapane yo atoto, utupanenga mana epene tupa minalapape. Dee, matili wandakali mindimane yano peya-geakale nembo toto, minditaka mai napene, mee moyo maiyapape. Yakamato Gotena ondo ene mana okone wato mineaindo, yakama balana andopane gulo atoto, matili yakamato yole andane wete mindi molopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","38","Wuane lalu, Jisasato pii mindi tako pua loto, yakamato wandakali yangone mindinga mana minulai pua teke, Goteto mana okone teke yakamanga minulu-peya leaipia. Yakamato minditaka epene tupa nuu andane mindina tumbi laya wato, wandakali mindi mayaindo, Goteto minditaka epene tupa nuu okonepene teke mindina tumbi laya wetete wato, yakama gulupeya-ko. Yakamato minditaka epene kambua wandakali yangone tupa maiyapape. Yakamato kenda-pene mindi wandakali waka tupanga yata nayaindo, Goteto kenda-pene mindi yakamanga yata naolo-peyako. Wandakali yangone tupamane mana koo mindi yakamanga minulai-kola, paini yakamato kenda-pene mindi utupanenga yata na-alapape. Yakamato wandakali yangone tupana koo tupa apia-maiyaindo, Goteto yakamana koo tupa apia-gulupeyako. Yakamato utupana koo tupa apia-maiyapape. Yakamato wandakali yangone tupa koo ya lo yapa lo tale napeaindo, Goteto yakamapi koo ya lo yapa lo tale napulu-peyako. Yakamato utupane koo ya lo yapa lo tale na-piyapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","40","Wuane lalu, Jisasato pii kokoli mindi wandakali utupane lamawuato, mana kambua tisa tupanga eya-kola, mana aŋako teke sukulu-pai tupanga yalane leaipia. Wuane tekeko, matili sukulu pai mindimane mana kuai lo mia koyo puato, bala tisa yale teke atolopeya. Wandakali lee koo mindimane lee koo yangone mindi asia andawa lokale nembo toto, atu peapindo, balato katulo asia okone kuai lo andawa lolo-peyape. Jia. Wandakali okonelapo lapotaka kundu mindina ayia peyolo-peyapi. ");
INSERT INTO ipi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nimba amene mindina lenenga lee kunu aŋako mindi eya-kola, nimbato okone andoto, mo apokale lalene tekeko, nimba tanena lenenga ita palaŋa andane mindi eya-kola, nimbato okone mo apokale nembo natalene. Anu peakale nimbato wuane pilinipe. ");
INSERT INTO ipi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nimbana lenenga ita palaŋa andane eya-kola teke, anu peakale nimbato ita palaŋa okone anda napene atoto, nimbana amene oko lamawuato, amene, nimbana leenga lee kunu eya oko nambato mo apia-gua lalenepe. Wandakali-mane nimbana pii okone ale wato, nimbanga koo mindi naeya nembo teakale nayuto, nimbato wuane lele. Nimbana lenenga ita patepane andane mindi eya oko nimba tane wamba ini mo apiape. Apialu, nimba lee epene atoto, nimba amene okona lee kunu yola oko katulo mo apolopele. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","Wuane lalu, Jisasato pii mindi tako pua loto, ita gulu ani atene mindina yomboto dini mindi lia napiyane leaipia. Eyaka ikilimbu mindina butusa dini mindi lia napiyane teke. Wandakali-mane ita dini lula tupa andoto, ita oko epene ya, ita oko koo ya lo yapa lalaini. Ita epene mindinga dini koo mindi liya napiyane. Wuane pua teke, ita koo mindinga dini epene mindi liya napiyane. Wandakali mindimane minditaka mindi nembo tatawa atolane okone teke pii kambua lalane. ");
INSERT INTO ipi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wandakali epene tupana nembo-tene epene kambua paleya-kola, utupane-mane pii epene teke kambua lalaini. Wandakali koo tupana nembo-tene koo kambua paleya-kola, utupane-mane pii koo kambua teke lalaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","49","Wuane lalu, Jisasato pii mindi tako pua loto, akali mindimane namba ateyonga epoto, nambana pii oko alewa, wato minalane wandakali okone bala wua pene atalane loto, nambato pii kokoli mindi yakama langeyo-ko. Yakamato ale alapa leaipia. Akali mindimane balana anda puyale ato, anda pingina tai ateakale loto, yuli tombama nenanga peaipia. Tombama poto, anda pingina okone duli lo ate loto, anda okone pikoyo peaipia. Matili ipa lii andane mindi lua awua epoto, anda okone peyo keao loyale peane tekeko, anda pingina tai ateane okonemane anda okone duli lo minea-kola, ipa lii epeane okomane anda okone katulo lai naleaipia. Akali waka mindimane balana anda puyale anda pingina mindi ate laa napene, balana anda oko mee peaipia. Matili ipa lii andane mindi lua awua epoto, pingina ata napene anda okone pelea-kola, anda okone kapoyale lai leaipia. Anda okone koyane pua teke, nambana pii oko ale wato, wato mina na-piyaini wandakali tupa koyolo-peyaiko. Anu peakale yakamato mee pii-mane angu, namba ando Akali Andane, Akali Andane lo atoto, nambana pii leyo tupa wato mina na-piyainipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pii utupane wandakali tupa lamai koyo piyu, Jisasa bala Kapaneame tano okona peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tano okonena ami opisa mindimane akali andete mindiki ando ateaipia. Balana piape akali yamapane yalane mindi siki moto, omoyale peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Omoyale pea-kola, wandakali minditupa-mane Jisasa bala Kapaneame tano okona epo ateya leainipia. Wuane leai-kola, ami opisa okomane pii okone ale wato, Juta yame akali kawane minditupa lamawuato, Jisasato nambana piape akali oko mo atu yolo epeakale, yakamato bala lamalu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Wuane lea-kola, akali utupane-mane Jisasa ateanga poto, ami opisa okonemane Juta yame wandakali nanima towa yamapane yo atoto, balato nanimana lotu anda mindi pingipiane leainipia. Bala akali epene wete mindi. Tene okonena, nimbato balana pii okone ale wato, balana piape akali oko mo atu yeendo, nanima epele olopeyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Wuane lalu, akali utupane-mane Jisasa atu ami opisa okona andaka poyale amonga-yale epeai wete, ami opisa okomane balana yamapane yene akali minditupa lamawuato, yakamato Jisasa malanda olo poto, pii mindi bala lamai-yapape leaipia. Ami opisa okomane pii mindi nimba languato, Akali Andane, namba akali koo okomane nimba andolo epewando, okone kuai nalolo-peya lala lo lamai-yapape. Nimba akali epene wete oko namba andaka epeendo, okone kuai nalolo-peya teke lala. Akali mindimane namba ando atalane. Wuane pua teke nambato ami yanda yene minditupa ando atalawane. Nambato ami yanda yene mindi ando, puu leyo-kola, bala palane. Nambato ami yanda yene mindi epeakale leyo-kola, bala epalane. Nambana piape akali okomane piape mindi peakale leyo-kola, balato piape okone piyane. Wuane pua teke, nimbato nambana piape akali oko mee pii-mane atu yakale lole-kola, bala atu yolopeya-ko. Nimba masia-pene namba andaka epolene. Ami opisa nambato wuane lala lo, yakamato Jisasa lamalu pulupa lea-kola, bala towa yamapane yene akali tupamane poto, Jisasa lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lamai-yaikola, Jisasato nembo kambua toto, wandakali kambua bala watama epeaini tupa anda-peke loto, ami opisa okone bala Isatale tane mindi jia tekeko, balato namba bilipi leya pua, Isatale tane wandakali mindimane namba bilipi leainga nambato wamba anda napewane lo nambato yakama langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wuane lea-kola, Jisasa malanda olo epeaini akali tupa ami opisa okona andaka peke loto andeai-kola, balana piape akali omoyale peane okone saka peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Anate-lene Jisasapi, balana disaipolo tupapi, wandakali kambua minditupa towa tano Naini lene okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bala tano okonena lome andane asini kolandaka lalaini geta okona peakaiyu lea-angi, wandakali minditupa-mane iwana patane omene mindi mali puyale awua epeainipia. Wamba iwana okonena angini okomane iwana mindiki okone angu mandu ya-kola, balana akalini oko omeaipia. Omea-kola, bala wanda yalo piti-yaepia. Iwana patane omeane okone mali puyale, tano okonena tane wandakali kambua wete iwana okonena angini oko towa epeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Epeai-kola, Akali Andane okomane wanda yalo okone ondo wato, nimba ai nalene kondaa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wuane lalu, Jisasa bala iwana omene takeanga awua epeaini ongane mandaka poto, takea oko minea-kola, akali awua epeaini utupane-mane iwana omene oko mee aitawa ateainipia. Aitawa ateai-kola, Jisasato loto, iwana patane, nimba ika laa leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wuane lea-kola, iwana patane omeane okone ika lo peteaipia. Ika lo pituto, pii lea-kola, Jisasato iwana okone lamawuato, nimba angini towa puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jisasato iwana patane omene okone ika laya ya oko andoto, wandakali pitaka-mane yuku yainipia. Yuku wato, utupane-mane Gotena gene oko laiyu loto, Goteto balana wandakali tupa ondo wato, moyolo epeakale lapia-kola, potopesa akali andane mindi nanimana tombenenga epo ateya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wandakali-mane pii okone lo tawe yoto, Jisasato iwana omene okone ika laya ala leai-kola, Jutiya disitiki tanepi, yuu waka tanepi, wandakali utupane pitaka-mane pii okone ale yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jisasato piape utupane pua ateya-kola, wandakali mindimane ipa peya-maiyane akali Jonena disaipolo tupa lamai-yainipia. Jonena disaipolo tupamane bala lamai-yaikola, balato balana disaipolo lapo akali ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Akali okonelapo bala ateanga peapi-kola, balato okonelapo lamawuato, liyamba Jisasa ateyanga poto, nimba akali mindi epolopeya layene pia okope. Pee, matili akali waka mindi epolopeya nembo toto, nanimato maliyo atamakalepe lo tipa piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wuane lea-kola, akali okonelapo-mane Jisasa ateanga poto, bala tipa puato, nimba akali mindi epolopeya layene yene pia okope. Pee, matili akali waka mindi epolopeya nembo toto, nanimato maliyo atamakalepe. Ipa peya-maiyane akali Jone pii okonelapo nimba tipa pulu pulupa lala-kola, nalipato nimba tipa pulu epeyapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wuane leapi-kola, okone angi teke Jisasato akali okone-lapona pii leapele okone yano peya napene, wandakali sipitisa koo atene tupana sipitisa koo tupa peyo watalu, wandakali lee koo kambua tupana lee teakale lalu, wandakali siki waka-waka palene tupa mo atu yaka piyu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","23","Wuane piyu, Jisasato Jonena disaipolo okonelapo lamawuato, nambato piape pua ateyo-kola, wandakali lee koo tupamane kuai lo andeyai. Wandakali kee koo tupa asini peyai. Wandakali tapa-pene tupa umbaini epene ateyai. Wandakali ale tuma tupamane pii ale eyai. Wandakali omene tupa ika loto, saka ateyai. Wandakali koo tipia tupamane Gotena pii layene oko ale eyai. Wandakali mindimane nembo lapo pali napene, namba Mesaya oko ateya lo bilipi leaindo, matili bala epele wetete olopeya. Nambato Gotena piape peyo-kola, liyambato lee-mane andeyapi. Nambato Gotena pii leyo-kola, liyambato ale-mane ale eyapi. Liyamba Jone ateyanga peke loto, lee-mane andeyapi tupapi, ale-mane ale eyapi tupapi, utupane pitaka Jone lamai-yapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jonena disaipolo okonelapo-mane bala ateanga peke leapi-kola, Jisasato wandakali kambua ateaini tupa tipa puato, wamba Jone bala wandakali napalene yuu okona atea-angi, bala akali anu-pene mindi atea-kola, yakamato bala andolo peaipe leaipia. Popo leya-kola, kambe tundupalina dini tupa puu amo nena piyane pua, Jone bala akali mini lapo palu atea-kola, yakamato bala andolo peaipe. Jia. Bala nembo mindiki palu atoto, piape pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Balato tona epene wete minditupa pua atea-kola, yakamato bala andolo peaipe. Jia. Tona epene paiya wete piyaini akali tupamane minditaka kambua wetete yatawa atoto, kiŋi tupana andaka pitiyaini. ");
INSERT INTO ipi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","28","Jone bala potopesa akali mindi atea-kola, yakamato bala andolo peaipe. Enene. Joneto potopisa piape pulupeya nembo toto, Gotena pii pepa pelene eya mindimane loto, ale alapape. Nambana pii wai lolane akali oko ingane epeakale lolowa-kola, balato nimbana asini oko makande pua yata olopeya layene eya. Joneto potopesa piape okone puato, piape waka mindi tako pua pea. Joneto yuu okona wandakali pitaka sia minu ateya tekeko, Goteto wandakali gene nayene wetete mindi moyo ando atola-kola, wandakali okonemane Jone sia minuto, kuai lo wetete atolopeya lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Takisa mialaini akali tupapi, wandakali waka tupapi, utupane pitaka-mane Jonena pii ale wato, Gotena mana oko tika-pene ya lo nembo toto, ipa meainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wuane tekeko, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane Gotena pii tanga loto, Joneto yakama ipa peya-gii nalene, konda yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wandakali yame andipa ateyai tupamane wuane peyai okonena, utupane yakama wandakali anu-pene ateyaipe. Nambato utupane aki mindi towa makande puape. ");
INSERT INTO ipi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","34","Nambato utupane andopane yame towa makande peyo. Andopane tupamane makesa ama tupana pituto, andopane yangone tupa lamawuato, yakamato nanima towa kindi pua lialapale loto, nanimato yakama mina kindi pua tina pene peyo gili galo lo mali lialama tekeko, yakamato nanima towa kindi pua mali liama na-lalai. Nanimato kindi puato, wandakali mali puyale wee lalaini mindi mandeke pua lalama tekeko, yakamato nanima towa kindi pua ai lama na-lalai lalaini. Wuane pua teke, wamba ipa peya-maiyane akali Jone bala epo atoto, ipa waenepi, uliapi, utupane nanene atea-angi, yakamato bala lamba loto, sipitisa koo mindi balanga ateya-kola, balato ipa waenepi, uliapi, utupane nanene kondeya leainipia. Andipa Akalina Iwanane oko epo atoto, ipa waenepi, uliapi, utupane no ateya-kola, yakamato balapi lamba loto, akali okomane ipa waenepi, uliapi, utupane kambua wete no atoto, takisa muni mialaini akali tupapi, koo piyaini wandakali tupapi, utupane towa yandeke ando atalane leyai. Andopane tupamane yakamana yangone tupa yataka amauwato, lalaini pua, yakamato Jonepi, Akalina Iwanane okopi, okonelapo yataka amawuato, wuane lalaini mana okonemane yakama andopane gulo ateyai. ");
INSERT INTO ipi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wandakali wai-ene tupa pitaka-mane Gotena pii layene oko tika-pene ya lo nembo toto, Goteto leya pua piyaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Patasai mindimane Jisasa lamawuato, nimba namba towa tomo napakale ipu lea-kola, Jisasa bala Patasai okona andaka kolandaka loto, tomo no peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Okone angi, mana koo kambua minalane wanda mindimane Jisasa bala Patasai okonena andaka tomo no peteya nembo toto, wele tunduma-pene minditupa botolo epene wete mindina piti-pata mindi awua epeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Epoto, Jisasana kee yanenga pituto, wanda okonemane bala tanena mana koo minalane tupa nembo toto, ai lea-kola, balana lee maiya epeane oko Jisasana kenenga dopo lo tepa yaepia. Dopo lo tepa ya-kola, wanda okonemane balana kawa itini luu wete atene okomane Jisasana kenenga lee maiya dopo lo tepa yane tupa kunu apia-maiyaepia. Apia maiyu, balato Jisasa tama puato, ole kambuanga balana kene oko nunu lalu, balana kenenga wele tunduma-pene awua epeane oko gae lo ayia mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wanda okonemane wuane pua petea-kola, Patasai Saimone lene Jisasa tomo napakale ipu leane okomane wua lo nembo teaipia: Jisasa bala potopesa akali enene mindi pia-yale, wanda okonemane mana koo tupa minalane nembo tapia-yale. Wuane nembo toto, balato wanda nimbato namba minulene lapia-yale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wuane nembo tea-kola, Jisasato Saimone lamawuato, nambato pii mindi nimba langukale leaipia. Wuane lea-kola, Saimoneto tisa, nimbato pii okone namba langi leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wuane lea-kola, Jisasato pii kokoli mindi bala lamawuato, akali lapo-mane akali mindikinga yano gii lo meapele leaipia. Akali mindimane kina (50) paiyasa yau gii lo meaipia. Akali mindoko-mane (10) tene kina angu gii lo meaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akali okonelapo-mane balana yano peyolane liyambanga minditaka nayapi oko andoto, matili yano anduane okomane akali okonelapo lamawuato, liyambato nambana yano gewa oko yano peya napene kondalapape leaipia. Wuane lea-kola, akali okone-lapona andoko-mane bala towa epelewa yamapane wete yane yaluape lo tipa peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tipa pea-kola, Saimoneto Jisasana pii okone yano peyoto, akali yano andane meane okomane bala towa epelewa yamapane wete yane yalua nembo teyo leaipia. Wuane lea-kola, Jisasato bala lamawuato, nimbato kuai lo nembo toto, lele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wuane lalu, Jisasa bala wanda okone peteanga mopeke loto, Saimone lamawuato, wanda okomane piape mindi peya oko nimbato andelepe, anda napelepe leaipia. Namba nimba andaka kolandaka lalo-angi, nambana kee wasa-wasa peyola loto, nimbato namba ipa ambua gii napele tekeko, wanda oko balana lee maiya ipane okomane nambana keenga wasa-wasa peyoto, balana kawa itini okomane nambana kenenga ipati atala oko endo peakale lo kunu eya-kola, nimbato andele okoni. ");
INSERT INTO ipi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Namba nimbana andaka kolandaka lalo-angi, wayu epeleya lo, nimbato namba nunu nalene kondele tekeko, wanda okomane namba tama puato, ole kambuanga nambana kee oko nunu lo peteyanga nimbato andele okoni. ");
INSERT INTO ipi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nimbato wele mee mindi nambana kawanenga gae na-lale tekeko, wanda okomane namba epele wato, wele tunduma-pene oko nambana kenenga gae loto, aiya-geya andele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wandakali minditupa-mane mana koo aŋalapo angu minalamane nembo talaini. Nambato wandakali okonepene mindina koo piyane tupa apia-maiyokola, balato namba towa mee teke epele alane. Wanda okonemane mana koo ole kambuanga minalawane nembo teya. Tene okonena, nambato balana mana koo utupane pitaka apia-maiyokola, balato namba towa epelewa yamapane wete eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wuane lalu, Jisasato wanda okone lamawuato, nimbana koo pilini tupa pitaka apia-geyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wuane lea-kola, akali bala towa atu tomo no peteaini tupamane yakama teke-teke mindi lamai-lamai puato, akali oko apito nimbana koo tupa apia-geyo leya andeyamape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wuane leai-kola, Jisasato wanda oko lamawuato, nimbato namba lo bilipi lele okomane nimba mo atu eya-ko. Nimba mini epene paliyu pupe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","3","Wamba akali Kusa lene mindimane Etotena anda ando atalaepia. Balana wetene Jowana bala siki pelea-kola, Jisasato bala mo atu yaepia. Wanda Matiya yuu Makatala tano okona tane balanga sipitisa koo yanasa ateai-kola, Jisasato sipitisa koo utupane peyo wateaipia. Wuane pua teke, Jisasato wanda waka minditupanga sipitisa koo ateane tupa peyo watalu, siki pelene wanda kambua mo atu yalu, Goteto pitaka taka ando atalane leaipia. Wuane loto, balato Gotena pii layene epene oko wandakali tupa lamaima, epoko puato, balana disaipolo alesa akali tupa towa atu tano aŋakopi, andanepi, yuu pitakana peainipia. Peai-kola, wanda Jowana, Matiya, Susana ima, wanda kambua akali utupane towa atu poto, utupane moyo, munipi, tomopi, okonetaka tupa maiki peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wandakali kambua tano pitakana atoto, Jisasa ateanga epo amunguli peai-kola, Jisasato pii kokoli mindi utupane lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Pii kokoli okone loto, akali mindimane tomo waini mindi papaka lolo peane leaipia. Papaka lea-kola, tomo waini minditupa ambe asininga tepa ya-kola, wandakali-mane asini okonena epo poto, kee-mane ango yai-kola, eka minditupa epoto, waini utupane neainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tomo waini minditupa ambe ana tokonga yuu aŋako yane mindina tepa wato, poka lo ika leaini tekeko, ana tokonga yuu aŋako yane okona ipa napetene ya-kola, tomo waini utupane kapu teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tomo waini minditupa ambe tani koo ani atene tupa ika lalane yuu mindina tepa wato, poka lo ika leaini tekeko, tani koo ani atene tupa kapoyale andayoto, tomo waini utupane peyayo neaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tomo waini minditupa yuu epene mindinga tepa wato, poka lo andayoto, dini (100) wane andete liaepia. Jisasato pii kokoli okone lalu, ale asia yene wandakali yakamato pii okone pailo ale wato, pii okonena tene oko nembo talapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisasato pii kokoli okone lea-kola, balana disaipolo tupamane bala tipa puato, nimbato pii kokoli lale okonena tene oko akipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wuane leai-kola, Jisasato utupane lamawuato, Goteto pitaka taka ando atalane loto, nambato balana pii mana wamba too-pene yane tupa yakamanga andawa lalawane tekeko, wandakali waka tupamane nambana piape lee-mane angu andoto, Goteto pitaka taka ando atalane lo anda napeakale. Dee, utupane-mane nambana pii oko ale-mane angu ale wato, Goteto anu puato, pitaka taka ando atalane nembo nateakale nayuto, nambato pii kokoli tupa angu lalawane. ");
INSERT INTO ipi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tene okonena, andipa nambato pii kokoli lalo okona tene tupa yakama langeyo. Tomo waini papaka leane oko Gotena pii layene epene oko eya. ");
INSERT INTO ipi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Akali mindimane tomo waini papaka lea-kola, minditupa ambe asinginga tepa ya-kola, eka minditupa epoto, utupane neainipia. Wuane pua teke, akali mindimane Gotena pii oko wandakali tupa lamaula-kola, utupane-mane pii okone bilipi lolai-kola, Goteto utupane molo-peke lolane nembo toto, Satane epoto, yakamana nembo-tenenga Gotena pii okone mo alu piya alane. ");
INSERT INTO ipi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tomo waini minditupa ambe ana tokonga yuu aŋako yane mindina tepa wato, poka lo ika leane tekeko, ana toto peane okomane pini tupa kapu teaipia. Wuane pua teke, wandakali minditupa-mane Gotena pii oko wamba ini epelewa ale wato, bilipi lalaini tekeko, matili kenda-pene minditupa utupanenga epeya-kola, Gotena pii bilipi leyama nayu nalene wandakali utupane yakama pini wayumane peya napene gulo atoto, ole ukupini angu bilipi lalu, Gote wamba kapoyale awua tepa alaini. ");
INSERT INTO ipi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tomo waini minditupa ambe tani koo ani atene tupa ika lalane yuu mindina tepa wato, poka lo ika leane tekeko, tani koo ani atene tupa kapoyale anda yoto, utupane peyayo neainipia. Wuane pua teke, wandakali minditupa-mane Gotena pii ale wato, bilipi lalaini tekeko, matili utupane-mane epoko pua atoto, umbainina epele-ene tupa pitaka pimakale nayuto, munipi, waka minditaka tupapi, kambua wete anu pua, mia-makale nembo kambua talaini. Mana okonemane wandakali tupa minakasa wato, Gotena pii oko oke eya-kola, Gotena pii yakamanga eya okomane dini lia napiyane. ");
INSERT INTO ipi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tomo waini minditupa yuu epenenga tepa wato, poka lo andayo atoto, dini (100) wane andete liaepia. Wuane pua teke, Gotena pii oko ale wato, mini epene palu, bilipi leyama nayu lalaini wandakali tupanga dini kambua lialane. ");
INSERT INTO ipi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wandakali mindikipi mindimane lamu mindi kayuto, pene mindimane lamu okone ombowa too na-piyaini. Dee, wandakali mindikipi mindimane lamu mindi kayuto, pangiyane toko mindina pangosa yata aa napiyane teke. Jia. Lamu mindimane tii pula-kola, wandakali andaka kolandaka lolai tupamane kuai lo andeakale nembo toto, wandakali-mane lamu okone kayuto, tokonga yata alaini. ");
INSERT INTO ipi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anu peakale nambato wuane leyope. Minditaka andipa too pitane ateya tupa pitaka matili Goteto mo pana olopeya. Minditaka andipa ombo atane eya tupa pitaka matili Goteto mo pana ola-kola, wandakali pitaka-mane andolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wandakali mindimane Gotena pii oko wayumane bilipi leando, Goteto wandakali okonena bilipi oko minu tai laya ola-kola, wandakali okonemane Gotena pii okone bilipi leyo nayu lolopeya. Wandakali mindimane Gotena pii oko bilipi leyo nayu nalene, mee owato bilipi lene gulo ateando, Sataneto akali okonena bilipi oko mo alu piya olopeya-ko. Yakamato Gotena pii oko anu pua ale eyamape nembo toto, wayumane ale eyo nayu alewa atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisasa bala anda mindina petea-kola, wandakali kambua epo amunguli peainipia. Okone angi, balana angini, amene ima, bala andolo epeaini tekeko, wandakali kambua anda-pango peteai-kola, anda-pangosa epolane panda naya-kola, Jisasana yame epeaini tupa kamaka ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kamaka ateai-kola, wandakali mindimane Jisasa lamawuato, nimbana angini amene ima utupane-mane nimba andamakale nembo toto, kamaka maliyo ateyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wuane lea-kola, Jisasato balana pii okone yano peyoto, Gotena pii layene okomane leya pua piyaini wandakali tupa nambana angini, amene ima ateyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ole mindi Jisasato balana disaipolo tupa lamawuato, nanima ipa angini okona amo yangi maa leaipia. Wuane lalu, Jisasapi, balana disaipolo tupapi, utupane sipi mindina peakaiyu lo pitiyu, peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ipa angini okona tombenga peai-kola, Jisasa bala sipi okonena limu palea wete, popo andane wete mindi lo awua epeane okomane ipa andane wete mindi taimane ika leaipia. Ipa ika leane okonemane sipi okone ipa pangosa mo landa peyoyale pea-kola, akali utupane omape-pene guleainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Omape-pene gulo atoto, Jisasana disaipolo tupamane bala paleanga poto, bala peya ika loto, Ando Atalene Akali, nanima omoyale peyama leainipia. Wuane leai-kola, Jisasa ika loto, popo andane leane okola, ipa taimane ika leane okola, lapotaka laya loto, tepa alapa lea-kola, lapotaka tepa wato, ema napeapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wuane pea-kola, Jisasato akali utupane lamawuato, anu peakale yakamato Gote lo bilipi leyama nayu naleyaipe leaipia. Wuane lea-kola, akali utupane-mane yuku wato, nembo kambua toto, yakama teke-teke pii mindi lamai-lamai puato, akali okomane tepa alapa leya-kola, popo andane lala okola, ipa taimane ika lala okola, lapotaka-mane balana pii oko ale eyapi-ko. Akali oko bala api ateyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jisasapi, balana disaipolo tupapi, utupane sipi okonena pitiyu, ipa angini Galili okona amo yangi poto, Getasa yamena yuu okona peakaiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Wamba sipitisa koo mindimane yuu okonena akali mindi mo kee ya-kola, ole kambuanga akali waka tupamane balana kini kene lapotaka anangapu peyo, sene ende-mane andi loto, bala wasa lo ando ateainipia. Utupane-mane wuane peaini tekeko, balato anangapupi, sene endepi, utupane pai lo apiaka piyu, tano oko tepa alu, wandakali napalene yuu tupana puku peaipia. Pulu, bala anda mindina ata napene, wandakali mali tupana atoto, umbaininga tona mindi napene, papata mee atalaepia. Jisasa bala sipi oko tepa alu, ipa okona matenenga epea-kola, sipitisa koo atene akali okonemane Jisasa andoto, bala ateanga epeaipia. Epea-kola, Jisasato sipitisa koo akali okonenga ateane oko lamawuato, nimba akali oko tepa alu, puu lea-kola, akali okonemane Jisasa ateanga aiki leka wato, tombawua leaipia. Tombawua lea-kola, sipitisa koo okomane pii taimane loto, Jisasa nimba Gote ati kenga wete ateya okona Iwanane oko atele leaipia. Nimbato nambanga aki pulape. Nimbato tandaka andane namba gii napene konda ola lo nambato nimba langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wuane lea-kola, Jisasato akali okone tipa puato, nimbana gene apipe leaipia. Sipitisa koo kambua akali okonenga paleai-kola, akali okonemane Jisasana pii okone yano peyoto, nambana gene oko ami leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Okone angi, yuu wangiane mindina yia kambua minditupa-mane tani no ateai-kola, sipitisa koo utupane-mane Jisasa taimane lamawuato, nimbato nanima yuu koo okona wato ainena lolene. Nanima yia ateya utupana ini anda-pangosa makale lo nimbato ando kondaa leainipia. Wuane leai-kola, Jisasato sipitisa koo utupane-mane wuane peakale lo ando konda yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wuane peakale lo ando konda ya-kola, sipitisa koo utupane-mane akali okone tepa alu, yia tupana ini anda-pangosa kolandaka leai-kola, yia utupane pitaka yuu wangiane okonena ato, taimane puu nena loto, ipa angini okona peakoto, ipa nalu, omeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wuane peai oko andoto, yia yatawa atalaini akali tupamane tano tupanapi, yuu waka tupanapi, utupanena taimane poto, wandakali tupa lamawuato, Jisasato wuane piya lo pii lo tawe yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pii lo tawe yai-kola, wandakali tupamane Jisasa ateanga poto andeaini-pia. Andeai-kola, sipitisa koo tupamane akali okone tepa alu peai-kola, bala mini paliyu, tona puato, Jisasa ateanga mandaka peteainga andoto, wandakali utupane-mane yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yuku yai-kola, lee-mane andeaini akali utupane-mane wandakali utupane lamawuato, Jisasato sipitisa koo tupa pulupa loto, akali okone mo atu yala-kola, yia tupa ipa angini okona peakoto, ipa nalu, omalai leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Wuane leai-kola, Getasa tane wandakali tupa pitaka-mane yuku-mane omoto, Jisasa nimba nanima tepa alu, puu leainipia. Wuane leai-kola, Jisasa bala sipi okona peakaiyu lo pitiyu, poyale pea-kola, akali wamba sipitisa koo atene ateane okomane Jisasa tee loto, namba towa baape leaipia. Baape lea-kola, Jisasato bala lamawuato, nimba peke loto, Goteto nimba moyo mangene piya tupa lo tawe yaape leaipia. Wuane lalu, Jisasa bala sipi okona pitiyu pea-kola, akali okone bala tano okona peke loto, Jisasato bala moyo mangene peane tupa wandakali tupa pitaka lamai yiake leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisasa bala Galili ipa angini okona amo yangi ato epolopeya nembo toto, wandakali kambua-mane bala maliyo ateai-kola, bala peke lea-angi, wandakali utupane pitaka-mane bala wayu epeleya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Okone angi, Juta yamena lotu anda ando atalane akali Jaitusa lene mindina wanane mindiki oko angu ee ana alesa pene oko omoyale peaipia. Omoyale pea-kola, Jaitusa epoto, Jisasa ateanga aiki lekawa tombawua loto, Jisasa-o-o, nimba namba andaka bakale ipu leaipia. Bakale ipu lea-kola, Jisasa bala Jaitusana andaka poyale pea-kola, wandakali kambua-mane bala wata awua poto, bala wata tombe pua tongatete leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ee ana alesa pitakana ole dindi lo kii kalo teke pitiyane wanda mindi tano okonena peteane tekeko, wandakali mindikipi mindimane katulo balana siki oko mo atu nayainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jisasa epo pea-kola, wanda okonemane Jisasana masianga epoto, balana tona okona duninga wata ya-kola, okone angi teke, bala kii kalo pitiyane alu peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Atu ya-kola, Jisasato wandakali tupa tipa puato, apito nambanga wata alape leaipia. Wuane lea-kola, wandakali bala watama epeaini tupa pitaka-mane namba jia laka peainipia. Jia laka peai-kola, Pitato Jisasa tipa puato, Ando Atalene Akali, wandakali kambua-mane nimba wata tombe pua, tongatete leyai-ko. Anu peakale nimbato wandakali tupa tipa puato, apito nambanga wata alape lelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wuane lea-kola, Jisasato Pitana pii okone yano peyoto, wandakali mindimane nambanga wata ala-kola, nambana tai-lene minditupa balanga pala-kola, wandakali mindimane nambana singilisanga wata ala nembo teyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wuane lea-kola, wanda okonemane katulo mindinga piti too napulu-peyawa nembo toto, putiti peyoto, Jisasa ateanga epoto, aiki lekawa tombawua leaipia. Wuane piyu, wandakali pitaka-mane alewa ateai-kola, wanda okonemane Jisasa lamawuato, siki mindi nambanga paliya-kola, nambato nimbana tonanga wata alo okone angi teke, nambana siki okone atu yala leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wuane lea-kola, Jisasato bala lamawuato, wana, nimbato nambanga tungi peyoto, bilipi lele okonena, nambato nimba mo atu eyo-ko. Nimba mini epene palu puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisasato wuane lo atea-kola teke, akali mindi Jaitusana andaka atala epoto, bala lamawuato, nimba wanane wamba omala-ko. Tisa oko masia-pene epolane. Peke leakale kondaa. ");
INSERT INTO ipi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wuane lea-kola, Jisasato balana pii okone ale wato, nambato nimbana wanane oko dee lapone saka atolo-peke laya olo-peyawako. Nimbato nembo kambua natene, nambanga tungi peyo bilipi lo atape. ");
INSERT INTO ipi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wuane lalu, Jisasa bala wandakali utupane towa atu poto, Jaitusana andaka peakaiyu leainipia. Peakaiyu loto, Pitapi, Jonepi, Jemesapi, wana omeane okona angini ayianepi, utupane angu Jisasa towa atu anda-pango kolandaka loto, Jisasato wandakali waka tupa yakama pitaka kamaka atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Anda pango kolandaka leai-kola, wandakali peteaini tupa pitaka-mane wana omene okone ondowa ai lo yaya peyo yamataka lo peteaini-pia. Wuane peai-kola, Jisasato wandakali utupane lamawuato, wana oko bala oma napene, mee limu paleya-ko. Yakamato ai nalene kondalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wana okone omea oko andalu, wandakali peteaini tupamane Jisasana pii okone ale wato, balato kopeta leya nayuto, bala andayo giwa yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Giwa yai-kola, Jisasato wana oko kininga minuto, wana nimba ika laa lo pii taimane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ika laa lea-kola, wana omene oko bala lee talu, wamba ini ika lea-kola, Jisasato wandakali peteaini tupa lamawuato, bala ulia neakale maiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jisasato wana omene okone mina ika lea-kola, wana okona angini, ayiane-lamane andoto, moko andane wete leapi. Moko wete leapi-kola, Jisasato okonelapo lamawuato, nambato wana omene yala oko mina ika leyo oko liyambato wandakali mindikipi mindi lamai na-piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisasato balana disaipolo alesa tupa ipulupa lea-kola, utupane epo amunguli peainipia. Amunguli peai-kola, Jisasato wandakali siki pelene tupa mo atu yolane tai-lene okola, sipitisa koo tupa peyo wata olane tai-lene okola, tai-lene okonelapo utupanenga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Maiyu, utupane-mane wandakali siki pelene tupa mo atu yoto, Goteto pitaka taka ando atalane leakale nembo toto, balato utupane pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pulupa loto, balato utupane lamawuato, yakamato nuupi, munipi, tomopi, okonetaka mindi mandi napene, kalango mindi ai napene, singilisa mindiki angu piyu, pulupape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yakamato tano mindina polai-angi, wandakali mindimane yakama yatawa paleaindo, yakamato anda mindina pali-pali napene, anda mindiki okonena angu palu atoto, epoko puato, piape pua atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yakamato tano mindina polai-kola, wandakali tupamane yakamana pii lolai tupa ale naene, yakama yatawa pali napeaindo, yuu okonena atalaini wandakali yakama tane koo mindi piyama ya lo nembo teakalenga, yakamana sukeenga yuu kangalamu atolane tupa tanda lo tepa alu, yakama yuu waka mindina pulupape. ");
INSERT INTO ipi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jisasato wuane lea-kola, alesa akali utupane-mane tano tupa pitakana puku puato, Gotena pii layene epene oko wandakali tupa lamaita, wandakali siki pelene tupa mo atu yaka pua ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Jisasato metekolo piape tupa pua atea-kola, wandakali minditupa-mane andoto, potopesa akali Ilainja bala ati kenga atala, yuunga peke loto, piape pua atalua leainipia. Wandakali minditupa-mane Jisasa bala potopesa akali wamba ateaini tupana waka mindi malinga ika loto, piape pua atalua leainipia. Wandakali minditupa-mane ipa peya-maiyane akali Jone bala malinga ika loto, metekolo piape tupa pua atalua leainipia. Wuane leai-kola, Galili disitiki oko ando atalane akali Etoteto pii utupane ale wato, nembo kambua toto, wamba nambato Jonena maa pai lewa-ko. Andipa apito metekolo piape utupane pua ateya-kola, nambato pii temane utupane ale eyope leaipia. Wuane lalu, balato Jisasa andokale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Matili aposolo akali alesa tupa epo peke loto, utupane-mane piape waka-waka peaini tupa pitaka Jisasa lamai-yainipia. Lamai-yaikola, Jisasato wandakali waka tupa ateakale lalu, balana disaipolo tupa angu bala towa atu tano Betesaita lene okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Utupane angu peaini tekeko, matili wandakali tupamane Jisasa bala Betesaita tano okona ateya lene ale wato, bala watama epeainipia. Epeai-kola, Jisasato utupane ando wayu epelaiya lalu, Goteto wua puato, pitaka taka ando atalane lo wandakali tupa mana lamaiyu, wandakali siki pelene tupa mo atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ole lea-kola, disaipolo alesa akali tupa Jisasa ateanga epoto, bala lamawuato, wandakali napalene yuu mindina ateyama-ko. Wandakali utupa tano aŋako mindina yandopi, wandakali mindina andaka yandopi, utupanena poto, yakama ulia nolanepi, anda pangulanepi utupane ayia peakalenga, nimbato utupane peakale laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Wuane leai-kola, Jisasato balana disaipolo tupa lamawuato, yakamato wandakali utupa tomo neakale maiyapa leaipia. Wuane lea-kola, akali angu (5,000) tausene yaupi mindi ateai oko andoto, balana disaipolo tupamane Jisasa lamawuato, nanimanga betesa yau, pisa lapo angu eyama-ko. Wandakali utupa pitaka-mane tomo neakale, nanimato mindisa poto, tomo kamboto, wandakali utupane pitaka-mane neakale maipe-penepe leainipia. Wuane leai-kola, Jisasato balana disaipolo tupa lamawuato, yakamato wandakali utupane paiyasa yau-yau lo, amunguli pua peteakale lamaiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Balato leane pua, balana disaipolo tupamane wandakali tupa lamai-yaikola, wandakali tupa pitaka yuunga peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Peteai-kola, Jisasato betesa yau tupapi, pisa lapo okolapopi, utupane moto, ati kenga andaiyu loto, Gote wayu pele loto, tomo utupane konde leaipia. Konde loto, betesa pisa ima utupane wandakali tupa maiyapa loto, balana disaipolo tupanga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Balana disaipolo tupamane tomo utupane wandakali peteaini tupa tale pua mayai-kola, wandakali pitaka-mane no embo yainipia. No embo yai-kola, balana disaipolo tupamane akenane yane tupa moto, basaketa nuu alesa tumbi laya yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Alu mindi, Jisasa balana disaipolo tupa towa atu atoto, bala angu pote lo ateaipia. Pote lo koyo piyu, balato utupane tipa puato, wandakali-mane namba andayo api ateya lalainipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wuane lea-kola, utupane-mane balana pii okone yano peyoto, wandakali minditupa-mane nimba ipa peya-maiyane akali Jone atele lalaini leainipia. Wandakali minditupa-mane nimba potopesa akali Ilainja peke loto atele lalaini. Minditupa-mane nimba potopesa akali wamba ateaini tupana waka malinga ika lene mindi atele lalaini leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wuane leai-kola, Jisasato balana disaipolo tupa lamawuato, utupane-mane wuane lalaini tekeko, yakamato namba api ateya lalainipe leaipia. Wuane lea-kola, Pitato balana pii okone yano peyoto, nimba Mesaya Goteto epeakale leane oko atele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, matili, ando atalane akali tupapi, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, utupane pitaka-mane Akalina Iwanane oko bala masia maulai-kola, bala tandaka andane nape-pene guleya leaipia. Akali-mane bala peyo ome lolai-kola, ole tepo penenga Goteto bala malinga ika laya olopeya-ko. Namba Gotena Mesaya oko ateya lo yakamato wandakali mindikipi mindi lamaulaini. Jia wete. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","26","Wuane lalu, Jisasato wandakali ateaini tupa pitaka lamawuato, wandakali tupana wenonga atoto, wandakali minditupa-mane nambapi, nambana pii tupapi, utupane bilipi leyo lape-pene yala wato, namba Jisasana yame ata napeyo lolopeyai. Mindimane wuane lola-kola, matili Ayiane Gote okopi, balana enjole epene wete tupapi, utupanena tai-lene oko Akalina Iwanane okonga yola-kola, Akalina Iwanane oko bala epolopeya. Okone angi, balato wandakali okone balana yame ateya lape-pene yala ola-kola, wandakali okone bala katulo Gote towa saka atapowa ata napulu-peyako. Wandakali mindimane yuu okona minditaka eya tupa pitaka mialu, saka atapowa ata napeando, matili balana minditaka utupane pitaka-mane anu puato, bala moyolo-peyape. Wandakali mindi bala nambana yame ateando, namba towa yanda piyaini akali tupamane katulo bala peyo ome lolopeyai. Wandakali mindi bala omolowane nembo toto, nambana yame ata napeando, bala epene saka atapowa ata napulu-peya tekeko, wandakali mindi bala nambana yame ateya nembo toto, wandakali-mane bala peyo ome leando, wandakali okone bala saka atapowa atolopeya. Tene okonena, wandakali mindimane namba polowa okona epokale nembo teando, bala tane nembo natene, ole dindi lo kenda-pene balanga epola tupa balana ita malamanda gulo aiyu, namba watama ipupe-pene. ");
INSERT INTO ipi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nambato pii enene mindi yakama langeyo. Wandakali andipa ateyai tupana minditupa wamba ini oma napene andolai-kola, Goteto pitaka taka moyo ando atolanga andolopeyai leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","32","Jisasato pii utupane lo koyo pea-kola, ole kitupasapi mindi peaipia. Pea-kola, matili balato Pita, Jemesa, Jone ima utupane atu aiyu yuu wangiane mindina pote lolo peaipia. Balato pote lo atea-kola, akali tepo utupane yakama limu palu ateainipia. Limu palu ateai-kola, Jisasana lee-ingapi tii wete pea-kola, balana tona peane tupa ake wete pea-kola, bala waka guleaipia. Waka gulea wete, Mosesa, Ilainja-la okonelapo ati kenga tii-pene oko towa atu epoto, Jisasa towa atu pii lalawa puato, matili Jisasa bala Jutusaleme poto, omalu, ika lalu, ati kenga polane okona pii lo ateainipia. Pii lalawa pua ateai-kola, Pita, Jemesa, Jone ima utupane yakama lee toto andeai-kola, Jisasana tii-pene okopi, lapo akali bala towa atu ateapele okolapopi, utupane andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Akali okonelapo liyamba Jisasa tepa alu, poyale ateapi wete, matili anu pulupeya nembo natene, Pitato Jisasa lamawuato, Ando Atalene Akali, nanima yuu okona ateyama-kola, kuai leya-ko. Nanima tepo akali tupamane aiyakame mindi nimbana, mindi Mosesana, mindi Ilainjana, aiyakame tepo pingimakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitato pii okone lo atea-kola, mole mindi epoto, akali utupane yame peyoto, ombo ya-kola, Pita, Jemesa, Jone ima utupane-mane yukuwa ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yukuwa ateai-kola, mole okonena tombenesa ato pii mindi leane okomane loto, akali oo ateya oko bala nambana iwanane oko leaipia. Balato nambana piape pingeakale loto, nambato bala ata lewaneko. Yakamato balana pii oko ale alapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wuane lea-kola, Pita, Jemesa, Jone ima utupane-mane Jisasa bala angu ateanga andeaini-pia. Utupane-mane mangene utupane pitaka andeaini tekeko, okone angi teke utupane-mane minditaka lee-mane andeaini tupa wandakali mindikipi mindi lamai napeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Anate-lene Jisasa, Pita, Jemesa, Jone ima, utupane yuu wangiane okone tepa alu, puu nena leai-kola, wandakali kambua amunguli peaini tupamane Jisasa malanda yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Malanda wato, wandakali utupane towa atu ateane akali mindimane pii taimane loto, tisa, nimbato nambana iwanane oko andola leaipia. Bala nambana andopane mindiki oko angu ateya. ");
INSERT INTO ipi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sipitisa koo mindimane bala mina duli leya-kola, bala kalae lo apupu teke mandu atalane. Sipitisa koo okonemane iwana oko ini tepa naene, balana umbaini minu koyalu palane. ");
INSERT INTO ipi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Balato wuane piyane okonena, nambato nimbana disaipolo tupamane sipitisa koo okone peyo wata alapale lo tee lalo tekeko, utupane-mane sipitisa koo okone katulo peyo wata napiyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wuane lea-kola, Jisasato utupane lamawuato, wandakali yame koo andipa ateyai tupa yakamato kuai lo nembo natene, mana koo tupa minuto, Gote lo bilipi leyama nayu na-lalaini lea. Ole aki-tupi namba yakama towa atokale yape. Dee, ole aki-tupinga namba yakama towa atu atoto, yakamana kenda-pene tupa awua ata gukale yape leaipia. Wuane lalu, balato akali okone lamawuato, nimba iwanane oko atu aiyu ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Iwana okone epoyale epea-kola, sipitisa koo okomane bala taimane mo malawai loto, yuunga mo lomba tepa ya-kola, bala peango-ngo peya-yene yaepia. Wuane pea-kola, Jisasato sipitisa koo okone laya loto, nimba iwana oko tepa alu, puu leaipia. Sipitisa koo okone pea-kola, Jisasato iwana okone mo atu yoto, nimba ayiane towa pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Jisasato iwana okone mo atu ya-kola, wandakali pitaka-mane Gotena tai-lene andane oko andoto, moko wete leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","44","Jisasato piape kambua andane pea-kola, wandakali pitaka-mane nembo kambua teainipia. Nembo kambua teai-kola, Jisasato balana disaipolo tupa lamawuato, pii nambato leyo utupa yakamato pailo ale wato, wayumane nembo tatawa atalapape. Matili akali mindimane Akalina Iwanane oko ene pituto, akali waka tupana kiinga malupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jisasato wuane leane tekeko, pii okonena tene oko too pene guleaipia. Tene okonena, utupane-mane tatake wato, balato aki nembo toto, wuane leyape nembo nateaini tekeko, utupane-mane bala tipa puyale yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Alu mindi Jisasana disaipolo tupamane nanima disaipolo ateyama tupana akali gene andane wete yene api ateyamape loto, yakama teke-teke pii yanda pua ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pii yanda pua ateai-kola, Jisasato utupanena nembo-tene okone andoto, andopane mindi kii minu atu epoto, bala towa atu ateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Atu atoto, Jisasato balana disaipolo tupa lamawuato, akali mindi bala yakama pitakana pangosa ateando, bala yakamana akali andane wete oko atolopeya leaipia. Wandakali mindimane namba lo nembo toto, andopane okopene mindi moyando, balato namba moyola-kola teke pulupeya. Wandakali mindimane namba moyando, balato namba puu leane Gote oko moyola-kola teke pulupeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Okone angi, Joneto Jisasa lamawuato, Ando Atalene Akali, nanimato andalama-kola, akali mindimane nimbana gene oko loto, sipitisa koo tupa peyo wato atala tekeko, bala nanima towa atu ata na-piyamane. Tene okonena, nanimato bala lamawuato, nimbato Jisasana gene oko loto, sipitisa koo tupa peyo watolene lalama leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Joneto wuane lea-kola, Jisasato bala lamawuato, akali mindimane yakama towa yanda pua ata napeando, balato yakama moyalane-ko. Akali mindimane piape epene mindi pua ateando, yakamato jia nalene, balato wuane peakale lo ando kondalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","52","Jisasa bala ati kenga peke lolane oto oko mandaka epea-kola, bala nembo mindiki paliyu, Jutusaleme poyale ato, akali minditupa-mane bala epeya lo lamai-yakale ingane pulupa leaipia. Wuane lea-kola, akali utupane-mane Jisasana tomo nolanepi, anda pangulanepi, utupane mandeke puyale, Samatiya yame tupana tano mindina ingane peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wuane tekeko, Jisasa balana disaipolo tupa towa tano okonena peakaiyu leai-angi, Samatiya yame wandakali utupane-mane Jisasa bala Jutusaleme poyale epeya nembo toto, bala yatawa pali napimakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wuane leai-kola, Jemesa, Jone-la okonelapo Jisasa ateanga poto, bala tipa puato, Akali Andane, wandakali utupane ita-mane teakalenga, nalipato ita tapeta mindi ati kenga ato epeakale lapape leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wuane leapi-kola, Jisasa okonelapo anda-peke lo laiya loto, liyambato wuane lolapele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wuane lalu, Jisasa balana disaipolo tupa towa yuu okone tepa alu, tano waka mindina peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisasa balana disaipolo tupa towa asini peai-kola, akali mindimane bala lamawuato, namba nimbana disaipolo atoto, yuu nimba pole tupa pitakana namba atu bakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Atu bakale lea-kola, Jisasato bala lamawuato, peango anatope tupana pangulane yuli tomba-yene yalane. Eka tupa paliyaini anda atalane tekeko, Akalina Iwanane oko oto mo, kawa yolane panda mindi naeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wuane lalu, Jisasato akali waka mindi lamawuato, nimba namba watama ipu lea-kola, akali okonemane lapeke loto, Akali Andane, nambana ayiane oko wamba ini bulupane mali piyu, matili namba nimba watama epokale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wuane lea-kola, Jisasato akali okone lamawuato, wandakali omene gulo atalaini tupamane yakamana yangone omene tupa mali peakale lo ando kondalu, Goteto pitaka taka ando atalane loto, nimbato pii okone lo tawe yolo puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Okone angi teke, akali waka mindimane Jisasa lamawuato, Akali Andane, matili nambato nimba pele okona watama epokale tekeko, wamba ini nambana yame tupa atalapape lolo pokale dee leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wuane lea-kola, Jisasato bala lamawuato, wandakali mindimane Gotena piape oko puape, kondowape lo, mini lapo palu ateando, balato Gotena piape oko kuai lo napulu-peya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisasa bala yuu waka minditupana poyale atoto, yuu utupanena akali lapo-lapo lo wamba ini piape pulu pulupa lokale nembo toto, akali paiyasa yanasanga lapo yapa lo meaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Moto, balato utupane lamawuato, eenga tomo kambua mandipe-pene eya tekeko, tomo mandulane wandakali aŋalapo angu ateyai-ko. Ee anduane okomane balana eenga tomo mandulane wandakali minditupa mo tako peakale loto, yakamato bala lo pote lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sipisipi andopane gulene piape akali yame yakama poto, peango anatope gulene wandakali tupana tombenenga atoto, piape pua atalapape leyo. ");
INSERT INTO ipi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yakamato piape pulu polai-angi, wandakali asininga malanda olai tupamane pii mindi loto, yakama minandi leakale lo yakamato ando konda na-piyapape. Yakamato munipi, nuupi, sukeepi, mindi mandi napene, mee pulupape. ");
INSERT INTO ipi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yakamato anda mindina kolandaka lolai-angi, anda okonena paliyaini wandakali tupa lamawuato, yakamato nanima towa embo olaini. Yakama mini epene palu atalapa lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","7","Anda okonena paliyaini wandakali tupamane yakamana pii lolai okone ale wato, mini epene pali napeaindo, mini epene palene pii okone wandakali utupanenga nayene, yakama tanenga peke lolopeya. Wuane tekeko, anda okonena paliyaini wandakali tupamane yakamana pii lolai okone ale wato, mini epene paleaindo, mini epene palene pii okone wandakali utupanenga yolopeya. Yola-kola, yakamato anda mindina pali-pali napene, anda okonena teke paluto, epoko pua piape piyapape. Piape akali mindimane piape puato, katulo balana yole mialane-ko. Wandakali utupane-mane tomo ipapi yakama gulai tupa yakamato nalapape. ");
INSERT INTO ipi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Yakama tano mindina polai-kola, tano okonena tane wandakali tupamane yakama ipulupa leaindo, yakamato tano okonena wandakali siki pelene tupa mo atu yalapape. Mo atu yalu, yakamato wandakali utupane lamawuato, Goteto yakama moyolo ipupia lalapape. Yakamato Gotena piape utupane pua atolai-kola, tano okonena tane wandakali tupamane tomo ipapi yakama gulai tupa nalapape. ");
INSERT INTO ipi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tano mindina tane wandakali tupamane yakama yatawa pali napimakale leaindo, yakamato tano okonena asini tupana atoto, wua lalapape: ");
INSERT INTO ipi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Goteto yakama moyo ando atolane oto oko ipupia-kola, wamba balato nanima languato, nambana pii oko wandakali utupanga lamalu pulupa lapia nembo talapape. Yakamato wuane nembo tape-pene tekeko, yakamato Gotena pii oko ale aa napimakale nembo toto, nanima yatawa pali napeyai. Tene okonena, koo tene mindi yakamanga eya lo andalapale loto, tano okona yuu kangalamu nanimana kenenga ateya tupa nanimato tanda lo tepa alu, nanima yuu waka mindina peyama lo wandakali utupane lamai-yapape. ");
INSERT INTO ipi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Matili Goteto wandakali tale pulu epola-angi, balato Sotomo tano okona tane wandakali tupa malinga ika laya wato, kenda-pene mindi utupanenga malupeya tekeko, andipa yakama disaipolo tupamane pii mindi lolai-kola, tano mindina wandakali tupamane yakamana pii okone ale naene, yakama yatawa pali napeaindo, Goteto kenda-pene andane wete mindi utupanenga malupeya leyo. ");
INSERT INTO ipi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","16","Wandakali mindimane yakamana pii oko ale yando, balato nambana pii oko ale ola-kola teke pulupeya. Wandakali mindimane yakama masia geando, namba masia gula-kola teke pulupeya. Wandakali mindimane namba masia geando, namba puu leane Gote oko masia maula-kola teke pulupeya. Jisasato akali paiyasanga lapo tupa lamawuato, wuane leaipia. Wuane lalu, balato pii mindi loto, wamba namba Kotasini, Betesaita-la, tano okone-lapona atoto, metekolo piape minditupa pewa-kola, tano okone-lapona tane wandakali yakama yamapane peke naleaini leaipia. Akali mindimane Taya, Saitone-la, tano okone-lapona atoto, metekolo piape nambato yakamana tano okone-lapona pewa okonepene mindi pea-yale, tano okone-lapona tane wandakali tupamane koo pemaeya nembo teai-yale. Yakamato wuane nembo teai-yale, wamba wete mini kenda wato, yamapane peke leyama lo andawa loyale, yakamato tona waka mindi-pene piyaini tupa puato, pete tenenga pitipiai-yaleko. Yakamato yamapane peke nalene ateyai okonena, yakama koyolo-peyai ya lo nembo toto, nambato yakama ondo eyo. Enene, Goteto wandakali tale pula-angi, balato Taya, Saitone-la, tano okone-lapona tane wandakali tupa malinga ika laya wato, kenda-pene mindi utupane maulupeya tekeko, balato kenda-pene andane wete mindi Kotasini, Betesaita-la, tano okone-lapona tane wandakali yakamanga gulupeya. Okone angi, Goteto Kapaneame tane yakamana gene oko ati kenga laiyu lolo-peyape. Jia. Yakamato namba lo bilipi naleyai lo andoto, balato yakama yuu koo wetete okona awua aindaka lolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Akali paiyasa yanasanga lapo tupamane poto, Jisasato piape piyapape leane tupa piyu, epele wato, Jisasa ateanga peke leainipia. Peke loto, utupane-mane bala lamawuato, Akali Andane, nanimato nimbana gene oko loto, sipitisa koo tupa peyo wataima-kola, sipitisa koo tupamane nanimana pii ale wato, wandakali tupa tepa alu pupiai leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","19","Wuane leai-kola, balato utupane lamawuato, nambato yakama minu tai laya ewa-kola, yakamato etelu gepopi, analika-likapi, okonetaka tupa ango olai-kola, okonetaka mindimane yakama katulo minu koya napulu-peya. Yakamato yakama yanda pingiyaini yame tupana tai-lene pitaka sia minulu-peyai. Sipitisa koo tupamane yakamana pii oko ale wato, wandakali tupa awua tepa alu pupiai-angi, yuu tapale kapoyale piyane pua, Satanena tai-lene oko kapoyale koyo pipianga nambato andauwa. ");
INSERT INTO ipi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sipitisa koo tupamane yakamana pii oko ale apiai nembo toto, yakamato epelewa ateyai tekeko, Goteto yakama ati kenga ipulupale loto, yakamana gene tupa balana bukunga peyoto, yatawa ateya nembo toto, yakamato epele andane wete alapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Okone angi, Oli Sipitisa okomane Jisasana yamapane mo epele piya ya-kola, Jisasato pote loto, Ayiane, nimba yuu ati-la lapotakana Akali Andane atele leaipia. Wandakali wai-enepi, mana kambua andenepi, utupane-mane nimbana pii mana epene utupane anda napeakale nembo toto, wamba nimbato utupane mo too peene. Andipa andopane aŋako gulo ateyai wandakali tupamane nimbana pii mana epene tupa andeakale nembo toto, nimbato wandakali utupanenga andawa lele. Enene, nimbato wuane pele okonena, nambato nimba ando wayu pele leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pote lo koyo piyu, Jisasato akali ateaini tupa lamawuato, minditaka eya tupa pitaka nambato ando atola loto, namba ayiane-mane utupane pitaka nambanga geane leaipia. Wandakali mindi bala tanena tai-lene mindimane Gotena Iwanane oko bala okopene nembo natalane. Jia. Ayiane Gote angu-mane balana iwanane okopene ateya nembo talane. Wandakali mindina tai-lene mindimane Ayiane oko bala okopene nembo natalane. Iwanane okomane angu ayiane oko wandakali mindinga andawa leya-kola, wandakali okonemane ayiane oko bala okopene nembo talane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Wuane lalu, Jisasa bala anda-peke loto, balana disaipolo tupa lamawuato, wamba potopesa akalipi, kiŋipi, kambua-mane pii andipa yakamato ale eyai tupa ale aima lakae lo nembo teaini tekeko, utupane-mane ale nayainipia. Utupane-mane minditaka yakamato lee-mane andeyai tupa andaima lakae lo nembo teaini tekeko, utupane-mane okonetaka tupa anda napeaini lo nambato yakama langeyo-ko. Yakamato minditaka lee-mane andeyai oko andoto, epele ape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Alu mindi Jisasato mana lamawua atea-kola, loo tupana mana kambua andene akali loya mindi ika loto, Jisasa minu mandeke puato, tisa, namba saka atapowa atokalenga, nambato anu puape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wuane lea-kola, Jisasato bala tipa puato, Mosesato Gotena loo tupa pepa peyoto, aki leaipiape. Nimbato loo utupane dii lo andoto, aki lalenepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jisasato wuane lea-kola, akali okomane Jisasana pii okone yano peyoto, nimbato nimbana Akali Andane Gote oko wayumane wetete epelewa yamapane yoto, nimbana yamapanepi, tandinipi, nembo-tenepi, tai-lenepi, utupane pitaka bala angu mawua atape. Wuane puato, nimba tane epelewa yamapane yo atalene pua teke, nimbato nimbana wandakali yangone tupa epelewa yamapane yo atape layene eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wuane lea-kola, Jisasato bala lamawuato, nimbato nambana pii lalo tupa tika pua yano pelele. Nimbato mana okone wato minu ateendo, nimba saka atapowa atolopele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wandakali peteaini tupamane loo tupana mana andene akali oko bala akali tika-pene mindi ateya nembo teakale nembo toto, balato Jisasa tipa puato, nambana wandakali yangone oko apipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wuane lea-kola, Jisasato balana pii okone yano peyoto, alumindi Juta yame akali mindi Jutusaleme tepa alu, Jetiko tano okona poyale puu nena leaipia. Puu nena lea-kola, pake nene akali minditupa-mane bala minu peyalu, balana tonapi, minditaka awua peane tupa pitaka pake mialu, bala peya-yene yakale lalu, peai-kola, bala asininga omoyale yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Omoyale ya-kola, Gotena pitisa piape piyane akali mindi asia okonena epoto, bala andoto, asia peya wanjialu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pea-kola, akali Lipai yame mindi epoto, bala andoto, wuane pua teke, asia peya wanjialu, peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Juta yame akali okonelapo-mane wuane peapi-kola, matili Samatiya yame akali mindi asia okonena epoto, Juta yame akali peyapiane yane okone andoto, ondo yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ondo wato, akali peyapiane yane ongane mandaka poto, balana umbaini pai leaini tupana tundupa epeane tupa kunu apoto, welepi, waenepi, minditupa matasini gulo ayia mawuato, tongo pima-yaepia. Wuane piyu, balato akali okone minaiyu loto, balana yia dongi okona masianenga yakale mandiyu poto, pasindia anda mindina yatawa paleaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Anate-lene Samatiya yame akali okomane pasindia anda ando atalane akali oko muni silipa-mane waa-pene lapo mawuato, nimbato akali oko pailo ando yatawa atape leaipia. Muni nambato nimba geyo oko koyo pula-kola, nimbana muni minditupa-mane akali oko moyeendo, matili namba peke lolowa-angi, nimbana muni utupane yano peyokale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pii kokoli okone lo koyo piyu, Jisasato loo tupana mana andene akali oko tipa puato, pake nene akali tupamane akali peleaini okone asini okonena peya-yene ya-kola, akali tepo asininga epeaini utupanena akali andoko-mane balana amene gulea yalua nembo telepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wuane lea-kola, loo tupana mana andene akali okomane Jisasana pii okone yano peyoto, ondo wato, moyane akali okone bala akali peya-yene yane okonena yangone gulea yalua leaipia. Wuane lea-kola, Jisasato bala lamawuato, nimbatopi mana okone teke wato minuto, wandakali waka tupana amene guloto, ondowa moyo atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisasapi, balana disaipolo tupapi, tano aŋako mindina peai-kola, wanda Matato Jisasa lamawuato, nimba namba andaka tomo nolo bakale ipu leaipia. Ipu lea-kola, Jisasa bala Matana andaka poto, peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Petea-kola, Mata akini Matiya lene okomane Jisasa peteanga mandaka epo peteaipia. Petea-kola, Jisasato Gotena pii minditupa bala lamawua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matiyato Gotena pii Jisasato leane tupa alewa petea-kola, Mata bala angu-mane tomo tupa yango mandeke puato, pii Jisasato leane tupa ale nayaepia. Jia. Piape kambua pulane ya-kola, bala angu-mane anu puato piape utupa pitaka puape lo, nembo kambua teaipia. Wuane nembo toto, balato Jisasa peteanga poto, Akali Andane, namba akini okomane namba moya napeya-kola, namba angu-mane piape utupa pitaka peyo oko nimbato anda napelepe. Matiyato namba moyakale, nimbato bala lamai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wuane lea-kola, Akali Andane okomane Matana pii leane okone yano peyoto, Mata, Mata, nimbato mangene waka-waka kambua piwa lakae lo nayuto, nembo kambua talene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Matiyato nambana pii alewa peteya oko mangene epene wete mindi peya-ko. Balato mangene peya okone kondaa lo nambato lamai napukale. Jia. Nimbatopi mangene epene mindiki okone angu piwa lakae lo petepe-pene guleya. ");
INSERT INTO ipi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Alumindi Jisasa bala yuu mindinga poto, pote lo ateaipia. Pote lo koyo pea-kola, balana disaipolo mindimane bala lamawuato, Akali Andane, wamba ipa peya-maiyane akali Joneto balana disaipolo tupa mana lamawuato, yakamato wua loto, pote lalapape leaipia. Andipa nimbato wuane teke puato, pote lolane mana oko nanima langi leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wuane lea-kola, Jisasato utupane lamawuato, yakamato pote lolai-angi, wua lalapape: Ayiane, nimbana gene oko tika pua yakale. Nimbato nanima moyo ando atape. ");
INSERT INTO ipi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ole dindi lo nanima tomo namakale giipe. ");
INSERT INTO ipi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nanimato wandakali waka tupa pitakana koo piyaini tupa apialamane. Wuane pua teke, nimbato nanimana koo piyamane tupa apia-gipe. Koo tupamane nanima minu makande pulu epolane, nimbato ando atape. Wuane loto, pote lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Wuane lalu, Jisasato utupane lamawuato, nimbana amene mindi yuu waka mindinga atalu, utulu tombe nimba andaka peakaiyu loto, tomo nokale gii leando, nimbato anu pulu-pelepe leaipia. Nimbana andaka tomo mindi nayando, nimbato amene waka mindina andaka poto, bala andayo, amene, nambana amene waka mindi tomo nanene, utulu namba andaka epala-kola, tomo neakale maulane mindi namba andaka naeya-ko. Matili nambato nimba yano peyo gukalenga, nimbato betesa tepo namba gii lolopele. ");
INSERT INTO ipi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nimbato wuane lole-kola, balato nimba languato, nambato asia wamba loko peyalu, nambana andopane tupa towa limu paleyama. Namba katulo ika loto, betesa utupane nimba gii napukale-ko. Nimbato namba peya ika nalene konda nalolo-peya. Jia. Balana amene okomane tee leya nembo toto, bala ika loto, betesa utupane nimba katulo gulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Balana amene okomane tee leya nembo toto, balato betesa utupane nimba gii napene konda yando, nimbato betesa gii lo atole-kola teke, matili bala kepa wato, ika lalu, minditaka gii lo atole tupa pitaka nimba katulo gulupeya lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Wandakali-mane pote loto, Gote nimbato mangene mindi pipe leyai-kola, Goteto mangene okone piyane. Yakamato pote loto, Gote nimbato mangene mindi pipe leaindo, Goteto mangene okone pulupeya-ko. Gote nimbato mangene mindi pipe lo pote lalapape. Minditaka ayia pua atalaini wandakali tupa pitaka-mane minditaka ando mialaini. Yakamato aiya pua ateaindo, yakamato minditaka ando molopeyai-ko. Yakamato minditaka ayia pua atalapape. Wandakali-mane anda asia lomba peya geao-geao lo atalaini tupa pitakana asia Goteto lumba maiyane. Yakamato asia lomba peya geao-geao lo ateaindo, Goteto asia lumbulu-peyako. Yakamato asia lomba peya geao-geao lo atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Andopane mindimane balana ayiane lamawuato, pisa mindi nokale gii leando, ayiane okonemane etelu koo mindi andopane okone malupeyape. Jia, balato etulu koo mindi andopane okone mai napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Andopane mindimane eka apane mindi nokale gii leando, bala ayiane okomane ana lika-lika mindi malupeyape. Jia. Balato ana lika-lika mindi andopane okone mai napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Andopane tupamane minditaka epene mindi gii leaindo, yuu okona ayiane koo tupa yakamato minditaka epene gii lolai okone maiyaini. Wuane pua teke, wandakali mindimane Oli Sipitisa gii leaindo, ayiane ati kenga ateya okomane yuu okona ayiane tupa sia minuto, Oli Sipitisa okone epelewa malupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sipitisa koo mindi akali mindinga atea-kola, akali okonemane katulo pii naleaipia. Jisasato sipitisa koo okone peyo watea-kola, akali okonemane pii leaipia. Jisasato akali okone moya-kola, wandakali kambua amunguli pua ateaini tupamane moko wete leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kambua-mane moko wete leaini tekeko, wandakali yangi-mane pii mindi loto, sipitisa koo tupana akali kawane Belesa-pulu balato Jisasa minu tai laya eya-kola, balato sipitisa koo waka tupa peyo wata alane leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wandakali yangi-mane Jisasa minu mandeke puato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loyale, nimbato ati kenga tawe metekolo piape mindi pula leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wuane leai-kola, Jisasato utupane lamawuato, kiŋi mindikina yame oko yapu lo lapo puato, yakama teke-teke yanda peapindo, utupane koyolo-peya. Dee, wandakali yame anda mindikina paliyaini tupa yapu lo lapo puato, yakama teke-teke yanda peapindo, wandakali yame okone tai ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yakamato pii mindi loto, sipitisa koo tupana akali kawane Belesa-pulu balato namba minu tai laya eya-kola, nambato sipitisa koo tupa peyo wata alane leyai tekeko, Belesa-pulu balato namba minu tai laya eya-kola, nambato sipitisa koo tupa peyo watauwa-yale, Satane yame oko yapu lo lapo puato, yakama teke-teke yanda pua atene gulapia-yale. Wuane pipia-yale, anu pua, balana yame tai atapia-yalepe. ");
INSERT INTO ipi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Belesa-pulu balato namba minu tai laya apia-kola, nambato sipitisa koo tupa peyo watauwa-yale, balato yakamana disaipolo tupa minu tai laya apia-kola, utupane-mane sipitisa koo tupa peyo watapia-yale. Yakamana disaipolo utupane-mane jasa gulo atoto, yakamato pii namba ando lalai tupa kopeta lalai lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","22","Akali tai mindimane balana yanda, yandatepi, awua atoto, balana anda oko tane ando ateya-kola, balana minditaka yola tupa pitaka epene yalane. Balana yanda, yandate tupamane bala moyolo-peya nembo talane tekeko, matili akali tai wetete mindi epola-angi, balato akali tai okone sia minuto, balana yanda yandate-la okonelapo mialu, balana minditaka yola tupa pitaka moto, wandakali waka tupanga tale pua malupeya. Wuane pua teke, Gote tai wetete okomane namba minu tai laya eya-kola, nambato sipitisa tai tupa peyo wata alawane-ko. Goteto yakama moyo ando atolo ipupia nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nambana yame ata na-piyaini wandakali tupamane namba yanda pingiyaini. Dee, nambana sipisipi tupa mo amunguli napiyane wandakali tupamane nambana sipisipi tupa mo toko laya alaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Wuane lalu, Jisasato pii mindi tako pua loto, sipitisa koo mindi akali mindinga ateando, akali okone bala kopeta atalane leaipia. Sipitisa koo okonemane akali okone tepa alu poto, oto mo atolane panda mindi ayia puato, wandakali napalene yuu tupana epoko piyane. Ayia pua atoto, oto mo atolane panda mindi ando mia napeando, balato pii mindi loto, anda wamba nambato tepa alu epewa okonena namba lapone peke loto atokale lalane. ");
INSERT INTO ipi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wuane lalu, bala anda okonena peke loto andeya-kola, akali okonemane anda okonena kangalamu tupa aki pua apoto, yati pitane epene ateyanga andalane. ");
INSERT INTO ipi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Andoto, balato sipitisa koo wetete yanasa lamialu, utupane towa anda okonena peke loto, atalaini. Sipitisa koo kitupasa utupane pitaka akali okonenga ateyai-kola, akali okone bala kopeta wetete atalane. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisasato pii okone lo atea-kola, wandakali kambua epo amunguli peaini utupanena wanda mindimane pii taimane loto, nimba mandu yoto, andu geane wanda okone bala epele ape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wuane lea-kola, Jisasato wanda okonena pii leane okone yano peyoto, enene, namba mandu yane wanda okone bala epelewa peteya tekeko, Gotena pii oko ale wato, balana mana wato minalaini wandakali tupa epele wetete ape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wandakali kambua Jisasa ateanga mandaka wete epeai-kola, balato utupane lamawuato, wandakali yame koo andipa ateyai tupamane namba languato, Goteto nimba moyo ateya-kola, nimbato piape pilini oko andawa loyale, metekolo piape mindi pula lalaini tekeko, nambato metekolo piape mindi andipa napukale. Jia. Wamba Goteto potopesa akali Jona balanga metekolo piape mindi peane okonepene mindiki angu nambato matili pukale. ");
INSERT INTO ipi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wamba Jona balato Gotena pii oko Ninipa tane wandakali tupa lamawua atea-kola, utupane-mane balana pii okone ale wato, Goteto pii mindi nanima langeya lo andeaini-pia. Wuane pua teke, Akalina Iwanane okomane Gotena pii oko wandakali andipa ateyai tupa lamaiya-kola, utupane-mane balana pii okone ale wato, Goteto pii mindi nanima langeya lo andape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Wamba Jona bala Gotena pii oko Ninipa tane wandakali tupa lamawua atea-kola, utupane-mane ale wato, yamapane peke leainipia. Andipa Jona sia minene akali mindi epoto, Gotena pii lamawua ateya tekeko, wandakali andipa ateyai tupamane ale wato, yamapane peke naleyai. Tene okonena, matili Goteto wandakali tale pulu epola-angi, balato Ninipa tane wandakali tupapi, wandakali andipa ateyai tupapi, pitaka malinga ika laya ola-kola, Ninipa tane wandakali tupamane pii kenda-pene minditupa wandakali andipa ateyai tupanga yata olopeyai. Wamba kuwini wanda mindimane Simba yuu oko ando peteane-angi, wandakali-mane kiŋi Solomone bala mana andene akali mindi ateya leainipia. Wuane leai-kola, kuwini wanda okonemane balana pii ale wakale nembo toto, Simba yuu oko tepa alu, asia luu wete mindina pea-kola, kiŋi Solomoneto Gotena pii oko bala lamai-yaepia. Andipa kiŋi Solomone sia minene akali mindi epo ateya tekeko, wandakali andipa ateyai tupamane balana pii oko ale aa na-piyaini. Tene okonena, matili Goteto wandakali tupa pitaka malinga ika laya wato, utupane yapa lo tale pula-angi, kuwini wanda okonemane koo tene minditupa wandakali andipa ateyai tupanga yata olopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wuane lalu, Jisasato pii mindi tako pua loto, wandakali mindikipi mindimane lamu mindi kayuto, sisopene mindimane lamu okone ombo wato, too na-piyaini leaipia. Dee, wandakali mindikipi mindimane lamu mindi kayuto, waka mindisa too na-piyaini teke. Jia. Lamu okone tii pula-kola, andaka kolandaka lolai wandakali tupamane kuai lo andeakale nembo toto, wandakali-mane lamu mindi kayuto, tokonga yata alaini. ");
INSERT INTO ipi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nimbana lee oko nimbana umbaini okona lamu gulo tii piyane. Nimbana lee koo guleando, nimbato minditaka mindi kuai lo anda napulupele. Wuane tekeko, nimbana lee kuai lo wete teando, nimbato minditaka mindi kuai lo wete andolopele. ");
INSERT INTO ipi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Lamu mindimane kuai lo wete teya-kola, nimbato kuai lo andelene pua teke, nimbana lee kuai lo wete teando, nimbato minditaka mindi kuai lo wete andolo-peleko. Tii pene Goteto nimba giyane oko nimbato kuai lo anda napeendo, nimba undupi pangosa atene gulo atolene. Tika ando atape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisasato pii lo koyo pea-kola, Patasai mindimane Jisasa bala tomo nolo bakale ipu leaipia. Ipu lea-kola, Jisasa bala Patasai okonena andaka kolandaka loto, tomo noyale, toko mindina peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisasato tomo noyale balana kii wasa-wasa peya napene petea-kola, Patasai okonemane andoto, nembo kambua teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nembo kambua tea-kola, Akali Andane okomane Patasai okone lamawuato, kapo pelesapi, pangosa kalato atene eya-kola, Patasai yame yakamato kenga angu wasa-wasa peyalaini leaipia. Pake miaima lakae lo nembo talaini mana okopi, mana koo minaima lakae lo nembo talaini mana okopi, utupane yakamana ini anda-pangosa eya-kola, yakamato yamapane peke nalene atoto, umbaini kenga angu wasa-wasa peyalaini. ");
INSERT INTO ipi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yakamato wuane piyaini mana okonemane, yakama tane akali kee ene gulo ateyai. Goteto yakamana umbaini kenga angu waa piyu, yakamana yamapane pangosa waa napene, konda yape. Jia. ");
INSERT INTO ipi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yakama tanena umbaini kenga angu wasa-wasa peya napene, yakamato wandakali jia yo ateyai tupa ondowa moyoto, tomo pelesa tupanga yalane tupa neakale maiyapape. Maulai-kola, yakamana umbaini, yamapane-la, okonelapo lapotaka kalato nayene atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Patasai yame yakamato takaepi, palenapi, okonetaka tupa yomo paiyasanga tale pua yata wato, yomo mindi Gote opa maiyaini tekeko, yakamato Gote wayumane epele aa na-piyaini. Dee, yakamato wandakali yangone tupa towa mana tika-pene tupa wato mina na-piyaini teke. Yakamato mana epene utupane pitaka wato minapiai-yale, yakamana mana okone katu lapia-yale. Wuane tekeko, yakamato mana epene utupane pitaka wato mina na-piyaini okonemane yakama tane koyolo-peyama ya lo nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Patasai yame yakama lotu andaka poto, toko bulupane tupana pituyale epele wete alaini. Dee, yakamato wandakali kambua amunguli piyaini ama tupana ateyai-angi, wandakali waka tupamane yakama andoto, akali andane, nimba ani pelepe lapiai lakae lo nembo talaini. Yakama tane angu nembo talaini okonemane yakama tane koyolo-peyama ya lo nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wandakali mali wambane mindi yuu-mane ombo atane eya oko anda napene, yuu epenenga peyama nembo toto, wandakali tupamane mee ambe mali okone ango alu, palaini. Wuane pua teke, mana koo minauwa lakae lo nembo talaini mana oko Patasai yame yakamana ini anda-pangosa too pitane eya-kola, wandakali tupamane yakamana mana koo utupane anda na-piyaini. Yakamana nembo-tene koo yame tupa mo too peyai okonemane, yakama tane koyolo-peyama ya lo nembo talapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wuane lea-kola, loo tupana mana andene akali mindimane balana pii okone yano peyoto, tisa, Patasai tupamane mana koo miniyai lo nimbato pii lamaele-ko. Nanimatopi mana utupane minalamane okonena, nimbato pii lele okone nanima ando lene guleya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wuane lea-kola, Jisasato loo tupana mana andene akali tupa lamawuato, yakamato wandakali tupa mana lamawuato, loo kambua wetete wayumane wato minalapape lalaini. Wuane loto, yakamato kenda-pene andane minditupa utupanena paiyanenga yata maiyai-kola, utupane-mane kenda-pene utupane auwa-yale pitete alaini. Wuane tekeko, yakama tane kenda-pene okonepene tupana aŋako wetepi mindi aimakale lo makande na-piyaini. Mana okomane yakama tane koyolo-peyama ya lo nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","51","Wamba wete wandakali ungi lo ateaini okone angi, Keneto bala amene Epolo oko peyo ome leaipia. Okone angi tewa, loo tupana mana andene akali yakamana yumbane tupamane potopesa akali kambua peyo ome laka peainipia. Matili potopesa akali Sakataya bala lotu anda okona alata toko yane ongane mandaka atea-kola, loo tupana mana andene akali yakamana yumbane tupamane balapi peyo ome leainipia. Utupane-mane potopesa akali utupane wayu peyo ome leaini ya lo nembo toto, loo tupana mana andene akali andipa ateyai tupa yakamato potopesa akali utupanena mali tupa yati pimai-yaini. Tene okonena, Goteto yakama languato, yakamana yumbane tupamane potopesa akali kambua peyo ome leaini okonena, tene koo tupa wandakali andipa ateyai tupanga peakale nembo teyo leaipia. Tene koo utupane yakamanga peakale nembo toto, nambato potopesa akalipi, aposolo akalipi, utupanena minditupa wandakali andipa ateya utupanenga peakale lokale. Peakale lolowa-kola, wandakali andipa ateyai utupane-mane potopesa akalipi, aposolo akalipi, utupanena minditupanga kenda-pene andane tupa maiki piyu, minditupa peyo ome lolopeyai. Tene okonena, wandakali andipa ateya tupamane potopesa akali peyo ome leyai okona tene okopi, yakamana yumbane-mane potopesa akali wamba peyo ome leaini okona tene okopi, utupane pitakana tene koo oko wandakali andipa ateyai tupa yakamanga epolopeya lo nambato yakama langeyo-ko. Yakama tane koyolo-peyama ya lo nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Loo tupana mana andene akali yame yakama tane mana ini mia napene ato, wandakali waka tupamane mana mia napeakale teke nembo talaini. Wuane nembo toto, yakamato utupanena mana molane asini oko pai lamai-yaiko. Yakama tane koyolo-peyama ya lo nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Wuane lalu, Jisasa bala anda okone tepa alu, kamaka pea-kola, loo tupana mana andene akalipi, Patasaipi, utupane-mane Jisasa towa yataka wete wato, bala kosimi lamakale nembo teainipia. Wuane nembo toto, Jisasa kosimi lolane tene mindi ando moyale, utupane-mane pii kambua balanga tipa peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","3","Wandakali tausene kambua wete amunguli pua ateai-kola, wandakali yangone mindi angowa apiape-pene guleaipia. Angowa apiape-pene gulea-kola, Jisasato balana disaipolo tupa angu wamba ini bulupane lamawuato, wandakali-mane mana andipa too pua miniyai tupa pitaka matili panakame yolopeya leaipia. Pii andipa too pene eya tupa pitaka matili wandakali-mane ale wato, nembo tolopeyai. Wamba yakamato undupi pangosa pii minditupa leaini tekeko, matili nai tola-angi, wandakali-mane pii utupane panakame ale olopeyai. Wamba yakama lumu anda-pangosa wete okona atoto, pii minditupa akatete-mane leaini tekeko, matili wandakali pitaka-mane pii okone ale yakale nembo toto, wandakali mindimane anda tokonga atoto, pii okone taimane lolopeya. Patasai tupamane mana koo minditupa too pua minu atoto teke, owato yakama akali epene gulo atalaini. Palawa yangalaini pauta yisa okomane betesa mo andayalane pua, akali utupanena mana koo okonemane yakama mo lawa pula-kola, yakamato utupanena mana koo okone wato minulaini. Tika ando atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","7","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, muni ana lapo-mane wandakali-mane eka pilipimbi yau kambalaini tekeko, Goteto eka aŋako utupanena mindikipi mindi embesa aa napiyane leaipia. Wandakali yakama eka pilipimbi kambua wete sia minuto, lipinga-yale ateyai-kola, Goteto yakamana kawa itini ateya tupa dii lo andalane-ko. Yakama yuku aa na-piyapape. Amene yame, wandakali-mane katulo yakamana umbaini peyo ome lolopeyai tekeko, wuane piyu, utupane-mane katulo mangene waka mindi yakamanga napulu-peyai. Tene okonena, wandakali-mane yakama peyo omolaini nembo toto, yakamato yuku olaini lo nambato yakama langeyo. Yakamato Goteto angu ando yuku ape-pene tene oko nambato yakama langukale. Balato yakamana umbaini oko peyo ome lalu, katulo yakama yuu koo wetete okona awua aindaka lolopeya-ko. Yakamato bala angu yukuwa atalapape lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","10","Wandakali mindimane Akalina Iwanane oko laya-geando, Goteto balana koo okone apia-malupeya tekeko, wandakali mindimane Oli Sipitisa oko laya-geando, Goteto balana koo okone apia-mai napulu-peya. Wandakali tupana wenonga atoto, wandakali mindimane namba Jisasana yame ata napeyo leando, matili Gotena enjole tupana wenonga atoto, Akalina Iwanane nambato akali oko bala nambana yame ata napeya lolo-peyawa. Wandakali tupana wenonga atoto, wandakali mindimane namba Jisasa yame ateyo leando, matili enjole tupana wenonga atoto, Akalina Iwanane nambato akali oko bala nambana yame ateya lolo-peyawa. ");
INSERT INTO ipi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Yakama nambana yame ateyai nembo toto, Juta yame-mane yakama kosimi loyale, yakama andi lo awua poto, utupanena lotu andaka polopeyai. Alumindi tupana utupane-mane yakama andi lo awua poto, gapomane akali andanepi, kiŋipi, utupanena wenonga kosimi lolopeyai. Utupane-mane yakama kosimi lolai-angi, Oli Sipitisa okomane yakama mana languato, wua lalapa lolopeya-ko. Utupane-mane yakama kosimi lolai-angi, nanimato aki loto, utupanena pii okone yano peya-makalepe lo yakamato nembo kambua tolaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Okone angi, wandakali mindimane Jisasa lamawuato, tisa, nambana amene okomane nalipa ayianena paluni tupa tale puato, minditupa namba geakale, nimbato bala lamai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wuane lea-kola, Jisasato bala lamawuato, minditaka liyambana tupa tale piya wakale, apito namba jasa gulo ata leape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wuane lalu, balato wandakali waka tupa lamawuato, wandakali mindimane minditaka kambua yatawa ateando, balana minditaka kambua yolane utupane-mane saka atapowa atene tene oko balanga mai napulu-peyako. Yakamato minditaka kambua miaima lakae lo nembo tolaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wuane lalu, Jisasato pii kokoli mindi utupane lamawuato, wamba akali amango mindina eenga tomo kambua andayo ateane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tomo kambua andayo atea-kola, balato pii mindi loto, nambana tomo mandu yata olane anda tupa aŋako guleya-kola, nambana tomo tupa anu pukalepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nambana tomo yata alawane anda aŋako tupa anguto, anda andane minditupa pukale. ");
INSERT INTO ipi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Anda andane tupa piyu, nambana witipi, minditaka epene tupa pitaka anda utupanena mo yata wakale. Nambana minditaka epene utupane mali kambua katulo sia minu yola-kola, namba tane mee oto atoto, tomo, ipapi, utupane no, mini epene palu atokale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Akali amango okone bala kuai-lene atokale nembo teane tekeko, Goteto bala lamawuato, andipa utulu nimba omole-kola, minditaka kambua nimbato mo yomowa atele tupa apina yolopeyape lo nimbato nembo natene, keewa atele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wuane pua teke, wandakali mindimane Gotena pii oko ale wato, nemboto mina napene, yuu okona eya tupa angu kambua mo yomowa ateando, bala akali kee ene gulo atolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","24","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, yakamato eka tupa nembo talapape leaipia. Utupane-mane ee mindi puato, tomo mandu naa na-piyaini. Eka tupana tomo mandu yalaini anda mindi ata napiyane tekeko, Goteto eka utupane tomo neakale maiyane. Wandakali yakamato eka tupa sia minuto, lipinga yale ateyai okonena, Goteto yakamapi tomo nalapale gulupeya teke. Goteto yakamana umbaini oko waa puato, saka ateakale leane. Balato piape pitete-pene okone wamba ini piyu, andipa tomopi, umbaininga tona pulanepi, utupane pitete naene, yakama giyane-ko. Yakama tane kuai lo atamakale nembo toto, tomo nolanepi, umbaininga tona pulanepi, utupane anu pua mia-makale lo nembo kambua tolaini. ");
INSERT INTO ipi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Goteto wandakali mindi bala ee ana oko tuma ateakale lea-kola, wandakali mindi bala tane oto mindikipi mindi kimbu pua atokale loto, katulo oto mindikipi mindi mo kimbu napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yakama tane oto mindikipi mindi katulo mo kimbu napulu-peyai yando, anu peakale yakamato anu puato, tomopi, tonapi, minditaka tupa mia-makale yape lo nembo kambua teyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","28","Gote lo bilipi leyama nayu na-lalaini wandakali yakamato palawa dini epene yati-pene ateya tupa nembo talapape. Palawa dini tupa andipa angu epene atalane. Anate-lene kapu teya-kola, wandakali-mane palawa utupane yokowa apoto, yangalaini. Utupane angini mindi jia. Palawa dini epene utupane yakama tane yati epene tupa waa na-piyaini. Wuane tekeko, Goteto utupane yati-pene liyakale leya-kola, palawa dini utupanena yati tupamane kiŋi Solomonena tona epene yati-pene pua ateane tupa sia minalane lo nambato yakama langeyo. Goteto palawa dini utupanena yati wayumane pimai-yane pua, balato yakamana yati tupa gulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","31","Gotena pii ale naene aitene wandakali tupa pitaka-mane anu puato, tomo ipapi, utupane mia-makale yape lo nembo kambua talaini tekeko, yakamana ayiane ati kenga ateya okomane tomo ipapi yakama nalapale nembo toto gulupeya-ko. Yakamato tomo ipapi, ani tawe namakalepe lo nembo kambua natene, Goteto yakama ando ateakale nembo talapape. Yakamato wuane nembo tolai-kola, Goteto okonetaka tupa pitaka yakama gulupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","34","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, nambana sipisipi yame aŋako tupa, yakamana ayiane ati kenga ateya okomane yakama epelewa moyo ando atokale leane leaipia. Wuane leaneko, yakamato yuu okona minditaka eya tupa yamapane mawua ata napene, yakamana minditaka yolai tupa muni moto, wandakali tipia tupa moyo maiyapape. Yakamato wuane peaindo, ati kenga minditaka epene wete yakamana yolai tupa pausa koya napiyane mindina muni yalane pua yolopeya. Minditaka ati kenga yola tupa wandakali-mane katulo pake mia napulu-peyai. Puyapuya-manepi katulo utupane nanolo-peyako. Yakama tane minditaka jia yolane lo yuku naene, yakamana minditaka epene yolane tupa muni moto, wandakali tipia tupa moyo maiyapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","38","Wuane lalu, Jisasato pii kokoli mindi loto, akali amango mindi yuu tepanda mindisa wanda waitapu mindi andolo peane leaipia. Matili bala peke loto, asia lombanga peya geao-geao lola-angi, balana piape akali tupamane asia lumbamakale lo maliyo atalaini. Utulu tombe yandopi, waa loyale pula-kola yandopi, bala peke loto andola-kola, balana piape akali tupa limu pali napene, lamu kayu yatawa, balana piape pimauwayale mandeke pitawa maliyo ateaini yando, balato akali utupane towa epele olopeya. Epele wato, balato utupanena tomo mandeke puato, nalapa lo maula-kola, piape akali utupane-mane epele wete olopeyai. Wuane pua teke, Akali Andane oko bala epolopeya nembo toto, yakamato mandeke pitawa atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anda anduane mindimane andola-kola, pake nalane akali mindi oko angi epolopeya lo andapia-yale, pake nalane akali okonemane balana anda okone keao leakale lo balato ando konda napipia-yale lo yakamato nembo talapape. ");
INSERT INTO ipi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wuane pua teke, yakamato Akalina Iwanane oko naepolo-peya nembo tolai-angi, bala epolo-peyako. Bala epolopeya nembo toto, yakamato mandeke pitawa atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisasato wuane lea-kola, Pitato bala lamawuato, Akali Andane, wandakali pitaka-mane pii kokoli nimbato lele okone ale yakale nembo toto, lelepe. Pee, nanima angu langelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wuane lea-kola, Akali Andane okomane bala lamawuato, akali andane mindi bala yuu tepanda mindinga poyale atoto, balana piape akali mindi lamawuato, nimbato piape akali yangone tupa ando atoto, utupane tomo neakale tale pua maiki pipe lolopeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Nambato pii enene mindi yakama langeyo. Piape ando atalane akali okonemane akali andane okona pii lolane oko ale wato, piape okone kuai lo pua ateando, matili akali andane oko bala peke loto, piape okone andolopeya. Andoto, balato balana piape akali okone lamawuato, nimbato nambana minditaka tupa pitaka ando atola lolopeya. Wuane lola-kola, piape akali epene okone bala epele wete olopeya. ");
INSERT INTO ipi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Wuane tekeko, piape ando atalane akali okonemane balana akali andane oko ini peke nalolo-peya nembo toto, tomo ipapi, kambua noto, kee aka pua atoto, piape akalipi, piape wandapi, utupane minu peyaka pua ateando, okone angi teke balana akali andane oko epolopeya. Akali andane oko epoto, piape akali koo okone peyo watoto, pii tanga lalaini wandakali tupa towa atolo peakale lolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","48","Wandakali mindimane minditaka kambua wandakali waka mindi yano maiyando, yano maulane akali okomane matili minditaka kambua wete yano peyo gii lolopeya. Goteto minditaka kambua wandakali mindi maiyando, minditaka kambua molane wandakali okonemane minditaka kambua teke yano peyo Gote maipe-pene. Akali andane mindimane piape mindi pipe-pene eya nembo teya-kola, balana piape akali okomane piape oko pulane eya nembo natene, konda yando, akali andane okomane balana piape akali okone kunju-mane mee teke peyolo-peya. Wuane tekeko, akali andane okomane piape akali mindi lamawuato, nimbato piape oko pii lola-kola, piape akali okonemane piape okone pulane eya nembo toto teke konda yando, akali andane okomane piape akali okone kunju-mane ole kambuanga peyolo-peya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wuane lalu, Jisasato pii mindi tako pua loto, yuu oko teakale nembo toto, nambato ita lengane peyo tepa olo epewane leaipia. Ita okonemane ungi lo yuu oko wamba ini tapia lakae lo nembo teyo-kola, ini taa napeya. ");
INSERT INTO ipi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nambato ipa mindi molowa-kola, ita okone katulo tolopeya nembo teyo tekeko, nambato ipa okone wamba ini mia napene atoto, yamapane kenda wete eyo. ");
INSERT INTO ipi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yuu okona wandakali-mane yanda pua ateyai tupa nambato minu koyo piya oyale epeane lo yakamato nembo teyaipe. Jia. Wandakali yame tupa mo toko laya olo epewane lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","53","Andipapi, matilipi, anda mindikina wandakali yau paliyaini tupana minditupa-mane namba lo bilipi lolai-kola, minditupa-mane namba lo bilipi nalolo-peyai. Wandakali utupane yame lapo gulo atoto, namba lo bilipi nalolai wandakali tupamane namba lo bilipi lolai wandakali tupa yanda pimalu-peyai. Iwanane okomane namba lo bilipi lola-kola, ayiane okomane iwanane okone yanda pimalu-peya. Ayiane okomane namba lo bilipi lola-kola, iwanane okomane ayiane okone yanda pimalu-peya. Wuane pua teke, wanane angini-la mindi peya-peya piyu, toko laka pulu-peyapi. Akali mindina wetene okomane akali okonena angini oko towa peya-peya piyu, toko laka pulu-peyapi. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wandakali kambua amunguli pua ateai-kola, Jisasato utupane lamawuato, nai andaka palanesa-tole mole yoto, yuu undupi lele peya-kola, yakamato kingi epolopeya ya leyai-kola, kingi epalane. ");
INSERT INTO ipi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ati tundupa pua yapiakoko eya-kola, yakamato andipa panyu pulupeya ya leyai-kola, panyu piyane. ");
INSERT INTO ipi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yuu okona mangene mindi peya-kolapi, atinga mangene mindi peya-kolapi, yakamato mangene utupane andoto, wua pulupeya lalaini. Wuane tekeko, andipa Goteto mangene minditupa pua ateya-kola, anu peakale yakamato mangene utupane andoto, anu pulu-peyape lo nanimato nembo nateyama leyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","59","Yano mindi nimbanga yola-kola, nimbato yano okone peya napene konda eendo, yano anduane okomane nimba atu jasa atolanga poto, nimba kosimi lola-kola, jasa okomane nimba andi lolopeya. Andi lola-kola, yanda yene tupamane nimba katapusa anda okona andi lo aindaka lolopeyai. Andi latane atoto, nimbanga yano yolane tupa pitaka peyo koyo piyu, matili nimba katapusa anda oko tepa alu, polopele. Tene okonena, akali andane mindimane nimba kosimi loyale pula-kola, liyamba lapotaka jasa andolo poyale polapi-angi, balato nimba andi lolane. Bala towa wamba ini pii lo tika piyapape. Wandakali mindimane yakama kosimi loyale peando, balato yakama kosimi lo andi lolane nembo toto, yakamato bala towa wamba ini pii lo tika piyaini. Andipa Goteto yakama kosimi loyale peya-ko. Anu peakale yakamato mana tika-pene tupa wato mina napene, konda yaipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Okone angi, wandakali ateaini tupana minditupa-mane pii temane mindi Jisasa lamawuato, wamba Galili disitiki tane wandakali minditupa-mane Gote lo tama puato, sipisipi maputane yango ateaini leainipia. Yango ateai-kola, gapomane akali kawane Pailateto balana ami yanda yene minditupa-mane wandakali utupane peyo ome leakale leaipia. Wuane lea-kola, ami yanda yene utupane-mane wandakali utupane peyo ome lalu, utupanena tundupa oko sipisipi maputane wandakali tupana tundupa towa mina mindiki leai leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wandakali ateaini tupamane pii temane okone Jisasa lamai-yaikola, balato utupane tipa puato, yakamato aki nembo teyaipe leaipia. Galili disitiki tane waka tupa pitaka sia minuto, Galili disitiki tane utupane-mane mana koo wete mindi mineaini oko Goteto andoto, kenda-pene andane okone utupanenga epeakale leane nembo teyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jia. Goteto wuane napeane tekeko, yakama pitaka yamapane peke naleaindo, yakamapi wuane pua teke omolo-peyai lo nambato yakama langeyo. ");
INSERT INTO ipi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wamba Silomo okona anda luu kenga wete mindi pili toto, wandakali paiyasanga kitupasa peyo ome leaipia. Wandakali utupane-mane Jutusaleme tane waka tupa pitaka sia minuto, mana koo wete mindi mineaininga andoto, Goteto utupane peyo ome leane lo yakamato nembo teyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jia. Goteto wuane napeane tekeko, yakama pitaka-mane yamapane peke naleaindo, yakamapi wuane pua teke omolo-peyai lo nambato yakama langeyo. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wuane lalu, Jisasato pii kokoli mindi loto, akali mindimane balana getepe ee okona poto, ita piki mindi yandeane leaipia. Yandoto, mali dindi lo ita okonena dini liyape lo andolo ipuku pea-kola, ita okonenga dini mindi lia napeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Matili mali tepo pea-kola, balato ee ando atalane akali oko lamawuato, akatupi, mali tepo utupanena ita piki okonga dini liyape lo, nambato andolo ipuku pewa-kola, dini mindikipi mindi lia napiyae yako. Anu peakale ita okomane nambana getepe ee oko mo oke yo ateyape. Nimbato ita oko yokowa apia leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wuane lea-kola, ee ando atalane akali okomane ee anduane okona pii okone yano peyoto, akali andane, ee ana mindiki oko angu ita oko ateakale lo ando kondaa leaipia. Ateakale lo ando kondole-kola, nambato ita okone yuu koyo oma pua, bulumako ii mauwakale. ");
INSERT INTO ipi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wuane puluwa-kola, matili ita okona dini katulo liyando, ateakale lo ando kondamakale. Dini lia napeando, nimbato ita oko yokowa apola leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sambasa angi Jisasato Juta yamena lotu anda mindina poto, wandakali peteaini tupa pii mana lamawua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Okone angi, sipitisa koo atene wanda mindi lotu anda okonena peteaipia. Wamba sipitisa koo okonemane wanda okona masiane minu aku pea-kola, bala katulo tika pua atape nayaepia. Siki okone pali-pata petea wete, mali paiyasanga kitupasa peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisasato wanda okone andoto, ipu lea-kola, wanda okone epeaipia. Epea-kola, Jisasato bala lamawuato, wanda, nambato nimbana siki oko mo atu eyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wuane lalu, balana kini wanda okonenga yata ya-kola, wanda okone kapoyale ika lo tika pua atoto, Gote lo tama peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sambasa angi Jisasato wanda okone mo atu yane oko andoto, lotu anda ando atalane akali okomane yataka wato, wandakali tupa lamawuato, ole wataka angu piape pua atoto, Sambasa angi mee atape-peneko. Akali mindimane yakamana siki mindi mo atu yakale nembo teaindo, Sambasa angi yakama ipu napene kondalu, piape piyamane oto wataka eya tupana mindi ipulupape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Wuane lea-kola, Akali Andane okomane balana pii okone yano peyoto, Sambasa angi yakama pitaka-mane yakamana bulumako anda tupana poto, bulumako tupapi, dongi tupapi, utupane ipa neakale tinga loto, yakamato atu na-palainipe leaipia. Wanda oko bala Apatakame yame okona mandiyene tekeko, Sataneto wanda okona masiane minu aku pea-kola, wanda okone bala siki okonemane andi latane gulo petea-kola, mali paiyasanga kitupasa peane-ko. Sambasa angi nambato wanda siki oko mo atu naene, bala siki okonemane andi latane gulo peteakale lo ando kondape-pene lo yakamato nembo teyaipe. Yakama wandakali koo atoto teke, yangone tupa minakasa oyale, owato yakama wandakali epene gulo ateyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wuane lea-kola, bala towa yanda-pene wandakali tupamane balana pii okone ale wato, yala yaini tekeko, wandakali waka tupamane Jisasana piape epene tupa pitaka nembo toto, epele wete yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wandakali tupamane epele yai-kola, Jisasato pii kokoli mindi wandakali utupane lamawuato, Goteto wandakali ando atalane piape oko anu-pene eyape leaipia. Nambato piape okone aki mindi towa makande puape. ");
INSERT INTO ipi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gotena piape okone maseta waini ika lo andayalane okone towa makande pene eya. Wamba akali mindimane maseta waini tupa moto, balana eenga papaka leaipia. Papaka lea-kola, waini utupane poka lo anda yoto, andane ita yale gulo ateyai-kola, eka tupa maseta kembone tupana anda piyaini. Wuane pua teke, Goteto wamba ini bulupane wandakali aŋalapo minditupa angu ando atoto, piape pua ateya-kola, matili balana yame tupa andane wete gulalaini. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wuane lalu, Jisasato pii kokoli waka mindi loto, Goteto wandakali ando atalane piape oko aki mindi towa mandeke puape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gotena piape okone palawa yangalaini pauta oko towa makande pene eya. Wamba wanda mindimane palawa yangoyale, palawa kapo tepo disa andane mindina tepa wato, palawa yangalaini pauta aŋalapo mindi palawa okone towa mina mindiki leaipia. Mina mindiki lea-kola, pauta aŋalapo okonemane palawa okone mo andayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisasa bala Jutusaleme poyale ato, tano aŋakopi, andanepi, utupanena wandakali tupa mana lamaiki pima peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","28","Mana lamaiki pea-kola, Juta yamena akali mindimane bala tipa puato, Akali Andane, matili Goteto wandakali tale pulu epola-angi, balato wandakali aŋalapo angu molo-peke lolo-peyape leaipia. Wuane lea-kola, Jisasato utupane lamawuato, matili anda anduane okomane ika loto, balana anda okona asia pili lola-kola, wandakali kambua takita atolopeyai leaipia. Yakamato takita atoto, anda asia lomba peya geao-geao loto, bala lamawuato, Akali Andane, nanima andaka ipumakale. Nimbato asia lumba-kae lolopeyai. Yakamato wuane lolai-kola, anda anduane okomane yakamana pii lolai okone yano peyoto, nambato yakama anda na-peyawaneko. Yakama ani tanepe lolopeya. Wuane lola-kola, yakamato anda anduane oko lamawuato, wamba nimbato nanimana tano tupana atoto, mana langua atee-kola, nanima nimba towa tomo ipapi atu no atalamae piako lolopeyai. Wuane lolai-kola, balato yakamana pii okone yano peyoto, nambato yakama anda na-peyawane. Yakama ani tanepe. Koo piyaini wandakali yakama pitaka namba ateyonga naepene, pulupa lolopeya. Wuane lola-kola, yakama balana anda okonena katulo kolandaka nalolo-peyai. Okone angi, Apatakamepi, Aisakepi, Jekopopi, potopesa akali tupapi, utupane pitaka Gotena yuu epene okona atolai-kola, yakama takita atoto, utupane andolopeyai. Andoto, yakama utupane towa atu ataima lakae lo nembo toto, mini kenda wato, yamataka loto, yakamana ambulini pai lo nolopeyai. Wandakali kambua Gotena yuu epene okona asia lomba aŋako okona kolandaka lamakale lo mandeke pulupeyai tekeko, Goteto jia lola-kola, utupane takita atolopeyai. Kenda-pene okone yakamanga epolane nemboto, Gotena yuu epene okona asia lomba aŋako okonena wamba ini kolandaka loyale taimane mandeke pua atalapape leyo. ");
INSERT INTO ipi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","30","Andipa akali minditupa gene yene gulo ateyai-kola, yuu waka tane wandakali tupa gene nayene gulo ateyai tekeko, matili wandakali minditupa yuu waka-waka tupa pitakana atoto, Gotena yuu epene okona epoto, tomo no pitulu-peyai. Okone angi, utupane gene yene atolai-kola, wandakali andipa gene yene gulo ateyai tupana minditupa gene nayene atolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ole okone angi teke, akali Patasai minditupa Jisasa ateanga epoto, akali Etoteto nimba peyo ome loyale peya-ko. Nimba yuu oko tepa alu, yuu waka mindisa puu leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Wuane leai-kola, Jisasato utupane lamawuato, yakama poto, langa-langa piyane peango anatope gulene akali okone lamawuato, wua lalapape: Wamba potopisa akali tupa yuu waka tupana ataka peai-kola, wandakali-mane utupane peyo ome laka napeainipia. Jia. Jutusaleme tano okona ataka peai-kola, wandakali-mane utupane peyo ome laka peainipia. Tene okonena, namba Jutusaleme atolowa-kola, utupane-mane namba peleakale nembo toto, andipapi, anatipi, namba Jutusaleme epoyale epeyo. Sipitisa koo tupa peyo wataka, wandakali siki pelene tupa mo atu yaka pima pulu, ole teponena namba Jutusaleme ipapowa epoto, nambana piape oko pikoyo pukale lala lo yakamato Etote lamai-yapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wuane lalu, Jisasato pii waka mindi loto, akatupi, Goteto pii akali minditupa Jutusaleme yuu okona epeakale lea-kola, Jutusaleme tane wandakali yakamato akali utupane ana-mane peya, potopesa akali tupa peyo ome laa, peaini leaipia. Eka angini-mane balana andopane tupa papakane pangosa yapu lo ombo alane pua, nambato ole kambuanga Jutusaleme tane wandakali yakama mo amunguli puato, ando atokale nembo tewa tekeko, yakamato jia leai. ");
INSERT INTO ipi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tene okonena, andipa ato tewa yakama tane yakamana anda oko ando atalapale loto, nambato yakama tepa alu pokale. Polowa-kola, yakamato namba anda napene atolopeyai lo nambato yakama langeyo. Matili yakamato pii mindi loto, Goteto akali epeya oko moyo ateakale lolai-angi, yakamato namba dee lapone andolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sambasa angi Jisasa bala Patasai akali kawane mindina andaka tomo nolo pea-kola, Patasai minditupa anda okonena atoto, Jisasato aki peyape lo andatawa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ole okone angi, akali umbaini andayo koyene mindi Jisasa peteane mandaka ongane peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Petea-kola, Jisasato loo tupana mana andene akali tupapi, Patasai tupapi, utupane tipa puato, Gotena loo okomane aki leyape. Sambasa angi mindimane wandakali siki pelene mindi mo atu yando, okone katupe, jiape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wuane lea-kola, utupane-mane balana pii okone yano peyoto, pii mindi lapeke naleainipia. Lapeke naleai-kola, Jisasato akali okone mo atu yalu, nimba puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Akali okone mo atu yalu, Jisasato Patasai tupa tipa puato, Sambasa angi yakamana iwanane yandopi, yia bulamakao yandopi, mindi ipa yuli tomba-yene mindina ayia peyola-kola, yakamato bala omeakale lo ando kondolo-peyaipe. Pee, yakamato bala wamba ini molo-peyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wuane lea-kola, akali utupane-mane Sambasa angi yakama tane piape minditupa piyaini nembo toto, pii mindikipi mindi katulo yano peya napeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Patasai akali kawane mindina andaka nolo epeaini wandakali tupamane akali andane gene yene pitiyaini toko epene tupana pitima lakae lo nembo teainga andoto, Jisasato pii mindi utupane lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","11","Balato pii okone utupane lamawuato, wandakali mindimane bala tanena gene oko laiyu leando, Goteto bala napinga yale ateakale laya olopeya leaipia. Akali mindi bala gene nayene gulo ateando, Goteto bala lipinga yale ateakale laya olopeya. Akali mindimane tomo andane mindi yangoto, nimba tomo nolo ipu lola-angi, nimba poto, akali andane pitiyaini toko okona peteendo, akali andane gene yene nimba sia minene mindi tomo nolo epolopeya. Epola-kola, akali tomo yangolane anduane okomane nimba languato, nimba petele toko okonena akali oko peteakale mai lola-kola, nimba yala andane mindi wato, masianenga wete poto, pitulu-pele. Akali mindimane nimba tomo namakale ipupe lola-angi, nimbana gene andane yakale nayuto, akali andane pitiyaini toko mindina piti napene, toko masianenga yolane mindina pitipe. Pitule-kola, akali nimba ipu lola okomane nimba languato, amene, nimba toko mandaka onga piti lola-kola, nimba towa tomo no pitulaini wandakali tupa pitakana wenonga nimbana gene andane yolopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wuane lalu, Jisasato akali bala tomo namakale ipu leane oko lamawuato, wua leaipia: Nimbato tomo mindi yangole-angi, nimbana yamepi, amenepi, tee akalipi, nimba towa epelewa atalaini akali amangopi, utupane tomo namakale ipulupa leendo, matili utupane-mane tomo yango paini nimba gulaini tupa nimbana yole gulo yolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Nimbato tomo andane mindi yangoto, wandakali koo tipiapi, kee koopi, lee koopi, utupane tomo namakale ipulupa leendo, utupane-mane nimbana tomo yango maulene tupa katulo paini yango gii napulu-peyai. Gii napulai-kola, matili Goteto wandakali epene tika-pene tupa malinga ika laya ola-angi, nimbana tomo yango maulene tupa paini yano peyoto, nimba mo epele aya olopeya-ko. Nimbato tomo andane mindi yangole-angi, wandakali koo tipiapi, kee koopi, lee koopi, utupane lamawuato, tomo namakale ipulupa lape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tomo no peteaini akali utupanena mindimane pii Jisasato leane okone ale wato, bala andayo, Gotena yuu epene okona atoto, tomo no atolai wandakali tupa mini epene palu atolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wuane lea-kola, Jisasato pii kokoli mindi loto, alumindi akali mindimane tomo andane mindi yangokale leane leaipia. Wamba ini akali okonemane tomo nolane wandakali kambua minditupa lamawuato, matili nambato yakama ee lolowa-angi, yakamato tomo nolo ipulupape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Matili tomo nolane oto okone epea-angi, balato balana piape akali mindi lamawuato, nimba poto, wandakali utupane lamawuato, tomo tupa pitaka yango mandeke pitane eya-ko. Yakamato nolo ipulupa lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tomo yangeane akali okomane leane pua, balana piape akali okonemane poto, wandakali utupane-mane tomo nolo ipulupa lo lamaiki peaipia. Lamaiki pea-kola, akali mindimane piape akali okone lamawuato, nambato yuu mindi kambauwane oko andolo pupe-pene guleya leaipia. Nambato katulo nimbana tomo nolo na-epeyoko. Yataka olene lala lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Akali lapone okomane piape akali okone lamawuato, nambato yia bulumako paiyasa kambauwane tupamane nambana piape mindi pingeakale mandeke pulu pokale leaipia. Nambato nimbana tomo nolo na-epeyoko. Yataka olene lala lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Akali tepone okomane piape akali okone lamawuato, nambato wanda mindi kee lauwa-ko. Nambato katulo nimbana tomo nolo naepeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","24","Akali utupane pitaka-mane wuane leai-kola, piape akali okone peke loto, wandakali utupane pitaka-mane tomo nolo na-ipumakale lalai loto, balana akali andane oko lamai-yaepia. Lamaiya-kola, anda anduane okomane yataka wato, balana piape akali okone lamawuato, wandakali wamba ipulupape lewa utupane matilipi nambana tomo oko nanolo-peyai lo nambato nimba langeyo leaipia. Nimba taimane poto, tano okona asini aŋakopi, andanepi, utupanena poto, wandakali tipiapi, lee koopi, kee koopi, utupane lamo atu namba andaka ipupe leaipia. Akali Andane okomane wuane lea-kola, piape akali okonemane wandakali utupane lamolo peaipia. Lamo atu epoto, balato anda anduane okone lamawuato, Akali Andane, nimbato lale pua teke piyo-kola, nimbana anda okona tomo no pitulane panda minditupa mee anana eya leaipia. Piape akali okonemane wuane lea-kola, akali andane okomane bala lamawuato, nambana anda oko tumbi leakalenga, nimbato tano oko tepa alu, asini andane tupapi, ee asini aŋako tupapi, utupanena poto, wandakali minditupa ayia puato, lamo atu ipupe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Jisasa bala asia pea-kola, wandakali yame kambua bala pea okona watama epeainipia. Watama epeai-kola, Jisasato anda-peke loto, utupane lamawuato, wandakali mindimane nambana disaipolo atokale nembo teando, matili anu pulu-peyape lo wamba ini wayumane nembo tape-pene leaipia. Bala nambana disaipolo atola mambele, balana angini ayianepi, wetene andopanepi, amene imalinipi, utupane-mane bala towa pii yanda pulai-kola, balato namba awua tepa yando, bala katulo nambana disaipolo ata napulu-peya. Dee, bala nambana disaipolo atola mambele, akali mindimane bala peyo ome loyale pula-kola, bala oma napukale nembo toto, namba awua tepa yando, bala katulo nambana disaipolo ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wuane pua teke, wandakali mindimane nambana yame atola mambele, kenda-pene minditupa balanga epoto, balana ita malamanda gulo yola-kola, balato kenda-pene utupane awua, namba watama na-epeando, bala katulo nambana disaipolo ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","30","Yakamana mindimane anda andane mindi pukale nembo teando, balato anda okone pikoyo pulane muni oko katulo eyope lo wayumane ini nembo natene, piape okone ika lo pulu-peyape. Jia. Balato wuane napulu-peya. Anda okone pikoyo pulane muni nayando, balato anda kumu ini minalu, anda okone pua apialu, kondolo-peya. Wuane peando, wandakali waka tupamane akali okone ando lamba loto, akali okonemane anda oko puyale pipia tekeko, katulo pikoyo napeya okonde lolopeyai. Wandakali-mane wuane lolaini nembo toto, nimbato anda mindi pukale nembo teendo, anda okone pikoyo pulane muni oko katulo eya lo wamba ini andoto, piape okone pipe-pene. ");
INSERT INTO ipi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","Dee, ami yanda yene (20,000) tausene paiyasa lapo yatawa atalane kiŋi mindimane kiŋi waka mindi yanda pimauwakale loto, asininga epo atola-kola, kiŋi mindoko-mane ami yanda yene (10,000) tausene paiyasa mindiki angu yatawa ateando, balato wamba wua lo nembo tape-pene: Nambana ami yanda yene (10,000) tausene paiyasa mindiki okomane ami yanda yene (20,000) tausene paiyasa lapo yatawa atalane kiŋi oko katulo sia minulu-peyope, sia mina napulu-peyope nembo tape-pene. Balato katulo sia mina napulu-peyo nembo teando, kiŋi mindoko-mane mandaka gulo naepola-kola teke, ami yanda yene (10,000) tausene paiyasa mindiki yatawa atalane kiŋi okomane yanda kondapa loto, akali minditupa kiŋi mindoko towa pii ini lo tika pulu peakale lape-pene. Akali utupane-mane kiŋi mindoko lamawuato, nanimato aki taka mindi guluma-kola, nimbato nanima towa yanda pi-gii napene kondolape lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wuane pua teke, yakamato yakamana minditaka tupa pitaka masia mai napeaindo, yakama katulo nambana disaipolo ata napulu-peyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wuane lalu, Jisasato pii mindi tako pua loto, sole-mane tomo mo tende piya alane tekeko, sole minditupa tende napene guleando, anu pua, nanimato sole okone dee lapone mo tende piya olo-peyamape. ");
INSERT INTO ipi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sole koo okonepene tupa yuu kangalamu towa mina mindiki loto, eenga gae lemando, eenga tomo kuai lo ika nalolo-peya. Wuane nembo toto, wandakali-mane sole koo okonepene tupa mee apialaini. Wandakali ale asia yene tupamane pii okone ale wato, nembo talalape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Alu mindi koo piyaini wandakali tupapi, takisa muni mialaini akali tupapi, utupane pitaka-mane Jisasato aki leyape lo ale oyale, bala ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Epeai-kola, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane mulu-mulu loto, koo piyaini wandakali tupa epeyai-kola, Jisasato utupane lamawuato, yakama wayu epeyai loto, utupane towa tomo no pitiyane leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Wuane leai-kola, Jisasato pii kokoli mindi akali utupane lamawuato, yakamana mindimane sipisipi (100) wane andete yatawa atola-kola, utupanena mindiki angu alu peando, balato anu pulu-peyape leaipia. Balato sipisipi (99) paiyasa pilisanga pilisa tupa yuu mindinga tani no ateakale lalu, sipisipi mindiki alu pulane okone ayia pulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Matili balato sipisipi okone ando moto, mini epene paliyu, sipisipi okone balana paiyanga aiyu, andaka peke lolopeya. Peke loto, balana yamepi, yuu okonena atalaini wandakali tupapi, utupane pitaka epo amunguli piyapa lolopeya. Epo amunguli pulai-kola, akali okonemane wandakali utupane lamawuato, nambana sipisipi alu pipia oko ayia pua ando moto, awua epeyo-ko. Nanima pitaka-mane epele ama lolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wuane pua teke, wandakali (99) paiyasa pilisanga pilisa epene tika-pene atalaini utupane mini peke nalape-pene gulo ateyai lo andoto, enjole ati kenga atalaini tupamane epele alaini tekeko, koo piyane wandakali mindi bala yamapane peke leya-kola, enjole ati kenga atalaini tupamane epele andane wetete alaini lo, nambato yakama langeyo. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wuane lalu, Jisasato pii kokoli waka mindi loto, wanda mindimane muni silipa-mane waa-pene paiyasa yatawa pitula-kola, muni utupanena mindiki alu peando, wanda okonemane anu pulu-peyape leaipia. Balato lamu mindi kayuto, anda-pangosa kangalamu tupa aki puato, muni okone ayia pua andoto, molopeya. ");
INSERT INTO ipi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ando moto, balana yamepi, yuu okonena atalaini wandakali tupapi, utupane pitaka epo amunguli piyapa lolopeya. Epo amunguli pulai-kola, wanda okonemane wandakali utupane lamawuato, nambana muni alu pipia oko ayia pua andoto, mialo-ko. Nanima pitaka-mane epele ama lolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wuane pua teke, koo piyane wandakali mindimane yamapane peke leya-kola, enjole ati kenga atalaini tupamane epele alaini lo nambato yakama langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wuane lalu, Jisasato loo tupana mana andene akali tupapi, Patasai tupapi, utupane towa pii kokoli mindi loto, akali mindimane iwana lapo mandeane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Matili iwana lapone okomane bala ayiane lamawuato, ayiane, nimbato paluni matili tale puato, namba gukale nembo tele tupa andipa namba tale pua gii leaipia. Wuane lea-kola, ayiane okomane minditaka balana yane tupa iwanane okonelapo tale pua mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tale pua maya-kola, iwana lapone oko bala ole mindilapo angu yuu okonena atalu, balana minditaka utupane pitaka muni mialu, yuu tepanda mindisa poto ateaipia. Yuu okonena atoto, balato mana koo kambua minaka puato, balana muni tupa pitaka apia koyo peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Balana muni koyo pea-kola, yuu bala ateane okonena ulia nono andane mindi yaepia. Ulia nono ya-kola, ulia tomo nolanepi, tona umbaininga pulanepi, utupane balanga jia yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jia ya oko andoto, balato yuu okonena tane akali mindina piape pimalu peaipia. Pea-kola, piape anduane okomane iwana okone lamawuato, nimbato nambana yia tupa yuu maliwa mindina tomo mawua yatawa atolo puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wuane lea-kola, iwana okonemane tupasia imbuni tupa yia tupa neakale mawua ateaipia. Yia tupamane tupasia imbuni tupa no ateai-kola, iwana okonemane ulia nono wato, tupasia imbuni utupanena minditupa nokale nembo teane tekeko, wandakali mindimane tupasia imbuni mindi bala neakale mai napeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mai napeai-kola, balato tika pua nembo toto, namba ayianena piape akali tupa pitaka-mane ulia kambua yatawa no ateyai-kola, namba yuu okona atoto, nono-mane omeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Andipa nambato ika lalu, namba ayiane ateyanga peke loto, bala lamawuato, ayiane, nimbangapi, Gotengapi, nambato mana koo minditupa minauwa lokale. ");
INSERT INTO ipi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nambato wuane pewa okonena, andipa namba nimbana iwanane nalola. Namba nimbana piape akali atokale lo nimbato ando kondaa lokale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wuane lalu, iwana okone ika loto, bala ayiane ateanga poyale peane tekeko, bala asininga wene amonga-yale epea-kola, balana ayiane okomane balana iwanane oko epeanga andeaipia. Andoto, ayiane okonemane ondo wete wato, taimane poto, iwanane okone bulu ope loto, nunu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wuane pea-kola, iwana okonemane balana ayiane oko lamawuato, ayiane, nimbangapi, Gotengapi, nambato mana koo minditupa minauwa-ko. Nimbato namba nimbana iwanane nalola leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Balato wuane leane tekeko, ayiane okonemane balana piape akali tupa lamawuato, wamba nambana iwanane oko omala taka alu peane tekeko, andipa bala saka atolo-peke leya-kola, nanimato bala andeyama. Tene okonena, yakama taimane poto, tona luu epene wete mindi yolopeya oko mo awua epoto, balanga pimaiyu, balana kiinga liŋi mindi pete lamaiyu, balana keenga sukee piya maiyu, piyapa. Bala peke leya okonena, nanimato epele wato, tomo no piti-makalenga, akali mindilapo-mane poto, yia bulumako andopane andane-yale mindi atapia oko atu epoto, peyo yangalapa leaipia. Wuane lea-kola, utupane-mane tomo yango no, epelewa peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Utupane-mane epelewa peteai-kola, akali okonena iwanane bulupane oko bala eenga atalu, anda okona mandaka epoto ale ya-kola, wandakali kambua-mane musiki peyo, danisa lo ateai oko ale yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ale wato, balato piape akali mindi ipu loto, wandakali utupane-mane aki pua ateyaipe lo tipa peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tipa pea-kola, piape akali okonemane bala lamawuato, nimbana amene piako sikipi mindi mia napene, peke lala-kola, nimba ayiane-mane epele wato, yia bulumako andopane andane-yale mindi atapia oko peyo yawala leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wuane lea-kola, iwana bulupane okomane yataka andane wetete wato, anda okonena kolandaka na-lokale nembo toto, bala kamaka ateaipia. Kamaka atea-kola, balana ayiane okomane kamaka poto, bala mo epele oyale, iwana nimba andaka ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wuane lea-kola, iwana bulupane okomane lapeke loto, mali ana kambua namba nimbana piape akali gulo atoto, ole mindikipi mindi nambato nimbana pii tanga nalewa leaipa. Nambato nimbana pii tanga nalewa tekeko, namba towa epelewa atalamane akali tupa towa epelewa tomo no pitiyapa lo, nimbato meme andopane mindi namba gii napee. ");
INSERT INTO ipi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wuane tekeko, nimbana iwanane lapone okomane nimbana minditaka tupa pitaka pasindia wanda tupanga koyo piyu, peke lala-kola, nimbato bulumako andopane andane-yale mindi atapia oko peyo yawa-maili ya okonde leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wuane lea-kola, ayiane okomane bala lamawuato, iwana, nimba namba towa ole dindi lo atu ataipa leaipia. Nambana minditaka eya tupa pitaka nimbana angu eya-ko. ");
INSERT INTO ipi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nimbana amene oko bala omala taka alu peane tekeko, andipa bala saka atolo-peke leya-kola, nanimato bala andeyama. Wuaneko, nanima epelewa, tomo no pitipe-pene leane lo Jisasato pii kokoli okone leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Wuane lalu, Jisasato pii kokoli mindi balana disaipolo tupa lamawuato, wamba akali pusapai mindimane amango mindina minditaka yane tupa yatawa ando ateane leaipia. Yatawa ando atea-kola, akali minditupa epoto, amango oko lamawuato, nimbana piape akali okomane nimbana minditaka yatawa ando atapia tupa mo ole pima epoko peya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wuane leai-kola, amango okomane balana pusapai oko epeakale loto, nimbato nambana minditaka tupa mo ole pima epoko pua atele leyai-kola, nambato ale eyo okonde leaipia. Nimbato wuane pipini okonena, nimbato nambana minditaka tupa yatawa ando ata gii napula-ko. Andipa nimba poto, nambana minditaka nimbato yatawa ando atapi tupa dii loto, oko tuma eya lo, pepa mindina peyo yatape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wuane lea-kola, minditaka ando atalane akali pusapai okomane wua lo nembo teaipia: Nambato balana minditaka tupa yatawa ando ata napula loto, nambana akali amango okomane namba peyo wateya. Nambato sapolo awuato, piape mindi katulo napulu-peyo yako. Andipa nambato anu pukale yape. Nambato mindi akalinga tomopi, munipi, minditaka mee giyapa lo tee lewando, yala pulupeya yako. ");
INSERT INTO ipi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Matili amango okomane namba languato, piape kondalu puu lola-angi, wandakali minditupa-mane namba yakamana andaka ipu leakalenga, andipa nambato utupane moyo, mangene mindi pukale nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wuane nembo toto, balato amango okona yano atene akali tupa pitaka mindiki-mindiki lo epeakale leaipia. Akali mindi ini epea-kola, balato akali okone tipa puato, nambana amango okona yano aki-tupi nimbanga eyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wuane lea-kola, akali okonemane loto, wele piti-pata jatamu pene (100) wane andete yano nambanga eya leaipia. Wuane lea-kola, minditaka yatawa ando atalane akali okomane yano meane akali oko lamawuato, andipa nimbana yano pepa oko wamba ini moto, toko mindina pituto, wele piti-pata jatamu (50) paiyasa yau angu nambanga yano eya lo yano pepa okona peyo yata aa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yano atene akali lapone oko epea-kola, minditaka ando atalane akali pusapai okomane bala tipa puato, nambana amango okona nimbanga yano aki-tupi eyape leaipia. Wuane lea-kola, akali okonemane tomo witi beke (100) wane andete nambanga yano eya leaipia. Wuane lea-kola, minditaka yatawa ando atalane akali okomane yano meane akali oko lamawuato, andipa nimbana yano pepa oko moto, tomo witi beke (80) paiyasa kitupasa angu nambanga yano eya lo yano pepa okona peyo yata aa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wuane pua teke, aitene wandakali tupamane wai-ene gulo atoto, Gotena mana epene tii-pene wato minalaini wandakali tupa sia minuto, aitene wandakali yangone tupa langa-langa pimai-yaini. Minditaka ando atalane akali pusapai okomane wai ene gulo, wuane peane oko andoto, amango okomane akali okonena gene oko laiyu loto, nimbato mangene mindi pele okonena, nimba akali wai-ene wetete atele oko andeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","13","Wandakali mindimane minditaka aŋako yola tupa kuai lo ando yatawa ateando, balato minditaka andane yola tupa kuai lo ando yatawa atolopeya teke. Wandakali mindimane minditaka aŋako yola tupa kuai lo ando yatawa ata napeando, balato minditaka andane yola tupa kuai lo ando yatawa ata napulu-peya teke. Yakamato wandakali waka mindina minditaka mindi kuai lo ando yatawa ata napeaindo, apito yakama tanena minditaka yolai tupa ando yatawa atalapa lo yakama gulupeyape. Yakamato yuu okona tawe muni koo tupa kuai lo ando yatawa ata napeaindo, apito minditaka angini oko yakamato ando yatawa atalapale lo gulupeyape. Wandakali mindimane akali andane lapona piape peando, balato akali andane mindi epelewa yamapane yalu, akali andane mindoko towa embo wato, masia malu-peyako. Akali mindimane akali andane lapona piape akali katulo ata napipe-pene. Yakamato mini lapo palu atoto, Gote muni-la, okonelapo lapotaka yamapane yoto, piape peaindo, mana okone katu nalolo-peya. Matili yakama omolai-angi, muni ando yatawa atalaini piape okone koyo pulupeya. Okone angi, ati kenga atalane Gote okomane nimba balana yuu epene okona ipu leakale nembo teaindo, andipa yakamato wandakali yangone tupa epele yakale loto, yuu okona tawe muni tupa tale pua mawua atalapape lo nambato yakama langeyo. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jisasato wuane lea-kola, Patasai tupamane ale yainipia. Muni angu wayumane epelewa yamapa yoto, utupane-mane Jisasa ando lamba leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lamba leai-kola, balato utupane lamawuato, wandakali tupamane yakama akali epene ateyai nembo teakale loto, yakamato mana minditupa wato minalaini leaipia. Wandakali tupamane yakamana mana utupane epene wete nembo talaini tekeko, Goteto andeya-kola, yakamana ini anda-pangosa mana koo wete tupa tumbi latane ateya lo andalane. ");
INSERT INTO ipi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wamba potopesa akali tupa pitakapi, Mosesapi, utupane-mane pii minditupa pepa peleai-kola, akali minditupa-mane pii utupane wandakali tupa lamawua atama ipulu, ipa peya-maiyane akali Jone oko bala epeane gii okona giau leainipia. Jone epoto, Goteto pitaka taka ando atalane lo pii lamawua ateane okone angi tewa atoto, wandakali pitaka-mane balana pii okone ale wato, Goteto utupane ando ateakale lo taimane atete pima ipulu, oto andipa ateyama okona giau leyai. ");
INSERT INTO ipi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yuu ati-la lapotaka katulo koyo pulupeya tekeko, Gotena loo utupanena mindikipi mindi koyo napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wuane lalu, Jisasato pii mindi tako pua loto, akali mindimane balana wetene wambane oko peyo watoto, wanda waka mindi kee leando, balato wanda lapone kee lolane oko towa pamuku pula-kola pulupeya. Wanda peyo watene mindi pitula-kola, akali waka mindimane bala kee leando, balato wanda okone towa pamuku pula-kola pulupeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wuane lalu, Jisasato pii mindi tako pua loto, wamba akali amango mindi ateane leaipia. Akali okone bala ole dindi lo tona epene muni andane-mane kambene tupa pua atoto, tomo epene tupa naka pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Tomo popolo-pene minditupa balana toko pangosa tepa aka pea-kola, akali tipia Lasatosa lene mindimane utupane nokale nembo toto, akali amango okona anda asia lomba okona mandaka pitiki peaipia. Pitiki pea-kola, peango tupamane balana tete tupa tande piki peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Matili akali tipia okone omea-kola, enjole tupamane bala auwa ati kenga poto, Apatakame towa atu ateakale leainipia. Amango oko balapi omea-kola, wandakali tupamane bala mali peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mali peai-kola, bala yuu koo wetete okona poto, tandaka andane wetete no atoto, andaiyu lea-kola, Lasatosa bala Apatakame towa atu ati kenga ateapinga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Andoto, amango okomane pii taimane loto, ayiane Apatakame, namba ita too atene yuu koo okona atoto, tandaka andane neyo-ko. Nimbato namba ondo wato, Lasatosa balana kii ondenenga ipa tanda puato, nambana ekene angu mo tambo lolo epeakale lamai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akali amango okonemane wuane leane tekeko, Apatakameto amango okona pii leane okone yano peyoto, iwana, wamba nimba yuu okona atee-angi, nimbato minditaka epene tupa pitaka yatawa atee leaipia. Nimbato utupane pitaka yatawa atee tekeko, Lasatosa bala koo tipia wetete atea oko nembo tolo-peke laa. Andipa Lasatosa bala ati kenga yuu okona ateya-kola, Goteto balana mini epene pale laya eya tekeko, nimba tandaka andane wetete no atele-ko. ");
INSERT INTO ipi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wandakali minditupa onga atoto, yakama moyolo epolaini nembo toto, Goteto kana andane mindi nanima-la, yakama-la, tombenenga yakale leane oko eya-kola, nanimato katulo yakama moyolo naepolo-peyama. Dee, yakama katulo nanima ateyama okona naepolo-peyai teke. Apatakameto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Wuane lea-kola, amango okomane bala lamawuato, ayiane Apatakame, pii nimbato lele okone enene yando, nambana amene yau atapia tupa matili yuu koo namba tandaka no ateyo okona na-epeakalenga, Lasatosa bala wisanisa mindi atoto, nimbana pii oko namba amene utupane lamai-yakalenga, nimbato bala namba ayiane andaka peakale lolape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Wuane lea-kola, Apatakameto amango oko lamawuato, wamba potopesa akali tupapi, Mosesapi, utupane-mane Gotena pii leainipia. Nimbana amene tupamane akali utupanena pii ale wato, mini peke lape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Apatakameto wuane leane tekeko, amango okonemane bala lamawuato, jia, nambana amene tupamane akali utupanena pii leaini tupa ale wato mini peke nalene, mee ateaini ateyai. Wuane tekeko, akali omene mindi malinga ika lalu, utupane atolainga poto, pii lamai-yando, utupane-mane balana pii oko ale wato, mini peke lolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wuane lea-kola, Apatakameto bala lamawuato, Mosesapi, potopesa akali tupapi, utupane-mane pii leai-kola, nimbana amene tupamane akali utupanena pii ale wato teke, bilipi naleai-ko. Akali omene mindi malinga ika loto, Gotena pii oko akali utupane lamaindo, utupane-mane balana pii oko bilipi nalolo-peyai teke. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wuane lalu, Jisasato balana disaipolo tupa lamawuato, wandakali yangone tupamane mana koo tupa peakale lo mo piya alaini wandakali utupane-mane yole koo wete mindi molopeyai-ko. Utupane ondo wetete ape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tene okonena, andopane oo ateyai utupana mindimane koo mindi peakale loto, wandakali mindimane bala mo piya oyale peando, wandakali minditupa-mane ana andane mindi wandakali okonena manenga andi loto, ipa solewata angini tombenga wete okona awua aindaka lape-pene. Wuane peaindo, wandakali okone bala omoto, andopane okone mo piya naola-kola, Goteto yole koo wetete yuku-pene mindi wandakali okone mai napulu-peyako. ");
INSERT INTO ipi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wandakali waka mindimane koo peakale lo yakamato bala mo piya olaini, tika ando atalapape. Wandakali yangone mindimane koo mindi peando, nimbato bala laiya loto, wuane napene, kondaa lape. Laiya lole-kola, balato mini peke leando, nimbato balana koo tupa apia-maipe. ");
INSERT INTO ipi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oto mindikina, ole yanasanga balato mana koo nimbanga minalu, ole yanasanga teke balato mini peke leando, nimbato ole yanasanga teke balana koo pulane tupa apia-maipe. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Akali Andane okomane wuane lea-kola, aposolo akali tupamane bala lamawuato, nimbato nanimana bilipi oko mo tai laya ape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wuane leai-kola, Akali Andane okomane utupane lamawuato, yakamana bilipi oko aŋako mee komba dini okonepene angu yando, okone katu teke. Yakamato Gote aŋako mee teke bilipi lolai-kola teke, ita oo ateya oko lamawuato, nimba pini towa lopalu poto, solewata tombenenga yandatane ata lapiai-yale, ita okonemane lopalu poto, solewata tombenenga katulo yandatane atapia-yale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wuane lalu, Jisasato pii mindi tako pua loto, akali mindina piape akali mindimane ee piape peandopi, sipisipi yatawa ateandopi, piape okonetaka pua atalu, matili bala andaka epola-angi, piape anduane okomane bala lamawuato, nimba epo pituto, tomo yangalo oko wamba ini naa lolo-peyape. Jia. ");
INSERT INTO ipi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Piape anduane okonemane wuane nalolo-peya. Balato piape akali oko lamawuato, nimba tomo ipapi, matili nolanga, namba ini nokale. Nimbato lapalapa epene mindi mo piyu, tomo ipapi, namba nolane tupa ini mandeke puato, gii lolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Piape anduane okomane lola pua, piape akali okomane pula-kola, piape anduane okomane bala ando wayu pele lolo-peyape. Jia. Balato wayu pele nalolo-peya. ");
INSERT INTO ipi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wuane pua teke, Goteto yakama langula pua, yakamato balana piape tupa pitaka pulai-kola, Goteto yakama wayu peyai leakale nembo na-talapape. Jia. Yakamato piape pipe-pene yapia tupa angu nanimato pima oko lalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisasa bala Galili disitiki okona atoto, Jutusaleme poyale, Samatiya disitiki okona asini peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Poto, bala tano aŋako mindina kolandaka lea-kola, akali tapa paiyasa-mane bala asini epeanga andoto, amonga-yale ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Amonga atoto, utupane-mane pii taimane loto, Ando Atalene Akali Jisasa, nimbato nanima ondo ape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ondo ape leai-kola, Jisasato akali tapa utupane lamawuato, pitisa akali tupamane yakamana umbaini tupa andeakale pulupa leaipia. Wuane lea-kola, akali tapa paiyasa utupane pitisa akali tupa ateainga poyale, asini peai-kola, yakama pitakana umbaini tapa peane tupa atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Atu ya-kola, akali mindiki-mane balana umbaini oko kuai lea oko andoto, bala angu Gotena gene taimane wetete laiyu lama, Jisasa ateanga peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akali peke leane oko bala Samatiya yame mindi pia. Peke lalu, bala Jisasa ateanga tombawua loto, Jisasa nimbato wayu pili leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Wuane lea-kola, Jisasato wandakali waka ateaini tupa lamawuato, nambato akali paiyasa tupa pitaka mo atu yalo tekeko, Samatiya yame akali oko bala angu Gotena gene oko laiyu lokale nembo toto, peke lala yako. Juta yame pilisa akali nambato mo atu yalo tupa anu piyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wuane lalu, Jisasato Samatiya yame akali okone lamawuato, nimbato Gote lo bilipi lele nembo toto, Goteto nimba mo atu eya-ko. Nimba ika lalu, puu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Alumindi Patasai tupamane Jisasa tipa puato, andoko angi Goteto wandakali tupa ando atolo epolo-peyape leainipia. Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, Gote bala yakamana ini anda-pangosa epo atoto, yakama ando ateya-kola, wandakali-mane katulo bala lee-mane anda na-piyainiko. Mindimane Akalina Iwanane bala onga ateya oko andolo ipulupa nalape-pene. Dee bala ambinga ateya oko andolo ipulupa nalape-pene teke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wuane lalu, Jisasa balana disaipolo tupa lamawuato, matili yakamato Akalina Iwanane oko andamakalenga, bali ini ipupia lakae lo nembo tolopeyai tekeko, bala ini naepolo-peya leaipia. Ini naepola-kola, yakamato bala wamba ini anda napulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","24","Yakamato bala ini andamakale nembo tolai-kola, wandakali minditupa-mane yakama languato, Akalina Iwanane oko onga ateya oko andolo maa lolopeyai. Wandakali waka minditupa-mane bala ambinga ateya oko andolo maa lolopeyai tekeko, utupane-mane enene leyai lo yakamato nembo na-talapape. Jia. Ati tapale oko nai epalanesa ato tewa, tii pima pulu, nai andaka palane ukusane pitaka tii piyoko peya-kola, wandakali pitaka-mane katulo ati tapale okone andalaini. Wuane pua teke, matili Akalina Iwanane oko panakame epola-kola, wandakali pitaka-mane katulo bala epola oko panakame andolopeyai. Tene okonena, wandakali-mane bala onga ateya oko andolo maa leaindopi, bala amokusa ateya oko andolo maa leaindopi, yakamato utupane watama polaini. Jia. ");
INSERT INTO ipi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wandakali andipa ateyai tupamane wamba ini bala masia maulai-kola, bala tandaka andane nolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Wamba akali Nowa ateane-angi, wandakali tupamane Gote masia mawuato, akali-mane wanda kee laka, wanda-mane akali puku, wandakali-mane tomo ipapi naka pua atama pulu, Nowa bala sipi andane wete okona kolandaka leane oto okona giau leainipia. Balato sipi okonena kolandaka lea-angi, Goteto ipa andane wetete mindi yuunga atinga lapotakanga ika laya wato, wandakali utupane pitaka peyo peakale peaipia. Wamba Nowa ateane-angi, Goteto mangene andane okone peane pua teke, matili Akalina Iwanane oko epola-angi, Goteto mangene andane mindi pulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wuane pua teke, wamba akali Lote ateane-angi, wandakali-mane Gote masia mawua atoto, ee piki, anda piki, tomo ipapi naka, bisanisa piape piki pua ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Utupane-mane wuane piki pua ateaini tekeko, Lote bala Sotomo tano oko tepa alu, peane okone angi, ati kenga ato kingi epalane pua, ita tapeta towa-towa ana ita-mane too nembeyawe-pene tupa epo tepa wato, Sotomo tano okonena ateaini wandakali tupa pitaka peyo ome leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wuane pua teke, matili wandakali tupamane mangene ole dindi lo piki piyaini tupa pua atolai-kola, Akalina Iwanane oko panakame epola-angi, Goteto kenda-pene andane wetete mindi bala lo bilipi nalene wandakali utupanenga yata olopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","32","Yakamato Lotena wetene oko nembo tolo-peke lalapape. Balato Gotena pii tanga loto, Sotomo tano okona minditaka yane tupa molo-peke lauwa lakae lo nembo toto, anda-peke leane okonena, bala omeaipia. Tene okonena, Akalina Iwanane oko lapone epola-angi, wandakali mindi balana anda okona takita ateando, kenda-pene Lotena wetene okonenga epeane oko nembo tolo-peke lape-pene. Okone nembo tolo-peke loto, balana minditaka andaka yolane tupa mokale nembo toto, anda-pangosa kolandaka nalene, mee palaka pupe-pene gulolo-peya. Dee, wandakali mindi bala eenga ateando, balana minditaka yolane tupa molo-peke nalene, mee palaka pupe-pene teke. ");
INSERT INTO ipi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wandakali mindi bala nambana yame ateando, namba towa yanda piyaini akali tupamane katulo bala peyo ome lolopeya. Wandakali mindi bala omolowane nembo toto, nambana yame ata napeando, bala epene saka atapowa ata napulu-peya. Wandakali mindi bala nambana yame atola mambele, wandakali mindimane bala peyo ome leando, wandakali okone bala epene saka atapowa atolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Akalina Iwanane oko utulu epeando, akali lapo toko mindikina pangulapi-kola, balato balana yame akali oko lamialu, mindoko paleakale tepa alu polopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Wanda lapo palawa waa puyale witi dini tupa taki lo pitulapi-kola, balato balana yame wanda oko lamialu, mindoko peteakale tepa alu polopeya. Lapo akali ee piape pua atolapi-kola, balato balana yame akali oko lamialu, mindoko ateakale polopeya. ");
INSERT INTO ipi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisasato wuane lea-kola, balana disaipolo tupamane bala tipa puato, Akali Andane, aninga ato wuane pulu-peyape leainipia. Wuane leai-kola, Jisasato pii kokoli mindi loto, minditaka omene yuu yolanga, eka ayiawe tupa amunguli pulai-kola, yakamato andolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Balana disaipolo tupamane kepa naene, ole dindi lo pote leakale nembo toto, Jisasato pii kokoli mindi utupane lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pii kokoli okone utupane lamawuato, balato jasa mindi tano mindina ateane leaipia. Jasa okonemane wandakali yangone tupa moyokale lopi, Gote yuku amawuapi, napiyane akali mindi ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ole kambuanga tano okonena wanda yalo mindi akali jasa okone ateanga puku puato, bala lamawuato, wandakali mindimane kenda-pene mindi namba geya-ko. Nimbato namba moyo, kenda-pene okone lo tika pingula laka peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wuane laka pea-kola, akali jasa okonemane wanda okonena kenda-pene oko wamba ini lo tika napene, konda yane tekeko, matili jasa okomane wua lo nembo teaipia: Nambato Gote yuku amawuapi, wandakali moyokale lopi, nembo natalawane. ");
INSERT INTO ipi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wuane tekeko, ole kambuanga wanda yalo okomane namba ateyonga epoto, kenda-pene namba giki piyane-ko. Balato namba mo kepa piya wetete olane. Nambato balana kenda-pene okone lo tika pimauwakale nembo teaipia. Jasa okonemane wuane leane lo, Jisasato pii kokoli okone leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Akali Andane okomane pii kokoli okone lo koyo piyu, balato pii mindi konda puato, ole kambuanga wanda yalo okonemane namba moyape laka pea-kola, akali jasa koo okonemane wanda yalo okona kenda-pene oko lo tika pukale leane okone yakamato nembo talapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ole dindi lo wanda yalo okonemane namba moyape laka peteane pua teke, Gotena yapa lo mene wandakali tupamane utulu otongapi, Gote tipa puato, pote laka pulai-kola, balato utupane moya napene, ole kambua mee maliyo atolo-peyape. Jia. ");
INSERT INTO ipi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Balato wandakali utupane wamba ini moyolo-peya tekeko, matili Akalina Iwanane oko epoto andola-kola, yuu okona wandakali mindimane bala bilipi lo atolo-peyape. Pee, utupane-mane bala bilipi lo ata napulu-peyape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wandakali minditupa-mane yakama tane epene tika-pene ateyama nembo toto, wandakali waka tupa pitaka koo ya lo anda napi leai-kola, Jisasato pii kokoli mindi utupane lamayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Pii kokoli okone loto, lapo akali lotu anda andane okona pote lolo peapele leaipia. Akali okone-lapona mindimane takisa muni mialaepia. Akali mindoko bala Patasai mindi ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Patasai okonemane lotu anda okona atoto, nembo-mane pote loto, takisa muni mialane akali okomane mana koo minalane leaipia. Wandakali minditupa-mane minditaka pake nalaini. Minditupa-mane minditaka eya tupana kambua miauwa lakae lo nembo talaini. Minditupa-mane Gotena loo waka tupa ango alaini. Wandakali utupane pitaka-mane mana koo minalaini pua nambato mina na-piyawane okonena, nambato Gote nimba ando wayu pele leyo. ");
INSERT INTO ipi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Satete dindi lo ole kambuanga nambato nimba nembo toto, tomo nanene kondalu, pote angu lo atalawane. Nambato muni yandopi, waka minditaka yandopi, paiyasa mewando, utupane tale puato, pilisa namba tane mialu, paiyane oko nimba giyawane lo pote leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Patasai okonemane wuane lo pote leane tekeko, takisa muni mialane akali okone bala aŋa amonga-yale atoto, mini kenda wato, andaiyu nalene, pote loto, nambato mana koo minalawane-ko. Gote nimbato namba ondo ape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisasato pii kokoli okone lo koyo piyu, pii mindi tako pua loto, wandakali mindimane bala tanena gene oko laiyu leando, Goteto wandakali okone napinga yale ateakale laya alane leaipia. Patasai okomane mana koo mindi mina na-piyawane lo pote lea-kola, Gotena wenonga, Patasai okone bala akali tika-pene mindi ata napea. Wandakali mindi bala napinga yale ateando, Goteto akali okone bala lipinga yale ateakale lalane. Takisa mialane akali okomane mana koo minalawane lo pote lea-kola, Gotena wenonga akali okone bala akali tika-pene mindi atoto, andaka pea. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Alumindi Jisasato andopane tupanga kii yata yakale nembo toto, wandakali-mane andopane kambolo tupa awua epeai-kola, balana disaipolo tupamane andoto, wandakali utupane laiya loto, andopane kambolo tupa atu aiyu naepene, kondalapa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Wuane leai-kola, Jisasato andopane tupa epeakale loto, balana disaipolo tupa lamawuato, Goteto andopane oo ateyai okopene gulene wandakali tupa moyo ando atalane-ko leaipia. Yakamato andopane utupa minandi nalene, namba ateyonga epeakale lo ando kondalapa. Goteto utupane moyo ando ateakale nembo toto, andopane tupamane bala wuane peakale lo ando konda alaini. Nambato pii enene mindi yakama langeyo. Goteto utupane ando ateakale lo andopane tupamane ando kondalaini pua teke, wandakali mindimane bala wuane peakale lo ando konda nayando, bala katulo Gotena yuu epene okona napolo-peya. Jia wete. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Alumindi ando atalane akali amango mindimane Jisasa tipa puato, tisa epene, namba saka atapowa atokalenga, nambato anu puape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wuane lea-kola, Jisasato bala lamawuato, wandakali mindikipi mindi epene ata napeya leaipia. Gote bala angu epene ateya-ko. Anu peakale nimbato namba tisa epene lelepe. ");
INSERT INTO ipi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nimba tane Gotena loo tupa andele okoni. Wanda akali-la liyambato pake namialapape. Nimbato wandakali yangone mindi peyo ome nalape. Nimbato pake mia napipe. Nimbato wandakali yangone mindi kosimi loto, owato pii nalape. Nimbana angini, ayiane-la okone-lapona pangosa atoto, nimbato okone-lapona pii lolapi tupa wato minu atape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wuane lea-kola, ando atalane akali okomane bala lamawuato, wamba namba iwana aŋakonga atoto, loo utupane pitaka wato minu atama ipulu, andipa ateyama okona giau leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pii leane okone ale wato, Jisasato bala lamawuato, mana epene mindiki angu nimbato wato mina napilini leaipia. Wandakali waka tupamane nimbana minditaka eya tupa pitaka kambeakale lape. Kambolai-kola, nimbato muni mole tupa wandakali tipia tupa maipe. Wuane peendo, matili nimbana minditaka epene wetete tupa ati kenga yola-ko. Andipa nimba namba watama ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wuane lea-kola, ando atalane akali amango okomane balana pii okone ale alu, balana minditaka kambua wete yane tupa pitaka awua tepa na-wakale nembo toto, bala mini kenda wetete yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Akali okone bala mini kenda wetete eya lo andoto, Jisasato pii mindi loto, Goteto utupane moyo ando ateakale lo minditaka kambua wetete yene wandakali tupamane ando kondape-pene oko pitete wetete alaini. ");
INSERT INTO ipi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yia kamele mindi yana asia titi aŋako mindina kolandaka loyale makande pipia-yale, pitete apia-yale tekeko, Goteto utupane moyo ando ateakale lo ando kondape-pene oko minditaka kambua yene wandakali tupamane pitete wetete alaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wuane lea-kola, wandakali balana pii ale yaini tupamane bala tipa puato, wuane yando, api katulo saka atapowa atolo-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, mangene wandakali-mane katulo napipe-pene tupa Goteto katulo piyane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wuane lea-kola, Pitato bala lamawuato, nanimato nanimana minditaka yemane tupa pitaka awua tepa alu, nimba watama epeyama oko nimbato andee-ko. Matili nanimato aki mindi molo-peyamape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, nambato pii enene mindi yakama langeyo leaipia. Goteto wandakali tupa moyo ando ateakale nembo toto, wandakali mindimane balana anda yandopi, wetene andopane yandopi, amene imalini yandopi, angini ayiane yandopi, utupanena mindi tepa alu, Gotena piape pua ateando, bala yuu okona atola-kola, Goteto okonetaka kambua longo bala maulupeya. Dee, matili wandakali okone omola-angi, Goteto bala saka atapowa ateakale lo ataya olopeya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","33","Jisasa balana disaipolo alesa akali tupa towa atu amonga-yale poto, andipa nanima Jutusaleme poyale asini peyama leaipia. Poloma-kola, akali mindimane Akalina Iwanane oko ene pitula-kola, wandakali waka tupamane bala lamba loto, mana koo minditupa balanga minulu-peyai. Utupane-mane apesango balanga soo lo peyoto, kunju-mane peyalu, peyo ome lolopeyai. Wuane pulai-kola, ole teponena bala malinga ika lolopeya. Wuane pula okomane pii wamba potopesa akali tupamane bala andayo pepa peleaini tupa pitaka enene gulolo-peya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jisasato wuane leane tekeko, balana disaipolo tupamane balana pii okone ale wato, balato aki nembo toto, wuane leyape nembo natene, tatake yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Matili Jisasa bala yuu Jetiko okona mandaka gulo pea-kola, akali lee koo mindi asia ayatenenga pituto, wandakali epo peaini tupa tee loto, muni giyapa laka pua peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Balato wandakali kambua wetete epo peainga ale wato, wandakali tupa tipa puato, anu peakale wandakali kambua epo peyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wuane lea-kola, wandakali mindimane bala lamawuato, Nasatesa tane Jisasa bala epo peya-kola, wandakali kambua bala towa atu epo peyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wuane lea-kola, akali lee koo okomane taimane ee loto, Dapiti yame Jisasa, nimbato namba ondo ape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wuane lea-kola, wandakali wamba ingane epeaini tupamane bala laiya loto, nimba pii nalene kondaa leaini tekeko, balato utupanena pii tanga loto, Dapiti yame Jisasa, nimbato namba ondo ape lo taimane wete laka peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Wuane laka pea-kola, Jisasato ongane atoto, wandakali tupa lamawuato, yakamato akali lee koo okone lamo atu namba ateyonga ipulupa leaipia. Wuane lea-kola, utupane-mane akali okone lamo atu mandaka epeai-kola, Jisasato bala tipa puato, nambato nimba moyo anu pipi lakae lo nembo telepe leaipia. Wuane lea-kola, akali lee koo okomane bala lamawuato, Akali Andane, nimbato nambana lee mo tee laya api lakae lo nembo teyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wuane lea-kola, Jisasato bala lamawuato, nimbato namba lo bilipi lele oko andoto, nambato nimbana lee oko tee laya eyo-ko. Nimba lee taa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wuane lea-kola, okone angi teke akali okone bala lee toto, minditaka yane tupa pitaka andeaipia. Andoto, balato Gote lo tama puato, Jisasa watama peaipia. Jisasato akali okonena lene mo tee laya ya-kola, wandakali tupamane andoto, Gotena gene oko laiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Jetiko tano okona takisa muni mialane akali Sakiasa lene mindi bala takisa muni mialaini akali waka tupana kawane atoto, akali amango mindi ateaipia. Bala tano okonena atea-kola, Jisasa bala peakaiyu lalu, yuu waka mindina poyale asini epeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Asini epea-kola, Sakiasato Jisasa bala akali anu-pene mindi ateyape lo andokale nembo teane tekeko, wandakali kambua-mane Jisasa ato kulia puato, bala towa atu asini epeai-kola, Sakiasa bala akali topaki okomane Jisasa andape nayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Andape naya-kola, Sakiasato Jisasa poyale asini peane okona ingane taimane poto, bala andoyale ita piki yame sikamo lene mindi ateane okona keyoto, peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Petea-kola, Jisasa epoto, Sakiasa ita okonena peteanga andaiyu loto, andipa namba nimbana andaka poto, atapakale-ko. Nimba wamba ini kili loto, yuunga ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wuane lea-kola, Sakiasa epele wato, wamba ini kili lalu, Jisasa nimba wayu epeleya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jisasa bala Sakiasana andaka pea-kola, wandakali minditupa-mane mini koo palu mulu-mulu loto, Jisasa bala koo piyane akali mindina andaka pangulu pala leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Utupane-mane wuane leaini tekeko, Sakiasato Akali Andane Jisasa oko lamawuato, wamba nambato owato pii loto, wandakali mindinga takisa muni minditupa konda pua mialawae yando, andipa nambato paini ole tukumindinga yano peyo mauwakale leaipia. Wuane piyu, nambana minditaka eya tupa pitaka atutu lo tale puato, minditupa wandakali tipia tupa mauwakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Wuane lea-kola, Jisasato bala lamawuato, Akalina Iwanane okomane wandakali alu-pene tupa ayia pua molo-peke loyale epeane-ko. Andipa nimba mini peke lele-kola, Goteto nimba Apatakame yame enene ataya wato, nimbana anda okona paliyaini yame tupa molo-peke leya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisasa bala Jutusaleme mandaka yale epea-kola, wandakali tupamane nembo toto, bala Jutusaleme peakaiyu lola-angi, nanimato andoloma-kola, Goteto pitaka taka panakame ando atolanga andolo-peyama nembo teainipia. Utupane-mane wuane nembo toto, balana pii leane tupa alewa peteai-kola, Jisasato pii kokoli mindi konda pua leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","Pii kokoli okone loto, wamba akali gene yene mindimane balana piape akali paiyasa tupa ipulupa leane leaipia. Ipulupa loto, balato kina (20) paiyasa lapo, paiyasa lapo lo tale puato, piape akali utupane maiki piyu, andipa namba yuu tepanda mindina peyo leaipia. Namba yuu okonena atolowa-angi, yakamato muni nambato yakama geyo tupa awua atoto, bisanisa piape pua atalapape. Matili namba yakamana kiŋi gulo atama peke lokale leaipia. Wuane lalu, akali gene yene okone bala yuu tepanda okonena peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pea-kola, balana yame tupamane bala towa embo wetete wato, akali okone bala kiŋi gulalu, nanima ando ata napeakale nembo teainipia. Wuane nembo toto, akali minditupa-mane kiŋi ate lalane akali oko lamai-yakale loto, utupane-mane akali utupane akali gene yene oko peane okonena peakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wuane leai-kola, akali utupane-mane akali gene yene oko watama poto, yuu tepanda okonena peainipia. Poto, utupane-mane kiŋi ate lalane akali oko lamawuato, akali andane gene yene oko bala nanimana kiŋi ata napeakale leaini tekeko, kiŋi ate lalane akali okomane utupanena pii tanga loto, akali gene yene okone bala utupanena kiŋi ate leaipia. Ate lea-kola, akali gene yene oko bala kiŋi gulalu, balana yuu okona epo peke leaipia. Peke loto, balana piape akali mindiki-mindiki lo muni tale pua mayane utupane-mane bisanisa piape puato, potopisa muni aki-tupi meaini yape andoyale, balana piape akali utupane epeakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Epeai-kola, akali bulupane epeane okomane loto, Akali Andane, nimbato kina (20) paiyasa lapo namba gee-kola, nambato bisanisa piape puato, (200) tu andete kina potopisa miauwa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wuane lea-kola, kiŋi okonemane bala lamawuato, nimbato minditaka aŋako wetete tupa wayumane ando atoto, piape kuai lo pipini yako. Nimba piape akali epene atele-ko. Nimbato tano paiyasa ando atola leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Piape akali lapone epeane okomane loto, Akali Andane, nimbato kina (20) paiyasa lapo namba gee-kola, nambato bisanisa piape puato, (100) wane andete kina potopisa miauwa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wuane lea-kola, kiŋi okomane nimbato tano yau ando atola leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Piape akali tepone epeane okomane loto, Akali Andane, akali waka mindimane minditaka yatawa ateya oko nimbato tikayu mialene leaipia. Akali waka mindimane tomo yandeya okone nimbato tikayu mandilini. Nimba akali makonga ene mindi pianga, nambato nimba ando yuku wato, nimbana kina (20) paiyasa lapo namba gee oko angasupi-mane tongo puato, yatawa atewane oo eya oko anda leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Wuane lea-kola, kiŋi okomane bala tipa puato, akali waka mindimane minditaka yatawa ateya tupa nambato tikayu meyo-kola, nimbato andalenepe leaipia. Akali waka mindimane tomo yandeya tupa nambato tikayu mandiki peyonga nimbato andalenepe. Namba akali makonga ene mindi atoto, wuane piyawae yando, anu peakale nimbato nambana kina (20) paiyasa lapo potopisa mandeakale beŋe mindina yata-gii napene, mee yakale konda eepe. Nimbato muni okone beŋenga yata ee-yale, namba peke leyo-angi, potopisa muni minditupa miauwa-yaleko. Nimbato namba ando pii koo lale utupane ale wato, nambato nimba yapa lo tale puato, nimba piape akali koo wetete atele leyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wuane lalu, kiŋi okomane akali ongane mandaka ateaini akali waka tupa lamawuato, yakamato kina (20) paiyasa lapo nambato akali oko maewa okone lopo moto, (200) tu andete kina yatawa ateya piape akali okone balanga konda pua maiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wuane lea-kola, utupane-mane kiŋi oko lamawuato, Akali Andane, nimbato muni maiyapa lele akali okone bala (200) tu andete kina yatawa ateya okonde leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wuane leai-kola, kiŋi okomane utupane lamawuato, wandakali mindimane minditaka balanga yola tupa kuai lo ando yatawa ateando, Goteto minditaka konda pua bala malupeya leaipia. Wuane tekeko, wandakali mindimane minditaka balanga yola tupa kuai lo ando ata napeando, minditaka aŋako balanga yola tupa Goteto lopo molopeya. ");
INSERT INTO ipi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wamba namba towa yanda-pene wandakali minditupa-mane namba towa embo wato, nambato utupanena kiŋi atoto, utupane ando ata napeakale nembo teainipia. Andipa yakamato wandakali utupane namba wenonga atu epoto, peyo ome lalapa. Kiŋi okonemane wuane leane loto, Jisasato pii kokoli okone leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisasato pii utupane lo koyo piyu, Jutusaleme poyale ingane pea-kola, balana disaipolo tupa bala atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","31","Poto, utupane yakamato Olipi wangiane okona peakaiyu leai-kola, Betepasi, Betani-la, tano okonelapo ongane mandaka yaepia. Mandaka ya-kola, Jisasato balana disaipolo lapo akali lamawuato, liyamba tano aŋako amo eya okona peakaiyu loto andolapi-kola, dongi talua wamba akali mindimane masianenga napetene mindi andi latane atolanga andolo-peyapi leaipia. Liyambato dongi okone tinga loto, atu ipulupape. Liyambato dongi okone tinga lolapi-angi, wandakali mindimane liyamba tipa puato, anu peakale liyambato dongi oko tinga leyapipe leaindo, liyambato bala lamawuato, Akali Andane okomane dongi mindina pitiyu, mangene mindi pukale nembo teya. Wuane nembo toto, balato mindi molo pulupa leanga nalipato oko meyapa lalapape leaipia. Jisasato wuane lalu, balana disaipolo okonelapo ingane pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wuane lea-kola, akali okonelapo-mane poto, balato leane tupa pitaka andeapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Andoto, akali okonelapo-mane dongi okone tinga leapi-kola, dongi anduane tupamane akali okonelapo tipa puato, anu peakale liyambato dongi talua oko tinga leyapipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wuane leai-kola, akali okonelapo-mane dongi anduane tupa lumauwato, Akali Andane okomane yia dongi mindina pitiyu, mangene mindi pukale nembo teya. Wuane nembo toto, balato mindi molo pulupa leanga nalipato oko meyapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wuane lalu, liyambato dongi okone atu Jisasa ateanga epoto, liyambana tona luu kenga peapili okolapo yokoto, dongi okonena masianenga yata yapelepia. Yata wato, pitulane panda mindi puato, Jisasa bala dongi okona masianenga peteakale lo bala moyapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bala dongi okonena masianenga pitiyu pea-kola, wandakali-mane yakamana tona luu kenga peapili tupa yokoto, bala poyale epeane asini okona panda pima peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wamba Jisasato metekolo piape kambua pea-kola, wandakali kambua-mane metekolo piape utupane andoto, bala lo bilipi lene yame oko ateainipia. Bala Olipi wangiane okona puu nena loto, Jutusaleme poyale mandaka yale pea wete, wandakali utupane pitaka-mane metekolo piape balato wamba peane tupa pitaka nembo tolo-peke loto, epele wato, Gotena gene oko laiyu leyama nayu laka pima peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Utupane-mane balana gene oko laiyu loto, Akali Andane Goteto kiŋi oko epeakale leya-kola, bala epeya leainipia. Goteto bala moyo ateakale. Gote ati kenga wetete ateya okomane yakama towa yamapane epene paleya-kola, yakamato balana gene oko laiyu lalapa lama peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wuane lama peai-kola, utupane towa atu epoko pua ateaini Patasai minditupa-mane Jisasa lamawuato, tisa, wandakali nimba watama epalaini tupamane pii leyai okone konda yakale lo nimbato utupane laiya laa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, wandakali utupa-mane pii laa napene konda yaindo, ana tupamane Gotena gene oko taimane laiyu lolopeyai lo nambato yakama langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wuane lalu, Jisasa bala Jutusaleme mandaka-yale poto, tano okone andoto, ai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","44","Ai loto, balato wua leaipia: Wamba Goteto Jutusaleme tane wandakali yakama moyolo epea-kola, Goteto nanima moyoyale epeya lo yakamato anda napeainipia. Tene okonena, alumindi yakama towa yanda-pene tupa epoto, yakamana tano okona yangisa, yangisa-la ato mapu puato, yakama yanda pingulu-peyai. Utupane-mane yakama yanda pingulai-angi, Jutusaleme tane wandakali yakamato utupane peyo ome lolaini loto, utupane-mane ende mindi pulai-kola, ende okonemane utupanena sia umbi gulo atolopeya. Utupane-mane yakamana tano okona endepi, andapi, ana-mane waa pitane ateya utupanena ana mindikipi mindi ana yangone tupana tokonga yakale lo ando konda naene, yakamana tano oko wetete minu koyolo-peyai. Wuane piyu, utupane-mane yakamana tano okona paleyai wandakalipi, andopanepi, yakama pitaka peyo ome lolopeyai. Andipa yakama Gote towa atu mini epene palu atolane mana oko nembo tapiai-yale, matili kenda-pene andane okone yakamanga katulo naipupia-yale. Wuane tekeko, andipa Gote towa atu mini epene palu atamakale loto, mana yakamato wato minape-pene tupa too pitane eya-kola, yakamato mana utupane nembo nateyai. Jisasato wuane loto, Jutusaleme tane wandakali tupa ondo wato, ai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Jisasa bala lotu anda andane okona ende anda-pangosa kolandaka loto andea-kola, wandakali minditupa-mane bisanisa piape pua ateainipia. Bisanisa pua ateai-kola, balato utupane lamawuato, Gotena pii pepa pelene eya mindimane loto, nambana lotu anda oko pote lo pitulane anda mindi atolopeya layene eya tekeko, yakamato nambana anda oko pake nene wandakali epo pitiyaini anda mindi gulaya yaini leaipia. Wuane lalu, Jisasato wandakali utupane takita pulupa lo peyo wateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wandakali utupane peyo watalu, ole dindi lo Jisasa bala lotu anda andane okonena epoto, wandakali tupa pii mana lamawua ateaipia. Pii mana lamawua atea-kola, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, wandakali tupana akali kawane waka tupapi, utupane pitaka-mane Jisasa peyo ome lolane asia mindi ayia peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Utupane-mane wuane peaini tekeko, wandakali pitaka-mane balana pii epelewa ale yai-kola, okone angi akali utupane-mane Jisasa peyo ome lolane asia mindi ando mia napeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ole alumindi Jisasa bala lotu anda andane okona ende anda-pangosa atoto, Gotena pii layene epene oko lamawuato, wandakali peteaini tupa mana lamawua ateaipia. Balato wuane pua atea-kola, pitisa akali kawane tupapi, loo tupana mana andene akali tupapi, Juta yame tupana akali kawane waka tupapi, utupane yakama Jisasa ateanga epeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Epoto, utupane-mane bala tipa puato, nimbato apina pii wato minuto, wandakali utupa mana lamawua atelepe. Apito nimba languato, piape utupa pipe lo nimba langipia-kola, nimbato piape utupa pua atelepe. Nimbato nanima langi leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Wuane leai-kola, balato utupane lamawuato, nambatopi pii mindi yakama tipa peyo leaipia. Goteto Jone lamawuato, nimbato wandakali tupa ipa peya-maipe lea-kola, balato wuane peapepe. Pee, wandakali-mane bala lamawuato, nimbato wandakali tupa ipa peya-maipe leai-kola, balato wuane peape. Yakamato namba langiyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Wuane lea-kola, akali utupane yakama teke-teke pii lalawa puato, wandakali tupa pitaka-mane Jone bala potopesa akali enene mindi ateane nemboto atalaini leainipia. Wuaneko, nanimato Jisasana pii oko yano peyoto, wandakali-mane Jone lamawuato, nimbato wandakali tupa ipa peya-maipe leai-kola, balato wuane peane lemando, wandakali tupamane nanima ana-mane peyo ome lolopeyai. Wuane tekeko, nanimato balana pii okone yano peyoto, Goteto ipa peya-maipe lea-kola, Joneto wuane peane lemando, Jisasato nanima tipa puato, wuane yando, anu peakale yakamato Jonena pii bilipi naleaipe lolopeya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Utupane yakama teke-teke wuane lalu, Jisasa lamawuato, Joneto ipa peya-maiyane okone apito peya-maipe lea-kola, balato wuane peape lo nanimato nembo nateyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wuane leai-kola, Jisasato utupane lamawuato, yakamato nambana pii oko kuai lo yano peya napeleai-ko. Piape utupa pipe lo namba langeane akali okona gene oko nambato yakama langi napukale teke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wuane lalu, Jisasato pii kokoli mindi wandakali tupa lamawuato, akali mindimane getepe ee mindi yandeane leaipia. Yandoto, balato piape akali minditupa lamawuato, yakamato nambana ee oko ando ateaindo, matili dini lula-angi, yakamato minditupa yoo gulai-kola, yakama tane akenane tupa mialapale lalu, bala yuu tepanda mindina pea-kola, ana kambua peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ana kambua pea-kola, matili getepe dini mandulane oto oko epea-angi, ee ando atalaini akali tupamane getepe dini minditupa yo geakale nembo toto, ee anduane okomane balana piape akali mindi lamawuato, akali utupane-mane getepe dini minditupa yo geakale, nimbato molo puu leaipia. Wuane lea-kola, piape akali okonemane dini minditupa molo peane tekeko, ee ando atalaini akali tupamane getepe dini minditupa yoo mai napene, piape akali okone minu peyalu, mee peke leakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akali okone peke lea-kola, ee anduane okomane balana piape akali waka mindimane dini minditupa molo peakale leane tekeko, ee ando atalaini akali utupane-mane getepe dini minditupa yoo mai napene, bala minu peyalu, mana koo yala-pene minditupa balanga minalu, bala mee peke leakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Peke lea-kola, ee anduane okomane balana piape akali waka mindimane teke dini minditupa molo peakale lea-kola, ee ando atalaini akali tupamane bala minu koyo wete wato, ee okonena ende kamaka awua apeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Akali utupane-mane wuane peai-kola, ee anduane okomane tatake wato, nambato anu puape leaipia. Nambana iwanane yamapane yalawane okone peakale lolowa-kola, akali utupane-mane balana pii lola tupa ale olopeyai yalua leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wuane loto, balana iwanane okomane dindi minditupa molo peane tekeko, ee ando atalaini akali tupamane balana iwanane oko epeanga andoto, yakama teke-teke pii lalawa puato, matili iwana epeya okomane bala ayianena paluni tupa pitaka tane molopeya-ko. Ee okona paluni oko nanima tane mia-makalenga, nanimato bala peyo ome lamakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wuane lalu, akali utupane-mane bala ee okonena ende kamaka atu aiyu poto, peyo ome leainipia. Utupane-mane wuane peaini okonena, ee anduane okomane akali utupane towa anu pulupeya nembo teyaipe. ");
INSERT INTO ipi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bala tane epoto, akali utupane peyo ome lalu, akali waka minditupa-mane balana getepe ee okone ando ateakale lo malupeya. Jisasato wuane lea-kola, balana pii alewa peteaini wandakali tupamane loto, matili-matilipi kenda-pene okone nanimanga na-epeakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wuane leai-kola, Jisasato utupane andapeyo yoto, Gotena pii pepa pelene eya mindimane loto, anda piyaini akali minditupa-mane anda mindi puato, ita mindi andoto, oko koo ya lo apeaini mindiki okone teke Goteto moto, anda okonena pingina gulaya yane layene eya leaipia. Pii kokoli nambato lalo okone angini guu nalolo-peya yando, Gotena pii layene lalo okonena tene oko andoko paleyape. ");
INSERT INTO ipi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ita okonena tokonga wandakali ayia peyolai tupa pitakana kulini tupa kundu lolopeyai tekeko, anda pingina okone tepa wato, wandakali mindi peyo tele lola-kola, bala yuu kangalamu gulolo-peyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisasato wuane lea-kola, loo tupana mana andene akali tupapi, pitisa akali kawane tupapi, utupane-mane ale wato, balato nanima andayo pii kokoli oko leya nembo teainipia. Tene okonena, okone angi teke, utupane-mane Jisasa andi lamakale nembo teaini tekeko, wandakali kambua-mane bala potopesa akali mindi ateya nembo teai-kola, Juta yamena akali kawane utupane-mane bala andi loyale yuku wato, konda yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Matili Juta yamena akali kawane tupamane pii mindi loto, gapomane akali kawane okomane Jisasa andi loto, peyo ome leakale leainipia. Nanimato Jisasa langa-langa pimaluma-kola, balato gapomane oko andayo pii koo mindi lola-kola, bala tanena pii lolane okonemane teke nanimato bala kosimi lamakale leainipia. Bala kosimi lamakale nembo toto, utupane-mane akali minditupa lamawuato, Jisasato aki leyape lo pii moyale, yakama akali tika-pene gulo atoto, bala kambo andolo pulupa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wuane leai-kola, akali utupane-mane poto, tisa, wandakali mindi bala akali gene yene yandopi, gene naene yandopi, okone tene mindi ata napeya nembo toto, nimbato pii tika pua lalene leainipia. Nanimato wua pipiai lakae lo Goteto nembo talane tupa nimbato nanima mana kuai lo languato, pii enene tupa angu lalene nembo teyama. ");
INSERT INTO ipi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tene okonena, nanimato nimba tipa puato, Juta yame wandakali nanimato Lomo tane gapomane akali kawane Sisa oko takisa muni maipe-penepe, mai napipe-penepe leyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Wuane leai-kola, akali utupane-mane langa-langa puato, pii okone tipa peyai lo andoto, Jisasato utupane lamawuato, yakamato muni ondene mindi namba andawa lalapa leaipia. Andawa leai-kola, balato utupane tipa puato, apina lee-inga waa pitane okola, gene peyatane okola, okonelapo muni okona ateyape leaipia. Wuane lea-kola, utupane-mane bala lamawuato, Lomo tane gapomane akali kawane Sisana lee-inga waa pitane okola, gene peyatane okola, okonelapo muni okona ateya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wuane leai-kola, balato utupane lamawuato, wuane yando, yakamato Sisana minditaka yolai tupa Sisa bala maiyu, Gotena minditaka yolai tupa Gote bala maiyu piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wandakali tupana wenonga Jisasato utupanena pii okone kuai lo yano peyoto, gapomane oko andayo pii koo mindi naleaipia. Tene okonena, utupane-mane bala kosimi lolane tene mindi ata napea-kola, utupane-mane katulo bala langa-langa napulu-peyama lo moko loto, pii waka mindi laa napene konda yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","29","Satusi yame-mane wandakali omene tupa malinga ika nalolo-peyai lalainipia. Akali utupanena minditupa-mane Jisasa ateanga epoto, bala lamawuato, tisa, amene yanasa ateai-kola, amene bulupane okomane wanda mindi kee lalu, andopane mindi mandi napene omeaipia. Wamba Mosesato nanimana pepa mindi peyoto, akali mindimane wanda mindi kee lalu, andopane mandi napene omeando, balana amene mindimane wanda yalo oko kee loto, amene omolane okona andopane mindi mandi maiyakale. Wamba Mosesato pii okone pepa peleaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pii okone nembo toto, akali omeane okona amene mindimane wanda yalo oko kee leane tekeko, balatopi andopane mindi mandi napene omeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Omea-kola, amene tepone okomane wuane teke peaipia. Wuane teke pima pulu, iwana yanasa tupa pitaka-mane wanda mindiki okone teke kee lama pulu, ome yiake leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ome yiake leai-kola, matili wanda yalo okone balapi omeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Amene yanasa utupane pitaka-mane wanda mindiki okone teke kee leai-ko. Matili wandakali omene tupa malinga ika lolai-angi, wanda okone bala amene yanasa utupanena mindi andokona wetene pitulu-peyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wuane leai-kola, Jisasato utupane lamawuato, andipa nanimato yuu okona ateyama-angi, wanda-mane akali pulu, akali-mane wanda kee lalu, piyaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Utupane-mane wuane piyaini tekeko, matili Goteto wandakali omene tupa pitaka malinga ika laya wato, minditupa bala towa atu saka atapowa ateakale lolopeya. Wuane lola-kola, wandakali utupane Gotena andopane yame atoto, enjole tupa oma na-piyaini pua, wandakali utupane katulo lapone oma napulu-peyai. Okone angi wanda-mane akali napolo-peyai. Akali-mane wanda kee nalolo-peyai teke. ");
INSERT INTO ipi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Goteto andeya-kola, wandakali wamba omeaini tupana tandini tupa saka ateyai-ko. Gote bala wandakali omene tupana Gote ateya nalape-pene. Jia. Bala wandakali saka ateyai tupana Gote oko ateya. Tene okonena, Apatakame, Aisake, Jekopo ima wamba omeai-kola teke, matili ita saka aŋako mindi ita lungu-mane teane okone angi, Mosesato pii mindi loto, Akali Andane oko bala Apatakame, Aisake, Jekopo ima utupanena Gote ateyo leaipia. Akali tepo omeaini utupanena tandini tupa saka ata napeai-yale, Mosesato Akali Andane oko andayo, bala akali utupanena Gote ateyo nalea-yale. Jia. Bala akali utupanena Gote atewa lea-yaleko. Mosesato Akali Andane oko bala akali utupanena Gote ateyo leane okomane wandakali pitaka malinga ika lolo-peyama lo andawa leane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Jisasato wuane lea-kola, Satusi yame tupamane pii waka mindi balanga tipa puyale yuku wato, konda yainipia. Konda yai-kola, loo tupana mana andene akali ateaini tupamane Jisasa lamawuato, tisa, nimbato Satusi utupanena pii lalai tupa kuai lo wetete yano peyale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Loo tupana mana andene akali tupamane wuane leai-kola, Jisasato utupane lamawuato, anu peakale akali minditupa-mane Mesaya oko bala mee Dapitina mandiyene ateya lalainipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Wamba Dapitito Gotena pii mindi buku Sama okona pepa peyoto, Akali Andane Gote okomane nambana Akali Andane Mesaya oko lamawuato, nambato nimba towa yanda-pene wandakali tupa nimbana kee pangosa ateakale lokalenga, nimba nambana kii tikasa-tole pitipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wamba Dapitito Mesaya oko andayo, bala nambana Akali Andane ateya leaipia-ko. Anu pua, Mesaya oko bala katulo Dapitina mandiyene ateyape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","47","Jisasato pii okone loo tupana mana andene akali tupa lamaiya-kola, wandakali pitaka-mane ale yainipia. Ale yai-kola, okone angi teke Jisasato balana disaipolo tupa lamawuato, loo tupana mana andene akali tupa yakama tane gene yene ateyama nembo toto, tona epene wete kii kee puyoko lene tupa puato, epoko puyale, epele wete alaini leaipia. Utupane-mane wandakali kambua amunguli piyaini ama tupana ateyai-angi, wandakali waka tupamane utupane andoto, akali andane, nimba ani pelepe lapiai lakae lo nembo talaini. Utupane-mane Juta yamena lotu anda tupana poto, toko bulupane tupana pituyale, epele wete alaini. Dee, wandakali kambua-mane tomo andane mindi no peteyai-angipi, utupane-mane akali kawane pitiyaini toko tupana pitima lakae lo nembo talaini. Wandakali waka tupamane utupane akali epene ya lo andeakale nembo toto, akali utupane-mane pote luu wetete tupa lalaini. Wuane tekeko, akali utupane-mane langa-langa puato, wanda yalo tupana eepi, andapi, utupane mialaini. Tene okonena, matili Goteto kenda-pene andane wetete mindi loo tupana mana andene akali utupanenga maulu-peyako. Yakamato akali utupanena mana koo tupa wato minulaini. Tika ando atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Akali amango tupamane lotu anda andane okona epo pitiki puato, Gote wayu pele lo muni kambua aindaka lolo ipuku peai-kola, muni aki-tupi aindaka leyaipe lo Jisasato anda peyo peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Utupane-mane wuane peaini tekeko, Jisasato andea-kola, wanda yalo tipia wete mindi epoto, Gote wayu pele lo muni aŋako one-pene lapo angu aindaka leanga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Andoto, Jisasato balana disaipolo tupa lamawuato, nambato pii enene mindi yakama langeyo leaipia. Akali amango tupa pitaka-mane muni kambua yakama tanenga yakale loto, minditupa aindaka lalai tekeko, wanda yalo okonga bala tane tomo kambo nolane muni naya-kola, muni aŋako one-pene lapo angu balanga yala. Balato okonelapo lapotaka aindaka lala okomane wandakali waka tupa pitaka sia minuto, muni kambua wetete aindaka lala. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Okone angi, Jisasana disaipolo tupamane lotu anda andane oko andoto, akali minditupa-mane ana epene wetete tupa moto, lotu anda andane oko peainipia. Wuane peai-kola, wandakali waka minditupa-mane Gote wayu pele lo minditaka epene wetete tupa moto, lotu anda oko kuai lo yati peaini ya leainipia. Wuane leai-kola, Jisasato utupane lamawuato, matili oto mindi epola-angi, akali minditupa epoto, anda utupanena ana mindikipi mindi ana yangone mindina tokonga yakale lo ando konda naene, utupa pitaka keao loto, yuunga tepa ayiake lolopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wuane lea-kola, Jisasana disaipolo tupamane bala tipa puato, tisa, andoko angi akali minditupa-mane lotu anda andane oko minu koyolo-peyaipe. Mangene anu-pene mindi wamba ini bulupane pula-kola, nanimato andoto, andipa yuu oko koyo puyale peya lo andolo-peyamape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Wuane leai-kola, Jisasato utupane lamawuato, matili akali kambua yale-yale ipuku puato, Mesaya oko namba epeyo. Andipa yuu koyo pulane oto oko wamba mandaka epeya lo yakama langulu-peyaiko leaipia. Akali mindimane Mesaya oko namba epeyo loto, yakama andakasa olaini. Waiwa ando atalapape. Yakamato akali utupane mindina disaipolo ata na-piyapape. ");
INSERT INTO ipi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","10","Matili wandakali yame andane mindimane wandakali yame andane waka mindi yanda pimaulu-peya. Akali kiŋi mindina yame-mane kiŋi mindokona yame oko yanda pimaulu-peya. Akali minditupa-mane gapomane oko yanda pimaulu-peya teke. Wandakali-mane mangene utupane wamba ini pipe-pene tekeko, okone angi teke yuu oko wamba kapoyale koyo napulu-peyako. Wandakali-mane yanda andane mindi pua atolai-kola, yakamato ale wato, andipa yuu oko koyo peya nayuto, yakama yuku aa na-piyapape. ");
INSERT INTO ipi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yuu minditupana yuu titiwali andane tupa lolopeya. Yuu minditupana ulia nono andane tupa yolopeya. Yuu minditupana siki koo andane tupa peyolo-peya. Ati kenga tawe mangene andane mindipene-mindipene pulai tupa kokoli gulola-kola, wandakali-mane yuku-mane omolo-peyai. ");
INSERT INTO ipi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kenda-pene utupane pitaka wene epoyale pula-kola, yakama nambana yame ateyai lo andoto, wandakali minditupa-mane kenda-pene andane minditupa yakama giki pulupeyai. Utupane-mane yakama andi lo awua poto, Juta yamena lotu anda mindina yandopi, katapusa anda mindina yandopi, okone-lapona mindina polopeyai. Wuane pulai-kola, akali waka minditupa-mane yakama kosimi loyale, andi lo awua poto, gapomane akali andanepi, kiŋipi, utupanena wenonga ataya olopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yakama akali utupanena wenonga atolai-angi, yakamato nambana wai pii layene epene oko akali utupanenga lamaulane asini oko lumbu ene yolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Wuaneko, akali utupane-mane yakama kosimi lolai-angi, namba tane yakama mo wai aya wato, yakamato utupanena pii okone yano peyoto, wua lalapale loto, nambato yakamana nembo-tene tupa mina ika lokale. Nambato yakama mo wai-ene gulaya wato, wua lalapale lo yakama langulu-wakola, yakamato pii nambato yakama languluwa okone lolopeyai. Yakamato pii okone lolai-angi, yakama towa pii yanda pulai wandakali tupamane anu pua yakamana pii okone yano peya-makalepe lo tatake wato, yakama sia mina napulu-peyai. Tene okonena, wandakali minditupa-mane yakama kosimi loyale atolai-angi, nanimato aki loto, utupanena pii okone yano peya-makalepe nembo toto, yakamato pii lolane mindi ini mandeke na-piyapape. ");
INSERT INTO ipi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yakama nambana yame ateyai mambele, yakama tanena angini ayianepi, amenepi, yamepi, utupane-mane yakama ene pitulai-kola, yakama towa yanda pulai akali utupane-mane yakamana minditupa peyo ome lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wandakali waka kambua-mane yakama towa embo wetete olopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wuane tekeko, yakamato Kataisa bilipi leyama nayu lo atolai okonena, yakamana kawa itini ateya tupana mindikipi mindi alu napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yakamato nambanga tungi peyo bilipi lo atoto, kenda-pene utupane awua ateaindo, matili yakama saka atapowa atolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","22","Wuane lalu, Jisasato pii mindi tako pua loto, Gotena pii pepa pelene eya oko enene guleakale loto, Goteto koo piyaini wandakali tupa yole koo maulupeya leaipia. Yole koo mindi malupeya okonena, matili yakamato andolai-kola, Jutusaleme tane wandakali tupa towa yanda-pene akali tupana ami tupa epoto, Jutusaleme tano oko ato mapu pulupeyai. Wuane pulai oko andoto, yakamato Jutusaleme tano koyolane oto oko mandaka epeya nembo talapape. Wuane nembo toto, Jutusaleme tano okona takita atolaini wandakali yakama tano okonena kolandaka lolaini. Jutusaleme tano okona anda-pangosa atolaini wandakali yakamato tano okone tepa alu, palaka pulupape. Jutiya disitiki okona atolaini wandakali yakama ata too pua atamakale nembo toto, yuu wangiane tupana palaka pulupape. ");
INSERT INTO ipi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","24","Okone angi, andopane ininga piti-pata pitulai wanda tupapi, andopane andu no atene pitulai wanda tupapi, utupane palaka pupe-pene pitete wato, ondo wete ape-pene gulo pitulu-peyai. Goteto Jutusaleme tane wandakali tupa towa yataka wato, yole koo mindi utupane mawuato, kenda-pene andane wetete minditupa wandakali utupane maulupeya. Okone angi, utupanena yanda-pene tupamane wandakali minditupa kandepa-mane yokowa ome lalu, minditupa andi lo awua yuu waka-waka tupana puku pulupeyai. Ee ana kambua wetete, wandakali yame waka tupamane Jutusaleme tano oko angowa tambaiyuto atolai-kola, matili yuu koyo pulane oto oko epola-angi, utupane-mane kondolo-peyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","Wuane lalu, Jisasato pii mindi tako pua loto, okone angi Akalina Iwanane oko epoyale peya lo andawa loyale, nai, ana, kaiyanda ima-mane mangene minditupa pulupeyai. Goteto ati iyu okona minditaka tai ateya tupa mo ema-ema piya ola-kola, wandakali-mane andoto, yuu okona anu pulu-peyape lo yuku-mane omoto, lee lemowa atolopeyai. Yuu okona ipa angini andane solewata peteya tupamane taimane wete ika loto, lekawa tepa ola-kola, tula-lene puku pula-kola, wandakali-mane ale wato, anu peyape lo tatake wato, nembo kambua tolopeyai. ");
INSERT INTO ipi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Okone angi, wandakali-mane andolai-kola, Akalina Iwanane oko bala mole mindina tokonga atoto, balana tai-lene andane okopi, tii-pene andane okopi, okonelapo towa atu epolopeya. ");
INSERT INTO ipi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mangene utupane tewa pula-angi, Goteto yakama molo-peke lolo epolane oto oko wamba mandaka epeya lo andoto, yakama ika loto, ati kenga iyu oko andaiyu lo maliyo atalapape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wuane lalu, Jisasato pii kokoli mindi wandakali utupane lamawuato, yakamato ita pikipi, ita waka tupapi, utupane pitaka andalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ita utupanena yokone tupa kome peya-kola, yakamato yokone utupane andoto, panyu puyale peya lo andalaini. ");
INSERT INTO ipi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wuane pua teke, matili mangene minditupa pulupeya leyo tupa pulai-angi, yakamato mangene utupane andoto, Goteto yakama ando atolane oto oko mandaka ipulua lo andalapape. ");
INSERT INTO ipi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nambato pii enene mindi yakama langeyo. Wandakali yame andipa ateyai tupa pitaka oma yiake nalolai-kola, mangene utupane pitaka pulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Matili yuu ati-la alu pulupeya tekeko, matili-matilipi nambana pii oko alu napulu-peya. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Wuane lalu, Jisasato pii mindi tako pua loto, Akalina Iwanane oko epola-angi, balato yuu okona wandakali tupa pitaka yapa lo tale pulupeya leaipia. Poloko pandu mindi yola oko anda napene, poloko mindi ambe epeando, pandu okonemane bala peleya-kola, omalane. Wuane pua teke, wandakali minditupa-mane Akalina Iwanane oko epolopeya nembo natene, nanimato anu puato, minditaka eya tupa mia-makale nembo kambua tolopeya. Wuane nembo toto, utupane-mane ipa tai kambua no sipaki loto, mana koo waka tupa minu atolopeyai. Yakamato wuane pua ateaindo, matili Akalina Iwanane oko bala kapoyale ini epoto, yakama yapa lo tale pulupeya. ");
INSERT INTO ipi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tene okonena, yakamato Akalina Iwanane okona wenonga tika pua atamakale nembo toto, yakama tane mana koo utupane minulaini. Tika ando atalapape. Ole dindi lo yakama tane ando atoto, yakamanga kenda-pene epola tupa peyo wanjialapale. Goteto asini mindi yata-geakale lo pote lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Utulu dindi lo Jisasa bala Jutusaleme tepa alu, Olipi wangiane okona poto, paliki peaipia. Paliyu, ole dindi lo bala Jutusaleme peke loto, lotu anda andane okona atoto, pii mana lamawua atea-kola, wandakali pitaka-mane balana pii ale oyale, lotu anda okonena ipuku peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Betesanga yisa napalene nalaini oto gene Pasopa lene oko mandaka epeane-angi, loo tupana mana andene akali tupapi, pitisa akali kawane tupapi, utupane-mane Jisasa peyo ome lolane asia mindi ayia pua ateainipia. Wuane tekeko, Jisasa andi loto, peyo ome loloma-kola, wandakali kambua epo amunguli peyai tupamane nanima towa yataka olopeyai nembo toto, utupanena wenonga bala andi loyale yuku yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jisasa peyo ome lolane asia mindi ayia pua ateai-kola, Satane bala disaipolo alesa tupana akali Jutasa Isaka-tiyote lene oko balanga kolandaka leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kolandaka lea-kola, Jutasa bala poto, pitisa akali kawane tupapi, lotu anda andane okona sukutiti akali kawane tupapi, utupane towa pii lalawa puato, nambato wua puato, Jisasa ene pitukale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wuane lea-kola, akali utupane-mane bala towa epele wato, Jutasa nimbato wuane peendo, nanimato muni minditupa nimba gulupeyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wuane leai-kola, Jutasato atu yalua leaipia. Matili wandakali kambua Jisasa towa atu ata napulai-angi, nambato bala ene pitukale lalu, Jutasato maliyo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Betesanga yisa napalene nalaini oto oko epeya-kola, Juta yame-mane Pasopa tomo tupa namakale nembo toto, sipisipi andopane mindi peyo nalainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Oto okone epea-kola, Jisasato Jone, Pita-la, okonelapo lamawuato, Pasopa tomo tupa namakalenga, liyambato mandeke pulu pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wuane lea-kola, akali okonelapo-mane bala tipa puato, nalipato aninga poto, Pasopa tomo tupa mandeke pipiapi lakae lo nembo telepe leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wuane leapi-kola, Jisasato akali okonelapo lamawuato, liyambato Jutusaleme tano okona polapi-kola, akali mindimane ipa pene andane mindina ipa ambu awua epoto, liyamba malanda olopeya leaipia. Liyambato akali okone watama poto, anda bala kolandaka lola okona teke liyambapi kolandaka lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kolandaka loto, liyambato anda anduane oko lamawuato, tisa okomane nimba tipa puato, nambana disaipolo tupa towa Pasopa tomo tupa nolane lumu oko aninga eyape lala lalapape. ");
INSERT INTO ipi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wuane lolapi-kola, balato liyamba atu aiyu poto, dapolo anda kenga okona lumu andane mindi liyamba andawa lolopeya. Lumu andane okonena tepolo tokopi, pitulane tokopi, okonetaka tupa pitaka yolopeya. Lumu okonena, liyambato Pasopa tomo nolane tupa mandeke piyapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wuane lea-kola, Jone, Pita-la, liyamba poto andeapi-kola, Jisasato minditaka yolopeya leane tupa pitaka ya-kola, okonelapo-mane Pasopa tomo nolane tupa mandeke peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasopa tomo nolane gii oko epea-kola, Jisasapi, balana disaipolo tupapi, utupane-mane tomo noyale tokonga peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Peteai-kola, balato utupane lamawuato, andipa Pasopa tomo noloma oko nalu, nambato Pasopa tomo oko dee lapone nanene atama pulu, Goteto yuu oko moyo ando atolo epola oto okona giau lolo-peyawa lo nambato yakama langeyo leaipia. Tene okonena, andipa nambato Pasopa tomo oko yakama towa atu naima lakae lo nembo teyo. Nalu, matili namba tandaka andane nolo-peyawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Wuane lalu, balato waene petene kapo mindi moto, Gote ando wayu pele loto, balana disaipolo tupa lamawuato, andipa namba towa waene neyama oko nalu, nambato waene oko dee lapone nanene atama pulu, Goteto yuu oko moyo ando atolo epola oto okona giau lolo-peyawa lo nambato yakama langeyo-ko. Yakamato waene oko tale pua nalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wuane lalu, balato betesa mindi moto, Gote wayu pele lalu, betesa okone konde lea. Konde loto, balana disaipolo tupa mawuato, oko nambana umbaini oko. Nambato yakama moyo geyo oko. Matilipi yakamato namba nembo tolo-peke loyale, betesa oko nalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tomo no koyo peai-kola, wuane pua teke, Jisasato waene petene kapo mindi meaipia. Moto, balato utupane lamawuato, nambato pii wenene mindi yakama towa lo yata wato, yakama moyoyale, nambana tundupa ita malamanda okona gae lolowa okomane wandakali tupa pitakana koo tupa apia-maulupeyo leyo. ");
INSERT INTO ipi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","Enene, wamba Goteto Akalina Iwanane okonga asia mindi andawa lea-kola, Akalina Iwanane okomane asia okone wato minuto omolo-peya tekeko, bala ene pitula akali oko ondo wete ape-pene. Namba ene pitulane akali okone bala namba towa atu tomo noyale peteyama oko andalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisasato wuane lea-kola, balana disaipolo tupa yakama teke-teke pii lalawa puato, nanima peteyama tupana apito mana koo okone minuyale peteyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wuane lalu, Jisasana disaipolo tupa yakama teke-teke pii yanda puato, nanima ateyama tupana akali kawane api ateyape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","27","Wuane leai-kola, Jisasato utupane tipa puato, tepolo tokonga tomo no pitiyane akali oko bala akali andane lipinga-yale atalaepe. Pee, tomo yanga-maiyane piape akali okomane tomo no pitiyane akali okone sia minuto, lipinga-yale atalaepe. Tomo no pitiyane akali oko bala lipinga-yale atalane tekeko, namba tomo yanga-maiyawane piape akali okonetaka gulo atoto, yakama towa atu ateyama. Enene, wandakali yame waka tupana kiŋi tupa yakama tane akali andane gene yene ateyama nembo toto, wandakali waka tupamane utupanena gene tupa laiyu loto, yakamato nanima moyalaini leakale lalaini. Utupane-mane wuane piyaini tekeko, nambana disaipolo tupa yakamato wuane na-piyapape. Jia. Yakamana akali kawane wetete oko bala wandakali waka tupa pitakana napinga wete gulo atoto, utupanena piape akali gulo atape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","30","Wamba nambana ayiane okomane namba kiŋi atape leane. Nambato kiŋi piape pua ateyo-angi, kenda-pene koo kambua tupa nambanga epeya-kola, yakamato namba tepa naene, namba towa atu atalaini. Tene okonena, matili yakama nambana yuu epene okona poto, tomo ipapi, no pitiyapale nembo toto, nambato yakama kiŋi tupa atalapale lokale. Wuane lolowa-kola, yakama kiŋi pitiyaini toko tupana pituto, Isatale tane wandakali yame alesa tupana pii lolai tupa lo tika pulupeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Okone angi, Jisasato Pita lamawuato, Saimone, Saimone, wandakali tupamane witi dinipi, imbunipi, utupane yapa lalaini pua, Sataneto disaipolo yakama pitaka yapa lo mandeke pukale nembo teya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sataneto wuane nembo teya tekeko, nimbana bilipi oko wetete koyolane loto, nambato Gote lo pote lauwa-ko. Matili nimba yamapane peke lole-angi, nimbana amene tupa minu tai laya ape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wuane lea-kola, Pitato Jisasa lamawuato, Akali Andane, namba nimba towa atu katapusa andaka pupe-pene guleandopi, omape-pene guleandopi, nambato katulo wuane pukale lo mandeke pitawa ateyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wuane lea-kola, Jisasato bala lamawuato, andipa eka pauli maipa mindimane pii nalola-kola, ole tepoainga nimbato wandakali minditupa lamawuato, nambato Jisasa anda na-peyawane lolopele lo nambato nimba langeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wuane lalu, Jisasato balana disaipolo tupa tipa puato, wamba nambato yakama nuupi, munipi, sukepi, mindi mandi napene, mee pulupa lewa-angi, yakamanga minditaka mindi jia ya-kola ateaipe leaipia. Wuane lea-kola, utupane-mane minditaka mindi nanimanga jia naya-kola, atema leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","37","Wuane leai-kola, balato utupane lamawuato, wamba nambato yakama mee pulupa lewa tekeko, andipa Gotena pii pepa pelene eya mindi nambanga enene guloyale peya. Pii okonemane loto, wandakali tupamane akali oko bala mana koo tupa minalane loto, koo pua atalaini akali tupa towa mina mindiki leaini layene eya. Akali minditupa-mane nambanga wuane pulai-kola, pii layene okone nambanga enene gulolo-peya. Tene okonena, andipa yakamato mindisa polai-angi, nuu, muni-la, yaindo, okonelapo mandiyu pupe-pene guleya. Akali mindi bala kandepa luu ai napene ateaindo, balana tona sakesa pulane oko akali waka mindimane kambo meakale salimi loto, muni molane okonemane kandepa luu mindi kambape-pene guleya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jisasato wuane lea-kola, balana disaipolo tupamane bala lamawuato, Akali Andane, nanimato kandepa luu lapo yatawa ateyama leainipia. Wuane leai-kola, Jisasato atu yalua leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wuane lalu, Jisasa bala Jutusaleme tepa alu, Olipi wangiane okona ole dindi palane pua teke pea-kola, balana disaipolo tupa atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wangiane okonena peakaiyu leai-kola, Jisasato balana disaipolo tupa lamawuato, Sataneto yakama minu mandeke pula-kola, yakama yuunga peakolaini. Pote lo atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Wuane lalu, Jisasa bala ambinga-yale akali-mane yandate peyo lopape-pene mindi gulo poto, aiki lekawa pote loto, nambana Ayiane Gote, nambato tandaka nape-pene oko peya wanju olane asini mindi yando, nimbato asini okone lumbape. Nimbato wuane pula lo nambato nembo teyo tekeko, nambato nembo teyo pua napene, nimba tane nembo tele pua pipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Jisasato wuane lo pote lea-kola, enjole mindi ati kenga atala epoto, Jisasa minu tai laya ya-kola, Jisasato lapone teke pote leaipia. Okone angi bala yamapane kenda andane wato, pote taimane lea-kola, weno pundu balanga kili leane okomane tundupa gulo yuunga dopo lo tepa yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jisasa bala pote lo koyo piyu, ika lalu poto, balana disaipolo tupa andea-kola, utupane-mane yamapane kendawa, limu palu ateaininga andeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Andoto, Jisasato utupane lamawuato, anu peakale yakamato limu palu ateyaipe. Sataneto yakama minu mandeke pula-kola, yakama yuunga peakolaini. Ika loto, pote lo atalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisasato wuane lo atea-kola teke, balana disaipolo alesa tupana akali Jutasa lene oko bala akali kambua towa atu epeaipia. Jutasa bala Jisasa nunu loyale, wamba ini ingane bala ateanga mandaka epeaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Epea-kola, Jisasato bala lamawuato, Jutasa, nimbato Akalina Iwanane oko nunu lele okomane ene petelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wuane lea-kola, balana disaipolo tupamane andeai-kola, akali epeaini tupamane Jisasa andi lolo epalaiya lo andeaini-pia. Andoto, utupane-mane Jisasa tipa puato, Akali Andane, nanimato akali utupa kandepa-mane yoko amape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wuane lalu, Jisasana disaipolo mindimane pitisa akali kawane okona piape akali mindina alene tikasa-tole kandepa-mane yoko taka lo tepa yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wuane pea-kola, Jisasato kondalapa lalu, akali okonena alenenga kii yata wato, mo atu yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Juta yamena akali kawanepi, pitisa akali kawanepi, lotu anda andane okona sukutiti akali kawanepi, utupane-mane Jisasa andi lolo epeai-kola, balato utupane tipa puato, nambato gapomane oko yanda pimawuato, minditaka pake nalane nembo toto, yakamato kandepa luupi, mulipi, utupane awuato, namba andi lolo epeyaipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ole dindi namba yakama towa atu lotu anda andane okona ende anda-pangosa ataima. Okone angi, yakamato namba andi nalapia tekeko, undupi-lene okona tai-lene okomane piape taimane peya-kola, yakamato katulo namba andi lolopeyai. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisasato wuane lea-kola, akali utupane-mane bala andi lo auwa peai-angi, Pita bala amonga-yale ata iki lama watama peaipia. Utupane-mane Jisasa andi lo auwa poto, pitisa akali kawane okona andaka kolandaka leai-kola, Pita bala kamaka ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Okone angi, akali minditupa anda okonena ende anda-pangosa ita yango, upa endo yo peteai-kola, Pita bala poto, utupane towa atu peteaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Petea-kola, piape wanda mindimane bala andapeyo yoto, akali oo peteya oko balapi Jisasa towa atu atalapele leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Balato wuane leane tekeko, Pitato wanda okona pii okone tanga loto, wanda, nambato Jisasa anda na-peyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aŋa matili yale akali mindimane Pita andoto, nimbapi Jisasana disaipolo mindi atele lea-kola, Pitato akali okonena pii okone yano peyoto, akali, nambato bala anda na-peyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wuane lea-kola, matili awa mindikipi mindi pea-kola, akali waka mindimane pii leyo nayu loto, akali oko bala Galili disitiki tane yako. Enene wetete, bala Jisasa towa atu atalapele ya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wuane lea-kola, Pitato akali okone lamawuato, akali, nimbato aki nembo toto, wuane lelepe. Nambato akali okone nembo nateyo. Balato wuane lata ya wete, eka pauli maipa mindimane pii leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eka pauli okonemane pii lea-angi, Akali Andane oko bala anda peke loto, Pita andatawa ya-kola, wamba Akali Andane okomane namba languato, andipa eka pauli maipa mindimane pii wene loyale pula-kola, ole tepoainga nimbato wandakali minditupana wenonga atoto, nambato Jisasa anda na-peyawane lolopele lo namba langiya oko enene ya lo nembo teaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wuane nembo toto, Pita bala ende kamaka poto, ai lo yamataka leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Okone angi, Jisasa kote leakale lo minatawa ateaini akali tupamane bala lamba leainipia. Lamba loto, utupane-mane Jisasana lene lapalapa-mane yake pua ombo wato, bala peyalu, nimba potopesa akali gulo, akali okomane namba peleya lo nanima langi leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wuane lalu, akali utupane-mane Jisasa lamba loto, pii koo waka-waka kambua kimbu pua leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Loo tupana mana andene akalipi, pitisa akali kawanepi, akali utupanena minditupa Juta yamena kanjole okona ateainipia. Waa lea-kola, akali utupane-mane Jisasa kosimi lamakale lo epo amunguli peai-kola, akali minditupa-mane Jisasa utupanena wenonga andi lo awua epeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Epeai-kola, Juta yamena kanjole akali kawane utupane-mane bala lamawuato, nimba Mesaya oko ateendo, nimbato nanima langi leainipia. Wuane leai-kola, Jisasato utupane lamawuato, nambato yakamana pii okone yano pelewando, yakamato nambana pii okone bilipi nalolo-peyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nambato pii mindi yakamanga tipa pewando, yakamato nambana pii okone yano peya napulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wuane tekeko, andipapi, matili-matilipi, Akalina Iwanane oko bala Gote tai wetete okona kii tikasa pitulu-peya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wuane lea-kola, Juta yamena kanjole tupa pitaka-mane bala tipa puato, nimba tane Gotena Iwanane ateyo nembo toto, wuane lelepe leainipia. Wuane leai-kola, Jisasato utupane lamawuato, yakamato namba Gotena Iwanane ateya leyai okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wuane lea-kola, utupane-mane loto, bala tane pii okone leya-kola, nanimato ale eyama-ko. Anu peakale akali waka mindimane wisanisa atoto, bala tane Mesaya oko ateyo lalane lo nanima langeakale maliyo atamakalepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wuane lalu, Juta yamena kanjole tupa pitaka ika loto, Jisasa bala Pailate peteanga andi lo awua peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pulu, Pailate wenonga akali utupane-mane Jisasa kosimi loto, nanimato ale aima-kola, akali okomane pii mindi loto, namba yakamana kiŋi Mesaya lene oko ateyo-ko. Yakamato takisa muni tupa Lomo tane gapomane akali kawane Sisa oko maulaini lalane. Balato Juta yame nanimana mana epene tupa minu koyalane teke leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wuane leai-kola, Pailateto Jisasa tipa puato, nimba Juta yamena kiŋi okope leaipia. Wuane lea-kola, Jisasato bala lamawuato, nimba tane lele okoni leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wuane lea-kola, Pailateto wandakali kambua amunguli pua ateaini tupapi, pitisa akali kawane tupapi, utupane lamawuato, nambato akali oko kosimi lolane tene mindi ando mia napeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wuane lea-kola, wandakali utupane-mane pii taimane wete loto, wamba akali okomane Galili disitiki okona ato tewa mana lamaiyane leainipia. Balato mana lamawua atoto, wandakali tupanga nembo-tene koo minditupa mina ika layawa epoko pua atalu, matili bala Jutiya disitiki okona epeane. Andipa wali epo atoto, balato wuane pua teke ateya leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wuane leai-kola, Pailateto utupane tipa puato, akali oko bala Galili disitiki tanepe leaipia. Wuane lea-kola, wandakali mindimane Pailatena pii okone yano peyoto, enene, bala Galili tane mindi ateya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wuane lea-kola, Pailateto Galili disitiki ando atalane akali kawane Etote okomane Jisasana kote oko ale ape-pene nembo teaipia. Pasopa angi, Etote balapi Jutusaleme tano okona epo atolopeya nembo toto, Pailateto yanda yene minditupa lamawuato, yakamato Jisasa andi lo awua poto, Etote ateyanga pulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jisasato metekolo piape tai minditupa pua ateya lene oko Etoteto wamba ale yaepia. Ale wato, matili Jisasato metekolo piape tai mindi pula-kola, lee-mane andokale nembo tatawa atoto, Etoteto ee ana kambua maliyo ateane okonena, balato Jisasa epeanga andoto, epele wete yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Epele wato, balato pii kambua Jisasanga tipa pea-kola, Jisasato balana pii leane utupanena mindikipi mindi yano napeleai-pia. ");
INSERT INTO ipi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Yano napelea-kola, loo tupana mana andene akalipi, pitisa akali kawanepi, utupane-mane Jisasa taimane kosimi leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kosimi leai-kola, Etotepi, balana ami yanda yene ateaini tupapi, utupane-mane Jisasa anda napi loto, lamba leainipia. Lamba loto, utupane-mane tona epene wetete kiŋi-mane piyaini okonetaka mindi balanga piya maiyu, ami yanda yene minditupa lamawuato, yakamato Jisasa andi lo awua poto, Pailate ateyanga peke lalapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wamba Etote, Pailate-la, okonelapo yanda-pene atalapele tekeko, Okone angi, okonelapo liyamba amene gulo atoto, epelewa ateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jisasa bala Pailate ateanga andi lo awua peai-kola, Pailateto pitisa akali kawanepi, Juta yamena akali kawane tupapi, wandakali ongane ateaini tupapi, utupane pitaka epo amunguli piyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Epo amunguli peai-kola, Pailateto utupane lamawuato, wamba yakamato akali oko andi lo awua namba atalo okona ipupia leaipia. Yakama epoto, akali okomane Juta yame wandakali nanimana mana epene tupa minu koyalane lo namba langiyai. Tene okonena, yakamana wenonga nambato pii kambua balanga tipa piyo tekeko, akali oko kosimi lolane tene mindikipi mindi ando mia napiyo oko yakamato andalai okoni. ");
INSERT INTO ipi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Etotetopi, Jisasa kosimi lolane tene mindi ayia pitete wato, bala nanima ateyamanga peke leakale lala ya oko nanimato andeyama okoni. Akali oko balato koo mindikipi mindi napipiya yako. Tene andokona, nanimato bala peyo ome lamakalepe. ");
INSERT INTO ipi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tene koo mindi balanga ya napeya-ko. Ami yanda yene mindimane bala kunju-mane peleakale lokale. Peyola-kola, nambato bala tita lo tepa wakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","Wamba akali Batapasa lene mindimane Jutusaleme gapomane oko yanda pimawuato, akali mindi peyo ome lea-kola, gapomane okomane bala andi leaipia. Wuane tekeko, Pailateto Jisasa tita lo tepa wakale lea-kola, wandakali amunguli pua ateaini tupa pitaka-mane pii taimane loto, Batapasa tita lo tepa alu, Jisasa andi lo awua poto, ita malamanda okona peyo yuka aa leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Utupane-mane wuane leaini tekeko, Pailateto Jisasa tita lo tepa wakale nembo toto, pii wamba leane okone teke dee lapone lolo-peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wuane lea-kola, wandakali ateaini tupamane pii taimane latawa yapo wato, Jisasa ita malamanda okona peyo yuka aa laka peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wuane laka peai-kola, ole tepone gulo Pailateto wandakali utupane lamawuato, balato mana koo andoko minapia-kola, nambato bala ita malamanda okona peyo yuka wakalepe leaipia. Akali oko peyo ome lolane tene mindi nambato ayia pitete wato kondalo. Anu peakale nambato bala peyo ome lokalepe. Ami yanda yene mindimane bala peleakale lokale. Peyola-kola, nambato bala tita lo tepa wakale leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pailateto wuane lea-kola, wandakali utupane-mane pii taimane wete loto, Jisasa ita malanda okona peyo yuka aa leaini okonemane Pailatena pii leane okone ango yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Ango yai-kola, Pailateto utupanena pii okone wato minukale nembo teaipia. Wamba Batapasato gapomane oko yanda pimawuato, akali mindi peyo ome leane tekeko, Pailateto Juta yamena pii wato minuto, akali okone tita lo tepa yaepia. Wuane piyu, Pailateto Juta yamena pii wato minuto, Jisasa ita malamanda okona peya yuka alapa loto, ami yanda yene tupanga mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ami yanda yene tupamane Jisasa bala ita malamanda okona peyo yuka oyale, bala atu Jutusaleme tepa alu, peainipia. Peai-kola, Saitini tano okona tane akali Saimone lene mindi Jutusaleme epoyale epea-kola, asininga malanda yainipia. Malanda wato, ita malamanda Jisasato awua epeane okone Saimoneto aiyakale lo, ami yanda yene tupamane Saimonena paiyanenga mo ayia yainipia. Mo ayia yai-kola, Saimoneto ita malamanda okone aiyu, Jisasa pea okona masianenga watama peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wandakali kambua Jisasana masianenga watama peaini utupanena wanda kambua-mane ondo wato, ai andane lo yamataka lama peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","31","Wanda utupane-mane ai andane lo yamataka lama watama epeai-kola, Jisasato anda-peke loto, wanda utupane lamawuato, namba dini epene lialane ita saka gulo ateyo-kola, kenda-pene andane okone nambanga epeya leaipia. Jutusaleme tane wandakali yakama dini liya napiyane ita kapu gulo ateyai-kola, kenda-pene anu-pene mindi yakamanga epolopeya yape. Matili yanda-pene akali tupamane Jutusaleme tano oko minu koyolo epola-angi, kenda-pene andane wete mindi yakamanga epolopeya. Okone angi, wandakali-mane pii mindi loto, andopane-mane andu nanola-kola, wanda pitulai tupapi, wanda andopane mandi napene pitulai tupapi, wanda kinambuli pitulai tupapi, utupane palaka pupe-pene pitete naolo-peyama nembo toto, epele ape-pene lolopeyai. Kenda-pene andane okone epola-angi, Jutusaleme tane wandakali tupamane ati peleya tupa lamawuato, yakamato lopayia epoto, nanima peyo pulu piyapa lolopeyai. Utupane-mane wangiane peleya tupa lamawuato, inyu epoto, nanima peyo ombo alapa lolo-peyaiko. Jutusaleme tane wanda yame yakamato namba ondo wato, ai na-lalapape. Yakama tanepi, yakamana andopanepi, utupane ondo wato, ai lalapa. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Okone angi, koo piyapele akali lapo Jisasa mandaka ita malamanda laponga peyo yuka oyale, ami yanda yene tupamane akali okonelapo andi lo awua peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Utupane-mane yuu kawane kulini lene okona peakaiyu loto, Jisasa bala ita malamanda mindina peyo yuka yainipia. Wuane piyu, utupane-mane koo piyapele akali okone-lapona mindi Jisasana kii tikasa ita malamanda mindina peyo yuka alu, mindoko balana kii koyasa ita malamanda mindina peyo yuka alu peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Utupane-mane Jisasa ita malamanda okona peyo yuka yai-kola, balato pote loto, wandakali utupa-mane namba api ateyape nembo natene ato, namba peyo yuka eyai okonena, Ayiane Gote nimbato wandakali utupana mana koo oko apia-maipe leaipia. Okone angi, ami yanda yene tupamane Jisasana tona mindiki-mindiki lo mia-makale loto, laki leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Okone angi, wandakali ongane ateaini tupamane andatawa ateai-kola, Juta yamena akali kawane tupamane Jisasa lamba loto, balato wandakali waka tupa moyalae piako. Goteto bala Mesaya oko ateakale lea yando, bala tane katulo taputi pua meakale leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","38","Wamba Jisasa bala peyo yuka yaini okone angi, akali mindimane akali oko bala Juta yamena kiŋi oko ateya lo pepa peyalu, Jisasana ita malamanda okona kawanenga yuka yaepia. Matili ami yanda yene tupamane mandaka epoto, pepa okone dii lo andoto, Jisasa lamba loto, nimba Juta yamena kiŋi ateendo, nimbato nimba tane molo-peke lape leainipia. Wuane lalu, utupane-mane bala tipa puato, nimbato ipa waene kaa-pene pinika lene oko nolape leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Koo piyapele akali lapo peyo yuka atane ateapele okone-lapona mindimane Jisasa lamba loto, nimba Mesaya oko ateendo, nimba tane taputi pua mialu, nalipapi taputi pua miape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Wuane lea-kola, koo piyapele akali mindoko-mane bala laiya loto, nimbato Gote yuku naene, wuane lelepe leaipia. Nalipato mana koo minalapele tupana yole koo meyapa oko miape-pene teke meyapa-ko. Akali okomane koo mindikipi mindi napipia-kola, Goteto kenda-pene nalipa geya okopene teke balanga mee maiya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wuane lalu, balato Jisasa lamawuato, Jisasa, nimba kiŋi gulole-angi, nimbato namba nembo tolo-peke lape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wuane lea-kola, Jisasato bala lamawuato, nambato pii enene wete mindi nimba langeyo. Andipa teke nimba namba towa atu Patandaisa yuu epene okona atolo-peyapa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","46","Otonga oto kulini okona nai oko undupi loto, yuu tupa pitaka undupi lamangua atane angu atama peaipia. Matili ole-lene siti kiloko lea wete, Jisasato pii taimane loto, Aiyane Gote, nambana tandini oko nimbana kii tokonga yata eyo lalu, omeaipia. Omea-kola, lotu anda andane okona lapa-lapa andane yuka atane ateane oko kawanenga ato tewa, atutu kao lo lapo pea-kola, yuu oko tii pulu-peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mangene andane peane utupane pitaka andoto, ami yanda yene ando atalane akali okomane Gotena gene oko laiyu loto, enene wete, akali oko bala akali tika-pene epene wetete mindi atalaeya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wamba ami yanda yene tupamane Jisasa peyo yuka olo peaini okone angi, wandakali kambua-mane andolo peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Okone angi, Jisasa towa epelewa atene wandakali tupapi, Galili disitiki okona atalu, Jisasa watama epeaini wanda tupapi, utupane pitaka amonga-yale atoto, mangene utupane andatawa ateainipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wamba Jutiya disitiki tano Atimatiya okona tane Josepe lene mindi balana yuu tene okone tepa alu epoto, Jutusaleme tano okona ateaipia. Balato mana epene tika-pene tupa minu atoto, Goteto wandakali tupa ando atolo epeakale lo maliyo ateaipia. Bala Juta yamena kanjole okona ateane tekeko, kanjole okonena akali waka tupamane Jisasa omeakale leai-kola, balato utupanena pii leaini tupapi, mana mineaini tupapi, utupane atu yalua naleaipia. ");
INSERT INTO ipi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","54","Juta yame wandakali tupamane anate-lene Sambasa oto oko andamakale nembo toto, pitaka taka wamba ini mandeke piyaini oto oko epea-kola, Jisasa omeaipia. Sambasa oko wamba mandaka epea-kola, Josepe bala Pailate ateanga poto, Jisasana umbaini oko namba gulape lo tee lea-kola, Pailateto atu yalua leaipia. Wuane lea-kola, Josepeto Jisasana umbaini oko ondo yuunga tepa wato, lapa-lapa epene wete mindimane yake pua ombo wato, awua peaipia. Wamba akali minditupa-mane wandakali mali pulane panda wenene mindi ana ati mindina kua peaini tekeko, okonena wamba wandakali mindi mali napeainipia. Josepeto Jisasana umbaini oko awua poto, mali okonena yata yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wamba wanda minditupa Galili disitiki okona atoto, Jisasa watama epoto, Jutusaleme epeainipia. Matili Josepeto Jisasa mali pulu pea-angi, wanda utupane-mane watama poto, Jisasana umbaini oko wua pua yata ya lo andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Andalu, wanda utupane yakama Jutusaleme peke loto, matili wele tunduma-pene tupa Jisasana umbaininga ayia olo makale nembo toto, wele utupane mo mandeke peainipia. Mandeke piyu, loo oko wato minuto, Sambasa angi utupane yakama mee oto mo peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande angi upa pitane wete wanda utupane yakama ika loto, wele tundupa-pene tupa mandeke pua yata yaini tupa mo mandiyu, Jisasa mali pitane ateane okona peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Poto andeai-kola, Jisasana mali asia lomba tuma peane ana pata andane wete oko minu pendeke layene yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pendeke layene ya-kola, wanda utupane-mane mali ana anda okonena kolandaka loto, andeai wete, Jisasana umbaini oko mali okonena nayanga andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Naya-kola, balana umbaini oko aninga eyape lo nembo kambua toto, andeai wete, wamba kapoyale akali lapo utupane ateainga mandaka ateapele-pia. Akali okonelapo liyambana tona peapele tupa tii wetete piyoko pene ateapi-kola, wanda utupane-mane akali okonelapo andoto, yuku-mane omeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","7","Yuku-mane omoto, wanda utupane yakama anda yuunga lo ateai-kola, akali okonelapo-mane wanda utupane lamawuato, wamba Jisasa bala yakama towa atu Galili disitiki okona ateai-angi, balato yakama languato, matili akali mindimane Akalina Iwanane oko ene pitulu-peya leaipia. Ene pitula-kola, koo piyaini akali minditupa-mane bala ita malamanda okona peyo yuka olopeyai. Peyo yuka olai-kola, bala omalu, ole teponena malinga ika lolopeya lo balato yakama langea oko yakamato nembo tolo-peke lalapa. Wamba balato wuane leane pua teke, andipa bala malinga ika lalu pala. Bala mali okona ya napeya-ko. Anu peakale yakamato akali saka ateya okone wandakali omene yalane mali okona ayia peyaipe leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","10","Enjole okonelapo-mane wuane leapi-kola, Makatala tane wanda Matiya okopi, Jemesa angini Matiya okopi, wanda Jowanapi, wanda waka utupane towa atu epeaini tupapi, utupane pitaka-mane enjole okone-lapona pii leapele tupa ale wato, pii Jisasato wamba leane utupane nembo tolo-peke leainipia. Nembo tolo-peke lalu, wanda utupane-mane Jisasana mali okone tepa alu peke loto, Jisasana mali okona minditaka lee-mane andeaini tupapi, pii ale yaini tupapi, utupane pitaka aposolo akali masia tupapi, Jisasa lo bilipi lene wandakali waka tupapi, utupane pitaka lamai-yainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lamai-yaikola, wandakali utupane-mane pii utupane ale wato, wanda utupane-mane kee ene gulo pii okone leyai nembo toto, pii leaini tupa bilipi naleainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wandakali utupane-mane wuane nembo teaini tekeko, Pita bala ika loto, Jisasana mali okona taimane poto, tombawua loto, andandaka lea wete, Jisasa mali okonena ya napeanga andeapia. Jisasa bala mali peaini-angi, lapa-lapa mindimane bala puta pua ombo yaini okone angu tinga layene mali pango okona yanga andeaipia. Andoto, anu piya yape lo Pita bala nembo kambua tama peke leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ole okone angi teke, Jisasa lo bilipi lene lapo akali Jutusaleme tepa alu, tano aŋako Emeasa lene okona poyale asia peapelepia. Tano okone Jutusaleme mandaka-yale kilomita masiapi mindi poyale asia peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tano okonena poyale, akali okonelapo-mane asininga poto, mangene peane tupa temane lo pii lalawa pima peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pii lama peapi wete, Jisasa bala akali okonelapo wato minalu, akali okonelapo towa mina mindiki loto, atu peainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Atu peaini tekeko, minditaka mindimane akali okone-lapona lene oko mo ombo ya-kola, akali okonelapo-mane Jisasa atu peyama lo anda napene peapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Akali okonelapo-mane pii lalawa pima peapi-kola, Jisasato okonelapo tipa puato, asininga liyambato aki pii mindi lalawa pua lama peyapipe leaipia. Wuane lea-kola, akali okonelapo-mane mini kenda wato, asia puu napene, mee ongane atoto, weno omo ateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Atoto, akali okone-lapona mindi gene Kilopasa lene okomane Jisasana pii leane okone yano peyoto, satete ateyama okona mangene kambua wete pipia leaipia. Mangene kambua wete pipia-kola, Jutusaleme yuu okona wandakali ataima tupa pitaka-mane alewa nemboto ateyama-ko. Nimba angu ale naene, opene mindisa atalu epelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wuane lea-kola, Jisasato akali okonelapo tipa puato, mangene aki mindi pipiape leaipia. Wuane lea-kola, akali okonelapo-mane balana pii okone yano peyoto, wandakali pitakana wenongapi, Gotena wenongapi, Nasatesa tane Jisasa bala potopesa akali enene wete mindi atoto, metekolo piape tai-lene tupa piki puato, Gotena pii taimane lamaiki peane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Balato Gotena piape okonelapo piki pua atea-kola, bala potopesa akali epolopeya layene okone epo atoto, nanima Isatale tane tupa moyo ateya nembo tema. Wuane tekeko, pitisa akali kawane tupapi, nanimana akali kawane tupapi, utupane-mane bala kosimi loto, gapomane okomane bala peyo ome leakale lo maipiai-kola, ami yanda yene tupamane bala ita malamanda okona peyo yuka apiai-ko. Bala mali pitane ateya-kola, andipa ole tepone guleya. ");
INSERT INTO ipi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Andipa upa pitane wetete nanima yame wanda minditupa-mane Jisasana mali okona poto andalai-kola, balana umbaini oko mali okonena ya napiya yala. Ya napiya-kola, wanda utupane-mane peke loto, nanima languato, nanimato Jisasana mali okona poto andalama-kola, enjole lapo atalapi yala lalai. Enjole okonelapo-mane Jisasa bala saka ateya lalapi loto, wanda utupane-mane nanima langiyai-kola, nanimato pii utupane pitaka ale wato, moko andane lalama. ");
INSERT INTO ipi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Moko loto, nanima yame minditupa-mane Jisasana mali andolo palai-kola, pitaka taka wanda utupane-mane lalai tupa enene lalai ya lo andalai yala tekeko, akali utupane-mane Jisasa bala angini anda napiyai yala leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Wuane leapi-kola, Jisasato akali okonelapo tipa puato, Kataisa balato tandaka andane wamba ini nalu, matili bala gene andane miape-pene oko liyambato nembo nateyapipe. Wamba potopesa akali tupamane loto, Kataisato kenda-pene kambua awua atalu, matili bala omalu, ika loto, ati kenga polopeya leainipia. Anu peakale liyamba akali mini napalene gulo atoto, potopesa akali tupamane pii leaini utupane pitaka kapoyale bilipi naleyapipe leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wuane lalu, Jisasato pii wamba Mosesapi, potopesa akali waka tupapi, utupane-mane bala ando pepa peleaini tupa pitakana tene tupa lo pana wato, akali okonelapo lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jisasato akali okonelapo pii mana lamaima poto, Emeasa tano okona mandaka yale pulu, yuu waka mindisa poyale peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Poyale pea-kola, akali okonelapo-mane Jisasa lamawuato, ole loyale, nai baa andaka peya-ko. Nalipa towa palimakalenga, nimba puu napene, kondaa leapelepia. Wuane leapi-kola, Jisasa bala akali okonelapo towa palimakale lalu, andaka poto, peteaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Andaka pituto, matili akali okonelapo towa tomo noyale, Jisasato betesa mindi moto, Gote wayu pele lo pote lalu, betesa okone konde loto, akali okonelapo neakale maiyapia. ");
INSERT INTO ipi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jisasato betesa maya wete, akali okone-lapona lene tii pea-kola, akali okonelapo-mane bala Jisasa ya lo andeapele-pia. Andeapi-kola, akali okone-lapona wenonga okone angi teke Jisasa bala kapoyale latako peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Latako pea-kola, akali okonelapo liyambato pii lalawa puato, wamba nanima asini epalama-angi, balato Gotena pii pepa pelene eya minditupana tene tupa nalipa langiya okomane nalipana yamapane mina ika laya ala okoni leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wuane lalu, okone angi teke liyamba ika lalu, Jutusaleme peke loto, Jisasana disaipolo alesa akali tupapi, wandakali waka minditupapi, utupane pitaka amunguli pua ateainga andeapili-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Andeai-kola, wandakali amunguli pua peteaini tupamane akali okonelapo lamawuato, enene wete, bala malinga ika lala-kola, Saimoneto andala yala leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wuane leai-kola, akali okonelapo-mane wandakali utupane lamawuato, nalipa Emeasa yuu okona poyale palapa-kola, asininga Jisasato pii minditupa nalipa langiyu, balato betesa konde loto, nalipa giyu piya-kola, nalipato bala Jisasa ya lo andalapa leapelepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Akali okonelapo-mane pii utupane lamawua ateapi wete, Jisasa bala wandakali utupanena tombenenga epo ateaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Epo panawa atea-kola, wandakali peteaini utupane-mane bala andoto, balana tandini epo ateya nembo toto, yuku-mane omeainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Yuku yai-kola, Jisasato utupane lamawuato, anu peakale yakamato namba tandini angu epeya lo nembo kambua toto, yukuwa ateyaipe. Nambana tandini oko angu ipupia-yale, umbaini kulinipi nambana ateya okopene ata napipia-yaleko. Yakamana kii-mane namba mina andalapa. Namba Jisasa ateyo. Nambana kini kenengapi, nili peyapiai matikini oo eya utupa yakamato andalapa. ");
INSERT INTO ipi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wuane lalu, Jisasato balana kini kenengapi matikini yane tupa wandakali peteaini utupanenga andawa leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wandakali peteaini utupane-mane balana kini kenepi nili peleaini matikini yane utupane andoto, epele yaini tekeko, Jisasa bala anu pua ika lalu, nanima peteyamanga epo ateyape lo tatake wato, akali epo ateya oko bala Jisasa ya lo bilipi naleainipia. Utupane-mane Jisasa bala enene wete epo ateya lo bilipi naleai-kola, Jisasato utupane tipa puato, tomo nolane mindi eyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wuane lea-kola, utupane-mane pisa yangene mindi yaini oko bala mo mayainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mayai-kola, balato pisa okone mo nea-kola, utupane-mane andeaini-pia. ");
INSERT INTO ipi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Andeai-kola, balato wandakali utupane lamawuato, wamba Mosesapi, potopesa akali waka tupapi, utupane-mane namba andayo pii kambua pepa peyo yata yaini leaipia. Akali waka minditupa-manepi pii okonepene teke kambua minditupa buku Sama okona pepa peyo yata yainipia. Wamba namba yakama towa atu atema-angi, namba andayo pii pepa peyo yata yaini utupane pitaka matili nambanga enene gulolo-peya lo nambato yakama langewa-ko. Andipa utupane nambanga enene guleya leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wuane lalu, utupane-mane Gotena pii pepa pelene eya utupanena tene tupa nembo teakale loto, Jisasato utupane moyaepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Utupane moyoto, balato utupane lamawuato, Gotena pii pepa pelene eya mindimane loto, Mesaya bala tandaka andane noto, omalu, ole teponena malinga bala ika lape-pene. ");
INSERT INTO ipi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Malinga ika lola-kola, Jutusaleme ato tewa, akali minditupa-mane Mesaya okona gene oko loto, wandakali yame palu pula tupa pitaka lamawuato, Goteto yakamana mana koo tupa apia-geakalenga, yakama yamapane peke lalapape lape-pene layene eya. ");
INSERT INTO ipi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gotena pii layene eya pua, namba omalu, malinga ika lalu, saka ateyo oko yakamato lee-mane andeyai-ko. Yakamato piape okone pua atalapape. ");
INSERT INTO ipi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yakamato pii okone wandakali pitaka lamai-yapale nembo toto, wamba nambana ayiane okomane potomisa pii mindi yakama languato, matili nambato Oli Sipitisa oko yakama gukale lea okoni. Nambato Oli Sipitisa okone yakamanga epeakale lolowa-kola, bala ati kenga atala epoto, yakama minu tai laya olopeya-ko. Oli Sipitisa okone yakamanga epeakale loto, yakama Jutusaleme tano okona maliyo atalapape. Oli Sipitisa oko epola-kola, yakamato nambana pii oko wandakali pitaka lamalu pulupape. Jisasato wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Matili Jisasato balana disaipolo tupa lamialu, Jutusaleme tepa alu, Betani tano okona mandaka yale peainipia. Yuu okonena atoto, Jisasato balana kini okolapo ya loto, balana disaipolo tupa belesini mindi mayaepia. ");
INSERT INTO ipi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Belesini mawua atea-kola, Goteto Jisasa bala ati kenga epeakale loto mea-kola, bala ati kenga iyu okona peaipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pea-kola, utupane-mane bala lo lotu lalu, epele wete wato, Jutusaleme peke leainipia. ");
INSERT INTO ipi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Peke lalu, ole dindi lo utupane-mane lotu anda andane okona atoto, Gotena gene oko laiyu lo ateainipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wamba wetete yuu ati-la naya-kola, Gotena pii oko ateaipia. Pii oko bala tane Gote atoto, bala Ayiane Gote oko towa atu ateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yuu ati-la ungi lea-angi, pii oko bala Ayiane Gote towa atu ateapele-pia. ");
INSERT INTO ipi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Goteto minditaka eya tupa pitaka pii okomane angu yakale lea-kola, pitaka taka yaepia. Minditaka eya tupa pitakana mindikipi mindi asini waka mindina nayaepia. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Balanga saka atapowa atene oko yene. Balanga saka atapowa atene okonemane wandakali tupa mo tii piya yaepia. ");
INSERT INTO ipi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tii-pene oko bala yuu undupi-lene okona atoto, tii pua ateya tekeko, undupi-lene okonemane tii-pene oko sia mina napiyane. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Goteto akali mindi epeakale lea-kola, bala epo ateaipia. Akali okonena gene oko Jone. ");
INSERT INTO ipi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wandakali pitaka-mane balana pii ale wato, tii-pene oko lo bilipi leakale nembo toto, Joneto tii-pene oko bala akali oko lo wandakali tupa lamalu epea. ");
INSERT INTO ipi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jone bala tii-pene oko jia. Bala wisanisa mindi atoto, tii-pene oko bala akali oo eya oko loto, wandakali tupa lamalu epea. ");
INSERT INTO ipi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gotena pii oko bala tii-pene enene oko ati kenga atala yuunga epo atoto, wandakali pitaka mo tii piyawa atalane. ");
INSERT INTO ipi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Balato yuu ati-la yakale lea-kola, yuu ati-la okolapo yaepia. Bala yuu okona ateane tekeko, yuunga wandakali tupamane bala andoto, akali oko bala Mesaya oko ateya nembo nateai. ");
INSERT INTO ipi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akali okone balana yuu tene okona pea-kola, bala yame wandakali tupana kambua-mane bala Mesaya oko epeya lo lamia napeai. ");
INSERT INTO ipi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wuane tekeko, wandakali minditupa-mane bala lo bilipi loto, bala utupanena Akali Andane oko ateya leai-kola, Goteto utupane balana andopane tupa gulaya yane. ");
INSERT INTO ipi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ayiane angini-lamane andopane mindi liyambana tundupa paini mandipakale nembo toto, mindi mandiyapele tekeko, Goteto wandakali tupa balana andopane tupa guleakale nembo toto, mana okone wato mina napeaipia. Jia. Bala tane-mane wandakali utupane balana andopane tupa gulaya alane. ");
INSERT INTO ipi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gotena pii oko bala akali mindi gulo atoto, nanima aposolo akali tupana tombenenga epo atea. Nanimato andema-kola, bala Ayiane Gotena iwanane mindiki atoto, tai-lene wete atea. Goteto bala epeakale lea-kola, balato wandakali tupa ondo wete wato, wayumane moyo ateanga, nanimato andemane. Gotena pii enene oko balanga tumbi latane atea. ");
INSERT INTO ipi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","18","Enene, wandakali mindikipi mindimane Ayiane Gote oko alu mindikipi mindi lee-mane anda napeaini tekeko, balana Iwanane mindiki oko bala Ayiane Gote towa atu atalane okonemane Gote bala okopene lo nanima andawa leane. Wamba Goteto balana loo tupa Mosesanga maiya-kola, Mosesato Gotena loo utupane Juta yame wandakali nanima geane tekeko, Jisasa Kataisato nanima ondo wete wato, nanima mee moyoto, Gotena pii enene oko nanima langea. Gotena ondo ene oko balanga tumbi latane atea-kola, balato nanima pitaka ondo wete wato, mee moyaka pua atea. Ipa peya-maiyane akali Joneto Jisasa epeanga andoto, wandakali tupa pii taimane lamawuato, wamba nambato akali mindi matili epolopeya lo yakama langewa okoni leaipia. Angini-mane namba mandi napenenga, akali okone bala wamba ini bulupane ateaipia. Wuane nembo toto, nambato akali okone bala nambana Akali Andane oko atolopeya lo yakama langewa okoni. Akali okone bala andipa amo epeya oko andalapa. Joneto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Alu mindi, Jutusaleme tane Juta yame wandakali tupamane pitisa akalipi, Lipai yame akalipi, utupanena minditupa lamawuato, ipa peya-maiyane akali Jone oko bala ateyanga poto, yakamato nimba apipe lo bala tipa piyapa leainipia. Wuane leai-kola, akali utupane-mane poto, bala tipa peai-kola, balato wisanisa mindi atoto, utupanena pii okone yano peleaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Utupane-mane bala lamawuato, nimba Mesaya oko jia yalua leai-kola, balato utupanena pii okone tanga nalene, pii tika pua loto, enene, namba Mesaya oko jia leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jia lea-kola, utupane-mane bala tipa puato, nimba Mesaya oko jia yando, nimba potopesa akali Ilainja okope leai-kola, balato namba akali okone jia leaipia. Utupane-mane bala tipa puato, nimba akali potopisa mindi epolopeya layene okope leai-kola, balato jia leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jia laka pea-kola, utupane-mane bala lamawuato, nimba api atelepe lo nimba tipa pulu pulupa lo nanima langiyai akali utupane lamai-makaleko. Nimba apipe. Nimbato wua piyawane lo nimba tane nanima langi leai. ");
INSERT INTO ipi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wuane leai-kola, balato utupane lamawuato, wamba potopisa akali Aisayato pii mindi loto, akali mindimane wandakali napalene yuu mindina atoto, yakamato Akali Andane okona asini oko mo tika piyapa lo atolopeya layene eya. Nambato pii okone lo atalawane lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wamba Patasai tupamane akali utupane Jone ateanga peakale leai-kola, balato pii okone utupane lamaiya. ");
INSERT INTO ipi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Lamaiya-kola, utupane-mane bala tipa puato, nimba Mesaya oko yandopi, Ilainja yandopi, potopisa akali epolopeya oko yandopi, utupanena mindi ata napeendo, anu peakale nimbato wandakali tupa ipa peya-mawua atelepe leai. ");
INSERT INTO ipi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Wuane leai-kola, Joneto utupanena pii okone yano peyoto, nambato ipa-mane angu wandakali tupa ipa peya-maiyawane lea. Akali mindi matili epolopeya lewa oko balato namba sia minulu-peya. Namba akali gene nayene okomane balana suu kee pula okona eyaka oko tita lolane namba akali epene mindi jia. Bala yakama tombenga epo ateya tekeko, yakamato bala akali oko ya lo anda napeyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jone bala Betani yuu okona atoto, pii utupane lea. Betani yuu okone ipa Jotane okona amo yangi yene okonena mandaka Joneto wandakali tupa ipa peya-mawua atea. ");
INSERT INTO ipi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Anate-lene ipa peya-maiyane akali Joneto Jisasa epeanga andoto, wandakali ongane ateaini tupa lamawuato, Gotena sipisipi andopane epeya oko andalapa lea. Balato yuu okona wandakali tupana koo tupa apia-malu epeya. ");
INSERT INTO ipi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wamba nambato yakama languato, namba angini-mane namba mandi napenenga, akali matili epolopeya oko bala wamba ini bulupane ateane mambele, bala nambana lipinga gulo atolopeya lewa okoni. Akali epeya oko bala akali okone. ");
INSERT INTO ipi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wamba nambato akali okone bala Gotena Iwanane ateya lo anda napewane tekeko, Isatale tane wandakali tupamane bala akali oko ya lo andeakale nembo toto, nambato utupane ipa peya-malu epewane lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Wuane lalu, Jone bala wisanisa mindi atoto, wamba nambato akali okone bala Gotena iwanane ateya lo anda napewane tekeko, Goteto namba languato, nimbato ipa-mane wandakali tupa ipa peya-malu puu lea. Ipa peya-mawua atole-kola, matili Oli Sipitisa oko bala akali mindinga epo pitulanga nimbato andolopele. Akali okonemane piape puato, wandakali tupa Oli Sipitisa okomane ipa peya-malupeya lea. Goteto wuane lea-kola, nambato Jisasa ipa peya-maewa okone angi, Oli Sipitisa oko eka uya gulo, ati kenga atala yuunga epoto, balanga epo peteanga andewa. ");
INSERT INTO ipi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Andoto, namba wisanisa atoto, akali oko bala Gotena Iwanane ateya lewa. Joneto wuane lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Anate-lene Jone balana disaipolo lapo akali towa atu dee lapone yuu okonena ateai. ");
INSERT INTO ipi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Joneto Jisasa asia epo peanga andoto, Gotena sipisipi andopane oko bala amo epo peya oko andalapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Balato wuane lea oko ale wato, Jonena disaipolo okonelapo-mane Jisasa watama peapi. ");
INSERT INTO ipi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Watama peapi-kola, Jisasato anda-peke loto, okonelapo bala watama epeapinga andoto, liyambato aki mindi aiya pima epeyapipe lea. Wuane lea-kola, okonelapo-mane bala tipa puato, Lapai, nimba aninga pangilinipe leapi. Iputu pii loto, gene Lapai okone mopeke loto, tisa lalaini. ");
INSERT INTO ipi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aninga pangilinipe lo tipa peapi-kola, balato andolo ipulupa lea. Wuane lea-kola, okonelapo-mane bala towa atu poto, bala paleane anda oko andeapi. Okone angi, ole-lene taeme poo kilokopi mindi lea-kola, utulu okonena okonelapo bala towa anda okonena atu paleai. ");
INSERT INTO ipi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wamba ipa peya-maiyane akali Joneto Jisasa andayo Gotena sipisipi andopane oko bala amo epo peya oko andalapa lea-angi, lapo akali-mane balana pii okone ale alu, Jisasa watama peapele. Akali okone-lapona mindoko bala Saimone Pita amene Endutu oko. ");
INSERT INTO ipi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anate-lene balato balana amene Saimone okone wamba ini bulupane aiya pua andoto, nalipato Mesaya oko andaipa leaipia. Gene Mesaya oko mopeke loto, Gitiki pii lo Kataisa lalaini. ");
INSERT INTO ipi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nalipato Mesaya oko andaipa lalu, Endutu balato Saimone lamo atu Jisasa ateanga pea-kola, Jisasato bala andatawa yoto, nimba Jone iwanane Saimone atele tekeko, matili wandakali-mane nimbana gene oko Sipasa lolopeyai lea. Gene Sipasa okone Gitiki pii mopeke loto, Pita lalaini. Gene okone-lapona tene oko ana. ");
INSERT INTO ipi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Anate-lene Jisasa bala Galili disitiki okona pokale nembo toto, Pilipi aiya pua andoto, nimba namba watama ipu lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi bala Endutu, Pita-la, okonelapo towa Betesaita tano okona tane ateai. ");
INSERT INTO ipi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jisasato nimba namba watama ipu lea-kola, Pilipito Nataniale aiya pua andoto, bala lamawuato, loo yata yane buku okona wamba Mosesato pii mindi pepa peyoto, matili akali mindi epolopeya leaipia. Dee, Potopisa akali tupamane pii minditupa pepa peyoto, wuane teke leainipia. Andipa nanimato akali okone andalama. Bala Nasatesa tano okona tane Josepe iwanane Jisasa oko leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wuane lea-kola, Natanialeto Pilipi tipa puato, Nasatesa tano okona tane akali mindi katulo gene yene atolo-peyape leaipia. Wuane lea-kola, Pilipito bala lamawuato, nimbato andolanga, bakale ipu leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wuane lea-kola, Nataniale bala Jisasa ateanga poyale pea-kola, Jisasato bala epeanga andea. Andoto, balato Nataniale andayo, wandakali minakasawa owato pii na-lalane Isatale tane akali enene mindi epeya oko andalapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Wuane lea-kola, Natanialeto bala tipa puato, nimbato anu puato, nambana mana tupa andelenepe lea. Wuane lea-kola, Jisasato bala lamawuato, wamba Pilipito nimba ipu nalala-kola, nimba ita piki tene okona atale okone angi, nambato nimba andalo lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Wuane lea-kola, Natanialeto balana pii okone yano peyoto, tisa, nimba Gotena iwanane atoto, Isatale tanena kiŋi oko atele lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wuane lea-kola, Jisasato bala lamawuato, nimba ita piki tene okona atale okone angi, nambato nimba andalo leyo-ko. Tene mindiki okonena angu nimbato namba lo bilipi lelepe. Matili nambato piape okone sia minuto, piape andane wete tupa puluwa-kola, nimbato andolopele lea. ");
INSERT INTO ipi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wuane lalu, Jisasato bala lamawuato, nambato pii enene wete mindi yakama langeyo lea. Matili yakamato andolai-kola, ati iyu oko yapu lapo pula-kola, Akalina Iwanane okonga enjole tupa iyu puu, nena ipu pua atolainga yakamato andolopeyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jisasato Nataniale Pilipi-la, okonelapo ipulupa lenenga, ole lapo pea. Okone angi, Galili disitiki okona tano Kena tane akali mindimane wanda mindi kee lea-kola, Jisasana angini okomane andolo pea. ");
INSERT INTO ipi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Wanda kee leane akali okonemane Jisasapi, balana disaipolo tupapi, utupane yakama andolo ipulupa lea-kola, utupanepi andolo peai. ");
INSERT INTO ipi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Akali okonemane wanda kee lea-kola, andolo epeaini wandakali tupa pitaka-mane tomo no ateai. Tomo no ateai-angi, ipa waene oko koyo pea-kola, Jisasa angini okomane bala iwanane lamawuato, waene koyo piya lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wuane lea-kola, Jisasato bala lamawuato, ama, nambato kenda-pene okone mo tika pulane gii oko na-epeyako. Nimbato namba languato, wua pii nalape-pene lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Wuane lea-kola, balana angini okomane piape akali tupa lamawuato, balato mangene mindi piyapa leando, balato lola pua piyapape lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gotena wenonga kalato atene atolomane nembo toto, Juta yame wandakali tupamane ole kambuanga wasa-wasa peyoyale, jatamu andane minditupana ipa ambu pete loto, yata alainipia. Ipa jatamu andane ana-mane waa-pene wataka ongane mee yane utupanena mindiki-mindiki lo wandakali-mane katulo ipa pene andetepi mindi gae lo pete lape-pene. ");
INSERT INTO ipi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ipa jatamu andane utupane ongane yai-kola, matili Jisasato piape akali tupa lamawuato, yakamato ipa ambuto, jatamu utupa tumbi lalapa lea-kola, utupane-mane ipa ambuto, jatamu andane utupane tumbi wete laya yai. ");
INSERT INTO ipi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tumbi laya yai-kola, Jisasato utupane lamawuato, andipa ipa okonena minditupa ambuto, tomo tale pua mawua ando ateya akali oko malu pulupa lea-kola, utupane-mane ipa okonena minditupa ambu awua poto, bala maiyai. ");
INSERT INTO ipi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Piape akali utupane-mane mee ipa enene ambuto, bala maiyama nembo teaini tekeko, utupane-mane ipa okone ani tawe mialaipe lo tomo tale pua mawua ando ateane akali okonemane nembo natea. Nembo natene atoto, balato ipa okone no makande pea-kola, waene gulea. Waene gulea-kola, balato wanda kee leane akali oko epeakale lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Akali okone epea-kola, tomo tale pua mawua ando ateane akali okomane bala lamawuato, wandakali pitaka-mane waene epene oko wamba ini tale pua maiyaini. Wandakali-mane waene epene okonena kambua wamba ini no koyo peyai-kola, matili waene koo yale tupa tale pua maiyaini tekeko, nimbato waene koo yale tupa wamba ini tale pua maiyu, waene epene oko epapu mo awua epele lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisasa bala Galili disitiki okona tano Kena okona atoto, metekolo piape bulupane okone puato, balana tai-lene andane oko mo pana ya-kola, balana disaipolo tupamane bala lo bilipi leai. ");
INSERT INTO ipi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bilipi leai-kola, Jisasapi, balana angini okopi, amene tupapi, balana disaipolo tupapi, utupane yakama Kapaneame tano okona puu nena lalu, ole minditupa okonena ateai. ");
INSERT INTO ipi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juta yame wandakali tupa Pasopa tomo nalaini oto oko epoyale pea-kola, Jisasa balana disaipolo tupa towa atu Jutusaleme peai. ");
INSERT INTO ipi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Balato lotu anda andane okona ende anda-pangosa kolandaka loto andea-kola, wandakali-mane yia bulumakopi, sipisipipi, eka uyapi, utupane Gote lo opa maiyakale nembo toto, wandakali minditupa-mane okonetaka tupa makesa yo ateai. Akali minditupa-mane muni lawa pua peteaini teke. ");
INSERT INTO ipi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisasato utupane andoto, eyaka minditupa mo tongo pua mina mindiki loto, kunju mindi gulo waa puato, yia bulumakopi, sipisipipi, minditaka makesa yo ateaini wandakali tupapi, utupane pitaka peyo wata kamaka lalu, muni lawa pua peteaini akali tupana muni yaini tupa minu gae loto, utupanena tepolo toko tupa kulembo lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wuane piyu, balato wandakali eka uya makesa yo ateaini tupa lamawuato, yakamato namba Ayianena anda oko mo lawa puato, makesa anda mindi gulaya naene kondalapa. Eka uya utupa awua pulupa lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Balato wuane peanga andoto, balana disaipolo tupamane Gotena pii pepa pelene eya mindi nembo tolo-peke loto, nimbana anda oko kuai lo ateakale loto, nambato piape taimane pua atolowa-kola, akali minditupa-mane namba minu koyolo-peyai layene eya lo nembo teai. ");
INSERT INTO ipi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jisasato minditaka makesa yo peteaini wandakali tupa peyo wateanga andoto, Juta yamena akali kawane tupamane bala tipa puato, Goteto nimba languato, piape oko pipe lea-kola, nimbato wuane pua ateyo lo nanima andawa loyale, nimbato metekolo piape andoko pulape leai. ");
INSERT INTO ipi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wuane leai-kola, Jisasato pii kokoli mindi utupane lamawuato, yakamato lotu anda oko lai lo apolai-kola, ole tepo angu pola-kola, nambato anda oko pulu-peke lolo-peyawa lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wuane lea-kola, Juta yamena akali kawane tupamane bala andayo lamba loto, nanimana yumbane tupamane lotu anda andane oko pua angu ateai-kola, mali paiyasa tukumindinga wataka peane tekeko, nimbato ole tepo angu tupana anda oko katulo pulu-peke lolo-peyawa lelepe leai. ");
INSERT INTO ipi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Utupane-mane wuane leaini tekeko, Juta yame-mane bala peyo ome lolai-kola, ole tepo angu pola-kola, malinga ika lokale nembo toto, Jisasato pii kokoli mindi utupane lamawuato, yakamato lotu anda oko lai lo apolai-kola, ole tepo angu pola-kola, nambato anda oko pulu-peke lolo-peyawa lea. ");
INSERT INTO ipi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Matili Goteto Jisasa malinga ika laya yane okone angi, balana disaipolo tupamane balana pii okone nembo tolo-peke loto, pii Jisasato wamba leane okonepi, Gotena pii pepa pelene eya tupapi, utupane bilipi leai. ");
INSERT INTO ipi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Juta yame wandakali tupa Pasopa tomo nalaini oto oko epeane okone angi, Jisasa bala Jutusaleme atoto, metekolo piape minditupa pua atea-kola, wandakali kambua-mane andoto, bala lo bilipi leai. ");
INSERT INTO ipi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Wuane tekeko, Jisasato wandakali tupa pitakana nembo-tene oko andalane. Tene okonena, wandakali mindimane bala lamawuato, wandakali utupa-mane nimbana metekolo piape tupa angu andoto, nimba lo bilipi leyai lo lamaulane tene mindi ata napeya. Jia. Bala tane-mane wandakali pitakana mana tupa andoto, wandakali utupane-mane bala lo bilipi leyama nayu naleai nembo toto, utupanenga tungi peyo ata napea. ");
INSERT INTO ipi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Patasai yamena akali Neketomasa lene mindi bala Juta yamena akali kawane mindi ateaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Utulu akali okone bala Jisasa peteanga epoto, tisa, Gote bala wandakali mindi towa ata napeando, wandakali okonemane metekolo piape nimbato pilini okonepene tupa katulo napulu-peya. Tene okonena, nanimato andeyama-kola, Goteto nimba tisa piape pulu puu leane ya lo nembo teyama leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nambato pii enene wete mindi nimba langeyo. Wandakali mindi bala mandulu-peke lene gulo ata napeando, Goteto bala moyo ando ateya lo balato katulo anda napulu-peya leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Wuane lea-kola, Neketomasato bala tipa puato, anu puato, wandakali mini-yene mindi bala katulo anginina ini anda-pangosa pitulu-peke lola-kola, angini-mane bala dee lapone mandulu-peke lolo-peyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Wuane lea-kola, Jisasato balana pii okone yano peyoto, wandakali-mane andopane mindi mandeya-kola, andopane okone bala wandakali atalane leaipia. Oli Sipitisa okomane wandakali mindi mandulu-peke leya-kola, wandakali okone bala Gotena yame ateya nembo toto, nambato pii enene wete mindi nimba langeyo. Goteto wandakali mindi ipa okola, Oli Sipitisa okola, okonelapo-mane mandulu-peke naleando, wandakali okone bala katulo Gotena yame ata napulu-peya. ");
INSERT INTO ipi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nambato nimba mandulu-peke lene gulo atape-pene leyo okonena, nimba moko nalape. ");
INSERT INTO ipi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Popo lalane oko bala tane popo lo awua pokale nembo tolane pua popo lo awua mindisa puku piyane. Popo leya-kola, nimbato ale alene tekeko, ukusa ato lo awua epeyape, dee, popo lo awua poto, aninga koyo pulu-peyape lo nimbato nembo natelene. Wuane pua teke, Oli Sipitisa okomane wandakali mindi mandulu-peke lokale nembo toto, okone mandulu-peke leya-kola, wandakali okone mandulu-peke lene gulo atalane tekeko, Oli Sipitisa okomane anu puato wandakali mindi mandulu-peke leyape lo nimbato nembo natalene leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wuane lea-kola, Neketomasato bala tipa puato, anu puato, mangene nimbato lele utupane katulo wuane pulu-peyape leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Wuane lea-kola, Jisasato balana pii okone yano peyoto, nimba Isatale tanena tisa atele-ko. Anu peakale nimbato pii okone katulo yano peya napelepe. ");
INSERT INTO ipi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nambato pii enene wete mindi nimba langeyo. Nanimato minditaka lee-mane andemane tupa wayumane nembo toto, yakama Patasai tupa langeyama tekeko, yakamato nanimana pii okone ale wato, enene pii leyai nembo taa na-piyaini. ");
INSERT INTO ipi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","13","Yuunga wandakali mindikipi mindi ati kenga pulu, yuunga peke nalea. Jia. Ati kenga atala yuunga epewane Akalina Iwanane nambato angu ati kenga mangene piyane tupa katulo yakama langiyawane. Wuane tekeko, yuu okona mangene piyaini tupa nambato yakama langiwa-kola, yakamato nambana pii okone ale wato, enene leya nembo natapiai-ko. Gote bala ati kenga atoto, mangene minditupa wua peya loto, nambato yakama langewando, nambato enene leya lo yakamato anu puato nembo tolopeyaipe. ");
INSERT INTO ipi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Wamba Isatale tane wandakali tupa oma napeakale nembo toto, Mosesa bala utupane towa atu wandakali napalene yuu okona atoto, etelu gulene mindi batasa-mane waa peaipia. Waa piyu, balato ita mindi yokowa peyata wato, etulu okone ita okonena peyo yuka yaepia. Wuane pua teke, Akalina Iwanane oko lo bilipi lolai wandakali tupa pitaka saka atapowa ateakale nembo toto, Goteto Akalina Iwanane oko ita malamanda okona peyo yuka wato, minaiyu lape-pene leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","17","Wamba Gotena iwanane okone ati kenga atea-kola, Goteto bala yuunga epeakale loto, wandakali tupa yapa lo tale peakale naleaipia. Jia. Balana iwanane okonemane wandakali tupa molo-peke leakale loto, Goteto bala yuunga epeakale leaipia-ko. Goteto wandakali tupa pitaka epelewa yamapane yo atoto, balana iwanane okone lo bilipi lolai wandakali tupa alu napene, pitaka saka atapowa ateakale nembo toto, balana iwanane mindiki oko angu epeakale leane. ");
INSERT INTO ipi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Balana iwanane okone lo bilipi lene wandakali tupanga Goteto koo tene mindi yata na-alane tekeko, wandakali waka tupamane balana iwanane mindiki angu oko lo bilipi na-lalaini mambele, Goteto utupane yapa lo tale puato, koo tene tupa utupanenga yata alane. ");
INSERT INTO ipi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","21","Goteto balana pii enene oko wato minalaini wandakali tupa minu tai laya eya-kola, utupane-mane balana piape piyaini. Wandakali waka tupamane okone andeakale nembo toto, Gotena wandakali utupane tii-pene okona epoto, piape piyaini tekeko, wandakali waka minditupa-mane mana koo tupa minu ateyai-kola, tii-pene okonemane utupanena mana koo tupa mo pana alane. Mo pana olane nembo toto, wandakali utupane pitaka-mane tii-pene okone embo wete wato, tii-pene okonena na-epalaini. Jia. Gotena tii-pene okone ati kenga atala yuunga epea-kola, utupane-mane tii-pene okone epele naene, undupi-lene oko epele wete alaini nembo toto, Goteto utupane yapa lo tale puato, koo tene mindi utupanenga yata alane. ");
INSERT INTO ipi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Matili Jisasapi, balana disaipolo tupapi, utupane Jutiya disitiki okona po atoto, wandakali tupa ipa peya-maiki pua ateai. ");
INSERT INTO ipi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Okone angi, Etoteto Jone andi laa napenenga, Jonetopi wandakali tupa ipa mia-maiki pua ateaipia. Salima yuu mandaka gulo Ainone yuu okona ipa kambua epo palane nembo toto, bala yuu okonena atoto, wandakali ipuku peaini tupa ipa peya-maiki pua ateaipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ipa peya-maiki pua atea-kola, Jonena disaipolo tupamane Juta yame akali mindi towa pii yanda puato, Gotena wenonga kalato ata napene atamakale nembo toto, wandakali-mane anu puato, wasa-wasa peyape-penepe leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wuane lalu, utupane-mane Jone ateanga poto, bala lamawuato, tisa, wamba akali mindi nimba towa atu ipa Jotane amo yangi ateapi-angi, nimbato bala ati kenga atala yuunga epeane lee okoni. Andipa balato wandakali ipa peya-mawua ateya-kola, wandakali tupa pitaka nimba tepa alu, bala ateyanga peyai okonde leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","28","Wuane leai-kola, Joneto utupanena pii okone yano peyoto, wamba namba Mesaya oko jia lewa. Wuane tekeko, Goteto namba languato, Mesaya oko bala epoyale peya loto, nimbato wandakali tupa wamba ini lamalu puu leane lewa okone yakamato ale yai okoni leaipia. Ati kenga ateya Gote okomane minditaka mindi wandakali mindinga mai napeando, wandakali okonemane minditaka okone katulo mia napulu-peya. Wuane pua teke, Goteto wandakali utupane Jisasa ateyanga peakale nalapia-yale, utupane-mane bala ateyainga napupiai-yale. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Akali mindimane wanda mindi kee leya-kola, wanda okone balana wetene gulo pitiyane. Akali okonemane wanda okone kee leyo nembo toto, pii leya-kola, akali okonena amene okomane balana pii okone ale wato, epele alane. Wuane pua teke, sosa oko Jisasana wetene gulo pitiyane. Bala lo bilipi lene wandakali tupa balana yame gulo peteyai nembo toto, balato pii leya-kola, nambato balana pii okone ale wato, epele wete eyo. ");
INSERT INTO ipi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Akali okone bala lipinga wete atola-kola, namba balana pangosa atape-pene. ");
INSERT INTO ipi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yuu okona akali mindimane yuu okona mangene piyaini tupa nembo toto, pii lalane. Ati kenga atala yuunga epeane akali oko bala yuu okona wandakali tupa pitaka sia minuto, utupanena lipinga wete ateya. ");
INSERT INTO ipi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wamba bala ati kenga atoto, minditaka andeane tupapi, pii ale yane tupapi, utupane wandakali tupa lamaiyane tekeko, wandakali-mane balana pii okone ale wato, bilipi na-lalaini. ");
INSERT INTO ipi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","35","Ayiane Gote okomane balana iwanane oko towa epelewa yamapane yo atoto, wandakalipi, waka minditaka eya tupapi, utupane pitaka balana kininga yata yaepia. Dee, Goteto balana Oli Sipitisa oko yapu loto, yangisa angu wandakali mindi mai napeaipia. Goteto Oli Sipitisa oko Jisasanga tumbi laya wato, yuunga puu lea-kola, Jisasato Gotena pii oko wandakali tupa lamaiki piyane. Wandakali-mane balana pii okone ale wato, bilipi lalaini mana okomane Goteto enene pii lalane lo andawa lalaini. ");
INSERT INTO ipi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gotena Iwanane oko lo bilipi lene wandakali tupa saka atapowa atolopeyai tekeko, balana pii oko wato mina na-piyaini wandakali tupa saka atapowa ata napulu-peyai. Jia. Gotena yataka ene oko wandakali utupanenga yapowa yolopeya. Ipa peya-maiyane akali Joneto wuane leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jisasa bala tane-mane wandakali tupa ipa peya-mai napeaipia. Jia. Balana disaipolo tupamane wandakali tupa ipa peya-mawua ateaini tekeko, wandakali-mane loto, Jisasato Jone sia minuto, wandakali kambua ipa peya-mawua ateya-kola, utupane balana disaipolo tupa ateyai leainipia. Wandakali-mane wuane leaini okone Patasai tupamane ale apiai nembo toto, Jisasa bala Jutiya disitiki oko tepa alu, Galili disitiki okona peke loyale pea. ");
INSERT INTO ipi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galili disitiki okona peke loyale asini oko Samatiya disitiki okona tombenenga yene. ");
INSERT INTO ipi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jisasa bala asini okone watama poto, Samatiya disitiki tano Saika lene okona peakaiyu lea. Tano okone bala yuu mindi wamba Jekopoto balana iwanane Josepe mayane okona mandaka gulo ya. ");
INSERT INTO ipi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wamba Jekopoto yuu okonena atoto, ipa ambuyale, ipa yuli mindi tombo yaepia. Tualo kilokopi mindi lea-kola, Jisasa bala asini epeane okomane balana umbaini oko tai nalea-kola, ipa yuli tomba-yene petene ongane mandaka petea. ");
INSERT INTO ipi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Balana disaipolo tupa tomo kamboyale tanonga peai-kola, Samatiya disitiki okona tane wanda mindi ipa ambulu epeaipia. Epea-kola, Jisasato bala lamawuato, ipa nokale. Ambu gii leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jisasato wuane leane tekeko, Juta yame wandakali tupamane Samatiya yame wandakali tupa towa atu mangene mindikipi mindi na-piyainipia. Tene okonena, Samatiya yame wanda okonemane Jisasana pii okone yano peyoto, anu peakale Juta yame akali nimbato Samatiya yame wanda namba andoto teke, ipa nokale, ambu gii lelepe leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wuane lea-kola, Jisasato balana pii okone yano peyoto, Goteto minditaka epene mindi mee giyane oko nimbato andapi-yale, ipa nokale ambu gii leyo akali oko api ateyape lo nimbato nembo tapi-yale. Okone nembo toto, nimbato wandakali saka atapowa ateakale lo ataya alane ipa oko gii lo tee lapi-yale, nambato okone nimba giwa-yale leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wuane lea-kola, wanda okonemane bala lamawuato, Akali Andane, ipa yuli oko nenanga wete tomba-yene eya leaipia. Yuli okonena ipa ambuyale pene mindi nimbato ai napele-ko. Wandakali saka atapowa ateakale lo ataya alane ipa okone aninga ambulape. ");
INSERT INTO ipi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wamba nanimana yumbane Jekopoto ipa kundu oko tomboto, bala tane ipa ambu naka puato, balana bulumako tupapi, sipisipi tupapi, iwanane tupapi, utupane-mane ipa oko neakale lo ambu maiki peaipia. Balato ipa kundu oko nanima geane-ko. Nimbato bala sia minuto, wandakali saka atapowa ateakale lo ataya alane ipa okone katulo namba gulape leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wuane lea-kola, Jisasato balana pii okone yano peyoto, ipa kundu okona nolai wandakali tupa pitaka lapone ipa nono olopeyai leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wuane tekeko, nambato ipa mindi wandakali maluwa tupanga ipa lai yungalane pua epoto, wandakali utupane saka atapowa ateakale lo ataya olopeya leaipia. Utupane-mane ipa okone nalu, matili-matilipi dee lapone ipa nono na-olopeyai. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wuane lea-kola, wanda okonemane bala lamawuato, Akali Andane, namba dee lapone ipa nono wato, ipa ambulu-peke na-lokalenga, nimbato ipa okone namba gii leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wuane lea-kola, Jisasato bala lamawuato, nimbana akalini oko epeakalenga, nimbato bala lamaulu pulu, bala towa atu onga peke lalapape leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Wuane lea-kola, wanda okonemane bala lamawuato, nambana akalini mindi ata napene leaipia. Wuane lea-kola, Jisasato bala lamawuato, nimbato enene pii lele leaipia. Wamba nimba akali yau tupana puku piyu, utupane pitaka tepa aka piki pee okoni. Andipa akali nimba towa atu peteyapi okone nimbana akalini jia-ko. Nimbana akalini mindi ata napeya lele okone enene pii lele leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wuane lea-kola, wanda okonemane bala lamawuato, Akali Andane, nambato nimba potopisa akali mindi atele lo andeyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Samatiya yame wandakali nanimana yumbane tupamane yuu wangiane okona epo amunguli puato, Gote lo lotu laka peaini tekeko, Juta yame wandakali yakamato loto, wandakali pitaka-mane Jutusaleme okona angu amunguli puato, Gote lo lotu lape-pene lalaini leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wuane lea-kola, Jisasato bala lamawuato, nambato pii nimba langeyo oko enene leya lo wanda nimbato nembo tape leaipia. Matili Samatiya yame wandakali yakamato yuu wangiane okonapi, Jutusaleme tano okonapi, yuu okone-lapona angu atoto, Ayiane Gote oko lo lotu nalolo-peyai. Jia. Yakamato yuu waka tupanapi atoto, bala lo lotu lolopeyai. ");
INSERT INTO ipi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Juta yame nanimana akali mindimane wandakali tupa molo-peke lolopeya. Tene okonena, nanimato Gotena pii pepa pelene eya tupa pitaka dii lo andoto, mangene Goteto wamba peane tupapi, matili pulupeya tupapi, utupane nembo toto, bala lo lotu lalamane. Samatiya yame wandakali yakamato okonetaka tupa nembo natene, bala lo lotu lalaini. ");
INSERT INTO ipi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Wuane tekeko, Gote bala sipitisa mindi ateya okonena, balana Oli Sipitisa okomane wandakali minu tai laya ola-kola, utupane-mane Gotena pii enene oko wato minuto, bala lo lotu lape-pene. Wandakali okonepene tupamane bala lo lotu lapiai lakae lo Ayiane Gote okomane nembo talane. Tene okonena, oto mindi epola-angi, Oli Sipitisa okomane lotu enene lalaini wandakali tupa minu tai laya ola-kola, utupane-mane Gotena pii enene oko wato minuto, bala lo lotu lolopeyai. Oto okone andipa epo eya leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wuane lea-kola, wanda okonemane bala lamawuato, nambato Mesaya, balana gene okone Gitiki pii mopeke loto, Kataisa lalaini oko epolopeya nembo teyo. Bala epola-angi, balato pitaka taka nanima langulu-peya leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Wuane lea-kola, Jisasato bala lamawuato, nimba towa pii leyapa akali namba Mesaya okone ateyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wuane lea-kola, balana disaipolo tupa epoto, bala wanda okone towa pii lo peteapele yanga andoto, moko wete loto, nembo kambua teai. Minditupa-mane anu peakale balato wanda oko towa pii lo pitiyape nembo teai. Minditupa-mane aki mindi mokale nembo toto, bala wanda oko towa pii lo pitiyape nembo teaini tekeko, disaipolo utupanena mindikipi mindimane bala tipa puato, anu peakale nimbato Samatiya wanda oko towa pii lelepe lopi, nimbato aki mokale nembo toto, bala towa pii lelepe lopi, naleai. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jisasato namba Mesaya oko ateyo leane okonena, wanda okonemane balana ipa pene oko ongane yakale lalu, tano okona peke loto, wandakali tupa lamai-yaepia. ");
INSERT INTO ipi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Balato utupane lamawuato, akali mindimane mangene nambato wamba pewane tupa pitaka langi yiake lala leaipia. Bala Mesaya oko ateyape. Yakamato bala andolo ipulupa leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wuane lea-kola, wandakali utupane tano okone tepa alu, Jisasa ateanga epoyale epeainipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wandakali utupane Jisasa ateanga epo ata nayai-kola, balana disaipolo tupamane bala lamawuato, tisa, nimba tomo naa-kae laka peai. ");
INSERT INTO ipi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wuane laka peai-kola, Jisasato utupane lamawuato, namba tomo nolane eya tupa yakamato anda napeyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wuane lea-kola, balana disaipolo tupamane yakama teke-teke pii mindi tipa piki puato, wandakali mindimane tomo mindi awua epoto, bala maiyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wuane leai-kola, Jisasato utupane lamawuato, nambato piape mindi pula nembo toto, Goteto namba puu leane lea. Balato nembo teya pua, nambato piape okone pikoyo pipe-pene okone nambana tomo nolane oko guleya. ");
INSERT INTO ipi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","38","Wandakali-mane pii kokoli mindi loto, akali mindimane eenga tomo waini yandeya-kola, akali waka mindimane tomo mandiyane lalaini. Wuane pua teke, wamba wandakali waka minditupa-mane eenga tomo waini tupa yandeai-kola, nambato yakama ee okonena tomo mandulu pululpa lewa. Wuane lewa-kola, yakamato ee okonena poto, tomo yakamato yanda napeai tupa mandeai okonemane pii kokoli layene okone enene gulea. Tomo waini yandalane wandakali okola, tomo mandiyane wandakali okola, okonelapo lapotaka epele yakale nembo toto, andipa tomo mandiyane akali okomane wandakali saka atapowa ateakale lo ataya olane tomo oko manduto, yole meya. Yakamato pii waka mindi lalaini oko loto, wandakali mindimane ee mindi yandola-angi, ana tukumindi pola-kola, tomo tupa mandipe-pene yolopeya lalaini tekeko, ee tupana tomo mandipe-pene eya oko andalapa lo nambato yakama langeyo lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Balato wuane lea-angi, utupane-mane andeai-kola, Samatiya disitiki okona tane wandakali kambua bala atea okona epeainga andeai. Wamba Samatiya yame wanda oko bala Saika tano okona poto, akali mindimane mangene nambato wamba pewane tupa pitaka langi yiake lea-kola, Samatiya yame wandakali kambua utupane-mane Jisasa lo bilipi leai. Bilipi loto, bala ateanga epoto, bala yakama towa atu atamakale lo tee leai-kola, bala ole lapo yuu okonena atea. ");
INSERT INTO ipi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yuu okonena atoto, balato pii minditupa utupane lamaiya-kola, Samatiya yame wandakali waka kambua minditupa-mane balana pii utupane ale wato, bala lo bilipi leai. ");
INSERT INTO ipi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bilipi loto, utupane-mane wanda oko lamawuato, wamba nanimato nimbana pii oko ale wato, bala lo bilipi lalama tekeko, andipa nanima tane balana pii oko ale wato, enene bala yuu okona wandakali tupa molo-peke lolane akali oko ateya lo andeyama leai. ");
INSERT INTO ipi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Wamba Jisasa bala tane pii mindi loto, potopisa akali mindi balana yuu tene okona ateando, balana yuu tene okona atalaini wandakali tupamane balana gene oko laiyu na-lalaini leaipia. Pii okone nembo toto, Jisasa bala Galili disitiki okona pea. ");
INSERT INTO ipi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wamba Juta yame wandakali tupamane Pasopa tomo neaini okone angi, Jisasa bala Jutusaleme atoto, metekolo piape minditupa pea. Okone angi, Galili disitiki tane wandakali minditupa-mane Pasopa tomo okone nolo poto, metekolo piape utupane pitaka andeai. Tene okonena, Jisasa bala Galili disitiki okona peakaiyu lea-angi, Galili tane wandakali utupane-mane bala wayu epeleya lo lameai. ");
INSERT INTO ipi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Lameai-kola, bala Galili disitiki tano Kena okona lapone pea. Wamba bala tano okonena atoto, ipa enene oko mo waene gulaya yane. Jisasa bala Kena tano okonena lapone peane okone angi, gapomane akali kawane mindina iwanane oko Kapaneame tano okona siki oma-yene ya. ");
INSERT INTO ipi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Balana iwanane okone omoyale pea wete, akali okonemane ale ya-kola, Jisasa bala Jutiya disitiki oko tepa alu, Galili disitiki okona epeya lene oko ale yaepia. Ale wato, bala Jisasa ateanga poto, nambana iwanane oko mo atu yolanga, nimba Kapaneame tano okona puu nena lamape lo tee lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wuane lea-kola, Jisasato bala lamawuato, wandakali yakamato nambana metekolo piapepi, kokoli piapepi, utupane anda napeaindo, yakamato namba lo bilipi nalolo-peyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wuane lea-kola, gapomane akali okonemane bala lamawuato, Akali Andane, nambana iwanane oko omolane. Nimba wamba ini puu nena laa lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wuane lea-kola, Jisasato bala lamawuato, nimbana iwanane okone saka pitulu-peyako. Nimba puu lea. Wuane lea-kola, Jisasato pii enene leya lo bilipi loto, akali okone bala andaka peke lea. ");
INSERT INTO ipi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bala peke loto, Kapaneame tano okona peakaiyu lata naeya-kola, balana piape akali tupamane bala asininga malanda wato, nimbana iwanane oko atu yoto, saka peteya leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wuane leai-kola, balato utupane tipa puato, taeme aki-tupi lapia-kola, bala atu yoto, saka pupiape leaipia. Wuane lea-kola, utupane-mane bala lamawuato, tuni otonga taeme wane kiloko lapia-kola, balana umbaininga toto pipiane oko atu yapia leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Wuane leai-kola, ayiane okonemane nembo tolo-peke loto, tuni otonga taeme mindiki okonena teke lapia-kola, Jisasato nimbana iwanane oko saka pitulu-peya lapia nembo teaipia. Wuane nembo toto, akali okonepi, balana andaka atalaini yamepi, utupane pitaka-mane Jisasa lo bilipi leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jisasa bala Jutiya disitiki oko tepa alu, Galili disitiki okona epo atoto, metekolo piape lapone okone pea. ");
INSERT INTO ipi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Matili Juta yame wandakali tupamane lotu andane mindi lalaini oto oko epoyale pea-kola, Jisasa balana disaipolo tupa towa atu Jutusaleme peai. ");
INSERT INTO ipi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jutusaleme tano okona ende ana-mane pitane atene mindina asia lomba andane oko Sipisipi Asia Lomba lalaini. Asia lomba andane okonena mandaka ipa angini aŋako mindi pitiyane. Iputu pii loto, ipa angini okonena gene oko Betesata lalaini. Ipa angini okonena matenenga anda aiyakame yau pitane atalane. ");
INSERT INTO ipi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Anda aiyakame yau utupane ongane ateyai-kola, wandakali lee koopi, kee koopi, papaka tambupi, siki pelene wandakali kambua tupa anda utupanena yalaini. ");
INSERT INTO ipi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Eyai-kola, ole minditupana Akali Andane okona enjole mindi ipuku puato, ipa angini okone mo ema piya yaka piyaepia. Wuane piki pea-angi, wandakali siki pelene utupanena mindi bala wamba ini ingane ipa angini okonena poto peteya-kola, wandakali okonena siki tupa atu yaka piyaepia. Tene okonena, wandakali siki pelene tupa anda aiyakame yau utupanena pituto, enjole okonemane ipa angini okone mo ema piya yakale lo maliyo pitiyaini-pia. ");
INSERT INTO ipi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Akali maliyo ateaini utupanena mindi bala mali paiyasa teponga dee kitupasa siki angu omo yaepia. ");
INSERT INTO ipi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisasato andea-kola, akali okone bala wamba wete siki omo yene yane ya lo andoto, bala tipa puato, nimbana siki oko atu yapia lakae lo nembo telepe lea. ");
INSERT INTO ipi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wuane lea-kola, akali siki oma yene yane okomane balana pii okone yano peyoto, Akali Andane, ipa oko mo ema piki piyane tekeko, namba mo awua ipa okona polane akali mindi ata napeya. Tene okonena, namba tane ipa okona poyale tengamane peyo-kola, wandakali waka tupamane namba wata peke lalu, yakama wamba ini ingane ipa angini okona palaini lea. ");
INSERT INTO ipi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wuane lea-kola, Jisasato bala lamawuato, nimba ika lalu, nimbana pangilini toko oko mo awua puu lea. ");
INSERT INTO ipi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wuane lea-kola, wamba ini kapoyale okone angi teke, akali okonena siki oko atu ya-kola, bala paliyane toko okone mo awua pea. Sambasa mindina balato wuane pea. ");
INSERT INTO ipi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wuane pea-kola, Juta yame akali minditupa-mane akali wamba siki yane okone lamawuato, andipa Sambasa angi, nimba pangilini toko oko mo awua napupe-pene leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wuane leai-kola, akali okonemane utupanena pii okone yano peyoto, nambana siki mo atu yala akali okomane namba languato, nimba pangilini toko oko mo awua puu lala-kola, awua peyo leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wuane lea-kola, utupane-mane bala tipa puato, akali andoko-mane nimba languato, nimbana pangilini toko oko mo awua puu lalape leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Utupane-mane wuane leaini tekeko, wandakali kambua epo amunguli peai-kola, Jisasa bala tengamane too pua pea. Bala too pua pea-kola, akali wamba siki oma yene yane okonemane balana siki oko mo atu yapiane akali oko nembo nateaipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Matili akali okone bala lotu anda andane okona ende anda-pangosa atea-kola, Jisasato bala aiya pua andoto, nimbana siki oko atu yapia lo andele leaipia. Nimbato mana koo tupa minu ateendo, nimbanga kenda-pene andane wete mindi epolane. Nimbato mana koo tupa dee lapone mina napene kondape lea. ");
INSERT INTO ipi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wuane lea-kola, akali okone bala Juta yame akali tupa ateainga poto, utupane lamawuato, nambana siki mo atu yapiane akali okone bala Jisasa leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wuane lea-kola, Sambasa angi Jisasato akali okone mo atu yane nembo toto, Juta yame akali utupane-mane kenda-pene andane minditupa bala maiki peainipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wuane piki pua ateai-kola, Jisasato utupane lamawuato, namba Ayiane okomane ole dindi lo piape piyane okonena, nambatopi ole dindi lo piape piyawane leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wuane lea-kola, Juta yame akali utupane-mane ale wato, Jisasato Gote balana Ayiane wetete ateya leya okonemane bala tane Gote ateya okonepene teke ateyo leya nembo teainipia. Dee, Sambasa angi Jisasato akali okone mo atu yane okomane Sambasa okona loo oko kalo peya lo andeaini tekepia. Tene okone-lapona, Juta yame wandakali tupamane Jisasa peyo ome laima lakae lo nembo teainipia. ");
INSERT INTO ipi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","23","Juta yame akali tupamane Jisasa peyo ome laima lakae lo nembo teai-kola, Jisasato utupane lamawuato, Gote Iwanane okona gene oko laiyu na-lalaini wandakali tupamane bala epeakale leane Ayiane okona gene oko laiyu naleya-kola teke, piyane leaipia. Ayiane Gote okomane wandakali mindi yapa lo tale napiyane. Jia. Wandakali-mane Ayiane okona gene oko laiyu lalaini pua teke, utupane pitaka-mane balana Iwanane okona gene oko laiyu leakale nembo toto, Ayiane Goteto wandakali yapa lo tale pulane piape okone pitaka bala iwanane okonga mayane. Maya-kola, Ayiane okomane wandakali omene tupa malinga ika laya wato, saka atapowa ateakale lo ataya alane pua teke, balana Iwanane okomane wandakali minditupa saka atapowa ateakale lo ataya wakale nayuto, utupane saka atapowa ateakale lo ataya alane. Ayiane okomane balana Iwanane oko epelewa yamapane yo atoto, balato piape piyane tupa pitaka balanga andawa lalane. Yakamato moko loto, nembo kambua talapale nayuto, Goteto balana piape utupane pitaka sia minene piape andane wete tupa balana iwanane okonga andawa lolopeya. Andawa leya-kola, Ayiane okomane piape piyane utupane balana iwanane okomane piyane teke. Nambato pii enene wete mindi yakama langeyo. Iwanane okomane bala tanena nembo-tene oko wato minuto, mangene mindi katulo napiyane. Jia. Balana Ayiane okomane mangene piyane tupa iwanane okomane andoto, wuane teke piyane. ");
INSERT INTO ipi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nambato pii enene wete mindi yakama langeyo. Wandakali mindimane nambana pii oko ale wato, namba ati kenga atala yuunga puu leane Ayiane Gote oko lo bilipi leaindo, Goteto wandakali okone yapa lo tale napulu-peya. Jia. Wandakali okone bala omene gulalane mana oko tepa alu, saka atene tene mialu, matilipi saka atapowa atolopeya. ");
INSERT INTO ipi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","27","Nambato pii enene wete mindi yakama langeyo. Ayiane Gote okomane balana iwanane oko Akalina Iwanane ateya nembo toto, wandakali yapa lo tale pulane tai-lene oko balanga mayaepia. Dee, wandakali saka atapowa ateakale lo ataya alane tai-lene oko Ayiane Gote bala tanenga yalane pua teke, Ayiane okomane wandakali saka atapowa ateakale lo ataya alane tai-lene oko balana iwananenga mayaepia. Tene okonena, namba lo bilipi nalene wandakali omene gulo atalaini tupamane Gote Iwanane okona pii oko ale olane oto oko andipa epo eya. Pii okone bilipi lolai wandakali tupa, saka atapowa atolopeyai leyo. ");
INSERT INTO ipi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nambato wuane leyo okonena, yakamato moko loto, nembo kambua na-talapape. Jia. Matili oto mindi epola-angi, Gote Iwanane okomane wandakali omene malinga paleyai tupa lamawuato, ika lalapa lola-kola, utupane pitaka-mane balana pii okone ale olopeyai. ");
INSERT INTO ipi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ale wato, utupane yakamana mali tupa tepa alu, ika loto, takita epolopeyai. Mana epene tupa minu atalu, omolaini wandakali tupa ika loto, saka atapowa atolopeyai. Koo pua atalu, omolaini wandakali tupa malinga ika lolai-kola, nambato utupane yapa lo tale puato, koyakale lolo-peyawa. ");
INSERT INTO ipi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Namba tane-mane nembo teyo pua pukale nembo natalawane. Jia. Namba ati kenga atala yuunga puu leane Ayiane okomane piape pula nembo teya pua nambato pukale nembo talawane. Wuaneko, namba tane wua pukale nembo toto, mangene mindi na-piyawane. Jia. Nambana Ayiane okomane wandakali tupa yapa lo tale pipe leya pua, nambato wandakali tupa tika pua yapa lo tale piyawane. ");
INSERT INTO ipi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Namba tane Gote Iwanane ateyo lewando, wandakali-mane nambana pii angu ale wato, nambato enene pii leyape, owato pii leyape lo tatake olopeyai. ");
INSERT INTO ipi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","35","Wuane tekeko, wamba yakamato akali minditupa ipa peya-maiyane akali Jone oko bala ateanga peakale leai-kola, Jone bala lamu kaiyapiane mindi gulo atoto, yakamana nembo-tene tupa tii piya yaepia. Balato enene pii oko loto, namba andayo, bala Gote Iwanane ateya lo yakama langea-kola, ole ukupini mindilapo angu yakamato balana pii oko ale wato, epelewa ateainipia. Yuunga akali mindimane namba Gote Iwanane ateya leandopi, naleandopi, okone angini mindi jia tekeko, Goteto yakama molo-peke lapia lakae lo nembo toto, nambato pii utupane leyo. Ayiane Gote okomane namba balana Iwanane atele leya-kola, nambato balana pii okone enene ya lo nembo teyo. ");
INSERT INTO ipi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Joneto namba Gote Iwanane ateya leane tekeko, Ayiane Goteto piape minditupa namba guato, utupane pikoyo pipe leane. Wuane lea-kola, nambato piape utupane pua ateyo okonemane Jonena pii sia minuto, Goteto namba languato, piape utupane pulu puu leane lo andawa leya. ");
INSERT INTO ipi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Alu mindikipi mindi yakamato Gote lee-mane anda napene ato, balana pii oko ale-mane ale nayai. Jia. Namba piape pulu puu leane Ayiane Goteto namba balana Iwanane ateya leane tekeko, yakamato namba balana Iwanane ateya lo bilipi naleai-kola, Gotena pii oko yakamanga yaa napeya. ");
INSERT INTO ipi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gotena pii pepa pelene eya okomane wandakali saka atapowa atolane asini oko yakamanga andawa lolopeya nembo toto, yakamato Gotena pii utupane dii lo andoto, aki leyape lo andalaini. Gotena pii utupane-mane namba Gote Iwanane ateya lo langiyaini. ");
INSERT INTO ipi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wuane tekeko, yakamato nambanga saka atapowa atene yalane oko molo ipumakale nembo natalaini. ");
INSERT INTO ipi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wandakali-mane nambana gene oko laiyu leakale loto, namba na-epewane. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","43","Ayiane Goteto namba languato, nambana pii oko wandakali tupa lamaulu puu lea-kola, nambato balana pii yakama langulu epewane. Nambato balana pii tupa yakama langiyawane tekeko, yakamato pii okone enene ya lo bilipi na-lalaini. Wuaneko, nambato yakamana mana okone andoto, yakamato Gote epelewa yamapane yo ata na-piyaini ya lo andeyo. Wandakali waka mindi bala tanena pii oko yakama langulu epeando, yakamato balana pii lola tupa ale wato, balana pii okone enene ya lo bilipi nalolo-peyai. ");
INSERT INTO ipi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wandakali yangone tupamane yakamana gene tupa laiyu lapiai lakae lo yakamato nembo talaini tekeko, Gote mindiki angu okomane yakamana gene tupa laiyu leakale lo yakamato nembo natalaini-ko. Anu puato, yakamato katulo namba Gote Iwanane ateya lo bilipi lolo-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yakamato namba Gote Iwanane ateya lo bilipi nalolai okonena, nambato Ayiane Gote okona wenonga atoto, yakama kosimi lolopeya nembo na-talapape. Jia. Mosesato yakama moyolo-peya lo yakamato nembo teyai tekeko, Gotena wenonga atoto, Mosesato yakama kosimi loyale ateya. ");
INSERT INTO ipi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wamba balato nambana piapepi, manapi, utupane yakama languato, Gotena pii layene tupa pepa peleane tekeko, yakamato balana pii utupane bilipi naleyai-kola, balato yakama kosimi loyale ateya. Yakamato Gotena pii layene balato pepa peleane utupane bilipi leai-yale, yakamato namba lo bilipi lapiai-yale. ");
INSERT INTO ipi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wuane tekeko, Mosesato pii pepa peleane utupane yakamato bilipi naleyai-ko. Anu puato, yakamato nambana pii tupa bilipi lolo-peyaipe. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","2","Wamba Jisasato metekolo piape tupa piki puato, wandakali siki pelene tupa mo atu yaka pua atea-kola, wandakali wete kambua-mane andeai. Andalu, matili Jisasa bala Galili ipa angini gene mindi Taipi-tiasa lene okona amo yangi pea-angi, wandakali kambua wetete bala watama epeai. ");
INSERT INTO ipi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Watama epeai-kola, balana disaipolo tupa towa atu bala yuu wangiane mindina puu iyu lalu, peteai. ");
INSERT INTO ipi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Okone angi, Juta yame-mane Pasopa tomo nalaini oto oko mandaka gulea. ");
INSERT INTO ipi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisasa bala wangiane okonena pituto, wandakali kambua wetete bala peteanga epeyai oko andea. Andoto, balato Pilipi tipa puato, wandakali utupane tomo neakale nanimato betesa aninga kambamape lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisasato metekolo piape mindi puato, wandakali utupane tomo neakale mauwakale nembo toto teke, mee Pilipito bala lo bilipi leyape lo andoyale, bala minu makande puato, pii okone lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pii okone lea-kola, Pilipito balana pii okone yano peyoto, nanimato (200) tu andete kina-mane betesa kambemando, wandakali utupa mindiki-mindiki lo tomo aŋako wetete nolai-kola, katu nalolo-peya lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wuane lea-kola, Jisasana disaipolo Saimone Pita amene Endutu balato Jisasa lamawuato, wua leaipia: ");
INSERT INTO ipi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Iwana oo ateya okonga pisa lapo, bali-mane waa-pene betesa yau, utupane mandiya ya tekeko, tomo aŋako wete utupane-mane wandakali kambua wetete utupa wayumane moya napulu-peya lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yuu wangiane ongane tani kambua atea-kola, Jisasato balana disaipolo tupa lamawuato, yakamato wandakali tupa peteakale lalapa lea. Pitiyapa leai-kola, wandakali tupamane taninga peteai. Akali tupa angu dii loto, (5,000) tausene yaupi mindi peteai. ");
INSERT INTO ipi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Peteai-kola, Jisasato betesa utupane moto, Gote ando wayu pele loto, wandakali peteaini utupane neakale lo tale pua maya. Wuane pua teke, balato pisa okolapo moto, wandakali peteaini utupane neakale lo tale pua maiya-kola, wandakali utupane mindiki-mindiki lo betesa okola, pisa okola, okonelapo lapotaka yakama tane okotuma nokale nembo teaini pua moto, neai. ");
INSERT INTO ipi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wandakali utupane pitaka-mane no embo yai-kola, Jisasato balana disaipolo tupa lamawuato, tomo akanane tupa mee yoto, tamulane. Yakamato utupane mo yomo alapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wuane lea-kola, wandakali utupane-mane tomo no embo yai-kola, Jisasana disaipolo tupamane bali dini-mane waa-pene betesa yau tupana akenane yane tupa mo amunguli puato, basaketa nuu alesa tumbi laya yai. ");
INSERT INTO ipi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jisasato metekolo piape okone pea-kola, wandakali tupamane andoto, enene wete, akali oko bala potopesa akali ati kenga atala Goteto yuunga epeakale lokale leane oko ya leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Wuane lalu, bala utupanena kiŋi ateakale nembo toto, utupane-mane bala minuyale epeaini tekeko, Jisasato okone andoto, utupane awua tepa alu, bala angu yuu wangiane okonena peke lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ole lene nai andaka pea-kola, Jisasana disaipolo tupa ipa angini matene okona puu nena leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Puu nena lalu, sipi mindina peakaiyu lo pitiyu, utupane yakama ipa angini okonena amo yangi Kapaneame tano okona poyale peai. Peai-kola, yuu wamba undupi leane tekeko, Jisasa bala yakama ateainga wamba kapoyale na-epea. ");
INSERT INTO ipi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Undupi lea-angi, popo andane mindi lo awua epeane mindimane ipa oko taimane mina ika laya ya. ");
INSERT INTO ipi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jisasana disaipolo tupamane sipi okonena pitiyu, pulu lama-lama poto, kilomita yaupi, watakapi, mindi gulo peai wete, Jisasa bala ipa okona tokonga kee atama epoto, sipi okonena mandaka gulo epea. Balana disaipolo tupamane bala andoto, yama mindi ipa okona tokonga kee atama epeya nembo toto, yuku-mane omeai. ");
INSERT INTO ipi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yuku-mane omeai-kola, Jisasato utupane lamawuato, akali mindi ipa okona tokonga kee atama epeyanga yakamato andeyai oko namba Jisasa epeyo-ko. Yakama yuku naene kondalape lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wuane lea-kola, utupane-mane bala sipi okona ipupia lakae lo nembo teaini tekeko, okone angi teke utupane yakama sipinga pitiyu poyale peaini yuu okonena peakaiyu leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Wamba Akali Andane Jisasato ipa angini Galili okona amo yangi atoto, Gote ando wayu pele lalu, wandakali tupa betesa neakale maiya-kola, wandakali tupamane betesa utupane neai. Nalu, wandakali utupane yakama ipa angini matene okona atoto andeai-kola, Jisasa bala sipi mindiki yane okona peakaiyu nalea-kola, balana disaipolo tupa yakama angu sipi okonena pitiyu, peai. Sipi waka mindi ongane nayanga andeaini tekeko, anate-lene wandakali utupane-mane andeai-kola, Jisasapi, balana disaipolo tupapi, utupane yuu okonena ata napeainipia. Okone angi, sipi minditupa Taipi-tiasa tano oko tepa alu epoto, yuu ongane mandaka peakaiyu leai-kola, wandakali utupane sipi utupanena peakaiyu lo pitiyu, Jisasa aiya pima poto, Kapaneame tano okona peakaiyu leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wandakali utupane yakama sipi utupanena pitiyu, ipa angini okonena amo yangi poto, Jisasa aiya pua andoto, tisa, andoko angi nimba wali ipupipe lo bala tipa peai. ");
INSERT INTO ipi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Wuane leai-kola, Jisasato utupane lamawuato, nambato pii enene wete mindi yakama langeyo lea. Yakamato namba aiya pima epeyai tekeko, namba Mesaya oko ateyo lo yakama andawa loyale, nambato metekolo piape andane minditupa piwa tupa nembo toto, yakamato namba aiya pima naepeyei. Jia. Nambato betesa kambua yakama mee giwa-kola, yakamato no embo apiai pua, dee lapone namakale nembo toto, yakamato namba aiya pima epeyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yuu okona tomo tupa tamuto, koyalane-ko. Yakamato tomo okonepene tupa mia-makale nembo toto, piape pua ata na-piyapa. Jia. Akalina Iwanane okomane piape peakale loto, Ayiane Goteto bala ata lata yako. Akalina Iwanane okonemane yakama saka atapowa ataya olane tomo oko yakama geakale nembo toto, yakamato piape pua atalapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wuane lea-kola, utupane-mane bala tipa puato, nanimato Gotena piape tupa pua atamakale nembo toto, piape anu-pene tupa pua atamakalepe leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wuane leai-kola, balato utupanena pii okone yano peyoto, yakamato akali Goteto epeakale leane oko bilipi lo ateaindo, yakamato Gotena piape pua atolai-kola pulupeya lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Wuane lea-kola, utupane-mane bala lamawuato, Gotena pii pepa pelene eya mindimane loto, balato ati kenga tawe betesa oko wandakali tupa neakale maiyane layene eya leai. Gotena pii layene eya okonemane leya pua teke, nanimana yumbane tupa wandakali napalene yuu okona ateai okone angi, Mosesato utupane betesa mana lene oko neakale maiki pea-kola, utupane-mane betesa okone naka peainipia-ko. Goteto nimba ati kenga atala yuunga puu leane lo nanimato andalapale nembo toto, nimbato metekolo piape anu-pene mindi pulape leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wuane leai-kola, Jisasato utupane lamawuato, nambato pii enene wete mindi yakama langeyo lea. Mosesato ati kenga tawe betesa okone yakamana yumbane tupanga mai napeaipia. Jia. Nambana Ayiane okomane betesa ati kenga tawe okone yakamana yumbane tupanga mayaepia. Wuane pua teke, balato betesa ati kenga tawe enene oko yakama geya. ");
INSERT INTO ipi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ati kenga atalu, yuunga epeane betesa okonemane yuu okona wandakali tupa saka atapowa ateakale lo ataya alane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wuane lea-kola, utupane-mane bala lamawuato, Akali Andane, nimbato betesa okone ole dindi lo nanima gula leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wuane leai-kola, balato utupane lamawuato, namba wandakali saka atapowa ateakale lo ataya alane betesa okone ateyo lea. Wandakali mindi bala nambanga epola okone bala aŋakopi mindi tomo nono na-olopeya. Dee, namba lo bilipi lolane wandakali okone bala matili-matilipi ipa nono na-olopeya teke. Jia wete. ");
INSERT INTO ipi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nambato metekolo piape mindi piwa-kola, yakamato utupane andapiai lo nambato yakama langiyo tekeko, yakamato namba lo bilipi naleyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","40","Namba tane nembo tolowa pua pukale lo na-epewane. Jia. Namba ati kenga atala yuunga puu leane Ayiane okonemane nembo tola pua pukale nembo toto, namba ati kenga atalu, yuunga epewane. Wandakali minditupa-mane Gotena Iwanane oko andoto, bala lo bilipi lolai-kola, namba Ayiane okomane utupane pitaka saka atapowa atapiai lakae lo nembo teya. Namba yakama ateyainga puu leane Ayiane okonemane wandakali utupane namba lo bilipi leakale nembo toto, namba gea. Gea-kola, nambato utupanena mindikipi mindi alu peakale lo ando konda naene, yuu koyo pula-angi, utupane pitaka malinga ika laya apiai lakae lo nembo teyo. Tene okonena, namba Ayiane okonemane wandakali namba gula tupa pitaka nambanga epolai-kola, nambato utupane peyo wata napulu-peyo. Jia wete. Yuu oko koyo pula okone angi, nambato utupane malinga ika laya olopeyo. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisasato ati kenga atalu, yuunga epeane betesa oko namba lea-kola, Juta yame wandakali utupane-mane mulu-mulu leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mulu-mulu loto, utupane-mane akali oko bala Josepe iwanane Jisasa jiape leai. Nanimato balana angini, ayiane-la, okonelapo andeyamae piako. Anu puato, bala ati kenga atalu, yuunga epewane katulo leyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Wuane leai-kola, Jisasato utupane lamawuato, yakama teke-teke mulu-mulu lo ateyai oko kondalapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","46","Wamba namba Ayiane Gote oko towa atu atoto, bala andalu, yuunga epewane. Yuu okona wandakali waka mindikipi mindimane bala anda napeai. Jia. Wandakali mindikipi mindi bala tane katulo namba ateyonga na-epalaini tekeko, potopisa akali tupamane Gotena pii layene mindi pepa peyoto, Goteto wandakali tupa pitaka mana lamaulu-peya leai. Ayiane okona pii okone ale wato, mana molai wandakali tupa pitaka nambanga epolopeyai. Namba ati kenga atala yuunga puu leane Ayiane okona pii okonemane wandakali utupane kilau lo mola-kola, utupane nambanga epolopeyai. Epolai-kola, matili yuu koyo pula-angi, nambato wandakali utupane malinga ika laya olo-peyawa. ");
INSERT INTO ipi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Nambato pii enene wete mindi yakama langeyo. Wandakali saka atapowa ateakale lo ataya alane betesa oko namba ateyo-kola, namba lo bilipi lola wandakali tupa saka atapowa atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wamba yakamana yumbane tupa wandakali napalene yuu okona atoto, betesa gene mana lene oko neaini tekeko, matili utupane pitaka omeainipia. ");
INSERT INTO ipi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Ati kenga atalu, yuunga epeane betesa saka atene oko namba. Wandakali-mane betesa oko no atoto, oma napeakale nembo toto, betesa oko ati kenga atalu, yuunga epeane. Wandakali mindimane betesa oko neando, bala saka atapowa atolopeya. Yuu okona wandakali tupa saka atapowa ateakale nembo toto, betesa nambato utupane mauwakale oko nambana umbaini oko. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wuane lea-kola, Juta yame wandakali yakama teke-teke pii yanda puato, nanimato balana umbaini oko nalapa loto, akali okomane anu pua katulo gulupeyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","56","Wuane leai-kola, Jisasato utupane lamawuato, nambana umbaini oko tomo enene eya lea. Dee, nambana tundupa oko ipa nolane enene eya. Nambana umbaini tundupa-la, okonelapo nolai wandakali tupa nambanga atolai-kola, namba utupanenga atolo-peyawa. Yuu oko koyo pula-angi, nambato utupane malinga ika laya olowa-kola, utupane saka atapowa atolopeyai. Wuane tekeko, nambato pii enene wete yakama langeyo. Yakamato Akalina Iwanane okona umbaini tundupa-la, okonelapo nanene kondeaindo, yakama saka atapowa ata napulu-peyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","58","Wamba betesa gene mana lene oko ati kenga ato yuunga epea-kola, yakamana yumbane tupamane betesa okone neaini tekeko, matili utupane yakama omeainipia. Nambana umbaini oko betesa okonepene jia. Namba ati kenga atalu, yuunga epewane-ko. Nambana umbaini nolai wandakali tupa saka atapowa atolopeyai. Ayiane saka atene okomane namba ati kenga atala yuunga puu lea-kola, namba epewane. Bala mambele namba saka ateyo. Wuane pua teke, namba nolai wandakali tupa namba mambele saka atapowa atolopeyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisasa bala Juta yamena lotu anda Kapaneame tanonga ateane okona atoto, wandakali tupa mana lamawuato, pii utupane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisasato wuane lea-kola, bala towa atu epoko pua ateaini wandakali kambua-mane balana pii okone ale wato, pii lalawa puato, pii mana Jisasato langeya okona tene oko nembo tape-pene pitete-pene guleya-ko. Apito balana pii okone ale wato, balato tika pua leya lolo-peyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wuane lo mulu-mulu leyai nembo toto, Jisasato utupane lamawuato, nambato pii leyo utupane yakamato ale wato, namba lo bilipi leyai oko awua tepa eyaipe lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wuane yando, Akalina Iwanane wamba ati kenga yuu ateane okona peke lola-angi, yakamato mangene okone andeaindo, yakamato anu pulu-peyaipe. ");
INSERT INTO ipi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nanimana umbaini-mane katulo nanima saka atapowa ateakale lo ataya na-olopeya. Jia. Oli Sipitisa okomane wandakali tupa saka atapowa ateakale lo ataya alane. Nambato Gotena pii oko wandakali tupa lamai-yokola, Oli Sipitisa oko epoto, utupane saka atapowa ateakale lo ataya alane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wamba Jisasato bulupane tewa balana piape pua atea-angi, akali bala ene pitulu-peya okopi, wandakali bala lo bilipi nalolo-peyai tupapi, utupane nembo teaipia. Utupane andayo, balato pii mindi tako pua loto, Oli Sipitisa okomane wandakali tupa saka atapowa ateakale lo ataya alane tekeko, yakamana minditupa-mane namba lo bilipi naleyai. ");
INSERT INTO ipi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tene okonena, nambato yakama languato, namba Ayiane okomane namba lo bilipi lolane tai-lene oko wandakali mindinga mai napeando, wandakali okonemane namba atolowanga katulo naepolo-peya lewane lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wuane lea-kola, okone angi tewa, wandakali bala towa atu epoko pua atoto, mana meaini tupana kambua minditupa-mane bala towa atu epoko pua ata napene, bala awua tepa alu, peke leai. ");
INSERT INTO ipi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Bala awua tepa alu, peke leai-kola, Jisasato balana disaipolo alesa akali tupa tipa puato, yakamatopi namba awua tepa aima lakae lo nembo teyaipe lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Wuane lea-kola, Saimone Pitato balana pii okone yano peyoto, Akali Andane, nimbato wandakali saka atapowa ateakale lo ataya alane pii tupa lalene. Nanimato andeyama-kola, Goteto nimba balana akali epene tika-pene wete oko atola lata yane lo andoto, nanimato nimba lo bilipi leyama. Nanimato nimba tepa wato, akali waka mindi pemando, okone kuai nalolo-peya lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wuane lea-kola, Jisasato balana disaipolo tupa lamawuato, nambato alesa akali yakama nambana disaipolo tupa atalapale loto, yapa lo mewane tekeko, yakamana akali mindi bala sipitisa koo Satane yale ateya lea. ");
INSERT INTO ipi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Saimone Isaka-tiyote iwanane Jutasa bala Jisasana disaipolo alesa akali tupana mindi ateane tekeko, matili Jutasato bala ene pitulu-peya nembo toto, Jisasato yakamana akali mindi bala sipitisa koo Satane yale ateya lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jutiya disitiki okona Juta yame akali minditupa-mane Jisasa peyo ome laima lakae lo nembo toto, bala aiya pua ateai-kola, bala Jutiya disitiki okona epoko pua ata napukale nembo toto, Galili disitiki okona angu epoko pua atea. ");
INSERT INTO ipi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wuane pua atea-kola, Juta yame wandakali tupa Jutusaleme poto, anda aiyakame tupana palu atoto, lotu andane mindi lalu, tomo andane mindi nalaini oto oko mandaka epea. ");
INSERT INTO ipi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Okone angi, Jisasana amene tupamane bala lo bilipi naleai. Tene okonena, utupane-mane bala lamba loto, akali mindimane bala gene yene atokale nembo teando, bala too pua atoto, piape mindikipi mindi na-piyaini leai. Nimbato metekolo piape tupa pilini yando, wandakali pitaka-mane nimbana metekolo piape utupane andeakale. Nimba lo bilipi lene Jutiya disitiki tane wandakali tupamane nimbana metekolo piape tupa andeakale teke. Nimba Galili disitiki oko tepa alu, Jutiya disitiki okona poto, metekolo piape utupane panakame pipe leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","7","Wuane leai-kola, Jisasato utupane lamawuato, nambato yuu okona wandakali tupana mana miniyai tupa andoto, utupane koo ya lalawane. Wuane leyo-kola, wandakali utupane-mane namba towa embo wete alaini okonena, namba Jutusaleme polane oto oko ipu ata naeya. Wuane tekeko, yuu okona wandakali tupamane katulo yakama towa embo wete naeyai-kola, yakama Jutusaleme polane oto oko ole dindi lo epalane. ");
INSERT INTO ipi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yakama Jutusaleme lotu andane oko lolo pulupa. Namba Jutusaleme polane oto oko ipu ata naeya-kola, andipa oko angi namba lotu andane oko lolo napeyo lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wuane lalu, bala Galili disitiki okona atea. ");
INSERT INTO ipi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bala Galili disitiki okona gii ukupini mindi ateane tekeko, balana amene tupa Jutusaleme wamba ini peai-kola, aŋa matili yale, balapi pea. Bala panakame puu napene, tengamane too pua pea. ");
INSERT INTO ipi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bala tengamane too pua peane okonena, Juta yame wandakali tupana akali kawane tupamane bala kapoyale anda napeainipia. Wuaneko, lotu andane lolane oto oko epea-angi, utupane-mane bala aiya pima epoko puato, akali oko bala aninga ateyape lo tipa piki pua ateai. ");
INSERT INTO ipi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Tipa piki pua ateai-kola, wandakali amunguli pua ateaini tupamane bala andayo mulu-mulu loto, pii kambua leainipia. Wandakali minditupa-mane mulu-mulu loto, Jisasato wandakali tupa minakasa alane leai. Wandakali minditupa-mane bala akali epene mindi ateya leaini tekeko, Juta yamena akali kawane tupamane kenda-pene mindi yakama gulaini lo yuku wato, utupane-mane pii okone panakame naleai. Jia. ");
INSERT INTO ipi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ole minditupa pea-kola, lotu lo ateaini oto tupana tombenenga, Jisasa bala lotu anda andane okona ende anda-pangosa kolandaka loto, Gotena pii mana tupa lamauwa atea. ");
INSERT INTO ipi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mana lamauwa atea-kola, Juta yamena akali kawane tupamane moko loto, nembo kambua toto, akali oko bala ee ana kambua sukulu nalea-ko. Balato Gotena pii mana tupa aninga tawe mana meape leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","18","Wuane leai-kola, Jisasato utupane lamawuato, Goteto wandakali minditupa lamawuato, yakamato nambana pii oko wandakali tupa lamalu pulupa leya-kola, wandakali utupanena minditupa-mane yakama tanena gene tupa laiyu lamakale nayuto, yakama tanena pii oko wandakali tupa lamai-yaini. Wuane tekeko, pii nambato lalawane tupa namba tanena pii jia. Namba Ayiane okomane balana pii oko wandakali tupa lamalu puu leane pua, nambato balana pii utupane lalawane. Tene okonena, wandakali mindimane nambana pii oko ale wato, Gotena nembo-tene wato minukale nembo teando, nambana pii okone yapa lo tale puato, nambato namba tanena pii mindi naleya. Jia. Gotena pii oko leya lo andolopeyai. Nambato Gotena gene oko laiyu lokale nembo toto, balana pii oko wandakali tupa lamai-yawane okomane namba akali tika-pene atoto, owato pii na-lalae ya lo yakamato andape-pene. ");
INSERT INTO ipi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosesato Gotena loo tupa yakama geane tekeko, yakamana mindikipi mindimane loo utupane wato mina na-piyaini. Jia. Nambato Gotena gene oko laiyu lauwa lakae lo nembo toto, balana enene pii oko lalawane-ko. Anu peakale yakamato namba peyo ome laima lakae lo nembo teyaipe. Jisasato wuane lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wuane lea-kola, wandakali epo amunguli pua ateaini tupamane bala tipa puato, apito nimba peyo ome laima lakae lo nembo teyape. Nimbanga sipitisa koo mindi ateya-kola, nimbato wuane lele leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Wuane leai-kola, Jisasato utupane lamawuato, wamba Mosesato loo mindi yata wato, yakamato iwana mindi mandulai-angi, ole kitupasa pola-kola, balana yala-pene umbaini oko katu apia-maiyapape leaipia. Mosesato mana okone wamba bulupane yata nayaepia. Jia. Yakamana yumbane Apatakameto mana okone wamba bulupane yata ya-kola, Mosesato mana okone minu tai laya yaepia. Yakamato mana okone wato minuto, iwana mindi mandulai-angi, ole kitupasa pola-kola, balana yala-pene umbaini oko katiyaini. Iwanaŋa okona yala-pene umbaini kateakale lene ole kitupane lola okone Sambasa mindi yando, yakamato Sambasa loo oko kalo peyama nembo toto teke, iwana okonena yala-pene umbaini katu apia-maiyaini. Sambasa tupana yakamato iwana tupana yala-pene umbaini katuto, piape piyaini pua teke, Sambasa mindina nambato metekolo piape mindiki piwa-kola, anu peakale yakamato moko lapiaipe. ");
INSERT INTO ipi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yakamato nambana mana tupa lee-mane angu andoto, namba yapa lo tale peyai mana oko kondalu, yakamato mana epene tika-pene oko wato minuto, nambana mana tupa kuai lo yapa lo tale piyapa lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jisasato wuane lea-kola, Jutusaleme tane wandakali minditupa-mane pii lalawa puato, Juta yamena akali kawane tupamane akali mindi peyo ome lamakale nembo toto, aiya pua ateyai akali oko bala jiape leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Balato wandakali tupa pitakana wenonga panakame atoto, pii lo ateya tekeko, Juta yamena akali kawane tupamane pii kondaa lo bala lamai napeyai oko andalapa. Utupane-mane bala Mesaya oko ateya nembo tolaini. ");
INSERT INTO ipi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nanimato akali okona yuu tene oko nembo teyama tekeko, Mesaya oko epola-angi, wandakali mindikipi mindimane balana yuu tene oko nembo natolo-peyaiko. Bala Mesaya oko jia leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wuane leai-kola, Jisasa bala lotu anda andane okona ende anda-pangosa atoto, wandakali tupa mana lamawua ateaipia. Balato pii taimane loto, enene, yakamato namba andoto, nambana yuu tene oko nembo teyai tekeko, namba epewane oko namba tane epokale nembo toto na-epewane. Jia. Gote enene okomane namba ati kenga atala yuunga puu lea-kola, namba yuunga epeane lo yakamato anda napeyai. ");
INSERT INTO ipi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Namba bala towa atu atapale okonena, nambato bala andeyawane. Namba ati kenga atewa-kola, balato namba yuunga puu leane. Jisasato wuane lo mana lamawua atea. ");
INSERT INTO ipi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Balato wuane lo mana lamawua atea-kola, utupane-mane bala andi laima lakae lo nembo teaini tekeko, bala andi lolane oto oko ipu ata naya-kola, wandakali mindikipi mindimane bala mina napene, kondayai. ");
INSERT INTO ipi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amunguli pua ateaini wandakali tupana kambua-mane Mesaya oko epola-angi, balato akali oko sia minuto, metekolo piape kambua wete napulu-peya yalua loto, bala Mesaya okone ya lo bilipi leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amunguli pua ateaini wandakali tupamane akatete lamo nena puato, Jisasa bala Mesaya oko ya leai-kola, Patasai tupamane pii okone ale yai. Ale wato, pitisa akali kawane tupa towa pii mindi lo puta puato, utupane-mane yakamana yanda yene minditupa lamawuato, yakamato Jisasa andi lolo pulupa leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Akali utupane-mane Jisasa andi lolo peai-kola, Jisasato Juta yame wandakali tupa lamawuato, namba ana aŋalapo minditupa angu tako pua yakama towa atu atalu, namba ati kenga atala yuunga puu leane Ayiane oko ateyanga peke lolo-peyawa lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Namba Ayianena yuu okona atolowa-kola, yakama katulo yuu okonena naepolo-peyai. Jia. Yakamato namba aiya pulupeyai tekeko, yakamato namba ando mia napulu-peyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Wuane lea-kola, Juta yamena akali kawane tupa yakama teke-teke pii mindi lamai-lamai puato, Jisasato yakama katulo namba atolowa okona naepolo-peyai leya. Yakamato namba aiyu pulupeyai tekeko, yakamato namba ando mia napulu-peyai leya-ko. Balato mangene anu-pene mindi pukale nembo toto, wuane leyape. Bala aninga pola-kola, nanimato bala katulo aiya pua anda napulu-peyamape. Wamba Juta yame wandakali minditupa nanimana yuu oko tepa alu, Gitiki yamena yuu okona poto, ateyai. Bala yuu okonena poto, Juta yame wandakali utupanena tombenenga atoto, wandakali yame waka tupa mana lamauwa atokale nembo toto, wuane leyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Juta yame wandakali tupamane lotu lalaini oto kitupane koyo puyale lotu andane mindi leai-angi, Jisasa bala ika lo atoto, pii mindi wandakali tupa taimane lamawuato, Gotena pii pepa pelene eya mindimane leya pua, wandakali mindimane namba lo bilipi leaindo, ipa saka balana yamapanenga lai yungu epolopeya layene eya. Tene okonena, wandakali mindi ipa nono yando, bala nambanga ipa nolo epeakale lea. ");
INSERT INTO ipi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Okone angi, Jisasa bala gene andane mindi mia napea-kola, Goteto balana Oli Sipitisa oko wandakali tupanga mai na-epea tekeko, matili bala lo bilipi lolai wandakali tupamane Oli Sipitisa oko molopeyai nembo toto, Jisasato pii okone wandakali utupane lamaiya. ");
INSERT INTO ipi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lamaiya-kola, wandakali amunguli pua ateaini tupana minditupa-mane balana pii okone ale wato, enene, akali oko bala potopisa akali ati kenga atala Goteto yuunga epeakale lokale leane oko ateya leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Wandakali waka minditupa-mane akali oko bala Mesaya oko ateya leai. Wuane tekeko, wandakali minditupa-mane Gotena pii pepa pelene eya mindimane loto, kiŋi Dapiti yame okomane balana yuu tene Beselekeme tano okona atoto, Mesaya oko mandulu-peya layene eya-ko. Mesaya oko bala Galili disitiki okona tane mindi ata napulu-peya nembo teyama leai. ");
INSERT INTO ipi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wuane leai-kola, wandakali amunguli pua ateaini tupamane Jisasa bala Mesaya oko ateyape lo pii yanda puato, yapu lo lapo peai. ");
INSERT INTO ipi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Akali yangi-mane bala andi laima lakae lo nembo teaini tekeko, utupanena mindikipi mindimane bala minata nayai. ");
INSERT INTO ipi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yanda yene tupamane Jisasa andi nalene, pitisa akali kawane tupapi, Patasai tupapi, utupane ateainga peke leai-kola, Juta yamena akali kawane utupane-mane yanda yene tupa tipa puato, anu peakale yakamato Jisasa andi lo awua na-epeyaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wuane leai-kola, yanda yene tupamane utupanena pii okone yano peyoto, Jisasato pii tene andane palene tupa lala pua wamba akali mindikipi mindimane naleane okonena, nanimato bala andi lo awua naepene kondalama leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wuane leai-kola, Patasai tupamane utupane tipa puato, Jisasato yakamapi minakasa ala-kola, yakamatopi bala lo bilipi lalaipe leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Wandakali amunguli pua ateyai tupamane Mosesana loo oko wayumane nembo natene ato, Jisasa bala Mesaya oko ateya lo bilipi leyai-kola, Goteto kenda-pene andane wete mindi utupane malupeya. Wuane tekeko, Patasai tupapi, Juta yamena akali kawane tupapi, nanimana mindikipi mindimane bala Mesaya oko ateya lo bilipi naleyama leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Patasai utupane mindina gene oko Neketomasa lene. Wamba bala Jisasa peteanga poto, bala towa pii lalawa peaipia. Akali okonemane Juta yamena akali kawane utupane lamawuato, wua leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nanimana loo okomane mana mindi yata wato, nanimato akali mindi mee kosimi loto, balanga koo tene minditupa yata ape-pene naleya. Jia. Nanimato balana pii wamba ini ale wato, balana mana tupa nembo toto, bala yapa lo tale pipe-pene leya leaipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wuane lea-kola, Juta yamena akali kawane tupamane balana pii okone yano peyoto, nimba Galili disitiki okona tane mindi ata napele-ko. Anu peakale nimbato Galili tane Jisasa oko moyoyale wuane lelepe. Nimbato Gotena pii pepa pelene eya tupa wayumane wete dii lo andoto, Galili tane mindi bala potopisa akali mindi atolopeya layene naeya oko andape leainipia. ");
INSERT INTO ipi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wuane lalu, akali utupane mindiki-mindiki lo yakama andaka peainipia. ");
INSERT INTO ipi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisasa bala Olipi wangiane okona pea. ");
INSERT INTO ipi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Anate-lene upa pitane nai peakaiyu lea-angi, bala lotu anda andane okona ende anda-pangosa dee lapone teke peakaiyu lea. Wandakali pitaka bala ateanga epeai-kola, bala pituto, utupane mana lamauwa petea. ");
INSERT INTO ipi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Akali mindina wetene okomane pamuku pua palea-kola, mindimane andoto, loo tupana mana andene akali tupapi, Patasai tupapi, utupane lamai-yainipia. Lamai-yaikola, utupane-mane wanda okone atu Jisasa mana lamawua peteanga epoto, wandakali tupana wenonga ateakale leai. ");
INSERT INTO ipi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ateakale lalu, utupane-mane Jisasa lamawuato, tisa, wanda okomane pamuku pua paliya-kola, mindimane andala yala leai. ");
INSERT INTO ipi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wamba Mosesato loo mindi nanimanga yata wato, wanda okonepene tupa ana-mane peyo ome lalapape leane-ko. Nimbato aki lelepe leai. ");
INSERT INTO ipi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jisasato utupanena pii okone yano peyola-kola, utupane-mane bala kosimi lamakale nembo toto, bala minu mandeke puato, wuane leaini tekeko, Jisasato utupanena pii okone yano peya napene, mee tombawua loto, balana kii ondene okomane yuunga pepa mindi pelea. ");
INSERT INTO ipi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jisasato utupanena pii okone yano napelea-kola, utupane-mane bala tipa pitawa yapo yai. Wuane pea-kola, bala ika loto, utupane lamawuato, koo napilini akali mindimane wanda oko ana-mane wamba ini peya lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wuane lalu, Jisasa bala lapone tombawua loto, yuunga pepa mindi pelea. ");
INSERT INTO ipi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jisasato wuane lea-kola, loo tupana mana andene akali tupapi, Patasai tupapi, utupane-mane balana pii okone ale alu, mindiki-mindiki lo puku peai. Akali mini-yene tupa wamba ini peai-kola, patane yale tupa matili peai. Akali utupane pitaka peai-kola, wanda okone angu Jisasana wenonga atea. ");
INSERT INTO ipi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Atea-kola, Jisasa ika lo atoto, bala tipa puato, wanda, akali andalama tupa aninga palaipe. Akali utupanena mindiki mindimane nimba kosimi loyale ata napeyaipe lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wuane lea-kola, wanda okonemane bala lamawuato, Akali Andane, akali mindikipi mindimane namba kosimi loyale ata napeyai lea. Wuane lea-kola, Jisasato bala lamawuato, nambatopi nimba kosimi naleyo-ko. Andipa ateyama gii okona atoto tewa, nimbato koo mindi dee lapone napipe. Nimba puu lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wandakali kambua lotu anda andane okonena ende anda-pangosa amunguli pua ateai-kola, Jisasato utupane lapone mana lamawuato, nambato yuu okona atoto, tii pua atalawane lea. Namba watama epolai wandakali tupanga saka atapowa ateakale lo ataya alane tii-pene okone yola-kola, utupane undupi pangosa epoko pua ata napulu-peyai. Jia wete lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wuane lea-kola, Patasai tupamane bala lamawuato, nimba tane angu wuane lele okonena, wandakali waka tupamane nimbana pii okone bilipi lolane tene mindi napaleya leai. ");
INSERT INTO ipi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, yuu namba atalu epewane okopi, yuu namba polopeyawa okopi, okonelapo yakamato nembo nateyai tekeko, yuu namba atalu epewane okopi, yuu namba polopeyawa okopi, okonelapo nambato nembo teyo lea. Nambato wuane nembo toto, mana okopene tupa minuto, piape piyawane lewando, wandakali waka tupamane nambana pii okone bilipi lape-pene. ");
INSERT INTO ipi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yakamato yuunga wandakali tupana pii mana wato minuto, namba yapa lo tale peyai. Yuunga wandakali tupana pii mana wato minuto, nambato wandakali mindikipi mindi yapa lo tale na-piyawane. ");
INSERT INTO ipi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","17","Wuane tekeko, yakamana loo okomane pii mindi loto, wandakali lapo wisanisa atoto, pii mindiki okone teke leapindo, okone-lapona pii okone enene yolopeya layene eya. Namba angu ata napeyo. Jia. Namba ati kenga atala yuunga puu leane Ayiane oko namba towa atu ateyapa. Wuaneko, nambato wandakali mindi yapa lo tale pewando, namba Ayiane okomane pii mindiki okone teke lola-kola, nalipana pii okone enene yolopeya. ");
INSERT INTO ipi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Namba tane mana okopene tupa minuto, piape piyawane leyo. Namba ati kenga atala yuunga puu leane Ayiane okomane namba andayo pii mindiki okone teke leya-kola, nalipana pii okone enene wete eya lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wuane lea-kola, Patasai tupamane bala tipa puato, nimbana Ayiane okone aninga ateyape leai. Wuane leai-kola, Jisasato utupanena pii okone yano peyoto, yakamato namba andapiai-yale, nambana Ayiane okopi andapiai-yale tekeko, yakamato namba Ayiane nalipa lapotaka anda napeyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wayu pele muni aindaka lalaini pene tupa yaini ongane mandaka pituto, Jisasato wandakali tupa mana lamawuato, pii utupane leane tekeko, wandakali-mane bala andi lolane oto oko ipu ata naya-kola, wandakali mindikipi mindimane bala andi loyale mina napeai. ");
INSERT INTO ipi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Okone angi, Jisasato dee lapone teke wandakali tupa mana lamawuato, namba polowa-kola, yakamato namba aiya pulupeyai tekeko, yakamato katulo namba anda napulu-peyaiko. Yakamana koo piyaini tupa yakamanga mee yapowa yola-kola, yakama omolai-angi, yuu namba polowa okona yakama katulo naepolo-peyai lea. ");
INSERT INTO ipi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wuane lea-kola, Juta yamena akali kawane tupa yakama teke-teke pii lalawa puato, balato yuu namba polowa okona yakama katulo naepolo-peyai leya-ko. Bala tane peyo ome lokale nembo toto, wuane leyape leai. ");
INSERT INTO ipi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","24","Wuane leai-kola, Jisasato utupane lamawuato, yuunga yuu oko yakamana yuu tene oko eya-kola, yakamato yuunga wandakalina mana tupa wato minu atalaini. Tene okonena, yakama omolai-angi, yakamato koo piyaini utupanena koo tene tupa yakama tanenga mee yapowa yolopeya lo nambato yakama langeyo. Wuane tekeko,