﻿USE sofia;
DROP TABLE IF EXISTS sofia.iou_vpl;
CREATE TABLE iou_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES iou_vpl WRITE;
INSERT INTO iou_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Yäput peŋpäŋ Anututä kunum kenta kome pewän ahäŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Täŋpäkaŋ kome u täŋkuräk-kuräk ikek, jopitä parirän bipmäŋ uranitä uwäk täŋkuk. Täŋpäŋ gwägu pähap terak uwä Anutu täŋo Munapiktä punin jop kuŋatkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Täŋpäkaŋ Anututä yäŋkuk; Yäŋewän! Yäwänä yäŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yäŋeŋirän Anututä peŋyäŋek u kawän tägaŋkuk. Kawän tägawäpäŋ bipmäŋ urani ba peŋyäŋek yäpmäŋ daniŋpäŋ inigän inigän yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ude yäpmäŋ daniŋpäŋ peŋyäŋek täŋo wäpi Kepma yäŋ iwetkuk. Täŋkaŋ bipmäŋ urani täŋo wäpi Bipani yäŋ iwetkuk. Eruk, kome bipmäŋpäŋ yäŋeŋirän edap kubä u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Edap kubä u täreŋirän, eruk Anututä yäŋkuk; Ume bämopiken baga kubä ahäŋpäŋ ume yäpmäŋ daniwän! ");
INSERT INTO iou_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ude yäwänä ume bämopiken baga kubä ahäŋpäŋ ume yäpmäŋ daniŋkuk. Yäpmäŋ daniŋpäŋ punin kubä täŋkuko gubam. Täŋkaŋ kome terak umeinik. Ude täŋirän punin inigän, komen inigän täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ude ahäŋirän Anututä baga unitäŋo wäpi Kunum yäŋ iwetkuk. Eruk, kome äneŋi bipmäŋpäŋ yäŋeŋirän edap yarä u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Edap yarä u täreŋirän, eruk Anututä yäŋkuk; Kunum gämoriken ume kubäkengän it moreŋirä kome kawuki ahäwän! Ude yäwänä ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Täŋpäŋä Anututä kome kawuki täŋo wäpi Kome yäŋ iwetkuk. Täŋpäŋ ume kubäkengän it moreŋkuŋo unitäŋo wäpi Gwägu Pähap yäŋ iwetkuk. Ude ahäŋirän Anututä kawän tägaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ude täŋkaŋ Anututä yäŋkuk; Imaka yeri-yeri kome terak tädorut! Ketem mujipi nikek mebäri mebäri ba päya mujipi nikek mebäri mebäri tädorut! Ude yäwänä udegän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kometä towiŋirä ketem mujipi nikek doni iniken iniken terak, ba päya mujipi nikek doni iniken iniken terak ahäŋkuŋ. Ahäwäkaŋ Anututä yabäwän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Eruk, kome äneŋi bipmäŋpäŋ yäŋeŋirän edap yaräkubä u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Edap yaräkubä u täreŋirän, eruk Anututä yäŋkuk; Kunum terak kepma ba bipani yäpmäŋ danikta topän ahäwut! Unitä iwän kadäni, edap kadäni, orekirit kadäni api yäŋahäk täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Täŋpäŋ kunum täŋo topän u ahäŋpäŋ kometa peŋyäŋek imut. Yäwänä udegän ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Anututä ude yäŋpäŋ topän pähap yarä pewän ahäŋkumän. Kubä taŋi uwä kepma watäni itta, kubä täpuri uwä bipani watäni itta u yepmaŋkuk. Täŋkaŋ guk bok pewän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Pewän ahäŋkuŋo uwä kometa peŋyäŋek imikta, bipani kepmata watäni itta, ba bipmäŋ urani ba peŋyäŋek yäpmäŋ danikta u Anututä kunum gänaŋ yepmaŋkuk. Ude yepmaŋpäŋ Anututä yabäwän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Eruk, kome äneŋi bipmäŋpäŋ yäŋeŋirän edap yaräbok-yaräbok u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Edap yaräbok-yaräbok u täreŋirän, eruk Anututä yäŋkuk; Ume gänaŋ tom bumtainik, jiraŋ ahäwut! Täŋkaŋ barak punin terak piäŋ kuŋarut! Ude yäwänä udegän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Anututä gwägu tom taŋi pähap ba imaka kuŋat-kuŋat ikek mebäri mebäri, wareŋ täŋpani mebäri mebäri gwägu gänaŋ kuŋat täkaŋ, ba barak mebäri mebäri pewän ahäŋkuŋ. Pewän ahäŋkuŋo u yabäwän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Täŋpäkaŋ Anututä man yeri nikek ŋode yäwetkuk; In bäyaŋ weŋpäŋ gwägu tokŋewut, ba barak imaka, bäyaŋ weŋpäŋ kome tokŋewut! ");
INSERT INTO iou_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Eruk, äneŋi bipmäŋpäŋ yäŋeŋirän edap ket kukŋi kudup u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Edap ket kukŋi kudup u täreŋirän Anututä yäŋkuk; Kome terak tom ŋode ahäŋpäŋ ini-ini bäyaŋ wewut; Tom yepmäŋ towikta yäwani ba tom ägwäri ba gämok kejima mebäri mebäri udegän bäyaŋ wewut! Ude yäwänä udegän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Anututä tom ägwäri ba yepmäŋ towikta yäwani mebäri mebäri ba gämok gwakgwak mebäri mebäri ude u pewän ahäwäpäŋ yabäwän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ude täŋkaŋ Anututä yäŋkuk; Eruk, ninin bumik äma pena ahäwut yäk. Ude täŋitna äma unitä gwägu tom ba barak ba tom yepmäŋ towikta yäwani ba kome terak irojäŋ kuŋarani, u kuduptagän kaŋ yabäŋ yäwarut. ");
INSERT INTO iou_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ude yäŋpäŋ Anututä ini bumik äma pewän ahäŋkuŋ. Ämani peŋ webe peŋ täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Täŋpäŋ man yeri nikek ŋode yäwetkuk; Intä kome mähem täŋpäŋ bäyaŋ wewäpäŋ kome tokŋewut. Täŋpäŋ tom gwägu gänaŋ nanik ba barak ba imaka imaka kome terak kuŋarani u kuduptagän kaŋ yabäŋ yäwarut. ");
INSERT INTO iou_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Anututä ude yäŋpäŋ yäwetkuk; Ketem imaka yeri nikek kudup ba päya mujipi näŋpani kudup u nakjinta peŋ tamitat. ");
INSERT INTO iou_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Täŋpäŋ tom kejima, barak kejima ba imaka gwakgwak kome terak kuŋarani unitä nakta tokän peyat. ");
INSERT INTO iou_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Täŋpäkaŋ Anututä imaka kudup täŋpewän ahäŋkuŋo u yabäwän tägagämäninik täŋkuŋ. Eruk, kome äneŋi bipmäŋpäŋ yäŋeŋirän edap 6 u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Eruk, kunum kome yarä ukät äboriye pähap pewän ahäŋ moreŋkuŋo unitäŋo manbiŋam uba. ");
INSERT INTO iou_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Täŋpäkaŋ edap 7uken Anututä piäni täŋkuko u täreŋirän edap uken itpäŋ-nadäkta orek itkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Anututä edap 7u ini kon täŋ imiŋpäŋ ini pärik, kudupi api irek yäŋ yäŋkuk. Imaka kudup ahäŋ morewäpäŋ itpäŋ-nadäk täŋpa yäŋpäŋ orek itkuko unita edap u ini pärik, kudupi peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Ŋowä kunum kome pewän ahäŋkuŋo unitäŋo manbiŋam. Yawe Anututä kunum kome pewän ahäŋkuŋo kadäni uken päya ba ketem imaka mebäri mebäri kome terak nämo ahäwani. Yawe Anututä iwän takta nämo nadäŋ imiŋkuk. Ba piäni täkta äma kubä nämo itkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Täŋpäkaŋ woŋ taŋi kome gänaŋ naniktä ahäŋpäŋ kome pähapta ume imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Täŋpäkaŋ Yawe Anututä komepäŋ äma kubä gatäŋpäŋ iŋami gänaŋ irit täŋo woŋ piäŋ iwatkuk. Piäŋ iwat-pewän äpmoŋirän äma u imaka irit ikek ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ude täŋpäŋ Yawe Anututä edap abani käda ketem piä kubä Iden komeken täŋkuk. Piä u täŋpäŋ äma gatäŋkuko u Iden piä uken teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Teŋpäŋ Yawe Anututä päya mebäri mebäri kaŋgärip ikekkät mujipi ätu täga nakta bok pewän ahäŋkuŋ. Täŋkaŋ piä u bämopiken päya kubä wäpi Irit päya, kubäwä wäpi Waki ba Täga täŋo Mebäri Nadäwani päyatä itkumän. ");
INSERT INTO iou_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Täŋpäkaŋ Iden kome bämopiken naniktä ume taŋi kubä piäta gakŋi imikta kuŋkuk. Kuŋkaŋ yäpmäŋ daniŋpäŋ ume yaräbok-yaräbok ini-ini kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ume kubä wäpi Pison, unitä Havila kome kudupken kuŋat moreŋkuk. Kome uken gol mobä kome gänaŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Gol mobä uken nanik gwäki ärowani. Täŋpäŋ ukengän päya kubä umumi käbäŋi säkgämän ikek itkuk, ba mobä kaŋgärip ikek wäpi Kanilian imaka itkuk.) ");
INSERT INTO iou_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Täŋpäkaŋ ume kubä wäpi Gihon, unitä Kus komeken kuŋat moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Täŋ, ume kubä wäpi uwä Taigris. Unitä Asiria kome edap abani käda u kuŋkuk. Täŋ, ume kubä wäpi Yufretis. ");
INSERT INTO iou_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Täŋpäkaŋ Yawe Anututä äma gatäŋkuko u yäpmäŋpäŋ Iden piä uken piä täkta, ba watäni irekta teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Teŋkaŋ äma u man kehäromi ŋode iwetkuk; Gäk piä ŋo gänaŋ päya mujipi nikek it yäpmäŋ kukaŋ unitäŋo mujipi täga api näŋpen. ");
INSERT INTO iou_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Upäŋkaŋ Waki ba Täga täŋo Mebäri Nadäwani päya unitäŋo mujipi nämoinik näŋpen! U naŋpäŋä kumäkinik api täŋpen. U jop nämo gäwetat yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Täŋpäkaŋ Yawe Anututä yäŋkuk; Äma u inigän irirän nämo tägatak. Ini bumikgän not täŋkentäki kubä gatäwa! ");
INSERT INTO iou_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eruk, Yawe Anutu u tom mebäri mebäri, barak punin nanik komepäŋ täŋkuko u kudup äma unitä wäp yämikta iŋamiken yäpmäŋ äbuk. Yäpmäŋ äbäŋirän äma unitä yabäŋpäŋ wäp ini-ini yämiŋkuk. Wäpi yämiŋkuko uwä wäpi ubayäŋ. ");
INSERT INTO iou_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Äma unitä ude täŋkuko uwä tom yepmäŋ towikta yäwani, barak ba tom ägwäri u kuduptagänta wäpi yämiŋkuk. Ude täŋkuko upäŋkaŋ täŋkentäki ini bumik kubä nämo kaŋ-ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Unita Yawe Anututä äma u täŋpewän däpmon patguŋ taŋirän äma unitäŋo järapi kujat kubä dätpäŋ toharipäŋ äneŋi täŋpipiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ude täŋkaŋ Yawe Anututä järapi kujat yäpuko upäŋ webe kubä täŋpäŋ äma uken imagut yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Imagut yäpmäŋ kuŋirän äma unitä kaŋpäŋ yäŋkuk; Wisik! Ŋowä kujatnek kubägän, tohatnek kubägän. Ŋowä ämaken nanik yäpani unita wäpi webe yäŋ api iwetneŋ. ");
INSERT INTO iou_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Eruk mebäri unita ämatä miŋi nani yepmaŋpeŋ webeni kentäŋirän gupi tohari kubägän api tädeŋ. ");
INSERT INTO iou_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Täŋpäkaŋ yanäpi yarä u moräŋ bok itpäŋ mäyäkkät nämo itkumän. ");
INSERT INTO iou_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Eruk, Yawe Anutu u tom ägwäri pewän ahäŋkuŋo upäŋkaŋ gämok täŋo yäŋikŋat mantä ärokinik täŋpäŋ tom päke u yärepmitkuk. Täŋpäkaŋ gämok u webe ŋode iwet yabäŋkuk; Anututä piä gänaŋ päya kuduptagän mujipi nämo nakta täwetkuk ba jide? ");
INSERT INTO iou_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Yäŋirän webetä gämok u iwetkuk; Nek piä gänaŋ päya kuduptagän täŋo mujipi täga nädeŋ yäŋ niwetkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Täŋ, päya kubä piä bämopiken itak unitäŋo mujipi uwä Anututä iŋitta ba nakta yäjiwätkuk. Ude täŋpäŋä kumäkinik api tädeŋ yäŋ niwetkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yäwänä gämoktä webe iwetkuk; Ude nämo! Nämo api kumdeŋ! ");
INSERT INTO iou_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","U Imata, Anututä ŋode nadäŋpäŋ täwetkuk; Ek mujipi u naŋirän dapunjek ijiwän kwäpäŋ ek Anutu ini bumik täŋpäŋ kädet täga ba waki unitäŋo mebäri api nadäwän täreneŋ yäŋ nadäŋkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Gämoktä ude iweränpäŋ webetä päya u kaŋpäŋ ŋode nadäŋkuk; Päya unitäŋo mujipi kaŋgärip ikek. U täga näŋpet. U naŋpäŋ nadäk-nadäk kaŋ-ahäk ikek yäŋ nadäŋpäŋ gäripi nadäŋkuk. Ude nadäŋpäŋ mujipi u dätpäŋ naŋkaŋä moräki äpita imän naŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Naŋpäŋä yarä u nadäk-nadäki piräreŋirän moräŋ kuŋatkumäno u kawän täreŋkuŋ. Unita gupi täŋpipikta pähäm taŋi ätu yäpmäŋkaŋ bipumän. ");
INSERT INTO iou_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Täŋkumäno kome komkom täŋirän Yawe Anututä piä gänaŋ kuŋarirän yanäpi yarä u mämäni nadäŋkumän. Nadäŋpäŋä umuntaŋpäŋ päya jopäniken käbop itkumän. ");
INSERT INTO iou_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Käbop irirän Yawe Anututä äma unita gera yäŋkuk; Adam, gäk de? ");
INSERT INTO iou_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yäŋirän iwetkuk; Näk gäkä piä gänaŋ kädet kuŋariri mämäka nadäŋpäŋ moräŋ kuŋatat unita umuntaŋpäŋ käbop itat yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yäwänä Anututä iwetkuk; Moräŋ kuŋatan u netä gäwerak? Gäk päya mujipi näŋpentawä yäŋ gäwetkuro u kubä nan ba? ");
INSERT INTO iou_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ude yäwänä äma unitä yäŋkuk; Ude nämo! Webe näkkät itta namiŋkuno unitä päya mujipi u namän nat yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ude yäŋirän Yawe Anututä webe iwetkuk; Imata ude tän? Ude yäwänä webe unitä iwetkuk; Näk nämo! Gämoktä yäŋnäkŋat-pewän nat yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yäwänkaŋ Yawe Anututä gämok u ŋode iwetkuk; Gäk ude täno unita tom towiwani ba ägwäri päke u täga bumik irirä, tagwän gäkä terakgän peyat. Gäk kome terak irojäŋ kuŋatpäŋ käpäpok naŋ yäpmäŋ api kwen. ");
INSERT INTO iou_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Täŋpäŋ gäkkät webekät iwan pähap täŋ yäpmäŋ api kudeŋ. Gäkŋo kodakikayekät webe täŋo kodakiniyekät iwan pähap api täŋ yäpmäŋ kuneŋ. Täŋpäŋ ukät nanik kubätä gwäkka api yeŋ jakŋirek. Täŋirän kowatawä kuroŋiken api iwen yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ude yäŋpäŋ Anututä webe uwä ŋode iwetkuk; Nanak kok itkaŋ kuŋariri komi bumta api gamet. Täŋira komi nadäŋpäŋ nanak api bäyawen. Täŋpäŋ äpkata gäripi nadäŋiri, unitä intäjukun api it gamek yäk. ");
INSERT INTO iou_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ude yäŋpäŋ Adam ŋode iwetkuk; Gäk webe täŋo man buramiŋpäŋ päya mujip nämo nakta gäwetkuro u nano unita kome terak tagwän peyat. Gäk komi piä tärek-täreki nämo api nadäwen. Komi piä täŋpäŋ ketemka api yabäŋ ahäwen. ");
INSERT INTO iou_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Täŋiri däräk-däräk ba mup waki ätu piäkaken kuräk ahäŋirä uken nanik ketem naŋpäŋ kaŋ kuŋat! ");
INSERT INTO iou_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Komi nadäŋopäŋ woŋ imätpäŋ ketem u mujipi naŋ yäpmäŋ kuŋtäŋgän kumäŋpäŋ gäk kome gänaŋ äneŋi äyäŋutpeŋ api äpmoŋpen, gäk komepäŋ täŋpani unita. Gäk komepäŋ täŋpanigän unita kumäŋpäŋä kome gänaŋ äneŋi api äpmoŋpen. ");
INSERT INTO iou_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Eruk, Adam webeni unitä ämawebe kuduptagän täŋo miŋi intäjukun yäput peŋkuk. Unita Adamtä webeni wäpi Iv yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Täŋpäkaŋ Yawe Anututä tom gupipäŋ tekta bipmäŋpäŋ Adamkät webenikätta täŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Täŋpäŋ Yawe Anututä ŋode yäŋkuk; Apiŋo äma ŋo ninin bumik äworetak. Waki ba täga unitäŋo mebäri nadäwani. Unita äma u Irit päya unitäŋo mujipi yäpmäŋpäŋ nakta baga peŋ imine. U naŋpäŋ paot-paori nämo irek. ");
INSERT INTO iou_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ude yäŋpäŋ Yawe Anututä Adam yanäpi Iden piäken itkumänopäŋ yäwat kireŋkuk. Yäwat kireŋpäŋ bibikpäŋ Adam gatäŋkuko unita bibik iŋit-iŋit epän täŋpäŋ naŋpeŋ kuŋatta yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ude yäwat kireŋpewän kuŋirän, Anututä aŋero ätu ba, päip päraŋi, kädäp mebet ikek äyäŋutpäŋ äyäŋutpäŋ täŋpani Iden piä yämaniken yepmaŋkuk. Ude täŋpäŋ Irit päya täŋo käderi täŋpipiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Täŋpäkaŋ Adamtä webeni Ivkät yanäpi täŋpäŋ kuŋarirän nanak kok itpäŋ nanak wäpi Kein bäyaŋkuk. Bäyaŋpäŋ yäŋkuk; Yawetä täŋkentäŋ namiŋirän nanak kubä bäyatat yäk. ");
INSERT INTO iou_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Täŋpäŋ mäden monäni Abel bäyaŋkuk. Bäyaŋkuko tägaŋpäŋ Abeltä sipsip watä äma ude kuŋat täŋkukonik. Täŋ Keintä ketem piä täk täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Täŋpäŋ ittäŋgän kepma kubäta Keintä piäniken nanik ketem ätu yäpmäŋ äbäŋpäŋ Anututa biŋam peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Täŋirän Abeltä udegän tom intäjukun ahäwani uken nanik ätu däpmäŋpäŋ madäŋpäŋ gakŋi yäpmäŋ äbä Anututa biŋam peŋkuk. Täŋirän, Yawetä Abel ini ba tom peŋkuko unita nadäŋirän täga täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Täŋ Kein ini ba ketem yäpuko unitawä nadäŋirän gäripi nämo täŋkuk. Anututä ude nadäŋirän Keintä bänepi wawäpäŋ iŋami dapun äpuiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","7","Ude täŋirän Yawetä Kein iwetkuk; Imata bänepka wawäpäŋ äpuitan? Gäk kudän siwoŋi täŋpeŋ kuŋariri uyaku not api täŋ gamet. Upäŋkaŋ kädet täga nämo iwareno uwä wakitä käbop itpäŋ gäk gabäŋ gäwarek. Waki uwä gepmäŋitta gäripi nadätak upäŋkaŋ gäk kehärom taŋpäŋ kaŋ irepmit. ");
INSERT INTO iou_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Eruk, Anututä ude iweränä Keintä monäni Abel iwetkuk; Nek piäken kuda yäŋ yäwänä piäken kuŋkumän. Kuŋpäŋä Keintä Monäni Abel iŋitpäŋ kumäŋ-kumäŋ utkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Täŋirän Yawetä Kein ŋode iwetkuk; Monäka Abel de? Iweränä Keintä iwetkuk; Näk nämo nadätat. Näk notnapak täŋo watä äma ba? ");
INSERT INTO iou_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yäwänä Yawetä iwetkuk; Gäk imapäŋ tän? Monäka täŋo nägät kome terak piwän kuŋo unitä näkken gera yäŋirän nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Unita tagwän gäkä terak pewa ärotak. Täŋpäŋ kome ŋo meni aŋeŋirän monäka täŋo nägät ketkaken nanik yäpmäŋpäŋ nako uken nanikpäŋ yäŋ-gäwatat. ");
INSERT INTO iou_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Eruk apiŋonitä päŋku ketem piä täŋiri ketem bureni ket nämo api ahäneŋ. Täŋkaŋ gähä kuŋat-kuŋatgän api täŋpen. ");
INSERT INTO iou_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Yäwänä Keintä Yawe iwetkuk; Kowata namitan u bäräpiinik. Näkä u täga kotanaŋi nämo. ");
INSERT INTO iou_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Gäk apiŋo piä täŋpäŋ nakna komeken nanik yäŋ-näwatan unita näk iŋamkaken nanik api paoret. Paot päŋku uken irit api täŋtäŋ kuŋaret. Täŋira, äma kubätä nabäŋ ahäŋpäŋ kumäŋ-kumäŋ api nurek yäk. ");
INSERT INTO iou_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yäwänä Yawetä iwetkuk; Ude nämo! Äma kubätä Kein utpäŋ kowata ärowaniinik api yäpek yäk. Ude yäŋpäŋ äma kubätä Kein kaŋ-ahäŋpäŋ kumäŋ-kumäŋ nämo urekta Yawetä Kein gupi terak wären täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ude täŋpäŋ Keintä Yawe iŋamiken nanik ämet päŋku kome kubä wäpi Kuŋat-kuŋatgän uken itkuk. Kome u edap äbani käda, Iden kome gägäniken itak. ");
INSERT INTO iou_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Täŋpäkaŋ Keintä webeni yäpmäŋpäŋ kuŋattäŋgän webeni nanak kok itkuk. Nanak kok itpäŋ nanaki Enok bäyaŋkuk. Kadäni uken Keintä yotpärare kodaki kubä täŋ irirän nanaki ahäŋkuko unita yotpärare u wäpi Enok yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Täŋpäkaŋ Enok u tägaŋpäŋ nanak kubä wäpi Irat bäyaŋkuk. Täŋpäŋ Irattä nanaki wäpi Mehujael bäyaŋkuk. Täŋkaŋ Mehujaeltä Metusael bäyaŋkuk. Täŋkaŋ Metusaeltä Lamek bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","20","Täŋpäkaŋ Lamek uwä webe gwaräp yäpuk, kubä wäpi Ada, kubä wäpi Sira. Täŋkaŋ Adatä nanaki Jabal bäyaŋkuk. Jabal uwä äma bipiken yottaba gänaŋ itkaŋ tom towik täkaŋ unitä intäjukun täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Täŋ monäni wäpi Jubal u kap tektek täŋo tuŋum mebäri mebäri u yäput peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Eruk, Lamek täŋo webeni kubä wäpi Sira unitä nanak kubä bäyaŋpäŋ wäpi Tubalkein yäŋ iwetkuk. Äma unitä kome änek-änek täŋo tuŋum ainpäŋ täŋpani unitäŋo intäjukun täŋkuk. Tubalkein unitäŋo wanori wäpi Nama. ");
INSERT INTO iou_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Täŋpäkaŋ kadäni kubä Lamektä webeniyat ŋode yäwetkuk; Webenayat Ada, Sira, ek juku peŋpäŋ näkŋo man ŋo nadäwun. Äma kubätä äbä nägät uränkaŋ näkä akuŋpäŋ kowata kumäŋ-kumäŋ utkut. Ba äma gubaŋi kubätä komi namiŋkuko unita kowata utpewa kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Äma kubätä Kein utpäŋä, kowata taŋi käwep nadäwek. Upäŋkaŋ äma kubätä näk nutpäŋä, kowata ärowaniinik api imet. ");
INSERT INTO iou_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Täŋpäkaŋ Adamä webenikät kuŋatgän nanak kok äneŋi itkuk. Nanak kok itpäŋ nanak kubä bäyaŋpäŋ ŋode yäŋpäŋ wäpi Set iwetkuk; Keintä Abel utkuko unitäŋo komenita Anututä nadäŋ namiŋirän nanak kubä ahäŋ namitak yäk. ");
INSERT INTO iou_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Eruk Set uwä tägaŋpäŋ nanak kubä bäyaŋpäŋ wäpi Enos yäŋ iwetkuk. Täŋpäkaŋ kadäni ukengän ämawebetä Anutu wäpi yäŋpäŋ kuŋat-kuŋat uken yäput peŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam äboriye täŋo wäpi tawaŋ ŋode kudän täwani; Anututä ämawebe pewän ahäŋkuŋo uwä Anutu ini bumik gatäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ämani bok webe bok gatäŋpäŋ man yeri nikek yäwetpäŋ wäpi taŋi Äma yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Täŋpäŋ Adamtä obaŋ 130 irirän nanaki gweki wäpi Set ahäŋkuk. Set u nani ini iŋami dapun bumik ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","5","Set ahäwänkaŋ, nani Adam äneŋi obaŋ 800 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 930 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Adam nanaki Set unitä obaŋ 105 täreŋirän nanaki tuäni wäpi Enos ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","8","Nanaki Enos u ahäwänkaŋ, nani Set uwä äneŋi obaŋ 807 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 912 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Täŋpäŋ Enos unitä obaŋ 90 täreŋirän nanaki tuäni wäpi Kenan ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","11","Kenan u ahäwänkaŋ nani Enos uwä äneŋi obaŋ 815 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 905 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Täŋpäŋ Kenan unitä obaŋ 70 täreŋirän, nanaki tuäni wäpi Mahalalel ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","14","Mahalalel u ahäwänkaŋ nani Kenan uwä äneŋi obaŋ 840 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 910 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Täŋpäŋ Mahalalel unitä obaŋ 65 täreŋirän, nanaki wäpi Jaret ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","17","Jaret u ahäwänkaŋ nani Mahalalel uwä äneŋi obaŋ 830 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 895 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Täŋpäŋ Jaret unitä obaŋ 162 täreŋirän, nanaki tuäni wäpi Enok ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","20","Enok u ahäwänkaŋ nani Jaret uwä äneŋi obaŋ 800 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 962 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Täŋpäŋ Enok unitä obaŋ 65 täreŋirän, nanaki tuäni wäpi Metusela ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","23","Metusela u ahäwänkaŋ Enoktä Anutukät kentäŋpäŋ obaŋ 300 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 365 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok uwä Anutukät kentäŋpäŋ kuŋattäŋgän paotkuk. Paotkuko uwä Anututä ini komegup ikek imagutkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Täŋpäŋ Metusela unitä obaŋ 187 it yäpmäŋ äroŋirän nanaki tuäni Lamek ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","27","Lamek u ahäwänkaŋ nani Metusela uwä äneŋi obaŋ 782 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 969 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Täŋpäŋ Lamek unitä obaŋ 182 täreŋirän nanaki tuäni ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nanaki tuäni ahäŋirän wäpi Noa yäŋ iwetpäŋ ŋode yäŋkuk; Anututä kome terak tagwän peŋkuko unita komi piä, butewaki piä pähap täŋpäŋ kuŋaritna nanak ŋonitä api niniŋ kawatäwek yäk. ");
INSERT INTO iou_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","31","Noa u ahäwänkaŋ Lamek uwä äneŋi obaŋ 595 u bämopiken äperiye nanak ätu ahäŋ yäpmäŋ kuŋirä obaŋ 777 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Täŋpäŋ Noa unitä obaŋ 500 täreŋirän nanaki yaräkubä ahäŋkuŋ. Kubä wäpi Siem, kubäwä Ham, kubäwä Jafet. ");
INSERT INTO iou_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Eruk ämatä kome terak mäyap ahäŋ yäpmäŋ äbuŋ. Täŋkaŋ äperiye bäyaŋkuŋo u Anutu täŋo nanakiyetä iŋami dapun yabäŋgärip täŋpäŋä iniken iniken gäripi terak webeniyeta yäpuŋ. ");
INSERT INTO iou_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Täŋirä, Yawetä yäŋkuk; Ämawebe u paotpaot ikek yäk. Kadäni käroŋita nämo api täŋkentäŋ yämet yäk. Näkŋo Munapiktä ämaken nämo it yäpmäŋ äroŋirän obaŋ 120 udegän itpäŋ api kumneŋ yäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Täŋpäkaŋ Anutu täŋo nanakiyetä komen äma täŋo äperiye ukät nädapi täŋirä nanakiye ahäŋkuŋ. Uwä äbot biani, inide kubä, ämik täkta kehäromi nikek. Ämawebetä äbot unitäŋo kudän pähap kaŋpäŋ biŋam pähap yäk täŋkuŋonik. Täŋpäŋ wäpi Nefirim yäŋ yäwet täŋkuŋonik. U kadäni uken, ba kämi imaka, kome terak it täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Täŋpäŋ ämatä kome terak wakiinik mebäri mebäri täŋit bänepiken nanik nadäk-nadäk wakigän nadäŋ yäpmäŋ äbäŋirä Yawetä yabäŋpäŋ-nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yabäŋpäŋ-nadäŋkaŋ imata ämawebe u gatäŋpäŋ kome terak peŋkut yäŋ nadäŋpäŋ bänepiken jägämiinik nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Jägämi nadäŋpäŋ yäŋkuk; Äma näkŋa kome terak pewa ahäŋkuŋo u kuduptagän kome terak nanik kaŋ awähut morewa! yäk. Bänepna jägämi täyak unita ämawebe ukät tom ba gwak ba barak bok, kuduptagän api däpmäŋ morewet yäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Täŋpäkaŋ Yawetä Noata nadäŋirän tägaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Täŋpäkaŋ Noa täŋo manbiŋam ŋode; Noa uwä siwoŋi kuŋat täŋkuŋonik. Ämawebe ätu päke u bämopiken, Noa-tägän kuräki, momini nämo, kuŋat täŋkukonik. Täŋkaŋ Anutukät kentäŋpäŋ kuŋat täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Täŋpäkaŋ unitäŋo nanaki yarä kubä. Kubä wäpi Siem, kubä Ham, kubä Jafet. ");
INSERT INTO iou_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Eruk, komen äma kudup Anutu iŋamiken waŋ moreŋirä kome terak ämik kädet mebäri mebäri bumta tokŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tokŋeŋirän Anututä kome kaŋirän wakiwakitä komen äma täŋo irit kuŋatkuŋari u täŋpän wakinik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Täŋpän wakinik täŋirän Anututä Noa ŋode iwetkuk; Näk komen äma api däpmäŋ paoret. Unitäŋo ämik kädettä kome terak tokŋetak unita däpmäŋ paorayäŋ. Näk bureni yäyat, ämawebe bok kome bok api awähuret. ");
INSERT INTO iou_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ude täŋpayäŋ täro unita gäk päya kehäromi kehäromi madäŋpäŋ upäŋ gäpe kubä kaŋ tä. Täŋpäŋ gäpe gänaŋ täŋkireki täŋkireŋpäŋ täŋkireŋpäŋ kaŋ pe yäk. Täŋpäŋ gupiken kukŋi kukŋi nämäkpäŋ kaŋ urumäŋpipi. ");
INSERT INTO iou_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Täŋpäŋ ŋode kaŋ tä; Järapita 140 mita, keräpinita 23 mita, käroŋinita 13 mita ude kaŋ tä. ");
INSERT INTO iou_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Täŋkaŋ pujiŋi peŋpäŋ, järapi täŋpipiŋ yäpmäŋ äroŋiri mänit kädetta bägup jopi haf mita ude piri gämoriken jop kaŋ irän. Täŋpäŋä järapi bämopiken yäma kubä kaŋ tä. Täŋpäŋ bukä yarä punin täŋkaŋ kubä gänaŋ umude kaŋ tä. ");
INSERT INTO iou_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Anututä ude yäŋpäŋ iwetkuk; Nadätan? Näk kome terak, ämawebe ba imaka irit kuŋat-kuŋat ikek kudup däpmäŋ morewa yäŋpäŋ ume gwägu taŋi api pewa ahäwek. Täŋpäkaŋ imaka kudup kome terak itkaŋ u api paotneŋ. ");
INSERT INTO iou_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Upäŋkaŋ gäkkät topmäk-topmäk kubägän täŋira gäpe gänaŋ äroŋpäŋ api iren. Täŋkaŋ u gäkŋagän nämo. Gäk ba nanakaye webeka ba äbekaye uwä gäkkät gäpe gänaŋ äro api itneŋ. ");
INSERT INTO iou_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Täŋpäŋ tom mebäri mebäri kudup yarä-yarä, ämani webeni gäkken äbäŋirä gäpe gänaŋ kaŋ yepmaŋ. Barak mebäri mebäri, tom mebäri mebäri, gämok mebäri mebäri ba gwakgwak mebäri mebäri u yarä-yarä gäkkät bok nämo paotneŋta äroŋpäŋ kaŋ irut. ");
INSERT INTO iou_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ketem mebäri mebäri in ba barak tom unitä nak täkaŋ u kämi nakta yäpmäŋpäŋ gäpe gänaŋ pewi ärowut yäk. ");
INSERT INTO iou_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Täŋpäkaŋ Noatä Anututä man iwetkuko udegän buramiŋpäŋ täŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Eruk Yawetä Noa ŋode iwetkuk; Gäk äma äbot ŋo bämopiken siwoŋi kuŋariri gabäwa tägatak unita gäkkät äbotkaye in kudup gäpe gänaŋ äroŋ morewut! ");
INSERT INTO iou_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Gäpe gänaŋ ärowayäŋä tom nakta nämo yäjiwärani mebäri mebäri ämani 7, webeni 7 ude kaŋ yäpmäŋ äro. Ba tom nämo nakta yäjiwärani mebäri mebäri ämani yarä webeni yarä kaŋ yäpmäŋ äro. ");
INSERT INTO iou_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Täŋkaŋ barak mebäri mebäri udegän, ämani 7 webeni 7 ude yäpmäŋpäŋ pewi gäkkät bok gäpe gänaŋ kaŋ äroŋ morewut. Imaka mebäri mebäri irit kuŋat-kuŋat ikektä nämo paotneŋta ude kaŋ tä. ");
INSERT INTO iou_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kepma 7 täreŋirän näkä yäŋira iwän pähap api tawek. Kome terak iwän taŋ yäpmäŋ kuŋtäyon kepma bipani 40 ude api tärewek. Iwän ude taŋirän imaka irit kuŋat-kuŋat ikek kome terak pewa ahäŋkuŋo u kuduptagän api däpmäŋ morewet. ");
INSERT INTO iou_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ude iweränkaŋ Noa Yawetä man iwetkuko uwä buramiŋpäŋ täŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Täŋpänkaŋ Noa täŋo obaŋ 600 ude täreŋirän gwägu pähap kome terak tokŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Täŋirän Noa ume tokŋeŋkuko u irepmitta webeni nanakiye ba äbekiye kudup yäŋ-yäkŋat yäpmäŋ gäpe gänaŋ äroŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Täŋirän tom nakta nämo yäjiwärani ba nämo nakta yäjiwärani ba barak, gämok, gwakgwak imaka mebäri mebäri ämani bok webeni bok Noaken äbuŋ. Äbäŋirä Anututä Noa iwetkuko udegän yäŋ-yäkŋat yäpmäŋ gäpe gänaŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gäpe gänaŋ ärowäkaŋ kepma 7 täreŋirän kome terak gwägu pähap tokŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa täŋo obaŋ 600 unitäŋo komepak yarä kepma 17 kadäni uken gwägu pähap kome gänaŋ naniktä ume dapuri uken bäräŋeŋ ahäŋirä kunum gänaŋ nanik iwän pähap taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Taŋ yäpmäŋ kuŋtäyon kepma bipani 40 ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Täŋpäkaŋ kepma iwän pähap yäput peŋpäŋ taŋkuko ugän Noa, webeni nanakiye Siem, Ham, Jafet ukät webeniyekät kudup gäpe gänaŋ äroŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Täŋpäŋ tom ägwäri ba yepmäŋ towiwani mebäri mebäri ba gämok gwakgwak mebäri mebäri ba barak mebäri mebäri ba imaka piri nikek u kuduptagän bok äro itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bureni, imaka irit kuŋat-kuŋat ikek mebäri mebäri kudup, yarä-yarä Noaken äbäŋpäŋ gäpe gänaŋ äroŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anututä Noa iwetkuko udegän äroŋ moreŋkuŋ. Ämani bok, webeni bok äroŋkuŋ. Äroŋ moreŋirä Yawetä gäpe täŋo yäma täŋpipiŋpäŋ täŋkehärom taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Täŋpänkaŋ kepma 40 udeta gwägu kome terak tokŋeŋ yäpmäŋ äroŋirän gäpe u punin oraŋ yäpmäŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bureni, kome terak ume umuri pähap tokŋeŋirän gäpetä gwägu terak kuŋ abäŋ täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Gwägu uwä kome terak bumta tokŋeŋpäŋ pom käroŋi käroŋi kuduptagän umetä uwäk täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ume gwägutä pom miŋgupi 7 mita ude irepmitkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ude täŋpäŋ imaka kome terak itkuŋo u kuduptagän paot moreŋkuŋ. Barak, tom yepmäŋ towiwani ba ägwäri, gwak, gämok ba ämawebe u kuduptagän kumäŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yarägän nämo paotkuŋ. Nämo, imaka mänit yäpmäk-yäpmäk ikek kuduptagän-inik kome terak kuŋarani u paotkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Bureni, Anututä imaka irit kuŋat-kuŋat ikek kome terak irani kuduptagän, äma ba tom, gwak kejima, barak u kudup awähutkuk. Noakät gäpe gänaŋ itkuŋo ugänpäŋ yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Täŋpäkaŋ ume gwägu pähap kome punin terak tokŋeŋ irirän kepma 150 ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Täŋpäkaŋ Anututä Noakät tom ägwäri ba towiwani päke ukät gäpe gänaŋ itkuŋo unita kudup nadäŋ yämiŋkuk. Nadäŋ yämiŋpäŋ mänit pähap iniŋ kireŋpewän piäŋirän gwägu pähap äpuk. ");
INSERT INTO iou_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Täŋpäŋ ume bian kome gänaŋ nanik abuŋo u kawuk taŋkuŋ. Ba iwän taŋkuko u imaka, däkŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Täŋpäŋ gwägu taŋi u äneŋi kwikinik kwikinik wädäŋ äpmoŋkuk. Kepma 150 ude täreŋirän ume gwägutä ätu wädäŋ äpmoŋirän gäpe u Ararat Pom terak däpän yewäpäŋ itkuk. Kadäni gäpetä pom terak itkuko u komepak 7 unitäŋo kepma 17. ");
INSERT INTO iou_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Irirän ume gwägu pen wädäŋ äpmoŋirän komepak 10 unitäŋo kepma 1 kadäni uken pom miŋgupi kwawak pat yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Eruk äneŋi kepma 40 ude täreŋirän Noatä gäpe täŋo mänit kädet bian täŋkuko u dätkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Dätpäŋ Noa barak kubä yägu bumik pewän uken-uken piäŋ kuŋat irirän ume gwägu kawuk taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Täŋpäkaŋ Noatä kome terak ume itak ba nämo itak yäŋ kaŋpäŋ nadäkta känaräm kubä tewän kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tewän päŋku känaräm u maŋira yäŋkaŋ gwägu pen parirän täŋpän waŋkuŋ. Täŋpän wawäpäŋ äneŋi äyäŋutpeŋ Noaken äbuk. Äbäŋirän Noatä ket kewarirän keri terak maŋitkuk. Maŋiränkaŋ yäpmäŋ gäpe gänaŋ äbuk. ");
INSERT INTO iou_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Täŋpäŋ kepma 7 itkaŋ känaräm u äneŋi tewän kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tewän yäpmäŋ päŋku kuŋattäŋgän bipäda äneŋi äyäŋutpeŋ äbäŋirän kaŋkuk; Olip päya pähämi kodaki kubä meniken irirän kaŋkuk. Ude kaŋpäŋä Noatä ŋode nadäŋkuk; Ume wädäŋ äpmoŋirän kome kwawak itak yäŋ nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Täŋpäŋ kepma 7 itkaŋ känaräm u äneŋi tewän kuŋkuk. Eruk tewän kuŋkuko uwä äneŋi nämo äbuk. ");
INSERT INTO iou_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa obaŋ 601 unitäŋo komepak kubä täŋo kepma 1 täŋirän kome terak ume kawuk taŋkuk. Täŋpäŋ Noatä gäpe täŋo medäp därämutpäŋ kaŋkuk; Kome terak ume kawuk taŋirän. ");
INSERT INTO iou_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ätukät itpäŋä komepak yarä unitäŋo kepma 27 täŋirän okä kudup kawuktaŋ moreŋpäŋ patkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kometä ude kawuk taŋirän Anututä Noa iwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Gäk, webeka ba nanakaye äbekaye gäpe gänaŋ naniktä yäman aput. ");
INSERT INTO iou_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tom, barak, gämok, gwakgwak u imaka yepmaŋpi äput. Yepmaŋpi äpäŋpäŋ bäyaŋ weŋpäŋ kome tokŋewut yäk. ");
INSERT INTO iou_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ude iwerirän Noakät webeni nanakiye äbekiye äpuŋ. ");
INSERT INTO iou_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ba tom kome terak kuŋarani kudup, barak, gämok, gwakgwak u kuduptagän gäpe gänaŋ naniktä äbot ini-ini tawaŋ äpuŋ. ");
INSERT INTO iou_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Äpäŋ moreŋpäŋä Noatä Yawe iniŋ oretta mobä bukä kubä täŋpäŋ tom ba barak nakta nämo yäjiwärani kudup ukät nanik ätu yäpmäŋpäŋ ijiŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ijiŋ imiŋirän Yawetä käbäŋi säkgämän nadäŋpäŋ bänepitä ŋode nadäŋkuk; Ämata yäŋpäŋ kome terak tagwän wari nämo api täŋpet. Äma nanakinik kentä bänep nadäk-nadäki wakigän api täŋ yäpmäŋ kuŋatneŋo upäŋkaŋ täŋkuro udegän näk imaka imaka kuŋat-kuŋat ikek kuduptagän äneŋi nämoinik api däpet. ");
INSERT INTO iou_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nämo! Kome täŋo kadäni it yäpmäŋ ärowayäŋ täyak udegän piŋpäŋ naknak, mänit ba komi, iwän ba edap kadäni, kepma bipani u pen api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Täŋpäŋ Anututä Noakät nanakiye man yeri nikek ŋode yäwetkuk; In nanak weŋbäyak täŋirä kome kaŋ tokŋewän. ");
INSERT INTO iou_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Täŋpäkaŋ tom ägwäri, barak, gämok gwakgwak kome terak kuŋat täkaŋ u ba gwägu tom u kuduptagän in ketjinken peyat. Ude täŋira inta umun pähap nadäŋpäŋ api kuŋatneŋ. ");
INSERT INTO iou_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Imaka irit kuŋat-kuŋat ikek u nakta tamitat. Bian tokän peŋ tamiŋkuro udegän apiŋo imaka imaka kudup nakta tamitat. ");
INSERT INTO iou_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Upäŋkaŋä tom nägäri nämo piwä kwani u nämo näneŋ, nägät u irit täŋo kehäromi nikek unita. ");
INSERT INTO iou_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nadäkaŋ? Nägät pikpik täŋo kowata u näkä api däpmäŋ tärewet. Äma kubätä noripak kubä ureko uwä kowata näkä bureni-inik api täŋpet. Ba tom kubätä äma kubä ureko uwä kowata udegän näkä api däpmäŋ tärewet. ");
INSERT INTO iou_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","U imata, äma kubä täŋo iŋam dapun nämo. Anutu näkŋa bumik täŋpani unita äma kubätä noripak kubä utpewän nägäri piwän kuneŋo unitäŋo kowata äma-tägän udegän äma u utpewän nägäri api piwän kuneŋ. ");
INSERT INTO iou_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Täŋpäkaŋ Noa, intäwä yeri nikek täŋpäŋ bäyaŋ weŋirä kome kaŋ tokŋewän. ");
INSERT INTO iou_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Anututä ude yäŋpäŋ Noakät nanakiye ŋode yäwetgän täŋkuk; ");
INSERT INTO iou_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Näkä apiŋo in ba yerijiyekät bok, topmäk-topmäk täyat. ");
INSERT INTO iou_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Täŋpäŋ imaka kome terak irit kuŋat-kuŋat ikek inkät penta gäpe gänaŋ naniktä äpuŋo, barak, tom ägwäri ba yepmäŋ towiwani u kudup inkät topmäk-topmäk täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Näk inkät topmäk-topmäk täyat uwä ume putputtä imaka kome terak kuŋat täkaŋ ba kome ini äneŋi nämoinik api awähuret. ");
INSERT INTO iou_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Anututä ude yäŋpäŋ äneŋi kubä ŋode yäwetgän täŋkuk; Näk inkät imaka kuŋat-kuŋat ikek kuduptagän inkät bok it täkaŋ, ba imaka kuduptagän kämi ahäkta yäwanikät bok, topmäk-topmäk täyat unitäŋo kudän ŋode; ");
INSERT INTO iou_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Näkŋo gämok wära kudän gubam terak peyat. Peyat u kaŋkaŋ topmäk-topmäk komekät täŋkuro unita kaŋ juku piwut. ");
INSERT INTO iou_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Näkä täŋpewa gubam gwägätpäŋ gämok wära ahäŋirän näkä inkät ba imaka irit kuŋat-kuŋat ikek mebäri mebäri ukät topmäk-topmäk täŋkuro u api nadäwet. Nadäŋira ume putputtä kome terak imaka irit ikek kudup wari nämo api däpek. ");
INSERT INTO iou_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Täŋpäŋ gubam terak gämok wära parirän kaŋpäŋ kome terak imaka irit kuŋat-kuŋat ikek inkät topmäk-topmäk tärek-täreki nämo täŋkuro u api nadäwet. ");
INSERT INTO iou_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Anututä ude yäŋpäŋ Noa ŋode iwetkuk; Kome terak imaka irit kuŋat-kuŋat ikek in kuduptagänta topmäk-topmäk täyat unitäŋo kudän u api kak täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa nanakiye gäpe gänaŋ naniktä äpuŋo unitäŋo wäpi Siem, Ham, Jafet. Täŋkaŋ Ham uwä Kenan täŋo nani. ");
INSERT INTO iou_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa nanakiye yaräkubä uken naniktä komen äma äbori äbori ahäŋ patpat täŋpäŋ komeni komeni it yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa uwä ketem piä täkta, äma ude itkuk. Täŋpäŋ Noa u yäput peŋpäŋ päya kubä wäpi wain, u piä täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Täŋpäkaŋ kämiwä wain ume yäpmäŋpäŋ naŋkaŋ täŋguŋguŋ taŋpäŋ yottaba gänaŋ moräŋ patkuk. ");
INSERT INTO iou_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Moräŋ parirän Kenan täŋo nani Ham unitä nani Noa moräŋ parirän kaŋpäŋ noripakiyat äpmo biŋam yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yäweränkaŋ Siem kenta Jafet tek kubä yäpmäŋpäŋ mädeni käda ämetpäŋ yäpmäŋkaŋ nan moräŋ parirän käde yäŋ nadäŋpäŋ mäde kädagän päro ämet imiŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Täŋpäŋ Noa u waintä urirän patkuk kädagän akuŋpäŋ nanaki gweki Hamtä imaka täŋ imiŋkuko unita nadäŋpäŋ ŋode yäŋkuk; ");
INSERT INTO iou_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tagwäntä Kenan terak kaŋ ärowän! U äpaniinik itkaŋ noriye täŋo piä täŋ yämiktagän. ");
INSERT INTO iou_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ude yäŋpäŋ äneŋi ŋode yäkgän täŋkuk; Yawe, Siem täŋo Anutu u iniŋ oretna! Täŋkaŋ Kenan u Siem täŋo piä täŋ imiktagän. ");
INSERT INTO iou_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Täŋpäkaŋ Anututä Jafet täŋkentäŋ imiŋirän komeni taŋigän kaŋ pipiyäwän. Täŋirän Jafet täŋo yeriniyekät Siem täŋo yeriniye bok kaŋ irut. Täŋpäkaŋ Kenan täŋo uwä piä täŋ imiktagän. ");
INSERT INTO iou_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Täŋpäkaŋ gwägu pähaptä paorirän Noa uwä äneŋi obaŋ 350 ude it yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kuŋarirän obaŋ 950 ude täreŋirän kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Gwägu pähaptä paoränkaŋ u punin terak Noa nanakiye Siem, Ham, Jafet unitäŋo nanakiye ahäŋkuŋ. Äma yaräkubä unitäŋo manbiŋam ŋode; ");
INSERT INTO iou_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet täŋo nanakiye wäpi ŋode; Gome, Magok, Madai, Javan, Tubal, Mesek ba Tiras. ");
INSERT INTO iou_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gome täŋo nanakiye wäpi ŋode; Askenas, Rifat, Togama. ");
INSERT INTO iou_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan täŋo nanakiye wäpi Elisa, Tasis. Täŋkaŋ ämawebe Saipras kenta Dodan komeken nanik u imaka, Javantä äbotken nanik. ");
INSERT INTO iou_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Täŋkaŋ äbot u bäyaŋ weŋirä äbot mäyap ahäŋ yäpmäŋ kuŋkuŋ. Äbot mäyap unitäŋo komeni ba mani kotäk inigän inigän. U ini buap-buap gwägu dubiniken ba kome kubäkubä gwägu bämopiken ittäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham täŋo nanakiye wäpi ŋode; Kus, Isip, Libia, Kenan. ");
INSERT INTO iou_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus täŋo nanakiye wäpi ŋode; Seba, Havila, Sapta, Rama, Sapteka. Rama uwä nanakiyat wäpi Seba kenta Dedan. ");
INSERT INTO iou_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus uwä Nimrot täŋo nani. Nimrot u tägaŋpäŋ äma kehäromi, wäpi biŋam nikek täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yawetä täŋkentäŋ imiŋirän tom däpmäkta intäjukun ämata itkuk. Mebäri unita äma kehäromi ätuta U Nimrot bumik, Yawetä täŋkentäŋ imiŋirän tom däpani ärowani itkuko u yäŋ yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Täŋpäŋ Nimrot unitä Babilonia kome taŋiken yotpärare mäyap täŋkuk. Intäjukunä yotpärare ŋode täŋkuk; Babel, Erek, Akat, Kalne. ");
INSERT INTO iou_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Eruk, Babilonia kome peŋpeŋ Asiria komeken kuŋkuk. Kome uken yotpärare wäpi Ninive, Rehobot, Kala, Resen täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen yotpärare uwä Ninive Kala yotpärare bämopiken itak. U yotpärare pähap. ");
INSERT INTO iou_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isip täŋo yeri äbot-äbot ŋode ahäŋkuŋ; Lidia nanik, Anam nanik, Lehap nanik, Naptu nanik, ");
INSERT INTO iou_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarus nanik, Kaslu nanik, Krit nanik. Krit naniktä Filistia nanik ahäŋ patpat täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Kenan nanaki wäpi Saidon intäjukun ahäŋkuk. Saidon ahäŋkuko u punin terak Kenan täŋo yeri äbot ätu wäpi ŋode ahäŋkuŋ; Hit, Jebus, Amo, Gilgas, Hivi, Alka, Sini, Alvat, Semar, Hamat. Äbot ude ahäŋ yäpmäŋ kuŋkuŋ. Kadäni u punin terak Kenan nanakiye täŋo äbori äbori uken-uken kuŋtäŋpä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kuŋ täŋpä kuŋkuŋo unita Kenan nanakiye äbori äboritä kome taŋi tokŋeŋ moreŋkuŋ. Kome taŋi täŋpäŋ Saidon kometä päŋku kome ban ätu unitäŋo baga terak täreŋkuk. Kome ban u wäpi ŋode; Geral, Gasa, Sodom, Gomora, Atma, Seboim, Lasa u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Eruk tawaŋ it yäpmäŋ äbäkaŋ u Ham nanakiye. Unitäŋo buap, mani kotäk, komeni, äbori u wäpi wäpi terak tawaŋ pewani. ");
INSERT INTO iou_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafet monäni wäpi Siem u imaka, nanakiye ätu ahäŋkuŋ. Siem u Ebe nanakiye täŋo orani. ");
INSERT INTO iou_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siem nanakiye wäpi ŋode; Elam, Asu, Apaksat, Lidia, Aram. ");
INSERT INTO iou_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram nanakiye uwä ŋode; Us, Hul, Geta, Mas. ");
INSERT INTO iou_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apaksat uwä Sela täŋo nani. Selawä, Ebe täŋo nani. ");
INSERT INTO iou_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe täŋo nanaki yarä ahäŋkumän. Kubä wäpi Pelek. Unitäŋo kadäniken ämawebetä äma äbot-äbotta kome yäpmäŋ daniŋkuŋo unita nanitä wäpi Pelek yäŋ iwetkuk. Monäni wäpi Joktan. ");
INSERT INTO iou_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Joktan unitäŋo nanakiye wäpi ŋode; Almodat, Selep, Hasamawet, Jera, Hadoram, Usal, Dikla, Obal, Abimael, Seba, Ofi, Havila ba Jobap. Äma u kudup Joktan nanakiye. ");
INSERT INTO iou_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Siem äboriye unitäŋo kome pom-pom ikek, edap dapuri abani käda itkuk. Mesa kome yäput peŋpäŋ päŋku Sefa täretak. ");
INSERT INTO iou_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tawaŋ it yäpmäŋ abäkaŋ u Siem nanakiye. Unitäŋo buap, mani kotäk, komeni, äbori u wäpi wäpi terak tawaŋ pewani. ");
INSERT INTO iou_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Äma tawaŋ it yäpmäŋ äpäkaŋ ŋo u Noa nanakiye äbori äbori ahäŋkuŋo udegän. Gwägu pähap paotkuko u punin terak äbot u naniktä äbori äbori ba kome deken deken kuŋtäŋpä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kadäni uken ämawebe komeni komeni man kotäk kubägän yäk täŋkuŋonik. Ba imaka wäpi wäpi uwä kudup kubägän yäk täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Täŋpäŋ ämawebe kome dapuri äpmoŋpanikentä bäyaŋ weŋtäŋ äbäŋkä awaŋ kubä wäpi Babilonia kome ahäŋpäŋ uken yotpärare täŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Täŋpäŋä yot täna yäŋkaŋ yäŋpäŋ-nadäk ŋode täŋkuŋ; Eruk, gäŋpäŋ täŋpena kwäkä yäwäkaŋ kädäpken ijiŋpena kehärom tawut yäk. Ba gäŋ kehärom täwani yäpurärätpäŋ däpmäŋ gatäkta kome yäpmäki kome gänaŋ nanik upäŋ kaŋ däpmäŋ gatäna yäk. Ude täŋkuŋo uwä äma kome ätuken naniktä yot mobäpäŋ täk täŋkuŋo u nämo täŋkuŋ. Ba mobä yäpurärätpäŋ däpmäŋ gatäkta gäŋpäŋ täk täŋkuŋo u nämo täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Täŋpäkaŋ äma unitä yäŋpäŋ-nadäk ŋode täŋkuŋ; Eruk yotpärare taŋi kubä täna. Täŋkaŋ yotpärare u bämopiken yot käroŋi kubä yäpurärätpäŋ täŋtäŋ äroŋitna miŋgupitä kunum kaŋ yäpurän! Ude täŋitna wäpnin biŋam nikek itpäŋ komeni komeni kuŋtäna kuneŋtawä yäk. ");
INSERT INTO iou_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ude yäŋpäŋ yotpärare pähap ba yot käroŋi u täŋ irirä Yawetä yabäwayäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Päpä yabäŋpäŋ Yawetä yäŋkuk; Bureni, ŋowä äma äbot kubägän, mani kotäk kubägän unita yot käroŋi ŋo täŋpäŋä mäden imaka imaka täna yäŋkaŋ tägagän api täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Eruk, nin äpmoŋpäŋ man kubägän yäk täkaŋ u awähutpena manta täŋguŋguŋ kaŋ taŋput yäk. ");
INSERT INTO iou_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yawetä ude yäŋpäŋ äma äbot pähap u yäpmäŋ daniŋpäŋ yepmaŋpän yotpärare pähap täŋ itkuŋo u peŋpeŋ komeni komeni kuŋtäŋpä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Täŋpäkaŋ Yawetä kome uken mani kotäk kubägän yäpmäŋ daniŋpewän imätpeŋ komeni komeni kuŋ moreŋkuŋo unita kome, yot käroŋi täŋkuŋo unitäŋo wäpi Babel yäŋ iwetkuk. Babel mebäri u yäŋuruk-uruk pähap. ");
INSERT INTO iou_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Siem täŋo äbekiye oraniye täŋo manbiŋam ŋode; Gwägu pähap paoränkaŋ obaŋ yarä täreŋirän Siem uwä obaŋ 100 täŋkuk. Obaŋ 100 täŋirän unitäŋo nanaki tuäni Apaksat ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apaksat ahäwänkaŋ obaŋ 500 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apaksat uwä obaŋ 35 täreŋirän nanaki tuäni Sela ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela ahäwänkaŋ Apaksat u obaŋ 403 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela uwä obaŋ 30 täreŋirän nanaki tuäni Ebe ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebe u ahäwänkaŋ Sela u obaŋ 403 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebe uwä obaŋ 34 täreŋirän nanaki tuäni Pelek ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelek ahäwänkaŋ Ebe u obaŋ 430 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek uwä obaŋ 30 täreŋirän nanaki tuäni Reu ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu ahäwänkaŋ Pelek u obaŋ 209 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu uwä obaŋ 32 täreŋirän nanaki tuäni Seruk ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruk ahäwänkaŋ Reu u obaŋ 207 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk uwä obaŋ 30 täreŋirän nanaki tuäni Naho ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naho ahäwänkaŋ Seruk u obaŋ 200 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naho uwä obaŋ 29 täreŋirän nanaki tuäni Tera ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera ahäwänkaŋ Naho u obaŋ 119 it yäpmäŋ äroŋirän u bämopiken äperiye nanak ätu ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera uwä obaŋ 70 täreŋirän nanakiye ŋode ahäŋkuŋ; Abram, Naho, Haran. ");
INSERT INTO iou_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Eruk Tera täŋo manbiŋam ŋode; Tera nanakiye Abram, Naho, Haran ahäŋkuŋ. Täŋpäŋ Haran täŋo nanaki Lot ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran nani wäpi Tera u pen irirän Haran uwä ini ahäwani yotpärare wäpi Ur uken kumbuk. Ur u Kaldia komeken itak. ");
INSERT INTO iou_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Täŋpäŋ Abram kenta Naho webe yäpumän. Abram webeni wäpi Sarai yäpuk. Täŋpäŋ Naho webeni wäpi Milka yäpuk. Naho webeni u Haran täŋo äperi. Haran uwä äperiyat Milka kenta Iska. ");
INSERT INTO iou_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Täŋpäŋ Abram webeni Sarai äruŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Täŋpäŋ Teratä nanaki Abram, Abram webeni wäpi Sarai, orani Haran täŋo nanaki wäpi Lot, u kudup yäŋ-yäkŋat yäpmäŋ Kenan komeken kuŋkuŋ. Kome it täŋkuŋo u wäpi Ur, Kaldia kome bämopiken itak u peŋpeŋ kädet moräki yäput peŋkuŋ. Kuŋkä kädet bämopiken Haran komeken ahäŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Täŋpäkaŋ Tera u obaŋ 205 it yäpmäŋ äroŋpäŋ Haran komeken kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Eruk Yawetä Abram ŋode iwetkuk; Gäk komeka, notkaye, äbotkaye u yepmaŋiri kome gäwoŋärewayäŋ täyat uken päŋku kaŋ it. ");
INSERT INTO iou_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Täŋpäŋ näkä iron täŋ gamiŋira äbotkayetä äbot pähap api itneŋ. Ude täŋ gamiŋira gäkä wäpka biŋam ikek itkaŋ ämawebe mäyap api täŋkentäŋ yämen. ");
INSERT INTO iou_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Äma iron täŋ gaminayäŋ täkaŋ uwä näkä udegän iron api täŋ yämet. Täŋ kubätä gäk waki täŋ gameko uwä näkä udegän waki api täŋ imet. Täŋpäkaŋ gäkä terak ämawebe äbori äbori komeni komeni kuduptagäntä iron pähap api yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Eruk Abram obaŋ 75 täreŋirän Yawetä iwetkuko ude man buramiŋpäŋ komeni wäpi Haran peŋpeŋ kuŋkuk. Inigän nämo kuŋkuk. Webeni Saraikät gweki täŋo nanaki Lot ba piä ämaniye tuŋumi Haran itkaŋ yäpuŋo päke u kudup yäŋ-butuwänkaŋ Kenan kome taŋi u kuna yäŋpäŋ komeni Haran peŋpeŋ kuŋkuŋ. Kädet käroŋi kuŋtäŋgän kome taŋi Kenan uken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","7","Abram Kenan kome kuŋtäŋgän kome täpuri kubä wäpi Sekem uken ahäŋkuŋ. Kome uken päya taŋi kubä äma kubä wäpi Moretä bian piwani itak. Kadäni uken ämawebe Kenantä äbotken nanik uken itkuŋopäŋ Yawetä Abram ahäŋ imiŋpäŋ iwetkuk; Nanakjiye ba äbekjiye orajiyeta kome ŋo api yämet yäk. Man ude iwetkuko unita Abramtä Yaweta yäŋpäŋ mobä bukä kubä täŋkuk, Yawetä ahäŋ imiŋkuko unita. ");
INSERT INTO iou_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ude täŋpäŋ Sekem kome u peŋpeŋ äneŋi kuŋtäŋgän edaptä äbani käda pom u dubiniken yottaba täŋpäŋ itkuk. Betel kome edaptä äpmoŋpani käda, Ai kome edaptä äbani käda u bämopiken itkuk. Täŋpäŋ kome uken Yaweta yäŋpäŋ mobä bukä kubä täŋpäŋ Yaweken yäŋapiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Täŋpäŋ äneŋi akumaŋ Negev komeken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Eruk kadäni uken kome Abramtä itkukken uwä nakta jop itkuŋ. Ketem nämoinik unita Isip komeken itpäŋ-nadäkta kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Eruk Isip kome keräp taŋpäŋ webeni Sarai ŋode iwetkuk; Nadätat yäk. Gäk webe säkgämän gabätat unita Isip ämatä gabäŋpäŋ api yäneŋ; Ai, ŋo webeni yäŋ nadäŋkaŋä näk kumäŋ-kumäŋ nutkaŋ gäk api gabäŋ koreneŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ude api yäneŋo unita ŋode kaŋ yäwet; Näk unitäŋo wanori yäŋ kaŋ yäwet yäk. Gäk ude yäweriwä gäka yäŋpäŋ näk nabäŋ koreŋpäŋ täga käwep api täŋ namineŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ude yäŋpäŋ kuŋtäŋgän Abram Isip komeken ahäŋkuk. Ahäŋirän Isip ämatä Sarai u säkgämäninik kaŋkaŋ kaŋgärip täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Täŋpäkaŋ Isip täŋo intäjukun äma Fero unitäŋo piä ämaniye ätutä Sarai u kaŋkaŋ päŋku Fero biŋam iwetkuŋ. Ude iweräwä Ferotä yäwerän Sarai imagut yäpmäŋ Ferotä ini yotken äroŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ferotä yotken äroŋirän kaŋpäŋ Saraita yäŋpäŋ Ferotä Abram iron täŋ imiŋkuk. Sipsip, bulimakau, doŋki ämani webeni, epän ämawebekät kamel ätu ude imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Upäŋkaŋ Abram webeni Saraita yäŋpäŋ Yawetä Ferokät äboriye käyäm wakiwaki pewän ahäŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ude ahäŋ yämiŋirän Ferotä Abramta yäŋpewän äbänpäŋ ŋode iwetkuk; Wa! Abram, jide täŋ namin? Ŋo webena yäŋ imata nämo näwetkun? ");
INSERT INTO iou_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Imata ŋo wanotna yäŋ näwetpewi webenata yäput? Eruk, webeka ŋo imagut yäpmäŋ ku! ");
INSERT INTO iou_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Täŋpäŋä Ferotä piä ämaniye yäwet-pewän äbä Abram iwetkuŋ; Webeka tuŋumka kudup yäŋporiŋ yäpmäŋ ku! yäŋ iwetkuŋ. Iweräwä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Täŋpäŋ Abramtä webeni, Lot ba tuŋumi kudup yäŋ-butuwänkaŋ Isip kome peŋpeŋ Negev komeken äneŋi äroŋkuŋ. ( ");
INSERT INTO iou_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram u Isip kome itkukken tom towiwani, golkät siliwa moneŋ mäyap yäpmäŋpäŋ tuŋum äma täŋkuk.) ");
INSERT INTO iou_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Eruk, Negev kome u peŋpeŋ kuŋtäŋgän Betel kome bian itkukken u ahäŋpäŋ itkuk. Betel kome, Ai kome bämopiken bian yottaba täŋpäŋ mobä bukä täŋkukken u kuŋpäŋä Yawe iniŋ oretkuk. ");
INSERT INTO iou_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Täŋpäkaŋ Lot Abramkät kuŋatkumäno u imaka, sipsip, bulimakau ba yot tom gupipäŋ täŋpani mäyap it imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Täŋpäŋ Abram kenta Lot bok ude irirän yawakiye mäyapinik ahäŋirä tomtä nakta ketemta wäyäkŋeŋkuŋo unita bok itnaŋi nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ude täŋpäŋ Abram täŋo piä ämaniyekät Lot täŋo piä ämaniye bämopiken yäŋwawak pewä ahäŋkuk. (Täŋpäkaŋ kadäni uken Kenan täŋo äboriyekät Peres täŋo äboriyetä kome mähem täŋpäŋ itkuŋ.) ");
INSERT INTO iou_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yäŋwawak yäŋtäko Abramtä Lot ŋode iwetkuk; Nek ba piä ämaniye bämopninken ämik man ahäŋirän nämo tägatak. Nek yanani. ");
INSERT INTO iou_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Eruk käyan? Kome pähap pätak u! Unita yäpmäŋ danida yäk. Gäkä bure käda kwayäŋ nadäwiwä näkä käpmäk käda api yäpet. Täŋ gäkä käpmäk käda kwayäŋ nadäwiwä näkä bure käda api yäpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Eruk Lot dapun ijiŋpewän kwäpäŋ Jodan awaŋ pähap, ume täga nikek. Kome uwä Iden piä Yawetä piwani ude bumik, ba Isip kome täga, Soa kome käda itak u bumik. (Kadäni uwä Yawetä Sodom Gomora yotpärare u nämo däpukken Jodan kometä ude itkuk.) ");
INSERT INTO iou_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Täŋpäŋ Lottä Jodan awaŋ päke u inita korekta yäŋkuk. Ude yäŋpäŋ edap äbani käda u kuŋkuk. Ude täŋkuko uwä Abram kenta Lot ini-ini päŋku itkumän. ");
INSERT INTO iou_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Täŋpäkaŋ Abram Kenan komeken pen irirän Lottä Jodan kome täŋo yotpärare itkuŋo u kubäwä wäpi Sodom u dubiniken kuŋpäŋ yot täŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom uwä mähemiwä wakiinik. Imaka Yawetä momi yäŋ nadäŋkuko u bumta täŋtäŋ kuŋat täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Eruk Lot Abram teŋpeŋ kuŋirän Yawetä Abram ŋode iwetkuk; Gäk bämop ŋo itkaŋ kome ŋo ijiŋ pärewat. ");
INSERT INTO iou_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Kome kudup käyan u gäka ba gäkŋo äbotkaye mäden ahänayäŋ täŋo unita biŋam. ");
INSERT INTO iou_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Näkä yäŋpewa äbotkaye keŋkeŋ jiraŋ ude api ahäneŋ. Äma kubätä keŋkeŋ jiraŋ täga daniweko uwä äbotkaye mäden ahänayäŋ täŋo u imaka, täga daniwek. Upäŋkaŋ täga nämo, u jiraŋinik api ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Eruk akumaŋ päŋku kudup yabäŋ yäwattäŋ ku. Kome päke ŋo gäkagän ganiŋ kiretat yäk. ");
INSERT INTO iou_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yawetä Abram ude iweränkaŋ tuŋumi kuduptagän yäpmäŋkaŋ kuŋtäŋgän Hebron kome päya äma kubä wäpi Mamretä piwani u dubiniken päŋku ugän itkuk. Päŋku u itkaŋ Yaweta yäŋpäŋ mobä bukä kubä täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","7","Kadäni uken äma Sodom, Gomora, Atma, Seboim ba Soa komeken naniktä Elam kome täŋo intäjukun äma wäpi Kedolaomi unitäŋo gämoriken obaŋ 12 ude it yäpmäŋ äbäŋkä eruk obaŋ 13 uken gaŋani pähap nadäŋpäŋ intäjukun ämaniye wäpi Bela, Bisa, Sinap ba Semebetä bänep kubägän täŋpäŋ Kedolaomi, komi piä täŋ yämiŋkuko ukät ämik pewä ahäkta yäŋpäŋ-nadäŋkuŋ. Ude täŋirä obaŋ 14 uken Kedolaomi, Elam kome täŋo intäjukun äma unitä kome ätu täŋo intäjukun ämakät äboriyeta gera yäŋpewä ämikken täŋkentäŋ imikta äbuŋ. Täŋkentäŋ imikta äbuŋo u Babilonia, Elasa ba Goim kome unitäŋo intäjukun äma wäpi Amrafel, Ariok, Tidal. Eruk intäjukun äma ukät äboriye äbäkaŋ pengän kome ätukät ämik täŋpäŋ kehäromini yäpmäŋ äpuŋ. Äma äbot-äbot kehäromini yäpmäŋ äpuŋo u wäpi Refa, Sus, Em, Hol. Täŋkaŋ kome ŋodeken ämik täŋkuŋ; Asterot-Kanaim, Ham, Save-Kiriataim, ba Sei kome täŋo pomkentä päŋku Elparan, kome jopi dubiniken itak u. Täŋpäkaŋ äbot ätu u kehäromini yäpmäŋ äpäŋkaŋ eruk äyäŋut päŋku Enmispat kome, wäpi kubä Kades u kuŋkuŋ. Kuŋpäŋ uken Amalek äbot kuduptagän däpmäŋpäŋ yäwat kireŋkuŋ. Ude täŋkaŋ Amo äbotken nanik Hasason-Tama komeken irani u däpuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Eruk ude täŋirä Sodom, Gomora, Atma, Seboim ba Soa kome täŋo intäjukun ämaniyekät äboriyetä Sidim Awaŋ, Kumbani Gwägu dubiniken itak u kuŋpäŋ Kedolaomi, Tidal, Amrafel ba Ariok ukät ämik pewä ahäŋkuŋ. Ämik pewä ahäŋkuko uwä kome 5 täŋo intäjukun ämatä kome 4 täŋo intäjukun ämakät ämik pewä ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Täŋpäkaŋ Sidim Awaŋ uken gwägu käroŋi okä näbä nikek bumta itkuŋ. Täŋkaŋ iwaniyetä Sodom Gomora täŋo äma ärowanikät äboriye kudup yäwat kireŋirä metäŋpeŋ kuŋpäŋ ätu okä gwägu u gänaŋ äpmoŋpäŋ paotkuŋ. Täŋirä ätu metäŋpeŋ päŋku pom terak äroŋpäŋ käbop itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ude täŋirä iwaniye kome 4 uken nanik unitä Sodom, Gomora yotpärare uken päŋku u nanik täŋo tuŋum ketem kudup yäyomägatkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram gweki täŋo nanaki Lot Sodom yotpärare itkuko u imaka, iŋitpäŋ tuŋumi bok yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ämik täŋirä Sodom nanik kubätä metäŋpeŋ päŋku Abram u imaka ahäŋkuko unitäŋo biŋam iwetkuk. (Abram unita äma ätutä Hibru äbotken nanik yäŋ yäk täŋkuŋonik. U päya äma kubä wäpi Mamretä bian piwani u dubiniken it täŋkukonik. Mamre uwä Amotä äbotken nanik. Unitäŋo noripakiyat Eskol kenta Ane. Äma yaräkubä ukät Abramkät bänep kubägän täŋpäŋ itkuŋ.) ");
INSERT INTO iou_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eruk, Abramtä nanaki topmäŋpäŋ yäpmäŋ kuŋkuŋo unitäŋo manbiŋam nadäŋpäŋ ŋode täŋkuk; Inikät nanik ämik täŋpäŋ nadäwani ämaniye yarägän 318 ude yämagutkuk. Yämaguränpäŋ iwan yäwat yäpmäŋ kuŋtäŋgän Dan yotpärareken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ahäŋpäŋ bipani ugän Abramtä ämaniye yäpmäŋ daniŋpäŋ ini äbot-äbot yepmaŋpäŋ yäwerän päŋku iwaniye ahäŋ yämiŋkuŋ. Ahäŋ yämiŋpäŋ däpmäŋpäŋ yäwat kireŋtäŋ kuŋtäŋgän Hoba yotpärare Damaskus guno käda uken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Uken ahäŋpäŋ tuŋum iwantä yäyomägat yäpmäŋ kuŋkuŋo u kuduptagän äneŋi yäpuŋ. Täŋpäŋ Abram gweki täŋo nanaki Lotkät Lot täŋo tuŋum, ukät webe ba ämawebe ätu iwantä kubota täŋkuŋo u äneŋi yämagutkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Täŋkaŋ Abram Elam täŋo intäjukun äma Kedolaomi ukät intäjukun äma noriye däpmäŋpäŋ yäwat kirewä kuŋirä eruk äyäŋutpäŋ komeniken kuŋkuk. Kuŋirän Sodom täŋo intäjukun äma Abram käwayäŋ Save Awaŋ komeken ahäŋ imiŋkuk. (Save Awaŋ kome u wäpi kubä Intäjukun äma täŋo Awaŋ.) ");
INSERT INTO iou_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Täŋpäkaŋ Salem täŋo intäjukun äma wäpi Melkisedek u imaka, äbä Abram ahäŋ imiŋkuk. (Melkisedek uwä Anutu Ärowaniinik unitäŋo bämop äma epän täk täŋkukonik.) Eruk, ahäŋ imiŋpäŋ käräga kenta wain ume Abramta imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Imiŋpäŋ kon man ŋode iwetkuk; Abram, Anutu Ärowaniinik kunum bibik gatäwanitä imaka tägatäga täŋ gamiton! ");
INSERT INTO iou_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Täŋkaŋ Anutu Ärowaniiniktä iwankaye ketkaken yepmaŋkuko unita wäpi iniŋ oretsi! Ude iweränä Abramtä tuŋum iwan keriken nanik yäyomägatkuko ukät nanik ätu buŋät imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ude täŋ imiŋkaŋ ätu nanak kuŋirän Sodom täŋo intäjukun ämatä Abram ahäŋ imiŋpäŋ ŋode iwetkuk; Ämawebenaye nomägatkuŋo u äneŋi naniŋ kire. Täŋ, tuŋumä gäkŋata it gamikot yäk. ");
INSERT INTO iou_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Yäŋirän Abramtä Sodom täŋo intäjukun äma u iwetkuk; Yawe Anutu Ärowaniinik, kunum kome täŋkuko u wäpi terak man kehäromi ŋode gäwetat; Näk tuŋum täpuri-inik u ba u ketkaken nanik kubä nämoinik yäpayäŋ. Imata, gäkä ŋode yäwenta; Näkä Abramta tuŋum mäyap imiŋira tuŋum äma täŋkuk yäŋ yäwenta yäk. ");
INSERT INTO iou_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Täŋpäkaŋ ketemka täpuri ämanayetä kädet miŋin naŋo unita täga naŋ yäŋ nadäsi yäk. Ba äma näkkät ämikta kuŋkumäŋo wäpi Ane, Eskol, Mamre, tuŋum unitä täga yäpnaŋi nadäŋ yämiŋiri yäput yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ude täŋpäŋ mäden Yawe täŋo mani kotäktä Abram ayäbu ahäŋ imiŋpäŋ iwetkuk; Abram, umun täwentawä! Näkŋagän gäkŋo kurepä ude api it yäpmäŋ ärowet! Täŋkaŋ näkŋawä gwäki ärowani ude api it gamet. ");
INSERT INTO iou_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yäwänä Abramtä iwetkuk; Ekäni Yawe, gäk imatäken kubä namayäŋ yäŋpäŋ yäyan? Näk kadäni käroŋi it yäpmäŋ äbätat upäŋkaŋ nanakna kubä nämo. Näkŋo kome ba tuŋum piä ämana Damaskus komeken nanik wäpi Eliesa unita biŋam api täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nadätan? Gäk nanak kubä nämo namiŋkun! Unita epän ämana kubätä näkŋo kome ba tuŋum api korewek yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ude yäwänä Yawe täŋo mani kotäktä ŋode ahäŋ imiŋkuk; Äma wäpi yäyan unitä gäkŋo kome ba tuŋum nämo api korewek. Nämo, gäkŋaken nanaka ahäwayäŋ täyak unitä gäkŋo tuŋum api korewek. ");
INSERT INTO iou_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ude iwetpäŋä yäŋikŋat päŋku yäman umu ŋode iwetkuk; Gäk doraŋpäŋ kunum terak ijiŋpewi ärowän. Ijiŋpewi ärowänpäŋ guk täga daninaŋi täŋpäwä, eruk dani! Ude yäŋpäŋ iwetkuk; Nanakaye ahänayäŋ täŋo yabätan udegän api ahäŋ yäpmäŋ kuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Täŋpäkaŋ Abram Yawetä iwetkuko u nadäkinik täŋkuko unita äma siwoŋi yäŋ yäŋtäreŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Täŋkaŋ ŋode iwetgän täŋkuk; Näk Yawe, kome ŋo ganiŋ kirewa gäkŋata biŋam täkta Ur yotpärare Kaldia komeken nanik gämagut yäpmäŋ äburo u. ");
INSERT INTO iou_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ude iweränkaŋ Abramtä iwetkuk; Ekäni Yawe, jide täŋpäŋ kome ŋo näkä bureni korewetta yäŋ nadäwet? ");
INSERT INTO iou_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yäwänä ŋode iwetkuk; Bulimakau gubaŋi kubä, meme kubä ukät sipsip ämani kubä, obaŋ yaräkubä tärewani ukät känaräm kubä notek kubä u yäpmäŋ näkken äbi. ");
INSERT INTO iou_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ude yäwänä Abram udegän täŋkuk. Yäpmäŋ päŋku kwäk duŋpäŋ kukŋi ini terak, kukŋi ini terak tawaŋ peŋkuk. Barakä kumän ikek peŋkuk, kwäk nämo duŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ude peŋirän barak taŋi ätutä tom madäŋ peŋkuko u nänayäŋ äpäŋirä Abramtä täŋ-yäwatkuk. ");
INSERT INTO iou_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Eruk edap äpmoŋpayäŋ täŋirän Abram patguŋguŋ täŋirän bipmäŋ urani umuri pähap kubätä uwäk täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Täŋpäkaŋ Yawetä Abram iwetkuk; Bureni-inik gäwera nadä; Kämiwä, äbotkaye kämi ahänayäŋ täkaŋ uwä kome kudupiken päŋku irirä kome unitäŋo mähemtä komi piäken api yepmaneŋ. Obaŋ 400 udeta komi piäken itkaŋ äma keri terak komi bumta api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Upäŋkaŋ komi piä täŋ yäminayäŋ täŋo unita kowata näkä api yämet. Täŋpäkaŋ kämiwä äbotkaye komi piäken nanikpäŋ tuŋum ärowani nikek api äpämaŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Gäkŋa uyaku tägawani täŋpäŋ kumäŋpäŋ äbekaye oraŋkaye täŋo itpäŋ-nadäk komeken api äpmoŋpen yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Täŋpäŋ Amo täŋo äboriye unitäŋo waki-wakini yäpurärätpäŋ yäpurärätpäŋ täŋ yäpmäŋ äroŋirä obaŋ 400 bumik tärewänkaŋ Amo äboriye däpmäŋpäŋ yäwat kireŋira äbotkaye äneŋi äyäŋutpeŋ api ämneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yawetä ude iwerirän kome dapuri äpmoŋpäŋ bipmäŋ urirän kädäp gäyäkkät topän mebet ahäŋpäŋ tom duŋpäŋ peŋkuko u kukŋi kukŋi irirän bämopgän kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","21","Kepma ukengän Yawetä Abramkät topmäk-topmäk täŋpäŋ iwetkuk; Kome ŋo gäkŋo äbotkayeta yämikta yäŋkehärom täyat. Kome uwä Isip täŋo ume wäpi Nail unitä päŋku Yufretis ume u täretak. U Ken, Kenas, Katmon, Hit, Peres, Refaim, Amo, Kenan, Gilgas, Jebus unitäŋo komeni gäkŋo äbotkayeta api yämet. ");
INSERT INTO iou_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Täŋpäkaŋ Abram täŋo webeni Sarai u nanak kubä nämo bäyaŋkuk. Täŋirän Sarai täŋo piä watä webe Isip nanik kubä itkuko u wäpi Haga. ");
INSERT INTO iou_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Irirän Saraitä Abram ŋode iwetkuk; Nadätan, Yawetä nadäŋirän äruŋ itat unita watä piä webena ukät pätkon. Parirän webe uterak nanak ätu käwep ahäŋ nimek yäk. Ude iweränä Abramtä Sarai täŋo man buramiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Eruk, Abramtä Kenan komeken obaŋ 10 ude irän täreŋirän, Saraitä Isip nanik watä piä webeni wäpi Haga u api Abram webenita iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iniŋ kirewän bok parirän nanak kok itkuk. Täŋpäŋ Haga nanak kok itat yäŋ nadäŋpäŋ Saraita nadäwän äpani täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ude täŋkuko unita Saraitä äpi Abram ŋode iwetkuk; Näkä mäyäk nadätat uwä gäka biŋam täyak yäk. Näkä watä webena gamiŋpäŋ kupäŋka terak peŋkut. Täŋpäŋ unita Hagatä nanak kok itat yäŋ nadäŋpäŋ näka nadäŋirän äpani täyak yäk. Unita gäkkät nek bämopnekken man pätak u Yawe ini-tägän yäpmäŋ daniwän yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ude yäwänä Abramtä iwetkuk; Ude nämo! Piä watä webe u mähemi gäkä täyan. Unita u ba u täŋ ima yäŋpäŋä täga api täŋ imen yäk. Yäwänä Saraitä Hagata iwan täŋ imiŋtäyon metäŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Haga metäŋpeŋ päŋku Su kädet kuŋtäŋgän kome äma nämo iraniken ume täpuri kubäken ahäŋpäŋ itkuk. Uken irirän Yawe täŋo aŋero ahäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ahäŋ imiŋpäŋä ŋode iwetkuk; Haga, Sarai täŋo watä webe, gäk de naniktä äbätan? Ba de kwayäŋ? Yäwänä Hagatä iwetkuk; Intäjukun webe Sarai kaŋumuntaŋ äbätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ude iweränä Yawe täŋo aŋero unitä ŋode iwetkuk; Gäk intäjukun webeka äneŋi kuŋkaŋ mani kaŋ burami yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nadätan? Näkä täŋpewa gäkŋo äbekaye oraŋkaye bumta, ämatä daninaŋi nämo ude api ahäneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ude yäŋpäŋ Yawe täŋo aŋero unitä ŋode iwetgän täŋkuk; Nadätan? Gäk nanak kok itan. Nanak ämani u bäyaŋpäŋä wäpi Ismael kaŋ iwet, Yawetä konäm butewaki täŋiri nadäŋkuko unita yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tägaŋpäŋ tom ägwäri udewani api irek yäk. Nanaka uwä ämata iwan täŋ yämiŋirän ämatä udegän api täŋ imineŋ. Noriye kuduptagänta iwan täŋ yämiŋtäŋ api kuŋarek yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ude iwetkuko unita Haga bänepitä ŋode nadäŋkuk; Nabäŋpäŋ-nadäwani unitä kwawak ahäŋ namiŋirän karo unita Yawe täŋo wäpi ŋode iwetat; Gäk Yawe nabäŋpäŋ-nadäwani u yäk. ");
INSERT INTO iou_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Mebäri unita ume terak itkuko u wäpi ŋode yäk täkaŋ; Irit mähemi nabäŋpäŋ-nadäwani unitäŋo ume dapuri. Ume u Kades yotpärare, Beret yotpärare bämopiken pen itak. ");
INSERT INTO iou_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Eruk, kadäni täreŋirän Hagatä Abramta nanak kubä bäyaŋ imiŋkuk. Bäyawänä Abramtä nanak wäpi Ismael yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Täŋpäkaŋ Abram täŋo obaŋ 86 täreŋirän Hagatä nanaki Ismael bäyaŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramtä täŋo obaŋ 99 täreŋirän Yawetä ahäŋ imiŋpäŋ ŋode iwetkuk; Näk Anutu kehäromi mähemi yäk. Gäk gämotnaken itkaŋ siwoŋigän kuŋat täyi yäk. ");
INSERT INTO iou_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Täŋiri näkä gäkkät topmäk-topmäk taŋpäŋ äbotkaye mäyap api pewa ahäŋ gamineŋ. ");
INSERT INTO iou_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ude iweränä Abramtä iŋami kome terak yäpän äpmoŋpäpäŋ parirän Anututä iwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Nadätan? Näk gäkkät topmäk-topmäk täyat uwä ŋodeta; Gäk äma äbori äbori unitäŋo nani api täŋpen. ");
INSERT INTO iou_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Täŋkaŋ wäpka Abram uwä wari nämo api gäweret. Nämo, gäk äma äbori äbori unitäŋo nani yäŋ nadäŋ gamiŋira kuŋarayäŋ täno unita wäpka Abraham api gäweret yäk. ");
INSERT INTO iou_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Täŋkaŋ näkä täŋpewa nanakaye mäyapinik api ahäneŋ. Ahäŋpäŋä ätutäwä intäjukun äma irit piä api täneŋ. Nanakaye mäyap ahänayäŋ täŋo unitä äbori äbori komeni komeni api it yäpmäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Topmäk-topmäk gäkkät täyat ŋonitä gäk ba nanakayetä äbotkentä äbekiye oraniyeken tärek-täreki nämo, api pat yäpmäŋ kwek. Täŋirän nähä gäka ba äbekaye oraŋkaye kämi-kämi ahänayäŋ täŋkaŋ unitäŋo Anutu api iret yäk. ");
INSERT INTO iou_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Apiŋo Kenan komeken itan ŋowä äbani ude itan upäŋkaŋ kome ŋo gäk ba äbekaye oraŋkaye kämi-kämi ahänayäŋ täkaŋ unitä mähemi tärek-täreki nämo täneŋta api taniŋ kirewet. Täŋpäŋ äbotkaye unitäŋo Anutu api iret yäk. ");
INSERT INTO iou_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ude iwetpäŋ Anututä Abraham ŋode iwetgän täŋkuk; Gähäwä topmäk-topmäk gäkkät täyat unitäŋo käderi iwat yäpmäŋ kaŋ kuŋat. Täŋiri äbekaye oraŋkaye kämi ahänayäŋ täkaŋ u udegän kaŋ iwat täŋput. ");
INSERT INTO iou_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","13","Topmäk-topmäkna täŋo kudän ŋode; Nanak ämani ahäŋpäŋ kepma 8 ude täreŋirän gupi moräk madäŋ yämik täneŋ. Nanak ämani kuduptagän apiŋotä kämi ahänayäŋ täŋo uwä udegän kaŋ täk täŋput. Inä ude tänayäŋ täŋo uwä näkä gäkkät topmäk-topmäk unitäŋo kudän ude api irek. Täŋpäkaŋ nanakayetagän nämo yäyat. Gäkŋo piä ämakaye täŋo nanak ba kome kubäken nanik moneŋpäŋ suwawani unitäŋo nanakiye udegän gupi moräk madäŋ yämineŋ. Täŋkaŋ topmäk-topmäk näkä inkät täyat uwä tärek-täreki nämo api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Täŋpäkaŋ äma kubä gupi moräk nämo madäweko uwä äma uwä äboriken nanik iwat kirewäkaŋ inigän api kuŋarek, äma uwä näkŋo topmäk-topmäk yäpmäŋ däkŋewayäŋ täko unita. ");
INSERT INTO iou_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ude yäŋpäŋ Anututä Abraham äneŋi kubä ŋode iwetgän täŋkuk; Webeka Saraita gäwera; U wäpi Sarai yäŋ nämo api iweren. Nämo, Sara yäŋ kaŋ iwet. ");
INSERT INTO iou_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bureni-inik, näkä iron täŋ imiŋira Saratä koki itpäŋ nanak kubä api bäyaŋ gamek. Saraken nanik äma äbori äbori api ahäneŋ. Ba uken nanikgän ätu uwä äbot täŋo intäjukun äma api ahäŋ yäpmäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Anututä ude iweränä Abraham kome terak iŋami yäpän äpmoŋpäpäŋ patkaŋ äräpi nadäŋpäŋ ŋode nadäŋkuk; Wära! Äma kubä obaŋ 100 tärewani näk udewanitä nanak kubä täga pewän ahäwek? Ba webena Sara obaŋ 90 tärewänkaŋ nanak kubä täga bäyawek? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ude nadäŋpäŋ Anutu iwetkuk; Nanakna Ismael bian bäyaŋkuro unitä gäkŋo iron terak täga itnaŋi nämo? ");
INSERT INTO iou_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Yäwänä Anututä iwetkuk; Ude upäŋkaŋ webeka Saratä nanak kubä bäyaŋ gamänkaŋ wäpi Aisak yäŋ kaŋ iwet. Ahäŋpäŋ tägawänkaŋ ukät topmäk-topmäkna api täŋpet. Täŋpäŋ äboriyekät udegän, topmäk-topmäk uwä tärek-täreki nämo api it yäpmäŋ kwet. ");
INSERT INTO iou_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Täŋ Ismaelta yäno u nadäŋ gamiŋpäŋ iron täŋ imiŋpewa äboriye mäyap api ahäŋ imineŋ. Täŋpäŋ nanakiye 12tä wäpi biŋam ikek itkaŋ yabäŋ yäwat piä api täneŋ. Täŋkaŋ näkä täŋkentäŋ imiŋira nanaki ahäŋ yäpmäŋ kuŋtäko äbot taŋi kubä api täŋpek. ");
INSERT INTO iou_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Upäŋkaŋ Ismael ukät topmäk-topmäkna nämo api täŋpet. Nanaka Aisak ukät uyaku api täŋpet. Täŋkaŋ nanak uwä Saratä obaŋ kubä gunonita api bäyaŋ gamek yäk. ");
INSERT INTO iou_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Eruk, Anutu Abrahamkät man yäŋtäreŋpäŋ Abraham teŋpeŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Teŋpeŋ äroŋkuko kepma ugän Abrahamtä Anutu täŋo man buramiŋpäŋ nanaki Ismael gupi moräk madäŋ imiŋkuk. Nanaki Ismaelkät piä ämaniye inikät irani ba kubäken nanik suwawani u ämani kudup gupi moräk madäŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Täŋpäkaŋ Abraham ini uwä obaŋ 99 tärewänkaŋ gupi moräk madäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Täŋ nanaki Ismael uwä obaŋ 13 täreŋirän nanitä gupi moräk madäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Bureni, kepma ugän, Abrahamkät nanaki Ismael gupi moräk madäŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Täŋkaŋ Abraham täŋo piä ämaniye, ini ugän bäyawani ba kome kubäken nanik moneŋpäŋ suwawani u imaka, kuduptagän gupi moräk madäŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kadäni uken Abrahamtä päya, äma kubä wäpi Mamre unitä piwani u dubiniken it täŋkukonik. Täŋpäŋ kadäni kubä, kepma bämopiken Abraham yottaba yäman maŋit irirän Yawetä ahäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham maŋit ittäŋgän ijiwän kwäpäŋ yabäŋkuk; Äma yaräkubä iŋamiken käroŋ wädäŋ irirä. Yabäŋpäŋ dubiniken bäräŋeŋ kuŋkaŋ oraŋ yämikta gwäjiŋ äpmoŋpäŋ yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ärowaninaye, in näka täga nadäŋ namiŋpäŋä piä ämajin näk, nämo närepmitneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Näkä yäŋpewa ume yäpmäŋ äbäpäŋ kuroŋjin ärutkaŋ päya ŋo äyuŋken itpäŋ-nadäk täkot. ");
INSERT INTO iou_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Täŋirä ketem ätu tama naŋ täpäneŋkaŋ kuna yäŋpäŋä kukot yäk. Näkä yotken äbäŋo unita nadäŋ namiŋirä ude täŋkentäŋ tama! Yäwänä iwetkuŋ; Täga, yäyan ude täyi yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Täga yäŋ iweräkaŋ Abrahamtä yot gänaŋ äro webeni Sara iwetkuk; Eruk, plaua ätu bumik gwetkaŋ awähutpäŋ käräga säkgämän ätu bäräŋeŋ ijiŋ yämisi yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Iwetpäŋä Abraham bäräŋeŋ päŋku bulimakau nanaki säkgämän kubä yäpmäŋ päŋku piä ämani kubäta imänkaŋ bäräŋek madäŋpäŋ ijiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Täŋirän bulimakau nonoŋ umeni ba gakŋikät bulimakau madäŋpäŋ ijiko u penta yäpmäŋ päbä yämiŋkuk. Yämän naŋ irirä iniwä päya äyuŋken käroŋ wädäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Käroŋ wädäŋirän iwet yabäŋkuŋ; Webeka Sara de? Yäwäwä yäwetkuk; Yot gänaŋ itak yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yäŋirän Yawetä iwetkuk; Apiŋo kadäni itkamäŋ ŋodeken obaŋ kubä gunonita näk äneŋi api äbet. Äneŋi äbäŋira Saratä nanak kubä api bäyawek yäk. Täŋpäkaŋ Sara äma itkuŋo u mädeniken yot yämaken itkaŋ man yäŋkuŋo u nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham kenta Sara uwä tägawaniinik täŋkumän. Täŋpäŋ Saratä nanak bäyanaŋi nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Unita Saratä ŋode nadäŋpäŋ mägayäŋkuk; Näk gupna tepmom ikek. Äpna u imaka, tägawanigän unita bok patpäŋ jide täŋpäŋ gäripi nadäwet? ");
INSERT INTO iou_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sara ude nadäŋirän Yawetä Abraham ŋode iwet yabäŋkuk; Sara imata näk webe pähap täyat ŋopäŋ nanak täga nämo bäyawet yäŋ nadäŋkaŋ mägayätak? ");
INSERT INTO iou_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yawetä imaka u ba u kubä täŋpayäŋä täga nämo täŋpän waneŋ. Nämoinik! Obaŋ kubä gunonita, kadäni gäweraro udeken äneŋi äbäŋira Sara nanak api bäyawek. ");
INSERT INTO iou_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yawetä ude yäŋirän Sara umuntaŋpäŋ äwo yäŋpäŋ yäŋkuk; Näk nämo mägayät yäk. Yäwänä iwetkuk; Mägayänopäŋ jop yäyan yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Äma yaräkubä Abrahamkät itkuŋo u akumaŋ kuna yäŋkaŋ Sodom yotpärare etä päpmo kaŋkuŋ. Täŋirä Abrahamtä kädet miŋin yepmaŋpa kut yäŋkaŋ bok kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kuŋkaŋ Yawe nadäk-nadäki-ken ŋode nadäŋkuk; Jide täkta nadätat uwä Abrahamta käbop nämo peŋ imet. ");
INSERT INTO iou_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Nadäŋ imiŋira Abraham täŋo oraniyetä bureni-inik äbot taŋi ba kehäromi nikek api täneŋ. U wäpi terak täŋkentäŋ yämiŋpewa ämawebe kuduptagän uken-uken nanik iron pähap api ahäŋ yämineŋ. ");
INSERT INTO iou_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Abrahamtä nanakiye ba oraniye äbekiye näkŋo kädet yäwoŋäreŋpewän näkŋo man buramiŋpäŋ kuŋat-kuŋat siwoŋi iwatpäŋ täneŋta unita näk Abraham näkŋata yäpmäŋ daniŋkut. Ude täŋirä näk Yawetä imaka Abrahamta biŋam yäŋkehärom taŋpäŋ iwetkuro unitäŋo bureni näk täga api pewa ahäŋ imineŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","Ude nadäŋpäŋ Yawetä Abraham iwetkuk; Sodom Gomora yotpärareken nanik täŋo irit kuŋatkuŋari wakiinik täŋpewä jukunaken yäŋkuruk-kuruk bumta ahätak unita yabäŋpäŋ-nadäkta kwa yäk. Yäŋkuruk-kuruk nadätat uwä bureni ba jop käwep yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Täŋpäŋ äma yarä u Abraham teŋpeŋ Sodom käda kuŋkumänopäŋ Abraham Yawekät itkumän. ");
INSERT INTO iou_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","24","Ittäŋgän Abrahamtä Yawe iŋamiken kuŋpäŋ butewaki man ŋode iwetkuk; Bureni? Gäk äma waki ba äma siwoŋi bok api däpmäŋ paoren? Ŋode täga nämo täŋpen? Ämawebe siwoŋi kuŋarani 50 ude itneŋo uwä yotpärare kudup täŋpi waneŋtawä. Äma siwoŋi kuŋarani 50 unita yäŋpäŋ päke u täga nämo yabäŋ korewen? ");
INSERT INTO iou_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ämawebe siwoŋi bok waki täŋpani bok däpayäŋ täno uwä imaka tänaŋi nämopäŋ täŋpen. Gäkŋo mebärika nadätat. Gäkä äma waki täŋpani ba äma siwoŋi kuŋarani yäpmäŋ daniŋpäŋ kudän siwoŋi täk täyan unita äma täga ba waki bok u däpnaŋi nämo yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yäwänä Yawetä iwetkuk; Sodom ämawebe siwoŋi kuŋarani 50 ude yabäŋpäŋä unita yäŋpäŋ ämawebe kudup api yepmaŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","28","Yäwänä Abrahamtä iwetkuk; O Ekäni, gäk ärowani. Näk äma äpani upäŋkaŋ näk nämo mäyäk taŋkaŋ äneŋi gäwetat. Näk 50ta yäropäŋ siwoŋi äma 45 ude itneŋowä gäk täga yepmaŋpen? Yäwänä Yawetä iwetkuk; Ämawebe siwoŋi 45 ude yabäŋpäŋä yotpärare u nämo yäpa waneŋ. ");
INSERT INTO iou_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ude yäwänä Abrahamtä äneŋi iwetgän täŋkuk; Ämawebe 40gän ude yabäŋpäŋ däpen ba? Yäwänä iwetkuk; Eruk ämawebe 40 unita yäŋpäŋ kudup yabä kätäwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iweränä Abrahamtä yäŋkuk; O Ekäni äneŋi gäwetat unita nämo nebewen! Ämawebe siwoŋi kuŋarani 30gän ude iräwä jide api täŋpen? Api däpen ba nämo api däpen? Yäwänä Yawetä iwetkuk; Ämawebe siwoŋi kuŋarani 30 unita yäŋpäŋ nämo api däpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yäwänä äneŋi Abrahamtä iwetgän täŋkuk; O Ekäni, näk nämo mäyäk taŋkaŋ äneŋi gäwetat. Ämawebe siwoŋi 20gän itneŋo uwä däpen ba nämo däpen? Yäwänä Ekänitä iwetkuk; Ämawebe 20 ude itneŋo unita yäŋpäŋ kudup yepmaŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ude yäwänä Abrahamtä yäŋkuk; O Ekäni, nämo nebewen! Kubäkät yäwayäŋ; E, ämawebe 10gän iräwä jide täŋpen? Yäwänä Ekänitä yäŋkuk; Ämawebe siwoŋi kuŋarani 10 ude iräwä yotpärare u nanik kuduptagän api yabäŋ korewet yäk. ");
INSERT INTO iou_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Eruk Yawetä Abrahamkät ude yäwän tärewän kuŋirän Abraham äneŋi äyäŋutpäŋ yotken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Eruk bipäda ugän Lottä Sodom yotpärare täŋo kädet moräkiken irirän aŋero yarä ukeŋo ahäŋ imiŋkumän. Ahäŋ imiŋirän yabäŋpäŋ päŋku iŋami yäpän äpmoŋpäpäŋ yäniŋ oretkuk. Yäniŋ oretpäŋ yäŋkuk; ");
INSERT INTO iou_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ärowaninayat, näkä yotken äbäŋirän täŋkentäŋ tama! Näk kuroŋjek ärutpäŋ bipani ŋo itpäŋ pätna yäŋewänkaŋ kaŋ kun yäk. Ude yäwänä iwetkumän; Nämo, yotpärare täŋo käbeyä bägupken jop pätdayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Jop uken pätdayäŋ yäwänä man kehäromigän yäŋtäyon Lottä yotken kuŋkuŋ. Kuŋpäŋ yot gänaŋ äro irirän Lottä käräga yiskät nämo awähurani u ba ketem tägatäga ätukät ijiŋ yämän naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Naŋkaŋ däpmon pätnayäŋ täŋirä Sodom nanik äma ekäni gubaŋi päke u kudup Lot täŋo yot u it äyäŋutkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","It äyäŋutpäŋ Lot gera täŋpäŋ iwetkuŋ; Äma yarä gäkken äbämäno ukeŋo de itkamän? Äma yarä u yäŋ-yäkŋat yäpmäŋ ninken äbi yäk. Yarä u yäpmäŋ ninken äbikaŋ yäjitna yäŋ nadäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ude yäwäwä man yäna yäŋkaŋ Lot yäman äpmoŋpäŋ yäma ukät yäwatkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Yäma ukät yäwatpäŋ yäwetkuk; O notnaye, wakiwaki tänayäŋ nadäkaŋ u nämo täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nämo, näk äpetnayat gubaŋi yarä ŋo ämakät nämo pärani unita yarä u yäpmäŋ äbä tamakaŋ ukät jide tänayäŋ nadäkaŋ uwä täkot yäk. Täŋ äma yarä ban naniktä näkken äbumäno uwä näkä watäni it yämitat unita waki täŋ yämineŋo! ");
INSERT INTO iou_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ude yäwänä iwetkuŋ; Keweŋ nimi! Gäk kome mähem nämo unita kädet udewanita gäkä man täga nämo niweren yäk. Nadätan? Yarä unita täŋ yäminayäŋ täkamäŋ uwä irepmitpäŋ gäka waki-inikinik api täŋ gamine! yäk. Ude yäŋpäŋ Lot pimiŋ iwat-pewä kwänpäŋ yäma däpmäŋ eränayäŋ täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Täŋirä äma yarä yot gänaŋ itkumäno u bäräŋeŋ päbä yäma dätpäŋ Lot kerigän iŋitkaŋ wädäŋ yäpmäŋ yot gänaŋ ärowänkaŋ yäma ukätkumän. ");
INSERT INTO iou_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Täŋpäŋ äma yarä unitä täŋpewän äma yäman itkuŋo uwä dapuri bipmäŋ utkuŋ, äma ekäni bok, gubaŋi bok. Dapuri bipmäŋ uräpäŋ yämata puŋ ijiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Eruk äma yarä unitä Lot iwetkumän; Gäk nanakaye äpetkaye yepmaŋkaye ba nägät moräkaye ätu yotpärare ŋoken iräwä kuduptagän yäwetpäŋ yämagurikaŋ yotpärare ŋo peŋpeŋ kut yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nek yotpärare ŋo däpmäŋ moredayäŋ nadäkamäk. Yotpärare ŋonitäŋo waki mebäri mebäritä yäŋkuruk-kuruk pähap ude Yawe jukuniken äpmoŋkuko unita peŋ niwet-pewän yotpärare ŋo däpmäŋ morekta äbumäk yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lottä man iwetkumäno u nadäŋpäŋ päŋku yepmaniyat, äperiyatta iwoyäwani u yäwetkuk; Oi, bäräŋeŋ! Yawetä kome ŋo däpmäŋ morewayäŋ täyak yäk. Yäweränkaŋ Lot jop yäŋnikŋatak yäŋ nadäŋkaŋ mani nämo buramiŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Eruk yäŋewänä tamimaŋ bipani aŋero yarä ukeŋonitä Lot peŋ iwetkumän; Bäräŋeŋ bäräŋeŋ! yäk. Webeka ba äpetkayat ŋo yäŋ-yäkŋat yäpmäŋ ku yäk. Ude täŋpayäŋ täno uyaku inä yotpärare ŋokät bok nämo paotnayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","17","Täŋpäkaŋ Lot kwikinik kwikinik täŋirän Yawetä butewaki nadäŋ yämiŋpäŋ aŋero ukeŋo yäwet-pewän nädamiŋi-nani kerigän yepmäŋitpäŋ yäŋ-yäkŋat yäpmäŋ yotpärare gägäniken kuŋpäŋ aŋero kubätä yäwetkuk; Bäräŋekinik kukot! Äyäŋutpäŋ ijik ba awaŋ uken itpäŋ-nadäk nämo täneŋ. Bäräŋeŋ kumaŋ pom uduken kaŋ kut. Uyaku nämo api kumneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ude iweränä Lottä yäŋkuk; Ärowanina, ude nämo! yäk. Ude täga nämo täŋpet. ");
INSERT INTO iou_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Gäk iron taŋi täŋpäŋ oraŋ namiŋirän nämo kumaro upäŋkaŋ pom udu baninik itkaŋ unita waki ahäwayäŋ täyak unita pom uken nämo ahäŋkaŋ bämopiken paoret yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yotpärare täpuri udu ka! U täpuri, ei yäŋ? U uyaku tuän bumik yäk. Uken nepmaŋpi yäpmäŋ kwayäŋ täro uyaku nämo paoret yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","22","Ude yäwänä iwetkuk; Eruk yäyan unita täga nadätat yäk. Yotpärare gäkä yäyan u nämo däpayäŋ upäŋkaŋ bäräŋeŋ metäŋpeŋ kut yäk. Yotpärare uken ahäwikaŋ uyaku kome ŋo täga täŋpa wanayäŋ yäk. (Yotpärare u Lottä täpuri yäŋ yäŋkuko unita wäpi Soa yäŋ yäk täkaŋ. Soa u nininken man terak täpuri.) ");
INSERT INTO iou_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kuŋtäyon edap dapuri äbäŋirän Lot yotpärare täpuri Soa uken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","25","Ahäŋirän Yawetä täŋpewän iwän kädäkut mebet ikek Sodom Gomora yotpärare terak äpuk. Iwän kädäkut mebet ikek äpuko u Sodom Gomora nanik ba awaŋ pähap uken nanik ämawebe ba ketem imaka imaka u kudup ijiŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Täŋirän Lot webeni kuŋtäŋgän äneŋi äyäŋutpäŋ Sodom yotpärare kaŋpäŋä bewe äworeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","28","Täŋpäkaŋ patkuko kome yäŋe-yäŋeta Abraham akumaŋ kumaŋ päŋku kome bian Anutu iŋamiken itkukken uken ahäŋkuk. Päŋku ahäŋpäŋ kaŋkuk; Sodom Gomora ba kome awaŋ pähap uwä gupe kädäp mebet ikek bumik akuŋirän. ");
INSERT INTO iou_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Yawetä Sodom Gomora awaŋ pähap Lottä iraniken u nanik kudup däpmäŋ moreŋkuko upäŋkaŋ Abrahamta nadäŋpäŋ Lot uken nanik imagut yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Täŋpäŋ Lot u Soa yotpärare täpuri uken itta umuntaŋpäŋ äperiyat yäwän yäpmäŋ pomken kuŋkaŋ mobä käwut kubäken it täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","32","Eruk kadäni kubäken Lot äperi mokitä wenäni iwetkuk; E, nek täŋo nannek tägawani täyak yäk. Täŋirän ämawebe komeni komenitä täk täkaŋ ude äma nek yäpmäŋpäŋ nektä nanak bäyakta nämoinik itkaŋ unita wain mujipi täŋo ume täkätpäŋ nanta imida naŋpäŋ täŋguŋ tawänpäŋ ukät patkaŋ nanak kok ikek kaŋ itda. Ude täŋitda nan täŋo nägät moräk api it yäpmäŋ ärowek yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Eruk bipani ugän wain ume imän naŋpäŋ täŋguŋ takinik täŋpäŋ nämo nadäŋirän äperi moki nanikät patkumän. ");
INSERT INTO iou_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Täŋpäŋ äneŋi patkuŋo yäŋewänkaŋ mokitä wenäni iwetkuk. Näkkät uku kwep bipani päramäko u yäk. Unita apiŋo äneŋi wain ume imida naŋirän gäkkät bipani kaŋ parun yäk. Ude täŋpäŋ uyaku nek bok nannektä nanak kaŋ nimän yäk. ");
INSERT INTO iou_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Eruk bipani ugän nanita wain ume imän naŋpäŋ täŋguŋ takinik täŋpäŋ nämo nadäŋirän äperi wenänikät patkumän. ");
INSERT INTO iou_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Täŋpäŋ Lot äperiyat nanikät ude täŋpäŋ nanak kok itkumän. ");
INSERT INTO iou_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ittäŋgän mokitä nanak ämani bäyaŋpäŋ wäpi Moap yäŋ iwetkuk. Apiŋo Moap äbot itkaŋ uwä Moap, Lot äperi mokitä bäyaŋkuko u täŋo orani pähap. ");
INSERT INTO iou_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Täŋpäkaŋ wenänitä udegän nanak ämani bäyaŋpäŋ wäpi Benami yäŋ iwetkuk. Apiŋo Amon äbot itkaŋ uwä Benami, Lot äperi wenänitä bäyaŋkuko u täŋo orani pähap. ");
INSERT INTO iou_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamtä Mamre kome peŋpeŋ kome taŋi kubä wäpi Negev uken kuŋkuk. Negev kome u Kades Su kome bämopiken uken. Täŋpäŋ Abrahamtä yotpärare kubä wäpi Gera uken itkuk. ");
INSERT INTO iou_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Itkaŋ webeni Sarata u wanotna yäŋ yäŋkuk. Biŋam u nadäŋpäŋ Gera yotpärare täŋo intäjukun äma Abimelektä yäŋpewän Sara yäŋikŋat yäpmäŋ päŋku imä webenita yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Täŋpänkaŋ bipani kubäken Anututä Abimelek däpmonken ahäŋ imiŋpäŋ iwetkuk; Gäk webe ŋo äpi nikekpäŋ gäkŋata yäpuno unita kumbayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ude iweränä Abimelektä iwetkuk; Näk Sarakät bok nämo päramäk. Ekänina, näk äma siwoŋi! Unita näkkät äbotnayekät nämo nidäpen yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahamtä ini-tägän wanotna yäŋ yäŋirän webeni Saratä Abrahamta udegän wanotna yäŋ yäŋkuk yäk. Näk bänep siwoŋina terak täŋkuro unita näkken waki kubä nämo pätak yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Yäweränä Yawetä iwetkuk; Bänep siwoŋi terak täŋkuno u bureni nadätat. Unita webe u iŋirenta baga peŋ gamiŋpäŋ täŋkentäŋ gamiŋira waki kubä nämo täŋkun yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Eruk, gäk webe u äpiken iniŋkire. Abraham uwä profet kubä unita gäka yäŋpäŋ näkken yäŋapiŋirän gäk nämo api kumben. Täŋ webeni nämo imayäŋ täno uwä gäk ba äbotkaye bureni-inik api kumäŋ moreneŋ. ");
INSERT INTO iou_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Eruk patkuŋo kome api yäŋeŋirän Abimelek akuŋpäŋ piä ämaniye änok yepmaŋpäŋ man däpmonken nadäŋkuko u yäwerirän umun pähap nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ude täŋkaŋ Abimelektä Abraham yäŋpewän äbänkaŋ ŋode iwet yabäŋkuk; Gäk jide täŋ nimiŋkun? Näk waki kubä jide täŋ gamiŋkutta kowata komi näk ba äbotnaye terak peŋ nimiŋkun? Ude uwä nämo tänaŋipäŋ täŋkun yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Gäk jide nadäŋpäŋ ude uwä täŋkun? ");
INSERT INTO iou_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ude yäwänä Abrahamtä iwetkuk; Kome ŋo naniktä Anutu nämoinik oraŋ imik täkaŋ unita webena yäŋ yäwawä api nutneŋ yäŋ nadäŋpäŋ ude täŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Etäŋ, u bureni wanotna yäk. U nannek kubägän upäŋkaŋ meŋnek inigän inigän. Upäŋkaŋ webenata yäput yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Täŋpäkaŋ Anututä näwet-pewän nana täŋo yotpärare peŋpäŋ kome kudupiken äba yäŋpäŋ Sara iwetkut; Kome uken ba uken kuŋpäŋä nadäŋ namikinik täŋpäŋä ŋo wanotna yäŋ kaŋ yäwet tä yäŋ iwetkut. ");
INSERT INTO iou_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ude iwerirän Abimelektä sipsip, bulimakau ba piä ämawebe yäpmäŋpäŋ Abrahamta biŋam iniŋ kireŋkuk. Täŋpäŋ webeni Sara bok iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Iniŋ kireŋpäŋ Abraham iwetkuk; Nadätan! Iŋamkaken komena pat kuyak ŋo gäk uken ba uken ira yäŋpäŋä täga api iren yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ude yäŋpäŋä Sara ŋode iwetkuk; Äbotkayetä nadäŋ gamiŋirä mäyäk nadäweno udeta ba gabäŋpäŋ gäk webe siwoŋi yäŋ nadäŋ gamineŋta wanotka Abrahamta siliwa moneŋ 1,000 ude imitat yäk. ");
INSERT INTO iou_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Täŋpäkaŋ Abimelektä Sara webenita yäpuko kadäni uken Anututä Sarata yäŋpäŋ Abimelek webeni ba piä webeniye nanak nämo bäyakta kädet täŋpipiŋ yämiŋkuk. Äruŋ itneŋta nadäŋ yämiŋkuko uwä Abrahamtä Sara äneŋi yäpmäŋpäŋ Anutuken yäŋapiŋirän nanak bäyakta kädet äneŋi peŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Kadäni uken Yawetä ini bian yäŋkehäromtak man yäŋkuko uterakgän Sarata iron täŋ imiŋirän nanak itpäŋ Abraham tägawani täŋirän nanak bäyaŋ imiŋkuk. Anututä kadäni uken api bäyawen yäŋ bian yäŋkehärom taŋkuko kadäni ukengän bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Täŋpäkaŋ nanak Saratä bäyaŋ imiŋkuko u Abrahamtä wäpi Aisak iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aisak ahäŋpäŋ kepma 8 täreŋirän Abraham u Anututä man iwetkuko u iwatpäŋ Aisak u gupi moräk madäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Täŋpäkaŋ Abraham obaŋ 100 täreŋirän nanaki Aisak u ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ahäŋirän Saratä ŋode yäŋkuk; Anututä kädet täwit namiŋkuko unita bumta oretat yäk. Kubätä nadäŋpäŋä bok api oretde. ");
INSERT INTO iou_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ude yäŋpäŋ yäkgän ŋode täŋkuk; Netätä Abraham Saratä nanak kubäta nonoŋ api imek yäŋ iwerän? Täga nämo, upäŋkaŋ Abraham tägawaniinik täŋirän nanak kubä bäyaŋ imitat yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Eruk, nanak u tägaŋpäŋ nonoŋ peŋkuko kepma uken Abrahamtä äŋnak-äŋnak pähap täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Täŋpäkaŋ kadäni kubäken nanak Isip webe Hagatä Abrahamta bäyaŋ imiŋkuko u Aisakkät täŋoret täŋ irirän Saratä yabäŋpäŋ Abraham iwetkuk; Gäk piä webe ukät nanaki bok yäwat kire! yäk. Piä webe u täŋo nanakikät nanakna Aisak, yarä unitä gäkŋo tuŋum bok nämoinik api koredeŋ yäk. Nanakna Aisak unitägän gäkŋo tuŋum api korewek yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Saratä ude yäŋirän Abraham jägämi nadäŋkuk, Ismael imaka, u unitäŋo nanakigän unita. ");
INSERT INTO iou_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Jägämi nadäŋirän Anututä Abraham ŋode iwetkuk; Nanaka ba piä webeka unita nadäwätäk nämo täŋpen yäk. Saratä man gäwerako u burami yäk. U imata? Aisak täŋo nanakiye-tägän wäpka biŋam u terak api pat yäpmäŋ äroweko unita yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Upäŋkaŋ näkä täŋpewa piä webeka täŋo nanaki uterak äma äbot pähap kubä api ahäneŋ. Ismael u gäkŋo nanakgän unita api nadäŋ imet yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Eruk patkuko yäŋeŋirän Abraham akumaŋ ketemkät ume ehät täŋtuŋum taŋpäŋ Haga täŋo piriken peŋkaŋ nanaki iniŋ kireŋpäŋ yäwet-pewän kuŋkumän. Kuŋtäŋgän Beseba kome äma nämo iraniken uken täŋguŋguŋ täŋtäŋ kuŋatkumän. ");
INSERT INTO iou_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Kuŋattäkon umetä paorirän nanaki päya äyuŋken tewän irirän nanaki kaŋirän kumäkta bitnäŋpäŋ inigän ban bumik päŋku itkuk. Päŋku itkaŋ butewaki nadäŋpäŋ konäm kotkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Täŋpäkaŋ nanaki imaka, konäm korirän Anutu nadäŋkuk. Nadäŋirän Anutu täŋo aŋero kunum gänaŋ itkaŋ Hagata gera ŋode yäŋkuk; Jide ahäŋ gamänpäŋ kotan? Umuntäweno! Anututä nanaka pat itkaŋ kotak u nadätak yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Akumaŋ päŋku nanaka yäpmäŋ akuŋpäŋ iniŋ bitnä. Nadätan? Näkä täŋpewa nanak uterak äbot pähap api ahäneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Täŋpäŋ Anututä nadäŋ imänpäŋ dapun ijiŋpewän kwäpäŋ ume dapuri kubä kaŋkuk. Ude kaŋpäŋ päŋku ume ehät piwän tokŋewänkaŋ yäpmäŋ päŋku nanaki towiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Täŋpäkaŋ Anututä nanak u watäni irirän tägaŋkuk. Kome jopi uken it yäpmäŋ kuŋpäŋ tom däpmäkta mebäri kudup nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Täŋkaŋ kome jopi wäpi Paran u irirän miŋitä Isip webe kubä yäpmäŋpäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kadäni uken Abimelek ba komi ämaniye täŋo watä äma wäpi Fikol ukät päŋku Abraham iwetkumän; Imaka u ba u täk täyan uwä Anututä täŋkentäŋ gamiŋirän täk täyan yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Unita näk ba nanaknaye ba nanaknaye täŋo nanakiye jop kubä nämo yäŋ-yäkŋarenta apiŋo kome ŋokengän Anutu wäpi yäŋpäŋ yäŋkehäromtaŋ nimi yäk. Gäk kome mähemi nämo itan unita näkä iron täŋ gamik täyat udegän gäkä näka ba ämawebe ŋo nanikta iron täŋ nimik täyi yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ude iweränä Abrahamtä ŋode iwetkuk; Näwetan ude yäŋkehärom täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ude yäŋpäŋ Abrahamtä Abimelek ŋode yäŋahäŋpäŋ iwetkuk; Nadätan? Gäkŋo piä ämakayetä ume nakta awaŋ äneŋpani kubä niyomägatkuŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Iweränä Abimelektä iwetkuk; Äma netä ude täŋ gamiŋkuŋo u näk nämo nadätat yäk. Bian man täpuri kubä nämo näweriri nadäŋkuropäŋ apiŋogän yäŋiri nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ude iweränkaŋ Abrahamtä sipsip ba bulimakau mäyap Abimelekta buŋät imänpäŋ bänep kubägän täŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Täŋpäŋ Abrahamtä sipsip nanaki, webeni 7 ude yäpmäŋ daniŋpäŋ inigän yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Yepmaŋirän Abimelektä yabäŋpäŋ yäŋkuk; Ima mebärita sipsip webeni 7 ŋo yäpmäŋ danitan? ");
INSERT INTO iou_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yäŋirän iwetkuk; Näkä ume awaŋ äneŋkuro näkŋaken yäŋ nadäŋpäŋ sipsip webeni 7 gamitat ŋo yäpmäŋkaŋ bureni yäŋ nadäwen yäk. ");
INSERT INTO iou_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Täŋpäkaŋ Abraham kenta Abimelek kome uken bänep kubägän täŋkumäno unita kome u wäpi Beseba yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Eruk bänep kubägän täŋpäŋ itkaŋ Abimelekkät komi ämaniye täŋo watä äma Fikol ukät Filistia komeken äneŋi kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kuŋirän Abrahamtä päya kubä Beseba komeken piŋkuk. Täŋpäŋ ukengän Ekäni Yawe Tärektäreki Nämo u iniŋ oretkuk. ");
INSERT INTO iou_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ude täŋpäŋ Abrahamtä Filistia kome uken kadäni käroŋi itkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","It yäpmäŋ kuŋtäŋgän Anututä Abraham iwet yabäŋkuk; Abraham! Yäwänä yäŋkuk; Ei! Näk ŋo yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Yäwänä iwetkuk; Gäk nanaka kubägän, gäripi nadäŋpäŋ oraŋ imik täyan u imagut yäpmäŋ Moria komeken ku. Kuŋpäŋ pom kubä gäwoŋärewapäŋ uken Aisak utpäŋ ärawata kaŋ ijiŋ nam yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eruk patkuko kome ket nämo yäŋeŋirän Abrahamtä akuŋpäŋ doŋkini kädet kukta ket utkuk. Täŋpäŋä Aisakkät piä ämani yarä yämagurän yäpmäŋ kuŋkuŋ. Ärawa ijikta kädäp duŋpäŋ däkäŋkuko u imaka yäpmäŋpäŋ Anututä kome iwetkukken ukäda kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kuŋtäko kepma yaräkubä täreŋirän kome yäŋkuko bankentä kaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","U kaŋpäŋ piä ämaniyat yäwetkuk; Ek ŋo doŋki watäni irirän Aisakkät nek udu päŋku Anutu iniŋ oretkaŋ ämdayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ude yäŋpäŋ Abrahamtä kädäp Aisakta imän yäpänkaŋ kädäp moräkkät mujuk imaka bok yäpmäŋkaŋ kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kuŋtäŋgän Aisaktä nan yäŋ iweränä Abrahamtä iwetkuk; Nanakna, ima? Ude yäwänä Aisaktä iwetkuk; Nan, kädäp moräk ba kädäp yäpmäŋkamäk ŋo. Täŋkaŋ ärawa täkta tom de? ");
INSERT INTO iou_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yäwänä Abrahamtä iwetkuk; Nanakna, Anututä ini-tägän tom ärawa täkta biŋam pewän ahäwayäŋ yäk. Ude iweränkaŋ kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kuŋtäŋgän Abraham Anututä kome yäŋkukken ahäŋpäŋ mobä bukä kubä täŋpäŋ kädäp uterak peŋkuk. Kädäp peŋpäŋä Aisak iŋitpäŋ pädä täŋkaŋ kädäp-bukä mobä bukä terak peŋkuko u terak punin teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","11","Punin teŋpäŋ mujuk yäpmäŋ akuŋpäŋ nanaki urayäŋ täŋirän Yawe täŋo aŋero kunum gänaŋ itkaŋ gera yäŋpäŋ iwetkuk; Abraham! Abraham! yäŋ yäŋirän Abrahamtä yäŋkuk; Ei, näk ŋo yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yäwänä aŋerotä iwetkuk; Nanaka ŋo u ba u täŋ imeno! Gäk nanaka kubägäninik näka namikta nämo iyap taŋiri gabäŋpäŋ gäk Anutu u umuri yäŋ nadäŋpäŋ oraŋ namiŋpäŋ kuŋat täyan yäŋ nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ude iwerirän Abrahamtä dapun ijiwän kwäpäŋ kaŋkuk; Sipsip ämani kubä yen obättä joŋanigän wabiwänkaŋ irirän kaŋkuk. Irirän kaŋpäŋ päŋku sipsip u yäpmäŋpäŋ nanaki komenita Anututa ärawa täŋ ima yäŋpäŋ ijiŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Täŋpäkaŋ Abrahamtä kome u wäpi Yawetä Api Täŋkentäŋ Namek yäŋ iwetkuk. Unita apiŋo Yawe iniken pomi terak api täŋkentäŋ nimek yäŋ pen yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","17","Täŋpäkaŋ Yawe täŋo aŋerotä Abrahamta gera äneŋi yäŋkuk. Yawe näkä ŋode yäyat yäk. Gäk nanaka kubägän nämo iyap tano unita täŋkentäŋ gamiŋpewa kunum terak guk mäyapinik itkaŋ ude, ba gwägu gägäniken mobä jiraŋ ude oraŋkayetä api ahäneŋ. Täŋkaŋ oraŋkayetä iwan täŋo yotpärare inita api koreneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ba oraŋkaye terak näkä nadäŋ yämiŋpewa äma äbot uken-uken nanik kuduptagäntä iron pähap api yäpneŋ yäk. U imata, gäk näkŋo man buramik täyan unita. Man yäyat ŋo Yawe näkŋa wäpna terak yäŋkehärom täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ude täŋpäŋ Aisak yanani äneŋi päŋku piä ämaniyat yämaguränkaŋ Beseba komeken penta kuŋkuŋ. Täŋpäkaŋ Abraham kome uken pen it yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","It yäpmäŋ kuŋtäyon kadäni kubäken Abraham manbiŋam ŋode iwetkuŋ; Monäka Naho unitäŋo webeni Milkatä nanaki ŋode bäyaŋ imiŋkuk; Usi intäjukun, eruk mäden Busi, Kemuel (u Aram täŋo nani), Keset, Haso, Pildas, Jitlap, Betuel yäk. Täŋpäkaŋ Betueltä Rebeka bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Täŋ Naho täŋo webeni kubäwä wäpi Reumatä nanak ätu bäyaŋkuko wäpiwä ŋode; Teba, Gaham, Tahas, Maka. ");
INSERT INTO iou_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Täŋpäkaŋ Sara obaŋ 127 tärewänkaŋ kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Yotpärare Hebron, Kenan komeken kumbuk. Kumäŋirän Abrahamtä päŋku konäm butewaki täŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham konäm kottäŋgän eruk akumaŋ Hit äboriyetä itkuŋken u kuŋpäŋ yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Näk kome mähem nämo, äma äbanitä in bämopjinken it täyat unita in webena kumbuko u änekta kome kubä näwoŋärewäkaŋ moneŋ tamayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Yäwerirän Hit ämatä iwetkuŋ; Ärowaninin, juku peŋiri gäweritna nadä; Nin gäka äma ekäni pähap yäŋ nadäŋ gamik täkamäŋ unita nintäŋo äma kumbani änekta awaŋ äneŋpani kubä kawi gärip tawänä upäŋ täga gamine yäk. Ninken nanik kubätä iyap tänaŋi nämo yäk. Uken ba uken ba webeka kumbuko u täga api äneŋpen yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yäŋirä Abrahamtä Hit äma gwäjiŋ äpmoŋ yämiŋpäŋ yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Intä webena komejinken äneŋpetta bureni nadäŋ namiŋpäŋä ŋode täŋ namikot; Mobä awaŋ wäpi Makpela upäŋ yäpayäŋ nadätat unita kome u mähemi näka biŋam iwerirä naniŋ kirewänkaŋ api suwawet yäk. Mobä awaŋ uwä mähemi Efron, Soha täŋo nanaki u. Awaŋ uwä unitäŋo kome moräkiken itak yäk. Iŋamjinken mobä awaŋ u gwäki mähemitä yäwänkaŋ uterakgän api imet yäk. Ude täŋ namiŋirä webena bämopjinken api äneŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","11","Täŋpäkaŋ Efron ini bok itkaŋ yäŋirän nadäŋkuk. Nadäŋpäŋ noriye käbeyä täŋkuŋken äbä itkuŋo unitä nadäŋirä Abraham iwetkuk; Ärowanina, yäyan ude nämo yäk. Näkä nadätat ude gäwera. Kome ukäda gäka biŋam ganiŋ kiretat. Mobä awaŋ äma kumbani änekta biŋam ukät kome u käda bok jop ganiŋ kiretat yäk. Notnaye itkaŋ ŋo kudup iŋamiken ganiŋ kiretat yäk. Gäka biŋam täyak unita webeka u kaŋ äneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","13","Iweränkaŋ Abrahamtä kome u nanik gwäjiŋ äpmoŋ yämikgän täŋpäŋ ämawebe itkuŋo u nadäŋirä Efron ŋode iwetkuk; Ude nämo, näkä nadätat ude gäwera nadäsi; Kome u jop naminaŋi nämo. Kome gwäkita gama yäpmäŋiri webenawä api äneŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Iweränä Efrontä yäŋkuk; ");
INSERT INTO iou_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ärowanina, kome yäyan unitäŋo gwäki siliwa moneŋ 400 peyat yäk. Imata man wari yäde? Webeka yäpmäŋ päŋku u äneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iwerirän Abrahamtä täga yäŋ nadäŋpäŋä gwäki Hit ämawebetä nadäŋirä yäŋkuko ude yäpmäŋ daniŋpäŋ imiŋkuk. Kome mähem täŋo siliwa moneŋ täŋo bäräpini kaŋpäŋ nadäwani uterak siliwa moneŋ 400 ude yäpmäŋ daniŋpäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Eruk, moneŋ imänpäŋ Hit ämawebe käbeyä täŋkuŋken äbä itkuŋo u iŋamiken Abrahamta biŋam kome Makpela, Mamre kome käda yäŋkuko u iniŋ kireŋkuk. Kome, päya ba awaŋ äma kumbani pekta biŋam äneŋpani u kudup iniŋ kireŋkuk. Täŋpäkaŋ Abrahamtä mobä awaŋ suwaŋkuk-ken webeni Sara u äneŋkuk. Kome uwä Kenan kome bämopiken itkuk. ");
INSERT INTO iou_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ude täŋkuŋo uwä Hit kome mähemtä kome ba awaŋ uwä Abrahamta biŋam yäŋtäreŋ imiŋpäŋ iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham kadäni käroŋi it yäpmäŋ äroŋtäŋgän tägawani täŋkuk. Imaka imaka täŋkuko uwä Yawetä iron täŋ imiŋirän säkgämän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Tägawani taŋpäŋ kadäni kubäken Abrahamtä piä watä ämani intäjukun täŋpani, tuŋumi kuduptagänta watä irani u ŋode iwetkuk; Ketka gäyeknaken peŋpäŋ Yawe, kunum täŋo Anutu ba kome täŋo Anutu u iŋamiken yäŋkehäromtak man ŋode näwet; Nanakata Kenan webe, kome itkamäŋ ŋoken nanik kubä nämoinik kaŋ-ahäŋ imet yäŋ näwet! Gäk Aisakta webe kaŋ-ahäŋ imayäŋ nadäŋpäŋä näkŋa komeken kuŋkaŋ näkŋo äbotken nanik webe kubä kaŋ yäpmäŋ imi. ");
INSERT INTO iou_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ude yäwänä piä watä ämanitä iwetkuk; Webetä näkkät ŋo äbäkta gäripi nämo nadäwänä jide kaŋ täŋpet? Nanaka kome ŋo peŋpeŋ komekaken käwep api imagut yäpmäŋ kwet? ");
INSERT INTO iou_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Yäwänä iwetkuk; Nämo! Nanakna u komenaken nämoinik imagut yäpmäŋ kwen! ");
INSERT INTO iou_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kunum täŋo Anutu Yawetä näkŋa kome kujatna ba nanatä äbot bämopiken nanikpäŋ nämagut yäpmäŋ äbäŋpäŋ man kehäromi ŋode näwetkuk; Yerikayeta kome itan ŋo bureni api yämet yäŋ näwetkuk. Unita nanaknata webe kubä näkŋa komeken nanikpäŋ kaŋ-ahäŋ imayäŋ täŋiri Yawetä aŋeroni iwerän päŋku intäjukun kuŋ gamiŋpäŋ api täŋkentäŋ gamek yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Webe kaŋ-ahäwayäŋ täno unitä gäkkät äyäŋutpeŋ äbäkta gäripi nämo nadäwänä eruk yäŋkehäromtak man näwetan unita nadäwätäk nämo täŋpen. Upäŋkaŋ ŋode nadä! Nanakna komenaken nämoinik imagut yäpmäŋ kwen! ");
INSERT INTO iou_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ude yäwän nadäŋpäŋä piä watä ämani uwä keri, mähemi Abraham gäyekiken peŋkaŋ man iwetkuko u täkta yäŋkehärom taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","11","Ude yäŋkaŋ piä watä ämani uwä mähemi Abraham täŋo kamel ätu itkuŋo ukät nanik 10 yämagutkuk. Täŋpäŋ mähemi täŋo tuŋum imaka tägatäga mebäri mebäri kobet täŋ yäpmäŋ kuŋkuk. Tuŋum ude täŋpäŋ yäpmäŋ kuŋtäŋgän Mesopotemia komeken Naho täŋo yotpärare keräp taŋpäŋ ume näŋpaniken ahäŋkuk. Ahäŋpäŋ itpäŋ kamel yäwerän gukuri imäpmok täŋkuŋ. U bipäda ahäŋkuk, webe u nanik täŋo ume gwetgwet kadäni bumik täŋirän. ");
INSERT INTO iou_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Täŋkaŋ piä watä äma unitä Anutuken ŋode yäŋapiŋkuk; O Yawe, mähemna Abraham täŋo Anutu, gäk apiŋo Abrahamta yäŋpäŋ iron täŋ imiŋpäŋ täŋkentäŋ namiŋiri piä täga täŋpa. ");
INSERT INTO iou_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Näka nabä! Näk ume dapuriken ŋo irira kome ŋo nanik täŋo webe gubaŋi umeta äbäkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ŋode irira webe gubaŋi kubä äbäŋpäŋ ume gwet nami näŋpayäŋ iwerapäŋ ŋode näwerän; Ŋo naŋiri kamelkayeta gwet yäma naŋput yäŋ. Ude yäwayäŋ täko webe u uwä piä ämaka Aisakta biŋam iwoyäŋkun yäŋ nadäwayäŋ yäk. Ude näweränä mähemna Abrahamta iron täŋ imitan yäŋ nadäwayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Man ude Anutu nämo iwet moreŋirän uterakgän Rebekatä ume gwetta ume käbot buramiŋ yäpmäŋ äbuk. Webe uwä Milka nanaki Betuel unitäŋo äperi. Milka uwä Abraham monäni Naho täŋo webeni. ");
INSERT INTO iou_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","17","Täŋpäkaŋ Rebeka uwä iŋami dapun säkgämän. Webe gubaŋi, ämakät nämo pärani ba kuŋarani. Webe unitä ume dapuriken äpmo ume gwetkaŋ äneŋi äbäŋirän piä watä äma unitä dubiniken bäräŋeŋ kuŋpäŋ iwetkuk; Nadäŋ namiŋiri ume käbotken ŋo ätu näŋpa yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ude iweränä Rebekatä ume käbot u piriken nanik yäpmäŋ äpäŋpäŋ iwoŋäreŋpäŋ iwetkuk; Ekänina ŋo naŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Naŋpikaŋ kamelkayeta udegän gwetpäŋ yämiŋira naŋpä koki täŋput yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ude yäŋpäŋ ume käbotken nanik kamelta gäpe gänaŋ bäräŋeŋ piwän äpmoŋkuŋ. Piwän äpmoŋpäkaŋ äneŋi bäräŋeŋ päŋku ume ätukät gwet yäpmäŋ äbuk. Ude täŋtäyon kamel 10 u ume naŋpä tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ude täŋ irirän Yawetä nadäŋ imiŋpäŋ piäni täŋo bureni webe ŋo terak pewän ahätak ba nämo yäŋ u kaŋpäŋ nadäkta piä äma unitä webe u ket täŋpäŋ kaŋiwat itkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Eruk, kameltä ume naŋ morewäkaŋ piä äma uwä iŋami epmäget täŋ imiŋpäŋ siworok yarä keri kukŋi kukŋi peŋ imiŋkuk. Epmäget uwä golpäŋ täŋpani, gwäki taŋipäŋ peŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Peŋ imiŋpäŋ iwet yabäŋkuk; E nanka wäpi netä? Täŋkaŋ ninä intä yotken täga pätnayäŋ? ");
INSERT INTO iou_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","25","Ude iweränä iwetkuk; Nana wäpi Betuel, Naho kenta Milka täŋo nanaki yäk. Ninkät täga pätnayäŋ. Täŋkaŋ nintä yotken ketem kamelkayetä nakta mäyap itkaŋ ba unitä däpmon patta bägup täga itkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Yäwänkaŋ piä watä ämatä gwäjiŋ äpmoŋpäŋ Yawe iniŋ oretpäŋ yäŋkuk; Mähemna Abraham täŋo Anutu Yawe u wäpi yäpmäŋ akutat yäk. Anutu uwä mähemna Abrahamta nadäŋ imiŋpäŋ bänep iron täŋpäŋ yäŋkehäromtak man yäŋkuko unitäŋo bureni nämo iyap taŋkuko unita iniŋ oretat yäk. Täŋkaŋ näka imaka, nadäŋ namitak. Yawe u kädet siwoŋi nämagut päbä nepmaŋpäŋ mähemna täŋo nägät moräktä yotken ahätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Täŋpäkaŋ webe gubaŋi uwä bäräŋeŋ päŋku miŋitä yotken ahäŋpäŋ ämawebe itkuŋo u ume terak imaka ahäŋkuko u manbiŋam kudup yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Iwerirän Rebeka wanori wäpi Laban unitä epmäget iŋamiken ba siworok keriken u yabäŋkaŋ manbiŋam yäŋkuko u nadäŋpäŋ bäräŋeŋ kumaŋ Abraham täŋo piä watä äma kamelkät ume terak irirä yabäŋ ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yabäŋ ahäŋpäŋ iwetkuk; Anututä iron täŋ gamani gäk äbikaŋ kuna yäk. Yotpärare gägäniken ŋo imata itan? Näk gäka ba kamelkayeta irit patpat kome ket urat yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ude yäŋpäŋ äma ukät kamelniye yämagut yäpmäŋ Rebeka miŋitä yotken kuŋkuk. Kuŋkaŋ kamel terak nanik tuŋum ketäreŋpäŋ peŋkaŋ kamelta ketem yämän naŋ irirä äma yarä u yot gänaŋ äroŋkumän. Äroŋpäŋ Abraham täŋo piä watä äma ukät piä ämaniye bok äbuŋo unita kuroŋi ärutta ume gäpe gänaŋ piŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ude täŋkaŋ ketem peŋ yämiŋkuŋ. Peŋ yämiŋirä Abraham täŋo piä watä ämatä yäŋkuk; Nadäŋ namiŋirä man nadätat u yäwa tärewänkaŋ ketem kämi näŋpayäŋ yäk. Yäwänä Labantä iwetkuk; Yäyan ude tä yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yäwänä watä äma unitä yäŋkuk; Näk Abraham täŋo piä äma yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawetä mähemna Abrahamta iron pähap täŋ imiŋkuko unita tuŋum äma täyak yäk. Sipsip, bulimakau, siliwa ba gol moneŋ, piä äma, piä webe, kamel, doŋki ude imani. ");
INSERT INTO iou_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Täŋpäkaŋ mähemna täŋo webeni Sara uwä webe pähap terak nanak kubä bäyaŋ imiŋkuk. Bäyaŋ imän tägawänkaŋ Abrahamtä tuŋumi kuduptagän nanakita äriwän äpmoŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Täŋpäŋ mähemnatä mani buramikta man kehäromi näwet-pewän yäŋkehärom taŋkut yäk. Ŋode täŋpen yäŋ näwetkuk; Gäk nanaknata webe kubä Kenan kome it täyat ŋoken nanik nämo yäpmäŋ imen yäŋ näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nanatä komeken näkŋa äbotken kuŋkaŋ nanaknata webe uken nanikgänpäŋ kaŋ yäpmäŋ imi. Ude näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ude näwerirän mähemna ŋode iwetkut; Webe unitä ŋo äbäkta gäripi nämo nadäwänä jide api täŋpet? yäŋ iwetkut. ");
INSERT INTO iou_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ude iwerawä kowata ŋode näwetkuk; Yawe iŋamiken it yäpmäŋ äbäk täyat unitä aŋero kubä peŋ iwet-pewän gäkkät itpäŋ täŋkentäŋ gamiŋirän piä gamitat ŋo unitäŋo bureni api ahäwek yäŋ näwetkuk. Gäk näkŋa kome kujat nanatä koŋken nanik nanaknata webe kubä api yäpmäŋ imen yäŋ näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Näkŋo äbotken naniktä webe kubä nanaknata nämo gamäwä, eruk, yäŋkehärom täyan unita nadäwätäk nämo täŋpen yäŋ näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Täŋpäkaŋ apiŋo ume dapuriken ahäŋpäŋ Anutu ŋode iwerat; Yawe, mähemna Abraham täŋo Anutu, piä täŋpayäŋ äbätat unita gäk täŋkentäŋ namiŋiri bureni täga ahäwayäŋ? ");
INSERT INTO iou_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","44","Ume dapuriken ŋo irira webe gubaŋi kubätä äbäŋpäŋ ume täpuri gwet nami näŋpayäŋ iwerapäŋ ŋode näwerän; Ŋo naŋiri kamelkayeta gwet yämayäŋ. Ude yäwayäŋ täko webe uwä mähemna täŋo nanaki unita biŋam, Yawetä iwoyäŋkuko u yäŋ nadäwayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","46","Eruk, bänepnatä ude nämo yäŋtäreŋira uterakgän Rebekatä ume käbot buramiŋ päbä ume dapuriken ahäŋpäŋ ume gwerak. Täŋirän ŋode iwerat; Ume nami näŋpa yäŋ iwerira uterakgän ume käbot piriken nanik yäpmäŋ äpäŋpäŋ ume gwetpäŋ näwerak; Naŋiri kamelkayeta udegän gwet yämayäŋ yäk. Ude yäŋ nadäŋä ume gwet namän naŋira kamelta udegän gwet yämän naŋ. ");
INSERT INTO iou_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ude täŋpänä iwerat; Gäk netä täŋo äperi? Ude yäwawä näwerak; Näk Naho Milka nanaki Betuel unitäŋo äperi yäk. Ude näweränä epmäget iŋamiken peŋpäŋ siworok keri kukŋi kukŋi peŋ imit. ");
INSERT INTO iou_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ude täŋpäŋ gwäjiŋ äpmoŋpäŋ Yawe iniŋ orerat yäk. Bureni, mähemna täŋo Anutu Yawetä monäni täŋo äbeki nanakita webe biŋam yäpmäkta kädet täga terak nämagutkuko unita wäpi yäpmäŋ akut! ");
INSERT INTO iou_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Eruk näwerut; In mähemnata nadäŋ imikinik täŋpäŋ iron täŋ imikta nadäkaŋ ba nämo? Nämo yäŋ nadäŋpäŋä näweräkaŋ u ba u api täŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ude yäweränkaŋ Labankät nani Betueltä iwetkumän; Ŋowä Yawe täŋo kudän unita nektä u ba u yänaŋi nämo yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka iŋamkaken itak ŋo. Mähemka täŋo nanakita webe biŋam Yawetä yäŋkuko udegän täŋpäŋ kaŋ imagut yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ude yäŋirä nadäŋpäŋ Abraham täŋo piä watä ämatä Yawe gwäjiŋ äpmoŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ude täŋpäŋ epmäget siliwa golpäŋ täŋpani, tek kejima Rebekata imiŋkuk. Täŋpäŋ tuŋum gwäki ärowani ätu uwä Rebeka miŋi wanorita yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Yämänkaŋ Abraham täŋo piä watä äma ukät äma ätu bok äbuŋo u ketem ume yämän naŋpäŋ ugän patkuŋ. Patkuŋo yäŋewänä yäwetkuk; Nepmaŋpäkaŋ mähemnaken kwa yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ude yäwänä miŋi wanoritä yäŋkumän; Webe gubaŋi uwä kepma 10 ude bumik ninkät itkaŋ kaŋ kut yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yäwäwä piä watä äma unitä yäwetkuk; Nabä kätäwä kwa yäk. Yawetä täga täŋ namiŋirän piäna täŋo bureni ahäŋirän imata nepmäŋitkamän? Mähemnaken nabä kätäwä kwa yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ude yäwänä iwetkumän; Eruk webe gubaŋi u imagutpäŋ iwetpäŋ-nadäna yäk. ");
INSERT INTO iou_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ude yäŋpäŋ yäŋpewän äbäŋirän Rebeka iwet yabäŋkumän; Gäk äma ŋokät kukta nadätan? Iweränä Ei, näk kwayäŋ nadätat yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Ei yäŋ yäwänä miŋi wanoritä Rebekakät iniken watä irani webe ba Abraham täŋo piä watä äma ukät yepmaŋpän kunayäŋ täŋirä Rebekata kon man ŋode iwetkumän; O wanotnin, gäk äbot pähap täŋo miŋi täyi. Täŋiri äbotkayetä iwaniye yäwat kireŋpäŋ kome mähemi täkot! ");
INSERT INTO iou_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ude iweräkaŋ Rebekakät piä webeniyetä tuŋum täŋpäŋ kamel terak ärowäkaŋ piä äma unitä yäŋ-yäkŋat yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Täŋpäkaŋ kadäni uken Aisak ume kubä wäpi Irit Mähemitä Nabäk Täyak u peŋpeŋ Negev kome päŋku it täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Eruk kadäni kubäta bipäda itpäŋ-nadäkta piäken kuŋkuko ittäŋgän dapun ijiŋpewän kwäpäŋ kamel äbäŋirä yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Täŋirän Rebekatä udegän dapun ijiŋpewän kwäpäŋ Aisak kaŋkuk. Kaŋpäŋ kamel terak naniktä äpmoŋpäŋ piä äma ŋode iwet yabäŋkuk; Äma piäken naniktä äbätak u netä? ");
INSERT INTO iou_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ude yäwänä piä watä ämatä iwetkuk; U mähemna ubayäŋ yäk. Ude yäŋirän iŋami dapun peŋpipikta tek wädäŋ pewän äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Täŋpäŋ dubiniken ahäŋpäŋ itpäŋ piä ämanitä imaka imaka täŋkuko u Aisak biŋam iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Iwerän tärewänkaŋ Aisaktä Rebeka imagut yäpmäŋ miŋi Saratä yotken yäpmäŋ äroŋpäŋ webenita yäpmäŋpäŋ nadäŋ imikinik täŋ imiŋirän it täŋkumänonik. Ude täŋpäŋ miŋi kumäŋirän butewaki nadäŋpeŋ kuŋatkuko u paotkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Saratä kumbänkaŋ Abraham äneŋi webe kubä yäpuk, wäpi Ketura. ");
INSERT INTO iou_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Unitäwä nanak ŋode bäyaŋ yepmaŋkuk; Simran, Joksan, Medan, Midian, Isbak, Sua. ");
INSERT INTO iou_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan uwä Seba kenta Dedan unitäŋo nani. Täŋkaŋ Dedan uwä äma äbot ŋode täŋo orani; Asu, Letus, Leum. ");
INSERT INTO iou_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Täŋkaŋ Midian täŋo nanakiye ŋodetä ahäŋkuŋ; Efa, Efe, Hanok, Abida, Elda. Äma u kudup u Ketura täŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Täŋpäkaŋ Abraham uwä moneŋ tuŋumi kuduptagän Aisakta biŋam buŋät imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Upäŋkaŋ kodak pen itpäŋ webeniye ätu unitäŋo nanakiyeta tuŋum ätu yämiŋpäŋ nanakna Aisakkät nämo itneŋ yäŋpäŋ edap äbani käda yäwerän kuŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham u it yäpmäŋ äroŋtäyon tägawaniinik täŋpäŋ obaŋ 175 ude tärewänkaŋ kumbuk. Kumbänkaŋ äneŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nanakiyat Aisak, Ismael unitä Makpela awaŋken äneŋkumän. Awaŋ uwä Hit äma Soha nanaki Efron unitäŋo piä Mamre udude käda itkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Piä u Abrahamtä bian Hit nanikpäŋ suwaŋpäŋ webeni Sara äneŋpani-kengän äneŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Täŋpäkaŋ Abraham kumäŋirän Anututä nanaki Aisakta iron pähap täŋ imiŋkuk. Aisak uwä ume awaŋ kubä wäpi Irit Mähemitä Nabäk Täyak u dubiniken it täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","13","Eruk Abraham nanaki Ismael, Sara täŋo watä piä webe Isip nanik wäpi Haga unitä bäyaŋ imiŋkuko unitäŋo nanakiye wäpi tawaŋ ŋode; Tuäni Nebaiot, monäni Keda, gweki Atbel, awäni Mipsam. ");
INSERT INTO iou_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","15","U punin terak Misma, Duma, Masa, Hadat, Tema, Jetu, Nafis, Kedema. ");
INSERT INTO iou_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael täŋo nanakiye 12 unitä äma äbot 12 unitäŋo oraniye pähap ude täŋkuŋ. Äma äbot 12 unitäŋo yottabatä ittäŋ kuŋkuŋo u yotpärare wäpi udegän yäŋ-daniŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Eruk Ismael it yäpmäŋ äroŋtäŋgän obaŋ 137 ude täreŋirän kumbänkaŋ äneŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael oraniye täŋo irit kome uwä Havila kenta Su kome u bämopiken, u Isip kome täŋo edaptä äbani kädatä päŋku Asiria baganiken it yäpmäŋ kuŋkuŋonik. Täŋkaŋ Ismael oraniye täŋo äbot unitä Abraham täŋo nanakiye ätukät not nämo täŋpäŋ inigän inigän it täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","20","Täŋpäkaŋ Abraham täŋo nanaki Aisak unitäŋo manbiŋam ŋode; Aisak u obaŋ 40 ude täreŋirän Betuel täŋo äperi Rebeka webenita yäpuk. Betuel u Aramtä äbotken nanik Mesopotemia kome mähemi. Rebeka wanoriwä Laban. ");
INSERT INTO iou_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka äruŋ ittäyon äpi Aisaktä webenita yäŋpäŋ Yaweken yäŋapik man yäwän nadäŋ imiŋirän Rebekatä nanak kok itkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nanaki yarä nikek miŋi koki gänaŋ patkaŋ kowat ämiwän täŋkumän. Täŋirän miŋitä yäŋkuk; Wära! Imata näkä terak ude ahäŋ namitak? Ude nadäŋpäŋ Yawe iwet yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Iwet yabäwänä Yawetä iwetkuk; Äma äbot yarä kokka gänaŋ itkamän. Äbot yarä gäkken naniktä ahäŋpäŋä ini äbot-äbot api itneŋ. Äbot kubä täŋo kehäromitä kubä täŋo api irepmirek. Intäjukun naniktä mäden nanikta watä piä api täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Täŋkaŋ nanak ahäk-ahäk kadäni täŋirän eruk, gwabäyak ahäŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Intäjukun ahäŋkuko u gupi gämäni täŋkaŋ pujiŋ-pujiŋ ikek, tom pujiŋi ude bumik unita wäpi Iso yäŋ iwetkuŋ. (Ninin man terak Iso uwä pujiŋ yot.) ");
INSERT INTO iou_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Täŋ mäden ahäŋkukotä tuäni Iso täŋo mämeki iŋitkaŋ ahäŋkuk, u wäpi Jekop yäŋ iwetkuŋ. (Jekop u ninin man terak mämeki iŋirani. Täŋkaŋ Isrel naniktä man wärani yäŋkaŋ äma jop man yäwanita mämeki iŋirani yäŋ yäwet täŋkuŋonik.) Aisak u obaŋ 60 ude täreŋirän nanakiyat uwä ahäŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Täŋpäkaŋ nanaki yarä ahäŋkumäno u tägaŋpäŋ Isotä äwanken kuŋatpäŋ tom däpmäkta mebäri nadäŋkuk. Ude täŋirän Jekop uwä kwikinik irani, yotkengän irani. ");
INSERT INTO iou_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Täŋpäkaŋ nani Aisak u tom ägwäri täŋo toharita gäripi nadäŋkuko unita gäripini Iso terak patkuk. Upäŋkaŋ miŋi Rebekatä Jekopta gäripi nadäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","30","Eruk kadäni kubäken Jekop käpek gämäni käbot ijiŋ irirän Iso bipiken naniktä äbäŋpäŋ nakta wakiinik iŋkuŋ. Äbäŋpäŋ Jekop iwetkuk; Bäräŋeŋ, imaka gämäni ijitan u ätu nami näŋpa. Nakta bumta nekaŋ! yäk. Mebäri unita wäpi kubä Edom yäŋ iwerani. (Ninin man terak Edom u imaka gämäni.) ");
INSERT INTO iou_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ude iweränä Jekoptä ŋode iwetkuk; Gäk intäjukun ahäwani täŋo tuŋum yäpmäkta biŋam wäp u naniŋ kirewikaŋ uyaku yäk. ");
INSERT INTO iou_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yäwänä Isotä man kowata ŋode iwetkuk; Eruk yäk. Wäpna biŋam unitä täŋkentäk jidewani api namek? Nämo! Nakta kumäkinik täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ude yäŋirän Jekoptä iwetkuk; Naniŋ kirekta yäŋkehäromtaŋ nam! Ude yäwänä Isotä intäjukun ahäwani täŋo tuŋum yäpmäkta biŋamta yäŋkehärom taŋpäŋ Jekopta iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Iniŋ kireŋirän Jekoptä Isota kärägakät käpek gämäni ijiŋkuko u imiŋkuk. Imän naŋkaŋ kuŋkuk. Bureni, Isotä intäjukun ahäwani täŋo tuŋum yäpmäkta biŋam wäpi unita nadäwän mewuni täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kadäni uken nakta jop irit äneŋi ahäŋkuk. Bianä Abraham täŋo kadäniken kubä ahäŋkuk. Täŋ äneŋi ahätak ŋowä Aisaktä Filistia äbot täŋo intäjukun äma wäpi Abimelek, Gera yotpärareken irirän päŋku ahäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Täŋpäkaŋ Yawetä Aisak ahäŋ imiŋpäŋ ŋode iwetkuk; Isip komeken nämo kwen. Näkä kome kubä gäwoŋärewakaŋ uken päŋku kaŋ it yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kome uken ätu iriri näkä gäkkät itpäŋ api täŋkentäŋ gamet. Täŋkentäŋ gamiŋpäŋ gäk ba nanakaye oraŋkayeta kome kudup u api tamet. Bureni, yäŋkehäromtak man nanka Abraham iwetkuro u api täŋkehärom tawet yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Näkä täŋpewa oraŋkayetä nanak bäyaŋ weŋirä kunum terak guk itkaŋ ude bumta api ahäneŋ. Äbekaye oraŋkaye äbot u terak ämawebe äbot komeni komeni kudupta iron pähap api täŋ yämet. ");
INSERT INTO iou_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","U Abrahamtä näkŋo baga man ba jukumanna u kudup nadäŋpäŋ buramiŋ moreŋkuko unita ude uwä api täŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yawetä ude iweränkaŋ Aisak Gera yotpärare uken it yäpmäŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Irirän kome u naniktä webenita iwet yabäk täŋirä Aisaktä yäwetkuk; U wanotna yäk. Webena yäŋ yäwetta umuntaŋkuk. Man bureni yäwawä ŋo naniktä Rebeka iŋami dapun säkgämän u kaŋgärip täŋpäŋ näk api nutneŋ yäŋ nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Eruk uken kadäni käroŋi ittäŋgän kadäni kubäken Aisaktä webeni Rebekakät täŋoret täŋirän Abimelek, Piristia täŋo intäjukun ämatä ini yotken itkaŋ dapun pärewat täŋpäŋ yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yabäŋpäŋ Aisak yäŋpewän äbäŋirän iwetkuk; Nadätat! Rebeka u webeka yäk. U wanotna yäŋ imata yäŋkun? Yäŋirän Aisaktä yäŋkuk; Bureni, näk Rebeka iŋami dapun täga u kaŋpäŋ nutneŋ yäŋ nadäŋpäŋ ude yäŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Yäŋirän Abimelektä iwetkuk; Wa! Umuri pähap täŋkun yäk. Ämanaye kubätä webeka Rebekakät patkumän yäwänä momi pähap nintä terak pätek yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ude yäŋpäŋ ämawebeniye ŋode yäwetkuk; Kubätä äma ŋo ba webenita imaka waki kubä täŋ yämayäŋ täko uwä kumäk-kumäkta biŋam api täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Täŋpäkaŋ Aisaktä kome uken ketem piä täŋkuk. Täŋirän Yawetä iron täŋ imiŋirän obaŋ ugän ketem bumtainik ahäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","14","Aisak uwä sipsip bulimakau ba piä watä ämaniye ahäŋ bumbum täŋirä tuŋum äma pähap täŋkuk. Ude täŋirän Filistia ämatä kaŋpäŋ nadäwäwak täŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nadäwäwak täŋ imiŋpäŋ ume awaŋ bian nani Abrahamtä itkaŋ piä ämaniye yäwerän äneŋpani u Filistia ämatä kome äneŋi kudup yejämbuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ude täŋirä Abimelektä Aisak ŋode iwetkuk; Gäk nin nirepmitpäŋ äma kehäromi nikek itan unita nipmaŋpeŋ kome kubäken ku yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ude yäwänkaŋ Aisak Gera kome pipiyäwani pähapken äpmoŋpäŋ yottaba täŋpäŋ kome uken kadäni käroŋi bumik itkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Täŋpäkaŋ ume awaŋ Abrahamtä irirän äneŋpani Filistia ämatä Abraham kumäŋirän yejämbuŋo u äneŋi äneŋtäŋ kuŋkuk. Ude täŋpäŋ ume awaŋ unitäŋo wäpi wäpi nanitä yäwani udegän yäŋtäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Täŋ Aisak täŋo piä watä ämaniyetä ume dapuri kudupi kubä kome äneŋpäŋ kaŋ-ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kaŋ-ahäŋirä Gera kome täŋo sipsip watä ämatä Aisak täŋo sipsip watä ämakät yäŋawätpäŋ yäŋkuŋ; Ume ŋo nin täŋo yäk. Yäŋawätkuŋo unita Aisaktä ume awaŋ uwä wäpi Esek yäŋ iwetkuk. (Ninin man terak Esek uwä yäŋawät-awät). ");
INSERT INTO iou_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ude täŋirä äneŋi ume awaŋ kubä änekgän täŋkuŋopäŋ unita äneŋi yäŋawätgän täŋkuŋ. Äneŋi yäŋawätgän täŋkuŋo unita wäpi Sitna yäŋ iwetkuk. (Ninin man terak Sitna u iwan täktäk). ");
INSERT INTO iou_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ude täŋirä kome u peŋpeŋ päŋku ume awaŋ äneŋi kubä äneŋkuk. Ume unita man nämo ahäŋkuk. Man nämo ahäwänpäŋ Aisaktä yäŋkuk; Yawetä kome taŋi ŋo namiŋirän nanak bäyaŋ weŋpäŋ api itne yäŋ yäŋpäŋ ume awaŋ u wäpi Kome Taŋi yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Eruk, Aisak kome uken naniktä Beseba komeken päŋku ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Päŋku ahäŋirän bipani ugän Yawetä ahäŋ imiŋpäŋ iwetkuk; Näk nanka Abraham täŋo Anutu. Näk gäkkät api itdero unita nämo umuntäwen yäk. Piä ämana Abrahamta yäŋpäŋ näk gäkkät itkaŋ täŋkentäŋ gamiŋpäŋ äbekaye oraŋkaye mäyap api pewa ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yawetä ude iwerirän Aisaktä mobä bukä kubä täŋpäŋ Yawe iniŋ oretkuk. Ude täŋpäŋ yottaba kome uken täŋirän piä ämaniyetä ume awaŋ kubä äneŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kadäni kubäken kome uken nanik täŋo intäjukun äma Abimelek ukät watä äma wäpi Ahusat ba komi ämaniye täŋo intäjukun äma wäpi Fikol u Gera komeken naniktä äbä Aisak ahäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ahäŋ imiŋirä Aisaktä yäwetkuk; Imata näkken äbäkaŋ? Iwan täŋ namiŋpäŋ näwat kireŋpewä kome ŋoken äburopäŋ imata äbäkaŋ? ");
INSERT INTO iou_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Ude yäwänä Gera naniktä yäŋkuŋ; Nin Yawetä gäkkät it täyak u kakinik täŋkumäŋo unita bämopninken yäŋkehäromtak man kubä peŋpäŋ gäkkät bänep kubägän tänayäŋ nadäkamäŋ yäk. Nintä gäka waki kubä nämo täŋ gamiŋpäŋ bätaki terak gepmanapäŋ ŋoken äbun. Äbäŋiri Yawetä täŋkentäŋ gamiŋkuk. Unita gäk udegän, waki kubä nämo täŋ nimenta bänep kubägän kaŋ täna yäk. ");
INSERT INTO iou_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ude yäŋirä Aisaktä äŋnak-äŋnak pähap täŋ yämän naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Naŋpäŋ patkuŋo yäŋewänä bänep kubägän itta Aisakkät äma äbuŋo u yäŋkehäromtak man yäŋkuŋ. Ude täŋkaŋ Aisaktä bänep kwini terak yepmaŋpän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Eruk, edap ugän Aisak täŋo piä ämaniye äbä ume awaŋ äneŋkuŋo unita Aisak biŋam ŋode iwetkuŋ; Nin ume kaŋ-ahäkamäŋ yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iwerirä ume awaŋ unitäŋo wäpi Seba yäŋ iwetkuk. Unita yotpärare unitäŋo wäpi Beseba yäŋ iwetkuŋo unitä pen itak. Ninin man terak Beseba u Yäŋkehäromtak Man. ");
INSERT INTO iou_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Täŋpäkaŋ Iso obaŋ 40 ude täreŋirän Hit nanik kubä wäpi Beri unitäŋo äperi Judit webenita yäpuk. Täŋpäŋ Hit nanik kubä wäpi Elon unitäŋo äperi Basemat u bok yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Täŋpäkaŋ webe yarä Isotä yäpuko unitä Aisak yanäpita goret täŋ yämiŋirän bänepitä jägämi pähap nadäk täŋkumänonik. ");
INSERT INTO iou_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Täŋpäkaŋ Aisak u it yäpmäŋ äroŋpäŋ äma tägawani täŋpäŋ dapuri waŋirän imaka imaka ket nämo yabäŋkuk. Eruk, kadäni uken nanaki tuäni Iso yäŋpewän äbänpäŋ Nanakna! yäŋ yäwänä Näk ŋo yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Iweränä nani Aisaktä iwetkuk; Nadätan? Näk äma tägawani täyat. Äma tägawani täŋpäŋ kumäk-kumäkna kadäni u nämo nadätat. ");
INSERT INTO iou_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Unita äpa kuwek yäpmäŋ päŋku bipiken tom kubä kaŋ ut nam. ");
INSERT INTO iou_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Utpäŋä ketem näkŋa gäripi nadäk täyat ude kaŋ ijiŋ nami näŋpa. Naŋ paotpäŋä näk nämo kumäŋkaŋ kon manna kaŋ gäwera tärewän yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Eruk Aisak nanaki Isokät man yäŋpäŋ-nadäk ude täŋirän Rebekatä juku peŋpäŋ nadäŋkuk. Nadäŋpäŋä Iso tomta bipiken kuŋirän Rebekatä nanaki Jekop iwetkuk; Ai, nadätan? Nankatä tuäka ŋode iwerirän nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Gäk tom kubä yäpmäŋ päbä ketem gäripi nikek ijiŋ namiŋiri Yawe iŋamiken kon manna gäwetkaŋ kaŋ kumba yäŋ iwetak. ");
INSERT INTO iou_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ude iwetak unita nanakna, näkä man gäwera nadäŋpäŋä burami. ");
INSERT INTO iou_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gäk ŋodetä kuŋkaŋ meme gubaŋi säkgämän yarä yäpmäŋ äbi. Yäpmäŋ äbäŋiri nankata ketem ini gäripi nadäk täyak u ijiŋ imayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ijiŋ imakaŋ yäpmäŋ nankaken yäpmäŋ ärowipäŋ naŋkaŋä gäkpäŋ kon mani gäwetkaŋ kaŋ kumbän yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ude iwerirän Jekoptä miŋi Rebeka iwetkuk; Ude täga upäŋkaŋ Iso u pujiŋ yot, nähä dudumi yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nanatä nepmäŋitpäŋ nadäwektagän yäk. Ude täŋpero uwä gäk täŋikŋarani äma yäŋ näwetpäŋ kon manta kowata tagwän man näwerek yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yäŋirän miŋitä iwetkuk; Nanakna, ude nämo! Tagwän man uwä näkä terak kaŋ ärowän yäk. Gähäwä manna buramiŋpäŋ imaka unita gäwetat u päŋku yäpmäŋ äbi yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ude iweränkaŋ Jekop päŋku meme yäpmäŋpäŋ miŋita imiŋkuk. Imänkaŋä miŋitä ketem nanitä gäripi nadäk täŋkuko ude ijiŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ude täŋkaŋ nanaki tuäni täŋo tek täga kubä eŋi gänaŋ itkuko u yäpmäŋpäŋ Jekopta täŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Täŋ imiŋpäŋ tom däpuko unitäŋo pujiŋi yäpmäŋpäŋ keri kotäki dudumi uwä uwäk täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Uwäk täŋ imiŋpäŋä tom ba käräga gäripi nikek ijiŋkuko u imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Imänkaŋ ketem u yäpmäŋkaŋ naniken kuŋpäŋ iwetkuk; Nan yäk. Yäwänä iwetkuk; Nanakna, gäk netä? ");
INSERT INTO iou_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yäwänä Jekoptä nani iwetkuk; Näk nanaka tuäka, Iso yäk. Man näwerano u täŋ moretat. Gäk akuŋpäŋ itkaŋ ketem yäpmäŋ äbätat ŋo naŋkaŋ kon man näwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yäwänä Aisaktä nanaki iwetkuk; Nanakna, jide täŋpäŋ tom u bäräŋekinik kaŋ-ahätan? Yäwänä ŋode iwetkuk; Yawe, gäkŋo Anutu unitä näwoŋärewänkaŋ kaŋ-ahätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ude yäwänä Aisaktä iwetkuk; Nanakna, äbikaŋ gäk nanakna Iso yäŋ siwoŋi nadäkta gepmäŋit nadäwa. ");
INSERT INTO iou_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ude yäwänä Jekoptä nani dubiniken kuŋirän iŋit nadäŋkuk. Iŋit nadäŋpäŋ yäŋkuk; Manka kotäk nadäŋira Jekop täŋo man kotäk bumik täyak upäŋkaŋ ketka gepmäŋitpäŋ nadäwa Iso täŋo bumik täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ude yäŋpäŋ keri Iso täŋo bumik pujiŋi nikek yäŋ nadäŋpäŋ nämo kaŋkuko unita kon imayäŋ nadäŋpäŋ yäŋyabäk ŋode täŋkuk; ");
INSERT INTO iou_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Gäk bureni nanakna Iso ba? Yäwänä Jekoptä yäŋkuk; Näk ubayäŋ. ");
INSERT INTO iou_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Näk ubayäŋ yäŋ yäwänä nanitä iwetkuk; Nanakna, tom ketem ijiwani u yäpmäŋ äbi naŋpäŋä kon manna gäwerayäŋ yäk. Ude iwerirän Jekoptä ketem u yäpmäŋpäŋ imän naŋkuk. Täŋpäŋ wain ume bok imän naŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Naŋ paotpäŋä nani Aisaktä ŋode iwetkuk; Nanakna, dubinaken äbäŋpäŋ bumumnaken neŋpäŋ naniŋ oret yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ude iweränä Jekop nani dubiniken kuŋpäŋ iniŋ oretpäŋ nani bumumiken iŋkuk. Täŋirän teki käbäŋ nadäŋpäŋ kon man ŋode iwetkuk; Nanakna täŋo gupi käbäŋ u äwan täŋo käbäŋ bumik, säkgämän, Yawetä gäripi nikek peŋkuko u bumik yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anututä guk näburum ba kome täŋo gakŋi gamiŋirän säguom ba wain ahäŋ bumbum täkot. ");
INSERT INTO iou_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Äma komeni komenitä oraŋ gamiŋpäŋ piä täŋ gamik täkot. Täŋirä notkayeta intäjukun täŋ yämisi. Ba meŋka täŋo äbotken naniktä oraŋ gamik täkot. Täŋkaŋ kubätä tagwän man gäweränä unita kowata tagwän man u terak äroton. Ba kubätä ganiŋ orerirän kowata udegän ahäŋ imiton. ");
INSERT INTO iou_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisaktä Jekop kon man ude iweränkaŋ Jekoptä nani mäden täŋ imiŋirän uterakgän tuäni Iso bipiken naniktä äbuk. ");
INSERT INTO iou_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Äbäŋpäŋ ketem gäripi nikek Jekoptä ijiŋkuko udegän ijiŋpäŋ naniken yäpmäŋ äbäŋpäŋ iwetkuk; Nan, akuŋpäŋ itkaŋ ketem yäpmäŋ äbätat ŋo naŋpäŋ kon manka näwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Iweränä Aisaktä iwetkuk; Gäk netä? Iweränä Näk nanaka tuäka Iso yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Iwerirän Aisaktä bärom pähap täŋpäŋ yäŋkuk; Netä unitä tom utpäŋ ijiŋ päbä namän nat? Gäk api äbäŋiri tom ketem u naŋpäŋ kon manna iwera tärek. Kon manna imiro uwä bureni yäpmäŋtak, jopi nämo api täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Aisaktä ude iwerirän Isotä konäm kotpäŋ jäpi nadäŋkaŋ nani iwetkuk; Nan! Kon manka näka udegän näwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yäwänä iwetkuk; Monäkatä yäŋnäkŋatpäŋ kon manna gäka biŋam u gomägarak yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ude iweränä Isotä yäŋkuk; Wa! Wäpi Jekop yäŋ iwerani uku ubayäŋ! Kadäni yarä yäŋnäkŋarani täyak. Kubäwä intäjukun ahäk-ahäk täŋo tuŋum yäpmäkta biŋam wäp uwä nomägatkuk yäk. Täŋpäkaŋ apiŋowä nana täŋo kon man näka namikta yäwani nomägatak yäk. Ude yäŋpäŋ yäŋkuk; Näka biŋam kon man kubä itak ba nämo? ");
INSERT INTO iou_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ude yäwänä Aisaktä nanaki Iso iwetkuk; Nadätan? Ude täŋ imiro uterak monäkatä intäjukun api täŋ gamek. Ba noriye kuduptagäntä watä piä api täŋ imineŋ. Ba säguom ba wain umetä ahäŋ bumbum api täŋ imineŋ. Unita nanakna, jide täŋpäŋ imaka de nanikpäŋ gamet? ");
INSERT INTO iou_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ude yäwänä Isotä iwetkuk; O nana, kon manka kubägän paorako uba? Näk imaka, kon man näwet yäk. Ude yäŋpäŋ konäm kähän yäŋpäŋ kotkuk. ");
INSERT INTO iou_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Konäm korirän Aisaktä iwetkuk; Guk näburumtä nämo api täŋkentäŋ gamek. Ba kome gakŋi nämoken api kuŋaren. ");
INSERT INTO iou_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Bureni, gäk ämik täŋpäŋ ketem api kaŋ-ahäwen. Täŋkaŋ gäk monäkata watä piä api täŋ imen. Upäŋkaŋ gäk piä täŋ imikta gaŋani nadäŋpäŋä ärowani täŋ imiŋpäŋ kaŋumuntaŋ api kwen. ");
INSERT INTO iou_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Täŋpäkaŋ Isowä nanitä kon mani Jekopta imiŋkuko unita yäŋpäŋ kokwawak nadäŋ yäpmäŋ kuŋatkuk. Täŋpäŋ bänepitä ŋode nadäŋkuk; Nana täŋo kumäk-kumäki keräp täyak. Kumäŋirän butewaki nadäwa täreŋirän monäna Jekop kumäŋ-kumäŋ api uret yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Eruk Rebekatä nanaki tuänitä man yäŋkuko u biŋam nadäŋpäŋä Jekop yäŋpewän äbänkaŋ ŋode iwetkuk; Nadätan? Tuäka Iso uwä bänepitä kowata däpmäŋ tärekta nadäŋpäŋ gäk kumäŋ-kumäŋ gutta nadäŋpeŋ kuŋatak yäk. ");
INSERT INTO iou_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Unita nanakna, gäk akumaŋ ämetpeŋ wanotna Labantä itakken Aran yotpärareken ku! Gäwetat udegän pengän iwat. ");
INSERT INTO iou_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Wanotna ukät kadäni keräpigän iriri tuäka täŋo kokwawak u kaŋ bam tawän. ");
INSERT INTO iou_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Bam taŋirän imaka täŋ imiŋkuno unita täŋguŋ taŋirän man pewakaŋ kaŋ äbi. Imata kepma kubägän tabäŋ äwaräkuk täŋira nanaknayat bok paotdeŋ? ");
INSERT INTO iou_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Täŋpäkaŋ Rebekatä äpi Aisak ŋode iwetkuk; Yäke! Näk Iso täŋo webeniyat Hit äbotken nanik unita bitnäkinik täyat yäk. Jekoptä udegän kome ŋo nanik, Hit webe udewani kubä yäpeko uwä kaŋ kumba yäŋ api nadäwet! ");
INSERT INTO iou_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rebekatä man ude iwetkuko unita Aisaktä Jekop yäŋpewän päbä kon man äneŋi iwetpäŋ man kehäromi ŋode iwetkuk; Gäk Kenan kome ŋo nanik webe kubä nämoinik yäpen yäk. ");
INSERT INTO iou_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Unita akumaŋ Mesopotemia komeken meŋka täŋo nani Betuel uken ku. Uken meŋka täŋo wanori Laban unitäŋo äperi kubä webekata kaŋ yäpmäŋ. ");
INSERT INTO iou_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ude täŋiri Anutu Kehäromi Mähemitä täŋkentäŋ gamiŋirän nanakaye mäyap ahäkot. Nanakaye mäyap ahäŋirä gäk äbot mäyap täŋo nani ude isi. ");
INSERT INTO iou_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anututä Abraham täŋkentäŋ imiŋkuko gäk ba äbekaye oraŋkaye udegän täŋkentäŋ tamiŋirän kome ŋo kaŋ kore. Kome ŋowä Anututä Abrahamta iniŋ kireŋkuko upäŋkaŋ apiŋo gäk kome mähem bureni nämo, äbani ude itan. ");
INSERT INTO iou_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Man ude yäŋpäŋ Aisaktä Jekop tewän yäpmäŋ Mesopotemia komeken äwäŋi Labanken kuŋkuk. Laban uwä Betuel, Aramtä äbotken nanik unitäŋo nanaki ba Rebeka wanori, Jekop kenta Iso täŋo miŋi u. ");
INSERT INTO iou_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Täŋpäkaŋ Isotä biŋam ŋode nadäŋkuk; Nantä Jekop kon man iwetpäŋ Kenan webe yäpmäkta yäjiwätpäŋ webe yäpmäkta Mesopotemia komeken kukta peŋ iwetkuk. Biŋam ude nadäŋpäŋ pen ŋode nadäkgän täŋkuk; Peŋ iwerirän Jekoptä miŋi nani täŋo man buramiŋpäŋ Mesopotemia komeken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isotä biŋam ude nadäŋpäŋ bänepiken ŋode nadäŋkuk; Nana Aisaktä webe Kenan nanik yäpuro unita nadäwän täga nämo täk täyak yäŋ nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ude nadäŋpäŋ päŋku Abraham nanaki kubä Ismael unitäŋo äperi kubä wäpi Mahalat, Nebaiot täŋo wanori u webenita yäpuk. Yäpmäŋpäŋ webeniyat itkumänkengän tewän yaräkubä täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Täŋpäkaŋ Jekoptä Beseba kome peŋpeŋ Haran yotpärareken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Kuŋtäyon edap äpmoŋirän kädet bämopiken däpmon pärayäŋ täŋkuk. Kome uken mobä mäyap itkuŋo u kubä yäpmäŋpäŋ kunowäta peŋpäŋ patkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Patpäŋ däpmonken, terak kubä moräki kome terak, moräki kunum gänaŋ yäputpäŋ irän kaŋkuk. Terak u terak Anutu täŋo aŋerotä äroŋ äpäŋ täŋirä yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ude täŋirä Yawetä terak moräkiken unu itkaŋ yäŋkuk; Näk Yawe, oraŋka Abraham ba nanka Aisak täŋo Anutu. Kome pätan ŋo gäk ba äbotkayeta api taniŋ kirewet. ");
INSERT INTO iou_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Äbotkayetä ahäŋ bumbum täŋtäko kome terak keŋkeŋ jiraŋ pätkaŋ ude api ahäneŋ. Täŋpäŋ kome kukŋi kukŋi umude ba unude api tokŋeŋ yäpmäŋ kuneŋ. Täŋirä gäk ba äbekaye oraŋkaye terak ämawebe komeni komeni u kuduptagänta iron pähap api täŋ yämet. ");
INSERT INTO iou_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nadätan? Näk gäkkät itkaŋ kome kuŋarayäŋ täno udegän watäni api it gamet. Täŋpäŋ gämagut yäpmäŋ äbäŋira kome ŋoken äneŋi api äben. Näk nämo gepmaŋpäŋ gäkkät irira imaka imaka api gamet yäŋ yäŋkehärom taŋkuro u api ahäŋ morewek yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ude iweränkaŋ Jekoptä akuŋpäŋ ŋode nadäŋkuk; Wära! Näk jop pätat yäŋ nadäropäŋ Yawetä kome ŋo it-inik täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ude nadäŋpäŋ umuntaŋpäŋ yäŋkuk; Kome ŋo umuri-inik. Bureni-inik, ŋowä Anutu täŋo irit kome. Eruk kunum täŋo yäma ŋo yäk. ");
INSERT INTO iou_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Eruk kome yäŋeŋburu taŋirän Jekop akuŋpäŋ mobä kunowäta peŋ patkuko u yäpmäŋ akuŋpäŋ kämi kaŋpäŋ nadäkta käroŋ yäputkuk. Täŋpäŋ Anututa biŋam täkta olip gakŋi umeni piŋ ibatkuk. ");
INSERT INTO iou_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Gakŋi piŋ ibatpäŋä kome u wäpi kodaki Betel yäŋ iwetkuk. (Ninin man terak Betel u Anutu täŋo yot). Kome unitäŋo wäpi biani Lus yäŋ iwerani. ");
INSERT INTO iou_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ude täŋpäŋ Jekoptä ŋode yäŋkehärom taŋkuk; Anutu gäkä näkkät itkaŋ kädet kuŋarayäŋ täro uken nabäŋ näwatpäŋ ketem ba tek pewi ahäŋ namiŋirän nanatä yotken äneŋi säkgämän äbäŋpäŋä eruk Yawe gäka näkŋo Anutu yäŋ api nadäŋ gamet. ");
INSERT INTO iou_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eruk mobä yäputat ŋonitä Anutu ganiŋoret bägup api irek yäk. Täŋkaŋ imaka imaka namayäŋ täyan u kuduptagän yäpmäŋ daniŋpäŋ moräki gäka api gamik täŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Täŋpäkaŋ Jekop kuŋtäŋgän ämawebe edap äbani käda itkuŋken uken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ahäŋpäŋ dapuri ijiwän kwäpäŋ ume awaŋ kubä kaŋkuk. Uken sipsip äbot yaräkubä yabäŋkuk. Kome mähemitä awaŋ uken yawakiye yepmäŋ towik täŋkuŋonik. Täŋkaŋ ume awaŋ unitäŋo meni mobä pähap kubäpäŋ täŋpipiwani. ");
INSERT INTO iou_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mähemiyetä sipsipta ume gwet yäminayäŋ nadäŋpäŋä mobä uwä kireŋ täbot-pewä kuŋirän ume gwetpäŋ sipsip yepmäŋ towik täŋkuŋonik. Yepmäŋ towiŋ moreŋpäŋä mobä u yäpmäŋpäŋ äneŋi komeniken täŋpipik täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Eruk, Jekoptä sipsip watä äma uwä ŋode yäwet yabäŋkuk; Notnaye, in de nanik? Yäwänä iwetkuŋ; Nin Haran nanik yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ude iwerirä yäwet yabäŋkuk; In Naho orani wäpi Laban u nadäkaŋ? Yäwänä Ei, u nadäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nadäkamäŋ yäŋ iweräwä yäwetkuk; U täga itak? Yäwänä iwetkuŋ; Ei, itak yäk. Äperi Resel sipsip yämagut yäpmäŋ äbätak udu käyan? ");
INSERT INTO iou_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ude yäwäwä Jekoptä yäŋkuk; Ai! Sipsip yotken yepmakta kadäni nämo täyak. Ŋo kepma yäk. Unita ume gwetpäŋ yepmäŋ towiŋpäŋ yämagut yäpmäŋ ketemi näŋpaniken äneŋi yepmanaŋi yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ude yäwänä iwetkuŋ; Ude nämo. Yawak äbot äbäŋ morewäkaŋ uyaku ume awaŋ meni täŋpipiwani mobä kireŋ täbotpena kuŋirän sipsip kudup ume yepmäŋ towinayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Man ude yäŋpäŋ-nadäk täŋ irirä Reseltä nani täŋo sipsip yämagut yäpmäŋ äbuk, u sipsip watä webe ude itkuko unita. ");
INSERT INTO iou_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Eruk, Jekop Reseltä äwäŋi Laban täŋo sipsip yämagut yäpmäŋ äbäŋirän kaŋpäŋ päŋku awaŋ meni täŋo mobä kireŋ täbotkuk. Mobä kireŋ täbot-pewän kuŋirän Laban täŋo sipsip ume yepmäŋ towiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ude täŋpäŋ Jekoptä Resel bumumiken iŋpäŋ konäm bumta kotkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Konäm ude kotpäŋ itkaŋ Resel iwetkuk; Näk nanka täŋo nägät moräk, Rebeka täŋo nanaki yäk. Ude iwerirän Resel kuŋpäŋ nani manbiŋam u iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Päŋku iweränä Labantä wanori täŋo nanaki Jekop unitäŋo biŋam nadäŋpäŋ bäräŋeŋ päŋku bäyaŋ imiŋpäŋ bumumiken iŋkuk. Täŋpäŋ imagut yäpmäŋ yoriken äroŋkuk. Äro itkaŋ Jekoptä manbiŋam kuduptagän Laban iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Iwet morewänä Labantä iwetkuk; Bureni, gäk näkŋo nägät moräkna yäk. Eruk Jekop komepak kubä irirän Labantä iwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Gäk nägät moräkna itan upäŋkaŋ imata piä jop api täŋ namiŋ iren? Gwäki jide yäpayäŋ nadätan? ");
INSERT INTO iou_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Täŋpäkaŋ Laban äperiyat yarä, moki wäpi Lea, wenäni wäpi Resel. ");
INSERT INTO iou_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea u dapuri waki. Täŋ Resel uwä iŋami dapun säkgämän, gäripi nikek. ");
INSERT INTO iou_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jekoptä Reselta gäripiinik nadäŋkuko unita äwäŋi iwetkuk; Näk obaŋ 7 ude piä täŋ gamiŋira äpetka wenäka Resel u kaŋ nam yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ude iweränä äwäŋitä yäŋkuk; Täga yäk. Äma kudupita imiŋira waki täŋpek. Gäka gamayäŋ täro uyaku täga api täŋpek yäk. Unita näkkät ŋo kaŋ itda. ");
INSERT INTO iou_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ude yäŋirän Jekoptä Reselta nadäŋpäŋ obaŋ 7 äwäŋita piä täŋ imiŋ yäpmäŋ äroŋkuk. Upäŋkaŋ Reselta gäripi nadäŋkuko unita obaŋ 7 unita nadäŋirän kepma yarägän bumik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Eruk obaŋ 7 täreŋirän Jekoptä äwäŋi iwetkuk; Kadänina täretak unita webena Resel namikaŋ kuŋatkäda yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ude yäwänä Labantä äŋnak-äŋnak pähap täŋkaŋ kome mähem kuduptagän yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Äŋnak-äŋnak pähap täŋkaŋ bipani ugän Labantä äperi moki Lea uwä Jekopken tewänkaŋ bok patkumän. ");
INSERT INTO iou_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labantä piä watä webe Silpa Leata piä watä täŋ imikta imiŋkuk.) ");
INSERT INTO iou_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Eruk patkumäno yäŋeŋirän Jekoptä Lea kaŋpäŋ kikŋutkuk. Kaŋpäŋ äwäŋi Laban päŋku iwetkuk; Ai, ima kudän täŋ namitan? Näk Reselta nadäŋpäŋ piä täŋ gamiŋkut yäk. Imata ŋode täŋnäkŋatan? ");
INSERT INTO iou_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yäwänä iwetkuk; Kome ŋo nanik täŋo kädet uwä moki jop irirän wenänitä jukun äma yäpnaŋi nämo yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Unita gäk mokikät kuŋarirän yanäpi täŋo oretoret äŋnak-äŋnak kepma 7 ude täreŋirän wenäni api gamet yäk. Upäŋkaŋ webe unita gwäki uwä äneŋi obaŋ 7 ude piä kaŋ täŋ nam yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Labantä Jekop ude iwetkuko udegän täŋkuk. Leakät yanäpi täŋkumäno unitäŋo oretoret äŋnak-äŋnak täreŋirän Labantä äperi Resel webenita imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Täŋpäŋ Reselta watä epän täŋ imikta webe kubä wäpi Bilha imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Täŋkaŋ Jekop Reselkät patpäŋ unita gäripi nadäŋkuko u webeni Lea pengän yäpuko unita nadäŋkuko u irepmitkuk. Täŋpäkaŋ Jekop Labanta piä täŋ imiŋ yäpmäŋ äroŋirän obaŋ äneŋi 7 ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Täŋpäkaŋ Yawe Jekoptä Leata gäripi nämo nadäŋ imiŋirän kaŋpäŋä Lea nanak bäyakta nadäŋ imiŋirän Resel äruŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Täŋpäŋ Leatä nanak kok itpäŋ bäyaŋkuko u wäpi Ruben yäŋ iwetkuk. Ŋode nadäŋpäŋ Ruben yäŋ iwetkuk; Anututä butewakina kaŋpäŋ nadäk täŋpäŋ täŋkentäŋ namitak yäk. Nanak bäyaŋ imitat unita äpnatä gäripi bureni käwep api nadäŋ namek yäk. ");
INSERT INTO iou_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ude täŋkaŋ it yäpmäŋ äroŋpäŋ äneŋi nanak kubäkät bäyaŋkuk. Bäyaŋpäŋ yäŋkuk; Äpnatä gaŋani nadäŋ namiŋirän Anututä nadäŋ namiŋpäŋ äneŋi nanak kubä ŋo namitak yäk. Mebäri unita wäpi Simeon yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ude täŋkaŋ it yäpmäŋ äroŋpäŋä äneŋi nanak kok itpäŋ kubä bäyaŋpäŋ yäŋkuk; Eruk, näk nanak yaräkubä bäyaŋ imitat unita äpnatä näka gäripi bureni api nadäwek yäk. Mebäri unita wäpi Livai yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Täŋpäŋ äneŋi it yäpmäŋ äroŋtäŋgän nanak kok itpäŋ bäyaŋpäŋä yäŋkuk; Apiŋo Anutu iniŋ oretat yäk. Ude yäŋpäŋ wäpi Juda yäŋ iwetkuk. Täŋkaŋ äneŋi nanak kubä bäräŋeŋ nämo bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Täŋpäkaŋ Resel äruŋ itpäŋ Jekopta nanak kubä nämo bäyaŋ imiŋkuk. Iniken mebäri ude nadäŋpäŋ moki Leata nadäwäwak täŋ imiŋpäŋ Jekop ŋode iwetkuk; Näka nanak kubä kaŋ nam! Nämo namiwä api kumbet yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ude yäŋirän Jekoptä jäpi nadäŋ imiŋpäŋ iwetkuk; Anututä nadäŋ gamiŋpäŋ nanak nämo gamiŋirän näkä u irepmitpäŋ nanak täga gamet? ");
INSERT INTO iou_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ude iweränä Reseltä yäŋkuk; Ŋo watä piä webena Bilha. Ukät patpäŋ nanak bäyaŋirän näka biŋam täŋpänkaŋ nanak täŋo miŋi kaŋ ahäwa yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Reseltä ude yäŋpäŋ piä watä webe Bilha imän Jekopkät patkumän. ");
INSERT INTO iou_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Patkumäno Bilhatä nanak kok itpäŋ Jekopta nanak kubä bäyaŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Bäyaŋirän Reseltä yäŋkuk; Anututä täŋkentäŋ namikta nadäwän tägawäpäŋ manna nadäŋpäŋ nanak kubä namitak yäk. Mebäri unita wäpi Dan yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Täŋpäkaŋ Resel täŋo watä piä webe äneŋi nanak kok itpäŋ Jekopta nanak kubä bäyaŋirän yarä ude täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Täŋkaŋ Reseltä yäŋkuk; Moknakät ämiŋtäŋgän eruk irepmitat uba yäk. Ude yäŋpäŋ nanak wäpi Naptali yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Täŋpäkaŋ Leatä nanak bäyak-bäyak kadänini paotak yäŋ nadäŋpäŋä watä piä webeni Silpa Jekop webenita iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Iniŋ kirewänkaŋ Silpatä Jekopta nanak kubä bäyaŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Bäyaŋ imiŋirän Lea wisikna yäŋ nadäŋpäŋ wäpi Gat yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Eruk, it yäpmäŋ äroŋpäŋ Silpatä Jekopta äneŋi nanak kubä bäyaŋirän yarä ude täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Täŋirän Leatä ŋode yäŋkuk; Näk bumta oretat unita notnaye ätutä näka oretoret täŋpani yäŋ api näwetneŋ yäk. Ude yäŋpäŋ nanak u wäpi Ase yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Täŋpäkaŋ wit bureni däpmäk-däpmäk kadäniken Lea täŋo nanaki tuäni Rubentä piäken kuŋkaŋ päya pähäm nanak itta näŋpani u ätu yabäŋ ahäŋkuk. Yabäŋ ahäŋpäŋ yäpmäŋkaŋ miŋi Leaken yäpmäŋ kuŋkuk. Yäpmäŋ päŋku imänkaŋ Reseltä u kaŋpäŋ Lea iwetkuk; Ai, päya pähäm nanak itta näŋpani nanakatä yäpmäŋ äbuko u ätu täga namayäŋ? ");
INSERT INTO iou_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Iweränä Leatä iwetkuk; Äpna nomägatkuno unita nadäwi pidäm tawänpäŋ päya pähäm nanak itta näŋpani nanaknatä yäpmäŋ äbuko u imaka, nomägarayäŋ täyan? Yäwänä Reseltä iwetkuk; Eruk, päya pähäm yäpmäŋ gamiŋkuko u namiwä apiŋo bipani gäk äpnakät täga patdayäŋ yäk. Ude yäwänä Leatä nadäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nadäŋ imiŋpäŋä bipäda Jekop piäken naniktä äbäŋirän Leatä päŋku kädet miŋin ahäŋ imiŋpäŋ iwetkuk; Apiŋo gäk näkkät pätdayäŋ yäk. Nanakna täŋo päya pähäm nanak itta näŋpani upäŋ gäk suwatat yäk. Yäwänkaŋ bipani uken bok patkumän. ");
INSERT INTO iou_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Täŋpäkaŋ Anututä Lea nadäŋ imiŋirän nanak kok itpäŋ Jekopta nanak kubä bäyaŋ imiŋirän nanakiye 5 ude itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Bäyaŋpäŋ yäŋkuk; Näk watä piä webena äpnata imiŋkuro unita kowata Anututä nanak kubä namitak yäk. Ude yäŋpäŋ nanak u iniken man terak wäpi Isaka yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Eruk ude täŋkaŋ it yäpmäŋ äroŋirän Leatä nanak kok itpäŋ Jekopta nanak kubä bäyaŋ imiŋirän nanakiye 6 ude itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Bäyaŋpäŋ yäŋkuk; Anututä iron täga täŋ namiŋirän äpnata nanak 6 ude bäyaŋ imiŋkut yäk. Unita näk api oraŋ namek yäk. Ude yäŋpäŋ nanak u iniken man terak wäpi Sebulun yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Eruk it yäpmäŋ äroŋtäŋgän äperi kubä bäyaŋkuko u wäpi Daina yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ude ahäŋ moreŋirä Anutu Reseltä yäŋapik man yäŋkuko u nadäŋ imiŋirän äruŋ iranitä nanak kok itkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nanak kok itpäŋä nanak kubä bäyaŋpäŋ yäŋkuk; Äruŋ itpäŋ mäyäk nadäŋkuro uwä Anututä nomägatak yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Eruk, Anututä nanak äneŋi kubä kaŋ namän! yäŋ yäŋpäŋ nanak u wäpi Josep yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Reseltä Josep bäyawänkaŋ Jekoptä äwäŋi Laban iwetkuk; Komenaken kwayäŋ nadätat unita nabä kätäwi kwa yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Webenayat nanaknayeta nadäŋpäŋ watä piä täŋ gamiŋkuro unita naniŋ kirewipäŋ yämagut yäpmäŋ kwa yäk. Piä jide täŋ gamiŋkuro uwä gäkŋa nadätan yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ude iweränä äwäŋitä iwetkuk; Ude nämo. Ŋode gäwera nadäsi. Näk kären ŋode kaŋkut; Yawetä gäka yäŋpäŋ iron taŋi täŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Unita piäka täŋo gwäki ude nami yäŋ nadäŋpäŋ yäwikaŋ api gamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yäwänä Jekoptä iwetkuk; Näk piä taŋi täŋ gamiŋkuro u kaŋpäŋ nadätan? Gäkŋo bulimakau sipsip yabäŋ yäwarira jide ahäŋkuŋo u gäkŋa nadätan yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Näkä nämo äbutken ähan yarägän bumik itkuŋopäŋ apiŋowä ahäŋ bumbum täŋ gamikaŋ. Näk piä täŋ gamiŋira Yawetä gäk täŋkentäŋ gamiŋ yäpmäŋ äbätak yäk. Unita kadäni ŋoken näkŋaken äbotnayeta piä täŋ yämiŋpäŋ täŋkentäŋ yämayäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ude yäwänä äwäŋitä iwetkuk; Unita kowata jide api täŋ gamet? Ude yäwänä Jekoptä iwetkuk; Gäk imaka kubä nämo namen yäk. Näk bänepnaken man pätak u gäwera nadäŋiri täga täŋpeko uwä gäkŋo sipsip meme äneŋi watäni api iret yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Uwä ŋode; Näk apiŋo tom äbori äbori yabäŋpäŋ sipsip kudäri ba yäput-toroktorok ikek, sipsip nanaki kubiri ba meme nanaki yäput-toroktorok ikek u kudup yäpmäŋ daniŋpäŋ inigän yepmaŋpayäŋ yäk. Tom yarägän udewanita piä täŋ gamik täyat unitäŋo gwäki api yäpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ude täŋira kudän siwoŋi täyak ba siwoŋi nämo täyak yäŋ täga api kaŋpäŋ nadäwen. Gäk piä täk täyat unitäŋo gwäki siwoŋi yäpmäŋtak yäŋ kaŋpäŋ nadäwayäŋ äbäŋpäŋä meme yäput-toroktorok ikek nämo, ba sipsip nanaki kubiri nämo, näkŋo äbotken irirä yabäŋpäŋ kubota täyak yäŋ kaŋ nadäk tä yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ude yäwänä äwäŋitä yäŋkuk; Yäyan u täga. Ude kaŋ ahäwän yäk. ");
INSERT INTO iou_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ude yäŋpäŋ äwäŋi Labantä kepma ugän meme ämani jaum ba yäput-toroktorok ikek, meme webeni yäput-toroktorok ikek ba pujiŋi bämop uken paki, ba sipsip nanaki kubiri u kudup nanakiyetä watäni itneŋta yäpmäŋ daniŋpäŋ yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ude täŋpäŋ Jekop peŋpeŋ kepma yaräkubä udeta kuŋtäŋgän kome ban kubäken ahäŋkuk. Ahäŋpäŋ u irirän Jekoptä äwäŋi täŋo meme sipsip ätuta watäni itkuk. ");
INSERT INTO iou_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Eruk Jekoptä päya mebäri yaräkubä unitäŋo karäni kodaki tokätpäŋ gupi uken-uken tätuŋ äyäŋutkuk. Uken-uken tätuwänkaŋ bänepi paki kwawak ahäŋpäŋ kudän ikek täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Täŋpäŋ päya karäni tätuŋkuko u yäpmäŋpäŋ sipsip memetä u kaŋkaŋ ume kaŋ naŋput yäŋpäŋ ume näŋpaniken peŋkuk. Eruk sipsip memetä webeniye yäwatnayäŋ äbäŋpäŋä ume naŋpäŋ päya karänitä iŋamiken irirän webeni yäwaräntäk täŋkuŋ. Ude täŋpäŋ nanak bäyaŋkuŋo u päya karäni udewanigän kudän-kudän nikek ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Nanak ahäŋkuŋo u yäpmäŋ daniŋpäŋ inigän yepmaŋkuk. Yepmaŋpäŋä sipsip meme biani uwä Laban täŋo sipsip meme kudän-kudän nikek itkuŋ käda ukäda kowat yabäwän täŋput yäŋpäŋ yepmaŋpän itkuŋ. Ude täŋpäŋ sipsip meme inita yäwani yäpmäŋpäŋ inigän yepmaŋkuk. Ude täŋpäŋ yepmaŋpän Laban täŋo inigän inita yäwani inigän itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kadäni kadäni meme sipsip gupi tägatä iniken täŋirä Jekoptä päya karäni ukeŋo äneŋi yäpmäŋpäŋ ume näŋpaniken peŋkuk. Ude täŋirän meme sipsip päya karäni u kaŋkaŋ webeni yäwaräntäk täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Upäŋkaŋ meme sipsip gupi waki uwä päya karäniken nämo yepmak täŋkukonik. Ude täŋirän meme sipsip gupi waki Labantagän itkuŋ. Meme sipsip gupi tägatäga u Jekop täŋo biŋamgän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ude täŋ yäpmäŋ kuŋtäŋgän Jekoptä tuŋum äma täŋkuk. Meme sipsip bumta, piä watä webe bok äma bok ba kamel doŋki nikek itkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jekoptä kädet ude täŋ yäpmäŋ äbäŋtäyon Laban täŋo nanakiyetä kaŋpäŋ yäŋkuŋ; Jekoptä nan täŋikŋatpäŋ nan täŋo tuŋum kudup yäyomägatak. Tuŋum äma täyak uwä nan täŋo tuŋum terak täyak yäk. Man ude yäŋirä Jekoptä nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Täŋpäŋ ŋode imaka kaŋpäŋ nadäŋkuk; Äwo apiŋo not säkgämän nämo täŋ namik täyak uwä bian nämo täŋ namik täŋkukopäŋ udewä täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ude nadäŋirän Yawetä Jekop iwetkuk; Gäk äneŋi äyäŋutpeŋ nankaye nägät moräkkayetä kome kujatken kaŋ ku! Kuŋiri watä api it gamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Anututä ude iwetkuko unita Jekoptä webeniyat Resel kenta Lea ŋode yäwetkuk; Näk tom epänaken kuŋira ek ätu itkaŋ kaŋ äbun yäk. Eruk man ude yäwetpäŋ kuŋirän ätu itkaŋä yarä uwä päŋku ahäŋ imiŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ahäŋ imänä yäwetkuk; Näk ŋode käyat yäk. Nanjek u bian not täŋ namiŋpäŋ kuŋatkuko udegän apiŋo nämo täŋ namitak. Upäŋkaŋ nana täŋo Anututä näk täŋkentäŋ namik täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Näk nanjekta watä piä kehäromi täkinik täŋ yäpmäŋ äbäk täyat u nadäkamän, ei yäŋ? ");
INSERT INTO iou_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ude täk täyat upäŋkaŋ nanjektä piä täŋ imik täyat unitäŋo gwäki namikta yäŋnäkŋat yäpmäŋ äbäŋirän kadäni 10 täreŋkuk. Upäŋkaŋ nanjektä waki ude täŋ namayäŋ täŋirän Anututä ukätpipik ŋode täŋ imik täŋkukonik; ");
INSERT INTO iou_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nanjektä tom yäput-toroktorok ikek piä gwäkita kaŋ yäpmäŋ yäŋ näwerirän eruk Anututä nadäŋirän tom miŋitä nanaki yäput-toroktorok ikekgän bäyaŋkuŋ. Täŋ tom gwärärek kudän ikek gäkŋata yäpmäŋ yäŋ näwerirän eruk Anututä nadäŋirän tom miŋitä nanaki gwärärek kudän nikekgän bäyaŋkuŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ude täŋ yäpmäŋ äbätäŋgän Anututä nanjek täŋo tom kudup yomägatpäŋ näkŋata biŋam naniŋ kireŋkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ude yäŋpäŋ ŋode yäwetkuk; Kadäni kubä yawaktä iniken täŋirä däpmonken ŋode täŋkut; Kadäni uken meme ämanitä webeni yäwatkuŋo uwä yäput-toroktorok, gwärärek kudän ikek yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Täŋpäŋ Anutu täŋo aŋerotä däpmonken ŋode näwetkuk; Jekop! yäk. Jekop yäŋ yäwänä Itat ŋo yäŋ iniŋ yäŋkut. ");
INSERT INTO iou_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Yäwawä näwetkuk; U yabä! yäk. Meme ämanitä webeni yäwatkaŋ u yäput-toroktorok, gwärärek kudän ikekgän yäk. Äwäŋka Labantä yäŋgäkŋat yäpmäŋ äbuko u kak täyat unita nadäŋira udewä ahäkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Täŋpäŋ nadätan? Gäk Betel komeken näka yäŋpäŋ mobä änok kubä buŋätkaŋ olip gakŋi uterak piŋ ibatpäŋ yäŋkehäromtak man yäŋkun. Eruk, kome uken iriri ahäŋ gamiŋkuro uwä Anutu näk ŋo yäk. Unita akuŋkaŋ äyäŋutpeŋ kome kujatkaken kaŋ ku yäk. Man ude näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Eruk, ude yäweränä webeniyattä iwetkumän; Nanta butewaki nämo nadäkamäk yäk. Nekta biŋam tuŋum kubä nämo iwoyäŋ nimiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nan uwä äbani bumik nibäk täyak yäk. Gäkken moneŋ yäpmäkta niniŋ kireŋkuk. Upäŋkaŋ moneŋ yäpuko uwä kudup naŋkuko unita imata ŋo itde? ");
INSERT INTO iou_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ude yäŋpäŋ yäŋkumän; Anututä nannek täŋo tuŋum kuduptagän yomägarirän nin ba nanakniye ninta biŋam täyak yäk. Unita Anututä gäwetak ude kaŋ tä yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ude yäwänä Jekop komeniken äneŋi kukta tuŋum täŋpäŋ webeniye nanakiye kamel terak yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ude täŋpäŋ sipsip, bulimakau, tuŋum ba imaka kudup Mesopotemia komeken irirän ahäŋ imiŋkuŋo u yäpmäŋpäŋ Kenan komeken nani Aisaktä itkukken kwa yäŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Akumaŋ kunayäŋ täŋkuŋo kadäni uken tuŋum ŋode täŋkuŋ; Labantä sipsip pujiŋi madäwa yäŋkaŋ kuŋirän Resel nanitä yotken äroŋpäŋ nani täŋo äboriyeta watä irani yäwik kubo täŋpäŋ yäpmäŋ äpämaŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Täŋ Jekoptäwä äwäŋi Laban, Aramtä äbotken nanik u täŋikŋatpeŋ nämo iwerän nadäŋirän kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Eruk tuŋum ude täŋ paotpäŋä tuŋumi kuduptagän kobet täŋ yäpmäŋ Yufretis ume weŋpeŋ Gileat pom käda kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jekop kuŋirän kepma yaräkubä tärewänkaŋ Jekoptä metäŋpeŋ kuŋkuko unita manbiŋam Laban iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","25","Eruk manbiŋam u nadäŋpäŋä ämaniye yämaguränkaŋ Jekop iwat yäpmäŋ kuŋtäyon kepma 7 tärewänkaŋ Gireat pom Jekoptä ahäŋpäŋ yottaba täŋpäŋ itkuko u ahäkta keräp taŋkuŋ. Uken ahäŋpäŋ Laban ba ämaniye yottaba täŋpäŋ patkuŋ. Parirä Anututä Laban däpmonken ŋode iwetkuk; Laban! Gäk Jekop man kädäp ikek kubä iwerentawä! yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Patkuŋo yäŋewänkaŋ Labantä Jekop ahäŋ imiŋpäŋä iwetkuk; Ima kudän täŋ namitan? Imata jop täŋnäkŋatpäŋ iwan täŋ gamapäŋ bumik äpetnayat nomägatpäŋ yäpmäŋ äbätan? ");
INSERT INTO iou_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Yäŋahäŋpäŋ näwetkuno uyaku kap teŋpäŋ gepmana yäpmäŋ äbim yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Näk äpetnayat oranaye nämo yäniŋ orerira yämagut yäpmäŋ äbän. Gäk guŋ kudän tän yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Näk gäk gutnaŋipäŋ nanka täŋo Anututä bipani däpmonken ŋode näwetpäŋ naniŋ bitnäk; Gäk Jekop man kädäp ikek kubä iwerentawä yäŋ näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Gäk komekata nadäwätäk täŋpäŋ ämetpeŋ äbäno uwä täga upäŋkaŋ näkŋo äbotnayeta watä irani yäwik imata kubo täŋpäŋ yäpmäŋ äbän? ");
INSERT INTO iou_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ude yäŋirän Jekoptä Laban man kowata ŋode iwetkuk; Gäka umuntaŋkuro uwä ŋodeta; Gäkä äpetkayat nomägaren yäŋ yäŋpäŋ unita nämo gäwetkaŋ äbämäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Upäŋkaŋ itkamäŋ ŋo kubätä yäkken yäwikka u kaŋ-ahäwayäŋ täno uwä äma ba webe u kumäkta biŋam täŋpän. Ämaniye iŋamiken tuŋum päke yäpmäŋ kuŋatat ŋo gäkŋata biŋam kubä kaŋpäŋä kaŋ yäpmäŋ yäk. Jekop uwä webeni Reseltä yäwik kubo täŋkuko u nämo nadäŋkaŋ man kehäromi u yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Eruk, Laban Jekoptä yottaba gänaŋ äroŋpäŋ yäwik ukeŋonita kawän wawäpäŋ, Leatä yottaba gänaŋ äroŋpäŋ udegän kawän waŋkuŋ. Täŋpäŋ piä watä webe yarä unitä yottaba gänaŋ udegän kawän waŋkuŋ. Ude täŋkaŋ kumaŋ Reseltä yottaba gänaŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reseltä yäwik kubo täŋkuko ukeŋo kamel täŋo yäk tuŋum pewani u gänaŋ käbop daiŋkukopäŋ uterak maŋirirän Labantä yottaba u gänaŋ wäyäkŋewän waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ude täŋkaŋ Reseltä nani iwetkuk; Nana, gäk näka kokwawak nadäweno. Näk täga nämo akwayäŋ. Webetä nininken käyäm ahäŋ namitak unita täga nämo akwayäŋ yäk. Iweränkaŋ nanitä päŋku yot kudup gänaŋ yäwikta wäyäkŋewän waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ude täŋirän Jekoptä koki wawäpäŋ Laban ŋode kaŋ yäŋkuk; Oi! Näk waki jide täŋ gamiŋkuro unita tom bumik nurayäŋ näwarän täyan? ");
INSERT INTO iou_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Gäkä näkŋo tuŋum päke ŋo yabäwi tärekaŋ. Unita gäkä imaka kubä gäkŋopäŋ näk ba äbotnaye ŋo bämopninken käyan u täŋpäwä notniye täŋo iŋamiken kwawak pewipäŋ kaŋkaŋ nek täŋo mebäri kaŋ yäpmäŋ daniwut! ");
INSERT INTO iou_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Näk gäka watä piä täŋ gamiŋira obaŋ 20 ude täreŋkuk. Kadäni u bämopiken gäkŋo yäwakaye watäni ket irira sipsip ba meme nanaki kubä nämo dätdät maŋkuŋ. Ba gäkŋo sipsip äbotken nanik sipsip ämani kubä nämo utpäŋ naŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ba tom ägwäritä gäkŋo sipsip yewa gänaŋ äroŋpäŋ sipsip kubä utpäŋ naŋpänä näkŋakenpäŋ komenita peŋ gamiŋkut. Täŋkaŋ kepma ba bipani kubäta gäkŋo sipsip kubä kubo täŋkuŋo unita komenita näkŋakenpäŋ gamikta näwet täŋkunonik. ");
INSERT INTO iou_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Näk gäkŋo sipsipta watä irira edaptä bumta nek täŋkukonik. Bipaniwä mänit nadäŋpäŋ däpmon säkgämän nämo pat täŋkuronik yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Näk komi piä ude gäka obaŋ 20 täŋkut. Obaŋ 14 äpetkayatta nadäŋpäŋ watä piä täŋ gamiŋkut. Ba obaŋ 6 äneŋi tom ätu näka biŋam täneŋta watäni it gamiŋkut. Täŋpäŋ kadäni u bämopiken piä täŋ gamiŋkuro unitäŋo gwäki namikta täŋnäkŋariri kadäni 10 ude täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gäk ude täŋ namiŋkuno upäŋkaŋ nana täŋo Anututä näka watä it namiŋkuk. Anutu uwä orana Abraham ba nana Aisak unitäŋo Anutu pähap. Anututä näka watä nämo itkuk yäwänä jopinik nepmaŋpi äbätet. Upäŋkaŋ Anututä butewaki terak komi piä täŋ yäpmäŋ äburo u kaŋpäŋ imaka kubä näka nämo täŋ namenta däpmonken man kehäromi gäwetkuko u yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jekoptä man ude yäwänä Labantä iwetkuk; Webekayat ŋowä äpetnayat, ba nanakaye ŋowä näkŋaken äbeknaye oranaye. Ba tom kuduptagän päke ŋo u imaka, näkŋakengän. Imaka kuduptagän iŋamnaken itkaŋ ŋowä näkŋakengän. Upäŋkaŋ apiŋowä jide täŋpäŋ äpetnayat ba äbeknaye oranaye äneŋi yäpet? U täga nämo. ");
INSERT INTO iou_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Unita nek bänep kubägän täda yäk. Täŋpäŋ bänep kubägän täkamäk ŋonita nämo guŋ tädeŋta mobä änok kubä ŋo peda yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Man ude yäwänkaŋ Jekoptä mobä käroŋi kubä yäpmäŋpäŋ siwoŋ yäputkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Täŋpäŋä noriye yäwet-pewän mobä u dubiniken mobä ätukät buŋätkuŋ. Ude täŋpäŋä mobä änok u dubiniken ketem naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Täŋpäkaŋ Labantä mobä änok peŋkumäno iniken Mesopotemia man terak wäpi Jega-Sahaduta yäŋ iwetkuk. Täŋpäŋ Jekop uwä iniken Hibru man terak wäpi Galet yäŋ iwetkuk. (Ninin man terak ‘nämo guŋtakta’). ");
INSERT INTO iou_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Täŋpäŋ Labantä Mobä änok pekamäk ŋo kaŋpäŋ bänep kubägän täkamäk unita nämo api guŋ täde yäŋ Jekop iwetkuko mebäri unita mobä änok unitäŋo wäpi Galet yäŋ iwetkumän. ");
INSERT INTO iou_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Täŋä Labantä kome u wäpi kubä Mispa iwetkuko uwä man ŋode yäŋkuko unita; Yawetä gäk gäkŋagän, näk näkŋagän kuŋaritda nek nibäŋpäŋ nadäwän. ");
INSERT INTO iou_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Täŋpäkaŋ Labantä Jekop äneŋi kubä ŋode iwetkuk; Gäk äpetnayatta gaŋani nadäŋpäŋ komi yämeno, ba näkä nämo nadäŋira webe kodaki ätu yäpeno uwä ŋodeta ket nadäwen; Anutu nibätak yäŋ nadäwen yäk. ");
INSERT INTO iou_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Mobä käroŋi yäputat ŋo ba mobä änok bämopnekken peyat ŋo ka! Ŋowä kaŋpeŋ kuŋatpäŋä bänep kubägän täkamäk ŋonita nämo api guŋ täde yäk. Näk ŋo irepmitpäŋ nämo guret. Gäk udegän, ŋo irepmitpäŋ nämo nuren. ");
INSERT INTO iou_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Täŋpäŋ gäk ba näk bänep kubägän täkamäk ŋopäŋ irepmitdawä Anutu, Abraham kenta Naho täŋo Anutu unitä kowata kaŋ nimän yäk. Ude yäwänkaŋ Jekoptä Anutu, nani Aisaktä gämoriken kuŋarani unitäŋo wäpi terak yäŋkehärom taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Täŋpäŋ Anutu iniŋ oretta pom terak äroŋpäŋ gupe ijiŋ ima yäŋpäŋ tom kubä utpäŋ ijiŋ imiŋkuk. Ude täŋpäŋ äboriyekät ketem bok näna yäŋkaŋ yämagutkuk. Yämaguränpäŋ ketem naŋkaŋ pom terak ini ugän patkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Patkuŋo yäŋewänä Laban akuŋpäŋ äperiyat, oraniye äbekiye yeŋpäŋ yäniŋ oretpäŋ kon man yäwetkaŋ komeniken äyäŋutpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Eruk Jekop kome u peŋpeŋ kuŋirän Anutu täŋo aŋero ätutä kädet miŋin ahäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ahäŋ imiŋirä yabäŋpäŋä nadäŋkuk; Wa! Ŋowä Anutu täŋo äbot yäk. Ude yäŋpäŋ unita kome u wäpi Mahanaim yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Kadäni uken Jekop täŋo tuäni Iso Sei kome, wäpi kubä Idom uken itkuk. Irirän Jekoptä tuäna uken itak yäŋ nadäŋpäŋ watä äma yäwet-pewän intäjukun kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kunayäŋ täŋirä yäwetkuk; In ekänina Iso ŋode iwerut yäk. Watä piä ämaka Jekoptä ŋode yäyak; Näk kome ban päŋku äwäŋnek Labankät kadäni käroŋi it yäpmäŋ äbut. ");
INSERT INTO iou_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","It yäpmäŋ äbäŋkä sipsip, bulimakau, doŋki, watä ämawebe it namikaŋ. Unita ekänina, gäk not täŋ nam yäŋ nadäŋpäŋ manbiŋam ŋo gäka pewa ärekaŋ yäk. Jekoptä manbiŋam ude pewän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Watä piä ämaniyetä manbiŋam ude yäpmäŋ kuŋkuŋotä äneŋi äyäŋutpeŋ äbäŋpäŋ Jekop ŋode iwetkuŋ; Nin tuäka Iso kaŋ-ahäŋkumäŋ yäk. Unitä gäk gabäŋ ahäwayäŋ nadäŋpäŋ ämaniye 400 yämagurän äbäŋ itkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ude iweräkaŋ Jekop umun pähap nadäŋpäŋ-nadäwätäk täŋkuko unita ämaniye, sipsip, bulimakau, kamel kudup yäpmäŋ daniŋpewän äbot yarä täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","U ŋode nadäŋpäŋ yäpmäŋ daniŋkuk; Isotä äbäŋpäŋ änok kubä nidäpänä änok kubätä api ämetpeŋ kuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ude nadäŋpäŋ Jekoptä Anutu yäŋapik man terak ŋode iwetkuk; O Anutu, orana Abrahamkät nana Aisak täŋo Anutu! Gäk ŋode näwetkun; Gäk komekaken ba notkaye itkaŋken äyäŋutpeŋ kuŋiri api täŋkentäŋ gamet. Man ude näwetkun. ");
INSERT INTO iou_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Näk piä ämaka täga nämo upäŋkaŋ nadäŋ namikinik täŋpäŋ bänep iron täŋ namiŋ yäpmäŋ äbäk täyan. Bianä ähottaba-gänpäŋ yäpmäŋkaŋ Jodan ume weŋpeŋ kuŋkut. Apiŋowä näk äbot taŋi yarä ŋo nikek äbätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Unita gäk täŋkentäŋ namiŋiri tuäna Isotä nurektawä. Tuänatä äbäŋpäŋ näkŋa ba nanak nädamiŋi nidäpek yäŋpäŋ umuntäyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Gäk bian ŋode näwetkuno äneŋi nadäsi; Näk bänep täga nadäŋ gamiŋpäŋ nanakaye pewa gwägu pomiken mobä jiraŋ mäyap, daninaŋi nämo itkaŋ ude api ahäneŋ. Ude näwetkun yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Eruk, patkuko yäŋewänä Jekoptä akuŋpäŋ tuäni Iso iron imikta tuŋumi päke uken nanik ätu iwoyäŋ imiŋkuk. Tuŋum ironta iwoyäŋ imiŋkuko uwä ŋode; ");
INSERT INTO iou_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","Meme webeni 200, ämani 20, sipsip webeni 200, ämani 20, kamel webeni nanakiye nikek 30, bulimakau webeni 40, ämani 10, doŋki webeni 20, ämani 10 ude iwoyäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Iwoyäŋ imiŋpäŋä memeta watä äma kubä peŋkuk, sipsipta kubä, kamelta kubä, bulimakauta kubä, doŋkita kubä. Ude yepmaŋpäŋ watä äma u ŋode yäwetkuk; Intäjukun kut yäk. Näk mäden täwarayäŋ. Upäŋkaŋ änok kubägän kuneŋo. Banban kut yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","18","Eruk kunayäŋ täŋirä Jekoptä watä äma intäjukun kwayäŋ täŋkuko u iwetkuk; Gäk kuŋiri tuäna Isotä gabäŋ ahäŋpäŋ gäwet yabäk ŋode api täŋpek; In netä täŋo watä äma? De kukaŋ? Tom äbot ŋo mähemi netä? yäŋ gäwerirän ŋode kaŋ iwet; Ŋowä watä ämaka Jekop, unitäŋo yäk. Tom äbot ŋo ekänini gäka iron täkta pewän äbäkaŋ. Täŋkaŋ monäka mäden näwatak yäŋ kaŋ iwet. ");
INSERT INTO iou_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Ude iwetkaŋä piä watä äma mäden kunayäŋ täŋkuŋo u man piä watä äma intäjukun iwetkuko udegän ŋode yäwetkuk; In Iso kaŋ-ahäŋpäŋä äma intäjukun kuyak u iweraro udegän kaŋ iwerut yäk. Watä ämaka niwatak yäŋ ude iwetneŋ yäk. Täŋpäkaŋ Jekoptä ŋode nadäŋkuk; Näk tom äbot ŋo ironta intäjukun pewa kuŋirä tuäna Iso näka bänep waki nadätak u peŋpäŋ kowat kawän täŋpäŋä not käwep täŋ namek yäk. ");
INSERT INTO iou_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ude nadäŋpäŋ tom äbot ukeŋo intäjukun pewän kuŋirä bipani ini ugän patkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Eruk bipani bämopiken Jekoptä akuŋpäŋ webeniyatkät watä webeni yarä ukät nanakiye 11 ude yämagut yäpmäŋ päŋku Jabok ume pipiyäwaniken weŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Weŋpeŋ kuŋ moreŋirä Jekoptä tuŋumi päke u kudup ume ani kukŋi udude pewän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Pewän kuŋ moreŋirä ume ani kukŋi ŋo käda inigän itkuk. U irirän äma kubätä ahäŋ imänkaŋ ämiŋtäkon kome yäŋeŋburu-buru täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ämiŋtäŋgän äma Jekop ahäŋ imiŋkuko u Jekop täŋo kehäromini täga nämo yäpmäŋ äpayäŋ yäŋ nadäŋpäŋ keritä Jekop jopänikengän iŋirirän jopäni jok tädotkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tädorirän äma unitä Jekop iwetkuk; Kome yäŋewayäŋ täyak unita nabä kätäwi kwa! yäk. Yäwänä Jekoptä kowata ŋode iwetkuk; Ude nämo! Gäk kon man kubä näwerikaŋ uyaku gabä kätäwayäŋ yäk ");
INSERT INTO iou_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yäwänä iwetkuk; Wäpka netä? Yäwänä Näk wäpna Jekop yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Jekop yäŋ iweränä äma unitä yäŋkuk; Gäk Anutukät ba äma ätukät ämiŋpäŋ gäkägän yärepmitan unita gäk wäpka Jekop peŋpäŋ wäpka kodaki Isrel yäŋ gäwetat. (Ninin man terak Isrel uwä Anutukät ämiŋkumän) ");
INSERT INTO iou_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Wäpi kodaki Isrel yäŋ iweränä Jekoptä yäŋkuk; Eruk, gäkŋo wäpka täga näwerayäŋ? Yäwänä iwetkuk; Imata wäpna nadäwayäŋ yäyan? Ude yäŋpäŋ kon man kubä iwetpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kuŋirän Jekoptä nadäŋkuk; Wära! Näk Anutu iŋami dapun karo unita nutnaŋipäŋ nabäŋ orerak yäk. Näk Anutu iŋami dapun kat yäŋ nadäŋkuko unita kome u iniken man terak wäpi Peniel yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Täŋpäŋ tamimaŋ edap dapuri abäŋirän Jekop Peniel kome u peŋpeŋ kuŋkuk. Peŋpeŋ kuŋkukopäŋkaŋ kuroŋ säkgämän nämo yeŋtäŋ kuŋkuk. Jopäni jok tädotkuko unita täŋäro päreŋtäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Täŋpäkaŋ mebäri unita kadäni ukentä päbä apiŋo Juda ämawebetä tom tohari jopäni jokken nanik nämo nak täkaŋ, Jekop jopänikengän iŋirirän jopäni jok tädotkuko unita. ");
INSERT INTO iou_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Eruk Jekop täŋäro päreŋtäŋ kuŋtäŋgän Iso, ämaniye 400 udekät äbäŋirä yabäŋkuk. Eruk yabäŋpäŋ Jekoptä nanakiye yäpmäŋ daniŋpäŋ webeni Resel kenta Leata, ba watä webeni yarä unita yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ude täŋpäŋ watä webe yarä ukät nanakiye intäjukun yepmaŋpän kwäwä nanaki ätukät Leakät u mädeniken yepmaŋpän kuŋkuŋ. Yepmaŋpän kuŋirä nanaki Josepkät Resel mädeninik yepmaŋpän kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tuŋum ude täŋpäŋ ini intäjukuninik kuŋirän iwatkuŋ. Intäjukuninik päŋku tuäni kaŋkaŋ oraŋ imikta kadäni 7 ude iŋami yäpän äpmoŋpäpäŋ patkaŋ akuk täŋtäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Täŋtäŋ kuŋirän tuäni Isotä kaŋpäŋä bäräŋeŋ äbä bäyaŋ imiŋpäŋ iŋpäŋ iniŋ oretkuk. Ude täŋpänkaŋ konäm kotkumän. ");
INSERT INTO iou_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Täŋpäŋ Isotä Jekop webeniyekät nanakiye yabäŋpäŋ Jekop iwetkuk; Ai! Webe nanak päke ŋo netäŋo? Yäwänä Jekoptä iwetkuk; Anututä watä ämaka näka iron täŋ namiŋirän imaka päke yabätan ŋo ahäŋ namiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ude yäwänkaŋ watä webe yarä u nanakiye yäŋ-yäkŋat yäpmäŋ Iso dubiniken kuŋpäŋ gukut imäpmok täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Täŋirä Lea nanakiyekät äbäŋpäŋ udegän täŋkuŋ. Mädeninik Resel nanaki Josepkät äbäŋpäŋ udegän gukut imäpmok täŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Täŋirä Isotä iwetkuk, Ai, tom äbot intäjukun yäpmäŋ äbäŋirä yabäro u imata? Yäŋirän Jekoptä iwetkuk; Ekänina, gäk bänep täga nadäŋ nami yäŋpäŋ pewa äbäŋo u! yäk. ");
INSERT INTO iou_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ude iweränä Isotä yäŋkuk; Monäna waki! Näkŋo tuŋum mäyapinik it namikaŋ unita tuŋum u gäkŋata yäpmäŋsi! ");
INSERT INTO iou_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yäwänä Jekoptä yäŋkuk; Ude nämo! Gäk bänep paki nadäŋ namiŋpäŋä tuŋum gamitat u gäkŋata biŋam yäpmäŋ yäk. Gäk gabäŋpäŋ tägagämän nadätat. Gäk not täŋ namitan unita iŋamka gabäŋira Anutu iŋami bumik täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ude yäŋpäŋ äneŋi gwäk pimiŋpäŋ iwetgän täŋkuk; Tuŋum gamiro u gäkŋata yäpmäŋ yäk. Anututä täŋkentäŋ namiŋirän imaka täpuri kubäta nämo wäyäkŋek täyat. Ude peŋ iwettäyon Isotä tuŋum u yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Yäpmäŋpäŋ Isotä yäŋkuk; Eruk kuna! Näkä jukun kuŋira näwarut yäk. ");
INSERT INTO iou_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yäwänä Jekoptä iwetkuk; Ekänina, gäk nadätan? Nanaknaye bäräŋeŋ kukta kehäromini nämo. Ba sipsip bulimakau nanakiye nikek unita imaka, nadäwätäk täyat. Bäräŋeŋ jide täŋpäŋ kuneŋ? Bäräŋeŋ kuŋpäŋä nanakiye kuduptagän kumneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Unita gäkä jukun Idom kome päŋku ninta itsämäŋiri näk mäden tomkät nanaknaye-kät nin kwikinik äreŋpäŋ api gabäŋ ahäne. ");
INSERT INTO iou_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ude yäwänä Isotä iwetkuk; Eruk, täŋkentäŋ tamikta ämanaye ätu gäkken yepmaŋpakaŋ tämagut yäpmäŋ kunayäŋ yäk. Yäwänä Jekoptä iwetkuk; Iron taŋi täyan upäŋkaŋ man yäyan ude nämo. Jop waki, näka bänep täga nadäŋpeŋ kweno uwä täga yäk. ");
INSERT INTO iou_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eruk man yäwän tärewänpäŋ Iso uwä iniken kome wäpi Idom kepma ugän äneŋi kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Idom kome kuŋkukopäŋ Jekop uwä Sukot komeken päŋku itkuk. Kome uken inita yottaba kubä täŋit, tomta yottaba ätu täŋit täŋkuk. Päŋku yottaba täŋpäŋ itkuko unita iniken man terak kome u wäpi Sukot yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Eruk, Mesopotemia kome peŋpeŋ äbuko, Sukot kome uken ätu it yäpmäŋ kuŋtäŋgän eruk akumaŋ päŋku Kenan kome Sekem täŋo yotpärare wäpi Salem uken ahäŋpäŋ u dubiniken kome yäpmäŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Kome yäpmäŋpäŋ itkuko unitäŋo mähemitä kome gwäkita siliwa moneŋta iwetkuk. Iwerä udegän yämiŋkuk. Kome mähemi uwä Hamo täŋo nanakiye. Hamo uwä Sekem täŋo nani. ");
INSERT INTO iou_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Täŋpäkaŋ Jekop kome uken mobä bukä kubä täŋpäŋ Anutu iniŋ oretta tom uterak däpmäŋpäŋ ijik täŋkukonik. Ude täŋkaŋ wäpi ‘Anutu, Isrel täŋo Anutu’ yäŋ iwetkuk. Iniken man terak wäpi ‘El, Elohe Isrel’ yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Eruk, kepma kubäta Jekop kenta Lea äperi wäpi Daina uwä webe kome uken nanik ätukät itpäŋ-nadäk täŋpayäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kuŋirän äma kubä wäpi Sekem unitä Daina u kaŋgärip täŋpäŋ iwarän täŋpäŋ iŋitpäŋ waki täŋ imiŋkuk. Sekem nani wäpi Hamo uwä Hivitä äbotken nanik, kome unitäŋo intäjukun äma itkuk. ");
INSERT INTO iou_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Täŋpäkaŋ Sekemtä Daina waki täŋ imiŋpäŋä eruk webe unita gäripi nadäŋpäŋ näkŋata kaŋ yäpa yäŋkaŋ man gäripi nikek ätu iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ude täŋpäŋ päŋku nani Hamo ŋode iwetkuk; Nan! Webe gubaŋ ŋo näka biŋam yäpmäŋ nam yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Täŋpäkaŋ Sekemtä Daina waki täŋ imiŋkuko manbiŋam u Jekoptä nadäŋkaŋ itkukonik. Nanakiye tomta watä itta kuŋ moreŋkuŋo unita ini äbäkaŋ manbiŋam u yäwera yäŋpäŋ itsämbuk. ");
INSERT INTO iou_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Nanakiyeta itsämäŋ irirän Sekem nani Hamo uwä äbuko Jekopkät man yäŋpäŋ-nadäk täŋ itkumän. ");
INSERT INTO iou_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Man nämo yäŋtäreŋirän Daina wanoriye tom piäken naniktä yoriken äbäŋpäŋ biŋam u nadäŋkuŋ. Sekemtä Daina waki täŋ imiŋkuk yäŋ nadäŋpäŋ Isrel ämawebe ninta mäyäk pähap täŋ nimitak yäŋ nadäŋkuŋ. Imaka tänaŋi nämopäŋ täŋkuko unita bänepi utpäŋ kokwawak taŋi pähap nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","9","Kokwawak nadäŋ irirä Hamotä Jekopkät nanakiye ŋode yäwetkuk; Nanakna Sekem uwä äpetka yäpmäkta gäripiinik nadätak yäk. Iniken gärip u iwatpäŋ gäwet yabätat yäk. Jide nadätan? Täga api yäpek ba nämo? Eruk, bänep kubägän pedayäŋ tämäko uyaku kämiwä nanakniye äpetniye kowat wapiwän täga api täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kowat wapiwän täŋpäŋ in nintä komeken ŋo penta kaŋ itna yäk. Ude täŋpäŋ itkaŋ intä ninken tuŋum suwaŋ namiŋ gamiŋ täga api täne yäk. Ba nintäŋo kome ätu imaka, injinta täga api yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem nanitä ude yäwänä Sekem ini uwä Daina nani wanoriye ŋode yäwetkuk; Intä ei yäŋ yäwäwä imaka kubä injin gäripi nadänayäŋ täŋo ugänpäŋ api tamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ba moneŋ udepäŋ nimi yäŋ näweräwä täga api tamet yäk. Upäŋkaŋ webe ŋo iwoyäŋ namiŋirä näka biŋam ude täŋpän yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sekemtä ude yäwänä Jekop nanakiyetä Wanotninta imaka mäyäk ikek täŋ imiŋkuko unita jop yäŋ-yäkŋatna yäŋpäŋ Sekemkät nani ŋode yäwetkuŋ; ");
INSERT INTO iou_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ude nämo yäk. Nin wanotnin uwä äma gupi moräk nämo madäwaniken täga nämo tena kwek yäk. Ude täkta mäyäk ikek yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Upäŋkaŋ in äma kuduptagän gupjin moräk madäŋpäŋ nin bumik äworeneŋo uyaku täga api nadäŋ tamine yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nintä kädet pekamäŋ u bureni iwaräwä eruk inkät bänep kubägän täŋpäŋ äbot kubägän ude itkaŋ kowat wapiwän täga api täŋ yäpmäŋ kune. ");
INSERT INTO iou_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Täŋ gupjin moräk madäkta täwetkamäŋ u nämo täŋpäwä nin kome ŋo peŋpäŋ wanotnin u yäŋikŋat yäpmäŋ api kune yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ude yäŋirä Hamokät nanaki Sekemtä nadäwän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Nadäwän tägawäpäŋ Sekem Jekop äperi yäpmäkta gäripiinik nadäŋkuko unita man Jekop nanakiyetä yäwetkuŋo u bäräŋeŋ buramiŋkuk. (Sekemtawä iniken äboriyetä nadäwä ärowani täk täŋkuŋ.) ");
INSERT INTO iou_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Eruk, Sekemkät nani Hamotä yotpärare u täŋo käbeyä komeken päŋku äma uken nanikkät käbeyä täŋpäŋ man ŋode yäwetkumän; ");
INSERT INTO iou_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Nadäkaŋ? Jekopkät äboriye uwä ämawebe täga. Ba komenin imaka, taŋi unita nadäŋ yämiŋitna kome ŋo yäpmäŋpäŋ itkaŋ suwaŋ namiŋ gamiŋ täŋit kowat wapiwän täŋpäŋ api täk täne yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Upäŋkaŋ nintä täkinik täŋput yäŋ nadäkaŋ uwä ämani nin kuduptagän gupnin moräk madänero uyaku penta ŋogän itta täga api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Täŋkaŋ äbot kubägän itpäŋ sipsip, bulimakau ba tuŋumi päke u ninta biŋam api täneŋo unita penta kaŋ itna yäŋ nadäŋ yämina! ");
INSERT INTO iou_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ude yäweränä yotpärare u nanik ämawebe kuduptagäntä Sekem yanani täŋo man unita nadäwä tägaŋkuŋ. Nadäwä tägawäpäŋ ämani kuduptagän gupi moräk madäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Eruk, gupi moräk madäŋkuŋo kepma yaräkubä ude täreŋirän unitäŋo komi nämo paorirä Daina wanoriyat, Simeon kenta Livai, yarä unitä ämik täkta päip yäpmäŋpäŋ käbop peŋkaŋ äma täga dapun jop täŋyäkŋatkaŋ yotpärare u kuŋatkumäno u naniktä yabäŋpäŋ-nadäk nämo täŋkuŋ. Yabäŋpäŋ-nadäk nämo täŋirä Simeon kenta Livai ämik pewän ahäŋkuŋ. Ämik täŋpäŋ Sekem yanani ba ämaniye kudup kumäŋ-kumäŋ däpumän. Däpmäŋpäŋ Daina Sekemtä yäpukopäŋ imagut yäpmäŋ kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ude täŋpeŋ kuŋirän noriye ätu mäden yäwatkuŋo unitäwä wanori waki täŋ imiŋkuko unita kowata däpmäŋ tärekta yotpärare u kuŋpäŋ äma däpumäno u yapmittäŋ kuŋpäŋ tuŋum tägatäga inita koreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","29","Uwä sipsip, bulimakau, doŋki ba webeniye nanakiye ba imaka tägatäga yori gänaŋ ba piäniken itkuŋo u kuduptagän poriŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ude täŋirän nani Jekoptä biŋam nadäŋpäŋ kikŋutpäŋ Simeon kenta Livai yäwetkuk; Wa! Ek ämawebe ŋo nanik iŋamiken näk wäpna täŋpän wakaŋ yäk. Ektä ude täŋirän Kenantä äbotken nanik ba Perestä äbotken nanik ba äbot kuduptagän näka gaŋani pähap api nadäŋ namineŋ. Näkä äbotken äma mäyap nämo ŋo unita äma äbori äbori unitä yäŋ-akuŋpäŋä nin nädamiŋi-nani kumän api nidäpneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nanitä ude yäwerirän nanakiyat unitä Jekop kowata man ŋode iwetkumän; Umun man täga niwetan upäŋkaŋ wanotnin kubokäret webe bumik waki täŋ imiŋkuko u täga nadätan ba? ");
INSERT INTO iou_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kome uken ittäŋgän Anututä Jekop ŋode iwetkuk; Gäk Betel komeken kuŋpäŋ kome kaŋ yäpmäŋpäŋ it yäk. Kome uken Anutu näk naniŋ oretta mobä bukä kubä kaŋ tä. Nähä Anutu gäk tuäka Isota umuntaŋ päŋku pariri ahäŋ gamiŋkuro u yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Anututä ude iweränä Jekoptä webeniyat äperiye nanakkät piä ämawebeniye kudup yäŋpäbä yepmaŋpäŋ ŋode yäwetkuk; Bämopjinken yäwikta anutunin yäŋ nadäk täkaŋ u ureŋ täŋpä kwäpäŋ bänepjin ket utpäŋ tekjin imaka, ärutpak täwanipäŋ wädäwä ärokot yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nadäkaŋ, nin Betel komeken api kune yäk. Näk butewaki nadäwätäk terak kuŋarira Anutu kädet miŋin ahäŋ namiŋkuko u iniŋ oretta mobä bukä kubä uken api täŋpet yäk. Anutu unitä uken-uken kuŋatkutken u täŋkentäŋ namiŋirän kuŋatkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ude yäweränkaŋ guŋ äbot täŋo yäwik yäpmäŋ kuŋatkuŋo u ba jukuwabik imaka kudup Jekopta imiŋirä Sekem täŋo kome u gägäniken kupähä päya kubä mebäriken awaŋ äneŋpäŋ yejämbuk. ");
INSERT INTO iou_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ude täŋpeŋ kuŋirä Anututä ämawebe yotpärare kukŋi kukŋi itkuŋo unita umun pähap pewän ahäŋ yämiŋirän Jekop nanakiye däpmäkta nämo yäwarän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Eruk kuŋtäŋgän Jekopkät äboriye Kenan komeken kome täpuri wäpi Lus, wäpi kubä Betel uken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Uken Jekoptä mobä bukä kubä täŋpäŋ wäpi Betel Kome Täŋo Anutu yäŋ iwetkuk. Tuänita umuntaŋpeŋ kuŋirän Anututä Betel kome uken ahäŋ imiŋkuko unita wäpi ude yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Uken ittäŋgän Rebeka täŋo watä piä webe wäpi Debora u kome uken kumäŋirän Betel kome gägäni kupähä päya mebäriken äneŋkuŋ. Päya kupähä u mebäriken Konäm Butewaki Kome yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Täŋpäkaŋ Jekoptä Mesopotemia komeken naniktä äbäŋpäŋ itkuko kadäni uken Anututä äneŋi ahäŋ imiŋpäŋ kon man ŋode iwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Gäk wäpka Jekop upäŋkaŋ wäpka Jekop wari nämo gäwetpäŋ wäpka kodaki Isrel yäŋ api gäwetneŋ. Ude yäŋpäŋ Anututä wäpi Isrel yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Täŋpäŋ iwetkuk; Nadätan, näk Anutu kehäromi mähemi. Gäk nanak bäyaŋ wek täŋpäŋ ahäŋ bumbum täŋiri äbot kubägän nämo, äma äbot ini-ini api ahäŋ yäpmäŋ kuneŋ. Ba gäkä äbotken nanik intäjukun äma imaka, api ahäneŋ. Ahäŋirä gäk orani pähap api iren yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Täŋpäkaŋ Abraham Aisakta kome yäniŋ kireŋkuro u gäka biŋam api ganiŋ kirewet. Täŋkaŋ äbekaye oraŋkaye kämi ahänayäŋ täkaŋ unita biŋam imaka, api yäniŋ kirewet yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Eruk, Anututä ude yäŋpäŋ Jekop teŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Täŋpäkaŋ Jekop Anututä man iwetkukken mobä käroŋi kubä kämi kaŋpäŋ nadäkta yäputkuk. Täŋpäŋ Anututa biŋam täkta wain ume piŋ ibatpäŋ olip gakŋi imaka piŋ ibatkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ude täŋpäŋ Anututä Jekop man iwetkuko kome u täŋo wäpi Betel yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Eruk Efrata kome kuna yäŋpäŋ Betel kome u peŋpeŋ kuŋkuŋ. Kuŋtäŋgän kädet bämopiken Resel nanak bäyawayäŋ komi nadäŋkukopäŋ nanak bäräŋeŋ nämo ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Komi taŋi ude nadäŋ irirän täŋkentäki kubätä ŋode iwetkuk; Umuntäweno! Nanak ämani äneŋi kubä ahätak yäk. ");
INSERT INTO iou_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Eruk nanak kwawak ahäwänkaŋ miŋi Resel kumbayäŋ täŋpäŋ nanaki wäpi Benoni yäŋ iwetpäŋ pengän kumbuk. Täŋpäkaŋ Benoni yäŋ iwetkukopäŋ kumäŋirän nanitä nanaki uwä wäpi Benjamin yäŋ iwetkuk. (Ninin man terak Benoni uwä Komi piäna täŋo nanak. Täŋ Benjamin uwä Nanakna bänepnaken nanik.) ");
INSERT INTO iou_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Eruk, Resel kumbänkaŋ Efrata kome nämo ahäŋkaŋ kome bämopiken, kädet gägäniken äneŋkuŋ. Efrata uwä apiŋo wäpi Betlehem yäŋ yäk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Resel äneŋpäŋä awaŋ terak mobä käroŋi kubä, kämi kaŋpäŋ nadäkta äneŋkuk. Äneŋkuko apiŋo pen itak. ");
INSERT INTO iou_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Eruk Jekop kome u peŋpeŋ kome täpuri wäpi Mikita-Ede u irepmitpäŋ ätukät kuŋpäŋ yottaba täŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Uken itkaŋ Jekop nanaki tuäni wäpi Rubentä nani täŋo watä piä webe kubä wäpi Bilha ukät päŋku parirän nanitä biŋam nadäŋpäŋ kokwawak taŋi nadäŋ imiŋkuk ");
INSERT INTO iou_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jekop täŋo nanakiye 12. Webeni Leatä bäyaŋkuko uwä ŋode; Ruben u intäjukun nanik. Mädenä Simeon, Livai, Juda, Isaka, Sebulun unitä ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Täŋ webeni Reseltäwä Josep kenta Benjamin bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Täŋkaŋ Resel täŋo watä piä webe Bilha u nanakiyat Dan kenta Naptali. ");
INSERT INTO iou_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Täŋ Lea täŋo watä piä webe wäpi Silpa uwä nanakiyat Gat kenta Ase. Jekop nanakiye uwä Mesopotemia komeken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Täŋpäŋ Jekop, nani käwa yäŋpäŋ Mikita-Ede kome peŋpeŋ Mamre kome, nani Aisaktä itkukken u kuŋkuk. Mamre kome u Hebron yotpärare u dubiniken itkuk. Hebron wäpi kubä Kiriat-Aba, Abraham kenta Aisaktä bian itkumäno u. ");
INSERT INTO iou_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aisak tägawaniinik täŋirän obaŋ 180 ude täreŋirän kumbuk. Kumäŋirän nanakiyat Iso kenta Jekoptä äneŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso, wäpi kubä Idom, unitäŋo manbiŋam ŋode; ");
INSERT INTO iou_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Webeniye Kenan komeken nanik ŋode yäpuk; Kubäwä Elon täŋo äperi Ada. Elon uwä Hit äbotken nanik. Kubäwä Ana täŋo äperi Oholibama. Ana uwä Sibeon nanaki, Hivi äbotken nanik. ");
INSERT INTO iou_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Webeni kubäwä Ismael äperi wäpi Basemat yäpuk. Basemat uwä Nebaiot täŋo noripak. ");
INSERT INTO iou_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Täŋkaŋ Iso webeni Ada uwä nanaki kubägän wäpi Erifas bäyaŋkuk. Täŋ webeni Basemat uwä nanaki kubägän wäpi Ruel bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","E, webeni Oholibama uwä nanakiye Jeus, Jalam, Kora bäyaŋkuk. Täŋpäkaŋ Iso nanakiye wäpi tawaŋ danikamäŋ uwä Kenan komeken itkaŋ ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Täŋpäkaŋ Jekop tuäni Isokät Kenan kome u bok itdeŋta nadäwän kome taŋi nämo täŋkuk. Äboriye ba yawakiye mäyap unita jide täŋpäŋ ketem ninekta ba yawaktä nakta yabäŋ ahäde yäŋ nadäŋkumän. Ude nadäŋpäŋ eruk Isotä monäni Jekop kakätäŋpeŋ kome kubäken kwa yäŋpäŋ webeniye nanakiye piä ämawebeniye yawakiye ba tuŋumi Kenan kome itkaŋ yäpuko u kuduptagän kome ban kubäken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kuŋtäŋgän Idom kome pom-pomken ahäŋpäŋ kome u yäpmäŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso uwä Idom äma äbot kome uken ahäŋkuŋo unitäŋo orani itkuk. Nanakiye oraniye täŋo wäpi tawaŋ ŋode; ");
INSERT INTO iou_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso webeni wäpi Ada unitä nanak Erifas bäyaŋkuk. Täŋ webeni kubäwä wäpi Basemat unitä nanaki Ruel bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eruk, nanaki Erifas unitäŋo nanakiye 5 ude ahäŋkuŋ. Nanakiye 5 ahäŋkuŋo u wäpi ŋode; Teman, Oma, Sefo, Gatam, Kenas. ");
INSERT INTO iou_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Täŋ Erifas webeni burenitä nanak 5 ude bäyaŋkuk. Täŋkaŋ watä piä webeni wäpi Timna yanäpi täŋpäŋ nanak Amalek bäyaŋkumän. Nanak uwä Iso webeni Ada unitäŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Täŋ Iso nanaki Ruel unitäŋo nanakiye yaräbok-yaräbok ŋode; Nahat, Sera, Sama, Misa. U uwä Iso webeni Basemat unitäŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E, Iso webeni mäden yäpuko uwä Oholibama. Oholibama uwä Ana täŋo äperi, Sibeon täŋo äbeki. Oholibama unitäŋo nanakiye uwä Jeus, Jalam, Kora. ");
INSERT INTO iou_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Täŋpäkaŋ Iso täŋo oraniye ätu äboriye täŋo äma ekänita itkuŋ. Äma ekäni itkuŋo uwä wäpi tawaŋ ŋode; Iso nanaki tuäni Erifas unitäŋo nanakiye äma ekänita itkuŋo u wäpi Teman, Oma, Sefo, Kenas, Kora, Gatam, Amalek. U uwä Iso webeni Ada täŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Täŋ Iso nanaki Ruel unitäŋo nanakiye äboriye täŋo äma ekänita itkuŋo u wäpi Nahat, Sera, Sama, Misa. U uwä Iso webeni Basemat täŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","E, Iso webeni Oholibama unitäŋo nanakiye äboriye täŋo äma ekänita itkuŋo uwä wäpi Jeus, Jalam, Kora. U uwä Iso webeni Oholibama, Ana äperi unitäŋo oraniye. ");
INSERT INTO iou_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Täŋpäkaŋ wäpi tawaŋ it yäpmäŋ äpäkaŋ uwä Iso, wäpi kubä Edom, unitäŋo nanakiye oraniye äma ekäni itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Täŋpäŋ Sei, Ho äbotken nanik, unitäŋo nanakiye Idom komeken itkaŋ ahäŋkuŋo u wäpi ŋode; Lotan, Sobal, Sibeon, Ana, Dison, Ese, Disan. Sei täŋo nanakiye u Ho äboriye täŋo äma ekänita itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Täŋkaŋ Lotan nanakiyat Hori, Heman. (Timna, Iso täŋo watä piä webeni uwä Lotan täŋo wanori). ");
INSERT INTO iou_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Täŋkaŋ Sobal nanakiye ŋode; Alvan, Manahat, Ebal, Sefo, Onam. ");
INSERT INTO iou_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Täŋkaŋ Sibeon nanakiyat Aia, Ana. Ana uwä kome äma nämo iraniken itkaŋ nani täŋo doŋkiniyeta watä it täŋkukken u ume komi nikek kome gänaŋ nanik äbäŋirän intäjukun kaŋ-ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Täŋpäkaŋ Anatä nanak yarä bäyaŋkuk. Nanaki Dison, äperi Oholibama. ");
INSERT INTO iou_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison nanakiye ŋode; Hemdan, Esban, Itran, Keran. ");
INSERT INTO iou_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Täŋ Ese nanakiye ŋode; Bilhan, Savan, Akan. ");
INSERT INTO iou_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","E, Disan nanakiyat Us, Aran. ");
INSERT INTO iou_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Täŋpäkaŋ Ho äboriye täŋo äma ekäni ŋode itkuŋ; Lotan, Sobal, Sibeon, Ana, Dison, Ese, Disan. Äma uwä äma äbori äbori Idom komeken ittäŋ kuŋkuŋo unitäŋo äma ekäni. ");
INSERT INTO iou_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Täŋpäkaŋ Isrel ämawebetä intäjukun äma kubä nämo yäpmäŋirä Idom ämawebe täŋo intäjukun äma mäyap ŋode it yäpmäŋ äbuŋ; ");
INSERT INTO iou_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Intäjukunä Beho nanaki wäpi Bela, u Idom komeken yabäŋ yäwat piä täŋkuk. Äma u Dinhaba yotpärareken nanik. ");
INSERT INTO iou_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Eruk, Belatä it yäpmäŋ äroŋpäŋ kumäŋirän Sera täŋo nanaki wäpi Jobaptä komeni yäpmäŋpäŋ intäjukun ämata itkuk. Äma unitäŋo komeni Bosra. ");
INSERT INTO iou_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Eruk Jobaptä it yäpmäŋ äroŋpäŋ kumäŋirän Husamtä komenita itkuk. Husam uwä Teman komeken nanik. ");
INSERT INTO iou_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Eruk Husamtä it yäpmäŋ äroŋpäŋ kumäŋirän Bedat nanaki wäpi Hadattä intäjukun ämata itkuk. Hadat uwä Moap komeken ämik täŋpäŋ Midian kome täŋo komi äma kehäromini yäpmäŋ äpuk. Hadat uwä yotpärareni Avit. ");
INSERT INTO iou_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Eruk Hadattä it yäpmäŋ äroŋpäŋ kumäŋirän Samlatä komeni yäpuk. Samla uwä Masreka komeken nanik. ");
INSERT INTO iou_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Eruk Samlatä it yäpmäŋ äroŋpäŋ kumäŋirän Saultä komenita itkuk. Uwä Rehobot yotpärare, Yufretis ume ani kukŋi uken nanik. ");
INSERT INTO iou_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Eruk Saultä kumäŋirän Akbo nanaki Balhanantä komeni yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Balhanantä it yäpmäŋ äroŋpäŋ kumäŋirän Hadattä komeni yäpuk. Äma uwä Pau yotpärareken nanik. Webeniwä Matret äperi wäpi Mehetabel. Matret uwä Mesahap äperi. ");
INSERT INTO iou_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Iso äboriye täŋo äma ekäni ekäni wäpi ŋode; Timna, Alva, Jetet, Oholibama, Ela, Pinon, Kenas, Teman, Mipsa, Makdiel, Iram. U uwä Idom nanik ämawebe äbori äbori unitäŋo äma ekäni. Täŋpäkaŋ wäpi Idom uwä Iso täŋo wäpi kubä. Isotä orani pähap itkuko unita kome u ba ämawebe äbot u wäpi Idom yäpuŋ. Äbot kubägän nämo itkuŋ. Äbori äbori itkuŋo u kome ini-ini yäpuŋ. Kome u ini-ini yäpmäŋpäŋ äma ekäni wäpi tawaŋ it yäpmäŋ äpäkaŋ ŋo äbori äbori unitäŋo äma ekänita itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Täŋpäkaŋ Jekop, nanitä bian itkukken, Kenan komeken u itkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Eruk Jekop nanakiye täŋo manbiŋam u ŋode; Nanaki kubä wäpi Josep u gubaŋi, obaŋi 17 ude. Uwä noriyekät sipsip kenta memeta watäni ittäŋ kuŋat täŋkuŋonik. Noriye uwä nani täŋo watä piä webe Bilha kenta Silpa unitäŋo nanakiye. Täŋkaŋ Josep uwä noriyetä kädet wakiwaki täŋpeŋ kuŋat täŋkuŋo u yabäŋpäŋ päŋku nani Jekop manbiŋam iwet täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Täŋpäkaŋ nani tägawaniinik täŋirän Josep ahäŋkuko unita nanitä Josepta gäripiinik nadäk täŋkukonik. Unita tek säkgämän käroŋi kubä, keri käroŋipäŋ bipmäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Täŋpäkaŋ noriyetä ŋode kaŋpäŋ nadäŋkuŋ; Nanitä Josepta gäripi nadäŋ imiŋkuko u ninta nadäŋ nimik täyak u irepmitak yäŋ kaŋpäŋ nadäŋkuŋ. Ude kaŋpäŋ nadäŋpäŋä Josepta gaŋani pähap nadäŋ imiŋkuŋ. Kokwawak iŋam dapun ijiŋpäŋ man täga kubä nämo iwet täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Kokwawak ude nadäŋ imiŋpäŋ kuŋarirä eruk bipani kubä Joseptä däpmonken täŋkuk. Täŋpän yäŋeŋirän däpmonken kaŋkuko u ŋode yäwetkuk; Näkä däpmonken karo u yäŋahäwa nadäwut yäk. Nin kuduptagän piä gänaŋ itkaŋ tepäraŋ ätu pädä täŋ iramäŋonik yäk. Tämäŋopäŋkaŋ näkä pädä täro uwä akuŋpäŋ käroŋ wädäŋ irak yäk. Täŋirän intä täŋo unitäwä näkä täro u it äyäŋutpäŋ gukut imäpmok täŋ imiŋirä yabät yäk. Däpmonken karo ubayäŋ yäk. Ude yäwerirän nadäŋpäŋ noriyetä gaŋani nadäŋ imiŋkuŋo u irepmitpäŋ gaŋaniinik nadäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ude yäwänä noriyetä iwetkuŋ; Gäk ninta intäjukun äma api iret yäŋ nadätan? Bure? Ude iwetpäŋ däpmonken kaŋkuko u ba man yäk täŋkuko u nadäŋpäŋ kokwawak taŋi pähap nadäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Eruk bipani kubäta däpmonken äneŋi kubä kaŋkuk. Kaŋpäŋ noriye ŋode yäwetkuk; Däpmonken karo u ŋode yabät yäk. Edap dapuri, komepakkät guk 11 ude iŋamnaken gukut imäpmok täŋ namiŋirä yabät yäk. ");
INSERT INTO iou_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Eruk noriye ude yäwetkaŋ nani imaka, päŋku iwetgän täŋkuk. Iweränä nanitä kaŋ-yäŋpäŋ ŋode iwetkuk; Wa! Däpmonken jidewanipäŋ tän! Gäk meŋka notkayekät nintä iŋamkaken gukut imäpmok kaŋ täŋ namut yäŋ nadätan? ");
INSERT INTO iou_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Täŋpäkaŋ Josep noriyetä kokwawak nadäŋ imik täŋkuŋo upäŋkaŋ nani Jekop uwä nanakitä man yäŋkuko u kudup nadäŋpäŋ iyap taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","13","Eruk kadäni kubä Josep noriye Seken komeken sipsipta watäni itta kuŋkuŋo irirä nani Jekoptä Josep iwetkuk; Notkaye sipsipta watäni itnayäŋ Sekem komeken kuŋkuŋo itkaŋ yäk. Gepmaŋpa yäpmäŋ notkayeken kwayäŋ unita tuŋum täyi yäk. Yäwänä Joseptä Täga, kwayäŋ yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yäwänä nanitä iwetkuk; Gäk kome udeken kuŋkaŋ notkaye ba tom imaka, säkgämän itkaŋ ba, goret itkaŋ yäŋ kaŋ yabä yäk. Kudup yabäŋpäŋ-nadäŋkaŋ äbä manbiŋam kaŋ näweri nadäwa yäk. Jekoptä ude iwetpäŋ Hebron awaŋ u nanik nanaki Josep tewän yäpmäŋ kuŋkuk. Eruk Josep kumaŋ Sekem komeken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sekem komeken ahäŋpäŋä noriyeta wäyäkŋeŋtäŋ kumän kuŋat moreŋkuk. Kuŋattäŋgän äma kubä ahäŋ imänä iwetkuk; Gäk imata wäyäkŋetan? ");
INSERT INTO iou_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iweränä Joseptä iwetkuk; Näk notnaye yawakiyeta watäni itkaŋ unita wäyäkŋetat yäk. Gäk uken itkaŋ yäŋ nadätan? ");
INSERT INTO iou_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Iweränä äma unitä iwetkuk; Notkaye kome ŋo peŋpeŋ kuŋkuŋ yäk. Uwä kome ŋo peŋpeŋ Dotan komeken kuna yäŋirä nadäŋkut yäk. Ude iweränä eruk Josep noriye yabäŋ ahäkta kuŋtäŋgän Dotan komeken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ahäŋpäŋ ban uduken kuŋ irirän noriyetä kaŋpäŋ kumäŋ-kumäŋ utta ŋode yäŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wisiknin! Äma däpmonken käwani ukeŋo äbätak udu yäk. ");
INSERT INTO iou_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Eruk, iŋitpäŋ kumäŋ-kumäŋ utpäŋ ume awaŋ kubä gänaŋ pena äpmoŋpän yäk. Utnakaŋ däpmonken kak täŋkuko u jide täŋpäŋ bureni api ahäneŋ? Ude täŋkaŋ päŋku nan ŋode kaŋ yäŋikŋatna; Tom ägwäri kubätä utpäŋ naŋkuk yäŋ kaŋ iwetna yäk. ");
INSERT INTO iou_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Eruk noriyetä ude yäŋirä tuäni Rubentä nadäŋpäŋ Josep täŋkentäŋpäŋ tewa yäpmäŋ nanken kaŋ kwän yäŋ nadäŋpäŋ man ŋode yäwetkuk; Kumäŋ-kumäŋ utnero! ");
INSERT INTO iou_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ba nägät iminero. Josep jop iŋitpäŋ kome jopi ŋoken ume awaŋ kubä gänaŋ tena äpmoŋpän yäk. Uwä yabäŋ paotpäŋ Josep äneŋi yäpmäŋpäŋ nanken kaŋ tewa kwän yäŋ nadäŋpäŋ man ude yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ude yäwerän nadäŋpäŋ irirä Josep, noriye dubiniken äbäŋirän iŋitpäŋ tek keri käroŋi täŋkuko u weŋ täŋpä kuŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Weŋ täŋpä kuŋ imiŋirä iŋit yäpmäŋ päŋku ume awaŋ gänaŋ tewä yäpmäŋ äpmo itkuk. Awaŋ uwä kawuki, umeni nämo. ");
INSERT INTO iou_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ude täŋkaŋ päŋku maŋit itpäŋ ketem naŋkuŋ. Ketem naŋ itkaŋ Ismael äbotken nanik ätu Gileat komeken naniktä Isip kunayäŋ äbäŋirä bankentä yabäŋkuŋ. Äma äbuŋo unitäŋo kamel terak imaka gäripi ba käbäŋi säkgämän nikek Isip komeken Isip naniktä yämiŋpäŋ gwäki yäpmäkta bumta peŋpäŋ yäpmäŋkaŋ äbuŋ. Ismael äbot uwä wäpi kubä Midian. ");
INSERT INTO iou_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ismael äbot wäpi kubä Midian u äbäŋirä yabäŋpäŋ Josep noripak kubä wäpi Judatä noriye ätu ŋode yäwetkuk; Notninpak utpäŋ käbop penayäŋ täkamäŋ u kowata imatäken upäŋ api yäpne? ");
INSERT INTO iou_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Unita utnero. Ismael äbot äbäkaŋ unita yämiŋpäŋ gwäki yäpna yäk. Ude tänayäŋ täkamäŋ unitä täga bumik. Josep uwä notninpak, nägät moräk kubägän yäk. Judatä ude yäweränä noriye ätu u nadäwä tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ude yäŋ irirä Midian moneŋ tuŋum äma u dubiniken äbuŋ. Äbäŋirän noriyetä Josep awaŋ gänaŋ nanik wädäŋ yäpmäŋ äbuŋ. Ude täŋkaŋ Ismael äbot unita yämiŋkuŋ. Yämäwä Josep gwäkita siliwa moneŋ 20 ude yämiŋkuŋ. Yämiŋpäŋ yäŋikŋat yäpmäŋ Isip komeken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ude täŋirä eruk Ruben mäden äbä awaŋ gänaŋ Josepta kawän wawäkaŋ butewaki taŋiinik nadäŋpäŋ konäm kotpäŋ teki weŋ-gajähutkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ude täŋpäŋ päŋku noriye yäwetkuk; Nanak u awaŋ gänaŋ nämo itak yäk. Unita näk jide täŋpayäŋ? ");
INSERT INTO iou_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ude yäŋirän noriye ätutä päŋku meme gubaŋi kubä utpäŋ Josep täŋo tek käroŋi uterak nanitä kakta nägäri däpä jiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Däpä jiwäpäŋ yäpmäŋkaŋ nani iwoŋärekta eŋiken kuŋkuŋ. Päŋku nani ahäŋ imiŋpäŋ tek keri käroŋi, meme nägäri nikek u iwoŋäreŋpäŋ ŋode iwetkuŋ; Nan, ŋo ka! Ŋo Josep täŋo tek ba? ");
INSERT INTO iou_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ude iwet yabäŋirä nanitä kaŋpäŋ yäŋkuk; Wära! Ŋo bureni nanakna Josep täŋo tek yäk. Tom ägwäri kubätä utpäŋ nak yäŋ nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jekop ude yäŋpäŋ butewaki taŋi nadäŋpäŋ iniken teki weŋ-gajähut maŋpän kuŋkuŋ. Weŋ-gajähut maŋpän kwäkaŋ tek wakiwaki yäpmäŋpäŋ täŋkuk. Täŋpäŋ nanaki Josepta yäŋpäŋ kadäni käroŋi konäm butewaki täŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ude täŋirän nanakiye äperiye kuduptagän nanitä itkukken ugän äbäŋ moreŋkuŋ. Äbäŋpäŋ nani iniŋ bitnänayäŋ nadäŋkuŋopäŋ konäm butewaki pekta nämo nadäŋkuk. Täŋpäŋ yäŋkuk; Nämo! Konäm kot yäpmäŋ kuŋtäŋgän kumäŋpäŋ nanaknatä kukken ugän api iwaret yäk. ");
INSERT INTO iou_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Täŋpäkaŋ Isip kome uken Midian nanik ukeŋonitä gwäki yäpmäkta Josep Potifata imiŋkuŋ. Potifa uwä Isip kome täŋo intäjukun äma Fero unitäŋo täŋkentäki kubä, komi äma Fero täŋo eŋi watä itkuŋo unitäŋo äma ärowani. ");
INSERT INTO iou_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kadäni uken Juda noriye yepmaŋpeŋ päŋku äma kubä wäpi Hira ukät itta Adulam yotpärareken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Päŋku ittäŋgän webe gubaŋ kubä kaŋgärip täŋpäŋ webenita yäpuk. Webe uwä nani wäpi Sua, Kenan komeken nanik. Eruk yanäpi täŋpäŋ bok ittäŋgän webeni nanak kok itpäŋ nanaki tuäni bäyaŋkuk. Bäyawänpäŋ nani Judatä wäpi Era yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Täŋpäŋ ittäŋ kuŋtäŋgän webeni äneŋi koki itpäŋ monäni bäyaŋkuk. Bäyaŋpäŋ wäpi Onan yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Täŋpäŋ ätu it yäpmäŋ kuŋtäŋgän nanak kok äneŋi itpäŋ nanak gweki bäyaŋpäŋ wäpi Sela yäŋ iwetkuk. Sela uwä Kesip yotpärareken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Eruk Judatä nanaki tuäni Erata webe kubä iwoyäŋ imiŋkuko uwä wäpi Tama. ");
INSERT INTO iou_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Täŋpäkaŋ Era u kädet goret-goret kuŋarirän Yawetä kawän nämo tägawäpäŋ kumäŋ-kumäŋ utkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ude täŋirän Judatä nanaki monäni Onan iwetkuk; Tuäkatä nanak kubä nämo bäyaŋkaŋ kumäŋtak unita gäkä nin täŋo kädet u iwatpäŋ webeni kajat gäkä koreŋpäŋ tuäkata nanak kaŋ bäyaŋ imi yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nanitä ude iwetkukopäŋ monänitä ŋode juku piŋkuk; Näk tuäna webeni kajat yäpayäŋ täyat uwä nanak bäyaŋirän ämawebetä U gäkŋaken nanak nämo yäŋ api näwetneŋ. U tuäka kumbuko u täŋo biŋam yäŋ api yäneŋ yäŋ nadäŋkuk. Ude nadäŋpäŋ eruk bok pat täŋkumänken nanak kok irektawä yäŋ nadäŋpäŋ ibini jopiken piak täŋkukonik. Ude täŋtäŋ kuŋkuko unita tuänita biŋam nanak kubä nämo ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onantä ude täk täŋkuko uwä Yawetä kawän täga nämo täŋpänpäŋ u imaka, kumäŋ-kumäŋ utkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Urirän kaŋpäŋä Judatä äbeki Tama ŋode iwetkuk; Nankaken kaŋ ku! yäk. Päŋku iriri gwekna Sela unitä tägaŋpäŋ webe yäpnaŋi ude täŋirän äneŋi äyäŋutpeŋ näkken ŋo kaŋ äbi yäk. Judatä tuäke monäke webe yäpmäŋpäŋ kumbumäno udegän yäpmäŋpäŋ kumäkgän täŋpek yäŋ nadäŋpäŋ äbeki iwet-pewän naniken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ude iwet-pewän kuŋirän it yäpmäŋ äroŋtäŋgän Juda webeni (u Sua äperi) kumbuk. Kumbänpäŋ äneŋkaŋ kupämta irän täreŋirän eruk kepma kubäta noripaki Adulam yotpärareken nanik wäpi Hira u imaguränkaŋ Timna komeken piä ämaniyetä sipsip pujiŋi madäŋ itkuŋken u kuŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kome uken ahäŋpäŋ irirän äma kubätä Tama iwetkuk; Nadätan? Oraŋka sipsip pujiŋi madäwayäŋ Timna komeken kuŋkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ude iwerirän Tamatä nadäŋkuk; Orana Juda, nanaki gweki wäpi Sela u tägatak upäŋkaŋ näka biŋam nämo iniŋ kiretak yäŋ nadäŋkuko unita ŋode täŋkuk; Tek webe kajattä täŋpeŋ kuŋarani u yäŋopmäŋpäŋ tek kudupi kubä täŋpäŋ ämatä nämo kaŋpäŋ nadäkta iŋami dapun uwäk täŋpipiŋkuk. Ude täŋkaŋ Judatä Temna kädet ŋo äbayäŋ nadäŋpäŋä päŋku Enaim yotpärare kädet moräkiken maŋit itkukonik. ");
INSERT INTO iou_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Eruk Juda uwä kuŋtäŋgän webe u kädet miŋin maŋit irirän kaŋpäŋ ŋode nadäŋkuk; Webe ŋo tektä iŋami dapun täŋpipiŋkuko unita kubokäret webe käwep yäŋ nadäŋkuk. Ŋo äbekna yäŋ nämo nadäŋkuk. Täŋpäŋ dubiniken kuŋpäŋä iwetkuk; Nadäŋ namiŋiri nek bok pätdayäŋ yäk. Iweränä webe unitä man ŋode iwetkuk; Bok pätdayäŋ näwetan unita imapäŋ namayäŋ? ");
INSERT INTO iou_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yäwänä Judatä iwetkuk; Nadäwätäk täŋpeno yäk. Kowatawä meme gubaŋi kubäpäŋ pewa äbayäŋ yäŋ iwetkuk. Yäwänä iwetkuk; U täga upäŋkaŋ imaka kubä namikaŋ uyaku u kaŋpäŋ meme bureni api namen yäŋ nadäwayäŋ. Meme u bureni namiwä tuŋum ŋo äneŋi api gamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yäwänä Judatä iwetkuk; Kaŋpäŋ nadäkta imatäkenpäŋ gamet? Yäwänä iwetkuk; Imaka kubä gäkŋa wäpka kudän nikek ukät ähottaba iŋitan u bok nam! Ude iweränä mani buramiŋpäŋ yäŋkuko udegän täŋkuk. Täŋpäŋ eruk bok parirän webe u nanak kok itkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Täŋpänkaŋ Tama yotken päŋku tek iŋami dapun täŋpipiŋkuko u yäŋopmäŋpäŋ peŋkaŋ tek webe kajattä täŋpani upäŋ äneŋi täŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","21","Täŋpäkaŋ Judatä iniken tuŋumi ätu webe unita imiŋkuko ukeŋo äneŋi yäpayäŋ nadäŋpäŋ noripak Hira u meme gubaŋi kubä imiŋkaŋ webe unita imikta peŋ iwet-pewän kuŋkuk. Peŋ iwet-pewän päŋku webe unita wäyäkŋewän wawäpäŋ äma ätu Enaim yotpärare u nanik ŋode yäwet yabäŋkuk; Kubokäret webe kädet miŋin maŋit irani u de itak? Yäwänä iwetkuŋ; Kubokäret webe udewani ŋo nämo yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ude iwerirä Hira äneŋi äyäŋutpeŋ Judaken kuŋkuk. Kuŋpäŋ iwetkuk; Webe ŋokeŋo nämo kaŋ-ahätat yäk. Webe udewani kome ŋoken kubä nämo itak yäŋ näwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ude iwerän nadäŋpäŋ Judatä yäŋkuk; Täga yäk. Näk nadäwätäk nämo täyat. Tuŋum imiŋkuro uwä inita biŋam täyak. Webe unita wari nämo wäyäkŋewen. Pen wäyäkŋeŋtäŋ kuŋaritda ämawebetä api nibäŋ mägayäneŋ. Meme gubaŋi u webe unita imikta yäwanipäŋ wäyäkŋewi wakaŋ unita täga, ini jop kaŋ irän yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Täŋpäkaŋ it yäpmäŋ äroŋtäŋgän komepak yaräkubä täreŋirän äma ätutä äbäŋpäŋ Juda iwetkuŋ; Äbeka Tama ukeŋowä kubokäretta kuŋattäŋgän nanak kok ikek irirän käkamäŋ yäk. Ude iweräwä kokwawak pähap nadäŋkuk. Täŋpäŋ yäŋkuk; Päŋku iŋit yäpmäŋ päŋku kädäp gänaŋ pewä ijiputpeŋ kwän! yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ude yäweränä pengän iŋit yäpmäŋ yäman äpäŋirä webe ŋokeŋo orani man ŋode iwetkuk; Nabäwut! Nanak kok itat ŋo netäŋo? Imaka wäpi kudän nikek ba ähottaba iŋitat ŋonitä äma unitäŋo yäŋahäwayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tamatä ude yäwänä Judatä imaka imaka imiŋkuko u yabäŋpäŋ ŋode yäŋkuk; Wära! Webe ŋonitäŋo momi nämo. Näkä goret täŋkut! Näk nanakna Sela tägawänkaŋ webe ŋonita iniŋ kirekta yäwanipäŋkaŋ nämo iniŋ kireŋkuro unita udewä täŋkuk yäk. Ude yäŋpäŋ eruk webe ukät bok wari nämo patkumän. ");
INSERT INTO iou_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","28","Täŋpäŋ ätu it yäpmäŋ äroŋpäŋ webe u nanak kok itkuko bäyawayäŋ täŋirän webe täŋkentäŋ imikta äbuko unitä kaŋpäŋ nadäŋkaŋ iwetkuk; Nanak kokkaken ŋo nanak yarätä itkamän yäk. Ude iwerirän nanak kubätä jukun keri pewän kwawak ahäŋirän tek moräk gämäni kubä yäpmäŋpäŋ keriken topuk. Täŋpäŋ yäŋkuk; Nanaki ŋonitä jukun ahätak yäk. ");
INSERT INTO iou_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ude yäwänä nanak u keri äneŋi wädäŋ yäpmäŋ äroŋkuk. Täŋirän noripak kubä käbop itkuko unitä jukun ahäŋkuk. Täŋirän watä webe unitä kaŋpäŋ yäŋkuk; Wa! Baga imata yeŋ weŋpäŋ intäjukun ahätan? Baga yeŋ weŋpäŋ intäjukun ahäŋkuko unita iniken man terak wäpi Peres yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Täŋ noripak kubä tek gämäni topuko u mäden ahäŋkuk. Ahäŋirän wäpi Sera yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Täŋpäkaŋ Ismael naniktä Josep u Isip komeken yäŋikŋat yäpmäŋ kuŋirän Isip täŋo intäjukun äma unitäŋo täŋkentäki kubä wäpi Potifa unitä moneŋ yämiŋpäŋ Josep watä piä jop täŋ imekta imagutkuk. Potifa uwä Isip kome täŋo intäjukun äma wäpi Fero unitäŋo watä ämata itkuk. Täŋkaŋ komi äma täŋo intäjukun äma ude itkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Eruk, Anutu Josepkät irirän Potifa täŋo eŋi gänaŋ watä piä täŋ yäpmäŋ kuŋkuko u täŋirän bureni säkgämän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ude täŋ irirän Potifatä kaŋpäŋ nadäŋkuk; U Yawetä bok itkaŋ kehäromi imik täyak unita imaka imaka täk täyak u kudup säkgämän ahäk täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ude kaŋpäŋ nadäwän tägawäpäŋ eŋini ba tuŋumi päke u yabäŋ yäwatta teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Täŋirän Yawetä Josepta yäŋpäŋ iron taŋi täŋirän Potifa täŋo äbot, tuŋumi ba epäni kudup säkgämäninik ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Yawetä ude täŋirän Potifatä Josep imaka imaka päke u yabäŋ yäwatta iniŋ kireŋkuk. Iniŋ kireŋpäŋ ini uwä imaka kubäta nadäwätäk nämo täŋkuk. Ketemgän naŋkaŋ nadäwätäk ikekkät nämo it täŋkukonik. Täŋpäkaŋ Josep uwä gupi ba iŋami dapun säkgämän. ");
INSERT INTO iou_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Unita kadäni käroŋi nämo itkaŋ Potifa webenitä Josep u kaŋgärip täŋpäŋ iwetkuk; Bok pätda yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Ude iweränä Josep bitnäŋpäŋ yäŋkuk; Imata näk kädet waki udewani täŋpet? Ŋo yabä; Tuŋum päke itkaŋ ŋonitäŋo mähemitä watäni itta nepmaŋkuk. Watäni irira ini uwä imaka kubäta nadäwätäk nämo täk täyak. U eŋi ŋo watäni itta wäpi biŋam iniken bumik namiŋpäŋ imaka kubäta nämo naniŋ bitnäŋkuk. Upäŋkaŋ imaka kubätagän naniŋ bitnäŋkuk, uwä gäk yäk. Unita imata näk kädet waki udewani täŋpäŋ Anutuken momi täŋpet? ");
INSERT INTO iou_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ude iwerirän gwäk pimiŋpäŋ kadäni kadäni pen iwet yabäk täk täŋkukopäŋ Joseptä nämoinik nadäŋ imiŋpäŋ bok patta ba dubiniken kukta bitnäk täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Täŋpäkaŋ kepma kubäta piä äma kudup kuŋ moreŋirä Josep piä täŋpayäŋ yot gänaŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Äroŋirän webe unitä iwatpäŋ tekigän iŋitpäŋ wädäŋkaŋ iwetkuk; Eruk, apiŋo bok pätdayäŋ yäk. Täŋirän Josep umuntaŋpäŋ teki punin nanik u webe keri terak yäŋopmäŋpäŋ peŋpeŋ yäman umu äpämaŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Äpämaŋ kuŋirän webe u Josep täŋo tek ŋokeŋo iŋit itkaŋ piä äma ätuta gera yäŋkuk; Oi! Äbä ŋo kawut! Hibru äma äpnatä nintä yotken imagut yäpmäŋ äbuko ukeŋonitä mäyäk nimitak yäk. Näkä däpmon patpat bägupken äbä nepmäŋirayäŋ täŋirän kähän yäyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kähän yäŋira metäŋpeŋ kuyak! Täŋkaŋ teki gupi terak nanik ŋo yäŋopmäŋpäŋ ketna terak peŋpeŋ kuyak ŋo kawut! yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ude täŋpäŋ tek u pen iŋitkaŋ irirän äpi Potifatä yoriken äbänä Josep täŋo tek u iwoŋäreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Iwoŋäreŋpäŋ manbiŋam piä äma ätu yäwetkuko udegän äpi iwetgän täŋkuk; Gäkä äma imagut yäpmäŋ äbuno ukeŋowä näkä däpmon patpatken äbäŋpäŋ mäyäk namik yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ude täŋirän näkä kähän yäŋpewa kikŋutpäŋ teki peŋpeŋ yäman äpämaŋ kuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifa, webenitä jop manman ude iwerirän nadäŋpäŋ kokwawak pähap nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Täŋpäŋ komi äma yäwerän Josep iŋitpäŋ Fero täŋo komi yotken teŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Eruk Josep komi yotken teŋkuko irirän Yawetä orakorak täŋ imiŋirän komi yot täŋo watä äma intäjukun täŋpanitä Josep kaŋpäŋ nadäwän äma täga täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ude kaŋpäŋ nadäŋkaŋ Joseptä äma komi yot gänaŋ irani u ba epän u gänaŋ täkta yäwani u kudup yabäŋ yäwatta teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Täŋpäkaŋ Yawetä Josep täŋkentäŋ imiŋpäŋ watä ämata teŋirän piä täŋkuko u tägagän ahäŋ moreŋirä intäjukun äma unitä kaŋpäŋ nadäwätäk kubä nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","It yäpmäŋ äroŋtäŋgän kadäni kubäken Isip täŋo intäjukun ämata wain ume piŋ imik täŋpani ukät käräga ijiŋpäŋ imik täŋpani, äma yarä unitä piä goret täŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Piä goret täŋirän Ferotä nadäwän wawäkaŋ komi yot kubä, komi äma täŋo watä intäjukun täŋpanitä watäni it täŋkuko uken yepmaŋpäŋ itkumän. Komi yot uwä Josep pewä itkukken ukengän äma yarä u päŋku yepmaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","5","Täŋkaŋ komi yot watä ämatä äma yarä unita watä irekta Josep iwoyäŋkuk. Eruk komi yotken kadäni käroŋi it yäpmäŋ äroŋpäŋ bipani kubäken äma yarä unitä däpmonken kaŋkumäno uwä mebäri inigän inigän yabäŋkumän. ");
INSERT INTO iou_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Patkumäno yäŋewänkaŋ Joseptä äma yarä unitä itkumänken äroŋpäŋ nadäwätäk täŋ irirän yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yabäŋpäŋä yäwetkuk; Oi, ek imata nadäwätäk täŋ itkamän? ");
INSERT INTO iou_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yäweränä iwetkumän; Nek däpmonken tämäko unita mebäri netä niwerek yäŋpäŋ nadäwätäk täŋ itkamäk yäk. Ude iweränä Joseptä yäwetkuk; Nadäwun! Däpmonken täŋo mebäri nadäk-nadäk u Anutu täŋo epän unita näwerun! ");
INSERT INTO iou_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ude yäweränä äma Ferota wain ume piŋ imik täŋpani unitä däpmonken täŋkuko unitäŋo manbiŋam ŋode iwetkuk; Näk ŋode kaŋkut yäk. Näk kaŋ-iwarira wain päya kubä tädotpäŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Täŋpäŋ unitäŋo känani yaräkubä äroŋpäŋ irori täŋkuk. Irori täŋpäŋ bureni ahäŋpäŋ gämäneŋkuŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Bureni gämäneŋirä näk Fero täŋo ume ehät ketna kukŋitä iŋitkaŋ ketna kukŋitä wain bureni iŋitpäŋ täkätpewa umeni ehät gänaŋ äpmoŋkuŋ. Äpmoŋpäkaŋ Ferota imiŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ude yäŋirän Joseptä iwetkuk; Mebäri ŋode gäwera yäk. Känani yaräkubä uwä edap yaräkubä ude itta kaŋkun. ");
INSERT INTO iou_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Edap yaräkubä täreŋirän Ferotä gämagut päŋku piäkaken äneŋi api gepmaŋpek. Täŋpäkaŋ gäk bian wain umeni piŋ imik täŋkuno äneŋi udegän api piŋ imik täŋpen yäk. ");
INSERT INTO iou_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ude täŋpäŋ bänep täga terak kuŋatpäŋä näka butewaki nadäŋpäŋ Fero iwerikaŋ yot ŋo peŋpeŋ kaŋ kwa! ");
INSERT INTO iou_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nadätan? Näk Kenan komeken nanik kubota nämagut päbä kome ŋoken komi piä täkta nepmaŋkuŋ. Täŋkuŋopäŋ waki kubä nämo täŋira jop nadäŋ komi yot ŋoken nepmaŋkuŋ! ");
INSERT INTO iou_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Joseptä ude yäŋirän äma Ferota käräga ijiŋpäŋ imik täŋpani unitä Joseptä noripaki u däpmonken täŋo mebäri täga yäŋahäŋpäŋ iwetak yäŋ nadäŋpäŋ ŋode iwetkuk; Näk däpmonken udegän kaŋkut yäk. Uwä ŋode; Näk käräga basket yaräkubä gwäknaken peŋpäŋ yäpmäŋ kuŋatkut. ");
INSERT INTO iou_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Yäpmäŋ kuŋarira basket punin u gänaŋ Ferota biŋam käräga gäripi mebäri mebäri irirä baraktä äbäŋpäŋ naŋ paotkuŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ude iwerirän Joseptä man kowata ŋode iwetkuk; Mebäri ŋode gäwera; Basket yaräkubä uwä edap yaräkubä ude itta kaŋkun. ");
INSERT INTO iou_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Edap yaräkubä täreŋirän Ferotä yäniŋ kireŋpewän kotäkka madäŋ täkŋeŋpäŋ gupka päya terak wabiŋirä baraktä api naŋ paotneŋ. ");
INSERT INTO iou_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Joseptä ude yäweränkaŋ edap yaräkubä täreŋirän Fero iniken ahäk-ahäk kadäni täŋirän äŋnak-äŋnak pähap täŋpa yäŋkaŋ piä ämaniye intäjukun täŋpani yämagutkuk. Ude täŋpäŋ äma Ferota wain ume piŋ imik täŋpani ukät äma Ferota käräga ijiŋpäŋ imik täŋpani yarä u komi yot gänaŋ nanik bok yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yämagutpäŋ äma wainta mebäri nadäwani uwä piä bian täŋpani äneŋi täŋpekta iniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Upäŋkaŋ käräga ijiŋ imani äma uwä Joseptä iwetkuko udegän kotäki madäŋ täkŋeŋpäŋ gupi päya terak wabiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ferotä ude täŋpänkaŋ wainta mebäri nadäwani äma unitä Josepta juku nämo peŋpäŋ guŋ taŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Eruk it yäpmäŋ äroŋtäko obaŋ yarä täreŋirän Ferotä däpmonken ŋode täŋkuk; Fero ini Nail ume dubiniken käroŋ itkaŋ bulimakau 7 gupi täga Nail ume gänaŋ naniktä abäŋpäŋ tepäraŋ naŋ irirä yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","4","Bulimakau 7 ude abäkaŋ bulimakau 7 äneŋi abuŋo uwä kujarigän, intäjukun ahäŋkuŋo udewani nämo. Unitä abämaŋ noriyetä itkuŋken u kuŋkuŋ. Kuŋpäŋä noriye gupi täga uwä naŋpäŋ kämä äpmoŋkuŋ. Eruk Fero ude kaŋpäŋ kikŋutkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kikŋutkaŋ äneŋi patpäŋ däpmonken äneŋi kubä ŋode täŋkuk; Säguom kubä tädotpäŋ äroŋirän kaŋkuk. Uterak bureni 7 taŋi, tägatä ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Eruk u punin terak äneŋi kubä tädotpäŋ äroŋkuko uwä bureni 7 mänit kädäp ikektä däpani pogopigän ude ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Täŋpäkaŋ bureni pogopigän unitä bureni täga uwä kudup kämä äpmoŋkuŋ. Kämä äpmoŋirä kaŋpäŋ Fero äneŋi kikŋutkuk. Kikŋutpäŋ ŋo däpmonken täyat yäŋ nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Patkuko yäŋewänä Ferotä däpmonken täŋkuko unita nadäwätäk pähap täŋpäŋ ämaniye nadäk-nadäk ikekkät kären käwani äma u kudup yämagut päbä yepmaŋkuk. Yepmaŋpän irirä däpmonken täŋkuko yäwetpäŋ unitäŋo mebärita yäwet yabäŋkuk. Yäwet yabäŋirän däpmonken täŋo mebäri kubä nämo yäŋahäŋpäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Täŋpäkaŋ äma Ferota wain ume piŋ imik täŋpani unitä Fero ŋode iwetkuk; Wära! Näk apiŋo momina kubä nadätat u yäŋahäŋpäŋ gäwera yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Gäk piä ämakayat nekta nadäwäwak täŋ nimiŋpäŋ äma käräga ijiŋpäŋ gamik täŋpani ukät nek komi yot kubä, komi äma täŋo watä intäjukun täŋpanitä watäni it täŋkuko uken nipmaŋkun. ");
INSERT INTO iou_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Komi yotken nipmaŋkuno kadäni uken bipani kubäkengän nek däpmonken bok täŋkumäko uwä mebäri inigän inigän. ");
INSERT INTO iou_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Täŋpäŋ kadäni uken Hibru äma gubaŋi kubä komi yot täŋo intäjukun äma unitäŋo watä piä täŋ imani itkuko unitä däpmonken täŋkumäko u iwetdapäŋ mebäri ini-ini niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mebäri niwetkuko udegän ahäŋ nimiŋkuk; Näk nämagut päbä piänaken äneŋi nepmaŋkun. Täŋ, äma gäka käräga ijiŋpäŋ gamik täŋpani uwä päya terak wabiŋkun yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ude iwerirän Ferotä komi äma peŋ yäwet-pewän Josep bäräŋeŋ imagut yäpmäŋ äbuŋ. Imagut yäpmäŋ äbäŋpäŋä gwäki geŋi pujiŋ bok madäŋ imiŋpäŋ tek kodaki täŋ imiŋkaŋ Fero iŋamiken yäŋikŋat yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Yäŋikŋat yäpmäŋ kwäwä Ferotä Josep ŋode iwetkuk; Nadätan? Näk bipani däpmonken täŋkuro unitäŋo mebäri nadäkta yäwet yabäwapäŋ kubätä däpmonken täŋo mebäri nämo näwerak yäk. Täŋkaŋ gäka ŋode yäŋirä nadät; Gäk däpmonken täŋpäŋ gäwerirä mebäri yäŋahäŋpäŋ yäwet täyan. U bureni ba? ");
INSERT INTO iou_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ude iwerirän Joseptä Fero man kowata ŋode iwetkuk; Näkŋa-tägän täga nämo täŋpet. Mebäri nadäwayäŋ täyan uwä Anututä gäwerayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","18","Ude iweränä Ferotä Josep iwetkuk; Näk däpmonken ŋode täŋkut. Näk Nail ume dubiniken käroŋ wädäŋ itkaŋ bulimakau 7 gupi täga Nail ume gänaŋ naniktä abäŋpäŋ tepäraŋ naŋ irirä yabäŋkut. ");
INSERT INTO iou_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Bulimakau 7 ude intäjukun abäkaŋ uterak äneŋi 7 ude abuŋo uwä kujarigän, Isip komeken näkä nämo yabäwani. ");
INSERT INTO iou_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bulimakau kujarigän unitä abämaŋ noriyetä itkuŋken kuŋkuŋ. Kuŋpäŋä noriye gupi täga uwä naŋpäŋ kämä äpmoŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Naŋpäŋ kämä äpmoŋkuŋopäŋ ude täŋkuŋ yäŋ nämo yabäŋpäŋ-nadäwen. Nämo, koki nämo tokŋeŋpäŋ irani udegän itkuŋ. Däpmonken ude täŋpäŋ kikŋutkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kikŋutpäŋ akuŋkaŋ äneŋi patpäŋ däpmonken ŋode täŋkut; Säguom kubä tädotpäŋ äroŋirän kaŋkut. Uterak bureni 7 taŋi, tägatä ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","U punin terak äneŋi kubä tädotpäŋ äroŋkuko uwä bureni 7 mänit kädäp ikektä däpani pogopigän ude ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Täŋpäkaŋ bureni pogopigän unitä bureni täga uwä kudup kämä äpmoŋkuŋ. Däpmonken ude täŋkut yäk. Däpmonken ude täŋkuro unita kären käwani ämatä mebäri näwerut yäŋkaŋ yäwerakaŋ mebärita täŋguŋ taŋkuŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ude iweränä Joseptä Fero ŋode iwetkuk; Däpmonken yarä täŋkuno unitäŋo mebäri kubägän. Anututä kudän kubä pewän ahänayäŋ täkaŋ unita kwawak gäwoŋäreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulimakau 7 gupi täga däpmonken yabäŋkuno uwä obaŋ 7 ude itta täyak. Ba säguom bureni täga nikek 7 yabäŋkuno uwä udegän obaŋ 7gän. Däpmonken yarä unitäŋo mebäri kubägän. ");
INSERT INTO iou_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Täŋ bulimakau 7 gupi kujarigän, tohari nämo uwä obaŋ 7 nakta jop itnayäŋ tämäŋo unitäŋo wärani. Ba säguom bureni mänit kädäp ikektä däpani pogopigän ahäŋirä yabäŋkuno u imaka, udegän. ");
INSERT INTO iou_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Unita nadäsi! Gäwetat ŋo bureni api ahäwek. Anututä pewän ahänayäŋ täŋo uwä gäwoŋäreŋkuko u yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nadätan? Isip kome pähap ŋoken obaŋ 7 u gänaŋ ketem ahäŋ bumbum api täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Upäŋkaŋ kadäni täga u täreŋirän u punin terak nakta jop irit obaŋ äneŋi 7 api it yäpmäŋ äroneŋ. Kadäni uken nakta jop irit wakiinik ahäŋirän säkgämän itkuŋo unita guŋ takinik api täneŋ. Bureni, kome ŋo api waŋ morewek. ");
INSERT INTO iou_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Unita Fero, gäk ŋode nadäsi; Däpmonken kadäni yarä täŋkuno u mebäri kubägän täŋkuno uwä mebäri ŋodeta; Anututä imaka u bureni api pewa ahäneŋ yäŋ nadäk peyak. Täŋkaŋ imaka u ahäkta kadäni keräpi täyak yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ude yäŋpäŋ Joseptä Fero ŋode iwetgän täŋkuk; Eruk, gäk äma nadäk-nadäki täga kubä iwoyäŋpäŋ Isip kome pähap u kudup watäni irekta epän kaŋ imi yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ude täŋpäŋ kaŋiwat äma ätu yepmaŋpipäŋ obaŋ 7, täŋ-bumbum kadäni ahäwayäŋ täko u gänaŋ ketem ahäŋirä äma unitä ketem moräki gapmanta biŋam yäpmäŋpäŋ kämita kaŋ pek täŋput yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kaŋiwat äma uwä kadäni täga uken ketem kämi nakta u yäpmäŋ daninayäŋ täŋo uwä kudup yotpärare kubäkubä täŋo ketem pewani yot gänaŋ pewä kuŋirä watäni kaŋ irut yäk. Täŋpäkaŋ Fero, epän uwä gäkŋa wäpka terak kaŋ täŋput. ");
INSERT INTO iou_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ketem penayäŋ täŋo uwä nakta jop irit obaŋ 7 ahäwayäŋ täko unita biŋam kaŋ pewut. Ude tänayäŋ täkaŋ uwä nakta jop irit kadäni uken kubätä nämo api kumbek. ");
INSERT INTO iou_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ude iweränä Ferokät piä ämaniye Joseptä man yäŋkuko u nadäwä tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nadäwä tägawäpäŋ Ferotä piä ämaniye ŋode yäwetkuk; Nin äma Josep udewani, Anutu täŋo Munapik ikek, netäpäŋ api kaŋ-ahäne? Imata äma kubäta wäyäkŋene? ");
INSERT INTO iou_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ude yäŋpäŋ Josep iwetkuk; Bureni, man niwetan u Anututä yäŋahäŋpäŋ gäwetak. Unita äma nadäk-nadäk ikek gäk ŋodewani kubä nämo itak yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Unita gäkä näkŋo kome pähap ŋo watä irenta gepmaŋtat yäk. Gäk man yäŋiri ämawebenaye kudup gäkŋo man api buramineŋ. Täŋpäkaŋ äma kubätä gärepmitnaŋi nämo. Nämo, näkägän gäkŋo ärowani api iret yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ferotä ude yäŋpäŋ ŋode iwetgän täŋkuk; Eruk, Isip kome pähap täŋo watä ärowani gepmaŋtat yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ude iwetpäŋ siworok keri nanakiken pewani Fero ini wärani nikek u keriken nanik ketäreŋpäŋ Josep keri nanakiken peŋ imiŋkuk. Täŋpäŋ tek säkgämän wädäwän äroŋ imiŋpäŋä meran kubä golpäŋ täŋpani meran täŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ude täŋpäŋ Ferotä Josep ŋode iwetkuk; Gäk näkŋo äpani ude itan unita näkŋo karis namba 2 hostä wädäwani uterak kuŋat täyi! Uterak kuŋariri äma ätutä intäjukun kuŋpäŋ ŋode api yäwettäŋ kuneŋ; Gukut imäpmok täŋ imut! yäŋ ude api yäwettäŋ kuneŋ yäk. Ude täŋkuko uwä Ferotä Josep Isip täŋo watä äma pähap teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ude yäŋpäŋ Josep äneŋi ŋode iwetgän täŋkuk; Näk Isip täŋo intäjukun äma itat upäŋkaŋ gäkä nämo nadäŋ yämiŋiri Isip komeken äma kubätä ini nadäŋpäŋ imaka kubä täga nämo api täŋpek. Gäkä nadäŋiri uyaku täga api täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Täŋpäŋ Ferotä wäpi kodaki Safenat-Panea yäŋ iwetkuk. Wäpi kodaki iwetkaŋä eruk webenita Heriopolis yotpärare täŋo bämop äma wäpi Potifera unitäŋo äperi wäpi Asenat u imiŋkuk. Täŋpäkaŋ Joseptä Isip kome pähap täŋo watä äma intäjukunta itkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josep uwä obaŋ 30 ude täreŋirän Ferotä Isip kome kaŋiwat piä u täkta iniŋ kireŋkuk. Täŋirän Josep Fero teŋpeŋ päŋku Isip kome kudup kaŋiwat piä täŋtäŋ kuŋatkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ude täŋpäŋ kuŋarirän Isip komeken obaŋ 7 ketem ahäŋ bumbum täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Täŋkaŋ obaŋ 7 u gänaŋ ketem kämi nakta u kudup yotpärare kubäkubä täŋo ketem pewani yot gänaŋ pewä kuŋ moreŋkuŋ. Ketem kämita peŋkuŋo uwä yotpärare kubäkubä epän iniken iniken u gänaŋ nanik. ");
INSERT INTO iou_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseptä ude täkta yäwettäŋ kuŋarirän ketemtä yot tokŋeŋpäŋ jiraŋ ude patkuŋ, ämatä täga daninaŋi nämo täŋpäkaŋ ketem danik-danik epän u peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Täŋkaŋ nakta jop irit kadäni u nämo ahäŋirän Josep webeni Asenat uwä nanaki yarä bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nanaki tuänitä ahäŋirän Joseptä ŋode yäŋkuk; Anututä täŋkentäŋ namiŋirän notnaye meŋna nanata nadäwätäk täŋkuro u täretak, ba komi nadäŋ yäpmäŋ äburo u täretak. Unita nanakna tuä ŋo wäpi Manase yäŋ iwetat. ");
INSERT INTO iou_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Täŋpäŋ nanaki monänitä ahäŋirän ŋode yäŋkuk; Komi piäna kome ŋoken Anututä nanaknaye namitak unita wäpi Efraim yäŋ iwetat yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Täŋpäkaŋ Isip komeken ketem ahäŋ bumbum obaŋ 7 u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Tärewänkaŋ nakta jop irit obaŋ 7 Joseptä bian yäŋkuko u ahäŋkuk. Ude ahäŋirän kome päke uken ketem nämo upäŋkaŋ Isip komeken ketem täga naŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Eruk nakta jop irit u wakiinik täŋirän Isip ämawebetä nakta Ferotä ketem yämikta yäŋapiŋkuŋ. Yäŋapiŋirä Ferotä ŋode yäwetkuk; In Josepken kwäkaŋ unitä yäwänkaŋ uterakgän kaŋ täŋput yäk. ");
INSERT INTO iou_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Täŋpäkaŋ nakta jop irit u wakiinik täŋpäŋ Isip kome u kudup pat yäpmäŋ kuŋkuk. Ude ahäŋirän Joseptä ketem yot it yäpmäŋ kuŋkuŋo u dät yämiŋirän Isip ämawebetä suwaŋpäŋ nak täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Täŋkaŋ kome ätuken udegän, nakta jop irit waki ahäŋirän ämawebe uken nanik-naniktä äbäŋpäŋ Josepken yäŋapiwäpäŋ nadäŋ yämiŋirän ketem suwaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kenan komeken nakta jop udegän itkaŋ Jekoptä manbiŋam ŋode nadäŋkuk; Isip komeken ketem suwaŋpäŋ-nak täŋ itkaŋ. Ude nadäŋpäŋ nanakiye yäwetkuk; In imata jop itkaŋ kowat kawän täŋ itkaŋ? ");
INSERT INTO iou_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isip komeken ketem itkaŋ yäŋ nadätat unita uken kuŋpäŋ ketem suwaŋpäŋ yäpmäŋ äbut, jop itpäŋ nakta kumneta! ");
INSERT INTO iou_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Nanitä ude yäŋpäŋ yäwet-pewän Josep noriye 10 udetä ketem suwanayäŋ Isip komeken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Upäŋkaŋ Jekoptä Josep noripaki mäden nanik-inik wäpi Benjamin u noriyekät kukta yäjiwätkuk. Kädet miŋin kuŋtäŋgän bäräpi kubä ahäŋ imek yäŋ nadäŋpäŋ iyap taŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Täŋkaŋ Jekop täŋo nanakiye uwä Kenan kome mähemkät penta kuŋkuŋ, nakta jop irit Kenan komeken imaka, ahäŋkuko unita. ");
INSERT INTO iou_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Täŋpäkaŋ Joseptä Isip kome täŋo watä äma pähap itkaŋ, ämawebe uken-uken nanikta ketem yämiŋirän suwaŋkuŋ. Ude täŋ irirän Josep noriye ukeŋo päŋku ahäŋ imiŋpäŋ gwäjiŋ äpmoŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Täŋirä Joseptä noriye yabäŋpäŋ-nadäŋkukopäŋ mebärini nämo yäŋahäŋpäŋ yäwetkaŋ man kädäp ikek ŋode yäwet yabäŋkuk; In de naniktä äbäkaŋ? Ude yäwänä iwetkuŋ; Ketem suwanayäŋ Kenan komeken naniktä äbäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseptä notnaye yäŋ nadäŋkukopäŋ kowata nämo kaŋpäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Täŋpäŋ Joseptä däpmonken bian täŋkuko unita juku piŋpäŋ ŋode yäwetkuk; Nadätat! In nintäŋo iwaniyetä nibäŋpäŋ nadäk tänayäŋ äbäkaŋ. In ninkät ämik täkta nadäŋpäŋ kome kubä de uken watäni nämo itak yäŋ kaŋpäŋ nadäk tänayäŋ äbäkaŋ. Ude nibäŋpäŋ nadäŋkaŋ komejinken kuŋpäŋä intäjukun ämajiye ŋode api yäwetneŋ; Uken ba uken watäni nämo itkaŋ yäŋ api yäwetneŋ! ");
INSERT INTO iou_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ude yäweränä noriyetä yäŋkuŋ; Ärowanina, ude nämo! Watä ämakaye ninä, ketem suwakta äbäkamäŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nin äma kubä täŋo nanakiyegän. Ninä jop man nämo yäwani. Yäyan udeta nämo äbäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iweräwä yäwetkuk; Jop man yäkaŋ! Nintäŋo iwantä nibäŋpäŋ nadäk täna yäŋpäŋ äbäkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yäwänä iwetkuŋ; Yäke, ude nämo! Nin ninin buap 12 ude ahäŋkumäŋ, äma kubä täŋo nanakgän, Kenan komeken irani. Täŋkaŋ nintäŋo mäden nanik kubä naninkät itkamän. Täŋ notninpak kubä paotkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ude yäŋirä Joseptä yäwetkuk; Ude nämo. Näk bian täweraro ude; In nintäŋo iwaniyetä nibäŋpäŋ nadäk tänayäŋ äbäŋ ŋo unita mebäri kwawak ahätak. ");
INSERT INTO iou_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Näk Fero täŋo wäpi terak man kehäromi ŋode täwetat; Intäŋo notjinpak mäden nanikjin unitä kome ŋo nämo äbeko uwä in kome ŋo naniktä äneŋi äyäŋutpeŋ komejinken nämo api kuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Unita notjinpak kubä peŋ iwet-pewä päŋku notjinpak nanikät itkamän u imaguränkaŋ äbun! In ätuwä komi yotken irirä man yäkaŋ u jop ba bureni yäŋ api kaŋpäŋ nadäwet. Notjinpak nämo ahäwänä in jop man yäwani, nintäŋo iwantä nibäŋpäŋ nadäkta äbäkaŋ yäŋ bureni-inik api nadäwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ude yäŋpäŋ komi yotken yepmaŋirän edap yaräkubä ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","19","Edap yaräkubä tärewäkaŋ Joseptä ŋode yäwetkuk; Nadäkaŋ? Näk Anutu u umuri yäŋ nadäŋpäŋ kuŋat täyat yäk. Unita näkä tepmaŋpa kukta nadäŋpäŋä ŋode kaŋ täŋput; In äma täga siwoŋi kuŋatkaŋ u täŋpäwä, notjinpak kubägänpäŋ tewa komi yot gänaŋ irirän in ätuwä ketem tama yäpmäŋ päŋku mähemjiye ketemta jopinik itkaŋ unita yämut yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Yämiŋkaŋ notjinpak mäden nanik uwä imagut yäpmäŋ äbut. Intä ude täŋpäwä in man bureni näwetkaŋ yäŋ nadäŋpäŋ kumäŋ-kumäŋ nämo api tadäpet yäk. Joseptä ude yäweränä yäŋkuko udegän täkta nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Täŋkaŋ ini-tägän näwetgäwet täŋpäŋ yäŋkuŋ; Bureni! Mäden naniknin waki täŋ imiŋkumäŋo unita kowata umuri pähap ŋo ahäŋ nimitak yäk. U konäm butewaki täŋ nimiŋirän mani nadäŋpäŋ kowata nämo täŋkentäŋ imiŋkumäŋo unita kudän umuri ŋo kowata ahäŋ nimitak yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ude yäŋpäŋ Rubentä yäwetkuk; Näk täwetkuro uwä! Notninpak u waki täŋ imineŋo yäŋ täwerakaŋ nämo nadäŋ namiŋkuŋo unita kumäk-kumäki täŋo kowata ahäŋ nimitak ŋo yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Joseptä noriye täŋo man nadäŋkukopäŋ man yäwerayäŋ nadäŋkaŋ man yäpmäŋ äyäŋurani äma iwerirän äma unitä man yäpmäŋ äyäŋutpäŋ yäwetkuko unita noriyetä nin täŋo man nämo nadätak yäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ude täŋpäŋ inigän päŋku konäm kotkuk. Konäm korän tägawäkaŋ äneŋi äbäŋpäŋ noriyetä kaŋirä Simeon iŋitpäŋ keriyat pädät täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ude täŋkaŋ piä ämaniye yäwet-pewän ketem ini yäkken-yäkken daiŋ yämiŋkuŋ. Yäkken daiwä tokŋewäpäŋ uterak moneŋ ketem u suwakta yäpmäŋ äbuŋo u äneŋi daiŋ yämiŋkuŋ. Ude täŋpäŋ kädetta däkum yämikta yäwetkuk. Yäwerirän udegän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ude täŋpäkaŋ Josep noriye ketem suwaŋkuŋo u doŋki terak peŋpäŋ yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kuŋtäŋgän kome bipänpäŋ patkuŋken noripak kubätä doŋkinita ketem imayäŋ nadäŋpäŋ iniken yäk meni pitpäŋ kaŋkuk; Moneŋ ketem suwaŋkuko u yäk meniken irirän. ");
INSERT INTO iou_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kaŋpäŋ noriye yäwetkuk; Näkŋo moneŋ äneŋi peŋ namiŋkuŋo yäk meniken itak ŋo yäk. Ude nadäŋpäŋ-nadäwätäk pähap täŋpäŋ yäŋpäŋ-nadäk ŋode täŋkuŋ; Nin kädet siwoŋi tämäŋopäŋkaŋ mebäri imata Anututä bäräpi ŋo pewän ahäŋ nimitak yäk? ");
INSERT INTO iou_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Parä yäŋewänkaŋ kuŋtäŋgän Kenan komeken ahäŋpäŋ nani Jekop manbiŋam kuduptagän iwet moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Manbiŋam ŋode iwetkuŋ; Isip kome unitäŋo äma ärowanitä man kädäp ikek ŋode niwetkuk; In iwan täŋ nimikta äbäkaŋ yäŋ niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","32","Ude niweränä ŋode iwetkumäŋ; Nin äma täga, ninin buap 12, nanin kubägän. Ninkät nanik kubä-tägän paotkuk. Täŋ mäden nanik-inikä naninkät komenin Kenan u itkamän yäŋ iwetkumäŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ude iwetnawä kowata ŋode niwetkuk; In äma täga ba waki yäŋ nadäkta ŋode täŋirä kaŋ nadäwa; Inkät nanik kubä ŋogän irirän in ätuwä mähemjiye nakta jop itkaŋ unita ketem yäpmäŋ päŋku kaŋ yämut yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Äneŋi äbäŋpäŋä mäden nanikjin imaguräkaŋ kaŋ äbut yäk. Intä ude täŋpäwä In äma täga yäŋ api nadäwet. In äma täga yäŋ nadäŋ tamiŋpäŋ notjinpak ŋo taniŋ kirewapäŋ in kome ŋoken ketem suwakta täga äbäŋkaŋ kuk api täneŋ yäk. Man ude niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nani manbiŋam ude iwetkaŋä ketem yäkken nanik ketem pewaniken äreŋpä kuŋkuŋ. Ude täŋpäŋä moneŋ ketem suwakta yämani ukeŋo kuduptagän yäk meniken yabäŋ ahäŋkuŋ. Moneŋ u yabäŋpäŋ nani ba nanakiye kudup umun pähap täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Moneŋ yabäŋpäŋ nani Jekoptä ŋode yäwetkuk; In ude täŋpäŋ nanaknaye kudup nomägatnayäŋ. Josep paotkuk, udegän Simeon ŋo nämo itak. Täŋpäŋ Benjamin imaka, nomägatnayäŋ täkaŋ uwä butewaki pähap u näkägän api nadäwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ude yäŋirän Rubentä nani iwetkuk; Näk Benjamin äneŋi nämo yäpmäŋ äbawä unita kowata nanaknayat bok kaŋ däpmäŋ yäk. Unita Benjamin näk ketna terak pe. Näkä äneŋi täga api yäpmäŋ äbäŋ gamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ude iweränä Jekoptä yäŋkuk; Nanakna ŋo inkät nämoinik api kwek! Bianinitä kumbukopäŋ inigän it namitak. In kädet miŋin kuŋtäŋgän umuri kubä ahäŋ tamiŋirän nanakna Benjamin ŋo käwep kumbek. Ude ahäweko uwä intä täŋpewä äma tägawani näk kumbet yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Täŋpäkaŋ nakta jop irit uwä Kenan komeken pen wakiinik itkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ude irirän Isip komeken nanik ketem yäpmäŋ äbuŋo uwä naŋpä paorirän Jekoptä ŋode yäwetkuk; In ninta ketem suwakta äneŋi kaŋ kut yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ude yäŋirän Judatä nani iwetkuk; Nan, nadätan? Isip täŋo intäjukun äma unitä man kehäromi ŋode niwetkuk; In mäden nanikjinkät bok nämo äbäwä näk nämo api tabäwet yäk. Injingän äbäŋkaŋ iŋamnaken nämoinik api ahäneŋ yäŋ ude niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Unita nan, gäkä Benjamin bok kukta niniŋ kireweno uwä täga päŋku ketem api suwane yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Upäŋkaŋ iyap tawiwä nämo api kune, äma unitä ŋode yäŋkuko unita; Injingän nämoinik ämneŋ yäk. Notjinpakkät bok nämo äbäwä nämo api nadäŋ tamet yäŋ niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Judatä ude yäwänä nani Jekoptä yäwetkuk; In Benjamin täŋo manbiŋam äma u imata iwetkuŋ? Ude täŋkuŋo uwä komi namikaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yäwänä nanakiyetä iwetkuŋ; Äma unitä yäŋyabäk mäyap ŋode niwetkuk; Nanjin kumbuk ba itak? Ba notjinpak mäden nanik kubä itak? Yäŋyabäk ude niwerirän itkamäŋ ude manbiŋam iwetkumäŋ. Ude iweritna kowata ude api niwerek yäŋ nämo nadäŋkaŋ iwet moreŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ude yäŋpäŋ Judatä nani iwetkuk; Benjamin näka naniŋ kirewipäŋ akumaŋ kuna yäk. Ude täŋpeno uyaku gäk ba nintäŋo webe nanak kudup nakta nämo api kumne. ");
INSERT INTO iou_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Täŋkaŋ ŋode yäŋkehärom täyat; Näkŋa Benjaminta watäni api iret. Täŋ äneŋi nämo imagut yäpmäŋ äbawä unitäŋo momi näka biŋam irirän kome terak it yäpmäŋ kuŋira api tärewek yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Eruk kuna! Kadäni käroŋi jop itkamäŋ. Yäŋ-nadäwätäk nämo täŋkumäŋ yäwänäku Isip kome kuŋkaŋ äbäk kadäni yarä uku tänam yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yäŋirän nanitä yäwetkuk; Yäyan ude tänaŋi täŋpäwä in kuna yäŋpäŋ imaka gäripi nikek kome ŋo nanik upäŋ yäkjinken daiŋpäŋ yäpmäŋ kaŋ kut yäk. Päya mujipi näŋpani, päya umumi käbäŋi nikek ba kähäräp umeni näŋpani, imaka udewani ätu ironjinta yäpmäŋ päŋku äma unita kaŋ imut! ");
INSERT INTO iou_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Täŋpäŋ moneŋ taŋi yäpmäŋkaŋ kut yäk, moneŋ kodaki bok bian ketem yäk meniken daiŋkaŋ tamiŋkuŋo u bok. Täŋguŋ taŋpäŋ tamiŋkuŋ käwep yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ude täŋkaŋ Benjamin imaguräkaŋ äma ukenä kut! yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Intä kuŋirä Anutu Kehäromi mähemitä täŋkentäŋ tamiŋirän notjinpak Simeon ba Benjamin ŋo bok tepmaŋpänkaŋ kaŋ äbut. Täŋ nanaknaye paot namikta biŋam täŋpäwä ini kaŋ paot namut! ");
INSERT INTO iou_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ude yäwänkaŋ eruk nanakiyetä iron täŋo tuŋum, moneŋ kodaki ba biani bok yäpmäŋkaŋ Benjamin imaguräkaŋ Isip komeken kumaŋ päŋku Josep ahäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ude täŋirä Joseptä Benjamin kaŋpäŋ yori watä äma iwetkuk; Äma äbäkaŋ u yäŋ-yäkŋat yäpmäŋ päŋku yotna gänaŋ yepmaŋ yäk. Ude täŋkaŋ tom kubä utpäŋ ijiwut. Ijiwäpäŋ kepma äma ukät ketem bok nänayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ude iweränkaŋ yäŋkuko udegän iwatpäŋ Joseptä yotken yämagut päŋku yämaken yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Joseptä ini yotken yämagut yäpmäŋ kuŋirän noriyetä bumta umuntaŋpäŋ yäŋkuŋ; Wära! Intäjukun äbumäŋo ugän yäkninken moneŋ äneŋi daiŋ nimiŋkuŋo unita käwep ŋo nipmaŋkaŋ yäk. Nin yot ŋo iritna äbä nidäpmäŋpäŋ doŋkinin niyomägatpäŋ komi piäniken api nipmaneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ude yäŋpäŋ Joseptä yot yämaken ahäŋpäŋ itkaŋ yot watä äma u ŋode iwetkuŋ; ");
INSERT INTO iou_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","21","Nadätan? Nin bian ketem suwakta äbumäŋopäŋ ninin komeken äneŋi kuŋtäŋgän kädet miŋin patkumäŋken yäk gänaŋ nin kubäkubä täŋo moneŋ kudup irirä yabäŋkumäŋ. Ude täŋkumäŋopäŋ moneŋ u äneŋi yäpmäŋ äbäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ba ugän nämo, moneŋ kodaki, ketem äneŋi suwakta yäpmäŋ äbäkamäŋ. Moneŋ biani u netä daiŋ nimiŋkuŋo u nämo nadäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ude yäwäwä yäwetkuk; Umuntäneŋo! Anutujin, Nanjin täŋo Anutu unitä yäkjinken daiŋ tamiŋkuk yäŋ nadäwut! Näk moneŋjin uku täga yäput yäk. Ude yäŋkaŋ päŋku Simeon komi yot gänaŋ nanik imagut yäpmäŋ noriyetä itkuŋken äpuk. ");
INSERT INTO iou_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Imagut yäpmäŋ äpäŋpäŋä noriye kudup Joseptä ini yot gänaŋ yäŋ-yäkŋat yäpmäŋ äroŋpäŋ ume gwet yämiŋirän kuroŋi ärutkuŋ. Ume gwet yämiŋkaŋ doŋkinita imaka, ketem yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ude täŋkaŋ Joseptä ketem bok nakta kepma äbayäŋ yäŋ ude nadäŋpäŋ ironta tuŋum yäpmäŋ äbuŋo u täŋtuŋum taŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ude täŋ irirä Joseptä äbänä iron tuŋumi yäpmäŋ äbuŋo u iŋamiken peŋkuŋ. Peŋpäŋ gwäjiŋ äpmoŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Gwäjiŋ äpmoŋ imiŋirä Joseptä yäwetkuk; Ai, näwerut! Nanjin tägawanita näwetkuŋo ukeŋo apiŋo jide itak? Täga itak ba kumbuk? ");
INSERT INTO iou_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yäwänä yäŋkuŋ; Piä ämaka nanin u täga itak yäk. Ude yäŋpäŋ gukuri imäpmok täŋpäŋ gwäjiŋ äpmoŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Gwäjiŋ äpmoŋ imiŋkaŋ akuŋirä iniken monäni Benjamin u kaŋpäŋ yäŋkuk; Notjinpak nanjinkät irirän näwetkuŋo ukeŋo ŋo? Ude yäŋpäŋ Benjamin iwetkuk; Nanakna, Anututä täŋkentäŋ gamiton! yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ude iwetpäŋ iniken monäni kaŋkuko unita butewaki nadäŋpäŋ konäm korayäŋ uruŋ käda bäräŋeŋ päŋku kotkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Konäm korän tärewäpäŋ iŋami dapun umetä ärutpäŋ kehärom taŋpäŋ äneŋi noriye dubiniken kuŋkuk. Noriye dubiniken kuŋpäŋ watä äma iwetkuk; Ketem gwet nimi! yäk. ");
INSERT INTO iou_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ude iweränä watä äma unitä ketem ini äbot-äbot peŋ yämiŋkuk. Josepta inigän, Josep noriyeta inigän, eruk Josep täŋo piä ämaniye, Isip nanik unita inigän peŋkuk. Isip naniktä Hibru ämakät ketem penta nakta taräki nadäk täŋkuŋo unita udewä täŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Josep inigän irirän noriye Josep iŋamiken inigän tawaŋ terak tuänitä it päŋku mäden nanik Benjaminken täreŋkuk. Ude itkaŋ Josepkät kowat kawän täŋ itkaŋ nadäwä inide kubä täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ude irirä watä äma unitä ketem gäripi nikek Josep inita pewani yäpmäŋpäŋ yämiŋkuk. Ude täŋpäŋ noriyeta kubäkubä yämiŋkaŋ Benjaminta mäyap peŋ imiŋkuk. Eruk, ketem naŋpäŋ ume komi bok naŋpäŋ kuduptagän oretoret täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Komeniken äneŋi kunayäŋ täŋirä Joseptä yot watä irani ŋode iwetkuk; Gäk äma ŋonita ketem mäyap, ini yäpnaŋi uterakgän yäkiken gwet yämi yäk. Ude täŋpäŋä iniken iniken moneŋ ketem suwakta yäpmäŋ äbuŋo u udegän ini yäkken-yäkken meniken äneŋi daiŋ yämi. ");
INSERT INTO iou_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Täŋpäŋ näkŋaken ume gwet näŋpani siliwapäŋ täŋpani u mäden naniki täŋo yäk meniken peŋkaŋ ketem täŋo moneŋ bok daiŋ imi yäk. Joseptä watä äma iwet-pewän udegän täŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Täŋpäŋ patkuŋo yäŋewänä eruk noriye u, doŋki tuŋumikät yepmaŋpä yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Yotpärare peŋpeŋ ban nämo kuŋirä Joseptä yot watä ämani iwetkuk; Eruk, gäk yäwat yäpmäŋ ku! Päŋku yabäŋpäŋ ŋode yäwet; Imaka umuri pähap täkaŋ yäŋ päŋku yäwet. Täga täŋ tamänkaŋ kowata imata waki täŋ imiŋpäŋ ume gwet näŋpani siliwapäŋ täŋpani u kubota yäpmaŋ? Ärowaninatä ukengän ume nak täyak. U it imiŋirän däpmonken täŋo mebäri yäŋahäk täyak. Ude täŋirä wakiinik täyak! yäŋ yäwet yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Man ude iwetpäŋ peŋ iwet-pewän päŋku yabäŋ ahäŋpäŋ Joseptä yäŋkuko udegän yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ude yäweränkaŋ kowata ŋode iwetkuŋ; Ärowaninin! Man ude imata niwetan? Nin kudän udewani nämo täk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nin bian ketem yäk meniken moneŋ yabäŋ ahäŋkumäŋo u Kenan komeken nanik äneŋi yäpmäŋ äbumäŋ. Unita imata äma ärowanika täŋo moneŋ tuŋum kubota yäpne? ");
INSERT INTO iou_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Unita tuŋum u ninken nanik kubä täŋo yäk gänaŋ kaŋ-ahäwiwä kumäkta biŋam kaŋ täŋpän! Täŋpänkaŋ nin ätu gäka komi piä api täne yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yäwäwä yäwetkuk; Yäkaŋ ude kaŋ ahäwän! Ume gwet näŋpani ukeŋo kubätä yäkken kaŋ-ahäwawä äma unitägän näkŋo watä piä api täŋpek. Ätu uwä yepmaŋpa jop api kuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ude yäwänä yäki bäräŋeŋ yäpmäŋpäŋ komen peŋpäŋ meni kudup pitkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Meni kudup pitkaŋ irirä Josep täŋo watä äma unitä yäk kubäkubäken duiŋ ijiŋkuk. Tuäniken jukun yäput peŋkaŋ yabäŋtäŋ päŋku mäden nanik Benjamintä yäkken ume gwet näŋpani ukeŋo bureni kaŋ-ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kaŋ-ahäwänä umuri pähap nadäŋpäŋ teki weŋpäŋ tuŋum ketem täŋ butuŋpäŋ doŋki terak peŋpäŋ äyäŋutpeŋ yotpärareken äneŋi kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","15","Kuŋpäŋä Josep yoriken pen irirän Judakät noriyekät yori gänaŋ äroŋpäŋ Josep gwäjiŋ äpmoŋ imiŋirä yäwetkuk; Wa! In kudän ude imata täkaŋ? Äma näk ŋodewanitä kären täŋpäŋ intäŋo mebäri käbop irani täga kaŋpäŋ nadäwek yäŋ nämo nadäŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yäwänä Judatä yäŋkuk; Yäke, ima manpäŋ gäwetne? Anututä nintäŋo mebäri kwawak peyak unita jide gäweritna nadäwi tägawek? Nadätan? Notninpak mäden nanik unitäŋo yäk meniken ume gwet näŋpani kaŋ-ahätak unitägän nämo, nin kumäntagän gäka watä piä api täŋ gamine. ");
INSERT INTO iou_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ude iweräwä Joseptä yäŋkuk; Ude nämo! Yäk meniken ume gwet näŋpani kaŋ-ahätak unitägän näka watä piä api täŋ namek. In ätuwä säkgämän kumaŋ nanjinken kukot! ");
INSERT INTO iou_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","20","Yäwänä Judatä Josep iwetkuk; Ärowanina! Nadäŋ namiŋiri man gäwerira kokwawak nadäŋ nameno yäk. Gäk Fero bumikgän itan unita kadäni kubä äbäŋitna ŋode niwetkun; Nanjin itak? Ba notjinpak kubä itak? yäŋ ude niweriri ŋode gäwetkumäŋ; Ei, nanin itak. Täŋkaŋ mäden naniknin kubätä itak. Uwä nanin tägawani irirän ahäŋkuk. Täŋ iniken tuäni uwä kumbuk. Miŋitä nanak yaräbok ugän bäyaŋ yepmaŋkukopäŋ kubä-tägän itak. Unita nanintä mäden nanik unita gäripi taŋi nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","22","Ude gäweritna ŋode niwetkun; In u imagut yäpmäŋ näkken äbäŋirä api käwet yäŋ niweriri ŋode gäwetkumäŋ; Nanak unitä nani teŋpeŋ kunaŋi nämo. Teŋpeŋ kuŋirän nani butewakita kumbek. ");
INSERT INTO iou_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ude gäweritna niwetkun; Mäden nanikjin u nämo imagut yäpmäŋ äbäŋpäŋä näk äneŋi nämo api nadäŋ tamet! ");
INSERT INTO iou_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Man ude yäŋiri nintä kuŋpäŋ watä piä ämaka nanin gäkŋo manbiŋam iwetkumäŋ. ");
INSERT INTO iou_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Iweritna nanintä Ketem suwakta äneŋi kut! yäŋ niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ketem suwakta äneŋi kut yäŋ niwerirän iwetkumäŋ; Täga nämo api kune yäk. Benjamin bok kunayäŋ täkamäŋ uyaku täga api kune. Benjaminkät bok nämo kunero uwä Isip kometa watäni pähap itak unitä täga nämo api nadäŋ nimek. ");
INSERT INTO iou_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","28","Ude iwetnapäŋ nanintä niwetkuk; Webenatä nanakna yarä ugän bäyaŋ namiŋkuko u nadäkaŋ? Kubätä waki nepmaŋ paotkuk. Tom ägwäritä käwep utpäŋ naŋ paotkukopäŋ nämo kak täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","We! Nanakna mäden nanik-inik ŋo nomägatnayäŋ täkaŋ? In kädet miŋin kuŋtäŋgän umuri kubä ahäŋ tamiŋirän nanakna Benjamin ŋo käwep kumbek. Ude ahäweko uwä intä täŋpewä äma tägawani näk api kumbet yäŋ niwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Nanin uwä man ude niwetkuko unita notninpak mäden nanik ŋo täga nämo teŋpeŋ kune yäk. Nanintä notninpak mäden nanik ŋonita gäripi taŋi nadäk täyak unita watä piä ämakaye nintä teŋpeŋ kunero uwä nanintä iŋamta wäyäkŋewän wawäpäŋ api kumbek. Kumäŋirän momi nintä yäpne yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Näk notnapak mäden nanik ŋo nan iŋamiken äneŋi yäpmäŋ kwetta man kehäromi ŋode iwetkut; Näkŋa Benjaminta watäni api iret. U äneŋi nämo imagut yäpmäŋ äbero uwä unitäŋo momi näka biŋam irirän kome terak it yäpmäŋ kuŋira api tärewek yäŋ iwetkut. ");
INSERT INTO iou_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Unita ärowanina, nadäŋ namipäŋ notnapak mäden nanik ŋonita kowata näkä itpäŋ gäkŋo watä piä täŋ gamiŋira noriyekät kaŋ kut! yäk. ");
INSERT INTO iou_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Niningän täga nämo api kune. Butewaki ärowani pähap udewani nana terak ahäŋirän kakta nämo nekaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Noriyetä ude yäŋirä Joseptä piä ämaniye itkuŋo u yabäŋpäŋ iŋamiken koret yäŋ nadäŋpäŋ ŋode yäŋkuk; In kuduptagän äpämaŋ kut! yäk. Ude yäŋirän äpämaŋ kuŋirä Joseptä noriye mebärini yäŋahäŋpäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ude täŋpäŋ konäm mabiŋ kot täŋirän piä ämaniye yäman itkuŋo u nadäŋpäŋ Ferotä yotken biŋam man tewän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Täŋkaŋ Joseptä noriye ŋode yäwetkuk; Näk notjinpak Josep! Nana itak? Ude yäwerän nadäŋpäŋ noriyetä bumta umuntaŋpäŋ kowata man nämo iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Umuntaŋ irirä Joseptä noriye yäwetkuk; In tuän ŋogän äbut yäk. Yäwet-pewän dubiniken äbäŋirä ŋode yäwetkuk; Näk mäden nanikjin Josep yäk. Intä gwäki yäpmäkta Isip komeken nepmaŋpä äburo u näk ŋo! yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nadäwätäk täneŋo. In moneŋ yäpmäŋpäŋ kome ŋoken naniŋ kireŋkuŋo unita injinta kokwawak nämo nadäneŋ. Ämawebetä kumneŋ yäŋpäŋ Anututä ini nadäŋpäŋ nepmaŋpän äbut yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Apiŋo nakta jop irit ahäŋirän obaŋ yarä täretak. Piä kodakiken yänat täktäk kadäni nämo keräp täyak. Unita jop it yäpmäŋ äronayäŋ täkamäŋ u obaŋ 5 ude äneŋi it yäpmäŋ api äroneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","In ba äbotjiye paotneŋ yäŋpäŋ Anututä intäjukun nepmaŋpän äbut yäk. Anututä näkä täŋkentäŋ tamikta ude täŋkuko uwä ini pärik kubä täŋkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","U nadäkaŋ? Intä nämo nepmaŋpä äbut. Nämo, Anututä ini-tägän nepmaŋpän äburo unita Fero nadäŋ imiŋirän Ferotä iniken yot watä ba Isip täŋo watä äma ärowani iretta nepmaŋkuk yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ude yäŋpäŋ yäŋkuk; Eruk, inä bäräŋeŋ kuŋkaŋ nana manbiŋam ŋode kaŋ iwerut; Nanaka Joseptä gäka man ŋode yäŋkuk; Anututä Isip kome pähap unita äma ärowani nepmaŋkuk. Unita kadäni käroŋi nämo iren. Bäräŋeŋ näkken kaŋ äbi yäŋ iwerut. ");
INSERT INTO iou_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Äbikaŋ Gosen komeken tuän ugän api tepmaŋpet. Äbayäŋ täno u gäkŋagän nämo. Nanakaye, äbekaye, oraŋkaye, yawakaye it tamikaŋ u kudup yämagurikaŋ kaŋ äbut yäŋ iwerut. ");
INSERT INTO iou_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nadäkaŋ? Nakta jop irit uwä pen it yäpmäŋ kuŋirän obaŋ 5 ude api tärewek. Unita in uken irirä näkä tabäŋ täwarira gäk ba äbotkaye yawakaye nakta nämo api kumneŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Näkŋo mebäri apiŋo nadäkaŋ. Dapunjintä nabäŋirä näkŋaken monäna Benjamin imaka, udegän nabätak yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Näk Isip komeken piä ärowani täŋpäŋ itat unitäŋo manbiŋam bok, imaka imaka yabäŋpäŋ-nadäk täkaŋ unitäŋo manbiŋam nana kaŋ iwerut! Ude täŋpäŋ bäräŋeŋ kaŋ imagut yäpmäŋ äbut. ");
INSERT INTO iou_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ude yäwetpäŋ monänikät kowat bäyaŋ imän täŋpäŋ korän kotkumän. ");
INSERT INTO iou_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Konäm korit-korit päŋku noriye ätuwä bäyaŋ yämiŋpäŋ bumumiken yeŋpäŋ konäm kot yebatkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ude täŋ irirä äma kubätä Ferotä yotken kuŋpäŋ Ferokät ämaniye manbiŋam ŋode yäwetkuk; Josep noriye äbäkaŋ yäk. Yäwerirän bänep täga nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","18","Ude täŋpäŋä Ferotä Josep iwetkuk; Notkaye ŋode yäwet yäk. In doŋki terak tuŋum ketemjin peŋpäŋ Kenan komejinken äyäŋutpeŋ kuŋpäŋ nanjin ba webe nanakjiye yämaguräkaŋ näkken kaŋ äbut! Täŋpäkaŋ kome täga taniŋ kirewapäŋ Isip komeken ketem ahäŋ bumbum pätak ŋo naŋpäŋ kaŋ irut yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ferotä ude yäŋpäŋ ŋode yäkgän täŋkuk; Ŋode yäwet yäk. In webejiye nanakjiyeta nadäŋpäŋ Isip komeken nanik karis tomtä wädäwani ätu kaŋ yäpmäŋ kut. Täŋkaŋ nanjin bok kaŋ imagurut! yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ude täŋkaŋ imaka tuŋum yot gänaŋ nanik unita nadäwätäk täneŋtawä. Isip komeken tuŋum udewanigän tägatäga itkaŋ u api tamine yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ferotä man iwetkuko u Joseptä noriye yäwetpäŋ karis tomtä wädäwani ätu ba ketem kädet miŋin nakta yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Täŋkaŋ noriye ätuta tek kubäkubä daiŋ yämiŋkuk. Ude täŋpäŋä Benjaminta tek säkgämän 5 ude imiŋpäŋ uterak moneŋ taŋi siliwa moneŋ 300 ude imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Täŋkaŋ nanitawä doŋki 10 terak Isip kome täŋo tuŋum gäripi nikek ätu peŋkuk. Täŋpäŋ äneŋi doŋki webeni 10 uterak ketem ätu nanita biŋam naŋtäŋ Isip komeken äbekta peŋpäŋ peŋ yäwet-pewän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Peŋ yäwet-pewän kunayäŋ täŋirä ŋode yäwetkuk; In kuŋtäŋgän kädet miŋin yäŋawät-awät nämo täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ude yäwet-pewän Isip kome peŋpeŋ kumaŋ päŋku Kenan komeken nani Jekop ahäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ahäŋ imiŋpäŋ manbiŋam ŋode iwetkuŋ; Nanaka Josep itak! yäk. Unitä Isip kome pähap unitäŋo äma ärowani itak. Ude yäŋirä Jekoptä man iwetkuŋo u nadäŋpäŋ kikŋutpäŋ nadäwän bureni nämo täŋpäpäŋ jop yabäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nadäwän bureni nämo täŋpäkaŋ Joseptä man yäwetkuko udegän iwet moreŋkuŋ. Täŋpäŋ karis tomtä wädäwani Joseptä nanita biŋam pewän kuŋkuŋo u yabäŋpäŋ bäneptä oretoret nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ude täŋpäŋ yäŋkuk; Täga. Nanakna Josep itak unita näk nämo kaŋkaŋ kumbero udeta eruk päŋku kaŋ käwa! yäk. ");
INSERT INTO iou_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ude yäŋpäŋ Jekoptä imaka imaka kuduptagän kobet täŋpäŋ päŋku Beseba komeken ahäŋpäŋ nani Aisak täŋo Anutu iniŋ oretta tom kubä utpäŋ ijiŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ude täŋirän Anututä däpmonken ŋode iwetkuk; Jekop! Jekop! Yäwänä Jekoptä yäŋkuk; Näk ŋo yäk. ");
INSERT INTO iou_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Yäwänä yäŋkuk; Näk nanka Aisak täŋo Anututä nadäŋ gamitat unita Isip komeken kukta umuntäweno. Uken uyaku gepmaŋpa nanak weŋbäyak täŋiri äbotkaye taŋi api ahäŋ yäpmäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Näk gäkkät bok Isip komeken api kude yäk. Täŋpäkaŋ ittäŋgän uken nanikpäŋ äneŋi api gämaguret. Täŋkaŋ nanaka Joseptä watä it gamiŋ yäŋpäŋ kuŋirän api kumben yäk. ");
INSERT INTO iou_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Anututä ude iweränkaŋ Jekoptä Beseba kome pena yäŋ yäŋirän nanakiyetä nani ba webeniye nanak kudup karis tomtä wädäwani Ferotä pewän äbuŋo uterak yepmaŋpä äroŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Kenan komeken itkaŋ tuŋum päke yäpuŋo ukät yawakiye kudup bok yämagut yäpmäŋ kuŋkä Isip komeken ahäŋkuŋ. Jekoptä äperiye nanakiye äbekiye oraniye u kudup Isip komeken yämagut yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ŋowä Jekop nanakiye oraniye Isip komeken kuŋkuŋo unitäŋo wäpi tawaŋ. Täŋkaŋ webeni kubä wäpi Leatä nanakiye ŋode bäyaŋ imiŋkuk; Nanaki tuäni Ruben. ");
INSERT INTO iou_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben nanakiye Hanok, Palu, Hesron, Kami. ");
INSERT INTO iou_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Täŋ nanaki kubä wäpi Simeon. Unitäŋo nanakiye ŋode; Jemuel, Jamin, Ohat, Jakin, Soha, Saul. (Saul uwä, Simeon webeni Kenan komeken nanik yäpuko unitä bäyaŋkuk.) ");
INSERT INTO iou_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Täŋ nanaki kubäwä wäpi Livai. Unitäŋo nanakiye ŋode; Geson, Kohat, Merari. ");
INSERT INTO iou_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Täŋ nanaki kubäwä wäpi Juda. Unitäŋo nanakiye ŋode; Era, Onan, Sela, Peres, Sera. (Era kenta Onan u Kenan komeken kumbumän). Peres uwä nanakiyat Hesron, Hamul. ");
INSERT INTO iou_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Täŋ nanaki kubäwä wäpi Isaka. Isaka täŋo nanakiye ŋode; Tola, Puva, Iop, Simron. ");
INSERT INTO iou_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Täŋ nanaki kubäwä wäpi Sebulun, unitäŋo nanakiye ŋode; Seret, Elon, Jalel. ");
INSERT INTO iou_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nanakiye u Leatä Mesopotemia komeken Jekopta bäyaŋ imiŋkuk. Äperi kubä wäpi Daina kome ugän ahäŋkuk. Äperi nanakiye ba oraniye kuduptagän 33 ude. Uwä Leatä bäyawani. ");
INSERT INTO iou_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Eruk, Jekop webeni kubä wäpi Silpatä nanakiye bäyaŋkuko uwä ŋode; Kubäwä Gat. Gat nanakiye Sefon, Hagi, Suni, Esbon, Eri, Arodi, Areli. ");
INSERT INTO iou_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Täŋ nanaki kubä Ase. Unitäŋo nanakiye ŋode; Imna, Isva, Isvi, Beria. Äperi kubägän wäpi Sera. Beriawä nanakiyat Hebe kenta Malkiel. ");
INSERT INTO iou_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nanakiye oraniye uwä Silpatä tawaŋken ahäŋkuŋ. Silpa uwä Lea täŋo watä piä webe, nani Labantä imiŋkuko u. Nanakiye oraniye 16 ude ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Täŋpäkaŋ Jekop webeni Reseltä nanakiyat Josep kenta Benjamin bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseptä Isip komeken webeni wäpi Asenat yäpmäŋirän nanakiyat Manase kenta Efraim bäyaŋkuk. Webeni uwä Potifera, Heliopilis kome täŋo bämop äma, unitäŋo äperi. ");
INSERT INTO iou_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Täŋ Benjamin täŋo nanakiye ŋode; Bela, Beke, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim, At. ");
INSERT INTO iou_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jekop webeni Reseltä nanak ude bäyaŋ imiŋkuk. Nanakiye, oraniye 14 ude Reseltä tawaŋken nanik. ");
INSERT INTO iou_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Täŋpäkaŋ Jekop webeni kubä wäpi Bilhatä nanakiye ŋode bäyaŋkuk; Kubäwä Dan. Dan nanaki kubägän wäpi Husim. ");
INSERT INTO iou_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Täŋ nanaki kubä Naptali. Unitäŋo nanakiye ŋode; Jasel, Guni, Jese, Silem. ");
INSERT INTO iou_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Nanakiye oraniye 7 u Bilhatä tawaŋken nanik Jekopta biŋam bäyawani. Bilha uwä Resel täŋo watä piä webe, nani Labantä imiŋkuko u. ");
INSERT INTO iou_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Eruk ämawebe Jekoptä äbotken ahäwani Isip komeken kuŋkuŋo u kuduptagän 66 ude. (Nanakiye täŋo webeniye u nämo daniŋkaŋ 66 ude ahäŋkuŋ.) ");
INSERT INTO iou_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joseptä Isip komeken irirän nanak yarä ahäŋkumäno u bok daniŋpäŋ Jekop äboriye Isip komeken itkuŋo u 70 ude itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","29","Täŋpäŋ Jekoptä Gosen komeken kwa yäŋpäŋ nanaki Juda intäjukun Josepken iwet-pewän kuŋkuk. Päŋku Josep iweränkaŋ karis hostä wädäwani kubä tuŋum täŋpäŋ uterak nani imagutta Gosen komeken kuŋkuk. Josep päŋku nani Jekop kaŋ-ahäŋpäŋ bäyaŋ imiŋpäŋ kadäni käroŋi kot ibat itkuk. ");
INSERT INTO iou_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Konäm kot ibattäyon Jekoptä nanaki Josep iwetkuk; Eruk, iŋamka dapun gabäŋpäŋ itan yäŋ nadätat unita kumäkta pidäm täyat yäk. ");
INSERT INTO iou_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ude iwerirän Joseptä noriyekät nani pähap ŋode yäwetkuk; Näk päŋku Fero man ŋode iwerayäŋ; Notnaye ba nana täŋo äboriye Kenan komeken iranitä näkken äbäkaŋ. ");
INSERT INTO iou_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Äbot uwä sipsipta watäni itkaŋ bulimakau piä bok täk täkaŋ. Yawakiye, tuŋumi kuduptagän yäpmäŋ äbuŋ. Näk Fero man ude iwerayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Unita nadäwut! Ferotä yäŋ-tämagut päŋku tepmaŋpäŋ In ima piä täk täkaŋ? yäŋ täwet yabäŋirän ŋode kaŋ iwerut; Watä piä ämakaye nin nanak täpuriken sipsip yawakta watäni itkumäŋonitä it yäpmäŋ äbäkamäŋ, oraniyetä täŋpani udegän. In man ude iweräwä Ferotä nadäwän taräki täŋirän kome gägäni kubä wäpi Gosen uken api tepmaŋpek. Isip naniktä piä ude täŋpanita taräki nadäk täkaŋ unita yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Eruk Joseptä man ude yäwet paotpäŋä Feroken kuŋpäŋ iwetkuk; Nana, notnaye, yawak ba tuŋumi u kudup yäpmäŋpäŋ Kenan komeni peŋpeŋ äbuŋo Gosen komeken itkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ude iwetkaŋ noriye 5 udepäŋ Fero iŋamiken yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Yepmaŋirän Ferotä Josep noriye ŋode yäwet yabäŋkuk; E! In ima piä täk täkaŋ? Ude yäweränä yäŋkuŋ; Watä piä ämakaye nin yawak sipsip watäni it täkamäŋ, oraniyetä täŋpani udegän yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nin kome ŋoken itpäŋ-nadäkta äbumäŋ. Kenan komeninken nakta jop irit pähap ahäŋkuko unita yawakninta ketem kubä nämo itkuŋ. Unita gäkä nadäŋ nimiŋiri Gosen komeken api itne yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","Ude yäwänä Ferotä Josep iwetkuk; Nankakät notkaye gäkken täga äbuŋ yäk. Nadätan? Isip kome pähap ŋo gäk ketka terak itak. Unita nankakät notkaye Gosen kome tägaken yepmaŋpipäŋ itkot. Uken itkaŋ äbotkaye ukät nanik kubä äma nadäk-nadäk ikek u täŋpäwä yepmaŋpipäŋ näkŋo yawaknayeta watäni kaŋ irän yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ferotä ude yäweränkaŋ Joseptä nani imagut yäpmäŋ Feroken kuŋkuk. Päŋku ahäŋ imiŋpäŋ Jekoptä Fero kon man iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kon man iweränä Ferotä iwet yabäŋkuk; Gäkŋo obaŋ jide? ");
INSERT INTO iou_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yäwänä Jekoptä iwetkuk; Kome terak ittäŋ kuŋatkuro uwä obaŋ 130 ude täreŋkuk. Kadäni keräpi u komi butewaki nikek itkut. Upäŋkaŋ nanaye oranayetä kome terak itpäŋ-nadäk kadäni käroŋi täŋkuŋo udegän nämo kaŋ-ahätat. ");
INSERT INTO iou_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ude yäŋpäŋ kon man iwetpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Täŋpäkaŋ Ferotä man yäŋkuko ude Joseptä noriyekät nanita Isip kome kukŋi inita biŋam yäniŋ kireŋkuk. Kome u tägagämän, Rameses yotpärare käda yepmaŋpän itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Josep ude täŋpäŋ nani ba noriye ba noriye täŋo webeniye nanakiye yawakiyeta ketem yämiŋkuk. Uwä nanakiye jide itkuŋo u terak ketem yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Täŋpäkaŋ komeni komeni nakta jop irit ahäŋtäŋ kuŋtäyon Isip kome ba Kenan kome mähemi bok, nakta bumta yeŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ude ahäŋirän ämawebe u naniktä äbä ketem gwäkita moneŋ peŋkuŋ. Peŋirä Joseptä moneŋ u kudup yäpmäŋpäŋ Ferotä yotken kubäkengän peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","U punin terak, eruk Isip ba Kenan komeken moneŋ paotkuk. Moneŋ paorirän kome mähemtä äbäŋpäŋ Josep iwetkuŋ; Gäk ketem jop nimi. Ketem nämo nimiŋpäŋ nibäŋ äwaräkuk täŋiri dapunkaken kumnayäŋ. Nintäŋo moneŋ kudup paotkuko ubayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ude yäwäwä Joseptä yäwetkuk; Moneŋjin paoräwä yawakjiye kaŋ yäpmäŋ äbut! Yäpmäŋ äbäŋirä unita kowata ketem api tamet yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ude yäŋirän yawakiye ketem gwäkita yäpmäŋ äbuŋ. Hos, sipsip, meme, bulimakau, doŋki kuduptagän yäpmäŋ äbäŋirä kowata Joseptä ketem yämiŋkuk. Ude täŋ yäpmäŋ kuŋtäko obaŋ u täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Obaŋ u täreŋirän obaŋ äneŋi kubä keräp taŋirän Josepken äbäŋpäŋ iwetkuŋ; Ärowaninin, imata jop man gäwetne? Nin täŋo moneŋ kudup paotkuŋ, ba tom imaka, u gäka biŋamgän täŋ moreŋkuŋ. Unita ninin ba komenin ugänpäŋ täga ganiŋ kirene. ");
INSERT INTO iou_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Täŋkaŋ iŋamkaken imata ninin ba komenin bok jop paotneŋ? Ude nämo! Gäk nin ba komenin suwaŋpäŋ ketem nimikaŋ komenin Ferotä inita biŋam täŋirän nininä Ferota watä piä kaŋ täŋ imina. Kumäŋpäŋ paoritna kometä jop päreko udeta ketem yeri nimiŋiri yeri piŋpäŋ naŋpäŋ nämo api kumne. ");
INSERT INTO iou_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ude iweräkaŋ Joseptä Isip kome kudup Ferota biŋam suwaŋkuk. Ketem kubä nämo irirän unita ämawebe Isip komeken nanik kuduptagän ini komen komen ketem gwäkita Ferota biŋam iniŋ kireŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ude täŋirä Joseptä Isip kome kukŋi kukŋi umude unude äma itkuŋo u kuduptagän Ferota watä piä täkta biŋam yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kome päke u suwaŋkaŋ bämop äma täŋo kome ugänpäŋ nämo suwaŋkuk. Ferotä bämop äma piäni gwäkita ketem yämik täŋkuko unita komeni nämo yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ude täŋpäŋ Joseptä ämawebe ŋode yäwetkuk; Näk apiŋo injin ba komejin suwawapäŋ Ferota biŋam täkaŋ unita ketem yeri ŋo yäpmäŋ päŋku piwut! yäk ");
INSERT INTO iou_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ketem piwäpäŋ bureni ahäŋirä äbot 5 ude kaŋ pewut. Eruk, ketem äbot 4 uwä in ba webejiye nanakjiyetä nakta ba yerita peŋkaŋ äbot kubäwä Ferota biŋam kaŋ pewut yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ude yäweränä ämawebetä iwetkuŋ; Gäkä täŋkentäŋ nimiŋiri nämo kumbumäŋo unita nibäwi tägawäpäŋ Fero täŋo watä piä kaŋ täna yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ude täŋpäŋ Joseptä Isip kometa kädet ŋode pewän ahäŋkuko pen itak; Ketem piäken nanik äbot 5 ude peŋkaŋ äbot 4 piä mähemi inita biŋam. Täŋ äbot kubäwä Ferota biŋam. Täŋpäkaŋ bämop äma täŋo komewä Ferotä nämo suwaŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isrel ämatä Gosen kome mähem ude täŋpäŋ irirä äperiye nanakiye mäyap ahäŋkuŋo udegän tuŋum ahäŋ bumbum täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Täŋpäkaŋ Jekop Gosen komeken obaŋ 17 it yäpmäŋ äroŋirän iniken obaŋ 147 täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Eruk, kumäk-kumäk kadänini keräp taŋirän nanaki Josep yäŋ-imagutpäŋ ŋode iwetkuk; Näka gäripi nadäŋpäŋä oraŋ namiŋpäŋ ketka gäyeknaken peŋkaŋ gupna Isip komeken nämo api äneŋpet yäŋ yäŋkehäromtä. ");
INSERT INTO iou_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Isip nanik nämagut päŋku nanaye oranaye äneŋpani-kengän kaŋ nepmaŋ yäk. Yäwänä Joseptä iwetkuk; Yäyan ude api täŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yäyan ude api täŋpet yäŋ iwerirän Jekoptä yäŋkuk; Man yäyan u bureni yäŋkehäromtä! yäk. Ude iweränä Joseptä yäŋkehäromtak man iwetkuk. Iwerän täreŋirän ähottaba iŋitkaŋ gwäjiŋ äpmoŋkaŋ Anutu iniŋ oretkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","It yäpmäŋ äroŋtäŋgän Josep manbiŋam ŋode iwetkuŋ; Nanka käyäm täyak yäk. Ude iwerirä Joseptä nanakiyat Manase Efraim yämagurän yäpmäŋ oranitä yotken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Päŋku ahäŋirä äma kubätä Jekop iwetkuk; Nanaka äbätak yäk. Ude iwerirän nadäŋ moreŋ aku itkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Täŋpäŋ Josep iwetkuk; Nadätan? Anutu Kehäromi Mähemitä Lus yotpärare Kenan komeken bian ahäŋ namiŋpäŋ ŋode näwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Näkä nadäŋ gamiŋira äpetkaye nanakaye, äbekaye, oraŋkaye mäyap ahäŋ bumbum api täneŋ. Täŋpäkaŋ gäk äma mäyap täŋo nani pähap täŋiri äbotkayeta kome ŋo yämiŋira inita biŋam yäpmäŋpäŋ kome ŋo mähemi api täneŋ. Anututä ude näwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Näk Isip komeken nämo äbäŋira nanakayat Isip komeken ahäŋkumäno uwä näka biŋam! yäk. Efraim, Manase uwä nanaknayat Ruben kenta Simeontä it namikamän ude itdeŋta yäwani yäk. ");
INSERT INTO iou_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Täŋ äpetkaye nanakaye mäden ahänayäŋ täŋo unitä gäkŋata biŋam kaŋ täŋput yäk. Mäden ahänayäŋ täŋo uwä tuäni monäni yarä u wäpi terak kome mähemi api täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Näk Mesopotemia komeken naniktä äbäŋira Efrata yotpärare keräp taŋirän Kenan komekengän webena Reseltä kädet miŋin kumbuk. Kumäŋirän butewaki nadäŋpäŋ äneŋkut. (Apiŋowä Efrata yotpärare u wäpi Betlehem yäŋ iwet täkaŋ). ");
INSERT INTO iou_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Eruk Jekoptä Josep nanakiyat yabäŋpäŋ iwet yabäŋkuk; Ai! Nanak ŋo netä täŋo? ");
INSERT INTO iou_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yäwänä Joseptä nani iwetkuk; Nanaknayat kome ŋo irira Anututä namiŋkuko u yarä ŋobayäŋ yäk. Yäwänä Jekoptä yäŋkuk; Yepmaŋpi dubinaken äbänkaŋ kon man yäwera yäk. ");
INSERT INTO iou_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jekop tägawani täŋirän dapuri waŋkuŋo unita oraniyat ket nämo yabäŋpäŋ-nadäŋkuk. Ude täŋkaŋ Joseptä nanakiyat orani dubiniken yepmaŋirän bäyaŋ yämiŋpäŋ bumumiken yeŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ude täŋpäŋ Josep ŋode iwetkuk; Näk äneŋi nämo api gabäwet yäŋ nadäŋkuropäŋ Anututä nadäŋirän gäk nanakayatkät bok tabätat. ");
INSERT INTO iou_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ude iwerirän Joseptä nanakiyat orani bakäniken nanik pudätpäŋ yepmaŋpän irirän iŋami kome terak yäpän äpmoŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ude täŋpäŋ Jekop keri käpmäk käda nanaki monäni Efraim teŋkuk. Täŋpäŋ keri bure käda nanaki tuäni Manase teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Joseptä ude yepmaŋirän Jekoptä keri bure käda tuäni Manase gwäkiken penaŋipäŋ keri kowat irepmirän keri bure käda monäni Efraim gwäkiken peŋkuk. Peŋpäŋ keri käpmäk käda Manase gwäkiken peŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ude täŋpäŋ nanaki Josep kon man ŋode iwetkuk; Nana Aisak ba orana Abraham, Anututä yabäŋ yäwarirän iŋamiken kuŋatkumän. Anutu unitägän näka watäni itkukotä itak. Unitä nanak yarä ŋo kon täŋ yämän. ");
INSERT INTO iou_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Täŋkaŋ Aŋero, komi butewaki mebäri mebäri uken nanikpäŋ nämagutkuko unitä nanak yarä ŋo kon täŋ yämiŋirän näkŋo wäpnatä yarä ŋoniterak pat yäpmäŋ kuyon, ba nana Aisak, orana Abraham unitäŋo wäpitä bok. Anututä nadäŋ yämiŋirän nanak yarä ŋonitä nanak weŋbäyak täŋirän kome terak ahäŋ bumbum kaŋ täŋput. ");
INSERT INTO iou_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kon man ude yäŋ paorirän nanitä keri bure käda Efraim gwäkiken peŋkuko unita Joseptä kawän nämo tägawäpäŋ nani keri bure käda yäpmäŋkaŋ Efraim gwäkiken nanik Manase gwäkiken pewayäŋ yäpuk. ");
INSERT INTO iou_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ude täŋpäŋ yäŋkuk; Nan! Ude nämo. Nanak ŋonitä intäjukun nanik unita ketka bure käda ŋo tuä gwäkiken pe! ");
INSERT INTO iou_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Yäwänä Jekoptä Josep täŋo man utpäŋ yäŋkuk; Näk nadäwa tärewäkaŋ ude täyat yäk. Manase u äma wäpi biŋam ikek itpäŋ kuŋarirän oraniye mäyap api ahäneŋ. Upäŋkaŋ monänitä irepmitpäŋ nanakiye oraniye äma äbot pähap täŋpäŋ api itneŋ. ");
INSERT INTO iou_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ude yäŋpäŋ kepma ugän kon man äneŋi kubä ŋode yäkgän täŋkuk; Kämi-kämi Isrel ämawebetä äma kubä kon man iwerayäŋ nadäŋpäŋä ek wäpjek terak wohutpäŋ ŋode api yäneŋ; Anututä Efraim Manase täŋkentäŋ yämiŋkuko gäk udegän täŋ gamiton! Jekoptä ude yäŋpäŋ monäni Efraim intäjukun peŋpäŋ tuäni Manase mäden teŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Jekoptä ude täŋpäŋ nanaki Josep ŋode iwetkuk; Nadätan? Näk kumbayäŋ täyat upäŋkaŋ Anututä gäkkät itpäŋ kämiwä tämagut yäpmäŋ orajiyetä kome kujatken äneŋi api kwek yäk. ");
INSERT INTO iou_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Täŋpäkaŋ Amo ämawebe äbot däpmäŋpäŋ yäwat kireŋpäŋ komeni wäpi Sekem yäyomägatkuro u notkaye ätuta biŋam nämo, gäka biŋam ganiŋ kiretat yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jekop nanakiye yäŋpäbä kubäkengän yepmaŋpäŋ imaka kämi ahäŋ yämayäŋ täŋkuko u kudup ŋode yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nanaknaye, in ket nadäwut! Nanjin näkä man täwerayäŋ täyat u yäpmäŋpäŋ nadäk-nadäkjin-ken pekot. ");
INSERT INTO iou_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Eruk, nanakna tuäna Ruben, gabäŋpäŋ kehäromtak täyat! Näk gubaŋi itkaŋ intäjukun gäk bäyaŋkut. Bäyawakaŋ ämawebetä nabäŋirä näk äma bureni kehäromina nikek ahäŋkut. Gäkŋo kehäromikatä notkaye ätu yärepmit morek täyak. ");
INSERT INTO iou_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Upäŋkaŋ gäkŋo irit kuŋat-kuŋat uwä umetä wakiinik tokätpäŋ päna täk täyak udewani. Gäk näka nämo nadäŋ namiŋpäŋ watä webena kubä yäŋikŋatpäŋ däpmon bok patkumäno unita näk mäyäk nadäŋkut. Mebäri unita gäk notkaye täŋo intäjukun äma nämoinik api iren yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Jekoptä Ruben man ude iwet moreŋpäŋ eruk nanakiyat Simeon kenta Livai ŋode yäwetkuk; Ek mebärijek kubägän. Ek ämik täŋo tuŋum yäpmäŋ kuŋatpäŋ ämik täk täkamän. ");
INSERT INTO iou_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Unita näk ekkät itpäŋ-nadäk penta täga nämo täne yäk. Ek äma däpmäkta man yäŋpäŋ-nadäk täkamän unita. Ek kokwawak täŋpäŋ äma bäräŋek däpmäk täkamän. Ba gäripita tom päriki jop-nadäŋ däpmäŋ tokät täkamän yäk. Kädet wakiwaki udewani täk täkamän. ");
INSERT INTO iou_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ek kokwawak wakiinik nadäŋpäŋ täŋpeŋ kuŋat täkamän unita injek terak bäräpi ŋode api kotadeŋ; Näkä ek ba nanak pewän ahänayäŋ täkaŋ u täwat kireŋpewa päŋku Isrel äma äbot ätu gänaŋ kubäkubä api ittäŋ kuneŋ. Äbot kubägän nämo api itneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jekoptä man ude yäwetpäŋ nanaki Juda ŋode iwetkuk; Juda, notkayetä wäpka biŋam yäpmäŋ akuŋpäŋ punin api peneŋ yäk. Ba iwankayetä gutna yäŋkaŋ api täŋburut täneŋ. Täŋirä gäkägän yepmäŋitpäŋ ureŋ täŋpi kuk api täŋpen. Gäk ude täŋiri notkayetä api gwäjiŋ äpmoŋ gamineŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Gäk laion gubaŋi udewani. Laion u kepma tom däpmäŋ naŋtäŋ kuŋattäŋgän kome bipmäŋirän äneŋi äyäŋutpeŋ däpmon patpat bägupken kuŋkaŋ parirän tom kubätä äbä täga nämo täŋikŋareko udegän ämawebe kudup gäka api umuntak täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juda, gäkŋo äbotken nanik äma yabäŋ yäwat piä täkta api ahäŋ yäpmäŋ kuneŋ. Bureni, oraŋkaye ahänayäŋ täkaŋ unitä intäjukun äma ude itkaŋ yabäŋ yäwat piä täŋirä äma äbot komeni komenitä äbä gwäjiŋ äpmoŋ yämiŋpäŋ tuŋum api buŋät yämik täneŋ. ");
INSERT INTO iou_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Juda uwä wäpi biŋam ikek it täyak. Unitäŋo wain piäni taŋi pähap unita doŋkinatä bureni näneŋ yäŋ yäŋpäŋ nadäwätäk nämo täŋkaŋ wain päya terakgän topmäk täyak. Ba äma jopitä tek umepäŋ ärut täkaŋ ude nämo. Äma unitä moneŋ ikek unita wain umenigänpäŋ tek ärut täyak. ");
INSERT INTO iou_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Umeta iwäwä wain umenigänpäŋ näŋtäyon dapuri gämänek täyak. Ba bulimakau nonoŋi täkätpäŋ nak täyak unita meni kujat kuräki pakiinik täk täkaŋ. Bureni! Juda uwä jäwäri nämo, äma ini pärik kubä api irek. ");
INSERT INTO iou_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Eruk, Jekoptä Judata man ude yäŋpäŋ nanaki Sebulun ŋode iwetkuk; Sebulun, gäk gwägu taŋi gägäniken api iren yäk. Kome irayäŋ täyan u säkgämän, gäpe taŋi taŋitä äbä täga itneŋ yäk. Gwägu pomi terak gäkä irayäŋ täyanken unitä päŋku Saidon kome unitäŋo kome mähemi ude api iren yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ude yäŋpäŋ nanaki Isaka ŋode iwetkuk; Isaka, gäkäwä doŋki kehäromi kubä. Tuŋum bäräpi bäräpi mädeka terak peŋirä kädet kuŋatta bitnäŋpäŋ jop uken maŋit itan yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Upäŋkaŋ komeka ba irit bägup täga kubä kaŋpäŋ piä täga täŋpen. Äma täŋo watä piä äma ude api täk täŋpen yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Jekoptä Isaka man ude iwetpäŋ nanaki Dan ŋode iwetkuk; Dan, gähäwä intäjukun ämatä itkaŋ ämawebe äbotkaye api yabäŋ yäwaren, notkayetä iniken äboriye yabäŋ yäwat täkaŋ ude yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Nanakna, ude irayäŋ täyan upäŋkaŋ gäk gämok komi kubä, kädet jämjäm pärani ude api iren. Gämok jäjäm irirä hos kubätä äbänä mämekiken iŋpewän hostä kikŋutpäŋ äma uterak maŋirani u api kwarut maŋpän kuneŋ. Gäk udewani yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jekoptä man ude yäŋ moreŋpäŋ ŋode yäŋkuk; Yawe, gäkŋo täŋkentäk piä kehäromi nikek ahäwayäŋ täko unita itsämäŋtat! yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Eruk ude yäŋpäŋ nanaki Gat ŋode iwetkuk; Kadäni ätuken kubo äma ätutä gäk ba äbotkayekät ämik api pewä ahäk täneŋ yäk. Upäŋkaŋä in kehärom taŋpäŋ api yäwat kirek täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ude yäŋpäŋ yäŋkuk; Nanakna Ase, gähäwä kome tägaken itkaŋ piä täŋpayäŋ täyan u ketem tägatäga ahäŋ bumbum api täneŋ yäk. Ketem ahänayäŋ täkaŋ uwä säkgämän, äma wäpi nikektä yabäŋgärip täŋpäŋ api nak täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ude yäŋpäŋ nanaki Naptali iwetkuk; Gäk meme ägwäri bumik. Uwä iniken gäripi terak kuŋatkaŋ nanak säkgämän bäyak täkaŋ udewani yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jekop ude yäŋpäŋ eruk nanaki Josep ŋode iwetkuk; Josep, gäk wain päya täga mujipi bumta pewä wädäk täkaŋ udewani yäk. Päya uwä ume gägäniken itkaŋ kubirigän äroŋirän momitä bumta iriŋ wädäk täyak. ");
INSERT INTO iou_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gäk ittäŋ kuŋariri äma komi gäka kokwawak nadäŋpäŋ gabäŋ ahäŋpäŋ äpatä gamneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Täŋirä gäkä ehutpäŋ äpa gwäjiŋpäŋ pära nämo api yamben yäk. Ketka kujat kehäromi täŋpayäŋ täko uwä nanka Jekop täŋo Anutu kehäromi mähemi, unitä täŋkentäŋ gamiŋirän kehäromi nikek api iren yäk. Anutu uwä Isrel täŋo Watä Pähap ba Isrel täŋo Mobä Kujat, unitäŋo kehäromitä api täŋkentäŋ gamek yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Bureni, nanka täŋo Anutu unitägän täŋkentäŋ gamik täyak. Anutu kehäromi mähemi uwä iron mebäri mebäri ŋode pewän ahäŋ gamik täkaŋ; Iwän punin nanik ba ume kome gänaŋ nanik, ba nanakaye mäyap, ba yawakaye imaka mäyap. Iron ude pewän ahäŋ gamik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nanka näkŋo kon man terak iron ahäŋ gamayäŋ täyak uwä buŋät yäpmäŋ ärok täyon pom biani biani u kaŋ yärepmirän. Ba iron u imaka säkgämän oranayetä bian yäpuŋo u imaka, kaŋ yärepmirän yäk. Täŋpäŋ Josep, gäk yäpmäŋ daniŋpäŋ notkaye yärepmitpäŋ wäpka biŋam ikek itan unita iron pähap yäyat ŋo gäka terak kaŋ äroŋ morewut yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Jekoptä Josep man ude iwetpäŋ nanaki Benjamin ŋode iwetkuk; Gäk aŋ komi tom däpmäŋpäŋ näŋpani kubä udewani yäk. Tamimaŋä tom ätu däpmäŋpäŋ pengän kudup nak täyak. Täŋpäŋ bipäda ätu däpmäŋpäŋ naŋkaŋ ätu däkumta pek täyak. ");
INSERT INTO iou_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Eruk, Jekop täŋo nanakiye uwä ini äbot-äbot ittäŋ kuŋkuŋo u Isrel kome täŋo äma äbot 12 udetä itkuŋ. Jekop nanakiye 12 u kubäkubä täŋo mebäriniye yabäŋpäŋ-nadäk täŋpäŋ uterakgän kon man yäwetkuko u äbä täretak ŋo. ");
INSERT INTO iou_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Jekop nanakiye man ude yäwet paotpäŋä ini kumäkta manbiŋam ŋode yäwetkuk; Näk kumbani notnayetä itkaŋken u kukta keräp täyak yäŋ nadätat. Näk kumäŋira kome nanaye oranaye äneŋkuŋken kaŋ äneŋput yäk. Kome u Kenan komeken, kome täpuri wäpi Makpela, Mamre kome edap abani käda uken itak yäk. U äma Hit nanik wäpi Efron unitäŋo piä tobät gägäniken itak, kome orana Abrahamtä ini ba äboriye äneneŋta suwaŋkuko u yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kome uken äbekna orana Abraham yanäpi äneŋkuŋ. Täŋpäŋ meŋna nana Aisak yanäpi pähap u imaka ugän äneŋkuŋ. Webena Lea imaka u äneŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kome ba awaŋ uwä Abrahamtä Hit nanik täŋopäŋ suwaŋkuk. Näk u kaŋ äneŋput. ");
INSERT INTO iou_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Eruk Jekop nanakiye man ude yäwet moreŋpäŋ patpäŋä eruk kuroŋi mugwäjiŋpäŋ waki kumbuk. ");
INSERT INTO iou_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Eruk nani kumbuko parirän Josep nani bäyaŋ imiŋpäŋ konäm butewaki täŋpäŋ iŋamiken iŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ude täŋpäŋ itkaŋ eruk mäden Josep nani täŋo komegup bäräŋeŋ nämo paraŋpäŋ kehäromigän pen irekta yäŋpäŋ Isip täŋo äma nadäwani ätu ŋode yäwetkuk; In imaka käbäŋi säkgämän nikek u yäpmäŋ päbä nana gupi terak ŋo kaŋ ärut imut yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ude yäweränä äma u Isip äma ätutä kumäŋirä täk täŋkuŋo u Jekoptä kumbänä udegän gupiken ärut imik täŋ yäpmäŋ kuŋ irirä kepma 40 ude täreŋkuk. Eruk ude täŋ moreŋpäŋ Isip nanik ämawebe Jekopta konäm butewaki täŋ yäpmäŋ kuŋirä kepma 70 ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Konäm butewaki täŋ yäpmäŋ kwä täreŋirän Joseptä Fero täŋo watä piä ämaniye ŋode yäwetkuk; In näka gäripi nadäkaŋ u täŋpäwä man yäyat ŋo yäpmäŋ päŋku Fero ŋode iwerut; ");
INSERT INTO iou_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Nana täŋo kumäk-kumäki kadäni keräp taŋirän man kehäromi kubä ŋode näweränpäŋ yäŋkehärom taŋkut; Näkä kumbawä Kenan komeken kome muni kubä näkŋa kumäŋira äneneŋta suwaŋkutken ukengän kaŋ äneŋ yäk. Nana ude näwetkuko unita Fero gäk nepmaŋpi päŋku nana kome uken äneŋkaŋ äneŋi äyäŋutpeŋ ŋo api äbet yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ude yäŋirän Ferotä nadäŋpäŋ kowata man Josepken ŋode tewän kuŋkuk; Gäk päŋku nankatä man gäwerirän yäŋkehärom taŋkuno udegän täŋkaŋ äneŋi kaŋ äbi yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ude iwerirän Josep päŋku nani Kenan kome uken äneŋkuk. Jekop änekta kuŋkuŋo u Fero täŋo äma wäpi nikek ba äma ekäni ekäni ba Isip kome täŋo intäjukun äma kuduptagän Josepkät bok kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Josep webeni nanakiye ba noriye kuduptagän ba Jekop täŋo äboriye kuduptagän kuŋkuŋ. Iroŋi täpuri täpuri ukät sipsip, bulimakau unitägän Gosen kome uken itkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Täŋä äma ätu karis hostä wädäwani uterak ba hos terak Josepkät penta kuŋkuŋ. Äma äbot kuŋkuŋo u kubägän nämo. Ämawebe bumta akuŋ kireŋkaŋ Jekop änekta kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Eruk kuŋtäŋgän Atat kome wit gupi tätuwani bägupken Jodan ume ani kukŋi udude uken ahäŋkuŋ. Eruk uken ahäŋpäŋä konäm butewaki pähap täŋkuŋ. Ude täŋpäŋ itkaŋ Josep u täŋbute-bute täŋpäŋ konäm butewaki täŋ yäpmäŋ kuŋirän kepma 7 ude täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Konäm butewaki täŋ irirä Kenan ämawebetä yabäŋpäŋ man ŋode yäŋkuŋ; U yabäwut! Isip naniktä konäm butewaki taŋi pähap, kadäni käroŋi täŋ yäpmäŋ äbäkaŋ yäk. Ude yäŋkuŋo unita kome u wäpi Abel-Misraim yäŋ yäk täkaŋ. Wäpi u mebäri Isip nanik täŋo butewaki pähap. ");
INSERT INTO iou_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Jekop nanakiye ude täŋkuŋo uwä nani täŋo man buramiŋpäŋ Kenan kome uken äneŋkuŋ. Kome nani äneŋkuŋken u wäpi Makpela, Mamre kome dubiniken, kome Abrahamtä bian äma kubä Hit nanik wäpi Efron unita moneŋ imiŋpäŋ kome u inita yäpukken u. ");
INSERT INTO iou_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Täŋpäkaŋ Josep nani Jekop u äneŋpäŋ yejämäŋpäŋ peŋkaŋ mäden nanakiye, noriye, wanoriye, piä ämaniye bok kuŋkuŋo u kudup äneŋi äyäŋutpeŋ Isip komeken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Eruk nani äneŋpeŋ äbä komeniken itkaŋ noriyetä yäŋkuŋ; Eruk apiŋo jide itkamäŋ? Josep ninta kokwawak pen nadäŋpäŋ yäwänäku imaka goret täŋ imiŋkumäŋo unita kowata udegän täŋ nimitek yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ude yäŋpäŋ man ŋode pewä yäpmäŋ Josepken kuŋkuk; Kadäni nanka nämo kumäŋkaŋ man ŋode niwetkuk; ");
INSERT INTO iou_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","In goret täŋkuŋ. Notjinpak Josepta waki täŋ imiŋkuŋo unita Josepken päŋku ŋode iwerut; Ninä waki täŋ gamiŋkumäŋo unita kowata nämo täŋ nimen. Momi täŋkumäŋo u peŋ nimisi yäk. Unita Josep, nin nanka täŋo Anutu unitäŋo piä ämaniyetä ŋode gäwetkamäŋ; Nantä man ude niwetkuko unita butewaki nadäŋ nimiŋpäŋ mominin nämo yäpmäŋ kuŋaren yäk. Yäŋirä Joseptä nadäŋpäŋ konäm kotkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Josep ude täŋirän noriye dubiniken äbäŋpäŋ iŋami yäpä äpmoŋpäŋ patkaŋ ŋode iwetkuŋ; Nin apiŋo gäkŋo watä piä äma ude itkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yäŋirä Joseptä yäwetkuk; In näka umuntäneŋtawä yäk. Näk Anutu täŋo bägup yäpmäŋpäŋ Anutu bumik täga nämo iret. ");
INSERT INTO iou_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","In bian näk yäpäwakta man yäŋpäŋ-nadäk täŋkuŋo upäŋkaŋ Anututä waki u yäpmäŋ äyäŋutpäŋ imaka täga kubä ŋode pewän ahäŋkuk; Ämawebe mäyaptä nakta jop itpäŋ kumnaŋi upäŋkaŋ Anututä intäŋo waki yäpmäŋ äyäŋutpäŋ näkä terak täŋkentäk pähap pewän ahäŋirän näkä in täŋkentäŋ tamitat ŋo. ");
INSERT INTO iou_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Unita in nadäwätäk täneŋtawä. Näk täŋkentäŋ tamiŋira in ba nanakjiye täga api itneŋ yäk. Josep noriye man säkgämän ude yäwettäyon noriye umun pähap nadäŋkuŋo u paotkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Eruk Josep täŋo kumäk-kumäki kadäni keräp taŋirän Jekop täŋo äboriye ukät Isip kome it yäpmäŋ kuŋirän obaŋ 110 täreŋirän kumbuk. Unitäŋo manbiŋam ŋode; ");
INSERT INTO iou_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Josep nämo kumäŋkaŋ nanaki monäni wäpi Efraim unitäŋo nanakiye oraniye yabäŋkuk. Ba kodak irirän nanaki tuäni wäpi Manase unitä nanaki kubä wäpi Maki bäyaŋkuk. Eruk Maki unitäŋo nanakiye ahäŋirä Joseptä inita iwoyäŋpäŋ watäni it yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Eruk Joseptä kumbayäŋ nadäŋkaŋ noriye yäŋpäbä yepmaŋpäŋ ŋode yäwetkuk; Eruk näk kumbayäŋ täropäŋkaŋ Anututä ini inta watä api it tamek yäk. Täŋpäŋ in yäŋ-täkŋat yäpmäŋ kome ŋo kakätäŋpeŋ kome kubäken api tepmaŋpek. Kome u Anututä Abraham, Aisak kenta Jekopta bureni api tamet yäŋ yäwetkukken u api yäŋ-täkŋat päŋku api tepmaŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Man ude yäŋpäŋ noriye ŋode yäwetkuk; In ŋode täneŋta yäŋkehärom tawut. Anututä tämagurirän Isip kome ŋo peŋpeŋ kunayäŋ täŋpäŋä näk kumbayäŋ täro u näkŋo kujatna imaka, yäpmäŋkaŋ kaŋ kut yäk. Ude yäwerirän yäŋkehärom taŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Täŋpäkaŋ Josep obaŋ 110 täreŋirän Isip komeken kumbuk. Kumbänkaŋ Isip nanik täŋo äma nadäwani ätutä komegup nämo parawekta imaka käbäŋi täga nikek gupi terak ärutkaŋ bokis gänaŋ peŋpäŋ äneŋkuŋ.");
INSERT INTO iou_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Bian yäpmäŋ daniwani ämatä Isrel ämawebe yabäŋ yäwat täŋkuŋo kadäni ugän ketemta jop itkuŋ. Irirä äma kubä wäpi Elimelek, Efrata äbotken nanik Betlehem yotpärare Juda komeken it täŋkuko unitä webeni Naomikät nanakiyat Malon kenta Kilion yämaguränkaŋ Moap komeken itpäŋ-nadäkta kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Päŋku ittäŋgän Elimelek kumbänkaŋ webeni Naomi nanakiyat ukät itkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Itkaŋ nanak yarä u webe yarä Moap komeken nanik wäpi Opa kenta Rutpäŋ yäpumän. Yäpmäŋpäŋ itkaŋ obaŋ 10 täreŋirän Malon kenta Kilion bok kumäŋirän Naomi inigän, äpi nanakiye nämotä itkuk. ");
INSERT INTO iou_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi ittäŋgän nadäŋkuk; Juda komeken Yawetä ämawebeniye täŋkentäŋ yämikta täŋ-bumbum pewän ahäkaŋ yäŋ nadäŋpäŋ äbekiyat yäwerän bok kukta tuŋum täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Täŋpäŋ äbekiyatkät kome it täŋkuŋo u peŋpeŋ Juda kädet moräki yäput peŋpäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Kuŋtäŋgän Naomitä äbekiyat ŋode yäwetkuk; Ektä näk ba äpjekyat kumbumäno unita watä it nimik täŋkumäno udegän Yawetä ekta watä it tamiŋirän päŋku meŋjekyat-kät irun. ");
INSERT INTO iou_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Täŋpäŋ Yawetä täŋkentäŋ tamiŋirän äma yarä äneŋi kaŋ yäpmäŋkaŋ irun. Ude yäwetpäŋ kowat bäyaŋ imän täŋpäŋ konäm bumta kotkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Konäm kotpäŋ ŋode iwetkumän; Ude nämo! Nek gäkkät mähemkayeken u bok api kune yäk. ");
INSERT INTO iou_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ude yäwänä Naomitä äneŋi yäwetgän täŋkuk; Äbeknayat, äyäŋutpeŋ notjiyeken kun. Mebäri imata näk näwatta nadäkamän? Näkä jide täŋpäŋ nanak ätu bäyawakaŋ api yäpdeŋ? ");
INSERT INTO iou_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Ude täga nämo. Näk webe pähap täyat. Äma äneŋi täga nämo api yäpet unita kun. Ba äma apiŋogän yäpmäŋpäŋ nanak pengän bäyawero u yäpmäkta kadäni käroŋi täga nämo itsämdeŋ. Kadäni käroŋi irän wawäpäŋ äma ätupäŋ yäpdeŋ yäŋ nadätat. Äbeknayat, butewaki pähap. Yawetä mäde ut namitak unita butewaki ärowani nadäŋ tamitat. ");
INSERT INTO iou_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ude yäweränä Rut kenta Opa konäm äneŋi kotkumän. Kotpäŋ Opa äbeki bäyaŋ imiŋpäŋ teŋpeŋ kuŋirän Rut kukta bänepi bitnäkinik täŋpäŋ Naomikät itta nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Ude täŋpänä Naomitä Rut iwetkuk; U ka! Gwaräpka noriyeken ba anutuniyeken kuyak. U iwat yäk. ");
INSERT INTO iou_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ude yäwänä Ruttä iwetkuk; Nämo, näk gäkkät bok kudayäŋ. Näkä gäk gepmaŋpeŋ kukta man näwereno. Gäkä deken kwayäŋ täno u näk bok api kude yäk. Gäk de irayäŋ täno u bok api itde. Gäkŋo notkaye u näkŋo notnaye ude api itneŋ. Ba gäkŋo Anutu u imaka, näkŋo Anutu ude api irek. ");
INSERT INTO iou_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gäkä kome deken kumbipäŋ änenayäŋ täŋo uwä näk kome ugän api äneneŋ. Imaka kubätä nek bämopnekken madäŋ täkŋewektawä. Kumäk-kumäk kubä-tägän api madäŋ täkŋewek. Bureni-inik yäyat. Näkä man yäyat ŋo kudup nämo iwarawä Yawetä kowata wakiinik kaŋ namän. ");
INSERT INTO iou_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomitä Rut man kehäromi ude yäŋirän nadäŋpäŋ teŋpäŋ kukta man kubä äneŋi nämo yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ude täŋpäŋ bok kumaŋ Betlehem yotpärareken kuŋkumän. Eruk kumaŋ Betlehem yotpärareken ahäŋirän kome u nanik webetä bumta kikŋutpäŋ yäŋkuŋ; Ŋo Naomi ini ba? ");
INSERT INTO iou_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ude yäwäwä Naomitä yäwetkuk; Wäpna Naomi yäŋ nämo näwetneŋ. Unitäŋo mebäri uwä säkgämän. Upäŋkaŋ kehäromi mähemitä mäde ut namiŋkuko unita wäpna säkgämän yäŋ nämo näwetneŋo. Mara yäŋ näwerut. Unitäŋo mebäri jägämi yäk. ");
INSERT INTO iou_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Kome ŋo peŋpeŋ kuŋkuro ugänä tuŋum webe bumiktä kuŋkut. Upäŋkaŋ apiŋo Yawetä jopi jäwäriinik irira nämagut yäpmäŋ äbätak. Ude täŋirän mebäri imata Naomi, webe säkgämän yäŋ näwetneŋ. Kehäromi mähemi unitä yäŋpewän näk wakinik täŋkut. ");
INSERT INTO iou_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Eruk, manbiŋam ŋo Naomitä äbeki Rut Moap komeken nanik imaguränkaŋ Moap kome peŋpeŋ Betlehem yotpärareken wit madäk-madäk kadäniken ahäŋkumäno unitäŋo manbiŋam. ");
INSERT INTO iou_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Betlehem kome uken Naomi äpi kumbuko unitäŋo nägät moräk kubä wäpi Boas unitä itkuk. Boas uwä Elimelektä äbotken nanik, äma ekäni kubä, tuŋum äma. ");
INSERT INTO iou_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Täŋpäkaŋ kepma kubä Ruttä äbeki Naomi ŋode iwetkuk; Nadäŋ namiŋiri äma kubätä piäken kuŋkaŋ piä äma wit madäŋtäŋ kuŋirä ätu jop mäŋpani u kaŋ yäpa yäk. Äma kubätä nadäŋ namänä unitä piäken api täŋpet yäk. Ruttä ude iweränä Naomitä iwetkuk; Äbekna, yäyan ude tä yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ude yäwänä eruk Rut piä kubäken kuŋpäŋ piä ämatä wit madäŋtäŋ kuŋirä mäŋpani u yäpmäŋtäŋ yäwatkuk. Piä ude täŋkuko uwä Boas, Elimelek täŋo nägät moräk kubä unitä piäken täŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Piä täŋ irirän Boas Betlehem yotpärare peŋpeŋ piäniken äbäŋpäŋ piä ämaniye yabäŋpäŋ ŋode yäwetkuk; Yawetä inkät iton. Ude yäwänä kowata ŋode iwetkuŋ; Yawetä kon täŋ gamiton yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Täŋpäŋ Boastä piä äma täŋo intäjukun äma ŋode iwet yabäŋkuk; Webe gubaŋi u netätä äbotken nanik? ");
INSERT INTO iou_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Yäwänä iwetkuk; U kome kubäken nanik, äbeki Naomikät Moap komeken naniktä äbumän yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Webe unitä ŋode näwerak; Nadäŋ namiŋiri piä ämakaye yäwarän täŋpäŋ wit pewä mäŋpani kaŋ yäpa yäŋ näwerak. Ude näweränpäŋ täga yäwapäŋ piä tamimaŋ yäput peŋpäŋ täŋ yäpmäŋ äbäko apiŋogän itpäŋ-nadäk täyak u yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ude iweränkaŋ Boastä päŋku Rut iwetkuk; Äpetna, man kubä gäwera nadä yäk. Äma kubätä piäken wit yäpmäkta kwentawä. Näkä piäken ŋogän webe kwayak ŋokät kaŋ täk täŋput. ");
INSERT INTO iou_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Webe u wit madäŋirä yabäŋkaŋ ugän yäwarän täk täyi. Nadätan? Näk piä ämanaye gäk waki nämo täŋ gamineŋta yäjiwät man uku yäwerat. Täŋpäŋ umeta gewäwä ume käbotken gwetpäŋ peŋo u täga api näŋpen yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Boastä ude iweränä Ruttä Boas dubiniken iŋami kome terak yäpän äpmoŋpäpäŋ iwetkuk; Näk kome kubäken nanikpäŋ mebäri imata nadäŋ namiŋpäŋ oraŋ namitan? ");
INSERT INTO iou_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ude iweränä Boastä ŋode iwetkuk; Äpkatä kumäŋirän äbekka Naomita täŋkentäk mebäri mebäri täŋ imiŋkuno unitäŋo manbiŋam yäŋirä kudup nadäŋkut. Gäk kome kujatka ba meŋkaye nankaye yepmaŋpeŋ äbot kudupi gänaŋ itta äbuno u nadäŋ gamitat. ");
INSERT INTO iou_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Unita Yawe, Isrel täŋo Anututä watä it gamekta dubiniken äbuno unitä imaka täga täŋkuno unita gwäki tägagämän kubä gamiton. ");
INSERT INTO iou_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ude yäwänä Ruttä ŋode iwetkuk; O intäjukun ämana, näk piä watä webekayetä itkaŋ ude nämo itat upäŋkaŋ oraŋ namiŋpäŋ man kwini näweriri bänepna pidäm täyak yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Täŋpäkaŋ ketem naknak kadäniken Boastä Rut ŋode iwetgän täŋkuk; Äbä käräga kubä yäpmäŋpäŋ wain ume gänaŋ yäputpäŋ naŋ. Ude iweränä Ruttä wit madäwani ämawebekät bok maŋitkuŋ. Maŋit irirän Boastä wit mujipi ijiŋkuko u imän naŋpäŋ koki täŋpäpäŋ moräki pewän itkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Ketem naŋ paotpäŋ akumaŋ päŋku wit mäŋpani äneŋi butuŋkuk. Ude täŋ irirän Boastä piä ämani ŋode iwetkuk; Nadäŋ imiŋirä nämo yäpnaŋiken, wit pädä täwani bämopiken mäŋpani kaŋ yäpän. Ba ugän nämo, madäk-madäk kadäniken ätu yäpmäŋ däkŋeŋpäŋ pewä maŋ imiŋirä kaŋ yäpän. Ude täŋirän nämo ibeneŋ. ");
INSERT INTO iou_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Täŋpäkaŋ Rut piä täŋ yäpmäŋ kuŋtäyon edap dapuri äpmoŋkuk. Ude täŋpäŋ wit kujari yäpuko u däpmäŋ-pewä bureni täreŋirä taŋi, 10 kilos ude ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ude täŋpäŋ yäpmäŋ päŋku wit bureni yäpuko ukät ketem naŋkaŋ moräki peŋkuko u äbeki Naomi iwoŋäreŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Iwoŋäreŋirän Naomitä Rut ŋode iwetkuk; Yäke, gäk netä piäken piä täŋpäŋ wit ŋo yäpmäŋ äbätan? Anututä äma nadäŋ gamiko u säkgämän täŋ imiton. Ude yäwänä Ruttä iwetkuk; Näk piä uwä äma kubä wäpi Boas unitä piäken tät yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ude iweränä Naomitä yäŋkuk; Yawetä Boas kon täŋ imiton! Yawe uwä äma kumbani ba kodak irani watäni itta yäŋkehäromtak man yäwani u nämo irepmit täyak. Ude yäŋpäŋ ŋode iwetgän täŋkuk; Nadätan? Äma uwä nintäŋo nägät moräk bureni, watä it nimikta yäwani yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Yäwänä Ruttä iwetkuk; Äneŋi man täga kubä ŋode näwetkuk yäk. Gäk piä watä webenayekät itpäŋ piä täŋ yäpmäŋ kuŋiri wit madäk-madäk kadäni kaŋ tärewän. ");
INSERT INTO iou_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ude iweränä Naomitä ŋode iwetkuk; Äbekna, u täga gäwerak yäk. Piä watä webeniyekät piä tänayäŋ täŋo u tägagämän. Kubätä piäken kweno uwä piä ämaniyetä waki täŋ gamineŋ! yäk. ");
INSERT INTO iou_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Täŋpäkaŋ Ruttä Boas täŋo piä webeniyekät piä täŋ yäpmäŋ kuŋirä wit madäk-madäk kadäni täreŋkuk. Täreŋirän äbekikät pen it yäpmäŋ äroŋkumän. ");
INSERT INTO iou_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Eruk ittäŋgän Naomitä äbeki Rut ŋode iwetkuk; Gäkä säkgämän irenta äma kubä kaŋ-ahäŋ gaminaŋi yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ŋode nadäsi; Boas, watä piä webeniye piä bok täŋkuŋo u nägät moräknin yäk. U apiŋo bipäda wit bureni yäpmäkta kujari madäŋkuŋo u däpmäŋ käkärayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Unita gäk ume ärutpäŋ tek säkgämän täŋkaŋ imaka käbäŋi nikek gupka terak ärutpäŋ Boastä piä täŋpayäŋ täyakken kuŋpäŋ iŋamiken kwawak nämo ahäŋ imen. Nämo, käbop iriri unitä epän täŋpän tärewäpäŋ ketem ume kaŋ naŋ paorän. ");
INSERT INTO iou_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Täŋkaŋ däpmon pärayäŋ täŋirän unitä pärayäŋ täko u ket kaŋ kaŋpäŋ nadä. Täŋpäŋ däpmon patguŋ taŋirän päŋku tek ämet pärayäŋ täko u yäpmäŋ akuŋpäŋ kuroŋi käda kaŋ pat. Pariri unitä kikŋutpäŋ imaka gäkä tänaŋi u api gäwerek. ");
INSERT INTO iou_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Naomitä ude iweränä Ruttä iwetkuk; Täga, näwetan ude api täŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ude yäŋkaŋ Ruttä wit däpmäŋ käkärani bägupken päŋku äbekitä piä man iwetkuko u kudup täŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas ketem ume naŋpäŋ bänep oretoret terak itpäŋä däpmonta iŋpewä päŋku wit bureni änok itkuŋken u patkuk. Parirän Rut yeŋ-yeŋ päŋku Boas täŋo tek yäpmäŋ akuŋpäŋ kuroŋiken patkuk. ");
INSERT INTO iou_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ude parirän Boas bipani bämopiinik kikŋutpäŋ äyäŋutpäŋ kaŋkuk; Webe kubä kuroŋi käda parirän! ");
INSERT INTO iou_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Kaŋpäŋ iwetkuk; Gäk netä? yäk. Yäwänä iwetkuk; Näk Rut, piä webeka yäk. Gäk Elimelek täŋo nägät moräk, näk watä it namikta yäwani. Unita näk webekata kaŋ nämagut yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ude iweränä Boastä ŋode iwetkuk; Äpetna, Yawetä kon täŋ gamiton! Kudän täyan ŋo imaka täga äbekkata täŋ imiŋkuno u irepmitpäŋ täyan. Äma gubaŋi, tuŋum ikek ba tuŋumi nämo u kubä täga yäpnaŋi upäŋkaŋ nämo, äbekka täŋo nägät moräk näkken äbätan. ");
INSERT INTO iou_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Unita äpetna, umuntäwentawä. Imaka kubäta näwet yabäwayäŋ täyan uwä api täŋkentäŋ gamet yäk. U imata, yotpärare ŋo nanik kudup u mebärika nadäkaŋ. Gäk webe täga. ");
INSERT INTO iou_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Täŋpäkaŋ näkä gäk watä it gamikta yäwani yäŋ näwetan u man bureni upäŋkaŋ näk gägäni bumik. Nägät moräk bureniwä äma kubä itak. ");
INSERT INTO iou_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Unita ŋo pariri kome yäŋewänkaŋ näkä tami päŋku äma u iwet yabäwa gäka watä itta täga yäwänä täga. Täŋ täga nämo yäwänä eruk, näkŋa watäka api it gamet. Yawe irit mähemi u wäpi terak ude yäŋkehärom täyat. Eruk päsi yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ude täŋpäŋ Boas kuroŋiken parirän kome yäŋeŋ buruburu täŋirän akwänkaŋ Boastä iwetkuk; Ämawebetä gäk ŋo päran yäŋ nadäneŋo unita kome ket nämo yäŋeŋirän kuyi yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Kwayäŋ täŋirän Boastä ŋode iwetgän täŋkuk; Tekka punin nanik yäŋopmäŋpäŋ ŋo iri yäk. Iwerän ude täŋpänä wit bureni tek terak äreŋpän kuŋirän 20 kilos ude täŋkuk. Täŋpänkaŋ Rut täŋkentäŋpäŋ wit uwäk u pudätpäŋ piri terak peŋkuk. Piri terak pewänkaŋ yotpärareken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Kumaŋ päŋku Naomi ahäŋ imiŋirän äbeki u ŋode iwet yabäŋkuk; Äbekna, kädet jide ahäŋ gamik? yäk. Ude iweränä Ruttä imaka Boastä täŋ imiŋkuko u kudup iwetkuk. ");
INSERT INTO iou_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Iwetpäŋ yäŋkuk; Äma unitä äbekkaken ketäŋ täga nämo kwen yäŋ näwetpäŋ wit ŋo namän yäpmäŋ äbätat yäk. ");
INSERT INTO iou_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ude iweränä Naomitä iwetkuk; Eruk äbekna, nadäŋit nadäŋit isi yäk. Imaka bureni ahäŋirän kaŋ käda. Nadätan, Boas imaka täŋpayäŋ gäwerako unita nämo maŋirän äpmonayäŋ. ");
INSERT INTO iou_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Eruk, Boastä käbeyä bägup, yotpärare täŋo yämabamken päŋku maŋitpäŋ itkaŋ Elimelek täŋo mäden naniki Boastä Rut iwetkuko u äbäŋirän kaŋkuk. Kaŋpäŋ iwetkuk; Notnapak, äbikaŋ bok itda yäk. Ude iweränä päŋku Boastä itkukken maŋitkuk. ");
INSERT INTO iou_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Täŋpäŋä Boastä yotpärare täŋo äma ekäni 10 udeta man pewän kwäkaŋ äma ekäni ekäni äbuŋ. Äbäwä yäwerän bok maŋitkuŋ. ");
INSERT INTO iou_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Maŋit irirä noripaki u ŋode iwetkuk; Nadätan? Naomi Moap kome peŋpeŋ äbuko uwä moneŋ yäpayäŋ notnekpak Elimelek täŋo kome kujat u äma kubäta imikta nadätak yäk. ");
INSERT INTO iou_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Unita ŋode gäwetta nadätat; Kome u suwawayäŋ nadäŋpäŋä äma ekäni ekäni itkaŋ ŋo iŋamiken yäŋtäre. Täŋ nämo yäpayäŋ nadäŋpäŋä siwoŋi yä. U imata, kome u gäkä mähemi tänaŋi bumik, näkä jukun ‘ei’ täga nämo yäwet yäk. Ude iweränä äma unitä täga, api suwawet yäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ude yäwänä Boastä iwetkuk; Nadätan? Kome u Naomi keriken suwaŋpäŋä Moap nanik webe kajat Rut u imaka, webekata yäpnaŋi yäk. Ude täŋiri notnekpak kumbuko unitäŋo wäpi nämo api paorek. Nämo, kome kujari u äbekiye oraniye ahänayäŋ täkaŋ unita biŋamgän api it yäpmäŋ ärowek yäk. ");
INSERT INTO iou_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ude iweränä noripaki u ŋode iwetkuk; Bureni, kome kujat u näkä mähemi tänaŋi upäŋkaŋ näkä suwawero uwä kome u näkŋaken nanaknayeta biŋam nämo api ireko unita täga nämo yäpayäŋ. Unita gäkŋata biŋam yäk. ");
INSERT INTO iou_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Kadäni uken Isrel naniktä ŋode täk täŋkukonik; Äma kubätä kubä täŋo tuŋum kubä suwaweko ba äma yarätä tuŋumi kowat imän tädeŋo u täŋkehärom takta tuŋum unitäŋo mähemitä kuroŋi ärärani yäŋopmäŋpäŋ äma tuŋum yäpeko unita imek. Ude täŋirä piä u täretak yäŋ nadäk täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Mebäri unita äma noripak unitä kome kujat u Boas gäkŋata suwa yäŋ ude iwetpäŋä kuroŋi ärärani yäŋopmäŋpäŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ude täŋirän Boastä äma ekäni ekäni ukät ämawebe päke itkuŋo u ŋode yäwetkuk; Eruk nabäŋirä in iŋamjinken Elimelek-kät nanakiyat Kilion kenta Malon unitäŋo tuŋum Naomitä inigän yäpmäŋ kuŋatkuko u apiŋo näkä suwaŋpäŋ mähemi täyat yäk. ");
INSERT INTO iou_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ba ugän nämo. Malon täŋo webe kajat Rut, Moap nanik u imaka, webenata imagutat. Ude täŋira notninpak kumbuko unitäŋo wäpi yotpärareni ŋoken nämo api paorek. Nämo, kome kujari u äbekiye oraniye ahänayäŋ täkaŋ unita biŋam api it yäpmäŋ ärowek yäk. In iŋamjinken kudän ŋo täyat. ");
INSERT INTO iou_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Ude yäwerirä äma ekäni ekäni ukät ämawebe päke itkuŋo u ei-gera yäŋpäŋ yäŋkuŋ; Täŋiri gabäŋpäŋ-nadäkamäŋ. Unita Yawetä webeka täŋkentäŋ imiŋirän Resel kenta Lea, Isrel äbot nintäŋo äbeknin pähap yarä ude äworeŋpäŋ nanak mäyap kaŋ bäyaŋ gamän. Ude täŋirän gäkŋawä Efrata äbot täŋo tuŋum äma kubä täŋpäŋ Betlehem yotpärareken wäp biŋam ärowani nikek kaŋ it. ");
INSERT INTO iou_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Täŋkaŋ Yawetä ekta nanak mäyap tamiŋirän Juda kenta Tama täŋo nanaki Peres unitäŋo äbot pähap udegän kaŋ ahäwut. ");
INSERT INTO iou_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Täŋpäkaŋ Boastä Rut webenita yäpuk. Täŋirän Yawetä nadäŋ imiŋirän nanak kok itpäŋ nanak ämani kubä bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Bäyaŋirän kome u nanik webetä Naomi ŋode iwetkuŋ; Yawe täŋo wäpi iniŋ oretna! Unitä watä it gamikta oraŋka kubä gamitak yäk. Nanak unitä Isrel ämawebe bämopiken wäp biŋam ärowani nikek iton. ");
INSERT INTO iou_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nadätan? Äbekka Ruttä gäka gäripi nadäŋ gamikinik täŋpäŋ täŋkentäk taŋi täŋ gamik täyak uwä nanak 7tä täŋkentäŋ gamineŋo u irepmitak. Unita nanak apiŋo bäyatak unitä webe pähap täŋiri täŋpidäm-pidäm täŋ gamiŋpäŋ watä säkgämän api it gamek yäk. ");
INSERT INTO iou_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ude iweräwä Naomitä nanaki bäyaŋ imiŋpäŋ ini bäyawani bumik watäni it imik täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Täŋpäkaŋ webe kome u naniktä nanak u wäpi Obet yäŋ iwetkuŋ. Ude yäŋpäŋ yäŋkuŋ; Wisiknin! Naomitä nanak kubä yäpmäŋtak! Täŋpäkaŋ Obet uwä Jesi täŋo nani. Täŋ Jesi uwä Devit täŋo nani. ");
INSERT INTO iou_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Eruk ŋowä Perestä äbotken nanik täŋo wäp tawaŋ; Peres uwä Hesron täŋo nani. Hesron uwä Ram täŋo nani. Ram uwä Aminadap täŋo nani. Aminadap uwä Nason täŋo nani. Nason uwä Salmon täŋo nani. Salmon uwä Boas täŋo nani. Boas uwä Obet täŋo nani. Obet uwä Jesi täŋo nani. Täŋpäkaŋ Jesi uwä Devit täŋo nani. Ugän.");
INSERT INTO iou_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Äma kubätä äma wakiwaki täŋo man nämo buramiwayäŋ täyak uwä bänep oretoret terak api kuŋarek. Äma unitä kädet äma wakiwakitä iwat täkaŋ u nämo iwat täyak. Ba äma Anututa yäŋärok man yäk täkaŋ udewanikät itpäŋ yäŋpäŋ-nadäk nämo täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Äma unitä Ekäni täŋo man ba kädet siwoŋita gäripi-inik nadäk täyak. Gäripiinik nadäŋpäŋ unita kepma bipani nadäk-nadäk epän täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Äma uwä päya ämatä ume pomi terak piwani ude bumik. U kehäromigän it täkaŋ. Pahämi kubirigän itkaŋ bureni kadäni terakgän pat täkaŋ. Imaka imaka äma unitä täŋpeko uwä kudup tägagän ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Täŋpäkaŋ äma waki täŋpani uwä udewani nämo. U pen nämo api itneŋ. Nämo, u täpun-täpun mänittä piäŋ äreyäŋ täŋpän kuk täkaŋ ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Unita Anututä äma wakita komi yämayäŋ täyak u täga nämo api irepmitneŋ. Täŋpäŋ äma udewaniwä äma täga bämopiken itpäŋ Anutu nämo api iniŋ oretneŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Täŋpäkaŋ äma Anutu täŋo man iwat täkaŋ, äma udewani Anututä oraŋ yämiŋpäŋ watä it yämik täyak. Täŋ, äma waki täŋpani kuduptagän api pewän paotneŋ. ");
INSERT INTO iou_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Guŋ ämawebetä imata ärowani täkta gäripi nadäk täkaŋ? Ba imata kädet wakiwaki täkta man yäŋpäŋ-nadäk jop täk täkaŋ? ");
INSERT INTO iou_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Kome täŋo intäjukun äma uken-uken nanik imaka, ämik tänayäŋ tuŋum täkaŋ. Täŋpäŋ Anutu ini ba äma Anututä intäjukun-inik itta iwoyäŋkuko u wäpi yäpmäŋ äpäkta käbeyä täŋpäŋ man yäŋpäŋ-nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Man yäŋpäŋ-nadäk täŋpäŋ ŋode yäkaŋ; Yarä unitä topmäŋpäŋ ini gämoriken nipmaŋkumän yäk. Unita ketnin pädät täŋkumäno u yäpmäŋ däkŋeŋ täna kwäpäŋ nininken gärip terak itna yäk. ");
INSERT INTO iou_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Komen ämatä ude yäŋirä Ekänitä kunum gänaŋ itkaŋ yabäŋ mägayäŋpäŋ sära yäwet täyak. ");
INSERT INTO iou_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Täŋkaŋ koki wawäpäŋ jukuman kehäromi yäwerirän bumta umuntaŋpäŋ kwaik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Koki wawäpäŋ ŋode yäwet täyak; Wa! Äma intäjukun itta yäwani iwoyäŋkuro u näkŋa teŋkuro itak yäk. U pom kudupina wäpi Saion uken teŋkuro intäjukun-inik itak yäk. U nadäŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Täŋpäkaŋ intäjukun äma Ekänitä iwoyäŋpäŋ teŋkuko unitä ŋode yäyak; Eruk ämawebenaye, man Ekänitä kwawak yäŋahäŋkuko u täwera nadäwut. Ekäni uwä ŋode näwetkuk; Gäk näkŋo nanakna. Apiŋo näkä gäkŋo nanka ude itat yäk. ");
INSERT INTO iou_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Täŋpäŋ ŋode näwetgän täŋkuk; Gäk näwerikaŋ guŋ ämawebe gäkŋa-tägän watä it yämenta api ganiŋ kirewet yäk. ");
INSERT INTO iou_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Ude täŋira gämotnaken kaŋ irut yäŋpäŋ pärip-pärip kehäromi iŋitkaŋ äma komitä-yäŋ intäjukun api it yämen yäk. Bureni, ämatä käbotinik däpmäŋ kärapmit täkaŋ ude gäk pärip-päriptä guŋ ämawebe api däpmäŋ kärapmiren. Ekäninatä man ude näwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Unita kome täŋo intäjukun äma in, ba äma wäpi nikek in, jukujin peŋpäŋ man täwerayäŋ täyat ŋonita ket nadäkot. ");
INSERT INTO iou_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","In Ekänita umuntaŋpäŋ gämori-kengän it täkot. ");
INSERT INTO iou_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Nadäkaŋ? Anutu täŋo nanakitä äma wakita kokwawak bäräŋeŋ täk täyak unita kumäŋ-kumäŋ nidäpek yäŋpäŋ kaŋ oraŋ imut. Täŋpäkaŋ ämawebe Anututä watä it nimän yäŋpäŋ dubiniken kuk täkaŋ uwä Ekäni täŋo oretoret terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Kap ŋowä Devittä nanaki tuäni Apsalom kaŋ-umuntaŋ kuŋatkaŋ teŋkuk. Ekäni, iwanaye bumta ahäŋkaŋ näk täŋpä wanayäŋ täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Täŋkaŋ yäŋärok ŋode näwet täkaŋ; Anututä täga nämo täŋkentäŋ gamek. ");
INSERT INTO iou_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Ude näwet täkaŋ upäŋkaŋ Anutu gäk näkŋo kurepäna ude itan. Gäkŋa-tägän täŋpewi iwanaye yärepmit täyat. Anutuna tägagämän, gäk bänep nadäŋ bäräpna täŋpidäm taŋ namiŋpäŋ nepmaŋpi iwan iŋamiken bätakigän it täyat. ");
INSERT INTO iou_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Nadäkaŋ? Ekänitä täŋkentäŋ namän yäŋpäŋ gera yäŋira iniken pom kudupi terak itkaŋ gerana nadäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Unitä watä it namik täyak unita bipani däpmon patguŋguŋ täŋtäŋgän akuk täyat. ");
INSERT INTO iou_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Iwanaye bumta näk it gwäjik täkaŋ upäŋkaŋ nämo umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Ekäni, gäkä iwanaye däpmäk täyan. Täŋkaŋ äma waki u meni däpmäŋ tokäriri näk nutta täŋpä wak täkaŋ. Unita Ekäni Anutuna, täŋ namiŋkuno udegän, gäk äbä iwan keri terak nanik nämagut! ");
INSERT INTO iou_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Ekäni gäk kubä-tägän ämawebekaye täga täŋkentäŋ yämen. Unita Ekäni, ämawebekaye watä säkgämän it yämi. ");
INSERT INTO iou_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Siwoŋi Anutuna, gäkken yäŋapiŋira nadäŋ namisi. Bian bänep nadäŋ bäräpna ketäreŋ namiŋkuno unita apiŋo gerana nadäŋpäŋ oraŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Ämawebe, in kadäni jidegän wäpna yäpmäŋ äpäkta piäni täk täkaŋ u api peneŋ? Ba imaka jopi-jopi yäpmäŋ kuŋat täkaŋ ba jopman nadäkta gäripi pähap nadäk täkaŋ u kadäni jidegän api peneŋ? ");
INSERT INTO iou_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ŋode nadäkot; Ämawebe Ekäni täŋo gämoriken kuŋat täkaŋ u inita biŋam iwoyäk täyak. Unita näkä gera yäŋira nadäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Unita ämawebe, in kujatjin kwaiwäpäŋ momi täktäk kädet pewut. Täŋkaŋ däpmon patpat kadäniken kwikinik patpäŋ man täwetat ŋonita juku pik täkot. ");
INSERT INTO iou_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Täŋkaŋ inä Ekänita nadäŋ imikinik täŋpäŋ ärawa täktäk kädet ini gäripi nadäk täyak ude täŋ imik täkot. ");
INSERT INTO iou_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Ekäni, ämawebe mäyaptä gäkken gera jop ŋode yäk täkaŋ; Iron täŋ nimi! Nadäŋ nimeno uyaku oretoret täga täne yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ketem piäniken ahäŋ-bumbum täŋirä äma unitä oretoret nadäk täkaŋ. Upäŋkaŋ Ekäni, oretoret nadäk täkaŋ u jopigän. Bänep oretoret gäkä namik täyan u taŋi pähap. Bänepna täŋpidäm taŋ namiŋiri oretoret bumta nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ekäni gäkŋa-tägän watä it namiŋiri säkgämän it täyat. Unita imaka kubäta nämo umuntaŋkaŋ däpmon bäräŋek-inik päŋku säkgämän patguŋguŋ täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","O Ekäni, näk komi nadäŋpäŋ yäŋkähän-kähän yäŋira juku peŋpäŋ nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Anutu intäjukun ämana, juku peŋpäŋ täŋkentäkta konäm kotat ŋo nadäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Ekäni, tami tami gäkken yäŋapik man yäk täyat. Edap dapuritä abäŋirän näk gäkken yäŋapik man kehäromigän yäŋpäŋ gäkä kowata jide näwoŋärewayäŋ täyan unita dapun täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Anutu, anutu jopi ätu kudän wakita gäripi nadäk täkaŋ upäŋkaŋ gäk anutu udewani nämo. Nämoinik, äma waki täŋpanitä gäk dubikaken täga nämo itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Ba äma inita nadäwä ärowani täŋpani uwä iŋamkaken täga nämo itneŋ. Äma waki täŋpani udewanita gaŋani pähap nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Täŋkaŋ äma jop manman yäwanita täŋpäwak täŋ yämik täyan. Ba äma iwan täŋpäŋ kumäŋ-kumäŋ däpanikät äma täŋyäkŋarani täŋpanita wakiinik nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Upäŋkaŋ gäk näka butewaki pähap nadäŋ namik täyan unita gäkŋo kudupi yotken täga api ärowet. Äroŋpäŋ ganiŋ oretta gukut imäpmok api täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Anutu, iwanaye bumta itkaŋ unita näkŋo irit kuŋat-kuŋatnata watä it namiŋiri gäkŋo kädet siwoŋi kaŋ iwara. Kädet näkä iwatta nadäwikaŋ pätak u näwoŋäre. ");
INSERT INTO iou_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Näkŋo iwanayetä man bureni kubä nämoinik yäk täkaŋ. Uwä äma täŋpä waktagän nadäk täkaŋ. Unitäŋo meni jinom uwä säkgämän, gakŋi nikektä äma täŋyäkŋatpäŋ kumäŋ-kumäŋ kädetken yämagut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Unita Anutu, manken yepmaŋpäŋ komi piä kaŋ yämi. Täŋiri iniken nadäk tawaŋ wakiwakitä äyäŋutpäŋ kaŋ täŋpä wawut. Ärowani täŋ gamiŋpäŋ momi bumta täk täkaŋ unita iŋamkaken nämo itta kaŋ yäwat-kire! ");
INSERT INTO iou_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Täŋpäkaŋ ämawebe nadäŋ gamiŋirä watä it yämik täyan uwä oretoret täk täkot. Bänep täga nadäŋpäŋ oretoret kap kadäni kadäni tek täkot. Ude täŋirä watä säkgämän it yämik täyi. U imata, ämawebe uwä gäka gäripi pähap nadäŋ gamiŋpäŋ gäka yäŋpäŋ oretoret bureni täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Bureni Ekäni, äma gäkŋo man bureni iwaräntäk täkaŋ unita kudän säkgämän täŋ yämik täyan. Nadäŋ yämik täyan unitä kurepätä-yäŋ watä bureni it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","O Ekäni, mominata yäŋpäŋ kokwawak nadäŋkaŋ nämo nebewen, ba momina täŋo kowata nämo namen. ");
INSERT INTO iou_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Ekäni, kehäromina paotinik täyak unita butewaki nadäŋ namiŋpäŋ kehäromi äneŋi nam. ");
INSERT INTO iou_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Bänepnaken nadäŋ bäräp pähap ahätak upäŋkaŋ Ekäni, gäk bäräŋeŋ nämo täŋkentäŋ namitan. Unita jidegän api nadäŋ namen? ");
INSERT INTO iou_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","5","Nutpewi kumbero uwä täga nämo ganiŋ oreret. Äma kumbanitä nämo nadäŋ gamik täkaŋ. Udewaniwä gäk täga nämo ganiŋ oretneŋ. Unita Ekäni, päbä bäräpi terak nanik nämagut. Gäk butewaki mähemi unita nadäŋ namiŋpäŋ kumäŋ-kumäŋ dubiniken nanik nämagutsi. ");
INSERT INTO iou_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Konäm kot yäpmäŋ äbäŋtäyiwa kehäromina kudup paotak. Täŋpäŋ bipani bipani dapunna konäm pitotä ämetpärani tekna ba gwäk kunowäna näbätak täyak. ");
INSERT INTO iou_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Iwanaye mäyap unita konäm pen kot täyat. Konäm kottäyiwa dapunna pom tokŋewäkaŋ dapun täga nämo ijik täyat. ");
INSERT INTO iou_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Tägagämän! Ekänitä konäm korira nadätak. Unita äma wakiwaki täŋpani in keweŋ namut! ");
INSERT INTO iou_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Täŋkentäkta gera yäk täyat u nadäŋ namitak. Bureni, yäŋapiŋira täŋkentäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Unita nadätat; Iwanaye bäräpi pähap gänaŋ itkaŋ umun bumta api täneŋ. Täŋpäŋ mäyäk pähap nadäŋpäŋ nepmaŋkaŋ täŋguŋ-gurap täŋtäŋ api ämetpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Ekäni Anutuna, iwanaye yabäŋ umuntaŋ gäkken käbop itta ärek täyat. Täŋkentäŋ namiŋiri äma näk kumäŋ-kumäŋ nutnayäŋ näwarän täkaŋ uwä nutneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Täŋ ämatä täŋkentäŋ namikta nämo iräwä, iwanayetä tom ägwäri ude wädäŋ gärepmäŋ päŋku gupna api yäpmäŋ däkŋeneŋ. ");
INSERT INTO iou_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","4","O Ekäni Anutuna, näk kudän waki kubä nämo täŋkut yäŋ nadätat. Upäŋkaŋ näkken kudän waki ätu itneŋo, ba not kubäta täŋpäwak täŋpero, ba notnapak täŋ-ikŋatpäŋ man uterak yäŋmaŋpa äroweko, ba jop nadäŋ iwanaye täŋpäwak täŋpero u täŋpäwä, eruk ŋode täga täŋpen; ");
INSERT INTO iou_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Iwanaye jop yabäŋiri näwarän täŋpäŋ kaŋ nepmäŋirut! Nut-maŋpä äpmoŋpapäŋ kumäŋ-kumäŋ täga api nutneŋ. Täŋpäŋ gupna kome terak jop uken täga api pewä pärek. ");
INSERT INTO iou_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Upäŋkaŋ näk ude nämo täŋpani unita Anutu, gäk kokwawak pähap nadäŋkaŋ akuŋpäŋ iwanaye nutnayäŋ piä bumta täkaŋ u däpmäŋpäŋ yäwat-kire! Imata, gäkäwä kudän siwoŋitagän nadäk täyan unita äbä täŋkentäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Ude täŋpäŋ punin unu itkaŋ ämawebe kuduptagän yäweri gämotkaken irirä yabäŋ yäwasi. ");
INSERT INTO iou_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Gähäwä ämawebe kuduptagän täŋo kudän yäpmäŋ daniwani unita Ekäni, iwanaye iŋamiken näka äma siwoŋi yäŋ näwet! Imata, näk waki täŋira kowata yäpmäkta yäwani nämo yäŋ nadätan unita. ");
INSERT INTO iou_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Anutu, gäk äma siwoŋi pähap. Gäk äma täŋo nadäk-nadäk ba gäripini kudup nadäwi tärek täkaŋ. Unita gäk äma waki täŋo kudän waki kudup kaŋ pewi paorut. Täŋkaŋ äma siwoŋita gwäki täga kaŋ yämi. ");
INSERT INTO iou_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Ämawebe, in nadäkaŋ? Anutu u näkŋo watä ämana. Äma unitäŋo man buramik täkaŋ u täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Anutu uwä man yäpmäŋ daniwani tägagämän. U äma wakiwaki nämo yabäŋ oretpäŋ kowata yäpmäkta biŋam yäŋtäreŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Täŋpäkaŋ äma waki u kudän waki nämo penayäŋ täŋo uwä Anututä päip boham täŋo meni api wädäwek. U äpa topmäŋkaŋ gwäjikta pidäm täyak. ");
INSERT INTO iou_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Täŋpäŋ ämik täŋo tuŋum komi komi u yäpmäŋpäŋ kuwek kädäp mebet ikek äma u yamäkta täŋtuŋum täyak. ");
INSERT INTO iou_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Eruk, äma waki unita nadäwut. U kudän waki täkta tawaŋ pek täkaŋ. Täŋkaŋ täŋikŋarani kudän mebäri mebäri wari wari täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Uwä äma ätuta buŋep täk täkaŋ. Upäŋkaŋ buŋep iniken unitä api äyäŋutpäŋ yepmäŋirek. ");
INSERT INTO iou_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","U udegän, kudän waki iniken unitägän äyäŋutpäŋ ini terak täŋpäwak api pewän ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","U kawut! Anutu u siwoŋi pähap unita bänep täga iwet täyat. Täŋpäŋ Ekäni Anutu ärowani unitäŋo wäpi biŋam kap terak iniŋoret täyat. ");
INSERT INTO iou_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Ekäni Mähemnin, wäpka biŋam gäripi gakŋi nikektä kome kuduptagän intäjukun itak! Wäpka biŋam ärowani unita kunum gänaŋ naniktä gäk ganiŋoret täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Täŋpäkaŋ iwankayetä mäyäk nadäwut yäŋpäŋ nanak pakikät iroŋiroŋi yäwetpäŋ yäwoŋärek täŋiri kap terak ganiŋoret täkaŋ. Teŋirä iwankayetä nadäŋpäŋ umuntaŋpäŋ man kum api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Täŋpäkaŋ Ekäni, näk kunum terak dapun täŋpäŋ imaka säkgämän ketkatä täŋ peŋkuno, komepak ba guk komeniken yepmaŋkuno u yabäŋ yäwatpäŋ nadäwätäk ŋode täk täyat; ");
INSERT INTO iou_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Anutu, imata gäk äma mewuni ninta nadäwi ärowani täk täkaŋ? Imata ämawebe watä säkgämän it nimik täyan? ");
INSERT INTO iou_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Nin äpani ude itnaŋipäŋ wäpnin biŋam epmäget kudän nikek ude nipmaŋkun. Bureni, imaka päke u kudup yärepmitpäŋ gäkŋa bumik nipmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Ude täŋkaŋ imaka kudup ketkatä täŋ-peŋkuno u yabäŋ yäwatta nipmaŋkun. Ude täŋiri imaka kudup u gämotninken itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","8","Yawakkät tom ägwäri, barak ba imaka imaka gwägu pähap gänaŋ komeni komeni kuŋat täkaŋ u kuduptagän äma gämoriken yepmaŋkunotä itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Unita Ekäni Mähemnin, wäpka biŋam gäripi gakŋi nikektä kome kuduptagän intäjukun itak! ");
INSERT INTO iou_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Ekäni, bänep nadäk-nadäkna kuduptä api ganiŋoret täŋpet. Täŋpäŋ näk ämawebe gäkä piä tägagämän täk täyan unita api yäwet täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Täŋkaŋ Anutu ärowani, näkä nadäŋ gamiŋpäŋ oretoret kap teŋpäŋ wäpka biŋam api yäpmäŋ ärok täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Gäkä täŋkentäŋ namikta äbäŋiri iwanayetä gabäŋ umuntaŋ metäŋpeŋ kuk täkaŋ. Metäŋpeŋ kuŋkä maŋ-däpmäŋpäŋ kumäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Täŋpäkaŋ yäpmäŋ danik piä täk täyan uwä siwoŋigän täk täyan. Täŋkaŋ näkŋo manna yäpmäŋ daniŋpäŋ momika nämo yäŋ yäŋtäreŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Gäk guŋ äbot äbori äbori nämo nadäŋ gamik täkaŋ u yebeŋpäŋ äma wakiwaki u kumän däpmäŋ moreŋkun. Täŋiri ämawebetä äma udewanita api guŋ täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Bureni, iwaniye waŋkuŋo ubayäŋ. Inide ude api itneŋ. Gäk unitäŋo yotpärare yäpi waŋkuŋo unita ämawebetä kome unita täŋguŋ taŋpäŋ nämoinik api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Täŋpäkaŋ Ekäni uwä intäjukun äma inide api it yäpmäŋ ärowek. Uwä intäjukun-inik itkaŋ ämawebe yäpmäŋ danikta pidäm täyak. ");
INSERT INTO iou_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Täŋpäŋ kudän siwoŋi terak api yäpmäŋ daniwek. Ude täŋkaŋ ämawebe kuduptagän iniken nadäk siwoŋi terak api yabäŋ yäwarek. ");
INSERT INTO iou_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ekäni uwä eŋi kehäromi kubä ude itak. Iwantä äma kubäta täŋpäwak täŋpänä, äma u Ekäniken päŋku täga irek. Ba bäräpi kadänikenä Anutuken käbop täga päŋku irek. ");
INSERT INTO iou_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","O Ekäni, äma gäk gabäŋ tarek täkaŋ u kubä mäde nämoinik ut imiŋkuno unita ämawebe mebärika nadäwä tärek täkaŋ uwä gäkä terakgän api yeŋgämä peneŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Unita ämawebe, in Ekäni, Saion yotpärareken intäjukun itkaŋ yabäŋ yäwat piä täk täyak u wäpi biŋami iniŋoret täkot! Epän pähap täk täyak unita ämawebe komeni komeni yäŋahäŋpäŋ yäwet täkot. ");
INSERT INTO iou_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Bureni, Ekäni uwä äma komi nadäk täkaŋ unitäŋo konäm gerata juku peŋpäŋ nadäŋ yämik täyak. Ude täŋpäŋ äma netätä komi u yämik täkaŋ unita kowata täŋpäwak täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Unita Ekäni, näka waki, butewaki nadäŋ namisi. Iwantä komi ba bäräpi namikaŋ ŋo yabä! Kumäŋ-kumäŋ dubiniken itat ŋo nämaguri äneŋi täga kaŋ ira! ");
INSERT INTO iou_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Ude täŋpayäŋ täno uwä näk päŋku Jerusalem nanik ämawebe iŋamiken itkaŋ wäpka api ganiŋ oreret! Ba waki keriken nanik nämagurayäŋ täyan unita oretoret pähap nadäŋpäŋ wäpka api yäpmäŋ ärowet. ");
INSERT INTO iou_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Täŋpäkaŋ äma guŋ äbotken naniktä nintä ärikta awaŋ äneŋkuŋo upäŋkaŋ ini-tägän awaŋi gänaŋ äriŋkuŋ. Nin nipmäŋitta buŋep täŋkuŋo upäŋkaŋ buŋep iniken unitä yepmäŋitkuk. ");
INSERT INTO iou_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Bureni-inik, Ekänitä äma täŋo täktäki, kudän siwoŋi terak yäpmäŋ daniŋpäŋ kowata yämik täyak. Täŋirän äma waki uwä iniken kudän wakitä äyäŋutpäŋ täŋpäwak täŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Äma waki komeni komeni Anututa nadäŋ äwaräkuk täk täkaŋ unitäŋo komeniwä kumbani kome ubayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Täŋpäkaŋ ämawebe tuŋumi nämo, täŋbute-bute täŋpaniwä Ekänitä jop yabäŋ äwaräkuk nämo täk täyak. Nämo, äma bäräpi nikek udewani bureni-inik api täŋkentäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Unita Ekäni, äbi! Äbä jop yabäŋiri komen ämatä ärowani täŋ gamineŋtawä! Äma nämo nadäŋ gamik täkaŋ u kudup yepmaŋpikaŋ gäkŋo man piäken kaŋ irut. Täŋpäŋ unitäŋo täktäki kaŋ yäpmäŋ dani. ");
INSERT INTO iou_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Ekäni, ude täŋiri kaŋ umuntäwut. Kehäromika ude yäwoŋäreŋiri inita nadäwä äpani-inik kaŋ täŋput. ");
INSERT INTO iou_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Ekäni, komi butewaki ahäŋ namiŋirän gäk imata nepmaŋpeŋ päŋku käbop itan? ");
INSERT INTO iou_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ekäni, äma waki täŋpanita nadä! U ärowani täŋpäŋ äma jopi jäwäri iwan täŋ yämiŋpäŋ däpmäŋpäŋ yäwat-kirek täkaŋ u nämo nadätan? ");
INSERT INTO iou_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Äma waki täŋpani uwä iniken bänepi täŋo gäripi ugän iwatpäŋ ärowani täk täkaŋ. Moneŋ tuŋumta nadäŋgärip täŋpäŋ Ekäni mäde ut imik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Äma udewanitä nin ärowani yäŋpäŋ Anututa nämoinik nadäŋ imik täkaŋ. Nämo, Anututa nadäwä nämo itak bumik yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Täŋpäŋ äma udewani tuŋum pähap ikek itkaŋ kome terak säkgämän it täkaŋ. Upäŋkaŋ Anutu, äma uwä inita nadäwä ärowani täŋpäpäŋ gäkŋo baga manta nadäwä äpani täk täkaŋ ba iwaniyeta udegän yäŋärok yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Täŋpäŋ bänepitä ŋode nadäk täkaŋ; Imaka kubätä nin täga nämo täŋpän waneŋ. Nin tägagän api itne yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Äma udewani uwä meniken äma tagwän man yäwet-yäwet unitägän abämaŋ kuk täkaŋ. Meberitä jop manman, umun man ba täŋpäwak man yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","9","Täŋpäŋ kädet moräkken käbop itpäŋ äma siwoŋi ba äma kehäromini nämo, jop nadäŋ däpmäk täkaŋ, aŋ komitä käbop itpäŋ tom däpmäk täkaŋ ude. ");
INSERT INTO iou_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Äma wakiinik täŋpani uwä äma jäwäri u jiraŋ yäŋ nadäŋkaŋ yeŋ yäwat päpmo yepmaŋpäŋ ärowani täŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Täŋkaŋ bänepitä ŋode yäk täkaŋ; Anutu u ninta guŋ taŋpäŋ dapuri täŋpipik täŋkuko unita nin nämo nibäk täyak yäk. ");
INSERT INTO iou_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O Ekäni, gäk akuŋpäŋ äma waki täŋpani unita kowata yämi! Täŋkaŋ äma kehäromi paorani ninta guŋ täwentawä! ");
INSERT INTO iou_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Anutu, äma waki täŋpani imata gäk ganiŋ wärät täkaŋ? Ŋode uwä jop nadäk täkaŋ; Kowata nämo api nimek! ");
INSERT INTO iou_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Upäŋkaŋ Ekäni, gäk äma kädet waki täŋpani u yabäk täyan. Äma udewanitä komi nimiŋirä nibäŋ äwaräkuk nämo täk täyan. Unita äma kehäromini nämo, gäkä täŋkentäŋ nimi yäŋpäŋ gäkgän gabäŋ tarek täkaŋ. U imata, gäk kubä-tägän äma jopi jäwäri täŋkentäŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Unita Ekäni, gäkä äma waki täŋpani täŋo kehäromi yäyomägatpäŋ kowata komi kaŋ yämi! ");
INSERT INTO iou_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Ekäni gäk intäjukun-inik it yäpmäŋ päŋku pen api it yäpmäŋ ärowen, paot-paotka nämo. Unita äma gäka nämo nadäŋ gamik täkaŋ u yäwat kireŋpewi kaŋ kuŋtäŋpä kut! ");
INSERT INTO iou_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ekäni, gäk äma jäwäri täŋo yäŋapik man nadäŋ yämiŋpäŋ bänepi täŋ-täpäneŋ yämiŋiri säkgämän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","O Ekäni, iroŋi kodäŋanikät äma bäräpi nadäwani unitäŋo yäŋapik man nadäŋ yämiŋpäŋ komi nadäk täkaŋ u dätäreŋ yämik täyi. Ude täŋiri komen ämata äneŋi nämo api umuntäneŋ! ");
INSERT INTO iou_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","2","Umuri kubä ahäŋ namiŋirän Ekänitä watä it namän yäŋpäŋ uken kuk täyat. Unita notnapak, imata guŋtä-yäŋ ŋode näwetan? Ai! Metäŋpeŋ ku! Äma waki täŋpanitä äma siwoŋi däpmäkta bipmäŋ uraniken käbop itkaŋ kuwek gwäjikaŋ u nämo yabätan? Gäk barak umuritä-yäŋ metäŋpeŋ pom udu ku! yäŋ man ude imata näwetan? ");
INSERT INTO iou_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Yäke! Äma kuduptagäntä kädet siwoŋi mäde ut imäwä äma siwoŋi jide täneŋ? Käwep api metäŋpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Upäŋkaŋ nähä nämo api metäŋpeŋ kwet! Nämo, Anutu ini kudupi tähaken itkaŋ dapun täŋ itak. Kunum gänaŋ maŋitkaŋ intäjukun-inik it nimiŋpäŋ äma täŋo täktäki u kuduptagän yabäŋpäŋ-nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Ekäni ini äma siwoŋi ba äma waki täŋpani yäpmäŋ daniŋpäŋ äma baga mani nämo buramik täkaŋ unita kokwawak pähap api pewän ahäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Ude täŋpäŋ kädäp mebet komigämän upäŋ piŋ yabat-pewän komi bumta api nadäneŋ. U imata, kowata udewani yäpmäkta biŋam täkaŋ ubayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Täŋpäkaŋ Ekäni ini uwä siwoŋi unita äma siwoŋi kuŋaranita gäripi nadäk täyak. Äma Ekäni täŋo meni jinom iwatpäŋ kuŋat täkaŋ uwä Ekäni iŋami api käneŋ. ");
INSERT INTO iou_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Ekäni, äma siwoŋi kubä nämoinik itak. Ba äma man bureni yäwani kudup paotkaŋ unita äbä täŋkentäŋ nimisi! ");
INSERT INTO iou_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Ämawebe kuduptagäntä noriye bänepi ärikta jop täŋyäkŋarani täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Unita Ekäni, gäk äma ätu jop yäŋ-yäkŋatpäŋ waki kädet terak yämagut täkaŋ ba ärowani täk täkaŋ uwä meni teŋpipiŋ yämi! ");
INSERT INTO iou_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Äma udewanitä ŋode yäk täkaŋ; Nin äma ätu jop yäŋ-yäkŋatpäŋ imaka yäpmäkta gäripi nadäk täkamäŋ u täga api yäpne. Ba man yänayäŋ nadäŋpäŋä udegän täga api yäk täne yäk. Ude täŋitna äma kubätä täga nämo niniŋ bitnäwek yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Ude yäk täkaŋ upäŋkaŋ Ekänitä ini ŋode yäyak; Eruk täga! Näk ärewayäŋ! Ämatä äma jäwäri yäpmäŋ äpäŋpäŋ komi piä yämiŋirä yäŋkähän-kähän yäŋ itkaŋ u nadätat. Äreŋpäŋ säkgämän itta gäripi nadäk täkaŋ u täŋkentäŋ yämiŋira udegän api itneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Ämawebe, in nadäkaŋ? Ekänitä täŋkentäŋ nimikta man kehäromi yäŋkuko uwä man bureni-inik yäŋkuk. Man yäk täyak u siliwa mobä kädäpken ijiŋpewä kodaki paki-inik äworek täkaŋ udewani. ");
INSERT INTO iou_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Unita Ekäni, watä säkgämän kadäni kadäni it nimiŋiri iwantä nidäpneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","U imata, äma waki bämopiken itkamäŋ. U kudup kädet wakita tägagämän yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Ekäni, kadäni jidegän äneŋi api nadäŋ namen? Gäk näka mäde kadäni käroŋi api ut namen ba? Kadäni jidegän nadäŋ namiŋiri iŋamka äneŋi api gabäwet? ");
INSERT INTO iou_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Kadäni jidegän bäräpina ŋo api ketäreŋ namen? Butewaki pähap nadäŋ itat ŋo kepma bipani jide nadäŋ yäpmäŋ kuŋira api paot namek? Kadäni jidegän täŋkentäŋ namiŋiri iwanaye gämoriken nämo api iret? ");
INSERT INTO iou_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Ekäni, gäk näkŋo Anutuna unita yäŋapik manna ŋo nadäŋ namiŋpäŋ butewaki nadäŋ nami. Täŋpäŋ kehäromi namiŋiri nämo api paoret. ");
INSERT INTO iou_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Iwanaye yabä kätäŋiri nintä irepmitkamäŋ yäŋpäŋ nabäwä maŋ parira oretoret nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Upäŋkaŋ ude nämo! Gäk nadäŋ namikinik täk täyan unita nadäkinik täyat. Butewaki nadäŋpäŋ täŋkentäŋ namayäŋ täyan unita oretoret täŋ gamitat. ");
INSERT INTO iou_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Bureni Ekäni, gäk näka säkgämän täŋ namiŋ yäpmäŋ äbuno unita kap teŋpäŋ wäpka api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Äma Anutu nämo itak yäŋ yäk täkaŋ uwä guŋ bureni-inik! Äma udewani bänepi käbäŋ täwani. U kudän waki mebäri mebäri täk täkaŋ. Kubätä kudän täga kubä nämoinik täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Nadäkaŋ? Ekänitä kunum terak ununitä etä päpä dapun pärewat täk täyak. U äma nadäwä tumbäpäŋ Anutu kaŋ-ahäkta piäni täŋpani udewani ätu itkaŋ ba nämo yäŋ nadäŋpäŋ yabäŋ ahäkta dapun pärewat täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Upäŋkaŋ nämo, kudup u kädet siwoŋi irepmit moreŋpäŋ kädet waki täŋpanigän. Uken nanik kubätä kudän täga kubä nämo täk täyak. Nämoinik. ");
INSERT INTO iou_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Unita Ekänitä ŋode yäyak; Jide? Ämawebe u nadäk-nadäki nämo? U jop orek patkaŋ näkŋo ämawebenaye uken täŋyäkŋatpäŋ kubota täŋ yämik täkaŋ. Ude täŋkaŋ näkken yäŋapik man kubä nämoinik yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Upäŋkaŋ Anututä ämawebeniye ukät itkentäk-inik täyak unita äma waki täŋpani unita imaka umuri-inik kubä api ahäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Äma waki uwä äma äpani jopi täŋo piä tawaŋ kaŋkaŋ yäniŋ wärät täkaŋ. Upäŋkaŋ Ekäni uwä äma äpanita watä it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Eruk, Isrel ämawebe täŋkentäŋ yämikta Ekänitä äma kubä Saion nanik kaŋ pewän äbän yäŋ nadätat. Ekänitä ude täŋirän äneŋi säkgämän itnayäŋ täkamäŋken uken oretoret pähap api nadäne! ");
INSERT INTO iou_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Ekäni, kudupi yotkaken äma jidewanitä täga ärowek? Ba kudupi yotpärarekaken äma jidewanitä kadäni käroŋi täga it yäpmäŋ ärowek? ");
INSERT INTO iou_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Eruk, nadätat, äma ŋodewanitä Anutu iŋamiken täga it yäpmäŋ ärowek; Äma, Anutu täŋo manta gäripi nadäŋpäŋ kädet siwoŋigän iwarani u. Ba äma kadäni kadäni man burenigän yäk täŋpani u. ");
INSERT INTO iou_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Äma udewanitä noriye täŋo wäpi jop man terak nämo yäpmäŋ äpek. Ba noriyeta imaka wakiwaki nämo täŋ yämek. Ba äboriye bämopiken yäŋ-yäkŋarani man kubä nämoinik yäwek. Anututä äma udewanita gäripi nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Äma udewanitä äma wakiwaki täŋpanita gäripi nämo nadäk täyak. Nämo! Ämawebe Anutu täŋo kädet siwoŋi iwat täkaŋ unitagän oraŋ yämik täyak. Äma udewanitä imaka api täŋpet yäŋ yäwani ugän iwatpäŋ täk täyak. Iniken mani u iwatpäŋ täŋirän bäräpi mebäri mebäri ahäŋ imäpäŋ waweko upäŋkaŋ gwäk pimiŋpäŋ mani ugän iwatpäŋ täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Äma udewanitä kädet siwoŋi ŋode täk täyak; Äma ätuta moneŋ yämiŋkaŋ yäwerek; Kowata kämi kaŋ namut yäk. Eruk ude yäwerekopäŋ kowata imikimik kadänikenä jide yämeko udegän yäpek, u irepmitpäŋ nämo. Täŋpäŋ äma udewanitä man käbeyäken man burenigän yäwek. Täŋpäkaŋ äma ätuwä noriye manken yepmakta jop manman yäk täkaŋ. Upäŋkaŋ äma siwoŋitä kädet udewaniwä nämoinik täŋpek. In nadäkaŋ? Äma kädet tägatäga udewani iwat täkaŋ uwä paot-paotta biŋam nämo täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Anutu, näk nadäŋ gamikinik täk täyat unita gäk watä säkgämän it namik täyi! ");
INSERT INTO iou_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Näk Ekäni ŋode iwetkut; Ekäni, gäk näkŋo intäjukun ämana. Imaka tägatäga näkken itkaŋ u gäkŋo ketka terak nanik-tägän äbäk täkaŋ yäŋ iwetkut. ");
INSERT INTO iou_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ämawebe Ekänita nadäkinik täk täkaŋ udewanikät itta gäripi nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Upäŋkaŋ ämawebe mäjo wära nadäŋ yämik täkaŋ uwä komi api nadäneŋ. Nähä mäjo wärata ärawa nämoinik api täŋ yämet. Ba wäpi menaken nämo api irek. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Imaka imaka päke itkaŋ ŋonitä näka watä nämo it namik täkaŋ. Ekäni, gäk kubä-tägän watä it namik täyan. Täŋpäkaŋ imaka imakata wäyäkŋek täyat uwä gäkägän namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Gäk watä säkgämän it namiŋiri näk kome terak ŋo gäripi nikek it yäpmäŋ äbätat. Näk imaka kubäta nämo wäyäkŋek täyat. ");
INSERT INTO iou_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Unita Ekänina wäpi biŋam yäpmäŋ akutat. Imata, uwä kädet siwoŋi kuŋatta nepmäŋit näwat täyak. Täŋpäŋ bipani imaka, Ekänitä nadäk-nadäk siwoŋi näwetpäŋ näwoŋärek täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Täŋpäkaŋ Ekänita guŋ taŋpäŋ nämo kuŋat täyat. Nämo, Ekäni uwä dubinaken it täyak unita imaka kubätä täŋyäkŋat-pewän umuntaŋpäŋ täga nämo kwaiwet. ");
INSERT INTO iou_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Unita bänepna pidäm taŋirän oretoret pähap nadäk täyat. Täŋkaŋ imaka kubäta nämoinik umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Täŋpäkaŋ Ekäni, gäk watä säkgämän it namik täyan. Ude täŋiri näk kumäŋ-kumäŋ komeken nämo api kwet. Gäkŋo piä ämaka täga näk, nabäŋ äwaräkuk täŋiri kumäŋpäŋ jop nämo api parawet. ");
INSERT INTO iou_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Täŋkaŋ gäkŋa-tägän kädet gäripi nadäk täyan u näwoŋärek täyan. Täŋiri gäk dubikaken itkaŋ bänep oretoret terak kuŋat täyat uwä tärek-täreki nämo! ");
INSERT INTO iou_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Ekäni, gäkken gera yäŋira nadäŋ namisi! Kädet siwoŋi iwat täyat unita nadäŋ bäräpna gäkken yäpmäŋ äbäŋira täŋkentäŋ nami. Gäk yäŋgäkŋatta nämo yäyat unita yäŋapik manna ŋo nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Näk nadätat, dapunka päraŋi-inik unita kudän siwoŋi u kudup kaŋpäŋ nadäwi tärek täkaŋ. Unita iwan iŋamiken äma siwoŋi yäŋ api yäŋtäreŋ namen. ");
INSERT INTO iou_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Bänep nadäk-nadäkna kudup kawi tärek täyak. Bipani bipani nabäŋpäŋ-nadäk täyanken nadäk waki kubä nämo kaŋ-ahäk täyan. Imata, näk man waki, äma ätutä yäk täkaŋ ude nämo yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Gäkŋo man ugänpäŋ buramiŋpäŋ äma täŋpäwak kädet kudän unita mäde ut imik täyat. ");
INSERT INTO iou_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Gäkŋo kädet siwoŋi nämo irepmitpäŋ wari wari ugän iwat täyat. ");
INSERT INTO iou_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Anutu, gäkken yäŋapiŋira nadäŋ namik täyan. Unita apiŋo gäkken gera yäkgän täŋira juku peŋpäŋ nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Dubikaken irira iwanayeta yäŋpäŋ watä säkgämän it namik täyan unita Anutu, nadäŋ namikinik täk täyan u kwawak pewi ahäwäpäŋ iwan keriken nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","9","Dapunka mujipta watäni it täyan udegän näka watä it namisi. Äma waki täŋpanitä näk nutta itgwäjineŋo udeta nämagut päŋku jirokka gäriŋ käbop nepmaŋsi. ");
INSERT INTO iou_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Äma udewani äma ätuta butewaki nämo nadäŋ yämik täkaŋ. Meni jinomkenä gup yäpmäŋ ärokärok man unitägän abäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","U näwarän täŋkä nabäŋ ahäŋpäŋ nutta yewa täkaŋ. Ude täŋkaŋ näk täŋpäwakta pidäm taŋpäŋ itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Aŋ ägwäri tom yenayäŋ pidäm taŋpäŋ it täkaŋ ude näk neŋpäŋ kwinit äwatta nabäŋ nawat itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Unita Ekäni, äbi! Äbä täŋkentäŋ namiŋpäŋ iwanaye däpmäŋ yäwat kireŋpäŋ unitäŋo kehäromini yäpmäŋ äpäsi. Päip bohamka u yäpmäŋ päbä ämik täŋpäŋ äma waki keriken nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Bureni Ekäni, äma kome terak ŋo imaka täpuri kubäta nämo wäyäkŋek täkaŋ u keriken nanik nämagut. Komi piä yämikta yäwani yäŋ yämiŋkuno u yäniŋ kiresi. Komi piä uwä yeritä yerita pen kaŋ yäniŋ kire! ");
INSERT INTO iou_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Täŋpäkaŋ nähä waki nämo täŋpani unita kämi gäkkät kowat kawän bureni api täde. Täŋkaŋ däpmon terak naniktä akuŋpäŋ dubinaken itan yäŋ nadäŋpäŋ bänep oretoret pähap tokŋek api nadäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Ekänitä Devit, Sol ba iwaniye ätu keri terak nanik imaguränpäŋ kap ŋo teŋkuk. O Ekäni, gäk näkŋo kehäromina unita gäka gäripi pähap inide kubä nadätat! ");
INSERT INTO iou_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Gäk näkŋo watä ämana, mobä yewa ude it namitan. Bureni, Anutunatä ude täŋkentäŋ namiŋirän gupna koreŋpäŋ säkgämän it täyat. U kurepä ude itpipiŋ namik täyak. Unitä itkentäŋ namiŋirän iwantä täga nämo nutneŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Näk Ekäniken gera yäŋira nadäŋ namiŋpäŋ iwan keriken nanik nämagut täyak. Unita Ekäni iniŋ orera! ");
INSERT INTO iou_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Kumäŋ-kumäŋ täŋo yentä kwasikotpäŋ nepmaŋkuŋ. Täŋpäwak täŋo kehäromitä näk uwäk taŋpäŋ nepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Bureni, kumbani kome täŋo yentä pädät täŋpäŋ nepmäŋ irirän awaŋtä näk nepmäŋitta buŋeptä-yäŋ itsämbuk. ");
INSERT INTO iou_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Upäŋkaŋ bäräpina u gänaŋ Ekäni Anutuna uken täŋkentäkta gera yäŋkut. Täŋkentäkta ude yäŋira ini kudupi yotken itkaŋ gera kotäkna ba konäm butewakina nadäŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Nadäŋ namiŋirän kome bärom täŋpäŋ kwaiŋkuk. Jop puningän nämo, mebäriken umu imaka, kwaiŋkuk. U imata, Anututä iwanayeta kokwawak nadäŋirän ude uwä ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Iŋami gäriŋ gänaŋ nanik gupe yäŋ täŋpän äpuŋ. Täŋpäŋ meni gänaŋ nanik täŋpäwak kädäp mebet gäyek ikek aŋeŋ täŋpän abuŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ude täŋkaŋ kunum yäpmäŋ weŋpewän kukŋi kukŋi kuŋirän gubam kubiri pähap terak yeŋtäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","U imaka kunum gänaŋ nanik piri nikek uterak maŋitkaŋ ukeŋode äpuk. U bäräŋek-inik äpuk, mänit täŋo piri mämä terak yäŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","U bipmäŋ uranipäŋ tek ude uwäk täŋkuk. Gubam tobori tobori ume nikek it gwäjiŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Kädet täwit imikta yäpätä gubam kubiri u gänaŋ madäŋ kireŋtäŋ äbäŋirän mim ba kädäp mebet kome terak maŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Täŋpäkaŋ Ekänitä iromaŋtä-yäŋ kunum gänaŋ kärakŋeŋirän Ekäni Ärowani-inik unitäŋo man kotäk nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Täŋkaŋ äŋini yäpä ude, gwäjiŋ täŋpän äbäŋirä iwaniye ämet täŋpä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Ekäni kokwawak täŋpäŋ iwaniye yabäŋ yäŋpäŋ yabäŋ kärakŋeŋkuk-ken gwägu pähap kawuk taŋirän kome mebäri kwawak patkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Ude täŋpäŋ Ekänitä punin unu naniktä näk nepmäŋitta kewatpäŋ ume gwägu käroŋiken nanik wädäŋpäŋ nepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Bureni, äma näka kokwawak täŋpani, kehäromini näkä yärepmitnaŋi nämo u keriken nanik nämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Iwanaye u bäräpi terak irira äbä nutnayäŋ täŋirä Ekänitä itpipiŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Wakiken-inik itkuro upäŋkaŋ bänepna gämäni-inik yäŋ nadäŋpäŋ unita wakiken nanik nämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Ekänitä näk kädet siwoŋi täk täyat unita gwäki säkgämän namik täyak. Näk momina nämo unita iron täŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Näk Ekäni Anutuna unita mäde nämo ut imiŋpäŋ unitäŋo baga mani buramiŋpäŋ iwat täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Baga mani kudup iwatpäŋ unitäŋo man käderi kubäta peŋawäk nämo täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","U iŋamiken momina nikek nämo it täyat. Waki kubä täŋpet yäŋpäŋ nadäŋit nadäŋit kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Iŋamiken näk momina nämo, siwoŋi kuräki-inik kuŋat täyat unita gwäki säkgämän udegän namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Unita Ekäni, ŋode nadätat; Äma nadäŋ gamikinik täŋpäŋ nämo gepmak täkaŋ unita kowata udegän nadäŋ yämiŋpäŋ oraŋ yämik täyan. Täŋpäŋ äma siwoŋi kuŋat täkaŋ unita kudän siwoŋigän täŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Täŋpäŋ äma bänep paki kuräki-inik kuŋat täkaŋ unita kudän tägagän täŋ yämik täyan. Täŋkaŋ äma waki täk täkaŋ unita iwan täŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Täŋpäkaŋ ämawebe äpani kuŋat täkaŋ u täŋkentäŋ yämik täyan. Täŋkaŋ äma inita nadäwä ärowani täŋpäpäŋ kuŋat täkaŋ u mäyäk yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","O Ekäni, bipmäŋ urani näk uwäktäŋ äyäŋutak u iwat kirekta topän ijiŋ-yäŋeŋ namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Bureni, kehäromi namiŋiri iwanaye täga däpmäŋpäŋ yäwat kirewet. Ba unitäŋo kehäromi täga yäpmäŋ äpet. ");
INSERT INTO iou_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Unita ämawebe, ŋode yäŋira nadäwut; Yawe Anutu ŋowä täktäki säkgämän, man yäk täyak u burenigän ahäk täkaŋ. Uwä äma watä it nimän yäŋ nadäŋpäŋ uken kuk täkaŋ unita kurepä ude it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Ekäni kubä unitägän Anutu. Ba Anutu unitägän nin gärak itpäŋ täŋkentäŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Anutu unitägän kehäromi namik täyak, ba kädet kuŋat-kuŋatnaken watä säkgämän it namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","U tägaken ba geŋiken kuŋatta kuroŋna täŋpidäm taŋ namiŋirän kwamäktä-yäŋ pidämigän kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Täŋkaŋ ämik täkta täŋpäŋ-näwoŋärek täyak unita ämik kadäniken äpa kehäromi täga gwäjiwet. ");
INSERT INTO iou_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ekäni, watä it namiŋpäŋ wakiken nanik nämagut täyan. Ketka kehäromitä mehamtäŋ namiŋpäŋ watä it namiŋiri säkgämän, wäpna biŋam nikek it täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Gäk kädet säkgämän täwit namiŋiri kuŋat täyatken yewa kwäpäŋ nämo maŋnut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nämo, iwanaye gwäk pimiŋpäŋ yäwat kireŋkä yepmäŋitpäŋ däpmäŋ-äŋan täŋkaŋ it täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Täŋkaŋ akukta nämo, bumta däpmäŋpäŋ yepmaŋpa gämotnaken it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Bureni Ekäni, gäk ämik täkta kehäromi namiŋiri iwanaye täŋo kehäromi yäpmäŋ äpäŋ morek täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Ba gäkä täŋpewi iwanaye näka umuntaŋpäŋ metäŋpeŋ kuŋtäŋpä kuk täkaŋ. Bureni, äma kokwawak täŋ namik täkaŋ u täŋpawak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ude täŋira täŋkentäkta konäm gera täk täkaŋ upäŋkaŋ kubätä nämo täŋkentäŋ yämik täyak. Ba Ekäniken gera yäk täkaŋ upäŋkaŋ kowata nämo yäniŋ-yäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Nämo, näk yeŋ kokoyäŋ-pewa keŋkeŋ äworeŋirä mänittä piäŋ äreyäŋ täŋpän kuk täkaŋ. Ba okä kädetken nanik ude äma u terak yeŋtäŋ kuk täyat. ");
INSERT INTO iou_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Bureni Ekäni, äma äbot peŋawäk täŋpani u keriken nanik nämagutpäŋ guŋ äbot yabäŋ yäwatta iwoyäŋpäŋ nepmaŋkun. Ude täŋiri äma bian nämo nadäŋkuro u apiŋo näkŋo watä piä ämanaye ude itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","45","Täŋpäŋ man yäŋira äma kubäken naniktä umuntaŋpäŋ kwaiŋkaŋ käbop irani uken nanik kwawakgän ahäŋkaŋ gwäjiŋ äpmoŋ namik täkaŋ. Ude täŋkaŋ manna buramik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Unita ŋode yäwa; Ekäni itak! Täŋkentäkna iniŋ orerut! Anutu waki keriken nanik nämagurani unitäŋo biŋam yäŋahäwut! ");
INSERT INTO iou_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","U imata, iwanaye yärepmitta kehäromi namik täyak. Täŋpäŋ äma äbori äbori täŋo kehäromi yäpmäŋ äpäŋpäŋ gämotna-kengän yepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Bureni Ekäni, iwanaye yärepmitta kehäromi namik täyan. Täŋkaŋ watä it namiŋiri täŋpäwak äma komi komitä nämo nut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Unita äma äbori äbori bämopiken kap terak yäŋ-teŋpäŋ api ganiŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","U imata, Anututä Devit näk, intäjukun ämani itta iwoyäŋkuk. U kehäromi namiŋirän iwanaye kudup yärepmit morek täyat. U kadäni kadäni nadäŋ namikinik täk täyak. Ba kämiwä yerinayeta udegän tärek-täreki nämo api nadäŋ yämik täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Kunumtä Anutu täŋo wäpi biŋam jidewani yäŋ u kwawak pewän ahäk täkaŋ! Imaka imaka kudup kunum terak naniktä keri kudän säkgämän-inik u kwawak niwoŋärek täkaŋ! ");
INSERT INTO iou_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kepma kubäkubätä yäpurärätpäŋ yäpurärätpäŋ pen yäŋahäk täyak. Ba bipanitä udegän täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Bipani kepma yarä uwä man yäkyäkta meni nämotä man kwawak yäŋirän jukunintä nämo nadäk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Upäŋkaŋ biŋam man yäŋpewän komeni komeni, yotpärare kubäkubä kuŋ morek täyak. Täŋpäkaŋ kunum terak Anututä eŋi kubä edap dapurita täŋ imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Täŋkuko unita edap dapuritä ŋode täk täyak; Äma gubaŋi kubätä webeni käwayäŋ oretoret terak eŋi gänaŋ naniktä äpämaŋ kweko ude abäk täyak. Ba äma kubä närepmirek gärepmirek-ken bäräŋekta pidämtak täyak ude täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Edap dapuri u pom kukŋi käda naniktä abämaŋ kumaŋ kukŋi udude äpmok täyak. Imaka kubätä unitäŋo ägonita käbop täga nämo irek. ");
INSERT INTO iou_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Täŋpäkaŋ Ekäni täŋo baga man uwä siwoŋi-inik. Unitä bänep nadäk-nadäknin täŋ-kodaktak täyak. Täŋkaŋ Ekäni täŋo man unita nadäŋitna bureni-inik täk täyak. Unitäŋo man kubä pära nämo täk täyak. Unitä äma nadäk-nadäki täpuri unita nadäk-nadäk taŋi Anutuken nanikpäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Täŋirän Ekänitä man tägagämän u yäŋpäŋ niwoŋärek täŋirän oretoret täk täkamäŋ. Täŋkaŋ Ekäni täŋo man kädet u kudupi säkgämän-inik unita ämawebe nadäk-nadäki täŋpirärek tak täyak. ");
INSERT INTO iou_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Täŋpäkaŋ Ekäni oraŋ imikimik kädet u kädet säkgämän. U tärek-täreki nämo it täyak. Täŋpäŋ Ekänitä ini kädet nintä iwatpäŋ täkta yäŋpäŋ niwet täyak u siwoŋi bureni-inik. ");
INSERT INTO iou_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Ekäni täŋo man u gol säkgämän-inik u irepmitak unita man unita gäripi pähap nadäk täkäna! Uwä gäripi-inik, tom gakŋi täŋo gäripini irepmit moretak. ");
INSERT INTO iou_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Bureni Ekäni, gäkŋo man u jukuman täga niwet täyak. Ämawebe u buramiŋpäŋ iwat täkaŋ uwä kowata täga ahäŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Upäŋkaŋ Ekäni, äma kubätä iniken momi kuduptagän täga nämo kaŋpäŋ nadäwän täreneŋ. Unita momi ätu käbop itkaŋ unita nämo nadätat u ärut nami! ");
INSERT INTO iou_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ärut namiŋpäŋ watä it namiŋiri momi nadäŋ parit wari täŋpetawä! Ude nämo täŋ namiwä momi unitä intäjukun täŋ namiŋirän unita watä piä täŋ imetta! Unita watä ude it namiŋiri siwoŋi-inik itkaŋ gäk mäde ut gamettawä. ");
INSERT INTO iou_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Täŋpäkaŋ Ekäni gäk käbop irit mobä käwutna, ba täŋkentäk ämana bureni! Unita näkŋo gäripna taŋi uwä ŋode yäŋahätat; Mena jinom, nadäk-nadäkna kaŋ kawi tägawut yäŋ nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Intäjukun ämanin, gäk bäräpi terak irayäŋ täno uwä, Ekäni, Jekop täŋo Anututä täŋkentäŋ gamiŋpäŋ watä it gamik täyon! ");
INSERT INTO iou_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Anutu u Saion komeken itak. Itkaŋ ini täha gänaŋ nanik täŋkentäk täga ganiŋ kirek täyon. ");
INSERT INTO iou_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Iniŋ oretta gupe käbäŋi nikek ijiŋ imayäŋ täno ba bänep tägata bänep iron peŋ imayäŋ täno unita gäripi nadäŋ gamik täyon. ");
INSERT INTO iou_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Imaka imaka bänepkatä gäripi pähap nadäk täyan u ganiŋ kirek täyon. Ba täŋkentäŋ gamiŋirän nadäk-tawaŋ pewayäŋ täno u bureni säkgämän kaŋ ahäwän! ");
INSERT INTO iou_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ude täŋkentäŋ gamiŋirän iwan täŋo kehäromi yäpmäŋ äpayäŋ täno uken nin oretoret pähap täŋpäŋ Anutunin api iniŋ oretne! Täŋpäkaŋ Ekänitä yäŋapik manka kudup nadäŋ gamik täyon. ");
INSERT INTO iou_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Eruk, näk nadätat! Ekänitä intäjukun äma ini iwoyäŋpäŋ tewani u täŋkentäŋ imik täyak. U kunum gänaŋ itkaŋ yäŋapik mani nadäŋ imik täyak. Täŋkaŋ keri kehäromitä täŋkentäŋ imiŋirän iwaniye täŋo kehäromi yäpmäŋ äpäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Täŋpäkaŋ äma ätu ämik täŋo tuŋum kehäromi kehäromi unitagän nadäkinik kehäromi täk täkaŋ. Upäŋkaŋ ninä Ekäni Anutunin unitäŋo kehäromita nadäkinik täk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Äma udewani täŋo kehäromi kudup paoräkaŋ api maŋ-patäbotneŋ. Upäŋkaŋ ninä akuŋpäŋ kehärom taŋpäŋ api it yäpmäŋ kune. ");
INSERT INTO iou_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Ekäni, gäkken gera yänayäŋ täkamäŋken uken nadäŋ nimiŋpäŋ intäjukun ämanin täŋkentäŋ imiŋiri iwaniye täŋo kehäromi kudup kaŋ yäpmäŋ äpäŋ morewän! ");
INSERT INTO iou_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Ekäni, intäjukun ämata kehäromi imiŋiri iwaniye täŋo kehäromi yäpmäŋ äpäŋ moreŋkuko unita oretoret täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Imaka bänepitä gäripi pähap nadäŋpäŋ unita gäkken yäŋapiŋkuko u imiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Gäk not täŋ imiŋpäŋ iron taŋi täŋ imiŋkun. Täŋkaŋ wäpi biŋam kwawak niwoŋärekta gwäpä golpäŋ täŋpanipäŋ ähät imiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","U irit käroŋi itta gäkken yäŋapiŋkuko u nadäŋ imiŋiri udegän kadäni käroŋi it yäpmäŋ abukotä pen api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Täŋkentäŋ imiŋiri iwan täŋo kehäromi yäpmäŋ äpuko unita wäpi biŋam ikektä taŋi itak. Wäpi biŋamkät kehäromi u gäkŋa imiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Gäk iron pähap täŋ imik täyan u paot-paori nämo, pen api it yäpmäŋ ärowek. Ba dubiniken iriri unita oretoret pähap täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","O Ekäni täŋpämorek mähemi, intäjukun äma u gäka nadäkinik täk täyak. Gäk nadäŋ imikinik täk täyan unita kehäromigän api irek. ");
INSERT INTO iou_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ude täŋkaŋ iwankaye kokwawak nadäŋ gamani u kuduptagän yäpmäŋ äpäŋpäŋ gäkŋa gämotka-kengän api yepmaŋpen. ");
INSERT INTO iou_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Täŋpäkaŋ Ekäni, gäkä kwawak ahäwayäŋ täyanken uken kädäp mebet taŋitä imaka imaka ijiŋpewä paot täkaŋ ude iwan u kudup api däpmäŋ paoren. Bureni, kokwawak taŋi nadäŋ yämiŋpäŋ däpmäŋpäŋ kädäptä kudup ijiŋpewi api paotneŋ. ");
INSERT INTO iou_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Täŋiri unitäŋo yeri kubä nämo api irek. Nämo, u kuduptagän api däpmäŋ morewen. ");
INSERT INTO iou_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Äma udewanitä waki täŋ gamikta yäŋpäŋ-nadäk täk täkaŋ upäŋkaŋ täga nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Nämo, kuwek gwäjiŋpewi yäwarirän api metäŋpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","O Ekäni, gäk kehäromika nikek unita wäpka biŋam kap terak ganiŋoret yäpmäŋ api kune! ");
INSERT INTO iou_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Anutuna, Anutuna, imata nepmaŋtan? Imata ban itkaŋ konäm kähänna nämo nadäŋ namitan? ");
INSERT INTO iou_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Wära! Anutuna, näk kepma konäm kähän yäŋira kowata nämo naniŋ yäk täyan. Ba bipani udegän ehutpäŋ gäkken gera yäŋira nämo nadäŋ namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Upäŋkaŋ näk nadätat; Gäk Anutu kudupi intäjukun iriri Isrel naniktä gäk wäpka yäpmäŋ akuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Täŋpäŋ bian äbekniye oraniyetä irit kuŋat-kuŋari gäk ketka terak peŋpeŋ kuŋarirä täŋkentäŋ yämik täŋkunonik. ");
INSERT INTO iou_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Uwä gäkken yäŋapiŋirä iwan keriken nanik yämagut täŋkunonik. Täŋiri gäka nadäkinik täŋ gamiŋirä nadäkiniki jopi nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Upäŋkaŋ nähä imaka jopi ude. Näk äma nämo! Ämawebetä nabäŋirä äpani täŋpäkaŋ yäŋärok näwerit iŋam täŋ namiŋit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Täŋpäŋ nabäŋ mägayäŋit mebet ogät näreŋit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Täŋpäŋ sära ŋode näwet täkaŋ; Ekäniken gera yäŋiri käwep täŋkentäŋ gamayäŋ yäk. Gäka gäripi nadäŋpäŋä imata nämo gämagut täyak? Man ude näwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Anutu, gäkä bian meŋ koki gänaŋ nanik täŋpewi ahäŋkut. Näk nonoŋ naŋ parira gäkä täŋkentäŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Gäk näkŋo Anutu. Gäka nadäkinik täk täyat uwä meŋtä bäyaŋpäŋ nepmaŋkukken unitä pen it yäpmäŋ äbätat ŋo. ");
INSERT INTO iou_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Unita apiŋo nepmaŋpentawä! Bäräpi ahäŋ namitak ŋonita näk täŋkentäkta kubä nämo! Unita gäk ban nepmaŋpeŋ kweno. ");
INSERT INTO iou_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Iwantä bulimakau komitä äma yäwat-kirek täkaŋ ude näwat-kirek täkaŋ. Burimäkau kehäromi Basan komeken nanik udewanitä-yäŋ näk yewa täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Aŋ komitä tom yenayäŋ yabäŋ kärakŋeŋpäŋ meni aŋek täkaŋ ude iwantä näk ude nenayäŋ täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Täŋpäkaŋ kehäromina kudup paotak, ume piwä kwäkaŋ kome terak päŋku paot täkaŋ ude. Täŋpäŋ kujatna kudup gapun täkaŋ. Ba nadäk-nadäkna tom gakŋi kädäpken pewäkaŋ mutpäŋ paot täkaŋ ude täyak. ");
INSERT INTO iou_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Täŋpäŋ kotäkna kawuk tawäkaŋ mebetna därawän täkaŋ. Gäk nabäŋ näwaräkuk täŋiri kumbayäŋ täyat. ");
INSERT INTO iou_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Täŋpäŋ waki täŋpani äbot pähaptä bipmäŋ gwäjiŋpäŋ aŋtä tom yek täkaŋ ude gupna neŋpäŋ yäpmäŋ däkŋek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Täŋpäkaŋ kujatna kwawak parirä nabäŋkaŋ oretoret täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ba näkŋo tek inita yäpmäkta närepmirek-gärepmirek ude täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Unita Ekäni, nepmaŋpeŋ ban kweno. Täŋkentäŋ namik täyan udegän apiŋo bäräŋeŋ abäŋkaŋ täŋkentäŋ nam! ");
INSERT INTO iou_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Gäk äneŋi nämaguriri nutna yäkŋat täŋpä wawut! Gäk täŋkentäŋ namiŋiri äma aŋ bumik ŋowä kumäŋ-kumäŋ nutneŋo. ");
INSERT INTO iou_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Näk aŋ ägwäri keriken nanik yäyomägariri tom ägwäri yek täkaŋ ude näk nekta täŋpä wawut! Täŋpäkaŋ bulimakau ägwäri itkaŋ ŋo joŋanitä näputneŋo, Ekäni näk nämagut. ");
INSERT INTO iou_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ude täŋpikaŋ manbiŋam gäkä täŋ namik täyan u notnaye api yäweret. Täŋpäŋ gäk ganiŋ oretta äbot kubägän itkaŋ näkä gäkŋo wäpka biŋam api yäpmäŋ akwet. ");
INSERT INTO iou_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Eruk näk ŋode yäyat; Anutu täŋo äbot täŋpani in Anutu wäpi yäpmäŋ akuwut! Jekop täŋo äboriye in Ekäni oraŋ imikot! Bureni, Isrel äbot in, gwäjiŋ äpmoŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","U imata, Anutu uwä äma jäwärita mäde nämo ut yämik täyak. Unitäŋo komi nadäwätäkita nadäŋirän jopi nämo täk täyak. Nämoinik! U yäŋapiŋirä nadäŋ yämiŋpäŋ dubiniken äbäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Unita Ekäni, ämawebekayetä ganiŋ oretta käbeyä täŋirä gäkŋo täktäkkata yäŋpäŋ käbeyä iŋamiken api ganiŋoret täŋpet. Bureni, oraŋ gamikta gupe käbäŋi nikek ijiŋ gamikta yäŋkehärom taŋkuro u ämawebe gäka umuntak täkaŋ u iŋamiken api täŋpa-tärewek. ");
INSERT INTO iou_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Kadäni uken äma jäwäri imaka, naŋ tokŋek api täneŋ. Ba ämawebe Ekäni dubiniken kuk täkaŋ uwä wäpi api iniŋ oretneŋ. Eruk, ude täŋkaŋ tärek-täreki nämo säkgämän it yäpmäŋ ärok täkot! ");
INSERT INTO iou_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Täŋpäkaŋ ämawebe komeni komeni Ekänita nadäŋpäŋ äyäŋutpeŋ gämoriken api kuŋ moreneŋ. Kuŋ moreŋpäŋ api iniŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","U imata, Ekäni uwä ämawebe komeni komeni kuduptagän intäjukun it yämiŋpäŋ yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Äma inita nadäŋirä ärowani täŋpanitä gukut imäpmok täŋpäŋ Anutu api iniŋ oretneŋ. Bureni, komen ämawebe kumäŋpäŋ parakta yäwani u kuduptagäntä Ekäni api oraŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Täŋkaŋ ämawebe mäden ahänayäŋ täkaŋ uwä Ekänita watä piä api täŋ imineŋ. Ude täŋkaŋ yeriniye ahänayäŋ täkaŋ unita Ekäni täŋo täktäkita yäŋahäŋpäŋ api yäwet täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Bureni, ämawebe nämo ahäwani uwä kämi ahäŋirä Ekänitä ämawebeniye waki keriken nanik yämagurani unita yäŋpäŋ-yäwoŋärek api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ämatä sipsip watä it yämik täkaŋ udegän, Uraktä näka watä säkgämän it namik täyak. Unita näk imaka kubäta wäyäkŋek piä nämo täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Täŋpäkaŋ näk yäŋnäkŋat päŋku nepmaŋpän ume dapuriken näŋpakaŋ eruk äneŋi nämagut päŋku äyuŋken nepmaŋpän kwinigän itpäŋ-nadäk täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ude täŋkaŋ irit kuŋat-kuŋatna täŋ-kehäromtak täyak. Täŋpäŋ iniken wäpi täga terak kädet siwoŋi-kengän nämagut yäpmäŋ kuk täyak. ");
INSERT INTO iou_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ekäni, kumäŋ-kumäŋ täŋo bipmäŋ uranitä uwäk täŋpäŋ nepmäŋirayäŋ täko upäŋkaŋ umuri udewanita nämo umuntäwet. Imata, gäk näkkät bok itkaŋ kadä ba käyäp iŋiriri gabäŋpäŋ nämo umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ude täŋkaŋ näk nepmäŋ towikta ketem tuŋum täŋpäŋ nämaguriri iwanaye jop nabäk täkaŋ. Ude täŋkaŋ nämagut päŋku dubikaken nepmaŋpäŋ täŋ-bumbum pewi ahäŋ namik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ekäni, gäk irit kuŋat-kuŋatnaken watä säkgämän it namiŋpäŋ bänep iron täŋ namik täyan. Unita gäripi pähap tärek-täreki nämo, nadäk täyat. Ba näk gäkkät bok pen api it yäpmäŋ ärode. ");
INSERT INTO iou_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Kome pähap ukät ämawebe ba imaka kome terak itkaŋ u kuduptagän Anututä mähemi-inik täyak. ");
INSERT INTO iou_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Anutu unitägän kome u gwägu pähap terak peŋpäŋ täŋ-kehärom taŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Unita äma jidewanitä Anutu unitäŋo kudupi pom terak täga äroneŋ? Ba äma jidewanitä kudupi yoriken täga äroŋpäŋ iniŋ oretneŋ? ");
INSERT INTO iou_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Ämawebe ŋodewani; Äma keritä kudän waki nämo täk täkaŋ u, ba äma bänepi kuräki-inik u. Ba äma bänep nadäk-nadäki mäjo wära terak nämo pek täkaŋ u, ba äma imaka udewani täŋo wäpi yäŋpäŋ jop manman nämo yäk täkaŋ u. ");
INSERT INTO iou_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Ekänitä ämawebe udewanita nadäŋ yämiŋpäŋ iron säkgämän api täŋ yämek. Bureni-inik, yämagurani Anutu unitä Siwoŋi ämawebenaye yäŋ api yäwerek. ");
INSERT INTO iou_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Täŋpäkaŋ ämawebe udewaniwä gwäk pimiŋpäŋ Jekop täŋo Anutu iwarän täŋpäŋ täŋkentäkta Anutu ukengän kaŋ-tarek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Unita Jerusalem täŋo yämabam biani biani, in keweŋ imiŋirä peŋyäŋek pähap täŋo intäjukun äma ärowani-inik u kaŋ ärowän! ");
INSERT INTO iou_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Täŋpäkaŋ peŋyäŋek täŋo intäjukun äma uwä netä? Uwä Ekäni kehäromi mähemi, iwan täŋo kehäromi yäpmäŋ äpani ubayäŋ! Äma unitägän peŋyäŋek pähap täŋo intäjukun äma itak. ");
INSERT INTO iou_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Unita äneŋi täwera! Jerusalem täŋo yäma biani biani, in keweŋ imiŋirä peŋyäŋek pähap täŋo intäjukun äma ärowani-inik u kaŋ ärowän! ");
INSERT INTO iou_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Täŋpäkaŋ peŋyäŋek täŋo intäjukun äma uwä netä? Uwä Ekäni kehäromi mähemi ubayäŋ! Äma unitägän peŋyäŋek pähap täŋo intäjukun äma itak. Bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Ekäni, yäŋapik man gäwerayäŋ äbätat! ");
INSERT INTO iou_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Gäk Anutuna unita näk gäkagän nadäkinik täk täyat. Gäk täŋkentäŋ nam! Nabäŋ äwaräkuk täŋiri iwantä kehäromina yäpmäŋ äpäŋpäŋ yäŋärok näwerirä mäyäk nadäwetawä. ");
INSERT INTO iou_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Täŋpäkaŋ näk ŋode nadätat; Äma gäkä terak yeŋgämä pek täkaŋ u yabäŋ äwaräkuk täŋiri nadäkiniki jopi nämo täŋpek. Nämoinik, äma gäka bitnäk täkaŋ unitägän komi nadäŋpäŋ mäyäk api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Unita Anutu, gäk nadäk-nadäk siwoŋika näwetpäŋ näwoŋärek täŋiri gäkŋo kädet täga u nadäwa tärewut. ");
INSERT INTO iou_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Täŋpäŋ nämagurani Anutu, gäkŋo man bureni pätak u näwetpäŋ näwoŋäreŋiri kädet siwoŋi u kaŋ iwara. O Ekäni, näk gäka nämo guŋ taŋpäŋ gepmäŋit-inik täŋpäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","7","Ekäni, ironka ba butewaki kädetka bian täŋkunoniktä täŋ yäpmäŋ äbätan unita nadäŋpäŋ näk gubaŋiken kädet wakiwaki täŋkuro u peŋ namisi. Gäk kudän täga ba iron mähemi unita nadäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Ämawebe, in nadäkaŋ? Ekäni uwä tägagämän, siwoŋi-inik itak. Unitä äma momi täŋpani kädet siwoŋi iwatta yäwetpäŋ yäwoŋärek täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Ba äma gämori-kengän kuŋat täkaŋ u kädet ini gäripi nadäk täyak ude yäwoŋärek täyak. ");
INSERT INTO iou_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Bureni, ämawebe topmäk-topmäk kubägän Anututä pewän ahäŋkuko u ba mani biŋam buramiŋpäŋ iwat täkaŋ unita nadäŋ yämik-inik täk täyak. Anutu uwä nadäk-nadäk yarä nikek nämo täk täyak, nadäŋkuko udegän pen api nadäŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Ekäni, momina mäyap upäŋkaŋ wäpka biŋamta yäŋpäŋ peŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Täŋpäkaŋ ämawebe Ekäni täŋo mani buramik täkaŋ, ämawebe u Ekänitä kädet siwoŋi iwatta u yäwoŋärek täyak. Yäwoŋäreŋirän ugän iwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Äma udewani säkgämän it täkaŋ. Ba unitäŋo nanakiye imaka, kome terak täga api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Bureni-inik! Ekänitä ämawebe mani buramik täkaŋ u not säkgämän täŋ yämik täyak. Täŋpäŋ topmäk-topmäk kubägän bian pewän ahäŋkuko unitäŋo mebäri kudup yäwetpäŋ yäwoŋärek täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Täŋkentäŋ namikta Anutu-kengän gera yäk täyat. Täŋira umuri u ba u keri terak nanik yäyomägat täyak. ");
INSERT INTO iou_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Unita Anutu, gäk näkken äbäŋpäŋ täŋkentäŋ namisi. Gäk ban iriri näkŋagän itpäŋ kehäromi nikek nämo nadätat. ");
INSERT INTO iou_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Unita gäk nadäŋ bäräpna yäpmäŋ keweŋ namiŋiri bänepnatä kwikinik kaŋ irän. Täŋkentäŋ namiŋiri bäräpitä kehäromina yäpmäŋ äpäk-inik nämo täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Bureni Anutu, komi nadäwätäkna yäpmäŋ keweŋ namiŋpäŋ momina kudup peŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Ekäni, iwanaye mäyap u yabätan? Unitä kokwawak pähap jop nadäŋ-nadäŋ namik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Täŋpäkaŋ gäk näkŋo watä ämana unita näk nämagutpäŋ watä säkgämän it namiŋiri iwantä nurirä mäyäk yäpettawä. ");
INSERT INTO iou_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Näk nadäŋ gamikinik täk täyat unita gäkä nadäŋ namiŋpäŋ kädet ba nadäk-nadäkna siwoŋi unita yäŋpäŋ kadäni kadäni watä säkgämän it namiŋiri wawetawä. ");
INSERT INTO iou_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Täŋpäkaŋ Ekäni, gäk äbotkaye Isrel, bäräpi mebäri mebäri gänaŋ nanikpäŋ wädäŋ tädotpäŋ yepmaŋpi säkgämän kaŋ irut. ");
INSERT INTO iou_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Näk kudän täga täk täyat upäŋkaŋ iwanayetä yäŋärok näwet täkaŋ. Unita Ekäni, iwanaye iŋamiken gäkäwä äma siwoŋi yäŋ kaŋ näwet! Näk gäkagän nadäŋ gamikinik täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Ekäni, man yäkyäk ba täktäkna kuduptagän siwoŋi itak yäŋ nadäkta nabäŋpäŋ-nadäk täyi. Täŋpäŋ bänep nadäk-nadäkna jide itak yäŋ nadäkta yäpmäŋ danisi. ");
INSERT INTO iou_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Ekäni, gäk näka iron pähap täŋ namiŋpäŋ kadäni kadäni kädet siwoŋi näwoŋärek täyan. Gäk intäjukun it namiŋpäŋ nämo nepmak täyan. ");
INSERT INTO iou_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Täŋpäkaŋ Anutu, gäk näkŋo mebärina nadätan. Näk äma waki täŋpanikät nämo kuŋat täkamäŋ. Ba äma jop manman yäwanikät nämo it täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Bureni, näk äma goret täŋpanikät itpäŋ yäŋpäŋ-nadäkta gäripi nämo nadäk täyat. Äma udewani mäde ut yämik täyat. ");
INSERT INTO iou_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ekäni, bänepna, täktäkna siwoŋi yäŋ gäwoŋärekta ketna ärutpäŋ gäkŋo eŋi gänaŋ alta dubiniken ganiŋ oretkaŋ teŋ gwäjik täyat. ");
INSERT INTO iou_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Näk ude täŋ gamiŋpäŋ kap kubä bänep täga man gäwetta teŋpäŋ täktäkka säkgämän u ämawebe yäwetpäŋ yäwoŋärek täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Ekäni, eŋi gäkä it täyanken wäpka biŋam kwawak itak. Eŋi unita gäripi taŋi nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Unita Anutu, näk äma waki täŋpani ba ämawebe kumäŋ-kumäŋ däpani ukät bok nämo nidäpen! ");
INSERT INTO iou_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Äma udewanitä kädet wakiwaki pen täk täkaŋ. Moneŋ yäpmäkta kädet waki mebäri mebäri täkta nämo umuntak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Upäŋkaŋ Ekäni, nähä kädet udewani täga nämo täŋpet. Näk gäkŋo kädet siwoŋi ugän iwat täyat unita näk nadäŋ namiŋpäŋ gäkŋata biŋam nämagut. ");
INSERT INTO iou_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Wisikna! Näk bägup tägaken itat yäŋ nadätat. Imaka kubätä näk täga nämo täŋpän waneŋ. Unita Anutu, ämawebe gäk ganiŋoret käbeyä täŋ irirä wäpka biŋam api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Ekäni uwä näkŋo peŋyäŋekna. Unitägän täŋkentäŋ namiŋpäŋ watä it namik täyak. Unita netäta umuntäwet? ");
INSERT INTO iou_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Anututä täŋkentäŋ namiŋirän äma wakiwakitä gupna awähutta täŋpäwak täkaŋ. Ba iwantä näka kokwawak nadäŋpäŋ nutna yäŋkaŋ äbä Anutu kaŋ-umuntaŋ ämetpeŋ päŋku yewä kwäpäŋ maŋdäpmäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Nadäkaŋ? Irit kuŋat-kuŋatna Anutu-kengän pek täyat unita iwan äma äbot pähaptä nutna yäŋkaŋ näk it gwäjineŋo upäŋkaŋ nämo umuntäwet. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Näk Anutuken imaka kubätagän yäŋapiŋkut. Ŋode täŋ namikta gäripi-inik nadäŋpäŋ yäŋapiŋkut; Anutu, gäk nadäŋ namiŋiri gäkŋa eŋi-kengän ittäŋgän kaŋ paora. Eŋikaken itkaŋ dapun taŋpäŋ gabäŋgärip täk täyiwa. ");
INSERT INTO iou_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Näk ŋode nadätat; Kadäni waki ahäŋ namayäŋ täyak upäŋkaŋ Anututä yäŋnäkŋat päŋku tähani gänaŋ nepmaŋpäŋ yäma ukätpäŋ watä säkgämän api it namek. Ude täŋirän näk tägagän api iret. ");
INSERT INTO iou_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Watä säkgämän it namiŋirän iwan näk it gwäjinayäŋ täkaŋ u yärepmitpäŋ kehäromini api yäpmäŋ äpet. Täŋpäŋ bänep pidäm nadäŋpäŋ oraŋ imiŋpäŋ Anututä ini eŋi gänaŋ kap terak wäpi biŋam api yäpmäŋ akwet. ");
INSERT INTO iou_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O Ekäni, näkä gäkken gera yäwayäŋ täyatken u butewaki nadäŋ namiŋkaŋ täŋkentäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Näkken äbi yäŋ näwetkuno udegän Ekäni, gäk ganiŋ oretta äretat. ");
INSERT INTO iou_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Äreŋira näka käbop nämo iren. O Anutu, näk piä ämaka unita täŋkentäŋ nam! Näka kokwawak nadäŋ namiŋpäŋ nämo näwat kirewen. Nämo nepmaŋpen ba mäde nämo ut namen. Kadäni kadäni täŋkentäŋ namik täŋkuno udegän täŋkentäŋ namik täyi. ");
INSERT INTO iou_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Meŋnaye nanayetä mäde ut namineŋo upäŋkaŋ Ekäni gähä täga nabäŋ näwaren. ");
INSERT INTO iou_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Unita Ekäni, imaka kaŋ tä yäŋ nadätan udegän näwoŋäreŋiri kaŋ täŋpa. Iwanaye mäyap itkaŋ unita kädet kukŋi kädagän kaŋ yäŋnäkŋat yäpmäŋ ku. ");
INSERT INTO iou_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Ekäni, iwan yabäŋ äwaräkuk täŋiri näk nämo nepmäŋitneŋ. Iwan uwä näka jop manman yäŋit umun man näwerit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Bureni-inik nadätat! Itkaŋ kämi Ekänitä ämawebeniye täŋkentäŋ yämiŋirän api yabäwet. ");
INSERT INTO iou_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Unita ämawebenaye, ŋode täwera nadäwut; In Anututa nadäkinik täŋpäŋ Anututä ini täŋkentäŋ tamekta kaŋ itsämbut. Nadäwätäk pähap nämo täneŋ. Nämoinik! Kehärom taŋpäŋ kaŋ irut. ");
INSERT INTO iou_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Täŋkentäkna bureni Anutu, gäkä täŋkentäŋ nami yäŋpäŋ yäŋapitat. Gera yäŋira nadäŋ namisi. Gäk gerana nämo nadäŋ namiwä näk äma kumäŋpeŋ kwani ude äworewayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Näk täŋkentäŋ nami yäŋpäŋ kudupi yotka käda ketna yaräbok kewatat. Täŋpäŋ yäŋapiŋira manna kotäk nadäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Anutu, näk äma waki-waki-kät bok nämo niwat kirewen. Äma waki udewani uwä noriyeta menitä not täŋ yämik täkaŋ upäŋkaŋ bänepitä nadäwäwak yäpmäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Unita Ekäni, kädet waki täŋkuŋo u kowata udegän kaŋ yämi. ");
INSERT INTO iou_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Gäk piä tägatäga täk täyan upäŋkaŋ äma udewanitä gäka mäde ut gamik täkaŋ. Unita nadätat, äma udewani uwä kumän api däpmäŋ morewen! ");
INSERT INTO iou_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Bänep täga pähap! Näk Ekäniken yäŋapik man yäŋira nadäŋ namiŋkuko unita ämawebenaye, Ekäni wäpi iniŋoret täkot! ");
INSERT INTO iou_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Ekäni uwä näkŋo kehäromina. U kurepäna. Bänep nadäk-nadäkna u terak peŋ moretat. U täŋkentäŋ namik täyak. Unita bänep tägagämän nadäŋpäŋ kap terak wäpi yäpmäŋ akutat ŋo! ");
INSERT INTO iou_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Ekäni uwä kehäromi-inik. Unitä iniken ämaniyeta kehäromi yämiŋpäŋ inita iwoyäwani näk watä it namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Täŋpäkaŋ Anutu, ämawebekaye waki keriken nanik ketäreŋ yepmaŋ. Täŋkaŋ gäkŋata iwoyäwani ämawebekayeta nadäŋ yämiŋpäŋ watä säkgämän kadäni kadäni kaŋ it yämi. ");
INSERT INTO iou_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Ei! Kunum gänaŋ it täkaŋ in Anutu gämoriken itkaŋ wäpi yäpmäŋ akuwut! Anutu-tägän kehäromi nikek unita wäpi biŋamta ba kehärominita yäŋpäŋ oretoret täŋput. ");
INSERT INTO iou_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Anutu u kudupi inipärik kubä itak unita gwäjiŋ äpmoŋ imiŋpäŋ wäpi biŋam iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Gwägu pähap u punin terak iromäŋ pähap yäŋirän äma komeni komenitä nadäk täkaŋ. U Anutu täŋo gera mämä. ");
INSERT INTO iou_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Bureni! Anutu uwä kehäromini nikek. Gerani u yäŋirän komen ämawebetä nadäwä kehäromi ini pärik kubä täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Täŋpäkaŋ mänit piäŋirän puamäk täk täkaŋ uwä Anutu täŋo mämä. Anutu täŋo mämä unitä Lebanon komeken päya taŋi taŋi tokät täŋpä kuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Unitä kärak yäŋirän Lebanon kome täŋo pomtä oretoret nadäŋpäŋ piäŋ äroŋkaŋ mak, bulimakau nanakitä täk täkaŋ ude täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","8","Bureni, Ekänitä kärak yäŋirän yäpä kwinit täyak. U kärak yäŋirän kome kawuki wäpi Kades unitä kwaik täyak. ");
INSERT INTO iou_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Ekänitä gera yäŋirän tomtä nanaki bäyak täkaŋ. Ba gera yäŋpewän päya pähämi äreyäŋ kuk täkaŋ. Ude täŋirän Ekäni täŋo kudupi yot gänaŋ ämawebeniyetä ŋode yäk täkaŋ; Ekäni täŋo wäpi biŋam taŋi kaŋ täŋpän! yäk. ");
INSERT INTO iou_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Ekäni u ume ba gwägu pähap yäŋpewän tokŋeŋkaŋ äneŋi wädäŋ äpmok täkaŋ. Täŋpäkaŋ Ekäni u intäjukun-inik, paot-paori nämo it täyak. ");
INSERT INTO iou_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Täŋkaŋ ämawebeniyeta kehäromi yämiŋpäŋ nadäŋ yämiŋirän säkgämän it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Ekäni, näk käyäm täŋpäŋ kumnaŋi upäŋkaŋ gäkä äneŋi nämagutkuno unita ganiŋ oretat! Gäkä täŋkentäŋ namiŋiri iwanaye yäŋärok nämo näwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Ekäni Urakna, näk gäkä täŋkentäŋ nam yäŋpäŋ yäŋapiŋira bäräpi ahäŋ namiŋkuko u ketäreŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Näk kumäŋ-kumäŋta biŋam täŋkuropäŋ äneŋi wädäŋ tädotpäŋ nepmaŋkun. Näk kumbani äworeŋpäŋ patkuropäŋ kumbaniken nanik äneŋi nämagutkun. ");
INSERT INTO iou_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Ai! Ekäni täŋo ämawebeniye, in oretoret täŋpäŋ wäpi biŋam yäpmäŋ akuwut! Ekänitä imaka imaka täk täŋkuko unita nadäkinik täŋpäŋ wäpi kudupi iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Uraknin uwä kokwawak kadäni käroŋita nämo nadäk täyak. Täŋ, iron täŋ nimik täyak uwä paot-paori nämo. Täŋpäkaŋ konäm butewaki kadäni keräpitagän täŋkaŋ butewaki paoränkaŋ äneŋi oretoret täk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Täŋpäkaŋ näk säkgämän itkutken uken ŋode nadäŋkut; Imaka kubätä täga nämo nepmäŋirek. Kehäromina nikek pen api iret yäŋ nadäŋkut. ");
INSERT INTO iou_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ekäni, kadäni uken näk pom ude, iŋamkaken kehäromi nikek itkut. Upäŋkaŋ gäk nabäŋ umuntaŋ kuŋiri umuntä kehäromina yäpmäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Ekäni, näk umun ude nadäŋkaŋ, gäkä butewaki nadäŋ nam yäŋpäŋ, gäkken yäŋapiŋkut. ");
INSERT INTO iou_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Näk ŋode gäwetkut; Näk kumäŋpäŋ äneŋi kome äworeŋira nämo tägawek. Nämoinik! Ba äma kumbanitä wäpka biŋam täga nämo yäpmäŋ akwek. Ba äma kumbanitä gäkŋo täktäkka täŋo biŋam täga nämo yäŋahäwek yäŋ gäwetkut. ");
INSERT INTO iou_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Unita Ekäni, näk gäkken yäŋapiŋira butewaki äneŋi nadäŋpäŋ täŋkentäŋ nam! ");
INSERT INTO iou_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Eruk, käyäm täŋkaŋ butewaki nadäŋ bäräp täŋkuro u ketäreŋ namiŋpewi oretoret kap teyat ŋo! Butewaki pähap nadäŋkuro u yäpmäŋ keweŋ namiŋpäŋ bänep oretoret peŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Unita mankum nämoinik api iret. Näk wari wari wäpka biŋam api yäŋahäk täŋpet! ");
INSERT INTO iou_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Ekäni gäkä käbop nepmaŋ yäŋpäŋ dubikaken äretat. Gäk täŋkentäŋ namiŋpäŋ iwan yabäŋ äwaräkuk täŋiri nämo nutneŋ. Gäk kudän siwoŋi-inik täŋpani unita täŋpewi iwantä nurirä mäyäk yäpettawä! ");
INSERT INTO iou_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Täŋpäŋ gäk nadäŋ namiŋpäŋ bäräŋek nämagut. Gäk mobä käwutna, watä ämana unita käbop nepmaŋiri iwantä nutneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Watä ämana gäkä wäpka biŋamta yäŋpäŋ nämagut yäpmäŋ kädet tägaken ku! ");
INSERT INTO iou_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Ekäni, iwantä näk nepmäŋitta buŋep täkaŋ. Unita nabäŋ näwariri jibi kubä yäpettawä! Gäk kubä-tägän watä ämana kehäromi. ");
INSERT INTO iou_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ekäni Anutuna, man bureni täŋo mähemi, bänep nadäk-nadäkna ba irit kuŋat-kuŋatna gäk-kengän peŋira näk nämagut. ");
INSERT INTO iou_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Gäk ämawebe ätutä mäjo wära yäniŋ oret täkaŋ unita bitnäk täyan. Upäŋkaŋ näk gäka nadäŋ gamikinik täyat. ");
INSERT INTO iou_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Gäk nadäŋ namikinik täk täyan unita oretoret täyat. Näk bäräpi täŋira nabäŋpäŋ bäräpina dätäreŋ namiŋkun. Komi nadäŋira nabäŋpäŋ komina utpewi maŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Iwan yabäŋ äwaräkuk täŋiri komi piäken nämo nepmaŋkuŋ. Nämo. Watä säkgämän it namiŋiri tägagän itat. ");
INSERT INTO iou_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Ekäni, gäk butewaki nadäŋ nam. Näk bäräpi kotatat. Näk konäm kottäyiwa dapunna pomi tokŋekaŋ. Täŋpäkaŋ kujatna imaka, kudup kwitakaŋ. ");
INSERT INTO iou_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Bänep nadäŋ bäräpnatä irit kuŋat-kuŋatna urayäŋ täyak. Täŋirän konäm kotkä kadäni käroŋi nämo iret yäŋ nadätat. Bäräpinatä kehäromina yäpmäŋ äpäŋpewän paotak. Täŋirän kujatna imaka, kudup kwitakaŋ. ");
INSERT INTO iou_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Kehäromina nikek nämo ude irira iwanayetä yäŋärok man näwet täkaŋ. Notnaye imaka, iŋam täŋ namik täkaŋ. Täŋpäŋ täŋkentäŋ namanitä näka gaŋa taŋpäŋ nabä-kätäkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Täŋirä ämawebe näka guŋ täkaŋ, äma kubäpäŋ äneŋpäŋ täŋguŋ taŋpäŋ it täkaŋ ude. Näk käbot awäram jiraŋken maŋpä kuk täkaŋ udewani. ");
INSERT INTO iou_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Täŋpäŋ iwan mäyaptä yäŋpäŋ-nabäŋ näwat täŋirä nadäk täyat. Näk nutta man yäŋpäŋ-nadäk täŋit waki täŋ naminayäŋ yäŋit täŋpewä bumta umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Upäŋkaŋ gäk näkŋo Anutuna bureni-inik yäŋpäŋ-nadäŋ gamikinik täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Näk gäk ketka terakgän it täyat unita iwan nepmäŋitnayäŋ näwat-kirek täkaŋ uken nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Gäkŋo piä ämaka näk, iron täŋ nami. Gäk iron mähemi unita äneŋi nämagut. ");
INSERT INTO iou_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Ekäni, näk gäka gera yäyat unita täŋkentäŋ nam. Gäk iwan yabäŋ äwaräkuk täŋiri näkŋo kehäromina nämo yäpmäŋ äpneŋ. Upäŋkaŋ äma waki ini wawut! Ini kumäŋpäŋ kumäk-inik täŋput! ");
INSERT INTO iou_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Äma udewanitä ärowani täŋpäŋ yäŋärok man ŋode yäk täkaŋ; Äma siwoŋi kuŋarani u äma waki yäŋ yäwetpäŋ yebek täkaŋ. Unita Anutu, äma udewani täŋo meni täŋpipi. ");
INSERT INTO iou_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Anutu, ämawebe gäka nadäŋ gamikinik täŋpeŋ kuŋat täkaŋ unita iron säkgämän-inik täŋ yämik täyan. Ämawebe gäkä terak tubeŋ kuk täkaŋ u watä kehäromi it yämik täyan. Ude täŋiri ämawebe komeni komenitä kaŋpäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Täŋpäkaŋ ämawebekaye u iwantä täŋpäwak täŋ yämineŋ yäŋpäŋ dubikaken käbop yepmak täyan. Täŋiri iwantä komi yämikta täŋpä wak täkaŋ. Ba äma waki täŋo mäyäk mantä täga nämo yäpmäŋ äpäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Unita näk Ekäni iniŋ orera! Iwantä yotpärarena däpmäŋ eränayäŋ täŋirä Ekäni uwä iron pähap täŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Bureni! Näk komi nadäŋkaŋ gäk käwep nepmaŋkun yäŋ nadäŋkuropäŋ konäm butewaki täŋira nadäŋpäŋ täŋkentäŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Ekäni, gäk ude täŋ namiŋkuno unita ämawebe ŋode yäwera; Ekäni täŋo äboriye in uwä Ekänita gäripi-inik nadäk täkot! U ämawebe mani buramik täkaŋ u watä säkgämän it yämik täyak. Upäŋkaŋ äma inita nadäwä ärowani täk täkaŋ unita kowata yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Unita ämawebe Ekäni nadäŋ imikinik täk täkaŋ, in kuduptagän Ekäni itak yäŋpäŋ kehäromigän it täkot. Täŋpäŋ imaka umuritä ahäŋ tamiŋirä bätakigän kuŋat täkot! ");
INSERT INTO iou_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Anututä äma kubä täŋo momi peŋ imiŋirän säkgämän it täyak. ");
INSERT INTO iou_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Bureni, ämawebe Anututä momini ärut yämiŋpäŋ momijin nämo yäŋ yäwet täyak uwä säkgämän it täkaŋ. Ämawebe udewani Ekäni täŋikŋarani äneŋi nämo täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Bureni Anutu, momina gäkken nämo yäŋahäŋkaŋ käbop peŋpäŋ kepma bipani konäm kotkä gupna kudup putäreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Kadäni uken kepma bipani bänepna sukurekta komi namiŋiri kehäromina kudup paotkuk, edap taŋi ijiŋpäŋ kome kawuktak täyak ude. ");
INSERT INTO iou_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Täŋpäŋ kämi ŋode nadäŋkut; Näk momina Anutuken yäŋahäwa! Ude nadäŋpäŋ momina kwawakgän peŋpäŋ yäŋahäŋira waki täŋkuro unitäŋo momi ärut namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Mebäri unita ämawebe gäkŋo manka buramik täkaŋ u kudup bäräpi ahäŋ yämäwä gäkken bäräŋeŋ kaŋ yäŋapiwut! Täŋirä bäräpi taŋi-inik, umetä tokätpäŋ äma yäpmäŋ kuk täkaŋ ude täŋpäŋ nämo api däpek. ");
INSERT INTO iou_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Bureni Anutu, näk imaka kubäta umuntaŋpäŋ gäkken päŋku käbop täga iret. Bureni, gäkä watä it namiŋiri bäräpitä näk nämo yäpmäŋ äpäk täkaŋ. Wakiken nanik nämagut täyan unita näk ganiŋ oretta kap taŋigän tek täyat. ");
INSERT INTO iou_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Täŋpäkaŋ Ekänitä ŋode näwetkuk; Kädet iwarayäŋ täyan u näkä nadäk-nadäk siwoŋigän gamiŋpäŋ api gabäŋ gäwaret yäk. ");
INSERT INTO iou_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Unita gäk hos kenta but ude nämo äworewen yäk. Yarä uwä nadäk-nadäki nämo yäk. U yen topmäŋpäŋ wädäwikaŋ manka buramiŋpäŋ gäkken ämdeŋ yäk. Täŋpäkaŋ gäkä udegän nämo äworewen yäŋ näwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ämawebe, näkä ŋode täwera nadäwut; Äma kädet wakiwaki täk täkaŋ udewani terak bäräpi mebäri mebäri ahäŋ yämik täkaŋ. Upäŋkaŋ ämawebe Anututa nadäŋ imikinik täk täkaŋ u säkgämän yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Unita ämawebe siwoŋi, in bänep täga nadäk täkot! Täŋpäŋ imaka imaka täŋ tamiŋkuko unita oretoret täk täkot! In ämawebe bänep sukurewani kudup, Anutu iŋamiken kap teŋpäŋ gera terak oretoret täk täkot! ");
INSERT INTO iou_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ämawebe siwoŋi kuŋarani, in oretoret täŋpäŋ Anutu kap iniŋ ubiŋ tewut. Jop manman nämo yäwani intä iniŋoret kap teŋ imiŋirä tägawek. ");
INSERT INTO iou_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Unita wagäm utpäŋ wäpi biŋam iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Wagäm bigoŋ säkgämän utpäŋ kap kodaki kubä oretoret terak teŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Anutu täŋo man u bureni-inik. Ba imaka täk täyak uwä tägagän täk täyak. Goret kubä nämo täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Unitä kudän siwoŋitagän gäripi nadäk täyak. Täŋkaŋ unitäŋo butewakitä kome pähap ŋo terak tokŋek täyak. Uwä nämo paot täyak. ");
INSERT INTO iou_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Täŋpäkaŋ Anututä man yäŋirän kunum, edap dapuri, komepak ba guk u kuduptagän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","U man yäŋirän ume kubäkengän äbä gwägu taŋi ahäŋkuk. Ahäŋpäŋ mani buramiŋkaŋ bagani nämo irepmitpäŋ ini iraniken ugän it täyak. ");
INSERT INTO iou_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","9","Unita ämawebe komeni komeni, in Anututa nadäwä umuri kubä täŋpäpäŋ iniŋ orerut! Iniŋ oretpäŋ mani buramiwut! ");
INSERT INTO iou_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Täŋpäŋ ŋode nadäwut; Ekäni u intäjukun itak. Komen ämatä ude api täne täne yäŋ man topmäk täkaŋ upäŋkaŋ Anututä nadäŋirän imaka u bureni täga nämo täk täkaŋ. U täna yäkŋat täŋpä wak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Täŋpäkaŋ Anutu ini, ude api täŋpet yäŋ nadäk täyak uwä burenigän pewän ahäk täkaŋ. Nadäk-nadäki kubä jop nämoinik kuk täyak, ba nämo api kwek. ");
INSERT INTO iou_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Unita äma äbot Anutu Bureni unitagän nadäk täkaŋ u oretoret terak kuŋat täkaŋ. Ämawebe inita biŋam iwoyäwani uwä bänep pidäm terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","14","Täŋpäkaŋ Ekäni uwä kunum gänaŋ intäjukun-inik itkaŋ ämawebe kuduptagän kome terak kuŋarirä yabäŋ yäwat itak. ");
INSERT INTO iou_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Anututä ini-tägän ämawebe täŋo nadäk-nadäki pewän ahäŋkuŋo unita mebärinin nadäŋ morek täyak. ");
INSERT INTO iou_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","17","Täŋpäkaŋ kome täŋo intäjukun ämatä ini-ini ŋode nadäk täkaŋ; Nin täŋo komi äma mäyap-inik itkaŋ unita iwan täŋo kehäromini täga yäpmäŋ äpne. Ba ŋode nadäk täkaŋ; Nin täŋo ämik tuŋum u kehäromi nikek unita nin intäjukun itkamäŋ yäŋ nadäk täkaŋ. Upäŋkaŋ täga nämo! Ämik täŋo tuŋum unitäŋo kehäromi terak säkgämän nämo itneŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Täŋ ämawebe Ekäni täŋo mani buramik täkaŋ ba unitäŋo iron paot-paori nämo u terak yeŋgämä pewäpäŋ it täkaŋ uwä Ekänitä watä it yämiŋirän säkgämän kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Ekänitä ini täŋkentäŋ yämiŋirän käyäm ba imaka umuri kubätä bäräŋeŋ nämo däpmäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Unita Ekäni kubä unitägän täŋkentäŋ nimikta itsämäk täkamäŋ. Ekänitä ini-tägän täga täŋkentäŋ nimek. Uwä nintäŋo ukätpipik kurepä. U watä it nimiŋirän säkgämän it täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Unita Ekänitagän gäripi pähap nadäk täkamäŋ. Unitäŋo wäpi kudupi terakgän tubeŋ kuŋpäŋ it täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Ekäni, nin irit kuŋat-kuŋatnin gäkä terakgän peŋpäŋ täŋkentäkta itsämäŋitna gäkŋo ironka pähap paot-paori nämotä nintä terak äroton! ");
INSERT INTO iou_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Kadäni kubä Devittä nepmaŋpän kwa yäŋkaŋ iwani Abimilek iŋamiken guŋ ude äworeŋirän Abimilektä kakätäŋ-pewän kuŋkuk. Täŋirän Devittä kap ŋo teŋkuk. Näk kadäni kadäni Ekäni wäpi biŋam yäpmäŋ akuk täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Imaka täga täŋ namik täyak unita nadäŋpäŋ iniŋoret täyat. Ude täŋira ämawebe nadäwätäk ikektä näkŋo man u nadäŋkaŋ bänep oretoret täkot. ");
INSERT INTO iou_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ai! In äbäkaŋ Ekäni täŋo wäpi biŋam bok yäŋahäŋitna nadäwut! Täŋpäŋ penta iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","In nadäwut! Näk Ekänitä täŋkentäŋ namikta yäŋapiŋira nadäŋ namiŋkuk. Täŋpäŋ umun mebäri mebäri nadäk täŋkuro u iwat kireŋirän bänep kwini terak bätakigän itkut. ");
INSERT INTO iou_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Unita nadäkot; In nadäŋ bäräp täŋpäŋ Ekäniken täŋkentäkta yäŋapinayäŋ täŋo uwä bänep oretoret pähap api nadäneŋ. U imata, Ekänitä inta nämo bitnäk täyak unita. ");
INSERT INTO iou_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Täŋpäkaŋ äma jopi jäwäritä Ekäniken gera yäŋirä nadäŋpäŋ täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Bureni! Ämawebe Ekänita nadäŋ imikinik täk täkaŋ u Ekäni täŋo aŋerotä dubiniken itpäŋ täŋkentäŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Ekäni uwä tägagämän-inik. Unita ketem kudupi kubä nabäŋ nadäwä gäripi täk täkaŋ udegän Ekäni dubiniken kuŋkaŋ täŋpäŋ-kawut. Ude tänayäŋ täŋo uwä Ekäni uwä gäripi-inik yäŋ api nadäneŋ! ");
INSERT INTO iou_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Täŋpäkaŋ Ekäni täŋo äboriye, in gämori-kengän itkaŋ imaka kubäta nämo api wäyäkŋeneŋ. ");
INSERT INTO iou_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Tom ägwäri uwä nakta kadäni kubäkubä wäyäkŋewä waneŋo upäŋkaŋ ämawebe Ekänigän iwat täkaŋ u imaka täga kubäta nämo wäyäkŋek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Unita nanaknaye, in äbä dubinaken itpäŋ Ekäni wäpi biŋam oraŋ imikta täwetpäŋ täwoŋärewayäŋ täyat ŋo ket nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Uwä ŋode; In säkgämän itkaŋ oretoret terak kaŋ it yäpmäŋ ärona yäŋ nadäkaŋ? ");
INSERT INTO iou_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Eruk ŋode täŋput! In jop manman ba man käbäŋi kubä nämo yäneŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","In kädet waki u mäde ut imiŋpäŋ kädet täga ugän kaŋ iwarut. Täŋpäŋ kädet täga u kaŋ-ahäŋpäŋ ämawebe ätukät bänep kubägän kaŋ täŋput. Gwäk pimiŋpäŋ kädet tägatäga u kudup kaŋ iwarut. ");
INSERT INTO iou_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","U imata, Ekänitä ämawebe siwoŋi yabäŋ yäwatpäŋ yäŋapik man yäk täkaŋ u nadäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Täŋ äma Ekäni täŋo mani nämo buramiwani uwä mäde ut yämik täyak. Mäde ut yämiŋirän äma udewani kumäŋirä ämawebetä waki täŋpani unita bäräŋeŋ guŋ taŋpäŋ äneŋi täga nämo api juku pineŋ. ");
INSERT INTO iou_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Unita äneŋi täwera nadäwut; Ämawebe siwoŋitä Ekäniken yäŋapiŋirä nadäŋ yämik täyak. Nadäŋ yämiŋpäŋ täŋkentäŋ yämiŋirän bäräpi kubätä kehäromini nämo yäpmäŋ äpäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Näk bureni täwetat. Ekäni uwä ämawebe nadäwätäk ikek u dubiniken it yämik täyak. Ba ämawebe butewaki pähap terak it täkaŋ u oraŋ yämiŋpäŋ bänepi täŋpidäm taŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Bureni, bäräpi mebäri mebäri uwä ämawebe siwoŋi kuŋaraniken ahäŋ yämik täkaŋ upäŋkaŋ Ekänitä täŋkentäŋ yämiŋpäŋ bäräpi u ketäreŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Täŋpäŋ watä it yämiŋirän kujari kubä nämo tokät täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Täŋpäkaŋ imaka wakiwakitä äma waki täŋpani kumäŋ-kumäŋ api däpneŋ. Täŋ ämawebe, äma nadäkinik täŋpanita iwan täŋ yämik täkaŋ uwä Ekänitä komi api yämek. ");
INSERT INTO iou_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Täŋpäkaŋ Ekänitä watä piä ämawebeniye watä it yämiŋirän säkgämän it täkaŋ. Täŋpäŋ ämawebe nadäkiniki u terakgän pek täkaŋ uwä paot-paotta biŋam nämo api täneŋ. Nämoinik. ");
INSERT INTO iou_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Ekäni, äma iwan täŋ namik täkaŋ u iwan täŋ yämisi. Ba äma näkkät ämik täk täkamäŋ ukät ämik udegän täkot! ");
INSERT INTO iou_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kurepäkät kupäŋtek yäpmäŋkaŋ täŋkentäŋ namikta äbäsi. ");
INSERT INTO iou_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Täŋpäŋ äma näwat kirek täkaŋ u kadä bohamka yäwoŋäresi. Täŋkaŋ bänepna kwinigän itta api täŋkentäŋ gamet yäŋ näwet. ");
INSERT INTO iou_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Täŋpäkaŋ äma näk nutpewä kumäkta yäŋpäŋ-nadäk täŋpäŋ näwat-kirek täkaŋ u ämikken kehäromini paoräpäŋ mäyäk nadäŋpäŋ äneŋi äyäŋutpäŋ metäŋpeŋ kaŋ kut! ");
INSERT INTO iou_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Ekäni täŋo aŋerotä yäwat kireŋirän täpun-täpun mänittä piäŋ äreyäŋ täŋpän kuk täkaŋ ude kaŋ äworewut. ");
INSERT INTO iou_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Metäŋpeŋ kuŋirä käderi bipmäŋ urani täŋpäŋ itärop kaŋ täŋpän. Täŋirän Ekäni täŋo aŋerotä kaŋ däpän! ");
INSERT INTO iou_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Mebäri nämo näka buŋep pek täkaŋ. U nepmäŋitta awaŋ käroŋi kädetnaken änek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Unita nämo nadäŋirä täŋpäwaktä kaŋ ahäŋ yämän. Täŋkaŋ buŋepi iniken unitä yepmäŋ irirän kaŋ wawut! ");
INSERT INTO iou_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Ude täŋirä Ekänita yäŋpäŋ oretoret api täŋpet, täŋkentäŋ namayäŋ täyak unita. ");
INSERT INTO iou_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Bänep nadäk-nadäkna kuduptä Ekäni ŋode api iweret; Gäk bumik äma kubä nämo itak. Äma kwini äma kehäromi nikektä däpneŋ yäŋpäŋ täŋkentäŋ yämik täyan. Ba äma jäwäri äma tuŋum ikektä täŋyäkŋatneŋta watä it yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Äma waki täŋpani manken nepmaŋpäŋ waki ude täŋpani yäŋ jop näkŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Täŋpäŋ täktäkna tägata kowata waki namik täkaŋ. Ude täŋirä netätä täŋkentäŋ namek yäŋ nadäŋkaŋ nadäŋ bäräp bumta täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Upäŋkaŋ kadäni unitä käyäm täŋiräwä, butewaki tek täŋpäŋ nakjop it täŋkuronik. Ude täŋkaŋ notnapak burenita yäŋ gwäjiŋ äpmoŋpäŋ Ekänitä täŋkentäŋ yämikta gera yäk täŋkuronik. Ba äma kubä miŋitä kumäŋirän konäm butewaki täŋpeko ude täk täŋkut. ");
INSERT INTO iou_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Täŋpäkaŋ kadäni näkä bäräpi gänaŋ irira wisik-inik yäŋ yäŋpäŋ näk it gwäjiŋpäŋ yäŋärok näwet täŋkuŋonik. Äma kome kubäken nanik u nutpäŋ nutgän täk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Ba äma wakitä guŋ yäniŋ wärätpäŋ ibeneŋo ude nebeŋpäŋ naniŋ wärät täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Unita Ekäni jop yabäŋ äwaräkuk täk täyan u jidegän api pewen? Bäräŋeŋ äbä aŋ ägwäri nutnayäŋ täkaŋ ŋoken nanik nämagut! ");
INSERT INTO iou_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ude täŋiri ämawebekaye käbeyä täŋirä iŋamiken bänep täga man kwawakgän gäwetpäŋ api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Täŋpäkaŋ iwanaye jop manman yäwani u yabäŋ äwaräkuk täŋiri näk närepmitpäŋ wisik-inik, kehäromini yäpmäŋ äpakamäŋ yäŋ nämo näwetneŋ. Ba jop yabäŋiri äma jop nadäŋ kokwawak täŋ namik täkaŋ u komi namiŋpäŋ yäŋärok nämo näwetneŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Äma udewani uwä kwini man nämo yäk täkaŋ. Nämo, u äma kwini terak kuŋaranita jop manman mebäri mebäri pewä ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Täŋkaŋ, ude täŋiri gabämäŋo yäŋ jop yäŋnäkŋatpäŋ wohut-wohut man bumta yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ude täŋirä upäŋkaŋ Ekäni, kaŋpäŋ nadäno unita man kum nämo iren. Ekäni, näk nabäŋ umuntaŋ päŋku ban nämo iren. ");
INSERT INTO iou_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Nämo! Kikŋutpäŋ ijiwä kwäpäŋ nabä! Äbä näk gärak itkaŋ iwanaye näka äma täga yäŋ yäwet! ");
INSERT INTO iou_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Ekäni, gäk siwoŋi-inik unita näka momini nämo yäŋ kaŋ yäwet. Ude täŋiri iwanaye yäŋärok nämo näwetneŋ. ");
INSERT INTO iou_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Yabäŋ äwaräkuk täŋiri näka ŋode nämo yäneŋ; Tägagämän! U paotak! ");
INSERT INTO iou_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Eruk, äma komi nadätat ŋonita yäŋärok näwet täkaŋ u kehäromini kudup paorirä täŋguŋ taŋpäŋ kaŋ irut! Ba äma näka nadäwä äpani täŋpäpäŋ inita nadäwä ärowani täk täkaŋ uwä wäpi biŋam paorirän mäyäk pähap kaŋ nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Täŋpäkaŋ Ekäni, gäk täŋkentäŋ namiŋiri ämawebe näka äma siwoŋi yäŋ nadäkinik täk täkaŋ u oretoret gera wari wari ŋode kaŋ yäwut; Ekäni wäpi biŋam punin-inik it täyon! Epän ämani ŋonitä säkgämän irirän gäripi nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ude yäŋirä näk imaka, täktäkka siwoŋi unitäŋo biŋam api yäŋahäwet. Täŋkaŋ yäŋetak bipmäŋtak wäpka biŋam api ganiŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Momitä äma waki bänepiken tokŋek pat täkaŋ. Momi unitä peŋ yäwerirä Anututa nämo umuntaŋkaŋ mäde ut imikinik täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Bänepitä täŋyäkŋarirän inita nadäwä ärowani täŋpäpäŋ ŋode nadäk täkaŋ; Wakinin käbop itak. Anututä unita yäŋpäŋ manken täga nämo nipmaŋpek! yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Meni jinomken man, nadäk ba täktäk waki unitägän abäk täkaŋ. Unita jop manmangän yäk täkaŋ. Imaka täga täkta nadäk tawaŋ siwoŋi kubä nämo pek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Nämo, däpmon patpari-kenä kädet waki täkta nadäk tawaŋ pek täkaŋ. Imaka täga täpuri-inik kubä nämo täŋkaŋ waki täktäk kädet unita mäde nämoinik ut imik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Täŋpäkaŋ Ekäni, gäkä ninta butewaki nadäŋ nimik täyan u käroŋi boham, kunum yäpureko ude bumik. Gäk ninta nadäkinik täŋ nimik täyan u ärowani. ");
INSERT INTO iou_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Imaka imaka tägagän täk täyan u yabäŋpäŋ-nadäŋitna inide kubä täk täyak. Gäkä piä siwoŋi täk täyan uwä ämatä nadäwä tärenaŋi nämo. Äma ba imaka tom tom gäkägän yabäŋ yäwat täyan. ");
INSERT INTO iou_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Anutu gäkä komen äma ninta watä it nimik täyan unita gäka gäripi pähap inide kubä nadäk täkamäŋ. Watä it nimik täyan uwä baraktä nanaki uwijiŋ pat täkaŋ ude täŋ nimik täyan. ");
INSERT INTO iou_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Ketem tägatäga gäripi nikek kawutkaken nanikpäŋ nimik täyan. Nadäŋ nimiŋiri gäkŋo ume gäripi nikek u nak täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Irit kuŋat-kuŋat täŋo mähemi u gäk kubägän. Gäk peŋyäŋekka bänepninken peŋyäŋeŋ nimiŋiri kwawakgän it täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Unita ämawebe gäka nadäŋ gamikinik täk täkaŋ unita bänep iron pen täŋ nimiŋ yäpmäŋ kwen. ");
INSERT INTO iou_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Täŋpäŋ äma ärowani täŋpani yabäŋ äwaräkuk täŋiri näk nämo yeŋ jakŋitneŋ. Ba waki täŋpani yabäŋ äwaräkuk täŋiri näk nämo yokut täreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Wisik! Äma waki täŋpani akukta nämo, maŋ-däpaniken ugän pätkaŋ. U kaŋpäŋ nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Notnapak, äma wakiwaki täŋo täktäkita yäŋpäŋ nadäwätäk nämo täŋpen. Ba äma unitäŋo tuŋumita nadäŋ gärip täŋpäŋ kokwawak nämo täŋpen. ");
INSERT INTO iou_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Äma udewaniwä piä täŋpäŋ pewä muyeŋ bäräŋeŋ kubitak täkaŋ ude api paotpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Unita gäk nadäwätäk nämo täŋpäŋ Ekänitagän nadäkinik täŋpäŋ kudän täga ugän täŋpeŋ kuŋat täyi. Ude täŋpayäŋ täno uyaku kome yäŋ gamaniken u säkgämän api iren. ");
INSERT INTO iou_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Täŋpäkaŋ oretoret bureni kaŋ-ahäkta Ekäniken kuŋiri ini bänep nadäk-nadäkka täŋo gäripi api däpmäŋ täreŋ gamek. ");
INSERT INTO iou_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Irit kuŋat-kuŋatka kudup Ekänita iniŋ kireŋpäŋ nadäkinik täŋ imiŋiri api täŋkentäŋ gamek. ");
INSERT INTO iou_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Ude täŋiri Ekänitä täktäkka täga u täŋpewän edap täŋo peŋyäŋekitä säkgämän ijik täyak ude ämawebe iŋamiken api ijiŋ-yäŋewek. Täŋkaŋ Ekänitä ämawebe kwawak ŋode api yäwoŋärewek; Äma ŋowä iŋamnaken siwoŋi-inik itak. ");
INSERT INTO iou_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Unita äma kädet waki iwatpäŋ tuŋum äma täk täkaŋ udegän itta nadäwätäk nämo täŋpen. Nämo, Ekänitä täŋkentäŋ gamikta dapun täŋpäŋ kwikinik iren. ");
INSERT INTO iou_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Nadäwätäk täŋpäŋ kokwawak täktäk kädet u mäde ut imi. Kädet udewani uwä bäräpi pewä ahäk-ahäk kädet. ");
INSERT INTO iou_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Nadätan? Ämawebe Ekänita nadäkinik täk täkaŋ unitäwä kome yäŋ yämani u api koreŋpäŋ itneŋ. Täŋpäkaŋ waki täŋpaniwä Anututä yäwat kireŋpewän api apämaŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Yäwat kireŋpewän apämaŋ kuŋpäŋä api paot täŋpä kuneŋ. Täŋirä yabäŋ ahäkta wäyäkŋewayäŋ täno upäŋkaŋ täga nämo api yabäŋ ahäwen. ");
INSERT INTO iou_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Nämo! Ämawebe inita nadäwä äpani täŋpani uwä täŋ-bumbum kome iwoyäŋ yämani u koreŋpäŋ irit gapuni terak itkaŋ oretoret api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Bureni, äma wakiwaki täŋpanitä äma siwoŋita kokwawak täŋ yämiŋpäŋ täŋpäwakta nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Upäŋkaŋ Ekänitä äma udewanita yäŋärok yäwet täyak. Imata, itkaŋ nämo, api waŋ moreneŋ yäŋ nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Äma äpani jäwäri u siwoŋi upäŋkaŋ äma wakiwaki täŋpanitä äma däpmäkta äpa kuwek gwäjiŋit päip boham wepmärit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Ude täk täkaŋ upäŋkaŋ päip boham iniken unitägän äyäŋutpäŋ ini api yäput täneŋ. Täŋkaŋ äpa kuweki uwä Anututä api ubiŋ jukut täŋpän kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Täŋpäkaŋ äma tägatäga tuŋum täpuri pat yämitak unitä äma waki täŋo tuŋum päke itkaŋ unitäŋo kehäromi Anutu iŋamiken kudup yärepmitak. ");
INSERT INTO iou_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Imata, Ekänitä ini äma waki täŋpani täŋo kehäromi yäyomägatpäŋ äma tägata watä api it yämek. ");
INSERT INTO iou_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Bureni, Ekänitä ämawebe mani buramiŋpäŋ iwat täkaŋ u watä säkgämän it yämiŋpäŋ kome iwoyäŋ yämani u inita biŋam yäniŋ kirewänpäŋ uken tärek-täreki nämo api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Täŋkaŋ äma udewaniwä kadäni waki äbäŋirän tägagän api itneŋ. Ba tagwän irit ahäwayäŋ täyakken imaka, ketem tokŋek api näneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Upäŋkaŋ äma waki täŋpani uwä Ekäni täŋo iwan itkaŋ unita api kumneŋ. Päya irori kadäni keräpitagän ahäŋpäŋ paot täkaŋ ude, ba gupetä äbutkuk täkaŋ ude api paotpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Äma waki täŋpani uwä äma täŋo tuŋum yäpmäŋkaŋ kowata äneŋi bäräŋeŋ nämo yämik täkaŋ. Upäŋkaŋ äma täga uwä iron säkgämän täŋpäŋ tuŋumi ämata ŋo yämiŋ-yämiŋ täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Täŋpäkaŋ ämawebe Ekäni täŋo iron ikek unitäwä kome yäŋ yämani u api koreŋpäŋ itneŋ. Täŋ äma Ekäni täŋo kokwawak terak it täkaŋ uwä yäwat kireŋpewän api kuŋtäŋpä kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Täŋkaŋ Ekänitä äma kubä täŋo irit kuŋat-kuŋari kaŋpäŋ gäripi nadäŋpäŋä irit kuŋat-kuŋari kädet u täŋ-kehäromtaŋ imik täyak. ");
INSERT INTO iou_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ude täŋirän äma udewani yewän kuneŋo uwä täga nämo maŋutneŋ. Nämo, Ekänitä täŋkentäŋ imiŋirän yeŋ täpäneŋpäŋ irek. ");
INSERT INTO iou_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Eruk, ŋode nadäwut; Kadäni käroŋi it yäpmäŋ äbäŋkä äma tägawani täyatken ŋo bämopiken Anututä äma siwoŋita mäde ut yämiŋirän nanakiye nakta yäŋapik-apik kubä nämo täŋirä yabäŋ yäpmäŋ äbätat. ");
INSERT INTO iou_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Nämo, äma täga udewani kadäni kadäni äma täŋkentäŋ yämikta iron tägatäga jop täŋ yämik täkaŋ. Täŋkaŋ äperiye nanakiyetä täga kuŋarirä miŋiye naniyetä yabäŋpäŋ oretoret api täk täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Unita notnapak, kädet waki täkta mäde ut imiŋpäŋ kädet täga ugän kaŋ tä. Ude täŋiri kämiwä gäkŋo yerikaye uwä kome iwoyäwaniken ugän säkgämän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Imata, Ekäni uwä ämawebeniye kudän täga täŋpäŋ nadäŋ imikinik täk täkaŋ u mäde nämo ut yämik täyak. Nämo, u yabäŋ yäwat piä tärek-täreki nämo täŋ yämik täyak. Täŋpäkaŋ waki täŋpani ini ba unitäŋo yeriniye uwä yäwat kireŋpewän api kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Täŋ ämawebe siwoŋitä kome yäŋ yämani u koreŋpäŋ uken tärek-täreki nämo api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Täŋpäkaŋ äma siwoŋi täŋo meni jinomkenä man säkgämän säkgämän Anutuken nanik unitägän ahäk täkaŋ. Mani unitä ämawebe täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Äma udewani Anutuni täŋo baga man bänepiken iŋit-inik täŋpeŋ kuŋat täkaŋ uwä nämo kakätäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Täŋ äma waki täŋpani uwä äma täga däpmäkta yabäŋ yäwat piä täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Upäŋkaŋ Ekänitä äma täga uwä yabä kätäŋirän iwaniyetä kehäromini täga nämo yäpmäŋ äpneŋ, ba manken täga nämo yepmaneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Unita Ekänitä täŋkentäŋ gamikta unitäŋo man kädet u kudup iwatkaŋ dapun täyi. Ude täŋiri oraŋ gamiŋpäŋ kome iwoyäwani u ganiŋ kireŋpäŋ iwankaye dapunka terak yäwat kireŋpewän kuŋirä api yabäwen. ");
INSERT INTO iou_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Eruk, äma kubäta ŋode täwera nadäwut; Äma waki kubä itkuko u ämawebeta komi yämik täŋkuk. U äma kehäromini nikek, päya taŋi, mäbi ude. ");
INSERT INTO iou_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Upäŋkaŋ mäden, äma unitä iraniken u kuŋpäŋ ini ba tuŋumi nämo irirän kaŋkut. Kaŋ-ahäwayäŋ wäyäkŋeŋkuro upäŋkaŋ täga nämo kaŋ-ahäŋkut. U paotkuk. ");
INSERT INTO iou_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Täŋ äma täga siwoŋi kuŋarani unita nadäwut; Äma bänep kwini terak kuŋarani täŋo yeriniye uwä mäyap. ");
INSERT INTO iou_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Täŋpäkaŋ momi täŋpani uwä paotpäŋ paot-inik api täneŋ. Ba yeriniye imaka, kudup api awähutneŋ. ");
INSERT INTO iou_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Upäŋkaŋ bäräpi kadäniken Ekänitä äma siwoŋi täŋkentäŋ yämiŋpäŋ watä it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Äma udewanitä waki mebäri mebärita umuntaŋpäŋ käbop nipmaŋpän yäŋpäŋ Ekäniken kuk täkaŋ unita äma waki täŋpani keriken nanik yäyomägatpäŋ watä it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Anutu, kokwawak nadäŋkaŋ nämo nebewen, ba momina täŋo kowata nämo namen. ");
INSERT INTO iou_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Gäk kuwektä-yäŋ namäk täyan. Täŋpäŋ nut-maŋpi kome terak äpmok täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Gäkä nadäŋ waŋ namiŋiri käyäm taŋi täyat. Täŋpäŋ momi täŋkuro unita gupnaken kehäromi nikek nämo nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Momina unitä uwäk ude täŋpäŋ nepmak täyak. Täŋirän tuŋum bäräpi kubä, buraminaŋi nämo, ude bumik yäpmäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Gupnaken womäntä tabä täŋkaŋ käbäŋi bumta piäk täkaŋ. Näkŋa kudän goret täŋkuro unita udewä ahäŋirän taräki-inik täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Bänepnaken bäräpi bumta parirä nadäŋira wakiinik täk täyak. Ude täŋkaŋ kepma käroŋ butewaki nadäŋpäŋ konäm kottäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Täŋpäŋ gupna kädäptä-yäŋ ijiŋirän käyäm pähap täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Komi taŋi nadäŋkaŋ goret-goret itat, imaka taŋi kubätä yeŋ nepmäŋitpäŋ irirän bumik. ");
INSERT INTO iou_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O Ekäni, gäk näkŋo nadäŋ gäripna u nadätan, ba bänepnatä yäŋkähän-kähän täyak u imaka, nadätan. ");
INSERT INTO iou_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Bänepnatä tuptup yäpurirän kehäromina kudup paot-inik täyak. Ude täŋirän dapunna imaka, säkgämän nämo ijitak. ");
INSERT INTO iou_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Ude täŋira notnaye jibinata yäŋpäŋ dubinaken äbäkta bitnäk-inik täk täkaŋ. Ba meŋ nan ba notnaye wanotnaye imaka, nabäŋ umuntaŋpäŋ päŋku ban it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Täŋpäkaŋ ämatä näk nutpäŋ waki täŋ namikta man yäŋpäŋ-nadäk täk täkaŋ. Täŋpäŋ waki täŋ namikta juku piŋtäŋ kuŋat täkaŋ. Ude täŋkaŋ näk nutta buŋep täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Täŋirä nähäwä guŋ ude äworeŋpäŋ man yäk täkaŋ u nämo nadäk täyat. Täŋpäŋ man waki yäk täkaŋ uwä kowata täga nämo yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Butewaki! Näk man nämo yäwani, ba man nämo nadäwani ude äworeŋpäŋ man kum it täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Upäŋkaŋ Ekäni, gäk yäpmäŋ wädäŋpäŋ itat. Täŋpäŋ Ekäni Anutuna, näk nadätat; Gäkä nadäŋ namiŋpäŋ api täŋkentäŋ namen. ");
INSERT INTO iou_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Unita iwanaye jop yabäŋiri näk komi nadäŋpäŋ goret irira nabäŋpäŋ wisik-inik yäŋ näwetneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","U imata, komi pen nadäŋ itkaŋ wakinik täŋpayäŋ keräp täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Täŋpäkaŋ Anutu, momi täŋkuro unita nadäwätäk pähap täŋpäŋ iŋamkaken kwawak yäŋahäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Täŋ iwanaye bumta-inik uwä kehäromi nikekgän itkaŋ jop nadäŋ kokwawak nadäŋ namik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Näk kudän siwoŋi täŋira äma unitä iwan täŋ namik täkaŋ. Äma udewaniwä kudän tägata kowata wäkigän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Unita Ekäni, mäde ut namentawä! Ban nämo iren! ");
INSERT INTO iou_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Gäk Ekäni, wakiken nanik wädäŋ tädotpäŋ nepmaŋpani unita bäräŋeŋ täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Näk ŋode yäŋkehärom taŋkut; Irit kuŋat-kuŋatnata watä ket api iret. Täŋpäŋ mebetnatä momiken nepmaŋpekta watä imaka, api iret. Unita äma waki dubinaken irirä man kubä nämo api yäwet. ");
INSERT INTO iou_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Ude yäŋkuro unita bäräpi ŋo ahäŋ namiŋirän man kum-inik itkut. Man täpuri kubä, waki ba täga nämo yäŋkuro upäŋkaŋ nadäŋ bäräpna taŋi täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Täŋpäŋ nadäwätäk unitä bänepnaken agekotkuk. Nadäwätäkgän täŋkä bäräpi bumta kaŋ-ahäŋkuro unita ŋode yäŋkut; ");
INSERT INTO iou_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Ekäni, kome terak ŋo kadäni jide api it yäpmäŋ ärowet? Ba jidegän api kumbet? Iritna jidegän api täreweko unitäŋo kadäni näwet! ");
INSERT INTO iou_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Butewaki! Kome terak itta kadäni keräpitagän täŋpäŋ nepmaŋkun! Kodak irayäŋ täyat u kaŋiri imaka jopi ude täyak. Bureni, äma kuduptagän itkaŋ u me woŋ bumik, kadäni keräpi-inik itta yäwani. ");
INSERT INTO iou_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Ba wärani, edap ägonitä ahäŋpäŋ paot täkaŋ u irepmitpäŋ nämo. Täŋpäkaŋ äma piä täk täkaŋ u imaka kehäromi kubä nämo pewä ahäk täkaŋ. Moneŋ tuŋum pewä ahäk täkaŋ u netätä api koreneŋ yäŋ nämo nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Unita Ekäni, imatäken kubäta itsämbet? Gäk kubä-tägän täga täŋkentäŋ nameno unita gakagän itsämäŋtat. ");
INSERT INTO iou_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Unita momi täk täyatken unitäŋo kowata yäpnaŋiken nanik nämagusi. Ba yabäŋ äwaräkuk täŋiri äma gäka nämo nadäŋ gamanitä yäŋärok näwetneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Nämo, gäkŋa täŋpewi komi ŋo nadätat unita man kum irayäŋ. Man täpuri kubä nämoinik yäwayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Unita komi piä wari namentawä! Nut yäpmäŋ äbäŋiri kumbayäŋ täyat! ");
INSERT INTO iou_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Gäkŋo mebärika nadätat. Gäk momi täŋo kowata äma yabäŋ yäŋpäŋ komi piä yämik täyan. Ba imaka unita gäripi nadäk täkaŋ u gwaktä tek näŋpä tumäk täkaŋ ude täŋpiwak täkaŋ. Bureni, ämawä me woŋ bumik, kadäni keräpi-inik itta yäwani. ");
INSERT INTO iou_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Unita Ekäni, juku peŋpäŋ butewaki gera ba yäŋapik manna nadäŋ namisi. Täŋpäŋ konäm korira nabäŋpäŋ äbä naniŋ kawat tä. Näk äbeknaye oranaye udegän kome terak ŋo gäkkät kadäni keräpitagän itta iwoyäŋkun. ");
INSERT INTO iou_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Eruk nabä kätäŋiri oretoret ätu täŋkaŋ kaŋ kuŋ kewewa! ");
INSERT INTO iou_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Näk Ekäniken gera yäŋkaŋ täŋkentäŋ namikta kwikinik itkut. Irira butewaki nadäŋ namiŋpäŋ gera yäŋkuro u nadäŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Nähä äma kubä awaŋ käroŋi kubä gänaŋ käbop itkaŋ kumbeko ude. Ude irira Ekänitä nabäŋpäŋ awaŋ gänaŋ nanik wädäŋpäŋ nepmaŋkuk. Ba näk äma kubä okä näbä gänaŋ äpmoŋpäŋ ireko ude irira Ekänitä wädäŋpäŋ kome tägaken nepmaŋpän äneŋi täga kuŋatkut. ");
INSERT INTO iou_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Eruk, ude täŋpäŋ kap kodaki kubä nadäk-nadäkna-ken pewän ahäŋkuŋ. Uwä Anutunin wäpi biŋam iniŋ oretta. Kap u teŋira nabäŋpäŋ ämawebe mäyaptä Anutu täŋo kehäromita nadäwä inide kubä täŋpäpäŋ Ekänita nadäkinik api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","In nadäkaŋ? Ämawebe Ekäni terak yeŋgämä pek täkaŋ uwä Ekäni täŋo iron nikek. Äma udewanitä äma ärowani täŋo kädet nämo yäwat täkaŋ. Ba Ekäni mäde ut imiŋpäŋ mäjo wära nämo yäniŋ oret täkaŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O Anutu Ekänina, gäk piä tägatäga täŋpäŋ täŋkentäŋ nimiŋkun. Äma gäk udewani kubä nämo itak! Gäkägän intäjukun itan! Täŋkentäk bumta täŋ nimikta nadäk tawaŋ pek täyan unita täga nämo yäwetpäŋ yäwoŋärewa täreneŋ. Nämoinik! Täŋkentäk nimik täyan uwä bumta-inik, daninaŋi nämo. ");
INSERT INTO iou_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Anutu, gäk ganiŋ oretta tom däpmäŋpäŋ ijik täkamäŋ unita nämo gek täkaŋ. Ba gupe käbäŋi nikek mominin ärutta ijik täkamäŋ udewanita nadäwi ärowani nämo täk täkaŋ. Upäŋkaŋ näk gäkŋata biŋam iwoyäŋpäŋ manka nadäkta jukuna biori tumbuŋ. Täŋpäŋ gäkä nadäk-nadäk namiŋiri manka buramik täyat. ");
INSERT INTO iou_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Eruk Anutu, näk äretat. Man näka bian kudän täŋkuŋo udegän iwatpäŋ äretat. ");
INSERT INTO iou_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Anutuna, kädet gäkä gäripi nadäk täyan näk kädet udegän täkta gäripi nadätat. Gäkŋo kädet siwoŋi u nadäk-nadäkna-ken pätak. ");
INSERT INTO iou_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","10","Unita Ekäni, näk man kum nämo itkaŋ käbeyäken ämawebekaye gäkŋo bänep ironta ŋode pen api yäŋahäŋpäŋ yäwet täŋpet; Ekäninintä nadäŋ nimikinik täŋpäŋ wakiken nanik wädäŋ tädotpäŋ nipmak täyak yäŋ api yäwet täŋpet. Täŋpäŋ manka täktäkka täŋo biŋam käbop nämo pek täyat. Ironka pähap ba imaka burenigän täk täyan u ämawebe yäwet täyat. ");
INSERT INTO iou_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Unita Ekäni, näka nadäŋ namisi! Gäk butewakika käbop nämo pewen. Nämo, nadäŋ namiŋiri ironka ba manka burenitä watä säkgämän it namiton. ");
INSERT INTO iou_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Bäräpi mebäri mebäri ahäŋ namik täkaŋ, u daninaŋi nämo. Täŋpäkaŋ momi täk täŋkuro unitä kehäromina yäpmäŋ äpäkaŋ. Bäräpi u ba u yärepmitta kädetta wäyäkŋewa wakaŋ. Momina mäyap iniktä gwäkna pujiŋ itkaŋ u yärepmitkaŋ. Unita umun terak itat. ");
INSERT INTO iou_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Unita Ekäni, bäräŋeŋ abä täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Äma nutnayäŋ täkaŋ u kehäromini yäpmäŋ äpäŋpäŋ nadäk-nadäki täŋpewi guŋtaŋirä mäyäk tawut. Mäyäk taŋpäŋ nabä-kätäŋpeŋ kut! ");
INSERT INTO iou_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Äma yäŋärok man näwet täkaŋ u meni täŋpipiŋpäŋ yäwat kireŋiri mäyäk nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Täŋpäkaŋ Ekäni, ämawebe gäk gäwaräntäk täkaŋ u oretoret täk täkot! Imata, gäkŋa waki keriken nanik wädäŋ tädotpäŋ yepmaŋkuno unita gäka gäripi pähap nadäk täkaŋ. Täŋpäŋ kadäni kadäni ŋode yäk täkot; Ekäni uwä wäpi biŋam ikek kaŋ irän! ");
INSERT INTO iou_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","O Ekäni, nähä waki, kehäromina nikek nämo. Upäŋkaŋ nadäŋ namisi. Gäk kubä-tägän näkŋo täŋkentäkna ba yäpätägak ämana. O Anutuna, bäräŋeŋ äbä täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Äma, äma jäwärita nadäŋ yämik täkaŋ uwä Anutu täŋo oretoret terak kuŋat täkaŋ. Udewanitä bäräpi kaŋ-ahänayäŋ täkaŋ uwä Ekänitä api täŋkentäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Bureni, Ekänitä watä it yämiŋpäŋ irit kuŋat-kuŋari api täŋ-mehamtaŋ yämek. Täŋpäŋ äma udewani täŋpewän komeniken oretoret terak api itneŋ. Irirä yabä kätäŋirän iwaniyetä kehäromini täga nämo api yäpmäŋ äpneŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Täŋpäŋ käyäm täŋirä Ekänitä täŋkentäŋ yämiŋirän gupi äneŋi api koreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Täŋpäkaŋ nähä Ekäni ŋode iwetkut; Ekäni, näk gäkken momi täŋkut. Upäŋkaŋ butewaki nadäŋ namiŋpäŋ nepmaŋpi tägasiwa. ");
INSERT INTO iou_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Iwanayetä käyäm täŋira nabäŋpäŋ man jägämi näwet täkaŋ. Uwä näkä kumäŋira wäpita kaŋ guŋ täna yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Täŋpäŋ äma u nabänayäŋ äbäk täkaŋ u jop gupi-tägän äbäk täkaŋ. U näka waki ude itak yäŋ yäŋpäŋ yäŋtäŋ kukta jop nabänayäŋ äbäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Äma kokwawak täŋ namik täkaŋ uwä näka waki ude ahäŋ imitak yäŋpäŋ yäŋjiap-jiap yäŋtäŋ kuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Näka ŋode yäk täkaŋ; Wisik! U käyäm wakiinik kubä täŋkaŋ kumäkta biŋam täyak. U täga nämo api tägawek yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Butewaki! Notnapak bureni, nadäŋ imikinik täŋpäŋ ketem namiŋ-gamiŋ täŋpäŋ nak täkamäk u imaka, näka iwan täŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Unita Ekäni, butewaki nadäŋ namiŋpäŋ nepmaŋpi tägaŋpäŋ iwanayeta kowata api yämet. ");
INSERT INTO iou_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Ude täŋkentäŋ namiŋiri iwantä nämo närepmiräwä ŋode api nadäwet; Anutu, gäk näka bänep täga nadäŋ namitan yäŋ api nadäwet. ");
INSERT INTO iou_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Näk kudän tägagän täk täyat unita oraŋ namiŋpäŋ iŋamkaken kwawakgän nepmaŋ iriri tärek-täreki nämo api iret. ");
INSERT INTO iou_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Unita ämawebe, Ekäni, Isrel täŋo Anutu u iniŋoret täkäna! U tärek-täreki nämo iniŋoret täkäna! Burenitä bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Anutu, tomtä umeta yek täkaŋ ude, näk gäka udegän nek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Anutu, Anutu irit mähemi, bänepnatä gäka nek täkaŋ unita kadäni jidegän gäkkät man yäŋpäŋ-nadäkta kaŋ ärewet? ");
INSERT INTO iou_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Kepma bipani butewaki nadäŋpäŋ konämna pitotä ketemna ude täk täyak. Kepma käroŋ yäŋärok ŋode näwet täkaŋ; Anutuka de? Imata nämo täŋkentäŋ gamik täyak? yäŋ näwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Näk komi nadäŋpäŋ imaka ŋode juku pik täyat u yäŋahäŋira bänepna pidäm tawän! Bian näk komenaken itkaŋ ämawebe tawaŋ käroŋ näkä jukun yäŋ-yäkŋat yäpmäŋ oretoret terak Anutu täŋo kudupi yot gänaŋ ärok täŋkumäŋonik. Äroŋkaŋä Anututa oretoret kap teŋ imiŋitna unitä täŋpidäm taŋ nimik täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Yäke! Butewaki imata nadätat? Bänepna imata jägäm täyak? Ude nämo! Näk ŋode täŋpet yäŋ nadätat; Näk Anutu tubeŋ kuŋkaŋ pen api iniŋoret täŋpet! Imata, Ekänina uwä nämagurani ämana bureni! ");
INSERT INTO iou_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Näk komenata nadäwätäk täŋ itat. Upäŋkaŋ Anutu, ban kome ŋo Jodan ume dapuri kädakät pom yarä Hemon kenta Misa ŋoken itkaŋ gäka nadäŋ gamayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Wära! Ume damuntä gwägu gänaŋ äpmoŋirän gwägutä gera yäŋ itak. Wära! Waki nadätat! Täŋpäik-päikkatä näk yejämäŋ moretak. ");
INSERT INTO iou_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Upäŋkaŋ ude nämo! Kepma kepma Ekänitä butewaki nadäŋ namik täyak. Ude täŋirän bipani bipani Anutu iniŋoret kapnatä mena-kengän it täyak. Kap teŋkaŋ Anutuna, irit kuŋat-kuŋatna täŋo mähemi uken yäŋapik täyat. ");
INSERT INTO iou_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Täŋpäŋ kadäni kadäni Anutu, mobä kujatna ŋode iwet täyat; Imata näka guŋtak täyan? Imata iwan yabäŋ äwaräkuk täŋiri komi namik täkaŋ? ");
INSERT INTO iou_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Kadäni kadäni iwantä sära ŋode näwet täkaŋ; Anutuka de? Man ude näwet täkaŋ u äpa kuwektä-yäŋ namäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Yäke! Butewaki imata nadätat? Bänepna imata jägäm täyak? Ude nämo! Näk ŋode täŋpet yäŋ nadätat; Näk Anutu tubeŋ kuŋkaŋ pen api iniŋoret täŋpet! Imata, Ekänina uwä nämagurani ämana bureni! ");
INSERT INTO iou_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Anutu, äma mäde ut gamik täkaŋ u wäpna yäpmäŋ äpnayäŋ täkaŋ. Unita gäkä näk gärak itkaŋ jop man yäwani unitäŋo mani utpäŋ ŋode yäwet; U siwoŋi kuŋat täyak. ");
INSERT INTO iou_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Anutu, gäk näkŋo kehäromina ude itan upäŋkaŋ imata mäde ut namitan? Iwantä kehäromina yäpmäŋ äpäŋirä wakiinik nadätat. ");
INSERT INTO iou_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Unita Anutu, kädetka bureni näwoŋäre! Topänka peŋyäŋeŋ namiŋiri akuŋpäŋ kädet täga iwat yäpmäŋ Saion Pom terak, itanken u kaŋ ärewa. ");
INSERT INTO iou_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Ude täŋ namiŋiri eŋikaken äroŋpäŋ gäk ganiŋ orerayäŋ kudupi bukäkaken kwa. Bureni, Anutuna, gäk dubikaken kwa. Gäk bänepna täŋpidäm taŋ namiŋiri oretoret pähap nadäk täyat unita Anutu Anutuna, wagäm utpäŋ api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Yäke! Butewaki imata nadätat? Bänepna imata jägäm täyak? Ude nämo! Näk ŋode täŋpet yäŋ nadätat; Näk Anutu tubeŋ kuŋkaŋ pen api iniŋoret täŋpet! Imata, Ekänina uwä nämagurani ämana bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","O Anutu, äbekniye oraniyeta imaka tägatäga bian-inik täŋ yämiŋkuno unitäŋo biŋam ŋode niwerirä ninin nadäŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Kome iwoyäŋ yämani uken nanik guŋ äbot komi yämiŋpäŋ yäwat kireŋpäŋ ämawebekaye gäkŋaken unita yäniŋ kireŋkun. Yäniŋ kireŋiri täŋ-bumbumka u koreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ämawebekaye u iniken kadä boham ba iniken kehäromi terak kome u nanik ämawebe nämo däpmäŋ yäwat kireŋkuŋ. Nämo, gäkŋo kehäromika terak yeŋgämä pewäpäŋ täŋkuŋ. Ba gäkä nadäŋ yämik-inik täŋpäŋ dubiniken itkentäŋ yämiŋpäŋ kehäromi yämiŋiri täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Gäk intäjukun ämana ba Anutuna bureni. Isrel äbot nintäŋo iwaniye yärepmitta kädet peŋ nimiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Täŋkaŋ gäkä täŋkentäŋ nimiŋiri iwaniye täŋo kehäromi yäpmäŋ äpäk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Unita näk äpa kuwekna ba päip boham unitä api täŋkentäŋ namineŋ yäŋ nämo nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Nämo, gäkŋa-tägän täŋkentäŋ nimiŋpäŋ iwaniye kokwawak nadäŋ nimik täkaŋ u däpmäŋ yäwat kireŋpäŋ u keriken nanik yäyomägatpäŋ nipmak täyan. ");
INSERT INTO iou_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Unita gäkŋo wäpka yäpmäŋ akuŋpäŋ bänep täga man tärek-täreki nämo api gäwet täne. ");
INSERT INTO iou_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Upäŋkaŋ waki, apiŋode nibä kätäŋiri iwaniyetä ämikken nirepmit täkaŋ. Komi ämaniye nämo itkentäŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Ude täŋiri iwaniye yabäŋ umuntaŋ metäŋpeŋ kuŋitna nintäŋo tuŋum korek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Nibä kätäŋiri sipsip däpmäk täkaŋ ude iwaniyetä nin mäyap nidäpuŋ. Ude täŋiri ämatä komeken kubäkubä kuŋ täna kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Ämawebekaye ninta nadäŋiri äpani-inik täŋpäpäŋ nin iwaniyeta jop yäniŋ kireŋkun. ");
INSERT INTO iou_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Gäk kudän nintä terak pewi ahäŋ nimiŋkuŋo u kaŋpäŋ, äma nintä äbotken nanik nämo unitä yäŋärok niwetpäŋ yäŋpäŋ-nibäŋ mägayäk täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Täŋpewi imaka jopi ude äworeŋitna guŋ äbotken naniktä yäŋpäŋ-nibäŋ niwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Iwanaye ba äma näka kokwawak täk täkaŋ unitä yäŋärok ude yäŋirä mäyäk pähap nadäŋpäŋ umuri nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Jide? Gäka guŋ taŋpäŋ gäkkät topmäk-topmäk kubägän täŋpani u irepmitnapäŋ imaka waki ude pewi ahäŋ nimitak? Nämo, nin ude nämo täŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Gäk gepmaŋpäŋ baga mankata mäde nämo utkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Upäŋkaŋ gäkä nipmaŋpikaŋ nin täŋkentäknin nämo, tom ägwäri bämopiken itkamäŋ. Ba bipmäŋurani pähap gänaŋ ude itkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","21","Nin Anutunin bureni gäk ganiŋ oretta bitnäŋpäŋ kome kubä täŋo anutu jopi-jopi nadäŋ yämiŋkumäŋo yäwänäku uwä gäkku bian nibäŋ ahäwim. Imata, gäk bänep nadäk-nadäknin käbop itkaŋ u kudup nibäwi tärek täyak unita. Upäŋkaŋ ude nämo täŋkumäŋ! ");
INSERT INTO iou_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Nin gäkŋo ämawebekaye itkamäŋ unita yäŋpäŋ kadäni kadäni ninken nanik mäyap nidäpmäk täkaŋ. Ba nibäŋirä sipsip nakta däpmäk täkaŋ ude itkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Unita Ekäni ijiwi kut! Imata dupiŋkaŋ itan? Mäde wari nämo ut nimen. Aku! ");
INSERT INTO iou_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ninta imata käbop it nimitan? Komi bäräpi gänaŋ itkamäŋ ŋonita ninta nämo guŋ täwen. ");
INSERT INTO iou_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Yäke! Däpmäŋ jakŋitpäŋ nipmaŋpä kumbanitä-yäŋ kome terak pätkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Unita äbä täŋkentäŋ nimisi! Gäk nadäŋ nimikinik täk täyan udegän waki keriken itkamäŋ ŋo nimagutsi! ");
INSERT INTO iou_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Kora täŋo nanakiyetä intäjukun ämata gäripi pähap nadäŋpäŋ kap ŋo teŋkuŋ. Man säkgämän säkgämän nadäk-nadäkna-ken tokŋek parirän intäjukun äma u iniŋ ubiŋpäŋ tewayäŋ. Äma meni pidämitä man säkgämän yäŋahäk täkaŋ ude menatä äma ekäni u ŋode iniŋ ubiŋ tekta pidäm täyat; ");
INSERT INTO iou_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Gäk äma säkgämän, man yäkyäkka imaka, gäripi nikek. Äma gäk udewani kubä nämo itak. Bureni, Anututä iron täŋ gamiŋkukotä pen api täŋ gamiŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Gäk intäjukun äma kehäromi pähap, wäpka biŋam ärowani-inik. Unita kehäromika niwoŋärekta päip bohamka iŋitpäŋ isi! ");
INSERT INTO iou_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Kehäromika nikek unitä iwan täŋo kehäromi yäpmäŋ äpäk täyi. Täŋpäŋ man bureni ba kudän siwoŋi unitägän irun yäŋpäŋ täŋ-mehamtak täyi. Kehäromikatä ämik täŋpäŋ iwan däpmäŋirän kaŋpäŋ umun pähap täk täkot! ");
INSERT INTO iou_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Täŋkaŋ tenäŋ kuwek-kuwekkawä päraŋi-inik. U iwankaye yabä-tumäkta nikek. Täŋiri äma äbori äbori gabäŋpäŋ gämotka-kengän maŋ pat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Bureni Anutu, gäk intäjukun-inik itkunonitä api it yäpmäŋ ärowen. Kaŋiwat piäka u kudän siwoŋi terakgän täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Gäk kädet wakita taräki nadäŋpäŋ kädet siwoŋitagän gäripi nadäk täyan. Unita Anutukatä ini gäkä kaŋiwat piä täkta iwoyäŋkuk. Piä ude täkta iwoyäŋkuko unita notkaye yärepmitpäŋ oretoret pähap nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Gäkŋo tek käroŋi kudup käbäŋi säkgämän-inik, jiä däropä käbäŋ ikek bumik. Ba intäjukun äma ätutä gäkä eŋiken abä kap teŋkaŋ ganiŋoret täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Täŋpäkaŋ äma jopi täŋo äperiyetä watä nämo it gamik täkaŋ. Nämo, kome ätu täŋo intäjukun äma täŋo äperiye unitä gäkä eŋiken itkaŋ watä it gamik täkaŋ. Täŋpäkaŋ webekawä omäk meran säkgämän täŋpäŋ dubikaken it täyak. Omäk meran uwä gol mobä säkgämän-inik, Opia komeken nanik upäŋ täŋpani. ");
INSERT INTO iou_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Eruk webeni, gäka ŋode yäŋira nadä; Gäk komekaken nanik ämawebe ba nägät moräkaye mäde ut yämiŋpäŋ unita juku kubä nämo pewen. ");
INSERT INTO iou_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Ude täŋiri intäjukun ämakatä gabäŋgärip täŋpäŋ gäka webe säkgämän yäŋ api gäwerek. Täŋ äpka uwä ekänika unita mani buramiwen. ");
INSERT INTO iou_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Täŋpäkaŋ Tire komeken ban naniktä äbä bänep tägata iron api täŋ gamineŋ, ba tuŋum ämatä gäk ganiŋ oretta api ämneŋ. ");
INSERT INTO iou_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","14","Eruk ämawebe, nadäkot! Intäjukun ämajin täŋo webeni uwä ini eŋi gänaŋ säkgämän, kaŋgärip ikek ude itak. Teki uwä golkät bok täŋpani, unita ägo-ägo weŋirän intäjukun äma dubiniken yäŋikŋat yäpmäŋ kukaŋ. Kuŋirä webe gubaŋ noriye imaka, iwarän täŋirä ugän yäŋ-yäkŋat yäpmäŋ kukaŋ. ");
INSERT INTO iou_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","U kudup, bänep täga pähap nadäŋpäŋ oretoret terak intäjukun äma täŋo eŋi pähap gänaŋ kumaŋ ärokaŋ. ");
INSERT INTO iou_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Täŋpäkaŋ intäjukun ämana, gäka ŋode yäyat; Gäkŋo nanak ämani mäyap ahäŋpäŋ gäk ba oraŋkaye täŋo kome yäpmäŋpäŋ intäjukun äma udegän api itneŋ. Täŋirä ämawebe komeni komeni yabäŋ yäwatta wäpi biŋam ärowani api yämen. ");
INSERT INTO iou_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Täŋpäkaŋ nähä ätu mäden ahänayäŋ täkaŋ unitä nadäŋpäŋ kuŋatneŋta kap ŋo teŋira wäpka biŋamtä punin api kuŋarek. Ude täŋira ämawebe kuduptä wäpka biŋam u tärek-täreki nämo api ganiŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Anutu u nintäŋo äyuŋnin ba nintäŋo kehärominin. Bäräpi gänaŋ täŋkentäŋ nimikta pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Unita nin imaka kubäta nämoinik umuntäne. Nämoinik! Kenäŋ kwaiŋirän kome kwähärep duneŋo uwä täga. Ba pom gwägu bämopiken duŋpeŋ äpmoneŋo u imaka täga. Nämo api umuntäne. ");
INSERT INTO iou_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Ba gwägu pähap mämä taŋi yäŋpäŋ tokätpäŋ porärak pakipaki täŋpek. Täŋirän pom taŋi taŋi wareŋ täneŋo upäŋkaŋ imata umuntäne? Ninä nämoinik api umuntäne! ");
INSERT INTO iou_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","U imata, Anutu täŋo yotpärare bämopiken ume taŋi kubätä pätak. Ume unita ämawebe oretoret pähap nadäk täkaŋ. Yotpärare u kudupi-inik, Anutu ärowani täŋo irit bägup. ");
INSERT INTO iou_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Uken Anututä it täyak unita nämo api wawek. Nämoinik, kepma bipani Anututä watä api it imik täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Bureni, Anutu u kehäromi-inik. Unita äma äbori äbori umun pähap nadäŋpäŋ kujari kwaik täkaŋ. Täŋirä Anututä kärak yäŋirän kometä ume bumik äworewek! ");
INSERT INTO iou_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Upäŋkaŋ ninäwä nämo api umuntäne. Nämo, Ekäni kehäromi mähemi u ninkät it täkamäŋ. Bäräpi kubätä ahäwänä Oranin Jekop täŋo Anutuken käbop täga api itne. ");
INSERT INTO iou_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ai, ämawebe in äbut! Äbäŋpäŋ Ekänitä piä täk täŋkuko u ŋo kawut! Imaka imaka täk täŋkuko u yabäŋpäŋ jäkjäk yamäŋpäŋ nadäwä inide kubä täk täyon! ");
INSERT INTO iou_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Ekäni uwä komeni komeni täŋo ämik däpmäŋ täkŋek täyak. Täŋpäŋ äpa kuwek yäpmäŋpäŋ tokät jukutpäŋ kurepä kädäp gänaŋ ureŋ täŋpän äpmok täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Unita Ekänitä ŋode yäyak; Kwikinik itkaŋ näka ŋode nabäŋpäŋ-nadäwut; Näk Anutu bureni-inik. Näk intäjukun irira ämawebe komeni komeni ittäŋ kukaŋ u gämotna-kengän it täkaŋ. Kome kuduptagän täŋo Ekäni-inik u näk! yäk. ");
INSERT INTO iou_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Unita ämawebe, in ŋode nadäwut! Ekäni kehäromi mähemi, u ninkät it täkamäŋ. Bureni, bäräpi kubätä ahäwänä Oranin Jekop täŋo Anutuken käbop täga itne. ");
INSERT INTO iou_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Ämawebe kuduptagän kap teŋkaŋ ketjin utpäŋ oretoret täk täkot! Täŋkaŋ oretoret gera terak Anutu iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Ekäni ärowani pähap uwä ini pärik-inik kubä itak. Kehäromini uwä umuri pähap. Uwä kome pähap ŋonitäŋo Ekäni ärowani-inik. ");
INSERT INTO iou_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Uwä täŋkentäŋ nimiŋpäŋ guŋ ämawebe äbori äbori unitäŋo kehäromini yäpmäŋ äpäŋpäŋ gämotninken yepmaŋkuk. Täŋkaŋ komeni ninta niniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Täŋpäkaŋ bian Anututä ini kome u iwoyäŋpäŋ nimiŋkuko unita ŋode nadäkamäŋ; Jekop täŋo äboriye ninta nadäŋ nimikinik täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ai, nadäwut! Anututä maŋirani bägupken äroŋkuko itak. Äro irirän ämawebetä bänep pidäm oretoret kap womat mämä terak teŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Eruk! Unita nadäŋpäŋ in imaka, Anututa oretoret kap teŋ imut! Teŋkaŋ iniŋ orerut! Ekäni pähapnin oretoret kap teŋ imut. Äneŋi täwetat; Iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Anutu uwä kome pähap ŋonitäŋo Ekäni ärowani itak unita oretoret kap teŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Anutu ärowani pähap unitä maŋirani bägup kudupiken maŋitkaŋ ämawebe komeni komeni intäjukun-inik it yämiŋpäŋ yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Täŋirän guŋ ämawebe äbori äbori täŋo ärowaniniyekät Abraham täŋo Anutu unitäŋo äbot ninkät käbeyä täk täkamäŋ. U imata, kome täŋo intäjukun äma kudup u Anutu gämori-kengän itkaŋ. Anutu unitäŋo kehärominitä päke u yärepmit moretak! U intäjukuntä intäjuninik itak. ");
INSERT INTO iou_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Ekäni uwä wäpi biŋam ärowani nikek. Unitäŋo yotpärare wäpi Jerusalem u pom kudupi kubä terak itak. Unita yotpärare uken äroŋpäŋ wäpi biŋam yäpmäŋ akuna! ");
INSERT INTO iou_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Saion Pom kudupi uwä käroŋi boham, tägagämän-inik, kaŋoret ikek. Ämawebe kome pähap ŋo nanik kuduptagäntä Anutu täŋo pom u kaŋpäŋ oretoret täk täkaŋ. Täŋpäkaŋ Ekäni Ärowani unitäŋo yotpärare pom u terak itak. ");
INSERT INTO iou_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Anutu uwä kudupi yotpärare u bämopiken itkaŋ ämik kadäniken ämawebe uken nanikta yewa kehäromi täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Bian kome ätu täŋo intäjukun ämatä Saion ämawebekät ämik tänayäŋ yotpärare u dubiniken äbuŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Äbäŋkaŋ yotpärare kudupi u kaŋpäŋ jäkjäk yamäŋpäŋ umuntaŋkaŋ metäŋpeŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Umuntaŋkuŋo uwä komi webetä nanak bäyanayäŋ nadäk täkaŋ ude nadäŋpäŋ kujari kwaiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Ämik tänayäŋ gäpe taŋi taŋi pähap terak äbuŋo u gäkä mänit pähap iniŋ kireŋpewi gäpe uwä yäpmäŋ kärapmit täŋpän kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Täŋpäkaŋ bianä, Anutu täŋo täktäki kehäromi nikek unitäŋo manbiŋamgän nadäk täŋkumäŋonik. Upäŋkaŋ apiŋo dapunintä kaŋpäŋ nadäk täkamäŋ. Ekäni uwä iniken yotpärare ŋo watäni säkgämän irirän kehäromigän pen api it yäpmäŋ ärowek. Yotpärare uwä Ekäninin, Anutu kehäromi mähemitä iniken. ");
INSERT INTO iou_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O Anutu, kudupi yotka gänaŋ äroŋpäŋ ironka tärek-täreki nämo unitäŋo mebärita yäŋpäŋ-nadäk täk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Wäpka biŋam komeni komeni kuŋ moreŋkuko unita ämawebe komeni komenitä udegän ganiŋoret täkaŋ. Täŋpäŋ yabäŋ yäwat piä täk täyan uwä nadäk-nadäk siwoŋi terakgän täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Gäk ämawebe täŋo irit kuŋat-kuŋari u siwoŋigän yäpmäŋ danik täyan unita ämawebe Saion yotpärareken nanik ba yotpärare taŋi täpuri Juda komeken it yäpmäŋ kukaŋ u nanik kudup, oretoret täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","13","Eruk, Anutu täŋo ämawebe, in Anutu täŋo kehäromini kaŋpäŋ nadäna yäŋpäŋä ŋode kaŋ täŋput; Jerusalem yotpärare gägäniken kuŋat äyäŋutpäŋ yewa kehäromikät ämik täŋo tuŋum tuŋum ukät yabäŋpäŋ-nadäwut. Yabäŋpäŋ-nadänayäŋ täŋo unitäŋo biŋam uwä nanakjiye orajiye mäden ahänayäŋ täkaŋ u ŋode kaŋ yäwerut; ");
INSERT INTO iou_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Anutu unitägän nibäŋ niwat täyak. U nintäŋo Anutu, paot-paori nämo. Täŋpäkaŋ unitä kadäni kadäni api nipmäŋit niwarek. ");
INSERT INTO iou_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Äma äbot, kome terak it yäpmäŋ kukaŋ in kudup man ŋo nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Äma wäpjin biŋam nikek ba wäpjin nämo, äma moneŋ ikek ba äma jäwäri, in kuduptagän man täwerayäŋ täyat ŋo juku peŋpäŋ nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Man kädet siwoŋi kubä nadätat u intä nadäneŋta yäŋahäwayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Man siwoŋi u man wärani terak täwerayäŋ. Täwet paotpäŋä man wärani unitäŋo mebäri kap terak api yäŋahäwet. ");
INSERT INTO iou_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Imata äma waki-wakita umuntäwet? Äma uwä moneŋta nadäkinik täk täkaŋ. U näk moneŋ ikek yäŋkaŋ iniken wäpi biŋam yäpmäŋ akuk täkaŋ. Täŋpäkaŋ äma waki udewanitä näk it gwäjiŋpäŋ nutnayäŋ täk täkaŋ. Upäŋkaŋ, äma udewanita imata umuntäwet? ");
INSERT INTO iou_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Moneŋi päke unitä nämo api täŋkentäŋ yämek. Nämoinik! Nin nadäkamäŋ; Äma kubätä iniken gupi moneŋpäŋ täga nämo suwawek. Nämo, äma kubätä irit kehäromi kaŋ-ahäwa yäŋpäŋ Anututa moneŋ peŋ imikimik kädet nämo pätak. ");
INSERT INTO iou_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Nämoinik, äma täŋo gwäki suwak-suwak ärowani pähap. U moneŋ taŋi peneŋo upäŋkaŋ bäräŋeŋ täga nämo pewä tägawek. ");
INSERT INTO iou_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Moneŋ terak äma kubätä irit kehäromi täga nämo kaŋ-ahäwek. Nämo, äma kuduptagän paot-paotta biŋam. ");
INSERT INTO iou_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Bureni nadäkamäŋ. Äma kuduptagän kumäk täkaŋ. Äma nadäk-nadäk ikek kumäk täkaŋ. Ba guŋ ämakät äma kädet goret-goret täŋpani u imaka, kumäk täkaŋ. Kumäŋpäŋ moneŋi peŋirä äma ätutä yäpmäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Bianä, äma udewani komeni nikek. Upäŋkaŋ apiŋo kubäpäŋ äneŋirä kome ukengän paot-paori nämo api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Äma täŋo wäpi biŋamtä kumäk-kumäkita kädet nämo api täŋpipiŋ yämek. Nämoinik! Tomtä kumäk täkaŋ udegän api kumneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Kumäk-kumäk kädet uwä, äma inita nadäkinik täŋpäŋ täga itkamäŋ yäŋ nadäk täkaŋ uken api ahäŋ yämek. U kawut! ");
INSERT INTO iou_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Äma udewani uwä tom udegän, kumäk-kumäk ikek. Kumäŋirä kumäŋ-kumäŋtä watä ämani ude api täŋpek. Äma äneŋpaniken äpmoŋirä gupi bäräŋeŋ paraŋirä ämawebe siwoŋitä Wi! api yäwatneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Täŋpäkaŋ nähä Uraktä nämagutpäŋ kumäŋ-kumäŋ täŋo kehäromiken nanik api wädäŋ tädotpäŋ nepmaŋpek. ");
INSERT INTO iou_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Unita nadäkot! Äma moneŋ tuŋum ikek ba eŋi säkgämän nikek, udewanita ninin jide täŋpäŋ äma ude kaŋ äworene yäŋ nadäwätäk nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Nämoinik! Äma udewani kämi kumäŋkaŋ tuŋumi u yäpmäŋkaŋ täga nämo api kuneŋ. Ba wäpi biŋamikät bok nämo api kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Täŋpäŋ äma udewani kodak itkaŋ kome täŋo tuŋumta gäripi nadäŋpäŋ Anutu täŋo iron terak itkamäŋ yäŋ nadäk täkaŋ. Säkgämän irirä äma ätutä wäpi biŋam yäpmäŋ akuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Upäŋkaŋ äma udewani kumäŋkaŋ, bian äbekiye oraniyetä kumäŋpeŋ päŋku bipmäŋ urani gänaŋ itkuŋken ugän api yäwatneŋ. ");
INSERT INTO iou_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Bureni-inik! Äma moneŋ tuŋum ikek upäkaŋ nadäk-nadäki nämotä irit kehäromita biŋam nämo api täneŋ. Uwä tomtä kumäŋpäŋ parak täkaŋ udewani. ");
INSERT INTO iou_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ai! Ämawebe in nadäwut! Anutu ärowani, Ekäninin unitä man yäwayäŋ täyak. U ämawebe komeni komeni päke unita gera yäyak. ");
INSERT INTO iou_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Anutu täŋo peŋyäŋek kudän Jerusalem yotpärare säkgämän uken naniktä kwawakinik teŋ yäŋetak. U kawut! ");
INSERT INTO iou_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Bureni! Anutunin kehäromi nikek u man yäwayäŋ äbätak. Kädäp mebettä intäjukun kuŋirän iwän mänit pähaptä itgwäjiŋirän äbätak. ");
INSERT INTO iou_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","5","Anututä ämawebeniye täŋo kudän yäpmäŋ daniwayäŋ yäŋpäŋ kunum kenta kometa gera ŋode yäyak; Ek äbä ämawebe naniŋ oret täkaŋ u kuduptagän yämagut päbä iŋamnaken yepmaŋpun yäk. Ämawebe uwä näkkät topmäk-topmäk kubägän täŋpäŋ täŋ-kehäromtakta tom däpmäŋpäŋ ijiŋ namiŋkuŋo u yäk. Eruk, ude täŋpänkaŋ man piä täŋira kaŋ nabäwut yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Anututä ude yäŋirän kunumtä kwawak ŋode yäŋahäk täyak; Anutu ini uwä man yäpmäŋ daniwani äma siwoŋi-inik. Jop man kubä nämo yäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Eruk, Anututä ämawebeniye ŋode yäwetak; Isrel ämawebenaye, juku peŋkaŋ nadäwut! Anutu bureni-inik, intäŋo Anutujin näkŋa in manken tepmaŋpayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Tom käbäŋi nikek ijiŋ namik täkaŋ unita nämo tebetat yäk. Nämo, kadäni kadäni in tom käbäŋi nikek ijiŋ namik täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Upäŋkaŋ ŋode täwera nadäwut; Näk bulimakau ba memeta nämo wäyäkŋek täyat yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","11","Nämoinik, tom ägwäri bipiken itkaŋ, ba bulimakau pomken itkaŋ, barak ba gwakgwak imaka u kuduptagän näkŋogän yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Nakta newäwä inken nämo yäŋapiwet yäk. Nämoinik, kome pähap ba imaka imaka u terak itkaŋ u mähemi näk yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Näk inipärik kubä. Tom koyani ba nägäri nämo nak täyat yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Täŋpäkaŋ naniŋ oretoret kädet bureni gäripi näkä nadäk täyat uwä ŋode; In naniŋ oretpäŋ bänep täga man yäk täkot. Uwä ärawa bureni ude api täŋ namineŋ. Täŋpäŋ Anutu ärowani näka bänep täga täŋ namikta yäk täŋkuŋo uwä bureni täŋ namineŋ! ");
INSERT INTO iou_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","In ude täneŋo uwä bäräpi kubä inken ahäwänä näkken gera yäŋirä näkä in täŋkentäk-inik api täŋpet. Täŋpakaŋ in wäpna biŋam punin api yäpmäŋ akuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Täŋpäkaŋ Anututä äma waki täŋpani man ŋode yäwetak; In jop, mejin-tägän näkŋo baga man ba topmäk-topmäk kubägän u yäŋahäk täkaŋ. Täŋirä nadäwa siwoŋi nämo täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Täŋpäŋ näkä in yäpä tägakta bitnäŋkaŋ kadäni kadäni näkŋo man ut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","In kubo äma yabäŋkaŋ ukät not täŋpeŋ kuŋat täkaŋ. Yabäŋirä intäŋo notjiye ude äworek täkaŋ. Ba ämawebe kubokäretta täŋpani ba nädapitä duŋ-weŋpäŋ ini-ini iranikät not täŋ yämiŋpäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","In mejinta watä nämo itkaŋ man jop manman ba man wakiwaki yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Täŋkaŋ notjiye manken yepmaŋit yäŋpäŋ-yabäŋ yäwarit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Intä ude täŋirä näkä jop dapun tabäŋpäŋ man kubä nämo yäk täyat. Ude täŋira intä Anutu u nin bumik yäŋ nadäk täkaŋ. Upäŋkaŋ nämoinik! Apiŋo tebeŋpäŋ manken kwawak tepmaŋpayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Unita ämawebe näka mäde ut namik täkaŋ, in ŋode nadäwut; In itkaŋ ude pen udegän itpäŋä api waŋ moreneŋ. Täŋkaŋ äma kubätä in täga nämo api täŋkentäŋ tamek. ");
INSERT INTO iou_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Täŋpäkaŋ bänep täga man näwet-näwet unita gäripi nadäk täyat. Unita nadäwa ärawa bureni ude täk täkaŋ. Ämawebe ude täŋ namiŋkaŋ näkŋo man buramik täkaŋ uwä bureni-inik api yämaguret. ");
INSERT INTO iou_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Devit Basiba kubo täŋirän Natantä kaŋ-yäŋkuko unita nadäŋpäŋ man ŋo kudän täŋkuk. Anutu, gäk butewaki mähemi unita näka butewaki nadäŋ namisi. Butewaki nadäŋ namiŋpäŋ wakina kudup ketäreŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ude täŋkaŋ wakiwakina ärut paktaŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Anutu, momi äma näk, wakina unita nadäwätäk täŋpäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Momina uwä ämaken nämo, gäkkengän täŋkut. Imaka u täŋira gäkä nabäŋiri taräki täŋkuk. Unita iŋam man näwetkuno u burenigän näwetkun. Ba täktäkna yäpmäŋ daniŋkuno u siwoŋigän yäpmäŋ daniŋkun. ");
INSERT INTO iou_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Wära! Kädet wakina ŋowä kädet kodaki nämo täyat. Nämo! Näk meŋnatä momikät bok bäyaŋpäŋ nepmaŋkuk. Täŋpänkaŋ momi täŋpani pen udegän it yäpmäŋ äbätat. ");
INSERT INTO iou_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Anutu, gäk näkä jop manman yäkta gäripi nämo nadäk täyan unita gäkŋaken nadäk-nadäk bureni näwoŋäre. ");
INSERT INTO iou_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Täŋpäŋ gäk momina ketäreŋ namiŋiri pakigän-inik ira. ");
INSERT INTO iou_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Bureni Anutu, bäräpi pähap namiŋkuno u ketäreŋ namiŋpäŋ bänep oretoret peŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Momi täŋkuro u ärut paktaŋ namiŋpäŋ momina unita kaŋ täŋguŋta! ");
INSERT INTO iou_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Anutu, gäk bänep pakigän pewi ahäŋ namikot. Bänepna täŋ kodaktaŋ namiŋiri gäkgänpäŋ kaŋ gäwaräntäwa! ");
INSERT INTO iou_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Iŋamkaken nanik näwat kireweno, Anutu. Ba gäkŋaken Munapikka nomägareno! ");
INSERT INTO iou_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Bian gäkŋata biŋam nämaguriri bänep oretoret nadäŋkuro u, apiŋo bänep oretoret udegän täŋ namisi yäŋ nadätat! Gäkŋo man iwatta gäripi pewi ahäŋ namänkaŋ gäkä mehamtäŋ namiŋiri man u buramiwa. ");
INSERT INTO iou_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ude täŋ namiŋiri peŋawäk äma gäkŋo kädet siwoŋi api yäwoŋärewet. Täŋira momi äma udewanitä bänepi api sukureneŋ. ");
INSERT INTO iou_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Anutu, yäpätägak ämana, näk kumäkta biŋam täyat upäŋkaŋ näk kumäŋ-kumäŋ nämo nuren. Ude täŋpayäŋ täno uwä bänep oretoret terak gäkŋo kudän siwoŋi u pen api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ekäni, mena jinom täŋpidäm taŋiri wäpka biŋam yäŋahäŋpäŋ ganiŋ orera! ");
INSERT INTO iou_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Nadätat! Anutu, oraŋ gamikta gupe käbäŋi nikek ijiŋ gamik-gamikta bitnäk täyan. Unita gäripi nadäwipäŋ uyaku ijiŋ gamitet. ");
INSERT INTO iou_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Upäŋkaŋ oraŋ gamik-gamik kädet gäkä gäripi nadäk täyan uwä ŋode; Äma manka buramiŋpäŋ gämotkaken kuŋat täkaŋ unita gäripi nadäk täyan. Näk nadätat, gäk äma iniken momita nadäŋ bäräp täŋpäŋ inita nadäwä äpani täk täkaŋ äma udewanita mäde nämo ut yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Anutu, gäkŋaken gärip iwatpäŋ ämawebe Jerusalem nanik täŋkentäŋ yämiŋiri säkgämän kaŋ irut. Täŋpäŋ Jerusalem täŋo yewa pähap äneŋi täŋkodak taŋpäŋ kaŋ pe! ");
INSERT INTO iou_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ude täŋiri ämatä gupe käbäŋi nikek ijiŋ gamiŋirä gäripi taŋi api nadäwen. ");
INSERT INTO iou_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Devit täŋo iwan kubätä päŋku Sol, Devit Ahimalektä yotken käbop itak yäŋ iwetkuko unita nadäŋpäŋ Devittä kap ŋo teŋkuk. Äma kehäromi gäk, imata täktäkka wakita yäŋbiŋam-biŋam yäŋtäŋ kuŋat täyan? Anutu iŋamiken mäyäk tänaŋipäŋ imata wakika unita biŋam wari wari yäŋtäŋ kuŋat täyan? ");
INSERT INTO iou_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Gäk äma täŋpäwakta nadäk tawaŋ pek täyan. Meka jinom päraŋi-inik, mujuk päraŋ bumik. Jop manman kädet mebäri mebäri pewä ahäkta nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Kudän tägata nadäwi äpani täŋpäpäŋ waki täkta gäripi nadäk täyan. Ba jop manmanta nadäwi ärowani täŋpäpäŋ man burenita gaŋani nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Jop manman yäwani gäk, ämawebe meka jinomtä komi yämikta gäripi pähap nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Unita Anututä gäka komi gamayäŋ täyak u tärek-täreki nämo. U eŋikaken nanik u wädäŋ maŋpän kuŋiri äma itnayäŋ täkaŋ u wari nämo api nadäŋ gamineŋ. ");
INSERT INTO iou_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Anututä ude täŋirän äma siwoŋi kuŋaranitä u kaŋpäŋ api umuntäneŋ. Täŋpäŋ gabäŋ mägayäŋpäŋ ŋode api yäneŋ; ");
INSERT INTO iou_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","U kawut! Äma ŋowä säkgämän itta Anutu terak nämo yeŋgämän pek täŋkukonik. Nämo, moneŋ tuŋumna pähaptä täga täŋkentäŋ namineŋ yäŋ nadäŋpäŋ säkgämän itta waki mebäri mebäri ehutpäŋ täk täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Täŋpäkaŋ nähä olip päya säkgämän Anutu täŋo eŋi dubiniken ärowani ude bumik itat. Täŋpäŋ unitäŋo iron tärek-täreki nämo uterak yeŋgäma pewäpäŋ it täyat. ");
INSERT INTO iou_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Unita Anutu, imaka täŋ namik täyan unita bänep täga man api gäwet yäpmäŋ ärowet. Täŋpäŋ ämawebekaye iŋamiken gäk tägagämän yäŋ yäŋahäŋpäŋ api yäwet täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Äma Anutu nämo itak yäŋ yäk täkaŋ uwä guŋ bureni-inik! Äma udewani bänepi käbäŋ täwani. U kudän waki mebäri mebäri täk täkaŋ. Kubätä kudän täga kubä nämoinik täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Nadäkaŋ? Anututä kunum terak ununitä etä päpä dapun pärewat täk täyak. U äma nadäk-nadäk täga nikek näk naniŋ orerani udewani ätu itkaŋ ba yäŋ nadäŋpäŋ yabäŋ ahäkta dapun pärewat täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Upäŋkaŋ nämo, kudup u kädet siwoŋi irepmit moreŋpäŋ kädet waki täŋpanigän. Uken nanik kubätä kudän täga kubä nämoinik täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Unita Anututä ŋode yäyak; Jide? Ämawebe udewani uwä nadäk-nadäki nämo ba? U näkŋo ämawebenaye uken täŋyäkŋatpäŋ kubota pidämigän täŋ yämik täkaŋ. Ude täŋkaŋ näkken yäŋapik man kubä nämoinik yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Upäŋkaŋ umuri pähap kubä api nadäneŋ. Bian umun udewani kubä nämoinik nadäŋkuŋ. Anututä ämawebeniye täŋo iwan kudup däpmäŋpäŋ kujari api ureŋ täŋpän kuneŋ. Bureni, Anututä mäde ut yämiŋkuko unita Isreltä iwaniye u täŋpäwakinik api täŋ yämineŋ. ");
INSERT INTO iou_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Eruk, Anututä Isrel ämawebe täŋkentäŋ yämikta äma kubä Saion nanik pewän äbän yäŋ nadätat. Anututä ude täŋirän äneŋi säkgämän itnayäŋ täkaŋ unita oretoret pähap api nadäneŋ! ");
INSERT INTO iou_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Sifa nanik ätutä päŋku Sol, Devit nintä komeken käbop käwep itak yäŋ iwetkuŋo unita nadäŋpäŋ Devittä kap ŋo teŋkuk. Anutu, kehäromika terak iwan keriken nanik nämagutpäŋ nepmaŋpi äneŋi säkgämän kaŋ kuŋara. ");
INSERT INTO iou_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Gäkken yäŋapiŋira juku peŋpäŋ nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Äma komi komi ba peŋawäk täŋpanitä näk kumäŋ-kumäŋ nutnayäŋ äbäkaŋ. Äma udewanitä Anututa nadäŋirä jopi täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Täŋpäkaŋ Anutu iniwä täŋkentäŋ namik täyak. Intäjukun ämanatä watä säkgämän it namiŋirän täga it täyat. ");
INSERT INTO iou_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Nämo nepmak täyak unita iwan komitä näka täŋ namik täkaŋ ugänpäŋ Uraktä äyäŋutpäŋ kowata udegän yämiŋirän paot-inik api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","O Ekäni, gäk tägagämän unita bänep täga man gäwetpäŋ iron kowata täŋ gamayäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","O Ekäni, gäk täŋkentäŋ namiŋiri bäräpi yabäŋ ahäŋkuro u kudup paot moreŋkuŋ. Täŋpäŋ yabäŋira gäkä iwanaye kuduptagän däpmäŋ moreŋkun. ");
INSERT INTO iou_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","O Anutu, yäŋapik mannata juku peŋpäŋ nadä. Butewaki terak gäwet yabäŋira mäde nämo ut namen! ");
INSERT INTO iou_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Nämo, juku peŋpäŋ kowata näwet. Imata, nadäwätäknatä kehäromina kudup yäpmäŋ äpätak. ");
INSERT INTO iou_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Iwanayetä umun man näwerirä bumta umuntaŋ itat. Äma waki täŋpani uwä näka gaŋani nadäŋpäŋ kokwawak nadäŋ namik täkaŋ unita nadäŋ bäräp taŋi täyat. ");
INSERT INTO iou_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","5","Bänepnatä komi inide kubä nadätat. Kujatna bumta kwaiwäkaŋ umun pähap nadätat ŋonitä täga nurek yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Unita ŋode nadätat; Näk pitna nikek täŋpän yäwänäku barak ude orek itta piäŋ päŋku kubäken itet. ");
INSERT INTO iou_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Ban kubäken-inik piäŋ päŋku kome ämani nämoken täha bägup täŋpäŋ itet. ");
INSERT INTO iou_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ude täŋkaŋ umuri ahäŋ namitak ŋonita uken käbop itet. ");
INSERT INTO iou_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Unita intäjukun ämana bureni, iwanaye täŋo man yäkyäki täŋ-kuruktaŋ yämi. Imata, yotpärare taŋiken ämatä ämik kowata kowata täŋkaŋ ut täpätet mämä bumta täŋirä yabätat. ");
INSERT INTO iou_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","U kepma bipani yotpärare u yewa täŋpäŋ it gwäjiŋkaŋ ämik ba kubota kudän bumta pewä ahäŋpäŋ tokŋeŋ pätak. ");
INSERT INTO iou_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Täŋpäkaŋ waki kädet mebäri mebäritä uken-uken kudup ahäŋ pätak. Yotpärare gänaŋ kädet täpuri täpuriken täŋyäkŋat-yäkŋat ba komi jop nadäŋ yämik-yämik kädettä udegän pätak. ");
INSERT INTO iou_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Butewaki pähap! Iwan kubätä yäŋärok ude näwet täŋpän yäwänäku täga bumik nadätet. Ba kubäken nanik kubätä näka ude täŋ namän yäwänäku käbop päŋku täga itet. ");
INSERT INTO iou_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Upäŋkaŋ waki, notnapak bureni-inik, imaka imaka bokgän täŋpani gäkä ude täŋ namitan! ");
INSERT INTO iou_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Nek iŋam kowat-kawän täŋpäŋ man yäŋpäŋ-nadäk säkgämän täŋkaŋ Anutu iniŋ oretta kudupi yotken bokgän kuk täŋkumäko upäŋ udewä täyan. ");
INSERT INTO iou_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Unita iwanaye täŋo kadänini nämo täreŋirän kaŋ paorut! Ba kodak itpäŋ kumbani komeken kaŋ äpmoŋput! Imata, kudän wakiwakitä äma udewanikät kentäŋpäŋ it-inik täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Upäŋkaŋ näk Ekäni Anutuken gera yäŋira api täŋkentäŋ namek. ");
INSERT INTO iou_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Tamimaŋ ba kepma bipani bäräpinata nadäŋpäŋ yäŋapik-apik gerana uken pewa äroŋirän api nadäŋ namek. ");
INSERT INTO iou_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ude täŋkaŋ ämik pähap gänaŋ iwanaye mäyapkät ämik tänayäŋ täkamäŋken uken nanik äneŋi säkgämän nämagut yäpmäŋ api äbek. ");
INSERT INTO iou_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Bureni, Anutu intäjukun itpäŋ kaŋiwat piä ärowani täŋ yäpmäŋ äbukotä itak, pen api it yäpmäŋ äroweko unitä yäŋapik manna nadäŋ namiŋpäŋ iwanaye komi piäken api yepmaŋpek. Imata, äma uwä Anututa nämo umuntaŋkaŋ kädet wakita mäde utta bitnäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Täŋpäkaŋ notnapak iwan täŋ namani unitä yäŋkehäromtak mani irepmitpäŋ noriye mäyapta iwan täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Menitä gakŋi ärut namik täyak upäŋkaŋ bänepitä näka kokwawak namik täyak. Mani säkgämän, gakŋi nikek upäŋkaŋ päip päraŋi udewani. ");
INSERT INTO iou_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Unita ämawebenaye, ŋode täwera nadäwut; Ekänitä äma siwoŋi yabäŋ äwaräkuk täŋirän iwaniyetä täga nämo yärepmitneŋ. Unita nadäŋ bäräpjin kudup Ekänikengän peŋirä api täŋkentäŋ tamek. ");
INSERT INTO iou_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Täŋpäkaŋ Anutu, gäk äma kumäŋ-kumäŋ däpani ba jop manman yäwani unitäŋo irit kuŋat-kuŋari kudup nämo täreŋirän yäŋ-yäkŋat yäpmäŋ päŋku ini awaŋ gänaŋ api yepmaŋpen. Täŋ nähä gäka nadäŋ gamikinik pen api täŋ yäpmäŋ ärowet. ");
INSERT INTO iou_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Filistia naniktä Devit Gat komeken iŋitkuŋo unita nadäŋpäŋ kap ŋo teŋkuk. O Anutu, iwanaye jop nadäŋ komi wari wari namik täkaŋ unita butewaki nadäŋ namiŋpäŋ täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Yäŋetak bipmäŋtak iwanaye nutnayäŋ täk täkaŋ. Iwanaye u yarägän nämo, mäyap-inik. ");
INSERT INTO iou_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Ude täŋirä umuntaŋpäŋ, Ekäni ärowani, gäkä terak tubeŋ kuŋpäŋ it täyat. ");
INSERT INTO iou_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Bureni, Anutu terak tubeŋ kuŋpäŋä nämo umuntak täyat. Nämo, täŋkentäŋ namikta yäŋkehäromtak man yäŋkuko u juku piŋpäŋ iniŋoret täyat. Ude täŋira ämatä imaka kubä täŋ namikta nämo umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Täŋpäkaŋ kepma kepma iwanayetä bäräpi mebäri mebäri namik täkaŋ. U täga kubä täŋ namikta nämo nadäk täkaŋ. Nämo, waki täŋ namiktagän yäŋpäŋ-nadäk täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","U kubäkengän päŋku käbop itpäŋ näk nutta yäŋpäŋ-nadäk täŋkaŋ nabäŋ näwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Unita Anutu, wakinita kowata komi piäken yepmaŋ! Yabäŋ koreweno! Kokwawakka terak kehäromini däpmäŋ tokät yämi. ");
INSERT INTO iou_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Näk bäräpi gänaŋ jide itat u kudup nadäŋ namitan. Ba konämna pito jide mäŋkaŋ u kudup daniŋpäŋ nadäk täyan. Bureni, u kudup tawaŋ terak kudän täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Unita Anutu, gäkken gera yäwayäŋ täyatken nadäŋ namiŋiri iwanaye nabäŋ umuntaŋpäŋ äneŋi äyäŋutpeŋ api kuneŋ. Ude täŋiri ŋode kaŋpäŋ api nadäwet; Anutu näk gärak itak yäŋ api nadäwet. ");
INSERT INTO iou_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ekäni uwä täŋkentäŋ namikta yäŋkehäromtak man yäŋkuko u juku piŋpäŋ iniŋoret täyat. ");
INSERT INTO iou_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ude täŋpäŋ Anutu terak tubeŋ kuŋpäŋä nämo umuntak täyat. Bureni, ämatä imaka kubä täŋ namikta nämo umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Unita Anutu, imaka gamikta yäŋkehärom taŋkuro u bureni api gamet. Uwä bänep täga man yäŋpäŋ api gamet. ");
INSERT INTO iou_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","U imata, näk awaŋ pomiken nanik nämagutkuno unita. Eruk, apiŋo Anutu iŋamiken irit täŋo peŋyäŋek gänaŋ itat. ");
INSERT INTO iou_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Devittä Solta umuntaŋpäŋ metäŋpeŋ päŋku mobä käwut kubä gänaŋ käbop itkukken uken kap ŋo teŋkuk. O Anutu, näk watä it nami yäŋpäŋ dubikaken äretat unita butewaki nadäŋ namisi. Jirokaken äyuŋ täŋ namiŋ yäpmäŋ kuŋiri imaka umuri näk täŋpäwakta itak ŋo kaŋ paorän! ");
INSERT INTO iou_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Näk Anutu täŋpämorek mähemiken täŋkentäk yäpmäkta gera yäyat. Anutu u täŋkentäŋ namiŋirän imaka kubäta nämo wäyäkŋek täyat. ");
INSERT INTO iou_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Unita nadätat; Anututä näka nadäŋ namikinik täŋpäŋ nämo nepmak täyak. Nämo! U kunum gänaŋ itkaŋ näkŋo yäŋapik manna nadäŋpäŋ wakiken nanik api nämagurek. Nämagutpäŋ iwanaye täŋo kehäromi api yäpmäŋ äpek. ");
INSERT INTO iou_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Aŋ ägwäri, äma yeŋpäŋ näŋpanitä-yäŋ näk it gwäjikaŋ. Meni uwä päraŋi-inik, tenäŋ kenta boham udewani. Täŋkaŋ meberi uwä päip päraŋi ude. ");
INSERT INTO iou_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Unita Anutu, wäpka biŋam ärowani kwawak pewi kunum gänaŋ ba komeni komeni ahäŋirän ämawebe kuduptagän kaŋ kaŋpäŋ nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Nadätan? Iwantä näk nepmäŋitta buŋep näkä kädetken täŋpäŋ peŋkuŋo unita nadäŋ bäräptä näkŋo kehäromina kudup yäpmäŋ äpätak. Täŋpäkaŋ wisik! Näk nepmäŋitta buŋep täŋkuŋo unitä äyäŋutpäŋ ini yepmäŋitkuk! ");
INSERT INTO iou_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O Anutu, bänepnatä gäka nadäkinik kehäromi täŋ gamitat unita kap terak ganiŋoret täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Eruk bänepna, pidäm täyi! Täŋkaŋ wagäm gita in udegän, kap tekta pidäm täkot! Pidäm taŋpäŋ kome nämo yäŋeŋirän kap tena! ");
INSERT INTO iou_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Ekäni, wäpka käbop nämo api pewet! Nämo, ämawebe gäka nämo nadäk täkaŋ u bämopiken bänep täga terak wäpka biŋam api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Täŋpäkaŋ Anutu, gäkä ninta butewaki nadäŋ nimik täyan u käroŋi boham, kunum yäpureko ude bumik. Täŋkaŋ ninta nadäŋ nimikinik täk täyan u ärowani. ");
INSERT INTO iou_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Unita Anutu, wäpka biŋam ärowani kwawak pewi kunum gänaŋ ba komeni komeni ahäŋirän ämawebe kuduptagän kaŋ kaŋpäŋ nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Intäjukun äma, in man yäpmäŋ danik piä täk täkaŋ u siwoŋi täk täkaŋ ba nämo? Täŋkaŋ man siwoŋi burenigän yäk täkaŋ ba nämo? ");
INSERT INTO iou_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Nämoinik! Waki jide täkta nadäk täkaŋ ugänpäŋ täk täkaŋ. Ude täŋkaŋ ämata komi jop nadäŋ bumta yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Äma waki udewani goretgän kuŋat täkaŋ. Uwä jop manman yäkyäk kädet pengän ahäŋpäŋ yäwanitä yäŋtäŋ äbäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Meni jinom u komi, gämok komi täŋo meni ude. Ba jukuni pik täŋpani. ");
INSERT INTO iou_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","U but ägwäri bumik. Mähemitä man yäŋirän täga nämo nadäwek. Iniken gärip terakgän kuŋarek. ");
INSERT INTO iou_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Eruk Anutu, aŋ komi umuri ŋonitäŋo meni däpmäŋ tokät täŋpi kut. ");
INSERT INTO iou_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Ude täŋiri ume madäŋpewä kuk täkaŋ ude kuŋpäŋ paot-inik kaŋ täŋput. Ba mup kädet miŋin ämatä yeŋ gatäk täkaŋ ude yeŋ gatäwut. ");
INSERT INTO iou_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","U gatäk-kubit yeŋ kokoyäŋ täŋpä kuk täkaŋ ude yeŋ kokoyäwut. Ba nanak paki meŋ koki gänaŋ kumäŋkaŋ ahäŋpäŋ dupik ikek pat täkaŋ ude kaŋ äworewut. ");
INSERT INTO iou_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ba mup däpmäŋ täkŋek täkaŋ ude nämo nadäŋirä bäräŋek-inik kaŋ däpmäŋ täkŋeŋ täŋpä kut. Bureni, Anututä iniken kokwawaki pähap terak pen irirä api piäŋ äreyäŋ täŋpän kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Täŋpäkaŋ waki täŋpanitä komi nadäŋirä äma siwoŋitä yabäŋkaŋ oretoret api täneŋ. Täŋpäŋ waki täŋpani täŋo nägät gwägu ude tokŋeŋirän äma siwoŋi kuroŋitä api yeŋ weneŋ. ");
INSERT INTO iou_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Ude ahäŋirän ämawebe ätutä api yäneŋ; Siwoŋi ämawebe gwäki täga bureni-inik yäpmäk täkaŋ. Apiŋo nadäkamäŋ; Anutu kubä unitägän ämawebe kuduptagän kädet siwoŋi terakgän yäpmäŋ danik täyak. Ude api yäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Soltä komi ämaniye ätu Devit kumäŋ-kumäŋ utta yäwerän päŋku yot yämaken jämjäm patkuŋo unita nadäŋpäŋ kap ŋo teŋkuk. Anutuna, watä it namiŋpäŋ iwan nutnayäŋ wari wari äbäk täkaŋ unita itpipiŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Äma wakiinik, äma kumäŋ-kumäŋ däpani u bämopiken nanik nämagusi! ");
INSERT INTO iou_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","U yabä! Äma komi komi u änok kubägän itpäŋ näk nutta itsämäŋkaŋ u. Uwä näkä momi ba goret kubä täŋkuro unita nämo. ");
INSERT INTO iou_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Nämo! Ekäni, näk waki kubä nämo täŋira näk nutta bäräŋeŋ äbäkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Unita Ekäni Anutu ärowani, gäk kikŋutpäŋ bäräŋeŋ äbä täŋkentäŋ namisi. Isrel täŋo Anutu gäk äbä äma waki täŋ namik täkaŋ u kaŋ yabäŋpäŋ-nadä! Ude täŋkaŋ guŋ äbot, äbori äboriken nanik äma wakiinik täŋpani ŋo komi yämiŋkaŋ nämo yabäŋ korewen. ");
INSERT INTO iou_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Äma uwä bipani bipani aŋtä-yäŋ yäŋgera-gera yäŋkaŋ yotpärare gänaŋ käbop käbop kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Man komi komi ba yäŋärok man yäk täkaŋ unita juku peŋpäŋ nadäsi. Meni jinom uwä päraŋi-inik, päip bumik. Täŋkaŋ äma kubä nämo nibäŋpäŋ nadätak yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Upäŋkaŋ nämo! Ekäni gäk guŋ äbot u yäŋärok yäwetpäŋ yabäŋ mägayäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Ude täŋiri unita kehäromikata nadäkinik täyat. O Anutu, gäk käbop irit mobä käwutna. ");
INSERT INTO iou_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Ämawebe, in nadäkaŋ? Anutuna uwä nadäŋ namikinik täŋpäŋ dubinaken äbä it namiŋirän iwanaye täŋo kehäromini api yäpmäŋ äpäŋ morewet. ");
INSERT INTO iou_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Täŋpäkaŋ Anutu, kumäŋ-kumäŋ bäräŋeŋ nämo däpen. Ude täŋpayäŋ täno uwä ämawebenayetä gäkŋo kehäromikata bäräŋeŋ guŋ täneŋta. Unita Ekäni watä ämanin, kehäromika terak kehäromini yäpmäŋ äpäŋpäŋ jop yäwat kireŋpewi kaŋ kuŋtäŋpä kut. ");
INSERT INTO iou_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Äma uwä meni jinomken, man yäkyäkiken u momi täktäk täŋo man ugänpäŋ yäk täkaŋ unita ärowani kudän unitä äyäŋutpäŋ buŋeptä-yäŋ yepmäŋiton. ");
INSERT INTO iou_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Täŋpäkaŋ man wakiwaki ba jop manman yäk täkaŋ unita yäŋpäŋ kokwawakka terak kumän-inik kaŋ täŋpi wawut. Ude täŋiri ämawebe kudup ŋode api nadäneŋ; Anututä Isrel ämawebe uwä yabäŋ yäwat täyak. Täŋpäŋ ugän nämo. Kome pähap pat yäpmäŋ kuyak u kudup kaŋiwat täyak yäŋ api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Iwanaye uwä bipani bipani aŋtä-yäŋ yäŋgera-gera yäŋkaŋ yotpärare gänaŋ käbop käbop kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","U aŋtä ketem naŋpäŋ nämo tokŋewäpäŋ ijiŋtäŋ kuŋat täkaŋ ude kuŋatkaŋ nakta yewäpäŋ yäŋkähän-kähän yäŋtäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Täŋpäkaŋ nähä kehäromikata yäŋpäŋ kap terak ganiŋ ubiŋ api tek täŋpet. Tamimaŋ tamimaŋ näka nadäŋ namikinik täk täyan unita nadäŋpäŋ kap kwawakgän api tek täŋpet. U imata, gäk käbop irit mobä käwutna ude it namik täyan. Ba bäräpi kadäniken äyuŋ täŋ namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Unita Anutu itkentäkna, gäk wäpka api ganiŋoret täŋpet. Gäk käbop irit mobä käwutna unita. Anutu, gäk nadäŋ namikinik täŋpani Anutuna. ");
INSERT INTO iou_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Anutu, gäk mäde ut nimiŋpäŋ kehärominin kudup yäpmäŋ äpäŋ moretan. Gäk kokwawak nadäŋ nimiŋkunopäŋ apiŋo äneŋi nimagut. ");
INSERT INTO iou_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Gäkä ude täŋ nimiŋkuno uwä täŋpewi kome kwaiŋpäŋ kudup duŋ-weko ude bumik. Unita äneŋi yäpi tägawut! ");
INSERT INTO iou_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ämawebekaye ninta bäräpi taŋi nimiŋiri, ämatä wain ume naŋpäŋ täŋguŋguŋ täk täkaŋ ude täŋtäŋ kuŋatkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Upäŋkaŋ ämawebe gäk gämotkaken kuŋat täkaŋ unitä kakta kudän kubä kwawak peŋkun. U kaŋpäŋ nadäŋpäŋ iwan yärepmitpäŋ gäkken säkgämän itta bäräŋeŋ päŋku dubinaken irut yäŋpäŋ ude täŋkun. ");
INSERT INTO iou_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Unita yäŋapik mannin nadäŋ nimiŋpäŋ ketka kehäromitä täŋkentäŋ nimi. Ude täŋiri ämawebe gäkŋa gäripi nadäŋ nimik täyan nin säkgämän kaŋ itna. ");
INSERT INTO iou_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Anutu ini eŋiken itkaŋ ŋode yäŋkuk; Iwan täŋo kehäromi kudup yäpmäŋ äpäŋ moreŋpäŋ oretoret terak ŋode api täŋpet; Sekem kenta Sukot kome yäpmäŋ daniŋpäŋ ämawebenayeta api yämet yäk. ");
INSERT INTO iou_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Täŋpäŋ ugän nämo. Gileat Manase kome u imaka, näkŋo. Täŋkaŋ Efraim kome u näkŋo kurepä ude, ba Juda kome u kehäromina kwawak pewä ahäwani yäk. ");
INSERT INTO iou_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Täŋpäkaŋ Moap kenta Idom kometä watä piä täŋ namik täkaŋ. Täŋkaŋ Filistia nanik täŋo kehäromini yäpmäŋ äpäŋpäŋ oretoret täyat yäk. ");
INSERT INTO iou_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Eruk Anutu, netätä yotpärare yewa kehäromi nikek, Idom komeken itak uken ämik täkta nämagut yäpmäŋ kwek? ");
INSERT INTO iou_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Nämo! Gäk mäde ut nimiŋkuno unita jop itkamäŋ. Gäk imata nintäŋo komi ämakät ämikken bok kukta gaŋa täk täyan? ");
INSERT INTO iou_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Eruk Anutu, gäk täŋkentäŋ nimiŋiri uyaku iwan täga däpmäŋpäŋ yäwat kirene. Ämatä täŋkentäk täk täkaŋ u jopi, kehäromini nämo. ");
INSERT INTO iou_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Unita nadäkamäŋ! Anutu, gäkkät bok uyaku iwan täŋo kehäromini täga api yäpmäŋ äpne! ");
INSERT INTO iou_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","O Anutu, näk gäkken gera yäŋira nadäŋ nami! Ba yäŋapik mannata juku peyi. ");
INSERT INTO iou_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Komena peŋpeŋ päŋku kome gägäni käda itpäŋ nadäŋ bäräp täyat. Unita gäkä täŋkentäŋ nam yäŋ nadäŋpäŋ gäkken gera yäyat. Gäkä äbä nämagut päŋku pom migupi terak ude bumik nepmaŋiri iwantä näk täŋpä waneŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","O Anutu gäk kubä-tägän watä säkgämän it namik täyan. Ba gäk kubä-tägän yewa kehäromi täŋ namiŋiri iwantä täga nämo nutneŋ. ");
INSERT INTO iou_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Unita gäk nadäŋ namiŋiri dubikaken tärek-täreki nämo kaŋ it yäpmäŋ ärowa. Barak miŋitä nanaki piri gänaŋ uyiŋ-piŋitpäŋ pat täkaŋ ude täŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O Anutu, imaka imaka täkta gäkken yäŋkehäromtak man yäŋira nadäŋkun. Täŋpäŋ ämawebe gäk ganiŋoret täkaŋ unita imaka imaka yämikta yäŋkehäromtak man yäŋkuno udegän näka imaka, namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Unita Anutu, Intäjukun äma täŋkentäŋ imiŋiri kome terak ŋo kadäni käroŋi kaŋ it yäpmäŋ ärowän. ");
INSERT INTO iou_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Uwä gäk iŋamkaken irit bägupiken kehäromigän kaŋ irän. Täŋpäŋ iron gäkä nanik unitä täŋkentäŋ imiŋirän kaŋ kuŋarän. Ba watä it imiŋpäŋ nämo tewen. ");
INSERT INTO iou_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Ude täŋiri yäŋkehäromtak man yäŋkuro uwä nämo api guŋ täwet. Täŋkaŋ kepma kepma kap terak wäpka api ganiŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Täŋkentäŋ namikta Anutu unitagän kwikinik itsämäk täyat. U kubä terakgän yeŋgäma pek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","U kubä-tägän nabäŋ näwatpäŋ wakiken nanik nämagut täyak. U näk gärak irirän iwanayetä näk täga nämo api närepmitneŋ. ");
INSERT INTO iou_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Eruk iwanaye, in ŋode yäŋira kowata näwerä nadäwa; Näk nutta wari wari api täk täneŋ ba? Näk kehäromina nikek nämo, yewa yeŋ wewani udewani unita näk täŋpäwakta täk täkaŋ u jidegän api peneŋ? Kowata näwerut! ");
INSERT INTO iou_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Ämawebe naniŋ oret täkaŋ upäŋkaŋ inä wäpna biŋam yäpmäŋ äpäktagän nadäk täkaŋ. Täŋpäŋ jop yäŋnäkŋatta gäripi nadäk täkaŋ. Täŋkaŋ mejintäwä man säkgämän näwet täkaŋ upäŋkaŋ bänepjin-täwä ini kaŋ wawän yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Upäŋkaŋ jop uken! Anutu kubä uterakgän yeŋgäma pek täkaŋ. U kubä-tägän täŋkentäŋ namikta itsämäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","U kubä-tägän nabäŋ näwatpäŋ wakiken nanik nämagut täyak. U näk gärak irirän iwanayetä näk täga nämo api närepmitneŋ. ");
INSERT INTO iou_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Täŋpäŋ Anutu unitägän täga api nämagurek, ba wäp biŋam api namek yäŋ nadäŋpäŋ it täyat. U kubä-tägän watä kehäromi it namiŋpäŋ käbop nepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Unita ämawebenaye, kadäni kadäni Anutu terakgän yeŋgämä pek täkot. U käbop irit mobä käwutnin unita nadäŋ bäräpjin u ba u kudup yäŋahäŋpäŋ iwet täkot. ");
INSERT INTO iou_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Täŋpäkaŋ ämawä imaka jopi, me woŋ bumik. Äpani ba ärowani u kubägän, jopigän. Anutu iŋamiken imaka bäräpi-inik nämo, pidämi-inik, ehät woŋ ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Unita moneŋ tuŋum terak nadäk kehäromi nämo peneŋ. Äma täŋyäkŋatpäŋ tuŋumi nämo kubo täneŋ. Nämo, kädet udewani terak imaka bureni kubä nämo api kaŋ-ahäneŋ. Ba moneŋ tuŋumjin taŋi pat tamineŋo upäŋkaŋ uniterak nämo yeŋgämä pewäpäŋ itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Ude nämo! Anututä man ŋode yäkgän täŋirän nadäŋkut; Kehäromi mähemi u Anutu näkŋa itat yäk. ");
INSERT INTO iou_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Bureni Ekäni, nadäŋ nimikinik täk täyan uwä siwoŋi uterakgän. Gäkŋa-tägän ämawebe kudup täktäki terak gwäki kowata yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Devit Juda kome kawukiken kuŋatkaŋ kap ŋo teŋkuk. Anutu, gäk näkŋo Anutu. Gäkagän gäripi nadäk täyat. Näk dubikaken itta bänepnatä etä itak. Äma kome kawukiken kuŋatkaŋ umeta wakiinik yek täkaŋ, näk gäka udegän nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Nadäŋ namiŋiri kudupi yotken äroŋpäŋ gäk gabäwa! Äroŋira kehäromika ba wäpka biŋam säkgämän kaŋ näwoŋäre! ");
INSERT INTO iou_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Anutu, gäkä iron täŋ namik täyan unitä kome terak irit täŋo gäripi u irepmit täyak. Ude täŋ namik täyan unita ganiŋ oretat. ");
INSERT INTO iou_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Täŋkaŋ kome ŋo terak irayäŋ täyat udegän ganiŋ orettäŋgän api paoret. Ba ketna yäpmäŋ akuŋpäŋ gäkkengän yäŋapik man api yäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Anutu, gäk mäjona towiŋiri säkgämän it täyat, ämatä ketem gäripi nikek naŋkaŋ it täkaŋ ude. Unita oretoret täŋpäŋ menatä kap terak api ganiŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Bipani, patpat bägupnaken kadäni käroŋi gäka nadäŋ gamiŋkaŋ pat täyat. ");
INSERT INTO iou_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Bureni Anutu, gäk täŋkentäkna. Unita gäkä nabäŋ näwariri jirokka gänaŋ oretoret kap teŋpäŋ pat täyat. ");
INSERT INTO iou_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Näk gäk tubeŋ kuŋira ketka bure kädatä täŋ-mehamtaŋ namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Ude täŋkentäŋ namik täyan unita äma ätutä nutnayäŋ täkaŋ unita näk ŋode nadätat; Äma udewani täŋpä wawäpäŋ kumäŋ-kumäŋ komeken api äpmoneŋ! ");
INSERT INTO iou_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Bureni, ämik ahäŋirän iwanaye u paorirä aŋ ägwäritä tohari api naŋ paotneŋ. ");
INSERT INTO iou_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Täŋpäkaŋ Juda täŋo intäjukun äma näk, Anututa bänep täga api nadäŋ yäpmäŋ ärowet. Täŋira äma Anutu täŋo wäpi terakgän it täkaŋ, u kuduptagäntä Anutu api iniŋ oretneŋ. Täŋ Anututä jop manman yäwani unitäŋo meni täŋpipiŋirän mankum-inik api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Eruk Anutu, näk bäräpi terak itat unita butewaki gerana ŋo nadäŋ nami! Iwanayeta bumta umuntak täyat unita watä it namiŋiri paoretawä. ");
INSERT INTO iou_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Äma wakiwaki komi namikta änok änok kuŋatkaŋ yäŋpäŋ-nadäk täk täkaŋ unita itpipiŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Äma uwä meberi päraŋi-inik, päip wädäwani ude. Man yäk täkaŋ u tenäŋ ukeŋo ude namäkta gwäjik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","U jop manman yäkta mäyäkkät nämo pidämigän yäŋtäŋ kuŋat täkaŋ. U yäŋpäŋ-yabäŋ yäwat man terak äma täga täŋpäwakta bätakigän nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Waki täkta täŋkentäk-kentäk terak täk täkaŋ. Täŋpäŋ äma yepmäŋitta buŋep udeken udeken kaŋ täna yäŋ yäŋpäŋ-nadäŋpäŋ ŋode yäk täkaŋ; Täŋitna ämatä täga nämo nibäneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Bureni, waki täkta yäŋpäŋ-nadäŋpäŋ ŋode yäk täkaŋ; Tawaŋ pekamäŋ ŋo säkgämän täkamäŋ yäk. Ämatä wärämutnaŋi nämo yäŋ yäk täkaŋ. Yäke! Äma täŋo bänep nadäk-nadäkken waki pätak u nadäwä tärenaŋi nämo! ");
INSERT INTO iou_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Upäŋkaŋ äma udewaniwä Anututä tenäŋpäŋ yamäŋirän jibi bäräŋeŋ api yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Meni jinom komi unita yäŋpäŋ täŋpän waŋirä äma u yabäŋkaŋ wisik yäŋ api yäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ude täŋirän kaŋkaŋ ämawebe kuduptagäntä umuntaŋpäŋ Anutu täŋo täktäki unita pen juku piŋpäŋ biŋami api yäŋtäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Bureni-inik, Anututä ude täŋirän ämawebe siwoŋitä kaŋkaŋ oretoret täŋpeŋ säkgämän itta uken api kuneŋ. Täŋkaŋ ämawebe tägatäga u Anutu api iniŋoret täneŋ! ");
INSERT INTO iou_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Anutu, nin pomka wäpi Saion u äroŋpäŋ wäpka ganiŋ oretpäŋ imaka imaka täŋ gamikta yäŋkehäromtak man yäŋkumäŋo u nämowä nämo api täne. ");
INSERT INTO iou_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Gäk komen äma nintäŋo yäŋapik man nadäŋ nimik täyan unita ämawebe kuduptagän ganiŋ oretta gäkkengän äpi ärenek. ");
INSERT INTO iou_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Täŋkaŋ momininta nadäŋpäŋ mäyäk nadäwätäk pähap täk täkamäŋ upäŋkaŋ Anutu gäkä mominin peŋ nimik täyan. ");
INSERT INTO iou_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bureni Anutu, äma gäkŋa iwoyäŋpäŋ eŋikaken yäŋ-yäkŋat yäpmäŋ kuk täyan, äma udewani oretoret terak kuŋat täkaŋ. Imata, kudupi yotka u gänaŋ imaka gäripi mebäri mebäri itkaŋ u nimik täyan unita. ");
INSERT INTO iou_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Anutu, nin gäkken yäŋapiŋitna gäkŋa-tägän äneŋi nimagut täyan. Täŋiri säkgämän it täkamäŋ. Imaka imaka täŋ nimik täyan unita nadäna gäripi inide kubä täk täkaŋ. Gäk ude täk täyan unita ämawebe komeni komeni, tuän ba gwägu pähap udude käda itkaŋ u gäk nadäŋ gamikinik täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ekäni, gäk kehäromika nikek. Unita gäkä täŋpewi pom pähap-pähap ahäŋtäŋ kuŋkuŋo itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Gäk kubä-tägän gwägu pähap täŋpewi mänit paoränkaŋ kwikinikgän it täyak. Udegän, komen ämawebe täŋo ämik täŋ-urukuruk unitäŋo kehäromini yäpmäŋ äpäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Täŋpäkaŋ nin-tägän nämo ganiŋoret täkamäŋ. Nämo, ämawebe komeni komeni, edap äbäk täyak käda ba äpmok täyak käda u kudän kudupi täk täyan unita nadäwätäk pähap täk täkamäŋ. Täŋpäŋ gäk wäpka biŋam kap terak ganiŋoret täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Anutu, gäk kometa watäni säkgämän itpäŋ iwän iweri taŋirän kome gakŋi nikek täk täyak. Gäkä komeni komeni ume kuduptagän peŋkuno u nämo kumäŋirä ketem säkgämän ahäk täkaŋ. Gäkŋa täŋpewi ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Bureni, gäkä iwän yäŋpewi taŋirän piä gänaŋ kome näbäni täŋirän ketem säkgämän ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Gäk kome nadäŋ imiŋiri kome uken ketem ahäŋ-bumbum täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","13","Ude täŋiri kome kawukiken upäŋkaŋ ketem säkgämän ahäŋirä pom terak sipsip imaka, ahäŋ-bumbum täk täkaŋ. Täŋpäkaŋ pom ba imaka imaka kuduptagän gäka oretoret pähap nadäŋpäŋ kap tek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Äma ba imaka kome terak kuŋat täkaŋ, in kuduptagän bänep oretoret gera terak Anutu iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Wäpi biŋam yäpmäŋ akuŋpäŋ kap teŋ imut! Iniŋ oretoret kap tek-inik täŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Täŋpäŋ Anutu ŋode iwerut; Imaka täk täyan uwä tägagämän-inik! Kehäromikatä täŋpewän iwankaye gämotkaken maŋ-patäbot täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Ämawebe kuduptagän oraŋ gamik täkaŋ. Oraŋ gamiŋpäŋ wäpka biŋam yäpmäŋ akuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Ämawebe, in äbut! Äbäŋkaŋ Anututä imaka imaka täk täŋkuko unitäŋo biŋami nadäwut. Äbä imaka kudupi, ämawebe bämopiken täŋkuko unitäŋo manbiŋam nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Anutu uwä ŋode täŋkuk; Ume taŋi täŋpewän däkŋeŋpeŋ kukŋi kukŋi kuŋirän kome kawuk taŋirän kädet patkuk. Kädet parirän ämawebe kuroŋitä bämopgän yeŋtäŋ kuŋkuŋ. Anututä ude täŋ yämiŋkuko u juku piŋpäŋ oretoret pähap nadäkot! ");
INSERT INTO iou_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Anutu uwä intäjukun itkaŋ kehäromini terak kaŋiwat piäni täk täyak. Täŋkaŋ guŋ äbottä peŋawäk täŋ namineŋ yäŋ nadäŋpäŋ yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Unita ämawebe, in Uraknin u iniŋ orerut! Wäpi biŋam yäpmäŋ akukta kap taŋigän teŋirä ätutä nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Imata, Anutu unitä watä kehäromi it nimiŋirän kadäni käroŋi it yäpmäŋ äbäkamäŋ. Watä kehäromi it nimiŋirän iwantä kehärominin täga nämo yäpmäŋ äpneŋ. ");
INSERT INTO iou_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Anutu, gäk täŋyabäkken nipmaŋkun. Upäŋkaŋ täŋyabäk uken jop nämo nipmaŋkun. U nintäŋo irit kuŋat-kuŋatnin yäpä tägakta nipmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Gäk nibäŋ äwaräkuk täŋiri buŋeptä nipmäŋitkuk. Täŋpäŋ bäräpi taŋi nintä terak kotaŋ niwatkun. ");
INSERT INTO iou_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Gäk nibäŋ äwaräkuk täŋiri ämatä yeŋ niwat päpmo nipmaŋkuŋ. Gäk nadäŋiri ume ba kädäp gänaŋ nipmaŋpä äpmoŋkumäŋ. Ude täŋkuŋopäŋ gäkä wädäŋ päbä kome säkgämän-ken nipmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Täŋpäkaŋ Anutu, bian bäräpi ahäŋ namiŋirän u ba u api täŋpet yäŋpäŋ yäŋkehärom taŋkuro unita nämo guŋ täyat. Nämo, ganiŋ oretta ŋode api täŋpet; Kudupi yotken äbä tom api ijiŋ gamet. ");
INSERT INTO iou_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Tom gupi taŋi, sipsip, bulimakau ba meme ämanipäŋ api ijiŋ gamet. ");
INSERT INTO iou_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Eruk, ämawebe Anutu oraŋ imik täkaŋ, in kudup äbäkaŋ imaka imaka Uraktä täŋkentäŋ namik täŋkuko unita yäŋira nadäwut. ");
INSERT INTO iou_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Bian gera yäŋira nadäŋ namiŋkuko unita kap terak wäpi biŋam yäpmäŋ akuŋkut. ");
INSERT INTO iou_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Täŋpäŋ kädet waki täkta gäripi nadäŋkaŋ Anutuken gera yäŋkut yäwänäku nämo nadäŋ namän. ");
INSERT INTO iou_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Upäŋkaŋ, bureni-inik! Näkŋo yäŋapik manna nadäŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Unita Anutu iniŋ orerut! Imata, näkŋo yäŋapik geranata mäde nämo utkuk. Täŋpäkaŋ butewaki nadäŋ namiŋpäŋ nämo nepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Anutu, gäk butewaki nadäŋ nimiŋpäŋ iron täŋ nimi. Ude täŋ nimiŋiri säkgämän kaŋ itna! ");
INSERT INTO iou_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Ude täŋiri komen äma äbori äboritä gäkŋo ironka ba yäpätägak piäka u kudup kaŋ kawä tärewut. ");
INSERT INTO iou_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Anutu, gäk ude täŋiri äma äbot kuduptagän uken-uken naniktä bänep täga nadäŋpäŋ kaŋ ganiŋ orerut. ");
INSERT INTO iou_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Täŋpäkaŋ äma mebäri mebäritä bänep täga nadäŋpäŋ oretoret kap terak kaŋ ganiŋ orerut. Imata, gäkä äma äbot täŋo mani ba nadäk-nadäki kädet siwoŋi terak yäpmäŋ danik täyan. Ba komen äma uken-uken nanik kädet tägaken yämagut yäpmäŋ kuk täyan. ");
INSERT INTO iou_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Unita Anutu, äma uken-uken naniktä Anutu gäk kaŋ ganiŋ orerut. Äma äbori äbori kuduptagäntä wäpka yäpmäŋ akuk täkot! ");
INSERT INTO iou_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ai, ämawebe, in nadäkaŋ? Anutu täŋo iron pähap terak kometä ketem bureni nimik täyak. Anutunin, Anutu Bureni-inik uwä iron pähap täŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Bureni! Anututä iron täŋ nimik täyak unita ämawebe it yäpmäŋ päŋku kome tärek-tärekken itkaŋ in kuduptagän Ekäni oraŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Anutu, bäräŋeŋ akuŋpäŋ iwankaye kokwawak nadäŋ gamik täkaŋ u däpmäŋ yäwat-kireŋ-pewi kuŋtäŋpä kut! ");
INSERT INTO iou_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Mänittä gupe piäŋ iwat-pewän paotpeŋ kuk täkaŋ ude däpmäŋ yäwat kireŋpewi kut. Ba tom gakŋi kädäpken ijiŋpewä mutpäŋ ume äworeŋpäŋ paot täkaŋ ude, wakiwaki täŋpani Anututä äbäŋirän udegän kaŋ täŋput! ");
INSERT INTO iou_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Täŋpäkaŋ äma siwoŋitä Anutu iŋamiken ŋode kaŋ täŋput; Bänep täga nadäŋpäŋ oretoret gera kaŋ yäk täŋput! ");
INSERT INTO iou_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Anututa kap teŋ imiŋpäŋ wäpi punin-inik pewut! Gubam terak äbätak unita kädet ket ut imikot! U wäpi Ekäni, iŋamiken oretoret täŋput! ");
INSERT INTO iou_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Anutu u kudupi yoriken itkaŋ nanak kodäŋa ba webe kajatta watä it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Äma noriye nämota eŋi yämiŋpäŋ komi eŋiken nanik yäniŋ kireŋpewän äpämaŋ päŋku oretoret terak it täkaŋ. Täŋ peŋawäk täŋpani yäwat kireŋpewän kome kekekiken ittäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","8","O Anutu, ämawebekaye yämaguri yäpmäŋ kome kawukiken kuŋat täŋkuŋo kadäni uken kome u kwaiŋirän kunum gänaŋ nanik iwän taŋi taŋkuk. Imata, Isrel nanik täŋo Anutu, Sainai pomken kehäromini kwawak yäwoŋäreŋkuko u äbäŋirän ude täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Täŋpäkaŋ kome iwoyäŋ yämiŋkuno u gakŋi nämo irirän iwän yäŋpewi taŋirän kome uken gakŋi taŋi äneŋi täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Täŋiri ämawebekaye yotpärare u täŋpäŋ irirä ämawebe jäwäri unita iron täŋpäŋ yepmäŋ towiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Ekänitä peŋ yäwerirän webetä manbiŋam ŋo yäpmäŋ kuŋatkuŋ; ");
INSERT INTO iou_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Iwaniye täŋo komi ämakät intäjukun ämaniye ämet täŋpä kuŋkuŋ. Ude täŋirä webe täha-kengän itkuŋo u iwan täŋo tuŋum yäyomägatkuŋo u yäpmäŋ daniŋpäŋ yäpuŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Tuŋum säkgämän säkgämän yäpuŋo ätu ŋode; Barak wärani siliwapäŋ uwäk täwani. Täŋkaŋ piritawä gol säkgämän-inikpäŋ täŋpani. Täŋ, in ätu imata ämik kadäniken yawakkät käbop jop itkuŋ? ");
INSERT INTO iou_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Täŋpäkaŋ Anutu kehäromi mähemitä kome ätu täŋo intäjukun äma Salmon pomken yäwat kireŋ täŋpän kuŋtäŋpä kuŋirä mim täŋpewän pom uken bumta maŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Wära! Basan pom pähap u jidewani? Pom äroŋkaŋ äpmok täŋpani mäyap-inik. ");
INSERT INTO iou_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Upäŋkaŋ Basan pom taŋi, gäk imata Saion pom Anututä ini itta iwoyäŋkuko unita iŋam täŋ imitan? Nämo nadätan? Ekäni uken tärek-täreki nämo api irek! ");
INSERT INTO iou_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Ekänitä komi ämaniye mäyap-jiraŋkät Sainai pomken naniktä äbämaŋ kudupi yori gänaŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","U iwaniye yentä topmäŋpäŋ wädäŋ yäpmäŋ punin unu äroŋkuk. Täŋirän uken äma peŋawäk täŋ imanitä gämoriken itpäŋ tuŋum imiŋkuŋ. Täŋpäkaŋ Ekänitä ukengän api irek. ");
INSERT INTO iou_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Unita Ekäni iniŋ oretna! U bäräpinin kepma kepma ketäreŋ nimiŋpäŋ täŋkentäŋ nimik täyak unita. ");
INSERT INTO iou_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Anutunin uwä waki keriken nanik nimagurani Anutu u. U Ekäni, nintäŋo Ekäninin kumäŋ-kumäŋ-ken nanik nimagurani. ");
INSERT INTO iou_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Anututä iwaniye, gwäk pimiŋpäŋ momi kädet iwarani unitäŋo gwäki bureni-inik api däpmäŋ kokoyäwek. ");
INSERT INTO iou_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","23","Unita Ekänitä ŋode niwetkuk; Intä iwanjiye däpmäŋpäŋ unitäŋo nägäri terak yeŋtäŋ kukta, ba aŋjiyetä unitäŋo nägäri naŋpä koki täkta inken yämagut yäpmäŋ api äbet. Ukäda-käda nanik, Basan pomken nanik ba gwägu mebäriken nanik iwanjiye kudup u gämotjinken yäpmäŋ päbä api yepmaŋpet yäŋ niwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Anutu, u bureni-inik täŋkun. Gäk iwankaye täŋo kehäromi yäpmäŋ äpäk-inik täŋkun. Ude täŋkuno unita ämawebe kuduptagän gabäŋirä oretoret terak kudupi yotka gänaŋ ärotan. ");
INSERT INTO iou_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Äroŋiri kap menitä yäŋ-tewani intäjukun kukaŋ. Kuŋirä wagäm mämä mebäri mebäri täŋpani u mäden äbäkaŋ. Täŋirä u bämopikenä webe gubaŋi wagäm täpuri täpuri uttäŋ kukaŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Täŋirä kap ŋode tekamäŋ; Ämawebeniye täŋo käbeyäken Anutu iniŋ oretna! Jekop täŋo äbotken nanik nin, Ekäni iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Täŋpäŋ tawaŋ terak kudupi yotken ŋode ärokamäŋ; Bejamin täŋo äbot täpuri unitä jukun kukaŋ. Täŋpäkaŋ u mädeniken Juda äbot täŋo äma ekäni ekäni. U mädenikenä Sebulun kenta Naptali äbot täŋo äma ekäni ekäni. ");
INSERT INTO iou_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Unita Anutu, gäkŋo kehäromika bian niwoŋärek täŋkuno udegän kwawak pewi ahäŋirän kaŋ käna! ");
INSERT INTO iou_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Jerusalem täŋo kudupi yotka unita yäŋpäŋ komeni komeni täŋo intäjukun ämatä gämotkaken itpäŋ tuŋum gamik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Eruk Anutu, iwanka Isip, tom ägwäritä-yäŋ komi täyak u ibe! Ba guŋ äbot kehäromi kehäromi u yebe! Ba äbot ämik täkta gäripi nadäk täkaŋ u yäwat kireŋ täŋpi ini-ini kuŋtäŋpä kut! Ude täŋtäyi gämotka-kengän päbä gwäjiŋ äpmoŋ gamiŋpäŋ siliwa moneŋ tuŋumi kaŋ ganiŋ kirewut! ");
INSERT INTO iou_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Bureni, Isip nanik täŋo intäjukun ämatä iniken piä ämaniye Anutu gwäjiŋ äpmoŋ imikta api yepmaŋpän kuneŋ. Ba Itiopia naniktä äbä ket kewatpäŋ Anutu bureniken yäŋapik man api yäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Unita kome terak äbori äbori Anututa iniŋoret kap teŋ imik täkot! ");
INSERT INTO iou_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Ekänitä kunum ini bian pewän ahäwani uterak kuŋ äbäk täŋ itak unita iniŋ orerut! Täŋkaŋ kehäromigän kärakŋeŋirän juku peŋpäŋ nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Anutu uwä Isrel äbotta intäjukun täŋ yämitak. Täŋkaŋ kehäromini kunum terak kwawak pewän ahäk täyak. Unita ämawebe nin imaka, Anutu unitäŋo kehäromi u kwawak yäŋahäk täkäna! ");
INSERT INTO iou_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Isrel täŋo Anutu kudupi yoriken nanik äpätak u kawut! U umuri pähap, inide kubä! Täŋpäkaŋ ini uwä ämawebeniyeta kehäromi yämik täyak. Unita Anutunin u iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Anutu, täŋkentäŋ namisi! Ume tokŋeŋ yäpmäŋ abäŋpäŋ kotäknaken itak. ");
INSERT INTO iou_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Näk gwägu gänaŋ äpmoŋira umetä tokŋeŋpäŋ nut maŋpän äpmotat. Yeŋ-täpäneŋpäŋ itta bägupta wäyäkŋetat. ");
INSERT INTO iou_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Anutu, gera yäŋtäyiwa kotäkna kawuk tawäpäŋ kehäromi nämo nadätat. Täŋpäŋ dapunna imaka, Anutu gäka dapun käroŋ täŋtäyiwa dapunna komi nekaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Täŋpäkaŋ imaka kubä nämo täŋira, äma mäyapiniktä jop nadäŋ kokwawak täŋ namik täkaŋ. Äma uwä kehäromi nikektä jop näkŋatpäŋ nutnayäŋ täk täkaŋ. Imaka kubä nämo kubo täŋkuro upäŋkaŋ äneŋi nimi yäŋ näwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Anutu, gäk näkŋo mebärina bureni nadätan. Momi kubäkubä täk täyat uwä iŋamkaken kwawak itak. ");
INSERT INTO iou_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Ekäni kehäromi mähemi, Isrel täŋo Anutu, näk nabäŋ äwaräkuk täŋiri näkä kädet waki ätu täŋira ämawebe gäk nadäŋ gamik täkaŋ unitä näka yäŋpäŋ mäyäk nämo yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Nadätan? Näk nadäŋ gamik täyat unita äma ätutä yäŋärok man näwet täkaŋ. Näwerirä mäyäk nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Näkŋaken notnayetä nabäŋirä jiraŋ udewani täyat. Ba näkŋaken mähemnaye imaka, eroni nabäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Upäŋkaŋ Anutu, gäkŋo eŋita yäŋpäŋ bänepna kädäp ijik täyak. Unita ämawebetä gäka yäŋärok yäŋirä yäŋärokitä näkä terak ärok täyak. ");
INSERT INTO iou_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Täŋpäŋ gäk ganiŋ oretta ketem nakta jop irira ämawebetä yäŋärok näwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ba butewaki nadäŋpäŋ tek waki peŋpäŋ äpani kuŋarira nabäŋ mägayäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Ba ugän nämo, ämatä kädet miŋin käbeyä täŋpäŋ näk yäŋpäŋ-nabäŋ näwat täk täkaŋ. Täŋirä äma ärowani, wain ume naŋpäŋ täŋguŋguŋ täŋpanitä kap naniŋ ubiŋ tek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Upäŋkaŋ jop uken! Näk yäŋapik manna Ekäni gäkken pewa ärek täyak. O Anutu, gäkŋo iron tokŋekinik pat täyak unita kadäni uken ba uken nadäwi tägawänä kaŋ nadäŋ nami! ");
INSERT INTO iou_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Täŋkentäŋ namiŋiri okä näbä gänaŋ äpmoŋpettawä. Iwanken nanik ba ume gwäguken nanik wädäŋ tädotpäŋ nepmaŋsi! ");
INSERT INTO iou_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Ekäni, näk nabäŋ äwaräkuk täŋiri umetä tokätpäŋ uwäk täwektawä. Bureni, watä it namiŋiri iwantä kehäromina yäpmäŋ äpäŋirä awaŋ gänaŋ äpmoŋpettawä. ");
INSERT INTO iou_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","O Ekäni, bänep ironka ärowani unita nadäŋ nami. Gäk kadäni kadäni butewaki nadäŋ namik täyan udegän täŋkentäŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Piä ämaka näka bitnäŋpäŋ käbop nämo iren. Näk bäräpi taŋi-inik nadätat unita näkŋo yäŋapik gera bäräŋeŋ nadäŋ nam! ");
INSERT INTO iou_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Ekäni, dubinaken äbäŋpäŋ näk iwan keriken nanik yäyomägat! ");
INSERT INTO iou_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Ekäni, mäyäk nadäk täyat uwä nadätan, ba näk man waki näwetpäŋ wäpna yäpmäŋ äpäk täkaŋ uwä nadätan. ");
INSERT INTO iou_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Yäŋärok näwet täkaŋ unita bänepnaken butewaki pähap nadäk täyat. Täŋira kehäromina paotak. Ätutä butewaki nadäŋ namut yäŋpäŋ dapun täŋpa waŋkuŋ. Ba naniŋ kämätta äma kubä nämo kaŋ-ahäŋkut. ");
INSERT INTO iou_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Täŋpäŋ nakta neŋirä täŋ-näkŋatpäŋ näk täŋpäwakta ketem wakipäŋ namiŋkuŋ. Täŋkaŋ umeta neŋirä ume jägämi namiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Unita ŋode nadätat; Äma u ketem nak-nakiken ketem oretoret terak naŋirä unitä äyäŋutpäŋ kowata kaŋ täŋpä wawut! Täŋkaŋ Anututa ärawa täŋ imiŋirä unitä äyäŋutpäŋ buŋep ude äworeŋpäŋ kaŋ däpän! ");
INSERT INTO iou_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Ekäni, dapuri yäpuri-tumbut. Täŋkaŋ mädeni kujat imaka, yäpi wawut! ");
INSERT INTO iou_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Täŋpäŋ kokwawakka äma udewani terak kwawak pewi ahäwäpäŋ komi nadäŋpäŋ kaŋ paorut! ");
INSERT INTO iou_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Paorirä komeni u jop kaŋ parän! Äma kubä nämoinik kaŋ-korewen, kuduptagän kaŋ däpmäŋ more! ");
INSERT INTO iou_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","U imata, äma udewanitä äma gäkä momita kowata komi yämani unita yäpurärätpäŋ komi yämikgän täŋpäŋ yäŋärok yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Unita Anutu, äma udewani täŋo momi täpuri kubäta nämoinik guŋ täwen. Ba imaka täga kubä nämoinik täŋ yämen. ");
INSERT INTO iou_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Täŋpäŋ irit kehäromi täŋo wäp tawaŋken wäpi itkaŋ u awähutpäŋ uken nanik äma kubä näkŋata biŋam täkaŋ yäŋ kubä nämo yäwen. ");
INSERT INTO iou_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Yäke! Komi bäräpi nadäŋira unitäŋo butewakitä nutak. Unita Anutu nämagutpäŋ yäpi-tägaŋ namut! ");
INSERT INTO iou_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Täŋiri wäpka pähap kap terak api ganiŋ oreret. Täŋkaŋ bänep täga nadäŋpäŋ unitäŋo biŋam api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Ude täŋira Ekänitä gäripi api nadäŋ namek. U bulimakaupäŋ gupe ijiŋ imero u irepmitpäŋ täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Ude täŋira ämawebe bäräpi kotaŋkaŋ itkaŋ unitä kaŋpäŋ oretoret api täneŋ. Bureni, ämawebe Anutu iniŋoret täkaŋ u bänep nadäk-nadäki äneŋi api täŋ-kehärom täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","U imata, Ekänitä äma jopi jäwäri täŋo gera nadäŋ yämik täyak. Ba iniken ämawebeniye iwantä yepmäŋitpäŋ komi eŋiken yepmaŋkuŋo itkaŋ unita nämo guŋtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Unita kunum, kome, gwägu ba gwägu tom imaka imaka gwägu gänaŋ itkaŋ in kuduptagän Anutu wäpi yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Nadäkaŋ? Anutu u Jerusalem täŋkentäŋ imiŋpäŋ iwan däpmäŋ yäwat kireŋirän äneŋi gupi koreŋpäŋ api irek. Ba Juda täŋo yotpärare ätu iwantä täŋpä wawani u imaka, äneŋi täŋkodak taŋpäŋ api pewek. Ude täŋirän ämawebeniyetä komeni äneŋi koreŋpäŋ uken säkgämän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Täŋpäŋ watä piä ämaniye unitäŋo yeriniyetä ahäŋpäŋ kome ugän koreŋpäŋ api it yäpmäŋ kuneŋ. Bureni, ämawebe Anututa gäripi nadäŋ imik täkaŋ u kome uken api it yäpmäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Anutu, bäräŋeŋ äbä täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Äma nutnayäŋ täkaŋ u kehäromini yäpmäŋ äpäŋpäŋ nadäk-nadäki täŋpi guŋtaŋirä mäyäk tawut. Mäyäk taŋpäŋ nabä-kätäŋpeŋ kut! ");
INSERT INTO iou_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Äma yäŋärok man näwet täkaŋ u meni täŋpipiŋpäŋ yäwat kireŋiri mäyäk tawut. ");
INSERT INTO iou_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Täŋpäkaŋ ämawebe gäk gäwaräntäk täkaŋ u oretoret täk täkot! Anutu, gäk waki keriken nanik wädäŋ tädotpäŋ yepmaŋkuno unita gäka gäripi pähap nadäk täkaŋ. Täŋpäŋ kadäni kadäni ŋode yäk täkot; Anutu u wäpi biŋam ikek kaŋ irän! ");
INSERT INTO iou_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","O Anutu, nähä waki kehäromina nikek nämo unita bäräŋeŋ äbi! Gäk kubä-tägän näkŋo täŋkentäk ba yäpätägak ämana. O Anutuna, bäräŋeŋ äbä täŋkentäŋ namisi! ");
INSERT INTO iou_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Ekänina, watä it namiŋiri iwantä näk täga nämo täŋpä waneŋ. Gäk iwan yabäŋ äwaräkuk täŋiri mäyäk nämo namineŋ. ");
INSERT INTO iou_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Täktäkka u siwoŋi-inik unita täŋkentäŋ namiŋpäŋ iwan keriken nanik yäyomägasi! Gäkken yäŋapiŋira nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Gäk yewa ba eŋi kehäromi ude it namik täyan. It namiŋiri näk u gänaŋ äroŋpäŋ iwan yabäŋ umuntaŋ päŋku käbop irira watä säkgämän it namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Anutuna, äma waki keriken nanik wädäŋ tädotpäŋ nepmaŋsi. Nadätan? Iwantä kehäromi-inik täŋpäŋ nepmäŋitnayäŋ täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Unita Anutu Ekänina, gäk kubä-tägän irit kuŋat-kuŋatnata watä täga iren yäŋ nadäkinik täyat. Näk iroŋiken umunitä gäka nadäkinik täŋ yäpmäŋ äbätat. ");
INSERT INTO iou_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Bureni! Gäk ketka terakgän it täyat. Näk nanak paki ahäŋkutken unitä apiŋo nepmäŋ towiŋ yäpmäŋ äbätan. Unita näk wäpka biŋam kadäni kadäni ganiŋoret täyat. ");
INSERT INTO iou_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Anutu, gäk watä kehäromi it namiŋ yäpmäŋ abuno unita ämawebe mäyaptä irit kuŋat-kuŋatna täga u kaŋpäŋ nadäŋpäŋ gäk Anutu udewani yäŋ nadäwä tärek täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Täŋpäŋ kepma kepma, tamimaŋtä päŋku bipäda menatä wäpka biŋam ärowani u ganiŋoret täyat. ");
INSERT INTO iou_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Unita tägawani täŋpäŋ kehäromina nämo itatken ŋoken mäde ut namiŋpäŋ nämo nepmaŋpen. ");
INSERT INTO iou_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Nämo, iwantä näk nutta käbeyä täŋpäŋ man yäŋpäŋ-nadäk täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Täŋpäŋ ŋode yäk täkaŋ; Eruk! Iwat kireŋpäŋ iŋitna yäk. Anututä mäde ut imiŋirän u täŋkentäŋ imikta äma kubä nämo itak yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Unita Anutuna, nabä kätäŋpäŋ gäkŋagän päŋku nämo iren. Nämo, täŋkentäŋ namikta bäräŋeŋ äbi! ");
INSERT INTO iou_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Ude täŋiri äma iwan täŋ namik täkaŋ u komi nadäŋpäŋ mäyäk pähap nadäk täkot. Täŋkaŋ iwaniyetä däpmäŋ yäwat kireŋirä paot-inik kaŋ täŋput. ");
INSERT INTO iou_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Upäŋkaŋ nähä gäkä täŋkentäŋ namenta nadäkinik täŋpäŋ api itsämbet. Ude täŋkaŋ wäpka biŋam wari wari api ganiŋoret yäpmäŋ ärowet. ");
INSERT INTO iou_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Täŋpäŋ säkgämän täŋkentäŋ namik täyan unita yäŋpäŋ biŋam api yäk täŋpet. Täktäkka täga u kumän nadäwa-tärenaŋi nämo upäŋkaŋ, jop uken, kepma kepma unitäŋo biŋam api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Ekäni Anutuna, kehäromika u nadäŋpäŋ wäpka api yäpmäŋ akuk täŋpet. Täŋpäŋ manbiŋam ŋodegän api yäŋahäwet; Ekäni-tägän äma siwoŋi-inik itak yäŋ ude api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Anutu, näk iroŋiken umunitä apiŋo näwetpäŋ näwoŋärek täŋ yäpmäŋ äbätan. Unita imaka tägatäga täk täyan u yäŋahäŋ yäpmäŋ äburotä pen yäŋahäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Unita Anutu, apiŋo tägawani täŋpäŋ gwäkna pujiŋ paki tädotak ŋoken nämo nabä-kätäwen! Nämo, watä pen it namiŋiri gäkŋo kehäromika pähap unita yäŋpäŋ ämawebe mäden ahänayäŋ täkaŋ u yäŋahäŋpäŋ api yäwet täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","U imata, Ekäni, kudänka siwoŋi u käroŋi boham, kunum yäpureko ude bumik. Gäk imaka umuri kudupi kudupi täŋ yäpmäŋ äbun. Komen äma gäk udewani kubä nämo itak. Nämoinik, gäkägän kudup yärepmit moretan. ");
INSERT INTO iou_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Gäk komi bäräpi mebäri mebäri namiŋkuno upäŋkaŋ nadätat; Äneŋi api täŋ-kehäromtaŋ namen. Kumbani ude iraropäŋ äneŋi nämagutan. ");
INSERT INTO iou_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ude täŋpäŋ wäp biŋam bian yäpuro u irepmitpäŋ namitan. Täŋkaŋ komi bäräpi gänaŋ irira äneŋi api naniŋ kawat täwen. ");
INSERT INTO iou_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","O Anutuna, täŋkentäŋ namikta yäŋkehärom taŋkuno udegän iwatpäŋ täŋkentäŋ namik täyan unita Isrel täŋo kudupi äma gäk wagäm utpäŋ wäpka yäpmäŋ akuŋpäŋ api ganiŋ ubiŋ tewet. ");
INSERT INTO iou_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Bänep oretoret pähap nadäŋpäŋ bumta api teŋ gärepet. Bänep nadäk-nadäkna ba gupna kudup mäba ärowäpäŋ api tek täŋpet. Gäk wakiken nanik nämagutkuno unita yäŋpäŋ ude api täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Bureni, kepma kepma täktäkka siwoŋi unita yäŋpäŋ ämawebe yäŋahäŋpäŋ api yäwet täŋpet. Imata, ämatä näk täŋpä wanayäŋ täŋkuŋo upäŋkaŋ gäkä unitäŋo kehäromi yäpmäŋ äpäŋiri mäyäk bumta nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","O Anutu, gäkä nintäŋo intäjukun äma gäkŋaken kudän siwoŋi ugänpäŋ täŋpäŋ-iwoŋäre. Täŋiri yäpmäŋ danik-danik piä siwoŋigän kaŋ täŋpän. ");
INSERT INTO iou_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ba ämawebekaye kudän siwoŋi terak yabäŋ yäwatpäŋ äma jäwäri kaŋ täŋkentäŋ yämän. ");
INSERT INTO iou_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Täŋpäŋ kadäni irayäŋ täyakken ämawebeniye piä tänayäŋ täkaŋken imaka ahäŋ-bumbum api täneŋ. Ude täŋirä ämawebe u kädet siwoŋika ugän api iwatneŋ. ");
INSERT INTO iou_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Täŋpäkaŋ intäjukun äma unitä äma jäwäri täŋo bäräpi api täŋpidäm taŋ yämek. Ba ämatä tuŋumta wäyäkŋek täkaŋ u api täŋkentäŋ yämek. Täŋ, ämatä noriye täŋpäwak täkaŋ udewanita kowata api yämek. ");
INSERT INTO iou_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Täŋpäkaŋ intäjukun äma u kome terak irayäŋ täyak uwä edap ba komepaktä ijiŋ yäpmäŋ kudayäŋ tämäno udegän api irek. ");
INSERT INTO iou_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Unitäŋo täktäki säkgämän-inik api ahäwek, iwäntä piä gänaŋ maŋirän ketem säkgämän ahäk täkaŋ ude. ");
INSERT INTO iou_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Ba kadäni yabäŋ yäwat piä täŋpayäŋ täyakken u äma siwoŋigän kuŋaranitä säkgämän api itneŋ. Ba komepaktä ijiŋ yäpmäŋ kwayäŋ täyak udegän täŋ-bumbum terak api it yäpmäŋ äroneŋ. ");
INSERT INTO iou_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Täŋpäkaŋ kome yabäŋ yäwat täyak u gwägu pähap ŋo kädatä päŋku ban udude pätak ude. Komeni täŋo baga uwä ume wäpi Yufretis u yäput-peŋkaŋä komeni komeni api kuŋ morewek. ");
INSERT INTO iou_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Täŋpänkaŋ ämawebe komeni komenitä api oraŋ imineŋ. Ba iwaniye kudup gämori-kengän api maŋ uyineŋ. ");
INSERT INTO iou_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Täŋpäŋ intäjukun äma u ärowani-inik irirän guŋ ämawebe täŋo intäjukun äma Spen kome, Itiopia kome ba Arebia komeken naniktä päbä iron täŋ imiŋpäŋ takis moneŋ kaŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Bureni, kome kudup täŋo intäjukun ämatä api gwäjiŋ äpmoŋ imineŋ. Ba äma äbori äboritä watä piä api täŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","14","Täŋpäkaŋ äma jäwäri ba äma kehäromini nämotä yäŋapiŋirä api täŋkentäŋ yämek. Ba ämawebe äma ätutä täŋkentäŋ yäminaŋi nämo unitä gera yäŋirä api täŋkentäŋ yämek. Äma udewanita gäripi nadäk täyak unita äma wakitä däpnayäŋ täŋirä äneŋi api yämagurek. ");
INSERT INTO iou_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Intäjukun äma u kadäni käroŋi kaŋ irän! Täŋpäkaŋ Arebia kome täŋo äma ekäni ekänitä gämoriken kuŋatpäŋ gol moneŋ pähap kaŋ imut! Täŋpäŋ ämawebeniyetä Anutu täŋkentäŋ imän yäŋ nadäŋpäŋ yäŋapik man yäŋirä Anututä api täŋkentäŋ imik täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Intäjukun äma unitä kome kaŋ iwarirän saguom ba ketem ätutä ämawebe täŋo piäken kaŋ ahäwut, Lebanon komeken ahäk täkaŋ ude. Täŋpäkaŋ muptä piäken tädot täkaŋ udegän ämawebe kome uken ahäŋ-bumbum kaŋ täŋput! ");
INSERT INTO iou_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Täŋpäkaŋ intäjukun äma täŋo wäpi biŋamä edaptä pen ijiŋ yäpmäŋ kuk täyak ude kaŋ it yäpmäŋ kwän. Täŋpäkaŋ ämawebe äbori äboritä u wäpi terak täŋ bumbum pähap terak kaŋ irut. Itkaŋ wäpi biŋam yäpmäŋ akuŋpäŋ iniŋoret-oret epän tärek-täreki nämo kaŋ täk täŋput. ");
INSERT INTO iou_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Täŋpäkaŋ ämawebe komeni komenitä Ekäni Anutu, Isrel täŋo Anutu u wäpi biŋam kaŋ iniŋoret täŋput. Unitägän kudän kudupi ini pärik kubä täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Wäpi biŋam säkgämän u pen oraŋ imik täkot. Wäpi biŋamtä komeni komeni kaŋ tokŋeŋ morewän! Burenitä bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Devit, Jesi täŋo nanaki, unitäŋo yäŋapik kap teŋirän kudän täk täŋkuŋo u kudup äbä tärekaŋ ŋo. Ugän. ");
INSERT INTO iou_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Näk bureni ŋode nadätat; Anututä Isrel ämawebeta säkgämän täŋ yämik täyak. U ämawebe bänep nadäk-nadäki kuräki säkgämän unita nadäŋ yämik-inik täyak. ");
INSERT INTO iou_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Upäŋkaŋ Anutu, nadäkinikna pära pewa putäreŋkuk. Äma wakiwaki täŋpanitä säkgämän itkaŋ tuŋum pähap ikek kuŋarirä yabäŋpäŋ-nadäŋkaŋ näkŋata jop waki ŋode nadäŋkut; Udegän itet yäŋ nadäŋkut. ");
INSERT INTO iou_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Ŋode yabäŋpäŋ-nadäk täyat; Äma udewani bäräpi nämo nadäk täkaŋ ba käyäm nämo kaŋ-ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Kome täŋo bäräpi ninta ahäŋ nimik täkaŋ uwä äma udewanita nämo ahäŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Täŋpäkaŋ iniken täktäki waki u käbop nämo peŋpäŋ gup yäpmäŋ ärokärok kudän ba ämata komi jop nadäŋ yämik-yämik kädet iwarän täŋpäŋ täk täkaŋ u kwawakgän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Bänep nadäk-nadäki-ken wakitä tokŋek patkaŋ abämaŋ kuk täkaŋ. Täŋpäkaŋ waki ätu täkta nadäk-nadäki-ken ini yäŋpäŋ-nadäk wari wari täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Ude täŋkaŋ äma ätu yäŋärok yäwetpäŋ kokwawak man yäwetgän täk täkaŋ. U ärowani kudän täŋpäŋ äma ätu komi yämikta umun man yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Täŋkaŋ Anutu kunum gänaŋ itak unita man waki yäk täkaŋ. Ba iniken wäpi yäpmäŋ akuŋpäŋ ämawebe komeni komenitä nintäŋo gärip ugän iwarut yäŋpäŋ peŋ yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Yäke! Ude täŋirä unita Anutu täŋo ämawebe ätutäwä gäripi nadäŋpäŋ man yäk täkaŋ unita nadäwä bureni täŋpäpäŋ yäwarän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Täŋirä äma waki unitä ŋode yäk täkaŋ; Anutu ärowani täŋpämorek mähemitä nintäŋo wakinin u yabäŋ ahäkta kädet kubä nämo pat imitak. ");
INSERT INTO iou_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Wära! Äma waki täŋpani täŋo mebäri udegän pätak! Tuŋum mäyap pat yämiŋirä upäŋkaŋ äneŋi ätukät yäpmäkta piäni täkgän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Butewaki! Siwoŋi kädet kuŋatpäŋ momi täŋpet yäŋpäŋ näkŋatta watä itpeŋ kuŋat täyat u jide? Jopi täyak ba? ");
INSERT INTO iou_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Anutu, ude bumik täŋpapäŋ yäŋ ukeŋode kadäni kadäni kepma bipani komi mebäri kubä namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Upäŋkaŋ ude nadäwero! Anutu, äma waki täŋpanitä yäŋärok gäwet täŋkuŋo udegän yäwero uwä ämawebekaye-kät nanik kubä bumik nämo iret. Nämo, äma waki udewanigän äworewet! ");
INSERT INTO iou_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Täŋpäkaŋ bäräpi ŋonitäŋo mebäri nadäwa tärewut yäŋpäŋ piäni täŋkuropäŋ mebäri täga nämo kaŋ-ahäŋkut. ");
INSERT INTO iou_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Ude täŋkä eruk, päŋku kudupi yotka gänaŋ äroŋpäŋä eruk nadäwa täreŋkuk. Äma waki terak kämi jide api ahäwek yäŋ u nadäwa täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Bureni, äma waki udewani yäniŋ kirewikaŋ itärop yewä kwäpäŋ maŋdäpmäk-inik täŋpäŋ api waŋ moreneŋ! ");
INSERT INTO iou_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Maŋ-däpnayäŋ täkaŋ uwä komi piä umuri kubäkengän api itneŋ. Ude täŋpäŋ pit kubägän api kumäŋ moreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Uwä ämatä bipani däpmonken täŋpäŋ pewä kwäkaŋ tamimaŋ päŋaku täŋguŋtaŋ it täkaŋ ude bumik. Bureni Ekäni, gäkä äbäŋiri äma udewani api paotpeŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","22","Täŋpäkaŋ äma udewanita yäŋpäŋ bänepnatä nadäwa jägäm tawäpäŋ kadäni uken gäkŋo mebärika täga nämo nadäwa täreŋkuŋ. Nämo, iŋamkaken kudän jide täŋkuro u tomtä-yäŋ guŋ ude kuŋatkut. ");
INSERT INTO iou_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Upäŋkaŋ apiŋo näk gäkkät it-inik täŋira gäkä ketnagän nepmäŋit näwariri it täyat. ");
INSERT INTO iou_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Ude täŋkaŋ juku-mankatä näk jide itpäŋ kuŋaretta näwetpäŋ näwoŋärek täk täyan. Ude täŋ yäpmäŋ kuŋkä mäden nämagutpäŋ epmägetka kudän api meran täŋ namen. ");
INSERT INTO iou_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","O Ekäni, näka watä itta kunum gänaŋ gäk udewani kubä nämo itak. Nämoinik. Gäk kubägän it namitan unita gäka gäripi inide kubä nadäk täyat. Unita kome täŋo tuŋumta imata gäripi nadäwet? ");
INSERT INTO iou_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Nämoinik! Gup nadäk-nadäkna täŋo kehäromi paoreko upäŋkaŋ Anutu gäk näkŋo kehäromina. Gäk näkkät tärek-täreki nämo it-inik api täŋpen. ");
INSERT INTO iou_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Täŋpäkaŋ ämawebe gäka mäde ut gamik täkaŋ u kudup paot-inik api täneŋ. Ba äma gäk gabäŋ umuntaŋpäŋ iniken gärip terak kuŋarani u kudup api täŋpi waneŋ. ");
INSERT INTO iou_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Upäŋkaŋ tägagämän-inik! Nähä gäk dubikaken itat unita säkgämän itat. Anutu Ekänina, gäk näkŋo yewana unita imaka täŋ namiŋkuno unita nadäŋpäŋ u kudup kwawakgän yäŋahäwayäŋ! ");
INSERT INTO iou_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","O Anutu, imata nipmaŋpi kodäŋani ŋode itkamäŋ? Ämawebekaye ninta kokwawak pen api nadäŋ yäpmäŋ ärowen ba? ");
INSERT INTO iou_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ämawebekaye gäkŋata biŋam bian iwoyäŋpäŋ komi piäken nanik nimagut yäpmäŋ äpämaŋ kuŋkuno ninta äneŋi nadäŋ nimen. Ba Saion Pomka ŋo terak gäkŋa bian bämopninken irani unita nadäwen. ");
INSERT INTO iou_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Komeka biani täŋpäwawani ŋo pärewatkaŋ ka! Iwaniyetä kudupi yot gänaŋ nanik imaka imaka kudup täŋpä waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Anutu, iwankayetä yärepmitkamäŋ yäŋpäŋ kudupi yot gänaŋ oretoret gera mämä täŋpäŋ eŋi ŋo ninta biŋam täyak yäŋpäŋ wären täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","6","Ämatä bipiken päya madäk täkaŋ ude kudupi yot gänaŋ päya kujat säkgämän säkgämän paiŋpäŋ täŋpani u kudup gwem kujat ba pinigoŋtä däpmäŋ äreyäŋ täŋpä kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Kudupi yotka u ude täŋpä wawäpäŋ kädäp pewä ijiŋirän iŋamkaken gäk ganiŋ oretta biŋam täha nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Ämawebekaye nin täŋpäwakinik tänayäŋ nadäŋpäŋ komeninken ŋoken ganiŋ oretta bägup kudup pewä ijiŋ paotkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ude täŋirä apiŋo kudän kudupi kubä nämo täŋiri kak täkamäŋ. Ba meka jinom yäŋahäwani äma u kudup paotkuŋ. Unita bäräpi ŋo udeken api paorek yäŋ äma kubätä nämo nadätak. ");
INSERT INTO iou_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Iwantä gäkŋo wäpka yäŋpäŋ gabäŋ mägayäk täŋirä kadäni jide api täŋpek? Wäpka biŋamta yäŋärok man yäŋirä tärek-täreki nämo api pärek ba? ");
INSERT INTO iou_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Anutu, imata nin täŋkentäŋ nimikta bitnäk täyan? Imata jop nadäŋ itkentäŋ nimik täyan? ");
INSERT INTO iou_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Täŋpäkaŋ näk nadätat; Gäk nintäŋo intäjukun äma ude yäput peŋpäŋ it nimiŋ yäpmäŋ äbun. Ude täŋkaŋ kadäni mäyap iwan keriken nanik nimagut täŋkun. ");
INSERT INTO iou_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","14","Kehäromika terak gwägu däpmäŋ täkŋeŋpäŋ gwägu gämok pähap wäpi Levitan unitäŋo gwäki däpmäŋ kokoyäŋpäŋ gupi madäŋ jukutpäŋ kome kawukiken nanik tomta yepmäŋ towiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Ude täŋkaŋ ume dapuri täwitpewi ume äpuŋ. Täŋkaŋ ume taŋi taŋi täŋpewi kawuktaŋ yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Gäkŋa-tägän kepma bipani yäŋpewi ahäŋkumän. Täŋpäŋ edap kenta komepak komeniken yepmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Täŋkaŋ kome pähap ŋonitäŋo baga kukŋi kukŋi täŋ-kehärom taŋpäŋ peŋkun. Täŋpäŋ iwän edap täŋo kadäni yäpmäŋ daniŋpäŋ peŋkun. ");
INSERT INTO iou_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Täŋpäkaŋ Ekäni, iwankaye gäka gaŋani pähap nadäŋpäŋ Anutu bureni yäŋ nämo nadäŋ gamiŋpäŋ gabäŋ mägayäk täkaŋ. Unita nadäŋpäŋ kowata yämen. ");
INSERT INTO iou_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Täŋpäŋ ämawebekaye täŋkentäki nämo, iwan täŋo komi piä terak itkaŋ u nämo nibä-kätäwen. ");
INSERT INTO iou_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Nämo, topmäk-topmäk kubägän ninkät bian täŋkuno unita äneŋi juku pi! Imata, kome ŋo täŋo käwuri kukŋi kukŋiken äma komi nimikta käbop ittäŋ kukaŋ. ");
INSERT INTO iou_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Unita iwan yabä-kätäŋiri mäyäk nämo nimineŋ. Nämo, täŋkentäŋ nimiŋiri äma jopi jäwäri mewuni nin wäpka kaŋ ganiŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Eruk Anutu, bäräŋeŋ akuŋpäŋ iwankaye yabäŋ yäŋiri goret täkamäŋ yäŋ nadäwut. Äma udewani nämo nadäŋ gamiŋkaŋ kepma käroŋ gäk gabäŋ mägayäktagän nadäk täkaŋ u nadä! ");
INSERT INTO iou_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Täŋkaŋ iwankaye u kokwawak täŋpäŋ yäŋgera-gera wari wari yäk täkaŋ unita nämo guŋ täwen! Nämo, komi kaŋ yämi. ");
INSERT INTO iou_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Bänep täga, Anutu, bänep täga gäkagän nadäŋ gamikamäŋ! Imaka säkgämän säkgämän, ba kudän kudupi kudupi täŋ yäpmäŋ äbuno unitäŋo biŋam yaŋahäk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Anutu, gäkä ŋode yäŋkun; Yäpmäŋ danik-danik epän täkta kadäni kubä iwoyäŋpäŋ peŋkuro itak. Kadäni uken kudän siwoŋi terak ämawebe uwä api yäpmäŋ daniwet. ");
INSERT INTO iou_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Täŋpäkaŋ imaka imaka kome terak it täkaŋ ba kome ini bärom täŋpeko upäŋkaŋ Anutu näkä meham täŋira api kehärom täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","5","Näk äma waki täŋpani gup yäpmäŋ ärokärok kädet peŋpäŋ injinken kehäromita nadäwä ärowani nämo täŋpek yäŋ yäwet täyat yäk. Anututä ude yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Nadäkaŋ, komen äma uken-uken nanik kubätä äma kubäta wäp biŋam bureni yämik-yämik uwä täga nämo täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Nämo, u Anutu ini kubä unitägän ämawebe yäpmäŋ daniŋpäŋ ätu kowata waki yäpmäkta biŋam yepmaŋkaŋ ätu wäpi biŋam yäpmäkta biŋam yepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Imata, Ekänitä ini kokwawaki umuri pähap, ume komi nikek bumik gäpe nikek iŋitak. Täŋpäŋ u piwän kuŋirän äma waki täŋpanitä kudup api naŋ paotneŋ. Kubätä nämoinik api irepmirek. ");
INSERT INTO iou_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Täŋ nähä Isrel täŋo Anutu unitäŋo täktäkita wari wari api yäŋahäk täŋpet. Ba kap terak iniŋ oretta nämoinik api gaŋa täwet. ");
INSERT INTO iou_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Nämo, Anutu u waki täŋpani täŋo kehäromi api pewän paotneŋ. Täŋkaŋ äma siwoŋi täŋo kehäromi ätukät api yäpurärärek. ");
INSERT INTO iou_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Juda naniktä Anutu täŋo mebäri nadäkaŋ. Ba Isrel nanik imaka, wäpi oraŋ imik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Anutu täŋo eŋini Jerusalem itak. Saion pom terak it täyak. ");
INSERT INTO iou_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Kome uken itkaŋ iwan ämik tänayäŋ äbuŋo unitäŋo äpa kuwek, kurepä, käda boham u kudup ubiŋ-jukutkuk. ");
INSERT INTO iou_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O Anutu, gäka nadäŋira epmäget kudän inipärik-inik kubä täk täyak. Ba täktäkka täŋo mebäri ärowani inipärik kubä, pom käroŋi käroŋiken tom ahäŋ-bumbum täk täkaŋ u kudup yärepmit moretak. ");
INSERT INTO iou_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Iwan täŋo komi äma uwä kehäromi nikek upäŋkaŋ gäkä däpmäŋpäŋ tuŋumi kudup yäyomägatkun. Täŋiri kumäŋpäŋ däpmon patguŋ-guŋ ude täŋ itkaŋ. U ka! Kehäromini ba nadäk-nadäki u jopigän. ");
INSERT INTO iou_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Jekop täŋo Anutu, däpayäŋ täŋyäkŋariri komi ämakät hosniye pajiŋ kumäŋ maŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Bureni Ekäni, äma kuduptagän gäka umuntak täkaŋ. Kokwawak täŋiri kubätä iŋamkaken täga nämo kehärom taŋpäŋ irek. ");
INSERT INTO iou_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Gäk kunum gänaŋ itkaŋ iwanta kowata ude yäŋtäreŋ yämiŋiri ämawebe komeni komeni umuntaŋpäŋ man kum itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Kowata yäŋtäreŋ yämiŋkuno uwä ämawebe iwan keriken irani u kudup yämagutta yäŋkun. ");
INSERT INTO iou_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Bureni Ekäni, äma ätutä kokwawak täŋpäŋ ämik täneŋo upäŋkaŋ kowata yämiŋiri ämawebe nadäwä täga täŋpäpäŋ ganiŋoret täkaŋ. Täŋirä äma ämikken kehärom taŋpäŋ it täkaŋ uwä api ganiŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Unita ämawebe, Ekäni Anutujinta täŋ imikta bian yäŋkehärom taŋkuŋo u inita täŋ imineŋ. Täŋpäŋ äma äbot tuän tuän itkaŋ in, iron yäpmäŋ äbäŋpäŋ kaŋ imut. U imata, Anutu unitagän umuntänaŋi. ");
INSERT INTO iou_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Bureni, Anutu u äma wäpi biŋam ikek täŋo wäpi yäpmäŋ äpäk täyak. Ba intäjukun äma ärowani ärowani täŋpewän bumta umuntak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Anutuken konäm butewaki gera yäk täyat. Gera yäŋira nadäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Bäräpi kadäniken Ekäniken yäŋapik täyat. Bipani käroŋ yäŋapik man yäk täyatken uken ketna yäpmäŋ akuŋkaŋ Ekäni iwet täyat. Upäŋkaŋ bänepna nämo pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Ude täŋkaŋ Anutu täŋo täktäkita nadäŋpäŋ bäräpi nadäk täyat. Unita juku piŋira nadäŋ bäräp ahäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Unitä täŋpewän bipani bipani däpmon kubä nämo pat täyat. Nadäwätäk taŋi täŋpäŋ man kubä täga nämo yäwet yäŋ nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ude täŋkaŋ bian täga itkutken unita juku pik täyat. ");
INSERT INTO iou_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Bipani käroŋ nadäk-nadäk pähap täŋpäŋ näkŋaken bänepna ŋode iwet yabäk täyat; ");
INSERT INTO iou_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Jide? Ekänitä ninta mäde pen api ut nimek? Ninta gäripi äneŋi nämo api nadäŋ nimek? ");
INSERT INTO iou_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Nadäŋ nimikinik täk täŋkuko u nibä-katäŋkuko ugän? Ba yäŋkehäromtak mani wari nämo käwep api iwarek? ");
INSERT INTO iou_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Orakoraki pewän paotkuko ubayäŋ? Kokwawakitä orakoraki komeni yäpuk ba? ");
INSERT INTO iou_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Ude nadäŋpäŋ yäŋkut; Imaka ŋonita nadäŋira bänepnaken däpmäŋ päretak; Anututä kadäni käroŋi kehäromini näwoŋäreŋ yäpmäŋ äbukopäŋ apiŋo de itak? ");
INSERT INTO iou_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Täŋpäkaŋ ude nämo! Ekäni, imaka säkgämän säkgämän, ba kudän kudupi kudupi bian täŋkuno unita äneŋi juku piwa! ");
INSERT INTO iou_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Imaka tägatäga kehäromi nikek täŋ yäpmäŋ äbuno unita nadäk-nadäk epän kaŋ täk täŋpa! ");
INSERT INTO iou_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Bureni Anutu, imaka imaka täk täyan u kumän kudupi siwoŋi-inik. Anutu kehäromi nikek gäk udewani kubä nämo itak. ");
INSERT INTO iou_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Kudän kudupi pewä ahäwani Anutu u gäk kubägän. Kehäromika ärowani guŋ äbot bämopiken pewi ahäŋirän kaŋpäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Ketka kehäromikatä ämawebekaye, Jekop kenta Josep täŋo äboriye u komi epänken nanik yämagutkun. ");
INSERT INTO iou_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Täŋpäkaŋ ume gwägu pähaptä Anutu gäk gabäŋkaŋ umuntaŋpäŋ bärom-bärom täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Yäŋpewi gubam gwägärirän yäpä iromäŋ iwän bukŋa täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Iromäŋ täŋpewi yäŋpäŋ-wädäŋ iwarirän yäpä kwinitpäŋ peŋyäŋeŋirän komeni komeni kwawakgän itkuŋ. Ude täŋirän kome kwaiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Anutu, gäk gwägu käroŋi boham u bämopiken kädet täwitkun. Täŋkuno upäŋkaŋ kuroŋka bäräm äma kubätä täga nämo kaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ude täŋkaŋ ämawebekaye yawak ude irirä yäŋ-yämagutkun. U Moses kenta Arontä watä it yämiŋirän yämagut päŋku tägaken yepmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Eruk ämawebenaye, in näkŋo jukuman ŋo nadäwut. Juku säkgämän peŋpäŋ man täwerayäŋ täyat ŋo nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Jukuman ŋo man wärani terak täwerayäŋ. Imaka bian ahäwani mebäri nikek unita täwerayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Bian oraniyetä yäŋpäŋ niwerirä nadäŋkumäŋo nadäk-nadäknin-ken pätak u tärewayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Man ŋo nanakniye ahänayäŋ täkaŋ unita käbop nämo peŋ yämine. Nämoinik! Ekäni u imaka säkgämän säkgämän täŋkuk. Unita yäwetpäŋ yäwoŋärek täŋitna epän kehäromi kehäromi täk täŋkuko u ba kudän kudupi täŋkuko unita kaŋ nadäwä tärewut. ");
INSERT INTO iou_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Ekäni u Jekop täŋo oraniye, Isrel ämawebe it yäpmäŋ äbäkamäŋ nintä iwatta baga mani bian peŋkuk. Täŋpäŋ oraniye man kehäromigän ŋode yäwetkuk; In näkŋo baga man ŋo nanakjiye yäwetpäŋ yäwoŋärek kaŋ täk täŋput yäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Ude tänayäŋ täŋo uyaku yerijiye mäden ahänayäŋ täkaŋ unitä yäŋpäŋ-nadäk pen api täk täneŋ. Ude täŋkaŋ unitäŋo yeri ahänayäŋ täkaŋ unitä udegän api yäwetpäŋ yäwoŋäreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Ude tänayäŋ täŋo uwä äbot u imaka, Anututa nadäkinik täŋ imiŋ yäpmäŋ kuŋpäŋ kudän kudupi täŋkuko unita nämo api guŋ täneŋ. Ba baga mani u api buramik täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Baga mani buramiŋpäŋä oraniyetä täŋkuŋo ude nämo api täneŋ. Oraniye uwä Anutu täŋo manta nadäkinik nämo täŋpäŋ bänepitä Anutu iŋit-inik nämo täŋkuŋ. Täŋpäŋ Anutu mäde ut imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Bian uken Efraim äbot unitäŋo komi äma uwä äpa kuwek yäpmäŋ kuŋat täŋkuŋo upäŋkaŋ ämik ahäŋirän umuntaŋpäŋ ämetkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","U Anutukät topmäk-topmäk täŋpani unita nadäŋ äwaräkuk täŋpäŋ baga mani iwatta bitnäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Ba imaka kudän kudupi iŋamiken täŋkuko unita guŋ tak-inik täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Ekänitä Isip täŋo kome kubä wäpi Soan uken kudän kudupi oraniye naniye ŋode täŋpäŋ yäwoŋäreŋkuk; ");
INSERT INTO iou_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","U gwägu taŋi däpmäŋ täkŋewänkaŋ kukŋi kukŋi kuŋirän Isrel ämawebe bämopgän yäŋ-yäkŋat yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Yäŋ-yäkŋat yäpmäŋ kuŋpäŋä kepmawä gubam kubä iwerän kädet yäwoŋärekta intäjukun kuŋirän iwatkuŋ. Täŋ bipaniwä kädäp täŋo peŋyäŋeki ägonitä udegän intäjukun kuŋirän iwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Täŋpäkaŋ kome kawukiinikken mobä yäpurän tumäŋirän ume gänaŋ umu nanik bumta abäŋirä naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Bureni, mobä jopi täŋpewän ume dapuri abani ude täŋkuk. Ude täŋirän ume taŋi ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Ekäni ärowani pähaptä iron ude täŋ yämiŋkukopäŋ kome kawuki uken ehutpäŋ ärowani kudän pen ŋode täŋ imiŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Anutu iyapi yäŋ nadäŋpäŋ yäŋikŋatpäŋ kakta ketem gäripi nikek ätukät nimi yäŋ peŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Ude täŋpäŋ Anutu yäŋärok ŋode iwetkuŋ; Anutu kome kawuki ŋodeken ketem täga käwep pewän ahäwäpäŋ nimek? Ba täga nämo käwep! yäk. ");
INSERT INTO iou_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Bureni, pengänä mobä yäpurän tumäŋirän ume uken nanik abuk yäk. Upäŋkaŋ jide? Tom ketem udegän niminaŋi nämo käwep? yäk. ");
INSERT INTO iou_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yäŋärok ude yäŋirä Ekänitä mani u nadäŋpäŋ kokwawak taŋi täŋpäŋ Jekop täŋo äbot uken kädäp mebet iniŋ kireŋpewän äpuk. ");
INSERT INTO iou_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","U imata, ämawebe uwä Anututa nadäkinik nämo täŋkuŋ. Ude täŋkaŋ Anutu ninta nadäkinik täŋpäŋ täŋkentäŋ nimik täyak yäŋ nadäwä bureni nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Ude täŋkuŋo upäŋkaŋ Anututä kunum iwerän aŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Aŋeŋirän kunum gänaŋ nanik ketem inide kubä pewän maŋirä yäpmäŋpäŋ naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Ketem naŋkuŋo u ketem tägagämän, aŋero täŋo ketem bumikpäŋ naŋkuŋ. Anututä iron täŋ yämiŋkuko u naŋpäŋ koki täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","27","Ude täŋpäŋ mänit pähap kubä iwerän piäŋkuk. Piäŋirän ämawebetä itkuŋken u barak punin nanik päke uwä iwän ude bumik pewän maŋkuŋ. Barak uwä bumta, mobä jiraŋ ude. ");
INSERT INTO iou_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Täŋpäkaŋ u kome jopiken nämo pewän maŋkuŋ. Nämo! Ämawebetä yottaba täŋpäŋ itkuŋken ugän pewän maŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Eruk, ude täŋpäkaŋ ämawebetä barak päke u naŋ tokŋeŋkuŋ. Bureni, imaka Anutuken yäpmäkta yäŋapiŋkuŋo u yäniŋ kireŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","31","Ude täŋkentäŋ yämiŋkukopäŋ momi kädet nämo peŋkuŋ. Unita ketem u pen naŋ irirä Anututä kokwawak nadäŋ yämiŋpäŋ Isrel äma gubaŋi gubaŋi kehäromi nikek u pit kubägän däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Upäŋkaŋ momi pen täŋ yäpmäŋ kuŋkuŋ. Anutu kudän kudupi päke täŋ yäpmäŋ äbuko unita nadäkinik nämo täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Nadäkinik nämo täŋkuŋo unita ehät woŋ pit kubägän abäŋpäŋ paot täkaŋ ude Ekänitä imaka umuri kubä pewän ahäŋirän uterak pit kubägän kumäŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Eruk Anututä ätuniye ude däpmäŋ paorirän yabäŋpäŋä ätu bänepi äyäŋutpäŋ Ekäni äneŋi iwatta bänep pek täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Täŋpäŋ nadäŋkuŋ; Ekäni uwä nintäŋo mobä kujat kehäromi ude it nimitak. Unitägän wakiken nanik nimagut täyak. ");
INSERT INTO iou_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Ude nadäŋkuŋo upäŋkaŋ bänep äyäŋut-äyäŋut man yäŋkuŋo u jop yäŋikŋatkuŋ. Man yäkyäki täktäki u jopigän, bureni nämo. ");
INSERT INTO iou_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Ekänikät topmäk-topmäk täŋpani u nadäŋ äwaräkuk täŋpäŋ mani nämo buramiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Ude täŋkuŋo upäŋkaŋ Anututä kudup nämo däpmäŋ moreŋkuk. Nämo, oraŋ yämiŋpäŋ momini peŋ yämiŋkuk. Kokwawak taŋi täga täŋ yäminaŋipäŋ kadäni kadäni kokwawaki pewän maŋpäpäŋ ähan täŋ yämik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","U imata, ämawebe unitäŋo mebärini ŋode nadäŋkuk; Uwä ämawebe jopigän, kadäni käroŋi itta yäwani nämo. Mänittä abämaŋ paotpeŋ kuk täyak udewani. ");
INSERT INTO iou_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Wära, kome kawukiken peŋawäk wari wari täŋ imiŋirä nadäwän jägämi täk täŋkuk! ");
INSERT INTO iou_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Isrel täŋo Kudupi Anutu u kadäni kadäni täŋikŋat-ikŋat kädet mäyap täŋ imiŋirä komi nadäk täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Uwä iniken kehäromini terak iwan keriken nanik bian yämagutkuko unita juku kubä nämo peŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Nämo, Isip kome Soan käda uken kudän kudupi ŋode täŋkuko unita nadäwä ärowani nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Kome uken Anututä ume yäŋpewän nägät äworeŋirän Isip nanik täga nämo naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Ba gäbäräm bipi ätu yäniŋ kirewänkaŋ abä äma gupi tätuŋ naŋkuŋ. Ude täŋpäŋä wirit udegän yäniŋ kirewänkaŋ äbä imaka imakani kudup täŋpä waŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Täŋpäkaŋ kapukbam mebäri mebäri ketemi epäni täŋpäwakta yäniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ude täŋpäŋä mimtä maŋpäŋ wain päya ba ketemi epän kudup täŋpän waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Ba ugän nämo, mim kenta yäpätä yawakiye kudup udegän däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Yäke! Anututä kokwawak wakiinik täŋpäŋ aŋero täŋpäwak pewä ahäwani u yäniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Kokwawaki kwawak yäwoŋärekta kädet täwitpäŋ ämawebe yabäŋ äwaräkuk kubä nämo täŋkuk. Nämo, käyäm wakitä mäyap däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Ekänitä ude täŋpäŋä Isip nanik täŋo nanak ämani intäjukun ahäwani kudup däpmäŋ paotkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Täŋ iniken ämawebeniye yawak ude kome kawukiken kädet yäwoŋäreŋpäŋ yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Yämagut päŋku yepmaŋpän umunkät nämo, säkgämän itkuŋ. Täŋpäkaŋ iwaniye uwä gwägutä uwäk täŋpäŋ däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Eruk, yäŋ-yäkŋat yäpmäŋ kuŋtäŋgän iniken kudupi kome dubinken ahäŋkuŋ. Täŋkaŋ kome uwä iniken kehäromi terak ämawebeniyeta yämikta ŋode täŋkuk; ");
INSERT INTO iou_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Kome u mähemiye yäwat kireŋpäŋ iniken ämawebeniyeta yäpmäŋ daniŋpäŋ yämiŋtäŋ kuŋkuk. Ude täŋpänkaŋ Isrel äbori äbori eŋi täŋpäŋ ittäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Anututä ude täŋ yämiŋkuko upäŋkaŋ Isrel ämawebetä Anutu ärowani unita täŋikŋarani täŋpäŋ peŋawäk täŋ imiŋkuŋ. U jukumani kubä nämoinik iwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Kudän waki oraniyetä bian täŋkuŋo udegän iwatpäŋ nadäŋ imikinik nämo täŋ imiŋkuŋ. Uwä äŋin gwäjiwani gwäjiwäkaŋ siwoŋi nämo kweko ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","59","Uwä anutu jopi yäniŋ oretta kome iwoyäŋpäŋ peŋkaŋ u kuk täŋkuŋonik. Ude täŋirä Anututä yabäŋpäŋ näk nadäŋ naminaŋi jidepäŋ täkaŋ yäŋ nadäŋpäŋ kokwawak täŋ yämik täŋkuk. Ude täŋpäŋ Isrel äbot u mäde ut yämik-inik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Täŋpäŋ Silo komeken yottaba Anutu burenitä bämopiken itta yäwerän täŋ imiŋkuŋo u Anutu uken äneŋi itta nadäk kubä nämo peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Ude täŋkaŋ iwan yäniŋ kireŋirän topmäk-topmäk täŋo kudupi gäpe yottaba u gänaŋ itkuko u yäyomägatkuŋ. Gäpe u terak Anutu täŋo kehäromi ba peŋyäŋeki kwawak kak täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Ude täŋkaŋ ämawebeniyeta kokwawak nadäŋpäŋ iwaniye yäniŋ kireŋirän däpuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Kadäni uken Isrel täŋo äma gubaŋi ämik pähap gänaŋ kumbuŋ. Kumäŋirä webetä äma deken yäpne yäŋ yäŋpäŋ jop itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Kadäni ugän bämop ämaniye udegän däpäkaŋ webeniye konäm kotkät nämo, jop kawuk taŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Eruk ude täŋtäŋ äbäŋkä Ekäni däpmon terak naniktä-yäŋ akuŋkuk. U äma wain ume naŋkaŋ täŋguŋguŋ täŋpäŋ pärekopäŋ kikŋutpäŋ akuŋpäŋ kärak yäweko ude bumik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Ude akuŋpäŋ iwaniye däpmäŋpäŋ pimiŋ yäwat kireŋirän mäyäk tärek-täreki nämo nadäŋpäŋ ämik äneŋi täkta nämo nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Ude täŋkaŋ Josep täŋo oraniye äbot unita mäde ut yämiŋpäŋ, Efraim täŋo äboriye imaka, nämo iwoyäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Täŋ Juda täŋo oraniye äbot u iwoyäŋkuk. Täŋkaŋ Saion pom, Juda täŋo komeken itkuko unita imaka, gäripi nadäk täŋkuko unita iwoyäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Täŋkaŋ pom uken kudupi yori, pom käroŋi ude punin unu täŋkuk. Täŋpäŋ kehäromi-inik täŋkuk, kome pähap täŋpäŋ peŋkuko inide it täyak ude bumik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","71","Täŋpäkaŋ Juda äbot uken nanik epän watä ämani Devit epäni täkta iwoyäŋkuk. U sipsip watä epän äma ude iraniken nanik imagutpäŋ Isrel ämawebe ekäni ba täpurita watä irekta iwoyäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Ude iwoyäŋpäŋ teŋirän Devit iniken epän unitagän nadäŋpäŋ ämawebeniyeta watä säkgämän it yämik täŋkuk. Eruk unita Devit uwä Isrel äbot täŋo watä äma tägagämän-inik ude itkuk. ");
INSERT INTO iou_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","O Anutu, guŋ äbottä gäkŋo kome inita korenayäŋ äbuŋo itkaŋ, u yabätan? U kudupi yotka täŋpä waŋirä imaka jopi äworetak. Ude täŋkaŋ Jerusalem yotpärare imaka, täŋpewä waŋ moretak. ");
INSERT INTO iou_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Ämawebekaye, epän watä ämakaye u däpmäŋpäŋ yepmaŋirä siäŋ ba tom ägwäritä naŋ-irähut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Ude täŋkaŋ ämawebekaye jopjop däpmäŋirä unitäŋo nägäri umeyäwa tägata kweko ude Jerusalem yotpärare bämopiken tokŋeŋkuk. Täŋpäkaŋ u änekta äma kubä nämo itkuk. U kumän paotkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Täŋpäkaŋ guŋ äbot kukŋi kukŋi iranitä yäŋärok niwetpäŋ nibäŋ mägayäkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Unita Ekäni, jide? Ninta kokwawak pen api täŋpen? Ba kokwawakka u kädäptä-yäŋ pen api ijiŋ yäpmäŋ kwek? ");
INSERT INTO iou_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Kokwawakka u ninta nämo, äbori äbori gäk nämo ganiŋoret täkaŋ ba gäkken yäŋapik man nämo yäk täkaŋ unita täŋ yämisi. ");
INSERT INTO iou_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Äma äbot unitä gäkŋo ämawebekaye däpmäŋ-pewä kubäpäŋ komeka u täŋpä waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Äbekniye oraniyetä bian momi täŋkuŋo unita yäŋpäŋ komi epän nämo nimen. Nämo, bänep nadäk-nadäknin putärewani ninta butewaki nadäŋ nimisi. ");
INSERT INTO iou_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Anutu, täŋkentäŋ nimiŋpäŋ iwan keriken nanik nimagusi. Ude täŋpäŋ wäpka biŋamta yäŋpäŋ mominin peŋ nimisi. ");
INSERT INTO iou_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Guŋ äbottä Anutujin de yäŋ niwerirä tägawek? Ude nämo, unita Anutu, guŋ äbottä epän watä ämakaye täŋo nägäri piwä kuŋkuŋo unita kowata komi yämiŋiri kaŋ yabäna! ");
INSERT INTO iou_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Täŋkaŋ notniye komi eŋiken yepmaŋkuŋo yäŋkähän-kähän yäŋ itkaŋ u nadäŋ yämiŋpäŋ kehäromika ärowani terak äma kumäkta biŋam yäŋtärewani u yäniŋ kireŋpewi äpämaŋ kut. ");
INSERT INTO iou_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","O Ekäni, guŋ äbot uken-uken nanik yäŋärok gäwet täŋkuŋo unita kowata kwini nämo täŋ yämen. Nämo, täŋ gamiŋkuŋo u irepmitpäŋ wakiinik täŋ yämen. ");
INSERT INTO iou_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ude täŋiri ämawebekaye nin, yawakaye ude itkaŋ bänep täga man tärek-täreki nämo gäwetpäŋ ganiŋ oretoret api täŋ yäpmäŋ kune. ");
INSERT INTO iou_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Anutu, Isrel täŋo watä äma, gäk nadäŋ nimisi! Gäk Josep täŋo äbot nin, yawak ude watä it nimik täyan. Gäk aŋero täŋo intäjukun äma iriri it gwäjik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Unita gäk kehäromika oraniye Efraim, Bejamin kenta Manase täŋo äbot ninken kwawak pewi ahäwän! Äbä kehäromika nimiŋpäŋ täŋkentäŋ nimi! ");
INSERT INTO iou_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Anutu, gäk äneŋi nimagut yäpmäŋ dubikaken ku. Butewaki nadäŋ nimiŋpäŋ täŋkentäŋ nimiŋiri paotnetawä! ");
INSERT INTO iou_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O Anutu kehäromi mähemi, äbotkaye nintä gäkken yäŋapiŋitna kokwawak nadäŋ nimiŋkä kadäni jidegän api pewen? ");
INSERT INTO iou_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Gäkä ude täŋiri konämpäŋ ketem ude naŋ itkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Täŋpäkaŋ iwaniyetä kukŋi kukŋi itkaŋ yabäŋ äwaräkuk täŋiri nidäpmäŋpäŋ nintäŋo kome korenayäŋ täkaŋ. Täŋpäŋ yäŋärok niwetpäŋ nibäŋ mägayäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Unita Anutu kehäromi mähemi, gäk äneŋi nimagut yäpmäŋ dubikaken ku. Butewaki nadäŋ nimiŋpäŋ täŋkentäŋ nimiŋiri paotnetawä! ");
INSERT INTO iou_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Ekäni, bian gäk äbekniye oraniye, wain yeri kubä ude, Isip komeken nanik yäpmäŋ päbä kome kubäken piwayäŋ yäŋpäŋ äma kome uken nanik yäwat kireŋkun. Täŋpäŋ wain yeri uwä kome u piŋkun. ");
INSERT INTO iou_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Täŋpäŋ yeri u pikta komeni ket täŋpäŋ piŋkun. Täŋpikaŋ jäwäri äpmoŋpäŋ taŋi-inik täŋpäŋ kome taŋi iriŋ wädäŋ yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Täŋpäŋ wain päya unitäŋo momitä pom ba päya taŋi taŋi päke itkuŋo u kudup äyuŋ täŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Täŋpäkaŋ momini uwä kumaŋ päŋku gwägu taŋi wäpi Mediterenian unitä päŋku Yufretis umeken täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Upäŋ gäk imata wain epän täŋo yewa u däpmäŋ weŋkun? Täŋkunopäŋ ämawebe kädet miŋin kuŋat täkaŋ unitä bureni kubota täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Täŋpäkaŋ but ägwäritä jäwäri metäŋ gwäjik täkaŋ. Täŋirä tom ägwäritä mujipi nak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Unita Anutu kehäromi mähemi, gäkä ninta äneŋi nadäŋpäŋ kunum terak ununitä dapun täŋpäŋ nibäŋ niwat. Täŋpäŋ wain päyaka nin täŋkentäŋ nimi. ");
INSERT INTO iou_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Ninäwä wain päya gubaŋi gäkä täŋpewi kehärom taŋkuko udewani. Gäkä yeri u ketka kehäromitä piŋkun. Täŋkuno unita täŋkentäŋ nimik täyi. ");
INSERT INTO iou_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Upäŋkaŋ wain päyaka uwä madäŋpäŋ kädäp ijiwani. Unita iwaniye yabäŋ yäŋiri paot-inik täŋput! ");
INSERT INTO iou_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","O Anutu, ämawebe ninä gäkŋata biŋam iwoyäŋkuno u täŋkentäŋ nimiŋpäŋ äneŋi nibäŋ niwat täyi. Ba kehäromi äneŋi nimik täyi. ");
INSERT INTO iou_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ude täŋ nimiŋiri nin ärowani täŋpäŋ manka äneŋi nämo api irepmitne. Täŋkaŋ wäpka biŋam api ganiŋ oretne. ");
INSERT INTO iou_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Unita Anutu kehäromi mähemi, gäk äneŋi nimagut yäpmäŋ dubikaken ku. Butewaki nadäŋ nimiŋpäŋ täŋkentäŋ nimiŋiri paotnetawä! ");
INSERT INTO iou_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Anutu u kehärominin. Unita bänep oretoret kap teŋ imina. Jekop täŋo Anutu u kap gera terak teŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Oretoret kap yäput pena yäŋpäŋä wagäm utkaŋ gita kurere bok utpäŋ iniŋoret kap teŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Täŋpäŋ komepak api äbäŋirän womat kaŋ piäwut, ba komepak bämop taŋirän orekirit kadäni uken womat piäŋpäŋ kap kaŋ teŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Isrel äbottä kap ude tekta baga pätak. Jekop täŋo Anututä man u yäŋkehärom taŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Anututä ämawebe Isip komeken nanik yämagutkuko kadäni uken man u Josep iwetpäŋ iwoŋärek täŋkuk. Täŋpäkaŋ näk man kotäk kudupi kubä ŋode ahäŋirän nadäŋkut; ");
INSERT INTO iou_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Pitjin terak bäräpi patkuko u ketäreŋ tamiŋkut yäk. Ba komi epänjin täŋo tuŋum u täyomägatpäŋ peŋ tamiŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Täŋpäkaŋ intä komi nadäŋpäŋ gera yäŋirä nadäŋpäŋ täŋkentäŋ tamiŋkut yäk. Iromäŋ mämä gänaŋ käbop itpäŋ nadäŋ tamiŋkut yäk. Täŋpäŋ komi gänaŋ nanik tämagut yäpmäŋ äbätäŋgän Meriba ume terak täŋyabäkken tepmaŋkut. ");
INSERT INTO iou_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Unita Isrel ämawebe äbotnaye, in jukuman täwerayäŋ nadätat ŋo ket nadänayäŋ ba nämo? ");
INSERT INTO iou_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","In mäjo wära nadäŋ yämiŋpäŋ nämoinik yäpmäŋ kuŋatneŋ yäk. Ba guŋ äma täŋo yäwik nämo gwäjiŋ äpmoŋ yämineŋ. ");
INSERT INTO iou_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Nadäkaŋ? Näk Ekäni, intäŋo Anutu bureni-inik. Isip komeken nanik tämagut yäpmäŋ äburo u yäk. Unita in mejin aŋeŋirä ketem tepmäŋ towiwa. ");
INSERT INTO iou_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Ude yäŋkuro upäŋ ämawebenayetä mäde ut namiŋpäŋ näkŋo man unita juku nämo peŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Ude täŋirä yabäŋ äwaräkuk täŋira iniken nadäk-nadäk terak kädet wakiwaki iwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Butewaki! Ämawebenaye, jide? In näkŋo man ŋo juku peŋpäŋ nadänaŋi. Isrel äbotnaye, in näkŋo kädet iwatnaŋi. ");
INSERT INTO iou_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Ude täŋirä uyaku iwanjiye täŋo kehäromi yäpmäŋ äpätet. Ba ketnatä iwanjiye däpmäŋ paotet. ");
INSERT INTO iou_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Ude täŋira iwanjiye, näka bitnäk täkaŋ uwä näka umuntaŋpäŋ gwäjiŋ äpmoŋ namikäneŋ. Täŋpäkaŋ komi epän tärek-täreki nämo yämitet yäk. ");
INSERT INTO iou_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Upäŋkaŋ ämawebenaye, näk inta ketem säkgämän säkgämän tamakaŋ naŋ tokŋewut yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Anututä äma ekäni ekäni unita gera yäŋpewän äbäŋpäŋ käbeyä täŋirä Anututä ini käbeyä täŋo intäjukun äma itak. Intäjukun itkaŋ käbeyäken äma itkaŋ uwä ŋode yabäŋ yäyak; ");
INSERT INTO iou_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","In goret täk täkaŋ yäk. In man käbeyäken äma kädet goret täŋpanita in täga täkaŋ yäŋ yäwet täkaŋ. Ba inä yabäŋ äwaräkuk täŋirä äma wäpi biŋam ikektä äma äpani täŋo wäpi yäpmäŋ äpäk täkaŋ yäk. Kädet u jidegän api peneŋ? ");
INSERT INTO iou_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","4","Unita in kädet täga ŋodepäŋ kaŋ täŋput; Man käbeyäken äma jopi jäwäri ba iroŋi kodäŋa udewani yäŋkentäŋ yämineŋ. Täŋpäŋ ämawebe guŋ ba ini gupi täga nämo täŋkentänaŋi udewanita kädet siwoŋi täŋ yämineŋ yäk. Täŋpäŋ ämatä äma udewani komi epän täŋ yäminayäŋ täkaŋ uwä kaŋ yäniŋ bitnäwut. ");
INSERT INTO iou_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Inä guŋ, nadäk-nadäkjin nämo! Injin bipmäŋ urani gänaŋ kuŋatpäŋ ämawebe kädet siwoŋi nämo yäwoŋärek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Näk bian ŋode täwetkut; Inä anutu bumik, Anutu ärowani täŋo nanakiye itkaŋ yäŋ täwetkut. ");
INSERT INTO iou_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Ude täwetkuro upäŋ apiŋo ŋode täwera nadäwut! Inä kodak nämo api itneŋ yäk. In äma mewunitä kumäk täkaŋ udegän api kumneŋ! Ba intäjukun äma ätutä kumäk täkaŋ udegän kumäŋpäŋ paot-inik api täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Anutu, bureni yäyan! Gäk akuŋpäŋ kome terak yäŋtärek epän tä! Äma äbori äbori kuduptagän u gäkŋo biŋam. ");
INSERT INTO iou_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","O Anutu, man kum nämo iren. Ba kubäkengän kwikinik nämo iren. ");
INSERT INTO iou_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Iwankaye yabäsi! Äma gäka gaŋani pähap nadäŋ gamik täkaŋ u ärowani täŋ gamikaŋ. ");
INSERT INTO iou_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Guŋ äma u ämawebekaye watä it yämik täyan u däpmäkta man käbop käbop yäŋpäŋ-nadäŋ itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Täŋpäŋ ŋode yäkaŋ; Eruk, Isrel äbot u wari nämo itta däpmäŋ morena. Ude täŋitna wäpi paotpäŋ paot-inik kaŋ täŋpän. ");
INSERT INTO iou_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Anutu, gäk täŋpäwakta guŋ äma äbori äbori ŋodetä bänep kubägän täkaŋ; ");
INSERT INTO iou_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Idom kenta Ismael nanik, Moap kenta Hakri nanik, ");
INSERT INTO iou_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ba Gebal, Amonkät Amalek nanik, ba Filistia kenta Tire nanik. ");
INSERT INTO iou_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Täŋpäŋ Siria nanik, äbot kehäromi Lot täŋo oraniye täŋkentäŋ yämiŋkuŋo u imaka, yäpurärätgän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Äma äbori äbori u gäk täŋpäwakta bänep kubägän pekaŋ unita Midian nanikta bian jide täŋ yämiŋkuno ude täŋ yämen. Ba Kison umeken Sisera kenta Jabinta jide täŋ yämiŋkuno udegän täŋ yämen. ");
INSERT INTO iou_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Äma uwä Endo komeken däpmäŋ-pewi kumäŋpäŋ kome äworeŋkuŋo u. ");
INSERT INTO iou_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Täŋpäkaŋ Orep kenta Septa jide täŋ yämiŋkuno u intäjukun ämaniyeta udegän täŋ yämen. Ba Sepa kenta Salmuna täŋpäwak täŋ yämiŋkuno u äma ärowaniniyeta udegän täŋ yämen. ");
INSERT INTO iou_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Äma uwä ŋode yäŋkuŋo unita täŋpäwak täŋ yämiŋkun; Anutu täŋo kome u nininta api korene yäŋ yäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O Anutu, iwaniye u täŋpewi mänittä keŋkeŋ jiraŋ kenta täpun-täpun piäŋ äreyäŋ täŋpän kuk täkaŋ ude kaŋ täŋput. ");
INSERT INTO iou_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","15","Täŋpäŋ kädäptä pom terak tepäraŋ pit kubägän ijiŋ paoreko ude täŋ yämen. Täŋpäŋ yäpä iromäŋ mänitka terak yäwat kireŋ täŋpi kuŋtäŋpä kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Ude täŋpäŋ kehäromika kaŋpäŋ nadäwä tärekta mäyäk pähap yämen. ");
INSERT INTO iou_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Ude täŋiri kehäromini paoräpäŋ gäka tärek-täreki nämo umuntäneŋ. Täŋpäŋ mäyäki pen pat yämiŋirän kaŋ kumbut. ");
INSERT INTO iou_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","O Ekäni, kwawak yäwoŋäreŋiri ŋode kaŋpäŋ nadäwä tärewut; Gäk kubä-tägän Ekäni, kome pähap ŋo kaŋiwatta kehäromi ärowani pat gamitak. ");
INSERT INTO iou_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","O Ekäni ärowani, kudupi yotkata gäripi inide kubä nadätat! ");
INSERT INTO iou_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","U gänaŋ Ekäni iŋamkaken itta bänepna kädäp ijik täyak u inipärik kubä. Bänep nadäk-nadäkna gupna kuduptä Anutu irit mähemi u oretoret kap yäŋteŋ iniŋoret täyiwa. ");
INSERT INTO iou_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Barak imaka, eŋikata gäripi nadäk täkaŋ. Kurasisiptä gäripi nadäŋpäŋ tähani kudupi yotka piriken täk täkaŋ. Ekäni ärowani Anutuna, barak ätu imaka, bägup säkgämän yäŋkaŋ eŋini täŋpäŋ kudupi bukäka dubiniken mujipi pek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Bureni, ämawebe kudupi yotkaken itkaŋ kap terak wari wari ganiŋoret täkaŋ uwä gäkŋo oretoret terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Ba ämawebe kehäromi yäpmäkta gäkkengän kuk täkaŋ u imaka, oretoret terak it täkaŋ. Ämawebe udewani ganiŋ oretta Saion pom terak ärokta pidämtak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Äroŋtäŋgän ämawebe täga u kome kawuki kubä wäpi Baka u irepmirirä iwän säkgämän taŋirän ume dapuri abäŋpäŋ gwägu tokŋeŋ yäpmäŋ kuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Ude ahäŋirän kaŋkaŋ oretoret täŋpäŋ Saion pom kaŋ-ahäkta ehutpäŋ kuŋkä nämo gaŋatak täkaŋ. Nämo, u anutu jopi-jopi kudup yärepmirani Anutu bureni u Saion pom terak api käneŋo unita. ");
INSERT INTO iou_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Ekäni Anutu ärowani, Jekop täŋo Anutu, juku peŋpäŋ yäŋapik mannata nadäsi! ");
INSERT INTO iou_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","O Anutu, intäjukun ämanin iwoyäŋkuno u iron täŋ imisi. ");
INSERT INTO iou_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Täŋpäŋ ŋode yäwa; Kudupi yotkata gäripi pähap nadätat. Kepma kubä uken irero uwä kepma mäyap uken-uken ittäŋ kwero u irepmitpäŋ iret. Äma ätutä äma waki täŋo täha säkgämän säkgämän gänaŋ itta gäripi nadäk täkaŋ upäŋkaŋ nähä äma jopigän itkaŋ Anutuna täŋo eŋi yäma täŋo watä ude irero unita nadäŋira inide kubä täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","U imata, Ekäni uwä watä it nimiŋpäŋ intäjukun täŋ nimik täyak. U kudän tägatäga terak iron täŋ nimiŋpäŋ oraŋ nimik täyak. U äma siwoŋi kuŋaranita imaka täga yämikta nämo bitnäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Bureni-inik! Ekäni ärowani, ämawebe gäka nadäkinik täŋpäŋ gäkä terak yeŋgämä pek täkaŋ uwä oretoret terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Ekäni, komeka ba Isrel ämawebekaye ninta iron täŋ nimiŋiri äneŋi säkgämän itkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Gäk ämawebekaye nintäŋo mominin peŋ nimiŋpäŋ waki täk täŋkumäŋo unitäŋo kowata awähutkun. ");
INSERT INTO iou_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Kokwawak ninta nadäŋ nimiŋkuno upäŋkaŋ peŋ nimiŋkun. Nidäpnaŋipäŋ kokwawakka äneŋi mäde käda peŋkun. ");
INSERT INTO iou_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Unita Ekäni, waki keriken nimagurani, äneŋi gäkŋata biŋam nimagusi. Butewaki Anutu, gäk ninta nadäwäwak wari täŋ nimentawä. ");
INSERT INTO iou_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Ekäni, ninta kokwawak pen api täŋpen? Ba gäkŋo nadäwäwakka pen api it yäpmäŋ ärowek ba? ");
INSERT INTO iou_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Ude nämo! Gäk täŋkentäŋ nimiŋpäŋ irit kuŋat-kuŋat säkgämän äneŋi nimiŋiri ämawebekaye nin oretoret täŋpäŋ kaŋ ganiŋoret täna. ");
INSERT INTO iou_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Ekäni, bänep ironka äneŋi niwoŋäreŋpäŋ waki keriken nanik wädäŋ tädotpäŋ tägaken nipmaŋiri säkgämän kaŋ itna. ");
INSERT INTO iou_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Ai, ämawebenaye, nin kädet waki bian täk täŋkumäŋo u äneŋi täk tänetawä. Nadäkaŋ? Ämawebe iniŋoret täkaŋ uwä Ekänitä irit säkgämän yämiŋpäŋ äbot kubägän yepmak täyak. Mebäri unita Ekäni Anututä man yäŋahäŋirän näk api nadäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Bureni! Ämawebe Anutu oraŋ imik täkaŋ u inita biŋam yäpmäkta nämo bitnäk täyak. Nämoinik. U nin äneŋi nimagutpäŋ Anutu ini ninkät penta itkaŋ komeninken säkgämän api itne. ");
INSERT INTO iou_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Täŋpäŋ kadäni uken Anututä nadäŋ yämik-inik täŋirän ämawebeniyetä bänep nadäk-nadäk Anutu-kengän api peneŋ. Ba Anututä iniken kädet siwoŋi ämawebeniye bämopiken pewän ahäŋirän säkgämän, äbot kubägän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Bureni! Kome terak Anutu täŋo ämawebeniyetä Anutu nadäŋ imikinik täŋirä Anututä käderi siwoŋi api yäwetpäŋ yäwoŋärewek. ");
INSERT INTO iou_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Ude täŋkaŋ iron täŋ nimiŋirän imaka imaka tänayäŋ täkamäŋ u kudup säkgämän ahäŋirä epäninken ketem ahäŋ-bumbum api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Täŋpäkaŋ Anutu täŋo kädet siwoŋitä intäjukun kuŋkaŋ Ekäni täŋo äbäkäbäk kädet api täwirek. ");
INSERT INTO iou_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Ekäni, äma mewuni näka butewaki nadäŋ namiŋpäŋ täŋkentäŋ nam! ");
INSERT INTO iou_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Nadäk-nadäkna kudup gäkkengän peŋpäŋ watä epän ämaka ude itat unita watä säkgämän it namiŋiri wawetawä. ");
INSERT INTO iou_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Ekäni, kepma käroŋ gäkken gera yäŋtäyiwa butewaki nadäŋ namiŋpäŋ geranata juku peyi. ");
INSERT INTO iou_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Gäkgän ganiŋoret täyat unita nadäŋ namiŋpäŋ täŋpewi bänepnaken oretoret pähap kaŋ nadäwa. ");
INSERT INTO iou_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Ekäni, gäk orakorak mähemi unita mominin peŋ nimik täyan. Ämawebe gäkken täŋkentäk yäpmäkta gera yäk täkaŋ u gäripi pähap nadäŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Unita Ekäni, näkŋo yäŋapik manta juku peyi. Näk gäkä butewaki nadäŋ nami yäŋ yäŋpäŋ gera yäyat u nadäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Näk nadätat, gäkken gera yäwayäŋ täyat u api nadäŋ namen unita bäräpi kaŋ-ahäwayäŋ täyatken gäkken gera api yäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Ekäni, gäk udewani Anutu kubä nämo itak. Gäkägän kuduptagän yärepmitan. Täŋpäŋ gäkä epän täga täk täyan u udegän kubä nämo täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Guŋ äbot täŋpäŋ yepmaŋkuno u kudup abä gäk gämotkaken gwäjiŋ äpmoŋ gamiŋpäŋ wäpka api ganiŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","U imata, Ekäni gäk kubä-tägän imaka kudupi kudupi täk täyan. Gäk kubä-tägän Anutu bureni-inik. ");
INSERT INTO iou_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Unita Ekäni, gäk kädetka näwoŋäreŋiri manka burenigän iwat täyiwa! Ket näwoŋäreŋiri gäkagän nadäŋ gamiŋpäŋ ganiŋoret täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Ekäni Anutuna, näk bänepna gupna kuduptagäntä api ganiŋoret täŋpet. Täŋpäŋ wäpka biŋam api oraŋ gamiŋ yäpmäŋ ärowet. ");
INSERT INTO iou_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Gäk butewaki taŋi nadäŋ namik täyan. Kumäkta biŋam täŋkuropäŋ wädäŋ tädotpäŋ nepmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Anutu, äma inita nadäwä ärowani täŋpani ätutä mäde ut namik täkaŋ. Uwä gäkŋo manka utpäŋ nämoinik iwat täkaŋ. Täŋpäŋ näka butewaki nämo nadäŋ namiŋpäŋ käbeyä täŋpäŋ näk nuttagän man yäŋpäŋ-nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Upäŋkaŋ Ekäni, gäk butewaki ba iron mähemi, kokwawak bäräŋeŋ nämo täk täyan. Gäk ämawebekayeta gäripi-inik nadäk täyan. Täŋpäŋ nämo nipmak täyan. ");
INSERT INTO iou_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Unita äneŋi nadäŋ namiŋpäŋ butewaki nadäŋ nam. Piä ämaka näk kehäromi namisi. Piä watä webeka nanaki näk täŋkentäŋ nami! ");
INSERT INTO iou_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Näka not täŋ namik täyan unitäŋo bureni kwawak peŋiri käwayäŋ nadätat. Ude täŋiri kaŋpäŋ iwanaye imaka, Ekänitä täŋkentäŋ imik täyak yäŋpäŋ kaŋ mäyäk tawut! ");
INSERT INTO iou_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Ekänitä pom kudupi terak yotpärareni wäpi Saion täŋpäŋ peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Täŋpäŋ Isrel täŋo kome ätuta gäripi nadäk täyak u irepmitpäŋ Saion yotpärareta gäripi ini pärik kubä nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Unita Anutu täŋo yotpärare, gäk juku peŋkaŋ Anututä gäka man tägatäga ŋode yäyak u nadä; ");
INSERT INTO iou_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Kome näkŋo man buramik täkaŋ unitäŋo wäpi tawaŋ api täŋpet. U täŋpayäŋ täyatken uken guŋ kome, Isip kenta Babilon täŋo wäpi imaka, bok api kudän täwet. Ba Saion itta biŋam wäpi kudän täwayäŋ täyatken uken guŋ kome Filistia, Tire ba Itiopia nanik imaka, bok api kudän täwet. ");
INSERT INTO iou_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Kadäni uken Saionta ŋode api yäneŋ; Komeni komeni ämawebe täŋo eŋi meŋ bureni täyak. Täŋpäŋ Anutu täŋpämorek mähemitä ini täŋ-kehärom taŋpäŋ api pewek. ");
INSERT INTO iou_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Täŋpäŋ Saion täŋo kome mähem bureni-inik täŋo wäpi tawaŋ kudän täwayäŋ täyakken uken ämawebe komeni komeni nanik täŋo wäpi u kudup u gänaŋ api pewek. ");
INSERT INTO iou_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Ude täŋirän ämawebe uwä kap teŋ oretoret bumta täŋpäŋ ŋode api yäneŋ; Saion kome ŋowä iron kädet mebäri mebäri pewä ahäŋ nimani unitäŋo dapuri bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Ekäni Anutu täŋkentäkna, kepma bipani konäm butewaki terak gäkken gera yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Unita yäŋapik manna terak gera yäyat ŋo nadäŋpäŋ täŋkentäŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Bäräpi mebäri mebäri näkä terak äroŋirä kumäŋ-kumäŋ dubiniken itat. ");
INSERT INTO iou_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Ämatä näka nadäŋirä kumäŋpäŋ awaŋ gänaŋ pat täkaŋ ude täyak, kehäromina kudup paotkaŋ unita. ");
INSERT INTO iou_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Näk kumbani ude nepmaŋpäkaŋ it täyat. Ba ämikken däpmäŋ-pewä kumbani, awaŋ gänaŋ pat täkaŋ udewani itat. Ba äma gäkä unita guŋ tak-inik täŋpäŋ nämo täŋkentäŋ yämeno ude bumik itat. ");
INSERT INTO iou_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Nähä awaŋ käroŋi-inik bipmäŋ urani gänaŋ mebäri-ken-inik umu maŋpi äpmoŋpero ude itat ŋo! ");
INSERT INTO iou_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Kokwawakkatä näk kudup uwäk täŋpäŋ yejämäŋtak. ");
INSERT INTO iou_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Gäkä nadäŋiri notnayetä nabäŋpäŋ-nadäŋirä imaka taräki täŋpäpäŋ nabäŋkaŋ umuntak täkaŋ. Näk yewa kehäromi täga nämo abämaŋ kunaŋi, udewani gänaŋ itat. ");
INSERT INTO iou_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Täŋpäŋ dapunna gäyamigän ijiŋ itat. Ude itkaŋ, Ekäni, kepma kepma ketna kewatpäŋ yäŋapik man terak gäkken gera yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Jide? Kumbanitä kakta kudän kudupi pewi ahäk täkaŋ? Nämo! Ba ude täŋiri kumbanitä akuŋpäŋ wäpka yäŋpäŋ ganiŋoret täkaŋ? Nämo, u täga nämo täneŋ! ");
INSERT INTO iou_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Kumbani komeken naniktä gäkä nadäŋ nimikinik täŋpäŋ nämo nipmak täyan unitäŋo biŋam yäŋahäk täkaŋ? Nämo, u täga nämo täneŋ! ");
INSERT INTO iou_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Bipmäŋ urani kome uken kudän kudupi kak täkaŋ? Nämo! Ba peŋpäŋ guŋ taŋpäŋ irani kome udeken naniktä gäkŋo bänep iron täga kaŋpäŋ nadäk täkaŋ? Nämotä nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Unita Ekäni, jop kumbero udeta täŋkentäkta gera yäyat. Tamimaŋ tamimaŋ gäkken gera yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Täŋira imata nämo nadäŋ namik täyan? Ba Ekäni, imata mäde ut namik täyan? ");
INSERT INTO iou_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Näk gubaŋiken umunitä komi namiŋ yäpmäŋ äbäŋiri kumäŋ-kumäŋ dubiniken it täyat. Komi unitä kehäromina kudup näyomägatak. ");
INSERT INTO iou_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Näk nutta kädet mebäri mebäri terak nepmaŋpi wak täyat. Gäkŋo kokwawakka wakiinik unitä näk däpmäŋ jakŋitpäŋ nepmaŋtak. ");
INSERT INTO iou_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Komi u kepma käroŋ näk itgwäjiŋpäŋ umetä tokätkaŋ täk täkaŋ ude yewa täŋpäŋ nepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Täŋpäŋ notnaye-inik u imaka, täŋpewi nabä-kätäŋirä bipmäŋ urani-tägän näkŋo notnapak bureni ude itak. ");
INSERT INTO iou_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","O Ekäni, wari wari nadäŋ nimik täyan unita juku piŋpäŋ kap api tek täŋpet. Ba nämo nibä-kätäk täyan unitäŋo manbiŋam pen api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Imata, nadäŋ nimikinik täk täyan uwä nämo api paorek yäŋ nadäk täyat. Ba kunum inide it täyak udegän nämoinik api nibä-katäweno unita nadäkinik täŋpäŋ api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ekäni, gäk man ŋode yäŋkun; Äma iwoyäŋkuro Devit ukät topmäk-topmäk kubägän täŋpäŋ ŋode yäŋkehärom taŋkut; Äma kubätä äbotken naniktä intäjukun äma nämo api irek. ");
INSERT INTO iou_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Nämo, intäjukun ämata gäkä äbotken nanik-tägän api ahäŋ yäpmäŋ ärok täneŋ yäŋ yäŋkun. ");
INSERT INTO iou_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Ekäni, kunumtä ini ba imaka u terak it täkaŋ unitä gäkŋo täktäkka tägagämän unita kap terak ganiŋ ubiŋ tek täkaŋ. Ba nadäŋ nimikinik täk täyan unita yäŋpäŋ aŋero kudupitä kap teŋpäŋ wäpka yäpmäŋ akuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Kunum gänaŋ kudupi aŋero ba imaka kubä gäk udewani nämo itak. ");
INSERT INTO iou_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Bureni, kudupi aŋerotä Anutu kaŋpäŋ nadäwä inipärik kubä, kehäromi nikek täŋpäpäŋ umuntak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Unita Ekäni Anutu kehäromi mähemi, gäka imaka kehäromi kubä terak utpäŋ täga nämo yäwet. Nämoinik, gäk kehäromi-inik, ba manka kudup iwat-inik täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Gwägu pähap gäk kubä-tägän kaŋiwat täyan. Ba gwägu tokärirän gäk kubä-tägän täga iniŋ bitnäwen. ");
INSERT INTO iou_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Gäk kubä-tägän Isip täŋo kehäromi kudup yomägatpäŋ kehäromikatä iwankaye ätu kudup däpmäŋpäŋ yäwat kireŋkun. ");
INSERT INTO iou_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Kunum u mähemi gäk, ba kome imaka. Kunum kenta kome gäkägän täŋ yepmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Kome moräki moräki, unudetä umude gäkä täŋkun. Unita pom taŋi yarä wäpi Tabo kenta Hemon unitä oretoret terak ganiŋoret täkamän. ");
INSERT INTO iou_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","O Ekäni, gäk ärowani, kehäromi-inik. ");
INSERT INTO iou_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Kaŋiwat epän täk täyan uwä kudän siwoŋi terakgän täk täyan. Nadäŋ yämik-inik täŋo mähemi gäk. Ba yäŋkehäromtak man siwoŋi iwarani u mähemi gäk. ");
INSERT INTO iou_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Unita Ekäni, ämawebe kap terak ganiŋoret täkaŋ ba orakorakka täŋo peŋyäŋek gänaŋ kuŋat täkaŋ uwä oretoret pähap nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Gäka juku piŋpäŋ kepma käroŋ bänep oretoret terak it täkaŋ. Täŋpäŋ iron täŋ yämik täyan unita nadäŋpäŋ wäpka biŋam yäpmäŋ ärok täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Ämawebe unitäŋo kehäromi u gäk. Ba unitäŋo epmäget kudän u gäk. Bureni Anutu, gäk oraŋ nimiŋiri iwaniye yärepmit morek täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Ekäni, Isrel ämawebe täŋo Anutu kudupi gäkä watä ämanin iwoyäŋkuno unitä intäjukun it nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Anutu, bian-inik, gäk ayäbu terak epän ämakaye täga ŋode yäwetkun; Näk komi äma kubä kaŋ-ahäŋpäŋ kehäromi imiŋkut. Äma u ämawebenaye bämopiken iwoyäŋpäŋ intäjukun äma ude teŋkut. ");
INSERT INTO iou_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Äma uwä epän ämana Devit. U intäjukun it tamikta olip umeni piŋ ibatpäŋ iwoyäŋpäŋ teŋkut. ");
INSERT INTO iou_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Unita kehäromi imiŋira kehäromigän api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Ude irirän iwaniyetä ämik täŋpäŋ kehäromini täga nämo api yäpmäŋ äpneŋ, ba äma wakitä täga nämo api irepmitneŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Nämoinik, iwaniye näkŋa-tägän api yeŋ jakŋiret. Äma iwan täŋ iminayäŋ täkaŋ upäŋ api däpet. ");
INSERT INTO iou_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Täŋpäŋ nadäŋ imikinik täŋpäŋ nämoinik api kakätäwet. Nämo, wäpna terak kehäromigän itkaŋ iwaniye api yärepmit morewek. ");
INSERT INTO iou_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Täŋpäŋ täŋkentäŋ imiŋira kome taŋi pähap, gwägu wäpi Mediterenian unitä päŋku ume wäpi Yufretis u inita koreŋpäŋ api kaŋiwarek. ");
INSERT INTO iou_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ude täŋ imiŋira ŋode api näwerek; Gäk näkŋo nanna ba Anutuna. Gäk watä ämana kehäromi pähap, mobä ude. Watä it namiŋiri säkgämän it täyat. ");
INSERT INTO iou_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Yäŋirän gäk nanakna intäjukun nanik yäŋ iwetpäŋ intäjukun äma wäpi biŋam ärowani nikek ude teŋira wäpi biŋamtä kome täŋo intäjukun äma päke u kudup api yärepmirek. ");
INSERT INTO iou_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Topmäk-topmäk kubägän ukät täŋkuro ba ude api täŋ gamet yäŋ yäŋkehärom taŋkuro u nämo api guŋ täwet. Nämo, u pen api nadäŋ yäpmäŋ kuŋaret. ");
INSERT INTO iou_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ude täŋpäŋ näkä täŋpewa kunumtä inide itpäŋ nämo paot täyak udegän Isrel täŋo intäjukun ämawä, unitä äbotken nanik-tägän api ahäŋ yäpmäŋ ärok täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","32","Täŋpäkaŋ unitäŋo äboriye ahänayäŋ täkaŋ u baga manna nämo buramiŋpäŋ man kädetna mäde ut iminayäŋ täkaŋ uwä momini unita kowata yämiŋira komi api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Upäŋkaŋ Devit ba nanakiye oraniye nämoinik api yabäŋ kätäwet. Yäŋ-kehäromtak man iwetkuro u nämo api irepmiret. Nämo! Pen nadäŋ imikinik api täk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Bureni-inik! Topmäk-topmäk ukät täŋkuro u nämo api madäŋ täkŋewet ba manna täpuri-inik kubä nämoinik api irepmiret. ");
INSERT INTO iou_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Wäpna kudupi u terak bureni-inik ŋode yäyat; Devit jopman kubä nämo iwetkut ba nämoinik api iweret. ");
INSERT INTO iou_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Nämo, äboriye pen api weŋ bäyaneŋ. Näk mehamtäŋ imiŋira edaptä ijiŋ yäpmäŋ kwayäŋ täyak udegän kaŋiwat epänitä pen api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Ba komepaktä inide peŋyäŋek täyak udegän it yäpmäŋ äroŋirä ämawebetä ŋode api nadäneŋ; U ka! Komepak inide it täyak ude, Anututä mani nämo guŋ taŋpäŋ kehäromigän iwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Ekäni, ude yäŋkuno upäŋkaŋ apiŋo intäjukun ämaka iwoyäŋkuno unita kokwawak nadäŋ imitan. Täŋpäŋ mäde ut imiŋpäŋ itan. ");
INSERT INTO iou_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Täŋpäŋ topmäk-topmäk kehäromi epän ämaka ukät täŋkuno u madäŋ täkŋeŋpäŋ gwäpäni säkgämän yäpmäŋpäŋ okä näbä gänaŋ maŋpi-äpmokaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Täŋpäŋ yotpärareni täŋo yewa kehäromi pähap u wärämutkun. ");
INSERT INTO iou_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Wärämuriri äma kuŋ-äbäŋ täk täkaŋ uwä tuŋumi kubotäŋ imiŋpäŋ kaŋ-mägayäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Yäniŋ kireŋiri iwaniyetä kehäromini yäpmäŋ äpäŋpäŋ oretoret bumta nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Ämik täŋpäŋ gäk täŋpewi ämik täŋo tuŋumitä nämo täŋkentäŋ imiŋirä iwaniyetä irepmitkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Gäk wäpi biŋam yomägatpäŋ gwäpäni säkgämän u jop maŋpi kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ude täŋiri kadäni nämo täreŋirän äma tägawani, kehäromi nikek nämo, bäräŋeŋ äworetak. Täŋpäŋ mäyäk pähap nadätak. ");
INSERT INTO iou_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Ekäni, butewaki. Käbop pen api iren? Ba kokwawakka kädäptä ijik täyak ude pen api täŋpen. ");
INSERT INTO iou_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Näkŋo mebärinata guŋ täwentawä. Kome terak iritna u keräpigän. Nin kudup kumäk-kumäk ikek täŋ nipmaŋkun. ");
INSERT INTO iou_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Netätä nämo kumäŋpäŋ kadäni käroŋi irek? Äma kubätä kehäromigän itkaŋ awaŋ gänaŋ täga nämo äpmoŋpek? Nämoinik. ");
INSERT INTO iou_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","O Ekäni, bian nadäŋ nimikinik täŋkuno u de pewi kukaŋ? Täŋpäŋ yäŋkehäromtak man Devit iwetkuno unita jide nadätan? ");
INSERT INTO iou_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Guŋ ämatä epän watä ämaka näka yäŋärok näwet täkaŋ unita nadäŋ äwaräkuk nämo täŋpen. Nämo, kowata yämen! ");
INSERT INTO iou_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Ekäni, nadä! Intäjukun ämaka näk iwoyäŋkuno u kome deken deken kuŋarira guŋ ämatä sära man näwet täkaŋ u nadätan? ");
INSERT INTO iou_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Eruk, Ekäni wäpi biŋam tärek-täreki nämo iniŋoret täkäna! ");
INSERT INTO iou_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Ekäni, gäk eŋinin bureni ude bian itkunonitä pen it yäpmäŋ äbätan. ");
INSERT INTO iou_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Kunum kenta kome nämo pewi ahäŋirän gäk Anutu itkun. Gäk Anutu pengän itkunonitä pen api it yäpmäŋ ärowen. Paotpaotka nämo. ");
INSERT INTO iou_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Gäk äma ŋode yäwet täyan; In äneŋi kome äworewut. Ude yäŋpäŋ äma täŋpewi kome äworek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Täŋpäkaŋ kadäni käroŋi pähap, obaŋ 1,000 ude u nadäŋiri kepma kubägän ude täk täyak. Däpmon paritna bipani kubä ahäŋpäŋ paot täyak ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Täŋpäkaŋ ume tokätpäŋ äma kumäŋ-kumäŋ däpmäŋpäŋ yäpmäŋ kuk täyak gäk äma täŋo irit ude täŋpewi paot täkaŋ. Täŋiri ämatä kome terak kadäni keräpi ayäbu täk täkamäŋ ude it täkamäŋ. Ba wädantä bäräŋeŋ ärok täkaŋ ude it täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Tamimaŋ mänit säkgämän yäpmäŋpäŋ itkaŋ kome ijiŋirän bipäda bäräŋeŋ kubitak täkaŋ. Äma uwä udewanigän. ");
INSERT INTO iou_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Täŋpäkaŋ gäkŋo kokwawaktä nidäpmäk täyak. Ba gäkŋo bänep wakwakta bumta umuntak täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Imaka wakiwaki käbop ba kwawak täk täkamäŋ u gäkä kwawakgän peŋpäŋ yabäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Kokwawak nadäŋ nimiŋiri nin kome terak ahäŋ paot täk täkamäŋ. Täŋpäkaŋ nin kähän yäŋpäŋ paot täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nin kadäni käroŋi nämo it täkamäŋ. Obaŋ 70 ude nämo itkaŋ paot täkamäŋ. Ba kehäromigän pen itpäŋä obaŋ 80 täga käwep kaŋ-ahäne. ");
INSERT INTO iou_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Ekäni, kokwawakka täŋo kehäromi kudup niwoŋärewi yäwänäku äma kubätä täga nämo itek. Ba umun pähap jidewanipäŋ nadäkkäne? ");
INSERT INTO iou_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Unita gäk kwawak niwoŋäreŋiri kome terak irit kuŋat-kuŋatnin u keräpigän it täkamäŋ yäŋ mebäri nadäna tumbut. Ket ude nadäna tumbäpäŋ nininta nadäna äpani täŋpäpäŋ gäkken nanik nadäk-nadäk säkgämän u terakgän kaŋ kuŋatna. ");
INSERT INTO iou_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Ekäni, gäkŋo kokwawak jidegän api paorek? Ba gäk jidegän äneŋi äyäŋutpäŋ epän ämakaye ninta butewaki api nadäŋ nimen? ");
INSERT INTO iou_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Täŋpäkaŋ gäk tamimaŋ tamimaŋ ironka pähap iritninken pewi tokŋeŋirän bänep oretoret nadäŋpäŋ ganiŋoret kap tek täkäna. ");
INSERT INTO iou_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Nin kadäni käroŋi-inik bäräpigän nadäŋ yäpmäŋ äbumäŋ. Eruk apiŋo gäk bänep oretoret taŋi nimisi, obaŋ jide bäräpi nimiŋ yäpmäŋ äbuno udegän. ");
INSERT INTO iou_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Kehäromika terak imaka tägatäga täk täyan u epän ämakaye niwoŋäre. Täŋpäŋ iroŋiniye ba oraniye ahänayäŋ täkaŋ uwä udegän kaŋ yäwoŋäre. ");
INSERT INTO iou_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Täŋpäkaŋ Ekäni Anutunin, konka pähaptä nintä terak äroŋirän imaka imaka tänayäŋ täkamäŋ unitäŋo bureni kwawak kaŋ ahäwut. ");
INSERT INTO iou_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Äma kubätä iwantä nutneŋ yäŋpäŋ Anutu ärowani-inik dubiniken kuŋirän käbop tewek. ");
INSERT INTO iou_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Täŋpäŋ Ekäni ŋode iwerek; Näk käbop irit bägupkaken äreŋira watä it namik täyan yäk. Anutuna, näk nadäŋ gamikinik täk täyat yäŋ iwerek. ");
INSERT INTO iou_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Bureni-inik, Anututä watä kehäromi it gamiŋirän, imaka käbop itak unitä gäk nämo täŋpän waneŋ. Ba käyäm wakitä gepmäŋirekta api täŋkentäŋ gamek. ");
INSERT INTO iou_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Anututä säkgämän uwäk täŋpäŋ api gepmaŋpek, baraktä nanaki uyiŋpiŋit pat täkaŋ ude. Näk watä it gamik täyat yäŋ yäk täyak uwä bureni-inik täk täyak. Unita gäk Ekänikät iriri ämatä ämik täŋo kurepä tageŋpäŋ it täkaŋ ude Ekänitä ude api täŋ gamek. ");
INSERT INTO iou_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Anututä watä it gamiŋirän gäk bipani imaka umuri kubäta nämo umuntäwen. Ba kepma imaka kubä gäkä terak bäräŋeŋ-inik äroŋpäŋ täŋpän waneŋ yäŋpäŋ nämo umuntäwen. ");
INSERT INTO iou_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Täŋpäkaŋ gäk käyäm taŋi ba imaka wakitä kepma ba bipani ahäŋ namineŋ yäŋpäŋ nämo umuntäwen. ");
INSERT INTO iou_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Äma mäyapiniktä dubikaken kumäŋirä näk udegän kumbet yäŋ nämo nadäwen. ");
INSERT INTO iou_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Nämo! Gäk säkgämän api iren. Täŋpäkaŋ äma waki täŋpani u kowata Anututä kwawak yämiŋirän api yabäwen. ");
INSERT INTO iou_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ekäni u gäka watä kehäromi-inik it täyak. Anutu ärowani uken päŋku imaka wakita käbop it täyan. ");
INSERT INTO iou_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","U iriri imaka wakitä gäkä terak nämo api ahäwek. Ba käyäm wakitä gäkä eŋi gänaŋ nämo api ärowek. ");
INSERT INTO iou_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","12","Anututä aŋeroniye watä it gamikta yepmaŋkuko unitä api oraŋpäŋ gepmaneŋ. Ude täŋirä kuroŋka ba gukutka nämo api pimiŋ tädoren. ");
INSERT INTO iou_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Täŋpäkaŋ gäk aŋ komi ba gämok täga api yeŋ yepmäŋiren. ");
INSERT INTO iou_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Täŋpäŋ Anututä ŋode yäŋkuk; Ämawebe näka gäripi nadäk täkaŋ uwä api täŋkentäŋ yämet yäk. Ba ämawebe nadäŋ namikinik täk täkaŋ uwä watä it yämet yäk. ");
INSERT INTO iou_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Äma udewani näkken gera yänayäŋ täkaŋ uwä api nadäŋ yämet yäk. Täŋpäkaŋ bäräpi ahäŋ yämiŋirä näk täŋkentäŋ yämiŋpäŋ wäpi biŋam ikek api yepmaŋpet yäk. ");
INSERT INTO iou_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Täŋpäkaŋ näkä kome terak irit kuŋat-kuŋari yäpurärät-pewa api käroŋtaŋ yämek yäk. Ude täŋira äma u ŋode api yäneŋ; Uraknin u täŋkentäknin bureni yäŋ api yäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Juda naniktä kap ŋo Sabat kadäni kubäkubäken tek täŋkuŋonik. Ekäni, gäk ärowani pähap. Gäka bänep täga man gäwetpäŋ ganiŋ orerira bänepna pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Täŋpäŋ iron täŋ namik täyan unita tami tami yäŋahäŋit watä säkgämän it namik täyan unita bipani bipani yäŋahäŋira bänepna pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Unita näk gita utpäŋ gäk wäpka yäpmäŋ akuk täyiwa. ");
INSERT INTO iou_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","O Ekäni, gäk epän täŋiri kaŋpäŋ bänepna tägak täyak. Ba ketka kudän kaŋpäŋ oretoret kap tek täyat. ");
INSERT INTO iou_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Gäk nadäk-nadäkka ärowani-inik. Täŋpäŋ epän täk täyan u imaka, ärowani-inik. ");
INSERT INTO iou_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Täŋiri äma bänep nadäk-nadäki nämotä gäkŋo täktäkkata täŋguŋtak täkaŋ. Ba äma nämo nadäŋ tumbani, guŋ udewanitä täga nämo nadäŋ gamik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Äma kädet waki täŋpani udewanitä nämo nadäŋ gamik täkaŋ upäŋkaŋ wädantä tägak täkaŋ ude tägaŋpäŋ imaka imaka yäpmäk täkaŋ. Ude täk täkaŋ upäŋ kämiwä kudup api waŋ moreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Imata, Ekäni gäk intäjukun-inik, paot-paotka nämo it täyan unita. ");
INSERT INTO iou_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Ekäni, äma udewani unita ŋode nadäkamäŋ; Äma waki täŋpanitä täga nämo api itneŋ. Nämoinik! Gäka iwan täŋ gamik täkaŋ uwä kudup api däpmäŋ morewen. ");
INSERT INTO iou_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Täŋpäkaŋ gäkä kehärominawä bulimakau ägwäri täŋo kehäromi ude peŋ namiŋkun. Ude täŋpäŋ nadäŋ namiŋpäŋ ume käbäŋi nikek ärut namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Täŋpäŋ täŋkentäŋ namiŋiri iwanaye kumän waŋ moreŋirä yabätat. Ba äma waki täŋpanitä kähän yäŋirä nadätat. ");
INSERT INTO iou_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Täŋpäkaŋ ämawebe siwoŋi kuŋaraniwä agäba päyani ärok täkaŋ udewani. Ba päya käroŋitä äromaŋ kuk täkaŋ ude säkgämän api it yäpmäŋ äroneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Uwä päya Ekäni täŋo eŋi yämaken piwani, säkgämän, kehäromi nikek udewani. ");
INSERT INTO iou_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Äma udewani uwä nadäkiniki kodakigän pen api it yäpmäŋ kwek. Uwä päya biani-päŋkaŋ kodakigän itkaŋ bureni säkgämän pat täkaŋ ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Unita ŋode api yäŋahäneŋ; Ekäni u tägagämän yäk. Nin kehäromigän täŋkentäŋ nimik täyak yäk. Uken kädet goret kubä nämo kak täkamäŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Ekäni uwä intäjukun-inik itak. Uwä ekäni ärowani. Wäpi biŋam säkgämäntä teki ude it täyak. Täŋkaŋ pioŋ yamäk täkaŋ ude kehärominipäŋ yamäk täyak. U komeni komeni täŋmeham täŋpäŋ pewän wareŋi nämo it täyak. ");
INSERT INTO iou_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Ekäni, gäk bian kome ŋoken imaka kubä nämo itkukken intäjukun itkun. Täŋkaŋ bian umuken intäjukun itkunonitä paot-paori nämo intäjukun it yäpmäŋ äbätan. ");
INSERT INTO iou_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","4","Täŋpäkaŋ kome terak imaka imaka kehäromi nikek itkaŋ uwä gäkä yärepmitan. Gwägu käroŋi boham uwä mämä taŋi yäk täyak. Ba gwägutä taŋi tokätpäŋ mämä pähap yäk täyak upäŋkaŋ Ekäni, gäkŋo kehäromika uwä ärowani pähap. Gäkŋo kehäromikatä imaka imaka kuduptagän yärepmitak. ");
INSERT INTO iou_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Ekäni, gäkŋo man kädet u kehäromigän, paot-paori nämo. Ba gäkŋo kome uwä kudupi-inik itkukoniktä api it yäpmäŋ ärowek! ");
INSERT INTO iou_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Ekäni, gäk äma wakita kowata yämani Anutu. Unita apiŋo kokwawakka kwawak pewi ahäŋirän käwa! ");
INSERT INTO iou_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Gäk ämawebe kuduptagän täŋo täktäki yäpmäŋ daniwani Anutu. Unita bäräŋeŋ päbä äma gup yäpmäŋ ärokärok täŋpani komi yäpnaŋi u yämi! ");
INSERT INTO iou_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","O Ekäni, äma wakiwaki täŋpanitä wakinita yäŋpäŋ oretoret täŋ yäpmäŋ kuŋirä kadäni jidegän api tärewek? Kowata jidegän api yämen? ");
INSERT INTO iou_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Äma udewanitä täŋpäwak kudänita gupi yäpmäŋ äroŋpäŋ inita biŋam wari wari yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Äma udewani ämawebe gäkŋata biŋam iwoyäŋkuno u komi bumta yämiŋpäŋ yeŋ däpmäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","U webe kajat ba nanak kodäŋani däpmäŋ-pewä kumäk täkaŋ. Ba kubäken nanik ninkät bok irani unita udegän jop nadäŋ däpmäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Ude täŋkaŋ ŋode yäk täkaŋ; Kudän ude täk tämaŋ uwä käbop täk tämamäŋ. Ekäni, Isrel täŋo Anutu u nämo nibäŋpäŋ nadäk täyak yäk. ");
INSERT INTO iou_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Äma täŋpäwak täŋpani in ude yäk täkaŋ upäŋkaŋ jidegän api nadäwä täreneŋ? Inä guŋ bureni-inik! ");
INSERT INTO iou_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Man ude yäk täkan uwä yänaŋi nämopäŋ yäk täkaŋ. Anutu, jukunin dapunin täŋkuko u täga nämo tabäŋpäŋ nadäwek? U siwoŋi tabäŋpäŋ-nadäk tayak! ");
INSERT INTO iou_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","U guŋ äbotta komi yämik täyak unita inta komi udegän täga api tamek. U ämawebe kuduptagän täŋo yäŋpäŋ-yäwoŋärek äma unita nadäk-nadäki nämo yäŋ nämo nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Nämo! Anututä äma täŋo nadäk-nadäki kudup yabäŋpäŋ-nadäk täyak. Nadäk jide pewä ahäk täkaŋ u jopigän yäŋ nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Täŋpäkaŋ Ekäni, äma gäkä jukuman yäwetpäŋ yäwoŋärek täŋiri buramik täkaŋ u gäkŋo oretoret terakgän kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Gäk bäräpi ketäreŋ yämiŋiri gup gapun gapun terakgän it täkaŋ. Ude it yäpmäŋ kuŋirä äma waki täŋpani awaŋ gänaŋ äpmoŋirä kaŋ yabäwut! ");
INSERT INTO iou_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Unita bureni-inik nadätat, Ekäni gäkä ämawebe gäkŋata biŋam iwoyäŋkuno u nämoinik api yabä-kätäwen. ");
INSERT INTO iou_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Nämo, äma waki täŋpani unitä ämawebe täŋo man goret yäpmäŋ danik täkaŋ u gäkä täŋpewi siwoŋi api ahäwek. Ude täŋiri äma siwoŋi siwoŋitä kädet u api täŋ-kehärom täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Ämawebe, yäŋyabäk ŋode täwet yabäwa; Netätä äma wakiwaki täŋpani iŋamiken näk gärak itkuk? Ba näkŋo man netätä yäŋkentäŋ namiŋkuk? ");
INSERT INTO iou_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Unita man ŋode täwera nadäwut; Ekänitä täŋkentäŋ namiŋkuk! Nämo täŋkentäŋ namiŋkuk yäwänäku näk bäräŋeŋ kumäŋpeŋ päŋku kum irit komeken iram. ");
INSERT INTO iou_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Yäke! Näk maŋ nutnayäŋ täkaŋ! yäŋ yäŋkut. Upäŋkaŋ nämo! Ekäni, butewakika tärek-täreki nämo u terak oraŋ namiŋiri nämo maŋ nutkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Nadäwätäk bäräpi mebäri mebäri ahäŋ namiŋirä upäkaŋ gäkä naniŋ kawat taŋiri oretoret terak kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Ekäni, näk nadätat. Gäk äma ekäni ekäni waki täŋpanikät epän bok nämo täk täkaŋ. Äma udewaniwä kudän wakita siwoŋigän yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Ude täŋkaŋ ämawebe siwoŋita komi yämikta tawaŋ peŋpäŋ äma momini nämo, jop nadäŋ kumäkta yäniŋ kirek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Upäŋkaŋ Ekäni Anutunatä äma waki iŋamiken näk gärak itpäŋ täŋkentäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Täŋkaŋ Ekäni Anutunintä äma waki mominita yäŋpäŋ komi yämiŋpäŋ kudup api täŋpän waneŋ. ");
INSERT INTO iou_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ämawebe, in äbut! Äbäkaŋ Anututa iniŋoret kap teŋ imina! Anutu u watä it nimiŋkaŋ umuri-ken nanik nimagut täyak unita iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Iŋamiken ahäŋpäŋ bänep täga kap iniŋ ubiŋ tena! ");
INSERT INTO iou_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Nadäkaŋ? Ekäni u Anutu pähap. Uwä wäbät ba imaka anutu yäŋ yäwet täkaŋ u kudup intäjukun-inik it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ume kubat ba pom käroŋi käroŋi kuduptagän u Ekäni täŋoniktä itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Ini-tägän kome ba gwägu pähap yäŋirän ahäŋkuŋo unita mähemi bureni-inik itak. ");
INSERT INTO iou_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Unita in äbut! Ekäni nin kudup täŋpäŋ-nipmaŋpani u dubiniken äbäŋpäŋ gwäjiŋ äpmoŋpäŋ iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Uwä nintäŋo Anutu itkaŋ yawakiye ude iritna nibäŋ niwatpäŋ ketem nipmäŋ towik täyak. ");
INSERT INTO iou_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Unita Ekänitä ŋode niwerirän nadäna; Äbekjiye orajiyetä bian Meriba Masa komeken näkŋo man bitnäŋpäŋ ärowani täk täŋkuŋo u in udegän nämo täneŋ. Apiŋo näkŋo man nadäŋ parit ärowani nämoinik täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Nämo! Näk imaka tägatäga täŋira yabäŋkuŋo upäŋkaŋ äbekjiye orajiye uwä mäde ut namikinik täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ude täŋ namiŋirä kokwawak nadäŋ yäpmäŋ kuŋira obaŋ 40 ude täreŋkuk. Täŋpäŋ yäŋkut; Näka nadäkinik nämo täŋ namiŋpäŋ näkŋo kädet iwatta bitnäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Unita kokna wawäpäŋ man kehäromi ŋode yäŋkut; Äbot uwä äbä orek näkkät nämoinik api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Komen ämawebe kuduptagän, nin Ekänita kap kodaki kubä teŋ imina! ");
INSERT INTO iou_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Ekänita kap teŋ imiŋpäŋ wäpi iniŋ oretna! Täŋpäŋ yäpätägak epän täŋkuko unitäŋo manbiŋam kepma kepma ämawebe kap terak yäwet täkäna! ");
INSERT INTO iou_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Bureni! Wäpi biŋam ärowani ba kudän kudupi täk täyak unitäŋo manbiŋam ämawebe komeni komeni yäŋahäŋpäŋ yäwetna! ");
INSERT INTO iou_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","5","Imaka imaka ämawebe komeni komenitä nadäŋ yämik täkaŋ uwä jopigän. Upäŋkaŋ Ekäni ini-tägän kunumkät imaka imaka punin itkaŋ u täŋpäŋ peŋkuk. Bureni! Ekäni u wäpi biŋam ikek unita unitäŋo wäpi biŋamä yäpmäŋ akuŋpäŋ punin unu pena! Täŋ, wäbät nämo nadäŋ yämine. Nämoinik! Ekänitagän umuntak täkäna! ");
INSERT INTO iou_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Ekäni uwä wäpi biŋam pähap ikek unitä Intäjukun Äma itak. Ba iniken eŋini udegän, kehäromi, epmäget tägagämän ikek. ");
INSERT INTO iou_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Unita äma äbori äbori, in kuduptagän Ekäni iniŋ orerut! Ekänitä iniken täktäki ba kehärominita yäŋpäŋ wäpi biŋam yäpmäŋ akukot! ");
INSERT INTO iou_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Wäpi biŋam iniŋ oretkaŋ imaka kubä Ekäni iniŋ oretta pewani yäpmäŋ iniken eŋi gänaŋ ärowut! ");
INSERT INTO iou_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Nadäkaŋ? Ekäni u kudupitä kudupi-inik unita ämawebe komeni komeni Anututa nadäŋpäŋ kwaineŋ. ");
INSERT INTO iou_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Täŋpäkaŋ Anutu täŋo ämawebe, in äma äbori äbori ŋode kaŋ yäwerut; Ekäni uwä intäjukun itkaŋ kome täŋ-kehärom taŋkuk. Täŋpäkaŋ kometä säkgämän itpäŋ wareŋi nämo pat täyak. Täŋpäkaŋ kämi Ekänitä iniken nadäk-nadäk siwoŋi terak äma äbori äbori yäpmäŋ daniŋpäŋ api yabäŋ yäwarek. Ude kaŋ yäwerut! ");
INSERT INTO iou_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ai! Kunum ba kome, ek oretoret täkon! Täŋpäŋ gwägu pähap, gäk ba imaka imaka gäk gänaŋ kuŋat täkaŋ in gera mämä täŋput! ");
INSERT INTO iou_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Epän, inkät ketem in gänaŋ itkaŋ u kudup Ekäni iniŋ orerut! Täŋpäkaŋ Anutu iŋamikenä päya bipiken päke itkaŋ u kuduptagän kap teŋpäŋ oretoret kaŋ täŋput! ");
INSERT INTO iou_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","U imata, Ekäni uwä äbayäŋ täyak. Äbäŋpäŋä ämawebe komeni komeni iniken nadäk-nadäk siwoŋi terak yabäŋ yäwatpäŋ man bureni terak api yäpmäŋ daniwek. ");
INSERT INTO iou_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Ekänitä intäjukun-inik itak. Unita kome taŋi, ba kome täpuri täpuri gwägu bämopiken itkaŋ, in bänep täga nadäŋ imiŋpäŋ oretoret täkot. ");
INSERT INTO iou_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Ekäni uwä kudupi-inik. Gubam kenta bipmäŋ uranitä kumän uwäk täŋ paot täyak. Täŋkaŋ unitä ämawebe yabäŋ yäwat epän säkgämän siwoŋi täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Täŋpäkaŋ uwä jop nämo kuŋat täyak. Nämoinik, kädäp mebet täŋpewän intäjukun kuŋkaŋ iwaniye ijiŋ paot täyak. ");
INSERT INTO iou_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Ekäni Anututä yäŋpewän yäpä kwinirirän kome yäŋek täyak. Ude ahäŋirän kometä kaŋkaŋ kwaik täyak. ");
INSERT INTO iou_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Anutu uwä kome pähap täŋo intäjukun. U äbäŋirän kome pähap ŋo kokoyäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Kunum ba imaka imaka u terak it täkaŋ unitä Anutu kudän siwoŋi täk täyak unitäŋo manbiŋam pewä ahäk täkaŋ. Täŋirä ämawebe u kaŋpäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Unita ämawebe anutu jopi-jopi yäniŋ oret täkaŋ uwä bumta mäyäk tänaŋi. Anutuniye u tägagämän yäŋ yäk täkaŋ. Upäŋkaŋ nämo! Anutu jopi-jopi kuduptagän u Ekäni iniŋ oretnaŋipäŋ. ");
INSERT INTO iou_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Anutu, yäpmäŋ danik-danik epän täk täyan u siwoŋi unita ämawebe kuduptagän Saion yotpärareken nanik ba Juda komeken nanik bänep täga pähap nadäŋpäŋ oretoret pähap täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Ekäni, gäk ekäni ärowani. Gäkä kome pähap ŋo watä it täyan. Gäk wäpka ärowani pähap. Imaka kome terak ba anutu jopi-jopi kumän yärepmitan. ");
INSERT INTO iou_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Täŋpäkaŋ Anututä ämawebe imaka waki-wakita taräki nadäk täkaŋ unita gäripi nadäŋ yämik täyak. Täŋpäŋ ämawebeniye watä säkgämän it yämiŋpäŋ äma wakiwaki keri terak nanik yämagut täyak. ");
INSERT INTO iou_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Bureni, ämawebe kudän täga täŋpani u Anututä peŋyäŋek bänepiken peŋirän oretoret terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Ai! Ämawebe siwoŋi kuŋat täkaŋ, in Ekänijin unita yäŋpäŋ bänepjinken oretoret pähap nadäk täkot! Piä taŋi täk täyak u nadäŋpäŋ iniŋ oretkaŋ U äma kudupi-inik yäŋ nadäk täkot! ");
INSERT INTO iou_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Ekänitä imaka mebäri mebäri tägagämän pewän ahäŋ nimiŋkuŋo unita kap kodaki kodaki terak iniŋoret täkäna! Ekäninin u siwoŋi, kehäromini terak iwaniye kudup täŋo kehäromini yäpmäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Ekänitä ämawebeniye iwan keriken nanikpäŋ yämagurirän ämawebe komeni komenitä kehäromini kwawakinik kaŋpäŋ nadäŋkuŋ. Ude täŋirän kudän siwoŋi-inik täk täyak yäŋ kaŋpäŋ nadäwä täreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Isrel ämawebeta watä pen api it yämet yäŋ bian yäŋkuko u nadäŋpäŋ ämawebeniye nämo yepmaŋkuk. Täŋirän ämawebe komeni komeni naniktä täktäki u kaŋpäŋ nadäŋpäŋ yäŋkuŋ; Anutu u ämawebeniye iwan keri terak nanikpäŋ yämagutkuk yäk. ");
INSERT INTO iou_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Unita ämawebe in kuduptagän kome terak itkaŋ, in Ekäni iniŋoret kap teŋpäŋ wäpi yäpmäŋ akuk täkot! ");
INSERT INTO iou_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","6","Ude täŋpäŋ bigoŋ utpäŋ iniŋoret kap teŋit womat piäŋit, uhuwep bok piäk täkot yäk. Bänep tägagämän nadäŋpäŋ Ekäni ärowani gera terak iniŋoret täkot! ");
INSERT INTO iou_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Ai! Gwägu taŋi, tom gäk gänaŋ itkaŋ u ba kome ba ämawebe, in kuduptagän Ekäni wäpi yäpmäŋ akuk täkot! ");
INSERT INTO iou_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Ume, in mämä taŋi yäk täkot! Pom, in imaka udegän, Ekäni iŋamiken oretoret täŋpäŋ kap tek täkot! ");
INSERT INTO iou_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","U imata, uwä Anutu Bureni-iniktä äbäŋpäŋ yabäŋ yäwat epän säkgämän siwoŋi täŋkaŋ iniken nadäk-nadäk siwoŋi terak ämawebe api yäpmäŋ daniweko unita! ");
INSERT INTO iou_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Ekäni u intäjukun-inik itak. Aŋero keri kukŋi kukŋi irirä u bämopiken maŋit iitak. Unita ämawebe uken-uken nanik kaŋpäŋ nadäŋpäŋ umuntaŋpäŋ kwaik täkot! ");
INSERT INTO iou_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Ekäni uwä Jerusalem yotpärareken itkaŋ wäpi biŋam ärowani nikek it täyak. Itkaŋ ämawebe äbori äbori komeni komeni intäjukun it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Bureni! Ekäni u kudupi unita ämawebe päke u Ekäni intäjukun-inik itak yäŋ nadäk täkot. Ude nadäŋpäŋ wäpi biŋam yäpmäŋ akuk täkot! ");
INSERT INTO iou_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Intäjukun ämanin, gäk kehäromika nikek itkaŋ kädet siwoŋitagän gäripi nadäk täyan. Ekäni, bureni, gäk Isrel ämawebe nin kädet siwoŋi niwoŋäreŋiri ugän iwat täkamäŋ. Niwoŋäreŋiri ämawebe ätu nämo täŋyäkŋat täkamäŋ. Nämo, kudän täga-tägagän yäwoŋärek täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Unita ämawebe, Ekänijin wäpi yäpmäŋ akuk täkot! U Anutujin bureni. U kudupi-inik unita dubiniken kuŋpäŋ wäpi iniŋoret täkot! ");
INSERT INTO iou_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Nadäkaŋ? Moses kenta Aron uwä Ekäni unitäŋo bämop äma ude itkumän. Ba Samuel u imaka, Anutu iniŋ orerani äma kubä. Äma uwä Ekäniken yäŋapiŋirä nadäŋ yämik täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Täŋpäkaŋ Ekäni uwä gubam gänaŋ itkaŋ baga man yämiŋkuk. Yämänkaŋ baga man u kudup iwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Ekäni Anutunin, gäk ämawebekaye täŋo yäŋapik man u nadäŋ yämik täŋkun. Gäk gäkŋa-tägän ämawebekaye ŋode yäwoŋäreŋkun; Gäk momini peŋ yämani Anutu. Momini peŋ yämik täŋkuno upäŋkaŋ wakini u yäpä-siwoŋtakta komi yämik täŋkun. ");
INSERT INTO iou_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Unita ämawebe, Ekäni Anutunin wäpi yäpmäŋ akuk täkäna! Täŋpäŋ unitäŋo pom kudupiken kuŋpäŋ gwäjiŋ äpmoŋ imiŋpäŋ iniŋoret täkäna. U imata, Ekäni Anutunin u kudupitä kudupi-inik itak. ");
INSERT INTO iou_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Ämawebe uken-uken nanik, in kuduptagän oretoret gera terak Anutu iniŋoret täkot! ");
INSERT INTO iou_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Täŋpäŋ Anutu täŋo epän bänep pidäm terak täŋpäŋ kap teŋpäŋ iŋamiken kwawak äbut. ");
INSERT INTO iou_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ekäni uwä Anutu itak u nadäwut! Keri terak ahäŋkumäŋo unita mäheminin ude itak. Täŋpäkaŋ ninä unitäŋo ämawebeniye. Täŋkaŋ ninä yawakiye unita nibäŋ niwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Eruk ämawebe, in kap teŋpäŋ iniŋ oretpäŋ Ekäni täŋo yotpärareken äbut! Täŋpäŋ bänep täga man iwetpäŋ wäpi yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Imata, Ekäni uwä tägagämän. Bänep ironi paot-paori nämo. Watä säkgämän pen api it nimiŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Ekäni, gäkä nadäkta kap yäŋ-tewayäŋ täyat ŋowä siwoŋi kuŋatta ba gäkgänpäŋ gäwaräntäkta tewayäŋ. ");
INSERT INTO iou_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Näk siwoŋigän kuŋatta nadäŋit nadäŋit api kuŋarero unita gäk näkken jidegän api äben? Täŋkaŋ ämawebenaye yabäŋ yäwat täyat uwä bänep kuräki terak täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Täŋkaŋ kudän wakita not nämoinik api täŋpet. Ba äma Anutu mäde ut imik täkaŋ unitäŋo täktäkita taräki nadäŋpäŋ unita ukät itpäŋ-nadäk kubä nämoinik api täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Näk täŋyäkŋarani kudän ba kudän waki ätu täŋo täktäkta bänep nämo api pewet. ");
INSERT INTO iou_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Täŋkaŋ äma yäŋpäŋ-yabäŋ yäwat täŋpani u api yäwat kirewet. Ba äma inita nadäwä ärowani täŋpäpäŋ gup yäpmäŋ ärokärok täŋpani u nämo api yabäŋ korewet. ");
INSERT INTO iou_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Täŋpäkaŋ ämawebe nadäk kubägän peŋpäŋ Anutu unitagän nadäŋ imikinik täŋpäŋ kuŋat täkaŋ u not täŋ yämiŋpäŋ api yämaguret. Ba nadäŋ yämiŋira äma kudän siwoŋigän täŋpanitä watä epän api täŋ namineŋ. ");
INSERT INTO iou_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Upäŋkaŋ jop manman yäwani ba täŋyäkŋarani täŋpanitä dubinaken täga nämo api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Nämo, kepma kepma äma waki täŋpani Ekäni täŋo yotpärareken ba komenin kudupken nanik api däpmäŋ yäwat kirek täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Kap ŋowä äma kubä nadäŋ bäräp terak irirän kehäromini kudup paoräpäŋ itkaŋ nadäŋ bäräpi u Ekäni yäŋahäŋpäŋ iwetkuk. O Ekäni, yäŋapik manna ŋo nadäŋ nami. Gäkä täŋkentäŋ nami yäŋpäŋ gera ŋo yäyat. ");
INSERT INTO iou_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Bäräpi taŋi kaŋ-ahäŋpäŋ nadäŋ bäräp terak irira näka mäde nämo ut namen. Nämo, gera yäŋira nadäŋpäŋ bäräŋeŋ täŋkentäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Näkŋo iritna gupe kadäni keräpitagän äroŋpäŋ abutkuk täkaŋ ude. Täŋpäŋ gupna kädäp ijitak, kädäp gäyek ude. ");
INSERT INTO iou_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Muyeŋ päripmäŋpäŋ pewä kubitak täkaŋ udewani bumik itpäŋ ketem nakta bänep kubä nämo nadätat. ");
INSERT INTO iou_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Yäke! Gupna nämo, kujatna-tägän itkaŋ yäŋkähän-kähän yäŋ itat. ");
INSERT INTO iou_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Näk kwäwukbam kome jopiken inigän it täkaŋ ude itat. ");
INSERT INTO iou_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ba barak kubä inigän-inik päya moräk terak ireko ude. Däpmon bureni nämo pat täyat. ");
INSERT INTO iou_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Butewaki, kepma käroŋ iwantä nebeŋpäŋ yäŋärok bumta näwet täkaŋ. Täŋkaŋ wäpna täktäk waki terak peŋkentäŋpäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","O Ekäni, gäk näka kokwawak nadäŋ namitan unita ketemta waki, kädäkutpäŋ nak täyat. Täŋkaŋ konämna pitopäŋ umeta ude nak täyat. Näk jiraŋ moräk ude ureŋpäŋ maŋpi kukaŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Näk kadäni käroŋi kome terak nämo api iret yäŋ nadätat. Mup däpmäŋ pewanitä bäräŋeŋ kubitak täkaŋ udewani. ");
INSERT INTO iou_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","O Ekäni, gäk intäjukun itkaŋ kaŋiwat epänka tärek-täreki nämo täk täyan. Unita wäpka biŋamtä udegän api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Täŋpäkaŋ Jerusalem ämawebeta oraŋ yämiŋpäŋ täŋkentäŋ yämikta kadäni ahätak ubayäŋ. Unita butewaki nadäŋ nimiŋpäŋ äbä täŋkentäŋ nimisi. ");
INSERT INTO iou_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Butewaki, Jerusalem yotpärare yäpäwawani upäŋkaŋ epän ämakaye nintä unita gäripi pen nadäkamäŋ. U täŋo moräk-moräki yabäŋkaŋ butewaki taŋi nadäk täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","16","Upäŋkaŋ Ekänitä Jerusalem u äneŋi yäpmäŋ akuŋpäŋ uterak kehäromini kwawak pewän ahäŋirän api käneŋ. Kaŋpäŋ ämawebe äbori äboritä Ekänita umuntaŋpäŋ intäjukun ämaniye gämori-kengän itpäŋ api oraŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Täŋpäkaŋ kadäni uken äma jäwäritä Ekäniken yäŋapiŋirä nämo gaŋa taŋpäŋ api nadäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Eruk Ekänitä imaka täŋkuko ŋonitäŋo manbiŋam kaŋ kudän täwut. Ude tänayäŋ tämäŋo uyaku oraniye mäden ahänayäŋ täkaŋ unitä kaŋpäŋ nadäŋpäŋ Ekäni ŋode api yäŋ-iniŋ oretneŋ; ");
INSERT INTO iou_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Ekäni ini iraniken punin unu itkaŋ kome terak ijiŋpewän äpuk. ");
INSERT INTO iou_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Ude täŋpäŋ nadäŋkuk; Äboriye komi eŋiken irani, kumäkta biŋam täŋkuŋo u komi nadäŋkaŋ yäŋkähän-kähän yäŋirä. Ude nadäŋpäŋ äpämaŋ kukta yäniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Unita Ekäni täŋo wäpi u Saion pom terak Jerusalem yotpärareken api iniŋ oretneŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Kadäni ugän äma äbori äbori äbä kubäkengän api itneŋ. Täŋpäŋ intäjukun ämaniye ba äboriye kudup u Ekänitagän watä epän api täŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Täŋpäkaŋ irit kuŋat-kuŋatna bämopiken Ekänitä kehäromina täŋpän wawäpäŋ nepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Unita ŋode iwetkut; Anutuna, gäk itkunotä it yäpmäŋ äbätan. Api it yäpmäŋ ärowen. Näk tägawani nämo täŋira gäk näk bäräŋeŋ nämo nämaguren! ");
INSERT INTO iou_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Anutu, bian-inik kome ŋo gäkä täŋkun. Täŋpäŋ kunum peŋpäŋ imaka imaka kudup peŋ moreŋkun, kome terak ba kunum gänaŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Imaka imaka kehäromi u kudup api paot moreneŋo upäŋkaŋ gäk pen api iren, paot-paotka nämo. Täŋiri imaka kunum ba kome terak peŋkuno uwä ämatä tek täŋ yäpmäŋ kuŋarirä wek täkaŋ udegän api täneŋ. Täŋpäŋ ämatä tek biani maŋpäkuk täkaŋ gäk udegän täŋpewi ämawebe paot täkaŋ. Ude täk täyan unita ämawebe kadäni käroŋi nämo it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","28","Anutu, gäk itan ude pen api ireno unita nanakniyeta watä it yämiŋiri säkgämän api itneŋ. Täŋkaŋ unitäŋo nanakiye udegän, gäkŋata biŋamgän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Näk Ekäni täŋo wäpi biŋam u yäpmäŋ akuk täyiwa! Bureni! Gupna, nadäk-nadäkna u kuduptä Ekäni täŋo wäpi kudupi u iniŋoret täŋpa! ");
INSERT INTO iou_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Ekänitä iron täŋ namik täyak unita guŋ täwetta yäŋpäŋ wäpi biŋam yäpmäŋ akuk täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ekäni unitä momina kudup peŋ namiŋ morek täyak. Täŋpäŋ käyämna imaka, kudup nepmaŋpän tägak täyat. ");
INSERT INTO iou_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ekänitä täŋkentäŋ namiŋirän nämo paot täyat. Bureni! Iron pähap näkä terak buŋät täyak. ");
INSERT INTO iou_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Imaka imaka gakŋi gäripi nikek namik täyak unitä tokŋek itkaŋ yäŋ nadäk täyat. Täŋpäŋ gupna kwitaŋirä kehäromi namiŋirän gubaŋi äneŋi äworeŋpäŋ pidämigän kuŋat täyat, siäŋtä kuŋat täkaŋ ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Ekäni u kudän siwoŋi terak ämawebe yabäŋ yäwat täyak. Äma ätu iwantä kädet waki täŋ yämik täkaŋ, äma udewani täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Täŋpäkaŋ bian, Anututä imaka imaka täŋpayäŋ nadäŋkuko u kudup Moses iwet moreŋkuk. Ba imaka imaka ämatä täga tänaŋi nämo u täŋirän Isrel ämawebetä yabäŋpäŋ-nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Bureni! Ekäni uwä butewaki ba iron pähap täŋ nimik täyak. U komen äma ninta kokwawak bäräŋeŋ nämo täk täyak. Nämo, iniken bänepi dätpäŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","U ninta kokwawak jop nadäŋ nämo täk täyak. Ba kokwawaki kadäni käroŋi nämo yäpmäŋ kuŋat täyak. ");
INSERT INTO iou_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Täŋpäkaŋ momininta ba wakiwakininta kowata taŋi niminaŋipäŋ nämo nimik täyak. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Ekäni uwä äma oraŋ imik täkaŋ udewanita butewaki pähap nadäŋ yämik-inik täk täyak, kunum kenta kome u taŋi pähap ude. ");
INSERT INTO iou_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Täŋpäkaŋ mominin yäpmäŋpäŋ ban-inik maŋpän kuk täkaŋ uwä edap dapuri äbani kädatä äpmok täyak käda u ban-inik itkamän ude. ");
INSERT INTO iou_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Ba naniyetä iroŋiniyeta nadäŋ yämik-inik täk täkaŋ udegän Ekänitä ämawebe oraŋ imik täkamäŋ, ninta nadäŋ nimikinik täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Ekäni u nintäŋo mebärinin nadätak. Ninä kehärominin nikek nämo, ninä komepäŋ gatäwanigän. ");
INSERT INTO iou_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Iritninä mup ba irori udewani. ");
INSERT INTO iou_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Mänittä piäŋirän irori u bäräŋeŋ paotpeŋ kuk täkaŋ. Kokoki kubä nämo irek. ");
INSERT INTO iou_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Upäŋkaŋ äma Anututa nadäŋ imikinik täk täkaŋ unita iron pen api täŋ yämiŋ yäpmäŋ ärowek. Ba nanakiyetä oraniye terak pen api täŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Bureni, Ekäni täŋo man kädet bian yämiŋkuko u iwarani, ba unitäŋo jukuman buramiwani udewanita butewaki pen api nadäŋ yämiŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Ekäni uwä kunum gänaŋ intäjukun-inik itak. Itpäŋ imaka imaka kunum gänaŋ ba kome terak unitäŋo mähemi pähap itak. ");
INSERT INTO iou_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Unita Ekäni täŋo aŋero, in wäpi biŋam yäpmäŋ akuwut! In Ekäni täŋo man buramik äma kehäromi nikek ude itkaŋ unita manita juku pekot! ");
INSERT INTO iou_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Täŋpäkaŋ Ekäni täŋo komi äma kunum gänaŋ itkaŋ, in udegän, wäpi biŋam iniŋ orerut. Inä epän ämaniye unita mani buramiwut! ");
INSERT INTO iou_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Bureni! Imaka imaka komeni komeni Anututä pewän ahäŋkuŋo in kuduptagän Ekäni iniŋ orerut. Ekänitä deken deken tabäŋ täwat täyakken uken iniŋ orerut. Ba näk udegän, gupna, nadäk-nadäkna kuduptä Ekäni täŋo wäpi biŋam yäpmäŋ akuk täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Bänep nadäk-nadäknatä Ekäni iniŋ orera! O Ekäni Anutuna, gäk ärowani pähap. Gäk intäjukun-inik itkaŋ epmäget kudän säkgämän-inikkatä uwäktäŋ gamiŋirän itan. ");
INSERT INTO iou_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Peŋyäŋekka pähappäŋ tek ude yamäk täyan. Täŋpäŋ kunum terak guk kejima ämatä tek iriŋ wädäŋpäŋ pek täkaŋ ude peŋkuno itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Täŋkaŋ irit bägupka ume punin itak u terak täŋkun. Täŋpäkaŋ gubam terak maŋiriri mänittä yäpmäŋ kuŋat täyak. ");
INSERT INTO iou_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Ude täŋkaŋ yäŋiri mänittä gäkŋo meka jinom komeni komeni yäpmäŋ kuŋat täyak, ba yäpätä epän ämakaye ude itak. ");
INSERT INTO iou_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Täŋpäkaŋ kome pähap ŋo täŋ-kehärom taŋpäŋ peŋkuno iniken beki terak wareŋi nämo it täyak. ");
INSERT INTO iou_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Kome täŋ-kehärom taŋpäŋ peŋkaŋ gwägu täŋpäŋ pewi kome pähap ba pom imaka, kudup yejämäŋpäŋ peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Ude täŋkunopäŋ mäden man kehäromi, iromäŋ ude yäŋiri gwägu ämetkuk. ");
INSERT INTO iou_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Gwägu pähap uwä pom kakätäŋpäŋ wädäŋ äpä kubari yäŋ imiŋkunken ugän itkuk. ");
INSERT INTO iou_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Ude täŋkuno unita baga peŋ imiŋkuno u täga nämo wärämut täyak. Ude täŋkuno unita gwägutä kome äneŋi kudup nämo api yejämbek. ");
INSERT INTO iou_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Täŋpäkaŋ gäkŋa-tägän täŋpewi ume ini kubat-kubatken äpämaŋ päŋku pom mebäriken ämiŋkaŋ kubägän kukaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Täŋirä tom ägwäri mebäri mebäri u naŋpäŋ kotäki irok tawäpäŋ it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Ba baraktä ume pomi terak nanik päya uniterak eŋini täŋpäŋ itkaŋ iniken manman yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Täŋpäkaŋ kunum gänaŋ nanik iwän yäŋiri tak täyak. Iwän taŋpäŋ kometa gakŋi tokŋek-inik imik täyak. ");
INSERT INTO iou_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ude täŋiri ketem tomtä nakta ba ämatä piŋpäŋ nakta ahäŋ-bumbum täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Bureni Ekäni, gäk wain ume nimiŋiri naŋpäŋ oretoret täk täkamäŋ. Ba orip gakŋi iŋamninken äruritna ägo weŋirä kuŋatta nimik täyan. Täŋpäŋ gupnin täŋ-kehärom takta ketem nimik täyan. ");
INSERT INTO iou_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Täŋpäkaŋ Ekäni, nadäŋiri gäkŋaken päya taŋi taŋi Lebanon komeken itkaŋ u iwäntä gakŋi säkgämän yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Ude täŋirä barak mebäri mebäritä päya uterak eŋini täŋpäŋ it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Täŋpäkaŋ tom taŋi taŋi pom käroŋi terak kuŋarirä täpuri täpuri ätutäwä mobä gänaŋ pat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Täŋpäŋ komepak täŋpäŋ peŋkuno unitä imaka imaka täŋo ahäk-ahäk unitäŋo kadäni wädäŋ yäpmäŋ äbäk täyak. Täŋpäkaŋ edap uwä käderi iwatpäŋ kadäni udeken äpmok täyat yäŋ nadätak. ");
INSERT INTO iou_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Yäŋpewi edap äpmoŋirän bipmäŋurani äbäk täyak. Ude täŋirän tom bipani kuŋarani u kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Aŋ ägwäri tomta wäyäkŋeŋkaŋ gera yäŋtäŋ kuŋat täkaŋ. U, Anutu gäkä nimi yäŋkaŋ gabäŋ tarek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Eruk edap abäŋirän patpat bägupi, gänaŋken äneŋi äpmok täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Ude täŋirä ämawä akumaŋ epäniken päŋku epän täŋ yäpmäŋ kuŋirä edap äpmok täyak. ");
INSERT INTO iou_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Ekäni, gäk imaka mebäri mebäri pewi ahäŋkuŋo u daninaŋi nämo. Nadäwi tärewäpäŋ täŋ moreŋkun. Kome ŋo terak ketka kudäntä tokŋeŋ moreŋkuko pätak. ");
INSERT INTO iou_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Täŋpäkaŋ gwägu pähap ŋode yäwa; U pipiyäwani pähap. U gänaŋ tom ba imaka imaka täga daninaŋi nämotä pätkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","U terak ämatä gäpe yäpmäŋ kuŋat täkaŋ. Ba tom pähap kubä wäpi Levitan täŋpäŋ yepmaŋkuno u gänaŋ täŋoret täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Imaka imaka irit ikek kuduptä gäkä ketem nimi yäŋkaŋ gabäŋ tarek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Täŋpäkaŋ gäkŋa-tägän ketem yämi naŋpä koki täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Upäŋkaŋ gäkä mäde ut yämiŋiri umuntak täkaŋ. Gäk irit kuŋat-kuŋari yäyomägariri kumäŋpäŋ kome äworek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Täŋpäkaŋ gäk meka woŋ piäŋ yäwariri komenita ätu kodaki ahäk täkaŋ. Täŋiri imaka imaka kome terak kodaki ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Unita ŋode yäwa; Ekäni täŋo wäpi biŋam ba peŋyäŋeki u paot-paori nämo it täyon! Täŋpäkaŋ Ekäni iniken ket kudän unita kaŋpäŋ kaŋgärip täk täyon. ");
INSERT INTO iou_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Ekäni uwä kehäromi pähap ikek. Kome jop kaŋirän kwaik täyak. Ba keritä pom jop tensumurirän gupe ärok täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Unita irayäŋ täyat udegän Ekäni täŋo täktäki tägata yäŋpäŋ kap api teŋ imik täŋpet. Bureni, it yäpmäŋ kwayäŋ täyat udegän kap teŋpäŋ Anutu api iniŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Täŋpäŋ imaka täga-tägatagän yäŋpäŋ-nadäk täŋira Anututä kawän tägawut yäŋ nadäk täyat. U imata, näk Ekäninata yäŋpäŋ oretoret pähap nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Upäŋkaŋ Ekäni, gäk äma momi täŋpani kudup kaŋ däpmäŋ! Äma waki täŋpani kudup paorut yäŋ nadätat! Eruk, Bänep nadäk-nadäknatä Anutu iniŋ orera! Täŋira, ämawebe in kuduptagän Ekäni udegän iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","2","Eruk, Ekäni täŋo ämawebe, Anutu-kengän bänep täga man iwerit täŋkentäŋ nimikta yäŋapik täk täkäna! Uwä wäpi biŋam ikek unita epän pähap täŋkuko unitäŋo manbiŋam ämawebe komeni komeni kaŋ yäŋahäŋpäŋ yäwetna. Täŋpäŋ kap teŋpäŋ wäpi kaŋ yäpmäŋ akuna. ");
INSERT INTO iou_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Nin unitäŋo ämawebe itkamäŋ unita oretoret terak kuŋat täkäna. Bureni! Ämawebe Anutuken yäŋapik täkamäŋ nin, oretoret täk täkäna! ");
INSERT INTO iou_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Täŋpäŋ Anutu dubini-kengän kuŋitna täŋkentäŋ nimik täyon. Ba kehäromi yäpna yäŋpäŋä ukengän yäŋapik täkäna. ");
INSERT INTO iou_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Isrel ämawebe, in nadäkaŋ? Inä Anutu täŋo epän ämaniyat wäpi Abraham kenta Jekop unitäŋo oraniye. Inä Anututä inita biŋam iwoyäwani. Unita kudän kudupi Anututä bian täŋkuko unita nadäneŋ. Ba äma wakita komi yämik täŋkuko unita juku pineŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Ekäni uwä Anutunin. Unitäŋo baga man uwä komen äma uken-uken naniktä buramikta yäwani. ");
INSERT INTO iou_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ninkät topmäk-topmäk kubägän peŋkuko u paot-paori nämo. Ba imaka imaka api täŋ tamet yäŋ yäŋkuko u kadäni kadäni yeritä yeri ahänayäŋ täkaŋ udegän iwatpäŋ api täŋ nimek. ");
INSERT INTO iou_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Topmäk-topmäk kubägän uwä bian oranin Abraham kenta Aisakkät täŋkuŋ. Yäŋ-kehäromtak man yäŋkuko u nämoinik api irepmirek. ");
INSERT INTO iou_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Täŋpäŋ man ugänpäŋ Jekop iwetgän täŋkuk. Bureni, topmäk-topmäk Isrel äbotkät täŋkuko uwä itkukonitä itak. ");
INSERT INTO iou_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Täŋpäŋ man kehäromi yäwetkuko uwä ŋode; Kenan kome taniŋ kirewayäŋ täyat u gäk ba oraŋkaye mäden ahänayäŋ täkaŋ inta biŋam api täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Täŋpäkaŋ äbekniye oraniye bian äbot taŋi nämo, täpuri. Uwä komeni nämo ude kome ŋoken itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Kome kubäkengän iräpmok-inik nämo täŋkuŋ. Nämo, ämatä komeken itpäŋ wärämut täŋtäŋ kuŋatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Ude täŋkuŋo upäŋkaŋ Ekänitä yabäŋ äwaräkuk täŋirän ämatä nämo täŋpä waŋkuŋ. Nämo, ämawebeniyeta yäŋpäŋ intäjukun äma ittäŋ kuŋkuŋo u jukuman kehäromi ŋode yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Ämawebe näkŋata biŋam iwoyäwani unita waki kubä täŋ yämikta nämoinik nadäneŋ yäk. Ba näkŋo man yäŋahäwani ämanayeta udegän nämo täŋ yämineŋ yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Eruk, it yäpmäŋ kuŋtäko Ekänitä nadäŋirän kome uken nakta jop irit kadäni ahäŋkuk. Ketem päke u kudup pewän paotkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Ude täŋkaŋ Josep iniŋ kireŋpewän intäjukun Isip komeken päŋku itkireŋkuk. U noriyetä gwäki yäpmäkta nadäŋpäŋ epän watä äma jopi ude itta ämata yäniŋ kireŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Eruk, imagut yäpmäŋ kuŋpäŋä komi eŋiken teŋpäŋ yen kehäromitä kuroŋiken topmäŋkaŋ kotäkikenä udegän imaka bäräpi kubäpäŋ topmäŋpäŋ tewä wädäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Komi eŋiken ugän it yäpmäŋ kuŋtäyon imaka ahäkta Ekänitä iwerirän yäŋahäŋkuko u ahäŋirän kaŋpäŋ nadäŋkuŋ. Kaŋpäŋ nadäŋpäŋ Josep täŋo man u bureni yäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Eruk, Isip täŋo intäjukun ämatä ude nadäŋpäŋä äma kubä iwerän päŋku Josep komi eŋiken nanik iniŋ kireŋpewän äpämaŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Ude täŋpäŋä intäjukun äma u Josep tuŋum ba imaka imakani kudup unita watä it yämikta wäp imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Ba ugän nämo. Iniken noriye Joseptä iniken gärip terak yabäŋ yäwatta kehäromi imaka imiŋkuk. Ba unitäŋo nadäk-nadäk ämaniye yäwetpäŋ yäwoŋärekta wäp imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Eruk, u punin terak, Jekoptä Isip komeken päŋku itkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","U irirän Ekänitä nadäŋ imiŋirän äboriyeken yeriniye ahäŋ-bumbum täŋkuŋ. Ahäŋ bumbum täŋpäŋ unitäŋo kehäromitä iwaniye täŋo kehäromi yärepmitkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Täŋpäkaŋ Ekänitä Isip nanik täŋpewän epän watä ämawebeniye unita kokwawak täŋ yämiŋpäŋ komi yämikta kädetta yäŋpäŋ-nadäk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Eruk ude täŋkaŋ mäden Ekänitä epän watä ämani yarä iwoyäŋpäŋ yepmaŋkuko Moses kenta Aron yäniŋ kireŋpewän Isip äbumän. ");
INSERT INTO iou_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Äbäŋpäŋ Isip ämawebe bämopiken Anutu täŋo kudän kudupi ŋode pewän ahäŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Anututä yäŋirän bipmäŋ uranitä kome pähap u kudup uwäk täŋpäŋ peŋkuk. Upäŋkaŋ Isip nanik u Anututä Moses meniken man yäŋahäŋkuko u kudup bitnäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ude täŋkuŋo unita äneŋi ume täŋpewän nägät äworeŋirän ume gänaŋ nanik tom kudup kumäŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Ude täŋkaŋ äneŋi kubä ŋode täŋkuk; Yäŋirän wirit ahäŋ-bumbum täŋpäŋ kome päke u kudup tokŋeŋpäŋ patkaŋ, intäjukun äma täŋo patpat bägupken udegän tokŋeŋpäŋ patkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Eruk Ekänitä äneŋi yäŋirän gäbäräm kenta nämäk-nämäk pädä nikek ahäŋ patpäŋ komeni komeni kudup tokŋeŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ude täŋkaŋ Ekänitä nadäŋirän iwän bureni nämo taŋkaŋ yäpä kwinirirän mim-tägän maŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Mimtä maŋpäŋ wain päya ba ketemi epän kudup täŋpän wawäpäŋ yäpätä päya ijiŋ-gariŋpäŋ peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Äneŋi yäkgän täŋirän käpukbam daninaŋi nämo, bumta ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Ahäŋ patpäŋ gwaktä imaka pähämi nikek kudup naŋ moreŋkuŋ. Ba Isip naniktä ketem piwani imaka, pähämi kudup naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ude täŋtäŋ kuŋtäŋgän Ekänitä Isip nanik täŋo nanak ämani intäjukun nanik u kudup däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Eruk, ude täŋkaŋ Isrel ämawebe Isip nanik täŋo siliwa gol moneŋ bumta yäpäkaŋ Ekänitä watäni itpäŋ Isip komeken nanik yämagut yäpmäŋ äpämaŋ kuŋkuk. Täŋirän kubätä bäräpi kubä nämo kaŋ-ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Täŋpäkaŋ Isip nanik Isrel nanikta umuntaŋkuŋo unita yepmaŋpeŋ kuŋirä oretoret täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Täŋpäkaŋ ämawebeniye kuŋirä Ekänitä nadäŋirän gubamtä äyuŋ täŋ yämikta gwäki terak itkuk. Täŋpäkaŋ bipani peŋyäŋek yämikta kädäp mebet peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Ude täŋkaŋ ketemta yäŋapiŋirä barak ätu yämiŋirän nak täŋkuŋ. Ba käräga kunum gänaŋ nanik yämiŋirän naŋ tokŋek täk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Täŋpäkaŋ mobä kubä yäŋirän imäränkaŋ ume u gänaŋ naniktä äpäŋirän naŋkuŋ. Kome kawuki umeni nämo upäŋkaŋ mobä gänaŋ nanik yäŋirän äpuko unitä täŋkentäŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Imaka päke ude täŋ yämiŋkuko uwä bian epän watä ämani Abraham ukät yäŋkehäromtak man yäŋkuko u iwatkaŋ täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Bureni, ämawebeniye inita biŋam iwoyäwani u yäŋ-yäkŋat yäpmäŋ kuŋirän teŋ oretoret terak kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Yäŋ-yäkŋat yäpmäŋ kuŋpäŋ äbot ätu täŋo kome yäniŋ kirewän koreŋkuŋ. Kome äma ätutä ket urani koreŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Täŋpäkaŋ täŋkentäk taŋi täŋ yämiŋ yäpmäŋ äbuko u jop nämo täŋ yämiŋkuk. Nämo, u jukumani ba baga mani u kudup buramiŋpäŋ kuŋatneŋta täŋ yämiŋkuk. Unita Ekäni wäpi iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Ekäni wäpi iniŋ oretna! U säkgämän täŋ nimik täyak unita bänep täga nadäŋ imik täkäna! Nadäŋ nimikinik täk täyak uwä tärek-täreki nämo. ");
INSERT INTO iou_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Imaka imaka taŋi taŋi täk täyak unitäŋo mebäri netätä kudup täga yäŋahäwek? Ba netätä iniŋ orerän tärewek? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Ämawebe mani buramiŋpäŋ kädet siwoŋigän kuŋat täkaŋ uwä Ekäni täŋo oretoret terak kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Unita Ekäni, ämawebekaye täŋkentäŋ yämiŋpäŋ iwan keriken nanik yämagurayäŋ täyanken uken näk imaka, bok kaŋ nimagut! ");
INSERT INTO iou_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Ude täŋiri ämawebekayetä äneŋi täŋ-bumbum terak irirä yabäŋpäŋ oretoret bok kaŋ täna. Ude täŋiri ketka kudänkaye nintä gäka gäripi inide kubä nadäk täkäna! ");
INSERT INTO iou_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Butewaki, äbekniye oraniyetä momi täŋkuŋo nin udegän täŋkumäŋ. Täŋpäwak mebäri mebäri täŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Äbekniye oraniye Isip komeken itkuŋo u Anutu täŋo kudän tägatäga kaŋpäŋ nadäŋkaŋ upäŋkaŋ unita nadäwä äpani täŋkuk. Nadäŋ yämik-inik täŋpäŋ täŋkentäk mebäri mebäri täŋ yämiŋkuko upäŋkaŋ guŋ taŋpäŋ Gwägu Gämäniken peŋawäk täŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Ude täŋkuŋo upäŋkaŋ yäŋkehäromtak mani iwatpäŋ kehäromini ärowani u kwawak yäwoŋärekta ŋode täŋkentäŋ yämiŋkuk; ");
INSERT INTO iou_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","U Gwägu Gämäni peŋ iwerirän däkŋeŋpäŋ kukŋi kukŋi kuŋirän kädet parirän ämawebeniye kome terak yeŋtäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Ude täŋkaŋ äma komi yämani, iwaniye u keriken nanik yämagut yäpmäŋ äpämaŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Ude täŋpäŋ iwaniye uwä täŋpewän umetä kudup däpmäŋ moreŋkuk, kubätä nämo itkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Ude täŋirän ämawebeniyetä kaŋpäŋ yäŋkehäromtak mani unita nadäwä bureni täŋpäpäŋ kap terak iniŋ oretkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Upäŋkaŋ täŋ yämiŋkuko unita bäräŋeŋ guŋ taŋpäŋ jukumani nadäkta juku kubä nämo peŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Nämo, kome jopiken kuŋatkä ketem mebäri kubä nakta wakiinik kubä nadäŋpäŋ Anutu jop nadäŋ peŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Täŋirä imatäkenta nadäŋpäŋ yäŋapiŋkuŋo u bureni yämiŋkuko upäŋkaŋ käyäm waki kubä bok bämopiken pewän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Kome jopiken u ittäŋ kuŋattäŋgän Isrel äbotken nanik ätutä Moses ba Ekäni täŋo epän watä äma kudupi wäpi Aron, yarä unita kokwawak nadäŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Täŋirä kome aŋeŋirän Datankät Abiram ini ba äboriye kudup kome gänaŋ äpmoŋirä kome äneŋi ämiŋ pipiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Ude täŋirä kädäp mebettä päpä äma yarä unitäŋo iwaräntäkiye wakiwaki täŋpani u kudup ijiŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Eruk, ittäŋ kuŋtäŋgän Sainai pom mebäriken bulimakau wärani kubä golpäŋ täŋpani täŋkuŋ. Täŋpäŋ peŋkaŋ unita gwäjiŋ äpmoŋ imik täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","U Anutu wäpi biŋam ärowani nikek mäde ut imiŋpäŋ u komenita tom muyeŋ näŋpani u peŋpäŋ wäpi iniŋoret täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Ude täŋkuŋo uwä Anutu Isip komeken iwaniye keriken nanik yämagutta kudän kehäromi mebäri mebäri täŋkuko unita guŋ taŋpäŋ ude täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","U kawut! Imaka kudupi kudupi Isip kome täŋkuko ba imaka ämatä nämo tänaŋi Gwägu Gämäniken täŋkuko unita nadäna inide kubä täŋpän! ");
INSERT INTO iou_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Täŋpäkaŋ Anutu ämawebeniye kudup täŋpän wanayäŋ yäŋirän epän watä ämani Moses unitä ämawebeniye gärak itpäŋ Anutu täŋo kokwawaki ukät-pipiŋirän nämo däpuk. ");
INSERT INTO iou_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","It yäpmäŋ kuŋtäŋgän Anutu täŋo yäŋkehäromtak man yäŋkuko unita nadäwä bureni nämo täŋpäpäŋ kome säkgämän Anututä yäniŋ kirekta yäŋkuko u korekta bitnäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Bitnäŋpäŋ eŋi jopikengän itkaŋ Ekäni täŋo manta juku kubä nämo peŋkaŋ iniken gärip iwatpäŋ yäŋuruk-uruk man bumta yäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Ude täŋirä Ekänitä jukuman kehäromi ŋode yäwetkuk; Kome jopiken täŋpewa in api paotneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Yerijiye yäpmäŋ daniŋpäŋ yepmaŋpa guŋ äbotken kukŋi käda päŋku api kumäŋ täŋpä kuneŋ yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Eruk ittäŋ kuŋtäŋgän Peo komeken Anutu täŋo äbottä guŋ äbot täŋo anutu jopi kubä wäpi Bal u iniŋ oretta biŋam täŋkuŋ. Täŋpäŋ anutu jopi, iriri nämo, u iniŋ oretta tom ijiwani u nak täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Ude täŋpewä Ekäni täŋo kokwawaki bumta ahäwänpäŋ nadäŋirän ämawebe bämopiken käyäm wakiinik kubä weŋ patkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Ude ahäŋirän Finiastä kaŋpäŋ nadäŋpäŋ ämawebe momi täŋkuŋo u komi yämiŋirän eruk Anututä käyäm waki u täŋpewän paotkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Finiastä ude täŋkuko uwä Anututä kawän tägawäpäŋ äma siwoŋi yäŋ pen, paot-paori nämo api nadäŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Täŋpäkaŋ Meriba ume dapuriken ämawebe äneŋi waki täŋirä Anututä kokwawak äneŋi nadäŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Täŋirän Moses nadäŋ bäräp terak itpäŋ bänepi jägäm tawäpäŋ man jopjop mäyap yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Eruk kome Anututä iwoyäŋ yämani uken ahäŋkuŋo upäŋkaŋ Anututä kome u nanik guŋ ämawebe päke u däpmäkta yäwetkuko udegän nämo täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Nämo, yabäŋ koreŋpäŋ ämawebe u nanikkät kowat-yäpän täŋpäŋ guŋ äbot täŋo kädet wakiwaki u iwarän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Anutu täŋo ämawebeniye unitägän kome unitäŋo mäjo wära nadäŋ yämiŋpäŋ gwäjiŋ äpmoŋ yämiŋkuŋ. Nadäŋ yämiŋkuŋo unita waŋ moreŋpäŋ ŋode täk täŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Iniken äperiye nanak ätu däpmäŋpäŋ Kenan nanik täŋo anutu jopi unita ärawa ude täŋ yämik täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","U äperiye nanak waki kubä nämo täŋirä jop nadäŋ däpmäŋirä nägäritä kome u Anutu iŋamiken täŋpän waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Täŋpäkaŋ iniken täktäki unitä ini imaka, Anutu iŋamiken taräki-inik ude itkuŋ. Ude täŋkuŋo unitäwä Anutukät bänep kubägän nämo täŋkuŋ. Nämo, iniken gärip iwarän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Ude täŋirä Ekänitä iniken ämawebeniye unita gaŋani pähap nadäŋpäŋ kokwawak täŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Ude täŋpäŋ Anututä ini nadäŋpäŋ ämawebeniye yabä-kätäŋirän guŋ ämawebetä äbä intäjukun täŋ yämiŋirä gämoriken kuŋatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Täŋirä iwaniyetä komi epän mebäri kubä täŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Täŋpäkaŋ kadäni kadäni Ekänitä ämawebeniye wakiken nanik yämagut täŋirän upäŋkaŋ waki täkta gwäk pimiŋpäŋ äpmok-inik täk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Ude täk täŋkuŋo upäŋkaŋ Ekänitä konäm butewakini nadäŋ yämik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Butewaki nadäŋ yämiŋpäŋ topmäk-topmäk kubägän ämawebeniyekät bian täŋkuko u juku piŋpäŋ nadäŋ yämik-inik täŋpäŋ jop yabäŋ oretkuk. ");
INSERT INTO iou_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Yabäŋ oretkaŋ äma komi epän yämani u täŋpewän ämawebeniye gämoriken itkuŋo unita butewaki nadäŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Eruk Ekäni Anutunin, ude täŋkuno unita nin udegän täŋkentäŋ nimiŋpäŋ guŋ äbot täŋo komi epänken itkamäŋken ŋo nanik äneŋi nimagut yäpmäŋ äpämaŋ kuyi! Ude täŋiri bänep täga nadäŋ gamiŋpäŋ wäpka kudupi u täga api ganiŋoret täne. ");
INSERT INTO iou_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Eruk ämawebe, Ekäni, Isrel täŋo Anutu u iniŋ oretna! Apiŋotä tärek-täreki nämo pen inide iniŋoret täkäna! Unita kudup ŋode yäna; U Bureni. Ekäni wäpi iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Ekäni iniŋ orerut! Uwä täŋ-bumbum mähemi-inik. Unitä iron täŋ nimik täyak uwä paot-paori nämo patkukotä pätak. ");
INSERT INTO iou_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Ekänitä komi epänken nanik tämagurani in kudup Ekäni iniŋoret man ude kaŋ yäwut. ");
INSERT INTO iou_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Ekäni uwä ämawebe komeni komeni kuŋtäŋpä kuŋkuŋo u äneŋi yämagutpäŋ kubäkengän yepmaŋkuko unita yäŋpäŋ ude kaŋ yäwut! ");
INSERT INTO iou_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Komeni komeni kuŋtäŋpä kuŋkuŋo uken nanik ätutä kome kawuki bämopiken kuŋatkaŋ yotpärare kubäken päŋku itta kädetta ŋoba kuna-kuna täŋtäŋ kuŋatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","U ketem ba umeta bumta yewäkaŋ ŋoken kumne yäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Komi bäräpi u gänaŋ itkaŋ Ekäniken gera yäŋirä ketäreŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ketäreŋ yämiŋpäŋ yämagut yäpmäŋ yotpärare eŋi täga täŋpäŋ itnaŋiken u ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Unita ämawebe u Ekäni täŋo iron tärek-täreki nämo unita yäŋpäŋ bänep täga pähap nadäŋ imik täkot. Ekäni uwä komen äma täŋkentäk säkgämän täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","U äma umeta yeŋirä ume yepmäŋ towiwän naŋpäŋ täga it täkaŋ. Ba äma nakta yek täkaŋ u ketem tägatäga yepmäŋ towiwän naŋ tokŋeŋpäŋ it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Eruk, ämawebe kuŋtäŋpä kuŋkuŋo u ätutäwä yen terak komi eŋiken bipmäŋ urani gänaŋ itkaŋ komi bumta nadäk täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","U imata, Anutu ärowani unitäŋo manta mäde ut imiŋpäŋ iniken gärip iwarani unita. ");
INSERT INTO iou_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Ude täŋkuŋo unita Ekänitä komi epän pähapken yepmaŋkuk. Ude yepmaŋirän kehäromini paoräkaŋ kwaiŋ äroŋtäŋ kuŋatkuŋ. Täŋkentäŋ yämikta äma kubä nämo itkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Komi epänken ude itkaŋ Ekäniken konäm butewaki gera yäŋkuŋ. Yäŋirä nadäŋ yämiŋpäŋ komi butewaki nadäŋkuŋo u ketäreŋ yämiŋpäŋ yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Bureni, u bipmäŋ urani pähap gänaŋ nanikpäŋ yen yäpmäŋ däkŋeŋpäŋ yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Unita ämawebe u Ekäni täŋo iron tärek-täreki nämo unita yäŋpäŋ bänep täga pähap nadäŋ imik täkot. Ekäni uwä komen äma täŋkentäk säkgämän täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","U komi epän täŋo yewa kehäromi yeŋ wek täyak. Ba komi eŋi täŋo eŋi kujari däpmäŋ jukut täyak. ");
INSERT INTO iou_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Eruk, ämawebe kuŋtäŋpä kuŋkuŋo u ätutäwä guŋ ude äworeŋpäŋ Anututa mäde ut imiŋkuŋ. Ude täŋpäŋ momi kädet mebäri mebäri täŋkuŋo unita käyäm waki kubäken yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Täŋpäŋ käyämtä täŋpewän ketem nakta kudup bitnäŋpäŋ pära kumäk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Wakiinik ude itkaŋ Ekäniken gera yäŋirä ŋode täŋkentäŋ yämiŋkuk; ");
INSERT INTO iou_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","U meni jinomtä yäpän tägawäpäŋ yepmaŋkuk. Awaŋ pomi terak nanikpäŋ yämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Unita ämawebe u Ekäni täŋo iron tärek-täreki nämo unita yäŋpäŋ bänep täga pähap nadäŋ imik täkot. Ekäni uwä komen äma täŋkentäk säkgämän täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Bänep täga nadäŋ imiŋpäŋ ärawa täŋ imiŋpäŋ bänep oretoret kap terak kudän täga täŋ yämiŋkuko unita yäŋpäŋ teŋ imik täkot. ");
INSERT INTO iou_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Eruk, ämawebe kuŋtäŋpä kuŋkuŋo u ätutäwä moneŋ epän täkta gäpe terak gwägu pähap terak kuŋatkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Gwägu terak kuŋarirä Ekänitä kudän kudupi ätu pewän ahäŋirä ŋode kaŋpäŋ nadäk täŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Ekänitä yäŋirän mänit pähap kubä piäŋpäŋ gwägu täŋpewän tokätkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Gwägutä tokätpäŋ gäpe pudät maŋpän äroŋkaŋ mak täŋkuk. Ude täŋirän äma gäpe terak kuŋatkuŋo unitä kumne yäŋ nadäŋpäŋ bumta umuntaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Umuntaŋpäŋ täŋguŋguŋ täŋkaŋ gäpetä säkgämän kukta nadäk täga kubä nämo yäpuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Ude täŋpäŋ imaka umuri pähap u gänaŋ itpäŋ Ekäniken gera yäŋirä täŋkentäŋ yämiŋpäŋ bäräpi u ketäreŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Täŋpäŋ Ekänitä äneŋi yäŋirän mänit pähap u paorirän gwägu wareŋi nämo patkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Eruk gwägu wareŋi nämo parirän kaŋpäŋ bänep oretoret pähap täŋkuŋ. Ude täŋirä Ekänitä yäŋ-yäkŋat yäpmäŋ päŋku kome kunayäŋ nadäŋkuŋken u yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Unita ämawebe u Ekäni täŋo iron tärek-täreki nämo unita yäŋpäŋ bänep täga pähap nadäŋ imik täkot. Ekäni uwä komen äma täŋkentäk säkgämän täŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Unita Anutu täŋo ämawebekät käbeyä täŋpäŋ Ekäni wäpi pähap yäŋpäŋ punin unuken kaŋ yäpmäŋ akuwut! Ba äma ekäni ekäni täŋo käbeyäken udegän Ekäni wäpi biŋam yäŋpäŋ kaŋ oraŋ imik täŋput. ");
INSERT INTO iou_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Täŋpäkaŋ Ekänitä kome täga täŋpewän ume täpuri ba taŋi kawuk taŋirä kome kekeki patkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Täŋpäŋ ketem pikpik komeken täŋpewän mobä gäjäräk ikek patkuk. Imata, ämawebe kome uken iranitä kudän waki mebäri mebäri täŋkuŋo unita ude täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Ekänitä ude täŋkuko upäŋkaŋ kome kawukiken yäŋpewän ume äpäŋit, gwägu parit täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Ude täŋkaŋ ämawebe nakta jop irani u yepmaŋpänkaŋ kome uken yotpärare täŋpäŋ itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Eruk yotpärare täŋpäŋ itpäŋä ketem piŋit wain päya piŋit täŋpäŋ pewä bureni bumta ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Ekänitä iron täŋ yämiŋirän nanak weŋbäyak täŋkuŋ. Ba yawakiye imaka, bumta weŋbäyaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Täŋpäkaŋ kehäromi nikek ude kadäni käroŋita nämo itkuŋ. Nämo, iwantä abäŋpäŋä komi epän ba butewaki terak yepmaŋirä ämawebe jopi ude itkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Bureni, Ekäni uwä äma wäp biŋam ärowani nikek täŋo wäpi biŋam yäpmäŋ äpani. Äma udewani yäwat kireŋirän kome jopiken kuŋtäŋpä kuk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Upäŋkaŋ äma jäwäri komi butewaki gänaŋ nanik täŋken täŋpäŋ yepmaŋkaŋ iron täŋ yämiŋirän nanakiye sipsiptä nanak weŋbäyak täk täkaŋ ude bumta ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Anututä ude täŋirän ämawebe siwoŋitä kaŋpäŋ bänep täga nadäk täkaŋ. Täŋ äma wakitä kaŋpäŋ jop, man kum it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Unita äma nadäk-nadäk ikek in Ekäni täŋo kudän päke u kaŋpäŋ nadäwä tärewut. Kaŋpäŋ nadäwä tärewäpäŋ Ekäni täŋo iron pähap unita yäŋpäŋ-nadäk kaŋ täŋpeŋ kuŋarut. ");
INSERT INTO iou_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","O Anutu, bänepnatä gäka nadäkinik kehäromi täŋ gamitat unita kap terak ganiŋoret täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Eruk, bänepna pidäm täyi! Udegän, wagäm gita in kap tekta pidäm täkot! Pidäm taŋpäŋ kap teŋitna kome yäŋewän! ");
INSERT INTO iou_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Ekäni, wäpka käbop nämo api pewet! Nämo, ämawebe gäka nämo nadäk täkaŋ u bämopiken bänep täga terak wäpka biŋam api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Täŋpäkaŋ Anutu, gäkä ninta butewaki nadäŋ nimik täyan u käroŋi boham, kunum irepmireko ude bumik. Täŋkaŋ ninta nadäŋ nimikinik täk täyan u ärowani. ");
INSERT INTO iou_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Unita Anutu, wäpka biŋam ärowani kwawak pewi kunum gänaŋ ba komeni komeni ahäŋirän ämawebe kuduptagäntä kaŋ kaŋpäŋ nadäwut! ");
INSERT INTO iou_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Täŋpäŋ ninta nadäŋ nimikinik täk täyan unita yäŋapik manna nadäŋ namiŋpäŋ ketka kehäromitä täŋkentäŋ nimi. Ude täŋiri säkgämän kaŋ itna. ");
INSERT INTO iou_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Anutu ini eŋiken itkaŋ ŋode yäŋkuk; Iwan täŋo kehäromi kudup yäpmäŋ äpäŋ moreŋpäŋ oretoret terak ŋode api täŋpet; Sekem kenta Sukot kome yäpmäŋ daniŋpäŋ ämawebenayeta api yämet yäk. ");
INSERT INTO iou_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Täŋpäŋ ugän nämo. Gileat Manase kome u imaka, näkŋo. Täŋkaŋ Efraim kome u näkŋo kurepä ude, ba Juda kome u kehäromina kwawak pewä ahäwani yäk. ");
INSERT INTO iou_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Täŋpäkaŋ Moap kenta Idom kometä watä epän täŋ namik täkaŋ. Täŋkaŋ Filistia nanik täŋo kehäromini yäpmäŋ äpäŋpäŋ oretoret täyat yäk. ");
INSERT INTO iou_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Eruk Anutu, netätä yotpärare yewa kehäromi nikek, Idom komeken itak uken ämik täkta nämagut yäpmäŋ kwek? ");
INSERT INTO iou_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Nämo! Gäk mäde ut nimiŋkuno unita jop itkamäŋ. Gäk nintäŋo komi ämakät ämikken bok täga nämo api kuneŋ ba? ");
INSERT INTO iou_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Eruk Anutu, gäk täŋkentäŋ nimiŋiri uyaku iwan täga däpmäŋpäŋ yäwat kirene. Ämatä täŋkentäk täk täkaŋ u jopi, kehäromini nämo. ");
INSERT INTO iou_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Unita nadäkamäŋ! Anutu, gäkkät bok uyaku iwan täŋo kehäromini täga api yäpmäŋ äpne! ");
INSERT INTO iou_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Anutu, näk ganiŋoret täyat unita nadäŋ äwaräkuk nämo täŋpen. ");
INSERT INTO iou_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Nämo, äma wakiwaki täŋpani ba jop manman yäwanitä näk jop man näkŋatpäŋ nut täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Mebärini nämo, man waki näwetpäŋ jop nepmäŋit täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Not täŋ yämiŋpäŋ täŋkentäŋ yämikta yäŋapik man yäk täyat upäŋkaŋ naniŋ wärät täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Täŋkaŋ not täŋ yämiŋpäŋ täŋkentäŋ yämiŋira unitä kowata kokwawak nadäŋ namiŋpäŋ waki täŋ namik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Unita Anutu, iwannaye u man käbeyäken yepmaŋpäŋ mani nadäkta äma waki kubä iwoyäŋpäŋ kaŋ te! Bureni, inikät nanik kubätä mani kotäk yäpmäŋ daniŋpäŋ kaŋ iniŋ wärärän. ");
INSERT INTO iou_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Täŋpäŋ mani yäpmäŋ daniŋpäŋ äma ŋo waki täŋpani yäŋ kaŋ yabäŋ-ahäwän. Täŋkaŋ yäŋapik man terak yäŋikŋarani yäk täkaŋ unita imaka, wakigän yäŋ kaŋ yäwän. ");
INSERT INTO iou_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Ude täŋirän irit kuŋat-kuŋari udegän bäräŋeŋ kaŋ paorän! Paorirän moneŋ tuŋumi äma kubätä ahäŋpäŋ kaŋ korewän yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Paorirän äperiye nanak kodäŋani kaŋ irut. Ba webeni imaka udegän, webe kajat, täkentäki nämo kaŋ irän. ");
INSERT INTO iou_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Nanakiye kome kujari nämo ude itkaŋ äriŋ täpätek täŋtäŋ kaŋ kuŋarut! Ude täŋtäŋ kuŋarirä tähani wärämutpäŋ kaŋ yäwat kireŋ pewäkut! ");
INSERT INTO iou_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Täŋpäŋ äma kubäken naniktä äma unitäŋo komeni ba moneŋ tuŋumi komi epän täŋpäŋ yäpani u kudup kaŋ yomägarut yäŋ nadätat! ");
INSERT INTO iou_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Täŋpäkaŋ kubätä not täŋ imiŋpäŋ äperiye nanak kodäŋani unita watä irektawä yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Täŋpäŋ yeriniye mäden ahänayäŋ täkaŋ u kudup kaŋ kumbut yäŋ nadätat. Täŋirä wäpitä paot-inik kaŋ täŋpän! ");
INSERT INTO iou_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Täŋpäkaŋ äbekiye oraniye täŋo kudän wakiwaki unita Ekänitä pen juku piŋpäŋ miŋi täŋo momini peŋ imektawä. ");
INSERT INTO iou_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Ude täŋkaŋ ämawebetä äbot unitäŋo wäpita guŋ tak-inik täŋirä upäŋkaŋ Ekänitä momini pen nadäŋ yäpmäŋ kaŋ kuŋarän yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Iwanna uwä orakorak kädet täpuri kubä nämoinik täŋkuk. Nämo, u äma jopi jäwäri, täŋkentäkiye nämo u komi jop nadäŋ yämiŋpäŋ däpmäkgän täk täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","U täŋpäwak man yäkta gäripi nadäŋkuko unita äyäŋutpäŋ ini kaŋ täŋpä wawut. Ba iron kädet täkta gaŋani nadäŋkuko unita kubätä iron nämo täŋ imek. ");
INSERT INTO iou_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Täŋpäwak man u tek gupi terakgän irani ude täŋkuk. Unita täŋpäwak man u ini gupi kujari gänaŋ kudup umetä-yäŋ äpmoŋpäŋ tokŋeŋ morewut! ");
INSERT INTO iou_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Ba tektä-yäŋ täktäki waki unitä gupi kudup uwäk täŋpipiŋpäŋ, pioŋpäŋ yäŋ puŋ topmäŋkaŋ pen it täyon. ");
INSERT INTO iou_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Unita Ekäni, iwanaye man waki näk peŋkentäŋpäŋ näwet täkaŋ unita yäyat udegän täŋ yämi. ");
INSERT INTO iou_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Ude täŋkaŋ Ekäni Anutuna gäkŋa wäpka biŋam täga unita yäŋpäŋ täŋkentäŋ nam. Täŋpäŋ säkgämän nadäŋ namikinik täk täyan unita iwan keri terak nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Butewaki! Näk täŋkentäkna nämo, jopi. Nadäŋ-bäräpnatä bänepnaken komi, womäntä yäŋ neyak. ");
INSERT INTO iou_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Edap äpmoŋirän edap ägoniken wärana paot täyak ude paoret yäŋ nadätat. Mänittä gwakgwak piäŋ äreyäŋ täŋpän kuk täkaŋ ude täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Butewaki nadäŋpäŋ ketem bitnäŋkuro unita gupna kudup putärewäkaŋ kehäromina nämo, kujatna kwini unitägän itat. ");
INSERT INTO iou_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ude irira iwanayetä nabäŋkaŋ nabäŋ mägayäŋpäŋ yäŋärok näwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","O Ekäni Anutuna, täŋkentäŋ nam! Butewakika tärek-täreki nämo unita nämagut. ");
INSERT INTO iou_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ude täŋiri iwanayetä ŋode kaŋpäŋ nadäwut; Ekäni uwä täŋkentäki bureni. ");
INSERT INTO iou_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Unitä täŋpäwak man näwetneŋo upäŋkaŋ gäkä iron api täŋ namen. Komi jop namani u täŋpewi mäyäk taŋirä näk epän watä ämaka oretoret kaŋ täŋpa. ");
INSERT INTO iou_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Äneŋi yäkgän ŋode täyat; Mäyäktä iwanaye tek ämet päranipäŋ yäŋ kumän kaŋ uwäk täwut! ");
INSERT INTO iou_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","31","Ekänitä äma täŋkentäki nämo itkentäŋ yämiŋpäŋ äma wakitä kumäkta biŋam yäŋtäreŋ yämiŋirä täŋkentäŋ yämik täyak. Unita, Anutu täŋo ämawebe käbeyä täŋirä u bämopiken itpäŋ bänep täga pähap nadäŋpäŋ menatä Ekäni bumta api iniŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Ekänitä intäjukun äma ekänina ŋode iwetkuk; Ketna bure käda maŋiriri iwankaye gämotkaken yepmaŋira kaŋ yabä! Ude iwetkuk. ");
INSERT INTO iou_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Nadätan? Yawetä Saion pom terak itkaŋ komeni komeni yabäŋ yäwatta wäp biŋam gamiŋpäŋ ŋode api gäwerek; Iwankayeta intäjukun täŋ yämiŋpäŋ kaŋ yabäŋ yäwat. ");
INSERT INTO iou_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Täŋpäkaŋ iwankayekät ämik tänayäŋ täkaŋken ämawebekayetä täŋkentäŋ gamikta gupi api yäniŋ kireneŋ. Täŋkaŋ tamimaŋ tamimaŋ näburum yabäk täkamäŋ ude äma gubaŋikayetä dubikaken ude api gäwarän täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yawetä ŋode yäŋkehärom taŋkuko u äneŋi nämo api wärämurek; Gäk bämop äma tärek-täreki nämo api iren, bämop äma biani kubä wäpi Melkisedektä itkuko ude. ");
INSERT INTO iou_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Eruk, ŋode nadä; Ekäni u bure käda itkentäŋ gamiŋkaŋ kokwawak täŋpäŋä kome ätu täŋo intäjukun äma täŋo kehäromi api yäpmäŋ äpek. ");
INSERT INTO iou_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Ba guŋ äbottä kowata yäpmäkta yäŋtäreŋ yämiŋpäŋ ämikken bumta däpmäŋirän ini ugän api kumäŋ maneŋ. Bureni, komeni komeni täŋo intäjukun ämaniye täŋo kehäromi u kudup api yäpmäŋ äpek. ");
INSERT INTO iou_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Upäŋkaŋ intäjukun ämana gäk, ume kädet miŋin säkgämän naŋ täpäneŋpäŋ iwan täŋo kehäromi kudup yäpmäŋ äpäŋ moreŋpäŋ oretoret terak täpäneŋpäŋ api iren. ");
INSERT INTO iou_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Eruk, Ekäni wäpi iniŋ oretna! Anutu täŋo ämawebeniye täga u käbeyä täŋirä näk bämopiken itkaŋ bänepna gupna nadäk-nadäkna kuduptagän Anutu bänep täga man iwet täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Ekäni u epän tägagämän täk täyak. Täŋirän ämawebe epäni unita gäripi nadäk täkaŋ uwä Anutu täŋo täktäkita juku piŋtäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Bureni-inik! Epän Anututä täk täyak u tägagämän-inik. Unita nadäwa inide kubä täk täyak. Täŋkaŋ kudän siwoŋini uwä paot-paori nämo. U pen api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Kudän kudupi Ekänitä täk täyak u inide kubä täk täyak. Unita bäräŋeŋ nämo guŋtak täkamäŋ. U butewaki pähap nadäŋ nimiŋpäŋ iron täŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Ämawebe oraŋ imik täkaŋ u Ekänitä ketem yepmäŋ towik täyak. Ba topmäk-topmäk ninkät täŋkuko unita nämo guŋtak täyak. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Täŋpäkaŋ äbot ätu täŋo kome, iniken ämawebeniyeta yäniŋ kireŋkuko uwä iniken kehäromini kwawak pewän ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Bureni-inik! Imaka u ba u täk täyak uwä kädet siwoŋi terakgän täk täyak. Man kädet ba jukuman niwet täyak u kuduptagän täga täŋkentäŋ nimek. Man jopi kubä nämo niwet täyak! ");
INSERT INTO iou_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Ba unitäŋo baga man kubä nämoinik api paorek. Nämo, uwä kudup siwoŋigän peŋkuko unitä pen api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Täŋpäkaŋ Ekäni u ämawebeniye nin komi epänken nanik nimagutpäŋ ninkät topmäk-topmäk täga, tärek-täreki nämo täŋkuk. Unita ŋode yäna; Anutu u kudupi, tägagämän-inik. ");
INSERT INTO iou_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Unita ämawebe, in ŋode nadäwut; Äma kubä nadäk-nadäk ikek ude kaŋ irayäŋ nadäŋpäŋä, eruk, Ekänita umuntaŋpäŋ oraŋ imek. Bureni, ämawebe Ekäni täŋo man buramik täkaŋ uwä nadäk-nadäk täga nikek. Unita Ekäni wäpi iniŋ oretpäŋ pen iniŋoret täkäna! ");
INSERT INTO iou_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Ekäni wäpi yäpmäŋ akuna! Äma Anutu oraŋ imik täkaŋ uwä Ekäni täŋo oretoret terak kuŋat täkaŋ. Äma udewanitä Anutu täŋo man buramikta gäripi nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Äma udewani täŋo äbekiye oraniyetä kome terak kehäromigän api itneŋ. Siwoŋi äma täŋo nanakiyetä Anutu täŋo täŋkentäk ikek api itneŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Äma udewani täŋo äboriyeken iron pähap ahäŋ-bumbum api täŋ yämek. Täŋpäŋ tärek-täreki nämo, säkgämän pen api irek. ");
INSERT INTO iou_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Jop manman nämo yäwani ämata bipmäŋurani gänaŋ peŋyäŋek pähap api ahäŋ yämek. Täŋpäkaŋ äma siwoŋi, bänep iron täŋpani ba äma ätuta täŋkentäŋ yämani unita peŋyäŋek api ahäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","6","Äma noriyeta butewaki nadäŋ yämik täkaŋ uwä säkgämän kuŋat täkaŋ. Täŋpäŋ äma moneŋ epän siwoŋigän, täŋyäkŋarani nikek nämo täk täkaŋ uwä oretoret terak kuŋat täkaŋ. Äma udewani täŋo kehäromi pen api irek. Äma mäden ahänayäŋ täkaŋ unitä wäpi biŋam pen api yäŋ yäpmäŋ äroneŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Äma udewanitä bäräpi kukŋi käda ahäŋirän nadäŋpäŋ nämo umuntak täkaŋ. Bänepitä Ekäni kwasikotpäŋ unita nämo kwitak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Äma udewanitä bätakigän kuŋatpäŋ imaka kubäta nämo umuntak täkaŋ. Ittäŋgän iwaniye iŋamiken kehärom taŋpäŋ bäri kap api teneŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Äma udewani jopi jäwärita butewaki nadäŋ yämiŋpäŋ iron täŋ yämik täkaŋ. Kädet siwoŋini u paot-paori nämo api irek. Unita ämatä wäpi biŋam api yäŋahäŋ yäpmäŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Täŋpäkaŋ äma wakitä u kaŋkaŋ kokwawak nadäk täkaŋ upäŋkaŋ gupi pewä putäreŋirän meni nänäm tawäpäŋ ämik täkta täŋpäwak täkaŋ. Täŋpäŋ imaka täga kämi yäpmäkta itsämäk täkaŋ uwä bureni nämo yäpmäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Ekäni iniŋoret täkäna! Ekäni täŋo epän watä ämaniye nin u wäpi iniŋoret täkäna! Äneŋi yäwa! Ekäni wäpi yäpmäŋ akuna! ");
INSERT INTO iou_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Yäŋetak bipmäŋtak tärek-täreki nämo iniŋoret täkäna! ");
INSERT INTO iou_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Ämawebe kukŋi kukŋi nanik in imaka, kudup Ekäni wäpi iniŋoret täkot! ");
INSERT INTO iou_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Ekänitä ämawebe komeni komenita intäjukun-inik it nimik täyak. Wäpi biŋamtä imaka imaka kome terak ba kunum gänaŋ itkaŋ u kumän yärepmitak. ");
INSERT INTO iou_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Ekäninin Anutu udewani kubä nämo itak! Nämoinik, Ekäninin u punin-inik unu it täyak. ");
INSERT INTO iou_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Bureni, u punin-inik unu it täyak upäŋkaŋ kunum kenta kome unita nadäŋpäŋ etä päpä yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","8","Ekäninin kudän tägagämän täk täyak. U äma äpani-inik, jopi jäwäri täŋkentäŋ yämiŋpäŋ yepmaŋpän äma wäpi biŋam ikekkät kentäŋpäŋ it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Täŋpäkaŋ webe äruŋ iranita nadäŋ yämiŋirän nanak bäyaŋkaŋ oretoret pähap nadäk täkaŋ. Unita Ekäni iniŋoret täkäna! ");
INSERT INTO iou_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","2","Kadäni Isrel nanik Jekop täŋo äbot unitä Isip komeken nanik äpämaŋ kuŋkuŋo uken, Juda äbot u Ekäni täŋo kudupi ämawebe ude äworeŋkuŋ. Bureni, kadäni ugän Isrel ämawebetä Ekänitä inita biŋam täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Kadäni uken Gwägu Gämänitä Ekäni kaŋ-umuntaŋ ämetpeŋ kuŋkuk. Ba kadäni kubä Jodan ume imaka, bitnäŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Täŋkaŋ pom taŋi taŋi oretoret täŋpäŋ memetä-yäŋ tubupeŋtäŋ kuŋirä, täpuri täpuriwä udegän sipsiptä-yäŋ tubupeŋtäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Eruk näwerut; Gwägu, gäk imapäŋ kaŋkaŋ metäŋpeŋ kuŋkun? Ba Jodan ume, gäk ima mebärita äpäkta bitnäŋpäŋ itkun? ");
INSERT INTO iou_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","E, pom taŋi taŋi, in ima mebärita memetä-yäŋ tubupeŋtäŋ kuŋkuŋ? Ba täpuri täpuri in udegän, imapäŋ kaŋkaŋ sipsiptä-yäŋ tubupeŋtäŋ kuŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Ai, kome pähap, Yawe, Jekop täŋo Anututä äbäŋirän kaŋkaŋ iŋamiken bäromtä! ");
INSERT INTO iou_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Imata, Ekäni uwä yäŋpewän mobä kehäromi kubätä imärirän ume gwägu ahäŋkuk. Ba yäŋpewän geŋi kawukiken ume dapuri äpuk. ");
INSERT INTO iou_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ekäni, nintäŋo wäpnin biŋam punin nämo irek. Nämo, nin täga nämo! Gäkŋaken wäpka biŋam peŋyäŋek ikek unitägän punin kwawakinik it täyon, gäk nadäŋ nimikinik täŋpäŋ nämo nipmak täyan unita. ");
INSERT INTO iou_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Guŋ äbottä sära man ŋode imata niwet täkaŋ; Anutujin u de itak? ");
INSERT INTO iou_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","U nämo nadäkaŋ? Nin täŋo Anutu u kunum gänaŋ kehäromi nikek itak. U itkaŋ imaka kubä täŋpayäŋ nadäŋpäŋä u burenigän täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Täŋ äma unitäŋo anutuwä siliwa kenta gol mobäpäŋ keritä iŋitpäŋ puŋ gatäŋpäŋ pek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","U meni nikek täk täkaŋ upäŋkaŋ meni man täga nämo yäneŋ. Ba dapuri nikek täk täkaŋ upäŋkaŋ dapuri wareŋ täga nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Ba jukuni nikek täk täkaŋ upäŋkaŋ man täga nämo nadäneŋ. Ba iŋami nikek täk täkaŋ upäŋkaŋ imaka kubä täga nämo piäŋ nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Keri nikek täk täkaŋ upäŋkaŋ keri wareŋ täŋpäŋ imaka kubä täga nämo iŋitneŋ. U kuroŋi nikek täk täkaŋ upäŋkaŋ kädet täga nämo kuneŋ. Ba wareŋ täŋpäŋ mämä täga nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Unita äma imaka udewani täŋpani, ba äma unita nadäŋ yämik-inik täk täkaŋ u imaka, imaka wärani täŋpäŋ nadäŋ yämineŋo udewanigän api äworeneŋ! ");
INSERT INTO iou_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Eruk, Isrel ämawebe, Ekänijin täŋkentäŋ tamiŋpäŋ watä it tamik täyak unitagän nadäŋ imikinik täŋput. ");
INSERT INTO iou_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Anutu täŋo bämop äma, in udegän täŋkentäŋ tamiŋpäŋ watä it tamik täyak unita Ekäni unitagän nadäŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Bureni, ämawebe Anutu bureni u iniŋ orerani in kudup Ekäni täŋkentäŋ tamiŋpäŋ watä it tamik täyak unitagän nadäkinik täŋput. ");
INSERT INTO iou_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Ekäni u ninta nämoinik guŋtak täyak. Nämo, u Isrel ämawebe ba Anutu täŋo bämop äma ninta nadäŋ nimikinik täŋpäŋ iron pen api täŋ nimik täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Anutu u ämawebe kuduptagän, äpani ba ärowani iniŋoret täkaŋ unita iron api täŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","15","Ekäni kunum kenta kome pewän ahäwani unitä yeri kon täŋ tamiton. Kon täŋirän nanak weŋ bäyak pen kaŋ täŋ yäpmäŋ kut! Ba nadäŋ tamiŋirän nanakjiyetä udegän kaŋ täŋ yäpmäŋ kut! ");
INSERT INTO iou_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Täŋpäkaŋ kunum uwä Ekänitä inita biŋam. Täŋ kome uwä ninta niniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","18","Unita ämawebe kodak irani nin, Ekänita bänep täga tärek-täreki nämo nadäŋ imik täkäna. U imata, kumäŋpeŋ päŋku kum irit komeken naniktä Ekäni täga nämo iniŋ oretneŋ. Eruk, Ekäni wäpi iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Ekäni täŋkentäŋ nam yäŋpäŋ gera butewaki terak yäŋira nadäŋ namik täyak unita Ekänita gäripi pähap nadätat. ");
INSERT INTO iou_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Näkŋo gerata juku pek täyak unita näk it yäpmäŋ kwayäŋ täyat ude Anutu iniŋoret yäpmäŋ kaŋ kwa. ");
INSERT INTO iou_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","4","Näk pära kumäŋpäŋ unita bumta umuntaŋkut. Kadäni uken Ekänita gera yäŋpäŋ ŋode yäŋkut; Ekäni, butewaki nadäŋ namiŋpäŋ täŋkentäŋ nam! yäŋ yäŋkut. ");
INSERT INTO iou_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Ekäni uwä ninta bänep täga nadäŋ nimiŋpäŋ täŋkentäŋ nimik täyak ba butewaki nadäŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Bureni! Äma ätu ini täga nämo täŋkentänaŋi uwä Ekänitä täŋkentäŋ yämik täyak. Näk ude itkuro upäŋkaŋ täŋkentäŋ namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Täŋpäŋ Ekänitä näk nabäŋ näwatpäŋ täŋkentäŋ namiŋkuko unita apiŋo imaka kubäta nadäwätäk nämo täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Näk konäm kottäyiwa Ekäni gäkä naniŋ bitnäŋpäŋ konämna pito ärut namiŋpäŋ nepmäŋit näwatkun. Näk kumbayäŋ täŋkuropäŋ Anutu gäkä täŋkentäŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Unita näk kome terak irayäŋ täyat uwä Ekänikät bok api it yäpmäŋ kuŋatde. ");
INSERT INTO iou_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Näk bumta wayat yäŋ nadäŋkuro upäŋkaŋ Ekäni jop waki nadäŋ imiŋkut. ");
INSERT INTO iou_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Täŋpäŋ näk äma täŋo manta nadäwa bureni nämo täŋpäkaŋ Anutugän nadäŋ imiŋkut. ");
INSERT INTO iou_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Ekänitä säkgämän täŋ namiŋ yäpmäŋ äbuko unita kowata jide api täŋ imet? ");
INSERT INTO iou_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","14","Näk nadätat! Ude api täŋ gamet yäŋ yäŋkehärom taŋkuro unita ämawebe kudup iŋamiken ŋode täga api täŋpet; Anututa iron imikta wain ume gäripi nikek inita biŋam kaŋ piŋ ima, Ekänitä nämagutkuko unita kowata. Ude täŋkaŋ Ekäniken yäŋapik man api yäwet. ");
INSERT INTO iou_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Täŋpäkaŋ Ekänitä ämawebeniyeta nadäwän ärowani täk täkaŋ. U kubätä kumäŋirän nadäwän jopi nämo täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Unita Ekäni, ŋode gäwera; Näk gäkŋo epän ämaka ude kuŋat täyat, meŋnatä kuŋat täŋkuko ude. Näk yentä topmäŋpäŋ nepmaŋkuŋopäŋ gäkä pit namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Unita näk gäka bänep tägata iron täŋ gamiŋpäŋ api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Täŋpäŋ näk ude api täŋ gamet yäŋ gäwetkuro ude ämawebekaye iŋamiken api täŋ gamet. ");
INSERT INTO iou_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Ekäni, näk täŋpayäŋ täyat u Jerusalem kudupi yotkaken api täŋ gamet. Unita Ekäni wäpi yäpmäŋ akukot! ");
INSERT INTO iou_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Äma äbori äbori, in Ekäni iniŋ orerut! Ämawebe kuduptagän in wäpi biŋam yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ekänitä ninta gäripi pähap nadäŋpäŋ wari wari nadäŋ nimikinik täk täyak. Unita iniken yäŋkehäromtak man bian yäŋkuko udegän iwatpäŋ nämoinik api nipmaŋpek. Unita ämawebe kuduptagän Ekäni wäpi iniŋoret täkäna! ");
INSERT INTO iou_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Ekäni nadäŋ nimik täyak unita bänep täga man iwet täkäna. Bänep iron tärek-täreki nämo täŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Unita Isrel ämawebe ŋode yäkot; Bänep iron tärek-täreki nämo täŋ nimik täyak! ");
INSERT INTO iou_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Anutu täŋo bämop äma udegän ŋode yäkot; Bänep iron tärek-täreki nämo täŋ nimik täyak! ");
INSERT INTO iou_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Ämawebe Anutu täŋo man buramik täk täkaŋ unitä ŋode yäk täkot; Bänep iron tärek-täreki nämo täŋ nimik täyak! ");
INSERT INTO iou_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Näkä bäräpi taŋi kotaŋpäŋ Ekänita gera yäŋkut. Gera yäŋira nadäŋpäŋ Ekäni uwä bäräpina ketäreŋ namiŋirän pidäm taŋkut. ");
INSERT INTO iou_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Ekäni uwä näkkät irirän nämo api umuntäwet. Nämo, ämatä imaka kubä täŋ namikta nämo umuntak täyat. ");
INSERT INTO iou_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Ekäni näkkät it täkamäk. Täŋkaŋ ini täŋkentäŋ namik täyak unita kämi iwanaye däpmäŋirän api yabäwet. ");
INSERT INTO iou_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Bureni! Äma täŋo täktäki-tagän nadäŋitna ärowani nämo täŋpäpäŋ Anututagän nadäŋ imikinik täŋpeŋ kuŋatneŋo u tägagämän. ");
INSERT INTO iou_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Komen äma täŋo täŋkentäk u äpanigän. Ekäni täŋo täŋkentäk u ärowani. ");
INSERT INTO iou_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Unita iwan mäyaptä it gwäjiŋ namiŋkuŋopäŋ Ekäni täŋo wäpi terak kehäromini yäpmäŋ äput. ");
INSERT INTO iou_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Näk it gwäjiŋkuŋopäŋ Ekäni täŋo kehäromi terak däput. ");
INSERT INTO iou_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Iwanayetä nämäk-nämäktä nintä terak bipmäk täkaŋ ude täŋkuŋo upäŋkaŋ däpmäŋ-pewa kumbuŋ, kädäptä tepäraŋ bäräŋeŋ ijiŋ paot täkaŋ ude. Ekäni täŋo kehäromi terak däpmäŋ moreŋkut. ");
INSERT INTO iou_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Ämik pähap täŋpäŋ nepmäŋitpäŋ nutnayäŋ täŋirä Ekänitä täŋkentäŋ namiŋirän nämo nutkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Bureni, Ekänitä kehäromi pähap namiŋpäŋ täŋkentäŋ namik täyak. U wakiken nanik nämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Täŋpäŋ unita Anutu täŋo ämawebe tähaniken iniŋoret kap teŋit gera ŋode yäk täkaŋ; Anutu täŋo kehäromitä epän kehäromi-inik täk täyak! yäk. ");
INSERT INTO iou_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Ekäni täŋo kehäromitä täŋkentäŋ nimiŋirän iwan täŋo kehäromi yäpmäŋ äpumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Näk pengän ŋode nämo api kumbet. Nämo! Näk kodak itkaŋ Ekäni täŋo täktäki unitäŋo manbiŋam api yäŋahäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Bureni, Ekäni uwä kumäŋ-kumäŋ nutta bitnäŋpäŋ näk yäpä-siwoŋtakta komigän namiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Unita kudupi yot yäma dät namiŋirä äro Anutu wäpi yäpmäŋ akwa! ");
INSERT INTO iou_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Ŋo ŋowä Ekäni täŋo yäma, ämawebe siwoŋi kuŋarani unitägän täga äroneŋ. ");
INSERT INTO iou_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Ekäni, gäk näkŋo yäŋapik man nadäŋ namiŋpäŋ täŋkentäŋ namiŋiri säkgämän it täyat. Unita ganiŋ oretat! ");
INSERT INTO iou_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Bek eŋi täŋpani ämatä kawä wawäpäŋ gägäniken maŋpä kuŋkuŋo unitä eŋi täŋo bek bämopi ude itak. ");
INSERT INTO iou_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Imaka uwä Ekäni ini-tägän täŋirän kaŋpäŋ gäripi pähap nadäkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Täŋpäŋ kadäni ŋowä Ekänitä peŋ nimiŋkuk. Unita oretoret täŋpäŋ bänep tägagämän nadäna! ");
INSERT INTO iou_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Ekäni, gäk täŋkentäŋ nimi. O Ekäni, täŋpewi bureni säkgämän ahäŋ nimän! ");
INSERT INTO iou_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Anutu, äma gäkŋaken wäpka terak äbayäŋ täyak uwä kaŋ oraŋ imi. Täŋiri nin udegän kudupi yot gänaŋ äroŋpäŋ wäpka api yäpmäŋ akune. ");
INSERT INTO iou_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Ekäni ini-tägän Anutu bureni! Ini-tägän ninta watä säkgämän it nimik täyak. Unita päya pähäm kehap täŋpäŋ alta teŋ äyäŋut täkot. ");
INSERT INTO iou_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Gäk Anutuna! Bänep täga man gäwetat. Gäk Anutuna! Gäkŋo wäpka yäpmäŋ akutat. ");
INSERT INTO iou_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Eruk ämawebe ŋode nadäkot; Ekänitä ninta gäripi nadäŋpäŋ iron täŋ nimik täyak u paot-paori nämo unita bänep täga man iwet täkot. ");
INSERT INTO iou_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Äma kädet siwoŋigän säkgämän kuŋat täkaŋ uwä Ekäni täŋo oretoret terak it täkaŋ. Äma udewaniwä Ekäni täŋo man buramiwani äma. ");
INSERT INTO iou_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Äma Ekäni täŋo kädet siwoŋi iwat täkaŋ, äma udewani Ekäni täŋo oretoret terak it täkaŋ. Ekäni täŋo kädet u iwatta gäripi pähap nadäŋpäŋ ehutpäŋ iwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Bureni-inik, äma udewani kädet waki iwatta bitnäŋpäŋ Ekäni täŋo kädet siwoŋi ugän iwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Anutu, gäk man kädetka siwoŋi u kudup niwetpäŋ ŋode yäŋkun; Watäni itpäŋ näkŋaken kädet siwoŋi ugän kaŋ iwarut yäŋ niwetkun. ");
INSERT INTO iou_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Unita Anutu, näk gäkŋo man kädet siwoŋi u iwatta gäripi pähap nadäk täyat udegän wari wari kaŋ iwat täŋpa yäŋ nadätat! ");
INSERT INTO iou_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Bureni, gäkŋo jukuman kuduptagänta ket nadäŋpäŋ kuŋarayäŋ täyat uwä momi täŋpäŋ nämo api mäyäk täwet. ");
INSERT INTO iou_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ekäni, kadäni gäkŋo man kädet siwoŋi yäŋpäŋ-nadäk täŋpayäŋ täyatken uken bänepna säkgämän paki-inik api irek. Ude täŋkaŋ gäkŋo wäpka biŋam api yäpmäŋ akuk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Näk gäkŋo irit kädetka kudup iwatta nadätat unita nämo nepmaŋpen. ");
INSERT INTO iou_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Äma gubaŋi näk jide täŋpäŋ kädet siwoŋigän täga kuŋaret? Näk gäkŋo man iwarero uyaku äma siwoŋi ude iret. ");
INSERT INTO iou_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Unita Anutu, näk gäkŋo kädet u iwatta gäripi pähap nadäŋpäŋ ehutpäŋ iwat täyat. Gäkä täŋkentäŋ namiŋiri kädet siwoŋita nämo bitnäŋpäŋ ugän api iwaret. ");
INSERT INTO iou_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Näk gäkken momi täŋpetawä yäŋpäŋ gäkä nanik man ugänpäŋ bänepnaken pek täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Ekäni, kädetka siwoŋi näwetpäŋ näwoŋärek täŋiri ugän iwatpäŋ wäpka biŋam kaŋ ganiŋ orera. ");
INSERT INTO iou_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Näk kädet kuduptagän yäŋahäŋpäŋ niwetkuno u ämawebe kudup yäŋahäŋpäŋ yäwet täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ämatä moneŋ tuŋumta gäripi pähap nadäk täkaŋ u irepmitpäŋ näk gäkŋo man iwatta gäripi udegän nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Gäkŋo manka juku piŋpäŋ manka kädet siwoŋi u yäŋpäŋ-nadäk täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Anutu, gäkŋo kädet siwoŋi iwatta gäripi nadäŋpäŋ gäkŋo mankata nämo api guŋ täwet. ");
INSERT INTO iou_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Unita Ekäni, epän watä ämaka näka täŋkentäk säkgämän täŋ namiŋiri säkgämän itpäŋ gäkŋo mangän kaŋ iwara. ");
INSERT INTO iou_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Bänepna täŋo dapuri birik ärut täŋpi kuŋirä ijiwa-kwäpäŋ man bureni gäripi nikek gäkŋo man kudän terak pätkaŋ u kudup nadäwa tärewut. ");
INSERT INTO iou_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Näk kome ŋo terak kadäni käroŋi itta biŋam yäwani nämo unita gäkŋaken man kädet u näka käbop nämo peŋ namen. Nämo! ");
INSERT INTO iou_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Näk gäkŋo manka biŋam u kepma kepma yäŋpäŋ-nadäk täŋpäŋ iwatta bänepnatä kädäp ijik täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ekäni, näk nadätat. Äma inita nadäwä ärowani täŋpäpäŋ manka mäde ut imik täkaŋ u yebeŋpäŋ mäde ut yämiŋiri paotta biŋam täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Täŋpäkaŋ näk gäkŋo man buramiŋpäŋ iwat täyat unita äma udewani yabäŋ äwaräkuk täŋiri yäŋärok ba mäde käda man wari nämo näwetneŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Bureni Ekäni, äma wäpi biŋam ikektä käbeyä täŋpäŋ näk wäpna yäpmäŋ äpäkta yäŋpäŋ-nadäk täk täkaŋ upäŋkaŋ epän watä ämaka näk gäkŋo jukuman ehutpäŋ yäŋpäŋ-nadäk api täk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Imata, gäkŋo jukuman unitä bänepna täŋpidäm taŋpäŋ kädet näwoŋärek täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Wära! Iwanayetä näk nutpäŋ näwat kireŋpewä kehäromina kudup paotak unita gäk bian näwetkuno ude täŋkentäŋ namiŋpäŋ kehäromi äneŋi namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Irit kuŋat-kuŋatna täŋo mebäri kudup yäŋahäŋpäŋ gäwerira kowata näwetkun. Unita apiŋo gäkŋaken man kädet u näwetpäŋ näwoŋäresi! ");
INSERT INTO iou_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Täŋpäŋ nadäk-nadäkna täŋpewi piräreŋirän gäkŋo jukuman nadäwa tärewäkaŋ kudän kudupi täŋkuno unita kaŋ juku piwa. ");
INSERT INTO iou_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Wära! Butewakitä nutpewän kumbet yäŋ nadätat unita näwetkuno udegän kehäromi äneŋi namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Täŋpäkaŋ bänepnatä täŋ-näkŋat-pewän kädet wakiwaki täŋpetta yäŋpäŋ baga peŋkireŋpäŋ yewa täŋ namisi. Täŋpäŋ bänep täga nadäŋ namiŋpäŋ baga manka näwetpäŋ näwoŋärek täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Imata, näk gäkŋo kädet bureni iwatta iwoyäŋpäŋ yäŋkehärom taŋkut. Ude täŋkaŋ man kädetka wari wari pen juku piŋpäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Ekäni, näk juku-manka iŋit-inik täŋpäŋ yäpmäŋ kuŋat täyat unita yabäŋ äwaräkuk täŋiri iwantä mäyäk nämo namineŋ! ");
INSERT INTO iou_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Eruk, wisik-inik! Bänepna täŋpidäm taŋ namik täyan unita gäkŋo baga man kädetka ugänpäŋ kaŋ iwat täŋpa! ");
INSERT INTO iou_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Ekäni, baga man kädetka ket näwoŋäreŋiri näk kädet u pen iwat yäpmäŋ äroŋtäŋgän kaŋ kumba! ");
INSERT INTO iou_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Nadäk nadäk täŋkentäŋ namiŋiri baga manka buramiŋpäŋ kaŋ yäpmäŋ kuŋara. Gupna bänepna bok kaŋ yäpmäŋ kuŋara! ");
INSERT INTO iou_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ekäni, baga manka kädetkaken yäŋnäkŋat yäpmäŋ ku. Imata, u iwat täyatken uken bänep oretoret nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Unita bänepna täŋpidäm taŋiri moneŋ wädäk-wädäk täŋo gärip mäde ut imiŋpäŋ gäkŋo baga man iwattagän gäripi kaŋ nadäk täŋpa! ");
INSERT INTO iou_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Dapunna teŋ-pipiwayäŋ täyan uyakuwä imaka jopi-jopita yabäŋgärip nämo api täŋpet. Ude täŋkaŋ näwetkuno udegän iritnata watä säkgämän it namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Anutu, ämawebe nadäŋ gamik täkaŋ u täŋkentäŋ yämikta yäŋkehärom taŋkun. Eruk, epän ämaka näkken udegän pewi kaŋ ahäŋ namän. ");
INSERT INTO iou_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Iwantä mäyäk man näwetta umuntäyat unita nadäŋ namiŋiri kaŋ närepmirän. ");
INSERT INTO iou_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","O Ekäni, baga manka ba juku-manka iwatta gäripi pähap nadätat unita gäkŋaken nadäk siwoŋi terak iwatpäŋ irit säkgämän u namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Täŋkaŋ Ekäni, gäk iron mähemi unita ironka u kwawak näwoŋäreŋpäŋ näwetkuno udegän wakiken nanik täŋken täŋpäŋ kaŋ nämagut. ");
INSERT INTO iou_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ude täŋ namiŋiri äma yäŋärok näwet täkaŋ unitäŋo man täga uret. Imata, gäkŋo manta nadäkinik täyat unita. ");
INSERT INTO iou_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","O Ekäni, mena täŋpidäm taŋiri manka bureni u yäŋahäk täyiwa. Imata, kehäromi kubäken nämo yäpmäk täyat, gäkŋo man terakgän yäpmäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Unita gäkŋo jukuman u tärek-täreki nämo buramiŋpäŋ api iwat täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Bureni, gäkŋo jukuman iwatta nadäk täyat unita iwanayetä täga nämo api topmäŋpäŋ nepmäŋitneŋ. Nämo, bätakigän api kuŋaret. ");
INSERT INTO iou_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Täŋpäkaŋ kome täŋo intäjukun äma iŋamiken gäkŋo jukuman api yäŋahäk täŋpet. Ude täŋira manna u utpäŋ mäyäk täga nämo api namineŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","U imata, gäkŋo mankata gäripi pähap nadäŋpäŋ buramiŋira bänepnatä pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ekäni, man kädetkata gäripi nadäk täyat unita nadäŋira ärowani täŋpäpäŋ yäŋpäŋ-nadäk täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Ekäni, yäŋkehäromtak man bian epän watä ämaka näk näwetkuno u nadäŋpäŋ täŋkentäŋ nam. Man näwetkuno unitä bänepna täŋ-kehäromtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Bäräpi kadäniken man unitä bänep kwini pewän ahäŋ namik täkaŋ ba iritna täŋ-mehamtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Täŋpäkaŋ butewaki pähap! Äma ärowanitä yäŋärok man bumta näwet täkaŋ. Upäŋkaŋ näk gäkŋo man unitagän gwäk pimiŋpäŋ manka ugänpäŋ iwat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Ekäni, baga manka bianiinik uterak kehäromi yäpmäk täyat unita u pen juku pik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Unita äma wakiwakitä gäkŋo baga man u pekinik täŋirä yabäŋpäŋ bänepna täŋpäwak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Täŋpäkaŋ uken-uken ittäŋ kuŋat täyatken gäkŋo baga manta gäripi nadäŋpäŋ unita kap ganiŋ ubiŋ teŋtäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Ekäni, bipani bipani näk gäka juku pik täyat. Täŋkaŋ baga manka u nämo api pewet. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Baga manka wari wari iwat täyat unitä bänepnaken oretoret pewän ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Ekäni, gäk it namitan unita imaka gäripi nikek äneŋi kubäta nämo wäyäkŋek täyat. Mebäri unita gäkŋo man kädet kudup iwatta nadäŋpäŋ yäŋkehärom taŋkut. ");
INSERT INTO iou_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Täŋpäkaŋ Ekäni, gäk bian täŋkentäŋ namikta yäŋkehäromtak man yäŋkun. Unita gäkŋo man u nadäŋpäŋ täŋkentäŋ namikta bänep nadäk-nadäkna kudup gäkagän ganiŋ kiretat. ");
INSERT INTO iou_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Näk irit kuŋat-kuŋatna täŋo mebäri kudup nadäwa-tärewäpäŋ apiŋo gäkŋo man buramiŋpäŋ iwatta bänep peyat. ");
INSERT INTO iou_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Unita gäkŋo jukuman iwatta kämi kaŋ yäŋkaŋ nämo itsämäŋ yäpmäŋ kwet. Nämo, pengän yäput peyat ŋo. ");
INSERT INTO iou_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Bureni, äma wakitä näk nutta nadäŋpäŋ buŋep täŋkuŋo upäŋkaŋ näk bänepna äreyäwäpäŋ gäkŋo jukuman unita nämo guŋ täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Nämoinik, gäkŋo baga manka siwoŋi unita nadäŋpäŋ ganiŋ oretta bipani bämop-inik akuk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ba ämawebe gäk oraŋ gamiŋpäŋ juku-manka iwat täkaŋ ukät not täŋpäŋ kuŋat täkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Bureni Ekäni, kome ŋo terak ironka tokŋeŋ pätak. Unita man kädetka täŋo mebäri näwetpäŋ näwoŋäreŋiri kaŋ nadäwa tärewut! ");
INSERT INTO iou_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Ekäni, täŋkentäŋ namikta yäŋkuno u iwatpäŋ epän ämaka näka säkgämän täŋ namik täyan. ");
INSERT INTO iou_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Näk baga mankata nadäkinik täyat unita nadäk-nadäk täga namiŋiri baga man täŋo mebäri kaŋ nadäwa tärewut. ");
INSERT INTO iou_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Täŋpäkaŋ bian goret kuŋatkuro unita yäpä-siwoŋtakta komi namiŋkun. Ude täŋiri eruk apiŋo gäkŋo man buramitat. ");
INSERT INTO iou_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","O Ekäni, täŋkentäŋ namik täyan u tägagämän. Gäk orakorak täŋo mähemi bureni. Unita gäkŋaken man kädetka täŋo mebäri näwetpäŋ näwoŋärek täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Äma ärowani näka jop manman yäk täkaŋ upäŋkaŋ bänep nadäk-nadäkna kudup gäkŋo juku-manka uterakgän pek täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Täŋpäŋ äma ärowani uwä bänep nadäk-nadäki kumbani upäŋkaŋ nähä juku-manka unita gäripi pähap nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Täŋpäkaŋ nadätat; Komi nadäŋ itkuro u täŋkentäŋ namiŋkuk. Unitä bänepna yäpmäŋ sukureŋpewän bänep nadäk-nadäkna pewa baga manka terakgän kuyak. ");
INSERT INTO iou_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Unita Ekäni, apiŋo ŋode yäyat; Baga man mekatä pewi ahäwani unita nadäwa säkgämän-inik täyak, moneŋ tuŋum pähapta gäripi nadäk täkaŋ u irepmit moretak! ");
INSERT INTO iou_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Ekäni, gäkŋa ketkatä puŋ gatäŋpäŋ nepmaŋkuno unita nadäk-nadäk namiŋiri juku-manka unita yäŋpäŋ-nadäk täk täyiwa! ");
INSERT INTO iou_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Täŋira ämawebe gäk oraŋ gamik täkaŋ u näk nabäŋpäŋ ŋode nadäk täkot; Äma ŋo Ekäni täŋo jukumanta nadäkiniki kehäromi uterak pek täyak! Ude nadäŋpäŋ oretoret täk täkot. ");
INSERT INTO iou_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Ekäni, näk bureni ŋode nadätat; Näk yäpä-siwoŋtakta komi namiŋkuno uwä nadäŋ namikinik täŋpäŋ unita namiŋkun. Täŋpäkaŋ gäkŋo man kädet uwä siwoŋi-inik. ");
INSERT INTO iou_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Eruk, watä epän ämaka näk täŋkentäŋ namikta bian yäŋkuno u iwatpäŋ ironka paot-paori nämo u pewi ahäŋ namiŋiri butewaki nadäwätäk terak itat ŋo täŋ-kehäromtaŋ nami. ");
INSERT INTO iou_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Näk gäkŋo baga manta gäripi nadäk täyat unita butewaki nadäŋ namiŋiri äneŋi säkgämän kaŋ ira. ");
INSERT INTO iou_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Täŋpäkaŋ äma inita nadäwä ärowani täŋpanitä jop manman terak manken nepmak täkaŋ. Ude täk täkaŋ unita mäyäk kaŋ yäput! Upäŋkaŋ nähä gäkŋo jukuman unita pen juku piŋpäŋ api kuŋaret. ");
INSERT INTO iou_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Täŋira ämawebe gäk oraŋ gamiŋpäŋ gäkŋo jukuman nadäk täkaŋ unitägän näkken äbäkaŋ bok kaŋ itna. ");
INSERT INTO iou_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Täŋpäkaŋ Ekäni, gäripna ŋode pätak; Iŋamkaken täktäkna terak mäyäk yäpettawä yäŋpäŋ gäkŋo jukuman kudup siwoŋigän iwatta nadätat. ");
INSERT INTO iou_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Ekäni, gäkä täŋkentäŋ namikta itsämäŋ yäpmäŋ äbäŋira kehäromina paoränkaŋ kehäromina nikek nämo itat. Upäŋkaŋ man bian yäŋkuno u bureni api täŋpen yäŋ nadäkinik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Täŋpäkaŋ man yäŋkuno u bureni jidegän iwatpäŋ bänepna täŋpidäm täwayäŋ? U kakta dapun täŋ yäpmäŋ äbäŋira dapunna komi nekaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Näk imaka wawäpäŋ maŋpäkuk täkaŋ ude itat upäŋkaŋ gäkŋo juku-manka unita nämo guŋtak täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Wära! Piä watä ämaka bäräpi terak it yäpmäŋ äbätat ŋo äneŋi udegän kepma bipani jide api iret? Ba äma komi namik täkaŋ unita kowata jidegän api täŋ yämen? ");
INSERT INTO iou_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Nadätan? Äma inita nadäwä ärowani täŋpani, gäkŋo baga manta mäde ut imik täkaŋ u näk täŋpäwakta näkä kädetken awaŋ änek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","87","U jop nadäŋ komi namik täkaŋ unita täŋkentäŋ nam! Äma udewanitä nuttäko paotnaŋipäŋ itat. Täŋpäkaŋ juku-manka kudup u siwoŋi tägagän, ämatä nadäŋpäŋ iyap taŋpäŋ yäpmäŋ kuŋatnaŋigän. Täŋpäŋ komi butewaki terak itat upäŋkaŋ juku-manka unita mäde nämo utat. ");
INSERT INTO iou_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Unita ironka tärek-täreki nämo unita yäŋpäŋ iritna täŋmeham taŋiri juku-manka, mekatä yäŋiri ahäwani u kudup kaŋ iwara. ");
INSERT INTO iou_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","O Ekäni, gäkŋo manka u kunum gänaŋ, kehäromi tärek-täreki nämo pätak. ");
INSERT INTO iou_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Ironkatä kodakitä kodaki api it yäpmäŋ kwek. Kome pähap ŋo inide itta täŋ-kehärom taŋpäŋ peŋkuno wareŋi nämo it täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Imaka imaka kuduptagän u gäkŋo man buramiwanitä itkaŋ unita gäkŋo meka jinom terakgän it yäpmäŋ äbäŋ itkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Täŋpäkaŋ gäkŋo baga manka unita gäripi nämo nadäŋkut yäwänäku komi namiŋkuno unitä nutpewän paoram. ");
INSERT INTO iou_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Upäŋkaŋ nämo! Gäk juku-manka terak iritna täŋ-mehamtaŋ namiŋkuno unita juku-manka unita wari nämo api guŋ täwet. ");
INSERT INTO iou_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","O Ekäni, näk gäkŋata biŋam itpäŋ gäkŋo juku-manka kadäni kadäni iwatta ehutpäŋ epäni täk täyat unita wakiken nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Nadätan? Äma waki käbop itkaŋ näk nutta täŋtuŋum täkaŋ. Upäŋkaŋ näk nadäwätäk nämo täŋpäŋ gäkŋo jukumanta yäŋpäŋ-nadäk pen täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Täŋpäkaŋ ŋode yabäŋpäŋ-nadäk täyat; Imaka kome ŋo terak täga yäŋ yäk täkamäŋ u kudup api paot moreneŋ. Täŋ gäkŋo man u imaka bureni-inik, tärek-täreki nämo, inide itta yäwani. ");
INSERT INTO iou_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Wisikna! Gäkŋo manta gäripi pähap nadäk täyat. Täŋpäŋ unita kepma bipani yäŋpäŋ-nadäk täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Jukumanka u wari wari yäŋpäŋ-nadäk täk täyat unita nadäk-nadäkna uwä iwanaye täŋo nadäk-nadäki yärepmitak. ");
INSERT INTO iou_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ba ugän nämo. Man kädetka unitagän juku piŋpäŋ kuŋat täyat unita nadäk täga iŋitat uwä yäŋpäŋ-näwoŋärek täŋpani ämanaye unitäŋo nadäk yärepmitpäŋ iŋitat. ");
INSERT INTO iou_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Ba baga manka u buramik täyat unita nadäk-nadäk äma ekäni ekänitä nadäk täkaŋ u näkä yärepmitpäŋ nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Täŋpäkaŋ gäkŋo juku-manka kubä irepmiret yäŋ nadäŋpäŋ kädet wakiwaki u kudup yabäŋ umuntaŋpäŋ kukŋi kädagän yärepmit täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Ekäni, gäkŋa-tägän meka jinom unita yäŋpäŋ-näwoŋärek täk täyan unita nämo guŋ taŋpäŋ irepmit täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Yäke! Gäkŋo jukuman unita nadäwa gäripi pähap, inide kubä täk täkaŋ, imaka gakŋi nikek nakta gäripi nadäk täyat unitäŋo gäripi irepmitak. ");
INSERT INTO iou_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Burenitä bureni-inik, gäkŋo mantä nadäk-nadäk kädet säkgämän näwoŋärek täyak unita waki kädet kudupta taräki nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Ekäni, gäkŋo meka jinom u kädet kuŋat-kuŋatna täŋo topän ude täŋ namitak. Täŋkaŋ kädetnaken peŋyäŋeŋ namitak. ");
INSERT INTO iou_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Unita man kädetka siwoŋi u iwatta iŋamkaken yäŋkehäromtak man yäŋkuro udegän api täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Upäŋkaŋ Ekäni, bäräpi taŋitä näk nepmäŋitak unita gäkŋa yäŋkuno ude iritna äneŋi täŋ-kehäromtaŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Täŋpäkaŋ gupe käbäŋi nikek ude, ganiŋoret man pewa-ärek täkaŋ unita gäripi nadäŋ namisi. Ude nadäŋ namiŋkaŋ gäkŋaken manka u säkgämän näwetpäŋ näwoŋärek täk täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Näk kadäni kadäni kumäŋ-kumäŋ dubiniken it täyat upäŋkaŋ gäkŋo juku-manka unita nämo guŋtak täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Äma wakitä näk nepmäŋitta buŋep täk täkaŋ upäŋkaŋ näk gäkŋo man kädetka u peŋpäŋ näkŋaken gärip terak nämo iwat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Nämoinik, gäkŋo juku-mankatä bänep oretoret pewän ahäŋ namik täkaŋ. Unita iyap taŋpäŋ tärek-täreki nämo api iwat täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Täŋpäŋ gäkŋo man kädetka u iwatta nadäk kehäromi peyat. U iwat yäpmäŋ kuŋtäŋgän kaŋ kumba! ");
INSERT INTO iou_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Ekäni, äma gäk gäwaräntäkta bänep yarä pek täkaŋ unita gaŋani pähap nadäŋkaŋ gäkŋo juku-manka unitawä gäripi nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","U imata, gäk näkŋo kurepäna ba mobä käwutna, iwantä nutnayäŋ täŋirä käbop iretta. Täŋpäkaŋ man bian yäŋkuno u bureni iwatpäŋ api täŋpen yäŋ nadäkinik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Ai! Waki täŋpani in nabä kätäŋpeŋ kut! Näk Anutuna täŋo jukumani iwarayäŋ nadätat! ");
INSERT INTO iou_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Eruk Anutu, näkŋo iritna täŋ-kehäromtakta man kehäromi yäŋkuno u juku piŋpäŋ udegän kaŋ tä. Ude täŋiri uyaku näkŋo nadäkinikna kehäromigän itkaŋ baga manka pen täga api iwarän täwet. ");
INSERT INTO iou_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Unita mehamtäŋ namiŋiri bäräpi gänaŋ nämo api paoret. Ude täŋiri juku-manka wari wari api nadäŋ gamet. ");
INSERT INTO iou_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","O Ekäni, näk nadätat. Gäk ämawebe gäkŋo jukuman iwatta bitnäk täkaŋ unita mäde ut yämik täyan. Ude täŋiri täŋyäkŋarani täktäki kädet u jopi ude api täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Täŋpäŋ, gäk ämawebe udewani kudup jiraŋ ude bumik ureŋ täŋpi kuk täkaŋ. Täŋpäkaŋ nähä gäkŋo manta gäripi pähap nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","O Ekäni, gäkŋo täktäkka inipärik unita nadäwa umuri täŋpäpäŋ kujat kwaik täk täyat. Ba gäkŋo man kädetka unita nadäwa umuri täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","O Ekäni, näk kädet täga siwoŋi iwat täyat unita nabäŋ äwaräkuk täŋiri iwantä näk nämo täŋpä waneŋ! ");
INSERT INTO iou_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Ekäni, näk epän watä ämaka unita api täŋkentäŋ gamet yäŋ näwet. Täŋkentäŋ namiŋiri äma inita nadäwä ärowani täŋpanitä bäräpi namineŋtawä. ");
INSERT INTO iou_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Wära! Gäk bian täŋkentäŋ namikta siwoŋi näwetkuno ude täŋkentäŋ nami yäŋpäŋ dapun täŋ yäpmäŋ äbäŋira dapunna komi nekaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Unita Ekäni, butewakika paot-paori nämo unita nadäŋ namisi! Täŋkaŋ gäkŋaken juku-manka u näwetpäŋ näwoŋärek täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Näk epän watä ämaka itat unita gäkŋo meka jinom u nadäwa-tärekta nadäk-nadäk namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Ekäni, ämawebe gäkŋo baga man irepmit täkaŋ u yabätan? Eruk, gäk bäräŋeŋ akuŋpäŋ kowata yäwoŋäre! ");
INSERT INTO iou_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","128","Näk kädet wakiwaki äma udewanitä iwat täkaŋ unita taräki-inik nadäk täyat. U imata, gäkŋo juku-manka unita gäripi pähap nadäk täyat, ämatä gol moneŋ säkgämän-inik unita gäripi nadäk täkaŋ u irepmitpäŋ-nadäk täyat. Ba gäkŋo baga manka u kudup iwat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Ekäni, gäkŋo man uwä säkgämän unita buramiŋpäŋ kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Äma kubätä gäkŋo man bänepiken peŋpäŋ kuŋarayäŋ täko uwä bänepiken peŋyäŋek api irek. Ba guŋ äma kubätä gäkŋo man yäŋpäŋ-nadäk täŋpayäŋ täko uwä nadäk-nadäk ikek api kuŋarek. ");
INSERT INTO iou_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Täŋpäkaŋ Ekäni, näk gäkŋo baga manta gäripi-inik nadäk täyat. U iwatta mena bänepna pidämtak täkamän. ");
INSERT INTO iou_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Unita Ekäni, ämawebe nadäŋ gamikinik täŋpanita nadäŋ yämik täyan udegän, näk nabäŋpäŋ butewaki nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Täŋkaŋ gäkŋo mankatä kädet näwoŋäreŋirän momitä näka intäjukun nämo täŋ namek. ");
INSERT INTO iou_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Täŋpäkaŋ Ekäni, täŋkentäŋ namiŋiri ämatä näka täŋpäwak täneŋtawä. Ude täŋ namiŋiri manka kaŋ buramik täŋpa. ");
INSERT INTO iou_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Gäk dubinaken itkaŋ säkgämän täŋ namiŋpäŋ gäkŋaken kädet siwoŋika kudup kaŋ näwetpäŋ näwoŋäre. ");
INSERT INTO iou_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Täŋpäkaŋ Ekäni, ämawebe mäyaptä gäkŋo man nämo iwat täkaŋ unita konämna pito ume dapuriken äpäk täyak ude mak täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","O Ekäni, kudän siwoŋi säkgämän täŋo mähemi u gäk. Täŋpäkaŋ gäkŋo meka jinom kudup u udewanigän, siwoŋi säkgämän. ");
INSERT INTO iou_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Bureni, jukuman bian pewi ahäŋkuŋo u kudup siwoŋi tägagän, ämatä nadäŋpäŋ iyap taŋpäŋ yäpmäŋ kuŋatneŋtagän. ");
INSERT INTO iou_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Upäŋkaŋ iwanayetä baga manka u mäde ut imik täkaŋ unita bänepna kädäp ude ijik täyak. ");
INSERT INTO iou_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Ekäni, yäŋkehäromtak manka u pära nämo ahäk täyak. Burenigän ahäk täyak. Unita epän watä ämaka näkä manka unita gäripi-inik nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Täŋpäŋ ämatä näka nadäwä äpani, jiraŋ ude täk täkaŋ upäŋkaŋ meka jinomta nämo gaŋatak täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","U imata, kudän siwoŋi säkgämän säkgämän täk täyan u pen udegän api täŋ yäpmäŋ äroweno unita. Täŋpäkaŋ baga manka u burenigän ahäŋ yäpmäŋ kukta yäwani. ");
INSERT INTO iou_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Bureni, komi epän gänaŋ itat, upäŋkaŋ juku-manka unitä bänepna täŋpidäm taŋirän oretoret nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Täŋpäkaŋ baga manka uwä siwoŋi tärek-täreki nämo. Unita Ekäni, nadäk-nadäk namiŋiri säkgämän kaŋ it yäpmäŋ ärowa! ");
INSERT INTO iou_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Bänep nadäk-nadäkna kudup gäkken peŋpäŋ gera yäyat. Unita Ekäni, nadäŋ namiŋiri juku-manka kudup kaŋ buramiwa! ");
INSERT INTO iou_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Gäkken gera yäŋira wakiken nanik nämagut. Nämaguriri baga manka kudup u kaŋ iwara. ");
INSERT INTO iou_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Täŋpäŋ gäkŋo manka unitä bureni ahäwekta nadäkinik täyat unita kome ket nämo yäŋeŋirän akuŋpäŋ täŋkentäŋ namikta gäkken gera yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Täŋkaŋ gäkŋo manka yäŋpäŋ-nadäk täŋpayäŋ nadäŋpäŋ bipani käroŋ päke u kodakgän it täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Ekäni, ironka tärek-täreki nämo unita nadäŋ namisi. Täŋpäŋ butewakika kwawak näwoŋäreŋpäŋ iritna täŋ-kehäromtaŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Nadätan? Äma komi epän namik täkaŋ u dubinaken itkaŋ. Äma uwä gäkŋo jukuman iwatta bitnäk-inik täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Täŋpäkaŋ Ekäni, gäk imaka, näk dubinaken itgän täyan. Täŋpäŋ gäkŋo baga manka u kehäromigän pen itta yäŋkehärom täwani. ");
INSERT INTO iou_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Bian gäkŋo juku-mankata yäŋpäŋ-nadäk ŋode täŋkut; U tärek-täreki nämo itta pewi ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Ekäni, näk gäkŋo juku-mankata nadäŋ äwaräkuk nämo täk täyat unita komi bäräpi gänaŋ itat ŋo nabäŋpäŋ-nadäŋkaŋ täŋkentäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Bian yäŋkehärom taŋkuno ude iwanaye iŋamiken näk gärak itpäŋ täŋkentäŋ namiŋiri iwan nabä-kätäŋpeŋ kut. ");
INSERT INTO iou_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Äma waki täŋpani u gäkŋo juku-manka nämo buramik täkaŋ unita gäkŋata biŋam täga nämo api yämaguren. ");
INSERT INTO iou_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Upäŋkaŋ Ekäni, nähä täŋkentäŋ nam! Butewakika u ärowani pätak unita yäŋkuno udegän wakiken nanik nämagut. ");
INSERT INTO iou_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Iwan mäyap näk täŋpäwakta it gwäjiŋ namikaŋ upäŋkaŋ gäkŋo man kädetka bureni u nämoinik irepmit täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Täŋ Isrel ämawebe ätu gäkŋo manta nadäŋ parit täk täkaŋ unita kokwawak nadäŋ yämik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Täŋpäkaŋ Ekäni, gäkŋo meka jinomta gäripi pähap nadäk täyat u nabäŋpäŋ-nadäsi. U nabäŋpäŋ-nadäŋkaŋ ironka tärek-täreki nämo unita iritna täŋ-kehäromtaŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Ekäni, baga manka u burenigän ahäŋ yäpmäŋ kukta yäwani. Manka siwoŋi u kudup tärek-täreki nämo. ");
INSERT INTO iou_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","O Ekäni, äma wäpi ärowani nikek ätu jop nadäŋ näk täŋpäwak täkaŋ upäŋkaŋ näk juku-manka unita nadäwa umuri täŋpäpäŋ oraŋ imik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Täŋpäŋ kudän tägatäga täkta yäŋkehärom taŋkuno unita nadäŋkaŋ oretoret pähap nadäk täyat. Äma kubätä moneŋ taŋi mämäram yäpmäŋkaŋ oretoret nadäweko ude nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Täŋpäkaŋ jop-manmanta taräki-inik nadäŋkaŋ gäkŋo man kädetkata gäripi-inik nadätat. ");
INSERT INTO iou_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Unita kepma kubä gänaŋ kadäni 7 ude baga manka siwoŋi unita yäŋpäŋ ganiŋoret täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Burenitä bureni-inik! Ämawebe gäkŋo manta gäripi nadäŋpäŋ iwat täkaŋ unitawä watä it yämiŋiri bänep kwini terakgän it täkaŋ imaka kubä täŋpewän bänep nadäk-nadäki täga nämo putärewek. ");
INSERT INTO iou_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Unita Ekäni, gäk kubä-tägän wakiken nanik nämagutta itsämäŋtat. Itsämäŋkaŋ gäkŋo baga manka u iwaräntäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Täŋpäkaŋ äneŋi ŋode yäkgän täyat; Jukumanka unita gäripi-inik nadäŋpäŋ iwat-inik täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Bureni, gäk näkŋo irit kuŋat-kuŋatna u kudup nabäŋpäŋ-nadäwi-tärek täkaŋ unita meka jinom kudup buramik täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Ekäni, gäkken gera yäyat ŋo nadäŋ namisi. Nadäŋ namiŋpäŋ bian yäŋkuno udegän nadäk-nadäk täga näwetpäŋ näwoŋärek täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Yäŋapik manna ŋo iŋamkaken äreŋirän yäŋkehäromtak manka u iwatpäŋ wakiken nanik nämagusi. ");
INSERT INTO iou_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ude täŋiri menatä gäk ganiŋoret täyiwa! Imata, gäk juku-manka kudup u säkgämän näwetpäŋ näwoŋärek täk täyan unita yäŋpäŋ. ");
INSERT INTO iou_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Mena täŋpidäm taŋiri gäkŋo manka kädet unita nadäŋpäŋ kap ganiŋ ubiŋpäŋ teŋtäŋ kuŋat täyiwa, manka kudup u säkgämän siwoŋigän unita. ");
INSERT INTO iou_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Näk gäkŋo man kädetka bureni iwatta yäŋkehärom taŋkuro unita täŋkentäŋ namikta pidämtak täyi. ");
INSERT INTO iou_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O Ekäni, gäkä täŋkentäŋ namikta dapun käroŋ täŋ itat ŋo. Ba gäkŋo manta bänep täga pähap nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Unita Ekäni, iritna täŋ-mehamtaŋ namiŋiri wäpka biŋam oraŋ gamik täyiwa. Ude täŋira manka kuduptä täŋ-mehamtaŋ namik täyon. ");
INSERT INTO iou_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Näk yawak ägwän taŋpeŋ kwani udewani unita gäk epän watä ämaka näka wäyäkŋeŋpäŋ nabäŋ ahäsi. Imata, näk gäkŋo juku-manka iwatta epäni kehäromi täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Bian, komi butewaki terak itkaŋ Ekäni, gäkken yäŋapiŋira nadäŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Unita apiŋo udegän jop manman yäwani ba täŋyäkŋarani äma bämopiken nanik nämagusi! ");
INSERT INTO iou_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Ai, jop manman yäwani in, Anututä jide api täŋ tamek? Ba komi epän jidewani upäŋ api tamek? ");
INSERT INTO iou_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Komi epän ŋodewanipäŋ api tamek; Komi äma täŋo päip bohamtä api tapmaŋpek. Ba kädäp mebetpäŋ intä terak api piŋ täbarek. ");
INSERT INTO iou_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Wära! Äma waki täŋpani, inta gaŋani pähap nadätat! In bämopjinken itkaŋ gaŋani nadätat u Mesek kome ba Keda ämawebe bämopiken itkaŋ nadäwero ude. ");
INSERT INTO iou_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Bänep kwini terak itta gäripi nämo nadäk täkaŋ u bämopiken kadäni käroŋi it yäpmäŋ äbut. Unita kaŋ pewa yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Imata, bänep kwini itta man yäŋira unitäwä ämik mangän yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Näk pom taŋi taŋi udu terak dapun käroŋ täŋ itat upäŋkaŋ täŋkentäkna dekaken naniktä äbäŋkaŋ täŋkentäŋ namayäŋ? ");
INSERT INTO iou_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Eruk näk nadätat, Ekäni kunum kenta kome täŋ-peŋkuko unitägän api täŋkentäŋ namek. ");
INSERT INTO iou_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Nadätan? Ekäni unitä gabäŋ äwaräkuk täŋirän nämo maŋgurek. Nämo, watä ämaka u däpmon nämo pat täyak. ");
INSERT INTO iou_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Bureni-inik, Isrel täŋo watä äma unitä kodakigän itpäŋ watä säkgämän it gamik täyak. ");
INSERT INTO iou_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","6","U dubikaken itkaŋ watä it gamiŋpäŋ äyuŋka ude it gamik täyak. Ude it gamiŋirän kepma edaptä täga nämo gurek ba bipani komepaktä gäk täga nämo täŋpän waneŋ. ");
INSERT INTO iou_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Täŋpäkaŋ Ekäni u gabäŋ gäwatkaŋ imaka umuri pähapken wädäŋ tädotpäŋ gepmaŋpän säkgämän api iren. ");
INSERT INTO iou_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Täŋpäŋ täha peŋpeŋ deken kwenopäŋ äneŋi tähaken äbeno uwä Ekänitä watä it gamiŋirän umun terak nämo api iren. Täŋpäkaŋ apiŋogän nämo gabäŋ gäwarek. Nämo, watä kadäni nämo, api it gamik täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekäni täŋo kudupi yotken ärona yäŋ näwerirä bumta oretkut! ");
INSERT INTO iou_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Eruk, ahäkamäŋ, Jerusalem täŋo yewa gänaŋ itkamäŋ ŋo. ");
INSERT INTO iou_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Täŋpäkaŋ Jerusalem u yotpärare tägagämän-inik. Täŋkodak taŋkuŋo unita kehäromigän, kaŋoret ikek itak. ");
INSERT INTO iou_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Uken Isrel ämawebe kuduptagän Anutu täŋo jukuman iwatpäŋ iniŋ oretta ärok täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ba uken Isrel täŋo intäjukun ämaniye itkaŋ ämawebeniye täŋo man epän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Unita Jerusalem komeken iranitä säkgämän irut yäŋpäŋ Ekäniken ŋode yäŋapitat; Ekäni, täŋkentäŋ yämiŋiri ämawebe Jerusalem yotpärareta gäripi nadäk täkaŋ u tägagän kaŋ irut! ");
INSERT INTO iou_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ude yäŋapiŋira Jerusalem ämawebetä kwini terak irirä watä ämaniye imaka, säkgämän kaŋ irut. ");
INSERT INTO iou_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Täŋpäkaŋ mähemnayeta yäŋpäŋ äneŋi ŋode yäkgän täŋpa; Jerusalem ämawebe säkgämän, kwini terak it täkot! ");
INSERT INTO iou_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Ba Ekäni Anutunin täŋo kudupi yotta yäŋpäŋ ŋode yäyat; Tägagän it täyon. ");
INSERT INTO iou_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekäni, ijiŋpewa kunum gäkä itkaŋ kaŋiwat epän täk täyanken ärotak. ");
INSERT INTO iou_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Täŋpäkaŋ Ekäni Anutunin, watä epän äma jopitä epän mähemi terak it täkaŋ, ba watä epän webetä intäjukun webeni täŋo kehäromi terak it täkaŋ, nin udegän gäkagän dapun käroŋ pen api täŋ yäpmäŋ kune. Ude täŋ yäpmäŋ kuŋtäkäna, eruk butewaki api nadäŋ nimen. ");
INSERT INTO iou_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Unita Ekäni, butewaki bäräŋeŋ nadäŋ nimisi. Imata, äma wakitä waki täŋ nimik täkaŋ unita gaŋani nadäkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ba tuŋum ämatä yäŋärok bumta niwet yäpmäŋ äbäŋirä äneŋi udegän nadäkta nämo nikaŋ. Ba äma gup yäpmäŋ ärokärok täŋpanitä komi epän nimiŋpäŋ sära niwet yäpmäŋ äbäŋirä gaŋani nadäkamäŋ. Unita Ekäni, butewaki nadäŋ nimiŋpäŋ täŋkentäŋ nimisi. ");
INSERT INTO iou_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekänitä nämo täŋkentäŋ nimiŋkuk yäwänä jide tänam? Isrel ämawebe, in yäŋyabäk ŋonikta kowata yäwut! ");
INSERT INTO iou_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","Bian ämatä kokwawak nadäŋ nimiŋpäŋ ninkät ämik täŋkuŋ. Täŋkuŋopäŋ Ekänitä nämo täŋkentäŋ nimiŋkuk yäwänä iwantä kudup nidäpäm. ");
INSERT INTO iou_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","5","Umetä tokätpäŋ nidäpmäŋpäŋ yejämäk täkaŋ ude tänaŋipäŋ nämo täŋkuk! ");
INSERT INTO iou_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Unita nin Ekänita bänep täga nadäŋpäŋ iniŋoret täkäna! Täŋpäkaŋ iwan yabäŋ äwaräkuk täŋirän nämo nidäpuŋ. ");
INSERT INTO iou_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Ämatä buŋep täŋpäkaŋ barak yepmäŋiräkaŋ ehutpäŋ buŋep därämutpeŋ kuk täkaŋ nin udegän täŋkumäŋ. Buŋep uwä däkŋeŋkuk. Täŋpäkaŋ ninä apiŋo buŋep terak nämo itkamäŋ. ");
INSERT INTO iou_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Ekäni, kunum kenta kome pewän ahäŋkuŋo uniktä ini-tägän täŋkentäŋ nimik täyak! ");
INSERT INTO iou_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ämawebe Ekäni terakgän yeŋgämä pek täkaŋ uwä Saion pomtä kehäromi-inik it täyak ude bumik it täkaŋ. Bäräpi mebäri mebäri ahäŋirä kwaiŋpäŋ täga nämo tokät maneŋ. ");
INSERT INTO iou_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Täŋpäkaŋ pomtä Jerusalem yotpärare it gwäjikaŋ ude, Ekänitä ämawebeniyeta tärek-täreki nämo ude yewa täŋpäŋ täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Näk ŋode nadätat; Waki täŋpanitä siwoŋi ämawebe täŋo komeken watä wari nämo api itneŋ. Ude tänayäŋ täŋo uwä kämiwä siwoŋi ämawebe ini imaka, käderi waki iwatpäŋ waki täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Unita Ekäni, äma täga, gäkŋo man buramik täk täkaŋ unita säkgämän täŋ yämisi. ");
INSERT INTO iou_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Täŋpäkaŋ waki täŋpanita kowata komi yämiŋpäŋä äma ätu gäkŋo äbot täŋpanipäŋ gabä-kätäŋpäŋ mäde ut gamik täkaŋ u imaka, kowata komi yämisi. Eruk, Isrel ämawebe säkgämän kaŋ irut! ");
INSERT INTO iou_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekänitä komi epänken nanikpäŋ yäŋnikŋat yäpmäŋ Jerusalem yotpärareken äneŋi äbäŋirän ayäbu täkamäŋ yäŋ nadäŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Äneŋi abäŋkaŋ gäripi nadäŋpäŋ mägayäk oretoret kap teŋkumäŋ. Täŋitna ämawebe Anututa nämo nadäŋ imanitä nibäŋpäŋ yäŋkuŋ; Ekäninitä Isrel ämawebeta täŋkentäk taŋi täŋ yämitak yäŋ yäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Bureni, Ekäni uwä täŋkentäk pähap täŋ nimiŋkuko unita bänep täga nadäŋ imiŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Unita Ekäni, gäkä bian ude täŋ nimiŋkuno udegän komeninken äneŋi kaŋ yäŋnikŋat yäpmäŋ ku! Ude täŋpayäŋ täyan uwä ŋode bumik; Kome kawukiken ume kubat kawuk tak-inik täŋpanipäŋ yäŋpewi iwän taŋirän kubat kawuk täwani u ume äneŋi äpäk täkaŋ ude bumik. ");
INSERT INTO iou_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Unita nadäkamäŋ; Äma kubätä apiŋo konäm butewaki terak ketem yeri piweko upäŋkaŋ oretoret terak ketem bureni ahäŋirän pugerek. ");
INSERT INTO iou_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Bureni, webe kubätä nadäwätäk terak yänat täŋpeko upäŋkaŋ bureni ahäŋirän kap teŋpäŋ oretoret terak ketem uwä eŋiken yäpmäŋ äbek. ");
INSERT INTO iou_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Äma kubätä eŋi kubä täŋpayäŋ nadäŋpäŋä Ekänita nämo nadäŋpäŋ täŋpayäŋ täko uwä täŋpän Anutu iŋamiken jopi api täŋpek. Ba udegän, ämatä Ekäni täŋo nadäk-nadäki terak äboriyeta watä nämo itnayäŋ täŋo uwä äma unitäŋo watä epän u jopigän api täŋpek. ");
INSERT INTO iou_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Ba udegän, gäk kome ket nämo yäŋeŋirän akumaŋ päŋku epän täŋ dämiŋ yäpmäŋ kuŋiri kome bipek. Ude täŋpayäŋ täno upäŋkaŋ Ekäni nämo nadäŋ imiŋkaŋ jop täŋpayäŋ täno uwä epän u Anutu iŋamiken jopi api täŋpek. Unita nadäkaŋ? Ekänitä ini ämawebeniye bureni uwä yabäŋ yäwatpäŋ imaka imaka täŋkentäŋ yämiŋirän bipani säkgämän pat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Täŋpäkaŋ nanak bäyak täkaŋ uwä Ekäni täŋo iron. Ba nanakjiye uwä Anutu täŋo kon pähap. ");
INSERT INTO iou_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","E, äma gubaŋi itkaŋ nanakiye mäyap bäyak täkaŋ uwä äma unitäŋo kehäromi. Iroŋiroŋi uwä tägaŋpäŋ watä säkgämän api it imineŋ. ");
INSERT INTO iou_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Bureni, äma udewani uwä oretoret pähap terak it täkaŋ. Täŋpäkaŋ iwaniyetä man epänken yepmaŋirä kehärom taŋpäŋ täga yärepmitneŋ. ");
INSERT INTO iou_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ämawebe Ekäni täŋo man buramiŋpäŋ nadäkinik täŋpeŋ kuŋat täkaŋ äma udewani uwä Ekäni täŋo oretoret terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Gäk äma udewanitä epän täŋiri bureni ahäŋ gaminayäŋ täkaŋ uwä iritka säkgämän api meham täwek. ");
INSERT INTO iou_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Yen tägatä mujipi bumta pewän wädäk täkaŋ ude webekatä nanak mäyap api bäyaŋ gamek. Ba nanakayetä gewet gukŋitä it gwäjik täkaŋ ude api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Bureni-inik, äma Ekäni täŋo mani buraminayäŋ täŋo uwä irit kuŋat-kuŋariken imaka tägatäga udewani api ahäŋ yämineŋ. ");
INSERT INTO iou_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Eruk, Ekäni Saion pom terak it täyak unitä iron täŋ tamiton. Ude täŋirän komejin Jerusalem uwä säkgämän kaŋ it yäpmäŋ ärowän. ");
INSERT INTO iou_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Ba in kadäni käroŋi säkgämän itkaŋ orajiye ahäŋirä kaŋ yabäwut. Unita Isrel ämawebe inä bänep kwini terakgän kaŋ it yäpmäŋ ärowut. ");
INSERT INTO iou_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Isrel, gäk äbot yäput peŋpäŋ ahäŋkunken iwankayetä komi gamiŋ yäpmäŋ äbuŋo unitäŋo manbiŋam ŋode yäŋahä; ");
INSERT INTO iou_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Äbot täpuri ude it yäpmäŋ äbäŋira iwanayetä komi epän jop nadäŋ namiŋkuŋ. Upäŋkaŋ nämo närepmitkuŋ! ");
INSERT INTO iou_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","U pärip-päriptä mädenaken nutpäŋ nepmaŋpä gupna terak bäräm bäräm bumta patkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Ude täŋ namiŋkuŋo upäŋkaŋ Ekäni siwoŋi täktäk kädet mähemi unitä komi epän uken nanik nämagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Unita Saion kometa kokwawak nadäk täkaŋ uwä Ekänitä kaŋ däpmäŋ yäwat kirewän! ");
INSERT INTO iou_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","U muyeŋ kome kawukiken ahäŋkaŋ kawuk taŋpäŋ paot täkaŋ ude kaŋ äworewut. ");
INSERT INTO iou_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","U epäni nämo, jiraŋ ude. Unita ini kubäkubä jop kaŋ parawut. ");
INSERT INTO iou_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Täŋirä ämatä yärepmit kuŋ äbäk täŋkaŋ yabäŋpäŋ kubätä ŋode nämo api yäwek; Ekäni wäpi terak kwikinik irirä Ekänitä iron täŋ tamiton yäŋ nämo api yäwetneŋ. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekäni, näk bäräpi pähap nadäŋpäŋ täŋkentäkta gäkken gera yäyat. ");
INSERT INTO iou_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","O Ekäni, gera yäŋira nadäŋ namiŋpäŋ täŋkentäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ekäni, gäk mominin terak nidäpmäk täŋpi yäwänä netä itek? Nin kudup paotnam. ");
INSERT INTO iou_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Upäŋkaŋ, gäk mominin peŋ nimik täyan unita gäkŋa gämotka-kengän kaŋ it täna. ");
INSERT INTO iou_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Näk Ekänitä täŋkentäŋ namän yäŋpäŋ kwikinik it täyat. Näk unitäŋo mantagän nadäkinik täyat. Unitägän bänepna täŋkentäŋ namik täyak. ");
INSERT INTO iou_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Äma epän kubä täŋpa yäŋpäŋ kome bäräŋeŋ yäŋewi täŋpayäŋ nadäk täkaŋ ude, näk Anutu bäräŋeŋ abä täŋkentäŋ namän yäŋpäŋ itsämäŋ itat. ");
INSERT INTO iou_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Unita Isrel ämawebe, nadäk-nadäknin Anutu-kengän kaŋ pena. Ekäni u iron tärek-täreki nämo täŋ nimik täyak ba waki keriken nanik nimagutta pidämtak täyak. ");
INSERT INTO iou_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Täŋpäkaŋ mominin terak kumäk-kumäkta biŋam tänaŋipäŋ Anututä ämawebeniye nintäŋo mominin kudup peŋ moreŋpäŋ api nimagurek. ");
INSERT INTO iou_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. O Ekäni, näk gup yäpmäŋ ärokärok nämo täk täyat. Ba näkŋata nadäŋira ärowani nämo täk täyak. Nadäk-nadäkna ärowani nikek itta ba imaka näkä täga nämo nadäwa tärenaŋi unita nadäwätäk wakiinik nämo täk täyat. ");
INSERT INTO iou_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Ude nämo. Imaka jide pat namitak unita täga nadätat. Nanak pakitä miŋiye bakani terak nadäwätäkkät nämo, gup gapun gapun pat täkaŋ ude, bänepnaken ude nadätat. ");
INSERT INTO iou_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Unita Isrel ämawebe, tärek-täreki nämo Ekäni terakgän yeŋgämä pewäpäŋ it täkot! ");
INSERT INTO iou_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekäni, Devittä gäka yäŋpäŋ komi epän gänaŋ itkuko unita nämo guŋ täwen. ");
INSERT INTO iou_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Täŋkaŋ Isrel täŋo Anutu kehäromi gäka täŋ gamikta yäŋkehäromtak man yäŋkuko u imaka, juku piwen. ");
INSERT INTO iou_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","5","Devit uwä yäŋkehärom taŋpäŋ ŋode yäŋkuk; Näk eŋiken ba däpmon patpatken bäräŋeŋ nämo api kwet. Nämo, Ekäni, Isrel täŋo Anutu kehäromi unitä itta kome täŋ-kerutpäŋ peŋkaŋ uyaku eŋiken päŋku orek itpäŋ däpmon täga api päret. ");
INSERT INTO iou_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Eruk, Betlehem yotpärareken itkaŋ topmäk-topmäk täŋo kudupi gäpe u itak yäŋ manbiŋam nadäŋkumäŋ. Nadäŋkaŋ päŋku Ja komeken bureni kaŋ-ahäŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Kaŋ-ahäŋpäŋä yäŋkumäŋ; Ekäni täŋo eŋiken kuŋpäŋ ini irani gämoriken gwäjiŋ-äpmoŋ imina! ");
INSERT INTO iou_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Eruk Ekäni, kudupi yotka ŋoken tärek-täreki nämo itta äbi! Täŋpäŋ topmäk-topmäk täŋo gäpe, kehäromika täŋo wärani, ukät bok kaŋ äbi! ");
INSERT INTO iou_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Äbäŋiri bämop ämakayetä kudän siwoŋigän kaŋ täk täŋput. Ude täŋirä ämawebekayetä oretoret gera kaŋ yäk täŋput. ");
INSERT INTO iou_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Ekäni, gäk intäjukun äma itta iwoyäwani Devit u imaka kubä täŋ imikta yäŋkehäromtak man yäŋkun. Unita epän ämaka u mäde nämo ut imen. ");
INSERT INTO iou_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yäŋ-kehäromtak man iwetkuno u bureni-inik api täŋ gamet yäŋ yäŋkun. Gäk ŋode iwetkun; Gäkŋo yeriken nanik kubä gäkä kumäŋiri mädekaken intäjukun äma itkaŋ kaŋiwat epän täkta api iwoyäwet. ");
INSERT INTO iou_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Täŋpäkaŋ yerikaye unitä topmäk-topmäk kubägän inkät täŋkuro u mäde nämo ut imiŋpäŋ baga man yämayäŋ täyat u buramiŋpäŋ yäpmäŋ kuŋatnayäŋ täŋo uwä, unitäŋo yeritä yeri intäjukun äma itta ude api ahäŋ yäpmäŋ kuk täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Nadäkaŋ? Ekänitä Saion yotpärare inita biŋam iwoyäŋpäŋ ŋode yäŋkuk; ");
INSERT INTO iou_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Yotpärare ŋowä näkä tärek-täreki nämo itkaŋ kaŋiwat epän täkta gäripi nadätat. ");
INSERT INTO iou_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Saion yotpärare ŋoken itkaŋ unitäŋo ämawebeniye täŋ-bumbum terak api yepmäŋ towiwet. Täŋpäŋ äma jäwäri bämopiken it täkaŋ u imaka, ketem yepmäŋ towiŋira naŋpä tokŋewäpäŋ oretoret api täk täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ude täŋkaŋ bämop ämaniye täŋo epäni täŋ-mehamtaŋ yämiŋira ämawebeniyetä kaŋpäŋ nadäŋkaŋ kap teŋpäŋ oretoret gera mämä api täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Täŋpäkaŋ kome ŋoken Devit täŋo orani kubä intäjukun äma ärowani-inik ude api pewa ahäwek. Äma uwä näkŋa iwoyäwani. Kaŋiwat epän täŋpayäŋ täyak u täŋpewa tärek-täreki nämo pen inide api täŋ yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Täŋkaŋ iwaniye täŋpewa mäyäk taŋi nadäŋirä upäŋkaŋ kaŋiwat epän täŋpayäŋ täyak uwä wawaki nämo, säkgämän api it yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Anutu täŋo ämawebeniye bänep kubägän terak it täkaŋ uwä imaka säkgämän, gäripi nikek kubä. ");
INSERT INTO iou_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Bänep kubägän irit kädet u orip gakŋi säkgämän Anutu täŋo bämop äma Aron täŋo gwäkiken piŋ ibarirä iŋami dapunken yäwat imiŋ äpämaŋ kotäkiken äpuŋo udewani. ");
INSERT INTO iou_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Ba uwä guk näburum Hemon pom terak säkgämän mak täkaŋ u Saion pom terak mäneŋo ude. U imata, Saion pom uken Ekänitä irit paot-paori nämo täŋo ironi nimikta yäŋkehärom taŋkuko unita. ");
INSERT INTO iou_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Anutu iniŋ oretoret käbeyä yäput pekta kap ŋo tek täŋkuŋonik. Ekäni täŋo epän watä ämawebeniye in kudup äbut! Äbäŋpäŋ Ekäni u iniŋ orerut! Bureni, bipani Ekäni täŋo kudupi yotken epän täk täkaŋ in udegän kaŋ täk täŋput. ");
INSERT INTO iou_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Kudupi yot gänaŋ ketjin kewatpäŋ yäŋapik man yäŋpäŋ Ekäni iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Ude täŋirä Ekäni kunum kenta kome pewän ahäwani unitä Saion pom terak itkaŋ iron täŋ tamiton! ");
INSERT INTO iou_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Ekäni wäpi iniŋ orerut! Ekäni täŋo epän ämaniye, in wäpi biŋam yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","3","Täŋpäkaŋ ämawebe Ekäni täŋo kudupi yot unita watä it täkaŋ, in wäpi biŋam yäŋpäŋ iniŋ orerut. Imata, Ekäni uwä kädet tägatäga niwoŋärek täyak ba täktäki unita kap terak wäpi iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Bureni-inik! Ekänitä Jekop täŋo äboriye, Isrel ämawebe äbot nin, inita biŋam iwoyäŋpäŋ nipmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Unita näk nadätat; Ekäninin uwä ärowani pähap, imaka imaka komen ämawebetä yäniŋ oret täkaŋ ba unita umuntak täkaŋ u kudup yärepmit moretak. ");
INSERT INTO iou_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Ekänitä ini imaka kubä kunum gänaŋ ba kome terak, gwägu gänaŋ ba gwägu mebäriken ban umu täŋpayäŋ nadäŋpäŋä u bureni täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Ba nadäŋirän gubam gwägätpäŋ yäpä kwinirirän mänit pähap u gänaŋ naniktä äbäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Täŋpäkaŋ Isip komeken äma ba tom nanaki ämani intäjukun nanik kudup däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Täŋpäŋ Isip kome unitäŋo intäjukun äma ukät epän ämaniyeta komi yämikta Ekänitä kudän kudupi mebäri mebäri pewän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Eruk ude täŋkaŋ ämawebe komeni komeni täŋo intäjukun äma u kumäŋ-kumäŋ däpmäŋpäŋ ämawebeniye täŋo kehäromini yäpmäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amo kome täŋo intäjukun äma wäpi Sihon u ba Basan kome täŋo intäjukun äma wäpi Oki u imaka kumäŋ-kumäŋ däpuk. Täŋpäŋ udegän Kenan kome täŋo intäjukun ämaniye kudup däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Täŋkaŋ intäjukun äma unitäŋo kome yäpmäŋ daniŋpäŋ Isrel ämawebeniyeta yäniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Unita Ekäni, wäpka biŋamä pen api it yäpmäŋ ärowek. Äroŋirän ämawebe mäden ahäŋ yäpmäŋ kunayäŋ täkaŋ u gäkagän pen api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Ude täŋirä Ekäni gäkä ämawebekayeta butewaki nadäŋ yämiŋpäŋ watä säkgämän api it yämen. ");
INSERT INTO iou_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Täŋpäkaŋ in ket nadäwut; Anutu kome kukŋi käda naniktä yäniŋ oret täkaŋ uwä anutu jopigän, äma keritä siliwa ba goräpäŋ täŋpani. ");
INSERT INTO iou_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Uwä meni nikek upäŋkaŋ man täga nämo yäneŋ. Ba dapuri nikek upäŋkaŋ imaka imaka täga nämo yabäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Ba jukuni nikek upäŋkaŋ man täga nämo nadäneŋ. Ba tämanitä mänit täga nämo yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Täŋpäkaŋ äma yäwik udewani yäniŋ oret täkaŋ uwä ini yäwik udegän kaŋ äworewut! ");
INSERT INTO iou_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Eruk, Isrel täŋo oraniye in Ekäni wäpi punin unu pewut! Ba Anutu täŋo bämop äma in imaka, wäpi iniŋ orerut. ");
INSERT INTO iou_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Ba kudupi yot täŋo epän äma, in udegän, Ekäni wäpi yäpmäŋ akuwut! Täŋpäkaŋ ämawebe Anutu bureni iniŋoret täkaŋ, in kuduptagän Ekäni wäpi biŋam yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Täŋirä Jerusalem ämawebe, Ekänitä ini irit bägupken, Saion pom terak äroŋpäŋ iniŋ orerut. Imata, Anutu uwä ärowani-inik. Unita äneŋi yäwa, Ekäni wäpi iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Ekäni u täŋkentäk säkgämän täŋ nimik täyak unita bänep täga pähap nadäŋ imina! Imata, unitäŋo ironi u tärek-täreki nämo patkukotä pätak, api pat yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Anutu intäjukun-inik itak unita bänep täga nadäŋ imina! ");
INSERT INTO iou_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Ekäni ärowani intäjukun-inik itak u iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","U kubä-tägän kudän kudupi ini pärik kubä pewän ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","U iniken nadäk-nadäk terak kunum pewän ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Täŋkaŋ komewä ume taŋi pähap u bämopiken täŋpäŋ peŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Ude täŋkaŋ edap dapuri kenta komepak täŋpäŋ yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Edap dapuriwä kepmata watäni itta teŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Täŋ, komepak kenta gukä bipanita watä itta yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Ekäni unitä Isip nanik täŋo nanak ämani intäjukun ahäwani u däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Täŋkaŋ Isrel äbot Isip nanik yäŋ-yäkŋat yäpmäŋ äpämaŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Iniken kehäromi terak keritä ude uwä täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Täŋkaŋ Gwägu Gämäni bämopgän däpmäŋ täkŋeŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ude täŋkaŋ ämawebeniye bämop ugän yämagut yäpmäŋ kuŋpäŋ säkgämän yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Täŋpäkaŋ Isip nanik täŋo intäjukun äma ba komi ämaniye u täŋpewän ume gänaŋ äpmoŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Täŋkaŋ ämawebeniye kome kawukiken yäŋ-yäkŋat yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","U kome ätu täŋo intäjukun äma kehäromi kehäromi däpmäŋ moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Bureni, u intäjukun ämaniye wäpi biŋam ikek däpmäkgän täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amo nanik täŋo intäjukun äma wäpi Sihon u kumäŋ-kumäŋ utkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ba Basan nanik täŋo intäjukun äma wäpi Oki u kumäŋ-kumäŋ utkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ude täŋkaŋ komeni kujat u ämawebeniyeta yäniŋ kireŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Kome u Isrel ämawebe, epän ämaniye unita yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Täŋpäkaŋ iwantä ämikken nirepmirirä nibäŋ äwaräkuk nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Nämo, u iwan keri terak nanik nimagutkuk. ");
INSERT INTO iou_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ekäni uwä imaka irit ikek päke u kudupta ketem yepmäŋ towik täyak. ");
INSERT INTO iou_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Unita Kunum täŋo Anutu unita bänep täga man iwet täkäna! Imata, unitäŋo ironi u tärek-täreki nämo patkukonitä pätak, api pat yäpmäŋ ärowek. ");
INSERT INTO iou_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Babilon ume pomiken maŋitkaŋ komenin kujat Saionta juku piŋpäŋ konäm bumta kot täŋkumäŋonik. ");
INSERT INTO iou_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Päya ume pomiken itkuŋo u terak wagämnin wabiŋkaŋ äneŋi nämo utkumäŋ. ");
INSERT INTO iou_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Iwan nipmäŋitpäŋ komeniken yäŋnikŋat yäpmäŋ kuŋkuŋo unitä kap gäripi nikek teŋirä oretoret nadäna yäŋ niwet täŋkuŋ. Saion kome täŋo kap kubä teŋ nimut yäŋ niwet täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Upäŋkaŋ jide? Ban kome kubäken itkaŋ Ekäni täŋo kap kubä täga tene? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","O komenin Jerusalem, gäka juku pikamäŋ. Gäka guŋ tänero uwä ketnin gapun tawäpäŋ wagäm wari nämo api utne! ");
INSERT INTO iou_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Ba gäka nadäŋitna gäripi pähap nämo täŋpeko uwä kotäknin wawäkaŋ kap wari nämo yäŋpäŋ tene! ");
INSERT INTO iou_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Unita Ekäni, Idom naniktä Babilon äma täŋken täŋpäŋ päŋku Jerusalem täŋpä waŋkuŋo unita nämo guŋ täwen. Iwaniye unitä ŋode yäŋkuŋ; Yotpärare ŋo däpmäŋ äreyäŋ täna kut! Täŋitna mobä kubätä kubä terak itneŋtawä! ");
INSERT INTO iou_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Eruk Babilon nanik, in umuntäkot! In api waŋ moreneŋ. Bureni, äma kowata tamayäŋ täyak uwä äma täga, Ekäni täŋo oretoret terak api kuŋarek. ");
INSERT INTO iou_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Äma unitä intäŋo nanak paki yäpmäŋpäŋ mobä terak kaŋ däpmäŋtaräk tawän! ");
INSERT INTO iou_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Ekäni, gäk ganiŋ oretta bänepna kehäromi-inik peyat. Täŋpäŋ urak kome terak nanik u iŋamiken gäk ganiŋoret kap api tek täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Täŋkaŋ kudupi yotka itak käda iŋamna dapun ukäda ijiŋkaŋ api oraŋ gamet. Ekäni, gäk näka nadäŋ namik täyan unita, ba iron täŋ namik täyan unita bänep täga man api gäweret. Gäk wäpka biŋam ba mankatä intäjukun-inik it täyak. ");
INSERT INTO iou_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Täŋpäkaŋ kadäni kubä näkä yäŋapik man yäŋkuro u nadäŋ namiŋkun. Täŋpäŋ gäkŋaken kehäromika namiŋpäŋ bänepna täŋ-kehäromtaŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Ekäni, kome täŋo intäjukun äma kuduptagän gäkŋo manbiŋam nadäŋ moreŋkuŋ. Nadäŋ moreŋkuŋo unita wäpka biŋam kaŋ yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Gäkŋo täktäkka ba epmäget peŋyäŋek pähap unita kap teŋ gamik täkot. ");
INSERT INTO iou_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Ekäni gäk intäjukun ärowani it täyan unita ämawebe inita nadäwä äpani täk täkaŋ uwä yabäŋ yäwat täyan. Upäŋkaŋ ämawebe inita nadäwä ärowani täk täkaŋ unita mäde ut yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","O Ekäni, bäräpi mebäri mebäri ahäŋ namiŋirä watä it namik täyan. Täŋpäkaŋ iwantä kokwawak nadäŋ namiŋirä gäkä däpmäŋ yäwat kireŋpäŋ kehäromika terak nämagut täyan. ");
INSERT INTO iou_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Ekäni, gäk täŋkentäk epän bumta täŋ namik täyan. O Ekäni, ironka paot-paori nämo pätak. Unita gäkŋaken ketka kudän nin nämo nipmaŋpen. ");
INSERT INTO iou_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Ekäni, gäk näk ket-inik nabäŋpäŋ-nadäŋkaŋ mebärina kudup nadäwi tärek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Irit kuŋat-kuŋatnaken imaka imaka täk täyat u kudup nabäŋpäŋ-nadäk täyan. Banken itkaŋ näkŋo nadäk-nadäkna kudup kaŋpäŋ nadäwi tärekaŋ. ");
INSERT INTO iou_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Piä täk täyatken ba orek it täyatken kudup nabäŋpäŋ-nadäk täyan. ");
INSERT INTO iou_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Man jide yäwayäŋ nadäk täyatken gäkä jukun nabäŋpäŋ-nadäwikaŋ mäden yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Gäk intäjukun mäden it namiŋkaŋ ketkatä oraŋ namikinik täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Yäke! Gäkä näkŋo mebärina nadäwi tärek täkaŋ u äpmoŋpani-inik. Unita nadäwa ärowani inipärik kubä täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Unita Munapikka u peŋpäŋ deken päŋku käbop täga iret? Ba gabäŋ paot päŋku käbop deken täga iret? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Kunum gänaŋ ärowero uwä gäk u iren. Kumbanitä yotpärareken kwayäŋ täro uwä u imaka, iren. ");
INSERT INTO iou_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","10","Ba ban-inik, edap dapuritä itkaŋ abäk täyakken ukäda kwayäŋ täro uwä gäk näk yäŋ-nämagutta u itgän täŋpen. Ba edap dapuritä äpmoŋpäŋ it täyakken ukäda päŋku irayäŋ täro uwä gäk näk täŋkentäŋ namikta ukäda itgän täŋpen. ");
INSERT INTO iou_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","12","Täŋpäkaŋ bipmäŋ urani iwera käbop nepmaŋpek, ba peŋyäŋek iwera bipmäŋ urani äworeŋpäŋ uwäktäŋ nameko upäŋkaŋ gäkä bipmäŋ urani kaŋiri bipmäŋ urani bureni nämo täk täyak. Ba bipani uwä kaŋiri kepma ude täk täyak. Unita bipani kepma uwä gäkä kaŋiri kepmagän it täyak. ");
INSERT INTO iou_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","O Ekäni, meŋ koki gänaŋ gupna täŋo moräki moräki kudup täŋ moreŋkun. ");
INSERT INTO iou_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Gäk näk inide kubä käbop säkgämän-inik kubä täŋpäŋ nepmaŋkuno unita ganiŋ oretat. Bänepnatä bureni-inik ŋode nadätat; Imaka kudup u udegän kaŋkorek ikek täŋpäŋ peŋkun. ");
INSERT INTO iou_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Gäk nabäŋiri näk meŋ koki gänaŋ käbop kujatna tohatna nämo tänaŋipäŋ kwikinik yäpurärätpäŋ tägaŋ itkut. ");
INSERT INTO iou_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Näk nämo ahäŋira gäkä jukun nabäŋkun. Ba nämo ahäŋira kome terak jide api irero unitäŋo kadäni u kudup intäjukun tawaŋ peŋ namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Anutu, nadäk-nadäkka mäyap. Näk jide täŋpäŋ daniŋpäŋ nadäwa täreneŋ. Täga nämo! ");
INSERT INTO iou_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Näkä u daniwero uwä mobä jiraŋ irepmitneŋ, unita täga nämo daniwa täreneŋ! Täŋpäkaŋ däpmon terak nanik akuŋpäŋ gäkkät bok pen it täkamäk. ");
INSERT INTO iou_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Yäke! Anutu, gäk äma waki täŋpani däpmäŋ yäŋ nadätat! Täŋiri ämata komi jop nadäŋ yämik täkaŋ u nabä-kätäwut! ");
INSERT INTO iou_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Äma udewani gäka man waki yäk täkaŋ. Ba wäpka ganiŋ wärät täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Ekäni, äma gäka kokwawak nadäŋ gamik täkaŋ unita näk udegän kokwawak nadäŋ yämik täyat. Ba äma peŋawäk täŋ gamik täkaŋ unita taräki pähap nadäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Bänep nadäk-nadäkna ba gupna kuduptä äma udewanita gaŋani pähap nadäk täyat. U yabäŋira iwanaye bureni ude täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O Anutu, bänep nadäk-nadäkna ket täŋpäŋ yäpmäŋ daniŋpäŋ nadä. ");
INSERT INTO iou_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ude täŋkaŋ nadäk waki ätu näk gänaŋ itneŋta epän täŋpäŋ yabäŋ ahä. Täŋpäkaŋ irit kehäromi täŋo kädetken yäŋnäkŋat yäpmäŋ ku! ");
INSERT INTO iou_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","O Ekäni, äma waki ba äma komi komitä nutneŋta itkentäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Äma udewani waki täkta däpmonta nämo yek täkaŋ. Ba yäŋawät-awät kädet pewä ahäkta gäripigän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Meni jinom u päraŋi-inik, gämok komi täŋo meni bumik. Man yäkyäki u komigämän, gämok äma däpani udewani bumik. ");
INSERT INTO iou_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Unita Ekäni, äma wakitä nepmäŋitneŋta watä it namik täyi. Äma u näk täŋpäwakta nadäk tawaŋ pek täkaŋ unita itpipiŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Äma uwä inita nadäwä ärowani täŋpäpäŋ kädetnaken näka buŋep täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Täŋpäkaŋ Ekäni ŋode iwet täyat; Näkŋo Anutu uwä gäk kubägän. Unita Ekäni, täŋkentäkta butewaki gera yäyat ŋo nadäŋ namisi. ");
INSERT INTO iou_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Yawe Ekänina, itkentäkna bureni, gäkä ämikken watä kehäromi it namiŋkun. ");
INSERT INTO iou_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Unita Yawe, apiŋo äma waki u nämo nadäŋ yämen. Yabäŋ äwaräkuk täŋiri täŋpäwaki unitäŋo bureni nämo kaŋ-ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Ba yabäŋ äwaräkuk täŋiri iwanayetä ämikken närepmitpäŋ kehäromina yäpmäŋ äpneŋtawä. Nämo, täŋpewi täŋpäwaki näka täk täkaŋ u äyäŋutpäŋ ini terak kaŋ ärowän. ");
INSERT INTO iou_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Täŋkaŋ kädäp gäyek komigämän äma uterakgän kaŋ maŋpän! Täŋpäŋ ureŋ täŋpä awaŋ käroŋi gänaŋ, äneŋi nämo abäkta, kaŋ äpmoŋput. ");
INSERT INTO iou_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Ba äma jop manman terak äma manken yepmak täkaŋ unitä imaka bureni kubä kaŋ-ahäneŋtawä. Nämo, täŋpäwaktä äma komi komi uterak äroŋpäŋ kaŋ täŋpän wawut! ");
INSERT INTO iou_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Täŋpäkaŋ Yawe, äma jopi jäwäri itkentäŋpäŋ äma wakitä täŋyäkŋatneŋo udeta watä it yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Unita ämawebe siwoŋitä dubikaken itpäŋ wäpka bureni-inik api ganiŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","O Ekäni, täŋkentäkta gäkken gera yäyat ŋo nadäŋ namiŋpäŋ bäräŋeŋ täŋkentäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Täŋpäŋ yäŋapik manna ŋonita nadäŋiri gupe käbäŋi nikek gäkken ärowani ude täyon. Täŋkaŋ ketna kewatat ŋonita nadäŋiri gäk ganiŋ oretta bipani täŋo ärawa säkgämän ude täyon. ");
INSERT INTO iou_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Eruk Ekäni, man waki kubä yäwetta mena jinomta watä ket it namik täyi. ");
INSERT INTO iou_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Ba waki täkta gäripi nadäŋpäŋ äma waki täŋpanikät bok kuŋatneta baga peŋkireŋ namisi. Ude täŋiri udewani täŋo kap teŋ oretoret äŋnak-äŋnakken bok nämo api itne. ");
INSERT INTO iou_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Täŋpäkaŋ äma täga kubätä kädet siwoŋi näwoŋärekta nabäŋ yäŋpäŋ komi namiŋirän nadäŋira täga täŋpek. Upäŋkaŋ äma waki täŋpanitä naniŋ orerirä täga nämo nadäŋ yämet. Nämo, näk unitäŋo täktäki wakitä paorut yäŋpäŋ unita yäŋapik man yäk täyat. ");
INSERT INTO iou_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Täŋpäkaŋ kudän wakita kowatawä iwantä äma udewani täŋo intäjukun äma geŋiken ureŋ täŋpä kunayäŋ täkaŋken uken ämawebetä kaŋpäŋ näka ŋode api nadäneŋ; Unitäŋo meni jinom u bureni yäŋ api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Äma udewani kumäŋirä ämatä kädäp täpuri täpuri duŋ-jukut täkaŋ ude kujari awaŋ gägäniken ude api täŋirähutneŋ. ");
INSERT INTO iou_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Täŋpäkaŋ Yawe Ekänina, nähä dapunna gäkkengän api pewa äreneŋ. Iwanta käbop itta gäkken ärek täyat unita nabä-kätäŋiri nämo kumbet. ");
INSERT INTO iou_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Nämo, iwanayetä buŋep täŋ namik täkaŋ uterak ärowetta nepmäŋit näwasi. ");
INSERT INTO iou_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Ude täŋiri näk gupna koreŋ kuŋarira buŋepi terak äma waki unitä ini täga äroneŋ. ");
INSERT INTO iou_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Devit mobä käwut gänaŋ käbop itkaŋ Anutuken yäŋapiŋkuk. Näk butewaki terak Anutuken gera yäŋ itat ŋo. Täŋkentäŋ namän yäŋpäŋ gera yäŋ itat. ");
INSERT INTO iou_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Näk nadäwätäkna yäŋahäŋpäŋ iwet it täyat. ");
INSERT INTO iou_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Jide täŋpäŋ ŋoba ŋo täŋpet yäŋpäŋ peŋpeŋ kwayäŋ nadäŋira Anututä nadäwätäkna yäpmäŋ äpäŋpäŋ ude kaŋ tä yäŋ kädet täwit namik täyak. Wära, wära! Kädet kuŋat täyatken ämatä näk nepmäŋitta yen kädetken pek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Täŋirä näk dapun taŋpäŋ täŋkentäkna kubä nämo kaŋ-ahätat. Näkä säkgämän itta bägup kubä nämoinik itak. Ude irira äma kubätä butewaki nämo nadäŋ namitak. ");
INSERT INTO iou_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Täŋpäkaŋ Ekäni, gäkken täŋkentäkta gera ŋode yäyat; Gäk kubä-tägän watä it namik täyan. Gäripna kudup gäkä terakgän peyat. ");
INSERT INTO iou_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Unita gerana ŋo nadäŋpäŋ täŋkentäŋ nami. Näk kehäromina nämo. Äma näwat kirekaŋ u kehäromina kudup yäpmäŋ äpnayäŋ täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Näk bäräpiken itat ŋo täŋpidäm taŋ nami. Ude täŋ namiŋiri uyaku ämawebekayetä u kaŋpäŋ nadäŋpäŋ äbä irirä näk iŋamiken wäpka biŋam api ganiŋ oreret. ");
INSERT INTO iou_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Ekäni gäk yäŋapik geranata juku peŋpäŋ nadäŋ nami. Gäk iron mähemi, äma siwoŋi-inik unita butewaki nadäŋ nam. ");
INSERT INTO iou_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Täŋpäkaŋ Ekäni, epän ämaka näk, näkŋata nadäŋira momi äma täyat upäŋkaŋ manken nämo nepmaŋpen. Nadätan, kome ŋo terak dapunkaken äma siwoŋi-inik kubä nämo itak. ");
INSERT INTO iou_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Ekäni, iwanayetä näwat kireŋpäŋ näkŋo kehäromina yäpmäŋ äpäk-inik täkaŋ. Täŋpäkaŋ kome bipmäŋ uraniken nepmaŋpä äma bian kumbanitä pat täkaŋ ude pat täyat. ");
INSERT INTO iou_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Ude täŋpäŋ nadäk-nadäkna wakiinik täŋpäŋ umun terak itat. ");
INSERT INTO iou_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Täŋkaŋ, kadäni bian itkutken upäŋ nadätat. Imaka tägatäga täŋkuno ba imaka imaka pewi ahäŋkuŋo u juku piyat. ");
INSERT INTO iou_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Täŋpäŋ gäkken yäŋapik man yäŋira mäjonatä gäka gäripi pähap nadäk täyak, ämatä kotäki kawuk taŋirä ume nänayäŋ nadäk täkaŋ ude. ");
INSERT INTO iou_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Unita Ekäni, kehäromina paotak unita gäk nadäŋ nami. Nepmaŋpi kumäŋpäŋ äma kumbani nämo äworewet! ");
INSERT INTO iou_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Näk gäka nadäŋ gamikinik täk täyat unita tami tami ironka kädet näwetpäŋ näwoŋärek täyi. Täŋiri näk gäkkengän yäŋapik täyat unita kädet siwoŋigän näwoŋäreŋiri iwat täyiwa. ");
INSERT INTO iou_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Ekäni, näk gäkä watä it nam yäŋ yäŋpäŋ gäkken äretat unita iwan keriken itat ŋo nämagut. ");
INSERT INTO iou_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Gäk näkŋo Anutu unita gäkŋaken gärip iwaretta näwetpäŋ näwoŋärek täyi. Ude täŋiri gäkŋo Munapikkatä kädet bähatgän nämagut yäpmäŋ kukta gäripi pähap nadätat. ");
INSERT INTO iou_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Unita Ekäni, gäkŋa yäŋkuno ude äneŋi nämagut. Gäk Ekäni siwoŋi pähap unita bäräpi mebäri mebäri ahäŋ naminayäŋ täkaŋ u keriken nanik kaŋ nämagut. ");
INSERT INTO iou_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Näk gäkŋo epän ämaka unita ironka pähap terak iwanaye ba äma näk täŋpäwak täkaŋ u kudup kumäŋ-kumäŋ däpmäŋ. ");
INSERT INTO iou_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Ekäni u watä äma bureni unita iniŋoret man unitagän yäŋ imik täkäna! U ämik täkta täŋpäŋ-näwoŋärek täyak unita ämik gänaŋ pidämigän kuŋat täyat. ");
INSERT INTO iou_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","U watä it namiŋpäŋ iwan iŋamiken näk gärak it täyak. U wakiken nanik nämagutpäŋ äyuŋna ude it namik täyak. Unitägän watä it namikta nadäkinik täŋ imik täyat. U guŋ äbot, äbori äbori täŋo kehäromini yäpmäŋ äpäŋpäŋ gämotnaken yepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Täŋpäŋ Ekäni, imata gäk äma mewuni ninta nadäwi ärowani täk täkaŋ? Imata ämawebe watä säkgämän it nimik täyan? ");
INSERT INTO iou_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Nin kuduptagän u me woŋ udegän bumik, kadäni keräpi-inik itta yäwani. Ba kome terak itnayäŋ täkamäŋ uwä wärani edap ägoniken ahäŋpäŋ paot täkaŋ ude. ");
INSERT INTO iou_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Upäŋkaŋ Ekäni, kunum duŋ weŋpewi aŋeŋpeŋ kukŋi kukŋi kuŋirän kaŋ äpi. Täŋkaŋ pom jop tensumuriri gupe pähap bäräŋeŋ kaŋ äbän. ");
INSERT INTO iou_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Täŋpäŋ iwankaye yäwat kireŋpewi kuŋtäŋpä kukta äŋin gwäjik täkaŋ ude täŋpewi yäpä joŋani käroŋ ude äbäton. ");
INSERT INTO iou_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Ude täŋkaŋ punin unu naniktä näk nepmäŋitta kewatpäŋ ume gwägu käroŋiken nanik wädäŋpäŋ nepmaŋsi. Täŋpäŋ iwan kome kubäken nanik täŋo keriken nanik nämagusi. ");
INSERT INTO iou_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Äma uwä man bureni nämoinik yäk täkaŋ. Nämo, Anutu iŋamiken man bureni yäkamäŋ yäŋ yäŋkaŋ man jop manman yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Täŋpäkaŋ Anutu, näk wagäm utpäŋ kap kodaki terak api ganiŋoret täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","U imata, gäk intäjukun ämakaye ämikken täŋmeham taŋ yämiŋiri iwaniye yärepmit täkaŋ. Täŋkaŋ epän watä ämaka Devit näk iwan keriken nanik nämagut täyan. ");
INSERT INTO iou_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Unita apiŋo udegän täŋ namisi. Itpipiŋ namiŋiri iwanaye komi komitä nutneŋtawä. Täŋpäŋ iwan kome kubäken nanik täŋo keriken nanik nämagusi. Äma uwä man bureni nämoinik yäk täkaŋ. Nämo, Anutu iŋamiken man bureni yäkamäŋ yäŋ yäŋkaŋ man jop manman yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Eruk Anutu näkŋo gäripna ŋode yäŋahäwa; Nanakniye gubaŋiken kehäromigän, päya kehäromitä it täkaŋ ude it täkot. Täŋpäkaŋ äpetniye siwoŋi säkgämän, intäjukun äma täŋo eŋi bek säkgämän säkgämänpäŋ täŋpani ude it täkot. ");
INSERT INTO iou_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Täŋpäŋ ketem mebäri mebäri epäninken ahäŋ-bumbum täk täkot. Ba yawakniye yewa gänaŋ nanak bäyaŋ-wek bumta täk täkot. ");
INSERT INTO iou_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Täŋpäŋ bulimakau nanak bäyaŋ-wek täŋirä ätu täŋguräŋ taŋpäŋ nämo paotneŋ. Ba yotpärareken konäm butewaki kähän nämo ahäwek. ");
INSERT INTO iou_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Äma äbot, imaka udewani ahäŋ yämik täkaŋ uwä, Ekäni täŋo oretoret terak kuŋat täkaŋ. Bureni, ämawebe Anutunita Yawe yäŋ nadäŋ imik täkaŋ uwä oretoret bureni terak it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Anutu, intäjukun ämana, gäk wäpka pen api yäŋahäŋ yäpmäŋ äroŋ iret. ");
INSERT INTO iou_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Kepma kepma wäpka biŋam bänep täga terak api ganiŋoret täŋpet. Bänep täga terak pen ude api ganiŋoret yäpmäŋ ärok täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Ekäni uwä wäpi biŋam ikek unita wäpi biŋam pen ude iniŋoret täkäna! Wäpi biŋam ärowani pähap unita jide täŋpäŋ mebärini nadäna täreneŋ? Nämoinik! Nin täŋo nadäk-nadäknin uwä keräpigän. ");
INSERT INTO iou_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Upäŋkaŋ meŋ nantä iroŋiniye gäkŋo täktäkka yäŋahäŋpäŋ api yäwet täneŋ. Epän pähap täŋkuno unitäŋo manbiŋam api yäwet täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Bureni! Ämawebetä Anutu intäjukun äma kehäromi nikek ude itak yäŋ api yäŋahäk täneŋ. Täŋirä näk imaka, gäkŋo epän täga unitagän api nadäk täŋpet. ");
INSERT INTO iou_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Täŋpäkaŋ ämawebetä kehäromika terak epän täk täyan unitäŋo manbiŋam api yäneŋ. Ude täŋirä näkŋawä wäpka biŋam pähap u api yäŋahäwet. ");
INSERT INTO iou_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Unita gäkä kudän tägagämän, ba iron täk täyan unita kap terak api ganiŋ oretne. ");
INSERT INTO iou_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Kap ŋode api tene; Ekäni uwä ninta nadäkinik täŋ nimiŋpäŋ iron täŋ nimik täyak. Täŋkaŋ butewaki nadäŋ nimiŋpäŋ kokwawak bäräŋek nämo nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Ekäni uwä ämawebe kuduptagän säkgämän täŋ yämik täyak. Imaka kudup pewän ahäŋkuŋo unita nadäkinik täk täyak. Kap ude api tene. ");
INSERT INTO iou_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Ekäni, ämawebekaye nin kap u teŋitna imaka imaka kudup peŋkuno unitä nadäŋpäŋ wäpka biŋam api yäpmäŋ akuk täneŋ. Täŋpäkaŋ ämawebekayetä bänep täga man api gäwet täne. ");
INSERT INTO iou_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Täŋpäŋ kaŋiwat epänka biŋam ikek unitäŋo manbiŋam api yäŋahäne. Ba kehäromikata udegän api yäŋahäŋ yäpmäŋ kune. ");
INSERT INTO iou_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Ude täŋitna epän kehäromi nikek täk täyan unitäŋo manbiŋam ämawebe komeni komeni kuduptä kaŋ nadäwut! Kaŋiwat epänka täŋo peŋyäŋek epmäget ikek unita täŋguŋ täneŋtawä! ");
INSERT INTO iou_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Kaŋiwat epän täk täyan uwä nämoinik api paorek. Gäk kaŋiwat epän äma intäjukun tärek-tärekka nämo api it yämiŋ yäpmäŋ ärowen. Ekäni gäkŋo man uwä jopi nämo. Ba täktäkka kudup kudäri säkgämän. ");
INSERT INTO iou_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Äma bäräpi kaŋ-ahäk täkaŋ u täŋkentäŋ yämiŋit, äma kehäromini paorani täŋ-kehäromtaŋ yämiŋit täk täyan. ");
INSERT INTO iou_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Ekäni, imaka imaka irit ikek nakta yewäkaŋ gäkken gabäŋ tareŋirä ketem ini täga nänaŋi u yämik täyan. ");
INSERT INTO iou_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Täŋpäkaŋ ketem imaka yämi naŋpäŋ säkgämän it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Nadäkaŋ? Ekänitä imaka imaka siwoŋigän täk täyak. Imaka imaka peŋkuko u kudup ironi terakgän yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Ämawebe Anutuken bänep kubägän peŋpäŋ gera yäk täkaŋ unita nadäŋ yämiŋpäŋ dubiniken it yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Ba ämawebe oraŋ imik täkaŋ unitä imaka kubäta yäŋapik man yäŋirä yämik täyak. Ba gera kotäki nadäŋpäŋ imaka umuri gänaŋ nanik wädäŋ tädotpäŋ yepmak täyak. ");
INSERT INTO iou_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Täŋpäŋ ämawebe Anututa gäripi-inik nadäŋ imik täkaŋ unita watä säkgämän it yämik täyak. Upäŋkaŋ äma wakiwaki täŋpani kudup api däpek. ");
INSERT INTO iou_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Täŋpäkaŋ näk menatä Ekäni täŋo biŋami yäŋahäk täyiwa! Ba ämawebe komeni komeni kuduptagäntä wäpi kudupi tärek-täreki nämo u kaŋ yäŋahäŋ yäpmäŋ ärowut! ");
INSERT INTO iou_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Anutu wäpi iniŋ orerut! Täŋpäkaŋ näk imaka, bänepna gupna, nadäk-nadäkna kuduptä Anutu wäpi biŋam yäpmäŋ akusiwa! ");
INSERT INTO iou_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Kome terak irayäŋ täyat ude Anutuna täŋo wäpi biŋam kap terak api iniŋoret yäpmäŋ kwet. ");
INSERT INTO iou_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Ämawebe, in ŋode nadäwut; Kome täŋo intäjukun ämatä täŋkentäk bureni täga nämo tamek. Unita komen äma udewanita nadäkinik nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Nadäkaŋ? Komen ämatä kumäŋpäŋ kome äneŋi äworek täkaŋ. Kumäŋpäŋ imaka imaka api täŋpet yäŋ yäwani u täga nämo täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Upäŋkaŋ äma kubätä oranin Jekop täŋo Anutu kwasikotpäŋ kuŋarayäŋ täko uwä bänep oretoret terak irek. Äma udewani uwä Anututä ini täŋkentäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Anutu uwä kunum kenta kome, ba gwägu pähap ba imaka imaka itkaŋ u pewän ahäŋkuŋ. Ba imaka u ba u api täŋ tamet yäŋ yäk täyak u burenigän täŋ nimik täyak. ");
INSERT INTO iou_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Täŋpäŋ ämawebe iwan gämoriken it täkaŋ, u ba ketemta wäyäkŋek täkaŋ, u ba komi epän gänaŋ it täkaŋ uwä Ekänitä täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Täŋpäŋ ŋode imaka täk täyak; Äma dapuri tumbani yäpän tägaŋpewän äneŋi dapun ijik täkaŋ. Ba äma bäräpi kotak täkaŋ unitäŋo bäräpi ketäreŋ yämik täyak. Bureni! Ekäni uwä iniken äbot siwoŋita gäripi-inik nadäŋpäŋ täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Täŋpäŋ äma komeni nämo, webe kajat ba iroŋi kodäŋa unita butewaki nadäŋ yämiŋpäŋ watä säkgämän it yämik täyak. Upäŋkaŋ äma waki täŋpani unitäŋo kehäromini kumän yäpmäŋ äpäk täyak. ");
INSERT INTO iou_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Bureni! Ekäni uwä intäjukun-inik pen api it yäpmäŋ ärowek! Saion ämawebe, in ŋode nadäwut; Ekänijin uwä paot-paori nämo api irek. Unita Ekäni täŋo wäpi biŋam punin yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Ekäni iniŋ oretna! Anutunin kap terak iniŋ oreritna bänepninken oretoret ahäk täyak, ba wäpi yäpmäŋ akuŋitna tägak täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Nadäkaŋ? Ekänitä Jerusalem äneŋi täŋkodak taŋpäŋ ämawebeniye iwantä yämagut yäpmäŋ kwani äneŋi yämagut yäpmäŋ abätak. ");
INSERT INTO iou_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ämawebe nadäŋ bäräp terak irani u täŋpidäm taŋ yämiŋpäŋ jibi meni uwäktäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Täŋpäkaŋ guk päke u ini nadäŋkuko udegän ahäŋirä wäpi ini-ini yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Bureni, Ekäninin unitäŋo wäpi biŋam ärowani, ba kehäromini u taŋi. Täŋkaŋ nadäk-nadäki u käroŋi boham, nintä kaŋpäŋ nadäna tärenaŋi nämo. ");
INSERT INTO iou_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Uwä äma äpani jopi-inik u kehäromi yämiŋpäŋ täŋ-mehamtaŋ yämik täyak. Täŋkaŋ äma waki täŋo kehäromini yäyomägatpäŋ kome terak yeŋ täreŋ täŋpän kuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Unita bänep täga nadäŋpäŋ kap terak Ekäni wäpi iniŋ oretna! Wagäm utpäŋ Anutunin u iniŋ ubiŋ tena. ");
INSERT INTO iou_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Imata, u gubam täŋpewän ahäk täkaŋ. Täŋpäŋ kome towikta iwän yäŋpewän taŋirän pom terak muyeŋ mebäri mebäri ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Täŋkaŋ tomta ketem yepmäŋ towik täyak. Ba barak nanak imaka, kähän yäŋirä yepmäŋ towik täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Nadäkaŋ? Hos ba komi äma ba imaka kome täŋo kehäromi nikekta ämatä nadäŋirä ärowani täk täkaŋ udewanita Ekänitä oretoret nämo täk täyak. Nämoinik! ");
INSERT INTO iou_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Ämawebe Ekäni initagän umuntaŋpäŋ nadäŋ imikinik täk täkaŋ, ba bänep ironi terak yeŋgämä pewäpäŋ it täkaŋ unita oretoret täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Unita Jerusalem ämawebe, in Ekäni iniŋ orerut. Uwä Anutujin unita wäpi yäpmäŋ akuwut. ");
INSERT INTO iou_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ekäni uwä yotpärarejin täŋo watä kehäromi itkaŋ iron pähap täŋ tamik täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ekäni uwä nadäŋ tamiŋirän in säkgämän, bänep kwini terak irirä Ekänitä epänjinken täŋpewän ketem ahäŋ-bumbum täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Täŋpäkaŋ Ekäni unitägän kome pähap päke ŋonitäŋo mähemi itak unita man yäŋirän kometä mani buramik täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Man yäŋirän gubam gwägärirän iwän mänit täk täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Peŋ iwerirän kome mäniri-inik täŋpäpäŋ ämawebe bärom bumta täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Täŋpäkaŋ man äneŋi yäŋirän kome tägaŋpäŋ edap säkgämän ijik täyak. ");
INSERT INTO iou_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Eruk, Ekäni unitägän Isrel ämawebe not täŋ yämiŋpäŋ iniken kädet kuroŋ yäwoŋäreŋpäŋ baga mani yäwetpäŋ yäwoŋäreŋkuk. ");
INSERT INTO iou_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Täŋpäkaŋ äma äbot ätuta nämo, Isrel ämawebe intagän man käderi täwoŋäreŋkuk, äma ätu uwä guŋ itkaŋ. Unita Ekäni iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Ekäni wäpi yäpmäŋ akuwut! Kunum gänaŋ nanik in kuduptagän Ekäni wäpi yäpmäŋ akuwut. ");
INSERT INTO iou_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Aŋero äboriye in kuduptagän Ekäni iniŋ orerut. Ba kunum gänaŋ nanik ämik ämaniye in imaka, Ekäni iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Edap dapuri kenta komepak ek imaka Ekäni wäpi iniŋ orerun! Ba guk taŋi ijiŋ-yäŋek täkaŋ in kudup Ekäni iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Kunum ban-inik unu gäk, ba ume gäk gänaŋ nanik, in Ekäni wäpi iniŋ orerut. ");
INSERT INTO iou_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Bureni! Ekänitä ini yäŋirän imaka imaka u ahäŋkuŋotä itkaŋ unita u kuduptagän Ekäni wäpi iniŋoret täkot. ");
INSERT INTO iou_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Ekänitä ini yäŋirän käderi peŋ yämiŋkuko u paot-paori nämo yäwat täkaŋ. Käderi u täga nämo yärepmitneŋ. ");
INSERT INTO iou_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Eruk, kome terak nanik in kuduptagän Ekäni iniŋ orerut. Ume tom taŋikät imaka imaka u gwägu mebäriken ban umu itkaŋ in, ");
INSERT INTO iou_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Ba yäpä iromäŋ, iwänkät mim, ba mänit taŋi in kudup Ekäni täŋo man buramik täkaŋ, wäpi biŋam iniŋ orerut. ");
INSERT INTO iou_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","10","Pom taŋi ba täpuri, päya piwani ba bipiken nanik, tom towiwani ba ägwäri, gämok, gejiraŋ ba barak, in kudup Ekäni wäpi yäpmäŋ akuwut. ");
INSERT INTO iou_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Täŋpäkaŋ komeni komeni täŋo intäjukun ämakät ämawebejiye, gapman ba äma wäpi nikek, in imaka, Ekäni iniŋ orerut. ");
INSERT INTO iou_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Ba ämawebe gubaŋi, ämawebe ekäni, ba iroŋiroŋi, in kuduptagän Ekäni wäpi biŋam yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Bureni-inik, in kudup Ekäni wäpi iniŋ orerut. Ekäni täŋo wäpi biŋamtä ämawebe täŋo wäp biŋam päke u kudup yärepmit morek täyak. Epmäget peŋyäŋek kudänitä imaka kome kenta kunum gänaŋ itkaŋ unitäŋo yärepmit morekinik täyak! ");
INSERT INTO iou_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Täŋpäkaŋ Ekäni u Isrel ämawebeta gäripi nadäŋ yämiŋpäŋ kehäromi yämiŋirän unita iniken kudupi ämawebeniye uwä Ekäni wäpi iniŋoret täkaŋ. Ekäni wäpi yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Ekäni wäpi yäpmäŋ akuwut! Ämawebeniye, in käbeyä täŋpäŋ iniŋoret kap kodaki kubä teŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Isrel ämawebe, Anututä gatäŋpäŋ tepmaŋkuko unita bänep täga nadäŋ imut! Jerusalem yotpärareken nanik inä intäjukun ämajin Ekäni unita oretoret täŋ imut! ");
INSERT INTO iou_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Täŋpäkaŋ in jop nämo itneŋ. Gukut tokätpäŋ wäpi yäpmäŋ akukta wagäm ba gita utpäŋ iniŋoret kap teŋ imut. ");
INSERT INTO iou_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","In nadäkaŋ? Ekänitä ämawebeniyeta nadäŋirän tägak täyak. Täŋpäkaŋ ämawebe inita nadäwä äpani täk täkaŋ u täŋkentäŋ yämik täyak. ");
INSERT INTO iou_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Unita ämawebe Ekäni iniŋoret täkaŋ in bänep oretoret täk täkot. Ba patpat bägupjinken udegän oretoret kap teŋ imik täkot. ");
INSERT INTO iou_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Täŋpäkaŋ ämik täŋo tuŋum iŋitpäŋ gera terak wäpi biŋam yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Ude täŋpäŋ iwanjiye täŋo momi kowata api däpmäŋ täreneŋ. ");
INSERT INTO iou_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Ba iwan täŋo ekäni ekäni ba intäjukun ämaniye yen kehäromipäŋ topmäŋpäŋ api yepmaneŋ. ");
INSERT INTO iou_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Ude täŋirä Anututä man bian yäŋkuko u iwanjiyeken bureni api ahäwek. Unita ämawebeniye, in Anutu iniŋ orerirä wäpi biŋam ärowani täk täyak. Eruk, Ekäni wäpi yäpmäŋ akuwut! ");
INSERT INTO iou_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Anutu wäpi yäpmäŋ akuwut! Kudupi yori gänaŋ wäpi yäpmäŋ akukot. Ba kehäromi pähap ikek kunum gänaŋ itak ununita iniŋ orerut! ");
INSERT INTO iou_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Epän taŋi täk täŋkuko unita oraŋ imina! U intäjukun äma pähap, wäpi biŋam ärowani nikek u iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Täŋpäŋ womat piäŋpäŋ uterak wäpi yäpmäŋ akuna! Ba gita utpäŋ uterak iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Täŋpäŋ wagäm utpäŋ kap teŋpäŋ gukut tokätpäŋ iniŋ oretna! Uhuwep piäŋkaŋ u kotäk terak wäpi yäpmäŋ akuna! ");
INSERT INTO iou_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Päräpäräp täŋpäŋ däpäyäk ärena kwäpäŋ Anutu iniŋ oretna! Täŋpäŋ päräpäräp däpäyäk mämä taŋigän täŋpäŋ Anutu kunum gänaŋ unu iniŋ oretna! ");
INSERT INTO iou_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Kome terak imaka imaka irit kuŋat-kuŋat ikek in kuduptagän Ekäni wäpi yäpmäŋ akuwut! Ekäni wäpi yäpmäŋ akuwut!");
INSERT INTO iou_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Man pätkaŋ ŋowä Jesu Kristo oraniye täŋo wäpi tawaŋ. Täŋpäŋ Jesu täŋo orani pähap u wäpi Abraham, bian-inik itkuko u. Täŋpäŋ Abraham täŋo yeri ahäŋ yäpmäŋ abäŋkä uterak orani kubä wäpi Devit ahäŋkuk. Täŋpäŋ Devit täŋo yeri ahäŋ yäpmäŋ abäŋkä u punin terak Jesu ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eruk Jesu täŋo oraniye tawaŋ ahäŋ yäpmäŋ äbuŋo unitäŋo manbiŋam u ŋode; Intäjukun-inik Abrahamtä nanaki Aisak bäyaŋkuk. Täŋpäŋ Aisaktä Jekop bäyaŋkuk. Jekoptä Judakät noriye ätu bäyaŋ yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judatä Peres-kät Sera bäyaŋkuk. Yarä unitäŋo miŋi wäpi Tama. Täŋpäŋ Perestä Esron bäyaŋkuk. Esrontä Ram bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramtä Aminadap bäyaŋkuk. Täŋpäŋ Aminadaptä Nason bäyaŋkuk. Nasontä Salmon bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmontä Boas bäyaŋkuk. Boas täŋo miŋi Rahap. Täŋpäŋ Boastä nanaki Obet bäyaŋkuk. Obet täŋo miŋi u Rut. Obettä Jesi bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesitä Devit bäyaŋkuk. Devit u Juda täŋo intäjukun äma itkuk. Täŋpäŋ Devit täŋo nanaki Solomon. Solomon u miŋi Devittä Uria webeni yomägatkuko unitä bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Täŋpäŋ Solomontä Rehoboam bäyaŋkuk. Rehoboamtä Abiya bäyaŋkuk. Abiyatä Asa bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Täŋpäŋ Asatä Jehosofat bäyaŋkuk. Jehosofattä Jehoram bäyaŋkuk. Jehoramtä Usia bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Täŋpäŋ Usiatä Jotam bäyaŋkuk. Jotamtä Ahas bäyaŋkuk. Ahastä Hesekia bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Täŋpäŋ Hesekiatä Manase bäyaŋkuk. Manasetä Emon bäyaŋkuk. Emontä Josaia bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Täŋpäŋ Josaiatä Jehokin-kät noriye bäyaŋ yepmaŋkuk. Uwä Babilon ämatä Juda ämawebe yämagut päŋku Babilon komeken yepmaŋpäŋ komi epänken yepmaŋkuŋo kadäni uken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Täŋpäŋ komi epänken pen irirä Jehokintä Sealtiel bäyaŋkuk. Sealtieltä Serubabel bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeltä Abiut bäyaŋkuk. Abiuttä Eliakim bäyaŋkuk. Eliakimtä Aso bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Täŋpäŋ Asotä Sadok bäyaŋkuk. Sadoktä Akim bäyaŋkuk. Akimtä Eliut bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuttä Eleasa bäyaŋkuk. Eleasatä Matan bäyaŋkuk. Matantä Jekop bäyaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekoptä Josep bäyaŋkuk. Josep uwä Maria Jesu bäyaŋkuko unitäŋo äpi. Täŋkaŋ Jesu uwä Kristo, Anutu täŋo iwoyäwani äma u. ");
INSERT INTO iou_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ŋode ahäŋ yäpmäŋ äbuŋ; Abrahamtä nanaki bäyawänä nanaki unitä nan täŋpäŋ nanak bäyaŋkuk. Pen udegän udegän täŋ yäpmäŋ abäŋtäko Devit ahäŋirän kadäni 14 ude täŋkuk. Täŋpäkaŋ Devittä nanaki bäyawänä nanaki unitä nan täŋpäŋ nanak bäyaŋkuk. Pen udetä udegän täŋ yäpmäŋ abäŋtäko kadäni Babilon komeken komi epän yämikta yämagut yäpmäŋ kuŋirä kadäni äneŋi 14 ude täŋkuk. Kadäni uken yäput peŋpäŋ nantä nanak bäyawänä nanaki unitä nan täŋkuk. Pen udetä udegän täŋ yäpmäŋ abäŋtäko kadäni äneŋi 14 ude täreŋirän Kristo, Anutu täŋo iwoyäwani ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu, Anutu täŋo iwoyäwani Kristo ahäŋkuko unitäŋo mebäri ŋode pätak; Miŋi Maria u Josepta biŋam iwoyäwäkaŋ inigän inigän kuŋarirän Munapiktä ini kudän täŋpewän Maria nanak kok irirän kaŋpäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ude ahäŋirän äpi Josep u äma siwoŋi kuŋatkuko unita webeni Maria nanak kok ikek irirän kaŋpäŋ kaŋ pewa yäŋkaŋ ŋode nadäŋkuk; Kwawak yäŋahäwapäŋ mäyäk nadäweko unita käbop kaŋ pewa yäk. ");
INSERT INTO iou_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep ude täŋpayäŋ nadäŋpäŋ kuŋarirän, Ekäni täŋo aŋero kubätä däpmonken ahäŋ imiŋpäŋ ŋode iwetkuk; Gäk Devit täŋo äbotken naniktä webeka Maria yäpmäkta nadäwätäk nämo täŋpen yäk. Nanak kok itak uwä Munapiktä ini kudän täŋpewän ahätak. ");
INSERT INTO iou_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nanak bäyawayäŋ täko uwä ämani api bäyawek. Bäyaŋirän wäpi Jesu yäŋ kaŋ iwet. Täŋpäkaŋ wäp Jesu u mebäri ŋode; Unitä iniken äboriye momi täŋo topmäk-topmäkken nanik ketäreŋpäŋ api yepmaŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Täŋkaŋ imaka kudup ahäŋkuŋo u Ekänitä nadäŋirän man profet biani kubätä ŋode yäŋkuko u bureni ahäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Webe gubaŋ, ämakät nämo pärani kubätä nanak kok itpäŋ bäyawayäŋ täko unitäŋo wäpi ‘Imanuel’ yäŋ api iwetneŋ. Täŋkaŋ wäpi ‘Imanuel’ unitäŋo mebäri uwä Anutu ninken itak. ");
INSERT INTO iou_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Täŋpäkaŋ Joseptä man u nadäŋpäŋ kikŋutpäŋ aku Anutu täŋo aŋerotä man iwetkuko u buramiŋpäŋ Maria webenita yäpuk. ");
INSERT INTO iou_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Webenita yäpukopäŋ bok nämo pat yäpmäŋ kuŋirän nanak u ahäŋkuk. Nanak u ahäŋirän Joseptä wäpi ‘Jesu’ yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Eruk Mariatä Jesu Judia kome, Betlehem yotpärare-ken bäyaŋkuk. Äma ekäni wäpi Herot Juda ämawebe yabäŋ yäwat täŋkuko kadäni ugän bäyaŋkuk. Bäyawänkaŋ ätu itpäŋ äma guk täŋo kuŋat-kuŋat yabäŋpäŋ-nadäwani ätu edap dapuri äbani käda naniktä Jerusalem äbuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Äbä ämawebe ŋode yäwet yabäŋkuŋ; Nanak paki Juda ämawebe yabäŋ yäwarayäŋ täyak u de? Nin komenin-ken udu itkaŋ nanak paki u ahäŋirän guk taŋi ahäŋkuko u kaŋpäŋ nadäŋpäŋ akumaŋ iwat yäpmäŋ äbäkamäŋ. Nanak paki u kaŋpäŋ iniŋ oretnayäŋ äbäkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ude yäŋirä Herottä nadäŋkaŋ kikŋutpäŋ nadäwätäk pähap täŋkuk. Ba Jerusalem nanik ämawebe kudup manbiŋam u nadäŋpäŋ-nadäwätäk udegän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herottä nadäwätäk täŋpäŋ Juda ämawebe täŋo bämop äma intäjukun täŋpani-kät Baga man yäwoŋärewani äma kumän-tagän yäŋ-päbä yepmaŋpäŋ yäwet yabäŋkuk; E, Anutu täŋo iwoyäwani Kristo yäŋ yäk täkaŋ u kome de ahäkta yäwani? ");
INSERT INTO iou_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ude yäwet yabäŋirän iwetkuŋ; U Judia kome Betlehem yotpärare-ken api ahäwek yäŋ yäk täkamäŋ yäk. Anututä Kristo uken api ahäwek yäŋ yäŋkuko u profet kubätä ŋode kudän täŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ai! Ämawebe Juda kome Betlehem yotpärare-ken nanik, in ŋode nämo nadäneŋ; Nin kome jopi-ken itkamäŋ. Bämopnin-ken äma ekäni kubä nämo itak, ba bian nämo itkuk yäŋ nämo nadäneŋ. Nämoinik! Inken intäjukun äma pähap kubä api ahäwek. Ahäŋpäŋ näkŋaken äbot, Isrel ämawebe u api yabäŋ yäwarek. ");
INSERT INTO iou_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Täŋpäŋ Herottä man u nadäŋpäŋ-nadäwätäk täŋpäŋ äma nadäk-nadäk ikek edap dapuri äbani käda äbuŋo ukeŋo yäŋ-päbä inigän yepmaŋpäŋ yäwetkuk; Guk taŋi kaŋkaŋ äbäkamäŋ yäŋ näwetkuŋo ukeŋo kadäni jidegän ahäŋirän kaŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ude yäwänä kowata iwerä nadäŋpäŋä jop ŋode yäwetpäŋ peŋ yäwetkuk; In päŋku ehutpäŋ yäŋ-wäyäkŋeŋpäŋ nanak paki u kaŋ-ahäŋpäŋä äneŋi päbä kaŋ näwerä nadäwa. Ude täŋpäkaŋ näk imaka, päŋku api iniŋ oreret yäk. ");
INSERT INTO iou_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ude yäweränkaŋ kuŋkuŋ. Kumaŋ päŋku guk taŋi ini komeken kaŋkuŋo u äneŋi kaŋkuŋ. Kaŋpäŋ oretoret pähap nadäŋkuŋ. Täŋpäkaŋ guk u intäjukun kuŋirän kaŋtäŋ iwatkuŋ. Kaŋtäŋ iwarirä guk uwä yot nanak yamiŋitä patkumäno u punin terak itkuk. ");
INSERT INTO iou_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Täŋpäkaŋ yot gänaŋ äroŋpäŋ Maria nanakikät irirän yabäŋpäŋ gukut imäpmok täŋpäŋ nanaki u iniŋ oretkuŋ. Ude täŋpäŋ tuŋum tägatäga, gol ba imaka käbäŋi tägatäga gwäki ärowani peŋpäŋ yäpmäŋ äbuŋo upäŋ peŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ude täŋkaŋ parirä Ekänitä däpmonken yäweränkaŋ yäŋewänä Herot irepmitpeŋ käbop kukŋi kädagän kumaŋ ini komeken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eruk äma nadäk-nadäk ikek ukeŋo äyäŋutpeŋ ini komeken kuŋirä Ekäni täŋo aŋero kubätä Josep däpmonken ahäŋ imiŋpäŋ iwetkuk; Josep, gäk ŋo irentawä. Akuŋkaŋ nanak yamiŋi yäŋ-yäkŋat yäpmäŋ metäŋpeŋ päŋku Isip komeken ahäŋpäŋ itkaŋ näkŋo manta juku päram kaŋ täŋpun yäk. Nadätan? Herottä nanak paki ŋo utta nadäŋkaŋ kädetta wäyäkŋetak. ");
INSERT INTO iou_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aŋerotä ude iweränä akuŋpäŋä nanak yamiŋi yäŋ-yäkŋat yäpmäŋ bipanigän Isip komeken metäŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Päŋku uken ittäŋ kuŋirän Herot kumbuk. Täŋpäkaŋ imaka ahäŋkuko unita profet kubätä bian, Anutu täŋo meni jinom yäpmäŋpäŋ ŋode kudän täŋkuk; Nanakna Isip komeken irirän gera yäŋira äneŋi äyäŋutpeŋ äbuk. Profettä man kudän täŋkuko u kämi ude bureni api ahäwek yäŋ nadäŋpäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Täŋpäkaŋ äma nadäk-nadäk ikek ukeŋo Herot täŋikŋatpeŋ kuŋirä nadäŋpäŋ kokwawak pähap nadäŋkuk. Kokwawak nadäŋkuko unita komi ämaniye peŋ yäwet-pewän Betlehem ba kome gägäni gägäni uken nanik nanak ämani obaŋ yarä nämo tärewani kudup kumäŋ-kumäŋ däpmäŋ moreŋkuŋ. Äma nadäk-nadäk ikek ukeŋonitä guk taŋi u kadäni uken ahäŋkuk yäŋ iwetkuŋo kadäni u nadäŋ iwatpäŋ nanak ämani obaŋ yarä nämo tärewani ugänpäŋ kumäŋ-kumäŋ däpuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herottä ude täŋkuko unita man profet Jeremaiatä ŋode kudän täŋkuko u bureni ahäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Betlehem dubini-ken Rama komeken Isrel webe kubätä konäm butewaki jägämi-inik yäŋirän nadäŋkuŋ. Nanakiye kumbuŋo unita konäm kähän yäŋirän iniŋ bitnäna yäŋkaŋ täŋpä waŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Täŋpäkaŋ Josep Isip komeken pen irirän Herottä kumbänä Ekäni täŋo aŋero kubätä däpmonken ahäŋ imiŋpäŋ iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Josep, äma nanak ŋo urayäŋ yäŋkuko ukeŋo kumbuk. Unita gäk akuŋkaŋ nanak yamiŋi ŋo yäŋ-yäkŋat yäpmäŋ Isrel komeken ku yäk. ");
INSERT INTO iou_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ude iweränä Josep iroŋi yamiŋi yämagurän yäpmäŋ Isrel komeken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Kuŋpäŋä nadäŋkuk; Herottä kumbänkaŋ nanaki wäpi Akelaustä Judia nanikta intäjukun täŋpäŋ itkuko unita Josep uken kwayäŋ umuntaŋkuk. Täŋpäŋ Anututä däpmonken jukuman ätukät iweränä kukŋi kädagän kumaŋ Galili komeken kuŋkaŋ Nasaret yotpärare-ken yot täŋpäŋ itkuŋ. Täŋpäŋ Jesuta profet ätutä bian yäŋkuŋo u bureni ahäŋkuk. Ŋode yäŋkuŋ; Äma ŋo Nasaret nanik yäŋ api iwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eruk kadäni uken ume ärut yämani äma wäpi Jontä kome jopi Judia täŋo kome bämopi-ken u päŋku itkuk. Itkaŋ manbiŋam yäŋahäk-ahäk epän täŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Täŋpäŋ manbiŋam ŋode yäŋahäk täŋkuk; Kadäni ŋo Anututä intäjukun itkaŋ yabäŋ yäwat epän bureni täŋ yämayäŋ täko u keräp täyak unita bänepjin sukureŋpäŋ kädet wakiwaki täk täkaŋ u kumän peŋ morewut! yäk. ");
INSERT INTO iou_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Täŋpäkaŋ bianä profet Aisaiatä Anutu meni-ken yäpmäŋpäŋ Jonta yäŋpäŋ man ŋode kudän täŋkuk; Äma kubätä kome jopi-ken päŋku itkaŋ gera ŋode yäŋ itak; Ekänitä äbäkta kädet täwirut! Irit kuŋat-kuŋatjin kaŋ täŋsiwoŋ tawut! Aisaiatä man ude kudän täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Täŋpäkaŋ Jon uwä tektawä but kubä wäpi kameri unitäŋo pujiŋipäŋ täŋpani upäŋ täŋkaŋä pioŋtawä but gupipäŋ täŋpani upäŋ yamäŋ täpäneŋpäŋ kuŋat täŋkukonik. Täŋkaŋ ketemtawä käpukbam-kät kähäräp umeni bipiken nanik ugänpäŋ nak täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ude täŋkaŋ manbiŋam u yäŋahäŋirän ämawebe Jerusalem yotpärare ba Judia kome ba Jodan ume kukŋi kukŋi uken naniktä bumta äbä ahäŋ imiŋpäŋ manbiŋam nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Manbiŋam nadäŋpäŋ wakini yäŋahäŋirä Jontä Jodan ume gänaŋ yäŋ-yäkŋat päpmo ärut yämik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ude täŋkaŋ Parisi äma ätu ba Satyusi äbotken nanik ätu Jontä ume ärut nimän yäŋkaŋ uken äbäŋirä yabäŋkuk. Yabäŋpäŋ Jontä yäwetkuk; Wa! In bänepjin nämo sukureŋkaŋ äbäkaŋ. In gämoktä äbotken nanik! Anututä intäŋo momita kokwawak nadäŋkaŋ tadäpayäŋ täko unita umuntaŋkaŋ gupjin-tägän äbäkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Inä bänepjin bureni-inik sukureŋpäŋ äma bänepi sukurewani täŋo kudän kaŋ pewä ahäwut! ");
INSERT INTO iou_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ŋode nämo nadäneŋ; Bänepnin täga. Nin oranin pähap Abrahamtä äbotken nanik unita Anututa biŋam itkamäŋ yäŋ nämo nadäneŋ. Nämo! Anututä Abraham täŋo äboriye ätu ahäwut yäŋ nadäŋpäŋä mobä jopi ŋopäŋ täga täŋpewän ahäneŋ! yäk. ");
INSERT INTO iou_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Upäŋkaŋ man ŋode nadäwut; Äma kubä päya mujipi pogopigän wädäwani madäkta pinigoŋ ket utak. Päya, mujipi pogopigän wädäk täkaŋ u kudup madäŋpäŋ ureŋ täŋpän kädäpta biŋam api kuneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Näkä ume ärut tamik täyat unitäŋo mebäri ŋode; In wakiwaki täk täkaŋ u kumän peŋ moreŋpäŋ bänepjin sukureŋpäŋ irit kuŋat-kuŋat siwoŋi täŋpeŋ kuŋatta ume ärut tamik täyat. Täŋpäkaŋ äma kubä wäpi biŋam ikek mäden näwatak. Unitäŋo kehärominitä näkŋo kehäromina irepmitak. Näk äpani-inik unita u dubini-ken näk itnaŋi nämo. Näk ume-inikpäŋ ärut tamitat. Upäŋkaŋ äma unitäwä Anutu täŋo Munapik ba kädäp mebetpäŋ bok api ärut tamek yäk. ");
INSERT INTO iou_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Äma ekäni uwä ämawebe yäpmäŋ danik epän täkta äbayäŋ täyak. Yäpmäŋ danik epän u man wärani ŋode bumik api täŋpek; Wit mujipi-kät gupi kubä-kengän itkaŋ u yäpmäŋ daniŋpäŋ mujipi bureni inita yot kubäken peŋkaŋä gupi kädäp kumäk-kumäki nämoken api ureŋ täŋpän äpmoneŋ yäk. Jontä man ude yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Täŋpäŋ Jontä ämawebe ume ärut yämiŋ irirän Jesu Jontä ärut namän yäŋkaŋ Galili komeken naniktä abämaŋ Jodan ume, Jontä itkuk-ken u äbuk. Äbäŋpäŋ Jon iwetkuk; Näka ume ärut nami yäk. ");
INSERT INTO iou_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ude yäwänä Jontä iwetkuk; Ude nämo! Gäkä näka uyaku täga ärut namen. Imata gäkä ärut nami yäŋ näwetan? ");
INSERT INTO iou_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yäwänä Jesutä iwetkuk; Bureni yäyan upäŋkaŋ apiŋo gäkä täga ärut namayäŋ. Nek Anututä nadäŋpäŋ kädet peŋkuko ugänpäŋ iwatde yäk. Ude iweränä Jontä mani buramiŋpäŋ ume ärut imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ärut imänkaŋ ume gänaŋ naniktä abä itpäŋ uterakgän kaŋkuk; Kunum aŋeŋirän Anutu täŋo Munapiktä känaräm ude äpäŋkaŋ gwäki terak maŋirayäŋ täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Täŋirän Anutu kunum gänaŋ gera kubä ŋode yäŋkuk; Ŋowä näkŋaken bänepna gämäni yäk. U kaŋpäŋ gäripi pähap nadäk täyat. Man ude yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jontä Jesu ume ärut imän täreŋirän Satantä Jesu täŋyabäkta Munapiktä yäŋikŋat yäpmäŋ kome jopi-ken päŋku teŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kome jopi-ken tewänkaŋ ketem kubä nämo naŋkaŋ kepma bipani 40 ude itkuk. Ketem kubä nämo naŋkaŋ it yäpmäŋ kuŋtäyon nakta wakiinik kubä iŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ude täŋirän Satantä ahäŋ imiŋpäŋä iwetkuk; Gäk Anutu täŋo nanak bureni-inik täŋpäwä mobä itkaŋ ŋo yäweri ketem äworewäkaŋ naŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yäwänä Jesutä iwetkuk; Ude nämo täŋpayäŋ. Anutu täŋo man kudän terak man ŋode pätak; Äma kubätä ketem-tagän täga nämo irek. Anutu täŋo man kumän nadäŋpäŋ bänepi-ken peŋpäŋ kuŋareko uyaku täga yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Ude yäwänä Satantä yäŋikŋat yäpmäŋ Jerusalem kuŋpäŋ kudupi yot medäp terak päro punin-inik unu teŋkaŋ iwetkuk; Anutu täŋo man ŋode kudän täwani; Anututä aŋeroniye watä it gamikta yepmaŋkuko unitä api oraŋpäŋ gepmaneŋ. Täŋpäkaŋ kuroŋka ba gukutka nämo api pimiŋ tädoren. Man ude pätak unita gäk Anutu täŋo nanak bureni-inik täŋpäwä man u nadäŋpäŋ punin ŋonitä komen umu tubäpe! yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ude iweränä Jesutä yäŋkuk; Näk ude nämo täŋpayäŋ. Anutu täŋo manbiŋam terak man kubä ŋode pätak; Gäk Ekäni Anutuka mebärika kwawak pewi ahäwut yäŋ jop nämo peŋ iweren yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yäwänä Satantä Jesu pom käroŋi kubäken yäŋikŋat yäpmäŋ päro itkaŋ komeni komeni äma äbori äbori u ba unitäŋo tuŋum pähap gäripi mebäri mebäri u iwoŋäreŋkaŋ ŋode iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Gäk gukut imäpmok täŋ namiŋpäŋ naniŋ oreriri imaka päke yabätan ŋowä täga ganiŋ kirewet yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ude iweränä Jesutä iwetkuk; Satan, gäk nabä kätäŋpeŋ ku! Anutu täŋo man ŋode kudän täwani; Ekäni Anutujin u kubägän iniŋ oretneŋ. Unitagän watä epän täŋ imineŋ. Man ude pätak. ");
INSERT INTO iou_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eruk Jesutä Satan ude iweränä teŋpeŋ kuŋirän Anutu täŋo aŋeroniyetä äbä täŋkentäŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Täŋpäkaŋ Jon komi yot gänaŋ tewä irirän Jesutä biŋam nadäŋpäŋ äyäŋutpeŋ Galili komeken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Päŋku ini yotpärare Nasaret u ittäŋgän eruk peŋpeŋ Kapeneam kuŋkuk. Kapeneam uwä Galili gwägu dubini-ken itkuk. Kome u Sebulun kenta Naptali äbekiye oraniye täŋo kome. Ukäda päŋku itkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesutä kome u kuŋatkuko unita bian profet Aisaiatä man ŋode kudän täŋkuko u bureni ahäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ai! In ämawebe Sebulun Naptalitä komeken nanik! Komejin Jodan ume udude käda Galili gwägu dubini-ken itak. Inä äma jopi, guŋ äbotken nanik. ");
INSERT INTO iou_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Upäŋkaŋ bipmäŋ urani-ken it täkaŋ u in peŋyäŋek pähap api käneŋ. Kumbani komeken bumik it täkaŋ, nadäk-nadäkjin nämo pirärewani, inta peŋyäŋek pähap kubä ahäŋ tamayäŋ täyak. Aisaiatä man ude kudän täŋkuko u bureni ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Täŋpäŋ Jesutä Kapeneam yotpärare-ken kuŋkuko kadäni uken manbiŋam yäŋahäk epän yäput peŋpäŋ ŋode yäŋahäŋpäŋ yäwetkuk; Bänepjin sukureŋpäŋ siwoŋigän kuŋarut. Anututä intäjukun itkaŋ äboriye yabäŋ yäwatinik täŋpayäŋ täyak u keräp täyak yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kepma kubäken Jesu Galili gwägu pomi terak kuŋattäŋgän yabäŋkuk; Äma yarä iniyat tuäni Saimon wäpi kubä Pita kenta monäni Andru gwägu tom yäpdayäŋ tom wädäwani yäk maŋpän äpmoŋirä yabäŋkuk. Äma yarä uwä moneŋ epänta gwägu tom yäpmäk täŋkumänonik. ");
INSERT INTO iou_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yäk maŋpän äpmoŋ irirän Jesutä yabäŋpäŋ yäwetkuk; Eruk! Epän u peŋkaŋ näk näwarun! Näk näwarirän gwägu tom yäpmäk täkamän udegän ämawebe Anutu iwatta yäpmäk-yäpmäk epän api tamet yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yäweränä uterakgän epäni u peŋpeŋ iwatkumän. ");
INSERT INTO iou_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eruk, ätukät kuŋpäŋä Sebedi nanakiyat wäpi Jems kenta Jon nani Sebedi-kät gäpe terak itkaŋ yäk taŋi gwägu tom yäpani u ket ut irirä yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yabäŋpäŋä näk näwarun yäŋ yäwerirän uterakgän nani gäpe terak ugän irirän teŋpeŋ Jesu iwatkumän. ");
INSERT INTO iou_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Täŋpäŋ Jesutä kome Galili dubini-ken itkuŋo u kudup kuŋat moreŋpäŋ ämawebe käyäm mebäri mebäri nikek yäpän tägaŋit, käbeyä yot gänaŋ äroŋpäŋ man yäwerit täŋ yäpmäŋ kuŋkuk. Manbiŋam Täga ŋode yäŋahäŋtäŋ kuŋatkuk; Anututä intäjukun itkaŋ äboriye yabäŋ yäwatinik täŋpayäŋ täyak u ahätak yäk. ");
INSERT INTO iou_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ude yäwerirän biŋami Siria komeken kuŋat moreŋirän nadäŋkuŋ. Nadäŋpäŋä ämawebe käyäm mebäri mebäri nikek, gup kähän nadäwani, äma mäjotä magärani, äma kwäyähäneŋ täŋpani, kumäŋ-däpurek täŋpani ba käyäm mebäri mebäri täŋpani u kudup noriyetä yäŋ-yäkŋat yäpmäŋ äbäŋirä Jesutä yäpän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Täŋpänkaŋ äma äbot pähap kome uken-uken naniktä iwarän täŋkuŋ. Ämawebe Galili komeken nanik, Dekapolis komeken nanik, Judia komeken nanik, ba Jodan ume pomi terak naniktä äbä Jesu iwarän täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Jesutä ämawebe äbot päke iwatkuŋo u yabäŋpäŋ pom keräpi kubä terak äro maŋitpäŋ irirän iwaräntäkiye uwä dubini-ken tuägän äbä iräwä Jesutä manbiŋam ŋode yäwetpäŋ yäwoŋärek täŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Äma ini bänepitä näk momi äma äpani-inik yäŋ nadäk täkaŋ uwä säkgämän itkaŋ. Bureni! Äma udewani uwä Anututä yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Täŋpäkaŋ äma iniken mominita nadäwä waki täŋpäpäŋ konäm butewaki terak kuŋat täkaŋ uwä säkgämän itkaŋ. Bureni! Anututä ini bänepi api täŋpidäm taŋ yämek. ");
INSERT INTO iou_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ba äma bänep kwini terak kuŋat täkaŋ uwä säkgämän itkaŋ. Bureni! Äma udewanita Anututä kome pähap ŋo inita biŋam api yäniŋ kirewek. ");
INSERT INTO iou_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Täŋpäŋ äma irit kuŋat-kuŋat siwoŋi u iwatta gäripi-inik nadäŋpäŋ ehutpäŋ täk täkaŋ uwä säkgämän itkaŋ. Bureni! Anututä äma udewani täŋo gäripini uwä api däpmäŋ täreŋ yämek. ");
INSERT INTO iou_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Täŋpäkaŋ äma noriyeta butewaki nadäŋ yämik täkaŋ uwä säkgämän itkaŋ. Bureni! Anututä äma udewanita butewaki udegän api nadäŋ yämek. ");
INSERT INTO iou_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ba äma bänep nadäk-nadäk imaka täga täktagän nadäŋpeŋ kuŋat täkaŋ uwä säkgämän itkaŋ. Bureni! Äma udewani uwä Anutu api kaŋ-ahäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Täŋpäŋ äma ämik ba duŋwekwek däpmäŋ täkŋek täkaŋ uwä säkgämän itkaŋ. Bureni! Anututä äma udewani Näkŋo iroŋinaye yäŋ api yäwerek. ");
INSERT INTO iou_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ba äma Anutu täŋo kädet siwoŋi iwarirä äma ätutä iwan täŋ yämik täkaŋ uwä säkgämän itkaŋ. Bureni! Äma udewani uwä Anututä yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Täŋpäkaŋ intä näk nadäŋ namikinik täŋirä ämawebetä man jop yäŋ-täkŋatpäŋ, man wakiwaki täwetpäŋ täwat kireŋit api täneŋ. Upäŋkaŋ ude täŋirä nadäwätäk nämo täneŋ. Nämo, in säkgämän itkaŋ. Nadäkaŋ? Bäräpi udewani intagän nämo täŋ tamik täkaŋ. Profet biani itkuŋo unita udegän täŋ yämiŋkuŋ. Täŋpäkaŋ in kunum gänaŋ kowata täga api yäpneŋo unita bänep täga nadäŋpäŋ oretoret terak kuŋat täkot! ");
INSERT INTO iou_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Täŋpäkaŋ Anutu täŋo ämawebeniye intä, ämawebe päke u bämopi-ken paŋ gäripi nikek ude kaŋ kuŋarut. Täŋpäkaŋ gäripi paoreko uwä jide täŋpena äneŋi gäripi ahäwek? Nämo, paŋ gäripi nikek nämo uwä maŋpä kuŋirä ämawebetä yeŋ awähutneŋ. Unita paŋ gäripi nikek ude kaŋ kuŋarut! ");
INSERT INTO iou_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Ba kubä pen ŋode; Topäntä taŋi ijiŋpäŋ ägoni säkgämän peŋyäŋek täkaŋ. In-täŋo irit kuŋat-kuŋatjin udegän. Äma kubätä topän ijiŋpäŋ käbop imata pewek? Ude nämo, ijiŋpäŋ kwawak peŋirän ägonitä kädet-ken peŋ-yäŋeŋirän ämawebetä kwawakgän kaŋtäŋ kuŋatneŋ. Ba yotpärare taŋi kubä pom terak ireko uwä käbop täga irek? Nämo, kwawakinik irirän ämawebe bankentä täga käneŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Täŋpäŋ in, irit kuŋat-kuŋatjin udegän. Anutu täŋo peŋyäŋek kudän bänepjin-ken itak u täŋpewä kwawak irirän kädet siwoŋi kuŋarirä ämawebetä tabäŋpäŋ oretoret täŋpäŋ Anutujin kunum gänaŋ nanik u iniŋoret täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesutä ude yäŋpäŋä äneŋi ŋode yäŋkuk; In Anutu täŋo baga man ba profet biani täŋo yäwetpäŋ yäwoŋärek man täŋpani u näkä däpmäŋ täkŋekta äpuk yäŋ nämo nadäneŋ. Näk u däpmäŋ täkŋekta nämo äput. Nämo, u täŋkehärom taŋpewa bureni kwawak kaŋ ahäwän yäŋpäŋ äput. ");
INSERT INTO iou_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Unita näk bureni täwetat; Baga man u bäräŋeŋ nämo api paorek. Imaka u ba u ahäkta yäwani Anutu täŋo man terak kudän täŋkuŋo u bureni ahäwäkaŋ kunum kenta kometä paorirän uyaku Baga man u api paorek. ");
INSERT INTO iou_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Unita äma kubätä baga man täpuri-inik kubä irepmitpäŋ ätu kädet udegän kaŋ iwarut yäŋ yäŋpäŋ-yäwoŋärek täŋpayäŋ täyak uwä Anutu täŋo kaŋiwat yewa gänaŋ wäpi biŋam nikektä nämo api irek. Täŋ, äma kubätä baga man u buramiŋpäŋ ätu kädet udegän kaŋ iwarut yäŋ yäŋpäŋ-yäwoŋärek täŋpayäŋ täyak uwä Anutu täŋo kaŋiwat yewa gänaŋ wäpi biŋam nikektä api irek. ");
INSERT INTO iou_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Unita ŋode täwera nadäwut; Baga man yäwoŋärewani äma ba Parisi ämatä ŋode yäk täkaŋ; Bureni, nin Anutu täŋo Baga man iwatpäŋ siwoŋi kuŋat täkamäŋ yäk. Ude yäk täkaŋ upäŋkaŋ in u yärepmitpäŋ Anutu täŋo gärip ugän kaŋ iwarut. Ude nämo tänayäŋ täkaŋ uwä Anutu täŋo kaŋiwat yewa gänaŋ nämo api äroneŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesutä ude yäŋpäŋ äneŋi ŋode yäŋkuk; Anututä äbekjiye orajiye bian ŋode yäwetkuk; Äma kubä kumäŋ-kumäŋ nämo uren. Äma kubä kumäŋ-kumäŋ urayäŋ täyan uwä manken api iren yäk. ");
INSERT INTO iou_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Man ude yäwetkuko upäŋkaŋ apiŋo näkä ŋode täwetat; Äma kubätä noripakita kokwawak nadäŋpeŋ kuŋarayäŋ täyak uwä manken api irek. Ba äma kubätä noripaki man waki mäyäk ikek iwerayäŋ täyak uwä man käbeyä-ken api irek. Ba äma kubätä noripakita kokwawak nadäŋpäŋ iniŋ wärät man iwerayäŋ täyak uwä geŋi kädäp mebet ikek unita biŋam api täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Unita ket ŋode nadäkot; Kadäni kubä gäk Anututa iron täŋ ima yäŋpäŋä ŋode käwep nadäwen; Näk imaka kubä täŋkuro unita notnapak näka kokwawak nadätak. Ude nadäŋpäŋä imaka Anututa imikta yäwani u pewi irirän äneŋi äyäŋutpeŋ päŋku notkapak kokwawak nadäŋ gameko uwä yäŋahäŋpäŋ yäŋpak taŋkaŋ eruk äneŋi äyäŋut päŋku imaka u Anututa täga imen. ");
INSERT INTO iou_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ba notkapak kubätä iwan täŋ gamiŋpäŋ manken gepmaŋpayäŋ yäŋirän nadäŋpäŋä manken nämo ahäŋkaŋ päŋku notkapak-kät yäŋpäŋ-nadäŋpäŋ bänep kubägän tädeŋ. Ude nämo täŋkaŋ notkapaktä jukun päŋku gäkŋo mebärika yäŋahäwänkaŋ gäk mäden kwiwä man nadäwanitä komi äma yäniŋ kireŋpewän gepmäŋit päŋku komi yotken gepmaneŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Näk bureni täwetat. Gäk notkapakta momi täŋ imeno u nämo täreŋirän gäk jop täga nämo ganiŋ kirewä äpämaŋ kwen. Nämo, gäk notkapakta momi täŋ imeno u suwawi tärewänkaŋ uyaku ganiŋ kireŋpewä äpämaŋ kwen! Upäŋkaŋ jide täŋpäŋ moneŋ yäpmäŋkaŋ suwawi tärewäpäŋ äpämaŋ kwen? ");
INSERT INTO iou_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesutä man ude yäwetpäŋ äneŋi ŋode yäkgän täŋkuk; Anututä äbekjiye orajiye bian ŋode yäwetkuk; In kubokäret nämo täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Man ude yäwetkuko upäŋkaŋ apiŋo näkä ŋode täwetat; Äma kubätä webe kubä kaŋgärip täŋpäŋ ukät pätde yäŋ bänepi-ken ude nadäweko uwä kubokäret täyak uba. ");
INSERT INTO iou_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Unita dapunka kubätä waki täŋo buŋep-ken gepmaŋpayäŋ täŋpänä dapunka u dätpäŋ maŋpi kuneŋ. Dapunka bok yäpmäŋ kuŋatkaŋ geŋi-ken äpmoŋpenta. ");
INSERT INTO iou_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ba ketka kubätä waki täŋo buŋep-ken gepmaŋpayäŋ täŋpänä ketka u madäŋ täkŋeŋpäŋ maŋpi kuneŋ! Gupka kumän nikek yäpmäŋ kuŋatpäŋ waŋpäŋ geŋi-ken äpmoŋpenta. ");
INSERT INTO iou_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesutä man ude yäwetpäŋ äneŋi pen ŋode yäwetkuk; Mosestä äbekjiye orajiye bian ŋode yäwetkuk; Äma kubätä webeni pewayäŋ nadäŋpäŋä webena peyat yäŋ man kudän kwawak ude täŋpäŋ imeko uyaku täga yäŋiwat-pewän kwek yäk. ");
INSERT INTO iou_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","In man ude nadäk täkaŋ upäŋkaŋä apiŋo näkä ŋode täwetat; Äma kubätä webenitä äma kubäkät momi nämo täŋpekopäŋ jop nadäŋ yäŋiwat-pewän päŋku äma kubä yäpeko uwä webe u kubokäret täŋpek. Täŋkaŋ äma kodaki yäpeko u imaka, kubokäret täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesutä ude yäwetpäŋ äneŋi man kubä pen ŋode yäŋahäŋpäŋ yäwetkuk; Baga man kubä bian ŋode kudän täwani in nadäk täkaŋ; Gäk yäŋkehäromtak man jop nämo yäwen. Yäŋ-kehäromtak man u Anutu iŋamiken yäwani unita udegän bureni täŋpen yäk. ");
INSERT INTO iou_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","In-täŋo baga man terak ude itak upäŋkaŋä apiŋo näkä ŋode täwetat; In yäŋkehäromtak man yäna yäŋpäŋä imaka kubä wäpi terak utpäŋ nämo yäneŋ. Kunum wäpi terak utpäŋ yäŋkehäromtak man nämo yäneŋ. Kunum uwä Anutu täŋo irit bägup unita. ");
INSERT INTO iou_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ba kome wäpi terak utpäŋ yäŋkehäromtak man nämo yäneŋ. Kome u imaka, Anutu täŋogän. Ba kudupi yotpärare Jerusalem wäpi terak utpäŋ yäŋkehäromtak man nämo yäneŋ. U Kaŋiwat Äma intäjukun täŋpani, Anutu täŋo yotpärare unita. ");
INSERT INTO iou_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ba gwäkjin kujat terak wohutpäŋ nämo yäneŋ. Imata, manjin u kehäromi nikek nämo. Jide? In gwäkjin pujiŋ paki kubä iwerä kubiri täga äworewek? Ba gwäkjin pujiŋ kubiri kubä iwerä paki täga äworewek? Nämoinik, in ämagän! ");
INSERT INTO iou_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Unita äma kubätä man yäweno u bureni ba bureni nämo yäŋ nadäkta gäwet yabäŋirän gäk ‘Bureni’ yäŋ yäŋpäŋä ‘Ei’-gän iweren. Ba ‘Bureni nämo’ yäŋ yäŋpäŋä ‘Nämo’-gän iweren. Man keräpi yarä ugän yäwen. Upäŋkaŋ gäk imaka kubä täŋo wäpi terak wohutpäŋ yäweno uwä Satantä pewän ahäŋirän yäwen. ");
INSERT INTO iou_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesutä man ude yäwetpäŋ äneŋi kubä ŋode yäwetkuk; Baga man kubä bian ŋode kudän täwani in nadäk täkaŋ; Kubätä dapunka yäpurän tumbäwä kowata udegän täŋ imen. Ba kubätä meka kujat däpmäŋ tokäränä kowata udegän däpmäŋ tokät imen yäk. ");
INSERT INTO iou_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","In man ude nadäk täkaŋ upäŋkaŋä apiŋo näkä ŋode täwetat; Äma kubätä waki täŋ gamänä kowata waki nämo täŋ imen. Unita äma kubätä bumumka kukŋi käda guränä kukŋi iniŋ kirewen. ");
INSERT INTO iou_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ba äma kubätä gäka kokwawak nadäŋpäŋ manken gepmaŋpäŋ gäkŋo tek punin nanik gomägaränä gänaŋ nanik bok iniŋ kirewi yäpek. ");
INSERT INTO iou_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ba äma kubätä täŋkentäŋ päŋku tuän uduken nepmaŋkaŋ äbi yäŋ gäweränä täŋkentäŋ päŋku ban uduken teŋkaŋ äben. ");
INSERT INTO iou_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ba äma kubätä imaka kubäta yäŋapiwänä imen. Ba äma kubätä gäkŋo imaka kubä yäpmäŋ päŋku täŋkaŋ api gamet yäŋ gäweränä iniŋ kirewen. ");
INSERT INTO iou_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesutä ude yäŋpäŋ man kubä pen ŋode yäwetgän täŋkuk; Man kubä ŋode yäwani u nadäkinik täkaŋ; Notjiyeta bänep iron täŋ yämiŋkaŋ äma iwan täŋ tamik täkaŋ unita mäde ut yämineŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Man ude nadäkaŋ upäŋkaŋ näkä apiŋo ŋode täwera nadäwut; Äma iwan täŋ tamik täkaŋ unita bänep iron täŋ yämineŋ. Ba äma nadäkinikjinta yäŋpäŋ komi tamik täkaŋ unita Anututä täŋkentäŋ yämikta Anutu-ken yäŋapineŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","In ude täneŋo uyaku Nanjin kunum gänaŋ nanik täŋo nanakiye bureni-inik api itneŋ. Täŋpäkaŋ mebäri imata äma waki ba äma täga bok iron täŋ yämineŋ? Uwä ŋode; Nanjin unitä yäŋpewän edaptä äma waki ba äma tägata bok peŋyäŋeŋ yämik täyak. Ba Anututä nadäŋ yämiŋirän äma siwoŋi-ken ba äma goret kuŋarani-ken iwän tak täyak. ");
INSERT INTO iou_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Täŋpäkaŋ äma gäka bänep iron kowata täŋ gamik täkaŋ äma unitagän bänep iron kowata yämeno uwä Anututä gäk äma täga yäŋ nämo gäwerek. Nämo, äma wakiwakitä noriyeta udegän bänep iron täŋ yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ba guŋ ämawebetä ämawebe ini gäripi nadäk täkaŋ unitagän bänep iron täga täŋ yämik täkaŋ. Täŋ, inä kädet ude nämo täneŋ. In notjiye-tagän iron täŋ yämineŋo uwä injinta nadäwä täga nämo täneŋ. Äma kowata nämo täŋ tamanita iron täŋ yämineŋo uyaku! ");
INSERT INTO iou_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","In nadäkaŋ? Kunum gänaŋ Nanjintä kädet ude iwat täyak. Uwä kädet tägagän täk täyak unita nanakiye inä udegän kädet tägagän kaŋ täk täŋput! ");
INSERT INTO iou_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesutä ude yäŋpäŋ ŋode yäwetkuk; In ket nadäŋkaŋ kuŋat täkot. Imaka täga kubä täŋpa yäŋpäŋä ŋode nämo nadäŋpäŋ täŋpen; Kwawak täŋira ämawebetä nabäŋpäŋ wäpna yäpmäŋ akut yäŋ nadäŋkaŋ nämo täŋpen. In ude tänayäŋ täkaŋ uwä kunum gänaŋ Nanjintä gwäki täga nämo api tamek. ");
INSERT INTO iou_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Unita gäk äma kubä täŋkentäŋ ima yäŋpäŋä eruk ämawebetä nabäwut yäŋ nadäŋkaŋ iŋamiken kwawak nämo täŋpen. Äma yäŋ-yäkŋaranitä kudupi yot gänaŋ ba kädet miŋin täk täkaŋ ude nämo täŋpen. Äma udewaniwä ämawebetä nibäŋpäŋ wäpnin biŋam yäpmäŋ akut yäŋ nadäŋkaŋ täk täkaŋ. Näk bureni täwetat. Äma udewani gwäki yäpmäŋirä täretak ubayäŋ! ");
INSERT INTO iou_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Unita gäk äma kubä täŋkentäŋ ima yäŋpäŋä käbop-inik, notkapak kubä dubika-ken ireko unitä gabäŋpäŋ-nadäŋirän nämo. ");
INSERT INTO iou_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ude täŋiri Nanka, imaka käbop täŋiri kaŋpäŋ nadäk täyak unitä gwäki api gamek. ");
INSERT INTO iou_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesutä man ude yäŋpäŋ man kubä pen ŋode yäkgän täŋkuk; In Anutu-ken yäŋapina yäŋpäŋä äma yäŋ-yäkŋaranitä täk täkaŋ ude nämo täneŋ. Yäŋ-yäkŋarani äma uwä kudupi yot gänaŋ ba kädet miŋin itkaŋ Anutu-ken yäŋapik man käroŋi boham yäkta gäripi nadäk täkaŋ. Ämawebetä nibäwut yäŋkaŋ udewä täk täkaŋ. Näk bureni täwetat. Ämawebetä äma udewani yabäŋirä gwäki yäpä täretak ubayäŋ! ");
INSERT INTO iou_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Unita Anutu-ken yäŋapiwa yäŋpäŋä gäkŋa yot gänaŋ päro yäma yäputpäŋ itkaŋ Nanka käbop it täyak ukät man yäŋpäŋ-nadäk tädeŋ. Ude täŋiri Nanka imaka käbop kaŋpäŋ nadäk täyak unitä gwäki api gamek. ");
INSERT INTO iou_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ba in Anutu-ken yäŋapina yäŋpäŋä guŋ ämatä täk täkaŋ ude nämo täneŋ. Guŋ äma uwä anutunita man käroŋi, mebärini nämo yäŋiwat yäpmäŋ kuk täkaŋ. Käroŋi ude yäŋ yäpmäŋ kuŋitna uyaku anutunintä käwep nadäŋ nimek yäŋ nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Upäŋkaŋ inä ude nämo täneŋ. In imaka imakata wäyäkŋeŋpäŋ Anutu Nanjinken yäŋapinayäŋ nadäŋirä Nanjin uku tabäŋpäŋ-nadäk täyak. Unita imata man käroŋi mebärini nämo yäŋiwat yäpmäŋ kuneŋ? Nanjin uwä täŋkentäŋ tamikta gäripi nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Unita Anutu-ken yäŋapinayäŋ nadäŋpäŋä man siwoŋi ŋode yäneŋ; Kunum gänaŋ Nanin taŋi, Gäk wäpka inipärik kubä pat täyon. ");
INSERT INTO iou_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Äbäŋpäŋ bänepi bänepi, komeni komeni Ekäni täŋ nimi. Kunum gänaŋ gäkken man buramik pätak, kome terak ninken udegän man buramik pat täyon. ");
INSERT INTO iou_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kadäni ŋonitäŋo ketem nimisi. ");
INSERT INTO iou_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nin notniye täŋo momi pek täkamäŋ, gäk udegän mominin peŋ nimisi. ");
INSERT INTO iou_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Täŋyabäk-ken nämo nipmaŋpen. Wakiken nanik wädäŋ tädotpäŋ nipmaŋsi. ");
INSERT INTO iou_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ude yäŋpäŋ yäŋkuk; Äma kubätä waki täŋ gamiŋirän, waki täŋ gameko u peŋ imiŋkaŋ nämo yäpmäŋ kuŋariwä Nanka kunum gänaŋ naniktä udegän gäkŋo wakika api peŋ gamek. ");
INSERT INTO iou_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Upäŋkaŋ äma kubätä waki täŋ gamiŋirän waki täŋ gameko u nämo peŋ imiŋkaŋ yäpmäŋ kuŋariwä Nankatä udegän gäkŋo waki nämo api peŋ gamek. ");
INSERT INTO iou_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","In kadäni ätu Anutu iniŋ oretta nakta jop itna yäŋpäŋä butewaki iŋam dapun nämo ijiŋkaŋ kuŋatneŋ, yäŋ-yäkŋarani ämatä täk täkaŋ ude. Äma udewani uwä ämawebetä nibäŋpäŋ in äma kädet täga täŋpani yäŋ nadäwut yäŋkaŋ iŋam dapun butewaki ijiŋkaŋ kuŋat täkaŋ. Näk bureni täwetat. Äma udewani gwäki yäpmäŋirä täretak ubayäŋ! ");
INSERT INTO iou_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Upäŋkaŋ inä, Anutu iniŋ oretta nakta jop itna yäŋpäŋä ume ärutpäŋ gwäkjin pujiŋ täŋket utkaŋ kuŋatneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ude täŋirä ämawebetä in Anutu iniŋ oretta nakta jop kuŋatkaŋ yäŋ tabäŋpäŋ nämo nadäneŋ. Nanjin käbop it täyak unitägän tabäŋpäŋ-nadäk täŋpek. Nanjin uwä imaka käbop täŋirä tabäŋpäŋ-nadäk täyak unitä gwäkiwä api tamek. ");
INSERT INTO iou_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesutä man ude yäŋpäŋ äneŋi kubä pen ŋode yäkgän täŋkuk; In kome terak ŋo imaka tägatäga yäpmäkta nadäwätäk nämo täneŋ. Kome täŋo tuŋum u kehäromi nämo. Äpusit ba gwakgwaktä nak täkaŋ ba gämäneŋ ärok täkaŋ. Ba kubo ämatä yot däpmäŋ äreyäŋpäŋ kubo täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Unita kunum täŋo tuŋum yäpmäkta epäni täŋpeŋ kaŋ kuŋarut. Kunum täŋo tuŋum nämo wak täkaŋ. Äpusit ba gwakgwak u nämo nak täkaŋ ba u nämo gämäneŋ ärok täkaŋ. Kunum täŋo tuŋum uwä kubo ämatä täga nämo däpmäŋ äreyäŋpäŋ yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bureni-inik, imatäken tuŋumta nadäwi ärowani täŋpeko uwä bänep nadäk-nadäkka uterakgän peŋpäŋ kuŋaren. ");
INSERT INTO iou_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","In nadäkaŋ? Dapunjin u gupjin täŋo topän. Dapunjintä täga ijineŋo uwä gupjin imaka, peŋyäŋek ikek irirän kädet siwoŋi täga kuŋatneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Täŋ, dapunjin waneŋo uwä jide täŋpäŋ imaka imaka täga kaŋpäŋ täŋpeŋ kuŋatneŋ? Nämo, gupjin bipmäŋ urani gänaŋ irek. Täŋpäkaŋ peŋyäŋek bänepjin-ken itak unitä bipmäŋ urani täŋpeko uwä bipmäŋ urani pähap gänaŋ api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Äma kubä-tägän äma ekäni yaräta watä epän täga nämo täŋ yämek. Nämo, u kubäta gäripi nadäŋkaŋ kubäta gaŋani nadäwek. Ba kubä täŋo epän täŋkaŋ kubäta mäde ut imek. In udegän, bänep nadäk-nadäkjin Anutu terak ba moneŋ tuŋum terak bok täga nämo peŋpeŋ kuŋatneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Unita ŋode täwetat; In gupjinta nadäwätäk ŋode nämo täneŋ; Ketem depäŋ näŋpet? Ba tek depäŋ täŋpäŋ kuŋaret? yäŋ nämo nadäneŋ. Nämo, ketem ba tek uwä bureni nämo. Uwä irit kuŋat-kuŋatjin täŋo täŋkentäk moräkigän. Unita bänep nadäk-nadäkjin imaka bureni terak peneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","In imata Anutu u watä säkgämän nämo käwep it nimek yäŋ nadäk täkaŋ? Eruk, in barakta yabäŋpäŋ-nadäwut! U ketem nämo piŋpäŋ puget täkaŋ ba pugetpäŋ kämita nämo pek täkaŋ. Upäŋkaŋ Nanjin kunum gänaŋ naniktä yabäŋ yäwatpäŋ yepmäŋ towik täyak. Imaka äpani udewani yabäŋ yäwatpäŋ yepmäŋ towik täyak u täŋpänä imata äma inta udegän nämo tabäŋ täwatpäŋ tepmäŋ towiwek? ");
INSERT INTO iou_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nadäwätäkjintä kome terak iritjin täga wädäwän käroŋ täwek? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Unita gupjin täŋo tuŋumta imata nadäwätäk täk täkaŋ? Päya irori bipiken it täkaŋ unita yabäŋpäŋ-nadäwut! U inita tekta epäni nämo täk täkaŋ upäŋkaŋ yabäŋgärip ikek. ");
INSERT INTO iou_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bureni, imaka kubä täŋo kaŋgäriptä päya irori unitäŋo kaŋgärip u täga nämo irepmirek. Unitäŋo yabäŋgäriptä intäjukun äma biani Solomon unitäŋo moneŋ tuŋum ba tek säkgämän kaŋgärip ikek päke u yärepmit täyak. ");
INSERT INTO iou_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","U uwä Anututä ini tek gäripi nikek ude päya irori jopi unita uwäktäŋ yämik täyak. Täŋpäkaŋ u kadäni keräpigän itpäŋ paot täkaŋ. Apiŋo ahäneŋopäŋ kwep ude äneŋi täreŋ mäneŋ. Eruk, päya irori unita yabäŋ yäwat täyak upäŋ imata inta udegän täga nämo tabäŋ täwatpäŋ tamek? U bureni tamek! Unita imata nadäkinikjin Anutu-ken kumän nämo pek täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Unita ketem ba ume deken yäpmäŋpäŋ näne yäŋkaŋ nadäwätäk nämo täneŋ. Ba tek deken yäpmäŋpäŋ täne yäŋkaŋ nadäwätäk nämo täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nämoinik! U guŋ ämatä bänep nadäk-nadäki udewani terakgän pek täkaŋ. Täŋ, inä imaka udewanita nadäwätäk pähap nämo täneŋ. Nämo, nanjintä in imaka udewanita wäyäkŋek täkaŋ yäŋ tabäŋpäŋ-nadäk täyak unita api täŋkentäŋ tamek. ");
INSERT INTO iou_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Unita inä imaka kubäta nadäwä intäjukun nämo täŋpek. Nämo, Anututä intäjukun it tamiŋpäŋ tabäŋ täwatta ba unitäŋo kädet siwoŋi u iwatta unitagän gäripi-inik nadäŋpäŋ epäni täk täkot. Ude täŋirä uyaku ketem tuŋumta wäyäkŋek epän tänayäŋ täkaŋ u api taniŋ kirewek. ");
INSERT INTO iou_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Unita kwep täŋo irit kuŋat-kuŋat jidewani api itneŋ yäŋ nadäŋkaŋ nadäwätäk nämo täneŋ. Kwep yäŋen täŋo bäräpi ini irirä apiŋo täŋo unitagän nadäwätäk täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Jesutä man äneŋi kubä pen ŋode yäwetkuk; In äma kubä yäŋpäŋ-kaŋiwat nämo täneŋ, Anututä in udegän yäpmäŋ daniwekta nadäŋkaŋ. In nadäkaŋ? In ämawebeta jide nadäŋpäŋ kuŋatnayäŋ täkaŋ uterakgän Anututä inta api nadäŋ tamek. ");
INSERT INTO iou_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Unita gäk imata täpun-täpun taŋi dapunka-ken itak u nämo kaŋpäŋ nadäŋkaŋ notkapak kubä dapuri-ken täpun-täpun täpuri itak u kaŋpäŋ yokut gamayäŋ iwet täyan? Täpuntäpun gäkŋa dapunka-ken itak u imata nämo kaŋpäŋ nadäk täyan? ");
INSERT INTO iou_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gäk yäŋ-yäkŋarani äma! Intäjukunä gäkŋa dapunka-ken täpun-täpun taŋi itak u yokutkaŋ uyaku dapun täga ijiŋpäŋ kaŋpäŋ notkapak dapuri-ken täpun-täpun u täga yokut imen! ");
INSERT INTO iou_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ude yäŋpäŋ yäwetkuk; Äma Anututa gäripi nämo nadäk täkaŋ unita Anutu täŋo man kudupi u jop nämo yäwetneŋ. Aŋtä äma yek täkaŋ udegän äma udewani uwä Anutu täŋo man unita bitnäŋpäŋ taniŋ wärätneŋ. Bureni, äma udewani uwä but bumik. Buttä it täkaŋ-ken tuŋumka täga kubä jop nadäŋ täga maŋpi kuneŋ? Nämo, buttä tuŋumka u yeŋ gatäŋtäŋ kuŋkaŋ abäk täneŋ. Äma uwä udegän täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesutä man ude yäŋpäŋ yäwetkuk; In Anutu-ken imaka kubäta yäŋapiŋirä api nadäŋ tamek. Uwä äma kubätä wäyäkŋek epän täŋ yäpmäŋ kuŋtäŋgän kaŋ-ahäweko ude. Ba kubätä yäma-ken kwäpkwäp yäput yäpmäŋ kuŋirän yäma dät imeko ude. ");
INSERT INTO iou_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Näk bureni täwetat. Äma kubätä yäŋapik epän täŋpäŋä bureni api yäpek, äma kubätä wäyäkŋek epän täŋ yäpmäŋ kuŋtäŋgän bureni kaŋ-ahäweko ude. Ba kubätä yäma-ken kwäpkwäp yäput irirän Anututä nadäŋ imiŋpäŋ yäma dät imeko ude. ");
INSERT INTO iou_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Eruk, jide nadäkaŋ? Nanakka kubätä ketemta yäŋirän mobä täga imen? Nämo! ");
INSERT INTO iou_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba tomta yäŋapiŋirän gämokpäŋ täga imen? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Inä äma waki upäŋkaŋ nanakjiyeta imaka tägatäga yämik täkaŋ. Unita ŋode nadäwut; Kunum gänaŋ Nanjin iron mähemi itak uken yäŋapiŋirä imaka tägatäga imata täga nämo tamek? Nämo, u gäripi nadäŋ tamiŋpäŋ bureni-inik tamek yäŋ täwetat! ");
INSERT INTO iou_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Unita ŋode täwetat; Kädet äma ätutä täŋ nimut yäŋ nadäk täkaŋ in udegän täŋ yämineŋ. Man täpuri unitäwä man profet bianitä yäŋahäwani u ba baga man Mosestä yäŋahäwani u kumän uwäk täyak. ");
INSERT INTO iou_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","In kunum kädet iwatta yäma täpuri-ken kaŋ ärowut. Kumäŋ-kumäŋ kädet u taŋi ba yämani udegän u taŋigän. Kädet taŋi uken ämawebe mäyaptä kuŋ äbäŋ täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Täŋpäkaŋ irit kehäromi täŋo yäma uwä täpuri ba käderi udegän gäkŋi. Kädet uwä ämawebe kubäkubä-tägän iwat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","In nadäkaŋ? Äma ätu Anutu täŋo man yäŋahäk täkaŋ upäŋkaŋ ämawebe täŋyäkŋatna yäŋkaŋ Anutu täŋo man siwoŋi nämo yäŋahäk täkaŋ. Äma udewanita ket nadäŋkaŋ kuŋatneŋ. Äma uwä bänep ärik-ärik man täwet täkaŋ upäŋkaŋ bänepi-ken nadäk wakiwaki yäpmäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Unitäŋo irit kuŋat-kuŋariken bureni jide pewä ahäk täkaŋ u yabäŋpäŋ-nadäŋkaŋ mebärini täga nadäneŋ. Uwä päya ude. Bärop terak wama mujip täga nämo wädäneŋ ba gupmom yen terak wäyän täga nämo wädäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nämo, päya mebäri täga terak bureni gäripi nikek wädäneŋ. Täŋ, päya mebäri wakitä mujipi näŋpani nämo wädäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Päya mujipi näŋpani terak bureni waki wädäkta käderi nämo pätak. Ba päya mujipi nämo näŋpani terak bureni näŋpani uwä täga nämo wädäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Täŋpäkaŋ päya, bureni goret pewä ahäk täkaŋ uwä madäŋpäŋ kädäp pewä ijik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","U udegän, äma Anutu täŋo man jopjop yäŋahäwani unitäŋo mebärini nadäna yäŋpäŋä irit kuŋat-kuŋari upäŋ yabäŋpäŋ-nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Unita ŋode täwera nadäwut; Äma mäyaptä näka Ekänina yäŋ näwet täkaŋ upäŋkaŋ u kuduptagän Anutu täŋo kaŋiwat yewa gänaŋ nämo api äroneŋ. Nämo! Nana kunum gänaŋ unitäŋo mani buramik täkaŋ ämawebe unitägän api äroneŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Äma mäyaptä kadäni pähapken ŋode api näwetneŋ; Ai! Ekäni! Gäkŋo biŋam man ämawebe yäŋahäŋpäŋ yäwetkumäŋ. Ba gäk wäpka terak kudän kudupi mebäri mebäri täŋit mäjo yäwat kireŋit täŋkumäŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Man ude yäŋirä näkä ŋode api yäweret; Wakiwaki täŋpani in kewewut! Näk inta nämo nadätat! ");
INSERT INTO iou_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Eruk, ämawebe man täwet täyat ŋo buramiŋpäŋ iwatnayäŋ täŋo uwä äma yot täkta mebäri nadäkinik täŋpani udewani bumik. Kadäni kubä äma nadäk-nadäk ikek udewani kubätä yori mobä kehäromi terak täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Täŋpekopäŋ iwän mänit täŋirän ume tokätkaŋ gwägu tokŋewek. Täŋpäkaŋ yot uwä mobä kehäromi terak täŋpani unita nämo wärämurek. ");
INSERT INTO iou_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eruk kadäni kubä äma guŋ udewanitä yori mobä jiraŋ terak täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Täŋpekopäŋ iwän mänit täŋirän ume tokätkaŋ gwägu pähap tokŋewek. Ude täŋpäŋ yot uwä äneŋ kwinit täŋpän kuneŋ. Bureni, u paot-inik täŋpek! Täŋpäkaŋ ämawebe näkŋo man täwet täyat ŋo nadäŋkaŋ nämo buramiŋpäŋ iwatnayäŋ täŋo uwä äma yot täkta mebäri nämo nadäwani, guŋ udewani. ");
INSERT INTO iou_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Täŋpäkaŋ Jesutä man päke u yäŋ moreŋirän ämawebe dubini-ken itkuŋo u man u nadäŋpäŋ-nadäwätäk pähap täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ŋode nadäŋkuŋ; Baga man yäwoŋärewani ämatä man yäŋpäŋ-yäwoŋärek täk täkaŋ ude bumik nämo yäyak yäk. Äma ŋowä man mähemitä ini yäyak yäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Eruk, Jesutä pom terak naniktä äpäŋirän ämawebe äbot pähap unitä iwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Täŋirä äma kubä gisik paräm ikek unitä Jesuken kuŋpäŋ gukut imäpmok täŋpäŋ iwetkuk; Ekäni, gäk täŋkentäŋ namayäŋ nadäŋpäŋä näk täga nepmaŋpi kudupi iret yäŋ nadätat. ");
INSERT INTO iou_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ude yäwänä Jesutä keri gupi terak peŋpäŋ yäŋkuk; Täga täŋkentäŋ gamayäŋ. Paräm ŋo paorut! yäk. Ude yäwänä uterakgän gisik paräm u paorirä gupi tägawänpäŋ säkgämän itkuk. ");
INSERT INTO iou_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesutä ude täŋ imiŋpäŋ iwetkuk; Gäk imaka täŋ gamitat ŋonitäŋo manbiŋam äma nämo yäweren. Nämo, gäk päŋku gupka Anutu täŋo bämop äma iwoŋäre. Ude täŋpäŋ äneŋi säkgämän itta Moses täŋo baga man iwatpäŋ gupe käbäŋi nikek ijiŋiri ämawebetä paräm tägakaŋ yäŋ api gabäŋpäŋ-nadäwä täreneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Eruk Jesu Kapeneam yotpärare-ken kumaŋ äroŋirän komi äma kubätä Jesuken ahäŋpäŋ butewaki man ŋode iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ärowanina! Epän watä ämana komi pähap nadäŋpäŋ kwäyähäneŋ täŋpäŋ yotken pätak yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","8","Yäwänä iwetkuk; Näkä äreŋkaŋä yäpa täganayäŋ yäk. Ude iweränä komi äma unitä ŋode iwetkuk; Ärowanina, näk äma täga uyaku yotna-ken täga kwen. Unita gäk ŋogän itkaŋä mangän yäŋiri kaŋ tägawän! ");
INSERT INTO iou_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ude täga täŋ namen yäŋ nadätat. Imata, näk udegän, intäjukun ämanaye täŋo gämori-ken itkaŋ mani buramik täyat. Ba näk gämotna-ken komi ämanaye ätu itkaŋ. U kubäpäŋ, Ku! yäŋ iwerawä, man buramiŋpäŋ kwek. Ba kubä, Äbi! yäŋ iwerawä, äbek. Ba epän watä ämana kubä, Epän ŋo tä! yäŋ iwerawä u täŋpek yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Man ude yäŋirän Jesutä nadäwän inide kubä täŋpäpäŋ ämawebe iwarän täŋkuŋo u ŋode yäwetkuk; Näk bureni täwetat. Näk äma nadäkinik ärowani ŋodewani Isrel komeken nanik kubä nämo kaŋpäŋ nadäk täyat! ");
INSERT INTO iou_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Unita ŋode täwetat; Ämawebe mäyap guŋ äbotken nanik uken-uken naniktä abäŋpäŋ Juda täŋo oraniye Abraham, Aisak, Jekop ukät Anutu täŋo kaŋiwat yewa gänaŋ ärawa pähapken bok api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Upäŋkaŋ Juda ämawebe ätu Anutu täŋo kaŋiwat yewa gänaŋ äronaŋipäŋ Anututä yäwat kireŋpewän bipmäŋ urani gänaŋ äpmoŋkaŋ konäm butewaki täŋkaŋ meni api jiwätpeŋ itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ude yäŋpäŋ komi äma u iwetkuk; Gäk kuyi. Nadäkinikka täŋo bureni ahäŋ gamayäŋ. Ude iwerirän uterakgän komi äma täŋo epän watä äma uwä tägaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ude täŋkaŋä Jesu Pitatä yot gänaŋ äroŋpäŋ kaŋkuk; Pita yepmani webe uwä gup kädäp käyäm täŋkaŋ parirän. ");
INSERT INTO iou_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kaŋpäŋ Jesutä kerigän iŋirirän käyäm u paotkuk. Täŋirän webe uwä akuŋpäŋ Jesuta ketem gwet imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Täŋpäkaŋ bipäda ugän ämawebe mäjotä magärani mäyap yäŋ-yäkŋat yäpmäŋ Jesuken äbuŋ. Äbä irirä, Jesutä mäjo peŋ yäwet-pewän ämawebe yabä kätäŋpeŋ kuk täŋkuŋ. Käyäm ikek imaka, kudup yäpän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ude täŋirän profet Aisaiatä bian man ŋode kudän täŋkuko u bureni ahäŋkuk; Nintäŋo käyäm-käyäm ba komi komi kumän niyomägatpäŋ yäpmäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Eruk, ämawebe mäyap unitä Jesu itgwäjiŋirä yabäŋpäŋ iwaräntäkiye ŋode yäwetkuk; Eruk, gwägu kukŋi udude käda kuna! yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ude yäweränä Baga man yäwoŋärewani äma kubätä abäŋpäŋä Jesu iwetkuk; Yäŋpäŋ-yäwoŋärek äma, gäkä deken kwayäŋ yäŋiwä näk imaka, api gäwarän täwet yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ude iweränä Jesutä iwetkuk; Ket nadäwi pewäkaŋ näwaren. Imata, tom ägwäri u patpat bägupi nikek. Barak udegän, bukäni nikek. Upäŋkaŋ Äma Bureni-inik iwarayäŋ yäŋ yäyan uwä patpat bägupta wäyäkŋek täyak. ");
INSERT INTO iou_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ude yäŋirän iwarän täwani kubätä Jesu iwetkuk; Ekäni, nadäŋ namiŋiri näk päŋku nana kumbänpäŋ äneŋkaŋ mäden kaŋ gäwara yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yäwänä iwetkuk; Ude nämo! Näk näwarän täŋiri, kumbanitä kumbani noriye kaŋ äneŋput. ");
INSERT INTO iou_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Eruk man ude yäŋ paotpäŋä Jesu iwaräntäkiye-kät gäpe terak äroŋpeŋ gwägu kukŋi udude käda kuna yäŋkaŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kuŋtäko pengän mänit pähap piäŋirän gwägutä taŋi tokätpäŋ gäpe gänaŋ äpmoŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jesu uwä gäpe mädeni käda parirän iwaräntäkiyetä yäwä kikŋuränpäŋ iwetkuŋ; Wära! Ekäni, täŋkentäŋ nimiwä! Gwägu gänaŋ äpmonayäŋ täkamäŋ ŋo! yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yäwäwä Jesutä yäwetkuk; Imata umuntäkaŋ? Nadäkinikjin äreyäwani! Imata bänepjin bäräŋeŋ putärekaŋ? Ude yäwetkaŋ akuŋpäŋ mänit pähap ba gwägu tokätkuko u yabäŋ yäŋpäŋ yäniŋ bitnäŋpewän kwikinik itkumän. ");
INSERT INTO iou_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ude täŋirän kaŋpäŋ iwaräntäkiyetä nadäwätäk pähap täŋpäŋ yäŋkuŋ; Wära! Äma ŋo jidewani? Mänit kenta gwägutä mani buramikamän ŋo! yäŋ yäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Eruk kuŋtäŋgän gwägu kukŋi udude käda Gadara komeken ahäŋkuŋ. Kome uken äma mäjotä magärani yarä, äma kumbani äneŋpani-ken it täŋkumänonik. Unitä komita täŋirän ämawebe umuntaŋkaŋ uruŋ kädagän yärepmitpeŋ kuŋ abäŋ täk täŋkuŋonik. ");
INSERT INTO iou_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eruk yarä unitä Jesu kaŋpäŋ bäräŋeŋ päŋku ahäŋ imiŋpäŋ kähän yäŋpäŋ ŋode yäŋkumän; Ee! Anutu täŋo iroŋi gäk jide täŋ nimayäŋ abätan? Gäk kadäninin nämo täreŋirän komi nimayäŋ ba abätan? ");
INSERT INTO iou_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Ude yäŋpäŋ ban uduken but äbot pähap itkaŋ ketem naŋ irirä yabäŋkumän. Yabäwänä mäjo, äma yarä u magärani unitä Jesu butewaki man ŋode iwetkuŋ; But äbot itkaŋ udu yabätan? Niwat kirewayäŋ yäŋpäŋä niwat kireŋpewi jopi-ken kunero. Niweri päŋku but äbot itkaŋ udu gänaŋ äpmona yäk. ");
INSERT INTO iou_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ude yäwänä Jesutä peŋ yäwetkuk; Eruk kut! Yäwänä äma yarä u yabä kätäŋpeŋ kumaŋ but gänaŋ äpmoŋkuŋ. But u gänaŋ äpmoŋpäkaŋ but päke unitä bäräŋeŋ kumaŋ geŋi äriŋpeŋ gwägu gänaŋ äpmoŋpäŋ kumäŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ude täŋirä äma but watäni irani uwä metäŋpeŋ kumaŋ yotpärare-ken päŋku imaka umuri ahäŋkuko unitäŋo biŋami yäwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yäweräkaŋ ämawebe päke u Jesu kakta yotpärare uken naniktä äbuŋ. Eruk äbä kaŋpäŋä Jesu butewaki nadäŋ nimiŋpäŋ kome ŋo peŋpeŋ ku! yäŋ iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu iwaräntäkiye-kät gäpe terak äroŋpeŋ gwägu kukŋi udude käda ini yotpärare-ken kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kumaŋ päŋku yotpärare-ken ahäŋirä äma ätutä kwäyähäneŋ täŋpani kubä gäraŋ täŋ yäpmäŋ Jesutä itkuk-ken äbuŋ. Yäpmäŋ äbäŋirä Jesutä äma u nadäkiniki näkken pekaŋ yäŋ nadäŋpäŋä kwäyähäneŋ täŋpani u ŋode iwetkuk; Nanakna, umuntäweno. Momika paotkaŋ! ");
INSERT INTO iou_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesutä man ude yäŋirän Baga man yäwoŋärewani äma ätu uken itkuŋo unitä nadäŋpäŋ yäŋpäŋ-nadäk ŋode täŋkuŋ; Wa! Äma ŋonitä man Anututä yänaŋipäŋ yäyak yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ude yäŋirä Jesutä nadäk-nadäki-ken yabäŋpäŋ ŋode yäwetkuk; Bänepjin-ken imata nadäk waki u nadäkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Äma ŋo man jide iwerira bureni kwawak ahäŋirän känayäŋ? Momika peŋ gamitat yäŋ iweret ba Akumaŋ ku yäŋ iweret? ");
INSERT INTO iou_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eruk, in Äma Bureni-inik-ken momi peŋ yämik täŋo kehäromi itak yäŋ nadäkta ŋode täŋira kawut. Ude yäŋpäŋ äma kwäyähäneŋ täŋpani u iwetkuk; Aku! Patpat bägupka yäpmäŋkaŋ yotka-ken kuyi! ");
INSERT INTO iou_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ude iweränä äma u akumaŋ yori-ken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kuŋirän ämawebe päke unitä u kaŋpäŋ jäkjäk yäŋpäŋ Anututä kehäromi udewani äma keri terak peŋ yämiŋkuko unita wäpi yäpmäŋ akuŋpäŋ iniŋ oretkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesutä Kapeneam yotpärare peŋpeŋ kuŋtäŋgän Matiyu kaŋkuk. Matiyu uwä takis moneŋ yäpmäk-yäpmäk täŋo yot gänaŋ irirän kaŋpäŋ iwetkuk; Gäk u peŋpäŋ näk näwat! yäk. Iweränä uterakgän mani buramiŋpäŋ akumaŋ iwatkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Täŋpäŋ Jesu-kät ketem bok näna yäŋpäŋ ini yot gänaŋ yäŋikŋat yäpmäŋ äroŋkuk. Ude täŋirän takis moneŋ yäpani ämakät waki täŋpani yäŋ yäwerani äma ba Jesu iwaräntäkiye ukät penta itpäŋ ketem naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Naŋ irirä Parisi äma ätutä yabäŋpäŋ Jesu täŋo iwaräntäkiye ŋode yäwetkuŋ; Ai! Yäwoŋärewani ämajin u imata takis moneŋ yäpani ba äma wakiwaki täŋpani-kät penta itpäŋ ketem näyak? ");
INSERT INTO iou_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Man ude yäŋirä Jesutä nadäŋpäŋ ŋode yäwetkuk; Yäpätägak ämatä äma tägaken epän nämo täk täkaŋ. Käyäm ikek-kengän täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anututä bian ŋode yäŋkuk; Imaka imaka näk naniŋ oretta pek täkaŋ unita gäripi nämo nadäk täyat yäk. Ämawebe bänep iron kädet iwat täkaŋ unita uyaku gäripi-inik nadäk täyat. Eruk, in kuŋkaŋ man yäŋkuko unitäŋo mebäri kaŋ nadäwä tärewut. Äma inita näk äma siwoŋi yäŋ nadäk täkaŋ unita nämo äput. Ämawebe inita näk momi täŋpani yäŋ nadäk täkaŋ unita yäŋpäŋ äput. ");
INSERT INTO iou_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kadäni uken Jon ume ärut yämani unitäŋo iwaräntäkiye ätutä Jesutä itkuk-ken äbäŋpäŋ iwet yabäŋkuŋ; Ninkät Parisi ämatä Anutu nadäŋ imiŋpäŋ kadäni ätuta nakta jop it täkamäŋ. Upäŋkaŋ gäkŋo gäwaräntäkaye udegän nämo täk täkaŋ yäk. Imata kadäni kadäni ketem nak-nakgän täk täkaŋ? Anututa nämo nadäŋ imiŋkaŋ udewä täk täkaŋ ba? ");
INSERT INTO iou_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ude yäŋirä Jesutä man wärani ŋode yäwetkuk; Äma ätu noripaki wäpi biŋam ikek kubäkät oretoret terak kuŋatkaŋ imata butewaki nadäŋpäŋ nakta jop itneŋ? Nämoinik! Täŋpäkaŋ iwantä päbä äma uwä iŋit yäpmäŋ kuŋirä uyaku noriyetä wäyäkŋewä wawäpäŋ butewaki nadäŋpäŋ nakta jop itneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesutä ude yäŋpäŋ iniken man kudupi-kät Parisi äma täŋo man ukät bok nämo awähutneŋ yäŋpäŋ man wärani yarä ŋode yäwetkuk; Äma kubätä tek wewani bipa yäŋkaŋ tek moräk kodakipäŋ tek wewani uterak täga nämo peŋpäŋ bipek. Ude täŋkaŋä tek u äruränä tek kodaki unitä täpuri täŋpäŋä biani yäpmäŋ däkŋewek. ");
INSERT INTO iou_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Udegän, äma kubätä wain umeni api täŋpanipäŋ käbot tom gupipäŋ täŋpani biani kubä gänaŋ täga nämo piwek. Ude täŋpänä wain umeni api täŋpani unitäŋo kehäromitä täŋpewän tom gupi käbot biani kehäromi nämo u tumäŋpäŋ wain umeni ba käbori u bok jop awähutneŋ. Unita wain umeni api täŋpanipäŋ käbot kodaki kehäromi gänaŋ piweko uyaku täga yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesutä man ude yäŋ irirän käbeyä yot täŋo watä äma kubä wäpi Jairas unitä ahäŋpäŋ Jesu kaŋpäŋ gämori-ken gukut imäpmok täŋpäŋ ŋode iwetkuk; Äpetna apigän kumäŋtak yäk. Unita gäkä päŋku ketkatä iŋiriri äneŋi kodak taŋpäŋ akwän! ");
INSERT INTO iou_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ude iwetpäŋ imagurän yäpmäŋ kuŋirän iwaräntäkiye imaka yäwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kuŋirä webe kubä käyäm mebäri kubä nikek itkuk. Webe unitä nägät piŋ yäpmäŋ kuŋirän obaŋ 12 ude täŋkuk. Webe unitä Jesu mädeni-ken iwatpäŋ Jesu täŋo tekgän iŋirira käyämna paorän yäŋkaŋ päŋku mädeni-ken tekgän iŋitkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ude iŋirirän Jesu äyäŋutpäŋ webe u kaŋpäŋ ŋode iwetkuk; Wanotna! Bänepka-ken oretoret pähap nadäsi! Nadäkinikka näkken peyan unitä gäk yäpän tägatan yäk. Ude iweränä webe unitäŋo käyämi paotkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Ude täŋkaŋ kuŋtäŋgän Jairastä yotken ahäŋpäŋ nadäŋkuk. Yäŋtäbätet yäŋpäŋ konäm butewaki pähap täŋit äma ätu butewaki kap uhuwep terak piäŋit täŋirä yabäŋpäŋ Jesutä yäwetkuk; Peŋpeŋ akumaŋ kut! Webe gubaŋ u nämo kumak. Jop däpmon pätak yäk. Yäwänä kaŋ-mägayäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ude täŋpäkaŋ yäŋ-yäwat-pewän kudup akumaŋ kuŋirä webe gubaŋ unitä itkuk-ken uken äroŋkuk. Äroŋpäŋä kerigän iŋirirän akuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Täŋpänkaŋ unitäŋo biŋamtä komeni komeni kuŋat moreŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu yotpärare u peŋpeŋ kuŋirän äma dapuri tumbani yarätä gera ŋode yäŋtäŋ iwatkumän; Devit orani! Butewaki nadäŋ nimiŋpäŋ täŋkentäŋ nimi! yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yäwän nadäŋkaŋ Jesu yot kubä gänaŋ äroŋkuk. Äro irirän äma yarä unitä äbänä Jesutä yäwet yabäŋkuk; Dapunjek yäpä tägakta kehäromi pat namitak u nadäkinik täkamän? Yäweränä iwetkumän; Ei, nadäkinik täkamäk. ");
INSERT INTO iou_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yäwänä dapuri-ken yepmäŋitpäŋ yäwetkuk; Nadäkinikjek täŋo bureni ahäŋ tamän! ");
INSERT INTO iou_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ude yäŋirän dapuri ijiwän kuŋkuŋ. Dapuri ijiwän kuŋirä Jesutä yäniŋ bitnäŋpäŋ yäwetkuk; Täŋ tamitat ŋonita äma kubä iwetdeŋtawä! ");
INSERT INTO iou_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ude yäwetpäŋ yäniŋ bitnäŋkuko upäŋkaŋ mani nämo buramiŋkaŋ manbiŋam u yäŋahäŋpewän yäpmäŋ komeni komeni kuŋatkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ude täŋpäŋ yepmaŋpän äma yarä u kuŋirän äma ätutä äma mäjotä magät-pewän man nämo yäwani kubä Jesuken yäŋ yäpmäŋ äbuŋ. ");
INSERT INTO iou_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Äbäŋirä Jesutä mäjo äma magärani u iwat kireŋ imänkaŋ äma u man yäŋkuk. Äma unitä man yäŋirän ämawebe päke itkuŋo u kaŋkaŋ keri iŋpäŋ yäŋkuŋ; Imaka ŋodewani Isrel komeken nämo ahäŋirän kaŋpäŋ nadäwani yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ämawebetä ude yäŋirä Parisi ämatä ŋode yäŋkuŋ; U uwä mäjo täŋo intäjukun ämatä kehäromi imiŋirän mäjo yäwat kirek täyak! yäk. ");
INSERT INTO iou_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Täŋpäŋ Jesu yotpärare taŋi täpuri kudup kuŋatkuk. Kuŋatkaŋ käbeyä yot ini-ini äroŋpäŋ Anututä intäjukun it yämiŋirän gämoriken irit täŋo Manbiŋam Täga u yäwetpäŋ yäwoŋärek täŋit, paräm käyäm mebäri mebäri nikek yäpän tägaŋit täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ude täŋkaŋ ämawebe päke u yabäŋpäŋ butewaki nadäŋkuk. Ämawebe uwä nanak kodäŋani bumik, kehäromini nämo, nadäwätäk terak kuŋarirä yabäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yabäŋpäŋ iwaräntäkiye ŋode yäwetkuk; Epän taŋi kubä ahäŋ nimiŋirän käyat yäk. Epän it yäpmäŋ kukaŋ-ken uken ketem ahäŋ-bumbum täkaŋ. Upäŋkaŋ ketem u yäpmäkta epän äma yarägän. ");
INSERT INTO iou_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Unita epän mähemi-ken yäŋapiŋirä ketem gämäneŋ itkaŋ u yäpmäkta epän äma ätukät kaŋ pewän äbut. ");
INSERT INTO iou_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesutä iwaräntäkiye 12 u yäŋ-yäkŋat päbä kubä-kengän yepmaŋpäŋ mäjo yäwat kirekta ba käyäm paräm mebäri mebäri nikek yäpä tägakta kehäromi yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Iwaräntäkiye 12 unitäŋo wäpi tawaŋ ŋode; Kubä Saimon, wäpi kubä Pita. Kubä Andru, Saimon monäni u. Yaräwä Jems kenta Jon, Sebedi nanakiyat u. Kubä Filip. Kubä Batorom. Kubä Tomas. Kubä Matiyu, takis moneŋ yäpani u. Kubä Jems, Alfias nanaki. Kubä Tadius. Kubä Saimon Selot. Kubä Judas, Kariot komeken nanik, Jesu iwan keri terak peŋkuko u. ");
INSERT INTO iou_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ude täŋpäŋ Jesutä äma 12 u epän man ŋode yäwetkaŋ yäniŋ kireŋpewän kuŋkuŋ; In kuŋkaŋ guŋ ämawebe äbotken ba Samaria yotpärare it yäpmäŋ kukaŋ-ken u kuneŋtawä. ");
INSERT INTO iou_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","8","Isrel äma äbot kodäŋani bumik, watä ämani nämo, itkaŋ ukengän kuŋkaŋ man ŋode yäŋahäŋpäŋ kaŋ yäwerut; Nadäwut! Anututä intäjukun itkaŋ yabäŋ yäwat epän täŋpayäŋ täko u keräp täyak. Ude yäwerit, käyäm nikek yepmaŋpä tägaŋit, paräm mebäri mebäri nikek komi nadäŋ itkaŋ u yäpä tägaŋit, mäjo yäwat kireŋit ba äma kumbani yäpmäŋ päŋaku yepmaŋit kaŋ täk täŋput. Epän u täkta kehäromi jop tamitat, gwäki nämo unita in udegän täŋkentäk epän u gwäki nämo, jop kaŋ täŋtäŋ kut. ");
INSERT INTO iou_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Kuroŋjin ärärani ba ähottaba nämo yäpneŋ. Moneŋ nämo yäpmäŋ kuneŋ, yäk imaka nämo yäpneŋ. Ba tek yarä nikek nämo yäpneŋ, gupjin terak itkaŋ unitagän kaŋ kut. U imata, epän tänayäŋ täŋo unitäŋo kowata täga täŋkentäŋ taminaŋi. ");
INSERT INTO iou_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","In yotpärare kubäken ahäŋirä äma kubätä yori-ken yäŋ-täkŋat yäpmäŋ ärowänä ugän itpäŋ epän täŋ paotpäŋ kome kubäken kaŋ kut. ");
INSERT INTO iou_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Täŋpäkaŋ äma kubä täŋo yot gänaŋ äroŋkaŋä yot mähemi u ŋode kaŋ iwerut; Anutu täŋo bänep iron gäkken pat täyon! ");
INSERT INTO iou_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ude iwerirä not täŋ tamiŋirän intäŋo man unitä uken bureni api ahäŋ imek. Upäŋkaŋä not nämo täŋ tamiŋirän man iwetnayäŋ täkaŋ unitä uken bureni nämo api ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Äma kubä ba ämawebe yotpärare kubäken naniktä not nämo täŋ tamiŋirä ba intäŋo manta gaŋa tawäwä mäde ut yämiŋpeŋ kaŋ kut! Täŋpäkaŋ ämawebe uken naniktä momi nininken pätak yäŋ nadäkta kugun kuroŋjin terak nanik pewä maŋpäpeŋ kaŋ kut. ");
INSERT INTO iou_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Näk bureni täwetat. Kowata yäpmäk-yäpmäk kadäni-ken ämawebe yotpärare udewani-ken naniktä kowata Sodom Gomora naniktä yäpnayäŋ täŋo u irepmitpäŋ ärowani pähap api yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ude yäŋpäŋ yäŋkuk; In nadäkaŋ? Iwan bämopi-ken taniŋ kiretat yäk. Aŋ komitä but nanak däpmäŋpäŋ nak täkaŋ in udegän api tadäpmäŋpäŋ näneŋ. Unita in ket kaŋiwatpäŋ nadäŋit kaŋ kuŋarut. Upäŋkaŋ bänep kwini terak kuŋatpäŋ waki kubä täkta nämo nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bureni, in watäni ket itpäŋ kaŋ kuŋarut! Äma ätutä manken tepmaŋit käbeyä yot gänaŋ kadätä api tadäpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba ugän nämo, näka nadäkinik täk täkaŋ unita tämagut päŋku kome täŋo kaŋiwat äma ba intäjukun äma iŋamiken api tepmaneŋ. Tepmaŋpäpäŋ intäjukun äma u ba ämawebe guŋ äbotken nanik u näkŋo manbiŋam api yäwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kadäni uken yäŋ-täkŋat yäpmäŋ manken kuŋirä man jide yäwetnayäŋ nadäŋkaŋ nadäwätäk nämo täneŋ. Kadäni uken man ahäŋ tamiŋirän nadäŋpäŋ ugänpäŋ yäwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Täŋkaŋ man yänayäŋ täŋo uwä injinken man nämo, u Nanjin täŋo Munapiktä bänepjin-ken peŋirän api yäŋahäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Täŋpäkaŋ kadäni uken ämatä ŋode api täneŋ; Tuänitä monäni iwan keri-ken peŋirän kumäŋ-kumäŋ api utneŋ. Ba naniyetä nanakiye udegän api täneŋ. Ba äperiye nanakiyetä miŋiye naniye iwan täŋ yämiŋpäŋ manken yepmaŋirä kumäŋ-kumäŋ api däpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Täŋpäkaŋ in näka nadäkinik täŋpäŋ näwat täkaŋ unita ämawebe mäyaptä inta kokwawak api nadäŋ tamineŋ. Upäŋkaŋ äma kubätä gwäk pimiŋpäŋ näkŋo man nämo peŋkaŋ yäpmäŋ kuŋarayäŋ täko uwä tärek-tärek kadäni-ken näkŋata biŋam api yäpet. ");
INSERT INTO iou_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Täŋpäŋ yotpärare kubäken kuŋirä tadäpmäŋpäŋ täwatkirek täŋpäwä yotpärare kubäken metäŋpeŋ kuneŋ. Näk bureni täwetat. Isrel kome pat yäpmäŋ kuyak u nämo kuŋarä täreŋirän Äma Bureni-inik api ahäwek yäk. ");
INSERT INTO iou_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ude yäŋpäŋ yäŋkuk; Jide nadäkaŋ? Netätä intäjukun itak? Yäwoŋärek ämatä intäjukun itak ba nanakiyetä intäjukun itkaŋ? Bureni, yäwoŋärek ämatä intäjukun itak! Ba netätä intäjukun itak? Epän mähemitä intäjukun itak ba epän ämaniyetä intäjukun itkaŋ? Bureni, epän mähemitä intäjukun itak. ");
INSERT INTO iou_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Unita yäwoŋärek ämata waki täŋ imineŋo uwä, nanakiyeta udegän täŋ yämiŋirä ŋode nadäneŋ; Täga! Ekäninin udegän äworekamäŋ yäŋ nadäne. Täŋpäkaŋ Bilisibap yäŋ näwetkuŋo unita imata näwaräntäknaye in man waki nämo api täwetneŋ? Nämo, u man wakiinik api täwetneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Unita in äma udewanita nämo umuntaŋkaŋ näkŋo man kwawak yäŋahäneŋ. Imaka täŋ-yejämbani pätak u wari nämo api pärek. Anututä api täŋkwawa täwek. Ba imaka käbop itak u wari nämo api irek. Kwawak api pewek. ");
INSERT INTO iou_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jiap man niningän itkaŋ täwet täyat u äma äbot gänaŋ kwawakgän kaŋ yäŋahäwut! ");
INSERT INTO iou_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","In ämata nämo umuntäneŋ. Äma uwä gupjingän täga awähutneŋ, upäŋkaŋ mäjojin utta api täŋpä waneŋ. Unita in Anutu kubä unitagän umuntäneŋ. Unitä uyaku äma täŋo gupi bok, mäjoni bok täga awähurek. ");
INSERT INTO iou_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bureni täwetat; Ämata nämo umuntäneŋ. Anututä watä säkgämän it tamik täyak. Unita pakup barakta nadäwut. Barak u äpani-inik, biŋami nikek nämo upäŋkaŋ Nanjintä udewanita ket yabäŋ yäwat täyak. Kuŋat-kuŋari ba kumäk-kumäki yabäŋpäŋ-nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Upäŋkaŋ Anututä inta gäripi nadäk täyak uwä pakup barakta nadäk täyak u irepmitak unita täga nämo tepmaŋpek. Gwäkjin pujiŋ jide itkaŋ u kudup nadäk täyak. Unita imaka kubäta nämo umuntäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Man ude yäŋpäŋ äneŋi ŋode yäŋkuk; Äma kubätä ämawebe iŋamiken näk Jesuta nadäkinik täŋ imitat yäŋ yäwayäŋ täko uwä näkä udegän Nana kunum gänaŋ nanik u iŋamiken äma uwä näkŋata biŋam yäpmäŋtat yäŋ api yäŋahäwet. ");
INSERT INTO iou_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Täŋ, äma kubätä ämawebeta umuntaŋpäŋ näk Jesuta nämo nadätat yäŋ yäwayäŋ täko uwä näkä udegän Nana kunum gänaŋ nanik u iŋamiken äma ŋonita nämo nadätat yäŋ api iweret. ");
INSERT INTO iou_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","In näka ŋode nämo nadäneŋ; Uwä kome terak bänep kwini pewän ahäkta äpuk yäŋ nämo nadäneŋ. Näk bänep kwini pewa ahäkta nämo äput. Nämoinik! Näk komen ämawebe bämopi-ken duŋ-wewek pewa ahäkta äput. ");
INSERT INTO iou_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Näk ämawebe yäpmäŋ danikta äpuro unita man ŋode profet biani kubätä kudän täŋkuko u bureni api ahäwek; Yanani yarä duŋ-wewek api tädeŋ, ba yamiŋi yarä udegän api duŋ-wedeŋ. Ba yanäbeki yarä duŋ-wewek api tädeŋ. Ba äma kubä iniken noriyeinik-tä iwan api täŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ba äma kubäwä miŋi nanita gäripi taŋi nadäŋ yämiŋkaŋ näka täpuri nadäŋ namayäŋ täko uwä äma udewani näka biŋam nämo api täŋpek. Täŋpäkaŋ meŋ ba nan kubätä äperiye nanakiyeta gäripi taŋi nadäŋ yämiŋkaŋ näka täpuri nadäŋ namayäŋ täko uwä näka biŋam nämo api täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ba kubätä näkä komi päya kwakäp terak nadäwayäŋ täro udegän nadäkta umuntaŋpäŋ nämo näwarayäŋ täko uwä näka biŋam nämo api täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ba kubätä kome terak irit kuŋat-kuŋatta gäripi nadäŋpäŋ nadäkinik täŋpeŋ kuŋarayäŋ täko uwä irit kehäromi nämo api kaŋ-ahäwek. Täŋ, kubätä näka nadäkinik täŋ namiŋpäŋ kome ŋonitäŋo irit kuŋat-kuŋat mäde ut imayäŋ täko uwä irit kehäromi api yäpek. ");
INSERT INTO iou_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Täŋpäkaŋ äma kubätä oraŋ tamayäŋ täko uwä näk udegän api oraŋ namek. Ba näk oraŋ namayäŋ täko uwä näk naniŋ kireŋkuko u udegän api oraŋ imek. ");
INSERT INTO iou_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Täŋkaŋ kubätä Anutu täŋo man yäŋahäwani äma kubäta nadäŋ imayäŋ täko uwä gwäki Anutu täŋo man yäŋahäwani ämatä yäpmäk täkaŋ udegän api yäpek. Täŋpäkaŋ äma kubätä äma siwoŋi kuŋarani kubä kaŋ-ahäŋpäŋ ŋode nadäwek; A! Äma uwä siwoŋi kuŋarani unita täŋkentäŋ ima yäŋ nadäwek. Äma ude nadäwayäŋ täko uwä gwäki äma unitä yäpayäŋ täko udegän api yäpek. ");
INSERT INTO iou_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Näk bureni täwetat. Äma kubätä näwaräntäknaye äpani-inik kubä kaŋ-ahäŋpäŋ U Jesu täŋo iwaräntäki kubä yäŋ yäŋpäŋ ume gwetpäŋ imayäŋ täko uwä gwäki täga api yäpek. ");
INSERT INTO iou_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesutä iwaräntäkiye 12 epän man ude yäwerän täreŋirän kome u peŋpeŋ Anutu täŋo man yäwetpäŋ yäwoŋärek täŋpayäŋ yotpärare ätu tuän ittäŋ kuŋkuŋ-ken uken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kuŋirän Jon ume ärut yämani uwä komi yotken itkaŋ Jesutä epän täk täŋkuko u biŋam nadäŋkuk. Biŋam u nadäŋpäŋ iniken iwaräntäkiye yäwet-pewän päŋku Jesu iwet yabäk ŋode täŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Äbäkta biŋam yäwani uwä gäk ŋo ba? Ba kubäta itsämne? yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ude iwet yabäwäwä Jesutä ŋode yäwetkuk; Inä äyäŋutpäŋ päŋku imaka nadäŋit kaŋit täkaŋ ŋo, unitäŋo manbiŋam päŋku Jon kaŋ iwerut. ");
INSERT INTO iou_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Äma dapuri tumbani äneŋi ijiwä kuk täkaŋ. Kwäyähäneŋ täŋpani äneŋi tägaŋpeŋ kuŋat täkaŋ. Paräm wakiwaki tokŋewani tägaŋpäŋ gupi dudum tak täkaŋ. Ba jukuni täŋguŋ täwani nadäwä tumäk täkaŋ, ba kumbani kodak taŋpäŋ akumaŋ kuk täkaŋ. Ba äma jäwäri-jäwäri Manbiŋam Täga u yäwera nadäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ba äneŋi kubä ŋode kaŋ iwerut; Äma näka yäŋpäŋ nadäkiniki nämo pewä putärek täkaŋ uwä bänep oretoret terak kuŋat täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ude yäweränkaŋ Jon täŋo iwaräntäkiye u äneŋi äyäŋutpeŋ kuŋirä Jesutä ämawebe äbot päke u Jon täŋo täktäki ba kuŋat-kuŋarita manbiŋam ŋode yäwetkuk; Jon kome jopi-ken irirän känayäŋ nadäŋpäŋ kuŋkuŋo u äma jidewanipäŋ känayäŋ kuŋkuŋ? Pidäm eŋini bumik, mänittä piäŋpewän wareŋ-wareŋ täk täkaŋ, äma udewani känayäŋ kuŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba ima känayäŋ kuŋkuŋ? Äma tek säkgämän täŋpani käwep? Ude nämo! Äma udewani uwä äma wäpi nikektä yot gänaŋ it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Unita näwerut! Äma jidewani u känayäŋ kuŋkuŋ? Profet kubä käwep känayäŋ kuŋkuŋ? Bureni, profet kubä kaŋkuŋo upäŋkaŋ Jon uwä profet inipärik kubä. ");
INSERT INTO iou_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Täŋkaŋ Anutu täŋo man ŋode kudän täwani uwä Jonta kudän täwani; Näkŋo biŋam yäŋahäwani äma kubä ŋo yäk. Intäjukun kädet täwit gamikta api iniŋ kirewet yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Unita näk bureni täwetat; Jon täŋo wäpi biŋamtä äma it yäpmäŋ äbuŋo unitäŋo wäpi biŋam yärepmit moretak. Upäŋkaŋ ämawebe äpani Anututä intäjukun it yämiŋpäŋ yabäŋ yäwat täyak unitäŋo wäpi biŋamtä Jon täŋo wäpi biŋam irepmitak. ");
INSERT INTO iou_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon intäjukun äbä Anututä yabäŋ yäwat epän täk täyak unitäŋo manbiŋam yäŋahäŋ yäpmäŋ äbuk. Apiŋo udegän nähä manbiŋam ugänpäŋ yäŋahäk täyat. Upäŋkaŋ äma waki ätutä mannata bitnäŋpäŋ Anutu täŋo kaŋiwat yewa gänaŋ äroŋpäŋ itta kädet ukät-pipinayäŋ täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses ba Profet biani kuduptä manbiŋam ŋode yäŋahäŋ yäpmäŋ äbuŋ; Anutu täŋo iwoyäwani äma ahäŋpäŋ Anutu täŋo yabäŋ yäwat epän api yäput pewek yäk. Manbiŋam u yäŋahäŋ yäpmäŋ abäŋtäko Jonken täreŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ba man kubä ŋode yäŋahäŋkuŋ; Profet kubä Elaija udewani api ahäwek! yäŋ yäŋkuŋ. Unita näk man täwetat ŋo nadäkinik täŋput! Profet Elaijatä äbäkta yäŋkuŋo uku Jon äbätak ŋo. ");
INSERT INTO iou_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Äma jukuni nikektä näkŋo man ŋo ket nadäwut! yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ämawebe äbot itkaŋ ŋonita jide yäwet? Uwä iroŋiroŋi täŋoret bägup-ken itkaŋ kowat yäwän ŋode täk täkaŋ ude bumik; ");
INSERT INTO iou_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Niwerä oretoret kap teŋitna gukut nämo tokät täŋkuŋ. Ba niwerä butewaki kap teŋitna, konäm nämo kotkuŋ yäŋ yäk täkaŋ. Täŋpäkaŋ in uwä udewani, nadäk siwoŋi kubägän nämo peŋkaŋ ŋode täŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon uwä äbäŋkaŋ ketem äma ätutä nak täkaŋ ude nämo naŋkuk ba wain ume imaka, nämo naŋkuk. Täŋirän intä kaŋpäŋ yäŋkuŋ; U mäjotä kotawani! ");
INSERT INTO iou_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Täŋ, Äma Bureni-iniktä äbäŋpäŋ ketem naŋit wain ume naŋit täŋkuk. Täŋirän intä kaŋpäŋ yäŋkuŋ; Äma ŋo kawut! Nak ämäŋ täŋpani! yäk. Uwä äma waki-waki-kät takis moneŋ yäpani täŋo noripaki! yäŋ yäŋkuŋ. Upäŋkaŋ in nämo nadäwä tumbäkaŋ ude yäk täkaŋ. Äma yarä unitä Anutu täŋo nadäk-nadäk siwoŋi iwatpäŋ täk täkamän. Täŋpäkaŋ nadäk-nadäk u iwatpäŋ täktäki siwoŋitä Anutu täŋo nadäk-nadäk kwawak pewän ahäŋirän ämawebetä kaŋpäŋ nadäwä bureni api täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kadäni uken Jesutä yotpärare ätuken epän täŋit kudän kudupi imaka täŋit täŋ yäpmäŋ äbäŋirän kaŋpäŋ bänepi nämo sukureŋkuŋo unita yabäŋ yäŋpäŋ ŋode yäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wa! Korasin nanik in, ba Betsaida nanik in komi api nadäneŋ! Inken kudän kudupi täk täŋkuro udegän Tire Sidon ämawebe, Anututa nämo nadäwani u ahäŋ yämiŋkuk yäwänäku mominita yäŋpäŋ konäm butewaki täŋpäŋ bänepi bian sukurewäm! ");
INSERT INTO iou_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Unita bureni ŋode täwera nadäwut; Ämawebe yäpmäŋ danik-danik kadäni pähapken Tire ba Sidon ämawebe kowata ahäŋ yämayäŋ täko u irepmitpäŋ inä ärowani-inik api kaŋ-ahäneŋ! ");
INSERT INTO iou_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Täŋ, Kapeneam nanik inä, Anututä kunum gänaŋ api yäŋnikŋat yäpmäŋ ärowek yäŋ nadäkaŋ? Wära! Nämoinik! In kumäŋ-kumäŋ komeken api äpmoŋ moreneŋ. Näkä kudän kudupi inken täk täŋkuro u Sodom komeken ahäŋkuk yäwänäku ämawebe momini peŋirä Anututä kome nämo awähurän. Nämo, pen kadäni käroŋi it yäpmäŋ kuk täyek. ");
INSERT INTO iou_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Unita Juda äma in ŋode täwera nadäwut; Kowata yäpmäk-yäpmäk kadäni-ken ämawebe yotpärare udewani-ken naniktä kowata waki ärowani api yäpneŋ. In Sodom naniktä yäpnayäŋ täŋo u irepmitpäŋ ärowani pähap api yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kadäni uken Jesutä nani ŋode iwetkuk; Nana, kunum kenta kome täŋo mähemi gäka bänep täga nadäŋ gamitat. Imata, gäk manka biŋam täŋo mebäri äma kome täŋo nadäk-nadäk ärowani nikekta käbop peŋ yämik täyan. Täŋ, äma äpanita täŋ-kwawataŋ yämik täyan. ");
INSERT INTO iou_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nan, gäkŋa ude kaŋ ahäwän yäŋ nadäŋkuno udegän ahätak yäk. ");
INSERT INTO iou_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ude yäŋpäŋ ämawebe päke u ŋode yäwetkuk; Nana uwä imaka kumän-tagän näk ketna terak peŋ moreŋkuk. Täŋpäkaŋ äma kubätä Anutu täŋo nanaki näka täga nämo nadäwän tärek täkaŋ. Nämo, Nana kubä-tägän mebärina nadäwän tärek täkaŋ. Ba äma kubätä ini Nana täŋo mebäri u nämo nadätak. Nämo, nanaki näkŋa-tägän nadätat. Täŋ, Nanaki näkä äma ätuta Nana täŋo mebäri yäwoŋärewayäŋ yäŋpäŋä yäwoŋäreŋira Nana täŋo mebäri täga nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jesutä ude yäŋpäŋ äneŋi ŋode yäwetkuk; Ämawebe in bäräpi kotaŋkaŋ nadäwätäk pähap täk täkaŋ uwä näk-kengän äbut! Näkken äbäŋirä bäräpi ketäreŋ tamiŋira itpäŋ-nadäk täkot. ");
INSERT INTO iou_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Näkken äbäŋkaŋ epän tamakaŋ u bok täŋpäŋ uyaku näkŋo mebärina nadäwä tärenayäŋ. Näk orakorak mähemi, näk bänep kwini ba äpani kuŋat täyat. Näkken äbäŋpäŋä nadäwätäk ikek nämo api kuŋatneŋ. Bureni, epän ketjin-ken pek täyat u pipiri nämo yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eruk Sabat kadäni kubäken Jesu inikät iwaräntäkiye säguom epän gänaŋ kuŋatkuŋ. Kuŋattäŋgän iwaräntäkiyetä nakta yewäwä säguom weŋpäŋ naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Weŋpäŋ naŋirä Parisi äma ätutä u yabäŋpäŋ Jesu iwetkuŋ; U kawut! Orekirit kadäni-ken gäwaräntäkayetä epän täkaŋ uwä nämo tänaŋipäŋ täkaŋ. U nintäŋo baga man irepmitpäŋ täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iweräwä Jesutä kowata ŋode yäwetkuk; Ude nämo! Bian oranin Devit u noriye-kät nakta yewäpäŋ täŋkuŋo unitäŋo manbiŋam Anutu täŋo man terak nämo daniŋpäŋ nadäk täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uwä ŋode täŋkuŋ; Devit u noriye-kät Anutu täŋo yot gänaŋ äroŋpäŋ käräga kudupi yäŋ yäwani u yäpmäŋpäŋ naŋkaŋ noriyeta imaka, yämän naŋkuŋ. Täŋkaŋ käräga uwä bämop äma-tägän nänaŋipäŋ naŋkuŋ. Äma jopitä udewani nakta yäjiwärani upäŋkaŋ Devit u noriye-kät naŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Täŋpäŋ in Baga man terak kudän täwani ŋode imaka nämo daniŋpäŋ nadäk täkaŋ ba? Bämop äma uwä Sabatken kadäni kadäni kudupi yot gänaŋ äroŋpäŋ Sabat täŋo baga irepmitpäŋ epän täk täkaŋ. Baga irepmit täkaŋ upäŋkaŋ waki täk täkaŋ yäŋ nämo yäwet täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Unita näkä ŋode täwera nadäwut; Iŋamjin-ken itat ŋonitä kudupi yot irepmitat. ");
INSERT INTO iou_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anututä man kubä yäŋkuko uwä ŋode kudän täwani; Gupe ijik-ijik näk naniŋ oretta pek täkaŋ unita gäripi nämo nadäk täyat. Ämawebetä bänep iron kädet iwarirä unita uyaku gäripi-inik nadäk täyat. In man u nadäŋpäŋ yäwänäku näwaräntäknaye momini nämo ŋo man nämo yäweräm. ");
INSERT INTO iou_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nadäkaŋ? Äma Bureni-inik uwä Sabat täŋo mähemi. ");
INSERT INTO iou_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Ude yäŋpäŋ peŋpeŋ kumaŋ käbeyä yot gänaŋ äroŋpäŋ äma kubä keri kukŋi täŋguräŋ täwani uken irirän kaŋkuk. Kawänä Juda täŋo ekäni ätutä Jesu u goret kubä täŋpän kaŋpäŋ manken tena yäŋkaŋ iwet yabäŋkuŋ; Sabat kadäni-ken äma kubätä käyäm ikek yäpän täganeŋo u baga irepmirek ba nämo irepmirek? ");
INSERT INTO iou_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ude yäŋirä Jesutä kowata ŋode yäwetkuk; Jide? Inken nanik kubätä yawaki tepi kubätä awaŋ gänaŋ äpmoŋirän Sabat unita yäŋpäŋ kaŋäwaräkuk täŋpek? Nämo, topmäŋpäŋ wädäwek! ");
INSERT INTO iou_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Täŋkaŋ yawak uwä imaka jopi udewani. Äma uyaku bureni. Unita Sabat kadäni-ken täŋkentäk epän uwä täga täŋpen. ");
INSERT INTO iou_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ude yäŋpäŋ äma keri täŋguräŋ täwani u iwetkuk; Ketka täŋ-siwoŋta! yäk. Ude iweränä keri täŋ-siwoŋ taŋirän tägaŋpäŋ keri kukŋi täga udegän itkuk. ");
INSERT INTO iou_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Täŋirän Parisi ämatä u kaŋpäŋä peŋpeŋ päŋku käbeyä täŋpäŋ Jesu kaŋ utna yäŋ yäŋpäŋ man topuŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Täŋpäkaŋ Jesu Baga man nadäwanitä man topuŋo u nadäŋpäŋ kome u peŋpeŋ kubäken kuŋkuk. Kuŋirän ämawebe mäyap iwarän täŋkuŋo u gänaŋ käyäm ikek u kudup yäpän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ude täŋpäŋ ämawebe päke unitä mebärini yäŋahäkta yäjiwät-inik täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ude täŋirän Profet Aisaiatä man bian ŋode kudän täŋkuko u bureni ahäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ŋowä epän ämanata näkŋa iwoyäŋkut yäk. Ŋowä näkŋaken bänepna gämäni. U kaŋpäŋ gäripi nadäk täyat. Uterak Munapikna peŋ ima täŋkentäŋ imiŋirän ämawebe Anutu täŋo äbot nämo täŋpani kuduptagän näkŋo kädet siwoŋi iwatta yäwetpäŋ yäwoŋärek api täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uwä yäŋawät-awät ba yabäŋ kärakŋek nämo api täŋpek. Ba mani kotäk kädet miŋin-miŋin gera yäŋpäŋ yäk täŋirän nämo api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bänep kwini terak api kuŋarek. Uwä tepäraŋ kujat pidämi kubä nämo tokärek ba kädäp täpuri ijiŋirän nämo däpän kumneŋ. Täŋpäkaŋ epäni täŋ yäpmäŋ kuŋirän kädet siwoŋi säkgämän api ahäŋ morewek. ");
INSERT INTO iou_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Täŋpäŋ ämawebe äbot nämo täŋpani kuduptagän bänepi wäpi biŋam terakgän api wohutneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Täŋpäkaŋ kadäni uken äma kubä mäjotä magärani kubä Jesuken yäpmäŋ äbuŋ. Äma uwä mäjotä magärirän dapuri tumbänpäŋ guŋ taŋkuk. Guŋ taŋpäŋ man imaka, nämo yäk täŋkukonik. Eruk äma upäŋ Jesuken yäpmäŋ äbäkaŋ yäpän tägaŋ-pewän dapun ijiŋit man yäŋit täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ude täŋirän ämawebe päke itkuŋo u kaŋpäŋ kikŋutpäŋ jäkjäk yäŋkuŋ. Täŋpäŋ yäŋkuŋ; Wära! Devit täŋo orani äbäkta yäŋkuŋo ukeŋo ŋo käwep yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ude yäŋirä Parisi ämatä nadäŋpäŋ ŋode yäŋkuŋ; Jop yäkaŋ! Mäjo täŋo äma ekäni wäpi Bilisibap unitä magärirän mäjo yäwat kirek täyak! yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ude yäŋirä Jesutä bänepi-ken yabäŋpäŋ-nadäŋkaŋ yäwetkuk; Man wärani kubä täwera nadäwut; Äbot kubätä duŋ-wewek täŋpäŋä kehäromi itneŋ ba nämo? Nämo! Ba yotpärare kubätä duŋ-wewek täŋpäwä tägawek ba nämo? Ba ini buaptä duŋ-wewek täŋpäŋ ämik täŋpäwä tägawek? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Unita ŋode täwetat; Satantä iniken ämaniye yäwat kireweko uwä jide täŋpäŋ Satan täŋo äbot kehäromi nikek irek? U täga nämo irek! ");
INSERT INTO iou_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Intä Näkä Satan täŋo kehäromi terak mäjo yäwat kirek täyat yäŋ näwetkaŋ upäŋkaŋ näkä ude bureni täyat u täŋpäwä intäŋo ämajiyetä netä wäpi terak mäjo yäwat kirek täkaŋ? Satan täŋo wäpi terak yäwat kirek täkaŋ yäŋ täga nämo yäneŋo unita jop täŋ-näkŋatkaŋ unitäŋo mebäri kwawak ahätak! ");
INSERT INTO iou_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Näk Anutu täŋo Munapiktä täŋkentäŋ namiŋirän täk täyat unita ŋode nadäneŋ; Anututä intäjukun it yämiŋirän gämoriken irit täŋo bureni inken ahätak ŋo. ");
INSERT INTO iou_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Näk Satan täŋo kehäromi yäpmäŋ äpäk täyat unitäŋo man wärani kubä ŋode täwera nadäwut; Äma komi kubä yori gänaŋ irirän äma kubätä siwani yäŋkaŋ päro tuŋumi täga yomägarek? Nämo! Äma komi u bäyaŋ iŋitpäŋ yentä keri kuroŋi pädät täŋpäŋ peŋkaŋ uyaku tuŋumi täga yomägarek. ");
INSERT INTO iou_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nadäkaŋ? Äma not nämo täŋ namik täkaŋ uwä iwan täŋ namik täkaŋ. Ba äma näkŋo epänta watä nämo it täkaŋ uwä epäna yäpäwak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Unita ŋode täwera nadäwut; Waki mebäri mebäri ba yäŋärok man mebäri mebäri näk näwet täkaŋ unitäŋo momi u täga penaŋi. Upäŋkaŋ äma kubätä Kudupi Munapikta man waki ba yäŋärok man iwereko uwä momi u penaŋi nämo. ");
INSERT INTO iou_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bureni, äma kubätä Äma Bureni-inikta yäŋärok man yäwayäŋ täko uwä momini u täga ärut imek. Täŋ, äma kubätä Kudupi Munapikta yäŋärok man yäwayäŋ täko uwä momini nämoinik api ärut imek. Nämo, u pen api pat imek yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Täŋpäŋ Jesutä äneŋi ŋode yäkgän täŋkuk; In päya kubäta täga yäŋ nadäŋpäŋä burenita udegän täga yäŋ nadäneŋ. Ba päya kubäta waki yäŋ nadäŋpäŋ burenita udegän waki yäŋ nadäneŋ. Päya täŋo mujipi kaŋpäŋ nadäŋpäŋ päya uwä täga ba waki yäŋ nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wa! Gämok täŋo äbotken nanik in jide täŋpäŋ man täga kubä yäneŋ? Nämo, nadäk, äma bänepi-ken pat täyak u meni-ken kwawak pewä ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Äma täga täŋpani u bänepi-ken nadäk tägatäga unitä irit kuŋat-kuŋariken kädet täga pewä ahäk täkaŋ. Täŋ, äma waki täŋpani u bänepi-ken nadäk wakiwaki unitä irit kuŋat-kuŋariken kädet waki pewä ahäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Upäŋkaŋ näk ŋode täwera nadäwut; Ämawebe yäpmäŋ danik-danik kadäni pähapken man waki mebäri mebäri bian yäŋ yäpmäŋ äbuŋo unita yäŋpäŋ Anututä manken api tepmaŋpek. ");
INSERT INTO iou_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","In kome terak kuŋatkaŋ man yäŋ yäpmäŋ kunayäŋ täŋo uwä Anututä nadäwän täga ba waki api täneŋ. Waki täŋpänä manken api tepmaŋpek. Täga täŋpänä Anututä api tämagurek yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesutä man ude yäweränä Parisi ämakät Baga man yäwoŋärewani äma ätu itkuŋo unitä Jesu man kowata ŋode iwetkuŋ; Yäŋpäŋ-yäwoŋärewani! Kudän kudupi kubä mebärika kaŋpäŋ nadäkta täŋiri käna! yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ude yäwäwä Jesutä yäwetkuk; Wa! Waki täŋpani ämawebe äbot intä kudän kudupi kubä kakta näwet yabäkaŋ? Upäŋkaŋ kudän kudupi mebäri kubä nämo täŋira känayäŋ! Ŋodegän api käneŋ; Kudän bian profet Jona terak ahäŋkuko udegän ahäŋirän api käneŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona uwä kepma bipani yaräkubä gwägu tom pähap koki gänaŋ patkuk. Udegän Äma Bureni-inik uwä kepma bipani yaräkubä kome gänaŋ api pärek. ");
INSERT INTO iou_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Täŋpäkaŋ ämawebe Ninive yotpärare-ken naniktä udegän, kowata yäpmäk-yäpmäk kadäni-ken inkät bok api itneŋ. Ämawebe uwä intäŋo momijin kwawak api pewä ahäneŋ. U jop nämo, Jonatä man yäwerän Ninive ämawebetä nadäŋpäŋ bänepi sukureŋkuŋ. Upäŋkaŋ äma Jonatä täŋkuko u irepmitak uwä itat ŋo! ");
INSERT INTO iou_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ba kowata yäpmäk-yäpmäk kadäni-ken kome umude käda nanik täŋo intäjukun webe unitä inkät Anutu iŋamiken bok itkaŋ momijin kwawak api pewän ahäneŋ. Webe unitä Juda täŋo intäjukun äma Solomon unitäŋo nadäk-nadäk ärowani yäŋahäŋirän nadäkta gäripi nadäŋkuko unita kome ban naniktä kädet käroŋi-inik äbuk. Täŋpäkaŋ äma Solomontä täŋkuko u irepmitak uwä itat ŋo! ");
INSERT INTO iou_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Täŋpäŋ Jesutä man äneŋi kubä ŋode yäwetgän täŋkuk; Äma äbot ŋowä ŋode bumik. Mäjo äma magärani kubätä äma u kakätäŋpeŋ päŋku kome kuräki-ken irit bägup kodakita wäyäkŋeŋtäŋ kuŋareko upäŋkaŋ nämo kaŋ-ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nämo kaŋ-ahäŋpäŋä yäwek; Bian itkut-ken äyäŋutpeŋ kwa yäŋ yäwek. Ude yäŋpäŋ äyäŋutpeŋ päŋku käwek; Irit bägup biani uwä ärutpäŋ ket urani, mähemi nämo. ");
INSERT INTO iou_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ude kaŋpäŋä noriye 7 ini bumik nämo, wakiinik, yämaguränkaŋ äbä ukengän itneŋ. Täŋpäkaŋ äma uwä pengän-inik waki irekopäŋ mäden waki inikinik täŋpäŋ irek yäk. Eruk, äma äbot waki ŋo äbot udegän api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Täŋpäŋ Jesu man pen yäwet irirän miŋi-kät noriye man iwetnayäŋ äbä yäman umu itsämbuŋ. ");
INSERT INTO iou_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Täŋirä äma kubätä Jesu iwetkuk; Ai! Meŋka notkaye man gäwetnayäŋ yäman itkaŋ gumo yäk. ");
INSERT INTO iou_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yäwänä Jesutä ŋode yäŋkuk; Meŋna netä? Ba notnaye u netä? ");
INSERT INTO iou_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ude yäŋpäŋ iwaräntäkiyetä itkuŋ-ken u käda ketsiwoŋ taŋpäŋ yäŋkuk; Yabäwut! Näkŋo meŋnaye notnaye ŋo! ");
INSERT INTO iou_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ämawebe Nana kunum gänaŋ nanik täŋo man buramik täkaŋ uwä näkŋo meŋnaye notnaye ba wanotnaye bureni yäk. ");
INSERT INTO iou_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kepma ukengän Jesu yot gänaŋ naniktä äpämaŋ päŋku gwägu gägäni-ken maŋit itkuk. ");
INSERT INTO iou_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Maŋit irirän ämawebe äbot pähap ahäŋpäŋ tokŋewä yabäŋpäŋä gäpe terak äroŋkuk. Äro gäpe terak irirän ämawebe bumta gwägu pomi terak itkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Irirä man wärani mebäri mebäri yäwetkuk. Yäwetkaŋ man wärani kubä ŋode yäwetgän täŋkuk; Äma kubätä ketem mujipi pikta epäni-ken päŋku mujipi täŋ-irähuttäŋ kwek. ");
INSERT INTO iou_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Täŋ-irähuttäŋ kuŋirän mujipi ätu kädet miŋin mäneŋ. Kädet miŋin mäneŋo uwä baraktä yabäŋ ahäŋpäŋ naŋ paotneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Täŋkaŋ mujipi ätuwä kome taŋi nämo, gänaŋ umu mobä, uterak maŋ tädotneŋ. Kome u pidämigän, gänaŋ umu mobä unita jäwäri punin itkaŋ bäräŋeŋ tädotneŋ. Bäräŋeŋ tädotneŋo upäŋkaŋ edaptä yeŋpewän kubit täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Täŋ, mujipi ätuwä mup waki gänaŋ mäneŋ. Mup waki gänaŋ maŋirä mup waki unitä äroŋpäŋ uwäk täŋpipiŋ-pewä waŋpäŋ bureni nämo pätneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Täŋpäkaŋ mujipi ätuwä kome gakŋi nikekken mäneŋo uwä täga äroneŋ. Äroŋpäŋ bureni ätu ähan pätneŋ. Ätuwä taŋi bumik pätneŋ. Täŋ, ätuwä bumta pätneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesutä ude yäŋpäŋ yäŋkuk; Äma jukuni nikektä näkŋo man ŋo ket nadäwut! ");
INSERT INTO iou_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesutä ude yäwänä iwaräntäkiyetä ŋode iwet yabäŋkuŋ; Imata man wärani terak yäwet täyan? ");
INSERT INTO iou_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yäwäwä ŋode yäwetkuk; Anututä intäjukun itkaŋ yabäŋ yäwat epän täk täyak unitäŋo manbiŋam käbop irani u injingän nadäkta yäwani unita in-gänpäŋ täwetat. Äma ätukät nadäkta nämo. ");
INSERT INTO iou_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Unita ket ŋode täwera nadäwut; Äma kubätä imaka Anututä imani u yäpmäŋ kuŋarayäŋ täko uwä yäpurärätpäŋ bumta imikta yäwani. Täŋ, äma ätuwä nin imaka udewani nikek yäŋ nadäk täkaŋ upäŋkaŋ nämo! Täŋpäkaŋ imaka iŋitkamäŋ yäŋ jop nadäk täkaŋ uwä yäyomägatta yäwani. ");
INSERT INTO iou_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mebäri unitagän man wärani terak yäŋpäŋ-yäwoŋärek täyat. Man wärani terak yäwetpewa dapuritä känayäŋ täŋo upäŋkaŋ nämo api kawä tärewek. Ba jukunitä nadänayäŋ täŋo upäŋkaŋ mebäri nämo api nadäwä tumneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Man täwetat ŋo man profet biani Aisaiatä ŋode kudän täwani udegän; Jukujin täwä api nadäneŋo upäŋkaŋ bänepjintä nämo api nadäwä täreneŋ. Dapunjintä api ijineŋo upäŋkaŋ nämo api kawä täreneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ämawebe äbot ŋo bänepi nämo imärani. Jukuni pik täŋpani ba dapurita pimiŋ ijiwani. Bänepi sukureŋirä uyaku yäpa tägawäpäŋ yepmaŋpam. Upäŋkaŋ ude täneŋtawä yäŋkaŋ näkä täŋpewa dapuritä nämo kawä tärek täkaŋ ba jukunitä nämo nadäwä tärek täkaŋ, ba bänepitä nadäkinik nämo täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aisaiatä äma äbot ŋonita ude yäŋkuko upäŋkaŋ Anututä nadäŋ tamiŋirän inä dapunjintä kawä tärek täkaŋ ba jukujintä nadäwä tärek täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Näk bureni täwetat. Anutu täŋo kehäromi kak täkaŋ uwä profet biani ba äma siwoŋi kuŋarani mäyaptä u kakta gäripi nadäk täŋkuŋo upäŋkaŋ nämo kak täŋkuŋ. Ba manbiŋam apiŋo intä nadäk täkaŋ ŋo nadäkta gäripi nadäk täŋkuŋo upäŋkaŋ nämo nadäk täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Eruk notnaye, mujipi pikpik täŋo man wärani täwetkuro unitäŋo mebäri täwerayäŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mujipi täŋ-irähuttäŋ kuŋirän kädet miŋin mäneŋo u jidewani? Mujipi uwä ŋode; Äma kubätä Anutu täŋo yewa gänaŋ ärokärok täŋo man nämo nadäwän tumbeko uwä äma wakitä bänepi-ken mujipi piwani u yomägat yäpmäŋ kwek. ");
INSERT INTO iou_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Täŋ, mujipi kome pidämi, gänaŋ umu mobä uterak mäneŋo u jidewani? Uwä ŋode; Äma kubätä näkŋo manbiŋam kudupi nadäŋpäŋ ukengän gäripi nadäŋpäŋ yäpmäŋ kuŋarek. ");
INSERT INTO iou_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Upäŋkaŋ bänepi-ken jäwäri nämo täŋpani unita kadäni keräpigän irek. Täŋpäkaŋ näkŋo manta yäŋpäŋ ämatä yäŋärok man iwerit iwan täŋ imiŋit täŋpäwä, nadäkiniki bäräŋeŋ putärewek. ");
INSERT INTO iou_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Täŋ, mujipi mup waki gänaŋ mäneŋo u jidewani? U äma kubätä näkŋo man kudupi u nadäŋpäŋ bänepi-ken daiŋpäŋ yäpmäŋ kuŋareko uwä kome täŋo tuŋumta nadäwätäk täŋpäŋ moneŋ tuŋum täŋbumbum unitäŋo gäriptä täŋikŋat-pewä näkŋo man kudupi u utpewän kumäŋirän bureni nämo täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Täŋ, mujipi kome gakŋiken piweko u jidewani? Uwä ŋode; Äma kubätä näkŋo man kudupi nadäŋpäŋ bänepi-ken peŋpäŋ täŋkehärom taŋpäŋ yäpmäŋ kuŋarek. Täŋpäkaŋ äma ätuken bureni ähan pätneŋ. Ätukenä taŋi bumik pätneŋ. Täŋ, ätukenä bumta pätneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ude yäwet paotpäŋ äneŋi man wärani kubä pen ŋode yäwetkuk; Äbot Anututä intäjukun it yämiŋpäŋ yabäŋ yäwarayäŋ täyak uwä ŋode bumik; Äma kubätä ketem mujipipäŋ yäpmäŋ päŋku epäni-ken piwek. ");
INSERT INTO iou_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ketem mujipi piŋkaŋ päŋku parirän bipani ugän iwanitä epän uken päŋku mup mujip, ketem mujipi epän mähemitä piweko ukengän täŋ-irähuttäŋ kwek. ");
INSERT INTO iou_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ude täŋpeŋ kuŋirän mujipitä imätpäŋ käruk äbäŋirä mup mujip waki iwantä täŋ-irähuttäŋ kweko u bok tädotneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tädorirä epän watä ämaniyetä u yabäŋpäŋ epän mähemi iwetneŋ; E! Gäk epänka-ken ketem mujipi tägagänpäŋ piŋkun yäk. Piŋkunopäŋ mup waki äbäkaŋ u jide täŋpäŋ bok ärokaŋ? ");
INSERT INTO iou_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yäwäwä yäwerek; Uwä iwan kubätä piŋkukotä ärokaŋ. Yäwänä iwetneŋ; Mup waki u nintä dätne? ");
INSERT INTO iou_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yäwäwä epän mähemitä yäwerek; Nämo! In mup waki dätna yäkŋat ketem mujipi piwani u bok dätneŋta yäk. ");
INSERT INTO iou_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ketem mujipi piwani bok mup waki ini bok kaŋ ärowut. Äroŋirä ketem bureni yäpmäk-yäpmäk kadäni-ken ketem bureni yäpani äma yäwerakaŋ yäpmäŋ daniŋpäŋ mup waki däpmäŋpäŋ kädäp gänaŋ pewä ijiwäkaŋ ketem bureni nakta yäwani ugänpäŋ yotna gänaŋ kaŋ pewut yäŋ yäwerek. ");
INSERT INTO iou_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ude yäŋpäŋ man wärani kubä pen ŋode yäŋkuk; Äbot Anututä intäjukun it yämiŋpäŋ yabäŋ yäwat täyak u päya mujipi kubä wäpi mastat udewani. Ämatä mastat mujipi uwä epänken pik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mujipi u täpuri, päya mujipi ätu täŋo gämori-ken itkaŋ. Upäŋkaŋ tädotpäŋ äroŋkaŋ tokän ätu yärepmit täkaŋ, päya bumik ärok täkaŋ. Äroŋpäŋ taŋi täŋpäŋ pähämi obät täk täkaŋ. U momi terak baraktä yori täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ude yäŋpäŋ yäŋkuk; Man wärani kubä ŋode. Äbot Anututä yabäŋ yäwat täyak u yis udewani. Webe kubätä käräga täŋpa yäŋkaŋ yis täpuri yäpmäŋpäŋ parawa taŋi-kät awähurek. Ude täŋirän yistä parawa kudup gänaŋ kuŋatkaŋ epäni täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesutä man yäwet täŋkuko uwä man wäranigän yäwet täŋkuk. Man kwawak kubä nämo yäŋahäŋpäŋ yäwet täŋkukonik. ");
INSERT INTO iou_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ude täŋirän profet kubätä man ŋode yäŋkuko u bureni ahäŋkuk; Näk ämawebe man yäwerayäŋ nadäŋpäŋä man wäranigän api yäk täŋpet. Man käbop kome ahäŋkuk-ken unitä it yäpmäŋ äbuko uwä api yäŋahäwet. ");
INSERT INTO iou_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ude yäŋpäŋ eruk Jesutä äma yepmaŋpän kuŋ moreŋirä yot gänaŋ äroŋkuk. Päro irirän iwaräntäkiyetä iwet yabäŋkuŋ; E! Saguom epän gänaŋ iwantä mup mujip täŋ-irähuttäŋ kuŋkuko unita mebäri yäŋahäwi nadäna yäk. ");
INSERT INTO iou_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ude iweräwä yäŋkuk; Äma säguom mujipi piŋkuko uwä Äma Bureni-inik. ");
INSERT INTO iou_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Epäni uwä kome pähap ŋo. Ketem mujipi piŋkuko uwä ämawebe Anututä yabäŋ yäwat täyak. Täŋ, mup waki uwä äma waki Satan täŋo äboriye. ");
INSERT INTO iou_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ba iwanä, epänken mup waki piŋkuko u Satan. Saguom yäpmäk-yäpmäk kadäni uwä tärek-tärek kadäni pähap. Täŋpäkaŋ ketem bureni yäpani äma uwä Anutu täŋo aŋeroniye. ");
INSERT INTO iou_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mup waki dätpäŋ kädäp-ken pewä kuŋkuŋo uwä tärek-tärek kadäni-ken ude api ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Kadäni uken Äma Bureni-iniktä aŋeroniye yäwerän päŋku komeni komeni ämawebe yabäŋ yäwat täyak u yäpmäŋ daniŋpäŋ ämawebe kädet siwoŋi yäpäwak täŋpani ba ämawebe wakiwaki täŋpani yäpmäŋpäŋ kädäp pähap gänaŋ yepmaŋpä api äpmoneŋ. Uken konäm butewaki pähap täŋpäŋ meni api jiwätpeŋ itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Täŋpäkaŋ ämawebe Anututä inita yäpmäŋ daniwayäŋ täyak uwä yewani gänaŋ itkaŋ kudän siwoŋi täŋ yäpmäŋ äbuŋo unitä edap ude api ijiŋ-yäŋeneŋ. Eruk, äma jukuni nikektä näkŋo man ŋo ket nadäwut! ");
INSERT INTO iou_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesutä man ude yäŋpäŋ man wärani kubä pen ŋode yäkgän täŋkuk; Äma ätu Anutu täŋo yewa gänaŋ ärokta gäripi-inik nadäk täkaŋ uwä ŋode bumik; Kadäni kubä äma kubätä epän tobät kubäken kuŋatkaŋ tuŋum säkgämän kubä ämatä bian-inik pewani u kaŋ-ahäwek. Kaŋ-ahäŋpäŋ yäwek; Wisikna! Näkŋata korewayäŋ nadätat yäk. Jide täŋpäŋ yäpet? Ude yäŋpäŋ tuŋum u yäpmäŋkaŋ kome ini ukengän äneŋi käbop pewek. Eruk peŋkaŋ päŋku iniken tuŋum kuduptagän ämata yämiŋpäŋ moneŋ yäpek. Moneŋ yäpmäŋkaŋ kome, tuŋum säkgämän kaŋ-ahäweko u inita suwaŋkaŋ tuŋum uwä yäpek. ");
INSERT INTO iou_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesutä ude yäŋpäŋ man wärani kubä pen ŋode yäwetgän täŋkuk; Eruk, äma ätu Anutu täŋo yewa gänaŋ ärokta gäripi-inik nadäk täkaŋ uwä ŋode bumik; Äma kubätä omäk tägatäga yäpmäkta wäyäkŋek epän täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kadäni kubäken äma uwä omäk tägagämän-inik kubä kaŋ-ahäwek. Ude kaŋpäŋ nadäŋkaŋ päŋku iniken tuŋum kudup ämata yämiŋpäŋ moneŋ yäpmäŋkaŋ päŋku omäk tägagämän-inik u suwawek. ");
INSERT INTO iou_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesutä ude yäŋpäŋ man wärani kubä pen ŋode yäwetgän täŋkuk; Anututä ämawebe intäjukun it yämiŋpäŋ yabäŋ yäwarayäŋ täyak uwä ŋode bumik; Ämatä yäk gwägu tom yäpani pewä gwägu gänaŋ äpmoŋirän gwägu tom mebäri mebäri u gänaŋ äpmoneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Äpmoŋpäŋ tokŋeŋirä gägäni-ken wädäŋ-pewä äbäŋirän tom yäpmäŋ daniŋpäŋ gwägu tom näŋpani gäpe-ken säkgämän peŋkaŋ waki, nämo näŋpani äneŋi ureŋ täŋpä gwägu gänaŋ äpmoneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Tärektärek kadäni-ken ude api ahäwek. Uken Anutu täŋo aŋeroniyetä komeni komeni kuŋatpäŋ ämawebe yäpmäŋ daniŋpäŋ äma siwoŋi kuŋarani inigän peŋkaŋ äma wakiwaki täŋpani kädäp pähap gänaŋ ureŋ täŋpä api äpmoneŋ. Uken konäm butewaki pähap täŋpäŋ meni api jiwätpeŋ itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesutä ude yäŋpäŋ iwaräntäkiye yäwet yabäŋkuk; In man wärani yäro u mebäri nadäwä tumäŋkaŋ? Yäwänä yäŋkuŋ; Nadäna tumäŋkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ude yäŋirä yäwetkuk; Inä Anutu täŋo man yäŋpäŋ-yäwoŋärek äma ude itkaŋ. Anututä yabäŋ yäwat epän täk täyak unitäŋo man kädetta mebäri nadäk täkaŋ unita in yot mähemi kubä udewani. Yot mähemi uwä yori gänaŋ äroŋpäŋ tuŋum käwut-ken nanik tuŋum biani bok kodaki bok yäpmäŋpäŋ äbot kubä-kengän pewek. Täŋpäkaŋ in udegän, Anutu täŋo man biani nadäŋit, apiŋo Anutu täŋo man kädet kodaki täwetpäŋ täwoŋäretat u nadäŋit täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu u man wärani mebäri mebäri yäŋkä yäŋ paotpäŋ yotpärare u peŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kumaŋ päŋku ini yotpärare-ken ahäŋpäŋ käbeyä yot gänaŋ äroŋpäŋ Anutu täŋo man yäwetpäŋ yäwoŋärek täŋirän ämawebetä nadäwä inide kubä täŋpäpäŋ yäŋkuŋ; Nadäk nadäk pähap ba kudän kudupi täkta kehäromi u de yäpuk? ");
INSERT INTO iou_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Unitäŋo mebäri nadäkamäŋ. U äma jopi, yot täŋpani täŋo nanak yäk. Miŋi wäpi nadäkamäŋ, u Maria. Noriye imaka, nadäkamäŋ, u Jems, Joses, Saimon kenta Judas yäk. ");
INSERT INTO iou_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ba wanoriye ninkät penta it täkamäŋ ŋo. Upäŋkaŋ imaka kudän kudupi täkta kehäromi ba nadäk-nadäk pähap u de yäpuk? ");
INSERT INTO iou_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ude yäŋpäŋ nadäwä waŋkuŋ. Ude täŋirä Jesutä yäwetkuk; Komeni komeni ämawebe Anutu täŋo epän äma oraŋ yämik täkaŋ upäŋkaŋ ini komeken nanik ba noriye miŋiye naniye u bitnäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Täŋpäkaŋ ämawebe kome u naniktä Jesuta nadäkinik nämo täŋkaŋ bitnäwäpäŋ kome uken kudän kudupi mäyap nämo täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kadäni uken Galili kome täŋo äma ekäni wäpi Herot unitä Jesu täŋo biŋam nadäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nadäŋpäŋ epän ämaniye ŋode yäwetkuk; Uwä Jon ume ärut yämani bian kumäŋ-kumäŋ utkuropäŋ äneŋi käwep akuŋkuko unita kehäromi nikek kuŋatak yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herottä Jon u bian kumäŋ-kumäŋ utkuko unitäŋo manbiŋam ŋode; Bian Herot uwä noripaki Filip täŋo webeni wäpi Herodias yomägatkuk. Ude täŋirän Jontä iwetkuk; Ai! Notkapak webeni yomägatan u goret täyan yäŋ iweränpäŋ Herottä kokwawak nadäŋpäŋ epän ämaniye yäwerän keri kuroŋi pädät täŋpäŋ päŋku komi yot gänaŋ teŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herottä Jon kumäŋ-kumäŋ urayäŋ nadäŋkukopäŋ ämawebetä Jon u äma täga, profet kubä yäŋ nadäŋkuŋo unita umuntaŋpäŋ nämo utkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Täŋkukopäŋ Herot iniken ahäk-ahäk kadäni täŋirän äŋnak-äŋnak täŋpa yäŋpäŋ äma wäpi biŋam ikek uken-uken nanik yämagutkuk. Yämagut päbä yepmaŋpän irirä Herodias täŋo äperitä äma wäpi biŋam ikek itkuŋo u iŋamiken kap, kuroŋ täŋpäŋ teŋirän kaŋkuŋ. Kaŋpäŋ gäripi nadäŋpäŋ Herottä webe gubaŋ u man kehäromi ŋode iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bureni gäwetat. Näkken imaka it namikaŋ u kubä nam yäŋ yäwiwä api ganiŋ kirewet yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ude yäŋirän webe gubaŋ uwä miŋitä peŋ iwerirän ŋode yäŋkuk; Gäk Jon kotäki madäŋ täkŋeŋpäŋ gwäki gäpe gänaŋ peŋkaŋ pengän namikaŋ wisik yäŋ kaŋ yäwa! yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","11","Ude yäŋirän Herottä nadäwätäk täŋkuk. Upäŋkaŋ Anutu iŋamiken ba äma itkuŋo u iŋamiken yäŋkehärom taŋkuko unita epän ämaniye yäwet-pewän päŋku Jon komi yot gänaŋ irirän kotäki madäŋ täkŋeŋpäŋ gäpe gänaŋ peŋpäŋ yäpmäŋ päbä imiŋkuŋ. Imäkaŋ webe gubaŋ unitä miŋi Herodiasta imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Täŋpäkaŋ Jon u kotäki madäŋkuŋ-ken u parirän iwaräntäkiyetä päbä yäpmäŋ päŋku äneŋkuŋ. Äneŋkaŋ päŋku Jesu manbiŋam iwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesutä Jon kotäki madäŋkuŋo unitäŋo manbiŋam nadäŋkaŋ gäpe gänaŋ äroŋpäŋä kome kubäken äma nämo irani-ken inipärik irayäŋ nadäŋpäŋ kuŋkuk. Kuŋirän ämawebe Jesu ude kuk yäŋ nadäŋkaŋ ämawebe uken-uken nanik yotpärareni peŋpeŋ Jesutä irayäŋ kuŋkuk-ken u päŋku it kireŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Täŋirä kome uken ahäŋpäŋ gäpe terak naniktä äpä ämawebe äbot pähap u yabäŋpäŋ butewaki nadäŋ yämiŋkuk. Täŋkaŋ käyäm paräm ikek yäpän tägaŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ude täŋ irirän kome bipänä iwaräntäkiyetä iwetkuŋ; Ŋo jopi-ken itkamäŋ. Iritna kome bipayäŋ täyak. Unita ämawebe ŋo yepmaŋpi ini komen komen kuŋpäŋ ketem yäpmäŋpäŋ naŋput yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ude yäwäwä Jesutä yäŋkuk; A! Imata kut yäŋ yäwetkaŋ? Injin yepmäŋ towiwurä! ");
INSERT INTO iou_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ude yäweränä yäŋkuŋ; Ninä käräga 5kät gwägu tom yarä-gänpäŋ iŋitkamäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ude iweräwä Jesutä yäwetkuk; U näka namut yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ude yäŋpäŋ ämawebe yäwet-pewän wädan gänaŋ maŋit yäpmäŋ kuŋkuŋ. Täŋirä käräga 5 u ba gwägu tom yarä u yäpmäŋpäŋ kunum terak doraŋpäŋ ketemta Anutu bänep täga man iwetkuk. Bänep täga man iwetkaŋ ketem u tokätpäŋ yäpmäŋ daniŋpäŋ iwaräntäkiyeta yämiŋkuk. Yämänkaŋ unitä yäpmäŋpäŋ ämawebe päke unita yämiŋtäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Täŋpäkaŋ ämawebe kudup naŋpä koki täŋpäpäŋ ätu jop peŋkuŋ. Täŋpäkaŋ jop patkuŋo u yäpmäŋpäŋ yäk 12 ude daiwä tokŋeŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ämawebe Jesutä yepmäŋ towiŋkuko uwä 5,000 ude. Täŋpäkaŋ u äma ekäni-gänpäŋ daniwani, webe iroŋi-kät nämo. ");
INSERT INTO iou_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","23","Eruk, Jesutä iwaräntäkiye yäniŋ kireŋpewän gäpe terak äromaŋ gwägu udude käda intäjukun kuŋkuŋ. Kuŋirä Jesutä ämawebe yepmaŋpän kuŋ moreŋirä Jesu inigän pom terak äroŋpäŋ nani-kät man yäŋpäŋ-nadäk täŋkumän. Ude täŋ irirän kome bipmäŋirän Jesu inigän-inik itkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Täŋpäŋ kaŋkuk; Gäpe iwaräntäkiyetä yäpmäŋ kuŋkuŋo u kumaŋ gwägu bämopi-ken ahäŋkuk. Ahäŋirän gäpetä kwayäŋ täŋkuk käda mänit taŋi pähaptä äbuk. Täŋirän gwägutä taŋi tokätpäŋ gäpe gänaŋ äpmoŋpayäŋ täŋkuk. Ude täŋirän kuna yäkŋat pipiri pähap täŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","26","Bipani käroŋ pipiri pähap ude täŋ irirä kome yäŋeŋkuk. Yäŋewänä iwaräntäkiye pen ude täŋ irirä Jesutä yabäŋpäŋ gwägu terak yeŋtäŋ kuŋirän bankentä kaŋpäŋ yäŋkuŋ; Yäke-e! Mäjo kubä äbätak! yäŋ yäŋpäŋ kähän yäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ude yäŋirä Jesutä yäniŋ bitnäŋpäŋ yäwetkuk; Umuntäneŋo. Näkŋa äretat yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ude yäwänä Pitatä nadäŋpäŋ iwetkuk; Ekänina! Gäkŋa äbäŋpäŋä yäwikaŋ näk gwägu terak gäkä äbätan udegän ärewa! yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yäwänä Jesutä iwetkuk; Äbiwä! yäk. Äbi yäŋ iweränkaŋ Pitatä gäpe terak naniktä äpämaŋ gwägu terak yeŋtäŋ Jesutä itkuk-ken kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yeŋtäŋ kuŋtäŋgän mänit pähap piäŋirän gwägu tokärän kaŋkaŋ umuntaŋpäŋ gwägu gänaŋ äpmoŋpayäŋ täŋkuk. Täŋpäŋ gera yäŋkuk; Wära! Ekäni gäk nepmäŋit yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yäwänä uterakgän Jesutä keri iŋitpäŋ iwetkuk; Gäk nadäk-nadäkka äreyäwani! Imata bänep yarä nikek peyan? ");
INSERT INTO iou_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ude iwetpäŋ iŋiränkaŋä gäpe terak äroŋirän mänit u bitnäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Täŋirän äma gäpe terak itkuŋo unitä Jesu gämori-ken gukut imäpmok täŋpäŋ iniŋ oretkuŋ. Täŋpäŋ ŋode iwetkuŋ; Gäk Anutu täŋo iroŋi bureni-inik! yäk. ");
INSERT INTO iou_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eruk ude täŋpäŋ gwägu irepmitpäŋ Genesaret kome gwägu gägäni-ken ahäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ahäŋpäŋ irirä ämawebe ätu Jesu kaŋpäŋ nadäŋpäŋ man pewä yäpmäŋ yotpärare it yäpmäŋ kuŋkuŋo ude kuŋatkuk. Kuŋarirän ämawebe käyäm ikek yäŋ-yäkŋat yäpmäŋ Jesuken äbuŋ. ");
INSERT INTO iou_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Äbäŋpäŋ Jesu butewaki man ŋode iwetkuŋ; Nadäŋ yämiŋiri tekka moräkigän iŋirirä käyämi paorut yäŋ iwetkuŋ. Ude iwerä nadäŋ yämiŋirän käyäm ikek teki moräkigän iŋitkuŋo u kudup tägaŋ moreŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kadäni uken Jerusalem yotpärare-ken nanik Parisi ba Baga man yäwoŋärewani äma ätutä Jesuken ahäŋpäŋ ŋode iwet yabäŋkuŋ; ");
INSERT INTO iou_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Gäwaräntäkaye imata oraniye täŋo man kädet irepmit täkaŋ? U ketem näna yäŋpäŋ keri nämo ärutkaŋ jop yäpmäŋpäŋ nak täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ude yäwäwä Jesutä kowata ŋode yäwetkuk; In imata orajiye täŋo man kädet iwatpäŋ Anutu täŋo baga man irepmit täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anututä bian ŋode yäŋkuk; Gäk meŋka nanka oraŋ yämen. Ba kubä ŋode; Äma kubätä miŋi nani yebewänä kumäŋ-kumäŋ utneŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Inä man bureni u nadäkaŋ upäŋkaŋ u mäde ut imiŋpäŋ ŋode yäk täkaŋ; Äma kubätä imaka täga kubäta miŋi nani täŋkentäŋ yämikta yäwekopäŋ ŋode yäwerek; Ŋo ekta taminaŋipäŋ ek jop irirän Anututa biŋam peyat yäŋ yäwerek. Wa! Miŋi nani nämo nadäŋ yämiŋpäŋ ude yäweko uwä in täga täyan yäŋ iwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","In ude täŋpäŋ Anutu täŋo man yäpmäŋ äpäŋkaŋ injinken man meham täk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jop manman yäwani inta profet biani kubä wäpi Aisaia unitä man Anututä nadäk-nadäki-ken peŋirän ŋode yäŋkuko uwä bureni ahätak; ");
INSERT INTO iou_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","Äma äbot ŋo menitä näk naniŋ oret täkaŋ upäŋkaŋ bänepitä näka bitnäk täkaŋ. Äma täŋo baga mangän iwat täkaŋ unita naniŋ orerirä näk nämo nadäŋ yämik täyat. ");
INSERT INTO iou_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesutä man ude yäŋpäŋ ämawebe ätu yäŋ yäŋ-yäkŋat päbä yepmaŋpäŋ yäwetkuk; Man ket ŋode täwera nadäwä tärewut; ");
INSERT INTO iou_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Imaka mejin gänaŋ äpmok täkaŋ unitä bänepjin nämo täŋpänwak täkaŋ. Imaka bänepjin-ken naniktä äbämaŋ mejin-ken äbäk täyak unitä täŋpewän bänepjin wak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ude yäwänä iwaräntäkiyetä dubini-ken kuŋpäŋ iwetkuŋ; Gäk nadätan? Gäk man u yäŋiri Parisi ämatä nadäŋpäŋ gäka kokwawak nadäkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ude yäŋirä Jesutä yäŋkuk; Päya kudup Nana kunum gänaŋ naniktä nämo piŋkuko uwä däyamäŋpäŋ api buŋärek. ");
INSERT INTO iou_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","In Parisi äma mäde ut yämik täkot. Uwä dapuri tumbanitä noriye dapuri tumbani kädet yäwoŋärek täkaŋ. Upäŋkaŋ äma dapuri tumbani yarätä keri kowat iŋirän täŋkaŋä kuŋtäŋgän awaŋ gänaŋ bok äpmodeŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jesutä ude yäwänä Pitatä iwetkuk; Gäk man wärani niwetan unitäŋo mebäri yäwi nadäna yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yäwänä Jesutä yäŋkuk; Ai! In udegän, man yäŋira nämo nadäwä tumäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mebäri ŋode nämo käwep nadäk täkaŋ; Mejintä imaka naŋirä kokjin gänaŋ päpmo ini irani-ken itkaŋä käderi-kengän äpämaŋ kuk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Täŋpäkaŋ imaka waki bänepjintä nadäk täkaŋ unitä bänepjin täŋpänwak täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Äma bänepitä imaka wakiwaki ŋode pewän ahäk täkaŋ; Nadäwäwak, ämik, kubokäret, kubo, äma yäniŋ wärät man, ba jop manman. ");
INSERT INTO iou_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Imaka udewanitä Anutu iŋamiken täŋpewän wak täyak yäk. Täŋpäkaŋ ketjin nämo ärutkaŋ ketem piŋitpäŋ nak täkaŋ unitä bänepjin nämo täŋpänwak täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesutä ude yäŋpäŋ kome u peŋpeŋ Kenan kome, yotpärare yarä wäpi Tire kenta Sidon itkumän-ken ukäda kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Päŋku irirän guŋ äbotken nanik webe kubä, kome uken nanik unitä päbä Jesuta gera ŋode yäŋkuk; Ekäni! Gäk Devit täŋo oranitä näka butewaki nadäŋ nam! Näkŋo äpetnawä mäjo kubätä kotawänkaŋ komi pähap nadäŋ it täyak yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ude yäwänä Jesutä nadäŋpäŋ man kowata kubä nämo iwetkuk. Ude täŋirän iwaräntäkiyetä Jesu dubini-ken kuŋpäŋ iwetkuŋ; Gäk webe ŋo yäŋ iwatpewi kwän! U yäŋ-urukuruk yäŋtäŋ niwatak yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yäwäwä Jesutä yäwetkuk; Anutu Nantä näk Isrel äma äbot, peŋ awähutpeŋ kuŋarani, ugänpäŋ täŋkentäkta näwerän äput yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Täŋpäkaŋ webe u ehutpäŋ äbä Jesu dubini-ken gukut imäpmok täŋpäŋ yäŋkuk; Ekäni, gäk jop waki täŋkentäŋ nam! ");
INSERT INTO iou_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ude iweränä Jesutä iwetkuk; Nanak täŋo ketem yäyomägatpäŋ aŋta yämiwä nämo tägawek. ");
INSERT INTO iou_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ude iweränä webe unitä iwetkuk; Bureni yäyan upäŋkaŋ aŋä mähemiyetä ketem naŋkaŋ kokoki pewä maŋirä jop waki nak täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ude yäwänä Jesutä iwetkuk; Wanotna, nadäkinikka taŋi! Unita näwet yabätan udegän täŋ gamitat. Ude yäŋirän uterakgän äperi tägaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ude täŋpäŋ Jesu kome u peŋpeŋ Galili gwägu-ken päŋku pom kubä terak päro maŋit itkuk. ");
INSERT INTO iou_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Maŋit irirän ämawebe bumta Jesu känayäŋ äbuŋ. U käyäm mebäri mebäri ŋode täŋpani yäŋ-yäkŋat yäpmäŋ äbä Jesu dubini-ken yepmaŋkuŋ; Kuroŋi waki, dapuri tumbani, kwäyähäneŋ täŋpani ba man nämo yäwani ba käyäm ikek ätu Jesu dubini-ken yäpmäŋ äbäŋirä Jesutä kudup yäpän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yäpän tägawäpäŋ yepmaŋpän man nämo yäwanitä man yäŋkuŋ. Ba kwäyähäneŋ täŋpanitä kädet ini kuŋatkuŋ. Täŋpäŋ äma kehäromini nämotä kehäromi yäpuŋ. Ba dapuri tumbanitä dapun ijiŋkuŋ. Ude täŋpäkaŋä ämawebe päke unitä yabäŋpäŋ jäkjäk yäŋpäŋ nadäwätäk pähap täŋkuŋ. Ude täŋpäŋ Isrel nanik täŋo Anutu bumta iniŋ oretkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Täŋpäkaŋ Jesu uwä iwaräntäkiye yäŋ-yäkŋat päbä yepmaŋpäŋ yäwetkuk; Näk ämawebe päke ŋonita butewaki nadätat. Ninkät kepma yaräkubä it yäpmäŋ abäŋkä nakta bumta yekaŋ. Täŋirä jop yepmana päŋku kädet miŋin nakta kumneŋ yäŋpäŋ nadäwätäk täyat yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ude yäwänä iwaräntäkiyetä iwetkuŋ; Kome jopi-ken ŋodeken ketem deken yäpmäŋpäŋ äma äbot pähap ŋodewani yepmäŋ towina naŋ tokŋeneŋ? ");
INSERT INTO iou_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ude iweräwä Jesutä yäwet yabäŋkuk; Injinken däkum jide itkaŋ? Yäwänä iwetkuŋ; Käräga 7kät gwägu tom yarä yäk. ");
INSERT INTO iou_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ude iwerä nadäŋkaŋ ämawebe päke u yäwet-pewän maŋit yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ude täŋirä käräga 7 ukät gwägu tom yarä u yäpmäŋpäŋ Anutu-ken bänep täga man yäŋpäŋ iwaräntäkiyeta yämiŋkuk. Yämänkaŋ unitä yäpmäŋ daniŋpäŋ ämawebe päke unita yämiŋ yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yämäkaŋä ämawebe päke u naŋpä koki täŋpäpäŋ ätu jop peŋkuŋ. Jop patkuŋo u yäpmäŋpäŋ yäk 7 ude daiwä tokŋeŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Täŋpäkaŋ äma ketem naŋkuŋo u 4,000 udetä naŋkuŋ. Webe iroŋi-kät nämo daniwani. ");
INSERT INTO iou_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eruk ude täŋkaŋ ämawebe u yepmaŋpän kuŋirä Jesu ini uwä gäpe terak äromaŋ kuŋtäŋgän Magadan komeken ahäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Eruk Magadan komeken ahäŋpäŋ irirän Parisi ämakät äma Satyusi äbotken nanik ätutä äbäŋpäŋ Jesutä goret kubä täŋpän kaŋpäŋ manken kaŋ tenayäŋ nadäŋpäŋ peŋ iwetkuŋ; Ai! Gäk kudän kudupi kubä täŋiri kaŋpäŋ Anututä gepmaŋpän äpun yäŋ nadäna! yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ude yäwäwä yäwetkuk; In kome täŋo kudän ŋode yabäŋpäŋ-nadäk täkaŋ; Bipäda kome gämäni ijiŋirän kwep edap api ijiwek yäŋ yäk täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ba yäŋewänkaŋ tamimaŋ gubam kubiri gwägärirän iwän taŋi tawayäŋ yäŋ yäk täkaŋ. Täŋpäŋ in kome täŋo kudän jopi udewani yabäŋpäŋ-nadäk täkaŋ upäŋkaŋ näk kudän kudupi täŋ yäpmäŋ äburo unitäŋo mebäri imata nämo kaŋpäŋ nadäk täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","In nadäkaŋ? Waki täŋpani ämawebe äbot intä kudän kudupi yabäkta näwet yabäk täkaŋ. Upäŋkaŋ kudän kudupi mebäri kubä nämo täŋira känayäŋ! Nämo, kudän bian profet Jona terak ahäŋkuko udegän ahäŋirän api käneŋ. ");
INSERT INTO iou_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Täŋpäŋ iwaräntäkiye käräga däkum guŋ taŋpäŋ peŋpeŋ Jesu-kät gäpe terak äroŋpeŋ gwägu kukŋi udude käda kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Päŋku itkaŋ Jesutä yäwetkuk; In Parisi ämakät Satyusi äbotken nanik täŋo yista ket nadäŋpäŋ kaŋ kuŋarut! ");
INSERT INTO iou_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ude yäwänä iwaräntäkiyetä näwetgäwet ŋode täŋpäŋ yäŋkuŋ; Yista yäyak u imata yäyak? Käräga guŋ taŋpäŋ peŋpeŋ äbämäŋo unita käwep nadäŋpäŋ niwetak yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Man ude yäŋirä Jesutä nadäŋpäŋ yäwetkuk; Wa! Nadäkinikjin kwini. In imata käräga peŋpeŋ äbäŋo unita man yäŋpäŋ-nadäk täkaŋ? Unita nämo yäyat. ");
INSERT INTO iou_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Näkä imaka bian täŋkuro unita täŋguŋ täkaŋ ba? In imata guŋ taŋpäŋ näwetgäwet täkaŋ? Näk käräga 5 upäŋ äma 5,000 ketem yepmäŋ towiwa naŋpä tägawäpäŋ ketem jop patkuŋo u yäk jide daiwä tokŋeŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ba käräga 7 upäŋ äma 4,000 yepmäŋ towiŋira naŋpä koki täŋpäpäŋ ketem jop patkuŋo u yäk jide daiwä tokŋeŋkuŋ? ");
INSERT INTO iou_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Unita in imata nämo nadäwä tärekaŋ? Näk yis yäro uwä kärägata nämo täwetat. Parisi ämakät Satyusi äbotken nanik täŋo kädet kuŋat-kuŋatta yäŋpäŋ yis terak utpäŋ täwetat. Äma u nämo yäwarän täneŋ yäŋpäŋ man u täwetat. Unitäŋo nadäk-nadäk waki unita ket kaŋiwatpäŋ kaŋ kuŋarut yäŋ ude nadäŋpäŋ täwetat. ");
INSERT INTO iou_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Man ude yäweränkaŋ eruk nadäwä tärewäpäŋ yäŋkuŋ; Bureni! Yis, käräga-kät awähurani unita nämo niwetak. Parisi ämakät Satyusi äbot täŋo man yäkyäki ba kädet kuŋat-kuŋarita ket kaŋiwatpäŋ kaŋ kuŋarut yäŋ yäŋpäŋ niwetak yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesutä ude yäŋpäŋ iwaräntäkiye yäŋ-yäkŋat yäpmäŋ Sisaria Pilipai komeken kuŋkuk. Kuŋtäŋgän Jesutä kädet miŋin iwaräntäkiye ŋode yäwet yabäŋkuk; Ämawebetä Äma Bureni-inikta netä yäŋ iwet täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yäwänä iwetkuŋ; Ätutäwä Jon, ume ärut yämani yäŋ yäk täkaŋ. Ba ätutäwä profet biani Elaija yäŋ yäk täkaŋ. Täŋ, ätutäwä Jeremaia ba profet biani ätu uken nanik kubä yäŋ yäk täkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ude yäwäwä Jesutä yäwetkuk; Täŋpäkaŋ injinä näkawä netä yäŋ yäk täkaŋ? ");
INSERT INTO iou_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yäwänä Saimon-Pita unitä iwetkuk; Gäk Kristo, Anutu Irit Mähemi unitäŋo nanaki yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yäwänä Jesutä ŋode iwetkuk; Saimon, Jona täŋo nanaki, gäka gäripi nadätat! Nadäk-nadäkka uwä ämaken naniktä nämo ahätak. Nana kunum gänaŋ naniktä yäŋkwawa täŋ gamitak. ");
INSERT INTO iou_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ude yäŋpäŋ iwetkuk; Bureni ŋode gäwera nadä; Wäpka Pita yäŋ gäwet täkaŋ u mebäri mobä unita gäkä terak äbotnaye yepmaŋpa kehäromi irirä äma waki täŋo kehäromitä nämo api däpek. ");
INSERT INTO iou_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Täŋpäŋ näk Anutu täŋo kaŋiwat yewa unitäŋo yäma därani täŋo ki api gamet. Ude täŋkaŋä gäkä imaka kubä kome terak nämo yäniŋ kireŋiri Anututä kunum gänaŋ udegän nämo api yäniŋ kirewek. Täŋ, gäkä imaka kubä kome terak yäniŋ kireŋiri Anututä kunum gänaŋ udegän api yäniŋ kirewek yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ude yäŋpäŋ iwaräntäkiye yäjiwät man kehäromi ŋode yäwetkuk; Intä näka Anutu täŋo iwoyäwani äma Kristo yäŋ ämawebe nämoinik yäwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kadäni uken Jesutä yäput peŋpäŋ imaka ahäŋ imikta yäŋ imani unita iwaräntäkiye yäwetkuk; Näk komi pähap api nadäwet. Täŋpäkaŋ Juda täŋo äma ekäni ba bämop äma intäjukun täŋpani-kät Baga man yäwoŋärewani ämatä mäde api ut namineŋ. Täŋkaŋ nutpäŋ änenayäŋ täŋopäŋ kepma yaräkubä täreŋirän kodak taŋpäŋ äneŋi api akwet. ");
INSERT INTO iou_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ude yäweränä Pitatä Jesu inipärik yäŋikŋat päŋku ibeŋpäŋ yäŋkuk; Ekäni, Anututä täŋkentäŋ gamiŋirän imaka udewani nämoinik api ahäŋ gamek yäk. ");
INSERT INTO iou_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yäwänä äyäŋutpäŋ Pita ŋode iwetkuk; Satan, gäk kewe! Gäk kädet täŋpipiŋ nameno! Nabä kätäŋpeŋ ku! Gäk man yäyan uwä Anutu-ken nanikpäŋ nämo yäyan. Uwä äma gäkŋaken mangänpäŋ näwetan yäŋ iwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Täŋpäkaŋ Jesutä iwaräntäkiye ŋode yäwetkuk; Äma kubätä näk näwarayäŋ nadäŋpäŋä iniken bänep nadäk-nadäki mäde ut imiŋpäŋ bäräpi näkä kotawayäŋ täyat udegän päya kwakäpi buramiŋkaŋ gwäk pimiŋpäŋ kaŋ näwarän. ");
INSERT INTO iou_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Täŋpäkaŋ, äma kubätä säkgämän kaŋ irayäŋ nadäŋkaŋ iniken irit kuŋat-kuŋarita iyap taŋpäŋä u api paorek. Upäŋkaŋ äma kubätä näka yäŋpäŋ irit kuŋat-kuŋari iniŋ kirewayäŋ täko uwä irit täga api kaŋ-ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Täŋ, äma kubätä kome täŋo imaka kudup peŋ bäyaŋpäŋ yäpmäŋ kuŋarayäŋ täko uwä kumäŋirän imaka imakani unitä irit kehäromi kakta täga nämo api täŋkentäŋ imineŋ. Unita irit kehäromi kaŋ-ahäkta imatäkenpäŋ täga suwawek? Nämoinik! ");
INSERT INTO iou_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jesutä ude yäŋpäŋ äneŋi ŋode yäŋkuk; Äma Bureni-inikä nani täŋo epmäget kudän ikek kudupi aŋeroniye-kät api äpneŋ. Äpäŋpäŋ ämawebe kuduptagän kädet jide jide täŋpeŋ kuŋat täkaŋ uterakgän kowata api yämek. ");
INSERT INTO iou_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Näk bureni täwera nadäwut; Itkaŋ ŋo inken nanik ätu nämo kumäŋirä Äma Bureni-inik intäjukun äma täŋo kudän ikek äpäŋirän api kaŋpäŋ nadäneŋ yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eruk Jesu kepma 6 ude it yäpmäŋ kuŋtäŋgän Pitakät noripakiyat Jems Jon u yäŋ-yäkŋat yäpmäŋ pom kubä terak äroŋkuk. Uken päro inigän itkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Itpäŋ kaŋirä Jesu gupi inide kubä ahäŋkuk. Iŋami dapuntä edap dapuri täŋo peŋyäŋek ude äworeŋkuk. Teki imaka paki inikinik täŋpäŋ ägo weŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ude ahäŋirän yabäŋkuŋ; Profet bian irani yarä, Moses kenta Elaija iŋami terak ini ugän ahäŋpäŋ itkumän. ");
INSERT INTO iou_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yarä uwä ahäŋpäŋ Jesu-kät man yäŋpäŋ-nadäk täŋirä Pitatä Jesu iwetkuk; Ekäni, itkamäŋ ŋonita oretoret täkamäŋ yäk. Unita gäkä yäwikaŋ yottaba yaräkubä kaŋ täŋpa yäk. Gäka kubä, Mosesta kubä, Elaijata kubä yäk. ");
INSERT INTO iou_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ude yäŋ irirän pengän gubam peŋyäŋek ikek kubätä äpä uwäk täŋpäŋ yepmaŋkuk. Uwäk täŋpäŋ yepmaŋirän gubam gänaŋ man kubä ŋode ahäŋkuk; Ŋowä näkŋo nanakna bureni-inik. U kaŋpäŋ gäripi-inik nadäk täyat unita in unitäŋo man kaŋ buramik täŋput yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eruk iwaräntäkiye yaräkubä unitä man u nadäŋpäŋ umuntaŋkaŋ kome terak päŋku iŋami yäpä äpmoŋpäpäŋ patkaŋ bumta kwaiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ude täŋirä Jesu dubini-ken kuŋpäŋ yepmäŋit täŋpäŋ yäwetkuk; In umuntäneŋo! Akuwut! ");
INSERT INTO iou_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yäwänä iwaräntäkiye u dapuri ijiwä kwäpäŋ Jesu inigän irirän kaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ude täŋkaŋ pom terak naniktä äpäŋit äpäŋit Jesutä jukuman ŋode yäwetkuk; Imaka kudupi käkaŋ unitäŋo manbiŋam äma ätu pengän nämo yäwetneŋ. Äma Bureni-inik kumbani-ken naniktä kodak taŋpäŋ akwänkaŋ kaŋ yäwerut yäk. ");
INSERT INTO iou_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ude yäweränä iwaräntäkiyetä iwet yabäŋkuŋ; Baga man yäwoŋärewani äma imata ŋode yäk täkaŋ? Elaijatä jukun ahäwänkaŋ Anutu täŋo iwoyäwani äma Kristo u mäden api ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iweräwä Jesutä kowata ŋode yäŋkuk; Elaijatä jukun ahäwänkaŋ Kristo mäden api ahäwek yäŋ yäk täkaŋ u täga yäk täkaŋ. Unita bureni ŋode täwetat; Elaija uku ahäŋkuk. Ahäŋpäŋ Kristo ahäwayäŋ täko unita kädet täwit imiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ahäŋpäŋ irirän nämo kaŋpäŋ nadäŋkaŋ kudän waki mäyap täŋ imiŋkuŋ. Täŋkuŋo Äma Bureni-inikta udegän komi mäyap api täŋ imineŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesutä ude yäweränkaŋ nadäwä tumbuŋ; Elaijata yäyak uwä Jon ume ärut yämanita yäyak yäŋ nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eruk pom terak naniktä äpäŋpäŋ ämawebe itkuŋ-ken u ahäŋirä äma kubätä päbä Jesu dubini-ken gwäjiŋ äpmoŋpäŋ iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ekäni, gäk nanaknata butewaki nadäŋ imi yäk. U täŋguŋguŋ taŋpäŋ maŋ-patäbotkaŋ kädäp gänaŋ ba ume gänaŋ äpmok täyak. ");
INSERT INTO iou_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ude täŋirän nanakna yäpmäŋ gäwaräntäkaye-ken äbäŋira yäpna tägawut yäŋkaŋ täŋpä waŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yäwänä Jesutä gaŋani nadäŋpäŋ ŋode yäŋkuk; Wa! In bänepjin gwäjiŋ ärowani. Nadäkinikjin nämo! Jidegän api nadäwä tumneŋ? Äma in udewani-kät wari kuŋatta nämo nekaŋ! Ude yäŋpäŋ äma u iwetkuk; Eruk, iroŋi uwä yäpmäŋ äbi! ");
INSERT INTO iou_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ude yäwänä iroŋi u yäpmäŋ äbäŋirän mäjo ibeŋpewän nanak u kakätäŋpeŋ kuŋkuk. Kakätäŋpeŋ kuŋirän tägaŋpäŋ itkuk. ");
INSERT INTO iou_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Täŋirän iwaräntäkiyetä Jesu inigän irirän iwet yabäŋkuŋ; Nin imata mäjo u iwat kirekta täna wawäpäŋ pemäŋ? ");
INSERT INTO iou_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yäwäwä yäwetkuk; Nadäkinikjin täpuri-inik unita täŋpä waŋ yäk. Näk bureni täwetat; Nadäkinik bureni u imaka kubä kehäromi nikek. Nadäkinikjin bureni, bak mujip udewani täpuri ireko uwä pom ŋo ŋode iwetneŋ; Wädäŋ udu ku! Iweräwä man buramiŋpäŋ täga wädäŋ kwek. Nadäkinikjin täpuri it tameko uwä imaka kubä täŋpäwä bureni nämowä nämo ahäwek. ");
INSERT INTO iou_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesutä ude yäwetpäŋ päŋku Galili komeken iwaräntäkiye-kät käbeyä täŋpäŋ yäwetkuk; Kadäni käroŋi nämo iritna äma kubätä Äma Bureni-inik jop nadäŋ äma keri terak api pewek. ");
INSERT INTO iou_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Peŋirän kumäŋ-kumäŋ utpäŋ äneŋirä kepma yaräkubä täreŋirän api akwek yäk. Ude yäwän nadäŋpäŋ iwaräntäkiye butewaki pähap nadäŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Täŋpäŋ äyäŋutpeŋ Kapeneam yotpärare-ken kuŋirä kudupi yot täŋkentäkta takis moneŋ yäpani äma ätutä äbäŋpäŋ Pita ŋode iwet yabäŋkuŋ; Täwoŋärek ämajintä kudupi yot täŋo takis moneŋ pek täyak ba nämo pek täyak? ");
INSERT INTO iou_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yäwäwä Pitatä yäwetkuk; U pek täyak! yäk. Ude yäŋpäŋ yot Jesutä itkuk-ken u äroŋpäŋ man nämo iwerirän Jesutä Pita pengän iwet yabäŋkuk; Saimon, gäk jide nadätan? Kome täŋo intäjukun ämatä iniken epän täŋkentäkta takis moneŋ yäpmäk täkaŋ u netä keri-ken nanik yäpmäk täkaŋ? Iniken mäyemiye-ken nanik bok yäpmäk täkaŋ ba ämawebe gägäni täŋo-gänpäŋ yäpmäk täkaŋ? Jide nadätan? ");
INSERT INTO iou_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yäwänä Pitatä iwetkuk; Ämawebe gägäni täŋo-gänpäŋ yäpmäk täkaŋ, iniken mäyemiye-ken nanik nämo yäpmäk täkaŋ yäk. Pitatä ude yäwänä Jesutä iwetkuk; Täga yäyan, iniken mäyemiye uwä takis moneŋ nämo pek täkaŋ. U jop it täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Upäŋkaŋ ninta nadäwä wak täŋ nimineŋo udeta gwägu-ken kuŋkaŋ gwägu tom kubä pengän wabiwayäŋ täyan u wädäŋpäŋ yäpmäŋkaŋ meni yäpmäŋ aŋeŋpäŋ moneŋ kubä kaŋpäŋ ninek-tagän yäŋpäŋ moneŋ u takis yäpani äma unita kaŋ yämi. ");
INSERT INTO iou_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kepma uken Jesu täŋo iwaräntäkiyetä Jesuken kuŋpäŋ ŋode iwet yabäŋkuŋ; Anutu täŋo kaŋiwat yewa gänaŋ netätä intäjukun täŋpäŋ itak? ");
INSERT INTO iou_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eruk ude yäŋirä Jesutä nanak täpuri kubä yäŋpewän äbänpäŋ bämopi-ken teŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Teŋpäŋ ŋode yäwetkuk; Näk bureni täwetat. In injinta nadäwä äpani täŋpäpäŋ nanak täpuri ŋodewani bumik nämo kuŋatnayäŋ täkaŋ uwä Anutu täŋo kaŋiwat yewa gänaŋ nämoinik api äroneŋ. ");
INSERT INTO iou_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Täŋpäkaŋ äma kubätä iniken gupi ba nadäk-nadäki yäpmäŋ äpäŋpäŋ nanak täpuri bämopjin-ken itak ŋodewani bumik kuŋarayäŋ täyak uwä Anutu täŋo kaŋiwat yewa gänaŋ intäjukun äma ude täŋpäŋ api irek. ");
INSERT INTO iou_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Täŋkaŋ äneŋi ŋode yäwetgän täŋkuk; In nadäkaŋ? Äma kubätä näka nadäŋpäŋ nanak täpuri ŋodewani kubäta oraŋ imayäŋ täyak uwä näka udegän api oraŋ namek. ");
INSERT INTO iou_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Upäŋkaŋ äma kubätä nanak ŋodewani nadäkiniki näkken pek täkaŋ u yäŋ-yäkŋat-pewän momi täneŋo uwä äma udewaniwä Anututä kowata wakitä wakiinik api imek, ämatä mobä bärum kotäkiken topmäŋpäŋ ume gänaŋ maŋpä äpmoneŋo u irepmirek. ");
INSERT INTO iou_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wära! Komen äma inta butewaki nadätat. Imata, äma waki ätutä täŋ-täkŋat-pewä inken nanik mäyap api waŋ moreneŋ. Bureni, täŋyäkŋarani äma udewani itkaŋ, upäŋkaŋ jide täŋpäŋ kowata api irepmitneŋ? ");
INSERT INTO iou_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Unita ketka ba kuroŋkatä wakiken gepmaŋpayäŋ täŋpänä u madäŋ täkŋeŋpäŋ kaŋ maŋpi kut yäk. Irit kehäromi kaŋ-ahäwayäŋ nadäŋpäŋä jop kwäyähäneŋ täŋpäŋ kaŋ it. Ude nämo täŋkaŋ ketka kuroŋka bok yäpmäŋ kuŋarayäŋ täno uwä kädäp pähap gänaŋ api äpmoŋpen! ");
INSERT INTO iou_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ba dapunkatä wakiken gepmaŋpayäŋ täŋpänä dapunka dätpäŋ kaŋ maŋpi kut. Irit kehäromi kaŋ-ahäwayäŋ nadäŋpäŋä ude täŋkaŋ dapunka tumbani kaŋ kuŋat. Dapunka bok ijiŋkaŋ kuŋatpäŋä geŋi täŋo kädäp pähap gänaŋ api äpmoŋpen. ");
INSERT INTO iou_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Man ude yäŋpäŋ äneŋi pen ŋode yäwetgän täŋkuk; Inä kwikinik kuŋatpäŋ iroŋi täpuri täpuri ŋonita nadäŋirä äpani nämo täneŋ. Näk unita ŋode täwera nadäwut; Nanak täpuri täpuri u Anutu dapuri-ken äpani nämo kuŋat täkaŋ. Nämo, u aŋeroniye nikek. Aŋero kunum gänaŋ Nana-kät bok itkaŋ unitä watäni it yämik täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","In jide nadäk täkaŋ? Äma kubä yawakiye 100 uken nanik kubä-tägän paoreko uwä ini paorän yäŋ täga yäwek? Nämoinik, yawaki 99 u yepmaŋkaŋ yawak paotpeŋ kweko unita päŋku wäyäkŋewek. ");
INSERT INTO iou_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Näk bureni täwetat. Äma uwä wäyäkŋeŋkä kaŋ-ahäŋpäŋä oretoret 99 itneŋo unita nämo täŋpek. Nämo, paotpeŋ kwanipäŋ kaŋ-ahäweko unita oretoret pähap täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Täŋpäkaŋ Nanjin kunum gänaŋ naniktä ämawebe äpani ukeŋonita udegän nadäk täyak. Kubätä paotta nämo nadäk täyak. ");
INSERT INTO iou_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesutä ude yäŋpäŋ yäŋkuk; Notkapak kubätä waki täŋ gamiŋirän gäk kuŋkaŋ äma ukät injekgän itpäŋ waki täŋ gameko u kwikinik yäŋ paideŋ. Täŋkaŋ man yäwi gäkŋo man buramiwänä äneŋi not täŋpeŋ kuŋatdeŋ. ");
INSERT INTO iou_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Upäŋkaŋ gäkŋo manta bitnäwänä äma kubä ba yarä yämagurikaŋ ukät bok yäŋpäŋ yäpä-siwoŋ tawäpäŋ teneŋ. Ude täneŋo uyaku nadäŋ gamek. ");
INSERT INTO iou_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Täŋpäkaŋ äma yaräkubä intäŋo manta bitnäwänä äbot täŋpani täŋo käbeyä-ken täga teneŋ. Ba äbot täŋpani käbeyä täŋo man unita udegän bitnäwänä äma u mäde ut imiŋirä guŋ äma, ba takis moneŋ yäpani ude kuŋarek. ");
INSERT INTO iou_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Näk bureni täwetat. In imaka kubä kome terak nämo yäniŋ kireŋirä Anututä kunum gänaŋ udegän nämo api yäniŋ kirewek. Ba in kome terak yäniŋ kireŋirä Anututä kunum gänaŋ udegän api yäniŋ kirewek. ");
INSERT INTO iou_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Ba äneŋi ŋode täwetgän täŋpa nadäwut; Äma yarä ba yaräkubätä näka yäŋpäŋ käbeyä täŋirä näk u bämopi-ken api iret. Unita inken nanik yarätä imaka kubäta bänep kubägän peŋpäŋ Anutu-ken yäŋapiŋirän kunum gänaŋ Nanatä nadäŋ yämiŋpäŋ mani api buramiwek. ");
INSERT INTO iou_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesutä man ude yäŋirän Pitatä iwetkuk; Ekäni! Notnapak kubätä waki täŋ namik täŋirän momini u kadäni kadäni peŋ imiŋ yäpmäŋ kuŋtäyiwä kadäni 7 ude täreŋirän äneŋi wari peŋ imettawä? ");
INSERT INTO iou_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pitatä ude yäwänä Jesutä iwetkuk; Ude nämo. Gäk notkapak täŋo momini kadäni kubä ba yarätagän ude nämo peŋ imen. Pen waki udegän täŋ gamiŋ yäpmäŋ äroŋirän gäk pen wakini pekpek kaŋ täŋ yäpmäŋ ku. ");
INSERT INTO iou_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Täŋpäŋ man yäŋkuko unita man wärani kubä ŋode yäwetkuk; Ämawebe Anututä intäjukun it yämiŋpäŋ yabäŋ yäwat täyak uwä ŋode bumik; Kome kubäken intäjukun äma kubä irek. Täŋpäkaŋ epän ämawebeniye mäyaptä äma uken nanik tuŋum jop yäpmäŋkaŋ gwäki nämo pek täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eruk kadäni kubä intäjukun äma u tuŋum jop yäpani unitäŋo gwäki yäpa yäŋkaŋ ämawebe kubäkubäken gwäki yäpek. Yäpmäŋtäŋ kuŋtäŋgän epän ämani kubä kaŋ-ahäwek. Äma u tuŋum jop yäpeko unitäŋo gwäki ärowani-inik. ");
INSERT INTO iou_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Unita äma u gwäki taŋi päke u jide täŋpäŋ pewa täreneŋ yäŋ nadäŋpäŋ mähemi iwerek. Iwerirän mähemi unitä ŋode yäwek; Imaka imaka it gamikaŋ u ba webe nanakaye kuduptagän ämata yäniŋ kireŋpäŋ gwäki yäpmäŋkaŋ kaŋ nam yäŋ iwerek. ");
INSERT INTO iou_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ude iwerirän inita butewaki nadäŋpäŋ mähemi dubini-ken kuŋpäŋ gukut imäpmok täŋpäŋ butewaki man ŋode yäwek; Butewaki nadäŋ namiŋpäŋ kwikinik iriri kaŋ-ahäŋkaŋ waki kaŋ gama yäk. ");
INSERT INTO iou_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iwerirän mähemi u butewaki nadäŋ imiŋpäŋ momini kudup peŋ moreŋ imiŋkaŋ jop tewän kwek. ");
INSERT INTO iou_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Eruk, tewän päŋku noripak kubätä äma uken gwäki täpuri 100 kina ude nämo imeko unita kaŋ-ahäŋpäŋ kotäkigän iŋitkaŋ näkŋo moneŋ ukeŋo nam yäŋ iwerek. ");
INSERT INTO iou_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ude täŋirän noripak u inita butewaki nadäŋkaŋ gwäjiŋ äpmoŋpäŋ ŋode iwerek; Butewaki! Kwikinik iriri kaŋ-ahäŋkaŋ api gamet yäŋ iwerek. Ude iweränä yäwek; ");
INSERT INTO iou_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kämi kaŋ gamayäŋ näwetan upäŋkaŋ nämoinik yäk. Ude yäŋpäŋ iŋit yäpmäŋ päŋku komi yot gänaŋ teŋkaŋ iwerek; Moneŋ nami täreŋirän api gabä kätäwä äpämaŋ kwen yäŋ iwerek. ");
INSERT INTO iou_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ude täŋirän noriye epän penta täŋpani unitä kaŋkaŋ kokwawak nadäŋpäŋ päŋku ekänini-ken manbiŋam u iwetneŋ. ");
INSERT INTO iou_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ude iweräwä äma ekäni unitä nadäŋpäŋ epän äma unita yäŋpewän äbänpäŋ iwerek; Wa! Gäk äma wakiinik yäk. Gäk näkken momi täŋkunopäŋ butewaki man näweriri näk gäkŋo momika kumän peŋ gamiŋkut yäk. ");
INSERT INTO iou_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Näkä ude täŋ gamiŋkuropäŋ gäk imata notkapakta udegän nämo täŋ imitan? ");
INSERT INTO iou_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ude yäŋpäŋ kokwawak taŋi nadäŋ imiŋpäŋ komi äma keri terak peŋkaŋ yäwerek; Äma ŋo komi imiŋ yäpmäŋ kuŋirä näkken tuŋum yäpuko unitäŋo gwäki namänkaŋ kaŋ kakätäwut yäŋ yäwerek. ");
INSERT INTO iou_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesutä man wärani ude yäŋpäŋ yäwetkuk; Nana kunum gänaŋ naniktä inta udegän api täŋ tamek. In mejin-tägän nämo yäneŋ. Bänepjin nadäk-nadäkjin kuduptä notjiye täŋo wakini nämo peŋ yämiŋpäŋä komi api nadäneŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Eruk Jesutä man ude yäŋ paotpäŋ Galili kome peŋpeŋ Judia kome Jodan ume kukŋi udude käda kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uken kuŋirän ämawebe mäyap pähap iwarän täŋirä käyäm mebäri mebäri yäpän tägaŋ yämiŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Täŋ irirän Parisi äma ätutä ahäŋ imiŋpäŋ täŋ-ikŋatpena man kubä goret yäwänkaŋ manken tenayäŋ nadäŋpäŋ man kubä ŋode iwetkuŋ; Ai! Gäk jide nadätan? Äma kubä täŋo webenitä kädet mebäri mebäri u ba u täŋirän webeni u yäŋ iwareko uwä täga ba waki? ");
INSERT INTO iou_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ude yäwäwä Jesutä yäwetkuk; Wära! Mosestä man kudän täŋkuko u nämo daniŋpäŋ nadäk täkaŋ? Man kubä ŋode kudän täŋkuk; Anututä imaka imaka pewän ahäŋ moreŋirä äma bok, webe bok täŋ yepmaŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Täŋpäŋ ŋode yäŋkuk; Ämatä miŋi nani yabä kätäŋpäŋ webeni-kät epmäŋpäŋ irirän tohari gupi kubägän api tädeŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mebäri unita yanäpi u inigän inigän nämo irani. U Anututä gupi tohari kubägän itdeŋta yepmaŋpanipäŋ ämatä täga nämo yäpmäŋ danineŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yäŋirän Parisi ämatä iwetkuŋ; Ude yäyan upäŋkaŋ imata Mosestä manbiŋam kubä ŋode niwetkuk? Gäk webeka pewayäŋ nadäŋpäŋä webekata yäŋiwat-iwat man kudän keräpi kubä täŋpäŋ imiŋkaŋ kaŋ yäŋiwat yäŋ yäŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ude yäŋirä Jesutä kowata ŋode yäwetkuk; Manbiŋam u jop nämo täwetkuk. In Anutu täŋo man irepmitkaŋ injinken gäripjin terak kuŋat täkaŋ unita webejiye täga api yäŋ-yäwatneŋ yäŋ yäŋkuk. Upäŋkaŋ pengän Anututä kädet ude täkta yäjiwätkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Näk ŋode täwera nadäwut; Äma kubätä webenitä äma kubäkät momi nämo täŋpekopäŋ jop nadäŋ yäŋiwatpäŋ webe kubä yäpeko uwä kubokäret ude täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eruk ude yäŋirän iwaräntäkiyetä iwetkuŋ; Wära! Nädapi irit kuŋat-kuŋatta ude niwetan unita webe netätä yäpek? ");
INSERT INTO iou_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yäŋirä Jesutä kowata ŋode yäwetkuk; Ämawebe mäyaptä man u nadäwä bäräp täkaŋ upäŋkaŋ Anututä täŋkentäŋ yämiŋirän ämawebe ätutä man u täga iwatneŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","In nadäkaŋ? Äma ätu webe täga nämo yäpneŋ. Imata, miŋiyetä inide bäyaŋ yepmak täkaŋ. Äma udewaniwä webe yäpmäkta gäripi nämo nadäk täkaŋ. Täŋ, äma ätu yabäni därani unita webe täga nämo yäpneŋ. Ba äma ätuwä Anutu täŋo epänta yäŋpäŋ webe nämo yäpmäk täkaŋ. Upäŋkaŋ äma kubä, webe yäpmäkta käderi pat imänä, eruk yanäpi täktäk täŋo man täweraro u buramiwek. ");
INSERT INTO iou_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kadäni uken ämawebe ätutä nanakiye Jesutä keri gupi terak peŋkaŋ nani-ken täŋkentäŋ yämikta yäŋapik man yäwän yäŋpäŋ Jesuken yäŋ yäpmäŋ äbuŋ. Yäŋ yäkŋat yäpmäŋ äbäŋirä iwaräntäkiyetä yabäŋ yäŋpäŋ yäwetkuŋ; Nanakjiye yäpmäŋ ämneŋo! Kut! yäŋ yäwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yäŋirä Jesutä nadäŋpäŋ yäŋkuk; Yäwat kireneŋo! Yabä kätäwä iroŋiroŋi näkken yäpmäŋ äbäk täkot yäk. Nämo yäjiwätneŋ. Ämawebe iroŋiroŋi ŋodewani äworeŋpäŋ kuŋat täkaŋ uwä Anututä bureni yabäŋ yäwat täyak. ");
INSERT INTO iou_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eruk Jesutä man ude yäŋpäŋ keri gupi terak peŋkuk. Ude täŋpän tärewäkaŋ kome u peŋpeŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Täŋpäkaŋ äma kubä Jesu ahäŋ imiŋpäŋ iwetkuk; Yäwoŋärewani, näk täga jide u täŋkaŋ irit kehäromi kaŋ yäpet? ");
INSERT INTO iou_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yäwänä Jesutä iwetkuk; Gäk imaka tägata imata näwet yabätan? Imaka täga u mähemi Anutu ini. Täŋ, irit kehäromi yäpayäŋ nadäŋpäŋä Anututä kädet pewani u iwarayäŋ täno uyaku api kaŋ-ahäwen. ");
INSERT INTO iou_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yäwänä äma unitä yäŋkuk; Kädet jidewanita yäyan? Yäwänä Jesutä yäŋkuk; Gäk äma kumäŋ-kumäŋ nämo uren, kubokäret nämo täŋpen, kubota nämo täŋpen, äma kubä manken teŋkaŋ jop manman nämo ikŋaren. ");
INSERT INTO iou_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ba gäk meŋka nanka oraŋ yämen. Täŋkaŋ gäkŋata nadäk täyan udegän notkapakta nadäŋpäŋ iron täŋ imen. ");
INSERT INTO iou_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ude iweränä yäŋkuk; Näk kädet näwetan u kudup iwat yäpmäŋ äbätat. Upäŋkaŋ imaka ätu jide upäŋ täŋkaŋ irit tägawä kaŋ yäpet? ");
INSERT INTO iou_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ude yäwänä Jesutä iwetkuk; Siwoŋi-inik kaŋ ira yäŋ nadäŋpäŋä ŋode kaŋ tä; Moneŋ tuŋum ba imaka it gamikaŋ u kudup ämata yäniŋ kireŋpäŋ moneŋ yäpmäŋkaŋ ämawebe jäwärita kaŋ yämiŋ more. Ude täŋpayäŋ täno uyaku kunum gänaŋ tuŋum tägagämän api korewen. Eruk, ude täŋ moreŋkaŋ äbä näk kaŋ näwat! ");
INSERT INTO iou_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Täŋpäkaŋ äma gubaŋi unitä man ude nadäŋpäŋ moneŋ tuŋum päke unita bänepitä nadäŋ bäräp taŋi täŋtäŋ kuŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kuŋirän Jesutä iwaräntäkiye yäwetkuk; Näk bureni-inik täwetat; Moneŋ ämatä Anutu gämori-ken itkaŋ unitäŋo kaŋiwat yewa gänaŋ ärokta api täŋburut täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Unita jide nadäkaŋ? Tom pähap kubä wäpi kameri u gänaŋ täpuri-ken täga ärowek? Nämo, u käjiŋ täwek. Tuŋum äma udegän, Anututä intäjukun it yämiŋpäŋ yabäŋ yäwatta api täŋburut täneŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesutä ude yäwänä iwaräntäkiyetä bumta kikŋutpäŋ yäŋkuŋ; Wära! Anututä äma moneŋ ikek bäräŋeŋ nämo api yämagurek yäŋ yäyan upäŋ äma jopi nin ŋodewani jide täŋpäŋ irit kehäromi api kaŋ-ahäne? ");
INSERT INTO iou_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ude yäwäwä Jesutä yabäŋpäŋ yäwetkuk; Ämatä ini-tägän täga nämo äroneŋ. Upäŋkaŋ ämatä ini täga nämo tänaŋi u kudup Anututä täga täŋpek. ");
INSERT INTO iou_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ude yäŋirän nadäŋpäŋ Pitatä kowata man ŋode iwetkuk; Nibä yäk. Nin imaka imaka kudup peŋ moreŋkaŋ gäk gäwarän täkamäŋ ŋonita kowata jide api yäpne? ");
INSERT INTO iou_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yäwänä Jesutä iwetkuk; Näk bureni täwetat; Anututä täŋpewän kome ba imaka imaka äneŋi kodak tänayäŋ täkaŋ-ken uken Äma Bureni-iniktä wäpi biŋam ikek itkaŋ imaka imaka api yabäŋ yäwarek. Täŋpäkaŋ in näk näwaräntäk täkaŋ u imaka, näk dubina-ken itkaŋ Isrel äbot 12 unitäŋo intäjukun äma ude api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Täŋpäŋ äma kubätä näk näwarayäŋ nadäŋpäŋ noriye wanoriye, miŋiye naniye, iroŋiniye ba imaka kuduptagän peŋkaŋ näk näwarayäŋ täko uwä imaka peŋkuko u yärepmitpäŋ kowata tägagämän api kaŋ-ahäwek. Täŋpäŋ irit kehäromi imaka, api yäpek. ");
INSERT INTO iou_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Upäŋkaŋ äma apiŋo wäpi biŋam ikek intäjukun itkaŋ u mäyaptä mäde käda kwäkaŋ ämawebe apiŋo äpani itkaŋ unitä wäpi biŋam ikek intäjukun api itneŋ yäŋ yäwetkuk. ");
INSERT INTO iou_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anututä intäjukun itkaŋ yabäŋ yäwat epän täk täyak uwä ŋode bumik; Epän mähemi kubätä tamimaŋ bipani akuŋpäŋ wain epäna kaŋ täŋ namut yäŋ yäŋpäŋ äma ätu yämagurayäŋ kwek. ");
INSERT INTO iou_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kuŋkaŋ äma jop irani ätu yabäŋ ahäŋpäŋ yäwerek; Ai! In näkŋo wain epän täŋ namiŋirä gwäki K20 K20 tamayäŋ yäk. Ude yäweränkaŋ äma unitä nadäwä täga täŋpäpäŋ wain epän mähemi u iwatneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Eruk 9’kirok täŋirän äneŋi päŋku äma mäyap namiŋ-gamiŋ bägup-ken jop irirä yabäŋpäŋ ŋode yäwerek; Ai, in päŋku wain epän täŋ namiŋirä näk gwäki tamayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yäwerän nadäŋkaŋ wain epäni-ken kuneŋ. Eruk kepma kubä ugän äma mäyap, tamimaŋ yämagurek, kepma yämagurek, bipäda yämagurek. ");
INSERT INTO iou_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ätu itkaŋ kome bipayäŋ täŋirän äneŋi päŋku äma jop irani ätu irirä yabäŋpäŋ yäwerek; In kepma käroŋ päke ŋo ima täŋ irirä kome bipmäŋtak? ");
INSERT INTO iou_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yäwänä iwetneŋ; Äma kubätä epän täŋ imikta nämo nimagurako unita jop iramäŋonik yäk. Yäwäwä yäwerek; Päŋku wain epäna täŋ namut yäk. Ude yäweränkaŋ kuneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Epän mähemitä ude täŋirän kome bipmäŋirän watä ämani kubä iwerek; Gäk epän äma apiŋo yämaguraro u yäŋ-päbä kubä-kengän yepmaŋpäŋ epän täkaŋ unitäŋo gwäki yämi yäk. Täŋpäŋ epän äma mäden yämaguraro unita yämiŋ päŋku äma pengän yämaguraro unita yämi tärewut yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ude täŋkaŋ eruk mäden yäŋ-yäkŋat yäpmäŋ äbeko unitä jukun K20 K20 yäpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eruk, K20 K20 yämän yäpmäŋirä intäjukun yämagureko unitä kaŋpäŋ ŋode nadäneŋ; Tägagämän! yäk. Nintawä wädäŋ päro punin käda käwep nimek yäŋ nadäneŋ. Ude nadäŋirä watä äma unitä mäden ämneŋo unita yämeko uterakgän intäjukun ämneŋo unita udegän yämek. ");
INSERT INTO iou_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ude yämän kaŋpäŋä epän mähemi yäŋpäŋ-kaŋiwat täŋpäŋ iwetneŋ; A! Mäden äbäŋo uwä epän jop iŋamgän iwoŋäreŋ yäk. Nin uwä tamimaŋ naniktä epän komi nadäŋpäŋ täŋ yäpmäŋ äbäŋitna bipmäŋtak. Tämäŋopäŋ imata gwäki mäden äbäŋo ukät bok uterakgän nimitan? ");
INSERT INTO iou_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ude iwerirä epän mähemitä epän äma u kubä ŋode iwerek; Notnapak yäk. Näkä gäk nämo täŋpa wakaŋ. Näk gwäki K20 K20 ude api tamet yäŋ täwerat. Täwerira täga yäŋ näweraŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Unita gwäki tamitat udegän yäpmäŋkaŋ kukot. Näkŋawä in intäjukun äbäŋo-kät mäden äbäŋo ukät gwäki kubägän tamikta nadätat yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tuŋum näkŋa-kenpäŋ ude ba ude täŋpa yäŋkaŋ täga nämo täŋpet? Näk iron täga täropäŋ imata bänepjin täŋpä wakaŋ? yäŋ yäwerek. ");
INSERT INTO iou_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesutä man wärani ude yäŋpäŋ yäŋkuk; Unita ämawebe apiŋo mäden itkaŋ unitä intäjukun api itneŋ. Ba ämawebe apiŋo intäjukun itkaŋ unitä mäden api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu uwä Jerusalem yotpärare-ken ärowa yäŋkaŋ iwaräntäkiye 12 ugänpäŋ yämagurän yäpmäŋ inigän kuŋkuŋ. Täŋkaŋ kädet kuŋit kuŋit ŋode yäwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ket nadäwut yäk. Nin kuŋtäŋgän Jerusalem yotpärare api ahäne. Ahäŋpäŋä Äma Bureni-inik uwä Baga man yäwoŋärewani ba bämop äma intäjukun täŋpani täŋo keri terak äroŋirän kumäkta man api topneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Täŋpäŋ äma guŋ äbotken nanik unita iniŋ kireŋirä yäŋärok man iwerit, kaŋ-mägayäŋit täŋpäŋ pärip-päriptä utpäŋ päya kwakäp terak api utpewä kumbek. Kumbänpäŋ äneŋirä edap yaräkubä täreŋirän api akwek. ");
INSERT INTO iou_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kadäni uken Sebedi webenitä Jesuken imaka kubäta yäŋapiwa yäŋkaŋ nanakiyat wäpi Jems kenta Jon yäŋ-yäkŋat yäpmäŋ päŋku Jesu iŋamiken gwäjiŋ äpmoŋpäŋ itkuk. Täŋirän Jesutä iwetkuk; ");
INSERT INTO iou_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jide näwerayäŋ äbätan? Yäwänä yäŋkuk; Gäkä yäwikaŋ wäpka biŋam ikek irayäŋ täno uken nanaknayat ŋo dubika-ken kubätä käpmäk käda, kubätä bure käda kaŋ irun yäk. Ude täŋpäŋ wäpi biŋam ikek gäkkät bok kaŋ irut yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ude yäwänä Jesutä yäwetkuk; In mebäri nämo nadäŋkaŋ yäkaŋ. Ume komi nikek näkä näŋpayäŋ täyat u ek udegän täga api nädeŋ? Yäwänä Jems kenta Jontä iwetkumän; Täga api näde! yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ude yäwänä Jesutä yäwetkuk; Bureni yäkamän. Komi nadäwayäŋ täyat u in udegän api nadädeŋ. Upäŋkaŋ näk järapna kukŋi kukŋi itdayäŋ yäkamän unita näkä täwetnaŋi nämo. Nanatä iwoyäŋkuko unitägän järapna kukŋi kukŋi bok api itneŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ude yäwänkaŋ iwaräntäkiye 10 unitä man u nadäŋpäŋ noripak yarä unita nadäwäwak täŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Täŋpäkaŋ Jesutä iwaräntäkiye yäŋpewän äbäpäŋ ŋode yäwetkuk; In nadäkaŋ? Guŋ äbot täŋo intäjukun ämatä ämawebeniye ärowani täŋ yämikta gäripi nadäk täkaŋ. Ba unitäŋo äma ekäni ekänitä ämawebe epän ämaniye ude yäpmäŋ kuŋat täkaŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Upäŋkaŋ inä ude nämo täneŋ. Inken nanik kubätä intäjukun irayäŋ nadäŋpäŋä eruk, kowata yäpmäkta nämo nadäŋpäŋ intäŋo watä epän äma jopigän ude täŋpeŋ kuŋarek. Intäjukun irayäŋ nadäŋpäŋä noriye täŋo gämori-ken kuŋatpäŋ unitäŋo watä äma ude irek. ");
INSERT INTO iou_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Imata, Äma Bureni-inik uwä udegän, ämawebe täŋo watä äma ude irekta äpuk. Uwä ämawebetä watä epän täŋ imikta nämo äpuk. Nämo! U gupi iniŋ kireŋpäŋ kumäŋirän ämawebe mäyap wakiken nanik ketäreŋpäŋ inita biŋam yäpayäŋ äpuk. ");
INSERT INTO iou_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu iwaräntäkiye-kät Jeriko yotpärare peŋpeŋ kuŋirä ämawebe bumta yäwatkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Täŋpäkaŋ äma dapuri tumbani yarä uwä kädet miŋin itkaŋ Jesu äbätak yäŋ yäwä nadäŋpäŋ gera taŋi ŋode yäŋkumän; Ekäni, Devit täŋo orani, butewaki nadäŋ nimi! yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ude yäŋirän ämatä yabäŋ yäŋpäŋ Wari yädeŋo! yäŋ yäwetkuŋ. Yäniŋ bitnäŋkuŋo upäŋkaŋ gwäk pimiŋpäŋ gera pen yäŋkumän; Ekäni, Devit täŋo orani, nekta butewaki nadäŋ nimi yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eruk ude yäŋtäkon Jesu kädet miŋin itkaŋ yäŋpewän dubini-ken äbäŋirän yäwetkuk; Ima täŋ nimän yäŋpäŋ näkken gera yäkamän? ");
INSERT INTO iou_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yäwänä ŋode iwetkumän; Ekäni, dapunek yäpi tägaŋirä ijida kut yäŋpäŋ yäkamäk yäk. ");
INSERT INTO iou_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ude yäwänä Jesutä butewaki nadäŋ yämiŋpäŋ dapuri-ken yepmäŋirirän uterakgän dapun ijiŋpäŋ Jesu iwarän täŋkumän. ");
INSERT INTO iou_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kuŋtäŋgän Jerusalem yotpärare keräp taŋpäŋ Olip pom mebäri-ken yotpärare täpuri kubä wäpi Betefage uken ahäŋkuŋ. Uken ahäŋpäŋ itpäŋä Jesutä iwaräntäki yarä ŋode yäwetpäŋ peŋ yäwet-pewän kuŋkumän; ");
INSERT INTO iou_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ek yotpärare täpuri udu käkamän uken kuŋkaŋ doŋki nanak yamiŋi topmäk terak itkamän u yabäŋpäŋ pitpäŋ wädäŋ yäpmäŋ äbun. ");
INSERT INTO iou_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ektä ude täŋirän äma kubätä täwet yabäk täŋpänä ŋode kaŋ iwerun; Ekänitä doŋki ŋonita yäwänpäŋ äbä pitkamäk yäŋ kaŋ iwerun. Ude iweränkaŋ taniŋ kirewayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Täŋpäkaŋ doŋki topmäk terak irirän Jesuta pitkumäno u jop nämo. Profet biani kubätä ŋode yäŋpäŋ kudän täŋkuko udegän ahäŋkuk; ");
INSERT INTO iou_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Päŋku Jerusalem nanik ämawebe ŋode yäwerut; Kawut! Ekänijin inken api äbek. U bänep kwini täŋpanitä doŋki nanak terak maŋitkaŋ api äbek yäŋ kaŋ yäwerut. ");
INSERT INTO iou_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","7","Täŋpäŋ iwaräntäki yarä u Jesutä man yäwetkuko udegän doŋki nanak yamiŋi u pitpäŋ yäŋ-yäkŋat yäpmäŋ äbäŋkaŋ iniken tek punin nanik yäŋopmäŋpäŋ doŋki terak iriŋ imänkaŋ Jesu uterak äro maŋitkuk. ");
INSERT INTO iou_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Täŋirän ämawebe uken nanik mäyaptä teki kädet miŋin iriŋ wädäŋ yäpmäŋ kuŋkuŋ. Ba ätutä päya pähäm tokätpäŋ kädet miŋin udegän peŋ wädäŋ yäpmäŋ kuŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ude täŋkaŋ ämawebe ätu intäjukun, ätu mäden kuŋkuŋo u gera ŋode yäŋkuŋ; Wisikinik! Ekäni wäpi terak äbätak ŋonita iniŋ oretna! Anutu ärowani kunum gänaŋ itak u iniŋ oretna! yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yäŋirä Jesu Jerusalem yotpärare uken äroŋirän ämawebe u naniktä yäŋtäbätek yäŋkuŋ. Täŋpäŋ yäŋkuŋ; Wära! Äma äbätak ŋo netä? ");
INSERT INTO iou_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yäwäwä ämawebe Jesu-kät bok äbuŋo unitä yäwetkuŋ; In nämo nadäkaŋ? Ŋowä profet Jesu yäk. U Nasaret yotpärare, Galili komeken ahäwani yäŋ yäwetkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Täŋkaŋ Jesutä kudupi yot gänaŋ äroŋpäŋ yabäŋkuk; Ämatä moneŋ ba barak imaka imaka kowat imän täŋ irirä. Yabäŋpäŋ yäwat kireŋpäŋ bukäni imaka, däpmäŋ äreyäŋ täŋpän kuŋ yämiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Täŋpäŋ yäwetkuk; Anutu täŋo man ŋode kudän täwani; Näkŋo Yotta nadäŋirä yäŋapik man yot ude täŋpek. Upäŋkaŋ intä ŋode täŋirä kubo äma täŋo käbop irit bägup ude äworetak! ");
INSERT INTO iou_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ude yäwetkaŋ Jesu kudupi yot gänaŋ irirän äma dapuri tumbani ba kwäyähäneŋ täŋpani mäyap Jesutä itkuk-ken u yäŋ-yäkŋat yäpmäŋ äbäŋirä yepmaŋpän tägaŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ude täŋirän iroŋiroŋi kudupi yot gänaŋ itkuŋo unitä kaŋpäŋ gera ŋode yäŋ itkuŋ; Devit orani äbäŋ nimitak ŋonita oretoret täŋ imina! yäŋ yäŋ itkuŋ. Täŋpäkaŋ iroŋiroŋitä Jesu wäpi biŋam yäpmäŋ akuŋirä nadäŋpäŋ bämop äma intäjukun täŋpani-kät Baga man yäwoŋärewani äma ätu ukät nadäwä waŋkuŋ. Ba kudän tägatäga Jesutä täŋkuko u kaŋpäŋ nadäwäwak täŋ imiŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nadäwäwak täŋ imiŋpäŋ Jesu iwetkuŋ; Iroŋiroŋi gäka man yäkaŋ u nadätan? Iweräwä Jesutä yäwetkuk; Ei, nadätat yäk. Täŋ, in man ŋode kudän täwani u nämo daniŋpäŋ nadäk täkaŋ ba? Iroŋiroŋi ba nanak täpuri-inik nonoŋ-ken nanik täŋo bänepi täŋpidäm taŋ yämiŋiri gäk ganiŋoret man yäkaŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesutä ude yäwetpäŋ mäde ut yämiŋpäŋ Jerusalem yotpärare peŋpeŋ päŋku Betani yotpärare-ken ahäŋirän kome bipänpäŋ u patkuk. ");
INSERT INTO iou_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","19","Patkuko yäŋewänä Jesu akumaŋ Jerusalem yotpärare-ken äneŋi kuŋkuk. Kuŋtäyon nakta iwäkaŋ wama päya kubä, mujipi nämo, pähämi-tägän irirä kädet miŋin kaŋkuk. Kaŋpäŋ wama u ŋode iwetkuk; Gäkä terak mujipka kubä mäden nämo ahäwek! Yäwänä uterakgän wama uwä gämäneŋ äroŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Täŋpänkaŋ iwaräntäkiyetä u kaŋpäŋ keri iŋpäŋ yäŋkuŋ; Wära! Wama ŋowä jide täŋpäŋ bäräŋek-inik gämäneŋ ärotak? ");
INSERT INTO iou_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yäwäwä Jesutä yäwetkuk; Näk bureni täwetat. In bänep yarä nikek nämo peŋpäŋ nadäkinikjin Anutu-kengän penayäŋ täkaŋ uwä wamata täro udegän täga täneŋ. Täŋpäŋ ugän nämo. In Anutu nadäŋ imikinik täŋpäŋ pom gudo ŋode täga iwetneŋ; Pom, gäk tokätpeŋ gwägu gänaŋ äpmo yäŋ iweräwä manjin api buramiwek. ");
INSERT INTO iou_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Täŋpäkaŋ nadäkinikjin nikek kuŋatpäŋ imaka u ba u unita yäŋapiŋirä api tamek. ");
INSERT INTO iou_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesutä kudupi yot gänaŋ äroŋpäŋ man yäŋpäŋ yäwoŋärek täŋ irirän Baga man yäwoŋärewani ämakät Juda täŋo watä äma ätutä ahäŋ imiŋpäŋ iwetkuŋ; Ai! Gäk imaka täk täyan ŋo netätä gäwerirän täk täyan? ");
INSERT INTO iou_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ude iweräwä Jesutä kowata ŋode yäwetkuk; Näk man kubägän-inik täwet yabäwa näwerirä näkä udegän netä näwerän imaka täk täyat u kowata täwerayäŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Eruk näwerut! Jontä ume ärut yämik täŋkuko u netä iweränkaŋ ume ärut yämik täŋkukonik? Anututä iweränkaŋ täŋkuk ba ini nadäŋpäŋ täk täŋkukonik? Ude yäwet yabäwänä jide yäne yäŋ nadäŋpäŋ yäŋpäŋ-nadäk ŋode täŋkuŋ; Nin Anututä iwerän täŋkuk yäŋ yänawä Jesutä ŋode niwerayäŋ; A! Upäŋ imata mani nämo nadäŋkuŋ? yäŋ niwerayäŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Täŋ, Jon uwä ini nadäŋpäŋ täŋkuk yäŋ yänawä ämawebetä Jon uwä profet kubä yäŋ nadäŋpäŋ ninta kokwawak nadäŋ nimineŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nadäŋ-bäräp yarä nikek ude täŋpäŋ Jesu iwetkuŋ; Nin nämo nadäkamäŋ yäk. Yäwäwä yäwetkuk; Eruk, ude yäkaŋ unita näk udegän netätä näwerirän täk täyat unitäŋo mebäri nämo täwerayäŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","30","Jesutä man ude yäŋpäŋ äneŋi ŋode yäwetkuk; Man wärani kubä täwera ket nadäwut; Tuäke monäke it täŋkumänonik. Nanitä nanaki tuäni ŋode iwetkuk; Tuä, gäk kuŋkaŋ wain epän täŋ namisi yäk. Iweränä yäŋkuk; Nan, täga täŋpayäŋ yäk. Täga täŋpayäŋ yäŋkukopäŋ peŋawäk täŋpeŋ epän nämo täŋkuk. Täŋirän ätu itpäŋ nanitä monäni man udegän iwetkuk. Iweränä yäŋkuk; Nämo täŋpayäŋ! yäk. Nämo täŋpayäŋ iwetkukopäŋ mäden bänepi sukureŋpäŋ päŋku epän täŋkuk. ");
INSERT INTO iou_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesutä man wärani u yäwet paotpäŋ yäwetkuk; In jide nadäkaŋ? Nanak netätä nan täŋo man buramiŋkuk? Yäwänä iwetkuŋ; Nanaki monänitä buramiŋkuk yäk. Yäwäwä Jesutä yäwetkuk; Näk bureni täwetat. Ämawebe wakiwaki täŋpani, takis moneŋ yäpani äma ba kädet miŋin webe udewanitä in tärepmitpäŋ Anutu täŋo kaŋiwat yewa gänaŋ intäjukun api äroneŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jontä ahäŋpäŋ siwoŋi kuŋat-kuŋat täŋo kädet täwoŋäreŋirän inä unitäŋo man nadäkta bitnäwäkaŋ takis moneŋ yäpani äma ba kädet miŋin webetä nadäŋpäŋ bänepi sukureŋkuŋ. Ude täŋirä yabäŋkuŋo upäŋkaŋ gwäkjin nämo imätkuŋ. Man Jontä yäŋkuko u nämo nadäŋ imiŋpäŋ bänepjin nämo sukureŋkuŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesutä ude yäŋpäŋ yäwetkuk; Näk man wärani kubä täwera nadäwut; Äma ekäni kubätä kome kubäken wain epän täŋ moreŋpäŋ yewa täŋ-äyäŋurek. Täŋpäŋ wain mujipi yeŋ yäwatpäŋ umeni yäpmäkta komeni täŋkaŋ watä ämata yot kubä täŋ yämek. Ude täŋ moreŋpäŋ wain epän u kaŋiwatta äma ätu yepmaŋpän irirä kome ban kubäken kwek. ");
INSERT INTO iou_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kwekopäŋ mujipi yäpmäk-yäpmäk kadäni keräp taŋirän mujipi ätu inita ketpäŋ yäpmäŋ imiŋ äbäkta epän ämaniye yäwerän kuneŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kuŋirä wain epän watä äma unitä äma u yepmäŋitpäŋ däpneŋ; Kubä iŋitpäŋ päripneŋ, kubäwä kumäŋ-kumäŋ utneŋ, kubäwä mobätä utneŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Täŋirä wain epän mähemitä nadäŋpäŋ äneŋi epän ämaniye mäyap yäwerän kuŋirä udegän yepmäŋitpäŋ däpneŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eruk mäden-inik ŋode nadäwek; Nanakna bureni-iniktä päŋku yäwänä oraŋ imiŋpäŋ mani api buramineŋ yäk. Ude nadäŋpäŋ iniken nanaki iwerän kwek. ");
INSERT INTO iou_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Eruk kwänkaŋ wain epän täŋo watä äma unitä nanaki-inik u kaŋpäŋ yäŋpäŋ-nadäk ŋode täneŋ; Unitä epän ŋo mähemi api täŋpek yäk. Unita uritna epän ŋo ninta biŋam kaŋ täŋpän! ");
INSERT INTO iou_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ude yäŋpäŋä iwat kireŋpewä yewa gägäni-ken kuŋirän kumäŋ-kumäŋ utneŋ. ");
INSERT INTO iou_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesutä man wärani ude yäŋpäŋ ŋode yäwetkuk; Jide nadäkaŋ? Epän mähemitä kuŋpäŋ watä äma u kowata jide täŋ yämek? ");
INSERT INTO iou_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yäwänä bämop äma ba Juda täŋo watä äma uken itkuŋo unitä iwetkuŋ; Imaka waki-waki täŋkuŋo unita udegän kowata waki täŋ yämiŋirän paotneŋ yäk. Täŋpäŋ watä äma biani yäwat kireŋpäŋ komeni-ken watä äma tägagänpäŋ yepmaŋirän unitä kadäni kadäni wain mujipi yäpmäŋ imik täneŋ yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yäwäwä Jesutä ŋode yäwetkuk; Anutu täŋo man ŋode kudän täwani u nämo daniŋpäŋ nadäk täkaŋ? Äma yot täŋpanitä bek kubä kawä wawäpäŋ peŋkuŋo unitä bek bämopi ude itak. Anututä ude täŋpewän ahäŋirän kaŋitna gäripi nikek täyak. ");
INSERT INTO iou_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Unita ŋode täwera nadäwut; Inä wain epän watä äma waki ukeŋo udewani. Unita Anutu täŋo kaŋiwat yewa gänaŋ ärokta kädet täŋpipiŋ täwatkaŋ äma äbot kudupi kubä Anutu täŋo gärip terak kuŋatnayäŋ täkaŋ unita kädet api peŋ yämek. ");
INSERT INTO iou_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bek bämopi täweraro uterak äma kubätä maŋpäŋä bumta api urek. Ba bek unitä äma kubä terak maŋpäŋä äma u api däpmäŋ jakŋirek yäk. ");
INSERT INTO iou_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesutä man wärani ude yäŋirän bämop ämakät