﻿USE sofia;
DROP TABLE IF EXISTS sofia.ino_vpl;
CREATE TABLE ino_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ino_vpl WRITE;
INSERT INTO ino_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mamona Yisasi Kalaisi akinakomoki apa'ki hane'ne. Yisasi'a Teviti nofi vayapati ve'ka mai'nea yafe Teviti'a Epalahamu nofi vayapati ve'ka mai'nikeno Epalahamu'a Yisasi akinako mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aisa'ki afo'amo'a Epalahamu'ae. Ye'kopu afo'amo'a Aisa'ki'ae. Yuta'ae akana'amoki'ae afo'apimo'a Ye'kopu'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pelesi'ae Sela'ae afo'animo'a Yuta'a mai'nikeno ita'animo aki'a Tema'ae. Hesaloni afo'amo'a Pelesi'ae. Lama afo'amo'a Hesaloni'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminatapi afo'amo'a Lama'ae. Nasoni afo'amo'a Aminatapi'ae. Salamoni afo'amo'a Nasoni'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamoni'a Povasi afo'amo'a mai'nikeno ita'amo aki'a Lehapu'ae. Povasi'a Opeti afo'amo'a mai'nikeno ita'amo aki'a Luti'ae. Opeti'a Yesi afo'amo'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi'a Teviti afo'amo mai'nikeno Teviti'a Isaleli vaya'aite ala kava ve'ka'api mai'ne. Teviti'a Solomoni afo'amo mai'nikeno ita'amo'a hokoteno Yulaiya a'a mai'neane. ");
INSERT INTO ino_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Liapoami afo'amo'a Solomoni'ae. Apaisa afo'amo'a Liapoami'ae. Esa afo'amo'a Apaisa'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yehosafati afo'amo'a Esa'ae. Yolami afo'amo'a Yehosafati'ae. Usia afo'amo'a Yolami'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yotami afo'amo'a Usia'ae. Ehasi afo'amo'a Yotami'ae. Hese'kaiya afo'amo'a Ehasi'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manasa afo'amo'a Hese'kaiya'ae. Emoni afo'amo'a Manasa'ae. Yosaiya afo'amo'a Emoni'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ye'konaiya'ae akana'amoki'ae afo'apimo'a Yosaiya'ae. Ani afina Papiloni koteka la hake'a Isaleli vaya apavale'a Papiloni koteka miya o'ali aliyate apate'nae. ");
INSERT INTO ino_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ani vaya'moki Papiloni koteka miya o'ali ali'ya apamitakeno Sealitielo afo'amo'a Ye'konaiya'ae. Selapapeli afo'amo'a Sealitielo'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Apiuta afo'amo'a Selapapeli'ae. Elaiya'kimi afo'amo'a Apiuta'ae. Aso afo'amo'a Elaiya'kimi'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Seto'ki afo'amo'a Aso'ae. A'kimi afo'amo'a Seto'ki'ae. Eliuti afo'amo'a A'kimi'ae ");
INSERT INTO ino_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleasa afo'amo'a Eliuti'ae. Matana afo'amo'a Eleasa'ae. Ye'kopu afo'amo'a Matana'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ye'kopu'a Yosefe afo'amo mai'nikeno Yosefe'a Malia anau'amo'a mai'nikeno ani a'mo'a Yisasi alite'nikeno akaeyafe Kalaisi'ae hu'a Anumaya Koti'a lakufa alino katikefe hute'nea ve'kae hu'a aki ne'ae. ");
INSERT INTO ino_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Epalahamu'a hokoteno mai'neno faliteke'a henaka'a ayatala'a hano huteno aiyalekati aole'ae aole'ae alea (14) akinakomo nofi vaya maime hai'a nefalike'a anile Teviti'a va'yi huno mai'neno falike'a henaka'a ayatala'a hano huteno aiyalekati aole'ae aole'ae alea akinakomo nofi vaya'a maime haike'a Papiloni vaya'moki e'a Isaleli kumate vaya apavalake'a miya o'ali ali'ya ali'nae. Ali'nake'a henaka'a ayatala'a hano huteno aiyalekati aole'ae aole'ae alea akinakomoki nofi vaya'a maime nehaikeno Kalaisi'a fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisasi Kalaisina alite'nea ke inake huno hane'ne ita'amo aki'a Malia'ae. Ani a'mafa'ne Yosefete ako hakemale'naya a'mafa'ne mai'nea'maki ve'ae lo'kano nohavaeya a'mafa'ne Anumaya Koti Fate Akufa Avamu'amoteti aipa'ae mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefete hakemale'naya ve'ka alakepa ve'ka mai'nea yafenakeno “Haviku Malia'a avuya hu'yafenake'na kesi atalesoe.” huno akesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Ani ke akesa afifi huketeno hava'neno himona akeana Anumayamo ko'ku'napi kayo kayo ve'ka va'yi huno inake huno hapai'ne “Yosefeka Teviti mafa'ne'amoka koli ohu'ka Maliana a'kamo'aki afa'a aleo. Anumaya Koti Fate Akufa Avamu'amoteti aipa'ae mai'neanakeno ne'mafa'ne alitekaiye. Ani mafa'nemo'a akai'a vaya'amoki hao'otake ya'apimo'a nofi hupate'nea vaya kalu heno apa'kufa alino katike. Ani yafe aki'a Yisasi'ae hu'ka malekane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","A'ke'ainaka Anumayamo'a aune ve'kamo avayafati inake hu'neane “Afeo ve'ae lo'kano nohavaeya a'mafa'nemo'a aipa'ae maiteno ne'mafa'ne alitesike'a aki'a ina ya hu'a malekae Imanueli'ae hu'a malekae.” hu'neane. Lakaeya kefati ani aki Anumaya Koti'a lakaeya'ae mai'ne huno hane'ne. Yisasina alite'nea afina ani a'ke'ainaka hu'nea kemo'a ako fole aino ne'ya'a aliteno lamake nehe. ");
INSERT INTO ino_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefe'a ani himona aketeno hetino Anumayamo ko'ku'napi kayo kayo ve'ka'amo'a hapai'nea ke afino a'kame maleteno Maliafe “A'nimokae.” huteno ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ali'nea'maki Yosefe'a ani afe “A'nimokae.” huteno a'yafa hava o'ate'nikeno ani ne'mafa'ne ako alitetekeno Yosefe'a ani mafa'nemo aki'a Yisasi'ae huno male'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heloti'a Yutia koteka ala kava ve'ka mai'nea kanafi Yisasina Petelehemu aise Yutia kumate alite'ne. Alite'nike'a henaka'a yake haineno va'yi nehea aupalikati mako apa'kenopa hale'nea vaya'moki Yelusalemu va'yi hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Va'yi hu'ne'a inake hu'a nehae “Yuta vaya'aite kava hisea mafa'ne meni ako alite'nea mafa'ne hanate mai'ne? Yake haineno va'yi nehea aupalikati mako saufa sanafi va'yi nehiketa aketeta ‘Ako alite'ne.’ nehuta akaeya aki alita asaka hukefe ne'one.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nehakeno kava ve'kamo'a Heloti'ae mi'ko Yelusalemu mai'naya vaya'ae ani ke afite'a atali atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Atali atalu nehu'a Heloti'a mi'ko mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ke hike'a akaeyate akeno inake huno apafine'ke “Anumaya Koti'a lapa'kufa alino katikefe hutesea ve'ka hanate alitekaiye hu'a hu'nayane?” huno apafike'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Apafikeke'a inake hu'a nehae “Ani mafa'ne Petelehemu alitekaiye. A'ke'ainaka Anumaya Koti aune ve'kamo'a inake huno kamale'neane ‘Kakaeya Petelehemu kuma'moka Yutia kuma mai'nana'maki Yutia kava ve'kamo kuma'yaka ako akase'ka hai'nane kakaeya kumateti ala kava ve'ka va'yi huteno nakaeya vaya Isaleli vaya'aite kava ve'ka'api maike huno kamale'neane.’ hu'a nehae.” ");
INSERT INTO ino_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nehakeno Heloti'a apa'kesi huno yake haineno va'yi nehea aupalikati e'naya apa'kenopa hale'nea vaya'aife ke hike'a akeno “Ani saufa sanafina na yu va'yi hu'ne?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Apafikeno Petelehemu hupatekefe inake nehe “Utapa ani mafa'ne kahau atapa aketapa fole aitetapa etapa ke nahapaike'na nakaeya'ae ani kava hu'na u'na aki ali'na asaka hino.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hike'a ani kava ve'kamo ke afite'a u'a akayana yake haineno va'yi nehea aupalikati va'yi hike'a ake'naya sanafi'mo'a eno uno hokotepateno ani Yisasina alitekeno mai'nea no'kato'mule mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mai'neno apavelike'a ake'naya yafe apaipamo'a kanale nehike'a lusi amuse nehae. ");
INSERT INTO ino_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Amuse hutete'a ani nopi hai'a fale'ne'a akayana ani mafa'ne'ae ita'amo'a Malia'ae mai'na'ake'a ana'kete'a mopafi ape hu'ne'a aki ali'a asaka nehu'a ku'apifati amuse yana amikefena mako moni'ae kanale mana ne'aiya la'nefa'ae yosamo a'kamemo li'ae ami'nae. Ani li'mo aki'a mea. ");
INSERT INTO ino_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amite'a hava'ne'a himona akayana Anumaya Koti'a himonafi inake huno hapapai'ne “Heloti mai'neateka o'utapa alu kateka veo.” huno hapapaike'a alu kateka kuma'apileka u'nae. ");
INSERT INTO ino_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Apa'kenopa hale'nea vaya utakeno himonafi ko'ku'napakati Anumayamo kayo kayo ve'ka Yosefete ekeno ake'ne. Akekeno inake huno hapai'ne “Heloti'a ma mafa'ne hakefe kahau akaiyanaki heti'ka mafa'ne'ae ita'amo'ae anavalete'ka lapaune hetapa Isipi koteka utapa mai'nisake'na henaka'a ete'na ke hukoanaki utapa mai'nike'nao.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ani himonafi hapaikeno Yosefe'a makale hetino mafa'ne'ae ita'amo'ae ani hani'ainaka ne'anavaleno Isipi koteka ukefe ne'vae. ");
INSERT INTO ino_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","U'a ani koteka yatala kana mai'nakeno Heloti'a faliteke'a atale'a ete'a e'nae. Ani kava hu'nea yafe a'ke'ainaka Anumayamo'a inake hu'neane “Isipi kotekati nakaeya mafa'ne'ni ke hu'noanakeno ako e'ne.” huno Anumaya Koti aune ve'ka a'ke'ainaka Anumayamo'a hapaikeno mani ke hu'neane. Ani afina hu'nea kemo'a fole aino ne'ya'a aliteno lamake hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heloti'a akesa afiteno “Ani apa'kenopa hale'nea vaya'moki apa'ke'atike hu'a a'a navataka hae.” huteno aipamo'a lusiya huno hai vaikeno ke ne'neno ati vaya hupateke'a “Petelehemu'ae ani hau'ale hane'ne hane'ne hu'nea kumate mafa'neyaka mi'ko aole kafu mai'naya mafa'neyaka hapaeke'a faleo.” huno hupate'ne. Apa'kenopa hale'nea vaya'moki haya ke afiteno Yisasife ani akufa kafu'a hane'nekaiye huno'aefe “Ani mafa'neyaka hapaeke'a faleo.” huno hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ani mafa'neyaka hapa'a hano hu'nayana a'ke'ainaka Anumaya Koti aune ve'ka Yelemaeya'ae nehaya ve'kamo avayafati hu'nea kemo'a inake hu'neane “Alakepa kumapati lusi kalafa ne'ka'a avi'nele'a avovo avava nehu'a lusi hapau ke fo'ke ke afi'nayane. Leseli'a akeho'amoki mafa'ne'ae lusi avileno apate'ne. Mako vaya'moki Leseli aipa ali'a yuna hutanina'maki mafa'ne anaka'a mako'ae o'mai'naya yafe lusi avileke leke huno ama ote'ne.” hu'ne. Ani afina a'ke'ainaka hu'naya kemo'a fole ne'aino ne'ya'a aliteno lamake nehe. ");
INSERT INTO ino_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Heloti'a ako falitekeno Yosefe'a Isipi koteka mai'nikeno himonafi Anumayamo ko'ku'napi kayo kayo ve'ka hutekeno eno inake huno hapai'ne “Heti'ka mafa'ne'ka'ae ita'amo'ae anavale'ka Isaleli uvo. Mafa'ne'ka hakefe haya vayana ako fali'nae.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Hapaikeno Yosefe'a hetino mafa'ne'ae ita'amo'ae ne'anavaleno Isaleli koteka u'nae. ");
INSERT INTO ino_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","U'naya'maki “Heloti'a falitekeno mafa'ne'amo'a A'keleasi'a afo'amo no alino kava ya alino Yutia mai'ne.” haya ke Yosefe'a afiteno koli huno “Ani koteka o'ukoe.” nehe. Neheana mako himonafi “Anileka o'veo.” ke afiteno Kalili koteka u'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kalili uno mako aise kuma'a Nasaletine hu'a nehaya kumate uno mai'ne. A'ke'ainaka Anumaya Koti aune vaya'moki Yisasife inake hu'a hu'nae “Akaeya Nasaleti ve'ka mai'ne.” hu'a hukae hu'a hu'nae. Ani afina a'ke'ainaka hu'naya kemo'a fole aino ne'ya'a aliteno lamake hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yoni'a li falene'apatea ve'ka va'yi huno Yutia koteka mako ka'me aupalika mai'neno Anumayamo ke mi'ko vaya hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Inake huno hapapai'ne “Anumayamo'a kava yakailapatesea kana'a ako eno aupasi neheanaki lapaipa aitapa yahae hutapa hao'otake yatapi ataleo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ani ke Yonife a'ke'ainaka Anumaya Koti'a aune ve'ka'a Aisaiya'ae nehaya aune ve'kamo avayafati hu'nea ke inake hu'neane “Vaya o'mai ka'me aupalika mako ve'kamo'a kate kate nehuno inake huke ‘Anumayamo esea ka valitapa alitapa avatati huteo.’ huno hu'neane.” ");
INSERT INTO ino_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoni'a mako kamolo hu'a aki ne'aya afumo ayo'kaleti kena'a alo huno havaiteno puluma'ka afumo akufaleti kamai nofi alo huno afafale ne'ano ne'ya'a kenu kafa'ae alumemo li'ae ne'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ani kanafi Yelusalemu vaya'ae Yutia vaya'ae mi'ko Yotani li'mo haute hane'nea kumate vaya'ae Yonite ete ete hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Va'yi hu'ne'a hao'otake kava nehaya ya'api hu'a fole aikeno Yoni'a Yotani lipi li falepate'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Li falene'apateke'a Falasi mono ke ne'afea vaya'ae Satiyusi mono ke ne'afea vaya'ae “Li falelatese.” hu'a ne'akeno Yoni'a apa'keteno apa'kaeyafe inake nehe “Lapa'kaeya osifa'vemo mafa'neyaka mai'nae. Anumaya Koti kake hulapatesea kana lapa'kufa lapa'kafu kisea kana'a makale va'yi hisea yafe ‘Lapaune hetapa veo.’ ke nala'a lahapapaiketapa ne'ae? ");
INSERT INTO ino_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hokotetapa lapa'kaitapi kanale au'ava kava haya yateti hao'otake yatape lapaipa aitapa yahae hutapa hao'otake yatapi atale'naya ya navelisayana lina falelapatekauve. ");
INSERT INTO ino_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lapa'kaeya ‘Epalahamu mafa'neyaka mai'none.’ hutapa oheo. Nakaeya lahapa'nepauve Anumaya Koti'a ma yafateti alino Epalahamu mafa'neyaka afa'a alo hinine. ");
INSERT INTO ino_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lapa'kaeya yosakana hu'nakeno meni Anumaya Koti'a ko'ne alino yosa hafu'yale avame huno male'neanakeno kanale alaka'a o'aesea yosayaka he'yaino atafi yaka hutalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lapaipa aitapa yahae hutapa hao'otake yatapi atalaya yafe nakaeya litafateti fale nelapatoanakeno nakaeya na'kame mako ve'ka ako ekaiye. Ani ve'kamo'a lusi lo'kiya'a hane'nea ve'kakeno nakaeya ako nakase'nike'na nakaeya afa ve'ka mai'noanake'na akaeya aiya'kale aesoana o'natekaiye. Ani ve'ka eseana Fate Akufa Avamu'amoteti'ae ataleti'ae falelapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akaeya sipeti ayo ali'neno viti avina hakome avinakana yana faino katekeno alakepa alaka'a nopi alino anupa huno malekaiya'maki anoma'a ata leke leke nehea atafi kakaiye. Ani avina alino fa'ko fa'ka hea avamete vaya alino fa'ko fa'ka huke.” huno nehe. ");
INSERT INTO ino_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ani kanafi Yisasi'a “Yoni ayapati lina falenatese.” nehuno Kalili aupalikati Yotani lite e'ne. Ekeno Yoni'a Yisasina Yotani lipi falete'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yoni'a Yisasife “Li fale o'katekauve.” nehuno Yisasife inake hu'ne “Kakaeya nakaeya li falenatesanana kanale hukea'maki na'ya hike'ka nakaeyafe lina falenato hu'ka nehane?” nehe. ");
INSERT INTO ino_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nehea'maki Yisasi'a Yonife ke anona'ale inake he “Meni ani kava hisanana kanalene. Li falenatesanana mi'ko Anumaya Koti alakepa au'ava'a alita'a alaki huku'ae.” hikeno Yoni'a Yisasi ke a'kame maleno li falete'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Li faletetekeno Yisasi'a lipati makale aino he'netino akeana makale ko'ku'na'mo'a hakalo hikeno Yisasi'a ne'akekeno Anumaya Koti Fate Akufa Avamu'amo'a namakana huno haleno elineno akaeya akufale ha'kaleno mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mai'nikeno ko'ku'napakati mako ake aiya akemo'a inake he “Akaeya nakaeya'ni mafa'ne. Akaeyafe lusiya huno nahau nayamopafati ne'nahaiya mafa'ne. Naipamo'a akaeyafe lusiya huno amuse'a nehe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","2","Sata'a “Hao'otake kava ho.” huno ano avataka hisea yafe Anumaya Koti Fate Akufa Avamu'amo'a Yisasina avaleno vaya o'mai ka'me aupalika uno atalekeno Yisasi'a aole ve'kala'mokani anaiya anaya hano hea yake'ae hani'ae (40 afina) ne'ya o'ne'nea yafe lusi aka nele. ");
INSERT INTO ino_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aka nelekeno Sata'a Yisasife inake he “Kakaeya Anumaya Koti mafa'ne mai'ne'kaefena ma yafa hapapaike'a kai hame'ya maya hamalesae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nehikeno Yisasi'a ke anona'ale inake he “Anumaya Koti avopi kamale'nea kemo'a inake hu'neane ‘Vaya'moki ne'ya'ake nesayana kanale hu'a mai ya o'alikaya'maki mi'ko Anumaya Koti avayafati hu'nea ke'ae afi'a ne'ya'kana hu'a nesayana apa'ku mafa'ne kanale huno maike.’ hu'neane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","Nehikeno Sata'a Yisasina Yelusalemu avaleno ala mono no'mo akofetule haino ha'ko'ya vai'nea yate ate'neno inake he “Kakaeya Anumaya Koti mafa'ne mai'ne'kaefena ma no'mo akofetuleti halesaka hu'ka mopafi laveo. Anumaya Koti avopi kamale'naya kemo'a inake hu'neane Anumaya Koti'a ko'ku'napi kayo kayo anaka'ae ‘Kava huteo.’ huno hupatesike'a eli'e'a kanale'ya hu'a yakaikate'nisake'ka halesaka hulavisanana apaya akusale kavale'a asaka hisakeno mako yafatena kaiyafi o'kahakaiye hu'neane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nehikeno Yisasi'a ke anona'ale inake he “Anumaya Koti kemo'a mako'ae inake hu'neane ‘Kakaeya Anumaya Koti'a ala'a'ka a'ka avataka oho.’ hu'neane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nehikeno Sata'a Yisasina avaleno hanafi hai'nea avimate ate'neno mi'ko mopale hane'nea no kuma'yaka'ae kanale'nale afeno'ya'ae aveli'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ave nelino inake he “Kakaeya nakaeyate e'ka kale'ya alo a'ka ape hu'ne'ka nakaeyafe kakesa afi'ka ‘Ala Ne'ni mai'nane.’ hu'ka naki ali'ka asaka hisanana mi'ko ani akana no kuma'yaka'ae kanale'nale afeno'ya'ae kava hisana yafe kamikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nehikeno Yisasi'a inake he “Sataka mai'ka halo Anumaya Koti avopi kamale'naya kemo'a inake hu'neane ‘Anumaya Koti'kamofe akai'a mako'ke'ake ala mai'ne nehu'ka akaeyate'ke kakesa afifi nehu'ka aki ali'ka asaka nehu'ka akai'a a'kame ne'male'ka ali'ya'a aleo.’ huno hu'neane.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nehikeno Sata'a ataleno vike'a ko'ku'napakati kayo kayo vaya'moki e'a Yisasina ha'ma'nae. ");
INSERT INTO ino_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","“Yonina ako avale'a nofi hute'nae.” haya ke Yisasi'a afiteno Kalili koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kalili mai'neno Yisasi'a Nasaleti ataleno Kapaneamu uno mai'ne. Ani Kapaneamu kumana Kalili li kotu'mo aki'nale hane'neno Sepiulani'ae Napatalai kumatala'mokani hanaute hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","A'ke'ainaka Aisaiya'a Anumaya Koti aune ve'kamo'a inake hu'neane “Sepiulani kuma'ae Napatalai kuma'ae ala li kotu'mo aki'naleka hane'na'a kumana Yotani li la'ka'a ne'vaya kate hane'nea kuma'ae Isaleli nofi o'mai vaya ne'maiya Kalili kote'ae nesu vaya ne'maiye. Ani kuma'yakafi mai'naya vayana lusi hani au'ava yapi mai'naya'maki meni ala hale ya ne'akae. Mi'ko vaya'moki hani yapi mai'ne'a falikefe nehakeno Anumaya Koti kemo'a ako ano halepate'ne.” huno hu'neane. Ani afina ani hu'nea kemo'a fole aino ne'ya'a aliteno lamake hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ani afina Yisasi'a aepa heno Anumaya Koti ke nehuno inake he “Anumaya Koti'a male'nea kana ako eno lahapau ka'niki ko'ku'napakati Anumaya Koti'a kava yakailapatesea ya makale va'yi hukefe nehiki lapa'kaeya lapaipa aitapa yahae nehutapa hao'otake yatapi ataleo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yisasi'a Kalili li kotu'mo aki'naleka uneno nehuno mako aole konakala ana'ke'ne. Ala'mo'a Saimoni'ae nehaya ve'ka mako aki'a Pita'ae. Akana'amo'a Etalu'ae ana'keana ani konakala'mokani faya lu'konako male ali'ya ne'ali'a ve'kala mai'na'a yafe ala lu'konako ku li kotupi yaka hu'ana ne'mala'ae. ");
INSERT INTO ino_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne'mala'akeno Yisasi'a inake nehe “Na'kame esa'ake'na faya neha'a avamete vaya apavalesa'a yafe hulanatekauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nehike'ana makale'a lu'konako'ani ne'atale'ana Yisasi a'kame ne'a'ae. ");
INSERT INTO ino_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ne'a'akeno Yisasi'a aisema'a ne'uno mako aole konakala ana'ke'ne. Ani konakalana Sepeti mafa'nela Yemisi'ae Yoni'ae afo'animo'ae lipi kalefi mai'ne'a lu'konako ku nefa'kanikeno Yisasi'a uno ana'keteno ana'kaeyafe ke he. ");
INSERT INTO ino_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ke hike'ana makale'a lu'konako'ani'ae afo'animo'ae ne'atale'ana a'kame ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisasi'a mi'ko Kalili aupalika uneno nehuno mono no'apifi Anumaya Koti ke alino apaya nehuno Anumaya Koti'a kava yakaipatesea ke hapa'nepaino mi'ko kali alino kanale hune'apateno mi'ko vaya apa'kufa haviya hu'nea ya mi'ko alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Alino kanale hupate'nea avake'amo'a mi'ko Silia koteka hane'nea kumate vaya u'a hapapaike'a mi'ko aki'ae aka'ae kalimo'a apa'kufa alino haviya hapaike'a lusi apa'kafu ne'kea vaya'ae Sata afe apaipafi mai'nea vaya'ae hafosamo'a hapake nehea vaya'ae mi'ko apaiya apaya avayu hu'nea vaya'ae apavale'a akeno Yisasi'a alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kanale hupate'nike'a mi'ko ve a'ne Kaliliti'ae naya aole kuma'yakaleti'ae Yelusalemuti'ae Yutiati'ae Yotani li la'ka'a alu'ale hane'nea kumate mai'naya vaya'moki Yisasina a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Lusi ve a'ne e'a ali'a atalu hakeno Yisasi'a apa'keteno avimapi haino faitopale mai'nike'a akaeya ke ne'afea anaka akaeyate ne'akeno Yisasi'a huno fole aino inake huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mako vaya'mokitapa “Anumaya Koti aulakale nakai'nike mako kanale ya'ni o'male'nea yafe alakepa ve'ka o'mai'noanakeno Anumaya Koti'a naya hise.” hutapa haya vaya'mokitapa Anumaya Koti'a lapa'kaeya kava yakai nelapatea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lahapau hu yapi ne'maisaya vaya'mokitapa Anumaya Koti'a lapaya huno lapaipamo'a falu hisea ya lapamisea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lapa'kufa alitapa nohaiya vaya'mokitapa Anumaya Koti'a henaka'a mi'ko mopa lapamisea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anumaya Koti alakepa au'ava kava hisaya yafe nelahapaikeno “Ani kavafe laka nele.” hutapa hisaya vaya'mokitapa Anumaya Koti'a lapamu hisiketapa maisaya alakepa kava lapamisea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mako vayatapimokife lapa'kaeya kalaki aipatetapa lusiya hutapa lahapau hune'apataya vaya'mokitapa Anumaya Koti'a ani kava huno kalaki aino hau hulapatesea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lapa'kaeya hao'otake kava ohakeno Anumaya Koti aulakale honi'ya yatapi lapaipafi o'male'nisea vaya'mokitapa Anumaya Kotina akesaya yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ke ne'vai'a la nehaya au'ava kava he'a laka nehu'a “Ina akufa kava oheo.” hu'a nehisaya vaya'mokitapa Anumaya Koti'a “Nakai'ni mafa'ne mai'nae.” huno hulapatesea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lapa'kaeya Anumaya Koti kanale au'ava kava hu'naya yafe mako vaya'moki apaipa kafa helapate'a ali'a haviya hunelapatesaya vaya'mokitapa Anumaya Koti'a lapa'kaeya kava yakai nelapatea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Lapa'kaeya na'kame malesaya yafe vaya'moki lapa'kete'a kamuke nelahapau'a hu'a haviya hulapate'a “Ma kavana havi kava nehae.” hu'a apa'ke'atike hulapatesaketapaena amuse heo. ");
INSERT INTO ino_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ani kava hu nelapatesaketapaena ko'ku'napi anona'a ala miya alisaya yafe lapaipamo'a kanale nehisiketapa amuse heo. Ali'a haviya hu nelapataya kavana vaya'moki a'ke'ainaka inani kava hu'a Anumaya Koti aune vaya ali'a haviya hupate'nayanake'a meni lapa'kaeya'ae ani kava hu'a apa'kaeya ali'a haviya hunelapatae. ");
INSERT INTO ino_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lapa'kaeya ma mopale mai'naya vaya'ai haka'ake hakekana hutapa mai'nae. Hakemo'a haka'a ako yaku yaku hiseana hana kava hutapa haka'a etetapa alitapa fole aikae? Haka'a ako yaku yaku hiseana afa ya'kana hisike'a ani hake vaya'moki ali'a ma'aileka atale'ne'a apaiyaleti alitata hu'a a'a kasokitekae. ");
INSERT INTO ino_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lapa'kaeya mi'ko ma mopale mai'naya vaya'ai ano ha lepatesea ya'kana hutapa mai'nae. Mako ala kumana avimate hane'nisea no kuma'mo'a fala o'kikeanake'a mi'ko vaya'moki akekae. ");
INSERT INTO ino_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vaya'moki ata kani ate'a samoleti ai'a ati'ka o'malekae. Ati'ka malesayana ano ha olekaiya'maki hipamo akofetule malesayana mi'ko nopaka ano ha lesike'a vaya'moki ake'a maikae. ");
INSERT INTO ino_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ina kava hukayanaki lapa'kaeya ani kava hutapa ata kani'mo ano ha lepatea kava hutapa Yisasi ke nehutapa vaya'ai apaulakale kanale au'ava kava hisake'a akete'a ko'ku'napi mai'nea afotapimo aki ali'a asaka hukae. ");
INSERT INTO ino_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Lapa'kaeya ma akufa lapa'kesa o'afeo “Mosese ke male male'nea ke'ae Anumaya Koti aune ke laka nehaya vaya'moki a'ke'ainaka hu'naya ke'ae Yisasi'a alino atalekefe e'ne.” hutapa oheo. Nakaeya ani ke ali'na o'atalekauva'maki ani ke ali'na fole aisukeno ne'yama'a fole aino lamake hisea yafe e'noe. ");
INSERT INTO ino_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nakaeya lamake hu'na lahapa'nepauve ma mopa'ae ko'ku'na'ae haneseana ke male male'nea kefi mi'ko aise aise o'akemo avo'atoto fanane ohuno afa'a hane'nisikeno ma mopa'ae ko'ku'na'ae hano huno fanane huke. Mi'ko hu'nea ke fole aino ne'ya'a aliteno lamake ohisikeno mako yama'a afa ya'kana huno fanane ohuke. ");
INSERT INTO ino_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mako vaya'moki “Ani ke male male'nea ke aisema'a a'kame o'malekauve.” nehuno mako vaya'aife “A'kame o'maleo.” huno nehea ve'kamo'a Anumaya Koti'a kava yakaisea kumate aise ve'ka maikea'maki mako ve'kamo'a mi'ko ke male male'nea ke alino a'kame nehuno mako vaya'aife “A'kame maleo.” huno hapapaiseana Anumaya Koti'a kava yakai'nea kumate apa'kaseno ala aki hanesea ve'ka maike. ");
INSERT INTO ino_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nakaeya lahapa'nepauve lapa'kaeya Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'moki'ae hu'naya alakepa au'ava kava akasetapa lusi kanale alakepa kava ohisayana lo'kiyatapi o'male'neanaketapa Anumaya Koti'a kava yakai'nea kumate haitapa o'maikae. ");
INSERT INTO ino_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Lapa'kinakomoki afi'naya ke lapa'kaeya ako afi'nae inake hu'neane “Vaya apamaki'ka kio'apato. Mako ve'kamoka mako ve'ka amaki'ka kitesanana kake hukatekae.” hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hu'nea'maki meni nakaeya lahapa'nepauve mako ve'kamo'a vaya'aife aipa kafa hapaeseana Anumaya Koti'a kake hutekaiye. Mako ve'kamo'a vaya'aife “Hao'otake kava'ake ve'ka mai'nane.” huteseana kanisole vaya'ai apaulakale avaleno kake hutekaiye. Mako ve'kamo'a vaya'aife “Kakaeya anekinaki ve'ka mai'nane.” huno huteseana hani yapi ata leke leke nehea atafi uke. ");
INSERT INTO ino_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ukea'maki kakaeya mono nopi u'ka “Anumaya Kotiteka amuse ya amisoe.” hu'kaena anile mai'ne'ka “Vae vaya'ni haviya hute'nokeno aipamo'a haviya nehe.” hu'ka kakesa afite'ka Anumaya Kotiteka amikefe hisana yana anile malete'ka vaya'ka'ae u'ka lanaipa makote maletana hutana falu hutetana ete'ka “Anumaya Kotiteka amikoe.” hu'ka hu'nana amuse yana ameo. ");
INSERT INTO ino_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mako ve'kamo'a “Hao'otake kava hunate'nananake'na kake hukatekauve.” huno kavaleno visike'kaena kateka ne'utana ani ve'ka'ae ke hutetana “Vaya'nimoka kaipamo'a falu kahaisea ya kamikoe.” hu'ka hapaiyo. Ina kava ohisanana kavaleno kake hukate ve'kale vinakeno kake hukate ve'kamo'a afiteno inaleti ati ve'kamo ayapi katesikeno kavaleno nofi hukatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nofi hukatesike'kaefena lamake hu'na lahapa'nepauve kake hukate'nea ve'kamo'a nameo huno hu'nisea ya o'ami'nisanana nofi nopati atale'ka ma'ailaka o'mekane hu'nae nehoe huno Yisasi'a nehe. ");
INSERT INTO ino_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Lapa'kaeya ako afi'nae a'ke'ainaka kemo'a inake huno hu'neane “Kumai kavana oheo.” hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ina ke hu'nea'maki nakaeya lahapa'nepauve mako ve'kamo'a mako a akeno ha'ye huno “Ani a'ae ina kava hukoe.” huno aipa akesa afiseana ani ana ako avayu huno kumai kava ako hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lamaka aupalika hane'nea kaulakamo'a akea ya'mo'a kavaleno yakaleno havi kapi visana kakesa kamisike'kaena ani kaulaka ali'ka kati'ka yaka hutalo. Ali'ka katisanana kanalene. Lapa'kaeya mako kaya lapa'kufa atalesayana kanale hutapa maikaya'maki ani kava ohisayana lapa'kufa mi'ko hani yapi ata leke leke nehea atafi kavaleno yaka hutalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lamaka kaya'mo'a “Havi kava ho.” huno kavaleno yakaleno havi kapi visana kakesa kamisike'kaefena ani kaya hataka hu'ka atalo. Hataka hutalesanana kanalene. Mako kaya kakufa o'male'niseana kanalenaki haviku lapa'kufa mi'ko hane'neno hani yapi akola leke leke nehea ata kapi kavaleno yaka hutalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A'ke'ainaka mani kemo'a va'yi hiketapa afi'nae. “Mako ve'kamo'a a'a hafaino'aefena ani ve'kamo'a a'amofe ‘Ako kahafauki uvo.’ avo kano ne'amino hutesikeno hano huno uke.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hu'nea'maki nakaeya lahapa'nepauve mako ve'kamo'a a'a hafaisuno'aena ani afe “Kumai a mai'nane.” huno hute'nea'maki mako ve'kamo'a ani hafai'nea a aliseana ani ve'kamo'a kumai kava nehe. Nehea'maki mako a'mo'a hokoteno kumai kava hiseana anau'amo'a kanale afa'a atalese. ");
INSERT INTO ino_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Lapa'kaeya ako afi'nae a'ke'ainaka mai'naya vayana hapapai'naya ke mako kemo'a inake hu'neane “Kakaeya mako yafe ‘Anumayamo aulakale lamake nehoanake'na ina ya hukoe.’ hu'ka hana ya alakepa hu'ka ani kava ho.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hu'nea'maki nakaeya lahapapauve lapa'kaeya “Anumaya Koti aulakale lamake nehoe.” hutapa oheo. Ko'ku'nana Anumaya Koti'a yakai'nea kuma hane'nea yafe lapa'kaeya “Ko'ku'na'mo akile a'na lamake nehoe.” hutapa oheo. ");
INSERT INTO ino_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mopamo'a Anumaya Koti'a aiya hayo humaleno ne'maiya mopa hane'nea yafe lapa'kaeya “Mopamo aki a'na lamake nehoe.” hutapa oheo. Yelusalemu kumana ala Anumaya Koti kuma'a hane'nea yafe lapa'kaeya “Ani Yelusalemu aki a'na lamake nehoe.” hutapa oheo. ");
INSERT INTO ino_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Lamake nehoe.” hisu'kaena “Nakaeya lo'kiya nayo'ka a'nea ve'kamo'na lamake nehoe.” hutapa oheo. Lapa'kaeya lapayo'kaena “Anupa nayo'ka'ae lui nayo'ka'ae ao.” hutapa hisaya lo'kiyatapi o'male'neanaki ani ke oheo. ");
INSERT INTO ino_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“He.” hisutapaena ani he ke'ake heo. “He'e.” hisutapaena ani he'e ke'ake heo. Mako ketapi alino lo'kiya vaisea ke'ae hisayana Sata'a ani ke alino fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","A'ke'ainaka mani ke fole aiketapa ako afi'nae “Mako ve'kamo'a kaulaka alino katisike'kaena ani ve'kamo aulaka anona'a ali'ka kateo. Kavena aino ya'kesike'kaena anona'a ani kava hu'ka akaeya avena ai'ka ya'ko.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hu'nea'maki nakaeya lahapapauve mako ve'kamo'a havi kava hukatesike'kaena anona'a ani kava huo'ato. Mako ve'kamo'a lamaka kakalametale kamakisike'kaena “Mako kaya nakalametale'ae namakeo.” hukeno kamakino. ");
INSERT INTO ino_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mako ve'kamo'a “Haviya hunatane.” huno kake hukateno “Kakai'ka kakufale siota nameo.” hisike'kaena mako ala yasi siota'ka'ae ameo. ");
INSERT INTO ino_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mako kava ve'kamo'a “Afeno ya'ni ali'ka u'ka muka'aleti natete'ka ekane.” hisike'kaena ani u'ka natete'ka ekane hu'nea kumana akase'ka alu'ale visea kumate ali'ka uvo. ");
INSERT INTO ino_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mako ve'kamo'a “Mako ya'ka nameo.” huno hisike'kaefena afa'a ameo. Mako ve'kamo'a ani kava huno “Yo'ka namisanake'na henaka'a ete'na kamikuki nameo.” hisike'kaena ani ve'ka ka'kame'ya o'ameo. ");
INSERT INTO ino_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","A'ke'ainaka mai'naya vayana hapapai'naya ke ako afi'nae inake hu'neane “Kuma'kale mai'naya vaya'aife kahau kayamopafati kahainake'ka kame vaya'ka kaipa kafa heto.” hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hu'nea'maki nakaeya meni lahapa'nepauve kame vayatapimokife lahapau lapayamopafati lahapaino. Havi kava hune'katea ve'kaena “Aya ho.” hu'ka Anumayamoteka ke hu'ka afiko. ");
INSERT INTO ino_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ani kava hisayana ko'ku'napi mai'nea afotapimo nehea akufa kava nehutapa mafa'ne'a hamalekae. Anumaya Koti'a hutekeno yakemo'a va'yi huno kanale vaya'aite'ae hao'otake vaya'aite'ae mako'ke akufa avamete ano hale nelapate. Anumaya Koti'a hutekeno ani kava huno alakepa hu'a ne'maiya vaya'aite'ae hao'otake kava hu'a ne'maiya vaya'aite'ae mako'ke akufa avamete kona apamikeno ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vaya'moki apaipafati lapa'kaeyafe hapaisea vayafe lapa'kaeya'ae ani kava hutapa apa'kaeyafe lapaipafati nelahapaiseana ani kava hisaya yatena na akufa amuse ya alikae? Amuse ya alaki o'alikae. Hao'otake kava nehaya apa'kufaleti ta'kisi miya ne'alea vaya'moki'ae ani kava hu'a apa'kaeyafe apaipafati hapaiya vayafe nehapaiye. ");
INSERT INTO ino_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kakaeya'ka vaya'ae'ke kake hisayana afa ya'kana nehiki Yisasi ke o'afi'naya vaya'ae ani kava nehaki lapa'kaeya kame vayatapimo'ae kake heo. ");
INSERT INTO ino_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ani yafe lapa'kaeya ko'ku'napi mai'nea afotapimo'a alakepa kava'ake huno mai'nea yafe lapa'kaeya ani akufa avamete vaya mai'netapa kositapa alakepa kava'ake hutapa vayatama maiyo. ");
INSERT INTO ino_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yisasi'a mako ke inake huno hu'ne hae lapa'kaeya maitapa halove heo. Vaya'moki lapa'kete'a “Kanale ve'ka mai'ne.” hu'a amuse hulapatesaya yafe'ke apaulakale kanale kava oheo. Lapa'kaeya ina akufa kava hisayana ko'ku'napi mai'nea Afotapimo'a kanale miya olapamikea'maki anona'atapi ako hai ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ani yafe kakaeya vaya kafaluna aya hu'ka ne'ya amikefena fala'ki'ka ameo. Ameka apa'kufaleti apa'ke'atike kava'ake nehaya vaya'moki mono no'apifi'ae kateka'ae “Vaya'moki lake'a amuseti hulatesae.” hu'a nehaya akufa kava hutapa lapa'kaeya “Lakesae.” hutapa vaya hupatake'a ka'ka hu'a ka'ae vaya u'a hoko'oteo. Nakaeya lamake laha'nepauve ina akufa kava nehisaya vayana miya'api ako hai ali'nayanakeno Anumaya Koti'a mako'ae o'apamike. ");
INSERT INTO ino_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","O'apamikea'maki ani yafe kakaeya vaya kafaluna aya hu'ka mako ya amikefena lamaka kaya'kamo'a fala'kino alo hisea yana haoka kaya'mo'a o'akese. ");
INSERT INTO ino_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","O'akesea yafe ani kava hu'ka fala'ki'ka aya hisanana ani ya'ka Afo'kamo'a Anumaya Koti'a fala'ki kava haya kavana ne'akea ve'kakeno ake'neanakeno kanale anona'a eteno kamike. ");
INSERT INTO ino_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Lapa'kaeya Anumaya Kotiteka amuse hutapa afikekefena ameka apa'kufaleti apa'ke'atikeke vaya'moki nehaya kava hutapa Anumaya Kotina afio'keo. Ani vaya'moki mono nopi heti'ne'a Anumayamoteka afikesaya yafe'ke nehapauno ka atakunele heti'a mai'nisake'a vaya'ko'moki u'e'a nehu'a apa'kesaya yafe'ke nehapaiye. Lamake lahapa'nepauve ani akufa kava nehaya vayana alaki miya'api ako ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ako ali'nayanaki fala'ki'nike'a no'akaya Anumayaleka afikekefena kakaeya ma kava ho. No'kafi visana ya'moka kita kite'ka fala'ki'ka mai'ne'ka Afo'kamoteka ke hu'ka afikekeno fala'ki yapaka'ae ne'akea Afo'kamo'a kakele alino henaka'a miya'a'ka kamike. ");
INSERT INTO ino_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Anumayaleka afikekefena Anumayamo ke no'afea vaya'moki nehaya kava hutapa havikunaku kefati afio'keo. Anumayamo ke no'afaya vaya'moki “Anumaya Kotiteka lusi ke hisunana afa'a ketile afike.” apa'kesa ne'afea'maki ani ke hu'a afikesaya ke o'afike. ");
INSERT INTO ino_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","O'afikea'maki lapa'kaeya apa'kaeya hisaya kava oheo. Lapa'kaeya Afotapimoteka ke hutapa afio'ke'nakeno “Mako yati o'male'ne.” haya yana ako afi'ne. Ani yafe lusi ke oheo. ");
INSERT INTO ino_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lapa'kaeya “Anumayamoteka afikesune.” hutapaena make hutapa afikeo “Afotimoka ko'ku'napi mai'nane. Vaya'moki kaki ali'a asaka nehu'a ‘Fate akufa ve'ka mai'nane.’ hu'a hukatesae. ");
INSERT INTO ino_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kava yakaisana kana makale va'yi hise. Ko'ku'napi ne'kahaiya kava nehaya kava lakaeya'ae ma mopafi vaya'mokita hisune. ");
INSERT INTO ino_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Meni afina nesuna ne'ya lameo. ");
INSERT INTO ino_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Lakaeya hao'otake kava hulataya vayana lahapaone lapatone nehuta laipa falu yapati ani hao'otake ya'api alita atalepatonaki kakaeya ani kava hu'ka lakaeya hao'otake yana lahapaove lapatove nehu'ka kaipa falu yapati ali'ka atalelato. ");
INSERT INTO ino_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Lakaeya kana lahaisea kate'ae Sata'a ano lavataka hukefe hisea yapi'ae lavale'ka olato. Kava yakai ya'kaki lo'kiya'kaki ala kaki hanesea ya'kaki mi'koma'a'ka kakai'ka ya'akenakeno haneke haneke huno hanese. Lamake.” Inake hutapa afikeo. ");
INSERT INTO ino_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lapa'kaeya hao'otake kava hulapate'naya vaya'aife lahapaone lapatone nehutapa lapaipa falu yapati alitapa atalepatesayana ko'ku'napi mai'nea Afotapimo'ae ani kava huno hao'otake yatape lahapaove lapatove nehuno aipa falu yapati alino atalelapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Atalelapatekaiya'maki lapa'kaeya hao'otake ya hulapate'naya vaya'aife lahapaone lapatone nehutapa lapaipa falu yapati alitapa atale opatesayana ko'ku'napi mai'nea afotapimo'a ani kava huno hao'otake yatape lahapaove lapatove nehuno aipa falu yapati alino o'atalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne'ya mosi'netapa lapa'kaeya Anumaya Kotiteka afikekefena lapaukosamo'a ananu o'kino. Ameka apa'kufaleti apa'ke'atike kava hu'naya vaya'moki nehaya kava oheo. Ani vaya'moki apaukosafi hapa'ae la'nefa'ae fale'ne'a inake nehae “Vaya'moki ne'ya mosi'nona ya lake'a aeto hute'a laki ali'a asaka hukae.” hu'a nehaya'maki lamake hu'na lahapa'nepauve ani kava nehaya vayana amuse ya'api ako hai ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ako ali'naya'maki lapa'kaeya ne'ya mosi'netapa Anumayamoteka afikekefena liteti lapaukosa alitetapa masave faleo. Ani kava hisayana mi'ko vaya'moki “Ne'ya mosi'nae.” hu'a lapa'ke'a aeto ohukaya'maki Afotapimo'a fala'ki'nike'a no'akaya Anumaya Koti'a fala'kitapa nehaya kava ne'akea Afotapimo'a fala'kitapa nehaya yana akai'a ake'nea yafe kanale amuse yatapi lapamike. ");
INSERT INTO ino_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Moni afeno yatapi ma mopale alitapa anupa oheo. Alitapa anupa hisayana kalokalo hakesikeno ha'kano'moki ali'a haviya nehisake'a kumaya vaya'moki hai'a notapifati ani yatapi kumaya alikae. ");
INSERT INTO ino_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Alikaya'maki ani mopale yafe lapa'kesa afifi oheo. Henaka'a ko'ku'napi kanale ya alisaya yafe meni afina Anumayamofe lapa'kesa afitapa kanale hutapa maisayana mi'ko ya ko'ku'napaka malesakeno kalokalo hakeke ha'kano'mo'a alino haviya huke kumaya vaya'moki ani kumate hai'a kumaya'ya huke ohukae. ");
INSERT INTO ino_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Amuse yatapi hane'nea kumate lapaipamo'ae ani kumate hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Lapaulakamo'a lapaipafi ano halesea ata kani hane'ne. Lapaulakamo'a kanale huno hane'niseana mi'ko lapaipafi ano ha lekaiya'maki lapaulakamo'a haviya hu'niseana mi'ko lapaipafi hani kike. “Naipa ha le'ne.” hu'ka kaki ali'ka asaka hana afina kani'ka kaipafi asu he'nikeno lusi hani kino metapu a'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mako'ke ve'kamo'a aole kava ve'kala'ani “Ali'ya ve'ka'ani maisoe.” ohise. Ani kava hiseana mako kava ve'kae hai ne'vaino “O'nahaiya kava nehana ve'ka mai'nane.” hune'ateno mako kava ve'kae “Nahau nayamopafati ne'nahaiya ve'ka mai'nane.” huke. Mako kava ve'ka aipa ne'amino mako kava ve'kai “Afole o'nahaiya kava nehane.” hukea'maki lapa'kaeya'ae ani kava hutapa Anumaya Koti'ae moni afeno'ae “Lana'kaeya kava yakainate'ao.” hisayana ani aole yatala a'kame malesaya lo'kiyatapi o'male'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nakaeya lahapa'nepauve lapa'kaeya ameka lapa'kufale kanale hutapa maisaya yafe lapa'kesa lapa o'aiyo. “Meni na ne'ya nekaune na li nekaune?” hutapa oheo. Lapa'kaeya lapa'kufale “Na kenati havaikaune?” hutapa lapa'kesa afitapa lapa o'aiyo. Ne'ya ne yana afa ya hane'niki lapavamu hane'nisiketapa mai ya'ke akaseno kanale ya hane'ne. Ku'kena havai yana ameka lapa'kufale yanaki lapavamu alitapa mai ya'ke kanale ya hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Akekeo. Hale'a u'e'a nehaya namayaka'aite apa'keo. Apa'kaeya mako ya noha'kalayanake'a avina ne'ya hoyafakati ali'e'a no'apifi no'malaya'maki ko'ku'napaka Afotapimo'a ne'ya ne'apamiki lapa'kaeya Anumaya Koti aulakale namayaka apa'kasetapa o'mai'netapae nehafe? Lapa'kaeya'ae kava yakai lapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hana ve'kamoka “Ofali'na mako'ae maike maike hu'na mani mopale maime maime haikoe.” hu'ka lo'kiya kakesa afisanakeno ani kakesa afina avamete maikape? He'e o'maikane. ");
INSERT INTO ino_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Na'ya hiketapa ku'kenatape lapa'kesa lapa ne'aiye? Akekeo. Kahaufaka vilasi ya'moki hai'a ause nehae. Ali'ya alite'a kena'api alo hu'a nohavaiya'maki kanale kena'api ause hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nakaeya meni lahapa'nepauve a'ke'ainaka mai'nea ala kava ve'katapi Solomoni'a lusiya huno kanale'nale konakali kena'a havai'nea'maki ma vilasi ya'mo ause'amo'ke mako'ae kanale ya'a akase'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Meni kahau hoyafi hane'nea'maki eka'a ako he'a hataka hutalesakeno vaitesike'a atafi kakaya'maki Anumaya Koti'a ani kahaule kava yakaikeno kanale'ya hu'nea'maki lapa'kaeya mi'ko vaya'mokitapa nakaeyafe afitapa lapaipafi aise'a maletapa alakepa nohaya vaya'mokitapalena Anumaya Koti'a ani kava huno lapa'kaeya ku'kenatapile alino alakepa hulapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ina yafe lapa'kesa lapa o'aiyo “Na ne'ya nekaune? Na li nekaune? Na kena havaikaune?” hutapa lapa'kesa lapa o'aiyo. ");
INSERT INTO ino_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Anumaya Koti ke no'afea vaya'moki ma mopale yafe apa'kesa afifi hu'a ne'maiyanaki ko'ku'napi Afotapimo'a lapa'ke'neno nesaya ya'ae havaisaya ya'ae ako afi'ne. ");
INSERT INTO ino_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Afi'neanaketapa lapa'kaeya hokotetapa “Anumaya Kotika yakailato.” hutapa akai'a nehaiya alakepa kava hisaya yafe lapa'kesa afifi hutapa maisayana Anumaya Koti'a yakai lapateno mi'ko ne'yatapi'ae kenatapi'ae lapamike. ");
INSERT INTO ino_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lapamisea yafe “Eka hana kava hukune?” hutapa lapa'kesa lapa o'aiyo. Eka'a fole aike hisea ya fole aike. Ina kava hukea'maki mako'ke afina havi kana lahapaisea yafe ani yu'mepa'ake lapa'kesa afeo. ");
INSERT INTO ino_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Lapa'kaeya vayatapimokife “Ina akufa kava nehana ve'ka mai'nane.” huo'apateo. Ani kava huo'apatesayana Anumaya Koti'a ani kava huno lapa'kaeyafe “Ina akufa kava nehana ve'ka mai'nane.” huo'katekaiye. ");
INSERT INTO ino_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lapa'kaeya ani vayatapimokife “Hao'otake kava nehana ve'ka mai'nane.” hutapa hisayana inani akufa ke hana ke huno Anumaya Koti'a lapa'kaeya ani kava hulapatekaiye. Lapa'kaeya ma mopale vayatapimokite hupatesaya avamete Anumaya Koti'a inani avamete'ke lapa'kaeyate'ae ani kava huno anonatapile lapamike. ");
INSERT INTO ino_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Lakaeyati laipafi hane'nea ya afiteta alu vayafe “Hao'otake ve'ka mai'nane.” hisuna yafe Yisasi'a inake he na'ya hike'ka vaya'kamo aulakafi aise yosa aleto'na hane'nike'ka ne'akana'maki kakaeya'ka kaulakafi mako ala yosa a'kopa hane'nike'ka o'male'ne nehane? ");
INSERT INTO ino_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na'ya hike'ka vaya'kamofe “Kaulakafati yosa aleto'na ali'na atalekauve.” hu'ka nehana'maki kakai'ka kaulakafi mako ala yosa a'kopa hane'nike'ka o'male'ne nehane? ");
INSERT INTO ino_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kaipafi hane'nea ya ake'ka alakepa ohu'ne'ka ameka kavayaleti kake'atike nehananaki kakai'ka kaulakafati ala yosa a'kopa ali'ka atalete'ka henaka'a vaya'kamo aulakafi kanale ne'ake'ka aise yosa aleto'na ali'ka atalekane. ");
INSERT INTO ino_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lapa'kaeya amuse nehisaya fate akufa yana kala anakapina o'apameo. Ani kava hutapa Yisasi a'kame'ya ne'amea vaya'aina Yisasi kemo aepa'a hapa'opaiyo. Kanale sesutapi yaka hutapa afu anaka o'apameo. Apamisayana apaiyaleti a'a hapa ne'kale'a ai'a yahae humale'a lahapa'a nekae. Lahapa'a nesaya avamete Yisasina a'kame'ya ne'amea vayana Yisasi kemo aepa'a hapapaisayana afukana hu'a ani ke a'a hapa ne'kale'a lapa'kaeya ali'a haviya hulapatekae. ");
INSERT INTO ino_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Anumaya Kotiteka mako yafe afikesayana ako lapamike. Mako yafe kahau aesakeno'aena alino fole ailapatekaiye. Kipateti ke hisayana Anumaya Koti'a afiteno kita ya'kilapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mi'ko afine'kesaya vaya'moki alikae. Kahau aesaya vaya'moki ake'a fole aikae. Kipateti ke hisaya vaya'aina kita ya'kipatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hana ve'kamoka mafa'ne'kamo'a mayae ke nehiseana yafa ali'ka amikane? He'e ani yafa o'amikane. ");
INSERT INTO ino_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hana ve'kamoka mafa'ne'kamo'a “Faya ali'ka nameo.” nehiseana nakala ali'ka amikape? He'e ani nakala ali'ka o'amikane. ");
INSERT INTO ino_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","O'amikana'maki lapa'kaeya hao'otake vaya'mokitapa mafa'netapi kanale ya ne'apameanakeno ko'ku'napi mai'nea Afotapimo'a lusiya huno lapa'kase'neanaketapa afikesakeno lusi kanale ya lapamike. ");
INSERT INTO ino_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Lapa'kaeya vayatapimokife “Ina kava hulateo.” hutapa hisaya kava lapa'kaeya hokotetapa hupateo. Ani kavana Mosese'ae Anumaya Koti aune vaya'moki'ae ke male male'naya kemo aepa'a hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Anumaya Koti kumate visaya kipana aise kipa hane'neanaketapa haitapa faleo. Hani kumapi ata leke leke nehea atafi visaya ka'mo kipana ala kipa'ae ala ka'ae hane'nike'a mi'ko vaya yo'yo hu'a ani kate ne'vae. ");
INSERT INTO ino_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ne'vaya'maki akola maike maike hisuna kumate visaya kipa'ae ka'ae aise hu'neanake'a lusi akaso ali mai'a ani kate ne'vaya'maki nesu vaya no'vae. ");
INSERT INTO ino_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yisasi'a inake he mako ve'kamo'a “Anumaya Koti ke hu'na fole ne'auva ve'ka mai'noe.” huno ake'atike'ake ke nehiseana lapa'kaeya ani ve'kaena maitapa halove huteo. Ameka akufa'amo'a sipi sipi afukana huno ne'eketapa ne'akaya'maki aku'ainaka'a afela kalakana ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lapa'kaeya apa'kaeyapati va'yi nehea kava aketetapa aepa'a hana akufa vaya mai'nae hutapa afikae. Aufe nofi hane'nea nofiteti li hane'nea alaka lakikife? He'e olakike. Akaso'ake hu'nea kahaumo'a haka'ake yu'yu alaka lakikife? He'e olakike. ");
INSERT INTO ino_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Olakikaya'maki kanale yosamo'a kanale alaka ne'aeya'maki havi yosamo'a havi alaka'a ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kanale yosamo'a havi alaka o'aesikeno hao'otake yosamo'a kanale alaka'a o'akaiye. ");
INSERT INTO ino_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mi'ko yosamo'a kanale alaka no'aeyana hataka hu'a atafi kane'atalae. ");
INSERT INTO ino_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ina kava hinaketapa lapa'kaeya akekae apa'ke'atike'ake ke huno fole ne'aiya vaya'aipati alaka'a va'yi hea kava aketetapa aepa'api hana akufa vaya mai'nae hutapa afikae. ");
INSERT INTO ino_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mi'ko vaya'moki nakaeyafe “Anumaya'nimokae Anumaya'nimokae.” hu'a hisaya vaya Anumaya Koti'a kava yakaisea kumate ohaikaya'maki ko'ku'napi mai'nea Afo'nimo hau'nea aipa akesale a'kame ne'malesaya vaya'mokike ani kumate hai'a falekae. ");
INSERT INTO ino_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anumaya Koti'a kake hupatesea afina mi'ko vaya'moki nakaeyafe inake hu'a hukae “Anumayatimokae Anumayatimokae lakaeya kakaeya kaki ne'ata Anumaya Koti ke huta fole ai'nonane. Kakaeya kaki ne'ata Sata afe'yaka alita apatale'nonane. Kakaeya kaki ne'ata o'ake'naya avame hu lo'kiya ya apaveli'nonane.” hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hukaya'maki nakaeya ani afina make hu'na fole aipatekauve “Lapa'kaeya olapa'ke'noa vaya mai'nae. Hao'otake kava'ake alo nehaya vayanaki lapaune hetapa nakaeyatekati veo.” hu'na hukoe. ");
INSERT INTO ino_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ani yafe mi'ko vaya'moki nakaeya ke ne'afi'a a'kame huke huke nehisaya vaya'moki mako akenopafi hale'nea ve'kamo hu'nea kava hu'a nehae. Ani ve'kamo'a yafa akofetule no'a kimale'ne. ");
INSERT INTO ino_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kimale'nikeno ko ne'aino li neheno lusi yasi ne'alino no alino kape lekefe hu'nea'maki ani nona yafa akofetule kimale'nea yafe alino kape ole'ne. ");
INSERT INTO ino_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kape ole'nea'maki mako ve'kamo'a nakaeya ke afiteno ani ke a'kame o'malesea ve'kamo'a akesa o'male ve'ka afa'a li kahaepate no ki'nea ve'kakana nehe. ");
INSERT INTO ino_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ani no kimale'nikeno ko ne'aino li neheno lusi yasimo'a ani nona alino kape kapu leno alino haviya hutale'ne. ");
INSERT INTO ino_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yisasi'a mani ke huno hano huteke'a mi'ko anile mai'naya vaya'moki akaeya ke afi'a apamo'yo ne'aikeno Yisasi'a mono hapali'a hapa'nepaiya vaya'moki nehaya akufa ke nohea'maki lo'kiya'api'ae vaya'moki nehaya ke nehea yafe ani vaya'moki apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisasi'a avima ataleno nelavike'a lusi vaya'moki a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A'kame ne'vakeno mako afuko ya ake'nea ve'kamo'a Yisasite eno aiyafi ale'ya alo ne'ano inake he “Anumaya'nimoka nakaeyafe kahau hisike'kaena ali'ka kanale hunatanine.” ");
INSERT INTO ino_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hikeno Yisasi'a aya akufale aya huno atafa nehuno inake he “Kanale hukatesoa yafe ne'nahaiyanakeno kakufa meni kanale hino.” huno nehikeno hae makale'a ani afuko kali'a hano hutekeno akufamo'a kanale hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kanale hutekeno Yisasi'a inake huno hapai'ne “Kava hu'ne'ka kakaeya ali'na kanale hukate'noa yafe mako ve'ka alaki ha'opai'ka hokote'ka mono nopi kava ve'kale ukeno kakufa valava kano aketesike'ka mi'ko vaya'moki kali'ka hano hu'ne hu'a afisae hu'kaena a'ke'ainaka Mosese ke hapapai'nea kava hu'ka ‘Ma ya Anumayamoteka ameo.’ huno hu'nea ya meni amisanake'a mi'ko vaya'moki kali'ka hano hu'ne hu'a hisae.” ");
INSERT INTO ino_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yisasi'a Kapaneamu kumate uno va'yi nehikeno mako kaya naya hano hea vaya'ai apaiya apaya hano hea avamete ati vaya'aite (100) kava ne'yakaiya ve'ka'ae fotu hute'ana ani kava ve'kamo'a Yisasife inake huno ke nehe “Vae Anumayamoka nakaeya ali'ya ve'ka'ni'a alaki ayamufa avayu hulavikeno lo'kiya'a o'malekeno lusi akafu ne'kikeno nopi havano mai'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nehikeno Yisasi'a akaeyafe inake he “Nakaeya u'na ani kali'a ali'na kanale hutekauve.” ");
INSERT INTO ino_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hapaiya'maki ani ati vaya'aite kava ve'kamo'a Yisasife inake he “Vae Anumayamoka nakaeya no'nifi esanana kanale o'katekaiki afa'a ke'ake nehisanakeno ani ali'ya ve'ka'nimo kali'a kanale huteno. ");
INSERT INTO ino_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nakaeya kakaeya'kana hu'na kava ve'ka mai'noe. Nakaeyate yakai'nea ve'kamo'a hanale mai'nike'na nakaeya ani kava hu'na mako ati vaya'aite kava ali'na yakaipate'noe. Mako ve'kae ‘Uvo.’ hukeno'aena ne've. Mako ve'kae ‘Eno.’ hukeno'aena ne'e. Ali'ya ve'ka'ni'ae ‘Ina kava ho.’ hukeno'aena ani kava nehe.” ");
INSERT INTO ino_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nehikeno Yisasi'a ani ke afiteno amo'yo ne'aino mi'ko a'kame e'naya vaya'aife inake he “Nakaeya lamake hu'na lahapa'nepauve alaki mako Isaleli ve'kamo'a ma kava ve'kamo hea kava huno nakaeyafe afino aipafi maleama'a o'ake'noe. ");
INSERT INTO ino_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lamake lahapa'nepauvanaki afeo. Lusi vaya'moki yake haino ne'eatekati'ae yake lavino nefaleatekati'ae Anumaya Koti kava alino yakaisea kumate e'a mai'ne'a lakinakomoki Epalahamu'ae Aisa'ki'ae Ye'kopu'ae mai'ne'a ne'ya nekae. ");
INSERT INTO ino_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nekaya'maki a'ke'ainaka Anumaya Koti'a Yuta vaya'aife ‘Nakaeya kava ali'na yakaisoa kumate maikae.’ huno hu'nea'maki akaeyafe afi'a apaipafi o'male'naya yafe meni Anumaya Koti'a hani kumapi alino apatalesike'a lavikae. Ani kumapi avi nele'a avovo avava nehu'a apave kemo'a nehinakeno lusi apa'kufa apa'kafu kisea yafe lusi kalaki aikae.” ");
INSERT INTO ino_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yisasi'a ani Lomu ati vaya'aite kava yakai'nea ve'kaena inake huno hapai'ne “Kakaeya ali'ya ve'kamo kali'a nakaeya ali'na kanale hutesoa yafe afi'ka kaipafi male'nana yafe ali'na kanale hutekauvanaki no'kaleka uvo.” huno hute'ne. Ani kake neha'a kanatofi ani ali'ya ve'ka'amo kali'a eteno kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisasi'a Pita nopi haino akeana Pita a'mo ita'amo'a lusi amu'ko kali aliteno hipale havano mai'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aketeno Yisasi'a ani a'mo ayate ame'ko ne'alikeno ani amu'ko kali'a hano hutekeno hetino Yisasi ne'ya ka'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ani unena ani kumate vaya'moki Sata afe'mo'a apaipafi mai'nea vaya'yaka nesu yate apavale'a Yisasite e'nae. Akeno Yisasi'a ke nehuno ani Sata afe'yaka alino ne'apataleno mi'ko vaya'ai kali'ae alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ani kava hu'nea yafe a'ke'ainaka Anumaya Koti aune ve'ka Aisaiya'a hu'nea kemo'a ani kanale fole aino ne'ya'a aliteno lamake nehe. Ani ke inake hu'neane “Akaeya akai'ake mi'ko ali'nona kali alino ataleteno lakufa fulu fulu huta lo'kiya no'aluna ya'ae ako alino atale'ne.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lusi ve a'nemoki Yisasi a'kame ne'vakeno aketeno akaeya ke ne'afea anaka'aife inake he “Li la'ka heta mekakaya aupalika viketao.” ");
INSERT INTO ino_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nehikeno mako mono ke hapalino hapa'nepaiya ve'kamo'a Yisasite eno inake he “Ali'ka apaya nehana Nenao mi'ko kakaeya u'ke'ka hisana kumate ka'kame u'ne'na hukoe.” ");
INSERT INTO ino_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nehikeno Yisasi'a akaeyafe inake he “He kanale'maki afela kalamoki hamai kapi havake'a namamoki'ae ani ya hu'a havaesaya no'api hane'nea'maki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na nakenopa nafita aimale'na havaesoa no'ni o'male'ne.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nehikeno mako akaeya ke ne'afea ve'kamo'a make huno he “Anumayamoka kanalenake'na afo'nimo falitesike'na ali'na kitete'na henaka'a kakaeya ka'kame ekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yisasi'a akaeyafe make huno hapai'ne “Afa'a aote ya'aki atalo. Apa'kaeya nakaeya ke o'afi'a maikeno apa'ku apame fali'nea vaya'moki falisea ve'ka apa'kai'api yanake'a ali'a kitekayanaki atale'ka nakaeya na'kame'ke eno.” ");
INSERT INTO ino_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisasi'a mako lipi kalefi haino asaka hune'maike'a akaeya ke ne'afea anaka'ae a'kame u'a hai'a asaka humai'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hai'a asaka humaikeno Yisasi'a ako au'kaleno mai'nikeno makale'a ani li kotupatina lusi yasi ne'alikeno li'mo'a aino kalafu'nafu aino ani lipi kale ano ati'kakefe hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Apati kakefe nehikeno Yisasi'a ako au'kale'nike'a u'a ali'a auna nehe'a make hae “Vae Anumayatimoka li'mo'a ano lati'kaesiketa falisuna kava nehiki heti'ka lakufa ali'ka kateo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nehakeno Yisasi'a hetino make huno apafine'ke “Na'ya hiketapa koli nehae? Nakaeyafe afitapa lapaipafi male'naya yatapi aise'ato'a hane'ne.” Inake huteno hetino ani yasi'ae li'aefe ke anama'kino “Ina kava ohi'ao.” hikeno yasi'ae li'ae mate'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma'neta'ake'a ani vaya'moki apamo'yo ne'ai'a inake hae “Ma ve'ka hana akufa ve'ka mai'nikeno yasimo'ae li'mo'ae ke'a afi'a a'kame ne'mala'ae.” ");
INSERT INTO ino_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ala li kotu la'ka he'a mekakaya aupalika aki'naleka mako kuma Katala vaya mai'naya kote u'nae. Aole ve'kala'mokani anaipafi Sata afe'yaka mai'nake'ana vaya ki ne'apataya yapakake ne'mai'a ve'kala'mokani Yisasina e'ana ake'na'ae. Ani ve'kalana alaki afela he'na'ake'a mi'ko vaya'moki ani ve'kale ne'mai'a aupalika kate u'e'a nohayane. ");
INSERT INTO ino_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","U'e'a nohaya'maki ani ve'kala'mokani Yisasina akete'ana ala kefati inake hu'ana ke hapai'na'ae “Kakaeya Anumaya Koti Mafa'nemoka la'akaeya na kava hula'atekefe nehane? La'akufu la'akafu kisea kana saufa va'yi ohu'nea'maki kakaeya la'akufa la'akafu kisea ya hulatekefe ne'ape?” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Neha'a'maki alu'ale mako nesu afu anaka mai'ne'a ne'ya ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ne'nake'a ani Sata afe'yakamoki Yisasife huke lakauke ohu'a inake hae “Anaipafati ali'ka latalekefena mika mai'naya afu anaka'moki apaipafi hulateketa haita faleno.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ha'akeno Yisasi'a “Kanalenaki anifi haiyo.” huno hike'a ani aole ve'kala'mokani anaipafati ne'anatale'a ani afu anaka'ai apaipafi hai'nae. Hai'a falake'a ani afuyakamoki naku naku lavite lavite haya'ya'moki mako muli kapi lavite'a li kotupi asaka hu'a aite'a li ne'a apamu pate'a fali'a hano hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Fali'a hano hake'a ani afu anaka'aite kava ne'yakaiya vaya'moki apaune he'a vaya'ya'moki ala kumate u'a ani kumate mai'naya vaya'aina mi'ko ake'naya ya Sata afe'yaka aole ve'kala'mokani anaipafati alino atale'nea avake hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hapapaike'a ani ke afite'a mi'ko ala kumate mai'naya vaya'yaka e'a Yisasina akete'a inake hae “Ma kumateti atale'ka alu kumate uvo.” hu'a lo'kiya kefati hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisasi'a mako lipi kalefi haino maiteno li kotu la'ka heno akai'a kumate u'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uno mai'nikeno mako kali ve'ka aiya aya avayu hu'nea ve'ka sifanale havano mai'nike'a avale'a Yisasite e'nae. Akeno Yisasi'a aketeno inake huno akesa afi'ne “Vae ma vaya'moki nakaeya ke afi'a apaipafi male'nae.” nehuno ani kali ve'kaena inake nehe “Mafa'ne'nimoka meni koli ohu'ka nakaeya kahaove katove nehu'na naipa falu yapati hao'otake ya'ka ako ali'na atalekatoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nehike'a mako mono hapali'a hapa'nepaiya vaya'moki apa'kai'api apaipafi inake hu'a nehae “Ma ve'kamo'a Anumaya Kotife huno haviya hune'ate.” ");
INSERT INTO ino_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nehaya'maki Yisasi'a apaipa apa'kesafi afea ke aketeno inake he “Na'ya hiketapa lapa'kaeya havi lapaipa lapa'kesa ne'afe? ");
INSERT INTO ino_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nakaeya ne'aloa ali'yana hana ali'ya'mo'a kana'a hane'ne? Nakaeya kahaove katove nehu'na naipa falu yapati hao'otake ya'ka ako ali'na atalekatoe hu'na hoa kava'mopi kali ve'kae kali'ka ali'na kanale hukatoki heti'ka hipa'ka alite'ka uvo hu'na hoa ali'ya'mo'ae? ");
INSERT INTO ino_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ani yafe nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na ma mopale mai'ne'na kahaove katove nehu'na naipa falu yapati hao'otake yatapi ako ali'na atalesoa lo'kiya'ni hane'nea yafe lapa'kaeya afitapa halesaya yafe mako kava hu'na lapavelikoe.” nehuno aiya aya avayu hulavi'nikeno lo'kiya'a o'male'nea ve'kae inake he “Heti'ka sifana'ka ne'ali'ka no'kaleka uvo.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hutekeno hetino no'aleka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ne'vike'a mi'ko ali'a atalu hu'naya vaya'moki ani kava hea ya akete'a apamo'yo aike'a Anumaya Koti'a lo'kiya'a vaya apami'nea yafe aki ali'a asaka nehae. ");
INSERT INTO ino_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anile apataleno ne'uno mako ve'ka aki'a Matiu'a kumaya'ya huno vaya apa'kufaleti ta'kesi miya ne'alea note faitopale mai'nikeno Yisasi'a ani ve'ka aketeno inake he “Kakaeya na'kame eno.” Nehikeno Matiu'a hetino Yisasi a'kame u'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","U'nikeno Yisasi'ae akaeya ke ne'afea anaka'ae Matiu nopi mai'ne'a ne'ya nekefe nehake'a nesu kumaya'ya nehu'a apa'kufaleti ta'kesi miya ne'alea vaya'ae mako hao'otake kava nehaya vaya'ae e'a Yisasi'ae lo'ka'a faitopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mai'nake'a Falasi mono ke ne'afea vaya'moki ani vaya apa'kete'a Yisasi ke ne'afea anaka'aife inake hae “Na'ya hikeno lapa'kaeya alino lapaya nehea ve'kamo'a kumaya'ya hu'a vaya apa'kufaleti ta'kesi miya ne'alea vaya'ae hao'otake kava nehaya vaya'ae ne'ya ne'ne?” hu'a apafine'kae. ");
INSERT INTO ino_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Apafine'kakeno Yisasi'a ani ke afiteno inake he “Kali'api o'male'nea vaya'moki Tota ve'kale o'ukaya'maki kali vaya'mokike Tota ve'kale ukae. ");
INSERT INTO ino_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nakaeya ina kava hu'na ‘Alakepa vaya mai'none.’ hu'a nehaya vaya'aife ke hukefe o'me'noa'maki hao'otake kava nehaya vaya'aife ke hisoa yafe e'noe. Anumaya Koti'a akai'a hu'nea ke kamale'naya avopi inake hu'neane ‘Afu he'a kola'a la'ki'a ne'namea kavafe o'nahaiki vaya kalaki aipate kavafe ne'nahaiye.’ hu'neane. Hu'neanaketapa lapa'kaeya utapa ani kemo aepa'a afitapa alakepa hutetapa ani kava heo.” ");
INSERT INTO ino_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yoni ke ne'afea vaya'moki Yisasite e'a inake hu'a afine'kae “Lakaeya'ae Falasi mono ke ne'afea vaya'ae ne'ya mo'nesuna'maki na kava hike'a kakaeya ke ne'afea vaya'moki ne'ya mo'osi'a afa'a ne'nae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Afine'kakeno Yisasi'a inake he “A alikefe nehea ve'kamo'a a alikefe hisea afina vaya'a'ae mai'nisike'a ani vaya'moki hapau hukafe? He'e hapau ohukaya'maki henaka alu kana va'yi hisike'a kame vaya'moki ani a'mo anau'amona atafa hu'a apa'kaeyapati avalesaya kanafi hapau hukae. ");
INSERT INTO ino_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mako ve'kamo'a saufa kenamo atupa alino atafa kena vala ai'nisea kate maleno ohatike. Maleno hatiseana saufa kenamo atupamo'a atafa kena ako alino vala aisikeno mako'ae ala huke. ");
INSERT INTO ino_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ani kava hu'a mako vaya'moki haekafa nofi alakamo li mememo akufaleti alo humale atafa kepi la'ki'a no'vaiye. La'ki'a vaisayana li'mo'a kala ateno alunu aisikeno li ke apalo huno la'ki lavino ani li ke alino haviya huke. Haekafa nofi alakamo li saufa mememo akufaleti alo humale kepi la'kino ne'vaiye.” ");
INSERT INTO ino_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisasi'a ani ke hapa'nepaikeno mako kava ve'kamo'a eno Yisasi aiyafi ape hu'neno Yisasife inake he “Ala Nenao a'mafa'ne'ni ako fali'niki kakaeya e'ka kaya akufale malesanakeno fali'neapati eteno hetike.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nehikeno Yisasi'a makale hetino ne'vike'a akae ke ne'afea anaka'ae heti'a a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ne'vakeno mako a'mo'a ayatala'a hano huteno aiyalekati aole uno alea kafu aiku ya akekeno maike maike huno ne'maiya a'mo'a Yisasi a'kamelekati eno kena atupa'ale ame'ko ne'ale. ");
INSERT INTO ino_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ani a'mo'a ina akufa akesa afi'ne “Kena'ale'ke ame ne'alisukeno kali'ni'a kanale hunatekaiye.” huteno ame'ko ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ame'ko alikeno Yisasi'a maino yahae huno ani ana aketeno inake he “Mafa'ne'nimoka koli ohu'ka nakaeyafe afi'ka kaipafi male'nana ya'kamo'a meni kali'ka alino kanale hukate'ne.” nehikeno makale'a ani kali hano hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Hano hutekeno Yisasi'a kava ve'kamo note uno va'yi huno akeana mi'ko vaya'moki hapau nehu'a nama ali'a kayo ne'aiya vaya'ae avi nelaya vaya'ae ali'a atalu hu'ne'a kaleso ne'aiya ke Yisasi'a afiteno inake he “Lapa'kaeya mi'ko hatilaveo. Mani a'mafa'ne ofali'nifa afa'a havano mai'ne.” huno hapapai'nea'maki ani ve a'nemoki ani a'mafa'ne ako falike'a ake'naya yafe Yisasi'a ofali'ne huno hea ke ne'afi'a kiki'a hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kiki hune'atakeno “Kumateka hatilaveo.” huno hupateteno Yisasi'a nopi haino ani a'mafa'nemo ayate atafa nehikeno makale'a heti'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hetikeno Yisasi'a alino hetitea avake'amo'a uneno hike'a mi'ko ani kote vaya'moki afi'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisasi'a ani kuma ataleno ne'vike'ana aole ve'kala anaulaka apo ka'nea ve'kalana a'kame ne'u'ana ka ne'a'ana inake neha'ae “Kakaeya Teviti akeho'amoka la'akaeya kalaki aila'ato.” hu'ana ka ne'a'ae. ");
INSERT INTO ino_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka ne'a'akeno Yisasi'a nopi haino nefaleke'ana anaulaka apo'ka'nea ve'kala'mokani akaeyate a'akeno Yisasi'a ani ve'kalafe inake huno anafine'ke “Nakaeya lanaulaka ali'na kanale hulanatesoa lo'kiya'ni hane'nea yafe afitana lanaipafi ako male'na'afe?” hike'ana “He kakaeya ani kava hula'atanine Anumayati'amoka.” ");
INSERT INTO ino_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Inake ha'akeno Yisasi'a anaulakale aya ne'maleno inake he “Lana'kaeya nakaeyafe afitana lanaipafi male'na'a yafe ani kava makale hulanatekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nehike'ana ani ve'kala'ani anaulakamo'a halai huno kanale hunate'ne. Kanale hu'natekeno Yisasi'a ana'kaeyafe lo'kiya ke huno anaumomo maleno inake he “Mako vaya'aife mani hulanatoa ya hapa'opai'ao.” he. ");
INSERT INTO ino_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hu'nea'maki ani ve'kala'mokani hatilavi'ana Yisasi'a hunate'nea avake'a hulitata ha'ake'a mi'ko ani kote vaya'moki afi'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ani aole ve'kala ne'va'ake'a mako ve'ka Sata afe'mo'a aipafi mai'neno liko'ke'a alino a'kanile'nikeno ake no'aiya ve'ka Yisasite avale'a e'nae. ");
INSERT INTO ino_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Avale'a akeno Yisasi'a Sata afe aipafati alino ne'atalekeno liko'a hakalo hikeno avenafu'namo'a uno no'ale hikeno kanale'ya huno ake ne'aike'a afea vaya'moki lusi apamo'yo ne'ai'a inake nehae “Mani akufa kavana a'ke'ainaka Isaleli mopafi o'ake'nona kavane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nehaya'maki Falasi mono ke ne'afea vaya'moki inake hae “Sata afe'yaka'ai kava ve'ka'apimo lo'kiya'aleti mani Sata afe alino ne'atale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisasi'a ala kumate'ae aise aise kumate'ae uneno nehuno mono no'apifi haino alino apaya nehuno Anumaya Koti kanale'ya huno yakaipatesea yafe kanale ke hapa'nepaino mi'ko kali vaya alino kanale hune'apateno lo'kiya'api o'male'nea vaya'ae alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Alino kanale hune'apateno mi'ko ali'a atalu hu'naya vaya apa'keteno kalaki aine'apateno inake huno akesa afi'ne “Ma vayana sipi sipi ana'aukana hu'nakeno apaipa apa'kesa'amo'a mako'ke kate male'a o'mai'naya yafe haviya hu'a mai'naya'maki kava yakaipatesea ve'ka o'mai'ne.” huteno kalaki aine'apate. ");
INSERT INTO ino_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Kalaki aipateteno Yisasi'a akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Nakaeya ke no'afea vaya'moki lusiya huno ne'ya'mo'a keteno avina aleteno maiya kava hu'naya'maki hoya'nifi ali'ya vayana ho'ka'a o'mai'nayanaketapa lapa'kaeya lusiya hutapa hoyamo afo'amoteka ke hikeno ali'ya vaya'a hupatesike'a u'a ne'ya ali'a anupa hunatesae.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisasi'a ayatala'a hano huteno aiyalekati aole alea anaka'aife ke hike'a akaeyate akeno Sata afe ali'a ne'atale'a ve a'nemoki aki'ae aka'ae kali'api ali'a kanale hupatesaya lo'kiya apami'ne. ");
INSERT INTO ino_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Akai'a ayatala'a hano huteno aiyalekati aole alea anaka'moki akaeya ke ne'afikeno hupate'nea anaka'ai apa'ki male hane'ne. Hokote ve'kamo aki'a Saimoni'ae mako aki'a Pita'ae. Etalu'a Saimoni akana'amo'ae. Yemisi'ae akana'amo'a Yoni'ae Sepeti mafa'nela mai'na'ae. Filipi'aki Patalomiu'aki Tomasi'aki Matiu'a ta'kesi moni ne'alea ve'kaki Yemisi'a Alafiasi mafa'neki Tatiasi'aki Saimoni hamo'amo'a Seloti anaka nofipati ve'kae. Yutasi Isa'kalioti'a akaeya henaka'a Yisasina akesi huno kame vaya'ai avaleno apamisea ve'kae. ");
INSERT INTO ino_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisasi'a ani ayatala'aki aiyalekati aole alea anaka'a ali'yate hune'apateno inake he lapa'kaeya Isaleli nofi o'mai vaya'aipi'ae Samelia vaya'ai kumapi'ae alaki o'veo. ");
INSERT INTO ino_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","O'utapa Isaleli nofi vaya'moki sipi sipi afu anaka'kana ohu'a afela he'nayanaki lapa'kaeya ani afela he'naya Isaleli vaya'aite veo. ");
INSERT INTO ino_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Utapa make hutapa hapapaiyo “Anumaya Koti'a kava yakai lapatesea kanamo'a ako eno lavate'ne.” hutapa hapapaiyo. ");
INSERT INTO ino_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nehutapa lapa'kaeya utapa kali vaya alitapa kanale hupateo. Fali'nisaya vayana alitapa heti ne'apatetapa fuko ya apa'ke'nisea vaya'ae alitapa kanale hune'apatetapa Sata afe vaya'moki apaipafati hapafaitaleo. Meni lapamuketapa ne'alea lo'kiya yana afa'a ne'aleanaki apaya hisake'a kanale hisaya yateti miya o'alitapa afa'a apaya heo. ");
INSERT INTO ino_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lapa'kaeya moni haita'afi alaka'afi kutapifi o'alitapa afa'a lapa'kufa'ake veo. ");
INSERT INTO ino_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lapa'kaeya ka ukefe ku o'alitapa veo. Lapa'kufale aole siota o'alitapa mako'ke'ake vailitapa veo. Lapaiyale anona o'aleo. Ka malekefena ayomepa kayo o'aleo. Lapa'kaeya nakaeya ali'ya alikayanake'a vaya'moki ne'yatapile yakai lapatekae. ");
INSERT INTO ino_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Lapa'kaeya mako ala kumate'ae aise kumate'ae ne'utapa akesakeno mako ve'kamo'a kanale kava huno ne'maisea ve'ka aketapa aeto hisakeno kanale'ya huno yakai lapatesiketapaena alu vaya'ae havalitata ohutapa ani ve'ka'ae'ke nehavatapa ataletapa alu kumate veo. ");
INSERT INTO ino_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lapa'kaeya mako nopi faletapa haikefe kipate kava nefaitapa ma ke hutapa heo “Lapa'kaeya ma nopi vayana Anumaya Koti'a falu lahapaisea ya lapamise.” hutapa falu fala hupateo. ");
INSERT INTO ino_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hutapa falu fala hune'apatesake'a ani nopi vaya'moki kanale kava hulapatesayana apaipa apa'kesamo'a falu hapaisea ya alikaya'maki apa'kaeya hu'a falu fala hu olapatesayana apaipamo'a falu hapaisea yana eteno esiketapa lapa'kaeya alikae. ");
INSERT INTO ino_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inaki mako vaya'moki “Ketapi o'afikune.” hute'a lapavale'a no'apifi ohaisaketapaena ani ala kumatetipi nopatipi ne'ataletapaena lapaiyale kama'nisea mumusopa alitapa fopo hune'ataletapa veo. Fopo hutalesaya yafe ina akufa apa'kesa afikae “Anumayamo ke la'kame'ya ami'nona yafe Anumayamo'a lakaeya'ae ani kava huno a'kame'ya lamike.” hu'a ne'afisaketapa fate kumate veo. ");
INSERT INTO ino_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma ke lamake lahapapauvanaki afeo. Anumaya Koti'a mi'ko ve a'ne apavaleno kake hupatesea afina Sotomu kumate vaya'ae Komola kumate vaya'moki'ae ali'naya apa'kafu yana aise'a ali'naya'maki lapa'kaeya lapavale'a no'apifaka o'visaya kumate vaya'moki Sotomu kumate vaya'ae Komola kumate vaya'moki ali'naya yana apa'kasekae huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Afeo. Lapa'kaeya sipi sipi ana'au'akana hu'na hulapatoketapa afela kala anaka mai'naya folakapi vayanaki veo. Ne'visake'aena ali'a haviya hulapate'yafenaki lapa'kaeya lapame maleta aketetapa veo. Lapa'kaeya ali'a haviya hulapatesaketapaena namamoki nehaya kava hutapa havi kava hisaya lapa'kesa o'afeo. ");
INSERT INTO ino_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lapa'kaeya hu'a haviya hulapatesaya vaya'aife maitapa halove hupateo. Ani vaya'moki lapavale'a kanisole vaya'apile kake hunelapate'a mono no'apifi sefu lapamikae. ");
INSERT INTO ino_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nakaeya ke hu'naya yafe ani vaya'moki lapa'kaeya lapatafa hu'a kamani vaya'apile'ae ala yahauve ve'ka'apile'ae lapavale'a haikaya'maki ani vaya'ai apaulakale nakaeyafe kanale ke hapapaisake'a Isaleli nofi o'mai vaya'moki'ae afikae. ");
INSERT INTO ino_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lapa'kaeya kake hulapate ya hu'a lapavale'a u'a lapatesaketapaena koli ohutapa lapa'kesa lapa o'aiyo. “Ke'apile anona'a na'yane ke hukune?” hutapa lapa'kesa o'afeo. Ani kanatofi Anumaya Koti'a “Inake hutapa heo.” huno ke lapavayale malesiketapa ke'apile anona'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ani ke lapa'kaeyatapi ohukaya'maki Afotapimo'a Anumaya Koti Fate Akufa Avamu'amo'a ani ke lapavayafati huke. ");
INSERT INTO ino_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ani afina neputapimoki Yisasi ke a'kame male'naya yafe apakana'apimoki apavale'a kake hupatesaya yafe kame vaya'ai apayapi apatesake'a kake hune'apate'a mako'a apamaki'a kipatekae. Afo'apimoki mafa'neyaka'ape inake hu'a huke “Hapaeke'a faleo.” Mafa'neyaka'apimoki ita afo'apimokife ai'a yahae hu'a kame ya hune'apate'a kake hupate ve'kale apavale'a kake hupatesake'a hanaesake'ana falika'ae. ");
INSERT INTO ino_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lapa'kaeya nakaeya naki'ae ke'ni'ae afitapa a'kame ne'malaya yafe mi'ko vaya'moki apaipa kafa lahapakaya'maki mako vaya'moki nakaeya ke meni afina aepa he'a atafa hu'a lo'kiya vaime vaime u'a lo'kiya vaili'naya yafe Yisasi'na ete'na esoa afina nakaeya ke atafa huli'nisaya vaya'aina Anumaya Koti'a apaipa apame alino katike. ");
INSERT INTO ino_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mako kumateti vaya'moki lahapafai'a lahapaesaketapaena lapaune hetapa alu kumate utapa maiyo. Nakaeya lamake lahapa'nepauve mi'ko Isaleli kuma'yakale uteta hutapa hano ohu'nisake'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne ete'na ekauve. ");
INSERT INTO ino_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Avo nopi mafa'nemo'a alino aya nehea nena ao'kase'ne. Ani kava huno mako ali'ya ve'kamo'a kava kano'a ao'kase'ne. ");
INSERT INTO ino_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Avo nopi mafa'nemo'a alino aya nehea ve'ka'ae mako'ke aiyayi hu'ana maisa'ana kanalene. Ani kava huno ali'ya ve'ka'ae kava kano'ae mako'ke aiyayi hu'ana maisa'ana kanalene. Nakaeyafe “Pielisepuli Sata afe'mo kava ve'ka'a mai'ne.” hu'a hu'nae. Nakaeya kava ve'kae hu'a haviya hu'naya yafe lapa'kesa afiketao lapa'kaeya'ae nakaeya anaka mai'nayanake'a ani kava hu'a hu'a haviya hulapate'a lapa'ki ali'a haviya hukae. ");
INSERT INTO ino_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ali'a haviya hulapatekaya'maki lapa'kaeya apa'kaeyafe koli oheo. Mi'ko fala'ki malesakeno hane'nisea yana Anumaya Koti'a vaya apaulakale alino fole aike. Mi'ko kesi ke hu'a fala kimale'nisaya ke Anumaya Koti'a alino fole aisike'a mi'ko vaya'moki afikae. ");
INSERT INTO ino_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nakaeya hani'ainaka lahapa'nepauva ke etetapa feluka mi'ko vaya hapapaiyo. Inaki lapa'kesafi sumi hu'na lahapa'nepauva ke lapa'kaeya no'kato'mule haitapa heti'netapa ala kefati ka atapa hapapaiyo. ");
INSERT INTO ino_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lapa'kaeya ameka lapa'kufa lahapaesaketapa falisaya vaya'aife koli oheo. Lapa'ku'ainaka mafa'ne ha'a ofalisaya yafe ani vaya'aife koli ohukaki lapa'ku mafa'ne'ae ameka lapa'kufa'ae ata leke leke nehea atafi hano kitesea ve'kae'ke lusiya hutapa koli'a heo. ");
INSERT INTO ino_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mako'ke moni alakaletina aole aise namatolana miya nehaya'maki Afotapimo'a ohaininana mako'ke nama eno ma mopafi ofalinina'maki Afotapimo'a “Falise.” hikeno fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Lapa'kaeya lapa'kenopale hane'nea lapayo'ka Anumaya Koti'a ako le'kanapaino ake'ne. Ani yafe lapa'kaeya koli oheo. Aise aise nama miya nehaya miya lapa'kaeya akasetapa vaya ako ala ya mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yisasi'a inake he mako vaya'moki nakaeyafe “Yisasi'a naipafi mai'nike'na nakaeya naipa ako ami'noe.” hute'a ve a'ne'ai apaulakale naki a'a fole ai'a hapapaisayana nakaeya'ae ko'ku'napi mai'nea Afo'nimo aulakale nakaeya'ae ani kava hu'na apa'kaeyafe “Nakaeya mafa'ne anaka mai'nae.” hu'na fole aipatekauve. ");
INSERT INTO ino_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hu'na fole aikoa'maki mako vaya'moki nakaeyafe “Yisasina naipa o'ami'noe.” hu'a ve a'nemoki apaulakale hisayana nakaeya'ae ko'ku'napi mai'nea Afo'nimo aulakale ani kava hu'na apa'kaeyafe “O'apa'ke'noa vaya mai'nae.” hu'na hukoe. ");
INSERT INTO ino_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yisasi'a inake he “Lapa'kaeya inake hae ‘Yisasi'a ma mopale e'neana ma mopafi vaya'mokita kame ya nehuna ya huno lakaulatekefe e'ne.’ hutapa nehafe? He'e. Nakaeya e'noana mi'ko ma mopafi kame ya hu'a la nehaya ya ali'na o'atalekauva'maki nakaeya e'noana ave ne'nea hakina ali'na e'noanaketapa la hukayanaketapa yuna hetapa o'maikae. ");
INSERT INTO ino_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nakaeya mopafi e'noa yafe kame hu ya va'yi huke. Mako afamopati ve mafa'nemo'a afo'amona kame ya hutesikeno atane ya fole aike. Ani kava huno a'mafa'ne'amo'a ita'amona kame ya hutekaiye. Mafa'ne'amo a'mo'a anofelo'amona kame ya hutekaiye. ");
INSERT INTO ino_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hune'atesike'a mako vaya'moki nakaeyafe afi'a aipafi male'naya yafe ani afamo'ai folakapi kame ya hanekaiye.” ");
INSERT INTO ino_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yisasi'a inake huno hapa'nepaiye mako vaya'moki ita afo'apimokife nehapaisike'ae'maki Nakaeyafe lusiya huno ohapaiseana ani vaya Nakaeya'ae maimo ve'ka o'mai'neanakeno vaya'ni o'maike. Ne'mafa'ne a'mafa'ne'aena nehaisikeno'ae'maki Nakaeyafe lusiya huno ohaiseana Nakaeya'ae maimo ve'ka o'mai'neanakeno vaya'ni o'maike. ");
INSERT INTO ino_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nakaeya nakafu ya alite'na falisoa yafe akesa afiteno “Ani kava hisoe.” nehuno akai'a yofo yosa kofino na'kame malemo ve'ka o'mai'neanakeno vaya'ni o'maike. ");
INSERT INTO ino_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nakaeyafe akesa o'afino akai'a maisea yafe'ke akesa afifi huno alino alaki hisea ve'kamo'a maike maike hu avamu alino mai ya'a atalekaiya'maki nakaeyafe lusi akesa afiteno “Kanale mai ya'ni'ae navamu'ae atalekauve.” huno hisea ve'kamo'a henaka'a avamu alino katitesikeno maike maike hu avamu alino maike. ");
INSERT INTO ino_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mako vaya'moki lapa'kaeya lapavale'a kanale kava hulapatesayana nakaeya'ke navale'a kanale kava hunatekae. Inaki nakaeya navale'a kanale kava hunatesayana ani kava hu'a nakaeya hunateke'na e'noa Anumaya Koti'ke avale'a kanale kava hutekae. ");
INSERT INTO ino_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mako vaya'moki Anumaya Koti ke huno fole ne'aiya ve'ka “Aya hisune.” hute'a no'apifi avale'u'a kanale'ya hu'a yakaitesayana ani vaya'moki ani Anumaya Koti ke huno fole ne'aiya ve'kamo alisea miya mako'ke avamete alikae. Ani kava hu'a “Alakepa ve'ka aya hisune.” hute'a avale'u'a no'apifi ate'ne'a kanale'ya hu'a yakaitesayana ani vaya'moki ani alakepa ve'kamo miya mako'ke avamete alikae. ");
INSERT INTO ino_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mako ve'kamo'a mako afa ve'kae “Yisasi ke ne'afea ve'kake'na aya hisoe.” huteno litafa hefino amiseana ani ve'kamo miya'a afa'a hanekaiyanakeno henaka'a alike. ");
INSERT INTO ino_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisasi'a ayatala'a hano huteno aiyalekati aole alea anaka'a akaeya ke ne'afea anaka alino apaya huteno fate fate kumate uno mi'ko vaya Anumaya Koti ke hapa'nepaino alino apaya hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Yoni'a li fale ne'apatea ve'ka nofi nopi mai'neno Kalaisi'a hu'nea avake afiteno mako akaeya ke ne'afea anaka'a hupateke'a e'a inake hu'a nehae “Kakaeya Anumaya Kotitekati e'nana ve'ka mai'napi alu ve'ka eseafe akeva maisune?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nehakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya utapa ne'afea ya'ae ne'akaya ya'ae Yonina hapaiyo. ");
INSERT INTO ino_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma ya ake'none hutapa heo. Apaulaka apo ka'nea vaya'moki ete'a ake'nae. Apaiya haviya hu'nea vaya'moki heti'a u'e'a nehae. Fuko'ya apa'ke'nea vaya'moki ete'a kanale hu'nae. Apa'kesa a'kani'nea vaya ete'a ke ne'afe. Fali'naya vaya ete'a heti'a mai'nae. Afeno ya'api o'male'nea vaya'moki Anumaya Koti kanale ke'a ne'afe. ");
INSERT INTO ino_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nakaeya hu'noa kavafe aole akesa o'afino ya o'kalesea ve'kamo'a amuse huno maike.” ");
INSERT INTO ino_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nehike'a ne'vakeno Yisasi'a anile mai'naya vaya'aife inake huno Yonife apafine'ke lapa'kaeya vaya o'mai ka'me koteka u'nayana na ya akekefe u'nae? Mako ve'ka hopakana huno yasimo'a alino fakake nepaiya ve'ka akekefe u'nafe? ");
INSERT INTO ino_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na ya akekefe u'nae? Kanale'nale kena havaili'nea ve'ka akekefe u'nafe? He'e kanale kena havaili'nisaya vaya ka'me koteka o'maikaya'maki ala yahauve ve'kamo nopi'ke ne'maiye. ");
INSERT INTO ino_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na ya akekefe u'nae? Anumaya Koti aune ve'ka akekefe u'nafe? Lamake lahapa'nepauve mi'ko apaune vaya'aipati Yoni'ae ve'kamo'a apa'kaseno mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ani ve'kaena a'ke'ainaka Anumaya Koti avopi inake huno kamale'neane “Afeo ke alino uno hapapaisea ve'ka'ni'a hokote'na hutesukeno visana ka valino kanale huke.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nakaeya lamake hu'na lahapa'nepauve Yoni'a li fale ne'apatea ve'ka mi'ko ma mopale mai'naya vaya'aina ako apa'kase'nea'maki mako aise ve'kamo'a Anumaya Kotife “Kava hunato.” huno hu'nea ve'kamo'a Yonina ako akase'ne. ");
INSERT INTO ino_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoni'a li fale ne'apatea ve'kamo'a ke hapapai'nea kanafi'ae meni maime ne'ona kanafi lo'kiya apa'ku apa'kesa hane'nea vaya'moki aepa he'a Anumaya Koti kava hupatesea kavafe lo'kiya vai'a “Ani yapi maikune.” hu'a lusi kava nehu'a meni ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mosese'ae Anumaya Koti aune vaya'ae Anumaya Koti yakai lapatesea yafe lo'kiya vai'a lahapapaime ne'akeno anileti Yoni'a fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Ilaiya'a esiketa akekaune.” hutapa hu'naya ve'ka ako Yoni'a ani ve'kakeno fole aino mai'nea'maki afisune hutapaena afikae. ");
INSERT INTO ino_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kakesa hanesea'moka mani ke afeo. ");
INSERT INTO ino_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Meni kanafi mai'naya vaya'yaka hana akufa vaya mai'nae hu'na lahapapaisoe? Ma ke hisoa akufa mafa'neyu'kana hutapa mai'nae. Apa'kaeya ma'keti kuma folakapi mafa'nekana hu'a mai'nake'a mako fate mafa'ne'aife inake hu'a nehae “Lakaeya yave'ya ne'auna'maki lapaiya no'ae. Lakaeya avi yakame nehuta lahau nehuna'maki lapa'kaeya avi nolae.” ");
INSERT INTO ino_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yoni'a li falepate ve'ka e'neana ne'ya'ae li'ae mosino maike'a “Sata afe'mo'a aipafi mai'ne.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hu'naya'maki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na e'na li ne'ne'na ne'ya ne'ne'na nehoanake'a nakaeyafe “Ne'ya'ae li'ae neke neke ve'ka mai'neno kumaya'ya nehu'a vaya apa'kufaleti ta'kesi miya ne'alea vaya'ae hao'otake kava nehaya vaya'ae vaya'a mai'nae.” hu'a nehaya'maki Anumaya Koti ali'ya'mo'a akesafi hale'nea yana fole aiketapa ne'aketapa “Alakepa kava nehe.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mako kuma'ale Yisasi'a lusi kava huno o'ake'naya avame hu lo'kiya ya alo huno apaveli'nea'maki alaki lamake hu'a apaipa ai'a yahae ohu'a hao'otake ya'api o'atalakeno Yisasi'a lusiya huno ke hapau'ne. ");
INSERT INTO ino_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Avo'neo Kolasini'ae Petasaita'ae mai'naya vaya'mokitapae lusiya hu'na nahau nehoe. Nakaeya lapa'kaeya kumate mai'ne'na o'ake'naya avame hu lo'kiya ya ako hu'noa'maki lapaipa aitapa yahae ohu'naya'maki Taiya'ae Saitoni kumatalate ani o'ake'naya avame lo'kiya ya mako ve'kamo'a alo hinake'a ake'nininana hao'otake kava nehaya yafe hapau nehu'a la'nefafi kasepu ne'ai'a lusi yate apaipa ai'a yahae hu'a hao'otake ya'api atalenine. ");
INSERT INTO ino_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anumaya Koti'a mi'ko ve a'ne apavaleno kake hupatesea afina Taiya vaya'ae Saitoni vaya'ae aise kana ya alikaya'maki Kolasini'ae Petasaita'ae mai'naya vaya'mokitapa ala kana ya apa'kasetapa alikae. ");
INSERT INTO ino_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lapa'kaeya Kapaneamu kumate vaya'mokitapa lapa'kufa alitapa “Ko'ku'napi haikune.” hutapa nehafe? He'e ina kava ohukafa ata leke leke nehea kumapi afepakake lavikae. Nakaeya lapa'kaeya kumate mai'ne'na o'ake'naya avame hu lo'kiya ya ako hu'noa'maki lapaipa aitapa yahae ohu'nayanaki Sotomu kumate ani o'ake'naya avame lo'kiya ya mako ve'kamo'a alo hu'nininana hao'otake kava nehaya yafe hapau nehakeno kuma'api ataleno fanane ohuno meni afina afa'a hane'ninine. ");
INSERT INTO ino_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Meni Nakaeya lahapa'nepauve Anumaya Koti'a mi'ko ve a'ne apavaleno kake hupatesea afina Sotomu mai'naya vaya aise apa'kafu ya alikaya'maki Kolasini'ae Petasaita'ae mai'naya vaya'mokitapa apa'kasetapa ala lapa'kafu ya alikae. ");
INSERT INTO ino_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ani afina Yisasi'a inake nehe Afo'nimoka mi'ko mopale ya'ae ko'ku'napi ya'ae kava yakai'nana Anumayamoka kanale kava nehane. Ma hapapai'noa ke “Nakaeya nakenopafi hale'nea ve'kamo'na mi'ko ya afi'noa ve'ka mai'noe.” hu'a hisaya vaya'moki “O'afisae.” hu'ka fala'kimale'nana'maki “Inamu mafa'ne mai'noe.” hu'a hu'naya vaya ako hu'ka fole ai'ka apaveli'nana yafe lusiya hu'na amuse'ka nehoe. ");
INSERT INTO ino_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","He Afo'nimoka kaipa kakesamo'a ina kava hu'nike'ka ani kava hu'nane. ");
INSERT INTO ino_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Anile ali'a atalu hu'naya vaya'aife inake he Afo'nimo'a mi'ko lo'kiya ya ako nami'ne. Nakaeya mafa'ne'amo'na aepa mi'ko vaya'moki o'afi'naya'maki Afo'nimo'a akai'ake Nakaeya aepa'a'ni afi'ne. Afi'nea'maki mi'ko vaya'moki Afo'nimo ne'maiya aepa'a o'afi'naya'maki Nakai'ni mafa'ne'amo'nake afi'noanake'na Nakaeya nahaisea vaya'ai hu'na apavelisuke'a Afo'nimo aepa'a afikae. ");
INSERT INTO ino_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Lapa'kaeya mi'ko vaya'mokitapa lusi kana'ake ali'ya ne'alikeno lapaipamo'a kana'ake hu'nea yafe nakaeyateka eke'na maitapa falu hisaya ya lapamino. ");
INSERT INTO ino_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nakaeya ali'ya eta lo'kata aliketa vino. Nakaeya'ae lo'katapa maisayana Nakaeya ne'aloa aepa'ni akekae. Nakaeya vaya ali'na kanale hupatesoa ve'ka mai'noe. Nakufa ali'na hai ve'ka o'mai'noanake'na maitapa falu hisaya ya lapamikoe. ");
INSERT INTO ino_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Lapa'kaeya nakaeya'ae lo'katapa visayana yo'yo hutapa ukae. Ani lapamoa ali'ya alisayana kana olahapauke. ");
INSERT INTO ino_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mako Sapati afina Yisasi'ae akaeya ke ne'afea anaka'ae mako kile hoyafi ne'u'a akaeya ke ne'afea anaka'moki apa'kateke'a ani kile hoyafati kile atakate'a kale'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ne'nake'a mako Falasi mono ke ne'afea vaya'moki apa'kete'a Yisasife inake nehae “Ake'nape Sapati kanafi he'e humale'nea kava kakaeya ke ne'afea vaya'moki ani ke ali'a ne'atakae.” ");
INSERT INTO ino_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nehakeno Yisasi'a apa'kaeyafe inake huno ke anona'apile apafine'ke lapa'kaeya a'ke'ainaka Teviti'ae a'kame u'naya vaya'ae apa'katekeno Teviti'a hu'nea kavafe kamale'naya ke hapalitapa o'ake'nafe? ");
INSERT INTO ino_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Apa'ka nelekeno Teviti'a Anumaya Koti nopi hai'neno ke male male'nea kemo'a “Afa vaya'moki o'nesafa mono nopi kava vaya'mokike nekae.” hu'a Anumaya Koti aulakale male'naya kai hame'ya Teviti'a ne'neno akaeya a'kame u'naya vaya'ae apamike'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lapa'kaeya Mosese kamale'nea avopi hane'nea ke hapalitapa o'afi'nafe? Ani ke inake huno kamale'neane mono nopi ali'ya vaya'moki mi'ko Sapati kanafi Sapati afina “Ina kava oheo.” hu'nea ke ali'a ne'ataka'a ali'ya'api ali'nae. Ali'a ne'atakaya'maki Anumaya Koti'a “Hao'otake kava nehaya vaya mai'nae.” ohu'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yisasi'a inake he “Lahapa'nepauve Anumaya Koti'a ala mono no akase'noa ve'ka nakaeya mai'noe. ");
INSERT INTO ino_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A'ke'ainaka Anumaya Koti avopi inake hu'a kamale'nayane ‘Nakaeya Anumaya Koti'na afu he'a kola'a la'ki'a ne'namea kavafe no'nahaiya'maki vaya kalaki aipate kavafe ne'nahaiye.’ huno hu'ne hu'a kamale'nayane. Kamale'naya'maki lapa'kaeya ani ke afitapa alakepa hu'nininana hao'otake kava ohu'naya vayafe ‘Hao'otake kava nehae.’ hutapa ohanine. ");
INSERT INTO ino_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na Sapati kana kava yakai'noe.” ");
INSERT INTO ino_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ani aupalika ne'ataleno eno mono nopi haino mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Akekeo mako ve'ka aya fali'nea ve'ka anile mai'nike'a mako vaya'moki Yisasi'a hao'otake kava nehe hu'a hisaya kafe kahau a'a akekefe Yisasife inake hae “Sapati kanafi kali ve'ka alino kanale hutesea yana kanale yape?” hu'a Yisasina afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Afine'kakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeyapati mako ve'kamo afu Sapati afina kelifi asakau lavisiketapaena ako avayu hutapa mopale atekafe? He ani kava hukae. ");
INSERT INTO ino_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vaya'moki afu akase'a ala ya mai'nae. Ala ya mai'naya yafe ke male male'nea ke a'kame ne'maleta Sapati afina vaya alita kanale hupatekaune.” ");
INSERT INTO ino_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Inake huteno ani aya fali'nea ve'kae inake huno hapai'ne “Kaya ali'ka api aiyo.” hikeno aya alino api ne'aikeno ako kanale hutekeno mako afa'a hane'nea aya'ae mako'ke kava hikeno kanale hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kanale hute'nea'maki Falasi mono ke ne'afea vaya'moki mono nopati hatilavi'a ali'a anupa hu'ne'a “Yisasina hana'ya huta haesunakeno falise.” hu'a veke nehae. ");
INSERT INTO ino_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yisasina hakefe veke haya ke akai'a afiteno ani kumana ne'ataleno u'ne. Ne'vike'a mi'ko vaya'moki a'kame ne'vakeno Yisasi'a mi'ko ani vaya'ai kali'api alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kanale hupateteno inake he “Nakaeya hulapate'noa kavafe mako ve'ka ha'opaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yisasi'a alino kanale hupate'nea kali vaya'aife “Nakaeya hulapate'noa kavafe hapa'opaiyo.” huno nehea kavafe a'ke'ainaka Aisaiya'a Anumaya Koti aune ve'kamo hu'nea ke fole aino ne'ya'a alitekeno lamake hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Inake hu'neane “Anumaya Koti'a inake huno nehe ‘Akekeo mani ve'ka nakaeya ali'ya ve'ka maisea yafe ako hapalimale'noe. Ani ve'kae amuse hu'na lusiya huno nahau'nea ve'kae. Nakaeya Fate Akufa Avamu'ni'a amitesukeno nakaeya alakepa kava hu'na yakailapatesoa yafe mi'ko Isaleli nofi o'mai vaya hapapaike. ");
INSERT INTO ino_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Akaeya hai o'vaino ala ke ohuno ka ka huno ke ohukeanake'a vaya'moki katekati o'afikae. ");
INSERT INTO ino_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mako falupa le'nea hopa alino alo o'akaiye. Ani kava huno fulu fulu nehaya vaya kayo o'apamike. Asu hesea ata kanina ako asu ohekaiya'maki fu huno kakaiyanakeno ani kava huno fulu fulu vayana kayo o'apamike. Akaeya alakepa kava'ake huke huke hiseana ani alakepa kava'mo'a hao'otake kavana akaseno haike. ");
INSERT INTO ino_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Haiseana mi'ko Isaleli nofi o'mai vaya'moki apaipa amite'a akai'a akile apame'atiti hukae.’ huno hu'neane.” ");
INSERT INTO ino_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mako ve'kamo aipafi Sata afe mai'nikeno liko'ke'a a'kanile'nikeno ake no'aino aulaka'ae fali'ka'nea ve'ka Yisasite avale'a ne'ae. Ne'akeno Yisasi'a ani Sata afe aipafati alino ne'atalekeno liko'a hakalo hikeno avenafu'namo'a no'ale vikeno kanale huno ake ne'aikeno aulakamo'a halai hikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Alino kanale hune'ateke'a ake'a mai'naya vaya'moki lusi apamo'yo ne'ai'a inake hu'a nehae “Mani ve'ka Teviti akeho'amo'a mai'nife? Akaeya Anumaya Koti'a lakufa alino katikefe hute'nea ve'ka mai'nife?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nehake'a Falasi mono ke ne'afea vaya'moki afite'a inake nehae “Sata afe'yaka'ai kava ve'ka'api Pielisipuli'a Yisasi aipafi mai'neno lo'kiya amikeno ani Sata afe alino ne'atale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nehakeno Yisasi'a apaipafi nehaya ke afiteno apa'kaeyafe inake he mako ala kote vaya'moki ali'a fa'ko hute'a la hisayana ani ko'apimo'a uno haviya huke. Mako kumateno mako anaka'aeno folaka'apifati ali'a fa'ko fa'ka hute'a la hisayana ani kuma'ae ani anaka'ae fali'a hano hukae. ");
INSERT INTO ino_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sata'a akai'a Sata afe vaya'ai apaipafati alino ataleseana akai'a nofi vaya alino fa'ko hisike'a “Fate fate nofi vaya mai'none.” hu'a hisayana Sata'a kava yakai'nea ya'a afa ya'kana hisikeno uno haviya huno hano huke. ");
INSERT INTO ino_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hano hukea'maki nakaeyafe “Sata afe'yaka'ai kava ve'ka'api Pielisipuli'a lo'kiya amikeno mani Sata afe alino ne'atale.” hutapa nehaya'maki nakaeya Pielisepuli lo'kiyaleti ali'na ne'ataleninana nala'a hapa'mano lapa'kaeya mafa'neyakamoki “Sata afe'yaka ali'a ne'atalae.” hutapa haya afina Sata'a apa'kaeya apaya nehife? Ani mafa'netapimoki havi lapa'kesa ne'afea ya hu'a lapavelikae. ");
INSERT INTO ino_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nakaeya Anumaya Koti Fate Akufa Avamu'amo lo'kiyaleti ani Sata afe ali'na atalesoana Anumaya Koti'a kava yakai lapatesea kana'a lapa'kaeyate ako e'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mako lo'kiya ve'kamo'a no'alena kava yakaino alakepa hiseana mako ve'kamo'a “Kumaya'ya hukefe visoe.” huno'aena hokoteno ani note yakai'nisea ve'ka atafa huno nofiteti aiya ayate kite'neno henaka'a afeno ya'a alike. Nakaeya ani ya hu'na Satana aiya ayate nofi kite'ne'na akaeya afe anakana hapafaitale'noe. ");
INSERT INTO ino_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mako ve'ka nakaeya vaya'ni o'mai'niseana kame ve'ka'ni mai'ne. Mako ve'kamo'a nakaeya'ae sipi sipi afu anaka alino atalu ohiseana hapafaitalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nakaeya lahapa'nepauve mi'ko ve a'nemoki hao'otake kava nehu'a fate fate hao'otake kava'ae mi'ko hu'a haviya hutesaya hao'otake ya'ape Anumaya Koti'a lahapaove lapatove nehuno aipa falu yapati alino atalelatekaiya'maki Anumaya Koti Fate Akufa Avamu'amofe hu'a haviya hutesaya ya'api Anumaya Koti'a alaki lamake huno lahapaove lapatove nehuno aipa falu yapati alino o'atalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mako ve'kamo'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kae hu'a haviya hunatesaya hao'otake ya'api Anumaya Koti'a lahapaove lapatove nehuno aipa falu yapati alino atalelatekaiya'maki Anumaya Koti Fate Akufa Avamu'amofe hu'a haviya hutesaya ya'api Anumaya Koti'a alaki lamake huno lahapaove lapatove nehuno aipa falu yapati alino o'atalekaiye. Meni'ae henaka va'yi hisea kana'ae akola alino o'atalesikeno alaki haneke haneke huno hanekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yisasi'a mako'ae inake he kanale yosamo'a kanale alaka'a akaiya'maki havi yosamo'a havi alaka'a akaiye. Kanale yosafi havi yosafi hutapa akesune hutapaena alaka'ale aketapa aeto heo. ");
INSERT INTO ino_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lapa'kaeya Falasi vayana osifa'vemo mafa'ne mai'netapa lapa'kaeya havi vayanaketapa hana kava hutapa kanale ke hukae? Vaya'moki apaipafi ke havaite'nea yapati ke nehaki lapaipafati lapa'ke'atike ke alitapa fole ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kanale aipa akesa'ae ve'kamo'a kanale aipa akesa hane'nea yapati kanale ke nehea'maki havi aipa akesa'ae ve'kamo'a havi aipa akesa hane'nea yapati havi ke fole ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nakaeya lahapa'nepauve Anumaya Koti'a henaka'a vaya kake hupateno alino fa'ko hisea afina mi'ko vaya'moki havikopa apa'kesa afike kanale ke huke hao'otake ke'ae nehaya au'ava'api Anumaya Koti'a ani ke ke huno apafikekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mako nehana keleti Anumaya Koti'a “Alakepa ve'ka mai'nane.” huno hukatekaiya'maki mako nehana keleti ani kava huno “Havi ve'ka mai'nane.” huno hukatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mono hapali'a hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'moki'ae Yisasife inake nehae “Ali'ka apaya nehana Nenao no'akona avame hu lo'kiya nehana ya'ka alo hu'ka laveliketa akeno.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nehakeno Yisasi'a inake huno hapapai'ne meni mai'naya vaya hao'otake ve a'ne mai'netapa “O'ake'nona avame hu lo'kiya'ka laveliketa akeno.” hutapa ke nehaya'maki Anumaya Koti'a alu mako'ae o'ake'naya lo'kiya avame hu yana lapave olikea'maki mako'ke avame hu lo'kiya ya'ake Anumaya Koti aune ve'ka Yona'a a'ke'ainaka mai'neno hu'nea avame hu lo'kiya ya'ake lapavelisiketapa akekae. ");
INSERT INTO ino_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona'a aole'ae mako'ae hani'ae yake'ae ala faya'mo aipafi mai'nea kava hu'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nakaeya'ae kelifi ki natesake'na aole'ae mako'ae hani'ae yake'ae mopafaka maikoe. ");
INSERT INTO ino_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninive kumate mai'naya vaya'moki Yona'a hu'nea ke afite'a apaipa ai'a yahae nehu'a hao'otake ya'api atale'naya'maki Yonana akase'nea ve'ka meni male mai'nea'maki lapa'kaeya hao'otake yatape lapa'kesa afitapa lapaipa aitapa yahae nohae. Ani yafe Anumaya Koti'a mi'ko vaya kake hupatesea afina Ninive kumate vaya'moki heti'a meni afina mai'naya vaya'aife “Hao'otake kava hu'nae.” hu'a ali'a fole ailapatekae. ");
INSERT INTO ino_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mako kaya (sauti) aupalika mai'nea yahauve a mopamo haneme uno atale'nea mopalekati eno Solomoni'a akenopafi hale'nea ve'kamo ke afi'nea'maki akekeo Solomonina akase'nea ve'ka ma mai'nea'maki lapa'kaeya akaeya ke no'afe. Henaka'a Anumaya Koti'a mi'ko vaya kake hupatesea afina ani kava a'mo'a hetino meni afina mai'naya vaya'aife “Hao'otake kava hu'nae.” huno alino fole ailapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sata afe mako ve'kamo aipafi haino mai'neapati ataleno uno maino falu hisea kumafe li o'male yapaka uneno nehuno lusi kahau ano uneno huketeana maisea ya'a alaki o'ake'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","O'akeno inake he “Halate ete'na hokote'na maike'noa nopi visoe.” huteno eteno uno akeana ani ve'kamo aipafi ako no'ya alino vaki huno kanale kava humale'nikeno mako vaya o'mai'nakeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aketeno vea'ya'mo'a naya mako kaya hano huteno naya mako kayati aole alea afe anaka apaveleteno e'neana akaeya hao'otake kava nehea kava akase'a mako'ae lusi hao'otake kava nehaya afe anaka apavaleno eke'a ani ve'kamo aipafi hai'a mai'nakeno ani ve'ka hokoteno aise ya'a alino haviya hute'nea'maki meni mako'ae lusi kava hu'a ali'a haviya hute'nae. Meni mai'netapa hao'otake kava nehaya vaya'mokitapa ani havi kava hulapatekaiye. Hokotetapa aise'a hao'otake kava hu'naya'maki meni mako'ae lusi hao'otake kava hukae. ");
INSERT INTO ino_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisasi'a ani ke vaya hapapaino mai'nike'a ita'amo'ae akana'amoki'ae “Ke hapaisune.” hu'a e'a ma'aileka mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mai'nakeno mako ve'kamo'a eno akaeyafe inake nehe “Ita'kamo'ae kakana'kamoki'ae e'a ma'aileka mai'ne'a kakaeyafe ke nehae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nehikeno Yisasi'a ani ke hapai'nea ve'kae ke anona'ale inake he “Nalaki ita'nimo'ae nakana'nimoki'ae mai'nae?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Akaeya ke ne'afea anaka'aite aya ha'ko'ya nehuno inake he “Nakaeya ita'nimoki nakana'nimoki male mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ko'ku'napi mai'nea Afo'nimo ke afi'a a'kame ne'male'a ha'ye hea kava nehaya vaya nakana'nimoki nasa'nimoki ita'nimoki mai'nae.” ");
INSERT INTO ino_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ani afina Yisasi'a nopati hatilavino li kotu aki'nale uno faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Faitopale mai'nike'a nesu ve a'ne akaeyate ali'a veko nehaya yafe Yisasi'a lipi kalefi haino faitopale mai'nike'a ali'a atalu haya vaya li kotu'mo aki'nale heti'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Heti'a mai'nakeno Yisasi'a fate fate ke avoya kefati alino apaya nehuno mako ke inake he mako ve'kamo'a uno avina ya hoyafi ha'kale'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ha'kaleme ne'vikeno mako avina ya'a kateka asaka hunelavike'a namayakamoki e'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mako avina ya'a yafa akofetule asaka hulavi'nea'maki mopamo'a alapa o'ai'nea yafe makale'a hake'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hake'nea'maki hafu'ya'a olavi'nea yafe yake haino ne'ekeno amu'ko'amo'a haya'a leno asakalikeno vai'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mako avina'a aufe kahau hane'nea yapi ha'kale'nikeno aufe kahau'ae makopi hakete'ana aufe kahaumo'a ano latota ne'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mako avina'a kanale mopafi asaka hulaviteno hakeno haiteno nesu yate ne'ya alite'ne. Ne'ya'a aliteateka mako'ke avinafati nesu yate naya mako kaya vaya'ai apaiya apaya hano hea avamete alaka'a (100 alaka'a) a'ne. Mako avina yapati aole'ae mako'ae vaya'ai apaiya apaya hano hea avamete alaka'a (60 alaka'a) a'nae. Mako avina yapati mako ve'kamo aiya aya hano huno mako ve'kamo ayatala'a hano hea avamete alaka'a (30 alaka'a) a'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kakesa hane'nisea ve'kamoka mani ke afeo. ");
INSERT INTO ino_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nehike'a akaeya ke ne'afea anaka'moki inake hu'a afine'kae “Na ya hike'ka ke avoya kefati hapapai'nane?” ");
INSERT INTO ino_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Afine'kakeno Yisasi'a apa'kaeyafe inake he Anumaya Koti'a kava alino yakai lapatesea yafe fala'kino hane'nea ke Anumaya Koti'a lapa'kaeya lahapa'mano lahapapaiketapa afi'naya'maki nakaeya ke no'afea vaya hapa o'makayanake'a apa'kesa afi'a alakepa ohukae. ");
INSERT INTO ino_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Afino alakepa huno afi'nea ve'ka Anumaya Koti'a mako'ae afisea akesa amisikeno lusiya huno afino alakepa hukea'maki “Hai afi'noe.” huno hisea ve'ka Anumaya Koti'a ani afi'nea ya'a alino hafalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ani vaya'moki akeme hai'naya'maki ake'a alakepa hu'a o'akesaya yafe nakaeya avoya ke hapa'nepauve. Afime nehaiya'maki afi'a alakepa ohisaya yafe nakaeya avoya ke hapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ani kava nehaya yafe Aisaiya'a Anumaya Koti aune ve'kamo hu'nea kemo'a ako fole aino ne'ya'a alitekeno lamake nehe. Inake hu'neane “Lapa'kaeya lapa'kesa afime haikaya'maki ani kemo aepa'a afitapa alakepa ohukae. Lapaulaka akeme haikaya'maki aketapa alakepa ohukae. ");
INSERT INTO ino_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kemo aepa'a afisaya yafe nohapaiya yafe apaipa apa'kesa o'male vaya mai'nae. Ani ke o'afisea yafe apa'kesa a'kanile'ne. Ani ya o'akesaya yafe apaulakamo'a ako fali'ka'ne. Haviku ake'a alakepa huke apa'kesa afi'a alakepa huke apaipa apa'kesa afi'a alakepa huke hute'a apaipa ai'a yahae hisake'na hao'otake ya'api ali'na atalesoa yafe o'nahaiye.” huno hike'a kamale'naya ke. Ani yafe avoya ke'ake hapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Anumaya Koti'a lapa'kaeya lusi kanale ya lapaulakamo ne'akea ya'ae lapa'kesamo ne'afea ya'ae lapami'nea yafe lusiya hutapa amuse hisaya ya lapami'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lamake hu'na lahapa'nepauve mi'ko a'ke'ainaka mai'naya apaune vaya'ae alakepa kava hu'a mai'naya vaya'ae lapa'kaeya meni ne'akaya ya “Akesune.” hu'a hu'naya'maki o'ake'nae. Meni ne'afea ke “Afisune.” hu'a hu'naya'maki o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lapa'kaeya afeo avina ya ha'kale'nea ve'kamo avoya ke ai'na yahae hukefe hoe. ");
INSERT INTO ino_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kate lavi'nea avina ya'mo kemo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti'a kava yakaipatesea ke afi'naya'maki afi'a alakepa ohu'nakeno Sata'a eno apaipafati ani ha'kalemale'nea ke alino atale'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Yafa mopafi lavi'nea avina ya'mo kemo'a ina kava hu'ne. Mako ve'kamo'a Anumaya Koti ke afiteno makale alino aipafi maleteno amuse nehea'maki alike ataleke ve'ka mai'nikeno hafu'ya'a mopafi olavi'nea yafe aise kanato afino aipafi male'nikeno havi kana va'yi nehikeno Anumaya Koti ke ne'afea yafe vaya'moki ali'a haviya hupate kana akaeyate va'yi neheana makale'a Anumaya Koti ke ne'atale. ");
INSERT INTO ino_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mako avina'amo'a aufe kahau hane'nea mopafi lavi'nea avinamo'a ina kava hu'ne. Mako ve'kamo'a Anumaya Koti ke ne'afino'ae'maki ma mopale aki'ae aka'ae kana ya'ae mi'ko moni afeno alisea yafe amuse nehuno akesa ne'afea ya'ae Anumaya Koti ke ano ati kaekeno alaka'a o'a'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","O'a'nea'maki kanale mopafi lavi'nea avina ya'mo'a ina kava hu'ne. Mako ve'kamo'a Anumaya Koti ke afino alakepa huno aipafi maleteno alaka'a aeyateka mako'ke avina yapati naya mako kaya hano hea vaya'ai apaiya apaya hano hea avamete lusi alaka'a (100 alaka'a) a'ne. Mako avina yapati aole'ae mako'ae vaya'ai apaiya apaya hano hea avamete alaka'a (60 alaka'a) a'ne. Mako avina yapati mako ve'kamo aiya aya hano huno mako ve'kamo ayatala'a hano hea avamete alaka'a (30 alaka'a) a'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisasi'a mako avoya ke inake huno hapapai'ne. Anumaya Koti'a kava alino yakai lapatesea kava'mo'a ina akufa avamete hane'ne. Mako ve'kamo'a kanale avina ya'a hoya'afi ha'kalemale'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ha'kalemaleke'a mi'ko vaya apau kale'nakeno kame ve'ka'amo'a eno kahau avina ani hoyafi alino ha'kalemaleno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","U'nikeno henaka'a ani kanale avina'ae kahau avina'ae makopi hake'ana hai'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hai'na'ake'a ali'ya vaya'moki akete'a hoyamo afo'amote u'a inake hae “Ala Nenao lakaeya lakesa afunana kanale avina ya hoya'kafi ha'kale'napi hutae huna'maki na ya hikeno kahau'ae anifati nehake?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Afikakeno hoyamo afo'amo'a apa'kaeyafe inake huno hapapai'ne “Mako kame ve'kamo'a mani kava eno hu'ne.” huno hike'a ali'ya vaya'moki inake hu'a afine'kae “Lakaeya kanale uta kahau apu'kaitalekaupe?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Afine'kakeno ani hoyamo afo'amo'a inake he “He'e utapa apu'kaisayana haviku kanale avina ya'ae apu'kaitalekayanaki ataleo. ");
INSERT INTO ino_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lapa'kaeya ina kava ohutapa anatale'nike'ana makopi lo'ka'ana hai'ao. Ne'ya'a ali kana fole aisea afina ani hoyale ali'ya vaya'ni'ae inake hu'na hapapaikoe ‘Hokotetapa kahau alitapa haya vaitetapa atafi kane'ataletapa kanale avinama'a ne'ya no'ni'afi maleo.’ hu'na hukoe.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisasi'a mako avoya ke inake he Anumaya Koti'a kava alino yakai lapatesea ya'mo'a ma akufa ya hane'ne. Mako avinamo'a nalepa yosamo alakakana huno aise aise alakatato hane'ne. Ani alakamo aki'a masatati hu'a nehae. Mako kanomo'a ani alakatato alino uno hoyafi ha'kale'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ani masatatimo alakamo'a aise huma'aleka ma mopafi alaka'a akaseno mako aise alakatato hane'nea'maki ha'kalemale'nikeno ani alakatatomo'a mi'ko aki'ae aka'ae yosayaka apa'kaseno lusi yosa nehaiyanakeno ala ala a'kopa hane'neanake'a aki'ae aka'ae namamoki e'a neha'kalae. ");
INSERT INTO ino_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisasi'a mako avoya ke inake huno hapapai'ne Anumaya Koti'a kava alino yakai lapatesea kava'mo'a kai hame'yapi yisi malakeno hale ne'kea yisi'kana hu'ne. Mako a'mo'a ani kai hame'ya alino hale kisea ya yisi alino aole'ae mako'ae la'nefa falaova havaite'nea lapepi maleteno alino aku naku hikeno henaka'a mi'ko ani la'nefa falaova'mo'a halekino ala hu'ne. Anumaya Koti'a kava alino yakai lapatesea kava'mo'a ani hale kisea yisi'kana huno hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ali'a atalu hu'naya vaya'aife Yisasi'a ani mi'ko ke hapapai'neana avoya ke'afati'ke hapapai'ne. Alaki mako ke'a huno fole aino hapa'opai'nea'maki alaki avoya ke'ake hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ani avoya ke'ake a'ke'ainaka mako Anumayamo aune ve'kamo hu'nea kemo'a fole aino ne'ya alitekeno lamake hu'ne. Ani kemo'a make hu'neane “Nakaeya navaya a'ka hu'na mi'ko avoya ke'ake hukoe. Nakaeya a'ke'ainaka ma mopa alo ohu'nea kanafi fala'kino haneme e'nea ke meni hapapaikoe.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yisasi'a ani ali'a atalu hu'naya ve a'ne apataleno nopi haino mai'nike'a akaeya ke ne'afea anaka'moki akaeyate e'a inake hae “Ala Nenao kahau hoyafi laki'nea avoya kemo'a na'mone kemofe hu'napi ai'ka yahae hu'ka lahapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nehakeno Yisasi'a inake he ani kanale avina ya ha'kale'nea ve'ka ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka mai'noe. ");
INSERT INTO ino_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ani hoyae hu'na hoana mi'ko ma mopale kuma'yakae hu'noe. Kanale avina yane hu'na hoana Anumaya Kotife “E'ka yakailato.” hu'a hu'naya vaya'aife hu'noe. Sata kele a'kame ne'malaya vaya kahaukana hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kahau avina ya ali'neno ha'kale'nea ve'ka Sata'a ha'kale'ne. Ne'ya ali kanae hu'na hu'noana ma mopa hano hisea kanae hu'noe. Ali'ya vayane hu'noana ko'ku'napi kayo kayo vaya'aife hu'noe. ");
INSERT INTO ino_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Kahau ali'a anupa hute'a atafi katalaya kava hu'a henaka'a ma mopa hano hisea afina ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na kayo kayo anaka'ni hupatesuke'a Anumaya Koti'a kava alino yakai'nea vayapatina “Mi'ko hao'otake kava ho.” hake'a apa'ku apame alino ya ne'kalea vaya'ae mi'ko hao'otake kava nehaya vaya'ae apasakau'a yaka hutalekae. ");
INSERT INTO ino_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Lusiya huno leke leke nehea atafi apasakau'a yaka hutalekae. Ani atafina lusiya hu'a avovo vava nehu'a avi nele'a apave kemo'a lusi kava hukae. ");
INSERT INTO ino_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nehisake'a ani afina alakepa hu'a ne'maisaya ve a'ne'moki Afo'apimo ne'yakaiya kumate hai'a yakekana hu'a a'a halekae. Ani yafe kakaeya kakesa hane'nisike'kaefena mani ke afi'ka alakepa hu'ka afeo. ");
INSERT INTO ino_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anumaya Koti'a kava alino yakai lapatesea kava'mo'a ma kava hu'ne. Mako ve'kamo'a moni peni hoya'afi ano ati'kamale'nikeno fate ve'kamo'a ani moni peni akeno fole aiteno halate ano ati'kateno lusi amuse huteno “Ma mopa miya hisukeno nakaeya'ni ya hamalese.” huteno uno mi'ko afeno'a mako vaya'aife “Miya heo.” hike'a miya hetakeno ani miya alineno ani moni peni fala'kimale'nea hoya hane'nea mopa miya he'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Anumaya Koti'a kava alino yakai lapatesea kava'mo'a ma kava hu'ne. Lusi afeno male'nea ve'kamo'a kanale'nale taimoni kinikana ya kahau ne'aeye. Kahau ame veateka mako kanale taimoni kinikana ya aketeno eteno uno mi'ko afeno ya'a mako vaya'aife “Miya heo.” hike'a miya faitakeno ani miya haya moni alino uno ani kanale taimoni kinikana ya miya he'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Anumaya Koti'a kava alino yakai lapatesea kava'mo'a ma kava huno hane'ne. Lu'konako ku li kotupi atalakeno lavike'a aki'ae aka'ae faya ani lu'konako kupi mai'naya akufa kava hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ani lu'konako kuna havaiteke'a li kahaepateka avayu hu'a e'a malete'a mopale mai'ne'a kanale faya'a mako lapepi ne'male'a haviya hu'nea faya'yaka'a ali'a yaka hutale'nae. ");
INSERT INTO ino_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Henaka'a ma mopa hano hisea afina ani akufa kava ve a'ne'aite va'yi huke. Ko'ku'napi kayo kayo vaya'moki e'a fa'ko hu'a alakepa kava nehaya vaya'ae hao'otake apa'ku apa'kesa'ae vaya'ae fa'ko hukae. ");
INSERT INTO ino_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Fa'ko hute'a mi'ko afina lusiya huno ata leke leke nehea atafi ani hao'otake kava nehaya vaya apasaka hu'a yaka hutalesake'a lavi'a ani kumapi lusiya hu'a avovo avava nehu'a apave kemo'a lusi kava huke. ");
INSERT INTO ino_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisasi'a inake huno apafine'ke “Ani ke ako afitapa alakepa hu'nafe?” huno apafikeke'a inake hae “He lakaeya kanale huta ako afi'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nehakeno Yisasi'a make huno hapapai'ne “Ala afeno no male'nea ve'kamo'a ani afeno no'afati atafa ya'ae saufa ya'ae alino vaya apamike. Lapa'kaeya mono hapalitapa hapa'nepaiya vaya meni nakaeya hoa ke afi'naya yafe ani kava hutapa a'ke'ainaka lahapapai'naya Anumaya Koti ke'ae meni lahapa'nepauva Anumaya Koti'a kava alino yakai nelapatea ke'ae afitapa a'kame malesayana hokote ke'ae meni saufa ke'ae hutapa fole aitapa hapapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisasi'a ani avoya ke huno avaya ateno ani kuma ataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kuma aepa'ale Nasaleti uteno apa'kai'api mono nopi haino Anumaya Koti ke hapa'nepaike'a ani kumate vaya'moki atali atalu nehu'a make hu'nae “Mika akenopafi hale'nea ya'ae o'ake'nona avame hu lo'kiya ya'ae mikani ve'kamo'a hanateti ali'ne? ");
INSERT INTO ino_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mikani ve'ka no ki ali'ya ne'alea ve'kamo mafa'ne o'mai'nife? Hifi Malia'a akaeya ita'amo o'mai'nife? Yemisi'ae Yosefe'ae Saimoni'ae Yutasi'ae akana'amoki o'mai'nafe? ");
INSERT INTO ino_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Akaeya asa'amoki lakaeya'ae lo'ka'a o'mai'nafe? Mi'ko lo'kiya ali'ya ne'alea ya'ae nehea ke'ae hanateti ali'ne?” ");
INSERT INTO ino_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Inake hu'a hute'a Yisasife apaipa kafa ha'nae. Apaipa kafa ha'naya'maki Yisasi'a inake huno hapapai'ne “Anumaya Koti ke huno fole ne'aiya ve'ka alu kumateka aki hane'nea ve'ka mai'nea'maki akai'a afamo'ae no kuma'ale vaya'ae aki ali'a asaka nohae.” ");
INSERT INTO ino_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Inake huteno akaeyafe afi'a apaipafi o'male'naya yafe ani kumate o'ake'naya lo'kiya ya ho'kano huno apave oli'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ani kanafi mako ala kava ve'kamo aki'a Heloti'a Yisasi hu'nea kava'mo avake'a afi'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Afiteno Heloti'a akai'a ali'ya vaya'aife inake huno Yisasife hapa'nepaiye “Ma ve'ka Yoni'a li falene'apatea ve'ka ako fali'neapati heti'ne. Heti'nea yafe lusi lo'kiya'a hane'nikeno lo'kiya ali'ya akaeya ayapati fole ne'aiye.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Heloti akana'amo aki'a Filipi'ae. Ani Filipi ana Helotiasina Heloti'a kumai kava hute'nikeno Yoni'a Helotife inake hu'ne “Anumaya Koti ke ali'ka ataka'ka kakana'kamo ana a'ka kapele'ka ali'nane.” huno hu'nea yafe Heloti'a ali'ya vaya'a hupateke'a Yonina atafa hu'a nofi hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nofi hute'nakeno Heloti'a “Yonina haesukeno falike.” huno hu'nea'maki mi'ko vaya'moki Yonife “Aune ve'ka mai'ne.” hu'a apa'kesa afi'naya yafe koli huno oha'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oha'nea'maki Helotina alite'nea kana va'yi hike'a vaya'moki Heloti'ae ali'a atalu hu'a mai'nakeno Helotiasi a'mafa'ne'amo'a eno folaka'apifi aiya ne'aekeno Heloti'a ne'akeno amuse hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Amuse nehuno Heloti'a ani a'mafa'ne inake huno hapai'ne “Anumaya Koti aulakale kaha'nepauve kakaeya mako kahaisea yafe ke hisanana kamikoe.” ");
INSERT INTO ino_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hu'nikeno ani a'mafa'nemo ita'amo'a mako aipa akesa amitekeno eteno eno inake he “Kakaeya Yoni'a li fale ne'apatea ve'ka hakeno falitesike'ka akenopa'a lapepi malete'ka ali'ke'ka nameo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hikeno ala kava ve'kamo aipamo'a lusi kana nehikeno Anumaya Koti aulakale huno lo'kiya vai'nea ya'ae mai'naya vaya'ae akesa afino “Ani a'mafa'ne hu'nea ya amikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mako ati ve'ka hune'ateno inake huno hapai'ne “Yonina hakeno falino.” he. ");
INSERT INTO ino_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hikeno nofi nopi uno ake'ya hataka huteno akenopa'a lapepi maleteno ali'neno ani a'mafa'ne amikeno ita'amona alino uno ami'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoni ke ne'afea anaka'moki e'a Yoni akufa hipo'ya hu'a ali'u'a kitete'a Yisasiteka u'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hapaitakeno Yisasi'a ani ke afiteno ani kuma ataleno akaeya ke ne'afea anaka'ae lipi kalefi vaya o'mai koteka u'nae. Apa'kaeya apaote ani koteka u'naya'maki anile ali'a atalu hu'naya vaya'moki Yisasi'a vaya o'mai koteka vea ke afite'a kuma'apileti mopafi a'kame hafai'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","U'nakeno Yisasi'a lipi kalefati asaka hunelavino akeana nesu ve a'ne mai'nakeno apa'keteno lusiya huno hautakipateteno mi'ko kali vaya alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Unetike'a akaeya ke ne'afea anaka'moki Yisasite e'a inake hae “Ma kote alaki vaya o'mai kotenaki ako hani kikefe nehiki ma vaya'kona hupateke'a u'e'a hu'a ne'ya'api kahau a'a kuma kotekati ne'ya miya he'a neo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nehakeno Yisasi'a inake huno hapapai'ne “Hana ya hu'a visae? Lapa'kaitapike mani vayana ne'yana apamisaya'mae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nehike'a akaeya ke ne'afea anaka'moki inake hae “He'e lakaeya ne'ya ho'kata o'ali'nona'maki laya mako kaya kai hame'ya maya'ae aole'ko faya'ae ali'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nehakeno “Ani ya nakaeyate alitapa eo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yisasi'a ani ali'a atalu hu'naya vaya'aife “Hafepale maiyo.” hike'a mai'nakeno Yisasi'a mani naya mako kaya kai hame'ya mayaki aole fayatalanaki aliteno ko'ku'napaka aulu he'neno Anumayamoteka ke huno amuse huteteno a'kaya heno akaeya ke ne'afea anaka apamike'a ali'u'e'a hu'a mi'ko vaya apami'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Apamike'a mi'ko vaya'moki ani ne'ya ne'a apamu hutake'a neke'a atalaya atupa atapa ne'ya ali'a anupa hayana nayatala'a hano huteno naiyalekati aole ku (12 ku) ai'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ani ne'ya ne'naya ve laya mako kaya tauseni vemoki (5,000) ne'naya'maki a'ne mafa'ne'a le'kana opaike'a o'afunama'amoki ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ne'ya netakeno Yisasi'a akaeya ke ne'afea anaka'aife inake nehe “Nakaeya nataletapa hokotetapa lipi kalefi haitapa ala li kotu la'ka hetapa li'mo mukakaya aupalika utapa hoko neteke'nao. Nakaeya ma vaya'yaka hupatesuke'a visae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mi'ko vaya hupateke'a utakeno Yisasi'a akai'ake Anumayamoteka ke huno afikekefe avimapi haino mai'nikeno hani ki'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Avimapi mai'nike'a akaeya ke ne'afea anaka u'naya lipi kale ako uno li folakapi ne'vakeno aukosalekati lo'kiya yasi ekeno li'mo'a ani lipi kale alino aino yahae hutale ya hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ko alino fanufane nehikeno Yisasi'a li ameka akaeya ke ne'afea anaka'aite u'ne. ");
INSERT INTO ino_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ne'eke'a akaeya ke ne'afea anaka'moki Yisasi li ameka ne'eke'a “Afe kano ne'e.” hute'a lusi koli nehu'a kalafa hu'a avovo nehae. ");
INSERT INTO ino_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Avovo nehakeno Yisasi'a makale inake he “Lapa'kaeya koli oheo. Nakaeya'ke ne'oanaki lapaipamo'a lo'kiya vainaketapa vase hutapa maiyo.” ");
INSERT INTO ino_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nehikeno Pita'a anona'a ke'ale inake he “Anumayamoka kakaeya ne'e'kaefena ke huke'na nakaeya'ae kakaeya mai'nanate li ameka vino.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nehikeno Yisasi'a Pitafe “Eno.” hikeno Pita'a lipi kalefati hati lavino li ameka Yisasi'a ne'eateka ukefe ne've. ");
INSERT INTO ino_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ne'eno akeana lo'kiya yasimo'a lo'kiya vaino ea yate aketeno Pita'a koli nehuno makale'a lipi lavino nelapa'kaneno inake he “Anumayamoka nakufa ali'ka kateo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ke hikeno Yisasi'a makalema'a ayate atafa huteno heno avayu huteno inake he “Kakaeya nakaeyafe aise ya'a afi'ka kaipafi male'nane. Na'ya hike'ka kame aole aole nehane?” ");
INSERT INTO ino_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ina kava hute'ana lipi kalefi asakau ne'mai'akeno ani lo'kiya yasi ma'nete. ");
INSERT INTO ino_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mateke'a lipi kalefi mai'naya vaya'moki akete'a Yisasi aki ali'a asaka nehu'a inake hae “Lamake kakaeya Anumaya Koti Mafa'ne mai'nane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ani li kotu la'ka he'a Kenesaleti kumate ne'vae. ");
INSERT INTO ino_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne'vake'a ani kumate vaya'moki “Yisasi'a ne'e.” hu'a haya ke afite'a ani kuma'mo haute hane'nea kuma'yakale vaya'aife ke hu'a hapapaike'a kali vaya apavale'a ete ete hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ani kali vaya'moki e'a Yisasife inake hu'a afine'kae “Afa'a kena'kamo atupale ame'ko ne'alisunakeno kaliti hano hise.” hu'a hute'a Yisasi kenale ame'ko ne'alikeno kali'api hano hikeno eteno apa'kufamo'a kanale hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Mako Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae Yelusalemu kuma atale'a Yisasite e'a inake hae “Na'ya hike'a kakaeya ke ne'afea anaka'moki lakaeya lakinakomoki hu'naya ke ali'a ne'ataka'a ne'ya nekefe apaya sese ohu'a afa'a ne'nae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yisasi'a anona'a ke'apile inake hu'ne lapa'kaeya na'ya hiketapa lapa'kinakomoki ke'ake a'kame ne'malaya yafe Anumaya Koti ke alitapa ne'atakae? ");
INSERT INTO ino_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anumaya Koti avopi inake hu'ne “Lapa'kaeya ita afotapimoki apa'ki alitapa asaka nehutapa ke'api kanale'ya hutapa ne'afitapa a'kame ne'maletapa vekano'kano huo'apateo. Mako ve'kamoka ita afo'kamokanife hu'ka haviya hunatesanana falikane.” huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Hu'nea'maki lapa'kaeya make hutapa nehae. “Mako ve'kamo'a ita afo'amokani hana'maesea miya ali'neno'ae'maki hana'o'maesoe huteno make nehe ‘Ma moni Anumaya Koti amisoa moni ali'noe.’ huno hiseana Ita afo'amona ha'mano ana'ki alino asaka ohise.” hutapa nehae. Ina kava nehaya kava'mo'a Anumaya Koti ke male male'nea ke alitapa ne'atakatapa lapa'kinakomoki ke'ake alitapa yosa vaitapa a'kame ne'malae. ");
INSERT INTO ino_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Ina kava nehayana lapa'kaeya alaki lapa'ke'ati ke'ake vaya mai'nae. Aisaiya'ae aune ve'kamo'a alaki lamake huno lapa'kaeyafe huno make hu'neane “Ani vaya'moki afa'a ameka apavayaleti'ke nakaeya naki ali'a asaka nehaya'maki apaipamo'a ako alu'ale hane'nike'a ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ani vaya'moki apavayafati hu'naya ke inake hu'nae ‘Ani ke Anumaya Koti ke hane'niki a'kame maleo.’ hu'a nehaya'maki inani akufa kava nehu'a nakaya naki ali'a asaka nehaya kavana afa kava mai'a nehae.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yisasi'a ve a'ne'aina ke hike'a akaeyate akeno inake he “Lapa'kaeya mani ke ne'afitapa lapa'kesa afitapa alakepa heo. ");
INSERT INTO ino_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mi'ko ne'ya lapavayafati nakeno lapaipafi nelavea ne'ya'mo'a vaya alino honi'ya nofaiya'maki vaya'mokita lavayafati'ke hatilavea ya'mo'ke vaya alino honi'ya'ake huke.” ");
INSERT INTO ino_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hu'nike'a akaeya ke ne'afea anaka'moki e'a inake hu'a Yisasina hapai'nae “Falasi mono ke ne'afea vaya'moki mani ke ne'afi'a apaipa afi'a haviya hune'kataya'maki ake'napi o'ake'nane?” nehae. ");
INSERT INTO ino_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nehakeno anona'a ke'apile Yisasi'a inake he “Ko'ku'napi mai'nea Afo'nimo'a akai'a hoya'a hane'neanakeno mi'ko ne'ya akai'a ofai'nea ne'yama'a alaki akola hafu'ya'ae alino va'kaitalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Afa'a apataleke'a maiyo. Apaulaka apo ka'neanake'a vaya'aina ka apavelikefe nehaya'maki apaulaka apo ka'nisea vaya'moki aulaka apo ka'nisea afalu'amona ‘Ka male hane'niki eno.’ hisakeno viseana mi'ko'a kelifi asaka hu'a aikae.” ");
INSERT INTO ino_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Hikeno Pita'a Yisasife inake he “Inani meni hana kemo aepa'a hu'ka fole aiketa afita haleno.” ");
INSERT INTO ino_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nehikeno Yisasi'a inake he “Lapa'kaeya'aeti afita ha oletapa afitapa alakepa ohu'nafe? ");
INSERT INTO ino_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mi'ko ne'ya lapavayafati nakeno lapaipafi lavitekeno lapaipamo'a alino atalekeno yolakafi nelavikeno afa ya'kana nehea'maki lapa'kaeya o'afi'nafe? ");
INSERT INTO ino_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Afa ya'kana nehea'maki mi'ko ke lapavayafati eno hati lavea ke alaki lapaipafati ne'eanakeno vaya alino honi'ya nefaiye. ");
INSERT INTO ino_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Lapaipafati hati nelavea yana ma akufa ya hane'ne. Hao'otake lapaipa lapa'kesa afi ya'ae vaya apamakita kipate ya'ae alu ve'kamo a avayu hu ya'ae a'ne a'mafa'nele kumai kava'ae kumaya'ya hu ya'ae apa'ke'atike ke failitata nehea ya'ae vayatapimokife kamuke hatake ya'ae lapaipafati hati nelave. ");
INSERT INTO ino_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ina akufa kava'mo'a lapaipafati hati lavino vaya alino honi'ya nefaiya'maki vaya'moki apaya sese ohu'a ne'ya ali'a ne ya'mo'a lapaipa alino honi'ya nofaiye.” ");
INSERT INTO ino_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisasi'a ani kuma ne'ataleno Taiya'ae Saitoni'ae hane'nea aupalika u'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uno mai'nikeno mako Kenani a Isaleli nofi o'mai a'mo'a ani aupalika ne'maiya a'mo'a no kuma'aleti akaeyate eno inake huno ke nehe “Anumayamoka Teviti akeho'amoka kalaki ainato. Sata afe'mo'a a'mafa'ne'nimo aipafi mai'neno lusiya huno alino haviya hune'ateke'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nehea'maki Yisasi'a akele o'alike'a akaeya ke ne'afea anaka'moki e'a Yisasife inake nehae “Ala Nenao ma a'mo'a la'kame lahafaino ne'eno lusiya huno ke hume hume ne'eki ‘Ete'ka uvo.’ hu'ka hutekeno vino.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nehakeno Yisasi'a apa'kaeyafe inake huno anona'apile hapapaiye “Isaleli sipi sipi afu anaka'alefe'ke Anumaya Koti hunateke'na nakaeya apa'kaeya'alefe'ke e'noe.” ");
INSERT INTO ino_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nehikeno ani a'mo'a Yisasi aiyafi eno ale'ya lo'a'neno inake he “Anumayamoka kakaeya naya ho.” ");
INSERT INTO ino_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nehikeno Yisasi'a inake he “Haviku mafa'ne'ai ne'ya hapafale'a kalayaka apamisayana kanale ohukeanake'na nakaeya Isaleli nofi vaya apatale'na alu vaya apaya hisoana kanale ohuke.” ");
INSERT INTO ino_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nehea'maki ani a'mo'a inake he “Anumayamoka lamake nehana'maki kalamoki afo'apimoki hipa kapakake mai'nake'a alakepa ne'ya ne'nakeno atupa atapa ali lavea ne'ya'ake mopafati kahalita hu'a ne'nae. Nakaeya ani kava hu'na Isaleli nofi a o'mai'noki afa'a aise'a naya ho.” ");
INSERT INTO ino_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inake hikeno Yisasi'a ani afe inake he “Ma ana afeo nakaeyafe afi'ka kaipafi male'nana ya'kamo'a lo'kiya vai'nea yafe kahau'nea ya fole aikeanaki uvo.” huno ha'nepaikeno ani kanatole ani a'mafa'ne'a eteno kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisasi'a ani kuma ataleno Kalili li kotu aki'naleka uteno inaleti avimapi haino faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mai'nike'a lusi ve a'nemoki akaeyate ali'a atalu nehu'a apaiya avayu hu'nea vaya'ae apayamufamo'a kelokalo hu'nea vaya'ae apaulaka apo ka'nea vaya'ae apa'ke no'aiya vaya'ae mi'ko aki'ae aka'ae kali ali'naya vaya'ae apavale'a e'a Yisasi aiyafi apate'nakeno Yisasi'a ani kali vaya'yaka alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kanale hupate'nike'a mi'ko ve a'nemoki akayana apa'ke no'aiya vaya'moki apa'ke ne'ai'a apayamufa kelokalo hu'nea vayana ete'a kanale nehu'a apaiya haviya hu'nea vaya'yaka ka ne'male'a apaulaka apo ka'nea vaya'yaka ete'a ne'ake'a haya yafe lusi apamo'yo aite'a Isaleli vaya'ai Anumaya Koti aki ali'a asaka nehae. ");
INSERT INTO ino_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisasi'a akaeya ke ne'afea anaka'aife ke hike'a akeno inake huno hapapai'ne “Mi'ko vaya'moki aole'ae mako'ae afina nakaeya'ae maikeno ne'ya'api o'male'nea yafe lusi nahau nehoe. Haviku afa'a apatalesuke'a apa'kateme visayateka kateka u'a apaune'ka'ka ailavisafi hu'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nehike'a akaeya ke ne'afea anaka'moki inake hae “Vaya o'mai kote mai'nonanaketa hanateti ne'ya alita ma akufa vayapi apamisunake'a nekae?” ");
INSERT INTO ino_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nehakeno Yisasi'a inake huno apafine'ke “Lapa'kaeya kutapifina na'maki kai hame'ya maya ali'nae?” huno hike'a apa'kaeya inake hae “He'e lakaeya kaya mako kaya hano huteno kaya mako kayati aole alea (7) kai hame'ya maya aliteta aise aise faya mako'ke mako'ke ali'none.” hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hapaikeno Yisasi'a ani ve a'ne'aife “Mopale maiyo.” hike'a faitopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Faitopale mai'nakeno Yisasi'a ani aya mako kaya hano huteno aya mako kayati aole alea (7) kai hame'ya maya'ae ani aise aise faya'ae aliteno Anumaya Kotiteka ke huno amuse huteteno a'kaya heno akaeya ke ne'afea anaka'a apamike'a ali'u'e'a hu'a ani ve a'ne'ai apami'nae. ");
INSERT INTO ino_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mi'ko vaya'moki ne'a apamu hute'a neke'a atalaya atupa atapa ne'yama'a ali'a anupa hu'a apaya mako kaya hano huteno apaya mako kayati aole alea kupi (7 kupi) aikeno havaite'ne. ");
INSERT INTO ino_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ani ne'ya ne'naya ve fo tauseni'a vemoki (4,000 vemoki) ne'naya'maki a'ne mafa'ne le'kana opai'nae. ");
INSERT INTO ino_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Apamike'a netakeno Yisasi'a hupateke'a utakeno mako lipi kalefi haino maiteno Makatani koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mako Falasi mono ke ne'afea vaya'ae Satiyusi mono ke ne'afea vaya'ae e'a a'a avataka hukefe Yisasife inake hae “Ko'ku'napakati mako o'ake'nona avame hu lo'kiya ya laveleo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nehakeno Yisasi'a apa'kaeyafe inake huno hapapai'ne “Lapa'kaeya une akakeno yakemo'a ko'ku'nate alino haesa hiketapaena ‘Eka'a kanale kotike.’ hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nehaya'maki natepi inake nehae ‘Ko'ku'nate hiya'mo'a alino anupa'ake nehuno ko'ku'na'mo'a haesa'ake nehea yafe meni yasi ne'alino ko ne'aino huke.’ hutapa nehae. He lamake lapa'kaeya ko'ku'nate alino aeto hea ya ne'aketapa ‘Ina kava huke.’ hutapa nehaya'maki meni kanafi fole ne'aiya ya aketapa aeto nohayanaketapa afitapa fa'ko nohae. ");
INSERT INTO ino_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Fa'ko nohaki meni afina mai'naya ve a'nemokitapa hao'otake ve a'ne Anumaya Kotina a'kame'ya ami'naya vaya'mokitapa inake nehae ‘O'ake'nona avame hu lo'kiya'ka laveliketa akeno.’ hutapa ke nehaya'maki Anumaya Koti'a alu mako'ae o'ake'naya lo'kiya avame hu lo'kiya ya lapaveolikea'maki mako'ke'ake Yona'a a'ke'ainaka mai'nea Anumaya Koti aune ve'kamo'a hu'nea avame hu lo'kiya ya'ake alo huno lapavelisiketapa akekae.” ");
INSERT INTO ino_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisasi ke ne'afea anaka'moki li kotu la'ka he'a u'naya'maki kai hame'ya maya apa'ke'kani'a o'ali'a mukakaya falika la'ka he'a u'a va'yi hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Va'yi hakeno Yisasi'a inake huno hapapai'ne “Falasi mono ke ne'afea vaya'ae Satiyusi mono ke ne'afea vaya'ae apaipafi hane'nea ya ake'a alakepa ohu'ne'a ameka apavayaleti apa'ke'atike haya ya apa'ketapa alakepa heo. Vala kai hame'ya maya alo hukefe yisi malete'a ali'a akunaku hakeno hale ne'kea ya'kana kava hu'a halekino ala nehea kava hu'naya yafe maitapa halove heo.” ");
INSERT INTO ino_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Hike'a apa'kai'api apavepi sumi ke hu'u'e'a nehu'a inake hae “Vae lakaeya kai hame'ya maya mako alita o'me'nona yafe mani ke nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nehaya ke Yisasi'a aipafi ako maleno afiteno inake he “Lapa'kaeya aise'ato'ake nakaeyafe afitapa lapaipafi male'naya vaya na'ya hiketapa kai hame'ya maya alita o'me'nona yafe nehe hutapa nehae? ");
INSERT INTO ino_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hifi lapa'kaeya mako ya o'ake'nafe? Laya mako kaya kai hame'ya mayafati laya mako kaya tauseni'a vaya'moki (5,000 vaya'moki) netaketapa na'maki kupi neke'a atalaya atupa'a alitapa aikeno havaite'ne? ");
INSERT INTO ino_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Lapaya mako kaya hano huteno lapaya mako kayati aole alea (7) kai hame'ya mayafati fo tauseni'a vaya'moki (4,000 vaya'moki) netaketapa na'maki kupi neke'a atalaya atupa'a alitapa aikeno havaite'ne? ");
INSERT INTO ino_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nakaeya mako kai hame'ya mayae nohoa'maki na ya hiketapa no'afe? Nakaeya make hu'na nehoe lapa'kaeya Falasi mono ke ne'afea vaya'ae Satiyusi mono ke ne'afea vaya'ae apaipafi hane'nea ya ake'a alakepa ohu'a ameka apavayaleti'ke apa'ke'atike haya ya apa'ketapa alakepa heo. Vala kai hame'ya maya alo hukefe yisi malete'a ali'a akunaku hakeno hale ne'kea ya'kana kava hu'a halekino ala nehea kava hu'nea yafe maitapa halove heo.” hu'nae nehoe. ");
INSERT INTO ino_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nehike'a afite'a “Kai hame'ya mayafi yisi malete'a ali'a akunaku hakeno hale ne'kea yafe nohea'maki Falasi mono ke ne'afea vaya'ae Satiyusi mono ke ne'afea vaya'moki ke hisaya ke yakai'neta maita halove hisuna yafe nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisasi'a Sisalia Filipai kumate uno lava'neteno akaeya ke ne'afea anaka'aife inake huno apafine'ke “Mi'ko ve a'nemoki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'naena nala'a mai'ne hu'a hune'natae?” ");
INSERT INTO ino_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Huno apafine'keke'a anona'a ke'ale inake hae “Mako'amoki kakaeya ‘Li falene'apatea ve'ka Yoni'a mai'ne.’ hake'a mako'amoki ‘Ilaiya'a mai'ne.’ hake'a mako'amoki ‘Yelemaeya'ao mako a'ke'ainaka mai'nea Anumayamo aune ve'ka mai'ne.’ hu'a nehae.” ");
INSERT INTO ino_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nehakeno inake he “Lapa'kaeyatapi nakaeyafe nalaka mai'nane hutapa nehae?” ");
INSERT INTO ino_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Apafine'kekeno Saimoni Pita'a inake nehe “Kakaeya Kalaisika Anumaya Koti lakufa alino katisea yafe hukate'nea ve'ka mai'nane. Kakaeya lo'kiya avamu'a hane'nea Anumaya Koti Mafa'ne mai'nane.” ");
INSERT INTO ino_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yisasi'a Pitafe inake he “Saimoni Yona mafa'nemoka ani ke hana yafe Anumaya Koti'a amuse hisana ya kami'ne. Mako mopafi ve'kamo'a inani hana ke kahapaike'ka ohana'maki ko'ku'napi mai'nea Afo'nimo'a kahapaike'ka ani ke hu'nane. ");
INSERT INTO ino_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nakaeya kaha'nepauve kakaeya Pitakae kakimo aepa'a yafane. Ani hu'nana kemo'a yafa'kana nehike'na nakaeya mi'ko apaipa nami'naya vaya mani yafa'mo akofetule no'kana hu'na kimale'nisuke'a hani kumapi ata leke leke nehea kelifati lo'kiya ya'mo'a ani kimale'nisoa nona alino kape olekaiye. ");
INSERT INTO ino_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nakaeya Anumaya Koti kava ya alino ne'yakaiya kumate ya'kisana ki kamitesuke'ka mopale mai'ne'ka ‘Ma ya atafa hutapa alaki heo.’ hisanana Anumaya Koti'ae ani kava huno ko'ku'napaka mai'neanakeno ani hu'nana ya ‘Atafa hutapa alaki heo.’ huno lo'kiya ke huke. Kakaeya mopafi mai'ne'ka mako yafe ‘Afa'a ataleo.’ hu'ka hisanana Anumaya Koti'ae ani kava huno ko'ku'napaka mai'neanakeno ani yafe ‘Afa'a ataleo.’ huno lo'kiya ke huke.” ");
INSERT INTO ino_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yisasi'a akaeya ke ne'afea anaka'aife lo'kiya ke inake hu'ne “Lapa'kaeya utapa mako ve'kae nakaeyafe ‘Akaeya Kalaisi Anumaya Koti lakufa alino katiseafe hute'nea ve'kae.’ hutapa ha'opaiyo huno apa'kesa ali'ne.” ");
INSERT INTO ino_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ani afina Yisasi'a akaeya ke ne'afea anaka'ae henaka'a fole aisea yafe aepa heno hapapai'ne. Inake huno nehe “Nakaeya Yelusalemu visuke'a ani kumate ala ala vaya'ae mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae lusi nakafu kisea kava hunatete'a nahaesake'na falikoe. Falitesuke'a kelifi kinatesake'na aole'ae mako'ae alisea kanafi fali'nisoapati ete'na hetikoe.” ");
INSERT INTO ino_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Hikeno Pita'a Yisasina avaleno alu'ale ate'neno aepa heno Yisasife inake he “Anumaya Koti'a ani kava ohisaya apaipa apa'kesa apamise. Anumaya'nimoka kakaeya ani kava huo'katesae.” ");
INSERT INTO ino_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nehikeno Yisasi'a aino yahae huno Pitafe inake nehe “Sataka e'ka na'kamelaka uvo kakaeya nakaeya naipa ali'ka haviya hukefe nehanaki Anumaya Koti afi'nea aipa akesa kanale hu'ka no'afinaki vaya'moki kahapaiya kaipa kakesa ne'afine.” ");
INSERT INTO ino_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yisasi'a akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Mako ve'kamo'a nakaeyafe afiteno na'kame malesuno'aena akai'a akufae akesa o'afino nakaeya nakufa nakafu kisike'na falisoa kava hisea akesa afiteno yofo yosa'a amete amete aki'nale kofi'neno na'kame eno. ");
INSERT INTO ino_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mako vaya'moki apavamu hanesike'a kanale mai ya'a atafa hu'a alaki huli'a maisayana ani apavamu hano hukea'maki mako vaya'moki nakaeyafe apa'kesa afi'a kanale mai ya'api'ae apavamu'ae atalesayana ani kanale mai ya'api alaki ali'na katisuke'a akola maikae. ");
INSERT INTO ino_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inaki mako vaya'mokitapa lapavamu alitapa mai yafe lapa'kesa o'afitapa mi'ko mopafi yafe'ke lusiya hutapa lahapaisiketapa ne'alisayateti falisayana ani afeno ya'mo'a hana ya huno lahapa'mano mai yana lapamike? Falite'aena ani vaya'moki hana akufa miya ali'u'a maike maike hu'a mai avamu miya he'a alikae? He'e akola fali'a fanane hukaiyanake'a akola maike maike hisaya apavamu ete'a o'alikae. ");
INSERT INTO ino_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","O'alikaya'maki henaka'a nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka afo'nimo ano hale lo'kiya himamu ya'ae ko'ku'napi kayo kayo vaya'ni'ae ete'na esoa afina mi'ko vaya'moki mopale hu'naya kavateti anona'apile apamikoe. ");
INSERT INTO ino_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lamake hu'na lahapa'nepauve meni nakaeya'ae male mai'naya vayapati mako vaya ofali'a afa'a mai'nisake'na nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na kava yakaisoa yafe va'yi hisuke'a nakete'a falikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Apa'kaeya naya mako kaya hano huteno naya mako kayati mako'ke alea afina (6 afina) maite'a Yisasi'a Pita'ae Yemisi'ae akana'amo'a Yoni'ae apavaleno mako hanafi hai'nea avimapi atulu hu'a hai'a apa'kai'apike mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mai'nakeno apaulakale Yisasi akufamo'a alino fate kava nehuno aukosamo'a yakekana nehuno ano ha nelekeno kena'amo'a yave yave nehuno alave alave nehe. ");
INSERT INTO ino_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Alave alave nehike'a akayana aole ve'kala a'ke'ainaka fali'na'a ve'kala Mosese'ae Ilaiya'ae fole ai'ana Yisasi'ae kake neha'ake'a apa'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Apa'ke'nakeno Pita'a Yisasife inake huno hapai'ne “Anumayamoka male maunana kanale kava heanaketa kakaeya kahaiseana aole'ae mako'ae amoke no kikune. Mako nona kakai'ka none. Mako nona Mosese none. Mako nona Ilaiya none.” ");
INSERT INTO ino_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ani ke nehikeno alave alave'ake hiya'mo'a eno aino susu lepate'nikeno ani hiyapati mako ake ne'aino inake he “Ma Mafa'ne alaki nakai'ni lusiya huno nahau nayamopafati ne'nahaiya mafa'neke'na lusi amuse'a nehoa ve'ka mai'neanaki ke'a kanale'ya hutapa afeo.” huno ake aiya akemo'a ake aino hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hapapai'nike'a Yisasi'ae lo'ka'a mai'naya anaka'moki ani ke afite'a lusi apamo'yo ne'ai'a apaukosalekati apa'ko'ya fai'a mopafi mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Apa'ko'ya fai'nakeno Yisasi'a eno apame'ko ne'alino inake he “Koli ohutapa heteo.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hike'a ake'a asaka hu'a akayana Yisasi'a akai'ake mai'nike'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ani avimapati atale'a u'a nelavi'a Yisasi'a apaumomo maleno inake he “Lapa'kaeya mako ve'ka mani akaya yafe alaki ha'opaitapa afa'a mai'nike'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne kelifati ete'na heti'nisoa afina ani ke hutapa fole aitapa hapapaiyo.” huno apa'kesa ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Apa'kesa aliteke'a akaeya ke ne'afea anaka'moki inake hu'a afine'kae “Na'ya hike'a mono hapali'a hapa'nepaiya vaya'moki Ilaiya'a hokoteno etesikeno Anumaya Koti'a lakufa alino katisea ve'ka henaka ekaiye hu'a hu'nae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Afine'kakeno Yisasi'a inake huno hapapai'ne “He lamake Ilaiya'a e'neno mi'ko ya alino alakepa huno no'ale no'ale maleno avatati huke. ");
INSERT INTO ino_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Avatati hukea'maki nakaeya lahapa'nepauve ani Ilaiya'a ako e'nea'maki vaya'moki akaeya ake'a alakepa hu'a o'ake'nayanake'a apa'kai'api afea apa'ku apa'kesa afea kate a'kame ne'male'a aki'ae aka'ae kava hu'a ali'a haviya hutakeno akufa akafu kino fali'ne. Fali'neanake'a nakaeya'ae ani kava hu'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ali'a haviya hunatesakeno nakufa nakafu kike.” ");
INSERT INTO ino_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yisasi'a ani ke huno hapapaike'a akaeya ke ne'afea anaka'moki Yoni'a li falene'apatea ve'kae nehe hu'a afi'a hale'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lusi vaya ali'a atalu hu'a mai'nake'a Yisasi'a akaeya ke ne'afea anaka'ae u'a va'yi nehakeno mako ve'kamo'a Yisasi aiyafi eno ape huno ale'ya alo ne'ano inake he. ");
INSERT INTO ino_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Anumayamoka mafa'ne'ni kalaki aito. Lusiya huno hafosa ya ne'akeno atafi'ae lipi'ae asaka huno ne'atekeno akufa akuya ne'vaiye. ");
INSERT INTO ino_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ina kava nehike'na kakaeya ke ne'afea anaka'aite avale'na e'noa'maki mafa'ne'ni ali'a kanale hutesaya lo'kiya'api o'male'ne.” ");
INSERT INTO ino_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nehikeno Yisasi'a mi'ko vaya'aife inake huno hapapai'ne “Lapa'kaeya meni afina mai'naya vaya hao'otake vaya mai'netapa nakaeyafe afitapa lapaipafi o'male'nakeno lapaipamo'a kanale ohu'nea yafe nakaeya alaka ne'nahaeye. Na'maki afina lapa'kaeya'ae mai'nisuketapa nakaeyafe afitapa lapaipafi malekae? Na'maki afina mako'ae nahau hulapatesoe? Ani mafa'ne male avaletapa nakaeyate eo.” ");
INSERT INTO ino_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Huteno Yisasi'a ani aipafi mai'nea Sata afe ke ne'ama'kikeno ani ke ama'kea afina ani mafa'nemo aipafati ataleno vikeno hafosa ya ne'akea ya'a kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yisasi ke ne'afea anaka'moki apa'kai'apike Yisasite e'a inake hae “Na'ya hiketa lakaeya ani mafa'nemo aipafati Sata afe alita atalesuna lo'kiyati o'male'ne?” hu'a afike'nae. ");
INSERT INTO ino_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Afine'kakeno Yisasi'a inake huno hapapai'ne “Nakaeyafe afitapa lapaipafi male'naya yatapimo'a aise hu'nea yafe ani akufa kava hisaya lo'kiyatapi o'male'ne. He nakaeya lamake lahapa'nepauve aise avina alakamo aki'a masatati alakakana hutapa lapa'kaeya nakaeyafe afitapa aise'a lapaipafi male'nininana ma avimafe ‘Heti'ka mukaleka uvo.’ hininana afa'a hetino vinine. Nakaeyafe afitapa lapaipafi male'naya yafenaketapa lapa'kaeya ‘Mako ali'yafe lo'kiyati o'male'ne.’ hutapa ohukaki afa'a mi'ko lo'kiya kava afa'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hukaya'maki ne'ya mosi'netapa Anumayamoteka afikesaya ya'mo'ke ani Sata afe alitapa atalesaya lo'kiya yatapi alikae.” ");
INSERT INTO ino_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Akaeya ke ne'afea anaka'ae Kalili koteka makopi ne'u'a Yisasi'a inake huno hapapai'ne “Aise kana mai'nisunake'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka navale'a kame vaya'moki apayapi natekae. ");
INSERT INTO ino_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Natesake'a nahaesake'na falikoe. Falitesuke'a kelifi kinate'nisake'na aole kana maite'na kotiseama'a fali'nisoapati ete'na hetikoe.” huno hapapaike'a akaeya ke ne'afea anaka'moki apaipamo'a kana'ake nehe. ");
INSERT INTO ino_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Henaka'a Kapaneamu kumate u'a va'yi hake'a ala mono no ali'a alakepa hisaya moni ne'alea vaya'moki Pitate e'a inake hae “Lapa'kaeya alino lapaya nehea ne'mo'a ala mono no ali'a alakepa hu moni ne'malefe?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Afine'kakeno Pita'a inake he “He ne'male.” huteno no'ale uno haikeno Yisasi'a hokoteno mako ke inake huno afine'ke “Saimoni Pitaka kakaeya ma yafe na'yane hu'ka kakesa ne'afine? Mopafi ala kava vaya'moki vaya apa'kufaleti ne'alea moni hana vayateti ne'ale? Apa'kai'api nofi vaya'aleti'ke aeto hu'a ne'alifi fate nofi vayateti'ae ne'ale?” ");
INSERT INTO ino_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Afikekeno Pita'a inake he “Fate nofi vaya'alekati'ke ne'ale.” huno hikeno Yisasi'a akaeyafe inake he “Lamake hane. Apa'kai'api nofi vayateti ta'kesi moni no'alisayana lakaeya'ae ani kava huta Anumaya Koti anaka mai'nonanaketa lakaiti moni lakaeyateti'ae ta'kesi moni malesuna ali'ya o'male. ");
INSERT INTO ino_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","O'malekaiya'maki haviku ina akufa kava hisuna yafe apaipamo'a haviya hisaki kakaeya li kotute u'ka faya he nofi atale'nekeno hokoteno eno nesike'ka avayu hisana faya'mo avaya ali'ka a'ka huli'ne'ka mako moni akekane. Ani alisana moni ali'ka e'ka ani vaya apamisanakeno la'akaeya la'akufale moni atale kate aino a'kanise.” ");
INSERT INTO ino_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ani afina Yisasi ke ne'afea anaka'moki Yisasite e'a inake hu'a afine'kae “Hana ve'kamo'a mi'ko vaya apa'kaseno Anumaya Koti'a kava yakaisea kumate ala ne maike?” ");
INSERT INTO ino_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hu'a afine'kakeno Yisasi'a mako aise mafa'ne ke hikeno eno mi'ko vaya'ai folaka'apifi hetite'ne. ");
INSERT INTO ino_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Heti'nikeno inake he nakaeya lamake lahapapauve lapa'kaeya lapaipa aitapa yahae nehutapa lapa'kufa alitapa hai kava ataletapa ma akufa mafa'nemo nehea akufa kava ohisayana Anumaya Koti'a kava yakaisea kumate ohaikae. ");
INSERT INTO ino_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mako ve'kamo'a akai'a akufa avaleno ohaino mi'ko afina aise mafa'nekana huno maiseana ani ve'kamo'a mako vaya apa'kaseno Anumaya Koti'a kava yakai'nisea kumate haino ala ve'ka maike. ");
INSERT INTO ino_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inaki mako ve'kamo'a nakaeyafe akesa afiteno ani akufa aise mafa'ne avaleno aya hiseana ani ve'kamo'a nakaeya'ke navaleno naya nehe. ");
INSERT INTO ino_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nakaeyafe afi'a apaipafi male'naya mafa'ne anakapati mako ve'kamo'a mako mafa'ne'ne “Hao'otake kava ho.” huno avaleno yakalesikeno hao'otake au'ava yapi asaka hulaviseana ani ve'kamo'a lusi hao'otake kava hukeanake'na lusi hanake'ke ya ani ve'ka amikoe. Ala yafa ali'e'a ani ve'kamo ake'yale male'a nofiteti kitete'a avale'u'a hake lipi yaka hutalesakeno faliseana aise hanake'ke ya hane'nea'maki inaya akase'na nakaeya mako'ae ala hanake'ke ya amikoe. ");
INSERT INTO ino_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Avo'neo mopafi vaya'moki nakaeyafe afi'a apaipafi male'naya vaya apavale'a yane'kalaya vaya'aife lusiya hu'na nahau hune'apatoe. Ani “Hao'otake kava heo.” hu'a a'a apavataka hisaya ya va'yi hukea'maki ani kava aepa he'a ali'a fole ai'naya vaya'aife lusiya hu'na nahau hupatoe. Ani vaya'aife “Avo'neo.” hu'na “Hanake'ke ya lapa'kaeyate fole aike.” hu'na lusi nahau hulapatoe. ");
INSERT INTO ino_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Inaki kaiyamopi kaya'mopi “Hao'otake kava ho.” huno kavaleno yakaleno havi kapi katesike'kaena ako ani kaiya'ae kaya'ae he'ka hataka hu'ka yaka hutalo. Hataka hu'ka yaka hutalesanakeno mako'ke kaiya'ae mako'ke kaya'ae hane'nisake'ka kanale'ya hu'ka maike maike hu kavamu alisane. Haviku aole kaiyala'ae aole kayatala'ae hane'neno kavale'a ata leke leke nehea atafi yaka hutale yafe mako'ke kaiya kaya'ake hane'nisike'ka kanale'ya hu'ka maike maike hu kavamu alikane. ");
INSERT INTO ino_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ani kava huno mako'ke kaulakamo'a akea ya'mo'a kavaleno yakaleno havi kapi visana kakesa kamisike'kaena ani kaulaka ali'ka kati'ka atalo. Haviku aole kaulakala hane'neno kavale'a ata leke leke nehea atafi yaka hutalesea yafe mako'ke kaulaka'ake hane'nisike'ka maike maike hu kavamu alisane. ");
INSERT INTO ino_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Lapa'kaeya maitapa halove hu'netapao. Haviku ma mai'naya vaya'mokitapa mako ve'kae “Ina akufa ya mai'ne.” hutapa hisaki. Ani yafe nakaeya make hu'na lahapa'nepauve ko'ku'napi akaeyate kava hu kayo kayo vaya'amoki mi'ko afina ko'ku'napi mai'nea Afo'nimo aukosafi ake'a ne'maiye. ");
INSERT INTO ino_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na'yafenomaki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na mopafi e'noana mako yatefe o'me'noki yakale'naya vaya hani yapi leke leke nehea atafi visaya vaya apa'ku apame ali'na katisoa yafe e'noe. ");
INSERT INTO ino_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Lapa'kaeya na'yane hutapa lapa'kesa ne'afe? Mako ve'kamo'a nayama'a kayo afu vani hataleti'a (100) afuyaka ate'niseapati mako'ke afu'a fanane hu'nisikeno'aena ani afumo afo'amo'a ani afue kahau akaifi o'akaiye? He mi'ko afuyaka'a avimate apate'neno ani mako'ke fanane hu'nisea afu'aena uno kahau akaiye. ");
INSERT INTO ino_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nakaeya lamake lahapa'nepauve ani ve'kamo'a ani fanane hu'nea afu'a kahau ano akeno fole aiseana fanane ohu'a afa'a mai'naya afu anaka'amokife amuse nehea amusena akaseno mako'ae lusi amuse huke. ");
INSERT INTO ino_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ani kava huno ko'ku'na kumate mai'nea Afotapimo'a nakaeyafe afi'a apaipafi male'naya mafa'ne anakapati mako'ke'a yakalesea yafe alaki lamake huno nohaiye. ");
INSERT INTO ino_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mako nepu kasaki kakaeya yate atalave ali'nisike'kaena lana'kaitotanike mai'netana “Ina akufa kava hana kava hao'otake kava hananaki atalo.” hu'ka hapaiyo. Hapaisanakeno ani ke afiteno ani au'ava kava atalesike'kaena “Nepu nasa'ni ako ete'na avaloe.” hu'ka hukane. ");
INSERT INTO ino_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Inaki kakaeya ke ani ve'kamo'a o'afisike'kaena aolefi aole'ae mako'ae vayapi apavalete'ka ani ve'kale uvo. Visanake'a ani apavale'ka visana aolefi aole'ae mako'ae vaya'moki'ae kaha'ma'a ake'ne'a hukate'nea kava hu'a fole ai'a hu'a fa'ko hu'a ani ve'ka aumomo malekae. ");
INSERT INTO ino_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aumomo malesaya ke o'afisike'kaena u'ka Anumaya Koti ke ne'afisaya vaya ali'a atalu hu'a ne'maisaya nopi avale'ka uke'a akesa ne'ali'a aumomo maleo. Aumomo malesaya ke o'afisike'kaena kakaeya make hu'ka huto “Atalave kava hana yafe lakaeya'ae e'ka lo'ka'ka o'mai'ka kaote u'ka Yisasi ke o'afi vaya'ae vaya apa'kufaleti kumaya'ya hu'a ta'kesi miya ne'alea vaya'ae u'ka lo'ka'ka maiyo.” hu'ka hapaiyo. ");
INSERT INTO ino_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ani ke hutesayana nakaeya lamake lahapa'nepauve mopale mai'netapa “Ma ya atafa hutapa alaki heo.” hisayana Anumaya Koti'ae ani kava huno ko'ku'napi mai'neanakeno ani hu'naya ya “Atafa hutapa alaki heo.” huno lo'kiya ke huke. Inaki mopale mai'netapa “Ma ya ataleo.” hutapa hisayana Anumaya Koti'ae ani kava huno ko'ku'napi mai'neanakeno ani hu'naya yafe “Afa'a ataleo.” huno lo'kiya ke huke. ");
INSERT INTO ino_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Inaki mako'ae mako ke lahapapaikoe mako aole ve'kala'mokani mako ya alikefe mako'ke anaipale mai'ne'ana ani yafe Anumaya Kotiteka afikesa'ana ko'ku'napi mai'nea Afo'nimo'a anamike. ");
INSERT INTO ino_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","He aolefi aole'ae mako'ae vayapi nakaeyafe afi'a naki ali'a asaka hukefe mako kumate ali'a anupa hu'a mai'nisake'na nakaeya ani folaka'apifi mai'nekauve hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita'a Yisasite eno inake he “Anumayamoka na'maki afina nafu'nakana'a hao'otake kava hunatesike'naena ani hao'otake kava hunate'nea kavafe kahaove katove nehu'na naipa falu yapati ali'na ataletesoe? Mako naya hano huteno mako nayatekati aole alisea afina hao'otake kava hunatesike'naena kahaove katove nehu'na naipa falu yapati ali'na ataletesufe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Afikekeno Yisasi'a inake huno hapaiye “Kakaeyafe mako naya hano huteno mako nayatekati aole uno alea afina ani kava ho hu'na nohoa'maki nakaeya inake hoe lakesa afiketa atalona avamete hao'otake kava hukatesike'kaena ani kava hu'ka lakesa afiketa atalona avamete kahaove katove nehu'ka kaipa falu yapati ali'ka ataleto hu'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Anumaya Kotika kava yakailato.” hu'a nehaya vaya'moki ma akufa kava nehae. Mako kumate kava yakai'nea ve'kamo'a akai'a ali'ya vayafe inake he “Yo'ka lapami'noa miya'ni etetapa mi'ko nameo.” ");
INSERT INTO ino_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huteno alino avatati hukefe nehuno mako ve'ka avalekeno eteno amisea miya'a o'afunama'a moni mako ve'kamo ayatala hano huteno aiya mako kaya'a hano hea kafu (15 kafu) ali'ya ne'alino miya alino ne'nea avamete miya eteno amisea miya hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hane'nea'maki amute o'male ve'kakeno ala kava yakai'nea ve'kamo'a inake he “Kakai'ka'ae a'ne mafa'ne'ka'ae afenoya'ka'ae alu ve'kamo'a miya hutesike'ka miya'nile ete'ka namikane.” ");
INSERT INTO ino_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nehikeno ani ali'ya ve'kamo'a kava ve'kamo aiyafi ape hu'neno make huno hapaiye “Ina kava ohu'ka kahau hunatete'ka vase hu'ka nakeva mai'neke'nao. Nakaeya henaka'a mi'ko nami'nana miya'ka ete'na kamikoe.” ");
INSERT INTO ino_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nehikeno ala kava ve'kamo'a ali'ya ve'ka'a lusiya huno hau huteteno ete'ka namikane hu'nea ya ne'ataleno kahauve katove nehuno aipa falu yapati alino atalete'ne. ");
INSERT INTO ino_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ako alino atalete'nea'maki ani ali'ya ve'ka hatilavino kumateka lavino akeana ali'ya lo'ka'ana ne'ali'a ve'ka aketeno ani ve'ka mako afina akaeyafe inake he “Mako'ke Sotapi ali'ya alineke'a miya ne'kamea akufa miya yo'ka nameo.” huno hikeno ami'nea'maki eteno o'ami'ne. O'ami'nea yafe ani kava ve'kamo'a hau hute'nea ve'kamo'a afalu'amo ake'yafi atafa nehuno make he “Kakaeya yo'ka kami'noa miya ete'ka mi'koma'a'ni makale nameo.” ");
INSERT INTO ino_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nehikeno ali'ya lo'ka'ana ne'ali'a ve'kamo'a ape hu'neno inake he “Ina kava ohu'ka atalo. Afa'a kahau hunate'ka kaipa falu hu'ka nakeva mai'neke'na henaka'a ete'na kamikoe.” ");
INSERT INTO ino_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nehikeno ani ve'kamo'a inake he “He'e ina akufa ke no'nahaiye. Nofi nopi hukate'nisuke'ka mai'ne'ka ete'ka namisanake'na ani nofi nopati atale'ka uvo hu'na hukatekaove.” ");
INSERT INTO ino_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nehike'a mako lo'ka'a ali'ya ne'alea vaya'moki ani kava hea ya akete'a apaipa haviya nehike'a kava ve'kale u'a mi'ko hu'nea kava hu'a fole aine'atae. ");
INSERT INTO ino_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hu'a fole aine'atakeno ala kava ve'kamo'a aipa falu hute'nea ali'ya ve'kae ke hikeno akaeyate ekeno make huno hapaiye “Kakaeya lusi havi ali'ya ve'ka mai'nane. Hokote'ka nakaeyafe e'ka avi lanake'na mako yo'ka kami'noa miya ete'ka o'naminake'na kahaove katove nehu'na naipa falu yapati ali'na atalekate'noe. ");
INSERT INTO ino_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nakaeya kakaeyafe nahau hukate'noa'maki na'ya hike'ka lo'katana ali'ya ne'ali'a ve'kae kahau hu'ka no'atane?” ");
INSERT INTO ino_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huteno ala kava ve'kamo'a lusi hai vaiteno nofi nopi avaleno uno kayo amisaya vaya'moki apayapi atekeno lusi akafu ya ali'ne. Ala kava ve'kamo'a inake huno hapapai'ne “Henaka'a mi'ko yo'ka ami'noa miya'ni eteno namitesiketapa atalekeno vino.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisasi'a inake huno hapapai'ne “Lapa'kaeya lapafutapa'kanaki atalave kava hulapatesaketapaena ameka lapaipaleti ohutapa lamake hutapa atalave ya'ape lahapaone lapatone nehutapa lapaipa falu yapati alita atale o'apatesayana ko'ku'napi mai'nea afo'nimo'a ani kava huno lapa'kaeya'ae nofi hute'naya kava huno nofi hulapatekaiye.” ");
INSERT INTO ino_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisasi'a mi'ko mani ke huno hano huteno Kalili ko ataleno Yotani li'mo mekakaya aupalika uno Yutia koteka ukefe u'ne. ");
INSERT INTO ino_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ne'vike'a mi'ko vaya'moki hafai'a Yisasi a'kame vakeno ani aupalika kali'api alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kanale hune'apateke'a mako Falasi mono ke ne'afea vaya'moki Yisasite e'a hao'otake ke hisea'aene hu'a a'a avataka nehu'a inake hu'a afine'kae “Mako ve'kamo'a a'a ataleseana ke male male'nea ke alino atakaesifi afa'a kanale huke?” hu'a afike'nae. ");
INSERT INTO ino_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Afine'kakeno Yisasi'a anona'a ke'apile inake he “Lapa'kaeya Anumaya Koti avopi hapalitapa o'ake'nafe inake hu'a kamale'nayane ‘Anumaya Koti'a hae afina aepa heno ve'ae a'ae alo humale'neane.’ huno hu'neane. Mako ke inake hu'a kamale'nayane ‘Ve'ae a'ae alo humale'nea yafe mako ve'kamo'a ita afo'amokani anataleno a'amo'ae aino lo'kakaiye. Ai'ana lo'kaesa'ana ani aolemokani ana'kufamo'a mako'ke'ake alino hapakaiye.’ huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ina kava hinakeno mako'ae aole kanola o'maika'a'maki meni mako'ke ana'kufa hapaeke'ana mai'na'anakeno ani yafe Anumaya Koti'a ana'kaeya ako alino hapainate'neanakeno mako mopale kanomo'a ani alavela mai ya'ani alino atane o'anatese.” ");
INSERT INTO ino_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nehike'a Falasi mono ke ne'afea vaya'moki Yisasife inake hu'a afine'kae “Na ya hikeno Mosese'a mako ke male male'nea kefi inake huno lahapai'ne ‘Vemo'a a'a avo kano ne'amino hutesikeno hano huke.’ huno hu'neane?” ");
INSERT INTO ino_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nehakeno Yisasi'a inake huno hapapai'ne “A'ke'ainaka ma mopa alo hu'nea afina mani kava ohane'nea'maki lapa'kaeya ke o'afitapa vekano'kano haya yafe Mosese'a a'ne apatalesaya ke kamale'ne. ");
INSERT INTO ino_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nakaeya inake hu'na lahapa'nepauve mako ve'kamo a'mo'a kumai ohe'nisikeno anau'amo'a ataleno alu a aliseana ani ve'kamo'a kumai kava hu'ne.” ");
INSERT INTO ino_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hike'a akaeya ke ne'afea anaka'moki Yisasife inake hae “Alave lo'ka'a mai au'ava yana lusi lo'kiya ke hane'nea'maki ana o'alita afa'a me'ku'ake maisune.” ");
INSERT INTO ino_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nehakeno Yisasi'a inake huno hapapai'ne “Ani haya ke lamake nehaya'maki mi'ko vemoki a o'alisaya lo'kiya'api o'male'nea'maki Anumaya Koti'a a o'alisaya lo'kiya apami'nea vaya'moki ani kava hu'a a o'alikae. ");
INSERT INTO ino_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mako vaya'moki a alikaya'maki mako vaya'moki a alisaya lo'kiya'api o'male'ne. Ani vayapati mako vaya'a ita'apimoki alipataya afina ve kahauma a kahauma mai'naya yafe a o'ali'nae. Ani kava hu'a mako vaya'aina apa'kayamo afaya'aitale'nisayana a o'alikae. Mako vaya'moki ‘Anumaya Koti'a kava yakainatesike'na akaeya ali'ya ali'na Yisasi ke hapapaisoa yafe a o'alikoe.’ hu'a hu'nae. ‘Ani ke afi'na a'kame malesoa lo'kiya'ni hane'ne.’ huno hisea ve'kamo'a ani kava hise.” ");
INSERT INTO ino_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Vaya'yakamoki mafa'ne'api Yisasi'a aya male ne'apateno Anumaya Kotiteka ke huno afikesea yafe apavale'a ne'ae. Apavale'a ne'ake'a akaeya ke ne'afea anaka'moki inake hae “Ina akufa kava oheo.” hu'a ke apama'ki'nae. ");
INSERT INTO ino_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ke ne'apama'kikeno Yisasi'a ani ya aketeno inake hu'ne “Afa'a ka o'a'kanitapa afa'a apataleke'a ani aise aise mafa'ne nakaeyate eo. ‘Inamu mafa'ne mai'none.’ hu'a ‘Lo'kiyati o'male'ne.’ hu'a nehaya vaya'mokike ‘Anumaya Kotife yakailato.’ hu'a nehaya vaya mai'nae.” ");
INSERT INTO ino_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ani ke huteno Yisasi'a mafa'ne'api aya apa'kufale malepateteno ani kuma ataleno aluleka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mako ala ve'ka lusi afeno'ya male'nea ve'kamo'a Yisasite eno inake he “Vae ali'ka apaya nehana Nenao nakaeya hana kanale kava hute'na maike maike hisoa navamu alikoe?” ");
INSERT INTO ino_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Afine'kekeno Yisasi'a akaeyafe inake he “Na ya hike'ka kanale kavafe nafike'nane? Mako'ke ve'ka Anumaya Koti'a kanale ve'ka mai'nea'maki maike maike hu'ka maisana kavamu alisu'kaena Akaeya ke male male'nea ke a'kame malo.” ");
INSERT INTO ino_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nehikeno Yisasife inake huno afine'ke “Hana akufa ke male male'nea ke nehane?” Nehikeno Yisasi'a inake he “Ke male male'nea kemo'a inake hu'ne kakaeya vaya hakeno ofalino. Kumai kava oho. Kumaya ya oho. Ma ve'ka hao'otake kava nehe hu'ka kake'atike ke fai'ka mako ve'ka ha'opaiyo. ");
INSERT INTO ino_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ita'kafo'kamokani ke kanale'ya hu'ka a'kame malo. Kakai'kae ne'kahaiya avamete male'ka alu vayafe kahaino.” ");
INSERT INTO ino_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hapaikeno ani lusi afeno male'nea nahaeya ve'kamo'a inake he “Vae ali'ka apaya nehana Nenao nakaeya mi'ko ani ke a'kame male'noa'maki nakaeya hana akufa kava'ae hisoa yafe nehane?” ");
INSERT INTO ino_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Hikeno Yisasi'a ani ve'kae inake huno hapai'ne “Kakaeya alaki alakepa ve'ka maisoe hu'kaena mako kava'ae hisanana ho'ka katesike'ka alakepa ve'ka maikane. Kakaeya u'ka mi'ko afeno ya'ka apamisanake'a miya faitesake'ka ani miya ali'ke'ka afeno'api o'male vaya fa'ko fa'ka hu'ka apameo. Ina kava hu'ka apamisanana Anumaya Koti ko'ku'na kumate mi'ko kanale'nale afeno katekaiki meni apamite'ka e'ka na'kame malo.” ");
INSERT INTO ino_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nehikeno ani ve'kamo'a ani ke afiteno lusi moni afeno male'neno o'atalesea yafe aipamo'a lusiya huno kana hikeno ataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Utekeno Yisasi'a akaeya ke ne'afea anaka'ae inake huno hapapai'ne “Lamake lahapa'nepauve lusi moni afeno male'naya vaya'moki lusiya hu'a kasake'ke ne'ai'a Anumaya Kotife kava yakailato hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mako ke'ae lahapapaisoe puluma'kakana afu aki'a kamoloe hu'a aki ne'aya afumo'a kena nefa'kanea ne'kayamo kapi faleno a'kayopa lavino viseana afa'a vakayo huno ukife? He'e faleno a'kayopa lavino o'vinine. Ani kava hu'a lusi moni afeno male'naya vaya'moki Anumaya Kotife ‘Kava yakailato.’ hu'a ke hu'a afike yafe lusiya hu'a kasake'ke ne'ai'a afino'kae.” ");
INSERT INTO ino_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nehike'a Yisasi ke ne'afea anaka'moki ani ke afite'a lusiya hu'a atali atalu hu'a halake'a ne'mai'a inake hu'nae “Ina kava hisike'aena nalaki'ke maike maike hisaya apavamu alikae?” ");
INSERT INTO ino_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nehakeno Yisasi'a aulu hapalitata nehuno make he “Vaya'moki apa'kai'api lo'kiya'api o'male'neanake'a ohukaiya'maki Anumaya Koti'a lo'kiya'a hane'neanakeno mi'ko ya afa'a alo huke.” ");
INSERT INTO ino_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hikeno Pita'a inake nehe “Akeko lakaeya mi'ko yati ataleteta ka'kame ne'onana lakaeya na ya alikune?” ");
INSERT INTO ino_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nehikeno Yisasi'a inake huno hapapai'ne “Lamake lahapa'nepauve mi'ko ya alino haekafa hisike'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ala naki hanesike'na kava ali'na yakaisoa yafe ano hale'nea fai mai yate fai maikoanaketapa ani kanafi nakaeya na'kame ne'malesaya vaya'mokitapa nayatala'a hano huteno naiyalekati aole alea (12) ala kava vaya fai ne'maiya yate nahaopa'ale fai mai'netapa Isaleli nofi vaya nayatala'a hano huteno naiyalekati aole alea nofi vaya'aite kava ya alitapa yakaikae. ");
INSERT INTO ino_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yakaikayanake'a mi'ko vaya'moki nakaeyafe afi'a apaipafi male'naya yafe apa'kesa afite'a no'api'ae nepu'apimoki'ae apasa'apimoki'ae ita afo'apimoki'ae mafa'ne'apimoki'ae mopa'api'ae atale'a visayana Anumaya Koti'a ani ya huno atale'naya no'api'ae nepu'apimoki'ae apasa'apimoki'ae ita afo'apimoki'ae mafa'ne'apimoki'ae mopa'api'ae atale'a nakaeya kele e'naya yafe atale'naya yate halate mako'ke hataleti mi'ko apamisuke'a maike maike hu apavamu'ae alikae. ");
INSERT INTO ino_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Meni kanafi ala vaya mai'naya vayana henaka'a aise vaya maisake'a meni kanafi aise vaya mai'naya vayana henaka'a u'a hokote'a ala vaya maikae.” ");
INSERT INTO ino_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anumaya Koti'a kava alino yakaipate'nea kava'amo'a ma kava hu'ne. Lusi mopa'a hane'nea ve'kamo'a vaini nofi alaka hoya'afi ali'ya vaya apavalekefe natepati u'ne. ");
INSERT INTO ino_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","U'neno ali'ya alisaya vayafe inake he “Hoya'nifi mako'ke afina ali'ya alisaya yatena mako'ke kina lapamite lapamite hukoe.” hike'a mi'ko'amoki “Kanalene.” hakeno hoya'afi hupateke'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Utakeno ani hoyamo afo'amo'a yake haineno naini kilo'ki nehikeno vaya ali'a atalu hu'a ne'maiya kumate uno akeana mako fate vaya ali'ya o'ali'a afa'a heti'a mai'nakeno apa'ke'ne. ");
INSERT INTO ino_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Apa'keteno ani vaya'aife “Hoya'nifi utapa ali'ya alisake'na kanale hu'na miya lapamikoe.” hike'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Utakeno yake haineno folaka nalakate maite lavino unetino tali kilo'ki huke hea kanale'ae ani kava huno mako'ae ali'ya vaya apavaleke'a hoya'afi u'nae. ");
INSERT INTO ino_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Utakeno ani kava huno yake lavino nefalekeno uno mako vaya apa'keteno inake he “Ma vayana hana ya hutapa ali'ya kanamaki afa'a felu mai'nakeno unetino hani kisea kava nehe?” ");
INSERT INTO ino_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nehike'a ani vaya'moki inake hu'a hapai'nae “Mako ve'kamo'a ‘Ma ali'ya aleo.’ huno huolate'niketae afa'a mai'none.” hu'a hakeno “Kanalenaki lapa'kaeya'ae utapa nakaeya hoyafi ali'ya aleo.” huno hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Une velo amakike'a nofi alaka hoyamo afo'amo'a ali'ya kava ve'ka'aena inake huno hapai'ne “Mi'ko ali'ya vaya'aife ke huke'a esake'ka miya'api apameo. Aepa he'ka henaka e'a ali'ya ali'naya vayatekati apamime u'ka natepati hokote'a e'a ali'ya ali'naya vayana henaka'a apameo.” ");
INSERT INTO ino_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hikeno une faefu kilo'ki aepa he'a ali'ya ali'naya vaya akeno vani kina apamite apamite hu'nike'a ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Alitake'a ali'ya natepati aepa he'a ali'naya vaya'moki “Ako ala moni alikune.” hu'a apa'kesa afi'naya'maki mi'koma'a alaki vani kina vani kina'ake apami'ne. ");
INSERT INTO ino_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Apamike'a alite'a ani hoyamo afo'amofe lusi ke ne'ama'ki'a inake hae “Lakaeya natepati eta alaka ali'ya ne'alunakeno yakemo'a laleno lasakali'neanakeno miya mako'ae ala huno laminina'maki hana ya huno'ae hae une'ato mako'ke aova'ake e'a ali'ya ali'naya vaya'ae mako'ke avamete ne'alune?” ");
INSERT INTO ino_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hu'naya'maki ani hoyamo afo'amo'a hetino ani vaya'ai folakapi mako ve'kae inake he “Vae vaya'nimoka afeo. Nakaeya kumaya'ya hu'na kaipa ali'na haviya ohu'noe. Nate'mo ‘Vani kinale kanale mako'ke afina ali'ya alikape.’ huke'kae'mo ‘Kanalene.’ ohu'ne'kae ani ke nehape? ");
INSERT INTO ino_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hai anima'a alite'ka no'kaleka uvo. Hokote ali'ya vaya'ni apamoa avamete henaka ali'ya vaya'ni'ae mako'ke kava hu'na nakai'ni yanake'na hai lapami'noe. ");
INSERT INTO ino_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ani miya nakai'ni ya hane'ne. Nakai'ni moni'nileti hoa kavafe oho hutapa nehafe? Nakaeya vaya kai'na'kai kava nehoa'maki na kava hike'ka kaipa afi'ka haviya hune'natane?” ");
INSERT INTO ino_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ani akufa avamete henaka vaya'moki hokotesake'a hokote vaya'moki henaka ekae. Meni afina ala vaya mai'naya vaya'moki henaka'a aise vaya maisake'a meni afina aise vaya mai'naya vaya'moki henaka'a u'a hokotekae huno hu'nea avoya ke Yisasi'a hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Mi'ko vaya Yelusalemu nehaikeno Yisasi'a aiyalekati aole alea anaka'ae akai'a'ae apaote lo'ka'a kateka ne'u'a inake huno hapapai'ne “Afeo meni Yelusalemu haisunake'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka natafa hu'a navale'a mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ai apayapi'ae natekae. Natesake'a kake hunatete'a nahaesake'na falisoa ke hu'a hayakae. ");
INSERT INTO ino_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ke hu'a hayate'a navale'a Isaleli nofi o'mai vaya'ai apayapi natesake'a hu'a haviya hune'nate'a aufe nofi kayoteti sefu namakite'a yofo yosale nasaimale'ne'a nahaesake'na falikoe. Falitesuke'a kelifi kinate'nisake'na aole kana kelifi mai'nisoapati kotiseama'a Anumaya Koti'a eteno alino hetinatekaiye.” ");
INSERT INTO ino_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ani afina Sepeti a'a'ae mafa'nela'a'ae Yisasite e'a ita'animo'a Yisasi aiyafi ale'ya lo'a'neno mako yafe afikekefe nehe. ");
INSERT INTO ino_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Afikekefe nehikeno Yisasi'a ani afe inake he “Kakaeya na ya hunato hu'kae nehane?” huno hikeno ani a'mo'a inake he “Kakaeya kava ali'ka yakaisana kumate u'ka mai'ne'ka ke huke'ana aole mafa'nela'nimokani mako'mo'a kaya lamaka maisikeno mako'mo'a kaya haoka maise.” ");
INSERT INTO ino_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huno afi ne'kekeno Yisasi'a inake he “Lapa'kaeya nafine'kaya ya afitapa ha ole'nae. Falisoa ya atu'ake nehea li'kana nehea'maki ani li hane'nea kepati nakaeya nekefe nehuki lana'kaeya'ae kanale ani li neka'afe?” huno anafikeke'ana “Afa'a nekau'ae.” neha'ae. ");
INSERT INTO ino_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Neha'akeno Yisasi'a ana'kaeyafe make huno hanapai'ne “He nakaeya nesoa kepati li neka'a'maki ala vaya ne'maiya yana naya lamaka'ae haoka'ae maisa'a ve'kalana nakaeya ya o'male'niki Anumaya Koti'a akai'a yanakeno ani naya lamaka'ni'ae haoka'ni'ae maisaya vaya apa'keteno ako alino avatati huteno alino kanale hupate'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nehike'a laya aole hano hea anaka'moki ani ke afite'a ani konakala'anife apaipa afi'a haviya hune'anatae. ");
INSERT INTO ino_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Afi'a haviya hune'anatakeno Yisasi'a apa'kaeyafe ke hike'a akaeyate akeno inake huno hapapai'ne “Mopale ala kava vaya'moki ‘Lakaeya ako ala kava vaya mai'none.’ hute'a Isaleli nofi o'mai vayafe ke ne'apama'ki'a lo'kiya ali'ya ke hune'apatake'a ke'api afi'a a'kame ne'malae. ");
INSERT INTO ino_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ina kava nehaya'maki lapa'kaeya folakapi ina akufa kava o'malesikeno mako ve'ka ‘Nakaeya kava ve'katapi maikefe nehoe.’ hisea ve'kamo'a mi'ko vaya'ai kayo kayo ve'ka maise. ");
INSERT INTO ino_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Inaki ‘Nakaeya hokote kava ve'katapi maisoe.’ hisea ve'ka afa'a miya o'ali ali'ya ve'katapi maise. ");
INSERT INTO ino_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka vaya'moki naya hu'a kanale naha'maesaya yafe o'me'noa'maki nakaeya vaya apaya hu'na ali'ya ve'ka'api maisoa yafe e'noe. E'ne'na nesu ve a'ne hao'otake ya'apimo'a nofi kipate'nea yapati kalu he'na apavalesoa miya hepatesoa yafe nakai'ni falikefe e'noe.” ");
INSERT INTO ino_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisasi'a akaeya ke ne'afea anaka'ae Yeli'ko kuma atale'a ne'vake'a lusi vaya'moki Yisasi a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A'kame ne'vake'a aole anaulaka apo ka'nea ve'kala kate mai'na'ake'a “Yisasi'a lana'kaseno ne've.” haya ke afite'ana inake hu'ana ke neha'ae “Teviti akeho'amoka amuse'ka nehu'aki la'akaeya kalaki aila'ato.” hu'ana ka ne'a'ae. ");
INSERT INTO ino_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka ne'a'ake'a vaya'yakamoki ke ne'anama'ki'a inake hae “Ke ohutana lanavaya atana a'kanilitana mai'ao.” hu'a lo'kiya kefati hanau'naya'maki mako'ae ani ke neha'ae “Anumayamoka Teviti akeho'amoka amuse'ka nehu'aki la'akaeya kalaki aila'ato.” ");
INSERT INTO ino_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Neha'a ke Yisasi'a afiteno anile heti'neno inake he “Nakaeya na kava hulanatesoa yafe nelahanaiye?” ");
INSERT INTO ino_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hike'ana ani netala'mokani inake ha'ae “Anumayamoka amuse'ka nehu'aki la'aulakati'a ali'ka kanale hula'atesanaketa'a aketa'a halai hisu'ae huta'ae nehu'ae.” ");
INSERT INTO ino_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Neha'akeno Yisasi'a ani netala hau hunateteno anaulakale aya ne'malekeno makale ani anaulaka halai hike'ana akete'ana Yisasi a'kame u'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Yelusalemu kumate ukefe Petafasi ne'u'a Yelusalemu haute hane'nike'a ake'nae. Petafasi kuma Olivi yosa'ake hane'nea avima'mo aki'nale hane'ne. Anile mai'ne'a Yisasi'a aole akaeya ke ne'afi'a ve'kala hune'anateno inake huno hanapai'ne muka kumate ne'utana atupale note utana hosikana afu ita'amo'ae ana'au'a'ae ate'nayanaketana akeka'ae. Aketetana kalu hetana avaletana male e'ao. ");
INSERT INTO ino_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mako vaya'moki lanafikesaketanaena inake hutana hi'ao “La'akaeya kava ve'kamo'a mako ali'ya alikefe nehuno ‘Avaletana e'ao.’ hiketa'ae ne'avalo'ae.” hutana hapapaisa'ake'a “Afa'a avaletana vi'ao.” hulanatekae.” ");
INSERT INTO ino_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ani afina hu'naya kava'mo'a Anumaya Koti aune ve'kamo hu'nea ke ako fole aino ne'ya'a alitekeno lamake hu'ne. A'ke'ainaka make huno kamale'neane ");
INSERT INTO ino_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Yelusalemu vaya'aife inake heo “Meni lapa'kaeyate kava yakailapate'nea ve'ka akufa alino ohai ve'ka hosikana afumo akofetule fai mai'neno ekaiye. Hosikana afumo ana'au'amo akofetule fai maino ekaiye.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Akaeya ke ne'afi'a ve'kala'mokani u'ana Yisasi'a hanapai'nea ke hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ani hosikana afu ana'au'ae ita'amo'ae Yisasite avale'ana ete'ana ana'kufaleti yasi kena'ani asaki'ana ani afumo akofetule maleta'akeno Yisasi'a anile fai mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Fai mai'neno kate ne'vike'a mi'ko vaya'moki “Ala ve'ka ne'e.” hu'a mako'amoki apa'kufaleti kena'api asaki'a kate ne'ya'kaike'a mako'amoki yosa haita hane'nea a'kopayaka alo a'a kate ya'kaimale'nakeno e'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aukosaleka'ae a'kameleka'ae ne'vaya vaya'moki inake hu'a nehae “Ala ve'ka lakufa ali'ka katisana ve'ka kanale'ya hu'ka ne'ane. Teviti akeho'amoka kanale'ya hu'ka ne'ane. Anumayamo ali'ya alisanafe hukate'nea ve'ka Anumaya Koti kanale manu kamino kaya hu'ne. Hanafaka mai'nea Anumaya Koti lakufa alino katiseafe hukate'nea ve'kae amuse'a hisune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nehakeno Yisasi'a Yelusalemu kumapi nehaike'a mi'ko vaya'moki atalitalu nehu'a inake nehae “Vae mani ve'ka nala'a ne'e?” ");
INSERT INTO ino_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nehake'a anile atalu hu'naya vaya'moki inake hae “Yisasi'a Nasaleti kumateti ve'ka Kalili kotekati Anumayamo aune ve'ka ne'e.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yisasi'a ala mono nopi hai'neno mi'ko moni afeno male'a ne'alea vaya'ae anifati miya nehaya vaya'ae aepa heno hapafai ne'ataleno alu kotekati moni ali'e'a ne'atalake'a ani kote moni ete'a yahae hu'a ne'apamea vaya'ae hipa'api'ae mi'ko namayaka apate'a mai'nake'a miya nehaya fai mai ya'ae alaki alino ako'ya faitale'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yisasi'a inake he “Anumaya Koti avopi make hu'neane ‘Nakaeya nofe mi'ko vaya'moki Anumaya Kotiteka afikesaya no hane'ne.’ huno kamale'neane. Ani no hane'nea'maki lapa'kaeya mani nofe afitapa afa ya hutetapa afeno no maletapa kumaya vaya'moki no'kana nehiketapa kumaya kava nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yisasi'a ani mono nopi mai'nike'a mako apaulaka apo ka'nea vaya'ae apaiya haviya hu'nea vaya'ae akaeyate akeno alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Alino kanale hupate'nea'maki ala mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae e'a akayana Yisasi'a o'ake'naya avame lo'kiya ya nehike'a ne'ake'a afi'nayana mako mafa'nemoki ala mono nopi mai'ne'a Yisasife ala kefati inake hae “Teviti mafa'nemoka lakufa ali'ka katisanafe hukate'nea ve'ka mai'nananaketa lusi amuse'ka hisune.” hu'a haya ke afite'a ani vaya'moki apaipamo'a haviya hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Apaipa haviya nehike'a inake hae “Haya ke afi'nape?” hu'a afikakeno Yisasi'a inake he “He afi'noe. Lapa'kaeya ma ke hapalitapa afi'nafi o'afi'nae? Mani ke Anumaya Koti avo'mo'a inake hu'neane ‘Inamu mafa'ne'ae nu ne'nesaya mafa'ne'ae apavayafati kanale'ya hu'a Anumaya Koti aki ali'a asaka hukae.’ huno kamale'neane.” ");
INSERT INTO ino_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ina ke huteno apataleno Yelusalemuti ani hani'ainaka lavino mako aise kumate Petani hava'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Havate'a natepati Petani kuma atale'a halate ete'a Yelusalemu ukefe kateka ne'vakeno Yisasi'a aka nele. ");
INSERT INTO ino_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aka nelekeno ka aki'nale mako yosa ake'ne. Ani yosamo aki'a fiki. Yisasi'a aketeno uno ani yosa aepale heti'neno akeana alaka'a o'ano haitayaka'ake hane'nikeno Yisasi'a ani yosaena inake he “Kakaeya alaka'a o'a'nana yafe alaki mako'ae alaka'a o'akane. Alaka'a o'ae yosa heti'ka maikane.” huno nehikeno makale'a vai'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vai'nike'a Yisasi ke ne'afea anaka'moki akete'a lusi apamo'yo aite'a inake hae “Na ya hikeno ani fiki yosa makale'a ako vai'ne?” ");
INSERT INTO ino_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nehakeno Yisasi'a inake huno hapa'nepaiye “Lamake hu'na lahapa'nepauve lapa'kaeya ‘Anumaya Koti'a mi'ko ya afa'a alo huke.’ hutapa afitapa lapaipafi maletapa lo'kiya vai'netapa aole lapa'kesa o'afisayana fiki yosa hute'noa kava'ae mako kava'ae hukae. Ma avimafe ‘Kalafa lavi'ka ala li kotupi laveo.’ hutapa hapaisakeno'aena ani ke a'kame maleno lavike. ");
INSERT INTO ino_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ani yafe Anumaya Kotiteka afikesayana ‘Anumaya Koti'a kanale huno afikesuna ya lamike.’ hutapa afitapa lapaipafi malesayana ani afikesaya ya lapamike.” ");
INSERT INTO ino_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisasi'a eteno ala mono nopi uno alino apaya nehike'a ani mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ani kumate ala ala vaya'ae akaeyate e'a inake hu'a afine'kae “Kakaeya hana akufa kaki hane'nea ve'kake'kae mani ali'ya ne'aline? Hana ve'kamo'a ‘Inani akufa ali'ya aleo.’ huno kahapaiteno lo'kiya kami'nike'ka mani ali'ya alime u'ke'ka nehane?” ");
INSERT INTO ino_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nehakeno Yisasi'a apa'kaeyafe inake he “Nakaeya'aeti mako ke lapafikesuketapa lapa'kaeya ani lapafikesoa kemo aepa'a nahapaisake'naena nakaeya'ae ani ali'ya ne'aloa lo'kiyamo aepa'a lahapapaikoe. ");
INSERT INTO ino_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Inake hu'na lapafine'koe Yoni'a li fale nelapatea yana Anumaya Koti'a ko'ku'napakati lapami'nea yapi vayatafa'moki lapami'naya yane? Ani yafe hutapa fole aitapa nahapaiyo.” Hike'a apa'kai'api sume ke hu'a mikafi mafi nehu'a inake hae “Anumaya Koti'a ko'ku'napakati lami'nea yane huta hisunana halate lakaeyafe na'ya hiketapa afitapa lapaipafi o'male'nae huno huke. ");
INSERT INTO ino_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","27","Hukea'maki mi'ko vaya'moki ‘Yonife Anumaya Koti aune ve'ka mai'ne.’ hu'a hu'naya yafe ‘Lakaeya vaya'moki hute'naya ve'ka mai'ne.’ huta hisunake'aena ani vaya'moki ke lama'kikae.” hu'a apa'kesa afite'a ani vaya'aife koli nehu'a Yisasife inake hae “Nala'a hute'nifi? Lakaeya o'afi'nonanaketa huta fole aita kaha'opaikaune.” hu'a hakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya naha'opaisayana nakaeya'ae ani kava hu'na ali'ya ne'aloa lo'kiyamo aepa'a lahapa'opaikoe.” ");
INSERT INTO ino_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na lapa'kesa ne'afe? Mako ve'kamo'a aole mafa'ne'ala mai'na'akeno afo'a'nimo'a uno hokote mafa'ne'aena inake he “Mafa'ne'nimoka meni afina u'ka nofi alaka hoyafi ali'ya aleo.” ");
INSERT INTO ino_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ali'ya aleo.” huno ha'nepaikeno mafa'ne'amo'a inake he “O'ukoe.” huteno'ae'maki henaka'a aipa aino yahae huteno uno ali'ya ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Afo'animo'a uno henaka mafa'ne'ae ani ke huno ha'nepaikeno inake he “Nakaeya u'na alikoe.” huteno'ae'maki o'u'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Hana mafa'nemo'a afo'amo ke a'kame male'ne?” huno apafikeke'a “Hokote mafa'ne'amo'ae.” hakeno Yisasi'a apa'kaeyafe inake he “Lamake hu'na lahapa'nepauve kumaya'ya nehu'a vaya apa'kufaleti ta'kesi miya ne'alea vaya'ae kumai kava hulitata nehaya a'ne'ae lapa'kase'a hokote'a Anumaya Kotife ‘Kava yakailato.’ hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoni'a va'yi hu'neno alakepa hutapa maisaya ka lapaveliketapa lapa'kaeya akaeya ke afitapa lapaipafi o'male'naya'maki kumaya'ya nehu'a vaya apa'kufaleti ta'kesi miya alilitata nehaya vaya'ae kumai kava hulitata nehaya a'ne'ae akaeya ke afi'a apaipafi male'nae. Apaipafi male'naya'maki lapa'kaeya ani haya kava ake'naya'maki lapaipa aitapa yahae ohutapa hao'otake yatapi o'ataletapa akaeya ke afitapa lapaipafi o'male'nae.” ");
INSERT INTO ino_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yisasi'a inake he mako avoya ke afeo. Mako ve'kamo'a nofi alaka hoya vaimaleteno keki'ya huno veko humaleteno ani hoya vekofi nofi alakayaka alaki'e'a havaitemale'ne'a apaiyaleti a'a latikeno lima'a lavisea keli'ae kafimaleteno hoyale yakaino maisea ve'kamo nona kino asaka huno kimale'ne. Kimaleteno no'apa'kea vaya'aife “Etapa hoya'nile yakaitapa maiyo. Ani nofi alakafati fa'ko fa'ka hutapa mako aleo.” huteno mako alu koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Henaka'a nofi alaka afu nelesifi kanale hoyamo afo'amo'a ali'ya vaya'a hoya'ale ne'yakaiya vaya'aiteka hune'apateno inake hu'ne “Ne'ya mako alitapa eo.” huno hupateke'a ani hoyaleka u'nae. ");
INSERT INTO ino_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","U'nake'a ani hoyafi ali'ya vaya'moki kayo ali'e'a ani hupateke'a e'naya ali'ya vaya'aipati mako ve'ka ne'amaki'a mako ve'ka amaki'a kine'ate'a mako ve'ka yafa kayoteti amaki'nae. ");
INSERT INTO ino_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hapatakeno hoyamo afo'amo'a hokoteno aise'a hupate'nea'maki meni mako'ae nesu ali'ya vaya hupate'nea'maki hoyale kava vaya'moki ani kava'ke hupate'nae. ");
INSERT INTO ino_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ani kava'ke hakeno hoyamo afo'amo'a mafa'ne'a hutekefe nehuno inake he “Nakai'ni mafa'ne'ni hutesukeno viseana hoyafi ali'ya vaya'moki nakai'ni mafa'nemo keke'a afikae.” huno akesa afiteno mafa'ne'a hutekeno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","U'nea'maki ani hoyafi ali'ya vaya'moki make hu'a hu'nae “Ma mafa'nemo'a ani hoyamo afo'amo mafa'ne henaka'a mi'ko afo'amo ya alikeanaketa ako haeketao. Haesunakeno falisiketa mani hoya'ae mi'ko ya'ae lakaiti ya hamalekaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hute'a ani mafa'ne atafa hute'a ani hoyafati ma'aileka avale'a yaka hutale'ne'a hakeno fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ani kava hu'naya yafe lapa'kaeya na lapa'kesa ne'afe? Henaka'a ani hoyamo afo'amo'a esea afina ani hoyafi ali'ya vaya'aina na akufa kava hupatekaiye? ");
INSERT INTO ino_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yisasi'a ina ke hike'a apa'kaeya inake hae “Hao'otake ali'ya vayanakeno hoyamo afo'amo'a esea afina alaki lesate hapaesike'a falitesakeno ani nofi alaka hoya alino mako vaya apamisike'a ali'ya ne'alisakeno ne'ya afulesea afina ne'ya kanale'ya hu'a fa'ko fa'ka hu'a amisaya vaya'aife ‘Etapa ani hoyale kava yakaiyo.’ huno huke.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nehakeno Yisasi'a inake he “Lapa'kaeya mani Anumayamo avopi hane'nea ke hapalitapa ake'nafi o'ake'nae? Ani kemo'a make hu'neane ‘Vaya'moki yafa no ne'kea'maki mako yafafe haviya he hute'a ne'atalaya'maki ani yafa'mo'a henaka'a mi'ko yafa apa'kase'nea yafana atakonale ne'malaya yafa hane'ne. Anumayamo'a akai'a ani ya alino fole aiketa ake'nonana kanale ya nehe huta nehune.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Kamale'nea'maki ani yafe lahapa'nepauve ani yafa akofetule asaka hulavisaya vaya ai'api aino latino aise aise humalekaiye. Inaki ani yafa aino ha'kailavino mako ve'ka amakiseana alaki akola amakino mi'ko akufa aino atalaka atalako hutalekaiye. Inaki Anumaya Koti kava yakaisea ya'a lapamiketapa ali'naya ya alakepa hutapa a'kame o'malesayana lapa'kaeyapati lahapafaleno mako kanale'ya hu'a a'kame male'ne'a ne'ya ali'a fole aisaya vaya apamike.” ");
INSERT INTO ino_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hike'a mono nopi kava vaya'ae Falasi mono ke ne'afea vaya'ae ani ke afite'a “Lakaeyafe ani avoya ke nehe.” hu'a afi'nae. ");
INSERT INTO ino_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Afite'a Yisasina atafa hu'a nofi hutekefe hu'naya'maki mi'ko vaya'moki Yisasife Anumayamo “Aune ve'ka mai'ne.” hu'a nehaya yafe apaulaka koli hute'a atale'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Yisasi'a mako'ae mi'ko vaya'aife avoya ke inake hu'ne Anumaya Koti'a kava yakailapatesea kava'mo'a ina kava hu'ne. Mako ala yahauve ve'kamo'a akai'a mafa'ne a alikefe hikeno afo'amo'a ala ne'ya ka'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akai'a ali'ya vaya hune'apateno inake he “Ke hu'noa vaya'aife utapa ke hisake'a mafa'ne'nimo'a a alisea ne'ya e'a nesae.” huno hupateke'a u'a ke haya'maki ani vaya'moki ani ne'yate o'mesaya apaipa kali'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ani kava hu'naya'maki eteno mako'ae alu ali'ya vaya'a hune'apateno inake huno hapapai'ne “Lapa'kaeya utapa ke hu'noa vayafe inake hutapa hapapaiyo ‘Lapa'kaeya afeo nakaeya ako ve puluma'ka afaya'ake afu'ni ako hete'na mako ya'ae ako ali'na avatati humale'noanaki lapa'kaeya a ali ne'yate eo hu'ne.’ hutapa hapapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","Nehike'a ani ali'ya vaya'moki u'a ani ke hapapai'naya'maki ani vaya'moki ne'afi'a no'afi'a nehu'a atale'a ute ete hu'nae. Makoma'a hoya'apileka ne'vake'a makoma'a afeno no'apileka ne'vake'a makoma'amoki ani hupate'nea ali'ya vaya apatafa hu'a ali'a haviya hune'apate'a hapake'a fali'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ina kava hutakeno ani ala yahauve ve'kamo'a ali'ya vaya'a hapaya yafe aipamo'a haviya hikeno akai'a ati vaya hupateke'a u'a hapa'a hano hutalete'a no kuma'api ata avekave hutale'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ina kava hutakeno ala kava ve'kamo'a ali'ya vaya'aena inake huno hapapai'ne “A ali ne'ya ako ali'na avatati humale'noa'maki eo hu'na ke hu'noa vaya apa'kai'api haya kava'mo'a o'apateanake'a o'mekae. ");
INSERT INTO ino_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","O'mekaya'maki lapa'kaeya utapa mi'ko ala ka atakunele utapa apa'kesaya vaya ke hike'a a ali ne'yate eo.” ");
INSERT INTO ino_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hike'a ali'ya vaya'a ani kate ute ete nehu'a haviya hu'naya vaya'ae kanale vaya'ae ali'a atalu hake'a mi'ko ala kava ve'kamo mafa'nemo a ali'nea ne'yate e'a ani nopi hai'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Hai'a havaitetakeno ala yahauve ve'kamo'a apa'kekefe ani nopi haino akeana mako ve'kamo'a a ali afina nehavaiya akufa kena ohavai'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aketeno ala ve'kamo'a inake huno hapai'ne “Vaya'nimoka na'ya hike'ka a ali afina nehavaiya kena ohavai'ka ma nopi e'nane?” huno afikekeno ani ve'kamo'a mako hisea ke o'male'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","O'malekeno ala ve'kamo'a akai'a ali'ya vayafe inake huno hapapai'ne “Aiya ayate nofi kitetapa asaka hutapa hani kumapi avi nele'a apave'kemo'a nehisea hani kumapi yaka hutalekeno maise.” ");
INSERT INTO ino_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisasi'a inake he “Anumaya Koti'a mi'ko vaya'aife ke nehea'maki mi'ko vaya o'makeno Anumaya Koti'a mako'ke mako'ke apa'keno le'kanapai'nea vaya e'a nefalae.” ");
INSERT INTO ino_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falasi mono ke ne'afea vaya'moki u'a inake hae “Hana ya huta Yisasina akai'a hisea keleti atafa huta nofi hutesune?” nehu'a ke hu'a hayamale'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Falasi mono ke ne'afea vaya'ae Heloti ke ne'afea vaya'ae hupatake'a Yisasite u'ne'a make hae “Ali'ka apaya nehana Nenao lakaeya afunana kakaeya alaki alakepa ve'kake'ka alaki lamake ke'afati'ke mi'ko ve a'ne Anumaya Koti ke hapa'nepaine. Kakaeya alaki mako ve'kaena ala kakesa afi'ka no'amina'maki kava vaya'ae afa vaya'ae kakesa afi'ka ala vaya mai'nae hu'ka hu no'apatana'maki mi'ko vaya'aina mako'ke akufa ya'ake hune'apatane. ");
INSERT INTO ino_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ani kava hune'apatana yafe kakaeya na'yane kakesa ne'afine? Kanalenaketa ta'kesi moni Lomu kava ve'ka Sisana amisupi atalesune? Kakaeya lahapaiyo.” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Afine'kakeno a'a avataka hisaya apa'ku apa'kesa Yisasi'a ako afiteno apa'kaeyafe inake huno apafine'ke “Lapa'kaeya ameka lapaipaleti lapa'ke'atike'ake vayana lapa'kaeya etapa mafi na'mofe ake navatakauke nehae? ");
INSERT INTO ino_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mako ta'kesi moni ali'nafi naveleo.” hike'a ani ta'kesi moni ali'e'a aveli'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Avelikeno aketeno Yisasi'a inake huno apafine'ke “Mani monile nala ame'ae aki'ae hane'ne?” ");
INSERT INTO ino_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Hike'a “Sisa ame'ae aki'ae hane'ne.” hakeno Yisasi'a inake he “Sisa ya'a Sisana ne'amitapa Anumaya Koti ya'a Anumaya Kotina ameo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hapapaike'a kesi kava hu'a Yisasina hakefe haya'maki apamo'yo aiya ke hike'a haleke'a maite'a atale'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ani mako'ke afina Satiyusi mono ke ne'afea vaya'moki fali'naya vaya ete'a he'otikae hu'a nehaya vayanake'a Yisasite e'a inake hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ali'ka apaya nehana Nenao Mosese'a inake huno avopi kamale'ne ‘Mako ve'ka mafa'ne ali o'ate ve'ka falisikeno'aena akana'amo'a ani ve'kamo a aliteno fali'nea ve'kamo no alisea yafe ani a ali'neno mafa'ne alitese.’ huno kamale'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kamale'niketa ake'nona yafe mako ke kafikesune lakaeya folakapi seveni'a (7) konaka mai'nayapati yake ve'kamo'a a aliteno mai'nea'maki mafa'ne ali o'ate ve'ka ako fali'ne. Falitekeno akana'amo'a ani a ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aliteno mai'neapati mafa'ne ali o'ate ve'ka falita'ake'a ani konakayumoki mako'ke kava'ke hume vakeno henaka ve'ka'ae ani kava huno ani a ali'neno fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mi'ko ani konakayu falitakeno henaka'a ani a'ae fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ani seveni'a konakamoki (7 konaka) mako'ke a'ke alite'a falite falite hutakeno ani a'ae fali'neanake'a henaka'a mi'ko fali'naya vaya ete'a hetisaya afina ani ana hana ve'kamo a maike hutae nehunaki kakaeya lahapaiyo.” hu'a Yisasina afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Afine'kakeno Yisasi'a apa'kaeyafe make huno hapapai'ne “Lapa'kaeya Anumaya Koti avopi kamale'naya ke'ae Anumaya Koti lo'kiya'ae o'afi'netapae lapa'kaeya havikunaku ke nehae. ");
INSERT INTO ino_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nehaya'maki mi'ko vaya falinisayapati hetisayana ko'ku'napi kayo kayo vaya'kana hu'a maikayanake'a a'nemoki vele o'maisake'a vemoki a o'alikae. ");
INSERT INTO ino_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Fali'naya vaya ete'a hetikae hu'na hu'noa ke ete'na lapafikekefe hoe. Anumaya Koti'a lapa'kaeyafe hu'nea ke afi'nafi o'afi'nae? Ani ke make huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nakaeya Epalahamu'aki Aisa'ki'aki Ye'kopu'aki apa'kaeya Anumaya Koti'apimo'na mai'noe.’ huno hu'neane. Ani anaka fali'naya'maki ‘Apa'kaeya Anumaya Koti'api mai'noe.’ huno hu'nea kemo'a fali'naya vaya'ai Anumaya Koti'api o'mai'nea'maki ani vaya'moki apa'ku apame ofalino afa'a mai'nea yafe ani ke nehe. Lapa'kaeya ‘Fali'naya vaya he otikae.’ hutapa nehaya ke lapa'ke'atike nehae.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","“Ete'a hetikae.” huno hea ke mi'ko anile mai'naya vaya'moki afite'a lusi apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yisasi'a hea ke Satiyusi mono ke ne'afea vaya'moki ke ohu'a maiya yafe Falasi mono ke ne'afea vaya'moki afite'a Yisasite ali'a atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ali'a atalu hu'a mai'naya vaya'ai folakapati mako mono alino apaya nehea ve'kamo'a Yisasina ano avataka hu ke inake huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ali'ka apaya nehana Nenao ke male male'nea kefati hana kemo'a mi'ko ke male male'nea kemona apa'kaseno uno hokote'nea ke hane'ne?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Afikekeno Yisasi'a akaeyafe inake he “Anumaya Koti'kamofe kahau kayamopafati lo'kiya vaino kahaino. Mi'ko kakesa afi ya'ae kaipa kame afisana ya'ae Anumaya Koti ameo. ");
INSERT INTO ino_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inani kemo'ke ala huno apa'kase'nea ke hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ani'ale ke hokote kemo hu'nea kava huno mako'ke ya hu'na'ae. Inake hu'neane ‘Kakai'ka kakufae ne'kahaiya avamete mi'ko vaya'aife lusiya huno kahau kayamopafati kahaino.’ ");
INSERT INTO ino_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mani aole kemo'a mi'ko Anumaya Koti aune vaya'moki ke'ae Mosese hu'nea ke'ae aepa'ani mani aole kefi hane'ne.” ");
INSERT INTO ino_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Falasi mono ke ne'afea vaya ali'a atalu hu'nakeno Yisasi'a apa'kaeyafe inake huno apafine'ke “Kalaisife na lapa'kesa ne'afe? Nala mafa'ne mai'ne?” huno hike'a apa'kaeya “Teviti mafa'ne mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Nehakeno Yisasi inake he “Na kava hikeno Anumaya Koti'a Fate Akufa Avamu'amo'a Tevitina aku akesa amikeno Teviti avayafati ‘Anumaya'ni mai'nane.’ huno inake hu'neane ‘Anumaya Koti'a Anumaya'nimofe inake huno hu'ne kakaeya naya lamaka'a hokote vaya mai'nayateka e'ka faitopale mai'nisanake'na kame vaya'ka apavale'na kaiyafi apatesuke'a mai'ne'a kakaeyafe ako lakase'ka ala kava ne mai'nane hu'a hukae.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lapa'kaeya akekeo Teviti'a Kalaisife ‘Anumaya'ni mai'nane.’ huno hu'nea'maki na ya hikeno Teviti'a henaka alitesea akeho'amofe ‘Anumaya'ni mai'nane.’ huno hu'ne?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Apafine'keke'a ani vaya'moki ke anona'ale mako ke ohu'a ani afina aepa he'a koli hute'a mako yafe ke hu'a afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Yisasi'a ali'a atalu hu'naya vaya'ae akaeya ke ne'afea anaka'ae inake huno hapapai'ne mono hapali'a hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae Mosese ke ali'a lapaya nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ali'a lapaya hu'a lahapapai'naya ke a'kame malekaya'maki hao'otake ya nehaya kava lapa'kame'ya ameo. Apa'kaeya ala ke nehaya'maki apa'kai'api haya ke a'kame no'malae. ");
INSERT INTO ino_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vaya'aife “Ke male male'nea ke a'kame maleo.” hu'apa mi'ko vaya'moki apa'ki'nale kana ya ali'a kofipatake'a lusi kana ya ali'a ko nefe. Ko nefea'maki apa'kaeya mako afina mako apaya male'a ani kana ya'api ali'a hapa'no'make'a lusi kana ya ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mi'ko nehaya kava'api “Vaya'moki lakesae.” hute'a Anumayamo kamale'nea ke ala ke'kola alo hu'a apayapi ne'vai'a Anumayamo kamale'nea ke hane'nea asa hapanile male'nae. Kena'apile yatala konakali nofi male'a kine'malae. ");
INSERT INTO ino_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Emule'ae mono nopi'ae kava vaya'moki ne'maiya yate maisaya yafe lusiya huno nehapaiye. ");
INSERT INTO ino_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Apa'kaeya mi'ko vaya anupa hu kumate u'a ve a'nemoki hu'a falu fala hupatesaya yafe'ke nehapauno “Nakaeyafe inake hisae ‘Ala ve'ka mono ke ali'ka laya hu ve'ka'nimokae.’ hisae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nehaya'maki lapa'kaeyafe “Mono ke ali'ka apaya hu ve'kamokae.” ohisae. Lapa'kaeya mako'ke'ake mono alino lapaya hu ve'katapi mai'niki lapa'kaeya mako'ke avamete mai'netapa mako'ke konaka'ake maiyo. ");
INSERT INTO ino_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mopale mai'netapa mako mono alino lapaya hu ve'kae “Afotimokae.” oheo. Lapa'kaeya Afotapimo'a mako'ke'ake ko'ku'napi mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mako vaya'moki lapa'kaeyafe “Ala mono ali'ka laya hu ve'ka'nimokae.” hu'a oheo. Kalaisi'a akai'ake ala mono alino lapaya hu ve'katapi mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lapa'kaeyapi “Mako ala ve'ka maisoe.” hisea ve'kamo'a ali'ya ve'katapi maise. ");
INSERT INTO ino_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mako ve'kamo'a “Ala ve'ka mai'noe.” huno akai'a “Nakufa ali'na asaka hukoe.” huno hiseana Anumaya Koti'a “Afa ve'ka mai'nane.” huno hutekaiya'maki mako ve'kamo'a “Aise ve'ka mai'noe.” huno hiseana Anumaya Koti'a ani ve'kamo aki alino asaka huke. ");
INSERT INTO ino_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Avo'neo. Lapa'kaeya mono hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake vaya'mokitapa mi'ko Yisasi ke afi'naya'maki “Mako vaya'moki o'afisae.” hutetapa Anumaya Koti yakaisea kuma'mo kita kimale'netapa lapa'kaeya “Ani kumate ohaikune.” nehaya'maki mako vaya'moki “Ani kumate haikune.” hu'a nehaya'maki “He'e.” hutetapa ka a'kani ne'apatae. ");
INSERT INTO ino_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Avo'neo. Lapa'kaeya mono hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake nehaya vaya'mokitapa kaite a'ne'aife “Mono nopi atale moni nesu'yate lameo.” nehutapa no'apifi hane'nea ya'yaka kumaya'ya hakeno moni'api hano hike'a ani kumaya vaya'mokitapa ve a'ne atapa apavataka hutapa “Kanale ve'ka mai'nane.” hu'a hulatesaya yafe yatala kefati Anumaya Kotiteka ke hutapa afi ne'kae. Ani kava hu'naya vayana Anumaya Koti'a kake hulapatesea afina havi anona'a lusi lapa'kufa lapa'kafu kisea ya mako'ae ala'a alikae. ");
INSERT INTO ino_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Avo'neo. Lapa'kaeya mono hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake vaya'mokitapa lapa'kaeya maitapa halove hu'netapao. Lapa'kaeya hake li aki'naleka'ae mopafi'ae ute ete nehutapa mako'ke ve'ka Yuta vaya'ai mono ke afisea yafe mono ke alitapa aya nehaya'maki havi kava hutapa alitapa aya nehaya ya'mo'a havi kapi avaletapa ate'nayanakeno lapa'kaeya nehaya kava lapa'kaseno lusi hao'otake kava hu'nea yafe hani yapi ata leke leke nehea atafi lapa'kaeya'ae uke. ");
INSERT INTO ino_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lapa'kaeya lapaulaka apo ka'nea vaya mai'nayanaketapa a'a apavataka hisaya yafe vaya'aife “Ka lapavelikune.” hutapa nehaya vaya'mokitapa lapa'kaeya maitapa halove hu'netapao. Make hutapa nehae “Mako ve'kamo'a ala mono no'mo aki ne'ano ‘Lamake nehoe.’ hiseana afa ya'kana ke nehea'maki mako ve'kamo'a kolimoni yafateti alo humale ya'yaka ani mono nopi hane'nea ya'mo aki ne'ano ‘Lamake nehoe.’ hiseana ani ke hisea ve'kamo'a ani ‘Hukoe.’ huno hisea ke huno alakepa huno hise.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lapa'kaeya anekinaki nehutapa lapaulaka apo ka'nea vaya mai'nae. Na ya'mo'a ala ya hane'ne? Ani kolimoni yafateti alo humale ya'mo'a akaseno ala ya hane'nifi mono no'mo'a akaseno ala ya hane'ne? He'e ani kolimoni yafateti alo humale ya mono nopi hane'nea yafe fate akufa ya hane'ne. Lamake mono no'mo'a akaseno ala ya hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lapa'kaeya inake nehae “Mako ve'kamo'a mono nopi hane'nike'a afu he'a kakeno sala'mana ne'aiya hitamo aki ne'ano ‘Lamake nehoe.’ hiseana afa kekana nehea'maki mako ve'kamo'a Anumaya Kotina afu he'a amuse ya amikefe ani hitale male'naya ya'mo aki ne'ano ‘Lamake nehoe.’ hiseana ani ke hisea ve'kamo'a ‘Hukoe.’ huno hisea ke huno alakepa huno hise.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lapaulaka apo ka'nea vayana na ya'mo'a ala ya hane'ne? Anumaya Kotina afu he'a amuse ya amisaya ya ala ya hane'nifi amuse ya ne'malaya hipa ala ya hane'ne? He hipa'ke ala ya hane'ne. Ani afu hipale male'naya yafe fate akufa ya hane'ne. Ani kava nehea yafe ala ya hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mako ve'kamo'a hipamo aki ne'ano “Lamake nehoe.” hiseana ani ya'ae mi'ko ani hipamo akofetule hane'nea ya'aefe hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mako ve'kamo'a ala mono no'mo aki ne'ano “Lamake nehoe.” hiseana ani mono nofe'ae Anumaya Koti'a ani nopi mai'nea ve'kae hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mako ve'kamo'a ko'ku'na'mo aki ne'ano “Lamake nehoe.” hiseana Anumaya Koti kava yakaisea fai mai ya'ae ani yate faitopale mai'nea ve'kae hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Avo'neo. Lapa'kaeya mono ke hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake nehaya vaya mai'nayanaki maitapa halove hu'netapao. Lapa'kaeya atu'ae kife'ae mi'ko aki'ae aka'ae hakomupa'ae nayatala'a male'nayapati mako'ke'a Anumaya Kotiteka fa'ko hutapa ne'amea'maki lapa'kaeya Anumayamo ke male male'nea ke hokote kavana alakepa hutapa kake hupatesaya ya'ae vaya kalaki aitapa kayone hisaya ya'ae Anumaya Kotife afitapa lapapaifi malesaya ya'ko'ae ane'kasae. Hokotetapa ani alakepa kava hu'netapa atu'ae kife'ae nayatala'a male'nayapati mako'ke'a Anumaya Koti amisayana kanale huke. ");
INSERT INTO ino_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lapaulaka apo ka'nea vaya'mokitapa “Na'kame eo.” hutapa nehaya vaya'mokitapa lapa'kaeya “Nesuna lipi havikafa mai'neanaketa o'nekaune.” hutapa atale'naya'maki ala hosikana afu kamolo afu nesaya lipi mai'niketapa afa'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lapa'kaeya mono ke hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake nehaya vaya'mokitapa maitapa halove hu'netapao. Lapa'kaeya ameka lapa'kufale kava nehutapa li ne ke'ae lape'ae ameka'ale sese nehaya'maki kumaya kava'ae lapa'kufa lahapa'ye hu ya'ae lusi kava huno lapa'ku'ainaka havaite'nea'maki sese nohae. ");
INSERT INTO ino_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lapaulaka apo ka'nea Falasi mono ke ne'afea vaya'mokitapa hokotetapa li ne ke'mo ayopi'ae lape'mo aku'ainaka'ae sese hisayana ameka akofetule honi'ya ofaike. ");
INSERT INTO ino_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lapa'kaeya mono ke hapalitapa hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ameka lapa'kufaleti lapa'ke'atike kava'ake vaya'mokitapa maitapa halove hu'netapao. Lapa'kaeya ina akufa avamete kava nehae. Vaya kipate'naya kelile mopa atapa kalifatapa vakayo hu ne'malaya kava hutapa ameka lapa'kufale ne'alea'maki lapa'ku'ainaka vaya kasalikeno apayamufa kahalita hu'nea akufa kava hutapa mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lapa'kaeya ani kelikana hu'nake'a vaya'moki ameka lapa'kufale nelapa'kayana “Alakepa vaya mai'nae.” hu'a nehaya'maki lapaipamo'a honi'ya'ake nehuno lapa'ke'atike ke hu yatapi'ae Anumaya Koti ke male male'nea ke alitapa ne'atakaya yatapi'ae nesu yate hane'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lapa'kaeya Falasi mono ke ne'afea vaya'ae mono hapalitapa hapa'nepaiya vaya'ae ameka lapa'kufaleti lapa'ke'atike ke'ake vaya mai'nayanaki maitapa halove hu'netapao. Lapa'kaeya Anumaya Koti aune vaya'ai kipate'naya kelile vilasi hoya vai ne'apatetapa alakepa vaya'ai kelile'ae ani kava hutapa konakali vilasi hoya vai ne'apatae. ");
INSERT INTO ino_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Vaipatetetapa inake hutapa nehae “Lakaeya lototimoki mai'naya kanafi mai'noninana Anumaya Koti aune vaya hapaonake'a ofalinine.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ani ke nehaya vaya'mokitapa “Anumaya Koti aune vaya hapa'naya vaya'moki mafa'ne'api mai'none.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inaki lapa'kinakomoki hu'naya hao'otake kava lapa'kaeya mako'ae hisakeno ho'kalapateno. ");
INSERT INTO ino_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lapa'kaeya osifa've mai'nae. Osifa'vemo mafa'nemokitapa Anumaya Koti'a “Hani kumapi akola lapa'kufa lapa'kafu kisea kelifi maiyo.” huno kake hulapatesiketapaena lapa'kaeya hana kava hutapa lapaune hetapa ukae? ");
INSERT INTO ino_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ina kava hu'nakeno nakaeya apaune vaya'ae apa'kenopa hale'nea vaya'ae mono ke hapali'a hapa'nepaiya vaya'ae lapa'kaeyate hupatesuke'a ne'visaketapa lapa'kaeya alitapa vekala ne'atapa alitapa havi kava hune'apatetapa makoma'a hapaesake'a falikae. Mako'a yofo yosale nili aitetapa asaisake'a falikae. Mako'a mono nopi heki kayoteti sefu apamakisake'a haviya hute'a apaune he'a alu kumate kumate u'e'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hapaesake'a u'e'a hisaya yafe ma mopa alo hu'nea afina aepa he'a mi'ko kafu alakepa vaya hapake'a fali'naya vaya'moki kola'apimo'a kumitapi fole ai'ne. Hokote'a Epolona hao'otake kava ohu'nea ve'ka hakeno faliteke'a mako'a ani kava hu'a hapame hapame e'a henaka'a Pela'kaiya mafa'ne Se'kalaiya'a Anumayamoteka amuse ya ali'e'a ne'malaya yafa hipa hanete ala mono no hanete hu'nea folakapi hakeno ako fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lamake lahapa'nepauve ani hapake'a fali'naya vaya'ai havi miya meni mai'naya vaya'mokitapa alikae. ");
INSERT INTO ino_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Vae Yelusalemu mai'naya vaya'mokitapa lapa'kaeya Anumayamo aune vaya'a hapatapa ki ne'apatetapa Anumaya Koti'a hupateke'a lapa'kaeyate e'naya vaya'ae yafa kayoteti apamakitapa ki ne'apatae. Ani kava nehaya'maki nakaeya mi'ko afina ko'kolemo'a ana'au anaka'a apavaleno ita'amo'a ha'ku kapi apateteno apatali ne'kaeya kava hu'na Yelusalemu vaya lapavale'na anupa hisoe hu'na nehoa'maki lapa'kaeya nolahapaiye. ");
INSERT INTO ino_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","“Nolahaiye.” hutapa haya yafe afeo. Anumaya Koti'a kumatape “Aote'ya'ae.” huno ako atale'ne. ");
INSERT INTO ino_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ako atale'neanaketapa meni mako'ae o'nakekaya'maki ma ke hisaya afina etetapa nakekae. Ani afina inake hutapa hukae “Anumayamo ali'ya alikefe hikeno hute'nea ve'ka Anumaya Koti kanale manu amise.” hutapa ke hisaya afina mako'ae nakekae. ");
INSERT INTO ino_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","2","Yisasi'a ala mono no ataleno nelavike'a akaeya ke ne'afea anaka'moki e'a ala mono no'yaka avenele. Avelikeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya mani ala konakali yafa no'yaka ne'akafe? Lamake lahapa'nepauve mani ne'akaya yana mako kana va'yi hiseana mako yafa'mo'a mako yafa'mo akofetule ohanekaiya'maki mi'ko ani yafa nona atakufa lavike.” ");
INSERT INTO ino_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yisasi'a Olivi yosa hane'nea avima'mo aki'naleka haino faitopale mai'nike'a akaeya ke ne'afea anaka'moki apa'kai'apike Yisasite e'a inake hu'a afine'kae “Na kanale ani ya va'yi huke? Na akufa avame ya va'yi hinaketa kakaeya ekefe hanakeno'ae he huta aketesunakeno ma mopa ako avayakefe he huta akekaune.” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Afine'kakeno Yisasi'a inake huno hapapai'ne lapa'kaeya maitapa halove hu'netapao. Haviku apa'ke'atike'ake vaya'moki apa'ke'atike lahapapaisaketapa afikae. ");
INSERT INTO ino_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nesu vaya'moki e'a nakaeya naki ne'a'a inake hu'a hukae “Anumaya Koti'a nakaeya lapa'kufa ali'na katisoa yafe hunateke'na e'noa ve'ka mai'noe.” nehu'a apa'ke'atike ke hu'a mi'ko vaya a'a apavataka hukae. ");
INSERT INTO ino_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mako koteka la hisaya ke'ae fate koteka la hisaya avake'ae afikaya'maki lapaipa lapame'mo'a halekeno o'maino. Inani akufa ya va'yi hukea'maki ma mopa hano hisea kana makale va'yi ohuke. ");
INSERT INTO ino_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mako nofi anaka'moki mako nofi vaya'ae heti'a la hisake'a mako mopale vaya'moki heti'a mako mopale vaya'ae la hukae. Lusiya huno fate fate koteka ala imima alike. Lusi kafu nehu'a apa'katesea ya va'yi huke. ");
INSERT INTO ino_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ani mi'ko ya va'yi hukea'maki afa'a a'nemoki mafa'ne alitekefe nehakeno hokoteno apa'kafu ne'kea avamete maleno kikea'maki henaka'a lapa'kaeya lusi lapa'kafu kike. ");
INSERT INTO ino_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ani kanafi nakaeya naki'ae ke'ni'ae afitapa a'kame male'naya yafenake'a nesu nofi vaya'moki lapa'kaeyafe lusi apaipa kafa lahapate'a lapa'kaeya lapavale'a u'a ali'a haviya hulapatete'a lahapaesaketapa falikae. ");
INSERT INTO ino_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Apaipa kafa lahapaesaya yafe nesu vaya'moki nakaeyafe afi'a apaipafi male'naya ke atalete'a nepu konaka'apimoki apavale'a kame vaya'ai apayapi apatesake'a hapakae. Ina kava nehu'a ani konaka konaka ne'atane'a kame hukae. ");
INSERT INTO ino_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ani kava nehisaya kanafi apa'ke'atike'ake apaune vaya lusi yate va'yi hu'ne'a mi'ko vaya apa'ke'atike ke hapapaite'a lusi vaya apavale'a havi kapi apatekae. ");
INSERT INTO ino_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hao'otake au'ava ya'mo'a lusiya huno aino atakufakaiyanake'a vayafe hapautaki fotaki nehaya kava atalekae. ");
INSERT INTO ino_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Atalekaya'maki mako vaya'moki nakaeya ke aepa he'a meni afime ne'visayana Yisasi'na ete'na esoa afina nakaeya ke atafa hu'nisaya vaya'aina Anumaya Koti'a apaipa apame alino katike. ");
INSERT INTO ino_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anumaya Koti'a kava alino yakaipatesea yafe mi'ko aupalika hapapaisake'a mi'ko vaya'moki afitesakeno henaka'a ma mopa hano hisea kana va'yi huke. ");
INSERT INTO ino_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yisasi'a inake nehe a'ke'ainaka Taniolo'a Anumaya Koti aune ve'kamo'a hu'nea ya lapa'kaeya akesakeno lusi lapamo'yo aisea ya ma mopa alino haviya hisea ya fate akufa nopi heti'nisiketapa akekae. Ani hu'nea ke hapalitapa afisaya vaya'mokitapa afitapa alakepa hutapa afeo. ");
INSERT INTO ino_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ani lapamo'yo aisea ya akesayana ani kanafi Yutia mai'nisaya vaya apaune he'a avimateka haiyo. ");
INSERT INTO ino_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mako ve'kamo'a no'kato'mule haino mai'neno ani ke ne'afiseateti lavino no'afakati mako ya o'alino afa'a naku naku vino. ");
INSERT INTO ino_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mako ve'ka hoyafaka mai'niseateti uno kena'a alikefe noteka o'vino. ");
INSERT INTO ino_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Avo'neo ani afina lusi havi ya va'yi huke. Ani afina aipa'ae mai'nisea a'ae mafa'ne saufa alitete'a nu ne'apamisaya a'ne'ae lusi nahau hune'apatoe. ");
INSERT INTO ino_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Anumaya Kotiteka inake hutapa afikeo “Ko ne'aiya i'kate'ae sapati afina'ae ani ya va'yi ohise.” hutapa afikeo. ");
INSERT INTO ino_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Hokoteno Anumaya Koti'a ma mopa alo hu'nea kana'ae meni kana'ae ani ala havi kana hapaisea ya va'yi ohu'nea'maki ani havi kana va'yi hiseana vaya lusi apa'kafu kikea'maki henaka'a mako'ae ani ya va'yi ohuke. ");
INSERT INTO ino_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anumaya Koti'a ani havi kana alino aupa huke. Alino aupa ohininana mi'ko vaya ako falinine. Anumaya Koti'a haikeno hapalimale'nea vaya'aife afino apa'kufa alino katisea yafe ani kana alino aupa huke. ");
INSERT INTO ino_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ani kanafi mako vaya'moki inake hukae “Anumaya Koti'a lakufa alino katikefe hute'nea ve'ka mafi mai'niki akeo.” huke “Muka mai'niki akeo.” huke hisaketapaena “Lamake nehae.” hutapa o'afeo. ");
INSERT INTO ino_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mako vaya va'yi hu'a vaya'aina a'a apavataka hisaya yafe apa'ke'atike ke inake hu'a hukae “Nakaeya Anumaya Koti'a lapa'kufa alino katikefe hunate'nea ve'kake'na ne'oe.” hu'a hisaya vaya'ae apa'ke'atike'ake apaune vaya'ae va'yi hukae. Ani akufa vaya va'yi hu'a Anumaya Koti'a ha'ye hikeno hapalimale'nea vaya'aina a'a apavataka hisaya yafe apa'ke'atike ke afisaya yafe lusi apamo'yo ai ya'ae o'ake'naya avame ya hu lo'kiya ya'ae hukae. Ani ya hukaya'maki Anumaya Koti ha'ye hikeno hapalimale'nea vaya'moki o'afikae. ");
INSERT INTO ino_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Afeo ani ya va'yi ohu'nea afina ako lahapapai'noanaki afitapa alakepa heo. ");
INSERT INTO ino_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ani yafe “Ani ve'ka ka'me koteka mai'niki utapa akeo.” hisaketapaena anifi o'mai'nekaiyanaki lapa'kaeya o'veo. “Mika nopi mai'niki utapa akeo.” hu'a hisaketapaena “Lamake nehae.” hutapa lapa'kesa o'afeo. ");
INSERT INTO ino_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne esoa au'ava kava'mo'a ina kava hukeanaki afeo. Lapa'kaeya akesakeno kopasi'namo'a yake haino ne'eatekati ano kahai huno yake lavino nefalea aupalika ano haleketapa ne'akaya avamete Anumayamo Mafa'ne ete'na ekefe hisukeno'aena ani kava hukeanaketapa nakekae. ");
INSERT INTO ino_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Fali'naya vaya apa'kufa hane'nea yate'ke mi'ko ha'ki'ki namayakamoki e'a ali'a anupa nehae. Ani kava hu'a mi'ko vaya'ai folakapi Anumayamo Mafa'ne ekaiye. ");
INSERT INTO ino_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ani ala kana hapaisea kana hano hutesikeno yakemo'a alino hani'ake nehisikeno i'ka'mo'a mako'ae ano ha olesike'a sanafi'yaka ko'ku'nateti atafailavi atafailavi hukae. Atafailavitesake'a mi'ko ani ko'ku'nate lo'kiya ya hane'nea ya'mo'a kanake kanake nehu'a fate fate kate u'e'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ani ya fole aitesike'naena nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na lapavelisoa avame hu yana ko'ku'nate va'yi hiseana mi'ko mopafi mai'naya nofi vaya'moki apamo'yo ne'ai'a avilekae. Avi'nele'a akesakeno ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne ko'ku'nate hiyapi ano hale himamu lo'kiya ya'ni'ae eli'na ne'esuke'a nakekae. ");
INSERT INTO ino_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne'akesake'na kayo kayo vaya'ni hupatesuke'a lusiya hu'a ufe ne'a'a mi'ko yake haino ne'eatekati'ae yake lavino nefaleatekati'ae aluka aluka aupalika'ae hupatesuke'a u'ne'a mi'ko nakai'ni vayane hu'na hapalimale'noa vaya'ni ko'ku'na'mo'a uno atale'niseatekati'ae apavale'a e'a anupa hute'a ekae. ");
INSERT INTO ino_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yisasi'a inake nehe hikifa yosale humale'na mako avoya ke lahapapaikoanaki afeo. Ani yosamo'a hokoteno a'kopayakale akusasi ano haita maleteno atali huteno halate anupa maleketapaena “Meni hoya ha'kale kana fole aiye.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ani kava nehaya'maki ani lahapapai'noa avame ya akesutapaena “Esea kana'amo'a aupasi nehikeno kipate eno mai'neanakeno ako ekaiye.” hutapa lapa'kesa afikae. ");
INSERT INTO ino_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lamake hu'na lahapa'nepauve meni mai'naya ve alave ofali'a afa'a mai'nisakeno mi'ko ani ya va'yi huke. ");
INSERT INTO ino_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lamake ko'ku'na'ae mopa'ae fanane huka'a'maki nakaeya ke'nimo'a alaki fanane ohuno haneke haneke huke. ");
INSERT INTO ino_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ani lahapapai'noa kana eno fole aisea kana mako ve'kamo'a alaki lamake huno o'afi'ne. Ani kava hu'a ko'ku'napi mai'naya kayo kayo vaya'moki'ae ani kana o'afi'nae. Ani kava huno Anumaya Koti Mafa'ne'amo'ae ani kana o'afi'nea'maki Afo'amo'a akai'ake ani kana afi'ne. ");
INSERT INTO ino_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A'ke'ainaka Noa'a mai'nea afina mai'naya vaya'moki hu'naya akufa kava hu'a ani afina mai'naya vaya'moki'ae ani akufa kava nehisake'na nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne ete'na ekauve. ");
INSERT INTO ino_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Li'mo'a ano apati o'ka'nea kanafi mai'naya vaya'moki ne'ya'ae li'ae ne'ne'a a alike ve alike nehu'a mi'ko afina ani yafe'ke apa'kesa ne'afi'a Noa'a ke hapapai'nea'maki ani ke o'afi'nakeno Noa'a lipi kalefi haino faleke'a mi'ko vaya'moki apa'kesa o'afi'a mai'naya yapi li'mo'a hakakino e'neno mi'ko vaya ano apati ka'ne. Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne ete'na esoa afina ani akufa kava hukae. ");
INSERT INTO ino_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nakaeya ete'na esoa afina hoyafi aole ve'kala mai'nisa'apati Anumaya Koti'a mako avaleno asaka nehuno mako ve'ka alino apahetalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aole atala'mokani maya lo'ka'ana haya ne'aisa'akeno Anumaya Koti'a mako a avaleno asaka nehuno mako a alino apahetalekaiye. ");
INSERT INTO ino_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ina yafe Anumayatapimo'na esoa kana lapa'kaeya o'afi'naya yafe lapau o'kaletapa akeva hutapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lapa'kaeya mako kumaya vaya'aife lapa'kesa afitapa haleo. Mako kumaya ve'kamo'a “Ina hanipi ina kanale no'a fai'na anafe hu'na alikoe.” huno hinakeno no'mo afo'amo'a afi'nininana “Kava yakaikoe.” huteno no'ale yakai'nisikeno ani kumaya ve'kamo'a ano anafe huno haino no'afati ya o'alinine. ");
INSERT INTO ino_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lapa'kaeya'ae ani kava hutapa avatati hutapa nakeva heo. Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kae “O'mekaiye.” nehutapa lapa'kesa o'afitapa haviku mai'nisaya kanafi e'na lahapau kakauve. ");
INSERT INTO ino_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anumayamo'a inake he kanale ali'ya ve'kamo'a akenopa hale'nea ve'ka mi'ko afina ali'ya alike alike nehea ve'ka lapa'kaeyapi hanate mai'ne? Ani kava hu'nea ali'ya ve'kae ala kava ve'kamo'a inake huke “Mi'ko ali'ya vaya'aite yakai'ne'ka mi'ko afina ne'ya fa'ko hu'ka apamite apamite ho.” huke. ");
INSERT INTO ino_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hukea'maki ani kava ve'ka henaka'a eteno ne'esikeno hokoteno hapai'nea akufa kava nehuno'aena ani ali'ya ve'kamo'a amuse huke. ");
INSERT INTO ino_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lamake hu'na lahapa'nepauve ani kava hu'nea ali'ya ve'kae kava ve'kamo'a inake huke “Mi'ko ya'ni'ale kava yakaiyo.” hutekaiye. ");
INSERT INTO ino_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Hutekaiya'maki ani ali'ya ve'kamo'a ina akufa akesa afike “Ala kava ve'ka'ni makale o'mekaiye.” huteno ali'ya'ale yakaipate'nea vaya kayo ne'apamino ala kava ve'kamo ne'ya neteno mako vaya'ae atu li neteno anekinaki nehuno “O'mekaiye.” huno haviku mai'nisea kanafi ani ala kava ve'ka ekaiye. ");
INSERT INTO ino_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eno ani hao'otake kava hu'nea ali'ya ve'ka lusi kayo amiteno inake huke “Nakaeyateka vekano'kano hu ne'nataya vaya'ae maiyo.” huno hutekaiye. Hutesikeno ani kumapi viseana apa'kafu yulakefa ne'ai'a apave kemo hukae. ");
INSERT INTO ino_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yisasi'a inake huno ke avoya kefati nehe Anumaya Koti'a kava alino yakailapatesea kana aepa hesea afina ina kava huke. Mako ve'ka meni a ali'nea ve'ka ekefe nehike'a naya aole a'mafa'neyaka ata kani'api ne'ali'a katekati u'a avalekefe u'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naya mako kaya a'mafa'neyaka apa'kesa o'male'nea a'mafa'neyaka maike'a naya mako kaya a'mafa'neyaka apa'kenopa hale'nea a'mafa'neyaka mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ani apa'kesa o'male'nea a'mafa'neyaka kani'api ali'ne'a e'naya'maki mako'ae la'kite'a ata kani aesaya lina ali'a o'me'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ali'a o'me'naya'maki apa'kenopa hale'nea a'mafa'neyakamoki ke'ayo'apifi la'kite'a ata kani aesaya lina alite'a ani ata kani'api'ae ali'ne'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","U'naya'maki ani a ali'nea ve'ka makale o'meke'a ani a'mafa'neyaka apau mai'mai hike'a apau kale'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Apau kale'nakeno hani'ainaka ala kefati inake hu'ne “A ali'nea ve'ka ako ne'e. Lapa'kaeya katekati utapa avaleteo.” ");
INSERT INTO ino_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nehike'a mani nayatala'a a'mafa'nemoki heti'a kani'api aesaya ya ako ali'a avatati hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Apa'kesa o'male'nea a'mafa'nemoki apa'kenopa hale'nea a'mafa'ne'aife inake nehae “Lakaeya ata kaniti ako asu hesea kava nehiki lapa'kaeya li kepati la'kilateo.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nehake'a apa'kenopa hale'nea a'mafa'nemoki anona'a ke'apile inake hae “Ata kani aesuna lina lakaeya'ae lapa'kaeya'ae la'kisuna akufa kava ohu'neanaki lapa'kaeya afeno nopati utapa miya heo.” hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Miya heo.” hu'a hupatake'a ne'vakeno a ali'nea ve'ka anile eke'a ali'a avatati hute'a mai'naya a'mafa'neyaka akaeya'ae ala ne'ya nopi hai'a falete'a kita ako kimale'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kimale'nake'a apa'kesa o'male'nea a'mafa'nemoki henaka'a e'a inake hae “Ala Nenao Ala Nenao kita ya'kilato.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nehakeno a ali'nea ve'kamo'a anona'a ke'apile inake he “He'e lamake lahapa'nepauve nakaeya nolapa'koa anaka ne'ae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yisasi'a inake nehe “Ina kava hu'naya yafe lapa'kaeya kava yakaiyo. Nakaeya ete'na esoa afina'ae kana'ae o'afi'naya yafe kava yakaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yisasi'a Anumaya Koti kava yakaipatesea kanae inake he mako kava ve'kamo'a yatala koteka ukefe nehuno ali'ya vaya'aife ke hike'a akeno moni fa'ko huno apamite apamite huteno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ali'ya ne'alea aepa'api apa'keteno mako ve'ka naya mako kaya tauseni kina (K5,000) amite mako ve'ka aole tauseni kina (K2,000) amite mako ve'ka mako'ke tauseni kina (K1,000) ami'ne. Apamite apamite huteno afaki koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","U'nikeno naya mako kaya tauseni kina (K5,000) ami'nea ve'kamo'a ani monileti ali'ya aliteno mako'ae ai'akama'a moni alikeno naya mako kaya tauseni kina'ae (K5,000) aliteno alino maleno lo'kaeyateka nayatalama'a alea tauseni kina (K10,000) fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Fole aikeno aole tauseni kina (K2,000) ami'nea ve'kamo'a ani monileti ali'ya aliteno mako'ae ai'akama'a moni alikeno aole tauseni kina'ae (K2,000) aliteno alino maleno lo'kaeyateka aole'ae aole'ae tauseni kina (K4,000) fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Fole ai'nea'maki mako'ke tauseni kina (K1,000) ami'nea ve'kamo'a ani moni alino uno mopafi keli kafiteno ano ati kamale'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ani ali'ya vaya'ai kava ve'ka yatala kana uno maiteno eteno eno apami'nea monimo ke huke nehe. ");
INSERT INTO ino_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Huke nehuno naya mako kaya tauseni kina (K5,000) ami'nea ve'kamo'a va'yi huno nayatala'a tauseni kina (K10,000) alino eno ne'amino inake he “Kava Nenao amuse'ka nehuki naya mako kaya tauseni kina (K5,000) nami'nanapati ete'na ali'ya alukeno ai'akama'a nayatalama'a tauseni kina (K10,000) hane'ne.” ");
INSERT INTO ino_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hikeno ala kava ve'kamo'a akaeyafe inake he “Kakaeya mi'ko afina ali'ya alike alike hana ya'kamo'a kanale hike'ka kanale ve'ka mai'nane. Aise moni kami'noa yateti ali'ya ali'nakeno ala hu'nea yafe kakaeya ala kava ali'ka yakaisana ya kamikoe. Nopi hai'keketa'a lo'kata'a amuse hi'ano.” ");
INSERT INTO ino_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nehikeno aole tauseni kina (K2,000) ami'nea ve'kamo'a eno inake huno hapai'ne “Kava Nenao amuse'ka nehuki kakaeya aole tauseni kina nami'nanapati ali'ya alukeno ai'akama'a moni aloateka aole'ae aole'ae tauseni kina (K4,000) ali'na ne'oe.” ");
INSERT INTO ino_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Hikeno ala kava ve'kamo'a akaeyafe inake he “Kakaeya ali'ya alike alike hana ya'kamo'a kanale hike'ka kanale ve'ka mai'nane. Aise moni kami'noa'maki ali'ya alinakeno ala hu'nea yafe kakaeya ala kava ali'ka yakaisana ya kamikoe. Nopi hai'keketa'a lo'kata'a amuse hi'ano.” ");
INSERT INTO ino_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nehikeno mako'ke tauseni kina (K1,000) ami'nea ve'kamo'a eno inake he “Kava Nenao amuse'ka nehuki ako kake'noana kakaeya lo'kiya ke'ake ve'ka mai'ne'ka alu ve'kamo male'nea ya ha'nefale'ka mako ve'kamo hoya'afi ha'kalemale'nea ya'ae kumaya ali'ka ne'nana ve'ka mai'nane. ");
INSERT INTO ino_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mako'ke tauseni kina (K1,000) nami'nana'maki koli'ka hute'na mopafi keli kafite'na fala'ki'kate'noateti kakaeya ma moni ali'na e'na ne'kamoe.” ");
INSERT INTO ino_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nehikeno ala kava ve'kamo'a ani ali'ya ve'kae inake he “Kakaeya kayamufa o'ai ali'ya ve'ka mai'nane. Kakaeya ako afi'nane nakaeya alu ve'kamo male'nea ya ha'nefale'na mako ve'kamo hoya'afi ha'kalemale'nea ya'ae kumaya ali'na ne'noa ve'ka mai'noa yafe ako afi'nape? ");
INSERT INTO ino_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Afi'nana'maki na kava hike'ka moni ne'malaya nopi moni'ni o'male'nane? Malanateninana nakaeya meni moni'ni'ae ai'aka moni'ni'ae alunine.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mako vaya'aife inake he “Ani mako'ke tauseni kina (K1,000) ali'nea ve'ka hafaletetapa nayatala'a tauseni kina (K10,000) ali'nea ve'ka ameo. ");
INSERT INTO ino_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lahapa'nepauve afeno'ya'a hane'nisea ve'ka mako'ae amisukeno ala afeno'a hanekaiya'maki afeno'ya ho'kano o'male'nisea ve'ka ali'nisea ya'a akaeyapati hafalekauve. ");
INSERT INTO ino_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani havi ali'ya ve'ka avaletapa ma'ailaka hani kumapi yaka hutalesake'a anifi mai'ne'a lusiya hu'a avovo avava nehu'a avi nele'a apave kume kume kanesaya kumapi atalekae.” ");
INSERT INTO ino_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yisasi'a inake he ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na kava yakaikefe esoa afina ano hale lo'kiya himamu ya'ni'ae ko'ku'napi kayo kayo vaya'ae ete'na ekauve. Nakai'ni ano hale lo'kiya'nileti kava yakaisoa yafe hale fai mai yate maikoe. ");
INSERT INTO ino_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fai mai'nisuke'a mi'ko aupalikati vaya'moki nakaeyate e'a ali'a atalu hu'nisake'na sipi sipile kava ne'yakaiya ve'kamo'a meme'ae sipi sipi'ae alino fa'ko fa'ka nehea avamete male'na vaya ali'na fa'ko hukoe. ");
INSERT INTO ino_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ali'na fa'ko hu'na sipi sipima'a naya lamaka ne'apate'na memema'a naya haoka apatekauve. ");
INSERT INTO ino_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Apatete'na ala kava yakai kanomo'na naya lamaka apatesoa vayafe inake hukoe “Afo'nimo'a kanale amuse ya ako lapami'nea vayanaki eo. Mani mopa alo hu'nea afina aepa heno katilapate'nea kumate kava yakaisoa kumate lapa'kaeya etapa maiyo.” hu'na hukoe. ");
INSERT INTO ino_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“Nakaeya naka'neteketapa ne'ya nami'nae. Life ne'nahaiketapa li nami'nae. Nata ve'ka ne'oketapa hutapa falu fala hune'natetapa navaletapa notapifi nate'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kena'ni o'male'niketapa kena havainate'nae. Kali ali'noketapa kava hunate'nae. Nofi nopi mai'noketapa utapa nake'nae. Ani kava hunate'naya yafe katilapate'noa kumate etapa maiyo.” hu'na hukoe. ");
INSERT INTO ino_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hisuke'a naya lamaka mai'naya alakepa kava hu'naya vaya'moki inake hukae “Anumayati hana afina kakateketa kaketeta ne'ya kami'none? Hana afina life kahaiketa kaketeta li kami'none? ");
INSERT INTO ino_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hana afina nata ve'ka ne'anaketa alita kanale hukate'none? Hana afina kena'ka o'maleketa kena kami'none? ");
INSERT INTO ino_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hana afina kali kaha'niketa kake'none? Hana afina nofi nopi mai'nanaketa uta kake'none.” hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Inake nehisakeno ala kava ve'kamo'a apa'kaeyafe eteno inake huke “Lamake lahapa'nepauve lapa'kaeya apa'ki o'male'nea nakana'nimoki hupate'naya kavana nakaeya'ke hunate'nae.” huno huke. ");
INSERT INTO ino_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Hukea'maki aya haoka alino apate'nea vaya'aife inake huke “Hao'otake kava'ake nehaya vaya hu'na haviya hulapatesoa yafe nataletapa veo. Sata'ae ali'ya vaya'a'ae katipate'noa kumapi akola ata leke leke nehea atafi utapa akola maiyo. ");
INSERT INTO ino_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nakaeya nakale'nea'maki ne'ya o'nami'nae. Life nahau'nea'maki li o'nami'nae. ");
INSERT INTO ino_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nata ve'ka ne'oa'maki navaletapa falu fala huo'nate'nae. Kena'ni o'male'nea'maki kena havai o'nate'nae. Kali alite nofi nopi ute hu'noa'maki utapa o'nake'nae.” ");
INSERT INTO ino_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hisike'a ete'a inake hukae “Anumayatimoka hana afina kakateketa kake'none? Hana afina life ne'kahaiketa kake'none? Hana afina nata ve'ka e'nanaketa kake'none? Hana afina kena'ka o'male'niketa kake'none? Hana afina kali alite'ka mai'nanaketa kake'none? Hana afina nofi nopi mai'nanaketa kake'none? Kake'nonateninana ako kaha'ma'nonine.” ");
INSERT INTO ino_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hakeno ala kava ve'kamo'a apa'kaeyafe inake huke “Lamake hu'na lahapa'nepauve lapa'kaeya apa'ki o'male nakana'nimoki ani kava hu o'apate'nisayana ani ya nakaeya'ke hu o'nate'nae.” ");
INSERT INTO ino_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ani hao'otake kava hu'naya vaya'aina hupatesike'a akola apa'kufa apa'kafu ki'a maike maike hisaya kumapi u'a maikaya'maki alakepa hu'a mai'nisaya vaya'moki kanale anona'a amuse hu'a ofali'a akola maike maike hu'a maisaya kumate ukae. ");
INSERT INTO ino_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Yisasi'a mani ke huno avaya ateno akaeya ke ne'afea anaka'aife inake he “Lapa'kaeya ako afi'nae Anumaya Koti'a lapa'kinakomoki apa'kufa alino kati'nea afinafe apa'kesa afi ne'ya hale o'ki kai hame'ya yakita hu'a nesaya kana aole afina maite'a aepa he'a ani ne'ya kakae. Katesake'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka natafa hu'a yofo yosale asaite'a nahaesake'na falikoe.” ");
INSERT INTO ino_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hike'a mono nopi kava vaya'ae ala ala vaya'ae ala mono nopi hokote kava ve'ka Kaiyafasi nopi ali'a atalu hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mai'ne'a ke hu'a nehaya'a inake hae “Hana kava huta lake'atike ke huteta kesi Yisasina atafa huta haesunakeno falise?” ");
INSERT INTO ino_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Inake hae “Mi'ko vaya'ko e'a ali'a atalu hu'ne'a ne'ya yakita hu'a nesaya yapi Yisasina atafa ohisune. Haviku atafa nehisunake'a mi'ko vaya'moki akete'a kaleso ne'ai'a la hukae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yisasi'a Petani uno a'ke'ainaka fuko'ya ake'nikeno alino kanale hute'nea ve'kamo nopi uno mai'ne. Ani ve'kamo aki'a Saimoni'ae. ");
INSERT INTO ino_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mai'nikeno mako a'mo'a yafa ke'ayo alilino akaeyate e'ne. Ani ke'ayo alo nehaya yafa'mo aki'a alapasata. Ani kepi ala miya ne'atalaya masave mana'ake li hane'nikeno ani a'mo'a ani masave ali'neno Yisasi'a hipale mai'nikeno akenopafi la'kino falete'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","La'kino fale ne'ateke'a akaeya ke ne'afea anaka mai'ne'a akete'a ani yafe apaipa kafa neha'a inake nehae “Na kava hikeno mika a'mo'a mana'ake masave la'kino huke ataleke nehe? ");
INSERT INTO ino_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ani mana'ake masave vaya apamisunake'a miya hisaketa ala moni aliteta moni afeno'api o'male vaya fa'ko huta apaminine.” ");
INSERT INTO ino_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisasi'a haya ke afiteno inake he “Ani ana ke o'ama'kitapa ataleo. Na ya hiketapa lapa'kaeya kana haiya ke nehae? Akaeya mani a'mo'a kanale kava hune'nate. ");
INSERT INTO ino_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Afeno ya'api o'male vaya mi'ko afina lapa'kaeya'ae lo'ka'a maikayanaketapa apaya hisaya lapa'kesa afisaya afina apaya hukaya'maki nakaeya mi'ko afina lapa'kaeya'ae lo'ka'na o'maikoe. ");
INSERT INTO ino_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mani a'mo'a mana'ake masave nakufale fale ne'nateana nakaeya kelifi kinatesaya ka'ni'a alino avatati hune'nate. ");
INSERT INTO ino_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nakaeya lamake lahapa'nepauve. Mi'ko aupalika vaya'aipi Yisasi kanale ke hapapaisaya koteka mani a'mo'a hunate'nea avake'a hapapaisake'a ani afe apa'kesa afikae.” ");
INSERT INTO ino_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Ani afina layatala'a hano huteno laiyalekati aole alea anaka Yisasi ke ne'afea anakapati mako'ke ve'ka Yutasi Isa'kelioti'a mono nopi kava vaya'aite uno inake he “Kutalu ya alo hutapa na'maki miya namisake'na Yisasina avale'na lapayapi atesoe?” huno hapapaike'a ani ke afite'a lusi amuse nehu'a teti kina (K30.00) ami'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amitakeno Yutasi'a ani afina Yisasina atafa hu'a haesaya kafe aepa heno kahau ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hale o'ki kai hame'ya ne'ya ne'naya kana hokote afina fole ne'aike'a Yisasi ke ne'afea anaka'moki Yisasite e'a inake hae “Hanate uta Anumaya Koti'a lakinakomoki apa'kufa alino kati'nea yafe lakesa afisuna ne'ya alita avatati hukatesune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Afine'kakeno Yisasi'a inake huno hapapai'ne ala kumate ne'utapa mako ve'ka aketapaena inake hutapa heo “Alino laya nehea ve'kamo'a inake huno hulateketa ne'one ‘Falisoa kana'ni ako va'yi hike'na kakaeya nopi nakaeya ke ne'afea anaka'ae Anumaya Koti'a lakinakomoki apa'kufa alino kati'nea yafe lakesa afi ne'ya nekefe nehune.’ hutapa hapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yisasi'a ani ke hapapaiteke'a mi'ko Yisasi'a hapapai'nea kava hu'a Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi ne'ya ali'a avatati hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ali'a avatati humalete'a une Yisasi'ae layatala'a hano huteno laiyalekati aole alea anaka'ae lo'ka'a mai'ne'a ne'ya ne'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne'ya ne'ne'a Yisasi'a inake he “Nakaeya alaki lamake hu'na lahapa'nepauve nakaeya'ae mai'nonapati mako ve'katapimo'a kutalu ya ako ne'neanakeno nakaeya navaleno kame ya hunatesaya vaya'ai apayapi natekaiye.” ");
INSERT INTO ino_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nehike'a mi'ko mako'ke mako'ke'moki apaipamo'a kana hapaike'a Yisasife inake hu'a afine'kae “Anumaya'nimoka nakaeyafe nehapi?” ");
INSERT INTO ino_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hu'a afine'kakeno Yisasi'a inake he “Nakaeya'ae mako'ke lapepati kai hame'yateti faino vakamotino ne'nea ve'kamo'a kame vaya'nimoki nahaesaya yafe kesi kate uneno nehuno kutalu ya ne'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ne'nekeno Anumaya Koti avopi ako kamale'naya ke a'kame male'a nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nahaesake'na falikoe. Avopi kamale'naya yafe ani kava hunatekaya'maki nakaeya navaleno kame ya hu ne'nataya vaya'ai apayapi natesea ve'kaena lusiya hu'na nahau hutoe. Ani ve'ka ita'amo'a ali o'ate'nininana kanale hinine.” ");
INSERT INTO ino_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hikeno Yutasi'a avaleno kame vaya'ai apayapi atesea ve'kamo'a inake he “Ali'ka laya nehana Nenao nakaeyafe nehape?” Hikeno Yisasi'a inake he “He kakaeya kakai'ka ako hu'ka fole ne'aine.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ne'ya ne'nakeno Yisasi'a mako kai hame'ya alino Anumaya Kotiteka ke huno amuse huteno a'kaya heno ke'a ne'afea anaka ne'apamino inake huno hapapai'ne “Mani kai hame'ya nakai'ni nakufaki lapa'kaeya alitapa neo.” ");
INSERT INTO ino_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mako li hefi'a ne'naya kepi nofi alakamo li hane'nea ke aliteno Anumayamoteka ke huno amuse huteno ne'apamino inake he “Mi'ko'amokitapa nete nete heo. ");
INSERT INTO ino_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mani lina nakai'ni kolane. Vaya'moki nahaesake'na falisoana kola'nimo'a la'ki laviseana mi'ko vaya'mokitapa hao'otake yatape lahapaove lapatove nehu'na naipa falu yapati ali'na atalelapatekauve. Ani kola'mo'a Anumaya Koti'a alino lo'kiya vailapate'nea kemo aepa'a alino lo'kiya vaike. ");
INSERT INTO ino_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nakaeya alaki lamake lahapa'nepauve nakaeya mako nofi alakamo li mako'ae o'ne'na maime u'na Anumaya Koti kava yakaisea kumate u'na lapa'kaeya'ae saufa au'ava kava hu'na nofi alakamo li nekauve.” ");
INSERT INTO ino_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hike'a mako'ke yakame hute'a ma'aileka hatilavi'a Olivi yosa hane'nea avimate u'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yisasi'a akaeya ke ne'afea anaka'ae inake he “Meni hani'ainaka mi'ko'amokitapa nakaeyafe afitapa lapaipafi male'naya yatapi ataletapa lapaune hekae. Anumaya Koti akai'a inake hike'a avopi kamale'neane ‘Nakaeya sipi sipi afu anaka'ai kava ne'api nehaesoana mi'ko afu anaka apaune he'a falu fale hukae.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kamale'nea'maki fali'nisukeno Anumaya Koti'a eteno alino hetinatesike'na Kalili u'na hoko netesuketapa na'kame ekae.” ");
INSERT INTO ino_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nehikeno Pita'a inake he “Mi'ko'amoki kakaeyafe afi'a apaipafi male'naya ya'api atale'a apaune hekaya'maki nakaeya lamake hu'na kaha'nepauve kakaeyafe afi'na naipafi male'noa ya'ni atale'na naune ohekauve.” ");
INSERT INTO ino_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nehikeno Yisasi'a Pitafe inake he “Lamake kahapauvanaki afeo. Meni hani'ainaka ko'kole ake o'ai'nisike'ka aole'ae mako'ae kana nakaeyafe ‘O'ake'noa ve'kae nehae.’ hu'ka vane hunatekane.” ");
INSERT INTO ino_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nehikeno Pita'a lo'kiya ke nehuno inake nehe “Kakaeya'ae nahaesake'na falisoe hu'naena nakaeya ‘O'ake'noa ve'kae.’ hu'na vane huo'katekauve.” huno nehike'a mi'ko Yisasi ke ne'afea anaka'ae mako'ke akufa ke'ake nehae. ");
INSERT INTO ino_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisasi'a apa'kaeya'ae Ketesemenine hu'a aki ne'aya hoyafi u'a va'yi nehu'a Yisasi'a ke'a ne'afea anaka'aife inake huno hapapai'ne “Anumaya Kotiteka ke hu'na afikekefe mukakaya uvanaki lapa'kaeya male maiyo.” ");
INSERT INTO ino_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hapapaiteno Pita'ae Sepeti mafa'nela Yemisi'ae Yoni'ae apavaleteno lo'ka'a ne'u'a Yisasi aipamo'a aepa heno kana'ake nehuno atafa huno alaki hikeno lusiya huno havi akaso ali'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Akaso ne'alino akaeya'ae u'naya anaka'aife inake he “Ako falisoa akufa kava nehukeno naipamo'a kana ne'nahaiki lapa'kaeya male mai'netapa kava yakainateo.” ");
INSERT INTO ino_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hapapaiteno aupasi'a uno mopafi aukosalekati ivi'ivi asakauno ai'neno Anumayamoteka inake nehe “O Afo'nimoka falisoa ya huki ani havi kanamo'a atu'ake nehea li'kana nehiki Kakaeya kahaisike'kaena ani li hane'nea ke'ayo ali'ka atalanina'maki nakaeya naku nakesale a'kame o'male'ka kakai'ka afisana kaku kakesale a'kame malo.” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Afikeno Yisasi'a uno akaeya ke ne'afea anaka'aite eteno uno apa'keana apau kale'a mai'nakeno apa'keteno Pitafe inake nehe “Vae lapa'kaeya aise kana nakaeya'ae lo'katapa kava yakaitapa o'mai'nafe? ");
INSERT INTO ino_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Haviku Sata'a ‘Hao'otake kava heo.’ huno ano lapavataka hu ya'mo'a eno lahapau kae yafenaki yakai'netapa Anumayaleka afikeo hu'nae nehoe. Lamake lapaipamo'a Anumaya a'kame malesea yafe nehaiya'maki lapa'kufamo'a alaka nehaekeno lo'kiya'a no'male. Sata ke o'afisaya yafe kava ne'yakaitapa Anumayamoteka ke hutapa afikeo.” ");
INSERT INTO ino_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mako'ae Yisasi'a eteno uno Anumayamoteka inake huno afike'ne “Afo'nimoka mani hao'otake kanamo'a atu'ake nehea li'kana nehikeno ani li hane'nea ke'ayo nakaeyafe ao'kaseno ‘Afa'a nese.’ hu'ka kakesa afisanana afa'a kanalenaki kakaeya afisana kate a'kame malo.” ");
INSERT INTO ino_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Afikeno Yisasi'a halate akaeya ke ne'afea anaka'aite eteno uno apa'keana apaulakamo'a kana'ake hike'a apau kale'a mai'nakeno apa'ke'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Halate aole'ae mako'ae kana apataleno uno hokoteno afike'nea akufa ke'ake huno mako'ae Anumayamoteka afine'ke. ");
INSERT INTO ino_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Afikeno Yisasi'a halate eteno akaeya ke ne'afea anaka'aite eno apau kale'a mai'nakeno apa'keteno inake he “Lapa'kaeya lapau kaletapa kanale maitapa falu nehafe? Afeo. Meni vaya'moki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka natafa hu'a navale'a havi vaya'moki apayapi ako natesake'a nahakefe nehae. ");
INSERT INTO ino_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hetiketa ako vino. Akekeo nakaeya navaleno havi vaya'ai apayapi natesea ve'ka kutalu ya ne'nea ve'ka ako eno lava'neteki ake'nafe?” ");
INSERT INTO ino_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisasi'a ani ke nehikeno Yutasi'ae ve'ka ayatala'a hano huteno aiyalekati aole ali'nea anakapi lo'kano ne'maiya ve'ka va'yi nehike'a akaeya a'kameleka mi'ko vaya e'nae. Mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ala ala vaya'ae ani vaya hupatake'a ani vaya'moki heki kayo alike mi'ko kayo alike hu'ne'a Yisasite e'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutasi'a Yisasina haesaya kutalu ya ne'nea ve'kamo'a inake hu'ne “U'na mako ve'ka hane hane hisoa ve'ka atafa heo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ani ke huno hapapaiteno Yutasi'a makale Yisasite eno inake he “Ali'ka laya nehana Nenao mai'nape?” nehuno hane hane hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yisasi'a Yutasife inake he “Vaya'nimoka hukefe e'nana yana makale ani kava ho.” huno nehike'a anileti vaya'moki u'a ayapi atafa hu'a alaki hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Atafa nehakeno Yisasi'ae hetino mai'nea ve'kamo'a aya maleno hakina avayu huteno ala mono nopi hokote kava ve'kamo ali'ya ve'ka'amo akesa aepafati heno hataka hutalekeno mopafi asaka hu lavi'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mopafi lavi'nea'maki Yisasi'a inake he “Hakina'ka ku'afi ete'ka aiyo. Hakinaleti la nehaya vayana hakinaleti hapaesake'a fali'a fanane hukae. ");
INSERT INTO ino_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fanane hukaya'maki nakaeya Afo'nimoteka afikesukeno nayatala'a hano huteno aiyalekati aole ali'nea nofi vaya'aipati la nehaya vaya'a apa'kaseno 70 tauseni (70,000) ko'ku'napi kayo kayo vaya nau vaisaya yafe hupatesike'a esaya yafe o'afi'nape? ");
INSERT INTO ino_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nakaeya ani yafe afikesuke'a nau vaisayana hana ya huno Anumaya Koti avopi kemo'a nakaeyafe ‘Ina kava hutesakeno falike.’ hu'a hu'naya ke fole aino ne'ya'a alitesikeno lamake huke?” ");
INSERT INTO ino_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","56","Yisasi'a ani afina atafa hu'naya vaya'aife inake nehe “Mako vaya nehapano kumaya ya nehea ve'ka atafa huke'kana kava hutapa lapa'kaeya hakina'ae heki kayo'ae ali'netapa nakaeya natafa hukefe e'naya'maki nakaeya mi'ko afina efi efi hu'na ala mono nopi hai'na mai'ne'na Anumayamo ke ali'na apaya hu'noa'maki lapa'kaeya ani kanafi natafa ohu'naya'maki ani mi'ko nakaeya nakufale nehaya kava'mo'a a'ke'ainaka apaune vaya'moki ka'naya kemo'a fole aino ne'ya'a alitekeno lamake hisea yafe ina kava hutapa natafa nehae.” Ani ke huno hano neheana mi'ko akaeya ke ne'afea anaka atale'a apaune he'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yisasina atafa hu'naya vaya'moki avale'a ala mono nopi hokote kava ve'ka Kaiyafasi nopi avale'a hai'nae. Ani nopi mono hapali'a hapa'nepaiya vaya'ae Isaleli ala ala vaya'ae ali'a atalu hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita'a Yisasi a'kame u'nea'maki hau'ale o'uno alu'ale ne'uno ala mono nopi hokote kava ve'kamo no kuma keki'ya vekofi haino mai'neno Yisasina hutesaya ya akekefe ati vaya'ae lo'kano mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mi'ko mono nopi kava vaya'ae Kanisole vaya'moki'ae “Mako vaya'aife ke hisunake'a e'a apa'ke'atike nehu'a ‘Yisasi'a ina hao'otake kava nehiketa ake'nona ve'kae.’ hu'a lahapaisaketa haesunakeno falise.” hu'a apa'ke'atike ke hutesaya vaya'aife kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Kahau a'nayana nesu vaya'moki e'a haviku ke nehu'a Yisasife “Ina kava ma kava huno hao'otake kava hu'ne.” hu'a hu'naya'maki Yisasina haesaya hao'otake kava'a o'ake'nae. O'ake'naya'maki aole ve'kala'mokani heti'ana Yisasife inake hu'ana neha'ae “La'akaeya akaeya hu'nea ke ako afi'no'ana inake hu'ne ‘Nakaeya Anumaya Koti ala mono nona ali'na kapelete'na aole'ae mako'ae kanafi ete'na kikoe.’ hiketa'a afi'no'ae.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Neha'akeno ala mono nopi hokote kava ve'kamo'a hetino Yisasife inake huno afine'ke “Kakaeya mako ke ohukape? Kakaeyafe ‘Ina kava ma kava hu'ka hao'otake kava hu'nana ve'ka mai'nane.’ hu'a hune'kataya'maki kakaeya na'yane hu'ka kakesa ne'afine?” ");
INSERT INTO ino_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Inake huno Yisasife afine'kea'maki alaki lamake huno ke huno o'ami'ne. O'amikeno ala mono nopi hokote kava ve'kamo'a Yisasife inake he “Nakaeya Anumaya Koti'a avamu'a hane'nikeno mai'nea Ne'mo akile kafine'koki kakaeya alaki lamake ke nahapaiyo. Kakaeya Anumaya Koti'a lakufa alino katiseafe hukate'nea ve'ka Kalaisika Anumaya Koti Mafa'ne mai'nape?” ");
INSERT INTO ino_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nehikeno Yisasi'a akaeyafe inake he “Kakaeya ani ke alaki ako hai nehane. Nehana'maki nakaeya mi'ko vaya lahapa'nepauve ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kake'na henaka'a nakesake'na ala lo'kiya'a hane'nea Anumaya Koti aya lamaka mai'ne'na ko'ku'nate hiyapi esuketapa nakekae.” ");
INSERT INTO ino_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nehikeno ani ke hea yafe ala mono nopi hokote kava ve'kamo aipamo'a atu hekeno kena'a alino vala aine'ataleno inake he “Anumaya Kotife huno haviya hune'ateketa akai'a avayafati ako hai afunanaketa mako vaya'aife ke hisunake'a mako akufa ke Yisasife laha'opaisae. ");
INSERT INTO ino_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ani ke afea yafe na'yane lapa'kesa ne'afe?” huno apafikeke'a ani vaya'moki inake hae “Lamake hane hao'otake ya'amo anona'a haesakeno falise.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Mako vaya'moki Yisasi aukosafi aepa he'a apavaitu'na hene'ate'a mi'kimi kayo ne'amakike'a mako'amoki apaya ali'a ataleli'ne'a ne'amaki'a inake nehae “Nala'a ne'kamakifi kakaeya kaune ke hu'ka fole ai'ka lahapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita'a ani no'mo ma'aileka kekitalofepi mai'nikeno mako ali'ya a'mafa'nemo'a aketeno amete ne'eno inake he “Kalili koteka ve'ka Yisasi'ae kakaeya lo'katana ne'mai'a ve'kafi hu'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nehikeno mi'ko vaya'ai apaulakale Pita'a inake he “Nakaeya o'afi'noa ke nehane.” huno vane hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Vane hune'ateno ma'aileka no kipate lavino mai'nikeno mako ali'ya a'mafa'nemo'a Pitana aketeno anile heti'naya vaya'aife inake he “Ma ve'ka Nasaleti mafa'ne Yisasi'ae lo'kano ne'maiya ve'ka mai'ne.” ");
INSERT INTO ino_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nehikeno Pita'a inake he “Nakaeya alaki lamake nehoe lapa'kaeya hu'naya ve'ka nakaeya no'akoa ve'kae nehae.” huno vane hute'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Vane huteno anile aise kana mai'nike'a akaeya'ae heti'a mai'naya vaya'moki Pitafe inake hae “Lamake kakaeya Kalili ve'kake'ka kake ne'aina kakele afita aeto nehunana kakaeya Yisasi'ae ne'maina ve'ka mai'nane.” ");
INSERT INTO ino_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nehakeno Pita'a inake he “Nakaeya alaki lamake ohisukeno'aena Anumaya Koti namakise hu'na Anumaya Koti aulakale lahapa'nepauve. Lapa'kaeya nehaya ve'ka nakaeya no'akoa ve'kae nehae.” huno nehikeno anile ko'kole ake ai'ne. ");
INSERT INTO ino_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ake aikeno Pita'a afiteno Yisasi'a hu'nea ke akesa afino hao hu'ne. Yisasi'a mako afina inake huno hapai'ne “Ko'kole ake o'ai'nisike'ka kakaeya aole'ae mako'ae afina nakaeyafe ‘O'ake'noa ve'ka mai'ne.’ hu'ka vane hunatekane.” huno hu'nea ke Pita'a akesa afino hao huteno ma'aileka hatilavino lusi avi le'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Kotike'a mi'ko mono nopi kava vaya'ae Isaleli nofi vayapati ala ala vaya'ae Yisasina haesakeno falisea veke vake hute'a Yisasina nofi kitete'a ala kamani ve'ka Pailati ayapi ate'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Yutasi'a Yisasina avaleno kame vaya'amoki apayapi ate'nea ve'kamo'a akeana Yisasina kake hutete'a “Falikane.” hu'a hutakeno aketeno lusi hautakiteno aku akesamo'a aino yahae hikeno halate eteno ani aole'ae mako'ae kayo (K30.00) moni ku mono nopi kava vaya'ae Isaleli nofi vayapati ala ala vaya'aite'ae alino u'ne. Alino uno inake he “Nakaeya alaki hao'otake kava hu'na kame vaya'ai apayapi hao'otake ya'a o'male'nea ve'ka ate'noanake'a haesakeno falike. Miyatapi etetapa aleo.” nehea'maki apa'kaeya inake hae “Lakaeya ya ohane'niki kakai'ka yane.” hu'a hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hutetakeno Yutasi'a ani moni ku ani mono nopi yaka hune'ataleno uno akai'a ayapati nofi alino yosale ane'mu ano fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mono nopi kava vaya'moki ani moni alite'a inake hae “Mani moni ‘Vaya haeyo.’ moni hake'naya mone Anumaya Koti kemo'a inake huno hu'ne ‘Ani akufa moni mono nopi moni'ae alitapa makopi o'maleo.’ huno hu'ne.” ");
INSERT INTO ino_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hute'a mako ke hu'a hayate'a “Ani monileti afaki kotekati vaya falisaketa kipatesuna mopa samo alo nehaya vaya'aiteti miya hesune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ina kava haya yafe ani mopamo aki'a Kola Mopae hu'a aki ne'ae. Hu'a aki male'naya mopa meni afa'a hane'nike'a ani aki ne'ae. ");
INSERT INTO ino_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ina kava hakeno a'ke'ainaka Yelemaeya'a Anumaya Koti aune ve'kamo avayafati hu'nea kemo'a fole aino ne'ya'a alitekeno lamake hu'ne. Ani kemo'a make hu'ne “Isaleli vaya'moki inake hae ‘Yisasina lavelisanaketa haesunakeno falisea miya kamikune.’ Ani aole'ae mako'ae kayo Anumayamo'a nahapai'nea ya hu'a ani monileti mopa samo alo nehaya vaya'ai mopa miya he'nae.” hu'neane. Ani mopa miya haya afina ani kemo'a fole aino lamake hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisasi'a ala kamani kava ve'kamo aulakale hetikeno ani ala kamani kava ve'kamo'a Yisasife inake huno afine'ke “Kakaeya Yuta vaya'ai yahauve ve'ka'api mai'nape?” huno afikekeno Yisasi'a inake he “Kakaeya'ka ani ke hai nehane.” ");
INSERT INTO ino_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nehikeno mono nopi kava vaya'ae Isaleli nofi vayapati ala ala vaya'ae Yisasife “Mani hao'otake kava nehe.” hu'a kake hute'naya'maki ke'apilena alaki mako ke ohu'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mako ke nohikeno Pailati'a mako'ae Yisasife inake nehe “Akeko mi'ko hao'otake kava hu'nana ya'ka hu'a fole aine'kataya ke alaki no'afipe?” ");
INSERT INTO ino_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hikeno Yisasi'a eteno mako ke anona'a ke'ale ke ha'opaikeno ani ala kamani kava ve'kamo'a akesa afino “No'akoa kava nehe.” huno amo'yo ne'aino akesa afino alu ala hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kafu'ae kafa'ae Anumaya Koti'a apa'kufa alino kati'nea afinafe apa'kesa afi emu ne'kikeno Pailati'a mi'ko ani emu ki afina mako nofi hupatake'a ne'maiya vayapati mi'ko vaya'yakamoki aki a'a asaka haya ve'ka “Nofipati hai hano hanaki uvo.” huno mi'ko kafu'ae kafa'ae hupate hupate hu'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ani kanale mako ve'kamo'a lusiya huno atalave atalava kava huno hao'otake kava nehea ve'ka atafa hu'a nofi hutakeno nofi nopi mai'ne. Ani ve'kamo aki'a Yisasi Palapasi'ae. ");
INSERT INTO ino_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mako ve'kamo aki akefe mi'ko ve a'ne ali'a anupa hu'nakeno Pailati'a make huno apafine'ke “Lapa'kaeya nalafe nofi nopati hutesukeno lapa'kaeyateka visea yafe nelahapaiye? Nakaeya Yisasi Palapasina hutesukeno visifi Yisasi'a Anumaya Koti'a lakufa alino katiseafe hute'nea ve'ka Kalaisi'ae hu'a aki ne'aya ve'ka hu'na hano hutesukeno vise?” ");
INSERT INTO ino_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailati'a ne'afeana Yuta vaya'moki ma akufa apa'kesa ne'afe “Mi'ko vaya Yisasiteka u'a akaeya keke afite'a lakaeya ke no'afe.” hu'a nehae. Apa'kai'api ke no'afea yafe Yisasife apaipamo'a haviya nehike'a Pailatite avale'e'a ate'nakeno Pailati'a ani ya afi'nea yafe ke huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apafikeno Pailati'a kake hune'apataya fai mai yate fai ne'maikeno a'amo'a “Ma ke hapaiyo.” huno mako ve'ka hutekeno Pailatite eno ani hapaiyo huno hu'nea ke hapai'ne. Inake he “Hani'ainaka Yisasife himonafi ake'noa ya'mo'a naipamo'a kana neheanaki ani ve'ka alakepa ve'ka mai'neanaki mako akufa kava huo'ato ke hapaiyo.” huno hea ke hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hapai'nea'maki mono nopi kava vaya'ae Isaleli ala ala vaya'ae u'a mi'ko ve a'nemoki apaipafi hu'a vakali nehu'a inake hu'a hapa'nepaiye “Make hutapa heo ‘Palapasife afa'a atalekeno eno.’ nehutapa ‘Yisasife yofo yosale falino.’ hutapa heo.” hu'a apa'ku apa'kesa apami'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Apami'nakeno Pailati'a mako'ae make huno apafine'ke “Ma aole netalapatina nakaeya nalana hutesukeno vise hutapa nehae?” hike'a “Lakaeya Palapasina hutesanakeno eno hutae nehune.” ");
INSERT INTO ino_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nehakeno Pailati'a ani vaya'aife inake he “Ani kava hisoana Yisasi'a Anumaya Koti'a lakufa alino katiseafe hute'nea ve'kae hutapa nehaya ve'ka Kalaisina na kava hutesoe?” huno apafine'keke'a apa'kaeya ala kefati inake hae “Yofo yosale nili aitetapa asaikeno falino.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nehakeno Pailati'a inake huno apafine'ke “Na'ya hiketapa ani ke nehae? Hana akufa hao'otake kava hu'ne?” huno apafine'kea'maki apa'kaeya eta'a ali'a alapi male'a ala kekefafati inake hu'a nehae “Yofo yosale nili aitetapa asaikeno falino.” ");
INSERT INTO ino_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nehakeno mi'ko vaya'moki haya kemo'a Pailati hea ke hu'a ati'ka ne'ate'a makale'a la hisaya kava nehakeno Pailati'a afeana ke hea kemo'a amu o'malekeno mi'ko vaya'ai apaulakale li alino aya sese nehuno inake he “Mako aise hao'otake ya'a o'male'nea ve'kamaki lapa'kaeya ‘Hakaune.’ hayanaketapa haesakeno faliseana lapa'kaitapi yanakeno mani ve'kamo kola'mo'a nakaeya nayapi o'malesikeno kumi'ni o'malesifa lapa'kaeyatapile kake hanemaleno hanese.” huteno aya sese nehe. ");
INSERT INTO ino_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ani ke nehike'a mi'ko vaya'moki inake hae “Lakaeya haesuna kumi'mo'a lakaeyate eteno mi'ko alipatesuna mafa'neyakamoki'ae ani kumi alisae.” ");
INSERT INTO ino_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hakeno Pailati'a Palapasife “Nofi nopati hano hane.” huno apamiteno Yisasina nofi kayoteti sefu amite'a yofo yosale nili aite'a asaikeno falisea yafe ati vaya'amoki apayapi ate'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hokote kava ve'kamo ati vaya'moki Yisasina avale'a no'mo haopaleka avale'a hai'a ate'ne'a anile ne'maiya ati vaya'aife eo hake'a e'a ali'a atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Atalu hu'ne'a akufale havaili'nea kena hate'a ne'atale'a mako ala kava ve'kamo haesa yatala kena ali'e'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Havaitete'a mako aufe nofiteti ali'a kalaki'a ka'kolita alo hute'a ali'e'a akenopale vaitete'a mako a'kapa kayo ali'e'a lamaka ayapi ami'ne'a aiyafi apale'ya nefai'a kiki hune'ate'a hu'a haviya havaya hutekefe inake nehae “Hae Yuta vaya'aipi ala yahauve ve'ka mai'nape?” ");
INSERT INTO ino_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hune'ate'a aukosafi apavaitu'na hene'ate'a ani a'kapa kayoteti akenopale amaki'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hu'a haviya hune'ate'a kiki hutete'a haesa kena hate ne'atale'a akai'a kena halate ali'a havaitete'a yofo yosale nili aite'a asaimale'nisakeno falisea yafe avale'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yisasina avale'a ne'u'a Saimoni'a Sailini kumateti ve'ka'ae kateka fotu hute'a ati vaya'moki atafa hute'a yofo yosa ali'a kofitete'a “Ali'ka uvo.” hu'a hakeno alino ne've. ");
INSERT INTO ino_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Alino ne'vike'a Yisasina avale'u'a Kolokatae nehaya kumate va'yi nehae. Ani kuma'mo aki'a lakaiti kefati Akenopa Ayamufae hu'a aki ne'ae. ");
INSERT INTO ino_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ani ati vaya'moki “Haesunakeno faliseana akufa akafu ki yafenaketa akufa akafu o'kisea li nese.” hute'a mako atu li'ae nofi alakamo li'ae ali'a makopi akunaku hute'a amikeno mako aise ya'a ne'nea'maki Yisasi'a ani life “He'e o'nekauve.” huno no'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","O'neke'a yofo yosale nili aite'a asaimale'ne'a kena'a fa'ko fa'ka hukefe kasi yo'kalokana akufa yo'kalo nelesakeno apa'kaseno haisea ve'kamo'a ani kena alite alite hisae hu'a ani yo'kalo lete'a ali'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Alite'a mai'ne'a anile yakai'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nili ai'a asaimale'ne'a Yisasi akenopale “Ma kava hiketa ha'none.” hu'a avo kamale'nae. Ani kamale'naya avo'mo'a “Ma ve'ka Yisasi'a Yuta vaya'ai hokote yahauve ve'kae.” hu'a kamale'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kate'a Yisasi'ae aole ve'kala vaya nehapa'ana kumaya'ya neha'a ve'kala mako ve'ka aya lamaka aupalika yofo yosale nili aite'a asaimalete'a mako ve'ka haoka aupalika nili aite'a asaimale'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kate u'e'a haya vaya'moki apa'kenopa ke'ka hune'ate'a “Hao'otake ve'ka mai'nane.” nehu'a kiki hune'ate'a hu'a haviya hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Inake hu'a nehae “Oho kakaeya ‘Ala mono no ali'na kapeletalete'na aole'ae mako'ae afina makale ete'na kikoe.’ hu'ka hu'nana ve'ka mai'nape? Inaki kakaeya Anumaya Koti mafa'ne mai'ne'kaefena meni kakaeya'ka kakufa ali'ka katisana yafe inani mai'nana yofo yosaleti ne'atale'ka eli'keketa kakeno.” ");
INSERT INTO ino_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ala mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae Isaleli ala ala vaya'moki'ae ani kava hu'a hu'a haviya hute'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Inake nehae “Vaya apa'kufa ako alino katipate'nea'maki akai'a akufa alino no'kate. Kalaisi'a Isaleli vaya'aite hokote yahauve ve'ka'api yofo yosaleti ataleno eli'nesiketa aketeta ‘Akaeya lamake nehe.’ huta akaeyafe afita laipafi malekaune.” nehu'a hu'a haviya hune'atae. ");
INSERT INTO ino_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Anumaya Koti Mafa'ne mai'noe huno nehea ve'kamakeno Anumaya Kotife ame'atiti nehuno afino aipafi male'nininana Anumaya Koti'a akaeyafe hau'nisikeno'aena meni akufa alino katise.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hu'a haviya hune'atake'ana akaeya'ae yofo yosale nili aite'a asaimale'naya ve'kala'mokani'ae ani kava hu'ana Yisasina hu'ana haviya hune'ata'ae. ");
INSERT INTO ino_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yakemo'a haineno folaka'nalaka nehikeno aepa heno mi'ko koteka hani huteno une yake lavino falekefe nehikeno ko alino hale'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ani une yake lavino falekefe nehikeno Yisasi'a ala kefati ke nehuno akai'a kefati inake he “Eli Eli lema sapa'katani?” Lakaeya kefati ani kemo'a make hu'ne “Anumaya Koti'nimoka Anumaya Koti'nimoka na ya hike'ka kakaeya ne'natalane?” ");
INSERT INTO ino_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nehike'a mako anile heti'naya vaya'moki ani Yisasi hea ke afite'a inake hae “Afikeo Ilaiyafe ke nehe.” ");
INSERT INTO ino_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nehakeno makale mako ve'kamo'a uno hake lipati ka'ki'nofakana ya asava'neno atu'ake nofi alakamo lipi ateno a'kapa kayote maleno kimale'neno Yisasina “Amisukeno mayu mayu huno nese.” huteno ami'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amikefe nehike'a mako vaya'moki ani ve'kae inake hae “Atale'nekeno'ao Ilaiyafe ke neheanaketa akeva mai'nisunakeno Ilaiya'a eno yofo yosaleti akufa alino katisifi? Akeketao.” nehae. ");
INSERT INTO ino_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nehakeno Yisasi'a mako'ae ala kefati ke nehikeno aku mafa'ne'a atalekeno fali'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Falea kanatofi ala mono nopi mako lapa'ake kenaleti hakaya amale'naya kenamo'a hanaleti aepa heno folakapati vala aino afete lavikeno aole alino hapa'nikeno mopamo'a imima ne'alikeno ala ala yafa aino a'kalafa'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aino a'kalafa'nikeno falike'a kipate'naya vaya'ai kelimo'a ha'kalo hike'a a'ke'ainaka Anumaya Kotiteka apa'ku'a ami'naya vaya falike'a kipate'naya vaya ete'a heti'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ani kelifati atale'a heti'a mai'nakeno Yisasi'a henaka'a fali'neapati eteno hetike'a fate akufa kumate Yelusalemu haike'a nesu vaya'moki apa'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ati vaya'aite kava ve'ka'ae mi'ko ati vaya'ae yakai'a mai'ne'a akayana mopamo'a imima ne'alino mi'ko va'yi hea ya akete'a lusiya hu'a koli nehu'a make hae “Lamake mani ve'ka Anumaya Koti alaki Mafa'ne'a mai'ne.” ");
INSERT INTO ino_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nesu a'neyaka Kalili kumate mai'nayateti Yisasina aya hu'a a'kame hafai'a e'nae. E'naya a'nemoki alu'ale heti'a mai'ne'a ake'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ani a'neyaka'ai folakapi mai'naya a'nemoki apa'ki'a Makatala kumateti Malia'ae hamo'amo'a Yemisi'ae Yosesi'ae ita'animo'ae mako ana Sepeti mafa'nela'mokani ita'animo'aki hu'a ani folakapi mai'nae. ");
INSERT INTO ino_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Une yake lavino falekefe nehikeno Yosefe'a Alimatia kumate ala moni afeno male'nea ve'ka e'ne. Ani ve'ka Yisasi ke ne'afea ne mai'neno Pailatite uno “Yisasi akufa alisoe.” huno afine'ke. Afine'kekeno Pailati'a ati vaya'aife hupateno inake he “Kanalenaki Yisasi akufa alitapa ameo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hapapaike'a ati vaya'moki Yisasi akufa ali'a amikeno Yosefe'a ani Yisasi akufa alino mako honi'ya o'male kenafi haya vai'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Haya vaimaleteno saufa akai'a kafimale'nea kelifi Yisasi akufa kite'ne. Ani keli mako ala yafapi kafafaimale'nea yafa kapi kiteteno avayale mako ala yafa'kefa alino helave huno aino a'kanimaleteno u'ne. ");
INSERT INTO ino_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Uteke'ana Makatala kumateti Malia'ae mako hamo'amo'ae ani kelile mai'ne'ana ake'ana mai'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Sapati kanamo ne'ya ali'a avatati hu'a havate'a Sapati natema'a ala mono nopi kava vaya'ae Falasi mono ke ne'afea vaya'ae ala kava ve'ka Pailatite u'a anupa nehu'a inake hae “Ala Nenao ani ake'atike'ake ve'ka afa'a mai'nea afina inake huno lahapai'ne ‘Nakaeya aole'ae mako'ae afina maite'na kelifati hetikoe.’ huno lahapai'nea ke lakesa ne'afune. ");
INSERT INTO ino_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ani ke hu'nea yafe kakaeya lo'kiya ke hisanake'a ani keli avayale ai'a a'kanile'a alaki humalesakeno lo'kiya vaino hanesike'a aole'ae mako'ae afina yakaisae. Haviku akaeya ke ne'afea anaka'moki ani kelifati Yisasi akufa kasake'a ali'u'a vaya'aife ‘Akai'a fali'neapati eteno kelifati hetino u'ne.’ hu'a hisae. Hisakeno apa'ke'atike ke hisaya kemo'a hokoteno hu'nea ke ‘Anumaya Koti mafa'ne mai'noe.’ huno hu'nea ke akasekaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nehakeno Pailati'a inaki huno hapa'nepaiye “Yakaisaya ati vaya lapamisuketapa ani kelile apavaletapa utapa lapa'kaeya lo'kiya vai'a yakaisaya apa'ku apa'kesa apamike'a yakai'a alakepa heo.” ");
INSERT INTO ino_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nehike'a u'a ani kelile kimale'naya yafate a'kameleti a'a alaki humalete'a mako ati vaya'aife “Yakaiyo.” hu'a hupate'nae. ");
INSERT INTO ino_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sapati afina hano hutekeno Sota afina yake haineno va'yi hukefe nehikeno Makatala kumateti Malia'ae hamo'amo'ae Yisasina kite'naya keli akekefe ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ne'va'akeno lusi imima ne'alikeno Anumayamo ko'ku'napi kayo kayo ve'ka ko'ku'na ataleno elineno male'a la'kamale'naya yafa ano atufa ne'ataleno ani yafa'mo akofetule fai mai'ne. ");
INSERT INTO ino_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Fai mai'nikeno aukosamo'a kopasi'na ne'alike kana huno ano ha nelekeno kena'amo'a yave yave huno efe'ake hiya'kana nehe. ");
INSERT INTO ino_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ani kava nehike'a kite'naya kelile kava yakai'naya ati vaya'moki ani Anumayamo ko'ku'napi kayo kayo ve'ka akete'a atali atalu nehu'a apa'ko'ya nefai'a fali'naya vaya'kana nehae. ");
INSERT INTO ino_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ani kava hu'naya'maki ko'ku'napi kayo kayo ve'kamo'a ani atala'anife inake huno hanapai'ne “Lana'kaeya lanamo'yo o'ai'ao. Nakaeya afi'noana lana'kaeya yofo yosale ha'a asai'naya Yisasife kahau ne'a'ae. ");
INSERT INTO ino_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kahau ne'a'a'maki mafi o'mai'nifa ako heti'ne. Lahapapai'nea ke ako fole aikeno ako heti'niki eta haitana kite'naya kelifi ake'ao. ");
INSERT INTO ino_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aketetana naku naku hutana akaeya ke ne'afea anaka'aife inake hutana hapapai'ao ‘Yisasi'a falike'a kite'nayapati hetino Kalili uno hoko'neteki anileka utapa akekae.’ hutana hi'ao nehuno hai lahanapauki vi'ao.” nehe. ");
INSERT INTO ino_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nehike'ana ana'kaeya anamo'yo ne'ai'ana amuse nehu'ana naku naku hu'ana akaeya ke ne'afea anaka hapapaikefe ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne'u'ana makale Yisasi'ae fotu hute'ana Yisasi'a inake he “Ne'a'afe?” nehike'ana haute u'ana aiyale ali'ana soso nehu'ana aki ali'ana asaka hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aki ali'ana asaka neha'akeno Yisasi'a ana'kaeyafe inake he “Lanamo'yo o'aitana utana inake hutana nafu'nakanakife hapapai'ao ‘Kalili utapa nakekae.’ hu'ne hutana hapapai'ao.” ");
INSERT INTO ino_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aole atala saufa kateka ne'va'ake'a ani kelile yakai'a mai'naya ati vaya'moki ala kumapi hai'a ala mono nopi kava vaya'aife mi'ko ya fole aike'a ake'naya yafe hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hapapaike'a ala mono nopi kava vaya'moki u'a Isaleli nofi vaya'ai ala ala vaya'ae ali'a atalu hu'ne'a ani ke hu'a fole o'aisaya yafe ke hu'a hayate'a ani ati vaya'aina lusi moniyako hake'a apami'nae. ");
INSERT INTO ino_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Make hutapa heo ‘Hani'ainaka lau'kale'nonake'a akaeya ke ne'afea anaka'amoki Yisasi akufa e'a kasake'a kumaya ali'a u'nae.’ hutapa heo. ");
INSERT INTO ino_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pailati'a ala kamani ve'kamo'a mani akufa ke afisiketaena lakaeya mako akufa ke hapaikunanaketapa lapa'kaeya mako kana ya o'alikae.” ");
INSERT INTO ino_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Inake hake'a ani ati vaya'moki ani moni alite'a ani hapapai'naya akufa kava hu'a a'kame male'nake'a mi'ko Yuta vaya'aipi maleno atakufa'nea keke'a meni'ae ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yisasi'a ayatala'a hano huteno aiyalekati mako'ke alea anaka (11) anaka'aife “Kalili avimapi veo.” huno hapapai'neanake'a hai'nae. ");
INSERT INTO ino_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hai'a Yisasina akete'a aki ali'a asaka nehaya'maki makoma'amoki aole apa'kesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","19","Yisasi'a eno ani mai'naya vaya'aife inake he “Anumaya Koti ko'ku'nate'ae mopale'ae kava yakaisoa lo'kiya'ni nami'nea yafe lapa'kaeya mi'ko aupalika utetapa nehutapa nakaeya ke hapapaike'a afi'a alakepa hu'a afite'a apaipa ai'a yahae hu'a namisaketapaena Afo'nimo akile'ae nakai'ni nakile'ae Fate Akufa Avamu'mo akile'ae li falepateo. ");
INSERT INTO ino_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Li fale ne'apatetapa nakaeya lahapapai'noa ke hapa'nepaitapa ‘A'kame maleo.’ hutapa alitapa apaya heo. Akekeo nakaeya lapa'kaeya'ae mi'ko afina maike maike hu'na ma mopa hano hukefe hisea afina'ae olapatalekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yisasi Kalaisi'a Anumaya Koti mafa'ne'amofe kanale ke aepa heno huno fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anumaya Koti aune ve'ka Aisaiya'a avopi inake huno kamale'neane Anumaya Koti'a inake he “Afeo ke alinuno hapapaisea ve'ka'ni hutesukeno Yisasika visana kate uno hoko'neteno ka valino halekatekaiye.” ");
INSERT INTO ino_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Vaya o'mai aupalikati mako ve'kamo'a kate kate nehuno inake he “Anumayamo esea kana valitapa alakepa nehutapa alitapa avatati heo.” hu'neane. ");
INSERT INTO ino_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoni'a li falepatesea ve'ka va'yi huno ka'me aupalika mai'neno inake nehe “Lapa'kaeya lapaipa aitapa yahae nehutapa hao'otake yatapi atalesake'na li fale nelapatesukeno Anumaya Koti'a hao'otake yatape lapahaove lapatove nehuno aipa yuna yapati alino atalelapatekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ani afina Yelusalemu vaya'ae Yutia vaya'ae Yoni mai'neateka u'a hao'otake kava nehaya ya'api hu'a fole ne'aikeno Yoni'a ani Yotani lipi li falepate'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni'a mako kamolo hu'a aki ne'aya afumo ayo'kaleti kena'a alo huno havai'ne. Puluma'kamo akufaleti kamai nofi alo huteno afafale ne'ano ne'ya'a kenu kafa'ae alumemo li'ae ne'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yoni'a inake huno hapapai'ne “Nakaeya na'kame mako ve'ka ako ekaiye. Ani ve'kamo'a nakaeya nakaseno lusi lo'kiya'a hane'nea ve'kakeno nakaeya ako nakase'neanake'na nakaeya afa ve'ka akaeya aiya'kale aesoana o'natekaiye. ");
INSERT INTO ino_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nakaeya litafateti fale nelapatoanakeno ani ve'kamo'a Anumaya Koti Fate Akufa Avamu'aleti falelapatekaiye.” ");
INSERT INTO ino_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ani afina Yisasi'a Kalili aupalika hane'nea kumana Nasaleti kumateti ekeno Yoni'a Yisasina Yotani lipi falete'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Li faletetekeno Yisasi'a lipati makale aino he'netino akeana ko'ku'na'mo'a halekeno Anumaya Koti Fate Akufa Avamu'amo'a namakana huno akaeyate haleno eline'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Elino ne'ekeno ko'ku'napakati mako ake aiya kemo'a inake he “Kakaeya nakai'ni mafa'ne'nimoka kakaeyafe lusiya huno nahau nayamopafati ne'nahaiya mafa'ne'ni kakaeyafe lusiya hu'na amuse'ka nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Anumaya Koti Fate Akufa Avamu'amo'a Yisasina vaya o'mai ka'me aupalika avaleno u'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ne'vikeno Sata'a Yisasife “Havi kava ho.” huno ano avataka hikeno aole ve'kala'mokani anaiya anaya hano hea afina (40 afina) Yisasi'a anile afela afu anaka'ae mai'nikeno ko'ku'napakati kayo kayo vaya'moki e'a ha'ma'nae. ");
INSERT INTO ino_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yonina nofi hute'nakeno Yisasi'a Kalili koteka uno Anumaya Koti'a yakaipatesea kanale ke'a hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yisasi'a inake nehe “Anumayamo male'nea kana'a ako va'yi hu'nikeno Anumaya Koti kava yakailapatesea kana makale'a va'yi hukefe neheanaki lapa'kaeya lapaipa aitapa yahae nehutapa hao'otake yatapi ne'ataletapa nakaeyafe kanale ke hu'nea ke lamake nehe hutapa afitapa lapaipafi maleo.” ");
INSERT INTO ino_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kalili li kotu'mo aki'naleka uneno nehuno Saimoni'ae akana'amo'a Etalu'ae ana'ke'ne. Ana'keana faya ya neha'a ve'kala mai'na'a yafe ala lu'konako ku li kotupi yaka hu'ana ne'mala'ae. ");
INSERT INTO ino_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne'mala'akeno Yisasi'a inake huno hana'nepaiye “Na'kame e'ao. Na'kame esa'ake'na faya neha'a avamete vaya apavalesa'a yafe hulanatekauve.” ");
INSERT INTO ino_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hike'ana makale lu'konako'ani ne'atale'ana Yisasi a'kame ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ne'va'akeno Yisasi'a aisema'a ne'uno Sepeti mafa'nela Yemisi'ae Yoni'ae lipi kalefi mai'ne'ana lu'konako ku nefa'kani'akeno Yisasi'a uno ana'ke'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ana'keteno Yisasi'a ana'kaeyafe ke hike'ana Sepeti afo'animo'ae ali'ya vaya'a'ae lipi kalefi ne'apatale'ana a'kame ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Apa'kaeya Kapaneamu lavi'a mai'ne'a Yisasi'a Sapati afina mono nopi uno Anumaya Koti ke alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Alino apaya hu'nea kemo'a lo'kiya'a hane'nea ve'kamo kekana hu'nea yafe lusi apamo'yo ne'aike'a inake nehae “Mako mono hapali'a laha'nepaiya vaya'kana huno alino laya ohu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ani nopi mako ve'ka Sata afe'mo'a aipafi mai'nea ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mai'neno kalafa kae kae nehuno inake nehe “Avo Yisasika Nasaleti ve'kamoka na kava hulatesana yafe e'nane? Lakaeya laha'ka falilatekefe e'nape? Nakaeya kakaeyafe ako afi'noe kakaeya fate akufa ve'ka Anumaya Koti hukate'nea ve'ka mai'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nehikeno Yisasi'a Sata afefe lo'kiya ke ne'ama'kino inake nehe “Ke ohu'ka mani ve'kamo aipafakati atale'ka uvo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nehikeno ani Sata afe'mo'a aipafati atalekefe nehuno ani ve'ka aike amakike nehuno kalafa ne'kano aipafati ataleno hatilavi'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hatilaviteke'a mi'ko vaya'moki apamo'yo aite'a ani yafe ke hu'a imafi mafi nehu'a inake hae “Ma kavana hana kava nehe? Na akufa saufa ke nehe? Lusi lo'kiya'aleti ke hike'a Sata afe'moki akaeya ke afi'a a'kame male'a hatilavi'a u'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yisasi'a ani kava hu'nea avakemo'a mi'ko Kalili koteka uneno hike'a mi'ko vaya'moki afi'nae. ");
INSERT INTO ino_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yisasi'a Yemisi'ae Yoni'ae mono nopati atale'a Saimonikani Etalukani nopaka ne'vae. ");
INSERT INTO ino_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ne'vakeno Saimoni a'amo ita'amo'a amu'ko kali ali'nike'a makale'a Yisasina ani yafe hapai'nae. ");
INSERT INTO ino_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hapaitakeno Yisasi'a uno ayate alino heti ne'atekeno amu'ko kali'a ako hano hutekeno ne'ya kano ne'apame. ");
INSERT INTO ino_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Une yake lavino faleteke'a vaya'moki mi'ko kali vaya'ae Sata afe'mo apaipafi mai'nea vaya'ae Yisasite apavale'a ne'ae. ");
INSERT INTO ino_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Apavale'a ne'ake'a mi'ko ani kumate vaya'moki kipate e'a yake yake nehae. ");
INSERT INTO ino_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yake yake nehakeno Yisasi'a aki'ae aka'ae kali ali'naya vaya'aina alino kanale hune'apateno mi'ko Sata afe'yaka apaipafati alino ne'ataleke'a Sata afe'yakamoki Yisasife ako afi'naya yafe Yisasi'a inake nehe “Nakaeyafe ke oheo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Natena ko alino fanufane nehikeno Yisasi'a hetino ani nona ataleno vaya o'mai yateka uno Anumayamoteka ke huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Afine'keke'a Saimoni'ae mako vaya'ae akaeyafe kahau ame u'a ake'a avatete'a inake nehae “Mi'ko vaya'moki kakaeyafe lusi kahau ne'ae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nehakeno Yisasi'a apa'kaeyafe inake nehe “Nakaeya lahau'ale hane'nea kumate'ae ke hapapaisoa yafe e'noki anile viketao.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mi'ko Kalili aupalika ute ete nehuno mono nopi Anumaya Koti ke hapa'nepaino Sata afe'yaka vaya apaipafati alino apatale'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mako ve'ka fuko ya'mo'a akufa alino haviya hu'nikeno Yisasiteka eno ape hu'neno inake hu'ne “Kahaisike'kaena kali'ni ako ali'ka kanale hunataninine.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nehikeno Yisasi'a hau huteteno ayana aya huno akufale ame'ko nehuno inake he “He ne'nahaiya yafe kakufamo'a meni kanale hino.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nehikeno ani fuko kali'a makale kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Alino kanale huteteno Yisasi'a lo'kiya ke hapaino inake nehe “Ali'na kanale hukate'noa yafe mako ve'ka ha'opai'ka mono nopi kava ve'kale ukeno kakufa valava kano aketesike'a mi'ko vaya'moki kali'ka ali'na kanale hukate'noa ya afisae hu'kaena a'ke'ainaka Mosese hapapai'nea kava hu'ka ‘Ma ya Anumayamoteka ameo.’ huno hu'nea ya meni amisanake'a mi'ko vaya'moki ‘Kali'ka hano hu'ne.’ hu'a hisae. Amisana yafe makale uvo.” huno lo'kiya kefati ke hau'ne. ");
INSERT INTO ino_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nehea'maki ani ve'kamo'a uno kali'amo avake mi'ko vaya'aina hapapailitata hike'a nesu vaya'moki afite'a “Kaliti alino kanale hulatese.” nehu'a ete ete hu'naya yafe Yisasi'a mi'ko kumate mako'ae uneno ohuno alaki ma'ailekake vaya o'mai aupalika fala'kino uneno nehike'a mi'ko aupalikati vaya'yakamoki akaeyate ete ete hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yisasi'a aupa kana maiteno eteno Kapaneamu kumate uno mai'nike'a ani kumate vaya'moki “Yisasi'a ako eno nopi mai'ne.” hu'a haya ke afi'nae. ");
INSERT INTO ino_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Afite'a lusi vaya'moki e'a ani nopi ma'aileka'ae no kipa kumate'ae mai'a havaitete'a maisaya kumana o'male'nikeno Yisasi'a Anumaya Koti ke hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hapa'nepaike'a aole'ae aole'ae vaya'moki mako aiya aya fali'nea ve'ka sifanale havano mai'nike'a Yisasite hipo'ya ali'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ute'a Yisasi amete mani ve'ka ali'a haikefe hu'naya'maki lusi vaya'moki mako'ke apa'kufale a'kalo a'kalo hu'nake'a Yisasi amete ali'a haisaya ka alaki o'maleke'a ani Yisasi mai'nea no'kato'mule hai'a aisema'a hi'yakofa kasake male'ne'a ani aiya aya fali'nea ve'ka mai'nea sifana atalakeno Yisasi mai'nea amete lavi'ne. ");
INSERT INTO ino_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lavikeno Yisasi'a apa'keteno inake huno akesa afi'ne “Ani kali ve'kamo vaya'amoki nakaeya ke afi'a apaipafi male'nae.” huteno ani kali ve'kaena inake he “Mafa'ne'nimoka nakaeya hao'otake ya'ka ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Nehike'a mono hapali'a hapa'nepaiya vaya'moki anifi mai'nayateti inake hu'a apaipa apa'kesa ne'afe “Ma ve'kamo'a na kava hikeno ani akufa ke nehe? Inamona Anumaya Koti aki alino haviya nehe. Mako ve'kamo'a hao'otake yafe ‘Kahaove katove nehu'na naipa falu yapati ali'na ataletoe.’ huno hukea'maki alino o'atalekaifa Anumaya Koti akai'a mako'ke'amo'ke hao'otake yati alino ataleteno aipa falu ya lami'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nehakeno Yisasi'a aipafi makale'a afea apa'ku apa'kesa ako afiteno apa'kaeyafe inake nehe “Na'ya hiketapa lapa'kaeya mani hoa ke lapaipa lapa'kesa afitapa alu'ala nehae? ");
INSERT INTO ino_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nakaeya ne'aloa ali'ya hana ali'ya'mo'a kana'a hane'ne? ‘Hao'otake ya'ka ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.’ hu'na hoa ali'ya'mopi ‘Kali'ka ako ali'na kanale hukatoki heti'ka hipa'ka alite'ka uvo.’ hu'na hoa ali'ya'mo'ae? ");
INSERT INTO ino_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Ani yafe nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na mopale mai'ne'na hao'otake yatapi lahapaove lapatove nehu'na naipa falu yapati ali'na atalelapatesoa lo'kiya ya'ni'a hane'nea yafe lapa'kaeya afitapa halesaya yafe mako kava hu'na lapavelikoe.” nehuno ani aiya aya ayamufa mi'ko fali'nea ve'kae inake huno hapai'ne “Nakaeya kaha'nepauki heti'ka hipa'ka ne'ali'ka no'kaleka uvo.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hutekeno mi'ko vaya'ai apaulakale ani ve'kamo'a makale'a he'netino hipa'a ne'alino u'ne. Uteke'a mi'ko vaya'moki lusi apamo'yo ne'ai'a Anumaya Koti aki ali'a asaka nehu'a inake hae “Meni afina fate akufa lo'kiya ya ne'akone.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yisasi'a Kalili li kotu'mo aki'naleka u'nike'a lusi ve a'nemoki akaeyate vakeno Anumaya Koti ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hapapaiteno ka maleno ne'uno Livai'a Alafiasi mafa'nemo'a kumaya'ya hu'a vaya apa'kufaleti ta'kesi miya ne'alea note mai'nikeno akeno avateteno Yisasi'a Livaife inake he “Nakaeya na'kame eno.” huno hikeno Livai'a hetino Yisasi a'kame u'ne. ");
INSERT INTO ino_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Henaka'a Yisasi'a Livai nopi uno ne'ya ne'neke'a mi'ko vaya'ai apa'kufaleti kumaya ya hu'a ta'kesi ne'alea vaya'ae hao'otake kava nehaya vaya'ae Yisasi'ae akaeya ke ne'afea anaka'ae ne'ya ne'nake'a nesu ani akufa vaya'moki Yisasi a'kame u'e'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mai'ne'a ne'ya ne'nake'a mako Falasi mono ke ne'afea vayapi mono hapali'a hapa'nepaiya vaya'moki e'a akayana Yisasi'a hao'otake kava nehaya vaya'ae vaya'ai apa'kufaleti ta'kesi miya ali vaya'ae mai'neno ne'ya ne'neke'a akete'a Yisasi ke ne'afea anaka'aife inake hu'nae “Na'ya hikeno Yisasi'a hao'otake kava nehaya vaya'ae vaya'ai apa'kufaleti ta'kesi miya ne'alea vaya'ae ne'ya ne'ne?” hu'a apafine'kae. ");
INSERT INTO ino_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Apafine'kakeno Yisasi'a ani ke afiteno inake huno hapa'nepaiye “Kali'api o'male'nea vaya'moki Tota vaya'aite no'vaya'maki kali vaya'mokike Tota vaya'aite ne'vae. Nakaeya ma mopafi e'noana alakepa vaya'aife ke hisoa yafe o'me'noa'maki nakaeya hao'otake kava nehaya vaya'aife ke hisoa yafe e'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mako afina Yoni ke ne'afea vaya'ae Falasi mono ke ne'afea vaya'ae ne'ya mosi'nake'a mako vaya'moki Yisasite e'a inake hu'a afine'kae “Yoni ke ne'afea vaya'ae Falasi mono ke ne'afea vaya'ae ne'ya mo'nesea'maki na kava hike'a kakaeya ke ne'afea vaya'moki ne'ya mo'osi'a afa'a ne'nae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nehakeno Yisasi'a inake he “A alikefe nehea ve'kamo'a a alikefe hea afina maya hu'a ne kanale vaya'a'ae mai'nike'a ani vaya'moki ne'ya mosikafe? He'e a alikefe nehea ve'kamo'a apa'kaeya'ae mai'neanake'a mo'osikae. ");
INSERT INTO ino_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mo'osikaya'maki henaka'a mako fate kana va'yi hisikeno kame vaya'amoki ani a'mo anau'amona atafa hu'a apa'kaeyapati avalesaya kanafi vaya'amoki ne'ya mosikae.” ");
INSERT INTO ino_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yisasi'a inake huno hapapai'ne “Mako ve'kamo'a saufa kena atupa alino atafa kena vala ai'nea kate maleno nohate. Maleno hatiseana ako atata aikeanakeno saufa kenamo atupamo'a atafa kena alino vala aisikeno mako'ae ala huke. ");
INSERT INTO ino_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ani kava hu'a mako vaya'moki haekafa nofi alakamo lima'a mememo akufaleti alo humale atafa kepi la'ki'a no'vaiye. Vaisayana lima'a a'kapalu hakeno a'nu'ka hesikeno li kena halo aino la'kilavike. La'kilavino ani li'ae ke'ayo'ae alino haviya huke. Haekafa nofi alakamo lima'a hefino saufa mememo akufaleti alo humale kepina la'kino vaino. ");
INSERT INTO ino_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mako Sapati afina Yisasi'ae akaeya ke ne'afea anaka'ae kile hoyafi ne'u'a akaeya ke ne'afea anaka'moki ani kile hoyafati kile ne'atakae. ");
INSERT INTO ino_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne'atakake'a mako Falasi mono ke ne'afea vaya'moki apa'kete'a Yisasife inake nehae “Ake'nape? Na'ya hike'a Sapati kanafi he'e humale'nea kava ma vaya'moki ani ke ali'a ne'atakae?” nehae. ");
INSERT INTO ino_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nehakeno Yisasi'a apa'kaeyafe inake huno apafine'ke “Lapa'kaeya a'ke'ainaka Teviti'ae a'kame u'naya vaya'ae apa'kateke'a Teviti'a hu'nea kavafe kamale'naya ke hapalitapa o'ake'nafe? ");
INSERT INTO ino_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apa'katekeno Teviti'a Anumaya Koti nopi hai'neno afa vaya'moki o'nekafa mono nopi kava vaya'amokike nekae huno ke male male'nea kemo'a he'e humale'nea ne'yana Anumaya Koti aulakale male'naya kai hame'ya maya Teviti'a alino ne'neno akaeya'ae u'naya vaya'ae apamike'a ne'nae. Ani kanafina Apaiyata'a ala mono nopi hokote kava ve'ka mai'nea afinane.” ");
INSERT INTO ino_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yisasi'a Falasi mono ne'afea vaya'aife inake he “Anumaya Koti'a vaya alo hu'neana Sapati kana ha'maesaya yafe alo ohu'nea'maki Anumaya Koti'a vaya hapa'maesea yafe Sapati kana alo hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ani yafe ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na ani Sapati kanalena kava yakai'na mai'noe.” ");
INSERT INTO ino_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisasi'a eteno mono nopi haino akeana mako kaya aya fali'nea ve'ka anile mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mai'nike'a mako vaya'moki Yisasi'a hao'otake kava nehe hu'a hisaya kafe kahau a'a akekefe “Yisasi'a Sapati kanafi ani kali ve'ka alino kanale hutesifi huo'atesifi?” hu'a Yisasina amata hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Amata hu'a mai'naya'maki Yisasi'a aya fali'nea ve'kaena inake huno hapaiye “Vaya folakapi e'ka heteo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huteno Yisasi'a amata hu'naya vaya'aife inake huno apafine'ke “Sapati kanaena Anumayamo kemo'a na'yane ke hu'ne? Sapati kanafi vaya alita kanale hupatesupi alita haviya hupatesune? Sapati kanafina vaya apaya huta apa'kufa alita katisupi vaya apamakisunake'a falisae? Lapa'kaeya na lapa'kesa ne'afe? Anumayamo kemo'a na'yane ke nehe?” huno apafine'keke'a ke ohu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ke ohu'a maikeno Yisasi'a hai ne'vaino mi'ko vaya'moki apaulakaleka akeme uneno heana aipamo'a haviya nehikeno apa'kaeya apaipa apa'kesamo'a a'kanile'nea yafe kalaki aine'apateno aya fali'nea ve'kae inake huno hapaiye “Kaya ali'ka api aiyo.” hikeno alino api ne'aikeno ako kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kanale hute'nea'maki Falasi mono ke ne'afea vaya'moki mono nopati atale'u'a Heloti ke ne'afea vaya'ae ali'a atalu hute'a “Yisasina hana'ya huta haesunakeno falise?” hu'a huke afike hu'a veke hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Veke nehakeno Yisasi'ae akae ke ne'afea anaka'ae Kalili li kotu hane'neateka vake'a lusi vaya Kaliliti a'kame ne'vae. Yutiati'ae Yelusalemuti'ae Itumiati'ae Yotani li falika vaya'ae Taiyati'ae Saitoniti'ae mi'ko vaya'moki Yisasi'a hu'nea avake'a afite'a akaeyateka ne'vae. ");
INSERT INTO ino_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ne'vakeno akaeya ke ne'afea anaka'ae inake nehe “Lusi vaya ali'a atalu nehayanake'a nakaeya a'a natufalitata hu yafenaki lipi kale alita avatati hunateo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hokoteno lusi vaya'ai kali alino kanale hupate'nea yafe mi'ko kali vaya'moki ame'ko alisaya yafe a'a atufa'nayane. ");
INSERT INTO ino_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A'a atu nefakeno Sata afe'yakamoki vaya'ai apaipafi mai'ne'a Yisasina akete'a aulakaleka e'a apa'ko'ya nefai'a kalafa nehu'a inake hu'a nehae “Kakaeya Anumaya Koti mafa'ne mai'nane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nehakeno Yisasi'a lo'kiya kefati inake hu'ne “Ani ke mako vaya'aife utapa hutapa fole aitapa hapa'opaiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yisasi'a avimapi haino mai'neno akaeya haiya vayama'a ke hike'a akaeyate hai'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Haikeno ani vayapati nayatala'a hano huno naiyalekati aole alea vaya le'kanapaiteno “Nakaeya'ae lo'katapa mai'nisake'na nakaeya ke hutapa fole aisaya yafe hulapatesoa vaya (Aposolo vaya) maiyo.” huno hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","“Sata afe'yaka vaya'ai apaipafati hapafaitalesaya lo'kiya'ni'a lapamikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ani nayatala'a hano huno naiyalekati aole alea anaka'moki apa'ki'a Saimoni'ae ve'kamo aki Yisasi'a Pita'ae huno ate'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pita'ae Yemisi'ae akana'amo'a Yoni'ae Sepeti mafa'nela mai'na'ae. Yisasi'a ani ve'kala'mokani ana'ki'a Poanesi huno male'ne. Ani ana'kimo'a lakaiti kefati ha'kali huno ake ne'aiya ya hu'ana ke neha'a kanolane huno'ae ani ana'ki anate'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Etalu'ae Filipi'ae Patalomiu'ae Matiu'ae Tomasi'ae Yemisi'a Alafiasi mafa'ne'ae Tatiasi'ae Saimonina hamo'amo'ae mako aki'a Seloti'ae. ");
INSERT INTO ino_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yutasi Isa'kalioti'ae akaeya henaka'a Yisasina akesi huno kame vaya'aina avaleno apamisea ve'kae. Ani vayama'a hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisasi'a nopi uno mai'nike'a mi'ko vaya'moki ali'a atalu hakeno akaeya ke ne'afea anaka'ae ne'ya nesaya kana'api o'male'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Akai'a afamo'moki ani ke afite'a inake hae “Yisasi'a aneki kava nehe.” hute'a avalekefe u'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yelusalemu kumateti mono hapali'a hapa'nepaiya vaya'moki va'yi hu'a Yisasife inake hu'a nehae “Akaeya Sata afe'yaka'ai kava ve'ka'api Pielisipuli aipafi mai'neno lo'kiya'a amikeno mani Sata afe alino ne'atale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Inake nehakeno Yisasi'a afiteno mako vaya'aife ke hike'a akeno ke avoya kefati inake huno hapapai'ne “Sata'a hana'ya huno akai'a Satana hafaike? ");
INSERT INTO ino_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mako ala koteka vaya'moki ali'a fa'ko fa'ka hute'a la hisayana ani ko'apimo'a uno haviya huno hano huke. ");
INSERT INTO ino_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inaki mako'ke afamo'moki folaka'apifati ali'a fa'ko fa'ka hute'a la hisayana ani afamo anakana u'a haviya hu'a hano hukae. ");
INSERT INTO ino_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sata'a akai'a Sata afe vaya aipafati alino ataleseana akai'a nofi vaya alino fa'ko hisike'a ‘Fate fate nofi vaya mai'none.’ hu'a hisayana Sata'a kava yakaisea yana uno haviya huno hano huke. ");
INSERT INTO ino_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mako lo'kiya ve'kamo'a no'alena kava yakaino alakepa hu'niseana mako ve'kamo'a ‘Kumaya'ya hukefe visoe.’ huno'aena hokoteno ani note yakai'nisea ve'ka atafa huno nofiteti aiya ayate kite'neno henaka'a ani afeno ya'a alike. Nakaeya ani ya hu'na Satana atafa hu'na nofiteti aiya ayate kite'ne'na akaeya afe anakana hapafaitale'noe. ");
INSERT INTO ino_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nakaeya lamake hu'na lahapa'nepauve mi'ko ve a'nemoki fate fate hao'otake kava'ae mi'ko hu'a haviya hutesaya hao'otake ya'api'ae Anumaya Koti'a lapahaove lapatove nehuno aipa yuna yapati alino atalelapatekaiye. ");
INSERT INTO ino_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Alino atalelapatekaiya'maki Anumaya Koti Fate Akufa Avamu'amofe hu'a haviya hutesaya ya'api Anumaya Koti'a alaki lamake huno lahapaove lapatove nehuno aipa falu yapati alino o'atalesikeno alaki haneke haneke huno hanekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Sata afe'mo'a haino aipafi mai'ne.” hu'a haya yafe Yisasi'a ani ke hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Hapa'nepaike'a ita'amo'ae akana'amoki'ae e'a kumateka mai'ne'a mako ve'ka hutakeno Yisasife ke nehe. ");
INSERT INTO ino_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ke nehike'a mi'ko vaya ali'a atalu hu'a Yisasi aiyafi faitopale mai'naya vaya'moki akaeyafe inake nehae “Afeo ita'kamo'ae kakana'kamoki'ae e'a ma'aileka mai'ne'a kakaeyafe ke nehae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nehakeno Yisasi'a ke anona'apile inake he “Nalaki ita'nimoki'ae nakana'nimoki'ae mai'nae?” huno apafi ne'ke. ");
INSERT INTO ino_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hau'ale mai'a veko hu'ne'a akaeya ke ne'afea vaya'aina apa'keno uneno nehuno inake huno hapapai'ne “Nakaeya ita'nimoki nakana'nimoki male mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Anumaya Koti ke afi'a a'kame ne'male'a nehaiya kava nehaya vaya'ke ita'nimoki nakana'nimoki nasa'nimoki mai'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yisasi'a li kotu'mo aki'naleka mai'neno mako'ae alino apaya nehike'a lusi ve a'ne ali'a atalu nehakeno Yisasi'a lipi kalefi haino faitopale maiteno li folakapi uno mai'nike'a ali'a atalu haya vaya'moki li kotu'mo aki'nale heti'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Heti'a mai'nakeno Yisasi'a fate fate ke avoya kefati alino apaya nehuno mako ke inake nehe “Mako ve'kamo'a uno avina ya hoyafi ne'atale. ");
INSERT INTO ino_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ataleme ne'vikeno mako avina ya'amo'a kateka asaka hulavi'nike'a namamoki e'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mako avina ya'a yafa akotofule asaka hulavi'nea'maki mopamo'a alapa o'ai'nea yafe makale hake'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hake'nea'maki hafu'ya'a olavi'nea yafe yake haino ne'ekeno amu'ko'amo'a leno asakalikeno vai'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mako avina ya'a aufe kahau'mo hu'nea yapi atale'nikeno aufe kahau'ae makopi hakete'ana aufe kahaumo'a ano latota nekeno alaka'a o'a'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mako avina alaka'a kanale mopafi asaka hulavi'neno hakeno haiteno lusi yate ne'ya alite'ne. Ne'ya'a aliteateka mako ve'kamo aiya aya hano huteno mako ve'kamo ayatala'a hano hea avamete alaka'a (30 alaka'a) a'ne. Mako vaya'moki mako'ke avina yapati aole'ae mako'ae vaya'ai apaiya apaya hano hea avamete alaka'a (60 alaka'a) a'ne. Mako'a avina ya'afati lusi yate naya mako'kaya hano hea vaya'ai apaiya apaya hano hea avamete alaka'a (100 alaka'a) a'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yisasi'a ani ke huteno inake nehe “Kakesa hane'nisea kanomoka mani ke afeo.” ");
INSERT INTO ino_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nehike'a mi'ko vaya utake'a mako vaya'ae akaeya ke ne'afea anaka'ae ani avoya ke hea kemo aepa'ae afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Afine'kakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya Anumaya Koti'a kava yakailapatesea yafe fala'kino hane'nea ke Anumaya Koti'a lahapa'maeketapa afi'naya'maki nakaeya ke no'afea vaya'yaka afi'a alakepa ohukae. Avoya ke hapapauke'a apa'kesa afite'a ke aepa'a afi'a ha ole'nae. ");
INSERT INTO ino_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ani vaya'moki akeme hai'naya'maki ake'a alakepa hu'a o'akesaya yafe nakaeya avoya ke hapa'nepauve. Afime nehaiya'maki afi'a alakepa ohisaya yafe nakaeya avoya ke hapa'nepauve. Haviku afi'a alakepa hute'a apaipa ai'a yahae hisake'na hao'otake ya'ape hapaove apatove nehu'na naipa falu yapati ali'na atalesoa yafe avoya ke'ake hapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Apa'kaeyafe inake hu'ne “Mani avoya ke afitapa alakepa ohu'nafe? Mi'ko avoya ke hana'ya hutapa afikae? ");
INSERT INTO ino_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Avina ya neha'kalea ve'ka Anumaya Koti ke neha'kale. ");
INSERT INTO ino_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Neha'kalekeno kate asaka hulavi'nea avina ya'mo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti kanale ke ha'kale'nea ke afi'a apaipafi o'malesaya yafe Sata'a eno apaipafati ani ke alino atale'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ani kava huno yafa mopafi lavi'nea avina ya'mo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti ke afite'a makale apaipafi malete'a amuse nehae. ");
INSERT INTO ino_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amuse nehaya'maki alike ataleke vaya mai'nayanake'a hafu'ya'a mopafi olavi'nea yafe aise kana afi'a apaipafi male'nakeno Anumayamo ke ne'afea yafe havi kana va'yi huke vaya'moki ali'a haviya hupate kana apa'kaeyate va'yi neheana makale Anumaya Koti ke ne'atalae. ");
INSERT INTO ino_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Mako avina'a aufe kahau hane'nea mopafi lavi'nea avinamo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti ke afite'a ma mopale aki'ae aka'ae kana yafe'ae mi'ko moni afeno'api alisaya ya'aefe amuse nehu'a apa'kesa ne'afi'a aki'ae aka'ae yafe ake'a hapa'ye hu ya'apimo'ae Anumaya Koti ke ano ati'kaekeno alaka'a ano alakepa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ano alakepa nohea'maki kanale mopafi lavi'nea avina ya'mo'a ina kava hu'ne mako vaya'moki Anumaya Koti ke afi'a apaipafi malete'a atafa hu'a alaki hu'naya vaya'moki alaka'a alitayateka mako ve'kamo aiya aya hano huno mako ve'kamo ayatala'a hano hea avamete alaka'a (30 alaka'a) a'nae. Mako vaya'moki mako'ke avina yapati aole'ae mako'ae vaya'ai apaiya apaya hano hea avamete alaka'a (60 alaka'a) a'nae. Mako avina yapati nesu yate naya mako'kaya hano hea vaya'ai apaiya apaya hano hea avamete alaka'a (100 alaka'a) a'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Anumaya Koti ke hapa'nepaiya yafe Yisasi'a inake huno apafine'ke “Mako vaya'moki kani ate'a samoleti ai'a ati'ka ne'malafi hipa kapi ne'malae? He'e ano halesea yafenake'a hipale'ke ne'malae. ");
INSERT INTO ino_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mi'ko fala'ki'nisea ya'mo'a henaka'a fole aike. Mi'ko kesi kava nehaya ya'mo'a henaka'a fole hinake'a mi'ko vaya'moki akekae. ");
INSERT INTO ino_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lapa'kesa hane'nisea vaya mai'netapaena mani ke afeo.” ");
INSERT INTO ino_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Apa'kaeyafe mako'ae inake nehe “Anumaya Koti ke ne'afea yafe lapa'kesa afitapa alakepa hutapa afeo. Afisaya ke afitapa a'kame malesayana ani avamete mako ke'ae lahapapaisiketapa afisakeno mako'ae ke lahapapaike. ");
INSERT INTO ino_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Afitapa alakepa hutapa afi'naya vaya'mokitapa Anumaya Koti'a mako'ae afisaya ya lapamikea'maki ‘Ako hai afi'none.’ hu'a hu'naya vaya'moki afi'naya ya ako eteno hapafalekaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Yisasi'a inake nehe “Anumaya Koti'a kava yakailapatesea ya'amo'a ma kava huno hane'ne. Mako ve'kamo'a hoya'afi avina ya ha'kalemaleno mi'ko hani'ainaka havamaleno felukama'a hetino uneno hu'nea'maki ani ha'kalemale'nea avina ya'mo'a ako hakeno ala hu'nea'maki ani ve'kamo'a hoya'nimo'a hana ya huno nehake huno akeno alakepa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Akeno alakepa ohu'nea'maki mopamo'a akai'ake ani avina yana nu amikeno haketeno haita'a maleteno henaka'a alakama'a ateno ketekeno'aefena avoyalekati alino fayo ne'make. ");
INSERT INTO ino_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Fayo makikeno'a aketeno ‘Ako ne'ya kete.’ nehuno ani ve'kamo'a sasu'me alino uno ani ne'ya hataka nehuno meni ‘Ne'ya ali kana fole aiye.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisasi'a inake nehe “Anumaya Koti'a vaya'aite yakaipatesea yafe hana ke huta hisune? Hana akufa ya hane'ne hu'na avoya ke humale'na ani ke lahapapaisoe? ");
INSERT INTO ino_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ani avinamo'a nalepa yosamo alakakana huno aise aise alakatato hane'ne. Ani alakamo aki'a masatati hu'a nehae. Ani masatatimo alakamo'a aise huma'aleka ma mopafi hane'nea yosamo alaka'a akaseno mako'ae aise alakatato hane'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ani alakatato ha'kalemale'nikeno mi'ko aki'ae aka'ae yosayaka apa'kaseno lusi yosakefa nehaiyanakeno ala ala a'kopa'a hane'nikeno aki'ae aka'ae nesu namamoki e'a auluna'afi ha'kale'a ne'maiye.” ");
INSERT INTO ino_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisasi'a ani kava huno lusi yate fate fate avoya kefati hapa'nepaino afi'a apaipafi malesaya avamete hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yisasi'a ke avoya ke'afati'ke mi'ko ke ve a'ne'aina hapapai'nea'maki mako ke huno fole aino hapa'opai'ne. Hapa'opai'nea'maki akae ke ne'afea anaka'ae lo'ka'a apaote maiya afina'ke ani avoya ke huno fole aino hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ani mako'ke afina unena Yisasi'a akaeya ke ne'afea anakafe inake huno hapapai'ne “Mikakaya li aki'naleka viketao.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ani mi'ko ve a'ne apatale'a Yisasi'a haino mai'nea lipi kalefi hai'a maite'a ako u'nae. Ne'vake'a mako fate lipi kaleyakamoki ani Yisasina avaleno vea lipi kale'ae lo'ka'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","U'naya'maki mako lo'kiya yasimo'a va'yi hikeno hake li'mo'a aino kalafu aino ani lipi kalefina hai'neno maleno havaite ya hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Havaite ya hikeno lipi kalemo a'kameleka mako yosa male'a veke aimale'naya kefa yosale Yisasi'a afita aiteno havano mai'nike'a auna he'a akaeyafe inake hu'a nehae “Ali'ka laya nehana Nenao lipi lavita falisuna kava nehuna'maki kakaeya kakesa no'afipe?” nehu'a auna he'nae. ");
INSERT INTO ino_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Auna hakeno Yisasi'a hetino lo'kiya yasi ke ne'amakino life inake he “Meni hainaki kakaeya laka'no.” nehikeno lo'kiya yasi laka'ne'ne. Li'mo'ae mako'ae alaki kanake ohu'ne. ");
INSERT INTO ino_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanake ohu'nikeno Yisasi'a akaeya ke ne'afea anaka'aife inake he “Lapa'kaeya na yafe ani koli hu'nae? Hana kava hutapaefe lapa'kaeya nakaeyafe afitapa lapapaipafi maletapa lo'kiya vai'naya yatapimo'a kale'yo nehe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Apafine'kea'maki lusi koli hute'a apa'kai'api apavepaka sumi ke hu'a inake hae “Ma ve'ka hana akufa ve'ka mai'neno'ae mani ke nehikeno yasimo'ae li'mo'ae ke hea kelena a'kame ne'mala'ae?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kalili ala li kotu la'ka'a mekakaya ke'ke'ka Kelasane nehaya koteka u'a va'yi nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","U'a va'yi hute'a Yisasi'a ani lipi kalefati ataleno li aki'naleka ne'vikeno Sata afe aipafi mai'nea ve'kamo'a makale'a vaya ki ne'apataya yapakati Yisasina akeno avate'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ani ve'ka mi'ko afina vaya ki ne'apataya yapakake uneno huno nehavaeya ve'kake'a mako vaya'moki alaki atafa hu'a nofi no'aya ve'kae. Aeni seni nofiteti aiya ayate nofi kite'naya'maki atafa ohuke. ");
INSERT INTO ino_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nesu afina vaya'moki ani ve'ka atafa hute'a aiya ayatena seni nofiteti kite'naya'maki ako'ke aino a'kano hune'ataleno lusi lo'kiya ve'ka mai'nea yafe mako ve'kamo'a atafa huteno “Vase hu'ka yuna ho.” huno huo'ate'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mi'ko afinana ani ve'kamo'a vaya ki ne'apataya yapakake ne'maino avimatekake uneno huno ne'maino ala kefati kate kate nehuno yahauna yafa alino akai'a akufa laka huke ataleke nehea ve'kae. ");
INSERT INTO ino_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ani ve'kamo'a Yisasina alu'aleti aketeno makale naku naku huno eno Yisasi aiyafi ape huno ale'ya lo ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Lo ne'akeno Yisasi'a ani Sata afefe “Ma ve'ka ne'atale'ka hatilaveo.” huno hu'nea yafe ani ve'kamo'a ala kekefafati lo'kiya ke nehuno inake he “Anumaya Koti ko'ku'napi ve'kamo mafa'ne Yisasika nakaeya na kava hunatekefe nehane? Kakaeyafe Anumaya Koti akile ke hu'na kafine'koki nakaeya ali'ka haviya hune'nate'ka nakafu kisea ya huo'nato.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nehikeno Yisasi'a ani ve'kaena inake he “Kakaeya kaki'ka nalakae?” hikeno “Nakaeya naki'ni'a Nesu'ya'mo'nae nesu yate akae aipafi haita mai'none.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ani ve'kamo'a Yisasife “Ani kumatetina Sata afe'yaka hupateke'a o'veo.” huno ala kefati lo'kiya ke nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nehea'maki mako avimate nesu afuyakamoki mai'ne'a ne'ya neke neke hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mai'nake'a ani Sata afe'yakamoki Yisasife “Mika afuyakamoki apaipafi hulateketa haita maino.” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Afine'kakeno Yisasi'a “Kanalenaki ani kava heo.” huno hupateke'a ani Sata afe'yakamoki ani ve'ka ne'atale'a afu anaka'ai apaipafi hai'a faletake'a ani afuyakamoki naku naku lavite lavite haya'ya'moki lusi mulifi lavi'nae. Mi'ko afuyaka aole tauseni'a (2,000) afuyakake'a mako li kotupi asaka hu'a aite'a li ne'a apamupate'a fali'a hano hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hano hake'a ani afu'aite kava vaya apaune he'a ala kumate mai'naya vaya'ae hoyafi mai'naya vaya'ae “Ina kava hiketa laune heta ne'one.” hu'a hapapaike'a ani hu'nea ya akekefe e'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yisasite e'a lusi Sata afe'yaka aipafati alino atale'nea ve'ka ako akesa ha'kalo hikeno meni kanale'ya huno kena'a havaiteno anile mai'nike'a ne'ake'a koli nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Koli nehake'a Yisasi'a ani Sata afe'yaka alino atale'nea kava ake'naya vaya'moki “Ina akufa kava nehea ve'kamaki alino kanale hute'ne.” nehu'a afu anaka'ai hupate'nea ya'aefe avake hu'a mi'ko vaya hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hapapaike'a ani vaya'moki Yisasife “Ma kumana atale'ka alu kumate uvo.” hu'a lusi lo'kiya ke nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hakeno Yisasi'a ataleno ukefe lipi kalefi nehaikeno ani Sata afe'yaka aipafati alino atale'nea ve'kamo'a Yisasife “Kakaeya'ae visufe?” huno afike'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Afike'nea'maki Yisasi'a ohaikeno akaeyafe inake he “He'e. Kakaeya no'kaleka anaka nofi vaya'kaleka u'ne'ka Anumayamo'a hautakikateteno mi'ko kakaeya kakufale alo hukate'nea yafe fa'ko hu'ka hapapaiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Hikeno ani ve'kamo'a Te'kapolisine nehaya koteka nayatala'a alea kumate vaya'aipi uno Yisasi'a alino kanale hute'nea yafe hapa'nepaike'a ani ke ne'afi'a lusi apa'kesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisasi'a eteno halate haino lipi kalefi maiteno ani li kotuna la'ka heno makaya falika eno li aki'nale mai'nike'a lusi ve a'nemoki akaeyate e'a ali'a atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mai'nikeno mako ve'kamo aki'a Yailasi'ae nehaya ve'ka e'ne. Ani ve'ka mako mono note so'ka ve'kakeno Yisasina aketeno aiyafi eno ale'ya lo a'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Eno ale'ya lo'a'neno Yisasife inake huno afine'ke “Vae nakaeya a'mafa'ne'ni ako falikefe nehiki kakaeya e'ka kaya maletesanakeno kanale hutesikeno eteno afa'a maise hu'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hikeno Yisasi'a ani ve'kamo a'kame anileka ne'vike'a lusi ve a'nemoki auleka a'kameleka hu'ne'a a'kalo a'kalo huli'a ne'u'a yake yake hu'a ne'vae. ");
INSERT INTO ino_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne'vakeno mako ana nayatala'a hano huno naiyalekati aole alea kafu aiku ya akekeno mi'ko afina aiku nopakake ne'maiya a'ae anile mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mai'nea a'mo'a yatala afina ma mopafi Tota vaya'aite u'nea'maki lusiya hu'a akafu kea kava'ke hutakeno lusi moni'a atale'nea'maki ani kali'a alaki lamake hu'a ali'a kanale huo'ate'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kanale huo'atakeno ani a'mo'a Yisasi avake afiteno ani vaya'ai folakapi mai'neno Yisasi a'kamelekati eno kena'ale ame'ko ali'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ame'ko ne'alino ma akufa akesa afi'ne “Afa'a kena'ale ame'ko ne'alisukeno kali'ni hano huke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nehuno ame'ko ne'alikeno makale aiku ya'a lanetekeno akufafaka maleno akeana ani kali'a ako hano hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hano hune'atekeno Yisasi'a maleno ake'neana akaeyatekati mako lo'kiya'a ako u'nikeno Yisasi'a ani vaya'ai folakapati aino yahae nehuno inake hu'ne “Nala'a eno kena'nile ame'ko ali'ne?” nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nehike'a akaeya ke ne'afea anaka'moki inake hae “Ake'nape lusi vaya'moki kakaeyatena mako'ke apa'kufale a'kalo a'kalo hu'naya'maki na kava hike'ka ‘Nala'a kena'nile ame'ko ali'ne?’ hu'ka nehane?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nehakeno Yisasi'a kena'ale ame'ko ali'nea ve'kae “Akesoe.” huno aulaka alinuneno nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aulaka ne'alikeno ani a'mo'a kena'ale ame'ko ne'alikeno ani kali'a hano hute'nea yafe akesa ne'afino amo'yo aikeno atete nehaikeno Yisasi aiyafi uno ale'ya lo a'neno mi'ko ya'a huno fole ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne'aikeno Yisasi'a inake huno hapai'ne “Mafa'ne'nimoka nakaeyafe afi'ka kaipafi male'nana ya'kamo'a meni kali'ka ako kanale hukateanake'ka kaipa falu yapati no'kaleka ukana'maki mi'ko kali'ka alaki hano huke.” ");
INSERT INTO ino_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisasi'a ani ke nehike'a mono note so'ka ve'kamo notekati mako vaya'moki e'a inake hae “So'ka Nenao a'mafa'ne'ka ako fali'nea'maki kakaeya hana kava hu'ka alino apaya nehea ve'ka alaka haesea akufa ke hune'atane mako'ae afio'ke'ka atalo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nehakeno Yisasi'a ani ke afi'nea'maki akesa afino o'apamino ani so'ka nefe inake huno hapai'ne “Kakaeya ani ke hisaya yafe kahau hale'ka kamo'yo o'ai'ka nakaeyafe'ke afi'ka kaipafi malo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ha'nepaino Yisasi'a mi'ko ve a'ne'aife “O'meo.” hupateteno “Pita'ae Yemisi'ae Yoni'a Yemisi nepu'amo'ae apa'kaeya'ake nakaeya'ae ekae.” huteno apavaleno ne've. ");
INSERT INTO ino_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Ani mono note so'ka ve'kamo note u'a va'yi hu'nayana lusi kaleso ne'ai'a lusi avi nelakeno ani nopi Yisasi'a hai'neno inake nehe “Na ya hiketapa lusi kaleso ne'aitapa mani avi nelae? Mani a'mafa'ne alaki ofali'nifa afa'a havano mai'nea yafe nehae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nehike'a ani vaya'moki lusiya hu'a kiki'a hune'atakeno Yisasi'a mi'ko ve a'ne ani nopati alino apataleke'a ma'aileka hatilavitakeno Yisasi'a ani a'mafa'nemo ita afo'amokani'ae aole'ae mako'ae anaka'a'ae Yisasi'a ke hike'a ani a'mafa'ne mai'nea nopi hai'nae. ");
INSERT INTO ino_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Haite'a Yisasi'a ani a'mafa'nemo ayate ne'alino inake huno hapai'ne “Talita kumi.” Ina hea kemo'a ma ke hunofe nehe “Aise a'mafa'ne nakaeya heteo hu'na nehuki kakaeya heteo.” huno'ae nehe. ");
INSERT INTO ino_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nehikeno makalema'a ani a'mafa'ne hetino ka uneno nehe. Ani a'mafa'ne layatala'a hano huno laiyalekati aole alea kafu (12 kafu) mai'nea a'mafa'nekeno Yisasi'a alino hetitekeno ka uneno hea ya ne'ake'a ani vaya'moki lusi apamo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Apamo'yo ne'aikeno Yisasi'a “Mani hoa yafe mako vaya alaki hapa'opaiyo.” huno lo'kiya ke hapa'nepaino “Mako ne'ya alitetapa mani a'mafa'ne amikeno neno.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisasi'a ani kumana ataleno ko aepa'aleka vike'a akaeya ke ne'afea anaka'a a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapati afina mono no'apifi uno Anumaya Koti ke mi'ko vaya hapa'nepaike'a ani ke afite'a atali atalu nehu'a inake nehae “Mani ke akenopa hale'nea ve'kamo nehea kekana ke hanateti alineno'ae ani ke nehe? Ayateti o'ake'nona avame hu lo'kiya yana hanateti ali'ne? ");
INSERT INTO ino_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mani ve'ka no ki ali'yate ve'kamafe? Malia mafa'nemafe? Yemisi'ae Yosesi'ae Yutasi'ae Saimoni'ae akana'amoki o'mai'nafe? Asa'amoki lakaeya'ae makopi mai'nae.” hute'a apaipa kafa hate'a apa'kame'ya ami'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Apa'kame'ya amitakeno Yisasi'a apa'kaeyafe inake hu'ne “Anumaya Koti ke nehea ve'kamo'a mi'ko kumate hapapaiseana aki ali'a asaka hukaya'maki akai'a kumate viseana akai'a afamo'ae no kuma'ale vaya'ae aki ali'a asaka ohukae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ani kumatena o'ake'naya avame hu lo'kiya yana nesu yate ohuno afa'a mako'ke mako'ke kali vaya'ake aya maleno alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Alino kanale hupateke'a mi'ko vaya'moki akaeyafe afi'a apaipafi o'male'naya yafe Yisasi'a lusi akesa ne'afino mi'ko kumate kumate uneno nehuno Anumayamo ke alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yisasi'a ayatala'a hano huno aiyalekati aole alea anaka'aife ke hike'a akaeyate akeno mi'ko Sata afe'yaka vaya'ai apaipafati ali'a apatalesaya lo'kiya'a apamiteno inake he “Aole lo'kate lo'kate hutapa veo.” huno hupate'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Hune'apateno inake he “Ka ne'utapaena ayomepa kayo'ake alikaya'maki ku'ae maya'ae moni'ae alitapa o'veo. ");
INSERT INTO ino_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lapaiya anona vaikaya'maki aole kenalana o'aleo. ");
INSERT INTO ino_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mako nopi haitapa mai'netapaena ani nopi maitapa havatetapa ataletapa fate kumate veo. Alu nopi nopi havalitata oheo. ");
INSERT INTO ino_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mako kumate vaya'moki ali'a falu fala huolapate'a ‘Lapa'kaeya ke o'afikune.’ hu'a hisaketapaena ani kumana ne'ataletapa ‘Havi kava hulate'nae.’ hutapa nehisake'a afisaya yafe lapaiyale kama'nisea mumusopa alitapa fopo hune'ataletapa veo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hapapaiteke'a ani vaya'moki u'a mi'ko vayafe inake hu'a nehae “Lapaipa aitapa yahae nehutapa hao'otake yatapi ataleo.” hu'a hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Hapapaike'a mi'ko Sata afe'yaka apaipafati hupatake'a ne'vake'a lusiya hu'a kali vaya'ai apa'kufale masave fale ne'apatakeno kanale hupate'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ani kanafina Yisasi avake'amo'a lusiya hikeno mako ala kava ve'kamo aki'a Heloti'a Yisasi hu'nea kava'mo avake'a afi'ne. Mako vaya'moki Yisasife inake hu'a nehae “Ma ve'ka Yoni'a li fale ne'apatea ve'ka ako fali'neapati heti'nea yafe lusi lo'kiya'a hane'nikeno ma lo'kiya ali'ya akaeya ayapati ne'ale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hake'a mako vaya'moki Yisasife inake hu'a nehae “Ma ve'ka Ilaiya'a mai'ne.” hu'a nehake'a mako vaya'moki inake hu'a nehae “Mako aune ve'ka mai'neno a'ke'ainaka Anumaya Koti ke lahapai'nea aune ve'kakana nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nehaya'maki Heloti'a ani ke afiteno inake nehe “Yonina haeyo huke'a ako ake'ya hataka hute'a kite'naya ve'ka eteno kelifati heti'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Heloti akana'amo aki'a Filipi'ae. Ani Filipi ana Helotiasina ano kapeleno Heloti'a ali'nikeno Yoni'a Helotife inake hu'ne “Anumaya Koti ke ali'ka ataka'ka kakana'kamo ana a'ka kapele'ka ali'nane.” Nehikeno Helotiasi'a Yoni falisea yafe nehaikeno Heloti'a ali'ya vaya'a hupateke'a Yonina atafa hu'a nofi hute'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Hute'nakeno Helotiasi'a Yonife hai vaiteno haesakeno falisea akesa afi'nea'maki Heloti'a inake huno akesa afi'ne Yoni'a alakepa kanokeno hao'otake kava ohuno fate akufa ve'ka mai'nea yafe Yonife koli huno “Ohakauve.” nehuno kanale'ya huno yakaite'neno Yoni ke afiteno akesa afino lapa ne'aino aole akesa ne'afino afa'a amuse huno ke'a ne'afe. ");
INSERT INTO ino_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mako afina Helotiasi'a Yonina haesea kana'a va'yi hu'ne. Ani kanalena Helotina alite'nea kana'a va'yi hikeno Heloti'a ala emu kimale'nike'a mi'ko kamani kava vaya'ae ati kava vaya'aite kava vaya'ae Kalili koteka lusi afeno male'naya vaya'yaka'ae ani ne'yate e'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E'a mai'nakeno Helotiasi'a a'mafa'ne'amo'a eno folaka'apifi aiya ne'aeke'a Heloti'ae vaya'amoki'ae ne'ake'a amuse nehakeno Heloti'a ani a'mafa'ne inake hu'ne “Kakaeya kahaisea yafe ke hisanana kamikoe. ");
INSERT INTO ino_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Anumaya Koti aulakale kaha'nepauve mako yafe nafikesanake'naena kamikoe. Nakaeya yakai'noa ya'mo folakapati a'na fa'ko hu'na kamikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hikeno ani a'mafa'nemo'a uno ita'amofe inake huno afine'ke “Naiya aova yate na yafe ke hisoe?” huno hikeno ita'amo'a inake nehe “Yoni'a li fale ne'apatea ve'kamo akenopa'a hataka hute'a nameo hu'ka afiko.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hikeno naku naku huno vea'ya'mo'a ala kava ve'kae inake hu'ne “Makale Yoni'a li fale ne'apatea ve'kamo ake'ya hataka hutetapa falitesike'ka akenopa'a lapepi alitetapa nameo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hikeno ala kava ve'kamo aipamo'a lusi kana nehikeno Anumaya Koti aulakale huno lo'kiya vai'nea ya'aefe mai'naya vaya'moki'aefe akesa afino “Ani a'mafa'ne hu'noa ke ali'na o'atakakauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Makale'a mako ati ve'ka hune'ateno inake huno hapaiye “Yonina akenopa'a ali'keno.” huno hikeno nofi nopi uno ake'ya'a hataka hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Hataka huteno akenopa'a lapepi maleteno alineno ani a'mafa'ne amikeno ita'amona ami'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Amike'a Yoni ke ne'afea vaya'moki ani ke afite'a u'a akufa'a ali'e'a yafa'kapi kite'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yisasi ke ne'afikeno hupate'nea vayana Yisasiteka ete'a mi'ko hu'naya kava'ae hu'a apaveli'naya ke'ae e'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ha'nepaike'a mi'ko vaya u'e'a hutake'a Yisasi'ae akaeya ke ne'afea anaka'ae ne'ya nesaya kana'a o'malekeno Yisasi'a apa'kaeyafe “Eketa vaya o'mai aupalika lakai'atike ne'uta maita falu hisune.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Apa'kai'apike lipi kalefi hai'a maite'a vaya o'mai koteka ukefe nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne'vake'a mi'ko vaya'moki apaukosa apa'ke'a aito nehu'a apaukosa hu'a vayateka kuma'apileti mopafi naku naku hu'a ani vaya o'mai koteka u'a hokote'a va'yi nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hokote'a u'a va'yi hakeno Yisasi'a lipi kalefati hatilavino mi'ko ali'a atalu hu'naya vaya'aina apa'keteno kalaki aine'apateno inake huno akesa afi'ne “Ma vayana sipi sipi ana'aukana kava nehaya'maki yakaipate ve'ka o'mai'ne.” huteno ani yafe kalaki aine'apateno fate fate ke hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Hapa'nepaikeno yake lavino falekefe nehike'a akaeya ke ne'afea vaya'moki e'a Yisasife inake hu'a nehae “Ma koteka vaya o'mai ko hane'nea yafe yake lavino falekefe neheanake'ka mi'ko vaya'yaka hupatesanake'a u'a alu vaya'ai hoyafati'ae nopati'ae nesaya ne'ya'api miya hisae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nehaya'maki Yisasi'a inake huno hapa'nepaiye “Lapa'kaeya lapa'kaitapike ne'yana apameo.” huno hike'a akaeyafe inake hu'a nehae “Mako ve'kamo'a naya aole vaya'ai apaiya apaya alea afina (200 afina) ali'ya aliteno miya alino ani miyateti ma akufa vaya'moki nesaya ne'yana miya ohinine. Lakaeya ne'ya miya faiteta apamisune hunake'kae nehape?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nehakeno Yisasi'a inake nehe “Na'maki maya hane'nifi utapa akekeo.” huno hike'a u'a akete'a “Naya mako kaya mayaki aole fayanaki huno hane'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nehakeno mi'ko vaya'aife “Alitapa anupa hupate hupate hutapa hafepale apateke'a maiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nehike'a naya mako kaya hano hea teni'a vaya (50 vayana) ali'a anupa hu'a maite maite hu'nake'a mako kaya naya hano hea vaya'ai apaiya apaya alea vaya (100 vaya) ali'a anupa hu'a maite maite hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mai'nakeno Yisasi'a naya mako kaya maya'ae aole faya'ae ali'neno ko'ku'nateka ne'akeno Anumaya Kotiteka huno amuse huteno maya a'kaya heno akaeya ke ne'afea vaya apamike'a ali'u'e'a hu'a vaya'yaka apami'nae. Aole faya'ae ani kava huno mi'ko vaya'moki nesaya yafe fa'ko huno ne'apame. ");
INSERT INTO ino_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Apamike'a mi'ko'amoki ne'a apamu hutake'a mako neke'a atalaya maya'ae faya'mo atupa atapa'ae ali'a anupa hu'a kupi aiyateka naiyalekati aole alea kupi (12 kupi) aikeno havaite'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ani ne'ya ne'naya vayana vema'ake faefu tauseni (5,000) veyakamoki ne'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Makale'a Yisasi'a akaeya ke ne'afea vaya'aife inake hu'ne “Nakaeya nataletapa hokotetapa lipi kalefi haitapa ala li kotu la'ka hetapa Petesaita kumate visake'na nakaeya ma vaya'yaka hupatesuke'a visae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","“Veo.” huno hupateke'a utakeno Yisasi'a akai'ake avimapi haino Anumayamoteka afikekefe hai'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yake lavino falekeno une avame li kotu'mo folakapi ne'vakeno Yisasi'a akai'ake mopaleka mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mai'neno akeana lo'kiya yasimo'a eno lipi kalemona ano atufatalekeno yosaleti lina amaki'naya'maki ani lipi kale no've. O'u'nikeno koti avameteka Yisasi'a li avoyale aiya ame ame lipi kale hane'neateka eno apa'kasekefe nehe. ");
INSERT INTO ino_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Apa'kaseno ukefe nehike'a akaeya li avoyale aiya ame ame ne'eke'a ne'ake'a “Afe kano ne'e.” nehu'a lusiya hu'a koli hute'a “Avo avo.” hu'a kalafa ka'nae. Koli nehakeno makale'a Yisasi'a inake huno hapapai'ne “Koli ohutapa lapaipamo'a lo'kiya vaineketapa maiyo. Mamona nakaeya'ke ne'oe.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hapa'nepaino Yisasi'a lipi kalefi haino apa'kaeya'ae ne'maikeno yasimo'a laka neke'a lusiya hu'a apamo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yisasi'a lo'kiya'aleti ne'ya apami'nea yafe apa'ku'amo'a yafa'kana huno lo'kiya apa'ku apa'kesa hane'nea yafe aepa'a afi'a alakepa ohu'a apamo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ani li kotuna la'ka he'a Kenesaleti aupalika u'a lipi kale nofiteti a'a atafa humale'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ani lipi kale atale'a nelavike'a ani kumate vaya'moki makale Yisasina ake'a aeto hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ake'a aeto nehu'a ani koteka hane'nea kumatena makale kali vaya apavale'a ekefe note note naku naku hu'a u'nake'a mi'ko vaya'moki “Yisasi'a eno mai'ne.” haya ke afite'a kali vaya'yaka apavale'a sifanafi apatete'a Yisasite ali'a ete ete hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mi'ko aise kumate'ae ala kumate'ae mi'ko aupalika Yisasi'a uno va'yi hike'a lusi kali vaya'ke'ya apavale'a e'a kuma folakapi apatake'a ani kali vaya'moki ala kefati Yisasife inake hae “Lakaeya lataleketa kena'kamo atupa'ale ame'ko ne'alisunakeno kaliti hano hise.” hu'a nehae. Hute'a mi'ko ani kali vaya'moki Yisasi kenale ame'ko ne'alikeno kali'api hano huno eteno apa'kufamo'a kanale hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ani afina mako Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae Yelusalemuti Yisasite e'a ali'a atalu hae. ");
INSERT INTO ino_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ali'a atalu hu'ne'a akayana mako Yisasi ke ne'afea vaya'moki apaya sese ohu'a ne'ya ne'nake'a apa'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falasi mono ke ne'afea vaya'moki'ae mi'ko Yuta vaya'moki'ae apa'kinakomoki'ae nehaya kava a'kame male'a apaya sese ohu'a ne'ya no'naki apaya'ke sese hute'a ne'ya nete nete hu'nayane. ");
INSERT INTO ino_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Situateka uke'a e'aena li ofalesayana ne'yana o'nekaya'maki li falakeno apa'kufamo'a kanale huteke'ae'ke ne'ya ne'nae. Ani akufa kava'ake o'male'nea'maki a'ke'ainaka vaya'moki ke male male'naya ke ali'a lo'kiya vai'a ali'naya yafe masu'ae yape'ae samo'ae mi'ko ya'api sese nehae. ");
INSERT INTO ino_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae e'a Yisasife inake hu'a nehae “Na'ya hike'a kakaeya ke ne'afea vaya'moki lakinakomoki nehaya kava ali'a ataka'a ne'ya nekefe apaya sese nohae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Afine'kakeno Yisasi'a anona'a ke'apile inake he “Lapa'kaeya lapame aole vaya mai'nae. Aisaiya'a Anumaya Koti aune ve'kamo'a lapa'kaeyafe lamake huno Anumaya Koti avopi inake huno hu'neane Ani nofi vaya'moki ameka apavayaleti'ke nakaeya naki ali'a asaka nehaya'maki apaipa'amo'a alu'ale hane'nike'a ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ani vaya'moki apavayafati hu'naya ke inake nehae ‘Ani ke Anumaya Koti ke hane'niki a'kame maleo.’ hu'a nehaya'maki inani akufa kava hu'a naki ali'a asaka nehaya kavana afa kava mai'a nehae huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anumaya Koti ke male male'nea ke ne'ataletapa vaya'moki nehaya ke a'kame male'nae.” ");
INSERT INTO ino_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Apa'kaeyafe inake nehe “Lapa'kaitapi lapa'kinakomoki kavafe a'kame male'naya yafe Anumaya Koti ke male male'nea ke ako atale'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosese'a Anumaya Koti avopi inake huno hu'neane ‘Lapa'kaeya ita afotapimoki apa'ki alitapa asaka nehutapa ke'api afitapa a'kame ne'maletapa vekano'kano huo'apateo. Mako ve'kamoka ita afo'kamokani hu'ka haviya hunatesanana falikane.’ huno hu'neane. ");
INSERT INTO ino_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Hu'nea'maki lapa'kaeya inake hutapa nehae mako ve'kamo'a ita afo'amokani hana'maesea miya hane'nisea'maki ita afo'amokanife ‘Hana'o'maesoe.’ nehuno ‘Ani miyana Anumaya Kotina amisoa ya male'noe.’ hiseana ita afo'amokani mako'ae hana'o'maeseana lapa'kaeya ‘Kanalene.’ hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ani ke nehaya kava'mo'a ‘Lapa'kinakomoki kavana heo.’ hutapa a'kame male'naya yafe Anumaya Koti kemo'a afa ya'kana nehe nehutapa mi'ko ani akufa kava nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yisasi'a mani ke huteno nesu vaya akaeyate esaya yafe ke hike'a akeno apa'kaeyafe inake huno hapapai'ne “Lapa'kaeya nakaeya ke afitapa alakepa hutapa afeo. ");
INSERT INTO ino_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ne'ya nesaya ne'ya'mo'a lapavayafati laviseana lapa'ku alino honi'ya ofaikea'maki lapa'ku'ainakati hatilavisea ya'mo'ke lapa'ku'a alino ho'niya'ake huke. ");
INSERT INTO ino_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Lapa'kesa hanesea'mokitapa ani ke afeo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huteno ne'apataleno nopaka hai'nike'a akaeya ke ne'afea anaka'moki Yisasife inake hu'a hae “Kakaeya mani avoya kemo aepa'a huketa afino.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hakeno Yisasi'a apa'kaeyafe inake hu'ne “Lapa'kaeya'aeti afita ha oletapa anekinakike hu'nafe? Mi'ko yana lapavayalekati laviseana lapa'ku alino honi'ya ofaike. ");
INSERT INTO ino_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Lapavayafi naya ne'ya'mo'a lapaipa lapa'kesafi no'vifa lapa'kupafi'ke laviteno henaka'a aifa lakeno afa ya'kana nehe.” huno nehe. Mani ke nehea kemo'a mi'ko ne'yama'a afa'a nesaya ya hane'ne huno'ae hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Inake nehe “Mako lapa'ku'ainakati haineno fole aiya ya'mo'ke lapa'ku'a alino honi'ya'ake nelahapaiye. ");
INSERT INTO ino_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Vaya'mokita laku lakesafati va'yi nehea yana ma akufa ya alino fole ne'aiye havi aipa akesa afi ya'ae a'ne a'mafa'nele kumai kava hu ya'ae kumaya'ya hu ya'ae vaya apamaki'a fali kava'ae alu ve'kamo ana avayu hu ya'ae alu ve'kamo yafe akeno ha'ye hu ya'ae hao'otake kava'ae ake'atike ke nehuno kumaya'ya hu ya'ae ake'a hapa'ye nehu'a kumai nehaya ya'ae vayafe afi'a haviya hupatesaya ya'ae vaya'aife kamuke hapau ya'ae lakufa alita hai ya'ae aneki naki hu ya'ae lapa'kupati haineno fole ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mi'ko ani hao'otake kava haya kavana apa'ku'ainakati va'yi nehea yafenakeno lapa'ku'a alino honi'ya'ake nelahapaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisasi'a ne'maiya kumana ataleno Taiya kuma'mo aupalika uno akai'ake mai'neno “Vaya'moki o'nakesae.” huno mako nopi haino mai'nea'maki vaya'moki ako ake'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Akete'a makalema'a mako a'mo'a Sata afe'mo'a a'mafa'ne'amo aipafi mai'nikeno “Yisasi mai'ne.” haya avake afiteno eno aiyafi ale'ya nefaiye. ");
INSERT INTO ino_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ani ana Isaleli nofi a o'mai'niki Kali'ki ake ne'aiya ana Finisia nofi a'mo'a Silia koteka anakeno a'mafa'ne'amo aipafi mai'nea Sata afe alino atalese huno'ae ke huno afike afike nehe. ");
INSERT INTO ino_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Afine'kekeno Yisasi'a akaeyafe inake nehe “Mafa'nemoki hokote'a ne'yana nesae. Mafa'ne'ai ne'yana hapafale'a kalayaka apamisayana haviya huke nakaeya Isaleli nofi vaya apatale'na alu vaya apaya hisoana kanale ohuke.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nehikeno ani a'mo'a inake nehe “Anumaya'nimoka lamake nehana'maki mafa'nemoki ne'nake'a ani kalayakamoki alilavea atupa'ake ne'nae. Kakaeya ani kava hu'ka nakaeya Isaleli a o'mai'noa'maki aise'a naya ho.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nehikeno Yisasi'a akaeyafe inake huno ha'nepaiye “Ke'ka ako hanake'na afuki no'kaleka uvo. Sata afe'mo'a a'mafe'ne'kamo aipafati ako atale'ne.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hikeno no'aleka uno akeana Sata afe'mo'a a'mafa'ne'a ako ataleno u'nikeno hipale kanale'ya huno havano mai'nikeno ita'amo'a ake'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisasi'a Taiya koteka ataleno aino yahae huno Saitoni kuma akaseno eno naya aole no kumana hane'nea kumana akaseno Kalili li aki'naleka uno va'yi hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uno va'yi hike'a vaya'yakamoki mako akesa a'kanikeno mai'nea ve'ka Yisasite avale'a vakeno ani akesa a'kanikeno mai'nea ve'ka avenafu'namo'a kana hikeno ke huno alakepa nohike'a inake hu'a nehae “Akufale kaya maleto” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Afine'kakeno Yisasi'a ani ve'ka avaleteno vaya'yaka apataleno alu'ale u'ana ana'kai'anike mai'ne'ana aya avoyaleti akesafi vaiteno avaitu'na heteno ayana avenafu'nale male'ne. ");
INSERT INTO ino_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maleteno hanafaka aulu neheno lo'kiya haimu alino nehaino “Ve hae.” huno huteno akaeyafe akai'a kefati inake huno nehe “Efata.” nehe. Lakaeya kefatina “Kakesa halo aino.” huno'ae nehe. ");
INSERT INTO ino_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nehikeno akesa halo aikeno avenafu'namo'a uno no'ale maitekeno kanale'ya huno ke nehe. ");
INSERT INTO ino_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ke nehikeno Yisasi'a inake nehe “Mako vaya'aina mani yafe hapa'opaiyo.” huno hu'nea'maki he'e nehu'a hapapaikeno mako'ae lo'kiya vaino “Inake oheo.” huno hu'nea'maki ani vaya'moki ani ke hu'a imafi mafi nehu'a mi'ko vaya'ai apa'kesale hulitata hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hake'a afi'naya vaya'moki lusi apamo'yo ne'ai'a inake hu'a nehae “Mi'ko alea ali'ya'mo'a kanale kanale'ke nehe. Apa'kesa a'kani'nea vayana aya malepateke'a ne'afe. Apa'ke no'aiya vayana ‘Lapa'ke aiyo.’ hike'a ke'api halate ete'a kanale'ya hu'a apa'ke ne'aiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Mako afina lusi vaya'moki Yisasite ali'a atalu hu'nakeno apa'keana ne'ya o'malekeno Yisasi'a akaeya ke ne'afea anakafe ke hike'a akaeyate akeno inake he “Mi'ko vaya'moki aole'ae mako'ae afina nakaeya'ae maikeno ne'ya'api o'male'nea yafe ani vaya'aife nakaeya nahau hune'apatoe. ");
INSERT INTO ino_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mako vaya yatala kotekati e'nayanake'na haviku apatalesuke'a kateka ne'visakeno apa'katesike'a apaune'ka'ka ai yafe o'nahaiye.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Hapapaike'a akaeya ke ne'afea anaka'amoki inake hu'a hapai'nae “Mani koteka vaya o'mai kotekaketa hanateti maya alita ani vayana apamisune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Afine'kakeno Yisasi'a halate inake huno apafike “Lapa'kaeya na'maki maya male'nae?” huno hike'a inake hae “Lakaeya laya mako kayati aole alea maya'ake (7 maya'ake) hane'ne.” hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hapaikeno Yisasi'a mi'ko vaya'aife “Mopale maiyo.” huno hapapaike'a mopale mai'nakeno Yisasi'a ani laya mako kaya hano huno laya mako kayati aole alea maya alino Anumayamoteka amuse huno ke huno afikeno kofa hute hute huteno akaeya ke ne'afea anaka'a apamike'a mi'ko vaya'aina ali'a apamite apamite hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mako aise faya hane'nikeno Yisasi'a Anumayamoteka ke huno faya'ae amuse huteteno “Alitapa apamite apamite heo.” huno hike'a vaya apami'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Apamike'a mi'ko vayana nakeno apamu hike'a atalaya maya atupayaka ali'a atalu hute'a naya mako kayati aole uno alea kupi (7 kupi) ai'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ani vaya'moki ne'ya ne'naya vayana o'afunama'a vayana fo tauseni vaya'moki (4,000 vaya'moki) netakeno Yisasi'a hupateke'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Utakeno Yisasi'a akaeya ke ne'afea anaka'ae lipi kalefi hai'a asaka hune'mai'a Talamanuta kumate u'nae. ");
INSERT INTO ino_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falasi mono ke ne'afea vaya'moki Yisasite e'a akaeya'ae ke ne'vai'a a'a avataka hisaya yafe inake hae “Kakaeya ko'ku'napakati o'ake'nona avame hu lo'kiya yana laveliketa akeno.” nehae. ");
INSERT INTO ino_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nehakeno Yisasi'a kosale haekeno lo'kiya haimu ne'aino inake nehe “Na'ya hike'a meni kanafi mai'naya vaya'moki lo'kiya avame hu ya hisoa yafe nafine'kae? Lamake lahapapaikuki afeo meni kanafi mai'naya vaya'aina lo'kiya avame hu ya hu'na apave olikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huteno ne'apataleno eteno lipi kalefi haino li kotu'mo umakaya falika u'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisasi ke ne'afea vaya'amoki li'kotuna la'ka he'a ne'vaya'maki apake'kanike'a mi'ko kai hame'ya maya o'ali'a mako'ke kai hame'ya'ake ali'a ne'vae. ");
INSERT INTO ino_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ali'a ne'vakeno Yisasi'a inake huno hapapai'ne “Falasi mono ke ne'afea vaya'ae Heloti'ae apaipafi hane'nea ya ake'a alakepa ohu'ne'a ameka apavayaleti apa'ke'atike haya yana kai hame'ya'mo hale ne'kea au'ava kava huno halekino ala hea kava nehea yafe lapa'kaeya maitapa halove hu'netapao.” huno apaumomo ne'male. ");
INSERT INTO ino_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nehike'a ani vaya'moki apa'kai'api huke afike nehu'a inake hae “Lakaeya kai hame'ya maya o'alita e'nona yafe nehe.” hu'a apa'kai'api ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nehaya'maki Yisasi'a ani vaya'moki haya ke ako afiteno apa'kaeyafe inake he “Na'ya hiketapa ‘Ne'yati alita o'me'none.’ hutapa lapa'kaitapi huke afike nehae. Lapa'kesa afitapa alakepa hutapa o'afi'nafe? Lapaipamo'a a'kanile'niketapa o'afi'nafe? ");
INSERT INTO ino_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Lapaulaka hane'nea'maki aketapa alakepa ohu'nafe? Lapa'kesa hane'nea'maki afitapa alakepa ohu'nafe? Laya mako kaya maya ali'na kofa hu'na faefu tauseni (5,000) vaya'aipi apami'noa yafe ako lapake'kani'niketapa o'afi'nafe? Atupatapa'a alitapa aikeno na'maki kupi havaite'ne?” huno apafine'keke'a “Layatala'a hano huno laiyalekati aole alea kupine (12 kupine).” hu'a ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ha'nepaikeno inake nehe “Mako nayatekati aole maya ali'na kofa hu'na fo tauseni (4,000) vaya apamitoketapa atupatapa'a alitapa aikeno na'maki kupi havaite'ne?” huno apafine'keke'a “Laya mako kaya hano huteno laya mako kayati aole.” hu'a ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ha'nepaikeno apa'kaeyafe inake nehe “Lapa'kaeya lapa'kesa no'afitapae nehafe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Petesaita kumate va'yi nehake'a vaya'moki mako aulaka apo ka'nea ve'ka avale'a Yisasite ne'e'a inake nehae “Amuse'ka nehunaki kaya akufale malekeno aulaka kanale hino.” nehae. ");
INSERT INTO ino_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nehakeno Yisasi'a aulaka apo ka'nea ve'ka ayate aliteno ma'aileka avaleno lavino ate'neno aulakale avaitu'na neheno ayana ne'maleno inake huno afine'ke “Mako ya ne'akapi no'akane?” ");
INSERT INTO ino_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Afikekeno akeno asaka huno ake'neno inake nehe “Vaya ne'apa'koa'maki mako yosakana hu'a u'e'a nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hikeno Yisasi'a mako'ae ani kava huno ayana aulakale maletetekeno aulakamo'a kanale hikeno aulu heno akeana aulakamo'a halai hikeno mi'ko yana akeno alakepa huno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Akeno alakepa hutekeno Yisasi'a ani ve'kae “Ma kumate o'u'ka no'kalekake uvo.” hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisasi'a akaeya ke ne'afea anaka'ae Sisalia Filipai aupalika hane'nea kumate ukefe kateka ne'u'a apa'kaeyafe inake huno apafine'ke “Vaya'moki nakaeyafe nala'a mai'ne nehae.” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Apafine'keke'a ke anona'ale inake nehae “Mako vaya'moki kakaeyafe ‘Yoni'a li fale ne'apatea ve'ka mai'ne.’ hu'a hake'a mako vaya'moki ‘Ilaiya'a mai'ne.’ hu'a hake'a mako vaya'moki ‘Anumaya Koti aune ve'ka mai'ne.’ hu'a nehae.” hu'a ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ha'nepaikeno Yisasi'a apa'kaeyafe inake huno apafine'ke “Lapa'kaeya nakaeyafe nalaka mai'nane hutapa nehae?” huno apafikekeno Pita'a ke anona'alena akaeyafe inake nehe “Kakaeya Kalaisika Anumaya Koti lakufa alino katiseafe hukate'nea ve'ka mai'nane.” huno nehe. ");
INSERT INTO ino_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nehikeno Yisasi'a apa'kaeyafe apaumomo ne'maleno inake huno hapapaiye “Lapa'kaeya nakaeyafe ‘Kalaisi'a Anumaya Koti lakufa alino katiseafe hute'nea ve'ka ma mai'ne.’ hutapa mako vaya hapa'opaiyo.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ani afina Yisasi'a aepa heno henaka'a akai'a akufale fole aisea yafe akaeya ke ne'afea anaka'aife inake huno hapapaiye “Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ala ala vaya'ae mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae apa'kame'ya namite'a lusi nakafu kisea kava hunatete'a nahaesake'na falikoe. Falitesuke'a kelifi kinate'nisake'na aole'ae mako'ae kana fali'nisoapati ete'na hetikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yisasi'a ani ke alaki huno fole aino hapapaike'a Pita'a Yisasina mako aki'naleka avalenuno Yisasife inake he “O'nahaiya ke nehane.” huno ke ama'ki'ne. ");
INSERT INTO ino_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ke ne'ama'kikeno Yisasi'a maino afeleno akaeya ke ne'afea anaka'a ne'apa'keno Pitafe inake huno ke ama'ki'ne “Sataka e'ka na'kamelaka uvo. Kakaeya Anumaya Koti nehaiya aku akesale a'kame no'malapa vaya'moki ne'afea akufa kaku kakesa ne'afine.” huno nehe. ");
INSERT INTO ino_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ani ke huteno ali'a atalu hu'naya vaya'ae akaeya ke ne'afea anaka'ae ke hike'a akeno inake huno hapapaiye “Mako ve'kamo'a nakaeyafe afiteno na'kame malesuno'aena akai'a akufae akesa o'afino nakaeya nakafu kisike'na falisoa kava hisea akesa afiteno yofo yosa'a amete amete aki'nale kofi'neno na'kame eno. ");
INSERT INTO ino_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mako vaya'moki apavamu hanesike'a kanale mai ya'api atafa hu'a alaki huli'a maisayana ani apavamu'api fanane hukea'maki mako vaya'moki nakaeyafe hu'a nakaeya kanale ke'ni'a hapapaisaya yafe kanale mai ya'ae apavamu'ae atalesayana ani kanale mai yana alaki alino katipatesike'a akola maikae. ");
INSERT INTO ino_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inaki mako vaya'mokitapa lapavamu alitapa mai yafe lapa'kesa o'afitapa ma mopafi mi'ko yafe'ke lusiya huno lahapaisiketapa ne'alisayateti falisayana ani afeno ya'mo'a hana ya huno lapaya huno mai yana lapamike? ");
INSERT INTO ino_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Faliteno'aena ani ve'kamo'a hana akufa miya alinuno'a maike maike huno mai avamuna miya heno alike? He'e akola falino fanane hukeanakeno akola maike maike hisea avamu'a eteno o'alike. ");
INSERT INTO ino_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","O'alikea'maki mako vaya'moki meni afina hao'otake kava nehaya vaya'ae Anumaya Koti ke atalete'a alu kate ne'vaya vaya'ai folakapi mai'ne'a nakaeya ke hapapai yafe apavuya nehisaya vaya'aina nakaeya'ae ani kava hu'na henaka'a ko'ku'napi fate akufa kayo kayo vaya'ae Afo'nimo ano hale lo'kiya himamu ya'afi ne'e'na ani vaya'ai apa'ki ae yafe navuya hupatete'na Afo'nimo aulakalena a'na fole o'aikoe.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisasi'a apa'kaeyafe inake nehe “Lamake hu'na lahapa'nepauve male mai'naya vayapati mako vayama'a ofali'a mai'nisakeno Anumaya Koti'a ala lo'kiya'aleti kava ya alisiketapa aketetapa henaka'a falikae.” nehe ");
INSERT INTO ino_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yisasi'a aole'ae aole'ae aole'ae kana (6 kana) maiteno Pita'ae Yemisi'ae Yoni'ae apavaleteno mako hanafi hai'nea avimapi haite'a ani avimapi apa'kai'apike mai'ne'a akayana apaulakale Yisasi akufamo'a aino yahae huno fate kava hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Akufale huli'nea ku'kena'amo'a efe'ake nehuno alave alave hu'ne. Mako ma mopafi ve'kamo'a Yisasi kenamo hu'nea kava huno kena'a sese huno ani efe'ake kenakana ohinine. ");
INSERT INTO ino_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ani alave alave nehike'a ake'a mai'nakeno aole ve'kala a'ke'ainaka fali'na'a ve'kala Ilaiya'ae Mosese'ae fole ai'ana Yisasi'ae kake nehake'a apa'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kake hu'a mai'nakeno Pita'a Yisasife inake nehe “Kakaeya ali'ka laya nehana Nenao lakaeya male mai'nonana kanale nehe. Lakaeya kateka nona aole'ae mako'ae no kilapatesune. Kakaeya nonaki Mosese nonaki Ilaiya nonaki huta kilapatesunakeno hanese.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Akete'a lusiya hu'a koli nehaya yafe Pita'a “Hana akufa ke hapaisoe?” akesa afiteno ani ke nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ani ke ha'nepaikeno mako hiya'mo'a eno aino ati'kapate'nikeno ani hiyapakati mako ke hu'nea kemo'a inake nehe “Mani ve'ka nakai'ni mafa'nekeno lusiya huno nahau nayamopafati ne'nahaiya mafa'ne mai'neanaki kanale'ya hutapa ke'a afeo.” huno ake aino hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hapapaiteke'a makalema'a apaulaka ake'a afa ya hute'a akayana Yisasi'a mako vaya'ae o'mai'nifaka akai'ake mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ani avima atale'a nelavi'a Yisasi'a apaumomo maleno inake huno hapapai'ne “Lapa'kaeya meni ne'akaya yana mako ve'ka alaki ha'opai'nisake'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka fali'nisoapati hetisoa afina ani ke hutapa fole aitapa hapapaikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nehike'a ani ke a'kame male'a hapa'opai'naya'maki apa'kai'apike mai'ne'a “Fali'nisoapati hetikoe.” huno hea ke aepa'a o'afi'ne'a apa'kesa lapa aite'a “Na akufa kemofe mani ke hu'ne?” hute'a lusiya hu'a apa'kesa kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Apa'kesa kahau ate'a Yisasife inake hu'a afine'kae “Na'ya hike'a mono hapali'a hapa'nepaiya vaya'moki Ilaiya'a hokoteno etesikeno Anumaya Koti'a hutesikeno lakufa alino katisea nena henaka ekaiye hu'a nehae?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Afine'kakeno Yisasi'a inake huno hapa'nepaiye “He lamake Ilaiya'a hokoteno e'neno mi'ko yana eteno alino alakepa huno kate kate huno hokoteno hane'nea kava hukea'maki nakaeyafe Anumaya Koti avopi inake hu'a kamale'nayane ‘Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne ali'a haviya hunatesake'na nakufa nakafu kisike'a apa'kame'ya namikae.’ hu'a nakaeyafe hu'nayane. ");
INSERT INTO ino_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lahapa'nepauve Ilaiya'a ako e'nike'a Anumaya Koti avopi kamale'naya kate male'a mi'ko vaya'moki apa'kai'api afea apa'ku apa'kesa afea kava'ke hute'a mi'ko aki'ae aka'ae hao'otake kava'ke hute'nae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ani avimapati lavite'a mako akaeya ke ne'afea anaka'aina apa'keana lusi vaya'moki apa'kaeyate e'a anupa hu'a mai'nae. Mako mono hapali'a hapa'nepaiya vaya'ae e'a mai'ne'a ani Yisasi ke ne'afea anaka'ae ne'o'ne ke nehatake'a ke ne'vaiye. ");
INSERT INTO ino_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ke ne'vaike'a anile mai'naya vaya'moki Yisasina akete'a makalema'a lusi amuse nehu'a naku naku hu'a akaeyateka aya'ya'moki ali'a falu fala hune'atae. ");
INSERT INTO ino_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ali'a falu fala hutetakeno Yisasi'a apa'kaeyafe inake huno apafine'ke “Lapa'kaeya na yafe ne'o'ne ke nehataketapa ke ne'vaiye?” ");
INSERT INTO ino_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Apafikekeno mako ani vaya'aipi mai'nea ve'kamo'a inake nehe “Vae ali'ka apaya nehana Nenao Sata afe'mo'a mafa'ne'nimo aipafi mai'neno liko'a alino a'kanilekeno ake no'aiya yafe kakaeyateka avale'na ne'oe. ");
INSERT INTO ino_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mi'ko afina ani Sata afe'mo'a lusiya huno atafa huno alaki hu'neno asakauno mopafi yaka hune'atalekeno yave yave avaitu'namo'a avayafati selu selu nehikeno ave kume ne'kaneno aiya aya a'kenele. Ani yafe kakaeya ke ne'afea vaya'aiteka ali'a kanale hutesaya yafe avale'na e'noa'maki ani Sata afe ali'a atalesaya lo'kiya'api o'male'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nehikeno Yisasi'a ani ke afiteno inake nehe “Hae lapa'kaeya meni kanale mai'naya vaya'mokitapa nakaeyafe afitapa lapaipafi no'malayana nakaeya na'maki afina lapa'kaeya'ae mai'noanaketapa afikae? No'afea yafe alaka ne'nahaeye. Na'maki afina lapa'kaeyafe lapa'keva hisoe? Ani mafa'ne male avaletapa eo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hike'a ani mafa'ne avale'a akeno ani Sata afe'mo'a Yisasina ne'akeno lusiya huno aiya aya'mo'a yamo yamo nehuno makalema'a ani mafa'ne asaka huno yaka hutalekeno ani mafanemo avayafati avaitu'namo'a selu selu nehikeno havano helave helave uneno nehuno kase kase ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ina kava nehikeno Yisasi'a afo'amofe inake huno afine'ke “Na'maki afina mafa'ne'ka mani akufa ya nehaiye?” huno afine'kekeno afo'amo'a inake he “Hae aise mafa'neto mai'nikeno mani kava aepa heno hau'neane. ");
INSERT INTO ino_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mi'ko afina ani Sata afe'mo'a asaka huteno yaka hune'ataleno atafi asaka huno faine'ateno lipi'ae asaka huno yaka nehikeno falisea akufa kava nehike'na kakaeyate avale'na ne'oki kakaeya afa'a ali'ka kanale hutesana lo'kiya'ka hane'niseana kahau hula'ate'ka la'aya ho.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nehikeno Yisasi'a akaeyafe inake nehe “Na'ya hike'ka nakaeyafe ‘Ali'ka kanale hutesana lo'kiya'ka hane'nife?’ hu'ka nafine'kane? Nakaeyafe afino aipafi male'nea kanomo'a mi'ko fate fate ya'ko'ae kanale huke.” huno ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ha'nepaikeno makale'a ani mafa'nemo afo'amo'a inake nehe “He nakaeya kakaeyafe afi'na naipafi ne'maloa'maki kakaeyafe afi'na naipafi male ya'nimo'a aupa hu'niki kakaeya naya nehu'ka name'atiti hu ya'ni'a ali'ka lo'kiya vainato.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hikeno Yisasi'a akeana lusi vaya ete ete hu'a anupa hakeno Yisasi'a ani Sata afefe lo'kiya ke huno inake hu'ne “Kakaeya avaya'ae akesa'ae ali'ka a'kani'nana afena nakaeya ke nehuki mani mafa'ne atale'ka kaune he'ka uvo. Ute'ka visanatekati ete'ka mako'ae o'meno.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nehikeno ani Sata afe'mo'a ala kefati kalafa ne'kano ani mafa'ne asaka huno ne'ataleno lusiya huno aike amakike hune'ateno ani mafa'ne ataleno u'ne. Utekeno ani mafa'ne alaki fali'neke'kana kava huno maike'a lusi vaya'moki “Mafa'ne alaki fali'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nehakeno Yisasi'a ani mafa'nemo ayate atafau'neno alino hetitekeno heti'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hetitekeno Yisasi'a nopaka haino mai'nike'a akaeya ke ne'afea anaka'moki apa'kai'apike mai'ne'a inake hu'a afine'kae “Lakaeya na'ya hiketa ani mafa'nemo aipafati Sata afe alita atalesuna lo'kiyati o'male'ne?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Afine'kakeno Yisasi'a inake huno hapa'nepaiye “Mani akufa Sata afe alu yateti alitapa o'atalekafa Anumaya Kotiteka afikesaya ya'mo'ke alino atalekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ani kuma atale'a Kalili koteka u'e'a nehu'a akaeya ke ne'afea anaka'a alino apaya hukefe vaya'moki inaleka mai'ne hu'a afisaya yafe ohaikeno sa'ko hu'a fala'ki'a ne'vakeno Yisasi'a inake huno alino apaya nehe “Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne nakaeya navale'a vaya'moki apayapi natesake'a natafa hute'a nahaesake'na falikoe. Falisuke'a kinate'nisake'na aole'ae mako'ae kana maine'male'na ete'na hetikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hu'nea'maki ani kemo aepa'a afi'a ha ole'a ke hu'a afikekefe hu'naya'maki koli hute'a afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapaneamu kumate e'a va'yi nehu'a Yisasi'a nopi haino mai'neno akaeya ke ne'afea anaka'aife inake huno apafine'ke “Lapa'kaeya kateka ne'etapa na akufa ke hume e'nae?” ");
INSERT INTO ino_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Apafine'kea'maki apa'kaeya kateka ne'e'a “Lakaeyapatina nakaeya alama'a'api mai'nofi nala'a ala ve'kati mai'ne?” hu'a kateka hume e'naya yafe Yisasi'a apafine'kea'maki apavaya a'a a'kanile'a mai'ne'a ke ohu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ke ohu'a mai'nakeno Yisasi'a faitopale mai'neno aiyalekati aole alea anaka'ae inake nehe “Eke'na lahapapaino.” hike'a akaeyate akeno make nehe “Mako ve'kamo'a ala huno hokote kava ve'ka maisoe huno'aena mi'ko vaya'ai apa'kamelaka mai'neno kayo kayo huno apamisea kano maiseana hokote kava ve'ka maike.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Mako aise mafa'ne avaleno folaka'apifi ateteno ayapi anu'ki'neno inake nehe “Mako ve'kamo'a nakaeyafe afi'neno'aena ma akufa aise mafa'neto avaleno kanale huteseana nakaeya'ae alino kanale hunate'ne. Inaki nakaeya alino kanale hune'natea ve'kamo'a nakaeya'ke alino kanale huo'natea'maki hunateke'na e'noa Ne'ae alino kanale hune'ate.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hikeno Yoni'a inake nehe “Kava Nenao lakaeya mako ve'ka ake'nonana kakaeya kaki ne'ano Sata afe'yaka vaya'ai apaipafati alino ne'ataleketa ake'nona'maki lakaeya la'kame o'me'nea yafe ‘Ina akufa ali'ya mako'ae o'aleo.’ huta ‘He'e.’ hute'none.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nehakeno Yisasi'a apa'kaeyafe inake hu'ne “Lapa'kaeya ani ve'kamo alisea ali'yafe “Ina akufa ali'ya o'aleo.” hutapa ka a'kani o'apateo. Mako vaya'moki nakaeya nakileti o'ake'naya avame ya hu lo'kiya kava hisaya vaya'moki nakaeyafe makale'a hu'a haviya huo'natekae. ");
INSERT INTO ino_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lakaeya nelakeno kame ya huolatesea ve'ka lakaeya vayati mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mako ve'kamo'a lapa'kaeya nelapa'keno “Kalaisi vaya'a apavale'ne'na apaya hisoe.” huteno li hefi'neno lapamiseana nakaeya lamake hu'na lahapa'nepauve ani ve'kamo miya'a afa'a hane'nisikeno henaka'a kanale miya alike.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mako aise aise anaka'nimoki nakaeyafe afi'a apaipafi male'naya anaka'ne mako vaya'moki “Hao'otake kava ho.” huno avaleno yakaleno havi kate atesikeno viseana ani ve'kamo'a lusiya huno hao'otake kava neheanake'na havi akafu ya anona'a amikoe. Ala yafa'kefaleti ani ve'kamo liko'ale male'a nofi kitete'a ali'u'a hake lipi yaka hutalesayana ani havi akafu ya'mo'a afa ya'kana hu'nea'maki nakaeya havi akafu ya mako'ae lusiya hu'na amikoe. ");
INSERT INTO ino_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaya'mo'a “Hao'otake kava ho.” huno kavaleno yakaleno havi kapi visana kakesa kamisike'kaefena ani kaya hataka hu'ka atalo. Hataka hutalesanana kanalene. Haviku aoleka'a kayatala hane'neno hani yapi ata akola leke leke nehea ata kapi kavaleno yaka hutale yafe kakaeya mako kayana hataka hutaletesanakeno kakufa haviya hu'nea kano mai'nisanana mako kaya kakufa'amo'a kanale maike maike ya alise. ");
INSERT INTO ino_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ani ata leke leke nehea kumapina vaya'yaka atafi mai'nisakeno kanaki kafa vaya apa'kufafi maikea'maki alaki ofalikeanakeno ani ata'aena alaki asu ohuke. ");
INSERT INTO ino_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kaiyamo'a “Hao'otake kava ho.” huno kavaleno yakaleno havi kate katesike'kaena ani kaiya hataka hu'ka atalo. Hataka hutalesanana kanalene. Kakufa haviya hu'nea kano maisanana kanale maike maike huno hano ohisea kavamu'ka hanesea ve'ka maikane. Haviku aole kaiyala hane'neno hani yapi akola leke leke nehea ata kapi kavaleno yaka hutale yafenaki mako kaiya hataka hutalo. ");
INSERT INTO ino_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mani ata leke leke nehea kumapina vaya'yaka atafi mai'nisakeno kanaki kafa vaya apa'kufafi maikea'maki alaki ofalikeanakeno ani ata'aena alaki asu ohuke. ");
INSERT INTO ino_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kaulakamo akea ya'mo'a kavaleno yakaleno havi kapi visana kakesa kamisike'kaena ani kaulaka ali'ka lakati'ka atalo. Lakati'ka atalesanana kanalene. Mako'ke kaulaka'ake haneseana kanale Anumaya Koti'a kava yakaisea kumatena u'ka maikana'maki haviku aole kaulakamo'a hao'otake kava hisana kakesa kamike'ka hao'otake kava hu'nana yafe hani kumapi leke leke nehea atafi kavaleno yaka hutalese. ");
INSERT INTO ino_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ani ata leke leke nehea kumapina vaya'yaka atafi mai'nisakeno kanaki kafa vaya apa'kufafi maikea'maki alaki ofalikeanakeno ani ata'aena alaki asu ohuke. ");
INSERT INTO ino_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Hake ne'yate ne'aiya kava huno mi'ko vaya ataleti aipatekaiye. ");
INSERT INTO ino_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hake kanale ya hane'nea'maki haka'ake nehea ya'a hano hiseana hana kava hutapa haka nehea yama'a etetapa alitapa fole aikae? Hakekana yana lapaipafi hanesiketapa yuna hetapa mako'ke lapaipa lapa'kesale mai'netapa kiki yo'kalo hutapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisasi'a ani ko ataleno Yutia koteka uno Yotani li'mo umakaya falika uno va'yi nehike'a mi'ko vaya'moki akaeyateka e'a ali'a atalu hakeno mako'ae nehea kava huno alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Alino apaya nehike'a mako Falasi mono ke ne'afea vaya'moki Yisasite e'a hao'otake ke hisea'aene hu'a a'a avataka nehu'a ke inake hu'a afine'kae “Mako ve'kamo'a a'a ataleseana ke male male'nea ke alino atakaesifi afa'a kanale huke.” hu'a afike'nae. ");
INSERT INTO ino_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Afikakeno Yisasi'a anona'a ke'apile inake huno apafine'ke “Mosese kemo'a ani yafe na yane ke hu'ne?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Apafine'keke'a inake hu'a hae “Mosese'a mako ke male male'nea kemo'a inake huno lahapai'ne ‘Vemo'a a'amona avo kano ne'amino hutesikeno hano huno uke.’ huno hu'neane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nehakeno Yisasi'a inake huno hapapai'ne “Lapa'kaeya ke o'afitapa vekano'kano haya yafe Mosese'a a atalesaya ke male male'nea ke kamale'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","8","Kamale'nea'maki Anumaya Koti avopi inake huno kamale'neane ‘Anumaya Koti'a hae afina aepa heno ve'ae a'ae alo humale'ne. Ve'ae a'ae alo humale'nea yafe mako ve'kamo'a ita afo'amokani anataleno a'amo'ae aino lo'kakaiye. Ai'ana lo'kaesa'ana ani aolemokani mako'ke ana'kufa hapakaiye.’ huno hu'neane. Ina kava hinakeno mako'ae aole kanola o'maika'a'maki meni mako'ke ana'kufa hapake'ana mai'na'ae. ");
INSERT INTO ino_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ani yafe Anumaya Koti'a ana'kaeya ako alino hapainate'neanakeno mako mopale kanomo'a ani alavela'mokani mai ya'ani alino atane o'anatese.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mani ke huteno nopaka haino mai'nike'a akaeya ke ne'afea anaka'moki ani hu'nea ke afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Afine'kakeno inake huno hapa'nepaiye “Mako ve'kamo'a a'a ataleteno alu a aliseana ani ve'kamo'a hokote a'amoteka kumai kava hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ani kava huno mako a'mo'a anau'amona ataleteno alu vele maiseana kumai kava nehe.” huno nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vaya'yakamoki mafa'ne'api Yisasi'a aya malepatesea yafe apavale'a ne'ake'a akaeya ke ne'afea anaka'moki inake hae “Ina akufa kava oheo.” hu'a ke apama'ki'nae. ");
INSERT INTO ino_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yisasi'a ke apama'kea ya aketeno aipamo'a haviya hikeno inake nehe “Afa'a ka o'a'kanitapa afa'a apataleke'a ani aise aise mafa'ne nakaeyate eo. ‘Inamu mafa'ne mai'nonakeno lo'kiyati o'male'ne.’ hu'a nehaya vaya'mokike Anumaya Kotife ‘Yakailato.’ hu'a nehaya vaya mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lamake lahapa'nepauve mako vaya'moki aise mafa'nekana hu'a ‘Lo'kiya'ni o'maleki Anumaya Kotika kava yakainato.’ hu'a ohisayana Anumaya Koti'a kava yakaisea kumate alaki lamake o'ukae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Inake huteno Yisasi'a ani mafa'neyaka apavale'neno aya malene'apateno inake nehe “Anumaya Koti'a kanale manu lapa'kaeya lapamisiketapa kanale mai ya alikae.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yisasi'a hetino kateka ne'vikeno mako ala ve'ka lusi afeno male'nea ve'kamo'a naku naku vea'ya'mo'a aiyafi ale'ya lo a'neno inake nehe “Vae ali'ka apaya nehana kanale Nenao nakaeya hana kava hute'na maike maike hu'na mai navamuna alikoe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Afine'kekeno Yisasi'a akaeyafe inake nehe “Anumaya Koti akai'ake kanale ve'ka mai'nea'maki na'ya hike'ka nakaeyafe kanale ve'ka mai'nane hu'ka nehane? ");
INSERT INTO ino_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kakaeya Anumaya Koti ke male male'nea ke ako afi'nana kemo'a inake hu'ne kakaeya vayana hakeno ofalino. Kumai kava oho. Kumaya ya oho. Ma ve'kamo'a hao'otake kava nehe hu'ka kake'atike ke fai'ka mako vayafe hapa'opaiyo. Kake'atike ke hute'ka alu vaya'ai yana ali'ka kakai'kaleka o'malo. Ita'kafo'kamoki hisaya ke ali'ka o'ataka'ka kanale ya hu'ka a'kame malo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hapaikeno ani lusi afeno male'nea ve'kamo'a inake nehe “Vae ali'ka apaya nehana Nenao lamake nehana'maki nakaeya ani ke ako aise ya'nile mai'ne'na ani mi'ko ke a'kame male'noa kemofe nehane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hikeno Yisasi'a ani ve'kae lusiya huno aipafati haikeno ani ve'kaena inake huno hapai'ne “Mako kava ohu'nanaki ani kavana ho. U'ka mi'ko afeno ya'ka apamisanake'a miya ne'kamisayana ani miyana ali'ka afeno'api o'male vayana fa'ko fa'ka hu'ka apamite'ka e'ka na'kame malo. Ina kava hu'ka apamisanakeno Anumaya Koti ko'ku'na kumate mi'ko kanale nale afenona kamike.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hikeno ani ve'kamo'a ani ke afiteno lusi moni afeno male'neno o'atalesea yafe aukosa avayamo'a alino ananukiteno aipa akesamo'a lusiya huno kana hikeno ataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Utekeno Yisasi'a akaeya ke ne'afea anaka'amokiteka ne'apa'keno inake nehe “Lapa'kaeya ne'akafe lusi moni afeno male'naya vaya'moki lusiya hu'a kasake'ke ne'ai'a Anumaya Kotife ‘Kava yakailato.’ hu'a hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nehike'a Yisasi ke ne'afea anaka'amoki ani ke afite'a lusiya hu'a atali hakeno mako'ae Yisasi'a eteno mako ke inake nehe “Mafa'ne anakana afeo mako vaya'moki lusiya hu'a kasake'ke ne'ai'a Anumaya Kotife ‘Kava yakailato.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mako puluma'kakana afumo aki'a kamoloe nehaya afumo'a ne'kayamo kapi viseana afa'a yo'yo huno ukife? He'e o'vinine. Ani kava hu'a lusi moni afeno male'naya vaya'moki Anumaya Kotife ‘Kava yakailato.’ hu'a ke hu'a afike yafe lusiya hu'a kasake'ke ne'ai'a afino'kae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hike'a akaeya ke ne'afea anaka'moki ani ke afite'a lusi apamo'yo aike'a apa'kai'apifi ke uno hapaikeno eno hapaikeno nehu'a inake hu'nae “Ina kava hisike'aena hana ve'kamo'ke maike maike avamuna alise?” ");
INSERT INTO ino_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nehakeno Yisasi'a aulu hapalitata nehuno make he “Vaya'moki apa'kai'api lo'kiya'api o'male'neanake'a ohukaya'maki Anumaya Koti lo'kiya'a hane'neanakeno mi'ko yana afa'a alo huke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hikeno Pita'a inake nehe “Akeko lakaeya mi'ko yati ataleteta ka'kame ne'one.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Nehikeno Yisasi'a inake huno hapai'ne “Lamake kaha'nepauve mi'ko vaya'moki nakaeyafe afi'a apaipafi male'ne'a nakaeya kanale ke'ni'a vaya hapapaisune hu'aena no'api'ae nepu'apimoki'ae apasa'apimoki'ae ita afo'apimoki'ae mafa'ne'apimoki'ae mopa'api'ae apatale'a visayana Anumaya Koti'a ani ya huno mopale mai'naya kanafi atale'naya no'api'ae nepu'apimoki'ae apasa'apimoki'ae ita'apimoki'ae mafa'ne'apimoki'ae mopa'api'ae mako'ae mako'ae o'afunama'a ya apamisike'a havi vaya'moki hu'a haviya hupatesaya kana ya'ae apamisake'a alite'a henaka'a maike maike apavamu'ae alikae. ");
INSERT INTO ino_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Meni kanafi ala vaya mai'naya vaya'moki henaka'a aise vaya maikaya'maki meni kanafi aise vaya mai'naya vaya'moki henaka'a u'a hokote'a ala vaya maikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yelusalemu haikefe kate ne'u'a Yisasi'a hokoteno ne'vike'a akaeya ke ne'afea anaka'moki apamo'yo ai'a ne'vake'a a'kame ne'vaya vaya'moki'ae koli nehae. Koli nehakeno Yisasi'a eteno mako'ae laiyalekati aole alea anaka'a ma'aileka apavaleno lavi'neno henaka'a akaeyate hutesaya yafe hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Apa'kaeyafe inake nehe “Afeo lakaeya Yelusalemu haitesunake'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka natafa hu'a mono nopi kava vaya'ai apayapi'ae mono hapali'a hapa'nepaiya vaya'ai apayapi'ae natesake'a kake hunatete'a nahaesake'na falisoa ke hu'a hayate'a Isaleli nofi o'mai vaya'ai apayapi natekae. ");
INSERT INTO ino_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Natesake'a hu'a haviya hune'nate'a naukosafi apavaitu'na hene'nate'a heki kayoteti namakite'a yofo yosale nasaimale'ne'a nahaesake'na falikoe. Falitesuke'a kelifi kinate'nisake'na aole'ae mako'ae kana mai'nisukeno Anumaya Koti'a alino hetinatekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepeti mafa'nelana Yemisi'ae Yoni'ae Yisasite e'ana make hu'ana neha'ae “Hu'ka lavenelina Nenao mako ke kafikekefe nehu'a'maki ani ya hula'ato.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Neha'akeno Yisasi'a inake huno anafine'ke “Na ya hulanatesoa yafe neha'ae?” ");
INSERT INTO ino_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Anafikeke'ana akaeyafe inake hu'ana neha'ae “Ano hale lo'kiya himamu ya'kafi u'ka maisana afina la'akaeya kahaute mai'nisu'ake'ka mako'mofe ‘Lamaka nayateka maiyo.’ nehu'ka mako'mofe ‘Haoka nayateka maiyo.’ hu'ka hula'ato.” hu'ana afine'ka'ae. ");
INSERT INTO ino_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Afine'ka'a'maki Yisasi'a inake huno hanapai'ne “Nafika'a yana lana'kaeya afitana ha ole'na'ae. Falisoa yana atu'ake hu'nea li'kana neheanake'na ani li hane'nea kepati nakaeya nekauva'maki lana'kaeya lama'a na'aninipe? Nakaeya nakufale nakafu kisea yateti falenatesaya ya'mo'a lana'kaeya lana'kufale falelanatesayana afa'a ali'aninipe?” ");
INSERT INTO ino_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Hike'ana “He lo'kiyati'a hane'neanaketa'a ani kava afa'a huku'ae.” ha'akeno ana'kaeyafe inake nehe “Lamake atu'ake hu'nea lina neka'a'maki falenatekefe nehaya ya'mo'a nakafu ne'kea yana falelanatekae. ");
INSERT INTO ino_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Falelanatekaya'maki ala vaya ne'maiya yana lamaka nayateka'ae haoka nayateka'ae mai yana nakaeya ya o'male'niki Anumaya Koti'a akai'a yanakeno ani naya lamaka'ni'ae haoka'ni'ae maisaya vaya apa'keteno ako alino avatati huteno alino kanale hupate'ne.” ");
INSERT INTO ino_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nehike'a nayatala'a vaya'moki ani ke afite'a ani Yemisi'ae Yoni'aefe apaipa afi'a haviya hune'anatae. ");
INSERT INTO ino_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hu'a haviya hune'anatakeno Yisasi'a apa'kaeyafe ke hike'a akaeyate akeno inake nehe “Ma mopale ala kava vaya'moki ‘Lusi ala vaya mai'none.’ hu'a Isaleli nofi o'mai vayafe ke apama'ki'a ali'ya ke hune'apate'a kava vaya'moki nehaya kava nehae. ");
INSERT INTO ino_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ina kava nehaya'maki lapa'kaeya folakapi ina akufa kava o'malesikeno mako ve'ka ‘Nakaeya kava ve'katapi maikefe nehoe.’ hisea ve'kamo'a mi'ko vaya'ai kayo kayo ve'ka maise. ");
INSERT INTO ino_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Inaki ‘Nakaeya hokote kava ve'katapi maisoe.’ hisea ve'ka afa'a miya o'ali ali'ya ve'ka maise. ");
INSERT INTO ino_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nakaeya ani kava hu'noana ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na vaya'moki naya hu'a kanale hunatesaya yafe o'me'noa'maki nakai'ni apaya hu'na ali'ya kano'api maisoa yafe e'noe. E'ne'na nesu ve a'ne hao'otake ya'apimo'a nofi kipate'nea yapati kalu he'na apavalesoa miya hepatesoa yafe nakai'ni falikefe e'noe.” ");
INSERT INTO ino_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisasi'a akaeya ke ne'afea vaya'ae lusi vaya'yaka'ae Yeli'ko kumate va'yi hute'a akase'a ukefe nehakeno mako aulaka fali ka'nea ve'kamo aki'a Patimiasi'ae ani ve'ka Timiasi mafa'nekeno ka aki'nale mai'neno “Moni nameo.” huno au'kaya nehe. ");
INSERT INTO ino_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mai'neno “Yisasi'a Nasaleti kumateti ve'ka ne'e.” hu'a haya ke afiteno akaeyafe inake nehe “Yisasika Teviti akeho'amoka nakaeya kalaki ainato.” huno ka ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hike'a lusi vaya'moki ke ne'ama'ki'a “Ke ohu'ka maiyo.” hu'a nehaya'maki mako'ae ani ve'kamo'a yatalate ke hume ne'uno inake he “Teviti akeho'amoka nakaeya kahau hunato.” huno ka ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ani ke huno maiya'kena Yisasi'a makale anile mai'neno inake nehe “Hapaikeno eno.” huno hike'a aulaka fali ka'nea ve'kae ke hu'a inake hae “Kakaeyafe ke nehiki kaipamo'a lo'kiya vai'ni'sike'ka makale heteo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nehakeno akufale ya'a hatu'mano ne'ataleteno makale'a hetino Yisasite ne've. ");
INSERT INTO ino_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vikeno Yisasi'a akaeyafe inake nehe “Na kava hukatesoa yafe ne'kahaiye?” huno hikeno aulaka fali ka'nea ve'kamo'a inake nehe “Ali'ka apaya nehana Nenao nakaeya ete'na naulaka akesoe hu'nae nehoe.” ");
INSERT INTO ino_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nehikeno Yisasi'a inake huno ha'nepaiye “Afa'a uvo nakaeyafe afi'ka kaipafi male'nana ya'kamo'a ako alino kanale hukate'ne.” huno hikeno makale aulaka ne'akeno Yisasi a'kame u'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Yisasi'ae vaya'amoki'ae aole aise kumatalana Petafasi'ae Petani'ae ne'u'a Yelusalemu kuma'mo haute hane'nike'a ake'nae. Ani kumatalana Olivi yosa hane'nea avima'mo aki'naleka hane'nike'a Yelusalemu u'a lava'netae. Inaleti Yisasi'a aole akaeya ke ne'afi'a ve'kala hunateno inake huno hanapai'ne “Muka kumate vi'ao. Utana akesa'ana atupale note mako hosikana afu aki'a to'ki ana'au'a nofi ate'naya'maki mako ve'kamo'a fai o'mai'nea to'ki afu mai'neanaki kalu hetana avaletana male e'ao. ");
INSERT INTO ino_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mako ve'kamo'a ‘Na'ya hiketana ina kava neha'ae?’ huno hisiketanaena make hutana hi'ao ‘Ala Neti'amo'a mako ali'ya alikefe hiketa'ae ne'avalo'ae. Ali'ya aliteno makale'a eteno lapamike.’ hutana hapai'ao.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ani ve'kala'mokani u'ana ani to'ki ana'au'a no kipate nofi atakeno kate hetino mai'nike'ana ake'ana fole aite'ana nofi ali'ana kalu neha'ae. ");
INSERT INTO ino_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ali'ana kalu neha'ake'a mako anile heti'naya vaya'moki inake hu'a anafine'kae “Na kava hukefe ina to'kimo nofina alitana kalu neha'ae?” hu'a anafike'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nehake'ana Yisasi'a “Inake hutana hi'ao.” huno hea ke hapa'nepai'ake'a ani vaya'moki “Afa'a ani to'ki avaletana vi'ao.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ani hosikana afumo ana'au'a Yisasite avale'ana u'ana ana'kai'ani ana'kufaleti yasi siota ali'ana ani afumo akotofule ya'kaimaleta'akeno Yisasi'a anile faimai'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Faimai'neno kate ne'vike'a lusi vaya'moki “Ala ve'ka ne'e.” hute'a mai'nayapati mako'amoki apa'kufaleti yasi ya'api asakimale'a ani Yisasi'a ukefe hea kate ne'malake'a mako vaya'moki hoya'apifakati yosa haita'a hane'nea a'kopa alo a'a ali'e'a kapi ne'malae. ");
INSERT INTO ino_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne'male'a aukosaleka'ae a'kameleka'ae ne'vaya vaya'moki ala kefati inake nehae “Lakufa ali'ka katisana ve'ka kanale'ya hu'ka ne'ane. Anumayamo ali'ya alisana yafe hukate'nea ve'kamoka Anumaya Koti'a kanale amuse ya kamino kaha'ma'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lakinakomo'a Teviti'a a'ke'ainaka kava ya alino yakai'nea akufa kana meni eteno va'yi neheanakeno Anumaya Koti'a kanale huno aipamo'a falu hisea amuse ya amisikeno kanale'ya huno kava alino yakaike. Ani kava hisea yafe hanafi mai'nea Anumaya Koti aki'a alita asaka nehuta amuse hutesune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nehakeno Yisasi'a Yelusalemu va'yi huteno ala mono nopi uno mi'ko ani mono nopi hane'nea yana vase huno akeno alakepa huno akeme ne'vikeno hani hu ya hikeno ataleno layatala'a hano huno laiyalekati aole alea anaka'amoki'ae Petani u'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eka'a kotike'a Petani kuma atale'a kateka ne'akeno Yisasi'a aka nele. ");
INSERT INTO ino_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aka nelekeno aulaka alino akeana mako haitamo'a nati nati hu'nea fi'ki yosa afaki huke kana'ale hane'nikeno ake'ne. Aketeno Yisasi'a ani yosa aepale uno mai'neno mako alaka a'nisea'aene huno havake kaleke hu'nea'maki ani afina fi'ki yosamo'a alaka no'aeya kanalenakeno ne'yama'a o'ano haitamo'ke lusi kava hu'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yisasi'a ani yosaena inake nehe “Kakaeya ne'yama'a'ka o'malana yafe alaki mako'ae alaka o'aesanake'a vaya'moki laki'a o'nesayane.” huno ke ama'kike'a akaeya ke ne'afea anakamoki ani ke afi'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yelusalemu u'a va'yi hute'a Yisasi'a ala mono nopi hai'neno mi'ko moni afeno male'a ne'alea vaya'ae anifati miya nehaya vaya'ae aepa heno hapafai ne'atale. Hapafai ne'ataleno alu koteka moni ali'e'a ne'atale'a ani kumateti moni ete'a ne'alea vaya'ae mi'ko mai'ne'a namayaka apate'a mai'nake'a miya nehaya hipa'ae alaki alino atale'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Alino apataleke'a apaune nehakeno afeno'api alitata haya vaya'aife inake nehe “Ani afenotapi alitetapa ma mono nopina ute eta oheo.” huno ka a'kanipate'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ina kava huteno Yisasi'a inake huno alino apaya nehe “Anumaya Koti avopatina make hu'ne ‘Nakaeya nofe mi'ko vaya'moki Anumaya Kotiteka afikesaya none.’ hu'a nehaya no hane'nea'maki lapa'kaeya mani nofe afitapa kala kala hutetetapa fala'ki yapaka kumaya vaya'moki kuma'kana kava nehae.” ");
INSERT INTO ino_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hike'a mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae Yisasi'a ani hea ke afite'a ke hu'a imafi mafi nehu'a aepa he'a Yisasina haesaya kafe kahau a'naya'maki mi'ko vaya'moki Yisasi'a hea ke afite'a hapau haleke'a apamo'yo ne'aiya yafe koli hute'a atale'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ataletakeno hani kike heapaka Yisasi'ae akaeya ke ne'afea anaka'ae Yelusalemu atale'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eka'a natepati ete'a e'naya kate ne'u'a akayana ani Yisasi'a ke ama'ki'nea fi'ki yosa ako vai'nike'a ake'nae. Alaki mi'ko haita'ae hafu'ya'ae vaino avaya'ne. ");
INSERT INTO ino_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Vai'nikeno Pita'a ani yosae Yisasi'a hu'nea ke akesa ne'afino Yisasife inake nehe “Hae ali'ka laya nehana Nenao ako eka ma fi'ki yosaena mako'ae ne'ya'a ali o'atesanane hu'nana yosamo'a ako vai'ne.” ");
INSERT INTO ino_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Nehikeno Yisasi'a inake huno hapa'nepaiye “Anumaya Kotife inake hutapa heo ‘Kakaeya mi'ko yana afa'a alo hukane.’ hutapa lapaipafi maletapa lo'kiya vaisayana nakaeya lamake hu'na lahapa'nepauve mako ve'kamo'a Anumaya Kotife afino aipafi maleno lo'kiya vai'neno aole akesa o'afino mako'ke akesa afi'neno ‘Mika avima'moka a'kalafa lavi'ka hake lipi laveo.’ huno hiseana ani avima'mo'a ke hiseama'a huno ani kava huke. ");
INSERT INTO ino_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ani kava hisea yafe nakaeya lahapa'nepauve. Lapa'kaeya mako yafe Anumaya Kotiteka afikesutapaena ‘He lamake Anumaya Koti'a mi'ko afine'kona yana lamike.’ hutapa lapa'ku lapa'kesa afisakeno'aena ani ke hu'naya yana lapamisiketapa alikae. ");
INSERT INTO ino_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lapa'kaeya hetitapa Anumaya Kotiteka afine'kesakeno ani kanafi mako ve'kamo'a lapa'kaeyateka havi kava hulapate'nisea lapa'kesa afitapaena ani ve'kamo hao'otake ya'aena ‘Kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.’ nehutapa ani hao'otake ya'a alitapa ataletesayana Afotapimo'a ani kava huno lapa'kaeya hao'otake yatapi'ae alino atalekaiye. ");
INSERT INTO ino_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Inaki lapa'kaeya hao'otake ya'ae ‘Kahaove katove nehu'na naipa falu yapati ali'na ataloe.’ ohutapa ke ne'ama'kitapa lapaipa falu hu o'apatesayana ko'ku'napi mai'nea Afotapimo'ae ani kava huno lapa'kaeya'ae ke nelapama'kino hao'otake yatapi lahapaove lapatove nehuno aipa falu yapati alino o'atalekaiye.” ");
INSERT INTO ino_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Apa'kaeya ete'a Yelusalemu u'a va'yi hute'a Yisasi'a ala mono nopi uneno nehike'a ani mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ani kumate alopa vaya'ko'ae akaeyate e'nae. ");
INSERT INTO ino_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","E'ne'a inake hu'a afine'kae “Kakaeya hana akufa kaki hane'nea ve'kake'ka mani akufa ali'yana ne'aline? Hana ve'kamo'a ‘Inani akufa ali'ya aleo.’ huno kahapaiteno lo'kiya kami'nike'ka mani ali'ya alime u'ke'ka nehane?” ");
INSERT INTO ino_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yisasi'a apa'kaeyafe inake nehe “Nakaeya'aeti mako ke lapafikesuketapa lapa'kaeya ‘Ina kemofe nehane.’ hutapa hisake'naena nakaeya mani ali'ya ne'aloa lo'kiyamo avake'a lahapapaikoe. ");
INSERT INTO ino_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Inake hu'na lapafine'koe ‘Yoni'a li fale nelapatea yana Anumaya Koti'a ko'ku'napati lapami'nea yapi afa'a vayatafa'moki lapami'naya yane?’ Ani yafe hutapa fole aitapa nahapaiyo.” ");
INSERT INTO ino_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hike'a apa'kai'api ke hu'a u'e'a nehu'a inake nehae “Anumaya Koti'a ko'ku'napakati lami'nea yane huta hisunana halate lakaeyafe ‘Na'ya hiketapa afitapa lapa'ku'ale no'malae?’ huno huke. ");
INSERT INTO ino_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","33","Hukea'maki mi'ko vaya'moki Yonife ‘Anumaya Koti aune ve'ka mai'ne.’ hu'a hu'naya yafe lakaeya ‘Afa'a vaya'moki hute'naya ve'ka mai'ne.’ huta hisuna kena ani vaya'moki ke lama'kikae.” hu'a afite'a ani vaya'aife koli nehu'a Yisasife inake nehae “Lakaeya o'afi'nonanaketa huta fole aita kaha'opaikaune.” hu'a hakeno Yisasi'a apa'kaeyafe inake nehe “Lapa'kaeya naha'opaisayana nakaeya'ae ani kava hu'na ali'ya ne'aloa lo'kiya'nimo avake'a lahapa'opaikoe.” ");
INSERT INTO ino_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisasi'a aepa heno mako avoya ke inake hu'ne mako ve'kamo'a nofi alaka hoya vaimaleteno keki'ya huno veko humaleteno ani nofi alakayaka laki'a male'ne'a a'a latapaisakeno li'amo'a lavisea keli mopafi kafimaleteno ani hoyale yakai'a maisaya nona hanafi kimaleteno mako vaya'aife ke hike'a akeno “Ma hoyale yakaiyo.” huno hupateteno ani ve'ka ako faki koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ne'ya afu nelesifi kanalena ani hoya aepa ve'kamo'a mako ali'ya ve'ka'a hutekeno hoya'ale ne'yakaiya vaya'aiteka uno ani hoya'afati ne'ya mako amisakeno alilino eseafene huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hutekeno u'nea'maki ani hoyale yakai'naya vaya'moki ani ali'ya ve'ka atafa hu'a hate'a “O'kamikunaki halate ete'ka uvo.” hu'a hutakeno eteno u'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eteno vikeno hoyamo afo'amo'a halate eteno mako ali'ya ve'ka'a hutekeno vike'a ani hoyale yakai'naya vaya'moki ani ve'ka'ae atafa hu'a anu heve kaleve nehu'a ne'amaki'a ali'a haviya havaya hutete'a avuya hisifi kava hute'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hutakeno hoyamo afo'amo'a eteno fate ali'ya ve'ka'a hutekeno ani hoyale ne'vike'a hakeno fali'ne. Falitekeno hoyamo afo'amo'a mi'ko ali'ya vaya'yaka'a hupateke'a vaya vaya'aipati mako ali'ya vayama'a apatafa hu'a kayo ne'apamaki'a mako vayama'a alaki hapake'a fali'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ina kava hutakeno mako'ke'ake mai'ne. Ani ve'ka hau ayamopafati nehaiya mafa'ne'a mai'nikeno afo'amo'a inake nehe “Mafa'ne'nimo ke afikae.” nehuno hutekeno henaka ani hoyale u'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","U'nike'a ani hoyafi ne'yakaiya vaya'moki inake nehae “Mamona ani hoyamo afo'amo mafa'ne. Afo'amo'a falisikeno'aena mani mafa'nemo'a mani hoya alikeanaketa ako haesunakeno falise. Falisiketaena ani hoya lakaeya ya hapakaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Atafa hute'a hakeno faliteke'a hoyafati akufa'a ali'a ma'ailaka yaka hutale'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yisasi'a inake huno apafine'ke “Ani kava hu'naya'maki hoyamo afo'amo'a hana'ya hupatekaiye? Afo'amo'a uno ani hoyale ne'yakaiya vayana lesate hapaesike'a falikae. Fali'a hano hisakeno fate vayafe ‘Etapa ani hoyale kava yakaiyo.’ huno hupatekaiye.” ");
INSERT INTO ino_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yisasi'a inake huno apafine'ke “Mani ke Anumaya Koti avopi ako hapalitapa afi'nafi o'afi'nae? Inake hu'neane ‘Vaya'moki yafateti no ne'ki'a mako yafafe haviya he hu'a ne'atalaya'maki ani yafa'mo'a henaka'a mi'ko yafa apa'kase'nea yafanake'a atakonale ne'malaya yafa hane'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anumayamo'a ani ya alino kanale'ya hu'nea yafe ne'aketa alaki kanale ya hane'ne huta nehune.’ hu'a kamale'nayane.” ");
INSERT INTO ino_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yisasi'a ani ke hike'a mono nopi kava vaya'moki “Mani avoya ke lakaeyafe nehe.” hu'a apa'kesa afite'a inake nehae “Avaleta nofi hutekaune.” hu'a nehaya'maki ali'a atalu hu'naya vayafe koli hute'a Yisasina atale'a ako u'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Apa'kaeya mako Falasi mono ke ne'afea vaya'ae mako Heloti anaka'ae hupatake'a Yisasina afikesakeno hisea keleti atafa hu'a haesaya yafe Yisasina a'a avataka hukefe amete u'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Akaeyateka u'ne'a inake hae “Ali'ka apaya hu ve'kamoka lakaeya ako afi'none kakaeya lamake'ake ke nehana ve'ka mai'nane. Kava vaya'ae afa vaya'ae mako'ke kakesa afi'ka ne'apami'ka mako'ke kate male'ka ke nehane. Vaya'moki afi'a amuse hukatesaya ke nohana'maki kakaeya lamake ke'ake nehu'ka Anumaya Koti'a ‘Ma kate uvo.’ huno hea kate lahapai'nane. Kakaeya hana akufa kakesa ne'afine ta'kesi miyati Sisa'a kava kanole kanale miya hesupi ohesune?” ");
INSERT INTO ino_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nehaya'maki Yisasi'a apaipafi ne'apa'keno “Lapa'ke'atike'ake vaya mai'netapa amekati ke nehae.” huteno apa'kaeyafe nake nehe “Na'ya hiketapa atapa navataka nehutapa natafa hisaya yafe nafine'kae? Mako moni alaka'a alitapa nakaeyateka eke'na akeno.” ");
INSERT INTO ino_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hike'a mako moni alaka'a ali'e'a amikeno inake huno apafine'ke “Ani monilena nala aukosa'ae nala aki'ae hane'ne?” huno hike'a “Kava ve'ka Sisa aki'ae aukosa'ae hane'ne.” ");
INSERT INTO ino_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nehakeno Yisasi'a apa'kaeyafe inake huno nehe “Sisa yana Sisateka ne'amitapa Anumaya Koti yana Anumaya Kotiteka anona'a ameo.” huno hike'a ani hea ke apa'kesa lapa ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mako Satiyusi mono vaya'moki mako ke afikekefe Yisasite e'nae. Ani vaya'moki vaya fali'nayapati ete'a he'otikae hu'a nehaya mono vayane. ");
INSERT INTO ino_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yisasife inake hu'a afine'kae “Ali'ka apaya nehana Nenao Mosese'a lakaeyafe ‘Ma kava heo.’ huno kamale'neane mako ve'kamo'a mafa'ne ali o'ate'neno a'a ataleno faliseana akana'amo'a ani a aliteno mafa'ne ali o'ateno fali'nea ve'kamo akile mafa'ne aliteteno alino malese huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inaki naya mako kaya hano huno naya mako kayati aole alea konakafati yake ve'kamo'a mako a aliteno mafa'ne ali o'ate ve'ka fali'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Falitekeno ani'ale ve'kamo'a ani ana ali'nea'maki ani kava huno mafa'ne'a o'mai ve'ka fali'ne. Eno ani'ale ve'kamo'a ani akufa kava'ke hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ani kava hu'a mi'ko konaka'amoki mako'ke a'ke alite'a mafa'ne'api ali o'ate'a falite falite hume u'a alaki naya mako kaya hano huno naya mako kayati aole alea konaka mi'koma'a fali'a avaya atakeno ani a'ae henaka'a fali'neane. ");
INSERT INTO ino_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Inaki naya mako kaya hano huteno naya mako kayati aole alea konakamoki mako'ke a ali'ne'a falite falite hu'nayanake'a henakama'a mi'ko vaya fali'nayapati ete'a hetisaya kanalena hana ve'kamo'a ani ana alike?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Afine'kakeno Yisasi'a inake huno hapapai'ne “Lapa'kaeya Anumaya Koti avopi kamale'nea ke'ae Anumaya Koti lo'kiya'aena o'afi'netapae lapa'kaeya havikunaku ke nehae. ");
INSERT INTO ino_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mi'ko vaya fali'nisayapati hetisayana ko'ku'napi kayo kayo vaya'kana hu'a maikae. Mako ve'kamo'a ana o'alisikeno mako a'mo'a ani kava huno velena o'maike. ");
INSERT INTO ino_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fali'naya vaya ete'a hetisaya yafe lapa'kaeya Mosese'a kamale'nea avona hapalitapa o'ake'netapae nehafe? Mako aise yosalena lusi ata kanefe ai'nea'maki ani yosa alaki leno asaka oli'ne huno kamale'nea ke afi'nafi o'afi'nae? Anumaya Koti'a ani afina Mosesefe inake huno hu'ne ‘Nakaeya Epalahamu'aki Aisa'ki'aki Ye'kopu'aki apa'kaeya Anumaya Koti'apimo'na mai'noe.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ani anaka fali'naya'maki ‘Apa'kaeya Anumaya Koti'api mai'noe.’ huno hu'nea kemo'a fali'naya vaya'ai Anumaya Koti'api o'mai'nea'maki ani vaya'moki apa'ku apame ofali'a afa'a mai'naya yafe ani ke nehe. Lapa'kaeya ‘Fali'naya vaya he'otikae.’ hutapa nehaya ke lapa'ke'atike nehae.” ");
INSERT INTO ino_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mako mono hapalino hapa'nepaiya ve'ka eno ke huke afike nehaya ke afiteno Yisasi'a anona'a ke'apile kanale'ya huno hapa'nepaikeno afiteno ani ve'kamo'a Yisasife inake huno afine'ke “Anumaya Koti'a lo'kiya ke male male'nea kefi hana kemo'a alaki apa'kaseno mako'ae hokote ke hane'ne?” ");
INSERT INTO ino_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Afine'kekeno Yisasi'a inake nehe “Mani hokote lo'kiya kemo'a inake hu'neane ‘Isaleli vaya'yaka afeo Anumayamo'a lakaiti Anumaya Kotitimo akai'a mako'ke'ake mai'niki kakaeya Anumaya Koti'kamofe kahau kayamopafati lo'kiya vaino kahaino. Mi'ko kakesa afi ya'ae kaku kame afisana ya'ae ali'ya ne'alina lo'kiya'ae Anumaya Koti ameo.’ ");
INSERT INTO ino_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Inake huno maleteno ani'ale male'nea kemo'a inake hu'ne ‘Kakai'kae kahaike'ka mako ya'mo'a nahaesiki natesiki nehana avamete male'ka mako vaya'aife ani avamete apa'kaeya apa'kufaena kahaino.’ Mani aole ke kaha'nepauva kemo'a Anumaya Koti ke male male'nea ke'afina ako apa'kase'na'ae.” ");
INSERT INTO ino_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nehikeno ani mono hapalino hapa'nepaiya ve'kamo'a Yisasife inake nehe “Ali'ka apaya nehana Nenao kanale ke nehane. Kakaeya alaki lamake nehane. He Anumaya Koti akai'a mako'ke'ake mai'nea'maki mako fate Anumaya Koti alaki o'mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","O'mai'neanaketa lakaeya mi'ko lahau layamopafati lahaisiketa mi'ko afi yatifati'ae mi'ko ali'ya ne'aluna lo'kiyati'ae akaeyafe lusiya huno lahaise. Nelahainaketa lakaite nelahaiya avamete vayatimokife lusiya huno lahaise. Lakaeya inani aole kavatala mi'ko afina a'kame maleme haisunana ani kava'mo'a a'ke'ainaka vaya'moki afu he'a Anumaya Kotiteka amuse ya ne'amea kavana akaseno mi'ko aki'ae aka'ae kava nehuta Anumayamo aki alita asaka hisuna kava'ae akasekaiye.” ");
INSERT INTO ino_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nehikeno Yisasi'a ani huno fole aiya ke ne'afino “Akenopa hale'nea ve'kakeno kanale ke naha'nepaiye.” huno akaeyafe inake nehe “Kakaeya Anumaya Kotife ‘E'ka yakainato.’ hu'ka hisana ya'kamo'a alu'ale o'male'ne.” Hike'a mi'ko vaya'moki koli'a hute'a mako ya'ae Yisasiteka mako'ae afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisasi'a ala mono nopi haino ve a'ne alino apaya nehuno inake nehe “Na'ya hike'a mono hapali'a hapa'nepaiya vaya'moki ‘Anumaya Koti lakufa alino katikefe hute'nea ve'ka Kalaisife Teviti akeho'amo'a mai'ne.’ hu'a haya kemo aepa'a na'yane nehae? ");
INSERT INTO ino_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Anumaya Koti Fate Akufa Avamu'amo'a Tevitina aku akesa amikeno Teviti'a akai'a avayafati inake hu'ne Anumaya Koti'a Anumaya'nimofe inake hu'ne ‘Kakaeya naya lamaka'a hokote vaya mai'nayateka e'ka faitopale mai'nisanake'na kame vaya'ka apavale'na kaiyafi apatesuke'a mai'ne'a kakaeyafe ako lakase'ka ala kava ne mai'nane hu'a hukae.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Teviti'a akai'a Kalaisife ‘Anumaya'ni mai'nane.’ huno hu'nea'maki na ya hikeno Teviti'a henaka'a alitesea akeho'amofe ‘Anumaya'ni mai'nane.’ hu'ne?” Yisasi'a apafine'keke'a mi'ko ali'a atalu hu'naya vaya'moki ani Yisasi hea ke afite'a amuse nehae. ");
INSERT INTO ino_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yisasi'a alino apaya nehuno inake huno hapapai'ne “Mono hapali'a hapa'nepaiya vaya'aife maitapa halove hu'netapao. Hao'otake kava nehaya kavana lapa'kame'ya ameo. Ani vaya'moki yatala yatala kena'ake havaili'a maisaya yafe'ke nehapauno mi'ko vaya ali'a atalu hu kumate ute ete hu'a mi'ko ve a'nemoki ‘Ma kano ne'ape?’ hu'a falu fala hupatesaya yafe'ke nehapaiye. ");
INSERT INTO ino_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mi'ko afina mono nopi mi'ko vaya'moki apaulakale'ke ne'mai'a ala ne'ya ne kanale'ae ‘Nakaeya ala ve'ka mai'noanake'na hokote'na maikoe.’ nehu'a hokote hipale'ke maike hisaya yafe'ke lusiya huno nehapaiye. ");
INSERT INTO ino_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ani vaya'moki kaite a'ne'aife ake apavataka huke nehu'a ‘Mono nopi atalesana miya lameo.’ hu'a ani kaite a'ne'ai nopi hane'nea ya'yaka kumaya'ya hakeno moni'api hano he. Ina kava nehu'a vaya'moki ‘Kanale ve'ka mai'ne.’ hu'a hisaya yafe apa'ke'atike ke hu'a Anumayamoteka yatala ke hu'a afine'kae. Ina akufa kava nehaya yafe henaka'a Anumayamo'a kake hulatesea kanalena ani vaya'moki lusiya hu'a havi kana ya alikae.” ");
INSERT INTO ino_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisasi'a mono nopi amuse ya moni ne'atalaya ya hane'nea aupalika mai'neno amuse ya'api atalayama'a apa'keno mai'ne. Mai'neno apa'keana ala moni'api hane'nea ve a'nemoki ala amuse ya'api ali'e'a atalete atalete hu'naya ya ake'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Atalete atalete hakeno mako amute o'male kaite a'mo'a ani kava huno aole aise haesa monitola atale'ne. Ani monila ali'a male'a lo'kakeno nayatala toya alo hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yisasi'a ani ana aketeno akaeya ke ne'afea anaka'aife ke hike'a akaeyate akeno inake huno hapapai'ne “Nakaeya lamake hu'na lahapapauve mika amute o'male kaite a'mo'a mi'ko ala moni ali'e'a atalaya vayana apa'kaseno ala moni alineno atale'ne. ");
INSERT INTO ino_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ataleke'a ma mi'ko'amoki ala moni'api apa'kai'apileka hane'nike'a ali'ya'a o'malekeno afa'a male'nea moni afa'a mako'ato'a ali'e'a atale'naya'maki mani a'mo'a alaki mi'ko ya'a o'male'nea a'mo'a mi'ko male'nea moni ne'ya miya hisea ya'a alaki alineno atalekeno avaya a'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisasi'a ala mono nopati ataleno ne'vikeno mako akaeya ke ne'afea ve'kamo'a inake nehe “Akeko ali'ka laya nehana Nenao ala kanale yafateti ma konakali no'yaka kimale'nae.” ");
INSERT INTO ino_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nehikeno Yisasi'a akaeyafe inake nehe “Kakaeya mani ala kanale no'yaka ake'nape? Ma ne'akana yana mako kana va'yi hiseana mako yafa'mo'a mako yafa'mo akofetule ohanekaiya'maki mi'ko ani yafa no'mo'a atakufa lavike.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisasi'a Olivi yosa hane'nea avima'mo aki'naleka haino faitopale mai'neno ani ala mono nona umakaya hane'nikeno ne'akeke'a Pita'ae Yemisi'ae Yoni'ae Etalu'ae apa'kai'apike Yisasi'ae mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Mai'ne'a Yisasife inake hu'a afine'kae “Na afina ani ya va'yi huke? Na akufa avame ya va'yi hinaketa aketesunakeno ani kana makale va'yi huke huta hukune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Afine'kakeno Yisasi'a inake huno hapapai'ne lapa'kaeya maitapa halove hu'netapao. Haviku apa'ke'atike'ake vaya'moki apa'ke'atike ke lahapapaisaketapa afikae. ");
INSERT INTO ino_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nesu vaya'moki e'a nakaeya naki ne'a'a inake hukae “Nakaeya Anumaya Koti'a hunateke'na e'noa ve'ka mai'noe.” hu'a apa'ke'atike ke hu'a mi'ko vayana a'a apavataka hukae. ");
INSERT INTO ino_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Mako koteka la nehae.” ke ne'afitapa “Fate koteka la hukae.” hu'a hisaya ke afikaya'maki lapaipa lapame'mo'a halekeno o'maino. Inani akufa ya va'yi hukea'maki ma mopa hano hisea kana'a makale va'yi ohuke. ");
INSERT INTO ino_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mako nofi anaka'moki mako nofi anaka'ae heti'a la hukae. La hisake'a mako mopale vaya'moki heti'a mako mopale vaya'ae la hukae. Lusiya huno alu kote kote ala imima alike. Ala kafu hu'a apa'katesea ya va'yi huke. Ani ya'yaka afa'a a'nemoki mafa'ne alitekefe nehakeno hokoteno apa'kafu ne'kea avamete maleno kikea'maki henaka'a lapa'kaeya lusi lapa'kafu kike. ");
INSERT INTO ino_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Lapa'kaitapi yakaitapa alakepa heo. Vaya'moki lapavale'a kanisole vaya'aite kake hulapatekae. Mono nopi lapavale'a u'a kayo lapamikae. Nakaeya ke hu'naya yafe lapavale'a ala kava vaya'aite'ae apa'kase'naya yahauve vaya'aite'ae hetisake'a kake hulapatesaketapaena nakaeya kanale ke'ni lapa'kaeya hapapaikae. ");
INSERT INTO ino_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hapapaikaya'maki hokote'a Yisasi kanale ke vaya'moki ali'a ute ete hu'a mi'ko koteka vaya'aina hapapaisake'a afitesakeno ma mopa hano huke. ");
INSERT INTO ino_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lapavale'a u'a kake hulapatekaya'maki lapa'kaeya “Na'yane ke hukune.” hutapa lapa'kesa lapa o'aitapa afa'a veo. Kake hulapatesaya kana va'yi hinaketapaena Anumaya Koti lahapapaisea ke'ake heo. Ani ke lapa'kaeya ke o'maleki Anumaya Koti Fate Akufa Avamu'amo'a huno lapa'kesale hinaketapa hukae. ");
INSERT INTO ino_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ani afina lapa'kaitapi neputapimoki lapavale'a kake hulapatesaya yafe kame vaya'ai apayapi lapatesake'a mako'a apamaki'a kipatekae. Afo'apimoki mafa'neyaka'ape inake hukae “Hapaesake'a falisae.” hukae. Mafa'neyaka'apimoki ita afo'apimoki ai'a yahae hu'a kame ya hupate'a kake hupate ve'kale apavale'a kake hupatete'a hapaesake'a falikae. ");
INSERT INTO ino_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lapa'kaeya nakaeya naki'ae ke'ni'ae afitapa na'kame male'naya yafe mi'ko vaya'moki apaipa kafa lahapakae. Lahapakaya'maki mako vaya'moki nakaeya ke meni afina aepa he'a atafa hu'a lo'kiya vaime vaime u'a lo'kiya vai'naya yafe Yisasi'na ete'na esoa afina nakaeya ke atafa huli'nisaya vaya'aina Anumaya Koti'a apaipa apame alino katike. ");
INSERT INTO ino_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yisasi'a inake nehe “Lusiya huno ma mopa alino haviya hisea yana lamo'yo aisea kava hisea yana fate akufa nopi heti'nisiketapa akekae.” hu'ne. Ani Yisasi'a hu'nea ke hapalitapa afisaya vaya'mokitapa afita alakepa hutapa afeo. Yisasi'a inake hu'ne “Ani lapamo'yo aisea yana akesayana ani kanalena Yutia mai'nisaya vayana apaune he'a avimateka haiyo. ");
INSERT INTO ino_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mako ve'kamo'a no akofetule haino mai'neno ani ke ne'afiseateti lavino no'afakati mako ya'a o'alino afa'a naku naku huno aune heno. ");
INSERT INTO ino_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mako vaya hoyafaka mai'nisayatetina kena'api alikefe noteka ete'a o'ukae. ");
INSERT INTO ino_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Avo'nio ani afina lusi havi ya va'yi huke. Ani kanafi apaipa'ae mai'nisaya a'ne'ae mafa'ne saufa alipatete'a nu ne'apamisaya a'ne'ae lusi nahau hu'na apatoe. ");
INSERT INTO ino_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Anumaya Kotiteka inake hutapa afikeo ‘Ko ne'aiya i'kate ani ya va'yi ohise.’ hutapa afikeo. ");
INSERT INTO ino_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Hae Anumaya Koti'a ma mopa alo hu'nea afina'ae meni afina'ae ani ala havi kana hapaisea kana va'yi ohu'ne. Va'yi ohu'nea'maki ani havi kana va'yi huno vaya ala apa'kafu kike. Ala ala apa'kafu kiteno henaka'a ani akufa ya va'yi ohuke. ");
INSERT INTO ino_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anumaya Koti'a ani havi kana alino aupa huke. Alino aupa ohininana mi'ko vayana ako falinine. Anumaya Koti'a ha'ye hikeno hapalimale'nea vayafe afino apa'kufa alino katisea yafe ani kana alino aupa huke. ");
INSERT INTO ino_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ani kanafi mako vaya'moki ‘Anumaya Koti'a lakufa alino katikefe hute'nea ve'ka ma mai'niki akeo.’ huke ‘Muka mai'niki akeo.’ huke hisaketapaena ‘Lamake nehae.’ hutapa o'afeo. ");
INSERT INTO ino_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mako vaya'moki va'yi hu'a vaya'aina a'a apavataka hisaya yafe ‘Nakaeya Anumaya Koti lapa'kufa alino katikefe hunate'nea ve'ka mai'noe.’ hu'a hisaya vaya'ae apa'ke'atike'ake apaune vaya'ae va'yi hukae. Ani akufa vaya va'yi hu'a Anumaya Koti ha'ye hikeno hapalimale'nea vaya'aina a'a apavataka hisaya yafe apa'ke'atike ke'api afisaya yafe lusi apamo'yo ai ya'ae o'ake'naya avame ya hu lo'kiya ya'ae hukae. Ani ya hukaya'maki Anumaya Koti ha'ye hikeno hapalimale'nea vaya'moki o'afikae. ");
INSERT INTO ino_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lamake ani ya va'yi ohu'nea afina ako lahapapai'noki maitapa halove hu'netapao.” ");
INSERT INTO ino_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ani kana hapaisea ya hano hisikeno Yakemo'a alino hani'ake nehisikeno i'ka'mo'a mako'ae ano ha olekaiye. ");
INSERT INTO ino_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ha olesikeno sanafi'yaka ko'ku'napakatina atafailavi atafailavi hukae. Mi'ko ani ko'ku'nate lo'kiya ya hane'nea ya'mo'a kanake kanake nehu'a fate fate kate u'e'a hukae. ");
INSERT INTO ino_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ani ya fole aitesike'na vaya'mo alinate'nea ve'kamo'na ko'ku'napakati hiyapi esuke'a nakekae. Lusi lo'kiya ya'ni'ae ano hale himamu ya'ni'ae esuketapa nakekae. ");
INSERT INTO ino_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nakesake'na kayo kayo vaya'ni mi'ko yake haino ne'eateka'ae lavino nefaleateka'ae aluka aluka aupalika'ae hupatesuke'a u'ne'a mi'ko “Nakai'ni vayane.” hu'na hapalimale'noa vaya'yaka'ni mi'ko mopa'ae ko'ku'na'ae uno hano hu'niseatekati'ae apavale'a anupa hute'a ekae. ");
INSERT INTO ino_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yisasi'a inake nehe hikifa yosamo'a mako avame ya lapave neleanaki akeo. Ani yosamo'a hokoteno a'kopayakale akusasi ano haita maleteno atali huteno anupa'a maleketapaena “Meni hoya ha'kale kana fole aiye.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ani kava nehaya'maki ani lahapapai'noa avame ya akesayana esoa kana'ni'amo'a aupasi nehikeno “Kipate eno mai'neanakeno ako ekaiye.” hutapa lapa'kesa afikae. ");
INSERT INTO ino_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lamake hu'na lahapa'nepauve meni mai'naya vayana ofali'a afa'a mai'nisakeno ani ya mi'ko va'yi huke. ");
INSERT INTO ino_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ko'ku'na'ae mopa'ae fanane hukea'maki nakaeya ke'ni'amo'a alaki fanane ohuke. ");
INSERT INTO ino_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ani lahapapai'noa kana eno fole aisea kana'a mako ve'kamo'a alaki lamake huno o'afi'ne. Ani kava hu'a ko'ku'napi mai'naya kayo kayo vaya'moki'ae ani kana o'afi'nae. Ani kava huno Anumaya Koti Mafa'ne'amo'ae ani kana o'afi'nea'maki Afo'amo'a akai'ake ani kana afi'ne. ");
INSERT INTO ino_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ani kana va'yi hisea kana lapa'kaeya o'afi'naya yafe lapau o'kaletapa akeva hutapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mako kava ve'kamo nehea kava huno Yisasi'a eteno ekaiye. Ani kava ve'kamo'a yatala koteka ukefe nehuno mi'ko mako'ke mako'ke ali'ya vaya'amokitena ali'ya apamiteno kipate yakaisea ve'kaena inake hu'ne “Kakaeya yakaiyo.” huteno ani kava ve'kamo'a kuma'a ataleno alu koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ani akufa yafe lapa'kaeya ani kava hutapa mani no kuma'mo afo'amo'a eteno esea kana'a lapa'kaeya o'afi'naya yafe akeva heo. Ani kava ve'ka une esifi? Hani folaku esifi? Ko'kole ake ne'aisikeno esifi? Nate esifi? Esea kana'a o'afi'naya yafe lapa'kaeya yakaitapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Haviku havatapa mai'nisakeno makalema'a eno lahapau'kae yafenaki yakaitapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lapa'kaeya kava hutapa maiyo hu'na nehoa ke mi'ko vaya'mokiteka'ae hapa'nepauvanaki lapa'kaeya yakaitapa maiyo. ");
INSERT INTO ino_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ani afina Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea afinafe apa'kesa afi ne'ya hale o'ki kai hame'ya yakita hu'a nesaya kana'a aole kana ne'mai'a aepa he'a ani ne'ya yakita hukefe nehake'a mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae inake nehae “Hana kava huta lake'atike ke huteta Yisasina atafa huta kesi haesunakeno falise?” nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Inake nehae “Mi'ko vaya'yaka e'a ali'a atalu hu'ne'a ne'ya yakita hu'a nesaya yapina Yisasina atafa ohisune. Haviku atafa nehisunake'a mi'ko vaya'moki akete'a ke hu'a mikafi mafi nehu'a la hukae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yisasi'a Petani uno a'ke'ainaka fuko'ya ako ake'nikeno alino kanale hute'nea ve'kamo nopi uno mai'ne. Ani ve'kamo aki'a Saimoni'ae ve'kamo nopi uno mai'neno ne'ya ne'nekeno mako a'mo'a yafa ke'ayo alino akaeyate e'ne. Ani ke'ayo alo nehaya yafa'mo aki'a alapasata. Ani masave kepi mako lusi miya'a hane'nea masavena mana'ake li hane'ne. Ani masave'mo aki'a nati. Ani a'mo'a ani masave ke alino atakiteno Yisasi akenopale la'kino falete'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","La'kino fale ne'ateke'a mako anile mai'naya vaya'moki ani yafe apaipa kafa neha'a apa'kai'api inake nehae “Na kava hikeno mika a'mo'a mana'ake masavena afa'a la'kino huke ataleke nehe? ");
INSERT INTO ino_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ani mana'ake masave vaya apamisunake'a miya hininana tali hataleti kina (K300.00) ina akufa ya aliteta ani moni alita uta moni afeno ya'api o'malesea vaya fa'ko huta apaminine.” hute'a ani afe ke ama'ki'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ke ama'ki'naya'maki Yisasi'a inake nehe “Ani ana afa'a ataleo. Na ya hiketapa lapa'kaeya kana haiya ke nehae? Akaeya mani a'mo'a nakaeya kanale kava hune'nate. ");
INSERT INTO ino_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Afeno ya'api o'male vaya mi'ko afina lapa'kaeya'ae lo'ka'a maikayanaketapa apaya hisaya lapa'kesa afisaya afina apaya hukaya'maki nakaeya mi'ko afina lapa'kaeya'ae lo'ka'na o'maikoe. ");
INSERT INTO ino_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mani a'mo'a nakaeyate ‘Hu katekauve.’ huno hu'nea kavana alaki ako hune'nate. Nakaeya kelifi ali'u'a kinatesaya ka'ni'a alino avatati hukefe mani a'mo'a mana'ake masavena nakufale fale ne'nate. ");
INSERT INTO ino_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nakaeya lamake lahapa'nepauve mi'ko ma mopale vaya'aipina Yisasi kanale ke hapapaisaya koteka'ae mani a'mo'a hunate'nea avake'a hapapaisake'a ani afe apa'kesa afikae.” ");
INSERT INTO ino_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ani afina layatala'a hano huno laiyalekati aole alea anaka'moki Yisasi ke ne'afea anakapati mako'ke ve'kamo'a Yutasi Isa'kelioti'a Yisasina kutalu ya huno apavelisike'a atafa hisaya yafe mono nopi kava vaya'aite u'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uno hapapaike'a ani ke afite'a lusi amuse nehu'a Yutasife “Ina kava hisana yate miya kamikune.” hu'a lo'kiya kefati hapaitakeno Yutasi'a vaya kulite o'aisea afina fala'kino apavelisike'a atafa hu'a haesaya kafe aepa heno kahau ne'aeye. ");
INSERT INTO ino_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hale o'ki kai hame'ya ne'ya ne'naya kana hokote afina fole ai'ne. Ani kana Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi'a sipi sipi afu ana'au'a hete'a ne'ya ka'a ne'naya kanalenake'a Yisasife akaeya ke ne'afea anaka'amoki inake hae “Hanate uta Anumaya Koti'a lakinakomoki apa'kufa alino kati'nea afinafe kakesa afisana ne'yana alita avatati hukatesune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Afine'kakeno Yisasi'a aole akaeya ke ne'afi'a ve'kala'a hune'anateno inake huno hanapai'ne ala kumate ne'visa'akeno mako li ke aliteno ne'esea ve'ka'ae utapa fotu hutetapaena ani ve'kamo a'kame hafaitana vi'ao. ");
INSERT INTO ino_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ne'utana akesa'akeno mako nopi haino falesiketanaena ani no'mo afo'amofe inake hutana afike'ao “Alino laya nehea ve'kamo'a inake nehe ‘Hana nopi nakaeya ke ne'afea anaka'ae Anumaya Koti'a lakinakomoki apa'kufa alino kati'nea afinafe lakesa afi ne'ya nesune?’ huno nehe.” hutana afike'ao. ");
INSERT INTO ino_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Afikesa'akeno akofetule nopi mai'neta ne'ya maleta nesuna hipayaka'ae ako ali'a avatati humale'nisaya nona lanavelikeanaki ani nopi nesuna ne'yana alitana avatati humaletana e'ao nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ani ke hanapaiteke'ana ani ala kumate u'ne'ana mi'ko Yisasi'a hanapai'nea kava huno fole aike'ana ani Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi ne'yana ali'ana avatati hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ali'ana avatati humale'na'ake'a unema'a Yisasi'ae layatala'a hano huno laiyalekati aole alea anaka'a'ae lo'ka'a e'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E'a mai'ne'a ne'ya ne'nakeno Yisasi'a inake nehe “Nakaeya alaki lamake lahapa'nepauve nakaeya'ae etapa ne'ya ne'naya vaya'mokitapafatina mako ve'katapimo'a kutalu ya huno nakaeya navaleno kame ya hune'nataya vaya'ai apayapi natekaiye. Ani ve'ka meni nakaeya'ae ne'ya ne'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nehike'a apaipamo'a kana nehike'a mi'ko mako'ke mako'ke'moki Yisasife inake hu'a afine'kae “Nakaeyafe nehapi?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Afine'kakeno Yisasi'a inake nehe “Lapa'kaeya nayatala'a hano huno naiyalekati aole alea anaka nakaeya ke ne'afea vaya'nimokitapafati mako'ke ve'kamoka kame vaya'nimoki nahaesaya yafe kesi kate u'ke'ka nehu'ka kutalu ya ne'nane. Ani ve'kamo'a nakaeya'ae mako'ke lapepatina kai hame'yateti faino vayakofino ne'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","He lamake Anumaya Koti avopi ako kamale'naya ke a'kame male'a nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nahaesake'na falikoe. Avopi kamale'naya yafe ani kava hunatekaya'maki nakaeya navaleno kame ya hune'nataya vaya'ai apayapi natesea ve'kaena lusiya hu'na nahau hutoe. Ani ve'ka ita'amo'a ali o'ate'ninana kanale hinine.” ");
INSERT INTO ino_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne'ya ne'nakeno Yisasi'a mako kai hame'ya alino Anumaya Kotiteka huno amuse huteno a'kaya heteno akaeya ke ne'afea anaka'a ne'apamino inake huno hapapai'ne “Mani kai hame'ya nakai'ni nakufaki lapa'kaeya aleo.” ");
INSERT INTO ino_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mako li hefi'a ne'naya kepi nofi alakamo li hane'nea ke aliteno Anumayamoteka ke huno amuse huteno apamike'a mi'ko'amoki nete nete hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne'nakeno Yisasi'a inake nehe “Mani lina nakai'ni kolane. Vaya'moki nahaesake'na falisukeno kola'nimo'a la'kilaviseana mi'ko vaya'mokitapa hao'otake yatapi ali'na atalekauve. Ani kola'mo'a Anumaya Koti'a alino lo'kiya vailapate'nea kemo aepa'a alino lo'kiya vaike. ");
INSERT INTO ino_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Lamake lahapa'nepauve nakaeya mako nofi alakamo lina meni mako'ae o'nekauvanake'na Anumaya Koti kava yakaisea kumate u'na saufa kava hu'na saufa nofi alakamo li nekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hike'a mako yakame hu'a avayate'a Olivi yosa hane'nea avimateka ne'vae. ");
INSERT INTO ino_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisasi'a akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Lapa'kaeya mi'ko'amokitapa nakaeya nataletapa lapaune hekae. A'ke'ainaka ani yafe Anumaya Koti'a akai'a inake hike'a avopi kamale'neane ‘Sipi sipile kava ve'ka haesukeno falisike'a sipi sipi afu anaka'a atale'a apaune hekae.’ huno hike'a kamale'neane. ");
INSERT INTO ino_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kamale'nea'maki fali'nisukeno Anumaya Koti'a eteno alino hetinatesike'na Kalili u'na hoko netesuketapa na'kame ekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nehikeno Pita'a inake nehe “Mi'ko'amoki kakaeyafe apame'atiti ya'api atalesayana nakaeya alaki lamake hu'na kakaeyafe name'atiti nehoa yana o'atalekauve hu'na nehoe.” ");
INSERT INTO ino_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hikeno Yisasi'a Pitafe inake nehe “Lamake nakaeya kahapauve meni hani'ainaka ko'kole ake o'ai'nisike'ka aole'ae mako'ae afina nakaeyafe ‘O'ake'noa ve'kae nehae.’ hu'ka vane hunatekane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nehikeno Pita'a lusi lo'kiya ke nehuno “Kakaeya'ae nahaesake'na falisoe hu'naefe nakaeya o'ake'noa ve'kae hu'na vane hu o'katekauve.” huno nehike'a mi'ko Yisasi ke ne'afea anaka'moki mako'ke akufa ke'ake nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yisasi'ae apa'kaeya'ae u'a mako hoyamo aki'a Ketesemeni hoyale u'a va'yi nehu'a Yisasi'a akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Anumaya Kotiteka ke hu'na afikekefe hoanaki lapa'kaeya male maiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nehuno Pita'ae Yemisi'ae Yoni'ae ke hike'a akaeya'ae u'nayanaki Yisasi aipamo'a aepa heno kana'ake nehuno atafa huno alaki hikeno lusiya huno havi akaso ali'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akaso aliteno akaeya'ae lo'ka'a ne'vaya anaka'aife inake nehe “Ako falisoa akufa kava ne'nahaikeno naipamo'a kana ne'nahaiyanaki lapa'kaeya male mai'netapa kava yakaitapa alakepa hunateo.” ");
INSERT INTO ino_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Apateteno aisema'a uno mopafi asaka hulavino mai'neno Anumaya Kotiteka inake huno afine'ke “Kakaeya kahaininana meni nakaeyate havi kana ya fole hukefe nehea kanamo'a nakasenine.” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Inake nehe “Vae Afo'nimoka kakaeya afa'a mi'ko kavana hanina'maki falisoa ya huki ani havi kanamo'a atu'ake nehea li'kana nehiki ani li hane'nea ke'ayona ali'ka atalo. Atalekana'maki kakaeya nakaeya naku nakesale na'kame o'male'ka kakai'ka afisana kaku kakesale a'kame malo.” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Afikeno Yisasi'a eteno uno akaeya ke ne'afea anaka'a apa'keana apau hava'a mai'nakeno apa'keteno Pitafe inake nehe “Saimonika kakaeya kau kale'nape? Vae kakaeya aise kana'a kava yakai'ka o'mai'nape? ");
INSERT INTO ino_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Haviku Sata'a ‘Hao'otake kava heo.’ huno ano lapavataka hu ya'mo'a eno lahapau'kae yafenaki yakai'netapa Anumayaleka afikeo hu'nae nehoe. Lamake lapaipamo'a Anumaya a'kame malesea yafe nehaiya'maki lapa'kufamo'a alaka haekeno lo'kiya'a o'male'ne. Sata ke o'afisaya yafe kava ne'yakaitapa Anumayamoteka ke hutapa afikeo.” ");
INSERT INTO ino_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Eteno halate mako'ae uno hokoteno hu'nea akufa ke huno Anumayamoteka afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Afikeno halate akaeya ke ne'afea anaka'aiteka eno apa'keana apaulakamo'a kana'ake hike'a apau'ke hava'a mai'nakeno apauna heke'a “Na'mone ke hisune?” hute'a ke ohu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ke ohu'nakeno Yisasi'a halate aole'ae mako'ae afina eteno eno apa'keana apau'ke hava'a mai'nakeno apa'keteno inake nehe “Lapa'kaeya maitapa falu hutapa lapau'ke hava'nafe? Haine. Kana'a'nimo'a ako va'yi nehe. Meni vaya'moki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka natafa hu'a navale'a havi vaya'ai apayapi ako natesake'a nahakefe nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mi'ko'a ako hetita viketao. Akeo nakaeya navaleno havi vaya'ai apayapi natesike'a nahaesaya yafe kutalu ya ne'nea ve'ka ako ne'e.” ");
INSERT INTO ino_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisasi'a ani ke nehikeno Yutasi'ae ve'ka ayatala'a hano huno aiyalekati aole alea anaka'ae lo'kano ne'maiya ve'ka va'yi nehike'a akaeya'ae mi'ko vaya mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ala ala vaya'moki'ae ani vaya hupatake'a ani vaya'moki heki kayo alike mi'ko kayo alike hu'ne'a Yisasite e'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yutasi'a Yisasina haesaya kutalu ya ne'nea ve'kamo'a inake hu'ne “U'na mako ve'ka hane hane hisoa ve'ka atafa hutapa lo'kiya vaitapa avaletapa veo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hapapaiteno Yutasi'a makale'a Yisasite uno inake nehe “Ali'ka laya nehana Nenao.” nehuno hano ne'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hano neteke'a haesaya vaya'moki u'a ayate atafa hu'a alaki hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atafa nehaya'maki mako akaeya'ae hetino mai'nea ve'kamo'a hakina avayu huteno ala mono nopi hokote kava ve'kamo ali'ya ve'kamo akesa aepafati heno hataka hutalekeno mopafi asaka hulavi'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Heno hataka hune'atalekeno Yisasi'a apa'kaeyafe inake nehe “Lapa'kaeya ma vayana nakaeya natafa hukefe hakina'ae mi'ko kayo kafefa'ae ne'ayana nakaeya mako vaya nehapa'na kumaya ve'ka mai'noketapae nehafe? ");
INSERT INTO ino_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mi'ko kana'ae kana'ae lapa'kaeya'ae ala mono nopi mai'ne'na ke lahapapaime nehaitoa'maki natafa ohu'naya'maki Anumayamo avopati kemo'a fole aino ne'ya'a alitesikeno lamake hisea yafe etapa natafa nehae.” ");
INSERT INTO ino_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hike'a mi'ko akaeya ke ne'afea anaka'a ako atale'a apaune he'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Mako'ke nahaeya ve'ka ka'ki kena havaiteno Yisasi a'kame e'nea'maki ani ve'ka atafa nehakeno ani kena'a ano kalo vaino anifi atale ne'maleno akufa alaka'ake aune he'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yisasina avale'a ala mono nopi hokote kava ve'kamo note u'nake'a mono nopi kava vaya'yaka'ae ala ala vaya'ae mono hapali'a hapa'nepaiya vaya'ae e'a ali'a anupa hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Anupa hu'nakeno Pita'a Yisasi a'kame u'nea'maki hau'ale o'uno alu'ale ne'uno ala mono nopi hokote kava ve'kamo no kuma keki'ya vekofi haino ati vaya'moki ata kamale'a lota hu'a mai'naya atale eno lota huno mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mono nopi kava vaya'ae mi'ko kanisole vaya'ae inake hae “Mako vaya'aife ke hisunake'a e'ne'a Yisasi'a hu'nea hao'otake kava'a hu'a fole ai'a lahapaisaketa haesunakeno falisea kake hutesune.” hu'a kahau a'naya'maki mako ya o'ake'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","O'ake'naya'maki lusi vaya'moki e'a Yisasife “Ina kava ma kava huno havi kava hu'ne.” hu'a hu'naya'maki ani hu'naya kemo'a kase o'alikeno mi'ko ke hu'naya ke'apimo'a fate fate akufa ke'ake hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Mako vaya'moki heti'a Yisasife apa'ke'atike nehu'a inake nehae “Lakaeya akaeya hu'nea ke afi'none akaeya inake he ‘Nakaeya ala mono nona vaya'moki kimale'naya nona ali'na kapele ne'atale'na aole'ae mako'ae kanafi ete'na kikoe. Vaya'moki no'kea akufa no kikoe.’ hiketa afi'none.” nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nehaya'maki mi'ko ani vaya'moki haya kemo'a mako'ke akufa ke ohu'naki fate fate ke'ake hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nehakeno ala mono nopi hokote kava ve'kamo'a ani folakapati hetimaleno Yisasife inake huno afine'ke “Kakaeyafe mika akufa ke hu ne'kataya'maki anona'a ke'apile mako ke ohisana kakesa ne'afipe?” ");
INSERT INTO ino_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nehikeno Yisasi'a ke ohuno mako ke alaki ohu'ne. Ohikeno ala mono nopi hokote kava ve'kamo'a halate mako'ae inake huno afine'ke “Kakaeya Kalaisika Anumaya Koti'a lakufa alino katiseafe hukate'nea ve'ka mai'nape? Aki alita asaka nehuna Anumaya Koti mafa'ne'amoka kakaeya mai'nape?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Afine'kekeno Yisasi'a huno fole aino inake hu'ne “He lamake nehane nakaeya ani ve'ka mai'noanaketapa nakekae. Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na henaka'a nakesake'na ala lo'kiya'a hane'nea Anumaya Koti aya lamaka'a mai'ne'na ko'ku'nate hiyapi esuketapa nakekae. ");
INSERT INTO ino_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nehikeno ani ke hea yafe ala mono nopi hokote kava ve'kamo aipamo'a ata lekeno kena'a alino vala ai ne'ataleno inake he “Hai akai'a avayafati ani ke afunanaketa mako vaya'aife ke hisunake'a mako akufa ke Yisasife laha'opaisae. ");
INSERT INTO ino_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lapa'kaeya Anumaya Kotife huno haviya hune'atea ke ako afife? Ani ke afea yafe na'yane lapa'kesa ne'afe?” huno hike'a ani vaya'moki inake hae “Lamake hane hao'otake ya'a hane'neanakeno anona'a haesakeno falise.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mako vaya'amoki Yisasi aukosafi aepa he'a apavaitu'na hene'ate'a mako kenaleti aulakale male'a kimale'ne'a aukosafi mi'kimi kayo ne'amaki'a inake nehae “Nala'a ne'kamakifi? Kakaeya kaune ke hu'ka fole ai'ka lahapaiyo.” nehake'a ati vaya'moki avale'a u'a lusi kayo amaki'nae. ");
INSERT INTO ino_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pita'a afenaka no keki'ya veko humale'naya yu'ainaka mai'nikeno ala mono nopi hokote kava ve'kamo ali'ya a'mafa'ne ne'eno akeana Pita'a atale lota huno mai'nikeno ake'ne. Aketeno Pitana akeno lakelake nehuno inake he “Kakaeya'ae Yisasi Nasaleti ve'ka'ae ne'maina ve'kae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nehikeno Pita'a akaeyafe inake nehe “Nakaeya ani ve'ka no'akoa ve'kae nehane.” huno vane huteno ataleno ma'aileka hatilavino no kipate nelavikeno ko'kolemo'a ake ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ani a'mafa'nemo'a eno halate Pitana aketeno anile heti'naya vaya'aife inake nehe “Ma ve'ka Yisasi'ae ne'maiya ve'kae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nehea'maki eteno Pita'a inake he “He'e. Nakaeya o'afi'noa ke nehae.” huteke'a aise kana'a maike'a anile akaeya'ae lo'ka'a mai'naya vaya'moki Pitafe inake hae “Lamake kakaeya Yisasi'ae ne'maina ve'ka Kalili kumate ve'ka mai'nane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nehakeno Pita'a inake he “Nakaeya lamake ohisukeno'aena Anumaya Koti'a nahaese. Anumaya Koti aulakale lahapa'nepauve nehaya ve'ka nakaeya o'ake'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nehikeno makale'a hokoteno ake ai'nea ko'kolemo'a halate eteno ake ne'aikeno Pita'a afiteno Yisasi'a hu'nea ke akesa afino hao nehe. Yisasi'a a'ke'ainaka inake huno hapai'ne “Ko'kolemo'a aole kanale ake o'ai'nisike'ka kakaeya aole'ae mako'ae kana nakaeyafe vane hu'ka ‘O'ake'noa ve'ka mai'ne.’ hu'ka vane hukane.” hu'nikeno Pita'a ani ke akesa afino hao huteno avi nele. ");
INSERT INTO ino_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ko neteana mi'ko mono nopi kava vaya'ae ala ala vaya'ae mono hapali'a hapa'nepaiya vaya'yaka'ae kanisole vaya'ae Yisasina haesakeno falisea veke vake ke hute'a Yisasina nofi kitete'a ala kamani kava ve'ka Pailatite avale'u'a ayapi ate'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ate'nakeno Pailati'a Yisasife inake huno afine'ke “Kakaeya Yuta vaya'ai yahauve'api mai'nape?” huno afikekeno Yisasi'a inake he “Kakaeya'ka ani ke hai nehane.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nehike'a mono nopi kava vaya'moki lusi kava hu'a “Ma akufa kava hu'ka hao'otake kava hu'nane.” hune'atae. ");
INSERT INTO ino_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hune'atakeno Pailati'a mako'ae Yisasife inake nehe “Akeko mi'ko hao'otake kava nehana yana hu'a fole ne'aiya'maki anona'a ke'apile ohukape?” nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nehikeno Yisasi'a anona'a ke'ale eteno mako aise ke nohikeno Pailati'a amo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kafu'ae kafa'ae Anumaya Koti'a apa'kufa alino kati'nea afinafe apa'kesa afi emu ne'kakeno Pailati'a mi'ko ani emu ki afina mako nofi hupatake'a ne'maiya vayapati vaya'yakamoki aki a'a asaka nehu'a “Akaeya ese.” hu'a haya ve'ka “Nofipati hai hano hanaki uvo.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ani afina mako ve'kamo aki'a Palapasi'a nofi nopi mai'ne. Palapasi'a kamani vaya'ae la nehaya vaya'ae lo'kano mai'neno kamani vaya'ae la hu'naya afina vaya hapano kipate'nea ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mai'nike'a vaya'moki e'a Pailatife inake hae “Mi'ko mani emu ki afina nehana kava hulato.” nehae. ");
INSERT INTO ino_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nehakeno Pailati'a inake huno apafine'ke “Nakaeya Yisasife Yuta vaya'aite ala yahauve ve'kae ‘Hai hano hanaki uvo.’ hu'na hutesukeno visiketapa amuse hisafe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailati'a ne'afeana mono nopi kava vaya'moki ma apa'kesa ne'afe “Mi'ko vaya Yisasiteka u'a akaeya keke afite'a lakaeya ke no'afe.” hu'a afi'naya yafe Yisasife apaipa afi'a haviya hutete'a Pailatite avale'a e'a ate'nakeno Pailati'a ani yafe afi'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Afi'nea'maki mono nopi kava vaya'moki u'a mi'ko vaya'ai apaipa hu'a vakali nehu'a vaya'aife inake hu'a hapa'nepaiye “Make hutapa heo ‘Palapasi'a afa'a ese.’ hutapa heo.” nehae. ");
INSERT INTO ino_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nehakeno Pailati'a vaya'aife inake nehe “Ani kava hisoana ma ve'ka lapa'kaeya ‘Yuta vaya'aite ala yahauve ve'ka mai'ne.’ hutapa nehaya ve'ka hana kava hutesoe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Apafine'keke'a apa'kaeya ala kekefafati inake hae “Yofo yosale nili aitetapa asaikeno falino.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nehakeno Pailati'a inake huno apafine'ke “Na'ya hiketapa ani ke nehae? Hana akufa hao'otake kava hu'ne?” huno apafine'kea'maki apa'kaeya ete'a ali'a alapi male'a ala kefati inake hu'a nehae “Yofo yosale nili aitetapa asaikeno falino.” ");
INSERT INTO ino_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nehakeno Pailati'a mi'ko vaya hapaisea kava hisea yafe Palapasife “Nofipati hano hane.” huno hune'ateno “Yisasina akufa akafu kisea kayoteti sefu ameo.” huteno ati vaya apamiteno “Yofo yosale nili aitetapa asaikeno falino.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ati vaya'moki Yisasina avale'a ala kava ne'mo no haopale u'ne'a mi'ko apa'kaeya'ae ne'maiya ati vaya'aife eo hu'a ke hake'a e'a ali'a atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ali'a atalu hake'a Yisasina kamuke haukefe ala kava ve'kamo yatala haesa kena havaitete'a aufe nofiteti ali'a kala'kite'a Yisasi akenopale ka'kolita vaite'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vaitete'a aepa he'a hu'a haviya havaya hutekefe inake nehae “Hae Yuta vaya'aipi ala yahauve ve'ka mai'nape?” hu'a hune'atae. ");
INSERT INTO ino_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Akenopale heki kayoteti amakike amakike nehu'a aukosafi apavaitu'na nehe'a apale'ya mopale fai'ne'a “Ala ve'ka mai'nane.” nehu'a kamuke ama'ki'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hu'a haviya hau'a kiki hutete'a haesa kena hate ne'atale'a akai'a kena halate havaitete'a yofo yosale nili aite'a asaisakeno falisea yafe avale'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yisasina avale'a ne'u'a Saimoni'a Sailini kumateti ve'ka'ae kateka fotu hu'nae. Saimoni mafa'nelana Ale'kasata'ae Lufasi'ae mai'na'ae. Ani ve'ka hoya'afakati eno kate ne'eke'a ati vaya'moki atafa hu'a yofo yosa ali'a kofitete'a “Ali'ka uvo.” hu'a hakeno alino ne've. ");
INSERT INTO ino_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Alino ne'vike'a Yisasina avale'a u'a Kolokatae nehaya kumate va'yi nehae. Ani kuma'mo aki'a lakaiti kefati Akenopa Ayamufae hu'a aki ne'ae. ");
INSERT INTO ino_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ani ati vaya'moki “Haesunakeno faliseana akufa akafu ki yafenaketa akufa akafu o'kisea li nese.” hu'a nehae. Ani akafu o'kisea li'mo aki'a mea. Mea'ae nofi alakamo li'ae makopi ali'a akunaku hute'a ali'a ami'nayana Yisasi'a ani life he'e huno no'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","O'neke'a yofo yosale nili aite'a asaimalete'a ati vaya'moki kena'a fa'ko fa'ka hukefe kasi yo'kalokana akufa yo'kalo nelesakeno apa'kaseno haisea ve'kamo'a ani kena'a alite alite hise hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Natena naini kilo'ki yakemo'a hanale haineno ne'vike'a Yisasina yofo yosale nili hete'a asaimale'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nili hetete'a “Ma kava hiketa ha'none.” hu'a inake hu'a kamale'nae “Yuta vaya'ai hokote yahauve ve'kae.” hu'a kamale'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kamalete'a Yisasi'ae aole ve'kalana vaya hapate'a kumaya'ya neha'a ve'kalana mako ve'ka aya lamaka yofo yosale nili aite'a asaimale'nae. Mako ve'ka haoka aupalika nili aite'a asaimale'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Anumaya Koti aune ve'kamo'a a'ke'ainaka ka'nea kemo'a inake hu'neane “Ke male male'nea ke ali'a ataka'naya vaya'ae mai'neana ani akufa ve'ka mai'ne hu'a apa'kesa afi'nae.” huno hu'neane. Yisasi'a hao'otake kava hu'na'a ve'kala'ae yosale asai'naya afina ani kamale'naya kemo'a fole aino ne'ya'a alitekeno lamake nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kate u'e'a nehu'a akaya vaya'moki apa'kenopa kayo ne'ai'a “Hao'otake ve'ka mai'nane.” nehu'a kiki'a hune'ate'a hu'a haviya hute'nae. Inake nehae “Oho kakaeya ‘Ala mono no ali'na kapeletale'na aole'ae mako'ae afina makale ete'na kikoe.’ hu'ka hu'nana ve'ka mai'nape? ");
INSERT INTO ino_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Meni kakaeya kakufa ali'ka katisana yafe yofo yosa ne'atale'ka eli'keno.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nehake'a ala mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ani kava hu'a apa'kaeya'ae ke hu imafi mafi nehu'a hu'a haviya hute'nae. Inake nehae “Vaya apa'kufa ako alino katipate'nea'maki akai'a akufa alino o'katike. ");
INSERT INTO ino_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kalaisi Isaleli vaya'aite hokote yahauve ve'ka'api yofo yosaleti ataleno elinesiketa aketeta akaeya lamake nehe huta akaeyafe afita laipafi malekaune.” nehu'a hu'a haviya hu ne'atake'ana akaeya'ae yofo yosale nili aite'a asaimale'naya ve'kala'mo'akani'ae ani kava hu'ana Yisasina hu'ana haviya hute'na'ae. ");
INSERT INTO ino_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ani afina yakemo'a folakate mai'neno yake nelea ya'a hano hikeno mi'ko koteka lusi hani kiteno une afafa eteno alino hale'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Une afafa yake lavino falekefe nehikeno Yisasi'a ala kekefafati ke nehuno akai'a kefati inake hu'ne “Eli Eli lema sapa'katani?” hu'ne. Lakaeya kefati ani ke inake nehe “Anumaya Koti'nimoka Anumaya Koti'nimoka na kava hike'ka nakaeya ne'natalane?” nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nehike'a mako anile heti'a mai'naya vaya'moki ani Yisasi hea ke afite'a inake hu'a nehae “Afikeo Ilaiyafe ke nehe.” ");
INSERT INTO ino_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nehakeno mako ve'kamo'a uno lipi havakana ya alino nofi alakamo lipi ateno kayote faino lanupaiteno alino asaka huno Yisasife mayu mayu huno nese huno ne'amino inake nehe “Akeva mai'nisunakeno Ilaiya'a eno yofo yosaletina avaleno elinesifi akeketao.” ");
INSERT INTO ino_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nehikeno Yisasi'a mako'ae ala ke huteno ako fali'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Falikeno alapa'ake kena ala mono nopi asaimale'naya kena hanaleti aepa heno folakapati atata aino lavino mopale lavea ya'mo'a aole hapa'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Anile mai'naya ati vaya'aite kava ve'ka'apimo'a Yisasi aulekaleka heti'neno Yisasi'a falikefe nehuno hu'nea ke afiteno falea au'ava kava aketeno inake nehe “Lamake ma ve'ka Anumaya Koti alaki mafa'ne'a mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mako a'ne alu'ale mai'ne'a ake'naya a'nemoki apa'ki'a Salomi'ae Makatala kumate Malia'ae hamo'amo'a aise Yemisikani Yosesikani ita'animo'ae mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mai'naya a'neyaka Yisasi'a Kalili koteka mai'nea afina ani a'neyakamoki a'kame u'e'a nehu'a ne'ya ka'a ami'nae. Mi'ko ani a'nemoki Yisasi'ae Yelusalemu e'naya a'neyaka anile alu'ale mai'ne'a Yisasina ake'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sapati kanae avatati hisaya kana yakemo'a lavino falekefe nehikeno Yosefe'a Alimatia kumate ve'ka Yuta vaya'ai kanisole vaya'ae ne'maiya ala ve'ka va'yi nehe. Ani ve'ka Anumaya Koti kava yakaisea kanae amuse huno akeva huno ne'maiya ve'kamo'a koli ohuno Pailatite uno inake huno afine'ke “Kanale nakaeya Yisasi akufa'a alisufe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Afine'kekeno Pailati'a “Yisasi'a makale ako fali'ne.” hea ke afiteno amo'yo ne'aikeno anile mai'naya ati vaya'aite kava ve'ka'apimofe ke huno afine'ke “Yisasi'a ako fali'nife?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Afikekeno ati vaya'aite kava ve'ka'apimo'a “Ako fali'ne.” hikeno Pailati'a Yosefena Yisasi akufa ami'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Amikeno Yosefe'a uno yosa'ae mi'ko yatala efe kena miya faiteno uno akufa yofo yosaleti asaiteno alino ani yosa'ae kenaleti akufale hayateno alino uno kafimale'naya yafa'kapi Yisasina kite'ne. Kiteteno avayale aino a'kanilesea yafana ano atufano ani keli avayale ano a'kanimale'ne. ");
INSERT INTO ino_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makatala kumate Malia'ae hamo'amo'a Yosesi ita'amo'a Malia'ae mai'ne'ana kite'nea ya ake'na'ae. ");
INSERT INTO ino_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapati afina hano hike'a Yemisi ita'amo'a Malia'ae hamo'amo'a Makatala kumate anaki Salomi'ae Yisasi akufale mana'ake masaveteti faletekefe ani masavena ali'a u'nae. ");
INSERT INTO ino_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ani afina sota'mo hokote afina ani a'neyaka yake hainane'eke'a Yisasina kite'naya kelileka u'nae. ");
INSERT INTO ino_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kateka ne'u'a kalaki ne'ai'a mako'amoki ke hu'a i'afike o'afike hume ne'u'a inake hu'a hu'nae “Keli avayale ai'a ati'kamale'naya yafana nala'a laya huno avayaleti alino avayu huno afeteka atalelatekaiye?” nehae. ");
INSERT INTO ino_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ake'a asaka hu'a ani lusi yafa'kefa akayana ani yafana ako heno avayu huno afa yateka atale'ne. ");
INSERT INTO ino_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Atale'nike'a ani yafa'kapi fale'a hai'a akayana apaya lamaka aupalika mako nahaeya ve'ka faitopale mai'nike'a akayana ani ve'kamo'a yatala efe kena havai'nike'a lusi apamo'yo ai'ne. ");
INSERT INTO ino_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Apamo'yo ne'aikeno ani ve'kamo'a inake huno hapa'nepaiye “Lapa'kaeya lapamo'yo o'aino. Lapa'kaeya Yisasi Nasaleti mafa'ne kahau ne'ae. Yofo yosale nili he'a asaimale'naya ve'kae kahau ne'aya'maki akaeya mafi o'mai'niki fali'neapati ako hetino mai'ne. Male o'mai'niki ani ve'ka kite'naya kuma'ake hane'niki akekeo. ");
INSERT INTO ino_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lapa'kaeya utapa Yisasi ke ne'afea anaka'ae Pita'ae inake hutapa hapapaiyo “Yisasi'a ofalino mai'neno lahapapai'nea ke huno ako uno hokoteno Kalili ne'ukeanaketapa anileka utapa Yisasina akekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nehike'a apa'kaeya yafa'kapati hatilavi'a naku naku u'naya'maki apamo'yo ai'naya yafe koli hu'a mako vaya hapa'opai'nae. ");
INSERT INTO ino_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sota'mo hokote afina natepati Yisasi'a fali'neapati he'netino hokoteno mako Malia'a Makatala kumate a'mo aulakale va'yi hikeno ake'ne. A'ke'ainaka Yisasi'a ani a'mo aipafati seveni'a (7) Sata afe'yaka alino atale'neane. ");
INSERT INTO ino_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ani a'mo'a Yisasina aketeno Yisasi'ae lo'ka'a ne'maiya anaka'aife uno hapapaikefe u'nea'maki ani anaka'moki Yisasina hakeno fali'nea yafe apaipamo'a haviya hike'a hapau hu'a avile'a mai'nakeno uno apavate'ne. ");
INSERT INTO ino_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Avi nelakeno ani a'mo'a ake'nea yafe hapa'nepaino inake he “Yisasi'a fali'neapati ako heti'nike'na akaeya ako akoe.” huno hapapaike'a afi'naya'maki ani a'mo hea ke “Ake'atike nehe.” hute'a ke'a afi'a o'ami'nae. ");
INSERT INTO ino_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Henaka'a aole Yisasi ke ne'afi'a ve'kala'mokani ala kuma atale'ana kateka ne'va'akeno Yisasi'a ana'kaeyate va'yi hu'nea'maki aukosamo'a alino fate akufa kava hu'nike'ana ake'na'ae. ");
INSERT INTO ino_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Akete'ana ani ve'kala'mokani ete'ana vaya'ani mai'nayateka u'ana “Yisasina ina akufa ve'ka ako'ae.” hu'ana neha'a'maki ani vaya'moki “Anake'atike neha'ae.” nehu'a ke'ani afi'a o'anami'nae. ");
INSERT INTO ino_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Henaka'a laiyalekati mako'ke alea anaka'amoki atalu hu'a mai'ne'a ne'ya ne'nakeno Yisasi'a ani folakapi va'yi huteno fali'neapati ako heti'nike'a hokote'a ake'naya vaya'moki hu'naya ke afi'a apaipafi o'male'a lamake hae hu'a ohu'naya yafe Yisasi'a ke apama'ki'ne. ");
INSERT INTO ino_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ke apama'kiteno inake huno hapapai'ne lapa'kaeya mi'ko koteka uteta nehutapa nakaeya kanale ke mi'ko vaya hapapaiyo. ");
INSERT INTO ino_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hapapaisake'a mako vaya'moki ani ke lamake nehae hu'a afi'a apaipafi malesaketapa li falepatesakeno Anumaya Koti'a apa'ku apame alino katike. Alino katikea'maki mako vaya'moki “Ani ke lapa'ke'atike nehae.” hu'a afi'a apaipafi o'malesaya vayana Anumaya Koti'a “Hani kumapi ata leke leke nehea atafi veo.” huno hupatekaiye. ");
INSERT INTO ino_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nakaeya ke afi'a apaipafi male'a lo'kiya vaisaya vaya'moki mani o'ake'naya avame ya hu'a apavelisake'a akekae. Ina akufa kava hukae nakaeya nakileti Sata afe'yaka vaya'ai apaipafati ne'atale'a apa'kesa o'afi'nisaya ke fate fate apa'ke aikae. ");
INSERT INTO ino_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vaya hapake'a nefalea osifa've atafa hukaya'maki hapaesike'a ofalikae. Vaya'moki nete'a nefalea nami nekaya'maki apa'kufa apa'kafu ki'a ofalikae. Kali ali'nisaya vaya'aina apa'kufale apaya malesakeno kali'api ako kanale hupatekaiye. ");
INSERT INTO ino_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anumayatimo'a Yisasi'a akaeya ke ne'afea anaka'ai ani ke hapapaitekeno Anumaya Koti'a ko'ku'napaka avaleno asaka hikeno haino Anumaya Koti aya lamaka aupalika faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Faitopale mai'nike'a akaeya ke ne'afea anaka'moki mi'ko kumate kumate u'e'a hayateka apa'kaeya'ae lo'kano mai'neno ali'ya ne'alino fate akufa o'ake'naya avame kava hu lo'kiya'aleti ani ke alino lo'kiya vai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ala nena Tiofilasika mi'ko vaya'moki Yisasi'a lakaeya folakapi hu'nea ya ako kamale'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yisasi ke hapa'nepaiya vaya'moki hokoteno aepa he'nea afina ani ya akete'a lahapai'naya yafe ako kamale'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Mi'ko lahapai'naya ke aepa'a afisana yafe nakaeya kanale'ya hu'na kahapaikoe hu'na ani Yisasi'a hu'nea yafe a'ke'ainaka afi'na alakepa hu'na afi'noa yafe alakepa hu'na ka'na kamikoe nehoe. ");
INSERT INTO ino_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Inaki Yutia koteka ala kava kanomo aki'a Heloti'a kava ya alino mai'nea kanafi mako kanomo aki'a Se'kalaiya'a mono nopi kava kano mai'neno mono nopi kava yakai anaka'aipi Apaisa anakapati mai'nikeno a'amo'a Eloni anakapati fole ai'ne. Ani a'mo aki'a Elisapeti'ae. ");
INSERT INTO ino_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ani alavela'mokani Anumaya Koti aulakale kanale hu'ana mai'ne'ana mi'ko mono ke afi'ana a'kame nehu'ana alakepa kava neha'a alavelane. ");
INSERT INTO ino_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisapeti'a nahamo a mai'nea yafe mafa'ne'ani o'mai alavela kosufa anau ane'kano le'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Apaisa anaka ali'ya ne'alea kanafi Se'kalaiya'a Anumaya Koti aulakale ali'ya ne'ali'ke'a mono nopi kava ne'yakaiya vaya'moki Se'kalaiyafe “Kakaeyae.” hu'a hakeno Se'kalaiya'a Anumaya Koti mono nopi he'e hu'nea nopi haino mana'ake ya hane'nea yate ata ano kaekeno Anumaya Kotina sala mana ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sala mana Anumaya Kotina ne'amike'a kumateka mai'naya vaya'moki Anumaya Kotiteka afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Afine'kakeno Se'kalaiya'a he'e hu'naya nopi mai'nikeno Anumayamo ko'ku'napi kayo kayo kano'a akaeyate fole aino mana'ake ata kamale'nea hita aepale lamaka aupalika hetino mai'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Se'kalaiya'a ani kano aketeno halekeno maiteno koli hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Koli hu'neanaki ani kanomo'a akaeyafe inake nehe “Se'kalaiyaka koli ohu'ka Anumaya Kotife afike'nana yana Anumaya Koti'a ako afi'neanakeno a'kamo'a Elisapeti'a ve mafa'ne alitesike'ka aki'a Yoni'ae hu'ka malekane. ");
INSERT INTO ino_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Alitesea afina kakaeya lusi amuse nehisanake'a mi'ko vaya'moki'ae ani mafa'ne fole aisea yafe amuse hukae. ");
INSERT INTO ino_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ani mafa'ne Anumaya Koti aulakale ala aki hanesea kano mai'neno atu li o'nekaiye. Alitesea afina aepa heno Anumaya Koti Fate Akufa Avamu'amo'a aipafina havaitekaiye. ");
INSERT INTO ino_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Havaite'nisike'a mi'ko Isaleli aupalika vaya'moki akaeya ke afite'a apaipa ai'a yahae hute'a apa'kai'api Anumaya Koti'apimo ke afikae. ");
INSERT INTO ino_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anumayamo esea kate hokoteno eno Ilaiya'a Fate Akufa Avamu ami'nea lo'kiya'ae alike'a afo'apimoki akaeya ke afite'a apaipa ai'a yahae nehu'a mafa'ne'ape apa'kesa afikae. Ke no'afisaya vaya'moki akaeya ke afite'a apaipa ai'a yahae hu'a alakepa apaipa apa'kesa'ae vaya'moki hu'naya apa'kenopa hale'nea ke afikae. Ani kava hu'nisakeno vaya'moki Anumaya esea yafe apa'ku'a ali'a avatati hu'a maikae.” ");
INSERT INTO ino_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nehikeno Se'kalaiya'a inake he “Lamake nehapi kake'atike nehane hana'ya hu'na afisoe? La'akaeya ako kosufa anau ane'kano ako le'no'anake'na hana'ya hu'na ani ke afisoe?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nehikeno ko'ku'napi kayo kayo kanomo'a inake he “Nakaeya Kepalieli'na Anumaya Koti aulakale heti'na mai'nokeno Anumaya Koti'a ani kanale ke kahapaisoa yafe hunateke'na e'noe. ");
INSERT INTO ino_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Afeo nakaeya kemo'a fole aino alaka'a alitesikeno lamake hisea ke'ni'a o'afi'nana yafe meni liko'ke'kamo'a a'kanisike'ka ke mako'ae o'aikananake'ka hoa kemo'a kanale huno fole aino lamake hisea afina liko'ke'kamo'a hakalo hisike'ka kake aikane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nehike'a kumateka mai'naya vaya'moki Se'kalaiyafe akeva maike maikete'a yatala kanale Anumaya Koti fate akufa nopi mai'nea yafe “Na'ya hikeno makale'a no'me.” hu'a apa'kesa afi'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mai'nakeno ani nopati hatilaveana ake o'ai'ne. Ake o'ai'nea yafe vaya'moki ina akufa apa'kesa afi'nae “Nopaka mai'neno fate akufa ya aketeno eline'ne.” hu'a apa'kesa ne'afikeno Se'kalaiya'a ayateti avame'name nehuno apaveli'neanaki avayamo'a lu'ki'nikeno ake o'ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Avayamo'a lu'ki'nikeno ali'ya'a hano hea afina no'aleka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Utekeno henaka'a a'amo'a Elisapeti'a aipa'ae mai'nea yafe naya mako kaya'a i'ka fala'kino mai'neno inake he “Anumayamo'a kanale ya hunate'ne. Hunate'nea yafe vaya'nimoki apaulakale nakaeya navuya hu'noa yana ako aketeno alino atale'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapeti'a aipa'ae mai'nea i'kana naya mako kaya hano huteno naya mako kayati mako'ke alea i'ka mai'nikeno Anumaya Koti'a mako ko'ku'napi kayo kayo ve'ka hute'ne. Ani ve'kamo aki'a Kepalieli'a mako Kalili aupalika hane'nea kumate Nasaleti hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ani ko'ku'napi kayo kayo ve'ka Anumaya Koti'a mako ve ohau a'mafa'nele hute'ne. Ani a'mafa'nemo aki'a Malia'ae. Yosefe akile hakemale'naya a'mafa'ne. Yosefe akinakomo'a Teviti'ae. ");
INSERT INTO ino_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kepalieli'a Maliate eno inake nehe “Mai'nape? Anumaya Koti'a kakaeyafe amuse nehea a'mafa'nemoka Anumaya Koti'a kakaeya'ae mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nehikeno ani hu'nea ke Malia'a lusi amo'yo ne'aino ma akesa afi'ne “Ani ke na'yane ke eno naha'nepaiye.” ");
INSERT INTO ino_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nehikeno ko'ku'napi kayo kayo ve'kamo'a akaeyafe inake nehe “Maliaka koli oho Anumaya Koti'a kakaeyafe afino kanale hukate'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Afino kanale hukate'neanaki afeo kakaeya kaipa'ae maite'ka ve mafa'ne alitete'ka aki'a Yisasi'ae hu'ka malo. ");
INSERT INTO ino_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Ani mafa'ne aki hanesea kano mai'nisike'a vaya'yakamoki ‘Hanale mai'nea Anumaya Koti mafa'ne mai'ne.’ hu'a hukae. Hisakeno akinakomo'a Teviti kava yakai'nea lo'kiya'a Anumaya Koti'a amitesikeno Ye'kopu nofi vaya'aite akola kava yakaino mai'neno kava yakaisea afinana haneke haneke huno hanesikeno hano ohuke.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nehikeno Malia'a ko'ku'napi kayo kayo ve'kae inake nehe “Hana'ya hu'na ani kava hukoe? Nakaeya vele o'mai'noa a'mafa'ne mai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nehikeno ani ko'ku'napi kayo kayo ve'kamo'a inake he “Anumaya Koti Fate Akufa Avamu'amo'a kakaeya'ae mai'nisikeno hanale mai'nea Anumaya Koti lo'kiya'amo'a katali kaesike'ka kaipa'ae maite'ka mafa'ne alitekane. Alitesanana vaya'yakamoki ani mafa'nena ‘Kanale fate akufa mafa'ne mai'ne.’ nehu'a ‘Anumaya Koti mafa'ne'a mai'ne.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Afeo. Nekafo'kamo ane'kano Elisapeti'a ako ane'kano le'nea'maki meni aipafina ve mafa'ne mai'neanakeno alitekaiye. A'ke'ainaka ‘Elisapeti'a mafa'ne ali o'atekaiye.’ hu'a hu'naya'maki meni aipa'ae mai'nikeno naya mako kaya hano huteno naya mako kayati mako'ke alea i'ka (6 i'ka) ako akase'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ina kava hu'neanakeno Anumaya Koti'a alo ohisea akufa yana alaki o'male'neanakeno mi'ko yana afa'ake alo huke.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Inake nehuno Malia'a ani kayo kayo ve'kaena inake huno hapai'ne “Afeo. Nakaeya Anumayamo ali'ya a'mafa'ne'a mai'noanakeno kakaeya nahapaina kavana eno hiseane.” nehikeno anileti ko'ku'napi kayo kayo ve'ka ako ataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ani afina Malia'a hetino makale mako avimate kumate u'ne. Ani kumana Yutiane nehaya koteka hane'nikeno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Vea'ya'mo'a Se'kalaiya nopi haino Elisapetina huno falu fala hune'ate. ");
INSERT INTO ino_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Falu fala hutea ke Elisapeti'a ne'afikeno aipafi mai'nea mafa'nemo'a kanake kanake nehikeno Anumaya Koti Fate Akufa Avamu'amo'a Elisapeti aipafina havaite'ne. Havaitekeno ala kekefafati inake he “Kakaeya mi'ko a'ne apa'kase'nananakeno Anumaya Koti'a kanale amuse ya kami'nike'ka ali'nane. Ina kakaeya kaipafi mai'nea mafa'nemo'aeti akaeya kanale amuse ya ali'nea mafa'ne mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nakaeya afa a'mo'na hana kava hu'noke'ka kakaeya Anumaya'nimo ita'amoka nakaeyateka ne'ane. ");
INSERT INTO ino_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Afeo. Kakaeya hu'ka falu fala hunatana ke ne'afukeno naipafi mai'nea mafa'nemo'a amuse nehuno kanake kanake nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amuse huno kanake kanake neheanaki kakaeya Maliaka ko'ku'napi kayo kayo ve'kamo'a kahapaiya kemo'a ‘Ako kanale huno fole aike.’ hu'ka kaipafi malana yafe Anumaya Koti'a amuse hisana yana ako kami'ne.” huno Elisapeti'a hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Ha'nepaikeno Malia'a inake nehe “Naipamo'a Anumayamo aki alino asaka nehe. Nehikeno naku mafa'nemo'a naku name alino kati'nea Anumaya Kotife lusi amuse nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Amuse nehike'na nakaeya ali'ya a'mafa'ne'a afa a'mafa'ne mai'noa'maki akai'a hautaki nate'neanake'na ani mafa'ne afa'a alitesuke'a meni mai'naya vayanaki henaka fole ai'a maisaya vayanaki nakaeyafe ‘Anumaya Koti'a kanale amuse ya ami'nea a'mafa'ne.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ala lo'kiya'a hane'nea ve'kamo'a nakaeyate kanale kava hunate'ne. Ani ve'ka fate akufa ve'ka honi'ya ya'a o'male ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akaeyafe apa'kesa afi'a ‘Alatimokae.’ nehaya vaya'moki'ae alipateme alipateme visaya mafa'ne'yakamoki'ae kalaki aipate'nea ya'amo'a alaki haneme haneme uke. ");
INSERT INTO ino_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ukea'maki aya'afatina lo'kiya ali'ya ne'alino apaipafi ne'afi'a ‘Lakaeya ala vaya mai'none.’ nehu'a apa'kufa ali'a haiya vayana hapafaitaleke'a atale'a u'e'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Lo'kiya kava vayana apavaleno mopafi ne'apateno apa'ki o'male vayana apa'ki alino asaka nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kanale yafe apa'ka nelea vayana kanale ya apamino apamu nehea'maki nesu afeno ya male'naya vayana hapafaitaleke'a afa'a ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A'ke'ainaka lakinakomokife hapapai'nea ke Epalahamu'ae akai'a nofi vaya'ae henaka'a fole aisaya vaya'aife ‘Alaki kalaki aipatekauve.’ hu'ne. Ani hu'nea kemo'a meni akesa ha'kalo hikeno Isaleli koteka ali'ya vaya'a hapa'ma'ne.” Malia'a hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia'a Elisapeti'ae lo'kano aole'ae mako'ae i'ka maiteno henaka'a eteno no'aleka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapeti'a mafa'ne alite kana'a fole aikeno ve mafa'ne alite'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aliteteke'a akai'a kumate vaya'ae akai'a nofi vaya'ae Anumaya Koti'a kalaki aipate'nea yafe afite'a lusi amuse hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Amuse hute'a mako sota maite'a ani ve mafa'nemo akoyamo ano'a hataka hisea ya akekefe e'naya vaya'moki afo'amo hamo'amo'ae nehu'a aki'a Se'kalaiya'ae hu'a malekefe nehaya'maki ita'amo'a “He'e aki'a Yoni'ae huta malekaune.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nehike'a vaya'yakamoki inake hu'a nehae “Na'ya hike'ka ani aki ne'malane? Lakaeya nofi vaya'mokitafina ani akufa aki o'male'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Afo'amo liko'ke'amo'a a'kanile'nikeno ake no'aiya yafe avame'name nehu'a “Na aki malekane.” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Afine'kakeno avame'name nehuno “Avo kaesoa ya nameo.” hike'a amikeno “Aki'a Yoni'ae.” huno ka'ne. Ka'nike'a “Vaya'moki nohaya kava nehe.” hute'a apamo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ani aki kamaletekeno makale'a Se'kalaiya liko'ke'amo'a hakalo hikeno avenafu'namo'a yatala hikeno ake ne'aino Anumaya Koti aki alino asaka nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ina kava hea yafe ani kumate vaya'moki lusi apamo'yo aike'a ani yafe ke hu'a imafi mafi hakeno ani kemo'a mi'ko Yutia avimateka hane'nea kuma'yakale uneno hike'a afi'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Afi'naya vaya'moki afi'a apaipafi malete'a inake hu'a nehae “Anumayamo'a aya hukefe akaeya'ae mai'nea yafe henaka'a mani mafa'ne hana kava hisea mafa'ne maike?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","68","Anumaya Koti Fate Akufa Avamu'amo'a Se'kalaiya aipafi eno havaitekeno afo'amo'a Se'kalaiya'a aune ke laka nehuno inake he “Lakaeya Isaleli vaya'ai Anumaya Koti aki alita asaka hiketao. Akai'a ve a'ne'a eno laha'mano lakaeya lakufa alino kati'nea yafe aki alita asaka hisune. ");
INSERT INTO ino_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anumaya Koti ali'ya ve'ka Teviti nofi anakapati mako lo'kiya ve'ka lakufa alino katiseafe alino hetite'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ani ke Anumaya Koti'a a'ke'ainaka fate akufa apaune vaya'moki apavayale maleke'a hu'a fole ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Inake hu'a hu'nae ‘Kame vayatimoki latafa hu'a mai'naya apayapatina eteno nelavaleno apaipa kafa laha'naya vaya'moki latafa hu'a mai'naya apayapatina eteno lavaleno lakufa alino katike.’ ");
INSERT INTO ino_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anumaya Koti'a a'ke'ainaka lakinakomokitena kalaki aipateteno kanale'ya huno apaya hu'nea kava hukeanakeno a'ke'ainaka ‘Lapamikoe.’ huteno huno lo'kiya vaimale'nea kemo'a afa'a ake o'kanino akesale mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ani lo'kiya ke lakinakomo Epalahamufe ‘Ani kamikoe hoa yana lamake nehoanake'na kamikoe.’ huno lo'kiya ke hapai'ne. A'ke'ainaka hu'nea ya'mo ali'ya'a meni lakaeyate alikefe akesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Ani lo'kiya kemo'a inake hu'neane ‘Nakaeya kame vayatapimoki apayapati lapavale'na lapa'kufa ali'na katitesuketapa lapa'kaeya koli ohutapa nakaeya ali'yate maikae. Mi'ko afina lapa'kaeya ma mopale maisayana nakaeya naulakale nakaeya ali'ya'ni'ale hao'otake kavatapi o'maleno alakepa kava'afati'ke atafa hulikae.’ hu'neane. ");
INSERT INTO ino_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Hu'nea'maki kakaeya Yonika mafa'ne'nimoka henaka'a kakaeyafe ‘Ko'ku'napi mai'nea Anumaya Koti aune ve'kae.’ hu'a hukae. Kakaeya Anumayamo visea katena u'ka hokote'ne'ka visea ka ali'ka hakalo nehu'ka ali'ka alakepa hutekane. ");
INSERT INTO ino_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Lakaeya Anumaya Koti'a lusiya huno kalaki ailatea yafe akaeya ve a'ne hao'otake ya'ape lapahaove lapatove nehuno aipa yuna yapati alino atalene'apateno apa'ku apame alino katisea yafe kakaeya ali'ka apaya hisanake'a apa'kaeya ne'afeo. Hale ya'a ko'ku'napakati atalesikeno lakaeyate elino ekaiye. ");
INSERT INTO ino_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Eno hani yapi mai'neta falikefe nehuna vaya ano halelate'neno laiya alino kate kate hulatesiketa kanale kava huta laipamo'a falu lahaisea kate visuna yafe ekaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Henaka'a ani mafa'ne kosino ala nehikeno aku mafa'ne'amo'ae lo'kiya vai'ne. Vaya o'mai kopaka maime uneno neheateti Isaleli vaya'moki apaulakale eno va'yi hukefe ani kopakati eno fole aike'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ani kanafi mako ala kava ve'kamo aki'a Sisa Okasatasi'a inake hu'neane “Mi'ko Lomu kamanimo yakai'nea koteka vaya'ai apa'ki aesake'a kakae.” hu'neane. ");
INSERT INTO ino_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hokoteno aepa heno apa'ki ka'naya afina Kuilinia'ae ve'ka Silia aupalika hokote kava ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","4","Mi'ko vayana apa'ki kakefe hake'a ko aepa'apileka ute ute hu'nae. Yosefe akinakomo'a Teviti ani koteka alite'naya yafe Yosefe'a Kalili aupalika hane'nea kumana Nasaleti kuma ne'ataleno Petelehemu u'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Malia'a hakemale'naya a'mafa'ne aipa'ae mai'nikeno “La'aki kaesu'afene.” huteno Yosefe'a avaleno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Avaleno vikeno anile uno mai'neno Malia'a mafa'ne alitekefe hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Alitekefe nehea'maki mi'ko havae nona havaite'nea yafe puluma'ka afumo nopi Malia'a yake mafa'ne ve aliteteno kupi asaka huno aiteno puluma'kamo ne'ya ne'nea lapepi havate'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ani hani'ainaka sipi sipi afu anaka'aite ne'yakaiya vayana kahaufaka mai'ne'a sipi sipi afu anaka'aite kava yakai'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mai'nakeno anile Anumaya Koti ko'ku'napi kayo kayo ve'ka ne'ekeno Anumayamo ano hale ya'amo'a ano kahai hulino ne'eke'a lusi koli hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Koli hu'naya'maki ko'ku'napi kayo kayo ve'kamo'a inake he “Koli ohutapa afeo nakaeya kanale ke lahapapaikefe ne'oe. Lusi amuse hisaya ke lahapapaikoanake'a mi'ko ve a'nemoki afikae. ");
INSERT INTO ino_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Meni hani'ainaka Teviti kumate lapa'kufa alino katisea ve'ka ako alite'ne. Ani ve'kamo aki'a Anumaya Kalaisi'ae Anumaya Koti'a lakufa alino katiseafe hute'nea ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ani mafa'ne ku aiteno puluma'ka afumo ne'ya ne'nea lapepi havate'neanaketapa utapa aketetapa ma avame yafe ‘Lahapai'nea ya ako fole ai'ne.’ hutapa hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Nehike'a ani ko'ku'napi kayo kayo ve'ka'ae mi'ko mako kayo kayo anaka'ae makale'a ali'a atalu hute'a Anumaya Koti aki ali'a asaka nehu'a inake nehae “Anumaya Kotitimoka hanafi mai'nane huta kaki alita asaka nehune. Ma mopale amuse nehisaya vayana mai'a falu hu'a maisae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ani kayo kayo vayana apatale'a ko'ku'napaka haitake'a sipi sipile kava yakai'a ne'maiya vaya'moki ke hu'a imafi mafi nehu'a inake nehae “Viketao Anumayamo'a lahapai'nea yana uta akesune.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hute'a naku naku hu'a ani koteka akekefe u'nayana Malia'ae Yosefe'ae mafa'ne'ani afumo ne'ya ne'nea lapepi atete'ana mai'na'ake'a u'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Akete'a ko'ku'napi kayo kayo ve'kamo'a ani mafa'ne hapapai'nea ke mi'ko vaya'aina hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hapapaike'a mi'ko ani ke afi'naya vaya'moki sipi sipile kava ne'yakaiya vaya'moki hapapaiya ke afite'a apamo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Apamo'yo ne'aiya'maki Malia'a mi'ko ani ke afino aipafi maleteno akesa'ake afino mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mai'nike'a sipi sipile kava ne'yakaiya vaya'moki ete'a kuma'apileka ne'u'a ako hapapaike'a afite'a ake'naya yafe Anumaya Kotiteka amuse hu'a aki ali'a asaka hume hume ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yisasina aliteteke'a mako'ke sota maite'a akoyamo ano'a laka haya afina aki'a Yisasi'ae hu'a male'nae. Ani aki ita'amo'a aipa'ae o'mai'nea afina ko'ku'napi kayo kayo ve'kamo'a ani aki'a ako male'nea aki male'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ita'amo'ae mafa'ne'a'ae aiku nopakati lama'ana esa'a afina Mosese'a hu'nea ke a'kame malesa'a yafe Yisasina avale'u'ana Anumaya Koti amikefe Yelusalemu avale'ana hai'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anumaya Koti ke kamale'naya avopi inake hu'a kamale'nayane “Mi'ko yake mafa'ne ve alipatesayana Anumaya Koti ayapi malesakeno fate akufa mafa'ne maisae.” hu'a kamale'nayane. ");
INSERT INTO ino_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kamale'naya yafe Anumaya Kotiteka amuse yana amikefe avale'ana hai'na'ae. Anumaya Koti ke kamale'naya avopi kemo'a inake hu'neane “Aole nama akapalapi aole kase'kana namalapi Anumaya Kotina amuse ya amikane.” hu'a kamale'nayane. ");
INSERT INTO ino_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Ani kanafi mako Yelusalemu mai'nea ve'kamo aki'a Simioni'ae. Ani ve'ka Anumaya Koti ke a'kame ne'maleno alakepa ve'ka mai'neanakeno Isaleli vaya'ai apa'kufa alino katisea ve'ka esea yafe akeva mai'nikeno Fate Akufa Avamu'mo'a akaeya'ae mai'neno inake huno hapai'ne “Makale ofalikana'maki Kalaisi'a Anumaya Koti'a apa'kufa alino katikefe hute'nea ve'ka esike'ka akete'kake falikane.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Hapaiteno ala mono nopi avalekeno ne'ekeno anile mai'nike'ana Yisasi ita afo'amokani mono kemo avaya hipo'ya hukefe avale'ana e'na'akeno ani ve'kamo'a Yisasina avaleno anu'ki'neno Anumaya Koti aki alino asaka hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Simioni'a inake nehe “Anumayamoka hokote'ka nahapai'nana mafa'ne meni ani mafa'nemo'a lakaeya lakufa alino katisea ve'ka ne'akokeno naipamo'a falu ne'nahaiyanake'ka ali'ya ve'ka'kamo'naena ‘Faleo.’ hisanake'na falisoe. ");
INSERT INTO ino_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mi'ko vaya'moki apaulakale ani lakufa alino katisea ve'ka laveli'nane. ");
INSERT INTO ino_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Laveli'nananakeno ani ve'kamo'a kakai'ka Isaleli vaya'moki apa'ki alino asaka huteno Isaleli nofi o'mai'naya vaya'aina ano hale ne'apateno kakaeya kavake hapapaike.” ");
INSERT INTO ino_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Hike'ana Yisasi ita afo'amo'akani Simioni'a ani mafa'ne hu'nea ke afite'ana lusi ana'kesa afifi hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Afi'a mai'na'akeno Simioni'a kanale manu ne'anamino Maliafe ani mafa'nemo ita'amofe inake he “Afeo Anumaya Koti'a mani mafa'ne hute'neana mi'ko Isaleli kote mai'naya vayapati mako vaya'a alino la'ka'ka ai ne'apataleno mako'a alino hetipatesea yafe hutekeno e'ne. Anumaya Koti'a avame ya hisea yafe hutekeno e'neanake'a mi'ko vaya'moki akaeyafe ‘Kaote'ya'kae.’ hu'a hukae. Ani kava hu'naya yafe mi'ko vaya'moki apaipa apa'kesafati ne'afea ke fole aipatekaiye. Maliaka henaka'a lusiya huno kakaeya kahau halekaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ani mono nopi mako Anumaya Koti aune ana mai'ne. Ani a'mo aki'a Ana'ae afo'amo aki'a Fanueli'ae. Ana'kaeya Asa nofi vayapati mai'nae. Ani ana ako ane'kano le'nikeno kafu'amo'a aole'ae aole'ae vaya'moki apaiya apaya hano huteno aole'ae aole'ae kafu (84 kafu) mai'ne. Venemo a mai'nea afina anau'amo'a naya mako kaya hano huteno naya mako kayati aole alea kafu (7 kafu) mai'nikeno anau'amo'a falitekeno kaite mai'neno mono no o'ataleno mi'ko afina hani'ainaka'ae feluka'ae Anumaya Koti aki alino asaka nehuno ne'ya mosi'neno Anumaya Kotiteka afike afike huno ne'maiye. ");
INSERT INTO ino_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ani a'mo'a anile va'yi huno Yisasina aketeno Anumaya Kotife lusi amuse huteteno mi'ko Yelusalemu vaya apa'kufa alino katisea ve'kae akeva mai'naya vaya'aina Yisasina hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yisasi ita afo'amokani mono ke hapa'nepaiya kavana hano huteke'ana Kalili ute'ana kuma'anileka Nasaleti u'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yisasi'a kosino lo'kiya mafa'ne akenopa hale'nea mafa'ne mai'nikeno Anumaya Koti'a akaeya'ae mai'neno hautakiteno ha'maesea ya ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isaleli koteka vaya'moki mi'ko kafu'ae kafa'ae Yelusalemu u'a Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi'a hao hisaya emu ka'a ne'kike'ana Yisasi ita afo'ala'mokani mi'ko kafu'ae ani emuleka Yelusalemu u'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","U'na'akeno Yisasi'a nayatala'a hano huteno naiyalekati aole alea kafu'a neheana mi'ko kafu'ae kafa'ae nehaya kava hu'a emuleka hai'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ani emu kea kana'a hano hike'a no'apileka yatala kate aepa he'a utakeno ani mafa'ne Yisasi'a o'uno afa'a Yelusalemu mai'nike'ana ita afo'ala'mokani o'afi'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Mako vayati'a'ae kateka ne'ekaiye.” hu'ana hute'ana mako'ke afina kateka ute'ana hani'ainaka ana'kai'ani anakapi'ae kuma'anile vaya'aipi'ae kahau a'na'ana o'ake'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Alaki o'ake'ana Yelusalemu kahau akefe ete'ana u'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aole'ae mako'ae afina kahau ake akete'ana kahau ame u'ana ala mono nopi ali'a apaya nehaya vaya'moki folakapi mai'nike'ana u'ana ne'aka'ae. Ne'aka'a'maki ani vaya'ai folakapi faitopale mai'neno apa'kaeya ke afiteno haya kemo anona'ale apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Apafine'keke'a mi'ko ani ke'a afi'naya vaya'moki ke anona'ale “Kanale akenopa hale'nea mafa'ne.” nehu'a lusiya hu'a apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Apamo'yo ne'aike'ana ita afo'amokani anamo'yo ne'ai'ana ita'amo'a inake he “Mafa'ne'nimoka na'ya hike'ka ma kava hunela'atane? Afo'kamo'ae nakaeya'ae la'aipa afita'a kana'ake nehuta'a kakaeya kahau ne'ao'ae.” ");
INSERT INTO ino_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nehikeno Yisasi'a ana'kaeyafe “Na'ya hiketana nakaeya kahau ne'a'ae? Nakaeya afo'nimo nopi maisoa yafe ne'nahaiye hu'na hoa ke o'afi'na'afe?” ");
INSERT INTO ino_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nehike'ana akaeya hea kemo aepa'a afi'ana ha nola'ae. ");
INSERT INTO ino_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Afi'ana ha nola'akeno Yisasi'a ana'kaeya'ae lavino Nasaleti mai'neno ana'kaeya ke afiteno a'kame ne'malekeno ita'amo'a mi'ko hu'nea kavana alino aipafi male'ne. ");
INSERT INTO ino_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ne'malekeno Yisasi'a ko'nesino akenopafi hale ya'amo'a ala hutekeno Anumaya Koti'ae vaya'amoki'ae afi'a lusi amuse hute'nae. ");
INSERT INTO ino_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taipiliasi Sisa'a mi'ko Lomu vaya kava yakai kuma'yaka aole nayatala'a hano huno naiya mako kaya'a hano hea kafu (15 kafu) kava ya alino mai'nikeno ani kafu Potiasi Pailati'a Yutia koteka kava ya alino mai'nikeno Heloti'a Kalili koteka ani kava huno kava ya alino mai'nikeno akana'amo'a Filipi'a Itulia koteka'ae Tale'konaitisi koteka'ae kava ya alino mai'nikeno Laiseniasi'a Apilini koteka ani kava huno kava ya alino mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mai'nake'ana ani afina Anasi'aki Kaiyafasi'aki ala mono nopi hokote kava ve'kala mai'na'akeno ani afina Yoni'a Se'kalaiya mafa'ne ka'me koteka mai'nikeno Anumaya Koti kemo'a akaeyate e'ne. ");
INSERT INTO ino_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Akaeyate ekeno Yoni'a ani afina Yotani li aki'nale hane'nea kuma'yakale uno Anumaya Koti ke hapa'nepaino inake he lapaipa aitapa yahae nehutapa hao'otake yatapi atalesake'na li falelapatesukeno Anumaya Koti'a hao'otake kava hu'naya yafe lahapaove lapatove nehuno aipa falu yapati alino atalelapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A'ke'ainaka Anumaya Koti aune ve'ka Aisaiya'a inake huno kamale'neane “Vaya o'mai aupalika mako ve'kamo'a kate kate nehuno inake huke ‘Anumayamo esea ka valitapa alitapa alakepa heo. ");
INSERT INTO ino_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Otu lavi'niseapi maletapa havai netetapa aise avima'ae ala avima'ae kafitapa alaku hikeno elineno makotalakame hise. Uno kayaki eno kayaki hu'nea ka alitapa api aiyo. Yafa hane'nisea ka'ae alitapa alakepa hukae.’ ");
INSERT INTO ino_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nehisakeno Anumaya Koti'a apa'ku apame alino katisea kavana mi'ko vaya'moki akekae.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mi'ko vaya'yaka “Yoni'a li falelatese.” nehu'a ne'akeno Yoni'a apa'kaeyafe inake huno hapa'nepaiye “Lapa'kaeya osifa'vemo mafa'neyaka mai'nisakeno Anumaya Koti'a kake hulapatesea kana'a lapa'kufa lapa'kafu kisea kana'a makale va'yi hisea yafe ‘Lapaune hetapa veo.’ ke nala'a lahapapaiketapa ne'ae? ");
INSERT INTO ino_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hokotetapa lapa'kaitapi kanale kava haya yateti lapaipa aitapa yahae hutapa hao'otake yatapi atalesaya yatapi navelisayana lina falelapatekauve. Lapa'kaeya ‘Epalahamu mafa'neyaka mai'none.’ hutapa oheo. Nakaeya lahapa'nepauve Anumaya Koti'a ma yafatetina alino Epalahamu mafa'ne alo hinine. ");
INSERT INTO ino_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lapa'kaeya yosakana hu'nakeno meni Anumaya Koti'a ko'ne alino yosa hafu'yale avame nehuno kanale alaka'a o'aesaya yosa'a atakino atafi yaka huno kakaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hike'a mi'ko vaya'moki inake hu'a afine'kae “Lakaeya hana kava hisune?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nehakeno Yoni'a inake nehe “Mako ve'kamo'a akufale ya aole hane'nisikeno eno mako akufale ya o'malesea ve'ka mako amino. Ne'ya'a hane'nisea ve'kamo'a ani kava huno ne'ya'a o'malesea ve'ka amino.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nehike'a vaya'ai apa'kufaleti ta'kesi miya ne'alea vaya “Li falelatese.” hu'a li falepateate ne'e'a akaeyafe inake nehae “Ali'ka laya nehana Nenao lakaeya hana ya hisune?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nehakeno apa'kaeyafe inake he “Ala kava ve'kamo'a ‘Ina'a ta'kesi miya aleo.’ hisea kate maletapa aleo. Afa miya'api'ae ali o'apateo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mako ati vaya'moki'ae inake hu'a afine'kae “Lakaeya hana ya hisune?” hu'a hakeno apa'kaeyafe inake he “Lapa'kaeya vayana nehapatapa moni'api o'aleo. Lapa'ke'atike kefati kake hutapa moni'api o'aleo. Alisaya miya'ake amuse hutapa aleo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nehike'a mi'ko vaya'moki “Anumaya Koti'a apa'kufa alino katisea yafe hutesea ve'ka makale ekaiye.” hu'a akeva mai'naya yafe Yonife lusi apaipa apa'kesa ne'afi'a “Yoni'a ani Kalaisi'a lakufa alino katiseafe hute'nea ve'ka mai'nifi? Fate ve'ka mai'ne?” hu'a apa'kesa aole ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hu'a ne'afikeno Yoni'a apa'kaeyafe inake nehe “Nakaeya litafateti fale nelapatoanakeno henaka'a esea ve'kamo'a Fate Akufa Avamu'amoteti'ae ataleti'ae falelapatekaiye. Ani ve'kamo'a lusi lo'kiya'a hane'nea ve'kakeno nakaeya ako nakase'neanake'na nakaeya afa ve'ka mai'noanake'na akaeya aiya'kale aesoana o'natekaiye. ");
INSERT INTO ino_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Akaeya sipeti ayo ali'neno viti avina hakome avinakana yana faino kateno alakepa alaka'a nopi anupa huno malekaiya'maki ano'a ata leke leke nehea atafi kakaiye. Ani avina alino fa'ko fa'ka hea avamete vaya alino fa'ko fa'ka huke.” ");
INSERT INTO ino_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoni'a mani ke'ae fate fate ke'ae hapa'nepaino huno apa'kesa nehuno Anumaya Koti kanale ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Hapa'nepaikeno Heloti'a ala kava ve'kamo'a mi'ko hao'otake kava hu'nea ya'ae akana'amo ana Helotiasina kumai kava hune'ateno alite'nea yafe'ae Yoni'a aulakafi ke ano asali huno hau'ne. Ano asali huno hau'nea ke Heloti'a mi'ko hao'otake kava hu'nea ya akaseno Yonina avaleno nofi hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Nofi hu o'ate'nea kanafi Yoni'a mi'ko vaya li fale ne'apatekeno Yisasi'a akaeyate ekeno Yisasina li faletetekeno Anumaya Kotiteka afine'kekeno ko'ku'na'mo'a hakalo nehikeno Fate Akufa Avamu'mo'a namakana huno haleno akaeyate elino ne'ekeno ko'ku'napakati ala ake ne'aino inake nehe “Kakaeya mafa'ne'nimoka kakaeyafe lusiya huno nahau nayamopafati ne'nahaiya mafa'ne'nimoka kakaeyafe lusiya hu'na amuse'ka nehoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yisasi'a mako ve'kamo aiya aya'a hano huno mako ve'kamo ayatala'a hano hea kafu (30 kafu) maiteno ali'ya'a aepa nehe. Mi'ko vaya'moki akaeyafe “Yosefe mafa'ne mai'ne.” hu'a nehae. Yisasi loto'amoki apa'kimo'a ne'eatekati aepa hu'neateka lavi'neanaki hapaleo. Yosefe afo'amo aki'a Hilai'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai afo'amo aki'a Matata'ae. Matata afo'amo aki'a Livae'ae. Livae afo'amo aki'a Mele'kai'ae. Mele'kai afo'amo aki'a Yanai'ae. Yanai afo'amo aki'a Yosefe'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefe afo'amo aki'a Matataiyasi'ae. Matataiyasi afo'amo aki'a Emosi'ae. Emosi afo'amo aki'a Neami'ae. Neami afo'amo aki'a Esalai'ae. Esalai afo'amo aki'a Nakai'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai afo'amo aki'a Me'ati'ae. Me'ati afo'amo aki'a Matataiyasi'ae. Matataiyasi afo'amo aki'a Semeni'ae. Semeni afo'amo aki'a Yose'ki'ae. Yose'ki afo'amo aki'a Yota'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota afo'amo aki'a Yoanana'ae. Yoanana afo'amo aki'a Lesae. Lesa afo'amo aki'a Selapapeli'ae. Selapapeli afo'amo aki'a Sialitielo'ae. Sialitielo afo'amo aki'a Nelai'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nelai afo'amo aki'a Mele'kai'ae. Mele'kai afo'amo aki'a Etai'ae. Etai afo'amo aki'a Kosama'ae. Kosama afo'amo aki'a Elamatama'ae. Elamatama afo'amo aki'a Ea'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ea afo'amo aki'a Yosu'ae. Yosu'a afo'amo aki'a Eliesa'ae. Eliesa afo'amo aki'a Yolima'ae. Yolima afo'amo aki'a Matata'ae. Matata afo'amo aki'a Livae'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae afo'amo aki'a Simioni'ae. Simioni afo'amo aki'a Yuta'ae. Yuta afo'amo aki'a Yosefe'ae. Yosefe afo'amo aki'a Yonama'ae. Yonama afo'amo aki'a Elaiya'kimi'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiya'kimi afo'amo aki'a Melia'ae. Melia afo'amo aki'a Mena'ae. Mena afo'amo aki'a Matata'ae. Matata afo'amo aki'a Netani'ae. Netani afo'amo aki'a Teviti'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Teviti afo'amo aki'a Yesi'ae. Yesi afo'amo aki'a Opeti'ae. Opeti afo'amo aki'a Povasi'ae. Povasi afo'amo aki'a Salamoni'ae. Salamoni afo'amo aki'a Nasoni'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoni afo'amo aki'a Aminatapi'ae. Aminatapi afo'amo aki'a Atamina'ae. Atamina afo'amo aki'a Anai'ae. Anai afo'amo aki'a Hesaloni'ae. Hesaloni afo'amo aki'a Pelesi'ae. Pelesi afo'amo aki'a Yuta'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuta afo'amo aki'a Ye'kopu'ae. Ye'kopu afo'amo aki'a Aisa'ki'ae. Aisa'ki afo'amo aki'a Epalahamu'ae. Epalahamu afo'amo aki'a Tela'ae. Tela afo'amo aki'a Neho'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho afo'amo aki'a Sela'ki'ae. Sela'ki afo'amo aki'a Leo'ae. Leo afo'amo aki'a Pele'ke'ae. Pele'ke afo'amo aki'a Epe'ae. Epe afo'amo aki'a Sela'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela afo'amo aki'a Kenani'ae. Kenani afo'amo aki'a Apa'kasati'ae. Apa'kasati afo'amo aki'a Semi'ae. Semi afo'amo aki'a Noa'ae. Noa afo'amo aki'a Lame'ka'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lame'ka afo'amo aki'a Metusala'ae. Metusala afo'amo aki'a Ino'ku'ae. Ino'ku afo'amo aki'a Yaleti'ae. Yaleti afo'amo aki'a Mahalaleli'ae. Mahalaleli afo'amo aki'a Kenani'ae. ");
INSERT INTO ino_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani afo'amo aki'a Inosi'ae. Inosi afo'amo aki'a Seti'ae. Seti afo'amo aki'a Atamu'ae. Atamu afo'amo aki'a Anumaya Koti'ae. ");
INSERT INTO ino_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Anumaya Koti Fate Akufa Avamu'amo'a Yisasi aipafi havaite'nikeno Yisasi'a Yotani li ne'ataleno ne'vikeno Fate Akufa Avamu'amo'a vaya o'mai'a ka'me aupalika avaleno uno atalekeno aole ve'kala'mokani anaiya anaya hano hea afina (40 afina) ne'ya o'neno mai'nikeno Sata'a Yisasife “Hao'otake kava ho.” huno ano avataka hu'ne. Ano avataka huke huke huketekeno Yisasi'a ne'ya o'ne'nea yafe ani kana'a hano hutekeno lusi aka le'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aka nelekeno Sata'a Yisasife inake he “Kakaeya Anumaya Koti mafa'ne mai'ne'kaefena ma yafafe hapaikeno kai hame'ya maya hamalese.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nehikeno Yisasi'a anona'a ke'ale inake huno hapai'ne “Anumaya Koti avopi kemo'a inake hu'ne ‘Vaya'moki ne'ya'ake nesayana kanale hu'a mai ya o'alikae.’ huno kamale'neane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nehikeno Sata'a Yisasina avaleno hanale ate'neno makale'a mi'ko ma mopale hane'nea no kuma'yaka'ae afeno'ya'ae aveli'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aveliteno Sata'a Yisasife inake nehe “Mani mi'ko kanale konakali ya hane'nea kumana yakaisana lo'kiya'ka kamikoe. Ani mi'ko kava yakai lo'kiya nakaeya yanake'na mako ve'ka amikoe hu'na hisoana afa'a amikoe. ");
INSERT INTO ino_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kakaeya nakaeyate e'ka ape hu'ne'ka nakaeyafe kakesa afi'ka ‘Ala ne'ni mai'nane’ hu'ka naki ali'ka asaka hisanana lo'kiya'ka kamikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yisasi'a anona'a ke'ale inake nehe “Anumaya Koti ke kamale'naya kemo'a inake hu'neane ‘Anumaya Koti'kamofe akaeya mako'ke'ake ala mai'ne nehu'ka akaeyate'ke kakesa afifi nehu'ka aki ali'ka asaka nehu'ka akaeya'ke a'kame ne'male'ka ali'ya'a aleo.’ huno hu'neane.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nehikeno Sata'a Yisasina Yelusalemu avaleno ala mono no'mo akofetule haino ha'ko'ya vai'nea yate ate'neno inake huno hapai'ne “Kakaeya Anumaya Koti mafa'ne mai'ne'kaefena ma no'mo akofetuleti asaka hulavi'ka mopafi laveo. ");
INSERT INTO ino_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Anumaya Koti avopi kamale'naya kemo'a inake hu'neane ‘Anumaya Koti'a ko'ku'napi kayo kayo anaka'ae kava huteo huno hupatesike'a eli'e'a kanale ya hu'a yakaikate'nisake'ka asaka hulavisanana apaya akusale kavale'a asaka hisakeno mako yafatena kaiya ano lo o'akaiye.’ huno hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nehikeno Yisasi'a anona'a ke'ale inake he “Anumaya Koti ke kamale'naya avopi kemo'a inake hu'neane ‘Kakaeya Anumaya Koti'kamo'a ala'kamona a'ka avataka oho.’ huno hu'neane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nehikeno Sata'a fate fate yate Yisasina ano avataka huketeno ne'ataleno “Mako afina ete'na a'na avataka hisoane.” huno akeva mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yisasi'a Fate Akufa Avamu'mo lo'kiya'ae Kalili ekeno akaeya avake'amo'a mi'ko ani kopi uneno hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mi'ko afina mono no'yaka'apifi alino apaya hike'a mi'ko vaya'moki akaeya ke afite'a aki'a ali'a asaka hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisasi'a Nasaleti aise ya mai'neno kosino ala hu'nea kumate uno mi'ko Sapati afina nehea kava huno mono nopi haino Anumaya Koti ke hapalikefe hetino mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hetino mai'nike'a Anumaya Koti aune ve'kamo'a Aisaiya'a kamale'nea avona ali'a amikeno va'kaleno kahau ano ake'neana ani kemo'a make hu'nea ke ake'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anumayamo Fate Akufa Avamu'amo'a nakaeyapi mai'ne. Mai'nikeno ‘Afeno ya'api o'male vaya'aite kanale ke u'ka hapapaiyo.’ huno lo'kiya'a namiteno hunateke'na e'noe. Hunateteno ma ke hu'ka hapapaiyo huno hu'ne ‘Nofi hulapatesaketapa mai'nisaya vayana kalu helapatesuketapa meni ataletapa afa'a ukae. Lapa'kaeya lapaulaka apalo hu'niketapa no'akaya vayana meni lapaulaka aketapa aya'ketapa akeo. Kame vaya'apimoki ali'a hao'otake kava hupate'naya kava'apimo'a nofi hupate'nea vaya'aife kalu helapate'noki afa'a veo.’ hu'na hisoa yafe hunateke'na e'noe. ");
INSERT INTO ino_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Anumayamo kanale kana'a fole ai'nea yafe'ae ‘Ke ali'ka u'ke'ka hu'ka hapapaiyo.’ huno hunateke'na e'noe.” huno hu'neane nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Huteno Yisasi'a ani hapalea avona aino a'kanileteno kava ve'ka amiteno mopale uno ne'maike'a mi'ko ani mono nopi mai'naya ve a'nemoki Yisasitekake aulu nehae. ");
INSERT INTO ino_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aulu nehakeno inake huno hapa'nepaiye “Meni lapa'kesafati ne'afikeno mani Anumaya Koti kemo'a fole aino ne'ya'a alitekeno lamake nehiketapa afi'nae.” ");
INSERT INTO ino_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Inake hea yafe lusi amuse nehu'a Yisasi aki ali'a asaka nehu'a kanale ke Yisasi avayafati hea yafe apa'kesa afikete'a inake nehae “Hana'ya huno'ae? Akaeya Yosefe mafa'ne o'mai'nife?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nehakeno Yisasi'a apa'kaeyafe inake nehe “Lamake lahapa'nepauve lapa'kaeya nakaeyafe ma ke hutapa hukae ‘Tota ve'kamoka kakai'ka kakufa ali'ka kanale huketa akeno. Kapaneamu kumate hu'nana kava hu'ka male kakai'ka kumate'ae huketa akeno.’ hutapa hukae. ");
INSERT INTO ino_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hukaya'maki nakaeya lamake hu'na lahapa'nepauve mako Anumaya Koti ke hapa'nepaiya ve'kamo'a akai'a kumate vaya'aipi ke nehiseana ‘Anumayamo ali'ya ve'kamo keki afiketao.’ hu'a ohukae. ");
INSERT INTO ino_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Lamake hu'na lahapapauve a'ke'ainaka Ilaiya'a mai'nea kanalena aole'ae mako'ae kafuki (3 kafu) naya mako kaya hano huteno naya mako kayati mako'ke'a alea i'ka (6 i'ka) ko o'aike'a ani Isaleli koteka mai'naya vaya'moki ne'ya'api o'maleke'a lusi apa'kate'ne. Ani afina mi'ko kaite a'neyaka Isaleli koteka mai'nayanaki Anumaya Koti'a aune ve'ka'a Ilaiyana ani kaite a'neyaka'aite hu o'ate'neanaki mako kumate aote mai'nea kaite ate Salefati kuma'mo ala aki'a Saitoni mai'nea ate hutekeno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ani kava huno a'ke'ainaka Ilaisa mai'nea afina fuko'ya apa'ke'nea vaya Isaleli koteka mai'nayanaki ani vaya'aipina mako'ke ve'ka'api alino kanale hu o'ate'neanaki mako alu koteka ve'kake aote mai'nea ve'ka Nemanina Silia mai'nea ve'kake alino kanale hute'ne.” huno Yisasi'a nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nehike'a ani ke afite'a mi'ko ani mono nopi mai'naya vaya'moki lusiya hu'a ke ne'ne'a apaipa afi'a haviya nehae. ");
INSERT INTO ino_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lusi ke ama'kite'a heti'a Yisasina atafa hute'a avale'a ma'aileka ne'ate'a avale'a u'a hai'nae. Ani kumana avimate kati male'naya kumatenake'a “Ani avimatekati uta alita ako'ya faitalekaune.” hute'a avale'a anileka u'nae. ");
INSERT INTO ino_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nehaya'maki Yisasi'a mi'ko vaya'ai folakapakati ako apataleno aluleka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisasi'a Kalili hane'nea kumate Kapaneamu lavi'neno Sapati afina mi'ko ve a'ne'aina Anumaya Koti ke alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Alino apaya nehike'a afeana akaeya kemo'a aki hane'nea ve'kamo nehea kekana huno hike'a lusi apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Ani mono nopi mako ve'ka Sata afe'mo'a aipafi mai'nea ve'ka mai'neno avo avo nehuno kalafa ne'kano inake nehe “Hae Yisasika Nasaleti ne'moka na ya hulatesana yafe e'nane? Lakaeya laha'ka falilatekefe e'nape? Nakaeya kakaeyafe ako afi'noe. Kakaeya fate akufa ve'ka Anumaya Koti'a hukate'nea ve'ka mai'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nehikeno Yisasi'a lo'kiya kefati ani Sata afe kanoe inake nehe “Ke ohu'ka mani ve'kamo aipafakati atale'ka ako uvo.” nehikeno ani Sata afe'mo'a mi'ko vaya mai'naya folakapi asaka huno alino ako'ya fai ne'ataleno mako'ae alino haviya huo'ateno ani ve'ka ne'ataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vike'a mi'ko vaya'moki ani ya ne'ake'a lusi ke hu'a imafi mafi nehu'a inake nehae “Ma ke hu'nea ke na akufa ke? Akaeya lusi lo'kiya'aleti Sata afe ke hapa'nepaike'a ke'a afi'a a'kame male'a vaya aipafati atale'a u'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nehike'a Yisasi'a hea avake'amo'a mi'ko kumate kumate uneno hike'a afi'nae. ");
INSERT INTO ino_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Yisasi'a ani mono nona ataleno Saimoni nopi hai'ne. Saimoni a'mo ita'amo'a lusi amu'ko kali ali'nike'a Yisasife “E'ka amu'ko kali'a ali'ka atalo.” hu'a ke nehakeno ani a'mo haute uno ani amu'ko kali ke ne'ama'kikeno ani kali'amo'a ne'atalekeno makale ani a'mo'a hetimaleno ne'ya kano apami'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ani afinana yakemo'a lavino falekefe nehike'a ani kumate vaya'moki vaya'api aki'ae aka'ae kali ali'naya vaya'yaka apavale'a Yisasite ete ete hakeno mi'ko mako'ke mako'kete aya malepateno kali'api alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kanale hune'apateke'a apaipafati Sata afe'yakamoki apatale'a ne'u'a inake hae “Kakaeya Anumaya Koti mafa'ne mai'nane.” hu'a hu'naya'maki akaeyafe apa'kaeya ako afi'nayane “Yisasi'a Anumaya Koti'a apa'kufa alino katisea ve'ka mai'ne.” hu'a ako afi'naya yafe Yisasi'a ke apama'kino “Mako'ae ke oheo.” huno hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Natepati Yisasi'a apataleno vaya o'mai koteka u'nike'a mi'ko vaya'moki kahau ame u'a ake'a fole aite'a inake hu'a nehae “Kakaeya latale'ka o'u'ka lakaeya'ae maiketao.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nehakeno Yisasi'a inake huno hapapaiye “Nakaeya Anumaya Koti'a vaya'aite kava yakaipatesea kanale ke mako'ae alu kumate kumate u'ne'na nehu'na hapapaisoe. Anumaya Koti'a ani ali'yatefe hunateke'na e'noe.” ");
INSERT INTO ino_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Inake huteno Yisasi'a mi'ko Yutia koteka vaya'ai mono nopi uneno nehuno Anumaya Koti ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mako afinana Yisasi'a Kenesaleti li'kotu aki'nale heti'nike'a mi'ko vaya'moki Anumaya Koti ke afikefe a'kalo a'kalo hu'a ali'a folakapi ate'nae. ");
INSERT INTO ino_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ate'nakeno Yisasi'a akeana aole lipi kalelana li aki'naleka avayu hu'a e'a male'nakeno ake'nike'a faya lu'konako ne'male'a maiya vayana ani lipi kalefati atale'a faya lu'konako ku'api sese nehae. ");
INSERT INTO ino_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sese nehakeno Yisasi'a mako lipi kale Saimoni kalefi haino mai'neno inake he “Saimonika li aki'nalekati aise'a lipi a'ka atufakeno vino.” huno hapaiteno Yisasi'a ani lipi kalefi faitopale mai'neno mi'ko ali'a atalu hu'naya vaya'aina Anumaya Koti ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hapapaiteno Saimonife inake he “Lipi kale'ka ali'ka li folakapi a'ka atufa'ka kotu aulaka'afi lu'konako'ka atalesanakeno lavinake'ka faya hekane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Inake nehikeno Saimoni'a Yisasife inake he “Ala Nenao lakaeya ako meni hani'ainaka eta faya lu'konako male'nona'maki faya mako'ke'a ohe'nonakeno koti'ne. Ohe'nona'maki kakaeya hana kele a'kame male'na lu'konako malekauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Ani lu'konako lipi malayana nesu faya'yakamoki hai'a havaite'nakeno lu'konako ku'mo'a kana'ake huteno aino a'kano'kanu hukefe hike'a mako lipi kalefi apa'kaeya'ae lo'ka'a ali'ya ne'alea vayafe apayateti avame'name nehu'a “Etapa laha'maeyo.” hu'a hake'a e'nae. E'a ani aole lipi kalelapina faya ali'a malayana havaiteteno kana'ake hike'ana ani lipi kalelana a'ana lapa'kanesa'a kava hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimoni Pita'a ani kava aketeno Yisasi aiyafi ape hu'neno inake he “Anumayamoka nakaeya hao'otake kava nehoa ve'ka mai'noki nakaeya natale'ka uvo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimoni'ae lo'ka'a mai'naya vaya'ae faya ali'a male'a havaite'naya yafe lusi apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimoni'ae lo'ka'ana ali'ya ne'ali'a ve'kalana Sepeti mafa'nela Yemisi'ae Yoni'ae ani kava hu'ana ana'kaeya'ae anamo'yo ai'na'ae. Anamo'yo ne'ai'akeno Yisasi'a Saimonife inake he “Meni koli oheo. Faya lu'konako male'ka faya hana avamete ani kava hu'ka meni Anumaya Koti'a akola maisaya apavamu apamisea yafe vaya apavalekane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nehike'a lipi kale ali'a u'a kahaepateka malete'a mi'ko ya'api ne'atale'a Yisasi a'kame ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Inaki mako afina Yisasi'a mako ala kumate mai'nikeno mako ve'ka fuko'ya'mo'a akufa alino hayaki'nea ve'kamo'a mai'neno Yisasina aketeno akaeyate ape hu'neno inake hu'ne “Anumayamoka kahaisike'kaefena nakaeya ako ali'ka kanale hunatanine.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nehikeno Yisasi'a ayana aya huno akufale ame ali'neno inake he “Nakaeya ne'nahaiyanakeno kakufamo'a meni kanale huke.” nehikeno makale'a kali'a hano hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hano hutetekeno Yisasi'a inake huno ha'nepaiye “Ali'na kanale hukate'noa yafe mako ve'ka ha'opai'ka mono nopi kava ve'kale ukeno kakufa valava kano kaketesike'ka mi'ko vaya'moki kali'ka ali'na kanale hukate'noa ke afisae hu'kaena kakaeya Mosese'a a'ke'ainaka hapapai'nea kava hu'ka ‘Ma ya Anumayamoteka ameo.’ huno hu'nea ya meni amisanake'a mi'ko vaya'moki ‘Kali'ka hano hu'ne.’ hu'a hisae.” huno lo'kiya kefati ke hau'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hapai'nea'maki kali'a alino kanale hute'nea avake'amo'a uneno hike'a nesu vaya'moki afite'a “Akaeya ke ne'afisunakeno kaliti alino kanale hulateseafene.” hute'a e'nae. ");
INSERT INTO ino_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E'naya'maki Yisasi'a nesu afina apataleno vaya o'mai aupalika uno mai'neno Anumayamoteka ke huno afike afike huno mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Inaki mako afina Yisasi'a alino apaya nehike'a mi'ko Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae Yelusalemuti'ae mi'ko Kalili no kumateti'ae Yutia no kumateti'ae anile e'a haute faitopale mai'ne'a afi'nae. Afi'nakeno Anumaya Koti lo'kiya'amo'a Yisasi'ae hane'nikeno ani lo'kiya'aleti kali vayana alino kanale hune'apate. ");
INSERT INTO ino_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Mako vaya'moki mako ve'ka sifanafi hipo'ya alili'a e'nae. Ani ve'ka aiya aya ayamufa avayu hulavi'nikeno ayamufamo'a lo'kiya o'malekeno mi'ko afina havano ne'maiya ve'ka sifanafi atete'a Yisasite avale'a mai'nea nopi hai'a amete atekefe nehaya'maki nesu vaya ani nopi mai'a kilipa'nake'a ani kali ve'ka ali'a haisaya kana o'malake'a ani kali ve'ka ali'a ohai'a atale'a no'kato'mule hai'a mako yosa ali'a asaka humale'ne'a mani kali ve'ka mi'ko ve a'ne mai'naya folakapi atalakeno lavino Yisasi amete ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ai'nikeno Yisasi'a aketeno inake huno akesa afi'ne “Ani ve'ka avale'a e'naya vaya'moki nakaeya ke afi'a apaipafi male'nae.” nehuno kali ve'kaena inake nehe “Vaya'nimoka hao'otake kava hu'nana kavafe ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.” ");
INSERT INTO ino_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hike'a mono hapali'a hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae ani Yisasi'a hea ke afite'a apaipafi inake hu'a nehae “Ma ve'ka Anumaya Kotife huno haviya hune'atea ve'ka akaeya nala'ae? Mako ve'kamo'a hao'otake yafe ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe huno hisea lo'kiya'a o'male'nea'maki Anumaya Koti'a akai'ake hao'otake yafe ako kahaove katove nehuno aipa falu yapati havi ya'ka ako ali'na atalekatoe huno hisea lo'kiya'a hane'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nehakeno Yisasi'a ako afea apaipa apa'kesa afiteno ke'apile inake huno hapapai'ne “Na kava hiketapa lapa'kesa afitapa lapa lapa ne'aiye? ");
INSERT INTO ino_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nakaeya ne'aloa ali'yana hana ali'ya'mo'a ala kana'a hane'ne? ‘Hao'otake kava hu'nana yafe ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.’ hu'na hoa ali'ya'mopi ‘Kali'ka ako ali'na kanale hukatoki sifana'ka alite'ka heti'ka uvo.’ hu'na hoa ali'ya'mo'ae? ");
INSERT INTO ino_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ina yafe nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na mopale mai'ne'na hao'otake yana kahaove katove nehu'na naipa falu yapati ali'na atalesoa lo'kiya'ni hane'nea yafe lapa'kaeya afitapa halesaya yafe mako kava hu'na lapavelikoe.” nehuno aiya aya avayu hulavi'nikeno lo'kiya'a o'male'nea ve'kae inake nehe “Nakaeya kaha'nepauki heti'ka sifana'ka alite'ka no'kaleka uvo.” ");
INSERT INTO ino_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nehikeno makale'a ani ve'kamo'a ve a'ne'ai folakapati he'netino hava'nea sifana'a aliteno no'aleka ne'uno Anumaya Koti aki alino asaka hume hume u'ne. ");
INSERT INTO ino_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ne'vike'a mi'ko ali'a atalu hu'naya vaya'moki lusi apamo'yo aike'a lusi koli hute'a Anumaya Koti aki ali'a asaka nehu'a inake nehae “Meni afina fate akufa lo'kiya ya ne'akone.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Anile apataleno ne'uno mako ve'ka aki'a Livae'a kumaya'ya nehuno vaya apa'kufaleti ta'kesi moni alilitata nehea ve'kakeno ofisi no'ale faitopale mai'nikeno Yisasi'a ani ve'ka aketeno inake nehe “Kakaeya na'kame eno.” ");
INSERT INTO ino_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nehikeno Livae'a mi'ko ya'a ne'ataleno Yisasi a'kame ne've. ");
INSERT INTO ino_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Livae'a no'afi Yisasina lusi ne'ya ka ne'ateke'a mi'ko vaya apa'kufaleti ta'kesi moni ali'a u'e'a nehaya vaya'ae mako vaya'ko'ae Yisasi'ae lo'ka'a ani ne'ya ne'nae. ");
INSERT INTO ino_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ne'nake'a Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae Yisasi ke ne'afea anaka'aife hikalu ke nehatake'a inake nehae “Na'ya hiketapa lapa'kaeya vaya apa'kufaleti ta'kesi moni ali vaya'ae hao'otake kava nehaya vaya'ae ne'ya ne'nae?” hu'a apafine'kae. ");
INSERT INTO ino_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Apafine'kakeno Yisasi'a inake huno ke anona'apile hapapai'ne “Kali'api o'male'nea vaya'moki Tota ve'kale no'vaya'maki kali vaya'mokike Tota ve'kale ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nakaeya alakepa vaya'aife e'na ‘Lapaipa aitapa yahae heo.’ hu'na ke hukefe o'me'noa'maki nakaeya e'noana hao'otake yapi mai'naya vaya'aife ‘Lapaipa aitapa yahae heo.’ hu'na ke hisoa yafe e'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nehike'a ani vaya'moki inake hu'a Yisasife nehae “Yoni ke ne'afea vaya'ae Falasi mono ke ne'afea vaya'ae ne'ya mo'nesea'maki kakaeya ke ne'afea anaka'moki ne'ya mi'ko kanafi ne'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Nehakeno Yisasi'a inake huno hapa'nepaiye “Mako ve'kamo'a a'a aliteno yake yaka hema kiseate vaya'amoki u'a ani ve'ka'ae mai'nisayana ani vaya'moki ne'yana mo'nesife? He'e mo'osikae. Mo'osikayanake'a henaka'a ani a ali'nea ve'ka kame vaya'amoki atafa hu'a apa'kaeyapati avale'a atalesakeno apa'kaeya'ae o'mai'nisike'aena inani afina ne'ya ne yafe ‘He'e.’ hu'a mosikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisasi'a avoya kefati inake huno hapa'nepaiye “Mako ve'kamo'a saufa kenaleti aise ya'a laka huno atafa kena vala ai'nisea kate maleno ohatike. Maleno hatiseana saufa kena'a alino haviya huke. Saufa kenaleti aise'a laka huno atafa kenale maleno hati'niseana mako'ke kava ohuka'ae. ");
INSERT INTO ino_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mako ve'kamo'a saufa vaeni nofi alakamo li'a atafa meme afumo akufaleti alo humale li'kepi ola'kike. La'kino vaiseana saufa vaeni li'mo'a ano atalaka hisikeno vaeni lina vale vale huno mopafi asaka hulavisikeno meme afumo akufaleti alo humale li kena ano atalaka atalako hisikeno akola haviya huke. ");
INSERT INTO ino_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Saufa vaeni lina la'kino vaikefe saufa meme afumo akufaleti alo humale li kepi la'kike. ");
INSERT INTO ino_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A'nu'ka heteno atu he'nisea vaeni li ne'nea ve'kamo'a atu ohe'nisea vaeni life nohaiye. Nohaiyanakeno inake nehe ‘Atu he'nea vaeni li'amo'ke kanale'ya huno haka'ake nehe.’ hu'ne.” Yisasi'a huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mako Sapati afina Yisasi'ae akaeya ke ne'afea anaka'ae mako kile hoyamo folakapi u'e'a nehu'a Yisasi ke ne'afea anaka'moki kile kalete'a fali hu'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ne'nake'a mako Falasi mono ke ne'afea vaya apa'kete'a inake hu'a nehae “Sapati kanafi he'e humale'naya kavana na'ya hiketapa ina kava nehae?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nehakeno Yisasi'a ke anona'apile inake huno apafine'ke “Lapa'kaeya Teviti'a hu'nea ke hapalitapa o'afi'nafe? Ani kanafi Tevitina a'kame hu'a u'naya vaya apa'kate'neane. ");
INSERT INTO ino_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Apa'ka'netekeno Teviti'a Anumaya Koti nopi haino kai hame'ya maya Anumaya Koti aulakale hane'nea maya alino ne'ne. ‘Ani kai hame'ya maya afa vaya'moki o'nekafa Anumaya Koti nopi ali'ya vaya'mokike nekae.’ hu'a he'e humale'nae. He'e humale'naya'maki Teviti'a afa'a alino ne'neno a'kame hu'a u'naya vaya'ae apamike'a ne'nae. Lapa'kaeya inani kava hu'nea ke hapalitapa afi'nafi o'afi'nae?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yisasi'a inake nehe “Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na Sapati kanalena yakai'noa afo'amo'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mako fate Sapati afina Yisasi'a mono nopi haino mono ke hapa'nepaino akeana mako aya lamaka'a fali'nea ve'ka ani folakapi mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mai'nike'a Falasi mono ke ne'afea vaya'ae mako mono hapali'a hapa'nepaiya vaya'ae “Yisasi'a hao'otake kava nehe.” hu'a hisaya yafe kahau a'a akekefe “Yisasi'a Sapati kanafi ani kali ve'ka alino kanale hutesifi hu o'atesifi?” hu'a Yisasina amata hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amata hu'a mai'naya'maki Yisasi'a ako ani vaya'moki ne'afea apaipa apa'kesafi ako afiteno ani aya lamaka'a fali'nea ve'kaena inake huno hapai'ne “Kakaeya ani vaya'moki folakapi heteo.” hikeno ani ve'ka heti'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hetino mai'nikeno Yisasi'a amata hu'naya vayafe inake nehe “Mako ke hu'na lapafikekefe huki afeo. Sapati kanaena Anumayamo kemo'a na'yane ke nehe? Sapati kanafi vayana alita kanale hupatesupi alita kanale huo'apatesune? Sapati kanafina vayana apaya huta apa'kufa alita katisupi hapaesunake'a falisae? Lapa'kaeya na lapa'kesa ne'afe? Anumayamo kemo'a na'yane ke hu'ne.” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mi'ko vaya'moki apaulakaleka akeme uneno nehuno ani aya fali'nea ve'kae inake huno hapai'ne “Kakaeya kaya ali'ka api aiyo.” hikeno alino api ne'aikeno ako kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ayana kanale hike'a ani vaya'moki akete'a lusiya hu'a apaipa kafa neha'a “Yisasina na kava hutesune?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mako afina Yisasi'a Afo'amoteka afikekefe avimapi hai'ne. Ani hani'ainaka akola Anumayamoteka afike afike nehutekeno ko alino hale'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko alino ha neleana akaeya ke ne'afea anaka'aife ke hike'a e'nae. Akeno ayatala'a hano huteno aiyalekati aole alea vayana le'kanapaiteno “Nakaeya ke ne'afike'na ali'ya'nile hulapatesoa vaya (Aposolo vaya) maiyo.” huno hupate'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Ani ke'a ne'afea anaka'moki apa'ki'a Saimoni'ae ve'kamo aki Yisasi'a Pita'ae huno ate'ne. Etalu'a Saimoni akana'amo'ae Yemisi'ae Yoni'ae Filipi'ae Patalomiu'ae Matiu'ae Tomasi'ae Yemisi'a Alafiasi mafa'ne'ae Saimoni'a mako aki'a Seloti'ae. ");
INSERT INTO ino_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yutasi'a Yemisi mafa'ne'ae Yutasi Isa'kalioti'a akaeya henaka'a Yisasina akesi huno kame vaya'aina avaleno apamisea ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisasi'a akaeya ke ne'afea anaka'ae lavino mako otu kumate heti'ne. Mako'ae nesu vaya akaeya ke ne'afea ve a'ne ali'a atalu hu'naya yate e'nae. Ani vaya'moki mi'ko Yutia kotekati ne'e'a Yelusalemuti ne'e'a hake li'mo aki'nale hane'nea kumatalana Taiyati'ae Saitoniti'ae e'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","“Yisasi ke afitesunakeno kaliti alino atalese.” hu'a e'a mai'nakeno Sata afe'mo'a apaipafi mai'nea ve a'ne mai'nakeno Yisasi'a ani Sata afe hafai ne'ataleno alino kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yisasi aipafati lo'kiya'a fole hinake'a mi'ko vaya'ai kali alino kanale hupatea yafe mi'ko e'naya ve a'nemoki apaya akaeya akufale ame'ko hukefe nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisasi'a akeno asaka huno akaeya ke ne'afea anaka'aiteka ne'apa'keno inake nehe lapa'kaeya mi'ko afeno'yatapi o'male vaya'mokitapa Anumaya Koti kava yakailapate'nea yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lapa'kaeya meni lapa'ka'nelea vayana henaka'a ne'ya netapa lapamu hisaya yafe amuse heo. Meni aviletapa mai'naya vayana henaka'a kiki hisaya yafe amuse heo. ");
INSERT INTO ino_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na na'kame ne'malaya yafe vaya'moki apaipa kafa lusiya hu'a henelapate'a lahapafai ne'atale'a kamuke nelahapau'a lapa'ki a'a “Havi ya mai'nae.” hu'a hisayana lapa'kaeya ani afina lusiya hutapa amuse heo. ");
INSERT INTO ino_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ani kava hulapatesaya afina ko'ku'napi ala miya alisaya yafe lapaipamo'a kanale nehinaketa amuse heo. Ali'a haviya hunelapataya vaya'ai apa'kinakomoki a'ke'ainaka inani kava hu'a Anumaya Koti aune vaya ali'a haviya hupate'nayanake'a meni mafa'ne'apimoki'ae lapa'kaeyate ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nehaya'maki avo'neo nesu moni afeno male'naya vayana maitapa halove hu'netapao. Lapaipa alitapa falu hisaya yatapi hai ali'nae. ");
INSERT INTO ino_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Avo'neo meni ne'ya netapa lapamu nehaya vayana maitapa halove hu'netapao. Henaka'a lapa'kana lekaiye. Avo'neo meni kiki nehaya vayana maitapa halove hu'netapao. Henaka'a lapahautakitapa lusi avi lesaya ya va'yi huke. ");
INSERT INTO ino_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Avo'neo mi'ko vaya'moki lapa'ki ali'a asaka nehisayana lapa'kaeya maitapa halove hu'netapao. A'ke'ainaka apa'kinakomoki ani ya hu'a apa'ke'atike apaune vaya'ai apa'ki ali'a asaka hu'nayane. ");
INSERT INTO ino_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nakaeya ke afisaya vaya'mokitapa kame vayatapimokife lahapau lapayamopafati lahapaino. Apaipa kafa helapate'naya vaya'aina kanale kava hupateo. ");
INSERT INTO ino_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vaya'moki lapa'kaeya ali'a haviya hulapatesaya vaya'aina “Anumaya Koti'a lapa'kaeya amuse ya lapamise.” hutapa heo. Hu'a haviya hune'kataya vaya'aife “Hapa'mao.” hu'ka Anumayamoteka ke hu'ka afiko. ");
INSERT INTO ino_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mako ve'kamo'a kakalametale kamakisike'kaena “Mako kaya nakalametale'ae namakeo.” hukeno kamakino. Mako ve'kamo'a ala yasi siota'ka alisike'kaena mako kakufale siota'ka'ae afa'a ameo. ");
INSERT INTO ino_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mako ve'kamo'a “Mako ya'ka nameo.” nehisike'kae ani ve'ka afa'a ameo. Kakaeya ya kumaya ali'nea ve'kae “Ete'ka nameo.” hu'ka oho. ");
INSERT INTO ino_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mako vaya'aife “Ma kava hunateo.” hu'ka hisana kavana kakaeya'ae alu vayana ani kava hupato. ");
INSERT INTO ino_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vaya'moki apaipafati lapa'kaeyafe nehapaisea vaya'aife lapa'kaeya'ae ani kava hutapa apa'kaeyafe lapaipafati lahapau'kea'maki ani kava hisaya yatena na akufa amuse ya alikae? Amuse ya alaki o'alikae. Hao'otake kava nehaya vaya'moki'ae ani kava hu'a apa'kaeyafe apaipafati hapaiya vaya'aife nehapaiye. ");
INSERT INTO ino_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Inaki kanale kava hulapate'naya vaya'aina ani kava hutapa anona'a kanale kava hupatesayana ani kavana afa yanaki hana'ya hutapa amuse yana alikae? He'e amuse yana alaki o'alikae. Hao'otake kava nehaya vaya'moki'ae ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Inaki “Eteno namisea yanake'na mako ve'ka yo'ka amikoe.” hutapa hisayana afa yanaketapa hana amuse ya alikae? He'e amuse ya o'alikae. Hao'otake kava nehaya vaya'moki'ae mako'ke akufa ya alisaya yafe hao'otake kava nehaya vaya'api yo'ka ne'apame. ");
INSERT INTO ino_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ina kava nehaya'maki lapa'kaeya kame vayatapi lapaipa apamitapa kanale kava hupateke hupateke hutapa maiyo. Lapafikesaya yafe “Eteta anona'a mako ya o'alikune.” lapa'kesa o'afitapa hapaisea ya yo'ka apameo. Ina kava hisayana henaka'a Anumaya Koti'a ala ya anona'a lapamisiketapa ko'ku'napi mai'nea Anumaya Koti mafa'ne anaka'a maikae. Hao'otake kava nehaya vaya'ae Anumaya Koti'a kanale ya hupate'nea yafe amuse ohu'naya vaya'ae Anumaya Koti'a aipamo'a falu huno hapane'maeye. Lapa'kaeya ani kava hisayana Anumaya Koti mafa'neyaka'a maikae. ");
INSERT INTO ino_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yisasi'a inake nehe “Afotapimo'a hau hunelapatea kava hutapa lapa'kaeya'ae vayafe lahapau hupateo.” ");
INSERT INTO ino_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Vayatapimokife “Ina akufa kava hana ve'ka mai'nane.” hu o'apateo. Ani kava hu o'apatesayana Anumaya Koti'a lapa'kaeya'ae “Ina akufa kava nehana ve'ka mai'nane.” hu o'katekaiye. Vayatapi kake hu o'apatesayana Anumaya Koti'a ani kava huno lapa'kaeya'ae kake hu olapatekaiye. Hao'otake kava hulapate'nea ve'kae “Ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.” hutapa hisakeno'aena Anumaya Koti'a akaeya'ae hao'otake yatape “Kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.” huno huke. ");
INSERT INTO ino_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vayatapi kanale ya apamisakeno Anumaya Koti'a ani kava huno kanale yana lapamike. Kutapifi ailapatesikeno kutapimo'a havaiteteno alilavimo avamete lapamike. Ma mopale vayatapimokite hupatesaya kavana Anumaya Koti'a inani avamete'ke lapa'kaeyate'ae ani kava huno anonatapile lapamike nehe. ");
INSERT INTO ino_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mako avoya ke inake hu'ne mako aulaka apo ka'nea ve'kamo'a mako ani ya huno aulaka apo ka'nea afalufe “Kana inale male hane'ne.” huno ka avelikife? He'e avaleno viseana aoleka'amokani kelifi'ke asakaulavika'ae. ");
INSERT INTO ino_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mako avo nopi mafa'nemo'a alino aya nehea nena ao'kasekaiya'maki mi'ko alino aya hu'nea ya afino alakepa huno afiteno alino aya hu'nea ve'kamo'a hu'nea kava huno mako'ke avamete hu'ana maika'ae. ");
INSERT INTO ino_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Lakaeya lakaiti laipafi hane'nea ya afiteta alu vayafe “Hao'otake ve'ka mai'nane.” hisuna yafe Yisasi'a inake nehe “Na'ya hike'ka vaya'kamo aulakafi aise yosa aleto'na hane'nike'ka ne'akana'maki kakai'ka kaulakafi mako ala yosa a'kopakefa hane'nike'ka o'male'ne.” hu'ka nehane? ");
INSERT INTO ino_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na'ya hike'ka vaya'kamofe “Kaulakafati yosa atana ali'na atalekauve.” hu'ka nehana'maki kakai'ka kaulakafi mako ala yosa a'kopakefa hane'nike'ka o'ake'ka “O'male'ne.” hu'ka nehane? Kaipafi hane'nea yana ake'ka alakepa ohu'ne'ka ameka kavayaleti kake'atike vakala ke hu ve'ka mai'ne'ka kakai'ka kaulakafati ala yosa a'kopa ali'ka atalete'ka vaya'kamo aulakafi henaka'a kanale ake'ka aise yosa aleto'na ali'ka atalekane nehe. ");
INSERT INTO ino_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kanale yosamo'a havi alaka no'aekeno havi yosamo'a ani kava huno kanale alaka'a no'aeye. ");
INSERT INTO ino_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","No'aeya'maki vaya'moki yosa alaka'a akete'a kanale alaka'a hane'niseana “Kanale yosa hane'ne.” hu'a hukae. Lakaeya ako ake'none yu'yu'mo alaka'a mako aufe yosafati alaka'a olaki'nae. Ani ya huno kaimo'a mako aufe yapati no'aeya'maki kanale yosafati'ke ne'aeye. ");
INSERT INTO ino_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kanale aipa akesa'ae ve'kamo'a kanale aipa akesa hane'nea yapati mi'ko kanale ke nehea'maki havi aipa akesa'ae ve'kamo'a havi aipa akesa hane'neapati mi'ko havi ke nehe. Vaya'moki apaipa apa'kesafi havaite'nea yana apavayafati ani ke fole ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Na'ya hiketapa nakaeyafe “Alatimokae Alatimokae.” nehutapae'maki nakaeya hoa ke a'kame no'malae? Ani ke hu'naya ke afa ke nehae. ");
INSERT INTO ino_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mako ve'kamo'a nakaeyate eteno ke'ni afiteno a'kame malesaya yafe ma ve'kamo mai au'ava ya'amo lapa'kaeya lapa'kesa afisaya yafe lahapapaisuketapa afikae. ");
INSERT INTO ino_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ani ve'ka mako no kikefe nehea ve'kakana hu'ne. Hokoteno keli kafino ema afepi laviteno kemi yosa posi yafa'mo akofetule ani kelifi faiteteno ano alaki huteno no kimale'nikeno lusi ko aiteno li heno ani note e'nea'maki ani ve'kamo'a kanale'ya huno kimale'nea yafe ani nona alino kape ole'ne. ");
INSERT INTO ino_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Alino kape ole'nea'maki mako ve'kamo'a nakaeya ke afiteno ani kele a'kame o'malesea ve'kamo'a mopa laka'ake mopafi no ki'nea ve'kakana nehe. Ani ve'kamo'a keli ameka kafiteno falu falu posi faiteno no'a kimale'nikeno lusi ko aiteno li heno ani note e'neno makale alino kape letale'ne huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisasi'a mi'ko ve a'ne'aina ke hapapaiteno Kapaneamu kumapi u'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","U'nikeno mako Lomu ati vaya'aite kava ve'kamo ali'ya ve'ka'a lusiya huno nehaiya ve'ka ala kali alino ako falikefe nehe. ");
INSERT INTO ino_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Falikefe nehikeno ani kava ve'kamo'a Yisasi avake'a afiteno mako ala ala vaya Yisasite hune'apateno inake nehe nakaeya hoa ke inake hutapa Yisasife afikeo “Amuse'ka nehuki e'ka ali'ya ve'ka'ni kali'a ali'ka kanale huto huno ke nehe.” hutapa afikeo huno hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Hapa'nepaike'a Yisasite u'a “Laha'mao.” hu'a ke hu'a afike afike nehu'a inake nehae “Ani kava ve'kamo'a lakaeya Yuta vaya'mokitae lusiya huno nehaikeno mono noti kilate'nea yafe kanale ve'ka mai'niki afa'a ha'maesanana kanale kava hukane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Nehakeno Yisasi'a apa'kaeya'ae no'ale ako u'a va'yi hukefe nehaya'maki Lomu ati vaya'aite kava ve'kamo'a mako fate vaya hune'apateno inake hutapa heo huno hupateke'a u'a Yisasite e'a inake hu'a nehae kava ve'ka inake nehe “Ala Nenao alaka kahaesike'kaena atalo. Nakaeya kanale ohu'noa ve'kake'ka no'ni'afi esanana kanale o'katekaike'nae ani yafe nakaeya kakaeyate o'u'noki afa'a meni ali'ya ve'ka'nimo kali'aena anilekati ke'ake nehisanakeno kali'a kanale hutese hu'nae nehoe. ");
INSERT INTO ino_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nakaeya kakaeya'kana hu'na kava ve'ka mai'noe. Nakaeyate kava yakainate ve'ka hanale mai'nike'na nakaeya ani ya hu'na mako ati vaya'aite kava ve'ka mai'noe. Mako ve'kae ‘Uvo.’ hukeno'aena ne've. ‘Eno.’ hukeno'aena ne'e. Ali'ya ve'ka'ni'aena ‘Ina kava ho.’ hukeno'aena ani kava nehe.” huno hu'ne hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hapaikeno Yisasi'a ani ke afiteno ani ve'kae “Namo'yo ne'aiya ke naha'nepaiye.” huno mi'ko a'kame ne'vaya vaya'aife inake nehe “Lahapa'nepauve alaki mako Isaleli ve'kamo'a ma kava ve'kamo hea kava huno nakaeyafe afino aipafi maleama'a o'ake'noe. Mani ve'kamo'a lusiya huno nakaeyafe afino aipafi male'ne.” ");
INSERT INTO ino_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nehike'a hupateke'a e'naya vaya'moki ete'a noteka u'a akayana ani ali'ya ve'kamo kali'a ako kanale hute'nike'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yisasi'a aise kanato'a maikeno mako ala kumate u'neana ani kuma'mo aki'a Neni. Akaeya ke ne'afea anaka'ae nesu ve a'ne'ae lo'ka'a akaeya'ae u'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ani ala kuma keki'ya vekomo kipate uno lava'netake'a mako fali'nea nahaeya ve'ka ali'a u'a kitekefe ali'a e'nae. Ani fali'nea ve'kamo ita'amo'a alaki mako'ke mafa'ne'akeno ita'amo'a koku kena'ae a mai'nike'a ani kumate nesu vaya'moki ani a'mo a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ne'vakeno Anumayamo'a ani ana aketeno lusi hau nehuno inake huno hapai'ne “Kakaeya kahau netaki'ka avi lana yana hano hinake'ka avi ole'ka afa'a maiyo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inake huno hapaiteno ali'naya sifanale uno atafa nehike'a ani sifana ali'naya vaya heti'a mai'nakeno Yisasi'a inake nehe “Ma nahaeyanao nakaeya kaha'nepauki ete'ka heteo.” huno ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ha'nepaikeno ani fali'nea nahaeya'mo'a hetimaleno ke aepa heno ke nehikeno Yisasi'a avaleno ita'amona ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Amike'a mi'ko vaya'moki lusi apamo'yo aike'a Anumaya Koti aki ali'a asaka nehu'a inake hu'a nehae “Mako ala Anumaya Koti aune ve'ka lakaeya folakapi e'ne.” nehu'a “Anumaya Koti'a mi'ko vaya'a apa'kufa alino katikefe hute'nea ve'ka ako eno mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yisasi'a ani kava hu'nea kemo avake'amo'a mi'ko Yutia koteka'ae mako aupalika hane'nea kumate'ae uneno hike'a afi'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yisasi ali'nea ali'ya'mo avakemo'a uneno nehike'a Yoni ke ne'afea vaya'moki ani avake'a Yonina hapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Hapaikeno Yoni'a akaeya ke ne'afea vayapati aole ve'kala ke hike'ana akaeyate a'akeno Anumayamoteka hune'ateno “Inake hutana afike'ao.” huno hanapai'ne. “Kakaeya ekaiye hu'naya ve'ka mai'napi mako alu ve'kae akeva maisune hutana afike'ao.” huno hanapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nehike'ana ani aole ve'kala Yisasite ute'ana inake hu'ana neha'ae Yoni'a li fale ne'apatea ve'kamo'a hula'ateketa'a kakaeyateka ne'o'ae. Ne'o'akeno “Inake hutana afike'ao.” huno laha'apaiye “Kakaeya ekaiye hu'a hu'naya ve'ka mai'napi mako alu ve'kae akeva maisune? huno hu'ne.” hu'ana afine'ka'ae. ");
INSERT INTO ino_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Neha'akeno ani afina Yisasi'a mi'ko fate fate kali ali'naya vaya alino kanale hune'apateno Sata afe mi'ko vaya'moki apaipafi mai'nea Sata afe'yakae “Apataletapa apaipafati veo.” huno hupate'ne. Apaulaka apo ka'nea vaya apaulaka alino kanale hupateke'a ake'a aya'ke'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yoni ke ne'afi'a ve'kala'mokani anona'a ke'anile inake nehe “Lana'kaeya utana ne'aka'a ya'ae ne'afi'a ya'ae Yonina inake hutana hapai'ao ‘Apaulaka apo ka'nea vaya'moki apaulaka ake'a aya ne'kae. Apaiya haviya hu'nea vaya'moki heti'a u'e'a nehae. Afuko'ya apa'ke'nea vaya'yaka eteno apa'kufamo'a kanale hupate'ne. Apa'kesa a'kanile'nea vaya'yaka ete'a ne'afe. Fali'naya vaya ete'a heti'a mai'nae. Afeno ya'api o'male'nea vaya'moki Anumaya Koti kanale ke'a ne'afe.’ hutana hapai'ao. ");
INSERT INTO ino_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nakaeya hu'noa kavafe aole apa'kesa afi'a ya o'kalesea vaya'moki lusi amuse hu'a maikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoni ke ali'ana a'a ve'kalana ako uta'akeno Yisasi'a Yonife inake huno mi'ko ve alave'aina hapa'nepaiye a'ke'ainaka vaya o'mai koteka u'nayana na'ya akekefe u'nae? Mako ve'kamo'a hopakana huno yasimo'a alino uteno eteno nehea ve'ka akekefe u'nafe? He'e ani akufa ya akekefe o'u'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na ya akekefe u'nae? Vaya o'mai koteka mako kanale nale kena havai'nea ve'ka akekefe u'nafe? He'e kanale nale kena havaili'a kanale ne'ya ne'a apamu nehaya vaya'moki vaya o'mai kopaka o'maikaya'maki ala kava ve'kamo kanale no'afi'ke maikae. ");
INSERT INTO ino_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lapa'kaeya u'nayana na'ya akekekefe u'nae? Anumaya Koti aune ve'ka akekefe u'nafi? He lamake lahapa'nepauve ani ve'kamo'a mi'ko Anumaya Koti aune vayana apa'kaseno lusi kanale aune ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ani ve'kaena Anumaya Koti avopi inake huno kamale'neane “Afeo nakaeya Anumaya Koti'na ali'ya ve'ka'ni hutesukeno viseana nakaeya ke alino uno hokote'neno visana ka valikatekaiye.” hu'a kamale'nayane. ");
INSERT INTO ino_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nakaeya lahapa'nepauve Yoni'a mi'ko ma mopafi mai'naya vayana apa'kase'nea'maki mako afa ve'kamo'a Anumaya Kotife “Kava yakainato.” huno hisea ve'kamo'a Yonina ako akase'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","30","Yoni'a hea ke afite'a mi'ko vaya'ae kumaya'ya nehu'a vaya apa'kufaleti ta'kesi moni ne'alea vaya'moki'ae inake hu'a nehae “He Anumaya Koti ke male male'nea ke alaki lamake ke hane'ne.” hu'a nehakeno Yoni'a li falepate'ne. Ani li falepate'nea vaya'moki ani ke nehaya'maki Falasi mono ke ne'afea vaya'moki'ae mono hapali'a hapa'nepaiya vaya'moki'ae Yoni'a li falepatea lina ofale'nayanake'a “Anumaya Koti ke male male'nea ke lakaeyafe ohu'ne.” nehu'a kanale ka apaveli'nea kana apa'kame'ya ami'nae. ");
INSERT INTO ino_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yisasi'a inake nehe apa'kame'ya ami'nayanake'na meni afina mai'naya vaya'mokitapaena hana akufa vaya mai'nae hu'na lahapapaisoe? ");
INSERT INTO ino_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ma ke hisoa akufa mafa'neyu'kana hutapa mai'nae. Mako mafa'neyu'moki kuma folakapi mai'ne'a mako fate mafa'neyaka'aife make hu'a ke nehae “Lakaeya yave'ya ne'amakuna'maki lapa'kaeya lapaiya no'ae. Lakaeya avi yakame nehuna'maki lapa'kaeya avi nolae.” ");
INSERT INTO ino_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yoni'a li falepate ve'ka e'neana ne'ya o'neno nofi alakamo lina o'ne'neanaketapa lapa'kaeya “Sata afe aipafi mai'ne.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nehayanaki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na e'na li ne'ne'na ne'ya ne'ne'na nehoanaketapa lapa'kaeya nakaeyafe inake hutapa nehae “Akekeo lusiya huno ne'ya neke neke li neke neke nehea ve'ka eno mai'neno kumaya ya hu'a vaya apa'kufaleti ta'kesi moni ne'alea vaya'ae hao'otake kava nehaya vaya'ae akaeya vaya'ake mai'nae.” hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nehaya'maki Anumaya Koti a'kame ne'vaya vaya'moki inake hu'a nehae “Anumaya Koti'a aku akesafi hane'nea kavapati kanale yana fole ai'nea yafe vaya'moki alakepa kava nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mako Falasi mono ke ne'afea ve'kamo aki'a Saimoni'ae. Saimoni'a Yisasife inake nehe “Nakaeya'ae ne'ya e'ka no.” hikeno Yisasi'a uno ne'ya nekefe Falasi mono ke ne'afea ve'kamo nopi haino faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Faitopale mai'nikeno mako kumai a ani kumate ne'maiya a'mo'a “Yisasi'a Falasi mono ke ne'afea ve'kamo nopi ne'ya nekefe u'ne.” hu'a haya ke afiteno mana'ake masavena havaite'nea ke'ayona aliteno u'ne. Ani ke'ayo alo nehaya yafa'mo aki'a alapasata. ");
INSERT INTO ino_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yisasife “Ala ve'ka mai'nane.” huteno Yisasi a'kameleka aiyafi ape hu'neno avi nelekeno aunumo'a Yisasi aiyale nelavikeno akai'a ayo'kaleti ano kalopa ne'ateno alino soso hune'ateno mana'ake masaveteti fale ne'ate. ");
INSERT INTO ino_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fale ne'atekeno “Ne'ya e'ka no.” hu'nea Falasi mono ke ne'afea ve'kamo'a ani ya aketeno inake huno akesa afi'ne “Ma ve'ka Anumaya Koti aune kano mai'nininana aiyale alino soso hune'atea a'mofe ako afinine. Ani a'mo'a lusiya huno hao'otake kava nehea a mai'ne huno akesa afinine.” huno akesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Akesa ne'afikeno Yisasi'a akaeyafe inake nehe “Saimonika mako ke kahapaisoe.” huno hikeno “Ali'ka laya nehana ve'kamoka nahapaike'na afino.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nehikeno Yisasi'a inake huno ha'nepaiye aole ve'kala'mokani u'ana moni'a hane'nea ve'kae mako ve'kamo'a “Naya mako kaya vaya'ai apaiya apaya kina (K100) nameo.” hikeno mako ve'kamo'a “Naya aole hano hea kina (K10) namisanaketa'a miya ya huta'a neteta'a henaka'a eteta'a kami'ano.” hu'ana ha'akeno anamike'ana ali'ana u'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Henaka'a ete'ana amisa'a moni'ani hoka'o'anateke'ana o'ami'akeno “O'namitana atale'ao.” nehe. Ani ke hu'nea yafe hana ve'kamo'a moni ami'nea ve'kae lusiya huno amuse huno hau ayamopafati hauke huno afike'ne? ");
INSERT INTO ino_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Afikekeno Saimoni'a inake he “Nakesa afoana ala moni ali'nea yafe ‘Atalo.’ huno hute'nea ve'kamo'a lusi amuse nehuno hau ayamopafati hauke.” huno hikeno Yisasi'a inake nehe “Lamake alakepa ke hane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ani ke huteno aino afeleno ani a ake'neno Saimonife inake huno hapai'ne “Kakaeya ani ana ako. Nakaeya kakaeya nopi oa'maki naiya sese hu o'natanakeno ma a'mo'a akai'a aunuleti naiya sese hunateteno akai'a ayo'kaleti alino hau hune'nate. ");
INSERT INTO ino_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kakaeya nopi e'na mai'noa'maki nakaeya nakufalena ali'ka soso hu o'natanakeno ma a'mo'a naiyale eno aluya huno alino soso hune'nate. ");
INSERT INTO ino_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kakaeya afa masaveteti nakenopafina fale o'natanakeno ma a'mo'a mana'ake masaveteti naiyale falene'nate. ");
INSERT INTO ino_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ani yafe kaha'nepauve ani a'mo hao'otake kava'amo'a lusiya hu'nea'maki Anumaya Koti'a haove atove nehuno aipa falu yapati alino atalete'nea yafe lusiya huno hau ayamopafati hau'ne. Hau'nea'maki aise hao'otake ya'a hane'nisea ve'ka Anumaya Koti'a ani hao'otake yafe ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe hiseana aise ya'a hau ayamopafati hauke.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yisasi'a inake huno ani afe ha'nepaiye “Nakaeya hao'otake kava hu'nana yafe ako kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.” huno ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ha'nepaike'a akaeya'ae lo'ka'a faitopale mai'naya vaya'moki apa'kai'api sumi sumi kefati inake hu'a nehae “Mani ve'ka hana akufa kano mai'neno'ae ‘Hao'otake kava hu'nana yafe kahaove katove nehu'na naipa falu yapati ali'na atalekatoe.’ ke nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nehakeno Yisasi'a ani afe inake he “Nakaeyafe afi'ka kaipafi male'nana yafe kaku kame ako ali'na katoanaki kanale kame male'ka kaipa falu yapati uvo.” hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Aise kanato'a maiteno Yisasi'a ala ala kumate'ae aise aise kumate'ae uneno nehuno Anumaya Koti'a kava yakaipatesea kanale ke ve a'ne'aina hapapai'ne. Akai'a ayatala'a hano huno mako kaya aiyalekati aole alea anaka'a'ae mako a'neyaka'ae akaeya'ae u'nae. A'ke'ainaka ani a'nemoki apaipafati Yisasi'a Sata afe'yaka alino atalete kali'api alino kanale hupatete hu'nea a'neyaka'ae Yisasi'ae lo'ka'a u'nae. Mako ana Malia'a Makatala kumate ane hu'a nehae. A'ke'ainaka ani a'mo aipafati laya mako kaya'a hano huno laya mako kayati aole alea Sata afe'yaka Yisasi'a alino atale'nea ane. ");
INSERT INTO ino_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mako a'mo aki'a Yoana'ae Heloti nopi ali'ya kava ve'kamo ane. Ani kava ve'kamo aki'a Kusa'ae mako a'mo aki'a Susana'ae. Mako a'neyaka'ae Yisasi'ae lo'ka'a u'nae. Ani a'neyakamoki Yisasi'ae akaeya ke ne'afea anaka'ae apa'kai'api afenoteti lusiya hu'a hapa'ma'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mako nesu ve a'ne fate fate kumateti e'naya vaya'moki Yisasite e'a mi'ko ali'a atalu nehae. Nehakeno Yisasi'a mako ke avoya kefati inake nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mako ve'kamo'a uno avina ya hoyafi ne'atale. Ataleme ne'vikeno mako avina ya'amo'a kateka asaka hulavi'nike'a vaya'moki a'a kasoki atikeno mako avina'a namamoki e'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mako avina yama'a yafa akofetule asaka hulavi'nikeno hake'nea'maki mopa ho'kano o'male'nea yafe li'a o'malekeno ani avina yana ako vai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mako avina ya'a aufe kahaumo hu'nea yapi atale'nikeno aufe kahau'ae makopi hakete'ana aufe kahau'mo'a ano ati kaekeno haviya hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Haviya hu'nea'maki mako avina alaka'a kanale mopafi asaka hulavi'neno hakeno haiteno nesu yate ne'ya alite'ne. Mako'ke avinamo'a ne'ya'a aliteateka naya mako kaya'a vaya'ai apaiya apaya hano hea ne'ya (100 ne'ya) alite'ne huteno Yisasi'a inake hu'ne “Vaya'moka kakesa hane'ninake'kaena mani hoa ke afeo.” ");
INSERT INTO ino_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nehike'a akaeya ke ne'afea anaka'moki inake hu'a nehae “Ani avoya kemo aepa'a hana'ya huno hane'ne?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Afine'kakeno Yisasi'a inake he “Lapa'kaeya Anumaya Koti kava yakailapatesea yafe ke huno fala'kino hane'nea ke Anumaya Koti'a lapaya hisiketapa afi'naya'maki mi'ko vaya'moki avoya ke'ake afi'nae. Hapapaike'a afi'naya'maki ke aepa'a afi'a ha ole'nae. Ake'naya'maki ake'a alakepa ohu'nae.” ");
INSERT INTO ino_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mani avoya kemo'a aepa'a huno fole aino inake nehe mani avina ya'mo'a Anumaya Koti kekana hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mako kateka asaka hulavi'nea avina ya'mo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti ke afite'a Anumaya Kotiteka apaipa amite'a ali'a lo'kiya o'vai'nisaya'aene nehuno Sata eno ani ke ako alino atale'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yafa mopafi lavi'nea avina ya'mo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti ke afite'a atafa hute'a amuse nehayanaki hafu'ya'a mopafi olavi'nea yafe alike ataleke vaya mai'ne'a aupa kanafi aise afi'a apaipafi male'nakeno mako ano apavataka huke ya apa'kaeyate ne'eana makale'a Anumaya Koti ke ne'atalae. ");
INSERT INTO ino_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mako aufe nofi'mo aepafi lavi'nea avina ya'mo'a ina kava hu'ne. Mako vaya'moki Anumaya Koti ke afite'a ne'vakeno aki'ae aka'ae kana ya'mo'aki ma mopafi amuse ya'mo'aki moni afeno ya alisaya ya'mo'ae ano apati'kaeke'a alaka'a ali o'ateno ne'yama'a fole o'ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Alakepa mopafi lavi'nea avina ya'mo'a nesu yate ne'ya alite'nea kava'mo'a ina kava hu'naya vaya'aife hu'ne. Anumaya Koti ke afite'a ani ke atafa hu'a alaki hu'nakeno apaipamo'a api aino kanale hike'a lo'kiya vai'a mai'ne'a alaka'a aline'ate'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Anumaya Koti ke ne'afea yafe Yisasi'a inake huno apafine'ke “Vaya'moki ata kani ate'a samoleti ai'a ati'ka no'malae. Mako hipakapaka kani ate'a no'malaya'maki ata kani ate'a hipa amekake male'nake'a ani nopi hai'aya vaya'moki ani ata kanite'ke e'a ne'akae. ");
INSERT INTO ino_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ani kava huno mi'ko fala'ki'nisea ya'mo'a henaka'a eteno fole aike. Vaya'moki mi'ko kesi kava nehaya kavana henaka'a fole aisike'a vaya'moki akekae. ");
INSERT INTO ino_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ina kava hisea yafe lapa'kaeya maitapa halove hu'netapao Anumaya Koti ke afitapa alakepa heo. Mako ve'kamo'a mako ke afi'niseana Anumaya Koti'a mako ke'ae ani ve'ka amikea'maki ‘Hai afi'noe.’ huno akesa afi'nea ve'ka Anumaya Koti'a ‘Hai afi'noe.’ hu'nea ya'a alino hafalekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ani kanalena Yisasi ita'amo'ae akana'amoki'ae Yisasi akekefe e'nayanaki nesu ve a'nemoki akaeyate ali'a atalu hu'ne'a mai'a kilipa'naya yafe Yisasi mai'neate visaya ka'api o'maleke'a ame'ale o'u'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O'u'a mai'nake'a mako vaya'moki inake hu'a Yisasife ha'nepaiye “Ita'kamo'ae kakana'kamoki'ae e'a kumateka mai'ne'a kakekefe nehae.” hu'a ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ha'nepaikeno Yisasi'a inake huno ke anona'apile nehe “Vaya'moki Anumaya Koti ke afi'a a'kame nehaya vaya apa'kaeya'ke ita'nimoki nakana'nimoki mai'nae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yisasi'ae akaeya ke ne'afea anaka'ae lipi kalefi hai'a maite'a Yisasi'a inake huno hapapai'ne “Umakaya aupalika li aki'naleka viketao.” huno hike'a anileka ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ani lipi kalefi ne'vikeno Yisasi'a au'kala kala hikeno au'kaleno mai'nikeno lo'kiya yasimo'a lusiya huno ne'alikeno ani lipi kalefina li'mo'a haino havaitesea kava nehuno ano apati'kakefe hike'a ani lipi falisaya kava hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ina kava hea yafe Yisasi'a au'kaleno mai'neapi u'a auna nehe'a “Kava Nenao Kava Nenao mafi li na'kaiteta ako falisuna kava nehune.” hu'a hakeno Yisasi'a hetino li'ae yasi'aefe lo'kiya kefati ke anama'kino inake he “Laka'netana mai'ao.” huno hike'ana li'ae yasimo'ae ke'a afite'ana kanake ohu'ana laka ne'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Li'mo'a kanake ohuno vase huno maikeno Yisasi'a akaeya ke ne'afea anaka'aife inake he “Nakaeyafe afitapa lapaipafi male'naya yana hanate atale'nae?” huno hike'a koli nehu'a apamo'yo ne'ai'a inake hu'a nehae “Ma ve'ka nala'akino li'ae yasi'ae ke hanapaike'ana akaeya ke afi'ana a'kame neha'ae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Henaka'a Kalili li kotu'mo mukakaya falika hane'nea kumate Kelasa vaya mai'nayateka u'a va'yi hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisasi'a lipi kalefati ataleno li aki'naleka ne'vikeno ani ala kumate ve'ka akaeyate eno va'yi hu'ne. Mako Sata afe'yaka akaeya aipafi mai'naya ve'kakeno yatala afina kena ohavaino nopi ohavano vaya ki ne'apataya yapakake ne'maiya ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ani ve'ka ne'ekeno Yisasi'a aepa heno Sata afefe inake nehe “Ani aneki ve'kafati ako atale'ka uvo.” nehe. Yatala afina ani ve'ka Sata afe'mo'a atafa huno ne'maiya ve'kake'a vaya'moki atafa hu'a aiya ayate seni nofiteti kitete'a ne'ataya'maki ani nofina aino a'kano a'kanu hune'ataleno Sata afe'mo'a vaya o'mai yapaka avaleno ne've. Ani ve'kamo'a Yisasina aketeno mopafi asaka huno Yisasi aiyafi ne'aino ala kekefafati inake he “Yisasika hanale mai'nea Anumaya Koti mafa'nemoka na akufa kava hunatekefe nehane? Vae afa'a nakafu kisea kava hu o'nato.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nehikeno Yisasi'a inake he “Kaki'ka'a nalakae?” hikeno ani ve'kamo'a make he “Naki'ni'a Nesu'ya'mo'nae.” he. Sata afe'yaka nesu yate akaeya aipafi mai'nakeno'ae “Naki'ni'a Nesu'ya'mo'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nehike'a Sata afe'yakamoki lusi ke nehu'a Yisasife inake nehae “Kakaeya hani yapi ata leke leke nehea kumapi lahafaiketa o'vino.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nehake'a mako nesu yate afu anaka anile aise avima'atole ne'ya ne'nake'a ani Sata afe'yakamoki Yisasife inake hu'a lautau nehae “Mika mai'naya afumoki apaipafi hulateketa haino.” hu'a hakeno Yisasi'a ani afumoki apaipafi hupateke'a hai'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sata afe'yaka ani aneki ve'kamo aipafati atale'a afuyakamoki apaipafi fale'a haike'a ani afuyakamoki naku naku lavite lavite haya'ya'moki mako muli kapi lavite'a lipi asaka hu'a aite'a li ne'a apamupate'a fali'a hano hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fali'a hano hake'a ani afu anaka'aite kava yakai'naya vayana ani afuyaka li ne'a apamupate'a falaya ya akete'a apaune he'a u'a ala kumate mai'naya vaya'ae hoyafi mai'naya vaya'ae “Ina kava hiketa laune heta ne'one.” hu'a hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hapapaike'a ani vaya'moki u'a hu'nea yana akekefe Yisasite u'nayana Sata afe aipafati hafaitale'nea ve'kamo'a meni akesa ha'kalo hikeno kena'a havaiteno Yisasi aiya'afi faitopale mai'nike'a akete'a koli nehae. ");
INSERT INTO ino_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Koli nehake'a Yisasi'a hu'nea kava ake'naya vaya'moki “Ina kava huno Sata afe'yaka aipafi mai'nea ve'ka alino kanale hute'ne.” hu'a hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hapapaitake'a mi'ko Kelasa aupalika vaya'moki Yisasife lusi koli haya yafe inake nehae “Lakaeya latale'ka uvo.” hu'a nehae. Nehakeno Yisasi'a apataleno e'neateka ukefe lipi kalefi haino asaka huno ne'maiye. ");
INSERT INTO ino_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ne'maikeno Sata afe aipafati alino atale'nea ve'kamo'a Yisasife inake nehe “Kakaeya'ae u'na lo'ka'na maisufe?” huno afikekeno Yisasi'a inake he “He'e kakaeya no'kalekake u'ka mi'ko Anumaya Koti'a hukate'nea yana u'ke'ka hu'ka vaya'yaka'ka hapapaiyo.” nehe. Hikeno ani ve'kamo'a mi'ko ala ala kuma'ale uneno huno vaya'aina Yisasi'a hute'nea yafe lusiya huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisasina akeva hu'nakeno eteno e'nea yafe mi'ko ve a'nemoki lusi amuse nehu'a hu'a falu fala hune'atae. ");
INSERT INTO ino_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hu'a falu fala hune'atakeno mako ve'ka eno va'yi hu'nea ve'kamo aki'a Yaelasi'ae. Ani ve'ka mako mono note so'ka ve'kakeno eno Yisasi aiyafi ape huno lusi ke nehuno inake he “Amuse'ka nehuki kakaeya nakaeya nopi eno.” huno ke nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ani ve'kamo'a mako'ke a'mafa'ne'ake mai'nea ve'kae. Ani a'mafa'ne'amo kafu'a ayatala'a hano huteno aiyalekati aole alea kafu (12 kafu) hane'nea a'mafa'ne ako falikefe nehe. Ani yafe “No'ni'afi eno.” huno afike afike nehikeno Yisasi'a anileka ne'vike'a nesu ve a'nemoki a'kame u'a mai'a veko hutakeno folaka'apifi mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ani vayapi ne'vikeno mako a'mo'a ayatala'a hano huteno aiyalekati aole alea kafu (12 kafu) mi'ko afina aiku nopakake maike maike huno ne'maiya anake'a ma mopafi Tota vaya'moki ani kali'a ha'ma'a ali'a kanale hu o'atanine. ");
INSERT INTO ino_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ani a'mo'a Yisasi a'kamelekati eno kena atupa'ale ame'ko ne'alikeno kola'amo'a lanekeno kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lanekeno Yisasi'a inake he “Nala'a kena'nilena ame'ko ale?” huno apafine'keke'a mi'ko anile mai'naya vaya'moki hu'a “Lakaeya ina kava ohu'none.” hu'a hakeno Pita'a inake he “Ala Nenao nesu vaya'moki kaulaka ka'kamelaka a'kalo a'kalo hu'a mai'naya'maki na'ya hike'ka ani ke apafine'kane?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nehikeno Yisasi'a inake he “Lamake mako ve'kamo'a kena'nile ame'ko ne'alike'na nakaeya male'na akoana name'ko ne'alikeno mako lo'kiya'ni nataleno vike'nae nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nehikeno ani a'mo'a ina akesa afi'ne “Fala'kikefe hoanaki Yisasi'a ako afi'ne.” huno akesa afiteno ani a'mo'a atali nehuno eno Yisasi aiyafi ape huno ale'ya alo a'neno mi'ko ve a'nemoki apaulakale huno fole ne'aino “Ina kava ne'nahaiya a'maki meni Yisasi kenale ame'ko ne'alukeno ani kali'ni'a makale'a hano hunate'ne.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hapa'nepaikeno Yisasi'a ke anona'ale inake he “Mafa'ne'nimoka nakaeyafe afi'ka kaipafi male'nana ya'kamo'a meni kali'ka ako alino kanale hukateki kaipa falu yapati no'kaleka uvo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ani ke nehikeno mako ve'ka ala so'ka ve'kamo notekati eno inake nehe “A'mafa'ne'ka ako fali'niki alino apaya nehea ve'ka alaka haesea akufa ke mako'ae afio'ke'ka atalo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nehikeno Yisasi'a ani hea ke ako afiteno inake nehe “Kakaeya koli ohu'ka nakaeyafe afi'ka kaipafi malo. Afi'ka kaipafi malesanana a'mafa'ne'ka ako fali'neapati eteno hetike.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yisasi'a ani ala so'ka ve'kamo nopi haiteno mi'ko vaya'aife inake nehe “Haita o'meo.” huteno Pita'ae Yoni'ae Yemisi'ae ani a'mafa'nemo ita afo'ala'mokani'ae ani nopi apavaleno hai'ne. ");
INSERT INTO ino_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Haitake'a mi'ko ve a'nemoki ani a'mafa'ne fali'nea yafe lusi avi le'a mai'nakeno Yisasi'a inake huno hapa'nepaiye “Lapa'kaeya avi oletapa mani a'mafa'ne alaki ofali'nifa afa'a havano mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inake huno hapapaike'a ani ve a'nemoki ako falike'a ake'naya yafe “Afa'a havano mai'ne.” huno hea ke lusiya hu'a kiki'a hute'nae. ");
INSERT INTO ino_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kiki'a nehakeno Yisasi'a ani fali'nea a'mafa'nemo ayate ne'alino inake he “A'mafa'nemoka kakaeya heteo.” ");
INSERT INTO ino_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Heteo huno ke nehikeno ani a'mafa'nemo aku mafa'ne'a eteno akaeyate ekeno makale'a heti'ne. Hetikeno Yisasi'a inake huno hapapai'ne “Lapa'kaeya ne'ya mani a'mafa'ne amikeno neno.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ani a'mafa'nemo ita afo'ala'mokani ani ya ne'ake'ana lusiya hu'ana atali atalu neha'ae. Neha'akeno Yisasi'a lo'kiya kefati inake huno hanapaiye “Lana'kaeya mani yafe mako ve'ka ha'opai'ao.” huno lo'kiya ke nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisasi'a ayatala'a hano huno aiyalekati aole alea vayafe ke hike'a akaeyate akeno lo'kiya'a apami'ne. Mi'ko Sata afe'yaka vaya apaipafati hapafai ne'atale'a kali'api ali'a kanale hupatesaya lo'kiya'ae apami'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Apamiteno Anumaya Koti'a kava yakaipatesea ke hapa'nepai'a kali vaya kali'api ali'a kanale hupatesaya yafe Yisasi'a ali'yate hupateke'a u'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne'vakeno make huno hapapai'ne “Ne'utapaena ka uteta hisaya yatapi ayomepa kayotapi'ae kutapi'ae mayatapi'ae monitapi'ae ali'netapa o'veo. Mako'ke'ake lapa'kufale havai ya ali'netapa veo. ");
INSERT INTO ino_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Alu nopi nopi havalitata oheo. Mako ve'kamo nopi haitapaena alaki ani nopi'ke havaetetapa henaka'a ataletapa alu kumateka veo. ");
INSERT INTO ino_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mako kumate visake'aena ani kumate vaya'moki ali'a falu fala hu olapate'a lapavele'a no'apifi ali'a alakepa hu olapatesaketapaena ani kumana ne'ataletapa ‘Havi kava hulate'nae.’ nehisake'a afisaya yafe lapaiyale kama'nisea mumusopa aitapa fopo hu ne'ataletapa veo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Inake huno hapapaike'a mi'ko kumate kumate Anumaya Koti kanale ke hapapai'a u'e'a nehu'a mi'ko aupalika kali vayana ali'a kanale hupate'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Heloti'a Kalili ala kava ve'kamo'a mi'ko Yisasi'a hu'nea kava'mo avake'a afi'ne. Afike'a mako vaya'moki ani kava akete'a “Yoni'a fali'nea ve'ka ako fali'neapati eteno heti'ne.” hu'a nehake'a mako'amoki “Ilaiya'a eteno fole ai'ne.” nehake'a mako'amoki “A'ke'ainaka mai'nea Anumaya Koti aune ve'ka fali'neapati eteno heti'ne.” hu'a nehakeno Heloti'a ani ke afiteno aipa akesamo'a anile u'nikeno “Hana vaya'moki lamake ke nehae?” huno akesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heloti'a inake he “Nakaeya ali'ya vaya'ni'a hupatoke'a Yonina liko'a ako he'a hataka hutalakeno ako falike'a kite'naya'maki ani avake nehaya ve'ka nala'ae?” huteno Yisasina akekefe nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yisasi ke ne'afikeno hupateke'a u'naya vaya ete'a e'a Yisasife “Ina akufa kava huta ali'ya alune.” hu'a mi'ko ke ha'nepaiye. Yisasi'a apa'kai'apike apavaleteno Petasaita kumate ukefe kateka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","U'nike'a ani ali'a atalu hu'naya ve a'neyakamoki afite'a Yisasina a'kame hafai'a u'a ne'akakeno Yisasi'a apa'keteno huno falu fala hupateteno Anumaya Koti kava yakaipatesea ke hapa'nepaino kali'api hane'nea vayana kali'api alino kanale hune'apate. ");
INSERT INTO ino_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Une alea'aleka ayatala'a hano huteno aiyalekati aole alea anaka'amoki akaeyate emale'a make hae “Ma mai'nona aupalika vaya alaki o'mai kote mai'nona yafe ma mi'ko ve a'ne hupateke'a mika hane'nea kuma'yakale u'e'a hu'a hava'ne'a ne'ya'api kahau a'a nesae.” hu'a Yisasina ha'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ha'nepaikeno Yisasi'a make huno hapapai'ne “Lapa'kaeya lapa'kaitapike ne'ya apamike'a neo.” huno hike'a inake hae “Lakaeya ne'yana ho'kata o'ali'nopa laya mako kaya kai hame'ya maya alite aole'ko fayatala alite hu'nona'maki mani mi'ko vaya'kefamoki ne'yana lakaeyafe'ke ‘Ne'ya miya hetetapa apameo.’ hu'ka kakesa ne'afipe?” ");
INSERT INTO ino_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Anile mai'naya vaya'yaka o'afunama'a vaya faefu tauseni ve (5,000 ve) mai'nae. Mai'naya'maki Yisasi'a akaeya ke ne'afea anaka'amokife inake huno hapapai'ne “Utapa hapapaike'a aole ve'kala'mokani anaiya anaya hano huno mako'ke ve'kamo ayatalama'a hano hisea vaya alitapa atalu hute hute hutapa ‘Maiyo.’ hutapa hapapaike'a maiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yisasi ke ne'afea anaka'moki u'a ani ke hu'a hapapaike'a ani kava hu'a mi'ko vaya faitopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yisasi'a mani naya mako kaya kai hame'ya maya'ae aole fayatala'ae aliteno ko'ku'napaka aulu he'neno Anumayamoteka ke huno amuse huteteno mani kai hame'ya alino a'kaya heteno akaeya ke ne'afea anaka apamike'a alilitata hu'a mi'ko ve a'ne apami'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mi'ko ve a'neyaka ako ne'a apamu hute'a mako neke'a atalaya atupa atapa ali'a anupa hu'a nayatala'a hano huno naiyalekati aole alea kupi ai'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mako afina Yisasi'a akai'ake Afo'amoteka ke huno afine'keke'a akaeya ke ne'afea anaka anile lo'ka'a mai'nae. Yisasi'a mako ke huno apafine'ke “Ve a'nemoki nakaeyafe nala'a mai'ne hu'a nehae?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Apafikeke'a make hu'a ke anona'ale nehae “Makoma'amoki kakaeyafe ‘Yoni li fale ne'apatea ve'ka mai'ne.’ nehake'a mako'amoki ‘Ilaiya mai'ne.’ hu'a nehake'a mako'amoki ‘A'ke'ainaka Anumaya Koti aune ve'ka fali'neapati meni ako hetino eno mai'ne.’ nehae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nehakeno “Lapa'kaeyatapi nakaeyafe nalaka mai'nane hutapa nehae?” huno nehikeno makale'a Pita'a inake he “Kakaeya Kalaisika Anumaya Koti'a lakufa alino katikefe hukate'nea ve'ka mai'nane.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Hapaitekeno Yisasi'a lo'kiya ke nehuno inake he “Mani ke alaki mako vayana hapa'opaiyo.” huno apa'kesa ali'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yisasi'a make hu'ne “Ala ala vaya'ae mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'nae apa'kame'ya namite'a nahaesake'na lusiya huno nakafu kisea ya alite'na falikauva'maki kinate'nisake'na aole kana kelifi maite'na aole'ae mako'ae alisea kanafi ete'na fali'nisoapati hetikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yisasi'a mi'ko akaeya ke ne'afea anaka'aife make huno hapapai'ne “Mako ve'kamo'a nakaeya na'kame malesuno'aena akai'a akufae amuse hisea akesa o'afino mi'ko afina nakaeya nakufa nakafu kisike'na falisoa kava hisea akesa afiteno yofo yosa'a aki'nale kofi'neno nakaeya na'kame eno. ");
INSERT INTO ino_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mako ve'kamo'a avamu'a hane'nisikeno mai ya'a atafa huno alaki hulino maiseana ani avamu'a hano huke. Hano hukea'maki mako ve'kamo'a nakaeyafe afiteno avamu'a hane'nisikeno mai ya'a ataleseana ani avamu'ae kanale huno mai ya'ae alino katisikeno akola maike maike huno maike. ");
INSERT INTO ino_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mako ve'kamo'a nesu afeno ya male'neno henaka'a falisikeno akola maike maike hisea avamu'a o'maleseana hana ya huno mani ali'nea afeno ya'mo'a ha'makaiye? He'e ha'o'makaiye. ");
INSERT INTO ino_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mako ve'kamo'a nakaeya'ae ke'ni'aefe avuya hiseana ani kava hu'na akaeyafe navuya hutekauve. Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na esoa afina ano hale himamu lo'kiya ya'ni'ae Afo'nimo ano hale himamu lo'kiya ya'ae hao'otake kava ohu'a fate akufa ko'ku'napi kayo kayo anaka'amoki'ae ete'na esoa afina ani kava hu'na ani ve'kaena navuya hutekauve. ");
INSERT INTO ino_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lamake lahapauve manifi mai'naya vayapatina mako'amoki ofali'a afa'a mai'nisakeno Anumaya Koti kava yakaipatesea kana fole aisike'a akekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ani ke huno avayateno naya mako kaya'a hano huno naya mako kayati aole'ae mako'ae alea kana (8 kana) maite'a Yisasi'a Pita'ae Yoni'ae Yemisi'ae apavaleteno Anumayamoteka ke huno afikekefe hike'a mako avimapi hai'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hai'nakeno Yisasi'a Anumayamoteka ke huno afine'kekeno aukosamo'a alino fate akufa kava nehuno ku'kena'amo'a alino yave yave'ake huno alave alave hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Alave alave nehikeno akekeo aole ve'kala a'ke'ainaka fali'na'a ve'kala Mosese'ae Ilaiya'ae ano hale ya'ae mai'ne'ana Yisasi'ae kake nehae. Anumaya Koti'a a'ke'ainaka Yisasina “Ina akufa kava hu'ka falikane.” huno hutekeno e'nea ke Yelusalemu uno falino ma mopa ataleno haisea ke nehae. ");
INSERT INTO ino_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kake nehake'a Pita'ae vaya'amokani'ae apau kale'nae. Apau kale'nayapati makale hetimale'a apaulaka ake'a aya'ke'a akayana Yisasi'a ano hale ya'a'ae mai'nike'a akete'a lo'ka'ana mai'na'a ve'kala'ae ana'ke'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yisasi'ae lo'ka'ana mai'na'a ve'kalana ako Yisasina atale'ana ukefe neha'akeno Pita'a Yisasife inake he “Kava Nenao male mauna ya'mo'a kanale kava heanaketa aole'ae mako'ae amoke no kisune. Mako nona kakaeya'kaki mako nona Mosese'aki mako nona Ilaiya'aki huta kilapatesune.” huno hu'nea'maki Pita'a afino alakepa ohu ke hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ani ke nehikeno mako hiya'mo'a eno aino ati'kapate'neapati Mosese'aki Ilaiya'aki ani hiyapi fala'ake'a Pita'ae vaya'amokani'ae lusi koli hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Koli nehakeno ani hiyapati mako ake ne'aino inake he “Ma ve'ka nakai'ni mafa'ne. Akaeyafe hapalite'noa ve'kaki lapa'kaeya ke'a afeo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ani ke ako huno avaya ne'aeyana aole ve'kalana ako uta'akeno Yisasi'a akai'ake hetino mai'nike'a ake'naya'maki ake'naya kavafe mako kano alaki lamake hu'a ha'opai'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Havate'a koteateka Pita'ae Yoni'ae Yemisi'ae avimana atale'a lavike'a mako nesu ve a'ne'moki Yisasina akekefe ne'ae. ");
INSERT INTO ino_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ani ve a'nemoki folakapati mako ve'kamo'a ala kefati make he “Vae ali'ka apaya nehana kanomoka kakaeyafe ke hu'na kafine'koki ma mako'ke mafa'neto'ni mai'niki kahau huto. ");
INSERT INTO ino_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Akekeo nesu afina mako Sata afe'mo'a ani mafa'ne'ni atafa nehikeno makale lusiya huno kalafa ne'kaekeno ani Sata afe'mo'a lusiya huno avaleno akofe aike yahae huke nehikeno avayafati yave yave avaitu'na ano valino ne'atalekeno akufa akafa alino haviya nehuno makale'a ataleno o'visea akufa kava nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nehike'na kakaeya ke ne'afea anaka'aife ‘Etapa Sata afe aipafati alitapa ataleo.’ hu'na apafike apafike hu'noa'maki ani Sata afe ali'a atalesaya lo'kiya'api o'male'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nehikeno Yisasi'a inake he “Lapa'kaeya meni ma kanafi mai'naya ve a'nemokitapa nakaeyafe afitapa lapaipafi no'malakeno lapaipamo'a kanale nohe. Na'maki afina lapa'kaeya'ae mai'ne'na kana yatapi alike alike hu'na maikoe? Nakaeya alaka ne'nahaiye.” huteno ani mafa'nemo afo'amofe inake nehe “Mafa'ne'ka avale'ka eno.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nehikeno ani mafa'ne'a saufa avaleno ne'ekeno ani Sata afe'mo'a avaleno yaka hune'ataleno aike amakike hune'ate. Haviya hune'atekeno Yisasi'a ani Sata afefe ke ne'ama'kino “Mani mafa'nemo aipafati hatilavi'ka laveo.” nehikeno ani mafa'nemo aipafati ataleno utekeno ani mafa'ne alino kanale huteteno eteno afo'amona avaleno ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mi'ko ve a'nemoki Anumaya Koti lo'kiya'a akete'a lusiya hu'a hapau haleke'a ne'mai'a “Vae fate akufa ya akone.” hu'a apamo'yo ai'nae. Yisasi'a ani kava hu'nea yafe lusiya hu'a apa'kesa afifi nehakeno Yisasi'a akaeya ke ne'afea anaka'ae make huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lapa'kesa maletapa nehoa ke afeo. Aupa kanafi ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka navale'a havi vaya'ai apayapi natekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nehea'maki ani kemo aepa'a ako fala'kike'a afi'a ha ole'a anile ke hu'a afikekefe hu'naya'maki koli hute'a ke hu'a afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yisasi ke ne'afea anaka'moki apa'kai'api ke ne'vai'a “Folakatifi nala'a ala ve'ka mai'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nehakeno Yisasi'a ani akufa apaipa apa'kesa afi'naya ke apaipafi ako apa'keteno mako aise mafa'neto avale'neno haute hetite'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ate'neno Yisasi'a make huno hapapai'ne “Mako ve'kamo'a nakaeyafe akesa ne'afino ma aise mafa'neto ha'maeseana nakaeya'ae naha'ne'maiye. Inaki nakaeya naha'maesea ve'kamo'a hunateke'na e'noa kano'ae ha'ne'maiye. Lapa'kaeya folakatapifi mako ve'kamo'a aise mafa'nekana huno maiseana ani ve'ka alatapi mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hikeno Yoni'a inake he “Kava Nenao mako ve'kamo'a ake'nonakeno kakaeya kakileti Sata afe vaya'moki apaipafati alino ne'ataleketa akona'maki la'kame o'me'nea yafe ‘Ina akufa ali'ya mako'ae o'aleo.’ huta hapai'none.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nehikeno Yisasi'a make huno hapai'ne “Lapa'kaeya ani ve'kamo alisea ali'yafena ‘Ina akufa ali'ya o'aleo.’ hutapa ka a'kani o'apateo. Lapa'kaeya kame ya hu olapatesea ve'ka lapa'kaeya vayatapi mai'ne.” ");
INSERT INTO ino_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yisasi'a eteno ko'ku'napi haisea kana'amo'a eno aupasi nehikeno Yelusalemu visea yafe lusi lo'kiya akesa afi'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akesa afiteno mako vaya'moki ali'a avatati hisaya yafe hokoteno hupateke'a Samelia kumate u'a hai'a inake hu'a nehae “Yisasi no alita avatati heo.” huno hu'nea ke hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nehake'a ani kumate vaya'moki Yisasi'a Yelusalemu ukefe nehe hute'a Yisasina hu'a falu fala hu o'ate'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hu'a falu fala hu o'atake'ana akaeya ke ne'afi'a kanola Yemisi'ae Yoni'ae ani kava haya kava akete'ana Yisasife make hu'ana afike'na'ae “Ala Nenao kakaeya hana kakesa ne'afine? Ke hisu'akeno ko'ku'napakati ata atalesikeno atamo'a elineno leno mani vaya'yaka apasakalise hu'ka nehape?” ");
INSERT INTO ino_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Hu'ana neha'akeno Yisasi'a maino yahae huno ne'ana'keno “Ani kava ohi'ao.” huno ke hanauteke'a ani kumana ne'atale'a mako alu kumate u'nae. ");
INSERT INTO ino_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kateka ne'vakeno mako ve'kamo'a Yisasife make huno hapai'ne “Mi'ko u'ke'ka hisana kumatena kakaeya'ae lo'ka'na ka'kame u'ne'na hukoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nehikeno Yisasi'a inake huno hapai'ne “Afela kalayakamoki hamai kapi nehavake'a namayakamoki havae no'api hane'nea'maki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nakenopa nafita aimale'na havaesoa no'ni o'male'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yisasi'a mako ve'kae inake huno hapai'ne “Kakaeya na'kame eno.” huno nehikeno ani ve'kamo'a make he “Kanale afo'nimo'a falitesike'na ali'na kitete'na henaka'a ka'kame ekauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nehikeno Yisasi'a inake huno hapai'ne “He'e nakaeya ke o'afi'a maikeno apa'ku apame fali'nea vaya'moki apa'kai'api yanake'a falisaya vayana ali'a kipatekaki kakaeya u'ka Anumaya Koti vaya'aina yakaipatesea kanale ke mi'ko vaya'aina u'ka hapapaiyo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nehikeno mako fate ve'kamo'a Yisasife inake huno ha'nepaiye “Ala Nenao nakaeya ka'kame ukefe nehoa'maki kanalenake'na nakaeya u'na vaya'ni ali'na falu fala hupatete'na ka'kame hisoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nehikeno Yisasi'a make huno hapai'ne “Mako ve'kamo'a avina ya ha'kalekefe nehea'maki mi'ko afina a'kameleka eteno aulu heno ne'akeanakeno ani ve'kaena Anumaya Koti'a ‘Nakaeya ali'ya ali'ka vaya'aite nakaeya kava yakaipatesoa ke hapapaiyo.’ huno hu o'atekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","2","Anumayamo'a mako'ae 72 vaya hapaliteno “Nakaeya ke hisaya vaya maiyo.” huteno aole alino lo'kapatete lo'kapatete huteno “Nakaeya visoa aise kumate'ae ala kumate'ae utapa hokotetapa ne'veo.” huno hune'apateno apa'kaeyafe inake huno hapapai'ne “Hoya'nifina lusiya huno ne'ya'mo'a keteteno hane'nea'maki ali'ya vayana ho'ka'a o'mai'nae. O'mai'nayanaki lapa'kaeya lusiya hutapa hoyamo afo'amoteka ke hikeno ali'ya vaya'a hupatesike'a e'a hoya'afati ne'yana ali'a anupa hutesae.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lapa'kaeya veo. Ne'utapa afeo lapa'kaeya mako sipi sipi afu ana'aukana hutapa mai'nake'na afela kalakana nehu'a apa'kame'ya nami'naya vaya'ai folakapi nakaeya hulapatoketapa ukae. ");
INSERT INTO ino_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ukefe monitapi'ae kutapi'ae lapaiya ano'ae ali'netapa o'veo. Kateka vaya'aife hutapa falu fala hupatekaya'maki yatala kana mai'netapa kake oheo. ");
INSERT INTO ino_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Inaki lapa'kaeya mako nopi haitapa falekefe nehutapaena hokote yana make hutapa heo “Ma nopi mai'naya ve a'neyaka Anumayamo'a lapaya nehinakeno lapaipamo'a falu hino.” hutapa heo. ");
INSERT INTO ino_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hisakeno ani nopi mako aipa falu ve'ka mai'niseana ani apami'naya aipa akesa falu ya'mo'a ani ve'kamo'ae lo'kano maike. Maikea'maki mako ani akufa ve'ka ani nopi o'mai'niseana ani apami'naya falu ya'mo'a eteno lapa'kaeyatapi alikae. ");
INSERT INTO ino_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ani utapa mai'nisaya nopi'ke mai'nisake'a ali'ya ve'kamo'a ani ali'ya ali'nea yapati anona'a alisea yafe ne'ya lapamike li lapamike hisaya yana afa'a neo. Alu nopaka havalitata oheo. ");
INSERT INTO ino_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mako ala no kumate ne'visake'a vaya'moki hu'a falu fala hunelapate'a lapavale'a no'apifaka u'a ne'ya fa'ko hu'a lapamisaya ne'yana afa'a neo. ");
INSERT INTO ino_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ani kumate mako kali vaya mai'nisayana ani kali'api alitapa kanale hupateo. Hune'apatetapa make hutapa hapapaiyo “Anumaya Koti'a kava alino yakailapatesea kana'a ako aupasi nehe.” hutapa hapapaiyo. ");
INSERT INTO ino_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Inaki mako ala kumapi haitapa falesake'a mako vaya'moki e'a lapavale'a no'apifaka o'visaketapaena ani kuma'mo ka folakapi heti'netapa make hutapa heo “Havi kava haya yafe ma kumate mumusopamo'a eno laiyale a'kamaeya'maki lakaeya mani mumusopa alita fopo hutalekaune.” nehutapa inake heo “Laiyafati alita fopo hutalekauna'maki lapa'kaeya afitapa alakepa heo Anumaya Koti'a kava alino yakailapatesea kanamo'a ako aupasi nehe.” ");
INSERT INTO ino_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Meni nakaeya lahapa'nepauve Anumaya Koti'a mi'ko ve a'ne apavaleno kake hupatesea afina Sotomu kumate vaya'moki alisaya apa'kafu yana aise alikaya'maki lapa'kaeya lapavale'a no'apifaka o'visaya kumate vaya'moki Sotomu kumate vaya'moki alisaya yana apa'kasekae huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Avo'neo Kolasini'ae Petasaita'ae mai'naya vaya'mokitapaena lusiya hu'na nahau nehoe. Nakaeya lapa'kaeya kumate mai'ne'na o'ake'naya lo'kiya avame ya ako hu'noanaki lapaipa aitapa yahae ohutapa hao'otake yatapi o'atale'naya'maki Taiyaka'ae Saitoni kumatalate ani o'ake'naya lo'kiya avame ya mako ve'kamo'a alo huno apavelininana havi kava nehaya yafe hapau nehu'a la'nefafi kasepu ne'ai'a apaipa ai'a yahae hinine. ");
INSERT INTO ino_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anumaya Koti'a mi'ko ve a'ne apavaleno kake hupatesea afina Taiya vaya'ae Saitoni vaya'ae aise kana ya alikaya'maki Kolasini'ae Petasaita'ae mai'naya vaya'mokitapa ala kana ya alitapa apa'kasekae. ");
INSERT INTO ino_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lapa'kaeya Kapaneamu kumate vayana lapa'kufa alitapa ‘Ko'ku'napi haikune.’ hutapa nehafe? He'e ina kava ohukaki ata leke leke nehea kumapi afepakake lavikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Akaeya ke ne'afea anaka'ae inake huno hapapai'ne “Lapa'kaeya ke afisea ve'ka nakaeya ke'ae ne'afea'maki lapa'kaeya a'kame'ya lapamisea ve'kamo'a ani kava huno nakaeya'ae a'kame'ya ne'name. Inaki nakaeya a'kame'ya namisea ve'kamo'a ani kava huno nakaeya hunateke'na e'noa ve'ka'ae a'kame'ya ne'ame.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hupateke'a ute'a e'naya vayana aole'ae mako'ae vaya'moki apaiya apaya hano huteno mako ve'kamo ayatala'a hano huno mako aiyalekati aole alea vayana (72 vaya) amuse nehu'a ete'a e'naya vaya'moki inake nehae “Anumayamoka lakaeya kakaeya kakileti Sata afe'yaka hapa'nefaunake'a lakaeya ke afi'a a'kame male'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nehakeno Yisasi'a apa'kaeyafe inake nehe “Nakaeya akoana Sata'a ko'ku'napakati kopasi'namo nehea kava huno makale asaka hulavino elineke'na akoe. ");
INSERT INTO ino_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Afeo nakaeya lo'kiya ako lapami'noe. Mako ya'mo'a lapa'kaeya alino haviya hu olapatekaiye. Sata lo'kiya hatapa akasesaya lo'kiya ako lapami'noe. Vaya hapaeke'a nefalea osifa've'ae heki'yave'ae lapaiyaleti atapa ati'kakayanaki nakaeya lo'kiya ako lapami'noa yafe olahapakaiye. Olahapakaiyanakeno mako ya'mo'a lapa'kaeya alino haviya hu olapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Haviya hu olapatekaiya'maki Sata afe'yaka apa'kasesaya lo'kiya lapami'noa yafe amuse ohutapa Anumaya Koti'a lapa'ki ko'ku'napi kamale'nea yafe'ke lusi amuse heo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ani afina Fate Akufa Avamu'amo'a lusiya huno amuse hisea aipa akesa ami'nikeno Yisasi'a amuse nehuno inake nehe “Afo'nimoka mi'ko mopale ya'ae ko'ku'napi ya'ae kava yakai'nana Anumayamoka kanale kava nehane. Mako vaya'moki ‘Mi'ko ya afi'nona vaya mai'none.’ hu'a haya vaya'moki ‘O'afisae.’ nehu'ka nakaeya mani hapapai'noa ke fala'ki male'nananaki ‘Inamu mafa'ne mai'none.’ hu'a haya vaya ako hu'ka fole ai'ka apaveli'nana yafe lusiya hu'na amuse'ka nehoe. He Afo'nimoka kakaeya kaipa kakesamo'a ina kava hu'nike'ka ani kava hu'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Anile ali'a atalu hu'naya vaya'aife inake hu'ne “Afo'nimo'a mi'ko lo'kiya yana ako nami'ne. Nakaeya ve mafa'ne'amo'na aepa'a'ni mi'ko vaya'moki o'afi'nayanaki Afo'nimo'a akai'ake nakaeya aepa'a'ni afi'ne. Afi'nea'maki mi'ko vaya'moki Afo'nimo ne'maiya aepa'a o'afi'nake'na nakai'ni mafa'ne'amo'nake afi'noanake'a nakaeya nahaisea vaya'aina hu'na apavelisuke'a Afo'nimo aepa'a afikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Akaeya ke ne'afea anaka'ae Yisasi'ae apaote mai'ne'a Yisasi'a inake huno hapapai'ne “Anumaya Koti'a lusi kanale ya lapaulakale fole aiketapa ne'akaya yafe lusi amuse hutapa maiyo. ");
INSERT INTO ino_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lahapa'nepauki mi'ko a'ke'ainaka mai'naya aune vaya'ae ala yahauve vaya'moki'ae lapa'kaeya ne'akaya ya ‘Akesune.’ hu'a hu'naya'maki o'ake'nae. Lapa'kaeya ne'afea ke ‘Afisune.’ hu'a hu'naya'maki o'afi'nae.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mako mono ke hapa'nepaiya ve'kamo'a hetino ake'atike hisea'aene huno Yisasina ano avataka hukefe inake huno afine'ke “Ali'ka apaya nehana Nenao nakaeya hana'ya hu'na akola maike maike hu'na maisoa navamu alisoe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Afine'kekeno Yisasi'a inake he “Anumaya Koti avopina na'yane ke kamale'nae? Kakaeya hapali'nanana ani kemo'a na'yane hu'ne hu'ka aepa'a ne'afine?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Afine'kekeno inake he “Ani kemo'a inake hu'ne ‘Ala Anumaya Koti'kamofe kahau kayamopafati lo'kiya vaino kahaino. Mi'ko kakesa afi ya'ae kaipa kame afisana ya'ae ali'ya ne'alina lo'kiya'ae Anumaya Koti ameo. Kakesa ne'afina ya'ka ameo. Kakai'ka kakufae ne'kahaiya ya hu'ka ani kava hu'ka mi'ko vaya'ai apa'kufae kahaino.’ huno hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nehikeno Yisasi'a inake he “Kakaeya hana ke lamake hananaki mi'ko afina ani kava huke huke hisanana maike maike hisana kavamu alikane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nehikeno ani ve'kamo'a akesafi ina akesa ne'afe “Yisasi'a nakaeyafe ‘Kanale kakesa afi'nana ve'ka mai'nane.’ huno hise.” nehuno ma ke afine'ke “Mi'ko vayana nalakife nehane?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yisasi'a ke anona'ale inake he “Mako Yuta ve'kamo'a Yelusalemu ataleno Yeli'ko ukefe kate ne've. Ne'vike'a mako kumaya vaya'moki kateka akete'a atafa hute'a mi'ko afeno'a ha'nefale'a amaki'a atale'nae. Atale'a u'nakeno falisea kava hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ina kava nehikeno ani afina mako mono nopi kava ve'kamo'a ani kate nelavino ani ve'ka akea'maki mako kaya ka aki'naleka ne'uno akaseno akeme akeme u'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ina kava hikeno mako Yuta ve'ka Livae nofi ve'ka ani kava huno eno akea'maki akaseno mako kaya ka aki'naleka ne'uno akeme akeme u'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ina kava huta'akeno mako kame ve'ka Sameliati ve'ka ani kate ne'eno ani ve'ka aketeno lusi hau hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ani ve'kamo'a haute uno mai'neno mani ve'ka ha'naya yate masave fale ne'ateno nofi alakamo li'ae amaki'naya kayomo kate la'kiteno haya vaiteteno avaleno akai'a to'ki afumo akofetule ateteno avaleno uno mako mi'ko nata vaya miya hu'a nehavaeya nopi uno ateteno lusiya huno kava hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ina kava huteno ko neteana ani no'mo afo'amona aole kina (K2.00) ne'amino inake huno hapai'ne ‘Kakaeya lusiya hu'ka mani ve'ka kava hu'ne'ka mako miya'ka mani ve'kale atalesanana henaka'a nakaeya ete'na atale'nana miya'kale kamikoe.’ hu'ne.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisasi'a ani ke huno hano nehuno inake he “Ina kava hu'naki kakaeya na kakesa ne'afine? Mani aole'ae mako'ae anakapati hana ve'kamo'a amakimale'naya ve'kamo kanapa ve'ka'akana akufa kava hute'ne?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nehikeno ani mono hapa'nepaiya ve'kamo'a inake he “Lusiya huno kalaki aite'nea ve'kamo'a kanapa ve'ka'akana akufa kava hute'ne.” huno hikeno Yisasi'a akaeyafe inake he “Kakaeya'ae u'ka mi'ko afina ani akufa kava ho.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisasi'ae akaeya ke ne'afea anaka'ae ka male'a ne'u'a Yisasi'a mako kumate ne'vikeno mako ana Matae hu'a aki ne'aya a'mo'a Yisasife ke hikeno no'afaka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U'nikeno Malia'a Mata akana'amo'a Yisasi aiyafi eno faitopale mai'neno Yisasi'a hea ke ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne'afikeno anu'kana'amo'a Mata'a mi'ko ne'ya alino avatati hu ali'ya lusi ali'ya alea yafe akesamo'a aole aole nehikeno Yisasite uno inake nehe “Anumayamoka nakana'nimo'a nataleke'na nakai'nike ne'ya ali'na avatati hu ali'yana lusiya hu'na ne'aloa'maki ani yafe kakesa no'afipe? Hapaikeno eno naha'maeno.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nehikeno Yisasi'a inake he “Matao Matao mi'ko yafe kakesamo'a aole aole nehike'ka ali'ya ne'alinana havi kava nehane. ");
INSERT INTO ino_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mako'ke yafe'ke kakesa afifi hu'ka maiyo. Malia'a ani yafe akesa afifi hea yana ako atafa hu'neanakeno ani yana mako ve'kamo'a ha'ofalekaiye.” ");
INSERT INTO ino_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mako afina Yisasi'a mako aupalika mai'neno Anumaya Kotiteka ke huno afikeno mai'nikeno akaeya ke ne'afea anakapati mako ve'kamo'a inake he “Anumayamoka Yoni'a akai'a ke ne'afea anaka'aife huno apaveli'nea kava hu'ka ina kava hutapa Anumayamoteka afikeo hu'ka laveleo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nehikeno Yisasi'a inake nehe “Anumayamoteka afikesune hutapaena inake hutapa heo Afotimoka vaya'moki kaki ali'a asaka nehu'a ‘Fate akufa ve'ka mai'nane.’ hu'a hukatesae. Kava yakaipatesana kana makale fole aise. ");
INSERT INTO ino_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mi'ko afina nesuna ne'ya lameo. ");
INSERT INTO ino_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lakaeya hao'otake kava hulate'naya vaya'ai hao'otake ya'api lahapaone lapatone nehuta laipa falu yapati alita atalepatonanaki kakaeya ani kava hu'ka hao'otake yati lahaove latove nehu'ka kaipa falu yapati ali'ka atalelato. Sata'a ano lavataka lahaisea yapi lavale'ka olato hutapa heo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yisasi'a apa'kaeyafe inake nehe “Hana ve'kamoka hani'ainaka u'ka vaya'kale inake hu'ka hukane ‘Vaya'nimoka aole'ae mako'ae maya yo'ka namikape? ");
INSERT INTO ino_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","7","Mako nata vaya'ni katekati eno va'yi nehike'na nesea ya o'male'noa yafe kanale namisanake'na amikufe?’ hu'ka hisanakeno vaya'kamo'a no'afakati make hisife ‘Kosale nahaeya ke nehanaki natalo. Kita ako kimalete'na mafa'ne'nimoki'ae ako havata mai'nonanake'na heti'na ani nafikana yana ali'na o'kamikoe.’ hukife? ");
INSERT INTO ino_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","He'e nakaeya lahapa'nepauve ‘Vaya'ka mai'noe.’ huno hisea yafe ‘O'kamikoe.’ huno hukea'maki kosale haeya ke afike afike huno hu'nea yafe hetino ani afike'nea ya ako alino amike. ");
INSERT INTO ino_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ani yafe nakaeya lahapa'nepauve Anumaya Kotiteka mako yafe afikesakeno'aena ako lapamike. Mako yafe kahau aesakeno'aena alino ako fole ailapatekaiye. Kipateti ke hisakeno'aena Anumaya Koti'a afiteno kita ako ya'kilapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mi'ko afikesaya vayana alikae. Kahau aesaya vayana ake'a fole aikae. Kipateti ke hisaya vayana kita ya'kipatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hana vekamoka mafa'ne'kamo'a ‘Faya ali'ka nameo.’ huno kafi ne'kesike'kaena afo'amoka anakala ali'ka amikape? He'e ani anakala ali'ka o'amikane. ");
INSERT INTO ino_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","‘Ko'kole amu ali'ka nameo.’ huno kafikesike'kaena heki'yave amikape? He'e ani heki'yave ali'ka o'amikane. ");
INSERT INTO ino_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","O'amikana'maki lapa'kaeya hao'otake vaya'mokitapa mafa'netapi kanale ya ne'apamayanakeno ko'ku'napi mai'nea Afotapimo'a lusiya huno lapa'kase'neanaketapa afikesakeno Fate Akufa Avamu'a lapamike.” ");
INSERT INTO ino_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sata afe mako ve'kamo aipafi haino mai'neno ake ne'aiya ya ali'nikeno ake no'aikeno Yisasi'a ani Sata afe alino ataletetekeno ake no'aiya ve'kamo'a ake ne'aino ke nehike'a mi'ko ve a'nemoki akete'a lusi apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Apamo'yo ne'aiya'maki mako'amoki inake nehae “Akaeya Sata afe'moki kava ve'ka'apimo lo'kiyaleti Pielisepuli lo'kiya'aleti mani afe alino ne'atale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nehake'a mako vaya'moki Yisasina a'a avataka hu'a akekefe inake nehae “Kakaeya ko'ku'napakati o'ake'nona avame hu lo'kiya'ka alo huketa akeno.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nehakeno Yisasi'a afea apaipa apa'kesa ako afiteno inake huno hapapai'ne “Mako ala kumate vaya'moki ali'a fa'ko fa'ka hute'a la hisayana ani kuma'apimo'a haviya hisikeno hano huke. Inaki mako'ke afamo'moki folaka'apifati ali'a fa'ko fa'ka hute'a la hisayana ani afamo anakana haviya hu'a hano hukae. ");
INSERT INTO ino_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sata'a akai'a Sata afe vaya aipafati alino ataleseana akai'a nofi vaya ano fa'ko hisike'a ‘Fate vaya mai'none.’ hu'a hisayana Sata'a kava ne'yakaiya ya'a hana kava huno lo'kiya vaike? He'e lo'kiya o'vaikea'maki nakaeyafe ‘Pielisepuli lo'kiya'a ami'nikeno Sata afe alino ne'atale.’ hutapa nehaya ke lapa'ke'atike ke nehae. ");
INSERT INTO ino_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nakaeyafe ‘Sata afe'yaka'ai kava ve'ka'api Pielisepuli lo'kiya amikeno Sata afe alino atale'ne.’ hutapa hu'naya'maki nakaeya Pielisepuli lo'kiyaleti ali'na ne'ataleninana nala'a hapa'mano lapa'kaeya lapa'kame ne'vaya vaya'moki Sata afe ali'a ne'atalae? Sata'a apa'kaeya apaya nehifi? Ani vaya havi lapa'kesa ne'afea ya hu'a lapavelike. ");
INSERT INTO ino_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lapavelikea'maki nakaeya Anumaya Koti lo'kiyaleti mani Sata afe ali'na ne'ataloe. Ne'ataloa yana lapa'kaeya akeo Anumaya Koti'a kava yakailapatesea ya'a ako eno va'yi huno lahapaupi ako eno hane'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mako lo'kiya ve'kamo'a ati keve'a aliteno kuma'ale kava yakaino alakepa hu'niseana mi'ko ya'amo'a afa'a kanale huno hanekaiye. ");
INSERT INTO ino_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hanekaiya'maki ani ve'kamo lo'kiya akaseno lusi lo'kiya'a hane'nisea ve'kamo'a uno atafa huno nehano mi'ko ame'atiti nehea ati keve sasu'me ko'ne'ae afeno ya'ae alino uteno alino visea ya'ko fa'ko fa'ka huteno vaya'a apamike. ");
INSERT INTO ino_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nakaeya vaya'ni o'mai'nisea ve'ka akaeya kame'ni mai'ne. Sipi sipi afu anaka alino atalu huno naha'o'maesea ve'ka akaeya ani afu anaka hapafaino hapano uno atale eno atale nehea ve'ka mai'ne.” ");
INSERT INTO ino_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sata afe'mo'a mako ve'kamo aipafi haino mai'neapati ataleno u'nea'maki uno maino falu hisea kumafe li o'male yapaka lusi kahau ano uneno nehe. Kahau ano uneno huketeana maisea no'a alaki o'akeno halate eteno ‘Hokote'na maike'noa nopi ete'na visoe.’ huteno ne'e. ");
INSERT INTO ino_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uno akeana ani ve'kamo aipafina ako no'ya alino vaki huno kanale kava humale'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aketeno vea'ya'mo'a naya mako kaya hano huteno naya mako kayati aole alea afe anaka apaveleno e'nea'maki akaeya hao'otake kava nehea kava akase'a mako'ae lusi hao'otake kava nehaya afe anaka apavaleno e'ne. Eke'a ani ve'kamo aipafi hai'a mai'nakeno ani ve'kamo'a hokoteno aise ya'a alino haviya hute'nea'maki meni mako'ae lusi kava hu'a ali'a haviya hute'nae.” ");
INSERT INTO ino_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ani ke nehikeno nesu vaya mai'naya folakapati mako a'mo'a ala kefati inake nehe “Kakaeya alikateteno nu kami'nea a'mo'a amuse huke. Anumaya Koti'a lusi amuse hu'nea ya ami'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yisasi'a inake nehe “Ani a'mo'a amuse hukea'maki Anumaya Koti ke afite'a a'kame ne'malaya vaya'ke Anumaya Koti'a lusi amuse hisaya ya apamike.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nesu vaya'yaka e'a ali'a anupa nehakeno Yisasi'a inake huno hapapai'ne meni kanafi mai'naya ve a'neyaka hao'otake ve a'neyaka'ake mai'netapa “O'ake'nona avame hu lo'kiya'ka laveliketa akeno.” hutapa ke nehaya'maki Anumaya Koti'a mako'ae alu o'ake'naya lo'kiya avame'ya hu yana olapamikea'maki mako'ke'ake avame'ya hu yana a'ke'ainaka mai'nea Anumaya Koti aune ve'ka Yona'a hu'nea avame'ya hu lo'kiya ya'ake huno lapavelisiketapa akekae. ");
INSERT INTO ino_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","A'ke'ainaka Yona'a hu'nea kava'mo'a inake huno hane'ne ala faya'mo'a Yonana asaka huno na'kaitekeno aole'ae mako'ae afina aipafi mai'neana Ninive kumate mai'naya vaya'aife avame kava huno apaveli'neane. Nakaeya ko'ku'napati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na meni afina mai'naya vaya'aipi ani akufa kava hu'na avame hu'na lapavelikoe. ");
INSERT INTO ino_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mako kaya aupalika (sauti) mai'nea ana ala kava ya alino yakai'nea a'mo'a mopa uno atupa he'neatekati eno Solomoni'a akenopafi hale'nea ve'kamo ke afi'neane. Afi'nea'maki akekeo Solomonina akase'nea ve'ka ma mai'nea'maki lapa'kaeya akaeya ke no'afe. Henaka'a Anumaya Koti'a mi'ko vaya kake hupatesea afina ani kava a'mo'a hetino meni afina mai'naya vaya'aife “Havi kava nehae.” huno alino fole ailapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninive kumate mai'naya vaya'moki Yona'a hu'nea ke afite'a apaipa ai'a yahae hu'a hao'otake ya'api atale'naya'maki Yonana akase'nea ve'ka meni male mai'nea'maki lapa'kaeya lapaipa aitapa yahae hutapa hao'otake yatapi o'atale'nae. Ani yafe Anumaya Koti'a mi'ko vaya kake hupatesea afina Ninive kumate vaya'moki heti'a meni afina mai'naya vaya'aife “Havi kava hu'nae.” hu'a ali'a fole ailapatekae. ");
INSERT INTO ino_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Vaya'moki ata kani ate'a no hakaya'mo au'vai'a maleke makalufi maleke nohae. Nohaya'maki ata kani ate'a hipa amekake male'nake'a ani nopi hai'aya vaya'moki ani ata kani e'a ne'akae. ");
INSERT INTO ino_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lapaulakamo'a lapaipafi ano halesea ata kani hane'ne. Lapa'kaeya lapaulaka kanale huno hane'niseana mi'ko lapaipafi ano halekaiya'maki lapa'kaeya lapaulaka haviya hu'niseana mi'ko lapaipafi hani kike. ");
INSERT INTO ino_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ina kava hu yafenaki lapa'kesa afitapa kava heo. Haviku kaku'ainaka ata kani asu he'nisike'ka ‘Ata kanefe ne'aiye.’ hu'ka hu yafenaki kava heo. ");
INSERT INTO ino_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lapa'ku'ainaka ata kani'mo'a mi'ko aupalika ano hale ne'atalesikeno mako'kaya aupalika'atapi hani o'kiseana ata kani'mo'a mi'ko aupalika ano hale ne'atalea avamete ano halekaiye.” ");
INSERT INTO ino_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisasi'a ani ke nehikeno mako Falasi mono ve'kamo'a Yisasife inake nehe “Nakaeya'ae e'ka ne'ya no.” huno ke hikeno Yisasi'a ani Falasi mono ke ne'afea ve'kamo nopi haino mai'neno ne'ya nesea hipale faimai'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Faimai'nikeno Falasi mono ke ne'afea ve'kamo'a akeana Yisasi'a aya sese ohuno ne'ya alino ne'nekeno aketeno akesa afino lapa ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Akesa afino lapa ne'aikeno Yisasi'a akaeyafe inake nehe “Lapa'kaeya Falasi mono ke ne'afea vaya'mokitapa ameka ke ma kava nehae ke'ayo'ae lape'ae sese nehaya'maki lapa'ku'ainaka kumaya kava'mo'ae hao'otake kavatapimo'ae lusiya huno havaite'nea'maki sese nohae. ");
INSERT INTO ino_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lapa'kaeya anekinaki vayana Anumaya Koti'a ameka'atapike alo huteno lapa'ku'ainaka'a alo ohu'niketapae nehafe? ");
INSERT INTO ino_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lape aku'ainaka'a hane'nea yana mako afeno ya'api o'male'nisea vaya apamisakeno lapa'ku'afina honi'ya ofaike. ");
INSERT INTO ino_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Avo'neo. Lapa'kaeya Falasi mono ke ne'afea vayana maitapa halove hu'netapao. Lapa'kaeya atu'ae kife'ae mi'ko aki'ae aka'ae hakomupa'ae aole nayatalapati mako'ke'a fa'ko hutapa Anumaya Kotiteka ne'amaya'maki lapa'kaeya alakepa kava hu ya'ae Anumaya Kotife lahapau lapayamopafati lahapau ya'ae ane'kasae. Hokotetapa alakepa kava nehutapa Anumaya Kotife lahapau lapayamopafati lahapaino. Lahapainaketapa atu'ae kife'ae nayatala'a male'nayapati mako'ke'a Anumaya Koti amisayana kanale huke. ");
INSERT INTO ino_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Avo'neo. Lapa'kaeya Falasi mono ke ne'afea vayana lapa'kaeya maitapa halove hu'netapao. Lapa'kaeya mono nopi mi'ko vaya'moki apaulakale kava vaya ne'maiya yate maisaya yafe lusiya huno nelahapauno lapa'kaeya mi'ko vaya ali'a atalu hu'a ne'maiya kumate utapa mai'nisake'a ve a'nemoki hu'a falu fala hulapatesaya yafe'ke lusiya huno nelahapaiye. ");
INSERT INTO ino_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Avo'neo. Lapa'kaeya maitapa halove hu'netapao. Mako vaya fala'ki'a kipate'nake'a vaya'moki ani keli o'ake'a akotofule u'e'a nehaya akufa kava hutapa lapa'kaeya ani kelikana nehakeno lapaipamo'a honi'ya'ake nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mako mono hapalino hapa'nepaiya ve'kamo'a ani kemo anona'ale inake nehe “Ali'ka laya nehana Nenao kakaeya hana kemo'a lakaeyateka hu'ka aukosa nehanakeno lakaeya lavuya nehea ke nehane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nehikeno Yisasi'a ani ve'kae inake nehe “Lapa'kaeya mono hapalitapa hapa'nepaiya vaya'mokitapae mani ke nehuki afitapa alakepa nehutapa maitapa halove heo. Lapa'kaeya ‘Ke male male'nea ke a'kame maleo.’ nehutapa mi'ko vaya'ai apa'ki'nalena kana ya alitapa kofipatake'a lusi kana ya ali'a ko'nefe. Ko'nefea'maki lapa'kaeya lapaya maletapa mako'ke afina ani kana ya'api alitapa hapa'o'make'a lusi kana'ake ya ali'nae. ");
INSERT INTO ino_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Avo'neo. Lapa'kaeya lapa'kinakomoki mi'ko Anumaya Koti aune vaya hapake'a fali'nake'a ani aune vaya kipate'naya kelile lapa'kaeya konakali hoya alitapa ne'vaiyanaki lapa'kaeya maitapa halove hu'netapao. ");
INSERT INTO ino_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anumaya Koti aune vaya hapate'a kipate'naya kelilena konakali hoya vaimale'naya kava'mo ‘Lakinakomoki kanale kava hu'nae.’ hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ina kava hu'nakeno Anumaya Koti'a kanale aipa akesa'ae ve'kakeno inake hu'ne ‘Nakaeya aune vaya'ni'ae nakaeya ke hapapaisaya yafe hupate'noa vaya'ni'ae apa'kaeyapi ali'ya ali'a ne'visake'a vaya'moki ali'a vekala ne'a'a ali'a haviya hune'apate'a mako vayama'a hapaesake'a falikae.’ hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Fali'naya yafe ma mopa alo hu'nea afina aepa he'a mi'ko kafu Anumaya Koti aune vaya hapake'a fali'naya vaya'ae meni kanafi hapake'a fali'naya vaya'ae anona'api meni mai'naya vaya'mokitapa havi miya'api alikae. ");
INSERT INTO ino_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hokote'a Epolona hakeno faliteke'a mako'a ani kava hu'a hapame hapame e'a henaka'a Se'kalaiya'a Anumayamoteka amuse ya ali'e'a ne'malaya yafa hipa hanete ala mono no hanete hu'nea folakapi hakeno ako fali'ne. Mi'ko fali'naya'maki ani ali'a haviya hupate'naya anona'a meni afina mai'naya vaya'mokitapa alikae. ");
INSERT INTO ino_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Avo'neo. Lapa'kaeya mono hapalitapa hapa'nepaiya vayana maitapa halove heo. Lapa'kaeya Yisasi ke mi'ko afi'naya'maki ‘Mako vaya'moki o'afisae.’ nehutapa kita ako kimale'netapa ya'kisaya ki'a ako atale'nae. Lapa'kaeya ‘Ani nopi ohaikune.’ nehake'a mako vaya'moki ‘Ani nopi haikune.’ hu'a nehaya'maki ‘He'e ani nopi haitapa ofalekae.’ nehae.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yisasi'a ani no ne'ataleke'a mi'ko mono hapali'a hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae lusiya hu'a apaipa kafa hate'a “Akaeyateka mako ke huta aukosa humale'neta fate fate ke afikesunakeno hao'otake ke nehiseana ani keleti kake hutekaune.” hute'a a'kame u'e'a nehu'a akesi akesi hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nesu tauseni vaya'moki e'a ali'a atalu hu'naya afina Yisasi'a hokoteno akaeya ke ne'afea anaka'aife inake hu'ne Falasi mono ke ne'afea vaya'moki apaipafi hane'nea ya ake'a alakepa ohu'ne'a ameka apavayaleti apa'ke'atike ke nehaya yafe lapa'kaeya maitapa halove hu'netapao. Ani kavana kai hame'ya'mo halekino ala nehea avamete kava nehe. Lapa'kaeya ani yafe maitapa halove hu'netapao. ");
INSERT INTO ino_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ati'kamale'nisaya yana Anumaya Koti'a alino fole aike. Fala'kimale'nisaya ke henaka'a Anumaya Koti'a alino fole aisike'a mi'ko vaya'moki afikae. ");
INSERT INTO ino_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lapa'kaeya mi'ko hanipi hu'nisaya ketapi Anumaya Koti'a yake feluka huno fole aisike'a mi'ko vaya'moki afikae. Mi'ko lapa'kaeya notapifi sumi sumi hutapa hu'nisaya ke Anumaya Koti'a no'kato'mule heti'neno ala kefati huno fole ailapatesike'a mi'ko vaya'moki afikae. ");
INSERT INTO ino_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Lapa'kaeya vaya'nimokitapa nakaeya lamake hu'na lahapa'nepauve lapa'kaeya ameka lapa'kufa'ake lahapa'a kilapatesaya vaya'aife koli'api oheo. Ani vaya'moki lapa'ku mafa'ne'ae ha'a kitesaya lo'kiya'api o'male'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Koli'a hisaya ve'ka lapavelikoe. Vaya hapano ki ne'apateno apa'ku mafa'ne'ae hani'ake kelifi ata leke leke nehea atafi apasaka huli'neno ne'apatalea ve'kae'ke lusiya hutapa koli heo. He lamake nakaeya lahapa'nepauve lapa'kaeya Anumaya Kotife'ke lusiya hutapa koli'a heo. ");
INSERT INTO ino_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Lapa'kaeya ako ake'nae vaya'moki aole haesa monileti naya mako kaya aise aise namatato miya nehaya'maki Anumaya Koti'a inani akufa namafati mako'ke namae ake o'kanino akesa afifi huno mai'ne. Ake o'kani'neanaketapa lapa'kaeyapati mako'ke'mo'a ani nesu namayakamoki miya'api akasetapa vaya ala ya mai'nae. Inani avamete Anumaya Koti'a mi'ko lapa'kenopafi hane'nea lapayo'ka ako le'kanapaino afi'ne. Ako le'kanapai'nea yafe lapa'kaeya koli oheo. ");
INSERT INTO ino_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nakaeya lahapa'nepauve mako'ke ve'kamo'a vaya apaulakale nakaeya naki ne'ano “Yisasi'a naipafi mai'ne.” huno ano fole aiseana ani kava hu'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na ani ve'kamo aki ko'ku'napi Anumayamo kayo kayo vaya'ai apaulakale aki a'na apa'kaeyafe “Nakaeya mafa'ne anaka mai'nae.” hu'na fole aipatekauve. ");
INSERT INTO ino_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Fole aikoa'maki mako ve'kamo'a vaya apaulakale “Yisasi naipa o'ami'noe.” nehuno nakaeya a'kame'ya vai'nateseana ani kava hu'na Anumayamo kayo kayo vaya'ai apaulakale ani ve'ka na'kame'ya vai ne'ate'na “O'ake'noa ve'ka mai'ne.” hu'na hukoe. ");
INSERT INTO ino_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mi'ko vaya'moki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka hu'a haviya hunatesayana Anumaya Koti'a lahapaove lapatove nehuno aipa falu yapati alino atalelapatekaiya'maki mako ve'kamo'a Anumaya Koti Fate Akufa Avamu'amofe huno haviya huteseana Anumaya Koti'a ani ve'kae kahaove katove nehuno aipa falu yapati alino o'atalekaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nakaeya ke hu'naya yafe lapatafa hute'a mono nopi kava vayate'ae kamani kava vayate'ae lapavale'a ala kake hulapatekefe nehaisaketapaena koli hutapa “Na'yane ke anona'ale hukune? Na'yane huta hisune?” ina akufa lapa'kesa o'afeo. ");
INSERT INTO ino_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ani kanatole Anumaya Koti Fate Akufa Avamu'amo'a “Inake heo.” huno lapavayale malesiketapa ani ke huke. ");
INSERT INTO ino_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ani ali'a atalu hu'naya vayapati mako ve'kamo'a inake huno Yisasina hapai'ne “Hu'ka apave nelina Nenao nepu'nimofe hapaikeno afoti'amo afeno yapati fa'ko huno mako kaya'a namino.” ");
INSERT INTO ino_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hu'nikeno Yisasi'a akaeyafe inake huno hapai'ne “Nakaeya kake hulapatete'na afeno yatapi ali'na fa'ko fa'ka hulapatesoa ve'ka o'mai'noe.” ");
INSERT INTO ino_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Huteno mi'ko mai'naya vaya'aife inake huno hapapai'ne “Lapa'kaeya yakaitapa alakepa hu'netapao. Haviku mi'ko yate lapaulakamo'a akeno ha'ye hisiki maitapa halove hu'netapao. Nesu afeno ya male'nea ve'kamo'a ani afeno yateti avamu alino mai yana o'ali'ne.” ");
INSERT INTO ino_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mako avoya ke inake huno hapapai'ne mako nesu afeno ya male'nea ve'kamo hoyafina nesu alaka a'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Alaka a'nikeno ani ve'kamo'a inake huno akesa afi'ne “Mani ne'ya'kona laki'na malesoa no'ni o'male'neanake'na hana kava hisoe?” ");
INSERT INTO ino_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma ke huno akesa afe “Mi'ko ayu no'yaka'ni ali'na kapelete'na ala ala no'yaka kite'na mi'ko ne'ya'ni'ae mi'ko afeno ya'a'ni'ae ani kimalesoa nopi malekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Ina kava hute'na nakaeya'ne make hu'na hukoe naipa nakesamoka nesu afeno ya'ni'ae ne'ya'ni'ae hane'neanakeno haneme yatala kafufi ukeanake'na mai'na falu hu'ne'na ne'ya ne'ne'na amuse hu'na maikoe.” huno akesa afi'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nehea'maki Anumaya Koti'a akaeyafe inake hu'ne “Anekinaki ve'ka meni hani'ainaka kavamu'ka kahafalesuke'ka falikane. Falisanana ali'ka anupa humale'nana ya'kona nala'a alike?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yisasi'a inake nehe “Mako vaya'moki apa'kai'api apa'kufa ali'a haisaya yafe moni afeno ali'a anupa humale'naya'maki Anumaya Koti amuse hisea kava ohisayana inani hu'noa ve'kakana vaya mai'nae.” ");
INSERT INTO ino_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yisasi'a akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Meni nakaeya lahapa'nepauve lapa'kaeya ameka lapa'kufale maisaya yafe lapa'kesa lapa o'aitapa ‘Meni na ne'ya nekaune?’ hutapa oheo. Lapa'kufale yafe lapa'kesa ne'afitapa ‘Na kenati havaikaune?’ hutapa oheo. Ina akufa lapa'kesa afime afime o'veo. ");
INSERT INTO ino_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ne'yana afa ya hane'niki lapavamu hane'niketapa mai ya'mo'ke akaseno kanale ya hane'ne. Kena havai yana ameka lapa'kufale yanaki lapavamu alitapa mai ya'ke kanale ya hane'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Namayaka'aife lapa'kesa afikeo ne'ya hoya'api ali'a ha'kalete'a ne'ya ali'a itu no'vaiye. Ne'ya no'api o'male'nea'maki Anumaya Koti'a ne'ya apamike'a ne'nae. Ne'naya'maki lapa'kaeya ve a'nemokitapa namayaka apa'kasetapa ala ya mai'nayakeno Anumaya Koti'a kanale'ya huno yakailapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Lapa'kaeya folakatapifati mako ve'kamo'a ameka akufale yafe lo'kiya akesa afiseana ani ve'kamo'a akai'a avamu aise kana'a maleno avayu humale'neno yatala afina ofalino maikife? He'e lo'kiya'a o'male'neanakeno ako falike. ");
INSERT INTO ino_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inani aise kava hisaya lo'kiyatapi o'male'nisiketapaena na'ya hiketapa maisaya yafe lapa'kesa lapa ne'aiye? ");
INSERT INTO ino_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lapa'kesa afikeo kahaufaka vilasi ya'moki hai'a ause nehae. Ali'ya alite'a kena'api fa'kani'a no'ale. No'alea'maki nakaeya lahapa'nepauve a'ke'ainaka Solomoni'a kanale konakali'ae kena alo humale'naya kena havailino mai'nea'maki kahaufaka vilasi ya'mo ausemo'ke Solomoni alo hu'nea konakali yana akase'ne. ");
INSERT INTO ino_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","He lamake ani kahau yana hae'ake haiteno hoyafi hanekaiya'maki eka'a ako he'a hataka hisakeno vaitesike'a atafi kakaya'maki Anumaya Koti'a kanale konakali ause'alena hu ne'ateanaketapa lapa'kaeya'ae ve a'nemokitapa nakaeyafe afitapa lapaipafi male'naya yatapimo'a aise nehea'maki Anumaya Koti'a kanale'ya huno yakailapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ina kava hinaketapa lapa'kesa lapa ne'aitapa ‘Na ne'ya nekaune na li nekaune?’ hutapa lapa'kesa lapa o'aiyo. ");
INSERT INTO ino_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ma mopafi vaya'moki Anumayamoteka apaipa o'ami'naya vaya'moki ma mopale yafe apa'kesa afi'a ne'maiya'maki lapa'kaeya Afotapimo'a nesaya ya'ae kena havaisaya ya'aefe ako afiteno mai'neanaki ma akufa ya lapamike. ");
INSERT INTO ino_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lapamikea'maki Anumaya Kotife ‘Yakailato.’ hutapa hisaya yafe hokotetapa lapa'kesa afifi hisakeno henaka'a ani mi'ko ne'yatapi'ae kenatapi'ae lapamiteno ani kumatena lapavaleno lapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vaya'nimokitapa lapa'kaeya aise sipi sipi afu anaka'ni mai'nayanaki koli oheo. Afotapimo'a kava yakaisea kumate visakeno kava yakaipatesaya yafe ako ke humale'nea yafe koli oheo. ");
INSERT INTO ino_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ako ke humale'nea'maki lapa'kaeya mi'ko yatapi miya hesaya vaya'aite alitapa vike'a miya hutesaketapa ani moni alitetapa afeno ya'api o'male vaya hapa'matapa apameo. Ina kava hisayana ko'ku'napi amuse yatapi alitapa avatati hukae. Ani ko'ku'napi alitapa avatati hisaya amuse yana hano ohuke. Kumaya ve'kamo'a kumaya'ya hukefena anile o'uke. Ha'kano'mo'a alino haviya ohuke. ");
INSERT INTO ino_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Amuse yatapi hane'nea kumate lapaipamo'ae ani kumate hane'ne.” ");
INSERT INTO ino_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yisasi'a inake nehe “Ala kava ve'ka ako ekaiyanaki kenatapi alitapa aupa humale'netapa ala ata kanitapi kani atetapa avatati hutapa maiyo. ");
INSERT INTO ino_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mako ali'ya vaya'moki ala ve'ka'ape akeva maisaya kava hutapa akeva maiyo. Ani kava ve'ka mako a ali ve'kamo'a ne'ya ne'kano ke hikeno haino mai'neateti eteno eno kipate ne'amakisike'a makale kita ya'kitesaya yafe akeva mai'nae. Lapa'kaeya'ae ani kava hutapa avatati hu'netapa nakeva maiyo. ");
INSERT INTO ino_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ala ve'ka esea kanae apau o'kale'a avatati hu'a akeva mai'nisaya ali'ya vayana lusi amuse hukae. Lamake lahapa'nepauve ala ve'kamo'a akai'a kena alino aupa hu'neno ali'ya anaka'a hupatesike'a ne'ya ne hipale faitopale mai'nisakeno akai'a ne'ya alino apamike. ");
INSERT INTO ino_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Folaku esifi? Hokote ko'kole ake ne'aisikeno esifi? Ani ali'ya vaya apau o'kale'a avatati hu'a akeva mai'nisakeno eno ne'apa'keseana ani ali'ya vaya lusi amuse hukae. ");
INSERT INTO ino_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lapa'kaeya kumaya vaya'aife lapa'kesa afitapa haleo. No'mo afo'amo'a ‘Meni kumaya ve'ka ekaiye.’ huno afi'nininana ‘Kava yakaikoe.’ huteno kava yakai'neno ani kumaya ve'ka atalesikeno no'a heno kape olenine. ");
INSERT INTO ino_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ani kava hu'nea kava hutapa lapa'kaeya'ae avatati humaletapa akeva heo. Ko'ku'napati e'noa ve'ka vaya'mo alinate'nea ve'kamo'nae ‘O'mekaiye.’ nehutapa haviku mai'nisaya yapi e'na lahapau kakauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita'a inake he “Ala Nenao mani avoya ke lakaeya'ale'ke nehapi mi'ko vaya'mokitae ani ke nehane?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Afine'kekeno Anumayamo'a inake nehe “Ali'ya ve'kamo'a akenopa hale'nea ve'ka ali'ya'a alike alike nehea ve'ka lapa'kaeyapi hanate mai'ne? Ani kava hu'nea ali'ya ve'kae ala kava ve'kamo'a inake huke ‘Mi'ko ali'ya vayate kava yakai'ne'ka ne'ya fa'ko hu'ka apamite apamite ho.’ huke. ");
INSERT INTO ino_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hukea'maki ani kava ve'ka henaka'a eteno ne'esikeno hokoteno hapai'nea akufa kava nehuno'aena ani ali'ya ve'kamo'a amuse huke. ");
INSERT INTO ino_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lamake hu'na lahapa'nepauve ani kava hu'nea ali'ya ve'kae ala kava ve'kamo'a inake huke ‘Mi'ko ya'ni'ale kava yakaiyo.’ huke. ");
INSERT INTO ino_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Hukea'maki ani ali'ya ve'kamo'a akai'a akesafi ina akesa afike ‘Ala kava ve'ka'ni'a meni makale o'mekaiye.’ huteno yakaipate'nea ve a'mafa'ne kayo ne'apamino ala kava ve'kamo ne'ya'ae atu li'ae neteno anekinaki nehuno ‘O'mekaiye.’ huno hisea afina ani ala kava ve'ka ekaiye. Eno ani hao'otake kava hu'nea ali'ya ve'ka lusi kayo amakiteno inake huke ‘Nakaeyateka vekano'kano hune'nataya vaya'ae u'ka maiyo.’ huno hutekaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mako ali'ya ve'kamo'a akai'a ala kava ve'kamo hau'nea kava ako afiteno kava ve'ka haiya kava ohuno alino avatati ohu'niseana ala kava ve'kamo'a akaeya lusi kayo amakike. ");
INSERT INTO ino_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amakikea'maki mako ali'ya ve'ka ala ve'ka'amo haiya kava o'afino havi kava hiseana ala kava ve'ka'amo'a vase huno hakaiye. Anumaya Koti'a mi'ko ya apami'nea vayafe ‘Anona'a etetapa mi'ko ya nameo.’ huke. Mi'ko ya apayapi male'nea vaya'aife ‘Etetapa anona'a lusiya nameo.’ huke.” ");
INSERT INTO ino_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yisasi'a inake nehe “Nakaeya e'noana ma mopafi ata atalesukeno lesea yafe e'noe. Ani atamo'a makale lesea yafe lusiya huno ne'nahaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nakaeya nahaesakeno lusi nakafu kikea'maki makale o'nahakeno hififi lavate o'natea yafe naipamo'a kana'ake ne'nahaiye. ");
INSERT INTO ino_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lapa'kaeya hana lapa'kesa ne'afe ‘Yisasi'a ma mopafi vaya'mokita kame ya nehuna ya huno laka hulatefe e'ne.’ hutapa nehafe? Ina kava ohukoanake'na nakaeya lamake lahapa'nepauve nakaeya ma mopafina e'noana ve a'ne ali'na fa'ko fa'ka hisoa yafe e'noe. ");
INSERT INTO ino_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Meni afina aepa he'a naya mako kaya ve alavemoki mako'ke nopi mai'nisayapati aolefi ali'a fa'ko nehu'a aole'ae mako'ae anaka'moki aole kame ane'anatesayana aolemokani aole'ae mako'ae anakana ani ya hu'ana kame apateka'ae. ");
INSERT INTO ino_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Hute'a afo'amo'a ne'mafa'ne'a kame atesikeno ne'mafa'ne'amo'a afo'amona kame atesike'a huka'ae. Ani kava huno ita'amo'a a'mafa'ne'a kame atesikeno a'mafa'ne'amo'a ita'amona kame atekaiye. Mako ve'kamo ita'amo'a anofelo'amona kame ane'ateseana saufa anofelo'amo'a ani kava huno alopa anofelo'amona kame atekaiye.” ");
INSERT INTO ino_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yisasi'a ali'a atalu hu'naya ve a'ne'aife inake huno hapa'nepaiye “Lapa'kaeya yake lavino nefalea kateka hiya'mo'a kana'ake nehuno alino kofiketapa ne'aketapaena ‘Meni ko aike.’ hutapa nehakeno ko ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lapa'kaeya o'ko ko'ku'na ne'aketapaena ‘Meni lusi yake nelesikeno amu'ko'ake huke.’ hutapa nehakeno lamake ani kava huno lusi yake nele. ");
INSERT INTO ino_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Neleanaki lapa'kaeya lapaipafi afitapa o'male'naki ameka lapavayaleti ke vakala vaya mai'nae. Ko'ku'nate'ae mopale'ae fole aiya yana aketapa aeto nehaya'maki na'ya hiketapa meni afina fole aiya yana aketapa aeto nohae? ");
INSERT INTO ino_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Na'ya hiketapa lapa'kaeyatapi alakepa kava'ae alakepa ohu kava'ae afitapa fa'ko hutapa no'afe? ");
INSERT INTO ino_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kake hukatekefe hea ve'ka'ae alino fa'ko hisea ve'kale kateka ne'utanaena ani kake hukatekefe hisea ve'ka'ae kake hutana hale'ao. Haviku ani ve'kamo'a kavaleno ke afi'a fa'ko nehaya vaya'aite visike'a inaleti kavalemale'a ati vaya'moki apayapi katesake'a ati vaya'moki kavale'a nofi hukatekae. ");
INSERT INTO ino_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nofi hukatesake'kaena kake hukate'nea ve'kamo'a ‘Nameo.’ huno hu'nisea ya o'ami'nisanana nofi hukate'niseapati makale hano hu'ka o'mekane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ani kanatofi mako vaya'moki Kalili vaya'ai apavake Yisasina ha'nepai'a inake hae “Kalili vaya'moki Anumaya Kotiteka amuse ya amikefe sipi sipi afu nehakeno Pailati'a kava ne'apimo'a ati vaya'a hupateke'a e'a ani vaya hapake'a falaya kola'ae ani amuse ya amaya afumo kola'ae makopi lavi'na'ae.” hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hapai'nakeno Yisasi'a inake huno hapapai'ne “Lapa'kaeya na lapa'kesa ne'afe ani fali'naya vaya'moki mi'ko Kalili vaya'aina apa'kase'a havi vaya mai'nayanake'a ani kana ya ali'a fali'nae hutapa lapa'kesa ne'afife? ");
INSERT INTO ino_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nakaeya lamake hu'na lahapa'nepauve ina kava ohu'nayanaki lapa'kaeya lapaipa aitapa yahae hutapa hao'otake yatapi ne'ataletapa lapaipa aitapa yahae ohisayana ani anaka asaka u'a ai'naya kava hutapa asakautapa aitetapa falikae. ");
INSERT INTO ino_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloamu kumate mako yatala no'mo'a aino kapele lavino nayatala'ae naiya mako kaya'ae hano huteno naiya mako kayati aole'ae mako'ae alea vaya'yaka (18 vaya'yaka) aino apati'kaeke'a fali'nae. Ani fali'naya vayafe hao'otake kava hu'naya ya'apimo'a mi'ko Yelusalemu mai'naya vaya'ai hao'otake kava nehaya kavana apa'kase'ne hutapa lapa'kesa ne'afife? ");
INSERT INTO ino_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nakaeya lamake hu'na lahapa'nepauve ani kava ohu'nayanaki lapa'kaeya lapaipa aitapa yahae hutapa hao'otake yatapi o'atalesayana lapa'kaeya'ae ani ya hutapa falisaya ya'ake hane'ne.” ");
INSERT INTO ino_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yisasi'a mako avoya ke hu'nea kemo'a inake hu'ne “Mako ve'kamo'a hoya'afina mako fi'ki yosa faimale'neanakeno henaka'a ani ve'kamo'a eno alaka'a a'nisea'aene huno akeana ani yosamo'a alaka'a o'a'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","O'a'nikeno ani hoyale ali'ya ve'ka'aena inake huno hapai'ne ‘Afeo aole'ae mako'ae kafufi mani fi'ki yosamo'a alaka'a a'nisea'aene hu'na e'na akeke akeke hoa'maki alaki o'a'nea yafe mani yosa atakitalo. Na'mofe mopamo ne'na'a neno avaya ne'aeye?’ ");
INSERT INTO ino_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ani hoyale ali'ya ve'ka'amo'a ke anona'ale inake huno hapai'ne ‘Amuse'ka nehuki meni kafufi atale'nisanake'na aepafi yu'ko alite'na afumo aifa ali'ne'na male'na akekene. ");
INSERT INTO ino_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Male'na akekesukeno'ae'mo mako kafufi kanale alaka'a aesifi o'aesifi akeke'ka atakitalekane.’ hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sapati kanafi Yisasi'a mako mono nopi uno ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ani mono nopi mako kali a mai'nikeno Sata afe'mo'a ani a'mo aipafi mai'neno lusi kali ami'ne. Nayatala'a hano huteno naiya mako kaya'a hano huteno mako kaya naiyalekati aole'ae mako'ae alea kafu (18 kafu) ani afe'mo'a lusi kali amikeno ani a'mo a'kame'ya ayamufamo'a ano fakaki'nikeno hetino api o'ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yisasi'a ani a aketeno ‘Nakaeyate eno.’ huteno inake huno hapai'ne ‘Muka ana kali'ka ako ali'na ataloe.’ hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nehuno Yisasi'a ani ate aya ne'malekeno ani a'mo'a makale'a hetino api ne'aino Anumaya Koti aki alino asaka hu'ne.” ");
INSERT INTO ino_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Alino asaka nehikeno ani mono note so'ka ve'kamo'a Yisasi'a Sapati kanafi kali'a alino kanale hutea yafe aipa kafa nehano ve a'ne'aife inake he “Aole'ae aole'ae aole'ae kanafi (6 kanafi) ali'ya ali kana hane'neanaki lapa'kaeya ‘Kalitapi alino atalese.’ hutapaena ali'ya kanafaka'ke ekeno kalitapi alino ataleno. Sapati kanafi o'meo.” ");
INSERT INTO ino_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nehikeno Yisasi'a ke anona'ale inake huno hapai'ne “Lapa'kaeya ameka lapa'kufaleti kapalo kapala kelaka'ake vaya mai'nae. Sapati kanafi puluma'katapi'ae to'ki afuyakatapi'ae no'apifati utapa ya'kipatetetapa apavaletapa liteka ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inaya nehayanaki ma kali'a ali'na kanale hune'atoa ana Epalahamu akeho'amo mai'nikeno Sata afe'mo'a atafa huno nayatala'a hano huteno naiya mako kaya'ae hano huteno mako kaya naiyalekati aole'ae mako'ae alea kafu (18 kafu) nofi kitekeno kali ali'nea yana Sapati kanafi ali'na kalu hene'atoana hao'otake kava nehane hutapa nehafe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Apafi'keke'a kame'amoki lusi apavuya nehaya'maki mi'ko ve a'nemoki Yisasi'a kanale lo'kiya kava hea yafe lusi amuse hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Anile Yisasi'a inake he “Anumaya Koti'a vaya'aite yakaipatesea kava hana akufa ya'kana ya hane'ne? Hana akufa ya hane'ne hu'na lahapapaisoe? ");
INSERT INTO ino_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mako aise aise alakatato aki'a masatati alaka'akana ya hane'ne. Mako ve'kamo'a ani aise aise masatati alakatato hoya'afi faimale'nikeno ani yosamo'a haino ala hike'a namayakamoki ani yosamo a'kopale hale'e'a no'api ki'nae. Anumaya Koti kava yakailatesea kavana ani ya'kana huno hane'ne.” ");
INSERT INTO ino_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Halate mako'ae inake he “Anumaya Koti yakailapatesea kavana hana'ya hu'na ma akufa ya hane'ne hu'na lahapapaisoe? ");
INSERT INTO ino_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kai hame'yapi malakeno hale ne'kea ya'kana hu'ne. Mako a'mo'a falaova'ae hale kisea ya'ae lapepi male'neno alino aku naku huteno male'nisikeno aise kanafi ani falaovamo'a hale ne'ke. Anumaya Koti kava hulatesea kavana ani ya'kana huno hane'ne.” ");
INSERT INTO ino_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisasi'a Yelusalemu ukefe nehuno mako ala ala kumate'ae aise aise kumate'ae uneno nehuno mi'ko ve a'ne alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nehikeno mako ve'kamo'a inake huno Yisasife afine'ke “Ala Nenao Anumaya Koti'a mako'ke mako'ke vaya'ake apa'ku apame alino katikifi nesu vaya alino katike?” huno afine'kekeno Yisasi'a ali'a atalu hu'naya vaya'aife inake huno hapapaiye. ");
INSERT INTO ino_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Anumaya Koti kumate visaya kipana aise kipa'atofati faletapa haikae. Lapa'kaeya ‘Ani kipapi falesune.’ hutapaena lapayamufa alitapa lo'kiya vaili'netapa falekae. Nakaeya lahapa'nepauve nesu vaya'moki ani aise kipa'atofati ‘Afa'a faleta haikune.’ hu'a hukaya'maki haisaya lo'kiya'api o'male'neanake'a u'a ohaikae. ");
INSERT INTO ino_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Henaka'a ani no'mo afo'amo'a hetino eno kita'a aino a'kanisiketapa lapa'kaeya ma'aileka kipate etapa heti'netapa kipate ne'amakitapa make hukae ‘Ala Nenao kita ya'kilato.’ hutapa nehisayana Ala Ne'mo'a inake huke ‘Nakaeya olapa'ke'noki lapa'kaeya hana kumate vaya etapa mai'nae?’ huno hulapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Inake huno hisiketapa lapa'kaeya make hutapa hapaikae ‘Lakaeya valamo'mo kakaeya'ae lo'kata ne'ya neke li neke huna afina kate mai'ne'ka ke'kamo ali'ka laya hu'nana'mae.’ hutapa hukae. ");
INSERT INTO ino_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inake hutapa hukaiya'maki no'mo afo'amo'a inake huke ‘Lapa'kaeya olapa'ke'noa vaya mai'naki hana kumateti vaya etapa mai'nae? Lapa'kaeya hao'otake kava nehaya vaya mai'naki mi'ko'amokitapa maitapa halove heo.’ huke. ");
INSERT INTO ino_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lapa'kaeya akesayana Epalahamu'ae Aisa'ki'ae Ye'kopu'ae Anumaya Koti aune vaya'ae Anumaya Koti yakaisea kumate hai'a mai'nisaketapa akekayanaki lapa'kaeya'ke ma'aileka mai'netapa lusi avi neletapa lapave kume kanekae. ");
INSERT INTO ino_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nesu vaya yake haino ne'eatekati'ae yake lavino nefaleatekati'ae aluka aluka aupalikati ve a'ne e'a Anumaya Koti yakaisea kumate ali'a anupa hu'a mai'ne'a ne'ya nekae. ");
INSERT INTO ino_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","He meni afina afa vaya'kana hu'a aise vaya mai'nisaya vaya'moki henaka ani afina u'a hokote'a ala vaya maisake'a meni afina hoko netaya ala vaya'moki henaka ani afina afa vaya'kana hu'a henaka u'ne'a aise vaya maikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ani kanatofi Falasi mono ne'afea vaya'moki emale'a inake hu'a Yisasife hapai'ne “Ma mai'nana aupalika ne'atale'ka ako uvo. Heloti'a ala kava ve'kamo'a kahakefe nehe.” hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ha'nepaikeno Yisasi'a inake huno hapapaiye “Lapa'kaeya utapa vala afela kalamo akekeno avenafu'na heno katilitata huno uneno nehea ve'kamo'a ake'atike huno ano navataka nehea ve'kae inake hutapa hapaiyo ‘Afeo meni'ae eka'ae Sata afe'yaka hapafai ne'atale'na kali vaya ali'na ako kanale hupate'noanake'na aole'ae mako'ae kanafi mi'ko ali'ya'ni ali'na avaya akauve.’ hu'na hoa ke utapa hapaiyo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hapapaiteno inake hu'ne “Mi'ko Anumayamo aune vaya'a mako fate fate kumate hapake'a ofalikayanaki akola Yelusalemu kumate'ke mi'ko hapake'a falikae. Ani yafe menimaki ekamaki olakamaki ka u'ne'na hute'na Yelusalemu ukoe. ");
INSERT INTO ino_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Vae Yelusalemu mai'naya vaya'mokitapa lapa'kaeya Anumayamo aune vaya'a hapatapa ki ne'apatetapa Anumaya Koti'a hupateke'a lapa'kaeyate e'naya vaya'ae yafa kayoteti apamakitapa ki ne'apatae. Ani kava nehaya'maki nakaeya mi'ko afina ko'kolemo'a ana'au anaka'a apavaleno ha'ku kapi apateteno apatali kano ne'maiya kava hu'na Yelusalemu vaya lapavale'na atalu hisoe hu'nae nehoa'maki lapa'kaeya nolahapaiye. ");
INSERT INTO ino_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nolahaiye hutapa haya yafe afeo. Anumaya Koti'a kumatapi ako ne'ataleno ‘Aote'ya'ae.’ huno hu'neanaketapa meni mako'ae o'nakekaya'maki ma ke hisaya afina etetapa nakekae. Ani afina inake hutapa hukae ‘Anumayamo ali'ya alikefe hikeno hute'nea ve'ka Anumaya Koti'a kanale manu amise.’ ke hutapa hisaya afina mako'ae nakekae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mako Sapati afina Yisasi'a mako Falasi mono ke ne'afea vaya'ae mono nopi ala kava ve'kamo nopi uno ne'ya ne'neke'a mako vaya'moki ake'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mai'nakeno mako ve'ka falikefe nehikeno akufa haleki'nea ve'ka anile mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mai'nikeno Yisasi'a ani ve'ka aketeno ani nopi mai'naya Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'aefe inake huno apafike'ne “Sapati afina kali alino kanale hute yana kanale yapi havi yane? Lapa'kaeya mono kemo'a na'yane nehe?” huno apafike'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Apafikeke'a ani vaya'yakamoki ke ohu'a mai'nakeno Yisasi'a ani kali ve'ka atafa huli'neno kali'a alino kanale huteteno hutetekeno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne'vikeno Yisasi'a inake huno apafine'ke “Hana ve'kamoka Sapati afina mafa'ne'kafi puluma'ka afu'kafi kelifi lavi'nisike'kaena Sapati kanalene hutapa anifaka atalesafi makale avayu hukae? He lamake avayu hukae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Apafikeke'a mi'ko vaya'moki anona'a ke'ale ohu'nae. ");
INSERT INTO ino_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","“Ne'ya nekae.” huno ke hike'a e'naya vaya'moki e'a “Ala ve'kamo aimu'yale maisoe.” hu'a haya kavana Yisasi'a aketeno ani kava haya yafe inake huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Mako ve'kamo'a kakaeyafe ‘Ala emule eno.’ huno ke hike'ka u'ka ala ve'kamo aimu'yale faitopale o'maiyo. Anile faitopale mai'nisanakeno haviku mako kakase'nea ala ve'kamofe ke hinakeno esikeno ke hu'nea ve'kamo'a eno kakaeyafe inake huno huke ‘Heti'ka ala ve'kamo aimu'yalenaki ameo.’ huno hisike'kaena kavuya hinake'ka a'kameleka u'ka mopafi maikane. ");
INSERT INTO ino_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mako ve'kamo'a kakaeyafe ‘Ala ne'ya e'ka no.’ huno ke hinake'ka u'ka atupale faitopale maiyo. Anile faitopale mai'nisanakeno kakaeyafe ke hu'nea ve'kamo'a eseana kakaeyafe inake huke ‘Vaya'nimoka male o'mai'ka ala ve'kamo aimu'yale u'ka maiyo.’ huke. Ani ke hisike'kaena mi'ko anile mai'naya vaya'moki kaki ali'a asaka hukae. ");
INSERT INTO ino_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mako ve'kamo'a ‘Ala ve'ka mai'noe.’ nehuno ‘Nakufa ali'na asaka hukoe.’ hisikeno Anumaya Koti'a ‘Afa ve'ka mai'nane.’ huno hutekaiya'maki mako ve'kamo'a ‘Aise ve'ka mai'noe.’ huno hisikeno Anumaya Koti'a ani ve'kamo aki alino asaka huke.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","“Yisasika ne'yana e'ka no.” huno akaeyafe ke hu'nea ve'kae inake nehe “Ala emu kikefe mi'ko afina vaya'kamo'ae nepu'kamo'ae kakai'ka anaka'ae moni afeno'api hane'nea vaya'aife ne'ya nesaya yafe ke oho. Ke hisanake'a henaka'a kakaeyafe ‘Ne'ya e'ka no.’ hu'a hisayana anona'a ani ne'yana ako alikane. ");
INSERT INTO ino_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","Alikana'maki ala emu kikefe ma vaya'aife ke ho. Miya'api o'male vaya'ae apa'kufa haviya hu'nea vaya'ae apaiya haviya hu'nea vaya'ae apaulaka apo ka'nea vaya'ae ke hisanakeno Anumaya Koti'a amuse ya kamike. Ani vaya'yaka anona'a ne'ya'kalena kamisaya akufa ohu'naya yafe amuse nehisanakeno alakepa hu'naya vaya'moki fali'nayapati hetisaya afina Anumaya Koti'a akai'a anona'a kamisike'ka amuse hukane.” ");
INSERT INTO ino_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mako ve'kamo'a Yisasi'ae faitopale mai'neno ne'ya ne'neno Yisasi ke afiteno inake he “Mako vaya'moki Anumaya Koti kava yakai'nea kumate mai'ne'a ne'ya nesayana lusi amuse hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nehikeno Yisasi'a inake huno hapai'ne “Mako afina mako ve'kamo'a ala emu kikefe mi'ko vaya'aife ‘Etapa ne'ya neo.’ hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Emu ako kimaleteno ali'ya ve'ka'a hutekeno uno ke hu'nea vaya'aife ‘Lapa'kaeya eo mi'ko ne'ya ako alino avatati humale'ne.’ huno hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hapa'nepaike'a ani mi'ko vaya'yaka apaote apaote inake nehae ‘Lakaeya o'ukune.’ hu'a nehae. Mako'ke ve'kamo'a inake he ‘Mako hoya miya hemale'noanake'na u'na akekefe nehoanake'na amuse'ka nehuki o'ukoe.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nehikeno mako ve'kamo'a inake he ‘Nakaeya naya aole hano hea ali'ya alisea puluma'ka miya hemale'ne'na ali'ya'a kanale ne'alifi hu'na akekefe nehoanake'na amuse'ka nehuki o'ukoe.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nehikeno mako ve'kamo'a inake he ‘Nakaeya menito a ali'noanake'na amuse'ka nehuki o'ukoe.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Inake hakeno eteno ani ali'ya ve'kamo'a uno ala kava ve'kae hapaikeno ani ve'kamo aipamo'a haviya hikeno ali'ya ve'ka'ae inake huno hapai'ne ‘Kakaeya makale u'ka aise kate'ae ala kateka'ae ne'u'ka miya'api o'male vaya'ae apaiya haviya hu'nea vaya'ae apaulaka apo ka'nea vaya'ae apaumina haviya hu'nea vaya'ae apavale'ka eno.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nehikeno ani ali'ya ve'kamo'a ani kava huno eteno inake huno hapai'ne ‘Ala kava ve'kamoka kakaeya ke ako afi'na a'kame maloana mako mopale maisaya no'a afa'a hane'nikeno no'ka'a havai ote'ne.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nehikeno ala ve'kamo'a akaeya ali'ya ve'kae inake huno hapai'ne ‘Kakaeya kuma atale'ka ala kale kate ute'ka kahau aki'naleka ne'maiya vaya'ae ke hu'ka apavale'ka eke'a nakaeya nona havaiteno. ");
INSERT INTO ino_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nakaeya kaha'nepauve hokote'na ke nehuke'a o'me'naya vayana mi'ko meni ne'ya ali'a o'nekae.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Nesu vaya'moki Yisasi a'kame ne'vakeno aino yahae huno inake huno hapapai'ne “Mako vaya'moki nakaeya na'kame esu'aena afo'amo'ae ita'amo'ae a'amo'ae mafa'ne'amo'ae nepu'amo'ae asa'amo'ae akana'amo'aefe ‘Afa vaya mai'naki Yisasi'a lapa'kaseke'na naipa ami'noa ve'ka mai'ne.’ huno ohisea ve'kamo'a nakaeya ke ne'afea ve'ka o'maike. ‘Kanale maisoa navamu'nimo'a afa ya'kana nehiki Yisasi'a akaseke'na naipa ami'noa ve'ka mai'ne.’ huno ohisea ve'kamo'a nakaeya ke ne'afea ve'ka o'maike. ");
INSERT INTO ino_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nakaeya nakafu kisike'na falisoa kavafe mako ve'kamo'a ‘Ani kava hukoe.’ huno akai'a yofo yosa alino kofiteno na'kame visea akesa o'afisea ve'kamo'a nakaeya ke ne'afea ve'ka o'maike. ");
INSERT INTO ino_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Lapa'kaeyapati mako ve'kamoka ala no'kefa kisana kakesa afisu'kaena ‘Hokote'ka ani no'ni'a ki'na avaya o'aesukeno no kisoa ya hano hisifi?’ hu'ka kakesa afifi hute'ka ‘Mi'ko kisoa yana hane'ne.’ hute'ka ani nona aepa he'ka kikane. ");
INSERT INTO ino_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Hokote'ka ani kava ohisu'kaena aepa he'ka amalaku aite'ka posi faitetesanakeno moni hano hisike'ka ani no ki'ka avaya aesana lo'kiya'ka o'malesike'a mi'ko akesaya vaya'yakamoki kiki'ka hu'a kamuke hu'a inake hu'a hukae ‘Mani ve'kamo'a nona aepa heno ki'nea'maki ani nona makale kino hano hisea lo'kiya'a o'male'ne.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Inaki mako ala yahauve ve'kamo'a mako ala yahauve ve'kamo'ae ‘Aepa he'na la hukoe.’ huno akesa afisuno'aena hokoteno inake huno akesa afike ‘Nakaeya nayatala'a hano hea tauseni ati vaya'ni (10,000 vaya) mai'nakeno mako ala kava ve'kamo'a 20 tauseni ati vaya'a (20,000 vaya) mai'naki hana'ya hu'na la hisoa lo'kiya'ni'a hane'nifi?’ huno akesa afike. ");
INSERT INTO ino_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akesa afiteno ‘He'e la hisoa lo'kiya'ni'a o'male.’ huno afisuno'aena akaeya'ae la hisaya vaya'moki yatala kate mai'nisakeno mako vaya hupateteno inake huno huke inake hutapa afikeo ‘Hana'ya huta laipa falu huta maisune?’ hutapa afikeo huno hapapaike'a u'a afikekae. ");
INSERT INTO ino_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ani ya hukaki lapa'kaeyapati mako ve'kamo'a mi'ko ya'a a'kame'ya o'amiseana nakaeya ke ne'afea ve'ka o'maike.” ");
INSERT INTO ino_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Lapa'kaeya afi'nae hake kanale ya hane'nea'maki haka'ake nehea ya'a hano hisiketapaena hana'ya hutapa haka nehea ya'a alitapa fole aikae? ");
INSERT INTO ino_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haka'ake nehea ya'a ohaneseana afa ya'kana neheanakeno hoyafi malesapi afu aifa'ae ali'a makopi malesayana afa ya'ake hukeanake'a vaya'moki afa'a yaka hutalekae. Ke afi lapa'kesa hane'nisiketapaena ani ke afeo.” ");
INSERT INTO ino_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kumaya'ya nehu'a vaya apa'kufaleti ta'kesi miya alitata nehaya vaya'ae hao'otake kava huke huke nehaya vaya'ae Yisasi ke afikefe amete e'nae. ");
INSERT INTO ino_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","E'nake'a Falasi mono ke ne'afea vaya'ae mono hapali'a hapa'nepaiya vaya'ae akete'a inake hu'a ke vai'nae “Akeo ma ve'kamo'a hao'otake kava nehaya vaya'ae lo'kano mai'neno ne'ya ne'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Nehakeno Yisasi'a avoya ke inake huno hapa'nepaiye “Hana ve'kamoka naya mako kaya vaya'ai apaiya apaya hano hea afu (100 afu) ate'niseapati mako'ke'a fanane hikeno ani afumo afo'amo'a mi'ko afu'a kahaufaka ne'apataleno uno mako'ke fanane he'nea afu kahau ano akeno fole aise? Fanane hisiketapaena ani kava hutapa kahau akafi o'akae? ");
INSERT INTO ino_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","He kahau akae. Ani ve'ka kahau ano fole aiteno amuse huteno ake'yafi aino ko'mu'kino avaleno u'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kumate va'yi huteno vaya'ae ke hike'a e'a ali'a atalu hakeno inake he ‘Fanane he'nea afu'ni'a kahau a'na ake'na fole ai'noa yafe lapa'kaeya nakaeya'ae amuse hisune.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yisasi'a huno fole aino inake nehe “Ani kava huno mi'ko naya mako kaya vaya'ai apaiya apaya hano hea vaya'moki (100 vaya) apaipa ai'a yahae nehu'a hao'otake ya'api atalete'a alakepa kava nehaya vaya'aife Anumaya Koti'a amuse hukea'maki mako'ke hao'otake kava hume hume ne'visea ve'kamo'a hao'otake kava'a ne'ataleno aipa aino yahae nehuno ‘Anumaya Kotiteka e'na naipa amikoe.’ hisikeno'aena Anumaya Koti'a lusiya huno mako'ae amuse hutekaiye.” ");
INSERT INTO ino_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mako a'mo'a naya aole kina male'neapati mako'ke'a fanane hikeno kani ano halemale'neno no'afati no'ya alino kahau ano akeno alino fole aiteno'ae'ke ataleno maike. ");
INSERT INTO ino_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Alino fole aiteno vaya'ae ke hike'a ali'a atalu hakeno inake he ‘Lapa'kaeya nakaeya'ae amuse hisune. Moni'ni fanane hu'nea ya kahau a'na ake'na ali'na fole auve.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yisasi'a huno fole aino inake he “Nakaeya lahapa'nepauve ani kava hu'a Anumaya Koti ko'ku'napi kayo kayo vaya'amoki mako'ke ve'kamo'a hao'otake kava hume hume ne'viseateti ‘Hao'otake kava hu'noa ya'mo'a navuya hu'na ai'na yahae hu'na hao'otake ya'ni atale'na Anumaya Kotiteka e'na naipa amikoe.’ huno hisikeno'aena ko'ku'napi kayo kayo vaya'moki lusiya hu'a amuse hutekae.” ");
INSERT INTO ino_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisasi'a apa'kaeyafe inake nehe “Mako ve'kamo'a aole mafa'nela'a mai'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mai'na'akeno henaka alite'nea mafa'ne'amo'a afo'amofe inake huno hapai'ne ‘Afo'nimoka falisanana nakaeya ya hamalekaiye hu'ka nate'nisana yana meni nameo.’ huno hikeno afo'amo'a mi'ko ya'a alino fa'ko huno aole mafa'nela'a anami'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Anamitekeno henaka alite'nea mafa'ne'amo'a aise kana maiteno mi'ko moni afeno ya'a aliteno yatala aupalika u'neno hao'otake kavate akeno ha'ye huno mi'ko moni afeno'a uno atale eno atale hikeno moni afeno ya'a mi'ko hano hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hano hu'nikeno ani kumate ala kafu hu kana fole aikeno mako ya'a o'malekeno lusi aka nele. ");
INSERT INTO ino_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aka nelekeno mako ani kumate ve'kale uno ‘Ali'ya'ka alisoe.’ huno nehikeno kahaufaka ali'yate hutekeno uno afule kava yakaino mai'neno ne'ya'api ne'apame. ");
INSERT INTO ino_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ne'apamino inake he ‘Vae afumo ne'ya haleti'ya'a nesoe.’ hu'nea'maki mako ve'kamo'a nesea yana o'ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","O'amikeno akesa afino inake huno he ‘Mi'ko afo'nimo ali'ya vaya'amoki lusi ne'ya ne'a apamu hute'a mai'nake'na nakaeya nakateke'na falisoa kava nehoe. ");
INSERT INTO ino_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nehoanake'na heti'na afo'nimoteka u'na akaeyafe inake hu'na hukoe afo'nimoka nakaeya hao'otake kava kakaeya hukatete'na Anumaya Koti'ae hao'otake kava hulanate'noe. ");
INSERT INTO ino_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nakaeya alinate'nana mafa'ne'kamo'nae hu'na hisoana o'natekaiyanake'na amuse'ka nehuki ali'ya kano'ka maisoa yafe navalo hu'na hukoe.’ huno akesa ne'afe. ");
INSERT INTO ino_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Huteno afo'amoteka afaki'ale ne'vikeno afo'amo'a aketeno hautakiteteno naku naku huno vea'ya'mo'a anu'ki'neno hano ne'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Hano ne'nekeno mafa'ne'amo'a akaeyafe inake nehe ‘Afo'nimoka nakaeya hao'otake kava hukatete'na Anumaya Kotiteka'ae hao'otake kava hute'noanake'ka kakaeya alikate'noa mafa'ne'nimokae hu'ka hisanana o'katekaiye.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nehikeno afo'amo'a ali'ya vaya'aife inake hu'ne ‘Makale utapa kanale hu'nisea kena alitetapa havaiteo. Ayapi vailisea hana alitetapa vaitetapa aiya ano'ae vaiteo. ");
INSERT INTO ino_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ala puluma'ka afaya'ake hu'nisea afu hetesaketa kita ne'neta amuse hutesune. ");
INSERT INTO ino_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ma mai'nea mafa'ne'nimo'a fali'neapati eteno he'nete. Fanane hu'neapati eno fole hu'nea yafe amuse hutesune.’ huno hike'a aepa he'a lusi amuse nehae. ");
INSERT INTO ino_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","26","Nehakeno yake mafa'ne'amo'a hoyafakati eno note va'yi nehuno yakame nehu'a apaiya ne'aya ke afiteno ali'ya ve'kae ke huno inake huno afine'ke ‘Na kava nehae?’ huno afike'ne. ");
INSERT INTO ino_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Afine'kekeno akaeyafe inake he ‘Kakana'kamo'a ako e'ne. Akufamo'a kanale hikeno e'nea yafe afo'kamo'a afaya'ake afu ako heke'a ne'ne'a hafali ate'a mai'nae.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","29","Nehikeno nepu'amo aipamo'a lusi kana hikeno hai vaikeno ‘Nakaeya ohaikoe.’ huno hikeno afo'amo'a nopakati eno inake hu'ne ‘Amuse'ka nehuki hai'keno.’ huno afike afike hikeno afo'amofe inake hu'ne ‘Afeo nakaeya yatala kafu kakaeya ali'ya alike alike nehu'na ke'kaena mako afina he'e ohu'noanake'ka vaya'ni'amo'ae amuse hisoa yana mako'ke meme ana'au'a he'ka o'namitafa hu'nane. ");
INSERT INTO ino_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","O'nami'nana'maki ma mafa'ne'kamo'a miya afeno ya'ka alino kumai a'nele uno atale eno atale hikeno miya'ka hano hikeno ne'eke'ka akusa'ae afu he'nane.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Nehikeno afo'amo'a akaeyafe inake nehe ‘Mafa'ne'nimoka mi'ko afina nakaeya'ae mai'nanakeno mi'ko ya'ni'a kakaeya ya'ake hamale'neanaki ma kakana'kamo'a fali'neapati eteno heti'ne. Fanane hu'neapati eno va'yi neheanaketa amuse huta laipa kanale huta maisunana ani ya'mo'a kanale latekaiye.’ hu'ne.” ");
INSERT INTO ino_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisasi'a akaeya ke ne'afea vaya'aife inake huno hapapai'ne mako nesu moni afeno ya'a hane'nea ve'kamo'a ani afeno yate kava yakaisea ali'ya ve'ka'a mai'nike'a vaya'moki e'a moni afeno'mo afo'amofe ke fai'a ha'nepai'a inake hu'a hae “Kakaeya ali'yate kava ve'ka'kamo'a mi'ko ya'ka alino uno atale eno atale hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nehakeno moni afeno aepa ve'kamo'a afeno ya'ale yakai'nea ve'kae ke hikeno ekeno “Na kava hu'nana ke kakaeyafe naha'nepaiye? Nakaeya kava yakaisanafene hu'na kami'noa yana hana'ya hu'ka kava yakai'napi? Hu'ka yokita hute'ka e'ka nahapaiyo. Nahapaite'ka meni mako'ae kava yakai ali'ya ve'ka o'maikane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hikeno ani ali'ya ve'kamo'a aipa akesa inaya huno afi'ne “Ali'ya'nileti nahafaikefe heanake'na hana kava hisoe? Hoya ali'ya alisoana lo'kiya'ni o'male'neanake'na mako ve'kalekati au'kaya hu'na ne'ya ali'na nesoana navuya hukeanake'na hana kava hisoe? ");
INSERT INTO ino_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Meni hisoa kavana ako afi'noe. Ma kava hupatesuke'a kava yakai'noa ali'ya'nileti nahafaisike'a ani vaya'moki ‘Notifi e'ka maiyo.’ hu'a hukae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mako vaya'moki moni afeno'ae ve'kae inake hu'a hu'nae “Mako ya afa'a yo'ka namiteke'na henaka'a kamino.” hu'a hakeno ani ali'ya ve'kamo'a ani vaya'aife apaote mako'ke mako'ke'mokife ke hike'a akeno hokote ve'kae inake huno afine'ke “Nakaeya kava ve'kamo'a na'maki yana yo'ka kami'ne?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Afine'kekeno inake he “Nakaeya naya mako kaya naya'a hano hea vaya'ai apaiya apaya (100) kalasini talamu yo'ka nami'nea'maki anona'a o'ami'noe.” huno hikeno ali'ya ve'kamo'a inake he “Ani kamale'nea avona ma hane'niki makale ani vani hataleti'ae huno kamale'nea aki'a a'ka kalopa ne'atale'ka naya mako kaya kayo'ake (50) kamalo.” huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mako fate ve'kae inake he “Yo'ka kami'nea ya na'maki ali'nane.” huno afikekeno “Naya mako kaya naya'a hano hea vaya'ai apaiya apaya (100) laisi ku havaite'nea ku yo'ka nami'nea'maki anona'a o'ami'noe.” huno hikeno ani ali'ya ve'ka'amo'a inake he “Ani kamale'nea avona ma hane'niki ani vani hataleti'ae huno kamale'nea aki'a a'ka kalopa ne'atale'ka aole'ae aole'ae vaya'ai apaiya apaya (80'ae) hu'ka kamalo.” hu'ne. Ani kava hu'nea yafe ma akesa ne'afe henaka'a ali'ya'nileti nahafaitalesike'a ani vaya'moki “Notifi e'ka maiyo.” hu'a hisaya yafe ani akufa kava nehe. ");
INSERT INTO ino_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ani kumaya ali'ya ve'kamo'a akesa afifi huteno ani kava hu'nea yafe ala moni afeno'mo afo'amo'a inake hu'ne “Kanale kaipa kakesa hane'ne.” hu'ne. “Ma mopale yafe amuse nehaya vaya'moki ani akufa kava nehu'a vaya'apimokife apa'kesa afifi nehu'a havi kava hune'apate'a hale yapi mai'naya vayana ako apa'kase'a apa'kesa afifi vaya mai'nae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisasi'a inake nehe “Nakaeya nakai'ni lahapa'nepauve ma mopale moni afeno ne'alea yana havi kava nehayanaketapa lapa'kaeya ani moni afeno mako vaya apamisayana vayatapi maikae. Ani kava nehutapa falisakeno ani moni afenotapi hano hisea afinana Anumaya Koti'a maike maike hu no'afi visakeno alino falu fala hulapatekaiye. ");
INSERT INTO ino_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mako vaya'moki aise'ase yate kanale hu'a ne'yakaisayana ala yate'ae ani kava hu'a kanale hu'a yakaikaya'maki mako vaya'moki aise yate kanale hu'a no'yakaisayana ani kava hu'a ala yatena kanale hu'a o'yakaikae. ");
INSERT INTO ino_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lapa'kaeya ma mopale moni afenote kanale'ya hutapa kava yakaitapa alakepa ohisayana ko'ku'napi hane'nea alakepa afeno olapamike. ");
INSERT INTO ino_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Lapa'kaeya alu ve'kamo yate kanale'ya hutapa kava o'yakai'nisayana lapa'kaitapi afenona olapamike. ");
INSERT INTO ino_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mako ve'kamo'a aole kava ve'kala'ani ‘Ali'ya ve'ka'ani maisoe.’ huno ohise. Ani kava hiseana mako kava ve'kae hai ne'vaino ‘O'nahaiya kava nehana ve'ka mai'nane.’ huno hukea'maki mako kava ve'kae ‘Nahau nayamopafati ne'nahaiya ve'ka mai'nane.’ huke. Mako kava ve'ka aipa amiteno mako kava ve'kae ‘Fole o'nahaiya kava nehane.’ huke. Lapa'kaeya ani kava hutapa Anumaya Koti'ae ma mopale moni afeno'ae ‘Lana'kaeya kava yakainate'ao.’ hisayana ani aole yatala a'kame malesaya lo'kiyatapi o'male'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falasi mono ke ne'afea vaya'moki moni afeno yafe lusiya huno nehapaiya vayanake'a ani hea ke afite'a lusiya hu'a kiki hune'ate'a kamuke hau'nae. ");
INSERT INTO ino_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kiki hune'atakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya vaya apaulakale ‘Alakepa vaya mai'none.’ hutapa ne'afea'maki Anumaya Koti'a lapaipafi ako akeno alakepa hu'ne. Akeno alakepa hu'nike'a vaya'moki apa'kai'api hu'naya kavafe ‘Kanale'nale kava nehae.’ hu'a hu'naya'maki Anumaya Koti aulakale hi'mana'ake kava nehae. ");
INSERT INTO ino_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mosese'ae Anumaya Koti aune vaya'ae Anumaya Koti yakailapatesea yafe lo'kiya vai'a lahapapaime ne'akeno anileti Yoni'a fole ai'nea afina nakaeya aepa he'na Anumaya Koti kava yakailapatesea kanale ke lahapa'nepauketapa mi'ko vaya'mokitapa ‘Anumaya Koti kava yakailatese.’ hu'a hukefe lusiya hu'a apayamufa ne'valae. ");
INSERT INTO ino_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mopa'ae ko'ku'na'ae hano hukea'maki Anumaya Koti ke kamale'naya ke mako'ke aise ya'ato'a alaki fanane ohuke.” ");
INSERT INTO ino_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mako ve'kamo'a a'a ataleteno alu a aliseana kumai kava hu'ne. Anau'amo'a atalesikeno mai'nisea a mako ve'kamo'a aliseana ani kava huno kumai kava'ke huke. ");
INSERT INTO ino_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mako moni afeno ya'a hane'nea ve'kamo'a mi'ko afina kanale'nale haesa ku'kena havaino mai'neno kanale ne'ya'ake ne'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne'nekeno mako amute o'male ve'ka amu'mo'a akufale alino haya ki'nea ve'ka no kipa'ale faitopale mai'ne. Ani ve'kamo aki'a Lasalasi'ae. ");
INSERT INTO ino_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ani ve'kamo'a inaya huno akesa afi'ne “Afeno'a hane'nea ve'kamo'a ne'nesikeno ali lavisea atupatapa'a nesoe.” huteno eno mai'nike'a kalayakamoki e'a amuteti sakani sakani hu'a ne'nae. ");
INSERT INTO ino_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Henaka'a amute o'male ve'ka falike'a Anumaya Koti ko'ku'napi kayo kayo vaya'moki hipo'ya ali'a u'a Epalahamu mai'neate u'a ate'nakeno afeno'ae ve'ka'ae falike'a ali'a u'a kite'nae. ");
INSERT INTO ino_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kitetakeno hani'ake kumapi mai'neno lusi akufa akafu ne'kikeno akeno asaka huno hanaleka akeana alu'ale Epalahamu'ae Lasalasi'ae lo'ka'ana mai'na'akeno ana'ke'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ana'keteno inake nehe “Vae Epalahamuka nakinakomoka kakaeya lusiya hu'ka kalaki ainatete'ka Lasalasina hutekeno eno lipi aya ateno eno navenafu'nale malesikeno falu nahaise. Nakaeya lusi atafi mai'nokeno lusi nakufa nakafu ne'ke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nehikeno Epalahamu'a inake hu'ne “Mafa'ne'nimoka kakaeya a'ke'ainaka mopale mai'nana afina mi'ko kanale'nale ya ali'nanakeno Lasalasi'a mi'ko havi ya'ake ali'ne. Ina kava hu'nana yafe kakesa afi'ka hao hu'ka afeo. Meni Lasalasi'a ma kumate ne'ekeno aipamo'a kanale nehike'ka kakaeya kakufa kakafu'ae mai'nane. ");
INSERT INTO ino_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mako ya'ae kahapaikesoe lakaeya'ae lapa'kaeya'ae mai'nona folakapi Anumaya Koti'a lusi mulikefa alo humale'nike'a ma kumate vaya'moki lapa'kaeyate visaya apa'kesa ne'afea'maki halesaka hu'a o'umo avamete hane'ne. Ani kava hu'a kakaeya'ae mai'naya vaya'moki e'a ani muli halesaka hu'a o'mekae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nehikeno ani ve'kamo'a inake nehe “Nakinakomoka nakaeya lusi kalaki ne'ai'na kakaeyafe ke nehuki Lasalasina hutekeno afo'nimo noteka vino. ");
INSERT INTO ino_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nakana'nimoki naya mako kaya'a mai'nake'na nakaeya lusi nakafu ne'kea kumate e'na mai'noa yafe Lasalasina hutekeno uno ala kekefafati inake hise ‘Lapaipa aitapa yahae ohisayana nakaeya mai'noa kumate ekae.’ huno hapapaino.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nehikeno Epalahamu'a inake hu'ne “Apa'kaeya Mosese'a hu'nea ke'ae Anumaya Koti aune vaya'moki kamale'naya ke'ae hane'neanake'a ani ke hapali'a afisae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nehikeno afeno'a hane'nea ve'kamo'a inake he “He'e nakinakomoka Epalahamuka ani ke o'afikaya'maki mako fali'nisea ve'kamo'a kelifati eteno hetino apa'kaeyate uno hapapaiseana apaipa ai'a yahae hu'a hao'otake ya'api ne'atalete'a Anumaya Kotiteka apaipa amikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nehikeno Epalahamu'a akaeyafe inake nehe “Mosese'a hu'nea ke'ae Anumaya Koti aune vaya'moki kamale'naya ke'ae afi'a apaipafi o'malesayana mako fali'nisea ve'ka kelifati eteno hetino hapapaiseana ani ke'ae afi'a apaipafi o'malekae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisasi'a akaeya ke ne'afea anaka'ae inake huno hapapai'ne “Hao'otake kava heo.” huno ano apavataka hisea ya'mo'a ve a'ne'aite va'yi hisike'a asakau'a aikaya'maki hao'otake kava hisaya kate lapavaleno visea ve'kamo'a maino halove hu'neno'ao hu'nae lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mako ve'kamo'a ma nakaeyafe afi'a apaipafi male'naya mafa'ne anakapati mako mafa'ne avaleno “Hao'otake kava ho.” huno hiseana ani ve'ka lusi hao'otake kava neheanakeno ala kefi maike. Ani ve'ka avalete'a ala yafa alite'a liko'afi male'a nofi kite'a hake lipi yaka hutalesayana ani yana ala kana ya o'male'nea'maki nakaeya henaka'a amisoa kana yana lusi akafu kisea ya amikoe. ");
INSERT INTO ino_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amikoa'maki lapa'kaeya'ae maitapa halove heo. Kakaeya mako vaya'kamo'a hao'otake kava hisike'kaena ke ne'ama'ki'ka “Ina kava oho.” hisanakeno aipa aino yahae huteno hao'otake ya'a ataleseana kakaeya vaya'ka hao'otake ya'a kahaove katove nehu'ka kaipa falu yapati ali'ka ataleto. ");
INSERT INTO ino_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Vaya'kamo'a mako'ke afina naya mako kaya hano huteno naya mako kayati aole alea kanale (7 kanale) kakaeyateka hao'otake kava hukateseana ani ve'kamo'a eteno naya mako kaya hano huteno naya mako kayati aole alea kanale (7 kanale) eteno “Hao'otake kava hu'ne'na naipa ai'na yahae nehoe.” huno hisike'kaena kakaeya kahaove katove nehu'ka kaipa falu yapati hao'otake ya'a ali'ka ataleto hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Akaeya ke ne'afea anaka'moki Yisasife inake hu'a hae “Kakaeya lo'kiya'ka hane'nea yafe afita laipafi maleteta alakepa hisuna yati ali'ka ala hulato.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nehakeno Yisasi'a inake he “Aise avina alakamo aki'a Masatati alakakana hutapa lapa'kaeya nakaeyafe afitapa aise'a laipafi male'nininana ma yosaena inake hutapa hapaikae ‘Yosamoka aepa'ae mi'ko va'kai'ka hake lipi lavi'ka male'ka lakeo.’ hutapa hapaisayana lapa'kaeya ke a'kame maleno ani kava hinine.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lapa'kaeyapati mako ali'ya ve'kamo'a hoya ali'ya'ae sipi sipi afule yakai ali'ya'ae avaya ano ne'eseana yakaite'nisea ve'kamo'a “Makale e'ka ne'ya no.” huno hukife? ");
INSERT INTO ino_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","He'e kava ve'kamo'a inake ohukea'maki inake huno huke “Kakaeya ne'ya'ni ali'ka avatati hute'ka kanale kena'ka ali'ka havaite'ka alinate'ka eno. Nakaeya ne'ya netesuke'ka henaka'a kakaeya nekane.” huno huke. ");
INSERT INTO ino_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ani hapai'nea ke a'kame male'nea yafe ali'ya ve'kaena “Amuse'ka nehoe.” huno hutekaife? He'e inake ohuke. ");
INSERT INTO ino_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ina kava hu'neanaketapa lapa'kaeya'ae ani kava hutapa mi'ko lahapapai'noa ali'yana alitapa avaya ne'atapa inake hutapa heo “Lakaeya havi ali'ya vaya mai'nonanaketa ne'aluna ali'yana kanale huno latea ali'ya'ake ali'none.” hutapa heo hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisasi'a Yelusalemu ukefe veana Samelia koteka'ae Kalili koteka'ae folaka kate ne've. ");
INSERT INTO ino_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Mako kumate va'yi nehake'a nayatala'a hano hea fuko'ya apa'ke'nea vayana afakite heti'a mai'ne'a ala kekefafati inake hae “Yisasika amuse'ka nehunaki lakaeya kalaki ailato.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nehakeno Yisasi'a apa'keteno inake he “Lapa'kaeya mono nopi kava vaya'aite utapa lapa'kufa apaveleo.” nehe. Hike'a ani vaya'aite ne'vakeno kateka apa'kufamo'a eteno kanale hupate'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kanale hupateke'a ne'vaya vaya'aipati mako'ke ve'kamo'a akeana “Nakufamo'a kanale he.” huteno eteno Yisasite uno ala kekefafati amuse huno Anumaya Koti aki alino asaka hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yisasite uno ape hu'neno aiyale alino soso nehuno “Kakaeyafe lusi amuse'ka nehoe.” nehe. Ani aiyale alino soso nehea ve'ka Samelia ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mai'nikeno Yisasi'a ani ve'ka aketeno inake he “Nakesa afoana nayatala'a vaya ako ali'na kanale hupate'nofe? Mako kaya naya hano huteno mako nayatekati aole'ae aole'ae vaya hanate maitake'ka kakai'kake ne'ane? ");
INSERT INTO ino_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Na'ya hike'a ani vaya'yaka Anumaya Kotite e'a aki ali'a asaka nohae? Mani mako'ke ve'ka alu kotekati ve'ka akaito'ake eno Anumaya Koti aki alino asaka nehife?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yisasi'a ani ve'kae inake huno hapai'ne “Kakaeya heti'ka uvo. Nakaeyafe afi'ka kaipafi male'nana ya'kamo'a kakaeya ako alino kanale hukate'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Falasi mono ke ne'afea vaya'moki inake hu'a afine'kae “Na afina Anumaya Koti'a kava alino yakaipatesea kana'a va'yi huke?” hu'a hakeno Yisasi'a ke'apile anona'a inake he “Anumaya Koti'a kava yakaipatesea kana va'yi hiseana Anumaya Koti'a apavelisea yafe avame'ya hu kavana ohukea'maki ve a'nemoki o'afisaya kava huno ekaiye. ");
INSERT INTO ino_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mako vaya'moki inake hu'a hukae ‘Akekeo male hane'ne mukale hane'ne.’ hu'a ohukaya'maki afeo Anumaya Koti'a lapa'kaeya folakapi kava ya alino mai'ne.” ");
INSERT INTO ino_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yisasi'a akaeya ke ne'afea anaka'aife inake he “Henaka'a mako kana va'yi hisiketapa inake hutapa hukae ‘Ko'ku'napakati e'nea ve'ka vaya'mo alite'nea mafa'ne mako'ke afina akesune.’ hutapa hukaya'maki o'nakekae. ");
INSERT INTO ino_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","O'nakesake'a mako vaya'moki inake hu'a lahapapaikae ‘Hae akekeo mekaleka mai'ne.’ huke ‘Mafi mai'niki etapa akeo.’ hu'a a'a lapavataka hukaya'maki afeo lapa'kaeya apa'kaeya apa'kame o'veo. ");
INSERT INTO ino_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","O'ukayanake'na nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ete'na esoa kanalena ina kava huke ko'ku'napi mako aupalika makale'a kopasi'namo'a alave alave nehuno mi'ko aupalika ano ha nelea kavakana hu'na ete'na ekauve. Esukeno mi'ko aupalika ano halesike'a akekae. ");
INSERT INTO ino_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akekaya'maki hokote yana meni afina mai'naya vaya'moki apa'kame'ya namite'a nakufa nakafu kisea ya hunatetesake'na henaka'a ani kava hu'na ekauve. ");
INSERT INTO ino_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ete'na esoa afina mai'naya vaya'moki Noa'a mai'nea afina mai'naya vaya'moki hu'naya au'ava kava nehisake'na ekauve. ");
INSERT INTO ino_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa'a mai'nea kanafi mai'naya vaya'moki ne'ya ne'ne'a li ne'ne'a a alike ve alike nehu'a mi'ko afina ani yafe'ke apa'kesa ne'afikeno Noa'a lipi kalefi haitekeno mopafi li he'neno mi'ko ve a'ne ano apati'kaeke'a fali'a hano hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","30","Ani kava hu'a Loti'a mai'nea kanafi vaya'moki ne'ya neke li neke afeno ya ali'u'a malake'a vaya'moki miya heke hoya alike no kike nehakeno Loti'a Sotomu ataleno ne'vea aiya'kale ani afina Anumaya Koti'a ata'ae ala hi'mana'ake ata nelea yafa ko'ku'napakati ko'kana huno elineno mi'ko ve a'ne apamakino falu ati'ne. Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ete'na apaulakale fole aisoa afina inani au'ava kava'ake nehisake'na mi'ko ve a'ne'aitena va'yi hukoe. ");
INSERT INTO ino_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ani ete'na esoa afina mako ve'kamo'a no'kato'mu'ale mai'niseateti no'afaka hane'nisea yana lavino no'afakati o'alino. Ani ya huno mako ve'ka hoya'afaka mai'niseatetina eteno no'aleka o'vino. ");
INSERT INTO ino_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lapa'kaeya Loti a'mo hu'nea kavafe lapa'kesa afitapa hao heo. ");
INSERT INTO ino_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mako ve'kamo'a mai ya'ale atafa huno alaki hiseana ani mai ya'a avaya akaiya'maki mako ve'kamo'a nakaeyafe akesa afino mai ya'a ataleseana eteno alike. ");
INSERT INTO ino_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nakaeya lamake hu'na lahapa'nepauve ani hanipi aole ve'kala lo'ka'ana mako'ke hipale hava'nisa'akeno Anumaya Koti'a mako ve'ka ne'avaleno mako ve'ka alino apahetalekaiye. ");
INSERT INTO ino_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aole atala'mokani maya lo'ka'ana haya ne'aisa'akeno mako'mona Anumaya Koti'a ne'avaleno mako'mona anifi alino apahetalekaiye. ");
INSERT INTO ino_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aole ve'kalana ani ya hu'ana hoya'anifi mai'nisa'akeno mako'mona Anumaya Koti'a ne'avaleno mako'mona anifi alino apahetalekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hike'a hea ke afite'a inake hu'a afine'kae “Ala Nenao ani nehana ke hana'ale va'yi huke?” hu'a hakeno Yisasi'a inake he “Fali'naya vaya'ai apa'kufa hane'nea yate'ke ha'ki'ki namayakamoki ali'a atalu hu'nae. Ani kava hu'a mi'ko vaya'moki folakapi Anumayamo Mafa'ne ekauve.” ");
INSERT INTO ino_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","2","Yisasi'a inake nehe “Mi'ko afina Anumaya Kotiteka ke hutapa afikeo. Alaka ne'nahaiye hutapa o'ataleo.” hu'ne. Ani ke afisea yafe mako avoya ke hapapaino inake he mako ala kumatena mako kake afi ve'ka mai'ne. Ani ve'kamo'a Anumaya Kotite'ae ma mopafi ve a'ne'aite'ae alaki koli ohuno mi'ko vaya'aife “Apaote ya'ape.” huno nehea ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","5","Ani kumate mako kaite ana mai'neno mi'ko afina ani kake afi ve'kalena uno inake huno hapaite hapaite hu'ne “Kame kano'nimo'a alino haviya hunatekefe nehike'nae nehuki kakaeya naha'ma'ka kake ho.” huno hapaite hapaite hu'nikeno hokoteno ani kake afi ve'kamo'a ani ana ha'o'maesea akesa afi'nea'maki henaka'a ma aipa akesa afi'ne “Anumaya Kotife koli nohoa ve'kake'na mi'ko vaya'aife ‘Lapaote yatape.’ hupate'noa'maki ma kaite a'mo'a lusi alaka nahaeya ke eno mi'ko afina neheanake'na ha'ma'na kake hisoe. Haviku mi'ko afina eno ke huke huke hisikeno alaka nahae yafenake'na ako ha'makauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yisasi'a inake he “Hao'otake kava nehea kake ne'afea ve'kamo ke afeo. ");
INSERT INTO ino_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Anumaya Koti'a hisea kavafe na lapa'kesa ne'afe? Akaeya ha'ye huno hapalimale'nea ve a'nemoki mi'ko feluka'ae hani'ainaka'ae Anumayamoteka inake hu'a afine'kae ‘Hao'otake kava hulate'naya vaya'aife akete'ka alakepa hu'ka kake hupato.’ hu'a afike afike hu'a ne'maisayana Anumayamo'a kake huno fa'ko fa'ka huke hutapa nehafe? He ani kava huke. Yatala afina maike maiketeno makale'a fa'ko fa'ka ohuke hutapa nehafe? He'e lamake hu'na lahapa'nepauve makale'a kake huno fa'ko fa'ka hukea'maki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ete'na esoa afinana ma mopafi ve a'nemoki nakaeyafe afi'a apaipafi male'naya vaya mai'nisafi o'mai'nisafi?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Mako vaya'moki apa'kai'api apaipa apa'kesafati “Alakepa kava nehune.” nehu'a mako vayafe “Havi vaya mai'nae.” hu'a nehaya vaya'aife Yisasi'a avoya ke huno inake nehe “Aole ve'kala'mokani Anumayamoteka ke hu'ana afikekefe mono nopi hai'ana mai'na'ae. Mako ve'ka Falasi mono ke ne'afea ve'kae. Mako ve'ka kumaya'ya nehuno vaya apa'kufaleti ta'kesi miya ne'alea ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falasi mono ke ne'afea ve'kamo'a folakapi heti'neno Anumayamoteka akai'ae inake nehe ‘Nakaeya mako vaya'moki nehaya kava nohoa ve'ka mai'noe. Kumaya'ya haya kava nohoe. Alakepa kava nohaya vaya'ai kavana nohoe. A'ne'aife ake'a hapa'ye hu'a kumai kava nehaya kava nohoe. Ma mai'nea ve'kamo'a vaya apa'kufaleti ta'kesi miya ne'alea ve'kamo'a nehea kava nohoe. Ina yafe amuse'ka nehoe. ");
INSERT INTO ino_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kakaeyafe mi'ko sota'mo ali'ya kanafi ne'ya aole afina mosi'na mai'ne'na mi'ko ne'aloa yapati naya aole male'noapati ali'na fa'ko hu'na mako'ke'a ne'kamoa ve'ka mai'noe.’ nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Neheanaki vaya apa'kufaleti ta'kesi miya ne'alea ve'kamo'a alu'ale mai'neno Anumaya Kotiteka ke huno afikekefe heti'neno ‘Hao'otake ve'ka mai'noe.’ huno ape hu'neno havi kafa alino fataka nehuno ko'ku'napaka aulu oheno Anumaya Kotiteka inake huno afine'ke ‘Anumayamoka nakaeya hao'otake kava hume hume nehauva ve'ka mai'noki nakaeyafe kahau hunato.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisasi'a inake nehe “Nakaeya lahapa'nepauve mani kumaya'ya huno vaya apa'kufaleti ta'kesi miya ne'alea ve'kae Anumaya Koti'a ‘Alakepa ve'ka mai'nane.’ huno hutetekeno no'aleka eteno u'ne. U'nea'maki hokote ve'kaena ani akufa ke hu o'ate'ne. Mako ve'kamo'a ‘Ala ve'ka mai'ne'na nakufa ali'na asaka hukoe.’ huno hisikeno Anumaya Koti'a ‘Afa ve'ka mai'nane.’ huno hutekaiya'maki mako ve'kamo'a ‘Aise ve'ka mai'noe.’ huno hisikeno Anumaya Koti'a ani ve'kamo aki alino asaka huke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vaya'yakamoki mafa'ne'api “Yisasi'a aya maleno amuse ya apamise.” hu'a Yisasite apavale'a ne'ae. Apavaleli'a ne'ake'a Yisasi ke ne'afea anaka'moki “Ina kava oheo.” hu'a ke ne'apama'ke. ");
INSERT INTO ino_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ke ne'apama'kikeno Yisasi'a ani aise aise mafa'ne'aife “Nakaeyate eo.” hike'a akeno “Afa'a ka o'a'kanitapa apataleke'a nakaeyate eo. ‘Inamu mafa'ne mai'neta lo'kiyati o'male.’ hu'a nehaya vaya'mokike Anumaya Kotife ‘Yakailato.’ hu'a nehaya vaya mai'nae.” ");
INSERT INTO ino_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lamake hu'na lahapa'nepauve mako vaya'moki mafa'nekana nehu'a “Lo'kiya'ni o'maleki Anumaya Koti yakainato.” hu'a ohisayana Anumaya Koti'a yakaisea kumate alaki lamake o'ukae. ");
INSERT INTO ino_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mako ala ve'kamo'a inake huno Yisasife afine'ke “Vae kanale ve'kamoka hu'ka apave nelina ve'ka hana kava hute'na maike maike hisoa navamu alisoe?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nehikeno Yisasi'a inake huno hapai'ne “Anumaya Koti'a akai'a mako'ke'ake kanale ve'ka mai'nea'maki na'ya hike'ka nakaeyafe ‘Kanale ve'ka mai'nane.’ hu'ka nehane? ");
INSERT INTO ino_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kakaeya Anumaya Koti ke male male'nea ke ako afi'nana'maki ani kemo'a inake hu'ne kakaeya kumai kava oho. Kakaeya mako ve'ka ha'ka ki o'ato. Kumaya ya oho. Mako ve'kamo'a hao'otake kava nehe hu'ka kake'atike ke mako ve'kaleka failitata oho. Ita'kafo'kamoki ke afite'ka a'kame ho.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nehikeno ani ala ve'kamo'a inake he “Aise ya'nileti aepa he'na maime e'na meni ma mai'noana ani Anumayamo ke male male'nea ke a'kame male'noe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nehikeno Yisasi'a ani ke afiteno inake nehe “Mako kava'ae ho. Mi'ko male'nana moni afeno ya'ka ali'ka fa'ko fa'ka hu'ka miya'api o'male vaya apamisanakeno Anumaya Koti'a ko'ku'napi afeno ya'ka katekaiye. Afeno ya'ka apamite apamite hute'ka na'kame eno.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nehikeno ani ve'kamo'a ani ke afiteno moni afeno ya'a nesu'ya hane'nea yafe aipamo'a afino lusi kana'ake hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ani ve'kamo aukosamo'a ati ne'kaekeno Yisasi'a aketeno inake nehe “Nesu afeno ya ma mopafi male'nisea ve'kamo'a lusi akaso ne'alino Anumaya Kotife ‘Kava yakainato.’ huno huke. ");
INSERT INTO ino_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mako puluma'kakana afumo aki'a kamolo nehaya afumo'a ne'kayamo kapi faleno viseana afa'a yo'yo huno ukea'maki mako ma mopafi nesu moni afeno male'nea ve'kamo'a Anumaya Kotife ‘Kava yakainato.’ huno hu yafe akaso alikeanakeno afio'kekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hike'a anile mai'naya vaya'moki hea ke afite'a inake hu'a afine'kae “Ina akufa kava hiseana inaki nala'amoki apaipa apame alino katisike'a maike maike apavamuna alikae?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nehakeno Yisasi'a inake he “Mako vaya'moki ‘Lo'kiyati o'male'neanaketa alo ohukune.’ hu'a hisaya yana Anumaya Koti'a lo'kiya'a hane'nea ve'kakeno afa'a alo huno apaipa apame alino katike.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nehikeno Pita'a inake he “Lakeko lakaeya kumati'ae mi'ko afeno yati'ae ne'ataleteta kakaeya ka'kame ne'one.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Nehikeno Yisasi'a inake huno hapapai'ne “Nakaeya alaki lamake hu'na lahapa'nepauve mako ve'kamo'a nakaeyafe afino aipafi male'neno Anumaya Koti'a kava yakaisea ke mako vaya hapapaikefe no'aki a'aki nepu'amo'aki ita afo'amo'aki mafa'ne'aki ne'apataleno eseana Anumaya Koti'a meni afina ma mopale mai'ne'a atale'nisaya ya'apilena anona'a mako'ae mako'ae o'afunama'a ne'apamino henaka'a fole aisea afina maike maike hu'a maisaya apavamu'ae apamike.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisasi'a akaeya ke ne'afea anaka'a apavaleno apaote alino atalu hupate'neno inake nehe “Afeo meni Yelusalemu kumapi haisunake'a a'ke'ainaka Anumaya Koti aune vaya'moki ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kae hunatesea ke kamale'naya kemo'a meni fole aino ne'ya'a alitekeno lamake huke. ");
INSERT INTO ino_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lamake hisike'a nakaeya natafa hu'a mako Yuta nofi o'mai anaka'ai apayapi natesake'a havi ke hu'a yakale ne'nate'a ali'a haviya hune'nate'a naukosafi apavaitu'na henateke hukae. ");
INSERT INTO ino_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kata kayoteti ne'namaki'a nahaesake'na falitesuke'a kelifi kinate'nisake'na aole'ae mako'ae kana ani kinatesaya kelifina maine'male'na ete'na hetikoe.” ");
INSERT INTO ino_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Akaeya ke ne'afea anaka'amoki ani Yisasi'a hea ke afi'a ha ole'nae. Ani hea kemo aepa'amo'a ako fala'ki'nike'a ani ke afi'a alakepa hu'a ha ole'nae. ");
INSERT INTO ino_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yisasi'a Yeli'ko kuma'mo haute ne'vikeno mako aulaka fali ka'nea ve'ka kate mai'neno u'e'a haya vaya'aife “Moni nameo.” huno ke huke huke nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ke huke huke nehuno afeana nesu vaya'moki ete ete nehakeno mako vaya'aife ke huno inake nehe “Na kava nehaketapae nehae?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Apafine'keke'a make hu'a hae “Yisasi'a Nasaleti kumate ve'ka ne'eke'a akekefe e'a kakase'a ute ute nehae.” hu'a hapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hapaitakeno ani ve'kamo'a ala kekefafati inake nehe “Yisasika Teviti akeho'amoka e'ka kalaki ainato.” huno ka ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka ne'aeke'a e'a akase'a ne'vaya vaya'moki ke ne'ama'ki'a “Ke ohu'ka maiyo.” hu'a nehaya'maki ani ve'kamo'a mako'ae ala kekefati ka ano “Yisasika Teviti akeho'amoka e'ka kalaki ainato.” huno ka ake ake huno mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ani ke huke huke huno maiya'kena Yisasi'a ani ke afiteno makale'a uno anile mai'neno “Aulaka fali ka'nea ve'ka male eno.” hikeno amete ekeno Yisasi'a akaeyafe inake huno afine'ke “Nakaeyafe na kava hunatese hu'ka nehane?” huno afine'ke. Afine'kekeno inake he “Amuse'ka nehuki nakaeya ete'na naulaka akesoe hu'nae nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nehikeno Yisasi'a inake nehe “Nakaeyafe afi'ka kaipafi male'nana ya'kamo'a kaulaka'ka alino kanale hune'kate.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nehikeno makale'a ani ve'kamo aulakamo'a aya'kekeno Yisasi a'kame ne'uno lusi amuse huno Anumaya Koti aki alino asaka hike'a mi'ko anile ali'a atalu hu'naya vaya'moki ani ya akete'a Anumaya Koti aki ali'a asaka nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yisasi'a Yeli'ko kumapi haiteno inaleti mako kumate ukefe ne've. ");
INSERT INTO ino_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ne'vikeno mako ve'ka aki'a Sa'kiasi'a ani kumate mai'ne. Ani ve'ka vaya'ai apa'kufaleti apa'ke'atike ke nehu'a ta'kesi miya ne'alea vaya'aite kava ve'kakeno nesu moni afeno male'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ani ve'kamo'a Yisasife “Hana akufa ve'ka mai'nifi?” huno akekefe hu'nea'maki aupasi ve'ka mai'nea yafe nesu vaya'moki mai'a a'kani'nakeno Yisasina akesea kafe lusiya huno kahau ame uneno hu'nea'maki Yisasina o'ake'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","O'akeno Yisasi visea kateka naku naku huno uno hokoteno vea'ya'mo'a mako fi'ki yosafi haino mai'neno Yisasina akekefe hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hu'nikeno Yisasi'a ani Sa'kiasi'a mai'nea yosa aepale ne'uno akeno asaka huno aketeno Sa'kiasife inake huno hapai'ne “Sa'kiasika makale'a eli'keno. Meni kakaeya nopi hai'na maisoe.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ha'nepaikeno Sa'kiasi'a ani ke afiteno makale'a ani yosafati elineno lusi amuse nehuno Yisasina avalelino no'afaka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","U'nike'a mi'ko vaya'moki inani ya ne'ake'a Yisasife kalu kalu ke ne'ama'ki'a inake hu'a ke nehae “Hao'otake kava nehea ve'kamo nopi u'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nehakeno Sa'kiasi'a heti'neno inake huno Anumayamofe nehe “Anumayamoka afeo. Meni mi'ko ya'nimo folakapati fa'ko fa'ka hu'na makoma'a ali'na afeno ya'api o'male vaya apamikoe. Inaki nake'atike ke hupatete'na ani ya'api kumaya ali'nisoa yatena ete'na aole'ae aole'ae afina apamikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nehikeno Yisasi'a akaeyafe inake huno hapai'ne “Ma ve'kamoka Epalahamu akeho'amoka mai'nanaki meni afina Anumaya Koti'a ma nopi mai'naya anaka'ka apa'ku apame ako alino kati'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na kanale ka atale'naya vaya kahau a'na apavale'na apa'ku apame ete'na ali'na katikefe e'noe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Inani hea ke afitakeno Yelusalemu eno va'yi hukefe nehike'a anifi mai'naya vaya'moki ma apa'kesa afi'nae “Menito'ake Anumayamo'a kava alino yakaipatesea kana ako fole aike.” hu'a nehaya yafe mako avoya ke'ae inake huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mako ala kava ve'ka mako afaki kumate visike'a avale'a ala kava ve'ka'api hamaletesakeno ani ve'kamo'a eteno ekaiye. ");
INSERT INTO ino_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Afaki koteka ukefe nehuno nayatala'a ali'ya vaya'ae ke hike'a akeno 20 kina 20 kina huno apamiteno inake huno hapapai'ne “Lapa'kaeya meni ma monileti ali'ya alikeno ho'ne'kaesike'na ete'na e'na va'yi hino.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Huteno u'nea'maki ani ve'kamo kuma'aleti vaya'moki kava'api maisea yafe ohapaike'a apaipa kafa hene'atakeno ani ve'ka ne'veana mako vaya hupatake'a a'kame hafai'a ne'u'a make hu'a hu'nae “Lakaeya ma ve'kamo'a ala kava alino yakailatesea yafe nolahaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Inake hu'a hu'naya'maki ke'api o'afi'a ani ve'ka avale'a “Ala kava ne maike.” hutakeno kava ya alino mai'neateti eno inake he “Moni apami'noa ali'ya vayafe ke hike'a male e'a mako'ke mako'ke'moki moni apami'noa moni ali'a akase'a male'nisafi e'a ali'a fole aiyo.” huno ke nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ke hikeno mako ve'kamo'a hokoteno eno inake huno hapai'ne “Amuse'ka nehuki kakaeya 20 kina nami'nana yafa'kaleti ali'ya alime ne'ukeno anona'a'ka 200 kina ali'na anupa hu'na kate'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nehikeno ala kava ve'kamo'a akaeyafe inake hu'ne “Kakaeya kanale ali'ya ve'ka'ni mai'ne'ka kanale ali'ya ali'nane. Aise ya'atole kanale'ya hu'ka yakai'ne'ka ali'ya alike alike nehanakeno alino ala hu'nea yafe kakaeya nayatala ala kumate kava ya ali'ka maisana lo'kiya ne'kamoe.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ani a'kameleka ea ve'kamo'a emaleno inake huno hapai'ne “Amuse'ka nehuki 20 kina nami'nana moni'kaleti ali'ya alime ne'ukeno anona'a'ka 100 kina fole aike'na alikate'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nehikeno ala kava ve'kamo'a inake huno hapai'ne “Kakaeya naya mako kaya'a ala kumate kava ya ali'ka yakaisana lo'kiya'ka kamoe.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mako ali'ya ve'ka'amo'a emaleno make he “Amuse'ka nehuki nami'nana 20 kina'ka ma hane'ne. Ani moni ali'na u'na hayavaite'na fala'kimale'noateti ali'ne'na ne'kamoe. ");
INSERT INTO ino_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nakaeya kakoana lo'kiya ke'ake ve'ka mai'nanake'na koli'ka nehoe. Kakaeya mako vaya'moki male'naya yana hapafale'ka ne'ali'ka fate vaya'moki hoya'apifi ha'kale male'naya ne'yana kakaeya kumaya'ya hana yafe koli'ka nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nehikeno ala kava ve'kamo'a inake huno hapai'ne “Kakaeya havi ali'ya ve'ka mai'nane. Kakaeya kakai'ka kakeleti kavale'na kake hukatekauve. Kakaeya ako nake'ne'ka ‘Lo'kiya ke'ake ve mai'ne.’ hu'ka lamake nehane. Mako vaya'moki male'naya yana hapafale'na ne'ali'na fate vaya'moki hoyafati ha'kale male'naya ne'yana kumaya nehoa yana ako nake'nane. ");
INSERT INTO ino_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Inani kava nehu'kae'maki na kava hike'ka mani moni'ni moni ne'malaya nopi o'male'nanakeno moni'nimo ame'a alo hike'na moni'ni'ae amema'ae o'aloe?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anile heti'a mai'naya vaya'aife inake he “20 kina hafaletapa alitapa 200 kina ali'nea ve'ka ameo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nehike'a make hae “Amuse'ka nehunaki ani ve'ka 200 kina ako ali'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nehakeno kava ve'kamo'a inake nehe “Lamake lahapapauve afeno ya ali'nisaya vaya Anumaya Koti'a mako'ae apamike. Apamikea'maki mako ya o'ali'a aise ya'ato'ake ali'nisaya vaya ani ya hapafalekaiye. ");
INSERT INTO ino_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ani kame vaya'nimoki nakaeyafe ‘Kavati o'maike.’ hu'a hu'naya vayana male apavaletetapa nakaeya naulakale hapaeke'a faleo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisasi'a ani hea ke huno avaya ateno Yelusalemu ukefe uno hokote'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Hokoteno Petafasi'ae Petani'ae Olivi yosa hane'nea avima'mo aki'naleka ani kumatala hane'na'akeno uno va'yi hukefe uno lava'nete. Inaleti akaeya ke ne'afi'a ve'kala hune'anateno inake he “Mukaleka hane'nea kumate vi'ao. Visa'a ya'mokitana akesa'ana atupale note mako to'ki afumo ana'au'a nofite atesakeno mai'nekaiyanaki mako ve'kamo'a fai o'mai'nea to'ki afu mai'neanaki ani afu kalu hetana avalelitana e'ao. ");
INSERT INTO ino_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mako ve'kamo'a ‘Ina to'ki afu avaletana utana na kava hukefe neha'ae?’ huno lanafikesiketanaena make hutana hi'ao ‘Ala Neti'amo'a mako ali'ya alikefe hiketa'ae ne'avalo'ae.’ hutana hapai'ao.” huno hanapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yisasi'a hunateke'ana u'na'anaki mi'ko hanapai'nea ya'kona fole ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","34","Fole aike'ana ani to'ki ana'au'amo nofi kalu neha'akeno ani to'ki afumo afo'amoki e'a make hu'a anafine'kae “Na kava hukefe ina to'kimo nofina alitana kasalu neha'ae?” hu'a anafikake'ana make hu'ana neha'ae “Ala Neti'amo'a mako ali'ya alikefe nehiketa'ae ne'avalo'ae.” hu'ana hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hute'ana ani hosikana afumo ana'au avale'ana Yisasite ute'ana kena'ani ali'ana ani afumo akotofule ya'kaimalete'ana Yisasina avale'ana anile faite'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Faita'akeno ne'vike'a ve a'nemoki ku'kena'api hatete'a Yisasi ekefe hea kate ya'kaime ya'kaime u'nae. ");
INSERT INTO ino_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ya'kaime u'nakeno ne'uno Olivi yosa hane'nea avimate lavi'nea kate uno Yelusalemu va'yi hukefe ako eno lava'neteke'a mi'ko akaeya ke ne'afea anaka'moki mi'ko o'ake'naya avame hu lo'kiya ya'a alo huno apavelike'a ake'naya yafe aepa he'a amuse hu'a lusiya hu'a ala kekefafati Anumaya Koti aki ali'a asaka nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inake hu'a nehae “Ala Kava Ve'kati Anumayamo ali'ya alikefe hanakeno hukate'nea ve'ka Anumaya Koti'a kanale manu kamiteno kaya hu'ne. Ko'ku'napi apaipa falu hisea no maisae. Anumaya Kotitimoka hanafi mai'nane huta kaki alita asaka hisune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nehake'a mako Falasi mono vaya ani vaya'ai folakapi mai'nayateti make hu'a Yisasife hae “Ali'ka apaya nehana Nenao kakaeya ke ne'afea vaya'ai ke apama'kike'a afa'a maiyo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nehakeno Yisasi'a inake huno hapapaiye “Nakaeya lahapa'nepauve apavaya a'a a'kanilesayana mika hane'nea yafa'ko'moki afa'a ani ke hu'a naki ali'a asaka hukae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisasi'a Yelusalemu kumate eno va'yi hukefe eno lava'neteno ani kumate vaya'aife avi leno apate'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Avi leno ne'apateno inake he “A'ke'ainaka yuna hesaya yafe o'afi'nayanaki nakaeya yuna he ya lapamisoa ve'ka meni mai'noa'maki no'afe. Ani yana fala'ki'neanaketapa o'afinine. ");
INSERT INTO ino_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mako kana va'yi hisike'a kame vayatapimoki e'a keki'ya lafi kimalete'a mai'a veko nehu'a e'a ali'a haviya hulapatekae. ");
INSERT INTO ino_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lapa'kaeya'ae mafa'netapi'ae mi'ko lafifi mai'nisaya vaya'ae falitapa hano hukae. Falitapa hano hisake'a yafateti kimale'naya nona mi'ko mopafi ana'kupalavikae. Anumaya Koti'a lapaya hisea yafe ne'eketapa akaeya ke no'afea yafe kame vayatapimoki ali'a haviya hulapatekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Yisasi'a ani ke huteno ala mono nopi haino faleno akeana ani nopi mai'naya vaya'moki miya alisaya ali'ya ne'alea vaya aepa heno alino apatalekefe nehuno inake he “Anumaya Koti avopi make huno kamale'neane ‘Nakaeya nona mi'ko vaya'moki Anumaya Koti aki a'a afikesaya no hane'ne.’ huno kamale'nea'maki lapa'kaeya mani nofe afitapa afa yane hutapa afeno ne'maletapa kumaya vaya'moki fala'ki no'apikana nehiketapa kumaya kava nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mi'ko afina ani ala mono nopi alino apaya nehike'a ala mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae mi'ko vaya'aite kava vaya'ae Yisasina haesaya kafe kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kahau ne'aya'maki mi'ko vaya'moki akaeya ke afi'a amuse nehu'a aki ali'a asaka nehaya yafe ala vaya'moki haesaya ka ake'a fole o'ai'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mako afina Yisasi'a ala mono nopi mai'neno ali'a atalu hu'naya vaya'aina alino apaya nehuno Anumaya Koti kanale ke hapa'nepaike'a ala ala vaya'ae mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae akaeyate e'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","E'a inake hu'a afine'kae “Kakaeya hana akufa kaki hane'nea ve'kake'kae mani akufa ali'ya ne'aline? Hana ve'kamo'a ‘Inani akufa ali'ya aleo.’ huno kahapaiteno lo'kiya kami'nike'ka mani ali'ya ali'nane?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Afine'kakeno Yisasi'a inake nehe “Nakaeya'ae ani kava hu'na mako yafe lapafikekauki nahapaiyo Yoni'a li fale ne'apatea yana Anumaya Koti'a hutekeno fale ne'apatefi afa'a ma mopale vaya'moki hutakeno fale ne'apatefi hutapa fole aitapa nahapaiyo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","7","Hike'a “Ina kava ma kava hukune.” hu'a ke hu'a imafi mafi nehu'a inake hu'a nehae “Anumaya Koti'a hutekeno e'ne.” hisunakeno Yisasi'a “Na'ya hiketapa akaeya ke afitapa lapapaipafi maletapa lamake hutapa nohae.” huno hukea'maki lakaeya “Afa'a mopale vaya'moki hutakeno e'ne.” huta hisunake'a mi'ko vaya'moki Yoni'a “Anumaya Koti aune laka hu ve'ka mai'ne.” hu'a hu'naya yafe yafa kayoteti lamakisaketa falikune. Hu'a ke hu'a imafi mafi hute'a Yisasife inake hu'a nehae “Nala'a hute'nifi? Lakaeya o'afi'nonanaketa huta fole aita kaha'opaikaune.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hakeno Yisasi'a apa'kaeyafe inake nehe “Nakaeya'ae ani kava hu'na ali'ya ne'aloa lo'kiyamo aepa'a hu'na fole ai'na lahapa'opaikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yisasi'a aepa heno vaya'aife ma avoya ke inake hu'ne “Mako ve'kamo'a nofi alaka hoya vaiteno mako vaya'ai apayapi ne'maleno inake he ‘Kava hu'netapa ani nofi alaka'afati fa'ko fa'ka hutapa mako'a ne'alitapa mako'a nateo.’ huteno ani hoya aepa ve'ka yatala kana maikefe afaki koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Afaki koteka mai'neno ne'ya afu nelea afina ani hoyamo afo'amo'a mako ali'ya ve'ka'a hutekeno ne'yakaiya vaya'aiteka mako nofi alaka alikefe u'ne. Ne'vike'a hoyale ne'yakaiya vaya'moki atafa hu'a amakite'a ‘O'kamikunaki atale'ka uvo.’ hakeno o'alino ataleno akufa'ake u'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Utekeno eteno mako fate kayo kayo ve'ka'a hutekeno ne'veana ani kava hu'a atafa hu'a amakite'a avuya hisea kava hutete'a ‘O'kamikunaki atale'ka uvo.’ hu'a hakeno o'alino u'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Utekeno eteno mako fate kayo kayo ve'ka'a hutekeno u'nike'a amakikeno kola'a huteke'a hoyafakati avalemale'a ma'ailaka yaka hutale'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yaka hune'atalakeno hoyamo afo'amo'a ina akesa afi'ne ‘Hana'ya hisoe? Ne'mafa'ne'ni nahau nayamopafati ne'nahaiya mafa'ne'ni hutesukeno viseana akaeya hisea ke afikafi o'afikae?’ huno akesa afi'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Afiteno hutekeno vike'a ani hoyale yakai'naya vaya'moki akete'a inake hu'a nehae ‘Mamona mani hoyamo afo'amo mafa'ne. Afo'amo'a falitesikeno'aena mani mafa'nemo'a mani hoya alikeanaki akaeya haeketao. Haesunakeno falisiketa ani hoya lakaiti ya hamalesiketa alikune.’ hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hute'a hoyafati avale'a ma'aileka yaka hutalete'a haekeno fali'ne.” Yisasi'a inake he “Ani kava hu'naya'maki hoyamo afo'amo'a hana'ya hupatekaiye? ");
INSERT INTO ino_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eteno hoya'afi ne'yakaiya vayana alesate hapaesike'a falikae. Fali'a hano hisakeno fate vaya'aife ‘Etapa ani hoyale kava yakaiyo.’ hupatekaiye.” nehe. Hike'a ali'a atalu hu'naya vaya'moki ani ke afite'a inake hae “Avo'neo ani kava ohisae.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nehakeno Yisasi'a apa'kaeyate aulu hapalitata nehuno inake nehe “Anumaya Koti avopi kamale'nea ke aepa'a o'afi'nafe? Ani ke inake hu'ne ‘Vaya'moki yafa no ne'ki'a mako yafafe haviya he hu'a ne'atalaya'maki henaka'a ani yafa'mo'a mi'ko yafa apa'kase'nea yafana lusi kanale lo'kiya yafa no'mo atakonale male'nae.’ hu'a kamale'neane. ");
INSERT INTO ino_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kamale'nea'maki mi'ko vaya'moki ani yafate asaka hulavisayana apa'kufa aino atalaka atalako huno haviya hukea'maki ani yafa'mo'a mako ve'kamo akufale a'koli laviseana akola ani ve'ka amakisikeno mumusopakana huke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hike'a mono hapali'a hapa'nepaiya vaya'ae mono nopi kava vaya'ae inake hae “Lakaeyafe ani avoya ke nehe. Meni avaleta nofi nopi atekaune.” hu'a nehaya'maki mai'naya vaya'aife koli nehu'a atale'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yakai'a mai'ne'a mako vaya Yisasite hupatake'a u'a ani vaya'yakamoki “Lakaeya kanale alakepa vaya mai'none.” nehu'a apa'ke'atike nehu'a inake hae “Akesi nehisunakeno mako ke nehiseana avaleta ala kava ve'ka lo'kiya'a hane'nea ve'kale kake hutesea yafe ayapi atekaune.” nehae. ");
INSERT INTO ino_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ani akesi hukefe ne'vaya vaya'moki inake hu'a nehae “Ali'ka apaya nehana ve'kamoka lakaeya afi'none hu'nana ke lamake'ake ke nehane. Kava vaya'ae afa vaya'ae mako'ke kate ke hapa'nepai'ka lamake hu'ka Anumaya Koti ke ali'ka apaya nehane. ");
INSERT INTO ino_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kakaeya hana akufa kakesa ne'afine? Ta'kesi he yati Lomu kava ve'ka Sisate kanale ta'kesi hesupi ohesune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Afine'kakeno Yisasi'a a'a avataka haya ke ako afi'neno apa'kaeyafe inake huno hapapai'ne “Mako moni alitapa navelike'na akeno.” huno hike'a ali'a avelikeno inake he “Ani monilena nala aukosa'ae nala aki'ae hane'ne?” huno hike'a “Sisa aukosa'ae aki'ae hane'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nehakeno Yisasi'a apa'kaeyafe inake he “Sisa yana Sisateka ne'amitapa Anumaya Koti yana Anumaya Kotiteka ameo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hu'nike'a ani akesi nehaya vaya'moki vaya apaulakale hisea keleti atafa hukefe hu'naya'maki “Lo'kiya ke neheanaketa atafa ohukune.” nehu'a hu'nea ke'ae apa'kesa afi'a apamo'yo ne'ai'a ke ohu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Mako Satiyusi mono ke ne'afea vaya'moki Yisasite e'nae. Ani vaya'moki “Vaya fali'nisayapati ete'a he'otikae.” hu'a nehaya vaya'moki Yisasite e'a inake hu'a afine'kae “Ali'ka apaya nehana ve'ka Mosese'a lakaeyafe inake huno kamale'ne ‘Mako ve'kamo'a mafa'ne ali o'ate'neno a'a ataleno faliseana akana'amo'a ani a aliteno mafa'ne ali o'ate'neno fali'nea ve'kamo akile mafa'ne alitese.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Naya mako kayati aole alea konaka mai'nayapati ala nepu'apimo'a a aliteno mafa'ne ali o'ate'nea ve'ka fali'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Falitekeno anile akana'amo'a fali'nea ve'kamo ana ali'nea'maki mafa'ne ali o'ateno fali'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Falitekeno anile akana'amo'a aliteke'a mi'ko naya mako kayati aole alea konakamoki ani ana ali'naya'maki mafa'ne ali o'ate'a atale'a fali'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ani kava hume hume e'a atalakeno ani ana henaka'a fali'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naya mako kayati aole alea konakamoki ani a ali'naya yafe vaya'yaka fali'nisayapati ete'a heti'a maisaya afina ani ana hana ve'kamo a hamalekaiye?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Afikakeno Yisasi'a apa'kaeyafe inake hu'ne “Meni afina mopale mai'naya ve a'nemoki ve alike'a a alike'a nehaya'maki henaka kana va'yi hiseana Anumaya Koti'a ‘Kanalene fali'nisayapati hetikae.’ huno hapapai'nisea vaya'moki fali'nisayapati hetisaya afina a'nemoki vele o'maisake'a vemoki a o'alikae. ");
INSERT INTO ino_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ko'ku'napi kayo kayo vaya'kana hu'a maisaya yafe mako'ae ofalikae. Fali'nayapati heti'naya yafe Anumaya Koti mafa'neyaka maikae. ");
INSERT INTO ino_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Mako aise yosale ala ata nelekeno ata kanefe ai'nea'maki ani aise yosa ole'nea afina fali'nisaya vaya hetisaya ke Mosese'a afiteno inake he ‘Anumaya Koti'a Epalahamu'aki Aisa'ki'aki Ye'kopu'aki apa'kaeya Anumaya Koti'api mai'ne.’ hu'ne. Ani anaka fali'naya'maki ‘Apa'kaeya Anumaya Koti'api mai'ne.’ huno hu'nea kemo'a fali'naya vaya'ai Anumaya Koti'api o'mai'nea'maki ani vaya'ai apa'ku mafa'ne ofali'a afa'a mai'naya yafe ani ke nehe. Anumaya Koti aulakale mi'ko ani vaya'moki akola maike maike hu apavamu ako ali'nae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nehike'a mako mono hapali'a hapa'nepaiya vaya'moki akaeyafe inake hae “Ali'ka apaya nehana ve'kamoka kanale ke hai nehane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hake'a Satiyusi mono ke ne'afea vaya'moki koli hute'a mako'ae afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Afino'kakeno Yisasi'a apa'kaeyafe inake huno apafine'ke “Vaya'moki lakufa alino katikefe Anumaya Koti'a hute'nea ve'ka Kalaisi'a afa'a Teviti akeho'amo mai'ne hu'a haya kemo aepa'a na'yane nehae? ");
INSERT INTO ino_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Teviti'a akai'a Anumaya Kotife yakame kamale'nea pu'ku Samu avopi Teviti'a inake huno hu'neane Anumaya Koti'a Anumaya'nimofe inake hu'ne ‘Naya lamaka'ni ala vaya mai'nayateka e'ka faitopale mai'nisanake'na kame vaya'ka apavale'na kaiyafi apatesuke'a mai'ne'a kakaeyafe ako lakase'ka ala kava ne mai'nane hu'a hukae.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Teviti'a Kalaisife ‘Anumaya'ni mai'nane.’ huno hu'nea'maki na kava hikeno Teviti'a henaka'a alitesea akeho'amofe ‘Anumaya'ni mai'nane.’ hu'ne.” huno apafike'ne. ");
INSERT INTO ino_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Mi'ko vaya mai'ne'a afi'nakeno akaeya ke ne'afea vaya'aife inake hu'ne “Mono hapali'a hapa'nepaiya vaya'aife maitapa halove hu'netapao. Ani vaya'moki apaiyaleka lavino kase'nea kena'api havaili'ne'a u'e'a hisaya yafe nehapaike'a mi'ko ve a'nemoki ali'a anupa hu'a mai'nisaya kumate ne'visake'a ‘Nakaeyafe ala ve'ka mai'nane nehu'a ali'a falu fala hunatesae.’ nehu'a mono nopi'ae emule'ae kava vaya ne'maiya yate faitopale maisaya yafe nehapaiye. ");
INSERT INTO ino_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ani vaya'moki kaite a'ne'aife a'a apavataka nehu'a ‘Mono nopi atalesaya moni male'nisaya moni lameo.’ hake'a nopi hane'nea ya'yaka apamike'a moni'ae hano nehake'a ani kumaya vaya'moki ve a'ne a'a apavataka hu'a ‘Kanale ve'ka mai'ne.’ hu'a hisaya yafe yatala nunamu Anumaya Kotiteka ke hu'a afine'kae. Ani kava hu'naya vaya'aina Anumaya Koti'a kake hupatesea afina lusi apa'kufa apa'kafu kisea yana ala'a alikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisasi'a akeno asaka huno mai'nike'a moni afeno'api'ae vaya'moki “Anumaya Kotiteka amuse ya amikune.” hute'a mako po'kisifi ne'atalae. ");
INSERT INTO ino_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne'atalakeno akeana mako amute o'male kaite a'mo'a eno aole aise haesa monitola anifi atale'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Atalekeno Yisasi'a inake he “Nakaeya lamake hu'na lahapa'nepauve ma kaite ana amute o'male'nea a'mo'a mi'ko ala moni ali'e'a atalaya ve a'ne apa'kaseno ala moni alino eno atale'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ataleke'a ma mi'ko'amoki nesu moni afeno'api afa'a hane'nea'maki ali'ya'a o'malekeno afa'a male'nea moni Anumayamoteka afa'a makoma'a ali'e'a atale'naya'maki ma kaite ana alaki mi'ko ya'a o'male'nea a'mo'a mi'ko male'nea moni'a ne'ya'a miya hisea moni alaki alineno atalekeno avaya a'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mako vaya'moki ala mono nofe inake hu'a hae “Ma nona vaya'moki Anumaya Koti aki ali'a asaka hisaya yafe nesu moni atale'a kanale yafateti konakali'a'ae nona kimale'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nehakeno Yisasi'a inake he “Ma ne'akaya yafa nona mako kana va'yi hiseana mako yafa'mo'a mako yafa'mo akofetule ohanekaiya'maki mi'ko ani no yafa'yaka kapele lavike.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hike'a inake hu'a afine'kae “Ali'ka laya nehana Nenao na afina ani ya va'yi huke? Na akufa avame ya va'yi hinaketa ani kana makale'a va'yi huke huta hukune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Afine'kakeno Yisasi'a inake huno hapapai'ne “Lapa'kaeya maitapa halove hu'netapao haviku apa'ke'atike'ake vaya'moki apa'ke'atike lahapapaisaketapa afikae. Nesu vaya'moki e'a nakaeya naki ne'a'a inake hu'a hukae ‘Nakaeya Anumaya Koti'a hunateke'na e'noa ve'ka mai'noanakeno Yisasi eteno esea kana'a ako eno va'yi hu'ne.’ hu'a hisaketapaena lapa'kaeya apa'kame o'veo. ");
INSERT INTO ino_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mako koteka la nehu'a fate koteka la hisaya ke afikaya'maki lapa'ku lapame'mo'a halekeno o'maino. Inani akufa ya va'yi hukea'maki ma mopa hano hisea kana'a makale va'yi ohuke.” ");
INSERT INTO ino_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Apa'kaeyafe inake huno hapapai'ne “Mako nofi anaka'moki heti'a mako nofi anaka'ae la hisake'a mako mopale vaya'moki heti'a mako mopale vaya'ae la hukae. ");
INSERT INTO ino_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lusiya huno ala imima alike. Alisikeno alu kote kote ala kafu hu'a apa'katesea ya va'yi huke. Alu kote kote kali'ae lusi ya hapauke. Ko'ku'napakati lusi havi lapamo'yo aisea avame'ya hu lo'kiya ya'ko va'yi huke. ");
INSERT INTO ino_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ani lahapapai'noa yana fole ohu'nisike'a nakaeya naki atapa na'kame e'naya yafe lapatafa hute'a ali'a haviya hulapatete'a lapavale'a mono nopi kava vaya'aite'ae kamani kava vaya'ai apaulakale'ae kake hulapatesaya yafe lapavale'a nofi nopi lapatekae. ");
INSERT INTO ino_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lapatekayanaki nakaeya ke ani afina lapa'kaeya hutapa fole aikae. ");
INSERT INTO ino_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Meni lapa'kesa afitapa alakepa hutetapa ‘Ani kanafi na ke hukune?’ hutapa lapa'kesa afitapa lapa o'aiyo. ");
INSERT INTO ino_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ani kanafi heti'nisake'na nakai'ni ke hisaya ke akenopa hale'nea ve'kamo ke lapavayale male'nisuketapa kake nehisake'a mi'ko kame vayatapimoki ani hisaya ke ‘Lapapa'ke'atike ke nehae.’ hu'a mako ke ani kele hu'a ati o'kakae. ");
INSERT INTO ino_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ani afinana afotapimoki'ae neputapimoki'ae lapa'kaitapi anaka'ae vayatapimoki'ae lapavale'a kake hulapatesaya yafe kame vaya'ai apayapi lapatekae. Lapatesake'a mako'atapi folakatapifati apamaki'a kipatesake'a falikae. ");
INSERT INTO ino_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ani afina nakaeya naki lapa'kaeya ne'aya yafenake'a mi'ko vaya'moki apaipa kafa lahapakae. ");
INSERT INTO ino_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ina kava hulapatekayanaki lapa'kenopafatina mako'ke lapayo'kato apu'kai olavike. Olavikeanaki lo'kiya vaitapa maisaya yafe maike maike hutapa maisaya lapavamu alikae.” ");
INSERT INTO ino_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kame ati vaya'moki Yelusalemu kumana e'a mai'a veko hisaketapa akesutapaena ‘Ala kumati ako ali'a haviya hisaya kana ako aupasi he.’ hutapa lapa'kesa afitapa hao heo. ");
INSERT INTO ino_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ani kanafi Yutia mai'nisaya vayana apaune he'a avimateka haiyo. Yelusalemu mai'nisayateti atale'a alu koteka veo. Makoma'a ma'aileka mai'nisayateti ani keki'ya vekofi hai'a ofaleo. ");
INSERT INTO ino_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ani kanafina Anumayamo avopi kamale'naya kemo'a fole aino ne'ya'a alitekeno lamake hukea'maki ke o'afi'a hao'otake kava hu'naya vaya anona'a havi ya apamike. ");
INSERT INTO ino_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Avo'neo ani kanafi aipa'ae mai'nisea a'ae mafa'ne saufa alitete'a nu ne'apamisaya a'ne'ae lusi nahau hune'apatoe. Ala kana ya ani kanafi ma mopafi va'yi hukaiyanakeno Anumaya Koti'a hai vai ya'a ani kanafi akaeya ke'a o'afi'a hao'otake kava nehaya yafe Yuta ve a'ne'aite malekaiye. ");
INSERT INTO ino_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ani kanafi kame vaya'moki yatala hakinaleti hapa'a falikae. Mako vaya apavale'a nofi huli'a u'a fate koteka Yuta nofi o'mai vaya'ae apate'a mai'nisake'a Yuta nofi o'mai vaya'moki e'a Yelusalemu kumana akuya aine'atale'a ani Yuta nofi o'mai vaya anile maike maikete'a Yuta nofi o'mai vaya'moki kava yakaisaya kana hano huke.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yisasi'a inake nehe “Nesu fate fate akufa avame'ya hu yana yake'ae sanafi'ae i'ka'ae mi'ko fate fate kava huke. Hake li'mo'a apaupae nehuno uneno hisea yafe ma mopafina mi'ko koteka vayana koli hukae. ");
INSERT INTO ino_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ko'ku'napi lo'kiya ya hane'nea ya'ko'moki anekinaki hu'a kanake kanake nehu'a fate fate kate u'e'a hisaya yafe mi'ko vaya'moki ‘Ma mopafi na ya va'yi hukefe nehe?’ nehu'a koli apaipa apa'kesa ne'afisakeno apaulakamo'a veko veko nehisike'a apaune ka'ka ailavikae. ");
INSERT INTO ino_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ani ya fole aitesike'naena nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ano hale lo'kiya himamu ya'ae hiyapi eli'na ne'esuke'a nakekae. ");
INSERT INTO ino_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ani avame'ya aepa heno fole aisiketapaena lapa'kufa alino katisea afina makale'a va'yi hiseafene hutapa hetitapa aketapa asaka hutapa akeo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisasi'a avoya ke inake huno hapa'nepaiye “Fi'ki yosa'ae mako yosa'ae akeo. Fi'ki yosa hikifakana yosae. ");
INSERT INTO ino_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ani hikifa yosamo'a atali huteno anupa'a maleketapaena ‘Meni hoya ha'kale kana fole aiye.’ hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ani kava nehaya'maki ani lahapapai'noa avame ya akesayana ‘Anumaya Koti'a kava yakaipatesea kana ako va'yi huke.’ hutapa afikae. ");
INSERT INTO ino_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lamake hu'na lahapa'nepauve meni mai'naya vayana ofali'a afa'a mai'nisakeno ani mi'ko ya va'yi huke. ");
INSERT INTO ino_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ko'ku'na'ae ma mopa'ae ako fanane huka'a'maki nakaeya kemo'a hano ohuno haneke haneke huke. ");
INSERT INTO ino_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Lapa'kaitapi yakaiyo. Haviku atu li nelitata nehutapa haviku ne'ya nesaya yafe'ae lapa'kufale yafe'ae lapa'kesa afifi hutapa mai'nisakeno ani ya'mo'a aino ati'kalapate'nisikeno ala ve'ka ekaiye. Ala ve'ka kalifumo'a nehea ya huno makale'a nehatea kava huno Yisasi'a eno mi'ko ma mopafi vaya'ai apaulakale va'yi hisike'a atali hukae. ");
INSERT INTO ino_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ani yafe lapa'kaitapi yakaiyo. Mi'ko afina Anumaya Kotitekati lo'kiya alisaya yafe afine'kesukeno ani lo'kiya lapami'nisiketapaena ani hao'otake ya va'yi hisea afina Anumaya Koti'a lapa'kufa alino katisiketapa ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na naulakale hetikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yisasi'a mi'ko afina ala mono nopi mai'neno alino apaya hu'nea'maki mi'ko hani'ainaka Olivi yosa hane'nea avimate haino ne'maiye. ");
INSERT INTO ino_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mai'nikeno ko'netike'a mi'ko vaya'moki akaeya ke afikefe mono nopi e'a ali'a atalu nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ala emu ki afina aupasi nehe. Ani emule hale o'ki kai hame'ya ne'ne'a kafu'ae kafa'ae Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe ali'a atalu hu'a ki'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ani emu ki afina aupasi nehike'a mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae ve a'ne'aife koli hute'a “Hana'ya huta Yisasina haesunakeno falise?” hu'a Yisasi haesaya kafe kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","5","Koli nehakeno Sata'a uno Yutasi aipafi haino fale'ne. Yutasi'a mako aki'a Isa'kalioti'a Yisasi aiyalekati aole alea vaya'ae ne'maiya ve'kamo'a apataleno uno mono nopi kava vaya'ae mono nopi ati kava vaya'ae kake huno inake he “Akesi hu'na lahapapaisuketapa Yisasina atafa hukae.” huno hike'a amuse'a nehu'a “Ani kava hisanaketa miya kamikune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nehakeno Yutasi'a “He.” nehuno vaya kulite o'aisea afina kesi kateti Yisasina apavelisike'a atafa hisaya kafe kahau ane'apate. ");
INSERT INTO ino_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hale o'ki kai hame'ya ne'naya kana hokote afina va'yi he. Ani afina kafu'ae kafa'ae Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi'a hao hisaya yafe mako sipi sipi afu ana'au'a he'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ani yafe Yisasi'a Pita'ae Yoni'ae hune'anateno inake nehe “Utana Anumaya Koti'a lapa'kinakomoki apa'kufa alino kati'nea yafe lakesa afita hao hisuna yafe ne'yana utana alitana avatati hi'aketa neno.” huno hunate'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Hune'anateke'ana “Hana nopi uta'a kaesu'ake'kae nehane?” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Neha'akeno inake huno hanapai'ne akeke'ao ala kumate ne'visa'akeno mako ve'kamo'a ala samofi li hefino alili ve'ka kateka fotu huka'ae. Fotu hutetana a'kame ne'utana haino falesea nopi lana'kaeya'ae haitana fale'ao. Haisea nopi utana ani no'mo afo'amofe inake hutana hapai'ao “Alino laya hu ve'kamo'a kakaeyafe inake huno kafine'ke ‘Hana nopi nakaeya ke ne'afea anaka'ni'ae Anumaya Koti'a lakinakomoki apa'kufa alino kati'nea kanae lakesa afita hao hisuna yafe ne'ya nesune?’ nehe.” hutana afike'ao. ");
INSERT INTO ino_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Afine'kesa'akeno hi'yalamu hu'a hanafi kimale nona ako ali'a avatati humale nona ala no'kefa lanavelisiketana ani nopi ne'yati alitana avatati hi'ao huno hanapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hanapaike'ana u'na'a'maki hu'nea kemo'a mi'ko fole ai'nike'ana Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea kana'ae apa'kesa afi'a hao hisaya yafe ne'yana ali'ana avatati hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ne'ya ako nekefe nehu'a Yisasi'ae akaeya ke ne'afea anaka'ae faitopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Faitopale mai'nakeno apa'kaeyafe inake hu'ne “Lapa'kaeya'ae mani ne'ya Anumaya Koti'a lapa'kinakomoki apa'kufa alino kati'nea kana'ae lakesa afita hao hisuna ne'yana lapa'kaeya'ae lo'ka'na nesoa yafe lusiya huno ne'nahaiye. Nete'na lusi nakafu kitesike'na falikoe. ");
INSERT INTO ino_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Lahapa'nepauve ma ne'ya mopale mai'ne'na mako'ae o'nekauvanaki Anumaya Koti'a akola lapa'ku lapame alino katitesike'na Anumaya Koti kava yakaisea kumate u'na nekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mako nofi alakamo li'mo aki'a vaeni Yisasi'a ani li hane'nea ke'ayo aliteno Anumaya Kotiteka ke huno amuse huteno inake huno hapapai'ne “Ma ke'ayo alitapa mi'ko nete nete heo. ");
INSERT INTO ino_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lahapa'nepauve meni aepa he'na nofi alakamo lina mako'ae hu'na o'nekauva'maki Anumaya Koti kava yakaisea kana va'yi hinake'na nekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ina kava huteno kai hame'ya alino Anumaya Kotiteka ke huno amuse huteno alino a'kaya heno ne'apamino inake nehe “Mani kai hame'ya nakaeya nakufae. Lapa'kaeyafe hu'na nakufa atalekauve. Ataletesuketapa ani kai hame'ya nesaya afina nakaeyafe lapa'kesa afifi hutapa maiyo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hike'a ne'ya netakeno nofi alakamo li hane'nea ke'ayo aliteno inake huno hapapai'ne “Ma lina nakaeya kolane. Nahaesake'na falisoana kola'nimo'a lapa'kaeyafe la'ki laviseana Anumaya Koti'a saufa alino lo'kiya vailapate'nea kemo aepa'a alino lo'kiya vaike. ");
INSERT INTO ino_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lo'kiya vaikaiya'maki akekeo nakaeyafe vaya'moki afisaki huno nakesi huno kame ya hunatesea ve'ka nakaeya'ae lo'kano mai'niketa'a la'ayana makopi ne'ya alita'a ne'no'ae. ");
INSERT INTO ino_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka Anumaya Koti'a hunate'nea kate ukoa'maki vaya'moki afisaki huno nakesi huno nakaeya navaleno kame ya hunateno vaya'ai apayapi natea ve'kae avo'neo hu'na nahau hanaki kakufa mai'ka halove hu'ne'kao hu'nae nehoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nehike'a apa'kai'api ke hu'a imafi mafi nehu'a inake hae “Lakaeyapati hana ve'kamo'a ani akufa kava huke?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ani ke hute'a inake hae “Nala'a lakaeyapi lakaseno ala ve'ka mai'ne?” hu'a ani yateti ke ne'vaiye. ");
INSERT INTO ino_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke ne'vaikeno Yisasi'a apa'kaeyafe inake nehe “Ma mopale Isaleli nofi o'mai vaya'ai ala yahauve vaya'moki ‘Ala kava vaya mai'none.’ hute'a ke ne'apama'ki'a ali'ya ke hune'apate'a ‘Nakaeyafe kanale kava ve'kae hu'a hunatesae.’ hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ina kava nehaya'maki lapa'kaeya folakapi ina akufa kava o'malesikeno lapa'kaeyapi aki hanesea ve'kamo'a aise ve'kamo'a nehea kava hise. Kava ve'katapimo'a lapa'kaeya kayo kayo ve'ka maise. ");
INSERT INTO ino_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nala'a ala kava ve'ka mai'ne? Afa'a faitopale mai'neno ne'ya ne'nea ve'kafi? Ne'ya hatino ne'apamea ve'kae? Lamake afa'a faitopale mai'neno ne'ya ne'nea ve'ka ala ve'ka mai'niki nakaeya lapa'kaeya'ae mai'ne'na kayo kayo hunelapatoe. ");
INSERT INTO ino_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Havi kana nakaeyate fole aiketapa lapa'kaeya o'nataletapa nakaeya'ae mai'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ani yafe Afo'ni'amo'a nakaeyafe ‘Kava yakaikane.’ hunate'nea kava hu'na lapa'kaeyafe ‘Kava yakaikae.’ hu'na hulapate'noe. ");
INSERT INTO ino_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ani kava hisuketapa kava yakaisoa kumate mai'netapa nakaeya'ae ne'ya ne'netapa kava vaya'ai hipale faitopale mai'netapa nayatala'a hano huteno naiyalekati aole alea Isaleli nofi vaya'yaka kava yakaipatekae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","Saimonife inake hu'ne “Saimoni Saimoni afeo Sata'a lapa'kaeya nakaeya natalesaya yafe lapatafa huno ‘Hao'otake kava heo.’ huno ano lapavataka hisea yafe ‘Ani vaya nameo.’ huno Anumaya Kotife afike'neanaki Saimonika nakaeyafe ‘Lusi lo'kiya'a hane'ne.’ hu'ka kaipafi afi'ka male'nana ke o'atalesana yafe nakaeya kakaeyafe Anumaya Kotiteka ako afike'noanaki kaipa ai'ka yahae hute'ka vaya'kamoki nakaeyafe apaipafati afisaya yafe apaya ho.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nehikeno Saimoni'a akaeyafe inake nehe “Anumaya'nimoka kakaeya'ae nofi nopi hula'atete'a laha'aesaketa'a faliku'ae hu'na naipa nakesa ne'afoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nehikeno Yisasi'a akaeyafe inake nehe “Pitaka kaha'nepauve meni hani'ainaka ko'kolemo'a ake o'ai'nisike'ka aole'ae mako'ae afina nakaeyafe ‘O'ake'noa ve'kae nehae.’ hu'ka vane hunatekane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Apa'kaeyafe inake huno apafine'ke “Monitapi'ae kutapi'ae lapaiya ano'ae alitapa o'veo hu'na hulapate'noa'maki mako ya ho'ka olapate'nife?” huno apafikeke'a “He'e mi'ko ya kanale ali'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hakeno apa'kaeyafe inake nehe “A'ke'ainaka ani ke lahapapai'noanaki meni afina monitapi hane'nisea'mokitapa alitapa veo. Kutapi hane'nisea'mokitapa alitapa veo. Yatala hakinatapi o'male'nisea'mokitapa ku'kenatapi alu ve'ka amisakeno anona'a yatala hakinatapi lapamise. ");
INSERT INTO ino_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lahapa'nepauve a'ke'ainaka Anumaya Koti ke kamale'naya ke inake huno kamale'neane ‘Hao'otake kava nehaya vaya'ae ali'a lo'kate'nae. Vaya'yakamoki akaeyafe inake hae hao'otake kava'ake ve'ka mai'ne hu'a nehae.’ huno kamale'nayanaki nakaeya hunatesaya kava hisakeno ani ke fole aino ne'ya'a alitekeno lamake nehe hu'a hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Hike'a inake nehae “Anumayatimoka ako aole yatala hakinalana ma hane'ne.” hu'a hakeno apa'kaeyafe inake he “Haine.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","No kuma ataleno mi'ko afina nehea kava huno Olivi yosa hane'nea avimate haino ne'vike'a akaeya ke ne'afea anaka a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Maisea yate va'yi nehuno apa'kaeyafe inake nehe “Anumaya Kotiteka inake hutapa afikeo ‘Sata'a ano lavataka hisea kate lavale'ka olato.’ hutapa afikeo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Ani ke huteno apataleno uno vaya'moki yafa kayo yaka hutalakeno uno nehanea avamete uno ale'ya alo ne'ano Anumaya Kotiteka inake huno afine'ke “Afo'nimoka falisoa ya huki ani havi kana ya'mo'a atu'ake nehea li'kana nehiki kahaisike'kaefe ani li hane'nea ke'ayona nahafalo. Afa'a nakaeya naipa nakesale a'kame o'male'ka kakai'ka kaipa kakesale a'kame malo.” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Afine'kekeno ko'ku'napakati mako kayo kayo ve'kamo'a eno Yisasina lo'kiya ami'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Amitekeno Yisasi'a aipafi maleno akeana lusi kana hu'nea yafe Anumaya Kotiteka mako'ae lusiya huno ke huno afine'kekeno haisemo'a kola'kana huno mopale la'keta'ke huno lavi'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nelavikeno Anumaya Kotiteka afiketeno hetino akaeya ke ne'afea anaka'moki mai'nayateka uno apa'keana apa'kaeya apaipamo'a kana'ake hu'nea yafe ako apau kale'a mai'nakeno uno apa'ke'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Apa'keteno apa'kaeyafe inake nehe “Hae lapa'kaeya lapau kaletapa mai'nafe? Hetitapa Sata'a ‘Hao'otake kava heo.’ huno ano lapavataka hisiketapa o'afisaya yafe Anumaya Kotiteka ke hutapa afikeo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ani ke nehike'a nesu vaya va'yi hakeno Yutasi'a ayatala'a hano huteno aiyalekati aole alea anaka'ae lo'kano ne'maiya ve'kamo'a apavaleno Yisasi haute eno hano nekefe e'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ekeno Yisasi'a inake nehe “Yutasi naha'ka nesana yateti nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nakesi hu'ka kame ya hunate'ka kame vaya'ai apayapi ne'natape?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nehike'a ayatala'a hano huteno aiyalekati mako'ke alea anaka'moki akaeya'ae mai'ne'a haya kava ne'ake'a inake hae “Anumayamoka yatala hakinaleti hapaesupe?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nehakeno apa'kaeyapati mako ve'kamo'a ala mono nopi hokote kava ve'kamo ali'ya ve'ka'a hakefe nehuno yatala hakinaleti lamaka aupalika akesa heno hataka hutalekeno mopafi asaka hulavi'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Asaka hunelavikeno Yisasi'a inake he “La hisaya ya ataleo.” nehuno ayana akesa aepale male'neno akesa alino kanale hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Alino kanale huteteno Yisasi'a mono nopi kava vaya'ae ala mono note ati vaya'aite kava vaya'ae ala ala vaya'ae ani vaya'ae akaeya atafa hukefe e'naya vaya'aife'ae Yisasi'a inake nehe “Lapa'kaeya nakaeyafe ‘Vaya nehapano kumaya'ya nehea ve'ka mai'ne.’ hutapae yatala hakina'ae mi'ko kayo'ae alitapa ne'afe? ");
INSERT INTO ino_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nakaeya mi'ko afina lapa'kaeya'ae ala mono nopi lo'ka'na mai'noketapa natafa ohu'naya'maki Anumaya Koti'a ma kana lapayapi male'niki Sata'a hani'mo afo'amo'a ali'ya alisea kana ako meni va'yi hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hike'a atafa hu'a ala mono nopi hokote kava ve'kamo kumate avale'a ne'vakeno Pita'a haute o'uno afakite a'kame u'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","U'nike'a ani no keki'ya vekofi ata kamalete'a faitopale mai'nakeno Pita'a ani ata kamale'a mai'naya vaya'ae lo'ka'a faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ata kanefete faitopale mai'nikeno mako ali'ya a'mafa'nemo'a Pitana akeno lake lake nehuno inake he “Ma ve'ka Yisasi'ae lo'kano uneno nehea ve'ka mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nehikeno Pita'a inake nehe “Ma a'mafa'ne nakaeya no'akoa ve'kae nehane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aise'a maike'a mako ve'kamo'a Pitana aketeno inake nehe “Kakaeya Yisasi'ae lo'katana ne'mai'a ve'ka mai'nane.” huno hikeno Pita'a inake he “Ma nahaeya'moka nakaeya ani ve'ka o'mai'noe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Henaka'a aise'a maike'a mako ve'kamo'a lo'kiya kefati inake nehe “Lamake lahapa'nepauve ma ve'ka Kalili ve'kakeno Yisasi'ae uneno nehea ve'ka mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nehikeno Pita'a inake nehe “Ma ve'kamoka o'afoa ke nehane.” nehea avayakasa ko'kolemo'a ake ne'aiye. ");
INSERT INTO ino_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Ake ne'aikeno Anumayamo'a aino yahae huno Pitana akeno lake lake hikeno Pita'a akesa afino hao huno Yisasi'a hu'nea ke afi'ne. Ani ke inake hu'ne “Meni hani'ainaka ko'kolemo'a ake o'ai'nisike'ka aole'ae mako'ae afina ‘O'ake'noa ve'kae nehae.’ hu'ka nakaeya naki hu'ka fala'kikane.” huno hu'nea ke Pita'a akesa afino hao huteno hatilavino lusi avi nele. ");
INSERT INTO ino_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yisasina atafa hu'naya vaya'moki kiki hune'ate'a kamuke nehau'a kayoteti amaki'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne'amaki'a kenaleti aulakale nofi ki'a ati kate'ne'a inake hu'a nehae “Kaune laka nehana ve'ka mai'nanaki lahapaiyo nala'a ne'kamakifi hu'ka fole aiyo?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mako'ae alu ke alu ke nehu'a kiki hune'ate'a kamuke hau'nae. ");
INSERT INTO ino_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kamuke nehautakeno kotike'a Yuta vaya'aipi ala ala vaya'ae mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae “Kake hutesune.” hu'a ali'a atalu hake'a Yisasina ani kanisole vaya'ai apaulakale avale'a u'a ate'nake'a Yisasife inake hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Kakaeya lahapaiyo kakaeya Anumaya Koti'a lakufa alino katikefe hukate'nea ve'ka mai'napi?” hu'a hakeno Yisasi'a apa'kaeyafe inake he “Nakaeya lahapapaisoana lamake hane hutapa ani ke afitapa lapaipafi o'malekae. ");
INSERT INTO ino_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mako ke lapafikesuketapaena anona'a ke'nile naha'opaikae. ");
INSERT INTO ino_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Meni aepa he'na ko'ku'napakati e'noa ve'ka vaya'mo alite'nea ve'kamo'na lusi lo'kiya'a hane'nea Anumaya Koti lamaka aupalika'a nakaeya faitopale mai'ne'na akola maikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nehike'a mi'ko anile ali'a atalu hu'naya vaya'moki inake hu'a hae “Kakaeya ani ke hananaki Anumaya Koti mafa'ne'a kakai'kake mai'nape?” hu'a hakeno “Lapa'kaeya nakaeyafe ani ve'ka mai'nane hutapa nehayana lamake nehae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nehike'a inake hae “Akai'a avayafati haesuna ke ako lahapaiketa afunanaki haviku alu vaya'aife ke hisunake'a akaeyafe laha'opaisae.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mi'ko kanisole vaya'moki heti'a Yisasina avale'a Pailati ala kava ve'kale u'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","U'ne'a aepa he'a “Ma kava huno hao'otake kava hu'ne.” hu'a inake nehae “Lakaeya akonana ani ve'kamo'a lakaeya kote vaya'aife ‘Kamani vaya'ai ke ataletapa hao'otake kava heo.’ nehuno lakaeyafe inake he ‘Sisa'a kava ve'kale ta'kesi oheo.’ nehuno ‘Nakaeya Kalaisi'na nakai'nike yahauve ve'ka mai'noe.’ hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nehakeno Pailati'a Yisasife inake huno afine'ke “Yuta vaya'ai yahauve'api mai'nape?” huno afikekeno Yisasi'a inake he “Kakaeya'ka ani ke hai nehane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nehikeno Pailati'a mono nopi kava vaya'ae mi'ko ali'a atalu hu'naya vaya'ae inake huno hapapai'ne “Hao'otake kava hu'ne hutapa hu'naya yana kahau aovana mako hao'otake ya'a o'male'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hike'a lo'kiya kefati inake hu'a nehae “Mi'ko Yutia koteka uneno nehuno vaya'yaka'aife ‘Kamani vaya'ai ke ataletapa ma kava heo.’ huno apavelike'a ‘Ani kava hupatekaune.’ hu'a nehae. Kaliliti ani kava aepa heno hume hume meni male ako e'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailati'a ani ke afiteno inake huno apafine'ke “Ani ve'ka Kalili ve'kafe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Apafine'keke'a “He ani kumateti ve'kae.” hu'a hakeno Heloti'a kava ne'yakaiya kumateti ve'ka mai'ne hu'a haya ke afiteno Helotite hute'ne. Heloti'a ani kanafi Yelusalemu ne'maiye. ");
INSERT INTO ino_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heloti'a Yisasina aketeno lusi amuse nehe. Avake'a afi'neanakeno mako o'ake'naya avame hu lo'kiya yana hinake'na akesoafene nehuno yatala afina Yisasina akesea akesa afi'nea'maki o'ake'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yisasina aketeno mi'ko yafe ke huno afike afike hu'nea'maki Yisasi'a ke anona'ale mako aise ke ohu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ohu'nike'a mono nopi kava vaya'ae mono hapali'a hapa'nepaiya vaya'ae anile heti'a mai'ne'a lusi ke nehu'a “Ina kava ma kava huno havi kava hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hakeno Heloti'ae ati vaya'amoki'ae Yisasina hu'a haviya hutete'a kiki nehu'a kamuke ne'ama'ki'a mako kanale kena ali'a havaitetakeno Heloti'a Yisasife “Pailatite eteno vise.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A'ke'ainaka Heloti'ae Pailati'ae kame fai'ana ne'mai'a kanola'maki meni ani afina ana'kaeya makopi ali'ana konaka neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Pailati'a mono nopi kava vaya'ae Yuta vaya'ai kava vaya'ae vaya'yaka'aefe ke hike'a akaeyate akeno inake huno hapapai'ne “Lapa'kaeya ma kanoe havi kava huno vaya'aife ‘Kamani vaya'ai ke ne'ataletapa havi kava heo.’ huno hapa'nepaiye hutapa hayana nakaeya kake hutesoa yafe nakaeyate avaletapa e'naya'maki akeo nakaeya lapa'kaeyatapi lapaulakale kahau aovana ‘Havi kava hu'ne.’ hutapa haya havi kavana alaki mako'ke'ato'a alaki ohu'ne hu'na aipafi ake'noe. ");
INSERT INTO ino_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","16","Ake'noanaki Heloti'a ani kava huno akeana lakaeyatefe ‘Ete'ka uvo.’ huno hute'ne. Akeo mani ve'ka falisea hao'otake kava ohu'nea yafe afa'a aumomo malete'na akesa alite'na kayo amite'na atalesukeno afa'a vise.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mi'ko kafu'ae kafa'ae ala emu ki afina ala kava kanomo'a mako'ke ve'ka nofi nopi hutekeno mai'nea kanoe vaya'moki apa'ki akeno apa'kasea ve'kae “Hano hanaki uvo.” huno hute'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hute'nea'maki mi'ko ali'a atalu hu'naya vaya'moki ke nehu'a inake hae “Yisasina haesakeno falise. Lakaeya Palapasife nofi nopati hano hise huta aki ne'aone.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ani Palapasi'a ala kumate vaya'aife inake he “Kamani vaya'ae la hiketao.” huno mako ve'ka hano kite'nea yafe nofi nopi hute'naya ve'ka mai'nike'a akaeyafe ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nehakeno Pailati'a Yisasife “Atalesukeno vise.” huno apa'kaeyafe mako'ae apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Apafine'keke'a apa'kaeya ala kekefafati inake hae “Yofo yosale nili aitetapa asaikeno falino. Yofo yosale nili aitetapa asaikeno falino.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailati'a mako'ae eteno apa'kaeyafe inake huno apafine'ke “Na'ya hiketapa ani ke nehae? Hana akufa havi kava hu'ne? Nakaeya kahau aovana falisea hao'otake kavana ohu'nea yafe afa'a aumomo malete'na akesa alite'na sefu amite'na atalesukeno afa'a vise.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ani ke hea'maki apa'kaeya lusi lo'kiya ke nehu'a ala kefati inaki hu'a hae “Yofo yosale nili aitetapa asaikeno falino.” hu'a lo'kiya kefati huke huke hakeno apa'kaeya kemo'a Pailati'a hea ke ano ati'kate'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ano ati'kaeya yafe Pailati'a haya ke afiteno Yisasife “Yofo yosale nili aitetapa asaikeno falino.” huno ati vaya hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Palapasi'a vaya'aife “Kamani vaya'ae la hiketao.” huteno mako kano hano kite'nike'a nofi nopi hute'naya kanoe ke hu'a afike afike haya yafe Pailati'a “Hano hananaki uvo.” hu'nea'maki mi'ko vaya'moki Yisasife “Yofo yosale nili aitetapa asaikeno falino.” hu'naya ke a'kame nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yisasina avale'a ne'u'a Saimoni'a Sailini kumateti ve'ka hoya'afakati kate ne'eke'a ati vaya'moki atafa hute'a yofo yosa ali'a ayo'nale kofitete'a “Yisasi a'kame kofi'ka uvo.” hu'a hute'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nehake'a mi'ko vaya'ae a'ne'ae a'kame ne'u'a a'nemoki avi yakame nehu'a avi nele'a hapau hume hume ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne'vakeno Yisasi'a aino yahae huno ne'apa'keno inake he “Yelusalemu a'nemokitapa nakaeyafe avi letapa o'nateo. Avi lesune hutapaena lapa'kaeyatape'ke avi neletapa mafa'netapike aviletapa apateo. ");
INSERT INTO ino_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akekeo henaka'a mako havi kana va'yi hisike'a inake hu'a hukae ‘Nahamo a'nemokitapa lusi amuse hutapa maiyo. Mafa'ne ali o'ate'naya a'nemokitapa amuse hutapa maiyo. Mafa'ne nu no'amisaya a'nemokitapa amuse hutapa maiyo.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ani havi kanafi Aepa he'a ala avimafe inake hu'a hukae ‘Mehai ali'ka lati kao.’ hu'a hukae. Aise avimafe inake hu'a hukae ‘Mehai ali'ka ai'ka ati'kalato.’ hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nakaeya haekafa atakana ve'ka faipa kava ohu'noa ve'ka mai'noke'a mani kava hunenate'naya'maki lapa'kaeya vai'nea atakana vaya faipa kava nehaya vaya mai'nayanake'a hana akufa kava hulapatekae?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yisasina hakefe avale'a ne'u'a aole hao'otake kava hu'na'a ve'kala'ae hanakefe anavale'a ne'vae. ");
INSERT INTO ino_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Akenopa Ayamufae hu'a aki ne'aya avimate ute'a avale'a aole hao'otake kava hu'na'a kanola'ae yofo yosale nili aite'a asaimale'nae. Mako ve'ka Yisasi haoka aupalika nili ai'a asaimalete'a mako ve'ka aya lamaka aupalika nile aite'a asaimale'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nili aite'a asaimale'nakeno Yisasi'a Anumaya Kotiteka inake huno ke nehe “Afo'nimoka ma vaya'moki hao'otake kava nehaya kavafe ‘Ina kava nehune.’ hu'a afi'a alakepa ohu'naki ani yafe lahapaove lapatove nehu'ka kaipa falu yapati ani hao'otake ya'api ali'ka atalepato.” hu'ne. Hike'a ati vaya'moki kena'a ali'a fa'ko fa'ka hukefe kasi yo'kalokana yo'kalo nelakeno apa'kaseno haiya ve'kamo'a ne'ale. ");
INSERT INTO ino_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kasi yo'kalokana yo'kalo le'a ne'alike'a vaya'moki ali'a atalu hu'a heti'a mai'ne'a aulu nehake'a kava vaya'moki hu'a haviya hune'ate'a inake nehae “Mako vaya'ai apa'kufa alino kati'nea kano Anumaya Koti'a lakufa alino katikefe hapaliteno hute'nea ve'ka mai'niseana akaeya'a akufa alino katise.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Nehake'a ati vaya'moki ani kava hu'a kamuke hau'nae. Haka ohu nofi alakafati fole ai'nea lina amite'a inake hae “Kakaeya Yuta vaya'aipi yahauve kano'api mai'nisanana kakai'ka kakufa ali'ka kateo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Akenopale hane'nea avo'mo'a inake nehe “Mani ve'ka Yuta vaya'aipi ala yahauve ve'ka mai'ne.” hu'a kamale'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mako hao'otake kava hu'nea kano yofo yosale nili ai'a asaimale'naya kanomo'a Yisasife kamuke nehauno inake nehe “Anumaya Koti'a lakufa alino katikefe hukate'nea ve'ka mai'nape? Kakaeya ani ve'ka mai'nisanana kakaeya'ae la'akaeya'ae yosaleti ali'ka ataleketa lavino.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hikeno mako hao'otake kava hike'a yofo yosale nili aite'a asaimale'naya ve'kamo'a ani ke afiteno ke ne'ama'kino inake nehe “Vae la'akaeya hao'otake kava hu'no'a anona'a makopi la'akaeya'ae nili aite'a asai'nayanaketa'a faliku'ae. Kakaeya Anumaya Kotife koli nohu'kae ani ke nehape? ");
INSERT INTO ino_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","La'akaeya hao'otake ya hu'no'a anona'a kanale laha'a'a asai'naya'maki ma ve'ka mako hao'otake ya'a o'male'nea ve'ka ani kava hute'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ani ve'kamo'a Yisasife inake nehe “Yisasika kava yakaikefe esana afina nakaeyafe kanale kakesa afi'ka nameo.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nehikeno Yisasi'a akaeyafe inake nehe “Lamake hu'na kaha'nepauve meni afina nakaeya'ae kanale maike maike nehaya kumate lo'kata'a haita'a maiku'ae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ani kanafi yakemo'a eno folakate nehikeno yake nelea ya'a hano hikeno mi'ko koteka lusi hani kiteno une afafa eteno alino hale'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Hani ne'kikeno ala mono nopi a'a asaimale'naya kenamo'a folakapati vala ai'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Vala aitekeno Yisasi'a ala kekefafati inake nehe “Afo'nimoka naku mafa'ne meni kayapi ne'maloe.” nehikeno avamu'a hano hikeno fali'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Fali'nike'a anile mai'naya ati vaya'aite kava ve'ka'apimo'a Yisasi'a hu'nea kavana aketeno Anumaya Koti aki alino asaka nehuno inake nehe “Lamake mani ve'ka hao'otake kava ohu'nea ve'ka alakepa ve'ka mai'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","“Na kava hutesafi aketetae.” hu'a ali'a atalu hu'naya vaya'moki mi'ko hu'nea kava akete'a hapau hutete'a havikafa ali'a fatakaume fatakaume no'apileka u'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","U'naya'maki mi'ko vaya'ae Kaliliti a'kame e'naya a'neyaka'ae mako aise'a afakite mai'ne'a hute'naya kavana ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mako alakepa ve'ka Yosefe'a Yuta vaya ne'maiya kumate Alimatia kumateti ve'ka anile mai'ne. Ani ve'kamo'a Yuta vaya'ai kanisole'api mai'neanaki “Yisasina hakaune.” hu'a haya kavafe “He kanalene haeyo.” huno ohu'nea'maki ani ve'ka Anumaya Koti'a kava yakaipatesea kana'ae akeva mai'nea ve'kae. ");
INSERT INTO ino_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yosefe'a Pailatite uno inake huno afine'ke “Kanale nakaeya Yisasi akufa'a alisufe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Afine'kekeno “He.” hikeno yofo yosaleti asaino akufa'a aliteno mako yosa'ae kenaleti akufale hayateno mako vaya kio'apate'naya yafa'kapi alino uno kite'ne. ");
INSERT INTO ino_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ani yu'mepa Sapati afina va'yi hukefe hike'a ali'a avatati hukefe haya afina Sapati ako aepa hekefe nehike'a ani kava nehe. ");
INSERT INTO ino_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nehike'a Kaliliti Yisasi'ae e'naya a'neyaka Yosefe'a yafa'kapi ki ne'ateke'a a'kame u'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Akete'a no'apile ete'a u'a akufale faletesaya mana'ake masave ali'a avatati nehakeno Sapati afina va'yi hike'a ke male male'nea ke a'kame male'a mai'a falu hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sota'mo hokote afina ko o'ali'nike'a ani a'nemoki ali'a avatati humale'naya mana'ake masavena ali'a Yisasina kite'naya kelileka u'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","U'a akayana keli avayale ai'a a'kanimale'naya yafana ako ali'a a'kolitale'nakeno avayale o'male'nike'a ani yafa kapi fale'a hai'a ake'naya'maki Yisasi akufa o'ake'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","O'ake'naya yafe “Hanate mai'ne?” hu'a lusi apa'kesa ne'afikeno akekeo aole ve'kalana apaulaka alino katea ku'kena havaili ve'kala va'yi neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Va'yi ha'ake'a a'neyakamoki lusi koli hu'a ape hake'ana ani aole ve'kala'mokani apa'kaeyafe inake hu'ana neha'ae “Na'ya hiketapa afa'a mai'nea ve'kae fali'naya vaya'ai kelile kahau ne'ae? Malena o'mai'niki fali'neapati ako heti'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kalili mai'neno lahapapai'nea ke lapa'kesalekati afitapa hao hutapa afeo. ");
INSERT INTO ino_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Inake hu'ne ‘Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka nakesi hisike'a hao'otake kava nehaya vaya'moki natafa hute'a yofo yosale naha'a asaisake'na falikoe. Falitesuke'a kinate'nisake'na aole afina kelifi maite'na aole'ae mako'ae alea kanafi fali'nisoapati hetikoe.’ hu'ne. Ani hu'nea ke'aena lapa'kesa afitapa hao hutapa afeo.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Neha'ake'a Yisasi'a hu'nea ke apa'kesa afi'a hao hute'a keli ne'atale'a ete'a ake'naya kava'ae afi'naya ke'ae Yisasina ayatala'a hano huteno aiyalekati mako'ke alea anaka'ae akaeya ke ne'afea ve a'ne'ae hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Malia'a Makatala kumate a'ae Yohana'ae Yemisina ita'amo'a Malia'ae mako a'neyaka'ae akaeya ke ne'afea anaka'ae hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hapa'nepaiya'maki apa'kesa afeana “Afa kekana ke nehae. Lamake nehafi apa'ke'atike nehafi?” hute'a afi'a apaipafi o'male'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Afi'a apaipafi o'malakeno Pita'a hetino naku naku uno kite'naya yafa kapi uno ape hu'neno akeana Yisasina hayavaite'naya kena'ake ake'ne. Aketeno akesa afime afime no'aleka u'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ani afina aole ve'kala Yisasi ke ne'afi'a ve'kala Emeasi kumate ukefe neha'ae. Ani ka'mo'a Yelusalemuti Emeasi u'nea ka aise'a yatala ka ileveni kilomita hane'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ani aole ve'kala kate ne'u'ana ani kava hu'naya yafe kake hume hume ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ne'u'ana ani yafe kake hu'ana i'afi o'afi hume ne'va'akeno Yisasi'a ana'kame eno ana'kaeya'ae u'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lo'ka'a ne'u'a ake'na'a'maki anaulakamo'a hani'ali ko'ali hike'ana Yisasina ake'ana alakepa ohu'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ake'ana alakepa ohu'na'akeno Yisasi'a ana'kaeyafe inake huno anafine'ke “Na yafe kake hume hume ne'va'ae?” huno anafikeke'ana heti'ana mai'na'akeno anaulafinamo'a ati'ka'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mako ve'kamo aki'a Kaliopasi'a inake nehe “Mi'ko Yelusalemu nata vaya'moki meni afina hu'naya kava ako afi'naya'maki kakaeya mako'ke'amoka o'afi'nape?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hikeno inake huno anafine'ke “Hana kavafe neha'ae?” huno anafikeke'ana inake hu'ana neha'ae Yisasi'a Nasaleti ve'kae o'afi'nape? Ani ve'kamo'a aune laka hu ve'ka mai'neno Anumaya Koti aulakale'ae vaya'moki apaulakale'ae lusiya huno o'ake'nona avame hu lo'kiya ya alo nehuno lusi lo'kiya ke'a lahapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lahapai'nea'maki lakaeya mono nopi kava vaya'ae kava vayati'ae akaeya atafa hu'a kake hutete'a “Falikane.” hute'a yofo yosale ha'a nili aite'a asaikeno fali'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","23","Fali'nea'maki lakaeya akaeyafe “Anumaya Koti'a lakufa alino katikefe hutekeno e'nea ve'kae.” huta lame'atiti nehune. Mako ya'ae hamale'naya kavana olaka hu'nayanaki meni lakaeya'ae ne'maiya a'neyaka natetepi Yisasina kite'naya kelile u'a akayana Yisasi akufa o'male'nea yafe ete'a e'a inake hu'a lahapai'nae “Lakaeya ko'ku'napi kayo kayo ve'kala ne'ana'konake'ana inake hu'ana lahapai'na'ae ‘Yisasi'a ako hetino mai'ne.’ hu'ana ha'a ke lahapai'aketa ne'one.” hu'a nehaketa lakaeya lusiya huta atali atalu hu'none. ");
INSERT INTO ino_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Atali atalu hu'nonake'a mako lakaeya'ae mai'naya vaya'moki ani kelileka u'ne'a akayana a'neyakamoki hu'naya ke mi'ko lamake hu'naya'maki Yisasina o'ake'nae hu'ana ha'nepai'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ha'nepai'akeno ana'kaeyafe inake nehe “Lana'kaeya lana'kesa o'male'nea ve'kala mai'na'ae. Makale'a lanaipa lana'kesamo'a hao nohiketana mi'ko Anumaya Koti aune vaya'moki kamale'naya ke afitana haletana lanaipafi o'male'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ani aune vaya'moki inake hu'a kamale'nae ‘Anumaya Koti'a lakufa alino katiseafe hutesea ve'kamo'a lusi akufa akafu kisea ya hano hutesikeno ano hale himamu lo'kiya ya'ae kuma'ale uke.’ hu'a kamale'naya ke o'afi'na'afe?” nehe. ");
INSERT INTO ino_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mosese'ae mi'ko Anumaya Koti aune vaya'ae akaeyafe kamale'naya ke aepa heno aepa'a huno kafino hana'nepaiye. ");
INSERT INTO ino_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Hanapaike'ana ukefe va'a koteka ako va'yi ha'akeno Yisasi'a mako'ae ka ukefe nehike'ana akete'ana atafa nehu'ana inake ha'ae “La'akaeya'ae maiyo. Yake ako lavino falesikeno makale'a hani kike.” hu'ana ha'akeno ana'kaeya'ae maikefe nopi haino fale'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","31","Ana'kaeya'ae ne'ya nekefe faitopale mai'neno kai hame'ya aliteno Anumaya Kotiteka ke huno amuse huteno a'kaya heno anami'ne. Anamike'ana ne'ali'akeno anaulakamo'a inanile haleke'ana Yisasina ake'ana alakepa hu'na'ae. “Akaeyamae.” hu'ana neha'akeno anile fanane hike'ana mako'ae Yisasina o'ake'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ani yafe ana'kai'ani hu'ana i'afi o'afi hu'ana inake ha'ae “Vae la'akaeya kate ne'o'akeno akaeya kanale ke laha'apaino Anumaya Koti ke kamale'naya avopi huno kafino aepa'a laha'a'nepaiketa'a la'aipamo'a vakali hu'ne.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hute'ana makale'a heti'ana ete'ana Yelusalemu u'ana Yisasi ayatala'a hano huteno aiyalekati mako'ke alea vaya'amoki'ae mako vaya'yaka'ae ali'a atalu hu'a mai'nake'ana apa'ke'na'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aketa'ake'a inake hu'a hanapai'nae “Lamake Anumayatimo'a ako fali'neapati heti'nikeno Saimoni'a ako ake'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nehake'ana ana'kaeya'ae kateka hu'nea avake'a hapa'nepai'ana inake ha'ae “Kai hame'ya a'kaya heno nela'amikeno la'aulaka haleketa'a Yisasina aketa'a alakepa hu'no'ae.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ani ke neha'akeno Yisasi'a folaka'apifi heti'neno inake nehe “Yuna lapa'kesa afitapa maiyo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hapa'nepaiya'maki apa'kaeya koli nehu'a atali atalu nehu'a akaeyafe “Afe kano eno mai'ne.” hu'a koli nehae. ");
INSERT INTO ino_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Koli nehakeno Yisasi'a apa'kaeyafe inake he “Na'ya hiketapa lapaipa afitapa haviya nehae? Na'ya hiketapa lapa'kesa lapa ne'aiye? ");
INSERT INTO ino_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lapa'kaeya naya'ae naiya'ae akeo. Akekeo nakaeya Yisasi'na e'na mai'noe. Nakufale name alitapa akeo. Afe'mo'ae hininana akufa ame'ae ayamufa'ae o'male'nina'maki nakaeya nakufa name'ae nayamufa'ae hane'niketapa ne'akae.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ani ke huteno aiya aya'ae apave nele. ");
INSERT INTO ino_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Apave nelike'a apamo'yo ne'ai'a lusi amuse haya yafe “Lamakefi ake'atike nehe?” hu'a aole apa'kesa ne'afi'a akaeyafe apa'kesa lapa ne'aikeno apa'kaeyafe inake nehe “Nesoa ya hane'nife?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Apafikeke'a atafi kate'a male'naya faya amikeno alino apaulakale kutala aino ne'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yisasi'a apa'kaeyafe inake nehe “Lapa'kaeya'ae lo'ka'na mai'noa afina make hu'na lahapapai'noe mi'ko nakaeyafe kamale'naya ke Mosese ke'ae Anumaya Koti aune vaya'moki ke'ae Anumaya Kotife Samu avopi yakame kefati kamale'naya ke'ae mi'ko ani nakaeyafe kamale'naya ke fole aino ne'ya'a alitekeno lamake huke hu'na lahapapai'noane.” nehe. ");
INSERT INTO ino_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huteno ani kamale'naya ke afi'a alakepa hu'a afisaya yafe apa'kesamo'a haleke'a afi'a alakepa hu'nae. ");
INSERT INTO ino_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Inake huno hapapai'ne “Make hu'a kamale'nayane Anumaya Koti'a lapa'kufa alino katiseafe hutesea ve'kamo'a lusi akufa akafu kisea ya aliteno falitesike'a kite'nisakeno aole afina kelifi maiteno aole'ae mako'ae alea kana (napa 3 afina) fali'niseapatina eteno hetike. ");
INSERT INTO ino_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Heti'nike'a Yelusalemu aepa he'a mi'ko aupalika kuma'yakale inake hu'a hukae ‘Yisasi'a lapa'ku lapame alino kati'nea yafe lapa'kesa ne'afitapa aitapa yahae nehutapa hao'otake yatapi atalesakeno Anumaya Koti'a lapahaove lapatove nehuno yuna aipafati atalelapatekaiye.’ hu'a hapapaisaya yafe kamale'nayane. ");
INSERT INTO ino_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mi'ko lapaulakafati ake'naya kavafe mi'ko vaya hapapaiyo. ");
INSERT INTO ino_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Afeo nakaeya Afo'nimo'a ‘Lapamikoe.’ huno hu'nea ve'ka Fate Akufa Avamuna nakaeya lapa'kaeyate hutekauvanaki lapa'kaeya mani ala kumate mai'nisakeno eno hanafakati lo'kiya lapamitesiketapa utapa nakaeya ke hapapaiyo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Ani ke huteno apavaleno Petani kumate uno ayana alino asaka nehuno inake nehe “Anumaya Koti'a lo'kiya'aleti lapaya hise.” nehuno apataleno ko'ku'napaka nehaiye. ");
INSERT INTO ino_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","Haiteke'a apa'kaeya aki ali'a asaka hute'a lusi amuse nehu'a ete'a Yelusalemu u'a mai'ne'a mi'ko afina ala mono nopi mai'ne'a Anumaya Koti aki ali'a asaka huke huke nehae. ");
INSERT INTO ino_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A'ke'ainaka Anumaya Koti'a ma mopa alo ohu'nea afina Yisasi'a mako aki'a Kemo'a mai'neno Anumaya Koti'ae lo'ka'ana mai'na'ane. Ani Kemo'a Yisasi'a akai'a Anumaya Koti mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mai'neno ma mopa alo ohu'nea afina ani ve'ka Anumaya Koti'ae lo'ka'ana mai'na'ane. ");
INSERT INTO ino_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anumaya Koti'a ha'nepaikeno Yisasi'a mi'ko ya alo hu'ne. Yisasi'a alo ohu'nea yana mako yana o'male'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yisasi'a mi'ko vaya apavamu ne'apamea ve'ka mai'neanakeno ani avamu'amo'a vaya ano halepatesea ya'a hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ani ano hale ne'apatea ya'mo'a hani'ki'nea yapi ano ha neleanaki hani'mo aku'ainaka ano hale'nea yana asu ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anumaya Koti'a mako ve'ka hute'ne. Ani ve'kamo aki'a Yoni'ae. ");
INSERT INTO ino_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ani ve'kamo'a ano halepatesea ya'mo ke hapapaikefe e'ne. E'nike'a akaeya keleti mi'ko vaya'moki ano hale yafe “Lamake hane.” hu'a Yisasife afi'a apaipafi malete'a apa'ku'a ami'a alakepa hute'a maisae huno e'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoni'a ani ano hale ya'mo aepa'a o'mai'nea'maki afa'a ano hale ya'mo aepa'a hane'nea ve'kae hapapaikefe e'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lamake ano hale ya'mo'a ma mopale eno mi'ko vaya ano halepatesea yafe e'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yisasi'a ma mopa alo humale'nea ve'ka eno ma mopafi mai'nea'maki ma mopafi vaya'moki ake'a alakepa ohu'a aepa'a afi'a ha ole'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akai'a kumate e'nea'maki akai'a vaya'moki ali'a falu fala huo'ate'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Avale'a no'atake'a mako'ke mako'ke'moki ali'a falu fala hune'ateno Yisasina avale'nea ve'kamo'a Yisasife afino aipafi male'neno aku'a amino alakepa hu'nea ve'ka Yisasi'a lo'kiya'aleti Anumaya Koti mafa'ne alite'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ani vayana vaya'moki kolateti ali no'apataya'maki Anumaya Koti'a akai'a alipate'ne. Vaya'moki apa'kufa ake'a hapa'ye hu yateti ali no'apataya'maki Anumaya Koti'a akai'a alipate'ne. Vaya'moki mafa'ne alipatesaya apa'kesa afea yateti ali no'apataya'maki Anumaya Koti'a akai'a alipate'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yisasina mako aki'a Kemo'a alitetekeno ve mai'neno lakaeya'ae mai'niketa akaeya fate akufa ano hale lo'kiya'a ne'akone. Ani ve'ka Anumaya Koti alaki mako'ke mafa'ne'a mai'neanakeno afo'amo'a akai'a fate akufa ano hale lo'kiya'a ami'ne. Amikeno vaya alino kayone hu ya'ae lamake hu ya'mo'ae akaeya aipafina havaite'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoni'a akaeyafe kate kate nehuno inake huno fole ai'ne “Ma ve'kae a'ke'ainaka inake hu'na lahapapai'noe henaka'a mako ve'ka ekaiye. Ani ve'ka nakaeya nakaseno mai'nea ve'ka ekaiya'maki nakaeya ali o'nate'naya afina ako mai'nea ve'kakeno nakaeya ako nakase'ne hu'na lahapapai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Vaya alino kayone hu ya'a nesu'ya hane'neapati lakaeya mi'ko'amokita laha'mateno kanale manu lamiteno mako'ae nesu yate kanale manu nelame. ");
INSERT INTO ino_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anumaya Koti'a ke male male'nea ke Mosesena hapaikeno hapapai'nea'maki vaya alino kayone hu ya'ae lamake hu ya'ae Yisasi Kalaisi'a lami'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Alaki mako'ke ve'kamo'a Anumaya Kotina alaki o'ake'ne. Lamake mi'ko vaya'moki o'ake'nae. O'ake'nafa alaki mako'ke mafa'ne'amo'ke Anumaya Koti haute mai'neateti eno afo'amo aepa'a huno kafino lahapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuta vaya Yelusalemu mai'nayateti Livae nofi vaya'ae mono nopi kava vaya'ae hune'apate'a inake hu'a nehae “Yonife kakaeya nalakae? hutapa afikeo.” hu'a hupate'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hupatake'a u'a afikakeno Yoni'a ani ke fala'kino nohea'maki ani ke huno fole aino inake nehe “Nakaeya Kalaisi'na Anumaya Koti'a lakufa alino katikefe hute'nea ve'ka lamake nakaeya o'mai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nehike'a “Ani ve'ka o'mai'nana'maki kakaeya nalaka mai'nane? Ilaiyaka mai'nape?” hu'a afikakeno “He'e nakaeya ani ve'ka o'mai'noe.” nehike'a “Anumaya Koti aune ve'ka mai'nape?” hu'a hakeno “He'e.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nehike'a inake hu'a nehae “Lahapaiyo kakaeya nalakae? Eteta uta hulataketa e'nona vaya'aina lafike'naya yate anona'a hapapaisuna yafe kakaeya kakesa afi'ka na'yane ke nehane?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nehakeno Yoni'a inake huno hapapai'ne “Nakaeya ma ve'ka mai'noe. Nake ai ve'ka mai'noe. Ka'me koteka mai'ne'na kate kate hu ve'ka mai'ne'na inake hoe ‘Anumayamo visea ka valitapa alakepa heo.’ hu'nae nehoe.” nehe. Ani ke Aisaiya'a Anumaya Koti aune ve'kamo'a a'ke'ainaka ako humale'nea ke. ");
INSERT INTO ino_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ani afikesaya ke ali'a ne'vaya vayana Falasi mono ke ne'afea vaya'moki hupate'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ani vaya'moki Yonife inake hu'a afine'kae “Kalaisika'ae Ilaiyaka'ae Anumaya Koti aune ve'ka'ae o'mai'nana'maki na'ya hike'ka lina fale ne'apatane?” hu'a afike'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Afikakeno Yoni'a inake he “Nakaeya litafateti fale nelapatoa'maki lapa'kaeya folakapi mako o'ake'naya ve'ka heti'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Heti'neanakeno ani ve'ka henaka'a ekaiye. Nakaeya afa ve'ka mai'noanake'na akaeya aiya'kale aesoana o'natekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yotani li'mo mikakaya falika Petani kumate Yoni'a li falepate'ne. Ani hu'naya kavana Petani kumate hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Havate'a kotike'a Yisasi'a Yoniteka ne'ekeno Yoni'a ne'akeno inake nehe “Akekeo ma ve'ka Anumaya Koti Sipi Sipi Ana'au'a haesakeno falisea yateti ma mopale vaya'ai hao'otake ya'api alino atalesea yafe e'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ani ve'kae mako afina inake hu'na lahapai'noane ‘Henaka'a mako ve'ka ekaiye. Ani ve'ka nakase'nea ve'ka ekaiya'maki nakaeya ali o'nate'nea afina mai'nea ve'kakeno nakaeya ako nakase'ne.’ hu'na lahapapai'noane. ");
INSERT INTO ino_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nakaeya'ni akaeya aepa'a o'ake'noa'maki Isaleli vaya'aipi Yisasi'a esea afina Yisasina apavelikefe u'na lina falepatesoe hu'nae e'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yoni'a inake huno hapapai'ne “Nakaeya akokeno Anumaya Koti Fate Akufa Avamu'amo'a namakana huno ko'ku'napakati haleno elineno akaeya akufale eno ha'kale'nike'na ake'noe. ");
INSERT INTO ino_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nakaeya'ni akaeyafe alaki o'afi'noa'maki Anumaya Koti'a li falepate yate hunateke'na e'noa ve'ka inake huno nahapai'ne ‘Kakaeya ake'nisanakeno nakaeya Fate Akufa Avamu'nimo'a haleno elineno'a mako ve'kamo akufale ha'kalesike'ka akesanana ani ve'ka Anumaya Koti Fate Akufa Avamu'aleti falelapatekaiye hu'ka hukane.’ huno hike'na afi'noe. ");
INSERT INTO ino_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nakaeya ani kava hea yana naulaka'nifati ne'ake'na lahapa'nepauve mamona Anumaya Koti mafa'ne mai'ne hu'na lahapa'nepauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Havate'a kotea'aleka Yoni'a eteno aole ve'kala akaeya ke ne'afi'a ve'kala'ae heti'nae. ");
INSERT INTO ino_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","37","Yisasi'a uneno nehikeno Yoni'a akeno lakelake nehukeno inake nehe “Akekeo Anumaya Koti Sipi Sipi Ana'au'a mika mai'ne.” hike'ana aole Yoni ke ne'afi'a ve'kala'mokani ani ke afite'ana Yisasina a'kame ne'va'ae. ");
INSERT INTO ino_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ne'va'akeno Yisasi'a maino yahae huno ana'keana a'kame ne'va'akeno ana'keteno inake huno anafine'ke “Na yafe ne'a'ae?” huno hike'ana ana'kaeya inake ha'ae “Lapae hanate ne'maine?” hu'ana neha'ae. Lapae kemo'a lakaeya kefatina ali'ka apaya nehana nenao hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yisasi'a inake nehe “Etana ake'ao.” huno hanapaike'ana ani ve'ka'ae u'ana ne'maiya no akete'ana unetike'ana ani afina akaeya'ae lo'ka'ana mai'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yoni'a hea ke afite'ana Yisasina a'kame ne'va'a ve'kala'mokanipati mako ve'kamo aki'a Etalu'ae ani ve'ka Saimoni Pita akana'amo'ae. ");
INSERT INTO ino_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Etalu'a hokoteno uno kahau ano nepu'amona Saimonina akeno fole aiteno inake huno hapai'ne “Anumaya Koti'a lakufa alino katisea yafe hute'nea ve'ka ako ake'no'ae.” nehe. Anumaya Koti'a lakufa alino katisea yafe hute'nea ve'kamo mako aki'a Kalaisi'ae. ");
INSERT INTO ino_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Saimonina avaleno Yisasite ne'vikeno Yisasi'a akeno lakelake nehuno inake nehe “Kakaeya Saimonika Yoni mafa'nemoka kakaeya kaki fate kaki malekauve Sifasikae Pitakae hu'na malekauve.” nehe. Ani akilana lakaeya kefina yafa'mokae huno male'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Havate'a kotikeno Yisasi'a Kalili koteka visea akesa afi'ne. Filipina aketeno inake huno hapai'ne “Kakaeya na'kame eno.” ");
INSERT INTO ino_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hikeno Filipi'a Petesaita kumate ve'kae. Ani ala kumatena Etalu'ae Pita'ae ne'mai'a kumane. ");
INSERT INTO ino_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi'a Natanielona akeno fole aiteno inake huno hapai'ne “Mako ve'kae Anumaya Koti aune vaya'ae Mosese'ae mono avopi kamale'nayane ani ve'ka lakaeya ako aketa fole ai'none. Akaeya Yisasi'a Yosefe mafa'ne Nasaleti kumate ve'kamo mafa'ne mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nehikeno Natanielo'a ne'afino inake huno afine'ke “Nasaleti kumatena mako kanale ya fole aikife?” hikeno Filipi'a inake he “Afa'a ne'e'ka ako.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanielo'a Yisasiteka ne'ekeno Yisasi'a aketeno akaeyafe inake he “Akeo mika ne'ea ve'ka alaki akola Isaleli ve'kae. Ani ve'ka mako ake'atike ke'a mako'ke'a akaeyapina alaki o'male'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hikeno Natanielo'a inake huno afine'ke “Nakaeyafe hana ya hu'ka nake'ne'kae nehane?” huno afikekeno Yisasi'a inake he “Filipi'a uno kakaeyafe ke ohu'nea'ae kanale kakaeya fi'ki yosamo aepale mai'nanake'na ako kake'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Hikeno Natanielo'a inake he “Ali'ka apaya hu ve'kamoka Anumaya Koti mafa'ne mai'ne'ka Isaleli kote ala kava ve'ka mai'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nehikeno Yisasi'a Natanielofe inake nehe “Fi'ki yosamo aepale mai'nanake'na kake'noe hu'na kahapauva yafe lamake nehane hu'ka afite'ka kaipafi male'ka kaipa alakepa hu'ka ne'namipe? Henaka'a meni akana yana akaseno lusi ala ya akekane.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yisasi'a mako'ae apa'kaeyafe inake he “Lamake hu'na lahapapauve ko'ku'na'mo'a hale'nisiketapa lapa'kaeya akesake'a Anumaya Koti ko'ku'napi kayo kayo vaya'yakamoki eli'e'a ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'nalena haite'a eli'ete'a hisaketapa akekae.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Yisasi'a akaeya ke ne'afea anaka'ae aole afina mai'nike'a Yisasife “Kakaeya ke ne'afea anaka'ae a ali ya etapa akeo.” hu'a nehake'a Kalili koteka hane'nea kuma Kena kumate u'nakeno ani kumate mako ve'kamo'a a ne'alikeno Yisasi ita'amo'a ani a alikefe hea nopi u'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","U'a ake'nakeno henaka'a nofi alakamo li ne'a hano hutakeno Yisasi ita'amo'a Yisasife inake huno hapai'ne “Nofi alakamo lina ako hano he.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nehikeno Yisasi'a inake he “Ato ina kava ma kava ho ke naha'opaiyo. Kakaeya ya o'male'ne. Nakaeya lo'kiya'ni hu'na apavelisoa kana'a va'yi ohu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nehikeno Yisasi ita'amo'a ne'ya alo hu'a ne'apamea vaya'aife inake huno hapapai'ne “Mako ke hisiketapaena akaeya ke a'kame maleo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuta vaya'moki mono kemo'a inake hu'ne “Mi'ko afina mi'ko ya sese nehutapa li faleo.” hu'ne. Ani yafe naya mako kaya hano huteno naya mako kayati mako'ke alea yafa li samoyakafi naya aole afina li kepati hefi'a la'kikeno havai'netea samoyaka anile hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisasi'a ne'ya ne'apamea vaya'aife inake huno hapapai'ne “Mani li samoyakafina litafa hefitapa havaiteo.” huno hapapaike'a hefi'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hefi'a havaitetakeno Yisasi'a inake nehe “Aise'a hefitapa ani ne'yate kava ve'kale alitutapa amikeno neno afikeno.” huno hike'a ali'a u'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ani lina hokoteno litafa hane'nea'maki henaka'a nofi alakamo li alino hapa'nikeno ani ne'yate kava ve'kamo'a neno aketeno ani li e'nea kama'a o'ake'nea'maki ani li hefi'naya ali'ya vaya'amoki afi'nakeno ne'yate kava ve'kamo'a ani a alea ve'kae ke huno inake huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Mi'ko vaya hokote'a haka'ake li apamike'a ne'a apamu hutake'a henaka'a afa li apami'naya'maki kakaeya hokote'ka haka ohu li laminaketa ako netonake'ka meni haka'ake li nelamine.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mani alo hea yana Yisasi'a aepa faino o'ake'naya avame ya hu lo'kiya yana Kalili koteka hane'nea kuma Kena kumate ani kavana alo nehuno lusi ala lo'kiya ya'a'ae apavelike'a akaeya ke ne'afea anaka'moki afi'a apaipafi malete'a apa'ku'a ami'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ani ya humaleteke'a Yisasi'ae ita'amo'ae akana'amoki'ae akaeya ke ne'afea anaka'ae Kapaneamu u'a aise kana'a anile mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Emu ki'a ne'ya ne kanamo'a aupasi nehikeno Yisasi'a Yelusalemu u'ne. Ani emu Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi emu kikefe nehae. ");
INSERT INTO ino_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yisasi'a ala mono nopi uno akeana vaya'yakamoki puluma'ka afuki sipi sipi afuki namaki hu'a male'nake'a miya nehake'a mako vaya'moki alu kotekati moni ne'ali'a ani kumate moni anona'a apamisaya yafe hitale malete'a mai'nakeno Yisasi'a apa'ke'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Apa'keteno nofi alino masakena kiteno mi'ko vaya sipi sipi afu'ae puluma'ka afuyaka'ae mono nopati hapafaitale'ne. Moni ali'a anupa nehaya vaya'moki hipa'api'ae moni'api'ae alino atakufatale'ne. ");
INSERT INTO ino_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Namayaka miya hisaya ya ali'e'a male'naya vaya'aife inake nehe “Alilitapa veo. Mafina afo'nimo nona lapa'kaeya alitapa ma'keti kuma ya alo oheo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nehike'a akaeya ke ne'afea anaka'moki avopi hane'nea ke apa'kesa afi'a hao nehae. Ani kemo'a inake hu'ne “Anumaya Koti nofe mi'ko afina nakesa afifi hu none. Ani nona kanale'ya huno hanesea yafe lusiya hu'na amuse nehoe.” huno kamale'nea ke apa'kesa afi'a hao nehae. ");
INSERT INTO ino_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Afi'nake'a Yuta vaya'moki make hu'a afine'kae “Ani kava hana kavana moni ali'a anupa nehaya vaya'moki hipa'api'ae moni'api'ae ali'ka atakufatale'nanana hana akufa lo'kiya ya'kaleti nehane? Lo'kiya'ka hane'ne huta afisuna yafe mako no'akona avame lo'kiya ya'ka huketa akeno.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nehakeno Yisasi'a inake huno hapa'nepaiye “Mani ala mono nona alitapa kape letalesake'na aole'ae mako'ae kanafi halate ete'na ani no ki'na avaya akauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nehike'a Yuta vaya'moki inake hu'a hapai'nae “Ke'kamo'a kanale ohea ke nehane. Aole'ae mako'ae kanafi ani nona ali'na hetikoe hu'ka hana'maki vaya'moki 46'a kafufi mani nona ki'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hu'a hakeno Yisasi'a ani mono nofe hu'neana akai'a akufae avoya ke nehe. ");
INSERT INTO ino_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Inake hu'neatenakeno henaka'a Yisasi'a fali'neapati eteno heti'nea afina akaeya ke ne'afea anaka'moki ani hu'nea ke apa'kesa afi'a hao nehisakeno Anumaya Koti ke'afi kamale'nea avopi hane'nea kemaki Yisasi'a hea kemaki lamake nehe hu'a afi'a apaipafi male'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi emu ne'kea kana va'yi hikeno Yisasi'a Yelusalemu mai'neno no'akaya avame hu lo'kiya yana ne'alike'a mi'ko vaya'moki akete'a akaeyafe lamake nehe nehu'a afi'a apaipafi male'nae. ");
INSERT INTO ino_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Apaipafi male'naya'maki Yisasi'a mi'ko vaya'ai apaipafi ako ake'nea yafe akai'a aipafi hane'nea ke hapa'nopaiye. Yisasi'a mi'ko vaya'ai apaipafi hane'nea yana ako afi'nea yafe mako ve'kae “Kaipafi hane'nea ya nahapaiyo.” huno apafi no'ke. ");
INSERT INTO ino_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mako Falasi mono ke ne'afea ve'ka Yuta vaya'aite ala kava ve'ka'apimo aki'a Ni'kotimasi'ae. ");
INSERT INTO ino_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mako hani'ainaka Ni'kotimasi'a Yisasite eno inake nehe “Hu'ka apavenelina Nenao lakaeya ako afi'none Anumaya Koti'a hukateke'ka kakaeya hu'ka apavenelina ne mai'nane. Kakaeya o'ake'naya avame'ya hu lo'kiya kavana nehane. Anumaya Koti'a kakaeya'ae o'mainininana ani kavana kakaeya ohanine. Ani yafe lakaeya ako afi'none Anumaya Koti'a hukateke'ka e'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nehikeno Yisasi'a inake nehe “Alaki lamake hu'na kaha'nepauve Anumaya Koti'a mako ve'ka saufa mafa'ne mako'ae ali o'ateseana ani ve'kamo'a Anumaya Koti kava yakai'nea kumana o'akekaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nehikeno Ni'kotimasi'a inake nehe “Alopa ve'ka hana'ya huno halate eteno alitekaiye? Ita'amo aipafi eteno visikeno mako'ae halate alitekaife?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Afine'kekeno Yisasi'a inake nehe “Alaki lamake hu'na kaha'nepauve liteti'ae Anumaya Koti Fate Akufa Avamu'amoteti'ae halate mafa'ne ali o'ateseana Anumaya Koti kava yakai'nea kumatena o'uke. ");
INSERT INTO ino_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Akufa ame hane'nea ve'kamo'a akufa ame hane'nea mafa'ne ali ne'atea'maki Anumaya Koti Fate Akufa Avamu'amo'a mako ve'ka aliteseana Fate Akufa Avamu'amo avamu alitekaiye. ");
INSERT INTO ino_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nakaeya hoa ke ‘Kakaeya mako'ae ete'ka alinato hu'ka ho.’ hu'na hoa ke afi'ka kamo'yo o'aiyo. ");
INSERT INTO ino_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yasimo'a haiya aupalika alino uneno nehea'maki kaulakaleti no'akane. Afa'a vo'vo hea ke'ake ne'afina'maki va'yi hu'nea ka'ae visea ka'ae no'akane. Yasimo'a hea kava huno Anumaya Koti Fate Akufa Avamu'amo'a mako ve'ka ali ne'atea'a no'akone.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ni'kotimasi'a inake huno afine'ke “Ani yana hana'ya huno nehe?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Afine'kekeno Yisasi'a inake nehe kakaeya Isaleli kumate vaya hu'ka apavenelina ve'ka mai'nanaki na'ya hike'ka o'afi'nane? ");
INSERT INTO ino_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Alaki lamake hu'na kaha'nepauve ake'nona ya'ae afi'nona ya'ae kaha'nepauvanaki ani ke no'afine. ");
INSERT INTO ino_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nakaeya ma mopale yafe ako kahapauke'ka lamake hane hu'ka afi'ka kaipafi o'male'nananake'na ko'ku'napi yafe kahapaisoana hana'ya hu'ka afi'ka kaipafi malekane? ");
INSERT INTO ino_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mako ve'kamo'a ko'ku'napaka ohai'nea'maki nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'kamo'na nakai'nike ko'ku'napakati ma mopafi eli'ne'noe. ");
INSERT INTO ino_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosese'a ka'me koteka mai'neno osifa've alo huteno yosale heno kamateno alino asaimale'nea kava hu'a meni ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ani kava hu'a ali'a nasaikae. ");
INSERT INTO ino_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ali'a nasaisakeno mi'ko vaya'moki nakaeyafe lamake nehe hu'a afi'a apaipafi malete'a apa'ku'a nami'a alakepa hisaya vayana akola maike maike hisaya apavamu alikae. ");
INSERT INTO ino_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anumaya Koti'a lakaeya ma mopale vayafe lusiya huno hau ayamopafati haikeno aiya mako'ke mafa'ne'a hutekeno eline'niketa lakaeya mako'ke mako'ke'mokita akaeyafe lamake nehe huta afita laipafi maleteta laku'a amita alakepa hisunana hani'ki'nea yapi ata leke leke nehea atafi o'ukunanaketa akola maike maike huta maikune. ");
INSERT INTO ino_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Anumaya Koti'a ma mopafi vaya kake hupateno nofi hupatekefe mafa'ne'a hutekeno o'me'nea'maki ma mopafi vaya apa'ku apame alino katiseafe hutekeno eline'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eline'nea'maki mako vaya'moki Yisasife lamake nehe nehu'a afi'a apaipafi malete'a apa'ku'a ami'a alakepa nehisakeno Anumaya Koti'a kake huno nofi hu o'apatekaiya'maki mako vaya'moki Yisasife ake'atike nehe nehu'a afi'a apaipafi o'male'a apa'ku'a ami'a alakepa hu'a no'ameanakeno Anumaya Koti'a ako kake hupateteno nofi hupate'ne. Anumaya Koti aiya mako'ke mafa'ne'amo'a ake'atike nehe nehu'a afi'a apaipafi o'male'a apa'ku'a o'ami'naya yafe kake huno nofi ako hupate'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ano ha nelea ve'ka ma mopafi ako e'nike'a vaya'moki hao'otake ya hu'a hanipi mai yafe amuse nehu'a ano ha nelea yafe nohapaiye. Nohapaiya yafe Anumaya Koti'a kake hupate'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mi'ko hao'otake kava huke huke nehaya vaya'moki ano ha nelea yafe nohapaike'a ano ha nelea yapi no'mae. “Hao'otake ya'ni akeno fole aike.” hute'a hale yapi no'mae. ");
INSERT INTO ino_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lamake'ake ke nehea ve'kamo'a ano ha nelea yapi ne'eno inake he “Anumaya Koti'a naha'maeke'na kanale kava hu ya ali'noanake'a mi'ko vaya'moki akesae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ani ya hano huteke'a Yisasi'ae akaeya ke ne'afea anaka'ae Yutia koteka u'nae. Yatala afina ani kumate mai'ne'a li falepate'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Li fale ne'apatekeno Yoni'a Inoni kumate mai'neno ani kava huno li falepate'ne. Inoni kuma'mo haute Selimi hane'ne. Nesu li ani koteka hane'nike'a vaya'yakamoki anile ete ete hakeno Yoni'a li falepate'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Fale ne'apatea'maki ani afina Yonina nofi hu o'ate'nakeno afa'a mai'neno li fale ne'apate. ");
INSERT INTO ino_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yoni ke ne'afea anaka'ae mako Yuta ve'ka'ae Yuta vaya'moki li fale au'ava yafe ke hu'a imafi mafi nehae. ");
INSERT INTO ino_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke hu'a imafi mafi hute'a Yoniteka u'a inake hu'a ha'nepaiye “Ali'ka laya nehana ve'kamoka Yotani li'mo meka kaya aupalika kakaeya'ae mai'nike'ka akaeyafe lahapai'nana ve'kamo'a meni li fale ne'apateke'a mi'ko vaya akaeyate ne'vae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nehakeno Yoni'a inake he “Mako vaya'aina Anumaya Koti'a o'apamininana mako yana o'alinine. ");
INSERT INTO ino_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hu'noa ke lapa'kaeya afi'nae. Inake hu'na hu'noane ‘Anumaya Koti'a lakufa alino katiseafe hute'nea ve'ka nakaeya o'mai'noa'maki nakaeya na'kame mako ve'ka esea yafe e'na hokotene'atoe.’ hu'na hu'noe. ");
INSERT INTO ino_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","‘Mako ve'kamo'a a ne'aleana akai'a a mai'nea'maki ha'maeya ve'kamo'a lusiya huno nehaikeno ani kava huno aketeno amuse nehe. Ani kava hu'nea kava hu'na mi'ko vaya'moki Yisasiteka u'naya yafe lusi amuse nehoe. ");
INSERT INTO ino_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yisasi'a ala ve'ka nakaseno aki'amo'a ala hukea'maki nakaeya afa ve'ka mai'ne'na nakimo'a afete lavise.’ nehe.” ");
INSERT INTO ino_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yoni'a inake nehe “Hanafakati e'nea ve'ka mi'ko yana apa'kase'nea'maki ma mopafati fole ai ve'kamo'a ma mopafi ve'ka mai'neno ma mopale yafe'ke ke nehe. Ko'ku'napakati e'nea ve'kamo'a mi'ko yana apa'kase'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","33","Ani ve'kamo'a ake'nea ya'ae afi'nea ya'aefe hapa'nepaike'a mako vaya'moki ani ke afi'a apaipafi no'malaya'maki mako'ke mako'ke vaya'moki hu'nea ke afi'a apaipafi malesune hu'apaena ‘Anumaya Koti'a lamake ve'ka mai'ne.’ hu'a lo'kiya ne'vaiye. ");
INSERT INTO ino_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anumaya Koti'a hute'nea ve'ka Anumaya Koti'a Fate Akufa Avamu'a amikeno nesu yate havaite'nikeno Anumaya Koti ke nehe. ");
INSERT INTO ino_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nehikeno afo'amo'a mafa'ne'ae lusiya huno hau'nea yafe mi'ko yana kava yakaisea yafe ami'ne. ");
INSERT INTO ino_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mako vaya'moki mafa'ne'ae lamake nehe hu'a afi'a apaipafi malete'a apa'ku'a ami'a alakepa hisayana akola maike maike hu apavamuna ako ali'nae. Ali'naya'maki mako vaya'moki mafa'ne'amo'a hea ke a'kame o'malesayana ani apavamuna o'alikaya'maki Anumaya Koti'a ani vaya'aife hai vai ne'apate.” ");
INSERT INTO ino_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","“Yisasi'a Yonina akaseno mi'ko ke'a ne'afea anaka'aina li falepatea akimo'a hanale hai'ne.” hu'a haya ke Falasi mono ke ne'afea vaya'moki afi'nae. Yisasi akai'a li fale o'apate'nea'maki akaeya ke ne'afea anaka'mokike fale ne'apatake'a Falasi mono ke ne'afea vaya'moki afi'naya ke Yisasi'a afiteno Yutia koteka ataleno Kalili eteno u'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne'uno mako folaka ko Sameliane hu'a aki ne'aya kona alino maleka ataleno ukefe hea koteka u'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ani Samelia koteka aise kuma'mo aki'a Sai'kana. Ani kuma Ye'kopu'a Yuta vaya'ai apa'kinakomo'a mafa'ne'a Yosefena ami'nea hoya hane'neate hane'nikeno Yisasi'a ani kumate va'yi nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ye'kopu'a li he'nefea li keli hane'nea yate va'yi nehikeno yakemo'a folaka'nalaka hikeno Yisasi'a ka male'nea yafe alaka haekeno ani li keli avayale faitopale mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Faitopale mai'nike'a akaeya ke ne'afea anaka ne'ya miya hukefe ala kumate utakeno Yisasi'a faitopale mai'nikeno mako Samelia a li hefikefe ne'ekeno Yisasi'a akaeyafe inake nehe “Li hefi'ka namike'na neno.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yuta vaya'ae Samelia vaya'ae kame ate'a apaote apaote mai'naya yafe ani Samelia a'mo'a inake nehe “Kakaeya Yuta ve'ka mai'nanake'na nakaeya Samelia a mai'noki na ya hike'ka nakaeyafe ‘Li hefi'ka namike'na neno.’ hu'ka nehane?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nehikeno Yisasi'a inake nehe “Kakaeya Anumaya Koti'a kamisea yafe afi'nininana ‘Li hefi'ka namike'na neno.’ hu'na hu'noa ve'kae afi'nininana life nafikaninana maike maike hisana lina kaminine.” ");
INSERT INTO ino_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Inake nehikeno ani a'mo'a inake nehe “Amuse'ka nehoa'maki ani li kelimo'a afepi hane'neanake'ka li hefi ke'ayona o'male'nea'maki hanateti ani maike maike hisoa li hefikane? ");
INSERT INTO ino_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ye'kopu'a lakinakomo'a ani li keli lami'nea kele. Ye'kopu'a akai'a'ae mafa'ne'amoki'ae afu anaka'amoki'ae ani li kelifati ne'naya'maki ‘Ye'kopu'a akase'na ala ne mai'noe.’ hu'kae nehape?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Nehikeno Yisasi'a inake nehe “Mi'ko ma lipati nesaya vayana ete'a life hapaukea'maki nakaeya mako'ke mako'ke vaya apamisoa lina apaipafati kapai nehakea li'kana huno haneke haneke hisike'a maike maike hu'a maisaya apavamu apamike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nehikeno ani a'mo'a inake nehe “Amuse'ka nehuki ani lina namike'na neno. Namisanakeno mako'ae life o'nahaisike'na nakaeya mako'ae li hefikefe ma lite o'mesoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nehikeno Yisasi'a inake nehe “U'ka anau'kamofe ke hute'ka ete'ka male e'ao.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nehikeno ani a'mo'a inake he “Anau'nimo'a o'mai'ne.” nehikeno Yisasi'a inake nehe “Anau'nimo'a o'mai'ne hu'ka hanana alaki lamake hane. ");
INSERT INTO ino_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kakaeya a'ke'ainaka naya mako kaya'a anau'kamoki mai'nayane. Meni afina mako ve'kale mai'nana'maki miya hukate'naya anau'kamo'ae o'mai'nana yafe ani ke alaki lamake hu'ka naha'nepaine.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nehikeno ani a'mo'a inake nehe “Ala Nenao nakaeya ako meni afoe lamake kakaeya Anumaya Koti aune ve'ka mai'nane. ");
INSERT INTO ino_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nakinakomoki ma avimate Anumaya Koti aki ali'a asaka nehu'a aki a'naya'maki lapa'kaeya Yuta vaya'mokitapa inake nehae ‘Yelusalemu Anumaya Koti aki alitapa asaka hutapa afine'kaya kumana hane'ne.’ hutapa nehae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nehikeno Yisasi'a inake nehe “Ma ana nakaeya lamake kaha'nepauvanaki afite'ka kaipafi ali'ka malo. Mako kana va'yi hinakeno ma avimate'ae Yelusalemu'ae Anumaya Koti aki ali'a asaka nehu'a aki o'akaya'maki fate fate kumate aki ali'a asaka hukae. ");
INSERT INTO ino_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lapa'kaeya Samelia vaya'mokitapa aki alitapa asaka nehutapa aki ne'aya ve'ka aketapa alakepa ohu'nae. Lakaeya Yuta vaya'moki afita alakepa hu'neta aki alita asaka huta aki a'nona ve'ka ako afi'none. Lapa'kufa alino kati ve'ka Yuta vaya'aipati va'yi nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mako kana va'yi huke hu'na hu'noa kana ako va'yi neheana vaya'moki lamake hu'a apaipa apame'afati afo'nimo aki ali'a asaka nehu'a avake hisaya kana ako va'yi nehe. Ani kava hisaya vayafe afo'nimo'a hau'nikeno kahau ne'aeye. ");
INSERT INTO ino_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anumaya Koti'a aipa ame'ake hane'nea'maki akufa o'male ve'ka mai'ne. Ani yafe akaeya avake nehu'a aki ali'a asaka nehaya vaya'moki apaipa apame'afati nehu'a lamake hu'a aki ali'a asaka nehu'a avake heo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nehikeno mani a'mo'a akaeyafe inake nehe “Nakaeya Kalaisi'a Anumaya Koti'a lakufa alino katikefe hutesea ve'ka esea ke ako afi'noe. Eseana mi'ko yafe lahapaike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nehikeno Yisasi'a akaeyafe inake he “Nakaeya nevaya'na ani ve'ka mai'noe. Kakaeya'ae meni mai'ne'na kake nehu'a ve'ka ani ve'ka mai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ani ke nehike'a akaeya ke ne'afea vaya ete'a ne'e'a Yisasi'a ani a'ae kake neha'ake'a ana'kete'a lusi apa'kesa lapa ne'aiya'maki mako'amoki “Na kava hike'ka kake nehane?” hu'a ani ana afio'ke'nae. “Na'ya hike'ka ma a'ae kake nehane?” hu'a Yisasina afio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ani a'mo'a li kena ne'ataleno ala no kumate eteno uno anile mai'naya vaya'aife inake nehe “Etapa akeo. Mi'ko hu'noa yana huno fole ainate'nea ve'ka etapa akeo. Ani ve'ka Anumaya Koti'a lakufa alino katikefe hute'nea ve'kafi?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nehike'a kuma ne'atale'a Yisasite ne'ae. ");
INSERT INTO ino_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Saufa ne'ake'a Yisasi ke ne'afea anaka'moki Yisasife inake nehae “Hu'ka lavenelina ve'ka nesana yana hane'niki no.” hu'a kune kune nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yisasi'a inake nehe “O'afi'naya ne'ya ako ne'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nehike'a ani vaya'moki apa'kai'api ke huke afike nehu'a inake hu'a nehae “Mako ve'kamo'a nesea ne'ya ako alineno ami'nifi?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nehakeno Yisasi'a inake nehe hunate'nea ve'kamo haiya kava hisoana inamona alaki nesoa ne'ya'ni hane'ne. Hunate'nea ve'kamo nami'nea ali'ya ali'na avaya aesoana inani ali'yana ne'ya'ni'a hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vaya'mokitapa nehaya ke inake hutapa nehae “Aole'ae aole'ae i'ka maitesunakeno henaka'a ne'ya afule kana va'yi huke.” hutapa nehafe? Nakaeya lahapa'nepauve hoyafi ne'yate aketapa alakepa hutapa akeo ani hoyafi ne'ya'mo afu nelea akufa kava nehe. Ani kava nehea kava hu'a vaya'moki nakaeya ke afi'a apaipafi malesaya vayana hoyafi ne'ya afu nelea akufa kava hu'a ako afu nelae. ");
INSERT INTO ino_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Afu neleana Anumaya Koti ke afisaya yafe hapa'maesea ve'kamo'a anona'a alikea'maki hapa'maeke'a afi'a apaipafi malesaya vaya akola maike maike hu apavamu alikae. Alikaya'maki ani hoyafi avina ya neha'kalea ve'ka'ae afulekeno ha'mano ne'alea ve'ka'ae mako'ke kava hu'ana amuse huka'ae. ");
INSERT INTO ino_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ani kava hisayana ako hu'naya ke lamake nehae inake hu'a nehae “Mako ve'kamo'a ha'kalemale'nikeno alu ve'kamo'a ne'ya'a ne'ale.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nehaki mako vaya'moki nakaeya ke o'afi'naya vaya'aina Anumaya Koti ke ako hapapai'naki lapa'kaeya hapa'makefe ani vaya'aite hulapate'noanaketapa hapapaisake'a nakaeyafe afi'a apaipafi malekae. Mako vaya'moki ali'ya ako alimale'naketa lapa'kaeya afa'a ne'ya'ake ne'ale nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ani a'mo'a “Mi'ko a'ke'ainaka hu'noa yafe huno ako fole ainate'ne.” huno hike'a afi'naya yafe mi'ko Samelia vaya'moki Yisasife afi'a apaipafi malete'a apa'ku'a ami'a alakepa hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yisasite va'yi hu'ne'a lusiya hu'a inake hu'a nehae “Lakaeya'ae maisane.” hu'a hakeno Yisasi'a apa'kaeya'ae aole kana'ake mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mai'nike'a nesu vaya'moki akaeya ke ne'afea yafe afi'a apaipafi malete'a apa'ku'a ami'a alakepa hu'a ami'nae. ");
INSERT INTO ino_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Amite'a ani afe inake hu'a ha'nepaiye “Meni kakaeya hana ke afuna yafe Yisasife afita laipa no'amuna'maki lakaeya akaeya ke lakaiti lakesafati afuna yafe afita laipafi maleteta laku'a amita alakepa nehune. Meni afi'none ani ve'ka lakufa alino katisea ve'ka mai'neno ma mopale vaya lakufa alino katikefe e'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aole kana hano nehikeno Yisasi'a ataleno Kalili u'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yisasi'a akai'a inake hu'ne “Mako mono hapa'nepaiya ve'kamo'a akai'a kumate vaya'aipina mai'nike'a vaya'amoki ‘Ala ve'kamo keki afiketao.’ hu'a nohae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nehea'maki Kalili va'yi hike'a ani kumate vaya'moki hu'a falu fala hune'ate'a amuse'kase hu'nae. Ani vaya'moki Yelusalemu ala emu ki'naya afina u'a Yisasi'a mi'ko ya hu'nea ya ake'naya yafe hu'a falu fala hune'ate'a amuse hune'atae. ");
INSERT INTO ino_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Amuse hune'atakeno Yisasi'a eteno Kalili hane'nea kumana Kena kumate uno va'yi hu'ne. Ani kumate Yisasi'a life hakeno litafateti alino nofi alakamo li alino hapa'nea kumatene. Yisasi'a anile mai'nikeno mako kamani kava ve'ka Kapaneamu kumate ve'kamo ne'mafa'ne kali ali'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kali ne'alikeno afo'amo'a “Yisasi'a Yutiati Kalili e'ne.” haya ke afiteno makale'a mafa'ne'a ne'ataleno Yisasite uno inake nehe “Mafa'ne'ni'a falisea ya nehiki e'ka ali'ka kanale huto.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nehikeno Yisasi'a akaeyafe inake nehe “Lapa'kaeya o'ake'naya avame hu lo'kiya ya o'akesayana nakaeyafe afitapa lapaipafi maletetapa lapa'ku'a namitapa alakepa ohukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nehikeno ani kamani kava ve'kamo'a inake nehe “Amuse'ka nehuki mafa'ne'ni ako falikefe nehike'nae nehuki makale nakaeya'ae eno.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nehikeno Yisasi'a akaeyafe inake nehe “Kakaeya afa'a uvo mafa'ne'ka ofalino afa'a mai'ne.” huno hikeno Yisasi hea ke afino aipafi maleteno u'ne. ");
INSERT INTO ino_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E'nea kateka atakineno ne'vike'a ali'ya mafa'ne'amoki e'a kateka fotu hute'a inake hu'a nehae “Kakaeya mafa'ne'ka ako kanale hutekeno hetino mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hakeno “Hana kanale aepa heno ani kali'a kanale hute'ne?” huno apafikeke'a “Eka yakemo'a lamotule haiteno nelavikeno ani amu'ko kali'a hano hute'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nehakeno afo'amo'a akesa afino hao nehuno inake he “Lamake yakemo'a ani kanale eno nelavikeno Yisasi'a ‘Mafa'ne'ka ako kanale huno mai'ne.’ huno nahapai'ne.” huteno akaeya'ae mi'ko anaka'a'ae Yisasife afi'a apaipafi malete'a apa'ku'a ami'a alakepa nehae. ");
INSERT INTO ino_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisasi'a Yutiati Kalili uno ani mafa'ne alino kanale huteteno o'ake'naya avame hu lo'kiya kavana aole afina alo hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Henaka'a Yuta vaya'moki ala emu ne'kikeno Yisasi'a Yelusalemu hai'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusalemu keki'yafi mako kipana sipi sipi afu anaka'ai kipa hane'ne. Ani kipa hane'neateka mako li kotu male'ne. Ani li kotu'mo aki'a Yuta vaya'moki kefati Petesaita. Ani kotute naya mako kaya'a no mai'a falu hisaya no kimale'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mi'ko kali vaya ani nopi ali'a atalu hute hute hu'a hava'a mai'nae. Apaulaka apo ka'nea vaya'ae apaiya avayu hu'nea vaya'ae apaiya apaya api ai'nea vaya'ae ali'a atalu hu'a hava'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mai'nakeno Anumaya Koti ko'ku'napi kayo kayo ve'ka mako'ke kana'ae kana'ae lavino lipi aino kalafu kalafu ne'aikeno hokoteno ani lipi lavea kano kali'a hano hute'ne. Ani kava hisea yafe kali vaya akeva mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ani akeva mai'naya vaya'aipi mako kano yatala afina mako ve'kamo aiya aya hano huno mako ve'kamo aya'a hano huteno aiyalekati aole atale'nea kafu (38 kafu) kali alino mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisasi'a ani havano mai'nea ve'ka aketeno mani ve'ka yatala afina kali alino mai'nea yafe afiteno akaeyafe inake he “Kali'kamo'a hano hisea yafe amuse nehape?” huno afike'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Afikekeno kali ve'kamo'a Yisasife inake he “Ali'ka apaya nehana ve'ka li aino kalafu aiya afina navaleno lipi natesea ve'ka o'mai'neno naha'o'make'na anileka makale o'u'noe. Nakaeya'nike uva'maki nakaeya ako nakase'a lipi makale u'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hikeno Yisasi'a akaeyafe inake he “Heti'ka havae hipa'ka ne'ali'ka uvo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hapaikeno makale kali'a avayatekeno makale'ato'a hetino havae hipa'a ne'alino u'ne. Ani afinana Sapati afinane. ");
INSERT INTO ino_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yuta vaya'moki kali'a hano hutea ve'kae inake nehae “Meni kana Sapati afinanaki na'ya hike'ka havae hipa'ka ali'ka ne'vane? Lakaeyate ke male male'nea kemo'a ‘Sapati afina ina kava oho.’ huno hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nehakeno ani ve'kamo'a inake he “Kali'ni alino atale'nea ve'kamo'a inake huno nahapai'ne ‘Havae hipa'ka alite'ka uvo.’ huno hunate'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nehike'a akaeyafe inake hu'a afine'kae “Ani ve'ka hana akufa ve'kamo'a kahapaike'ka nehavana ya'kaikona'ka ali'ka ne'ane?” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nehaya'maki Yisasi'a mi'ko vaya anile ali'a atalu hu'naya vaya'aipi ako makale u'nea yafe ani kali'a alino kanale hute'nea ve'kamo'a akeno alakepa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Henaka Yisasi'a kali alino kanale hute'nea ve'ka mono nopi aketeno inake huno hapai'ne “Kakaeya ako meni kali'ka hano hike'ka kanale hu'ka mai'nananaki hao'otake kava mako'ae oho. Hao'otake kava hisanana mako'ae ala kali alite'ka kana kahaisea no maikane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nehikeno ani ve'kamo'a uno Yuta vaya'aife inake huno hapapai'ne “Kali'ni alino kanale hunate'nea ve'ka Yisasi'ae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Neheanaki Yisasi'a Sapati afina kali'a alino kanale hute'nea yafe Yuta vaya'moki havi apa'kesa afite'a Yisasina apaipa kafa hate'a ali'a haviya hute'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yisasi'a inake huno hapapai'ne “Afo'nimo'a mi'ko afina ali'ya ne'alike'na nakaeya'ae ani kava hu'na ali'ya ne'aloe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mani ke'ae Yisasi'a “Anumaya Koti'a afo'nimo'ae. Nakaeya Anumaya Koti'ae mako aiyayi huta'a mai'no'ae.” nehea ke'aefe Sapati afina ke male male'nea ke alino ataka'nea yafe Yuta vaya'moki mako'ae lusi apaipa kafa neha'a ke ne'ama'ki'a “Hakaune.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yisasi'a anona'a ke'apile inake nehe lamake hu'na lahapa'nepauve mafa'ne'amo'a akai'ake mako'ke kava nohea'maki afo'amo nehea ya aketeno ani kava nehe. Afo'amo'a nehea kava huno mafa'ne'amo'a ani kava nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afo'nimo'a mafa'ne'amo'naena aipafati nehaikeno akai'a mi'ko nehea kava navenele. Henaka'a lusi ala kava mako'ae navelisike'na hisoa yafe atali atalu hukae. ");
INSERT INTO ino_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afo'nimo'a fali'naya vayana alino hetipateno apavamu ne'apameanakeno mafa'ne'amo'na ani kava hu'na nahaiya ve'ka avamu ne'amoe. ");
INSERT INTO ino_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Afo'nimo'a akai'ake mako ve'ka kake huo'atekaiya'maki mafa'ne'amo'nake mi'ko vaya kake hupatesoa lo'kiya yana ako nami'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nami'nea yafe mi'ko vaya'moki afo'nimo avake nehu'a aki ali'a asaka hu'nayane ani kava hu'a mafa'ne'amo'naena mi'ko vaya'moki navake nehu'a naki ali'a asaka hisae. Ali'a asaka hukaya'maki mako vaya'moki mafa'ne'amo'na naki ali'a asaka ohisayana ani kava hu'a hunate'nea afo'nimo aki'ae ali'a asaka ohu'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nakaeya alaki lamake hu'na lahapa'nepauve mako vaya'moki ke'ni'a ako ne'afi'a hunate'nea ve'kae lamake hane hu'a afi'a apaipafi malete'a apaipa nami'a alakepa hisaya vaya akola maike maike hisaya apavamuna ako ali'nae. Ani vayana ako fali'neke'kana hute'a fali'nayapati ako heti'a apavamu'api ali'nayanakeno henaka'a Anumaya Koti'a kake huo'apatekaiye. ");
INSERT INTO ino_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Alaki lamake hu'na lahapa'nepauve mako kana va'yi huke hu'nea kana ako meni va'yi hu'ne. Ani kanafi fali'naya vaya'moki Anumaya Koti mafa'nemo ke afikae. Ani ke afi'naya vaya heti'a akola maike maike hu'a maikae. ");
INSERT INTO ino_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afo'nimo'a akai'afi avamu'mo aepa'a hane'nikeno ani kava huno mafa'ne'ae “Avamu'mo aepa'a maiyo.” huno hunate'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne mai'noa yafe mi'ko vaya kake hupatesoa lo'kiya'a nami'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mani yafe lapamo'yo o'aiyo. Mako kana va'yi huteno mi'ko falike'a kelifi kipate'naya vaya'moki ake'a afite'a ani kelifakati heti'a hatilavikae. ");
INSERT INTO ino_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Hatilavisake'a kanale kava hu'naya vaya'yaka heti'a kanale hu'a maikayanaki hao'otake kava hu'naya vaya'yaka hetisakeno Anumaya Koti'a kake hupateteno nofi hupatekaiye. ");
INSERT INTO ino_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nakai'nike mako yana nakesafati nohoa'maki Anumaya Koti nahapaiya keleti kake hune'apatoe. Ani yafe alakepa kava hu'na kake hune'apatoe. Nakai'ni naipa nakesafati nohoanaki hunate'nea ve'kamo aipa akesa'ae ali'na nehoa yafe alakepa hu'na kake hupatoe. ");
INSERT INTO ino_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","32","Nakai'ni aepa'a'ni'a lahapapaisoana ke'nimo'a haviya hukea'maki mako ve'kamo'a nakaeyafe lahapa'nepaiyana nakaeya ako afi'noe akaeya nakaeyafe hea ke lamake nehe. ");
INSERT INTO ino_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lapa'kaeya vayana hupatake'a Yoniteka u'nayana Yoni'a nakaeyafe lamake ke ako lahapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nakaeyafe vaya'moki hu'naya ke afa ke hane'ne hu'na nehoanaki lapa'kaeya ani ke afisakeno lapa'kufa alino katisea yafe'ke lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoni'a mako kani'kana hu'neane. Ani kani'mo'a aupa kana'afi ano hale'niketapa lapa'kaeya akaeya kani'mo'a hale'nea yafe amuse hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mako lusi kanale ya'ae nakaeya aepa'ae lapaveli'ne. Ani yana ali'na avaya aesoa ali'ya'ni afo'nimo'a nami'nea ali'yana Yoni'a nakaeyafe hu'nea ke akase'niketapa aketetapa nakaeyafe afi'nae. Ani ali'yana afo'nimo hunate'nea yafe lapaveli'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hunate'nea afo'nimo'a nakaeyafe ako lahapapai'neanaki lapa'kaeya akaeya ake o'afitapa akaeya aulakafina o'aketapa hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Akaeya ke lapaipafi ohane'ne. Hute'nea ve'kae lamake nehane hutapa afitapa lapaipafi maletapa lapaipa amitapa alakepa ohu'naya yafe Anumaya Koti ke lapaipafi ohane'ne. ");
INSERT INTO ino_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","Anumaya Koti ke a'ke'ainaka kamale'naya avopi hapalitapa kahau atapa ake'nae “Ani avopati akola maike maike hisuna lavamu alikune.” hutapa lapa'kesa afi'nae. Ani avona nakaeyafe hu'a lahapapai'naya'maki nakaeyateka esaya lapa'kesa no'afe. Akola maike maike hisaya lapavamu lapamikoa'maki nakaeyateka no'mae. ");
INSERT INTO ino_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Vaya'moki amuse hunatesaya yafe kahau no'aova'maki lapa'kaeyafe nakaeya ako afi'noe. Lapa'kaeya lapaipafina Anumaya Kotife nolahapaike'na ne'akoe. ");
INSERT INTO ino_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nakaeya afo'nimo akile e'noe. E'noanaki alitapa falu fala hutapa no'natayanaki mako ve'kamo'a akai'a akile eseana afa'a alitapa falu fala hutekae. ");
INSERT INTO ino_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lapa'kaeya “Fate fate vayatimoki amuse hulatesae.” hutapa nelahapaiya'maki Anumaya Koti'a akai'ake mai'niki fate Anumaya Koti'a o'mai'neanaketapa “Anumaya Koti'a amuse hunatese.” hutapa nolahapaiye. Ina kava nehutapa hana'ya hutapa nakaeyafe afitapa lapaipafi maletetapa lapaipa namitapa alakepa hutapa namikae? ");
INSERT INTO ino_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lapa'kaeya nakaeyafe inake hutapa nehafe “Afo'amoteka lakaeyafe huno fole ailatekaiye.” hutapa lapa'kesa afi'nafe? He'e nakaeya hu'na fole ai olapatekauvanakeno fate ve'ka Mosese'a lahapapai'nea kemo'a lahapa'maesea yafe lapame'atiti yapi mai'naya yateti ani ke huno fole aino kake hulapatekaiye. ");
INSERT INTO ino_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosese ke afitapa lapaipafi male'nininana nakaeya ke'ae ani kava hutapa afitapa lapaipafi malanine. Mosese'a nakaeyafe huno ani ke kamale'nea yafe ani kava hinine. ");
INSERT INTO ino_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lapa'kaeya Mosese'a kamale'nea ke afitapa lapaipafi alitapa o'male'nayanaketapa hana'ya hutapa nakaeya ke afitapa lapaipafi alitapa malekae? huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ani ke huno hano huteno Yisasi'a uno lipi kalefi Kalili li kotu la'kano u'ne. Ani li kotu'mo mako aki'a Taipiliasi. ");
INSERT INTO ino_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mi'ko vaya'ai kali alino kanale hune'apateno no'akaya avame hu lo'kiya kavana nehike'a ne'ake'a a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ne'vakeno Yisasi'a avimate haino akaeya ke ne'afea anaka'ae mopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yuta vaya'moki Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi emu kisaya kana'a aupasi nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yisasi'a akeno maleno akeana mi'ko vaya'yaka akaeyateka ne'akeno Filipife inake he “Hanatekati ani vaya'yaka nesaya ne'ya miya hesune?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisasi'a Filipina ano avataka hukefe ani ke nehuno ina kava ma kava hukoe hisea yana ako afi'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi'a inake he “Mako ve'kamo'a naya aole vaya'ai apaiya apaya alea afina (200 afina) ali'ya aliteno miya aliteno ani miyateti ne'ya miya heseana ma mi'ko vaya'moki o'nekaki aise'ato'ake ne'ya nekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Hikeno mako akaeya ke ne'afea anaka'aipati Saimoni Pita akana'amo'a Etalu'a inake he “Mako mafa'nemo'a naya mako kaya mayaki aole fayatalanaki alilino mai'ne. Mani ne'yana aise'ato'akeno vaya'kefamo'ke ako ala hu'nea yafe ani ne'ya'mo'a ho'o'kakaiyanaketa hana'ya hisune?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nehikeno Yisasi'a akaeya ke ne'afea anaka'aife inake he “Mi'ko vaya mopale maiyo hutapa heo.” huno hapapai'ne. Ani kumatena mi'ko hafaepa'ake hane'nea kumatenaki'a mi'ko vaya faitopale mai'nae. Ani vaya'yaka o'afunama'a vaya'yaka faefu tauseni ve (5,000 ve) mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yisasi'a ani maya alino Anumaya Kotiteka ke huno amuse huteteno mi'ko mopale mai'naya vaya'yaka apamite apamite hu'ne. Faya'ae ani kava huteno apamite apamite hike'a mi'ko vaya'moki ani ne'ya ne'a apamu hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ani vaya'yaka apamu hutekeno Yisasi'a akaeya ke ne'afea vaya'aife inake he “Mi'ko atupatapa ne'yana alitapa maleo. Haviku mako aise aise atupa'a fatili fatili huta atalesaki alitapa anupa heo.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mi'ko vaya'yakamoki naya mako kaya mayafati nete'a atalaya maya atupayaka'a ali'a anupa hakeno nayatala'a hano huteno naiyalekati aole uno alea ku (12 ku) ai'a havaite'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Anifi mai'naya vaya'moki o'ake'naya avame hu lo'kiya yana Yisasi'a apavelike'a akete'a inake hae “Lamake ma mopale esea Anumaya Koti aune ve'ka ma mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nehakeno Yisasi'a vaya'moki akaeyate hukefe haya kavana ako aku'a akesafi inake huno afi'ne “Ma mi'ko vaya'moki nakaeya navale'a kava kano'api maisoa yafe nakaeya navalekefe nehae.” huno akesa afiteno akai'ake avimapi hai'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Yake lavino falekefe une avameteka akaeya ke ne'afea anaka'moki ala li kotuteka vakeno Yisasi'a apa'kaeya'ae lo'kano o'vike'a apa'kai'apike lipi kalefi u'a li la'ka hekefe Kapaneamu li aki'naleka saufa uke uke nehakeno hani kipate'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lo'kiya'ake yasikefamo'a ne'ekeno lusi kava huno li'mo'a aino kalafu kalafu huno lusi kava hupate'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lusi kava nehike'a lipi kalefi mai'naya vaya'moki alaki yosaleti lina amaki'a mako yatalate (6 kilomita) li kotu'mo folaka'afi ne'vakeno Yisasi'a li avoyale aiya ame ame lipi kale ne'veateka ne'eke'a lusi koli nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Koli nehakeno Yisasi'a inake huno hapapai'ne “Koli oheo mamona nakaeya'ke ne'oe.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hapa'nepaike'a ani vaya'moki Yisasi'a lipi kalefi esea yafe amuse hu'a lipati avale'a asaka nehakeno ani lipi kalemo'a visune haya kumate makale u'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Havate'a kotike'a li kotu'mo falika mai'naya vaya apa'kete'a inake hae “Eka mako fate lipi kale o'male'nea'maki mako'ke lipi kale'ake hane'nike'a Yisasi ke ne'afea anaka ani lipi kalefi ako u'naya'maki Yisasi'a ani lipi kalefi haino apa'kaeya'ae o'u'nifa akaeya ke ne'afea anaka apa'kai'apike u'nakeno Yisasi'a hanate mai'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nehaya'maki Yisasi'a Anumayamoteka amuse huteteno kai hame'ya apamike'a ne'naya kumate Taipiliasi kumateti lipi kaleyaka e'a lavate'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mi'ko ve a'nemoki kahau a'a akayana Yisasi'ae akaeya ke ne'afea anaka'ae o'maike'a lipi kalefi Kapaneamu u'a Yisasife kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yisasi'a li la'kano mukakaya falika uno mai'nike'a kahau a'a ake'a fole aite'a inake hae “Ali'ka apaya nehana Nena na yu ma kumate e'nane?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Afine'kakeno Yisasi'a inake he “Nakaeya alaki lamake hu'na lahapa'nepauve lapa'kaeya nakaeya o'ake'naya avame hu lo'kiya ya lapaveluketapa ake'naya yafe kahau no'aya'maki lapa'kaeya ne'ya lapamuketapa netapa lapamu haya yafe nakaeya kahau ne'ae. ");
INSERT INTO ino_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lapa'kaeya ako kasalisea ne'ya alisaya yafe ali'ya o'aleo. O'alitapafa alaki maike maike hisaya ne'ya alisaya yafe'ke ali'ya aleo. Nakaeya Anumaya Koti afo'nimo nehaiya ve'ka hunate'nea ve'kamo'na ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na mani ne'ya lapamikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nehike'a akaeyafe inake hu'a afikae “Lakaeya hana kava huta Anumaya Koti ali'ya alisune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Afine'kakeno Yisasi'a inake he “Mani ali'yafe Anumaya Koti'a amuse hu'neana akaeya hute'nea mafa'ne'ae afitapa lapaipafi maletapa lapa'ku'a amitapa alakepa hisaya yafe amuse nehe.” ");
INSERT INTO ino_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nehike'a mi'ko vaya'moki inake hae “Hana akufa ali'ya alite'ka o'ake'nona avame hu lo'kiya ya lavelisanaketa aketeta laku'a kamita alakepa hisune? Kakaeya na kava hukane? ");
INSERT INTO ino_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A'ke'ainaka lakinakomoki ka'me koteka mai'ne'a mako ne'ya'mo aki'a mana ne'nayana ani yafe ako avopi inake huno kamale'neane ‘Ko'ku'napakati maya apamike'a ne'nae.’ huno hu'neane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hu'a hakeno Yisasi'a inake he “Nakaeya alaki lamake hu'na lahapa'nepauve Mosese'a ko'ku'napakati eline'nea maya olapami'nea'maki afo'nimo'a ko'ku'napakati alakepa maya nelapame. ");
INSERT INTO ino_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ani Anumaya Koti'a lapami'nea maya ko'ku'napakati e'nea ve'kae. Ani mayamo'a ma mopale mai'naya vayana apavamu ne'apame.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Inake huteke'a inake hu'a hae “Ala Netimoka mi'ko afina ani maya lamike lamike hu'ka maiyo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hakeno Yisasi'a inake huno hapapai'ne “Nakaeya nakai'nike apavamu apami maya mai'noanakeno nakaeyate esea ve'kamo'a mako'ae aka olekaiye. Nakaeyafe afino aipafi maleteno aku'a namino alakepa hisea ve'ka life mako'ae ohauke. ");
INSERT INTO ino_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ako lahapapai'noe. Nakaeya ako nake'naya'maki nakaeyafe afitapa lapaipafi maletetapa lapa'ku'a namitapa alakepa nohae. ");
INSERT INTO ino_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Afo'nimo'a mi'ko apavaleno nami'nea vaya'moki apaipa namikefe nakaeyateka ne'ayapati mako'ke'a nakaeyateka ne'ea ve'kae ‘Ete'ka ai'ka yahae hu'ka mukaleka uvo.’ hu'na huo'atekauve. ");
INSERT INTO ino_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hunate'nea ve'kamo haisea kava hisoa yafe ko'ku'napakati e'noanake'na nakaeya nakai'ni nahaisea kavana hisoa yafe o'me'noe. ");
INSERT INTO ino_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Inani hunate'nea ve'kamo haisea kava'mo'a ma kava hu'ne mi'ko apavaleno nayapi male'nea vayapati mako'ke'a fanane ohisafa ma mopa hano hisea afina alaki mi'ko fali'nisayapati ali'na hetipatesuke'a akola maike maike hukae. ");
INSERT INTO ino_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Afo'nimo'a ina kavafe amuse nehe. Mi'ko vaya'yaka mafa'ne'a ne'ake'a afi'a alakepa hu'a akaeya lakaeyate hulate'nea kavafe afi'a apaipafi malete'a apa'ku'a ami'a alakepa hisayana akola maike maike hisaya apavamu alikae. Alitesake'na ma mopa hano hisea afina fali'nisayapati ali'na hetipatesuke'a akola maike maike hukae. Ina akufa yafe afo'nimo'a amuse nehe.” huno nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nehike'a Yuta vaya'moki Yisasi'a “Nakaeya ko'ku'napakati eline'nea maya mai'noe.” huno hea ke Yisasife ke nete'a lusi ke nehatakae. ");
INSERT INTO ino_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Inake hu'a nehae “Ma ve'ka Yisasi'a Yosefe mafa'ne mai'nifi? Ani ve'ka mai'niketa ita afo'ala'mokani ako ana'ke'nona'maki na kava hikeno meni afina ‘Ko'ku'napakati eli'ne'noe.’ nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nehakeno Yisasi'a inake nehe “Lapa'kaeya ke hataketapa utetapa nehaya ke ataleo. ");
INSERT INTO ino_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mako ve'kamo'a nakaeyateka akai'ake akesa afino no'meanaki hunate'nea afo'nimo'a avayu hisikeno nakaeyateka esike'na ma mopa hano hisea afina fali'niseapati ete'na ali'na hetitesukeno avamu alike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yisasi'a inake nehe “Anumaya Koti aune vaya'aipati mako ve'kamo'a inake huno kamale'neane ‘Anumaya Koti'a mi'ko ve a'ne alino apaya huke.’ huno kamale'neane.” Yisasi'a inake nehe “Mi'ko vaya afo'nimo alino apaya hu'nea ke afite'a a'kame malesune hu'apaena nakaeyateka ekae. ");
INSERT INTO ino_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mako ve'kamo'a alaki Afo'nimona o'ake'nea'maki Anumaya Kotitekati e'noa ve'kamo'na nakai'nike afo'nimona ake'noe. ");
INSERT INTO ino_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Alaki lamake hu'na lahapa'nepauve nakaeyafe afino aipafi maleteno aku'a namino alakepa hu'nea ve'ka akola maike maike hisea avamu'a ako ali'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nakaeya nakai'nike apavamu apami maya mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A'ke'ainaka lapa'kinakomoki vaya o'mai ka'me koteka mai'ne'a mako ne'ya'mo aki'a mana ne'naya'maki fali'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Fali'naya'maki ko'ku'napakati eline'nea mayamo'a ma kava hu'ne. Nesaya vayana ofalikae. ");
INSERT INTO ino_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nakaeya apavamu apami maya mai'noe. Ko'ku'napakati eline'nea maya mai'noe. Mako vaya'moki mani maya nesayana akola maike maike hukae. Ani apamisoa maya nakai'ni nakufa name apamikoe. Ani nakufa name'a mani mopale mai'naya vayana akola maike maike hisaya yafe nakaeya falikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nehike'a Yuta vaya'moki ani hea ke ke ne'vai'a inake hu'a nehae “Mani ve'kamo'a hana'ya huno akufa amena alino lamisiketa nesuna yafe nehe?” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hu'a nehakeno Yisasi'a inake he “Nakaeya alaki lamake hu'na lahapa'nepauve lapa'kaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na nakufa name'ae kola'ni'ae o'nesayana maike maike hisaya lapavamu lapaipafi o'malekaiye. ");
INSERT INTO ino_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mako vaya'moki nakufa name'ae kola'ni'ae ne'nesayana akola maike maike hisaya apavamu ako ali'nayanake'na mani mopa hano hisea afina fali'nisayapati ali'na hetipatekauve. ");
INSERT INTO ino_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nakaeya nakufa namena alaki alakepa ne'ya hanete kola'ni'ae alaki alakepa li hanete hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mako vaya'moki nakufa name'ae kola'ni'ae nesayana nakaeya naipafi ne'maike'na nakaeya'ae ani kava hu'na apa'kaeya apaipafi'ae mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hunate'nea afo'nimo'a avamu'mo aepa'a mai'neno avamu nami'nea yafe mai'noanake'a mako vaya'moki nakaeya nakufa name nesayana ani vaya'yaka nakaeya apavamu apamisoa yafe maikae. ");
INSERT INTO ino_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mani ko'ku'napakati eline'nea mayamo'a ma kava hu'ne. Yuta vaya'ai apa'kinakomoki a'ke'ainaka ne'naya mayakana nohe. Ani maya nete'a ako fali'naya'maki mako vaya'moki ko'ku'napakati eline'nea maya nesayana akola maike maike hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisasi'a Kapaneamu mono nopi alino apaya nehuno mani ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mako akaeya ke ne'afea anaka'moki ani hea ke afite'a inake hu'a hae “Mani hea kemo'a lusi kava huno kana'ake nehiki hana ve'kamo'a mani ke afiteno a'kame malesea lo'kiya'a hane'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ani hea ke kanaku kanaku ke nehatakakeno Yisasi'a aipafi maleno afiteno inake he “Mani hoa kemo'a lapaipa alino hao'otake kava hea ke nehuketapaefe natalesaya lapa'kesa ne'afife? ");
INSERT INTO ino_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nakaeya ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea ve'ka ete'na hokote'na ne'mauva kumate visuketapa nakesayana hana lapaipa lapa'kesa afikae? ");
INSERT INTO ino_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anumaya Koti Avamu'amo'a maike maike hisuna lavamu nelamea'maki lakaeya ameka lakufamo'a mako kanale ya nolame. Lahapapai'noa kemo'a maike maike lapavamu alaki lapamisea ke'ae Anumaya Koti Avamu alaki lapamisea ke'ae hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ani ke lahapapai'noa'maki folakatapifati mako'amoki mani hoa ke afitapa lapaipafi no'malae.” nehe. Hae aepa he'nea afina afi'a apaipafi malete'a apa'ku'a o'amisaya vaya'ae akaeya akesi huno kame ya hutesea ve'ka'ae Yisasi'a ako afi'ne. ");
INSERT INTO ino_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yisasi'a mako'ae inake he “Inani ke inake hu'na lahapapai'noe mako ve'kamo'a akai'ake nakaeyateka o'mekaiya'maki afo'nimo'a esea akesa o'ami'nininana nakaeyateka o'menine.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ani ke hike'a nesu a'kame u'naya vaya'yaka ete'a ai'a yahae hu'a atale'a akaeya'ae lo'ka'a no'vae. ");
INSERT INTO ino_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","No'vaki Yisasi'a ayatala'a hano huteno aiyalekati aole alea anaka akaeya ke ne'afea anaka'aife inake huno apafine'ke “Lapa'kaeya'ae ani kava hutapa nakaeya nataletapa ukafe?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Apafine'kekeno Saimoni Pita'a akaeyafe inake he “Ala Nenao nalate visune? Kakaeya kemo'a maike maike huta maisuna lavamu nelame. ");
INSERT INTO ino_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nelamiketa lakaeya ani ke ako afita laku'afi maleteta kakaeya'ke fate akufa ve'ka Anumaya Kotitekati e'nana ve'ka kakaeya'kake mai'nane huta nehune.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nehikeno Yisasi'a inake he “Hana'ya nehe? Nakaeya nayatala'a hano huteno naiyalekati aole alea anaka le'kanapaimale'noa'maki folakatapifati mako ve'ka Sata afe mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yisasi'a Yutasife ani ke hu'ne. Ani ve'kamo'a ayatala'a hano huteno aiyalekati aole alea anakapati Yisasina hakefe hisaya vaya'moki apayapi avaleno atesike'a hakae. Ani ve'ka Saimoni Isa'kalioti mafa'ne mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anile Yutia koteka Yuta vaya'moki haesaya apa'kesa ne'afea yafe Yisasi'a Yutia mako'ae uneno ohuno Kalili kotekake uneno nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Hoyafi ne'ya afule'nea emu kisaya kanamo'a aupasi nehike'a Yisasi akana'amoki inake hu'a hapai'nae “Ma kumana atale'ka Yutia koteka uke'a kakaeya ke ne'afea anaka'moki kakaeya lo'kiya'kaleti alinana ali'ya akeo. ");
INSERT INTO ino_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mako ve'kamo'a mi'ko vaya'moki nakesayafene huno kesi ali'ya o'ali'ne. Kakaeya ani lo'kiya ali'yana ma mopale vaya'ai apaulakale alisanake'a ani ali'ya'ka akesae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nehaya'maki ani akana'amoki akaeyafe afi'a apaipafi o'male'a Yisasina apa'ku'a ami'a alakepa ohu'ne'a ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ami'a alakepa ohakeno Yisasi'a inake he “Ali'ya'ni'a apavelisoa kana'ni va'yi ohu'nea'maki lapa'kaeya afa'a utapa mi'ko afina lapa'kaitapi lahapaisea kava hisaya kana hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nakaeya ke o'afi'naya vaya'moki lapa'kaeya kame ya huolapatekayanaki nakaeya ‘Hao'otake kava nehae.’ hu'na hapa'nepauva yafe nakaeyafe apaipamo'a kana hike'a kame ya hune'natae. ");
INSERT INTO ino_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nakaeya ali'ya alisoa kana'ni va'yi ohu'nea yafe meni emuleka o'ukuki lapa'kaeyatapike ani emuleka veo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ina akufa ke hapapaiteno afa'a Kalili koteka mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Akana'amoki emuleka utakeno henaka'a Yisasi'a anileka u'ne. Vaya apaulakale o'u'niki fala'kino ne've. ");
INSERT INTO ino_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fala'kino ne'vike'a Yuta vaya'moki akaeya emule eseafene hu'a kahau ame u'e'a nehu'a inake hu'a nehae “Ani ve'ka hanate mai'ne?” nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Nehake'a anile ali'a atalu hu'naya vaya'moki Yisasife lusi ke nehatake'a ke ne'vai'a mako'amoki “Kanale ve'kae.” hu'a nehake'a mako'amoki “Ake'atike ke nehuno vaya ano apavataka nehea ve'kae.” hu'a nehae. Yuta vaya'aife koli haya yafe ani ke ala ke ohu'a vase hu'a sumi kefati hu'a fala'ki'nae. ");
INSERT INTO ino_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ani emu ne'yana neke maleke humai'a mako Sota mai'a ne'nakeno Yisasi'a aole'ae mako'ae kana maiteno ala mono nopi uno alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Alino apaya nehike'a Yuta vaya'moki lusi apamo'yo ne'ai'a inake hu'a nehae “Mani ve'ka hana avo nopi u'nea ve'kakeno avona hapalino laha'nepaiye. Avo nopi o'u'nea ve'kamaki hanateti ani ke afi'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nehakeno Yisasi'a inake huno hapa'nepaiye ali'na lapaya nehoa yana nakaeya nakesafati ali'na lapaya nohoa'maki Nevaya hunate'nea ve'kamo'a nahapai'nea ke lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mako ve'kamo'a “Anumaya Koti haisea kava hukoe.” huno hisea ve'kamo'a mani ali'na lapaya hu'noa ke nakesafati lahapa'nepaufi Anumaya Koti'a nahapaike'na lahapa'nepaufi aepa'a afike. ");
INSERT INTO ino_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mako ve'kamo'a akai'a akesafati ke hisea ve'ka “Naki ali'a asaka hisae.” huno akai'ae ani ke nehea'maki mako ve'kamo'a “Nevaya'a hunate'nea ve'kamo aki ali'a asaka hisayafene.” huno nehea ve'ka kanale aipa akesa'ae ve'ka mai'neanakeno ake'atike nohe. ");
INSERT INTO ino_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosese'a ke male male'nea ke ako lahapapai'nea'maki lapa'kaeya mako'amokitapa ani ke a'kame no'malae. Na'ya hiketapa meni afina nahakefe nehae huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Apafine'keke'a vaya'moki inake hu'a nehae “Sata afe'mo'a kakaeya kaipafi mai'neno kavalelitata nehe. Nalaki kahakefe nehake'kae nehane?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nehakeno Yisasi'a inake huno hapapai'ne “Nakaeya mako lo'kiya ali'ya Sapati afina aluketapae ani yafe lapamo'yo ne'aife? ");
INSERT INTO ino_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosese'a a'ke'ainaka ne'mafa'netapi'ai apa'koya ameka akufa'a ‘Laka heo.’ huno ke male male'nea ke hapapai'ne. Afa'a ani kavana Mosese'a alino aepa ohe'neanaki Mosese akinakomoki ani kava aepa he'nae. ‘Ani ke male male'nea ke a'kame malekaune.’ hutapaena ne'mafa'netapimoki apa'koya ano'a laka nehayana Sapati afina laka nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lapa'kaeya ‘Mosese ke male male'nea ke alita o'atakaesune.’ hutapaena Sapati afina ne'mafa'ne'ai apa'koya ano'a laka nehaya'maki na'ya hiketapa nakaeya Sapati afina mako ve'kamo akufa mi'ko ali'na kanale hute'noa yafe lahapai vai ne'natae? ");
INSERT INTO ino_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Haviku ke nehae ameka yate aketapa fa'ko ohutapa alakepa ya aketetapa fa'ko heo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nehike'a ani ke afite'a mako Yelusalemu mai'naya vaya'moki inake hu'a nehae “Mani ve'ka hakaune hu'naya ve'kafe? ");
INSERT INTO ino_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Inaki akekeo akaeya vaya apaulakale kake nehea'maki mako vaya'moki akaeyafe ke ama'kike'kana ke nohae. Ma ve'kae kava vaya'moki ake'a Anumaya Koti'a lakufa alino katilateseafe hute'nea ve'ka mai'ne hu'a ako afi'nafe? ");
INSERT INTO ino_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anumaya Koti lakufa alino katiseafe hute'nea ve'ka eseana vaya'moki ‘Hana kumateti e'ne.’ hu'a e'nisea kuma o'akekaya'maki ma ve'ka e'nea kuma ako ake'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nehakeno Yisasi'a ala mono nopi mai'neno huno apave nelino ala kefati inake nehe “Lapa'kaeya nakaeya ako naketapa alakepa hutetapa e'noa kuma'ae ako afi'nae. Nakaeya nakai'ni nakesafati o'me'noa'maki nakaeya hunate'nea ve'kamo'a lamake ke'ake ve'ka mai'nea'maki lapa'kaeya ani ve'ka o'ake'nae. ");
INSERT INTO ino_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","O'ake'naya'maki nakaeya akai'aleti e'noafenake'na ako ake'noe. Akaeya hunateke'na e'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nehike'a atafa hu'a nofi hutesaya apa'kesa afi'naya'maki falisea kana'a saufa va'yi ohu'nea yafe mako ve'kamo'a akufale aya maleno atafa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nofi hutekaya'maki nesu vaya anifi mai'naya vaya'moki akaeyafe afi'a apaipafi ne'male'a inake hae “Anumaya Koti'a lakufa alino katiseafe hutesea ve'ka eseana ma mai'nea ve'kamo'a o'ake'nona avame'ya hu lo'kiya hu'nea kavana akasesifi? He'e ao'kasekaiya'maki ma ve'ka Anumaya Koti'a lakufa alino katiseafe hute'nea ve'ka mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nehake'a Falasi mono ke ne'afea vaya'moki akaeyafe sume ke nehaya ke afite'a mono nopi kava vaya'moki'ae Falasi mono ke ne'afea vaya'moki'ae ati vaya'aina hupatake'a Yisasina atafa hu'a nofi hutesaya yafe avaleke ne'vae. ");
INSERT INTO ino_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Vakeno Yisasi'a inake nehe “Aupasi kana'ake lapa'kaeya'ae maike'na hunateke'na e'noa ve'kaleka ako ete'na ukoe. ");
INSERT INTO ino_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ukoanaketapa lapa'kaeya nakaeyafe kahau akaya'maki o'nakekae. U'na maisoa kumatena lapa'kaeya o'ukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nehike'a Yuta vaya'moki apa'kai'api ke hu'a imafi mafi nehu'a make hu'a nehae “Mani ve'ka hanate ukeanaketa o'akekaune? Hifi akaeya Kali'ki koteka Yuta vaya latale'a u'naya koteka uno mai'neno ani Kali'ki vaya alino apaya hisifi? ");
INSERT INTO ino_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Akaeya hea ke ‘Lapa'kaeya nakaeyafe kahau akaya'maki o'nakekae. U'na maisoa kumatena o'ukae.’ huno hea kemo aepa'a na'yane huno'ae nehe?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Emu ki'a neme neme nehai'a ki'a avaya akefe nehaya afina ala kana hane'ne. Ani afina Yisasi'a hetimaleno ala kekefafati inake nehe “Mako ve'kamoka life kahaiseana e'ka nakaeyateti li no. ");
INSERT INTO ino_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mako ve'kamo'a nakaeyafe afino aipafi maleseana Anumaya Koti avopi inani ve'kae inake hu'neane ‘Alaki olane avamu amisea li'mo'a ani ve'kamo aipafati kapai hakeno uke uke huno uke.’ hu'neane.” ");
INSERT INTO ino_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisasi'a Fate Akufa Avamufe ani ke nehe. Akaeyafe afi'a apaipafi malesaya vaya ani Fate Akufa Avamu apamite apamite hukefe nehe. Apamikefe nehea'maki ani ke hea afina Yisasi'a saufa ko'ku'napi ohai'nea afinanakeno Fate Akufa Avamu saufa o'apami'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mi'ko ali'a atalu hu'naya vayapati mako vaya'moki ani ke afite'a inake hae “Lamake mani ve'ka Anumaya Koti aune ve'kae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nehake'a mako'amoki “Anumaya Koti'a lakufa alino katiseafe hute'nea ve'kae.” nehake'a mako'amoki inake hae “Anumaya Koti'a lakufa alino katiseafe hutesea ve'kamo'a Kaliliti va'yi ohuke. ");
INSERT INTO ino_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anumaya Koti avopi inake huno kamale'neane ‘Anumaya Koti'a lakufa alino katiseafe hutesea ve'ka Teviti nofipati va'yi huke. Teviti'a Petelehemu ne'maiya kumate va'yi huke.’ huno kamale'neane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Inake hute'a akaeyafe aolefi ali'a fa'ko fa'ka nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Fa'ko fa'ka nehaya'maki mako'amoki “Akaeya atafa hutapa nofi huteo.” hu'a haya'maki mako ve'kamo'a Yisasina atafa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ina kava hike'a ati vaya'moki ete'a mono nopi kava vayate'ae Falasi mono ke ne'afea vayate'ae vake'a inake hu'a apafine'kae “Na'ya hiketapa ani ve'ka avaletapa no'mae?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nehake'a ati vaya'moki inake hae “A'ke'ainaka'ae meni'ae mako vaya'moki Yisasi nehea akufa ke ohu'nae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nehake'a Falasi mono ke ne'afea vaya'moki inake hae “Lapa'kaeya'ae ako ano lapavataka hu'nife? ");
INSERT INTO ino_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Lakaeya kava vaya'ae Falasi mono ke ne'afea vaya'ae Yisasife afi'a apaipafi mako'amoki male'nafe? He'e o'male'nae. Ani kava nohaya'maki mani ali'a atalu hu'naya vaya'moki Mosese ke male male'nea ke o'afi'nafe apaipafi male'naya'maki Anumaya Koti'a hai vaipateno hani'ki yapi hupatekaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nehakeno Ni'kotimasi'a Yisasite u'nea ve'kamo'a apa'kaeya'ae mai'neno inake nehe “Lakaeya mono kemo'a inake hu'ne ‘Nofi hutesaya ve'kamo ke afitetake ina kava ma kava hu'nea ke hokotetapa afitetake henaka'a hao'otake kava hu'niseana nofi huteo.’ huno hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Nehike'a “Kakaeya'ae Kalili koteka ve'ka mai'ne'kae nehape? Anumaya Koti ke kamale'naya kefina hapali'ka afi'ka alakepa hute'ka afikane Kaliliti mako aune ve'ka fole o'aike.” hu'a hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mi'ko vaya'moki kuma'apileka vakeno Yisasi'a Olivi yosa'ake hane'nea avimapi hai'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Natepati Yisasi'a hetino ala mono nopi vike'a vaya'yaka mai'a veko nehakeno Yisasi'a faitopale mai'neno alino apaya nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Alino apaya nehike'a mono hapali'a hapa'nepaiya vaya'ae Falasi mono ke ne'afea vaya'ae akayana mako a'mo'a alu ve'ae kumai kava nehike'a akete'a avale'a e'a ani vaya'ai folakapi ate'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ate'ne'a Yisasife inake hu'a hapai'nae “Ali'ka apaya nehana Nenao ake'nape ma a'mo'a alu ve'ae kumai neheketa ake'none. ");
INSERT INTO ino_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosese'a lami'nea ke male male'nea kefina ‘Ani akufa kava hisea afe yafa kayoteti amakitapa keli vaiyo.’ huno kamale'nea'maki kakaeya na'yane hu'ka kakesa ne'afine?” ");
INSERT INTO ino_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yisasi'a mako akufa havike hisike'aena avale'a kake hutesaya yafe kahau ne'a'a ani ke a'a avataka hune'kakeno Yisasi'a mopale ape huno mako avo ka'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Avo ne'kaeke'a lusiya hu'a Yisasife afike afike nehakeno Yisasi'a hetino inake huno hapapai'ne “Lapa'kaeya folakapati aise hao'otake kava nohisana ve'kamoka hokote'ka yafa kayo ali'ka mani a amakeo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hapapaiteno halate ape huno mopale ani avo ka'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ani ke afite'a mi'ko vaya'yaka hokote'a alopa alopa vaya utake'a mako vaya henaka hatilavi'a ma'aileka u'a hano hutakeno Yisasi'a akai'ake mai'nikeno ani ana mako'ke'ake Yisasi aulakale hetino mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yisasi'a hetino inake he “Male kahakefe e'naya vayana hanate mai'nae? Kakaeya kake hukatesea ve'ka manile o'mai'nife?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Afine'kekeno ani a'mo'a inake he “Anumayamoka lamake alaki o'mai'ne.” nehikeno Yisasi'a inake huno nehe “Nakaeya'ae kake huo'katekauki afa'a ne'u'ka henaka'a mako'ae hao'otake kava oho.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Henaka'a Yisasi'a mono nopi ali'a atalu hu'naya vaya'aife inake hu'ne “Nakaeya ma mopafi vaya'aipi a'na halepatesoa ve'ka mai'noe. Nakaeya na'kame malesaya vayana ofalino ano halesea yana alitetapa hani yapi uteta ohukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nehike'a Falasi mono ke ne'afea vaya'moki akaeyafe inake hae “Kakaeya kakai'kae'ke kake'atike ke hu'ka fole ne'ainanaketa kakaeya ke o'afikune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nehakeno Yisasi'a inake nehe “He'e nakaeya nakai'ne ke hisoana hisoa kemo'a lamake hukoe. Nakaeya aepa he'na e'noa kuma'ae visoa ka'ae ako ake'noe. Ake'noanaketapa lapa'kaeya nakaeya e'noa kumate'ae visoa ka'ae o'ake'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lapa'kaeya ma mopafi vaya'moki kavateti kake hupatetapa atapa fa'ko nehaya'maki nakaeya mako'ke ve'ka kake hute'na a'na fa'ko nohoe. ");
INSERT INTO ino_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A'na fa'ko nohoa'maki nakaeya vaya ali'na fa'ko hu'nininana kanale'ya hu'na ali'na fa'ko hunine. Nakaeya nakaeya'nike vaya ali'na fa'ko fa'ka nohoa'maki hunate'nea Afo'nimo'ae lo'ka'neta'a kanale kava huta'a fa'ko nehu'ae. ");
INSERT INTO ino_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lapa'kaeya mono kemo'a inake nehe ‘Aole ve'kala'mokani mako'ke kate hisa'ana ana'kaeya kemo'a lamake huke.’ nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nakaeya nakai'ni ke hu'na fole ne'aukeno hunateke'na e'noa afo'nimo'a ani kava huno nakaeyafe huno fole ne'aiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nehike'a ani ke afite'a akaeyafe inake hu'a afikae “Afo'kamo'a hanate mai'ne?” hu'a afikakeno Yisasi'a inake he “Lapa'kaeya nakaeya o'nake'nisayana Afo'nimo'ae ani kava hutapa o'ake'nae. Nakaeya nake'nininana Afo'nimo'ae ani kava hutapa ake'ninine.” ");
INSERT INTO ino_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisasi'a mani ke ala mono nopi amuse ya ne'malaya aupalika mai'neno ani ke alino apaya neheanaki akai'a falisea kana'a va'yi ohu'nea yafe mako ve'kamo'a akaeya avaleno nofi huo'ate'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Huo'ate'nikeno Yisasi'a eteno mako'ae inake hu'ne “Nakaeya ako ukoanaketapa nakaeyafe kahau akaya'maki lapa'kaitapi hao'otake yatapi o'atalekayanakeno hane'nisiketapa falikayanaketapa nakaeya visoa katena lapa'kaeya o'ukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nehike'a Yuta vaya'moki inake hae “Nakaeya visoa katena lapa'kaeya o'ukae hea kemo aepa'a akai'a akufa haesikeno falisea yafe nehifi?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nehakeno Yisasi'a apa'kaeyafe inake he “Lapa'kaeya afetekati e'naya'maki nakaeya hanafakati e'noe. Lapa'kaeya ma mopafati e'naya'maki nakaeya ma mopafati o'me'noe. ");
INSERT INTO ino_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ina yafe lapa'kaeya lahapapai'noe ‘Lapa'kaitapi hao'otake yatapi o'ataletapa hane'nisiketapa falikae.’ hu'noe. ‘Nakaeya ma ve'ka mai'noe.’ hu'noa ke lapa'kaeya afitapa lapaipafi o'malesayana hao'otake yatapi o'atalesakeno hane'nisiketapa falikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nehike'a inake hu'a nehae “Kakaeya nalakae?” hu'a afikakeno Yisasi'a inake he “Lapa'kaeya hokote'na lahapapai'noa ve'ka mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lusi ke lapa'kaeyafe kake hulapate'na ali'na fa'ko hulapatesoa ke hane'nea'maki nakaeya hunateke'na e'noa ve'kamo'a lamake ke'ake hu'nea ve'ka mai'neanake'na akaeyatekati afi'noa ke ma mopafi vaya lahapa'nepauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ani ke Afo'amofe nehea'maki apa'kaeya afi'a aepa ali'a o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","O'afi'naya yafe Yisasi'a apa'kaeyafe inake he “Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'ne lapa'kaeya yofo yosale alitapa asaka hisayana nakaeya ani ve'ka mai'noa yafe afitapa alakepa hukae. Ani afina ma ya afikae nakaeya nakai'ni nakesafati mako'ke yana ohu'noa'maki afo'nimo hu'nea ke'ake nehoanaketapa afikae. ");
INSERT INTO ino_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nakaeya hunate'nea ve'ka nakaeya'ae lo'kano mai'neno mi'ko afina akai'a amuse hea kava nehoa yafe nakaeya o'natale'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nehike'a lusi vaya'moki Yisasi'a hea ke afi'a apaipafi malete'a apa'ku'a ami'a alakepa nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yisasife afi'a apaipafi malete'a apa'ku'a ami'a alakepa hu'naya Yuta vaya'aife Yisasi'a inake he “Lapa'kaeya nakaeya ke mi'ko afina a'kame malesayana nakaeya ke ne'afea anaka maikae. ");
INSERT INTO ino_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nakaeya lamake hoa ke afitapa alakepa hutapa afisakeno ani lamake kemo'a lapa'kaeyapi kana lahapau'nea yana nofi hulapate'naya yana hano hisiketapa afa'a a'va kate mai'naya vaya maikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nehike'a ke'ale inake hu'a hapai'nae “Lakaeya Epalahamu nofi vaya mai'nonanaketa mako vaya'moki nofi huolate'naketa miya o'ali ali'yana o'ali'nona'maki na'ya hike'ka lakaeyafe ‘Nofi hulapate'naya yafe miya o'ali ali'yapi ne'maiya ya hano hinaketapa meni a'va kate mai'naya vaya'kana hutapa maikae.’ hu'ka nehane?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Afine'kakeno Yisasi'a inake he “Alaki lamake hu'na lahapa'nepauve mi'ko vaya hao'otake kava alo hisayana hao'otake yatapimo'a nofi hulapate'niketapa miya o'ali ali'ya ne'alea vaya mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Afa'a miya o'ali ali'ya ve'ka mako afamo'ae akola lo'kano o'maikea'maki alite'nisea mafa'ne'amo'ke akola ani afamo'ae maike. ");
INSERT INTO ino_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anumaya Koti mafa'ne'amo'a hao'otake ya'mo'a lapatafa hu'nea yana alino atale'niseana afa'a meni a'va kate maiyo huno hulapate'nisiketapaena ako alaki alino atale'nea yafe mako'ae ani ali'yana o'alikae. ");
INSERT INTO ino_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakaeya ako afi'noe lapa'kaeya Epalahamu nofi vaya mai'naya'maki nakaeya hoa ke afitapa lapaipafi o'male'naya yafe nahakefe nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nakaeya afo'nimo'a naveli'nea kava'ake lahapa'nepauva'maki lapa'kaeya lapa'kaitapi afotapimo lahapapai'nea kava nehae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yisasife inake hae “Afotimo'a Epalahamu'ae.” hu'a hakeno “Lapa'kaeya Epalahamu mafa'ne mai'nininana akaeya hu'nisea akufa kava alo hinine. ");
INSERT INTO ino_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Alo hinina'maki meni nakaeya afo'nimotekati lamake'ake ke afi'noa ke lahapapai'noa ve'ka nahaesaya kava nehae. Epalahamu'a ina akufa kavana ohu'neane. ");
INSERT INTO ino_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lapa'kaeya afotapimo kava nehae.” huno hike'a apa'kaeya inake hu'a nehae “Itatimo'a kumai heno uneno nehuno ali olate'niki lakaeya mako'ke'ake afotimo'a Anumaya Koti'a akai'ake mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","43","Nehakeno Yisasi'a apa'kaeyafe inake he “Anumaya Koti'a afotapimo'a mai'nininana nakaeyafe lahapau lapayamopafati lahapainine. Nakaeya Anumaya Koti mafa'ne akaeyatekati e'noanake'na nakai'ni nakesafati o'me'noanake'na Anumaya Koti'a hunateke'na e'noa'maki na'ya hiketapa ke hoa ke afitapa alakepa nohae. Lapa'kaeya o'afimo hu'naya yafenaketapa nakaeya ke o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lapa'kaeya afotapimo'a Sata'a alilapateketapa afotapimo haisea kava hutapa a'kame malekefe nehae. Hokoteno aepa hu'neatekati vaya hapaeke'a fali'naya ve'kae. Ani ve'ka lamake ke aipafi o'male ve'ka mi'ko afina hao'otake kate uneno nehea ve'ka mai'ne. Havike hiseana mi'ko afina aepa'akeno alaki ani kava nehea kava nehe. Ani ve'ka Sata'a havike'ake ve'kakeno mi'ko havikemo afo'amo mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mai'nea yafe nakaeya lapa'kaeya lamake ke lahapa'nepauva yafe ke afitapa lapaipafi no'malae. ");
INSERT INTO ino_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hana ve'kamoka ne'nake'ka nakaeyafe ‘Hao'otake ya'ka hane'ne.’ hu'ka hukane? Nakaeya lamake ke lahapapai'noa'maki na'ya hiketapa nakaeyafe afitapa lapaipa no'name? ");
INSERT INTO ino_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mako vaya Anumaya Koti mafa'neyaka mai'ne'a Anumaya Koti ke ne'afea'maki lapa'kaeya Anumaya Koti mafa'neyaka o'mai'naya yafenaketapa nakaeya ke no'afe.” ");
INSERT INTO ino_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yuta vaya'moki ke anona'ale Yisasife inake hu'a nehae “Lakaeya lamake nehune kakaeyafe Samelia ve'ka mai'nanana Sata afe kaipafi mai'ne huta lamake hu'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nehakeno Yisasi'a inake hu'ne “Nakaeyapi Sata afe o'mai'nea'maki nakaeya Afo'nimo aki ali'na asaka nehoa'maki lapa'kaeya nakaeya naki alitapa asaka nohae. ");
INSERT INTO ino_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Alitapa asaka nohaya'maki naki ali'a asaka hisaya vayafe nakaeya kahau no'aova'maki mako'ke ve'kamo'a vaya'moki naki ali'a asaka hisaya yafe nehaiye. Ani ve'ka Anumaya Koti'akeno akaeya kake hupate ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Alaki lamake hu'na lahapa'nepauve nakaeya ke a'kame malesea'mo'a alaki ofalike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nehike'a Yuta vaya'moki akaeyafe inake nehae “Ani ke nehanaketa lakaeya afunana kakaeya kaipafi Sata afe mai'ne. Epalahamu'ae a'ke'ainaka Anumaya Koti aune vaya'ae fali'naya'maki kakaeya ‘Nakaeya ke a'kame malesaya'moki ofalikae.’ hu'ka nehape? ");
INSERT INTO ino_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kakaeya lakinakomona Epalahamuna akase'noa ve'ka mai'noe hu'ka nehape? Epalahamu fali'nike'a Anumaya Koti aune vaya'ae fali'nae. Kakaeya hana ve'ka mai'noe hu'ka nehane?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nehakeno Yisasi'a inake nehe “Nakaeya naki'ni'a ali'na asaka hisoana afa ya'kana hukea'maki Afo'nimo'a nakaeya naki alino asaka nehiketapa lapa'kaeya ani ve'kae ‘Anumaya Kotitimo mai'ne.’ hutapa nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nehaya'maki lapa'kaeya akaeya o'aketafa hu'nae. Nakaeya akaeya ako ake'noe. Nakaeya ‘Akaeyafe o'ake'noe.’ hu'nininana lapa'kaeya haya kava hu'na havike'ake ve'ka mai'ninina'maki nakaeya ako akaeya ake'ne'na akaeya ke a'kame ne'maloe. ");
INSERT INTO ino_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Epalahamu'a lapa'kinakomo'a nakaeyafe inake hu'ne ‘Nakaeya akaeya ma mopale va'yi hisea afina akekauve.’ huno amuse huteno aketeno mako'ae amuse hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nehike'a Yuta vaya'moki akaeyafe inake nehae “Kakaeya aole ve'kala'mokani anaiya anaya hano huteno mako ve'kamo ayatala'a hano hea kafu (50 kafu) ohu'ne'ka vayatama o'mai'nana'maki Epalahamuna kakaeya ake'nape?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nehakeno Yisasi'a inake nehe “Alaki lamake hu'na lahapa'nepauve Epalahamuna ali o'ate'nea afina nakaeya hokote'na ko'ku'napaka mai'noane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ani ke hea yafe yafa kayo ali'a asaka hu'a Yisasina hakefe nehakeno Yisasi'a fala'kino apataleno Anumaya Koti aki ali'a asaka nehaya nopakati ma'aileka u'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisasi'a kateka ne'uno mako ve'ka ita'amo'a hae alitea afina aulaka fali ka'nea ve'ka ake'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ake'nike'a akaeya ke ne'afea anaka'moki inake hu'a afine'kae “Ali'ka apaya nehana Nenao nala'a hao'otake kava hu'nea ya'mo'a mani ve'kamo aulaka fali ka'ne? Akai'afi ita afo'ala'mokani hao'otake kava ha'a ya'mo'a ani aulaka fali ka'ne?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Afine'kakeno Yisasi'a inake he “Ani ve'ka ita afo'ala'mokani'ae akai'a'ae hao'otake kava hu'naya ya'mo'a ani aulaka fali o'ka'nea'maki Anumaya Koti'a lo'kiya'amo'a alino kanale hutesike'a mi'ko vaya'moki akesaya yafe aulaka fali ka'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Meni kotino hale'nisea'ae'ke hunate'nea ve'kamo ali'yana alike alike huta maisune. Hani kiseana mako ve'kamo'a ali'yana o'alike. ");
INSERT INTO ino_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Meni nakaeya ma mopale mai'noa afinana nakaeya ma mopafi a'na halesoa ve'ka mai'noe.” ");
INSERT INTO ino_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Inake nehuno avaitu'na mopafi heteno mopa'ae avaitu'na'ae alino maleno akunaku huteno ani mopa alino kalifateno aulaka fali ka'nea ve'kamo aulakale malete'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Maleteteno inake huno hapai'ne “Kakaeya Siloamu li kotute u'ka kaukosa sese hute'ka ete'ka eno.” nehe. Nehikeno uno li faleteno eteno ne'ekeno aulakamo'a kanale hikeno ne'ake. Ani li kotu'mo aki'a lakaeya kefati make huta aki akaune “Hute'ne.” huta akaune. ");
INSERT INTO ino_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Eke'a kuma'ale vaya'ae mi'ko afina mani ve'ka aulaka fali ka'nea kanafi moni au'kaya huno “Moni nameo nameo.” nehike'a ake'naya vaya'moki'ae inake hu'a hu'nae “Ani ve'kamo'a mi'ko afina felu mai'neno moni au'kaya nehea ve'kafi alu ve'kae?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nehake'a mako'amoki “Ani ve'kae.” nehake'a mako'amoki “Fate ve'ka ani akufa ve'kae.” hakeno akai'a “Nakaeya ani ve'ka mai'noe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nehike'a mi'ko vaya'moki afine'kae “Hana'ya hanakeno kaulakamo'a kanale hukate'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nehakeno inake nehe “Mako ve'ka Yisasi'ae hu'a aki ne'aya ve'kamo'a hapa alino kalifateno alino naulakale malenateteno ‘Siloamu li kotuteka u'ka li falo.’ hike'na u'na li nefalokeno naulakamo'a haleke'na ake'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nehike'a ani vaya'moki “Hanate ani ve'ka mai'ne?” hu'a hakeno “Nakaeya o'ake'noe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ani kava hakeno Falasi mono ke ne'afea vaya'aiteka aulaka fali ka'neapati aulaka eteno ake'nea ve'ka avaleli'a u'nae. ");
INSERT INTO ino_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yisasi'a hapa alino kalifateno ani ve'kamo aulaka alino kanale hute'nea kana Sapati afinane. ");
INSERT INTO ino_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Falasi mono ke ne'afea vaya inake hu'a afine'kae “Hana'ya hanakeno kaulakamo'a kanale hukate'ne?” hu'a hakeno “Hapa alino kalifateno naulakale maleteke'na u'na li falokeno naulakamo'a haleke'na meni ne'akoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nehike'a mako Falasi mono ke ne'afea vaya'moki “Ani kava hu'nea ve'ka Sapati kana a'kame no'malea yafe Anumaya Koti'a ani ve'ka hutekeno o'me'ne.” hu'a nehake'a mako vaya'moki inake hae “Hana kava huno hao'otake kava nehisea ve'kamo'a ina akufa kava huno o'ake'naya avame ya hu lo'kiya kavana alo hininine?” hu'a nehake'a ani afina aolefi ali'a fa'ko fa'ka hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ina kava hake'a aulaka fali ka'nea ve'kaena ete'a inake hu'a afine'kae “Ani kaulaka alino kanale hukate'nea ve'kaena na'yane ke nehane?” hu'a hakeno inake he “Anumaya Koti aune ve'ka mai'ne hu'na nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nehike'a Yuta vaya'moki ani ve'ka aulaka fali ka'nea ve'kamaki meni aulakamo'a ako kanale he hu'a haya ke ake'atike nehe hu'a ani ke afi'a apaipafi o'male'nae. Apaipafi o'male'a ani aulaka fali ka'nea ve'kamo ita afo'amokanife ke hute'a anafikake'ana hapapai'ake'a ani ke afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ita afo'amokanife inake hu'a anafine'kae “Ma ve'ka alite'na'a afinana aulaka fali ka'nea mafa'netani mai'nife? Hana kava hikeno meni aulakamo'a kanale hikeno ne'ake?” hu'a anafine'kae. ");
INSERT INTO ino_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","21","Anafine'kake'ana ita afo'ala'mokani inake hu'na'ae “La'akaeya ake'no'ana mani ve'ka la'akaiti mafa'ne mai'ne. Ita'amo'a aliteateka aulaka fali ka'nea mafa'ne alite'nea'a ako ake'no'a'maki hana'ya huno aulaka kanale hikeno ake'nea'a o'ake'no'ae. Hana ve'kamo'a ani aulaka alino kanale hute'nifi o'ake'no'aki akai'ake ke hutapa afikekena'ao. Alopa ve'ka mai'neanakeno akai'a lahapapaike.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Ita afo'ala'mokani Yuta vaya'aife koli nehu'ana ani ke hu'na'ae. Yuta vaya'moki ako mako ke hu'a lo'kiya vaimalete'a inake hu'nae “Mako ve'kamoka Yisasife ‘Anumaya Koti'a lakufa alino katiseafe hute'nea ve'ka mai'ne.’ hisana ve'ka akola mono nopati avaleta ma'aileka atalekaune.” hu'naya ke koli neha'ae. Inani aepaleti “Alopa ve'ka mai'niki akai'a afikekeno'a lahapapaino.” hu'ana neha'ae. ");
INSERT INTO ino_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mako'ae aulaka fali ka'nea ve'kae ke hute'a inake hu'nae “Kakaeya Anumaya Koti aulakale alaki lamake nehu'ka Anumaya Koti aki ali'ka asaka ho. Akonana ani ve'ka hao'otake kava nehea ve'kae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nehakeno inake huno nehe “Nakaeya o'ake'noe akaeya hao'otake kava nehea nepi nohea nepi hu'na o'ake'noa'maki mako'ke ya'ake ake'noana hokoteno naulaka'ni fali ka'nea'maki meni naulaka'ni alino kanale hike'na ne'akoe. Ina ya'ake ake'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nehike'a inake hu'a afine'kae “Hana kava hukate'ne? Hana'ya huno kaulaka alino kanale hukate'ne?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Afine'kakeno inake huno hapa'nepaiye “Nakaeya ako hokote'na lahapapai'noa'maki lapa'kaeya ke'ni'a no'afe. Na'ya hiketapa etetapa halate nafine'kae? Lapa'kaeya'ae etetapa akaeya ke ne'afea vaya maikefe nehafe?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nehike'a apa'kaeya kamuke ne'ama'ki'a inake nehae “Kakaeya'ke Yisasi ke ne'afina ve'ka mai'nana'maki lakaeya Mosese ke ne'afuna vaya hai mai'none. ");
INSERT INTO ino_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anumaya Koti'a Mosese ke hapai'nea'a lakaeya ako afi'nonaki inani ve'ka hanatekati e'nifi lakaeya o'ake'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nehakeno aulaka fali ka'nea ve'kamo'a inake nehe “Inani kavana alaki fate akufa kava nehae. Lapa'kaeya va'yi hu'nea ka'a o'ake'naya'maki ani ve'kamo'a naulaka alino kanale hunate'ne. ");
INSERT INTO ino_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Lakaeya ako afi'none Anumaya Koti'a havi vaya'ai ke no'afea'maki mako vaya'moki Anumaya Kotife amuse hu'a aki ali'a asaka hisaya vayana Anumaya Koti'a nehaiya kava hisaya vaya mai'nisayana Anumaya Koti'a ke'api afike. ");
INSERT INTO ino_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A'ke'ainaka ma mopa aepa faino alo hu'nea kanaleti haneme eno meni mai'nona kanale mako ve'ka ita'amo'a aliteateka aulaka fali ka'nea ve'ka mai'nikeno ‘Mako ve'kamo'a aulaka alino kanale hute'ne.’ hu'a hu'naya ke mako o'male'nike'a o'afi'nayane. ");
INSERT INTO ino_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Inaki Anumaya Koti'a mani ve'ka hu o'ate'nininana mako lo'kiya kavana akaeya alo ohinine.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nehike'a akaeyafe inake hu'nae “Kakaeya ma mopafi hao'otake ya hane'nea yapati ita'kamo'a alikateke'ka e'nana'maki lakaeya meni ali'ka laya hukefe nehape?” hu'a nehae. Ani ke hute'a mono nopati ma'aileka avale'a yaka hutale'nae. ");
INSERT INTO ino_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yaka hutale'nakeno Yisasi'a ani ke afiteno ani avale'a yaka hutale'naya ve'ka aketeno inake he “Kakaeya ko'ku'napakati e'nea ve'ka vaya'mo alite'nea ve'kaena afi'ka kaipafi ne'malape?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Afine'kekeno ani ve'kamo'a inake he “Amuse'ka nehuki ani ve'ka nala'ae? Nahapaisanake'na ani ve'kaena afi'na naipafi malekauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nehikeno Yisasi'a akaeyafe inake he “Kakaeya ani ve'ka ako ake'nane. Ani ve'ka'ae meni kake neha'ae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nehikeno ani ve'kamo'a inake nehe “Anumaya'nimoka meni kakaeyafe afi'na naipafi ne'maloe.” nehuno amuse huno akaeyate ale'ya alo ano alino soso hune'ate. ");
INSERT INTO ino_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yisasi'a inake he “Nakaeya ma mopale vaya ali'na fa'ko fa'ka hu'na kake hupatesoa yafe e'noe. Ali'na fa'ko hisuke'a apaulaka fali ka'nea vaya'moki apaulaka kanale hupatesike'a akekae. Akesakeno apaulaka ne'akesaya vayana eteno fali kakaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nehike'a mako Falasi mono ke ne'afea vaya haute mai'ne'a ani hea ke afite'a akaeyafe inake hu'a afine'kae “Lakaeya'aefe lapaulaka fali ka'ne hu'ka nehape?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Afine'kakeno Yisasi'a inake nehe “Lapaulakamo'a fali ka'nininana Anumaya Koti'a ‘Hao'otake yatapi hane'ne.’ huno ohinina'maki lapa'kaeya ‘Laulakamo'a haleketa kanale huta ake'none.’ hutapa nehaya yafe hao'otake yatapi hane'ne.” ");
INSERT INTO ino_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisasi'a inake nehe “Nakaeya alaki lamake hu'na lahapa'nepauve mako vaya'moki sipi sipimo keki'ya kipateti o'u'a keki'ya afafafati hale'a haisaya vayana kumaya vaya mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mai'naya'maki kipateti haino nefalea ve'ka sipi sipile ne'yakaiya ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kipate ne'yakaiya ve'kamo'a akaeya aketeno kita ya'kitekeno kipateti haino nefaleke'a sipi sipiyakamoki akele afi'nayanakeno akai'a sipi sipimoki apa'ki hanete hanete hu'neanakeno apa'ki ano makoteka makoteka nehuno apavaleno ma'ailaka nelave. ");
INSERT INTO ino_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Apavaleno ma'ailaka ne'uno uno hokoteno ne'vike'a sipi sipimoki a'kame ne'vae. Ani ve'kamo akele afi'nayanake'a a'kame ne'vae. ");
INSERT INTO ino_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A'kame ne'vaya'maki o'ake'naya vaya'moki a'kame o'ukae. Ani ve'kamo akele o'afi'naya yafenake'a apaune he'a aluleka ukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisasi'a ani avoya ke hapapai'nea'maki apa'kaeya afi'a alakepa hu'a o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","O'afi'naya'maki Yisasi'a eteno halate inake hu'ne “Alaki lamake hu'na lahapa'nepauve nakaeya sipi sipimoki haisaya kipa mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mai'noke'a mako vaya hokote'a e'naya vayana kumaya'ya nehu'a vaya nehapaya vaya e'naya'maki sipi sipiyakamoki ani vaya'ai apa'ke o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nakai'nike kipa mai'noe. Mako vaya'mokitapa nakaeyapi etapa falesake'na lapa'ku lapame ali'na katisuketapa uteta nehutapa nesaya ya alikae. ");
INSERT INTO ino_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kumaya ve'kamo'a kumaya'ya nehuno vaya neheno alino haviya hukefe ne'ea'maki nakaeya kanale lapavamu lapamikefe e'noe. Akola hano ohu lapavamu lapamisukeno ani avamu'mo'a lapaipafi havaitekaiye.” ");
INSERT INTO ino_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yisasi'a inake nehe “Nakaeya kanale sipi sipile kava ve'kamo'na sipi sipi anaka'nimoki apa'ku apame ali'na katisoa yafe falikoe. ");
INSERT INTO ino_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mako ve'ka sipi sipimo afo'amo o'mai'nea'maki miyatefe'ke ali'ya ne'alino kava yakai'nisikeno mako afela kala ne'eseana atale ne'maleno aune hesikeno ani afela kalamo'a sipi sipi anakana hapafaino hapalitata hisike'a apaune he'a u'e'a hukae. ");
INSERT INTO ino_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na'yafene ani sipi sipile kava ve'kamo'a akaeya miya alisea yafe'ke akesa afiteno ‘Sipi sipiyaka'ni mai'nae.’ huno akesa o'afino ataleno aune heno u'ne. ");
INSERT INTO ino_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nakaeya sipi sipile kanale kava ve'ka mai'noe. Mai'ne'na mi'ko afu anaka'ni apa'ke'noke'a afu anaka'nimoki nakaeya'ae ako nake'a aeto hu'nae. Afo'nimo'a akai'a aipa nami'nike'na nakaeya'ae naipa ami'noe. Ani kava hu'noa kava hu'a sipi sipiyaka'nimoki apaipa ne'namike'na nakaeya'ae naipa apami'noe. Nakaeya sipi sipi afuyaka'nimoki apa'ku apame ali'na katisoa yafe falikoe. ");
INSERT INTO ino_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mako sipi sipiyaka'ni apaote ma'ailaka mai'ne'a keki'ya veko'nifi o'mai'nayanake'na ani afuyaka'ni apavale'na esoana nakaeya nake afisake'na mako'ke'ake sipi sipi afu anaka'ni maisake'na mako'ke'mo'na sipi sipi afu anaka'aite kava ve'ka maikoe. ");
INSERT INTO ino_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Nakaeya afa'a falikoe.’ hu'na hoa ke Afo'nimo'a hau ayamopafati lusiya huno nakaeyafe nehaiye. Navamuna eteno namisike'na hetisoa yafenake'na navamuna afa'a atalekauve hu'na nehoe. ");
INSERT INTO ino_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mako vaya'moki navamuna naha'ofalekaya'maki nakai'ni nakesafati navamuna atalekauve. Navamu'ni'a atalesoa lo'kiya'ni hane'neanake'na navamuna atalete'na ete'na alisoa lo'kiya'ni hane'ne. Ani kava hisoa ke Afo'nimo'a nahapaike'na afi'noa ke hane'ne.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Inake huno hea yafe Yuta vaya'moki aolefi ali'a fa'ko hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nesu vaya'moki inake nehae “Sata afe akaeya aipafi mai'nikeno anekinaki nehiki na'ya hiketapa akaeya ke ne'afe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nehake'a mako vaya'moki inake hu'a hae “Sata afe'mo'a aipafi mai'nininana ma akufa ke ohinine. Sata afe'mo'a aulaka fali ka'nea ve'ka alino halai huteninipe?” hu'a apafine'kae. ");
INSERT INTO ino_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","A'ke'ainaka mono no kimalete'a kita ya'ki'naya kanae apa'kesa afi'a amuse nehaya emu Yelusalemu ki'nae. Kitakeno ani lanitani kana Yisasi'a Anumaya Koti nopi mai'neno yasi ne'alea no Solomoni'a ano analakimale'nea aupalika uneno nehe. ");
INSERT INTO ino_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nehike'a mi'ko Yuta vaya'moki e'a Yisasi mai'nea yate mai'a veko hu'a mai'ne'a inake hae “Laipa lakesamo'a aolefi aolefi nehuno kana'ake nehiki na yu lakaeya laipa lakesa ali'ka kanale hulatekane? Meni kakaeya Anumaya Koti'a hukateke'ka e'nana ve'ka mai'nisanana lamake hu'ka fole ai'ka lahapaiyo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Afine'kakeno Yisasi'a inake nehe “Nakaeya ako lahapapai'noa'maki nakaeyafe afitapa lapaipafi no'malae. Afo'nimo nami'nea lo'kiyaleti ali'noa ali'yana nakaeya naki lapaveli'ne. Nakaeya ani Anumaya Koti'a hunateke'na e'noa ve'ka mai'noa yafe lahapapai'nea'maki lapa'kaeya nakaeya sipi sipi anaka o'mai'naya yafe afitapa lapaipafi no'malae. ");
INSERT INTO ino_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","No'malaya'maki nakaeya sipi sipiyakamoki nakaeya nakele afite'a na'kame ne'malake'na nakaeya apa'kaeya ako apa'ke'noe. ");
INSERT INTO ino_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Apa'kete'na maike maike hu apavamuna ako apami'noanake'a ofalikae. Nakaeya nayapi ako mai'nayanakeno mako ve'kamo'a eno apavayu ohuke. ");
INSERT INTO ino_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Afo'nimo'a ani sipi sipi anaka nami'nea ve'kakeno mi'ko yana apa'kase'nea ve'ka mai'nea yafe alu ve'kamo'a afo'nimo ayapatina ha'ofalekaiye. ");
INSERT INTO ino_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Afo'nimo'ae nakaeya'ae mako'ke'ake mai'no'ae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nehike'a Yuta vaya'moki mako'ae yafa kayo ali'a asaka hu'a halate amakikefe nehae. ");
INSERT INTO ino_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nehakeno Yisasi'a inake he “Nakaeya mi'ko afo'nimo nami'nea kanale kavana lapa'kaeya lapaulakale alo hu'na lapaveli'noa'maki hana kava hu'noa yafe nakaeya yafa kayoteti nahakefe nehae?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Apafine'keke'a “Kanale ya hu'nana yafe yafa kayoteti o'kahakauna'maki kakaeya ma mopafi afa'a vayatafa'mokamaki ‘Nakaeya Anumaya Koti'na mai'noe.’ nehu'ka Anumaya Kotife hu'ka haviya hutana yafe yafa kayoteti kahakefe nehune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nehakeno Yisasi'a inake he “Lapa'kaitapi mono ke kamale'nea kemo'a inake hu'ne Anumaya Koti'a inake he ‘Lapa'kaitapi koti'kana vaya mai'nae.’ nehe hu'a kamale'nayane. ");
INSERT INTO ino_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Ani Anumaya Koti ke kamale'naya ke haneke haneke huno lamake ke'ake huke. A'ke'ainaka Anumaya Koti kemo'a ani vaya'aite uno ako hapa'nepaiya vayafe ‘Koti'kana vaya mai'nae.’ huno hu'niseana nakaeya Afo'nimo'a ‘Naha'ye hea ve'ka mai'nane.’ huno hunateke'na ma mopafina e'noki na'ya hiketapa ‘Nakaeyafe nakaeya Anumaya Koti mafa'ne'amo'nae.’ hu'na hoa ke ‘Anumaya Kotife hu'ka haviya hu ne'atane.’ hutapa nakaeyafe nehae? ");
INSERT INTO ino_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Nakaeya Afo'nimo ali'ya o'alininana nakaeyafe afitapa lapaipafi o'malesayana kanale kava hanina'maki nakaeya ani ali'ya ali'nisoana nakaeya ke afitapa lapaipafi ‘O'malesune.’ hutapaena nakaeya ali'yafe afitapa lapaipafi maleo. Ani kava hisayana Afo'nimo'a nakaeya'ae maike'na nakaeya ani kava hu'na akaeya'ae mai'noa ke afitapa alakepa hutapa afikae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nehike'a mako'ae nofi hutekefe atafa hukefe hu'naya'maki apataleno u'ne. ");
INSERT INTO ino_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne'uno Yisasi'a eteno Yotani li la'ka heno Yoni'a li falepate'nea aupalika uno mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mai'nike'a nesu vaya akaeyate ne'e'a inake hae “Yoni'a o'ake'nona avame ya hu lo'kiya ali'yana o'ali'nea'maki ma ve'ka mi'ko hu'nea kemo'a alaki lamake ke'ake hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mi'ko e'naya vaya'moki Yisasife afi'a apaipafi male'a apa'ku'a ami'a alakepa hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mako ve'kamo aki'a Lasalasi'a kali ali'ne. Ani ve'ka'ae asa'amo'a Mata'ae akana'amo'a Malia'ae Petani ne'maiya kumane. ");
INSERT INTO ino_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia'a mako afina mana'ake masaveteti Yisasi aiyale faleteteno ayo'kaleti ano kalopate'nea a'mafa'ne. Ani a'mafa'nemo asa'amo'a Lasalasi'a kali ali'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kali ali'nike'ana ani aole anu'kanala'mokani Yisasiteka mako ve'ka huta'akeno uno inake nehe “Anumayamoka kakaeya kahau kayamopafati lusiya huno ne'kahaiya ve'ka kali ali'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nehikeno Yisasi'a ani ke ne'afino inake he “Lasalasi'a kali ali'nea'maki falisea kali o'ali'niki ani kali Anumaya Koti aki ali'a asaka hisaya yafe ali'ne. Ani kali Anumaya Koti mafa'nemo'a no'akaya lo'kiya kava hisike'a akete'a aki ali'a asaka hisaya yafe va'yi hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mata'ae akana'amo'ae Lasalasi'ae Yisasi'a ani anaka'aife aipafati lusiya huno nehaiya anakane. ");
INSERT INTO ino_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","7","Lusiya huno nehaiya anaka'maki Lasalasi'a kali ali'nea ke afiteno o'uno aole afina ani mai'nea kumate maiteno akaeya ke ne'afea vaya'aife inake nehe “Yutia koteka eteta visune.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Hike'a akaeya ke ne'afea vaya'moki inake hae “Ali'ka apaya nehana ve'ka Yuta vaya'moki yafa kayoteti ali'a kamakikefe hu'naya koteka meni kakaeya halate ete'ka ani koteka ukefe nehape?” hu'a afike'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Afikakeno Yisasi'a akai'a mani mopale mai'nea kana'a hano ohu'nea yafe avoya ke nehuno inake he “Natepati ano hale'nea ya'mo'a ano hale'nikeno une netife? Mako ve'ka natena vailino ohakaiye. Ma mopale ano hale ya hane'nea yafenakeno ake'nea'maki hani'ainaka ano hale ya'a aku'ainaka o'male'nea yafenakeno uneno hiseana vailino hakaiye.” ");
INSERT INTO ino_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yisasi'a ani ke huteno mako ke inake nehe “Lakaeya vayatimo'a Lasalasi'a havano mai'neanake'na nakaeya u'na ali'na hetitekefe uve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Hike'a akaeya ke ne'afea anaka'moki inake hae “Anumayamoka akaeya afa'a havano mai'niseana kali'a kanale hutesikeno eteno hetike.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yisasi'a Lasalasife avoya ke nehuno ako fali'nea yafe “Havano mai'ne.” huno hea ke akaeya ke ne'afea anaka'moki o'afi'a “Afa'a havano mai'nikeno'ae nehe.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yisasi'a avoya ke ataleno huno fole aino inake he “Lasalasi'a ako fali'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lapa'kaeya nakaeyafe afitapa alakepa hutapa lamake hane hutapa lapaipafi maletapa lapa'ku'a namisaya yafe o'mai'nokeno fali'nea yafe amuse nehuki meni akaeyateka viketao.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi'a Yisasi ke ne'afea anaka'aife inake he “Viketao. Yisasi'ae makopi ne'visunake'a lahaesaketa makopi falisune.” nehe. Tomasi'ae aki lakaeya kefati aole mafa'ne ya hu'ne nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lasalasina aole'ae aole'ae kana kelifi kite'nakeno Yisasi'a uno va'yi hike'a kite'naya kana'ae hapaikeno afi'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Yelusalemu kuma'mo haute (3 kilomita) Petani kumana hane'neanake'a ani yafe mi'ko Yuta vaya'moki Yelusalemuti Mata'ae Malia'ae anasa'animo'a fali'nea yafe hapautaki fotaki hunatekefe e'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","E'nakeno Mata'a Yisasife ne'e ke afiteno kateka uno fotu hu'na'a'maki Malia'a no'afi mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mai'nikeno Mata'a Yisasife inake he “Anumayamoka kakaeya male mai'naninana nasa'nimo'a ofalinine. ");
INSERT INTO ino_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ofalinina'maki ako afi'noe meni kakaeya Anumaya Kotiteka mako yafe ke hu'ka afikesanana afa'a kamike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nehikeno Yisasi'a inake huno hapai'ne “Kasa'kamo'a avamu'a hano hu'nea'maki eteno avamu'a aliteno hetike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hikeno ani a'mafa'nemo'a inake he “He nakaeya ako afi'noe mi'ko ya hano hisea afina mi'ko vaya fali'nayapati hetisaya afina eteno avamu'a alike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nehikeno Yisasi'a akaeyafe inake he “Nakaeya fali'naya vayana apavale'na asaka hu'ne'na apavamu ne'apamoa ve'ka mai'noe. Nakaeya maike maike hu apavamu apami ya'mo aepa'a mai'noe. Mako vaya'moki nakaeyafe afi'a apaipafi male'a apa'ku'a nami'a alakepa hisayana falite'a hetisayana akola maike maike apavamu afa'a alikae. ");
INSERT INTO ino_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mako vaya'a mai'ne'a nakaeyafe afi'a apaipafi malete'a apa'ku'a nami'a alakepa hu'naya vayana maike maike hukayanake'a ofalikae. Ma ke ako afi'ka alakepa hu'ka kaipafi male'nape?” huno afike'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Afikekeno ani a'mafa'nemo'a inake he “He Anumaya'nimoka nakaeya ako afi'na naipafi malete'na naku'a kami'na alakepa hu'noe. Lamake nehae kakaeya Kalaisika Anumaya Koti mafa'ne mai'nane. Ma mopale eli'ka esana ve'ka mai'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata'a ani ke huteno eteno ne'uno akana'amona Maliafe sumi huno inake huno ha'nepaiye “Alino apaya nehea ve'ka eno mai'neno kakaeyafe ke nehe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hikeno Malia'a ani ke afiteno makale'a hetino Yisasiteka ne've. ");
INSERT INTO ino_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ne'vea'maki Yisasi'a kumate va'yi ohuno Mata'ae fotu hu'na'a yate'ke mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mai'nike'a hanau hunatekefe e'naya Yuta vaya'moki Malia'ae nopi mai'nayateti Malia'a makale'a hetino kumateka vea yafe akete'a inake hu'a apa'kesa ne'afe “Vae Malia'a asa'amo kelileka uno avilekefe ne've.” hu'a a'kame u'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","U'nakeno Malia'a Yisasi mai'neateka uno aketeno aiyafi ape hu'neno inake he “Anumayamoka kakaeya male mai'naninana nasa'nimo'a ofalinine.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nehikeno Yisasi'a Maliana akeana avi nelekeno akaeya'ae mai'naya Yuta vaya'moki ani kava hu'a avi nelakeno Yisasi aipamo'a haviya hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aipamo'a haviya nehikeno apa'kaeyafe inake he “Hanate kite'nae?” huno hike'a “Anumayamoka e'ka ako.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nehakeno Yisasi aulakafati aunu eli'ne'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aunu eli'ne'eke'a Yuta vaya'moki inake hae “Akeo Lasalasife lusiya huno hau ayamopafati nehaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nehaya'maki mako vaya'moki inake hae “Mani ve'kamo'a mako aulaka fali ka'nea ve'kamo aulaka alino kanale aya'kete'nea'maki na kava hikeno Lasalasina ha'o'maekeno fali'ne?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yisasi aipamo'a mako'ae afino haviya huteno kite'naya kelileka u'ne. Ani keli yafa kapi kite'naya keli ala yafateti keli avayalena ai'a ati kamale'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ati kamale'nakeno Yisasi'a inake he “Ani keli avayaleti yafana alitapa ataleo.” huno hikeno Mata'a fali'nea ve'kamo asa'amo'a inake nehe “Anumaya'nimoka ani ve'ka kitonakeno aole'ae aole'ae kana kelifi mai'nea ve'kakeno hi'mana'ake huke.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nehikeno Yisasi'a akaeyafe inake he “Nakaeya mako ke ako kahapai'nofe? Inake hu'na ako kahapai'noe ‘Kakaeya nakaeyafe lamake nehane hu'ka afi'ka kaipafi male'ka kaku'a nami'ka alakepa hisanana Anumaya Koti aki ali'a asaka hisaya yana no'akaya lo'kiya ya akekane.’ hu'na kahapai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ani yafana ali'a ataletakeno Yisasi'a hanafaka ne'akeno inake he “Afo'nimoka amuse'ka nehuki kafikesoa ke ako afi'nane. ");
INSERT INTO ino_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Afi'nanake'na nakaeya afoana mi'ko afina kafine'koa ke ne'afinaki afa'a manile mai'naya vaya'moki kakaeya hunate'nanake'na e'noa ke lamake hane hu'a afi'a apaipafi malesaya yafe kafine'koe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ani ke huteno ala kekefafati inake he “Lasalasika hatilaveo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nehikeno fali'nea ve'ka hetino eke'a aiya aya aukosafi'ae kenaleti hayate'naya ve'ka ekeno Yisasi'a apa'kaeyafe inake huno hapapai'ne “Kalu hetapa atalekeno vino.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nehike'a mi'ko Yuta vaya Malia'ae e'a mai'naya vaya'moki Yisasi'a hea kava akete'a apaipafi malete'a apa'ku'a ami'a alakepa nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Apa'ku'a ami'a alakepa hu'naya'maki mako vaya atale'a Falasi mono ke ne'afea vaya mai'nayateka u'a Yisasi'a hea kavafe hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Hapapaike'a Falasi mono ke ne'afea vaya'ae ala mono nopi kava vaya'ae “Kanisole vayate kake hukune.” hu'a hapapai'nake'a inake hu'a nehae “Mani ve'ka lusiya huno o'ake'naya avame'ya hu lo'kiya kava nehuno ani kava neheanaketa hana'ya hukune? Afa'a atale'nisunakeno mi'ko afina ani kava'ake hisike'apaena mi'ko vaya'moki akaeyafe lamake he hu'a afi'a apaipafi male'a apa'ku'a ami'a alakepa hu'a amikae. Amisake'a Lomu vaya'moki kame hulatekefe e'a mani kumate mi'ko ya ala mono no'ae ali'a kapele ne'atale'a mi'ko koteka vayati'ae hapakae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nehakeno Kaiyafasi'a ani kafufina ala mono nopi ala kava ve'kamo'a ani vayapati hetino make he “Lapa'kaeya mako'ke ke no'afe. ");
INSERT INTO ino_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lapa'kaeya o'afi'nafe na ya kanale yana mi'ko koteka vayati hapaesake'a falisafi? Mako'ke ve'ka mi'ko vaya'ai no alino falise?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ani kafufi Kaiyafasi'a ala mono nopi ala kava ve'ka mai'nea yafe Anumaya Koti'a ha'nepaikeno aune ame laka nehea'maki akai'a aipa akesafati nohe. Ani aune ame laka hu'nea aepa'a inake he “Yisasi'a Yuta vaya'ai hapa'maesea yafe falike.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Apa'kai'apile'ke ofalikiki fate fate koteka mai'naya vaya Anumaya Koti mako'ke mafa'ne anaka'ake maisaya yafe Yisasi'a falike nehe. ");
INSERT INTO ino_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ani afina aepa he'a Yuta vaya'aite kava vaya'moki Yisasina haesaya ke hu'a afite'a hu'a u'e'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ani yafe Yisasi'a Yuta vaya'ai apaulakale hetino uneno ohuno mako kumate uno mai'nea kuma'mo aki'a Efaleamu. Ani kumana vaya o'mai ka'me ko hane'nea haute hane'nike'a akaeya ke ne'afea anaka'ae anileka u'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yuta vaya'moki kafu'ae kafa'ae Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe ali'a atalu hu'a emu ki'nae. Ani emu kisaya kana'a aupasi hike'a mi'ko vaya mi'ko kumateti Yelusalemu hai'nae. Ke male male'nea ke hapa'nepaiya kava hukefe apa'kufa'ae apa'ku'ainaka'ae sese hukefe u'nae. Sese hute'a ani emu'api hati'a nekae. ");
INSERT INTO ino_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ala mono nopi ali'a atalu hu'a heti'ne'a Yisasife kahau a'naya'maki o'ake'nae. Apa'kaeya u'a afike e'a afike nehu'a inake nehae “Na'yane lapa'kesa ne'afe ne'ya nonate o'meanakeno esifi o'mesifi?” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nehake'a ala mono nopi kava vaya'ae Falasi mono ke ne'afea vaya'ae Yisasina atafa hukefe inake hu'nae “Ma kava heo. Yisasi'a havaesea kumana akesutapaena etapa lahapaiyo.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yisasi'a Petani va'yi nehikeno emu kisaya kana aupasi nehe. Mako kaya naya hano huteno mako kaya nayatekati mako'ke alea afina maite'a Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe emu kikefe nehae. Petani kumate Lasalasi'a fali'nikeno Yisasi'a alino hetite'nea ve'ka ne'maiya kumate Yisasi'a anile u'ne. ");
INSERT INTO ino_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","U'nike'a Yisasina amuse hutesaya ne'ya ka'naya ne'ya Mata'a alinuneno huno apamite apamite nehikeno Lasalasi'a Yisasi'ae mako vaya'ae lo'ka'a faitopale mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Faitopale mai'nakeno Malia'a masavena lusi monileti ali'nea masave mana'ake masavena ani masave'mo aki'a nati alino Yisasi aiyale la'kiteno ayo'kaleti ano kalopa ne'atekeno mana'amo'a kahau kahau hike'a nopi mai'naya vaya'moki afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Yisasi ke ne'afea vaya'aipati mako ve'kamo aki'a Yutasi Isa'kalioti'ae. Ani ve'kamo'a henaka'a Yisasina avaleno kame vaya'ai apayapi atesike'a haesaya ve'kamo'a inake nehe “Na kava hikeno ani mana'ake masave afa'a ne'atale? Alino la'ki o'ataleno afa'a ali'ninaketa mako vaya apamisunake'a tali hataleti kina (K300) miya lamitesaketa ani moni alita uta afeno'api o'male vaya apamisuna yafe'mo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yutasi'a afeno o'male vaya'aife akesa afino hau hune'apatea yafe ani ke nohea'maki mi'ko afina moni hane'nea kute kava yakaino mai'neno malaya moni kumaya alino ne'nea ve'kakeno ani ke nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yisasi'a inake he “Ma ana afa'a atalo. Nakaeya fali'nisuke'a ali'u'a kinatesaya yafe akesa afino meni ani masaveteti falene'nate. ");
INSERT INTO ino_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Afeno ya'api o'male vaya'moki lapa'kaeya'ae mi'ko afina maikayanaketapa apaya hisaya lapa'kesa afisaya afina apaya hukaya'maki nakaeya lapa'kaeya'ae mi'ko afina lo'ka'na o'maikoe.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nesu Yuta vaya'moki Yisasife “Petani kumate mai'nekaiye.” hu'a haya ke afite'a mai'neateka u'nae. Yisasi'ke akekefe o'me'naya'maki Lasalasi'ae ako fali'neapati alino hetitekeno mai'nea ve'ka'ae akekefe e'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lasalasi'a fali'neapati heti'nea yafe nesu Yuta vaya'moki kava vaya'api ne'apatale'a Yisasi ke afi'a apaipafi ne'male'a apa'ku'a ami'naya yafe ala mono nopi kava vaya'moki “Lasalasina haesunakeno falise.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Havate'a kotike'a Anumaya Koti'a apa'kinakomo apa'kufa alino kati'nea yafe apa'kesa afi'a emu ki'nake'a mi'ko vaya'yaka ani emule e'nae. E'naya vaya'moki “Yisasi'a Yelusalemu kumate ekefe nehe.” haya ke afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Afite'a masu haita hataka hute'a Yisasi ne'eateka u'a fotu hukefe u'nae. Ne'u'a ala kefati inake hu'a nehae “Lakufa ali'ka katisana ve'ka kanale'ya hu'ka ne'ane. Anumayamo ali'ya alikefe hanakeno hukate'nea ve'ka Anumaya Koti kanale manu kamiteno kaya hu'ne. Isaleli kumate yakaipate'nana ala ve'ka Anumaya Koti'a kaya hu'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nehakeno Yisasi'a mako hosikana afumo aki'a to'ki afu akeno fole aiteno akotofule faimai'ne. Ani kava hea kavana a'ke'ainaka Anumaya Koti ke kamale'nea kemo'a inake hu'neane ");
INSERT INTO ino_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yelusalemu vayana koli oheo. Meni lapa'kaeyate kava yakailapate'nea ve'ka to'kimo ana'au'amo akotofule faimaino ekaiye.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yisasi ke ne'afea anaka'moki Yisasi'a ani kava hea afina ani kamale'nea ke o'afi'naya'maki henaka'a Yisasi'a faliteno hetino hale ya'a hane'nea kumate haiteke'a apa'kesamo'a ha'kalo hike'a ani kamale'nea ke'ae vaya'moki ani afina hute'naya ya'ae apa'kesa afi'a hao hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yisasi'a Lasalasife “Kelifati heteo.” huno hikeno heti'nea afina mi'ko yake yake haya vaya'yaka ani afina Yisasi'ae maite'a “Ina kava ma kava hu'ne.” hu'a ke hapapai'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hapapaike'a ani yafe o'ake'naya lo'kiya'a apaveli'nea ke afi'naya yafe mi'ko vaya'moki u'a Yisasi'ae fotu hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fotu hake'a Falasi mono ke ne'afea vaya'moki apaote apaote ke hute hute hu'a make hu'a hu'nae “Mi'ko ma mopale vaya ako akaeya a'kame ne'vae.” ");
INSERT INTO ino_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mako Kali'ki vaya'moki Anumaya Koti aki ali'a asaka hukefe ani emu ne'ya nayateka u'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ani Kali'ki vaya'yaka Filipi mai'neateka u'nae. Filipi'a Kalili koteka hane'nea kuma Petesaitane hu'a nehaya kumateti ve'ka mai'nike'a akaeyateka u'a inake hae “Amuse'ka nehunaki lakaeya Yisasina akekefe ne'one.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nehakeno Filipi'a uno Etaluna hapaiteke'ana u'ana Yisasina hapai'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hapai'akeno Yisasi'a inake huno hanapai'ne “Ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na naki ne'a'a lusiya hu'a naki ali'a asaka hisaya kana meni va'yi nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Lamake hu'na lahana'nepauve mako'ke kile avina mopafi ofaiseana mako'ke ani kile avina'ake hanekaiya'maki mako'ke kile avina mopafi faimale'nisikeno alulu aino apalo huno haketeno ne'ya'a lusi yate alitekaiye. ");
INSERT INTO ino_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Alitekaiya'maki mako vaya'moki mi'ko ma mopafi yafe apa'kufa ali'a haisaya vaya'yaka apavamu'ae ani ya'ae mi'ko hano hukea'maki ma mopale vaya'moki apa'kufa ali'a hai yafe ‘Afa yane.’ hu'a nehaya vayana maike maike hukayanakeno apavamuna hano ohuke. ");
INSERT INTO ino_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mako vaya'moki nakaeyafe ‘Kakaeya ali'ya vaya maikune.’ hisayana na'kame eke eke hisae. Nakaeya ali'ya vaya nakaeya'ae maikefena na'kame esakeno Afo'nimo'a nakaeya ali'ya ne'alea vaya'aife ‘Ala ve'ka mai'nane.’ huno hupatekaiye.” ");
INSERT INTO ino_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yisasi'a inake nehe “Nakaeya naipamo'a lusiya huno kana ne'nahaiya'maki na ke hisoe? Afo'nimoka meni nakaeya nakufale fole aisea yana ali'ka atalo hisufi? He'e nakaeya inani akufa ali'ya alisoa yafe'ke e'noanake'na nakufa nakafu kisea yapi maikefe e'noe. ");
INSERT INTO ino_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Afo'nimoka kaki'ka ali'ka asaka ho.” nehe. Nehikeno anile ko'ku'napakati ake aino inake nehe “Naki'ni ako ali'na asaka hu'noanake'na ete'na mako'ae ali'na asaka hukoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nehike'a yake yake nehaya vaya'moki ake aiya ke afite'a mako'amoki inake hu'a nehae “Ko'ku'napakati ha'kali ha'kalu nehe.” hu'a nehake'a mako'amoki inake hu'a nehae “Mako ko'ku'napakati kayo kayo ve'kamo'a eno mako ke ha'nepaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nehakeno Yisasi'a haya kele inake nehe “Ani ake ne'aiya ke nakaeya naha'maesea yafe nohea'maki ani ke lapa'kaeya lahapa'maesea yafe nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Meni afina Anumaya Koti'a ma mopafi vaya'aina kake hupatekaiye. Meni afina ma mopafi kava ya alino mai'nea ve'ka Sata'ae ve'ka ako hafaitalekaiye. ");
INSERT INTO ino_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hafaitalekaiya'maki nakaeya ma mopafati navale'a asaka hu'a nasaisake'a mi'ko vaya'moki nakaeyateka apaipa namisaya yafe apavayu hukoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ani avoya ke hea kemo'a make hu'ne. Mani yateti yofo yosale nahaesake'na falikoe huno hapa'nepaiye. ");
INSERT INTO ino_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hapa'nepaike'a ani vaya'moki anona'a ke'ale inake hu'a ha'nepaiye “Lakaeya mono kemo'a inake huno lahapai'ne Anumaya Koti'a ‘Lakufa alino katiseafe hutesea ve'kamo'a mi'ko afina maike maike huke.’ huno lahapai'nea'maki na'ya hike'ka ma ke nehane? ‘Ko'ku'napati e'noa ve'ka vaya'mo alinate'nea mafa'ne asaikae.’ hu'ka nehane? Ani ko'ku'napakati e'nea ve'ka vaya'mo alite'nea mafa'ne nala'a mai'ne?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Afine'kakeno Yisasi'a inake nehe “Ano hale'nea ve'ka aise kana'a lapa'kaeya folakapi maikeanakeno lapa'kaeyate hani o'ki'nisea'ae hale yate ute ete heo. Hani aku'ainaka u'e'a haya vaya'moki visaya ka o'ake'a ‘Hana kate visune?’ hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hale ve'ka mai'nisea afina hale kanoe lamake hane hutapa afitapa lapaipafi maleo. Ani kava hisayana hale yatapi'ae vaya maikae.” nehe. Yisasi'a mani ke huteno uno fala ne'ke. ");
INSERT INTO ino_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nesu yate o'ake'naya avame'ya hu lo'kiya yana apaulakale hu'nea'maki afi'a apaipafi malete'a apa'ku'a o'ami'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ani yafe Anumaya Koti aune ve'kamo'a Aisaiya'a hu'nea ke ako va'yi huno ne'ya'a alitekeno lamake nehe. Ani ke Aisaiya'a inake huno hu'neane “Anumayamoka mani hu'nona ke nalaki afi'a apaipafi ne'malae? Anumayamo lo'kiya'a hana vaya'ai apaveli'nike'a afi'a alakepa nehae.” huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Aisaiya'a mako'ae inake hu'ne “Apaulaka o'akesaya yafe Anumaya Koti'a apaulaka alino fali kapate'ne. Apaipa afi'a alakepa ohisaya yafe apaipa alino lo'kiya vaiteno ‘Yafa'kana apa'kenopa'ae vaya maiyo.’ hupate'ne. Ani kava hupate'nike'a nakaeya ali'na kanale hupatesoa yafe nakaeyateka esaya yafe apaipa ai'a yahae ohisae hu'na ani kava hupate'noe.” huno hu'neane. Mani yafe lo'kiya'api o'male'neanake'a afi'a apaipafi malete'a apa'ku'a o'ami'nae. ");
INSERT INTO ino_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiya'a Yisasina fate akufa lo'kiya'a hane'nea hale ya'a aketeno akaeyafe ani ke hu'neane. ");
INSERT INTO ino_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ani ke hu'nea'maki Yuta kava vayapati nesu vaya'moki Yisasife afite'a apaipa ne'amea'maki Falasi mono ke ne'afea vaya'moki inake hae “Ani kava hisayana mono nopi o'meo huta hulapatekaune.” hu'a hu'naya yafe Yisasife “Ako afita laipafi maleta laku'a ne'amune.” hu'a fole no'aiye. ");
INSERT INTO ino_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ani vaya'moki Anumaya Koti'a “Kanale kava hane.” huno hisea yafe nohapaiya'maki ma mopafi vaya'moki “Kanale kava nehane.” hu'a hisaya yafe'ke nehapaiye. ");
INSERT INTO ino_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yisasi'a ala kekefafati inake hu'ne “Mako vaya'mokitapa nakaeyafe lamake nehe hutapa afitapa lapaipafi maletetapa lapa'ku'a namisayana nakai'nike lapa'ku'a no'namea'maki hunate'nea ve'ka'ae lapa'ku'a ne'ame. ");
INSERT INTO ino_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mako vaya'mokitapa ako ne'naketapa hunate'nea ve'ka'ae ne'akae. ");
INSERT INTO ino_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nakaeya a'na halesoa ve'ka ma mopale e'noe. Mi'ko vaya'moki nakaeyafe afi'a apaipafi malete'a apa'ku'a nami'nisaya vayana hani yapi o'maikae. Hani yapi o'maisaya yafe e'noe. ");
INSERT INTO ino_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mako vaya'mokitapa nakaeya ke afitetapa na'kame o'malesayana nakaeya lapa'kaeya kake huolapatekauve. Ma mopale vaya kake hupatesoa yafe o'me'noa'maki mopale vayana apa'kufa ali'na katisoa yafe e'noe. ");
INSERT INTO ino_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mako vaya'moki nakaeya apa'kame'ya namite'a nakaeya ke afi'a apaipafi o'malesakeno'aena mako ve'kamo'a kake hupatekaiye. Ma mopa hano hisea kana va'yi hiseana lapa'kaeyafe hu'na fole ai'noa ke'nimo'a kake hulapatekaiye. ");
INSERT INTO ino_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ani ke nakesafati ali'na fole ai'na lahapa'nopauki hunate'nea Afo'nimo'a akai'ake ho huno nahapai'nea ke'ake lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nakaeya ako afi'noe akaeya ke afitapa lapaipafi maletetapa akola maike maike hisaya lapavamu alikae. Ani yafe Afo'nimo'a nahapaiya ke nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Anumaya Koti'a a'ke'ainaka Yuta vaya'ai apa'kinakomoki apa'kufa alino kati'nea yafe apa'kesa afi ne'ya emu ki'a ne'naya kana makale va'yi hisikeno Yisasi'a ma mopa ne'ataleno Afo'amoteka haisea kanamo'a ako eno aupasi nehe huno akesa ne'afino ma mopafi vaya'moki akaeyafe afi'a apaipafi ne'malaya vaya'aife lusiya huno hau ayamopafati nehaikeno hau hupate'ne. Alaki lusi yate mako'ae hau ayamopafati haume ne'uno fali'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Unema'a Yisasi'a ayatala'a hano huteno aiyalekati aole alea anaka'a'ae ne'ya ne'nakeno Sata'a Yutasife “O'afisiki hu'ka akesi hu'ka u'ka kame vaya'aena hapapaisanake'a Yisasina haesae.” huno havi aipa akesa ami'ne. Yutasi'a mako aki'a Isa'kalioti Saimoni mafa'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sata'a ani aku akesa ami'nikeno Yisasi'a inake huno akesa afi'ne “Afo'nimo'a mi'ko lo'kiya yana ako nayapi maleteno Anumaya Koti'a hunateke'na e'noanake'na ete'na Anumaya Kotiteka haikoe.” huno ako afi'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ne'afino Yisasi'a ani ne'yana ne'ataleno hetino yasi kena'a asakino ne'ataleno mako tauli alino afafafi aino atafai'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Aino atafaili'neno li alino ala lapepi la'kiteno akaeya ke ne'afea anaka'ai apaiya aepa heno sese hupateteno afafafi aino atafai'nea taulileti alino hau hune'apate. ");
INSERT INTO ino_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sese hupateme eno Saimoni Pitate ekeno Pita'a inake he “Anumayamoka nakaeya naiya sese hunatekefe nehape? Kakaeya nakaeya naiya sese ohukane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nehikeno Yisasi'a ani hea kelena inake huno hapai'ne “Nakaeya meni ma nehoa kava'mo aepa'a o'afi'nana'maki henaka'a aepama'a afikane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nehikeno Pita'a akaeyafe inake he “Alaki lamake hu'ka nakaeya naiya sese hu o'natekane.” nehe. Nehikeno Yisasi'a eteno Pitafe inake he “Nakaeya kaiya sese hu o'katesoana kakaeya nakaeya'ae lo'ka'ka o'maikane.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Inani ke hea yafe Saimoni Pita'a inake he “Anumaya'nimokaki naiya'ake sese hu o'nate'ka mi'ko naiya naya'ae nakenopa'ae sese hunato.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Hu'nea'maki Yisasi'a inake huno hapai'ne “Ako li fale'nisea ve'kamo'a halate mako'ae li ofalekaiya'maki afa'a aiya'ake sese nehisikeno mi'ko akufa'a honi'ya ofaike. Lapa'kaeya mi'ko'amokitapa hao'otake kava haya honi'yatapi o'male'nea'maki mako'ke ve'kamo'ke hao'otake kava nehikeno honi'ya'ake hu'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ani ke neheana Yisasi'a akaeya akesi huno kame vaya'amoki apayapi atesike'a haesaya ve'ka ako ake'nea yafe “Lapa'kaeya mi'ko'amokitapa honi'yatapi o'male'ne.” ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Apaiya sese huteno yasi kena'a alino vaiteno faitopale mai'neno inake huno apafine'ke “Lapa'kaeyate nakaeya hulapatoa kavana ako afitapa alakepa hu'nafe? ");
INSERT INTO ino_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lapa'kaeya nakaeyafe ‘Ali'ka Laya Hu Nenao.’ nehutapa ‘Anumayatimokae.’ hutapa nehayana alaki lamake nehae nakaeya inani akufa ve'ka mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nakaeya Anumayatapimo'na ali'na lapaya hu ve'katapimo'na lapaiya sese hu nelapatoanaki lapa'kaeya'ae ani kava hutapa vayatapimoki apaiya sese hupateo. ");
INSERT INTO ino_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nakaeya ani hisaya kavana ako hu'na lapaveneluki lapa'kaeya nakaeya hulapate'noa kava hutapa heo. ");
INSERT INTO ino_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nakaeya alaki lamake hu'na lahapa'nepauve ali'ya ve'kamo'a kava ve'ka'a haino ao'kasekaiye. Kayo kayo ve'kamo'a hute'nea ve'ka ao'kasekaiye. ");
INSERT INTO ino_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lapa'kaeya ani ke afitapa alakepa hu'nayanaketapa ani kava hisayana amuse hutapa maikae. ");
INSERT INTO ino_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nakaeya ‘Amuse hutapa maikae.’ hu'na hoa ke mi'ko'amokitapae nohoa'maki nakaeya nahaike'na hapalimale'noa'ae ako afi'noe. Anumaya Koti ke a'ke'ainaka kamale'nea kemo'a make hu'ne ‘Nakaeya'ae ne'ya ne'nea ve'kamo'a nakaeya ano latapaikefe aiya alino asaka nehe.’ huno kamale'neane. Kamale'nea kemo'a meni fole aino ne'ya'a alitekeno lamake nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Henaka'a ani kana fole aisiketapaena nakaeyafe ‘Vae lamake akaeya Anumaya Koti mai'ne.’ hutapa afitapa lapaipafi malesaya yafe meni ani kana'a va'yi ohu'nike'na ako lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Lamake hu'na lahapa'nepauve nakaeya ali'ya alisea yafe hutesoa ve'ka mako vaya'moki avale'a ali'a kanale kava hutesayana nakaeya'ke navale'a ali'a kanale kava hune'natae. Nakaeya navale'a ali'a kanale kava hunatesaya vaya'moki nakaeya hunateke'na e'noa ve'ka ani kava hu'a avale'a ali'a kanale kava hune'atae.” ");
INSERT INTO ino_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisasi'a ani ke hutekeno aipamo'a lusiya huno kana nehaikeno inake huno fole ne'aiye “Alaki lamake hu'na lahapa'nepauve lapa'kaeya folakatapifati mako ve'kamoka vaya'moki afisaki hu'ka nakesi nehu'ka kame ya hunatekane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nehike'a akaeya ayatala'a hano huteno aiyalekati aole alea anaka'amoki i'aulakafi o'aulakafi hute'a “Nalafe nehe?” hu'a ani ve'kaena o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","O'afi'nake'na nakaeya Yoni'na akaeya ke ne'afea vaya'ae ne'mai'na hau ayamopafati nakaeyafe hau'nea ve'kamo'na haute mai'noe. ");
INSERT INTO ino_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mai'nokeno Saimoni Pita'a aumaliya nehuno nakaeyafe inake huno naha'nepaiye “Nalafe nehifi ke hu'ka afikeke'nao.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nehike'na nakaeya Yisasi amete maime ne'u'na akaeyafe inake hu'na hoe “Anumayamoka ani ve'ka nalafe nehane?” hu'na afikoe. ");
INSERT INTO ino_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Afikokeno Yisasi'a inake nehe “Nakaeya ne'ya ali'na memeyapi ate'na ali'na amisoa ve'kamo'a nakesi huno kame vaya'nimoki apayapi natesea ve'ka mai'ne.” nehe. Ani ne'ya alino memeyapi ateno Yutasi Saimoni Isa'kalioti mafa'ne ne'ame. ");
INSERT INTO ino_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Amikeno aliteno mai'nikeno Sata'a uno aipafi haino faleno mai'nikeno Yisasi'a akaeyafe inake he “Kakaeya alo hukoe hu'ka kakesa afina kavana makale alo ho.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nehike'a anile faitopale mai'naya vaya'moki Yisasi'a hu'nea kemo aepa'a o'afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","O'afi'naya'maki Yutasi'a moni kute yakai'nea ve'kakeno'ae “Yisasi'a akaeyafe inake huno ha'nepaiye hu'a mako'amoki ina apa'kesa ne'afe ‘Ala emule nesuna ne'ya u'ka ali'ka eno.’ huno'ae nehifi ‘Moni'api o'male vaya mako moni u'ka apameo.’ huno'ae nehifi?” hu'a apa'kesa afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Apa'kesa ne'afikeno Yutasi'a ani ne'ya aliteno makale'a ma'aileka hatilavino lusi hanipi u'ne. ");
INSERT INTO ino_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutasi'a hatilavi'nikeno Yisasi'a inake nehe “Meni ko'ku'napakati e'noa ve'ka vaya'mo alinate'nea mafa'nemo'na naki'ni ali'a asaka hukae. Nakaeya nahaesake'na falitesuke'a Anumaya Koti aki ali'a asaka hukae. ");
INSERT INTO ino_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nakaeya falisoa yafe Anumaya Koti aki ali'a asaka hisayana Anumaya Koti'a navalesike'na akaeya'ae maikoe. Makale navaleteno naki alino asaka huke. ");
INSERT INTO ino_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mafa'ne'nimokitapa lapa'kaeya'ae nakaeya aise kana'a maikoe. Maite'na ako visuketapa nakaeyafe kahau akaya'maki lo'kiyatapi o'male'neanaketapa visoa kumatena o'ukae. Ani ke Yuta vaya'aife ako hapapai'noa kemaki meni lapa'kaeya lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Meni mako saufa o'afi'naya ke male male'noa ke lahapapaikoanaki afeo. Vayatapimokife akola lahapau lapayamopafati nelahapaiseana apa'kaeya'ae ani kava hu'a lapa'kaeyafe hapaise. Nakaeya lapa'kaeyafe nahau nayamopafati ne'nahaiya kava hutapa vayatapimokife lahapau lapayamopafati nelahapaiseana apa'kaeya'ae ani kava hu'a lapa'kaeyafe hapau apayamopafati hapaise. ");
INSERT INTO ino_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ani kava hisayana mi'ko vaya'moki lahapau lapayamopafati nelahapaiya ya akete'a lapa'kaeyafe inake hukae ‘Yisasi ke ne'afea vaya mai'nae.’ hu'a hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimoni Pita'a inake nehe “Anumayamoka hanate ukane?” huno afikekeno Yisasi'a inake nehe “Visoa kumatena meni na'kame o'ukana'maki henaka'ake ukane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nehikeno Pita'a inake nehe “Anumaya'nimoka nakaeya na'ya hinake'na meni ka'kame o'visoe? Kakaeyafe nahau'neanake'na kaha'ma'na navamuna atale'na falikoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nehikeno Yisasi'a inake huno afine'ke “Kakaeya nakaeyafe ‘Lusiya huno nahau'neanake'na kaha'maesoa yafe navamu atale'na falikoe.’ hu'ka nehape? Alaki lamake hu'na kaha'nepauve ko'kolemo'a ake o'ai'nisike'ka kakaeya aole'ae mako'ae afina vane nehu'ka nakaeyafe ‘O'ake'noa ve'kae nehae.’ hu'ka naki a'ka fala'kikane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisasi'a inake nehe “Lapaipamo'a halekeno o'maino. Anumaya Kotife afitapa lapa'ku'a ne'amitapaena ani kava hutapa nakaeya'ae afitapa lapaipafi maletapa lapa'ku'a nameo. ");
INSERT INTO ino_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Afo'nimo nopina mi'ko vaya maisaya yana nesu ya hane'ne. Ani ya ohane'nininana ako lahapapaunine. Lahapapaunina'maki nakaeya no kumatapi ali'na avatati hulapatekefe nehoanake'na ukoe. ");
INSERT INTO ino_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nakaeya mai'noa kumate esaketa nakaeya'ae lo'kata maisuna yafe nakaeya u'na no kumatapi ali'na avatati hulapatete'na ete'na esoana lapavale'na visuketa alaki lo'kata maikune. ");
INSERT INTO ino_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lapa'kaeya ani kumate visoa kana ako ake'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nehikeno Tomasi'a inake nehe “Anumayatimoka visana kumana lakaeya o'afi'nona'maki hana kava huta visuna kafe afisune?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Afine'kekeno Yisasi'a inake nehe “Nakaeya'nike ko'ku'napi visaya ka'mo aepa'a mai'noe. Nakaeya lamake ke hu ya'mo aepa'a mai'noe. Nakaeya akola maike maike hu apavamu'mo aepa'a mai'noe. Mako vaya'moki Afo'nimoteka esayana alu kateti o'ukaya'maki nakaeya'ke ka'mo aepa'a mai'noa yafe alaki nakaeyateti'ke ukae. ");
INSERT INTO ino_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Lapa'kaeya nakaeya ako naketapa alakepa hu'nininana Afo'nimo'ae ani kava hutapa ako ake'ninina'maki lapa'kaeya meni aepa hetapa Afo'nimona ako ne'aketapa afitapa ako hale'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nehikeno Filipi'a inake huno hapai'ne “Anumayatimoka Afo'kamona lavelisanaketa akesunakeno laipamo'a mako'ae laka olese.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nehikeno Yisasi'a inake huno ha'nepaiye “Filipika yatala afina lapa'kaeya'ae lo'ka'na mai'noa'maki nakaeya aepa o'ake'nape? Mako ve'kamo'a nakaeya nake'niseana ani kava huno Afo'nimo'ae ne'akea'maki na'ya hike'ka ‘Afo'kamona laveleo.’ hu'ka nehane? ");
INSERT INTO ino_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nakaeya Afo'nimo aipafi maukeno Afo'nimo'a ani kava huno nakaeya naipafi mai'nea yafe kakaeya afi'ka kaipafi no'malape? Lahapapai'noa ke nakai'ni naku nakesafati ali'na lahapa'nopauva'maki Afo'nimo'a nakaeyapi mai'neno ali'ya ne'alino ani ke nahapai'nea ke lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nakaeya Afo'nimo aipafi mai'nokeno ani kava huno Afo'nimo'a nakaeya naipafi mai'ne hu'na nehoa ke afitapa lapaipafi maletapa lapa'ku'a nameo. Inake hoa kelefe lapa'ku'a o'namikefe lapa'kaeya mi'ko ne'aloa ali'yafe ake'netapa nakaeyafe afitapa lapaipafi ne'maletapa lapa'ku'a nameo. ");
INSERT INTO ino_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Alaki lamake hu'na lahapa'nepauve mako vaya'moki nakaeyafe afi'a apaipafi malete'a apa'ku'a nami'naya vaya'moki mi'ko ali'noa ali'yana ani kava hu'a alikae. Alikaya'maki nakaeya Afo'nimoteka visoa yafenake'a lusi ali'ya ali'a nakaeya ali'noa ali'yana ali'a nakase'a alikae. ");
INSERT INTO ino_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Inaki lapa'kaeya mi'ko yafe nakaeyafe afitapa nakaeya nakile nafikesayana ani kava hukoe. Mafa'ne'amo'na hu'noa kava'mo'a Afo'nimo aki ali'a asaka hisaya yafe ani kava hulapatekauve. ");
INSERT INTO ino_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ani kava hutapa mi'ko yafe nafikesayana nakaeyafe afitapa nakaeya nakile ke hutapa mi'ko yafe nafikesayana ani kava hulapatekauve.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Lapa'kaeya lahapau lapayamopafati nakaeyafe lahapaisiketapaena lahapapai'noa ke a'kame malekae. ");
INSERT INTO ino_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A'kame malesake'na Afo'nimoteka afikesukeno lahapa'maesea Avamuna hutesikeno eno akola maike maike huno lapa'kaeya'ae maike. Ani Fate Akufa Avamu'amo'a lamake'ake kemo aepa'a mai'neanakeno alino lapaya huke. ");
INSERT INTO ino_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mi'ko mani mopale yafe apa'kufa ali'a hai'naya vaya'moki ake'a afi'a alakepa ohu'naya yafe Fate Akufa Avamu'a o'avalekaya'maki lapa'kaeya ako aketapa alakepa hutapa mai'nayanakeno lapa'kaeya'ae mai'neanakeno lapaipafi eno maike. ");
INSERT INTO ino_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ani yafe lapatalesuketapa mekusa mafa'nekana hutapa o'maikayanaki lapa'kaeyate ete'na ekauve. ");
INSERT INTO ino_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aupasi afina mani mopale yafe apa'kufa ali'a nehaiya vaya'moki mako'ae nakaeya o'nakekayanaketapa lapa'kaeya nakaeya nakekae. Akola maike maike apavamu'mo aepa'a mai'noa yafe lapa'kaeya ani ya hutapa maike maike lapavamu alitapa maikae. ");
INSERT INTO ino_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mai'netapa lapa'kaeya mani kanale Fate Akufa Avamu'amo'a esea afina nakaeya Afo'nimo'ae mai'noketapa lapa'kaeya ani ya hutapa nakaeya'ae mai'nake'na nakaeya ani ya hu'na lapa'kaeya'ae mai'noa yafe afitapa alakepa hutapa afikae. ");
INSERT INTO ino_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mako vaya'moki nakaeya ke afite'a a'kame malesu'aena nakaeyafe hapau apayamopafati nehapaiye. Nakaeyafe hapau apayamopafati nehapaiya vayafe Afo'nimo'a ani ya huno apa'kaeyafe hau ayamopafati hauke. Haisike'na nakaeya'ae ani ya hu'na nahau nayamopafati apa'kaeyafe nahaisike'na naipa apamisuke'a nake'a alakepa hu'a nakekae” nehe. ");
INSERT INTO ino_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nehikeno Yutasi Isa'kalioti aomepa hamo'amo'a inake nehe “Anumaya'nimoka na'ya hinake'ka lakaeya laulakale aepa'a'ka lavelikananaki mi'ko ma mopale yafe apa'kufa ali'a hai'naya vaya'ai apaulakale hu'ka fole ohukane?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Afine'kekeno Yisasi'a inake he “Mako vaya'moki nakaeyafe apaipafati hapaisike'aena nakaeya ke a'kame malekae. A'kame malesakeno'aena Afo'nimo'a apa'kaeyafe ani kava huno aipafati hauke. Afo'nimo'ae nakai'ni'ae eta'a apa'kaeya'ae maiku'ae. ");
INSERT INTO ino_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mako vaya'moki nakaeyafe apaipafati ohapaiseana nakaeya ke a'kame no'malaya'maki lahapapai'noa ke nakai'ni ke o'maleanaki hunate'nea Afo'nimo ke hane'ne. ");
INSERT INTO ino_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Lapa'kaeya'ae mai'ne'na mani ke lahapapai'noe. ");
INSERT INTO ino_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lahapapai'noa'maki Afo'nimo'a nakaeya nakile hutesea ve'ka lapaya hu ve'kakeno mi'ko ya huno lapavelike. Ani hutesea ve'ka Fate Akufa Avamu'akeno mai'neno mi'ko lahapapai'noa ke lapa'kesa alino hao hisiketapa afikae. ");
INSERT INTO ino_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lapatale'na ukefe nehu'na yuna hetapa maisaya lapaipa lapa'kesa nelapamoe. Nakaeya yuna he'na mai'noa naipa nakesa nelapamoe. Ani nelapamoa yana ma mopale vaya'moki yuna hesaya ya nelapamea ya'kana noheanaki havi lapaipa lapa'kesa afitapa koli oheo. ");
INSERT INTO ino_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Lapatale'na ute'na lapa'kaeyate ete'na ekauve.’ hu'na lahapapai'noa ke ako afi'nae. Nakaeyafe lapaipafati nelahapaininana Afo'nimo'a nakaseno ala hu'nea yafe Afo'nimo mai'neateka ukefe hisoa yana amuse hanine. ");
INSERT INTO ino_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lapatale'na visoa afina afitetapa lapaipafi malesaya yafe meni afina visoa yafe lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sata'a ma mopale kava ve'ka makale'a ekefe neheanake'na nakaeya mako'ae ke ohukoe. Sata lo'kiya'amo'a nakaeya nao'kase'neanaki Afo'nimo'a nahapai'nea kava hu'na falikoe. ");
INSERT INTO ino_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nakaeya Afo'nimofe naipafati ne'nahaiya kavana ma mopale vaya'moki afisaya yafe Afo'nimo'a nahapai'nea kava nehoe. Hai'a nehuki ako viketao.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisasi'a inake nehe nakaeya lamake alakamo nofi mai'nokeno Afo'nimo'a ani alaka nofi hoyamo afo'amo mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akaeya mi'ko nakaeyate a'kama'nea nofi a'kopamo'a alaka'a no'aeyana yakeno ne'atale. Inaki kanale'ya huno alaka aeya a'kopama'a mako'ae kanale'ya huno nesu yate alaka aeseafene nehuno ai'a alino hakalo hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lapa'kaeya ako lahapapai'noa kemo'a ako alino hakalo hiketapa kanale'ya hutapa mako honi'ya yatapi o'male vaya mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lapa'kaeya nakaeyate kamatapa maisake'na nakaeya'ae ani kava hu'na lapa'kaeya'ae kama'na maikoe. Mako nofi alaka nofi'mo a'kopamo'a nofi'ale a'kamano ohaneseana ne'ya'a ali o'atekaiye. Ani kava hutapa lapa'kaeya'ae nakaeyate kamatapa alaki hutapa o'maisayana ne'ya'a ali o'atekae. ");
INSERT INTO ino_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nakaeya nofi'mo yosa'a mai'noketapa lapa'kaeya a'kopa'a'ni mai'nae. Nakaeyate kamano mai'nike'na akaeyate kama'na mai'noa ve'kamo'a alaka'a nesu yate ne'aeye. Inaki lapa'kaeya natalesayana alaki lamake hutapa mako akufa kanale kava ohukae. ");
INSERT INTO ino_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mako vaya'moki nakaeya'ae mai'a ohapaisayana alaka'a o'aeya a'kopakana hu'a hataka hutale'nisake'a vaikae. Vaitesake'a ani a'kopayaka ali'a anupa hute'a atafi yaka hu'a katalekae. ");
INSERT INTO ino_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Lapa'kaeya nakaeyate maitapa hapai'nisakeno nakaeya kemo'a lapa'kaeyapi hane'nisiketapa lahapau'nisea yafe nafikesayana afa'a lapamikoe. ");
INSERT INTO ino_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lapa'kaeya lusiya hutapa alaka'a aesayana Afo'nimo'a ala aki hanekaiye. Hanesea yafenaketapa lapa'kaeya nakaeya ke ne'afea vaya maikae. ");
INSERT INTO ino_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Afo'nimo'a nakaeyafe hau ayamopafati nehaiya kava hu'na lapa'kaeyafe ani kava hu'na nahau nayamopafati nahau'ne. Nahau nayamopafati nahau'nea vaya'nimokitapa nakaeya nahau nayamopafati ne'nahaiya aku'ainaka maiyo. ");
INSERT INTO ino_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nakaeya Afo'nimo'a hu'nea ke afi'na a'kame male'noa yafe Afo'nimo'a nakaeyafe hau ayamopafati nehaiya aku'ainaka ne'mauve. Mai'noketapa lapa'kaeya ani kava hutapa hu'noa ke afitapa a'kame malesake'na lapa'kaeya'ae nahau nayamopafati ne'nahaiya aku'ainaka maikae. ");
INSERT INTO ino_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nakaeya naipamo'a amuse ya hane'nea ya lapa'kaeya lapaipafi male'na havaitelapatesoa yafe ani ke lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nakaeya lapa'kaeyafe nahau nayamopafati ne'nahaiya kava hutapa vayatapimokife lahapau lapayamopafati lahapaisike'a ani kava hu'a apa'kaeya'ae lapa'kaeyafe hapau apayamopafati hapaino hu'na ke male male'noa ke ne'maloe. ");
INSERT INTO ino_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mako ve'kamo'a vaya'amofe “Kakaeya kakufa ali'na katisoa yafe nakaeya kakaeyatefe falikoe.” huteno faliseana mi'ko vaya'moki hapau apayamopafati nehapaiya kavana apa'kasekaiye. ");
INSERT INTO ino_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nakaeya hu'noa ke a'kame malesayana nakai'ni vaya maikae. ");
INSERT INTO ino_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nakaeya lapa'kaeyafe “Ali'ya vaya'ni mai'nae.” hu'na mako'ae ohukoe. Mako ali'ya ve'kamo'a kava ve'ka'amo ali'ya alea aepa'a o'ake'nea'maki nakaeya mi'ko ya Afo'nimo'a nahapai'nea ke ako lahapapai'noa yafe “Ali'ya vaya'ni mai'nae.” ohukoanaki ako lahapapai'noa yafe “Lapa'kaeya vaya'ni mai'nae.” hu'na nehoe. ");
INSERT INTO ino_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Lapa'kaeya nakaeya naketapa le'kanapai o'nate'naya'maki nakaeya hokote'na lapa'kaeya utapa Anumaya Koti haisea kava hisaya yapati ne'ya'a alitapa fole aisayana akola hanesea yafe lapa'ke'na ako le'kanapaite'na hulapate'noe. Hulapate'noketapa nakaeyafe ne'afitapa nakaeya nakile Afo'nimoteka mako yafe afikesayana mi'ko ani afikesaya yana lapamike. ");
INSERT INTO ino_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nahau'nea kavafe inake hu'na ke male male'noa ke ne'maloe vayatapimokife lahapau lapayamopafati lahapainake'a ani kava hu'a lapa'kaeyafe hapau apayamopafati hapaino. ");
INSERT INTO ino_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ma mopale yafe apa'kufa ali'a nehaiya vaya'moki lapa'kaeya kame ya hulapatesaketapaena lapa'kesamo'a hao hinaketapa afeo hokote'a nakaeya ani kava hu'a kame ya hunate'nae. ");
INSERT INTO ino_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Lapa'kaeya ma mopale vaya'kana hutapa mai'nininana mani mopale vaya'moki hapau apayamopafati lapa'kaeyafe hapainina'maki nakaeya ma mopale vayapati lapa'ke'na le'kanapaimale'noa yafe lapa'kaeya mopale vaya'kana vaya o'mai'nae. Ani yafe ma mopale yafe apa'kufa ali'a nehaiya vaya'moki kame ya hunelapatae. ");
INSERT INTO ino_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nakaeya inake hu'na ako lahapapai'noe “Ali'ya ve'kamo'a kava ve'ka'a ao'kase'ne.” Ani hu'noa ke lapa'kesa afitapa hao heo. Mako vaya'moki nakaeya lapa'kaeya kava ve'katapi ali'a haviya hunate'naya ya hu'a lapa'kaeya ani kava hu'a ali'ya vaya'ni'ae ali'a haviya hulapatekaya'maki mako vaya'moki nakaeya ke afi'a a'kame male'nisayana lapa'kaeya ke'ae ani kava hu'a afi'a a'kame malekae. ");
INSERT INTO ino_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hunate'nea ve'kae afi'a alakepa hu'a o'afi'naya yafe lapa'kaeya nakaeya vaya mai'naya yafe ani kava hulapatekae. ");
INSERT INTO ino_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nakaeya e'na ke hapa'opauninana apa'kaeya hao'otake kavana ohanine. Afa'a ako e'na hapapai'noa'maki hao'otake ya hu'naya yafe ete'a ke hisaya ke'api o'male'ne. ");
INSERT INTO ino_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nakaeya kame ya hunate'naya vaya'moki Afo'nimo'ae kame ya hute'nae. ");
INSERT INTO ino_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nakaeya apa'kaeyapi mai'ne'na mako vaya o'ake'naya lo'kiya kava ohininana hao'otake kavana ohanina'maki ako alo huke'a akete'a nakaeya'ae Afo'nimo'ae kame ya hunela'atae. ");
INSERT INTO ino_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Apa'kaeya ke male male'nea ke kamale'naya kemo'a nakaeyafe inake hu'ne “Hao'otake kava ohu'ninake'a kame ya hune'natae.” hu'a kamale'nayane. Ani ke fole aino ne'ya'a alitekeno lamake nehe hisea yafe nakaeya kame ya hunate'nae. ");
INSERT INTO ino_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lapaya hu ve'ka Afo'nimotekati hutesoa ve'ka lamake'ake ke hisea ve'ka Fate Akufa Avamuna Afo'nimotekati hutesukeno eseana nakaeyafe ke lahapapaike. ");
INSERT INTO ino_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lahapapaikeanaketapa nakaeya ali'ya aepa he'na ali'noa afina lapa'kaeya nakaeya'ae ako mai'nayanaketapa nakaeyafe mi'ko vayana ke hapapaikae. ");
INSERT INTO ino_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yisasi'a inake nehe nakaeyafe lapaipafi afitapa male'nayateti ataletapa o'visaya yafe mani ke lahapapai'noe. ");
INSERT INTO ino_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Apa'kaeya lapa'kaeya lapavale'a mono nopati lahapafaitalekae. Ani kana esea afina mako vaya'moki lapa'kaeya nelahapa'a ma apa'kesa afikae “Mani kava nehunana Anumaya Koti a'kame ne'malone.” hu'a hukae. ");
INSERT INTO ino_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Afo'nimo'ae nakaeya'ae apaipa ola'ami'naya yafe ani kavana hulapatekae. ");
INSERT INTO ino_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ani kana eno va'yi hisea afina lahapapai'noa kemo'a lapa'kesa alino hao hinaketapa afitapa alakepa hisaya yafe meni ani ke lahapapai'noe. Mani ke hokote afina lapa'kaeya'ae mai'noa yafe a'ke'ainaka lahapa'opai'noane. ");
INSERT INTO ino_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lahapa'opai'noa'maki meni hunateke'na e'noa ve'kamoteka ukoanaketapa mako ve'kamoka nakaeyafe “Hana'ale ne'vane?” hutapa nafio'ke'nae. ");
INSERT INTO ino_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nafio'ketapa nakaeya lahapa'nepauva ke lahapau nehae. ");
INSERT INTO ino_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lahapau nehake'na alaki lamake hu'na lahapa'nepauve nakaeya o'visoana lapaya hu ve'ka o'mekaiye. O'mekaiyanake'na nakaeya ute'na lapaya hisea ve'ka lapa'kaeyate hutesukeno eseana kanale lapa'kaeya lapaya huke. ");
INSERT INTO ino_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lapaya hu ve'ka eseana mi'ko ma mopale vayana hao'otake ya hu'naya aepa'ae fatako kava hu'naya aepa'ae Anumaya Koti'a kake hupatesea ya'mo aepa'ae huno fole ainake'a afikae. ");
INSERT INTO ino_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Hao'otake ya'mo aepa'ae lapaya hu ve'kamo'a inake huke “Yisasife afitapa lapaipafi no'malaya yafe hao'otake yatapi hane'ne.” ");
INSERT INTO ino_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nakaeya Afo'nimo mai'neateka ako visuketapa nakaeya mako'ae o'nakesaya yafe fatako kava hu ya'mo aepa'a lapaya hu ve'kamo'a huno fole ainaketapa afikae. ");
INSERT INTO ino_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Satana ma mopale kava ve'ka Anumaya Koti'a kake ako hute'nea yafe lapaya hu ve'kamo'a Anumaya Koti'a kake hupatesea ya'mo aepa'a fole ainaketapa afikae. ");
INSERT INTO ino_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nakaeya lusi ke lahapapaikoa'maki kana'ake hea yafe lapa'kaeya afitapa alakepa hutapa o'afikae. ");
INSERT INTO ino_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lamake ke nehea ve'ka Anumaya Koti Avamu'a eseana akai'alekati mi'ko Anumaya Koti lamake ke'a lapavelike. Akai'a aipa akesafati ke ohukeanaki ne'afea ke'ae henaka esea ya'mo ke'ae lahapapaike. ");
INSERT INTO ino_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ani ve'kamo'a nakaeya hu'noa ke lahapapaisike'a naki'ni lusiya hutapa alitapa asaka hukae. ");
INSERT INTO ino_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mi'ko Afo'nimo'a male'nea ya'a nakai'ni ya'ake hamale'ne. Ina kava hu'nea yafe ani ke hu'noe “Fate Akufa Avamu'amo'a amisoa ke alino lahapapaike.” hu'na hu'noe. ");
INSERT INTO ino_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Aise kana'a nakaeya mako'ae o'nakekaya'maki aise kana'a maiketapa etetapa nakekae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nehike'a mako akaeya ke ne'afea anaka'moki mako anaka'aife inake hae “Mani kemo aepa'amo'a hana'ya hu'ne? ‘Aise kana'a nakaeya mako'ae o'nakekaya'maki aise kana'a maiketapa etetapa nakekae.’ nehuno ‘Afo'nimoteka visoa yafe nehoe.’ huno nehiketa aepa'a no'afune. ");
INSERT INTO ino_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Aise kana'ae.’ heana aepa'a na'yane huno'ae nehe? Lakaeya akaeya hea ke no'afune.” hu'a huke afike nehae. ");
INSERT INTO ino_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nehakeno afikekefe haya ke Yisasi'a aipafi maleno afiteno inake he “Hu'noa ke ‘Aise kana'a nakaeya o'nakekaya'maki etetapa aise kana'a maiketapa nakekae.’ hu'na hoa ke lapa'kaeya lapa'kaitapi ani kemo aepa'aena hutapa uteta nehafe? ");
INSERT INTO ino_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Alaki lamake hu'na lahapa'nepauve lapa'kaeya lapatale'na visoa yafe avi alekaya'maki ma mopale vaya'moki amuse hukae. Hokotetapa lahapau hukaya'maki henaka'a lahapau hu ya'mo'a amuse ya hapakaiye. ");
INSERT INTO ino_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A'mo'a mafa'ne alitesea kana aupa nehikeno akufa akafu kisea kana va'yi hu'nea yafe aipa kana nehe. Aipa kana nehea'maki mafa'ne ako alitetekeno ‘Mafa'ne ako alitoe.’ huno amuse huno akufa akafu ki'nea yana ako ake'ne'kane. ");
INSERT INTO ino_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ani kava'mo'a lapa'kaeyapi'ae hane'ne. Meni lapa'kaeya'ae lapaipa kana nelahapaiyanake'na ete'na lapa'kesukeno lapaipafina amuse ya'mo'a havaitekaiye. Havaitesikeno mako ve'kamo'a ani amuse yana lahapa'ofalekaiye. ");
INSERT INTO ino_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ani kana eno va'yi hiseana lapa'kaeya nakaeyafe mako yafe nafio'kekae. Lamake hu'na lahapa'nepauve nakaeyafe afitapa naki atapa mako yafe Afo'nimoteka afikesayana mi'ko afikesaya yana afa'a lapamike. ");
INSERT INTO ino_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A'ke'ainaka'ae meni'ae nakaeyafe afitapa naki atapa mako'ke yafe Afo'nimoteka afio'ke'nae. Amuse yatapimo'a lapaipafina havaitese hutapaena nakaeyafe nafikeke'na lapamino. ");
INSERT INTO ino_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mani ke avoya ke humale'na lahapa'nepauvanake'na henaka'a ani avoya ke mako'ae ohukoanake'na Afo'nimofe hu'na fole ai'na lahapapaikoe. ");
INSERT INTO ino_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Hu'na fole aisuketapa ani afina nakaeya nakile afikekayanaki nakaeya lapa'kaeyafe Afo'nimona afikekauve hu'na nohoa'maki lapa'kaeya nakaeyafe lapaipafati nelahapaiya yafe Afo'nimo'a lapa'kaeyafe aipafati nehainekeno afikesaya yana akai'a lapamike. Nakaeya Anumaya Kotitekati e'noa ke afitapa lapaipafi ne'malaya yafe Afo'nimo'a lapa'kaeyafe aipafati nehaiye. ");
INSERT INTO ino_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nakaeya Afo'nimotekati ma mopafi e'noe. Meni nakaeya mani mopa atale'na Afo'nimoteka ukefe nehoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nehike'a akaeya ke ne'afea vaya'moki inake hae “Ako avoya kefati meni nohanaki mani ke hu'ka fole ai'ka nehane. ");
INSERT INTO ino_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Meni lakaeya afunana kakaeya mi'ko yana afi'nane. Mi'ko vaya'moki apaipafi afi'naya ya afi'nanaki mako'ke ve'kamo'a mako yafe kafio'kese. Mi'ko yana afi'nana ke lakaeya kakaeyafe ‘Anumaya Kotitekati e'nane.’ huta laipafi afita male'none.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nehakeno Yisasi'a inake nehe “Meni lapa'kaeya afitapa lapaipafi maletapa lapaipa ne'namife? ");
INSERT INTO ino_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Afeo mako kana makale'a ekefe neheana ako eno va'yi hu'ne. Ani kanafina mako'ke mako'ke'mokitapa nataletapa no kumatapile uteta hukae. Nataletapa visake'na nakai'nike maikoa'maki Afo'nimo'a nakaeya'ae maike. ");
INSERT INTO ino_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lapa'ku'a namitetapa lapaipa falu hutapa vase hutapa maisaya yafe ani ke lahapapai'noe. Ma mopale maikayanakeno mako kana'ake ya fole aikeanaki koli oheo. Nakaeya ma mopafi au'ava yana ako akase'na kava ya ali'na yakai'noe.” ");
INSERT INTO ino_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisasi'a ani ke huno hano huteno ko'ku'napaka aulu neheno Anumayamoteka inake huno ke nehe Afo'nimoka falisoa kana'a ako va'yi hike'na mafa'ne'kamo'na kaki ali'na asaka hisoa yafe falite'na heti'na kakaeyate haisuke'ka ala naki'ae lo'kiya'ni'ae mafa'ne'kamo'na nameo. Namisanake'na kakaeya kaki hanale ali'na asaka hukoe. ");
INSERT INTO ino_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mafa'ne'kamo'na mi'ko nami'nana vaya akola maike maike hisaya apavamu ne'apami'na mi'ko vayate kava yakaisoa lo'kiya'ka ako nami'nane. ");
INSERT INTO ino_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Anumaya Kotika kakai'kake lo'kiya ve'ka lamake ve'ka mako'ke'ake Anumaya Kotika mai'nane hu'a vaya'moki kakaeyafe ako afi'a alakepa hute'a hute'nana ve'ka Yisasife vaya apa'ku apame alino kati ve'ka ko'ku'napakati e'nea ve'ka mai'ne hu'a afi'a alakepa hu'naya yafe maike maike hu apavamu alikae. ");
INSERT INTO ino_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nami'nana ali'yana ako ali'na avaya a'noa yafe ma mopale kaki'ka ali'na asaka humale'noe. ");
INSERT INTO ino_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Humale'noanaki Afo'nimoka meni afina kakaeya kamete mai'nisuke'ka fate akufa ano halesea lo'kiya'ni nameo. Ma mopa alo ohu'nana afina kakaeya'ae mai'noanake'na fate akufa ano hale lo'kiya'ni hane'nike'na mai'noanaki meni ani ya hu'ka ani akufa ano hale lo'kiya'ni nameo. ");
INSERT INTO ino_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ma mopafi vayapati apavale'ka nami'nana vaya'aitena aepa'a'ka hu'na fole ai'na ako hapapai'noe. Ani vaya'moki kakai'ka vaya'yakake'ka apavale'ka nakaeya nami'nane. Nami'nanake'a ani vaya'moki kakaeya ke'kalena a'kame ne'malae. ");
INSERT INTO ino_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Nami'nana ke ako apami'noke'a ako atafa hu'a afi'a alakepa huli'ne'a nakaeya kakaeyatekati e'noa yafe afi'a alakepa huli'ne'a kakaeya hunatanake'na e'noa yafe afi'a apaipafi malete'a apa'ku'a nami'nae. Apaipafi male'naya yafe mi'ko nami'nana yana kakaeyatekati'ke e'ne hu'a meni afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Apa'kaeya hapa'maesane hu'na Afo'nimokaleka ke hu'na kafine'koe. Ma mopale yafe apa'kufa ali'a nehaiya vayafe Afo'nimokaleka meni kafi no'koa'maki kakai'ka apavale'ka nami'nana vaya'yaka kakai'ka vaya mai'naya yafe nami'nana vaya hapa'maesana yafe kafi ne'koe. ");
INSERT INTO ino_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mi'ko nakaeya vayana kakaeya vaya'akene. Mi'ko kakaeya vayana ani kava hu'a nakaeya vaya'ake mai'ne'a apaipa nami'naya vaya'nimoki nakaeya naki ali'a asaka hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ali'a asaka hu'nake'na meni ma mopa atale'na kakaeyate ukoanaki nakaeyafe afi'a apaipafi male'naya vayana ma mopafi maikayanaki Afo'nimoka fate akufa Afo'nimoka kakai'ka nami'nana kakile hane'nea lo'kiya'kaleti yakaipatesanana la'akaeya mako'kepi mai'no'a avamete mai'no'a ya hu'a apa'kaeya'ae mako'ke kate male'a mako'ke'a maisae. ");
INSERT INTO ino_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nakaeya apa'kaeya'ae lo'ka'na mai'noa afina kakaeya nami'nana kakile hane'nea lo'kiyaleti yakaipate'nokeno mako'ke ve'ka hani yapi leke leke nehea atafi o'ukea'maki Anumaya Koti ke kamale'naya kemo'a fole aino ne'ya'a alitesikeno lamake hisea yafe ani hani yapi leke leke nehea atafi visea ve'ka Yutasi'a akai'ake uke. ");
INSERT INTO ino_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Meni kakaeyateka ete'na ekauvanaki nakaeya nehoa amuse ya'mo'a apa'kaeya apaipafi havaitesea yafe ma mopale mai'ne'na mani ke hapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hapa'nepai'na kakaeya ke ako apami'noki nakaeya ma mopale vaya'kana ve'ka o'mai'na fate naku name'ae ve'ka mai'noke'a apa'kaeya'ae nakaeya'kana hu'a ma mopale vaya'kana vaya o'mai'a fate apa'ku apame'ae vaya mai'naya yafe ma mopafi ve a'nemoki apa'kaeyafe apaipa kafa hepate'a kame ya hupate'nae. ");
INSERT INTO ino_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kame ya hupate'naki nakaeya vaya'ni “Ma mopafati apavale'ka asaka ho.” hu'nae kafi no'koanaki Sata'a ano apavataka hu yafe “Yakaipate'ka apa'kufa ali'ka katike'a apa'kufaena kava hu'a maisae.” hu'naefe kafi ne'koe. ");
INSERT INTO ino_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nakaeya ma mopafi vaya'kana ve'ka o'mai'na alu naku name'ae ve'ka mai'noke'a apa'kaeya nakaeya'kana hu'a ma mopafi vaya'kana vaya o'mai'a alu apa'ku apame'ae vaya mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mai'nayanaki kakaeya'ka lamake'ake keleti fate akufa vaya maisaya apaipa apa'kesa apameo. Kakaeya hu'nana kemo'a lamake ke'ake nehe. ");
INSERT INTO ino_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kakaeya nakaeya hunatanake'na ma mopafi vaya'ai folakapi e'noana nakaeya ani kava hu'na mopale vaya'ai folakapi u'a maisae hu'na hupate'noe. ");
INSERT INTO ino_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hupate'noanake'a apa'kaeya lamake'ake keleti fate akufa vaya maisaya apaipa apa'kesa afisaya yafe nakaeya fate akufa ve'ka maisoa naipa nakesa ne'afoe. ");
INSERT INTO ino_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nakaeya'ae mai'naya vaya'ake hapa'maesana yafe kafi no'koa'maki apa'kaeya hisaya keleti nakaeyafe afi'a apaipafi malesaya vaya'aefe kafine'koe. ");
INSERT INTO ino_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Afo'nimoka inake hu'na kafine'koe mi'ko nakaeyafe afi'a apaipafi male'naya vayana mako'ke apaipale maisae. Mi'ko mopale ve a'nemoki kakaeya hunate'nanake'na e'noa yafe afi'a apaipafi malesaya yafe la'akaeya mai'no'a kava hu'a mako'ke apaipale maisae. Kakaeya nakaeyapi ne'mainake'na nakaeya kakaeyapi mauketa'a hu'no'a kava hu'a la'akaeyapi maisaketa mako'ke laipale maisune. ");
INSERT INTO ino_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","La'akaeya mako'ke la'aipa la'akesale mau'a kava hu'a mako'ke apaipa apa'kesale maisaya yafe ano halesea lo'kiya'ni nami'nana lo'kiya yana ako apami'noe. ");
INSERT INTO ino_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Apa'kaeya mako'ke apaipa apa'kesale mai'a alakepa hisaya yafe nakaeya apa'kaeyapi mauke'ka kakaeya nakaeyapi mai'nane. Nakaeyafe kahau kayamopafati kahau'nike'ka ani kava hu'ka ma mopale vaya'aife kahau kayamopafati kahau'nea ya'ae hunatanake'na e'noa ya'aefe mi'ko mopale vaya'moki afisaya yafe kakaeya ke afi'naya vayana mako'ke apaipa apa'kesale maisae. ");
INSERT INTO ino_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Afo'nimoka ma mopa alo ohu'ne'ka nakaeyafe kahau kayamopafati kahaike'ka nami'nana fate akufa ano hale lo'kiya'ni kakaeya apavale'ka nami'nana vayana maisoa kumatena nakaeya'ae mai'ne'a akesae hu'nae nehoe. ");
INSERT INTO ino_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Afo'nimoka hao'otake kava hu ya'ka o'male Afo'nimoka ma mopale yafe apa'kufa ali'a hai vayana kakaeyafe o'afi'nayanaki nakaeya ako kakaeyafe afi'noke'a ma mai'naya vaya'moki nakaeya hunatanake'na e'noa yana ako afi'nae. ");
INSERT INTO ino_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nakaeya apa'kaeya apa'ku'ainaka maisoa yafe aepa'a'ka ako hapapai'noe. Nakaeyafe kahau kayamopafati kahau'nea ya apa'kaeya apaipafi malesana yafe aepa'a'ka hu'na fole ai'na hapapai'noa'maki mako'ae hapapaikoe huno hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisasi'a ani ke Anumayamoteka ke huno afikeno akaeya ke ne'afea anaka'ae hatilavi'a mako otufi u'nae. Ani otumo aki'a Kitaloni. Ani li falika mako olivi yosa ha'kalemale'naya hoya hane'nike'a Yisasi'ae akaeya ke ne'afea anaka'ae ani hoyafi hai'nae. ");
INSERT INTO ino_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hai'naya'maki Yutasi'a Yisasina avaleno kame vaya'amoki apayapi atesea ve'kamo'a ani hoya ake'neane. Yisasi'a akaeya ke ne'afea anaka'ae ani hoyafi ali'a atalu hu'a ne'maiya hoyafinakeno Yutasi'a ake'neane. ");
INSERT INTO ino_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ake'neatenakeno Yutasi'a uno ala mono nopi kava vaya'ae Falasi mono ke ne'afea vaya'aite'ae vikeno mono nopi ati vaya'ae mako ati vaya'ae ne'apavaleno ani hoyafi ata kani'ae lamu kani'ae ala hisaya ati keve'ae ali'ne'a e'nae. ");
INSERT INTO ino_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yisasi'a mi'ko akaeya akufale fole aikefe nehea yana ako aketeno uno hapau'aleti inake huno apafine'ke “Lapa'kaeya nalafe kahau ne'ae?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nehike'a anona'a ke'ale inake nehae “Yisasi'a Nasaleti kumateti ve'kae eta kahau ne'aone.” hu'a nehae. Nehakeno Yisasi'a inake nehe “Ma nakaeya'ke mai'noafe'mune.” huno nehikeno Yutasi'a avaleno kame vaya'ai apayapi atekefe nehea ve'ka ani vaya'ae mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mai'nikeno Yisasi'a “Nakaeya ma mai'noafe'mune.” nehike'a apa'kamelakati la'ka'ka ai'a asakau'a ai'nae. ");
INSERT INTO ino_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Asakau'a ai'nakeno Yisasi'a halate mako'ae inake huno apafine'ke “Lapa'kaeya nalafe kahau ne'ae?” huno hike'a anona'a ke'ale inake nehae “Yisasi'a Nasaleti kumateti ve'kae eta kahau ne'aone.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nehakeno Yisasi'a anona'a ke'apile inake nehe “Ma nakaeyafe'mune hu'na ako lahapapai'noe. Lapa'kaeya nakaeyafe kahau ne'atapaena ma vaya'kona apataleke'a ete'a veo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yisasi'a ako hokoteno hu'nea ke inake hu'ne “Nami'nana vayapati mako'ke'a o'atale'noe.” hu'ne. Ani hu'nea kemo'a fole aino lamake huno ne'ya'a alitesea yafe Yisasi'a “Apataleke'a veo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nehikeno Saimoni Pita'a sasu'me aliteno mai'neateti ani sasu'me ku'afati avayu humaleno ala mono nopi kava ve'kamo ali'ya ve'kamo aya lamaka aupalika akesa aepa'afati heno hataka hutalekeno mopafi asaka hulavi'ne. Ani ali'ya ve'kamo aki'a Mala'kasi'ae. ");
INSERT INTO ino_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ina kava nehikeno Yisasi'a Pitafe inake nehe “Sasu'me'ka halate ali'ka ku'afi aiyo. Na kava nehane? Ko nakufa'ae naku name'ae nakafu kisea ya'mo'a atu'ake nehea li'kana nehikeno afa'a ani li hane'nea ke'ayona Afo'nimo'a nami'nea'maki nakaeyafe ‘O'nese.’ hu'kae nehape?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nehike'a kame hu ati vaya'ae ala kava ve'ka'api'ae mono nopi ati vaya'ae Yisasina atafa hu'a ayate nofi kite'nae. ");
INSERT INTO ino_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nofi kitete'a hokote'a Anasite avale'a ne'vae. Anasi'a Kaiyafasi a'amo afo'amo'a mai'neanakeno Kaiyafasi'a ani kafufi ala mono nopi hokote kava ve'ka mai'nea kanalene. ");
INSERT INTO ino_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyafasi'a Yuta vaya'aife inake huno hapapai'ne “Mako ve'ka mi'ko vaya'aite falise.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimoni Pita'ae mako Yisasi ke ne'afea ve'ka'ae Yisasina a'kame ne'va'akeno ala mono nopi hokote kava ve'kamo'a ani Yisasi ke ne'afea ve'ka ako ake'nea ve'kakeno ala mono nopi hokote kava ve'kamo keki'ya vekofi Yisasi'ae lo'kano hai'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Haitekeno Pita'a ma'aileka kipate hetino mai'nikeno ani Yisasi ke ne'afea ve'kamo'a uno kipate yakai'nea a'mafa'ne ke hapaiteno Pitana avaleno atekeno mai'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mai'nikeno ani kipate yakai'nea a'mafa'nemo'a Pitafe inake he “Kakaeya'ae ma ve'kamo ke ne'afina ve'ka mai'nape?” huno afine'kekeno Pita'a inake hu'ne “Nakaeya ani ve'ka o'mai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nehikeno yasimo huteno lusi lanitani hike'a ali'ya vaya'ae mono nopi ati vaya'ae ata kate'a lusi yasi hike'a heti'a lota hu'a mai'nakeno Pita'a apa'kaeya'ae atale hetino akufa lota nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ala mono nopi hokote kava ve'kamo'a Yisasife inake huno afine'ke “Kakaeya ke ne'afea anaka'ae kakaeya hu'ka apaveli'nana ke'ae nahapaiyo.” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Afine'kekeno Yisasi'a ke'ale inake he “Nakaeya mi'ko ve a'ne'ai apaulakale mono ke hapapai'noana mi'ko afina Yuta vaya atalu hu'naya mono nopi'ae ala mono nopi'ae mi'ko ke hu'noa'maki fala'ki yapaka u'na mako kesi ke alaki hapa'opai'noe. ");
INSERT INTO ino_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na kava hike'ka nafine'kane? Nakaeya ke nehuke'a afi'naya vaya'aife hapapai'noa ke apafiko. Nakaeya hu'noa ke afi'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nehikeno mako anile hetino mai'nea ati ve'kamo'a Yisasi aukosafi ne'amakino inake he “Kakaeya ala mono nopi hokote kava ve'kamo kele nakalu hukape?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nehikeno Yisasi'a anona'a ke'ale inake he “Nakaeya mako hao'otake ke hu'nisuke'kaena kakaeya ani hao'otake ke hu'nisoa ke ete'ka hu'ka fole ainato. Inaki nakaeya lamake ke hu'nisoana na'ya hike'ka ne'namakine?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nehike'a nofi kitete'a Anasi'a ala mono nopi hokote kava ve'ka Kaiyafasiteka huteke'a avale'a ne'vae. ");
INSERT INTO ino_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ne'vakeno Saimoni Pita'a atale lota huno mai'nike'a inake hu'a nehae “Kakaeya'ae ani ve'kamo ke ne'afina ve'ka mai'nape?” hu'a nehakeno Pita'a make he “He'e ani ve'ka nakaeya o'mai'noe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nehikeno ala mono nopi hokote kava ve'kamo ali'ya ve'kamo'a Pita'a akesa heno hataka hu'nea ve'kamo vaya'amo'a inake nehe “Lamake kakaeya Yisasi'ae hoyafi mai'nanake'na kake'noane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nehikeno Pita'a mako'ae inake hu'ne “Nakaeya o'nake'nane.” nehikeno ko'kolemo'a makale'a ake ai'ne. ");
INSERT INTO ino_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Natepi Yisasina Kaiyafasi nopati avale'a ala Lomu kamani kava ve'kamo kake hupate note avale'a u'nae. Yuta vaya'ai mono ke'apimo'a inake hu'ne afa vaya'ae lo'katapa maisayana apa'kaeya kava hutapa hao'otake vaya mai'naya yafe ala emu ne'yana o'nekae huno hu'nea yafe Yuta vaya'moki ani ala emu ne'yana nesaya yafe ani nopi ohai'a ma'aileka mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kumateka mai'nakeno Pailati'a ala Lomu kamani kava ve'kamo'a apa'kaeya mai'nayate eno inake huno apafine'ke “Lapa'kaeya na'yane keleti mani ve'ka kake hutekefe nehae?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Hike'a anona'a ke'ale inake hu'a hapai'nae “Mani ve'ka hao'otake kava ohu ve'ka mai'nininana ma kava huta kakaeyate avalelita o'menine.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nehakeno Pailati'a eteno inake huno hapapai'ne “Lapa'kaitapi yanaki lapa'kaeya avaletapa mono ketapileti kake huteo.” nehe. Nehike'a Yuta vaya'moki inake hu'a hu'nae “Kakaeya kamanimoka ke male male'nana kemo'a ‘Mako ve'ka hatapa ofaleo.’ hu'ka lakaeyafe nehane.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A'ke'ainaka Yisasi'a “Falikoe.” nehuno inake hu'ne “Yofo yosale nahaesake'na falikoe.” hu'ne. Lomu kamani vaya'moki mako ve'ka hakefe yofo yosale asaikeno fali'ne. Yisasi'a hu'nea kemo'a fole aino ne'ya'a alitekeno lamake hisea yafe Yuta vaya'yakamoki ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ani ke hakeno Pailati'a ataleno kake hune'apatea nopaka haiteno Yisasife ke hikeno vikeno inake huno afine'ke “Kakaeya Yuta vaya'aipi ala yahauve ve'ka mai'nape?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Afine'kekeno Yisasi'a anona'a ke'ale inake he “Kakaeya kaipa kakesafati mani ke nehapi mako vaya'moki inani akufa ke nakaeyafe kahapaike'kae nehane?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Afine'kekeno Pailati'a anona'a ke'ale inake huno afine'ke “Nakaeya Yuta ve'ka mai'nofi? Kakai'ka nofi vaya'ae ala mono nopi kava vaya'ae kavale'a nakaeyate ne'ayana kakaeya na hao'otake kava hu'nane hu'na kafine'koe?” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Afine'kekeno Yisasi'a anona'a ke'ale inake he “Nakaeya kava yakaisoa kumana ma mopafi o'male'ne. Inaki ma mopafi kava yakaisoa kuma'ni hane'nininana ali'ya vaya'nimoki heti'a la hinina'maki nakaeya navale'a Yuta vaya'ai apayapina ma kava hu'a o'natanina'maki nakaeya kava yakaisoa kuma'ni ma mopafi o'male'nea yafe Yuta vaya'moki apayapi navale'a nate'nae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nehikeno Pailati'a akaeyafe inake nehe “Ala kava ve'ka mai'noe hu'ka nehape?” nehikeno Yisasi'a anona'a ke'ale inake he “Kakaeya nakaeyafe ‘Ala kava ne mai'nane.’ hu'ka hana ke lamake nehane. Nakaeya lamake ke hu'na fole aisoa yafe ita'nimo'a alinate'ne. Lamake ke hu'na fole aisoa yafe ma mopafi e'noana lamake ke afi'a apaipafi male'naya vaya'moki nakaeya nehoa ke ne'afe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nehikeno Pailati'a Yisasife inake nehe “Ani lamake ke na akufa ke hane'ne?” nehe. Pailati'a hatilavino kumateka uno Yuta vaya'aife inake huno hapapai'ne “Hao'otake kava hu'nea yana kahau aovana o'ake'noe. ");
INSERT INTO ino_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","O'ake'noa'maki lapa'kaeya mi'ko ala emu ki afina nafikake'na mako ve'ka nofi nopati afa'a avale'na lapami'noanaki lapa'kaeya meni nalafe nelahapaiye? Yuta vaya'mokitapa yahauve ve'ka afa'a atalesukeno lapa'kaeyateka visife?” huno apafine'ke. ");
INSERT INTO ino_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Apafikeke'a ala kefati inake hu'a hu'nae “Akaeya ne'atale'ka Palapasina avale'ka lamisane.” hu'a nehu'a “Palapasi'kene Palapasi'kene.” hu'a nehae. Ani Palapasi'a ala kumate vaya'aife inake he “Kamani vaya'ae la hiketao.” huno hu'nea ve'ka mai'nike'a akaeyafe ani ke nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailati'a Yisasina avaleno “Nofi kayoteti sefu ameo.” huno hapapaike'a sefu ami'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Sefu amite'a kame vaya'moki aufe nofiteti ali'a kalaki'a ka'kolita alo hute'a akenopale vaite'nae. Vaitete'a ala kava ve'kamo haesa yatala kena havaitete'a Yisasi'a mai'neate e'a Yisasife inake hae “Hae Yuta vaya'ai ala yahauve ve'ka mai'nape?” nehu'a aukosafi apayateti amaki'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ina kava hakeno Pailati'a kumateka hatilavino ali'a atalu hu'naya Yuta vaya'aife inake nehe “Hao'otake ya'a kahau a'na akoana mako'ke o'maleke'na lapa'kaeya ani ke afisae hu'na avale'na lapa'kaeyate hatilavi'na ne'oe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nehikeno Yisasi'a kumateka hatilavino e'ne. Aufe nofiteti ali'a kalaki'a alo humale ka'kolita akenopale hane'nikeno haesa kena havaite'naya kena'ae hatilavino e'ne. Ekeno Pailati'a apa'kaeyafe inake nehe “Mani ve'ka mai'niki akeo.” huno hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hapapaike'a mono nopi kava vaya'ae ati vaya'ae Yisasina akete'a ala kekefafati inake hu'a nehae “Yofo yosale nili aitetapa asaikeno falino. Yofo yosale nili aitetapa asaikeno falino.” hu'a nehakeno Pailati'a inake huno hapapai'ne “Lapa'kaeyatapi avaletapa yofo yosale nili aitetapa asaiyo. Nakaeya kahau aovana mako hao'otake ya'a o'male'nea yafenake'na ohakauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nehike'a Yuta vaya'moki inake hu'a hapai'nae “Yisasi'a akai'ae inake hu'ne ‘Nakaeya Anumaya Koti mafa'ne'a mai'noe.’ hu'ne. Hu'nikeno lakaeyapina mako ke male male'nea kemo'a inake hu'ne ‘Ani ke hisea ve'ka falise.’ hu'neanakeno meni Yisasi'a ani ke hu'nea yafe falise.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nehakeno Pailati'a ani ke afiteno lusiya huno amo'yo ne'aiye. ");
INSERT INTO ino_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Amo'yo ne'aikeno Pailati'a eteno kake hupate nopi haino faleno mai'neno Yisasife inake huno afine'ke “Kakaeya hanatekati e'nane.” huno afine'kea'maki Yisasi'a anona'a ke'ale ha'opai'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ha'opaikeno Pailati'a inake huno hapai'ne “Kakaeya na'ya hike'ka nakelena no'aline? Nakaeya lo'kiya'ni'ae ve'kake'na nofi nopati katalesoe hu'naena ‘Ataleo.’ hu'na hisoana katalekaya'maki ‘Yofo yosale nili aitetapa asaikeno falino.’ hu'na hisoana ani ya hukatekae. Kakaeya ani ke ne'afipi no'afine?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Afine'kekeno Yisasi'a anona'a ke'ale inake huno hapai'ne “Kakaeya Anumaya Koti'a lo'kiya'a o'kami'nininana nakaeya natafa ohanina'maki nakaeya navale'a kakaeya kayapi nate'naya vaya'ai hao'otake ya'apimo'a kakaeya hao'otake ya akaseno hao'otake ya'api ala huno hane'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nehikeno Pailati'a ani ke afiteno “Hana'ya hu'na atalesoe.” huno ani kafe kahau ne'ayanaki Yuta vaya'moki ala kekefafati inake hu'a hu'nae “Mako'ke ve'kamo'a Yisasi'a hea kava huno akai'aena ‘Nakaeya ala yahauve ve'ka mai'noe.’ huno hisea ve'ka Sisa'a kava ve'katimo kame'a mai'ne. Kakaeya ani ve'ka atalesanakeno viseana kakaeya Sisa'a kava ve'katimo vaya'a o'mai'nane.” ");
INSERT INTO ino_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nehakeno Pailati'a ani ke afiteno Yisasina avaleno hatilavino kumateka eno ala kake ne'afi ve'ka fai ne'maiya yate fai mai'ne. Ani no'mo haopaleka Yuta vaya'ai kefati aki'a Kapatae hu'a nehae. Ani no'mo haopaleka lakaiti kefati amalaku ai'a yafa male'naya haopalekae huta nehune. ");
INSERT INTO ino_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ani afina Anumaya Koti'a apa'kinakomoki apa'kufa alino kati'nea yafe Yuta vaya'moki apa'kesa afi emu ne'ya ki kanamo'a aupasi hike'a ali'a avatati nehakeno yakemo'a eno uno apamotule ekeno Pailati'a inake huno Yuta vaya'aife hapapai'ne “Ala kava ve'katapi akeo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nehike'a apa'kaeya ala kekefafati inake hu'a nehae “Aote'ya'ae aote'ya'ae yofo yosale nili aitetapa asaikeno falino.” hu'a hakeno Pailati'a inake huno hapapai'ne “Nakaeya lapa'kaeya ala yahauve ve'katapi yofo yosale asaisukeno falisife?” huno hike'a mono nopi kava vaya'moki inake hae “Mako ala yahauve ve'kati o'mai'nifa Sisa'a akaeya mako'ke'ake mai'ne.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nehakeno Pailati'a Yisasife “Yofo yosale nili aitetapa asaiyo.” huno avaleno ati vaya apami'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yisasina avale'a u'nae. Ne'vakeno Yisasi'a akai'a nili aite'a asaisaya yofo yosa kofino Akenopa Ayamufae hu'a aki ne'aya kumate u'ne. Ani kuma'mo aki'a Yuta vaya'ai kefati Kolokatae hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ani kumate avale'a u'a yofo yosale nili aite'a asai'nae. Aole ve'kala'ae anaote yofo yosale aluka aluka aki'naleka asaimale'ne'a Yisasina folaka'anifi nili aite'a asaimale'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Asaimale'nakeno Pailati'a mako avo kano Yisasina nili hemale'naya yofo yosale asaimale'ne. Ani avo'mo'a inake he “Yisasi'a Nasaleti ve'kae. Yuta vaya'ai ala yahauve ve'ka ma mai'ne.” huno kamale'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kamale'nike'a Yisasi'a yofo yosale asaimale'naya aupalika ala kuma'mo haute asaimale'nake'a mi'ko Yuta vaya'moki ani ke hapali'a ake'nae. Pailati'a aole'ae mako'ae alu kefati kamale'nea ke Yuta vaya'ai kefati'ae Lomu vaya'ai kefati'ae Kali'ki vaya'ai ke'ae kamale'nike'a hapali'a ake'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ake'nake'a Yuta vaya'ai mono nopi kava vaya'moki Pailatife inake hae “Kakaeya ‘Yuta vaya'ai ala yahauve ve'ka ma mai'ne.’ hu'ka o'ka'ka ma ke hu'ka kao ‘Nakaeya Yuta vaya'aipi ala yahauve ve'ka mai'noe huno nehea ve'ka ma mai'ne.’ hu'ka kao.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nehakeno Pailati'a inake he “Kamale'noa ke hai kamale'noanakeno hanese.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ati vaya'moki Yisasina yofo yosale nili aite'a asaimalete'a kena'a aole'ae aole'ae hetama vai'a ali'nae. Mako yatala kena'a'ae alikefe akayana ofa'kani kena mi'ko hanalekati afeteka afa'a lavino kase'nea kenae. ");
INSERT INTO ino_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ofa'kani kenake'a ani ati vaya'moki kake hute'a inake hae “Hatata ohuta afa'a alita kasi yo'kalokana akufa yo'kalo nelisunakeno lakasesea'mo'a alise.” hu'a apa'kai'api nehae. Ani kava haya kava humaletakeno Anumaya Koti ke a'ke'ainaka kamale'naya kemo'a ako fole aino ne'ya'a alitekeno lamake nehe. Ani a'ke'ainaka kamale'naya kemo'a inake hu'ne “Kena'ni fa'ko fa'ka hu'a ne'ali'a mako kena'ni yo'kalo le'a apa'kasesea'mo'a alike.” hu'a kamale'nayane. Kamale'nake'a ani kemo'a lamake hisea yafenake'a ati vaya'moki ani kava nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nehake'a Yisasi'a asaimale'naya yofo yosamo haute Yisasi ita'amo'ae ani a'mo ato'amo'ae heti'na'ae. Ana'kaeya'ae Kalopasi a'mo aki'a Malia'a hamo'amo'ae Makatala kumateti a'ae heti'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Heti'nakeno Yisasi'a ita'amona aketeno aipafati hau'nea ve'ka Yoni'na haute mai'no'akeno la'aketeno ita'amofe inake nehe “Ma ana ma ve'ka kakaeya mafa'ne'ka mai'ne.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Huteno nakaeyafe “Mamona ita'kamo'ae.” huno hike'na nakaeya ani afina Maliana yakaitesoa yafe no'nileka avale'na u'noe. ");
INSERT INTO ino_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ani ke huteno Yisasi'a inake nehe “Mi'ko ali'ya'ni ali'na ako hano hoe.” huno akesa afiteno a'ke'ainaka Anumaya Koti ke kamale'naya kemo'a alaki fole aino lamake hisea yafe inake he “Life ne'nahaiye.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nehike'a nofi alakafati fole ai'nea lina mako kepi havaite'nike'a mako lipi havakana ya ali'a ani lipi ate'a kayote vaite'a ali'a asaka hu'a Yisasi avayale male'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Malakeno Yisasi'a mayu mayu huno neteno inake he “Afo'nimo'a nahapai'nea yana ako avaya a'noe.” nehuno ake'yamo'a ape nehuno avamu'a ne'atale. ");
INSERT INTO ino_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sapati kanae ali'a avatati hisaya kanakeno eka ala Sapati afina va'yi hukefe hike'a Yuta vaya'moki ani yofo yosale hapamale'naya vaya'ai apa'kufa Sapati afina yofo yosale hanesea yafe ohapaike'a Pailatife inake hu'a afine'kae “Kakaeya apaiya'a ali'ka kofa hisanake'a makale falitesaketa hipo'ya huta alita ukune.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nehakeno Pailati'a ati vaya hapapaike'a u'a aole ve'kala'ae Yisasi'ae yofo yosale asaimale'naya ve'kala mai'na'ate e'a anaiyala ali'a kofa hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ali'a kofa hute'a Yisasiteka e'a ake'nayana ako fali'nike'a akete'a akaeya aiya ali'a kofa ohu'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ali'a kofa ohu'nakeno mako ati ve'kamo'a keve'aleti Yisasina haopafi haekeno makale'a ani keve kapati kola'ae li'ae elino e'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Elineke'na nakaeya Yoni'na ani kavana ake'noanake'nae lahapa'nepauve. Lahapa'nepauva ke lamake ke hane'neanaki afi'na alakepa hu'ne'na lahapa'nepauvanaki lapa'kaeya'ae Yisasife afitapa lapaipafi malesaya yafe lamake ke lahapa'nepauve. ");
INSERT INTO ino_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","A'ke'ainaka Anumaya Koti ke kamale'naya kemo'a inake hu'ne “Apa'kaeya mako ayamufa ali'a kofa ohukae.” hu'a kamale'nayane. Inaki mako Anumaya Koti ke kamale'naya kemo'a inake hu'ne “Haopafi keveleti ha'nea ve'ka akekae.” hu'a kamale'nayane. Kamale'naya kemo'a alaki fole aino ne'ya'a alitekeno lamake hisea yafe mani kava hu'nae. ");
INSERT INTO ino_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Haopafi keveleti hamale'nikeno Yosefe'a Alimatia kumate ve'kamo'a inake huno Pailatina afine'ke “Kanale nakaeya Yisasi akufa'a alisufe?” huno afikekeno Pailati'a “Kanalene.” huno hutekeno Yosefe'a uno Yisasi akufa'a alino e'ne. Ani ve'kamo'a Yisasi ke afino a'kame ne'malea ve'kakeno Yuta vaya'aife koli huteno Yisasife afino aipafi male'nea ke alino fala'kimale'neno mako ve'ka ha'opai'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ni'kotimasi'a hokoteno Yisasite hani'ainaka e'nea ve'kamo'a eno Yosefena aya hukefe fu'ki a'kamekana lina aole yosafati hefino e'ne. Ani aole yosala'mokani ana'ki'a mea'ae alo'ae hane'nike'a ali'a akunaku humale'nayapati mana'ake li fole aikeno alino e'ne. Ani yana sikelile malakeno 34 kilo hikeno alino e'ne. ");
INSERT INTO ino_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ani aole ve'kala'mokani u'ana Yisasi akufa'a ali'ana hipo'ya huli'ana u'ana mopale male'ne'ana yosa'ae kenaleti akufale hayavaite'ana mana'ake lina faletete'ana ali'ana kala'ki'na'ae. Mi'ko afina Yuta vaya'moki vaya falike'aena ani kava hu'a ne'apataya kava hute'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yisasina yofo yosale nili aite'a ha'naya aupalika mako kanale hoya hane'ne. Ani hoyafina mako vaya kipatesaya yafa'ka hane'ne. Ani yafa'kana saufa kafimale'ne'a mako vayana kio'apate'naya yafa'kapi ali'ana u'ana kite'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ani afina Sapati ali'a avatati hisaya afinanake'ana ani matimatina hau'ale hane'nike'ana ani aole ve'kala'mokani Yisasina akufa'a anile ali'u'ana kite'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sota'mo hokote afina ko o'ali'nikeno Malia'a Makatala kumate a'mo'a natepati Yisasi kite'naya kelile eno akeana keli avayale ai'a a'kanimale'naya yafana o'male'nikeno ake'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aketeno eteno ataleno naku naku uno nakaeya Yoni'na Yisasi'a nakaeyafe lusiya huno nehaiya ve'ka'ae Saimoni Pita'ae mai'no'ate eno la'akaeyafe inake huno laha'a'nepaiye “Anumayatimo akufa'a kelifati ako ali'nayanake'a hana'ale male'nafi?” huno laha'apai'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Laha'apaiketa'a afiteta'a Pita'ae nakaeya'ae Yisasi kite'naya kelileka u'no'ae. ");
INSERT INTO ino_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Makopi naku naku uta'a Yisasi kite'naya kelileka u'no'a'maki Pitana akase'na nakaeya Yoni'na makale u'na Yisasi kite'naya kelile hokote'na va'yi hu'noe. ");
INSERT INTO ino_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Va'yi hute'na nakaeya ape hu'ne'na akoana Yisasi akufale hayate'naya kena'ake hane'nike'na ake'noa'maki ani keli'afi fale'na u'na ohai'noe. ");
INSERT INTO ino_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Ohai'na ma'aileka mai'nokeno Saimoni Pita'a henaka na'kame ea ve'kamo'a Yisasina kite'naya kelifi eno makale faleno hai'ne. Haino mako hayate'naya kenayaka akeana Yisasi akenopale kite'naya kena'ae akufale hayate'naya kena'ae makopi lo'kano o'male'nifa aote yate ano kafake'kino hane'nikeno haino ake'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne'akeke'na nakaeya Yoni'na kelile hokote'na u'noa ve'kamo'na anifi fale'na hai'na ne'ake'na kelifati ako heti'nea ke lamake hu'ne hu'na afi'na naipafi male'noe. ");
INSERT INTO ino_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ani afina lakaeya mi'ko vaya'mokita Anumaya Koti ke kamale'naya ke “Yisasi'a fali'niseapati eteno hetike.” hu'a kamale'naya ke afita alakepa ohu'none. ");
INSERT INTO ino_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","La'akaeya Yisasi ke ne'afu'a ve'kalana ani kelifati hatilavita'a noti'aleka eteta'a u'no'ae. ");
INSERT INTO ino_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia'a ani yafa'ka'mo avayale mai'neno avi neleno ape huno kavafaino ne'ake. ");
INSERT INTO ino_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akeana aole ko'ku'napi kayo kayo ve'kalana yave yave'ake kena havaili'na'akeno ana'ke'ne. Ani ve'kalana Yisasi akufa male'naya yate faitopale mai'na'ae. Mako ve'kamo'a akenopa male'naya aupalika maikeno mako ve'ka aiya male'nayateka maikeno hu'ana mai'na'ae. ");
INSERT INTO ino_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mai'ne'ana Maliafe inake ha'ae “Mika ana na'ya hike'ka avi nelane?” hu'ana ha'akeno Malia'a inake nehe “Anumaya'ni ali'u'a male'naya kuma o'ake'ne'nae avi neloe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Inake huteno aino afeleno akeana Yisasi'a akai'a heti'nikeno aukosafi akeno alakepa ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Akeno alakepa ohu'nikeno Yisasi'a akaeyafe inake nehe “Ma ana na'ya hike'ka avi nelane? Nalafe kahau ne'ane?” nehe. Nehikeno Malia'a akesa afino inake nehe “Ma ve'ka hoyale ne'yakaiya ve'ka mai'ne.” huno akesa afiteno inake nehe “Amuse'ka nehuki kakaeya ali'ka u'ka male'nisu'kaena male'nisana kuma navelisanake'na u'na ali'na visoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nehikeno Yisasi'a akaeyafe inake he “Maliao.” huno hikeno ani a'mo'a aino afeleno Yuta vaya'ai kefati akaeyafe inake nehe “Laponae.” nehe. Ani ke lakaeya kefatina ali'ka laya nehana Nenao nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nehikeno Yisasi'a akaeyafe inake he “Natafa oho. Nakaeya Afo'nimo mai'neateka ohai'noki name'ko ohu'ka u'ka nakaeya'ni nakana'nimokife kahapaisoa ke hapapaiyo ‘Nakaeya'ae lapa'kaeya'ae Afotimoteka haikefe nehoe. Nakaeya'ae lapa'kaeya'ae Anumaya Kotitimoteka haikefe nehoe.’ hu'na kaha'nepauva ke hu'ka hapapaiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nehikeno Makatala kumateti Malia'a uno akaeya ke ne'afea anaka'aife inake huno hapapai'ne “Nakaeya Anumaya'ni'a ako ake'noe.” huteno Yisasi'a hapai'nea ke hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yisasi'a fali'neapati heti'nea Sota'mo hani'ainaka Yisasi'a ayatala'a hano huteno aiyalekati mako'ke alea anaka'amokita Yuta vaya'aife koli huteta kita kita alaki humaleta mako nopi alita atalu huta mai'none. Mai'nonakeno Yisasi'a folakatifi va'yi huno heti'neno lakaeyafe inake he “Lapaipamo'a falu hinaketapa maiyo.” huno lahapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Lahapaiteno akai'a aya'ae haopa'ae laveliketa ne'aketa ayatala'a hano huteno aiyalekati mako'ke alea anaka'amokita Anumayati aketeta laipamo'a lusi amuse nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Amuse nehunakeno Yisasi'a lakaeyafe mako'ae inake he “Lapaipamo'a falu hinaketapa maiyo. Afo'nimo'a hunate'nea ya hu'na lapa'kaeya'ae hunelapatoe.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ina ke huteno avamu'a ha huno nelamino lakaeyafe inake he “Fate Akufa Avamu lapamuki avaleo. ");
INSERT INTO ino_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lapa'kaeya mako hao'otake kava hu'nisea ve'kae ‘Kahaone katone nehuta laipa falu yapati alita atalekatone.’ hutapa hisayana Anumaya Koti'a ani kava huno haove atove nehuno aipa falu yapati alino ataletekaiya'maki hao'otake kava hu'naya vaya'aife ‘Naipamo'a falu oheanake'na hao'otake yatapi ali'na o'atalekauve.’ hutapa hisayana Anumaya Koti'a ani kava huno aipamo'a falu ohisikeno hao'otake ya'api alino o'atalekaiye.” huno lahapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yisasi'a lakaeyate va'yi hu'nea afina Yisasi'a ayatala'a hano huteno aiyalekati mako'ke alea anaka'amokitafatina mako'ke ve'ka Tomasi'a lakaeya'ae o'mai'ne. Ani ve'ka Tomasi'a mako aki'a aole mafa'ne alinate'neapati mai'nea ve'kae hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ani ve'ka lakaeya'ae o'mai'nea yafe lakaeya “Anumayati ako ake'none.” huta ha'nepaunakeno Tomasi'a lakaeyafe inake he “Nakaeya Yisasina nili ai'naya afuku ayapi o'akesu'naena ani ke lamake nehae hu'na afi'na naipafi o'malekauve. Nakaeya naya ha'ko'ya afukute o'malesu'naena ani ke afi'na naipafi o'malekauve. Haopafi hayo a'naya afukupi naya o'vaisu'naena ani ke afi'na naipafi o'malekauve.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Naya mako kaya hano huteno naya mako kayati aole'ae mako'ae alea afina maiteta Yisasina ayatala'a huno huteno aiyalekati mako'ke alea anaka'amokita eteta ani nopi mai'nonakeno Tomasi'a ani afina lakaeya'ae mai'ne. Kita kita alaki humale'nona'maki Yisasi'a folakatifi va'yi huno heti'neno lakaeyafe inake he “Lapaipamo'a falu hinaketapa maiyo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomasife inake he “Kaya avoya mafi vaite'ka nayapi nafuku'a ako. Kaya ali'ka nahaopale hane'nea nafukupi vai'ka ako. Akete'ka aole kakesa afina ya atale'ka nakaeyafe afi'ka kaipafi malo.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nehikeno Tomasi'a inake he “Kakaeya Anumaya'nimokae Anumaya Koti'nimoka mai'nane.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nehikeno Yisasi'a akaeyafe inake he “Kakaeya nakete'kake nakaeyafe kaipafi afi'ka male'nape? O'nake'ne'a nakaeyafe afi'a apaipafi malesaya vayana Anumaya Koti'a lusiya hu'a amuse hisaya ya apamisike'a lusiya hu'a amuse hukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yisasi'a ayatala'a hano huteno aiyalekati mako'ke alea anaka'amokitaena laulakale fate fate akufa avame hu lo'kiya yana no'akaya ya huno laveli'ne. Ani yana mi'ko mani avopi nakaeya Yoni'na o'ka'noe. ");
INSERT INTO ino_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","O'ka'noa'maki ma ke kamale'noa ke lapa'kaeyafe hu'na Yisasi'a laku lame alino kati ve'ka Kalaisi'a mai'neno akaeya Anumaya Koti mafa'ne mai'ne hutapa afitapa lapaipafi maletapa lapa'ku'a amisae hu'nae ani ke kamale'noe. Kamale'noanaki lapa'kaeya afitapa lapaipafi malesune hutapaena Yisasi akileti akola maike maike hisaya lapavamu alikae hu'nae kamale'noe. ");
INSERT INTO ino_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Henaka'a Yisasi'a ayatala'a hano huteno aiyalekati mako'ke alea anaka'amoki (11 anaka) Taipiliasi li'kotu aki'naleka mai'nakeno Yisasi'a apaulakale eno va'yi hu'ne. Lakaeyate va'yi hu'nea kavafe meni nakaeya Yoni'na lahapapaikoe. ");
INSERT INTO ino_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Lakaeya Saimoni Pita'ae Tomasi'a mako aki'a lako'ya mafa'ne'ae Nataniolo'a Kalili hane'nea kumana Kena nehaya kumate ve'ka'ae aole Sepeti mafa'nela'a nakaeya Yoni'na'ae nakana'nimo'ae Yisasina ayatala'a hano huteno aiyalekati mako'ke alea anakapati aole ve'kala'ae lo'kata mai'none. ");
INSERT INTO ino_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mai'nonakeno Saimoni Pita'a inake huno lahapai'ne “Nakaeya faya ya hukoe.” huno hiketa lakaeya inake hune “Lakaeya'ae visanateka lo'kata ukune.” huta hapaiteta lipi kalefi haita maiteta ani hani'ainaka u'nona'maki mako'ke faya alaki ohe'none. ");
INSERT INTO ino_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ohe'nonakeno yake haineno va'yi hukefe nehikeno Yisasi'a li aki'naleka hetino mai'nea'maki lakaeya akaeya ke ne'afuna anaka'amokita Yisasina aketa alakepa ohu'none. ");
INSERT INTO ino_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aketa alakepa ohu'nonakeno Yisasi'a inake huno lafine'ke “Vae mafa'ne'nimokitapa faya mako he'nafi ohe'nae?” huno lafikeketa “He'e ohe'none.” huta hapai'none. ");
INSERT INTO ino_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hapaitonakeno Yisasi'a inake huno lahapai'ne “Lapa'kaeya lu'konako kutapi alitapa lipi kaletapimo lamaka aupalika atalesayana faya hekae.” huno lahapaiketa lakaeya lu'konako kuti ani kava huteta lusi yate fayana he'none. He'nonakeno lu'konako'mo'a kana'ake hiketa alita asaka hisuna yafe lusi ya hu'none. ");
INSERT INTO ino_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nakaeya Yoni'na Yisasi'a nakaeyafe lusiya huno nehaiya ve'kamo'na Pitafe inake hu'na hapauve “Akaeya Anumayatimo'ae.” hu'na ha'nepauve. Saimoni Pita'a yasi kena'a asakitaleno ali'yana ne'aleateti afeana nakaeya Anumayatimo'ae hoa ke afiteno yasi kena'a eteno makale'a alino vaiteno lipi halesaka huno lavino Yisasite ne've. ");
INSERT INTO ino_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ne'viketa ani lipi kalefi alu'ale mai'neta lakaeya mako Yisasi ke ne'afuna anaka'mokita lu'konako ku'ae ani faya'ae heta avayu hulita li kahaepateka e'none. ");
INSERT INTO ino_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Li kahaepate lavita ata neleketa akonana faya'yaka'ae kai hame maya'ae ani atafina hane'niketa ake'none. ");
INSERT INTO ino_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ake'nonakeno Yisasi'a inake huno lahapai'ne “Meni alitapa aya fayapati mako alitapa nakaeyate eo.” huno lahapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Laha'nepaikeno Saimoni Pita'a lipi kalefi hai'neno nesu faya havaite'nea lu'konako kuna alino li kahaepateka eno male'ne. Ani lu'konako kupina 153 faya'yaka havaite'nea'maki ani lu'konako kuna a'kano ohu'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yisasi'a inake huno lahapai'ne “Lapa'kaeya etapa ne'ya neo.” huno lahapaiketa lakaeya lamo'yo aiteta “Kakaeya nalakae.” huta afio'ke'nona'maki “Anumayati mai'ne.” huta afi'nona yafe afio'ke'none. ");
INSERT INTO ino_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yisasi'a eno kai hame'ya maya'ae faya'ae a'kaya heno nelame. ");
INSERT INTO ino_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yisasi'a kite'naya kelifatina ako hetiketa aole afina ake'nonateti mani hea kava ne'akokeno aole'ae mako'ae afina akaeya ke ne'afuna anaka'amokita laulakale va'yi hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Lakaeya ne'ya netonakeno Yisasi'a Saimoni Pitana inake huno afike'ne “Saimonika Yoni mafa'nemoka kakaeya mako'ae kaipa ne'namipe faya lu'konako malesana yafe kaipa kakesamo'a lusiya huno ne'kahaiye?” huno afikekeno Pita'a inake nehe “He Anumaya'nimoka kakaeya ako afi'nane kakaeyafe ne'nahaiye.” hikeno Yisasi'a inake huno hapai'ne “Kakaeya nakaeya sipi sipi afu ana'au'yaka'ni ne'ya apameo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hapaiteno mako'ae eteno inake he “Saimonika Yoni mafa'nemoka nakaeyafe kaipa afi'ka ne'namipi no'namine?” hikeno Pita'a inake huno hapai'ne “Kakaeya ako afi'nane nakaeya kakaeyafe ne'nahaiye.” huno hikeno Yisasi'a inake huno hapai'ne “Kakaeya sipi sipi anaka'nilena kava yakaiyo.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hapaiteno mako'ae eteno aole'ae mako'ae afina ani ke huno afine'ke “Saimonika Yoni mafa'nemoka nakaeyafe ne'kahaifi no'kahaiye?” huno afine'kekeno Saimoni'a aole'ae mako'ae afina ani akufa keke “Kakaeya kaipa afi'ka ako ne'namipe?” huno afine'kea yafe Pita aipamo'a kana nehikeno inake hu'ne “Anumaya'nimoka mi'ko yana ako afi'nanafe nakaeya kakaeyafe ne'nahaiya yafe ako afi'nane.” huno hapai'ne. Hapaikeno Yisasi'a inake nehe “Kakaeya sipi sipi anaka'ni ne'ya apameo. ");
INSERT INTO ino_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Lamake hu'na kahapauve kakaeya nahaeya ve'ka mai'ne'kaena kena'ka kakai'ka havaite'ka visoe hu'ka hu'nana kumate ne'vana'maki henaka'a kosufa lesanana kaya ali'ka asaka hu'nisanake'a mako vaya'moki kena'ka havaikatete'a o'ukoe hu'ka hisana kumate afa'a kavale'a ukae.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ani hu'nea kemo aepa'a inake hu'ne henaka'a havi vaya'moki katafa hu'a kahakaya'maki ani afina Anumaya Koti aki ali'ka asaka hukane huno aepa'a nehe. Yisasi'a ani ke huteno Pitafe “Na'kame eno.” nehe. ");
INSERT INTO ino_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita'a maino afeleno Yoni'ni'na nake'ne. Nakaeya Yoni'na Yisasina hau ayamopafati hau'nea ve'kake'na nakaeya ne'ya nona afina Yisasina haopale mai'ne'na inake hu'na afike'noe “Anumayamoka hana ve'kamo'a kakaeya kakesi huno kame vaya'kamoki apayapi kavaleno katekaiye?” hu'na afike'noa ve'kamo'na Yisasi'ae Pita'ae ana'kame ne'okeno Pita'a maino afeleno nake'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Naketeno Pita'a Yisasife inake huno afine'ke “Anumaya'nimoka ma ve'kamo'a henaka'a hana akufa kava huke?” huno afine'ke. ");
INSERT INTO ino_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Afine'kekeno Yisasi'a inake huno ha'nepaiye “Nakaeya akaeyafe nahaisike'naena ma mopale afa'a mai'ninake'na ete'na esoe hu'na hisoana kakaeya ya hane'nife? Kakaeya afa'a na'kame eno.” huno hapai'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hapai'nea ke vaya'amoki hu'a imafi mafi hake'a inake nehae “Yoni'a ofalike.” hu'a nehaya'maki Yisasi'a ani ve'kae “Ofalike.” huno ohu'nifa make hu'ne “Nakaeya akaeyafe nahaisike'naena ma mopale afa'a mai'ninake'na ete'na esoe hu'na hisoana kakaeya ya hane'nife?” hu'ne. ");
INSERT INTO ino_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ani ke hayana Yoni'nae nehae. Nakaeya mi'ko Yisasi'a hu'nea kavafe lahapapaite'na avopi kamale'noe. Nakaeya hu'noa ke “Lamake hu'ne.” huta afi'none. ");
INSERT INTO ino_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yisasi'a mi'ko fate fate ya'ko'ae nesu yate alo hu'nea'maki vaya'moki mi'ko alo hu'nea ya'a ake'a kahalita hu'a avopi ka'nayateninana nakesa afoana ani avo'yaka ma mopalena mi'ko koteka lusiya huno havaitesikeno mopale hanesea ka'a o'malenine. ");
INSERT INTO ino_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofilasika hokote'na kamale'noa autamafi Yisasi'a aepa heno hu'nea ali'ya'ae alino apaya nehea ke'ae Anumaya Koti Fate Akufa Avamu'amo lo'kiya'aleti “Ina kava heo.” huno akaeya ke ne'afikeno hupate'nea anaka (Aposolo anaka) hapapaiteno ko'ku'napi hai'nea kava'ae ako ka'na kahapai'noe. ");
INSERT INTO ino_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yisasi'a lusi akafu ki ya alino faliteno hetino akaeya ke ne'afikeno hupate'nea anaka'moki apaulakale va'yi huno fali'neapati hetino avamu aliteno mai'nea ya afisaya yafe lusi lo'kiya kava hu'ne. Aole ve'kala'mokani anaiya anaya alea afina (40 afina) apaulakale eno va'yi huteno uteno halate eteno va'yi huno Anumaya Koti kava alino yakaisea yafe hapapai'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Mako afina apa'kaeya'ae mai'neno ne'ya ne'neno make huno hapapai'ne “Lapa'kaeya Yelusalemu kuma o'ataletapa mai'nikeno Afo'nimo'a mako ve'ka ‘Lapamikoe.’ huno hu'neanakeno ani ve'ka lapamitesiketapa avaletapa veo. Nakaeya ani ve'kae ako lahapapai'noe. Yoni'a litafateti falelapate'nea'maki lapa'kaeya aupa kanatofi Afo'nimo'a Fate Akufa Avamu'aleti falelapatekaiye.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mako afina Yisasi ke ne'afea anaka ali'a atalu hu'a mai'ne'a Yisasife inake hu'a afine'kae “Anumayatimoka meni kanafi Lomu kamanifati hapafale'ka kakaeya'ka Isaleli vaya'mokitale kava ali'ka yakailatesane hutae nehune?” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Afine'kakeno Yisasi'a apa'kaeyafe inake nehe “Afo'nimo'a akai'a lo'kiya'aleti mi'ko kana'ae mi'ko afina'ae ‘Ma ali'ya alikoe.’ huno yakai'nea'maki ani yana lapa'kaeya afisaya ya o'male'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","O'afi'naya'maki Anumaya Koti Fate Akufa Avamu'amo'a lapa'kaeyate eseana lo'kiya'a lapamitesiketapa nakaeyafe Yelusalemu'ae mi'ko Yutia koteka'ae Samelia koteka'ae mi'ko ma mopamo atupale mai'naya vaya'ae nakaeyafe hapapaikae.” hu'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ani ke huno hano huteke'a ake'a mai'nakeno mopaleti nehaikeno mako hiya'mo'a aino susuleteno avaleno haike'a o'ake'nae. ");
INSERT INTO ino_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nehaike'a apa'kaeya ko'ku'nate ake'a aiya'ka ne'vaike'a ani afina aole efe ku'kena huli ve'kala va'yi hu'ana apa'kaeya apamete e'ana heti'na'ae. ");
INSERT INTO ino_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Heti'ne'ana inake hu'ana neha'ae “Kalili kumate vaya'mokitapa na'ya hiketapa heti'netapa ko'ku'napaka aketapa aiya'ka ne'vaiye? Yisasi'a lapataleno ko'ku'napi haiya'maki ani ve'ka ani haiketapa akaya avamete eteno elinekaiye.” hu'ana hu'na'ae. ");
INSERT INTO ino_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hu'na'ake'a apa'kaeya Olivi yosa hane'nea avimana atale'a vani kilomita ne'u'a Yelusalemu va'yi hu'nae. ");
INSERT INTO ino_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Va'yi hute'a ne'maiya nona ki'a avayu hu'a akofetule kimale nopi hai'a mai'nae. Hai'a mai'naya vaya'moki apa'ki'a Pita'aki Yoni'aki Yemisi'aki Etalu'aki Filipi'aki Tomasi'aki Patalomiu'aki Matiu'aki Alafiasi mafa'ne Yemisi'aki Saimoni'ae ve'ka mako aki'a Seloti'aki Yutasi'a Yemisi mafa'ne'ae ani nopi hai'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ani vaya'ae a'neyaka'ae Malia'a Yisasi ita'amo'ae Yisasi akana'amoki'ae mako'ke apaipa apa'kesa afite'a mi'ko afina Anumayamoteka ke hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mako afina naya mako kaya hano huno naya mako kayati mako'ke alea vaya'ai apaiya apaya hano hea vaya (120 vaya) mai'nakeno Pita'a apa'kaeya folaka'apifati heti'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Hetiteno inake hu'ne “Vaya'nimokitapa Anumaya Koti Fate Akufa Avamu'amo'a a'ke'ainaka Teviti avayafati Yutasi'a Yisasina atafa hu'a haesaya ka apaveli'nea ve'kaena aune laka hu'ne. Ani kemo'a meni fole aino ne'ya'a alitekeno lamake nehe. ");
INSERT INTO ino_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ani ve'ka Yutasi'a lakaeya'ae Yisasi ke ne'afuna anakapi mai'neno Yisasi ali'ya ve'ka mai'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yutasi'a hao'otake kava hu'nea ya'mo anona'a moni alino mako mopa miya heteno anifi asaka hulavikeno akufamo'a aino atalaka hikeno aipa aino helafi lavi'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Helafi lavi'nike'a mi'ko Yelusalemu mai'naya vaya'moki ani ke afite'a ani mopamo aki'a apa'kai'api kefati A'kelatama hu'a aki a'nae. Inaki lakaeyati lakefati ani aki'aena ‘Kola lavi'nea kumane.’ huta akaune.” ");
INSERT INTO ino_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita'a inake hu'ne “Teviti'a yakame hu'nea avona Samupi inake huno kamale'neane ‘Akai'a ne'maiya nona vaya'moki o'maisakeno yu nona hamalese.’ huno kamale'neane. Mako aupalika inake hu'ne ‘Alu ve'kamo'a akaeya ali'yate alise.’ huno kamale'neane. ");
INSERT INTO ino_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Inake huno kamale'nea yafe mako ve'kamo'a Anumayati Yisasi'ae lakaeya'ae uneno nehea ve'ka Yoni'a li fale ne'apatea afina aepa heno lakaeya'ae uneno huno Yisasi'a ko'ku'napi hai'nea afina lakaeya'ae ne'maiya vayapati mako ve'ka Yisasi'a fali'neapati heti'nea ke hapapaisea yafena lakaeya'ae hetise.” huno Pita'a hu'ne. ");
INSERT INTO ino_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hike'a apa'kaeya aole ve'kalafe “Ana'kaeyae.” hu'a ana'ki a'nae. Mako ve'ka Yosefe Yasatasi'ae ve'kamo mako aki'a Pasapasi'ae. Mako ve'ka Mataiyasi'ae hu'a ana'ki a'nae. ");
INSERT INTO ino_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ate'a Anumayamoteka inake hu'a afine'kae “Anumayamoka kakaeya mi'ko vaya'moki apaipafi ako ake'nane. Yutasi'a haiya kava huno ataleno havi kapi u'nea yafe anona'a alu ve'kamo'a hetino kakaeya ke afisike'ka hutesana ve'ka maise hutae nehune. Kakaeya hana ve'ka mani ve'kalapati ako hapali'ka hute'nane? Hute'nana ve'ka laveleo.” hu'a afine'kae. ");
INSERT INTO ino_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anumayamoteka ke hu'a afike'a ana'ki'a aote aote haitale kate'a mako lapepi vaimale'ne'a mako'ke'a avayu hu'a akayana Mataiyasi aki ali'a avayu hu'nae. Avayu hakeno ani ve'kamo'a aiyalekati mako'ke alea vaya'ae hetino Yisasi ke ne'afikeno hupate'nea anaka'ae mai'ne. ");
INSERT INTO ino_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yisasi'a faliteke'a mako ayatekati aole alea sota (7 sota) maite'a ne'ya afule kanae amuse nehaya emu ki afina mi'ko vayana mako'ke nopi ali'a atalu hu'a mai'nae. ");
INSERT INTO ino_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mai'nakeno makale'a ko'ku'napakati ala ake ne'aino ala yasimo'a vo vo huno ake ne'aino ea'ya'mo'a faitopale mai'naya nopi haino havaite'ne. ");
INSERT INTO ino_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Havaite'nike'a akayana mako ata kanefe'kana ya eno ano fa'ko fa'ka huno mi'ko apaote apaote apa'kufale mailino u'ne. ");
INSERT INTO ino_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mailino u'nikeno Anumaya Koti Fate Akufa Avamu'amo'a eno mi'ko anaka'moki apaipafi eno havaiteke'a apa'kaeya aepa he'a Fate Akufa Avamu'amo apamea ke apaipa apa'kesafati no'afea ke fate fate kefati hu'nae. ");
INSERT INTO ino_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nehake'a ani afinana lusi vaya'moki Anumaya Koti ke ne'afea Yuta vaya'yaka mi'ko kotekati e'a Yelusalemu ali'a atalu hu'nae. ");
INSERT INTO ino_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ani vaya'moki ko'ku'napakati ala ake ne'aike'a afite'a e'a ali'a atalu hu'a afeana ani nopi mai'naya vaya'moki fate fate kefati hake'a alu kote koteti e'naya vaya'moki apaote apaote inake hae “Vae nakaeya kefati nehae.” nehake'a “Vae nakaeya kefati nehae.” hu'a lusi apamo'yo ai'nae. ");
INSERT INTO ino_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Apamo'yo ne'ai'a lusi apa'kesa ne'afi'a inake hae “Ani ke nehaya vaya Kalili vaya'ake mai'naya'maki hana'ya hu'a lakaiti kefati itati afotimoki nehaketa ne'afuna kefatina ke haketa ne'afune? ");
INSERT INTO ino_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Lakaeya ma kumatekati e'none. Patiati'ae Mitiati'ae Elamiti'ae Mesopotemiati'ae Yutiati'ae Kapatosiati'ae Potasiti'ae Esiati'ae Filisiati'ae Pamafiliati'ae Isipiti'ae Sailini haute Lipia kotekati'ae Lomuti'ae Kalititi'ae Alepiati'ae eta Yuta vaya'ae Yuta vaya'ai Anumaya Koti'apimo ke afi'naya vaya'ae eta mai'neta ne'afunake'a Anumaya Koti'a lusi lo'kiya'aleti hu'nea kavafe lakaiti kefati hu'a fole ai'a laha'nepaiye.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","13","Mi'ko vaya'moki lusi apamo'yo ne'aike'a apa'kesa lapa aite'a mako vaya'moki inake hu'a nehae “Ani akufa kava'mo aepa'a na'yane?” hu'a haya'maki mako vaya'moki kiki'api nehu'a inake hae “Apa'kaeya atu li nete'a anekinaki ke nehae.” hu'a nehae. ");
INSERT INTO ino_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nehaya'maki Pita'a ayatala'a hano huteno aiyalekati mako'ke alea anakapati Yisasi ke ne'afikeno hupate'nea anakapati heti'neno ala kefati inake hu'ne “Yuta vaya'nimokitapa'ae Yelusalemu ne'maiya vaya'ae mako ke lahapapaikefe nehuki afeo. ");
INSERT INTO ino_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lapa'kaeya lapa'kesa ne'afeana ‘Mani vaya'moki atu li nete'a anekinaki ke nehatakae.’ hutapa nehafe? He'e meni nate mai'nonakeno naini kilo'ki nehea'maki mako atu li o'ne'nae. ");
INSERT INTO ino_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","O'ne'naya'maki meni nehaketapa afea kavafe a'ke'ainaka Anumaya Koti aune ve'ka Yoeli'a hike'a kamale'naya kemo'a inake huno hu'neane Anumaya Koti'a make hu'ne ‘Mi'ko ya avaya akefe hisea kanafi nakaeya Fate Akufa Avamu'ni mi'ko vaya'aina helafi'na apamikoe. Apamisuke'a lapa'kaeya ve mafa'ne'ae a'mafa'ne'ae Anumayamo'a avayafati hapapaisea ke apaune vaya'kana hu'a hisake'a nahaeya'vetapimoki himonakana ya feluka ne'akesake'a kosufatapimoki himona akekae. ");
INSERT INTO ino_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He inani kanafi nakaeya Fate Akufa Avamu'ni helafi'na ali'ya vaya'ni ve'ae a'ae apamitesuke'a Anumayamo avayafati hapapaisea ke apaune vaya'kana hu'a lahapapaikae. ");
INSERT INTO ino_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nakaeya ko'ku'nate fate