﻿USE sofia;
DROP TABLE IF EXISTS sofia.indayt_vpl;
CREATE TABLE indayt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES indayt_vpl WRITE;
INSERT INTO indayt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pada mulanya, Allah menciptakan langit dan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Bumi tidak berbentuk dan kosong, kegelapan menutupi permukaan samudra, dan Roh Allah melayang-layang di atas permukaan air. ");
INSERT INTO indayt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kemudian, Allah berfirman, “Jadilah terang.” Lalu, terang itu jadi. ");
INSERT INTO indayt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah melihat bahwa terang itu baik. Kemudian, Allah memisahkan terang itu dari gelap. ");
INSERT INTO indayt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allah menyebut terang itu siang dan gelap itu malam. Jadilah petang dan jadilah pagi, itulah hari pertama. ");
INSERT INTO indayt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kemudian, Allah berfirman, “Jadilah cakrawala di tengah-tengah air untuk memisahkan air dari air!” ");
INSERT INTO indayt_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Lalu, Allah membuat cakrawala dan memisahkan air yang ada di atas cakrawala itu dari air yang ada di bawah cakrawala itu. Lalu, jadilah demikian. ");
INSERT INTO indayt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allah menyebut cakrawala itu langit. Jadilah petang dan jadilah pagi, itulah hari kedua. ");
INSERT INTO indayt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kemudian, Allah berfirman, “Biarlah air yang ada di bawah langit berkumpul ke satu tempat dan biarlah tanah yang kering itu tampak.” Lalu, jadilah demikian. ");
INSERT INTO indayt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allah menyebut tanah yang kering itu darat dan kumpulan air itu disebut-Nya laut. Allah melihat bahwa itu baik. ");
INSERT INTO indayt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Allah berfirman, “Biarlah bumi menumbuhkan rerumputan, tumbuh-tumbuhan berbiji, dan pohon buah yang berbuah menurut jenisnya dan berbiji di dalamnya, di atas bumi.” Lalu, jadilah demikian. ");
INSERT INTO indayt_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Bumi menumbuhkan rerumputan, tumbuh-tumbuhan berbiji menurut jenisnya, dan pohon yang berbuah dengan biji di dalamnya menurut jenisnya. Allah melihat bahwa itu baik. ");
INSERT INTO indayt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Jadilah petang dan jadilah pagi, itulah hari ketiga. ");
INSERT INTO indayt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kemudian, Allah berfirman, “Biarlah ada penerang di cakrawala langit untuk memisahkan siang dari malam, dan biarlah itu ada untuk tanda-tanda dan untuk musim-musim, dan untuk hari-hari serta tahun-tahun, ");
INSERT INTO indayt_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","dan biarlah itu menjadi penerang di cakrawala langit, untuk memberikan terang atas bumi.” Demikianlah itu terjadi. ");
INSERT INTO indayt_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allah membuat dua penerang yang besar. Penerang yang lebih besar untuk menguasai siang, sedangkan penerang yang lebih kecil untuk menguasai malam. Dia juga membuat bintang-bintang. ");
INSERT INTO indayt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allah mengatur mereka di cakrawala langit untuk menerangi bumi, ");
INSERT INTO indayt_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","untuk menguasai siang dan menguasai malam, dan untuk memisahkan terang dari gelap. Allah melihat bahwa itu baik. ");
INSERT INTO indayt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Jadilah petang dan jadilah pagi, itulah hari keempat. ");
INSERT INTO indayt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kemudian, Allah berfirman, “Biarlah air dikerumuni oleh makhluk-makhluk hidup, dan biarlah burung-burung beterbangan di atas bumi, melintasi cakrawala langit.” ");
INSERT INTO indayt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Lalu, Allah menciptakan binatang-binatang laut yang besar dan segala jenis makhluk hidup yang bergerak serta berkerumun di dalam air menurut jenisnya, dan segala burung bersayap menurut jenisnya. Allah melihat bahwa itu baik. ");
INSERT INTO indayt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Allah memberkatinya, firman-Nya, “Berkembangbiaklah, dan berlipatgandalah, dan penuhilah air di lautan, dan biarlah burung-burung berlipat ganda di bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Jadilah petang dan jadilah pagi. Inilah hari kelima. ");
INSERT INTO indayt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kemudian, Allah berfirman, “Biarlah bumi menghasilkan makhluk hidup menurut jenisnya, hewan ternak, binatang melata, dan binatang-binatang liar, masing-masing menurut jenisnya.” Lalu, jadilah demikian. ");
INSERT INTO indayt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allah membuat binatang liar di darat itu menurut jenisnya, hewan ternak menurut jenisnya, dan segala binatang melata di atas tanah menurut jenisnya. Allah melihat bahwa itu baik. ");
INSERT INTO indayt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kemudian, Allah berfirman, “Sekarang, mari Kita membuat manusia dalam rupa Kita, menurut keserupaan Kita. Biarlah mereka berkuasa atas ikan-ikan di laut, atas burung-burung di udara, atas ternak, atas seluruh bumi, dan atas segala yang melata yang merayap di bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lalu, Allah menciptakan manusia menurut rupa-Nya. Menurut rupa Allah, Dia menciptakannya. Laki-laki dan perempuan, demikianlah Dia menciptakan mereka. ");
INSERT INTO indayt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allah memberkati mereka dan Allah berfirman kepada mereka, “Beranakcuculah dan berlipatgandalah, dan penuhilah bumi, dan kuasailah itu. Berkuasalah atas ikan-ikan di laut, atas burung-burung di udara, dan atas segala yang hidup yang bergerak di bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kemudian, Allah berfirman, “Lihat, Aku telah memberikan kepadamu segala tumbuhan yang menghasilkan biji yang ada di seluruh muka bumi, dan segala pohon yang buahnya berbiji, itulah yang akan menjadi makananmu. ");
INSERT INTO indayt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Untuk segala binatang di bumi, dan untuk segala burung di langit, dan untuk segala yang merayap di bumi, yaitu segala sesuatu yang ada napas hidup di dalamnya, Aku telah memberi segala tumbuhan hijau sebagai makanan.” Lalu, jadilah demikian. ");
INSERT INTO indayt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allah mengamati segala sesuatu yang telah dibuat-Nya, dan lihatlah, itu sangat baik! Jadilah petang dan jadilah pagi. Inilah hari keenam. ");
INSERT INTO indayt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Demikianlah langit dan bumi beserta segala isinya diselesaikan. ");
INSERT INTO indayt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pada hari ketujuh, Allah menyelesaikan pekerjaan-Nya, yang telah dilakukan-Nya itu, dan Dia beristirahat pada hari ketujuh dari segala pekerjaan-Nya, yang telah dilakukan-Nya. ");
INSERT INTO indayt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Lalu, Allah memberkati hari ketujuh itu dan menguduskannya, sebab pada saat itu, Dia beristirahat dari segala pekerjaan-Nya, yang telah Dia lakukan dalam penciptaan. ");
INSERT INTO indayt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Inilah riwayat langit dan bumi ketika mereka diciptakan, pada waktu TUHAN Allah menjadikan bumi dan langit, ");
INSERT INTO indayt_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ketika di bumi belum ada segala semak belukar di ladang dan belum ada tanaman ladang yang tumbuh karena TUHAN Allah belum menurunkan hujan ke bumi, dan belum ada orang yang mengolah tanah itu. ");
INSERT INTO indayt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Namun, ada kabut yang keluar dari bumi dan membasahi seluruh permukaan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kemudian, TUHAN Allah membentuk manusia dari debu tanah dan mengembuskan napas kehidupan ke dalam lubang hidungnya sehingga manusia itu menjadi makhluk yang hidup. ");
INSERT INTO indayt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Lalu, TUHAN Allah membuat sebuah taman di sebelah timur, di Eden, dan di sana Dia menempatkan manusia yang telah dibentuk-Nya itu. ");
INSERT INTO indayt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Dari dalam tanah, TUHAN Allah menumbuhkan segala jenis pohon yang enak dilihat dan baik untuk makanan. Pohon kehidupan juga ada di tengah-tengah taman itu beserta pohon pengetahuan yang baik dan yang jahat. ");
INSERT INTO indayt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ada suatu sungai yang mengalir dari Eden dan mengairi taman itu. Dari situ, sungai tersebut terbagi menjadi empat cabang. ");
INSERT INTO indayt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nama sungai yang pertama adalah Pison yang mengelilingi seluruh tanah Hawila, tempat yang ada emasnya. ");
INSERT INTO indayt_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Emas dari tanah itu bagus, dan di sana ada damar bedolah dan batu krisopras. ");
INSERT INTO indayt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nama sungai yang kedua adalah Gihon yang mengalir mengelilingi seluruh tanah Kush. ");
INSERT INTO indayt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nama sungai yang ketiga adalah Tigris yang mengalir di sebelah timur Asyur. Sungai yang keempat adalah Efrat. ");
INSERT INTO indayt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","TUHAN Allah mengambil manusia itu dan menempatkannya di taman Eden untuk mengolahnya dan memeliharanya. ");
INSERT INTO indayt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kemudian, TUHAN Allah memberikan perintah kepada manusia itu, firman-Nya, “Kamu boleh makan dari segala pohon apa yang ada di taman ini, ");
INSERT INTO indayt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","tetapi kamu jangan makan dari pohon pengetahuan tentang yang baik dan yang jahat, sebab pada hari kamu memakannya, kamu pasti akan mati.” ");
INSERT INTO indayt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kemudian, TUHAN Allah berfirman, “Tidak baik kalau manusia itu sendiri saja. Aku akan membuat baginya, penolong yang sepadan dengannya.” ");
INSERT INTO indayt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Lalu, dari tanah, TUHAN Allah membentuk segala binatang di padang dan segala burung di udara, dan membawanya kepada manusia untuk melihat bagaimana dia akan menyebut mereka. Apa pun sebutan manusia itu bagi setiap makhluk hidup itu, itulah namanya. ");
INSERT INTO indayt_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Jadi, manusia itu memberikan nama untuk semua hewan, untuk burung-burung di udara, dan semua binatang liar di padang. Akan tetapi, bagi manusia itu, tidak ditemukan seorang penolong yang sepadan dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lalu, TUHAN Allah mendatangkan tidur yang lelap atas manusia itu. Ketika dia tidur, TUHAN mengambil salah satu tulang rusuknya, lalu menutupnya dengan daging. ");
INSERT INTO indayt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tulang rusuk, yang telah TUHAN Allah ambil dari manusia itu, dibuat-Nya menjadi seorang perempuan dan dibawa-Nya kepada manusia itu. ");
INSERT INTO indayt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kemudian, manusia itu berkata, “Inilah tulang dari tulang-tulangku, dan daging dari dagingku; dia akan disebut perempuan karena dia diambil dari laki-laki.” ");
INSERT INTO indayt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Karena itu, laki-laki akan meninggalkan ayahnya dan ibunya, lalu bersatu dengan istrinya sehingga mereka akan menjadi satu daging. ");
INSERT INTO indayt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Manusia dan istrinya itu, keduanya telanjang, tetapi mereka tidak merasa malu. ");
INSERT INTO indayt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ular adalah yang paling licik dari segala binatang di padang yang telah dijadikan oleh TUHAN Allah. Dia berkata kepada perempuan itu, “Apakah Allah benar-benar berfirman, ‘Kamu tidak boleh makan dari pohon mana pun di taman ini?’” ");
INSERT INTO indayt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Perempuan itu berkata kepada ular, “Kami boleh makan buah dari pohon-pohon di dalam taman, ");
INSERT INTO indayt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tetapi dari buah pohon yang ada di tengah taman, Allah telah berfirman, ‘Kamu tidak boleh memakannya, kamu juga tidak boleh menyentuhnya, nanti kamu akan mati.’” ");
INSERT INTO indayt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Namun, ular itu berkata kepada perempuan itu, “Kamu sama sekali tidak akan mati, ");
INSERT INTO indayt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","sebab Allah tahu bahwa pada hari kamu memakannya, matamu akan terbuka dan kamu akan menjadi seperti Allah, tahu yang baik dan yang jahat!” ");
INSERT INTO indayt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ketika perempuan itu melihat bahwa pohon itu baik sebagai makanan dan itu menarik bagi mata, dan pohon itu diinginkan untuk membuat seseorang bijaksana, dia pun memetik buahnya dan memakannya. Lalu, dia juga memberikannya kepada suaminya yang bersamanya, dan suaminya pun memakannya. ");
INSERT INTO indayt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lalu, mata mereka berdua terbuka sehingga mereka tahu bahwa mereka telanjang. Kemudian, mereka menyemat daun-daun ara dan membuat cawat. ");
INSERT INTO indayt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ketika mereka mendengar suara TUHAN Allah yang berjalan di taman pada suatu hari yang sejuk, manusia dan istrinya itu menyembunyikan diri mereka dari hadapan TUHAN Allah di antara pohon-pohon di dalam taman. ");
INSERT INTO indayt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Namun, TUHAN Allah memanggil manusia itu dan berkata kepadanya, “Di manakah kamu?” ");
INSERT INTO indayt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Dia menjawab, “Aku mendengar suara-Mu di taman dan aku takut karena aku telanjang, jadi aku bersembunyi.” ");
INSERT INTO indayt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kemudian, TUHAN berkata, “Siapa yang memberitahukanmu kalau kamu telanjang? Apakah kamu makan dari pohon yang kepadamu telah Kuperintahkan jangan kamu memakannya?” ");
INSERT INTO indayt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Manusia itu berkata, “Perempuan yang Engkau berikan untuk bersamaku itu, dialah yang telah memberikannya kepadaku dari pohon itu, maka aku pun memakannya.” ");
INSERT INTO indayt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lalu, TUHAN Allah berkata kepada perempuan itu, “Apa yang telah kaulakukan?” Perempuan itu menjawab, “Ular itu menipuku, maka aku makan.” ");
INSERT INTO indayt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kemudian, TUHAN Allah berkata kepada ular itu, “Karena kamu telah melakukan hal ini, terkutuklah kamu di antara segala hewan ternak, dan di antara segala binatang liar di padang. Dengan perutmu, kamu akan berjalan, dan kamu akan makan debu tanah seumur hidupmu. ");
INSERT INTO indayt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aku akan mengadakan permusuhan antara kamu dengan perempuan ini, dan di antara keturunanmu dan keturunannya. Keturunannya akan meremukkan kepalamu, dan kamu akan meremukkan tumitnya.” ");
INSERT INTO indayt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kepada perempuan itu, Allah berfirman, “Aku akan sangat melipatgandakan susah payahmu ketika mengandung; dalam kesakitan kamu akan melahirkan anak-anak; tetapi kamu tetap akan berahi kepada suamimu, dan dia akan berkuasa atasmu.” ");
INSERT INTO indayt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Lalu, kepada manusia itu, Dia berfirman, “Karena kamu mendengarkan suara istrimu, dan telah makan dari pohon yang kepadamu telah Kuperintahkan, ‘Jangan kamu memakannya,’ terkutuklah tanah karena kamu! Dengan susah payah kamu akan makan dari hasilnya selama hari-hari hidupmu. ");
INSERT INTO indayt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Semak duri dan rumput liarlah yang akan ditumbuhkan bagimu, dan kamu akan memakan tumbuh-tumbuhan di padang. ");
INSERT INTO indayt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Dengan keringat di wajahmu, kamu akan makan roti, sampai kamu kembali kepada tanah yang darinya kamu diambil. Sebab, kamu adalah debu, dan kamu akan kembali kepada debu. ");
INSERT INTO indayt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Manusia itu menyebut istrinya Hawa karena dia adalah ibu dari semua yang hidup. ");
INSERT INTO indayt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","TUHAN Allah membuat pakaian dari kulit untuk manusia dan istrinya itu, lalu mengenakannya kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Setelah itu, TUHAN Allah berfirman, “Lihatlah, manusia itu menjadi seperti salah satu dari Kita, tahu tentang yang baik dan yang jahat. Sekarang, jangan sampai dia mengulurkan tangannya dan mengambil juga dari pohon kehidupan, lalu memakannya dan hidup selama-lamanya.” ");
INSERT INTO indayt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Karena itu, TUHAN Allah menyuruhnya keluar dari taman Eden untuk mengolah tanah yang dari itu dia diambil. ");
INSERT INTO indayt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Setelah Allah menghalau manusia itu keluar, di sebelah timur taman Eden ditempatkan-Nyalah kerub-kerub dengan pedang api yang menyambar-nyambar untuk menjaga jalan menuju pohon kehidupan. ");
INSERT INTO indayt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam bersetubuh dengan Hawa, istrinya, lalu Hawa mengandung dan melahirkan Kain. Dia berkata, “Aku telah mendapatkan seorang laki-laki dari TUHAN!” ");
INSERT INTO indayt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kemudian, Hawa melahirkan adiknya, yaitu Habel. Habel menggembalakan domba, sedangkan Kain menggarap tanah. ");
INSERT INTO indayt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Pada suatu waktu, Kain membawa kepada TUHAN suatu persembahan hasil dari tanah itu, ");
INSERT INTO indayt_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel juga membawa yang sulung dari kawanan dombanya beserta lemak-lemaknya. TUHAN memperhatikan Habel dan persembahannya, ");
INSERT INTO indayt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tetapi terhadap Kain dan persembahannya, Dia tidak memperhatikannya. Lalu, Kain menjadi sangat marah dan wajahnya muram. ");
INSERT INTO indayt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","TUHAN berkata kepada Kain, “Mengapa kamu marah? Mengapa mukamu muram? ");
INSERT INTO indayt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Jika kamu berbuat baik, bukankah kamu akan diterima? Namun, jika kamu tidak berbuat baik, dosa sudah mengintip di pintu, keinginannya adalah untukmu, tetapi kamu harus berkuasa atasnya.” ");
INSERT INTO indayt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain berbicara dengan Habel, saudaranya. Lalu, terjadilah, ketika mereka berada di padang, Kain bangkit untuk menyerang Habel, saudaranya itu, dan membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Lalu, TUHAN bertanya kepada Kain, “Di mana Habel, adikmu?” Kain menjawab, “Aku tidak tahu. Apakah aku penjaga adikku?” ");
INSERT INTO indayt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","TUHAN berkata, “Apa yang sudah kamu lakukan? Suara darah adikmu itu menjerit kepada-Ku dari dalam tanah. ");
INSERT INTO indayt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sekarang, kamu terkutuk dari tanah yang telah membuka mulutnya untuk menerima darah adikmu dari tanganmu. ");
INSERT INTO indayt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Jika kamu menggarap tanah itu, ia tidak akan lagi memberikan hasilnya untukmu. Kamu akan mengembara dan menggelandang di bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kemudian, Kain berkata kepada TUHAN, “Hukumanku itu lebih berat daripada yang sanggup kutanggung. ");
INSERT INTO indayt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lihat! Hari ini Engkau telah menggiring aku dari tanah ini. Lalu, aku akan tersembunyi dari hadapan-Mu, dan aku akan menjadi buronan dan pengembara di bumi, dan akan terjadi, siapa saja yang bertemu denganku akan membunuhku.” ");
INSERT INTO indayt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Namun, TUHAN berkata kepada Kain, “Karena itu, siapa pun yang membunuh Kain, kepadanya akan dibalaskan tujuh kali lipat.” Kemudian, TUHAN memberi tanda pada Kain supaya tidak seorang pun yang bertemu dengannya akan membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Lalu, Kain pergi dari hadapan TUHAN dan menetap di tanah Nod, sebelah timur Eden. ");
INSERT INTO indayt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain bersetubuh dengan istrinya, lalu istrinya itu mengandung dan melahirkan Henokh. Kain membangun suatu kota dan menyebut nama kota itu seperti nama anaknya, Henokh. ");
INSERT INTO indayt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Bagi Henokh, lahirlah Irad, dan Irad adalah ayah Mehuyael. Mehuyael adalah ayah Metusael, dan Metusael adalah ayah Lamekh. ");
INSERT INTO indayt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekh mengambil dua istri baginya, yang satu bernama Ada dan yang lain bernama Zila. ");
INSERT INTO indayt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada melahirkan Yabal yang adalah nenek moyang semua yang tinggal dalam tenda dan beternak. ");
INSERT INTO indayt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Saudaranya bernama Yubal, dia adalah nenek moyang semua yang memainkan kecapi dan seruling. ");
INSERT INTO indayt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila juga melahirkan Tubal-Kain, dia yang menempa segala perkakas dari perunggu dan besi. Saudara perempuan Tubal-Kain adalah Naama. ");
INSERT INTO indayt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamekh berkata kepada kedua istrinya, “Ada dan Zila, dengarlah suaraku! Hai istri-istri Lamekh, dengarkanlah perkataanku! Aku telah membunuh seorang laki-laki karena lukaku, dan seorang laki-laki muda karena melukaiku. ");
INSERT INTO indayt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Jika kepada Kain dibalaskan tujuh kali lipat, kepada Lamekh dibalaskan 77 kali lipat!” ");
INSERT INTO indayt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam bersetubuh lagi dengan istrinya, dan istrinya itu melahirkan anak laki-laki lainnya, dan menyebut namanya Set, sebab katanya, “Allah menentukan benih yang lain bagiku sebagai ganti Habel karena Kain telah membunuhnya.” ");
INSERT INTO indayt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seorang anak laki-laki juga lahir bagi Set, dan dia menyebut namanya Enos. Pada masa itulah manusia mulai memanggil nama TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Inilah catatan keturunan Adam. Pada hari Allah menciptakan manusia, Dia membuatnya dalam keserupaan dengan Allah. ");
INSERT INTO indayt_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Dia menciptakan mereka, laki-laki dan perempuan, dan Dia memberkati mereka, dan menamai mereka manusia, pada hari mereka diciptakan. ");
INSERT INTO indayt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ketika Adam hidup selama 130 tahun dan seorang anak laki-laki lahir baginya dalam keserupaan dengannya, menurut rupanya. Lalu, dia menamainya Set. ");
INSERT INTO indayt_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam hidup 800 tahun lagi, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Jadi, seluruh masa hidup Adam adalah 930 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ketika Set hidup selama 105 tahun, Enos lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set hidup 807 tahun lagi setelah Enos lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Jadi, seluruh masa hidup Set adalah 912 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ketika Enos hidup selama 90 tahun, Kenan lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos hidup 815 tahun lagi setelah Kenan lahir, dan dia mendapatkan anak laki-laki dan anak perempuan. Masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Jadi, masa hidup Enos adalah 905 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ketika Kenan hidup selama 70 tahun, Mahalaleel lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan hidup 840 tahun lagi setelah Mahalaleel lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Jadi, masa hidup Kenan adalah 910 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ketika Mahalaleel hidup selama 65 tahun, Yared lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleel hidup 830 tahun lagi setelah Yared lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Jadi, masa hidup Mahalaleel adalah 895 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ketika Yared hidup selama 162 tahun, Henokh lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yared hidup 800 tahun lagi setelah Henokh lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jadi, masa hidup Yared adalah 962 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ketika Henokh hidup selama 65 tahun, Metusalah lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henokh berjalan dengan Allah selama 300 tahun setelah Metusalah lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Jadi, masa hidup Henokh adalah 365 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henokh berjalan dengan Allah, setelah itu dia tidak ada lagi, sebab Allah mengambilnya. ");
INSERT INTO indayt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ketika Metusalah hidup selama 187 tahun, Lamekh lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusalah hidup 782 tahun lagi setelah Lamekh lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jadi, masa hidup Metusalah adalah 969 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Setelah Lamekh hidup selama 182 tahun, seorang anak laki-laki lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Dia menamai anak itu Nuh dan berkata, “Dia ini akan menghibur kita dalam kerja keras dan jerih payah tangan kita akibat tanah yang telah TUHAN kutuk ini.” ");
INSERT INTO indayt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamekh hidup 595 tahun lagi setelah Nuh lahir, dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Jadi, masa hidup Lamekh adalah 777 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ketika Nuh hidup selama 500 tahun, Sem, Ham, dan Yafet lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ketika manusia mulai berlipat ganda di muka bumi dan anak-anak perempuan dilahirkan bagi mereka, ");
INSERT INTO indayt_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","anak-anak Allah melihat bahwa anak-anak perempuan manusia itu cantik, lalu mereka mengambil istri-istri yang mereka pilih untuk diri mereka sendiri. ");
INSERT INTO indayt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kemudian, TUHAN berfirman, “Roh-Ku tidak akan selama-lamanya beperkara dengan manusia karena dia adalah daging, hari-harinya akan menjadi 120 tahun.” ");
INSERT INTO indayt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ada raksasa-raksasa di bumi pada zaman itu, bahkan sesudahnya, ketika anak-anak Allah datang kepada anak-anak perempuan manusia dan melahirkan anak-anak bagi mereka. Inilah orang-orang yang perkasa sejak dahulu kala, orang-orang yang terkenal. ");
INSERT INTO indayt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","TUHAN melihat bahwa kejahatan manusia demikian besar di bumi, dan setiap maksud pikiran dari hatinya semata-mata jahat sepanjang waktu. ");
INSERT INTO indayt_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","TUHAN menyesal bahwa Dia telah menjadikan manusia di bumi, dan hal itu mendukakan hati-Nya. ");
INSERT INTO indayt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Karena itu, TUHAN berfirman, “Aku akan memusnahkan manusia yang telah Kuciptakan dari muka bumi; baik manusia dan binatang, yang merayap dan burung-burung di udara, sebab Aku menyesal telah menjadikan mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Namun, Nuh mendapat perkenanan di mata TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Inilah keturunan Nuh. Nuh adalah orang yang benar, tidak bercela pada zamannya, dan Nuh berjalan dengan Allah. ");
INSERT INTO indayt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Tiga anak laki-laki lahir bagi Nuh, yaitu Sem, Ham, dan Yafet. ");
INSERT INTO indayt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Pada saat itu, bumi sudah rusak di hadapan Allah dan bumi dipenuhi dengan kekerasan. ");
INSERT INTO indayt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allah mengamati bumi, dan lihatlah, ia sudah rusak, sebab semua manusia telah merusak jalan hidupnya di bumi. ");
INSERT INTO indayt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Lalu, Allah berkata kepada Nuh, “Akhir dari semua manusia telah datang di hadapan-Ku sebab bumi sudah dipenuhi dengan kekerasan oleh mereka. Lihat! Aku akan memusnahkan mereka bersama dengan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Buatlah bahtera dari kayu gofir untuk dirimu. Buatlah kamar-kamar di dalam bahtera itu dan lapisilah bagian dalam maupun luarnya dengan ter. ");
INSERT INTO indayt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Beginilah kamu harus membuatnya: panjang bahtera itu 300 hasta, lebarnya 50 hasta, dan tingginya 30 hasta. ");
INSERT INTO indayt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Buatlah jendela untuk bahtera itu dan selesaikanlah itu kira-kira sehasta dari atas. Pasanglah pintu bahtera di sisinya. Buatlah bahtera itu dengan geladak bawah, kedua, dan ketiga. ");
INSERT INTO indayt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Lihat, Aku akan mendatangkan air bah ke atas bumi untuk memusnahkan semua daging yang di dalamnya ada napas kehidupan di bawah langit sehingga semua yang ada di bumi akan mati. ");
INSERT INTO indayt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Akan tetapi, Aku akan menetapkan perjanjian-Ku denganmu, dan kamu akan masuk ke dalam bahtera; kamu, anak-anakmu, istrimu, dan para istri anak-anakmu. ");
INSERT INTO indayt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Dari segala yang hidup, kamu harus membawa sepasang dari setiap jenisnya ke bahtera untuk menjaganya tetap hidup bersamamu, jantan dan betina. ");
INSERT INTO indayt_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dari burung-burung menurut jenisnya, dari binatang-binatang menurut jenisnya, dan dari setiap yang merayap di tanah menurut jenisnya, sepasang dari setiap jenis itu akan datang kepadamu supaya mereka tetap hidup. ");
INSERT INTO indayt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bawalah juga segala makanan yang dapat dimakan, kumpulkanlah itu bagi dirimu, dan itu akan menjadi makanan untukmu dan untuk mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Demikianlah Nuh melaksanakannya, dia melaksanakan semua yang diperintahkan Allah kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kemudian, TUHAN berfirman kepada Nuh, “Masuklah ke dalam bahtera, kamu dan seisi rumahmu, sebab aku telah melihat bahwa kamulah yang benar di hadapan-Ku dalam generasi ini. ");
INSERT INTO indayt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bawalah tujuh pasang binatang yang halal, jantan dan betinanya, dan sepasang dari setiap jenis binatang yang haram jantan dan betinanya, ");
INSERT INTO indayt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","juga tujuh pasang burung di udara, jantan dan betina, untuk menjaga keturunan mereka di seluruh muka bumi. ");
INSERT INTO indayt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sebab, dalam tujuh hari, Aku akan menurunkan hujan ke bumi selama empat puluh hari dan empat puluh malam, dan segala yang hidup, yang telah Aku buat itu, akan Aku musnahkan dari muka bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lalu, Nuh melaksanakan semua yang telah TUHAN perintahkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuh berumur 600 tahun ketika air bah itu melanda bumi. ");
INSERT INTO indayt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Lalu, Nuh beserta anak-anaknya, dan istrinya, dan para istri anak-anaknya masuk ke dalam bahtera karena air bah itu. ");
INSERT INTO indayt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Dari binatang yang halal dan binatang yang haram, dan burung-burung, dan segala yang merayap di tanah, ");
INSERT INTO indayt_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sepasang demi sepasang, jantan dan betina, datang kepada Nuh ke dalam bahtera itu, sebagaimana yang telah diperintahkan Allah kepada Nuh. ");
INSERT INTO indayt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Setelah tujuh hari, air bah itu pun melanda bumi. ");
INSERT INTO indayt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pada tahun keenam ratus masa hidup Nuh, pada bulan kedua, hari ketujuh belas bulan itu, pada hari itu semua mata air samudra raya terbelah dan semua pintu air di langit terbuka. ");
INSERT INTO indayt_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Hujan turun ke bumi selama empat puluh hari dan empat puluh malam. ");
INSERT INTO indayt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Pada hari yang sama, Nuh bersama Sem, dan Ham, dan Yafet; anak-anak Nuh, serta istri Nuh, dan ketiga istri anak-anaknya masuk ke dalam bahtera. ");
INSERT INTO indayt_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Mereka dan setiap binatang menurut jenisnya, setiap jenis ternak, segala yang merayap di muka bumi menurut jenisnya, dan setiap burung menurut jenisnya, setiap yang bersayap. ");
INSERT INTO indayt_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mereka masuk ke dalam bahtera bersama Nuh, sepasang demi sepasang dari segala makhluk yang ada napas hidup di dalamnya. ");
INSERT INTO indayt_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Mereka yang masuk ke dalam, jantan dan betina dari segala makhluk, mereka masuk sebagaimana yang telah diperintahkan TUHAN kepada Nuh. Lalu, TUHAN menutupkan bahtera itu untuk Nuh. ");
INSERT INTO indayt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Banjir itu berlangsung selama empat puluh hari, dan air itu bertambah-tambah dan mengangkat bahtera itu sehingga naik tinggi di atas bumi. ");
INSERT INTO indayt_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Air itu semakin hebat dan bertambah sangat besar di muka bumi, dan bahtera itu terapung-apung di permukaan air. ");
INSERT INTO indayt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Air itu makin bertambah-tambah hebatnya di bumi sehingga semua gunung yang tinggi, yang ada di kolong langit pun tertutup. ");
INSERT INTO indayt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Air itu mencapai 15 hasta lebih tinggi dan gunung-gunung ditutupinya. ");
INSERT INTO indayt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Segala makhluk yang bergerak di bumi pun musnah, baik burung-burung, ternak, binatang liar, segala makhluk melata yang merayap di atas bumi, dan semua manusia. ");
INSERT INTO indayt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Semua yang di darat, yang ada napas kehidupan dalam hidungnya, mati. ");
INSERT INTO indayt_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Dia memusnahkan segala yang hidup yang ada di muka bumi, manusia dan binatang, dan yang merayap, dan burung-burung di langit. Mereka dimusnahkan dari bumi. Hanya Nuh yang tertinggal serta mereka yang bersama dengannya dalam bahtera. ");
INSERT INTO indayt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Air pun terus menguasai bumi selama 150 hari. ");
INSERT INTO indayt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Lalu, Allah mengingat Nuh, dan segala binatang, dan segala ternak yang bersamanya dalam bahtera itu. Allah membuat angin berembus ke atas bumi sehingga air pun surut. ");
INSERT INTO indayt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Setelah itu, mata air-mata air dari kedalaman bumi dan dari pintu-pintu air di langit juga ditutup. Hujan dari langit pun dihentikan. ");
INSERT INTO indayt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Air itu berangsur-angsur surut dari muka bumi dan pada akhir hari ke-150, air itu berkurang. ");
INSERT INTO indayt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pada bulan ketujuh, hari yang ketujuh belas pada bulan itu, bahtera itu kandas di pegunungan Ararat. ");
INSERT INTO indayt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Air itu terus surut sampai bulan kesepuluh. Pada hari pertama bulan kesepuluh itu, puncak-puncak pegunungan itu tampak. ");
INSERT INTO indayt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Pada akhir dari 40 hari itu, Nuh membuka jendela bahtera yang dibuatnya, ");
INSERT INTO indayt_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","dan melepaskan seekor gagak yang pergi, terbang, dan kembali lagi sampai air itu mengering dari permukaan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kemudian, dia juga melepaskan seekor merpati darinya untuk mengetahui apakah air telah surut dari permukaan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Akan tetapi, merpati itu tidak menemukan tempat untuk bertengger sehingga ia kembali kepada Nuh di dalam bahtera itu karena air masih ada di seluruh permukaan bumi. Nuh mengulurkan tangannya untuk menangkap merpati itu dan memasukannya ke bahtera. ");
INSERT INTO indayt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Jadi, dia menunggu selama tujuh hari lagi, dan dia kembali melepaskan merpati itu dari bahtera. ");
INSERT INTO indayt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Lalu, merpati itu kembali kepadanya pada sore hari, dan lihat, sehelai daun zaitun yang baru terpetik ada di paruhnya. Dengan demikian, Nuh mengetahui bahwa air telah surut dari permukaan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuh menunggu selama tujuh hari lagi, lalu kembali melepaskan merpati itu, yang tidak kembali lagi kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pada tahun yang ke-601, pada hari pertama bulan pertama itu, air telah mengering dari bumi. Lalu, Nuh membuka atap bahtera itu dan melihat bahwa permukaan tanah sudah kering. ");
INSERT INTO indayt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pada bulan kedua hari ke-27 bulan itu, bumi sudah kering. ");
INSERT INTO indayt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kemudian, Allah berkata kepada Nuh, ");
INSERT INTO indayt_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Keluarlah dari bahtera itu, kamu, istrimu, anak-anakmu, dan istri-istri mereka, bersamamu. ");
INSERT INTO indayt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bawalah denganmu segala yang hidup yang ada bersamamu, burung-burung, binatang ternak, segala yang melata yang merayap di atas bumi, supaya mereka dapat berkelompok di bumi, berkembang biak, dan bertambah-tambah banyaknya di atas bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Lalu, Nuh keluar, dan anak-anaknya, istrinya, juga para istri anak-anaknya bersamanya. ");
INSERT INTO indayt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Segala binatang, segala yang merayap, segala burung, segala yang bergerak di atas bumi, keluar dari bahtera menurut jenisnya masing-masing. ");
INSERT INTO indayt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kemudian, Nuh membangun sebuah mazbah untuk TUHAN. Dia mengambil beberapa binatang yang halal dan beberapa dari burung yang halal, lalu mempersembahkan persembahan bakaran di mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","TUHAN mencium bau harum itu dan TUHAN berkata dalam hati-Nya, “Aku tidak akan lagi mengutuk tanah karena manusia sebab niat hati manusia itu jahat sejak masa mudanya. Aku juga tidak akan memusnahkan lagi setiap makhluk hidup seperti yang telah Aku lakukan. ");
INSERT INTO indayt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Selama bumi masih ada, musim tanam dan musim panen, dingin dan panas, musim kemarau dan musim hujan, siang dan malam, tidak akan berhenti.” ");
INSERT INTO indayt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Allah memberkati Nuh beserta anak-anaknya, dan berfirman kepada mereka, “Beranakcuculah, dan berlipatgandalah, dan penuhilah bumi. ");
INSERT INTO indayt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ketakutan akan kamu dan kegentaran akan kamu akan berlaku atas setiap binatang di bumi dan atas setiap burung di langit, atas segala yang merayap di bumi dan atas segala ikan di laut. Ke dalam tanganmu mereka diserahkan. ");
INSERT INTO indayt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Segala yang hidup dan bergerak akan menjadi makananmu. Seperti Aku memberikan tumbuhan-tumbuhan hijau kepadamu, sekarang Aku memberikan segalanya kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Namun, jangan kamu makan daging yang masih bernyawa, yaitu darahnya. ");
INSERT INTO indayt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sebab, Aku pasti akan menuntut pembalasan atas darahmu, yaitu nyawamu; dari setiap binatang Aku akan menuntutnya, dan Aku juga akan menuntut nyawa manusia lainnya dari setiap manusia. ");
INSERT INTO indayt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Siapa pun yang menumpahkan darah manusia, darahnya akan ditumpahkan oleh manusia. Sebab, Allah menciptakan manusia sesuai dengan rupa-Nya sendiri. ");
INSERT INTO indayt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Beranakcuculah kamu serta berlipatgandalah; penuhilah bumi dan berlipatgandalah di dalamnya.” ");
INSERT INTO indayt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Lalu, Allah berkata kepada Nuh dan anak-anaknya yang bersamanya, ");
INSERT INTO indayt_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Lihat! Sekarang Aku menetapkan perjanjian-Ku denganmu dan dengan keturunanmu yang akan datang, ");
INSERT INTO indayt_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","dan dengan segala yang hidup yang ada bersamamu, baik burung-burung, ternak, segala binatang di bumi, dari semua yang keluar dari bahtera, yaitu segala binatang di bumi. ");
INSERT INTO indayt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Aku menetapkan perjanjian-Ku denganmu: tidak akan ada lagi makhluk hidup yang dibinasakan oleh air bah; tidak akan ada lagi air bah yang menghancurkan bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Allah berfirman, “Inilah tanda perjanjian yang Kubuat antara Aku dan kamu, dan setiap makhluk hidup yang bersama-sama denganmu, untuk seluruh generasi selanjutnya: ");
INSERT INTO indayt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Aku akan menaruh busur-Ku di awan dan itu akan menjadi bukti perjanjian antara Aku dan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Apabila Aku mendatangkan awan-awan ke atas bumi dan busur itu tampak di awan, ");
INSERT INTO indayt_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Aku akan mengingat perjanjian antara Aku dan kamu dan setiap makhluk hidup sehingga air tidak akan lagi menjadi air bah yang membinasakan semua yang hidup. ");
INSERT INTO indayt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kapan pun busur itu ada di awan, Aku akan melihatnya dan akan mengingat perjanjian kekal antara Allah dan setiap makhluk hidup yang ada di atas bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kemudian, Allah berfirman kepada Nuh, “Itulah tanda dari perjanjian yang telah Aku tetapkan antara Aku dengan segala makhluk hidup di bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Anak-anak Nuh yang keluar dari bahtera adalah Sem, Ham, dan Yafet. Ham adalah bapak orang Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mereka bertiga adalah anak Nuh. Dari mereka, lahir seluruh manusia yang tersebar di bumi. ");
INSERT INTO indayt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh menjadi petani dan mulai menggarap kebun anggur. ");
INSERT INTO indayt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Pada suatu hari, Nuh minum anggur dan mabuk, lalu dia telanjang di dalam tendanya. ");
INSERT INTO indayt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, bapak orang Kanaan itu, melihat ketelanjangan ayahnya dan memberitahukannya kepada kedua saudaranya di luar. ");
INSERT INTO indayt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Akan tetapi, Sem dan Yafet mengambil sehelai kain dan meletakkannya di bahu mereka, lalu dengan berjalan mundur mereka menutupi ketelanjangan ayah mereka. Mereka memalingkan wajah mereka sehingga tidak melihat ketelanjangan ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ketika Nuh sadar dari mabuknya, dia mengetahui yang dilakukan anak bungsunya itu kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Karena itu, dia berkata, “Terkutuklah Kanaan! Kiranya dia menjadi hamba dari hamba saudara-saudaranya.” ");
INSERT INTO indayt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuh juga berkata, “Terpujilah TUHAN, Allah Sem! Biarlah Kanaan menjadi hambanya. ");
INSERT INTO indayt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Biarlah Allah meluaskan Yafet, biarlah dia tinggal di tenda Sem, dan biarlah Kanaan menjadi hamba baginya.” ");
INSERT INTO indayt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Setelah air bah, Nuh masih hidup 350 tahun lagi. ");
INSERT INTO indayt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Jadi, seluruh masa hidup Nuh adalah 950 tahun, kemudian dia mati. ");
INSERT INTO indayt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Inilah keturunan Sem, Ham, dan Yafet, anak-anak Nuh. Anak-anak laki-laki lahir bagi mereka setelah peristiwa air bah. ");
INSERT INTO indayt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Keturunan Yafet adalah Gomer, Magog, Madai, Yawan, Tubal, Mesekh, dan Tiras. ");
INSERT INTO indayt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Keturunan Gomer adalah Askenas, Rifat, dan Togarma. ");
INSERT INTO indayt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Keturunan Yawan adalah Elisa, Tarsis, Kitim, dan Dodanim. ");
INSERT INTO indayt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dari merekalah tersebar bangsa-bangsa daerah pesisir, masing-masing menurut bahasa, kaum keluarga, dan bangsanya sendiri. ");
INSERT INTO indayt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Keturunan Ham adalah Kush, Misraim, Put, dan Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Keturunan Kush adalah Seba, Hawila, Sabta, Raema, dan Sabtekha. Keturunan Raema adalah Syeba dan Dedan. ");
INSERT INTO indayt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kush adalah ayah Nimrod, yang menjadi orang perkasa pertama di bumi. ");
INSERT INTO indayt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Dia adalah pemburu yang perkasa di hadapan TUHAN. Karena itu, orang-orang berkata, “Seperti Nimrod, pemburu yang perkasa di hadapan TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pada awalnya, wilayah kerajaannya adalah Babel, Erekh, Akad, dan Kalne di tanah Sinear. ");
INSERT INTO indayt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dari tanah itu, dia masuk ke Asyur lalu membangun Niniwe, Rehobot-Ir, Kalah, ");
INSERT INTO indayt_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","dan Resen yang ada di antara Niniwe dan Kalah; yang adalah kota yang besar. ");
INSERT INTO indayt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim adalah ayah Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO indayt_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim, yang adalah nenek moyang bangsa Filistin, dan Kaftorim. ");
INSERT INTO indayt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan adalah ayah Sidon, anak sulungnya, dan Het, ");
INSERT INTO indayt_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","dan orang Yebusi, orang Amori, orang Girgasi, ");
INSERT INTO indayt_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","orang Hewi, orang Arki, orang Sini, ");
INSERT INTO indayt_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","orang Arwadi, orang Semari, dan orang Hamati. Seiring berjalannya waktu, kaum keluarga Kanaan ini pun tersebar. ");
INSERT INTO indayt_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Wilayah orang Kanaan membentang dari Sidon ke arah Gerar sampai ke Gaza, dan ke arah Sodom, Gomora, Adma, Zeboim, sampai ke Lasa. ");
INSERT INTO indayt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Itulah keturunan Ham menurut kaum keluarganya, bahasanya, negerinya, dan bangsanya. ");
INSERT INTO indayt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Lahirlah juga anak-anak laki-laki bagi Sem, yang adalah nenek moyang anak-anak Eber dan saudara tertua Yafet. ");
INSERT INTO indayt_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Keturunan Sem adalah Elam, Asyur, Arpakhsad, Lud, dan Aram. ");
INSERT INTO indayt_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Keturunan Aram adalah Us, Hul, Geter, dan Mas. ");
INSERT INTO indayt_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakhsad adalah ayah Selah; dan Selah adalah ayah Eber. ");
INSERT INTO indayt_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Bagi Eber, lahirlah dua anak laki-laki, yang satu bernama Peleg sebab pada masa hidupnya bumi terbelah, sedangkan saudaranya bernama Yoktan. ");
INSERT INTO indayt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan adalah ayah Almodad, Selef, Hazar-Mawet, Yerah, ");
INSERT INTO indayt_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO indayt_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO indayt_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, dan Yobab; semuanya adalah keturunan Yoktan. ");
INSERT INTO indayt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wilayah mereka membentang dari Mesa ke arah Sefar di pegunungan sebelah timur. ");
INSERT INTO indayt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Itulah keturunan Sem menurut kaum keluarganya, bahasanya, negerinya, dan bangsanya. ");
INSERT INTO indayt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Itulah daftar keluarga dari anak-anak Nuh menurut silsilah mereka dan bangsa mereka. Dari merekalah, bangsa-bangsa tersebar ke seluruh bumi setelah peristiwa air bah. ");
INSERT INTO indayt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pada saat itu, seluruh bumi itu memiliki satu bahasa dan logat yang sama. ");
INSERT INTO indayt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dalam perjalanan ke timur, mereka menemukan dataran di tanah Sinear dan menetap di sana. ");
INSERT INTO indayt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lalu, mereka berkata satu sama lain, “Mari kita membuat batu bata dan membakarnya baik-baik.” Lalu, mereka memakai bata-bata itu sebagai batu dan aspal sebagai perekatnya. ");
INSERT INTO indayt_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kemudian, mereka berkata, “Mari kita membangun kota bagi kita dengan menara yang puncaknya sampai ke langit, dan marilah kita membuat nama bagi kita supaya kita jangan tersebar ke seluruh muka bumi.” ");
INSERT INTO indayt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Akan tetapi, TUHAN turun untuk melihat kota dan menara yang telah dibangun oleh anak-anak manusia itu. ");
INSERT INTO indayt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","TUHAN berkata, “Lihat! Mereka ini adalah satu bangsa dan mereka memakai bahasa yang sama, dan ini baru awal dari yang dapat mereka lakukan. Mulai sekarang, segala yang mereka rencanakan untuk dilakukan, tidak ada yang tidak terlaksana. ");
INSERT INTO indayt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ayo, Kita turun dan mengacaukan bahasa mereka supaya mereka tidak dapat memahami satu sama lain.” ");
INSERT INTO indayt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Lalu, TUHAN mencerai-beraikan mereka ke seluruh bumi. Mereka pun berhenti membangun kota itu. ");
INSERT INTO indayt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Karena itu, tempat itu disebut Babel karena di sana TUHAN mengacaukan bahasa seluruh bumi, dan dari tempat itu TUHAN mencerai-beraikan mereka ke seluruh muka bumi. ");
INSERT INTO indayt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Inilah keturunan Sem. Ketika Sem berumur 100 tahun, Arpakhsad lahir baginya, yaitu dua tahun setelah peristiwa air bah. ");
INSERT INTO indayt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Setelah Arpakhsad lahir baginya, Sem hidup 500 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ketika Arpakhsad hidup selama 35 tahun, Selah lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Setelah Selah lahir baginya, Arpakhsad hidup 403 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ketika Selah hidup selama 30 tahun, Eber lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Setelah Eber lahir baginya, Selah hidup 403 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ketika Eber hidup selama 34 tahun, Peleg lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Setelah Peleg lahir baginya, Eber hidup 430 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ketika Peleg hidup selama 30 tahun, Rehu lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Setelah Rehu lahir baginya, Peleg hidup 209 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ketika Rehu hidup selama 32 tahun, Serug lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Setelah Serug lahir baginya, Rehu hidup 207 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ketika Serug hidup selama 30 tahun, Nahor lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Setelah Nahor lahir baginya, Serug hidup 200 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ketika Nahor hidup selama 29 tahun, Terah lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Setelah Terah lahir baginya, Nahor hidup 119 tahun lagi dan masih ada anak laki-laki dan anak perempuan lainnya yang lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ketika Terah hidup selama 70 tahun, Abram, Nahor, dan Haran lahir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Inilah keturunan Terah. Abram, Nahor, dan Haran lahir bagi Terah. Setelah itu, Lot lahir bagi Haran. ");
INSERT INTO indayt_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mati di hadapan Terah, ayahnya, di tanah kelahirannya, Ur-Kasdim. ");
INSERT INTO indayt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram dan Nahor mengambil istri. Istri Abram bernama Sarai dan istri Nahor bernama Milka, anak Haran, ayah Milka dan Yiska. ");
INSERT INTO indayt_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai itu mandul, dia tidak punya anak. ");
INSERT INTO indayt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Dari Ur-Kasdim, Terah membawa Abram, anaknya, Lot anak Haran, cucunya, dan Sarai, menantunya, istri Abram, ke tanah Kanaan. Ketika sampai di Haran, mereka menetap di sana. ");
INSERT INTO indayt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah hidup selama 205 tahun, dan dia mati di Haran. ");
INSERT INTO indayt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","TUHAN berfirman kepada Abram, “Pergilah dari negerimu, dan dari keluargamu, dan dari rumah ayahmu, ke tanah yang akan Kutunjukkan kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aku akan menjadikanmu suatu bangsa yang besar, dan Aku akan memberkatimu, dan membuat namamu masyhur, dan kamu akan menjadi berkat. ");
INSERT INTO indayt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aku akan memberkati mereka yang memberkatimu, tetapi orang yang mengutukmu akan Aku kutuk. Melaluimu, semua kaum di bumi akan diberkati.” ");
INSERT INTO indayt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Lalu, Abram pergi seperti yang telah difirmankan TUHAN kepadanya dan Lot turut besertanya. Abram berumur 75 tahun ketika dia pergi dari Haran. ");
INSERT INTO indayt_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Dia membawa Sarai, istrinya, dan Lot, keponakannya, dan semua harta yang telah mereka kumpulkan, serta orang-orang yang diperolehnya di Haran. Mereka pergi ke tanah Kanaan. Kemudian, mereka tiba di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram berjalan melalui tanah itu sampai ke suatu tempat di Sikhem, di pohon tarbantin More. Pada masa itu, orang Kanaan tinggal di tanah itu. ");
INSERT INTO indayt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kemudian, TUHAN menampakkan diri kepada Abram dan berkata, “Aku akan memberikan tanah ini kepada keturunanmu.” Di sana, dia membangun mazbah bagi TUHAN, yang telah menampakkan diri kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Dari tempat itu, dia pindah ke pegunungan di sebelah timur Betel dan membentangkan tendanya dengan Betel di sebelah barat dan Ai di sebelah timur. Di sana, dia mendirikan mazbah bagi TUHAN dan memanggil nama TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kemudian, Abram meneruskan perjalanannya menuju Negeb. ");
INSERT INTO indayt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Saat itu, kelaparan melanda negeri itu sehingga Abram pergi ke Mesir untuk tinggal sementara di sana sebab kelaparan di tanah itu sangat hebat. ");
INSERT INTO indayt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ketika dia hampir memasuki Mesir, dia berkata kepada Sarai, istrinya: “Lihatlah, aku tahu bahwa kamu adalah perempuan yang cantik. ");
INSERT INTO indayt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kalau orang Mesir melihatmu, mereka akan berkata, ‘Itu istrinya.’ Kemudian, mereka akan membunuhku, tetapi mereka akan membiarkanmu hidup. ");
INSERT INTO indayt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Aku mohon, katakanlah bahwa kamu adalah adikku, supaya karena kamu, hal itu menjadi baik bagiku dan nyawaku akan hidup karenamu.” ");
INSERT INTO indayt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ketika Abram memasuki Mesir, orang Mesir melihat bahwa perempuan itu sangat cantik. ");
INSERT INTO indayt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pejabat-pejabat Firaun juga melihatnya dan memuji-muji dia di hadapan Firaun sehingga perempuan itu dibawa ke istana Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Dia pun memperlakukan Abram dengan baik demi perempuan itu dan memberikan kawanan domba, sapi-sapi jantan, keledai-keledai jantan, pelayan laki-laki dan pelayan perempuan, keledai-keledai betina, dan unta-unta kepada Abram. ");
INSERT INTO indayt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Akan tetapi, TUHAN menimpakan wabah penyakit yang dahsyat kepada Firaun dan seisi istananya karena Sarai, istri Abram. ");
INSERT INTO indayt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Karena itu, Firaun memanggil Abram dan berkata, “Apa yang sudah kamu lakukan terhadapku? Mengapa kamu tidak mengatakan kepadaku kalau dia itu istrimu? ");
INSERT INTO indayt_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mengapa kamu berkata, ‘Dia adalah adikku,’ sehingga aku mengambil dia menjadi istriku? Ini istrimu! Ambil dia dan pergi!” ");
INSERT INTO indayt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kemudian, Firaun memberikan perintah kepada orang-orangnya tentang Abram sehingga mereka melepasnya pergi beserta dengan istrinya dan segala kepunyaannya. ");
INSERT INTO indayt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram pergi dari Mesir menuju ke selatan, dia dan istrinya, dan segala kepunyaannya, dan Lot bersamanya. ");
INSERT INTO indayt_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram sangat kaya akan ternak, perak, dan emas. ");
INSERT INTO indayt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram meneruskan perjalanannya mulai dari selatan sampai Betel, ke tempat dia mendirikan tendanya mula-mula, yaitu di antara Betel dan Ai, ");
INSERT INTO indayt_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tempat dia mendirikan mazbah untuk pertama kalinya. Di sana, Abram memanggil nama TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, yang ikut bersama Abram, juga memiliki kawanan domba, kawanan sapi, dan tenda-tenda, ");
INSERT INTO indayt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","sehingga negeri itu tidak cukup lagi menampung mereka untuk hidup bersama-sama. Karena harta milik mereka sangat banyak, mereka tidak dapat tinggal bersama-sama lagi. ");
INSERT INTO indayt_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Lalu, terjadilah perselisihan di antara para gembala ternak Abram dan para gembala ternak Lot. Pada masa itu, orang Kanaan dan orang Feris mendiami negeri itu. ");
INSERT INTO indayt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram berkata kepada Lot, “Aku mohon, jangan sampai terjadi perselisihan antara kamu dan aku, atau antara gembala-gembalaku dan gembala-gembalamu sebab kita ini bersaudara. ");
INSERT INTO indayt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bukankah seluruh tanah ini ada di hadapanmu? Pisahkanlah dirimu dariku. Jika kamu ke sebelah kiri, aku akan pergi ke kanan. Jika kamu pergi ke sebelah kanan, aku akan pergi ke kiri.” ");
INSERT INTO indayt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lalu, Lot mengarahkan matanya dan melihat seluruh Lembah Yordan, yang terairi dengan baik di mana-mana seperti taman TUHAN, seperti tanah Mesir ke arah Zoar. Keadaan itu adalah sebelum TUHAN membinasakan Sodom dan Gomora. ");
INSERT INTO indayt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jadi, Lot memilih bagi dirinya sendiri seluruh Lembah Yordan dan Lot menempuh perjalanan ke timur. Demikianlah keduanya berpisah satu sama lain. ");
INSERT INTO indayt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram menetap di tanah Kanaan, sedangkan Lot menetap di antara kota-kota di lembah itu dan memindahkan tendanya sampai ke Sodom. ");
INSERT INTO indayt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Namun, orang Sodom itu jahat dan sangat berdosa terhadap TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","TUHAN berkata kepada Abram setelah Lot berpisah darinya, “Angkatlah matamu, dan dari tempatmu berdiri ini, pandanglah ke arah utara dan selatan, serta ke timur dan ke barat, ");
INSERT INTO indayt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","sebab seluruh tanah yang kaulihat itu akan Aku berikan kepadamu dan kepada keturunanmu untuk selamanya. ");
INSERT INTO indayt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aku akan menjadikan keturunanmu seperti debu tanah sehingga jika ada orang yang dapat menghitung jumlah debu tanah, keturunanmu pun akan dapat dihitung. ");
INSERT INTO indayt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bangunlah, jelajahi tanah itu menurut panjang dan lebarnya sebab Aku akan memberikannya kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Setelah itu, Abram memindahkan tendanya dan tinggal di dekat pohon-pohon tarbantin Mamre, di Hebron. Di sana, dia membangun mazbah bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pada masa Amrafel, raja Sinear; Ariokh, raja Elasar; Kedorlaomer, raja Elam; dan Tideal, raja Goyim; ");
INSERT INTO indayt_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","mereka mengadakan perang terhadap Bera, raja Sodom; Birsya, raja Gomora; Syinab, raja Adma; Syemeber, raja Zeboim; dan, Zoar, raja Bela. ");
INSERT INTO indayt_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mereka semua bersekutu di Lembah Sidim, yaitu Laut Asin. ");
INSERT INTO indayt_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Selama dua belas tahun mereka melayani Kedorlaomer, tetapi pada tahun ketiga belas mereka memberontak. ");
INSERT INTO indayt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pada tahun keempat belas, datanglah Kedorlaomer bersama raja-raja yang menyertainya dan mengalahkan orang Refaim di Asyterot-Karnaim, orang Zuzim di Ham, orang Emim di Syawe-Kiryataim, ");
INSERT INTO indayt_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","dan orang Hori yang tinggal di pegunungan mereka, Seir, sampai ke El-Paran di pinggir padang belantara. ");
INSERT INTO indayt_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Setelah itu, mereka kembali dan tiba di En-Mispat, yaitu Kadesh, dan menaklukkan seluruh wilayah milik orang Amalek serta orang Amori yang tinggal di Hazezon-Tamar. ");
INSERT INTO indayt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Lalu, keluarlah Raja Sodom, Raja Gomora, Raja Adma, Raja Zeboim, dan Raja Bela, yaitu Zoar, dan mengatur pertempuran terhadap mereka di Lembah Sidim, ");
INSERT INTO indayt_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","yaitu terhadap Kedorlaomer, raja Elam; Tideal, raja Goyim; Amrafel, raja Sinear; dan Ariokh, raja Elasar. Empat raja melawan lima raja. ");
INSERT INTO indayt_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Lembah Sidim penuh dengan sumur aspal, dan ketika Raja Sodom dan Raja Gomora melarikan diri, beberapa orang terjatuh ke dalam lubang-lubang tersebut, tetapi mereka yang selamat melarikan diri ke pegunungan. ");
INSERT INTO indayt_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Jadi, mereka pun menjarah seluruh barang serta makanan milik orang Sodom dan Gomora, kemudian pergi. ");
INSERT INTO indayt_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Mereka juga menawan Lot, anak dari saudara Abram, dan segala kepunyaannya sebab dia tinggal di Sodom. Setelah itu, mereka pergi. ");
INSERT INTO indayt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kemudian, seseorang yang berhasil melarikan diri datang dan menceritakannya kepada Abram, orang Ibrani itu, yang tinggal di antara pohon-pohon tarbantin milik Mamre, orang Amori, saudara Eskol dan saudara Aner, dan mereka itu bersekutu dengan Abram. ");
INSERT INTO indayt_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ketika Abram mengetahui bahwa saudaranya telah ditawan, dia mengerahkan orang-orangnya yang terlatih, yang lahir di rumahnya, sebanyak 318 orang, dan mengejar mereka sampai ke Dan. ");
INSERT INTO indayt_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Dia membagi pasukannya, yaitu dia dan pelayan-pelayannya, untuk melawan mereka pada waktu malam, lalu memukul mereka, dan mengejar mereka sampai ke Hoba di sebelah utara Damsyik. ");
INSERT INTO indayt_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram membawa kembali segala barang, dan juga membawa kembali saudaranya, Lot, dan barang-barangnya, dan juga para perempuan, dan orang-orang yang lain. ");
INSERT INTO indayt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kemudian, Raja Sodom keluar untuk menemuinya di Lembah Syawe, yaitu lembah raja, sekembalinya dia dari mengalahkan Kedorlaomer dan raja-raja yang bersamanya. ");
INSERT INTO indayt_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kemudian, Melkisedek, raja Salem, membawa roti dan anggur. Dia adalah imam Allah Yang Mahatinggi. ");
INSERT INTO indayt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Dia memberkati Abram dan berkata, “Diberkatilah Abram dari Allah Yang Mahatinggi, Sang Pemilik langit dan bumi. ");
INSERT INTO indayt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Terpujilah Allah Yang Mahatinggi, yang telah menyerahkan musuh-musuhmu ke dalam tanganmu.” Kemudian, Abram menyerahkan sepersepuluh dari segala sesuatunya kepada Melkisedek. ");
INSERT INTO indayt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kemudian, Raja Sodom berkata kepada Abram, “Berikanlah kepadaku orang-orang itu, tetapi ambillah barang-barang itu untuk dirimu sendiri.” ");
INSERT INTO indayt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Akan tetapi, Abram berkata kepada Raja Sodom, “Aku telah mengangkat tanganku kepada TUHAN, Allah Yang Mahatinggi, Sang Pemilik langit dan bumi ");
INSERT INTO indayt_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","bahwa aku tidak akan mengambil segala sesuatu yang menjadi milikmu, bahkan sehelai benang atau tali sandal sekalipun supaya kamu jangan berkata, ‘Aku telah menjadikan Abram kaya.’ ");
INSERT INTO indayt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Aku tidak akan mengambil apa pun, kecuali yang sudah dimakan oleh orang-orang muda ini dan bagian orang-orang yang turut bersamaku, yaitu Aner, Eskol, dan Mamre, biarlah mereka mengambil bagian mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Setelah semua ini, firman TUHAN datang kepada Abram dalam suatu penglihatan, firman-Nya, “Jangan takut, Abram, Akulah perisaimu, pahalamu akan sangat besar.” ");
INSERT INTO indayt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Lalu, Abram berkata, “Ya, Tuhan ALLAH, apakah yang akan Engkau berikan kepadaku sebab aku tidak punya anak dan ahli waris rumahku adalah Eliezer, orang Damsyik itu?” ");
INSERT INTO indayt_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kata Abram lagi, “Lihatlah, karena Engkau tidak memberikan keturunan kepadaku, sesungguhnya orang yang lahir di rumahku adalah ahli warisku.” ");
INSERT INTO indayt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Namun, lihatlah, firman TUHAN datang kepadanya, kata-Nya, “Orang itu tidak akan menjadi ahli warismu, melainkan dia yang keluar dari tubuhmu sendirilah yang akan menjadi ahli warismu.” ");
INSERT INTO indayt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kemudian, TUHAN membawa Abram ke luar dan berfirman, “Pandanglah langit dan hitunglah bintang-bintang kalau kau dapat menghitungnya.” Dia pun berfirman lagi kepada Abram, “Seperti itulah keturunanmu nanti.” ");
INSERT INTO indayt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram percaya kepada TUHAN, dan Dia memperhitungkan hal itu kepadanya sebagai kebenaran. ");
INSERT INTO indayt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kemudian, Dia berkata kepada Abram, “Akulah TUHAN yang membawamu keluar dari Ur-Kasdim untuk memberikan negeri ini menjadi milikmu.” ");
INSERT INTO indayt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Namun, Abram berkata, “Ya, Tuhan ALLAH, bagaimana aku tahu kalau aku akan memilikinya?” ");
INSERT INTO indayt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","TUHAN berfirman kepada Abram, “Bawalah kepada-Ku seekor sapi betina yang berumur 3 tahun, seekor kambing betina yang berumur 3 tahun, seekor domba jantan yang berumur 3 tahun, seekor burung tekukur, dan seekor merpati muda.” ");
INSERT INTO indayt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kemudian, Abram mengambil semua itu untuk-Nya, dan membelahnya menjadi dua, dan meletakkan belahan-belahan itu berhadapan satu sama lain. Namun, dia tidak membelah burung-burung itu. ");
INSERT INTO indayt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ketika burung-burung pemangsa mendekati daging-daging itu, Abram menghalau mereka. ");
INSERT INTO indayt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ketika matahari mulai terbenam, Abram tertidur lelap. Lihatlah, kegelapan yang mengerikan dan dahsyat meliputinya. ");
INSERT INTO indayt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tuhan berfirman kepada Abram, “Ketahuilah dengan sungguh-sungguh bahwa keturunanmu akan menjadi orang asing di negeri yang bukan milik mereka. Di sana, mereka akan diperbudak dan ditindas selama 400 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Namun, Aku akan menghukum bangsa yang memperbudak mereka. Setelah itu, mereka akan keluar dari tanah itu dengan membawa banyak harta. ");
INSERT INTO indayt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Lalu, kamu sendiri akan pergi kepada nenek moyangmu dalam damai dan dikuburkan pada masa tuamu. ");
INSERT INTO indayt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Keturunanmu yang keempat akan kembali ke tempat ini sebab kejahatan orang Amori belum genap.” ");
INSERT INTO indayt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Setelah matahari terbenam dan hari sangat gelap, lihat, perapian yang berasap dan obor yang menyala-nyala berjalan di antara potongan-potongan daging itu. ");
INSERT INTO indayt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Pada hari itu, TUHAN membuat suatu perjanjian dengan Abram, firman-Nya: “Aku akan memberikan tanah ini kepada keturunanmu, dari sungai Mesir sampai ke sungai besar, yaitu Sungai Efrat, ");
INSERT INTO indayt_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","yaitu tanah orang Keni, orang Kenas, orang Kadmon, ");
INSERT INTO indayt_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","orang Het, orang Feris, orang Refaim, ");
INSERT INTO indayt_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","orang Amori, orang Kanaan, orang Girgasi, dan orang Yebus.” ");
INSERT INTO indayt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Pada saat itu, Sarai, istri Abram, tidak mempunyai anak. Sarai mempunyai hamba perempuan dari Mesir bernama Hagar. ");
INSERT INTO indayt_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lalu, Sarai berkata kepada Abram, “Lihatlah, TUHAN mencegahku melahirkan anak. Karena itu, aku mohon kepadamu, bersetubuhlah dengan hambaku, mungkin aku dapat memiliki anak melaluinya.” Abram pun mendengarkan suara Sarai. ");
INSERT INTO indayt_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Jadi, setelah sepuluh tahun lamanya Abram tinggal di tanah Kanaan, Sarai, istri Abram mengambil Hagar, hambanya, orang Mesir itu, dan memberikannya kepada Abram, suaminya, untuk menjadi istrinya. ");
INSERT INTO indayt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Lalu, Abram bersetubuh dengan Hagar sehingga perempuan itu mengandung. Ketika Hagar tahu bahwa dia mengandung, dia pun memandang rendah nyonyanya itu. ");
INSERT INTO indayt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai berkata kepada Abram, “Kiranya penghinaan yang kuterima ini menjadi tanggung jawabmu! Aku telah memberikan hambaku ke dalam pelukanmu, tetapi ketika dia tahu bahwa dia mengandung, dia memandang rendah aku. Kiranya TUHAN menjadi hakim antara aku dan engkau!” ");
INSERT INTO indayt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Akan tetapi, Abram berkata kepada Sarai, “Lihatlah, hambamu itu ada dalam kuasamu. Karena itu, perlakukanlah dia menurut yang kaupandang baik.” Lalu, Sarai memperlakukan Hagar dengan kasar sehingga dia melarikan diri. ");
INSERT INTO indayt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaikat TUHAN menemukan Hagar di dekat mata air di padang belantara. Mata air itu berada di dekat jalan menuju Syur. ");
INSERT INTO indayt_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kata Malaikat itu, “Hagar, hamba Sarai, dari manakah kamu dan ke mana kamu akan pergi?” Jawab Hagar, “Aku melarikan diri dari Sarai, nyonyaku.” ");
INSERT INTO indayt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kemudian, Malaikat TUHAN berkata kepadanya, “Kembalilah kepada nyonyamu dan tunduklah di bawah otoritasnya.” ");
INSERT INTO indayt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Malaikat TUHAN itu juga berkata, “Aku akan melipatgandakan keturunanmu sehingga jumlahnya akan menjadi terlalu banyak untuk dihitung.” ");
INSERT INTO indayt_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Lalu, Malaikat TUHAN itu berkata lagi kepadanya, “Dengar, kamu sedang mengandung dan akan melahirkan anak laki-laki. Kamu akan menamainya Ismael sebab TUHAN telah mendengar tentang penderitaanmu. ");
INSERT INTO indayt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Dia akan menjadi manusia yang seperti keledai liar. Tangannya akan melawan setiap orang, dan tangan setiap orang akan melawannya. Dia akan tinggal berseberangan dengan semua saudaranya.” ");
INSERT INTO indayt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Lalu, Hagar memanggil nama TUHAN yang berbicara kepadanya itu dengan sebutan, “Engkaulah El-Roi!” sebab katanya, “Sungguhkah di sini aku telah melihat Dia yang telah melihat aku?” ");
INSERT INTO indayt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Itulah sebabnya, mata air itu dinamakan sumur Lahai-Roi, yang terletak di antara Kadesh dan Bered. ");
INSERT INTO indayt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kemudian, Hagar melahirkan anak laki-laki bagi Abram, dan Abram menamai anak itu Ismael. ");
INSERT INTO indayt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram berumur 86 tahun ketika Hagar melahirkan Ismael baginya. ");
INSERT INTO indayt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ketika Abram berumur 99 tahun, TUHAN menampakkan diri kepada Abram dan berkata kepadanya, “Akulah Allah Yang Mahakuasa, hiduplah di hadapan-Ku tanpa cela. ");
INSERT INTO indayt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Aku akan mengadakan perjanjian antara Aku dan kamu, dan Aku akan melipatgandakanmu menjadi sangat banyak.” ");
INSERT INTO indayt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lalu, Abram tersungkur dengan wajahnya dan Allah berfirman kepadanya, ");
INSERT INTO indayt_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Dari pihak-Ku, lihatlah, perjanjian-Ku adalah denganmu: kamu akan menjadi bapak dari banyak bangsa. ");
INSERT INTO indayt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kamu juga tidak akan disebut Abram lagi, melainkan Abraham karena Aku telah menjadikanmu bapak dari banyak bangsa. ");
INSERT INTO indayt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aku akan membuat keturunanmu sangat banyak, Aku akan menjadikanmu bangsa-bangsa, dan raja-raja akan muncul darimu. ");
INSERT INTO indayt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Aku akan meneguhkan perjanjian antara Aku dan kamu, dan keturunan-keturunan sesudahmu dalam generasi mereka, untuk suatu perjanjian yang kekal, yaitu Aku akan menjadi Allah bagimu dan bagi keturunan-keturunan sesudahmu. ");
INSERT INTO indayt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Aku akan memberikan kepadamu dan kepada keturunan-keturunan sesudahmu, negeri yang kamu tinggali sementara ini, yaitu seluruh tanah Kanaan, sebagai milikmu selama-lamanya, dan Aku akan menjadi Allah mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Lalu, Allah berkata kepada Abraham, “Untukmu, kamu harus memegang teguh perjanjian-Ku, kamu dan keturunan-keturunan sesudahmu dalam generasi mereka. ");
INSERT INTO indayt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Inilah perjanjian-Ku yang harus kamu pegang teguh, antara Aku, dan kamu, dan keturunan-keturunan sesudahmu, yaitu setiap anak laki-laki di antara kamu harus disunat. ");
INSERT INTO indayt_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kamu harus memotong kulit khitanmu, dan itu akan menjadi tanda perjanjian antara Aku dan kamu. ");
INSERT INTO indayt_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Setiap bayi laki-laki yang berumur 8 hari dalam keturunanmu juga harus disunat, baik yang lahir di rumahmu ataupun yang kamu beli dari orang asing, yaitu mereka yang tidak termasuk dalam keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Jadi, baik yang lahir di rumahmu maupun yang dibeli dengan uangmu, mereka harus disunat. Dengan begitu, perjanjian-Ku ada dalam dagingmu sebagai perjanjian yang kekal. ");
INSERT INTO indayt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Namun, laki-laki yang tidak disunat, yaitu yang kulit khatannya tidak dipotong, dia harus disingkirkan dari bangsanya sebab dia telah mengingkari perjanjian-Ku.” ");
INSERT INTO indayt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kemudian, Allah berfirman kepada Abraham, “Mengenai istrimu, Sarai, kamu tidak akan memanggilnya Sarai lagi, melainkan Sara, itulah namanya. ");
INSERT INTO indayt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aku akan memberkatinya dan akan memberikan anak laki-laki kepadamu melalui dia. Aku akan memberkatinya sehingga dia akan menjadi ibu dari bangsa-bangsa dan raja-raja banyak bangsa akan berasal darinya.” ");
INSERT INTO indayt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Lalu, Abraham tersungkur dengan mukanya sampai menyentuh tanah, dan tertawa sambil berkata dalam hatinya, “Mungkinkah seorang anak dilahirkan bagi dia yang berumur 100 tahun? Mungkinkah Sara, yang berumur 90 tahun, melahirkan anak?” ");
INSERT INTO indayt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Lalu, berkatalah Abraham kepada Allah, “Oh, biarlah Ismael diperkenankan hidup di hadapan-Mu.” ");
INSERT INTO indayt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Akan tetapi, Allah berfirman, “Sungguh! Sara, istrimu, akan melahirkan anak laki-laki bagimu dan kamu akan menamainya Ishak. Aku akan meneguhkan perjanjian-Ku dengannya sebagai perjanjian kekal yang akan berlaku sampai kepada keturunan-keturunannya setelah dia. ");
INSERT INTO indayt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mengenai Ismael, Aku telah mendengarkanmu. Lihatlah, Aku telah memberkatinya, membuatnya beranak cucu, dan akan melipatgandakannya menjadi sangat banyak. Darinya akan lahir dua belas raja dan Aku akan menjadikannya bangsa yang besar. ");
INSERT INTO indayt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Namun, Aku akan meneguhkan perjanjian-Ku dengan Ishak, yang akan dilahirkan Sara bagimu, pada waktu seperti ini, tahun depan.” ");
INSERT INTO indayt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Setelah selesai berfirman kepada Abraham, pergilah Allah dari Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kemudian, Abraham mengambil Ismael, anaknya, dan semua yang lahir di rumahnya, dan semua yang dibelinya dengan uang, semua laki-laki di rumah Abraham, dan dia menyunat mereka pada hari itu juga, sesuai dengan yang difirmankan Allah kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham berumur 99 tahun ketika dia disunat, ");
INSERT INTO indayt_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","dan Ismael, anak laki-lakinya, berumur 13 tahun ketika disunat. ");
INSERT INTO indayt_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham dan anak laki-lakinya disunat pada hari yang sama. ");
INSERT INTO indayt_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Semua laki-laki yang berada di rumah Abraham, baik yang lahir di dalam rumahnya maupun yang dibelinya dari orang asing, disunat juga bersama-sama dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","TUHAN menampakkan diri kepada Abraham di dekat pohon-pohon tarbantin Mamre, ketika dia duduk di pintu tendanya, pada suatu hari yang panas terik. ");
INSERT INTO indayt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham mengarahkan matanya dan melihat, tampak ada tiga orang yang berdiri di depannya. Ketika dia melihat mereka, dia berlari dari pintu tendanya untuk menyambut mereka, lalu dia membungkukkan dirinya ke tanah, ");
INSERT INTO indayt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","dan berkata, “Tuanku, jika pada saat ini aku mendapat perkenanan di matamu, janganlah berlalu dari hambamu ini begitu saja. ");
INSERT INTO indayt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Aku mohon kepadamu, biarlah diambil sedikit air dan cucilah kakimu, lalu beristirahatlah di bawah pohon ini. ");
INSERT INTO indayt_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Aku akan mengambil sepotong roti dan akan menyegarkan hatimu. Setelah itu, Tuan-tuan dapat berlalu sebab Tuan-tuan telah singgah kepada hambamu ini.” Mereka berkata, “Jadi, lakukanlah seperti yang telah kaukatakan itu.” ");
INSERT INTO indayt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham cepat-cepat masuk ke dalam tenda, kepada Sara, dan berkata, “Cepat! Ambillah 3 sukat tepung yang baik, remaslah, dan buatlah roti-roti bundar.” ");
INSERT INTO indayt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kemudian, Abraham berlari menuju kawanan sapinya dan mengambil seekor anak sapi yang empuk dan baik, lalu dia menyerahkannya kepada seorang muda, dan orang itu segera mengolahnya. ");
INSERT INTO indayt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Lalu, dia mengambil dadih dan susu, serta sapi yang sudah diolah itu, kemudian dia meletakkannya di hadapan ketiga orang itu. Dia berdiri di dekat mereka di bawah pohon, lalu mereka pun makan. ");
INSERT INTO indayt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Setelah itu, mereka berkata kepadanya, “Di mana Sara, istrimu?” Dia berkata, “Di sana, di dalam tenda.” ");
INSERT INTO indayt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Lalu, Dia berkata, “Kelak, Aku pasti kembali lagi kepadamu. Lihatlah, Sara, istrimu, akan mempunyai seorang anak laki-laki.” Sara mendengarnya dari pintu tenda, di belakang orang itu. ");
INSERT INTO indayt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham dan Sara sudah tua, mereka telah lanjut umur, Sara pun sudah tidak haid. ");
INSERT INTO indayt_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Jadi, Sara tertawa dalam hatinya dan berkata, “Setelah aku begini tua, apakah aku akan berahi, sementara suamiku juga sudah tua?” ");
INSERT INTO indayt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Lalu, TUHAN berkata kepada Abraham, “Mengapa Sara tertawa dan berkata, ‘Apakah aku benar-benar akan melahirkan anak padahal aku sudah tua?’ ");
INSERT INTO indayt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Adakah sesuatu yang mustahil bagi TUHAN? Pada waktu yang telah ditetapkan, Aku akan kembali kepadamu, dan pada waktu itu Sara akan mempunyai anak laki-laki.” ");
INSERT INTO indayt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Akan tetapi, Sara menyangkalnya dan berkata, “Aku tidak tertawa,” karena dia takut. Namun, Dia berkata, “Tidak! Kamu memang tertawa!” ");
INSERT INTO indayt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kemudian, orang-orang itu bangun dari situ dan mereka memandang ke arah Sodom, dan Abraham berjalan bersama mereka untuk mengantar mereka. ");
INSERT INTO indayt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","TUHAN berkata, “Apakah Aku harus merahasiakan kepada Abraham tentang apa yang akan Aku lakukan, ");
INSERT INTO indayt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","sedangkan Abraham pasti akan menjadi bangsa yang besar dan berkuasa, dan melaluinya seluruh bangsa di bumi akan diberkati? ");
INSERT INTO indayt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Sebab Aku telah mengenalnya, dia akan memerintahkan kepada anak-anaknya dan seisi rumahnya sesudah dia untuk hidup sesuai jalan TUHAN dengan melakukan kebenaran dan keadilan sehingga TUHAN akan memberikan kepada Abraham apa yang telah dijanjikan-Nya kepadanya.” ");
INSERT INTO indayt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kemudian TUHAN berkata, “Karena teriakan tentang Sodom dan Gomora sangat keras, dan karena dosa mereka terlampau berat, ");
INSERT INTO indayt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Aku akan turun sekarang untuk melihat apakah mereka benar-benar telah melakukan semua itu sesuai dengan teriakan yang sampai kepada-Ku? Jika tidak, Aku akan mengetahuinya.” ");
INSERT INTO indayt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kemudian, orang-orang itu berbalik dari sana dan berangkat menuju Sodom, tetapi Abraham masih berdiri di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Lalu, Abraham mendekat dan bertanya, “Apakah Engkau benar-benar akan membinasakan orang-orang benar bersama-sama dengan orang jahat? ");
INSERT INTO indayt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Seandainya ada lima puluh orang benar di kota itu, apakah Engkau akan benar-benar membinasakan dan tidak menyayangkan kota itu demi lima puluh orang benar di dalamnya? ");
INSERT INTO indayt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kiranya, jauh dari-Mu untuk melakukan hal itu, membinasakan lima puluh orang benar bersama-sama dengan orang jahat. Kiranya hal itu jauh dari-Mu! Bukankah Hakim Semesta Bumi akan berlaku adil?” ");
INSERT INTO indayt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","TUHAN berkata, “Jika Aku mendapati lima puluh orang benar di kota Sodom, Aku akan menyayangkan seluruh tempat itu demi mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Lalu, Abraham menjawab dan berkata, “Lihatlah, aku telah berbicara kepada Tuhan meskipun aku hanya debu dan abu; ");
INSERT INTO indayt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","seandainya kurang lima saja dari lima puluh orang benar di kota itu, apakah Engkau akan membinasakan seluruh kota karena lima orang itu?” Tuhan berkata, “Aku tidak akan membinasakan kota itu, jika Aku mendapati empat puluh lima orang benar di sana.” ");
INSERT INTO indayt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham berbicara lagi kepada-Nya, katanya, “Seandainya hanya ada empat puluh orang benar yang didapati di sana?” TUHAN berkata lagi, “Aku tidak akan membinasakan kota itu demi empat puluh orang benar itu.” ");
INSERT INTO indayt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kemudian, Abraham berkata, “Oh, janganlah kiranya Tuhan murka, maka aku akan berbicara. Seandainya hanya ada tiga puluh orang yang didapati di sana?” Tuhan berkata, “Aku tidak akan membinasakan kota itu, jika Aku mendapati tiga puluh orang benar di sana.” ");
INSERT INTO indayt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham berkata lagi, “Aku memberanikan diri berbicara kepada Tuhan, bagaimana jika hanya ada dua puluh orang benar yang didapati di sana?” Tuhan menjawab, “Demi dua puluh orang benar itu, Aku tidak akan membinasakan kota itu.” ");
INSERT INTO indayt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Akhirnya Abraham berkata, “Kiranya Tuhan jangan murka terhadapku, maka aku akan berbicara sekali lagi. Seandainya hanya ada sepuluh orang benar yang didapati di sana?” Jawab-Nya, “Aku tidak akan membinasakannya demi sepuluh orang itu.” ");
INSERT INTO indayt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Lalu, TUHAN pergi setelah Dia selesai berfirman kepada Abraham. Abraham pun kembali ke tempatnya. ");
INSERT INTO indayt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kedua malaikat itu tiba di Sodom pada sore hari dan Lot sedang duduk di dekat pintu gerbang Sodom. Ketika Lot melihat mereka, dia berdiri untuk menyambut mereka, lalu dia berlutut sampai mukanya ke tanah. ");
INSERT INTO indayt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Lot berkata, “Tuan-tuan, mohon singgahlah di rumah hambamu ini dan menginaplah, cucilah kakimu, dan Tuan-tuan dapat bangun pagi-pagi untuk melanjutkan perjalanan.” Akan tetapi, mereka berkata, “Tidak, kami akan bermalam di alun-alun kota.” ");
INSERT INTO indayt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Namun, dia terus mendesak mereka sehingga mereka pun singgah kepadanya dan masuk ke dalam rumahnya. Kemudian, dia menyiapkan makanan bagi mereka dan memanggang roti tak beragi, lalu mereka pun makan. ");
INSERT INTO indayt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Namun, sebelum mereka berbaring, para laki-laki dari kota itu, yaitu laki-laki Sodom, mengepung rumah itu, baik yang tua maupun yang muda, semua orang tanpa terkecuali. ");
INSERT INTO indayt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mereka memanggil Lot dan berkata kepadanya, “Di manakah kedua orang yang datang kepadamu malam ini? Bawa mereka keluar kepada kami supaya kami dapat bersetubuh dengan mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lalu, Lot keluar menemui mereka dan menutup pintu di belakangnya, ");
INSERT INTO indayt_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","dan berkata, “Aku mohon, Saudara-saudaraku, janganlah berbuat jahat. ");
INSERT INTO indayt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Lihatlah, aku mempunyai dua anak perempuan yang belum pernah bersetubuh dengan laki-laki. Aku mohon, biarlah aku membawa mereka kepadamu dan perlakukanlah mereka menurut apa yang kamu pandang baik, asal jangan lakukan apa pun terhadap orang-orang ini sebab mereka datang untuk berlindung di bawah atap rumahku.” ");
INSERT INTO indayt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Akan tetapi, orang-orang itu berkata, “Mundur!” Mereka berkata lagi, “Orang ini datang ke sini untuk menumpang tinggal dan dia berlagak seperti hakim! Sekarang, kami akan berbuat lebih jahat terhadapmu daripada terhadap mereka!” Karena itu, mereka terus mendorong orang itu dengan kasar, yaitu Lot, dan mendekat untuk mendobrak pintu. ");
INSERT INTO indayt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Namun, kedua orang itu mengulurkan tangannya, dan menarik Lot ke dalam rumah, lalu menutup pintu. ");
INSERT INTO indayt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Setelah itu, mereka memukul orang-orang yang berada di depan pintu itu dengan kebutaan, dari yang kecil sampai yang besar sehingga mereka kesulitan mencari-cari pintu itu. ");
INSERT INTO indayt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Lalu, kedua orang itu berkata kepada Lot, “Siapa lagi keluargamu yang masih ada di sini? Menantu laki-laki, anak laki-laki, anak perempuan, dan keluargamu yang lain di kota ini, bawa mereka keluar dari tempat ini, ");
INSERT INTO indayt_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","sebab kami akan membinasakan tempat ini. Teriakan mengenai kota ini begitu keras di hadapan TUHAN sehingga TUHAN mengutus kami untuk membinasakannya.” ");
INSERT INTO indayt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lalu, Lot pergi dan berbicara kepada calon-calon menantunya yang akan mengawini anak-anak perempuannya, katanya, “Ayo, tinggalkan kota ini karena TUHAN akan segera membinasakannya!” Namun, bagi kedua calon menantunya itu, dia tampak seperti orang yang sedang bercanda. ");
INSERT INTO indayt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pada waktu fajar, malaikat-malaikat itu mendesak Lot, katanya, “Bangun! Bawa istri dan kedua anak perempuanmu yang ada di sini, atau kamu juga akan dibinasakan dalam penghukuman kota ini!” ");
INSERT INTO indayt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Akan tetapi, Lot berlambat-lambat sehingga kedua orang itu menarik tangan Lot dan tangan istrinya, juga tangan kedua anaknya sebab TUHAN berbelaskasihan kepadanya. Mereka membawa Lot sampai di luar kota itu. ");
INSERT INTO indayt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ketika mereka sudah membawa Lot dan keluarganya ke luar kota, salah satu dari mereka berkata, “Lari! Selamatkan nyawamu! Jangan menoleh ke belakang, jangan berhenti di mana pun di lembah, dan larilah ke pegunungan, atau kamu juga akan dibinasakan!” ");
INSERT INTO indayt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Akan tetapi, Lot berkata kepada mereka, “Jangan begitu, ya, Tuanku! ");
INSERT INTO indayt_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Lihat, hambamu ini sudah mendapat belas kasihan di matamu dan engkau sudah menunjukkan kemurahan dengan menyelamatkan nyawa hamba. Namun, aku tidak sanggup melarikan diri ke pegunungan itu sehingga bisa-bisa aku akan tersusul oleh malapetaka itu, lalu mati! ");
INSERT INTO indayt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lihatlah, kota itu cukup dekat untuk dituju dan kota itu kecil. Izinkanlah hamba melarikan diri ke sana supaya nyawaku selamat. Bukankah itu kota kecil?” ");
INSERT INTO indayt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaikat itu berkata kepada Lot, “Baiklah, aku juga akan mengabulkan permintaanmu ini dan tidak akan membinasakan kota yang kamu sebutkan itu. ");
INSERT INTO indayt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Cepat pergi ke sana karena aku tidak dapat melakukan apa pun sampai kamu tiba di kota itu.” Itulah sebabnya, kota itu disebut Zoar. ");
INSERT INTO indayt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Matahari baru saja terbit ketika Lot tiba di Zoar. ");
INSERT INTO indayt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kemudian, TUHAN menghujani Sodom dan Gomora dengan belerang dan api dari langit, yaitu dari TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Dia menunggangbalikkan kota-kota itu, seluruh lembah, seluruh penduduk, dan membinasakan kedua kota itu dan seluruh wilayahnya, termasuk semua penduduk, dan apa pun yang tumbuh di atas tanah. ");
INSERT INTO indayt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Namun, istri Lot, yang berjalan mengikutinya, menoleh ke belakang dan dia menjadi tiang garam. ");
INSERT INTO indayt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Keesokan harinya, Abraham bangun pagi-pagi, lalu pergi ke tempat dia berdiri di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Dia pun melayangkan pandangannya ke arah Sodom dan Gomora serta ke arah seluruh lembah itu. Dia melihat asap yang naik dari kedua kota itu seperti asap perapian. ");
INSERT INTO indayt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Demikianlah, ketika Allah membinasakan kota-kota di lembah itu, Allah mengingat Abraham dan mengeluarkan Lot dari tengah-tengah kehancuran itu, ketika Dia menunggangbalikkan kota-kota itu, tempat Lot tinggal. ");
INSERT INTO indayt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Kemudian, Lot pergi dari Zoar dan tinggal di suatu gua, di pegunungan, bersama kedua anak perempuannya sebab dia takut tinggal di Zoar. ");
INSERT INTO indayt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pada suatu ketika, anak sulungnya berkata kepada adiknya, “Ayah kita sudah tua dan tidak ada satu laki-laki pun di bumi ini yang datang kepada kita seperti tradisi di seluruh bumi. ");
INSERT INTO indayt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jadi, marilah kita memberikan minuman anggur kepada ayah kita, lalu bersetubuh dengannya supaya kita dapat meneruskan keturunan melalui ayah kita.” ");
INSERT INTO indayt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Malam itu, mereka pun membuat ayah mereka minum anggur, lalu anak yang sulung masuk dan bersetubuh dengan ayahnya. Lot bahkan tidak tahu ketika anaknya itu bersetubuh dengannya dan ketika anaknya itu pergi. ");
INSERT INTO indayt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Hari berikutnya, anak yang sulung berkata kepada adiknya, “Semalam, aku bersetubuh dengan ayah, mari kita juga membuatnya minum anggur malam ini supaya kamu juga dapat masuk dan bersetubuh dengannya. Dengan demikian, kita dapat meneruskan keturunan melalui ayah kita.” ");
INSERT INTO indayt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Jadi, mereka pun membuat ayahnya mabuk lagi pada malam itu. Lalu, anak yang lebih muda masuk dan bersetubuh dengannya. Sekali lagi, Lot tidak tahu ketika anaknya itu bersetubuh dengannya dan ketika anaknya itu pergi. ");
INSERT INTO indayt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kemudian, kedua anak perempuan Lot itu mengandung oleh ayah mereka. ");
INSERT INTO indayt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Anak yang sulung melahirkan seorang anak laki-laki dan menamainya Moab. Moab adalah nenek moyang semua orang Moab yang ada sekarang. ");
INSERT INTO indayt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Anak yang lebih muda juga melahirkan seorang anak laki-laki dan menamainya Ben-Ami. Ben-Ami adalah nenek moyang semua orang Amon yang ada sekarang ini. ");
INSERT INTO indayt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Dari tempat itu, Abraham berjalan menuju ke selatan dan tinggal di antara Kadesh dan Syur. Kemudian, dia tinggal sementara di Gerar. ");
INSERT INTO indayt_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham berkata tentang Sara, istrinya, “Dia adalah adikku,” sehingga Abimelekh, raja Gerar, menyuruh orang untuk mengambil Sara. ");
INSERT INTO indayt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Akan tetapi, pada suatu malam, Allah berkata kepada Abimelekh dalam mimpi, firman-Nya, “Kamu akan mati sebab perempuan yang kauambil itu adalah istri orang lain.” ");
INSERT INTO indayt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Namun, Abimelekh belum mendekati Sara dan dia berkata, “Tuhan, apakah Engkau akan membunuh bangsa yang tidak bersalah? ");
INSERT INTO indayt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Bukankah dia sendiri yang berkata kepadaku, ‘Perempuan ini adalah adikku,’? Lalu, bukankah perempuan itu juga berkata, ‘Laki-laki ini adalah kakakku,’? Aku melakukan ini dalam ketulusan hatiku dan ketidakbersalahan tanganku.” ");
INSERT INTO indayt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kemudian, Allah berfirman kepadanya dalam mimpi, “Ya, Aku tahu bahwa kamu melakukan hal ini dalam ketulusan hatimu. Aku yang mencegahmu berbuat dosa terhadap Aku. Karena itu, Aku tidak membiarkanmu menyentuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Sekarang, kembalikanlah istri orang itu karena dia adalah seorang nabi. Dia akan berdoa untukmu supaya kamu akan hidup. Namun, jika kamu tidak mengembalikan istrinya kepadanya, ketahuilah bahwa kamu dan semua yang bersama denganmu pasti akan mati.” ");
INSERT INTO indayt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Jadi, pagi-pagi sekali, Abimelekh memanggil semua hambanya dan menceritakan tentang semua hal ini di telinga mereka sehingga mereka semua menjadi sangat takut. ");
INSERT INTO indayt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Lalu, Abimelekh memanggil Abraham dan berkata kepadanya, “Apa yang sudah kaulakukan terhadap kami? Kesalahan apa yang telah kulakukan kepadamu sehingga kamu menimpakan dosa yang besar atas diriku dan kerajaanku? Kamu telah melakukan sesuatu yang tidak pantas terhadapku!” ");
INSERT INTO indayt_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Lalu, Abimelekh berkata lagi kepada Abraham, “Apa maksudmu sehingga kamu melakukan hal ini?” ");
INSERT INTO indayt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kata Abraham, “Pikirku, sesungguhnya rasa takut akan Allah tidak ada dalam tempat ini sehingga mereka akan membunuhku karena istriku. ");
INSERT INTO indayt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Lagi pula, dia memang adikku; dia anak ayahku, tetapi bukan anak ibuku, dan dia menjadi istriku. ");
INSERT INTO indayt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ketika Allah menyuruhku mengembara keluar dari rumah ayahku, aku berkata kepada istriku, ‘Tunjukkanlah kasihmu kepadaku dengan melakukan hal ini di setiap tempat yang kita tuju, katakanlah tentang aku: dia adalah kakakku.’” ");
INSERT INTO indayt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelekh mengambil domba, sapi, serta hamba laki-laki dan perempuan, lalu memberikannya kepada Abraham. Abimelekh juga mengembalikan Sara, istri Abraham, kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kata Abimelekh, “Lihatlah, negeriku ada di hadapanmu. Tinggallah di mana pun kamu suka.” ");
INSERT INTO indayt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelekh berkata kepada Sara, “Dengarlah, aku memberikan 1000 syikal perak kepada kakakmu sebagai bukti kesucianmu di hadapan semua orang yang bersama-sama denganmu. Di hadapan semua orang, namamu dibersihkan.” ");
INSERT INTO indayt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kemudian, Abraham berdoa kepada Allah dan Allah menyembuhkan Abimelekh, istrinya, dan hamba-hambanya perempuan sehingga mereka dapat melahirkan anak. ");
INSERT INTO indayt_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Sebelumnya, TUHAN menutup rahim semua perempuan di dalam istana Abimelekh karena Sara, istri Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TUHAN mengunjungi Sara seperti yang difirmankan-Nya, dan TUHAN melakukan kepada Sara seperti yang telah difirmankan-Nya. ");
INSERT INTO indayt_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Jadi, Sara mengandung dan melahirkan seorang anak laki-laki bagi Abraham pada masa tuanya, sesuai dengan waktu yang telah difirmankan Allah kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham menamakan anak yang lahir baginya itu Ishak, yaitu anak yang telah dilahirkan oleh Sara baginya. ");
INSERT INTO indayt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Lalu, Abraham menyunat Ishak, anak laki-lakinya itu, ketika berumur 8 hari, seperti yang diperintahkan Allah kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham berumur 100 tahun ketika Ishak lahir. ");
INSERT INTO indayt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara berkata, “Allah telah membuatku tertawa, dan setiap orang yang mendengar hal ini akan tertawa bersamaku.” ");
INSERT INTO indayt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Dia berkata lagi, “Dahulu, siapakah yang dapat mengatakan kepada Abraham bahwa Sara akan menyusui anak? Namun, aku telah melahirkan seorang anak laki-laki baginya, pada masa tuanya.” ");
INSERT INTO indayt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Anak itu bertambah besar dan mulai disapih. Abraham mengadakan suatu pesta besar pada hari Ishak disapih. ");
INSERT INTO indayt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Pada suatu waktu, Sara melihat anak Hagar, perempuan Mesir yang melahirkan bagi Abraham itu, sedang mengejek, ");
INSERT INTO indayt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara berkata kepada Abraham, “Usirlah hamba itu bersama anaknya sebab anak laki-laki dari hamba itu tidak akan menjadi ahli waris bersama dengan Ishak, anakku.” ");
INSERT INTO indayt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hal ini sangat mendukakan dalam pandangan Abraham karena Ismael juga adalah anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Namun, Allah berkata kepada Abraham, “Jangan berduka karena anak laki-laki dan karena hamba perempuanmu itu. Lakukanlah semua yang dikatakan Sara kepadamu karena dari Ishaklah yang akan disebut keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Namun, Aku juga akan menjadikan anak hamba perempuanmu suatu bangsa yang besar sebab anak itu juga adalah keturunanmu.” ");
INSERT INTO indayt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kemudian, Abraham bangun pagi-pagi sekali, lalu mengambil roti serta kantong kulit yang berisi air, dan memberikannya kepada Hagar. Dia meletakkan makanan dan air itu di pundak Hagar dan menyerahkan anak itu kepadanya, lalu menyuruh mereka pergi. Lalu, perempuan itu pergi mengembara di padang belantara Bersyeba. ");
INSERT INTO indayt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Setelah air di dalam kantong kulit itu habis, Hagar meletakkan anaknya di bawah semak belukar. ");
INSERT INTO indayt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kemudian, dia pergi dan duduk berseberangan dengan anaknya kira-kira sejauh anak panah yang dilepaskan, sebab katanya, “Jangan sampai aku melihat anak itu mati.” Selagi dia duduk berseberangan dengan anaknya, dia mulai menangis dengan suara nyaring. ");
INSERT INTO indayt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Allah mendengar suara anak itu, lalu Malaikat Allah memanggil Hagar dari surga dan berkata kepadanya, “Apa yang menyusahkanmu, Hagar? Jangan takut sebab Allah telah mendengar suara anak itu di tempatnya. ");
INSERT INTO indayt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Bangunlah! Angkat anak itu dan tegakkan dia dengan tanganmu sebab Aku akan menjadikannya suatu bangsa yang besar.” ");
INSERT INTO indayt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kemudian, Allah membuka mata Hagar sehingga dia melihat sebuah sumur. Lalu, Hagar pergi dan mengisi kantong kulit itu dengan air, dan meminumkannya kepada anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah menyertai anak itu dan dia bertambah besar. Ismael hidup di padang belantara dan menjadi pemanah. ");
INSERT INTO indayt_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Dia tinggal di padang belantara Paran dan ibunya mengambilkan istri dari tanah Mesir baginya. ");
INSERT INTO indayt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pada waktu itu, Abimelekh dan Pikhol, panglima tentara Abimelekh, berbicara kepada Abraham, “Allah menyertaimu dalam segala sesuatu yang kamu lakukan. ");
INSERT INTO indayt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jadi, bersumpahlah kepadaku di sini, di hadapan Allah, bahwa kamu tidak akan berlaku curang terhadap aku, kepada anak-anakku, atau kepada cucu cicitku. Akan tetapi, seperti kebaikan yang telah kutunjukkan kepadamu, tunjukkanlah kebaikanmu kepadaku dan kepada negeri yang kamu tumpangi ini.” ");
INSERT INTO indayt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Jawab Abraham, “Aku bersumpah!” ");
INSERT INTO indayt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Namun, Abraham mengeluh kepada Abimelekh tentang sumur air yang telah dirampas oleh hamba-hamba Abimelekh. ");
INSERT INTO indayt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelekh berkata, “Aku tidak tahu siapa yang melakukannya. Lagi pula, kamu tidak pernah mengatakannya kepadaku dan aku belum pernah mendengar tentang ini sampai hari ini.” ");
INSERT INTO indayt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham mengambil beberapa ekor domba dan sapi jantan, lalu memberikannya kepada Abimelekh. Lalu, kedua orang itu pun mengadakan perjanjian. ");
INSERT INTO indayt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Lalu, Abraham juga memisahkan tujuh ekor domba betina dari kawanannya. ");
INSERT INTO indayt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelekh bertanya kepada Abraham, “Mengapa kamu memisahkan ketujuh domba betina itu?” ");
INSERT INTO indayt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham menjawab, “Kamu akan menerima tujuh domba betina ini dari tanganku sebagai kesaksian bagiku bahwa akulah yang menggali sumur ini.” ");
INSERT INTO indayt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Itulah sebabnya, sumur itu disebut Bersyeba karena di situlah keduanya bersumpah. ");
INSERT INTO indayt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Jadi, mereka mengadakan suatu perjanjian di Bersyeba. Setelah itu, Abimelekh dan pemimpin pasukannya, Pikhol, kembali ke negeri orang Filistin. ");
INSERT INTO indayt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham menanam pohon tamariska di Bersyeba dan di situ dia menyerukan nama TUHAN, Allah yang kekal. ");
INSERT INTO indayt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Setelah itu, Abraham masih tinggal sementara di tanah orang Filistin selama beberapa waktu. ");
INSERT INTO indayt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sesudah berbagai peristiwa itu, Allah menguji Abraham dan berkata kepadanya, “Abraham!” Abraham menjawab, “Ini aku!” ");
INSERT INTO indayt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dia berfirman, “Bawalah Ishak, anakmu satu-satunya, yang kaukasihi itu, ke tanah Moria. Lalu, persembahkanlah dia di sana sebagai kurban bakaran di salah satu gunung yang akan Kutunjukkan kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Pagi-pagi sekali, bangunlah Abraham dan memelana keledainya. Dia mengajak dua dari pelayannya bersamanya dan juga Ishak, anaknya. Dia membelah kayu untuk kurban bakaran, lalu dia bersiap dan berangkat ke tempat yang telah difirmankan Allah kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pada hari yang ketiga, Abraham melayangkan pandangannya dan melihat tempat itu dari kejauhan. ");
INSERT INTO indayt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham berkata kepada kedua orang muda yang bersamanya, “Tinggallah di sini dengan keledai ini. Aku dan anak ini akan pergi ke sana untuk beribadah dan akan kembali lagi kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham mengambil kayu untuk kurban bakaran itu dan meletakkannya di bahu Ishak, anaknya, sedangkan dia membawa api dan pisau di tangannya. Keduanya pergi bersama-sama. ");
INSERT INTO indayt_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ishak berkata kepada ayahnya, “Ayahku!” Abraham menjawab, “Ya, Nak?” Ishak bertanya, “Lihat, api dan kayunya ada di sini, tetapi mana domba untuk persembahan bakarannya?” ");
INSERT INTO indayt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham menjawab, “Anakku, Allah sendiri yang akan menyediakan anak domba untuk persembahan bakaran itu bagi-Nya.” Keduanya pun terus berjalan bersama-sama. ");
INSERT INTO indayt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ketika mereka sampai di tempat yang difirmankan Allah kepada Abraham, Abraham pun membangun mazbah di sana dan mengatur kayu di atasnya. Kemudian, dia mengikat Ishak, anaknya, dan membaringkannya di atas mazbah itu, di atas kayu. ");
INSERT INTO indayt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Lalu, Abraham mengulurkan tangannya dan mengambil pisau untuk menyembelih anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Akan tetapi, Malaikat TUHAN memanggilnya dari langit dan berkata, “Abraham! Abraham!” Abraham pun menjawab, “Ini aku.” ");
INSERT INTO indayt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaikat TUHAN berkata, “Jangan ulurkan tanganmu ke atas anak itu, jangan lakukan apa pun terhadapnya, sebab sekarang Aku tahu bahwa kamu takut akan Allah dan kamu tidak menahan anakmu, anak tunggalmu itu, dari-Ku.” ");
INSERT INTO indayt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kemudian, Abraham mengangkat wajahnya dan melihat seekor domba jantan yang tanduknya tersangkut di semak belukar. Lalu, Abraham pergi untuk mengambil domba jantan itu dan mempersembahkannya sebagai kurban bakaran menggantikan anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham pun menyebut tempat itu: “TUHAN akan Menyediakan”. Sebab itu, sampai hari ini orang mengatakan, “Di gunung TUHAN hal itu akan disediakan.” ");
INSERT INTO indayt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Untuk kedua kalinya, Malaikat TUHAN memanggil Abraham dari langit, ");
INSERT INTO indayt_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","dan berkata, “Demi diri-Ku sendiri Aku bersumpah, demikianlah firman Allah, sebab kamu telah melakukan hal ini dan tidak menahan anakmu, anak tunggalmu itu, ");
INSERT INTO indayt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Aku sungguh-sungguh akan memberkatimu dan akan melipatgandakan keturunanmu sebanyak bintang di langit dan sebanyak pasir di pantai. Keturunanmu akan menduduki setiap gerbang musuh-musuh mereka, ");
INSERT INTO indayt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","dan melalui keturunanmu, semua bangsa di bumi akan diberkati karena kamu menaati perkataan-Ku.” ");
INSERT INTO indayt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Lalu, Abraham kembali kepada pelayan-pelayannya, dan mereka semua pergi bersama ke Bersyeba. Abraham pun tinggal di Bersyeba. ");
INSERT INTO indayt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Setelah semua peristiwa ini, diberitakanlah mengenai hal ini kepada Abraham, “Ketahuilah, Milka juga telah menjadi ibu. Dia telah melahirkan anak-anak laki-laki bagi Nahor, saudaramu. ");
INSERT INTO indayt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Anaknya yang sulung adalah Us, kemudian Bus, adiknya, dan Kemuel, nenek moyang orang Aram. ");
INSERT INTO indayt_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kemudian, Kesed, Hazo, Pildash, Yidlaf, dan Betuel.” ");
INSERT INTO indayt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel adalah ayah dari Ribka. Milka melahirkan delapan anak bagi Nahor, saudara laki-laki Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Gundik Nahor yang bernama Reuma juga melahirkan anak laki-laki, yaitu Tebah, Gaham, Tahash, dan Maakha. ");
INSERT INTO indayt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara hidup selama 127 tahun, itulah tahun-tahun masa hidup Sara. ");
INSERT INTO indayt_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Dia mati di Kiryat-Arba, yaitu Hebron, di tanah Kanaan. Lalu, Abraham datang untuk meratapi Sara dan menangisinya di sana. ");
INSERT INTO indayt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kemudian, Abraham bangkit dari hadapan jenazah itu, dan berbicara kepada keturunan Het, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Aku adalah orang asing dan orang yang tinggal sementara di tengah-tengah kamu; berilah tempat bagiku di tengah-tengah kamu supaya aku dapat menguburkan orang matiku ini dari hadapanku.” ");
INSERT INTO indayt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Keturunan Het menjawab Abraham, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Dengarlah kami, ya Tuan, engkau adalah seorang pemimpin besar di tengah-tengah kami. Kuburkanlah jenazah istrimu itu di pekuburan terpilih di tempat kami. Tidak ada satu pun dari kami yang akan menolakmu dari pekuburannya supaya engkau dapat menguburkan orang matimu.” ");
INSERT INTO indayt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham berdiri, lalu berlutut kepada penduduk tanah itu, yaitu keturunan Het. ");
INSERT INTO indayt_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Dia berkata kepada mereka, “Jika kamu telah menyetujui agar aku dapat menguburkan orang matiku dari hadapanku ini, dengarkanlah aku dan temuilah Efron keturunan Zohar itu demi aku, ");
INSERT INTO indayt_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","supaya dia memberikan kepadaku Gua Makhpela, yang adalah miliknya, yang terletak di ujung ladangnya. Biarlah dia memberikannya kepadaku dengan harga penuh sebagai tempat pekuburan di tengah-tengah kamu.” ");
INSERT INTO indayt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Pada waktu itu, Efron sedang duduk di tengah-tengah keturunan Het itu. Lalu, Efron, orang Het itu menjawab Abraham dan didengar oleh para keturunan Het itu, yaitu semua orang yang datang ke pintu gerbang kotanya, katanya ");
INSERT INTO indayt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tidak, Tuanku, dengarkanlah aku. Aku memberikan ladang itu beserta gua yang berada di dalamnya. Aku menyerahkannya kepadamu, di hadapan kaum sebangsaku, aku memberikan tanah itu kepadamu, kuburkanlah orang matimu.” ");
INSERT INTO indayt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Lalu, berlututlah Abraham di hadapan penduduk tanah itu. ");
INSERT INTO indayt_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Dia berkata kepada Efron dan didengar oleh semua penduduk tanah itu, “Jika kamu berkenan, dengarkanlah aku, aku akan membayar harga ladang itu. Terimalah itu dariku supaya aku dapat mengubur orang matiku di sana.” ");
INSERT INTO indayt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron menjawab Abraham, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tuanku, dengarkanlah aku, sebidang tanah itu harganya 400 syikal perak, tetapi apalah artinya itu bagiku dan bagimu? Jadi, kuburkanlah orang matimu.” ");
INSERT INTO indayt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham mendengar perkataan Efron. Dia menimbang perak sebanyak yang dikatakan Efron, yang didengar oleh keturunan Het, yaitu 400 syikal perak, sesuai dengan berat perak yang berlaku di antara para pedagang. ");
INSERT INTO indayt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Jadi, ladang milik Efron di Makhpela, di sebelah timur Mamre, baik ladang maupun gua yang berada di dalamnya beserta seluruh pohon yang berada dalam ladang itu, yang berada dalam batas-batasnya, ");
INSERT INTO indayt_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","diserahkan kepada Abraham menjadi miliknya, di hadapan keturunan Het, di hadapan semua orang yang datang ke pintu gerbang kota itu. ");
INSERT INTO indayt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Setelah itu, Abraham mengubur Sara, istrinya, di dalam gua di ladang Makhpela di sebelah timur Mamre, yaitu Hebron, di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Jadi, ladang dan gua yang berada di dalamnya itu diserahkan kepada Abraham sebagai pekuburan miliknya, dari keturunan Het. ");
INSERT INTO indayt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Sekarang, Abraham sudah tua dan lanjut umurnya. TUHAN memberkati Abraham dalam segala hal. ");
INSERT INTO indayt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham berkata kepada hambanya yang tertua dalam rumahnya, yaitu hambanya yang bertanggung jawab atas seluruh harta miliknya, “Letakkanlah tanganmu di bawah pangkal pahaku. ");
INSERT INTO indayt_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Aku mau supaya kamu bersumpah demi TUHAN, yaitu Allah langit dan Allah bumi, bahwa kamu tidak akan mengambil istri bagi anakku dari anak-anak perempuan Kanaan yang di tengah-tengahnya aku berdiam ini. ");
INSERT INTO indayt_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Namun, kamu akan pergi kepada negeriku dan kepada sanak saudaraku untuk mengambil istri bagi Ishak, anakku.” ");
INSERT INTO indayt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Hamba itu berkata kepadanya, “Bagaimana jika perempuan itu tidak mau ikut denganku ke negeri ini? Haruskah aku membawa anakmu ke negeri asalmu?” ");
INSERT INTO indayt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Namun, Abraham berkata kepadanya, “Awas! Jangan kaubawa anakku kembali ke sana. ");
INSERT INTO indayt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TUHAN, Allah semesta langit, yang membawaku dari rumah ayahku dan dari tanah leluhurku; yang berbicara kepadaku dan bersumpah kepadaku, kata-Nya, ‘Aku akan memberikan tanah ini kepada keturunanmu,’ Dia akan mengutus malaikat-Nya di depanmu sehingga kamu bisa mendapatkan istri bagi anakku dari sana. ");
INSERT INTO indayt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Namun, kalau perempuan itu tidak ikut denganmu, kamu bebas dari sumpah ini, hanya jangan kaubawa anakku kembali ke sana.” ");
INSERT INTO indayt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lalu, hamba itu meletakkan tangannya ke bawah pangkal paha Abraham, tuannya itu, dan bersumpah kepadanya mengenai hal ini. ");
INSERT INTO indayt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kemudian, hamba itu membawa sepuluh ekor unta dari kawanan unta tuannya dan pergi. Dia juga membawa beraneka ragam barang bagus milik tuannya dan pergi ke Mesopotamia, ke kota Nahor. ");
INSERT INTO indayt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Di luar kota itu, dia membuat unta-untanya duduk di tepi sumur air pada sore hari, yaitu pada saat perempuan-perempuan pergi keluar untuk menimba air. ");
INSERT INTO indayt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kemudian, hamba itu berdoa, “Ya TUHAN, Allah tuanku Abraham! Buatlah aku berhasil pada hari ini, dan tunjukkanlah kemurahan-Mu kepada tuanku, Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lihatlah, aku berdiri di dekat sumur dan anak-anak perempuan dari penduduk kota ini datang untuk mengambil air. ");
INSERT INTO indayt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kalau gadis yang kepadanya aku berkata, ‘Tolong turunkan kendimu supaya aku dapat minum,’ menjawab dengan, ‘Minumlah dan aku juga akan memberi minum unta-untamu,’ dialah yang Engkau tetapkan bagi hamba-Mu, Ishak. Dengan demikian, aku akan mengetahui bahwa Engkau telah menunjukkan kemurahan-Mu kepada tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sebelum pelayan itu selesai berdoa, tiba-tiba Ribka, anak perempuan yang dilahirkan bagi Betuel anak Milka, istri dari saudara Abraham yang bernama Nahor, datang ke sumur dengan membawa kendi di bahunya. ");
INSERT INTO indayt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Gadis itu sangat cantik, seorang perawan, belum pernah ada laki-laki yang bersetubuh dengannya. Gadis itu pergi turun ke sumur dan mengisi kendinya, kemudian naik kembali. ");
INSERT INTO indayt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Hamba itu berlari untuk menemuinya dan berkata, “Tolong, izinkan aku minum sedikit air dari kendimu.” ");
INSERT INTO indayt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Jawab Ribka, “Minumlah, Tuanku.” Dia pun segera menurunkan kendi itu ke tangannya, lalu memberikan minum kepada hamba itu. ");
INSERT INTO indayt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Setelah Ribka selesai memberikan minuman kepada hamba itu, dia berkata, “Aku juga akan menimba air untuk unta-untamu sampai semuanya puas minum.” ");
INSERT INTO indayt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Lalu, Ribka segera menuangkan seluruh isi kendinya ke dalam palungan, lalu berlari kembali ke sumur untuk menimba air, dan dia menimbanya untuk semua unta orang itu. ");
INSERT INTO indayt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tanpa berkata-kata, orang itu mengamat-amati gadis itu untuk mengetahui apakah TUHAN telah membuat perjalanannya berhasil. ");
INSERT INTO indayt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Setelah unta-unta itu selesai minum, dia mengambil sepasang anting-anting emas seberat 0,5 syikal serta dua gelang emas seberat 10 syikal. ");
INSERT INTO indayt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Orang itu berkata, “Aku mohon, katakanlah kepadaku anak siapakah engkau? Adakah kamar di rumah ayahmu untuk kami bermalam?” ");
INSERT INTO indayt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ribka menjawabnya, “Aku adalah anak Betuel, anak Milka, yang telah dia lahirkan bagi Nahor.” ");
INSERT INTO indayt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Lalu, dia berkata lagi, “Kami mempunyai banyak jerami dan makanan unta, serta tempat untuk bermalam.” ");
INSERT INTO indayt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lalu, orang itu menundukkan kepalanya dan menyembah TUHAN, ");
INSERT INTO indayt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","katanya, “Terpujilah TUHAN, Allah tuanku, Abraham, yang tidak mengabaikan kasih setia-Nya kepada tuanku. Bagiku, TUHAN telah menuntun perjalananku menuju saudara tuanku ini.” ");
INSERT INTO indayt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kemudian, gadis itu berlari dan memberitahukan tentang semua itu kepada seisi rumah ibunya. ");
INSERT INTO indayt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribka mempunyai seorang saudara laki-laki bernama Laban, dan Laban berlari keluar untuk menemui hamba Abraham itu di dekat mata air. ");
INSERT INTO indayt_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Hal itu dilakukannya segera setelah dia melihat anting-anting dan gelang yang dikenakan pada tangan adiknya, serta mendengar perkataan Ribka: “Begitulah yang dikatakan orang itu kepadaku.” Laban menemui hamba Abraham itu dan mendapatinya berdiri di sebelah unta-untanya di dekat mata air. ");
INSERT INTO indayt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban berkata kepadanya, “Silakan masuk, engkau yang diberkati TUHAN! Mengapa engkau berdiri di luar? Aku telah menyiapkan rumah, juga tempat untuk unta-unta.” ");
INSERT INTO indayt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Lalu, orang itu masuk ke dalam rumah dan melepaskan pelana unta-unta itu, dan dia memberikan jerami maupun makanan untuk unta-unta itu. Ada juga air untuk membasuh kakinya dan kaki orang-orang yang menyertainya. ");
INSERT INTO indayt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kemudian, makanan disajikan di hadapannya untuk dimakan. Namun, dia berkata, “Aku tidak akan makan sampai aku selesai mengatakan apa yang harus aku katakan.” Laban berkata kepadanya, “Berbicaralah.” ");
INSERT INTO indayt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Lalu, dia berkata, “Aku adalah hamba Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TUHAN sangat memberkati tuanku dan dia telah menjadi kaya. Dia telah memberinya kawanan domba dan sapi, perak dan emas, hamba-hamba laki-laki maupun perempuan, serta banyak unta dan keledai. ");
INSERT INTO indayt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, istri tuanku itu melahirkan seorang anak laki-laki baginya pada masa tuanya. Dia telah memberikan segala sesuatu yang menjadi miliknya kepada anak itu. ");
INSERT INTO indayt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tuanku memintaku bersumpah, katanya, ‘Kamu tidak boleh mengambil istri bagi anakku dari anak-anak perempuan Kanaan, tanah yang kita tinggali ini. ");
INSERT INTO indayt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Namun, kamu harus pergi kepada keluarga ayahku dan kepada keluargaku untuk mengambilkan istri bagi anak laki-lakiku.’ ");
INSERT INTO indayt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kataku kepada tuanku itu, ‘Bagaimana jika perempuan itu tidak mau ikut denganku?’ ");
INSERT INTO indayt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Jawab tuanku, ‘TUHAN, yang di hadapan-Nya aku berjalan, akan mengutus malaikat-Nya untuk menyertai dan membuat perjalananmu berhasil sehingga kamu akan mengambilkan seorang istri untuk anakku dari tengah-tengah kaumku dan dari keluarga ayahku. ");
INSERT INTO indayt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Setelah itu, kamu akan bebas dari sumpahku, ketika kamu datang kepada keluargaku. Karena itu, jika mereka tidak bersedia menyerahkan anak perempuannya kepadamu, kamu tetap dibebaskan dari sumpahku.’ ");
INSERT INTO indayt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jadi, aku datang ke mata air itu hari ini dan memohon, ‘TUHAN, Allah tuanku, Abraham, jika sekarang ini Engkau berkenan untuk membuat perjalananku berhasil, ");
INSERT INTO indayt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","lihatlah, aku akan berdiri di dekat mata air itu; jika seorang gadis datang untuk mengambil air, aku akan berkata kepadanya, ‘Tolong izinkan aku minum sedikit dari air yang ada di kendimu.’ ");
INSERT INTO indayt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Jika perempuan itu berkata kepadaku, ‘Minumlah, dan aku juga akan mengambil air untuk unta-untamu,’ biarlah perempuan itu yang TUHAN tetapkan bagi anak laki-laki tuanku.’ ");
INSERT INTO indayt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Sebelum aku selesai berdoa dalam hatiku, lihatlah, Ribka datang ke sumur mengambil air dengan membawa kendi di bahunya. Ketika dia turun ke sumur untuk mengambil air, aku berkata kepadanya, ‘Tolong, berilah aku minum.’ ");
INSERT INTO indayt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Dia pun segera menurunkan kendinya itu dari bahunya dan berkata, ‘Minumlah dan aku juga akan mengambil air untuk unta-untamu.’ Lalu, aku minum dan dia juga memberi minum unta-untaku. ");
INSERT INTO indayt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kemudian, aku bertanya kepadanya, ‘Anak siapakah engkau?’ Jawabnya, ‘Anak perempuan Betuel, dia adalah anak laki-laki yang dilahirkan Milka bagi Nahor.’ Aku pun memasangkan anting-anting pada hidungnya dan gelang pada tangannya. ");
INSERT INTO indayt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Lalu, aku menundukkan kepalaku dan menyembah TUHAN. Aku memuji TUHAN, Allah tuanku, Abraham, yang telah membawaku ke jalan yang benar untuk bertemu dengan anak perempuan dari saudara tuanku untuk anak laki-lakinya. ");
INSERT INTO indayt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Sekarang, jika engkau berkenan menunjukkan kemurahan hati dan kesetiaan kepada tuanku, katakanlah kepadaku; dan jika tidak, katakanlah juga supaya aku tahu, aku harus berpaling ke kanan atau ke kiri.” ");
INSERT INTO indayt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kemudian, Laban dan Betuel menjawab, “Karena hal ini berasal dari TUHAN, kami tidak dapat mengatakan kepadamu baik atau buruknya. ");
INSERT INTO indayt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lihatlah, Ribka berada di hadapanmu. Bawalah dia dan pergilah. Biarlah dia menjadi istri bagi anak tuanmu, seperti yang telah TUHAN firmankan.” ");
INSERT INTO indayt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ketika hamba Abraham mendengar hal ini, berlututlah dia ke tanah di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kemudian, hamba Abraham itu mengeluarkan perhiasan perak, emas, dan pakaian, lalu memberikannya kepada Ribka; dia juga memberikan barang-barang yang mahal kepada saudara dan ibunya. ");
INSERT INTO indayt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kemudian, hamba Abraham dan orang-orangnya makan dan minum, dan mereka bermalam di sana. Ketika mereka bangun pada keesokan harinya, dia berkata, “Izinkanlah aku kembali kepada tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Namun, saudara laki-laki dan ibu Ribka berkata, “Biarlah Ribka tinggal dengan kami kira-kira 10 hari lagi. Setelah itu, kamu boleh pergi.” ");
INSERT INTO indayt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Akan tetapi, hamba Abraham berkata kepada mereka, “Jangan menahan aku, ketahuilah bahwa TUHAN telah membuat perjalananku berhasil. Izinkanlah aku pergi supaya aku dapat pergi kepada tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kata mereka, “Kami akan memanggil gadis itu dan mengetahuinya dari mulutnya sendiri.” ");
INSERT INTO indayt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Lalu, mereka memanggil Ribka dan bertanya kepadanya, “Apakah kamu mau pergi dengan orang ini?” Dia menjawab, “Ya, aku akan pergi.” ");
INSERT INTO indayt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Jadi, mereka mengizinkan Ribka dan pengasuhnya pergi bersama hamba Abraham dan orang-orangnya. ");
INSERT INTO indayt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Mereka memberkati Ribka dan berkata kepadanya, “Adik perempuan kami, biarlah kamu menjadi berpuluh-puluh ribu; dan kiranya keturunanmu menduduki pintu gerbang negeri-negeri yang memusuhi mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kemudian, Ribka dan pelayan-pelayannya bangkit, lalu menaiki unta dan mengikuti hamba Abraham itu. Demikianlah hamba itu membawa Ribka dan pergi. ");
INSERT INTO indayt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Adapun Ishak telah kembali dari perjalanan ke sumur Lahai-Roi dan tinggal di tanah selatan. ");
INSERT INTO indayt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pada suatu petang, dia berjalan-jalan ke ladang untuk menyendiri. Ketika dia melayangkan pandangannya, lihatlah, ada unta-unta yang sedang datang. ");
INSERT INTO indayt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka juga melayangkan pandangannya dan melihat Ishak, lalu dia turun dari untanya. ");
INSERT INTO indayt_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Dia bertanya kepada hamba itu, “Siapakah laki-laki yang sedang berjalan di ladang untuk menemui kita?” Hamba itu menjawab, “Dialah tuanku.” Lalu, Ribka mengambil cadarnya dan menutupi dirinya. ");
INSERT INTO indayt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kemudian, hamba itu menceritakan kepada Ishak tentang segala sesuatu yang telah dilakukannya. ");
INSERT INTO indayt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ishak membawa perempuan itu ke dalam tenda Sara, ibunya, dan mengambil Ribka sehingga Ribka menjadi istrinya, dan dia mencintai Ribka. Karena itu, Ishak terhibur setelah kematian ibunya. ");
INSERT INTO indayt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kemudian, Abraham mengambil seorang istri lagi, bernama Ketura. ");
INSERT INTO indayt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura melahirkan Zimran, Yoksan, Medan, Midian, Isybak, dan Suah bagi Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Bagi Yoksan, lahirlah Syeba dan Dedan. Keturunan Dedan adalah orang Asyur, orang Letush, dan orang Leum. ");
INSERT INTO indayt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Keturunan Midian adalah Efa, Efer, Henokh, Abida, dan Eldaa. Mereka semua adalah keturunan Ketura. ");
INSERT INTO indayt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham memberikan segala sesuatu yang dimilikinya kepada Ishak. ");
INSERT INTO indayt_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Akan tetapi, kepada anak-anak dari para gundiknya, Abraham memberikan banyak hadiah kepada mereka. Selagi Abraham masih hidup, dia menyuruh mereka pergi dari Ishak, anaknya, ke sebelah timur, ke tanah timur. ");
INSERT INTO indayt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Inilah seluruh tahun kehidupan Abraham yang telah dijalaninya, yaitu 175 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham mengembuskan napas terakhirnya dan mati pada usia yang sangat tua, genap tahun-tahunnya, dan dia dikumpulkan bersama nenek moyangnya. ");
INSERT INTO indayt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Lalu, anak-anaknya, Ishak dan Ismael, menguburkan dia di Gua Makhpela yang terdapat di ladang Efron, anak Zohar, orang Het, berseberangan dengan Mamre. ");
INSERT INTO indayt_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Di ladang yang dibelinya dari orang-orang Het inilah Abraham dikuburkan bersama dengan istrinya, Sara. ");
INSERT INTO indayt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Setelah kematian Abraham, Allah memberkati Ishak, anaknya. Kemudian, Ishak menetap di Sumur Lahai-Roi. ");
INSERT INTO indayt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Inilah keturunan dari Ismael, anak Abraham, yang dilahirkan bagi Abraham dari Hagar, wanita Mesir, hamba Sara itu. ");
INSERT INTO indayt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Inilah nama anak-anak laki-laki Ismael sesuai nama-nama mereka: Nebayot, anak sulung Ismael, lalu Kedar, Adbeel, Mibsam, ");
INSERT INTO indayt_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misyma, Duma, Masa, ");
INSERT INTO indayt_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafish, dan Kedma. ");
INSERT INTO indayt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Itulah keturunan Ismael dan itulah nama-nama mereka sesuai kampung dan pemukiman mereka, masing-masing dua belas pemimpin menurut suku-suku mereka. ");
INSERT INTO indayt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Inilah tahun-tahun dari kehidupan Ismael, yaitu 137 tahun. Kemudian, dia mengembuskan napasnya yang terakhir dan mati, lalu dikumpulkan bersama nenek moyangnya. ");
INSERT INTO indayt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Keturunannya berdiam mulai dari Hawila sampai ke Syur, yang letaknya di sebelah timur Mesir ke arah Asyur. Di sana, mereka hidup berseberangan dengan saudara-saudaranya. ");
INSERT INTO indayt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Inilah keturunan Ishak, anak Abraham; Abraham adalah ayah Ishak, ");
INSERT INTO indayt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ishak berumur 40 tahun ketika dia mengambil Ribka; anak perempuan Betuel, orang Aram dari Padan-Aram, dan adik perempuan Laban, orang Aram itu menjadi istrinya. ");
INSERT INTO indayt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ishak berdoa kepada TUHAN bagi istrinya karena istrinya itu mandul, dan TUHAN mendengar doa Ishak sehingga Ribka mengandung. ");
INSERT INTO indayt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Akan tetapi, anak-anak itu saling bergulat dalam rahim Ribka sehingga dia berkata, “Mengapa hal ini terjadi kepadaku?” Lalu, dia pergi untuk mencari TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","TUHAN berkata kepadanya, “Dua bangsa ada dalam rahimmu. Dua orang yang berasal darimu itu akan dipisahkan. Yang satu akan lebih kuat daripada yang lain, dan yang lebih tua akan melayani yang lebih muda.” ");
INSERT INTO indayt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ketika tiba waktunya untuk melahirkan, ternyata memang ada anak kembar dalam rahimnya. ");
INSERT INTO indayt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Yang pertama lahir, warnanya merah, seluruh tubuhnya seperti jubah berbulu, dan mereka menamainya Esau. ");
INSERT INTO indayt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Setelah itu, lahirlah saudaranya dengan tangannya yang sedang memegang tumit Esau. Jadi, dia dinamai Yakub. Ishak berumur 60 tahun ketika Ribka melahirkan mereka. ");
INSERT INTO indayt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ketika kedua anak itu tumbuh besar, Esau menjadi pemburu yang terampil, orang yang senang tinggal di padang. Akan tetapi, Yakub adalah orang yang tenang, yang suka tinggal di tenda. ");
INSERT INTO indayt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ishak menyayangi Esau karena dia suka makan hasil buruan Esau. Namun, Ribka menyayangi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Pada suatu hari, ketika Yakub sedang memasak suatu rebusan, datanglah Esau dari padang dan dia kelelahan. ");
INSERT INTO indayt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Lalu, Esau berkata kepada Yakub, “Aku mohon kepadamu, biarkanlah aku makan sedikit dari yang merah-merah itu sebab aku sangat lelah.” Oleh sebab itu, orang menamakannya Edom. ");
INSERT INTO indayt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Akan tetapi, Yakub berkata, “Jual dahulu hak kesulunganmu kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kata Esau, “Sebentar lagi aku mati. Apakah gunanya hak kesulungan itu bagiku?” ");
INSERT INTO indayt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Namun, Yakub berkata, “Bersumpahlah dahulu kepadaku!” Jadi, Esau bersumpah kepadanya dan menjual hak kesulungannya kepada Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kemudian, Yakub memberikan roti dan rebusan kacang merah itu kepada Esau. Esau memakannya dan minum, lalu pergi. Demikianlah Esau meremehkan hak kesulungannya. ");
INSERT INTO indayt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kelaparan pun terjadi di negeri itu, selain kelaparan yang terjadi pada zaman Abraham. Karena itu, Ishak pergi ke Gerar, kepada Abimelekh, raja orang Filistin. ");
INSERT INTO indayt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","TUHAN menampakkan diri kepada Ishak dan berkata, “Jangan pergi ke Mesir. Tinggallah di tanah yang akan Kukatakan kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tinggallah untuk sementara di negeri ini dan Aku akan menyertaimu dan akan memberkatimu. Karena kepadamu dan kepada keturunanmulah, Aku akan memberikan seluruh negeri ini. Aku akan meneguhkan sumpah yang telah Kuikrarkan kepada Abraham, ayahmu. ");
INSERT INTO indayt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aku akan melipatgandakan keturunanmu sebanyak bintang di langit, dan akan memberikan seluruh negeri ini kepada keturunanmu. Melalui keturunanmu, seluruh bangsa di bumi akan diberkati, ");
INSERT INTO indayt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","sebab Abraham menaati suara-Ku, dan memelihara kewajibannya terhadap-Ku, perintah-perintah-Ku, ketetapan-ketetapan-Ku, dan hukum-hukum-Ku.” ");
INSERT INTO indayt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Jadi, Ishak menetap di Gerar. ");
INSERT INTO indayt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ketika orang-orang di tempat itu bertanya kepada Ishak tentang istrinya, dia berkata, “Dia adalah adikku.” Dia takut untuk berkata, “Dia adalah istriku,” karena pikirnya, “orang-orang di tempat ini akan membunuhku karena Ribka sebab dia cantik.” ");
INSERT INTO indayt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ketika dia telah beberapa lama berada di sana, Abimelekh, raja orang Filistin, memandang dari jendela dan memperhatikan, tampak Ishak sedang bercumbu dengan Ribka, istrinya. ");
INSERT INTO indayt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lalu, Abimelekh memanggil Ishak dan berkata, “Lihatlah, ternyata dia adalah istrimu! Lalu, mengapa kamu mengatakan bahwa dia adalah adikmu?” Kata Ishak kepadanya, “Karena aku pikir, jangan-jangan aku akan mati karena dia.” ");
INSERT INTO indayt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelekh berkata, “Apa yang telah kaulakukan terhadap kami? Mudah sekali bagi salah seorang rakyatku ini berbaring dengan istrimu sehingga kamu mendatangkan sebuah kesalahan atas kami.” ");
INSERT INTO indayt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Lalu, Abimelekh memperingatkan semua orang, katanya, “Siapa pun yang menyentuh laki-laki ini atau istrinya, orang itu pasti dihukum mati!” ");
INSERT INTO indayt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ishak menabur di tanah itu dan dia memanen seratus kali lipat pada tahun yang sama sebab TUHAN memberkatinya. ");
INSERT INTO indayt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Orang itu pun menjadi kaya, dan terus bertambah kaya sehingga dia menjadi kaya raya. ");
INSERT INTO indayt_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Dia memiliki kawanan domba, dan ternak, dan banyak hamba sehingga orang-orang Filistin iri terhadapnya. ");
INSERT INTO indayt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Karena itu, semua sumur yang digali oleh hamba-hamba ayahnya, ketika ayahnya, Abraham, masih hidup, ditutup dan ditimbun dengan tanah oleh orang-orang Filistin. ");
INSERT INTO indayt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kemudian, Abimelekh berkata kepada Ishak, “Pergilah dari kami sebab kamu menjadi lebih kuat daripada kami.” ");
INSERT INTO indayt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Lalu, Ishak pergi dari sana. Dia mendirikan tenda di Lembah Gerar dan tinggal di sana. ");
INSERT INTO indayt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kemudian, Ishak kembali menggali sumur-sumur yang digali pada zaman Abraham, ayahnya, yang telah ditutup oleh orang Filistin setelah kematian Abraham. Ishak memberikan nama yang sama kepada sumur-sumur itu, sebagaimana Abraham menamakannya dahulu. ");
INSERT INTO indayt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Akan tetapi, ketika hamba-hamba Ishak menggali sumur di lembah itu dan menemukan mata air yang alirannya berlimpah-limpah, ");
INSERT INTO indayt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","para penggembala Gerar bertengkar dengan hamba-hamba Ishak dan berkata, “Air itu adalah milik kami!” Jadi, Ishak menamakan sumur itu Esek sebab di sana orang-orang bertengkar dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kemudian, mereka menggali sumur yang lain, tetapi orang-orang itu juga mempertengkarkannya sehingga Ishak menamakan sumur itu Sitna. ");
INSERT INTO indayt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ishak pindah dari sana dan menggali sumur yang lain. Di sana tidak ada pertengkaran lagi sehingga Ishak menamakan tempat itu Rehobot. Dia berkata, “Sekarang, TUHAN telah memberikan keleluasaan kepada kita sehingga kita dapat beranak cucu di tanah ini.” ");
INSERT INTO indayt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dari situ, Ishak pergi ke Bersyeba. ");
INSERT INTO indayt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pada malam itu, TUHAN menampakkan diri kepadanya dan berfirman, “Akulah Allah Abraham, ayahmu. Jangan takut sebab Aku menyertaimu. Aku akan memberkatimu dan melipatgandakan keturunanmu karena Abraham, hamba-Ku.” ");
INSERT INTO indayt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Lalu, Ishak membangun mazbah di sana dan memanggil nama TUHAN. Di sana, dia mendirikan tendanya dan hamba-hambanya juga menggali sumur di situ. ");
INSERT INTO indayt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Setelah itu, datanglah Abimelekh dari Gerar kepada Ishak bersama dengan Ahuzat, penasihatnya, dan Pikhol, panglima pasukannya. ");
INSERT INTO indayt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ishak berkata kepada mereka, “Mengapa engkau datang menemuiku padahal sebelumnya engkau membenciku dan menyuruhku pergi darimu.” ");
INSERT INTO indayt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mereka menjawab, “Sekarang kami melihat dengan jelas bahwa TUHAN menyertaimu. Jadi, kami mengatakan bahwa sebaiknya ada sumpah di antara kita, antara pihakmu dan kami. Biarlah kami membuat suatu perjanjian denganmu; ");
INSERT INTO indayt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","bahwa kami tidak akan menyakitimu seperti dahulu, kami tidak menyentuhmu, dan tidak melakukan apa pun kepadamu, kecuali kebaikan. Bahkan, ketika menyuruhmu pergi, kami menyuruhmu pergi dalam damai. Sekarang, kamulah yang diberkati TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ishak mengadakan jamuan makan bagi mereka, lalu mereka makan dan minum. ");
INSERT INTO indayt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mereka bangun pagi-pagi sekali dan saling bersumpah. Kemudian, Ishak melepas orang-orang itu dan mereka pergi darinya dalam damai. ");
INSERT INTO indayt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Pada hari itu, hamba-hamba Ishak datang dan memberi tahu tentang sumur yang telah mereka gali. Mereka berkata, “Kami menemukan air!” ");
INSERT INTO indayt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","sehingga Ishak menamakan sumur itu Syeba. Karena itulah, kota itu masih disebut Bersyeba sampai hari ini. ");
INSERT INTO indayt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ketika Esau berumur 40 tahun, dia menikah dengan Yudit anak Beeri, orang Het, dan Basmat anak Elon, orang Het, ");
INSERT INTO indayt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","yang mendukakan hati Ishak dan Ribka. ");
INSERT INTO indayt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ketika Ishak sudah tua dan matanya menjadi rabun sehingga dia tidak dapat melihat dengan jelas, dia memanggil Esau, anak sulungnya, dan berkata, “Anakku!” Esau menjawab, “Ya, Ayah.” ");
INSERT INTO indayt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ishak berkata, “Lihatlah, sekarang aku sudah tua, aku tidak mengetahui hari kematianku. ");
INSERT INTO indayt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Jadi, ambillah senjatamu, tabung panahmu, dan busurmu, lalu pergilah ke padang untuk memburu makanan bagiku. ");
INSERT INTO indayt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Lalu, olahlah makanan lezat bagiku, seperti yang aku suka, dan bawalah kemari untuk kumakan supaya aku dapat memberkatimu sebelum aku mati.” ");
INSERT INTO indayt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Pada saat Ishak berbicara kepada Esau, anaknya, Ribka mendengar hal ini. Karena itu, ketika Esau pergi ke padang hendak memburu tangkapan untuk dibawa pulang, ");
INSERT INTO indayt_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka berkata kepada Yakub, anaknya, “Aku mendengar ayahmu berbicara kepada kakakmu, Esau, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bawalah kepadaku hasil buruan dan olahlah makanan yang lezat untukku supaya aku dapat memakannya dan memberkatimu di hadapan Allah sebelum aku mati.’ ");
INSERT INTO indayt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Karena itu, Anakku, dengarlah perkataanku sesuai perintahku kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pergilah kepada kawanan kambing kita dan dari itu ambillah dua ekor kambing jantan muda pilihan dan aku akan mengolahnya menjadi makanan lezat bagi ayahmu seperti yang dia sukai. ");
INSERT INTO indayt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Lalu, kamu harus membawanya kepada ayahmu supaya dimakannya sehingga dia dapat memberkatimu sebelum kematiannya.” ");
INSERT INTO indayt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Namun, Yakub berkata kepada Ribka, ibunya, “Lihatlah, Esau, kakakku, adalah orang yang berbulu, sedangkan aku adalah orang berkulit licin. ");
INSERT INTO indayt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mungkin ayahku akan merabaku dan aku akan dianggapnya sebagai penipu sehingga aku malah akan mendatangkan kutuk atas diriku, bukannya berkat.” ");
INSERT INTO indayt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Namun, ibunya berkata kepadanya, “Kutukmu itu adalah tanggunganku, Anakku. Dengarkan saja suaraku. Pergilah dan bawa kambing-kambing itu kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Lalu, dia pergi untuk mengambil dan membawanya kepada ibunya. Lalu, ibunya mengolah makanan lezat sesuai dengan kesukaan ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kemudian, Ribka mengambil pakaian terbaik milik Esau, anak sulungnya, yang disimpannya di rumah dan mengenakannya pada anak bungsunya, Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dia juga menaruh kulit kambing muda pada tangan dan bagian leher Yakub yang tidak berbulu. ");
INSERT INTO indayt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Dia juga memberikan makanan lezat dan roti yang dibuatnya kepada Yakub, anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kemudian, Yakub pergi kepada ayahnya dan berkata, “Ayahku!” Ayahnya menjawab, “Ya, Nak. Siapakah kamu, Anakku?” ");
INSERT INTO indayt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakub berkata kepada ayahnya, “Aku Esau, anak sulungmu. Aku telah melaksanakan apa yang Ayah katakan kepadaku. Sekarang, duduklah dan makanlah hasil buruanku ini supaya engkau dapat memberkatiku.” ");
INSERT INTO indayt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ishak berkata kepada anaknya, “Bagaimana kamu bisa mendapatkannya secepat itu, Anakku?” Yakub menjawab, “Karena TUHAN, Allahmu, yang membuatku berhasil.” ");
INSERT INTO indayt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kemudian, Ishak berkata kepada Yakub, “Mendekatlah supaya aku dapat merabamu, Anakku, supaya aku tahu apakah kamu benar-benar anakku, Esau, atau bukan.” ");
INSERT INTO indayt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Lalu, Yakub mendekat kepada Ishak, ayahnya, dan Ishak merabanya, lalu berkata, “Suaranya suara Yakub, tetapi tangannya adalah tangan Esau.” ");
INSERT INTO indayt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ishak tidak mengenali Yakub karena tangan Yakub berbulu seperti tangan Esau. Jadi, Ishak memberkati Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Namun, sekali lagi Ishak bertanya, “Apakah kamu benar-benar anakku, Esau?” Yakub menjawab, “Ya, akulah dia.” ");
INSERT INTO indayt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kemudian, Ishak berkata, “Bawalah kepadaku, aku akan memakan hasil buruan anakku supaya aku dapat memberkatimu.” Yakub membawa makanan itu kepada ayahnya dan Ishak pun memakannya. Yakub juga membawakan anggur untuk ayahnya, dan Ishak pun meminumnya. ");
INSERT INTO indayt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kemudian, Ishak, ayahnya, berkata kepadanya, “Kemarilah dan ciumlah aku, Anakku.” ");
INSERT INTO indayt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakub pun mendekat kepada ayahnya dan menciumnya. Ketika Ishak mencium bau pakaiannya, dia memberkatinya dan berkata, “Bau anakku ini seperti bau padang yang diberkati TUHAN. ");
INSERT INTO indayt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kiranya Allah memberikan kepadamu embun dari langit, tanah yang gemuk, gandum, dan anggur baru yang berlimpah-limpah. ");
INSERT INTO indayt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kiranya bangsa-bangsa melayanimu dan suku-suku bangsa sujud kepadamu. Jadilah tuan atas saudara-saudaramu, dan kiranya anak-anak ibumu berlutut kepadamu. Terkutuklah orang yang mengutukmu, dan diberkatilah orang yang memberkatimu.” ");
INSERT INTO indayt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ishak baru saja selesai memberkati Yakub dan Yakub juga baru saja meninggalkan ayahnya, ketika Esau pulang dari pemburuannya. ");
INSERT INTO indayt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kemudian, Esau juga mengolah makanan lezat dan dibawanya itu kepada ayahnya. Dia berkata kepada ayahnya, “Ayahku, bangun dan makanlah hasil buruan anakmu ini supaya engkau memberkati aku.” ");
INSERT INTO indayt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Namun, Ishak, ayahnya, bertanya kepadanya, “Siapa kamu?” Esau menjawab, “Aku anakmu, anak sulungmu, Esau.” ");
INSERT INTO indayt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tubuh Ishak menjadi sangat gemetar dan berkata, “Siapa dia yang telah memburu hasil buruan dan membawanya kepadaku? Sebelum kamu datang, aku telah memakan semuanya itu dan memberkatinya; dan dialah yang tetap akan diberkati.” ");
INSERT INTO indayt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ketika Esau mendengar perkataan ayahnya itu, Dia menjerit dengan suara yang sangat nyaring dan penuh kepahitan. Lalu, dia berkata kepada ayahnya, “Berkatilah juga aku, Ayahku!” ");
INSERT INTO indayt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kata Ishak kepadanya, “Saudaramu telah datang kemari dengan tipu daya dan merampas berkatmu.” ");
INSERT INTO indayt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau berkata, “Memang tepat namanya Yakub, bukan? Sebab, sudah dua kali dia memperdaya aku. Dia telah merampas hak kesulunganku, lalu sekarang, lihatlah, dia merampas berkatku.” Dia pun bertanya lagi, “Apakah engkau tidak menyimpan berkat lain untukku?” ");
INSERT INTO indayt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ishak menjawab Esau, “Aku telah menjadikannya tuan atasmu dan semua saudaranya kuberikan kepadanya untuk menjadi hambanya. Aku pun telah memberkatinya dengan banyak gandum dan anggur. Karena itu, apa lagi yang dapat kulakukan untukmu, Anakku?” ");
INSERT INTO indayt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau berkata kepada ayahnya, “Apakah engkau hanya memiliki satu berkat itu, Ayahku? Berkatilah juga aku, Ayahku!” Kemudian, Esau mulai menangis dengan suara keras. ");
INSERT INTO indayt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Lalu Ishak, ayahnya, berkata kepadanya, “Dengarlah, tempat tinggalmu akan jauh dari tanah yang subur di bumi, dan jauh pula dari embun langit di atas. ");
INSERT INTO indayt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kamu akan hidup oleh pedang, dan kamu akan melayani saudaramu. Akan tetapi, jika kamu berusaha sungguh-sungguh, kamu akan dapat melemparkan kuknya dari lehermu.” ");
INSERT INTO indayt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Karena itu, Esau membenci Yakub karena berkat yang telah diberikan ayah mereka kepada adiknya. Kata Esau kepada dirinya sendiri, “Masa berkabung karena kematian ayah sudah dekat; setelah itulah aku akan membunuh saudaraku, Yakub.” ");
INSERT INTO indayt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ketika Ribka diberitahu tentang apa yang dikatakan Esau, dia pun segera mengutus orang untuk memanggil Yakub, anak bungsunya, dan berkata kepadanya, “Dengarlah, Esau, saudaramu, hendak menghibur dirinya dengan membunuhmu. ");
INSERT INTO indayt_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Karena itu, Anakku, lakukan apa yang kukatakan kepadamu: Cepat lari kepada Laban, saudara laki-lakiku, di Haran. ");
INSERT INTO indayt_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tinggallah dengannya selama beberapa waktu sampai kemarahan saudaramu reda. ");
INSERT INTO indayt_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ketika kemarahan saudaramu telah reda dan dia melupakan apa yang kaulakukan kepadanya, aku akan mengutus seseorang untuk membawamu kembali. Lagi pula, mengapa aku harus kehilangan kamu berdua dalam sehari?” ");
INSERT INTO indayt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kemudian, Ribka berkata kepada Ishak, “Aku lelah dengan hidupku karena perempuan-perempuan Het ini. Jika Yakub mengambil istri dari antara perempuan di negeri ini, dari perempuan-perempuan Het seperti ini, tidak ada gunanya lagi aku hidup.” ");
INSERT INTO indayt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kemudian, Ishak memanggil Yakub, memberkatinya, dan memerintahkannya, “Kamu tidak boleh mengambil istri dari antara anak perempuan Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Bersiaplah dan pergilah ke Padan-Aram, ke rumah Betuel, ayah dari ibumu. Dari sana, ambillah seorang istri bagimu, yaitu salah seorang anak perempuan Laban, saudara ibumu. ");
INSERT INTO indayt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kiranya Allah Yang Mahakuasa memberkatimu, membuatmu beranak cucu, dan melipatgandakanmu sehingga kamu menjadi bangsa yang besar. ");
INSERT INTO indayt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kiranya Dia memberikan berkat Abraham kepadamu dan kepada keturunanmu supaya kamu dapat memiliki tanah yang kautinggali sementara ini, yang diberikan Allah kepada Abraham.” ");
INSERT INTO indayt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kemudian, Ishak melepas kepergian Yakub, dan dia berangkat ke Padan-Aram, kepada Laban, anak Betuel orang Aram itu, yang adalah saudara Ribka, ibu Yakub dan Esau. ");
INSERT INTO indayt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau melihat bahwa Ishak telah memberkati Yakub dan menyuruhnya pergi ke Padan-Aram untuk mengambil seorang istri dari sana, dan bahwa ketika dia memberkati Yakub, dia memberi perintah kepadanya, katanya, “Kamu tidak boleh mengambil istri dari antara anak perempuan Kanaan,” ");
INSERT INTO indayt_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","dan bahwa Yakub menaati ayahnya dan ibunya, lalu pergi ke Padan-Aram. ");
INSERT INTO indayt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Dengan demikian, Esau menyadari bahwa perempuan-perempuan Kanaan itu tidak disukai oleh Ishak, ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Karena itu, pergilah Esau kepada Ismael dan mengambil Mahalat sebagai istrinya di samping istri-istrinya yang lain. Mahalat adalah adik perempuan Nebayot, anak Ismael, anak Abraham. ");
INSERT INTO indayt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakub pergi dari Bersyeba dan berangkat ke Haran. ");
INSERT INTO indayt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Lalu, dia tiba di suatu tempat dan dia bermalam di sana sebab matahari telah terbenam. Yakub mengambil sebongkah batu dari tempat itu dan menjadikannya bantal, lalu berbaringlah dia di tempat itu untuk tidur. ");
INSERT INTO indayt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kemudian, dia bermimpi, dan lihatlah, sebuah tangga didirikan di atas bumi yang ujungnya sampai ke langit. Lihatlah, para malaikat Allah turun naik melaluinya. ");
INSERT INTO indayt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kemudian, lihatlah, TUHAN berdiri di atasnya dan berfirman, “Akulah TUHAN, Allah Abraham, nenek moyangmu, dan Allah Ishak; tanah tempatmu berbaring ini akan Kuberikan kepadamu dan kepada keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Keturunanmu akan menjadi seperti debu tanah, dan kamu akan menyebar ke barat, timur, utara, dan selatan. Melaluimu dan melalui keturunanmu, semua kaum di bumi akan diberkati. ");
INSERT INTO indayt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Lihatlah, Aku menyertaimu dan akan menjagamu, ke mana pun kamu pergi, dan akan membawamu kembali ke tanah ini. Sebab, Aku tidak akan meninggalkanmu sampai Aku menggenapi apa yang telah Kukatakan kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kemudian, Yakub terbangun dari tidurnya dan dia berkata, “Sesungguhnya, TUHAN ada di tempat ini, tetapi aku tidak mengetahuinya!” ");
INSERT INTO indayt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Dia menjadi takut dan berkata, “Betapa dahsyatnya tempat ini! Ini tidak lain adalah rumah Allah dan ini adalah gerbang surga!” ");
INSERT INTO indayt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Karena itu, Yakub bangun pagi-pagi benar dan mengambil batu yang diletakkannya di bawah kepalanya. Lalu, dia menyusunnya menjadi sebuah tugu dan mencurahkan minyak ke atasnya. ");
INSERT INTO indayt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yakub menyebut tempat itu Betel, tetapi sebelumnya nama kota itu adalah Lus. ");
INSERT INTO indayt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kemudian, Yakub bersumpah, katanya, “Jika Allah akan menyertaiku dan akan menjagaku dalam perjalanan yang kutempuh ini, dan jika Dia memberiku roti untuk dimakan dan pakaian untuk dikenakan, ");
INSERT INTO indayt_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sampai aku kembali lagi ke rumah ayahku dengan selamat, TUHAN akan menjadi Allahku. ");
INSERT INTO indayt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu ini, yang kudirikan sebagai tugu, akan menjadi rumah Allah dan segala sesuatu yang Engkau berikan kepadaku, aku akan memberikan sepersepuluhnya kepada-Mu.” ");
INSERT INTO indayt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kemudian, Yakub meneruskan perjalanannya dan tiba di tanah orang-orang Timur. ");
INSERT INTO indayt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Dia melayangkan pandangannya, dan lihatlah, ada sebuah sumur di padang. Tampak tiga kawanan domba yang berbaring di dekat situ karena dari sumur itulah para gembala memberi minum kawanannya. Sebongkah batu besar ada di atas mulut sumur itu. ");
INSERT INTO indayt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Setelah semua kawanan itu berkumpul di sana, para gembala akan menggulingkan batu itu dari mulut sumur, memberi minum domba-domba mereka, lalu mereka mengembalikan batu itu ke tempatnya, di atas mulut sumur. ");
INSERT INTO indayt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kata Yakub kepada mereka, “Saudara-saudaraku, dari manakah asal kalian?” Jawab mereka, “Kami dari Haran.” ");
INSERT INTO indayt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Dia berkata kepada mereka, “Apakah kalian mengenal Laban, anak Nahor?” Jawab mereka, “Kami mengenalnya.” ");
INSERT INTO indayt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kemudian, dia bertanya kepada mereka, “Apakah dia baik-baik saja?” Jawab mereka, “Dia baik-baik saja. Lihatlah, itu Rahel, anak perempuannya, datang dengan domba-dombanya.” ");
INSERT INTO indayt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Dia berkata, “Lihatlah, hari masih siang. Belum waktunya untuk ternak dikumpulkan. Berilah domba-domba itu minum dan pergilah, gembalakanlah mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Namun, mereka berkata, “Kami tidak dapat melakukannya sebelum semua kawanan domba itu dikumpulkan dan batu penutup itu digulingkan dari mulut sumur. Setelah itu, kami baru dapat memberi minum domba-domba ini.” ");
INSERT INTO indayt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sementara dia sedang berbicara dengan mereka, Rahel datang bersama domba-domba ayahnya sebab dialah yang menggembalakannya. ");
INSERT INTO indayt_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ketika Yakub melihat Rahel, anak perempuan Laban, saudara ibunya, dan domba-domba Laban, saudara ibunya, Yakub pun mendekat dan menggulingkan batu itu dari mulut sumur, lalu memberi minum kawanan domba Laban, saudara ibunya itu. ");
INSERT INTO indayt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kemudian, Yakub mencium Rahel dan menangis dengan menyaringkan suaranya. ");
INSERT INTO indayt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakub memberi tahu Rahel bahwa dia anak saudara ayahnya, dan bahwa dia adalah anak Ribka. Lalu, dia berlari untuk memberi tahu ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ketika Laban mendengar kabar tentang Yakub, anak saudaranya, dia pun berlari untuk menemuinya, memeluknya, menciumnya, dan membawanya ke rumahnya. Dia pun menceritakan tentang segala sesuatunya kepada Laban. ");
INSERT INTO indayt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban berkata kepadanya, “Sesungguhnya, kamu adalah tulang dan dagingku!” Lalu, Yakub tinggal dengannya selama sebulan. ");
INSERT INTO indayt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kemudian, Laban bertanya kepada Yakub, “Hanya karena kamu adalah saudaraku, apakah kamu harus bekerja padaku dengan cuma-cuma? Katakanlah kepadaku, apakah upahmu?” ");
INSERT INTO indayt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban mempunyai dua anak perempuan. Yang sulung bernama Lea dan yang lebih muda bernama Rahel. ");
INSERT INTO indayt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mata Lea sayu, sedangkan Rahel itu cantik penampilannya dan wajahnya. ");
INSERT INTO indayt_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakub mencintai Rahel dan dia berkata, “Aku akan bekerja padamu selama tujuh tahun demi Rahel, anak bungsumu.” ");
INSERT INTO indayt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban berkata, “Lebih baik aku memberikan Rahel kepadamu daripada aku harus memberikannya kepada orang lain. Jadi, tinggallah denganku.” ");
INSERT INTO indayt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakub bekerja selama tujuh tahun demi Rahel dan hal itu seperti beberapa hari saja baginya karena cintanya terhadap Rahel. ");
INSERT INTO indayt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Setelah tujuh tahun, Yakub berkata kepada Laban, “Berikanlah istriku kepadaku karena hari-hariku sudah genap. Dengan begitu, aku dapat mengawininya.” ");
INSERT INTO indayt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lalu, Laban mengumpulkan semua orang dari tempat itu dan mengadakan pesta perjamuan. ");
INSERT INTO indayt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Malam itu, Laban mengambil anak perempuannya, Lea, dan membawanya kepada Yakub. Lalu, Yakub bersetubuh dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban juga memberikan hamba perempuannya, Zilpa, kepada anaknya, Lea, untuk menjadi hamba anaknya itu. ");
INSERT INTO indayt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Keesokan paginya, lihatlah, itu adalah Lea! Karena itu, Yakub berkata kepada Laban, “Apa yang engkau lakukan terhadapku? Bukankah aku bekerja untukmu demi Rahel? Lalu, mengapa engkau menipuku?” ");
INSERT INTO indayt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban menjawab, “Bukan kebiasaan di negeri kami untuk memberikan yang termuda sebelum yang sulung. ");
INSERT INTO indayt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Genapilah dahulu 7 hari baginya, lalu kami akan memberikan dia juga kepadamu asalkan kamu kembali bekerja untukku selama tujuh tahun lagi.” ");
INSERT INTO indayt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakub melakukannya dan menggenapi tujuh hari perempuan itu. Kemudian, Laban memberikan Rahel, anaknya, sebagai istri Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban memberikan hamba perempuannya, Bilha, kepada anaknya, Rahel, untuk menjadi hamba bagi anaknya itu. ");
INSERT INTO indayt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Lalu, Yakub bersetubuh juga dengan Rahel dan dia lebih mencintai Rahel daripada Lea. Dia masih bekerja untuk Laban selama tujuh tahun lagi. ");
INSERT INTO indayt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ketika TUHAN melihat bahwa Lea tidak dicintai, Dia membuka kandungannya, sedangkan Rahel mandul. ");
INSERT INTO indayt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea mengandung dan melahirkan seorang anak laki-laki. Dia menamainya Ruben sebab katanya, “TUHAN telah melihat kesusahanku. Sebab itu, sekarang suamiku akan mencintaiku.” ");
INSERT INTO indayt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea mengandung lagi dan melahirkan anak laki-laki dan berkata, “Karena TUHAN telah mendengar bahwa aku tidak dicintai, Dia juga memberikan anak laki-laki ini kepadaku.” Sebab itu, dia menamainya Simeon. ");
INSERT INTO indayt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea mengandung lagi dan melahirkan anak laki-laki, katanya, “Sekaranglah waktunya, suamiku akan lekat kepadaku karena aku telah melahirkan tiga anak laki-laki baginya.” Karena itu, dia dinamai Lewi. ");
INSERT INTO indayt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kemudian, Lea mengandung lagi dan melahirkan anak laki-laki, katanya, “Sekarang, aku akan memuji TUHAN.” Karena itu, dia menamakannya Yehuda. Setelah itu, dia berhenti melahirkan. ");
INSERT INTO indayt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ketika Rahel melihat bahwa dia tidak melahirkan anak bagi Yakub, dia cemburu terhadap kakaknya dan berkata kepada Yakub, “Berikanlah anak untukku, kalau tidak, aku akan mati!” ");
INSERT INTO indayt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Lalu, kemarahan Yakub menyala terhadap Rahel sehingga dia berkata, “Apa aku ini pengganti Allah yang telah menghalangi benih dari kandunganmu?” ");
INSERT INTO indayt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahel berkata, “Ini Bilha, hambaku. Bersetubuhlah dengannya supaya dia dapat melahirkan anak di pangkuanku. Dengan begitu, aku juga mendapatkan anak melaluinya.” ");
INSERT INTO indayt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Jadi, Rahel memberikan Bilha kepada Yakub untuk menjadi istrinya dan Yakub bersetubuh dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Lalu, Bilha mengandung dan melahirkan anak laki-laki bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel berkata, “Allah telah memutuskan bagiku dan telah mendengar suaraku juga, dan Dia memberiku anak laki-laki.” Karena itu, dia menamainya Dan. ");
INSERT INTO indayt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, hamba perempuan Rahel, mengandung lagi dan melahirkan anak laki-laki yang kedua bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel berkata, “Dengan pergumulan yang sangat hebat aku telah bergumul dengan kakakku, dan aku dimampukan.” Jadi, dia menamainya Naftali. ");
INSERT INTO indayt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ketika Lea menyadari bahwa dia telah berhenti melahirkan, dia mengambil Zilpa, hambanya, dan memberikannya kepada Yakub sebagai istrinya. ");
INSERT INTO indayt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, hamba Lea, melahirkan anak laki-laki bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea berkata, “Betapa beruntungnya.” Jadi, dia menamainya Gad. ");
INSERT INTO indayt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, hamba Lea, melahirkan anak laki-laki yang kedua bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea berkata, “Aku bahagia! Sebab, perempuan-perempuan akan menyebutku berbahagia.” Jadi, dia menamainya Asyer. ");
INSERT INTO indayt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pada musim panen gandum, Ruben berjalan-jalan dan menemukan buah-buah dudaim di padang, lalu dia membawanya kepada Lea, ibunya. Kemudian, Rahel berkata kepada Lea, “Aku mohon, berikanlah beberapa dudaim anakmu itu kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea berkata kepadanya, “Apakah perkara kecil bagimu untuk mengambil suamiku? Sekarang, kamu juga mau mengambil dudaim anakku?” Lalu, Rahel menjawab, “Kalau begitu, Yakub boleh tidur denganmu malam ini sebagai ganti dudaim anakmu itu.” ");
INSERT INTO indayt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ketika Yakub pulang dari ladang pada sore hari itu, Lea keluar untuk menyambutnya dan berkata, “Kamu harus datang kepadaku karena aku sudah menyewamu dengan dudaim anakku.” Jadi, Yakub tidur dengannya pada malam itu. ");
INSERT INTO indayt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allah mendengarkan Lea sehingga dia mengandung dan melahirkan anak laki-laki yang kelima bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea berkata, “Allah memberikan upah kepadaku karena aku telah memberikan hambaku kepada suamiku.” Jadi, dia menamainya Isakhar. ");
INSERT INTO indayt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea mengandung lagi dan melahirkan anak laki-laki yang keenam bagi Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Dia berkata, “Allah telah memberkatiku dengan pemberian yang indah. Sekarang, suamiku akan tinggal bersamaku karena aku telah melahirkan enam anak laki-laki baginya.” Dia pun menamainya Zebulon. ");
INSERT INTO indayt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Setelah itu, dia melahirkan seorang anak perempuan dan menamainya Dina. ");
INSERT INTO indayt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kemudian, Allah mengingat Rahel, dan Allah mendengarkannya, dan membuka kandungannya. ");
INSERT INTO indayt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Dia mengandung dan melahirkan anak laki-laki, lalu dia berkata, “Allah telah membuang aibku.” ");
INSERT INTO indayt_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rahel menamainya Yusuf, katanya, “Kiranya TUHAN menambahkan bagiku anak laki-laki lainnya.” ");
INSERT INTO indayt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ketika Rahel telah melahirkan Yusuf, Yakub berkata kepada Laban, “Lepaskanlah aku supaya aku dapat kembali ke tempat asalku dan ke negeriku. ");
INSERT INTO indayt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Berikanlah istri-istriku dan anak-anakku kepadaku, yang demi mereka, aku telah bekerja padamu, dan biarkan aku pergi. Engkau sendiri tahu pekerjaan yang telah aku kerjakan bagimu.” ");
INSERT INTO indayt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban berkata kepadanya, “Aku mohon kepadamu, jika kamu berkenan, tinggallah denganku sebab aku telah mengamati tanda-tanda bahwa TUHAN memberkatiku karenamu.” ");
INSERT INTO indayt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Lalu, katanya pula, “Sebutkan upahmu kepadaku dan aku akan memberikannya.” ");
INSERT INTO indayt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakub berkata kepadanya, “Engkau sendiri tahu bagaimana aku melayanimu dan bagaimana keadaan ternakmu bersamaku. ");
INSERT INTO indayt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sebab, hanya sedikit yang engkau miliki sebelum aku datang, dan sekarang itu sudah bertambah sangat banyak selama aku di sini. TUHAN telah memberkatimu karena kakiku. Kalau begitu, kapan aku dapat melakukannya untuk rumah tanggaku sendiri?” ");
INSERT INTO indayt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban bertanya, “Apa yang harus kuberikan kepadamu?” Jawab Yakub, “Engkau tidak perlu memberikan apa-apa kepadaku. Aku akan kembali menggembalakan dan menjaga kawanan kambing dombamu, jika engkau mau melakukan hal ini kepadaku: ");
INSERT INTO indayt_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hari ini, izinkan aku berjalan di antara kawanan kambing dombamu untuk memisahkan dari situ setiap domba yang berbintik-bintik dan bertutul, dan setiap anak domba yang berwarna gelap, dan setiap kambing yang bertutul atau berbintik-bintik. Itulah yang akan menjadi upahku. ");
INSERT INTO indayt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kelak, kebenaranku itu menjadi saksi bagiku, ketika engkau datang untuk memeriksa upahku. Semua yang tidak berbintik-bintik atau bertutul di antara kambing-kambing itu, dan yang tidak berwarna gelap di antara domba-domba itu, itu akan diperhitungkan sebagai curianku.” ");
INSERT INTO indayt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban menjawab, “Baiklah! Jadilah seperti yang kaukatakan itu.” ");
INSERT INTO indayt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Namun, pada hari itu, dia memisahkan kambing-kambing jantan yang bergaris-garis dan bertutul, dan semua kambing betina yang berbintik-bintik dan bertutul, semua yang ada warna putih pada badannya. Dia juga memisahkan semua domba yang berwarna gelap, lalu Laban menyerahkannya ke tangan anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kemudian, dia mengambil jarak antara dirinya dengan Yakub selama tiga hari perjalanan, sementara Yakub menggembalakan sisanya dari kawanan kambing domba Laban. ");
INSERT INTO indayt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kemudian, Yakub memotong ranting-ranting segar dari pohon hawar, pohon badam, dan pohon berangan, lalu dia mengupas belang-belang putihnya sehingga terlihatlah warna putih pada ranting-ranting itu. ");
INSERT INTO indayt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Dia meletakkan ranting-ranting yang telah dikupasnya di depan kawanan kambing domba itu, di palungan-palungan, di penampungan-penampungan air, tempat kawanan itu datang untuk minum. Biasanya, mereka saling kawin ketika mereka datang untuk minum. ");
INSERT INTO indayt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ketika kawanan itu kawin di depan ranting-ranting itu, kawanan itu melahirkan yang bergaris-garis, berbintik-bintik, dan bertutul. ");
INSERT INTO indayt_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakub memisahkan anak-anak domba dan menghadapkan kawanan itu ke arah yang bergaris-garis dan semua yang berwarna gelap dari kawanan domba milik Laban. Dia memisahkan kawanan dombanya dari milik Laban. ");
INSERT INTO indayt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Setiap kali yang lebih kuat dari kawanan itu kawin, Yakub akan meletakkan ranting-ranting di depan mata kawanan itu sehingga mereka bisa kawin dekat ranting-ranting itu. ");
INSERT INTO indayt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Namun, dia tidak meletakkannya di depan kawanan yang lemah. Karena itu, yang lemah adalah milik Laban, sedangkan yang kuat adalah milik Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Dengan demikian, Yakub bertambah kaya raya. Dia mempunyai banyak sekali kawanan kambing domba, hamba laki-laki dan hamba perempuan, unta, dan keledai. ");
INSERT INTO indayt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pada suatu hari, Yakub mendengar perkataan anak-anak Laban, katanya, “Yakub telah mengambil segala milik ayah kita, dan dari milik ayah kita itu, dia membangun seluruh kekayaan ini.” ");
INSERT INTO indayt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakub memperhatikan wajah Laban, tampaknya tidak lagi seperti dahulu terhadapnya. ");
INSERT INTO indayt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lalu, berkatalah TUHAN kepada Yakub, “Kembalilah ke tanah nenek moyangmu, dan kepada keluargamu, dan Aku akan menyertaimu.” ");
INSERT INTO indayt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Setelah itu, Yakub menyuruh orang untuk memanggil Rahel dan Lea ke tempat kawanan kambing dombanya, di padang. ");
INSERT INTO indayt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Dia berkata kepada mereka, “Aku memperhatikan bahwa wajah ayahmu terhadapku tidak lagi seperti dahulu. Akan tetapi, Allah ayahku menyertaiku. ");
INSERT INTO indayt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kalian tahu bahwa dengan sekuat tenaga aku sudah bekerja pada ayahmu. ");
INSERT INTO indayt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Namun, ayahmu telah menipuku dan mengubah upahku sebanyak sepuluh kali. Akan tetapi, Allah tidak membiarkannya menjahatiku. ");
INSERT INTO indayt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Jika dia berkata, ‘Yang berbintik-bintik akan menjadi upahmu,’ seluruh kawanan itu pun melahirkan yang berbintik-bintik. Jika dia berkata, ‘Yang bergaris-garis akan menjadi upahmu,’ seluruh kawanan itu pun melahirkan yang bergaris-garis. ");
INSERT INTO indayt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Demikianlah Allah mengambil ternak ayahmu dan memberikannya kepadaku. ");
INSERT INTO indayt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Pada musim kawin ternak, aku mengarahkan mataku dan melihat dalam mimpi, tampaklah kambing-kambing jantan yang sedang kawin adalah yang bergaris-garis, berbintik-bintik, dan bertutul. ");
INSERT INTO indayt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kemudian, Malaikat Allah berkata kepadaku dalam mimpi, ‘Yakub!’ Aku menjawab, ‘Ya.’ ");
INSERT INTO indayt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Dia berkata, ‘Sekarang, angkatlah matamu dan lihatlah bahwa kambing-kambing jantan yang sedang kawin itu adalah yang bergaris-garis, berbintik-bintik, dan bertutul karena Aku telah melihat semua yang dilakukan Laban terhadapmu. ");
INSERT INTO indayt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Akulah Allah yang di Betel, tempat kamu mencurahkan minyak pada sebuah tugu, dan di sana kamu membuat suatu sumpah kepada-Ku. Sekarang, bangkitlah, tinggalkan tanah ini, dan kembalilah ke tanah kelahiranmu.’” ");
INSERT INTO indayt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahel dan Lea berkata kepada Yakub, “Apakah masih ada bagian atau warisan bagi kami dalam rumah ayah kami? ");
INSERT INTO indayt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bukankah kami ini dianggapnya orang asing? Sebab, dia telah menjual kami dan telah menghabiskan uang kami itu. ");
INSERT INTO indayt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Karena itu, segala kekayaan yang diambil Allah dari ayah kami adalah milik kami dan anak-anak kami. Sekarang, lakukanlah apa pun yang dikatakan Allah kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Lalu, Yakub bersiap dan menaikkan anak-anaknya dan istri-istrinya ke atas unta. ");
INSERT INTO indayt_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Dia membawa seluruh kawanan ternaknya, yaitu kawanan ternak yang diperolehnya di Padan-Aram, dan segala harta benda yang dikumpulkannya untuk pergi kepada Ishak, ayahnya, di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ketika Laban pergi untuk mengguntingi bulu domba-dombanya, Rahel mencuri terafim ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakub diam-diam pergi di luar kesadaran Laban, orang Aram itu, dengan tidak memberitahukan kepadanya bahwa dia melarikan diri. ");
INSERT INTO indayt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jadi, dia melarikan diri dengan segala yang dimilikinya. Dia berangkat, dan menyeberangi sungai, dan mengarahkan pandangannya ke arah pegunungan Gilead. ");
INSERT INTO indayt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Pada hari yang ketiga, dikabarkanlah hal ini kepada Laban bahwa Yakub telah melarikan diri. ");
INSERT INTO indayt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Jadi, dia mengumpulkan saudara-saudaranya dan mengejar Yakub selama tujuh hari, sampai mereka dapat menyusulnya di pegunungan Gilead. ");
INSERT INTO indayt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Malam itu Allah datang kepada Laban, orang Aram itu, dalam mimpi dan berkata kepadanya, “Berhati-hatilah, jangan katakan apa pun kepada Yakub, entah itu baik atau buruk!” ");
INSERT INTO indayt_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban pun menyusul Yakub. Ketika Yakub memasang tendanya di pegunungan itu, Laban dan saudara-saudaranya pun memasang tendanya di pegunungan Gilead. ");
INSERT INTO indayt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban berkata kepada Yakub, “Apa yang kaulakukan ini dengan pergi diam-diam di luar kesadaranku dan membawa anak-anak perempuanku seperti orang yang ditawan dengan pedang? ");
INSERT INTO indayt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mengapa kamu melarikan diri dan pergi dariku secara diam-diam, dan tidak mengatakannya kepadaku supaya aku dapat melepasmu dengan sukacita diiringi nyanyian dengan tamborin dan harpa? ");
INSERT INTO indayt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kamu bahkan tidak memberiku kesempatan untuk mencium cucu-cucuku dan anak-anak perempuanku? Kali ini, kamu sudah bertindak bodoh. ");
INSERT INTO indayt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ada kuasa dalam tanganku untuk berbuat jahat terhadapmu, tetapi tadi malam, Allah ayahmu berkata kepadaku, ‘Berhati-hatilah, jangan katakan apa pun kepada Yakub, entah itu baik atau buruk!’ ");
INSERT INTO indayt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sekarang, memang kamu benar-benar telah pergi karena kamu sangat merindukan rumah ayahmu, tetapi mengapa kamu mencuri ilah-ilahku?” ");
INSERT INTO indayt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakub menjawab dan berkata kepada Laban, “Sebab, aku takut. Aku pikir, jangan-jangan engkau akan merebut anak-anakmu dariku. ");
INSERT INTO indayt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Namun, pada siapa pun engkau menemukan ilah-ilahmu itu, dia tidak akan hidup lagi. Di hadapan saudara-saudara kita, periksalah milikmu, apakah ada padaku dan ambillah itu untukmu.” Yakub tidak tahu bahwa Rahellah yang mencurinya. ");
INSERT INTO indayt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lalu, masuklah Laban ke dalam tenda Yakub, dan tenda Lea, dan tenda kedua hambanya, tetapi dia tidak menemukannya. Kemudian, dia keluar dari tenda Lea dan masuk ke dalam tenda Rahel. ");
INSERT INTO indayt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel telah mengambil terafim itu dan memasukannya ke dalam pelana unta, lalu dia duduk di atasnya. Laban menggeledah seluruh tenda, tetapi dia tidak menemukannya. ");
INSERT INTO indayt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel berkata kepada ayahnya, “Tuanku, janganlah marah terhadapku. Aku tidak sanggup berdiri di hadapanmu karena hal yang biasa bagi perempuan sedang terjadi atasku.” Laban mencari, tetapi dia tidak menemukan terafim itu. ");
INSERT INTO indayt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakub menjadi marah dan bertengkar dengan Laban. Yakub berkata kepada Laban, “Apa pelanggaranku? Apa dosaku sampai engkau mengejarku segigih ini? ");
INSERT INTO indayt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ketika engkau menggeledah semua barangku, apakah engkau menemukan semua barang rumahmu? Letakkanlah itu di sini, di hadapan saudara-saudaraku dan saudara-saudaramu supaya mereka dapat memutuskannya di antara kita berdua. ");
INSERT INTO indayt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Selama dua puluh tahun aku bersamamu, domba-domba betina dan kambing-kambing betinamu tidak pernah keguguran dan aku juga tidak memakan domba-domba jantan dari kawanan kambing dombamu. ");
INSERT INTO indayt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Yang dicabik-cabik oleh binatang buas tidak kubawa kepadamu, aku sendiri yang menggantinya. Yang dicuri pada waktu siang atau malam pun, engkau tuntut dari tanganku. ");
INSERT INTO indayt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aku ini, dilahap oleh panas pada siang hari dan oleh dingin pada malam hari. Tidur pun menjauh dari mataku. ");
INSERT INTO indayt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Selama dua puluh tahun aku berada di rumahmu: Aku bekerja padamu selama empat belas tahun untuk dua anak perempuanmu dan enam tahun untuk ternakmu. Selama itu, engkau mengubah upahku sebanyak sepuluh kali. ");
INSERT INTO indayt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Seandainya Allah ayahku, yaitu Allah Abraham, Yang Ditakuti oleh Ishak, tidak menyertaiku, tentu engkau sudah membiarkanku pergi dengan tangan kosong. Allah telah memperhatikan kesusahan dan kerja keras tanganku sehingga Dia menegurmu tadi malam.” ");
INSERT INTO indayt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban menjawab dan berkata kepada Yakub, “Anak-anak perempuan ini adalah anakku, anak-anak itu adalah cucuku, kawanan kambing domba itu adalah kawananku, dan segala yang kaulihat adalah milikku. Namun, apa yang dapat aku lakukan hari ini untuk anak-anak perempuanku atau untuk anak-anak yang telah mereka lahirkan? ");
INSERT INTO indayt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Oleh sebab itu, mari kita membuat perjanjian, antara aku dan kamu. Biarlah ini menjadi saksi antara aku dan kamu.” ");
INSERT INTO indayt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lalu, Yakub mengambil sebongkah batu dan didirikannya menjadi sebuah tugu. ");
INSERT INTO indayt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakub berkata kepada saudara-saudaranya, “Kumpulkanlah batu-batu.” Lalu, mereka mengambil batu-batu dan membuat satu tumpukan. Setelah itu, mereka makan di sana, di dekat tumpukan itu. ");
INSERT INTO indayt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban menamai tempat itu Yegar-Sahaduta. Namun, Yakub menamainya Galed. ");
INSERT INTO indayt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban berkata, “Tumpukan batu ini adalah saksi antara aku dan kamu pada hari ini.” Itu sebabnya, Yakub menyebut tempat itu Galed, ");
INSERT INTO indayt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","atau Mizpa, sebab kata Laban, “Biarlah TUHAN mengawasi kau dan aku, ketika kita tidak saling melihat. ");
INSERT INTO indayt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jika kamu menyusahkan anak-anak perempuanku atau mengambil istri selain dari anak-anak perempuanku ini, walaupun tidak ada yang bersama dengan kita, ingatlah, Allah adalah saksi antara aku dan kamu.” ");
INSERT INTO indayt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban berkata kepada Yakub, “Lihatlah tumpukan batu ini dan tugu yang sudah kudirikan di antara aku dan kamu. ");
INSERT INTO indayt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tumpukan batu ini adalah saksi dan tugu ini juga adalah saksi bahwa aku tidak akan melewati tumpukan batu ini kepadamu, dan kamu tidak akan melewati tumpukan batu dan tugu ini kepadaku untuk niat jahat. ");
INSERT INTO indayt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Allah Abraham dan Allah Nahor, Allah nenek moyang mereka, yang mengadili di antara kita.” Yakub bersumpah demi Yang Ditakuti oleh ayahnya, Ishak. ");
INSERT INTO indayt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kemudian, Yakub mempersembahkan kurban di pegunungan itu dan mengundang saudara-saudaranya untuk makan roti. Mereka makan roti dan bermalam di pegunungan itu. ");
INSERT INTO indayt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Keesokan harinya, pagi-pagi benar, Laban bangun dan mencium cucu-cucunya dan anak-anak perempuannya serta memberkati mereka. Kemudian, Laban berangkat untuk kembali ke tempat tinggalnya. ");
INSERT INTO indayt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakub melanjutkan perjalanannya, lalu para malaikat Allah menemuinya. ");
INSERT INTO indayt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ketika Yakub melihat mereka, dia berkata, “Tempat ini adalah perkemahan Allah!” Jadi, Yakub menamai tempat itu Mahanaim. ");
INSERT INTO indayt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Kemudian, Yakub mengirim beberapa utusan di depannya kepada Esau, kakaknya, di tanah Seir, negeri Edom. ");
INSERT INTO indayt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Dia memerintahkan kepada mereka, katanya, “Beginilah harus kamu katakan kepada tuanku, Esau, ‘Hambamu, Yakub, berkata: Aku telah tinggal sementara dengan Laban dan tinggal di sana sampai sekarang. ");
INSERT INTO indayt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aku mempunyai sapi, keledai, kawanan kambing domba, hamba laki-laki dan hamba perempuan, dan aku telah mengutus untuk memberitahukan kepada Tuan supaya aku mendapat perkenanan di matamu.’” ");
INSERT INTO indayt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Para utusan itu kembali kepada Yakub dan berkata, “Kami telah pergi kepada kakakmu, Esau. Pada saat ini, dia sedang datang beserta empat ratus laki-laki untuk menemuimu.” ");
INSERT INTO indayt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakub menjadi sangat ketakutan dan tertekan. Dia membagi orang-orang yang ada bersamanya, kawanan kambing domba, ternak, dan unta ke dalam dua kelompok. ");
INSERT INTO indayt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sebab, dia berpikir, “Jika Esau mendatangi kelompok yang satu dan menyerangnya, kelompok yang tinggal akan meloloskan diri.” ");
INSERT INTO indayt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kemudian, Yakub berkata, “Ya Allah nenek moyangku, Abraham, Allah ayahku, Ishak, ya TUHAN yang berkata kepadaku, ‘Kembalilah ke negerimu dan kepada keluargamu, dan Aku akan melakukan yang baik kepadamu,’ ");
INSERT INTO indayt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","aku tidak layak akan segala kebaikan dan segala kesetiaan yang Engkau nyatakan kepada hamba-Mu ini. Karena hanya dengan tongkatku, aku menyeberangi Sungai Yordan ini, tetapi sekarang aku telah menjadi dua kelompok. ");
INSERT INTO indayt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aku mohon, lepaskanlah aku dari tangan kakakku, dari tangan Esau, sebab aku takut terhadapnya. Jangan-jangan dia akan datang menyerangku dan para ibu dengan anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Engkau pernah berkata, ‘Aku pasti akan melakukan yang baik dan membuat keturunanmu seperti pasir di laut, yang tidak terhitung karena banyaknya.’” ");
INSERT INTO indayt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakub tinggal di sana pada malam itu dan dia mengambil hadiah untuk kakaknya, Esau, dari apa yang ada padanya: ");
INSERT INTO indayt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 ekor kambing betina dan 20 ekor kambing jantan, 200 ekor domba betina dan 20 ekor domba jantan, ");
INSERT INTO indayt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ekor unta yang sedang menyusui beserta anak-anaknya, 40 ekor sapi betina dan 10 ekor sapi jantan, 20 ekor keledai betina dan 10 ekor keledai jantan. ");
INSERT INTO indayt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Dia memberikan itu ke tangan hamba-hambanya, setiap kelompok secara tersendiri. Kemudian, dia berkata kepada hamba-hambanya, “Dahuluilah aku dan jagalah jarak antara kelompok yang satu dengan kelompok yang lain.” ");
INSERT INTO indayt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Dia memberikan perintah kepada hambanya yang paling depan, katanya, “Ketika Esau, kakakku, bertemu denganmu dan bertanya kepadamu, ‘Siapakah kamu? Ke manakah kamu pergi? Milik siapakah yang ada di depanmu itu?’ ");
INSERT INTO indayt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","kamu harus menjawab, ‘Milik hambamu, Yakub. Ini adalah hadiah yang dikirimnya untuk Tuanku, Esau. Lihatlah, dia sendiri juga ada di belakang kami.’” ");
INSERT INTO indayt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakub memerintahkannya juga kepada yang kedua dan yang ketiga, dan kepada semua yang mengikuti kelompok-kelompok itu, katanya, “Seperti itulah perkataan yang harus kamu ucapkan kepada Esau ketika kamu bertemu dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kamu juga harus berkata, ‘Lihatlah, hambamu, Yakub, ada di belakang kami.’” Sebab, dia berpikir, “Aku akan menenangkannya dengan hadiah yang mendahuluiku. Kemudian, aku akan memandang wajahnya dan mungkin dia akan menerima.” ");
INSERT INTO indayt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jadi, hadiah itu mendahuluinya sementara dia sendiri bermalam di perkemahan. ");
INSERT INTO indayt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Pada malam itu, dia bangun dan mengambil kedua istrinya, kedua hamba perempuannya, dan kesebelas anak laki-lakinya untuk menyeberangi penyeberangan Yabok. ");
INSERT INTO indayt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Dia membawa mereka dan menyeberangkan mereka melintasi aliran sungai. Lalu, dia menyeberangkan semua miliknya. ");
INSERT INTO indayt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Lalu, Yakub tinggal sendirian dan ada Seseorang yang bergulat dengannya sampai fajar. ");
INSERT INTO indayt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ketika Orang itu melihat bahwa Dia tidak dapat mengalahkan Yakub, Dia memukul pangkal paha Yakub sehingga pangkal pahanya terkilir ketika bergulat dengan-Nya. ");
INSERT INTO indayt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kemudian, Dia berkata, “Biarkan Aku pergi karena matahari telah terbit.” Akan tetapi, Yakub berkata, “Aku tidak akan membiarkan Engkau pergi, kecuali Engkau memberkatiku.” ");
INSERT INTO indayt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Orang itu berkata kepada Yakub, “Siapa namamu?” Yakub menjawab, “Yakub.” ");
INSERT INTO indayt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kemudian, Dia berkata, “Namamu bukan lagi Yakub, melainkan Israel sebab kamu telah bergulat dengan Allah dan manusia, dan kamu menang.” ");
INSERT INTO indayt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kemudian, Yakub bertanya kepadanya, “Aku mohon, beritahukanlah nama-Mu kepadaku.” Akan tetapi, Dia berkata, “Mengapa kamu menanyakan nama-Ku?” Kemudian, orang itu memberkati Yakub di situ. ");
INSERT INTO indayt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jadi, Yakub menamakan tempat itu Pniel, katanya, “Aku telah bertemu Allah, muka dengan muka, tetapi nyawaku diselamatkan.” ");
INSERT INTO indayt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Matahari sudah terbit atasnya ketika dia melewati Pniel dan dia pincang pada pangkal pahanya. ");
INSERT INTO indayt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Itulah sebabnya, sampai hari ini umat Israel tidak makan urat daging yang terdapat pada pangkal paha karena Dia telah memukul pangkal paha Yakub pada otot pahanya. ");
INSERT INTO indayt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakub mengarahkan matanya dan mengamat-amati. Lihat, Esau datang beserta empat ratus orang laki-laki. Kemudian, Yakub membagi anak-anaknya kepada Lea, dan kepada Rahel, dan kepada kedua hamba perempuannya. ");
INSERT INTO indayt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakub menempatkan kedua hamba perempuannya dan anak-anak mereka di depan. Setelah itu, Lea dan anak-anaknya. Yang terakhir adalah Rahel dan Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakub sendiri berjalan di depan mereka dan berlutut ke tanah sebanyak tujuh kali sampai dia tiba di dekat kakaknya. ");
INSERT INTO indayt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kemudian, Esau berlari menyongsongnya, memeluknya, merangkul lehernya, dan menciumnya, lalu mereka menangis. ");
INSERT INTO indayt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Setelah itu, dia mengarahkan matanya dan melihat perempuan-perempuan dan anak-anak itu. Dia berkata, “Siapakah mereka yang bersamamu ini?” Yakub menjawab, “Inilah anak-anak, yang dengan kemurahan hati telah dikaruniakan Allah kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kemudian, kedua hamba perempuan itu mendekat, mereka dan anak-anaknya, lalu mereka berlutut. ");
INSERT INTO indayt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea beserta anak-anaknya juga mendekat, lalu mereka berlutut. Setelah itu, mendekatlah Yusuf beserta Rahel, lalu mereka berlutut. ");
INSERT INTO indayt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau berkata, “Apa maksudmu dengan semua iring-iringan yang aku jumpai tadi?” Yakub menjawab, “Untuk memperoleh kemurahan di matamu, Tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Namun, Esau berkata, “Aku telah punya banyak, Adikku. Simpanlah yang kamu miliki ini untuk dirimu sendiri.” ");
INSERT INTO indayt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakub berkata, “Tidak! Aku mohon, jika pada saat ini aku memperoleh kemurahan di matamu, terimalah hadiah dari tanganku ini. Sebab, aku telah melihat wajahmu bagaikan aku telah melihat wajah Allah, dan engkau berkenan kepadaku. ");
INSERT INTO indayt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Aku mohon, terimalah berkatku yang dibawa kepadamu ini karena Allah telah bermurah hati kepadaku, dan karena aku mempunyai segalanya.” Yakub mendesaknya dan Esau pun menerimanya. ");
INSERT INTO indayt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kemudian, Esau berkata, “Mari kita melakukan perjalanan dan berangkat. Aku akan pergi mendahuluimu.” ");
INSERT INTO indayt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Namun, Yakub berkata kepadanya, “Tuanku mengetahui bahwa anak-anak ini masih lemah, dan besertaku ada pula kawanan kambing domba dan ternak yang masih menyusui. Jika digiring paksa selama sehari saja, semua kawanan itu akan mati. ");
INSERT INTO indayt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jadi, silakan tuanku mendahului hambamu ini. Aku akan menyusul pelan-pelan mengikuti langkah ternak di depanku, dan mengikuti langkah anak-anak hingga aku tiba kepada tuanku di Seir.” ");
INSERT INTO indayt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Lalu, Esau berkata, “Kalau begitu, biarlah kutinggalkan bersamamu beberapa orang yang menyertaiku ini.” Akan tetapi, Yakub menjawab, “Apakah perlunya hal itu? Biarlah aku memperoleh kemurahan hati di mata tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Jadi, pada hari itu, Esau kembali ke perjalanannya menuju Seir. ");
INSERT INTO indayt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sementara itu, Yakub berangkat ke Sukot dan mendirikan rumah bagi dirinya dan membuat pondok-pondok dari daun bagi ternaknya. Itulah sebabnya, tempat itu dinamakan Sukot. ");
INSERT INTO indayt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakub tiba dengan selamat di kota Sikhem, di tanah Kanaan, ketika dia tiba dari Padan-Aram. Lalu, dia mendirikan tendanya di depan kota itu. ");
INSERT INTO indayt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Dia membeli sebidang tanah, tempat dia mendirikan tendanya dari tangan keturunan Hemor, ayah Sikhem, seharga 100 kesita. ");
INSERT INTO indayt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Dia mendirikan mazbah di situ dan menyebutnya, “Allah Israel adalah Allah.” ");
INSERT INTO indayt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pada suatu hari, Dina, anak perempuan Lea, yang dilahirkannya bagi Yakub, pergi untuk mengunjungi anak-anak perempuan di negeri itu. ");
INSERT INTO indayt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ketika Sikhem, anak Hemor, orang Hewi, pemimpin negeri itu, melihat Dina, dia membawanya dan menidurinya, lalu memerkosanya. ");
INSERT INTO indayt_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Namun, jiwanya terpaut kepada gadis itu, anak perempuan Yakub. Dia mencintai gadis itu dan berbicara dengan lembut kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Lalu, Sikhem berkata kepada Hemor, ayahnya, “Dapatkanlah gadis itu bagiku untuk menjadi istriku.” ");
INSERT INTO indayt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakub mendengar bahwa dia telah menodai Dina, anak perempuannya. Namun, anak-anak laki-lakinya sedang bersama ternak di padang sehingga Yakub tetap diam sampai mereka pulang. ");
INSERT INTO indayt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kemudian, Hemor, ayah Sikhem, pergi kepada Yakub untuk berbicara dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anak-anak Yakub baru kembali dari padang ketika mendengar tentang hal ini sehingga orang-orang itu merasa sakit hati dan sangat terbakar kemarahannya karena Sikhem telah berbuat aib di antara orang Israel dengan meniduri anak perempuan Yakub. Hal itu tidak pantas untuk dilakukan. ");
INSERT INTO indayt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Akan tetapi, Hemor berkata kepada mereka, katanya, “Jiwa anakku, Sikhem, telah terpaut kepada anak perempuanmu. Aku mohon, berikanlah anak perempuanmu itu kepadanya untuk menjadi istrinya. ");
INSERT INTO indayt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Marilah kita saling berbesan. Berikanlah anak perempuanmu kepada kami dan ambillah anak-anak perempuan kami bagimu. ");
INSERT INTO indayt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Dengan demikian, kamu dapat tinggal bersama kami. Tanah ini ada di hadapanmu, tinggallah, berdaganglah, dan kumpulkanlah hartamu dari itu.” ");
INSERT INTO indayt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kemudian, Sikhem berkata kepada ayah perempuan itu dan kepada saudara-saudaranya, “Biarlah aku mendapatkan kemurahan di matamu dan apa pun yang kamu katakan kepadaku, aku akan memberikannya. ");
INSERT INTO indayt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bebankanlah sebanyak mungkin maskawin dan hadiah kepadaku, maka aku akan memberikannya sesuai dengan yang engkau katakan kepadaku. Hanya, berikanlah gadis itu kepadaku sebagai istri.” ");
INSERT INTO indayt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Karena adik perempuan mereka telah dinodai, para anak laki-laki Yakub menjawab Sikhem dan Hemor, ayahnya, dengan tipu daya. ");
INSERT INTO indayt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kata mereka, “Kami tidak dapat melakukan hal ini, yaitu menyerahkan adik kami kepada seorang laki-laki yang tidak bersunat karena hal itu akan menjadi aib bagi kami. ");
INSERT INTO indayt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hanya dengan syarat ini kami akan setuju denganmu, yaitu seluruh laki-laki di antaramu harus disunat. ");
INSERT INTO indayt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Setelah itu, kami akan memberikan anak-anak perempuan kami kepadamu dan kami akan mengambil anak-anak perempuanmu bagi kami. Lalu, kami akan tinggal bersamamu dan kita akan menjadi satu bangsa. ");
INSERT INTO indayt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Namun, jika kamu tidak mendengarkan kami, untuk disunat, kami akan mengambil anak perempuan kami dan kami akan pergi.” ");
INSERT INTO indayt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Perkataan mereka dipandang baik oleh Hemor dan dipandang baik oleh Sikhem, anak Hemor. ");
INSERT INTO indayt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Pemuda itu tidak menunda-nunda untuk melakukannya karena dia sangat menginginkan anak perempuan Yakub itu dan dialah yang paling dihormati di antara keluarga ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Lalu, Hemor dan Sikhem, anaknya, pergi ke gerbang kotanya untuk berbicara kepada para laki-laki di kota itu, katanya ");
INSERT INTO indayt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Orang-orang ini bersahabat dengan kita. Karena itu, biarlah mereka tinggal di tanah kita dan berdagang di dalamnya. Sebab, lihatlah, tanah ini masih cukup luas bagi mereka. Marilah kita mengambil anak-anak perempuan mereka sebagai istri, dan biarlah kita memberikan anak-anak perempuan kita kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Hanya dengan syarat inilah orang-orang itu sepakat untuk tinggal bersama kita untuk menjadi satu bangsa, yaitu setiap laki-laki di antara kita harus disunat, sama seperti mereka juga telah disunat. ");
INSERT INTO indayt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bukankah nantinya ternak mereka, harta mereka, dan segala hewan mereka akan menjadi milik kita? Jadi, mari kita sepakat dengan mereka, lalu mereka akan tinggal bersama kita.” ");
INSERT INTO indayt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Semua laki-laki yang pergi ke gerbang kota itu mendengarkan Hemor dan Sikhem, anaknya. Oleh karena itu, setiap laki-laki disunat, yaitu semua yang pergi ke gerbang kotanya itu. ");
INSERT INTO indayt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tiga hari kemudian, sewaktu mereka masih kesakitan, dua orang dari anak laki-laki Yakub, yaitu Simeon dan Lewi, kakak-kakak Dina, mengambil pedangnya masing-masing, dan memasuki kota itu dengan berani, lalu mereka membunuh semua laki-laki itu. ");
INSERT INTO indayt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Mereka juga membunuh Hemor dan anaknya, Sikhem, dengan mata pedang. Kemudian, mereka membawa Dina keluar dari rumah Sikhem dan pergi. ");
INSERT INTO indayt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Anak-anak Yakub mendatangi mereka yang terbunuh itu dan menjarah kota itu karena mereka telah menodai adik perempuannya. ");
INSERT INTO indayt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Mereka mengambil kawanan domba, ternak, dan keledainya, apa saja yang masih ada di kota itu, dan yang ada di ladang, ");
INSERT INTO indayt_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","seluruh kekayaannya, semua anaknya, dan istri-istrinya, bahkan menjarah segala sesuatu yang ada di dalam rumah. ");
INSERT INTO indayt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Akan tetapi, Yakub berkata kepada Simeon dan Lewi, “Kamu telah menyusahkan aku dengan membusukkanku di antara penduduk negeri ini, di antara orang Kanaan dan orang Feris. Orang-orangku hanya sedikit jumlahnya, sedangkan mereka akan bergabung untuk melawanku dan menyerangku, dan aku pun akan dibinasakan, aku dan seisi rumahku.” ");
INSERT INTO indayt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Namun, mereka berkata, “Haruskah dia memperlakukan adik perempuan kami seperti perempuan sundal?” ");
INSERT INTO indayt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Allah berfirman kepada Yakub, “Bangunlah, pergilah ke Betel dan tinggallah di sana. Lalu, buatlah sebuah mazbah bagi Allah yang telah menampakkan diri kepadamu, ketika kamu melarikan diri dari kakakmu, Esau.” ");
INSERT INTO indayt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kemudian, Yakub berkata kepada seisi rumahnya dan kepada semua yang bersamanya, “Singkirkanlah ilah-ilah lain yang ada di antara kalian, dan bersihkanlah dirimu, lalu gantilah pakaianmu. ");
INSERT INTO indayt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mari kita bersiap-siap dan pergi ke Betel. Di sana, aku akan membuat sebuah mazbah bagi Allah yang menjawabku pada masa kesulitanku dan yang menyertaiku ke mana pun aku pergi.” ");
INSERT INTO indayt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kemudian, mereka menyerahkan segala ilah lain yang ada di tangan mereka dan anting-anting yang ada di telinga mereka kepada Yakub, lalu Yakub menanamnya di bawah pohon tarbantin, yang terletak di dekat Sikhem. ");
INSERT INTO indayt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Lalu, mereka berangkat dan kengerian dari Allah menimpa kota-kota di sekelilingnya sehingga mereka tidak mengejar keturunan Yakub itu. ");
INSERT INTO indayt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakub tiba di Lus, yaitu Betel, yang terletak di tanah Kanaan, dia dan semua orang yang besertanya. ");
INSERT INTO indayt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakub membangun sebuah mazbah di sana dan menamai tempat itu “El-Betel” karena di tempat itulah Allah menampakkan diri kepadanya, ketika dia melarikan diri dari kakaknya. ");
INSERT INTO indayt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Lalu, Debora, pengasuh Ribka, mati di sana dan dia dikuburkan di bawah Betel, di bawah pohon tarbantin sehingga namanya disebut “Alon-Bakut”. ");
INSERT INTO indayt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kemudian, Allah kembali menampakkan diri kepada Yakub dan memberkatinya, ketika dia datang dari Padan-Aram. ");
INSERT INTO indayt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allah berfirman kepadanya, “Namamu Yakub, namamu tidak lagi akan disebut Yakub, melainkan Israel yang akan menjadi namamu.” Jadi, Dia menamainya Israel. ");
INSERT INTO indayt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Allah berfirman kepadanya, “Akulah Allah Yang Mahakuasa, beranakcuculah dan berlipatgandalah: satu bangsa dan sekumpulan bangsa akan berasal darimu, dan raja-raja akan datang dari tubuhmu sendiri. ");
INSERT INTO indayt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tanah yang Kuberikan kepada Abraham dan Ishak akan Kuberikan kepadamu, bahkan Aku akan memberikan tanah ini kepada keturunanmu yang akan datang.” ");
INSERT INTO indayt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kemudian, naiklah Allah dari padanya, dari tempat Dia berfirman kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Lalu, Yakub mendirikan sebuah tugu di tempat itu, tempat Allah telah berfirman kepadanya, sebuah tugu batu. Lalu, dia mencurahkan persembahan minuman ke atasnya dan dia mencurahkan minyak ke atasnya. ");
INSERT INTO indayt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Lalu, Yakub menamai tempat itu, tempat Allah telah berfirman kepadanya, Betel. ");
INSERT INTO indayt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Lalu, mereka berangkat dari Betel. Ketika tidak terlalu jauh lagi jarak menuju Efrata, Rahel melahirkan, tetapi dia mengalami kesulitan untuk melahirkan. ");
INSERT INTO indayt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ketika dia sangat kesulitan untuk melahirkan, orang yang membantunya melahirkan berkata kepadanya, “Jangan takut sebab kamu mendapatkan anak laki-laki lagi.” ");
INSERT INTO indayt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ketika nyawanya hampir melayang, dia menyebut nama anaknya, Ben-Oni, lalu dia pun mati. Namun, ayahnya menamainya Benyamin. ");
INSERT INTO indayt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Demikianlah Rahel mati dan dikuburkan di jalan menuju ke Efrata, yaitu Betlehem. ");
INSERT INTO indayt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakub mendirikan sebuah tugu di atas kuburnya, dan itulah tugu kubur Rahel sampai hari ini. ");
INSERT INTO indayt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kemudian, Israel berangkat dan mendirikan tendanya di luar Migdal-Eder. ");
INSERT INTO indayt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ketika Israel tinggal di tanah itu, Ruben bersetubuh dengan Bilha, gundik ayahnya, dan Israel mendengarnya. Saat itu, anak laki-laki Yakub berjumlah dua belas orang. ");
INSERT INTO indayt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Anak-anak Lea adalah Ruben, anak sulung Yakub, kemudian Simeon, Lewi, Yehuda, Isakhar, dan Zebulon. ");
INSERT INTO indayt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Anak-anak Rahel adalah Yusuf dan Benyamin. ");
INSERT INTO indayt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Anak-anak Bilha, hamba Rahel, adalah Dan dan Naftali. ");
INSERT INTO indayt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Anak-anak Zilpa, hamba Lea, adalah Gad dan Asyer. Mereka inilah anak-anak Yakub yang dilahirkan baginya di Padan-Aram. ");
INSERT INTO indayt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Lalu, Yakub datang kepada Ishak, ayahnya, di Mamre, di Kiryat-Arba, yaitu Hebron. Di sinilah Abraham dan Ishak tinggal sementara. ");
INSERT INTO indayt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Umur Ishak adalah 180 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Kemudian, hidup Ishak berakhir dan dia pun mati. Dia dikumpulkan kepada kaumnya, menjadi tua, dan genap hari-harinya. Anak-anaknya, Esau dan Yakub, yang menguburkannya. ");
INSERT INTO indayt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Inilah keturunan Esau, yang adalah Edom. ");
INSERT INTO indayt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau mengambil istri dari anak-anak perempuan Kanaan, yaitu Ada, anak Elon, orang Het; Oholibama, anak Ana, anak perempuan Zibeon, orang Hewi; ");
INSERT INTO indayt_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","dan Basmat, anak Ismael, saudara perempuan Nebayot. ");
INSERT INTO indayt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Lalu, Ada melahirkan Elifas bagi Esau, Basmat melahirkan Rehuel, ");
INSERT INTO indayt_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","dan Oholibama melahirkan Yeush, Yaelam, dan Korah. Inilah anak-anak laki-laki Esau yang dilahirkan baginya di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kemudian, Esau membawa istri-istrinya, anak-anak laki-lakinya, anak-anak perempuannya, dan semua orang di rumahnya, dan ternaknya, dan segala binatangnya, dan segala harta benda miliknya yang diperolehnya di tanah Kanaan, untuk pergi ke tanah yang jauh dari Yakub, adiknya. ");
INSERT INTO indayt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Sebab, harta benda mereka sudah terlalu banyak untuk mereka dapat tinggal bersama-sama, dan tanah tempat tinggal sementara mereka tidak lagi dapat menampung mereka karena ternaknya. ");
INSERT INTO indayt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Jadi, Esau tinggal di pegunungan Seir. Esau adalah Edom. ");
INSERT INTO indayt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Inilah keturunan Esau, nenek moyang orang Edom di pegunungan Seir. ");
INSERT INTO indayt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inilah nama-nama keturunan Esau: Elifas, anak Ada, istri Esau; Rehuel, anak Basmat, istri Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Keturunan Elifas adalah Teman, Omar, Zefo, Gaetam, dan Kenas. ");
INSERT INTO indayt_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna adalah gundik Elifas, anak Esau, dan dia melahirkan Amalek bagi Elifas. Itulah keturunan Ada, istri Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Inilah keturunan Rehuel: Nahat, Zerah, Syama, dan Miza. Itulah keturunan Basmat, istri Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Inilah keturunan Oholibama, anak Ana, anak perempuan Zibeon, istri Esau. Dia melahirkan Yeush, Yaelam, dan Korah bagi Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Inilah para kepala kaum dari keturunan Esau: keturunan Elifas, anak sulung Esau, adalah kepala kaum Teman, kepala kaum Omar, kepala kaum Zefo, dan kepala kaum Kenas, ");
INSERT INTO indayt_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","kepala kaum Korah, kepala kaum Gaetam, dan kepala kaum Amalek. Itulah para kepala kaum yang berasal dari Elifas di tanah Edom, yang adalah keturunan Ada. ");
INSERT INTO indayt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Inilah keturunan Rehuel, anak Esau: kepala kaum Nahat, kepala kaum Zerah, kepala kaum Syama, dan kepala kaum Miza. Itulah para kepala kaum yang berasal dari Rehuel di tanah Edom, yang adalah keturunan Basmat, istri Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Inilah keturunan Oholibama, istri Esau: kepala kaum Yeush, kepala kaum Yaelam, dan kepala kaum Korah. Itulah para kepala kaum yang berasal dari Oholibama, anak perempuan Ana, istri Esau. ");
INSERT INTO indayt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Itulah keturunan Esau, yang adalah Edom, dan itulah para kepala kaumnya. ");
INSERT INTO indayt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Inilah keturunan Seir, orang Hori, yang tinggal di negeri itu: Lotan, Syobal, Zibeon, Ana, ");
INSERT INTO indayt_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disyon, Ezer, dan Disyan. Itulah kepala kaum Hori, keturunan Seir di tanah Edom. ");
INSERT INTO indayt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Keturunan Lotan adalah Hori dan Heman. Saudara perempuan Lotan adalah Timna. ");
INSERT INTO indayt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Inilah keturunan Syobal: Alwan, Manahat, Ebal, Syefo, dan Onam. ");
INSERT INTO indayt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Inilah keturunan Zibeon: Aya dan Ana. Ana inilah yang menemukan sumber-sumber air panas di padang belantara ketika dia menggembalakan keledai-keledai Zibeon, ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Inilah keturunan Ana: Disyon dan Oholibama. ");
INSERT INTO indayt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Inilah keturunan Disyon: Hemdan, Esyban, Yitran, dan Keran. ");
INSERT INTO indayt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Inilah keturunan Ezer: Bilhan, Zaawan, dan Akan. ");
INSERT INTO indayt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Inilah keturunan Disyan: Us dan Aran. ");
INSERT INTO indayt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Inilah para kepala kaum Hori: kepala kaum Lotan, kepala kaum Syobal, kepala kaum Zibeon, kepala kaum Ana, ");
INSERT INTO indayt_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","kepala kaum Disyon, kepala kaum Ezer, dan kepala kaum Disyan. Itulah para kepala kaum yang berasal dari Hori, sesuai dengan kepala kaumnya di tanah Seir. ");
INSERT INTO indayt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Inilah para raja yang memerintah di tanah Edom, sebelum ada raja yang memerintah atas orang Israel. ");
INSERT INTO indayt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, keturunan Beor, memerintah di Edom dan nama kotanya adalah Dinhaba. ");
INSERT INTO indayt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Setelah Bela mati, yang memerintah sebagai penggantinya adalah Yobab, anak Zerah, dari Bozra. ");
INSERT INTO indayt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Setelah Yobab mati, yang memerintah sebagai penggantinya adalah Husyam dari tanah orang Teman. ");
INSERT INTO indayt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Setelah Husyam mati, yang memerintah sebagai penggantinya adalah Hadad, anak Bedad, yang mengalahkan orang Midian di wilayah Moab. Nama kotanya adalah Awit. ");
INSERT INTO indayt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Setelah Hadad mati, yang memerintah sebagai penggantinya adalah Samla dari Masreka. ");
INSERT INTO indayt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Setelah Samla mati, yang memerintah sebagai penggantinya adalah Saul dari Rehobot di dekat sungai. ");
INSERT INTO indayt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Setelah Saul mati, yang memerintah sebagai penggantinya adalah Baal-Hanan, anak Akhbor. ");
INSERT INTO indayt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Setelah Baal-Hanan, anak Akhbor, mati, yang memerintah sebagai penggantinya adalah Hadar, dan nama kotanya adalah Pahu. Nama istrinya adalah Mehetabeel, anak perempuan Matred, anak perempuan Mezahab. ");
INSERT INTO indayt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Inilah nama-nama kepala kaum yang berasal dari Esau, menurut keluarganya, berdasarkan tempat-tempatnya, masing-masing dengan namanya: Kepala kaum Timna, kepala kaum Alwa, kepala kaum Yetet, ");
INSERT INTO indayt_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","kepala kaum Oholibama, kepala kaum Ela, kepala kaum Pinon, ");
INSERT INTO indayt_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","kepala kaum Kenas, kepala kaum Teman, kepala kaum Mibzar, ");
INSERT INTO indayt_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","kepala kaum Magdiel, dan kepala kaum Iram. Itulah para kepala kaum Edom menurut tempat kediamannya di tanah milik mereka. ");
INSERT INTO indayt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub tinggal di tanah tempat ayahnya tinggal sementara, di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Inilah riwayat keturunan Yakub. Yusuf, ketika dia berumur 17 tahun, dia menggembalakan kawanan bersama saudara-saudaranya. Dia bersama dengan anak-anak Bilha dan anak-anak Zilpa, para istri ayahnya. Yusuf menyampaikan laporan tentang kejahatan mereka kepada ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel lebih mengasihi Yusuf daripada semua anak laki-lakinya karena dia adalah anak pada masa tuanya. Dia membuat sehelai jubah yang berwarna-warni untuk Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ketika saudara-saudaranya melihat bahwa ayah mereka mengasihi dia lebih daripada semua saudaranya, mereka pun membencinya dan tidak mau berbicara dengan baik kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Pada suatu waktu, Yusuf mendapat suatu mimpi. Dia menceritakannya kepada saudara-saudaranya dan mereka pun semakin membencinya. ");
INSERT INTO indayt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusuf berkata kepada mereka, “Aku mohon, dengarlah, inilah mimpi yang kumimpikan itu. ");
INSERT INTO indayt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kita tampak sedang mengikat berkas-berkas gandum di ladang. Begini, berkasku bangkit dan juga berdiri tegak. Lalu, tampaklah berkas-berkas gandum kalian mengelilingi dan menyembah berkasku.” ");
INSERT INTO indayt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Saudara-saudaranya berkata kepadanya, “Apa kamu sungguh-sungguh akan memerintah kami? Atau, apa kamu sungguh-sungguh akan menguasai kami?” Mereka pun semakin membencinya karena mimpinya dan karena perkataannya itu. ");
INSERT INTO indayt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusuf bermimpi lagi mimpi yang lain dan menceritakannya kepada saudara-saudaranya, katanya, “Begini, aku bermimpi suatu mimpi lagi. Tampak matahari, dan bulan, dan sebelas bintang menyembahku.” ");
INSERT INTO indayt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Dia menceritakannya kepada ayahnya dan saudara-saudaranya. Namun, ayahnya menegurnya dan berkata kepadanya, “Mimpi apa yang kaumimpikan itu? Apakah aku, dan ibumu, dan saudara-saudaramu harus benar-benar datang untuk berlutut kepadamu sampai ke tanah?” ");
INSERT INTO indayt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Saudara-saudaranya pun iri terhadapnya, tetapi ayahnya menyimpan perkataan itu. ");
INSERT INTO indayt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Pada suatu waktu, saudara-saudaranya pergi untuk menggembalakan kawanan ayahnya di dekat Sikhem. ");
INSERT INTO indayt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Lalu, Israel berkata kepada Yusuf, “Bukankah saudara-saudaramu menggembalakan kawanan di Sikhem? Kemarilah, aku akan mengutusmu kepada mereka.” Dia berkata kepada ayahnya, “Iya, Ayah.” ");
INSERT INTO indayt_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ayahnya berkata kepadanya, “Aku minta, kamu pergi untuk melihat apakah keadaan saudara-saudaramu baik-baik saja dan keadaan kawanan dombanya juga baik-baik saja, lalu berilah kabar kepadaku.” Jadi, ayahnya mengutusnya dari Lembah Hebron dan dia pun tiba di Sikhem. ");
INSERT INTO indayt_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Lalu, seorang laki-laki menemukannya. Ternyata, Yusuf sedang tersesat di padang. Orang itu bertanya kepadanya, “Apa yang kaucari?” ");
INSERT INTO indayt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Dia menjawab, “Aku mencari saudara-saudaraku. Aku mohon, katakanlah kepadaku, di manakah mereka menggembalakan kawanannya?” ");
INSERT INTO indayt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Orang itu berkata, “Mereka telah meninggalkan tempat ini sebab aku mendengar mereka berkata, ‘Mari kita pergi ke Dotan.’” Jadi, Yusuf menyusul saudara-saudaranya dan menemukan mereka di Dotan. ");
INSERT INTO indayt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ketika mereka melihat Yusuf dari jauh dan sebelum dia semakin dekat kepada mereka, mereka bersekongkol untuk membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Mereka berkata satu sama lain, “Lihat, si tukang mimpi datang! ");
INSERT INTO indayt_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Sekarang, ayo kita bunuh dia dan melemparkannya ke salah satu sumur. Kita akan mengatakan bahwa binatang buas telah memangsanya. Setelah itu, kita akan lihat apa yang akan terjadi dengan mimpi-mimpinya itu.” ");
INSERT INTO indayt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Akan tetapi, ketika Ruben mendengar hal itu, dia melepaskan Yusuf dari tangan mereka dan berkata, “Jangan sampai kita membunuhnya.” ");
INSERT INTO indayt_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Agar dia dapat melepaskan Yusuf dari tangan mereka dan membawanya kembali kepada ayahnya, maka Ruben berkata lagi, “Jangan sampai menumpahkan darah, melainkan lempar saja dia ke sumur di padang belantara ini dan jangan meletakkan tangan atasnya.” ");
INSERT INTO indayt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Inilah yang terjadi ketika Yusuf sampai kepada saudara-saudaranya, mereka melucuti jubahnya, jubah berwarna-warni yang dikenakannya itu. ");
INSERT INTO indayt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Lalu, mereka membawanya dan melemparkannya ke dalam sebuah sumur. Sumur itu kosong, tidak ada air di dalamnya. ");
INSERT INTO indayt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Setelah itu, mereka duduk untuk makan roti. Lalu, mereka mengarahkan matanya dan melihat, tampak serombongan orang Ismael yang datang dari Gilead dengan unta-untanya yang mengangkut rempah-rempah, balsam, dan mur untuk dibawa ke Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Lalu, Yehuda berkata kepada saudara-saudaranya, “Jika kita membunuh adik kita dan menyembunyikan darahnya, apa untungnya bagi kita? ");
INSERT INTO indayt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ayo, kita jual saja dia kepada orang Ismael itu dan jangan sampai kita meletakkan tangan atasnya. Bagaimanapun, dia adalah adik kita, daging kita sendiri.” Saudara-saudaranya pun mendengarkannya. ");
INSERT INTO indayt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kemudian, para pedagang Midian lewat. Lalu, saudara-saudaranya menarik dan mengangkat Yusuf keluar dari sumur dan menjual Yusuf kepada orang Ismael seharga 20 syikal perak. Kemudian, mereka membawa Yusuf ke Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben kembali ke sumur, dan ternyata, Yusuf tidak ada di sumur. Lalu, dia pun mengoyak-ngoyak pakaiannya. ");
INSERT INTO indayt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ruben kembali kepada saudara-saudaranya dan berkata, “Anak itu tidak ada! Lalu, aku, ke manakah aku harus pergi?” ");
INSERT INTO indayt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kemudian, mereka mengambil jubah Yusuf dan menyembelih seekor kambing jantan yang berbulu, lalu mencelupkan jubah itu ke dalam darahnya. ");
INSERT INTO indayt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Setelah itu, mereka mengirimkan jubah yang berwarna-warni itu untuk dibawa kepada ayah mereka, katanya, “Kami telah menemukan ini, periksalah, apakah ini jubah anak ayah atau bukan?” ");
INSERT INTO indayt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Dia mengenalinya dan berkata, “Ini jubah anakku! Seekor binatang buas memangsanya! Yusuf pasti sudah tercabik-cabik!” ");
INSERT INTO indayt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kemudian, Yakub mengoyakkan pakaiannya dan mengenakan kain kabung pada pinggangnya, lalu meratapi anaknya itu berhari-hari. ");
INSERT INTO indayt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Semua anaknya, laki-laki maupun perempuan, bangkit untuk menghiburnya, tetapi dia menolak untuk dihibur, dan dia berkata, “Aku akan turun ke dalam dunia orang mati, kepada anakku, untuk berkabung.” Demikianlah, ayahnya menangisinya. ");
INSERT INTO indayt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Sementara itu, di Mesir, para pedagang Midian menjualnya kepada Potifar, pegawai Firaun, kepala para pengawal. ");
INSERT INTO indayt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Pada suatu waktu, Yehuda pergi dari saudara-saudaranya dan mendirikan tenda di dekat tempat seorang Adulam yang bernama Hira. ");
INSERT INTO indayt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Di sana, Yehuda melihat anak perempuan dari seorang Kanaan yang bernama Syua. Lalu, Yehuda mengambilnya dan memperistrinya. ");
INSERT INTO indayt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Perempuan itu pun mengandung dan melahirkan seorang anak laki-laki, lalu Yehuda menamainya Er. ");
INSERT INTO indayt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sesudah itu, perempuan itu mengandung lagi dan melahirkan anak laki-laki lagi, dan dia menamainya Onan. ");
INSERT INTO indayt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kemudian, dia melahirkan lagi seorang anak laki-laki dan menamainya Syela. Ketika perempuan itu melahirkan anaknya, Yehuda sedang berada di Kezib. ");
INSERT INTO indayt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yehuda mengambil seorang istri untuk Er, anak sulungnya. Namanya adalah Tamar. ");
INSERT INTO indayt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Akan tetapi, Er, anak sulung Yehuda, jahat di mata TUHAN. Sebab itu, TUHAN membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Lalu, Yehuda berkata kepada Onan, “Pergilah kepada istri saudaramu dan penuhilah kewajibanmu sebagai ipar baginya. Lalu, bangkitkanlah keturunan bagi kakakmu.” ");
INSERT INTO indayt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan tahu bahwa keturunan itu tidak akan menjadi miliknya. Karena itu, ketika dia bersetubuh dengan istri kakaknya itu, dia menumpahkan air maninya ke tanah supaya tidak memberikan keturunan bagi kakaknya. ");
INSERT INTO indayt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yang dilakukannya itu adalah jahat di mata TUHAN sehingga TUHAN juga membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kemudian, Yehuda berkata kepada Tamar, menantunya, “Tinggallah sebagai seorang janda di rumah ayahmu, sampai anakku, Syela, menjadi dewasa.” Karena pikirnya, “Jangan sampai dia juga mati seperti kakak-kakaknya.” Jadi, Tamar pergi dan tinggal di rumah ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Setelah beberapa waktu, istri Yehuda, yaitu anak Syua, mati. Ketika Yehuda sudah terhibur, dia pergi kepada orang-orang yang mencukur bulu domba-dombanya di Timna, dia bersama temannya, Hira, orang Adulam itu. ");
INSERT INTO indayt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Hal ini dikabarkan kepada Tamar, “Lihatlah, ayah mertuamu pergi ke Timna untuk mencukur dombanya.” ");
INSERT INTO indayt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kemudian, Tamar menanggalkan pakaian kejandaannya dan menutupi dirinya dengan kerudung, menyelubungi dirinya, lalu duduk di pintu masuk Enaim, yang adalah jalan menuju Timna. Sebab, dia melihat bahwa Syela sudah dewasa, tetapi dirinya belum diberikan kepada Syela sebagai istri. ");
INSERT INTO indayt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ketika Yehuda melihat Tamar, dia menyangka bahwa perempuan itu adalah perempuan sundal karena dia menutupi wajahnya. ");
INSERT INTO indayt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Sebab itu, dia berpaling kepada perempuan itu di pinggir jalan tersebut, katanya, “Ayo, biarlah aku bersetubuh denganmu.” Dia tidak mengetahui kalau perempuan itu adalah menantunya. Perempuan itu berkata, “Apa yang akan engkau berikan kepadaku supaya engkau boleh bersetubuh denganku?” ");
INSERT INTO indayt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Dia berkata, “Aku akan mengirim seekor kambing jantan muda dari kawananku kepadamu.” Perempuan itu menjawab, “Akankah engkau memberikan jaminan kepadaku sampai engkau mengirimkannya?” ");
INSERT INTO indayt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Dia berkata, “Jaminan apa yang harus aku berikan kepadamu?” Perempuan itu menjawab, “Cincin meteraimu, dan gelangmu, dan tongkat yang ada di tanganmu itu.” Jadi, dia memberikannya kepada perempuan itu dan bersetubuh dengannya sehingga perempuan itu pun mengandung karenanya. ");
INSERT INTO indayt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kemudian, Tamar bangun dan pergi, dia menanggalkan kerudungnya, lalu mengenakan kembali pakaian kejandaannya. ");
INSERT INTO indayt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yehuda mengirimkan kambing jantan muda melalui tangan temannya, orang Adulam itu, agar dia bisa mendapatkan kembali jaminan itu dari tangan perempuan itu, tetapi dia tidak dapat menemukannya. ");
INSERT INTO indayt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Dia bertanya kepada beberapa orang di tempat itu, “Di manakah perempuan sundal itu, yang ada di jalan menuju ke Enaim?” Jawab mereka, “Tidak ada perempuan sundal di tempat ini.” ");
INSERT INTO indayt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Karena itu, Hira kembali kepada Yehuda dan berkata, “Aku tidak dapat menemukannya. Lagi pula, orang-orang di tempat itu berkata, ‘Tidak ada perempuan sundal di tempat ini.’” ");
INSERT INTO indayt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yehuda berkata, “Biarlah dia mengambilnya untuk dirinya, jangan sampai kita menjadi cibiran. Lagi pula, aku sudah mengirimkan kambing jantan muda ini, tetapi kamu tidak dapat menemukannya.” ");
INSERT INTO indayt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kira-kira tiga bulan kemudian, Yehuda mendapat kabar, “Tamar, menantumu, telah bersundal, bahkan dia juga mengandung akibat perzinaannya itu.” Lalu, Yehuda berkata, “Bawa dia keluar! Biar dia dibakar!” ");
INSERT INTO indayt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ketika dia dibawa keluar, dia mengutus orang kepada ayah mertuanya, katanya, “Karena laki-laki yang memiliki barang-barang inilah aku mengandung,” katanya pula, “aku mohon, periksalah, siapa pemilik cincin meterai, dan gelang, dan tongkat ini.” ");
INSERT INTO indayt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda pun mengenalinya dan berkata, “Dia lebih benar daripada aku karena aku tidak memberikan dirinya kepada Syela, anakku.” Setelah itu, dia tidak bersetubuh lagi dengan Tamar. ");
INSERT INTO indayt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ketika tiba waktunya bagi Tamar untuk melahirkan, ternyata ada anak kembar dalam kandungannya. ");
INSERT INTO indayt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ketika dia melahirkan, salah satunya mengeluarkan tangannya. Kemudian, orang yang membantunya melahirkan memegangnya dan mengikatkan seutas benang merah tua pada tangannya, lalu berkata, “Inilah yang keluar lebih dahulu.” ");
INSERT INTO indayt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Namun, dia menarik kembali tangannya, dan lihat, saudaranyalah yang keluar. Kemudian, bidan itu berkata, “Betapa kamu telah menerobos, kamulah terobosan.” Sebab itu, dia dinamai Peres. ");
INSERT INTO indayt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sesudah itu, saudaranya keluar, yaitu yang ada benang merah tua pada tangannya, dan dia dinamai Zerah. ");
INSERT INTO indayt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Pada saat itu, Yusuf dibawa ke Mesir. Potifar, pegawai Firaun, kepala para pengawal, seorang Mesir, membelinya dari tangan orang Ismael yang telah membawanya ke sana. ");
INSERT INTO indayt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","TUHAN menyertainya sehingga dia menjadi orang yang berhasil dan dia tinggal di rumah tuannya, orang Mesir itu. ");
INSERT INTO indayt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tuannya melihat bahwa TUHAN menyertainya dan TUHAN membuat segala yang dilakukannya berhasil di tangannya. ");
INSERT INTO indayt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Sebab itu, Yusuf mendapat perkenanan di mata tuannya dan Yusuf mengabdi kepadanya. Lalu, Potifar mengangkat Yusuf dalam rumahnya dan segala miliknya pun diserahkannya ke tangan Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sejak Potifar mengangkat Yusuf dalam rumahnya dan atas segala miliknya, TUHAN memberkati rumah orang Mesir itu karena Yusuf. Berkat TUHAN itu ada pada segala sesuatu yang dimilikinya, baik di dalam rumah maupun di ladang. ");
INSERT INTO indayt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Jadi, dia menyerahkan segala miliknya ke tangan Yusuf sehingga tidak diketahuinya mengenai apa pun, kecuali makanan yang dimakannya. Yusuf adalah orang yang bagus penampilannya dan tampan. ");
INSERT INTO indayt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Setelah beberapa waktu, terjadilah, istri tuannya memandang Yusuf dan berkata, “Berbaringlah denganku.” ");
INSERT INTO indayt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Akan tetapi, dia menolak dan berkata kepada istri tuannya itu, “Lihatlah, tuanku tidak mengetahui tentang apa pun yang ada dalam rumah ini dan dia telah menyerahkan segala yang dimilikinya ke tanganku. ");
INSERT INTO indayt_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tidak seorang pun yang lebih besar daripada aku di rumah ini dan dia tidak menahan apa pun dariku, kecuali engkau, sebab engkau adalah istrinya. Bagaimana mungkin aku dapat melakukan kejahatan yang besar ini dan berdosa terhadap Allah?” ");
INSERT INTO indayt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hari demi hari, perempuan itu terus berbicara kepada Yusuf, tetapi Yusuf tidak mau mendengarkannya untuk tidur dengannya atau untuk bersetubuh bersamanya. ");
INSERT INTO indayt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pada suatu hari, Yusuf masuk ke rumah untuk melakukan pekerjaannya dan tidak seorang pun dari rumah itu yang ada di dalam rumah. ");
INSERT INTO indayt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Lalu, perempuan itu menangkap Yusuf pada bajunya dan berkata, “Tidurlah denganku!” Akan tetapi, Yusuf meninggalkan bajunya di tangan perempuan itu, dia meloloskan diri, lalu pergi keluar. ");
INSERT INTO indayt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ketika perempuan itu melihat bahwa Yusuf telah meninggalkan bajunya di tangannya dan keluar melarikan diri, ");
INSERT INTO indayt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","dia memanggil orang-orang di rumahnya dan berkata kepada mereka, “Lihat, dia telah membawa seorang Ibrani untuk mempermalukan kita. Dia datang kepadaku untuk tidur denganku, tetapi aku menjerit dengan suara keras. ");
INSERT INTO indayt_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Begitu didengarnya aku mengeraskan suaraku dan menjerit, dia meninggalkan bajunya padaku, meloloskan diri, lalu pergi keluar.” ");
INSERT INTO indayt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kemudian, perempuan itu meletakkan baju Yusuf di dekatnya sampai tuannya pulang ke rumah. ");
INSERT INTO indayt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Perempuan itu pun berkata kepadanya sesuai dengan kata-katanya itu, “Budak Ibrani, yang engkau bawa kepada kita, datang kepadaku untuk mempermalukanku! ");
INSERT INTO indayt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Namun, ketika aku mengeraskan suaraku dan menjerit, dia meninggalkan bajunya di sampingku dan meloloskan diri.” ");
INSERT INTO indayt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ketika tuannya mendengar perkataan istrinya yang disampaikan kepadanya, “Inilah yang dilakukan budakmu terhadapku,” ");
INSERT INTO indayt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","tuannya menangkap Yusuf dan memasukkannya ke rumah bundar, tempat para tahanan raja dikurung. Dia pun berada di sana, di dalam penjara. ");
INSERT INTO indayt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Namun, TUHAN menyertai Yusuf, dan menunjukkan kasih kepadanya, dan mengaruniainya perkenanan di mata kepala penjara. ");
INSERT INTO indayt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kepala penjara menyerahkan semua tahanan yang ada di penjara itu ke tangan Yusuf. Apa pun yang mereka lakukan di sana, dialah yang mengerjakannya. ");
INSERT INTO indayt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kepala penjara tidak mengawasi segala sesuatu yang ada di bawah tangan Yusuf karena TUHAN menyertainya. Apa pun yang dikerjakannya, TUHAN membuatnya berhasil. ");
INSERT INTO indayt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Pada suatu waktu, sesudah peristiwa-peristiwa itu, juru minuman Raja Mesir dan juru rotinya berbuat salah terhadap tuannya, Raja Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Lalu, Firaun murka terhadap kedua pegawainya itu, yaitu terhadap kepala juru minuman dan terhadap kepala juru roti. ");
INSERT INTO indayt_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Karena itu, dia memasukkan mereka ke penjara di rumah kepala para pengawal, yaitu di rumah bundar, tempat Yusuf dipenjarakan. ");
INSERT INTO indayt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kepala para pengawal itu menempatkan Yusuf bersama dengan mereka dan dia pun melayani mereka. Mereka berada di dalam penjara selama beberapa waktu. ");
INSERT INTO indayt_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pada satu malam, juru minuman dan juru roti Raja Mesir, yang ditahan di penjara, mereka berdua bermimpi suatu mimpi. Masing-masing dengan mimpinya sendiri dan masing-masing mimpi dengan artinya sendiri. ");
INSERT INTO indayt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ketika Yusuf datang kepada mereka pada pagi hari dan memperhatikan mereka, lihatlah, mereka bersusah hati. ");
INSERT INTO indayt_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Dia bertanya kepada para pegawai Firaun yang bersama dengannya di dalam penjara, di rumah tuannya itu, katanya, “Mengapa wajahmu muram hari ini?” ");
INSERT INTO indayt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Mereka berkata kepadanya, “Kami bermimpi suatu mimpi dan tidak ada orang yang menafsirkannya.” Lalu, Yusuf berkata kepada mereka, “Bukankah penafsiran itu milik Allah? Silakan, ceritakanlah kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Lalu, kepala juru minuman menceritakan mimpinya kepada Yusuf dan berkata kepadanya, “Dalam mimpiku, tampak sebatang pohon anggur di depanku, ");
INSERT INTO indayt_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","dan pohon anggur itu berdahan tiga. Ketika dia bertunas, bunganya pun mekar, dan tandan-tandannya mengeluarkan buah anggur yang masak. ");
INSERT INTO indayt_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pada saat itu, di tanganku ada piala Firaun, lalu aku memetik buah anggur itu dan memerasnya ke dalam piala Firaun. Kemudian, aku memberikan piala itu ke tangan Firaun.” ");
INSERT INTO indayt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Lalu, Yusuf berkata kepadanya, “Inilah tafsirannya: tiga dahan itu adalah tiga hari. ");
INSERT INTO indayt_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dalam tiga hari, Firaun akan mengangkat kepalamu dan mengembalikanmu pada kedudukanmu, lalu engkau akan memberikan piala Firaun itu ke tangannya, seperti yang telah engkau lakukan sebelumnya ketika engkau menjadi juru minumannya. ");
INSERT INTO indayt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Namun, apabila keadaanmu menjadi baik, aku mohon, ingatlah aku dan lakukanlah kebaikan bagiku dengan menyebut aku kepada Firaun, dan keluarkanlah aku dari rumah ini. ");
INSERT INTO indayt_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Sebab, sebenarnya aku telah diculik dari tanah orang Ibrani dan di sini pun aku tidak pernah melakukan sesuatu sehingga mereka harus memasukkanku ke dalam lubang ini.” ");
INSERT INTO indayt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ketika kepala juru roti melihat bahwa tafsirannya baik, dia berkata kepada Yusuf, “Dalam mimpiku, aku juga melihat ada tiga keranjang roti putih di kepalaku. ");
INSERT INTO indayt_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dalam keranjang yang paling atas terdapat segala jenis makanan yang dipanggang untuk raja, tetapi burung-burung memakannya dari keranjang di kepalaku itu.” ");
INSERT INTO indayt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf menjawab, “Inilah tafsirannya: tiga keranjang itu adalah tiga hari. ");
INSERT INTO indayt_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dalam tiga hari, Firaun akan mengangkat kepalamu darimu dan akan menggantungnya pada sebatang pohon. Lalu, burung-burung akan memakan dagingmu.” ");
INSERT INTO indayt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tiga hari kemudian, pada hari ulang tahun Firaun, dia mengadakan suatu jamuan untuk semua hambanya. Lalu, dia mengangkat kepala dari kepala juru minuman dan kepala juru roti di tengah-tengah hambanya. ");
INSERT INTO indayt_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Firaun mengembalikan kepala juru minuman pada kedudukannya dan dia memberikan piala ke tangan Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Akan tetapi, Firaun menggantung kepala juru roti, sebagaimana yang sudah ditafsirkan Yusuf kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Namun, kepala juru minuman tidak mengingat Yusuf, bahkan dia melupakannya. ");
INSERT INTO indayt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dua tahun kemudian, Firaun bermimpi dan dia tampak sedang berdiri di tepi sungai. ");
INSERT INTO indayt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Lihatlah, dari sungai muncul tujuh ekor sapi betina yang kelihatan bagus dan tambun badannya. Mereka merumput di rumput rawa. ");
INSERT INTO indayt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kemudian, lihatlah, dari sungai muncul tujuh ekor sapi betina lainnya, yang kelihatan buruk dan kurus badannya, dan berdiri dengan sapi-sapi lainnya di tepi sungai itu. ");
INSERT INTO indayt_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kemudian, sapi-sapi yang kelihatan buruk dan kurus tubuhnya itu memakan ketujuh ekor sapi yang kelihatan bagus dan tambun. Lalu, Firaun pun terbangun. ");
INSERT INTO indayt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Setelah itu, Firaun tertidur dan bermimpi untuk kedua kalinya. Tampak tujuh bulir gandum yang bernas dan bagus muncul dari satu tangkai. ");
INSERT INTO indayt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Lalu, lihatlah, tujuh bulir gandum yang kurus dan menjadi rusak karena angin timur, muncul sesudahnya. ");
INSERT INTO indayt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bulir-bulir gandum yang kurus itu menelan ketujuh bulir gandum yang bernas dan berisi. Kemudian, Firaun terbangun dan ternyata itu adalah suatu mimpi. ");
INSERT INTO indayt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pada pagi harinya, rohnya gelisah. Karena itu, dia menyuruh dan memanggil semua ahli sihir Mesir beserta semua orang bijaknya. Kemudian, Firaun menceritakan mimpinya kepada mereka, tetapi tidak ada satu pun yang mampu menafsirkannya bagi Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kemudian, kepala juru minuman berkata kepada Firaun, katanya, “Pada hari ini, aku teringat akan kesalahanku. ");
INSERT INTO indayt_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Firaun pernah murka kepada hamba-hambanya dan memasukkanku ke penjara, di rumah kepala para pengawal, yaitu aku dan kepala juru roti. ");
INSERT INTO indayt_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Pada satu malam, kami bermimpi suatu mimpi, yaitu dia dan aku, masing-masing bermimpi menurut arti mimpinya tersendiri. ");
INSERT INTO indayt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Di sana, ada seorang pemuda, orang Ibrani, hamba dari kepala para pengawal. Kemudian, kami menceritakannya kepadanya dan dia menafsirkan bagi kami mimpi kami itu. ");
INSERT INTO indayt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Seperti yang ditafsirkannya bagi kami, yaitu dia mengembalikanku pada kedudukanku, sedangkan juru roti itu digantung.” ");
INSERT INTO indayt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kemudian, Firaun menyuruh orang memanggil Yusuf dan dengan cepat mereka membawanya keluar dari lubang itu. Dia bercukur dan mengganti pakaiannya, lalu menghadap Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Firaun berkata kepada Yusuf, “Aku bermimpi sebuah mimpi dan tidak ada yang mampu menafsirkannya. Namun, aku telah mendengar tentangmu, bahwa kamu dapat mendengar sebuah mimpi untuk menafsirkannya.” ");
INSERT INTO indayt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusuf menjawab Firaun, katanya, “Bukan aku! Allah yang akan memberikan kepada Firaun suatu jawaban yang mendamaikan.” ");
INSERT INTO indayt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Lalu, Firaun berkata kepada Yusuf, “Dalam mimpiku, aku tampak sedang berdiri di tepi sungai. ");
INSERT INTO indayt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Lihatlah, dari sungai itu muncul tujuh sapi betina yang tambun tubuhnya dan kelihatan bagus. Mereka merumput di rumput-rumput rawa. ");
INSERT INTO indayt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kemudian, tampak tujuh ekor sapi betina lainnya yang muncul setelah mereka, yang kelihatan buruk dan kurus. Aku belum pernah melihat yang seburuk itu di seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sapi-sapi yang kurus dan buruk memakan ketujuh sapi yang tambun sebelumnya. ");
INSERT INTO indayt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ketika masuk ke dalam perutnya, tidak dapat diketahui bahwa mereka telah memakannya karena mereka tetap kelihatan buruk seperti semula. Kemudian, aku pun terbangun. ");
INSERT INTO indayt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Aku melihat dalam mimpiku, tampak tujuh bulir gandum yang bernas dan baik, muncul dari satu tangkai. ");
INSERT INTO indayt_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Lalu, tampak tujuh bulir gandum yang layu, tipis, dan rusak karena angin timur, yang muncul setelahnya. ");
INSERT INTO indayt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bulir-bulir gandum yang tipis itu menelan ketujuh bulir gandum yang baik. Aku telah menceritakan semua ini kepada para ahli sihir itu, tetapi tidak satu pun yang mampu menjelaskannya kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kemudian, Yusuf berkata kepada Firaun, “Mimpi Firaun adalah satu. Apa yang hendak Allah lakukan telah Dia nyatakan kepada Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tujuh ekor sapi betina yang bagus adalah tujuh tahun dan tujuh bulir gandum yang bagus adalah tujuh tahun, mimpi tersebut satu adanya. ");
INSERT INTO indayt_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Lalu, tujuh ekor sapi betina yang kurus dan kelihatan buruk, yang muncul sesudahnya, adalah tujuh tahun. Tujuh bulir gandum yang tipis dan rusak oleh angin timur itu akan menjadi tujuh tahun kelaparan. ");
INSERT INTO indayt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Inilah hal yang aku katakan kepada Firaun, yaitu apa yang hendak Allah lakukan telah Dia nyatakan kepada Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sesungguhnya, akan datang tujuh tahun masa kelimpahan besar di seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Setelah itu, akan datang tujuh tahun kelaparan sehingga segala kelimpahan sebelumnya di tanah Mesir akan terlupakan. Kelaparan itu akan menghabisi tanah ini. ");
INSERT INTO indayt_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bahkan, kelimpahan itu tidak akan diingat lagi di tanah itu karena kelaparan sesudahnya, sebab hal itu akan terlalu berat. ");
INSERT INTO indayt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Karena mimpi itu diulang sampai dua kali bagi Firaun, berarti hal tersebut telah ditetapkan oleh Allah dan Allah akan melaksanakannya secepatnya. ");
INSERT INTO indayt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Sebab itu, sebaiknya Firaun mencari seseorang yang pandai dan bijaksana, lalu mengangkatnya atas seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Lalu, hendaklah Firaun menunjuk para pengawas atas tanah ini dan mengambil seperlima bagian dari hasil tanah Mesir selama tujuh tahun kelimpahan itu. ");
INSERT INTO indayt_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Biarlah mereka mengumpulkan segala makanan dalam tahun-tahun yang baik, yang akan datang ini, dan menimbun gandum di bawah tangan Firaun. Biarlah mereka menyimpan makanan di kota-kotanya. ");
INSERT INTO indayt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Makanan itu akan menjadi persediaan untuk tanah ini, selama tujuh tahun kelaparan yang akan terjadi di tanah Mesir supaya tanah ini tidak dibinasakan oleh kelaparan itu.” ");
INSERT INTO indayt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Usul tersebut baik di mata Firaun dan di mata seluruh hambanya. ");
INSERT INTO indayt_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Lalu, Firaun berkata kepada para hambanya, “Apakah kita dapat menemukan orang seperti ini, seseorang dengan Roh Allah di dalam dirinya?” ");
INSERT INTO indayt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Lalu, Firaun berkata kepada Yusuf, “Karena Allah telah membuatmu semua hal ini diketahui olehmu, maka tidak ada satu pun yang sepandai dan sebijaksana dirimu. ");
INSERT INTO indayt_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kamu akan berkuasa atas istanaku dan berdasarkan perkataan mulutmulah seluruh rakyatku akan diperintah.” ");
INSERT INTO indayt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Firaun berkata kepada Yusuf, “Lihat, aku telah mengangkatmu menguasai seluruh tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kemudian, Firaun melepaskan cincin meterai dari tangannya dan memasangnya di tangan Yusuf, lalu dia memakaikan pakaian dari linen halus kepada Yusuf dan memasang sebuah rantai emas di lehernya. ");
INSERT INTO indayt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Setelah itu, Firaun menyuruh Yusuf mengendarai keretanya yang kedua dan di hadapan Yusuf, mereka berseru, “Berlutut!” Demikianlah Firaun mengangkatnya menguasai seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firaun berkata kepada Yusuf, “Akulah Firaun, tetapi tanpamu, tidak akan ada seorang pun yang mengangkat tangannya atau kakinya di seluruh negeri Mesir.” ");
INSERT INTO indayt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kemudian, Firaun menamai Yusuf dengan Zafnat-Paaneah. Dia juga memberikan Asnat kepadanya sebagai istri, yaitu anak Potifera, imam di On. Lalu, Yusuf pergi ke seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusuf berumur 30 tahun ketika dia berdiri di hadapan Firaun, raja Mesir. Yusuf pun pergi dari hadapan Firaun dan pergi mengelilingi seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Selama tujuh tahun kelimpahan, tanah itu mengeluarkan hasil yang berlimpah-limpah dari tanah. ");
INSERT INTO indayt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Selama tujuh tahun, dia mengumpulkan segala makanan dari tanah Mesir dan menimbun makanan di kota-kota: makanan dari ladang, dari sekitar masing-masing kota, ditimbunnya di tengah kota. ");
INSERT INTO indayt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusuf menimbun gandum seperti pasir di laut, sangat banyak, hingga dia berhenti menghitungnya karena sudah tidak terhitung. ");
INSERT INTO indayt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sebelum tahun kelaparan datang, lahirlah dua anak laki-laki bagi Yusuf dari Asnat, anak Potifera, seorang imam di On. ");
INSERT INTO indayt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuf menamai anak sulungnya Manasye, sebab katanya, “Allah telah membuatku melupakan segala kesusahanku dan seluruh rumah ayahku.” ");
INSERT INTO indayt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nama anak keduanya adalah Efraim, sebab katanya, “Allah telah membuatku berbuah-buah di tanah kesengsaraanku.” ");
INSERT INTO indayt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Tujuh tahun kelimpahan di tanah Mesir pun berakhir. ");
INSERT INTO indayt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Tujuh tahun kelaparan pun mulai tiba, sebagaimana yang telah dikatakan Yusuf. Kelaparan terjadi di semua wilayah, tetapi di seluruh tanah Mesir ada makanan. ");
INSERT INTO indayt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ketika seluruh tanah Mesir kelaparan, rakyat mulai berteriak kepada Firaun untuk makanan. Kemudian, Firaun berkata kepada semua orang Mesir, “Pergilah kepada Yusuf! Kamu harus melakukan apa pun yang dikatakannya.” ");
INSERT INTO indayt_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ketika kelaparan semakin menyebar ke seluruh muka bumi, Yusuf pun membuka semua penimbunan, dan menjualnya kepada orang Mesir. Kelaparan itu terlalu berat di tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Orang-orang dari seluruh bumi berdatangan ke Mesir untuk membeli gandum dari Yusuf karena kelaparan itu sangat berat di seluruh bumi. ");
INSERT INTO indayt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ketika Yakub melihat bahwa di Mesir ada gandum, berkatalah Yakub kepada anak-anaknya, “Mengapa kalian hanya saling memandang?” ");
INSERT INTO indayt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Dia berkata, “Lihat, aku telah mendengar bahwa ada gandum di Mesir. Pergilah ke sana dan belilah untuk kita dari sana supaya kita tetap hidup dan tidak mati.” ");
INSERT INTO indayt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Lalu, sepuluh kakak Yusuf berangkat ke Mesir untuk membeli gandum. ");
INSERT INTO indayt_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Namun, Yakub tidak menyuruh Benyamin, adik Yusuf, untuk pergi bersama kakak-kakaknya sebab katanya, “Jangan sampai kecelakaan menimpanya.” ");
INSERT INTO indayt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Jadi, anak-anak Israel berangkat untuk membeli gandum di antara mereka yang berdatangan karena kelaparan telah terjadi di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusuf adalah penguasa atas tanah itu dan dialah yang menjual kepada seluruh rakyat tanah itu. Lalu, datanglah kakak-kakak Yusuf dan berlutut kepadanya dengan mukanya sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusuf melihat kakak-kakaknya dan dia pun mengenali mereka. Namun, dia membuat dirinya tidak dikenali oleh mereka dan berbicara dengan kasar terhadap mereka. Dia berkata kepada mereka, “Dari mana kalian datang?” Mereka berkata, “Dari tanah Kanaan untuk membeli makanan.” ");
INSERT INTO indayt_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusuf mengenali kakak-kakaknya, tetapi mereka tidak mengenalinya. ");
INSERT INTO indayt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Lalu, teringatlah Yusuf akan mimpi-mimpi yang pernah dimimpikannya tentang mereka, dan dia berkata kepada mereka, “Kalian adalah mata-mata! Kalian datang untuk mengamat-amati bagian yang tidak dijaga dari tanah ini.” ");
INSERT INTO indayt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Mereka berkata kepadanya, “Tidak, ya Tuanku. Hamba-hambamu ini datang untuk membeli makanan. ");
INSERT INTO indayt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kami semua ini adalah anak dari seorang laki-laki. Kami orang jujur, hamba-hambamu ini bukanlah mata-mata.” ");
INSERT INTO indayt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Dia berkata kepada mereka, “Tidak! Kalian datang untuk mengamat-amati bagian yang tidak dijaga dari tanah ini.” ");
INSERT INTO indayt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mereka berkata, “Hamba-hambamu ini adalah dua belas bersaudara, anak-anak dari seorang laki-laki di tanah Kanaan. Pada saat ini, yang bungsu ada bersama dengan ayah kami, tetapi yang seorang tidak ada lagi.” ");
INSERT INTO indayt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Akan tetapi, Yusuf berkata kepada mereka, “Sebagaimana yang telah aku katakan kepadamu, kalian adalah mata-mata. ");
INSERT INTO indayt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Beginilah kalian akan diuji: demi hidup Firaun, kalian tidak boleh pergi dari tempat ini, kecuali adik bungsumu itu datang kemari. ");
INSERT INTO indayt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Utuslah salah seorang dari kalian dan biarkan dia membawa adikmu, sementara yang lain tetap ditahan. Biarlah perkataanmu dapat dibuktikan, apakah ada kebenaran di dalamnya. Namun, jika tidak, demi hidup Firaun, kamu pasti adalah mata-mata.” ");
INSERT INTO indayt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Lalu, dia menjebloskan mereka ke penjara selama tiga hari. ");
INSERT INTO indayt_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Setelah tiga hari, Yusuf berkata kepada mereka, “Lakukanlah ini dan kalian akan hidup sebab aku ini takut akan Allah: ");
INSERT INTO indayt_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Jika kalian jujur, biarlah salah satu dari saudaramu tetap dikurung di dalam rumah tahanan. Kalian pergilah, bawalah gandum untuk kelaparan rumahmu. ");
INSERT INTO indayt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Lalu, bawalah adik bungsu kalian kepadaku supaya terbuktilah perkataan-perkataanmu, dan kalian tidak perlu mati.” Mereka pun melakukan seperti itu. ");
INSERT INTO indayt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mereka berkata satu sama lain, “Kita benar-benar bersalah terhadap adik kita. Pada saat itu, kita melihat kesusahan jiwanya, ketika dia memohon kepada kita, tetapi kita tidak mendengarkannya. Oleh sebab itu, kesusahan ini menimpa kita.” ");
INSERT INTO indayt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lalu, Ruben berkata kepada mereka, katanya, “Aku sudah berkata kepada kalian, ‘Jangan berdosa terhadap anak itu,’ tetapi kalian tidak mau mendengarkan! Oleh sebab itu, lihatlah, darahnya pun dituntut dari kita!” ");
INSERT INTO indayt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mereka tidak tahu kalau Yusuf memahaminya karena ada yang menerjemahkan di antara mereka. ");
INSERT INTO indayt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kemudian, dia berpaling dari mereka dan menangis. Lalu, dia kembali lagi kepada mereka, berbicara dengan mereka, mengambil Simeon dari mereka, lalu mengikatnya di hadapan mereka. ");
INSERT INTO indayt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Setelah itu, Yusuf memerintahkan untuk mengisi karung-karung mereka dengan gandum, mengembalikan uang masing-masing orang ke dalam karungnya, dan memberikan bekal untuk perjalanan kepada mereka. Dilaksanakanlah hal itu bagi mereka. ");
INSERT INTO indayt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mereka menaikkan gandum ke atas keledai-keledainya dan berangkat dari sana. ");
INSERT INTO indayt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ketika salah satunya membuka karungnya untuk memberi makan keledainya di tempat bermalam, dia melihat uangnya, dan lihatlah, itu ada di mulut karungnya. ");
INSERT INTO indayt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Lalu, dia berkata kepada saudara-saudaranya, “Uangku dikembalikan! Lihatlah, itu di dalam karungku!” Lalu, mereka kecut hati dan mereka gemetar sambil berkata satu sama lain, “Apakah ini yang telah Allah lakukan terhadap kita?” ");
INSERT INTO indayt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mereka pun sampai kepada Yakub, ayahnya, di tanah Kanaan. Mereka menceritakan kepadanya tentang semua hal yang telah menimpa mereka, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Orang itu, yang menjadi penguasa atas tanah itu, berbicara dengan kasar terhadap kami, dan menganggap kami mata-mata atas negeri itu. ");
INSERT INTO indayt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Namun, kami berkata kepadanya, ‘Kami orang jujur, kami bukan mata-mata. ");
INSERT INTO indayt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kami ini dua belas bersaudara, anak-anak ayah kami, yang seorang sudah tidak ada, dan yang bungsu bersama dengan ayah kami saat ini, di tanah Kanaan.’ ");
INSERT INTO indayt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kemudian, orang itu, penguasa negeri itu, berkata kepada kami, ‘Beginilah aku akan mengetahui bahwa kalian orang jujur: tinggalkanlah salah satu saudaramu denganku, dan ambillah makanan untuk kelaparan di rumahmu, lalu pergilah. ");
INSERT INTO indayt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Lalu, bawalah adik bungsumu kepadaku agar aku tahu bahwa kalian bukanlah mata-mata, melainkan orang jujur. Aku akan mengembalikan saudaramu kepadamu dan kamu boleh menjelajahi tanah ini.’” ");
INSERT INTO indayt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sewaktu mereka mengosongkan karung-karungnya, lihatlah, kantong uang masing-masing orang ada di dalam karungnya. Ketika mereka dan ayah mereka melihat kantong-kantong uang itu, mereka menjadi takut. ");
INSERT INTO indayt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakub, ayah mereka, berkata kepada mereka, “Kalian telah membuatku berduka. Yusuf tidak ada dan Simeon juga tidak ada, lalu Benyamin akan kalian ambil. Segalanya telah menimpaku!” ");
INSERT INTO indayt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kemudian, Ruben berkata kepada ayahnya, katanya, “Bunuhlah kedua anak laki-lakiku jika aku tidak membawanya kepadamu. Serahkanlah dia ke tanganku dan aku akan membawanya kembali kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Dia berkata, “Anakku tidak akan turut bersamamu sebab kakaknya sudah mati, dan tinggal dia sendiri. Jika kejahatan menimpanya di jalan yang kamu lewati, kamu akan menurunkan aku yang beruban ini dalam dukacita ke dunia orang mati.” ");
INSERT INTO indayt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kelaparan pun semakin berat di tanah itu. ");
INSERT INTO indayt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lalu, terjadilah, pada waktu mereka memakan habis gandum yang mereka beli dari Mesir, ayahnya berkata kepada mereka, “Pergilah kembali, belikan sedikit makanan untuk kita.” ");
INSERT INTO indayt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Namun, Yehuda berkata kepadanya, katanya, “Orang itu sungguh-sungguh memperingatkan kami, begini, ‘Kalian tidak boleh melihat wajahku, kecuali adikmu bersamamu.’ ");
INSERT INTO indayt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Jika engkau mengutus adik kami bersama kami, kami akan pergi dan membelikanmu makanan. ");
INSERT INTO indayt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Namun, jika engkau tidak bersedia mengutusnya, kami tidak akan pergi sebab orang itu berkata kepada kami, ‘Kalian tidak boleh melihat wajahku, kecuali adikmu bersama denganmu.’” ");
INSERT INTO indayt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kemudian, Israel berkata, “Mengapa kalian menyakitiku dengan bercerita kepada orang itu bahwa kalian masih memiliki seorang adik?” ");
INSERT INTO indayt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Mereka berkata, “Orang itu bertanya secara teliti kepada kami tentang keluarga kita, katanya, ‘Apakah ayahmu masih hidup? Apakah kalian mempunyai seorang adik?’ Lalu, kami menceritakan kepadanya berdasarkan perkataan-perkataan mulutnya itu. Jadi, dapatkah kami tahu bahwa dia akan berkata, ‘Bawalah adikmu.’?” ");
INSERT INTO indayt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Lalu, Yehuda berkata kepada Israel, ayahnya, “Utuslah anak itu bersamaku, maka aku akan bangun dan pergi, supaya kita dapat hidup dan tidak mati, baik kami, dan engkau, dan juga anak-anak kami. ");
INSERT INTO indayt_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Aku yang akan menjaminnya dan dari tangankulah engkau dapat menuntutnya. Jika aku tidak membawanya kepadamu dan menempatkannya di hadapanmu, biarlah aku menanggung kesalahan itu selamanya. ");
INSERT INTO indayt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Karena kalau tidak berlama-lama, sekarang ini kami telah kembali sebanyak dua kali.” ");
INSERT INTO indayt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Lalu, ayah mereka, Israel, berkata kepada mereka, “Jika memang demikian, lakukanlah ini: ambillah hasil terbaik dari tanah ini dalam wadah-wadahmu dan bawalah sebagai hadiah: sedikit balsam, sedikit madu, rempah-rempah dan mur, serta kacang pistasio dan badam. ");
INSERT INTO indayt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bawalah dua kali lipat uang dalam tanganmu. Lalu, uang yang dikembalikan kepadamu, dalam mulut karung-karungmu itu, bawalah kembali dalam tanganmu. Mungkin hal itu adalah kekeliruan. ");
INSERT INTO indayt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Lalu, ambillah adikmu ini dan bangunlah, pergilah lagi kepada orang itu. ");
INSERT INTO indayt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kiranya Allah Yang Mahakuasa menganugerahkan belas kasihan bagimu dalam pandangan orang itu supaya dia melepaskan saudaramu yang lain dan Benyamin untukmu. Jika memang aku harus berduka, biarlah aku berduka.” ");
INSERT INTO indayt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Orang-orang itu pun membawa hadiah, dan mereka juga membawa uang dua kali lipat dalam tangannya serta Benyamin. Mereka bangun, lalu pergi ke Mesir dan berdiri di hadapan Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ketika Yusuf melihat Benyamin bersama mereka, berkatalah dia kepada yang mengurus rumahnya, “Bawalah orang-orang itu ke rumah, sembelihlah sembelihan, dan siapkanlah, sebab orang-orang itu akan makan bersamaku pada siang ini.” ");
INSERT INTO indayt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Orang itu melakukan seperti yang Yusuf katakan dan orang itu membawa orang-orang itu ke rumah Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Orang-orang itu menjadi takut karena mereka dibawa ke rumah Yusuf. Mereka berkata, “Karena masalah uang yang dikembalikan ke dalam karung-karung kita dahulu itulah, kita dibawa masuk supaya dia dapat melawan kita, dan menjatuhkan kita, dan mengambil kita sebagai budak, dan keledai-keledai kita.” ");
INSERT INTO indayt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Jadi, mereka mendekati orang yang mengurus rumah Yusuf dan mereka berbicara kepadanya di pintu rumah itu, ");
INSERT INTO indayt_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","katanya, “Oh, Tuanku, sesungguhnya pada awalnya kami datang untuk membeli makanan, ");
INSERT INTO indayt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","dan terjadilah, ketika kami tiba di tempat bermalam, kami membuka karung-karung kami, dan lihatlah, uang setiap orang ada di mulut karungnya, uang kami itu utuh. Sekarang, kami telah membawanya kembali di tangan kami ini. ");
INSERT INTO indayt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kami juga membawa uang yang lain dalam tangan kami untuk membeli makanan. Kami tidak tahu siapa yang menaruh uang kami dalam karung-karung kami itu.” ");
INSERT INTO indayt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Dia berkata, “Sejahtera bagimu, jangan takut, Allahmu dan Allah ayahmulah yang telah memberikan harta kepadamu dalam karungmu. Aku telah menerima uangmu.” Kemudian, dia membawa Simeon kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Orang itu membawa orang-orang itu masuk ke dalam rumah Yusuf dan memberikan air kepada mereka. Mereka pun membasuh kakinya dan orang itu menyediakan makanan bagi keledai-keledai mereka. ");
INSERT INTO indayt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Lalu, mereka menyiapkan hadiah sampai Yusuf datang pada siang hari, sebab mereka mendengar bahwa mereka akan makan roti di sana. ");
INSERT INTO indayt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ketika Yusuf tiba di rumah, mereka membawa kepadanya, ke dalam rumah itu, hadiah-hadiah yang ada di tangan mereka. Lalu, mereka berlutut dan menyembahnya sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kemudian, dia menanyai mereka mengenai kesejahteraan mereka, katanya, “Apakah ayahmu sejahtera, orang tua yang kalian bicarakan itu? Apakah dia masih hidup?” ");
INSERT INTO indayt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Mereka berkata, “Hambamu, ayah kami, sejahtera dan masih hidup.” Lalu, mereka membungkuk dan menyembah. ");
INSERT INTO indayt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kemudian, dia mengarahkan matanya dan melihat adiknya, Benyamin, anak ibunya, dan berkata, “Inikah adik bungsumu yang pernah kalian ceritakan kepadaku?” Dia berkata, “Kiranya Allah bermurah hati kepadamu, Anakku!” ");
INSERT INTO indayt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Lalu, Yusuf pergi tergesa-gesa karena rasa belas kasihnya bergelora terhadap adiknya itu. Dia pun mencari tempat untuk menangis, lalu dia masuk ke kamarnya dan menangis di sana. ");
INSERT INTO indayt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kemudian, dia membasuh wajahnya, dan keluar, dan menguasai dirinya, katanya, “Hidangkanlah roti.” ");
INSERT INTO indayt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Mereka menyiapkan baginya secara tersendiri, dan bagi saudara-saudaranya secara tersendiri, dan bagi orang Mesir, yang makan bersamanya, secara tersendiri. Orang Mesir tidak dapat makan roti bersama orang Ibrani karena hal itu adalah kekejian bagi orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Pada saat itu, mereka duduk di hadapannya, mulai dari yang sulung, berdasarkan hak kelahirannya, sampai yang bungsu berdasarkan kemudaannya. Orang-orang itu pun keheranan satu sama lain. ");
INSERT INTO indayt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Lalu, dia menyajikan bagian bagi mereka di hadapan mereka, tetapi bagian Benyamin lima kali lebih banyak dari bagian yang lainnya. Mereka minum dan menjadi mabuk bersamanya. ");
INSERT INTO indayt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Lalu, dia memberi perintah kepada orang yang mengurus rumahnya, katanya, “Isilah karung setiap orang itu dengan makanan, sebanyak yang sanggup mereka angkut, lalu taruhlah uang mereka masing-masing dalam mulut karungnya. ");
INSERT INTO indayt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kemudian, pialaku, piala perak itu, taruhlah itu di mulut karung yang bungsu beserta uang gandumnya.” Dia pun melaksanakan titah yang dititahkan oleh Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ketika fajar menyingsing, orang-orang itu dilepas pergi, mereka dan keledai-keledainya. ");
INSERT INTO indayt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ketika mereka baru saja keluar dari kota, belum jauh, Yusuf berkata kepada yang mengurus rumahnya, “Bangunlah, kejarlah orang-orang itu, dan ketika kamu dapat menyusulnya, katakanlah kepada mereka, ‘Mengapa kamu membalas hal yang jahat untuk hal yang baik? ");
INSERT INTO indayt_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bukankah ini yang dengannya tuanku minum dan meramal? Dia meramal kalian telah berbuat jahat dengan melakukan hal tersebut.’” ");
INSERT INTO indayt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Lalu, dia menyusul mereka dan bertitah kepada mereka dengan titah yang sama. ");
INSERT INTO indayt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mereka berkata kepadanya, “Mengapa Tuanku mengatakan perkataan itu? Jauhlah dari hamba-hambamu ini untuk melakukan hal semacam itu. ");
INSERT INTO indayt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Lihatlah, uang yang kami temukan dalam mulut karung kami ini, kami bawa kembali kepadamu dari tanah Kanaan. Bagaimana kemudian kami mencuri emas atau perak dari rumah tuanmu? ");
INSERT INTO indayt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Pada siapa pun itu ditemukan, dari hamba-hambamu ini, biarlah dia mati dan kami juga akan menjadi budak-budak Tuanku.” ");
INSERT INTO indayt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Dia berkata, “Sekarang juga, berdasarkan perkataanmu itu, pada siapa pun itu ditemukan, dia akan menjadi budakku, dan kalian tidak bersalah.” ");
INSERT INTO indayt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kemudian, setiap orang cepat-cepat menurunkan karungnya ke tanah dan membuka karungnya masing-masing. ");
INSERT INTO indayt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Dia pun mencari, dimulai dari yang tertua dan berakhir pada yang termuda. Piala itu ditemukan di dalam karung Benyamin. ");
INSERT INTO indayt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kemudian, mereka mengoyak pakaiannya dan memuati keledainya masing-masing, lalu kembali ke kota. ");
INSERT INTO indayt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kemudian, Yehuda dan saudara-saudaranya masuk ke rumah Yusuf selagi dia masih ada di sana. Lalu, mereka menjatuhkan diri di hadapannya sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuf berkata kepada mereka, “Perbuatan apa yang telah kalian lakukan ini? Tidak tahukah kamu bahwa orang seperti aku ini dapat meramal?” ");
INSERT INTO indayt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yehuda berkata, “Apa yang harus kami katakan kepada Tuanku? Apa yang harus kami bicarakan? Atau, bagaimana kami dapat membenarkan diri kami? Allah telah mendapati kesalahan hamba-hambamu ini. Lihat, kami ini hamba-hamba Tuanku, baik kami maupun dia yang padanya didapati piala itu.” ");
INSERT INTO indayt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Akan tetapi, dia berkata, “Jauhlah dariku untuk melakukan hal itu. Namun, orang yang padanya didapati piala itu, dialah yang akan menjadi budakku. Lalu, kembalilah kalian dengan sejahtera kepada ayahmu.” ");
INSERT INTO indayt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kemudian, Yehuda mendekati Yusuf dan berkata, “Tuanku, aku mohon, biarkanlah hambamu ini menyampaikan sepatah kata di telinga Tuanku, dan janganlah amarahmu menyala terhadap hambamu karena engkau adalah sama seperti Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tuanku pernah bertanya kepada hambamu ini dengan berkata, ‘Apakah kalian mempunyai ayah atau adik?’ ");
INSERT INTO indayt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kami mengatakan kepadamu bahwa kami memiliki ayah yang sudah tua dan seorang anak pada masa tuanya, anak bungsu. Kakaknya sudah mati dan tinggal dia sendiri dari ibunya. Ayahnya mengasihinya. ");
INSERT INTO indayt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kemudian, engkau berkata kepada hamba-hambamu, ‘Bawa dia kepadaku supaya aku dapat mengamatinya.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kami berkata kepada Tuanku, ‘Anak itu tidak dapat meninggalkan ayahnya. Jika dia harus meninggalkan ayahnya, ayahnya akan mati.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Namun, engkau berkata kepada hamba-hambamu ini, ‘Kecuali adik bungsumu datang bersamamu, kamu tidak boleh melihat wajahku lagi.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Inilah yang terjadi, ketika kami sampai kepada hambamu, ayah kami, kami menyampaikan kepadanya tentang titah Tuanku ini. ");
INSERT INTO indayt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lalu, Ayah kami berkata, ‘Pergilah lagi, belikan kita sedikit makanan.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kami berkata, ‘Kami tidak dapat pergi. Kami baru akan pergi jika adik bungsu kami beserta dengan kami. Sebab, kami tidak boleh melihat wajah orang itu, kecuali adik bungsu kami itu ikut dengan kami.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lalu, hambamu, ayah kami, berkata kepada kami, ‘Kalian tahu bahwa istriku melahirkan dua anak laki-laki bagiku, ");
INSERT INTO indayt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","dan yang seorang pergi dariku, dan aku mengatakan bahwa pastilah dia benar-benar tercabik-cabik. Aku tidak pernah melihatnya semenjak itu. ");
INSERT INTO indayt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Jika kamu juga mengambil yang ini dariku, dan kejahatan menimpanya, kalian akan membawa aku yang ubanan ini turun ke dunia orang mati dengan kesengsaraan.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Oleh sebab itu, sekarang, ketika aku pulang kepada hambamu, ayahku, dan anak itu tidak beserta kami, padahal jiwanya terikat dalam hidup anak itu, ");
INSERT INTO indayt_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","maka terjadilah, ketika dia melihat bahwa anak itu tidak beserta dengan kami, dia akan mati. Dengan demikian, hamba-hambamu ini akan membawa hambamu yang beruban, ayah kami, dalam dukacita, ke dunia orang mati. ");
INSERT INTO indayt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Sebab, hambamu ini menjamin anak itu untuk ayahku, dengan berkata, ‘Jika aku tidak membawanya kembali kepadamu, aku akan menanggung kesalahan terhadap ayahku untuk selama-lamanya.’ ");
INSERT INTO indayt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Sekarang, aku mohon, biarlah hambamu ini tetap di sini, alih-alih anak itu, biarlah hamba yang menjadi budak Tuanku. Biarlah anak itu kembali bersama kakak-kakaknya. ");
INSERT INTO indayt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Sebab bagaimana aku dapat kembali kepada ayahku, tetapi anak itu tidak bersamaku. Aku tidak dapat menyaksikan kesengsaraan yang akan menimpa ayahku.” ");
INSERT INTO indayt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf pun tidak sanggup lagi menguasai dirinya di hadapan semua yang berdiri di dekatnya. Dia berseru, “Semuanya, pergilah dari hadapanku!” Ketika tidak ada lagi orang yang berdiri di dekatnya, Yusuf pun mengungkapkan diri kepada saudara-saudaranya. ");
INSERT INTO indayt_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Lalu, dia menangis sekeras-kerasnya sehingga terdengar oleh orang-orang Mesir dan seisi istana Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Setelah itu, Yusuf berkata kepada saudara-saudaranya, “Akulah Yusuf! Apakah ayahku masih hidup?” Namun, saudara-saudaranya tidak dapat menjawabnya karena mereka ngeri terhadapnya. ");
INSERT INTO indayt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Oleh sebab itu, Yusuf berkata kepada saudara-saudaranya, “Ayo, mendekatlah kepadaku.” Mereka pun mendekatinya. Kemudian, dia berkata, “Akulah Yusuf, adikmu, yang telah kalian jual ke Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Sekarang, janganlah bersedih atau murka terhadap dirimu sendiri sebab kalian telah menjualku ke sini. Sebab, Allah mengutusku mendahuluimu untuk memelihara kehidupan. ");
INSERT INTO indayt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Karena kelaparan di tanah ini baru berlangsung selama dua tahun, masih ada lima tahun lagi masa yang di dalamnya tidak akan ada yang membajak maupun memanen. ");
INSERT INTO indayt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Sebab itu, Allah mengutus aku mendahului kalian untuk kelanjutanmu di bumi ini dan untuk menjagamu tetap hidup melalui pembebasan besar. ");
INSERT INTO indayt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Jadi, bukan kalian yang telah mengutus aku ke sini, melainkan Allah. Dia telah menjadikanku ayah bagi Firaun, dan menjadi tuan atas seluruh rumahnya, dan penguasa atas seluruh tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Cepat-cepatlah pergi kepada ayahku dan katakanlah kepadanya, “Demikianlah kata anakmu, Yusuf, ‘Allah telah menjadikanku tuan atas seluruh Mesir. Datanglah kepadaku, jangan berlambat-lambat! ");
INSERT INTO indayt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Engkau akan tinggal di tanah Gosyen dan engkau akan dekat denganku, engkau, dan anak-anakmu, dan anak-anak dari anak-anakmu, dan kawanan kambing dombamu, dan ternakmu, dan segala yang engkau miliki. ");
INSERT INTO indayt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Di sana, aku akan memelihara engkau karena masih lima tahun lagi kelaparan ini. Jangan sampai engkau, seisi rumahmu, dan segala milikmu masuk dalam kemiskinan.’ ");
INSERT INTO indayt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Lihatlah, mata kalian sendiri melihat, begitu pula mata adikku, Benyamin, bahwa mulutkulah yang mengatakannya kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Sebab itu, ceritakanlah kepada ayahku tentang segala kemuliaanku di Mesir, dan tentang segala yang telah kalian lihat. Kalian harus membawa ayahku kemari secepatnya.” ");
INSERT INTO indayt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kemudian, Yusuf merangkul leher Benyamin, adiknya, dan menangis. Benyamin pun menangis pada leher Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Lalu, dia mencium semua saudaranya sambil menangis pada mereka. Setelah itu, barulah saudara-saudaranya berbicara dengannya. ");
INSERT INTO indayt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ketika berita ini terdengar di Istana Firaun bahwa saudara-saudara Yusuf datang, di mata Firaun maupun hamba-hambanya hal ini menggembirakan. ");
INSERT INTO indayt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Karena itu, Firaun berkata kepada Yusuf, “Katakanlah kepada saudara-saudaramu: ‘Lakukanlah ini: bebanilah binatang-binatangmu dan pergilah, kembalilah ke tanah Kanaan, ");
INSERT INTO indayt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","jemputlah ayahmu beserta seisi rumahmu, lalu datanglah kepadaku. Aku akan memberikan kepadamu apa yang baik dari tanah Mesir dan kamu akan makan apa yang terbaik dari tanah ini.’ ");
INSERT INTO indayt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Sekarang, kamu diperintahkan untuk melaksanakan ini: bawalah bagimu kereta-kereta dari tanah Mesir untuk anak-anakmu dan istri-istrimu. Bawalah ayahmu dan datanglah kemari. ");
INSERT INTO indayt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Jangan merasa sayang dengan barang-barangmu sebab apa yang baik dari seluruh tanah Mesir ini adalah milikmu.” ");
INSERT INTO indayt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Anak-anak Israel pun melaksanakannya. Lalu, Yusuf memberikan kereta-kereta kepada mereka, sesuai dengan perintah Firaun, dan memberikan bekal untuk perjalanan mereka. ");
INSERT INTO indayt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kepada mereka semua, masing-masing diberikannya sebuah pakaian ganti. Namun, untuk Benyamin, dia memberikan tiga ratus keping perak dan lima pakaian ganti. ");
INSERT INTO indayt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Untuk ayahnya, dia mengirimkan ini: sepuluh keledai jantan, yang dibebani dengan barang-barang bagus dari Mesir, dan sepuluh ekor keledai betina, yang dibebani dengan gandum, dan roti, dan makanan untuk ayahnya dalam perjalanan. ");
INSERT INTO indayt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kemudian, Yusuf melepas saudara-saudaranya dan berangkatlah mereka. Dia berkata kepada saudara-saudaranya, “Jangan bertengkar dalam perjalanan.” ");
INSERT INTO indayt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Jadi, mereka berangkat dari Mesir dan sampai kepada ayahnya di tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Lalu, mereka bercerita kepadanya, “Yusuf masih hidup! Sesungguhnya, dia adalah penguasa atas seluruh tanah Mesir.” Akan tetapi, hatinya tetap dingin karena dia tidak memercayai mereka. ");
INSERT INTO indayt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ketika mereka menceritakan kepadanya segala perkataan Yusuf, yang telah disampaikannya kepada mereka, dan ketika dia melihat kereta-kereta yang dikirimkan oleh Yusuf untuk membawanya, bangkitlah semangat Yakub, ayah mereka. ");
INSERT INTO indayt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Lalu, Israel berkata, “Sudah cukup! Anakku, Yusuf, masih hidup! Aku mau pergi dan melihatnya sebelum aku mati.” ");
INSERT INTO indayt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kemudian, Israel berangkat beserta segala miliknya, lalu tiba di Bersyeba, dan mengurbankan kurban kepada Allah ayahnya, Ishak. ");
INSERT INTO indayt_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Allah berkata kepada Israel dalam penglihatan pada waktu malam, firman-Nya, “Yakub, Yakub.” Yakub berkata, “Inilah aku.” ");
INSERT INTO indayt_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kemudian, Dia berfirman, “Akulah Allah, Allah ayahmu. Jangan takut pergi ke Mesir karena Aku akan membuatmu menjadi bangsa yang besar di sana. ");
INSERT INTO indayt_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aku akan menyertaimu masuk ke Mesir, lalu Aku juga akan membawamu keluar, pasti membawamu keluar, dan tangan Yusuflah yang akan menutup matamu.” ");
INSERT INTO indayt_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bangunlah Yakub dari Bersyeba. Setelah itu, anak-anak Israel membawa Yakub, ayahnya, dan anak-anaknya, dan istri-istrinya dalam kereta-kereta yang dikirimkan Firaun untuk membawa mereka. ");
INSERT INTO indayt_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Mereka membawa ternak-ternaknya dan barang-barangnya yang mereka dapatkan di tanah Kanaan. Mereka pun tiba di Mesir, Yakub beserta seluruh keturunannya, ");
INSERT INTO indayt_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","yaitu anak-anak laki-lakinya, anak-anak laki-laki dari para anak laki-lakinya, anak-anak perempuannya, anak-anak perempuan dari para anak laki-lakinya, dan seluruh keturunannya, dibawanya bersamanya ke Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Inilah nama-nama keturunan Israel yang masuk ke Mesir, Yakub dan keturunannya: Ruben, anak sulung Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Anak-anak Ruben: Henokh, Palu, Hezron, dan Karmi. ");
INSERT INTO indayt_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Anak-anak Simeon: Yemuel, Yamin, Ohad, Yakhin, Zohar, dan Saul, anak dari seorang perempuan Kanaan. ");
INSERT INTO indayt_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Anak-anak Lewi: Gerson, Kehat, dan Merari. ");
INSERT INTO indayt_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Anak-anak Yehuda: Er, Onan, Syela, Peres, dan Zerah. Namun, Er dan Onan mati di tanah Kanaan. Anak-anak Peres adalah Hezron dan Hamul. ");
INSERT INTO indayt_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Anak-anak Isakhar: Tola, Pua, Ayub, dan Simron. ");
INSERT INTO indayt_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Anak-anak Zebulon: Sered, Elon, dan Yahleel. ");
INSERT INTO indayt_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Itulah keturunan Lea yang dilahirkannya bagi Yakub di Padan-Aram, dan Dina, anak perempuannya. Seluruh keturunan laki-lakinya dan keturunan perempuannya ada 33 jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Anak-anak Gad: Zifyon, Hagi, Syuni, Ezbon, Eri, Arodi, dan Areli. ");
INSERT INTO indayt_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Anak-anak Asyer: Yimna, Yiswa, Yiswi, Beria, dan Serah, saudara perempuan mereka. Anak Beria adalah Heber dan Malkiel. ");
INSERT INTO indayt_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Itulah keturunan Zilpa, yang diberikan Laban kepada Lea, anak perempuannya. Itulah yang dilahirkannya bagi Yakub sebanyak enam belas jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Anak-anak Rahel, istri Yakub: Yusuf dan Benyamin. ");
INSERT INTO indayt_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Lahirlah bagi Yusuf, di tanah Mesir, yang lahir dari Asnat, anak Potifera, imam di kota On: Manasye dan Efraim. ");
INSERT INTO indayt_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Anak-anak Benyamin adalah Bela, Bekher, Asybel, Gera, Naaman, Ehi, Rosh, Mupim, Hupim, dan Ared. ");
INSERT INTO indayt_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Itulah keturunan Rahel yang dilahirkannya bagi Yakub, seluruhnya ada empat belas jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Anak-Anak Dan: Husim. ");
INSERT INTO indayt_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Anak-anak Naftali: Yahzeel, Guni, Yezer, dan Syilem. ");
INSERT INTO indayt_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Itulah keturunan Bilha, yang diberikan Laban kepada Rahel, anak perempuannya. Dia melahirkan mereka bagi Yakub, seluruhnya ada tujuh jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Seluruh jiwa yang masuk ke Mesir bersama Yakub, yang adalah keturunan kandungnya, tidak termasuk para istri anak-anak Yakub, seluruhnya ada 66 jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Anak-anak Yusuf, yang lahir baginya di Mesir, berjumlah dua jiwa. Jadi, seisi rumah Yakub, yang masuk ke Mesir, ada tujuh puluh jiwa. ");
INSERT INTO indayt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Dia mengutus Yehuda mendahuluinya menghadap Yusuf untuk menunjukkan Gosyen kepadanya. Lalu, mereka pun tiba di tanah Gosyen. ");
INSERT INTO indayt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf mempersiapkan keretanya dan pergi untuk menemui ayahnya, Israel, di Gosyen, dan memperlihatkan diri kepadanya. Lalu, dia merangkul leher ayahnya, dan menangis pada lehernya untuk beberapa lama. ");
INSERT INTO indayt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Lalu, Israel berkata kepada Yusuf, “Sekarang, biarlah aku mati, setelah aku melihat wajahmu, sebab kamu masih hidup.” ");
INSERT INTO indayt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusuf berkata kepada saudara-saudaranya dan kepada seisi rumah ayahnya, “Aku akan pergi dan berbicara kepada Firaun, lalu berkata kepadanya, ‘Saudara-saudaraku dan seisi rumah ayahku, yang ada di tanah Kanaan, telah datang kepadaku. ");
INSERT INTO indayt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Orang-orang itu menggembalakan kawanannya karena mereka adalah para peternak. Mereka membawa kawanan dombanya, dan ternaknya, dan segala yang dimilikinya.’ ");
INSERT INTO indayt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lalu, Firaun akan memanggil kalian dan bertanya, ‘Apakah pekerjaan kalian?’ ");
INSERT INTO indayt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Kamu harus menjawab, ‘Hamba-hambamu ini sudah beternak sejak muda sampai sekarang, baik kami maupun nenek moyang kami.’ Dengan demikian, kamu boleh menetap di tanah Gosyen karena menggembalakan kawanan adalah suatu kekejian bagi orang Mesir.” ");
INSERT INTO indayt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kemudian, Yusuf menghadap Firaun dan bercerita kepadanya, katanya, “Ayahku dan saudara-saudaraku, dan kawanan kambing dombanya, dan kawanan sapinya, beserta segala yang ada padanya, telah datang dari tanah Kanaan. Lihatlah, mereka berada di tanah Gosyen.” ");
INSERT INTO indayt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Dia membawa beberapa saudaranya, yaitu lima orang, dan menghadapkannya kepada Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Lalu, Firaun berkata kepada saudara-saudaranya, “Apa pekerjaan kalian?” Mereka berkata kepada Firaun, “Kami, baik hamba-hambamu ini maupun nenek moyang kami, menggembalakan kawanan kambing domba.” ");
INSERT INTO indayt_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mereka berkata kepada Firaun, “Kami datang ke tanah ini untuk tinggal sementara karena tidak ada padang rumput bagi hamba-hambamu ini untuk kawanan kambing domba kami, sebab kelaparan di tanah Kanaan sangatlah hebat. Sekarang, kami memohon, izinkanlah hamba-hambamu ini tinggal di tanah Gosyen.” ");
INSERT INTO indayt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Lalu, Firaun berkata kepada Yusuf, katanya, “Ayahmu dan saudara-saudaramu telah datang kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tanah Mesir ini ada di hadapanmu. Biarlah ayahmu dan saudara-saudaramu tinggal di tanah Gosyen, di tempat terbaik dari tanah ini untuk tinggal. Jika kamu mengetahui ada orang-orang yang terampil di antara mereka, jadikanlah mereka sebagai pengawas atas ternakku.” ");
INSERT INTO indayt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kemudian, Yusuf membawa masuk Yakub, ayahnya, dan menempatkannya di hadapan Firaun. Lalu, Yakub memberkati Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firaun berkata kepada Yakub, “Berapa tahun umurmu?” ");
INSERT INTO indayt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakub berkata kepada Firaun, “Hari-hari dalam tahun-tahun pengembaraanku adalah 130 tahun. Hari-hari dalam tahun kehidupanku singkat dan sengsara, dan tidak mencapai hari-hari tahun kehidupan nenek moyangku dalam hari-hari pengembaraan mereka.” ");
INSERT INTO indayt_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Setelah itu, Yakub memberkati Firaun, lalu undur diri dari hadapan Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kemudian, Yusuf menempatkan ayah dan saudara-saudaranya, dan memberikan kepada mereka kepemilikan di tanah Gosyen, di tempat terbaik tanah itu, yaitu di tanah Rameses, sebagaimana yang diperintahkan Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf menyediakan roti bagi ayahnya, dan saudara-saudaranya, dan seisi rumah ayahnya, sejumlah mulut anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Pada satu waktu, tidak ada lagi roti di seluruh tanah itu karena kelaparan sangatlah berat sehingga tanah Mesir dan tanah Kanaan merana akibat kelaparan itu. ");
INSERT INTO indayt_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Lalu, Yusuf mengumpulkan semua uang yang diperoleh dari tanah Mesir dan tanah Kanaan untuk gandum yang mereka beli, dan Yusuf membawa uang itu ke istana Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Setelah uang di tanah Mesir dan di tanah Kanaan habis, seluruh orang Mesir datang kepada Yusuf dan berkata, “Berilah roti untuk kami sebab apa gunanya kami mati di hadapanmu? Uang kami sudah habis.” ");
INSERT INTO indayt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Akan tetapi, Yusuf menjawab, “Jika uang kalian sudah habis, berikanlah ternakmu dan aku akan memberikannya kepadamu sebagai ganti ternakmu.” ");
INSERT INTO indayt_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Lalu, mereka membawa ternaknya kepada Yusuf dan Yusuf memberikan roti kepada mereka sebagai pengganti kuda-kudanya, kawanan kambing dombanya, kawanan sapinya, dan keledai-keledainya. Pada tahun itu, dia memelihara mereka dengan roti sebagai pengganti segala ternak mereka. ");
INSERT INTO indayt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Setelah tahun itu berakhir, mereka datang lagi pada tahun yang kedua dan berkata kepadanya, “Kami tidak dapat menyembunyikannya dari Tuanku, bahwa uang kami sudah habis. Tuanku juga memiliki ternak kami sehingga tidak ada lagi yang tersisa di hadapanku Tuanku, kecuali tubuh kami dan tanah kami. ");
INSERT INTO indayt_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mengapa kami harus mati di depan matamu, baik kami maupun tanah kami? Belilah kami dan tanah kami untuk roti, maka kami maupun tanah kami akan menjadi hamba bagi Firaun. Berikanlah benih kepada kami supaya kami dapat hidup dan tidak mati. Dengan demikian, tanah ini tidak menjadi tandus.” ");
INSERT INTO indayt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jadi, Yusuf membeli semua tanah di Mesir untuk Firaun sebab orang Mesir menjual ladangnya masing-masing akibat kelaparan yang menimpa mereka. Jadi, tanah-tanah itu pun menjadi milik Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mengenai rakyat itu, dia memindahkannya ke kota-kota, dari ujung perbatasan Mesir yang satu kepada yang lainnya. ");
INSERT INTO indayt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hanya tanah yang dimiliki oleh para imam yang tidak dibelinya karena para imam memiliki bagian tetap dari Firaun dan mereka memakan bagian yang diberikan Firaun kepadanya. Oleh sebab itu, mereka tidak menjual tanahnya. ");
INSERT INTO indayt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kemudian, Yusuf berkata kepada rakyat itu, “Lihatlah, pada hari ini, aku telah membelimu dan tanahmu untuk Firaun. Inilah benih untukmu dan kamu harus menaburnya di tanah ini. ");
INSERT INTO indayt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pada masa panen, kamu harus memberikan seperlima bagian untuk Firaun dan empat bagian menjadi milikmu, untuk benih ladangmu, dan untuk rotimu, untuk mereka di dalam rumahmu, dan untuk makanan bagi anak-anakmu.” ");
INSERT INTO indayt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Lalu, mereka berkata, “Engkau telah menyelamatkan hidup kami! Biarlah kami mendapatkan kemurahan di mata Tuanku, dan kami akan menjadi hamba bagi Firaun.” ");
INSERT INTO indayt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Lalu, Yusuf menetapkan hal itu sebagai hukum atas tanah Mesir hingga hari ini, yaitu seperlima adalah milik Firaun. Hanya tanah imam yang tidak menjadi milik Firaun. ");
INSERT INTO indayt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Demikianlah Israel tinggal di tanah Mesir, di tanah Gosyen. Mereka mendapat kepemilikan di situ, beranak cucu, dan menjadi sangat banyak jumlahnya. ");
INSERT INTO indayt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub tinggal di Mesir selama tujuh belas tahun. Jadi umur Yakub adalah 147 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ketika waktu kematian Israel semakin dekat, dia memanggil Yusuf, anaknya, dan berkata kepadanya, “Jika sekarang aku mendapat kemurahanmu dalam pandanganmu, aku mohon, taruhlah tanganmu di bawah pangkal pahaku dan berjanjilah bahwa kamu akan menunjukkan kebaikan dan kesetiaan terhadapku. Aku mohon, jangan menguburku di Mesir. ");
INSERT INTO indayt_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Namun, aku ingin berbaring dengan nenek moyangku, dan kamu akan membawaku keluar dari Mesir, lalu menguburkanku di pekuburan mereka.” Jawab Yusuf, “Aku akan melakukan seperti yang engkau katakan.” ");
INSERT INTO indayt_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Lalu, Yakub berkata, “Bersumpahlah kepadaku.” Yusuf pun bersumpah kepadanya. Lalu, Israel bersujud di bagian kepala tempat tidurnya. ");
INSERT INTO indayt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Setelah semua itu, terjadilah, seseorang memberi tahu Yusuf, “Lihatlah, ayahmu sakit!” Lalu, dia membawa kedua anaknya, yaitu Manasye dan Efraim, besertanya. ");
INSERT INTO indayt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kemudian, seseorang memberi tahu Yakub dan berkata, “Lihatlah, anakmu, Yusuf, datang kepadamu,” sehingga Israel menguatkan dirinya dan duduk di tempat tidur. ");
INSERT INTO indayt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Lalu, Yakub berkata kepada Yusuf, “Allah Yang Mahakuasa menampakkan diri kepadaku di Lus, di tanah Kanaan dan memberkatiku. ");
INSERT INTO indayt_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Dia berkata kepadaku, ‘Lihatlah, Aku akan membuatmu beranak cucu dan melipatgandakanmu. Aku akan menjadikanmu bangsa yang besar dan akan memberikan tanah ini kepada keturunan-keturunan sesudahmu sebagai milik mereka untuk selama-lamanya.’ ");
INSERT INTO indayt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Sekarang, kedua anakmu, Efraim dan Manasye, yang lahir bagimu di tanah Mesir sebelum kedatanganku di Mesir, mereka adalah milikku, sama seperti Ruben dan Simeon. ");
INSERT INTO indayt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Akan tetapi, keturunanmu yang lahir setelah mereka akan menjadi milikmu. Mereka akan disebut berdasarkan nama kedua kakak mereka dalam warisan mereka. ");
INSERT INTO indayt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Lalu, aku, pada saat kedatanganku dari Padan, Rahel mati di sisiku, di tanah Kanaan, tidak jauh dari Efrata. Aku menguburnya di sana, di jalan menuju Efrata, yaitu Betlehem.” ");
INSERT INTO indayt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ketika Israel melihat anak-anak Yusuf, dia berkata, “Siapa mereka ini?” ");
INSERT INTO indayt_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuf berkata kepada ayahnya, “Merekalah anakku, yang telah Allah berikan kepadaku di tempat ini.” Dia berkata, “Aku minta kepadamu, bawalah mereka kepadaku, dan aku akan memberkatinya.” ");
INSERT INTO indayt_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Pada waktu itu, mata Israel sudah rabun karena usia sehingga dia tidak dapat melihat. Yusuf pun mendekatkan mereka kepada ayahnya, lalu dia mencium serta memeluk mereka. ");
INSERT INTO indayt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel berkata kepada Yusuf, “Aku tidak pernah berpikir untuk melihat wajahmu, tetapi lihatlah, Allah bahkan mengizinkanku untuk melihat keturunanmu.” ");
INSERT INTO indayt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Lalu, Yusuf menarik anak-anaknya dari pangkuan Israel dan dia berlutut dengan wajahnya sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Setelah itu, Yusuf menempatkan mereka berdua, Efraim di tangan kanannya, berhadapan dengan tangan kiri Israel; dan Manasye di tangan kirinya, berhadapan dengan tangan kanan Israel. Lalu, dia mendekatkan mereka kepada Israel. ");
INSERT INTO indayt_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Akan tetapi, Israel mengulurkan tangan kanannya dan menumpangkannya ke atas kepala Efraim, yang adalah anak bungsu, dan tangan kirinya ke atas kepala Manasye. Dia menyilangkan tangannya meskipun Manasye adalah anak sulung. ");
INSERT INTO indayt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Lalu, dia memberkati Yusuf dan berkata, “Allah, yang di hadapan-Nya, leluhurku Abraham dan Ishak hidup, Allah yang menjadi Gembalaku di sepanjang hidupku, sampai pada hari ini, ");
INSERT INTO indayt_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malaikat yang telah menebusku dari semua yang jahat, berkatilah kiranya anak-anak muda ini. Biarlah namaku ada dalam mereka, dan nama leluhurku, Abraham dan Ishak. Kiranya mereka bertambah-tambah menjadi banyak di tengah-tengah bumi ini.” ");
INSERT INTO indayt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ketika Yusuf melihat bahwa ayahnya menumpangkan tangan kanannya ke atas kepala Efraim, hal itu membuatnya tidak senang. Yusuf tidak senang akan hal itu. Yusuf memegang tangan ayahnya untuk memindahkannya dari kepala Efraim ke kepala Manasye. ");
INSERT INTO indayt_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusuf berkata kepada ayahnya, “Ayah, tangan kananmu ada pada anak yang salah. Manasye adalah anak sulung. Letakkanlah tangan kananmu ke atasnya.” ");
INSERT INTO indayt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Namun, ayahnya menolak dan berkata, “Aku tahu, Nak. Aku tahu. Dia juga akan menjadi bangsa, dan dia juga akan menjadi besar. Namun, sesungguhnya adiknya akan menjadi lebih besar darinya dan keturunannya akan menjadi bangsa yang besar.” ");
INSERT INTO indayt_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jadi, Israel memberkati mereka hari itu. Dia berkata, “Umat Israel akan memakai namamu apabila mereka memberkati orang. Mereka akan berkata, ‘Semoga Allah menjadikanmu seperti Efraim dan Manasye.’” Demikianlah dia memberkati mereka pada hari itu, katanya, “Allah menjadikanmu seperti Efraim dan seperti Manasye. Dia menempatkan Efraim di depan Manasye. ");
INSERT INTO indayt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kemudian, Israel berkata kepada Yusuf, “Lihatlah, aku hampir mati, tetapi Allah akan menyertaimu dan membawamu kembali ke tanah nenek moyangmu. ");
INSERT INTO indayt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Lebih lagi, aku telah memberikan kepadamu lebih besar dari saudaramu, yaitu wilayah yang aku rebut dengan pedang dan panah dari orang-orang Amori.” ");
INSERT INTO indayt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kemudian, Yakub memanggil semua anaknya dan berkata, “Berkumpullah kamu supaya aku dapat menceritakan kepadamu apa yang akan menimpamu pada hari-hari yang akan datang. ");
INSERT INTO indayt_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","‘Berkumpullah dan dengarlah, hai Anak-anak Yakub, dengarkanlah Israel, ayahmu.’” ");
INSERT INTO indayt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, anak sulungku, kamulah kejantananku, permulaan dari kegagahanku. Yang terunggul dalam keluhuran Yang terunggul dalam kekuatan. ");
INSERT INTO indayt_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bagaikan air yang tidak terkendali, kamu tidak lagi menjadi yang terunggul. Sebab, kamu telah menaiki tempat tidur ayahmu, lalu kamu menajiskannya. Kamu telah menaiki tempat tidurku!” ");
INSERT INTO indayt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon dan Lewi adalah kakak beradik. senjatanya adalah alat kekerasan. ");
INSERT INTO indayt_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hai jiwaku, janganlah masuk dalam perundingan mereka, janganlah kemuliaanku menyatu dalam perkumpulan mereka, sebab dalam amarahnya, mereka membunuh orang, dan dalam kesenangan dirinya, mereka telah melumpuhkan sapi jantan. ");
INSERT INTO indayt_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Terkutuklah amarah mereka sebab itu bengis. Aku akan mencerai-beraikan mereka di antara Yakub, dan menyerakkan mereka di antara Israel.” ");
INSERT INTO indayt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yehuda, saudara-saudaramu akan memujimu. Tanganmu ada di leher musuh-musuhmu. Anak-anak ayahmu akan berlutut kepadamu. ");
INSERT INTO indayt_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda bagaikan anak singa, dari mangsa kaupergi, anakku. Dia meniarap, dia berbaring bagaikan singa jantan atau singa betina. Siapa yang berani membangunkannya? ");
INSERT INTO indayt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tongkat kerajaan takkan beranjak dari Yehuda, begitu juga lambang pemerintahan dari antara kakinya, sampai ketika Shilo datang, dan kepadanyalah bangsa-bangsa akan taat. ");
INSERT INTO indayt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yang menambatkan keledainya pada pohon anggur dan anak keledainya pada pohon anggur terbaik. Dia mencuci pakaiannya dengan anggur dan jubahnya dengan darah buah anggur. ");
INSERT INTO indayt_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matanya memerah karena anggur. Giginya memutih karena susu.” ");
INSERT INTO indayt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulon akan hidup di tepi laut, dan pesisirnya bagi kapal-kapal, dan batasnya akan sampai ke Sidon.” ");
INSERT INTO indayt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakhar bagaikan keledai yang kuat, yang berbaring di antara kedua bebannya. ");
INSERT INTO indayt_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ketika dia melihat tempat peristirahatan yang baik dan tanah itu menyenangkan, dia membungkukkan bahunya untuk memikul beban, dan menjadi budak kerja paksa.” ");
INSERT INTO indayt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan akan menghakimi umatnya sebagai salah satu dari suku-suku Israel. ");
INSERT INTO indayt_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan akan seperti ular di pinggir jalan. Dia akan seperti ular berbisa di jalan setapak, yang memagut tumit kuda, sehingga yang menunggangnya jatuh ke belakang. ");
INSERT INTO indayt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aku menantikan keselamatan dari-Mu, ya TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad akan diserang oleh gerombolan, tetapi dia akan menyerang mereka pada tumitnya.” ");
INSERT INTO indayt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Bagi Asyer, makanannya akan berlimpah, dan dia akan menghidangkan santapan lezat raja.” ");
INSERT INTO indayt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali bagaikan seekor rusa betina yang terlepas, yang menghasilkan perkataan-perkataan indah.” ");
INSERT INTO indayt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusuf bagaikan dahan yang penuh buah, dahan penuh buah di dekat mata air, yang ranting-rantingnya menjalar ke tembok. ");
INSERT INTO indayt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Para pemanah menyusahkannya, membidiknya dan membencinya. ");
INSERT INTO indayt_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Namun, busur Yusuf tetap kukuh, dan lengan tangannya dibuat makin kuat, oleh tangan Yang Mahakuasanya Yakub, karena Sang Gembala, Batu Karang Israel. ");
INSERT INTO indayt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Allah ayahmu akan menolongmu. Semoga Allah Yang Mahakuasa memberkatimu dengan berkat dari surga, berkat-berkat dari kedalaman samudra paling bawah, berkat-berkat dari buah dada dan rahim. ");
INSERT INTO indayt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nenek moyangmu diberkati banyak hal baik. tetapi aku, ayahmu, bahkan lebih diberkati lagi. Kiranya semua berkat itu turun ke atas kepala Yusuf dan ke atas mahkota kepalanya yang teristimewa dari antara saudara-saudaranya.” ");
INSERT INTO indayt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin seperti serigala lapar. Pada pagi hari, dia membunuh mangsanya. Pada malam hari, dia membagi-bagikan rampasannya.” ");
INSERT INTO indayt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Itulah semua suku Israel, sebanyak dua belas, dan itulah yang telah dikatakan ayahnya kepada mereka, lalu dia pun memberkati mereka. Dia memberkati mereka, masing-masing sesuai dengan berkatnya. ");
INSERT INTO indayt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kemudian, dia berpesan kepada mereka dan berkata kepada mereka, “Aku akan dikumpulkan bersama bangsaku, kuburkanlah aku bersama dengan nenek moyangku di dalam gua, di ladang Efron orang Het itu, ");
INSERT INTO indayt_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","yaitu di gua yang ada di ladang Makhpela, di depan Mamre, di tanah Kanaan, yang telah Abraham beli beserta dengan ladangnya dari Efron, orang Het itu, sebagai pekuburan miliknya. ");
INSERT INTO indayt_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Di sanalah mereka menguburkan Abraham dan Sara, istrinya. Di sanalah mereka menguburkan Ishak dan Ribka, istrinya. Di sanalah aku menguburkan Lea. ");
INSERT INTO indayt_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Pembelian ladang dan gua di dalamnya adalah dari keturunan Het.” ");
INSERT INTO indayt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Setelah Yakub selesai berpesan kepada anak-anaknya, dia menarik kakinya ke tempat tidur, mengembuskan napas terakhirnya, dan dikumpulkan bersama umatnya. ");
INSERT INTO indayt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Setelah itu, Yusuf merebahkan diri pada wajah ayahnya dan menciumnya. ");
INSERT INTO indayt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yusuf memerintahkan para pelayannya, yaitu para tabib, untuk merempah-rempahi jenazah ayahnya. Para tabib pun merempah-rempahi jenazah Yakub. ");
INSERT INTO indayt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dia memenuhinya selama 40 hari karena demikianlah waktu untuk merempah-rempahi jenazah, dan orang-orang Mesir menangisinya selama tujuh puluh hari. ");
INSERT INTO indayt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Setelah masa berkabung usai, Yusuf berkata kepada seisi istana Firaun, katanya, “Jika aku mendapat kemurahan di matamu, aku mohon, bicaralah di telinga Firaun, ");
INSERT INTO indayt_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ayahku telah membuatku bersumpah, katanya: Lihatlah, aku akan mati. Di kuburan yang telah kugali sendiri, di tanah Kanaan, di sanalah kamu harus menguburkanku.’ Oleh karena itu, sekarang, aku mohon, izinkanlah aku pergi dan menguburkan ayahku, lalu aku akan kembali.” ");
INSERT INTO indayt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Firaun berkata, “Pergilah dan kuburkanlah ayahmu karena dia telah memintamu untuk bersumpah.” ");
INSERT INTO indayt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Jadi, Yusuf pun pergi untuk menguburkan ayahnya. Dia pergi beserta semua pelayan Firaun, para tua-tua istana Firaun, dan semua tua-tua tanah mesir, ");
INSERT INTO indayt_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dan seisi rumah Yusuf, dan saudara-saudaranya, dan seisi rumah ayahnya. Yang mereka tinggalkan di tanah Gosyen hanya anak-anaknya, kawanan kambing dombanya, dan kawanan sapinya. ");
INSERT INTO indayt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bersama mereka, turut pula kereta-kereta dan orang-orang berkuda sehingga iring-iringan itu menjadi sangat besar. ");
INSERT INTO indayt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kemudian, mereka tiba di Goren-Haatad, yang terletak di seberang Yordan, dan di situ mereka meratap dengan ratapan yang sangat keras. Dia mengadakan perkabungan bagi ayahnya selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ketika penduduk tanah itu, yaitu orang-orang Kanaan, melihat perkabungan di Goren-Haatad itu, mereka berkata, “Ini merupakan perkabungan yang amat besar bagi orang Mesir.” Demikianlah, tempat itu dinamai Abel-Mizraim, yang terletak di seberang Yordan. ");
INSERT INTO indayt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Anak-anaknya melaksanakan baginya, sebagaimana pesannya kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Anak-anaknya membawanya ke tanah Kanaan, lalu menguburnya di gua, di ladang Makhpela, yang telah dibeli oleh Abraham dari Efron, orang Het, sebagai pekuburan miliknya, yang terletak di sebelah timur Mamre. ");
INSERT INTO indayt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Setelah itu, Yusuf kembali ke Mesir, dia dan saudara-saudaranya, dan semua yang turut dengannya untuk menguburkan ayahnya. ");
INSERT INTO indayt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ketika saudara-saudara Yusuf menyadari bahwa ayah mereka telah mati, mereka berkata, “Mungkin saja Yusuf akan melawan kita dan akan membalas kita, membalaskan segala kejahatan yang telah kita lakukan terhadapnya.” ");
INSERT INTO indayt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Jadi, mereka mengirim pesan kepada Yusuf, katanya, “Sebelum mati, ayahmu berpesan, katanya, ");
INSERT INTO indayt_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Beginilah harus kamu katakan kepada Yusuf: Sekarang, aku mohon, ampunilah pelanggaran saudara-saudaramu dan dosanya karena mereka melakukan hal jahat terhadapmu.’ Karena itu, kami memohon kepadamu, ampunilah pelanggaran dari hamba-hamba Allah ayahmu ini.” Yusuf pun menangis ketika mereka mengatakan hal itu kepadanya. ");
INSERT INTO indayt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kemudian, saudara-saudara Yusuf pun datang dan berlutut di hadapannya, dan mereka berkata, “Lihatlah, kami adalah hambamu.” ");
INSERT INTO indayt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Lalu, Yusuf berkata kepada mereka, “Jangan takut! Apakah aku ini pengganti Allah? ");
INSERT INTO indayt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tentang kalian, kalian memang telah merancang yang jahat terhadapku, tetapi Allah merancang yang baik untuk melakukan sebagaimana yang terjadi saat ini, untuk menyelamatkan hidup banyak orang. ");
INSERT INTO indayt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jadi, jangan takut. Aku akan memelihara kalian dan anak-anak kalian.” Demikianlah Yusuf menenangkan saudara-saudaranya dan berbicara dengan baik kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf tetap tinggal di Mesir bersama seisi rumah ayahnya. Yusuf hidup selama 110 tahun. ");
INSERT INTO indayt_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusuf masih melihat generasi ketiga dari anak-anak Efraim. Bahkan anak-anak Makhir, anak Manasye, dilahirkan di pangkuan Yusuf. ");
INSERT INTO indayt_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kemudian, Yusuf berkata kepada saudara-saudaranya, “Aku akan mati. Akan tetapi, Allah pasti akan datang kepadamu dan membawamu keluar dari tanah ini ke tanah yang telah disumpahkan-Nya kepada Abraham, kepada Ishak, dan kepada Yakub.” ");
INSERT INTO indayt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Lalu, Yusuf meminta anak-anak Israel bersumpah kepadanya, katanya, “Allah pasti akan datang kepadamu. Karena itu, kamu harus membawa tulang-tulangku dari sini.” ");
INSERT INTO indayt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Jadi, Yusuf mati pada usia 110 tahun dan mereka merempahi-rempahinya, lalu dia diletakkan dalam sebuah peti di Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Inilah nama anak-anak Israel yang masuk ke Mesir bersama Yakub, masing-masing datang dengan keluarganya: ");
INSERT INTO indayt_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Lewi, Yehuda, ");
INSERT INTO indayt_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakhar, Zebulon, Benyamin, ");
INSERT INTO indayt_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad, dan Asyer. ");
INSERT INTO indayt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Seluruh jiwa yang adalah keturunan langsung dari Yakub berjumlah tujuh puluh, tetapi Yusuf sudah berada di Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Lalu, Yusuf mati, begitu pula dengan semua saudaranya, dan semua orang dari generasi itu. ");
INSERT INTO indayt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Akan tetapi, keturunan Israel beranak cucu, dan terus bertambah banyak, dan berlipat ganda, dan menjadi sangat kuat sehingga mereka memenuhi negeri itu. ");
INSERT INTO indayt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kemudian, seorang raja baru, yang tidak mengenal Yusuf, muncul di Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Dia berkata kepada rakyatnya, “Lihatlah, orang dari keturunan Israel itu menjadi banyak dan lebih kuat daripada kita. ");
INSERT INTO indayt_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mari kita bertindak cerdik terhadap mereka. Jangan sampai mereka berlipat ganda sehingga ketika terjadi perang, mereka akan bersekutu dengan musuh-musuh kita untuk mengalahkan kita, lalu pergi dari tanah ini.” ");
INSERT INTO indayt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Karena itu, mereka menunjuk para mandor untuk menindas keturunan Israel dengan kerja paksa. Mereka membangun kota-kota perbekalan bagi Firaun, yaitu Pitom dan Raamses. ");
INSERT INTO indayt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Namun, semakin mereka menindasnya, keturunan Israel justru semakin berlipat ganda dan tersebar. Mereka pun takut karena keturunan Israel itu. ");
INSERT INTO indayt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Dengan kekerasan, orang Mesir memaksa keturunan Israel untuk bekerja, ");
INSERT INTO indayt_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","dan membuat hidup mereka pahit dengan perbudakan yang berat, yaitu mengolah tanah liat, dan batu bata, dan segala jenis pekerjaan di ladang. Segala pekerjaan mereka, yang dipaksakan kepada mereka untuk dilakukan, disertai dengan kekerasan. ");
INSERT INTO indayt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Setelah itu, Raja Mesir berkata kepada para bidan yang membantu kelahiran orang Ibrani, yang satu bernama Sifra dan yang lain bernama Pua, ");
INSERT INTO indayt_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","katanya, “Ketika kamu menolong perempuan Ibrani untuk melahirkan dari tempat mereka melahirkan, jika itu bayi laki-laki, kamu harus membunuhnya. Akan tetapi, jika itu bayi perempuan, biarkan dia hidup.” ");
INSERT INTO indayt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Namun, bidan-bidan itu takut akan Allah sehingga mereka tidak melakukan seperti yang diperintahkan raja kepada mereka, melainkan membiarkan bayi laki-laki tetap hidup. ");
INSERT INTO indayt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Oleh sebab itu, Raja Mesir memanggil para bidan itu dan berkata kepada mereka, “Mengapa kalian melakukan hal ini dan membiarkan bayi laki-laki tetap hidup?” ");
INSERT INTO indayt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bidan-bidan itu berkata kepada Firaun, “Perempuan-perempuan Ibrani itu tidak seperti perempuan Mesir karena mereka bertenaga dan sudah melahirkan sebelum bidan sampai kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Karena itu, Allah berlaku baik terhadap kedua bidan itu. Bangsa itu berlipat ganda dan menjadi sangat kuat. ");
INSERT INTO indayt_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Karena bidan-bidan itu takut akan Allah, Dia membangun rumah tangga untuk mereka. ");
INSERT INTO indayt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Lalu, Firaun memberikan perintah kepada seluruh rakyatnya, “Setiap bayi laki-laki yang dilahirkan harus kamu lempar ke sungai, tetapi kamu boleh membiarkan setiap bayi perempuan tetap hidup.” ");
INSERT INTO indayt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ada seorang laki-laki dari suku Lewi yang memperistri seorang perempuan keturunan Lewi. ");
INSERT INTO indayt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Perempuan itu mengandung dan melahirkan seorang bayi laki-laki. Ketika perempuan itu melihat bahwa bayi itu elok, dia menyembunyikannya selama tiga bulan. ");
INSERT INTO indayt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ketika dia tidak dapat menyembunyikannya lebih lama lagi, dia mengambil sebuah keranjang yang terbuat dari papirus dan melapisinya dengan ter cair, lalu memasukkan bayi itu ke dalamnya, dan dia meletakkannya di antara alang-alang di tepi sungai. ");
INSERT INTO indayt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kakak perempuan bayi itu berdiri agak jauh untuk mengetahui yang akan terjadi kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Lalu, datanglah putri Firaun untuk mandi di sungai sementara dayang-dayangnya menyusuri tepi sungai. Ketika dia melihat keranjang itu di antara alang-alang, dia menyuruh salah satu dayangnya untuk mengambilnya. ");
INSERT INTO indayt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Sewaktu dia membukanya, dia melihat bayi itu, dan lihatlah, bayi itu menangis. Dia pun berbelaskasihan kepadanya dan berkata, “Ini pasti salah satu anak orang Ibrani.” ");
INSERT INTO indayt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kakak bayi itu berkata kepada putri Firaun, “Bolehkah aku pergi dan memanggil pengasuh dari perempuan Ibrani untuk menyusui bayi itu bagi engkau?” ");
INSERT INTO indayt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Putri Firaun berkata kepadanya, “Ya, pergilah.” Lalu, gadis itu pergi dan memanggil ibu bayi itu. ");
INSERT INTO indayt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Putri Firaun berkata kepada ibu bayi itu, “Bawalah bayi ini dan susuilah dia bagiku. Aku akan memberikan upahmu kepadamu.” Lalu, perempuan itu mengambil bayi itu dan menyusuinya. ");
INSERT INTO indayt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Setelah anak itu bertambah besar, ibunya membawa dia kepada putri Firaun dan anak itu menjadi anaknya. Dia menamainya Musa, katanya, “Sebab, aku telah menariknya keluar dari air.” ");
INSERT INTO indayt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Pada suatu hari, ketika Musa sudah dewasa, dia pergi kepada saudara-saudaranya dan melihat kerja paksa mereka. Lalu, dia melihat seorang Mesir sedang memukuli seorang Ibrani, salah satu dari saudara-saudaranya itu. ");
INSERT INTO indayt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Dia menoleh ke sana kemari, dan ketika dia melihat bahwa di situ tidak ada orang, dia pun membunuh orang Mesir itu dan menyembunyikannya di dalam pasir. ");
INSERT INTO indayt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Keesokan harinya, ketika dia keluar, lihatlah, ada dua orang Ibrani saling berkelahi. Dia bertanya kepada orang yang bersalah, “Mengapa kamu memukul temanmu?” ");
INSERT INTO indayt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Orang itu menjawab, “Siapa yang mengangkatmu menjadi pemimpin dan hakim atas kami? Apa engkau akan membunuhku seperti engkau membunuh orang Mesir itu?” Musa menjadi takut dan berpikir, “Pasti hal itu sudah ketahuan.” ");
INSERT INTO indayt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ketika Firaun mendengar tentang hal itu, dia berusaha untuk membunuh Musa. Namun, Musa telah melarikan diri dari Firaun dan tinggal di tanah Midian. Dia duduk di tepi sebuah sumur. ");
INSERT INTO indayt_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Imam dari Midian memiliki tujuh anak perempuan. Mereka datang untuk menimba air dan mengisi palungan-palungan untuk memberi minum kawanan domba ayahnya. ");
INSERT INTO indayt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Para gembala datang dan mengusir mereka, tetapi Musa bangkit untuk menolong mereka dan memberi minum kawanan domba mereka. ");
INSERT INTO indayt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ketika mereka kembali kepada Rehuel, ayah mereka, dia bertanya, “Mengapa hari ini kalian cepat sekali pulang?” ");
INSERT INTO indayt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Mereka menjawab, “Ada orang Mesir yang melepaskan kami dari tangan para gembala, bahkan dia menimbakan air untuk kami dan memberi minum kawanan domba kami.” ");
INSERT INTO indayt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Dia bertanya kepada anak-anaknya, “Lalu, mana dia? Mengapa kamu meninggalkan orang itu? Panggillah dia, ajak dia untuk makan roti.” ");
INSERT INTO indayt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa sepakat untuk tinggal bersama orang itu dan dia memberikan Zipora, anaknya, kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kemudian, perempuan itu melahirkan seorang anak laki-laki dan Musa menamainya Gersom, sebab katanya, “Aku telah menjadi seorang pendatang di negeri asing.” ");
INSERT INTO indayt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Beberapa lama berselang, Raja Mesir pun mati. Namun, keturunan Israel masih mengerang karena perbudakan, lalu mereka pun berseru-seru, dan seruan mereka karena perbudakan itu naik kepada Allah. ");
INSERT INTO indayt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allah mendengar erangan mereka dan Allah ingat akan perjanjian-Nya dengan Abraham, dengan Ishak, dan dengan Yakub. ");
INSERT INTO indayt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Allah melihat keturunan Israel dan Allah memperhatikan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Pada waktu itu, Musa sedang menggembalakan kawanan domba Yitro, ayah mertuanya, seorang imam dari Midian. Dia menggiring kawanan itu ke sebelah padang belantara dan tiba di gunung Allah, yaitu Horeb. ");
INSERT INTO indayt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Lalu, malaikat TUHAN menampakkan diri kepadanya dalam api yang menyala-nyala dari tengah-tengah semak belukar. Dia mengamatinya, dan lihatlah, semak belukar itu menyala-nyala dalam api, tetapi semak belukar itu tidak dilahap olehnya. ");
INSERT INTO indayt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Lalu, Musa berkata, “Aku akan berpaling untuk melihat pemandangan yang hebat itu, mengapa semak belukar itu tidak terbakar?” ");
INSERT INTO indayt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ketika TUHAN melihat bahwa dia berpaling untuk melihat, Allah memanggilnya dari tengah-tengah semak belukar itu dan berkata, “Musa, Musa!” Musa menjawab, “Ini, aku.” ");
INSERT INTO indayt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kemudian, Dia berfirman, “Jangan mendekat! Lepaskanlah kasut dari kakimu karena tempatmu berdiri itu adalah tanah yang suci.” ");
INSERT INTO indayt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Dia berfirman lagi, “Akulah Allah nenek moyangmu, Allah Abraham, Allah Ishak, dan Allah Yakub.” Lalu, Musa menyembunyikan wajahnya karena dia takut memandang Allah. ");
INSERT INTO indayt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kemudian, TUHAN berfirman, “Sesungguhnya, Aku telah melihat kesengsaraan umat-Ku di Mesir dan telah mendengar tangisan mereka karena para mandor mereka. Sebab, Aku mengetahui penderitaan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Karena itu, Aku telah turun untuk melepaskan mereka dari tangan orang Mesir dan untuk menuntun mereka keluar dari negeri itu menuju ke suatu negeri yang baik dan luas, ke negeri yang berlimpah susu dan madu, yaitu ke negeri orang Kanaan, orang Het, orang Amori, orang Feris, orang Hewi, dan orang Yebus. ");
INSERT INTO indayt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Sekarang, lihatlah, tangisan keturunan Israel telah sampai kepada-Ku dan Aku juga telah melihat penindasan, yang dengannya orang Mesir menindas mereka. ");
INSERT INTO indayt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Jadi sekarang, pergilah! Aku akan mengutusmu kepada Firaun supaya kamu dapat membawa umat-Ku, keturunan Israel, keluar dari Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Namun, Musa berkata kepada Allah, “Siapakah aku ini sehingga aku harus menghadap Firaun dan aku harus membawa keturunan Israel keluar dari Mesir?” ");
INSERT INTO indayt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dia berfirman, “Sesungguhnya, Aku akan menyertaimu dan inilah tanda bagimu bahwa Aku telah mengutusmu: ketika kamu telah membawa bangsa ini keluar dari Mesir, kamu akan melayani Allah di gunung ini.” ");
INSERT INTO indayt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kemudian, Musa berkata kepada Allah, “Lihatlah, ketika aku pergi kepada keturunan Israel dan berkata kepada mereka, ‘Allah nenek moyangmu telah mengutus aku kepadamu,’ lalu mereka akan bertanya kepadaku, ‘Siapa nama-Nya?’, apa yang harus kukatakan kepada mereka?” ");
INSERT INTO indayt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allah berfirman kepada Musa, “AKU ADALAH AKU.” Lalu, Dia berfirman, “Kamu harus mengatakan ini kepada keturunan Israel, ‘SANG AKU yang telah mengutusku kepadamu.’” ");
INSERT INTO indayt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Allah berfirman lagi kepada Musa, “Inilah yang harus kamu katakan kepada keturunan Israel, ‘TUHAN, Allah nenek moyangmu, Allah Abraham, Allah Ishak, dan Allah Yakub telah mengutusku kepadamu.’ Itulah nama-Ku untuk selama-lamanya dan itulah pengingat akan Aku, turun-temurun. ");
INSERT INTO indayt_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Pergilah, dan kumpulkanlah tua-tua Israel dan katakanlah kepada mereka bahwa TUHAN, Allah nenek moyangmu, Allah Abraham, Ishak, dan Yakub telah menampakkan diri kepadaku dan berfirman, ‘Sesungguhnya, Aku telah memperhatikanmu dan yang terjadi atasmu di Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Aku telah berfirman bahwa Aku akan membawamu keluar dari penderitaan di Mesir ke negeri orang Kanaan, orang Het, orang Amori, orang Feris, orang Hewi, dan orang Yebus, yaitu negeri yang berlimpah susu dan madu.’ ");
INSERT INTO indayt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Mereka akan mendengarkan suaramu. Setelah itu, kamu dan tua-tua Israel harus menghadap Raja Mesir dan kamu harus berkata kepadanya, ‘TUHAN, Allah orang Ibrani telah menjumpai kami. Sebab itu, biarkanlah kami pergi ke padang belantara sejauh tiga hari perjalanan supaya kami dapat berkurban untuk TUHAN, Allah kami.’ ");
INSERT INTO indayt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Namun, Aku tahu bahwa Raja Mesir tidak akan memberimu izin untuk pergi, kecuali dengan tangan yang kuat. ");
INSERT INTO indayt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Jadi, Aku akan mengulurkan tangan-Ku dan memukul Mesir dengan segala keajaiban-keajaiban-Ku, yang akan Aku lakukan di tengah-tengah mereka. Setelah itu, dia akan melepasmu pergi. ");
INSERT INTO indayt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Aku pun akan memberikan kemurahan hati kepada bangsa ini dalam pandangan orang Mesir sehingga ketika kamu pergi, kamu tidak akan pergi dengan tangan kosong. ");
INSERT INTO indayt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Setiap perempuan harus meminta barang-barang perak, barang-barang emas, dan pakaian dari tetangganya maupun dari perempuan yang tinggal sementara di rumahnya. Kamu harus mengenakannya pada anak laki-lakimu dan anak perempuanmu. Demikianlah kamu akan merampasi orang Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa menjawab dan berkata, “Namun, lihatlah, mereka tidak akan percaya kepadaku atau tidak mau mendengarkan suaraku sebab mereka akan berkata, ‘TUHAN tidak menampakkan diri kepadamu.’” ");
INSERT INTO indayt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","TUHAN berfirman kepadanya, “Apa yang ada di tanganmu itu?” Dia berkata, “Sebatang tongkat.” ");
INSERT INTO indayt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kemudian, Dia berfirman, “Lemparkanlah itu ke tanah!” Dia melemparkannya ke tanah dan tongkat itu menjadi seekor ular sehingga Musa lari darinya. ");
INSERT INTO indayt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Lalu, TUHAN berfirman kepada Musa, “Ulurkan tanganmu dan tangkaplah ekornya.” Dia mengulurkan tangannya dan memegangnya, lalu ular itu menjadi sebatang tongkat di tangannya. ");
INSERT INTO indayt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Dengan demikian, mereka akan percaya bahwa TUHAN, Allah nenek moyangmu, Allah Abraham, Allah Ishak, dan Allah Yakub telah menampakkan diri kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kemudian, TUHAN berfirman lagi kepadanya, “Sekarang, masukkanlah tanganmu ke dalam jubahmu.” Dia pun memasukkan tangannya ke dalam jubahnya. Ketika dia mengeluarkannya, lihatlah, tangannya kena kusta seperti salju. ");
INSERT INTO indayt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Lalu, Allah berfirman, “Masukanlah kembali tanganmu ke dalam jubahmu.” Dia pun memasukkan kembali tangannya ke dalam jubahnya. Ketika dia mengeluarkannya dari dalam jubahnya, lihatlah, tangannya pulih kembali seperti sekujur tubuhnya. ");
INSERT INTO indayt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Hal ini akan terjadi, jika mereka tidak percaya kepadamu dan tidak mau mendengarkan suaramu sejak tanda yang pertama, mereka akan percaya dengan suara dari tanda berikutnya. ");
INSERT INTO indayt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Jika mereka tidak percaya juga dengan dua tanda tersebut atau tidak mau mendengarkan suaramu, kamu harus mengambil air dari sungai dan mencurahkannya ke atas tanah yang kering. Lalu, air yang kamu ambil dari sungai itu akan menjadi darah di atas tanah kering itu.” ");
INSERT INTO indayt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Namun, Musa berkata kepada TUHAN, “Oh, Tuhanku, aku bukan orang yang pandai berkata-kata, baik dahulu maupun sejak Engkau berfirman kepada hamba-Mu ini. Sebab, aku lambat berbicara dan lambat lidah.” ");
INSERT INTO indayt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kemudian, TUHAN berfirman kepadanya, “Siapakah yang membuat mulut manusia? Siapakah yang menjadikan orang bisu, atau tuli, atau melihat, atau buta? Bukankah Aku, TUHAN? ");
INSERT INTO indayt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Jadi, sekarang pergilah! Aku akan menyertai mulutmu dan mengajarkan kepadamu apa yang harus kamu ucapkan.” ");
INSERT INTO indayt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Namun, dia berkata, “Oh, Tuhanku, aku mohon, utuslah orang lain saja.” ");
INSERT INTO indayt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kemarahan TUHAN pun menyala atas Musa, dan Dia berfirman, “Bukankah Harun, orang Lewi itu, kakakmu? Aku tahu, dia pandai berkata-kata. Lihat, dia akan datang untuk menemuimu. Ketika dia menemuimu, dia akan bersukacita dalam hatinya. ");
INSERT INTO indayt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kamu harus berbicara dengannya dan menaruh perkataan-perkataan itu dalam mulutnya, dan Aku akan menyertai mulutmu dan mulutnya, dan akan mengajarkan kepadamu apa yang harus kalian lakukan. ");
INSERT INTO indayt_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Jadi, dia harus berbicara bagimu kepada bangsa itu. Dia akan berbicara kepada bangsa itu bagimu, dan dia akan menjadi mulutmu, dan kamu akan menjadi seperti Allah baginya. ");
INSERT INTO indayt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kamu juga harus membawa tongkat ini di tanganmu, yang dengan itu kamu akan membuat tanda-tanda.” ");
INSERT INTO indayt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kemudian, Musa kembali kepada Yitro, ayah mertuanya dan berkata kepadanya, “Aku mohon, izinkan aku pergi dan kembali kepada saudara-saudaraku yang berada di Mesir untuk melihat apakah mereka masih hidup?” Yitro berkata kepada Musa, “Pergilah dalam damai.” ");
INSERT INTO indayt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","TUHAN telah berfirman kepada Musa di Midian, “Kembalilah ke Mesir karena orang-orang yang mengincar nyawamu sudah mati.” ");
INSERT INTO indayt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Setelah itu, Musa menaikkan istri dan anak-anaknya ke atas keledai dan kembali ke tanah Mesir. Musa membawa tongkat Allah di tangannya. ");
INSERT INTO indayt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","TUHAN berfirman kepada Musa, “Ketika kamu kembali ke Mesir, ingatlah akan segala keajaiban yang telah Aku serahkan ke dalam tanganmu dan lakukanlah itu di hadapan Firaun. Namun, Aku akan mengeraskan hatinya supaya dia tidak membiarkan bangsa itu pergi. ");
INSERT INTO indayt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kemudian, kamu harus berkata kepada Firaun, ‘Inilah firman TUHAN: Israel adalah anak-Ku, anak sulung-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Karena itu, Aku berfirman kepadamu untuk melepaskan anak-Ku supaya mereka dapat melayani-Ku. Jika kamu menolak untuk membiarkannya pergi, lihatlah, Aku akan membunuh anakmu, anak sulungmu.’” ");
INSERT INTO indayt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dalam perjalanannya, di suatu tempat bermalam, TUHAN menjumpainya dan bermaksud untuk membunuhnya. ");
INSERT INTO indayt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kemudian, Zipora mengambil batu tajam untuk mengerat kulit khitan anaknya, dan dia melemparkannya ke kaki Musa, katanya, “Sesungguhnya, kamu adalah mempelai darah bagiku.” ");
INSERT INTO indayt_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Sebab itu, Allah membiarkannya. Kemudian, Zipora berkata, “Mempelai darah,” mengenai sunat itu. ");
INSERT INTO indayt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","TUHAN berfirman kepada Harun, “Pergilah ke padang belantara untuk menjumpai Musa.” Lalu, dia pergi, dan berjumpa dengan Musa di gunung Allah, dan menciumnya. ");
INSERT INTO indayt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa mengatakan kepada Harun mengenai semua perkataan TUHAN, yang telah mengutusnya, dan tentang semua tanda yang telah diperintahkan-Nya. ");
INSERT INTO indayt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kemudian, Musa dan Harun pergi untuk mengumpulkan semua tua-tua keturunan Israel. ");
INSERT INTO indayt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harun menyampaikan semua firman yang telah TUHAN katakan kepada Musa serta melakukan tanda-tanda itu di hadapan orang-orang itu. ");
INSERT INTO indayt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Sebab itu, orang-orang itu percaya. Ketika mereka mendengar bahwa TUHAN telah memperhatikan keturunan Israel dan Dia telah melihat kesengsaraan mereka, mereka menundukkan kepala mereka dan menyembah. ");
INSERT INTO indayt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Setelah itu, Musa dan Harun pergi dan berkata kepada Firaun, “Inilah firman TUHAN, Allah Israel, ‘Biarkanlah umat-Ku pergi supaya mereka dapat mengadakan perayaan bagi-Ku di padang belantara.’” ");
INSERT INTO indayt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Namun, Firaun berkata, “Siapa itu TUHAN? Apa aku harus taat kepada suara-Nya dan membiarkan orang Israel pergi? Aku tidak kenal TUHAN dan Aku tidak akan membiarkan orang Israel pergi!” ");
INSERT INTO indayt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kemudian, mereka berkata, “Allah orang Ibrani telah menjumpai kami. Kami mohon, izinkanlah kami pergi sejauh tiga hari perjalanan ke padang belantara untuk mempersembahkan kurban kepada TUHAN, Allah kami, supaya Dia tidak menimpakan wabah penyakit atau pedang atas kami.” ");
INSERT INTO indayt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Namun, Raja Mesir berkata kepada mereka, “Musa dan Harun! Mengapa kalian menghentikan orang-orang itu dari pekerjaannya? Kembali saja pada pekerjaan kalian!” ");
INSERT INTO indayt_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Firaun berkata lagi, “Lihat! Orang-orang itu sudah terlalu banyak di tanah ini dan kamu menghentikan mereka dari pekerjaannya!” ");
INSERT INTO indayt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Pada hari itu juga, Firaun bertitah kepada para mandor bangsa itu dan kepada kepala tukangnya, katanya, ");
INSERT INTO indayt_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kalian tidak boleh lagi memberikan jerami kepada bangsa itu untuk membuat batu bata seperti sebelumnya. Biar mereka sendiri yang pergi dan mengumpulkan jerami. ");
INSERT INTO indayt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Namun, jumlah batu bata yang sudah mereka buat selama tiga hari terakhir ini harus tetap kalian bebankan kepada mereka. Kalian tidak boleh menguranginya sebab mereka itu malas. Itulah sebabnya, mereka menuntut dan berkata, ‘Biarkan kami pergi untuk berkurban kepada Allah kami.’ ");
INSERT INTO indayt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Jadi, pekerjaan orang-orang itu harus diperberat supaya mereka tetap mengerjakannya dan tidak menghiraukan kata-kata dusta.” ");
INSERT INTO indayt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Sebab itu, para mandor bangsa itu dan kepala-kepala tukangnya pergi untuk menyampaikannya kepada bangsa itu, katanya, “Inilah titah Firaun, ‘Aku tidak akan memberikan jerami lagi kepada kalian. ");
INSERT INTO indayt_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kalian sendiri yang harus pergi mendapatkan jerami di mana pun kalian dapat menemukannya. Namun, pekerjaanmu tidak boleh berkurang sedikit pun.’” ");
INSERT INTO indayt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Bangsa itu pun berpencar ke seluruh tanah Mesir untuk mengumpulkan tunggul jerami. ");
INSERT INTO indayt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Para mandor menindas mereka, katanya, “Penuhi pekerjaan kalian sehari-hari sebagaimana yang dititahkan, seperti ketika masih ada jerami.” ");
INSERT INTO indayt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Para mandor Firaun memukuli para kepala tukang dari keturunan Israel, yang mereka angkat atas bangsa itu dan berkata, “Mengapa kalian belum memenuhi pekerjaanmu, baik kemarin maupun hari ini, untuk membuat batu bata sebanyak sebelumnya?” ");
INSERT INTO indayt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kemudian, para kepala tukang dari keturunan Israel itu menghadap dan berseru kepada Firaun, katanya, “Mengapa engkau memperlakukan hamba-hambamu seperti ini? ");
INSERT INTO indayt_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tidak ada lagi jerami yang diberikan kepada hamba-hambamu, tetapi mereka berkata kepada kami, ‘Buat batu bata!’ Lihatlah, hamba-hambamu ini dipukuli, padahal orang-orangmulah yang bersalah.” ");
INSERT INTO indayt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Namun, dia berkata, “Pemalas! Kalian pemalas! Itulah sebabnya kalian berkata, ‘Biarlah kami pergi dan berkurban kepada TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Sekarang, kembalilah bekerja! Jerami tidak akan diberikan kepada kalian, tetapi kalian tetap harus menyetorkan batu bata sejumlah yang sudah ditetapkan.” ");
INSERT INTO indayt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Para kepala tukang dari keturunan Israel itu pun menyadari bahwa mereka sedang dalam kesulitan setelah dikatakan, “Kalian tidak boleh mengurangi jumlah batu bata kalian sehari-hari sebagaimana yang sudah dititahkan!” ");
INSERT INTO indayt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Setelah mereka undur dari Firaun, mereka berjumpa dengan Musa dan Harun yang sedang berdiri menantikan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Mereka berkata kepada keduanya, “Semoga TUHAN melihatmu dan menghakimimu sebab engkau telah membusukkan nama kami di mata Firaun dan di mata para hambanya. Dengan demikian, engkau telah memberikan sebilah pedang di tangan mereka untuk membunuh kami.” ");
INSERT INTO indayt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Setelah itu, Musa kembali kepada TUHAN dan berkata, “Oh, TUHAN, mengapa Engkau melakukan hal yang jahat kepada bangsa ini? Mengapa pula Engkau mengutusku? ");
INSERT INTO indayt_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Karena sejak aku menghadap Firaun untuk berbicara atas nama-Mu, dia telah berlaku jahat terhadap bangsa ini dan Engkau tidak melepaskan bangsa ini sama sekali.” ");
INSERT INTO indayt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Namun, TUHAN berfirman kepada Musa, “Sekarang, kamu akan melihat yang akan Kulakukan terhadap Firaun. Karena dipaksa oleh tangan yang kuat, dia akan membiarkanmu pergi dan oleh tangan yang kuat pula, dia akan mengusir mereka keluar dari negerinya.” ");
INSERT INTO indayt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Allah berfirman kepada Musa, “Akulah TUHAN! ");
INSERT INTO indayt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aku telah menampakkan diri kepada Abraham, kepada Ishak, dan kepada Yakub sebagai Allah Yang Mahakuasa. Namun, mengenai nama-Ku, yaitu TUHAN, Aku tidak menyatakannya kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Aku juga telah menetapkan perjanjian-Ku dengan mereka untuk memberikan tanah Kanaan kepada mereka, yaitu tanah tempat mereka tinggal sementara. ");
INSERT INTO indayt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Aku juga telah mendengar erangan keturunan Israel yang diperbudak oleh orang Mesir, maka Aku pun mengingat perjanjian-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Sebab itu, katakanlah kepada keturunan Israel, ‘Akulah TUHAN! Aku akan mengeluarkanmu dari kerja paksa orang Mesir, dan Aku akan melepaskanmu dari perbudakan mereka, dan Aku akan menebusmu dengan tangan yang terentang, dan dengan hukuman-hukuman berat. ");
INSERT INTO indayt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Aku akan mengangkatmu menjadi umat-Ku dan Aku akan menjadi Allahmu supaya kamu tahu bahwa Akulah TUHAN, Allahmu, yang mengeluarkanmu dari kerja paksa orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aku akan membawamu ke negeri, yang dengan tangan terangkat Aku telah bersumpah untuk memberikannya kepada Abraham, kepada Ishak, dan kepada Yakub. Aku akan memberikannya kepadamu sebagai milikmu. Akulah TUHAN!’” ");
INSERT INTO indayt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Setelah itu, Musa menyampaikannya kepada keturunan Israel, tetapi mereka tidak mau mendengarkan Musa karena patah semangatnya dan karena perbudakan yang berat itu. ");
INSERT INTO indayt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pergilah dan katakan kepada Firaun, raja Mesir, bahwa dia harus membiarkan keturunan Israel keluar dari negerinya.” ");
INSERT INTO indayt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Namun, Musa berkata kepada TUHAN, katanya, “Lihatlah, keturunan Israel saja tidak mau mendengarkanku, bagaimana mungkin Firaun akan mendengarkan aku, orang yang tidak pandai bicara?” ");
INSERT INTO indayt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Lalu, TUHAN berfirman kepada Musa dan Harun mengenai keturunan Israel dan Firaun, raja Mesir, dan Dia memerintahkan mereka untuk mengeluarkan keturunan Israel dari tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Inilah para kepala kaum nenek moyang mereka: keturunan Ruben, anak sulung Israel, Henokh, Palu, Hezron, dan Karmi. Itulah kaum-kaum Ruben. ");
INSERT INTO indayt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Keturunan Simeon adalah Yemuel, Yamin, Ohad, Yakhin, Zohar, dan Saul, anak seorang perempuan Kanaan. Itulah kaum Simeon ");
INSERT INTO indayt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Inilah nama anak-anak Lewi menurut generasinya: Gerson, dan Kehat, dan Merari. Tahun-tahun kehidupan Lewi adalah 137 tahun. ");
INSERT INTO indayt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Keturunan Gerson: Libni dan Simei menurut kaumnya. ");
INSERT INTO indayt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Keturunan Kehat: Amram, Yizhar, Hebron, dan Uziel. Masa hidup Kehat adalah 133 tahun. ");
INSERT INTO indayt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Keturunan Merari: Mahli dan Musi. Itulah kaum Lewi menurut generasi mereka. ");
INSERT INTO indayt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram memperistri Yokhebed, saudara ayahnya. Dia melahirkan Harun dan Musa baginya. Masa hidup Amram adalah 137 tahun. ");
INSERT INTO indayt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Keturunan Yizhar: Korah, Nefeg, dan Zikhri. ");
INSERT INTO indayt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Keturunan Uziel: Misael, Elsafan, dan Sitri. ");
INSERT INTO indayt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harun memperistri Eliseba, anak perempuan Aminadab, saudara Nahason. Dia melahirkan Nadab dan Abihu, Eleazar dan Itamar. ");
INSERT INTO indayt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Keturunan Korah: Asir, Elkana, dan Abiasaf. Mereka inilah kaum Korah. ");
INSERT INTO indayt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, anak Harun, menikahi salah seorang anak perempuan Putiel. Dia melahirkan Pinehas baginya. Mereka adalah para kepala kaum Lewi. ");
INSERT INTO indayt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Itulah Harun dan Musa yang kepada mereka, TUHAN berfirman, “Bawalah keturunan Israel keluar dari tanah Mesir menurut kelompoknya.” ");
INSERT INTO indayt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Merekalah yang berbicara kepada Firaun, raja Mesir, untuk mengeluarkan keturunan Israel dari Mesir. Mereka adalah Musa dan Harun. ");
INSERT INTO indayt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","TUHAN berfirman lagi kepada Musa di tanah Mesir, ");
INSERT INTO indayt_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","TUHAN berfirman kepada Musa, kata-Nya, “Akulah TUHAN! Katakanlah kepada Firaun, raja Mesir, segala sesuatu yang telah Kufirmankan kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Akan tetapi, Musa berkata kepada TUHAN, “Lihatlah, aku tidak pandai berbicara, bagaimana mungkin Firaun mau mendengarku?” ");
INSERT INTO indayt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","TUHAN berfirman kepada Musa, “Lihat, Aku telah menjadikanmu seperti Allah bagi Firaun, dan kakakmu, Harun, akan menjadi nabimu. ");
INSERT INTO indayt_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kamu harus menyampaikan semua yang Kuperintahkan kepadamu, sedangkan kakakmu, Harun, akan mengatakannya kepada Firaun agar dia melepaskan bangsa Israel keluar dari negerinya. ");
INSERT INTO indayt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Namun, Aku akan mengeraskan hati Firaun dan melipatgandakan tanda-tanda-Ku dan mukjizat-mukjizat-Ku di tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Firaun tidak akan mendengarkanmu. Sebab itu, Aku akan meletakkan tangan-Ku atas Mesir dan membawa pasukan-Ku, yaitu umat-Ku, keturunan Israel, keluar dari tanah Mesir dengan hukuman-hukuman yang berat. ");
INSERT INTO indayt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Orang Mesir pun akan tahu bahwa Akulah TUHAN, ketika Aku merentangkan tangan-Ku atas Mesir dan mengeluarkan keturunan Israel dari tengah-tengah mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa dan Harun melakukan seperti yang diperintahkan TUHAN kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa berumur 80 tahun dan Harun 83 tahun ketika mereka berbicara kepada Firaun. ");
INSERT INTO indayt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","TUHAN berfirman kepada Musa dan Harun, ");
INSERT INTO indayt_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Jika Firaun berkata kepadamu, begini, ‘Berikanlah satu mukjizat,’ kamu harus berkata kepada Harun, ‘Ambil tongkatmu dan lemparkan itu di hadapan Firaun.’ Tongkat itu pun akan menjadi seekor ular.” ");
INSERT INTO indayt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Jadi, Musa dan Harun menghadap Firaun dan mereka melaksanakan seperti yang diperintahkan TUHAN. Harun melemparkan tongkatnya di hadapan Firaun dan para hambanya, lalu tongkat itu menjadi seekor ular. ");
INSERT INTO indayt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kemudian, Firaun memanggil orang-orang pintar dan para ahli sihir. Lalu, mereka, para ahli ilmu gaib Mesir itu, juga melakukan hal yang sama menggunakan mantra-mantra rahasia mereka. ");
INSERT INTO indayt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Mereka masing-masing melemparkan tongkatnya dan tongkat-tongkat itu menjadi ular, tetapi tongkat Harun memakan tongkat-tongkat mereka. ");
INSERT INTO indayt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Namun, hati Firaun dikeraskan sehingga dia tidak mau mendengarkan mereka, seperti yang telah TUHAN katakan. ");
INSERT INTO indayt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kemudian, TUHAN berfirman kepada Musa, “Hati Firaun itu keras! Dia menolak untuk melepaskan bangsa itu pergi. ");
INSERT INTO indayt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pada pagi hari, pergilah kepada Firaun. Amatilah, ketika dia sedang menuju air, berdirilah di tepi sungai untuk menemuinya. Kamu harus membawa tongkat yang pernah berubah menjadi ular itu di tanganmu. ");
INSERT INTO indayt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kamu harus berkata kepadanya, ‘TUHAN, Allah orang Ibrani telah mengutus aku kepadamu, kata-Nya: Biarkan umat-Ku pergi supaya mereka dapat melayani-Ku di padang belantara. Namun, lihatlah, engkau tidak mau mendengarkan sampai sekarang. ");
INSERT INTO indayt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Karena itu, inilah firman TUHAN: Dengan ini engkau akan tahu bahwa Akulah TUHAN. Lihatlah, dengan tongkat di tanganku ini, aku akan memukul air sungai dan itu akan berubah menjadi darah. ");
INSERT INTO indayt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ikan-ikan di sungai akan mati dan airnya akan berbau busuk. Orang Mesir tidak dapat lagi minum air dari sungai.’” ");
INSERT INTO indayt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kemudian, TUHAN berfirman kepada Musa, “Katakan kepada Harun, ‘Ambillah tongkatmu dan ulurkan tanganmu ke atas air orang Mesir, ke atas sungai-sungainya, kanal-kanalnya, dan ke atas kolam-kolamnya, atas semua penampungan air sehingga semuanya itu menjadi darah. Demikianlah, akan ada darah di seluruh tanah Mesir, baik dalam wadah-wadah kayu maupun wadah-wadah batu.’” ");
INSERT INTO indayt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa dan Harun melaksanakannya seperti yang diperintahkan TUHAN. Lalu, dia mengangkat tongkat dan memukulkannya ke air di sungai, di depan mata Firaun dan para hambanya, dan seluruh air di sungai berubah menjadi darah. ");
INSERT INTO indayt_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ikan-ikan di sungai pun mati sehingga sungai berbau busuk. Sebab itu, orang Mesir tidak dapat minum air dari sungai. Darah ada di seluruh Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Namun, para ahli ilmu gaib Mesir melakukannya juga dengan mantra-mantra rahasianya sehingga hati Firaun dikeraskan. Sebab itu, dia tidak mau mendengarkan mereka, sebagaimana yang telah difirmankan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Firaun berbalik dan kembali ke istananya. Bahkan, dia juga tidak menaruh hatinya terhadap hal ini. ");
INSERT INTO indayt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Semua orang Mesir menggali di sekitar sungai untuk mencari air minum karena mereka tidak dapat minum air dari sungai. ");
INSERT INTO indayt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tujuh hari telah berlalu sesudah TUHAN memukul sungai. ");
INSERT INTO indayt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kemudian, TUHAN berfirman kepada Musa, “Pergilah kepada Firaun dan katakan kepadanya, ‘Inilah firman TUHAN: Biarkan umat-Ku pergi supaya mereka dapat melayani Aku! ");
INSERT INTO indayt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Jika kamu menolak untuk membiarkan mereka pergi, lihatlah, Aku akan memukul seluruh wilayahmu dengan katak. ");
INSERT INTO indayt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sungai akan dikerumuni oleh katak yang akan naik dan masuk ke dalam istanamu, ke ruang ranjangmu, di ranjangmu, ke dalam rumah hamba-hambamu dan rakyatmu, ke dalam pemanggang rotimu, dan ke dalam loyang-loyang adonanmu. ");
INSERT INTO indayt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Katak-katak itu akan naik ke atasmu, ke atas rakyatmu, dan ke atas semua hambamu.’” ");
INSERT INTO indayt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Sesudah itu, TUHAN berfirman kepada Musa, “Katakan kepada Harun, ‘Ulurkanlah tanganmu dengan tongkatmu ke atas sungai-sungai, ke atas saluran-saluran air, dan ke atas kolam-kolam, lalu buatlah katak-katak bermunculan di atas tanah Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Harun pun merentangkan tangannya ke atas seluruh air di Mesir, lalu katak-katak bermunculan menutupi tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Namun, para ahli ilmu gaib juga melakukannya dengan mantra-mantra rahasianya sehingga mereka membuat katak-katak bermunculan di seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kemudian, Firaun memanggil Musa dan Harun dan berkata, “Berdoalah kepada TUHAN supaya Dia menjauhkan katak-katak ini dariku dan dari rakyatku. Setelah itu, aku akan membiarkan bangsa itu pergi supaya mereka dapat berkurban kepada TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa berkata kepada Firaun, “Ini adalah kehormatan bagiku. Kapan aku harus berdoa untukmu, untuk hamba-hambamu, dan untuk rakyatmu agar katak-katak itu dilenyapkan dari rumah-rumahmu sehingga mereka akan ada di sungai saja?” ");
INSERT INTO indayt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firaun berkata, “Besok.” Lalu, Musa berkata, “Jadilah seperti yang engkau katakan itu supaya engkau tahu bahwa tidak ada satu pun yang seperti TUHAN, Allah kami. ");
INSERT INTO indayt_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Katak-katak itu akan pergi darimu, dari istanamu, dari para hambamu, dan dari rakyatmu. Katak-katak itu hanya akan tinggal di sungai.” ");
INSERT INTO indayt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa dan Harun meninggalkan Firaun, lalu Musa berseru kepada TUHAN mengenai katak-katak yang didatangkan-Nya atas Firaun. ");
INSERT INTO indayt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","TUHAN pun mengabulkan perkataan Musa sehingga katak-katak itu mati di dalam rumah, di halaman, dan di ladang. ");
INSERT INTO indayt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mereka mengumpulkannya bertimbun-timbun sehingga seluruh negeri itu berbau busuk. ");
INSERT INTO indayt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Namun, ketika Firaun melihat bahwa sudah ada kelegaan, dia mengeraskan hatinya dan tidak mau mendengarkan mereka, sebagaimana yang telah TUHAN katakan. ");
INSERT INTO indayt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kemudian, TUHAN berkata kepada Musa, “Katakanlah kepada Harun, ‘Ulurkanlah tongkatmu, lalu pukullah debu tanah supaya dia menjadi nyamuk di seluruh tanah Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mereka pun melaksanakannya. Harun mengulurkan tangannya dengan tongkatnya, lalu memukul debu tanah sehingga debu itu menjadi nyamuk yang hinggap pada manusia dan binatang. Semua debu tanah itu menjadi nyamuk di seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Para ahli ilmu gaib melakukannya pula dengan mantra-mantra rahasianya untuk mendatangkan nyamuk, tetapi mereka tidak berhasil. Demikianlah nyamuk-nyamuk itu hinggap atas manusia dan atas binatang. ");
INSERT INTO indayt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Sebab itu, para ahli ilmu gaib itu berkata kepada Firaun, “Ini adalah jari Allah.” Namun, hati Firaun mengeras dan dia tidak mau mendengarkan mereka, sebagaimana yang telah difirmankan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","TUHAN berkata kepada Musa, “Bangunlah pagi-pagi dan berdirilah di hadapan Firaun. Amatilah, ketika dia menuju ke air, katakanlah kepadanya, ‘Inilah firman TUHAN: Biarkan umat-Ku pergi supaya mereka dapat melayani-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Jika kamu tidak membiarkan umat-Ku pergi, lihatlah, Aku akan mengirim lalat-lalat kepadamu, dan kepada hamba-hambamu, dan kepada rakyatmu, dan ke dalam istanamu. Rumah orang Mesir akan penuh dengan lalat dan juga tanah tempat mereka berada. ");
INSERT INTO indayt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Namun, pada hari itu, Aku akan mengecualikan tanah Gosyen, tempat umat-Ku tinggal sehingga tidak akan ada lalat di sana. Dengan demikian, kamu akan tahu bahwa Aku, TUHAN, ada di tengah-tengah negeri ini. ");
INSERT INTO indayt_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Aku akan menempatkan pemisah antara umat-Ku dan rakyatmu. Tanda ini akan terjadi besok.’” ");
INSERT INTO indayt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Demikianlah TUHAN melakukannya. Sejumlah besar lalat masuk ke dalam istana Firaun dan ke rumah hamba-hambanya, sampai seluruh tanah Mesir. Maka, TUHAN melakukan yang telah dikatakan-Nya. Jutaan lalat masuk ke rumah Firaun dan ke rumah para pejabatnya. Lalat-lalat itu memenuhi seluruh Mesir dan merusak negeri itu. ");
INSERT INTO indayt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Lalu, Firaun memanggil Musa dan Harun dan berkata, “Pergilah, persembahkanlah kurban bagi Allahmu di negeri ini!” ");
INSERT INTO indayt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Namun, Musa berkata, “Hal itu tidak tepat untuk dilakukan karena kami akan mempersembahkan hal yang keji bagi orang Mesir. Lihatlah, jika kami mempersembahkan hal yang keji bagi orang Mesir di depan mata mereka, bukankah mereka akan merajami kami? ");
INSERT INTO indayt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kami harus pergi sejauh tiga hari perjalanan ke padang belantara dan mempersembahkan kurban kepada TUHAN, Allah kami, sebagaimana yang difirmankan-Nya kepada kami.” ");
INSERT INTO indayt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firaun berkata, “Aku akan membiarkan kamu pergi supaya kamu dapat mempersembahkan kurban kepada TUHAN, Allahmu, di padang belantara. Namun, kamu tidak boleh pergi terlalu jauh. Ayo, berdoalah untukku!” ");
INSERT INTO indayt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa berkata, “Lihatlah, aku akan undur dari hadapanmu dan aku akan berdoa kepada TUHAN supaya besok lalat-lalat itu menyingkir dari Firaun, dari hamba-hambanya, dan dari rakyatnya. Hanya, jangan sampai Firaun berbuat curang lagi dengan tidak membiarkan bangsa itu pergi untuk mempersembahkan kurban kepada TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Lalu, Musa pergi dari Firaun dan berdoa kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","TUHAN melakukan yang diminta Musa dan menyingkirkan lalat-lalat itu dari Firaun, dari para hambanya, dan dari rakyatnya. Tidak ada satu pun yang tertinggal. ");
INSERT INTO indayt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Namun, kali ini pun Firaun mengeraskan hatinya dan tidak membiarkan bangsa itu pergi. ");
INSERT INTO indayt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kemudian, TUHAN berfirman kepada Musa, “Pergilah kepada Firaun dan katakan kepadanya, ‘Inilah firman TUHAN, Allah orang Ibrani: Biarkanlah umat-Ku pergi supaya mereka dapat melayani Aku. ");
INSERT INTO indayt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Sebab, jika engkau menolak untuk membiarkan mereka pergi dan terus-menerus menahan mereka, ");
INSERT INTO indayt_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","lihatlah, tangan TUHAN akan datang dengan wabah penyakit yang sangat berat atas ternakmu di ladang, atas kuda, atas keledai, atas unta, atas kawanan sapi, dan atas kawanan domba. ");
INSERT INTO indayt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Namun, TUHAN akan membedakan ternak orang Israel dengan ternak orang Mesir sehingga tidak ada yang akan mati dari milik keturunan Israel. ");
INSERT INTO indayt_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","TUHAN telah menetapkan satu waktu, kata-Nya: Besok, TUHAN akan melaksanakannya di negeri ini.’” ");
INSERT INTO indayt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Keesokan harinya, TUHAN melaksanakan hal tersebut dan semua ternak orang Mesir pun mati, tetapi tidak ada satu pun ternak keturunan Israel yang mati. ");
INSERT INTO indayt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firaun mengutus orang, dan lihatlah, tidak ada satu pun ternak orang Israel yang mati. Namun, hati Firaun dikeraskan dan dia tidak membiarkan bangsa itu pergi. ");
INSERT INTO indayt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","TUHAN berkata kepada Musa dan Harun, “Ambillah bagimu segenggam abu dari tungku dan biarkanlah Musa menghamburkannya ke udara di depan mata Firaun. ");
INSERT INTO indayt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Itu akan menjadi debu halus di seluruh tanah Mesir dan akan menjadi bisul yang pecah bernanah pada manusia dan binatang di seluruh tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Lalu, mereka mengambil abu dari tungku dan berdiri di hadapan Firaun. Kemudian, Musa menghamburkannya ke udara dan itu menjadi bisul yang pecah bernanah pada manusia dan binatang. ");
INSERT INTO indayt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Para ahli ilmu gaib tidak dapat berdiri di hadapan Musa karena bisul itu sebab bisul itu juga menjangkiti para ahli ilmu gaib, seperti semua orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Namun, TUHAN mengeraskan hati Firaun sehingga dia tidak mau mendengarkan mereka, sebagaimana yang telah difirmankan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kemudian, TUHAN berfirman kepada Musa, “Bangunlah pagi-pagi dan berdirilah di hadapan Firaun. Lalu, katakan kepadanya, ‘Inilah firman TUHAN, Allah orang Ibrani: Biarkan umat-Ku pergi supaya mereka dapat melayani Aku! ");
INSERT INTO indayt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Sebab, kali ini Aku akan mengirimkan segala malapetaka-Ku atas dirimu, atas hamba-hambamu, dan atas rakyatmu supaya kamu tahu bahwa tidak ada satu pun yang seperti Aku di seluruh bumi. ");
INSERT INTO indayt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Sekarang pun Aku dapat mengulurkan tangan-Ku untuk memukul kamu dan rakyatmu dengan wabah penyakit, dan kamu akan dilenyapkan dari bumi. ");
INSERT INTO indayt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Namun, sesungguhnya, untuk alasan ini Aku masih membiarkanmu berdiri, yaitu untuk mempertunjukkan kuasa-Ku kepadamu dan untuk memasyhurkan nama-Ku di seluruh bumi! ");
INSERT INTO indayt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Meskipun demikian, kamu masih saja meninggikan diri terhadap umat-Ku dan tidak membiarkan mereka pergi. ");
INSERT INTO indayt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Lihat, besok, kira-kira pada waktu seperti ini, Aku akan menurunkan hujan es yang sangat dahsyat, yang belum pernah terjadi di Mesir, sejak didirikan sampai sekarang.’ ");
INSERT INTO indayt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Sebab itu, sekarang, amankanlah ternakmu dan segala yang kamu miliki di ladang. Setiap orang dan binatang yang ada di padang dan tidak dibawa ke rumah akan mati ketika hujan es menghujani mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Beberapa orang dari antara hamba Firaun yang takut akan firman TUHAN melarikan para budaknya dan ternaknya ke dalam rumah. ");
INSERT INTO indayt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Namun, orang yang tidak mengacuhkan firman TUHAN meninggalkan para budaknya dan ternaknya di padang. ");
INSERT INTO indayt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kemudian, TUHAN berkata kepada Musa, “Acungkan tanganmu ke langit sehingga hujan es turun di seluruh tanah Mesir, atas manusia dan atas binatang, dan atas segala tumbuhan di padang, di tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Setelah itu, Musa mengacungkan tangannya ke langit dan TUHAN mengirim guntur, dan hujan es, dan api yang menyambar sampai ke bumi. Demikianlah, TUHAN menghujani tanah Mesir dengan hujan es. ");
INSERT INTO indayt_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hujan es turun dan api terus-menerus menyambar di tengah-tengah hujan es itu, sangat dahsyat. Yang seperti itu belum pernah terjadi di seluruh tanah Mesir sejak Mesir menjadi suatu bangsa. ");
INSERT INTO indayt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Hujan es itu menghantam seluruh tanah Mesir, segala sesuatu yang ada di ladang, baik manusia maupun binatang. Hujan es juga menghantam segala tanaman di ladang dan menghancurkan setiap pohon di ladang. ");
INSERT INTO indayt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Hanya di tanah Gosyen, tempat tinggal keturunan Israel, yang tidak ditimpa oleh hujan es. ");
INSERT INTO indayt_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Firaun menyuruh orang untuk memanggil Musa dan Harun, lalu berkata kepada mereka, “Kali ini, aku telah berdosa. TUHAN-lah yang benar. Aku dan rakyatku yang salah. ");
INSERT INTO indayt_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Berdoalah kepada TUHAN sebab ini sudah cukup! Jangan lagi ada guntur Allah dan hujan es ini. Setelah itu, Aku akan membiarkan kalian pergi dan kalian tidak usah tinggal di sini lagi.” ");
INSERT INTO indayt_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa berkata kepadanya, “Segera setelah aku keluar dari kota ini, aku akan menadahkan telapak tanganku kepada TUHAN, dan guntur akan berhenti serta tidak akan ada lagi hujan es supaya kamu akan mengetahui bahwa bumi ini adalah milik TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Namun, aku tahu bahwa kamu dan para hambamu belum juga takut kepada TUHAN Allah.” ");
INSERT INTO indayt_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Benih rami dan jelai telah dihancurkan sebab jelai baru bertunas dan benih rami sedang mekar. ");
INSERT INTO indayt_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Akan tetapi, gandum dan jawawut belum tiba musimnya, jadi tumbuhan-tumbuhan ini tidak dihancurkan. ");
INSERT INTO indayt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa keluar dari kota itu, dari Firaun, dan menadahkan telapak tangannya kepada TUHAN, maka guntur dan hujan es itu berhenti, dan hujan tidak lagi tercurah ke bumi. ");
INSERT INTO indayt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ketika Firaun melihat bahwa hujan, hujan es, dan guntur telah berhenti, dia berdosa lagi. Dia dan para hambanya kembali mengeraskan hati mereka. ");
INSERT INTO indayt_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Hati Firaun tetap keras dan dia tidak membiarkan keturunan Israel untuk pergi, sebagaimana yang telah difirmankan TUHAN melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","TUHAN berfirman kepada Musa, “Pergilah menghadap Firaun karena Aku telah mengeraskan hatinya dan hati para hambanya agar Aku dapat mempertunjukkan tanda-tanda-Ku di antara mereka, ");
INSERT INTO indayt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","dan agar kamu dapat menceritakannya di telinga anakmu dan cucumu bagaimana Aku mempermainkan orang Mesir dan bagaimana Aku mempertunjukkan tanda-tanda-Ku di antara mereka. Dengan demikian, kamu dapat mengetahui bahwa Akulah TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kemudian, Musa dan Harun menghadap Firaun dan berkata kepadanya, “Inilah firman TUHAN, Allah orang Ibrani, ‘Berapa lama lagi kamu akan menolak untuk merendahkan dirimu di hadapan-Ku? Biarkan umat-Ku pergi supaya mereka dapat melayani Aku! ");
INSERT INTO indayt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Jika kamu menolak untuk membiarkan umat-Ku pergi, lihatlah, besok Aku akan mendatangkan belalang di wilayahmu, ");
INSERT INTO indayt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","dan belalang-belalang itu akan menutupi permukaan tanah sehingga tidak ada yang dapat melihat tanah itu. Belalang-belalang itu akan memakan habis sisa-sisa yang masih tertinggal dari peristiwa hujan es dan mereka akan memakan semua pohon yang baru tumbuh bagimu di ladang, ");
INSERT INTO indayt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","dan mereka akan memenuhi istanamu, dan rumah hamba-hambamu, dan rumah seluruh orang Mesir. Ini adalah sesuatu yang belum pernah dilihat, baik oleh ayahmu maupun nenek moyangmu, sejak mereka lahir di dunia sampai pada hari ini.’” Kemudian, Musa dan Harun berbalik keluar meninggalkan Firaun. ");
INSERT INTO indayt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Hamba-hamba Firaun berkata kepadanya, “Berapa lama orang ini akan menjadi jerat bagi kita? Biarkanlah orang-orang itu pergi supaya mereka dapat melayani TUHAN, Allah mereka. Apakah engkau belum menyadari bahwa Mesir telah binasa?” ");
INSERT INTO indayt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Sebab itu, Musa dan Harun dibawa kembali kepada Firaun dan dia berkata kepada mereka, “Pergilah! Layani TUHAN, Allahmu. Namun, siapa dan siapa yang akan pergi?” ");
INSERT INTO indayt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa menjawab, “Kami akan pergi bersama orang-orang muda dan orang-orang tua, bersama anak-anak laki-laki kami dan anak-anak perempuan kami, bersama kawanan domba kami dan kawanan sapi kami. Kami akan pergi sebab kami harus mengadakan perayaan bagi TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firaun berkata kepada mereka, “Kiranya TUHAN menyertaimu ketika aku membiarkanmu pergi beserta anak-anakmu. Lihat, ada kejahatan di wajahmu. ");
INSERT INTO indayt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tidak boleh begitu! Pergilah sekarang, tetapi hanya laki-laki, dan layani TUHAN, sebab itulah yang kamu inginkan.” Kemudian, mereka diusir dari hadapan Firaun. ");
INSERT INTO indayt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","TUHAN berfirman kepada Musa, “Ulurkanlah tanganmu ke atas tanah Mesir supaya belalang datang ke atas tanah Mesir dan memakan segala tumbuhan di tanah itu, apa saja yang tersisa dari hujan es itu.” ");
INSERT INTO indayt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kemudian, Musa mengulurkan tongkatnya ke atas tanah Mesir, dan TUHAN mengembuskan angin timur di negeri itu sepanjang siang dan sepanjang malam. Besok paginya, angin dari timur itu telah membawa belalang-belalang. ");
INSERT INTO indayt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Belalang berdatangan di seluruh tanah Mesir dan hinggap di seluruh wilayah Mesir. Belum pernah ada belalang-belalang seperti itu sebelumnya, dan tidak akan pernah ada lagi sesudahnya. ");
INSERT INTO indayt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Belalang-belalang itu menutupi seluruh permukaan tanah sehingga negeri itu menjadi gelap. Mereka makan segala tumbuhan di tanah itu, segala buah dari pohon-pohon yang tersisa dari hujan es. Di pohon tidak ada hijau yang tersisa atau apa pun yang tumbuh di ladang, di seluruh tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Dengan segera, Firaun memanggil Musa dan Harun dan berkata, “Aku telah berdosa kepada TUHAN, Allahmu, dan kepadamu. ");
INSERT INTO indayt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Karena itu, sekarang, aku mohon kepadamu, ampunilah dosaku satu kali ini saja, dan berdoalah kepada TUHAN, Allahmu, supaya Dia menjauhkan aku dari kematian ini.” ");
INSERT INTO indayt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Lalu, Musa undur dari Firaun dan berdoa kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","TUHAN pun mendatangkan angin barat yang sangat kuat, yang mengangkat belalang-belalang itu sehingga tercampak ke Laut Teberau. Tidak ada seekor belalang pun yang tertinggal di seluruh wilayah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Akan tetapi, TUHAN mengeraskan hati Firaun supaya dia tidak membiarkan keturunan Israel pergi. ");
INSERT INTO indayt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kemudian, TUHAN berfirman kepada Musa, “Ulurkanlah tanganmu ke langit dan akan datang gelap gulita yang menutupi seluruh tanah Mesir sehingga orang merasakan kegelapan itu.” ");
INSERT INTO indayt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa pun mengulurkan tangannya ke langit dan gelap gulita meliputi seluruh tanah Mesir selama tiga hari. ");
INSERT INTO indayt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mereka tidak dapat saling melihat dan tidak dapat beranjak dari tempatnya selama tiga hari. Namun, ada terang di tempat tinggal keturunan Israel. ");
INSERT INTO indayt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Karena itu, Firaun memanggil Musa lagi dan berkata, “Pergi dan layanilah TUHAN! Hanya, kawanan domba dan ternakmu harus tetap tinggal. Anak-anakmu juga boleh pergi besertamu.” ");
INSERT INTO indayt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Namun, Musa berkata, “Engkau juga harus memberikan kurban-kurban dan persembahan bakaran supaya kami dapat mempersembahkan kurban kepada TUHAN, Allah kami. ");
INSERT INTO indayt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ternak kami pun harus ikut bersama kami, tidak seekor pun yang akan ditinggalkan sebab kami harus mengambil dari itu untuk melayani TUHAN, Allah kami. Sampai kami tiba di sana, kami sendiri tidak mengetahui dengan apa kami harus melayani TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Namun, TUHAN mengeraskan hati Firaun sehingga dia tidak membiarkan mereka pergi. ");
INSERT INTO indayt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firaun berkata kepada Musa, “Pergi dari sini! Awas, jangan lihat wajahku! Pada hari kamu melihat wajahku, kamu akan mati!” ");
INSERT INTO indayt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa berkata, “Seperti yang engkau katakan, aku tidak akan melihat wajahmu lagi.” ");
INSERT INTO indayt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kemudian, TUHAN berkata kepada Musa, “Aku masih akan menimpakan satu bencana lagi atas Firaun dan atas Mesir. Sesudah itu, dia baru akan membiarkanmu pergi dari sini. Ketika dia membiarkanmu pergi, dia akan benar-benar mengusirmu dari sini. ");
INSERT INTO indayt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sekarang, sampaikanlah hal ini ke telinga umat itu agar setiap laki-laki meminta kepada tetangganya dan setiap perempuan kepada tetangganya, yaitu barang-barang emas dan perak. ");
INSERT INTO indayt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","TUHAN akan memberikan kepada umat itu kemurahan di mata orang Mesir, apalagi Musa adalah orang yang terpandang di tanah Mesir, baik di mata hamba-hamba Firaun dan di mata penduduknya.’” ");
INSERT INTO indayt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Karena itu, Musa berkata, “Inilah firman TUHAN, ‘Kira-kira pada tengah malam, Aku akan keluar ke tengah-tengah Mesir, ");
INSERT INTO indayt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","dan semua anak sulung di tanah Mesir akan mati, mulai dari anak sulung Firaun, yang duduk di takhtanya, hingga anak sulung budak perempuan yang ada di balik kilangan, begitu juga dengan semua anak sulung binatang. ");
INSERT INTO indayt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Akan ada ratapan yang sangat hebat di seluruh Mesir; suatu ratapan yang belum pernah ada dan tidak akan pernah ada lagi. ");
INSERT INTO indayt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Namun, seekor anjing pun tidak akan bergerak lidahnya atas keturunan Israel, baik manusia ataupun binatang, supaya kamu mengetahui bahwa TUHAN membuat perbedaan antara Mesir dan Israel. ");
INSERT INTO indayt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Semua hambamu akan bersujud kepadaku dan membungkukkan diri mereka kepadaku sambil berkata: Keluarlah kamu dan seluruh umat yang mengikutimu! Setelah itu, aku baru akan pergi.’” Kemudian, dia pergi dari Firaun dalam kemarahan yang menyala-nyala. ");
INSERT INTO indayt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","TUHAN berfirman kepada Musa, “Firaun tidak akan mendengarkanmu. Dengan demikian, mukjizat-mukjizat-Ku akan berlipat ganda di tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Itulah sebabnya, Musa dan Harun melakukan semua mukjizat besar itu di depan Firaun, tetapi TUHAN mengeraskan hati Firaun sehingga dia tidak membiarkan keturunan Israel keluar dari negerinya. ");
INSERT INTO indayt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","TUHAN berkata kepada Musa dan Harun di tanah Mesir, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Bulan ini akan menjadi permulaan bulan-bulan bagimu dan akan menjadi bulan pertama dalam setahun bagimu. ");
INSERT INTO indayt_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Sampaikanlah kepada seluruh jemaat Israel, katakanlah, ‘Pada hari kesepuluh bulan ini, setiap laki-laki harus mengambil seekor domba untuk setiap rumah. ");
INSERT INTO indayt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Jika satu rumah terlalu sedikit jumlahnya untuk seekor domba, biarlah dia bersama tetangga yang dekat dengan rumahnya mengambil berdasarkan jumlah jiwa. Kamu harus memperkirakan domba itu berdasarkan berapa banyak yang dimakan oleh setiap orang. ");
INSERT INTO indayt_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Dombamu itu harus tidak bercacat, jantan, dan berumur setahun, dan kamu dapat mengambilnya dari antara domba atau kambing. ");
INSERT INTO indayt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kamu harus menyimpannya sampai pada hari keempat belas bulan ini. Setelah itu, seluruh jemaat Israel harus menyembelihnya pada waktu senja. ");
INSERT INTO indayt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kemudian, mereka harus mengambil darahnya dan mengoleskannya pada kedua tiang dan ambang pintu rumah tempat mereka memakannya.’ ");
INSERT INTO indayt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","‘Pada malam itu juga, mereka harus makan daging itu, yang dipanggang pada api, dan mereka harus memakannya dengan roti tidak beragi dan sayur pahit. ");
INSERT INTO indayt_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Jangan memakannya mentah-mentah atau matang karena direbus dengan air, melainkan pangganglah dengan api, baik kepalanya, dan kakinya, beserta isi perutnya. ");
INSERT INTO indayt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kamu tidak boleh menyisakannya sampai pagi. Apa pun yang tersisa dari itu sampai pagi harus kamu bakar dengan api.’ ");
INSERT INTO indayt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","‘Beginilah kamu harus memakannya, yaitu dengan pinggangmu yang dililit sabuk, dengan kasutmu di kakimu, dan dengan tongkatmu di tanganmu, dan kamu harus memakannya dengan cepat, itulah Pesakh bagi TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","‘Pada malam itu, Aku akan melintasi seluruh tanah Mesir dan akan memukul setiap anak sulung di tanah Mesir, baik itu manusia maupun binatang, dan Aku akan menjatuhkan penghakiman atas seluruh ilah Mesir. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Darah itu akan menjadi tanda bagimu pada rumah tempat kamu tinggal. Ketika Aku melihat darah itu, Aku akan melewatkan rumahmu agar tidak ada bencana yang akan menimpamu dan membinasakanmu ketika Aku memukul tanah Mesir.’ ");
INSERT INTO indayt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","‘Hari ini akan menjadi hari peringatan bagimu dan kamu harus memeliharanya sebagai suatu hari raya bagi TUHAN, turun-temurun. Kamu harus memeliharanya sebagai suatu ketetapan untuk selama-lamanya. ");
INSERT INTO indayt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Selama tujuh hari kamu harus makan roti tidak beragi, tetapi pada hari pertama kamu harus menyingkirkan ragi dari rumahmu. Karena siapa pun yang makan sesuatu yang beragi sejak hari pertama sampai hari ketujuh, nyawanya harus dilenyapkan dari Israel. ");
INSERT INTO indayt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pada hari pertama akan ada pertemuan kudus, begitu pula pada hari ketujuh akan ada pertemuan kudus bagimu. Tidak ada pekerjaan yang boleh dilakukan pada hari-hari itu. Apa yang perlu dimakan oleh setiap orang, hanya itulah yang boleh kamu siapkan. ");
INSERT INTO indayt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Kamu harus tetap memelihara hari raya Roti Tidak Beragi sebab tepat pada hari itu Aku telah membawa pasukanmu keluar dari tanah Mesir. Karena itu, kamu harus memelihara hari ini turun-temurun sebagai ketetapan untuk selama-lamanya. ");
INSERT INTO indayt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Dalam bulan pertama, pada hari keempat belas bulan itu, kamu harus makan roti tidak beragi sampai pada hari kedua puluh satu bulan itu, pada waktu sore. ");
INSERT INTO indayt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Selama tujuh hari tidak boleh ada ragi yang didapati dalam rumahmu. Karena siapa pun makan sesuatu yang beragi, nyawanya akan dilenyapkan dari antara jemaat Israel, baik orang asing atau penduduk asli negeri itu. ");
INSERT INTO indayt_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kamu tidak boleh makan apa pun yang beragi. Di seluruh tempat tinggalmu, kamu harus makan roti tidak beragi.’” ");
INSERT INTO indayt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kemudian, Musa memanggil semua tua-tua Israel dan berkata kepada mereka, “Pilihlah dan ambillah domba berdasarkan keluargamu dan sembelihlah domba Pesakh itu. ");
INSERT INTO indayt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ambillah seikat hisop dan celupkan itu ke dalam darah di sebuah baskom. Lalu, oleslah ambang pintu dan dua tiangnya dengan darah di baskom itu. Tidak ada seorang pun yang boleh keluar dari pintu rumah sampai pagi, ");
INSERT INTO indayt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","sebab TUHAN akan melintas untuk memukul orang Mesir, dan ketika Dia melihat darah pada ambang pintu dan pada dua tiangnya, TUHAN akan melewatkan pintu itu dan tidak akan mengizinkan si pembinasa masuk ke dalam rumahmu untuk memukulmu. ");
INSERT INTO indayt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Kamu harus memelihara hal ini sebagai ketetapan bagimu dan anak-anakmu untuk selamanya. ");
INSERT INTO indayt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Saat kamu memasuki negeri yang akan diberikan TUHAN kepadamu, seperti yang telah dijanjikan-Nya, kamu harus tetap memelihara ibadah ini. ");
INSERT INTO indayt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Apabila anak-anakmu bertanya kepadamu, ‘Apa arti ibadah ini bagimu?’ ");
INSERT INTO indayt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kamu harus menjawab, ‘Ini adalah kurban Pesakh bagi TUHAN yang melewatkan rumah keturunan Israel di Mesir ketika Dia memukul orang Mesir, tetapi meluputkan rumah kami.’” Lalu, umat itu bersujud dan menyembah. ");
INSERT INTO indayt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kemudian, keturunan Israel pergi dan melaksanakannya, sebagaimana yang telah diperintahkan TUHAN kepada Musa dan Harun, demikianlah mereka melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Terjadilah, pada tengah malam, TUHAN memukul semua anak sulung di tanah Mesir, mulai dari anak sulung Firaun yang duduk di takhtanya, sampai anak sulung para tahanan yang berada di penjara, dan juga setiap anak sulung ternak. ");
INSERT INTO indayt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pada malam itu, Firaun bangun, dia, dan semua hambanya, dan seluruh orang Mesir. Lalu, terdengarlah jerit tangis yang dahsyat di Mesir sebab tidak ada satu pun rumah yang tidak ada kematian. ");
INSERT INTO indayt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pada malam itu juga, Firaun memanggil Musa dan Harun, lalu berkata, “Bangkitlah, keluarlah kamu dari antara rakyatku, baik kamu maupun keturunan Israel, dan pergi, layanilah TUHAN seperti katamu itu. ");
INSERT INTO indayt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bawa juga kawanan dombamu dan ternakmu seperti katamu itu, pergilah, dan berkatilah juga aku.” ");
INSERT INTO indayt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Orang Mesir pun mendesak bangsa itu dan menyuruh mereka keluar dari negeri itu sesegera mungkin sebab mereka berkata, “Kami semua bisa mati.” ");
INSERT INTO indayt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kemudian, bangsa itu mengangkat adonan yang belum beragi beserta tempat adonannya yang dibungkus dengan pakaiannya ke atas bahu mereka. ");
INSERT INTO indayt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Keturunan Israel juga telah melaksanakan yang dikatakan Musa, yaitu mereka meminta barang-barang perak, barang-barang emas, dan pakaian dari orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","TUHAN memberikan kepada bangsa ini kemurahan hati di mata orang Mesir sehingga orang Mesir memberi yang mereka minta. Demikianlah mereka merampasi orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Keturunan Israel berangkat dari Raamses ke Sukot, sekitar 600.000 laki-laki yang berjalan kaki, belum termasuk anak-anak. ");
INSERT INTO indayt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Banyak bangsa campuran yang juga pergi bersama mereka, beserta kawanan domba, kawanan sapi, dan ternak yang sangat banyak. ");
INSERT INTO indayt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kemudian, mereka memanggang adonan yang mereka bawa dari Mesir menjadi roti tidak beragi sebab mereka diusir dari Mesir dan tidak boleh berlambat-lambat. Mereka juga tidak sempat menyiapkan bekal bagi diri mereka. ");
INSERT INTO indayt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Lamanya keturunan Israel tinggal sementara, yaitu ketika mereka tinggal di Mesir adalah 430 tahun. ");
INSERT INTO indayt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pada akhir 430 tahun, pada hari itu, seluruh pasukan TUHAN keluar dari tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ini adalah malam yang harus diperingati bagi TUHAN karena telah membawa mereka keluar dari tanah Mesir. Malam ini adalah malam bagi TUHAN, untuk diperingati oleh seluruh keturunan Israel, turun-temurun. ");
INSERT INTO indayt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","TUHAN berfirman kepada Musa dan Harun, “Inilah peraturan tentang Pesakh: Orang asing tidak boleh memakannya, ");
INSERT INTO indayt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","tetapi setiap budak yang dibeli dengan uang, setelah kamu menyunatnya, mereka boleh memakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Orang asing dan orang upahan tidak boleh memakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Itu harus dimakan di dalam rumah, kamu tidak boleh membawa daging itu keluar dari rumah, dan satu pun tulangnya tidak boleh kamu patahkan. ");
INSERT INTO indayt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Seluruh jemaat Israel harus melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Jika ada orang asing yang tinggal sementara denganmu dan ingin merayakan Pesakh bagi TUHAN, setiap laki-laki dari mereka harus disunat. Setelah itu, mereka boleh datang untuk merayakannya dan dia akan menjadi seperti yang lahir di negeri itu. Orang yang tidak bersunat tidak boleh memakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Satu hukum ini berlaku bagi semua penduduk asli dan bagi orang asing yang tinggal sementara di tengah-tengah kamu.” ");
INSERT INTO indayt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Demikianlah seluruh keturunan Israel melaksanakannya, sebagaimana yang telah TUHAN perintahkan kepada Musa dan Harun, demikianlah mereka melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Pada hari itu juga, TUHAN membawa orang Israel keluar dari tanah Mesir menurut kelompok-kelompoknya. ");
INSERT INTO indayt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kemudian, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Khususkanlah bagi-Ku setiap anak sulung, yang pertama kali membuka rahim di antara keturunan Israel, baik manusia maupun binatang, adalah milikku.” ");
INSERT INTO indayt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa berkata kepada umat itu, “Ingatlah hari ini, ketika kamu keluar dari Mesir, keluar dari rumah perbudakan, sebab dengan kekuatan tangan-Nya, TUHAN membawamu keluar dari sana: jangan makan apa pun yang beragi. ");
INSERT INTO indayt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hari ini, dalam bulan Abib, kamu telah keluar. ");
INSERT INTO indayt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Apabila TUHAN telah membawamu ke negeri orang Kanaan, orang Het, orang Amori, dan orang Yebus, yang telah disumpahkan-Nya kepada nenek moyangmu untuk diberikan kepadamu, yaitu suatu negeri yang berlimpah susu dan madu, kamu harus melaksanakan ibadah ini pada bulan ini.” ");
INSERT INTO indayt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Selama tujuh hari, kamu harus makan roti tidak beragi, dan hari ketujuh harus menjadi perayaan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Roti tidak beragi harus dimakan selama tujuh hari dan apa pun yang beragi tidak boleh terlihat di antara kamu, tidak boleh ada ragi yang terlihat di antara kamu, di seluruh wilayahmu. ");
INSERT INTO indayt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Pada hari itu, katakanlah kepada anak-anakmu, ‘Ini karena apa yang telah TUHAN perbuat bagiku ketika aku keluar dari Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Itu harus menjadi tanda bagimu pada tanganmu dan sebagai pengingat di antara matamu supaya hukum TUHAN ada pada mulutmu, sebab dengan tangan yang kuat, TUHAN telah membawamu keluar dari Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Oleh sebab itu, kamu harus memelihara ketetapan ini pada waktu tertentu dari tahun ke tahun.” ");
INSERT INTO indayt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Ketika TUHAN membawamu ke negeri orang Kanaan, seperti yang telah disumpahkan-Nya kepadamu dan kepada nenek moyangmu, dan akan diberikan kepadamu, ");
INSERT INTO indayt_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kamu harus mengkhususkan bagi TUHAN, semua yang pertama membuka rahim, yang pertama lahir dari binatang-binatang milikmu, yaitu yang jantan, itu adalah milik TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Setiap keledai jantan yang pertama lahir harus kamu tebus dengan domba, tetapi jika kamu tidak menebusnya, kamu harus mematahkan lehernya; dan setiap anak sulung manusia di antara anak laki-lakimu harus kamu tebus.” ");
INSERT INTO indayt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Pada suatu waktu, ketika anak laki-lakimu datang dan bertanya kepadamu, ‘Apa artinya ini?’, kamu harus berkata kepadanya, ‘Dengan kekuatan tangan-Nya, TUHAN telah membawa kita keluar dari Mesir, dari rumah perbudakan, ");
INSERT INTO indayt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","dan terjadilah, ketika Firaun bersikeras menolak kami pergi, TUHAN membunuh semua anak sulung di tanah Mesir, baik anak sulung manusia maupun anak sulung binatang. Oleh sebab itu, aku mengurbankan kepada TUHAN semua yang membuka rahim, yang jantan, tetapi semua anak sulung laki-lakiku, aku tebus. ");
INSERT INTO indayt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Hal ini harus menjadi tanda pada tanganmu dan lambang pada dahimu sebab dengan tangan yang kuat, TUHAN telah membawa kita keluar dari Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ketika Firaun telah membiarkan bangsa itu pergi, Allah menuntun mereka untuk tidak melewati negeri orang Filistin, meskipun itu lebih dekat, sebab Allah berkata, “Jangan-jangan bangsa ini berubah pikiran ketika mereka melihat perang, lalu kembali ke Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Jadi, Allah menuntun bangsa itu berputar melalui padang belantara menuju Laut Teberau. Keturunan Israel keluar dari tanah Mesir dalam barisan perang. ");
INSERT INTO indayt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa membawa tulang-tulang Yusuf bersamanya sebab Yusuf telah meminta keturunan Israel untuk bersumpah, ya, bersumpah, katanya, “Allah pasti akan datang kepadamu, dan kamu harus membawa tulang-tulangku dari sini bersamamu.” ");
INSERT INTO indayt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mereka berangkat dari Sukot dan berkemah di Etam, di pinggir padang belantara. ");
INSERT INTO indayt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","TUHAN berjalan di depan mereka dalam tiang awan pada siang hari untuk menuntun mereka di jalan, dan dalam tiang api pada malam hari untuk memberikan terang kepada mereka supaya mereka dapat berjalan pada siang dan malam hari. ");
INSERT INTO indayt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Dia tidak menyingkirkan tiang awan pada siang hari begitu pula dengan tiang api pada malam hari dari hadapan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kemudian, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Katakanlah kepada keturunan Israel untuk kembali dan berkemah di Pi-Hahirot, di antara Migdol dan laut, di depan Baal-Zefon, kamu harus berkemah di seberangnya, di tepi laut, ");
INSERT INTO indayt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","sebab Firaun akan berkata mengenai keturunan Israel, ‘Mereka tersesat di negeri ini, padang belantara telah mengurung mereka.’ ");
INSERT INTO indayt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Aku akan mengeraskan hati Firaun dan dia akan mengejar mereka, dan Aku akan dimuliakan atas Firaun, dan atas seluruh pasukannya sehingga orang Mesir akan tahu bahwa Akulah TUHAN.” Demikianlah mereka melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ketika dikabarkan kepada Raja Mesir bahwa bangsa itu telah melarikan diri, hati Firaun maupun hamba-hambanya berubah terhadap bangsa itu dan mereka berkata, “Apa yang sudah kita lakukan? Kita telah melepaskan orang Israel pergi dari perbudakan kita?” ");
INSERT INTO indayt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Dia pun menyiapkan keretanya dan membawa orang-orangnya besertanya. ");
INSERT INTO indayt_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Dia membawa enam ratus kereta pilihan dan semua kereta di Mesir, masing-masing lengkap dengan perwiranya. ");
INSERT INTO indayt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","TUHAN mengeraskan hati Firaun, raja Mesir, sehingga dia mengejar keturunan Israel sementara keturunan Israel telah berjalan dengan gagah berani. ");
INSERT INTO indayt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Orang Mesir mengejar mereka dengan semua kuda dan kereta Firaun, dengan orang-orang berkuda dan pasukannya, dan menyusul mereka yang sedang berkemah di tepi laut, di dekat Pi-Hahirot, di depan Baal-Zefon. ");
INSERT INTO indayt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ketika Firaun sudah dekat, bangsa Israel mengangkat matanya, dan lihatlah, orang Mesir sedang mengikuti mereka dari belakang. Mereka sangat ketakutan sehingga keturunan Israel itu pun berseru-seru kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mereka berkata kepada Musa, “Apakah karena di Mesir tidak ada kuburan sehingga engkau membawa kami pergi untuk mati di padang belantara ini? Mengapa engkau melakukan hal ini terhadap kami dengan membawa kami keluar dari Mesir? ");
INSERT INTO indayt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bukankah kami sudah mengatakan ini kepadamu di Mesir, ‘Jangan ganggu kami, biarkan kami melayani orang Mesir’? Sebab, lebih baik kami melayani orang Mesir daripada kami harus mati di padang belantara.” ");
INSERT INTO indayt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa berkata kepada bangsa itu, “Jangan takut! Berdirilah teguh dan lihatlah keselamatan dari TUHAN yang akan ditunjukkan-Nya kepadamu pada hari ini, sebab orang Mesir yang kamu lihat hari ini tidak akan pernah kamu lihat lagi selamanya. ");
INSERT INTO indayt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","TUHAN akan berperang bagimu dan kamu tinggal diam saja.” ");
INSERT INTO indayt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","TUHAN berkata kepada Musa, “Mengapa kamu masih berseru-seru kepada-Ku? Katakanlah kepada keturunan Israel untuk terus maju, ");
INSERT INTO indayt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","tetapi kamu, angkatlah tongkatmu dan ulurkan tanganmu ke atas laut dan belahlah itu supaya keturunan Israel dapat berjalan di tengah-tengah laut di tanah yang kering. ");
INSERT INTO indayt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Lihatlah, Aku akan mengeraskan hati orang Mesir sehingga mereka akan mengejar keturunan Israel, dan Aku akan dipermuliakan atas Firaun, dan atas seluruh pasukannya, dan atas kereta-keretanya, dan atas pasukan berkudanya. ");
INSERT INTO indayt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Lalu, orang Mesir akan mengetahui bahwa Akulah TUHAN, ketika Aku dipermuliakan atas Firaun, atas kereta-keretanya, dan atas pasukan berkudanya.” ");
INSERT INTO indayt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kemudian, malaikat Allah, yang berjalan di depan pasukan Israel, berpindah dan berjalan di belakang mereka. Lalu, tiang awan beranjak dari hadapan mereka untuk berdiri di belakang mereka, ");
INSERT INTO indayt_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","dan tiang awan itu datang di antara pasukan orang Mesir dan pasukan orang Israel. Sepanjang malam, awan itu membawa kegelapan di sisi yang satu dan terang di sisi yang lainnya sehingga tidak ada satu pun yang dapat saling mendekati. ");
INSERT INTO indayt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kemudian, Musa mengulurkan tangannya ke atas laut dan TUHAN menguak laut dengan angin timur yang sangat kencang sepanjang malam dan membuat laut itu menjadi tanah kering dan airnya terbelah. ");
INSERT INTO indayt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Keturunan Israel berjalan di tengah-tengah laut di atas tanah kering dan airnya menjadi tembok bagi mereka di sebelah kanan dan di sebelah kiri mereka. ");
INSERT INTO indayt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Kemudian, orang Mesir mengejar dan mengikuti mereka sampai ke tengah-tengah laut, bahkan semua kuda Firaun, kereta-keretanya, dan pasukan berkudanya. ");
INSERT INTO indayt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Dan, terjadilah, selama waktu jaga pagi hari, TUHAN mengamati pasukan orang Mesir melalui tiang api dan awan, lalu mengacaukan pasukan orang Mesir itu, ");
INSERT INTO indayt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","dan melepaskan roda kereta-keretanya sehingga mereka mengendarainya dengan berat. Oleh karena itu, orang Mesir berkata, “Ayo kita lari dari hadapan orang Israel karena TUHAN yang berperang bagi mereka untuk melawan orang Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kemudian, TUHAN berfirman kepada Musa, “Ulurkan tanganmu ke atas laut supaya air itu berbalik ke atas orang Mesir, ke atas kereta-keretanya, dan ke atas pasukan berkudanya.” ");
INSERT INTO indayt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa pun mengulurkan tangannya ke atas laut dan laut berbalik ke keadaan semula ketika pagi menjelang. Orang Mesir berlarian ke air itu dan TUHAN mencampakkan orang Mesir ke tengah-tengah laut. ");
INSERT INTO indayt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Air itu kembali pada keadaannya semula dan menenggelamkan semua kereta dan pasukan berkuda itu, yaitu semua pasukan Firaun yang masuk ke laut mengikuti bangsa Israel sehingga tidak ada satu pun yang tersisa dari mereka. ");
INSERT INTO indayt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Akan tetapi, bangsa Israel berjalan di atas tanah yang kering di tengah-tengah laut dan air menjadi seperti tembok bagi mereka, di sebelah kanan dan sebelah kirinya. ");
INSERT INTO indayt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Demikianlah, pada hari itu, TUHAN menyelamatkan Israel dari tangan orang Mesir dan Israel melihat orang-orang Mesir itu mati terdampar di pantai. ");
INSERT INTO indayt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ketika Israel melihat perbuatan besar yang TUHAN lakukan atas orang Mesir, bangsa itu menjadi takut akan TUHAN dan percaya kepada TUHAN, dan kepada Musa, hamba-Nya. ");
INSERT INTO indayt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kemudian Musa dan keturunan Israel menyanyikan lagu ini kepada TUHAN dengan perkataan yang berbunyi, “Aku akan bernyanyi bagi TUHAN, sebab Dia ditinggikan mulia. Kuda-kuda dan para penunggangnya telah dicampakkan-Nya ke laut. ");
INSERT INTO indayt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TUHAN adalah kekuatanku dan nyanyianku, Dia telah menjadi keselamatanku, Dialah Allahku dan aku akan memuji-Nya, Allah nenek moyangku, dan Aku akan meninggikan-Nya. ");
INSERT INTO indayt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TUHAN adalah pahlawan perang, TUHAN adalah nama-Nya. ");
INSERT INTO indayt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kereta-kereta Firaun dan pasukannya, telah dicampakkan-Nya ke laut, dan perwira-perwira pilihannya telah ditenggelamkan ke dalam Laut Teberau. ");
INSERT INTO indayt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kedalaman menutupi mereka, mereka tenggelam ke kedalaman bagaikan batu.” ");
INSERT INTO indayt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Tangan kanan-Mu, ya TUHAN, diagungkan dalam kekuatan, tangan kanan-Mu, ya TUHAN, menghancurkan musuh. ");
INSERT INTO indayt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Dalam kebesaran keagungan-Mu, Engkau merobohkan mereka yang bangkit untuk menentang-Mu. Engkau mengirim api murka-Mu yang melahap mereka bagaikan tunggul jerami. ");
INSERT INTO indayt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Dengan embusan dari lubang hidung-Mu, air naik bertimbun-timbun, Air yang mengalir menjadi seperti dinding, menjadi padat di jantung laut.” ");
INSERT INTO indayt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Musuh berkata, ‘Aku akan mengejar, aku akan menyusul, aku akan membagi-bagi jarahan, nafsuku akan terpuaskan atas mereka, aku akan menghunus pedangku, tanganku akan menghancurkan mereka.’ ");
INSERT INTO indayt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Engkau meniup mereka dengan angin-MU, maka laut meliputi mereka. Mereka tenggelam bagaikan timah ke dalam air yang kuat.” ");
INSERT INTO indayt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Siapakah yang seperti Engkau, ya TUHAN, di antara para ilah? Siapakah yang seperti Engkau agung dalam kekudusan, mengagumkan dalam kemuliaan, yang mengerjakan keajaiban-keajaiban? ");
INSERT INTO indayt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Engkau mengulurkan tangan kanan-Mu, dan bumi menelan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Dalam kebaikan-Mu, Engkau telah memimpin umat yang telah Engkau tebus. Dalam kekuatan-MU, Engkau telah membimbing mereka ke kediaman-Mu yang kudus.” ");
INSERT INTO indayt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“Bangsa-bangsa akan mendengar dan akan gemetar. Kegentaran akan mencekam penduduk Filistin. ");
INSERT INTO indayt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Para pemimpin Edom akan cemas, para pemimpin Moab dicekam kegentaran, seluruh penduduk Kanaan tak berdaya. ");
INSERT INTO indayt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kengerian dan ketakutan menimpa mereka. Oleh kedahsyatan tangan-Mu, mereka tidak dapat bergerak seperti batu, sampai umat-Mu menyeberang, ya TUHAN, sampai umat yang telah Engkau dapatkan itu menyeberang. ");
INSERT INTO indayt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Engkau akan membawa mereka dan menanam mereka di gunung milik pusaka-MU, di tempat yang telah Kaujadikan tempat kediaman-MU, ya TUHAN, di tempat kudus yang telah didirikan oleh tangan-MU, ya TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","TUHAN akan memerintah kekal selama-lamanya!” ");
INSERT INTO indayt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Sebab, kuda-kuda Firaun beserta kereta-keretanya dan pasukan berkudanya masuk ke dalam laut dan TUHAN mengembalikan lagi air laut ke atas mereka. Namun, keturunan Israel berjalan di tanah yang kering di tengah-tengah laut. ");
INSERT INTO indayt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kemudian Miryam, sang nabiah, adik Harun, memegang rebana di tangannya, dan semua perempuan keluar mengikutinya dengan rebana dan tari-tarian. ");
INSERT INTO indayt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryam menyahut mereka, “Bernyanyilah bagi TUHAN! Sebab, Dia ditinggikan mulia. Kuda dan penunggangnya telah dicampakkan-Nya ke dalam laut.” ");
INSERT INTO indayt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kemudian, Musa membawa Israel dari Laut Teberau dan mereka pergi ke Padang Belantara Syur. Mereka berjalan selama 3 hari di padang belantara dan tidak menemukan air. ");
INSERT INTO indayt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ketika mereka tiba di Mara, mereka tidak dapat minum air di Mara itu karena rasanya pahit. Itulah sebabnya, tempat itu disebut Mara. ");
INSERT INTO indayt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Jadi, bangsa itu bersungut-sungut kepada Musa dan berkata, “Apa yang akan kita minum?” ");
INSERT INTO indayt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Dia pun berseru kepada TUHAN dan TUHAN menunjukkan sepotong kayu kepadanya, dan ketika dia melemparkannya ke air, air itu menjadi manis. Di sana TUHAN membuat ketetapan dan peraturan bagi mereka, dan di sana Dia menguji mereka, ");
INSERT INTO indayt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","dan berfirman, “Jika kamu sungguh-sungguh mendengarkan suara TUHAN, Allahmu, melakukan yang benar dalam pandangan-Nya, memberikan telinga terhadap perintah-perintah-Nya, dan memelihara semua ketetapan-Nya, Aku tidak akan menimpakan satu pun penyakit yang telah Kutimpakan atas orang Mesir, sebab Akulah TUHAN yang menyembuhkanmu.” ");
INSERT INTO indayt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kemudian, mereka tiba di Elim. Di sana ada dua belas mata air dan tujuh puluh pohon kurma. Mereka berkemah di sana, di dekat air itu. ");
INSERT INTO indayt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kemudian mereka melakukan perjalanan dari Elim, dan seluruh jemaat keturunan Israel itu tiba di Padang Belantara Sin, yang terletak di antara Elim dan Sinai, pada hari kelima belas, bulan kedua, sejak mereka keluar dari tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Seluruh jemaat keturunan Israel itu bersungut-sungut lagi kepada Musa dan Harun di padang belantara itu, ");
INSERT INTO indayt_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","lalu keturunan Israel itu berkata kepada mereka, “Seharusnya kami ini mati di tangan TUHAN di tanah Mesir ketika kami duduk di dekat kuali berisi daging dan ketika kami makan roti sampai kenyang. Namun, kamu telah membawa kami ke padang belantara ini untuk membunuh seluruh jemaat ini dengan kelaparan.” ");
INSERT INTO indayt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kemudian, TUHAN berkata kepada Musa, “Lihat, Aku akan menghujanimu dengan roti dari langit, dan umat itu akan keluar dan mengumpulkannya sebanyak yang diperlukan setiap hari agar Aku dapat menguji mereka, apakah mereka akan berjalan menurut hukum-Ku atau tidak. ");
INSERT INTO indayt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pada hari yang keenam, ketika mereka mengolah apa yang mereka bawa pulang, jumlahnya harus dua kali lipat dari yang mereka kumpulkan sehari-hari.” ");
INSERT INTO indayt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Lalu, Musa dan Harun berkata kepada seluruh keturunan Israel, “Pada sore ini, kamu akan mengetahui bahwa TUHAN telah membawamu keluar dari tanah Mesir, ");
INSERT INTO indayt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","dan pada pagi hari, kamu akan melihat kemuliaan TUHAN karena Dia mendengar sungut-sungutmu terhadap TUHAN; dan siapakah kami ini sehingga kamu bersungut-sungut kepada kami?” ");
INSERT INTO indayt_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa berkata, “Hal ini akan terjadi ketika TUHAN memberimu daging untuk dimakan pada sore hari, dan roti pada pagi hari sampai kenyang; sebab TUHAN telah mendengar sungut-sungutmu yang kamu keluhkan kepada-Nya, dan apalah kami ini? Jadi, keluhanmu itu bukan kepada kami, melainkan kepada TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kemudian, Musa berkata kepada Harun, “Katakanlah kepada seluruh jemaat keturunan Israel, ‘Datanglah mendekat di hadapan TUHAN sebab Dia telah mendengar sungut-sungutmu.’” ");
INSERT INTO indayt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Harun segera berbicara kepada seluruh jemaat keturunan Israel agar mereka menengok ke padang belantara, dan lihat, kemuliaan TUHAN tampak dalam awan. ");
INSERT INTO indayt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Aku telah mendengar keluhan umat Israel. Katakanlah kepada mereka, ‘Pada waktu senja, kamu akan makan daging, dan pada pagi hari kamu akan dikenyangkan dengan roti, dan kamu akan mengetahui bahwa Akulah TUHAN, Allahmu.’” ");
INSERT INTO indayt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Lalu, terjadilah, pada sore hari itu, burung-buruh puyuh datang dan menutupi perkemahan; dan pada pagi hari, terdapat selapis embun di sekeliling perkemahan. ");
INSERT INTO indayt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ketika embun itu menguap, lihat, di permukaan padang belantara itu tampak sesuatu seperti serpihan yang halus, semacam embun beku di tanah. ");
INSERT INTO indayt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ketika bangsa Israel melihatnya, mereka saling bertanya, “Apa ini?” sebab mereka tidak tahu itu apa. Lalu, Musa berkata kepada mereka, “Itulah roti yang diberikan TUHAN kepadamu sebagai makananmu. ");
INSERT INTO indayt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Inilah perintah TUHAN, ‘Kumpulkanlah itu, masing-masing sesuai dengan yang dapat dimakannya, yaitu segomer untuk setiap orang, berdasarkan jumlah jiwa yang ada dalam tendanya.’” ");
INSERT INTO indayt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bangsa Israel melaksanakannya dan mengumpulkannya, ada yang banyak, ada yang sedikit. ");
INSERT INTO indayt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ketika mereka menakarnya dengan gomer, yang mengumpulkan banyak tidak kelebihan dan yang mengumpulkan sedikit tidak kekurangan. Masing-masing orang mengumpulkannya sebanyak yang dapat mereka makan. ");
INSERT INTO indayt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa berkata kepada mereka, “Jangan ada seorang pun yang menyisakannya sampai pagi.” ");
INSERT INTO indayt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Namun, mereka tidak mendengarkan Musa dan beberapa menyisakannya sampai pagi. Lalu, roti itu pun berulat dan berbau busuk. Musa pun marah kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mereka mengumpulkannya setiap pagi, setiap orang berdasarkan kebutuhannya, dan ketika matahari menjadi terik, dia meleleh. ");
INSERT INTO indayt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pada hari keenam, mereka mengumpulkan makanan sebanyak dua kali lipat, yaitu 2 gomer untuk setiap orang. Semua pemimpin umat datang dan menceritakannya kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa berkata kepada mereka, “Inilah perintah TUHAN, ‘Besok adalah peristirahatan, Sabat kudus bagi TUHAN. Pangganglah apa yang akan kamu panggang untuk hari ini, dan rebuslah apa yang akan kamu rebus. Lalu, sisihkanlah semua yang tersisa untuk kamu simpan sampai pagi.’” ");
INSERT INTO indayt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mereka menyisihkannya sampai pagi sebagaimana perintah Musa, dan roti itu tidak berbau busuk maupun berulat. ");
INSERT INTO indayt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa berkata, “Makanlah itu untuk hari ini sebab hari ini adalah Sabat bagi TUHAN. Pada hari ini, kamu tidak akan menemukannya di padang. ");
INSERT INTO indayt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Selama enam hari kamu akan mengumpulkannya, tetapi pada hari yang ketujuh, yaitu Sabat, tidak akan ada satu pun.” ");
INSERT INTO indayt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pada hari yang ketujuh, beberapa dari bangsa itu keluar untuk mengumpulkan roti itu, tetapi mereka tidak menemukan apa-apa. ");
INSERT INTO indayt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","TUHAN berkata kepada Musa, “Berapa lama lagi kalian menolak untuk memelihara perintah-Ku dan hukum-hukum-Ku? ");
INSERT INTO indayt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Lihat! TUHAN telah memberikan Sabat bagimu. Karena itu, pada hari yang keenam, Dia memberikan roti untuk dua hari kepadamu. Kamu harus tinggal di tempatmu masing-masing, tidak seorang pun boleh keluar dari tempatnya pada hari ketujuh.” ");
INSERT INTO indayt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Demikianlah bangsa itu beristirahat pada hari ketujuh. ");
INSERT INTO indayt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Orang Israel menyebut namanya manna. Ia seperti biji ketumbar, putih, dan rasanya seperti kue dengan madu. ");
INSERT INTO indayt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa berkata, “Inilah perintah TUHAN: ‘Ambillah segomer penuh untuk disimpan bagi keturunanmu supaya mereka dapat melihat roti, yang dengannya, Aku memberimu makanan di padang belantara, ketika aku membawamu keluar dari Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa berkata kepada Harun, “Ambillah sebuah buli-buli dan masukkan segomer manna ke dalamnya dan letakkanlah itu di hadapan TUHAN untuk disimpan bagi keturunanmu.” ");
INSERT INTO indayt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Sebagaimana yang telah TUHAN perintahkan kepada Musa, demikianlah Harun meletakkannya di depan tabut kesaksian untuk disimpan. ");
INSERT INTO indayt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bangsa Israel makan manna selama empat puluh tahun, sampai mereka tiba di tanah yang berpenghuni. Mereka makan manna sampai mereka tiba di perbatasan tanah Kanaan. ");
INSERT INTO indayt_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Satu gomer adalah sepersepuluh efa. ");
INSERT INTO indayt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kemudian, seluruh jemaat keturunan Israel berjalan dari Padang Belantara Sin untuk menempuh tahap demi tahap perjalanan mereka, sebagaimana yang telah TUHAN perintahkan, dan berkemah di Rafidim, tetapi di sana tidak ada air untuk diminum oleh bangsa itu. ");
INSERT INTO indayt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Karena itu, bangsa itu bertengkar dengan Musa dan berkata, “Berikan kami air supaya kami dapat minum!” Lalu, Musa berkata kepada mereka, “Mengapa kamu bertengkar denganku? Mengapa kamu mencobai TUHAN?” ");
INSERT INTO indayt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Akan tetapi, bangsa itu haus akan air sehingga bangsa itu bersungut-sungut kepada Musa, katanya, “Mengapa engkau membawa kami keluar dari Mesir? Apakah untuk membunuh kami, anak-anak kami, dan ternak kami dengan dahaga?” ");
INSERT INTO indayt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa pun berseru kepada TUHAN, katanya, “Apa yang harus aku lakukan terhadap bangsa ini? Mereka sudah siap untuk merajamku dengan batu.” ");
INSERT INTO indayt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","TUHAN pun menjawab Musa, “Berjalanlah di depan bangsa itu dan bawalah beberapa tua-tua Israel besertamu, juga tongkatmu yang kaupakai untuk memukul sungai, bawalah itu di tanganmu, lalu pergilah. ");
INSERT INTO indayt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lihat, Aku akan berdiri di depanmu di atas batu itu, di Horeb, dan kamu akan memukul batu itu, lalu air akan menyembur dari situ sehingga bangsa itu dapat minum.” Lalu, Musa melaksanakan hal itu di depan mata para tua-tua Israel. ");
INSERT INTO indayt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kemudian, dia menamakan tempat itu Masa dan Meriba karena pertengkaran dengan keturunan Israel dan karena mereka mencobai TUHAN dengan berkata, “Apakah TUHAN ada di tengah-tengah kita atau tidak?” ");
INSERT INTO indayt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kemudian, orang Amalek datang dan berperang dengan orang Israel di Rafidim. ");
INSERT INTO indayt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa pun berkata kepada Yosua, “Pilihlah beberapa orang bagi kita, lalu pergilah berperang melawan orang Amalek. Besok, aku akan berdiri di puncak bukit dengan tongkat Allah itu di tanganku.” ");
INSERT INTO indayt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosua melakukan seperti yang dikatakan Musa kepadanya dan berperang melawan orang Amalek. Sementara itu, Musa, Harun, dan Hur naik ke puncak bukit. ");
INSERT INTO indayt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Setiap kali Musa mengangkat tangannya, Israel menjadi kuat, tetapi ketika dia menurunkan tangannya, Amalek menjadi kuat. ");
INSERT INTO indayt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Namun, tangan musa menjadi berat, lalu mereka mengambil batu dan meletakkannya di bawahnya sehingga Musa dapat duduk di situ. Kemudian, Harun dan Hur menopang tangannya, yang seorang di sisi yang satu, dan yang seorang di sisi yang lain agar tangan Musa tetap terangkat hingga matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Itulah sebabnya, Yosua mengalahkan Amalek dan rakyatnya dengan mata pedang. ");
INSERT INTO indayt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kemudian, TUHAN berfirman kepada Musa, “Tulislah ini dalam sebuah kitab sebagai tanda peringatan dan taruhlah itu di telinga Yosua sebab Aku akan menghapuskan sama sekali ingatan akan Amalek dari bawah langit.” ");
INSERT INTO indayt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kemudian, Musa membangun sebuah mazbah dan menamakannya, “TUHAN adalah panji-panjiku,” ");
INSERT INTO indayt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","sebab katanya, “Tangan di atas panji-panji TUHAN! TUHAN akan berperang melawan Amalek turun-temurun.” ");
INSERT INTO indayt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ketika Yitro, imam di Midian, ayah mertua Musa, mendengar segala yang telah Allah lakukan bagi Musa dan bagi Israel, umat-Nya, yaitu bahwa TUHAN telah membawa Israel keluar dari Mesir, ");
INSERT INTO indayt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","maka Yitro, ayah mertua Musa itu, membawa Zipora, istri Musa, yang dahulu disuruhnya pulang, ");
INSERT INTO indayt_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","beserta dua anak laki-lakinya. Yang seorang bernama Gersom, sebab kata Musa, “Aku telah menjadi pendatang di negeri asing,” ");
INSERT INTO indayt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","dan yang seorang bernama Eliezer, sebab katanya, “Allah ayahku adalah pertolonganku dan yang melepaskanku dari pedang Firaun.” ");
INSERT INTO indayt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yitro, ayah mertua Musa, datang kepada Musa beserta anak-anak laki-lakinya dan istrinya di padang belantara, tempat dia berkemah di gunung Allah. ");
INSERT INTO indayt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Dia mengirimkan pesan kepada Musa, “Aku Yitro, ayah mertuamu, datang kepadamu beserta istrimu dan dua anak laki-lakimu.” ");
INSERT INTO indayt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa pun keluar untuk menemui ayah mertuanya, kemudian dia bersujud dan menciumnya, mereka saling menanyakan keadaan mereka, lalu mereka masuk ke tenda. ");
INSERT INTO indayt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa menceritakan kepada Yitro, ayah mertuanya, segala yang telah TUHAN lakukan terhadap Firaun demi Israel, dan segala kesukaran yang telah menimpa mereka dalam perjalanan, dan bagaimana TUHAN telah menyelamatkan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yitro bersukacita atas segala kebaikan yang TUHAN lakukan terhadap Israel, yang telah Dia lepaskan dari tangan orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yitro berkata, “Terpujilah TUHAN yang telah melepaskanmu dari tangan orang Mesir dan dari tangan Firaun, dan yang telah melepaskan bangsa ini dari bawah tangan orang Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sekarang, aku tahu bahwa TUHAN lebih besar daripada semua ilah, sebab dalam hal ini, orang-orang itu telah bertindak angkuh terhadap mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yitro ayah mertua Musa, membawa persembahan bakaran dan kurban bagi Allah. Kemudian, Harun datang beserta semua tua-tua Israel untuk makan roti bersama dengan ayah mertua Musa di hadapan Allah. ");
INSERT INTO indayt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pada hari berikutnya, Musa duduk untuk mengadili bangsa itu, dan bangsa itu berdiri di hadapan Musa dari pagi sampai sore. ");
INSERT INTO indayt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ketika ayah mertua Musa melihat semua yang dilakukannya terhadap bangsa itu, dia bertanya, “Apakah yang telah kamu lakukan terhadap bangsa ini? Mengapa kamu sendiri yang duduk sedangkan seluruh bangsa itu berdiri di hadapanmu dari pagi sampai sore?” ");
INSERT INTO indayt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa berkata kepada ayah mertuanya, “Sebab, bangsa ini datang kepadaku untuk mencari Allah. ");
INSERT INTO indayt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ketika ada perkara di antara mereka, mereka datang kepadaku agar aku menghakimi yang satu dengan yang lain, dan aku memberitahukan ketetapan Allah dan hukum-hukum-Nya kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ayah mertua Musa berkata kepadanya, “Yang kaulakukan itu tidak baik. ");
INSERT INTO indayt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kamu pasti benar-benar lelah, baik kamu maupun bangsa ini yang bersamamu, sebab ini terlalu berat bagimu dan engkau tidak akan sanggup melakukannya seorang diri. ");
INSERT INTO indayt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Sekarang, dengarkanlah suaraku, aku akan menasihatimu, dan Allah akan menyertaimu. Kamu harus mewakili bangsa ini di hadapan Allah dan membawa perkara-perkara mereka kepada Allah, ");
INSERT INTO indayt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","dan kamu harus mengajarkan kepada mereka tentang ketetapan dan hukum-hukum itu, dan harus memberitahukan kepada mereka mengenai jalan yang harus mereka tempuh dan apa yang harus mereka lakukan. ");
INSERT INTO indayt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Selain itu, kamu harus memilih orang-orang yang cakap dari antara bangsa itu, orang yang takut akan Allah, orang-orang benar, dan membenci laba hasil kecurangan. Lalu, tunjuklah beberapa orang di antara mereka untuk menjadi pemimpin seribu orang, pemimpin seratus orang, pemimpin lima puluh orang, dan pemimpin sepuluh orang. ");
INSERT INTO indayt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Biarlah mereka yang menghakimi bangsa itu sewaktu-waktu. Mereka harus membawa setiap perkara yang besar kepadamu, sedangkan perkara yang kecil harus mereka adili sendiri. Jadi, hal ini akan lebih ringan bagimu dan mereka akan ikut menanggungnya bersamamu. ");
INSERT INTO indayt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Jika kamu melakukan ini dan Allah memang memerintahkan demikian kepadamu, kamu akan sanggup menanggungnya dan seluruh bangsa ini juga akan kembali ke tempatnya masing-masing dengan sejahtera.” ");
INSERT INTO indayt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa mendengarkan suara ayah mertuanya dan melaksanakan seperti yang telah dikatakannya. ");
INSERT INTO indayt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa memilih orang-orang yang cakap dari antara bangsa Israel dan menjadikan mereka pemimpin atas bangsa itu: pemimpin seribu orang, seratus orang, lima puluh orang, dan sepuluh orang. ");
INSERT INTO indayt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Mereka menghakimi bangsa itu sewaktu-waktu. Mereka membawa perkara yang berat kepada Musa, sedangkan mereka dapat memutuskan sendiri untuk perkara-perkara yang kecil. ");
INSERT INTO indayt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Tidak lama kemudian, Musa melepas ayah mertuanya pergi dan Yitro pun pulang ke negerinya sendiri. ");
INSERT INTO indayt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Pada bulan ketiga sejak keturunan Israel keluar dari tanah Mesir, pada hari itu juga mereka tiba di Padang Belantara Sinai. ");
INSERT INTO indayt_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Mereka berangkat dari Rafidim dan tiba di Padang Belantara Sinai, lalu mendirikan tendanya di padang belantara itu. Orang Israel berkemah di sana, di depan gunung. ");
INSERT INTO indayt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kemudian, Musa naik menghadap Allah, dan TUHAN berseru kepadanya dari gunung itu, firman-Nya, “Inilah yang harus kamu katakan kepada keluarga Yakub dan ceritakan kepada keturunan Israel, ");
INSERT INTO indayt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kamu telah melihat yang Aku lakukan terhadap orang Mesir dan bagaimana Aku menopangmu di atas sayap rajawali dan membawamu kepada-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Oleh sebab itu, sekarang, jika kamu sungguh-sungguh menaati suara-Ku dan memelihara perjanjian-Ku, kamu akan menjadi harta kesayangan-Ku di atas segala bangsa sebab seluruh bumi ini adalah milik-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kamu akan menjadi imamat rajani bagiku dan bangsa yang kudus,’ itulah firman yang harus kamu katakan kepada keturunan Israel.” ");
INSERT INTO indayt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kemudian, Musa datang dan memanggil para tua-tua bangsa itu untuk menyampaikan semua firman yang telah TUHAN perintahkan kepadanya di hadapan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Seluruh bangsa itu serentak menjawab dan berkata, “Semua yang telah Allah firmankan itu akan kami lakukan.” Musa pun menyampaikan perkataan bangsa itu kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","TUHAN berkata kepada Musa, “Lihatlah, Aku akan datang kepadamu dalam awan yang tebal supaya umat Israel dapat mendengar saat Aku berbicara kepadamu dan percaya kepadamu selamanya.” Lalu, Musa menyampaikan perkataan bangsa itu kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","TUHAN berkata kepada Musa, “Pergilah kepada bangsa itu dan kuduskanlah mereka pada hari ini dan besok, lalu biarlah mereka mencuci pakaiannya, ");
INSERT INTO indayt_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kemudian, bersiaplah untuk hari yang ketiga karena pada hari yang ketiga itu, TUHAN akan turun dari Gunung Sinai di depan mata seluruh bangsa itu. ");
INSERT INTO indayt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kamu harus memasang batas bagi bangsa itu di sekelilingnya dan katakanlah, ‘Waspadalah, jangan sampai kamu naik ke gunung ini atau menyentuh batasnya. Siapa pun yang menyentuh gunung itu pasti akan dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tidak ada satu tangan pun yang boleh menyentuhnya karena dia pasti akan dirajam atau dipanah, entah itu binatang atau manusia, dia tidak akan hidup. Ketika trompet berbunyi panjang, mereka baru boleh mendaki gunung itu.’” ");
INSERT INTO indayt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Lalu, Musa turun dari gunung itu kepada bangsa itu dan menguduskan bangsa itu, lalu mereka mencuci pakaian mereka. ");
INSERT INTO indayt_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Setelah itu, dia berkata kepada bangsa itu, “Bersiaplah menghadapi hari yang ketiga, jangan bersetubuh dengan perempuan.” ");
INSERT INTO indayt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pada hari yang ketiga, pada pagi hari, terjadilah guruh, kilat, dan awan yang tebal di atas gunung itu. Lalu, terdengarlah suara trompet yang sangat keras sehingga semua orang di perkemahan itu gemetar. ");
INSERT INTO indayt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa membawa bangsa itu keluar dari perkemahan untuk bertemu dengan Allah dan mereka pun berdiri di kaki gunung itu. ");
INSERT INTO indayt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Pada saat itu, Gunung Sinai tertutup sepenuhnya oleh asap karena TUHAN turun dalam api dan asap membumbung seperti asap dari dapur api. Seluruh gunung pun berguncang hebat. ");
INSERT INTO indayt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ketika bunyi trompet semakin lama semakin keras, Musa berbicara dan Allah menjawabnya dalam guruh. ");
INSERT INTO indayt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","TUHAN turun ke Gunung Sinai, ke puncak gunung itu, lalu TUHAN memanggil Musa untuk naik ke puncak gunung itu, dan Musa pun naik. ");
INSERT INTO indayt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","TUHAN berfirman kepada Musa, “Turunlah dan peringatkan bangsa itu, jangan sampai mereka menerobos untuk melihat TUHAN sehingga banyak dari mereka yang akan binasa. ");
INSERT INTO indayt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Katakanlah juga kepada para imam yang datang mendekati Allah untuk menguduskan diri mereka agar jangan sampai TUHAN menghanguskan mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa berkata kepada TUHAN, “Bangsa itu tidak dapat naik ke gunung sebab Engkau sendiri sudah memperingatkan kami, firman-Mu, ‘Tetapkanlah batas di sekitar gunung itu dan kuduskanlah itu!’” ");
INSERT INTO indayt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kemudian TUHAN berkata kepadanya, “Turun dan naiklah kembali, kamu dan Harun bersamamu, tetapi jangan sampai para imam dan bangsa itu menerobos untuk datang kepada TUHAN supaya Dia tidak menghanguskan mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa pun turun kepada bangsa itu dan memberitahukan hal-hal ini kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Kemudian, Allah menyampaikan semua firman ini, kata-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Akulah TUHAN, Allahmu, yang membawamu keluar dari tanah Mesir, dari tempat perbudakan: ");
INSERT INTO indayt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Jangan ada padamu ilah lain di hadapan-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Jangan membuat berhala bagimu atau wujud apa pun yang ada di langit, di atas, atau di bumi, di bawah, atau di dalam air, di bawah bumi. ");
INSERT INTO indayt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Janganlah kamu menyembah atau beribadah kepadanya sebab Aku, TUHAN, Allahmu, adalah Allah yang cemburu, yang membalas kesalahan ayah kepada anak-anaknya sampai keturunan yang ketiga dan keempat dari orang-orang yang membenci Aku. ");
INSERT INTO indayt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Namun, Aku akan menunjukkan kasih setia kepada beribu-ribu orang yang mengasihi Aku dan yang menaati perintah-perintah-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Jangan menyebut nama TUHAN, Allahmu, dengan sia-sia karena TUHAN akan memandang bersalah siapa pun yang menyebut nama-Nya dengan sia-sia. ");
INSERT INTO indayt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ingatlah dan kuduskanlah hari Sabat. ");
INSERT INTO indayt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Selama enam hari kamu akan bekerja dan melakukan semua pekerjaanmu, ");
INSERT INTO indayt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","tetapi hari ketujuh adalah Sabat TUHAN, Allahmu. Pada hari itu, kamu tidak boleh melakukan pekerjaan apa pun, kamu, ataupun anak laki-lakimu, ataupun anak perempuanmu, ataupun hamba laki-lakimu, ataupun hamba perempuanmu, ataupun ternakmu, ataupun orang asing yang ada di kotamu. ");
INSERT INTO indayt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Sebab, selama enam hari TUHAN menciptakan langit dan bumi, laut dan segala yang ada di dalamnya, lalu beristirahat pada hari ketujuh. Karena itu, TUHAN memberkati hari Sabat dan menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hormatilah ayahmu dan ibumu supaya umurmu panjang di tanah yang diberikan TUHAN, Allahmu, kepadamu. ");
INSERT INTO indayt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Jangan membunuh. ");
INSERT INTO indayt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Jangan berzina. ");
INSERT INTO indayt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Jangan mencuri. ");
INSERT INTO indayt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Jangan mengucapkan kesaksian dusta tentang sesamamu. ");
INSERT INTO indayt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Jangan mengingini rumah sesamamu, jangan mengingini istri sesamamu, hamba laki-lakinya atau perempuan, sapinya, keledainya, atau apa pun yang adalah milik sesamamu.” ");
INSERT INTO indayt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Seluruh bangsa itu menyaksikan guntur dan kilat, bunyi trompet, dan gunung yang berasap. Ketika bangsa itu menyaksikannya, mereka gemetar dan berdiri jauh-jauh. ");
INSERT INTO indayt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kemudian, mereka berkata kepada Musa, “Berbicaralah kepada kami dan kami akan mendengarkan, tetapi jangan biarkan Allah berbicara dengan kami, atau kami akan mati.” ");
INSERT INTO indayt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa berkata kepada mereka, “Jangan takut! Sebab, Allah datang untuk mengujimu agar rasa takut akan Dia ada padamu sehingga kamu tidak berbuat dosa.” ");
INSERT INTO indayt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Jadi, bangsa itu pun berdiri jauh-jauh dan Musa menghampiri kegelapan yang pekat, tempat Allah hadir. ");
INSERT INTO indayt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","TUHAN berfirman kepada Musa, “Inilah yang harus kamu katakan kepada keturunan Israel, ‘Kamu sudah menyaksikan bahwa Aku telah berbicara kepadamu dari langit. ");
INSERT INTO indayt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Jangan kamu membuat ilah-ilah lain, di samping Aku, baik itu ilah dari perak maupun ilah dari emas, kamu tidak boleh membuatnya bagi dirimu. ");
INSERT INTO indayt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kamu harus membuat sebuah mazbah di bumi bagi-Ku dan harus mengurbankan persembahan bakaranmu dan persembahan pendamaianmu di atasnya, yaitu dombamu dan sapimu. Di setiap tempat yang Aku tentukan untuk mengingat nama-Ku, Aku akan datang kepadamu dan Aku akan memberkatimu. ");
INSERT INTO indayt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Jika kamu membuat sebuah mazbah batu bagi-Ku, jangan kamu membangunnya dari batu yang dipahat. Sebab, jika kamu mengangkat peralatanmu atasnya, kamu sudah mencemarkannya. ");
INSERT INTO indayt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Jangan kamu naik ke mazbah-Ku menggunakan tangga supaya ketelanjanganmu tidak terlihat di sana.’” ");
INSERT INTO indayt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kemudian, Allah berfirman kepada Musa, “Inilah peraturan-peraturan yang harus kamu tetapkan di depan mereka: ");
INSERT INTO indayt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Jika kamu membeli seorang budak Ibrani, dia harus bekerja untukmu selama 6 tahun. Namun, pada tahun yang ketujuh dia harus keluar dengan merdeka tanpa membayar apa pun. ");
INSERT INTO indayt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Jika dia masuk seorang diri saja, dia juga harus keluar seorang diri. Namun, jika dia sudah kawin, istrinya juga harus keluar bersamanya. ");
INSERT INTO indayt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Jika tuannya memberikan istri kepadanya dan istrinya itu melahirkan anak laki-laki atau anak perempuan, istri dan anak-anaknya akan menjadi milik tuannya, sedangkan dia harus keluar. ");
INSERT INTO indayt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Namun, jika hambanya itu berkata dengan sungguh-sungguh, ‘Aku mengasihi tuanku, istriku, dan anak-anakku, jadi aku tidak mau keluar sebagai orang merdeka,’ ");
INSERT INTO indayt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","tuannya harus membawanya ke hadapan Allah dan juga harus membawanya ke pintu atau ke tiang pintu, lalu tuannya akan menindik telinganya dengan penindik dan dia pun akan bekerja untuk tuannya selama-lamanya. ");
INSERT INTO indayt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Jika seseorang menjual anak perempuannya untuk menjadi budak, budak perempuan itu tidak dapat keluar seperti yang dilakukan oleh budak laki-laki. ");
INSERT INTO indayt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Jika budak perempuan itu tidak menyenangkan di mata tuannya, yang telah memilih sendiri budak perempuan itu baginya, tuannya harus membiarkannya ditebus, tuannya tidak punya hak untuk menjualnya kepada orang asing karena sudah berlaku curang terhadapnya. ");
INSERT INTO indayt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Jika tuannya memilih budak perempuan itu untuk anak laki-lakinya, tuannya itu harus memperlakukan dia sebagai anak perempuannya. ");
INSERT INTO indayt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Jika tuannya mengambil istri lain, tuannya itu tidak boleh mengurangi makanan, pakaian, dan kewajiban dalam perkawinan terhadap budak perempuannya. ");
INSERT INTO indayt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Jika dia tidak melakukan ketiga hal itu kepada budak perempuannya, budak perempuannya boleh keluar dengan merdeka tanpa membayar apa pun. ");
INSERT INTO indayt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Siapa pun yang memukuli orang lain sampai mati, dia harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Namun, jika dia tidak merencanakannya, melainkan Allahlah yang menyerahkan orang itu ke dalam tangannya, Aku akan menetapkan suatu tempat bagimu, ke mana dia dapat melarikan diri. ");
INSERT INTO indayt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Namun, jika seseorang naik darah terhadap sesamanya, lalu membunuhnya secara licik, kamu harus mengambil orang itu dari mazbah-Ku untuk dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Siapa yang membunuh ayahnya atau ibunya harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Siapa pun yang menculik seseorang, entah dia telah menjualnya atau masih berada di tangannya, dia harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Siapa pun yang mengutuk ayahnya atau ibunya harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Jika ada orang yang bertengkar, dan yang satu memukul yang lainnya dengan batu atau dengan tinjunya, tetapi dia tidak mati dan harus terbaring di tempat tidur, ");
INSERT INTO indayt_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","jika dia dapat bangun kembali dan berjalan dengan tongkatnya, orang yang memukulnya itu bebas dari hukuman, orang itu harus membayar waktu berhenti kerjanya, dan orang itu harus menanggungnya sampai benar-benar sembuh. ");
INSERT INTO indayt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Jika seseorang memukul budak laki-lakinya atau budak perempuannya dengan tongkat, dan budaknya itu mati di tangannya, dia harus dibalas. ");
INSERT INTO indayt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Namun, jika budaknya itu dapat bertahan selama satu atau dua hari, dia tidak akan dibalas sebab budaknya itu adalah uangnya. ");
INSERT INTO indayt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Jika ada orang yang berkelahi dan melukai perempuan yang sedang mengandung sehingga janinnya gugur dari perempuan itu, tetapi tidak ada luka lainnya, orang itu harus didenda sebanyak yang dibebankan oleh suami perempuan itu atasnya, dan dia harus membayarnya sesuai dengan keputusan hakim. ");
INSERT INTO indayt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Namun, jika ada luka lainnya, kamu harus membalas nyawa ganti nyawa, ");
INSERT INTO indayt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mata ganti mata, gigi ganti gigi, tangan ganti tangan, dan kaki ganti kaki, ");
INSERT INTO indayt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","luka bakar ganti luka bakar, luka ganti luka, bengkak ganti bengkak. ");
INSERT INTO indayt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Jika seseorang memukul mata budak laki-lakinya atau mata budak perempuannya dan merusaknya, dia harus membiarkan budaknya merdeka karena matanya itu. ");
INSERT INTO indayt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Jika dia memukul budaknya laki-laki dan budaknya perempuan sampai giginya tanggal, dia harus membiarkan budaknya merdeka karena giginya itu. ");
INSERT INTO indayt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Jika seekor sapi jantan menanduk seorang laki-laki atau perempuan sehingga orang itu mati, sapi itu harus dirajam dan dagingnya tidak boleh dimakan, sedangkan pemilik sapi itu bebas dari hukuman. ");
INSERT INTO indayt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Namun, jika sebelumnya sapi itu sudah sering menanduk dan pemiliknya juga sudah ditegur akan hal itu, tetapi dia tidak mengawasinya, lalu sapi itu membunuh seorang laki-laki atau perempuan, sapi itu harus dirajam dan pemiliknya pun harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Namun, jika kepadanya dibebankan uang tebusan, dia harus memberikannya sebagai tebusan untuk nyawanya berdasarkan segala sesuatu yang ditanggungkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Entah sapi itu menanduk seorang anak laki-laki ataupun anak perempuan, berdasarkan peraturan ini begitulah akan diterapkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Namun, jika sapi itu menanduk seorang budak laki-laki atau budak perempuan, pemilik sapi harus memberikan 30 syikal perak kepada tuannya, dan sapi itu harus dirajam. ");
INSERT INTO indayt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Jika ada orang yang membuka sumur atau jika ada orang yang menggali sumur dan tidak menutupnya, lalu seekor sapi jantan atau seekor keledai jantan jatuh ke dalamnya, ");
INSERT INTO indayt_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","pemilik sumur itu harus mengganti rugi dan memberikan sejumlah uang kepada pemilik ternak itu, tetapi ternak yang mati itu akan menjadi milik pemilik sumur. ");
INSERT INTO indayt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Jika sapi seseorang melukai sapi lainnya dan mati, mereka harus menjual ternak yang masih hidup itu dan membagi uangnya. Sapi yang mati itu pun harus dibagi dua. ");
INSERT INTO indayt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Atau, jika sudah diketahui bahwa sapi itu sudah sering menanduk sebelumnya, dan pemiliknya tidak menjaganya, dia harus membayar sapi jantan ganti sapi jantan, dan yang mati akan menjadi miliknya.” ");
INSERT INTO indayt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Jika seseorang mencuri seekor sapi jantan atau domba, lalu membunuhnya atau menjualnya, dia harus membayar lima sapi untuk mengganti sapi jantan itu dan empat domba untuk mengganti domba itu. ");
INSERT INTO indayt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Jika pencuri itu kedapatan sedang membobol, lalu dia dipukuli sampai mati, tidak akan ada utang darah atasnya. ");
INSERT INTO indayt_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Namun, jika matahari telah terbit atasnya, akan ada utang darah atasnya sehingga dia harus membayar kerugian sepenuhnya. Jika dia tidak memiliki apa-apa, dia harus dijual untuk mengganti curiannya itu. ");
INSERT INTO indayt_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Jika yang dicurinya itu didapati masih dalam keadaan hidup di tangannya, baik sapi, keledai, atau domba, dia harus membayar dua kali lipat. ");
INSERT INTO indayt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Jika seseorang membiarkan suatu ladang atau kebun anggur dimakan oleh ternaknya, lalu ternak itu dibiarkan untuk makan di ladang orang lain, dia harus membayar ganti rugi dengan hasil yang terbaik dari ladangnya sendiri atau dengan hasil yang terbaik dari kebun anggurnya sendiri. ");
INSERT INTO indayt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Jika api menyala dan melahap semak duri sehingga timbunan jagung atau ladang itu dimakan api, orang yang menyulut api itu harus membayar ganti rugi. ");
INSERT INTO indayt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Jika seseorang menitipkan uang kepada temannya untuk disimpan, lalu uang itu dicuri dari rumah orang itu dan pencurinya tertangkap, dia harus membayar ganti rugi sebesar dua kali lipat. ");
INSERT INTO indayt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Jika pencurinya tidak tertangkap, pemilik rumah itu harus dibawa ke hadapan Allah untuk mengetahui apakah dia telah mengulurkan tangannya atas barang-barang temannya itu. ");
INSERT INTO indayt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Untuk segala bentuk pelanggaran, baik itu tentang sapi, tentang keledai, tentang domba, tentang pakaian, atau tentang segala sesuatu yang hilang, dia yang mengatakan bahwa barang itu miliknya, keduanya harus membawanya ke hadapan Allah. Siapa pun yang Allah nyatakan bersalah harus membayar dua kali lipat kepada temannya. ");
INSERT INTO indayt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Jika seseorang menitipkan keledai, atau sapi, atau domba, atau hewan apa pun kepada temannya agar dia menjaganya, lalu hewan itu mati atau terluka, atau diambil orang tanpa ada seorang pun yang melihatnya, ");
INSERT INTO indayt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","harus ada sumpah di antara mereka demi TUHAN bahwa dia tidak mengulurkan tangannya atas milik temannya itu, dan pemiliknya harus menerimanya, dan dia tidak perlu membayar ganti rugi. ");
INSERT INTO indayt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Namun, jika hewan itu benar-benar dicuri darinya, dia harus membayar ganti rugi kepada pemiliknya. ");
INSERT INTO indayt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Jika hewan itu benar-benar tercabik-cabik, biarlah dia membawanya sebagai bukti sehingga dia tidak perlu membayar ganti rugi atas apa yang telah tercabik-cabik itu. ");
INSERT INTO indayt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Jika seseorang meminjam hewan apa pun dari temannya, lalu hewan itu terluka atau mati ketika pemiliknya tidak bersama dengannya, orang itu benar-benar harus membayar ganti rugi. ");
INSERT INTO indayt_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Namun, jika pemiliknya ada bersama dengan hewan itu, orang itu tidak perlu membayar ganti rugi. Jika hewan itu disewa, itu sudah mencakup biaya sewanya. ");
INSERT INTO indayt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Jika seorang laki-laki merayu seorang gadis yang belum bertunangan untuk tidur dengannya, dia harus membelinya sebagai istrinya. ");
INSERT INTO indayt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Jika ayah gadis itu menolak untuk memberikan anaknya kepada laki-laki itu, dia harus membayar sejumlah uang berdasarkan maskawin seorang gadis. ");
INSERT INTO indayt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Kamu tidak boleh membiarkan seorang perempuan penyihir hidup. ");
INSERT INTO indayt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Siapa pun yang bersetubuh dengan hewan harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Siapa pun yang berkurban bagi ilah-ilah lain, selain bagi TUHAN semata, dia harus dibinasakan. ");
INSERT INTO indayt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Kamu tidak boleh menindas orang asing ataupun menekannya karena dahulu kamu juga adalah orang asing di tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kamu tidak boleh menganiaya seorang janda atau anak yatim. ");
INSERT INTO indayt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Jika kamu menganiaya mereka dengan cara apa pun, lalu mereka berseru kepada-Ku, Aku akan benar-benar mendengarkan seruan mereka, ");
INSERT INTO indayt_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","dan murka-Ku akan menyala-nyala, lalu Aku akan membunuhmu dengan pedang sehingga istri-istrimu akan menjadi janda dan anak-anakmu menjadi yatim. ");
INSERT INTO indayt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Jika kamu meminjamkan uang kepada umat-Ku yang miskin di antaramu, kamu tidak boleh bertindak seperti penagih utang terhadapnya dan kamu juga tidak boleh menetapkan bunga kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Jika kamu mengambil jubah temanmu sebagai jaminan utang, kamu harus mengembalikan itu kepadanya sebelum matahari terbenam, ");
INSERT INTO indayt_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","sebab mungkin hanya itulah penutup tubuhnya, itulah pakaian bagi kulitnya, jadi dengan apakah dia akan tidur? Lalu, akan terjadi, ketika dia berseru kepada-Ku, Aku akan mendengarkannya sebab Aku ini murah hati. ");
INSERT INTO indayt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Kamu tidak boleh mengutuk Allah ataupun pemimpin bangsamu. ");
INSERT INTO indayt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Kamu tidak boleh menangguhkan persembahan dari hasil panenmu dan hasil anggurmu. Kamu harus menyerahkan anak laki-laki sulungmu kepada-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Demikianlah kamu juga harus melakukannya dengan sapi-sapimu dan dengan domba-dombamu. Selama 7 hari, hewan itu akan tinggal dengan induknya, lalu kamu harus menyerahkannya kepada-Ku pada hari kedelapan. ");
INSERT INTO indayt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Kamu harus menjadi umat yang kudus bagi-Ku. Sebab itu, kamu tidak boleh makan daging apa pun yang dicabik-cabik oleh binatang di padang, melainkan kamu harus melemparkannya kepada anjing.” ");
INSERT INTO indayt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Jangan menyebarkan perkataan yang sia-sia, jangan melibatkan tanganmu dengan orang jahat untuk menjadi saksi palsu baginya. ");
INSERT INTO indayt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Jangan kamu ikut-ikutan dengan orang banyak dalam hal melakukan kejahatan dan jangan pula kamu menjadi saksi dalam suatu perkara hukum, mengikuti kebanyakan orang, untuk menyesatkan keadilan, ");
INSERT INTO indayt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","dan jangan pula berpihak pada orang miskin dalam perkaranya. ");
INSERT INTO indayt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Jika kamu mendapati sapi musuhmu atau keledainya berkeliaran, kamu harus mengembalikannya kepada pemiliknya. ");
INSERT INTO indayt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Jika kamu melihat keledai milik orang yang membencimu rebah di bawah bebannya, jangan kamu meninggalkannya, kamu harus benar-benar melepaskan bebannya. ");
INSERT INTO indayt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Jangan kamu memutarbalikkan hak orang miskin dalam perkaranya. ");
INSERT INTO indayt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Menjauhlah dari perkara yang licik, dan jangan kamu membunuh orang yang tidak bersalah atau orang yang benar sebab Aku tidak membenarkan kejahatan. ");
INSERT INTO indayt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Jangan kamu menerima suap sebab suap dapat membutakan mata orang yang dapat melihat dan memutarbalikkan perkara orang yang benar. ");
INSERT INTO indayt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Jangan menindas orang asing. Kamu sendiri tahu rasanya menjadi orang asing sebab kamu adalah orang yang tinggal sementara di tanah Mesir.” ");
INSERT INTO indayt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Selama 6 tahun kamu harus menabur benih di tanahmu dan akan mengumpulkan hasilnya, ");
INSERT INTO indayt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","tetapi pada tahun ketujuh, kamu harus membiarkannya dan meninggalkannya supaya apa pun yang ditinggalkan oleh tanah itu dapat dimakan oleh binatang di ladang. Kamu harus melakukan hal yang sama dengan kebun anggurmu dan pohon-pohon zaitunmu. ");
INSERT INTO indayt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Enam hari lamanya kamu akan mengerjakan pekerjaanmu, tetapi pada hari ketujuh kamu harus beristirahat agar sapimu dan keledaimu dapat beristirahat, begitu pula dengan anak budak perempuanmu dan orang asing agar mereka dapat beristirahat. ");
INSERT INTO indayt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Perhatikanlah segala sesuatu yang telah Aku firmankan kepadamu dan jangan menyebut nama ilah-ilah lain dan jangan biarkan itu terdengar dari mulutmu! ");
INSERT INTO indayt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Tiga kali dalam setahun kamu harus mengadakan perayaan bagi-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Kamu harus memelihara perayaan Roti Tidak Beragi. Selama 7 hari kamu harus makan roti yang tidak beragi seperti yang telah Aku perintahkan kepadamu, pada waktu yang telah ditetapkan pada bulan Abib. Sebab, pada bulan itulah kamu keluar dari Mesir dan jangan ada seorang pun yang terlihat dengan tangan hampa di hadapan-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Kamu juga harus memelihara hari raya Panen, yaitu hasil pertama usahamu dari apa yang kamu tabur di ladang. Rayakanlah juga hari raya Pengumpulan Hasil pada setiap akhir tahun, yaitu ketika kamu mengumpulkan hasil usahamu dari ladang. ");
INSERT INTO indayt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Jadi, tiga kali dalam setahun semua laki-laki harus datang ke hadapan TUHAN Allah. ");
INSERT INTO indayt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Janganlah kamu persembahkan darah kurban untuk-Ku dengan roti yang beragi. Jangan sampai lemak dari perayaan-Ku tersisa hingga pagi. ");
INSERT INTO indayt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Kamu harus membawa hasil pertama yang terbaik dari ladangmu ke rumah TUHAN, Allahmu. Janganlah merebus anak kambing dalam susu induknya.” ");
INSERT INTO indayt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Lihatlah, Aku akan mengutus malaikat di hadapanmu untuk melindungimu dalam perjalanan dan untuk membawamu ke tempat yang telah Aku siapkan. ");
INSERT INTO indayt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Perhatikanlah dia dan taatilah suaranya, jangan kamu memberontak terhadapnya karena dia tidak akan mengampuni pelanggaran-pelanggaranmu. Sebab, nama-Ku ada dalam dia. ");
INSERT INTO indayt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Jika kamu benar-benar menaati suaranya dan melakukan semua yang Aku firmankan, Aku akan menjadi musuh bagi musuh-musuhmu dan lawan dari lawan-lawanmu. ");
INSERT INTO indayt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Sebab, malaikat-Ku akan berjalan di depanmu dan membawamu ke negeri orang Amori, dan orang Het, dan orang Feris, dan orang Kanaan, dan orang Hewi, dan orang Yebus, dan Aku akan melenyapkan mereka semua. ");
INSERT INTO indayt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Jangan kamu menyembah ilah-ilah mereka ataupun melayaninya. Jangan pula mengikuti perbuatannya, melainkan kamu harus benar-benar menggulingkan mereka dan menghancurkan tugu-tugu berhala mereka. ");
INSERT INTO indayt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kamu harus melayani TUHAN, Allahmu, maka Dia akan memberkati rotimu, airmu, dan akan menjauhkan segala penyakit dari antara kamu. ");
INSERT INTO indayt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tidak akan ada seorang pun yang keguguran atau mandul di tanahmu dan Aku akan menggenapkan hari-harimu. ");
INSERT INTO indayt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Aku akan mengutus kengerian-Ku di depan mereka dan akan memusnahkan semua orang yang kaudatangi. Aku akan membuat musuh-musuhmu membalikkan punggung mereka terhadapmu. ");
INSERT INTO indayt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Aku akan mengirimkan lebah di depanmu untuk menghalau orang Hewi, orang Kanaan, dan orang Het dari hadapan-Mu. ");
INSERT INTO indayt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Aku tidak akan menghalau mereka dari hadapanmu dalam waktu setahun supaya negeri itu tidak menjadi reruntuhan dan binatang liar di padang tidak bertambah jumlahnya untukmu. ");
INSERT INTO indayt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Jadi, Aku akan memaksa mereka keluar sedikit demi sedikit, sampai kamu bertambah banyak dan memiliki tanah itu. ");
INSERT INTO indayt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Aku akan menetapkan batasmu mulai dari Laut Teberau sampai ke Laut Filistin, dan dari padang belantara ke Sungai Efrat, sebab Aku akan memberikan penduduk negeri ini ke tanganmu dan kamu akan menghalau mereka dari hadapanmu. ");
INSERT INTO indayt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Jangan mengadakan perjanjian dengan mereka atau ilah-ilahnya. ");
INSERT INTO indayt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mereka tidak akan menetap di tanahmu supaya mereka tidak membuatmu berdosa terhadapku. Sebab, jika kamu melayani ilah-ilah mereka, hal itu pasti akan menjadi perangkap bagimu.” ");
INSERT INTO indayt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kemudian, Dia berfirman kepada Musa, “Naiklah ke hadapan TUHAN, kamu, Harun, Nadab, Abihu, dan tujuh puluh tua-tua Israel, dan bersujudlah dari kejauhan. ");
INSERT INTO indayt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Hanya Musa yang boleh mendekati TUHAN, tetapi mereka tidak boleh mendekat, dan bangsa itu pun tidak boleh naik bersamanya.” ");
INSERT INTO indayt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa datang dan menyampaikan segala firman TUHAN dan segala peraturan tersebut kepada bangsa itu. Seluruh bangsa itu menjawab dengan satu suara dan berkata, “Kami akan melaksanakan semua perintah yang telah difirmankan oleh TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa pun menulis semua firman TUHAN itu, dan bangun pagi-pagi pada keesokan harinya untuk mendirikan sebuah mazbah di kaki gunung itu, dengan dua belas tiang sesuai dua belas suku Israel. ");
INSERT INTO indayt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Dia mengutus beberapa pemuda dari keturunan Israel, lalu mereka mempersembahkan kurban bakaran dan mengurbankan sapi-sapi jantan muda sebagai persembahan pendamaian bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa mengambil setengah dari darah kurban itu dan memasukkannya ke dalam mangkuk-mangkuk, dan setengah darah yang lainnya dipercikkannya di mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Setelah itu, dia mengambil kitab perjanjian dan membacakannya di depan bangsa itu. Lalu, mereka berkata, “Segala yang telah TUHAN firmankan akan kami lakukan dan taati.” ");
INSERT INTO indayt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa mengambil darah itu dan memercikkannya ke atas bangsa itu dan berkata, “Lihatlah darah perjanjian yang telah TUHAN adakan denganmu berdasarkan semua firman itu.” ");
INSERT INTO indayt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kemudian, Musa, dan Harun, Nadab, dan Abihu, serta tujuh puluh tua-tua Israel naik ke gunung, ");
INSERT INTO indayt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","lalu mereka melihat Allah Israel, dan di bawah kaki-Nya tampak sesuatu seperti lantai dari batu nilam yang tampaknya bagaikan langit yang cerah. ");
INSERT INTO indayt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Allah tidak mengulurkan tangan-Nya ke atas para pemimpin keturunan Israel itu, dan mereka pun melihat Allah, lalu makan dan minum. ");
INSERT INTO indayt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","TUHAN berfirman kepada Musa, “Datanglah kepada-Ku di atas gunung dan tinggallah di sana. Aku hendak memberikan loh-loh batu kepadamu, dan hukum, dan perintah-perintah yang telah Aku tulis supaya kamu dapat mengajarkannya kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Setelah itu, Musa bangkit, begitu pula dengan Yosua yang melayaninya, dan Musa pun naik ke gunung Allah. ");
INSERT INTO indayt_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Dia berkata kepada para tua-tua, “Tunggulah kami di sini sampai kami kembali kepadamu. Lihat, Harun dan Hur bersama denganmu, jadi siapa pun yang beperkara biarlah dia datang kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kemudian, Musa naik ke gunung dan awan menyelimuti gunung itu. ");
INSERT INTO indayt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kemuliaan TUHAN bersemayam di Gunung Sinai dan awan menyelimutinya selama 6 hari. Pada hari yang ketujuh, Dia memanggil Musa dari tengah-tengah awan itu. ");
INSERT INTO indayt_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Di mata keturunan Israel, wujud kemuliaan TUHAN itu seperti api yang melahap di puncak gunung itu. ");
INSERT INTO indayt_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa masuk ke tengah-tengah awan itu dan dia naik ke atas gunung. Musa berada di gunung itu selama 40 hari dan 40 malam. ");
INSERT INTO indayt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Katakanlah kepada keturunan Israel untuk membawa persembahan bagi-Ku. Kamu harus menerima persembahan bagi-Ku dari setiap orang yang tergerak hatinya. ");
INSERT INTO indayt_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Inilah persembahan yang harus kamu ambil dari mereka: emas, dan perak, dan perunggu, ");
INSERT INTO indayt_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kain biru, dan kain ungu, dan kain kirmizi, dan linen halus, dan bulu kambing, ");
INSERT INTO indayt_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dan kulit domba jantan yang dicelup merah, dan kulit lumba-lumba, dan kayu akasia, ");
INSERT INTO indayt_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","minyak untuk penerangan, rempah-rempah untuk minyak urapan, dan untuk dupa yang harum, ");
INSERT INTO indayt_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","dan permata krisopras, dan permata lainnya untuk dipahat pada baju efod dan untuk tutup dada.” ");
INSERT INTO indayt_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Kemudian, mereka harus membuat suatu tempat kudus bagi-Ku supaya Aku dapat bersemayam di tengah-tengah mereka. ");
INSERT INTO indayt_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Berdasarkan segala hal yang akan Aku tunjukkan kepadamu, begitulah kamu harus membuatnya, yaitu sesuai dengan pola Tenda Suci dan pola segala perkakasnya.” ");
INSERT INTO indayt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Mereka harus membuat sebuah tabut dari kayu akasia yang panjangnya 2,5 hasta, lebarnya 1,5 hasta, dan tingginya 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kamu harus melapisinya dengan emas murni, bagian dalam maupun luarnya harus kamu lapisi, dan kamu harus membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kamu harus menuang empat gelang emas untuknya dan memasangnya pada empat kakinya, yaitu dua gelang pada salah satu sisinya dan dua gelang di sisi yang lainnya. ");
INSERT INTO indayt_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kamu harus membuat tongkat-tongkat pengusung dari kayu akasia dan lapisilah itu dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kamu harus memasukkan tongkat-tongkat itu ke dalam gelangnya di setiap sisi tabut supaya tabut itu dapat diusung dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tongkat-tongkat pengusung itu harus tetap berada dalam gelang-gelang tabut itu dan tidak boleh dilepas darinya.” ");
INSERT INTO indayt_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“Kamu akan memasukkan kesaksian yang telah Aku berikan kepadamu ke dalam tabut itu. ");
INSERT INTO indayt_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Setelah itu, kamu harus membuat tutup pendamaian dari emas murni yang panjangnya 2,5 hasta dan lebarnya 1,5 hasta ");
INSERT INTO indayt_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Lalu, kamu harus membuat dua kerub dari emas pada dua ujung tutup pendamaian dan buatlah itu dari emas tempaan. ");
INSERT INTO indayt_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Buatlah satu kerub untuk ujung sebelah sini dan kerub yang satu pada ujung sebelah sana. Kamu harus membuat kerub-kerub itu ada di atas tutup pendamaian, pada kedua ujungnya. ");
INSERT INTO indayt_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerub-kerub itu harus mengembangkan dua sayapnya ke atas untuk menundungi tutup pendamaian itu dengan sayapnya, wajahnya harus saling berhadapan, dan wajah mereka harus menghadap ke tutup pendamaian itu.” ");
INSERT INTO indayt_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“Kamu harus memasang tutup pendamaian itu di atas tabut dan di dalam tabut itu kamu harus memasukkan kesaksian yang akan Aku berikan kepadamu. ");
INSERT INTO indayt_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Aku akan menemuimu di situ, dan dari atas tutup pendamaian itu, dari antara dua kerub di tabut hukum itu, Aku akan berbicara kepadamu mengenai segala sesuatu yang akan Aku berikan kepadamu, yaitu perintah untuk keturunan Israel.” ");
INSERT INTO indayt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Kamu harus membuat sebuah meja dari kayu akasia yang panjangnya 2 hasta, lebarnya 1 hasta, tingginya 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kamu harus melapisinya dengan emas murni dan membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kamu harus membuat pinggiran sebesar telapak tangan di sekelilingnya dan kamu harus membuat bingkai emas untuk pinggiran di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Lalu, kamu harus membuat empat gelang emas untuknya, dan pasanglah gelang-gelang itu pada empat sudut, yaitu di keempat kakinya. ");
INSERT INTO indayt_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Gelang-gelang itu harus dipasang di dekat pinggiran meja sebagai tempat tongkat-tongkat pengusung untuk mengusung meja itu. ");
INSERT INTO indayt_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kamu harus membuat tongkat-tongkat pengusung dari kayu akasia dan melapisinya dengan emas supaya meja itu dapat diusung dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kamu harus membuat piring-piringnya, sendok-sendoknya, piala-pialanya, dan mangkuk-mangkuknya untuk persembahan curahan, kamu harus membuatnya dari emas murni. ");
INSERT INTO indayt_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kamu pun harus selalu meletakkan roti sajian di meja itu di hadapan-Ku.” ");
INSERT INTO indayt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Kemudian, kamu harus membuat kaki dian dari emas murni dan kaki dian itu harus dibuat dari emas tempaan, bagian alasnya, cabang-cabangnya, mangkuk-mangkuknya, kelopak-kelopaknya, dan bunga-bunganya harus seiras dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kaki dian itu harus mempunyai enam cabang yang menonjol dari sisi-sisinya, tiga cabang kaki dian dari sisi yang satu dan tiga cabang kaki dian dari sisi yang lainnya, ");
INSERT INTO indayt_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","dan tiga mangkuk yang dibuat seperti bunga badam dalam setiap cabang, masing-masing dengan satu kelopak dan satu bunga. Jadi, ada enam cabang yang menonjol dari kaki dian itu. ");
INSERT INTO indayt_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Lalu, pada kaki dian itu sendiri akan ada empat mangkuk yang dibuat seperti bunga badam dengan kelopak-kelopaknya dan bunga-bunganya. ");
INSERT INTO indayt_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ada satu kelopak di bawah sepasang cabang yang pertama dan satu kelopak lagi di bawah sepasang cabang yang kedua yang menonjol dari kaki dian itu, dan satu kelopak di bawah sepasang cabang yang ketiga yang menonjol darinya, sesuai dengan enam cabang yang menonjol dari kaki dian itu. ");
INSERT INTO indayt_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Semua kelopak dan cabangnya harus seiras dengannya, keseluruhan bagian itu harus terbuat dari sebongkah emas murni tempaan. ");
INSERT INTO indayt_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kamu harus membuat tujuh buah pelita untuk itu dan pelita-pelita itu harus dipasang begitu rupa untuk memberikan terang ke ruang di depannya. ");
INSERT INTO indayt_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Penyapit sumbu serta perbaraannya harus terbuat dari emas murni. ");
INSERT INTO indayt_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Itu harus dibuat dari 1 talenta emas murni termasuk segala perlengkapannya. ");
INSERT INTO indayt_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Pastikanlah kamu membuatnya berdasarkan pola yang telah Aku perlihatkan kepadamu di gunung.” ");
INSERT INTO indayt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Kamu harus membuat Tenda Suci dengan sepuluh tirai dari kain linen halus, dan kain biru, dan kain ungu, dan kain kirmizi, buatlah itu dengan kerub-kerub yang dikerjakan oleh seorang ahli. ");
INSERT INTO indayt_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Setiap tirai panjangnya harus 28 hasta dan masing-masing lebarnya adalah 4 hasta. Setiap tirai harus memiliki ukuran yang sama. ");
INSERT INTO indayt_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Lima helai tirai harus disambung satu sama lain, demikian pula dengan lima tirai lainnya harus disambung satu sama lain. ");
INSERT INTO indayt_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kamu harus membuat lubang pengancing dari kain biru pada tepi tirai paling luar dari masing-masing rangkaian tirai. ");
INSERT INTO indayt_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kamu harus membuat lima puluh lubang pengancing pada tirai-tirai dari rangkaian yang pertama, dan kamu harus membuat lima puluh lubang pengancing di pinggir tirai, yaitu di ujung tirai dari rangkaian yang kedua, dan lubang-lubang kancing itu harus saling berhadapan. ");
INSERT INTO indayt_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kamu harus membuat lima puluh pengait emas dan sambunglah tirai-tirai itu dengan pengait tersebut sehingga Tenda Suci menjadi satu. ");
INSERT INTO indayt_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kamu juga harus membuat tirai dari bulu kambing sebagai tudung untuk Tenda Suci; kamu harus membuatnya sebanyak sebelas tirai. ");
INSERT INTO indayt_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Panjang masing-masing tirai harus 30 hasta dan lebar masing-masing tirai harus 4 hasta, dan untuk sebelas tirai seluruhnya harus sama ukurannya. ");
INSERT INTO indayt_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kamu harus menyambung lima tirai secara tersendiri dan enam tirai secara tersendiri; dan tirai yang keenam harus kamu lipat menjadi dua di bagian depan tenda itu. ");
INSERT INTO indayt_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kamu harus membuat lima puluh lubang pengancing di tepi tirai yang paling luar dari rangkaian yang pertama dan lima puluh lubang pengancing di tepi tirai dari rangkaian yang kedua. ");
INSERT INTO indayt_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Lalu, kamu harus membuat lima puluh pengait perunggu dan memasukkan pengait-pengait itu di lubang-lubang pengancing untuk menyambung tenda itu bersama-sama agar menjadi satu. ");
INSERT INTO indayt_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Bagian yang berlebih dari sisa tirai-tirai tenda itu, yaitu setengah tirai yang tersisa, harus menjuntai di bagian belakang Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Sehasta pada sisi yang satu dan sehasta pada sisi yang lain menurut yang tersisa dari panjangnya tirai tenda itu harus menjuntai di sisi Tenda Suci, yaitu di sisi yang satu dan di sisi yang lainnya, untuk menutupinya. ");
INSERT INTO indayt_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Setelah itu, kamu harus membuat tudung untuk tenda itu dari kulit domba jantan yang dicelup merah dan tudung dari kulit lumba-lumba pada bagian atasnya. ");
INSERT INTO indayt_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kamu harus membuat papan-papan Tenda Suci itu dari kayu akasia yang tegak lurus. ");
INSERT INTO indayt_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Panjang setiap papan harus 10 hasta dan lebar setiap papan harus 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Harus ada dua pasak pada setiap papan untuk menyatukan yang satu dengan yang lainnya. Demikianlah kamu harus membuatnya untuk semua papan Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kamu harus membuat papan-papan untuk Tenda Suci, yaitu dua puluh papan untuk sisi sebelah selatan ke arah selatan. ");
INSERT INTO indayt_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Lalu, kamu harus membuat empat puluh alas perak di bawah dua puluh papan itu, yaitu dua alas di bawah satu papan untuk dua pasaknya, dan dua alas di bawah papan yang lain untuk dua pasaknya. ");
INSERT INTO indayt_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Untuk sisi kedua Tenda Suci, yaitu untuk sebelah utara, harus ada dua puluh papan, ");
INSERT INTO indayt_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","dengan empat puluh alas peraknya, dua alas di bawah satu papan, dan dua alas di bawah papan yang lainnya. ");
INSERT INTO indayt_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Untuk bagian belakang Tenda Suci di sebelah barat, kamu harus membuat enam papan. ");
INSERT INTO indayt_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kamu harus membuat dua papan untuk sudut-sudut Tenda Suci bagian belakang. ");
INSERT INTO indayt_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Papan-papan itu harus disambung pada bagian bawahnya, dan harus disambung sampai ke atas sampai pada gelang yang pertama. Demikianlah harus terjadi bagi keduanya, mereka akan membentuk dua sudut. ");
INSERT INTO indayt_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Jadi, harus ada delapan papan dan enam belas alas peraknya, dua alas di bawah papan yang satu dan dua alas di bawah papan lainnya. ");
INSERT INTO indayt_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Kamu harus membuat palang-palang dari kayu akasia, lima untuk papan-papan pada satu sisi Tenda Suci, ");
INSERT INTO indayt_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","dan lima palang untuk papan pada sisi lainnya dari Tenda Suci, dan lima palang untuk papan di sisi Tenda Suci, yaitu untuk dua sisi di sebelah barat. ");
INSERT INTO indayt_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Palang yang di tengah, di tengah-tengah papan-papan itu, harus melintang dari ujung ke ujung. ");
INSERT INTO indayt_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kamu harus melapisi papan-papan itu dengan emas dan membuat gelang-gelangnya dari emas untuk tempat palang-palang itu. Kamu harus melapisi palang-palang itu dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kamu harus mendirikan Tenda Suci itu menurut rancangan yang telah ditunjukkan kepadamu di gunung itu.” ");
INSERT INTO indayt_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kamu harus membuat tirai dari benang berwarna biru, ungu, dan merah dan dari kain linen yang halus. Seorang ahli harus menyulam gambar kerub pada tirai itu. ");
INSERT INTO indayt_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kamu harus menggantungnya pada empat tiang kayu akasia yang dilapisi emas, dengan kaitan emas, pada keempat alas perak. ");
INSERT INTO indayt_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kamu harus menggantung tirai itu di bawah kaitan-kaitan itu dan kamu harus membawa masuk tabut kesaksian ke sana ke bagian dalam tirai; dan tirai itu memisahkan Ruang Kudus dan Ruang Yang Mahakudus bagimu. ");
INSERT INTO indayt_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Taruhlah tutup pendamaian di atas Tabut Perjanjian di dalam Ruang Yang Mahakudus. ");
INSERT INTO indayt_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kamu harus meletakkan meja itu di bagian luar tirai, dan kaki dian di sebelah selatan Tenda Suci yang berhadapan dengan meja itu, dan kamu harus menempatkan meja itu di sebelah utara.” ");
INSERT INTO indayt_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“kamu harus membuat tirai untuk pintu tenda dari kain biru, kain ungu, kain kirmizi, dan linen halus yang dipintal, suatu karya seorang ahli. ");
INSERT INTO indayt_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kamu harus membuat lima tiang dari kayu akasia untuk tirai tersebut dan lapisilah dengan emas, kaitan-kaitannya juga harus terbuat dari emas, dan kamu harus menuang lima alas perunggu untuk itu.” ");
INSERT INTO indayt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Kamu harus membuat mazbah dari kayu akasia yang panjangnya 5 hasta dan lebarnya 5 hasta sehingga mazbah itu berbentuk persegi dengan tinggi 3 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kamu harus membuat tanduk-tanduk untuk empat sudutnya dan tanduk-tanduk itu harus dibuat seiras dengannya, lalu kamu harus melapisinya dengan perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kamu harus membuat belanga-belanga untuk menampung abunya, dan sekop-sekopnya, dan bokor-bokornya, dan garpu-garpunya, dan perbaraan-perbaraannya. Semua perkakas itu harus kamu buat dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kamu harus membuat jala-jala dari perunggu dan pada jala-jala itu kamu harus membuat empat gelang perunggu pada empat sudutnya. ");
INSERT INTO indayt_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kamu harus memasangnya di bawah pinggiran mazbah dari sebelah bawah supaya jala-jala itu sampai ke tengah-tengah mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kamu harus membuat tongkat-tongkat pengusung untuk mazbah itu, tongkat pengusung dari kayu akasia, dan lapisilah semuanya dengan perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Tongkat-tongkat pengusung itu harus dimasukkan ke dalam gelang-gelang, supaya tongkat-tongkat pengusung itu ada di dua sisi mazbah itu ketika diusung. ");
INSERT INTO indayt_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kamu harus membuatnya dari papan berongga, sebagaimana yang telah ditunjukkan kepadamu di gunung itu, demikianlah mereka harus membuatnya.” ");
INSERT INTO indayt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kamu harus membuat pelataran Tenda Suci yang di sisi selatannya harus ada tirai untuk pelataran itu dari kain linen halus yang dipintal dengan panjang 100 hasta untuk sisi yang itu, ");
INSERT INTO indayt_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","dan harus ada dua puluh tiang dengan dua puluh alas tiangnya dari perunggu, sedangkan kaitan-kaitan tiang itu dan penyambung-penyambungnya harus terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Demikian pula dengan sisi utara, harus ada tirai sepanjang 100 hasta dengan dua puluh tiang dan dua puluh alas tiangnya dari perunggu, sedangkan kaitan-kaitan tiang itu dan penyambung-penyambungnya harus terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Untuk lebar pelataran di sisi barat harus ada tirai berukuran 50 hasta dengan sepuluh tiang dan sepuluh alas tiangnya. ");
INSERT INTO indayt_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Di sisi timur pelataran itu, lebarnya harus 50 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Tirai untuk satu sisi gerbang itu harus berukuran 15 hasta dengan tiga tiang dan tiga alas tiangnya. ");
INSERT INTO indayt_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Di sisi lainnya harus ada tirai berukuran 15 hasta dengan tiga tiang dan tiga alas tiangnya. ");
INSERT INTO indayt_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Untuk gerbang pelataran harus ada tirai berukuran 20 hasta dari kain biru, kain ungu, kain kirmizi, dan kain linen halus yang dipintal, buatan ahli tenun, dengan empat tiang dan empat alas tiangnya. ");
INSERT INTO indayt_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Semua tiang di sekeliling pelataran harus tersambung dengan perak, kaitan-kaitannya dari perak dan alas-alas tiangnya dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Panjang pelataran itu harus sebesar 100 hasta dan lebarnya 50 hasta, dan tingginya 5 hasta, yang dibuat dari kain linen halus yang dipintal dengan alas-alas tiangnya dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Segala perlengkapan Tenda Suci untuk keperluan ibadah, semua patoknya, termasuk patok untuk pelataran harus terbuat dari perunggu.” ");
INSERT INTO indayt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Kamu harus memerintahkan kepada keturunan Israel untuk membawa minyak zaitun tumbuk yang murni kepadamu untuk penerangan agar pelita terus-menerus menyala. ");
INSERT INTO indayt_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Dalam tenda pertemuan, di bagian luar tirai yang menutupi tabut kesaksian, Harun dan anak-anaknya harus menjaga pelita itu dari petang hingga pagi di hadapan TUHAN. Hal itu harus menjadi ketetapan untuk selama-lamanya bagi keturunan mereka, yaitu bagi keturunan Israel.” ");
INSERT INTO indayt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Bawalah Harun, kakakmu, beserta anak-anaknya dari tengah-tengah keturunan Israel kepadamu supaya dia dapat melayani sebagai imam bagi-Ku, yaitu Harun, Nadab dan Abihu, Eleazar dan Itamar, para anak laki-laki Harun. ");
INSERT INTO indayt_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kamu harus membuat pakaian kudus untuk Harun, kakakmu, untuk kemuliaan dan keindahan. ");
INSERT INTO indayt_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kamu harus berbicara kepada semua orang ahli, yang telah Kupenuhi dengan roh hikmat, agar mereka membuat pakaian Harun untuk mengkhususkannya sehingga dia dapat melayani sebagai imam bagi-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Inilah pakaian yang harus mereka buat: tutup dada, dan baju efod, dan jubah, dan baju panjang yang bersulam, serban, dan ikat pinggang. Mereka harus membuat pakaian kudus itu untuk Harun, kakakmu, dan untuk para anak laki-lakinya supaya mereka dapat melayani-Ku sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Mereka harus menggunakan emas, dan kain biru, dan kain ungu, dan kain kirmizi, dan linen halus.” ");
INSERT INTO indayt_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Mereka harus membuat baju efod itu dari emas, kain biru, kain ungu, kain kirmizi, dan linen halus yang dipintal, buatan ahli tenun. ");
INSERT INTO indayt_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Pada baju efod itu harus ada dua penutup bahu yang saling menyambung pada dua ujungnya, demikianlah itu harus tersambung. ");
INSERT INTO indayt_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ikat pinggang yang ditenun dengan terampil, yang ada pada baju efod, harus dibuat dari bahan yang sama, yaitu dari emas, kain biru, kain ungu, kain kirmizi, dan kain linen halus yang dipintal. ");
INSERT INTO indayt_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Kamu harus mengambil dua permata krisopras dan mengukir nama anak-anak Israel di atasnya, ");
INSERT INTO indayt_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","enam nama mereka pada batu permata yang satu dan enam nama sisanya pada batu permata yang lainnya, berdasarkan kelahiran mereka. ");
INSERT INTO indayt_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Sebagaimana ahli pengukir permata, demikianlah kamu harus mengukir dua batu permata itu dengan nama anak-anak Israel, lalu kamu harus melilitnya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kamu harus meletakkan dua batu itu pada dua bahu baju efod sebagai batu permata peringatan akan anak-anak Israel, dan Harun harus membawa nama-nama mereka di bahunya, di hadapan TUHAN, sebagai tanda peringatan. ");
INSERT INTO indayt_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kamu harus membuat sulaman dari emas, ");
INSERT INTO indayt_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","dan dua rantai dari emas yang dijalin seperti tali, lalu kamu harus memasang untaian rantai itu pada sulaman emas itu.” ");
INSERT INTO indayt_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kamu harus membuat tutup dada penghakiman, yang dikerjakan oleh seorang ahli. Kamu harus membuatnya seperti pada baju efod, yaitu terbuat dari emas, kain biru, kain ungu, kain kirmizi, dan kain linen halus yang dipintal, demikianlah kamu harus membuatnya. ");
INSERT INTO indayt_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tutup dada itu harus berbentuk persegi, dilipat dua, sejengkal panjangnya dan sejengkal lebarnya. ");
INSERT INTO indayt_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kamu harus memasang empat baris batu permata padanya. Baris pertama harus terdiri dari permata yaspis merah, krisolit, dan malakit, itulah baris pertama. ");
INSERT INTO indayt_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Lalu, baris kedua harus terdiri dari permata batu darah, lazurit, dan yaspis hijau. ");
INSERT INTO indayt_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Baris ketiga adalah permata ambar, akik, dan kecubung. ");
INSERT INTO indayt_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Baris keempat adalah permata pirus, krisopras, dan nefrit. Semua itu harus dipasang dalam sulaman emas. ");
INSERT INTO indayt_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Harus ada dua belas permata dengan namanya yang sesuai dengan nama anak-anak Israel, sejumlah dua belas, seperti ukiran pada meterai, setiap permata dengan namanya tersendiri berdasarkan dua belas suku. ");
INSERT INTO indayt_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Untuk tutup dada, kamu harus membuat rantai dari emas murni yang dijalin seperti tali. ");
INSERT INTO indayt_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kamu harus membuat dua gelang emas pada tutup dada itu dan harus memasang dua gelang itu di ujung-ujung tutup dada itu. ");
INSERT INTO indayt_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kemudian, kamu harus memasang dua rantai emas itu pada dua gelang di ujung-ujung tutup dada itu. ");
INSERT INTO indayt_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Dua ujung lain dari rantai emas itu harus kamu pasang pada sulamannya, lalu pasanglah itu pada tutup bahu baju efod di bagian depannya. ");
INSERT INTO indayt_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kamu harus membuat dua gelang emas dan memasangnya pada kedua ujung tutup dada itu, di tepinya di bagian dalam baju efod. ");
INSERT INTO indayt_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kamu harus membuat dua gelang emas lainnya dan pasanglah itu pada kedua bahu efod di sebelah bawah, di bagian depannya, di dekat sambungannya, di atas pita efod. ");
INSERT INTO indayt_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mereka harus mengikat tutup dada itu dengan gelang-gelang baju efod dengan tali biru supaya tutup dada itu tidak terlepas dari baju efod. ");
INSERT INTO indayt_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Harun akan menanggung nama anak-anak Israel pada tutup dada penghakiman itu di atas jantungnya ketika dia masuk ke Ruang Kudus sebagai peringatan di hadapan TUHAN senantiasa. ");
INSERT INTO indayt_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Pasanglah Urim dan Tumim di tutup dada penghakiman itu yang keduanya harus ada di atas jantung Harun ketika dia pergi ke hadapan TUHAN, dan Harun akan menanggung penghakiman atas bangsa Israel di jantungnya, di hadapan TUHAN, senantiasa.” ");
INSERT INTO indayt_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Kamu harus membuat jubah efod yang semuanya terbuat dari kain biru. ");
INSERT INTO indayt_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Jubah itu harus mempunyai lubang pada bagian atasnya di tengah-tengahnya. Di sekeliling lubang itu harus ada pinggiran hasil karya seorang penenun, seperti lubang pada baju zirah agar jubah itu tidak mudah koyak. ");
INSERT INTO indayt_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kamu harus membuat hiasan delima dari kain biru, kain ungu, dan kain kirmizi di sekeliling tepi bawah jubah itu, dengan kerincing-kerincing emas di antaranya, ");
INSERT INTO indayt_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","satu kerincing emas, satu delima, satu kerincing emas, satu delima, di sekeliling bawah tepi jubah itu. ");
INSERT INTO indayt_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun harus memakainya ketika dia melayani, lalu bunyinya akan terdengar ketika dia masuk ke Ruang Kudus di hadapan TUHAN dan ketika dia keluar supaya dia tidak mati. ");
INSERT INTO indayt_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Kamu harus membuat pelat dari emas murni dan ukirlah di atasnya, seperti ukiran pada meterai: ‘Kudus bagi TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kamu harus memasangnya pada tali biru supaya dapat dipasang pada serban, yang harus dipasang di bagian depan serban. ");
INSERT INTO indayt_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Serban itu harus ada di dahi Harun supaya Harun dapat menanggung kesalahan dari segala yang kudus yang dikhususkan oleh keturunan Israel sebagai persembahan kudus mereka. Itu akan selalu ada di dahinya supaya dia dapat diterima di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Kamu harus menyulam baju panjang dari linen halus, dan harus membuat serban dari linen halus, dan kamu harus membuat ikat pinggang, suatu karya seorang penyulam. ");
INSERT INTO indayt_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Untuk anak-anak Harun, kamu harus membuat baju-baju panjang, kamu juga harus membuat ikat pinggang-ikat pinggang bagi mereka, dan kamu harus membuat ikat-ikat kepala bagi mereka untuk kemuliaan dan keindahannya. ");
INSERT INTO indayt_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kamu harus mengenakannya pada Harun, kakakmu, beserta anak-anaknya. Kamu harus mengurapi, menahbiskan, dan menguduskan mereka supaya mereka dapat melayani-Ku sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Kamu harus membuat celana-celana linen putih untuk ketelanjangan mereka, mulai dari pinggang sampai ke paha. ");
INSERT INTO indayt_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Semua itu harus dipakai oleh Harun dan anak-anaknya ketika mereka masuk ke tenda pertemuan, atau ketika mereka di dekat mazbah untuk melayani di Ruang Kudus agar mereka tidak menanggung kesalahan dan mati. Ini harus menjadi ketetapan baginya dan keturunannya untuk selama-lamanya.” ");
INSERT INTO indayt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Sekarang, inilah yang harus kamu lakukan kepada mereka, untuk menahbiskan mereka supaya mereka dapat melayani-Ku sebagai imam, ambillah seekor sapi jantan dan dua ekor domba jantan yang tidak bercacat, ");
INSERT INTO indayt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","dan roti tidak beragi, dan kue tidak beragi yang dicampur dengan minyak, dan roti tipis tidak beragi yang diolesi minyak. Kamu harus membuat semua itu dari tepung gandum yang baik. ");
INSERT INTO indayt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Kamu harus memasukkannya dalam satu keranjang dan mempersembahkannya dalam keranjang dengan sapi jantan dan dua domba jantan itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kamu harus membawa Harun dan anak-anaknya masuk ke tenda pertemuan dan membasuh mereka dengan air. ");
INSERT INTO indayt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kemudian, kamu harus mengambil pakaian-pakaian itu dan mengenakan jubah, jubah baju efod, baju efod, dan tutup dada, lalu sabukkanlah dia dengan pita efod yang dikerjakan secara terampil itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kamu harus memasangkan serban di kepalanya dan memasang mahkota kudus pada serban itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kemudian, ambillah minyak urapan dan curahkanlah itu di atas kepalanya dan urapilah dia. ");
INSERT INTO indayt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Setelah itu, kamu harus membawa anak-anaknya untuk mendekat dan kenakanlah jubah itu pada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kamu harus menyabuki mereka dengan ikat pinggang, yaitu Harun dan anak-anaknya, dan lilitkanlah ikat-ikat kepala kepada mereka supaya jabatan imam itu akan berlaku atas mereka menurut ketetapan selama-lamanya. Demikianlah kamu harus menahbiskan Harun dan anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Kemudian, kamu harus membawa sapi jantan ke depan tenda pertemuan, lalu Harun dan anak-anaknya akan meletakkan tangan mereka di atas kepala sapi itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Setelah itu, kamu harus menyembelih sapi jantan itu di hadapan TUHAN, di pintu tenda pertemuan, ");
INSERT INTO indayt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","dan ambillah sebagian darah sapi itu, dan oleslah itu pada tanduk-tanduk mazbah dengan jarimu, lalu tuanglah seluruh darah itu ke dasar mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kamu harus mengambil semua lemak yang menutupi isi perutnya, dan hati bagian atas, dan dua ginjal dengan lemaknya, lalu bakarlah itu di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Namun, untuk daging sapi jantan itu, kulitnya, dan kotorannya harus kamu bakar di luar tenda, itu adalah persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Kemudian, kamu harus mengambil seekor domba jantan, lalu Harun dan anak-anaknya harus meletakkan tangan mereka di kepala domba itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kamu harus menyembelih domba itu, dan harus mengambil darahnya, dan memercikkannya ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kemudian, kamu harus memotong domba jantan itu menurut bagian-bagiannya, dan cucilah isi perutnya, kaki-kakinya, dan taruhlah itu di atas bagian-bagiannya dan di atas kepalanya. ");
INSERT INTO indayt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kamu harus membakar seluruh domba jantan itu di atas mazbah, inilah persembahan bakaran bagi TUHAN, inilah bau yang harum, inilah persembahan dengan api bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kemudian, kamu harus mengambil domba jantan yang seekor lagi, dan Harun beserta anak-anaknya harus meletakkan tangan mereka di kepala domba itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kamu harus menyembelih domba jantan itu, dan mengambil darahnya, dan mengoleskannya pada cuping telinga kanan Harun dan pada cuping telinga kanan anak-anaknya, dan pada ibu jari tangan kanan mereka, dan pada ibu jari kaki kanan mereka, lalu percikkanlah sisa darah itu di sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kemudian, kamu harus mengambil darah yang di atas mazbah dan dari minyak urapan, lalu percikkanlah itu kepada Harun dan pada jubahnya, pada anak-anaknya dan pada jubah anak-anaknya yang bersamanya. Demikianlah dia akan dikuduskan, dan jubahnya, dan anak-anaknya, dan jubah anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Kamu juga harus mengambil lemak dari domba jantan itu, dan ekornya yang berlemak, dan lemak yang menutupi isi perutnya, dan umbai hatinya, dan dua ginjal dengan lemaknya, dan paha kanannya karena ini adalah domba jantan penahbisan, ");
INSERT INTO indayt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","dan sepotong roti, dan sepotong kue berminyak, dan satu roti tipis dari keranjang roti tidak beragi yang ada di hadapan TUHAN, ");
INSERT INTO indayt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","lalu kamu harus meletakkan semua itu di tangan Harun dan di tangan anak-anaknya, dan harus mengunjukkannya sebagai persembahan unjukan di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kemudian, kamu harus mengambilnya dari tangan mereka dan membakarnya di atas mazbah untuk persembahan bakaran sebagai bau yang harum di hadapan TUHAN, inilah suatu persembahan dengan api untuk TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kamu harus mengambil dada domba jantan dari penahbisan Harun dan mengunjukkannya sebagai persembahan unjukan di hadapan TUHAN, dan itu akan menjadi bagianmu. ");
INSERT INTO indayt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Lalu, kamu harus menguduskan dada persembahan unjukan dan paha persembahan unjukan itu, yang diunjukkan dan dipersembahkan dari domba jantan penahbisan, yaitu dari bagian untuk Harun dan dari bagian untuk anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Itu harus menjadi bagian Harun dan anak-anaknya dari keturunan Israel yang ditetapkan untuk selama-lamanya karena hal itu adalah persembahan, dan ini harus menjadi persembahan dari keturunan Israel dari kurban persembahan pendamaian mereka, persembahan mereka bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Pakaian kudus Harun harus menjadi milik anak-anaknya setelah dia agar mereka diurapi dengan itu dan ditahbiskan pula dengan itu. ");
INSERT INTO indayt_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Anak yang menggantikannya sebagai imam harus mengenakan pakaian itu selama tujuh hari ketika dia memasuki tenda pertemuan untuk melayani di Ruang Kudus. ");
INSERT INTO indayt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ambillah domba jantan dari penahbisan itu dan rebuslah dagingnya di Ruang Kudus. ");
INSERT INTO indayt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harun dan anak-anaknya harus memakan daging domba itu dan roti yang ada dalam keranjang di pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Mereka harus makan segala sesuatu yang dengannya penebusan itu diadakan untuk menahbiskan dan menguduskan mereka. Namun, orang biasa tidak boleh memakannya karena hal-hal ini adalah kudus. ");
INSERT INTO indayt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Jika ada daging dari persembahan penahbisan itu atau roti yang tersisa sampai pagi, kamu harus membakarnya dengan api. Itu tidak boleh dimakan karena itu kudus. ");
INSERT INTO indayt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Demikianlah yang harus dilakukan Harun dan anak-anaknya menurut semua yang telah Aku perintahkan kepadamu. Selama tujuh hari kamu harus menahbiskan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Setiap hari, kamu harus mempersembahkan seekor sapi jantan sebagai persembahan penghapus dosa untuk pendamaian. Kamu juga harus membersihkan mazbah ketika kamu mengadakan pendamaian untuknya, lalu kamu harus mengurapinya untuk menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Selama tujuh hari kamu harus mengadakan pendamaian untuk mazbah itu dan menguduskannya sehingga mazbah itu akan menjadi mahakudus. Apa pun yang menyentuh mazbah itu akan menjadi kudus. ");
INSERT INTO indayt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Inilah yang harus kamu persembahkan di atas mazbah itu secara teratur setiap hari: dua ekor anak domba yang berumur setahun. ");
INSERT INTO indayt_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kamu harus mempersembahkan seekor domba pada pagi hari dan domba yang lainnya harus kamu persembahkan pada petang hari. ");
INSERT INTO indayt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Bersama dengan domba yang pertama, campurlah 1/10 efa tepung halus dengan 1/4 hin minyak zaitun yang ditumbuk dan 1/4 hin anggur sebagai persembahan curahan. ");
INSERT INTO indayt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Domba berikutnya harus kamu persembahkan pada waktu senja. Persembahkanlah itu bersama dengan persembahan sajian dan persembahan curahan seperti yang diberikan pada pagi hari, yang harum baunya, suatu kurban bakaran bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ini harus menjadi persembahan bakaran yang terus ada secara turun-temurun, di pintu tenda pertemuan, di hadapan TUHAN, tempat Aku akan bertemu denganmu dan berbicara denganmu. ");
INSERT INTO indayt_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Di sana, Aku akan bertemu dengan keturunan Israel dan tempat itu akan dikuduskan oleh kemuliaan-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Aku akan menguduskan tenda pertemuan dan mazbahnya. Aku juga akan menguduskan Harun maupun anak-anaknya untuk melayani-Ku sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Aku akan tinggal di antara keturunan Israel dan Aku akan menjadi Allah mereka. ");
INSERT INTO indayt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Mereka harus tahu bahwa Akulah TUHAN, Allah mereka, yang telah membawa mereka keluar dari tanah Mesir agar Aku dapat tinggal di antara mereka. Akulah TUHAN, Allah mereka.” ");
INSERT INTO indayt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Kamu harus membuat mazbah untuk membakar dupa dan kamu harus membuatnya dari kayu akasia. ");
INSERT INTO indayt_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Panjangnya harus sehasta, lebarnya harus sehasta, bentuknya harus persegi, dan tingginya harus 2 hasta, tanduk-tanduknya harus seiras dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kamu harus melapisinya dengan emas murni pada bagian atasnya, dan sisi-sisi di sekelilingnya, dan tanduk-tanduknya, lalu kamu harus membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kamu harus membuat dua gelang emas di bawah bingkainya dan kamu harus membuatnya pada dua sisinya karena itu akan menjadi tempat tongkat pengusung, yang dengannya mazbah itu dapat diusung. ");
INSERT INTO indayt_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kamu harus membuat tongkat-tokat pengusung dari kayu akasia dan melapisinya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kamu harus meletakkannya di depan tirai, di hadapan tabut kesaksian, di depan tutup pendamaian di atas tabut kesaksian itu, tempat Aku akan menemuimu. ");
INSERT INTO indayt_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Setiap pagi, Harun harus membakar dupa yang harum di atas mazbah, ketika dia membersihkan pelita-pelita, dia harus membakarnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ketika Harun menyalakan pelita-pelita itu pada waktu senja, dia harus membakar dupa itu, suatu persembahan dupa di hadapan TUHAN yang harus terus-menerus dilakukan oleh keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kamu tidak boleh mempersembahkan dupa asing di atasnya, atau persembahan bakaran, atau persembahan sajian, dan kamu juga tidak boleh menuangkan persembahan curahan di atasnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Harun harus mengadakan pendamaian pada tanduk-tanduknya setahun sekali dengan darah dari persembahan penghapus dosa. Setahun sekali, dia harus mengadakan pendamaian itu, turun-temurun, sebab mazbah itu adalah yang mahakudus bagi TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ketika kamu mengadakan sensus bagi keturunan Israel untuk menghitung mereka, setiap orang dari mereka harus memberikan pendamaian bagi dirinya sendiri kepada TUHAN ketika kamu menghitung mereka supaya tidak ada wabah di antara mereka ketika kamu menghitungnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Setiap orang yang dihitung pada sensus tersebut harus memberi ini: 0,5 syikal menurut syikal tempat kudus, berat 1 syikal adalah 20 gera, 0,5 syikal itu sebagai persembahan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Setiap orang yang dihitung, yaitu yang berusia 20 tahun ke atas, harus memberikan persembahan kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Orang kaya tidak boleh memberi lebih banyak, dan orang miskin tidak boleh memberi lebih sedikit dari 0,5 syikal, ketika mereka memberikan persembahan kepada TUHAN untuk mengadakan pendamaian atas jiwamu. ");
INSERT INTO indayt_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kamu harus mengambil uang pendamaian itu dari bangsa Israel dan harus memberikannya untuk pelayanan tenda pertemuan supaya itu menjadi peringatan bagi keturunan Israel di hadapan TUHAN, yaitu untuk mengadakan pendamaian bagi jiwamu.” ");
INSERT INTO indayt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kemudian, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kamu harus membuat sebuah bejana perunggu untuk membasuh dengan alasnya yang terbuat dari perunggu, dan kamu harus meletakkannya di antara tenda pertemuan dan mazbah, lalu kamu harus memasukkan air ke dalamnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harun dan anak-anaknya harus mencuci tangan dan kaki mereka dengan air dari bejana ini. ");
INSERT INTO indayt_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ketika mereka masuk ke tenda pertemuan, mereka harus dibasuh dengan air supaya mereka tidak mati, atau ketika mereka mendekati mazbah untuk melayani, yaitu untuk membakar persembahan dengan api kepada TUHAN, ");
INSERT INTO indayt_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","mereka harus membasuh tangan mereka dan kaki mereka supaya mereka tidak mati. Ini akan menjadi peraturan yang berlaku selamanya bagi Harun dan keturunannya, turun-temurun.” ");
INSERT INTO indayt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kemudian, TUHAN berkata kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ambillah rempah-rempah yang terbaik: 500 syikal minyak mur, dan kayu manis harum sebanyak setengah dari itu, yaitu 250 syikal, dan 250 syikal tebu yang baik, ");
INSERT INTO indayt_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","dan 500 syikal kasia menurut syikal kudus, dan 1 hin minyak zaitun. ");
INSERT INTO indayt_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kamu harus membuat minyak urapan kudus dari semua bahan itu, suatu campuran rempah-rempah yang dibuat oleh seorang ahli wewangian. Itulah yang akan menjadi minyak urapan kudus. ");
INSERT INTO indayt_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Lalu, dengan itu kamu harus mengurapi tenda pertemuan dan tabut kesaksian, ");
INSERT INTO indayt_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meja dan segala perkakasnya, kaki dian dan segala perkakasnya, dan mazbah dupa, ");
INSERT INTO indayt_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mazbah persembahan bakaran dan segala perkakasnya, dan bejana pembasuhan dengan alasnya. ");
INSERT INTO indayt_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kamu harus menguduskan semua itu sehingga semuanya menjadi mahakudus. Segala sesuatu yang menyentuh barang-barang itu juga akan menjadi kudus. ");
INSERT INTO indayt_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Kamu juga harus mengurapi Harun dan anak-anaknya dan menguduskan mereka supaya mereka dapat melayani-Ku sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kamu harus mengatakan kepada keturunan Israel begini, ‘Ini akan menjadi minyak urapan kudus untuk seluruh keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Minyak itu tidak boleh dicurahkan atas tubuh orang-orang biasa. Juga, jangan membuat tiruan dari minyak ini sebab ini kudus dan haruslah itu kudus bagi kamu. ");
INSERT INTO indayt_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Siapa pun membuat yang seperti itu atau siapa pun yang mengoleskannya pada orang biasa, harus dilenyapkan dari antara bangsanya.’” ");
INSERT INTO indayt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","TUHAN berkata kepada Musa, “Ambillah rempah-rempah yang harum ini bagimu: getah damar, kulit lokan, getah rasamala, dan dupa murni. Jumlah masing-masing haruslah sama. ");
INSERT INTO indayt_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Dari semua itu, kamu harus membuat dupa, suatu wangi-wangian, yang dikerjakan oleh ahli wewangian, lalu garamilah agar murni dan kudus. ");
INSERT INTO indayt_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kamu harus menumbuk sebagian dupa itu hingga halus dan meletakkannya di depan tenda pertemuan, tempat Aku akan bertemu denganmu. Itu harus menjadi mahakudus bagimu. ");
INSERT INTO indayt_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Dupa yang kamu buat itu tidak boleh kamu buat dengan takaranmu sendiri. Itu harus kudus bagimu, untuk TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Siapa pun yang membuat yang seperti itu sebagai wewangian, harus dilenyapkan dari bangsanya.” ");
INSERT INTO indayt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kemudian, TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Lihat, Aku telah memanggil nama Bezaleel, anak Uri, anak Hur, dari suku Yehuda, ");
INSERT INTO indayt_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","dan Aku telah memenuhinya dengan Roh Allah dalam hal hikmat, dan pengertian, dan pengetahuan, dan bermacam-macam keahlian ");
INSERT INTO indayt_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","untuk membuat berbagai rancangan dari emas, perak, dan perunggu, ");
INSERT INTO indayt_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","dan dalam hal mengasah permata untuk pahatannya, dan dalam hal mengukir kayu untuk mengerjakan bermacam-macam keahlian. ");
INSERT INTO indayt_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Lihatlah, Aku juga telah menetapkan seseorang untuk menyertainya, yaitu Aholiab, anak Ahisamakh, dari suku Dan. Bahkan, Aku telah memberikan keahlian kepada semua pekerja lainnya supaya mereka dapat membuat segala sesuatu yang telah Kuperintahkan kepadamu, yaitu: ");
INSERT INTO indayt_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tenda pertemuan, tabut kesaksian, tutup pendamaian di atasnya, dan semua perlengkapan tenda; ");
INSERT INTO indayt_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meja dan perkakasnya, kaki dian dari emas murni dan segala perkakasnya, mazbah pembakaran dupa, ");
INSERT INTO indayt_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","mazbah kurban bakaran dan segala perkakasnya, bejana pembasuhan dan alasnya, ");
INSERT INTO indayt_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pakaian khusus untuk Harun dan anak-anaknya apabila mereka melayani sebagai imam, ");
INSERT INTO indayt_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","minyak urapan yang harum, dan dupa yang harum untuk Ruang Kudus. Mereka harus membuat semua itu sebagaimana yang Aku perintahkan kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Katakanlah kepada bangsa Israel, begini, ‘Kamu harus sungguh-sungguh memelihara sabat-sabat-Ku sebab itu adalah tanda antara Aku dan kamu bagi keturunanmu supaya kamu mengetahui bahwa Akulah, TUHAN, yang telah menguduskan kamu. ");
INSERT INTO indayt_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Oleh sebab itu, kamu harus memelihara hari Sabat karena itu adalah hari yang kudus bagimu. Setiap orang yang mencemarkannya harus dihukum mati sebab siapa saja yang bekerja saat itu, orang itu harus dilenyapkan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Selama enam hari kamu boleh bekerja, tetapi hari ketujuh adalah hari Sabat, hari peristirahatan yang kudus bagi TUHAN. Siapa pun yang bekerja pada hari Sabat harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Sebab itu, bangsa Israel harus memelihara Sabat untuk merayakan Sabat, turun-temurun, sebagai suatu perjanjian untuk selamanya. ");
INSERT INTO indayt_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Itu adalah tanda antara Aku dan keturunan Israel selama-lamanya. Sebab, selama enam hari TUHAN bekerja menciptakan langit dan bumi, dan pada hari ketujuh Dia berhenti dan beristirahat.” ");
INSERT INTO indayt_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Setelah TUHAN selesai berbicara kepada Musa di Gunung Sinai, Dia memberikan kepadanya dua loh batu, yang bertuliskan hukum-hukum yang ditulis dengan jari Allah sendiri. ");
INSERT INTO indayt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ketika bangsa Israel melihat bahwa Musa menunda untuk turun dari gunung, bangsa itu berkumpul untuk datang kepada Harun dan berkata kepadanya, “Ayo, buatlah ilah bagi kami yang akan berjalan di depan kami, sebab Musa, orang yang telah membawa kami keluar dari tanah Mesir, kami tidak tahu yang terjadi atasnya.” ");
INSERT INTO indayt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Lalu, Harun berkata kepada mereka, “Lepaskanlah semua anting-anting emas yang ada di telinga istrimu, anak laki-lakimu, dan anak perempuanmu, lalu bawalah itu kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Oleh karena itu, seluruh bangsa itu melepas anting-anting emas yang ada di telinga mereka dan membawanya kepada Harun. ");
INSERT INTO indayt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Dia menerimanya dari tangan mereka dan membentuknya dengan alat pahat, lalu dia membuatnya menjadi anak sapi tuangan. Kemudian, mereka berkata, “Inilah ilahmu, hai Israel, yang telah membawamu keluar dari tanah Mesir!” ");
INSERT INTO indayt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ketika Harun melihatnya, dia membangun mazbah di hadapan anak sapi itu, lalu Harun membuat pengumuman dan berkata, “Besok akan menjadi hari raya bagi TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mereka bangun pagi-pagi pada keesokan harinya dan mempersembahkan persembahan bakaran, dan membawa persembahan pendamaian. Lalu, bangsa itu duduk untuk makan dan minum, dan bangkit untuk bersenang-senang. ");
INSERT INTO indayt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lalu, TUHAN berfirman kepada Musa, “Pergilah, turunlah, sebab bangsamu, yang kamu bawa keluar dari tanah Mesir telah merusak diri mereka sendiri. ");
INSERT INTO indayt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mereka dengan cepat menyimpang dari jalan yang telah Kuperintahkan kepada mereka. Mereka telah membuat anak sapi tuangan bagi diri mereka sendiri, dan menyembahnya, dan mempersembahkan kurban kepadanya, lalu berkata, ‘Inilah ilahmu, hai Israel, yang telah membawamu keluar dari tanah Mesir.’” ");
INSERT INTO indayt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","TUHAN berfirman kepada Musa, “Aku telah melihat bangsa ini, dan lihatlah, mereka adalah bangsa yang tegar tengkuk. ");
INSERT INTO indayt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sebab itu, tinggalkan Aku sendiri supaya murka-Ku menyala atas mereka sehingga Aku dapat menghabisi mereka. Namun, Aku akan membuat suatu bangsa yang besar darimu.” ");
INSERT INTO indayt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Namun, Musa memohon kepada TUHAN, Allahnya, dan berkata, “Ya TUHAN, mengapa murkamu menyala atas umat-Mu yang telah Engkau bawa keluar dari tanah Mesir dengan kekuatan yang besar dan dengan tangan yang kuat? ");
INSERT INTO indayt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mengapa orang Mesir harus berkata begini, ‘Dengan niat jahat, Dia telah membawa mereka keluar untuk membunuh mereka di pegunungan dan untuk membinasakan mereka dari muka bumi’? Berbaliklah dari murkamu yang menyala-nyala dan ubahlah niat-Mu untuk mendatangkan malapetaka atas umat-Mu. ");
INSERT INTO indayt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ingatlah akan Abraham, Ishak, dan Israel, hamba-hamba-Mu, yang kepada mereka, Engkau telah bersumpah demi diri-Mu sendiri dan berkata kepada mereka, ‘Aku akan melipatgandakan keturunanmu seperti bintang di langit dan semua tanah yang telah Kukatakan akan Kuberikan kepada keturunanmu, dan mereka akan mewarisinya untuk selamanya.’” ");
INSERT INTO indayt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","TUHAN pun mengubah niat-Nya mengenai malapateka yang telah difirmankan-Nya terhadap umat-Nya. ");
INSERT INTO indayt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa pun berbalik dan turun dari gunung dengan dua loh batu kesaksian di tangannya. Loh-loh batu itu dibubuhi tulisan pada dua sisinya; tertera di sisi satu dan sisi yang lain. ");
INSERT INTO indayt_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Allah sendiri yang membuat loh batu itu dan tulisan itu adalah tulisan Allah, terukir pada loh-loh batu itu. ");
INSERT INTO indayt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ketika Yosua mendengar suara bangsa itu selagi mereka bersorak-sorak, dia berkata kepada Musa, “Ada suara perang di perkemahan!” ");
INSERT INTO indayt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Namun, Musa menjawab, “Itu bukan suara sorak kemenangan atau suara tangis kekalahan, melainkan suara nyanyian, itu yang kudengar.” ");
INSERT INTO indayt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ketika Musa mendekati perkemahan dan melihat anak sapi itu serta orang yang menari-nari, kemarahan Musa menyala-nyala. Dia membanting loh-loh batu dari tangannya dan memecahkannya di kaki gunung. ");
INSERT INTO indayt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Dia mengambil anak sapi yang mereka buat itu dan membakarnya dalam api, menggilingnya sampai halus, dan mencampurnya ke dalam air. Setelah itu, dia menyuruh bangsa Israel meminumnya. ");
INSERT INTO indayt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Dia berkata kepada Harun, “Apa yang telah diperbuat bangsa ini kepadamu sehingga kamu mendatangkan dosa yang sangat besar kepada mereka?” ");
INSERT INTO indayt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun menjawab, “Jangan biarkan kemarahanmu menyala-nyala, Tuanku, kamu kenal bangsa ini, mereka memang jahat. ");
INSERT INTO indayt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Sebab, mereka berkata kepadaku, ‘Buatlah ilah bagi kami yang akan berjalan di depan kami, sebab Musa, orang yang telah membawa kami keluar dari tanah Mesir, kami tidak tahu yang terjadi atasnya.’ ");
INSERT INTO indayt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Jadi, aku berkata kepada mereka, ‘Siapa pun yang mempunyai emas, lepaskanlah itu.’ Lalu, mereka memberikannya kepadaku, dan aku melemparnya dalam api, dan anak sapi itu keluar dari situ.” ");
INSERT INTO indayt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ketika Musa melihat bahwa bangsa itu sudah di luar kendali, sebab Harun telah membiarkan mereka lepas kendali sehingga menjadi ejekan bagi musuh-musuh mereka, ");
INSERT INTO indayt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa berdiri di depan gerbang perkemahan itu dan berkata, “Siapa yang berada di sisi TUHAN? Datanglah kepadaku.” Lalu, semua keturunan Lewi berkumpul kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Dia pun berkata kepada mereka, “Inilah yang difirmankan TUHAN, Allah Israel, ‘Setiap orang, sandanglah pedang di pinggangnya dan pergilah dari gerbang ke gerbang di seluruh perkemahan, lalu bunuhlah saudaramu masing-masing, temanmu masing-masing, dan tetanggamu masing-masing.’” ");
INSERT INTO indayt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Keturunan Lewi melaksanakannya sesuai perkataan Musa sehingga sekitar tiga ribu orang dari bangsa itu mati pada hari itu. ");
INSERT INTO indayt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kemudian, Musa berkata, “Pada hari ini, kamu telah menahbiskan diri bagi TUHAN dengan tanganmu karena setiap orang telah melawan anaknya atau melawan saudaranya sehingga Dia dapat memberikan berkat atasmu pada hari ini.” ");
INSERT INTO indayt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Pada hari berikutnya, Musa berkata kepada bangsa itu, “Kamu berbuat dosa, dosa yang besar, dan sekarang aku akan pergi kepada TUHAN, mungkin aku dapat membuat pendamaian atas dosamu.” ");
INSERT INTO indayt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa pun kembali kepada TUHAN dan berkata, “Oh, bangsa ini telah melakukan dosa yang besar dan mereka telah membuat ilah emas untuk diri mereka sendiri. ");
INSERT INTO indayt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Namun, sekarang, jika Engkau berkenan, ampunilah dosa mereka; tetapi jika tidak, hapuslah namaku keluar dari kitab-Mu yang telah Engkau tulis.” ");
INSERT INTO indayt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Namun, TUHAN berfirman kepada Musa, “Siapa pun yang berdosa terhadap-Ku, Aku akan menghapusnya dari kitab-Ku. ");
INSERT INTO indayt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Jadi sekarang, pergilah, pimpinlah bangsa itu ke tempat yang telah Aku katakan kepadamu. Lihatlah, malaikat-Ku akan berjalan di depanmu. Meski demikian, pada hari penghakiman-Ku, aku akan menghukum mereka yang berbuat dosa.” ");
INSERT INTO indayt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kemudian, TUHAN menimpakan wabah atas bangsa itu karena mereka telah membuat anak sapi yang dibuat oleh Harun. ");
INSERT INTO indayt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kemudian, TUHAN berkata kepada Musa, “Berangkatlah, pergilah dari sini, kamu dan bangsa yang telah kaubawa dari tanah Mesir ke negeri yang telah Kusumpahkan kepada Abraham, Ishak, dan Yakub dengan berfirman, ‘Aku akan memberikannya kepada keturunanmu.’ ");
INSERT INTO indayt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aku akan mengutus malaikat berjalan di depanmu, dan Aku akan menghalau orang Kanaan, orang Amori, orang Het, orang Feris, orang Hewi, dan orang Yebus. ");
INSERT INTO indayt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pergilah ke negeri yang berlimpah susu dan madu, tetapi Aku tidak akan ada di tengah-tengah kamu karena kamu adalah bangsa yang tegar tengkuk supaya Aku tidak menghabisi kamu di jalan.” ");
INSERT INTO indayt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ketika umat Israel mendengar perkataan yang mengerikan itu, mereka pun berkabung dan tidak ada seorang pun yang memakai perhiasannya. ");
INSERT INTO indayt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Sebab, TUHAN berfirman kepada Musa, “Katakanlah kepada keturunan Israel, ‘Kamu adalah bangsa yang tegar tengkuk. Jika Aku pergi ke tengah-tengah kamu, Aku akan menghabisimu. Sekarang, tanggalkanlah perhiasan-perhiasanmu supaya Aku tahu yang harus Aku lakukan terhadapmu.’” ");
INSERT INTO indayt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Sejak itu, di Gunung Horeb, bangsa Israel menanggalkan perhiasan-perhiasan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Lalu, Musa mengambil sebuah tenda dan mendirikannya di luar perkemahan, jauh dari perkemahan, dan dia menyebutnya tenda pertemuan, dan setiap orang yang mencari TUHAN harus pergi ke tenda pertemuan yang berada di luar perkemahan itu. ");
INSERT INTO indayt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Setiap kali Musa pergi ke tenda itu, semua orang akan bangkit, dan masing-masing akan berdiri di pintu tendanya, dan mengikuti Musa dengan pandangan mereka sampai dia masuk ke dalam tenda itu. ");
INSERT INTO indayt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kapan pun Musa masuk ke dalam tenda itu, tiang awan akan turun dan berdiri di pintu tenda itu, dan TUHAN akan berbicara dengan Musa. ");
INSERT INTO indayt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ketika seluruh bangsa itu melihat tiang awan berdiri di pintu tenda itu, seluruh bangsa itu akan bangkit dan menyembah di pintu tendanya masing-masing. ");
INSERT INTO indayt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Demikianlah biasanya TUHAN berbicara kepada Musa, muka dengan muka, sebagaimana orang berbicara dengan temannya. Ketika Musa kembali lagi ke perkemahan, pelayannya yang masih muda, yaitu Yosua, anak Nun, tidak beranjak dari tenda itu. ");
INSERT INTO indayt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa berkata kepada TUHAN, “Memang, Engkau mengatakan kepadaku untuk membawa umat ini, tetapi Engkau tidak mengatakan siapa yang akan Kauutus bersamaku. Bahkan, Engkau berkata kepadaku, ‘Aku sangat mengenalmu dengan namamu, dan kamu juga mendapat kemurahan hati di mata-Ku.’ ");
INSERT INTO indayt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Oleh sebab itu, aku mohon kepada-Mu, jika aku mendapat kemurahan hati di mata-Mu, mohon tunjukkan jalan-jalan-Mu kepadaku supaya aku dapat mengenal-Mu agar Aku mendapatkan kemurahan hati di mata-Mu. Pertimbangkanlah juga, bangsa ini adalah umat-Mu.” ");
INSERT INTO indayt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","TUHAN menjawab, “Kehadiran-Ku akan menyertaimu dan Aku akan memberikan ketenteraman kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa pun berkata kepada-Nya, “Jika kehadiran-Mu tidak menyertai kami, jangan membawa kami dari sini. ");
INSERT INTO indayt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Sebab, bagaimana hal itu akan diketahui, bahwa aku telah mendapat kemurahan hati di mata-Mu, aku dan umat-Mu ini? Bukankah dengan penyertaan-Mu itu, kami, yaitu Aku dan umat-Mu, dapat dibedakan dari segala bangsa lain di permukaan bumi?” ");
INSERT INTO indayt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","TUHAN menjawab Musa, “Aku juga akan melakukan yang telah kamu minta sebab kamu mendapatkan kemurahan hati di mata-Ku dan Aku telah mengenalmu dengan namamu.” ");
INSERT INTO indayt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Lalu, Musa berkata, “Aku mohon kepada-Mu, tunjukkanlah kemuliaan-Mu.” ");
INSERT INTO indayt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Dia menjawab, “Aku akan membuat seluruh kebaikan-Ku lewat di depanmu dan akan menyerukan nama TUHAN di hadapanmu, dan Aku akan berbelas kasihan terhadap orang-orang yang kepadanya Aku akan berbelas kasihan, dan Aku akan menyatakan kasih kepada siapa pun yang kepadanya Aku akan mengasihinya.” ");
INSERT INTO indayt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","“Namun,” Dia berkata, “kamu tidak dapat melihat wajah-Ku karena tidak seorang pun dapat melihat-Ku dan hidup.” ");
INSERT INTO indayt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kemudian, TUHAN berfirman, “Lihat, ada satu tempat di dekat-Ku, dan kamu harus berdiri di sana, di atas gunung batu. ");
INSERT INTO indayt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ketika kemuliaan-Ku lewat, Aku akan menempatkanmu di celah di gunung batu itu dan akan menudungimu dengan tangan-Ku sampai Aku berlalu. ");
INSERT INTO indayt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kemudian, Aku akan menarik tangan-Ku, dan kamu akan melihat punggung-Ku. Namun, wajahku tidak dapat dilihat.” ");
INSERT INTO indayt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kemudian, TUHAN berkata kepada Musa, “Pahatlah dua loh batu seperti yang sebelumnya, dan Aku akan menulisi loh-loh batu itu dengan kata-kata yang terdapat pada loh-loh batu sebelumnya, yang telah kamu pecahkan. ");
INSERT INTO indayt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Bersiap-siaplah pada pagi hari dan naiklah ke Gunung Sinai pada pagi itu, lalu berdirilah kamu di puncak gunung itu. ");
INSERT INTO indayt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tidak boleh ada orang yang naik bersamamu, dan tidak ada orang yang boleh terlihat di seluruh gunung itu, dan jangan biarkan kawanan domba atau kawanan sapi memakan rumput di depan gunung itu.” ");
INSERT INTO indayt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Lalu, Musa memahat dua loh batu seperti yang sebelumnya dan Musa bangun pagi-pagi sekali untuk naik ke Gunung Sinai, seperti yang telah diperintahkan TUHAN kepadanya, dan dia membawa dua loh batu itu di tangannya. ");
INSERT INTO indayt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kemudian, TUHAN turun di awan dan berdiri dengan Musa di sana, dan menyerukan nama TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","TUHAN lewat di depannya dan berseru, “TUHAN, TUHAN Allah, yang penuh kasih dan murah hati, yang lambat marah dan berlimpah dalam kebaikan dan kebenaran, ");
INSERT INTO indayt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","yang memelihara kebaikan untuk beribu-ribu orang, mengampuni kesalahan, pelanggaran, dan dosa, yang sama sekali tidak membiarkan yang bersalah tidak dihukum, melainkan membalaskan kesalahan ayah atas anak-anaknya, atas cucu-cucunya, kepada keturunan yang ketiga dan yang keempat.” ");
INSERT INTO indayt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa segera menundukkan kepalanya sampai ke tanah dan menyembah. ");
INSERT INTO indayt_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Dia berkata, “Jika saat ini aku telah mendapat kemurahan di mata-Mu, oh TUHAN, aku mohon, biarlah TUHAN berjalan di tengah-tengah kami meskipun bangsa ini sangat tegar tengkuk, dan ampunilah kesalahan kami dan dosa kami, dan ambillah kami menjadi milik pusaka-Mu.” ");
INSERT INTO indayt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kemudian, Dia berfirman, “Lihat, Aku akan mengadakan suatu perjanjian: di hadapan seluruh bangsamu ini, Aku akan melakukan keajaiban-keajaiban yang belum pernah dilakukan di seluruh bumi dan di antara bangsa-bangsa. Semua bangsa, yang di tengah-tengah mereka kamu tinggal, akan melihat perbuatan TUHAN karena yang akan Aku lakukan adalah sesuatu yang mengerikan. ");
INSERT INTO indayt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Taatilah apa yang Kuperintahkan kepadamu pada hari ini. Lihatlah, Aku akan mengusir orang Amori, orang Kanaan, orang Het, orang Feris, orang Hewi, dan orang Yebus dari hadapanmu. ");
INSERT INTO indayt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Jagalah dirimu, jangan sampai kamu mengadakan perjanjian dengan penduduk negeri yang kamu datangi, atau hal itu akan menjadi perangkap di antara kamu. ");
INSERT INTO indayt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kamu harus merobohkan mazbah-mazbah mereka, menghancurkan tiang-tiang berhala mereka, dan menebang patung-patung Dewi Asyera mereka. ");
INSERT INTO indayt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kamu tidak boleh menyembah ilah lain sebab TUHAN, yang namanya Cemburu, adalah Allah yang cemburu. ");
INSERT INTO indayt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Jangan sampai kamu mengadakan perjanjian dengan penduduk negeri itu, sebab ketika mereka melacurkan diri di depan ilahnya dan berkurban untuk ilah mereka, mereka akan mengundangmu dan kamu pun akan makan dari kurban mereka. ");
INSERT INTO indayt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kemudian, kamu akan mengambil anak-anak perempuan mereka untuk anak-anak laki-lakimu, dan anak perempuan mereka akan melacurkan diri mereka dengan ilah-ilahnya sehingga membuat anak laki-lakimu juga melacurkan diri dengan ilah-ilah mereka. ");
INSERT INTO indayt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Kamu tidak boleh membuat ilah-ilah tuangan untuk dirimu. ");
INSERT INTO indayt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Kamu harus memelihara perayaan Roti Tidak Beragi. Selama tujuh hari kamu harus makan roti yang tidak beragi seperti yang telah Kuperintahkan kepadamu pada waktu yang telah ditetapkan, yaitu pada bulan Abib, sebab pada bulan Abib itulah kamu keluar dari Mesir. ");
INSERT INTO indayt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Setiap anak yang pertama kali membuka kandungan adalah milik-Ku, begitu pula dengan semua yang jantan dari ternakmu, yang pertama lahir dari sapi atau dombamu. ");
INSERT INTO indayt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Keledai yang pertama lahir harus kamu tebus dengan seekor domba, tetapi jika kamu tidak menebusnya, kamu harus mematahkan lehernya. Kamu harus menebus setiap anak laki-laki sulungmu. Tidak boleh ada seorang pun yang tampak di hadapan-Ku dengan tangan kosong. ");
INSERT INTO indayt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Kamu harus bekerja selama enam hari, tetapi pada hari ketujuh kamu harus beristirahat, sekalipun itu pada musim membajak atau musim panen, kamu harus beristirahat. ");
INSERT INTO indayt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Kamu harus merayakan hari raya Tujuh Minggu dengan hasil pertama dari panen gandum, dan juga perayaan Pengumpulan pada pergantian tahun. ");
INSERT INTO indayt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tiga kali setahun, semua laki-laki harus datang ke hadapan TUHAN Allah, Allah Israel. ");
INSERT INTO indayt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Sebab, Aku akan mengusir bangsa-bangsa di hadapanmu dan memperluas wilayahmu, dan tidak seorang pun akan mengingini tanahmu ketika kamu pergi untuk menghadap ke hadapan TUHAN, Allahmu, tiga kali setahun. ");
INSERT INTO indayt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Kamu tidak boleh mempersembahkan darah kurban sembelihan dengan roti yang beragi, dan kurban dari perayaan Pesakh tidak boleh tersisa sampai pagi. ");
INSERT INTO indayt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Bawalah hasil panen pertama yang terbaik dari tanahmu ke bait TUHAN, Allahmu. Kamu tidak boleh merebus anak kambing dalam susu induknya.” ");
INSERT INTO indayt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kemudian, TUHAN berfirman kepada Musa, “Tulislah segala perkataan ini, sebab berdasarkan perkataan inilah, Aku telah mengadakan perjanjian denganmu dan dengan Israel.” ");
INSERT INTO indayt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Dia berada di sana bersama TUHAN selama 40 hari dan 40 malam. Dia tidak makan roti atau minum air. Dia menulisi loh-loh batu itu dengan kata-kata perjanjian, yaitu Sepuluh Perintah. ");
INSERT INTO indayt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ketika Musa turun dari Gunung Sinai dengan dua loh batu kesaksian di tangannya, dia tidak menyadari bahwa kulit wajahnya bercahaya karena dia telah berbicara dengan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Harun dan seluruh orang Israel melihat Musa, dan lihatlah, kulit wajahnya bercahaya sehingga mereka takut untuk mendekatinya. ");
INSERT INTO indayt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Namun, Musa memanggil mereka. Kemudian, Harun dan seluruh pemimpin umat itu kembali kepadanya, dan Musa berbicara kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sesudah itu, seluruh keturunan Israel mendekatinya, dan kepada mereka, dia memberikan semua perintah yang telah TUHAN berikan kepadanya di Gunung Sinai. ");
INSERT INTO indayt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Setelah Musa selesai berbicara kepada mereka, Musa menudungi wajahnya dengan kerudung. ");
INSERT INTO indayt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Setiap kali Musa pergi ke hadapan TUHAN untuk berbicara dengan-Nya, dia membuka kerudungnya sampai dia keluar. Ketika keluar dan berbicara kepada keturunan Israel tentang apa yang telah diperintahkan kepadanya, ");
INSERT INTO indayt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","keturunan Israel dapat melihat wajah Musa, bahwa kulit wajah Musa itu bercahaya. Lalu, Musa akan menudungi wajahnya kembali sampai dia pergi lagi untuk berbicara dengan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa mengumpulkan seluruh jemaat keturunan Israel dan berkata kepada mereka, “Inilah firman yang telah TUHAN perintahkan untuk kamu lakukan: ");
INSERT INTO indayt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Enam hari lamanya pekerjaan harus dilakukan, tetapi hari yang ketujuh harus menjadi hari yang kudus, yaitu Sabat peristirahatan bagi TUHAN. Siapa pun yang melakukan pekerjaan pada saat itu harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kamu tidak boleh menyalakan api di seluruh kediamanmu pada hari Sabat.” ");
INSERT INTO indayt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa berkata kepada seluruh jemaat keturunan Israel, katanya, “Inilah yang telah TUHAN perintahkan, firman-Nya: ");
INSERT INTO indayt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Ambillah persembahan bagi TUHAN dari antara kamu. Siapa pun yang tergerak hatinya, biarlah dia membawa ini sebagai persembahan bagi TUHAN: emas, perak, dan perunggu; ");
INSERT INTO indayt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kain biru, kain ungu, kain kirmizi, dan linen halus, dan bulu kambing, ");
INSERT INTO indayt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kulit domba jantan yang dicelup merah, kulit lumba-lumba, dan kayu akasia, ");
INSERT INTO indayt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","minyak untuk pelita, rempah-rempah untuk minyak urapan dan untuk dupa yang harum, ");
INSERT INTO indayt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","dan permata krisopras, dan permata ukiran untuk efod dan untuk tutup dada.’ ");
INSERT INTO indayt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","‘Biarlah setiap orang yang ahli di antara kamu datang dan membuat semua yang telah TUHAN perintahkan, ");
INSERT INTO indayt_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","yaitu Tenda Suci: tendanya, tudungnya, pengait-pengaitnya, papan-papannya, palang-palangnya, tiang-tiangnya, dan alas-alasnya; ");
INSERT INTO indayt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","tabut dengan tongkat-tongkat pengusungnya, tutup pendamaian, dan tirai penudungnya; ");
INSERT INTO indayt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meja dan tongkat-tongkat pengusungnya, dan segala perlengkapannya, dan roti sajiannya; ");
INSERT INTO indayt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","juga kaki dian untuk penerangan, dan perlengkapannya, dan pelita-pelitanya, dengan minyak untuk penerangan; ");
INSERT INTO indayt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","dan mazbah dupa dengan tongkat pengusungnya, dan minyak urapan, dan dupa harum, dan tirai pintu di pintu Tenda Suci; ");
INSERT INTO indayt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","mazbah persembahan bakaran dengan jala-jala perunggunya, tongkat pengusungnya, dan segala perlengkapannya, bejana pembasuhan dengan alasnya; ");
INSERT INTO indayt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","tirai-tirai pelataran, tiang-tiangnya, dan alas-alasnya, dan tirai-tirai untuk gerbang pelataran; ");
INSERT INTO indayt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","patok-patok Tenda Suci, dan patok-patok pelataran, dan tali-talinya; ");
INSERT INTO indayt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","dan pakaian-pakaian yang dipintal untuk melayani di tempat kudus, pakaian kudus untuk Imam Harun dan pakaian anak-anaknya untuk melayani sebagai imam.’” ");
INSERT INTO indayt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kemudian, seluruh jemaat keturunan Israel pergi dari hadapan Musa. ");
INSERT INTO indayt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Sesudah itu, setiap orang yang digerakkan oleh hatinya dan setiap orang yang digerakkan oleh rohnya pun datang serta membawa persembahan bagi TUHAN untuk pengerjaan tenda pertemuan dan untuk segala pelayanannya, dan untuk pakaian-pakaian kudus itu. ");
INSERT INTO indayt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Mereka pun datang, laki-laki maupun perempuan, setiap orang yang rela hatinya, membawa bros, dan anting-anting, dan cincin meterai, dan gelang, dan segala macam barang dari emas. Demikianlah setiap orang yang membawa persembahan, mempersembahkan emas untuk TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Setiap orang yang mempunyai kain biru, dan kain ungu, dan kain kirmizi, dan kain linen halus, dan bulu kambing, dan kulit domba jantan yang dicelup merah, dan kulit lumba-lumba, datang membawanya. ");
INSERT INTO indayt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Setiap orang yang dapat memberikan persembahan dari perak atau perunggu membawanya sebagai persembahan bagi TUHAN, dan setiap orang yang memiliki kayu akasia membawanya untuk berbagai pekerjaan pelayanan itu. ");
INSERT INTO indayt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Setiap perempuan yang ahli, memintal dengan tangannya dan mereka membawa yang mereka pintal itu, yaitu kain biru, kain ungu, kain kirmizi, dan kain linen halus. ");
INSERT INTO indayt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Semua perempuan yang digerakkan oleh hatinya, memintal bulu kambing dengan keahliannya. ");
INSERT INTO indayt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Para pemimpin membawa permata krisopras dan permata-permata ukiran untuk baju efod dan untuk tutup dada, ");
INSERT INTO indayt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dan rempah-rempah, dan minyak untuk pelita, dan untuk minyak urapan, dan untuk dupa yang harum. ");
INSERT INTO indayt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Keturunan Israel membawa persembahan sukarela kepada TUHAN, semua laki-laki dan perempuan yang digerakkan oleh hatinya untuk membawa segala keperluan pekerjaan yang telah diperintahkan TUHAN untuk dilaksanakan melalui Musa, mereka membawanya sebagai persembahan sukarela kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kemudian, Musa berkata kepada bangsa Israel, “Lihatlah, TUHAN telah memanggil nama Bezaleel, anak Uri, anak Hur, dari suku Yehuda, ");
INSERT INTO indayt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","dan Dia memenuhinya dengan Roh Allah, dengan hikmat, dan dengan pengertian, dan dengan pengetahuan, dan dengan segala macam pekerjaan tangan, ");
INSERT INTO indayt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","untuk membuat rancangan pengerjaan emas, dan perak, dan perunggu, ");
INSERT INTO indayt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","untuk memotong batu-batu permata untuk diukir, dan untuk mengukir kayu, untuk membuat segala macam pekerjaan rancangan itu. ");
INSERT INTO indayt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","TUHAN juga telah menaruh dalam hatinya supaya dia dapat mengajar, baik dia maupun Aholiab, anak Ahisamakh, dari suku Dan. ");
INSERT INTO indayt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Dia memenuhi mereka dengan keahlian untuk mengerjakan segala macam pekerjaan pemahat, perancang, dan pemintal kain biru, kain ungu, kain kirmizi, dan kain linen halus, dan penenun, yang melakukan setiap pekerjaan dan yang merancang segala sesuatunya.” ");
INSERT INTO indayt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bezaleel, Aholiab, dan setiap orang yang ahli, yang telah dikaruniai TUHAN dengan keahlian dan pengertian untuk mengetahui bagaimana mengerjakan segala pekerjaan tempat kudus harus bekerja berdasarkan segala sesuatu yang telah diperintahkan Allah.” ");
INSERT INTO indayt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Lalu, Musa memanggil Bezaleel, Aholiab, dan semua orang yang ahli, yang telah dikaruniai dengan keahlian dari TUHAN, dan setiap orang yang hatinya menggerakkan dia untuk datang melakukan pekerjaan itu. ");
INSERT INTO indayt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Dari Musa, mereka menerima segala persembahan itu, yang dibawa oleh keturunan Israel untuk pekerjaan pelayanan tempat kudus. Mereka pun masih terus membawa persembahan sukarela setiap pagi. ");
INSERT INTO indayt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Lalu, semua orang yang ahli, yang melakukan setiap pekerjaan tempat kudus itu datang, masing-masing menurut tugas yang sedang mereka kerjakan, ");
INSERT INTO indayt_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","dan berkata kepada Musa, “Bangsa ini membawa lebih banyak dari yang dibutuhkan untuk melakukan pekerjaan yang telah TUHAN perintahkan kepada kita.” ");
INSERT INTO indayt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Oleh sebab itu, Musa memerintahkan dan mengumumkan ke seluruh perkemahan, katanya, “Jangan ada lagi laki-laki atau perempuan yang membuat apa pun sebagai persembahan untuk tempat kudus.” Demikianlah bangsa itu dicegah dari memberikan persembahan, ");
INSERT INTO indayt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","sebab bahan-bahan yang mereka miliki sudah cukup untuk melaksanakan segala pekerjaan itu, bahkan berlebih. ");
INSERT INTO indayt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Lalu, semua orang yang ahli di antara orang-orang yang mengerjakan pekerjaan itu membuat Tenda Suci dengan sepuluh tirai dari linen halus yang dipintal, dari kain biru, dan kain ungu, dan kain kirmizi, dengan kerub-kerub yang dikerjakan oleh orang yang ahli. ");
INSERT INTO indayt_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Panjang setiap tirai harus 28 hasta, dan lebar setiap tirai harus 4 hasta, dan ukuran semua tirai harus sama. ");
INSERT INTO indayt_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Dia menyambung lima tirai satu sama lain, dan menyambung juga lima tirai yang lainnya satu sama lain. ");
INSERT INTO indayt_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Dia membuat lubang pengancing dari kain biru di tepi tirai yang terluar dari kelompok tirai yang pertama. Dia juga membuat hal yang sama di tepi tirai terluar dari kelompok tirai yang kedua. ");
INSERT INTO indayt_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Dia membuat lima puluh lubang pada tirai yang pertama dan dia membuat lima puluh lubang di tepi tirai dari rangkaian yang kedua. Lubang-lubang itu saling berhadapan. ");
INSERT INTO indayt_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Lalu, dia membuat lima puluh kaitan emas dan menyambungkan tirai-tirai itu satu sama lain dengan kaitan-kaitan itu sehingga Tenda Suci itu menjadi satu. ");
INSERT INTO indayt_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Kemudian, dia membuat tirai dari bulu kambing sebagai tudung Tenda Suci, dan dia membuatnya sebanyak sebelas tirai. ");
INSERT INTO indayt_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Panjang masing-masing tirai harus 30 hasta dan lebar masing-masing tirai harus 4 hasta. Sebelas tirai itu harus sama ukurannya. ");
INSERT INTO indayt_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Dia menyambung lima tirai secara tersendiri dan enam tirai secara tersendiri. ");
INSERT INTO indayt_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Kemudian, dia membuat lima puluh lubang di tepi tirai yang paling luar dari rangkaian yang pertama dan lima puluh lubang di tepi tirai dari rangkaian yang kedua. ");
INSERT INTO indayt_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Dia membuat lima puluh kaitan perunggu untuk menyambung tirai-tirai itu agar menjadi satu kesatuan. ");
INSERT INTO indayt_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Lalu, dia membuat tudung tenda dari kulit domba jantan yang dicelup merah dan tudung dari kulit lumba-lumba pada bagian atasnya. ");
INSERT INTO indayt_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Lalu, dia membuat papan-papan Tenda Suci itu dari kayu akasia yang tegak lurus. ");
INSERT INTO indayt_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Panjang setiap papan harus 10 hasta dan lebar setiap papan harus 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Pada setiap papan ada dua pasak untuk menyatukan yang satu dengan yang lainnya, demikianlah dia membuat semua papan untuk Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Dia membuat papan-papan untuk Tenda Suci, yaitu dua puluh papan untuk sisi sebelah selatan ke arah selatan, ");
INSERT INTO indayt_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","dan dia membuat empat puluh alas perak di bawah dua puluh papan itu, yaitu dua alas di bawah satu papan untuk dua pasaknya, dan dua alas di bawah papan yang lain untuk dua pasaknya. ");
INSERT INTO indayt_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kemudian, untuk sisi kedua Tenda Suci, yaitu untuk sebelah utara, dia membuat dua puluh papan, ");
INSERT INTO indayt_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","dengan empat puluh alas peraknya, dua alas di bawah satu papan, dan dua alas di bawah papan yang lainnya. ");
INSERT INTO indayt_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Untuk dua sisi Tenda Suci di sebelah barat, dia membuat enam papan. ");
INSERT INTO indayt_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Dia membuat dua papan untuk dua sudut Tenda Suci di bagian belakang. ");
INSERT INTO indayt_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Papan-papan itu harus disambung pada bagian bawahnya, dan harus disambung sampai ke atas sampai pada gelang yang pertama. Demikianlah harus terjadi bagi keduanya, mereka akan membentuk dua sudut. ");
INSERT INTO indayt_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Jadi, ada delapan papan dengan enam belas alas peraknya, dua alas di bawah masing-masing papan. ");
INSERT INTO indayt_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Kemudian, dia membuat palang-palang dari kayu akasia, lima untuk papan-papan pada satu sisi Tenda Suci, ");
INSERT INTO indayt_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","dan lima palang untuk papan pada sisi lain Tenda Suci, dan lima palang untuk papan-papan Tenda Suci bagian belakang di sisi sebelah barat. ");
INSERT INTO indayt_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Mereka membuat palang tengah yang melintang di tengah-tengah papan-papan itu dari ujung ke ujung. ");
INSERT INTO indayt_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Lalu, dia melapisi papan-papan itu dengan emas dan membuat gelang-gelangnya dari emas untuk memasang palang-palang itu, dan melapisi palang-palangnya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Kemudian, dia membuat tirai dari kain biru, dan kain ungu, dan kain kirmizi, dan kain linen halus yang disulam dengan kerub-kerub oleh orang yang ahli. ");
INSERT INTO indayt_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Untuk tirai itu, dia membuat empat tiang dari kayu akasia dan melapisinya dengan emas, dengan kaitan-kaitan emasnya, dan untuk tiang-tiangnya, dia menuang empat alas dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kemudian, dia membuat tirai untuk pintu masuk ke tenda itu dari kain biru, kain ungu, dan kain kirmizi, dan kain linen halus yang dipintal dengan sulaman. ");
INSERT INTO indayt_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Untuk tirai ini, dia membuat lima tiang dari kayu akasia dan melapisi ujung-ujung dan penyambung-penyambungnya dengan emas, tetapi lima alasnya dibuat dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleel membuat tabut dari kayu akasia yang panjangnya 2,5 hasta dan lebarnya 1,5 hasta, dan tingginya 1,5 hasta, ");
INSERT INTO indayt_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","dan dia melapisinya dengan emas murni di dalam dan di luarnya, dan membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Dia menuang empat gelang emas untuknya dan memasangnya pada empat kakinya, yaitu dua gelang di sisi yang satu dan dua gelang di sisi yang satunya. ");
INSERT INTO indayt_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kemudian, dia membuat pengusung dari kayu akasia dan melapisinya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Dia memasukkan pengusung-pengusung itu ke dalam gelang di setiap sisi tabut untuk mengusung tabut itu. ");
INSERT INTO indayt_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Lalu, dia membuat tutup pendamaian dari emas murni yang panjangnya 2,5 hasta dan lebarnya 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Dia membuat dua kerub emas yang dibuatnya dari emas tempaan untuk kedua ujung tutup pendamaian, ");
INSERT INTO indayt_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","satu kerub di ujung sebelah sini dan kerub yang lain di ujung sebelah sana. Dia membuat kerub-kerub itu seiras dengan tutup pendamaian pada dua ujungnya. ");
INSERT INTO indayt_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kerub-kerub itu mengembangkan dua sayapnya ke atas untuk menundungi tutup pendamaian itu dengan sayapnya dan wajahnya harus saling berhadapan. Kerub-kerub itu harus menghadap tutup pendamaian. ");
INSERT INTO indayt_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Kemudian, Bezaleel membuat meja dari kayu akasia yang panjangnya 2 hasta, lebarnya 1 hasta, dan tingginya 1,5 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Dia melapisinya dengan emas murni dan membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kemudian, dia membuat pinggiran sebesar telapak tangan di sekelilingnya dan membuat bingkai emas untuk pinggiran di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Dia menuang empat gelang emas untuk itu dan memasang gelang-gelang itu pada empat sudut, yaitu pada keempat kakinya. ");
INSERT INTO indayt_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gelang-gelang itu harus dipasang di dekat pinggiran meja, sebagai tempat tongkat-tongkat pengusung untuk mengusung meja itu. ");
INSERT INTO indayt_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Dia membuat pengusung-pengusung dari kayu akasia untuk mengangkut meja itu dan melapisinya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Dia membuat semua perlengkapan meja itu, yaitu piring-piringnya, sendok-sendoknya, mangkuk-mangkuknya, dan kendi dari emas murni. Mangkuk dan kendi dipakai untuk menuang persembahan curahan. ");
INSERT INTO indayt_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Kemudian, Bezaleel membuat kaki dian dari emas murni dan kaki dian itu harus dibuat dari emas tempaan, baik alasnya maupun cabang-cabangnya, mangkuk-mangkuknya, kelopak-kelopaknya, dan bunga-bunganya harus dibuat seiras dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kaki dian itu mempunyai enam cabang yang menonjol dari sisi-sisinya, tiga cabang kaki dian dari sisi yang satu dan tiga cabang kaki dian dari sisi yang lain, ");
INSERT INTO indayt_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","dan tiga mangkuk yang dibuat seperti bunga badam dalam setiap cabang, masing-masing dengan satu kelopak dan satu bunga. Jadi, ada enam cabang yang menonjol dari kaki dian itu. ");
INSERT INTO indayt_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Pada kaki dian itu sendiri terdapat empat mangkuk yang dibentuk seperti bunga badam dengan kelopak dan bunganya, ");
INSERT INTO indayt_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","dan ada satu kelopak di bawah sepasang cabang yang pertama dan satu kelopak lagi di bawah sepasang cabang yang kedua yang menonjol dari kaki dian itu, dan satu kelopak di bawah sepasang cabang yang ketiga yang menonjol darinya, sesuai dengan enam cabang yang menonjol dari kaki dian itu. ");
INSERT INTO indayt_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Semua kelopak dan cabangnya harus seiras dengannya, keseluruhan bagian itu harus terbuat dari sebongkah emas murni tempaan. ");
INSERT INTO indayt_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bezaleel membuat tujuh pelita dengan penyapit sumbu dan perbaraannya dari emas murni. ");
INSERT INTO indayt_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Dia menggunakan 1 talenta emas murni untuk membuat kaki dian itu dengan segala perlengkapannya. ");
INSERT INTO indayt_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kemudian, Bezaleel membuat mazbah pembakaran dupa yang dibuat dari kayu akasia yang panjangnya 1 hasta, lebarnya 1 hasta, dan bentuknya persegi, dan tingginya 2 hasta. Tanduk-tanduknya harus seiras dengannya. ");
INSERT INTO indayt_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Dia melapisinya dengan emas murni pada bagian atasnya, dan sisi-sisi di sekelilingnya, dan tanduk-tanduknya, lalu dia membuat bingkai emas di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Dia membuat dua gelang emas di bawah bingkainya pada kedua sisinya, sebagai tempat pengusung yang dengannya mazbah itu dapat diangkut. ");
INSERT INTO indayt_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Dia membuat tongkat-tongkat pengusung-pengusung itu dari kayu akasia dan melapisinya dengan emas. ");
INSERT INTO indayt_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Dia juga membuat minyak urapan kudus dan dupa murni yang harum buatan seorang ahli wewangian. ");
INSERT INTO indayt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleel membuat mazbah persembahan bakaran dari kayu akasia yang panjangnya 5 hasta dan lebarnya 5 hasta, bentuknya persegi dengan tinggi 3 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Dia membuat tanduk-tanduk untuk empat sudutnya dan tanduk-tanduk dibuat seiras dengannya, lalu dia melapisinya dengan perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Dia membuat segala perkakas untuk mazbah itu, yaitu belanga-belanganya, sekop-sekopnya, bokor-bokornya, garpu-garpunya, dan perbaraannya; dia membuat segala perkakas itu dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kemudian, dia membuat terali dari jala-jala perunggu di bawah pinggiran mazbah dari sebelah bawah sampai ke tengah-tengah mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Kemudian, dia menuang empat gelang untuk empat sudut terali perunggu itu sebagai tempat pengusung-pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Dia membuat pengusung-pengusung itu dari kayu akasia dan melapisinya dengan perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Dia memasukkan pengusung-pengusung itu ke dalam gelang-gelang yang ada di sisi mazbah yang dengannya mazbah itu dapat diusung. Dia membuat mazbah itu dari papan yang berongga. ");
INSERT INTO indayt_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Dia membuat bejana perunggu. Alasnya juga dibuat dari perunggu yang diperoleh dari cermin-cermin para perempuan yang melayani di pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Selanjutnya, Bezaleel membuat pelataran. Di sisi selatan, tirai pelataran itu terbuat dari linen halus yang dipintal yang panjangnya 100 hasta, ");
INSERT INTO indayt_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","dengan dua puluh tiang dan dua puluh alasnya yang terbuat dari perunggu. Kaitan tiang-tiang itu dan penyambungnya terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tirai di sisi utara panjangnya 100 hasta, dengan dua puluh tiang dan dua puluh alasnya yang terbuat dari perunggu. Pada sisi utara, juga terdapat tirai sepanjang 100 hasta, dua puluh tiang penyangga tirai, dan dua puluh alasnya yang terbuat dari perunggu. Kaitan tiang-tiang itu dan penyambungnya terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Di sisi barat, terdapat tirai berukuran 50 hasta dengan sepuluh tiang dan sepuluh alasnya. Kaitan tiang-tiang itu dan penyambungnya terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Untuk sisi timur, ukurannya juga 50 hasta. ");
INSERT INTO indayt_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Tirai-tirai untuk satu sisi gerbang berukuran 15 hasta dengan tiga tiang dan tiga alasnya. ");
INSERT INTO indayt_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Begitu pula untuk sisi yang satunya. Pada dua sisi gerbang pelataran itu terdapat tirai berukuran 15 hasta dengan tiga tiang dan tiga alasnya. ");
INSERT INTO indayt_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Semua tirai di sekeliling pelataran terbuat dari linen halus yang dipintal. ");
INSERT INTO indayt_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Alas tiang-tiangnya terbuat dari perunggu, kaitan tiang-tiang dan penyambung-penyambungnya terbuat dari perak, dan lapisan bagian atasnya terbuat dari perak. Semua tiang pelataran itu tersambung dengan perak. ");
INSERT INTO indayt_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Tirai gerbang untuk pelataran itu adalah karya seorang penyulam yang terbuat dari kain biru, kain ungu, kain kirmizi, dan linen halus yang dipintal. Panjangnya adalah 20 hasta dan lebarnya adalah 5 hasta, sama dengan tirai-tirai pelataran. ");
INSERT INTO indayt_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Empat tiang dan empat alasnya terbuat dari perunggu, kaitan tiang-tiangnya dari perak, dan lapisan bagian atasnya maupun penyambung-penyambungnya terbuat dari perak. ");
INSERT INTO indayt_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Semua patok untuk Tenda Suci dan untuk pelataran di sekelilingnya terbuat dari perunggu. ");
INSERT INTO indayt_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Inilah jumlah segala sesuatu untuk Tenda Suci, yaitu Tenda Kesaksian, yang dihitung berdasarkan perintah Musa sebagai pelayanan dari orang Lewi, di bawah pimpinan Itamar, anak Imam Harun. ");
INSERT INTO indayt_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleel anak Uri, anak Hur, dari suku Yehuda mengerjakan segala sesuatu yang diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bersama dengan dia ada Aholiab, anak Ahisamakh, dari suku Dan, orang yang ahli dalam mengukir, dan merancang, dan menyulam kain biru, kain ungu, dan kain kirmizi, dan linen halus. ");
INSERT INTO indayt_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Seluruh jumlah emas yang digunakan dalam pekerjaan itu, berkaitan dengan segala pekerjaan tempat kudus itu, termasuk emas persembahan adalah 29 talenta dan 730 syikal, menurut ukuran syikal tempat kudus. ");
INSERT INTO indayt_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Jumlah perak dari jemaat yang terhitung adalah 100 talenta dan 1.775 syikal, menurut ukuran syikal tempat kudus, ");
INSERT INTO indayt_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","satu beka per orang, yaitu setengah syikal, menurut syikal tempat kudus, untuk setiap orang yang terhitung, mulai dari yang berumur 20 tahun ke atas, yaitu 603.550 orang. ");
INSERT INTO indayt_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Seratus talenta perak digunakan untuk menuang alas-alas tempat kudus dan alas-alas tirai; seratus alas dari seratus talenta, satu talenta untuk satu alas. ");
INSERT INTO indayt_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Dari 1.775 syikal perak, dia membuat kaitan-kaitan tiang, dan melapisi bagian atasnya, lalu menyambungkannya. ");
INSERT INTO indayt_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Jumlah persembahan unjukan yang berupa perunggu adalah 70 talenta dan 2.400 syikal. ");
INSERT INTO indayt_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Dengan itu, dia membuat alas untuk pintu tenda pertemuan, mazbah perunggu, dan jala-jala perunggunya, dan segala perkakas mazbah, ");
INSERT INTO indayt_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dan alas-alas untuk pelataran di sekelilingnya, dan alas untuk gerbang pelataran, termasuk semua patok Tenda Suci dan patok-patok di sekeliling pelataran. ");
INSERT INTO indayt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Dari kain biru, dan kain ungu, dan kain kirmizi, mereka membuat pakaian yang dipintal untuk melakukan pelayanan di tempat kudus, dan membuat pakaian kudus untuk Harun, sebagaimana yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezaleel membuat baju efod dari emas, dan dari kain biru, kain ungu, kain kirmizi, dan linen halus yang dipintal. ");
INSERT INTO indayt_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Kemudian, mereka menempa emas menjadi lembaran-lembaran emas dan memotong-motongnya menjadi benang untuk disulamkan pada kain biru, dan kain ungu, dan kain kirmizi, dan linen halus, buatan ahli tenun. ");
INSERT INTO indayt_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Mereka membuat penutup bahu untuk baju efod itu dan menyambungnya menjadi satu dengan menyatukannya pada dua ujungnya. ");
INSERT INTO indayt_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ikat pinggang yang ditenun dengan terampil, yang terdapat padanya, dibuat dari bahan yang sama menurut pengerjaannya, yaitu dari emas, dan kain biru, dan kain ungu, dan kain kirmizi, dan linen halus yang dipintal, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mereka mengerjakan permata-permata krisopras yang dililit dengan ikatan emas, lalu diukir seperti ukiran meterai dengan nama-nama anak Israel. ");
INSERT INTO indayt_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mereka menempatkannya pada penutup bahu efod sebagai permata peringatan akan anak-anak Israel, seperti yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kemudian, Bezaleel membuat tutup dada, buatan seorang ahli, seperti pengerjaan untuk baju efod: dari emas, kain biru, kain ungu, kain kirmizi, dan linen halus yang dipintal. ");
INSERT INTO indayt_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bentuknya persegi, mereka membuat tutup dada itu dilipat dua, sejengkal panjangnya dan sejengkal lebarnya. ");
INSERT INTO indayt_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Lalu, mereka memasang empat baris batu permata pada baju efod itu. Baris pertama: permata yaspis merah, krisolit, dan malakit, itulah baris pertama. ");
INSERT INTO indayt_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Baris kedua: permata batu darah, lazurit, dan yaspis hijau. ");
INSERT INTO indayt_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Baris ketiga: permata ambar, akik, dan kecubung. ");
INSERT INTO indayt_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Baris keempat: permata pirus, krisopras, dan nefrit. Semua dililit dengan ikatan emas ketika mereka memasangnya. ");
INSERT INTO indayt_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Batu-batu permata itu sesuai dengan nama anak-anak Israel, yaitu dua belas, yang diukir seperti ukiran meterai, masing-masing dengan namanya untuk dua belas suku. ");
INSERT INTO indayt_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pada tutup dada itu, mereka membuat rantai dari emas murni yang dijalin seperti tali. ");
INSERT INTO indayt_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Mereka membuat dua sulaman emas dan dua gelang emas, lalu memasang dua gelang itu pada kedua ujung tutup dada. ");
INSERT INTO indayt_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mereka memasukkan dua rantai emas itu ke dalam dua gelang yang ada pada kedua ujung tutup dada. ");
INSERT INTO indayt_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Lalu, dua ujung dari dua rantai emas itu mereka sambungkan dengan dua sulaman emas dan dipasang pada penutup bahu baju efod di bagian depannya. ");
INSERT INTO indayt_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Setelah itu, mereka membuat dua gelang emas dan memasangnya pada dua ujung tutup dada, yaitu di pinggirannya, yang ada di sisi sebelah dalam baju efod. ");
INSERT INTO indayt_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Lalu, mereka membuat lagi dua gelang emas dan menempatkannya di bawah penutup bahu baju efod bagian depan, di dekat sambungannya, di atas ikat pinggang baju efod. ");
INSERT INTO indayt_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Mereka mengikat tutup dada itu dari gelang-gelangnya ke gelang-gelang baju efod dengan tali biru agar berada di ikat pinggang baju efod dan agar tutup dada itu tidak lepas dari baju efod, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezaleel membuat jubah efod, karya seorang ahli tenun, semuanya dari kain biru, ");
INSERT INTO indayt_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","dan ada satu lubang di tengah-tengah jubah itu seperti lubang untuk baju zirah dengan pinggiran di sekelilingnya agar tidak mudah koyak. ");
INSERT INTO indayt_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mereka membuat hiasan delima dari kain biru, kain ungu, dan kain kirmizi, dan dari linen halus yang dipintal untuk tepi bawah jubah itu. ");
INSERT INTO indayt_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Mereka juga membuat beberapa kerincing dari emas murni dan memasang kerincing-kerincing itu di antara hiasan delima di sekeliling tepi jubah itu, ");
INSERT INTO indayt_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","satu kerincing, satu delima, satu kerincing, satu delima, di sekeliling tepi bawah jubah yang dipakai untuk melayani, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Mereka juga membuat baju panjang dari linen halus, karya seorang ahli tenun, untuk Harun dan anak-anaknya, ");
INSERT INTO indayt_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","dan serban dari linen halus, dan ikat-ikat kepala dari linen halus, dan pakaian dalam dari linen halus yang dipintal, ");
INSERT INTO indayt_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ikat-ikat pinggang dari linen halus, dan dari kain biru, kain ungu, dan kain kirmizi buatan seorang penenun, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Mereka membuat hiasan mahkota kudus dari emas murni dan menulis tulisan di atasnya, seperti ukiran meterai, “Kudus bagi TUHAN”. ");
INSERT INTO indayt_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mereka memasang seutas tali biru pada hiasan itu untuk mengikatnya dengan serban di bagian atas, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Demikianlah semua pengerjaan Tenda Suci, tenda pertemuan itu, selesai. Seluruh keturunan Israel melaksanakannya sesuai dengan semua yang telah TUHAN perintahkan kepada Musa, demikianlah mereka melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Mereka membawa Tenda Suci itu kepada Musa, yaitu tenda dengan segala perlengkapannya: kait-kaitnya, papan-papannya, palang-palangnya, dan alas-alasnya, ");
INSERT INTO indayt_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","dan tudung dari kulit domba jantan yang dicelup merah, tudung dari kulit lumba-lumba, dan tirai untuk tudung itu, ");
INSERT INTO indayt_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","tabut kesaksian dan tongkat-tongkat pengusungnya, dan tutup pendamaian, ");
INSERT INTO indayt_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meja dengan segala perlengkapannya dan roti sajian, ");
INSERT INTO indayt_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kaki dian dari emas murni dengan pelita-pelitanya, pelita yang diatur sesuai susunannya, dan segala perlengkapannya, dan minyak untuk penerangan, ");
INSERT INTO indayt_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","dan mazbah emas, dan minyak urapan, dan dupa yang harum, dan tirai untuk pintu Tenda Suci, ");
INSERT INTO indayt_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mazbah perunggu dan jala-jala perunggunya, kayu-kayu pengusungnya dan segala perlengkapannya, bejana dan alasnya, ");
INSERT INTO indayt_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","tirai-tirai untuk pelataran, tiang-tiang dan alas-alasnya, tirai untuk gerbang pelataran, tali-talinya, patok-patoknya, dan segala perlengkapan untuk pelayanan Tenda Suci, untuk tenda pertemuan itu, ");
INSERT INTO indayt_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","pakaian yang dipintal untuk melayani di tempat kudus, pakaian kudus untuk Imam Harun dan untuk anak-anaknya saat melayani sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Keturunan Israel melaksanakan segala pekerjaan itu sesuai dengan yang telah TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa memeriksa segala pekerjaan itu, dan lihatlah, mereka melakukannya sesuai dengan yang telah TUHAN perintahkan, demikianlah mereka melaksanakannya, lalu Musa memberkati mereka. ");
INSERT INTO indayt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kemudian, TUHAN berkata kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Pada hari pertama dalam bulan pertama, kamu harus mendirikan Tenda Suci, tenda pertemuan itu. ");
INSERT INTO indayt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kamu harus menempatkan tabut kesaksian itu di sana dan tudungilah tabut itu dengan tirai. ");
INSERT INTO indayt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kamu harus membawa masuk meja itu dan mengatur segala sesuatu yang harus diatur di atasnya, dan kamu juga harus membawa masuk kaki dian itu beserta pelita-pelitanya. ");
INSERT INTO indayt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kamu harus menempatkan mazbah emas untuk dupa itu di depan tabut kesaksian, lalu pasanglah tirai di pintu ke Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kamu harus meletakkan mazbah persembahan bakaran di depan pintu Tenda Suci, tenda pertemuan itu, ");
INSERT INTO indayt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","dan tempatkanlah bejana itu di antara tenda pertemuan dan mazbah, lalu isilah bejana itu dengan air. ");
INSERT INTO indayt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kamu harus membuat pelataran di sekelilingnya dan pasanglah tirai di gerbang pelataran itu. ");
INSERT INTO indayt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kemudian, kamu harus mengambil minyak urapan dan mengurapi Tenda Suci beserta segala sesuatu di dalamnya, dan kuduskanlah itu dengan segala perkakasnya sehingga semua itu menjadi kudus. ");
INSERT INTO indayt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kamu juga harus mengurapi mazbah persembahan bakaran dengan segala perkakasnya, dan kuduskanlah mazbah itu sehingga mazbah itu menjadi mahakudus. ");
INSERT INTO indayt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kamu juga harus mengurapi bejana itu dengan alasnya dan menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Kemudian, kamu harus membawa Harun dan anak-anaknya ke pintu tenda pertemuan dan basuhlah mereka dengan air. ");
INSERT INTO indayt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kamu harus mengenakan pakaian kudus kepada Harun dan mengurapinya, dan menguduskannya, agar dia dapat melayani-Ku sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Lalu, kamu harus membawa anak-anaknya dan mengenakan jubah panjang kepada mereka, ");
INSERT INTO indayt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","dan urapilah mereka, seperti kamu telah mengurapi ayahnya sebagai seorang imam, supaya mereka dapat melayani-Ku sebagai imam. Pengurapan atas mereka ini sungguh-sungguh akan menjadi keimaman yang kekal turun-temurun.” ");
INSERT INTO indayt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa melaksanakannya sesuai dengan segala yang telah TUHAN perintahkan kepadanya, demikianlah dia melaksanakannya. ");
INSERT INTO indayt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Pada bulan pertama dalam tahun kedua, yaitu pada hari pertama bulan itu, Tenda Suci itu pun didirikan. ");
INSERT INTO indayt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa mendirikan Tenda Suci: dia memasang alas-alasnya, dan memasang papan-papannya, memasang palang-palangnya, dan mendirikan tiang-tiangnya. ");
INSERT INTO indayt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Sesudah itu, dia membentangkan tenda bagian luar di atas Tenda Suci dan memasang tudung di atasnya, sebagaimana yang telah diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dia pun mengambil kesaksian itu dan meletakkannya di dalam tabut, dan memasang kayu-kayu pengusung di tabut itu, lalu memasang tutup pendamaian di atas tabut itu. ");
INSERT INTO indayt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kemudian, dia membawa tabut itu ke dalam Tenda Suci, dan memasang tirai penudung untuk menudungi tabut kesaksian itu, sebagaimana yang telah diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Dia menempatkan meja itu di tenda pertemuan, di sebelah utara Tenda Suci, di luar tirai. ");
INSERT INTO indayt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Dia meletakkan roti sajian di atasnya, di hadapan TUHAN, seperti yang telah diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Dia menempatkan kaki dian di tenda pertemuan itu, berhadapan dengan meja itu, di sebelah selatan Tenda Suci, ");
INSERT INTO indayt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","dan dia menyalakan pelita-pelita itu di hadapan TUHAN, sebagaimana yang telah diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Kemudian, dia menempatkan mazbah emas di tenda pertemuan, di depan tirai, ");
INSERT INTO indayt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","dan dia membakar dupa yang harum di atasnya, sebagaimana yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Setelah itu, dia memasang tirai di pintu Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Dia menempatkan mazbah persembahan bakaran di depan pintu Tenda Suci, tenda pertemuan itu, dan mempersembahkan persembahan bakaran di atasnya, dan persembahan sajian, seperti yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Lalu, dia meletakkan bejana di antara tenda pertemuan dan mazbah itu, dan memasukkan air ke dalamnya untuk membasuh. ");
INSERT INTO indayt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, dan Harun, dan anak-anaknya membasuh tangannya dan kakinya di situ. ");
INSERT INTO indayt_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ketika mereka masuk ke tenda pertemuan, dan ketika mereka mendekat ke mazbah, mereka pun membasuh, seperti yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Lalu, dia mendirikan pelataran di sekeliling Tenda Suci dan mazbah itu, dan memasang tirai gerbang pelataran. Demikianlah Musa menyelesaikan pekerjaan itu. ");
INSERT INTO indayt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kemudian, awan melingkupi tenda pertemuan itu dan kemuliaan TUHAN memenuhi Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa tidak dapat memasuki tenda pertemuan itu karena awan itu berdiam di dalamnya, dan kemuliaan TUHAN memenuhi Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ketika awan itu naik dari Tenda Suci, keturunan Israel pun berangkat untuk melanjutkan perjalanan mereka. ");
INSERT INTO indayt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Namun, jika awan itu tidak terangkat, mereka tidak akan berangkat sampai pada hari awan itu naik. ");
INSERT INTO indayt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sebab, awan TUHAN ada di atas Tenda Suci itu pada siang hari, dan ada api dalam awan itu pada malam hari di mata semua keturunan Israel, di sepanjang perjalanan mereka. ");
INSERT INTO indayt_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","TUHAN memanggil Musa dan berbicara kepadanya dari dalam tenda pertemuan, Dia berfirman, ");
INSERT INTO indayt_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Berbicaralah kepada keturunan Israel dan katakanlah kepada mereka, ‘Apabila seseorang di antara kamu membawa persembahan kepada TUHAN, kamu harus mempersembahkan ternak, baik itu dari kawanan sapi atau kawanan domba.’ ");
INSERT INTO indayt_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","‘Jika persembahannya adalah persembahan bakaran dari kawanan sapi, dia harus mempersembahkan seekor jantan yang tidak bercacat. Dia harus membawanya ke pintu tenda pertemuan agar TUHAN berkenan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Dia harus meletakkan tangannya di atas kepala persembahan bakaran itu dan hal itu akan diterima baginya sebagai pendamaian untuknya.’ ");
INSERT INTO indayt_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","‘Dia harus menyembelih sapi muda itu di hadapan TUHAN, lalu anak-anak Harun, yaitu para imam, harus mempersembahkan darahnya dan memercikkan darah itu di sekeliling mazbah yang ada di depan pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Dia harus menguliti persembahan bakaran itu dan memotong-motongnya menjadi beberapa bagian. ");
INSERT INTO indayt_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Anak-anak Imam Harun akan menyalakan api di atas mazbah dan menyusun kayu di atas api itu. ");
INSERT INTO indayt_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Anak-anak Imam Harun harus menata potongan-potongan itu, yaitu kepalanya dan lemaknya di atas kayu yang terbakar di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Namun, isi perut dan kaki persembahan bakaran itu harus dia cuci dengan air. Kemudian, imam yang akan membakar seluruhnya di atas mazbah. Itulah persembahan bakaran, suatu persembahan dengan api, bau harum yang menyenangkan bagi TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","‘Jika persembahannya adalah dari kawanan domba atau kambing, dia harus mempersembahkan seekor jantan yang tidak bercacat sebagai persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Dia harus menyembelihnya di sisi mazbah sebelah utara, di hadapan TUHAN, lalu anak-anak Harun, yaitu para imam, harus memercikkan darah itu di sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Dia harus memotong binatang itu menjadi beberapa bagian, kepala dan lemaknya, lalu imam itu harus menyusunnya di atas kayu yang terbakar di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Namun, dia harus mencuci isi perut dan kaki kurban itu dengan air. Kemudian, imam-imam itu harus membawa seluruhnya dan membakarnya di atas mazbah. Itulah persembahan bakaran, persembahan dengan api, bau harum yang menyenangkan bagi TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","‘Jika persembahannya kepada TUHAN adalah persembahan bakaran berupa burung, dia harus membawa persembahannya itu dari burung tekukur atau burung merpati muda. ");
INSERT INTO indayt_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Imam harus membawa kurban itu ke mazbah dan memuntir kepala burung itu, lalu membakarnya di atas mazbah, dan darahnya harus dikucurkan di sisi mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Dia harus mengambil tembolok dan bulunya serta membuangnya ke tempat abu di sebelah timur mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Selanjutnya, imam harus mencabiknya pada pangkal sayapnya, tetapi tidak boleh sampai terpisah. Imam harus membakarnya di atas mazbah, di atas kayu yang terbakar. Itulah persembahan bakaran, persembahan dengan api, bau harum yang menyenangkan bagi TUHAN.’” ");
INSERT INTO indayt_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Apabila seseorang mempersembahkan persembahan sajian kepada TUHAN, persembahannya harus dari tepung halus, dan dia harus menuangkan minyak ke atas tepung itu, lalu membubuhkan kemenyan di atasnya. ");
INSERT INTO indayt_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Kemudian, dia harus membawanya kepada anak-anak Harun, para imam, yang harus mengambil segenggam dari tepung halus itu dan minyak beserta semua kemenyannya. Imam harus membakarnya di atas mazbah sebagai bagian peringatan, suatu persembahan dengan api, bau harum yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Sisa persembahan sajian itu menjadi milik Harun dan anak-anaknya, satu bagian yang paling kudus dari persembahan bakaran kepada TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Apabila kamu membawa persembahan sajian yang dipanggang, itu harus berupa roti bundar tidak beragi, terbuat dari tepung halus yang dicampur dengan minyak, atau roti tipis yang diolesi minyak. ");
INSERT INTO indayt_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Jika kamu mempersembahkan persembahan sajian yang telah dipanggang di atas pemanggang, itu harus terbuat dari tepung halus, tidak beragi, dan dicampur dengan minyak. ");
INSERT INTO indayt_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Kamu harus memecah-mecahkannya menjadi beberapa bagian dan menuangkan minyak ke atasnya. Itulah persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Apabila persembahanmu adalah persembahan sajian yang dimasak di dalam wajan, itu harus terbuat dari tepung halus dengan minyak. ");
INSERT INTO indayt_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kamu harus membawa persembahan sajian yang terbuat dari semua itu kepada TUHAN, lalu itu harus dibawa kepada imam dan dia harus membawanya ke mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Imam itu harus mengambil dari persembahan sajian itu sebagai bagian peringatan, dan harus membakarnya di atas mazbah. Itulah suatu persembahan dengan api, bau harum yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Sisa persembahan sajian itu menjadi milik Harun dan anak-anaknya, suatu bagian yang paling kudus dari persembahan bakaran kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Tidak boleh ada persembahan sajian yang kamu bawa kepada TUHAN yang diolah dengan ragi, karena kamu tidak boleh membakar apa pun yang mengandung ragi atau mengandung madu sebagai persembahan bakaran kepada TUHAN, ");
INSERT INTO indayt_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","bawalah sebagai persembahan hasil pertama kepada TUHAN, tetapi itu tidak dapat dipersembahkan di mazbah sebagai bau harum yang menyenangkan. ");
INSERT INTO indayt_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kamu harus membubuhkan semua persembahan sajianmu dengan garam. Jangan meniadakan garam perjanjian dengan Allahmu dari persembahan sajianmu. Kamu harus membubuhkan garam pada semua persembahanmu.” ");
INSERT INTO indayt_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Jika kamu mempersembahkan persembahan sajian dari panen pertamamu kepada TUHAN, kamu harus membawa bulir gandum baru yang dipanggang di atas api, biji gandum yang ditumbuk, itulah persembahan sajian pertama dari hasil ladangmu. ");
INSERT INTO indayt_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kamu harus mengoleskan minyak di atasnya dan menaruh kemenyan di atasnya. Itulah suatu persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Imam harus membakar bagian peringatan dari gandum yang ditumbuk itu dengan minyak beserta semua kemenyan, sebagai suatu persembahan dengan api bagi TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Jika persembahannya adalah persembahan pendamaian dan dia akan mempersembahkan dari kawanan sapinya, entah itu jantan atau betina, dia harus mempersembahkan yang tidak bercacat kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Dia harus meletakkan tangannya di atas kepala persembahan itu dan menyembelihnya di pintu tenda pertemuan. Kemudian, anak-anak Harun, yaitu para imam, harus memercikkan darah hewan itu di sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Dari persembahan pendamaian itu, dia harus mempersembahkan persembahan dengan api kepada TUHAN, yaitu lemak yang menutupi isi perut dan segala lemak yang ada dalam isi perut hewan itu, ");
INSERT INTO indayt_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","dan kedua ginjal dengan lemaknya, yaitu di pinggangnya, dan umbai hati yang diambil bersama dengan ginjalnya itu. ");
INSERT INTO indayt_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kemudian, anak-anak Harun harus membakarnya di mazbah, di atas persembahan bakaran, di atas kayu yang terbakar. Itulah suatu persembahan dengan api, bau harum yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Jika persembahan untuk kurban pendamaian kepada TUHAN diambil dari kawanan domba, entah itu jantan atau betina, dia harus mempersembahkan yang tidak bercacat. ");
INSERT INTO indayt_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Jika dia mempersembahkan anak domba sebagai persembahannya, dia harus mempersembahkannya di hadapan TUHAN, ");
INSERT INTO indayt_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","dan dia harus meletakkan tangannya di atas kepala persembahannya itu, lalu menyembelihnya di depan tenda pertemuan. Kemudian, anak-anak Harun harus memercikkan darahnya ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Dari kurban pendamaian itu, dia harus mempersembahkan lemaknya sebagai persembahan bakaran bagi TUHAN, yaitu lemak pada ekornya yang harus dipotongnya dari tulang belakang, lemak yang menutupi isi perut, dan semua lemak yang terdapat pada isi perut, ");
INSERT INTO indayt_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","dan kedua ginjal dan lemak yang menutupinya, yang terletak di pinggang bagian bawah, dan umbai hati yang harus diambilnya bersama-sama dengan ginjal. ");
INSERT INTO indayt_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Selanjutnya, imam harus membakarnya di atas mazbah sebagai makanan, suatu persembahan dengan api bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Jika kurban itu adalah seekor kambing, dia harus mempersembahkannya di hadapan TUHAN, ");
INSERT INTO indayt_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","dia harus meletakkan tangannya di atas kepala kambing itu, lalu menyembelihnya di depan tenda pertemuan. Kemudian, anak-anak Harun harus memercikkan darahnya di sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kemudian, dari persembahannya itu, dia harus mempersembahkan suatu persembahan dengan api bagi Tuhan, yaitu lemak yang menutupi isi perut dan semua lemak yang terdapat pada isi perut, ");
INSERT INTO indayt_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","dan kedua ginjal beserta lemaknya yang terletak di pinggangnya, dan umbai hati yang harus diambilnya bersama-sama dengan ginjal. ");
INSERT INTO indayt_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Imam harus membakar semua bagian itu di atas mazbah sebagai makanan, suatu persembahan dengan bau harum yang menyenangkan. Semua lemaknya adalah milik TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Inilah ketetapan kekal untuk seluruh keturunanmu di segala tempat kediamanmu: kamu tidak boleh makan lemak ataupun darah.” ");
INSERT INTO indayt_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kemudian, TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sampaikanlah kepada bangsa Israel dengan berkata, ‘Jika seseorang berdosa karena ketidaksengajaan dalam melakukan sesuatu yang dilarang oleh TUHAN, tetapi dia melakukan salah satu dari itu, ");
INSERT INTO indayt_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","jika yang berdosa adalah imam yang telah diurapi sehingga membawa kesalahan atas bangsanya, dia harus membawa seekor sapi jantan muda yang tidak bercacat kepada TUHAN sebagai persembahan penghapus dosa untuk dosanya itu. ");
INSERT INTO indayt_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dia harus membawa sapi jantan muda itu ke pintu tenda pertemuan di hadapan TUHAN dan harus meletakkan tangannya di atas kepala sapi jantan muda itu, lalu menyembelih sapi jantan muda itu di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Imam yang telah diurapi itu harus mengambil sebagian darah sapi jantan muda itu dan membawanya ke dalam tenda pertemuan, ");
INSERT INTO indayt_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","lalu imam itu harus mencelupkan jarinya ke dalam darah itu dan memercikkannya tujuh kali di hadapan TUHAN di depan tirai tempat kudus. ");
INSERT INTO indayt_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kemudian, imam itu juga harus mengoleskan darah itu pada tanduk-tanduk mazbah dupa yang harum di hadapan TUHAN, di dalam tenda pertemuan. Lalu, semua darah sapi jantan muda itu harus ditumpahkan ke alas mazbah persembahan bakaran yang ada di depan pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Dia harus mengambil seluruh lemak sapi yang menjadi persembahan penghapus dosa itu, yaitu lemak yang menutupi isi perut dan semua lemak yang ada pada isi perut sapi itu, ");
INSERT INTO indayt_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","dan kedua ginjal serta lemak yang menutupinya yang terletak di pinggang, juga umbai hati yang harus diambilnya bersama ginjal tadi, ");
INSERT INTO indayt_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","sama seperti yang diambil dari sapi jantan persembahan pendamaian. Lalu, imam harus membakarnya di mazbah persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Namun, kulit dan semua daging sapi jantan muda itu, juga kepalanya, kakinya, isi perut, dan kotorannya, ");
INSERT INTO indayt_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","yaitu seluruh bagian lain dari sapi itu, harus dibawa ke tempat yang tahir di luar perkemahan, yaitu tempat pembuangan abu, lalu dibakar di atas kayu berapi; di tempat pembuangan abu itulah semuanya harus dibakar.’ ");
INSERT INTO indayt_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","‘Jika yang berdosa adalah seluruh jemaat Israel karena ketidaksengajaannya, dan perkara itu tersembunyi dari mata jemaat dan mereka melakukan salah satu dari hal yang dilarang TUHAN sehingga mereka menjadi bersalah, ");
INSERT INTO indayt_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ketika dosa yang telah mereka lakukan itu diketahui, jemaat harus mempersembahkan seekor sapi jantan muda dari kawanan sapinya sebagai persembahan penghapus dosa dan membawanya ke depan tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Para tua-tua jemaat itu harus meletakkan tangan mereka ke kepala sapi jantan muda itu di hadapan TUHAN, lalu sapi itu harus disembelih di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kemudian, imam yang telah diurapi harus membawa sebagian darah sapi itu ke dalam tenda pertemuan, ");
INSERT INTO indayt_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","dan imam itu harus mencelupkan jarinya ke dalam darah dan memercikkannya tujuh kali di hadapan TUHAN, di depan tirai. ");
INSERT INTO indayt_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Dia harus mengoleskan darah itu pada tanduk-tanduk mazbah yang ada di hadapan TUHAN, di dalam tenda pertemuan, dan semua sisa darah yang ada harus dia curahkan ke alas mazbah persembahan bakaran yang ada di depan pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Dia harus mengambil semua lemak sapi itu dan membakarnya di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Dia harus melakukan hal yang sama kepada sapi itu seperti yang dilakukannya terhadap sapi persembahan penghapus dosa. Demikianlah dia harus melaksanakannya. Imam akan mengadakan pendamaian bagi mereka agar mereka diampuni. ");
INSERT INTO indayt_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Lalu, dia harus membawa sapi itu ke luar perkemahan dan membakarnya, sama seperti ketika dia membakar sapi sebelumnya. Itulah persembahan penghapus dosa untuk bangsa itu.’ ");
INSERT INTO indayt_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","‘Jika seorang pemimpin berdosa dan dalam ketidaksengajaannya melakukan salah satu hal yang dilarang TUHAN, Allahnya, dia bersalah. ");
INSERT INTO indayt_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Jika dosa yang dilakukan diberitahukan kepadanya, dia harus membawa persembahannya, yaitu seekor kambing jantan yang tidak bercacat. ");
INSERT INTO indayt_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Dia harus meletakkan tangannya ke atas kepala kambing jantan itu dan menyembelihnya di tempat penyembelihan persembahan bakaran di hadapan TUHAN. Itulah persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Lalu, imam harus mengambil sebagian dari darah persembahan penghapus dosa itu dengan jarinya dan mengoleskannya pada tanduk-tanduk mazbah persembahan bakaran, dan sisa darah yang ada harus dicurahkan ke alas mazbah persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Dia harus membakar semua lemaknya di atas mazbah sama seperti lemak persembahan pendamaian, lalu imam akan mengadakan pendamaian untuknya karena dosanya itu sehingga dia diampuni.’ ");
INSERT INTO indayt_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","‘Jika seseorang dari antara rakyat biasa berdosa karena ketidaksengajaannya dalam melakukan salah satu hal yang dilarang oleh TUHAN sehingga dia bersalah, ");
INSERT INTO indayt_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","setelah dosa yang telah dilakukannya itu diberitahukan kepadanya, dia harus membawa persembahannya, yaitu seekor anak kambing betina yang tidak bercacat untuk dosa yang telah dilakukannya itu. ");
INSERT INTO indayt_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Dia harus meletakkan tangannya ke atas kepala persembahan penghapus dosa itu dan menyembelih persembahan penghapus dosa itu di tempat persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kemudian, imam harus mengambil sebagian darah kambing itu dengan jarinya dan mengoleskannya pada tanduk-tanduk mazbah persembahan bakaran, dan sisa darah yang ada harus dicurahkan ke alas mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Imam harus mengambil semua lemak kambing kurban pendamaian itu dan membakarnya di atas mazbah, bau yang menyenangkan bagi TUHAN. Dengan cara itulah imam mengadakan pendamaian bagi orang itu sehingga dia diampuni.’ ");
INSERT INTO indayt_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","‘Namun, jika orang itu membawa seekor anak domba sebagai persembahan penghapus dosanya, dia harus membawa seekor betina yang tidak bercacat. ");
INSERT INTO indayt_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Dia harus meletakkan tangannya ke kepala kurban penghapus dosa itu dan menyembelihnya sebagai persembahan penghapus dosa di tempat menyembelih persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Imam harus mengambil sebagian darah persembahan penghapus dosa dengan jarinya dan mengoleskannya pada tanduk-tanduk mazbah persembahan bakaran, dan seluruh sisa darah harus ditumpahkan ke bagian alas mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Kemudian, dia harus mengambil semua lemaknya, sama seperti lemak pada domba kurban pendamaian, dan imam harus membakarnya di atas mazbah sebagai persembahan dengan api bagi TUHAN. Dengan cara itulah imam mengadakan pendamaian untuk orang itu atas dosa yang dilakukannya dan orang itu akan diampuni.’” ");
INSERT INTO indayt_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Jika seseorang berdosa karena mendengar suara kutukan dan dia adalah saksi, entah dia melihat atau mengetahuinya, tetapi dia tidak mau mengatakannya, dialah yang harus menanggung kesalahannya. ");
INSERT INTO indayt_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Atau, jika seseorang menyentuh sesuatu yang najis, baik bangkai binatang buas, bangkai ternak yang najis, maupun bangkai binatang mengeriap yang najis, meskipun dia tidak mengetahuinya, dia juga menjadi najis dan bersalah, ");
INSERT INTO indayt_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","atau, jika seseorang menyentuh kenajisan manusia, apa pun bentuk kenajisan yang dapat membuatnya menjadi najis, meskipun dia tidak mengetahuinya, dia pun bersalah, ");
INSERT INTO indayt_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","atau, jika seseorang bersumpah secara gegabah dengan bibirnya untuk melakukan yang jahat atau melakukan yang baik, tetapi hal itu tersembunyi baginya, ketika dia telah mengetahuinya, dia pun bersalah atas salah satu dari perkara-perkara itu. ");
INSERT INTO indayt_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Jadi, jika seseorang menjadi bersalah karena salah satu dari perkara-perkara tersebut, dia harus mengakui dosa yang telah diperbuatnya itu. ");
INSERT INTO indayt_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Dia juga harus membawa persembahan penebus salahnya kepada TUHAN karena dosa yang telah membuatnya berdosa itu, yaitu anak domba betina atau anak kambing betina dari kawanannya sebagai persembahan penghapus dosa. Lalu, imam harus mengadakan pendamaian bagi orang itu atas dosanya. ");
INSERT INTO indayt_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Namun, jika dia tidak mampu menyediakan seekor anak domba, dia harus membawa persembahan penebus salah kepada TUHAN karena dosa yang telah dilakukannya itu, yaitu dua ekor burung tekukur atau dua ekor burung merpati muda, yang seekor untuk persembahan penghapus dosa, dan yang seekor untuk persembahan bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Dia harus membawanya kepada imam, yang terlebih dahulu harus mempersembahkan persembahan penghapus dosa dan harus memuntir kepalanya dari pangkal lehernya, tetapi tidak boleh sampai terputus. ");
INSERT INTO indayt_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Dia harus memercikkan sebagian darah persembahan penghapus dosa itu ke sisi mazbah, sedangkan sisa darahnya harus diperas keluar, ke alas mazbah, itulah persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kemudian, imam harus mengolah yang seekor lagi sebagai persembahan bakaran sesuai dengan peraturan. Jadi, imam harus mengadakan pendamaian demi orang itu atas dosa yang telah diperbuatnya itu supaya dia diampuni. ");
INSERT INTO indayt_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Namun, jika orang itu tidak mampu memberikan dua ekor burung tekukur atau dua burung merpati, orang yang telah berdosa itu harus membawa persembahannya, yaitu sepersepuluh efa tepung halus sebagai persembahan penghapus dosa. Dia tidak boleh menuangkan minyak atau membubuhkan kemenyan ke atasnya sebab itu adalah persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Dia harus membawanya kepada imam dan imam harus mengambil segenggam dari tepung itu sebagai bagian peringatan, lalu membakarnya di atas mazbah bersama persembahan dengan api untuk TUHAN, itulah persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Demikianlah imam harus mengadakan pendamaian bagi orang itu atas dosa yang dilakukannya dalam salah satu perkara-perkara tersebut, dan hal itu akan membuatnya diampuni. Lalu, sisanya harus menjadi bagian untuk imam, sama seperti persembahan sajian.” ");
INSERT INTO indayt_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Kemudian, TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ketika seseorang melakukan pelanggaran dan berdosa dalam ketidaksengajaan sehubungan dengan hal-hal kudus milik TUHAN, dia harus membawa persembahan penebus salahnya kepada TUHAN, yaitu seekor domba jantan yang tidak bercacat dari kawanannya yang ditaksir menurut ukuran syikal perak, yaitu berdasarkan syikal tempat kudus untuk persembahan penebus salah. ");
INSERT INTO indayt_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Dia harus membayar ganti rugi atas dosa yang dilakukannya terhadap hal-hal kudus tersebut dan harus menambahkan seperlimanya untuk diberikan kepada imam. Lalu, imam akan mengadakan pendamaian untuknya dengan domba jantan persembahan penebus salah dan hal itu akan membuatnya diampuni. ");
INSERT INTO indayt_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Jika seseorang berdosa dan melakukan salah satu hal yang dilarang TUHAN, meskipun dia tidak mengetahuinya, dia tetap bersalah dan harus menanggung kesalahannya. ");
INSERT INTO indayt_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Dia harus membawa kepada imam seekor domba jantan yang tidak bercacat dari kawanannya berdasarkan taksirannya sebagai persembahan penebus salah. Dengan begitu, imam akan mengadakan pendamaian baginya atas kesalahan yang dilakukannya dalam ketidaksengajaan sehingga dia tidak mengetahuinya, dan hal itu akan membuatnya diampuni. ");
INSERT INTO indayt_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Itulah kurban penebus salah karena dia memang benar-benar bersalah di hadapan TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kemudian, TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Jika seseorang berdosa dan bertindak tidak setia kepada TUHAN dengan menipu sesamanya mengenai barang titipan, atau barang yang dipercayakan kepadanya, atau barang rampasan, atau dia telah memeras sesamanya, ");
INSERT INTO indayt_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","atau ketika dia menemukan barang yang hilang, tetapi berbohong mengenai hal itu dan dia bersumpah dusta mengenai segala hal yang dilakukan oleh seorang manusia sehingga dia berdosa karenanya, ");
INSERT INTO indayt_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","akan terjadi, karena dia telah berdosa dan bersalah, dia harus mengembalikan apa yang telah diambilnya, entah itu dengan merampas, memeras, mengambil barang yang dititipkan kepadanya, atau barang hilang yang ditemukannya, ");
INSERT INTO indayt_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","maupun barang yang atasnya dia bersumpah dusta itu. Dia harus membayar kembali semua barang itu sepenuhnya dan harus menambahkan seperlima dari harga barang-barang tersebut. Lalu, dia harus memberikannya kepada pemilik barang-barang itu pada hari dia mempersembahkan persembahan penebus salahnya. ");
INSERT INTO indayt_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Dia harus membawa persembahan penebus salahnya bagi TUHAN kepada imam, yaitu seekor domba jantan yang tidak bercacat dari kawanannya, atau yang nilainya setara sebagai persembahan penebus salah. ");
INSERT INTO indayt_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Imam harus mengadakan pendamaian bagi orang itu di hadapan TUHAN sehingga orang itu akan diampuni kesalahannya atas pelanggaran apa pun yang telah dia perbuat.” ");
INSERT INTO indayt_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Perintahkanlah ini kepada Harun dan anak-anaknya, ‘Inilah hukum tentang persembahan bakaran: persembahan bakaran harus tetap ada di atas perapian mazbah sepanjang malam sampai pagi dan api mazbah harus dijaga tetap menyala. ");
INSERT INTO indayt_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Imam harus mengenakan pakaian linennya dan mengenakan celana linen pada tubuhnya. Lalu, dia harus mengangkat abu persembahan bakaran yang telah dilahap oleh api di mazbah dan dia harus menaruhnya di samping mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Kemudian, dia harus menanggalkan pakaiannya dan mengenakan pakaian lain, lalu membawa abu itu ke luar perkemahan, ke suatu tempat yang tahir. ");
INSERT INTO indayt_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Api yang di atas mazbah harus tetap menyala, tidak boleh padam. Setiap pagi, imam harus membakar kayu di atas mazbah dan meletakkan persembahan bakaran di atasnya. Dia harus membakar lemak kurban itu sebagai kurban pendamaian. ");
INSERT INTO indayt_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Api itu harus terus-menerus menyala di atas mazbah, tidak boleh padam.’” ");
INSERT INTO indayt_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Inilah hukum tentang persembahan sajian: anak-anak Harun harus mempersembahkannya kepada TUHAN di depan mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Dia harus mengambil segenggam tepung halus dari persembahan sajian itu, bersama minyak dan semua kemenyan yang terdapat pada persembahan sajian. Dia harus membakarnya di atas mazbah, suatu bau harum yang menyenangkan, sebagai persembahan peringatan bagi TUHAN, ");
INSERT INTO indayt_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","yang tersisa dari itu harus dimakan oleh Harun dan anak-anaknya dan harus dimakan sebagai roti tidak beragi di tempat kudus. Mereka harus memakannya di pelataran tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Itu tidak boleh dipanggang dengan ragi. Aku telah memberikannya sebagai bagian mereka dari persembahan dengan api milik-Ku. Itu adalah yang mahakudus, sama seperti persembahan penghapus dosa dan persembahan penebus salah. ");
INSERT INTO indayt_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Setiap laki-laki dari keturunan Harun boleh memakannya. Itulah ketetapan untuk selama-lamanya dari generasi ke generasi, yaitu dari persembahan dengan api untuk TUHAN. Semua yang menyentuhnya akan menjadi kudus.” ");
INSERT INTO indayt_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Inilah persembahan Harun dan anak-anaknya yang harus dipersembahkan kepada TUHAN pada hari ketika dia diurapi: sepersepuluh efa tepung halus sebagai persembahan sajian yang tetap, setengah pada pagi hari dan setengahnya lagi pada sore hari. ");
INSERT INTO indayt_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tepung itu harus diolah dengan minyak di atas pemanggang. Setelah tercampur dengan baik, kamu harus membawanya masuk. Lalu, kamu harus mempersembahkan persembahan sajian berupa potongan-potongan yang sudah dibakar itu sebagai bau harum yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Yang harus melakukannya adalah imam dari antara anak-anak Harun yang telah diurapi untuk menggantikannya. Ini adalah ketetapan yang berlaku selama-lamanya untuk TUHAN, dan itu harus dibakar seluruhnya. ");
INSERT INTO indayt_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Jadi, setiap kurban sajian dari imam harus dibakar seluruhnya, tidak boleh dimakan.” ");
INSERT INTO indayt_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Berbicaralah kepada Harun dan anak-anaknya, katakanlah: ‘Inilah hukum tentang persembahan penghapus dosa: di tempat persembahan bakaran disembelih, di situlah persembahan penghapus dosa harus disembelih di hadapan TUHAN. Ini adalah yang mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Imam yang mempersembahkan persembahan penghapus dosa itu harus memakannya. Dia harus memakannya di tempat kudus, yaitu di pelataran tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Segala sesuatu yang menyentuh daging itu akan menjadi suci, dan jika ada darahnya yang terpercik pada pakaian, kamu harus mencuci bagian yang terpercik itu di tempat kudus. ");
INSERT INTO indayt_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Lalu, belanga tanah yang dipakai untuk merebusnya harus dipecahkan. Namun, jika daging itu direbus dalam bejana perunggu, belanga itu harus digosok dan dicuci dengan air. ");
INSERT INTO indayt_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Setiap laki-laki dalam keluarga imam boleh memakannya. Itu adalah yang mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Akan tetapi, persembahan penghapus dosa, yang darahnya dibawa masuk ke tenda pertemuan untuk mengadakan pendamaian di tempat kudus, tidak boleh dimakan, melainkan harus dibakar dengan api.’” ");
INSERT INTO indayt_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Inilah hukum tentang persembahan penebus salah, yang adalah mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Di tempat mereka menyembelih persembahan bakaran, di situlah mereka harus menyembelih persembahan penebus salah, dan darahnya harus dipercikkan di sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Dia harus mempersembahkan semua lemaknya, yaitu lemak ekor dan lemak yang menutupi isi perutnya, ");
INSERT INTO indayt_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","lalu kedua ginjal dengan lemaknya, yang terletak di pinggang, dan umbai pada hati harus dia pisahkan bersama dengan ginjal itu. ");
INSERT INTO indayt_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Imam harus membakarnya di atas mazbah sebagai persembahan dengan api bagi TUHAN, itulah persembahan penebus salah. ");
INSERT INTO indayt_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Setiap laki-laki di antara para imam boleh memakannya dan itu harus dimakan di tempat kudus, ini adalah yang mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Persembahan penebus salah sama seperti persembahan penghapus dosa, yaitu satu hukum untuk keduanya: imam yang mengadakan pendamaian dengan persembahan itu harus mendapatkannya. ");
INSERT INTO indayt_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Imam yang mempersembahkan persembahan bakaran seseorang harus memperoleh kulit dari persembahan bakaran yang dia persembahkan itu bagi dirinya. ");
INSERT INTO indayt_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Semua persembahan sajian yang dipanggang di atas tungku, dan semua yang diolah di atas wajan, dan di atas pemanggang harus menjadi milik imam yang mempersembahkannya. ");
INSERT INTO indayt_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Semua persembahan sajian yang dicampur dengan minyak maupun yang kering harus menjadi milik anak-anak Harun, masing-masing mendapat bagian yang sama.” ");
INSERT INTO indayt_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Inilah hukum tentang persembahan pendamaian yang harus seseorang persembahkan kepada TUHAN: ");
INSERT INTO indayt_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","jika dia mempersembahkannya sebagai ucapan syukur, bersama persembahan ucapan syukur itu dia harus mempersembahkan roti bundar tidak beragi yang diolah dengan minyak, roti tipis yang diolesi minyak, dan roti yang terbuat dari tepung halus yang diolah dengan minyak. ");
INSERT INTO indayt_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Bersama kurban dari persembahan pendamaian untuk ucapan syukurnya, dia harus mempersembahkan persembahannya dengan roti yang beragi. ");
INSERT INTO indayt_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Dia harus mengambil sepotong roti dari setiap persembahan itu sebagai pemberian kepada TUHAN. Itu harus menjadi milik imam yang memercikkan darah persembahan pendamaian. ");
INSERT INTO indayt_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Daging dari persembahan pendamaian untuk ucapan syukurnya itu harus dimakan pada hari yang sama ketika itu dipersembahkan. Dia tidak boleh menyisakan sedikit pun sampai pagi. ");
INSERT INTO indayt_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Akan tetapi, jika persembahannya merupakan suatu nazar atau persembahan sukarela, itu harus dimakan pada hari dia mempersembahkan kurbannya, dan yang masih tersisa harus dimakan pada keesokan harinya. ");
INSERT INTO indayt_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Namun, pada hari yang ketiga, yang tersisa dari daging kurban itu harus dibakar dengan api. ");
INSERT INTO indayt_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Karena itu, jika ada dari daging persembahan pendamaian itu yang dimakan pada hari yang ketiga, orang yang mempersembahkannya tidak akan diterima dan hal itu tidak akan diperhitungkan baginya, malah persembahan itu menjadi sesuatu yang najis. Orang yang memakannya akan menanggung sendiri kesalahannya. ");
INSERT INTO indayt_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Daging yang menyentuh segala sesuatu yang najis tidak boleh dimakan, melainkan harus dibakar dengan api. Adapun mengenai daging yang lainnya, setiap orang yang tahir boleh makan daging itu. ");
INSERT INTO indayt_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Jika seseorang yang makan daging persembahan pendamaian milik TUHAN sedang dalam kenajisannya, orang itu harus dilenyapkan dari bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Jika seseorang menyentuh sesuatu yang najis, entah itu kenajisan dari manusia, atau dari binatang yang najis, atau dari binatang merayap yang najis, lalu dia makan daging persembahan pendamaian yang adalah bagian TUHAN, orang itu harus dilenyapkan dari bangsanya.” ");
INSERT INTO indayt_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kemudian, TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Berbicaralah kepada bangsa Israel, katakanlah, ‘Jangan makan lemak apa pun dari sapi, domba, atau kambing. ");
INSERT INTO indayt_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Namun, lemak dari bangkai binatang apa pun atau lemak binatang yang mati dimangsa hewan buas boleh digunakan untuk hal lain, tetapi tidak boleh dimakan. ");
INSERT INTO indayt_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Siapa pun yang memakan lemak dari hewan yang dipersembahkan sebagai pemberian dengan api kepada TUHAN harus dilenyapkan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Di mana pun kamu tinggal, kamu tidak boleh memakan darah, dari unggas ataupun binatang lain. ");
INSERT INTO indayt_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Siapa pun yang memakan darah harus dilenyapkan dari antara bangsanya.’” ");
INSERT INTO indayt_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Katakanlah kepada bangsa Israel: ‘Orang yang mempersembahkan kurban pendamaian kepada TUHAN harus membawa sendiri persembahannya dari kurban pendamaian itu kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Dengan tangannya sendiri, dia harus membawa persembahan bakarannya, yaitu lemak serta dada binatang itu. Dada binatang itu akan dibawa sebagai persembahan unjukan kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Imam akan membakar lemaknya di atas mazbah, tetapi dada binatang itu akan menjadi milik Harun dan anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kamu juga harus memberikan paha kanannya kepada imam sebagai pemberian dari kurban pendamaianmu. ");
INSERT INTO indayt_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Anak Harun yang mempersembahkan darah dan lemak kurban pendamaian tersebut, dialah yang mendapat bagian paha kanan itu. ");
INSERT INTO indayt_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Sebab, Aku telah mengambil dada dan paha kanan persembahan unjukan dari kurban pendamaian yang dipersembahkan umat Israel. Dan, Aku telah memberikan itu kepada Imam Harun dan anak-anaknya, sebagai ketetapan selama-lamanya bagi umat Israel. ");
INSERT INTO indayt_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Itulah bagian Harun dan anak-anaknya dari semua kurban bakaran yang dipersembahkan kepada TUHAN pada waktu dia mempersembahkannya sebagai imam di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Itulah perintah TUHAN kepada umat Israel tentang apa yang harus diberikan kepada Harun dan anak-anaknya pada hari mereka diurapi sebagai imam. Itulah bagian mereka untuk selamanya, dari generasi ke generasi.’” ");
INSERT INTO indayt_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Demikianlah peraturan tentang persembahan bakaran, persembahan sajian, persembahan penghapus dosa, persembahan penebus salah, persembahan pendamaian, dan persembahan penahbisan imam. ");
INSERT INTO indayt_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","TUHAN memberikan perintah ini kepada Musa di atas Gunung Sinai ketika Dia memerintahkan bangsa Israel untuk membawa persembahan kepada TUHAN di padang gurun Sinai. ");
INSERT INTO indayt_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Bawalah Harun dan anak-anaknya bersamanya, dengan pakaian-pakaian, minyak urapan, sapi jantan untuk persembahan penghapus dosa, dua domba jantan, dan sekeranjang roti tidak beragi. ");
INSERT INTO indayt_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Kumpulkanlah seluruh jemaat di pintu tenda pertemuan.” ");
INSERT INTO indayt_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa melakukan seperti yang TUHAN perintahkan kepadanya, dan jemaat berkumpul di pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa berkata kepada jemaat itu, “Ini adalah firman yang telah TUHAN perintahkan untuk dilakukan.” ");
INSERT INTO indayt_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Kemudian, Musa membawa Harun dan anak-anaknya untuk mendekat dan membasuh mereka dengan air. ");
INSERT INTO indayt_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Dia memakaikan baju panjang kepada Harun dan mengikatkan ikat pinggang kepadanya, lalu dia memakaikan jubah kepadanya dan memasang baju efod atasnya, kemudian dia mengikatkan pita baju efod di sekelilingnya sehingga baju efod itu terikat dengannya. ");
INSERT INTO indayt_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Dia juga memasangkan tutup dada kepadanya, lalu memasang Urim dan Tumim pada tutup dada itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Dia memakaikan serban ke kepalanya dan memasang hiasan emas pada bagian depan serban itu, yaitu mahkota kudus seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kemudian, Musa mengambil minyak urapan dan mengurapi Tenda Suci beserta semua benda yang ada di dalamnya, dan menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Dia memercikkan sebagian minyak urapan pada mazbah sebanyak tujuh kali dan mengurapi mazbah serta semua perkakasnya, bejana pembasuhan serta alasnya, untuk menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Lalu, dia menuangkan sebagian dari minyak urapan ke kepala Harun dan mengurapinya untuk menguduskannya. ");
INSERT INTO indayt_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Selanjutnya, Musa membawa anak-anak Harun ke depan dan memakaikan baju panjang kepada mereka, dan mengikatkan ikat pinggang kain, dan memasangkan serban ke kepala mereka, seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kemudian, Musa membawa sapi jantan persembahan penghapus dosa, dan Harun beserta anak-anaknya meletakkan tangan mereka ke atas kepala sapi persembahan penghapus dosa itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Lalu, Musa menyembelih sapi itu dan mengambil darahnya. Lalu, dengan jarinya, dia mengoleskannya pada semua tanduk mazbah untuk menguduskan mazbah itu. Kemudian, dia menumpahkan sisa darah yang ada ke dasar mazbah. Demikianlah dia menguduskannya dan mengadakan pendamaian atas mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Dia juga mengambil semua lemak yang ada pada isi perut, hati bagian atas, lalu dua ginjal beserta lemaknya, dan membakarnya di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Akan tetapi, sapi jantan muda itu, kulitnya, dagingnya, dan kotorannya, dia bakar dengan api di luar perkemahan, seperti yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kemudian, dia mempersembahkan domba jantan persembahan bakaran, lalu Harun beserta anak-anaknya meletakkan tangan mereka ke atas kepala domba itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Lalu, Musa menyembelih domba itu dan memercikkan darahnya ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Dia memotong domba itu menjadi beberapa bagian, lalu Musa membakar kepala, potongan-potongannya, dan lemaknya. ");
INSERT INTO indayt_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Setelah dia membersihkan isi perut dan kaki domba itu dengan air, Musa membakar seluruh bagian domba itu di atas mazbah. Itulah persembahan bakaran, bau harum yang menyenangkan, suatu persembahan dengan api untuk TUHAN, seperti yang telah diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kemudian, dia membawa domba jantan yang lain, yaitu domba jantan penahbisan, lalu Harun dan anak-anaknya meletakkan tangan mereka ke kepala domba itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa menyembelih domba itu dan mengambil darahnya, lalu mengoleskannya pada cuping telinga kanan Harun, dan pada ibu jari tangan kanannya, dan pada ibu jari kaki kanannya. ");
INSERT INTO indayt_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Kemudian, dia membawa anak-anak Harun untuk mendekat, dan Musa mengoleskan darah itu di cuping telinga kanan, ibu jari tangan kanan, dan di ibu jari kaki kanan mereka. Lalu, Musa memercikkan sisa darah itu ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Dia mengambil semua lemak domba itu, baik lemak di bagian ekor maupun di bagian isi perut, juga umbai hati, dua ginjal beserta lemaknya, dan paha kanan domba itu. ");
INSERT INTO indayt_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Dari keranjang roti tidak beragi yang ada di hadapan TUHAN, Musa mengambil sepotong roti tidak beragi, sepotong roti yang dicampur dengan minyak, dan sepotong roti tipis, lalu dia meletakkannya di atas lemak-lemak itu dan di atas paha kanan. ");
INSERT INTO indayt_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Kemudian, dia menyerahkan semua itu ke tangan Harun dan ke tangan anak-anaknya dan mengunjukkannya sebagai persembahan unjukan di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Lalu, Musa mengambilnya kembali dari tangan mereka dan membakarnya di atas mazbah bersama dengan kurban bakaran. Itulah kurban penahbisan yang baunya menyenangkan, suatu persembahan dengan api bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa juga mengambil dada domba itu dan mempersembahkannya sebagai persembahan unjukan di hadapan TUHAN. Itulah yang menjadi bagian Musa dari domba jantan penahbisan, seperti yang diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musa mengambil minyak urapan dan darah yang ada di atas mazbah lalu memercikkannya pada Harun, pakaiannya serta pada anak-anak Harun dan pakaian anak-anaknya. Demikianlah dia menguduskan Harun dan pakaiannya, serta anak-anaknya dan pakaian mereka. ");
INSERT INTO indayt_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Kemudian, Musa berkata kepada Harun dan anak-anaknya, “Masaklah daging domba itu di pintu tenda pertemuan. Makanlah itu di sana bersama dengan roti yang ada di dalam keranjang kurban penahbisan, seperti yang telah kuperintahkan dengan berkata, ‘Harun dan anak-anaknya harus memakannya’. ");
INSERT INTO indayt_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Jika ada daging atau roti yang tersisa, bakarlah habis dengan api. ");
INSERT INTO indayt_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kalian tidak boleh meninggalkan pintu tenda pertemuan selama tujuh hari sampai hari penahbisanmu selesai, sebab Dia akan menguduskanmu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Seperti yang kita lakukan hari ini, demikianlah perintah TUHAN untuk pengampunan dosamu. ");
INSERT INTO indayt_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kalian harus tinggal di pintu masuk tenda pertemuan, siang dan malam selama tujuh hari. Kalian harus melakukan kewajibanmu kepada TUHAN supaya kamu tidak mati. Karena, itulah yang diperintahkan kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Jadi, Harun dan anak-anaknya melakukan semua yang telah diperintahkan TUHAN melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Pada hari kedelapan, Musa memanggil Harun dan anak-anaknya serta tua-tua Israel. ");
INSERT INTO indayt_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Dia berkata kepada Harun, “Ambillah seekor anak sapi jantan untuk kurban penghapus dosa dan seekor domba jantan untuk kurban bakaran. Keduanya haruslah tidak bercacat. Persembahkanlah itu di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Katakanlah kepada bangsa Israel perkataan ini, ‘Ambillah seekor kambing jantan untuk kurban penghapus dosa, seekor anak sapi jantan dan seekor domba yang berumur setahun untuk kurban bakaran. Semuanya tidak boleh bercacat. ");
INSERT INTO indayt_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Ambillah seekor sapi dan seekor domba jantan untuk kurban pendamaian; dan persembahan sajian yang diolah dengan minyak untuk dipersembahkan kepada TUHAN. Sebab, hari ini TUHAN akan menampakkan diri kepadamu.’” ");
INSERT INTO indayt_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Maka, bangsa itu membawa semua yang diperintahkan Musa ke depan tenda pertemuan. Seluruh umat datang mendekat dan berdiri di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa berkata, “Inilah firman yang diperintahkan TUHAN untuk kamu lakukan, supaya kemuliaan TUHAN tampak kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kemudian, Musa berkata kepada Harun, “Mendekatlah ke mazbah dan persembahkanlah kurban penghapus dosa dan kurban bakaranmu, untuk mengadakan pengampunan dosa bagi dirimu sendiri dan bagi bangsa ini. Dengan begitu, kamu mengadakan pengampunan dosa bagi bangsa ini seperti yang diperintahkan TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Jadi, Harun mendekat ke mazbah dan menyembelih anak sapi kurban penghapus dosa untuk dirinya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Anak-anak Harun membawa darah anak sapi itu kepadanya. Harun mencelupkan jarinya ke dalam darah dan mengoleskannya ke tanduk-tanduk mazbah. Dia menyiramkan sisa darah itu ke bagian alas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Lemak, ginjal, dan umbai hati kurban penebus dosa itu dibakarnya di atas mazbah, seperti yang diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Namun, kulit dan daging kurban itu dibakar dengan api di luar perkemahan. ");
INSERT INTO indayt_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Berikutnya, Harun menyembelih hewan kurban bakaran. Anak-anaknya membawa darah hewan itu kepadanya, dan dia memercikkannya ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Mereka juga memberikan potongan-potongan daging dan kepala dari kurban bakaran itu kepadanya, dan dia membakarnya di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Dia mencuci isi perut dan kaki hewan itu serta membakarnya di atas mazbah bersama kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kemudian, dia membawa persembahan umat Israel. Dia mengambil kambing kurban penghapus dosa untuk bangsa itu, menyembelihnya, dan mempersembahkannya sebagai kurban penghapus dosa, seperti sebelumnya. ");
INSERT INTO indayt_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Dia juga membawa kurban bakaran dan mempersembahkannya menurut peraturan. ");
INSERT INTO indayt_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Lalu, Harun membawa kurban sajian. Dia mengambil segenggam dari kurban sajian itu dan membakarnya di atas mazbah, di samping kurban bakaran pada pagi hari. ");
INSERT INTO indayt_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Harun juga menyembelih sapi dan domba jantan, yaitu kurban pendamaian bagi bangsa itu. Anak-anaknya memberikan darah kurban itu kepadanya, dan dia memercikkannya ke sekeliling mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Kemudian juga bagian lemak sapi dan domba jantan itu, yaitu lemak pada ekornya, lemak yang menutupi isi perutnya, juga kedua ginjal dan umbai hati. ");
INSERT INTO indayt_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Mereka meletakkan semua lemak itu di atas dada hewan itu dan dia membakarnya di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Namun, dada dan paha kanan kurban itu dipersembahkan Harun sebagai persembahan unjukan di hadapan TUHAN, seperti yang Musa perintahkan. ");
INSERT INTO indayt_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kemudian, Harun mengangkat tangannya ke arah umat dan memberkati mereka. Sesudah mempersembahkan kurban penghapus dosa, kurban bakaran, dan kurban pendamaian, lalu dia turun. ");
INSERT INTO indayt_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Lalu, Musa dan Harun masuk ke tenda pertemuan. Ketika mereka keluar dan memberkati umat, kemuliaan TUHAN tampak kepada seluruh umat itu. ");
INSERT INTO indayt_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Api keluar dari hadapan TUHAN dan membakar habis kurban bakaran dan semua lemak di atas mazbah. Ketika seluruh umat melihatnya, mereka bersorak-sorai dan sujud menyembah dengan muka sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Kemudian, anak-anak Harun, Nadab dan Abihu, mengambil pedupaan masing-masing dan menaruh api serta ukupan di atasnya, lalu mempersembahkan api yang asing ke hadapan TUHAN, sesuatu yang tidak diperintahkan oleh-Nya. ");
INSERT INTO indayt_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lalu, keluarlah api dari hadapan TUHAN melalap keduanya dan mereka pun mati di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Lalu, Musa berkata kepada Harun, “Inilah yang TUHAN firmankan, firman-Nya, ‘Semua orang yang mendekat kepada-Ku harus menghormati kekudusan-Ku. Di hadapan seluruh umat ini, Aku harus dimuliakan.’” Jadi, Harun tidak mengatakan apa pun. ");
INSERT INTO indayt_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa memanggil Misael dan Elsafan, anak-anak Uziel, paman Harun, lalu berkata kepada mereka, “Datang dan angkatlah saudara-saudaramu, bawalah mereka dari tempat yang kudus ini ke luar perkemahan.” ");
INSERT INTO indayt_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Setelah itu, mereka datang lalu mengangkat jenazah keduanya yang masih mengenakan pakaian ke luar perkemahan, seperti yang diperintahkan Musa. ");
INSERT INTO indayt_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kemudian, Musa berkata kepada Harun dan anak-anaknya, Eleazar dan Itamar, “Janganlah menguraikan rambutmu maupun menyobek pakaianmu, supaya kamu tidak mati dan TUHAN tidak murka terhadap seluruh umat ini. Akan tetapi, biarlah saudara-saudaramu, seluruh Israel, meratapi keluarnya api dari TUHAN itu. ");
INSERT INTO indayt_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kamu tidak boleh meninggalkan pintu tenda pertemuan, atau kamu akan mati. Sebab, minyak urapan TUHAN ada padamu.” Maka mereka pun mematuhi Musa. ");
INSERT INTO indayt_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kemudian, TUHAN berfirman kepada Harun, kata-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ketika kamu memasuki tenda pertemuan, kamu dan anak-anakmu tidak boleh minum anggur atau minuman keras. Supaya kamu tidak mati. Inilah peraturan untuk selamanya dari generasi ke generasi. ");
INSERT INTO indayt_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kamu harus dapat membedakan antara yang kudus dan yang tidak kudus, antara yang tahir dan yang najis, ");
INSERT INTO indayt_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","juga ajarkan kepada umat Israel tentang semua hukum yang telah TUHAN firmankan kepada mereka melalui Musa.” ");
INSERT INTO indayt_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa berkata kepada Harun dan kepada dua anaknya yang masih hidup, Eleazar dan Itamar, “Ambillah kurban sajian yang masih tersisa dari kurban bakaran TUHAN dan makanlah tanpa ragi di samping mazbah, sebab, itulah bagian mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Itulah yang menjadi hakmu dan anak-anakmu dari semua kurban bakaran bagi TUHAN, seperti yang telah diperintahkan padaku, makanlah di tempat yang kudus. ");
INSERT INTO indayt_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Namun, dada persembahan unjukan dan paha kurban khusus harus kamu makan di tempat yang tahir, bersama anak-anakmu laki-laki dan perempuan. Sebab, bagian itu telah diberikan sebagai hakmu dan hak anak-anakmu dari semua kurban pendamaian umat Israel. ");
INSERT INTO indayt_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Paha kurban pemberian dan dada kurban unjukan harus dibawa bersama lemak kurban bakaran, untuk dipersembahkan sebagai kurban unjukan di hadapan TUHAN. Itu akan menjadi hakmu dan anak-anakmu untuk selamanya, seperti yang diperintahkan TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kemudian, Musa mencari kambing jantan kurban penghapus dosa, yang ternyata telah habis dibakar. Dia menjadi marah pada Eleazar dan Itamar, anak-anak Harun yang masih hidup, dan berkata, ");
INSERT INTO indayt_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Mengapa kamu tidak memakan kurban penghapus dosa itu di tempat yang kudus? Itulah bagian mahakudus! TUHAN telah memberikannya kepadamu untuk membawa kesalahan umat, untuk mengadakan pendamaian bagi mereka di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Lihat, kalau darahnya tidak di bawa masuk ke ruang kudus, berarti kamu seharusnya memakannya di ruang kudus, seperti yang telah kuperintahkan!” ");
INSERT INTO indayt_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Lalu Harun berkata kepada Musa, “Lihat, hari ini mereka telah mempersembahkan kurban penghapus dosa dan kurban bakaran mereka di hadapan TUHAN dan setelah peristiwa yang terjadi padaku ini, apakah baik di mata TUHAN jika aku memakan daging kurban penghapus dosa hari ini?” ");
INSERT INTO indayt_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Setelah mendengar itu, Musa pun menyetujuinya. ");
INSERT INTO indayt_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","TUHAN berfirman kepada Musa dan Harun, firman-Nya ");
INSERT INTO indayt_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Katakanlah kepada bangsa Israel demikian, ‘Inilah hewan-hewan yang boleh kamu makan dari semua binatang yang ada di bumi: ");
INSERT INTO indayt_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Setiap binatang yang berkuku belah, yaitu yang kukunya benar-benar terbelah, dan yang memamah biak boleh kamu makan. ");
INSERT INTO indayt_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Namun, dari binatang yang berkuku belah atau memamah biak, inilah yang tidak boleh kamu makan, yaitu unta, sebab, meskipun memamah biak, unta tidak berkuku belah. Itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pelanduk juga tidak boleh kamu makan, sebab, meskipun memamah biak, pelanduk tidak berkuku belah. Itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Kelinci juga tidak boleh dimakan, sebab, meskipun memamah biak, kelinci tidak berkuku belah. Itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Sedang hewan lain yang tidak boleh kamu makan adalah babi. Sebab, meskipun berkuku belah, yaitu kukunya benar-benar terbelah, babi tidak memamah biak. Itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Jangan memakan daging hewan-hewan ini, dan jangan menyentuh bangkainya! Itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Inilah yang boleh kamu makan dari semua yang hidup di air: semua yang bersisik dan bersirip boleh kamu makan, baik yang hidup di laut maupun yang di sungai. ");
INSERT INTO indayt_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Akan tetapi, semua yang tidak bersisik dan tidak bersirip, yang hidup di laut atau di sungai, semua itu merupakan kejijikan bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Semua itu kejijikan bagimu. Jangan memakan dagingnya dan hindari bangkainya. ");
INSERT INTO indayt_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Semua yang hidup di air yang tidak bersisik dan tidak bersirip adalah kejijikan bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Inilah burung-burung yang harus kamu hindari dan tidak boleh dimakan dagingnya karena itu adalah kejijikan, yaitu rajawali, burung nasar, burung sikap, ");
INSERT INTO indayt_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","burung layang-layang, dan semua jenis alap-alap, ");
INSERT INTO indayt_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","semua jenis burung gagak, ");
INSERT INTO indayt_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","burung unta, burung hantu, camar, dan semua jenis burung elang, ");
INSERT INTO indayt_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","burung pungguk, burung dendang air, dan burung hantu besar, ");
INSERT INTO indayt_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","burung hantu putih, burung pelikan, burung ering, ");
INSERT INTO indayt_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","semua jenis burung bangau dan burung kuntul, burung upupa, dan kelelawar. ");
INSERT INTO indayt_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Semua serangga yang bersayap dan merayap dengan empat kakinya adalah kejijikan bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Inilah serangga bersayap yang berjalan dengan empat kakinya yang boleh kamu makan: Semua jenis serangga yang mempunyai paha untuk melompat di tanah boleh kamu makan. ");
INSERT INTO indayt_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Di antara semua serangga itu, inilah yang boleh kamu makan, yaitu semua jenis belalang, belalang pelahap dan semua jenisnya, belalang kunyit dan semua jenisnya, dan semua jenis belalang padi. ");
INSERT INTO indayt_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Hindarilah semua jenis serangga bersayap lain yang berkaki empat. ");
INSERT INTO indayt_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Serangga inilah yang dapat membuatmu najis. Jika kamu menyentuh bangkainya, kamu akan menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Setiap orang yang mengambil salah satu bangkai serangga itu harus mencuci pakaiannya dan ia menjadi najis sampai matahari terbenam.” ");
INSERT INTO indayt_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Semua binatang yang berkuku belah, tetapi kukunya tidak benar-benar terbelah, dan yang tidak memamah biak, haram bagimu. Setiap orang yang menyentuh binatang itu menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Juga, semua binatang yang berjalan dengan keempat telapak kakinya itu haram bagimu. Setiap orang yang menyentuh bangkai binatang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Setiap orang yang mengambil bangkai binatang itu harus mencuci pakaiannya dan menjadi najis sampai matahari terbenam. Semua binatang itu haram bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Inilah binatang yang haram bagimu di antara semua binatang yang merayap dan berkeriapan di tanah: tikus tanah, tikus, semua jenis kadal besar, ");
INSERT INTO indayt_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","tokek, biawak, kadal, kadal pasir, dan bunglon. ");
INSERT INTO indayt_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Itulah binatang merayap yang haram bagimu. Setiap orang yang menyentuh bangkai binatang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“Jika bangkai binatang itu jatuh ke atas sesuatu, baik itu barang dari kayu, pakaian, kulit, karung, atau perkakas apa pun yang digunakan, maka barang itu harus direndam dalam air, dan benda itu najis sampai matahari terbenam. Setelah itu, barang tersebut tahir kembali. ");
INSERT INTO indayt_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Jika bangkai salah satu binatang najis itu jatuh ke belanga tembikar, seluruh isinya akan menjadi najis. Dan, kamu harus memecahkan belanga itu. ");
INSERT INTO indayt_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Jika air dari belanga yang najis itu mengalir dan kena pada makanan yang boleh dimakan, makanan itu menjadi najis. Minuman apa pun yang dapat diminum dalam belanga yang najis itu akan menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Jika ada bagian dari bangkai binatang yang najis jatuh ke atas sesuatu, maka sesuatu itu menjadi najis. Jika itu adalah tungku dari tanah atau alat pemanggang, maka itu harus dipecahkan. Benda-benda itu akan tetap najis bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Akan tetapi, mata air atau sumur yang menampung air akan tetap tahir, sedangkan orang yang menyentuh bangkai binatang itu menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Jika bagian dari bangkai binatang najis itu jatuh ke atas benih yang akan ditanam, benih itu tetap tahir. ");
INSERT INTO indayt_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Akan tetapi, jika benih itu telah diberi air, dan bagian dari bangkai binatang itu jatuh ke atasnya, benih itu najis bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Jika binatang yang menjadi makananmu mati, orang yang menyentuh bangkainya menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Orang yang makan daging dari bangkai binatang itu harus mencuci pakaiannya dan ia menjadi najis sampai matahari terbenam. Jika seseorang mengambil bangkai itu, ia harus mencuci pakaiannya dan ia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Semua binatang merayap yang berkeriapan di tanah adalah kejijikan. Itu tidak boleh dimakan. ");
INSERT INTO indayt_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Semua binatang yang berjalan dengan perutnya, yang berjalan dengan keempat kakinya, atau yang mempunyai banyak kaki tidak boleh kamu makan. Sebab, semua binatang itu adalah kejijikan bagimu. ");
INSERT INTO indayt_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Jangan menajiskan dirimu sendiri dengan binatang yang merayap dan berkeriapan di tanah. Janganlah menajiskan dirimu dengan semua binatang itu sehingga kamu menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Akulah TUHAN, Allahmu. Karena itu, sucikan dirimu sehingga kamu menjadi kudus sebab Aku ini kudus. Janganlah menajiskan dirimu dengan semua binatang merayap yang mengeriap di tanah. ");
INSERT INTO indayt_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Sebab, Akulah TUHAN yang telah membawamu keluar dari negeri Mesir, untuk menjadi Allahmu. Jadi, kamu harus kudus sebab Aku ini kudus.’ ");
INSERT INTO indayt_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Itulah peraturan tentang binatang, burung, dan makhluk hidup yang di air, dan semua binatang yang merayap di tanah, ");
INSERT INTO indayt_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","untuk membedakan yang najis dan yang tahir, antara makhluk yang boleh dan tidak boleh dimakan.” ");
INSERT INTO indayt_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Katakanlah kepada bangsa Israel perkataan ini: ‘Apabila seorang perempuan mengandung dan melahirkan anak laki-laki, dia akan najis selama tujuh hari, sebagaimana ketika datang bulan, dia menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pada hari kedelapan, daging kulit khitan bayi itu harus disunat. ");
INSERT INTO indayt_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Perempuan itu harus tetap ada dalam penyucian nifasnya selama 33 hari. Dia tidak boleh menyentuh sesuatu yang dikuduskan atau masuk ke tempat kudus, sampai hari penyuciannya genap. ");
INSERT INTO indayt_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Akan tetapi, jika dia melahirkan bayi perempuan, dia menjadi najis selama 2 minggu, sebagaimana ketika datang bulan, dan dia harus tetap ada dalam masa penyucian dari nifasnya selama 66 hari. ");
INSERT INTO indayt_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Setelah masa penyuciannya genap, baik dia melahirkan anak laki-laki atau perempuan, dia harus membawa persembahan kepada imam di pintu tenda pertemuan, yaitu domba berumur setahun sebagai persembahan bakaran dan seekor merpati muda atau burung tekukur sebagai persembahan penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Imam harus mempersembahkannya di hadapan TUHAN dan mengadakan pendamaian untuk perempuan itu karena lelehan darahnya. Itulah hukum bagi dia yang melahirkan bayi laki-laki atau perempuan. ");
INSERT INTO indayt_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Jika dia tidak mampu menyediakan domba, dia boleh membawa dua ekor burung tekukur atau dua ekor burung merpati muda. Yang seekor untuk persembahan bakaran dan yang seekor untuk persembahan penghapus dosa, lalu imam harus mengadakan pendamaian baginya sehingga dia menjadi tahir.” ");
INSERT INTO indayt_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","TUHAN berfirman kepada Musa dan Harun, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Jika pada kulit tubuh seseorang terdapat bengkak, bintil, atau bercak terang, dan itu menjadi tanda penyakit kusta pada kulit tubuhnya, orang itu harus dibawa kepada Imam Harun atau kepada salah satu anaknya, para imam itu. ");
INSERT INTO indayt_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Imam harus memeriksa penyakit pada kulit tubuh orang itu. Jika rambut di bagian penyakit itu menjadi putih dan tampak lebih dalam dari kulit tubuhnya, itu adalah penyakit kusta. Bila imam telah memeriksa orang itu, dia harus menyatakan bahwa orang itu najis. ");
INSERT INTO indayt_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Jika bercak terang pada kulit tubuh orang itu tidak terlihat lebih dalam dari kulitnya, dan rambut pada bagian itu tidak menjadi putih, imam harus mengasingkan orang itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pada hari ketujuh, imam harus memeriksa orang itu lagi. Jika dalam pandangannya penyakit itu tetap tidak berubah dan penyakit itu tidak menyebar di kulit, imam harus mengasingkannya lagi selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Lalu, imam harus memeriksanya kembali pada hari yang ketujuh. Jika penyakit itu telah pudar dan tanda itu tidak menyebar di kulit, tujuh hari kemudian, imam harus memeriksanya lagi. Jika infeksi itu telah hilang dan tidak menyebar pada kulitnya, imam harus menyatakan bahwa orang itu tahir, itu hanya ruam. Lalu, dia harus mencuci pakaiannya dan menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Namun, jika infeksi kulit itu menyebar di kulit setelah dia menunjukkan dirinya kepada imam untuk penahirannya, dia harus menunjukkan dirinya kembali kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Imam harus memeriksanya dan jika infeksi kulit itu telah menyebar pada kulitnya, imam harus menyatakan bahwa orang itu najis. Itu adalah penyakit kusta. ");
INSERT INTO indayt_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Jika seseorang terjangkit penyakit kusta, dia harus dibawa kepada imam, ");
INSERT INTO indayt_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","lalu imam harus memeriksanya. Jika ada bengkak putih pada kulitnya dan telah berubah menjadi rambut yang putih, dan ada daging tumbuh pada bengkak itu, ");
INSERT INTO indayt_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","itu adalah penyakit kusta yang kronis pada kulit tubuhnya. Imam harus menyatakan bahwa orang itu najis. Imam tidak perlu mengasingkannya karena dia sudah najis. ");
INSERT INTO indayt_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Jika kusta itu telah pecah di kulit dan kusta itu menutupi seluruh kulit orang yang terjangkit itu dari kepala sampai kaki, sejauh yang dapat dilihat oleh imam, ");
INSERT INTO indayt_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","imam harus memeriksanya. Jika kusta itu telah menutupi seluruh tubuh orang itu, imam harus menyatakan bahwa orang itu tahir. Semuanya telah berubah menjadi putih, maka orang itu pun tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Namun, jika terlihat ada daging tumbuh, dia pun menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Bila imam melihat bagian yang terlihat dagingnya, dia harus menyatakan bahwa orang itu najis. Daging yang terlihat itu najis. Itulah penyakit kusta. ");
INSERT INTO indayt_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Jika daging tumbuh itu hilang dan berubah menjadi putih, orang itu harus menemui imam, ");
INSERT INTO indayt_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","lalu Imam harus memeriksanya. Jika penyakit itu telah menjadi putih, imam harus menyatakan bahwa orang itu tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Jika pada kulit seseorang timbul bisul dan telah sembuh, ");
INSERT INTO indayt_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","kemudian pada bekas bisul itu timbul bengkak berwarna putih atau bercak putih kemerah-merahan, itu harus ditunjukkan kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Imam harus memeriksanya, apabila bercak itu tampak lebih dalam dari kulit, dan rambut pada bagian itu menjadi putih, maka imam harus menyatakan bahwa orang itu najis. Itu adalah penyakit kusta yang muncul dari dalam bisul. ");
INSERT INTO indayt_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Namun, jika imam memeriksanya dan itu tidak lebih dalam dari kulit, rambut pada bagian itu tidak menjadi putih, tetapi telah memudar, imam harus mengasingkan orang itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Jika itu menyebar ke kulit, imam harus menyatakan bahwa orang itu najis, itu adalah penyakit. ");
INSERT INTO indayt_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Namun, jika bercak putih itu tetap di tempatnya dan tidak menyebar, itu adalah bekas bisul dan imam harus menyatakan bahwa orang itu tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Jika seseorang mengalami luka bakar pada kulitnya dan daging pada luka bakar itu menjadi putih atau putih kemerah-merahan, ");
INSERT INTO indayt_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","imam harus memeriksanya. Jika rambut pada bagian itu menjadi putih dan bercak itu terlihat lebih dalam daripada kulit, itu adalah kusta yang muncul dari luka bakar tadi. Lalu, imam harus menyatakan bahwa orang itu najis. Itu adalah penyakit kusta. ");
INSERT INTO indayt_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Namun, jika setelah diperiksa ternyata tidak ada rambut putih pada bercak dan tidak terlihat lebih dalam daripada kulit, bahkan memudar, imam harus mengasingkan orang itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pada hari yang ketujuh, imam harus memeriksa orang itu lagi. Jika bercak itu menyebar pada kulit, imam harus menyatakan bahwa orang itu najis. Itu adalah penyakit kusta. ");
INSERT INTO indayt_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Akan tetapi, jika bercak itu tidak menyebar di kulit, bahkan telah memudar, itu hanyalah bekas luka bakar. Imam harus menyatakan bahwa orang itu tahir hanya luka bakar. ");
INSERT INTO indayt_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Jika laki-laki atau perempuan terinfeksi pada kulit kepala atau pada dagunya, ");
INSERT INTO indayt_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","imam harus memeriksa infeksi tersebut. Jika infeksi itu terlihat lebih dalam daripada kulit, dan rambut pada bagian itu menjadi tipis dan kekuning-kuningan, imam harus menyatakan bahwa orang itu najis. Itu adalah kudis, penyakit kusta pada kepala atau dagu. ");
INSERT INTO indayt_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Jika penyakitnya tidak lebih dalam dari kulit dan tidak terdapat rambut hitam di situ, imam harus mengasingkan orang itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pada hari ketujuh, imam harus memeriksanya lagi. Jika kudis itu tidak menyebar dan tidak ada rambut kekuning-kuningan yang tumbuh pada bagian itu, serta kudis itu tidak terlihat lebih dalam daripada kulit, ");
INSERT INTO indayt_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","orang itu harus bercukur, tetapi bagian yang terdapat kudis tidak boleh dicukur. Lalu, imam harus mengasingkan orang yang berpenyakit kudis itu selama tujuh hari lagi. ");
INSERT INTO indayt_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Pada hari yang ketujuh, imam harus memeriksanya lagi. Jika kudis itu tidak menyebar di kulit dan tidak terlihat lebih dalam dari kulit, imam harus menyatakan bahwa orang itu tahir. Orang itu harus mencuci pakaiannya dan dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Namun, jika kudis itu menyebar pada kulitnya sesudah penahirannya, ");
INSERT INTO indayt_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","imam harus memeriksanya lagi. Jika kudis itu menyebar ke kulit, imam tidak perlu mencari rambut yang kekuning-kuningan. Orang itu najis. ");
INSERT INTO indayt_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Jika menurut pandangan imam, kudis itu tidak berubah dan ada rambut hitam yang tumbuh di situ, kudis itu telah sembuh dan orang itu tahir. Imam harus menyatakan bahwa orang itu tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Jika laki-laki atau perempuan terdapat bercak pada tubuhnya, bahkan bercak putih terang, ");
INSERT INTO indayt_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","imam harus memeriksanya. Jika bercak itu berwarna putih pucat, itu hanya ruam yang tidak berbahaya, yang timbul pada kulitnya. Orang itu tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Jika rambut kepala seseorang rontok sehingga dia menjadi botak, orang itu tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Jika rambut kepala seseorang rontok di dahinya sehingga dia mengalami botak pada dahinya, dia tahir. ");
INSERT INTO indayt_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Namun, jika pada bagian kepala yang botak atau pada dahi yang botak itu terdapat bercak putih yang kemerah-merahan, itu adalah penyakit kusta, yang muncul pada bagian kepala yang botak atau pada dahi yang botak itu. ");
INSERT INTO indayt_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Lalu, imam harus memeriksanya. Jika pembengkakan dari penyakit itu menjadi putih kemerah-merahan di kepala botaknya atau di dahi botaknya, tampak seperti kusta pada kulit tubuhnya, ");
INSERT INTO indayt_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","orang itu terjangkit penyakit kusta dan dia najis. Imam harus menyatakan bahwa orang itu najis karena kusta yang ada di kepalanya. ");
INSERT INTO indayt_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Orang yang menderita penyakit kusta harus memakai pakaian yang disobek-sobek, rambutnya dibiarkan terurai, dan menutupi mulutnya sambil berseru-seru, ‘Najis, najis!’ ");
INSERT INTO indayt_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Selama dia mengidap penyakit itu, dia najis. Dia memang najis dan harus tinggal terasing. Tempat tinggalnya adalah di luar perkemahan. ");
INSERT INTO indayt_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Jika terdapat tanda-tanda kusta pada pakaian, baik itu pakaian yang terbuat dari bulu domba atau linen, ");
INSERT INTO indayt_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","dari bahan tenunan atau rajutan, dari kulit atau apa pun yang terbuat dari kulit, ");
INSERT INTO indayt_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","jika tanda itu berwarna kehijauan atau kemerahan pada pakaian atau pada kulit, atau pada benang, atau pada benda apa pun dari kulit, itu adalah tanda penyakit kusta, dan itu harus diperlihatkan kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Imam harus memeriksa tanda penyakit itu dan mengasingkan benda yang memiliki tanda penyakit itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pada hari ketujuh, imam harus memeriksa tanda itu lagi, jika tanda penyakit itu telah menyebar pada pakaian, pada benang, atau pada kulit, apa pun kegunaan benda berbahan kulit itu, penyakit itu adalah kusta ganas dan itu najis. ");
INSERT INTO indayt_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Karena itu, imam harus membakar pakaian tersebut, atau benang, atau kain tenun dalam wol atau linen, atau benda apa pun berbahan kulit yang terdapat tanda itu, sebab itu adalah tanda kusta yang ganas. Pakaian itu harus dibakar dalam api. ");
INSERT INTO indayt_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Namun, jika imam telah memeriksa dan tanda penyakit itu tidak menyebar pada pakaian, pada benang, atau pada tenunan, atau pada apa pun yang terbuat dari kulit, ");
INSERT INTO indayt_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","imam harus memerintahkan mereka untuk mencuci tanda penyakit itu, lalu untuk kedua kali, dia harus mengasingkannya selama tujuh hari lagi. ");
INSERT INTO indayt_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Imam harus memeriksa kembali sesudah tanda penyakit itu dicuci. Jika tampaknya tanda penyakit itu tidak berubah meskipun tanda penyakit itu tidak menyebar, itu adalah najis. Kamu harus membakarnya dalam api, sebab tanda itu makin dalam di bagian belakang atau bagian depannya. ");
INSERT INTO indayt_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Jika imam telah memeriksa dan tanda penyakit itu telah memudar setelah dicuci, dia harus menyobek pakaian, atau kulit, atau benang, atau tenunan itu. ");
INSERT INTO indayt_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Jika tanda itu muncul kembali pada pakaian, pada benang, atau pada tenunan, atau dalam apa pun yang terbuat dari kulit, berarti tanda itu telah menyebar sehingga kamu harus membakar dengan api, apa pun yang terkena tanda itu ");
INSERT INTO indayt_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pakaian tersebut, atau benang, atau tenunan, atau benda apa pun yang terbuat dari kulit yang darinya tanda penyakit itu telah hilang ketika kamu mencucinya, kamu harus mencucinya kembali untuk kedua kalinya, dan barulah menjadi tahir.” ");
INSERT INTO indayt_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Itulah hukum mengenai tanda penyakit kusta pada pakaian, baik yang berbahan bulu domba atau linen, dari tenunan atau rajutan, ataupun dari semua yang berbahan kulit, untuk menyatakannya najis atau tahir. ");
INSERT INTO indayt_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","TUHAN berfirman kepada Musa, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ini harus menjadi hukum bagi penderita kusta pada masa penahirannya. Dia harus dibawa kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Imam harus menemui orang itu di luar perkemahan, lalu imam akan memeriksanya. Jika penderita kusta itu sudah sembuh dari sakit kustanya, ");
INSERT INTO indayt_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","imam harus menyuruh orang yang akan ditahirkan untuk membawa dua ekor burung hidup dan tahir, kayu cemara, kain merah, dan sebatang hisop. ");
INSERT INTO indayt_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Imam harus memerintahkan supaya seekor burung disembelih di atas belanga tembikar, di atas air yang mengalir. ");
INSERT INTO indayt_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Imam harus mengambil burung satunya yang masih hidup, kayu cemara, kain merah, dan hisop, lalu mencelupkan semua itu ke dalam darah burung yang telah disembelih di atas air yang mengalir tadi. ");
INSERT INTO indayt_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Dia harus memercikkan darah itu tujuh kali pada orang yang akan ditahirkan dari penyakit kusta, dan menyatakan bahwa orang itu tahir. Lalu, imam harus melepaskan burung yang hidup itu ke padang. ");
INSERT INTO indayt_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kemudian, orang yang akan ditahirkan itu harus mencuci pakaiannya, mencukur semua rambutnya, dan mandi dengan air. Maka, dia menjadi tahir. Sesudah itu, dia boleh masuk ke dalam perkemahan, tetapi harus tinggal di luar tendanya selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pada hari ketujuh, dia harus mencukur kepala, jenggot, alis, bahkan semua rambutnya. Lalu, dia harus mencuci pakaiannya dan mandi dengan air. Sesudah itu, dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Pada hari kedelapan, orang itu harus mengambil dua domba jantan yang tidak bercacat dan seekor domba betina yang tidak bercacat yang berumur setahun, dan 3/10 efa tepung halus yang dicampur dengan minyak sebagai kurban sajian dan satu log minyak. ");
INSERT INTO indayt_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Imam yang menyatakan orang itu tahir, harus membawa orang itu dan persembahannya ke hadapan TUHAN di pintu masuk tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Imam harus mengambil salah satu domba jantan itu beserta satu log minyak tadi dan mempersembahkannya sebagai kurban penghapus salah, serta mempersembahkannya sebagai persembahan unjukan di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Lalu, imam harus menyembelih domba jantan satunya di tempat dia menyembelih kurban penghapus dosa dan kurban bakaran di tempat kudus. Sebab, kurban penghapus salah adalah bagian imam, sama seperti kurban penghapus dosa. Itu adalah bagian mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Imam harus mengambil sebagian darah kurban penghapus salah dan mengoleskannya pada cuping telinga kanan dan pada jempol tangan dan kaki kanan orang yang akan ditahirkan. ");
INSERT INTO indayt_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Imam juga harus mengambil sebagian dari minyak tadi dan menuangkannya di telapak tangan kirinya. ");
INSERT INTO indayt_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kemudian, imam harus mencelupkan jari tangan kanannya ke dalam minyak yang ada pada telapak tangan kirinya. Dia harus memercikkan minyak itu dengan jarinya sebanyak tujuh kali di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Dengan sisa minyak yang ada di telapak tangan kirinya, imam harus mengoleskannya pada cuping telinga kanan orang yang akan ditahirkan, dan pada jempol tangan kanannya, dan pada jempol kaki kanannya, di atas darah persembahan penghapus salah. ");
INSERT INTO indayt_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sisa minyak yang ada di tangan imam harus dicurahkan pada kepala orang yang akan ditahirkan. Kemudian, imam harus mengadakan pendamaian bagi orang itu di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kemudian, imam harus mempersembahkan kurban penghapus dosa untuk pengampunan dosa orang yang akan ditahirkan dari kenajisannya. Sesudah itu, ia harus menyembelih kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Imam harus mempersembahkan kurban bakaran dan kurban sajian di atas mazbah. Begitulah imam mengadakan pengampunan dosa bagi orang itu sehingga dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Jika orang yang akan ditahirkan itu adalah orang miskin dan tidak mampu memberikan semua persembahan itu, maka dia harus membawa seekor domba jantan untuk kurban penghapus salah sebagai persembahan unjukan bagi pengampunan dosanya. Selain itu, dia harus membawa 1/10 efa tepung halus yang dicampur dengan minyak sebagai kurban sajian, satu log minyak, ");
INSERT INTO indayt_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","dan dua ekor burung tekukur atau dua ekor burung merpati muda sesuai kemampuannya. Yang seekor untuk kurban penghapus dosa dan yang seekor untuk kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Pada hari kedelapan, orang itu harus membawa kurban penahirannya kepada imam di pintu masuk tenda pertemuan, di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Imam harus mengambil domba kurban penghapus salah dan satu log minyak tadi. Dia harus mempersembahkannya sebagai kurban unjukan di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Berikutnya, imam harus menyembelih domba kurban penghapus salah dan mengambil sebagian darahnya. Dia harus mengoleskannya pada cuping telinga kanan dan jempol tangan kanan dan jempol kaki kanan orang yang akan ditahirkan. ");
INSERT INTO indayt_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Imam harus menuangkan sebagian minyak ke telapak tangan kirinya sendiri, ");
INSERT INTO indayt_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","dan dengan jari tangan kanannya, dia harus memercikkan sebagian minyak yang ada di tangan kirinya sebanyak tujuh kali di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Imam harus mengoleskan minyak yang ada di tangan kirinya pada cuping telinga kanan dan jempol tangan dan jempol kaki kanan orang yang akan ditahirkan, di tempat darah kurban penghapus salah dioleskan. ");
INSERT INTO indayt_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Sisa minyak yang ada di tangan imam harus dicurahkan pada kepala orang yang akan ditahirkan untuk mengadakan pengampunan dosa baginya di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Selanjutnya, imam harus mempersembahkan satu dari kedua ekor burung tekukur atau burung merpati muda, sesuai kemampuannya. ");
INSERT INTO indayt_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Yang seekor untuk kurban penghapus dosa dan yang seekor untuk kurban bakaran, bersama dengan kurban sajian. Demikianlah imam harus mengadakan pengampunan dosa untuk orang yang akan ditahirkan di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Itulah hukum bagi dia yang terjangkit penyakit kusta, yang tidak mampu memenuhi persembahan untuk penahirannya.” ");
INSERT INTO indayt_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Selanjutnya, TUHAN berfirman kepada Musa dan Harun, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Jika kamu memasuki tanah Kanaan yang akan Kuberikan kepadamu, dan Aku menaruh satu tanda penyakit kusta pada sebuah rumah di negeri itu, ");
INSERT INTO indayt_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","maka pemilik rumah itu harus memberitahukannya kepada imam, katanya, “Kelihatannya, ada tanda seperti penyakit kusta di rumahku.’ ");
INSERT INTO indayt_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Imam harus memerintahkan supaya rumah itu dikosongkan sebelum dia datang untuk memeriksa tanda itu. Dengan demikian, segala sesuatu yang ada di rumah itu tidak menjadi najis. Setelah itu, imam harus memeriksa rumah itu. ");
INSERT INTO indayt_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Imam harus memeriksa tanda itu. Jika tanda pada dinding rumah itu berupa lekuk-lekuk berwarna kehijauan atau kemerahan, dan terlihat lebih dalam dari permukaan dinding, ");
INSERT INTO indayt_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","dia harus keluar dari rumah itu menuju pintu rumah itu, lalu menutup rumah itu selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pada hari ketujuh, imam harus kembali dan memeriksa rumah itu lagi. Jika tanda itu menyebar ke dinding rumah, ");
INSERT INTO indayt_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","imam harus memerintahkan supaya bagian dinding yang terdapat tanda itu diambil batunya dan dibuang ke tempat yang najis di luar kota. ");
INSERT INTO indayt_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kemudian, dia harus memerintahkan agar bagian dalam rumah itu dikikis berkeliling, dan kikisan lepa itu harus dibuang ke tempat yang najis di luar kota. ");
INSERT INTO indayt_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Lalu, mereka harus memasang batu-batu lain untuk menggantikan batu yang telah diambil dan memasang lepa yang baru pada rumah itu. ");
INSERT INTO indayt_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Jika tanda itu muncul lagi setelah rumah itu diambil batunya, dikikis lepanya, dan setelah itu dipasang yang baru, ");
INSERT INTO indayt_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","imam harus datang dan memeriksanya lagi. Jika dia melihat bahwa tanda itu menyebar di dalam rumah, maka itu adalah penyakit kusta yang ganas di rumah itu. Jadi, itu najis. ");
INSERT INTO indayt_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Dia harus meruntuhkan rumah itu, seluruh batu, kayu, serta lepanya, dan dia harus membawanya ke tempat yang najis di luar kota. ");
INSERT INTO indayt_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Setiap orang yang masuk ke rumah itu ketika ditutup akan menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Setiap orang yang makan dan tidur di rumah itu harus mencuci pakaiannya. ");
INSERT INTO indayt_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Akan tetapi, jika imam datang untuk memeriksa kembali rumah itu dan mendapati bahwa tanda itu tidak menyebar sesudah dipasang lepa yang baru, imam harus menyatakan bahwa rumah itu tahir karena tanda itu tidak muncul lagi. ");
INSERT INTO indayt_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Untuk menahirkan rumah itu, imam harus mengambil dua ekor burung, kayu cemara, kain merah, hisop. ");
INSERT INTO indayt_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Dia harus menyembelih seekor burung dalam bejana tembikar di atas air yang mengalir. ");
INSERT INTO indayt_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kemudian, imam akan mengambil kayu cemara, hisop, kain merah, dan burung yang masih hidup lalu mencelupkan semuanya ke dalam darah burung yang disembelih di atas air mengalir tadi, lalu memercikkan darah itu pada rumah yang akan ditahirkan sebanyak tujuh kali. ");
INSERT INTO indayt_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Demikianlah imam menahirkan rumah itu dengan darah burung yang disembelih di atas air mengalir, bersama dengan burung yang masih hidup, kayu cemara, hisop, dan benang merah. ");
INSERT INTO indayt_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Imam harus melepaskan burung yang masih hidup itu di padang terbuka di luar kota. Dengan demikian, dia mengadakan pendamaian untuk rumah itu sehingga menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Itulah hukum tentang semua jenis tanda penyakit kusta, bahkan untuk kudis, ");
INSERT INTO indayt_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","tentang tanda kusta pada pakaian atau pada rumah, ");
INSERT INTO indayt_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","tentang bisul, bintik-bintik merah, atau bercak putih pada kulit, ");
INSERT INTO indayt_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","untuk memberi tahu apakah mereka najis atau tahir. Itulah hukum tentang kusta. ");
INSERT INTO indayt_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","TUHAN berfirman kepada Musa dan Harun, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Katakanlah kepada bangsa Israel: Bila seorang laki-laki mengeluarkan cairan dari kelaminnya, orang itu najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Inilah peraturan untuk kenajisannya dalam hal tersebut, baik yang keluar maupun yang ditahan. ");
INSERT INTO indayt_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Semua tempat tidur, benda yang ditiduri atau didudukinya menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Siapa pun yang menyentuh tempat tidurnya harus mencuci pakaiannya dan mandi dengan air. Orang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Dan, siapa pun yang duduk di tempat yang telah diduduki orang yang mengeluarkan cairan itu, harus mencuci pakaiannya dan mandi dengan air. Orang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Barang siapa menyentuh orang itu, harus mencuci pakaiannya dan mandi dengan air. Orang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Jika dia meludahi seseorang yang tahir, orang yang diludahi itu harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Semua pelana yang diduduki orang itu menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Siapa pun yang menyentuh segala sesuatu yang telah diduduki orang itu menjadi najis sampai matahari terbenam. Dan, orang yang membawa segala sesuatu yang pernah didudukinya harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Demikian juga, siapa pun yang disentuh oleh orang itu tanpa mencuci tangannya terlebih dahulu, dia harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Perkakas tembikar yang disentuh orang itu harus dipecahkan dan semua perkakas kayu yang disentuhnya harus dicuci dengan air. ");
INSERT INTO indayt_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Bila orang yang mengeluarkan cairan itu sudah bersih dari cairannya, dia harus melewati tujuh hari lagi untuk penahirannya. Dia harus mencuci pakaiannya dan mandi dengan air dengan air yang mengalir. Dengan demikian, dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pada hari yang kedelapan, dia harus membawa dua ekor burung tekukur atau dua ekor burung merpati muda dan datang ke hadapan TUHAN di pintu masuk tenda pertemuan. Dia harus menyerahkan kedua burung itu kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Imam harus mempersembahkan kedua burung itu, yang seekor untuk kurban penghapus dosa dan yang seekor untuk kurban bakaran. Demikianlah imam mengadakan pendamaian bagi orang yang mengeluarkan cairan itu di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Jika seorang laki-laki mengeluarkan cairan, dia harus mandi dengan air dan menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Jika cairan itu mengenai pakaian atau bahan kulit, pakaian atau bahan kulit itu harus dicuci dengan air dan menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Jika seorang laki-laki melakukan hubungan seksual dengan seorang perempuan, dan cairannya keluar, keduanya harus mandi dengan air dan mereka menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Jika seorang perempuan sedang haid, dia najis selama tujuh hari. Setiap orang yang menyentuhnya menjadi najis sampai sore. ");
INSERT INTO indayt_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Semua barang yang ditiduri perempuan itu selama haid akan menjadi najis. Dan semua barang yang dia duduki juga menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Siapa pun yang menyentuh tempat tidur perempuan itu harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Siapa pun yang menyentuh sesuatu yang sudah diduduki perempuan itu harus mencuci pakaiannya dan mandi dengan air. Dan, dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Jika seseorang menyentuh barang, baik yang ada di atas tempat tidur ataupun di atas tempat yang pernah diduduki perempuan itu, orang itu menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Jika seorang laki-laki melakukan hubungan seksual dengan seorang perempuan saat dia sedang haid, laki-laki itu menjadi najis selama tujuh hari. Setiap tempat tidur yang ditidurinya akan menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Jika seorang perempuan mengalami pendarahan selama berhari-hari, yang bukan pada masa haidnya, atau jika dia mengalami pendarahan setelah masa haidnya, dia menjadi najis selama pendarahan itu, sama seperti saat dia sedang haid. ");
INSERT INTO indayt_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Selama masa pendarahannya itu, setiap tempat tidur yang ditidurinya dan setiap barang yang didudukinya menjadi najis, sama seperti saat dia sedang haid. ");
INSERT INTO indayt_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Siapa pun yang menyentuh barang-barang itu menjadi najis, dia harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO indayt_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Setelah pendarahan wanita itu berhenti, dia harus menunggu selama tujuh hari. Sesudah itu, dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kemudian, pada hari kedelapan, perempuan itu harus membawa dua ekor burung tekukur atau dua ekor merpati muda kepada imam di pintu masuk tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Imam harus mempersembahkan yang seekor untuk kurban penghapus dosa dan yang lain untuk kurban bakaran. Dengan demikian imam mengadakan pendamaian bagi perempuan itu atas cairan kenajisannya di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Demikianlah kamu harus memisahkan anak-anak Israel dari kenajisan mereka sehingga mereka tidak mati dalam kenajisan karena menajiskan Tenda Suci-Ku yang ada di tengah-tengahmu!” ");
INSERT INTO indayt_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Itulah peraturan tentang orang yang mengeluarkan cairan, dan untuk laki-laki yang mengeluarkan cairan sehingga menyebabkan dia najis. ");
INSERT INTO indayt_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Itulah hukum tentang perempuan yang sedang haid, orang yang mengeluarkan cairan, baik laki-laki maupun perempuan, dan tentang laki-laki yang melakukan hubungan seksual dengan perempuan yang sedang najis. ");
INSERT INTO indayt_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","TUHAN berfirman kepada Musa sesudah kematian kedua anak Harun, ketika mereka menghampiri hadirat TUHAN dan mati. ");
INSERT INTO indayt_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","TUHAN berfirman kepada Musa, “Katakanlah kepada Harun, kakakmu, bahwa dia tidak boleh masuk sembarangan ke balik tirai, ke ruang mahakudus, ke hadapan tutup pendamaian di atas Tabut Perjanjian. Jika tidak demikian dia akan mati. Sebab, Aku akan menampakkan diri dalam awan di atas tutup pendamaian itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Harun harus masuk ke ruang kudus dengan membawa seekor sapi jantan untuk kurban penghapus dosa, dan seekor domba jantan untuk kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Dia harus mengenakan jubah linen yang kudus, pakaian dalam linen di baliknya, ikat pinggang linen, dan serban linen; inilah pakaian kudus. Sebelum mengenakan semua itu, dia harus mandi dengan air. ");
INSERT INTO indayt_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Dia harus mengambil dua ekor kambing jantan dari umat Israel untuk kurban penghapus dosa dan seekor domba jantan untuk kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Kemudian, Harun harus mempersembahkan sapi jantan itu untuk kurban penghapus dosa bagi dirinya sendiri, dan mengadakan pendamaian bagi dirinya sendiri dan bagi keluarganya. ");
INSERT INTO indayt_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Dia harus mengambil kedua kambing jantan dan membawanya ke hadapan TUHAN di pintu masuk tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Harun harus membuang undi terhadap kedua kambing jantan itu. Satu undi bagi TUHAN, yang lainnya bagi Azazel. ");
INSERT INTO indayt_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Harun harus mempersembahkan kambing yang terpilih bagi TUHAN sebagai kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Kambing yang terpilih bagi Azazel harus dibawa hidup-hidup ke hadapan TUHAN untuk mengadakan pendamaian. Kemudian, kambing itu harus dibawa keluar dan dilepaskan bagi Azazel di padang belantara. ");
INSERT INTO indayt_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Selanjutnya, Harun harus mempersembahkan sapi jantan muda sebagai kurban penghapus dosa bagi dirinya sendiri dan mengadakan pendamaian bagi dirinya dan keluarganya. Dia harus menyembelih sapi jantan muda kurban penghapus dosa bagi dirinya itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Dia harus mengambil pedupaan yang dipenuhi bara api dari atas mazbah di hadapan TUHAN dan segenggam kemenyan harum yang sudah digiling halus dan membawanya ke balik tirai. ");
INSERT INTO indayt_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Dia harus menaburkan kemenyan itu ke dalam bara api di hadapan TUHAN, supaya asap kemenyan itu menutupi tutup pendamaian yang ada di atas tabut kesaksian supaya dia tidak mati. ");
INSERT INTO indayt_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kemudian, dia harus mengambil sebagian darah sapi jantan dan memercikkannya ke tutup pendamaian sebelah timur dengan jarinya, juga bagian depan tutup pendamaian itu harus diperciki sebanyak tujuh kali. ");
INSERT INTO indayt_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Selanjutnya, Harun harus menyembelih kambing jantan kurban penghapus dosa yang diperuntukkan bagi seluruh umat dan membawa darahnya ke balik tirai, serta melakukan hal yang sama seperti yang dilakukannya dengan darah sapi jantan muda tadi. Dia harus memercikkan darah itu di atas tutup pendamaian dan pada bagian depan tutup pendamaian. ");
INSERT INTO indayt_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Demikianlah dia harus mengadakan pendamaian untuk ruang kudus karena kenajisan dan pelanggaran umat Israel sehubungan dengan dosa-dosa mereka. Dia juga harus mengadakan pendamaian untuk tenda pertemuan yang ada di tengah-tengah kenajisan mereka. ");
INSERT INTO indayt_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Selama dia berada di ruang kudus untuk mengadakan pendamaian, tidak seorang pun diperbolehkan berada di tenda pertemuan sebelum dia keluar dari sana. Dengan demikian Harun dapat mengadakan pendamaian bagi dirinya sendiri, keluarganya, dan seluruh umat Israel. ");
INSERT INTO indayt_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Kemudian, dia harus keluar menuju mazbah yang ada di hadapan TUHAN untuk mengadakan pendamaian bagi mazbah itu. Dia harus mengambil sebagian darah sapi jantan muda dan darah kambing jantan serta mengoleskannya ke tanduk-tanduk di keempat sudut mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Dia harus memercikkan sebagian darah ke mazbah dengan jarinya sebanyak tujuh kali. Dengan demikian, dia menahirkan dan menguduskan mazbah itu dari semua kenajisan umat Israel. ");
INSERT INTO indayt_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Setelah dia selesai mengadakan pendamaian untuk ruang kudus dan tenda pertemuan serta mazbah, dia harus mempersembahkan kambing jantan yang masih hidup itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Harun harus meletakkan kedua tangannya ke kepala kambing jantan itu dan mengakui segala kesalahan dan pelanggaran bangsa Israel; semua dosa mereka. Dia harus menanggungkan semua dosa itu ke kepala kambing jantan itu dan melepaskannya di padang gurun, melalui seorang yang telah disiapkan untuk itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Jadi, kambing itu akan menanggung segala kesalahan umat ke tanah yang sunyi. Orang yang membawa kambing itu harus melepaskannya di padang belantara. ");
INSERT INTO indayt_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Kemudian, Harun harus memasuki tenda pertemuan dan melepaskan pakaian putih yang dipakainya saat masuk ke ruang kudus lalu meninggalkannya di sana. ");
INSERT INTO indayt_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Dia harus mandi dengan air di tempat yang kudus dan memakai pakaiannya sendiri. Lalu, dia harus keluar dan mempersembahkan kurban bakaran untuk dirinya sendiri dan untuk seluruh umat. Dengan demikian dia mengadakan pendamaian untuk dirinya sendiri dan untuk umat itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Sesudah itu, dia harus membakar lemak kurban penghapus dosa di atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Orang yang melepaskan kambing jantan bagi Azazel harus mencuci pakaiannya dan mandi dengan air. Sesudah itu, dia boleh memasuki perkemahan. ");
INSERT INTO indayt_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Akan tetapi, sapi jantan muda dan kambing jantan kurban penghapus dosa, yang darahnya dibawa masuk ke ruang kudus untuk mengadakan pendamaian, harus dibawa ke luar perkemahan untuk dibakar kulit, daging, dan kotorannya. ");
INSERT INTO indayt_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Orang yang membakarnya harus mencuci pakaiannya dan mandi dengan air. Sesudah itu, dia boleh memasuki perkemahan. ");
INSERT INTO indayt_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Itulah peraturan yang berlaku selamanya bagimu: Pada hari ke-10 bulan ke-7, kamu harus merendahkan hatimu dan tidak mengerjakan pekerjaan apa pun, baik orang Israel asli ataupun pendatang yang ada di antaramu. ");
INSERT INTO indayt_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Karena pada hari itu, imam harus mengadakan pendamaian untuk menahirkanmu. Kamu akan ditahirkan dari segala dosamu di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hari itu harus menjadi Sabat, yaitu hari peristirahatan penuh bagimu. Kamu harus merendahkan dirimu. Itulah ketetapan untuk selama-lamanya. ");
INSERT INTO indayt_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Imam yang telah diurapi dan disahkan untuk melayani sebagai imam menggantikan ayahnya, harus mengenakan pakaian linen, yaitu pakaian kudus. ");
INSERT INTO indayt_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Dia harus mengadakan pendamaian untuk ruang kudus, tenda pertemuan, dan mazbah. Dia juga harus mengadakan pendamaian untuk para imam dan seluruh umat itu. ");
INSERT INTO indayt_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Peraturan ini harus berlaku selamanya untuk mengadakan pendamaian setiap tahun bagi umat Israel karena segala dosa mereka.” Jadi, Harun melakukan semuanya tepat seperti yang diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Katakanlah kepada Harun dan anak-anaknya, serta kepada seluruh umat Israel, ‘Inilah yang diperintahkan TUHAN, firman-Nya: ");
INSERT INTO indayt_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Setiap orang dari umat Israel yang menyembelih sapi, domba, atau kambing, baik di dalam ataupun di luar perkemahan, ");
INSERT INTO indayt_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","tanpa membawa hewan-hewan itu ke pintu tenda pertemuan untuk dipersembahkan sebagai kurban bagi TUHAN di depan Tenda Suci TUHAN, maka orang itu berutang darah karena dia telah menumpahkan darah. Orang itu harus dilenyapkan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Maksudnya ialah supaya orang Israel membawa kurban mereka yang biasa dipersembahkan di padang terbuka kepada TUHAN di pintu masuk tenda pertemuan, dan mempersembahkannya sebagai kurban pendamaian kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Imam harus memercikkan darahnya itu ke atas mazbah TUHAN di pintu masuk tenda pertemuan dan mempersembahkan lemaknya dalam api sebagai bau yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Jadi, mereka tidak boleh lagi mempersembahkan kurban kepada berhala, yang dengannya umat Israel berzina. Peraturan ini berlaku selamanya bagi mereka, dari generasi ke generasi.’ ");
INSERT INTO indayt_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Katakanlah kepada mereka: ‘Setiap orang Israel, atau pendatang yang ada di antara mereka, yang mempersembahkan kurban bakaran atau kurban sembelihan, ");
INSERT INTO indayt_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","tetapi tidak membawanya ke pintu tenda pertemuan untuk dipersembahkan kepada TUHAN, orang itu harus dilenyapkan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Setiap umat Israel, atau pendatang yang ada di antara mereka, yang makan darah, Aku sendiri akan memalingkan wajah-Ku dari orang yang makan darah itu dan melenyapkannya dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Sebab, nyawa makhluk terdapat dalam darahnya dan Aku telah memberikan darah itu kepadamu di atas mazbah, untuk mengadakan pendamaian bagi nyawamu. Sebab, darahlah yang mengadakan pendamaian bagi kehidupan.’ ");
INSERT INTO indayt_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Oleh sebab itu, Aku berkata kepada umat Israel, ‘Tidak seorang pun di antaramu boleh makan darah, pendatang yang ada di antaramu pun tidak boleh.’ ");
INSERT INTO indayt_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Jadi, setiap kali umat Israel atau pendatang di antara mereka berburu dan menangkap binatang liar atau burung yang boleh dimakan, maka dia harus menumpahkan darahnya itu dan menimbunnya dengan tanah. ");
INSERT INTO indayt_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Sebab, nyawa semua makhluk ada di dalam darahnya. Karena itu, Aku memerintahkan umat Israel, ‘Kalian tidak boleh makan darah apa pun. Setiap orang yang makan darah harus dilenyapkan. Sebab, nyawa semua makhluk ada dalam darahnya.’ ");
INSERT INTO indayt_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Jika seseorang, baik orang Israel ataupun pendatang, memakan bangkai binatang yang mati dengan sendirinya atau dimangsa binatang buas, orang itu harus mencuci pakaiannya dan mandi dengan air. Dia menjadi najis sampai sore hari. Setelah itu, dia menjadi tahir. ");
INSERT INTO indayt_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Jika dia tidak mencuci pakaiannya dan mandi dengan air, dia akan menanggung kesalahannya sendiri.” ");
INSERT INTO indayt_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Katakanlah kepada umat Israel perkataan ini: ‘Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Jangan lakukan apa yang dilakukan orang di Mesir, tempatmu dahulu tinggal. Juga jangan lakukan apa yang dilakukan orang di Kanaan, negeri ke mana Aku membawamu sekarang. Kalian tidak boleh mengikuti peraturan-peraturan mereka. ");
INSERT INTO indayt_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kalian harus melakukan peraturan-peraturan-Ku dan memelihara semua hukum-Ku. Hiduplah sesuai dengan semua itu. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Jadi, kamu harus memelihara semua hukum dan peraturan-Ku. Orang yang melakukannya akan hidup. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Jangan mengadakan hubungan seksual dengan sanak saudaramu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Jangan mengadakan hubungan seksual dengan istri ayahmu. Dia itu ibumu, jadi jangan mengadakan hubungan seksual dengan dia. ");
INSERT INTO indayt_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Jangan mengadakan hubungan seksual dengan istri ayahmu, walaupun dia bukan ibumu. Sebab, dia adalah milik ayahmu. ");
INSERT INTO indayt_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Jangan mengadakan hubungan seksual dengan saudaramu perempuan, baik itu anak perempuan ayahmu atau ibumu, baik yang lahir di rumahmu maupun di luar. ");
INSERT INTO indayt_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Jangan mengadakan hubungan seksual dengan cucumu perempuan, baik dari anakmu laki-laki atau anakmu perempuan. Jangan memberi aib keturunanmu. ");
INSERT INTO indayt_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Jika ayahmu dan istrinya mempunyai seorang anak perempuan, dia adalah saudarimu. Jangan mengadakan hubungan seksual dengan dia. ");
INSERT INTO indayt_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Jangan mengadakan hubungan seksual dengan saudara perempuan ayahmu. Dia adalah saudara kandung ayahmu. ");
INSERT INTO indayt_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Jangan mengadakan hubungan seksual dengan saudara perempuan ibumu. Sebab, dia adalah saudara kandung ibumu. ");
INSERT INTO indayt_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Jangan mendekati istri pamanmu untuk mengadakan hubungan seksual dengannya. Sebab, dia adalah bibimu. ");
INSERT INTO indayt_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Jangan mengadakan hubungan seksual dengan menantumu perempuan. Dia adalah istri anakmu, kamu tidak boleh mengadakan hubungan seksual dengannya. ");
INSERT INTO indayt_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Jangan mengadakan hubungan seksual dengan istri saudaramu laki-laki. Dia adalah milik saudaramu laki-laki. ");
INSERT INTO indayt_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Jangan mengadakan hubungan seksual dengan seorang ibu dan anaknya perempuan atau cucunya, baik cucu itu dari anaknya perempuan atau anaknya laki-laki. Mereka masih keluarga. Itu adalah perzinaan. ");
INSERT INTO indayt_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Selama istrimu masih hidup, jangan mengambil saudara perempuannya sebagai istri yang lain. Jangan mengadakan hubungan seksual dengan saudari istrimu. ");
INSERT INTO indayt_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Jangan mendekati seorang perempuan yang sedang dalam kenajisan haid untuk mengadakan hubungan seksual dengannya. ");
INSERT INTO indayt_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Jangan mengadakan hubungan seksual dengan istri sesamamu. Itu akan membuatmu najis dengannya. ");
INSERT INTO indayt_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Jangan menyerahkan keturunanmu untuk dipersembahkan kepada Molokh atau menajiskan nama Allahmu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Setiap laki-laki jangan mengadakan hubungan seksual dengan laki-laki, seperti dengan seorang perempuan. Itu adalah perbuatan yang sangat keji. ");
INSERT INTO indayt_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Jangan mengadakan hubungan seksual dengan binatang apa pun sehingga engkau menjadi najis. Hal itu adalah perbuatan yang sangat keji. ");
INSERT INTO indayt_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Jangan menajiskan dirimu dengan semua hal tadi. Sebab, dengan melakukan semua itu, bangsa-bangsa lain yang akan Kuusir dari hadapanmu telah menajiskan diri mereka. ");
INSERT INTO indayt_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Negeri itu telah menjadi najis. Oleh sebab itu, Aku menimpakan hukuman-Ku ke atasnya sehingga negeri itu memuntahkan penduduknya. ");
INSERT INTO indayt_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Akan tetapi, kamu harus memelihara semua peraturan dan hukum-Ku dan jangan melakukan semua kekejian tadi, baik umat Israel maupun pendatang yang ada di antaramu. ");
INSERT INTO indayt_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Sebab, penduduk sebelumnya yang tinggal di negeri itu telah melakukan semua kekejian itu. Dengan demikian, negeri mereka menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Jika kamu melakukan semua kenajisan itu, kamu akan membuat negeri itu najis. Dan, negeri itu akan memuntahkan kamu sebagaimana ia memuntahkan bangsa-bangsa sebelum kamu. ");
INSERT INTO indayt_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Setiap orang yang melakukan kekejian itu harus dilenyapkan dari antara umatnya. ");
INSERT INTO indayt_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Oleh karena itu, kamu harus menaati perintah-Ku supaya kamu tidak melakukan kekejian yang biasa dilakukan sebelum kamu. Jangan menajiskan dirimu dengan semua itu. Akulah TUHAN, Allahmu.” ");
INSERT INTO indayt_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","TUHAN berfirman kepada Musa, kata-Nya, ");
INSERT INTO indayt_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Katakanlah kepada seluruh umat Israel perkataan ini: ‘Akulah TUHAN, Allahmu. Haruslah kamu kudus, sebab Aku TUHAN, Allahmu, kudus. ");
INSERT INTO indayt_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Setiap orang di antara kamu harus menghormati ibu dan ayahnya dan tetap memelihara hari Sabat-Ku. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Jangan menyembah berhala-berhala. Jangan membuat patung tuangan bagimu. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Bila kamu mempersembahkan kurban pendamaian kepada TUHAN, kamu harus mempersembahkannya dengan benar supaya kamu diterima. ");
INSERT INTO indayt_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kurban itu harus dimakan pada hari kamu mempersembahkannya. Juga boleh dimakan keesokan harinya. Namun, jika ada sisa sampai hari ketiga, sisa itu harus dibakar habis dengan api. ");
INSERT INTO indayt_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Jika dimakan pada hari ketiga, kurban itu menjadi tercemar, dan tidak akan diterima. ");
INSERT INTO indayt_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Setiap orang yang memakannya akan menanggung kesalahannya. Sebab, dia telah menajiskan sesuatu yang kudus bagi TUHAN. Nyawa orang itu harus dilenyapkan dari bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Bila kamu memanen hasil ladangmu, jangan memanen seluruh ladang sampai ke ujungnya. Jangan memungut hasil panen yang tertinggal dari penuaianmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Jangan petik seluruh buah anggur dalam kebun anggurmu dan jangan pungut buah anggur yang jatuh ke tanah. Tinggalkanlah itu bagi orang miskin dan pendatang. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Jangan mencuri, jangan berbohong, jangan berdusta pada orang lain. ");
INSERT INTO indayt_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Jangan bersumpah palsu demi nama-Ku supaya kamu tidak mencemarkan nama Allahmu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Jangan menindas atau merampas sesamamu. Jangan menahan upah seorang buruh sepanjang malam sampai pagi. ");
INSERT INTO indayt_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Jangan mengutuki orang tuli. Jangan menaruh batu sandungan di depan orang buta. Akan tetapi, hormatilah Allahmu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Jangan melakukan kecurangan dalam pengadilan. Jangan berpihak, baik kepada orang miskin ataupun orang kaya dalam persidangan. Kamu harus mengadili sesamamu dengan adil. ");
INSERT INTO indayt_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Jangan menyebarkan fitnah tentang sesamamu. Jangan melakukan sesuatu yang membahayakan hidup sesamamu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Jangan membenci sesamamu di dalam hatimu. Namun, tegurlah dengan terus terang kesalahan yang mereka lakukan supaya kamu tidak berdosa karena orang itu. ");
INSERT INTO indayt_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Jangan membalas dendam dan jangan menyimpan dendam terhadap sesamamu. Akan tetapi, kasihilah sesamamu seperti dirimu sendiri. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Kamu harus memelihara semua hukum-Ku. Jangan mengawinkan dua jenis ternak yang berbeda. Jangan menaburi ladangmu dengan dua jenis bibit yang berbeda. Jangan mengenakan pakaian yang terbuat dari dua macam bahan yang berbeda. ");
INSERT INTO indayt_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Apabila seorang laki-laki mengadakan hubungan seksual dengan budak perempuan orang lain, yang belum ditebus atau dibebaskan, perbuatan itu harus mendapat hukuman. Namun, jangan dihukum mati karena budak perempuan itu belum dibebaskan. ");
INSERT INTO indayt_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Laki-laki itu harus membawa kurban penghapus salahnya kepada TUHAN di pintu masuk tenda pertemuan, yaitu seekor domba jantan untuk kurban penghapus salah. ");
INSERT INTO indayt_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Imam harus mengadakan pendamaian untuk orang itu atas dosa yang telah dilakukannya. Imam harus mempersembahkan domba jantan kurban penebus salah itu di hadapan TUHAN. Dengan demikian, orang itu akan diampuni dosanya. ");
INSERT INTO indayt_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kelak, ketika kamu memasuki negeri itu dan menanam berbagai macam pohon untuk makanan, kamu harus menganggap buahnya terlarang selama tiga tahun pertama. Itu tidak boleh kamu makan. ");
INSERT INTO indayt_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Namun, pada tahun keempat, semua buah pohon itu kudus dan harus dipersembahkan sebagai persembahan pujian bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pada tahun kelima, kamu boleh memakan buah dari pohon itu. Dan, pohon itu akan menghasilkan lebih banyak buah bagimu. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Jangan makan sesuatu yang masih ada darahnya. Jangan melakukan praktik perdukunan atau ramalan. ");
INSERT INTO indayt_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Jangan mencukur tepi rambut kepalamu dan tepi janggutmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Jangan melukai tubuhmu sebagai cara untuk mengenang orang mati. Jangan membuat tato pada tubuhmu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Jangan merusak kesucian anak perempuanmu dengan menjadikannya pelacur supaya negeri itu tidak melakukan pelacuran dan penuh dengan kejahatan. ");
INSERT INTO indayt_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kamu harus memelihara hari Sabat-Ku dan menghormati tempat kudus-Ku. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Jangan mencari peramal atau tukang sihir untuk meminta nasihat. Mereka hanya akan membuatmu najis. Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Berdirilah di hadapan orang tua, hormatilah mereka. Takutlah akan Allahmu. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Jika seorang pendatang tinggal di negerimu, janganlah menindasnya. ");
INSERT INTO indayt_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kamu harus memperlakukan mereka seperti saudara sebangsamu. Kasihilah mereka seperti dirimu sendiri. Ingatlah, dahulu kamu juga orang asing di Mesir. Akulah TUHAN, Allahmu! ");
INSERT INTO indayt_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Janganlah berbuat curang dalam persidangan, dalam hal ukuran, atau dalam hal timbangan dan sukatan. ");
INSERT INTO indayt_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Neraca dan timbanganmu harus seimbang, ukuran efa dan hinmu harus benar. Akulah TUHAN, Allahmu, yang membawamu keluar dari tanah Mesir. ");
INSERT INTO indayt_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kamu harus memelihara semua hukum dan peraturan-Ku serta melakukannya. Akulah TUHAN.’” ");
INSERT INTO indayt_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Katakanlah kepada umat Israel: ‘Setiap orang yang tinggal di Israel, baik warga Israel atau pendatang, yang menyerahkan anaknya kepada Molokh harus dihukum mati. Orang negeri itu harus merajamnya dengan batu. ");
INSERT INTO indayt_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Aku sendiri akan memalingkan wajah-Ku dari orang itu dan melenyapkan dia dari antara bangsanya. Sebab, dia telah menyerahkan anaknya kepada Molokh sehingga mencemarkan tempat kudus-Ku dan menajiskan nama-Ku yang kudus. ");
INSERT INTO indayt_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Akan tetapi, jika penduduk negeri itu tidak mau tahu terhadap orang itu ketika dia menyerahkan anaknya kepada Molokh, dan tidak menghukum mati dia, ");
INSERT INTO indayt_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Aku sendiri akan memalingkan wajah-Ku dari orang itu dan keluarganya. Aku akan melenyapkan semua orang yang ikut melakukan perzinaan dengan menyembah Molokh. ");
INSERT INTO indayt_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Bila seseorang berpaling kepada dukun dan peramal, orang itu telah berzina. Aku juga akan memalingkan wajah-Ku dari orang itu dan akan melenyapkannya dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Oleh sebab itu, kuduskanlah dirimu, jadilah kudus. Sebab, Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kamu harus memelihara semua hukum-Ku dan melakukannya. Akulah TUHAN yang menguduskanmu. ");
INSERT INTO indayt_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Setiap orang yang mengutuk ayah atau ibunya harus dihukum mati. Dia telah mengutuk ayah atau ibunya, dia sendiri yang menanggung utang darahnya. ");
INSERT INTO indayt_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Jika seorang laki-laki melakukan hubungan seksual dengan istri sesamanya, kedua pelaku perzinaan itu harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Jika seorang laki-laki melakukan hubungan seksual dengan istri ayahnya, kedua pelaku perzinaan harus dihukum mati. Mereka akan menanggung utang darahnya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Jika seorang laki-laki melakukan hubungan seksual dengan menantunya perempuan, keduanya harus dihukum mati. Mereka telah melakukan penyimpangan. Mereka akan menanggung utang darahnya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Jika seorang laki-laki melakukan hubungan seksual dengan sesama laki-laki seperti dengan seorang perempuan, keduanya telah melakukan kekejian. Mereka harus dihukum mati. Mereka akan menanggung utang darahnya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Jika seorang laki-laki menikahi seorang perempuan dan ibunya, itu adalah perbuatan mesum. Ketiganya harus dibakar supaya tidak ada perbuatan mesum di antara umatmu. ");
INSERT INTO indayt_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Jika seorang laki-laki melakukan hubungan seksual dengan seekor binatang, keduanya harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Jika seorang perempuan melakukan hubungan seksual dengan seekor binatang, kamu harus menghukum mati keduanya. Mereka akan menanggung utang darahnya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Jika seorang laki-laki menikahi saudara perempuannya, yaitu anak perempuan ayah atau ibunya, dan melakukan hubungan seksual dengannya, itu adalah aib. Mereka harus dilenyapkan di hadapan seluruh bangsanya. Laki-laki itu telah melakukan hubungan seksual dengan saudara perempuannya dan ia akan menanggung hukuman atas kesalahannya. ");
INSERT INTO indayt_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Jika seorang laki-laki melakukan hubungan seksual dengan seorang perempuan yang sedang haid, keduanya harus dilenyapkan dari antara bangsanya. Laki-laki itu telah membuka lelehan darahnya dan perempuan itu telah menunjukkan lelehan darahnya. ");
INSERT INTO indayt_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Jangan mengadakan hubungan seksual dengan bibimu, baik dari ayah maupun ibumu. Orang yang seperti itu telah membuat aib bagi kerabatnya. Keduanya akan menanggung hukuman atas kesalahan mereka. ");
INSERT INTO indayt_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Jika seseorang melakukan hubungan seksual dengan istri pamannya, ia telah membuat aib terhadap pamannya. Mereka akan menanggung kesalahan itu. Mereka akan mati tanpa memiliki anak. ");
INSERT INTO indayt_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Jika seseorang mengambil istri saudaranya, itu adalah suatu aib bagi saudaranya. Mereka tidak akan memiliki anak. ");
INSERT INTO indayt_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Oleh sebab itu, kamu harus memelihara seluruh hukum dan peraturan-Ku serta melakukannya supaya negeri yang akan Kuberikan kepadamu untuk ditinggali tidak memuntahkan kamu. ");
INSERT INTO indayt_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Janganlah kamu mengikuti kebiasaan bangsa yang akan Kuusir di hadapanmu. Sebab, mereka telah melakukan semua yang Aku larang itu sehingga Aku muak terhadap mereka. ");
INSERT INTO indayt_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Aku telah berkata kepadamu, ‘Kamu akan memiliki negeri mereka. Aku sendiri yang akan memberikannya kepadamu, yaitu negeri yang berlimpah susu dan madunya. Akulah TUHAN, Allahmu, yang telah memisahkanmu dari bangsa-bangsa lain’. ");
INSERT INTO indayt_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Oleh sebab itu, kamu harus membedakan hewan yang najis dan yang tahir, burung yang najis dan yang tahir. Jangan mencemari dirimu sendiri dengan hewan, burung, atau semua yang merayap di tanah, yang telah Kupisahkan sebagai binatang yang najis. ");
INSERT INTO indayt_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kuduslah kamu sebab Aku, TUHAN, adalah kudus. Aku telah memisahkanmu dari bangsa-bangsa lain untuk menjadi milik-Ku. ");
INSERT INTO indayt_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Jika seorang lelaki atau perempuan menjadi dukun dan peramal, dia harus dihukum mati dengan dirajam batu. Mereka akan menanggung utang darahnya sendiri.” ");
INSERT INTO indayt_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","TUHAN berfirman kepada Musa, “Katakanlah kepada para imam, yaitu anak-anak Harun, katakanlah, ‘Seorang imam tidak boleh menajiskan dirinya dengan menyentuh orang mati dari antara umatnya, ");
INSERT INTO indayt_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","kecuali keluarga dekatnya, yaitu ibu, ayah, anak laki-laki, anak perempuan, atau saudaranya laki-laki, ");
INSERT INTO indayt_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","saudaranya perempuan yang masih perawan, yang dekat dengannya karena belum memiliki suami. Untuknya imam boleh menajiskan diri. ");
INSERT INTO indayt_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Namun, sebagai seorang pemimpin di antara bangsanya, dia tidak boleh menajiskan dirinya sehingga dirinya tercemar. ");
INSERT INTO indayt_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Mereka tidak boleh menggundul kepalanya, mencukur tepi rambut dan tepi janggutnya, dan tidak boleh menggambari tubuhnya dengan goresan. ");
INSERT INTO indayt_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Para imam harus kudus bagi Allah dan tidak mencemarkan kekudusan nama Allah mereka. Sebab, merekalah yang mempersembahkan kurban bakaran TUHAN, yaitu hidangan bagi Allah mereka. Jadi, mereka harus kudus. ");
INSERT INTO indayt_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Seorang imam tidak boleh memperistri perempuan yang cemar atau pelacur. Dia juga tidak boleh menikah dengan wanita yang diceraikan suaminya. Sebab, imam itu harus kudus bagi Allahnya. ");
INSERT INTO indayt_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Oleh sebab itu, kamu harus menguduskan imam karena imamlah yang mempersembahkan hidangan bagi Allah. Imam harus kudus bagimu, sebab Aku, TUHAN, yang telah menguduskanmu, adalah kudus. ");
INSERT INTO indayt_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Jika anak perempuan imam melacurkan diri, anak itu telah mencemarkan ayahnya. Anak perempuan itu harus dibakar. ");
INSERT INTO indayt_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Imam yang menjadi kepala di antara saudara-saudaranya, yang memiliki pengurapan di atas kepalanya dan disahkan untuk memakai pakaian imam, tidak boleh membiarkan rambutnya terurai dan merobek pakaiannya. ");
INSERT INTO indayt_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Dia tidak boleh menajiskan dirinya dengan menyentuh orang mati, bahkan jika itu adalah ayah atau ibunya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Dia tidak boleh meninggalkan tempat kudus Allah atau mencemarkannya. Sebab, minyak urapan Allah yang menjadi tanda bahwa dia telah dikuduskan telah ada padanya. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Dia harus menikah dengan perempuan yang masih perawan. ");
INSERT INTO indayt_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Seorang janda atau seorang perempuan yang diceraikan, atau perempuan yang cemar karena menjadi pelacur, tidak boleh diambil menjadi istri. Imam harus menikah dengan perempuan yang masih perawan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Dengan demikian, imam tidak akan mencemarkan keturunannya di antara umatnya. Sebab, Akulah TUHAN yang menguduskannya.’” ");
INSERT INTO indayt_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Katakanlah kepada Harun: ‘Jika salah satu keturunanmu ada yang cacat fisik, dia tidak boleh mendekat untuk mempersembahkan hidangan bagi Allah. ");
INSERT INTO indayt_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Sebab, orang yang cacat tidak boleh mendekat: orang buta, orang lumpuh, orang yang mempunyai cacat pada wajahnya, orang yang mempunyai anggota tubuh terlalu panjang, ");
INSERT INTO indayt_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","orang yang kaki atau tangannya patah, ");
INSERT INTO indayt_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","orang yang bungkuk, orang kerdil, orang yang bermata juling, orang yang berbintil-bintil atau berpenyakit kulit, dan orang yang rusak buah pelirnya. ");
INSERT INTO indayt_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Tidak seorang pun dari antara keturunan Imam Harun yang bercacat tubuhnya boleh mendekati mazbah untuk mempersembahkan kurban bakaran bagi TUHAN. Karena dia cacat, dia tidak boleh mendekat untuk mempersembahkan hidangan bagi Allah. ");
INSERT INTO indayt_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Dia boleh makan hidangan yang dipersembahkan kepada Allah, baik dari persembahan kudus ataupun dari persembahan mahakudus. ");
INSERT INTO indayt_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Dia tidak boleh mendekati mazbah atau melewati tirai karena dia cacat. Dengan demikian, dia tidak akan mencemarkan tempat kudus-Ku. Akulah TUHAN yang menguduskan mereka.’” ");
INSERT INTO indayt_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Demikianlah Musa menyampaikan semua perkataan itu kepada Harun, anak-anaknya, dan seluruh orang Israel. ");
INSERT INTO indayt_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Katakanlah kepada Harun dan anak-anaknya supaya mereka mendedikasikan diri untuk semua persembahan kudus yang diberikan umat Israel kepada-Ku, sehingga mereka tidak mencemarkan nama-Ku yang kudus. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Katakanlah kepada mereka semua, ‘Jika ada seorang dari keturunanmu mendekati persembahan kudus Israel bagi TUHAN dalam keadaan najis, orang itu harus dilenyapkan dari hadapan-Ku. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Tidak seorang pun dari keturunan Harun yang sakit kusta atau sedang najis boleh makan persembahkan kudus, sebelum dia menjadi tahir. Jika seseorang menyentuh sesuatu yang najis karena terkena mayat, atau jika dia mengeluarkan mani, ");
INSERT INTO indayt_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","atau orang yang menyentuh binatang merayap atau manusia yang membuatnya najis, apa pun bentuk kenajisannya, ");
INSERT INTO indayt_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","orang itu menjadi najis sampai matahari terbenam. Dia tidak boleh makan dari persembahan kudus tadi sebelum dia mandi dengan air. ");
INSERT INTO indayt_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Namun, setelah matahari terbenam, dia menjadi tahir. Sesudah itu, dia boleh makan dari persembahan kudus karena itu memang makanannya. ");
INSERT INTO indayt_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Dia tidak boleh memakan binatang yang sudah mati atau diterkam binatang buas, dengan demikian dia menjadi najis. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Mereka harus melakukan tanggung jawabnya terhadap-Ku, supaya mereka tidak menanggung dosa dan mati karena mencemarkannya. Akulah TUHAN yang menguduskan mereka. ");
INSERT INTO indayt_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Orang asing tidak boleh makan persembahan kudus itu, termasuk pendatang yang menjadi tamu imam ataupun seorang buruh. ");
INSERT INTO indayt_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Namun, budak yang telah dibeli imam dengan uangnya sendiri atau yang lahir di rumahnya boleh ikut memakannya. ");
INSERT INTO indayt_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Apabila anak perempuan imam menikah dengan orang biasa, perempuan itu tidak boleh makan dari persembahan kudus. ");
INSERT INTO indayt_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Namun, bila anak perempuan imam menjadi janda atau diceraikan, dan tidak mempunyai keturunan sehingga dia kembali kepada ayahnya seperti saat belum menikah, dia boleh makan makanan ayahnya. Akan tetapi, orang asing tidak boleh makan persembahan itu. ");
INSERT INTO indayt_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Jika seseorang tidak sengaja memakan persembahan kudus, dia harus mengganti persembahan itu dengan menambah 1/5 dari persembahan kudus tadi dan memberikannya kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Imam tidak boleh mencemarkan persembahan kudus yang diberikan umat Israel sebagai persembahan kepada TUHAN, ");
INSERT INTO indayt_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","supaya mereka tidak menanggung hukuman atas kesalahan mereka karena memakan persembahan kudus. Akulah TUHAN yang menguduskan mereka.’” ");
INSERT INTO indayt_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Katakanlah kepada Harun dan anak-anaknya, serta kepada seluruh umat Israel: ‘Setiap orang, baik warga Israel maupun pendatang di Israel, yang ingin memberikan persembahannya kepada TUHAN sebagai kurban bakaran, baik itu persembahan nazar ataupun persembahan sukarela, ");
INSERT INTO indayt_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","supaya diperkenan, persembahan itu harus yang jantan dari antara sapi, domba, atau kambingnya yang tidak bercacat. ");
INSERT INTO indayt_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Semua hewan yang bercacat tidak boleh dipersembahkan. Sebab, itu tidak akan diperkenan darimu. ");
INSERT INTO indayt_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Apabila seseorang mempersembahkan kurban pendamaian kepada TUHAN untuk memenuhi nazarnya, atau sebagai persembahan sukarela, yang diambil dari antara kawanan ternaknya, hewan itu haruslah yang terbaik dan tidak bercacat supaya diperkenan. ");
INSERT INTO indayt_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Hewan yang buta, tulangnya patah, cacat, pincang, terluka, atau berpenyakit kulit, semua itu tidak boleh kamu persembahkan kepada TUHAN ataupun dijadikan kurban bakaran di atas mazbah bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Seekor sapi atau anak domba dengan kaki yang terlalu panjang, atau kaki yang tidak tumbuh sempurna boleh kamu persembahkan sebagai persembahan sukarela. Namun, itu tidak boleh dipersembahkan sebagai persembahan nazar. ");
INSERT INTO indayt_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Jika seekor binatang yang pelirnya memar, hancur, robek, atau dikebiri jangan kamu persembahkan kepada TUHAN. Kamu tidak boleh melakukan hal ini di negerimu. ");
INSERT INTO indayt_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Jangan kamu terima binatang seperti itu dari tangan orang asing sebagai hidangan bagi Allahmu. Sebab, semua binatang itu bercela dan memiliki cacat, itu tidak akan diperkenan darimu.’” ");
INSERT INTO indayt_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Bila lahir seekor sapi, domba, atau kambing, anak hewan itu harus tinggal bersama induknya selama tujuh hari. Sejak hari kedelapan dan seterusnya, hewan itu dikenan TUHAN untuk dipersembahkan sebagai kurban bakaran. ");
INSERT INTO indayt_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Jangan menyembelih induk dan anaknya pada hari yang sama, baik itu sapi maupun domba. ");
INSERT INTO indayt_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Apabila kamu mempersembahkan kurban syukur kepada TUHAN, kamu harus mempersembahkannya dengan cara yang berkenan kepada-Nya. ");
INSERT INTO indayt_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kurban itu harus dimakan pada hari itu juga. Jangan menyisakannya sampai pagi. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Kamu harus memelihara hukum-hukum-Ku dan melakukannya. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Jangan mencemarkan nama-Ku yang kudus supaya Aku ditinggikan di antara orang Israel. Akulah TUHAN yang menguduskanmu, ");
INSERT INTO indayt_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","yang telah membawamu keluar dari negeri Mesir untuk menjadi Allahmu. Akulah TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Katakanlah kepada umat Israel: ‘Inilah perayaan yang ditetapkan TUHAN yang harus kamu nyatakan sebagai pertemuan kudus, semua ini perayaan yang Aku tetapkan: ");
INSERT INTO indayt_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Kamu boleh bekerja selama enam hari, tetapi hari yang ketujuh merupakan Sabat, hari peristirahatan penuh. Kamu harus menggunakan hari itu sebagai hari pertemuan kudus. Kamu tidak boleh melakukan pekerjaan apa pun pada hari itu. Sebab, itu adalah hari Sabat bagi TUHAN di seluruh kediamanmu. ");
INSERT INTO indayt_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Inilah hari yang ditetapkan TUHAN sebagai pertemuan kudus, yang harus kamu nyatakan pada hari yang telah ditetapkan. ");
INSERT INTO indayt_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Petang hari, hari ke-14 bulan pertama adalah Hari Pesakh TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Pada hari ke-15 bulan yang sama adalah hari raya Roti Tidak Beragi bagi TUHAN. Kamu harus makan roti tidak beragi selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Pada hari pertama perayaan itu, kamu harus mengadakan pertemuan kudus. Jangan melakukan pekerjaan berat pada hari itu. ");
INSERT INTO indayt_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Selama tujuh hari kamu harus mempersembahkan kurban bakaran kepada TUHAN. Pada hari ketujuh, kamu harus mengadakan pertemuan kudus. Janganlah melakukan semua pekerjaan yang berat.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Katakanlah kepada umat Israel: Ketika kamu memasuki negeri yang akan Kuberikan kepadamu dan menuai panen negeri itu, kamu harus membawa seikat hasil panen pertamamu kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Imam akan mengunjukkan berkas itu di hadapan TUHAN agar dikenan. Imam harus mengunjukkannya setelah hari Sabat. ");
INSERT INTO indayt_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pada hari kamu mengunjukkan berkas itu, kamu harus mempersembahkan domba jantan berumur setahun yang tidak bercacat sebagai kurban bakaran bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kamu juga harus mempersembahkan kurban sajian berupa 2/10 efa tepung halus, yang dicampur dengan minyak sebagai kurban bakaran yang baunya menyenangkan bagi TUHAN. Itu harus dipersembahkan bersama kurban curahan yang berupa 1/4 hin anggur. ");
INSERT INTO indayt_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Jangan makan roti, atau biji-bijian, atau gandum baru itu, sebelum kamu memberikan persembahan kepada Allahmu. Peraturan ini berlaku selamanya, dari generasi ke generasi, di mana pun kamu tinggal. ");
INSERT INTO indayt_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Setelah hari Sabat, yaitu setelah kamu membawa berkasmu sebagai persembahan unjukan, kamu harus menghitung sampai genap tujuh minggu. ");
INSERT INTO indayt_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Setelah genap tujuh minggu, kamu harus menghitung 50 hari lagi untuk mempersembahkan kurban sajian yang baru kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Pada hari itu, bawalah dua roti dari rumahmu sebagai persembahan unjukan. Roti itu harus dibuat dari 2/10 efa tepung halus, yang dipanggang dengan ragi sebagai hasil pertama bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bersama roti itu, kamu harus mempersembahkan tujuh ekor domba berumur setahun yang tidak bercacat, seekor sapi jantan muda, dan dua ekor domba jantan. Hewan-hewan itu harus dipersembahkan sebagai kurban bakaran kepada TUHAN bersama kurban sajian dan kurban curahan. Itulah kurban bakaran yang harum baunya bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kamu juga harus mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa dan dua ekor domba jantan berumur setahun sebagai kurban pendamaian. ");
INSERT INTO indayt_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Lalu, imam harus mengunjukkan persembahan itu bersama roti dari hasil pertamamu sebagai persembahan unjukan di hadapan TUHAN, bersama kedua ekor domba tadi. Semua itu kudus bagi TUHAN. Itulah yang akan menjadi bagian imam. ");
INSERT INTO indayt_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Pada hari itu juga, kamu harus membuat satu pernyataan bahwa akan ada pertemuan kudus. Jangan melakukan pekerjaan berat pada hari itu. Ini akan menjadi peraturan yang berlaku selamanya, dari generasi ke generasi, di mana pun kamu tinggal. ");
INSERT INTO indayt_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Apabila kamu menuai hasil panen dari tanahmu, janganlah menuainya habis sampai ke tepi-tepi ladangmu. Jangan mengambil gandum yang telah jatuh ke tanah. Tinggalkanlah itu untuk orang miskin dan orang asing di negerimu. Akulah TUHAN, Allahmu.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Katakanlah kepada umat Israel: ‘Pada hari pertama bulan ketujuh, kamu harus mengadakan hari perhentian penuh. Tiuplah trompet untuk mengingatkan umat bahwa itu adalah hari pertemuan kudus. ");
INSERT INTO indayt_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Janganlah melakukan pekerjaan berat pada hari itu, tetapi kamu harus mempersembahkan kurban bakaran kepada TUHAN.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","‘Tepat pada hari ke-10 bulan ketujuh adalah hari pendamaian. Itu harus menjadi hari pertemuan kudus bagimu. Kamu harus merendahkan diri dan mempersembahkan kurban bakaran kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Jangan melakukan pekerjaan apa pun pada hari itu, sebab hari itu adalah Hari Pendamaian untuk mengadakan pendamaian bagimu di hadapan TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Jika ada seseorang yang tidak merendahkan dirinya pada hari itu, orang itu harus dilenyapkan dari antara umatnya. ");
INSERT INTO indayt_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Jika seseorang melakukan pekerjaan pada hari itu, Aku akan membinasakan orang itu dari antara umatnya. ");
INSERT INTO indayt_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Kamu tidak boleh melakukan pekerjaan apa pun. Ini harus menjadi peraturan untuk selamanya, dari generasi ke generasi, di mana pun kamu tinggal. ");
INSERT INTO indayt_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hari itu harus menjadi Sabat, suatu perhentian penuh bagimu untuk merendahkan diri. Pada hari ke-9 bulan itu, kamu harus merayakan Sabat dari matahari terbenam sampai matahari terbenam.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Katakanlah kepada umat Israel: ‘Hari ke-15 bulan 7 adalah hari raya Pondok Daun bagi TUHAN selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Hari pertama dari ketujuh hari itu merupakan hari pertemuan kudus. Jangan melakukan pekerjaan berat pada hari itu. ");
INSERT INTO indayt_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Selama tujuh hari, kamu harus mempersembahkan kurban bakaran kepada TUHAN. Pada hari kedelapan, kamu harus mengadakan pertemuan kudus yang lain dan mempersembahkan kurban bakaran kepada TUHAN. Itu adalah pertemuan raya. Jangan melakukan pekerjaan berat pada hari itu.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Itulah hari-hari perayaan yang ditetapkan TUHAN, yang harus kamu nyatakan sebagai pertemuan kudus untuk mempersembahkan kurban bakaran kepada TUHAN. Kurban-kurban itu adalah kurban bakaran dan kurban sajian, kurban sembelihan dan kurban curahan, masing-masing sesuai dengan hari yang telah ditetapkan. ");
INSERT INTO indayt_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Semua hari raya itu adalah hari raya di luar hari Sabat TUHAN, di samping semua persembahan yang kamu berikan kepada TUHAN, kurban nazar, dan kurban sukarelamu. ");
INSERT INTO indayt_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Tepat pada hari ke-15 bulan ketujuh, saat kamu mengumpulkan panen yang dihasilkan tanahmu, kamu harus merayakan perayaan bagi TUHAN selama tujuh hari. Hari pertama dan hari kedelapan harus kamu jadikan sebagai hari peristirahatan penuh. ");
INSERT INTO indayt_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pada hari pertama, kamu harus mengambil buah-buah dari pohon-pohon yang indah, pelepah pohon kurma, ranting-ranting pohon yang rindang, dan pohon gandarusa. Kamu harus bersukaria di hadapan TUHAN, Allahmu, selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kamu harus merayakannya sebagai perayaan bagi TUHAN selama tujuh hari setiap tahun. Ini harus menjadi peraturan yang berlaku selamanya, dari generasi ke generasi. Kamu harus merayakannya pada bulan ketujuh. ");
INSERT INTO indayt_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Kamu harus tinggal di pondok-pondok selama tujuh hari. Semua orang Israel asli harus tinggal di dalam pondok, ");
INSERT INTO indayt_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","supaya keturunanmu mengetahui bahwa Aku pernah menyuruh umat Israel tinggal di dalam pondok-pondok ketika Aku membawa mereka keluar dari negeri Mesir. Akulah TUHAN, Allahmu.’” ");
INSERT INTO indayt_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Demikianlah Musa mengumumkan kepada umat Israel semua perayaan bagi TUHAN itu. ");
INSERT INTO indayt_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Perintahkan umat Israel untuk membawa kepadamu minyak zaitun tumbuk yang murni untuk penerangan supaya lampu tetap menyala. ");
INSERT INTO indayt_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Harun harus mengatur lampu itu di bagian luar tirai yang menutupi Tabut Perjanjian dalam tenda pertemuan di hadapan TUHAN dari petang sampai pagi. Peraturan ini berlaku selamanya, dari generasi ke generasi. ");
INSERT INTO indayt_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Dia harus senantiasa mengatur lampu-lampu itu di atas tatakan lampu yang terbuat dari emas murni, di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ambillah tepung halus dan pangganglah 12 kue dari tepung itu. Masing-masing kue dibuat dari 2/10 efa tepung. ");
INSERT INTO indayt_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tatalah kue-kue itu menjadi dua baris di atas meja emas murni, di hadapan TUHAN, enam roti untuk setiap barisnya. ");
INSERT INTO indayt_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Taruhlah kemenyan murni pada setiap barisnya. Itu akan menjadi bagian pengingat dari kue-kue itu, sebagai kurban bakaran bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Setiap hari Sabat, dia harus menata kue-kue itu secara teratur di hadapan TUHAN. Itu merupakan perjanjian bagi umat Israel selama-lamanya. ");
INSERT INTO indayt_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Itu akan menjadi bagian Harun dan anak-anaknya. Mereka harus memakannya di tempat yang kudus, bagian mahakudus dari kurban bakaran TUHAN. Itu akan menjadi bagiannya selamanya.” ");
INSERT INTO indayt_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Suatu hari, ada seorang anak laki-laki, ibunya orang Israel dan ayahnya orang Mesir. Dia berkelahi dengan seorang Israel di perkemahan. ");
INSERT INTO indayt_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Anak dari perempuan Israel itu mulai menghujat dan mengutuki nama TUHAN. Lalu, anak itu dibawa menghadap Musa. Ibunya bernama Selomit, anak Dibri, dari suku Dan. ");
INSERT INTO indayt_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mereka memasukkan anak itu dalam tahanan untuk menantikan keputusan berdasarkan perintah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Bawalah orang yang menghujat itu ke suatu tempat di luar perkemahan. Suruhlah semua orang yang mendengarnya menghujat untuk meletakkan tangan mereka ke atas kepala orang itu. Kemudian, biarlah seluruh umat merajamnya.” ");
INSERT INTO indayt_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Katakanlah kepada umat Israel: ‘Siapa pun yang menghujat Allah, dia harus menanggung dosanya. ");
INSERT INTO indayt_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Setiap orang yang menghujat nama TUHAN harus dihukum mati. Seluruh umat harus merajam orang itu. Baik orang Israel maupun orang asing yang menghujat TUHAN harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Jika seseorang membunuh sesamanya, dia harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Setiap orang yang membunuh ternak harus menggantinya, nyawa ganti nyawa. ");
INSERT INTO indayt_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Jika seseorang melukai sesamanya, apa pun yang dilakukannya, orang itu harus diperlakukan sama seperti perbuatannya. ");
INSERT INTO indayt_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Patah ganti patah, mata ganti mata, gigi ganti gigi. Luka yang diberikan seseorang kepada orang lain, harus diberikan juga kepadanya. ");
INSERT INTO indayt_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Karena itu, seseorang yang membunuh ternak harus menggantinya. Namun, setiap orang yang membunuh sesamanya harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Satu hukum berlaku untuk semua orang, baik orang Israel maupun pendatang. Akulah TUHAN, Allahmu.’” ");
INSERT INTO indayt_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Kemudian, Musa menyampaikan hal itu kepada umat Israel. Maka, mereka membawa anak laki-laki yang menghujat itu ke luar perkemahan dan merajamnya. Begitulah dilakukan umat Israel, seperti yang diperintahkan TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","TUHAN berfirman kepada Musa di Gunung Sinai, ");
INSERT INTO indayt_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Katakanlah kepada umat Israel: ‘Apabila kamu memasuki negeri yang akan Kuberikan kepadamu, negeri itu harus diberi masa istirahat sebagai Sabat bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Selama enam tahun kamu harus menabur benih di ladangmu dan enam tahun juga kamu memanen kebun anggurmu serta mengumpulkan hasil panennya. ");
INSERT INTO indayt_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Namun, selama tahun ketujuh, tanah itu harus mendapatkan masa istirahat, Sabat bagi TUHAN. Kamu tidak boleh menabur benih di ladangmu atau memanen kebun anggurmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Jangan memanen segala sesuatu yang tumbuh sendiri setelah masa panenmu ataupun mengumpulkan buah anggur dari pohon anggur yang tidak dipangkas daunnya. Tanah itu harus diberikan masa istirahat selama tahun Sabat. ");
INSERT INTO indayt_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Seluruh hasil tanah itu selama tahun Sabat akan menjadi makanan bagimu sendiri, bagi hamba-hambamu, orang-orang yang bekerja padamu, ataupun bagi orang asing yang tinggal bersamamu. ");
INSERT INTO indayt_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Bahkan, ternak dan semua binatang yang ada di negerimu boleh makan semua hasil tanah itu. ");
INSERT INTO indayt_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Kamu harus menghitung tujuh tahun Sabat, yaitu tujuh kali tujuh tahun. Jadi, jumlah tujuh tahun Sabat itu adalah 49 tahun. ");
INSERT INTO indayt_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Pada hari ke-10 bulan tujuh, kamu harus meniup trompet dengan keras. Pada hari raya Pendamaian kamu harus meniupnya di seluruh negeri. ");
INSERT INTO indayt_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kamu harus menguduskan tahun kelima puluh dan menyatakan pembebasan bagi seluruh penduduk negerimu. Itulah tahun Yobel bagimu. Setiap orang akan kembali ke tanah miliknya dan kepada keluarganya. ");
INSERT INTO indayt_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Tahun kelima puluh harus menjadi tahun Yobel bagimu. Jangan menabur atau menuai hasil yang tumbuh dengan sendirinya. Juga jangan memanen buah anggur dari ranting yang tidak dipangkas. ");
INSERT INTO indayt_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Sebab, itu adalah tahun Yobel dan haruslah itu menjadi tahun yang kudus bagimu. Kamu boleh makan dari hasil ladangmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Dalam tahun Yobel itu, kamu harus kembali ke tanah milikmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Janganlah merugikan sesamamu ketika kamu menjual sesuatu padanya ataupun membeli sesuatu darinya. ");
INSERT INTO indayt_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jika kamu membeli sesuatu dari sesamamu, kamu harus membayarnya menurut jumlah tahun setelah tahun Yobel, sementara orang itu harus menjualnya kepadamu menurut jumlah tahun panen. ");
INSERT INTO indayt_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Semakin banyak jumlah tahun setelah tahun Yobel, semakin tinggi harga jualnya. Semakin sedikit jumlah tahunnya, semakin rendah harga jualnya. Sebab, itulah jumlah hasil panen yang dijual orang itu kepadamu. ");
INSERT INTO indayt_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Jangan saling merugikan. Takutlah akan Allahmu. Sebab, Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Oleh karena itu, lakukanlah peraturan-peraturan-Ku dan peliharalah hukum-hukum-Ku. Maka, kamu akan hidup di negerimu dengan aman. ");
INSERT INTO indayt_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Negeri itu akan memberikan hasilnya. Kamu akan makan sampai kenyang dan hidup dengan tenteram di sana. ");
INSERT INTO indayt_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mungkin kamu akan bertanya, ‘Jika kami tidak boleh menanam benih atau menuai, apa yang akan kami makan selama tahun ketujuh itu?’ ");
INSERT INTO indayt_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Pada tahun keenam, Aku akan memerintahkan berkat-Ku kepadamu sehingga hasil panenmu akan cukup untuk 3 tahun. ");
INSERT INTO indayt_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Saat kamu menabur benih pada tahun kedelapan, kamu masih bisa makan dari hasil panen yang lama. Kamu akan makan hasil panen yang lama itu sampai tahun kesembilan, yaitu saat hasil panen tahun kedelapan tiba. ");
INSERT INTO indayt_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Tanah tidak boleh dijual secara permanen. Sebab sesungguhnya, tanah itu adalah milik-Ku. Kamu semua hanyalah orang asing dan pendatang yang tinggal di tanah-Ku. ");
INSERT INTO indayt_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Semua tanah kepunyaanmu harus kamu beri hak tebus. ");
INSERT INTO indayt_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Jika seseorang di negerimu menjadi miskin dan terpaksa menjual sebagian tanahnya, keluarga terdekatnya harus datang dan menebus tanah itu kembali. ");
INSERT INTO indayt_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Jika dia tidak memiliki keluarga dekat, tetapi kemudian dia memiliki cukup uang untuk menebus tanahnya, ");
INSERT INTO indayt_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","dia harus menghitung jumlah tahun sejak dia menjualnya, dan mengembalikan kelebihannya kepada orang yang membelinya. Dengan demikian, tanah itu akan menjadi miliknya kembali. ");
INSERT INTO indayt_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Namun, jika dia tidak mampu menebus tanahnya, tanah itu harus tetap menjadi milik orang yang telah membelinya sampai tahun Yobel tiba. Pada tahun Yobel, tanah itu harus dikembalikan kepada orang yang menjualnya sehingga dia bisa kembali ke tanahnya. ");
INSERT INTO indayt_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Jika seseorang menjual rumahnya yang berada di kota yang bertembok, hak tebusnya berlaku selama setahun sejak hari penjualannya. Dalam satu tahun itu dia berhak menebusnya. ");
INSERT INTO indayt_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Jika rumah itu tidak ditebus dalam setahun, rumah itu akan menjadi milik pembelinya selamanya, tidak akan dikembalikan pada tahun Yobel. ");
INSERT INTO indayt_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Rumah-rumah di desa yang tidak dikelilingi tembok dianggap sama dengan ladang terbuka, boleh ditebus dan harus dikembalikan pada tahun Yobel. ");
INSERT INTO indayt_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Mengenai kota-kota orang Lewi, orang Lewi memiliki hak tebus selamanya atas rumah mereka yang ada di kota-kota mereka. ");
INSERT INTO indayt_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Oleh karena itu, jika seorang Lewi menjual rumahnya yang berada di kota orang Lewi, rumah itu akan dikembalikan kepadanya pada tahun Yobel. Sebab, rumah yang ada di kota-kota orang Lewi adalah milik mereka di antara anak-anak Israel. ");
INSERT INTO indayt_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Namun, ladang penggembalaan di kota-kota orang Lewi tidak boleh dijual. Sebab, itu adalah milik mereka selamanya. ");
INSERT INTO indayt_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Jika saudaramu menjadi miskin dan tidak dapat lagi hidup di antaramu, kamu harus menopangnya, sebagaimana layaknya terhadap orang asing atau pendatang, sehingga ia dapat bertahan hidup di antaramu. ");
INSERT INTO indayt_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Jangan membebankan riba kepadanya, tetapi takutlah akan Allahmu, supaya saudaramu bisa hidup bersamamu. ");
INSERT INTO indayt_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Jangan meminjamkan uangmu kepadanya dengan bunga. Jangan berusaha mengambil keuntungan dari makanan yang kamu berikan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Akulah TUHAN, Allahmu, yang telah membawamu keluar dari negeri Mesir untuk memberikan negeri Kanaan kepadamu dan untuk menjadi Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Jika saudaramu menjadi miskin sehingga dia harus menjual dirinya kepadamu, jangan mempekerjakan dia seperti budak. ");
INSERT INTO indayt_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Dia harus tinggal bersamamu sebagai buruh atau orang asing, dia harus bekerja padamu sampai tahun Yobel. ");
INSERT INTO indayt_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Sesudah itu, dia dan anak-anaknya boleh meninggalkanmu dan kembali kepada keluarganya, ke tanah milik nenek moyangnya. ");
INSERT INTO indayt_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Sebab, mereka adalah para pelayan-Ku, yang Aku bawa keluar dari negeri Mesir. Jangan menjual mereka sebagai budak. ");
INSERT INTO indayt_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Jangan menjadi tuan yang kejam terhadap mereka, tetapi takutlah akan Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Hamba laki-laki dan hamba perempuan yang kamu miliki haruslah berasal dari bangsa-bangsa yang ada di sekelilingmu. Hanya dari merekalah kamu harus membeli hamba laki-laki dan hamba perempuan. ");
INSERT INTO indayt_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kamu juga boleh membelinya dari para pendatang yang ada di antaramu atau dari kaum keluarga mereka yang lahir di negerimu. Mereka akan menjadi harta milikmu. ");
INSERT INTO indayt_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Bahkan, kamu boleh mewariskan budak-budak orang asing ini kepada anak-anakmu sebagai harta milik, mereka akan menjadi budakmu selamanya. Akan tetapi, terhadap sesamamu orang Israel, jangan memerintah mereka dengan kejam. ");
INSERT INTO indayt_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Jika seorang pendatang di antaramu menjadi kaya, sedangkan saudaramu menjadi miskin dan menjual dirinya kepada pendatang itu atau kepada kaum keluarganya, ");
INSERT INTO indayt_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","dia memiliki hak tebus setelah dia menjual dirinya. Salah seorang saudaranya dapat menebusnya. ");
INSERT INTO indayt_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Paman, sepupu, atau salah seorang dari keluarga dekatnya dapat menebusnya. Atau, jika dia sudah mampu, dia dapat menebus dirinya sendiri. ");
INSERT INTO indayt_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Dia dan orang yang membelinya harus menghitung mulai dari dia menjual dirinya sampai kepada tahun Yobel. Harga penjualan dirinya harus dihitung menurut jumlah tahun itu. Lamanya waktu dia tinggal pada pendatang itu harus dihitung seperti masa kerja orang upahan. ");
INSERT INTO indayt_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Jika jumlah tahunnya banyak, maka berdasarkan jumlah tahun itulah ia harus membayar harga tebusannya dari harga pembeliannya. ");
INSERT INTO indayt_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Jika jumlah tahun sebelum tahun Yobel hanya tinggal beberapa tahun saja, dia harus menghitung dan membayar tebusan untuk dirinya menurut jumlah tahun itu. ");
INSERT INTO indayt_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Dia harus tinggal sebagai buruh dari tahun ke tahun. Janganlah kamu membiarkan ia diperintah dengan kejam di depan matamu. ");
INSERT INTO indayt_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Jika orang itu tidak ditebus dengan cara demikian, orang itu tetap harus dibebaskan pada tahun Yobel, baik dia maupun anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Sebab, umat Israel adalah para hamba-Ku, yang Aku bawa keluar dari negeri Mesir. Akulah TUHAN, Allahmu.” ");
INSERT INTO indayt_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Jangan membuat berhala bagi dirimu sendiri, atau mendirikan patung maupun tiang berhala di negerimu untuk disembah, sebab Akulah TUHAN, Allahmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Peliharalah hari Sabat-Ku dan hormatilah tempat-Ku yang kudus. Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Jika kamu berjalan menurut semua peraturan dan perintah-Ku, serta melakukannya, ");
INSERT INTO indayt_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Aku akan menurunkan hujan bagimu pada waktunya. Tanah itu akan menghasilkan panen dan pohon-pohon di ladang akan memberi buahnya. ");
INSERT INTO indayt_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Pengirikanmu akan tetap ada sampai waktu panen buah anggur. Dan, panen buah anggurmu akan tetap ada sampai musim menanam. Kamu akan makan sampai kenyang dan akan tinggal di negerimu dengan aman. ");
INSERT INTO indayt_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Aku akan memberikan damai sejahtera kepada negerimu sehingga kamu dapat berbaring tanpa ada yang membuatmu takut. Aku akan menjauhkan binatang liar yang berbahaya dari negerimu. Tidak akan ada pedang yang melintasi negerimu. ");
INSERT INTO indayt_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kamu akan mengejar musuh-musuhmu dan mengalahkan mereka dengan pedangmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Lima orang darimu akan mengejar seratus orang, dan seratus orang darimu akan mengejar 10 ribu orang. Kamu akan mengalahkan musuh-musuhmu dengan pedangmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Aku akan berpaling kepadamu dan membuatmu berbuah dan bertambah banyak. Aku akan meneguhkan perjanjian-Ku dengan kamu. ");
INSERT INTO indayt_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kamu akan makan dari hasil panenmu yang dahulu. Kamu akan mengeluarkan panen lama supaya ada tempat untuk panen baru. ");
INSERT INTO indayt_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Aku juga akan mendirikan tempat kediaman-Ku di tengah-tengahmu, dan Aku tidak akan menolak kamu. ");
INSERT INTO indayt_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Aku akan berjalan bersamamu dan menjadi Allahmu. Kamu akan menjadi umat-Ku. ");
INSERT INTO indayt_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Akulah TUHAN, Allahmu, yang telah membawamu keluar dari negeri Mesir, supaya kamu tidak menjadi hamba mereka. Aku telah mematahkan batang kuk yang kamu pikul dan membuatmu berjalan dengan tegak. ");
INSERT INTO indayt_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Akan tetapi, jika kamu tidak mendengarkan Aku dan tidak melakukan semua perintah-Ku itu, ");
INSERT INTO indayt_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","jika kamu menolak peraturan-Ku dan hatimu muak terhadap hukum-hukum-Ku, sehingga kamu tidak melakukan semua perintah-Ku, dengan begitu kamu mengingkari perjanjian-Ku, ");
INSERT INTO indayt_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","maka Aku akan melakukan hal ini kepadamu: Aku akan mendatangkan sesuatu yang mengejutkanmu, yaitu penyakit ganas dan demam yang membuat matamu sayu dan membuat hati merana. Kamu akan menabur benih dengan sia-sia sebab musuh-musuhmu akan memakan hasilnya. ");
INSERT INTO indayt_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Aku akan memalingkan wajah-Ku darimu sehingga musuh-musuhmu akan mengalahkanmu. Mereka yang membencimu akan memerintah atasmu. Kamu akan berlari meski tidak ada yang mengejarmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Jika setelah semua ini kamu tetap tidak mau mendengarkan Aku, Aku akan menghukummu tujuh kali lebih berat karena dosamu itu. ");
INSERT INTO indayt_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Aku juga akan mematahkan semua kekuatan yang membuatmu menyombongkan diri. Aku akan membuat langitmu seperti besi dan tanahmu seperti tembaga. ");
INSERT INTO indayt_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Kekuatanmu akan habis dengan sia-sia karena tanahmu tidak akan menghasilkan panen apa pun, dan pohon-pohon di negeri itu tidak akan menghasilkan buah. ");
INSERT INTO indayt_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Jika setelah semua itu kamu masih tetap melawan-Ku dan tidak mau mendengarkan-Ku, Aku akan meningkatkan hukumanmu tujuh kali lebih berat, sesuai dosa-dosamu. ");
INSERT INTO indayt_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Aku akan membiarkan binatang buas mencabik anak-anakmu dan membinasakan ternakmu. Binatang itu akan membuat jumlahmu menjadi sedikit sehingga jalan-jalanmu menjadi sepi. ");
INSERT INTO indayt_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Jika dengan semua ini kamu tidak Aku hajar dan tetap melawan Aku, ");
INSERT INTO indayt_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Aku juga akan melawanmu. Aku sendiri akan memukulmu tujuh kali lebih berat karena dosamu. ");
INSERT INTO indayt_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Aku akan mendatangkan pedang atasmu yang akan mengadakan pembalasan bagi perjanjian-Ku. Apabila kamu berkumpul di kota-kotamu, Aku akan mengirimkan penyakit sampar ke tengah-tengahmu sehingga kamu akan diserahkan ke tangan musuh-musuhmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Aku akan menghentikan persediaan gandummu. Sepuluh wanita akan memanggang roti dalam satu tungku dan mereka akan memberikan rotimu dengan timbangan tertentu. Kamu akan memakannya, tetapi tidak menjadi kenyang. ");
INSERT INTO indayt_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Jika dengan semua itu kamu masih tidak mau mendengarkan Aku dan berjalan menentang Aku, ");
INSERT INTO indayt_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Aku akan menentangmu dengan murka-Ku. Aku sendiri akan menghukummu tujuh kali lebih berat karena dosamu. ");
INSERT INTO indayt_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kamu akan memakan daging anak-anakmu laki-laki dan perempuan. ");
INSERT INTO indayt_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Aku akan membinasakan bukit-bukit pengurbananmu dan meruntuhkan mazbah-mazbah pedupaanmu. Aku akan melemparkan mayatmu ke atas bangkai-bangkai berhalamu, sebab jiwa-Ku akan muak terhadapmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Aku akan membiarkan kota-kotamu terbengkalai dan tempat-tempat kudusmu menjadi sunyi. Aku tidak akan lagi menghirup persembahanmu yang menyenangkan. ");
INSERT INTO indayt_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Aku akan membuat negerimu tandus sehingga musuh-musuhmu yang menetap di situ akan terkejut melihatnya. ");
INSERT INTO indayt_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Aku akan menceraiberaikanmu di antara bangsa-bangsa. Aku akan menghunus pedang di hadapanmu. Negerimu akan menjadi sunyi dan kota-kotamu akan reruntuhan. ");
INSERT INTO indayt_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Pada waktu itu, negerimu akan mendapatkan hari Sabat selama masa kesunyian itu, sementara kamu tinggal di negeri-negeri musuhmu. Negerimu akan mendapat peristirahatan dan menikmati Sabatnya. ");
INSERT INTO indayt_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Selama masa kesunyian, negerimu itu akan mendapatkan masa istirahat yang tidak ia dapatkan selama kamu tinggal di situ. ");
INSERT INTO indayt_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Untuk orang-orang dari antaramu yang masih bertahan, Aku akan mendatangkan keputusasaan dalam hati mereka di negeri-negeri musuh mereka. Suara dedaunan yang ditiup angin pun akan mengejar mereka. Mereka akan lari seperti orang yang dikejar-kejar pedang. Mereka akan terjatuh meski tidak ada orang yang mengejar. ");
INSERT INTO indayt_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Mereka saling tersandung satu dengan yang lain seolah kabur dari pedang, padahal tidak seorang pun mengejar mereka. Kamu tidak akan memiliki kekuatan untuk berdiri di hadapan musuh-musuhmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kamu akan musnah dari antara bangsa-bangsa dan negeri musuh-musuhmu akan menelanmu. ");
INSERT INTO indayt_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Mereka yang selamat akan membusuk di negeri musuh karena kesalahan-kesalahan mereka, dan juga karena semua kesalahan nenek moyang mereka. Mereka akan membusuk bersama nenek moyang mereka. ");
INSERT INTO indayt_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Akan tetapi, jika mereka mengakui kesalahan mereka dan kesalahan nenek moyang mereka, dalam hal ketidaksetiaan yang mereka lakukan terhadap Aku dan dalam sikap mereka yang menentang Aku, ");
INSERT INTO indayt_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","sehingga Aku akan menentang dan membawa mereka ke negeri musuh-musuh mereka. Jika kemudian hati mereka yang tidak bersunat itu mau tunduk dan menerima hukuman atas kesalahan mereka, ");
INSERT INTO indayt_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Aku akan mengingat Perjanjian-Ku dengan Yakub, Ishak, dan Abraham. Dan, Aku akan mengingat negeri itu. ");
INSERT INTO indayt_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Negeri itu akan mereka tinggalkan dan menikmati Sabatnya selama negeri itu sunyi tanpa mereka. Sementara itu, mereka akan menerima hukuman untuk kesalahan mereka karena menolak hukum-hukum-Ku dan karena jiwa mereka muak terhadap peraturan-peraturan-Ku. ");
INSERT INTO indayt_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Meski begitu, saat mereka ada di negeri musuh, Aku tidak akan menolak atau membenci mereka sehingga ingin membinasakan mereka. Jika demikian, Aku melanggar perjanjian-Ku dengan mereka. Sebab, Akulah TUHAN, Allah mereka. ");
INSERT INTO indayt_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Demi mereka, Aku akan mengingat perjanjian dengan orang-orang terdahulu, yang telah Kubawa keluar dari negeri Mesir di hadapan bangsa-bangsa lain, supaya Aku menjadi Allah mereka. Akulah TUHAN.’” ");
INSERT INTO indayt_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Itulah peraturan, hukum, dan ketetapan yang diadakan antara TUHAN dan umat Israel dengan perantaraan Musa di Gunung Sinai. ");
INSERT INTO indayt_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Katakanlah kepada umat Israel: ‘Apabila seseorang menyampaikan nazar khusus kepada TUHAN mengenai orang lain, orang yang dinazarkan itu boleh ditebus menurut nilai yang kautetapkan. ");
INSERT INTO indayt_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Nilai untuk laki-laki yang berusia antara 20 sampai 60 tahun adalah 50 syikal perak, menurut syikal kudus. ");
INSERT INTO indayt_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Untuk perempuan, nilainya adalah 30 syikal. ");
INSERT INTO indayt_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Untuk yang berusia 5 sampai 20 tahun, jika laki-laki nilainya adalah 20 syikal, jika perempuan sepuluh syikal. ");
INSERT INTO indayt_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Jika yang berusia satu bulan sampai 5 tahun, nilainya adalah 5 syikal perak untuk laki-laki dan 3 syikal perak untuk perempuan. ");
INSERT INTO indayt_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Untuk mereka yang berusia 60 tahun lebih, nilainya adalah 15 syikal untuk laki-laki, dan 10 syikal untuk perempuan. ");
INSERT INTO indayt_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Jika seseorang terlalu miskin untuk membayar harga itu, bawalah dia kepada imam. Imam akan menentukan harga orang itu sesuai dengan kemampuan orang yang bernazar.” ");
INSERT INTO indayt_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Apabila yang dinazarkan orang itu adalah seekor binatang yang dapat dipersembahkan sebagai kurban kepada TUHAN, semua bagian binatang yang dia berikan kepada TUHAN itu menjadi kudus. ");
INSERT INTO indayt_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Dia tidak boleh menukar atau mengganti binatang itu, yang tidak baik untuk yang baik, atau sebaliknya. Jika dia menukar binatang itu dengan yang lain, binatang yang ditukar dan yang digunakan haruslah kudus. ");
INSERT INTO indayt_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Namun, jika binatang yang dia nazarkan adalah binatang najis yang tidak boleh dipersembahkan kepada TUHAN, orang itu harus membawa binatang itu kepada imam. ");
INSERT INTO indayt_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Imam akan menetapkan nilai binatang itu menurut kondisinya. Sesuai dengan yang ditetapkan imam, itulah nilai binatang itu. ");
INSERT INTO indayt_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Jika orang itu mau menebus binatang itu, dia harus menambahkan 1/5 dari nilai yang ditetapkan itu. ");
INSERT INTO indayt_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Apabila seseorang mengkhususkan rumahnya sebagai persembahan kepada TUHAN, imam harus menetapkan nilai rumah itu menurut kondisinya. Sebagaimana yang ditetapkan imam, itulah nilai rumah itu. ");
INSERT INTO indayt_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Jika orang itu ingin menebus rumahnya kembali, ia harus menambahkan 1/5 dari nilai yang sudah ditetapkan imam. Maka, rumah itu akan menjadi miliknya kembali. ");
INSERT INTO indayt_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Apabila seseorang mengkhususkan sebagian dari ladang yang dimilikinya bagi TUHAN, nilainya sama dengan jumlah benih yang dapat ditabur di ladang itu. Satu homer benih jelai nilainya adalah 50 syikal perak. ");
INSERT INTO indayt_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jika orang itu mengkhusus ladangnya pada tahun Yobel, nilainya sesuai dengan penetapanmu. ");
INSERT INTO indayt_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Namun, apabila dia mengkhususkan ladang itu setelah tahun Yobel, imam harus menetapkan nilainya bagi orang itu menurut jumlah tahun yang ada sebelum tahun Yobel berikutnya. Dan, nilainya harus dikurangi dari perkiraanmu. ");
INSERT INTO indayt_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Jika orang itu ingin menebus ladangnya kembali, dia harus menambahkan 1/5 dari nilai yang ditetapkan imam. Maka, ladang itu akan menjadi miliknya kembali. ");
INSERT INTO indayt_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Namun, apabila dia tidak ingin menebus ladangnya, atau sudah menjualnya ke orang lain, ladang itu tidak dapat ditebus lagi. ");
INSERT INTO indayt_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Saat ladang itu dibebaskan pada tahun Yobel, ladang itu kudus bagi TUHAN, sama seperti ladang lain yang telah dikhususkan. Ladang itu akan menjadi milik imam. ");
INSERT INTO indayt_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Apabila seseorang mengkhususkan ladang yang dia beli bagi TUHAN, yang bukan miliknya dahulu, ");
INSERT INTO indayt_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","imam harus menghitung berapa nilainya sampai tahun Yobel. Hari itu juga, orang itu harus membayar nilainya sebagai persembahan kudus bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Pada tahun Yobel, ladang itu harus dikembalikan kepada pemilik yang semula, yaitu kepada pemilik asli ladang itu. ");
INSERT INTO indayt_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Setiap penilaian haruslah menurut ukuran syikal kudus. Satu syikal sama dengan 20 gera. ");
INSERT INTO indayt_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Akan tetapi, anak sulung binatang adalah milik TUHAN, tidak boleh dikhususkan, baik itu sapi maupun domba, sebab itu milik TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Akan tetapi, anak sulung binatang yang haram harus ditebus menurut nilai yang kamu tetapkan, dengan menambah 1/5 dari nilai itu. Jika tidak ditebus, maka harus dijual menurut nilai yang sudah ditetapkan. ");
INSERT INTO indayt_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Semua kepemilikan yang dikhususkan seseorang bagi TUHAN, baik itu orang, binatang, maupun ladang, tidak boleh dijual atau ditebus. Segala sesuatu yang dikhususkan adalah mahakudus bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Seseorang yang sudah dikhususkan untuk dibinasakan di antara manusia, tidak boleh ditebus. Orang itu harus dibunuh. ");
INSERT INTO indayt_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Sepersepuluh hasil panen adalah milik TUHAN, baik itu hasil gandum maupun buah pohon-pohon. Itu kudus bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Jika seseorang ingin menebus sebagian persepuluhannya, dia harus menambahkan 1/5. ");
INSERT INTO indayt_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Setiap sepersepuluh dari kawanan sapi atau domba, yaitu hewan kesepuluh yang lewat di bawah tongkat gembala saat dihitung, adalah persembahan kudus bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Pemilik ternak tidak boleh memilih-milih, yang baik atau yang tidak baik, ataupun menukarnya. Jika pemilik itu menukarnya, hewan yang ditukar dan yang digunakan untuk menukar menjadi kudus. Itu tidak boleh ditebus.’” ");
INSERT INTO indayt_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Itulah perintah-perintah yang disampaikan TUHAN kepada Musa di Gunung Sinai bagi umat Israel. ");
INSERT INTO indayt_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Pada hari pertama bulan kedua, tahun kedua sesudah umat Israel meninggalkan Mesir, TUHAN berfirman kepada Musa dalam tenda pertemuan di padang gurun Sinai, ");
INSERT INTO indayt_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Hitunglah jumlah umat Israel. Daftarkan nama setiap orang menurut kaum keluarganya, catatlah nama setiap laki-laki, orang demi orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Kamu dan Harun harus menghitung semua laki-laki di Israel yang berusia 20 tahun ke atas, yang sanggup maju berperang. Catatlah mereka menurut barisan masing-masing. ");
INSERT INTO indayt_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Dari setiap suku, harus ada satu orang kepala leluhurnya. ");
INSERT INTO indayt_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Inilah nama-nama mereka yang akan membantumu: dari suku Ruben — Elizur, anak Syedeur; ");
INSERT INTO indayt_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","dari suku Simeon — Selumiel, anak Zurisyadai; ");
INSERT INTO indayt_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","dari suku Yehuda — Nahason, anak Aminadab; ");
INSERT INTO indayt_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","dari suku Isakhar — Netaneel, anak Zuar; ");
INSERT INTO indayt_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","dari suku Zebulon — Eliab, anak Helon; ");
INSERT INTO indayt_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","dari keturunan Yusuf: dari suku Efraim — Elisama, anak Amihud; dari suku Manasye — Gamaliel, anak Pedazur; ");
INSERT INTO indayt_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","dari suku Benyamin — Abidan, anak Gideoni; ");
INSERT INTO indayt_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","dari suku Dan — Ahiezer, anak Amisyadai; ");
INSERT INTO indayt_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","dari suku Asyer — Pagiel, anak Okhran; ");
INSERT INTO indayt_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","dari suku Gad — Elyasaf, anak Rehuel; ");
INSERT INTO indayt_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","dari suku Naftali — Ahira, anak Enan.” ");
INSERT INTO indayt_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Merekalah yang dipilih dari antara umat Israel, para pemimpin suku nenek moyang mereka, kepala pasukan Israel. ");
INSERT INTO indayt_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa dan Harun memanggil mereka yang telah disebutkan namanya ini, ");
INSERT INTO indayt_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","dan mereka mengumpulkan seluruh umat Israel pada hari pertama bulan kedua. Lalu, orang-orang dicatat menurut keluarga dan suku mereka. Semua laki-laki yang berusia 20 tahun atau lebih dicatat satu per satu. ");
INSERT INTO indayt_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Musa melakukannya tepat seperti perintah TUHAN, dia menghitung mereka di padang gurun Sinai. ");
INSERT INTO indayt_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Keturunan Ruben, anak sulung Israel. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Laki-laki yang dihitung dari suku Ruben berjumlah 46.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Keturunan Simeon. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Laki-laki yang dihitung dari suku Simeon berjumlah 59.300 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Keturunan Gad. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Laki-laki yang dihitung dari suku Gad berjumlah 45.650 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Keturunan Yehuda. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Laki-laki yang dihitung dari suku Yehuda berjumlah 74.600 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Keturunan Isakhar. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Laki-laki yang dihitung dari suku Isakhar berjumlah 54.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Keturunan Zebulon. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Laki-laki yang dihitung dari suku Zebulon berjumlah 57.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Dari anak-anak Yusuf, keturunan Efraim. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Laki-laki yang dihitung dari suku Efraim berjumlah 40.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Keturunan Manasye. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Laki-laki yang dihitung dari suku Manasye berjumlah 32.200 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Keturunan Benyamin. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Laki-laki yang dihitung dari suku Benyamin berjumlah 35.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Keturunan Dan. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Laki-laki yang dihitung dari suku Dan berjumlah 62.700 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Keturunan Asyer. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Laki-laki yang dihitung dari suku Asyer berjumlah 41.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Keturunan Naftali. Nama semua laki-laki yang berusia 20 tahun atau lebih dan sanggup berperang telah didaftar menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Laki-laki yang dihitung dari suku Naftali berjumlah 53.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Itulah orang-orang yang dihitung Musa, Harun, dan kedua belas pemimpin Israel, yang mewakili masing-masing suku. ");
INSERT INTO indayt_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Mereka menghitung setiap orang yang berusia 20 tahun atau lebih, yang sanggup berperang. Setiap orang didaftar menurut keluarganya. ");
INSERT INTO indayt_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Seluruh laki-laki yang dihitung itu berjumlah 603.550 orang. ");
INSERT INTO indayt_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Akan tetapi, suku Lewi tidak dihitung bersama orang Israel lainnya. ");
INSERT INTO indayt_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Sebab, TUHAN telah berkata kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Suku Lewi tidak boleh kamu hitung. Jangan menghitung mereka bersama keturunan Israel yang lain. ");
INSERT INTO indayt_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Akan tetapi, angkatlah orang Lewi sebagai penanggung jawab tenda kesaksian, semua perlengkapannya, dan segala sesuatu yang ada di dalamnya. Mereka harus mengangkut tenda itu dan semua yang ada di dalamnya. Mereka harus merawatnya, dan juga harus berkemah di sekelilingnya. ");
INSERT INTO indayt_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Jadi, apabila Tenda Suci hendak berangkat, orang Lewi yang harus membongkarnya. Apabila Tenda Suci harus didirikan, orang Lewi yang harus memasangnya. Orang awam yang mendekatinya harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Umat Israel harus mendirikan tenda mereka menurut pasukan masing-masing, sesuai benderanya. ");
INSERT INTO indayt_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Namun, orang Lewi harus mendirikan tenda mereka di sekeliling tenda kesaksian supaya tidak ada murka yang menimpa seluruh umat Israel. Orang Lewi harus menjaga tenda kesaksian.” ");
INSERT INTO indayt_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Begitulah dilakukan umat Israel. Mereka melakukan semuanya tepat seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","TUHAN berfirman kepada Musa dan Harun, ");
INSERT INTO indayt_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Umat Israel harus berkemah mengelilingi tenda pertemuan. Mereka harus berkemah menurut bendera sukunya masing-masing. ");
INSERT INTO indayt_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Perkemahan Yehuda harus berada di sebelah timur, tempat matahari terbit, menurut pasukan masing-masing. Pemimpin suku Yehuda ialah Nahason, anak Aminadab, ");
INSERT INTO indayt_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","74.600 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Suku Isakhar harus berkemah di samping suku Yehuda. Pemimpin suku Isakhar adalah Netaneel, anak Zuar, ");
INSERT INTO indayt_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","54.400 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kemudian suku Zebulon. Pemimpin suku Zebulon ialah Eliab, anak Helon, ");
INSERT INTO indayt_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","57.400 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Jumlah keseluruhan laki-laki dalam perkemahan suku Yehuda adalah 186.400 orang, menurut barisannya masing-masing. Mereka harus berangkat pada urutan pertama. ");
INSERT INTO indayt_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Perkemahan Ruben harus berada di sebelah selatan, menurut pasukannya masing-masing. Pemimpin suku Ruben adalah Elizur, anak Syedeur, ");
INSERT INTO indayt_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","46.500 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Suku Simeon harus berkemah di samping suku Ruben. Pemimpin suku Simeon adalah Selumiel, anak Zurisyadai, ");
INSERT INTO indayt_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","59.300 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Suku Gad juga harus berkemah di samping suku Ruben. Pemimpin suku Gad adalah Elyasaf, anak Rehuel, ");
INSERT INTO indayt_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","45.650 orang pasukannya. ");
INSERT INTO indayt_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Jumlah keseluruhan laki-laki dalam perkemahan suku Ruben adalah 151.450 orang. Mereka harus berangkat pada urutan kedua. ");
INSERT INTO indayt_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kemudian, tenda pertemuan harus diberangkatkan bersama perkemahan suku Lewi, di tengah perkemahan suku yang lain. Sama seperti posisi mereka berkemah, demikianlah mereka harus berangkat, setiap orang berada di posisi masing-masing menurut bendera mereka. ");
INSERT INTO indayt_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Perkemahan Efraim harus berada di sebelah barat, menurut pasukan-pasukannya. Pemimpin suku Efraim adalah Elisama, anak Amihud. ");
INSERT INTO indayt_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Pasukannya berjumlah 40.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Suku Manasye harus berkemah di sebelah suku Efraim. Pemimpin suku Manasye adalah Gamaliel, anak Pedazur. ");
INSERT INTO indayt_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Pasukannya berjumlah 32.200 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Suku Benyamin juga harus berkemah di dekat suku Efraim. Pemimpin suku Benyamin adalah Abidan, anak Gideoni. ");
INSERT INTO indayt_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Pasukannya berjumlah 35.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Jumlah keseluruhan laki-laki dalam perkemahan suku Efraim adalah 108.100 orang, menurut pasukan-pasukan mereka. Mereka harus berangkat pada urutan ketiga. ");
INSERT INTO indayt_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Perkemahan Dan harus berada di sebelah utara, menurut pasukan-pasukannya. Pemimpin suku Dan ialah Ahiezer, anak Amisyadai. ");
INSERT INTO indayt_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Pasukannya berjumlah 62.700 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Suku Asyer harus berkemah di sebelah suku Dan. Pemimpin suku Asyer ialah Pagiel, anak Okhran. ");
INSERT INTO indayt_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Pasukannya berjumlah 41.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Suku Naftali juga harus berkemah di dekat suku Dan. Pemimpin suku Naftali adalah Ahira, anak Enan. ");
INSERT INTO indayt_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Pasukannya berjumlah 53.400 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Jumlah keseluruhan laki-laki dalam perkemahan suku Dan adalah 157.600 orang. Mereka harus berangkat pada urutan terakhir, masing-masing pasukan menurut benderanya.” ");
INSERT INTO indayt_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Itulah jumlah keseluruhan umat Israel menurut suku mereka. Jumlah keseluruhan laki-laki dalam perkemahan itu, yang dihitung menurut pasukan-pasukannya, adalah 603.550 orang. ");
INSERT INTO indayt_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Akan tetapi, suku Lewi tidak dihitung di antara umat Israel, seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Demikianlah dilakukan umat Israel. Mereka melakukan semuanya tepat seperti yang TUHAN perintahkan kepada Musa. Mereka berkemah dan berpindah menurut bendera masing-masing, menurut suku dan keluarganya. ");
INSERT INTO indayt_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Inilah silsilah Harun dan Musa ketika TUHAN berfirman kepada Musa di Gunung Sinai. ");
INSERT INTO indayt_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Inilah nama anak-anak Harun: Nadab, anak sulung, Abihu, Eleazar, dan Itamar. ");
INSERT INTO indayt_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Itulah nama anak-anak Harun, para imam yang diurapi, yang telah diangkat untuk melayani sebagai imam. ");
INSERT INTO indayt_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Namun, Nadab dan Abihu mati di hadapan TUHAN ketika mereka mempersembahkan api yang asing kepada TUHAN di padang gurun Sinai. Mereka tidak memiliki anak. Jadi, Eleazar dan Itamarlah yang melayani sebagai imam di depan Harun, ayah mereka. ");
INSERT INTO indayt_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bawalah suku Lewi ke hadapan Imam Harun. Mereka akan melayaninya. ");
INSERT INTO indayt_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Mereka akan bertanggung jawab terhadapnya dalam mengerjakan tugas-tugas terhadap seluruh umat di tenda pertemuan, untuk melakukan pelayanan Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Mereka harus mengurus semua perlengkapan tenda pertemuan dan umat Israel dalam pelayanan di Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Berikanlah orang-orang Lewi kepada Harun dan anak-anaknya sebab mereka telah dipilih dari antara orang Israel untuk Harun dan anak-anaknya. ");
INSERT INTO indayt_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tetapkanlah Harun dan anak-anaknya untuk melaksanakan tugas keimaman. Orang asing yang mendekat harus dihukum mati.” ");
INSERT INTO indayt_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Aku telah mengambil suku Lewi dari antara anak-anak Israel sebagai pengganti anak sulung, yaitu yang pertama lahir dari kandungan di antara umat Israel. Suku Lewi akan menjadi milik-Ku, ");
INSERT INTO indayt_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","karena semua anak sulung adalah milik-Ku. Pada waktu Aku membinasakan semua anak sulung di negeri Mesir, Aku menguduskan semua anak sulung di Israel bagi diri-Ku sendiri, baik anak sulung manusia maupun binatang. Mereka menjadi milik-Ku. Akulah TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","TUHAN berfirman kepada Musa di padang gurun Sinai, ");
INSERT INTO indayt_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Catatlah jumlah orang Lewi menurut keluarga dan suku mereka. Hitung semua laki-laki yang berusia sebulan atau lebih.” ");
INSERT INTO indayt_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Lalu, Musa menghitung suku Lewi sesuai dengan firman TUHAN yang diperintahkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Inilah nama anak-anak lelaki Lewi: Gerson, Kehat, dan Merari. ");
INSERT INTO indayt_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Inilah nama anak-anak Gerson menurut suku mereka: Libni dan Simei. ");
INSERT INTO indayt_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Anak-anak Kehat menurut suku mereka adalah Amram, Yizhar, Hebron, dan Uziel. ");
INSERT INTO indayt_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Anak-anak Merari menurut suku mereka adalah Mahli dan Musi. Itulah keluarga orang Lewi berdasarkan kaum mereka. ");
INSERT INTO indayt_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Keluarga Libni dan Simei termasuk dalam keluarga Gerson. Itulah keluarga orang Gerson. ");
INSERT INTO indayt_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Jumlah laki-laki yang berusia sebulan ke atas adalah 7.500 orang. ");
INSERT INTO indayt_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Keluarga Gerson harus berkemah di belakang Tenda Suci, di sebelah barat. ");
INSERT INTO indayt_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Pemimpin keluarga Gerson adalah Elyasaf, anak Lael. ");
INSERT INTO indayt_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Tanggung jawab orang-orang Gerson dalam tenda pertemuan mencakup Tenda Suci, tenda beserta atapnya, tirai pintu masuk tenda pertemuan, ");
INSERT INTO indayt_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","tirai pelataran, tirai pintu masuk pelataran yang mengelilingi Tenda Suci dan mazbah, beserta tali-talinya, dan semua pelayanan yang berhubungan dengan benda-benda itu. ");
INSERT INTO indayt_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keluarga Amram, Yizhar, Hebron, dan Uziel termasuk dalam keluarga Kehat. Itulah keluarga orang Kehat. ");
INSERT INTO indayt_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Jumlah laki-laki yang berusia sebulan ke atas adalah 8.300 orang. Mereka bertugas mengurus peralatan di tempat kudus. ");
INSERT INTO indayt_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Keluarga Kehat harus berkemah di sebelah selatan Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Pemimpin keluarga Kehat adalah Elisafan, anak Uziel. ");
INSERT INTO indayt_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Tugas mereka adalah mengurus tabut, meja, kandil, mazbah, dan perlengkapan tempat kudus yang mereka pakai melayani, tirai dan semua pelayanan yang berhubungan dengan benda-benda itu. ");
INSERT INTO indayt_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Pemimpin tertinggi orang Lewi ialah Eleazar, anak Harun. Eleazar bertanggung jawab mengawasi semua orang yang bekerja mengurusi tempat kudus. ");
INSERT INTO indayt_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Keluarga Mahli dan Musi termasuk dalam keluarga Merari. ");
INSERT INTO indayt_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Jumlah laki-laki yang berusia sebulan ke atas adalah 6.200 orang. ");
INSERT INTO indayt_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Pemimpin keluarga Merari adalah Zuriel, anak Abihail. Mereka harus berkemah di sebelah utara Tenda Suci. ");
INSERT INTO indayt_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Tanggung jawab yang ditetapkan untuk orang Merari meliputi kerangka Tenda Suci. Mereka mengurus semua kayu usuk, tiang, alas, semua peralatannya, dan segala sesuatu yang berhubungan dengan itu. ");
INSERT INTO indayt_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Mereka juga mengurus semua tiang penyangga di sekeliling pelataran, semua alas, patok, dan tali-talinya. ");
INSERT INTO indayt_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Yang harus berkemah di sebelah timur, di depan tenda pertemuan, ialah Musa, Harun, dan anak-anaknya yang bertanggung jawab di tempat kudus bagi umat Israel. Orang asing yang mendekat harus dihukum mati. ");
INSERT INTO indayt_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Semua laki-laki orang Lewi yang dihitung oleh Musa dan Harun sesuai perintah TUHAN, berdasarkan suku mereka, setiap laki-laki berusia satu bulan ke atas, berjumlah 22.000 orang. ");
INSERT INTO indayt_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","TUHAN berfirman kepada Musa, “Hitunglah semua laki-laki sulung Israel yang berusia satu bulan ke atas. Tulislah daftar nama mereka. ");
INSERT INTO indayt_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kamu harus mengambil orang Lewi bagi-Ku sebagai pengganti semua anak sulung di antara umat Israel, dan anak sulung ternak orang Lewi sebagai pengganti anak sulung ternak umat Israel. Akulah TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Maka, Musa menghitung semua anak sulung Israel seperti yang TUHAN perintahkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Jumlah semua anak laki-laki sulung yang berusia satu bulan ke atas adalah 22.273 orang. ");
INSERT INTO indayt_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kemudian, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ambillah orang-orang Lewi sebagai pengganti semua laki-laki sulung umat Israel dan anak sulung ternak orang Lewi sebagai pengganti anak sulung ternak umat Israel. Orang-orang Lewi harus menjadi milik-Ku, Akulah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Harus ditebus juga anak sulung umat Israel yang lebih banyak 273 orang dari jumlah orang Lewi. ");
INSERT INTO indayt_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Nilai tebusan untuk setiap orang adalah lima syikal, menurut ukuran syikal kudus. Satu syikal adalah dua puluh gera. ");
INSERT INTO indayt_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Berikanlah perak itu kepada Harun dan anak-anaknya sebagai tebusan untuk orang-orang itu.” ");
INSERT INTO indayt_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Jadi, Musa mengambil uang tebusan dari 273 orang yang melebihi jumlah yang ditebus orang Lewi itu. ");
INSERT INTO indayt_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Dari anak sulung umat Israel, Musa mengumpulkan 1.365 syikal perak, menurut ukuran syikal kudus. ");
INSERT INTO indayt_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa memberikan uang tebusan itu kepada Harun dan anak-anaknya, sesuai dengan firman TUHAN yang diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","TUHAN berfirman kepada Musa dan Harun, firman-Nya, ");
INSERT INTO indayt_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Hitunglah jumlah laki-laki dalam keluarga Kehat, di antara anak-anak Lewi. Hitunglah mereka menurut keluarga dan suku mereka, ");
INSERT INTO indayt_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","yang berusia 30 hingga 50 tahun, semua orang yang bisa masuk dalam pelayanan untuk melakukan pekerjaan di tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Tugas orang Kehat di tenda pertemuan adalah tentang yang maha kudus. ");
INSERT INTO indayt_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ketika perkemahan akan berangkat, Harun dan anak-anaknya harus masuk dan menurunkan tirai dan menutupi tabut kesaksian dengan tirai itu. ");
INSERT INTO indayt_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Mereka harus menutup semuanya ini dengan penutup yang terbuat dari kulit lumba-lumba. Kemudian, mereka harus membentangkan kain biru sebagai penutup di atasnya dan memasukkan kayu-kayu pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Di atas meja roti sajian, mereka harus membentangkan kain biru. Lalu, mereka harus meletakkan piring, cawan, piala, dan kendi untuk persembahan curahan di atas meja itu. Roti sajian harus selalu ada di atas meja itu. ");
INSERT INTO indayt_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Mereka harus menutupi semua itu dengan kain merah dan melapisinya dengan penutup dari kulit lumba-lumba, serta memasang kayu-kayu pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Selanjutnya, kaki pelita, beserta lampunya, pemadam pelita, nampan, dan tempat minyak harus mereka tutup juga dengan kain biru. ");
INSERT INTO indayt_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Lalu, mereka harus menutup semuanya itu dengan penutup dari kulit lumba-lumba dan meletakkannya di atas kayu pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Mereka harus membentangkan sehelai kain biru ke atas mazbah emas dan menutupnya dengan kulit lumba-lumba. Lalu, mereka harus memasangkan kayu-kayu pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Selanjutnya, mereka harus mengambil semua perlengkapan yang mereka pakai untuk melayani di tempat kudus, membungkusnya dengan sehelai kain biru, dan melapisinya dengan kulit lumba-lumba. Mereka harus meletakkan semua perlengkapan ini di atas usungan. ");
INSERT INTO indayt_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Mereka harus membersihkan mazbah dari abu dan membentangkan kain ungu di atasnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kemudian, mereka harus meletakkan semua perlengkapan pelayanan mazbah di atasnya, yaitu pedupaan, garpu, sekop, bokor, dan semua perlengkapan mazbah itu. Lalu, mereka harus membentangkan kulit lumba-lumba di atas mazbah dan memasukkan kayu-kayu pengusungnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Setelah Harun dan anak-anaknya selesai menutupi semua benda kudus dan perlengkapannya, barulah keturunan Kehat boleh masuk untuk mengangkut semua benda kudus dari tempat kudus. Namun, mereka tidak boleh menyentuh benda-benda kudus, atau mereka akan mati. Itulah barang-barang tenda pertemuan yang harus dibawa oleh orang-orang Kehat. ");
INSERT INTO indayt_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar, anak Imam Harun, bertanggung jawab atas minyak untuk pelita, kemenyan wangi, kurban sajian yang harus selalu ada, dan minyak urapan. Dia juga bertanggung jawab mengawasi seluruh Tenda Suci dan semua yang ada di dalamnya, juga segala barang kudus dan perlengkapannya.” ");
INSERT INTO indayt_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","TUHAN berfirman kepada Musa dan Harun, ");
INSERT INTO indayt_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Jangan biarkan orang-orang Kehat binasa dari antara keluarga Lewi. ");
INSERT INTO indayt_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Lakukanlah hal ini supaya mereka tetap hidup dan tidak mati ketika mereka mendekati barang-barang maha kudus: Harun dan anak-anaknya harus masuk dan menunjukkan kepada setiap orang Kehat apa yang harus dilakukan dan yang harus dibawa, ");
INSERT INTO indayt_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","tetapi mereka tidak boleh masuk melihat barang-barang kudus itu. Jika mereka melihatnya, walaupun hanya sebentar, mereka pasti mati.” ");
INSERT INTO indayt_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Hitunglah semua orang di keluarga Gerson. Daftarlah mereka menurut kaum dan keluarganya. ");
INSERT INTO indayt_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Hitunglah semua laki-laki yang berusia 30 hingga 50 tahun, semua laki-laki yang dapat melakukan tugas pelayanan dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Inilah pelayanan yang harus dilakukan keluarga Gerson dan benda-benda yang harus mereka bawa. ");
INSERT INTO indayt_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Mereka harus membawa semua tirai Tenda Suci, tenda pertemuan, penutupnya, dan penutup yang terbuat dari kulit lumba-lumba yang ada di atasnya. Mereka juga harus membawa tirai pintu masuk tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Mereka harus membawa tirai pelataran dan tirai pintu gerbang pelataran, yang ada di sekeliling Tenda Suci dan mazbah. Mereka juga harus membawa semua tali dan perlengkapan yang dipakai untuk pelayanan mereka. Mereka bertanggung jawab untuk semua pekerjaan yang berkaitan dengan barang-barang itu. ");
INSERT INTO indayt_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Semua pelayanan orang Gerson, apa yang harus mereka bawa, dan apa yang harus mereka kerjakan harus dilakukan atas perintah Harun dan anak-anaknya. Kamu harus memberi tahu apa yang harus mereka bawa. ");
INSERT INTO indayt_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Itulah pelayanan keluarga Gerson dalam tenda pertemuan. Itamar, anak Imam Harun, bertanggung jawab atas pekerjaan mereka. ");
INSERT INTO indayt_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Hitunglah semua laki-laki di keluarga Merari, berdasarkan sukunya. ");
INSERT INTO indayt_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Hitunglah semua laki-laki yang berusia 30 hingga 50 tahun, yang melakukan tugas pelayanan dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Sebagai tanggung jawab mereka dalam tenda pertemuan, inilah yang harus mereka bawa: papan Tenda Suci beserta kayu, tiang, dan alasnya. ");
INSERT INTO indayt_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Juga tiang-tiang penyangga sekeliling pelataran beserta alas, patok, tali-tali dan semua perlengkapannya. Kamu harus menyebutkan nama-nama barang yang harus mereka bawa. ");
INSERT INTO indayt_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Itulah pelayanan kaum Merari dalam tenda pertemuan di bawah pengarahan Itamar, anak Imam Harun.” ");
INSERT INTO indayt_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Harun, dan para pemimpin Israel menghitung orang-orang Kehat menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Mereka menghitung semua laki-laki yang berusia 30 hingga 50 tahun yang melayani dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Jumlah laki-laki yang dihitung menurut keluarga mereka adalah 2.750 orang. ");
INSERT INTO indayt_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Itulah keluarga Kehat yang dihitung Musa dan Harun sesuai dengan perintah Tuhan melalui Musa. Mereka inilah yang melayani di tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Jumlah laki-laki keturunan Gerson dihitung menurut keluarga dan sukunya, ");
INSERT INTO indayt_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","yaitu yang berusia 30 hingga 50 tahun, yang melayani dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Semuanya berjumlah 2.630 orang. ");
INSERT INTO indayt_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Itulah jumlah laki-laki yang dihitung dari keluarga Gerson, yaitu mereka yang melayani dalam tenda pertemuan. Musa dan Harun menghitungnya sesuai perintah TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Jumlah laki-laki dari kaum Merari dihitung menurut suku dan keluarganya, ");
INSERT INTO indayt_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","yaitu yang berusia 30 hingga 50 tahun, yang melayani dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Semuanya berjumlah 3.200 orang. ");
INSERT INTO indayt_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Itulah jumlah laki-laki yang dihitung dari keluarga Merari, yang dihitung oleh Musa dan Harun sesuai perintah TUHAN melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Jadi, Musa, Harun, dan para pemimpin Israel menghitung semua laki-laki keturunan Lewi menurut keluarga dan suku mereka. ");
INSERT INTO indayt_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Semua laki-laki yang berusia 30 hingga 50 tahun, yang melakukan tugas pelayanan dan membawa barang-barang dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Jumlah keseluruhannya adalah 8.580 orang. ");
INSERT INTO indayt_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Sesuai dengan perintah TUHAN melalui Musa, mereka semua dihitung. Masing-masing sesuai tugas dan barang yang harus dibawanya. Demikianlah mereka semua dihitung, seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Perintahkanlah umat Israel untuk mengeluarkan dari perkemahan semua orang yang terserang kusta, yang mengeluarkan lelehan, dan yang najis karena mayat. ");
INSERT INTO indayt_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kamu harus mengeluarkan mereka dari perkemahan, baik laki-laki maupun perempuan, supaya mereka tidak menajiskan perkemahan, tempat Aku tinggal di tengah-tengahmu.” ");
INSERT INTO indayt_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Maka, umat Israel melakukan hal itu. Mereka mengeluarkan orang-orang itu dari perkemahan. Mereka melakukannya seperti yang TUHAN firmankan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Katakanlah kepada umat Israel, seorang laki-laki maupun perempuan yang melakukan dosa tidak setia terhadap TUHAN sehingga orang itu bersalah, ");
INSERT INTO indayt_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","maka dia harus mengakui dosa yang telah dilakukannya, dan membayar ganti rugi penuh atas kesalahannya dengan menambah seperlima kepada orang yang telah dirugikannya itu. ");
INSERT INTO indayt_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Namun, bila orang yang dirugikan itu tidak memiliki kerabat yang dapat menerima ganti ruginya, ganti rugi itu harus diberikan kepada TUHAN dan menjadi milik imam. Dia juga harus memberikan seekor domba jantan pendamaian untuknya. ");
INSERT INTO indayt_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Semua pemberian kudus yang dipersembahkan umat Israel kepada imam, harus menjadi milik imam. ");
INSERT INTO indayt_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Jadi, setiap pemberian kudus yang dibawa seseorang adalah milik orang itu. Apa pun yang dia berikan kepada imam menjadi milik imam.” ");
INSERT INTO indayt_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Lalu, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Katakanlah kepada umat Israel: Jika seorang istri menyimpang dan tidak setia terhadap suaminya, ");
INSERT INTO indayt_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","dan seorang laki-laki melakukan hubungan dengannya tanpa sepengetahuan suaminya, dan dia tidak ketahuan telah menajiskan dirinya, serta tidak ada saksi yang melihatnya, sebab dia tidak tertangkap basah, ");
INSERT INTO indayt_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","kemudian bila roh kecemburuan menguasai suaminya sehingga dia merasa cemburu kepada istrinya yang telah menajiskan diri, atau bila roh kecemburuan menguasainya dan dia merasa cemburu kepada istrinya meski istrinya tidak menajiskan diri, ");
INSERT INTO indayt_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","maka pria itu harus membawa istrinya kepada imam beserta persembahan berupa sepersepuluh efa tepung jelai. Dia tidak boleh mencurahkan minyak atau kemenyan ke atas tepung itu sebab itu adalah kurban sajian kecemburuan, suatu kurban sajian pengingat, sebuah pengingat kesalahan. ");
INSERT INTO indayt_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Imam harus meminta wanita itu mendekat dan berdiri di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Imam akan membawa air kudus dalam sebuah tembikar, dan mengambil sedikit debu dari lantai Tenda Suci dan memasukannya ke dalam air itu. ");
INSERT INTO indayt_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Imam harus menyuruh wanita itu berdiri di hadapan TUHAN dengan rambut terurai, dan meletakkan kurban sajian pengingat, yaitu kurban sajian kecemburuan ke tangan wanita itu. Sedang imam memegang air pahit yang mendatangkan kutuk. ");
INSERT INTO indayt_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kemudian, imam harus meminta wanita itu bersumpah dengan berkata, ‘Apabila tidak ada laki-laki lain yang melakukan hubungan denganmu dan jika kamu tidak menyimpang pada kenajisan di belakang suamimu, kamu akan terbebas dari air pahit yang mendatangkan kutuk ini. ");
INSERT INTO indayt_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Akan tetapi, apabila kamu telah menyimpang, dan seorang laki-laki lain telah melakukan hubungan denganmu di belakang suamimu, ");
INSERT INTO indayt_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","TUHAN akan membuatmu menjadi kutuk dan sumpah di antara bangsamu, TUHAN membuat pahamu menyusut dan perutmu membengkak. ");
INSERT INTO indayt_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Air yang mendatangkan kutuk ini akan masuk ke dalam perutmu, membuat perutmu membengkak dan pahamu menyusut.’ Dan, wanita itu harus berkata, ‘Amin. Amin.’ ");
INSERT INTO indayt_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Imam harus menuliskan semua kutukan itu dalam sebuah gulungan kitab dan menghapusnya dengan air pahit tadi. ");
INSERT INTO indayt_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Kemudian, imam harus menyuruh wanita itu meminum air pahit yang mendatangkan kutuk tadi. Air itu akan masuk ke dalam tubuhnya dan mendatangkan rasa pahit. ");
INSERT INTO indayt_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Lalu, imam akan mengambil kurban sajian kecemburuan dari tangan wanita itu lalu mengunjukkannya di hadapan TUHAN dan membawanya ke atas mazbah. ");
INSERT INTO indayt_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Imam harus mengambil segenggam dari kurban sajian itu sebagai bagian pengingat dan membakarnya di atas mazbah. Sesudah itu, dia harus menyuruh wanita itu meminum air tersebut. ");
INSERT INTO indayt_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ketika imam telah menyuruh dia meminumnya, maka akan tampak, apabila dia telah menajiskan diri dan tidak setia kepada suaminya, air yang mendatangkan kutuk itu akan masuk ke dalam tubuhnya dan menyebabkan rasa pahit, perutnya akan membengkak dan pahanya menyusut, dan wanita itu akan menjadi kutuk di antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Akan tetapi, jika wanita itu tidak menajiskan dirinya dan masih suci, dia akan terbebas dan akan mendapat keturunan. ");
INSERT INTO indayt_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Itulah hukum tentang kecemburuan ketika seorang wanita menyimpang di belakang suaminya dan menajiskan dirinya, ");
INSERT INTO indayt_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","atau ketika roh kecemburuan menguasai seorang pria dan dia merasa cemburu kepada istrinya. Dia harus membawa istrinya ke hadapan TUHAN dan imam akan menerapkan semua hukum tadi kepada wanita itu. ");
INSERT INTO indayt_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Pria itu akan terbebas dari kesalahan, tetapi wanita itu akan menanggung kesalahannya.” ");
INSERT INTO indayt_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Katakanlah kepada umat Israel: Apabila seseorang bernazar khusus, yaitu nazar seorang nazir, untuk mengabdikan dirinya kepada TUHAN, ");
INSERT INTO indayt_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","dia tidak boleh minum anggur dan minuman keras. Dia tidak boleh meminum yang memabukkan, baik yang terbuat dari anggur maupun minuman keras lain. Dia juga tidak boleh minum air anggur dan memakan buah anggur, baik yang segar maupun yang dikeringkan. ");
INSERT INTO indayt_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Selama masa pengabdian diri itu, dia tidak boleh makan sesuatu yang dihasilkan oleh pohon anggur, bahkan sekalipun hanya dari biji atau kulitnya. ");
INSERT INTO indayt_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Selama masa nazarnya itu, dia tidak boleh mencukur rambutnya. Dia harus kudus sampai masa pengabdiannya kepada TUHAN itu berakhir. Dia harus membiarkan rambutnya tumbuh panjang. ");
INSERT INTO indayt_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Selama masa pengabdiannya kepada TUHAN, dia tidak boleh mendekati mayat. ");
INSERT INTO indayt_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Dia tidak boleh menajiskan dirinya dengan mayat ayah, ibu, saudara laki-laki, maupun saudara perempuannya bila mereka mati, karena nazarnya kepada Allah ada di atas kepalanya. ");
INSERT INTO indayt_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Selama masa pengabdiannya, orang itu harus kudus bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Namun, apabila ada yang mati mendadak di dekat orang itu, sehingga dia menajiskan rambut kepalanya yang telah dinazarkan itu, dia harus mencukur rambutnya pada hari penahirannya. Dia harus mencukurnya pada hari ketujuh. ");
INSERT INTO indayt_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Pada hari kedelapan, dia harus memberikan dua ekor burung tekukur atau dua ekor burung merpati muda kepada imam di pintu masuk tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Imam harus mempersembahkan yang seekor sebagai kurban penghapus dosa dan yang seekor lagi sebagai kurban bakaran. Imam harus mengadakan pendamaian untuknya karena dosanya yang disebabkan oleh orang yang mati mendadak tadi. Hari itu juga, dia harus menguduskan kepalanya ");
INSERT INTO indayt_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","dan kembali mengabdikan dirinya kepada TUHAN sebagai nazir. Dia harus membawa seekor domba jantan berumur setahun sebagai kurban penghapus salah. Masa yang sudah dia lewati sebagai nazir menjadi batal karena telah dinajiskan. ");
INSERT INTO indayt_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Dan, inilah hukum tentang seorang nazir: apabila seluruh masa pengabdiannya telah dipenuhi, dia harus membawa persembahan ke pintu tenda pertemuan, ");
INSERT INTO indayt_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","dan memberikan persembahan kepada TUHAN berupa: seekor domba jantan berumur setahun yang tidak bercacat untuk kurban bakaran; seekor domba betina berumur setahun yang tidak bercacat untuk kurban penghapus dosa; seekor domba jantan yang tidak bercacat untuk kurban pendamaian; ");
INSERT INTO indayt_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","satu keranjang roti tidak beragi, yang dibuat dari tepung halus yang dicampur dengan minyak; dan roti tipis yang tidak beragi, yang diperciki minyak; beserta kurban sajian dan persembahan curahan. ");
INSERT INTO indayt_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Imam harus membawa semua persembahan itu kepada TUHAN dan mempersembahkan kurban penghapus dosa dan kurban bakaran orang itu. ");
INSERT INTO indayt_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Bersama dengan sekeranjang roti tidak beragi, imam harus mempersembahkan domba jantan itu untuk kurban pendamaian. Demikian juga, imam harus mempersembahkan kurban sajian dan persembahan curahan. ");
INSERT INTO indayt_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Kemudian, orang yang bernazar itu harus mencukur rambut kepalanya di pintu tenda pertemuan, mengambil potongan rambutnya, dan memasukkannya ke dalam api yang berada di bawah persembahan kurban pendamaian. ");
INSERT INTO indayt_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kemudian, imam harus meletakkan bahu kambing jantan yang telah direbus, sepotong roti tidak beragi dari keranjang tadi, dan sepotong roti tipis yang tidak beragi ke telapak tangan nazir itu setelah dia mencukur rambut pengabdiannya. ");
INSERT INTO indayt_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Lalu, imam harus mengunjukkan semua itu ke hadapan TUHAN sebagai persembahan unjukan. Itu akan menjadi bagian yang kudus bagi imam bersama-sama dengan dada persembahan unjukan dan paha persembahan pemberian. Setelah itu, orang yang bernazar tadi boleh minum anggur. ");
INSERT INTO indayt_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Itulah hukum tentang seorang nazir, yang menazarkan persembahannya kepada TUHAN berdasarkan pengabdiannya, belum termasuk apa yang dapat dia berikan menurut kemampuannya sesuai dengan nazar yang diucapkannya. Berdasarkan sumpah yang dinazarkannya, demikianlah dia harus melakukannya sesuai dengan hukum kenaziran.” ");
INSERT INTO indayt_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Katakan kepada Harun dan anak-anaknya, ‘Beginilah kamu harus memberkati umat Israel, katakan: ");
INSERT INTO indayt_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","TUHAN memberkatimu dan melindungimu. ");
INSERT INTO indayt_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","TUHAN menyinarimu dengan wajah-Nya dan memberimu kasih karunia. ");
INSERT INTO indayt_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","TUHAN menghadapkan wajah-Nya kepadamu dan memberimu damai sejahtera.’” ");
INSERT INTO indayt_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Dengan begitu, Harun dan anak-anaknya akan menempatkan nama-Ku atas umat Israel, dan Aku akan memberkati mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musa telah selesai membangun Tenda Suci. Pada hari itu, dia mengurapi dan menahbiskannya beserta segala sesuatu yang ada di dalamnya. Dia juga menahbiskan mazbah dan semua perlengkapannya. ");
INSERT INTO indayt_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Kemudian, para pemimpin Israel, para kepala kaum mereka, memberikan persembahan. Mereka adalah para kepala keluarga. Merekalah yang dahulu menghitung jumlah umatnya. ");
INSERT INTO indayt_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Mereka membawa persembahan ke hadapan TUHAN di depan Tenda Suci. Mereka membawa 6 gerobak beratap dan 12 sapi jantan. Satu gerobak untuk setiap 2 pemimpin dan seekor sapi masing-masing satu. ");
INSERT INTO indayt_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Terimalah persembahan dari para pemimpin itu untuk digunakan dalam pelayanan tenda pertemuan. Berikan persembahan itu kepada orang Lewi, masing-masing sesuai dengan pelayanannya.” ");
INSERT INTO indayt_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Jadi, Musa menerima semua gerobak dan sapi itu serta menyerahkannya kepada orang Lewi. ");
INSERT INTO indayt_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Dia memberikan 2 gerobak dan 4 sapi kepada orang Gerson, sesuai pelayanan mereka, ");
INSERT INTO indayt_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","4 gerobak dan 8 sapi kepada keturunan Merari, sesuai dengan pelayanan mereka, di bawah pengarahan Itamar, anak Imam Harun. ");
INSERT INTO indayt_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Namun, kepada orang Kehat, Musa tidak memberikan apa-apa karena mereka bertugas mengangkut benda-benda suci di atas bahu mereka. ");
INSERT INTO indayt_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Para pemimpin membawa persembahan penahbisan ini pada hari mazbah itu diurapi. Jadi, mereka mempersembahkan persembahan mereka di depan mazbah. ");
INSERT INTO indayt_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","TUHAN berfirman kepada Musa, “Mereka harus mempersembahkan kurban mereka. Setiap hari, satu pemimpin harus membawa persembahan penahbisannya ke mazbah.” ");
INSERT INTO indayt_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Yang harus membawa persembahannya pada hari pertama adalah Nahason, anak Aminadab, dari suku Yehuda. ");
INSERT INTO indayt_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","seekor sapi jantan, seekor kambing jantan, seekor domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Nahason, anak Aminadab. ");
INSERT INTO indayt_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Pada hari kedua, Netaneel, anak Zuar, pemimpin suku Isakhar, membawa persembahan. ");
INSERT INTO indayt_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal tempat kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","seekor sapi jantan muda, seekor kambing jantan, seekor domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","seekor anak kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba berumur setahun untuk kurban pendamaian. Itulah persembahan Netaneel, anak Zuar. ");
INSERT INTO indayt_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Pada hari ketiga, Eliab, anak Helon, pemimpin suku Zebulon. ");
INSERT INTO indayt_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Eliab, anak Helon. ");
INSERT INTO indayt_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Pada hari keempat, Elizur, anak Syedeur, pemimpin suku Ruben. ");
INSERT INTO indayt_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","seekor anak sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Elizur, anak Syedeur. ");
INSERT INTO indayt_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Pada hari kelima, Selumiel, anak Zurisyadai, pemimpin suku Simeon. ");
INSERT INTO indayt_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Selumiel, anak Zurisyadai. ");
INSERT INTO indayt_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Pada hari keenam, Elyasaf, anak Rehuel, pemimpin suku Gad. ");
INSERT INTO indayt_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal tempat kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","seekor sapi jantan, seekor kambing jantan, seekor domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Elyasaf, anak Rehuel. ");
INSERT INTO indayt_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Pada hari ketujuh, Elisama, anak Amihud, pemimpin suku Efraim. ");
INSERT INTO indayt_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Elisama, anak Amihud. ");
INSERT INTO indayt_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pada hari kedelapan, Gamaliel, anak Pedazur, pemimpin suku Manasye. ");
INSERT INTO indayt_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Gamaliel, anak Pedazur. ");
INSERT INTO indayt_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Pada hari kesembilan, Abidan, anak Gideoni, pemimpin suku Benyamin. ");
INSERT INTO indayt_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Abidan, anak Gideoni. ");
INSERT INTO indayt_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Pada hari kesepuluh, Ahiezer, anak Amisyadai, pemimpin suku Dan. ");
INSERT INTO indayt_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Ahiezer, anak Amisyadai. ");
INSERT INTO indayt_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pada hari kesebelas, Pagiel, anak Okhran, pemimpin suku Asyer. ");
INSERT INTO indayt_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Pagiel, anak Okhran. ");
INSERT INTO indayt_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Pada hari kedua belas, Ahira, anak Enan, pemimpin suku Naftali. ");
INSERT INTO indayt_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Persembahannya berupa sebuah piring perak seberat 130 syikal, sebuah mangkuk perak seberat 70 syikal, menurut syikal kudus. Keduanya berisi penuh tepung halus yang dicampur dengan minyak untuk persembahan sajian. ");
INSERT INTO indayt_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Sebuah cawan emas seberat sepuluh syikal yang berisi kemenyan, ");
INSERT INTO indayt_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","seekor sapi jantan, seekor domba jantan, seekor anak domba jantan berumur setahun untuk kurban bakaran, ");
INSERT INTO indayt_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","seekor kambing jantan untuk kurban penghapus dosa, ");
INSERT INTO indayt_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","dua ekor sapi, lima ekor domba jantan, lima ekor kambing jantan, dan lima ekor anak domba jantan berumur setahun untuk kurban pendamaian. Itulah persembahan Ahira, anak Enan. ");
INSERT INTO indayt_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Inilah persembahan pengabdian dari para pemimpin Israel bagi mazbah saat mazbah itu diurapi: 12 piring perak, 12 mangkuk perak, 12 cawan emas. ");
INSERT INTO indayt_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Setiap piring perak beratnya 130 syikal, dan setiap mangkuk perak beratnya 70 syikal. Seluruh perlengkapan perak beratnya 2.400 syikal, menurut syikal kudus. ");
INSERT INTO indayt_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Kedua belas cawan emas, yang penuh dengan kemenyan, beratnya masing-masing sepuluh syikal, menurut syikal kudus. Seluruh cawan emas itu beratnya 120 syikal. ");
INSERT INTO indayt_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Jumlah keseluruhan binatang untuk kurban bakaran adalah 12 sapi jantan, 12 domba jantan, dan 12 domba jantan berumur setahun beserta kurban sajiannya, dan 12 kambing jantan untuk kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Jumlah seluruh hewan yang dipersembahkan sebagai kurban pendamaian adalah 24 ekor sapi jantan, 60 ekor domba jantan, 60 kambing jantan, dan 60 anak domba jantan berumur setahun. Itulah persembahan pengabdian untuk mazbah setelah mazbah itu diurapi. ");
INSERT INTO indayt_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ketika Musa memasuki tenda pertemuan untuk berbicara dengan-Nya, dia mendengar suara yang berbicara kepadanya, datangnya dari antara kedua kerub yang berada pada tutup pendamaian, di atas tabut kesaksian. Demikianlah Dia berbicara kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Katakanlah kepada Harun, ‘Apabila kamu memasang pelita, ketujuh pelita itu harus dapat menerangi daerah di depan kaki pelita.’” ");
INSERT INTO indayt_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harun pun melakukannya demikian. Dia menempatkan pelita-pelita itu pada bagian depan kakinya, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Beginilah kaki pelita itu dibuat: Dari alas hingga hiasan bunga-bunganya dikerjakan dengan cara ditempa. Sesuai contoh yang TUHAN tunjukkan kepada Musa, demikianlah dia membuat kaki pelita itu. ");
INSERT INTO indayt_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Pisahkanlah orang Lewi dari orang Israel lainnya dan sucikanlah mereka. ");
INSERT INTO indayt_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Inilah yang harus kamu lakukan untuk menyucikan mereka: Percikkan air dari persembahan penghapus dosa. Kemudian, mereka harus mencukur rambut di seluruh tubuh dan mencuci pakaian mereka. Dengan demikian mereka menjadi suci. ");
INSERT INTO indayt_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Mereka harus mengambil seekor sapi jantan beserta kurban sajiannya, yaitu tepung halus yang dicampur dengan minyak. Ambillah juga seekor sapi jantan yang lain untuk kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Bawalah orang Lewi ke depan tenda pertemuan. Kamu juga harus mengumpulkan seluruh umat Israel. ");
INSERT INTO indayt_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Bawalah orang Lewi ke hadapan TUHAN, dan umat Israel harus meletakkan tangan mereka ke atas orang Lewi. ");
INSERT INTO indayt_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Kemudian, Harun harus menyerahkan orang Lewi sebagai persembahan unjukan dari umat Israel kepada TUHAN. Dengan demikian, orang Lewi dapat melakukan pelayanan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lalu, orang-orang Lewi itu harus meletakkan tangan mereka ke kepala-kepala sapi jantan tadi. Setelah itu, persembahkanlah sapi yang satu sebagai kurban penghapus dosa dan yang lain sebagai kurban bakaran kepada TUHAN, untuk mengadakan pendamaian bagi orang Lewi. ");
INSERT INTO indayt_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Suruhlah orang Lewi berdiri di depan Harun dan anak-anaknya, untuk mempersembahkan mereka sebagai persembahan unjukan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Begitulah kamu harus memisahkan orang Lewi dari antara umat Israel sehingga orang Lewi menjadi milik-Ku. ");
INSERT INTO indayt_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Setelah kamu selesai menyucikan dan mempersembahkan orang Lewi sebagai persembahan unjukan, mereka boleh masuk ke tenda pertemuan untuk melayani. ");
INSERT INTO indayt_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Sebab, mereka semua telah diberikan kepada-Ku dari antara umat Israel. Aku telah mengambil mereka sebagai pengganti semua anak sulung umat Israel, yaitu semua yang lahir pertama kali dari rahim. ");
INSERT INTO indayt_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Karena semua anak sulung umat Israel adalah milik-Ku, baik manusia maupun binatang. Pada hari aku membinasakan semua anak sulung di negeri Mesir, Aku menguduskan anak-anak sulung Israel bagi-Ku. ");
INSERT INTO indayt_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Akan tetapi, Aku telah mengambil orang Lewi sebagai ganti semua anak sulung umat Israel. ");
INSERT INTO indayt_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Dari antara umat Israel, Aku telah memberikan orang Lewi sebagai pemberian kepada Harun dan anak-anaknya untuk melakukan tugas pelayanan bagi umat Israel di tenda pertemuan dan mengadakan pendamaian bagi mereka. Dengan begitu, umat Israel tidak akan mendapat tulah karena mendekati tempat kudus.” ");
INSERT INTO indayt_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Demikianlah dilakukan Musa, Harun, dan seluruh umat Israel kepada orang Lewi. Umat Israel memperlakukan orang Lewi seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Orang Lewi pun menyucikan diri mereka dan mencuci pakaian mereka. Kemudian, Harun memberikan mereka kepada TUHAN sebagai persembahan unjukan. Harun juga mengadakan pendamaian bagi mereka untuk menyucikan mereka. ");
INSERT INTO indayt_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Sesudah itu, orang Lewi datang ke tenda pertemuan untuk melaksanakan tugas mereka di hadapan Harun dan anak-anaknya. Sesuai dengan perintah TUHAN kepada Musa mengenai orang Lewi, demikianlah mereka melakukannya. ");
INSERT INTO indayt_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Lalu, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Inilah peraturan bagi orang Lewi: Semua laki-laki yang berusia 25 tahun atau lebih harus melayani dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Namun, pada usia 50 tahun, mereka harus berhenti dari tugas pelayanannya. ");
INSERT INTO indayt_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mereka boleh membantu saudara-saudaranya dalam melakukan tugas di tenda pertemuan, tetapi mereka sendiri tidak boleh mengerjakan pelayanan. Itulah yang harus kamu lakukan terhadap orang Lewi berkaitan dengan tanggung jawab mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Pada bulan pertama tahun kedua setelah orang Israel keluar dari negeri Mesir, TUHAN berfirman kepada Musa di padang gurun Sinai, ");
INSERT INTO indayt_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Umat Israel harus merayakan Pesakh pada waktu yang telah ditentukan. ");
INSERT INTO indayt_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Pada hari ke 14, bulan ini, pada waktu sore, harus kamu nyatakan sebagai waktu yang ditetapkan untuk merayakan Pesakh. Kamu harus merayakannya sesuai dengan ketetapan dan peraturannya.” ");
INSERT INTO indayt_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Lalu, Musa pun menyuruh umat Israel untuk merayakan Pesakh. ");
INSERT INTO indayt_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Umat Israel merayakan Pesakh di padang gurun Sinai waktu sore pada hari ke 14 bulan pertama. Mereka melakukannya tepat seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Namun, ada beberapa orang yang tidak dapat merayakan Pesakh sebab mereka najis karena mayat. Maka, mereka menemui Musa dan Harun pada hari itu ");
INSERT INTO indayt_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","dan berkata kepadanya, “Meski kami najis karena mayat, tetapi mengapa kami ditahan untuk tidak memberikan persembahan kepada TUHAN pada waktu yang telah ditentukan bersama dengan orang Israel lainnya?” ");
INSERT INTO indayt_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa menjawab mereka, “Tunggulah dahulu. Aku akan bertanya kepada TUHAN mengenai kamu.” ");
INSERT INTO indayt_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Kemudian, TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Katakanlah kepada umat Israel: ‘Apabila seseorang dari antaramu atau keturunanmu menjadi najis karena mayat, atau sedang dalam perjalanan, dia tetap harus merayakan Pesakh bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mereka harus merayakannya pada waktu sore, hari ke 14 bulan kedua. Mereka harus memakan domba Pesakh dengan roti tidak beragi dan sayur pahit. ");
INSERT INTO indayt_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Mereka tidak boleh menyisakannya sampai esok paginya dan tidak boleh mematahkan tulangnya. Mereka harus merayakannya sesuai dengan semua peraturan Pesakh. ");
INSERT INTO indayt_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Akan tetapi, orang yang tidak najis dan tidak sedang dalam perjalanan, tetapi mengabaikan Pesakh, harus dibinasakan dari antara bangsanya. Sebab, dia tidak memberikan persembahan kepada TUHAN pada waktu yang telah ditetapkan. Dia akan menanggung dosanya. ");
INSERT INTO indayt_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Apabila ada orang asing yang tinggal di antaramu merayakan Pesakh bagi TUHAN, dia harus melakukannya menurut ketetapan dan peraturan Pesakh. Hanya ada satu peraturan berlaku baik bagimu maupun bagi pendatang di negerimu.” ");
INSERT INTO indayt_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Setelah Tenda Suci didirikan, awan melingkupi tenda itu, yakni tenda kesaksian. Pada malam hingga pagi hari, awan itu tampak seperti api. ");
INSERT INTO indayt_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Jadi, awan itu terus-menerus melingkupinya sepanjang siang hari dan dalam rupa api pada malam hari. ");
INSERT INTO indayt_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Setiap kali awan naik dari tenda itu, umat Israel akan berangkat. Mereka akan berkemah di tempat awan itu berhenti bergerak. ");
INSERT INTO indayt_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Umat Israel berangkat menurut perintah TUHAN dan berkemah menurut perintah TUHAN. Selama awan masih melingkupi Tenda Suci, umat Israel tetap berkemah di situ. ");
INSERT INTO indayt_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ketika awan itu melingkupi Tenda Suci untuk waktu yang lama, umat Israel akan tetap mematuhi TUHAN dan tidak berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kadang-kadang, awan itu melingkupi Tenda Suci selama beberapa hari saja, dan umat Israel tetap berkemah di situ sesuai dengan perintah TUHAN. Lalu, mereka akan berangkat jika TUHAN memerintahkannya. ");
INSERT INTO indayt_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kadang-kadang, awan itu hanya tinggal dari petang hingga pagi. Ketika pagi harinya awan itu bergerak, umat Israel akan berangkat. Atau, jika awan itu tidak bergerak sampai siang hari, dan baru bergerak pada malam harinya, kapan saja awan itu bergerak, mereka akan berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Entah awan itu melingkupi Tenda Suci selama dua hari, sebulan, ataupun setahun, umat Israel akan terus berkemah dan tidak berangkat. Namun, apabila awan itu bergerak, mereka pun berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Umat Israel berangkat menurut perintah TUHAN dan berkemah menurut perintah TUHAN. Mereka mematuhi pimpinan TUHAN, seperti yang Dia perintahkan melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Buatlah dua buah trompet dari perak yang ditempa. Pakailah itu untuk mengumpulkan umat dan untuk menyuruh mereka berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Apabila kedua trompet itu ditiup, seluruh umat Israel harus berkumpul di depan pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Namun, jika satu trompet saja yang ditiup, hanya para pemimpin suku yang berkumpul di hadapanmu. ");
INSERT INTO indayt_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ketika kamu meniup suatu tanda peringatan, berarti perkemahan yang ada di sebelah Timur harus berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ketika kamu meniup tanda peringatan untuk kedua kalinya, berarti perkemahan yang ada di sebelah Selatan harus berangkat. Tanda peringatan harus dibunyikan untuk menyuruh mereka berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Namun, untuk mengumpulkan umat, kamu harus meniupnya tanpa tanda peringatan. ");
INSERT INTO indayt_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Anak-anak Harunlah, yaitu para imam, yang harus meniup trompet. Ini akan menjadi ketetapan bagimu selamanya, dari generasi ke generasi. ");
INSERT INTO indayt_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Jika kamu berperang di negerimu melawan musuh yang menindasmu, bunyikanlah tanda peringatan dengan trompet itu, supaya kamu diingat di hadapan TUHAN, Allahmu, dan diselamatkan dari musuh-musuhmu. ");
INSERT INTO indayt_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Kamu juga harus meniupkan trompet pada hari sukacitamu, pada perayaan-perayaan yang sudah ditetapkan, dan pada pergantian bulan, saat kamu mempersembahkan kurban bakaran dan kurban pendamaian. Itu akan menjadi pengingat akan kamu bagi Allahmu. Akulah TUHAN, Allahmu.” ");
INSERT INTO indayt_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Pada tanggal 20 bulan kedua, tahun kedua, awan yang melingkupi tenda kesaksian bergerak. ");
INSERT INTO indayt_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Umat Israel pun memulai perjalanan mereka dari padang gurun Sinai dan berjalan sampai awan itu berhenti di padang gurun Paran. ");
INSERT INTO indayt_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Itulah pertama kalinya umat Israel pindah atas perintah TUHAN melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Bendera perkemahan Yehuda berangkat pertama kali, menurut pasukan-pasukannya, dengan dipimpin oleh Nahason, anak Aminadab. ");
INSERT INTO indayt_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneel, anak Zuar, memimpin suku Isakhar. ");
INSERT INTO indayt_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Dan, Eliab anak Helon, memimpin suku Zebulon. ");
INSERT INTO indayt_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Kemudian, Tenda Suci dibongkar. Orang-orang dari keluarga Gerson dan Merari yang mengangkut Tenda Suci itu pun berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Bendera perkemahan Ruben yang berangkat berikutnya, menurut pasukan-pasukannya, dengan dipimpin oleh Elizur, anak Syedeur. ");
INSERT INTO indayt_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumiel, anak Zurisyadai, memimpin suku Simeon. ");
INSERT INTO indayt_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Dan, Elyasaf, anak Rehuel, memimpin suku Gad. ");
INSERT INTO indayt_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kemudian, orang-orang Kehat berangkat dengan mengangkut benda-benda kudus. Tenda Suci sudah dipasang sebelum mereka tiba. ");
INSERT INTO indayt_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Selanjutnya, panji perkemahan Efraim berangkat menurut pasukan-pasukannya, dipimpin oleh Elisama, anak Amihud. ");
INSERT INTO indayt_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, anak Pedazur, memimpin suku Manasye. ");
INSERT INTO indayt_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Dan, Abidan, anak Gideoni, memimpin suku Benyamin. ");
INSERT INTO indayt_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kemudian panji suku Dan berangkat menurut pasukan-pasukannya, dengan dipimpin oleh Ahiezer, anak Amisyadai. Mereka membentuk pengawalan dari belakang bagi seluruh perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, anak Okhran, memimpin suku Asyer. ");
INSERT INTO indayt_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Dan, Ahira, anak Enan, memimpin suku Naftali. ");
INSERT INTO indayt_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Itulah urutan keberangkatan umat Israel menurut pasukan mereka ketika berangkat. ");
INSERT INTO indayt_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa berkata kepada Hobab, anak Rehuel orang Midian, ayah mertua Musa, “Kami berangkat menuju tempat yang dikatakan TUHAN, ‘Aku akan memberikannya kepadamu.’ Mari, ikutlah dengan kami dan kami akan memperlakukanmu dengan baik. Sebab, TUHAN telah menjanjikan yang baik kepada Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Namun, Hobab menjawab, “Tidak, aku tidak akan ikut, aku akan kembali ke negeriku dan kepada keluargaku.” ");
INSERT INTO indayt_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa menjawab, “Tolong, jangan tinggalkan kami. Engkau yang tahu bagaimana berkemah di padang gurun, dan engkau dapat menjadi mata bagi kami. ");
INSERT INTO indayt_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Jika kamu pergi bersama kami, semua kebaikan yang dilakukan TUHAN kepada kami akan kami lakukan juga kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Jadi, mereka berangkat dari gunung TUHAN selama tiga hari perjalanan. Tabut Perjanjian TUHAN berjalan di depan mereka selama tiga hari, untuk mencari tempat perhentian bagi mereka. ");
INSERT INTO indayt_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Awan TUHAN berada di atas mereka selama siang hari saat mereka berangkat dari perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ketika mereka mengangkat tabut, Musa berkata, “Bangkitlah, ya TUHAN! Biarlah musuh-musuh-Mu berserak. Biarlah orang-orang yang membenci-Mu melarikan diri dari hadapan-Mu.” ");
INSERT INTO indayt_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Apabila tabut berhenti, Musa berkata, “Kembalilah, ya TUHAN, kepada beribu laksa umat Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Bangsa itu menjadi jahat dengan mulai mengeluh di hadapan TUHAN. Ketika TUHAN mendengar itu, kemarahan-Nya pun berkobar, dan api TUHAN menyala di antara mereka dan membakar tepi perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Umat itu meminta tolong kepada Musa, Musa berdoa kepada TUHAN dan api itu pun padam. ");
INSERT INTO indayt_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Itulah sebabnya tempat itu dinamai Tabera, sebab api TUHAN menyala di antara mereka. ");
INSERT INTO indayt_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Para pembuat onar yang ada di antara mereka memiliki nafsu rakus, dan umat Israel pun mulai meratap lagi serta berkata, “Siapa yang akan memberi kita daging untuk makan? ");
INSERT INTO indayt_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Kita teringat akan ikan yang kita makan di Mesir secara cuma-cuma. Juga mentimun, semangka, daun bawang, bawang merah, dan bawang putih. ");
INSERT INTO indayt_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Akan tetapi sekarang, kita kurus, tidak ada apa pun selain manna ini yang kita lihat.” ");
INSERT INTO indayt_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna itu seperti biji ketumbar dan warnanya seperti damar. ");
INSERT INTO indayt_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Orang harus berjalan ke sana kemari untuk mengumpulkannya, dan menggilingnya dengan batu kilangan atau menumbuknya dalam lumpang, lalu merebusnya dalam periuk dan membuat roti darinya. Rasanya seperti roti yang dimasak dengan minyak. ");
INSERT INTO indayt_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Manna itu turun ke perkemahan bersamaan dengan embun yang turun pada malam hari. ");
INSERT INTO indayt_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa mendengar bahwa umat itu sedang mengeluh, masing-masing di pintu tendanya. Murka TUHAN menyala dengan sangat, dan Musa tidak senang akan hal ini. ");
INSERT INTO indayt_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa berkata kepada TUHAN, “Mengapa Engkau begitu keras terhadap hamba-Mu ini? Mengapa aku tidak mendapat perkenanan di hadapan-Mu sehingga Engkau memikulkan semua beban umat ini kepadaku? ");
INSERT INTO indayt_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Apakah aku yang telah mengandung dan melahirkan umat ini, sehingga Engkau berkata kepadaku, ‘Gendonglah mereka di dadamu seperti seorang pengasuh menggendong bayi menyusui, menuju negeri yang Engkau janjikan kepada nenek moyang mereka?’ ");
INSERT INTO indayt_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Dari mana aku bisa mendapatkan daging untuk diberikan kepada mereka? Sebab mereka meratap kepadaku, ‘Berilah kami daging untuk dimakan.’ ");
INSERT INTO indayt_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Aku tidak sanggup menanggung seluruh umat ini sendirian, terlalu berat bagiku. ");
INSERT INTO indayt_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Sebab itu, jika Engkau memperlakukanku seperti ini, mohon bunuh saja aku, apabila aku mendapat perkenan di hadapan-Mu, jangan biarkan aku melihat celakaku.” ");
INSERT INTO indayt_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","TUHAN berfirman kepada Musa, “Kumpulkanlah bagi-Ku 70 orang dari antara tua-tua Israel, yang kamu ketahui merupakan tua-tua umat dan pemimpin mereka, dan bawalah mereka ke tenda pertemuan, dan suruhlah mereka berdiri bersamamu di sana. ");
INSERT INTO indayt_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Aku akan turun dan berbicara denganmu di sana. Aku akan mengambil sebagian roh yang ada padamu sekarang dan memberikannya kepada mereka. Dengan demikian, kamu tidak akan memikul beban itu seorang diri sebab mereka akan memikulnya bersamamu. ");
INSERT INTO indayt_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Katakanlah kepada umat, ‘Kuduskanlah dirimu untuk besok dan kamu akan makan daging. Sebab, kamu telah meratap kepada TUHAN dengan berkata, ‘Siapa yang akan memberi kami daging untuk dimakan! Lebih baik kami tinggal di Mesir.’ Oleh sebab itu, TUHAN akan memberimu daging untuk kamu makan. ");
INSERT INTO indayt_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Kamu akan memakannya bukan hanya sehari, 2 hari, 5 hari, 10 hari, atau 20 hari, ");
INSERT INTO indayt_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","melainkan selama sebulan penuh, sampai itu keluar dari hidungmu dan membuatmu jijik. Karena kamu telah menolak TUHAN yang tinggal di antaramu dan meratap di hadapan-Nya dengan berkata, ‘Mengapa dahulu kita meninggalkan Mesir?’” ");
INSERT INTO indayt_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Akan tetapi, Musa berkata, “Umat yang tinggal bersamaku aku tinggal ini berjumlah 600 ribu orang yang berjalan kaki, dan Engkau berkata, ‘Aku akan memberi mereka daging untuk dimakan selama sebulan penuh.’ ");
INSERT INTO indayt_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Haruskah seluruh ternak disembelih supaya cukup untuk mereka semua? Atau haruskah seluruh ikan di laut dikumpulkan supaya cukup untuk mereka semua?” ");
INSERT INTO indayt_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","TUHAN berkata kepada Musa, “Apakah kuasa-Ku terbatas? Sekarang, kamu akan melihat apakah perkataan-Ku itu menjadi kenyataan atau tidak.” ");
INSERT INTO indayt_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Jadi, Musa keluar dan menyampaikan perkataan TUHAN kepada umat. Dia juga mengumpulkan 70 orang dari antara tua-tua Israel dan menyuruh mereka berdiri di sekeliling tenda. ");
INSERT INTO indayt_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kemudian, TUHAN turun dalam awan dan berbicara kepadanya. Dia mengambil sebagian roh yang ada pada Musa dan memberikannya kepada ketujuh puluh tua-tua itu. Ketika roh-Nya turun ke atas mereka, mereka bernubuat. Namun, mereka tidak melakukannya lagi. ");
INSERT INTO indayt_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Akan tetapi, ada dua orang yang tetap tinggal di perkemahan. Nama mereka adalah Eldad dan Medad. Roh turun ke atas mereka, mereka termasuk dalam orang-orang yang terdaftar, tetapi tidak pergi ke tenda, dan mereka bernubuat di perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Seorang pemuda berlari dan memberi tahu Musa, “Eldad dan Medad bernubuat di perkemahan.” ");
INSERT INTO indayt_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yosua, anak Nun, hamba Musa sejak masa mudanya, berkata kepada Musa, “Tuanku, Musa, hentikanlah mereka!” ");
INSERT INTO indayt_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Namun, Musa berkata kepadanya, “Apakah kamu iri demi aku? Biarlah semua umat menjadi nabi sehingga TUHAN memberikan roh-Nya kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Kemudian, Musa dan tua-tua Israel kembali ke perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kemudian, angin dari TUHAN bertiup membawa burung puyuh dari laut dan menjatuhkan burung puyuh ke perkemahan, seluas satu hari perjalanan ke arah sini dan sehari perjalanan ke arah sana di sekeliling perkemahan, dua hasta tingginya dari tanah. ");
INSERT INTO indayt_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Sepanjang hari itu, sepanjang malam itu, dan sepanjang hari berikutnya, mereka bangun mengumpulkan burung puyuh. Mereka mengumpulkan paling sedikit sepuluh homer, dan menyebarkannya di sekeliling perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Selagi daging itu masih berada di antara gigi mereka, sebelum dikunyah, kemarahan TUHAN menyala terhadap mereka, dan TUHAN menghajar umat itu dengan tulah yang hebat. ");
INSERT INTO indayt_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Oleh sebab itu, tempat itu dinamai Kibrot-Taawa karena di situlah mereka menguburkan orang-orang yang rakus. ");
INSERT INTO indayt_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Dari Kibrot-Taawa, umat Israel berangkat ke Hazerot dan menetap di sana. ");
INSERT INTO indayt_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miryam dan Harun berbicara menentang Musa perihal wanita Kush yang dia nikahi, sebab dia telah menikahi seorang wanita Kush. ");
INSERT INTO indayt_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Mereka berkata, “Apakah memang TUHAN hanya berbicara melalui Musa saja? Tidakkah Dia juga berbicara melalui kita?” Dan, TUHAN mendengar hal itu. ");
INSERT INTO indayt_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa adalah seorang yang sangat lembut hati, lebih daripada semua orang di muka bumi. ");
INSERT INTO indayt_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Tiba-tiba, TUHAN berkata kepada Musa, Harun, dan Miryam, “Kalian bertiga, datanglah ke tenda pertemuan sekarang!” Jadi, ketiganya pun pergi. ");
INSERT INTO indayt_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Lalu, TUHAN turun dalam tiang awan dan berdiri di pintu masuk tenda. Dia memanggil Harun dan Miryam. Keduanya pun menghadap. ");
INSERT INTO indayt_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","TUHAN berkata, “Dengarkanlah perkataan-Ku! Jika ada seorang nabi di antaramu, Aku, TUHAN, akan menyatakan diri-Ku kepadanya dalam penglihatan. Aku akan berbicara kepadanya melalui mimpi. ");
INSERT INTO indayt_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tidak demikian halnya dengan Musa. Dia adalah hamba yang setia di rumah-Ku. ");
INSERT INTO indayt_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Dengan dia, Aku berbicara mulut ke mulut, jelas, dan tidak menggunakan maksud yang tersembunyi. Dia melihat rupa TUHAN. Kalau demikian, mengapa kalian tidak takut menentang hamba-Ku Musa?” ");
INSERT INTO indayt_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Murka TUHAN menyala terhadap mereka dan Dia pergi. ");
INSERT INTO indayt_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ketika tiang awan telah meninggalkan tenda, tampaklah Miryam terkena kusta, seperti salju. Saat Harun menoleh kepada Miryam, dia melihatnya terkena kusta. ");
INSERT INTO indayt_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Lalu, Harun berkata kepada Musa, “Tuanku, kumohon kepadamu, jangan timpakan dosa ini ke atas kami, kami telah bertindak bodoh dan telah berbuat salah. ");
INSERT INTO indayt_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Janganlah biarkan Miryam menjadi seperti seorang mati, yang dagingnya sudah setengah membusuk saat keluar dari rahim ibunya.” ");
INSERT INTO indayt_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa pun berseru kepada TUHAN, “Ya Allah, mohon sembuhkanlah dia!” ");
INSERT INTO indayt_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","TUHAN berkata kepada Musa, “Seandainya ayah Miryam meludahi wajahnya, bukankah dia harus menanggung malu selama tujuh hari? Biarlah dia dikucilkan di luar perkemahan selama tujuh hari. Sesudah itu, dia dapat diterima kembali.” ");
INSERT INTO indayt_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Jadi, Miryam diasingkan di luar perkemahan selama tujuh hari. Dan, umat Israel tidak berangkat sebelum Miryam kembali. ");
INSERT INTO indayt_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Sesudah itu, umat Israel meninggalkan Hazerot dan berkemah di padang gurun Paran. ");
INSERT INTO indayt_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Utuslah orang untuk mengintai tanah Kanaan, yang akan Kuberikan kepada anak-anak Israel. Kamu harus mengutus seorang dari tiap suku, setiap pemimpin dari antara mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Sesuai dengan perintah TUHAN, Musa mengutus mereka dari padang gurun Paran, orang-orang itu semuanya merupakan para pemimpin orang Israel. ");
INSERT INTO indayt_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Inilah nama-nama mereka: dari suku Ruben — Syamua, anak Zakur; ");
INSERT INTO indayt_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","dari suku Simeon — Safat, anak Hori; ");
INSERT INTO indayt_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","dari suku Yehuda — Kaleb, anak Yefune; ");
INSERT INTO indayt_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","dari suku Isakhar — Yigal, anak Yusuf; ");
INSERT INTO indayt_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","dari suku Efraim — Hosea, anak Nun; ");
INSERT INTO indayt_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","dari suku Benyamin — Palti, anak Rafu; ");
INSERT INTO indayt_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","dari suku Zebulon — Gadiel, anak Sodi; ");
INSERT INTO indayt_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","dari suku Yusuf, yaitu dari suku Manasye — Gadi, anak Susi; ");
INSERT INTO indayt_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","dari suku Dan — Amiel, anak Gemali; ");
INSERT INTO indayt_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","dari suku Asyer — Setur, anak Mikhael; ");
INSERT INTO indayt_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","dari suku Naftali — Nahbi, anak Wofsi; ");
INSERT INTO indayt_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","dari suku Gad — Guel, anak Makhi. ");
INSERT INTO indayt_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Itulah nama orang-orang yang diutus Musa untuk mengintai negeri itu. Dan, Musa menyebut Hosea, anak Nun, sebagai Yosua. ");
INSERT INTO indayt_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ketika Musa mengutus mereka mengintai tanah Kanaan, dia berkata, “Naiklah ke selatan lalu naiklah ke daerah pegunungan. ");
INSERT INTO indayt_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Lihatlah seperti apa negeri itu, apakah orang-orang yang tinggal di sana kuat atau lemah, banyak atau sedikit, ");
INSERT INTO indayt_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","dan bagaimana negeri tempat mereka tinggal, apakah baik atau buruk, bagaimana kota-kota mereka, apakah seperti perkemahan atau berbenteng, ");
INSERT INTO indayt_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","dan bagaimana tanah itu, apakah subur atau kering, apakah ada pepohonan atau tidak di sana. Kuatkanlah dirimu dan bawalah beberapa buah dari negeri itu.” Saat itu adalah masa panen pertama buah anggur. ");
INSERT INTO indayt_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Mereka pun pergi dan mengintai negeri itu, mulai dari padang gurun Sin sampai ke Rehob di Hamat. ");
INSERT INTO indayt_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Mereka berjalan naik ke selatan dan sampai ke Hebron. Di situ tinggal keturunan Enak, yaitu Ahiman, Sesai, dan Talmai. Hebron dibangun 7 tahun sebelum Soan di Mesir. ");
INSERT INTO indayt_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kemudian, mereka tiba di lembah Eskol. Di situ, mereka memotong setandan buah anggur. Mereka mengangkutnya dengan kayu dipikul dua orang, juga beberapa delima dan buah ara. ");
INSERT INTO indayt_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Tempat itu dinamai lembah Eskol karena di situlah orang Israel memotong tandan buah anggur. ");
INSERT INTO indayt_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Mereka menyelidiki negeri itu selama 40 hari. Sesudah itu, mereka kembali. ");
INSERT INTO indayt_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mereka datang kepada Musa dan Harun dan seluruh umat Israel di padang gurun Paran, di Kadesh. Mereka menyampaikan laporan kepada mereka dan seluruh umat, juga menunjukkan buah dari negeri itu. ");
INSERT INTO indayt_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Mereka berkata kepada Musa, “Kami sudah pergi ke negeri ke mana engkau utus kami. Negeri itu memang berlimpah dengan susu dan madu. Inilah buah dari sana. ");
INSERT INTO indayt_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Akan tetapi, bangsa yang tinggal di sana sangat kuat. Kota-kotanya sangat besar dan berbenteng. Bahkan, kami melihat beberapa orang Enak di sana. ");
INSERT INTO indayt_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Orang-orang Amalek tinggal di selatan. Orang Het, Yebus, dan Amori tinggal di daerah perbukitan. Orang Kanaan tinggal di tepi laut dan sepanjang Sungai Yordan.” ");
INSERT INTO indayt_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Namun, Kaleb menenangkan orang-orang yang ada di hadapan Musa, lalu berkata, “Kita akan pergi ke sana dan menduduki negeri itu. Sebab, kita pasti sanggup menguasainya.” ");
INSERT INTO indayt_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Namun, mereka yang pergi bersama dia berkata, “Kita tidak akan mampu melawan orang-orang itu sebab mereka lebih kuat daripada kita.” ");
INSERT INTO indayt_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Demikianlah mereka menyampaikan laporan buruk kepada umat Israel tentang negeri yang mereka intai dengan berkata, “Negeri yang kami intai itu merupakan negeri yang memakan penduduknya. Semua orang yang kami lihat di sana berperawakan besar. ");
INSERT INTO indayt_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Kami juga melihat orang-orang Nefilim di sana yaitu keturunan Enak! Kami melihat diri kami sendiri seperti belalang, demikian pula mereka melihat kami.” ");
INSERT INTO indayt_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Malam itu, umat itu mengeluh dengan nyaring serta meratap. ");
INSERT INTO indayt_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Orang Israel menggerutu terhadap Musa dan Harun, dan seluruh umat berkata kepada mereka, “Alangkah baiknya kalau kami mati di Mesir atau di padang gurun ini saja. ");
INSERT INTO indayt_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mengapa TUHAN membawa kami ke negeri ini untuk dibunuh dengan pedang? Istri dan anak-anak kami akan menjadi tawanan. Bukankah lebih baik jika kami kembali ke Mesir?” ");
INSERT INTO indayt_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Maka, mereka berkata satu sama lain, “Mari kita angkat seorang pemimpin, lalu kembali ke Mesir.” ");
INSERT INTO indayt_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Musa dan Harun sujud dengan mukanya ke tanah di depan kumpulan semua orang Israel itu. ");
INSERT INTO indayt_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yosua, anak Nun, dan Kaleb, anak Yefune, yang ikut mengintai negeri itu, merobek pakaian mereka. ");
INSERT INTO indayt_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Mereka berkata kepada kumpulan umat Israel, “Negeri yang kami jalani untuk diintai itu sangat baik. ");
INSERT INTO indayt_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Jika TUHAN berkenan kepada kita, Dia akan membawa kita memasuki negeri itu dan akan memberikannya kepada kita, suatu negeri yang berlimpah dengan susu dan madu. ");
INSERT INTO indayt_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hanya saja, jangan memberontak melawan TUHAN, dan jangan takut kepada penduduk tanah itu, sebab bagi kita, mereka adalah mangsa. Perlindungan mereka telah meninggalkan mereka, dan TUHAN menyertai kita. Jadi, jangan takut kepada mereka!” ");
INSERT INTO indayt_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Namun, umat itu mengatakan hendak merajam keduanya dengan batu. Lalu, kemuliaan TUHAN muncul di tenda pertemuan di hadapan seluruh umat Israel. ");
INSERT INTO indayt_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","TUHAN berkata kepada Musa, “Sampai kapan umat ini akan menghina Aku? Sampai kapan mereka tidak mau percaya kepada-Ku? Padahal, Aku telah melakukan banyak mukjizat di antara mereka. ");
INSERT INTO indayt_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Aku akan membinasakan mereka semua dengan penyakit sampar dan membuang mereka. Aku akan membuatmu menjadi bangsa yang jauh lebih besar dan lebih kuat daripada mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa berkata kepada TUHAN, “Nanti orang Mesir akan mendengarnya, sebab Engkau telah membawa bangsa ini keluar dari tengah mereka dengan kuasa-Mu yang besar. ");
INSERT INTO indayt_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Dan, mereka akan memberitahukan hal itu kepada penduduk negeri ini. Mereka sudah mendengar bahwa Engkau, ya TUHAN, menyertai umat ini. Sebab, Engkau, ya TUHAN, telah menampakkan diri kepada umat-Mu, awan-Mu ada di atas mereka, Engkau berjalan di depan mereka dalam tiang awan pada siang hari dan tiang api pada malam hari. ");
INSERT INTO indayt_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Apabila Engkau membinasakan umat ini sekaligus, maka bangsa-bangsa yang telah mendengar kemashyuran-Mu akan berkata, ");
INSERT INTO indayt_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘TUHAN tidak mampu membawa mereka ke negeri yang telah Dia janjikan kepada mereka dengan sumpah, karena itulah Dia membinasakan mereka semua di padang gurun.’ ");
INSERT INTO indayt_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Jadi sekarang, ya Tuhan, aku berdoa, biarlah kuasa-Mu diagungkan, seperti yang telah Engkau nyatakan dengan berkata, ");
INSERT INTO indayt_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘TUHAN itu lambat untuk marah, berlimpah dengan kasih setia, mengampuni kesalahan dan pelanggaran. Namun, Dia tidak membiarkan orang yang bersalah tidak dihukum, membalaskan kesalahan ayah kepada anak-anaknya sampai keturunan ketiga dan keempat.’ ");
INSERT INTO indayt_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ampunilah kesalahan umat ini sesuai dengan kebesaran kasih setia-Mu itu, sebagaimana Engkau telah senantiasa mengampuni mereka mulai dari Mesir hingga sekarang.” ");
INSERT INTO indayt_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jawab TUHAN, “Aku telah mengampuni mereka sesuai dengan permintaanmu. ");
INSERT INTO indayt_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Namun, sesungguhnya, demi Aku yang hidup dan kemuliaan TUHAN akan memenuhi seluruh bumi: ");
INSERT INTO indayt_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Semua orang yang telah melihat kemuliaan-Ku dan mukjizat-Ku yang Kulakukan di Mesir dan di padang gurun, tetapi telah mencobai Aku sepuluh kali dan tidak mendengarkan suara-Ku, ");
INSERT INTO indayt_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tidak akan melihat negeri yang telah Aku janjikan kepada nenek moyang mereka, juga semua orang yang telah menghina Aku. ");
INSERT INTO indayt_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Akan tetapi, hamba-Ku Kaleb akan Kubawa masuk ke negeri yang dia masuki itu dan keturunannya akan memiliki negeri itu. Sebab, dia memiliki roh yang berbeda dan telah mengikuti Aku dengan sepenuhnya. ");
INSERT INTO indayt_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Orang Amalek dan orang Kanaan tinggal di lembah-lembah itu, berbaliklah besok dan berangkatlah ke padang gurun melalui jalan Laut Teberau.” ");
INSERT INTO indayt_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","TUHAN berfirman kepada Musa dan Harun, ");
INSERT INTO indayt_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Berapa lama lagi Aku harus bersabar terhadap umat yang jahat yang menggerutu terhadap Aku? Aku telah mendengar gerutuan umat Israel terhadap-Ku. ");
INSERT INTO indayt_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Katakanlah kepada mereka, ‘TUHAN berkata, Demi Aku yang hidup, Aku akan melakukan kepadamu sesuai dengan apa yang Aku dengar dari kata-katamu: ");
INSERT INTO indayt_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mayatmu akan bergelimpangan di padang gurun ini. Dari semua laki-laki yang tercatat, yaitu mereka yang berusia 20 tahun atau lebih, yang telah menggerutu terhadap Aku, ");
INSERT INTO indayt_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","tidak seorang pun dari mereka yang akan masuk ke negeri yang telah Kujanjikan untuk kamu tinggali, kecuali Kaleb, anak Yefune, dan Yosua, anak Nun. ");
INSERT INTO indayt_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Namun, anak-anakmu, yang kamu katakan akan menjadi mangsa, akan Kubawa masuk ke negeri itu. Mereka akan menikmati negeri yang kamu tolak itu. ");
INSERT INTO indayt_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Sementara untuk kalian, mayat kalian akan bergelimpangan di padang gurun ini. ");
INSERT INTO indayt_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Anak-anakmu akan menjadi gembala selama 40 tahun di padang gurun. Mereka akan menderita karena ketidaksetiaanmu, sampai kalian semua mati di padang gurun. ");
INSERT INTO indayt_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Sesuai jumlah hari ketika kamu mengintai negeri itu, yaitu empat puluh hari, untuk setiap harinya kamu harus menanggung kesalahanmu selama setahun, genap empat puluh tahun. Dengan demikian, kamu akan mengetahui permusuhan-Ku.’ ");
INSERT INTO indayt_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Aku, TUHAN, telah berfirman. Aku pasti akan melakukan hal itu kepada seluruh umat yang jahat ini, yang telah berkumpul bersama menentang Aku. Di gurun ini mereka akan dibinasakan. Di situlah mereka akan mati.’” ");
INSERT INTO indayt_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Sementara itu, para pengintai yang diutus Musa untuk mengintai negeri itu, yang telah kembali dan menyebabkan umat menggerutu kepadanya dengan menyampaikan laporan yang buruk tentang negeri itu, ");
INSERT INTO indayt_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","orang-orang yang mengarang kabar buruk tentang tanah itu, mati terkena tulah di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Dari semua orang yang diutus mengintai negeri itu, hanya Yosua, anak Nun dan Kaleb, anak Yefune yang tetap hidup. ");
INSERT INTO indayt_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ketika Musa menyampaikan hal itu kepada semua orang Israel, bangsa itu sangat berdukacita. ");
INSERT INTO indayt_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Keesokan harinya, mereka bangun pagi-pagi hendak naik ke puncak gunung. Mereka berkata, “Inilah kami. Kami akan pergi ke tempat yang telah TUHAN janjikan, karena kami telah berdosa.” ");
INSERT INTO indayt_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Akan tetapi, Musa berkata, “Mengapa kamu mau melanggar perintah TUHAN? Kamu tidak akan berhasil! ");
INSERT INTO indayt_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Jangan pergi ke sana karena TUHAN tidak menyertaimu. Kamu akan dikalahkan oleh musuh-musuhmu. ");
INSERT INTO indayt_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Orang Amalek dan orang Kanaan akan melawanmu di sana. Kalian akan dibunuh dengan pedang karena kalian telah berbalik dari mengikuti TUHAN jadi TUHAN tidak akan menyertaimu.” ");
INSERT INTO indayt_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Akan tetapi, mereka tetap nekat pergi ke daerah pegunungan, sedangkan Tabut Perjanjian TUHAN dan Musa tidak beranjak dari perkemahan. ");
INSERT INTO indayt_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Orang Amalek dan orang Kanaan yang tinggal di daerah pegunungan itu turun, lalu menyerang orang Israel dan mengalahkannya sampai di Horma. ");
INSERT INTO indayt_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Katakanlah kepada orang Israel: Ketika kamu masuk ke negeri yang akan kamu tinggali, yang Aku berikan kepadamu, ");
INSERT INTO indayt_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kamu harus memberikan persembahan dengan api kepada TUHAN, baik kurban bakaran maupun kurban nazar, kurban sukarela, atau kurban pada perayaan yang sudah ditetapkan, sebagai persembahan yang harum kepada TUHAN, dari antara kawanan ternakmu. ");
INSERT INTO indayt_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Orang yang membawa persembahannya kepada TUHAN haruslah mempersembahkan persembahan sajian berupa sepersepuluh efa tepung halus yang dicampur dengan 1/4 hin minyak. ");
INSERT INTO indayt_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Bersama kurban bakaran atau kurban lainnya itu, kamu juga harus mempersembahkan 1/4 hin anggur sebagai persembahan curahan untuk setiap anak domba. ");
INSERT INTO indayt_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Untuk setiap domba jantan, kamu harus menyiapkan persembahan sajian berupa 2/10 efa tepung halus yang dicampur dengan 1/3 hin minyak. ");
INSERT INTO indayt_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Untuk persembahan curahannya, kamu harus membawa 1/3 hin anggur, aroma yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Apabila kamu mempersembahkan anak sapi sebagai kurban bakaran atau sebagai kurban nazar atau kurban pendamaian kepada TUHAN, ");
INSERT INTO indayt_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","maka bersama kurban itu kamu harus membawa persembahan sajian berupa 3/10 efa tepung halus yang dicampur dengan setengah hin minyak. ");
INSERT INTO indayt_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Untuk persembahan curahannya, kamu harus membawa setengah hin anggur, aroma yang menyenangkan bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Begitulah harus kamu lakukan pada setiap sapi jantan, domba jantan, anak domba jantan, ataupun kambing. ");
INSERT INTO indayt_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Berdasarkan jumlah yang kamu siapkan, itulah yang harus kamu lakukan untuk setiap kurban sesuai dengan banyaknya. ");
INSERT INTO indayt_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Setiap orang Israel harus melakukan semua itu dengan cara demikian untuk mempersembahkan kurban yang dibakar, sebagai bau yang harum bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Apabila ada orang asing yang singgah sementara bersamamu, atau yang telah menetap di antaramu, ingin memberikan kurban yang dibakar sebagai aroma yang menyenangkan bagi TUHAN, dia harus melakukannya seperti yang kamu lakukan. ");
INSERT INTO indayt_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Peraturan yang sama berlaku untuk seluruh umat, baik orang Israel maupun orang asing yang tinggal di antaramu. Peraturan ini berlaku selamanya. Seperti halnya kamu, demikianlah orang asing di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Satu hukum dan satu peraturan berlaku bagimu dan bagi orang asing yang tinggal di antaramu.” ");
INSERT INTO indayt_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Berbicaralah kepada orang Israel dan katakan kepada mereka: Ketika kamu memasuki negeri ke mana Aku membawamu, ");
INSERT INTO indayt_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","saat kamu makan hasil buminya, kamu harus memberikan persembahan kepada TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Dari adonan pertamamu, ambillah sepotong kue sebagai persembahan, sama seperti persembahan dari hasil pengirikanmu. Demikianlah kamu harus mempersembahkannya. ");
INSERT INTO indayt_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dari adonan pertamamu, kamu harus memberikan persembahan kepada TUHAN dari generasi ke generasi. ");
INSERT INTO indayt_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Apabila kamu dengan tidak sengaja melanggar, melalaikan perintah yang TUHAN sampaikan kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","semua yang telah TUHAN perintahkan kepadamu melalui Musa sejak hari ketika TUHAN memberikan perintah hingga kepada generasimu, ");
INSERT INTO indayt_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","dan jika kelalaian itu dilakukan dengan tidak sengaja tanpa sepengetahuan umat, seluruh umat harus mempersembahkan seekor sapi jantan sebagai kurban bakaran yang harum baunya bagi TUHAN, bersama dengan persembahan sajiannya dan persembahan curahannya sesuai ketentuan, serta seekor kambing untuk kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Imam harus mengadakan pendamaian untuk seluruh umat Israel sehingga mereka diampuni. Sebab, kesalahan itu tidak disengaja dan mereka telah membawa persembahan, yaitu persembahan yang dibakar dan kurban penghapus dosa di hadapan TUHAN atas kesalahan mereka. ");
INSERT INTO indayt_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Dengan begitu, seluruh umat Israel dan orang asing yang tinggal di tengah mereka akan diampuni karena kelalaian itu. ");
INSERT INTO indayt_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Apabila seseorang tidak sengaja berbuat dosa, orang itu harus mempersembahkan seekor kambing betina berumur setahun untuk kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Imam harus mengadakan pendamaian di hadapan TUHAN untuk orang yang melakukan dosa dengan tidak sengaja itu, supaya dia diampuni. ");
INSERT INTO indayt_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Satu hukum harus berlaku bagi setiap orang yang melakukan dosa yang tidak disengaja, baik orang Israel maupun orang asing yang tinggal di antara mereka. ");
INSERT INTO indayt_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Akan tetapi, jika seseorang melakukan dosa dengan sengaja, baik orang Israel maupun pendatang, dia menghujat TUHAN. Orang itu harus dilenyapkan dari antara bangsanya. ");
INSERT INTO indayt_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Sebab, dia telah menghina firman TUHAN dan melanggar perintah-Nya. Orang itu harus dibinasakan, kesalahannya akan ditanggungkan kepadanya.” ");
INSERT INTO indayt_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ketika orang Israel berada di padang gurun, mereka mendapati seseorang sedang mengumpulkan kayu pada hari Sabat. ");
INSERT INTO indayt_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Mereka yang melihat orang itu mengumpulkan kayu membawanya kepada Musa, Harun, dan seluruh jemaat. ");
INSERT INTO indayt_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Mereka menahan orang itu karena belum ada keputusan tentang apa yang harus dilakukan terhadapnya. ");
INSERT INTO indayt_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Lalu, TUHAN berkata kepada Musa, “Orang itu harus mati. Seluruh umat harus merajamnya dengan batu di luar perkemahan.” ");
INSERT INTO indayt_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Jadi, seluruh umat membawanya keluar perkemahan dan merajamnya hingga mati, seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO indayt_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Berbicaralah kepada umat Israel dan perintahkanlah mereka untuk membuat rumbai pada ujung-ujung pakaian mereka, dari generasi ke generasi. Rumbai itu harus diberi benang berwarna biru. ");
INSERT INTO indayt_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Saat kamu melihatnya, rumbai itu akan menjadi pengingat bagimu akan perintah-perintah TUHAN. Dengan demikian, kamu akan melakukan semua perintah itu dan tidak mengikuti kehendak hati dan matamu sendiri, yang membuatmu menjadi pelacur. ");
INSERT INTO indayt_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Dengan begitu, kamu akan selalu ingat untuk melakukan semua perintah-Ku dan menjadi kudus bagi Allahmu. ");
INSERT INTO indayt_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Akulah TUHAN, Allahmu, yang membawamu keluar dari negeri Mesir untuk menjadi Allahmu. Akulah TUHAN, Allahmu.” ");
INSERT INTO indayt_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Suatu ketika, Korah, anak Yizhar, anak Kehat, anak Lewi, serta Datan dan Abiram, anak-anak Eliab, dan On anak Pelet, mereka orang-orang Ruben, menghasut orang-orang. ");
INSERT INTO indayt_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Mereka bangkit berdiri di hadapan Musa bersama dengan sejumlah orang Israel, 250 orang pemimpin jemaat terpilih, orang-orang ternama. ");
INSERT INTO indayt_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Mereka berkumpul menentang Musa dan Harun dan berkata, “Kalian sudah keterlaluan! Seluruh umat, dan setiap orang di antara mereka adalah orang-orang kudus. TUHAN ada di tengah mereka. Mengapa kamu meninggikan diri di atas jemaat TUHAN ini?” ");
INSERT INTO indayt_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ketika Musa mendengarnya, dia sujud dengan muka sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Lalu, dia berkata kepada Korah dan semua pengikutnya, “Besok pagi TUHAN akan menunjukkan siapakah milik-Nya, dan siapakah yang kudus, dan akan membawa dia dekat kepada-Nya. ");
INSERT INTO indayt_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Jadi, besok lakukanlah ini hai Korah, kamu dan para pengikutmu harus mengambil pedupaan, ");
INSERT INTO indayt_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","nyalakan api di dalamnya dan taburkanlah kemenyan di atasnya di hadapan TUHAN besok. Yang dipilih TUHAN, dialah orang yang kudus. Hai anak-anak Lewi, cukuplah itu!” ");
INSERT INTO indayt_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa juga berkata kepada Korah, “Hai orang Lewi, dengarkanlah! ");
INSERT INTO indayt_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Allah Israel telah memisahkanmu dari seluruh umat untuk membawamu dekat kepada-Nya, untuk mengerjakan pelayanan Tenda Suci TUHAN, dan untuk berdiri di hadapan umat melayani mereka. Tidakkah itu cukup bagimu? ");
INSERT INTO indayt_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Dia telah membawamu dan saudara-saudaramu, orang Lewi dekat kepada-Nya. Sekarang kamu menuntut jabatan imam juga? ");
INSERT INTO indayt_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","sebab itu, kamu dan para pengikutmu telah berkumpul menentang TUHAN! Siapakah Harun sehingga kamu menggerutu terhadap dia?” ");
INSERT INTO indayt_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kemudian, Musa menyuruh seseorang untuk memanggil Datan dan Abiram, anak-anak Eliab. Namun, kedua orang itu menjawab, “Kami tidak akan datang! ");
INSERT INTO indayt_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Belum cukupkah kamu membawa kami keluar dari negeri yang berlimpah dengan susu dan madu untuk membuat kami mati di padang gurun, sehingga kamu mau menjadi tuan atas kami? ");
INSERT INTO indayt_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Sesungguhnya, kamu tidak membawa kami ke negeri yang berlimpah susu dan madu, ataupun memberi kami warisan ladang atau kebun anggur. Masihkah kamu hendak membutakan mata orang-orang ini? Kami tidak akan datang.” ");
INSERT INTO indayt_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa menjadi sangat marah dan berkata kepada TUHAN, “Janganlah mengindahkan persembahan mereka. Aku tidak pernah mengambil seekor keledai pun dari mereka. Aku tidak pernah merugikan satu pun dari mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa berkata kepada Korah, “Kamu dan semua pengikutmu harus datang ke hadapan TUHAN besok. Baik kalian maupun Harun. ");
INSERT INTO indayt_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Setiap orang dari kalian harus membawa pedupaan dan menaruh kemenyan di situ, 250 pedupaan. Kamu dan Harun juga, masing-masing harus membawa pedupaan.” ");
INSERT INTO indayt_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Jadi, setiap orang mengambil pedupaannya, menaruh api di situ dan menaburinya dengan kemenyan, lalu berdiri di pintu masuk tenda pertemuan bersama Musa dan Harun. ");
INSERT INTO indayt_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah mengumpulkan semua orang untuk menentang mereka di pintu tenda pertemuan. Lalu, kemuliaan TUHAN tampak kepada seluruh kumpulan itu. ");
INSERT INTO indayt_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","TUHAN berfirman kepada Musa dan Harun, ");
INSERT INTO indayt_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Pisahkanlah dirimu dari orang-orang ini, supaya Aku dapat membinasakan mereka dalam sekejap!” ");
INSERT INTO indayt_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Akan tetapi, Musa dan Harun tersungkur dengan muka mereka dan berkata, “Ya Allah, Allah dari roh segala makhluk, ketika satu orang berdosa, akankah Engkau murka terhadap seluruh umat?” ");
INSERT INTO indayt_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Katakanlah kepada umat itu untuk menjauh dari sekeliling tempat tinggal Korah, Datan, dan Abiram.” ");
INSERT INTO indayt_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Lalu, Musa bangun dan pergi menemui Datan dan Abiram, dan tua-tua Israel mengikutinya. ");
INSERT INTO indayt_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Dia berkata kepada umat itu, “Menjauhlah dari tenda orang-orang jahat ini. Jangan menyentuh apa pun milik mereka! Jika kamu melakukannya, kamu akan dibasmi bersama semua dosa mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Jadi, mereka pun menjauh dari perkemahan Korah, Datan, dan Abiram. Lalu, Datan dan Abiram keluar dan berdiri di pintu tenda mereka, bersama istri mereka, putra-putra mereka, dan anak-anak mereka yang masih kecil. ");
INSERT INTO indayt_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa berkata, “Dengan ini kamu akan mengetahui bahwa TUHAN-lah yang mengutusku untuk melakukan segala perbuatan ini, bukan atas kemauanku sendiri. ");
INSERT INTO indayt_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Jika mereka mati secara wajar seperti semua manusia, atau jika mereka mengalami akhir seperti semua manusia, berarti TUHAN tidak mengutus aku. ");
INSERT INTO indayt_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Akan tetapi, jika TUHAN melakukan sesuatu yang baru, tanah membuka mulutnya dan menelan mereka bersama segala milik mereka, dan mereka turun hidup-hidup ke Syeol, kamu akan mengetahui bahwa mereka telah menentang TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Setelah dia selesai mengucapkan semua perkataan itu, tanah di bawah mereka pun terbelah terbuka. ");
INSERT INTO indayt_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Bumi membuka mulutnya dan menelan mereka, seisi rumah mereka, dan semua orang yang menjadi bagian dari Korah beserta segala milik mereka. ");
INSERT INTO indayt_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mereka dan seluruh milik mereka turun hidup-hidup ke Syeol. Bumi menutup di atas mereka, dan mereka pun binasa dari antara umat itu. ");
INSERT INTO indayt_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Seluruh umat Israel yang ada di sekitar tempat itu berhamburan mendengar jeritan mereka. Mereka berkata, “Jangan-jangan bumi menelan kita juga!” ");
INSERT INTO indayt_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kemudian, keluarlah api dari TUHAN menghanguskan 250 orang yang mempersembahkan kemenyan. ");
INSERT INTO indayt_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Katakan kepada Eleazar, anak imam Harun, untuk mengambil semua pedupaan dari tengah kobaran api, karena pedupaan itu kudus. Dan kamu, hamburkanlah bara apinya jauh-jauh. ");
INSERT INTO indayt_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Semua pedupaan milik orang-orang yang telah berdosa dan membayarnya dengan nyawa mereka, harus ditempa menjadi lempengan untuk menyalut mazbah. Karena mereka sudah mempersembahkannya di hadirat TUHAN sehingga semuanya menjadi kudus. Dengan demikian, ini akan menjadi tanda bagi umat Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Imam Eleazar mengumpulkan semua pedupaan perunggu yang dibawa oleh mereka yang terbakar. Kemudian ditempa menjadi lempengan untuk menyalut mazbah, ");
INSERT INTO indayt_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","sebagai peringatan bagi keturunan Israel bahwa tidak ada orang awam yang bukan keturunan Harun yang boleh mendekat untuk membakar kemenyan di hadapan TUHAN, supaya jangan menjadi seperti Korah dan pengikutnya, seperti yang telah dikatakan TUHAN melalui Musa. ");
INSERT INTO indayt_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Namun, keesokan harinya seluruh umat Israel menggerutu terhadap Musa dan Harun dengan berkata, “Kamu telah membunuh umat TUHAN.” ");
INSERT INTO indayt_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Dan terjadilah, ketika umat itu berhimpun menentang Musa dan Harun, mereka berpaling ke arah tenda pertemuan, melihat awan menutupinya dan kemuliaan TUHAN tampak. ");
INSERT INTO indayt_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Kemudian, Musa dan Harun datang ke depan tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Menjauhlah dari antara umat ini supaya Aku membinasakan mereka dalam sekejap.” Lalu, mereka tersungkur dengan mukanya. ");
INSERT INTO indayt_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa berkata kepada Harun, “Ambillah pedupaan, taruhlah api dari mazbah ke dalamnya dan taburilah dengan kemenyan, dan bawalah segera kepada umat untuk mengadakan pendamaian bagi mereka, karena murka telah keluar dari TUHAN, tulah telah dimulai.” ");
INSERT INTO indayt_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Harun mengambil pedupaan seperti yang dikatakan Musa dan berlari ke tengah umat itu. Lihat, tulah sudah dimulai di antara mereka, maka dia membubuhkan kemenyan dan mengadakan pendamaian bagi umat itu. ");
INSERT INTO indayt_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Dia berdiri di antara yang hidup dan yang mati, dan tulah itu berhenti. ");
INSERT INTO indayt_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ada 14.700 orang yang mati karena tulah, belum termasuk orang yang mati dalam perkara Korah. ");
INSERT INTO indayt_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Setelah tulah berhenti, Harun pun kembali kepada Musa di pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Berbicaralah kepada bangsa Israel, dan ambillah dari mereka satu tongkat untuk setiap suku, dua belas tongkat, dari semua pemimpin menurut suku mereka. Tuliskan nama masing-masing pada setiap tongkatnya. ");
INSERT INTO indayt_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Pada tongkat Lewi, tuliskan nama Harun. Untuk setiap suku harus ada satu tongkat. ");
INSERT INTO indayt_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Taruhlah seluruh tongkat itu di dalam tenda pertemuan, di depan tabut kesaksian tempat Aku bertemu dengan kamu. ");
INSERT INTO indayt_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Tongkat milik orang yang Kupilih akan bertunas. Demikianlah Aku akan menenangkan umat Israel atas keluhan mereka terhadapmu.” ");
INSERT INTO indayt_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa pun berbicara kepada bangsa Israel. Setiap pemimpin memberikan sebuah tongkat. Satu tongkat dari masing-masing pemimpin suku, ada dua belas tongkat, dan tongkat Harun ada di antaranya. ");
INSERT INTO indayt_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa meletakkan tongkat-tongkat itu di hadapan TUHAN dalam tenda kesaksian. ");
INSERT INTO indayt_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Keesokan harinya, Musa memasuki tenda kesaksian itu, dan melihat tongkat Harun dari suku Lewi telah bertunas, mengeluarkan kuntum, mengembangkan bunga, dan menghasilkan buah badam. ");
INSERT INTO indayt_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa membawa semua tongkat itu keluar dari hadapan TUHAN kepada seluruh umat Israel. Mereka melihat dan mengambil tongkatnya masing-masing. ");
INSERT INTO indayt_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","TUHAN berkata kepada Musa, “Kembalikan tongkat Harun ke depan tabut kesaksian untuk disimpan sebagai tanda bagi para pemberontak, dengan demikian kamu menghentikan sungut-sungut mereka terhadap-Ku supaya mereka tidak binasa.” ");
INSERT INTO indayt_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa melakukan seperti yang diperintahkan TUHAN kepadanya. ");
INSERT INTO indayt_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Umat Israel berkata kepada Musa, “Lihat, kami akan mati! Kami akan binasa! Kami semua akan binasa! ");
INSERT INTO indayt_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Setiap orang yang mendekat, mendekat ke Tenda Suci TUHAN, akan mati. Apakah kami semua akan binasa?” ");
INSERT INTO indayt_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","TUHAN berfirman kepada Harun, “Kamu, anak-anakmu, dan seluruh sukumu akan menanggung segala kesalahan terhadap tempat kudus. Kamu dan anak-anakmu akan menanggung kesalahan berkenaan dengan keimamanmu. ");
INSERT INTO indayt_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Bawalah saudara-saudaramu suku Lewi, yakni suku bapamu, untuk bergabung denganmu dan melayanimu sementara kamu dan anak-anakmu berada di depan tenda kesaksian. ");
INSERT INTO indayt_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Mereka harus bertanggung jawab terhadap kamu dan kewajiban dalam tenda. Hanya saja, mereka tidak boleh mendekati perlengkapan tempat kudus dan mazbah, supaya kamu dan mereka jangan mati. ");
INSERT INTO indayt_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mereka akan bersama-sama denganmu melakukan pekerjaan dalam tenda pertemuan, untuk semua pelayanan di tenda itu. Akan tetapi, orang luar tidak boleh mendekat kepadamu. ");
INSERT INTO indayt_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Kamu harus bertanggung jawab terhadap kewajiban di tempat kudus dan kewajiban pada mazbah, supaya umat Israel tidak lagi menerima murka. ");
INSERT INTO indayt_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Lihat, Aku sendiri telah memilih saudara-saudaramu, orang Lewi, dari antara umat Israel. Mereka merupakan suatu pemberian kepadamu, dipersembahkan bagi TUHAN, untuk melakukan pelayanan di tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Akan tetapi, kamu dan anak-anakmu harus bertanggung jawab sebagai imam, yaitu mengurus segala sesuatu berkenaan dengan mazbah dan yang di belakang tirai, dan kamu harus melakukan pelayanan. Aku memberikan kepadamu pelayanan keimaman itu, tetapi orang luar yang mendekat harus dihukum mati.” ");
INSERT INTO indayt_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Lalu TUHAN berfirman kepada Harun, “Lihat, Aku sendiri memberikan tanggung jawab kepadamu atas semua pemberian khusus yang diberikan umat kepada-Ku. Semua pemberian kudus yang diberikan bangsa Israel kepada-Ku, Kuberikan kepadamu sebagai bagianmu dan anak-anakmu untuk selamanya. ");
INSERT INTO indayt_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Umat harus membawa pemberian kudus yang dibakar yaitu kurban sajian, dan kurban penghapus dosa, dan kurban penghapus salah. Persembahan-persembahan ini sangat suci dan menjadi bagianmu dan anak-anakmu. ");
INSERT INTO indayt_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Semua laki-laki dalam keluargamu boleh memakannya. Itu bagian kudusmu. ");
INSERT INTO indayt_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ini juga akan menjadi bagianmu yaitu persembahan pemberian dan persembahan unjukan umat Israel. Aku memberikannya kepadamu, baik anak-anakmu laki-laki atau perempuan. Setiap orang dalam keluargamu yang tahir dapat memakannya. ");
INSERT INTO indayt_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Aku akan memberikan kepadamu semua minyak, anggur baru, dan gandum yang terbaik yang dipersembahkan umat-Ku sebagai hasil sulungnya. ");
INSERT INTO indayt_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Hasil pertama dari segala yang tumbuh di tanahnya yang dipersembahkan kepada TUHAN akan menjadi bagianmu. Setiap orang yang tahir dari keluargamu boleh memakannya. ");
INSERT INTO indayt_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Semua yang dipersembahkan oleh umat Israel akan menjadi bagianmu. ");
INSERT INTO indayt_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Semua yang sulung, baik anak sulung manusia maupun binatang yang dipersembahkan kepada TUHAN akan menjadi bagianmu. Akan tetapi, kamu harus menebus anak sulung manusia, dan dari anak sulung binatang yang najis. ");
INSERT INTO indayt_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kamu harus menebusnya sesuai dengan nilai sejak berumur satu bulan. Menurut syikal kudus nilainya lima syikal yaitu dua puluh gera. ");
INSERT INTO indayt_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Akan tetapi, kamu jangan menebus anak sulung sapi, domba, atau kambing karena itu kudus. Percikkan darah binatang itu ke mazbah dan bakarlah lemaknya sebagai kurban bakaran yang harum baunya bagi TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Dari binatang yang dipersembahkan tadi, dagingnya akan menjadi bagianmu sama seperti persembahan unjukan dada dan paha kanan. ");
INSERT INTO indayt_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Aku, TUHAN, memberikan segala sesuatu yang dipersembahkan umat Israel sebagai persembahan kudus, menjadi milikmu. Itu akan menjadi bagianmu kepada anak-anakmu, baik laki-laki maupun perempuan. Perjanjian garam ini berlaku untuk selama-lamanya.” ");
INSERT INTO indayt_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","TUHAN berkata kepada Harun, “Kamu tidak akan mendapat bagian dari tanah pusaka di tengah mereka. Bagimu, Akulah bagianmu dan warisanmu. ");
INSERT INTO indayt_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Bangsa Israel akan memberikan sepersepuluh dari segala sesuatu yang dimilikinya kepada keturunan Lewi, sebagai pengganti dari pelayanan yang mereka lakukan di tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Namun, orang Israel yang lain tidak boleh mendekati tenda pertemuan sebab mereka akan berdosa dan mati! ");
INSERT INTO indayt_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Akan tetapi, orang Lewi akan melakukan pelayanan mengurus tenda pertemuan dan harus bertanggung jawab atas kesalahannya. Itulah peraturan yang berlaku selamanya dari generasi ke generasi. Mereka tidak akan mendapat tanah pusaka di tengah orang Israel. ");
INSERT INTO indayt_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Umat Israel harus mempersembahkan sepersepuluh kepada TUHAN. Aku memberikannya kepada orang Lewi sebagai milik pusaka. Karena itulah Aku berkata demikian tentang mereka: ‘Mereka tidak akan memperoleh pusaka di Israel.’” ");
INSERT INTO indayt_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Katakanlah kepada orang Lewi: Orang Israel harus memberikan sepersepuluh dari semua yang mereka miliki kepada TUHAN dan orang Lewi juga harus memberikan sepersepuluh darinya sebagai persembahan. ");
INSERT INTO indayt_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Persembahanmu itu akan dianggap seperti gandum dari lantai penggilingan dan hasil anggur dari pemerasan anggur. ");
INSERT INTO indayt_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Dan juga, dari persembahan unjukanmu kepada TUHAN, dari perpuluhan Israel itu harus kamu berikan kepada Imam Harun. ");
INSERT INTO indayt_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Dari segala persembahanmu, berikan persembahan unjukan TUHAN yang terbaik sebagai bagian kudus darinya. ");
INSERT INTO indayt_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Katakanlah kepada mereka, ‘Apabila kamu mempersembahkan yang terbaik dari yang kamu terima, bagi orang Lewi sama seperti gandum dari tempat pengirikan dan anggur dari tempat pemerasan. ");
INSERT INTO indayt_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","kamu dan keluargamu boleh memakannya. Itulah imbalan atas pelayananmu dalam tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kamu tidak akan bersalah apabila kamu mengambil bagian yang terbaik itu. Sedang kurban kudus dari bangsa Israel jangan dinajiskan supaya kamu tidak mati.’” ");
INSERT INTO indayt_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","TUHAN berfirman kepada Musa dan Harun. ");
INSERT INTO indayt_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Inilah hukum yang TUHAN berikan kepada umat Israel, ‘Ambillah seekor sapi merah yang tidak bercacat dan tidak pernah membawa beban. ");
INSERT INTO indayt_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Berikanlah sapi itu kepada Imam Eleazar, dia akan membawanya keluar dari perkemahan dan menyembelih sapi itu di depannya. ");
INSERT INTO indayt_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Imam Eleazar harus mengambil sedikit darahnya dengan jarinya dan memercikkannya ke arah tenda pertemuan itu sebanyak tujuh kali. ");
INSERT INTO indayt_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kemudian, sapi itu harus dibakar di depannya: kulit, daging, darah, dan isi perutnya harus dibakar. ");
INSERT INTO indayt_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Imam harus mengambil kayu aras, sebatang hisop, dan kain merah. Dia harus melemparkannya ke sapi yang dibakar itu. ");
INSERT INTO indayt_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kemudian, imam harus mandi dan mencuci pakaiannya. Sesudah itu, dia harus kembali ke perkemahan dan dia akan najis hingga sore hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Orang yang membakar sapi itu harus mandi dan mencuci pakaiannya. Dia akan najis hingga sore hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Orang yang tahir akan mengumpulkan abu sapi itu dan menaruhnya di tempat yang bersih, di luar perkemahan. Dengan demikian, abu itu digunakan umat Israel sebagai air penahiran. Itulah kurban penghapus dosa. ");
INSERT INTO indayt_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Orang yang mengumpulkan abu sapi itu harus mencuci pakaiannya dan dia akan najis hingga sore hari. Itulah peraturan untuk selamanya bagi umat Israel dan orang asing yang ada di tengah-tengahmu. ");
INSERT INTO indayt_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Siapa pun yang menyentuh mayat akan najis selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dia harus membersihkan diri dengan air itu pada hari ketiga dan pada hari ketujuh. Jika dia tidak melakukannya, dia akan tetap najis. ");
INSERT INTO indayt_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Siapa pun yang menyentuh mayat orang mati dan tidak menahirkan dirinya berarti dia menajiskan Tenda Suci TUHAN. Orang itu harus dilenyapkan dari umat Israel. Sebab, air penahiran itu tidak dipercikkan kepadanya sehingga dia menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Itulah peraturan bagi seseorang yang mati dalam tendanya. Setiap orang yang masuk dan ada dalam tenda itu akan najis selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Dan, setiap bejana yang tanpa tutup menjadi najis. ");
INSERT INTO indayt_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Siapa pun yang menyentuh mayat di ladang, orang yang terbunuh oleh pedang, atau tulang-belulangnya, atau kuburannya, dia menjadi najis selama tujuh hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Siapa pun yang najis, harus mengambil abu kurban bakaran penghapus dosa itu. Mereka harus menuangkan air segar ke atas abu yang ada dalam bejana. ");
INSERT INTO indayt_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Lalu, orang yang tahir harus mengambil sebatang hisop dan mencelupkannya ke dalam air tadi. Dia harus memercikkannya ke atas tenda dan setiap bejana, serta setiap orang yang ada dan terhadap orang yang menyentuh yang mati, yang terbunuh, tulang-belulangnya, bahkan kuburannya. ");
INSERT INTO indayt_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Orang yang tahir harus memercikkan air itu kepada orang yang najis pada hari ketiga dan pada hari ketujuh untuk menyucikannya. Pada hari ketujuh orang yang najis harus mencuci pakaiannya dan mandi. Dengan demikian, dia menjadi tahir pada sore harinya. ");
INSERT INTO indayt_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Akan tetapi, siapa pun yang najis dan tidak mau menahirkan diri, orang itu harus dilenyapkan dari tengah umat karena dia telah menajiskan tempat kudus TUHAN. Orang itu tetap najis karena tidak diperciki dengan air penahiran ");
INSERT INTO indayt_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Itulah peraturan untuk selama-lamanya. Siapa pun yang memercikkan air penahiran itu harus mencuci pakaiannya. Dan orang lain yang terkena air itu akan menjadi najis hingga sore hari. ");
INSERT INTO indayt_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Segala sesuatu yang disentuh orang yang najis akan menjadi najis termasuk orang yang menyentuhnya, najis sampai sore hari.’” ");
INSERT INTO indayt_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Segenap orang Israel sampai di padang gurun Sin pada bulan pertama. Mereka tinggal di Kadesh. Lalu, Miryam mati dan dia dikuburkan di sana. ");
INSERT INTO indayt_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Suatu ketika, tidak ada air bagi umat itu. Maka, mereka berkumpul menentang Musa dan Harun. ");
INSERT INTO indayt_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kemudian, umat itu berselisih dengan Musa dan berkata, “Andai saja kami mati ketika saudara-saudara kami itu mati di hadapan TUHAN. ");
INSERT INTO indayt_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mengapa kamu membawa umat TUHAN ke padang belantara ini untuk mati di sini, kami dan hewan ternak kami? ");
INSERT INTO indayt_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mengapa kamu membawa kami keluar dari negeri Mesir ke tempat celaka ini? Di tempat ini tidak ada biji-bijian, tidak ada pohon ara, pohon anggur, ataupun buah delima, bahkan tidak ada air untuk diminum.” ");
INSERT INTO indayt_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa dan Harun pun meninggalkan orang banyak itu dan pergi ke pintu tenda pertemuan. Mereka sujud sampai ke tanah, dan kemuliaan TUHAN tampak kepada mereka. ");
INSERT INTO indayt_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ambillah tongkatmu itu. Kumpulkanlah umat Israel bersama Harun, kakakmu. Berkatalah kepada bukit batu itu di depan mata mereka supaya bukit batu itu mengeluarkan airnya. Begitulah caramu mengeluarkan air dari bukit batu itu bagi mereka, dan memberi minum umat itu beserta ternak-ternaknya.” ");
INSERT INTO indayt_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Lalu, Musa mengambil tongkat itu dari hadapan TUHAN seperti yang Dia perintahkan kepadanya. ");
INSERT INTO indayt_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa dan Harun mengumpulkan umat di depan bukit batu itu. Kemudian, Musa berkata, “Dengarkanlah aku, hai pemberontak. Haruskah kami mengeluarkan air dari bukit batu ini?” ");
INSERT INTO indayt_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa mengangkat tangannya dan memukul bukit batu itu dua kali. Kemudian, air memancar keluar dari bukit batu itu. Seluruh umat dan ternak mereka meminum air itu. ");
INSERT INTO indayt_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Namun, TUHAN berfirman kepada Musa dan Harun, “Oleh karena kamu tidak mempercayai Aku, dan tidak menjaga kekudusan-Ku di mata orang Israel. Oleh sebab itu, kamu tidak akan memimpin umat itu memasuki negeri yang telah Kuberikan kepada mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Inilah air Meriba, karena umat Israel berselisih dengan TUHAN dan Dia dikuduskan di antara mereka. ");
INSERT INTO indayt_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Di Kadesh, Musa mengirim utusan kepada Raja Edom dengan pesan, “Saudara orang Israel berkata: Kamu tahu segala kesulitan yang telah kami alami. ");
INSERT INTO indayt_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nenek moyang kami pergi ke Mesir, dan kami tinggal lama di sana. Orang Mesir sangat kejam kepada kami dan nenek moyang kami. ");
INSERT INTO indayt_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Kami berseru kepada TUHAN, dan Dia mendengarkan kami dan mengirim malaikat membawa keluar dari Mesir. Sekarang kami ada di Kadesh, perbatasan negerimu. ");
INSERT INTO indayt_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Izinkanlah kami melewati negerimu. Kami tidak akan melintas melewati ladang atau kebun anggur. Kami tidak akan minum air sumurmu. Kami hanya berjalan pada jalan rayamu. Kami tidak menyimpang ke kanan atau ke kiri. Sampai kami melewati perbatasanmu.” ");
INSERT INTO indayt_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom menjawab, “Kamu tidak boleh melewati wilayah kami atau kami akan memerangimu dengan pedang.” ");
INSERT INTO indayt_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Jawab umat Israel, “Kami akan berjalan di jalan raya. Jika ternak kami meminum airmu, kami akan membayarnya. Kami hanya lewat dengan berjalan kaki.” ");
INSERT INTO indayt_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edom berkata lagi, “Kamu tidak boleh lewat.” Kemudian, Edom keluar mendatangi mereka dengan banyak orang bersenjata. ");
INSERT INTO indayt_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edom tidak mengizinkan orang Israel melewati negerinya, lalu orang Israel membelok darinya. ");
INSERT INTO indayt_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Semua orang Israel meninggalkan Kadesh dan sampai di Gunung Hor. ");
INSERT INTO indayt_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","TUHAN berkata kepada Musa dan Harun di Gunung Hor, dekat perbatasan Edom. ");
INSERT INTO indayt_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Harun akan dikumpulkan bersama dengan nenek moyangnya. Harun tidak akan memasuki negeri yang telah Kujanjikan kepada orang Israel, karena kalian berdua tidak mematuhi perintah-Ku di Air Meriba. ");
INSERT INTO indayt_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Bawalah Harun dan Eleazar, anaknya, ke Gunung Hor. ");
INSERT INTO indayt_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Tanggalkanlah pakaian Harun dan kenakanlah pada anaknya, Eleazar. Harun akan mati di sana.” ");
INSERT INTO indayt_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa melakukan apa yang diperintahkan TUHAN. Ketiganya naik ke atas Gunung Hor dengan dilihat seluruh orang Israel. ");
INSERT INTO indayt_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa menanggalkan pakaian Harun dan mengenakannya kepada anaknya, Eleazar. Harun mati di puncak gunung itu. Lalu, Musa dan Eleazar turun. ");
INSERT INTO indayt_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Semua orang Israel mengetahui bahwa Harun sudah mati. Seluruh orang Israel berkabung selama 30 hari. ");
INSERT INTO indayt_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Raja Arad, orang Kanaan, yang tinggal di selatan, mendengar bahwa umat Israel datang melalui jalan Atarim, maka raja itu datang menyerang orang Israel dan menangkap beberapa orang dari mereka untuk dijadikan tawanan. ");
INSERT INTO indayt_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Umat Israel bernazar kepada TUHAN: “Jika Engkau menyerahkan bangsa ini kepada kami, kami akan menghancurkan seluruh kota mereka.” ");
INSERT INTO indayt_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","TUHAN mendengar umat Israel dan membuat mereka mengalahkan orang Kanaan. Mereka benar-benar membinasakannya beserta kota-kota mereka. Kemudian, tempat itu dinamakan Horma. ");
INSERT INTO indayt_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Bangsa Israel meninggalkan Gunung Hor dan berjalan menuju Laut Teberau untuk mengelilingi negeri Edom. Namun, umat itu tidak sabar selama dalam perjalanan. ");
INSERT INTO indayt_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Mereka mengeluh terhadap Allah dan Musa dengan berkata, “Mengapa kamu membawa kami keluar dari Mesir, supaya kami mati di padang gurun? Tidak ada roti dan air! Kami muak dengan makanan yang tidak enak ini!” ");
INSERT INTO indayt_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Kemudian, TUHAN mengirimkan ular-ular tedung ke tengah umat itu untuk menggigit mereka, dan banyak orang Israel yang mati. ");
INSERT INTO indayt_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Mereka datang kepada Musa dan berkata, “Kami tahu bahwa kami telah berdosa karena kami mengeluh terhadap TUHAN dan engkau. Berdoalah kepada TUHAN, minta kepada-Nya agar Dia menjauhkan ular-ular ini.” Musa pun berdoa untuk mereka. ");
INSERT INTO indayt_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","TUHAN berfirman kepada Musa, “Buatlah seekor ular tedung dan letakkan di atas sebuah tiang. Jika ada orang digigit ular, orang itu harus memandang ular itu. Maka orang itu tidak akan mati.” ");
INSERT INTO indayt_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Lalu, Musa membuat seekor ular dari tembaga dan menempatkannya di atas tiang. Apabila ada orang yang digigit ular, orang itu harus memandang ular tembaga itu. Maka, orang itu akan tetap hidup. ");
INSERT INTO indayt_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Bangsa Israel meninggalkan tempat itu dan berkemah di Obot. ");
INSERT INTO indayt_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kemudian, mereka meninggalkan Obot dan berkemah di Abarim, di padang gurun sebelah timur Moab. ");
INSERT INTO indayt_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Dari sana, mereka melanjutkan perjalanan dan berkemah di lembah Zered. ");
INSERT INTO indayt_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Mereka kembali berjalan dan berkemah di seberang Sungai Arnon, di padang gurun yang merupakan batas antara Moab dan Amori, itulah perbatasan Amori. ");
INSERT INTO indayt_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Itulah sebabnya kata-kata ini ditulis dalam Kitab Peperangan TUHAN, “Waheb di Sufa, dan lembah-lembah di Arnon, ");
INSERT INTO indayt_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","dan bukit-bukit dekat lembah-lembah yang terbentang hingga Kota Ar, tempat perbatasan Moab.” ");
INSERT INTO indayt_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Mereka berjalan ke Beer. Di sini terdapat sumur, tempat TUHAN berkata kepada Musa, “Kumpulkanlah umat itu, dan Aku akan memberi mereka air.” ");
INSERT INTO indayt_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Lalu, umat Israel menyanyikan nyanyian ini: “Hai sumur, meluaplah dengan air! Nyanyikanlah itu! ");
INSERT INTO indayt_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ini adalah sumur yang digali bangsawan itu. memakai tongkat kerajaan, tongkatnya.” Dari padang gurun, mereka menuju ke Kota Matana. ");
INSERT INTO indayt_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Dari Matana ke Nahaliel. Dari Nahaliel ke Bamot. ");
INSERT INTO indayt_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Dari Bamot mereka berjalan ke Lembah Moab, di mana puncak Gunung Pisga menghadap ke padang gurun. ");
INSERT INTO indayt_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Bangsa Israel mengutus utusan kepada Sihon, raja Amori. Katanya, ");
INSERT INTO indayt_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Izinkanlah kami melewati negerimu. Kami tidak akan berbelok memasuki ladang atau kebun anggur. Kami tidak akan minum air dari sumur mana pun. Kami hanya akan berjalan di jalan raya sampai kami melewati perbatasanmu.” ");
INSERT INTO indayt_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Namun, Raja Sihon tidak mengizinkan orang Israel melewati negerinya. Dia mengumpulkan tentaranya dan keluar ke padang belantara untuk melawan orang Israel. Sesampainya di Yahas, mereka berperang melawan orang Israel. ");
INSERT INTO indayt_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Orang Israel mengalahkan raja itu dengan pedang dan merebut negerinya, mulai dari Sungai Arnon, Sungai Yabok, sampai perbatasan orang Amon, sebab perbatasan orang Amon itu kuat. ");
INSERT INTO indayt_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel merebut semua kota orang Amori dan tinggal di kota-kota itu, di Hesybon dan di semua desanya. ");
INSERT INTO indayt_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesybon adalah kota Sihon, raja Amori. Dia pernah berperang melawan Moab dan merebut tanah sepanjang Sungai Arnon. ");
INSERT INTO indayt_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Sebab itu, para penyair mengatakan: Datanglah dan bangunlah kembali Hesybon! Teguhkan kota Sihon. ");
INSERT INTO indayt_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Api keluar dari Hesybon, nyalanya dari kota Sihon. Api itu membinasakan Ar-Moab, berkuasa atas bukit-bukit sepanjang Sungai Arnon. ");
INSERT INTO indayt_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Celakalah kamu, Moab. Binasalah kamu, bangsa Kamos. Anak-anaknya laki-laki menjadi pelarian. Anak-anaknya perempuan menjadi tawanan Sihon, raja Amori. ");
INSERT INTO indayt_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Namun, kami mengalahkan mereka, dari Hesybon hingga Dibon, dan dari Nofah, di Medeba. ");
INSERT INTO indayt_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Bangsa Israel pun tinggal di tanah orang Amori. ");
INSERT INTO indayt_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa mengutus beberapa orang untuk menyelidiki Kota Yaezer. Kemudian, orang Israel merebut kota itu dan mengusir orang Amori yang tinggal di tempat itu. ");
INSERT INTO indayt_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Mereka berbalik dan berjalan menuju Basan. Og, raja Basan, beserta semua rakyatnya keluar menghadapi mereka untuk berperang di Edrei. ");
INSERT INTO indayt_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Namun, TUHAN berfirman kepada Musa, “Jangan takut kepadanya. Aku akan menyerahkan dia beserta seluruh rakyat dan negerinya kepadamu. Lakukanlah hal yang sama kepadanya, seperti yang telah kamu lakukan terhadap Sihon, raja Amori yang tinggal di Hesybon.” ");
INSERT INTO indayt_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Mereka pun mengalahkan Og, anak-anaknya, dan seluruh pasukannya sampai tidak bersisa. Setelah itu, mereka menduduki negerinya. ");
INSERT INTO indayt_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Umat Israel berangkat dan berkemah di dataran Moab, seberang Sungai Yordan, dekat Yerikho. ");
INSERT INTO indayt_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, anak Zipor, telah melihat segala yang dilakukan umat Israel terhadap Amori. ");
INSERT INTO indayt_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Seluruh Moab sangat takut terhadap orang Israel karena jumlahnya banyak. Mereka menjadi ciut hati terhadap umat Israel. ");
INSERT INTO indayt_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Orang-orang Moab berkata kepada tua-tua Midian, “Kumpulan orang itu akan membabat habis segala sesuatu di sekitar kita, seperti sapi memakan semua rumput di ladang.” Raja Moab saat itu adalah Balak, anak Zipor. ");
INSERT INTO indayt_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Dia mengirim utusan kepada Bileam, anak Beor. Bileam ada di Petor dekat Sungai Efrat. Dia berkata: “Suatu bangsa telah keluar dari Mesir. Mereka menduduki seluruh negeri dan berkemah di dekatku. ");
INSERT INTO indayt_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Datang dan tolonglah aku. Orang-orang ini terlalu kuat untukku maka kutuklah mereka bagiku supaya aku mampu mengalahkan dan mengusir mereka dari negeriku. Sebab jika kamu memberkati, maka akan diberkati. Jika kamu mengutuk, maka akan kena kutuk.” ");
INSERT INTO indayt_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Tua-tua Moab dan Midian pergi dengan membawa uang di tangannya dan menyampaikan semua yang telah dikatakan Balak. ");
INSERT INTO indayt_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bileam berkata kepada mereka, “Bermalamlah di sini. Aku akan berbicara kepada TUHAN dan memberitahumu jawaban-Nya kepadaku.” Para pemimpin Moab tinggal di sana bersama Bileam. ");
INSERT INTO indayt_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Kemudian, Allah datang kepada Bileam dan berfirman, “Siapa orang-orang yang bersamamu?” ");
INSERT INTO indayt_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Jawab Bileam kepada Allah, “Balak, anak Zipor, raja Moab, mengutus mereka kepadaku, ");
INSERT INTO indayt_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Suatu bangsa telah keluar dari Mesir dan menduduki seluruh negeri. Jadi datanglah dan kutuklah mereka ini supaya aku mampu menyerang dan mengusir mereka.’” ");
INSERT INTO indayt_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Namun, Allah berfirman kepada Bileam, “Jangan pergi bersama mereka. Jangan mengutuk bangsa itu sebab mereka diberkati.” ");
INSERT INTO indayt_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Keesokan paginya, Bileam bangun dan berkata kepada tua-tua Balak, “Pergilah kembali ke negerimu. TUHAN tidak ingin aku pergi bersamamu.” ");
INSERT INTO indayt_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Para pemimpin Moab itu kembali kepada Balak dan berkata, “Bileam menolak untuk datang bersama kami.” ");
INSERT INTO indayt_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Kemudian, Balak mengirim pemimpin lainnya kepada Bileam. Kali ini, dia mengutus lebih banyak daripada yang pertama. Para pemimpin ini jauh lebih terhormat dari yang pertama diutus. ");
INSERT INTO indayt_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Mereka pergi kepada Bileam dan berkata, “Inilah yang dikatakan Balak, anak Zipor, kepadamu: ‘Janganlah ada sesuatu yang menghalangimu untuk datang kepadaku. ");
INSERT INTO indayt_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Aku akan membayar upah yang besar kepadamu, dan aku akan melakukan apa pun yang kamu minta. Datanglah dan kutuklah bangsa ini demi aku.’” ");
INSERT INTO indayt_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam menjawab pembantu Balak. Katanya, “Aku tidak akan melanggar perintah TUHAN, Allahku. Baik itu perintah-Nya besar atau kecil. Bahkan, jika Balak menawarkan kepadaku istananya yang penuh dengan emas dan perak, aku tidak akan melakukan apa pun melawan perintah-Nya. ");
INSERT INTO indayt_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Namun, kamu dapat bermalam di sini seperti yang dilakukan oleh rombongan sebelumnya, dan malam ini aku akan tahu apa yang TUHAN katakan kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Malam itu, Allah datang kepada Bileam dan berkata, “Orang-orang ini telah memintamu untuk pergi bersama mereka. Pergilah bersama mereka, tetapi lakukanlah seperti yang Kukatakan kepadamu.” ");
INSERT INTO indayt_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Keesokan paginya, Bileam bangun, memasang pelana pada keledainya, dan berangkat bersama para pemimpin Moab. ");
INSERT INTO indayt_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Allah menjadi murka ketika Bileam pergi. Ketika Bileam sedang menunggang keledainya bersama dengan dua orang hambanya, malaikat TUHAN berdiri di jalan, di depannya. ");
INSERT INTO indayt_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Keledai Bileam melihat malaikat TUHAN berdiri di jalan dengan pedang terhunus. Lalu, keledai itu berbelok dari jalan dan masuk ke ladang. Ia memukul keledai itu untuk memaksanya kembali ke jalan. ");
INSERT INTO indayt_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Malaikat TUHAN berdiri di jalan yang sempit di antara kebun anggur dengan pagar tembok di kedua sisinya. ");
INSERT INTO indayt_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Keledai itu kembali melihat malaikat TUHAN sehingga keledai itu merapatkan tubuhnya pada tembok. Ia memukul kembali keledai itu karena kaki Bileam terimpit tembok. ");
INSERT INTO indayt_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Sesudah itu, malaikat TUHAN berdiri di tempat lain. Malaikat itu berdiri di jalan yang sempit sehingga tidak ada jalan bagi keledai itu untuk melewatinya. Keledai itu juga tidak bisa berbelok ke kiri maupun ke kanan. ");
INSERT INTO indayt_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Keledai itu melihat malaikat TUHAN dan merebahkan tubuhnya. Saat itu, Bileam masih duduk di atasnya. Bileam menjadi marah dan memukul keledai itu dengan tongkatnya. ");
INSERT INTO indayt_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Kemudian, TUHAN membuka mulut keledai itu dan keledai itu berkata kepada Bileam, “Mengapa kamu marah kepadaku? Apa yang telah kuperbuat kepadamu sehingga kamu telah memukul aku tiga kali!” ");
INSERT INTO indayt_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bileam menjawab kepada keledai itu, “Kamu mempermainkan aku. Jika aku memegang pedang, aku akan membunuhmu sekarang!” ");
INSERT INTO indayt_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Keledai itu berkata kepada Bileam, “Lihatlah, aku keledaimu. Kamu telah menunggangiku selama bertahun-tahun. Kamu tahu bahwa aku tidak pernah melakukan hal seperti ini sebelumnya!” “Itu benar,” kata Bileam. ");
INSERT INTO indayt_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kemudian, TUHAN membuka mata Bileam dan dia melihat malaikat TUHAN berdiri di jalan dengan pedang di tangannya. Maka, Bileam bersujud sampai ke tanah. ");
INSERT INTO indayt_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malaikat TUHAN bertanya kepada Bileam, “Mengapa kamu memukul keledaimu tiga kali? Akulah yang telah menentangmu. Karena jalanmu bertentangan denganku. ");
INSERT INTO indayt_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Keledaimu melihatku dan menghindariku sampai tiga kali. Jika keledai itu tidak menghindar, aku sudah membunuhmu tetapi keledaimu akan kuselamatkan.” ");
INSERT INTO indayt_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bileam berkata kepada malaikat TUHAN, “Aku telah berdosa. Aku tidak tahu bahwa engkau berdiri di jalan. Jika aku melakukan yang salah, aku akan pulang kembali.” ");
INSERT INTO indayt_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malaikat TUHAN berkata kepada Bileam, “Tidak, pergilah bersama orang-orang itu. Namun, kamu harus berkata seperti yang Kusuruh untuk kamu katakan.” Lalu, Bileam pergi bersama para pemimpin yang diutus Balak itu. ");
INSERT INTO indayt_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ketika Balak mendengar bahwa Bileam datang. Balak pun keluar untuk menemuinya di Kota Moab, perbatasan Sungai Arnon, tepatnya di ujung perbatasan itu. ");
INSERT INTO indayt_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak berkata kepada Bileam, “Aku sebelumnya telah memintamu untuk datang. Mengapa kamu tidak datang kepadaku? Apakah kamu kira aku tidak sanggup membayarmu?” ");
INSERT INTO indayt_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Jawab Bileam kepada Balak, “Aku sekarang telah datang, tetapi aku tidak dapat mengatakan apa pun seperti yang kauminta. Aku hanya mengatakan apa yang sudah Allah katakan kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Kemudian, Bileam pergi bersama Balak ke Kiryat-Huzot. ");
INSERT INTO indayt_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak menyembelih beberapa sapi dan domba sebagai kurban. Dia memberikan sebagian daging kepada Bileam dan beberapa kepada para pemimpin yang ada bersamanya. ");
INSERT INTO indayt_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Besok paginya Balak membawa Bileam ke Bukit Baal. Dari sana, dia dapat melihat sebagian perkemahan orang Israel. ");
INSERT INTO indayt_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bileam berkata kepada Balak, “Dirikanlah 7 mazbah bagiku di sini. Persiapkanlah juga 7 sapi jantan dan 7 domba jantan bagiku.” ");
INSERT INTO indayt_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak melakukan yang diminta Bileam. Kemudian, Balak dan Bileam menyembelih seekor sapi jantan dan seekor domba jantan di atas setiap mazbah. ");
INSERT INTO indayt_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Bileam berkata kepada Balak, “Berdirilah di samping kurban bakaranmu. Aku akan pergi. Kiranya TUHAN akan datang kepadaku, dan apa pun yang Dia katakan kepadaku akan kukatakan kepadamu.” Lalu, dia pergi ke suatu bukit. ");
INSERT INTO indayt_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Allah menemui Bileam di tempat itu, dan Bileam berkata kepada-Nya, “Aku telah mendirikan 7 mazbah dan sudah mengurbankan seekor sapi jantan dan seekor domba jantan pada setiap mazbah.” ");
INSERT INTO indayt_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","TUHAN menaruh firman pada mulut Bileam, dan berkata, “Kembalilah kepada Balak dan sampaikanlah demikian.” ");
INSERT INTO indayt_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Dia pun kembali kepada Balak. Balak masih berdiri di samping kurban bakarannya bersama dengan semua pemimpin Moab. ");
INSERT INTO indayt_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Kemudian, Bileam menyampaikan sajaknya: “Balak, raja Moab, telah menyuruh aku datang dari pegunungan timur Aram. katanya, ‘Datanglah, kutuklah Yakub bagiku. Datanglah, kutuklah Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Bagaimana aku mengutuk yang tidak dikutuk Allah? Bagaimana aku memurkai yang tidak dimurkai TUHAN? ");
INSERT INTO indayt_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Aku melihat umat ini dari atas gunung batu. Aku memandangnya dari bukit. Bangsa yang tinggal sendirian dan bukan bagian dari bangsa-bangsa lain. ");
INSERT INTO indayt_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Siapa yang dapat menghitung debu Yakub? dan siapakah yang dapat menghitung 1/4 Israel? Kiranya jiwaku mati sebagai orang jujur dan ajalku seperti mereka.’” ");
INSERT INTO indayt_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak berkata kepada Bileam, “Apakah yang kamu lakukan terhadapku? Aku membawamu ke sini untuk mengutuk musuh-musuhku, tetapi kamu malah memberkati mereka!” ");
INSERT INTO indayt_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Jawab Bileam, “Aku harus mengatakan yang telah TUHAN sampaikan kepadaku.” ");
INSERT INTO indayt_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Kemudian, Balak berkata kepadanya, “Marilah bersamaku ke tempat lain. Di tempat itu kamu juga dapat melihatnya namun hanya bagian paling ujung dan tidak seluruhnya. Kutuklah mereka bagiku dari sana.” ");
INSERT INTO indayt_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Balak pun membawanya ke Padang Pengintai di puncak Gunung Pisga. Di situ, Balak membangun tujuh mazbah dan mempersembahkan seekor sapi jantan dan satu domba jantan pada setiap mazbah itu. ");
INSERT INTO indayt_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bileam berkata kepada Balak, “Berdirilah di dekat kurban bakaranmu dan aku akan menemui TUHAN di sana.” ");
INSERT INTO indayt_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","TUHAN menemui Bileam dan menyampaikan pesan kepadanya, “Kembalilah kepada Balak dan berkatalah demikian”. ");
INSERT INTO indayt_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Bileam kembali kepada Balak, dia masih berdiri dekat kurban bakarannya bersama para pemimpin Moab. Kemudian, Balak berkata kepadanya, “Apa yang telah difirmankan TUHAN?” ");
INSERT INTO indayt_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kemudian, Bileam bersajak: “Bangkitlah, hai Balak, dan dengarkanlah. Berilah telinga padaku, hai anak Zipor. ");
INSERT INTO indayt_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Allah bukanlah manusia, Dia tidak akan berbohong. Allah bukan anak manusia; Dia tidak akan menyesal. Jika Dia berfirman, Dia melakukannya. Jika Dia berbicara, Dia menepatinya. ");
INSERT INTO indayt_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Aku disuruh memberkati mereka. Dia juga memberkati, aku tidak dapat mengubahnya. ");
INSERT INTO indayt_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Dia tidak melihat yang salah pada Yakub. dan kejahatan bangsa Israel. TUHAN, Allah mereka, bersama mereka. sorak-sorai raja di tengah mereka! ");
INSERT INTO indayt_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Allah yang membawa mereka keluar dari Mesir, bagaikan tanduk banteng kuat baginya. ");
INSERT INTO indayt_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tidak ada mantra dapat mengalahkan Yakub, ataupun tenungan terhadap Israel. Orang akan berkata tentang Yakub dan Israel: ‘Apa yang telah Allah lakukan!’ ");
INSERT INTO indayt_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Bangsa itu bangkit seperti singa betina, dan berdiri tegak bagai singa jantan. Dan ia tidak berbaring sampai ia makan mangsanya, dan minum darah kurbannya.” ");
INSERT INTO indayt_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak berkata kepada Bileam, “Jikalau kamu tidak mengutuki mereka, janganlah kamu memberkatinya!” ");
INSERT INTO indayt_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Jawab Bileam kepadanya, “Aku telah mengatakan kepadamu bahwa aku hanya mengatakan semua yang TUHAN firmankan, itu yang kulakukan.” ");
INSERT INTO indayt_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kemudian, Balak berkata kepada Bileam, “Marilah bersamaku ke tempat yang lain. Mungkin Allah berkenan di mata-Nya dan mengizinkanmu mengutuk bagiku dari tempat itu.” ");
INSERT INTO indayt_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak pun membawa Bileam ke puncak Gunung Peor, yang menghadap ke padang gurun. ");
INSERT INTO indayt_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bileam berkata kepada Balak, “Dirikanlah 7 mazbah di sini. Lalu siapkanlah 7 sapi jantan dan 7 domba jantan.” ");
INSERT INTO indayt_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak melakukan yang diminta oleh Bileam. Balak mempersembahkan sapi jantan dan domba jantan pada setiap mazbah. ");
INSERT INTO indayt_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bileam telah melihat bahwa TUHAN akan memberkati Israel sehingga dia tidak berusaha untuk mencari tanda lagi, dan memandang ke arah padang gurun. ");
INSERT INTO indayt_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ketika Bileam memandang dan melihat orang Israel berkemah menurut sukunya masing-masing, Roh Allah mendatangi dia. ");
INSERT INTO indayt_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Lalu, dia bersajak dan berkata: “Pesan ini dari Bileam, anak Beor. perkataan orang yang dibuka matanya. ");
INSERT INTO indayt_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Kata-kata dari mendengarkan firman Allah, penglihatan dari Yang Mahakuasa, dengan rebah mataku tersingkap. ");
INSERT INTO indayt_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hai Yakub, tenda-tendamu indah! Hai Israel, tempat kediamanmu indah! ");
INSERT INTO indayt_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Terbentang bagai sungai, serupa taman di tepi sungai, bagaikan pohon gaharu, ditanam oleh TUHAN, bagaikan pohon aras, di tepi air. ");
INSERT INTO indayt_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Dari timbanya mengalirlah air, melimpahlah air untuk benihmu. Rajamu akan lebih tinggi dari Agag, kerajaanmu akan dimuliakan. ");
INSERT INTO indayt_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Allah yang membawa mereka keluar dari Mesir, Dia seperti tanduk banteng. Dia memangsa bangsa-bangsa, lawan-Nya, Dia akan meremukkan tulang-tulang mereka dan akan memanah mereka. ");
INSERT INTO indayt_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Dia seperti singa jantan dan betina yang merunduk dan membaringkan diri, siapa yang berani membangunkannya! Setiap orang yang memberkatimu akan diberkati. Dan siapa yang mengutukmu akan dikutuk.” ");
INSERT INTO indayt_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak marah kepada Bileam sambil meremas-remas jarinya, lalu berkata kepada Bileam, “Aku memanggilmu untuk mengutuk musuh-musuhku, tetapi kamu malah memberkati mereka sampai tiga kali. ");
INSERT INTO indayt_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Sekarang, pulanglah! Aku telah mengatakan bahwa aku akan mengupahmu sangat banyak, tetapi TUHAN membuatmu kehilangan upah.” ");
INSERT INTO indayt_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bileam berkata kepada Balak, “Ingatlah pada pesan yang kukatakan kepada utusan-utusanmu, kataku, ");
INSERT INTO indayt_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Sekalipun Balak memberikan kepadaku rumahnya yang penuh perak dan emas, aku tidak dapat melanggar perintah TUHAN untuk berbuat baik atau buruk dari hatiku sendiri. Aku hanya mengatakan yang diperintahkan TUHAN.’ ");
INSERT INTO indayt_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sekarang, aku pulang kepada bangsaku. Namun, aku akan mengatakan kepadamu perihal yang akan dilakukan oleh bangsa itu terhadap bangsamu nanti.” ");
INSERT INTO indayt_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Kemudian, Bileam menyampaikan sajaknya, dan berkata: “Inilah pesan Bileam, anak Beor. Orang yang dibukakan matanya, ");
INSERT INTO indayt_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","yang mendengar dari firman Allah, yang tahu hikmat Yang Mahatinggi. Aku telah melihat penglihatan dari Yang Mahakuasa, dengan rebah mataku tersingkap. ");
INSERT INTO indayt_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Aku melihatnya datang, tetapi bukan sekarang. Aku memandangnya, tetapi tidak dari dekat. Sebuah bintang akan datang dari Yakub. Tongkat kerajaan akan bangkit dari orang Israel. Dia akan meremukkan pelipis Moab dan menghancurkan semua anak Set. ");
INSERT INTO indayt_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Israel akan berbuat hal besar! Edom jadi kepunyaannya. Seir akan dia duduki, musuhnya itu. ");
INSERT INTO indayt_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Pemimpin akan datang dari Yakub, yang akan membinasakan orang yang lari dari kota.” ");
INSERT INTO indayt_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Dia melihat orang Amalek dan berkata: “Amalek adalah yang pertama dari semua bangsa, tetapi Amalek pun akan binasa!” ");
INSERT INTO indayt_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Bileam melihat orang Keni dan berkata: “Negerimu kukuh, sarangmu ada di atas bukit batu. ");
INSERT INTO indayt_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Namun Keni akan binasa, Asyur akan segera menawanmu.” ");
INSERT INTO indayt_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kemudian, Bileam berkata: “Celaka! Siapa yang hidup apabila Allah melakukan hal ini? ");
INSERT INTO indayt_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kapal-kapal akan datang dari pantai Kitim. Mereka akan mengalahkan Asyur dan Heber, tetapi dia pun akan binasa.” ");
INSERT INTO indayt_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kemudian Bileam bangkit dan pulang, Balak juga pergi. ");
INSERT INTO indayt_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Bangsa Israel tinggal di Sitim, bangsa itu mulai melakukan pelacuran dengan perempuan Moab. ");
INSERT INTO indayt_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Perempuan-perempuan ini mengundang bangsa itu untuk mempersembahkan kurban kepada ilahnya. Umat itu turut makan dan sujud menyembah kepada ilah mereka. ");
INSERT INTO indayt_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ketika Israel bergabung dengan Baal-Peor, TUHAN murka kepada Israel. ");
INSERT INTO indayt_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","TUHAN berfirman kepada Musa, “Tangkap semua pemimpin orang-orang itu dan gantunglah mereka pada siang hari, di hadapan TUHAN. Dengan demikian, murka TUHAN surut dari Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa berkata kepada para hakim Israel, “Bunuhlah orang-orang yang bergabung dengan Baal-Peor.” ");
INSERT INTO indayt_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Seorang Israel datang membawa seorang perempuan Midian kepada sanak saudaranya, dengan dilihat Musa dan para pemimpin Israel, yang sedang menangis di depan pintu tenda pertemuan. ");
INSERT INTO indayt_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ketika Pinehas, anak Eleazar, cucu Imam Harun, melihat mereka, berdirilah dia meninggalkan pertemuan itu dan mengambil tombak di tangannya. ");
INSERT INTO indayt_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Dia mengikuti orang Israel itu ke dalam tendanya. Kemudian, dia menikam keduanya tepat di perutnya, baik orang Israel maupun perempuan itu. Maka, berhentilah tulah atas bangsa Israel. ");
INSERT INTO indayt_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Jumlah orang yang mati karena tulah itu 24 ribu orang. ");
INSERT INTO indayt_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pinehas, anak Eleazar, cucu Imam Harun, telah menyurutkan murka-Ku terhadap orang Israel. Dia melakukan ini karena dia giat membela kehormatan-Ku di tengah mereka, sehingga Aku tidak jadi membinasakan bangsa Israel dalam kecemburuan-Ku. ");
INSERT INTO indayt_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Katakanlah kepada Pinehas bahwa Aku membuat perjanjian perdamaian dengannya. ");
INSERT INTO indayt_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Inilah perjanjian itu: bagi dia dan keturunannya ada perjanjian keimaman selamanya. Karena dia giat membela Allahnya dan telah melakukan penebusan bagi Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Nama orang Israel yang dibunuh bersama perempuan Midian adalah Zimri, anak Salu. Dia seorang pemimpin keluarga dari suku Simeon. ");
INSERT INTO indayt_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Nama perempuan Midian yang dibunuh ialah Kozbi, anak Zur, kepala keluarga dari suku leluhur Midian. ");
INSERT INTO indayt_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","TUHAN berfirman kepada Musa, ");
INSERT INTO indayt_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Seranglah Midian dan pukullah mereka. ");
INSERT INTO indayt_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Sebab, mereka telah memusuhimu dengan merancang peristiwa di Peor dan peristiwa Kozbi, anak perempuan pemimpin Midian, yang mati pada waktu tulah terjadi atas orang Israel karena peristiwa Peor.” ");
INSERT INTO indayt_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Setelah tulah itu berhenti, TUHAN berfirman kepada Musa dan Eleazar, anak Imam Harun. ");
INSERT INTO indayt_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Hitunglah jumlah seluruh umat Israel yang berumur lebih dari 20 tahun menurut sukunya, orang-orang yang sanggup berperang dari Israel.” ");
INSERT INTO indayt_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa dan Imam Eleazar berkata kepada mereka di dataran Moa