﻿USE sofia;
DROP TABLE IF EXISTS sofia.indags_vpl;
CREATE TABLE indags_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES indags_vpl WRITE;
INSERT INTO indags_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitab ini mencatat tentang kisah Yesus sang Mesias, keturunan dari Daud, dan Daud adalah keturunan dari Abraham. Inilah permulaan garis keturunan-Nya. ");
INSERT INTO indags_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, Ishak, Yakub, ");
INSERT INTO indags_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda, Peres (dan Zerah, ibu mereka adalah Tamar), Hezron, ");
INSERT INTO indags_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, Aminadab, Nahason, ");
INSERT INTO indags_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Boaz (ibunya bernama Rahab), Obed (ibunya adalah Rut), Isai, ");
INSERT INTO indags_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Raja Daud, Salomo (ibunya adalah mantan istri Uria), ");
INSERT INTO indags_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rehoboam, Abia, Asa, ");
INSERT INTO indags_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yosafat, Yoram, Uzia, ");
INSERT INTO indags_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yotam, Ahaz, Hizkia, ");
INSERT INTO indags_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manasye, Amon, Yosia, ");
INSERT INTO indags_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","dan Yosia ayah Yoyakhin dan saudara-saudaranya, pada waktu pembuangan ke Babel. ");
INSERT INTO indags_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sesudah bangsa Israel kembali pulang dari penawanan di Babel sampai Yesus dilahirkan, inilah daftar nenek moyang-Nya, yaitu Sealtiel, Zerubabel, ");
INSERT INTO indags_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud, Eliakim, Azor, ");
INSERT INTO indags_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Zadok, Akim, Eliud, ");
INSERT INTO indags_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar, Matan, Yakub. ");
INSERT INTO indags_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dan Yusuf yang adalah suami Maria, ibu Yesus, yang disebut Mesias. ");
INSERT INTO indags_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jadi mulai dari Abraham sampai Daud ada 14 generasi, dari Daud sampai bangsa Israel diangkut ke Babel sebagai tawanan ada 14 generasi, dan sesudah kembali dari penawanan sampai lahirnya Mesias, ada 14 generasi. ");
INSERT INTO indags_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inilah kisah kelahiran Yesus sang Mesias. Ibu-Nya, Maria bertunangan dengan Yusuf, tetapi sebelum mereka sah menjadi suami dan istri, Maria sudah hamil oleh karena kuasa Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusuf, tunangan Maria, adalah seorang pria yang baik dan tidak ingin mempermalukan Maria di depan umum, maka dia bermaksud untuk memutuskan pertunangan mereka dengan diam-diam. ");
INSERT INTO indags_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sementara Yusuf sedang memikirkan hal ini, malaikat Tuhan datang kepadanya dalam mimpinya dan berkata, “Yusuf, keturunan Daud, janganlah takut untuk menikahi Maria sebab dia hamil oleh kuasa Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dia akan melahirkan seorang anak laki-laki dan kamu akan memberi nama Yesus kepada anak itu, sebab anak itu akan menyelamatkan orang-orang dari dosa-dosa mereka.” ");
INSERT INTO indags_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(Semua ini terjadi untuk menepati janji-janji yang Tuhan berikan melalui nabinya: ");
INSERT INTO indags_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Seorang perawan akan mengandung, dan akan melahirkan seorang anak laki-laki. Dan mereka akan menyebut anak itu Imanuel,” yang artinya “Allah ada bersama kita.”) ");
INSERT INTO indags_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ketika Yusuf bangun dari tidurnya, dia melakukan apa yang dikatakan oleh malaikat Tuhan itu. ");
INSERT INTO indags_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yusuf menikahi Maria, tapi tidak bersetubuh dengannya sampai sesudah Maria melahirkan seorang anak laki-laki, dan memberi-Nya nama Yesus. ");
INSERT INTO indags_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sesudah Yesus dilahirkan di kota Betlehem di daerah Yudea di bawah pemerintahan Raja Herodes, beberapa orang bijak datang dari arah timur ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Dimanakah Raja orang Yahudi yang baru lahir itu?” tanya mereka. “Kami melihat bintangnya di timur dan kami datang untuk menyembah Dia.” ");
INSERT INTO indags_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ketika Raja Herodes mendengar berita ini, dia dan seluruh penduduk Yerusalem merasa sangat gelisah. ");
INSERT INTO indags_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lalu Herodes memanggil semua imam kepala dan guru-guru agama, dan bertanya di mana Mesias seharusnya dilahirkan. ");
INSERT INTO indags_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Di kota Betlehem di daerah Yudea”, jawab mereka, “sebab itulah yang ditulis oleh para nabi: ");
INSERT INTO indags_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem di daerah Yudea, kamu tidak menjadi kota yang paling tidak penting di antara kota-kota besar di Yehuda, sebab seorang pemimpin yang berasal dari padamu akan menggembalakan umat-Ku Israel.’” ");
INSERT INTO indags_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lalu Herodes memanggil orang-orang bijak itu dan mengadakan pertemuan dengan mereka secara pribadi. Dalam pertemuan ini Herodes mendapat tahu dari mereka waktu yang tepat tentang kapan bintang itu muncul pertama kali. ");
INSERT INTO indags_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Dan dikirimnya mereka ke kota Betlehem dengan pesan, “Ketika kalian tiba di sana, carilah tempat anak itu berada. Dan ketika kalian menemukan-Nya, segeralah mengabariku, agar saya juga dapat datang dan menyembah Dia juga.” ");
INSERT INTO indags_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sesudah mereka mendengar perkataan sang raja, mereka berangkat. Di langit muncul bintang yang mereka lihat di timur yang memimpin mereka selama ini, sampai bintang itu kemudian berhenti tepat di atas tempat di mana anak itu berada. ");
INSERT INTO indags_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Maka ketika mereka melihat bintang itu, sangat bersukacitalah mereka! ");
INSERT INTO indags_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lalu masuklah mereka ke dalam rumah itu dan melihat anak itu bersama dengan Maria, ibunya. Mereka membungkukkan tubuh dan menyembah Dia. Lalu membuka tas-tas mereka yang penuh dengan harta benda, dan memberi kepada-Nya hadiah berupa emas, kemenyan, dan mur. ");
INSERT INTO indags_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Karena diperingati dalam mimpi untuk tidak kembali kepada Herodes, orang-orang bijak ini kembali ke negeri mereka melalui jalan yang berbeda. ");
INSERT INTO indags_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Dan sesudah orang-orang bijak itu pulang, malaikat Tuhan muncul kembali kepada Yusuf melalui sebuah mimpi, dan berkata, “Bangunlah, dan bawalah anak itu dengan ibunya, dan larilah ke Mesir. Tinggallah di situ sampai saya memberi kabar lagi kepadamu untuk kembali. Sebab Herodes ingin mencari Anak itu dan membunuh Dia.” ");
INSERT INTO indags_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Maka malam itu juga Yusuf bangun, membawa Maria serta Yesus dan pergi menuju ke Mesir. ");
INSERT INTO indags_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dan mereka menetap di sana sampai Herodes meninggal. Kejadian ini memenuhi janji yang Tuhan berikan melalui hamba-Nya sang nabi, “Dari Mesir Aku memanggil Anak-Ku.” ");
INSERT INTO indags_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Raja Herodes menjadi sangat marah ketika menyadari bahwa dia sudah dibohongi oleh orang-orang bijak itu. Maka dikirimnya para tentara untuk membunuh anak-anak laki-laki yang berusia di bawah dua tahun di kota Betlehem dan daerah sekitarnya. Hal ini berdasarkan kurun waktu yang dia dapat dari para orang bijak itu. ");
INSERT INTO indags_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dengan cara ini, maka perkataan Allah melalui nabi Yeremia ditepati. ");
INSERT INTO indags_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Terdengar suara tangisan yang mengerikan di Rama, sebab Rahel menangisi anak-anaknya. Mereka semua sudah mati, dan dia tidak bisa ditenangkan lagi.” ");
INSERT INTO indags_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sesudah kematian Herodes, malaikat Tuhan kembali muncul di dalam mimpi kepada Yusuf di Mesir dan berkata, ");
INSERT INTO indags_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bangunlah! Bawalah Anak itu dan ibu-Nya, dan kembalilah ke negeri Israel, sebab orang-orang yang mencoba membunuh Anak itu sudah mati.” ");
INSERT INTO indags_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Maka bangunlah Yusuf dan membawa serta Anak itu dengan ibu-Nya kembali ke negeri Israel. ");
INSERT INTO indags_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Namun Yusuf menjadi takut ketika mendengar bahwa Arkelaus sudah menggantikan ayahnya Herodes sebagai Raja negeri Yudea, sehingga dia tidak jadi pergi ke sana melainkan ke daerah Galilea. ");
INSERT INTO indags_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Di sana ia menetap di Nazaret. Dan ini sesuai dengan yang diucapkan oleh para nabi, “Dia akan disebut orang Nazaret.” ");
INSERT INTO indags_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bertahun-tahun kemudian, Yohanes Pembaptis tampil ke hadapan orang banyak, menyerukan kalimat ini di gurun Yudea, ");
INSERT INTO indags_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Bertobatlah, sebab Kerajaan Surga sudah datang!” ");
INSERT INTO indags_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dialah yang dibicarakan oleh Nabi Yesaya ketika dia berkata, “Ada suara yang berseru di padang gurun, ‘Persiapkanlah jalan bagi Tuhan. Luruskanlah jalan bagi Dia.’” ");
INSERT INTO indags_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes berpakaian dari kulit unta, dengan ikat pinggang terbuat dari kulit melingkari pinggangnya. Makanannya adalah belalang dan madu hutan. ");
INSERT INTO indags_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Banyak orang datang kepadanya dari Yerusalem, seluruh Yudea, dan dari seluruh daerah Sungai Yordan, ");
INSERT INTO indags_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","dan dibaptis di Sungai Yordan, dan mengakui dosa-dosa mereka di depan umum. ");
INSERT INTO indags_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tetapi ketika Yohanes melihat banyak orang Farisi dan Saduki datang untuk meminta diri dibaptis, berkatalah dia kepada mereka, “Kalian keturunan ular beracun! Siapa yang memberi kalian peringatan bahwa kalian bisa lari dari penghakiman yang sedang datang? ");
INSERT INTO indags_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tunjukkanlah pertobatan kalian dengan perbuatan kalian, ");
INSERT INTO indags_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","dan janganlah berpikir dengan sombong kepada diri kalian sendiri, ‘Abraham adalah nenek moyang kami.’ Saya katakan kepada kalian, bahwa Allah bisa menjadikan batu-batu ini menjadi anak-anak Abraham. ");
INSERT INTO indags_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nyatanya kapak, sudah siap untuk menebang pohon buah-buahan. Setiap pohon yang tidak menghasilkan buah yang baik akan ditebang dan dibuang ke dalam api. ");
INSERT INTO indags_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Benar, saya memang membaptis kalian dengan air untuk menunjukkan pertobatan kalian, tetapi sesudah saya, akan datang seseorang yang lebih besar dariku. Aku bahkan tidak layak untuk melepaskan alas kaki-Nya. Dan dia akan membaptis kalian dengan Roh Kudus dan dengan api. ");
INSERT INTO indags_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Alat penampi sudah ada di tangan-Nya. Dia akan membersihkan tempat pengirikan gandum dan mengumpulkan gandum ke dalam lumbung, tetapi kulit-kulit sekamnya akan dibakar dengan api yang tidak dapat dipadamkan.” ");
INSERT INTO indags_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kemudian datanglah Yesus dari Galilea ke Sungai Yordan untuk dibaptis oleh Yohanes. ");
INSERT INTO indags_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Namun Yohanes mencoba membujuk Yesus agar mengubah pikiran-Nya. Katanya, “Akulah yang perlu Engkau baptis, bukan saya yang membaptis Engkau!” ");
INSERT INTO indags_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jawab Yesus, “Baptislah Aku, sebab baik bagi kita berdua untuk melakukan perbuatan yang benar dalam pandangan Allah.” Maka Yohanes pun mengikuti perkataan Yesus. ");
INSERT INTO indags_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Segera sesudah dibaptis, Yesus keluar dari air. Langit terbuka, dan dia melihat Roh Allah yang seperti seekor burung merpati turun ke atas-Nya. ");
INSERT INTO indags_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kemudian terdengarlah suara dari surga yang berkata, “Inilah anak yang Aku kasihi, yang menyenangkan Aku.” ");
INSERT INTO indags_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kemudian Yesus dibawa oleh Roh ke padang gurun untuk dicobai oleh iblis. ");
INSERT INTO indags_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sesudah berpuasa selama empat puluh hari dan empat puluh malam, maka Yesuspun merasa lapar. ");
INSERT INTO indags_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lalu datanglah si Pencoba dan berkata kepada-Nya, “Jika Engkau sungguh-sungguh Anak Allah, maka perintahkanlah agar batu-batu ini berubah menjadi roti.” ");
INSERT INTO indags_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jawab Yesus kepadanya, “Seperti yang tertulis dalam Kitab Suci, ‘Manusia tidak hidup hanya karena makan roti saja, tetapi oleh karena setiap kata yang keluar dari mulut Allah.’” ");
INSERT INTO indags_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lalu Iblis membawa-Nya ke kota kudus, dan menempatkan-Nya di bagian atas Rumah Allah. ");
INSERT INTO indags_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Jika Engkau benar-benar Anak Allah, lemparkanlah diri-Mu,” katanya kepada Yesus. “Seperti yang tertulis dalam Kitab Suci, ‘Dia akan memerintahkan malaikat-malaikat-Nya untuk menjaga-Mu dari kecelakaan. Mereka akan menangkap-Mu sehingga Engkau tidak akan tersandung oleh batu.’” ");
INSERT INTO indags_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jawab Yesus, “Tetapi Kitab Suci juga menjawab, ‘Jangan menguji Tuhan Allahmu.’” ");
INSERT INTO indags_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lalu Iblis membawa Yesus ke sebuah puncak gunung yang sangat tinggi dan memperlihatkan kepada-Nya semua kerajaan yang ada di dunia ini dengan keagungan mereka. ");
INSERT INTO indags_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dan berkatalah Iblis kepada-Nya, “Akan saya berikan semua ini jika Engkau mau sujud dan menyembahku.” ");
INSERT INTO indags_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","“Pergilah, Iblis!” jawab Yesus. “Seperti yang tertulis dalam Kitab Suci, ‘Haruslah engkau hanya menyembah dan melayani Allah saja.’” ");
INSERT INTO indags_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lalu Iblis meninggalkan Yesus, dan para malaikat datang dan merawat-Nya. ");
INSERT INTO indags_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ketika kabar tentang penangkapan Yohanes Pembaptis sampai kepada Yesus, maka kembalilah Dia ke Galilea. ");
INSERT INTO indags_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yesus pindah dari Nazaret ke Kapernaum dan tinggal di daerah pantai di tepi laut di antara wilayah Zebulon dan Naftali. ");
INSERT INTO indags_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hal ini menggenapi nubuatan yang disampaikan oleh Nabi Yesaya, ");
INSERT INTO indags_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Di wilayah Zebulon dan Naftali, di jalan menuju ke laut, di seberang Sungai Yordan, di Galilea tempat tinggal para orang asing: ");
INSERT INTO indags_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Oprang-orang yang tinggal dalam kegelapan sudah melihat suatu terang yang besar, fajar sudah mulai terbit atas mereka yang hidup di wilayah bayang-bayang kematian.” ");
INSERT INTO indags_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sejak saat itu Yesus mulai menyerukan pesannya, “Bertobatlah, sebab Kerajaan Surga sudah tiba!” ");
INSERT INTO indags_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ketika Yesus berjalan di tepi laut Galilea, Dia melihat dua orang bersaudara, yaitu Simon, yang dipanggil dengan nama Petrus, dan saudaranya, Andreas, sedang menebarkan jala di laut. Pekerjaan mereka adalah nelayan. ");
INSERT INTO indags_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Mari datang, dan ikutlah Aku, dan Aku akan mengajari kalian cara menjala manusia,” kata-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Maka mereka dengan segera meninggalkan jala mereka dan mengikuti Dia. ");
INSERT INTO indags_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sementara Yesus terus berjalan, Dia kembali melihat dua orang bersaudara lainnya, Yakobus dan Yohanes. Mereka sedang ada di dalam perahu bersama dengan Zebedeus, ayah mereka, sedang memperbaiki jala. Yesus memanggil mereka untuk mengikuti Dia. ");
INSERT INTO indags_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dan mereka segera meninggalkan kapal dan ayah mereka, dan mengikuti Dia. ");
INSERT INTO indags_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus berjalan mengelilingi seluruh Galilea, mengajar di sinagoge-sinagoge, memberitakan kabar baik tentang Kerajaan Surga, dan menyembuhkan banyak orang dari segala jenis penyakit mereka. ");
INSERT INTO indags_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Berita tentang Dia dengan segera tersebar di seluruh provinsi Siria. Orang-orang membawa siapa saja yang sedang sakit kepada-Nya, mereka yang menderita kejang, dirasuk setan, sakit mental, lumpuh, dan Yesus menyembuhkan mereka semua. ");
INSERT INTO indags_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Orang banyak yang besar jumlahnya mengikuti Yesus dari Galilea, Dekapolis, Yerusalem, Yudea, bahkan dari daerah seberang sungai Yordan. ");
INSERT INTO indags_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ketika Yesus melihat rombongan orang mengikuti Dia, maka naiklah dia ke atas sebuah bukit. Di sana Yesus duduk bersama dengan murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dan mulai mengajar mereka, katanya: ");
INSERT INTO indags_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Berbahagialah mereka yang mengetahui bahwa mereka miskin rohani sebab punya merekalah kerajaan surga. ");
INSERT INTO indags_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Berbahagialah mereka yang saat ini berdukacita, sebab mereka akan menerima penghiburan. ");
INSERT INTO indags_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Berbahagialah mereka yang baik hati sebab mereka yang akan mewarisi bumi ini. ");
INSERT INTO indags_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Berbahagialah mereka yang keinginan terbesar mereka adalah melakukan apa yang benar, sebab mereka akan merasa puas. ");
INSERT INTO indags_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Berbahagialah orang yang penyayang, karena mereka akan diperlihatkan belas kasihan. ");
INSERT INTO indags_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Berbahagialah mereka yang memiliki pikiran murni, sebab merekalah yang akan melihat Allah. ");
INSERT INTO indags_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Berbahagialah mereka yang bekerja untuk mendatangkan kedamaian, sebab mereka akan disebut anak-anak Allah. ");
INSERT INTO indags_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Berbahagialah mereka yang menderita karena hidup benar, sebab kerajaan Allah adalah milik mereka. ");
INSERT INTO indags_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Berbahagialah kamu ketika orang-orang menghina dan menganiaya kamu, dan menuduhmu melakukan segala macam kejahatan karena Aku. ");
INSERT INTO indags_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bersukacitalah, benar-benar bergembiralah, sebab kamu akan menerima imbalan di surga — sebab mereka juga menganiaya nabi-nabi yang hidup sebelum kamu dengan cara yang sama.” ");
INSERT INTO indags_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kalian bisa diumpamakan seperti garam, yang bisa memberi rasa asin pada dunia, tetapi jika garam itu menjadi tidak ada rasa, bagaimana bisa membuatkan kembali memiliki rasa? Garam itu menjadi sesuatu yang tidak berguna, yang akhirnya dibuang dan diinjak-injak. ");
INSERT INTO indags_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kalian juga bisa diumpamakan seperti terang bagi dunia ini. Seperti kota yang dibangun di atas bukit, sehingga tidak mungkin tidak terlihat. ");
INSERT INTO indags_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tidak seorangpun menyalakan sebatang lilin lalu meletakkannya di bawah ember. Tetapi pasti diletakkan di atas tempat lilin sehingga lilin itu memberikan cahaya kepada semua orang yang ada di dalam rumah. ");
INSERT INTO indags_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dengan cara yang sama, kamu harus membiarkan terang kamu bersinar di hadapan orang-orang sehingga mereka bisa melihat perbuatan-perbuatan baikmu dan memuji Bapamu yang ada di surga. ");
INSERT INTO indags_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jangan berpikir bahwa Aku datang untuk meniadakan hukum Taurat ataupun tulisan para nabi. Aku datang bukan untuk meniadakannya, tetapi untuk memenuhinya. ");
INSERT INTO indags_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aku pastikan kepada kalian, bahwa sampai surga dan bumi ini berakhir, tidak satu huruf atau tanda baca yang sudah tertulis dalam hukum Taurat akan dibatalkan sampai segala sesuatunya tergenapi. ");
INSERT INTO indags_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jadi siapapun yang mengabaikan perintah yang dianggap paling tidak penting, dan mengajarkan kepada orang lain untuk berlaku demikian, maka dia juga akan menjadi orang yang paling tidak penting di dalam kerajaan surga, tetapi barangsiapa yang melakukan dan mengajarkan perintah-perintah ini, akan dianggap orang yang luar biasa di kerajaan surga. ");
INSERT INTO indags_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aku katakan kepadamu, jika cara hidup moralmu tidak lebih benar daripada para guru agama dan orang-orang Farisi, kamu tidak akan bisa masuk dalam kerajaan surga. ");
INSERT INTO indags_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kalian sudah mendengar bahwa hukum Taurat berkata kepada nenek moyang kita, ‘Janganlah membunuh, dan setiap orang yang membunuh akan diadili dan dihukum.’ ");
INSERT INTO indags_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tetapi Aku katakan kepada kalian, siapapun yang marah kepada saudaranya akan dinyatakan bersalah. Dan siapapun yang menyebut saudaranya bodoh haruslah dihadapkan ke pengadilan, tetapi siapapun yang dengan perkataan jelas mencari maki saudaranya harus bersiap menghadapi api Gehena. ");
INSERT INTO indags_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dan jika kamu sedang di depan mezbah untuk membawa persembahanmu, dan kamu teringat bahwa ada seseorang yang sedang berseteru denganmu, ");
INSERT INTO indags_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","maka tinggalkanlah persembahanmu itu dan berdamailah dengannya, dan sesudah itu barulah kamu datang kembali untuk memberikan persembahanmu itu. ");
INSERT INTO indags_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Jika kamu sedang berhadapan di pengadilan dengan musuhmu, segeralah kamu membereskan masalahmu dengan dia dan berdamailah. Jika tidak, musuhmu bisa saja menyerahkanmu ke tangan hakim, dan hakim akan menyerahkanmu kepada petugas pengadilan, dan kamu akan masuk ke dalam penjara. ");
INSERT INTO indags_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Biar Saya beritahu yang sebenarnya kepadamu, kamu tidak akan keluar dari dalam penjara sampai kamu melunasi denda yang sudah ditetapkan oleh hakim itu. ");
INSERT INTO indags_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kalian juga sudah mendengar di dalam hukum Taurat, ‘Jangan berzina.’ ");
INSERT INTO indags_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tetapi Aku katakan ini kepada kalian, siapapun yang melihat dengan penuh hasrat birahi kepada seorang perempuan, sudah melakukan berzina dengan perempuan itu di dalam pikirannya. ");
INSERT INTO indags_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jika salah satu matamu menyebabkan kamu berdosa, cungkillah mata itu keluar dan buanglah, sebab lebih baik kamu kehilangan salah satu anggota tubuhmu dari pada seluruh tubuhmu dilemparkan ke dalam api Gehena. ");
INSERT INTO indags_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jika salah satu tanganmu menyebabkan kamu melakukan dosa, potonglah dan buanglah itu, sebab lebih baik bagimu kehilangan salah satu anggota tubuhmu dari pada seluruh tubuhmu dilemparkan ke dalam api Gehena. ");
INSERT INTO indags_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Hukum juga mengatakan, ‘Jika seorang laki-laki menceraikan istrinya, ia harus memberinya surat cerai.’ ");
INSERT INTO indags_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tetapi Aku berkata kepadamu bahwa siapa pun yang menceraikan istrinya kecuali karena amoralitas seksual menyebabkan dia berzinah, dan siapa pun menikahi wanita yang diceraikan melakukan perzinahan. ");
INSERT INTO indags_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kalian juga sudah mendengar, hukum Taurat berkata kepada nenek moyang kita, ‘Janganlah mengucapkan sumpah palsu. Sebaliknya, tepatilah sumpah yang sudah pernah kamu ucapkan kepada Tuhan.’ ");
INSERT INTO indags_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tetapi Aku katakan kepada kalian, jangan pernah mengatakan sumpah sama sekali. Jangan bersumpah demi surga, sebab di sanalah Allah bertahta. ");
INSERT INTO indags_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jangan bersumpah demi bumi, sebab bumi adalah tempat Allah meletakkan kaki-Nya. Jangan bersumpah demi Yerusalem, sebab kota itu adalah kota milik Raja Besar. ");
INSERT INTO indags_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bahkan jangan bersumpah demi kepalamu, sebab kamu bahkan tidak mampu membuat sehelai rambutmu pun berubah dari hitam ke putih. ");
INSERT INTO indags_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cukup katakan ‘ya’ jika kamu maksudkan ‘ya’ atau katakan ‘tidak’ jika kamu maksud ‘tidak’ — sebab menambahkan sesuatu yang lebih dari itu berasal dari si jahat. ");
INSERT INTO indags_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kalian sudah mendengar hukum Taurat berkata, ‘Mata ganti mata, dan gigi ganti gigi.’ ");
INSERT INTO indags_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tetapi Aku katakan kepadamu, janganlah membalas orang yang berbuat jahat. Jika ada yang menampar pipi kananmu, biarkan mereka menampar pipi kirimu juga. ");
INSERT INTO indags_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jika seorang pergi ke pengadilan karena ingin mengambil pakaianmu, berilah juga mantelmu. ");
INSERT INTO indags_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jika seseorang memaksamu berjalan sepanjang satu kilometer, berjalanlah bersama dengannya sepanjang dua kilometer. ");
INSERT INTO indags_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Berikanlah barang yang diminta dari kamu, dan janganlah menolak mereka yang ingin meminjam darimu. ");
INSERT INTO indags_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kalian sudah mendengar bahwa dalam hukum Taurat ada tertulis, ‘Kasihilah tetanggamu dan bencilah musuhmu.’ ");
INSERT INTO indags_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tetapi Aku berkata kepada kalian, kasihilah musuh kalian dan berdoalah untuk mereka yang menganiaya kalian, ");
INSERT INTO indags_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","supaya kamu menjadi anak-anak Bapa surgawimu. Sebab matahari yang Dia ciptakan juga menerangi baik orang baik maupun orang jahat, dan hujan yang Dia turunkan juga jatuh untuk mereka yang melakukan perbuatan yang benar dan yang tidak benar. ");
INSERT INTO indags_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sebab jika kalian hanya mengasihi orang yang mengasihi kamu, imbalan apa yang akan kamu dapat dari Allah? Sebab penagih pajak pun bisa melakukan hal itu. ");
INSERT INTO indags_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jika kamu hanya berbuat baik kepada anggota keluargamu, apa bedanya kamu dengan orang-orang lain? Bahkan orang-orang yang tidak peduli dengan Allah juga melakukannya! ");
INSERT INTO indags_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tumbuh dan menjadi benar-benar dapat dipercaya, seperti Bapa surgawi kalian dapat dipercaya.” ");
INSERT INTO indags_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pastikanlah kamu tidak melakukan perbuatan baikmu di hadapan semua orang hanya agar mereka bisa melihatnya. Jika kamu melakukannya dengan maksud seperti itu, maka Bapamu yang di surga tidak akan memberi kepadamu upah dari perbuatanmu itu. ");
INSERT INTO indags_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dan ketika kamu memberi kepada orang-orang miskin, janganlah seperti para orang munafik yang meniupkan terompet mereka sendiri untuk mengumumkan semua perbuatan yang mereka lakukan di rumah-rumah ibadat dan di jalan-jalan agar orang-orang lain memuji mereka. Biar Aku beritahu kepadamu yang sebenarnya, mereka sudah mendapatkan upah mereka. ");
INSERT INTO indags_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sebab itu, jika kamu memberikan kepada orang miskin, janganlah orang lain sampai tahu pemberianmu, sama seperti tangan kirimu tidak tahu apa yang diperbuat oleh tangan kananmu. ");
INSERT INTO indags_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dengan demikian, pemberianmu itu hanya akan diketahui oleh Bapamu yang di surga, yang melihat hal-hal yang tersembunyi dan akan memberi upah kepadamu. ");
INSERT INTO indags_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Dan ketika kamu sedang berdoa, janganlah berdoa seperti orang-orang munafik, sebab mereka suka berdiri dan berdoa di rumah-rumah ibadat dan di sudut-sudut jalan agar orang-orang bisa melihat mereka. Yakinlah, mereka sudah mendapat upah mereka. ");
INSERT INTO indags_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tetapi kamu, jika kamu berdoa, masuklah ke dalam dan tutuplah pintu, dan berdoalah kepada Bapamu secara pribadi, dan Bapamu yang melihat di tempat-tempat tersembunyi, akan memberi upah kepadamu. ");
INSERT INTO indags_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dan ketika kamu berdoa, janganlah berceloteh tanpa arti seperti yang dilakukan orang yang tidak mengenal Allah, yang berpikir bahwa mereka akan didengar hanya karena ucapan doa mereka yang berulang-ulang. ");
INSERT INTO indags_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Janganlah meniru mereka, sebab Bapamu yang di surga tahu yang kamu butuhkan bahkan sebelum kamu memintanya. ");
INSERT INTO indags_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tetapi berdoalah seperti ini: ");
INSERT INTO indags_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bapa surgawi kami, biarlah nama-Mu dihormati. Biarlah kerajaan-Mu datang! Dan kehendak-Mu terjadi di atas bumi ini seperti di dalam surga. ");
INSERT INTO indags_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Berikanlah kepada kami makanan yang kami butuhkan pada hari ini. ");
INSERT INTO indags_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ampunilah dosa-dosa kami, seperti kami juga mengampuni mereka yang berdosa kepada kami. ");
INSERT INTO indags_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Janganlah kami dicobai untuk melakukan perbuatan yang salah, dan selamatkanlah kami dari yang jahat. ");
INSERT INTO indags_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Sebab jika kamu memaafkan mereka yang berdosa kepada kamu, maka Bapa surgawimu juga akan memaafkan kamu. ");
INSERT INTO indags_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tetapi jika kamu tidak mau memaafkan mereka yang berdosa kepadamu, maka Bapamu yang di surga juga tidak akan mengampuni dosa-dosamu. ");
INSERT INTO indags_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ketika kamu berpuasa, janganlah seperti orang-orang munafik yang membuat roman wajahnya menjadi muram dan membuat diri mereka tampak menderita sehingga orang-orang bisa melihat bahwa mereka sedang berpuasa. Aku katakan sejujurnya, bahwa mereka sudah mendapatkan upah mereka, yaitu pujian dari orang-orang. ");
INSERT INTO indags_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sebaliknya, jika kamu berpuasa, cucilah mukamu dan tampilah dengan wajah cerah, ");
INSERT INTO indags_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sehingga orang-orang tidak melihat bahwa kamu sedang berpuasa, dan Bapa surgawimu yang tidak terlihat namun melihat segala sesuatu yang dilakukan secara diam-diam akan memberi upah kepadamu. ");
INSERT INTO indags_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Janganlah kamu menimbun kekayaan di atas bumi ini dimana ngengat dan karat akan merusaknya, dan pencuri membongkar masuk dan mencurinya. ");
INSERT INTO indags_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sebaliknya, kumpulkanlah kekayaanmu di surga, dimana ngengat dan karat tidak merusaknya, dan para pencuri tidak membongkar masuk dan mencurinya. ");
INSERT INTO indags_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sebab hal yang paling kamu hargai menunjukkan siapa dirimu yang sebenarnya. ");
INSERT INTO indags_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mata seumpama pelita yang menerangi tubuh. Jika matamu sehat, maka seluruh tubuhmu juga akan bercahaya. ");
INSERT INTO indags_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tetapi jika matamu hanya melihat yang jahat, maka seluruh tubuhmu juga akan ada dalam gelap. Jika matamu yang seharusnya terang menjadi gelap, betapa gelapnya kegelapan itu. ");
INSERT INTO indags_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tidak seorangpun bisa melayani dua majikan. Kamu pasti akan membenci yang satu dan menyayangi yang lain, atau kamu akan mengabdi kepada yang satu dan merendahkan yang lain. Kamu tidak bisa melayani Allah dan uang bersama-sama. ");
INSERT INTO indags_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Itu sebabnya Aku katakan kepadamu untuk tidak kuatir tentang hidupmu. Jangan kamu kuatir tentang apa yang harus kamu makan, ataupun minum, ataupun pakaian yang harus kamu pakai. Bukankah hidup ini lebih dari sekadar makan, dan tubuh lebih dari sekedar pakaian? ");
INSERT INTO indags_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lihatlah burung-burung — mereka tidak menabur ataupun menuai ataupun menyimpan makanan di lumbung-lumbung, tetapi Bapa surgawimu memberi mereka makan. Tidakkah kamu lebih berharga dari pada mereka? ");
INSERT INTO indags_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Siapakah di antara kamu dengan merasa kuatir bisa menambah satu menit dari hidup kalian? ");
INSERT INTO indags_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dan mengapa kamu kuatir tentang pakaian? Lihatlah bunga-bunga yang indah di padang. Lihat cara mereka bertumbuh, mereka tidak bekerja keras, mereka tidak menenun benang. ");
INSERT INTO indags_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tetapi Aku beritahu kamu, bahkan Raja Salomo dengan semua lemegahannya tidaklah berpakaian seindah bunga-bunga itu. ");
INSERT INTO indags_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jika Allah mendekorasi padang-padang seperti ini, rumput yang ada di sini hari ini dan besok dibuang ke dalam api, tidakkah Dia akan berbuat lebih lagi kepadamu, hai kamu yang sedikit sekali percaya? ");
INSERT INTO indags_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jadi janganlah kuatir dan berkata, ‘Apa yang akan kami makan?’ atau ‘Apa yang akan kami minum?’ atau ‘Baju apa yang akan kami pakai?’ ");
INSERT INTO indags_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Semua hal ini dikejar oleh orang-orang yang tidak mengenal Allah, tetapi Bapa surgawimu tahu semua hal yang kamu butuhkan. ");
INSERT INTO indags_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tetapi carilah kerajaan-Nya terlebih dahulu, dan cara hidup-Nya yang benar, maka segalanya yang lain akan diberikan kepadamu. ");
INSERT INTO indags_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maka janganlah kamu kuatir tentang hari esok, sebab hari esok punya kekuatirannya sendiri. Ada cukuplah banyak jahat setiap hari.” ");
INSERT INTO indags_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Janganlah kamu menghakimi orang lain, agar kamu juga tidak akan dihakimi. ");
INSERT INTO indags_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sebab standar yang kamu pakai untuk menghakimi orang lain akan digunakan juga untuk menghakimi kamu, dan ukuran apa yang kamu pakai untuk mengukur orang lain akan menjadi ukuran untuk mengukur kamu juga. ");
INSERT INTO indags_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mengapa kamu melihat setitik serbuk gergaji di mata sesamamu? Tidakkah kamu sadar adanya selembar papan di matamu sendiri? ");
INSERT INTO indags_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bagaimana kamu bisa berkata kepada sesamamu, ‘Mari saya tolong kamu mengeluarkan setitik dari matamu namun di saat yang sama kamu punya selembar papan di dalam matamu sendiri?’ ");
INSERT INTO indags_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hai orang-orang munafik! Singkirkanlah dahulu selembar papan yang ada di dalam matamu. Maka kamu akan bisa melihat dengan jelas untuk mengeluarkan setitik yang ada di mata sesamamu. ");
INSERT INTO indags_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jangan beri anjing apa yang suci. Jangan lemparkan mutiaramu ke babi. Dengan begitu babi tidak akan menginjak-injaknya, dan anjing tidak akan berbalik dan menyerangmu. ");
INSERT INTO indags_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mintalah, maka akan diberikan kepadamu. Carilah, maka kamu akan menemukannya. Ketuklah, maka pintu akan dibukakan untukmu. ");
INSERT INTO indags_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mereka yang meminta, akan menerima, yang mencari akan menemukan, dan yang mengetuk pintu, maka pintu akan dibukakan untuk mereka. ");
INSERT INTO indags_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Apakah ada di antara kamu yang memberi anakmu batu ketika dia minta roti untuk dimakan? ");
INSERT INTO indags_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atau ketika dia minta seekor ikan, apakah kamu akan memberi dia seekor ular? ");
INSERT INTO indags_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jadi, jika kamu yang jahat saja tahu untuk memberikan yang baik untuk anak-anakmu, apalagi Bapa surgawimu yang akan memberikan hal-hal baik kepada mereka yang minta kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Perlakukanlah orang lain seperti kamu ingin diperlakukan. Inilah meringkas yang hukum Taurat dan Kitab Nabi-nabi. ");
INSERT INTO indags_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Masuklah melalui jalan yang sempit itu. Sebab lebarlah jalan yang menuju kepada jalan kebinasaan, dan banyak orang yang melaluinya. ");
INSERT INTO indags_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tetapi sempit dan sulitlah jalan yang menuju kepada kehidupan kekal, dan hanya sedikit orang yang menemukannya. ");
INSERT INTO indags_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Hati-hati dengan nabi palsu yang datang dengan memakai pakaian domba, tetetapi didalamnya adalah serigala ganas. ");
INSERT INTO indags_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kamu akan bisa mengenali mereka dari hasil perbuatan mereka. Tidak mungkin orang memanen buah anggur dari semak duri, atau buah ara dari onak berduri. ");
INSERT INTO indags_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jadi setiap pohon yang baik akan menghasilkan buah yang baik, sementara pohon yang buruk akan menghasilkan buah yang busuk. ");
INSERT INTO indags_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Setiap pohon yang baik tidak bisa menghasilkan buah yang tidak baik, demikian juga pohon yang tidak baik tidak bisa menghasilkan buah yang baik. ");
INSERT INTO indags_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dan setiap pohon yang tidak menghasilkan buah yang baik akan ditebang dan dibakar. ");
INSERT INTO indags_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jadi dari buahnyalah kamu akan mengenali pohon itu. ");
INSERT INTO indags_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bukan setiap orang yang memanggil Aku, ‘Tuhan, Tuhan,’ akan masuk ke dalam kerajaan Surga — hanya mereka yang melakukan kehendak Bapa-Ku yang di surga yang akan masuk ke dalam kerajaan Surga. ");
INSERT INTO indags_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Banyak orang yang akan berkata kepada-Ku pada hari Penghakiman, ‘Tuhan, Tuhan, kami kan sudah bernubuat dalam nama-Mu dan mengusir setan dalam nama-Mu, dan juga melakukan banyak mujizat dalam nama-Mu.’ ");
INSERT INTO indags_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pada saat itulah Aku berkata kepada mereka, ‘Aku tidak pernah mengenal kamu. Tinggalkan Aku, hai para pelaku kejahatan!’ ");
INSERT INTO indags_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Setiap orang yang mendengar ucapan-Ku, dan mengikutinya, adalah seperti seorang bijak yang membangun rumahnya di atas pondasi yang kuat. ");
INSERT INTO indags_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lalu turunlah hujan, banjir datang, dan angin bertiup kencang menghantam rumah itu, tetapi rumah itu tidaklah runtuh, sebab dibangun di atas pondasi yang kokoh. ");
INSERT INTO indags_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Setiap orang yang mendengar ucapan-Ku, tetapi tidak melakukannya, adalah seperti orang bodoh yang membangun rumahnya di atas pasir. ");
INSERT INTO indags_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lalu turunlah hujan, datanglah banjir, dan angin bertiup menghantam rumah itu, maka rumah itupun rubuh — benar-benar rata dengan tanah.” ");
INSERT INTO indags_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ketika Yesus selesai mengajarkan hal-hal ini, maka takjublah orang banyak itu, ");
INSERT INTO indags_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sebab Dia mengajar seperti seorang yang mempunyai otoritas, dan bukan seperti guru-guru agama mereka. ");
INSERT INTO indags_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sekelompok besar orang mengikuti Yesus ketika Dia sudah selesai mengajar di gunung. ");
INSERT INTO indags_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Seorang yang menderita sakit kusta datang mendekati Dia dan menyembah-Nya, serta berkata, “Tuhan, jika Engkau berkenan, sembuhkanlah saya.” ");
INSERT INTO indags_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lalu Yesus mengulurkan tangan-Nya dan menyentuh dia. “Aku mau,” kata-Nya. “Sembuhlah!” Maka dengan segera orang itupun sembuh dari sakitnya. ");
INSERT INTO indags_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","“Jangan beritahu siapapun mengenai hal ini,” kata Yesus kepadanya. “Tetapi pergi dan tunjukkanlah dirimu kepada imam dan berilah persembahan yang Musa perintahkan sebagai bukti di muka umum.” ");
INSERT INTO indags_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ketika Yesus masuk ke kota Kapernaum, seorang perwira Romawi datang menjumpai Dia, memohon pertolongan-Nya, ");
INSERT INTO indags_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tuhan, seorang pembantuku di rumah, sedang terbaring sakit, tidak bisa bergerak. Dia sedang sangat kesakitan.” ");
INSERT INTO indags_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Aku akan datang dan menyembuhkan dia,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tetapi perwira Romawi itu menjawab, “Tuhan, saya tidak layak menerima kunjungan-Mu ke rumah saya. Cukup katakan sepatah kata saja, maka pembantuku di rumah akan sembuh. ");
INSERT INTO indags_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sebab saya sendiri memiliki atasan, dan juga para prajurit yang menjadi bawahan saya. Jika saya berkata kepada seorang prajurit, ‘Pergi!’ dan dia akan pergi. Dan kepada yang lain saya berkata, ‘Kemari!’ dan dia akan datang. Saya katakan kepada pelayan saya, ‘Lakukanlah ini!’ dan dia melakukannya.” ");
INSERT INTO indags_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ketika Yesus mendengar ucapannya, takjublah Yesus. Dia berkata kepada semua yang mengikuti Dia, “Aku katakan sejujurnya, tidak pernah Aku jumpai kepercayaan seperti ini di manapun di antara orang Israel. ");
INSERT INTO indags_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aku katakan kepada kalian, akan banyak orang yang datang dari daerah timur dan barat, dan duduk bersama dengan Abraham, Ishak dan Yakub dalam Kerajaan Surga. ");
INSERT INTO indags_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tetapi pewaris-pewaris kerajaan itu sebaliknya akan dibuang ke dalam kegelapan yang paling gelap di mana akan ada tangisan dan gertakan gigi.” ");
INSERT INTO indags_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lalu berkatalah Yesus kepada perwira itu, “Pulanglah. Sebab kamu sangat percaya bahwa hal itu akan terjadi, maka permintaanmu sudah dipenuhi.” Dan pelayan perwira itu sembuh seketika itu juga. ");
INSERT INTO indags_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ketika Yesus tiba di rumah Petrus, Dia melihat bahwa ibu mertua Petrus sedang sakit terserang demam tinggi. ");
INSERT INTO indags_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jadi Yesus menyentuh tangan wanita itu dan demamnya pergi. Perempuan itu lalu duduk dan mulai mempersiapkan makanan untuk mereka. ");
INSERT INTO indags_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ketika sore hari tiba, maka banyak orang yang datang kepada Yesus sambil membawa orang-orang yang sedang dikuasai setan. Yesus memerintahkan setan-setan itu untuk pergi, dan banyak menyembuhkan mereka yang sedang sakit. ");
INSERT INTO indags_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hal ini menggenapi nubuatan dari nabi Yesaya, “Dialah yang menyembuhkan penyakit kita, dan membebaskan kita dari kesakitan kita.” ");
INSERT INTO indags_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ketika Yesus melihat banyak orang yang mengelilingi Dia, maka Dia memerintahkan agar Dia beserta murid-murid-Nya untuk pergi ke sisi lain dari danau. ");
INSERT INTO indags_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Salah satu ahli Taurat datang mendekati-Nya dan berkata, “Guru, saya akan ikut kemanapun guru pergi!” ");
INSERT INTO indags_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jawab Yesus kepadanya, “Rubah-rubah punya liang, dan burung-burung liar punya sarang, tetapi Anak Manusia tidak punya tempat untuk berbaring dan beristirahat.” ");
INSERT INTO indags_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Seorang murid lain mendekati-Nya dan berkata, “Tuhan, ijinkanlah saya menguburkan ayahku lebih dahulu, dan saya akan mengikuti Engkau.” ");
INSERT INTO indags_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Ikutlah Aku! Biarkan orang mati menguburkan orang mati mereka sendiri,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lalu Yesus naik ke dalam perahu bersama murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tiba-tiba angin badai melanda, dan ombak menerjang kapal itu, tetapi Yesus sedang tidur. ");
INSERT INTO indags_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Maka murid-murid-Nya mendekati Dia dan membangunkan-Nya. “Selamatkanlah kita, Tuhan! Kita akan mati tenggelam!” mereka berteriak. ");
INSERT INTO indags_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Mengapa kalian begitu takut? Mengapa kalian tidak percaya?” tanya-Nya kepada mereka. Lalu bangunlah Dia, dan memerintahkan angin dan gelombang untuk berhenti. Lalu segala sesuatunya menjadi benar-benar tenang. ");
INSERT INTO indags_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Para murid tertegun, dan berkata, “Siapakah orang ini? Bahkan angin dan ombak pun taat kepada-Nya!” ");
INSERT INTO indags_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ketika mereka tiba di daerah seberang di wilayah Gerasa, dua orang yang dirasuki setan keluar dari daerah kuburan untuk bertemu dengan-Nya. Mereka berdua sangat berbahaya sehingga tidak ada seorangpun yang berani lewat di daerah itu. ");
INSERT INTO indags_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mereka berteriak, “Kamu mau apa dengan kami, hai Anak Allah? Apakah Kamu ingin menyiksa kami sebelum waktunya?” ");
INSERT INTO indags_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Di kejauhan ada sekelompok besar babi yang sedang diberi makan. ");
INSERT INTO indags_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dan setan-setan itu memohon kepada-Nya, “Jika Kamu ingin mengusir kami keluar, maka kirimlah kami ke arah kumpulan ternak babi itu.” ");
INSERT INTO indags_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Pergilah!” kata Yesus. Maka setan-setan itu pergi meninggalkan kedua orang ini dan masuk ke dalam sekumpulan babi itu. Dan babi-babi itu lalu terjun ke sisi jurang dan tenggelam ke dalam laut. ");
INSERT INTO indags_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Para gembala babi-babi itu melarikan diri. Mereka masuk ke kota dan menceritakan segala sesuatu yang sudah terjadi di tempat itu, dan apa yang terjadi dengan orang-orang yang kerasukan setan sebelumnya. ");
INSERT INTO indags_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Seluruh penduduk kota datang keluar menemui Yesus. Ketika mereka bertemu dengan Dia, mereka meminta-Nya untuk meninggalkan daerah mereka. ");
INSERT INTO indags_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Maka Yesus kembali naik ke perahu dan menyeberangi danau ke arah kota tempat Dia tinggal. ");
INSERT INTO indags_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Di sana mereka membawa kepada-Nya di atas sebuah matras seorang yang sakit lumpuh. Ketika Yesus melihat betapa mereka percaya kepada-Nya, berkatalah Dia kepada orang yang lumpuh itu, “Temanku, bergembiralah! Dosa-dosamu sudah diampuni.” ");
INSERT INTO indags_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ketika orang-orang Farisi mendengar perkataan-Nya, berkatalah mereka satu sama lain, “Dia menghujat Allah!” ");
INSERT INTO indags_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tetapi Yesus mengetahui pikiran mereka. Katanya, “Mengapa kalian memiliki pikiran yang jahat? ");
INSERT INTO indags_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Perkataan mana yang lebih mudah diucapkan, ‘Dosa-dosamu sudah diampuni,’ atau ‘Bangun dan berjalanlah?’ ");
INSERT INTO indags_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tetapi agar kalian yakin bahwa Anak Manusia memang memiliki kuasa untuk mengampuni dosa,” kata-Nya kepada orang lumpuh itu, “Bangun, angkatlah matrasmu, dan pulanglah!” ");
INSERT INTO indags_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Maka bangunlah orang itu dan pulang. ");
INSERT INTO indags_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ketika orang banyak itu melihat apa yang terjadi, mereka menjadi takut. Lalu mereka memuji Allah yang sudah memberikan kuasa yang sedahsyat itu kepada seorang manusia. ");
INSERT INTO indags_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ketika Yesus berpindah dari tempat itu, Dia melihat seorang laki-laki bernama Matius sedang duduk di stan pajak. Lalu Yesus memanggilnya, “Ikutlah Aku!” Maka bangunlah Matius dan mengikuti Yesus. ");
INSERT INTO indags_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sementara Matius sedang menjamu Yesus di rumahnya, banyak para penagih pajak dan orang-orang berdosa yang datang dan duduk satu meja dengan Yesus dan murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ketika orang Farisi melihat ini, bertanyalah mereka kepada murid-murid Yesus, “Mengapa Guru kalian makan bersama-sama dengan para petugas pajak dan orang-orang berdosa?” ");
INSERT INTO indags_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ketika Yesus mendengar pertanyaan ini, Dia menjawab, “Orang yang sehat tidak memerlukan dokter, hanya orang sakit. ");
INSERT INTO indags_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pergi dan carilah arti perkataan ini, ‘Aku ingin kalian saling menunjukkan belas kasihan, dan bukan membawa persembahan. Sebab Aku tidak datang untuk memanggil mereka yang melakukan apa yang benar — Aku datang untuk memanggil orang-orang berdosa.’” ");
INSERT INTO indags_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lalu datanglah murid-murid Yohanes Pembaptis dan bertanya, “Mengapa kami dan orang-orang Farisi sering berpuasa, sedangkan murid-murid-Mu tidak?” ");
INSERT INTO indags_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","“Apakah tamu undangan berkabung sementara pengantin laki-laki bersama-sama dengan mereka?” jawab Yesus. “Tetapi akan tiba waktunya ketika pengantin itu akan diambil dari mereka, dan pada saat itulah mereka akan berpuasa. Demikian juga murid-murid-Ku, tidak akan berpuasa selama Aku bersama dengan mereka, tetapi ketika Aku tidak lagi bersama mereka, maka mereka akan berpuasa.” ");
INSERT INTO indags_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tidak seorangpun yang menambal pakaian lama dengan kain baru, sebab kain yang baru itu bisa menyusut dan membuat robekannya menjadi semakin besar. ");
INSERT INTO indags_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dan tidak seorangpun yang menuang air anggur yang baru ke dalam kantong kulit yang lama, sebab dengan begitu, kantong kulit itu akan rusak, dan air anggurnya terbuang. Tidak, anggur baru dimasukkan ke dalam kantong kulit yang baru, dan keduanya bertahan lama.” ");
INSERT INTO indags_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sementara Yesus berbicara tentang semua hal ini, datanglah salah satu pemimpin orang Yahudi dan sujud di hadapan-Nya, “Anak perempuanku baru saja meninggal,” kata orang itu kepada Yesus. “Tetapi jika Engkau datang dan menjamah dia, saya tahu bahwa dia akan hidup kembali.” ");
INSERT INTO indags_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Maka Yesus dan murid-murid-Nya berdiri dan mengikuti dia. ");
INSERT INTO indags_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ketika Yesus lewat, seorang perempuan yang sudah sakit pendarahan selama dua belas tahun datang dari belakang Yesus dan menyentuh sisi jubah-Nya. ");
INSERT INTO indags_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sebab katanya kepada dirinya sendiri, “Jika saja saya bisa menjamah bagian pinggir jubahnya, saya pasti sembuh.” ");
INSERT INTO indags_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lalu Yesus berpaling dan melihat perempuan itu. “Berbahagialah, sebab karena kamu percaya kepada-Ku, kamu menjadi sembuh,” kata Yesus kepadanya. Dan perempuan itu menjadi sembuh. ");
INSERT INTO indags_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lalu tibalah Yesus di rumah pemimpin itu. Yesus melihat para pemain suling dan orang-orang banyak yang menangis dengan suara keras. ");
INSERT INTO indags_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Silahkan pergi,” kata-Nya kepada mereka, “Sebab anak gadis itu tidak mati, dia hanya tertidur saja.” Tetapi mereka menertawakan dan mengejek Dia. ");
INSERT INTO indags_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tetapi ketika rombongan itu sudah dikirim keluar dari rumah, Yesus masuk ke dalam dan memegang tangan anak itu, lalu anak itu pun bangun berdiri. ");
INSERT INTO indags_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Berita tentang apa yang sudah terjadi tersebar di seluruh wilayah itu. ");
INSERT INTO indags_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lalu Yesus melanjutkan perjalanan, dua orang buta mengikuti Dia, dan berteriak, “Hai anak Daud, kasihanilah kami!” ");
INSERT INTO indags_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dan ketika Yesus tiba di sebuah rumah, orang-orang buta itu juga ikut masuk. “Apakah kalian percaya Aku bisa menyembuhkan kalian?” Yesus bertanya kepada mereka. “Ya Tuhan, kami percaya,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kemudian Yesus menyentuh mata mereka, dan berkata, “Sebab kalian percaya kepada-Ku, maka terjadilah sesuai dengan yang kalian percayai!” ");
INSERT INTO indags_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Maka sembuhlah mata mereka dan mereka bisa melihat. Lalu Yesus memperingati mereka, “Pastikan tidak seorangpun tahu tentang mujizat ini.” ");
INSERT INTO indags_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tetapi mereka lalu pergi dan menceritakan berita tentang Yesus ke arah mana pun mereka pergi. ");
INSERT INTO indags_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ketika Yesus dan murid-murid-Nya hendak berangkat dari tempat itu, seorang yang bisu dan dirasuki setan dibawa kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Namun sesudah setan itu diusir dari orang itu, maka orang bisu itu mulai berkata-kata, dan orang banyak sangat takjub. “Belum pernah hal ini terjadi di Israel sebelumnya,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tetapi orang-orang Farisi berkata, “Dia mengusir setan dengan menggunakan kuasa pemimpin setan.” ");
INSERT INTO indags_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus pergi mengelilingi daerah itu, mengunjungi kota-kota kecil dan desa-desa. Dia mengajar di tempat-tempat ibadah mereka, memberitakan kabar baik tentang Kerajaan Allah, dan menyembuhkan segala jenis penyakit. ");
INSERT INTO indags_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ketika Yesus melihat orang-orang banyak itu, Dia sangat dipenuhi oleh belas kasihan kepada mereka, sebab mereka penuh dengan kesulitan dan tidak berdaya, seperti domba-domba yang tidak memiliki seorang gembala. ");
INSERT INTO indags_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Maka kata-Nya kepada murid-murid-Nya, “Tuaian sangat banyak tetapi penuainya pekerja sedikit. ");
INSERT INTO indags_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Berdoa kepada Tuhan dari tuaian, dan mintalah agar Dia mengirimkan lebih banyak pekerja untuk tuaian-Nya.” ");
INSERT INTO indags_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus mengumpulkan dua belas muridnya dan memberi mereka kuasa untuk mengusir setan, dan menyembuhkan segala jenis penyakit. ");
INSERT INTO indags_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inilah nama kedua belas murid itu: pertama, Simon (yang juga dipanggil Petrus), Andreas saudaranya, Yakobus anak Zebedeus, dan Yohanes saudaranya, ");
INSERT INTO indags_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus, Bartolomeus, Tomas, Matius si tukang tagih pajak, Yakobus anak Alfeus, Tadeus, ");
INSERT INTO indags_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon yang pernah ikut gerakan revolusi, dan Yudas Iskariot, yang menghianati Yesus. ");
INSERT INTO indags_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus mengirim dua belas murid ini dan berkata kepada mereka, “Janganlah menemui orang-orang asing, ataupun ke kota-kota di daerah Samaria. ");
INSERT INTO indags_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kalian haruslah pergi kepada orang-orang Israel yang seperti domba-domba yang tersesat. ");
INSERT INTO indags_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dan kemanapun kalian pergi, beritakanlah hal ini, ‘Kerajaan Surga sudah dekat.’ ");
INSERT INTO indags_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sembuhkanlah orang-orang yang sakit. Hidupkanlah kembali mereka yang sudah mati. Pulihkanlah mereka yang sakit kusta. Usirlah roh-roh jahat. Kalian mendapatkannya dengan cuma-cuma, berikanlah juga secara cuma-cuma. ");
INSERT INTO indags_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Janganlah membawa uang emas, perak ataupun tembaga di kantong kalian, ");
INSERT INTO indags_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ataupun sebuah tas selama perjalanan kalian, atau dua jubah, sandal atau tongkat jalan, sebab seorang pekerja wajib untuk mendapat dukungan. ");
INSERT INTO indags_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kemanapun kalian pergi, baik ke kota kecil ataupun desa, mintalah seseorang yang dikenal baik cara hidupnya, dan tinggallah di sana sampai tiba waktunya kalian melanjutkan perjalanan. ");
INSERT INTO indags_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dan ketika kalian masuk satu rumah, berkatilah rumah itu. ");
INSERT INTO indags_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jika rumah itu layak mendapatkannya, maka damai yang kalian berikan akan diterima oleh rumah itu, tetapi jika rumah itu tidak layak, maka damai yang kamu berikan akan kembali lagi kepadamu. ");
INSERT INTO indags_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jika seseorang tidak menyambut kalian, dan menolak mendengarkan apa yang harus kalian katakan, maka tinggalkanlah rumah atau kota itu, dan kebaskanlah debu dari kalian ketika kalian berangkat. ");
INSERT INTO indags_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aku beritahu kalian sejujurnya, kondisi kota Sodom dan Gomora akan lebih baik pada hari Penghakiman dari pada kota itu! ");
INSERT INTO indags_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Dengar, Aku mengutus kalian seperti domba-domba di antara serigala-serigala. Jadi biarlah kalian cerdik seperti ular dan juga tulus seperti burung merpati. ");
INSERT INTO indags_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Waspadalah pada mereka yang akan menyerahkan kalian untuk diadili di pengadilan kota dan akan memberikan hukuman cambuk di tempat-tempat ibadah mereka. ");
INSERT INTO indags_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kalian akan diseret ke hadapan gubernur dan raja-raja oleh karena Aku, untuk bersaksi kepada mereka dan kepada orang-orang asing. ");
INSERT INTO indags_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tetapi ketika mereka menghadapkan kalian di pengadilan, janganlah kuatir apa yang harus kalian ucapkan, sebab kalian akan tahu apa yang harus kalian katakan tepat pada waktunya. ");
INSERT INTO indags_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sebab bukan kalian yang akan berbicara, tetapi roh yang dikirim oleh Bapa yang akan berbicara melalui kalian. ");
INSERT INTO indags_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sesama saudara akan saling mengkhianati dan membunuh, demikian juga seorang ayah kepada anaknya. Anak-anak akan memberontak kepada orang tuanya, dan akan membuat mereka dihukum mati. ");
INSERT INTO indags_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Setiap orang akan membenci kalian sebab kalian menjadi pengikut Aku, tetapi mereka yang mau setia sampai akhir akan diselamatkan. ");
INSERT INTO indags_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ketika kalian dianiaya di salah satu kota, larilah ke kota berikutnya. Aku katakan sejujurnya kepada kalian, kalian tidak akan selesai mengunjungi seluruh kota di Israel sebelum Anak Manusia datang. ");
INSERT INTO indags_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Murid tidaklah lebih penting daripada gurunya, dan hamba tidaklah lebih penting dari tuan mereka. ");
INSERT INTO indags_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Murid haruslah puas jika bisa sama seperti gurunya, dan hamba sama seperti tuan mereka. Jika kepala rumah disebut Beelzebul, apalagi seisi rumahnya! ");
INSERT INTO indags_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Maka janganlah takut kepada mereka, sebab tidak ada satupun yang ditutupi yang tidak akan dibuka, dan yang tersembunyi yang tidak akan disingkapkan. ");
INSERT INTO indags_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apa yang Aku katakan secara rahasia kepada kalian, beritakanlah itu dengan terang-terangan, dan yang kalian dengar dengan bisikan di telinga kalian, teriakanlah dari atap rumah. ");
INSERT INTO indags_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jangan takut pada mereka yang bisa membunuhmu secara fisik, tetapi tidak bisa membunuhmu secara spiritual. Sebaliknya, takutlah pada orang yang dapat menghancurkan kamu secara fisik dan spiritual di Gehena. ");
INSERT INTO indags_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bukankah sepasang burung pipit bisa dibeli dengan mata uang yang terkecil? Tetapi tidak satu ekorpun dari mereka akan jatuh ke tanah tanpa Bapa kalian tahu tentang itu. ");
INSERT INTO indags_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bahkan sehelai rambut di kepala kalian pun sudah terhitung jumlahnya. ");
INSERT INTO indags_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jadi janganlah kuatir sebab kalian semua lebih berharga dari pada burung-burung pipit yang besar jumlahnya! ");
INSERT INTO indags_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Siapapun yang dengan terus terang mengakui bahwa mereka adalah murid-Ku, maka Aku juga akan mengakui mereka di hadapan Bapa-Ku yang di surga. ");
INSERT INTO indags_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tetapi siapapun juga yang dengan terus terang menyangkal mengenal Aku, maka Aku juga akan menyangkal mengenal dia di hadapan Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jangan berpikir bahwa Aku datang untuk membawa kedamaian di bumi. Aku tidak datang untuk membawa kedamaian, melainkan perang. ");
INSERT INTO indags_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aku datang untuk ‘berbelok seorang anak laki-laki melawan ayahnya, seorang anak perempuan melawan ibunya, dan seorang menantu perempuan melawan ibu mertuanya. ");
INSERT INTO indags_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yang menjadi musuh-musuhmu adalah anggota keluargamu sendiri!’ ");
INSERT INTO indags_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jika kalian menyayangi ayah atau ibu kalian lebih daripada-Ku maka kalian tidak layak menjadi milik-Ku, dan jika kalian menyayangi anak laki-laki atau perempuan kalian lebih dari pada-Ku, maka kalian tidak layak menjadi milik-Ku. ");
INSERT INTO indags_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jika kalian tidak mau memikul salib kalian dan mengikut Aku, maka kalian tidak layak menjadi milik-Ku. ");
INSERT INTO indags_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jika kalian mencoba menyelamatkan nyawa kalian, kalian akan kehilangan nyawa kalian, tetapi jika kalian kehilangan nyawa kalian karena Aku, maka kalian akan mendapatkannya kembali. ");
INSERT INTO indags_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mereka yang menyambut kalian berarti orang itu juga menyambut Aku, dan orang yang menyambut Aku, menyambut Dia yang mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mereka yang menerima seorang nabi sebab dia seorang nabi, maka mereka akan menerima hadiah yang sama sebagai seorang nabi. Mereka yang menerima seseorang karena melakukan yang benar, maka mereka akan menerima hadiah yang sama dengan orang yang melakukan yang benar. ");
INSERT INTO indags_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aku katakan sejujurnya kepada kalian, siapapun yang memberikan segelas air minum kepada murid-Ku yang dianggap paling tidak penting, pasti akan menerima hadiahnya.” ");
INSERT INTO indags_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sesudah Yesus selesai memberikan pesan kepada kedua belas murid-Nya, Dia pergi dan mengajar serta memberitakan Firman Allah di kota-kota terdekat. ");
INSERT INTO indags_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sementara itu Yohanes yang sedang dipenjarakan mendengar tentang segala perbuatan yang dilakukan oleh Mesias, maka dia mengutus murid-muridnya menemui Yesus ");
INSERT INTO indags_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","dan bertanya mewakili dia, “Apakah Engkau orang yang kami tunggu-tunggu kedatangannya, atau haruskah kami terus mencari orang lain?” ");
INSERT INTO indags_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jawab Yesus kepada mereka, “Kembalilah dan ceritakanlah kepada Yohanes apa yang sudah kalian dengar dan yang sudah kalian lihat. ");
INSERT INTO indags_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Orang buta disembuhkan sehingga bisa melihat, orang lumpuh sekarang bisa berjalan lagi, orang yang menderita sakit kusta disembuhkan, yang tuli bisa mendengar kembali, yang sudah mati dibangkitkan, dan orang-orang yang miskin mendengarkan berita baik. ");
INSERT INTO indags_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Diberkatilah mereka yang tidak menolak Aku!” ");
INSERT INTO indags_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sesudah mereka pergi, Yesus mulai berbicara kepada orang banyak itu tentang Yohanes. “Apa yang kalian pikir akan kalian temui ketika pergi ke padang gurun? Alang-alang yang sedang ditiup angin? ");
INSERT INTO indags_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jadi kalian pergi untuk melihat apa? Orang yang berpakaian indah dan mewah? Orang-orang yang berpakaian seperti itu hidupnya di istana-istana raja-raja. ");
INSERT INTO indags_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jadi kalian pergi untuk melihat apa? Seorang nabi? Benar, dan Aku katakan pada kalian, dia lebih dari sekedar seorang nabi! ");
INSERT INTO indags_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Dialah yang dikatakan oleh Kitab Suci tentang: ‘Aku mengutus seorang pembawa pesan sebelum kamu. Dialah yang akan membukakan jalan bagimu.’ ");
INSERT INTO indags_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aku katakan sejujurnya kepada kalian, bahwa di antara seluruh umat manusia tidak ada yang lebih besar dari pada Yohanes Pembaptis, tetapi bahkan yang paling tidak penting dalam Kerajaan Surga lebih besar dari pada dia. ");
INSERT INTO indags_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sejak masa Yohanes Pembaptis mulai melayani sampai saat ini, Kerajaan Allah terus menerus diserang dan orang-orang berusaha menguasinya dengan paksa. ");
INSERT INTO indags_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sebab semua pesan-pesan yang tertulis di Kitab Hukum Taurat dan Para nabi hanya bernubuat sampai masa Yohanes Pembaptis tiba. ");
INSERT INTO indags_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jika kalian mau percaya hal ini, Yohanes adalah orang yang dikatakan sebagai ganti Elia, orang yang dinanti-nantikan akan datang. ");
INSERT INTO indags_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Setiap orang yang punya telinga dengarkanlah! ");
INSERT INTO indags_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Dengan apakah bisa Aku bandingkan generasi ini? Mereka sama seperti anak-anak yang duduk pasar sambil berteriak satu dengan yang lainnya, ");
INSERT INTO indags_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kami bermain suling untuk kalian, tetapi kalian tidak menari, kami menyanyikan lagi sedih, tetapi kalian tidak menangis.’ ");
INSERT INTO indags_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohanes Pembaptis tidak datang untuk makan-makan dan minum, maka orang berkata, ‘Dia dirasuki oleh setan!’ ");
INSERT INTO indags_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sebaliknya, Anak Manusia datang dan ikut makan dan minum, tetapi orang-orang berkata, ‘Coba lihat, Dia orang yang rakus dan terlalu banyak minum, Dia juga seorang teman dari penagih pajak dan orang-orang berdosa!’ Tetapi kebijaksanaan terbukti benar melalui hasil-hasilnya.” ");
INSERT INTO indags_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lalu Yesus mulai menegur kota-kota di mana Dia melakukan paling banyak mujizat karena mereka tidak bertobat. ");
INSERT INTO indags_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Sungguh tidak tahu malu kalian, orang-orang Korazin! Sungguh tidak tahu malu kalian, orang-orang Betsaida! Sebab jika perbuatan-perbuatan ajaib yang terjadi di antara kalian terjadi di Tirus dan Sidon, mereka pasti sudah bertobat dengan berkabung dan meratap sejak lama. ");
INSERT INTO indags_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tetapi saya memberitahu kalian bahwa pada Hari Penghakiman itu akan lebih baik bagi Tirus dan Sidon daripada bagi kalian! ");
INSERT INTO indags_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sedangkan kalian, penduduk Kapernaum! Kalian pikir kalian akan diangkat ke surga? Tidak, kalian akan pergi ke Hades! Sebab jika perbuatan-perbuatan ajaib yang sudah kalian alami dialami di Sodom, kota itu masih akan berdiri sampai hari ini. ");
INSERT INTO indags_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tetapi saya katakan kepada kalian bahwa pada Hari Pembalasan akan lebih baik bagi Sodom daripada bagi kalian!” ");
INSERT INTO indags_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kemudian Yesus berdoa, “Aku memuji Engkau, Bapa, Tuhan penguasa bumi dan surga, sebab Engkau sudah merahasiakan berita tentang Kerajaan-Mu kepada orang-orang yang berpikir dirinya cerdas dan penuh pengetahuan. Sebaliknya, Engkau nyatakan berita ini kepada orang-orang yang biasa. ");
INSERT INTO indags_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Benar, Bapa, itulah yang menyenangkan Engkau! ");
INSERT INTO indags_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Segala sesuatu sudah diserahkan kepada-Ku oleh Bapa-Ku, dan tidak seorangpun benar-benar mengerti sang Anak, selain Bapa, dan tidak seorangpun benar-benar mengerti Bapa, selain sang Anak, dan mereka kepada siapa Putra memilih untuk mengungkapkan Dia. ");
INSERT INTO indags_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Marilah kepada-Ku, kalian yang merasa penuh pergumulan dan yang sangat terbeban. Aku akan memberi ketenangan kepada kalian. ");
INSERT INTO indags_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Terimalah pekerjaan yang Aku berikan, dan belajarlah dari-Ku. Sebab Aku ini lemah lembut dan rendah hati, dan di dalam-Ku kalian akan menemukan ketenangan yang kalian butuhkan. ");
INSERT INTO indags_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sebab pekerjaan yang Aku berikan mudah, dan beban yang Aku berikanpun ringan.” ");
INSERT INTO indags_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pada suatu hari Sabat, Yesus berjalan melintasi ladang gandum. Murid-murid Yesus merasa lapar dan mereka mulai memetik bulir gandum dan memakannya. ");
INSERT INTO indags_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ketika orang-orang Farisi melihat ini, mereka berkata kepada Yesus, “Lihatlah murid-murid-Mu — mereka melakukan hal yang dilarang dilakukan di hari Sabat!” ");
INSERT INTO indags_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tetapi kata Yesus kepada mereka, “Belum pernahkan kalian baca tentang apa yang dilakukan Daud ketika dia dan pasukannya merasa lapar? ");
INSERT INTO indags_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daud pergi menghadap ke Rumah Allah, dan dia beserta pasukannya makan roti kudus yang seharusnya tidak boleh mereka makan, sebab roti itu dikhususkan untuk para imam. ");
INSERT INTO indags_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Belum pernahkah kalian baca di dalam hukum Taurat bahwa pada hari Sabat para imam di Rumah Allah melanggar ketentuan hari Sabat, tetapi dinyatakan tidak bersalah? ");
INSERT INTO indags_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tetapi Aku beritahu kalian bahwa seseorang yang ada disini lebih besar dari pada rumah Tuhan! ");
INSERT INTO indags_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jika kalian mengerti arti ayat ini, ‘Aku menghendaki belas kasihan dan bukan persembahan,’ kalian tidak akan menuduh seseorang yang tidak bersalah. ");
INSERT INTO indags_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sebab Anak Manusia adalah Tuhan atas hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lalu Yesus pergi dan mengajar di rumah-rumah ibadat mereka. ");
INSERT INTO indags_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Di sana ada seorang yang cacat tangannya. “Apakah hukum mengijinkan orang disembuhkan pada hari Sabat?” tanya mereka, sebagai alasan untuk menuduh Dia. ");
INSERT INTO indags_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","“Jika kalian punya seekor domba dan domba itu jatuh ke dalam lubang pada hari Sabat, tidakkah kalian akan menariknya keluar?” Yesus menjawab pertanyaan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Tidakkah menurut kalian seorang manusia jauh lebih berharga daripada seekor domba? Jadi ya, kalian boleh berbuat baik pada hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lalu berkatalah Yesus kepada orang cacat itu, “Luruskanlah tanganmu.” Maka orang itu mengulurkan tangannya, dan tangan itu sembuh, sama sehatnya dengan tangan yang satunya. ");
INSERT INTO indags_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tetapi orang-orang Farisi lalu keluar dan membuat rencana untuk membunuh Yesus. ");
INSERT INTO indags_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ketika mengetahui hal ini, Yesus pergi dengan diikuti oleh orang banyak. Yesus menyembuhkan mereka semua, ");
INSERT INTO indags_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","tetapi Yesus minta mereka untuk tidak mengatakan kepada siapapun tentang diri-Nya. ");
INSERT INTO indags_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hal ini menggenapi yang sudah dinubuatkan oleh Nabi Yesaya: ");
INSERT INTO indags_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Inilah hamba pilihan-Ku, yang Aku kasihi dan kepada siapa Aku berkenan. Aku akan menaruh roh-Ku ke atas-Nya, dan Dia akan mengajarkan orang-orang asing apa yang benar. ");
INSERT INTO indags_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dia tidak akan berdebat, dia tidak akan berteriak, dan tidak seorangpun yang akan mendengarkan suara-Nya di jalan-jalan. ");
INSERT INTO indags_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dia tidak akan mematahkan mereka yang lemah, ataupun memadamkan harapan yang paling tipis sekalipun, sampai Dia sudah membuktikan bahwa penghakiman yang Dia lakukan adalah benar, ");
INSERT INTO indags_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dan orang-orang asing akan menaruh harapan mereka kepada-Nya.” ");
INSERT INTO indags_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ketika Yesus dan murid-murid-Nya hendak berangkat, seorang laki-laki yang buta, bisu dan dirasuki setan dibawa ke hadapan-Nya. Yesus menyembuhkan dia, sehingga laki-laki itu bisa kembali berbicara dan melihat. ");
INSERT INTO indags_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rombongan orang itu menjadi takjub, dan berkata, “Mungkinkah ini benar-benar putra Daud?” ");
INSERT INTO indags_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tetapi ketika orang-orang Farisi mendengar hal ini, mereka berkata, “Orang ini hanya bisa mengusir setan dengan kuasa Beelzebul, si pemimpin setan!” ");
INSERT INTO indags_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus mengenal cara berpikir mereka, karena itu Yesus berkata, “Setiap kerajaan yang terbagi-bagi akan mudah dihancurkan. Tidak ada satu kota atau rumah tangga pun yang terbagi bisa bertahan. ");
INSERT INTO indags_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jika setan mengusir setan, maka dia sedang melawan dirinya sendiri, jika demikian, bagaimana bisa kerajaannya akan bertahan? ");
INSERT INTO indags_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jika Aku mengusir setan keluar dengan kuasa Beelzebul, dengan kuasa siapa kalian mengusir setan? Kalian sendiri yang membuktikan bahwa kalian salah! ");
INSERT INTO indags_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tetapi jika Aku mengusir setan dengan kuasa Roh Allah, maka sesungguhnya Kerajaan Allah sudah datang kepadamu! ");
INSERT INTO indags_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bisakah kalian masuk ke rumah seorang yang sangat kuat dan mengambil harta bendanya tanpa mengikat dia terlebih dulu? Hanya dengan mengikatnya lebih dahulu, kalian baru bisa mengambil barang-barangnya. ");
INSERT INTO indags_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mereka yang tidak berpihak kepada-Ku artinya mereka adalah lawan-Ku, dan mereka yang tidak bersama-Ku akan melakukan hal yang berlawanan: mereka akan mencerai-beraikan. ");
INSERT INTO indags_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Itu sebabnya Aku katakan kepada kalian, yaitu setiap dosa dan hujat yang kalian katakan akan diampuni, tetapi hujat melawan Roh Kudus tidak akan diampuni. ");
INSERT INTO indags_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Setiap perkataan yang melawan Anak Manusia akan diampuni, tetapi setiap perkataan yang menentang Roh Kudus tidak akan diampuni, baik di kehidupan dalam dunia ini, maupun di kehidupan berikutnya. ");
INSERT INTO indags_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kita bisa memutuskan sebuah pohon itu baik atau buruk adalah dengan melihat kepada buah yang dihasilkannya. ");
INSERT INTO indags_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hai kalian keturunan ular berbisa, bagaimana bisa kalian yang jahat mengucapkan kata-kata yang baik? Sebab mulutmu hanya akan mengatakan apa yang ada di dalam pikiranmu. ");
INSERT INTO indags_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Orang yang baik mengeluarkan yang baik dari simpanannya yang baik, dan orang yang jahat mengeluarkan yang jahat dari simpanannya yang jahat. ");
INSERT INTO indags_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aku katakan kepada kalian, setiap orang pasti akan mempertanggungjawabkan setiap perkataan sia-sia yang dia ucapkan di hari Penghakiman nanti. ");
INSERT INTO indags_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sebab apa yang kalian ucapkan akan membenarkan atau menghukum kalian.” ");
INSERT INTO indags_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lalu datanglah beberapa guru agama dan orang-orang Farisi kepada-Nya dan berkata, “Guru, berilah suatu tanda mujizat kepada kami.” ");
INSERT INTO indags_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Orang-orang jahat yang tidak percaya kepada Allah ini meminta sebuah tanda mujizat. Tetapi satu-satunya tanda mujizat yang akan mereka terima adalah tanda dari nabi Yunus,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Sama seperti Yunus ada di dalam perut ikan selama tiga hari dan tiga malam, demikianlah Anak Manusia akan diam di dalam bumi selama tiga hari dan tiga malam. ");
INSERT INTO indags_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Orang-orang dari kota Niniwe akan bangkit di hari penghakiman bersama-sama dengan generasi ini dan mereka akan menjadi pendakwa bagi generasi ini sebab mereka bertobat sebagai reaksi mereka atas pesan yang disampaikan oleh Yunus — dan seperti yang kalian lihat, di sini ada seseorang yang lebih luar biasa dibandingkan dengan Yunus! ");
INSERT INTO indags_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ratu dari daerah Selatan akan bangkit di hari Penghakiman bersama dengan generasi ini dan dia akan mendakwa mereka, sebab dia datang dari ujung bumi untuk mendengarkan kebijaksanaan Salomo — sementara di sini ada orang yang lebih bijak daripada Salomo! ");
INSERT INTO indags_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ketika roh jahat meninggalkan seseorang, ia mengembara melalui tempat-tempat sepi mencari istirahat, dan tidak menemukan tempat tinggal. ");
INSERT INTO indags_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Maka katanya, ‘Aku akan kembali ke tempat yang dulu saya tinggalkan,’ dan ketika roh itu kembali, ditemukannya tempat itu kosong, bersih dan rapi. ");
INSERT INTO indags_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Maka pergilah dia dan membawa kembali tujuh roh lain yang bahkan lebih jahat dari pada dirinya, dan roh itu masuk dan menetap di dalam tempat itu. Jadi orang itu berakhir lebih buruk daripada mereka di awal. Begitulah yang akan terjadi dengan generasi jahat ini.” ");
INSERT INTO indags_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sementara Yesus berbicara dengan orang banyak, ibu-Nya dan saudara-saudara-Nya tiba dan berdiri di bagian luar, ingin berbicara dengan Dia. ");
INSERT INTO indags_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Seseorang datang dan berkata kepada-Nya, “Dengar, ibu dan saudara-saudara-Mu sedang di luar, mereka ingin berbicara dengan-Mu.” ");
INSERT INTO indags_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","“Siapa yang kamu sebut ibu-Ku? Siapa yang kamu katakan saudara-saudara-Ku?” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lalu Dia menunjuk murid-murid-Nya dan berkata, “Merekalah ibu dan saudara-saudara-Ku! ");
INSERT INTO indags_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sebab mereka yang melakukan kehendak Bapa-Ku yang di surga, itulah yang Aku sebut sebagai saudara-Ku laki-laki, saudara-Ku perempuan dan ibu-Ku!” ");
INSERT INTO indags_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pada hari itu juga, Yesus meninggalkan rumah itu, dan duduk untuk mengajar di tepi danau. ");
INSERT INTO indags_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Banyak orang yang berkumpul di sekeliling Dia sehingga Yesus harus naik ke dalam perahu dan duduk di sana untuk mengajar, sementara orang banyak berdiri di pantai. ");
INSERT INTO indags_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesus menjelaskan banyak hal kepada mereka dengan menggunakan cerita sebagai ilustrasi. “Seorang petani pergi ke ladangnya untuk menabur,” kata Yesus, ");
INSERT INTO indags_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Ketika dia menabur, beberapa biji benih jatuh di jalan. Lalu datanglah burung-burung dan memakan benih-benih itu. ");
INSERT INTO indags_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Beberapa biji benih lainnya jatuh ke atas tanah yang berbatu di mana tanahnya tipis sehingga benih-benih itu dengan cepat bertumbuh. ");
INSERT INTO indags_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lalu matahari bersinar terik dan membakar mereka sehingga mereka menjadi layu, sebab mereka tidak memiliki akar. ");
INSERT INTO indags_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Benih-benih lainnya jatuh ke semak berduri yang kemudian tumbuh dan memadati mereka. ");
INSERT INTO indags_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Namun ada benih-benih yang tumbuh di tanah yang subur. Mereka menghasilkan buah — ada yang 100, ada yang 60, dan ada yang 30 kali lipat dari yang sudah ditanam. ");
INSERT INTO indags_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Siapa pun yang punya telinga, haruslah memperhatikan!” ");
INSERT INTO indags_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Para murid datang kepada Yesus dan bertanya, “Mengapa Engkau menggunakan cerita ketika berbicara kepada orang-orang?” ");
INSERT INTO indags_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","“Kepada kalian diberikan hak istimewa untuk mengerti misteri kerajaan surga, tetapi kepada mereka tidak diberikan pengertian itu,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Mereka yang sudah memiliki pengertian akan kerajaan Allah akan mendapatkan pengertian yang lebih lagi. Tetapi mereka yang tidak memiliki pengertian itu, bahkan pengertian yang ada pada mereka tentang kerajaan Allah, akan diambil dari mereka. ");
INSERT INTO indags_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Itu sebabnya Aku berbicara kepada mereka dengan memakai cerita. Sebab sekalipun mereka memiliki penglihatan, mereka tidak melihat, dan sekalipun mereka memiliki pendengaran, mereka tidak mendengar ataupun mereka mengerti. ");
INSERT INTO indags_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nubuatan nabi Yesaya digenapi dalam diri mereka, ‘Sekalipun kamu mendengar, tetapi kamu tidak akan mengerti, dan sekalipun kamu melihat, kamu tidak akan memahami. ");
INSERT INTO indags_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mereka sudah begitu keras kepala, sehingga tidak mau mendengar, dan sudah menutup mata mereka. Jika mereka tidak keras kepala, maka mereka mungkin dapat melihat dengan mata jasmani mereka, mendengar dengan telinga mereka, dan memahami dalam pikiran mereka, dan mereka akan bertobat dan berbalik, dan Aku akan menyembuhkan mereka.’ ");
INSERT INTO indags_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kalian diberkati karena mata kalian bisa melihat dan telinga kalian bisa mendengar. ");
INSERT INTO indags_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aku katakan kepada kalian, banyak nabi-nabi dan orang-orang yang baik ingin melihat apa yang mata kalian lihat sekarang ini, tetapi mereka tidak bisa melihatnya. Mereka rindu mendengar apa yang sedang kalian dengar sekarang ini, tetapi tidak bisa mendengarnya. ");
INSERT INTO indags_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Maka inilah arti dari cerita tentang si petani yang menabur itu. ");
INSERT INTO indags_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ketika orang-orang mendengar pesan tentang Kerajaan Allah dan tidak mengerti tentangnya, si jahat akan datang dan mencabut apa yang ditaburkan dalam mereka. Inilah artinya benih-benih yang jatuh di jalan. ");
INSERT INTO indags_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Benih-benih yang ditabur di tanah berbatu adalah orang-orang yang mendengar pesan tentang Kerajaan Allah dan dengan senang hati menerima pesan itu. ");
INSERT INTO indags_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Orang-orang itu bertahan beberapa saat, tetapi karena mereka tidak memiliki akar, maka ketika masalah dan kesulitan datang, dengan segera mereka murtad. ");
INSERT INTO indags_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Benih-benih yang jatuh di antara semak berduri adalah orang-orang yang mendengarkan perkataan firman, tetapi kemudian kekhawatiran hidup dan godaan uang mencekik pesan itu sehingga tidak menghasilkan buah. ");
INSERT INTO indags_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sedangkan benih-benih yang jatuh ke tanah yang subur adalah orang-orang yang mendengarkan firman itu, memahaminya, dan menghasilkan panen yang baik. Ada yang menghasilkan 100, 60 dan 30 kali lipat dari benih yang ditabur.” ");
INSERT INTO indags_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Lalu kepada mereka Yesus menceritakan kisah yang lain: “Kerajaan Allah seperti seorang petani yang menaburkan benih yang baik di ladangnya. ");
INSERT INTO indags_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tetapi sementara para pekerjanya tertidur, seorang musuh datang dan menaburkan benih rumput liar di atas benih gandum itu. Lalu mereka pergi. ");
INSERT INTO indags_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jadi ketika gandum itu tumbuh dan menghasilkan bulir-bulir gandum, rumput-rumput liar itu juga tumbuh. ");
INSERT INTO indags_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Para pekerja petani itu datang dan bertanya kepadanya, ‘Tuan, bukankah Tuan menabur benih yang bagus di ladang Tuan? Dari mana rumput-rumput liar ini datang?’ ");
INSERT INTO indags_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Pasti ada musuh yang melakukan hal ini,’ jawabnya. ‘Apa Tuan ingin agar kami mencabuti rumput-rumput itu?’ tanya para pekerjanya. ");
INSERT INTO indags_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Tidak,’ jawab petani itu, ‘sebab sewaktu kalian mencabuti rumput itu, bisa jadi gandum itu juga akan ikut tercabut. ");
INSERT INTO indags_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Biarkanlah mereka tumbuh bersama sampai musim panen nanti, dan ketika musim panen tiba, saya akan mengatakan kepada para penuai untuk mencabut rumput-rumput itu dan mengikat serta membakar mereka, baru kemudian mengumpulkan gandum-gandum itu dan menyimpannya di gudang saya.’” ");
INSERT INTO indags_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Lalu Yesus memberikan kisah yang lain: “Kerajaan Surga adalah seperti sebutir benih biji sesawi yang ditanam seorang petani di ladangnya. ");
INSERT INTO indags_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sekalipun biji itu adalah biji yang terkecil dari antara semua jenis biji-bijian, tetapi ketika biji itu tumbuh, dia lebih besar dari segala jenis pohon. Bahkan biji itu bisa tumbuh menjadi sebuah pohon yang cukup besar sehingga cabangnya bisa menjadi tempat bertengger bagi burung-burung.” ");
INSERT INTO indags_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus memberikan kisah yang lain: “Kerajaan Surga itu sama seperti ragi yang dicampurkan ke dalam sejumlah besar tepung oleh seorang perempuan sampai seluruh adonan mengembang.” ");
INSERT INTO indags_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus menerangkan semua ini kepada orang banyak menggunakan berbagai macam kisah — bahkan tidak pernah dia berbicara kepada orang banyak tanpa menggunakan kisah sebagai cara mengajar mereka. ");
INSERT INTO indags_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hal ini menggenapi apa yang dikatakan oleh nubuatan para nabi: “Aku akan mengajar dengan menggunakan kisah-kisah, dan Aku akan menjelaskan pengajaran-pengajaran yang tersembunyi sejak dari dunia ini diciptakan.” ");
INSERT INTO indags_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kemudian Yesus meninggalkan keramaian dan masuk ke sebuah rumah. Murid-muridnya datang kepada-Nya dan berkata, “Tolong jelaskan kepada kami arti dari kisah-kisah tentang rumput-rumput liar yang ada di padang.” ");
INSERT INTO indags_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","“Orang yang menabur benih yang baik adalah Anak Manusia,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Sementara ladang adalah orang-orang di dunia ini. Benih-benih yang baik adalah anak-anak Kerajaan Surga. Benih rumput liar adalah anak-anak kejahatan. ");
INSERT INTO indags_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Musuh yang menabur benih rumput itu adalah si Iblis. Waktu panen adalah ketika dunia ini berakhir. Dan para penuai adalah para malaikat. ");
INSERT INTO indags_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sama seperti rumput-rumput liar itu dipanen dan dibakar, demikian juga yang akan terjadi ketika dunia ini berakhir. ");
INSERT INTO indags_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anak Manusia akan mengirim para malaikatnya, dan mereka akan mengumpulkan setiap perbuatan-perbuatan yang jahat dan para pelakunya, ");
INSERT INTO indags_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","dan akan melemparkan mereka ke dalam tungku menyala, di mana akan terdengar ratapan dan suara gemeletuk gigi. ");
INSERT INTO indags_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kemudian mereka yang selama hidupnya melakukan perbuatan-perbuatan yang benar akan bersinar seperti matahari di kerajaan Bapa mereka. Biarlah mereka yang punya telinga, memperhatikan! ");
INSERT INTO indags_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kerajaan Surga sama seperti harta yang tersembunyi di sebuah ladang. Seseorang menemukannya, menguburnya kembali, lalu dengan penuh sukacita pergi dan menjual semua miliknya untuk membeli ladang itu. ");
INSERT INTO indags_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kerajaan Surga juga sama seperti seorang pedagang yang mencari butiran mutiara yang berharga. ");
INSERT INTO indags_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ketika dia menemukan sebutir mutiara yang sangat mahal, maka pergilah dia dan menjual semua miliknya. ");
INSERT INTO indags_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Satu hal lagi, Kerajaan Surga sama seperti sebuah jala ikan yang ditebarkan ke lautan untuk menangkap semua jenis ikan. ");
INSERT INTO indags_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ketika jala itu sudah penuh, jaring ditariklah ke arah pantai. Ikan-ikan yang bagus diletakkan ke dalam keranjang sementara yang buruk dibuang. ");
INSERT INTO indags_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Demikianlah semua ini akan terjadi ketika dunia sudah mencapai akhir masanya. Para malaikat akan datang dan memisahkan mereka yang suka melakukan perbuatan-perbuatan jahat dengan mereka yang suka melakukan perbuatan-perbuatan baik, ");
INSERT INTO indags_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","dan melemparkan para pelaku kejahatan itu ke dalam tungku menyala di mana akan terdengar ratapan dan gemeletuk gigi. ");
INSERT INTO indags_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Apakah kalian mengerti arti semua ini sekarang?” “Ya, Guru,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Setiap pengajar-pengajar agama yang mempelajari tentang Kerajaan Surga adalah seperti seorang pemilik rumah yang mengeluarkan dari ruang simpanannya semua harta miliknya, baik yang baru maupun yang lama,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sesudah Yesus selesai mengajarkan hal-hal ini melalui kisah-kisah, maka Yesus pergi. ");
INSERT INTO indags_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yesus kembali ke Nazaret, kota asalnya, dan mengajar di rumah-rumah ibadat di sana. Orang-orang sangat takjub, dan berkata, “Dari mana Dia mendapatkan kebijaksanaan dan kuasa untuk melakukan segala perbuatan ajaib ini? ");
INSERT INTO indags_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bukankah Dia anak si tukang kayu? Bukankah Maria adalah ibu-Nya, dan saudara-saudara-Nya adalah Yakobus, Yusuf, Simon dan Yudas? ");
INSERT INTO indags_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bukankah saudara-saudara perempuannya juga disini bersama-sama dengan kita? Jadi dari mana Dia mendapatkan semua ini?” ");
INSERT INTO indags_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jadi mereka menolak untuk percaya kepada-Nya. “Seorang nabi dihormati di mana saja kecuali di kota asalnya dan dalam keluarganya,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Karena mereka tidak bisa percaya kepada-Nya, maka Yesus tidak banyak melakukan perbuatan-perbuatan ajaib disitu. ");
INSERT INTO indags_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pada waktu itu, Herodes, penguasa daerah Galilea mendengar tentang perbuatan-perbuatan Yesus ");
INSERT INTO indags_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","dan berkata kepada para pelayannya, “Dia itu pasti Yohanes Pembaptis yang bangkit dari kematian, dan itulah sebabnya Dia begitu berkuasa!” ");
INSERT INTO indags_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes sudah menahan Yohanes, merantainya dan memasukkan dia ke dalam penjara oleh karena Herodia, istri Filipus, saudara Herodes. ");
INSERT INTO indags_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sebab Yohanes berkata kepadanya, “Tidak sah bagimu untuk menikah dengannya.” ");
INSERT INTO indags_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes sesungguhnya ingin membunuh Yohanes, tetapi dia takut kepada reaksi rakyat sebab rakyat menganggap Yohanes seorang nabi. ");
INSERT INTO indags_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Namun, Herodes merasa senang sekali ketika putri Herodias menari di pesta ulang tahunnya. ");
INSERT INTO indags_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Maka Herodes bersumpah untuk memberikan kepada anak perempuan itu apapun permintaannya. ");
INSERT INTO indags_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Didesak oleh ibunya, anak itu berkata, “Berikanlah kepadaku kepala Yohanes Pembaptis di atas sebuah nampan.” ");
INSERT INTO indags_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Menyesallah Herodes dengan janji yang sudah diucapkannya, tetapi karena sumpah yang dia ucapkan di hadapan para tamunya, maka diperintahkanlah agar Yohanes dibunuh dan kepalanya dipancung. ");
INSERT INTO indags_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Perintah itu dilaksanakan dan Yohanes Pembaptis dipancung di dalam penjara. ");
INSERT INTO indags_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dan kepalanya diletakkan di atas nampan dan diberikan kepada anak perempuan itu yang langsung membawanya kepada ibunya. ");
INSERT INTO indags_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Murid-murid Yohanes datang dan mengambil tubuhnya serta menguburkan dia. Lalu mereka pergi kepada Yesus dan memberitahukan apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ketika Yesus mendengar kabar itu, pergilah Dia ke suatu tempat yang sunyi dengan memakai perahu, tetapi ketika orang banyak mengetahui tempat yang dituju oleh Yesus, mereka mengikuti Dia dengan berjalan kaki dari kota-kota kecil. ");
INSERT INTO indags_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ketika Yesus turun dari perahu dan melihat kumpulan orang itu, maka Yesus merasa kasihan dengan mereka, dan menyembuhkan banyak yang sakit dari antara mereka. ");
INSERT INTO indags_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ketika hari sudah menjelang malam, datanglah murid-murid-Nya dan berkata, “Tempat ini sangat jauh dari manapun, dan sudah mulai malam. Mintalah agar orang-orang ini pergi ke desa-desa, sehingga mereka bisa membeli makanan untuk diri mereka.” ");
INSERT INTO indags_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tetapi jawab Yesus kepada murid-murid-Nya, “Mereka tidak perlu pergi. Kalianlah yang harus memberi mereka makan!” ");
INSERT INTO indags_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Kami hanya punya lima potong roti dan dua ekor ikan,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Berikanlah mereka kepada-Ku,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lalu Dia meminta agar orang banyak itu duduk di atas rumput. Dan kemudian diambil-Nya lima roti dan dua ekor ikan itu, menengadahkan kepala-Nya ke langit dan memberkati makanan itu. Sesudah itu Yesus membelah-belah roti into menjadi potongan-potongan kecil dan memberikannya kepada para murid-Nya, dan murid-murid-Nya memberikan potongan itu kepada orang banyak. ");
INSERT INTO indags_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Setiap orang makan sampai kenyang. Lalu para murid-Nya mengumpulkan sisa makanan itu yang jumlahnya sampai dua belas keranjang. ");
INSERT INTO indags_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yang ikut makan jumlahnya 5.000 laki-laki, belum terhitung wanita dan anak-anak. ");
INSERT INTO indags_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Segera sesudah mereka makan, Yesus menyuruh murid-murid-Nya naik ke dalam perahu dan menyeberangi danau sementara Dia menyuruh orang banyak itu pulang. ");
INSERT INTO indags_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Sesudah itu, naiklah Yesus seorang diri ke atas bukit untuk berdoa. Saat itu sudah malam, dan Yesus berdoa seorang diri. ");
INSERT INTO indags_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sementara itu perahu yang ditumpangi oleh murid-murid-Nya sudah jauh dari daratan, sedang diombang ambingkan oleh ombak sebab angin sedang bertiup kencang. ");
INSERT INTO indags_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sekitar pukul 3 pagi, Yesus menyusul mereka, berjalan di atas laut. ");
INSERT INTO indags_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ketika para murid-Nya melihat Dia berjalan di atas laut, mereka menjadi ketakutan. Berteriaklah mereka, “Itu hantu!” ");
INSERT INTO indags_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tetapi dengan segera Yesus menjawab mereka, “Ini Aku, jangan kuatir! Jangan takut!” ");
INSERT INTO indags_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","“Tuhan, jika itu benar-benar diri-Mu, biarlah saya datang kepada-Mu, berjalan di atas air,” jawab Petrus. ");
INSERT INTO indags_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Mari sini jika demikian,” kata Yesus, dan Petrus keluar dari dalam perahu dan berjalan di atas air menuju Yesus. ");
INSERT INTO indags_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tetapi ketika dia menyadari betapa kuatnya angin itu, dia menjadi takut, dan mulai tenggelam, “Tuhan! Tolong aku!” Petrus berseru. ");
INSERT INTO indags_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dengan segera Yesus mengulurkan tangan-Nya dan memegang Petrus, dan berkata, “Kamu memiliki sedikit kepercayaan pada saya. Mengapa kamu ragu?” ");
INSERT INTO indags_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ketika mereka masuk ke dalam perahu, angin tiba-tiba menjadi tenang, ");
INSERT INTO indags_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","dan mereka yang ada di dalam perahu menyembah Dia, dan berkata, “Engkau ini benar-benar Anak Allah!” ");
INSERT INTO indags_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mereka tiba di pantai Genesaret sesudah menyeberangi danau. ");
INSERT INTO indags_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ketika orang banyak menyadari bahwa Yesus ada di sana, mereka mengabarkan berita ini ke seluruh daerah yang mereka kenal. Mereka membawa banyak orang sakit kepada-Nya, ");
INSERT INTO indags_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","dan memohon agar Dia mengijinkan orang-orang sakit itu menyentuh ujung jubah-Nya agar mereka sembuh. Setiap orang yang memegang ujung jubah-Nya menjadi sembuh. ");
INSERT INTO indags_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lalu beberapa orang Farisi dan guru-guru agama dari Yerusalem datang kepada Yesus dan bertanya, ");
INSERT INTO indags_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mengapa murid-murid-Mu melanggar tradisi dari nenek moyang kita dengan tidak mencuci tangan mereka sebelum makan?” ");
INSERT INTO indags_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“Lalu mengapa kalian melanggar perintah Allah karena tradisi nenek moyang kita?” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Sebab Allah berfirman, ‘Hormatilah ayahmu dan ibumu,’ dan ‘Mereka yang mengutuk ayah dan ibu mereka haruslah dihukum mati.’ ");
INSERT INTO indags_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tetapi kalian berkata siapa pun yang mengatakan kepada ayah atau ibunya, ‘Apa yang seharusnya menjadi bagian untuk kalian dariku, sudah saya serahkan sebagai hadiah kepada Allah,’ maka ");
INSERT INTO indags_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","orang itu tidaklah wajib menghormati orangtuanya. Dengan cara ini kalian membatalkan perintah Allah demi tradisi kalian. ");
INSERT INTO indags_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dasar orang-orang munafik! Sungguh benar yang dikatakan Yesaya ketika dia bernubuat: ");
INSERT INTO indags_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Orang-orang ini hanya menghormati Aku dalam ucapan mereka saja, tetapi sesungguhnya mereka tidak peduli pada ajaran-Ku. ");
INSERT INTO indags_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Penyembahan yang mereka berikan tidak berguna. Ajaran yang mereka ajarkan hanyalah aturan-aturan manusia.’” ");
INSERT INTO indags_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lalu Yesus memanggil orang banyak dan berakta, “Dengar dan pahamilah ini: ");
INSERT INTO indags_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","bukan apa yang masuk ke dalam diri kamu melalui mulut yang menajiskan kamu. Apa yang keluar dari mulutmu itulah yang menajiskanmu.” ");
INSERT INTO indags_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kemudian murid-murid Yesus datang kepada-Nya dan berkata, “Guru, tentu Engkau menyadari bahwa orang-orang Farisi itu tersinggung dengan perkataan-Mu.” ");
INSERT INTO indags_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tetapi Yesus menjawab mereka, “Setiap pohon yang tidak ditanam oleh Bapa-Ku akan dicabut sampai ke akarnya.” ");
INSERT INTO indags_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Lupakan tentang mereka, mereka seumpama penuntun jalan yang buta. Jika seorang buta menuntun orang buta lainnya, maka mereka berdua akan jatuh ke dalam lubang.” ");
INSERT INTO indags_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus kemudian berkata, “Jelaskan kepada kami arti dari kisah itu.” ");
INSERT INTO indags_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Bahkan kalian juga tidak mengerti artinya?” Yesus bertanya. ");
INSERT INTO indags_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Apakah kalian tidak tahu bahwa apapun yang masuk ke dalam mulut akan masuk ke dalam perut, dan keluar sebagai melalui sistem pembuangan air besar dari tubuh? ");
INSERT INTO indags_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tetapi apapun juga yang keluar dari mulut adalah hasil dari buah pikiran, dan itulah yang menajiskan kalian. ");
INSERT INTO indags_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sebab apa yang keluar dari pikiran bisa saja pikiran-pikiran jahat, pembunuhan, perselingkuhan, amoralitas seksual, mencuri, berbohong, dan penghujatan, ");
INSERT INTO indags_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","dan itulah yang menajiskan kalian. Makan dengan tangan yang belum dicuci tidaklah membuat kalian menjadi najis.” ");
INSERT INTO indags_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kemudian Yesus berangkat menuju daerah Tirus dan Sidon. ");
INSERT INTO indags_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Seorang perempuan Kanaan datang dari daerah itu dan berteriak, “Tuhan, anak Daud! Kasihanilah saya, sebab anak perempuanku menderita kerasukan setan!” ");
INSERT INTO indags_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Namun Yesus tidak menjawab perempuan itu. Murid-murid-Nya datang dan berkata kepada-Nya, “Katakan padanya untuk berhenti mengikuti kita. Karena teriakan-teriakannya sungguh menjengkelkan!” ");
INSERT INTO indags_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","“Aku hanya dikirim untuk menolong mereka yang berasal dari Israel,” kata Yesus kepada perempuan itu. ");
INSERT INTO indags_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tetapi perempuan itu datang dan bersujud dihadapan-Nya, dan berkata, “Tuhan, tolonglah saya!” ");
INSERT INTO indags_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","“Tidaklah benar untuk mengambil makanan yang disediakan untuk anak-anak dan melemparkannya kepada anjing peliharaan,” kata Yesus kepada perempuan itu. ");
INSERT INTO indags_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Benar, Tuhan, tetapi bahkan anjing-anjing pun diijinkan untuk makan remah-remah roti yang jatuh dari meja tuannya,” jawab perempuan itu. ");
INSERT INTO indags_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","“Kamu sangat percaya pada saya,” jawab Yesus. “Aku mengabulkan keinginanmu!” Dan anak perempuannya sembuh seketika itu juga. ");
INSERT INTO indags_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sesudah itu Yesus kembali melalui Laut Galilea. Dia pergi ke sebuah bukit di dekat sana dan duduk. ");
INSERT INTO indags_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Segera orang banyak datang kepada-Nya, dan membawa dengan mereka orang-orang yang lumpuh, buta, cacat, bisu, dan yang sedang sakit. Orang-orang ini meletakkan mereka yang sakit di tanah di dekat kaki-Nya, dan Yesus menyembuhkan mereka. ");
INSERT INTO indags_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Orang banyak itu kagum dengan apa yang sedang mereka saksikan: orang bisu bisa berbicara, orang cacat disembuhkan, orang lumpuh berjalan, dan orang buta bisa kembali melihat. Dan mereka memuji Allah orang Israel. ");
INSERT INTO indags_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus memanggil murid-murid-Nya dan berkata kepada mereka, “Aku merasa sangat kasihan kepada orang-orang ini, sebab mereka sudah mengikuti Aku selama tiga hari sampai hari ini, dan mereka tidak memiliki apa-apa untuk dimakan. Aku tidak ingin mengirim mereka pergi sementara mereka merasa lapar, sebab bisa-bisa mereka pingsan ketika dalam perjalanan pulang.” ");
INSERT INTO indags_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“Dimana kita bisa menemukan cukup roti di padang gurun ini untuk memberi makan orang sebanyak ini?” jawab murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Berapa potong roti yang ada pada kalian?” kata Yesus. “Ada tujuh, dan beberapa ekor ikan kecil,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Lalu Yesus meminta orang banyak itu duduk. ");
INSERT INTO indags_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dia mengambil ke tujuh potong roti dan ikan itu, dan sesudah memberkati makanan itu, Dia memecahkan mereka menjadi potongan-potongan dan memberikannya kepada murid-murid-Nya, dan para murid-Nya memberikan makanan itu kepada orang banyak. ");
INSERT INTO indags_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Setiap orang makan sampai mereka merasa kenyang, lalu mereka mengumpulkan sisanya sebanyak tujuh keranjang. ");
INSERT INTO indags_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ada 4.000 orang laki-laki yang ikut serta makan makanan itu, belum termasuk perempuan dan anak-anak. ");
INSERT INTO indags_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kemudian Yesus mengirim orang banyak itu pulang, sedangkan Dia sendiri masuk ke dalam perahu dan berlayar ke daerah Magdala. ");
INSERT INTO indags_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Orang-orang Farisi dan Saduki datang untuk menguji Yesus, menuntut agar Dia menunjukkan kepada mereka suatu tanda dari surga. ");
INSERT INTO indags_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesus menjawab mereka, “Ketika senja tiba, kalian berkata, ‘Besok hari akan cerah, sebab langit senja berwarna merah,’ ");
INSERT INTO indags_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","dan di pagi hari kalian berkata, ‘Hari ini cuaca tidak bagus, karena langit berwarna merah dan mendung.’ Kalian tahu cara meramalkan cuaca dengan melihat kondisi langit, tetapi kalian tidak bisa mengenali tanda-tanda zaman! ");
INSERT INTO indags_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Orang-orang jahat yang tidak mempercayai Allah adalah mereka yang mencari tanda-tanda ajaib, tetapi tidak akan ada satu tanda pun yang akan diberikan kepada mereka selain tanda seperti tanda nabi Yunus.” Lalu Dia pergi meninggalkan mereka. ");
INSERT INTO indags_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ketika Yesus dan murid-murid-Nya pergi ke seberang danau, murid-murid-Nya lupa membawa roti. ");
INSERT INTO indags_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Berhati-hatilah terhadap ragi orang Farisi dan Saduki,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Para murid mulai berdebat di antara mereka. “Dia berkata seperti ini karena kita tidak membawa roti,” demikian kesimpulan mereka. ");
INSERT INTO indags_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus tahu apa yang menjadi perdebatan mereka dan berkata, “Sungguh sedikit sekali rasa percaya kalian kepada-Ku! Mengapa kalian saling berdebat tentang ketiadaan roti? ");
INSERT INTO indags_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Apakah kalian masih belum menyadari? Tidakkah kalian ingat lima potong roti yang bisa memberi makan 5.000 orang? Berapa keranjang sisanya yang kalian kumpulkan? ");
INSERT INTO indags_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bagaimana dengan tujuh potong roti yang menyediakan makanan untuk 4.000 orang? Berapa banyak keranjang sisa yang kalian kumpulkan? ");
INSERT INTO indags_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Belum paham juga kah kalian bahwa Aku tidak berbicara tentang roti kepada kalian? Berhati-hatilah terhadap ragi orang Farisi dan Saduki!” ");
INSERT INTO indags_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Akhirnya mereka menyadari bahwa Yesus sedang memperingati mereka tentang ajaran yang diajarkan oleh orang-orang Farisi dan Saduki, dan bukan tentang ragi yang ada di dalam tepung. ");
INSERT INTO indags_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ketika Yesus tiba di daerah Kaisarea Filipi, bertanyalah Dia kepada murid-murid-Nya, “Apa yang dikatakan orang-orang tentang siapa Anak Manusia itu?” ");
INSERT INTO indags_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Ada yang bilang Yohanes Pembaptis, ada yang bilang Elia, dan ada yang bilang Yeremia atau salah satu nabi lainnya,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Tetapi bagaimana dengan kalian?” tanya-Nya. “Menurut kalian, Aku ini siapa?” ");
INSERT INTO indags_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“Engkau adalah Mesias, Anak Allah yang hidup,” jawab Simon Petrus. ");
INSERT INTO indags_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Sungguh Engkau diberkati, hai Simon anak Yohanes,” kata Yesus kepadanya. “Sebab bukan secara manusia yang memberi pengertian, tetapi oleh karena Bapa-Ku yang di surga. ");
INSERT INTO indags_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Saya juga memberi tahu kamu bahwa kamu adalah Petrus, dan di atas batu karang ini saya akan membangun gereja saya dan kuasa kematian tidak akan mengalahkannya. ");
INSERT INTO indags_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aku akan memberikan kunci-kunci kerajaan surga kepadamu, dan apapun yang kamu larang di bumi ini, akan terlarang juga di surga, dan yang kamu ijinkan terjadi di bumi ini, akan diijinkan juga di surga.” ");
INSERT INTO indags_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lalu Yesus memperingati murid-murid-Nya untuk tidak mengatakan kepada siapapun bahwa Dia adalah Mesias. ");
INSERT INTO indags_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sejak dari saat itu, Yesus mulai menjelaskan kepada murid-murid-Nya bahwa suatu hari Dia harus pergi ke Yerusalem, dan mengalami penderitaan yang sangat luar biasa di tangan para tua-tua, iman-iman kepala dan guru-guru agama; dan Dia juga akan dibunuh, tetapi Dia juga akan bangkit kembali dari kematian pada hari yang ke tiga. ");
INSERT INTO indags_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tetapi Petrus menarik Yesus dan mulai memberitahu-Nya untuk tidak berbicara seperti itu. “Allah melarang, Tuhan, bahwa ini akan pernah terjadi pada Engkau!” katanya. ");
INSERT INTO indags_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus berpaling kepada Petrus dan berkata, “Menjauhlah dariku, Setan! Kamu adalah jebakan untuk menjebak saya, karena kamu berpikir dengan cara manusia, dan bukan seperti yang Allah pikirkan!” ");
INSERT INTO indags_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lalu kata Yesus kepada murid-murid-Nya, “Jika kalian ingin menjadi pengikut-Ku, kalian harus rela meninggalkan kehendak kalian sendiri, dan mau mengikut Aku bahkan sampai mati sekalipun. ");
INSERT INTO indags_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sebab jika kamu ingin menyelamatkan hidup kamu, kamu akan kehilangannya, dan jika kamu kehilangan hidup kamu demi saya, kamu akan menyelamatkannya. ");
INSERT INTO indags_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Keuntungan apa yang akan kalian dapat jika kalian memiliki seluruh dunia, tetapi kehilangan nyawa kalian? Apa yang akan kalian serahkan sebagai ganti menyelamatkan nyawa kalian? ");
INSERT INTO indags_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sebab Anak Manusia akan datang dengan penuh kemuliaan penuh dari Bapa, bersama para malaikat-Nya. Kemudian setiap orang akan mendapat imbalan sesuai dengan perbuatan yang sudah dilakukannya. ");
INSERT INTO indags_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ada beberapa orang yang berdiri di sini yang tidak akan mati sebelum mereka melihat Anak Manusia datang dalam kerajaannya.” ");
INSERT INTO indags_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Enam hari kemudian, Yesus membawa Petrus, Yakobus dan saudaranya, Yohanes naik ke atas gunung yang tinggi untuk menyendiri. ");
INSERT INTO indags_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ketiga murid-Nya bertiga melihat Yesus berubah. Wajah-Nya menjadi bercahaya seperti matahari dan pakaian-Nya berubah seputih dan seterang cahaya. ");
INSERT INTO indags_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tiba-tiba, Musa dan Elia muncul di hadapan mereka, sedang berbicara dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lalu Petrus berbicara kepada Yesus, “Tuhan, alangkah baiknya bisa berada di sini. Jika Tuhan mau, saya akan mendirikan tiga pondok — satu untuk-Mu, satu untuk Musa dan satu untuk Elia.” ");
INSERT INTO indags_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sementara Petrus masih berkata-kata, ada awan terang yang membungkus mereka. Dan sebuah suara keluar dari awan itu dan berkata, “Inilah Anak-Ku yang Aku kasihi, Anak yang menyenangkan Aku. Dengarkanlah Dia.” ");
INSERT INTO indags_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ketika mereka mendengar ini, para murid jatuh tersungkur, benar-benar ketakutan. ");
INSERT INTO indags_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus menghampiri dan menyentuh mereka. “Bangunlah,” kata-Nya. “Jangan takut.” ");
INSERT INTO indags_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ketika mereka mengangkat kepala mereka, tidak seorang pun yang mereka lihat kecuali Yesus. ");
INSERT INTO indags_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ketika mereka turun dari gunung itu, Yesus memberi mereka peringatan keras. “Jangan beritahukan kepada siapapun apa yang kalian lihat sampai Anak Manusia sudah bangkit dari kematian,” kata-Nya. ");
INSERT INTO indags_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","“Jadi, mengapa para guru agama berbicara bahwa Elia harus datang terlebih dahulu sebelum Penyelamat yang dijanjikan tiba?” tanya murid-murid Yesus. ");
INSERT INTO indags_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Memang benar bahwa Elia datang agar segala sesuatunya tepat pada tempatnya,” jawab Yesus, ");
INSERT INTO indags_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","“tetapi Aku katakan sejujurnya kepada kalian, Elia sudah datang, tetapi orang-orang tidak mengenali dia. Mereka memperlakukannya sesuka hati mereka. Dan dengan cara yang sama, Anak Manusia juga akan menderita di tangan mereka.” ");
INSERT INTO indags_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lalu murid-murid Yesus menyadari bahwa Yesus sedang berbicara tentang Yohanes Pembaptis. ");
INSERT INTO indags_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ketika mereka menghampiri orang banyak, seorang laki-laki menemui Yesus, dan bersujud di hadapan-Nya. ");
INSERT INTO indags_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ya Tuhan, kasihanilah anak laki-lakiku,” katanya. “Dia sudah kehilangan akal sehatnya dan sangat menderita sehingga dia sering jatuh ke dalam api maupun air. ");
INSERT INTO indags_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aku sudah membawanya kepada murid-murid-Mu, tetapi mereka tidak dapat menyembuhkan dia.” ");
INSERT INTO indags_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Kalian benar-benar orang yang tidak percaya kepada-Ku, dan sangat jahat!” kata Yesus. “Berapa lama Aku harus bersama dengan kalian? Berapa lama Aku harus bersabar dengan kalian? Bawa anak itu kepada-Ku!” ");
INSERT INTO indags_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lalu Yesus dihadapkan setan itu dan setan itu meninggalkan anak laki-laki itu. Dan anak itu langsung sembuh. ");
INSERT INTO indags_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Beberapa saat kemudian, murid-murid Yesus datang kepada-Nya dan bertanya, “Mengapa kami tidak bisa mengusir setan itu keluar?” ");
INSERT INTO indags_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Sebab kalian kurang yakin akan kuasa Allah,” kata Yesus kepada mereka. “Aku katakan sejujurnya kepada kalian, bahkan jika kalian sungguh-sungguh percaya kepada-Ku sedikit saja, kalian bisa katakan kepada gunung ini, ‘Pindahlah dari sini ke sana,’ dan gunung itu akan pindah. Tidak akan ada yang menjadi tidak mungkin bagi kalian.” ");
INSERT INTO indags_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dan ketika mereka sedang berjalan bersama melalui daerah Galilea, Yesus berkata kepada mereka, “Anak Manusia akan dikhianati dan orang-orang akan mengalahkan Dia. ");
INSERT INTO indags_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mereka akan membunuh Dia, tetapi pada hari yang ketiga Dia akan hidup kembali.” Dan murid-murid-Nya merasa sangat sedih mendengar hal ini. ");
INSERT INTO indags_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ketika mereka tiba di daerah Kapernaum, orang-orang yang bertugas memungut pajak setengah syikal untuk rumah Tuhan mendatangi Petrus dan bertanya, “Tentu Gurumu membayar pajak etengah syikal, bukan?” ");
INSERT INTO indags_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ya, tentu saja,” jawab Petrus. Ketika dia kembali ke tempat mereka menginap, Yesus menjawab persoalan itu. “Bagaimana menurutmu, Simon?” tanya Yesus. “Apakah penguasa dunia ini memungut pajak dari penduduk mereka atau dari orang asing?” ");
INSERT INTO indags_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Dari orang asing,” jawab Petrus. Maka Yesus berkata kepadanya, “Jika demikian, seharusnya penduduknya tidak perlu membayar pajak. ");
INSERT INTO indags_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tetapi agar tidak menyinggung seorangpun, pergilah ke danau, dan lemparkanlah tali pancing dengan kail. Tariklah ikan pertama yang kamu tangkap. Dan saat kamu membuka mulutnya di sana, kamu akan menemukan koin stater. Ambil koin stater itu dan berikan kepada mereka untuk saya dan kamu.” ");
INSERT INTO indags_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pada waktu itu, murid-murid Yesus datang kepada-Nya dan bertanya, “Siapakah yang paling hebat dalam kerajaan surga?” ");
INSERT INTO indags_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus memanggil seorang anak kecil mendekat, dan meminta anak itu berdiri di hadapan para murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Aku katakan sejujurnya kepada kalian. Hanya jika kalian mengubah cara berpikir kalian dan menjadi seperti anak-anak, kalian tidak akan masuk ke dalam kerajaan surga,” kata-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Tetapi siapa pun yang merendahkan hati mereka dan menjadi seperti anak kecil ini adalah yang terhebat dalam kerajaan surga. ");
INSERT INTO indags_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dan siapa pun yang menyambut anak kecil ini dalam nama-Ku, mereka menyambut Aku. ");
INSERT INTO indags_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tetapi siapapun yang membuat anak-anak kecil yang percaya kepada-Ku ini berdosa, maka lebih baik bagi diri mereka, jika mereka diikatkan sebuah batu besar pada leher mereka dan ditenggelamkan ke lautan dalam. ");
INSERT INTO indags_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Betapa bencana yang akan datang di dunia karena semua godaannya untuk berbuat dosa! Pencobaan pasti akan datang, tetapi itu akan menjadi bencana bagi orang yang melaluinya pencobaan itu datang! ");
INSERT INTO indags_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jika tangan atau kakimu membuat kamu jatuh ke dalam dosa, potonglah dan buanglah itu. Lebih baik kamu masuk ke dalam kehidupan kekal sebagai orang cacat atau lumpuh dibandingkan jika tubuhmu utuh tetapi dilemparkan ke dalam api abadi. ");
INSERT INTO indags_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dan jika matamu menyebakan kamu jatuh ke dalam dosa, cungkillah dan buanglah. Lebih baik bagimu untuk masuk ke dalam kehidupan kekal dengan hanya satu mata dibandingkan kedua matamu utuh tetapi kamu dilemparkan ke dalam api Gehena. ");
INSERT INTO indags_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pastikanlah kalian tidak memandang rendah anak-anak kecil ini. Saya memberitahu kalian bahwa di surga malaikat mereka selalu bersama Bapa surgawi saya. ");
INSERT INTO indags_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bagaimana menurut kalian tentang hal ini? Seorang laki-laki memiliki seratus ekor domba, dan satu dari domba-domba itu tersesat. Apakah dia tidak akan meninggalkan ke 99 domba lainnya di bukit dan pergi mencari satu ekor yang hilang itu? ");
INSERT INTO indags_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dan jika dia menemukannya, Aku beritahu kalian, dia akan benar-benar bersukacita mendapati domba yang hilang itu dari pada ke 99 ekor yang tidak hilang. ");
INSERT INTO indags_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Demikian juga Bapa-Ku yang di Surga yang tidak ingin satupun dari anak-anak kecil ini tersesat. ");
INSERT INTO indags_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jika saudaramu bersalah terhadap kamu, pergi dan tunjukkanlah kesalahannya kepadanya, hanya berdua dengan dia. Jika dia mendengarkanmu, kalian sudah memenangkan saudara kalian kembali. ");
INSERT INTO indags_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tetapi jika dia tidak mendengarkan, bawalah satu atau dua orang lagi bersama kalian, jadi dengan dua atau tiga orang saksi, kebenaran bisa dipastikan. ");
INSERT INTO indags_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Namun, jika dia menolak mendengarkan mereka, maka beritahukanlah kepada jemaat. Dan jika dia juga tidak mau mendengarkan jemaat, maka perlakukanlah dia sebagai seorang asing atau seorang penagih pajak. ");
INSERT INTO indags_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Aku katakan kepada kalian sejujurnya, apa pun yang kalian larang terjadi di bumi, akan terlarang juga terjadi di surga, dan apapun yang kalian ijinkan terjadi di bumi, akan terjadi juga di surga. ");
INSERT INTO indags_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Aku katakan juga kepadamu, jika dua orang di bumi ini sepakat tentang sesuatu yang kalian doakan, maka Bapa-Ku yang di Surga akan melakukannya untukmu. ");
INSERT INTO indags_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sebab dimana ada dua atau tiga orang berkumpul bersama dalam nama-Ku, Aku ada bersama dengan mereka.” ");
INSERT INTO indags_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lalu Petrus datang kepada Yesus dan bertanya, “Guru, berapa kalikah aku harus mengampuni saudaraku yang bersalah kepadaku? Tujuh kali?” ");
INSERT INTO indags_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Bukan, bukan tujuh kali, tetapi tujuh puluh kali tujuh,” jawab Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Hal kerajaan Sorga seumpama seorang majikan yang hendak menyelesaikan perhitungan hutang antara pekerja-pekerjanya dengan dirinya. ");
INSERT INTO indags_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ketika sang majikan mulai memperhitungkan hutang-hutang pekerjanya, seorang pekerja dibawa menghadap dia. Pekerja ini berhutang kepadanya sekitar 300.000 kg koin emas. ");
INSERT INTO indags_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Karena pekerja ini tidak sanggup membayar hutangnya, maka sang majikan memerintahkan agar pekerja ini dijual, bersama dengan istri dan anak-anaknya serta segala harta miliknya, agar hutangnya bisa dilunasi. ");
INSERT INTO indags_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Si pekerja ini pun bersujud dan berkata kepada majikannya, ‘Tolonglah bersabar! Saya pasti akan melunasi semuanya!’ ");
INSERT INTO indags_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Karena merasa kasihan, maka sang majikan melepaskan si pekerja dan menghapus hutangnya. ");
INSERT INTO indags_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tetapi ketika pekerja ini keluar, dia bertemu dengan seorang rekan kerjanya yang berhutang kepadanya sekitar 100 koin perak. Dia mencengkeram lehernya dan mencekiknya, sambil berkata, ‘Bayarkan utangmu padaku!’ ");
INSERT INTO indags_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Rekannya bersujud di hadapannya dan memohon, ‘Bersabarlah kawan! Aku pasti akan melunasi semua hutangku!’ ");
INSERT INTO indags_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tetapi pekerja ini menolak bersabar, dan membawa rekannya serta memasukkannya ke dalam penjara, sampai rekannya ini bisa melunasi hutangnya. ");
INSERT INTO indags_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ketika rekan sekerjanya yang lain melihat kejadian itu, mereka kaget dan kecewa. Lalu mereka pergi ke majikan mereka dan menceritakan segala sesuatu yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lalu sang majikan memanggil kembali orang itu dan berkata, ‘Kamu pekerja yang jahat! Aku sudah menghapus hutangmu karena kamu memohon kesabaranku. ");
INSERT INTO indags_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tidakkah seharusnya kamu juga berbelas kasihan kepada rekan kerjamu juga, sama seperti yang aku lakukan kepadamu?!’ ");
INSERT INTO indags_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Majikannya menjadi marah dan menyerahkannya kepada petugas penjara sampai pekerja itu bisa melunasi hutangnya. ");
INSERT INTO indags_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Inilah yang akan Bapa-Ku yang di Surga lakukan kepada setiap kalian jika kalian tidak dengan tulus mengampuni saudara-saudra kalian.” ");
INSERT INTO indags_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ketika Yesus selesai berbicara, Dia dan murid-murid-Nya meninggalkan Galilea dan pergi ke daerah Yudea di seberang sungai Yordan. ");
INSERT INTO indags_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Orang banyak mengikuti Dia, dan Dia menyembuhkan banyak orang sakit di sana. ");
INSERT INTO indags_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Datanglah beberapa orang Farisi datang untuk mengujinya. “Bolehkah seorang laki-laki menceraikan istrinya dengan alasan apapun juga?” tanya mereka. ");
INSERT INTO indags_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jawab Yesus kepada mereka, “Belum pernahkah kalian baca bahwa Allah yang menciptakan manusia sebagai laki-laki dan perempuan dari awalnya?” ");
INSERT INTO indags_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lalu kata-Nya lagi, “Inilah alasan seorang laki-laki akan meninggalkan orangtuanya, dan menjadi satu dengan istrinya, dan mereka menjadi satu. ");
INSERT INTO indags_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jadi mereka bukan lagi dua, tetapi satu. Dan apa yang sudah disatukan oleh Allah tidak boleh dipisahkan oleh manusia.” ");
INSERT INTO indags_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Lalu mengapa Musa memberikan aturan bahwa seorang laki-laki boleh menceraikan istrinya dengan memberikan kepada perempuan itu surat cerai, dan mengusirnya keluar?” kata mereka. ");
INSERT INTO indags_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","“Oleh sebab kekerasan hatimu, Musa dengan mengijinkan kalian untuk menceraikan istri kalian, tetapi tidak demikian pada awalnya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“Aku katakan kepada kalian, siapapun yang menceraikan istrinya kecuali karena perselingkuhan, dan lalu menikah kembali, maka dia melakukan perselingkuhan.” ");
INSERT INTO indags_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","“Jika kehidupan suami dan istri seperti itu, lebih baik tidak usah menikah saja!” kata murid-murid Yesus kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","“Tidak semua orang bisa memahami perkataan ini, hanya untuk mereka yang sudah ditentukan oleh Allah,” jawab Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","“Beberapa orang ditetapkan Allah untuk tidak menikah, beberapa karena keputusan yang dibuat oleh orang lain, dan beberapa memilih untuk tidak menikah demi kerajaan surga. Mereka yang bisa memahami perkataan ini, haruslah menerimanya.” ");
INSERT INTO indags_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lalu orang-orang membawa anak-anak kecil kepada-Nya agar Yesus bisa memberkati anak-anak itu dan mendoakan mereka. Tetapi para murid menyuruh mereka untuk tidak melakukannya. ");
INSERT INTO indags_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tetapi Yesus berkata, “Biarkan anak-anak kecil itu datang kepada-Ku. Janganlah menghentikan mereka. Sebab kerajaan Surga adalah milik orang-orang yang seperti mereka!” ");
INSERT INTO indags_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lalu Yesus meletakkan tangan-Nya atas mereka dan memberkati mereka, kemudian Yesus berangkat. ");
INSERT INTO indags_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Seorang laki-laki datang kepada Yesus dan bertanya, “Guru, perbuatan baik apakah yang harus aku lakukan agar aku bisa hidup sampai selamanya?” ");
INSERT INTO indags_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Mengapa kamu bertanya kepada-Ku tentang perbuatan baik?” jawab Yesus. “Hanya ada satu pribadi yang baik. Tetapi jika kamu ingin hidup selamanya, maka lakukanlah perintah-perintah ini.” ");
INSERT INTO indags_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Perintah yang mana yang Guru maksudkan?” tanya laki-laki itu. “Jangan membunuh, jangan berselingkuh, jangan mencuri, jangan memfitnah, ");
INSERT INTO indags_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hormatilah ayahmu dan ibumu, dan kasihilah sesamamu seperti kamu mengasihi dirimu sendiri,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Aku sudah melakukan semua perintah-perintah itu,” jawab si laki-laki muda itu. “Perbuatan apa lagi yang harus aku lakukan?” ");
INSERT INTO indags_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jawab Yesus, “Jika kamu ingin sempurna dan utuh dalam melakukan perbuatan baik agar bisa mendapat kehidupan kekal, pergilah dan juallah harta milikmu, dan bagikanlah uangnya kepada orang miskin, dan kamu akan menyimpan harta di surga. Kemudian datanglah dan ikutlah Aku.” ");
INSERT INTO indags_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ketika laki-laki muda itu mendengar jawaban Yesus, pergilah dia dengan sangat sedih, sebab hartanya banyak. ");
INSERT INTO indags_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","“Aku katakan sejujurnya kepada kalian,” kata Yesus kepada murid-murid-Nya, “Akan sukar bagi orang kaya untuk masuk ke dalam surga. ");
INSERT INTO indags_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bahkan Aku katakan kepada kalian ini: Jauh lebih mudah bagi seekor unta untuk melewati lubang jarum dibandingkan seorang kaya masuk ke dalam kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ketika para murid mendengar hal ini, tercenganglah mereka, dan bertanya, “Jadi, siapa yang bisa diselamatkan?” ");
INSERT INTO indags_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus menatap mereka dan berkata, “Dari sudut pandang manusia memang tidak mungkin, tetapi segala sesuatunya mungkin untuk Allah.” ");
INSERT INTO indags_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lalu Petrus menjawab Yesus, “Guru, kami sudah meninggalkan segala sesuatunya dan mengikuti Engkau. Apa yang akan kami dapatkan?” ");
INSERT INTO indags_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jawab Yesus, “Aku katakan kepada kalian sesungguhnya, ketika segala sesuatu di perbaharui dan Anak Manusia duduk di atas tahta yang penuh dengan kemuliaan-Nya, kalian yang mengikuti Aku akan duduk juga bersama di dua belas takhta, menghakimi ke dua belas suku Israel. ");
INSERT INTO indags_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bagi semua orang yang meninggalkan rumah, saudara, saudari, orangtua, anak-anak dan ladang mereka demi Aku, maka mereka akan menerima kembali semuanya itu seratus kali lipat bahkan lebih, dan juga mereka akan hidup untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sebab banyak orang yang dianggap penting akan menjadi orang yang tidak penting, dan yang dianggap tidak penting menjadi orang penting. ");
INSERT INTO indags_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sebab kerajaan surga adalah seperti seorang pemilik tanah yang pergi ketika hari masih pagi sekali, untuk mencari pekerja agar bekerja di ladang anggur miliknya. ");
INSERT INTO indags_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dan dia setuju untuk membayar para pekerja itu satu keping uang perak sehari dan mengirim mereka untuk bekerja di ladang anggurnya. ");
INSERT INTO indags_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sekitar jam 9 pagi, si pemilik kebuh anggur keluar dan melihat ada pengangguran sedang berdiri di pasar. ");
INSERT INTO indags_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Pergilah bekerja di kebun anggurku juga, dan saya akan membayar kalian dengan upah yang benar,’ katanya kepada mereka. Jadi pergilah mereka ke kebun anggur miliknya. ");
INSERT INTO indags_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sekitar tengah hari dan jam 3 sore hari, si pemilik kebun juga keluar dan kembali melakukan tindakan yang sama. ");
INSERT INTO indags_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lalu si pemilik kebun kembali keluar pada pukul 5 sore dan bertemu dengan para pengangguran sedang berdiri saja. ‘Mengapa kalian hanya berdiri saja dan tidak melakukan apa-apa?’ tanya orang itu kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Sebab tidak ada seorangpun yang mau mempekerjakan kami,’ jawab mereka. ‘Pergilah ke kebun anggurku dan bekerjalah di sana,’ kata si pemilik kebun kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ketika sore hari tiba, si pemilik kebun memanggil pengawas pekerja untuk memanggil para pekerjanya. Mereka akan diberi upah untuk pekerjaan mereka selama satu hari. Dipanggilnya mereka mulai dari yang masuk belakangan sampai kepada mereka yang pertama kali dia sewa untuk bekerja. ");
INSERT INTO indags_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ketika mereka yang dipekerjakan mulai pukul 5 sore masuk, setiap mereka mendapatkan upah satu keping uang perak. ");
INSERT INTO indags_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jadi ketika para pekerja yang pertama kali dipekerjakan masuk untuk menerima upah mereka, mereka berpikir, tentu mereka akan menerima lebih, tetapi ternyata mereka juga menerima satu keping uang perak sebagai upah mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Maka bersungut-sungutlah mereka kepada pemilik kebun itu. ");
INSERT INTO indags_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Mereka yang bapak pekerjakan terakhir hanya bekerja selama satu jam, dan bapak membayar mereka sama seperti upah kami yang sudah bekerja selama satu hari penuh di bawah teriknya matahari,’ protes mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pemilik kebun itu menjawab mereka, ‘Teman, aku memperlakukan kalian dengan adil. Bukankah kita sepakat kalian akan bekerja untukku dengan upah satu keping perak selama sehari? ");
INSERT INTO indags_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ambillah upah kalian dan pergilah. Aku sudah membuat keputusan untuk memberikan upah yang sama kepada mereka yang bekerja paling akhir. ");
INSERT INTO indags_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tidak bisakah saya memilih untuk melakukan apa yang saya inginkan dengan uang saya sendiri? Mengapa kalian harus memberi saya tatapan jahat karena saya ingin berbuat baik?’ ");
INSERT INTO indags_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dengan demikian, yang paling akhir menjadi yang pertama, dan yang paling awal menjadi yang terakhir.” ");
INSERT INTO indags_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dalam perjalanan menuju ke kota Yerusalem, Yesus mengumpulkan kedua belas murid-Nya secara tersendiri dan berkata kepada mereka, ");
INSERT INTO indags_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Dengar, kita akan pergi ke Yerusalem, dan Anak Manusia akan dikhianati dan diserahkan ke imam-imam kepala dan guru-guru agama. Dan mereka akan menghukum mati Aku, ");
INSERT INTO indags_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","dan menyerahkan Aku ke tangan orang asing untuk mengejek, menyiksa dan menyalibkan Aku. Tetapi pada hari yang ke tiga Aku akan bangkit dari antara orang mati.” ");
INSERT INTO indags_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Laku ibu dari Yakobus dan Yohanes datang menemui Yesus. Dia bersujud di hadapan-Nya dan menyatakan permintaannya. ");
INSERT INTO indags_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Apakah yang kamu inginkan?” tanya Yesus kepadanya. “Tolong tunjuk kedua putra saya untuk duduk di samping kamu di kerajaan kamu, satu di kanan kamu dan yang lainnya di kiri kamu,” pintanya. ");
INSERT INTO indags_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Kalian tidak tahu apa yang kalian minta,” kata Yesus kepada mereka. “Apa kalian sanggup mengalami penderitaan yang akan Aku alami?” “Ya, kami sanggup melakukannya,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Kalian memang akan mengalaminya,” kata-Nya kepada mereka, “tetapi kehormatan untuk duduk di kedua sisi-Ku bukanlah Aku yang berhak menentukannya. Bapa-Ku yang di surga yang sudah menentukan siapa orangnya.” ");
INSERT INTO indags_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ke sepuluh murid lainnya merasa jengkel kepada ke dua bersaudara itu ketika mendengar permintaan mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus memanggil mereka semua berkumpul dan berkata, “Kalian tahu bahwa penguasa asing memerintah atas taklukan mereka, dan penguasa yang kuat menekan taklukan mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tetapi hal itu tidaklah berlaku untuk kalian. Setiap orang yang ingin menjadi orang yang paling penting haruslah menjadi pelayan bagi orang lain. ");
INSERT INTO indags_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Dan siapa yang ingin menjadi orang nomor satu haruslah melayani seperti seorang budak untuk orang lain. ");
INSERT INTO indags_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sebab demikian juga Anak Manusia bukan datang untuk dilayani, melainkan untuk melayani, dan untuk memberikan nyawanya sebagai tebusan bagi banyak orang.” ");
INSERT INTO indags_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ketika mereka meninggalkan kota Yeriko, orang banyak mengikuti mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dan ada dua orang buta yang duduk di tepi jalan. Ketika mereka mendengar bahwa Yesus sedang melewati jalan itu, berteriaklah mereka, “Berbelas kasihanlah kepada kami, hai Anak Daud!” ");
INSERT INTO indags_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Orang banyak itu menyuruh agar orang-orang buta ini untuk diam, tetapi mereka bahkan berteriak lebih keras lagi, “Berbelas kasihanlah kepada kami, Tuhan, Anak Daud!” ");
INSERT INTO indags_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Maka berhentilah Yesus dan memanggil mereka, kata-Nya, “Apa yang kalian inginkan untuk Aku lakukan?” ");
INSERT INTO indags_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Ya Tuhan, buatlah agar kami bisa melihat,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Lalu Yesus menyentuh mata mereka. Dengan segera mereka dapat melihat dan mereka mengikuti Dia. ");
INSERT INTO indags_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus dan murid-murid-Nya pergi ke kota Yerusalem. Ketika mereka sudah dekat dengan kota, mereka tiba di desa Betfage yang terletak di Bukit Zaitun. Yesus mengirim dua orang murid-Nya untuk pergi mendahului mereka, ");
INSERT INTO indags_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dan berkata, “Masuklah ke desa itu. Di sana kalian akan menemukan seekor keledai betina yang diikat bersama dengan anaknya. Lepaskanlah ikatan mereka dan bawalah mereka kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jika ada yang bertanya apa yang sedang kalian lakukan, katakan saja kepada mereka, bahwa Aku membutuhkan hewan-hewan itu, dan orang itu akan melepaskan mereka.” ");
INSERT INTO indags_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hal ini untuk menggenapi ucapan yang dinubuatkan oleh nabi: ");
INSERT INTO indags_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Katakan kepada putri-putri Sion, ‘Lihat, Rajamu datang kepadamu. Dia sangat rendah hati, dan menunggang seekor keledai betina, dan anaknya.’” ");
INSERT INTO indags_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Maka pergilah kedua murid itu dan melakukan perintah Yesus. ");
INSERT INTO indags_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dan membawa keledai betina beserta anaknya itu. Mereka meletakkan jubah mereka di atas kedua hewan itu, dan Yesus duduk di atasnya. ");
INSERT INTO indags_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Banyak di antara rombongan yang menggelar jubah mereka di atas jalan, sementara yang lainnya memotong ranting-ranting yang penuh daun dari pohon-pohon dan menebarkannya di jalan. ");
INSERT INTO indags_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Baik yang berjalan mendahului Yesus maupun yang ada di belakang Yesus berteriak, “Hosana bagi Anak Daud! Diberkatilah Dia yang datang dalam nama Tuhan! Hosana di tempat yang paling tinggi!” ");
INSERT INTO indags_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ketika Yesus tiba di Yerusalem, seluruh kota penuh kegemparan. “Siapa ini?” mereka bertanya-tanya. ");
INSERT INTO indags_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Dia ini Yesus, nabi dari kota Nazaret yang ada di daerah Galilea,” jawab orang banyak itu. ");
INSERT INTO indags_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lalu Yesus masuk ke rumah Tuhan, dan mengusir semua penjual dan pembeli yang sedang melakukan transaksi di rumah Tuhan. Ditunggangbalikkan-Nya meja-meja penukar uang dan kursi-kursi para penjual burung merpati. ");
INSERT INTO indags_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kata-Nya kepada mereka, “Bukankah tertulis di Kitab Suci, ‘Rumah-Ku akan disebut rumah doa,’ tetapi kalian sudah mengubahnya menjadi sarang pencuri.” ");
INSERT INTO indags_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Orang-orang buta dan orang-orang lumpuh datang menemui Yesus di rumah Tuhan, dan Dia menyembuhkan mereka. ");
INSERT INTO indags_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tetapi ketika imam-imam kepala dan guru-guru agama melihat perbuatan-perbuatan ajaib yang dilakukan Yesus, dan anak-anak berteriak di rumah Tuhan, “Hosana bagi Anak Daud,” tersinggunglah mereka. “Apa kamu dengar yang dikatakan anak-anak itu?” tanya mereka kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Ya,” jawab-Nya. “Apakah kalian belum pernah membaca di Kitab Suci bahwa, ‘Engkau menaruh pujian yang sempurna di mulut bayi-bayi dan anak-anak’?” ");
INSERT INTO indags_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lalu Yesus meninggalkan mereka dan pergi ke luar kota untuk bermalam di kota Betania. ");
INSERT INTO indags_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Keesokan paginya, Yesus kembali ke dalam kota, dan dia merasa lapar. ");
INSERT INTO indags_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dan dilihat-Nya sebuah pohon ara di sisi jalan, jadi dihampiri-Nya pohon itu, tetapi tidak ditemukan buah satupun pada pohon itu, hanya daun-daun saja. Maka kata Yesus, “Kamu tidak akan pernah berbuah lagi!” Dengan segera pohon ara itu mengering. ");
INSERT INTO indags_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Para murid tercengang melihat ini. “Bagaimana pohon ara itu tiba-tiba layu?” mereka bertanya. ");
INSERT INTO indags_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“Sejujurnya Aku beritahukan kepada kalian,” kata Yesus, “Jika kalian benar-benar percaya kepada Allah, dan tidak ragu kepada-Nya sedikitpun, kalian bukan hanya sanggup melakukan keajaiban seperti yang sudah Aku lakukan, bahkan lebih lagi. Jika kalian berkata kepada gunung ini, ‘Bangun dan lemparkanlah dirimu ke dalam lautan,’ maka hal itu akan terjadi! ");
INSERT INTO indags_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kalian akan menerima segala sesuatu yang kalian minta dalam doa kalian, selama kalian percaya pada Allah.” ");
INSERT INTO indags_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lalu Yesus masuk ke dalam rumah Tuhan. Para imam kepala dan tua-tua pemimpin orang Israel datang kepada-Nya sementara Yesus masih mengajar dan bertanya, “Dengan wewenang apa Engkau melakukan semua ini? Siapa yang memberi-Mu wewenang ini?” ");
INSERT INTO indags_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","“Aku juga akan mengajukan pertanyaan kepada kalian,” jawab Yesus. “Jika kalian bisa menjawabnya, maka Aku juga akan mengatakan dengan wewenang apa Aku melakukan semua perbuatan ajaib ini. ");
INSERT INTO indags_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dari mana asal baptisan Yohanes? Apakah dari surga, atau dari manusia?” Para imam kepala dan guru-guru agama itu saling berdebat, “Jika kita katakan bahwa ‘baptisan Yohanes berasal dari surga,’ maka Dia akan berkata, mengapa kita tidak percaya kepada Dia. ");
INSERT INTO indags_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tetapi jika kita berkata, ‘baptisan Yohanes berasal dari manusia,’ maka kita takut orang banyak ini akan melawan kita, sebab mereka semua menganggap Yohanes adalah seorang nabi.” ");
INSERT INTO indags_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Maka jawab mereka kepada Yesus, “Kami tidak tahu.” “Jika demikian, Aku juga tidak akan mengatakan kepada kalian dengan wewenang apa Aku melakukan perbuatan-perbuatan ajaib ini,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tetapi bagaimana menurut kalian kisah ini? Suatu waktu ada seorang laki-laki yang memiliki dua orang putra. Dia mendatangi putra sulungnya dan berkata, ‘Nak, pergilah bekerja di ladang anggur hari ini.’ ");
INSERT INTO indags_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dan si anak menjawab, ‘Tidak mau,’ tetapi kemudian si anak ini menyesali perkataannya dan dia pergi ke kebun anggur untuk bekerja di sana. ");
INSERT INTO indags_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lalu pergilah si laki-laki ini kepada anak bungsunya dan meminta si anak untuk pergi bekerja di kebun anggurnya. Si bungsu menjawab, ‘Baik, ayah. Aku akan pergi ke sana,’ tetapi sesungguhnya si bungsu sama sekali tidak pergi. ");
INSERT INTO indags_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dari mana di antara ke dua putra ini yang melakukan kehendak ayahnya?” “Yang pertama,” jawab para imam kepala dan guru-guru agama. “Aku katakan yang sebenarnya kepada kalian: para penagih pajak dan perempuan tuna susila akan masuk ke dalam kerajaan Allah bahkan sebelum kalian,” Kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“Yohanes pembaptis datang untuk menunjukkan kepada kalian cara hidup yang benar dengan Allah, dan kalian tidak mempercayainya, tetapi para penagih pajak dan perempuan tuna susila mempercayai dia. Kemudian, ketika kalian melihat apa yang sudah terjadi, kalian masih tetap tidak mau bertobat dan mempercayai dia.” ");
INSERT INTO indags_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Dengarkanlah kisah yang lain,” kata Yesus. “Terdapatlah seorang pemilik tanah yang menanam sebidang kebun anggur, mendirikan pagar di sekeliling kebun itu, menggali sebuah lubang tempat memeras anggur, dan mendirikan sebuah menara pengawas. Lalu disewakannya kebun anggur itu kepada para pekerja dan pergi meninggalkan rumah dalam suatu perjalanan. ");
INSERT INTO indags_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ketika tiba waktunya untuk memanen anggur-anggur tersebut, tuan pemilik kebun itu mengirim para pembantunya kepada para penyewa kebun untuk menerima bagiannya dari hasil panen itu. ");
INSERT INTO indags_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tetapi para penyewa itu mengambil para pembantunya. Sebagian dari para pembantu itu ada yang dipukuli, dibunuh dan ada yang dilempari dengan batu oleh para penyewa kebun ini. ");
INSERT INTO indags_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Lalu pemilik kebun itu kembali mengirimkan para pembantunya, lebih banyak dari yang datang pertama, dan para penyewa ini kembali melakukan hal yang sama kepada para pembantunya. ");
INSERT INTO indags_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Akhirnya dikirimlah olehnya anak laki-lakinya kepada mereka. ‘Tentunya mereka akan menghormati anakku,’ katanya. ");
INSERT INTO indags_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tetapi ketika para penyewa kebun itu melihat sang anak, berkatalah mereka kepada sesamanya, ‘Ini anak si pemilik datang. Ayo, mari bunuh dia, dan kita akan mendapatkan kebun ini sebagai milik kita!’ ");
INSERT INTO indags_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jadi mereka menangkap anak itu, melemparkannya keluar dari kebun anggur serta membunuhnya. ");
INSERT INTO indags_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Sekarang, ketika pemilik kebun itu datang, apa yang akan dia lakukan kepada para penyewa itu?” tanya Yesus. ");
INSERT INTO indags_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Pastilah dia akan membunuh para orang jahat itu,” jawab mereka, “dan menyewakan kebun itu kepada para penyewa lainnya, yang akan memberikan bagian dari hasil panennya di waktu yang seharusnya.” ");
INSERT INTO indags_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kata Yesus kepada mereka, “Belum pernahkah kalian membaca yang tertulis di Kitab Suci? ‘Batu yang ditolak oleh tukang bangunan karena dianggap tidak berharga, ternyata menjadi batu yang paling penting. Hal ini dilakukan oleh Tuhan, dan itu indah di mata kita!’ ");
INSERT INTO indags_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Itu sebabnya saya memberi tahu kalian bahwa kerajaan Allah akan diambil dari kalian. Itu akan diberikan kepada orang-orang yang menghasilkan jenis buah yang tepat. ");
INSERT INTO indags_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Setiap orang yang jatuh ke atas batu ini akan rusak, tetapi batu ini akan menghancurkan siapapun yang ditimpanya.” ");
INSERT INTO indags_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ketika para imam kepala dan orang-orang Farisi mendengar cerita ini, mereka sadar bahwa Yesus berbicara tentang mereka. ");
INSERT INTO indags_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Maka mereka berusaha agar Yesus ditangkap, tetapi mereka takut dengan apa yang orang-orang akan lakukan sebab banyak orang percaya bahwa Yesus adalah seorang nabi. ");
INSERT INTO indags_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus berbicara kepada mereka menggunakan lebih banyak lagi cerita. ");
INSERT INTO indags_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kerajaan surga adalah seperti seorang raja yang mengadakan pesta pernikahan untuk putranya,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Dikirimnya para pelayannya kepada setiap orang yang diundang ke pernikahan untuk segera menghadirinya, tetapi orang-orang itu menolak untuk datang. ");
INSERT INTO indags_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jadi sang raja mengirim lebih banyak lagi pelayan dengan perintah, ‘Katakan kepada semua tamu undangan bahwa aku sudah menyiapkan makanan pesta. Sapi-sapi jantan dan anak-anak sapi gemuk sudah disembelih — segala sesuatunya sudah siap. Jadi, ayo datanglah ke pestanya!’ ");
INSERT INTO indags_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tetapi para undangan tetap tidak menghiraukan undangan itu dan masing-masing pergi mengurus pekerjaannya. Ada yang pergi ke ladangnya, ada yang mengurus usahanya. ");
INSERT INTO indags_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sisanya menangkap para pelayan raja, menganiaya dan membunuh mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Raja menjadi sangat marah. Dikirimnya para prajuritnya untuk menghancurkan para pembunuh itu dan membakar kota mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lalu berkatalah raja kepada para pelayannya yang lain, ‘Makanan pesta sudah siap, tetapi mereka yang diundang tidak layak untuk menghadirinya. ");
INSERT INTO indags_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pergilah ke jalan-jalan dan undanglah setiap orang yang kalian temui untuk datang ke pesta pernikahan ini.’ ");
INSERT INTO indags_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jadi para pelayan raja keluar ke jalan-jalan dan membawa serta setiap orang yang bisa mereka temui, baik orang yang berperilaku baik maupun orang yang berperilaku jahat. Ruangan pesta pernikahan itu menjadi penuh. ");
INSERT INTO indags_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tetapi ketika raja datang untuk bertemu dengan para undangannya, dia dapati ada satu orang laki-laki yang tidak mengenakan pakaian yang layak untuk pesta pernikahan. ");
INSERT INTO indags_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bertanyalah raja kepada orang itu, ‘Kawan, bagaimana bisa kamu masuk ke sini tanpa pakaian yang layak untuk pesta pernikahan?’ Tetapi laki-laki ini tidak bisa memberi jawaban. ");
INSERT INTO indags_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lalu berkatalah raja kepada para pelayannya, ‘Ikatlah kedua tangan dan kakinya, dan lembarkanlah dia keluar ke tempat yang paling gelap, di amana akan ada tangisan dan gemeletuk gigi.’ ");
INSERT INTO indags_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sebab banyak mereka yang diundang, tetapi hanya sedikit yang dipilih.” ");
INSERT INTO indags_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lalu orang-orang Farisi itu pergi, berkumpul bersama dan membuat rencana agar mereka bisa menjebak Yesus melalui ucapan-ucapan-Nya. ");
INSERT INTO indags_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mereka mengirimkan murid-murid mereka kepadanya, beserta dengan beberapa pendukung Herodes. “Guru, kami tahu Engkau adalah seorang yang jujur, dan ajaran Allah yang Engkau ajarkan adalah tentang kebenaran,” kata mereka. “Engkau tidak dipengaruhi oleh siapapun, dan Engkau tidak peduli tentang tingkatan ataupun status. ");
INSERT INTO indags_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jadi bolehkan kami minta pendapatmu? Apakah benar untuk membayar pajak kepada Kaisar?” ");
INSERT INTO indags_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tetapi Yesus tahu bahwa mereka ingin menjebak Dia. Kata-Nya, “Mengapa kalian bersepakat ingin menjebak Aku, hai orang-orang munafik? ");
INSERT INTO indags_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tunjukkanlah kepadaku uang koin yang digunakan untuk membayar pajak.” Dan mereka memberikan mata uang perak senilai satu dinarius kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Gambar siapa dan nama siapa yang tertulis di sini?” tanya Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Gambar dan nama Kaisar,” jawab mereka. “Maka kalian haruslah mengembalikan kepada Kaisar apa yang menjadi haknya, dan kepada Allah apa yang menjadi hak-Nya,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ketika mereka mendengar jawaban Yesus, tertegunlah mereka. Lalu mereka semua pergi meninggalkan Yesus. ");
INSERT INTO indags_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kemudian pada hari yang sama beberapa orang Saduki datang menemuinya. (Mereka adalah orang-orang yang mengatakan tidak ada kebangkitan.) ");
INSERT INTO indags_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bertanyalah mereka kepada Yesus, “Guru, Musa berkata jika seorang laki-laki menikah tanpa memiliki anak, maka saudara laki-lakinya haruslah menikahi janda laki-laki itu dan memberikan keturunan untuk saudaranya yang sudah meninggal itu. ");
INSERT INTO indags_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sekarang, ada tujuh orang bersaudara yang ada bersama kami di sini. Yang pertama menikah, lalu meninggal, dan karena dia tidak mendapatkan keturunan, maka saudaranya yang selanjutnya yang harus menikahi jandanya. ");
INSERT INTO indags_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hal yang sama terulang kembali kepada saudara yang nomor dua, tiga sampai kepada saudara yang nomor tujuh. ");
INSERT INTO indags_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Akhirnya perempuan yang mereka nikahi juga meninggal. ");
INSERT INTO indags_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jadi ketika hari kebangkitan tiba, perempuan itu akan menjadi istri siapa, sebab dia menikah dengan semua tujuh bersaudara ini?” ");
INSERT INTO indags_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus menjawab, “Kesalahan kalian adalah kalian tidak memahami Kitab Suci dan apa yang sanggup Allah lakukan. ");
INSERT INTO indags_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sebab pada hari kebangkitan manusia tidak menikah ataupun dinikahkan — melainkan mereka sama seperti para malaikat yang di surga. ");
INSERT INTO indags_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sedangkan untuk orang mati yang hidup kembali — tidakkah kalian baca apa yang sudah Allah katakan kepada kalian, ");
INSERT INTO indags_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Akulah Allah Abraham, Isak dan Yakub’. Dia bukanlah Allah orang mati, tetapi Allah orang hidup.” ");
INSERT INTO indags_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ketika orang banyak mendengar perkataan-Nya, mereka terpesona dengan pengajaran-Nya. ");
INSERT INTO indags_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ketika orang-orang Farisi mendengar bahwa Yesus membuat orang-orang Saduki terdiam dan tidak dapat membalas ucapan-Nya, maka berkumpullah mereka dan kembali kepada Yesus untuk mengajukan beberapa pertanyaan. ");
INSERT INTO indags_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Salah seorang dari mereka, sebagai seorang pengacara, mengajukan pertanyaan untuk menjebak Yesus: ");
INSERT INTO indags_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guru, apakah yang menjadi perintah yang terbesar di Kitab Suci?” ");
INSERT INTO indags_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kata Yesus kepada mereka, “‘Kasihilah Tuhan Allahmu dengan segenap pikiranmu, perasaanmu, dan dalam segala perbuatanmu.’ ");
INSERT INTO indags_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inilah perintah pertama dari yang paling utama. ");
INSERT INTO indags_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yang kedua adalah, ‘Kasihilah sesamamu seperti kamu mengasihi dirimu sendiri.’ ");
INSERT INTO indags_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kedua perintah ini adalah dasar dari semua hukum Taurat dan tulisan para nabi.” ");
INSERT INTO indags_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sementara orang Farisi berkumpul di sana, bertanyalah Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Menurut kalian, Mesias itu bagaimana?” tanya-Nya. “Keturunan siapakah Dia?” “Keturunan raja Daud,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Tetapi bagaimana bisa Daud di bawah ilham memanggil Dia ‘Tuan’?” tanya Yesus kepada mereka. “Daud berkata, ");
INSERT INTO indags_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tuhan berkata kepada Tuanku, duduklah di sisi kananku sampai Aku mengalahkan semua musuhmu.’ ");
INSERT INTO indags_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jika Daud memanggil Dia Tuan, bagaimana bisa Dia menjadi anak Daud?” ");
INSERT INTO indags_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tidak seorangpun yang dapat menjawab Yesus, dan sejak saat itu tidak seorangpun yang berani mengajukan pertanyaan kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lalu Yesus berkata kepada orang banyak dan murid-murid-Nya: ");
INSERT INTO indags_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Para guru agama dan orang Farisi bertanggung jawab sebagai penerjemah dari hukum Taurat, ");
INSERT INTO indags_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","jadi taatilah mereka dan lakukanlah segala yang mereka katakan kepada kalian. Tetapi jangan ikuti perbuatan mereka, sebab mereka tidak melakukan apa yang mereka ajarkan. ");
INSERT INTO indags_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mereka memberikan beban yang berat dan meletakkannya ke atas bahu orang-orang, tetapi mereka sendiri tidak sedikitpun menolong orang itu untuk meringankan beban mereka. ");
INSERT INTO indags_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Segala yang mereka lakukan hanyalah untuk mencari perhatian. Mereka membuat kotak doa yang besar bagi diri mereka untuk dipakai dan rumbai panjang pada pakaian mereka. ");
INSERT INTO indags_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mereka suka mencari tempat-tempat kehormatan di perjamuan-perjamuan dan tempat-tempat duduk terbaik di rumah-rumah ibadah. ");
INSERT INTO indags_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mereka suka jika disapa dengan hormat di pasar-pasar, dan suka jika orang-orang memanggil mereka, ‘Guru.’ ");
INSERT INTO indags_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Janganlah seorangpun memanggil kalian dengan sebutan ‘Guru’. Hanya satu orang Guru kalian, sementara kalian semua adalah saudara. ");
INSERT INTO indags_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dan jangan seorangpun memanggil kalian dengan sebutan ‘Bapa’ di bumi ini. Karena hanya ada satu saja Bapa kita, yaitu Bapa yang di surga. ");
INSERT INTO indags_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dan jangan biarkan orang-orang memanggil kalian dengan sebutan ‘Pengajar.’ Sebab hanya ada satu Pengajar kalian, yaitu Sang Mesias. ");
INSERT INTO indags_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yang paling hebat di antara kalian akan menjadi hamba kalian. ");
INSERT INTO indags_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mereka yang meninggikan diri mereka akan direndahkan oleh Allah, dan mereka yang merendahkan diri akan ditinggikan oleh Allah. ");
INSERT INTO indags_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian menutup pintu kerajaan surga tepat di depan mata orang yang ingin memasukinya. Kalian sendiri tidak masuk, namun kalian tidak mengijinkan siapapun yang mencoba masuk ke dalamnya. ");
INSERT INTO indags_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian menutup pintu kerajaan surga tepat di depan mata orang yang ingin memasukinya. Kalian sendiri tidak masuk, namun kalian tidak mengijinkan siapapun yang mencoba masuk ke dalamnya, para guru agama dan orang Farisi, kalian orang munafik! Karena kamu melakukan perjalanan melalui darat dan laut untuk membuat satu orang yang bertobat, dan ketika kamu melakukannya, kamu membuatnya menjadi dua kali putra Gehena seperti kamu sendiri. ");
INSERT INTO indags_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian menutup pintu kerajaan surga tepat di depan mata orang yang ingin memasukinya. Kalian sendiri tidak masuk, namun kalian tidak mengijinkan siapapun yang mencoba masuk ke dalamnya., ‘Jika kamu bersumpah demi rumah Tuhan, sumpahmu itu tidak berlaku, tetapi jika kamu bersumpah demi emas rumah Tuhan, maka kamu harus menepati sumbahmu itu.’ Betapa bodoh dan butanya kamu! ");
INSERT INTO indags_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yang mana yang lebih berkuasa — emas itu, atau rumah Tuhan yang membuat emas itu kudus? ");
INSERT INTO indags_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kalian berkata, ‘Jika kamu bersumpah demi mezbah, maka sumpah itu tidak berlaku, tetapi jika kamu bersumpah demi persembahan yang ada di atas mezbah, maka kamu harus menepati sumpahmu itu.’ ");
INSERT INTO indags_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Betapa butanya kamu! Mana yang menurutmu lebih punya kuasa — kurban itu, atau mezbah yang membuat kurban itu suci? ");
INSERT INTO indags_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jika kamu bersumpah atas nama mezbah itu, kamu bersumpah demi mezbah sekaligus semua yang ada di dalamnya. ");
INSERT INTO indags_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jika kamu bersumpah demi rumah Tuhan, kamu bersumpah demi rumah Tuhan itu berikut dengan siapapun yang tinggal di dalamnya. ");
INSERT INTO indags_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jika kamu bersumpah demi surga, maka kamu bersumpah demi tahta Allah dan Dia yang duduk di atas tahta itu. ");
INSERT INTO indags_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Besar sekali bencana yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian menyerahkan perpuluhan mint, adas manis dan jintan, tetapi kalian mengabaikan bagian paling penting dari hukum itu — melakukan baik, menunjukkan pengampunan, dan dapat dipercaya. Ya, kalian memang harus menyerahkan perpuluhan kalian, tetapi jangan lupakan juga hal-hal lain. ");
INSERT INTO indags_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hai kalian pemimpin yang buta — kalian bertingkah seakan-akan kalian menyaring minuman kalian agar kalian tidak menelan nyamuk, tetapi kemudian seakan-akan kalian menelan seekor masuk seekor unta! ");
INSERT INTO indags_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Tampak luar kalian, kalian bersihkan seperti bagian luar cangkir dan gelas, tetapi di dalamnya, kalian busuk, penuh dengan keserakahan dan pemuasan diri. ");
INSERT INTO indags_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kalian orang Farisi yang buta! Bersihkanlah bagian dalam kalian, yaitu hati dan pikiran kalian, dulu, agar bagian luar kalianpun, yaitu perbuatan dan perkataan kalian, ikut bersih. ");
INSERT INTO indags_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian menutup pintu kerajaan surga tepat di depan mata orang yang ingin memasukinya. Kalian sendiri tidak masuk, namun kalian tidak mengijinkan siapapun yang mencoba masuk ke dalamnya, guru-guru agama dan orang-orang Farisi yang munafik! ");
INSERT INTO indags_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kalian pun sama. Penampilan luar kalian tampak seperti orang baik bagi banyak orang, tetapi di dalam, kalian penuh dengan kemunafikan dan kejahatan. ");
INSERT INTO indags_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bencana apa yang akan menimpa kalian, hai orang Farisi dan guru-guru agama yang munafik! Kalian membangun makam sebagai tugu peringatan untuk mengenang nabi-nabi kalian, dan menghiasi kuburan orang-orang baik, ");
INSERT INTO indags_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","dan kalian berkata, ‘Jika kita sudah hidup di jaman leluhur kita, kita tidak akan bergabung dengan mereka untuk membunuhi para nabi.’ ");
INSERT INTO indags_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tetapi dengan mengatakan ini, sesungguhnya kalian menjadi saksi untuk melawan diri kalian sendiri, membuktikan bahwa kalian adalah keturunan orang-orang yang membunuhi para nabi! ");
INSERT INTO indags_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jadi, selesaikanlah pekerjaan yang sudah dimulai oleh leluhur kalian! ");
INSERT INTO indags_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dasar licik, keturunan orang-orang licik, kalian pikir kalian akan lolos dari hari penghukuman Gehena? ");
INSERT INTO indags_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Itu sebabnya Aku mengirim kepada kalian para nabi, orang-orang bijak, dan guru-guru pengajar. Beberapa dari mereka akan kalian bunuh, beberapa kalian salibkan, beberapa akan kalian siksa di rumah-rumah ibadah kalian, kalian akan kejar mereka dari kota ke kota. ");
INSERT INTO indags_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sebagai akibatnya, kalian harus bertanggung jawab untuk pembunuhan atas orang-orang baik yang terjadi di negeri ini, mulai dari darah Habel, yang melakukan hal yang benar, sampai kepada darah Zakaria anak Barakia, yang kalian bunuh di antara rumah Tuhan dan mezbah. ");
INSERT INTO indags_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aku katakan kepada kalian, akibat dari semua ini akan menimpa generasi ini. ");
INSERT INTO indags_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalem, Yerusalem, kalian yang membunuh para nabi dan melempari mereka yang dikirimkan kepadamu dengan batu! Begitu sering Aku ingin mengumpulkan anak-anakmu seperti seorang induk ayam yang mengumpulkan anak-anaknya di bawah sayapnya, tetapi kamu tidak mengijinkan aku. ");
INSERT INTO indags_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sekarang lihat, rumahmu akan sunyi sepi ditinggalkan. ");
INSERT INTO indags_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aku katakan kepada kalian, kalian tidak akan bertemu dengan-Ku lagi sampai kalian berkata, ‘Diberkatilah Dia yang datang dalam nama Tuhan.’” ");
INSERT INTO indags_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ketika Yesus meninggalkan rumah Tuhan, murid-murid-Nya datang kepada-Nya dan dengan bangga menunjuk kepada bangunan Ruman Tuhan. ");
INSERT INTO indags_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tetapi Yesus menjawab mereka, “Kalian lihat bangunan-bangunan ini? Aku katakan kepada kalian sejujurnya: tidak ada satu batupun akan dibiarkan ada di atas batu lainnya. Setiap batu ini akan runtuh!” ");
INSERT INTO indags_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ketika Yesus duduk di Bukit Zaitun, para murid-Nya datang kepada-Nya, dan bertanya, “Tolong beritahukan kepada kami kapankah hal itu akan terjadi. Apakah yang akan menjadi tanda kedatangan-Mu dan tanda dunia ini akan berakhir?” ");
INSERT INTO indags_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","“Pastikan tidak seorangpun yang menyesatkan kalian,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Banyak orang yang akan datang dan mengaku sebagai diri-Ku, dengan berkata, ‘Akulah sang Mesias,’ dan mereka akan menipu banyak orang. ");
INSERT INTO indags_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kalian akan mendengar berita tentang peperangan, dan desas desus tentang peperangan, tetapi janganlah kuatir. Hal-hal ini harus terjadi, tetapi ini juga bukanlah yang tanda akhir dunia. ");
INSERT INTO indags_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bangsa-bangsa dan kerajaan-kerajaan akan saling berperang. Akan ada bencana kelaparan dan gempa bumi di berbagai tempat, ");
INSERT INTO indags_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","tetetapi semua ini barulah awal, seperti seorang perempuan yang sedang akan melahirkan bayinya. ");
INSERT INTO indags_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lalu mereka akan menangkap, menganiaya dan membunuh kalian. Dan banyak orang akan membenci kalian karena kalian percaya kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ketika waktu itu tiba, banyak orang berhenti percaya kepada-Ku. Mereka akan saling menghianati dan saling membenci. ");
INSERT INTO indags_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Banyak nabi-nabi palsu juga akan datang dan menipu banyak orang. ");
INSERT INTO indags_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kejahatan yang meningkat akan menyebabkan cinta banyak orang menjadi dingin, ");
INSERT INTO indags_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","tetapi mereka yang bertahan sampai akhir akan diselamatkan. ");
INSERT INTO indags_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabar baik tentang kerajaan surga akan diberitakan ke seluruh dunia agar setiap orang bisa mendengarnya, barulah datang waktu bagi akhir dunia. ");
INSERT INTO indags_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jadi ketika kalian melihat ‘pemujaan berhala yang mengotori’ ada di tempat kudus seperti yang dinubuatkan oleh Daniel (pembaca yang membaca kitab tolong pertimbangkan dengan hati-hati), ");
INSERT INTO indags_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","maka orang-orang yang tinggal di Yudea haruslah lari ke arah gunung-gunung. ");
INSERT INTO indags_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Siapa pun yang sedang duduk di atas atap, janganlah turun dan mengambil barang-barang yang ada di dalam rumah. ");
INSERT INTO indags_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Siapapun yang sedang ada di ladang janganlah pulang untuk mengambil pakaian. ");
INSERT INTO indags_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Celakalah para perempuan yang mengandung, dan mereka yang masih menyusui ketika masa itu tiba! ");
INSERT INTO indags_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Berdoalah agar ketika hari itu tiba, bukanlah jatuh di musim dingin ataupun hari Sabat. ");
INSERT INTO indags_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sebab pada masa itu, akan terjadi penganiayaan yang mengerikan — lebih berat dari yang pernah terjadi sejak dunia dijadikan sampai sekarang ini, dan tidak akan pernah terjadi lagi. ");
INSERT INTO indags_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hanya jika waktu-waktu itu diperpendek, maka tidak ada satu orangpun yang akan tinggal hidup, tapi demi orang-orang pilihan, waktu itu akan dipersingkat. ");
INSERT INTO indags_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jadi, jika ada yang mengatakan kepada kalian, ‘Lihat, Mesias ada di sini,’ atau ‘Itu Dia ada di sana,’ janganlah percaya berita itu. ");
INSERT INTO indags_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sebab mesias-mesias dan nabi-nabi palsu akan bermunculan, dan akan melakukan tanda-tanda yang luar biasa dan ajaib untuk menipu orang-orang percaya jika memungkinkan. ");
INSERT INTO indags_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Perhatikanlah bahwa Aku sudah memperingatkan kalian sebelum peristiwa-peristiwa ini terjadi. ");
INSERT INTO indags_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jika mereka katakan, ‘Lihat, Dia ada di padang gurun,’ janganlah kalian pergi mencarinya ke sana; atau jika mereka berkata, ‘Lihat, Dia bersembunyi di sini,’ janganlah mempercayainya. ");
INSERT INTO indags_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sebab ketika Anak Manusia datang, Dia akan datang seperti kilat yang bersinar dengan terang dari arah timur ke barat. ");
INSERT INTO indags_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Burung nasar berkumpul di tempat bangkai berada.’ ");
INSERT INTO indags_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tetapi tepat setelah hari-hari penganiayaan itu, matahari akan menjadi gelap, bulan tidak lagi bersinar, dan bintang-bintang akan jatuh dari langit, dan kuasa kegelapan akan diguncang. ");
INSERT INTO indags_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kemudian tanda kedatangan Anak Manusia akan muncul di langit, dan semua orang di bumi akan meratap. Mereka akan melihat Anak Manusia datang di atas awan-awan dengan kuasa dan kemuliaan. ");
INSERT INTO indags_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dengan suara tiupan terompet Dia akan mengirimkan para malaikat-Nya untuk mengumpulkan orang-orang pilihan-Nya dari seluruh tempat, dari ujung langit dan bumi ke ujung lainnya. ");
INSERT INTO indags_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Belajarlah dari kisah pohon ara. Ketika tunasnya menjadi lembut dan daunnya mulai tumbuh, kalian tahu bahwa hampir tiba waktunya musim panas. ");
INSERT INTO indags_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Dengan cara yang sama ketika kalian melihat semua hal ini terjadi, kalian tahu bahwa waktu kedatangan Tuhan sudah dekat, bahkan Dia sudah ada di ambang pintu! ");
INSERT INTO indags_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aku katakan kepada kalian sesungguhnya: generasi ini tidak akan berlalu sampai semua peristiwa-peristiwa ini sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Surga dan bumi boleh lenyap, tetapi perkataan-Ku tidak akan lenyap. ");
INSERT INTO indags_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tetapi tidak seorangpun tahu hari atau waktunya kapan peristiwa ini akan terjadi, tidak para malaikat, ataupun sang Anak. Hanya Bapa di surga yang tahu. ");
INSERT INTO indags_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ketika Anak Manusia datang, hari itu akan seperti ketika zaman Nuh. ");
INSERT INTO indags_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Harinya akan seperti ketika hari-hari sebelum terjadinya banjir bandang, ketika mereka makan dan minum, menikah dan dinikahi, sampai tepat ketika hari Nuh masuk ke dalam perahu besar itu. ");
INSERT INTO indags_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mereka tidak menyadari apa yang akan terjadi sampai banjir datang dan menyapu mereka. Jadi itu akan terjadi ketika saatnya tiba untuk kedatangan Anak Manusia. ");
INSERT INTO indags_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jika ada dua orang sedang bekerja di ladang, yang satu orang akan diangkat, sedangkan yang lain ditinggalkan. ");
INSERT INTO indags_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dan dua orang perempuan sedang menggiling gandum di tempat pengirikan, yang seorang akan diangkat, dan yang seorang akan ditinggalkan. ");
INSERT INTO indags_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jadi tetaplah waspada, sebab kalian tidak tahu kapan saatnya Tuhanmu datang. ");
INSERT INTO indags_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tetapi pertimbangkan hal ini: jika seorang pemilik rumah tahu saatnya seorang pencuri akan datang, dia pasti akan berjaga-jaga. Dia tidak akan membiarkan rumahnya dibobol dan dirampok. ");
INSERT INTO indags_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kalian pun harus bersiap-siap, sebab Anak Manusia datang di waktu yang tidak pernah kalian harapkan. ");
INSERT INTO indags_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sebab siapa pekerja yang bisa dipercaya dan bijaksana? Itu adalah orang yang ditugaskan tuannya untuk mengurus rumah tangganya untuk memberi mereka makanan pada waktu yang tepat. ");
INSERT INTO indags_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sungguh baik jika pekerja itu ditemukan melakukan apa yang seharusnya dia lakukan ketika tuannya kembali! ");
INSERT INTO indags_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aku katakan kepadamu sejujurnya: tuannya akan membuat pekerja itu menjadi kepala untuk segala milik kepunyaannya. ");
INSERT INTO indags_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tetapi jika dia adalah pekerja yang jahat, dia akan mengatakan ini kepada dirinya sendiri, ‘Tuanku akan pergi lama,’ ");
INSERT INTO indags_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","dan mulai memukuli para pekerja lainnya, berpesta dan minum-minum dengan para pemabuk. ");
INSERT INTO indags_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lalu pulanglah tuannya akan di waktu yang tidak diduga oleh si pekerja. ");
INSERT INTO indags_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Maka tuannya itu akan membuat nasib si pekerja sama seperti orang-orang munafik, mengirimnya ke tempat di mana orang akan selalu menangis dan penggilingangigi. ");
INSERT INTO indags_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kerajaan surga seumpama seperti sepuluh orang gadis, yang membawa pelita mereka untuk pergi menemui pengantin laki-laki. ");
INSERT INTO indags_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima orang dari mereka adalah gadis yang bodoh, dan lima orangnya lagi adalah gadis yang bijak. ");
INSERT INTO indags_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gadis-gadis yang bodoh membawa pelita mereka, tetapi mereka tidak membawa serta minyak persediaannya, ");
INSERT INTO indags_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","sementara gadis-gadis yang bijak membawa masing-masing sekendi minyak berikut dengan pelita mereka. ");
INSERT INTO indags_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tetapi sang pengantin laki-laki tidak kunjung datang dan semua gadis itu menjadi mengantuk dan jatuh tertidur. ");
INSERT INTO indags_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ketika tengah malam tiba terdengarlah pengumuman yang dinantikan, ‘Perhatikan, pengantin laki-laki sudah datang! Mari keluar dan temui dia!’ ");
INSERT INTO indags_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ke sepuluh gadis itu bangun dan mengatur nyala pelita mereka. Gadis-gadis yang bodoh berkata kepada gadis-gadis yang bijak, ");
INSERT INTO indags_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‘Bagilah sedikit minyak kalian, sebab pelita kami hampir padam.’ Tetapi gadis-gadis yang bijak berkata, ");
INSERT INTO indags_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Tidak, sebab jika demikian tidak akan ada cukup minyak untuk kalian dan kami. Pergilah ke toko dan belilah minyak untuk kalian sendiri.’ ");
INSERT INTO indags_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sementara kelima gadis bodoh itu membeli minyak, datanglah si pengantin laki-laki, dan mereka yang sudah siap, masuk bersama dia ke dalam pesta pernikahan, dan pintu itu lalu dikunci. ");
INSERT INTO indags_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kelima gadis bodoh itu datang terlambat. ‘Tuan, Tuan,’ panggil mereka, ‘Bukakanlah pintu bagi kami!’ ");
INSERT INTO indags_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tetapi akan dia katakan kepada mereka, ‘Aku tidak pernah mengenal kalian. Pergilah kalian, para pelaku kejahatan!’ ");
INSERT INTO indags_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jadi tetap waspada, sebab kalian tidak tahu waktu dan saatnya. ");
INSERT INTO indags_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kerajaan surga adalah seperti seorang laki-laki yang sedang pergi dalam suatu perjalanan. Dipanggilnya para pekerjanya dan kepada mereka diberikannya miliknya. ");
INSERT INTO indags_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kepada yang seorang dia memberikan lima kantong koin perak, kepada yang satu dia memberikan dua kantong koin perak, dan kepada yang lain dia memberikan satu kantong koin perak, sesuai dengan kemampuan mereka. Lalu pergilah si tuan ini. ");
INSERT INTO indags_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dengan segera pekerja yang mendapat lima kantong koin perak pergi dan menggunakan uangnya untuk membangun sebuah usaha, dan mendapatkan lima kantong koin perak lagi sebagai keuntungannya. ");
INSERT INTO indags_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Demikian juga dengan pekerja yang mendapat kantong koin perak. Dia mendapatkan keuntungan dua kantong koin perak dari usaha yang dilakukannya. ");
INSERT INTO indags_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tetapi pekerja yang hanya mendapat satu kantong koin perak pergi menggali lubang dan menguburkan uang milik tuannya. ");
INSERT INTO indags_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sesudah lama berselang, sang tuan dari ketiga pekerja itu pulang, dan meminta pertanggungjawaban dari mereka. ");
INSERT INTO indags_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pekerja yang mendapat lima kantong koin perak datang dan membawakan untuk tuannya tambahan lima kantong koin perak lagi. ‘Tuan,’ katanya, ‘Tuan memberikan kepada saya lima kantong koin perak. Lihat, saya sudah mendapatkan keuntungan sebanyak lima kantong koin perak.’ ");
INSERT INTO indags_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kata tuannya kepadanya, ‘Kamu sudah bekerja dengan baik — kamu pekerja yang baik dan setia. Kamu sudah membuktikan bahwa kamu bisa dipercaya untuk hal-hal kecil, maka sekarang saya akan mempercayakan kamu untuk bertanggung jawab dengan hal-hal besar. Berbahagialah, sebab saya sungguh-sungguh berkenan kepadamu!’ ");
INSERT INTO indags_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pekerja yang menerima dua kantong koin perak juga datang. ‘Tuan,’ katanya, ‘Tuan memberikan kepada saya dua kantong koin perak. Lihat, saya sudah mendapatkan keuntungan sebanyak dua kantong koin perak.’ ");
INSERT INTO indags_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kata tuannya kepadanya, ‘Pekerjaanmu sangat baik — kamu adalah pekerja yang baik dan setia. Kamu terbukti bisa dipercaya mengurus hal-hal yang kecil, maka sekarang saya memberimu tanggung jawab untuk mengurus hal-hal yang besar. Bersukacitalah, sebab saya sungguh berkenan kepada kamu!’ ");
INSERT INTO indags_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Lalu datanglah seorang yang mendapat satu kantong koin perak, ‘Tuan,’ katanya, ‘Saya tahu bahwa tuan adalah seorang laki-laki yang kejam. Tuan menuai apa yang tuan tidak tabur, dan memanen di tempat yang tuan tidak tanam. ");
INSERT INTO indags_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Maka karena saya takut kepada tuan, saya pergi dan menyembunyikan uang kantong koin perak tuan di dalam tanah. Ini, tuan bisa mengambil kembali milik tuan.’ ");
INSERT INTO indags_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tetapi jawab tuannya kepadanya, ‘Dasar kamu pekerja yang jahat dan malas! Jika menurutmu saya menuai di tempat saya tidak menabur, dan memanen apa yang tidak saya tanam, ");
INSERT INTO indags_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","maka seharusnya kamu menyimpan uang itu di bank sehingga ketika saya kembali, saya bisa mendapat uang sekaligus dengan bunga simpanannya. ");
INSERT INTO indags_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ambillah satu uang kantong koin perak yang ada padanya, dan berikanlah itu untuk orang yang sudah memegang sepuluh kantong. ");
INSERT INTO indags_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sebab setiap orang yang setia berusaha kepadanya akan diberikan lagi sampai dia berkelimpahan, dan setiap orang yang tidak mau berusaha, apa pun yang ada padanya akan diambil dari dia. ");
INSERT INTO indags_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sekarang, lemparkanlah pekerja yang tidak berguna ini ke tempat yang paling gelap, di mana hanya ada tangisan dan penggilingangigi.’ ");
INSERT INTO indags_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tetapi ketika Anak Manusia datang dalam kemuliaan-Nya, bersama dengan seluruh malaikat-Nya, Dia akan duduk dalam tahta-Nya yang mulia. ");
INSERT INTO indags_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dan setiap orang akan dibawa ke hadapan-Nya. Dan Dia akan memisahkan mereka satu per satu, seperti seorang gembala yang memisahkan kambing-kambing dari domba-domba. ");
INSERT INTO indags_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dia akan meletakkan domba-domba di sebelah kanan, dan kambing-kambing di sebelah kiri. ");
INSERT INTO indags_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lalu sang Raja akan berkata kepada mereka yang ada di sebelah kanannya, ‘Mari, kalian yang mendapat berkat dari Ayah-Ku, dan mewarisi kerajaan yang disiapkan untuk kalian sejak dari dunia ini dibentuk. ");
INSERT INTO indags_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sebab ketika Aku lapar, kalian memberiku makanan untuk dimakan. Dan ketika Aku haus, kalian memberi Aku air untuk diminum. Sekalipun Aku orang asing, kalian mengundang-Ku untuk masuk. ");
INSERT INTO indags_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ketika Aku tidak memiliki pakaian, kalian memakaikannya untuk-Ku. Ketika Aku sakit, kalian merawat-Ku. Dan ketika Aku ada dalam penjara, kalian mengunjungi Aku.’ ");
INSERT INTO indags_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Maka mereka yang ada di sisi kanan-Nya berkata, ‘Tuhan, kapankan kami melihat Engkau lapar dan memberi Engkau makan, atau haus dan memberi Engkau minum? ");
INSERT INTO indags_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kapankah kami melihat Engkau seperti orang asing dan mengundang-Mu masuk, atau Engkau tidak berpakaian dan memakaikan baju kepada-Mu? ");
INSERT INTO indags_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kapankah kami melihat Tuhan sakit, atau dipenjara dan menjenguk-Mu?’ ");
INSERT INTO indags_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sang Raja memberitahu mereka, ‘Kukatakan sejujurnya kepadamu, apapun yang kalian lakukan kepada salah satu dari mereka yang dianggap paling tidak penting dari saudara-saudara saya, kalian melakukannya untuk kau.’ ");
INSERT INTO indags_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kepada mereka yang ada di sebelah kiri-Nya, Dia berkata, ‘Pergilah dari hadapan-Ku, kalian yang dikutuk, masuk ke dalam api abadi yang disiapkan bagi iblis dan para malaikatnya! ");
INSERT INTO indags_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sebab ketika Aku lapar kalian tidak memberiku apapun untuk dimakan. Ketika Aku haus, kalian tidak memberiku minum. ");
INSERT INTO indags_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ketika saya datang sebagai orang asing, kalian tidak mengundang saya masuk. Aku telanjang namun kalian tidak memberiku pakaian. Aku sakit dan dipenjara, namun kalian tidak menjengukku.’ ");
INSERT INTO indags_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dan mereka juga menjawab, ‘Tuhan, kapan kami melihat Engkau lapar, atau haus, atau sebagai orang asing, atau telanjang, atau sakit, atau dipenjara dan tidak merawat Engkau?’ ");
INSERT INTO indags_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Maka berkatalah Dia, ‘Aku katakan kepadamu sejujurnya: apapun yang tidak kalian lakukan kepada orang-orang yang dianggap paling tidak penting dari saudara-saudara saya, kalian tidak melakukannya kepada-Ku.’ ");
INSERT INTO indags_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dan mereka akan pergi ke penghakiman kekal, tetapi mereka yang baik akan masuk dalam kehidupan kekal.” ");
INSERT INTO indags_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sesudah Yesus mengatakan semua ini, berkatalah Dia kepada murid-murid-Nya, ");
INSERT INTO indags_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kalian tahu bahwa hari raya Paskah akan diadakan dua hari lagi, dan Anak Manusia akan diserahkan untuk disalibkan.” ");
INSERT INTO indags_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lalu imam kepala dan para pemimpin suku Israel berkumpul di halaman rumah Kayafas, sang Imam Besar. ");
INSERT INTO indags_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Di sana mereka merencanakan untuk menangkap Yesus dengan dalih penipuan dan membunuh Dia. ");
INSERT INTO indags_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tapi mereka berkata, “Janganlah kita lakukan ini selama hari raya agar orang-orang tidak menimbulkan kerusuhan.” ");
INSERT INTO indags_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sementara Yesus menginap di rumah Simon si kusta di Betania, ");
INSERT INTO indags_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","seorang perempuan datang kepada-Nya membawa sebotol pualam parfum yang sangat mahal. Dan menuangkannya ke atas kepala Yesus sementara Dia sedang duduk makan. ");
INSERT INTO indags_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tetapi ketika para murid melihat perbuatannya, mereka menjadi kecewa. “Sungguh suatu kesia-siaan yang sangat keterlaluan!” kata mereka. ");
INSERT INTO indags_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Padahal parfum ini bisa dijual dengan harga yang sangat mahal dan uangnya bisa diberikan kepada orang-orang miskin!” ");
INSERT INTO indags_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus menyadari apa yang sedang terjadi dan memberitahukan mereka, “Mengapa kalian marah dengan perempuan ini? Dia sudah melakukan sesuatu yang luar biasa untuk-Ku! ");
INSERT INTO indags_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Orang-orang miskin akan selalu ada bersama dengan kalian, sedangkan Aku tidak. ");
INSERT INTO indags_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dengan menuangkan parfum ini ke atas tubuh-Ku, sesungguhnya perempuan ini sedang menyiapkan penguburan-Ku. ");
INSERT INTO indags_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aku katakan sejujurnya kepada kalian: kemanapun di bumi ini berita tentang kabar baik disiarkan, kisah tentang perbuatan perempuan ini juga akan diceritakan sebagai pengingat akan dia.” ");
INSERT INTO indags_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lalu Yudas Iskariot, salah seorang dari kedua belas murid, pergi menemui para imam kepala ");
INSERT INTO indags_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","dan bertanya kepada mereka, “Berapa yang akan kalian berikan kepadaku jika aku menyerahkan Yesus kepada kalian?” Mereka setuju untuk memberikan Yudas 30 keping uang perak. ");
INSERT INTO indags_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sejak saat itu Yudas mencari sebuah kesempatan untuk mengkhianati Yesus. ");
INSERT INTO indags_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pada hari pertama dari Hari Raya Roti tidak beragi, para murid datang kepada Yesus dan bertanya, “Dimanakah Guru mau kami siapkan perjamuan Perayaan Paskah?” ");
INSERT INTO indags_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus berkata kepada mereka, “Pergilah ke kota dan temukan seorang laki-laki ini, dan katakan padanya bahwa Guru berkata, ‘Waktuku sudah hampir tiba. Aku datang untuk merayakan Perjamuan Paskah dengan murid-murid-Ku di rumahmu.’” ");
INSERT INTO indags_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Para murid melakukan apa yang Yesus katakan kepada mereka, dan menyiapkan Perjamuan Paskah di sana. ");
INSERT INTO indags_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ketika senja tiba, Yesus duduk dan makan dengan kedua belas murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sementara mereka sedang makan, Dia memberitahu mereka, “Aku katakan kepada kalian sejujurnya: salah satu dari kalian akan mengkhianati-Ku.” ");
INSERT INTO indags_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mereka sangat bermasalah. Satu per satu bertanya kepada Yesus, “Tuhan, apakah itu saya?” ");
INSERT INTO indags_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","“Dia yang mencelupkan tangannya ke dalam makanan bersamaan dengan-Ku yang akan menghianati Aku,” Jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Anak Manusia akan mati seperti yang sudah dinubuatkan tentang Dia, tetapi celakalah dia yang mengkhianati Anak Manusia! Lebih baik bagi orang itu jika dia tidak pernah dilahirkan!” ");
INSERT INTO indags_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, yang akan mengkhianati Yesus, berakta, “Bukan saya kan, Rabi?” “Kamu mengatakannya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sementara mereka sedang makan, Yesus mengambil roti dan memberkatinya. Lalu Dia memecah-mecahkan-Nya dan memberikannya kepada murid-murid-Nya. “Ambillah dan makanlah roti ini, sebab roti ini melambangkan tubuh-Ku,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lalu diangkatnya cangkir-Nya, memberkatinya, dan memberikannya kepada mereka. “Minumlah darinya, kalian semua,” kata-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Sebab minum ini melambangkan darah-Ku, yang adalah darah perjanjian, yang dicurahkan bagi banyak orang sebagai pengampunan dosa. ");
INSERT INTO indags_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Bagaimanapun, Aku katakan kepada kalian, Aku tidak akan minum air anggur ini sampai ketika Aku meminumnya yang baru bersama dengan kalian di dalam Kerajaan Bapa-Ku.” ");
INSERT INTO indags_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Setelah menyanyikan sebuah lagu, mereka pergi menuju Bukit Zaitun. ");
INSERT INTO indags_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","“Kalian semua akan meninggalkan Aku malam ini,” kata Yesus kepada mereka. “Seperti yang tertulis di Kitab Suci, ‘Aku akan menyerang sang Gembala, dan kawanan dombanya akan tercerai berai.’ ");
INSERT INTO indags_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tetapi sesudah Aku bangkit, Aku akan mendahului kalian ke Galilea.” ");
INSERT INTO indags_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tetapi Petrus keberatan, “Sekalipun yang lainnya meninggalkan Engkau, aku tidak akan pernah melakukannya.” ");
INSERT INTO indags_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Sejujurnya Aku katakan kepadamu,” kata Yesus kepadanya, “Malam ini juga, sebelum ayam jantan berkokok, kamu akan menyangkal Aku tiga kali.” ");
INSERT INTO indags_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“Sekalipun saya harus mati bersama-Mu, saya tidak akan pernah menyangkal Engkau!” kata Petrus bersikeras. Dan semua murid juga mengatakan hal yang sama. ");
INSERT INTO indags_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lalu Yesus bersama murid-murid-Nya pergi ke suatu tempat yang dinamakan Getsemani. Kata-Nya kepada mereka, “Duduklah di sini sementara Aku pergi ke arah sana dan berdoa.” ");
INSERT INTO indags_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lalu Yesus membawa Petrus dan kedua anak Zebedeus bersama dengan-Nya, dan dia mulai menderita kesedihan dan kesusahan yang menyiksa. ");
INSERT INTO indags_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Lalu kata-Nya kepada mereka, “Saya sangat diliputi kesedihan sehingga itu membunuh saya. Tunggulah dan berjaga-jagalah dengan-Ku di sini.” ");
INSERT INTO indags_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lalu Yesus maju sedikit, sujud dengan muka ke atas tanah, dan berdoa, “Bapa-Ku, tolonglah, jika memungkinkan, biarlah penderitaan ini tidak harus Aku alami,” doa Yesus. “Meskipun demikian, biarlah itu karena kehendak-Mu, dan bukan kehendak-Ku.” ");
INSERT INTO indags_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lalu kembalilah Yesus kepada murid-murid-Nya dan mendapati bahwa mereka sedang tidur. Berkatalah Yesus kepada Petrus, “Apa, tidak bisakah kalian tetap terjaga bersama-Ku hanya satu jam saja? ");
INSERT INTO indags_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tetaplah berjaga dan berdoalah, agar kalian tidak jauh ke dalam pencobaan. Ya, roh memang penurut, tetapi tubuh ini lemah.” ");
INSERT INTO indags_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lalu pergilah Yesus berdoa untuk yang kedua kalinya. “Bapa, jika tidak mungkin penderitaan ini diambil dari pada-Ku, kecuali Aku mengalamina, maka jadilah sesuai kehendak-Mu,” kata-Nya. ");
INSERT INTO indags_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kembalilah Yesus kepada murid-murid-N ya dan menemukan bahwa mereka sedang tertidur, sebab mereka sudah sangat mengantuk. ");
INSERT INTO indags_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Maka ditinggalkan-Nya mereka sekali lagi, dan pergi serta berdoa untuk ketiga kalinya, mengulangi doa yang sama. ");
INSERT INTO indags_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lalu kembalilah Yesus kepada para murid-Nya, dan berkata kepada mereka, “Bagaimana bisa kalian masih tidur dan beristirahat? Dengar, waktunya sudah tiba. Anak Manusia akan dikhianati kepada orang-orang yang berdosa! ");
INSERT INTO indags_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ayo bangun, mari pergi! Lihat, dia yang mengkhianati Aku sudah tiba.” ");
INSERT INTO indags_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sesudah Yesus selesai mengatakan ini, salah satu dari dua belas rasul tiba bersama dengan kumpulan besar orang yang bersenjata pedang dan tongkat yang dikirim oleh para imam kepala dan pemimpin orang Israel. ");
INSERT INTO indags_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Si pengkhianat sudah mengatur sebuah tanda dengan mereka, yaitu, “Dia yang saya beri salam dengan mencium pipinya, itulah Dia — tangkaplah Dia,” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas dengan segera menghampiri Yesus dan berkata, “Salam, Guru,” dan mengecup pipi-Nya. ");
INSERT INTO indags_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“Kawan, lakukanlah apa yang hendak kamu lakukan,” kata Yesus kepada Yudas. Jadi mereka datang dan memegang Yesus serta menangkap Dia. ");
INSERT INTO indags_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Salah satu murid yang mengikuti Yesus mengambil pedang dan mengeluarkannya dari sarungnya. Dia menyerang pelayan imam besar dan memotong sebelah telinga orang itu. ");
INSERT INTO indags_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tetapi Yesus berkata kepada orang itu, “Sarungkan kembali pedangmu. Setiap orang yang menggunakan pedang untuk bertarung, akan mati juga oleh pedang. ");
INSERT INTO indags_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Apakah menurutmu Aku tidak bisa minta kepada Bapa-Ku, dan Dia tidak akan segera mengirim dua belas legiun malaikat? ");
INSERT INTO indags_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tetapi bagaimana bisa nubuatan kitab Suci akan tergenapi jika tidak terjadi seperti ini?” ");
INSERT INTO indags_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lalu berkatalah Yesus kepada gerombolan orang itu, “Apakah kalian datang dengan membawa pedang dan tongkat untuk menangkap-Ku seakan-akan Aku ini penjahat berbahaya? Setiap hari Aku duduk mengajar di rumah Tuhan, dan kalian tidak menangkap-Ku ketika itu. ");
INSERT INTO indags_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tetapi semua ini terjadi sebagai penggenapan yang sudah ditulis oleh para nabi.” Lalu semua murid-Nya meninggalkan Dia dan melarikan diri. ");
INSERT INTO indags_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mereka yang menangkap Yesus membawa Dia ke rumah Imam Besar Kayafas, di mana pengajar-pengajar agama dan para pemimpin sudah berkumpul. ");
INSERT INTO indags_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus mengikuti Yesus dari jauh, dan masuk ke halaman rumah imam kepala. Di sana dia duduk bersama dengan para penjaga untuk mencari tahu bagaimana segala sesuatunya ini akan berakhir. ");
INSERT INTO indags_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Para imam kepala dan seluruh hakim sedang mencari beberapa tuduhan palsu yang bisa diarahkan kepada Yesus agar mereka bisa menghukum mati Dia. ");
INSERT INTO indags_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tetapi mereka tidak dapat menemukan satu bukti pun, sekalipun begitu banyak saksi palsu yang sudah maju memberikan kesaksian. Pada akhirnya, majulah dua orang saksi ");
INSERT INTO indags_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","dan melaporkan, “Orang ini berkata, ‘Aku bisa menghancurkan rumah Tuhan, dan membangunnya kembali dalam waktu tiga hari.’” ");
INSERT INTO indags_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sang imam kepala berdiri dan bertanya kepada Yesus, “Apakah Engkau tidak memiliki jawaban? Apa yang menjadi pembelaan-Mu?” ");
INSERT INTO indags_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tetapi Yesus tetap berdiam diri dan tidak mengucapkan satu katapun. Imam kepala itu berkata kepada Yesus, “Demi Allah yang hidup, saya meminta Engkau menjawab dengan jujur. Katakan kepada kami, apakah Engkau benar-benar Mesias, anak Allah?!” ");
INSERT INTO indags_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Engkau sendiri yang mengatakannya,” jawab Yesus. “Dan Aku katakan juga kepadamu, kalian akan melihat di masa yang akan datang, Anak Manusia akan duduk di sebelah kanan Yang Mahakuasa, dan akan datang kembali di atas awan-awan.” ");
INSERT INTO indags_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mendengar ucapan Yesus, sang Imam Besar merobek pakaiannya, dan berkata, “Dia berhujat! Untuk apa lagi kita membutuhkan saksi? Dengar, kalian sendiri sudah mendengar hujatan-Nya! ");
INSERT INTO indags_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jadi, apa keputusan kalian?” “Bersalah! Dia layak dihukum mati!” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lalu mereka menampar wajah Yesus dan memukuli Dia. Beberapa menampar Yesus dengan tangan mereka, ");
INSERT INTO indags_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dan berkata, “Bernubuatlah, hai ‘Mesias’! Siapa yang baru saja memukuli Engkau?” ");
INSERT INTO indags_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sementara Petrus duduk di luar di pekarangan, seorang gadis pelayan datang menemuinya, dan berkata, “Kamu kan bersama Yesus si orang Galilea itu!” ");
INSERT INTO indags_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tetapi Petrus menyangkali hal itu di depan banyak orang. “Aku tidak tahu apa yang kamu bicarakan,” katanya. ");
INSERT INTO indags_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ketika Petrus kembali ke pintu masuk pekarangan, seorang gadis pelayan melihat dia dan berkata kepada orang-orang yang ada di situ, “Orang ini juga bersama dengan Yesus yang dari Nazaret itu.” ");
INSERT INTO indags_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sekali lagi Petrus menyangkali hal itu, bahkan dengan bersumpah dia berkata, “Aku tidak mengenal orang itu.” ");
INSERT INTO indags_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Beberapa saat kemudian, orang-orang yang sedang berdiri di sana menghampiri Petrus dan berkata, “Kamu sudah pasti salah satu dari mereka. Bisa terdengar dari logatmu berbicara.” ");
INSERT INTO indags_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Maka Petrus mulai bersumpah, “Terkutuklah saya, jika saya berbohong! Aku tidak mengenal orang itu!” Dengan segera ayam jantan berkokok. ");
INSERT INTO indags_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lalu Petrus ingat bahwa Yesus sudah berkata kepadanya, “Sebelum ayam jantan berkokok, kamu sudah tiga kali menyangkal bahwa kamu mengenal Aku.” Lalu Petrus pergi ke luar dan menangis dengan sangat sedih. ");
INSERT INTO indags_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagi-pagi sekali keesokan harinya, seluruh imam kepala dan para pemimpin Israel berunding dan bersepakat untuk membunuh Yesus. ");
INSERT INTO indags_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mereka mengikat Dia, membawa-Nya, dan menyerahkan-Nya kepada sang Gubernur, Pilatus. ");
INSERT INTO indags_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ketika Yudas, yang mengkhianati Yesus, melihat bahwa Yesus akan dihukum mati, menyesallah dia akan tindakannya, dan mengembalikan tiga puluh keping perak itu kepada para imam kepala dan pemimpin orang Israel. ");
INSERT INTO indags_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Aku sudah berdosa! Aku sudah mengkhianati orang yang tidak bersalah!” katanya kepada mereka. “Tidak ada urusannya dengan kami!” jawab imam kepala dan para pemimpin Israel. “Itu masalahmu!” ");
INSERT INTO indags_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas lalu melempar ke tiga puluh uang perak itu ke rumah Tuhan dan meninggalkan mereka. Lalu Yudas pergi menggantung dirinya. ");
INSERT INTO indags_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Para imam kepala mengambil uang perak itu dan berkata, “Ini adalah uang darah, jadi tidak halal untuk memasukkan ini ke dalam perbendaharaan rumah Tuhan.” ");
INSERT INTO indags_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Maka mereka sepakat untuk membeli sebidang tanah dari seorang tukang periuk dan menjadikannya kuburan untuk mengubur orang-orang asing. ");
INSERT INTO indags_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Itulah mengapa ladang itu masih disebut sampai sekarang sebagai “Lapangan Darah.” ");
INSERT INTO indags_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hal ini untuk menggenapi nubuatan yang dikatakan oleh nabi Yeremia: “Mereka mengambil tiga puluh keping uang perak — yaitu harga yang ditetapkan untuk menebus salah satu orang Israel — ");
INSERT INTO indags_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","dan menggunakannya untuk membayar sebidang tanah tukang periuk, seperti yang Tuhan perintahkan untuk aku lakukan.” ");
INSERT INTO indags_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesus dibawa ke hadapan Gubernur Pilatus yang bertanya kepada-Nya, “Apakah Engkau Raja orang Yahudi?” “Engkau yang mengatakannya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tetapi ketika para imam kepala dan pemimpin orang Israel membawa tuduhan kepada Yesus, Dia sama sekali tidak menjawab tuduhan mereka. ");
INSERT INTO indags_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","“Tidakkah Engkau dengar betapa banyaknya tuduhan yang mereka bawa kepada-Mu?” tanya Pilatus kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tetapi Yesus tidak mengatakan apa pun, satu katapun tidak. Hal ini sangat mengejutkan sang Gubernur. ");
INSERT INTO indags_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sekarang sudah menjadi kebiasaan Gubernur untuk melepaskan seorang tahanan kembali ke masyarakat bila ada perayaan sesuai keinginan orang banyak. ");
INSERT INTO indags_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ketika itu ada seorang tawanan yang terkenal sangat jahat, yang bernama Barabas. ");
INSERT INTO indags_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jadi bertanyalah Pilatus kepada orang banyak yang sedang berkumpul itu, “Siapa yang kalian kehendaki untuk saya bebaskan? Barabas, atau Yesus, yang disebut Mesias?” ");
INSERT INTO indags_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Pilatus sadar bahwa karena iri hatilah orang-orang ini menyerahkan Yesus kepadanya untuk diadili.) ");
INSERT INTO indags_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sementara Pilatus sedang duduk di kursi hakim, istrinya mengirimkan seorang pengirim pesan dengan perkataan, “Jangan lakukan apapun kepada orang yang tidak berdosa ini, sebab aku sangat menderita karena mimpi yang aku alami hari ini tentang orang ini.” ");
INSERT INTO indags_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tetapi para imam kepala dan pemimpin Israel sudah menyakinkan orang banyak itu agar Barabas dibebaskan, dan agar Yesus dihukum mati. ");
INSERT INTO indags_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ketika Gubernur bertanya kepada mereka, “Jadi siapa dari antara kedua orang ini yang kalian ingin aku dibebaskan?” mereka, menjawab, “Barabas.” ");
INSERT INTO indags_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Lalu, apa yang harus aku lakukan terhadap Yesus, sang Mesias?” tanya Pilatus kepada orang-orang itu. Mereka semua berteriak, “Salibkan Dia!” ");
INSERT INTO indags_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Tetapi kenapa? Kejahatan apa yang sudah dia lakukan?” tanya Pilatus. Tetapi orang banyak itu bahkan berteriak lebih keras lagi, “Salibkan Dia!” ");
INSERT INTO indags_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ketika Pilatus melihat bahwa tidak mungkin baginya untuk membebaskan Yesus, dan bahwa akan ada kerusuhan yang timbul, maka Pilatus mengambil air dan mencuci tangannya di hadapan orang banyak itu. “Aku tidak bersalah atas nyawa orang ini. Nyawa orang ini adalah tanggung jawab kalian!” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Semua orang itu menjawab, “Biarlah kesalahan atas kematiannya ditanggung oleh kami, dan juga oleh anak-anak kami!” ");
INSERT INTO indags_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Maka Pilatus melepaskan Barabas bagi mereka, tetapi ia menyuruh agar Yesus dicambuk dan diserahkan untuk disalibkan. ");
INSERT INTO indags_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Prajurit-prajurit yang bekerja untuk Pilatus membawa Yesus ke markas militer dan seluruh pasukan mengelilingi Dia. ");
INSERT INTO indags_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mereka melucuti pakaian-Nya dan memakaikan jubah berwarna merah ke atas-Nya. ");
INSERT INTO indags_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Juga membuat sebuah mahkota dari tanaman berduri dan meletakkannya di atas kepala-Nya, serta memaksa-Nya memegang sebatang tongkat. Lalu mereka bersujud di hadapan-Nya dan mengejek Dia, “Kami salut padamu, hai Raja orang Yahudi!” ");
INSERT INTO indags_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lalu mereka meludahi Dia, mengambil tongkat yang ada di tangan-Nya, dan memukul kepala-Nya dengan tongkat itu. ");
INSERT INTO indags_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ketika mereka selesai mengolok-olok Dia, mereka menanggalkan jubah yang mereka letakkan dan mengembalikan pakaian-Nya kembali. Lalu membawa Dia untuk disalibkan. ");
INSERT INTO indags_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dalam perjalanan menuju tempat penyaliban, mereka menemukan seorang yang bernama Simon, yang berasal dari Kirene, dan memaksanya untuk memikul salib yang akan dipakai untuk menyalibkan Yesus. ");
INSERT INTO indags_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ketika mereka tiba Golgota, yang berarti “Tempat Tengkorak,” ");
INSERT INTO indags_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","mereka memberi Yesus anggur yang dicampur dengan sesuatu yang pahit seperti empedu. Ketika Yesus mencicipinya, Dia menolak untuk meminumnya. ");
INSERT INTO indags_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sesudah mereka selesai menyalibkan Dia, mereka membuang undi untuk membagi-bagikan pakaian-Nya di antara mereka. ");
INSERT INTO indags_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lalu mereka duduk dan terus menjaga Dia di situ. ");
INSERT INTO indags_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mereka memasang tanda di atas kepalanya dengan tuduhan terhadapnya. Di situ tertulis, “Yesus, Raja orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ada dua penjahat yang juga disalibkan bersama-sama dengan Yesus, satu di sebelah kanan-Nya, dan satu di sebelah kiri-Nya. ");
INSERT INTO indags_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Orang-orang yang lewat di situ juga meneriakkan kata-kata hinaan kepada Yesus dan menggelengkan kepala mereka, ");
INSERT INTO indags_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","serta berkata, “Engkau berkata bahwa Engkau sanggup menghancurkan rumah Tuhan dan membangunnya kembali dalam waktu tiga hari, lalu mengapa Engkau tidak menyelamatkan diri-Mu sendiri?! Jika Engkau benar-benar Anak Allah yang sejati, turunlah dari salib itu.” ");
INSERT INTO indags_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Para imam kepala juga mengejek Dia, bersama-sama dengan para pengajar dan pemimpin orang Israel. ");
INSERT INTO indags_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Dia sudah menyelamatkan orang lain, tetapi diri-Nya sendiri tidak bisa Dia selamatkan!” kata mereka. “Jika Dia benar-benar Raja orang Israel, biarlah Dia turun dari salib itu, dan kita akan percaya kepada-Nya! ");
INSERT INTO indags_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Karena Dia sangat percaya kepada Allah — biarlah Allah saja yang menyelamatkan Dia sekarang, jika Allah mau, sebab Dia sudah menyatakan, ‘Aku adalah Anak Allah.’” ");
INSERT INTO indags_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Para penjahat yang disalibkan bersama-sama dengan Yesus juga menghina-Nya. ");
INSERT INTO indags_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dari tengah hari sampai jam tiga sore kegelapan meliputi seluruh negeri. ");
INSERT INTO indags_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sekitar jam tiga sore, Yesus tiba-tiba berseru dengan suara keras, “Eli, Eli, lama sabaktani?” yang artinya, “Allahku, Allaku, mengapa Engkau meninggalkan aku?” ");
INSERT INTO indags_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ketika mereka yang sedang ada di sekitar situ mendengarnya, mereka berkata, “Dia berseru memanggil Elia!” ");
INSERT INTO indags_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dengan segera salah seorang dari mereka berlari dan mengambil spons, mencelupkannya ke dalam larutan cuka, menusukan spons itu ke sebuah tongkat, dan menjulurkannya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tetapi yang lain berkata, “Tinggalkan dia sendiri. Mari lihat apakah Elia akan datang dan menyelamatkan Dia.” ");
INSERT INTO indags_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus kembali berseru dengan suara keras, dan menghembuskan nafas-Nya yang terakhir. ");
INSERT INTO indags_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tepat ketika itu juga, kain pembagi yang membagi ruangan kudus dengan maha kudus yang ada di rumah Tuhan robek dari atas sampai ke bawah. Tanah bergoncang, bumi terbelah, ");
INSERT INTO indags_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","dan kubur-kubur banyak yang terbuka. Banyak dari mereka yang dahulunya hidup dengan baik dan sudah meninggal, dibangkitkan dari kematian. ");
INSERT INTO indags_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sesudah kebangkitan Yesus mereka yang keluar dari kuburnya masing-masing masuk ke kota Yerusalem dan orang banyak yang menyaksikan mereka. ");
INSERT INTO indags_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ketika kepala pasukan dan para prajurit yang bersama dengan dia menjaga Yesus, melihat gempa bumi dan kejadian yang sedang berlangsung, mereka ketakutan dan berkata, “Sungguh Dia ini memang Anak Allah!” ");
INSERT INTO indags_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Banyak wanita yang juga mengamati peristiwa itu dari kejauhan, mereka yang mengikuti dan mendukung Yesus mulai dari Galelia. ");
INSERT INTO indags_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Termasuk Maria Magdalena, Maria ibu Yakobus dan Yusuf, dan istri dari Zebedeus. ");
INSERT INTO indags_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ketika sore tiba, seorang kaya yang bernama Yusuf, yang berasal dari Arimatea, yang juga salah seorang murid Yesus, ");
INSERT INTO indags_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","pergi menemui Pilatus dan minta mayat Yesus. Pilatus memerintahkan agar mayat Yesus diserahkan keapda Yusuf. ");
INSERT INTO indags_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuf mengambil mayat itu dan membungkusnya dengan kain linen yang masih baru, ");
INSERT INTO indags_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","dan meletakkan mayat itu dalam sebuah kubur yang baru, yang dipotong dari batu padat. Lalu Yusuf memerintahkan agar sebuah batu besar digulingkan ke mulut gua itu, lalu dia pulang. ");
INSERT INTO indags_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena dan Maria yang lainnya sedang ada disitu, duduk di seberang kuburan itu. ");
INSERT INTO indags_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Keesokan harinya, setelah hari Persiapan, sesudah hari persiapan, para imam kepala dan orang Farisi pergi menemui Pilatus. ");
INSERT INTO indags_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Berkatalah mereka kepada dia, “Pak, kami ingat bahwa si penghasut itu berkata, ketika Dia masih hidup, ‘Sesudah tiga hari, Aku akan bangkit kembali.’ ");
INSERT INTO indags_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maka berikanlah perintah agar kuburan itu dijaga sampai pada hari yang ketiga. Dengan demikian murid-murid-Nya tidak bisa datang dan mencuri tubuh-Nya, dan mengatakan kepada orang-orang bahwa Dia sudah bangkit dari antara yang mati, dan penipuan ini pada akhirnya akan menjadi lebih buruk dari awalnya.” ");
INSERT INTO indags_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Aku akan memberimu penjaga tentarat,” kata Pilatus kepada mereka. “Sekarang pergilah, dan lakukanlah segala sesuatu yang kalian perlukan untuk mengamankan kuburan itu.” ");
INSERT INTO indags_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jadi mereka pergi ke kuburan itu, memberi segel di bagian pintu masuk, dan meletakkan prajurit untuk berjaga-jaga di situ. ");
INSERT INTO indags_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Setelah Sabat, saat fajar pada hari pertama minggu itu, Maria Magdalena dan Maria yang lain pergi mengunjungi kuburan itu. ");
INSERT INTO indags_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tiba-tiba terjadi gempa bumi yang dahsyat, sebab seorang malaikat Tuhan turun dari surga dan menggulingkan batu itu serta duduk di atasnya. ");
INSERT INTO indags_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wajahnya bersinar seperti kilat, dan pakaiannya seputih salju. ");
INSERT INTO indags_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Para penjaga gemetar ketakutan, jatuh rebah seakan-akan mereka sudah mati. ");
INSERT INTO indags_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaikat itu berkata kepada para perempuan itu, “Jangan takut! Aku tahu kalian mencari Yesus yang sudah disalibkan itu. ");
INSERT INTO indags_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dia tidak ada disini. Dia sudah bangkit dari kematian, seperti yang sudah Dia katakan. Mari dan lihatlah tempat Tuhan dahulu diletakkan. ");
INSERT INTO indags_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sekarang, pergilah cepat, dan katakan kepada murid-murid-Nya bahwa Dia sudah bangkit dari kematian dan Dia akan pergi mendahului kalian ke Galilea. Kalian akan bertemu dengan Dia disana!” ");
INSERT INTO indags_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dengan segera mereka meninggalkan kuburan itu, merasa takut sekaligus gembira, berlari memberitahu kejadian itu kepada murid-murid Yesus. ");
INSERT INTO indags_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tiba-tiba Yesus datang menemui dan menyapa mereka. Dengan segera mereka menghampiri Yesus, memegang kaki-Nya dan menyembah Dia. ");
INSERT INTO indags_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Berkatalah Yesus kepada mereka, “Jangan takut! Pergi dan katakanlah kepada saudara-saudara-Ku untuk berangkat ke Galilea, dan mereka akan bertemu dengan-Ku di sana.” ");
INSERT INTO indags_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sementara mereka pergi, beberapa penjaga masuk ke kota dan melaporkan kepada para imam kepala segala sesuatu yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sesudah para imam kepala bertemu dengan para pemimpin bangsa Israel, mereka bersepakat menjalankan sebuah rencana. Mereka menyuap para penjaga itu dengan banyak uang. ");
INSERT INTO indags_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Sebarkanlah berita ini, bahwa murid-murid Yesus datang di waktu malam dan mencuri mayat-Nya ketika kami sedang tertidur,” kata mereka kepada para prajurit. ");
INSERT INTO indags_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Dan jika Gubernur mendengar berita ini, kami akan bicara dengan dia, kalian tidak perlu kuatir.” ");
INSERT INTO indags_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jadi para prajurit itu menerima uang suap itu, dan melakukan apa yang diperintahkan. Cerita inilah yang menyebar di antara orang Yahudi bahkan sampai ke hari ini. ");
INSERT INTO indags_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tetapi ke sebelas murid Yesus pergi ke Galilea, ke tempat yang sudah Yesus katakan kepada mereka di atas sebuah gunung. ");
INSERT INTO indags_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ketika mereka melihat Dia, sujudlah mereka menyembah-Nya, sekalipun ada di antara mereka yang ragu-ragu. ");
INSERT INTO indags_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus menghampiri mereka yang masih ragu-ragu dan berkata, “Semua kuasa yang ada di bumi dan di surga sudah diserahkan kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maka itu pergilah, dan muridkanlah orang-orang dari segala bangsa, dan baptislah mereka dalam nama Bapa dan Anak dan Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ajarlah mereka untuk mengikuti semua perintah yang sudah Aku berikan kepada kalian. Dan ingatlah ini, bahwa Aku selalu bersama dengan kalian, sampai dunia ini berakhir.” ");
INSERT INTO indags_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inilah awal dari Kabar Baik tentang Yesus Kristus, Anak Allah. ");
INSERT INTO indags_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Seperti yang nabi Yesaya menulis, “Aku mengirim utusan-Ku sebelum Kamu untuk mempersiapkan jalan-Mu. ");
INSERT INTO indags_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ada suara yang berseru di padang gurun, ‘Persiapkan jalan Tuhan! Buat jalan agar lurus bagi-Nya.’” ");
INSERT INTO indags_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohanes datang dan membaptis di padang gurun, dan berseru, “Bertobatlah dan berilah dirimu dibaptis supaya dosa-dosamu diampuni.” ");
INSERT INTO indags_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Setiap orang dari negara Yudea dan dari Yerusalem pergi kepada Yohanes. Mereka mengakui dosa mereka di depan umum dan dia membaptis mereka di Sungai Yordan. ");
INSERT INTO indags_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes memakai pakaian yang terbuat dari bulu unta, dengan sabuk kulit di pinggangnya. Dia makan belalang dan madu liar. ");
INSERT INTO indags_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Inilah yang dia katakan: “Sesudah saya, akan datang seseorang yang lebih besar dari saya. Saya tidak pantas untuk membungkuk dan melepaskan ikatan sandalnya. ");
INSERT INTO indags_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Saya membaptis kamu dengan air, tetapi Dia akan membaptis dengan Roh Kudus.” ");
INSERT INTO indags_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kemudian Yesus datang dari Nazaret di Galilea dan Yohanes membaptis-Nya di Sungai Yordan. ");
INSERT INTO indags_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sesudah Yesus keluar dari air, Dia melihat langit terbelah dan Roh seperti seekor merpati turun ke atas-Nya. ");
INSERT INTO indags_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Terdengar suara dari surga berkata, “Engkau adalah Anak-Ku yang Ku-kasihi, Aku senang kepada-Mu.” ");
INSERT INTO indags_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sesudah itu Roh Allah membawa Yesus ke padang gurun. ");
INSERT INTO indags_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesus dicobai oleh Satan selama empat puluh hari. Dia tinggal di antara binatang liar, dan para malaikat melayani Dia. ");
INSERT INTO indags_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kemudian, sesudah Yohanes Pembaptis dipenjarakan, Yesus pergi ke Galilea dan mengajar tentang Kabar Baik di sana. ");
INSERT INTO indags_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesus berkata, “Bertobatlah dan percayalah kepada Kabar Baik, karena kerajaan Allah sudah datang.” ");
INSERT INTO indags_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ketika Yesus berjalan di pinggir danau Galilea, Dia melihat Simon dan saudaranya Andreas sedang melemparkan jala ke air, karena mereka mencari nafkah dengan memancing. ");
INSERT INTO indags_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lalu Yesus berkata kepada mereka, “Mari ikut Aku. Kamu akan Ku-jadikan penjala manusia.” ");
INSERT INTO indags_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mereka meninggalkan jala dan langsung mengikuti Yesus. ");
INSERT INTO indags_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus berjalan sedikit jauh dan melihat Yakobus dan saudaranya Yohanes, anak-anak Zebedeus. Mereka sedang memperbaiki jala dalam perahu. ");
INSERT INTO indags_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lalu Yesus memanggil mereka untuk mengikut Dia, dan mereka meninggalkan bapak mereka di dalam perahu, dan mengikut Yesus. ");
INSERT INTO indags_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kemudian mereka pergi ke Kapernaum, dan pada hari Sabat Yesus masuk ke rumah pertemuan orang Yahudi dan mengajar di situ. ");
INSERT INTO indags_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Semua orang yang mendengar pengajaran-Nya merasa kagum pada-Nya, karena Yesus berbicara dengan otoritas, tidak seperti yang diajarkan oleh guru-guru agama Yahudi. ");
INSERT INTO indags_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tiba-tiba, di rumah pertemuan, seorang laki-laki yang dikuasai roh jahat mulai berteriak, ");
INSERT INTO indags_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus dari Nasaret, mengapa kamu mengganggu kami? Apakah kamu datang untuk menghancurkan kami? Saya tahu siapa kamu! Kamu adalah Yang Kudus dari Allah!” ");
INSERT INTO indags_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus menyela roh jahat itu, mengatakan kepadanya, “Diam! Keluarlah dari orang itu.” ");
INSERT INTO indags_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Roh jahat itu menjerit, membuat laki-laki itu kejang-kejang, dan keluar dari dirinya. ");
INSERT INTO indags_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Semua orang yang melihat kejadian itu menjadi heran dan bertanya satu sama lain, “Apa ini? Ajaran baru apakah yang memiliki otoritas seperti itu? Bahkan roh jahat melakukan apa yang diperintahkan!” ");
INSERT INTO indags_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Berita tentang Yesus menyebar dengan cepat ke seluruh wilayah Galilea. ");
INSERT INTO indags_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kemudian mereka meninggalkan rumah pertemuan orang Yahudi dan pergi ke rumah Simon dan Andreas, bersama dengan Yakobus dan Yohanes. ");
INSERT INTO indags_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ibu mertua Simon sedang terbaring di tempat tidur karena sakit demam, jadi mereka memberitahu Yesus tentang dia. ");
INSERT INTO indags_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kemudian Yesus datang kepadanya dan memegang tangannya, lalu membantunya untuk berdiri. Pada waktu itu juga demamnya hilang. Lalu dia membuatkan mereka makanan. ");
INSERT INTO indags_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ketika hari mulai sore, saat matahari mulai terbenam, penduduk di kota itu membawa orang-orang yang sakit dan kerasukan setan kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Seluruh penduduk di kota itu berkumpul di depan rumah. ");
INSERT INTO indags_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lalu Yesus menyembuhkan banyak orang yang menderita berbagai penyakit, dan mengusir setan-setan yang menguasai banyak orang. Yesus tidak mengizinkan setan-setan berbicara, karena roh-roh itu tahu siapa Dia. ");
INSERT INTO indags_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagi-pagi sekali, saat hari masih gelap, Yesus bangun dan pergi sendirian ke tempat yang sunyi untuk berdoa. ");
INSERT INTO indags_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Waktu Simon dan yang lain melihat Yesus tidak ada di dalam rumah itu, mereka pergi mencari-Nya. ");
INSERT INTO indags_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ketika mereka menemukan Yesus, mereka mengatakan kepada-Nya, “Semua orang mencari-Mu.” ");
INSERT INTO indags_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tetapi Yesus menjawab, “Kita harus pergi ke kota-kota lain di sekitar sini agar Aku mengajarkan Kabar Baik juga kepada mereka, karena untuk itulah Aku datang.” ");
INSERT INTO indags_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jadi Yesus pergi ke seluruh Galilea, dan mengajar di rumah-rumah pertemuan orang Yahudi dan mengusir banyak setan dari orang-orang di situ. ");
INSERT INTO indags_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pada waktu itu ada seorang yang sakit kusta datang kepada Yesus. Dia berlutut di hadapan Yesus dan berkata, “Kalau Bapa mau, tolong sembuhkan saya!” ");
INSERT INTO indags_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dengan hati yang penuh belas kasihan, Yesus mengulurkan tangan-Nya dan menjamah laki-laki itu, lalu berkata, “Saya bersedia. Sembuhlah!” ");
INSERT INTO indags_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saat itu juga penyakit kusta hilang, dan orang itu sembuh. ");
INSERT INTO indags_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lalu Yesus menyuruh orang itu pergi dan dengan tegas melarangnya, kata-Nya, ");
INSERT INTO indags_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Pastikan bahwa kamu tidak memberitahu siapa pun tentang apa yang terjadi kepadamu. Pergi ke pendeta dan tunjukkan dirimu padanya. Berikan persembahan yang diwajibkan dalam hukum Taurat untuk setiap orang yang sudah disembuhkan dari penyakit kusta, supaya setiap orang yang melihatmu tahu bahwa kamu benar-benar sudah sembuh.” ");
INSERT INTO indags_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tetapi orang yang sudah sembuh dari sakit kusta itu keluar dan menceritakan kepada semua orang apa yang sudah terjadi. Akibatnya Yesus tidak bisa lagi secara terbuka pergi ke kota-kota, tetapi Yesus harus tinggal di luar kota-kota, dan orang-orang datang kepada-Nya dari mana-mana. ");
INSERT INTO indags_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Beberapa hari kemudian Yesus kembali lagi ke Kapernaum, dan dengan cepat tersebar berita bahwa Yesus sudah kembali. ");
INSERT INTO indags_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Begitu banyak orang datang dan berkumpul di dalam rumah untuk mendengar Yesus mengajar tentang Kabar Baik, sehingga penuh sesak, bahkan di depan pintu juga tidak ada tempat untuk berdiri. ");
INSERT INTO indags_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sementara itu, ada empat orang membawa orang lumpuh, ");
INSERT INTO indags_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","tetapi mereka tidak dapat mendekati Yesus karena orang banyak. Jadi mereka naik ke atap dan membongkarnya. Setelah mereka membuat lubang di atas Yesus, mereka menurunkan tikar dengan orang lumpuh itu berbaring di atasnya. ");
INSERT INTO indags_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ketika Yesus melihat iman yang dimiliki orang-orang ini, Yesus berkata kepada orang lumpuh itu, “Teman, dosamu sudah diampuni.” ");
INSERT INTO indags_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tetapi ada beberapa guru agama Yahudi yang duduk di sana berpikir, ");
INSERT INTO indags_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kenapa dia berbicara seperti ini? Dia menghina Allah! Siapa yang bisa mengampuni dosa? Hanya Allah yang bisa melakukan itu!” ");
INSERT INTO indags_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesus langsung tahu apa yang mereka pikirkan. Dia berkata kepada mereka, “Mengapa kamu berpikir seperti ini? ");
INSERT INTO indags_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Apa yang lebih mudah: mengatakan kepada orang lumpuh, ‘Dosa-dosamu sudah diampuni,’ atau ‘Bangun, angkatlah tikarmu dan pulanglah’? ");
INSERT INTO indags_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tetapi untuk meyakinkan kalian bahwa Anak Manusia berhak untuk mengampuni dosa, ");
INSERT INTO indags_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Aku berkata kepadamu (orang yang lumpuh), ‘Bangunlah, ambil tikarmu, dan pulanglah ke rumahmu.’” ");
INSERT INTO indags_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orang itu berdiri, dia mengambil tikarnya, dan berjalan keluar di depan semua orang di sana. Mereka semua terheran-heran sambil memuji Allah, dan berkata “Kami belum pernah melihat yang seperti ini!” ");
INSERT INTO indags_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Waktu Yesus kembali lagi ke pantai Danau Galilea, banyak orang yang datang kepada-Nya, lalu Dia mengajar mereka. ");
INSERT INTO indags_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Saat Yesus berjalan, dia melihat Lewi anak laki-laki Alfeus, duduk di tempat pemungut cukai, keturunan Lewi sedang duduk di tempat kerjanya. Lalu Yesus mendekati dia dan berkata, “Mari, ikutlah Aku.” Waktu itu juga Matius berdiri dan mengikut Yesus. ");
INSERT INTO indags_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Malam itu Yesus makan malam di rumah Lewi. Banyak pemungut cukai dan “orang berdosa,” bergabung dengan Yesus dan murid-murid-Nya untuk makan, karena ada banyak dari orang-orang ini yang mengikuti Yesus. ");
INSERT INTO indags_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ketika para pemimpin agama dari orang-orang Farisi melihat Yesus makan dengan orang-orang seperti itu, mereka bertanya kepada murid-murid Yesus, “Mengapa Dia makan dengan pemungut pajak dan orang berdosa?” ");
INSERT INTO indags_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ketika Yesus mendengar hal ini, Dia berkata kepada mereka, “Bukan orang sehat yang membutuhkan dokter, tetapi mereka yang sakit. Aku tidak datang untuk mengundang mereka yang melakukan apa yang benar, tetapi Aku datang untuk orang-orang berdosa supaya mereka bertobat.” ");
INSERT INTO indags_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pada waktu itu murid-murid Yohanes dan orang Farisi sedang berpuasa. Jadi beberapa dari mereka datang kepada Yesus, dan bertanya kepada-Nya, “Mengapa murid-murid Yohanes dan orang Farisi berpuasa, tetapi murid-murid-Mu tidak?” ");
INSERT INTO indags_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lalu Yesus berkata kepada mereka, “Tidak ada tamu-tamu dalam pesta pernikahan yang berpuasa saat pengantin laki-laki masih bersama mereka. Begitu juga selama Aku masih bersama murid-murid-Ku, mereka tidak akan berpuasa. ");
INSERT INTO indags_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tetapi akan tiba saatnya mempelai laki-laki akan diambil dari mereka, dan kemudian mereka akan berpuasa. ");
INSERT INTO indags_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kalau orang yang mempunyai baju lama yang robek, dia tidak bisa menambal baju itu dengan kain yang baru. Karena kain baru itu akan menyusut dari yang lama ketika dicuci, dan bagian yang robek itu akan semakin robek lagi. ");
INSERT INTO indags_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tidak ada yang memasukkan anggur baru ke dalam kantong kulit yang lama. Kalau tidak, anggur itu akan mengoyak kantong-kantong anggur, dan anggur dan kantong-kantong itu akan terbuang sia-sia. Tidak. Kalian memasukkan anggur baru ke dalam kantong kulit yang baru.” ");
INSERT INTO indags_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kemudian pada hari Sabat ketika Yesus berjalan bersama murid-murid-Nya melalui ladang gandum, murid-murid-Nya merasa lapar lalu mereka mulai memetik bulir-bulir gandum saat mereka berjalan. ");
INSERT INTO indags_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pada waktu orang-orang Farisi melihat hal itu, mereka bertanya kepada Yesus, “Kenapa murid-murid-Mu melakukan apa yang tidak diizinkan pada hari Sabat?” ");
INSERT INTO indags_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lalu Yesus menjawab mereka, “Pernahkah kamu membaca apa yang Daud lakukan ketika dia dan orang-orang yang mengikutinya merasa lapar dan membutuhkan makanan?” ");
INSERT INTO indags_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dia pergi ke rumah Tuhan ketika Abyatar menjadi imam besar, dan makan roti yang dikuduskan yang tidak boleh dimakan oleh siapa pun kecuali para imam, dan juga memberikannya kepada anak buahnya. ");
INSERT INTO indags_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Sabat dibuat untuk manfaat kalian. Itu tidak dibuat bagi kalian untuk memberi manfaat hari Sabat,” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“Jadi Anak Manusia adalah Tuhan atas hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus pergi ke rumah pertemuan orang Yahudi lagi. Ada seorang laki-laki yang salah satu tangannya lumpuh. ");
INSERT INTO indags_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Beberapa dari mereka di sana melihat Yesus untuk melihat apakah Dia akan menyembuhkan orang pada hari Sabat karena mereka sedang mencari alasan untuk menuduh-Nya melanggar hukum. ");
INSERT INTO indags_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus memanggil laki-laki yang tangannya lumpuh itu, “Mari berdiri di depan sini.” ");
INSERT INTO indags_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kemudian Yesus bertanya kepada mereka, “Apakah diperbolehkan melakukan yang baik pada hari Sabat, atau melakukan yang jahat? Apakah kamu harus menyelamatkan hidup orang, atau membunuh?” Tetapi mereka tidak menjawab-Nya. ");
INSERT INTO indags_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus melihat ke sekeliling mereka dengan kejengkelan, dan merasa sangat kesal dengan sikap mereka yang keras kepala. Kemudian Yesus berkata kepada laki-laki itu, “Ulurkan tanganmu.” Laki-laki itu mengulurkan tangannya, dan tangannya menjadi sembuh. ");
INSERT INTO indags_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lalu orang-orang Farisi itu pergi dari rumah pertemuan itu, dan segera mereka mulai mengatur rencana dengan kelompok Herodes tentang bagaimana caranya untuk membunuh Yesus. ");
INSERT INTO indags_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sesudah itu Yesus dan para murid-Nya pergi Danau Galilea. Banyak orang yang mengikuti mereka. Mereka datang dari Galilea, Yudea, ");
INSERT INTO indags_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalem, Idumea, dan dari sebelah timur Sungai Yordan. Ada juga yang datang dari daerah sekitar Tirus dan Sidon. Begitu banyak orang yang datang karena mereka sudah mendengar tentang semua hal luar biasa yang Yesus sudah lakukan. ");
INSERT INTO indags_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Begitu banyak orang datang sehingga Yesus menyuruh murid-murid-Nya menyiapkan perahu agar Ia dapat mengajar dari perahu, ");
INSERT INTO indags_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","karena Ia telah menyembuhkan begitu banyak orang sehingga semua orang sakit terus mendesak ke arah-Nya agar dapat menyentuh-Nya. ");
INSERT INTO indags_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Setiap kali roh-roh jahat melihat-Nya, mereka akan sujud di hadapan-Nya dan berteriak, “Engkau adalah Anak Allah!” ");
INSERT INTO indags_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tetapi Yesus melarang roh-roh jahat itu untuk tidak memberitahukan tentang siapa Dia. ");
INSERT INTO indags_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kemudian Yesus naik ke bukit. Lalu Dia memanggil dua belas orang yang sudah dipilih-Nya. ");
INSERT INTO indags_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yesus memilih dua belas murid untuk bersama-Nya, dan mengangkat mereka sebagai rasul-rasul-Nya. Mereka akan bersama dengan Yesus, dan mereka akan diutus untuk memberitakan Kabar Baik, ");
INSERT INTO indags_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dan dengan kuasa untuk mengusir setan. ");
INSERT INTO indags_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ini adalah nama-nama kedua belas rasul yang dipilih itu, Simon, yang dipanggil Petrus, ");
INSERT INTO indags_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus anak Zebedeus dan saudaranya Yohanes yang disebut Boanerges, yang berarti “anak-anak guntur” ");
INSERT INTO indags_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Dan juga ada Andreas, Filipus, Bartolomeus, Matius, Thomas, Yakobus anak dari Alfeus, Tadeus, dan Simon orang Kanaan, ");
INSERT INTO indags_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dan Yudas Iskariot yang kemudian mengkhianati Yesus. ");
INSERT INTO indags_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus pulang, tetapi begitu banyak orang berkumpul lagi sehingga Dia dan murid-murid-Nya bahkan tidak punya waktu untuk makan. ");
INSERT INTO indags_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ketika keluarga Yesus mendengar tentang hal itu, mereka datang untuk membawanya pergi, dengan mengatakan, “Dia kehilangan akal sehatnya!” ");
INSERT INTO indags_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tetapi ada para pemimpin agama yang datang dari Yerusalem, berkata, “Dia dirasuki oleh iblis yaitu Beelzebul, pemimpin para setan yang memberi kuasa untuk mengusir setan-setan!” ");
INSERT INTO indags_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tetapi Yesus memanggil orang banyak itu berkumpul, dan mulai mengajar mereka dengan menggunakan beberapa ilustrasi. “Bagaimana setan bisa mengusir setan? ");
INSERT INTO indags_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jika satu negara saling berperang, maka negara itu akan hancur. ");
INSERT INTO indags_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Rumah tangga yang terpecah akan hancur. ");
INSERT INTO indags_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jika setan terpecah belah dan bertarung melawan dirinya sendiri, dia tidak akan bertahan lama — dia akan segera berakhir. ");
INSERT INTO indags_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Begitu juga, jika ada orang yang mau mencuri di rumah seseorang yang kuat dan mencoba untuk mengambil barang-barangnya, dia tidak akan masuk langsung tetapi sebelumnya dia harus mengikat terlebih dahulu orang yang kuat itu.” ");
INSERT INTO indags_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Apa yang Aku katakan ini benar, semua dosa dan penistaan bisa diampuni, ");
INSERT INTO indags_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tetapi orang yang melakukan penistaan dengan menolak Roh Kudus tidak akan pernah diampuni. Mereka bersalah atas dosa abadi.” ");
INSERT INTO indags_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus berkata begitu karena orang-orang telah berkata, “Dia sudah dikuasai oleh roh jahat.” ");
INSERT INTO indags_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Waktu itu ibu dan saudara-saudara Yesus tiba di rumah itu. Mereka menunggu di luar dan mengiriminya pesan, memintanya untuk keluar. ");
INSERT INTO indags_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesus sedang duduk di rumah itu dan dikeliling orang banyak. Lalu ada orang yang menyampaikan kepada-Nya, “Ibu dan saudara-saudari-Mu mau bertemu, mereka sedang menunggu di luar.” ");
INSERT INTO indags_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tetapi Yesus menjawab, “Siapa ibuku? Siapa saudara-saudaraku?” ");
INSERT INTO indags_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lalu Yesus memandang orang-orang yang duduk di sekitar-Nya dan berkata, “Orang-orang seperti ini yang Aku anggap sebagai ibu-Ku dan saudara-saudari-Ku! ");
INSERT INTO indags_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Setiap orang yang melakukan apa yang Allah inginkan, mereka adalah saudara-Ku, dan saudari-Ku, dan ibu-Ku.” ");
INSERT INTO indags_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus mulai mengajar lagi di pinggir pantai. Dan banyak sekali orang yang datang untuk mendengarkan pengajaran-Nya sehingga Dia harus naik ke perahu dan mulai mengajar, sementara orang banyak mendengarkan dari pantai. ");
INSERT INTO indags_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesus mengajar banyak hal dengan menggunakan ilustrasi. ");
INSERT INTO indags_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dengarkan baik-baik,” kata Yesus. “Pada suatu hari seorang penabur pergi untuk menabur bibit di ladang. ");
INSERT INTO indags_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ketika dia sedang menabur bibit, sebagian jatuh di jalan, dan burung-burung datang lalu memakannya sampai habis. ");
INSERT INTO indags_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bibit lain jatuh di tanah berbatu di mana tidak ada banyak tanah. Lalu tunas bibit itu tumbuh dengan cepat, karena tanahnya tipis. ");
INSERT INTO indags_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Waktu sinar matahari mulai panas, tunas-tunas itu menjadi layu dan kering karena akarnya tidak masuk dalam tanah. ");
INSERT INTO indags_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bibit lainnya jatuh di antara rumput berduri. Rumput duri itu tumbuh dan menghambat tunas itu, sehingga tidak menghasilkan buah. ");
INSERT INTO indags_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bibit lain jatuh di tanah yang subur, bibit itu bertunas, tumbuh dan berbuah. Pohonnya menghasilkan buah sekitar tiga puluh, enam puluh, dan seratus. ");
INSERT INTO indags_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jika kamu memiliki telinga untuk mendengar, dengarkan apa yang Aku katakan.” ");
INSERT INTO indags_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ketika Yesus sedang sendirian, kedua belas murid-Nya dan orang lain yang bersama-Nya bertanya kepada Nya apa arti ilustrasi itu. ");
INSERT INTO indags_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lalu Yesus berkata kepada mereka, “Rahasia tentang kerajaan Allah sudah diberikan kepada kalian untuk dipahami. Tetapi orang lain, Aku mengajarkan lewat ilustrasi, ");
INSERT INTO indags_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sehingga meskipun mereka melihat, mereka tidak benar-benar ‘melihat’, dan meskipun mereka mendengar, mereka tidak mengerti, supaya jangan sampai mereka berbalik kepada-Ku dan Aku mengampuni dosa-dosa mereka.” ");
INSERT INTO indags_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Apakah kalian tidak mengerti cerita ini?” Yesus bertanya kepada mereka. “Jika kalian tidak bisa mengerti, bagaimana kalian akan mengerti ilustrasi yang lainnya? ");
INSERT INTO indags_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Penabur menabur Firman. ");
INSERT INTO indags_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bibit yang jatuh di jalan, gambaran orang-orang yang mendengar pesan, tetapi iblis datang dan mencuri Firman itu dari hati mereka. ");
INSERT INTO indags_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Begitu juga dengan bibit yang jatuh di atas tanah berbatu, gambaran orang-orang yang mendengar Firman itu, dan dengan senang hati menerimanya segera. ");
INSERT INTO indags_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tetapi karena Firman itu tidak berakar dengan baik dalam hati mereka, jadi mereka tidak dapat bertahan lama ketika menghadapi masalah atau penganiayaan, mereka akan cepat menyerah. ");
INSERT INTO indags_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yang ditabur di antara rumput berduri, gambaran orang-orang yang mendengar Firman, ");
INSERT INTO indags_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tetapi kekuatiran dunia ini, godaan kekayaan, dan gangguan lain menghambat pertumbuhan Firman, dan menjadi tidak produktif. ");
INSERT INTO indags_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tetapi bibit yang ditabur di tanah yang baik, gambaran orang-orang yang mendengar Firman, menerimanya dengan sepenuh hati, dan mereka produktif — seperti tanah yang subur, yang menghasil buah yang banyak, tiga puluh, enam puluh, dan seratus kali lipat.” ");
INSERT INTO indags_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lalu Yesus mengajar lagi kata-Nya, “Tidak ada orang yang menaruh pelita yang menyala di bawah ember, atau di atas tempat tidur. ");
INSERT INTO indags_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Segala sesuatu yang tersembunyi akan terbuka, dan segala sesuatu yang rahasia akan disingkapkan. ");
INSERT INTO indags_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jika kalian mempunyai telinga, dengarkan apa yang Aku katakan! ");
INSERT INTO indags_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Perhatikan apa yang kalian dengar,” kata Yesus kepada mereka, “Karena kalian akan diberikan sesuai dengan seberapa banyak yang kalian berikan kepada orang lain, demikian juga Allah akan menambahkan lebih banyak lagi kepadamu. ");
INSERT INTO indags_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lebih banyak akan diberikan kepada mereka yang sudah memiliki pemahaman, tetapi mereka yang tidak ingin tahu akan memiliki sedikit pemahaman yang sudah mereka peroleh diambil dari mereka. ");
INSERT INTO indags_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kerajaan Allah seperti orang yang menabur bibit tanaman di tanah,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","“Sesudah menabur, dia pergi dan hidup seperti biasa, hari demi hari, tetapi orang itu tidak memiliki pengetahuan tentang bagaimana bibit tanaman itu bisa bertunas dan tumbuh. ");
INSERT INTO indags_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bumi mengeluarkan hasil buah dengan sendirinya. Pertama-tama muncul pucuk, kemudian bulir biji-bijian, dan kemudian bulir biji-bijian matang. ");
INSERT INTO indags_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ketika buahnya sudah matang, petani akan menuai dengan sabit, karena panennya sudah siap.” ");
INSERT INTO indags_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kemudian Yesus bertanya kepada mereka, “Dengan apa kita bisa membandingkan kerajaan Allah? Perumpamaan apa yang akan kami gunakan?” ");
INSERT INTO indags_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Kerajaan Allah seperti biji sawi, benih terkecil dari semuanya. ");
INSERT INTO indags_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Waktu ditanam, tumbuhan itu akan menjadi tanaman yang lebih besar dari tanaman lain. Dia memiliki cabang yang cukup besar sehingga burung dapat bertengger di tempat teduh.” ");
INSERT INTO indags_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus memakai banyak ilustrasi untuk mengajarkan kepada orang-orang sehingga mereka akan mengerti sebanyak yang mereka bisa. ");
INSERT INTO indags_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesus selalu memakai ilustrasi untuk mengajar orang banyak. Tetapi waktu sendiri, Yesus menjelaskan arti ilustrasi itu kepada para murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Di hari yang sama, ketika sudah malam, Yesus berkata kepada murid-murid-Nya, “Mari kita menyeberang ke seberang danau.” ");
INSERT INTO indags_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lalu Yesus dan murid-murid-Nya meninggalkan orang banyak itu dan naik ke perahu. Sementara itu, ada juga perahu-perahu yang lain mengikuti mereka. ");
INSERT INTO indags_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tiba-tiba angin kencang dan ombak besar datang dan menghantam perahu itu, sehingga perahu itu kemasukan air sampai penuh. ");
INSERT INTO indags_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Waktu itu Yesus sedang tidur di bagian belakang perahu, dengan kepala Dia atas bantal. Murid-murid membangunkan-Nya, sambil berteriak, “Guru, apakah kamu tidak peduli kita akan tenggelam?” ");
INSERT INTO indags_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lalu Yesus bangun. Dia memerintahkan angin danau, “Berhenti dan diamlah!” Saat itu juga angin kencang berhenti dan danau menjadi tenang sekali. ");
INSERT INTO indags_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kemudian Yesus berkata kepada para murid-Nya, “Kenapa kamu begitu ketakutan? Apakah kamu tidak belajar untuk percaya kepada-Ku?” ");
INSERT INTO indags_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mereka tertegun dan benar-benar ketakutan. Dan saling bertanya, “Siapakah orang ini? Bahkan angin dan ombak pun taat kepada-Nya!” ");
INSERT INTO indags_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus dan para murid-Nya tiba di seberang danau di daerah Gadara. ");
INSERT INTO indags_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Waktu Yesus turun dari perahu, seorang laki-laki yang dikuasai oleh roh jahat datang dari kuburan yang ada di dekat pantai itu, untuk menemui Yesus. ");
INSERT INTO indags_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Laki-laki itu tinggal di antara kuburan, dan sudah tidak mungkin lagi mengikat dia, bahkan dengan rantai sekalipun. ");
INSERT INTO indags_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dia sering diikat dengan rantai dan belenggu, tetapi dia bisa memutuskan rantai dan mematahkan belenggu menjadi beberapa bagian. Tidak ada yang memiliki kekuatan untuk menahannya. ");
INSERT INTO indags_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Siang dan malam orang itu selalu berteriak di antara kuburan dan bukit di dekat situ. Dia sering melukai dirinya sendiri dengan batu tajam. ");
INSERT INTO indags_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Waktu dia melihat Yesus dari kejauhan dia berlari dan berlutut di depan-Nya. ");
INSERT INTO indags_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Dengan suara keras orang itu berteriak, “Apa hubungan-Mu dengan saya, Yesus, Anak Allah Yang Mahakuasa? Demi Allah, berjanjilah bahwa kau tidak akan menyiksa saya!” ");
INSERT INTO indags_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Karena Yesus sudah menyuruh roh jahat untuk meninggalkan orang itu. ");
INSERT INTO indags_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kemudian Yesus bertanya kepadanya, “Siapa namamu?” Lalu roh-roh jahat yang ada dalam diri orang itu menjawab, “Nama saya Legiun, karena kami banyak!” ");
INSERT INTO indags_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dan roh-roh jahat itu berulang kali memohon kepada Yesus untuk tidak mengusir mereka keluar jauh dari situ. ");
INSERT INTO indags_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Waktu itu ada sekelompok besar babi sedang makan di lereng bukit di dekat situ. ");
INSERT INTO indags_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lalu roh-roh jahat itu memohon kepada Yesus, “Izinkan kami masuk ke dalam babi-babi itu.” ");
INSERT INTO indags_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus setuju dan mengizinkan roh-roh jahat itu keluar dari laki-laki itu dan masuk ke dalam babi-babi itu. Jumlah bai-babi itu kira-kira dua ribu ekor. Babi-babi itu lari dengan cepat lalu terjun dari pinggir jurang ke dalam danau dan mati tenggelam. ");
INSERT INTO indags_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Waktu para penjaga babi itu melihat apa yang terjadi, mereka melarikan diri, dan menceritakan kejadian itu ke seluruh kota dan daerah sekitarnya. Lalu orang-orang yang mendengar berita itu keluar untuk melihat apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ketika mereka tiba di tempat Yesus berada, mereka melihat orang yang dulu dikuasai roh jahat sedang duduk tenang dan dia sudah berpakaian, dan pikirannya sudah sehat kembali. Melihat kejadian itu mereka pun menjadi takut kepada Yesus! ");
INSERT INTO indags_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Para penjaga babi yang sudah melihat apa yang sudah terjadi pada orang yang dikuasai roh jahat itu, menceritakan kepada orang-orang yang baru datang. ");
INSERT INTO indags_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sesudah itu, mereka memohon kepada Yesus untuk meninggalkan daerah mereka. ");
INSERT INTO indags_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pada waktu Yesus naik ke perahu, laki-laki yang dulu dikuasai oleh roh jahat itu meminta kepada Yesus supaya dia bisa ikut bersama-Nya. ");
INSERT INTO indags_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tetapi Yesus menolak dan berkata kepada orang itu, “Pulanglah dan ceritakan kepada keluargamu dan orang-orang di kampungmu, berapa banyak yang telah Tuhan lakukan untukmu dan betapa dia telah berbelas kasih kepadamu.” ");
INSERT INTO indags_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lalu orang itu pergi dan mulai memberitakan kepada orang-orang di Sepuluh Kota segala sesuatu yang sudah Yesus lakukan untuknya. Dan semua orang yang mendengarkan kesaksian orang itu menjadi heran. ");
INSERT INTO indags_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sesudah itu, Yesus dan para murid-Nya kembali lagi dengan perahu ke sebelah barat Danau Galilea. Waktu mereka tiba, banyak orang datang berkumpul di sekeliling Dia di pinggir danau. ");
INSERT INTO indags_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Seorang pemimpin rumah pertemuan orang Yahudi yang bernama Yairus, datang kepada Yesus. Ketika dia melihat Yesus, dia berlutut di depan kaki-Nya ");
INSERT INTO indags_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dan memohon kepada Yesus, katanya, “Anak perempuan saya yang kecil sakit parah dan hampir mati. Tolong Bapa datang ke rumah saya! Letakkanlah tangan-Mu di atasnya supaya dia sembuh dan tidak mati.” ");
INSERT INTO indags_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jadi Yesus dan para murid-Nya pergi bersamanya. Tetapi semua orang mengikuti mereka bahkan saling berdesakan di sekeliling Yesus. ");
INSERT INTO indags_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Di situ ada seorang perempuan yang sakit pendarahan selama dua belas tahun. ");
INSERT INTO indags_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dia sudah menghabiskan banyak uang untuk bertobat ke banyak dokter. Tetapi tidak ada yang dapat sembuhkan dia, bahkan sakitnya menjadi lebih parah. ");
INSERT INTO indags_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Perempuan itu sudah mendengar tentang Yesus. Jadi dia mengikuti Yesus dari belakang bersama orang banyak dan menyentuh jubah-Nya. ");
INSERT INTO indags_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Dia berkata pada dirinya sendiri, “Jika saya bisa menyentuh saja jubah-Nya, saya pasti sembuh.” ");
INSERT INTO indags_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Waktu dia melakukannya, pendarahannya langsung berhenti, dan dia merasakan tubuhnya sudah sembuh dari penyakitnya. ");
INSERT INTO indags_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Seketika itu Yesus langsung merasakan bahwa ada kekuatan yang keluar dari diri-Nya. Jadi Dia berbalik dan bertanya kepada orang banyak itu, “Siapa yang sudah menyentuh jubah-Ku?” ");
INSERT INTO indags_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tetapi murid-murid-Nya menjawab, “Bapa lihat sendiri, terlalu banyak orang yang berdesak-desakan. Kenapa Bapa tanya siapa yang menyentuh jubah-Mu?” ");
INSERT INTO indags_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tetapi Yesus terus melihat dan mencari orang yang sudah menyentuh jubah-Nya. ");
INSERT INTO indags_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Perempuan itu menyadari bahwa dia sudah sembuh. Lalu dengan gemetar dan takut dia datang dan sujud di depan kaki Yesus dan menceritakan apa yang sudah dia lakukan. ");
INSERT INTO indags_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Maka Yesus berkata kepadanya, “Anak-Ku, karena kamu percaya penuh kepada-Ku, kamu menjadi sembuh. Jadi sekarang, pulanglah dalam damai karena kamu benar-benar sudah sembuh dari penyakitmu itu.” ");
INSERT INTO indags_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ketika Yesus masih berbicara dengan perempuan itu, beberapa orang datang dari rumah Yairus dan berkata kepadanya, “Anak perempuanmu sudah meninggal. Jadi kamu tidak perlu mengganggu Guru lagi.” ");
INSERT INTO indags_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tetapi Yesus tidak peduli apa yang mereka katakan kepada Yairus. Jadi Yesus berkata kepada Yairus, “Jangan takut, tetap saja percaya pada-Ku.” ");
INSERT INTO indags_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Dan Yesus tidak mengizinkan orang lain ikut bersama-Nya, kecuali Petrus, Yakobus, dan Yohanes, saudara laki-laki Yakobus. ");
INSERT INTO indags_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ketika mereka tiba di rumah Yairus, Yesus melihat keadaan di situ sangat ribut karena orang-orang yang sedang menangis dan meratap. ");
INSERT INTO indags_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lalu Yesus masuk dan berkata kepada mereka, “Mengapa kamu ribut dan menangis? Anak itu tidak mati, dia hanya tidur.” ");
INSERT INTO indags_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Orang-orang itu menertawakan Dia. Tetapi Yesus menyuruh semua orang keluar. Kemudian Dia mengajak orang tua anak itu dan ketiga murid-Nya masuk ke dalam kamar di mana anak itu terbaring. ");
INSERT INTO indags_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kemudian Yesus memegang tangan anak itu dan berkata dalam bahasa mereka, “Talita kum,” yang berarti, “Anak perempuan, Aku berkata kepadamu, bangunlah!” ");
INSERT INTO indags_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Anak perempuan itu langsung bangun dan berjalan. Umur anak itu dua belas tahun. Dan semua orang yang berada di situ benar-benar heran dengan apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tetapi Yesus dengan keras melarang mereka untuk tidak menceritakan hal itu kepada orang lain. Lalu Yesus menyuruh orang tua anak itu memberi dia makanan untuk dimakan. ");
INSERT INTO indags_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lalu Yesus meninggalkan dan pulang ke Nazaret bersama murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pada Hari Sabat, Yesus mulai mengajar di rumah pertemuan mereka. Banyak orang merasa heran mendengar Dia mengajar. Lalu mereka berkata satu sama lain, “Dari mana Dia mendapatkan hikmat untuk mengajar kita? Siapa yang memberi kuasa kepada-Nya untuk melakukan banyak keajaiban? ");
INSERT INTO indags_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bukankah Dia ini tukang kayu, anaknya Maria — saudara laki-lakinya Yakobus, Yusuf, Yudas dan Simon? Dan bukankah saudara perempuan-Nya tinggal di sini bersama kita?” Karena mereka sudah tahu siapa Dia, mereka tidak mau percaya dan menolak-Nya. ");
INSERT INTO indags_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lalu Yesus berkata kepada mereka, “Seorang nabi selalu dihormati di mana-mana kecuali di kota asalnya, di antara saudara-saudarinya, dan di dalam keluarganya sendiri,” ");
INSERT INTO indags_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Karena mereka tidak percaya kepada-Nya, Yesus tidak bisa melakukan mujizat di sana, kecuali menyembuhkan beberapa orang sakit. ");
INSERT INTO indags_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesus sangat heran karena mereka tidak percaya kepada-Nya. Lalu Yesus pergi berjalan dari desa yang satu ke desa yang lain di sekitar daerah itu untuk mengajar. ");
INSERT INTO indags_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dia memanggil kedua belas murid, dan mulai mengutus mereka berdua demi dua, memberi mereka otoritas atas roh-roh jahat. ");
INSERT INTO indags_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dia berpesan kepada mereka untuk tidak membawa apapun, baik makanan, tas, maupun uang, kecuali satu tongkat untuk berjalan. ");
INSERT INTO indags_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mereka bisa memakai sandal, tetapi mereka tidak boleh membawa baju ekstra. ");
INSERT INTO indags_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Waktu kamu masuk ke salah satu desa dan ada keluarga yang mengundang kamu untuk menginap di rumahnya, tinggallah di sana sampai kamu pergi meninggalkan desa itu”. ");
INSERT INTO indags_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Tetapi kalau kamu tidak diterima dan tidak didengarkan, kebaskanlah debu dari kaki sebagai tanda peringatan kepada mereka.” ");
INSERT INTO indags_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Lalu murid-murid-Nya pergi berkeliling menyampaikan kepada orang-orang untuk bertobat. ");
INSERT INTO indags_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mereka mengusir banyak setan, dan menyembuhkan banyak orang sakit dengan mengurapi mereka dengan minyak. ");
INSERT INTO indags_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lalu, Raja Herodes mendengar tentang Yesus karena nama-Nya sudah terkenal di mana-mana. Pada waktu itu, Herodes baru saja membunuh Yohanes Pembaptis. Jadi ada orang yang berkata, “Dia ini adalah Yohanes Pembaptis yang sudah bangkit dari kematian. Itulah mengapa Dia melakukan banyak keajaiban.” ");
INSERT INTO indags_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tetapi ada orang lain yang berkata, “Dia adalah nabi Elia.” Dan yang lain lagi berkata, “Dia adalah seorang nabi yang baru, seperti salah satu nabi di masa lalu.” ");
INSERT INTO indags_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tetapi ketika Herodes mendengar tentang hal itu, dia berkata, “Itu pasti Yohanes Pembaptis, orang yang dulu kupotong kepalanya! Sekarang dia sudah hidup kembali!” ");
INSERT INTO indags_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Karena Herodes sudah merampas Herodias, istri saudaranya sendiri, Filipus. ");
INSERT INTO indags_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohanes Pembaptis sudah menegur dia berulang-ulang, “Menikah dengan istri saudara laki-lakimu sendiri adalah melanggar hukum.” ");
INSERT INTO indags_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jadi karena itu Herodias menyimpan dendam terhadap Yohanes Pembaptis dan berusaha mengatur rencana untuk membunuh dia. Tetapi dia tidak bisa mengaturnya ");
INSERT INTO indags_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","karena Herodes tahu bahwa Yohanes Pembaptis adalah orang suci yang melakukan apa yang benar. Herodes melindungi Yohanes dan meskipun apa yang dikatakan Yohanes membuatnya kesal, Herodes tetap senang mendengarkan Yohanes. ");
INSERT INTO indags_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Akhirnya Herodiasmendapat kesempatan pada hari ulang tahun Herodes. Dia memberikan jamuan makan untuk para bangsawan, perwira militer, dan orang-orang penting yang ada di Galilea. ");
INSERT INTO indags_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dalam pesta itu anak perempuan Herodias menari di hadapan Herodes dan semua tamunya. Mereka semua yang makan bersamanya sangat senang dengan penampilannya, jadi Herodes memberi tahu gadis itu, ");
INSERT INTO indags_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Mintalah padaku apa pun yang kamu suka, dan aku akan memberikannya padamu.” Herodes menegaskan janjinya dengan sumpah, “Aku akan memberikan apa pun yang kamu minta, sekalipun itu setengah dari kerajaanku.” ");
INSERT INTO indags_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lalu perempuan itu keluar dan bertanya kepada ibunya, “Apa yang harus saya minta?” Ibunya berkata, “Kepala Yohanes Pembaptis.” ");
INSERT INTO indags_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Langsung perempuan itu cepat-cepat kembali kepada raja Herodes dan berkata, “Saya minta kepala Yohanes Pembaptis sekarang juga, ditaruh di atas piring dan dibawa kemari.” ");
INSERT INTO indags_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Raja sangat sedih, tetapi karena janji yang dibuatnya di depan para tamunya, dia tidak dapat menolaknya. ");
INSERT INTO indags_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jadi Herodes segera menyuruh tentara untuk memotong dan membawa kepala Yohanes di dalam penjara, ");
INSERT INTO indags_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tentara itu membawa kepala Yohanes di atas sebuah piring dan memberikannya kepada perempuan itu, dan perempuan itu menyerahkannya kepada ibunya. ");
INSERT INTO indags_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ketika murid-murid Yohanes mendengar apa yang terjadi, mereka datang dan mengambil mayatnya lalu dikuburkan. ");
INSERT INTO indags_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Waktu para murid yang Yesus utus itu kembali dari perjalanan mereka mengelilingi desa-desa dan menyampaikan Kabar Baik dan berkumpul bersama Yesus, mereka menceritakan semua yang sudah mereka lakukan dan ajarkan. ");
INSERT INTO indags_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","“Mari bersama-Ku, hanya kita saja. Mari kita pergi ke sebuah tempat yang tenang, dan beristirahat untuk sejenak,” kata Yesus kepada mereka, karena begitu banyak orang yang datang dan pergi sehingga tidak cukup waktu bagi mereka bahkan untuk makan. ");
INSERT INTO indags_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jadi mereka pergi dengan perahu ke tempat yang sepi untuk menyendiri. ");
INSERT INTO indags_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tetapi ada orang-orang yang melihat Yesus dan para murid-Nya pergi dan orang-orang itu tahu ke mana tujuan mereka. Jadi orang-orang dari kota-kota sekitarnya berlari dan sampai duluan di sana sebelum Yesus dan para murid-Nya tiba. ");
INSERT INTO indags_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ketika Yesus turun dari perahu dia melihat banyak sekali orang yang sudah kumpul di sana. Dan Yesus merasa kasihan kepada mereka, karena mereka seperti domba yang tidak punya gembala. Lalu Yesus mulai mengajari mereka tentang banyak hal. ");
INSERT INTO indags_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ketika hari mulai gelap, murid-murid Yesus datang dan berkata kepada-Nya, “Sekarang hari sudah mulai gelap, dan tempat ini adalah daerah terpencil. ");
INSERT INTO indags_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jadi lebih baik kita menyuruh mereka untuk pergi dan membeli sendiri sesuatu di rumah-rumah dan desa terdekat, untuk dimakan.” ");
INSERT INTO indags_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tetapi Yesus berkata kepada para murid-Nya, “Kalian yang harus memberi mereka makan.” Tetapi para murid-Nya menjawab, “Kami membutuhkan gaji lebih dari enam bulan untuk membeli makanan bagi semua orang ini.” ");
INSERT INTO indags_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jadi Yesus bertanya, “Berapa banyak roti yang kamu punya? Pergi dan lihat.” Sesudah mereka melihat, lalu berkata kepada-Nya, “Ada lima roti dan dua ikan.” ");
INSERT INTO indags_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kemudian Yesus menyuruh orang banyak itu duduk berkelompok di rumput hijau. ");
INSERT INTO indags_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mereka duduk dalam beberapa kelompok yang terdiri dari seratus orang dan lima puluhan orang. ");
INSERT INTO indags_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kemudian Yesus mengambil lima roti dan dua ikan itu. Memandang ke langit dan mengucap syukur kepada Allah untuk makanan itu. Lalu memecahkan roti menjadi beberapa bagian. Kemudian dia menyerahkan roti kepada para murid-Nya untuk dibagikan kepada orang-orang, dan dia membagi ikan di antara mereka semua. ");
INSERT INTO indags_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Semua orang makan sampai kenyang. ");
INSERT INTO indags_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kemudian mereka mengumpulkan sisa roti dan ikan — ada dua belas keranjang. ");
INSERT INTO indags_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jumlah orang yang ikut makan kira-kira lima ribu orang laki-laki, belum terhitung perempuan dan anak-anak. ");
INSERT INTO indags_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sesudah itu, Yesus langsung menyuruh para murid-Nya untuk naik ke perahu. Mereka harus pergi ke Betsaida di seberang danau sementara itu Yesus menyuruh orang-orang itu pulang. ");
INSERT INTO indags_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Begitu Yesus mengucapkan selamat tinggal kepada mereka, Dia pergi ke bukit untuk berdoa. ");
INSERT INTO indags_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ketika hari sudah malam, para murid-Nya berada dalam perahu itu di tengah danau. Sementara itu Yesus masih di darat sendirian. ");
INSERT INTO indags_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dia sudah melihat mereka susah mendayung karena angin bertiup kencang ke arah mereka. Lalu waktu dini hari Yesus datang kepada mereka, berjalan di atas air. Dia akan melewati mereka, ");
INSERT INTO indags_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","tetapi ketika mereka melihat-Nya berjalan di atas air, mereka berteriak karena mereka mengira Dia adalah hantu. ");
INSERT INTO indags_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Waktu mereka semua bisa melihat-Nya, mereka sangat ketakutan. Yesus langsung memberi tahu mereka: “Jangan khawatir, ini Aku. Jangan takut!” ");
INSERT INTO indags_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesus naik ke perahu, dan angin pun berhenti. Dan mereka sangat heran, ");
INSERT INTO indags_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","karena mereka belum mengerti tentang keajaiban yang Yesus perbuat waktu Dia memberi makan lima ribu orang. Mereka sulit mengerti karena pikiran mereka yang keras kepala masih tertutup. ");
INSERT INTO indags_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sesudah Yesus dan para murid-Nyamenyeberangi danau, mereka tiba di Genesaret dan mengikat perahu. ");
INSERT INTO indags_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Saat mereka turun, orang-orang itu segera mengenali Yesus. ");
INSERT INTO indags_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lalu orang-orang berlari ke setiap daerah untuk menyampaikan bahwa Yesus sudah kembali. Jadi mereka membawa semua orang yang sakit di atas tikar mereka ke tempat di mana mereka mendengar Yesus berada. ");
INSERT INTO indags_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ke mana pun Yesus pergi, di kampung, di kota, atau di pedesaan, mereka meletakkan orang sakit di tempat-tempat umum dan memohon kepada Yesus untuk membiarkan orang sakit menyentuh ujung jubah-Nya saja. Dan setiap orang yang menyentuh-Nya menjadi sembuh. ");
INSERT INTO indags_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pada suatu hari orang Farisi dan pemimpin agama Yahudi datang dari Yerusalem untuk bertemu Yesus. ");
INSERT INTO indags_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mereka melihat beberapa muridnya makan dengan tangan “najis” (artinya tidak dicuci). ");
INSERT INTO indags_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Orang Farisi dan semua orang Yahudi tidak makan sampai mereka mencuci tangan, mengikuti tradisi nenek moyang mereka. ");
INSERT INTO indags_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dengan cara yang sama, mereka tidak makan ketika kembali dari pasar sampai mereka mandi. Mereka menjalankan banyak aturan, seperti mencuci cangkir, cerek, dan kuali. ");
INSERT INTO indags_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jadi orang Farisi dan pemimpin agama bertanya kepada Yesus, “Mengapa murid-murid-Mu tidak mengikuti aturan nenek moyang kita? Mereka makan makanan dengan tangan yang tidak bersih.” ");
INSERT INTO indags_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tetapi Yesus menjawab, “Benar sekali apa yang Yesaya katakan tentang kamu yang hanya berpura-pura sebagai orang baik, katanya, ‘Bangsa ini berkata bahwa mereka menghormati Aku, tetapi hati mereka jauh dari Aku. ");
INSERT INTO indags_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Percuma saja mereka menyembah Aku, karena mereka mengajar orang tentang peraturan-peraturan manusia, dan bukan peraturan-peraturan-Ku.’” ");
INSERT INTO indags_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kata Yesus lagi kepada mereka, “Kalian meninggalkan perintah-perintah Allah, dan sebaliknya kalian hanya mengikuti peraturan manusia dengan hati-hati.” ");
INSERT INTO indags_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lalu kata Yesus kepada mereka, “Kalian sangat pintar mengabaikan peraturan-peraturan Allah dengan berpura-pura, supaya dapat melakukan peraturan manusia! ");
INSERT INTO indags_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sebagai contoh, Musa berkata, ‘Hormatilah ibu dan bapakmu,’ dan ‘Kalau ada orang yang menghina ibu dan bapaknya, dia harus dihukum mati.’ ");
INSERT INTO indags_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tetapi kalian berkata, kalau seseorang memberitahu ibu dan bapaknya, ‘Apa pun yang seharusnya saya berikan kepada ibu dan bapak, tetapi sekarang saya tidak bisa berikan lagi, karena saya sudah berjanji untuk memberikannya sebagai kurban kepada Allah,’ ");
INSERT INTO indags_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","dengan demikian, kalian mengajarkan orang lain untuk tidak lagi menolong orang tua mereka. ");
INSERT INTO indags_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dengan mengikuti peraturan yang diajarkan oleh nenek moyang kita, kalian membuat firman Allah menjadi batal demi hukum. Dan masih banyak lagi yang kalian lakukan seperti ini.” ");
INSERT INTO indags_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus memanggil orang banyak itu lagi dan mengatakan kepada mereka, “Tolong, semua orang dengarkan Aku dan mengerti. ");
INSERT INTO indags_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bukan apa yang masuk ke dalam tubuh kalian yang membuat kalian najis di hadapan Allah. Tetapi, apa yang keluar dari dalam dirimu, itulah yang membuat kamu najis di hadapan Allah.” ");
INSERT INTO indags_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Waktu Yesus meninggalkan orang banyak itu dan masuk ke dalam satu rumah, murid-murid-Nya bertanya tentang arti ilustrasi itu. ");
INSERT INTO indags_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Apa kamu juga tidak mengerti?” dia bertanya kepada mereka. “Tidakkah kamu melihat bahwa apa yang kamu makan tidak membuat kamu najis? ");
INSERT INTO indags_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Makanan itu tidak masuk ke dalam hati dan pikiran kalian, tetapi ke perut kalian, dan kemudian keluar dari tubuh. Jadi semua makanan itu bersih secara seremonial.” ");
INSERT INTO indags_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Tetapi apa yang keluar dari mulut itulah yang membuat seseorang najis! ");
INSERT INTO indags_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Karena dari dalam dirimu yaitu, dari hati dan pikiranmu berasal segala macam keinginan, yaitu: mencuri, membunuh, seks bebas, berzinah, atau perbuatan jahat yang lain. ");
INSERT INTO indags_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Juga iri hati, rakus, suka berbuat jahat, suka menipu, suka menghina, sombong, dan keras kepala. ");
INSERT INTO indags_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Semua kejahatan ini datang dari dalam hati dan pikiran manusia, dan menajiskan orang.” ");
INSERT INTO indags_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lalu Yesus meninggalkan tempat itu dan pergi ke daerah Tirus dan Sidon. Dia tidak ingin ada yang tahu Dia tinggal di sebuah rumah di sana, tetapi Dia tidak bisa menyembunyikan diri-Nya. ");
INSERT INTO indags_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Di situ ada seorang ibu yang anak perempuannya sedang dikuasai roh jahat. Waktu ibu itu mendengar berita bahwa Yesus sudah datang, dia langsung datang dan berlutut di depan kaki Yesus. ");
INSERT INTO indags_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ibu itu bukan orang Yahudi. Dia berasal dari daerah Fenisia di provinsi Siria dan dia berbahasa Yunani. Dia memohon kepada Yesus untuk mengusir roh jahat dari anaknya. ");
INSERT INTO indags_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tetapi kata Yesus kepadanya, “Biarlah anak-anak makan dahulu sampai mereka kenyang. Tidak benar mengambil makanan anak-anak dan membuangnya kepada anjing.” ");
INSERT INTO indags_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Benar, Pak,” kata ibu itu, “Tetapi biasanya anjing di bawah meja memakan sisa makanan yang ditinggalkan anak-anak.” ");
INSERT INTO indags_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lalu Yesus berkata kepadanya, “Karena ibu menjawab seperti itu, ibu boleh pergi. Karena roh jahat itu sudah keluar dari anakmu.” ");
INSERT INTO indags_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ibu itu pulang ke rumah dan melihat anaknya terbaring dengan tenang di tempat tidur, karena roh jahat sudah keluar dari dia. ");
INSERT INTO indags_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sesudah itu Yesus meninggalkan daerah Tirus. Yesus dan murid-murid-Nya berjalan melalui kota Sidon dan pergi ke daerah di dekat Danau Galilea yang disebut Sepuluh Kota. ");
INSERT INTO indags_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Di sana beberapa orang membawa seorang laki-laki yang tuli dan juga tidak bisa berbicara dengan baik. Mereka meminta Yesus untuk meletakkan tangan-Nya ke atas orang itu supaya dia sembuh. ");
INSERT INTO indags_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lalu Yesus membawa orang itu menjauh dari orang banyak. Yesus meletakkan jarinya di telinga orang tuli itu. Kemudian Yesus mengoles ludah-Nya di lidah laki-laki itu. ");
INSERT INTO indags_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lalu Yesus melihat ke atas ke langit dan sambil menghela nafas Dia berkata, “Efata,” yang berarti, “Terbukalah!” ");
INSERT INTO indags_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Saat itu juga telinga laki-laki itu terbuka dan dia bisa mendengar, dan lidahnya menjadi baik sehingga dia mulai berbicara dengan jelas. ");
INSERT INTO indags_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kemudian Yesus dengan tegas memberi mereka perintah supaya tidak memberitahu siapa pun. Tetapi semakin Dia melarang, semakin mereka menyebarkan berita itu. ");
INSERT INTO indags_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Semua orang yang mendengar hal itu menjadi sangat heran dan berkata, “Semua yang Yesus lakukan luar biasa. Dia bahkan membuat orang tuli mendengar, dan orang bisu berbicara.” ");
INSERT INTO indags_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pada hari yang sama, banyak orang datang kembali berkumpul bersama Yesus. Mereka tidak punya apa-apa untuk dimakan. Jadi Yesus memanggil para murid-Nya dan berkata kepada mereka, ");
INSERT INTO indags_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aku merasa kasihan sekali kepada orang banyak karena mereka sudah tinggal bersama-Ku selama tiga hari dan mereka tidak punya apa-apa untuk dimakan. ");
INSERT INTO indags_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kalau Aku menyuruh mereka pulang dalam keadaan lapar, mereka bisa pingsan di jalan, karena ada beberapa orang datang dari jauh.” ");
INSERT INTO indags_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tetapi jawab murid-murid-Nya, “Di tempat sepi seperti ini, tidak mungkin kita bisa membeli roti untuk orang sebanyak ini?” ");
INSERT INTO indags_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Lalu Yesus bertanya kepada mereka, “Ada berapa banyak roti yang kamu punya?” Jawab mereka, “Ada tujuh saja.” ");
INSERT INTO indags_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesus menyuruh orang banyak untuk duduk di tanah. Kemudian dia mengambil tujuh potong roti, dan mengucap syukur. Dia memecahkan roti dan menyerahkan potongan-potongan itu kepada murid-murid-Nya untuk diberikan kepada orang banyak. ");
INSERT INTO indags_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mereka juga memiliki sedikit ikan, jadi sesudah Yesus mengucap syukur atas ikan itu lalu Dia berkata, “Ambil ikan ini dan bagikan juga.” ");
INSERT INTO indags_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mereka makan sampai kenyang, dan kemudian mengumpulkan tujuh keranjang sisa makanan. ");
INSERT INTO indags_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Orang-orang yang makan kira-kira empat ribu. Sesudah itu Yesus menyuruh mereka pulang. ");
INSERT INTO indags_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lalu Yesus naik ke perahu bersama murid-murid-Nya dan pergi ke daerah Dalmanuta. ");
INSERT INTO indags_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Orang-orang Farisi datang dan mulai berdebat dengan-Nya, menginginkan Dia memberi mereka tanda ajaib dari surga, mencoba membuat Dia membuktikan diri-Nya. ");
INSERT INTO indags_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus menghela nafas dalam-dalam, dan bertanya, “Mengapa kalian semua menginginkan tanda? Aku mengatakan yang sebenarnya: Aku tidak akan memberi tanda apapun kepada kalian.” ");
INSERT INTO indags_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sesudah berkata begitu Yesus meninggalkan mereka, dan naik ke perahu bersama para murid-Nya dan kembali ke seberang danau. ");
INSERT INTO indags_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tetapi waktu itu para murid-Nya lupa membawa makanan. Yang mereka miliki di perahu hanyalah satu roti. ");
INSERT INTO indags_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lalu Yesus memberitahu mereka, “Hati-hati terhadap ragi orang Farisi dan Herodes!” ");
INSERT INTO indags_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","“Dia mengatakan itu karena kita tidak punya roti,” mereka menyimpulkan. ");
INSERT INTO indags_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tetapi Yesus sudah tahu apa yang mereka bicarakan. Lalu Yesus berkata kepada mereka, “Mengapa kamu berbicara tentang kekurangan roti!? Apakah kalian masih tidak mengerti? Pikiran kalian sangat tertutup! ");
INSERT INTO indags_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kalian punya mata untuk melihat, bukan? Dan telinga untuk mendengar? ");
INSERT INTO indags_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Apakah kamu tidak ingat ketika Aku membagikan lima roti di antara lima ribu orang? Berapa banyak sisa makanan yang kalian ambil?” “Dua belas keranjang,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Dan ketujuh roti itu dibagi di antara empat ribu orang. Berapa banyak sisa makanan yang kalian ambil?” “Tujuh keranjang penuh,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Apakah kamu masih belum mengerti?” Yesus bertanya kepada para murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Waktu Yesus dan murid-murid-Nya sampai di Betsaida, ada beberapa orang membawa seorang yang buta kepada Yesus. Mereka memohon kepada Yesus untuk menjamah dia supaya menjadi sembuh. ");
INSERT INTO indags_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus memegang tangan orang buta itu dan menuntun ke luar desa. Yesus mengoles mata laki-laki itu dengan ludah-Nya dan menaruh tangan-Nya di mata orang itu. Kemudian Yesus bertanya kepadanya, “Bisakah kamu melihat sesuatu?” ");
INSERT INTO indags_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Laki-laki itu melihat sekeliling, dia berkata, “Saya bisa melihat orang, tetapi mereka terlihat seperti pohon yang berjalan.” ");
INSERT INTO indags_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jadi Yesus meletakkan tangan-Nya lagi pada mata laki-laki itu. Dia bisa melihat dengan baik — dia sembuh dan penglihatannya jernih. ");
INSERT INTO indags_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lalu Yesus menyuruh laki-laki itu pulang ke rumahnya, dan berkata kepadanya, “Jangan kembali melalui kampung ini.” ");
INSERT INTO indags_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sesudah itu Yesus dan murid-murid-Nya pergi ke kampung-kampung di sekitar Kaisarea Filipi. Dalam perjalanan Dia bertanya kepada murid-murid-Nya, “Kata orang, siapa Aku?” ");
INSERT INTO indags_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jawab mereka, “Ada yang mengatakan Engkau sebagai Yohanes Pembaptis, ada beberapa mengatakan Engkau sebagai nabi Elia, yang lain mengatakan Engkau adalah salah satu nabi.” ");
INSERT INTO indags_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lalu Dia bertanya kepada mereka, “Tetapi menurutmu Aku ini siapa?” Petrus menjawab, “Engkau adalah Mesias!” ");
INSERT INTO indags_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesus melarang mereka supaya tidak memberitahukan kepada siapa pun tentang Dia. ");
INSERT INTO indags_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kemudian Yesus mulai mengajarkan kepada para murid-Nya bahwa Anak Manusia akan mengalami banyak penderitaan dan ditolak oleh para penatua, imam-imam kepala, dan guru-guru agama. Dia akan dibunuh, tetapi tiga hari kemudian akan bangkit kembali. ");
INSERT INTO indags_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus mengajarkan dengan jelas hal ini kepada mereka. Tetapi Petrus menarik Yesus ke samping dan mulai menegur Yesus atas apa yang dikatakan-Nya. ");
INSERT INTO indags_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tetapi Yesus berbalik dan memandang murid-murid-Nya, lalu menegur Petrus. “Menjauhlah dari hadapan-Ku, hai Iblis. Kamu tidak berpikir seperti yang Allah pikirkan, tetapi seperti yang dilakukan manusia.” ");
INSERT INTO indags_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesus memanggil orang banyak dan murid-murid-Nya kepada-Nya, dan berkata kepada mereka, “Jika ada di antara kamu yang ingin mengikut Aku, kamu harus menyangkal dirimu, pikul salibmu, dan ikutlah Aku. ");
INSERT INTO indags_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jika kamu ingin menyelamatkan hidup kamu, kamu akan kehilangannya, tetapi jika kamu kehilangan hidup kamu karena saya dan kabar baik kamu akan menyelamatkannya. ");
INSERT INTO indags_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Apa gunanya bagimu memiliki kekayaan di seluruh dunia, tetapi kehilangan hidupmu? ");
INSERT INTO indags_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Apa yang akan kamu berikan kepada Allah sebagai ganti hidupmu? ");
INSERT INTO indags_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kalau kalian malu untuk mengakui Aku dan apa yang Aku katakan kepada orang-orang yang tidak setia dan berdosa ini, maka Anak Manusia juga malu untuk mengakui kalian ketika Dia datang dalam kemuliaan Bapa-Nya bersama para malaikat surgawi.” ");
INSERT INTO indags_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lalu Yesus berkata kepada mereka, “Aku mengatakan yang sebenarnya: beberapa orang yang berdiri di sini tidak akan mati sebelum mereka melihat kerajaan Allah datang dengan kuasa.” ");
INSERT INTO indags_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Enam hari kemudian Yesus membawa Petrus, Yakobus, dan Yohanes bersama-Nya, dan memimpin mereka mendaki gunung untuk menyendiri. Tubuh dan pakaian Yesus berubah. ");
INSERT INTO indags_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pakaian-Nya bersinar putih cemerlang. Tidak ada seorangpun di dunia ini yang bisa membuat kain seputih itu. ");
INSERT INTO indags_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tiba-tiba ketiga murid itu melihat Elia dan Musa sedang berbicara dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lalu Petrus berkata kepada Yesus, “Guru, senang sekali kita berada di sini! Kami akan membuat tiga tempat berlindung — masing-masing untuk Engkau, Musa, dan Elia.” ");
INSERT INTO indags_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Petrus benar-benar tidak tahu harus berkata apa karena mereka semua sangat ketakutan!) ");
INSERT INTO indags_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kemudian awan menutupi mereka, dan terdengar suara dari awan itu, berkata, “Inilah Anak-Ku yang sangat Ku-kasihi. Dengarkanlah Dia.” ");
INSERT INTO indags_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lalu, tiba-tiba mereka tidak melihat orang lain, kecuali Yesus sendiri. ");
INSERT INTO indags_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Saat mereka turun dari gunung itu, Yesus melarang mereka untuk tidak memberitahu siapa pun tentang apa yang mereka lihat sampai Anak Manusia bangkit dari antara orang mati. ");
INSERT INTO indags_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mereka menyimpan ini untuk diri mereka sendiri, tetapi mereka berdebat satu sama lain tentang apa artinya bangkit dari kematian. ");
INSERT INTO indags_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","“Mengapa para guru agama menyatakan bahwa Elia harus didahulukan?” mereka bertanya padanya. ");
INSERT INTO indags_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jawab Yesus, “Memang benar bahwa Elia datang lebih dulu untuk mempersiapkan segala sesuatu sebelum Anak Manusia datang.” “Tetapi mengapa dikatakan dalam Kitab Suci bahwa Anak Manusia harus begitu menderita dan diperlakukan dengan hina? ");
INSERT INTO indags_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Namun, saya memberi tahu kalian bahwa Elia telah datang, dan mereka melecehkannya dengan cara apa pun yang mereka inginkan, seperti yang dikatakan Kitab Suci.” ");
INSERT INTO indags_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ketika Yesus dan ketiga murid-Nya kembali, mereka melihat orang banyak sedang mengelilingi murid-murid-Nya yang lain. Di situ ada juga beberapa guru agama sedang berdebat dengan mereka. ");
INSERT INTO indags_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tetapi ketika orang banyak itu melihat Yesus, mereka alam kekaguman penuh, dan berlari untuk menyambut Dia. ");
INSERT INTO indags_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Apa yang kalian perdebatkan dengan mereka?” Yesus bertanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lalu salah satu orang di antara banyak orang itu menjawab, “Guru, saya datang membawa anak saya kepada-Mu. Dia dikuasai roh jahat yang membuat sehingga dia tidak bisa berbicara. ");
INSERT INTO indags_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Setiap kali roh jahat itu menyerang, dia mengalami kejang lalu jatuh, dan mulutnya berbusa, menggertakkan giginya, dan badannya menjadi kaku. Saya sudah meminta murid-murid-Mu untuk mengusir roh jahat itu, tetapi mereka tidak bisa melakukannya.” ");
INSERT INTO indags_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lalu Yesus berkata kepada para murud-Nya, “Kamu orang yang tidak percaya! Berapa lama Aku harus tinggal di sini bersama kalian? Berapa lama Aku harus bersabar dengan kalian? Bawa anak itu ke sini!” ");
INSERT INTO indags_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jadi mereka membawanya kepada Yesus. Ketika roh jahat itu melihat Yesus, dia segera membuat anak laki-laki itu kejang dan melemparkannya ke tanah, di mana dia berguling-guling, dan mulutnya berbusa. ");
INSERT INTO indags_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus bertanya kepada bapak anak ini, “Sudah berapa lama dia begini?” Lalu bapak itu menjawab, “Sejak dia masih kecil. ");
INSERT INTO indags_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Seringkali melemparkannya ke dalam api untuk membakarnya sampai mati, atau melemparkannya ke dalam air untuk menenggelamkannya. Tolong kasihanilah kami dan bantu, kalau Engkau bisa.” ");
INSERT INTO indags_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tetapi Yesus berkata kepada bapak itu, “Mengapa kamu mengatakan, ‘Kalau Engkau bisa?’ Siapa percaya, pasti memiliki kuasa!” ");
INSERT INTO indags_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Saat itu juga bapak itu berkata, “Saya benar-benar percaya kepada-Mu. Tolong saya supaya saya lebih percaya lagi.” ");
INSERT INTO indags_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waktu Yesus melihat orang-orang semakin bertambah banyak, Dia menyuruh roh jahat itu, “Hei, roh yang membuat anak ini bisu dan tuli, Aku perintahkan kamu keluar dari dia dan jangan pernah kembali lagi.” ");
INSERT INTO indags_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Roh itu berteriak dan membuat anak itu kejang-kejang lalu keluar. Anak itu kelihatan seperti orang mati — jadi orang banyak yang menyaksikan berkata, “Dia sudah mati.” ");
INSERT INTO indags_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tetapi Yesus memegang tangan anak itu dan membantunya berdiri. ");
INSERT INTO indags_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Waktu Yesus dan murid-murid-Nya sendiri dalam rumah itu, mereka bertanya kepada-Nya, “Mengapa kami tidak bisa mengusir roh jahat itu?” ");
INSERT INTO indags_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jawab Yesus kepada mereka, “Roh jahat sejenis ini hanya bisa diusir dengan berdoa dan berpuasa.” ");
INSERT INTO indags_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lalu Yesus dan para murid-Nya pergi dan melewati Galilea menuju ke Kapernaum. Yesus tidak ingin ada orang yang tahu di mana mereka berada, ");
INSERT INTO indags_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","karena Dia sedang mengajar murid-murid-Nya seperti ini: “Anak Manusia akan diserahkan ke dalam tangan orang-orang jahat,” kata Yesus kepada mereka. “Mereka akan membunuh Dia, tetapi pada hari ketiga Dia akan hidup kembali.” ");
INSERT INTO indags_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mereka tidak mengerti apa yang Yesus maksudkan, tetapi mereka takut untuk menanyakan hal itu kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mereka tiba di Kapernaum, dan begitu mereka berada di dalam rumah tempat mereka tinggal, Yesus bertanya kepada mereka, “Apa yang kalian bicarakan dalam perjalanan tadi?” ");
INSERT INTO indags_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tetapi mereka tidak berani menjawab karena dalam perjalanan mereka berdebat tentang siapakah yang paling tinggi kedudukannya di antara mereka. ");
INSERT INTO indags_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus duduk dan memanggil kedua belas murid-Nya, lalu berkata, “Kalau ada yang ingin menjadi yang nomor satu, dia harus menjadi yang paling terakhir, dan siap untuk menjadi pelayan bagi semua orang.” ");
INSERT INTO indags_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesus mengajak seorang anak kecil dan menyuruh anak itu berdiri di tengah-tengah mereka. Kemudian Dia mengangkat dan memeluk anak itu, lalu berkata kepada mereka, ");
INSERT INTO indags_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Barangsiapa menyambut anak seperti ini atas namaku, ia menyambutku, dan siapa pun yang menyambutku, tidak menyambutku melainkan yang mengutusku.” ");
INSERT INTO indags_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Lalu Yohanes berkata kepada Yesus, “Guru, kami melihat seseorang yang mengusir setan dengan memakai nama-Mu. Kami mencoba menghentikannya karena dia bukan salah satu dari kami.” ");
INSERT INTO indags_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tetapi Yesus berkata, “Jangan larang dia.” Karena orang yang melakukan keajaiban dengan memakai nama-Ku, dia tidak bisa langsung berbalik dan menghina Aku. ");
INSERT INTO indags_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Siapapun yang tidak melawan kita adalah untuk kita. ");
INSERT INTO indags_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Siapa pun yang memberikan secangkir air kepada kalian atas nama saya, karena kalian adalah milik Kristus, tidak akan kehilangan upahnya, percayalah. ");
INSERT INTO indags_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Lalu Yesus berkata lagi, “Tetapi kalau ada orang yang membuat salah satu dari anak-anak kecil yang percaya kepada-Ku ini melakukan dosa, akan lebih baik bagi mereka kalau mereka dibuang ke laut dengan sebuah batu kilangan besar diikatkan di leher mereka. ");
INSERT INTO indags_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kalau tanganmu menyebabkan kamu berbuat dosa, potong dan buang saja! Lebih baik kamu masuk kepada hidup kekal sebagai orang cacat daripada masuk dengan kedua tangan ke dalam Gehena, ke dalam api yang tidak bisa dipadamkan. ");
INSERT INTO indags_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Begitu juga kalau kakimu menyebabkan kamu berdosa, potong saja kaki itu! Lebih baik kamu masuk kepada hidup kekal dengan kaki yang pincang daripada kamu dilemparkan ke dalam Gehena dengan kakimu yang masih lengkap. ");
INSERT INTO indags_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dan kalau matamu menyebabkan kamu berbuat dosa, cungkil dan buang saja! Lebih baik kamu masuk ke dalam kerajaan Allah hanya dengan satu mata daripada kamu dilemparkan ke dalam Gehena dengan kedua matamu yang masih utuh, ");
INSERT INTO indags_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","di mana cacing tidak mati dan apinya tidak pernah padam. ");
INSERT INTO indags_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Semua orang akan ‘diasinkan’ oleh api. ");
INSERT INTO indags_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Garam itu enak, tetapi kalau rasanya hilang, bagaimana bisa dia asin lagi? Kalian harus menjadi seperti garam, dan hidup dalam damai satu sama lain.” ");
INSERT INTO indags_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus meninggalkan Kapernaum dan pergi ke Sungai Yordan di provinsi Yudea. Banyak orang datang kepada-Nya, dan seperti biasanya, Yesus mulai mengajar. ");
INSERT INTO indags_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Waktu itu ada beberapa orang Farisi datang kepada-Nya. Mereka mencoba mengujinya dengan mengajukan pertanyaan, “Apakah perceraian itu sah?” ");
INSERT INTO indags_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lalu jawab Yesus, “Apa yang Musa perintahkan untuk kalian lakukan?” ");
INSERT INTO indags_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jawab mereka, “Musa mengizinkan seorang suami menceraikan istrinya dengan memberikan surat cerai kepadanya.” ");
INSERT INTO indags_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kemudian Yesus berkata kepada mereka, “Musa menuliskan peraturan ini untukmu karena sikapmu yang keras hati. ");
INSERT INTO indags_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Namun, pada mulanya, sejak penciptaan, Allah menciptakan laki-laki dan perempuan. ");
INSERT INTO indags_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Itulah sebabnya dalam pernikahan, seorang laki-laki meninggalkan bapak dan ibunya dan bersatu dengan istrinya, ");
INSERT INTO indags_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","dan keduanya menjadi satu tubuh. Mereka bukan lagi dua tetapi satu. ");
INSERT INTO indags_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Janganlah seorang pun memisahkan apa yang telah dipersatukan Allah.” ");
INSERT INTO indags_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ketika mereka kembali ke dalam rumah, murid-murid mulai bertanya kepada-Nya tentang perceraian itu. ");
INSERT INTO indags_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kata Yesus kepada murid-murid-Nya, “Setiap suami yang menceraikan istrinya dan menikah lagi dengan perempuan lain, dia sudah melakukan perselingkuhan terhadap istrinya. ");
INSERT INTO indags_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Begitu juga kalau seorang istri menceraikan suaminya dan menikah lagi dengan laki-laki lain, dia melakukan perselingkuhan terhadap suaminya.” ");
INSERT INTO indags_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kemudian ada beberapa orang yang membawa anak-anak mereka kepada Yesus agar Dia bisa menjamah dan memberkati mereka. Tetapi para murid menyuruh mereka pergi dan berusaha menjauhkan anak-anak itu dari Yesus. ");
INSERT INTO indags_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tetapi ketika Yesus melihat apa yang mereka lakukan, Dia marah dan berkata kepada mereka, “Biarkan anak-anak itu datang kepada-Ku! Jangan melarang mereka, karena Kerajaan Allah adalah milik mereka yang seperti anak-anak ini. ");
INSERT INTO indags_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aku berkata yang sebenarnya, siapa pun yang tidak menyambut kerajaan Allah seperti anak kecil ini, dia tidak akan masuk ke dalamnya.” ");
INSERT INTO indags_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dia memeluk anak-anak itu, meletakkan tangan-Nya di atas mereka, dan memberkati mereka. ");
INSERT INTO indags_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Saat Yesus keluar dari rumah itu, ada seorang laki-laki datang berlari dan berlutut di hadapan Yesus. Lalu dia bertanya, “Guru yang baik, apa yang harus saya lakukan untuk memastikan saya memiliki kehidupan kekal?” ");
INSERT INTO indags_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Mengapa kamu menyebut-Ku baik?” Yesus bertanya padanya. “Tidak ada yang baik, hanya Allah saja yang baik. ");
INSERT INTO indags_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kamu sudah tahu perintah ini: ‘Jangan membunuh, jangan berzinah, jangan mencuri, jangan memberikan kesaksian palsu, jangan menipu, hormati bapak dan ibumu…’” ");
INSERT INTO indags_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jawab orang itu kepada-Nya, “Guru, saya sudah mematuhi semua perintah ini sejak saya masih kecil.” ");
INSERT INTO indags_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus memandang dia dengan cinta dan lalu berkata, “Kamu hanya kehilangan satu hal. Pergi dan jual semua yang kamu miliki, berikan uangnya kepada orang miskin, dan kamu akan memiliki harta di surga. Lalu kamu datang dan mengikut Aku.” ");
INSERT INTO indags_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mendengar Yesus berkata begitu, orang itu kecewa, dan dia pergi dengan perasaan sangat sedih, karena dia sangat kaya. ");
INSERT INTO indags_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus melihat sekeliling, dan berkata kepada murid-murid-Nya, “Orang-orang kaya sulit sekali masuk ke dalam Kerajaan Allah!” ");
INSERT INTO indags_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Para murid-Nya heran mendengar perkataan-Nya. Tetapi Yesus berkata lagi, “Teman-teman-Ku, sulit untuk masuk ke dalam kerajaan Allah. ");
INSERT INTO indags_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lebih mudah bagi seekor unta untuk melewati lubang jarum daripada bagi orang kaya untuk masuk ke dalam kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Para murid-Nya semakin heran dan bingung dan bertanya satu sama lain. “Kalau begitu siapa yang bisa diselamatkan?” ");
INSERT INTO indags_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sambil melihat ke arah mereka, Yesus berkata, “Bagi manusia itu tidak mungkin — tetapi bagi Allah tidak ada yang tidak mungkin. Karena Allah sanggup melakukan segala sesuatu.” ");
INSERT INTO indags_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lalu Petrus berkata kepada-Nya, “Bagaimana dengan kami? Kami sudah meninggalkan segalanya untuk mengikuti-Mu.” ");
INSERT INTO indags_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jawab Yesus, “Aku berkata yang sebenarnya, siapa saja yang sudah meninggalkan rumah atau saudara atau saudari atau ibu atau bapak atau anak atau tanah karena mengikut Aku, dan juga karena Kabar Baik, ");
INSERT INTO indags_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","akan menerima balasan pada waktunya seratus kali lebih banyak dari rumah dan saudara lelaki dan perempuan serta anak-anak dan negeri — serta penganiayaan. Di dunia yang akan datang mereka akan menerima kehidupan kekal. ");
INSERT INTO indags_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tetapi banyak orang yang sekarang mempunyai kedudukan tinggi, akan mendapat kedudukan yang rendah dikemudian hari. Dan orang yang sekarang mempunyai kedudukan yang rendah, akan mendapatkan kedudukan yang tinggi di kemudian hari.” ");
INSERT INTO indags_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mereka melanjutkan perjalanan ke Yerusalem. Yesus berjalan di depan mereka. Murid-murid-Nya merasa kuatir dan pengikut lainnya merasa takut. Jadi Yesus mengajak murid-Nya secara tersendiri dan mulai menjelaskan kepada mereka apa yang akan terjadi pada diri-Nya. ");
INSERT INTO indags_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kita akan pergi ke Yerusalem,” kata Yesus kepada mereka, “dan Anak Manusia akan diserahkan kepada para imam kepala dan guru-guru agama. Mereka akan menghukum mati Dia dan menyerahkan Dia kepada para pembesar yang orang asing. ");
INSERT INTO indags_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mereka akan mengejek, meludahi, mencambuk, dan membunuh-Dia. Tetapi tiga hari kemudian Dia akan bangkit kembali.” ");
INSERT INTO indags_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobus dan Yohanes, anak Zebedeus, datang kepada Yesus dan berkata, “Guru, kami ingin Engkau melakukan untuk kami apa pun yang kami minta.” ");
INSERT INTO indags_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lalu Yesus bertanya kepada mereka, “Jadi, apa yang kalian ingin Aku lakukan untukmu?” ");
INSERT INTO indags_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kata mereka kepada Yesus, “Waktu Engkau menjadi Raja dan duduk di atas takhta kerajaan-Mu, izinkan kami berdua duduk di samping-Mu, satu di kanan, yang lain di kiri.” ");
INSERT INTO indags_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tetapi jawab Yesus kepada mereka, “Kalian tidak mengerti apa yang kalian minta. Apakah kalian bisa menerima penderitaan seperti yang akan Aku alami? Apakah kalian dibaptis dengan baptisan rasa sakit yang akan saya derita?” ");
INSERT INTO indags_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ya, kami bisa,” jawab mereka. “Memang kalian akan menderita dan kalian akan dibaptis dengan baptisan rasa sakit yang sama seperti Aku,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Tetapi Aku tidak berhak untuk memilih siapa yang akan duduk di sebelah kanan-Ku atau di sebelah kiri-Ku. Karena kedua tempat itu sudah disediakan bagi mereka yang sudah dipersiapkan.” ");
INSERT INTO indags_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ketika sepuluh murid lainnya mendengar tentang ini, mereka mulai marah kepada Yakobus dan Yohanes. ");
INSERT INTO indags_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus memanggil semua murid-Nya dan memberitahu mereka, “Kalian sudah tahu bahwa para pemimpin bangsa-bangsa menganggap dirinya pembesar dan memerintah bangsa serta menindas rakyat mereka. Para penguasa bertindak dengan keras. ");
INSERT INTO indags_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tetapi kalian tidak boleh seperti ini. Siapapun dari kalian yang mau menjadi penguasa, dia harus menjadi seperti seorang hamba, ");
INSERT INTO indags_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","dan siapa pun yang ingin menjadi yang pertama di antara kalian harus menjadi hamba untuk kalian semua. ");
INSERT INTO indags_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Karena Anak Manusia tidak datang untuk dilayani tetapi untuk melayani, dan untuk memberikan nyawa-Nya sebagai tebusan bagi banyak orang.” ");
INSERT INTO indags_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lalu Yesus dan murid-murid-Nya tiba di Yeriko. Dan ketika mereka meninggalkan kota itu, ada seorang pengemis buta bernama Bartimeus, sedang duduk di pinggir jalan. ");
INSERT INTO indags_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ketika dia mendengar bahwa Yesus dari Nazaret sedang lewat, dia mulai berteriak, “Yesus, Anak Daud, kasihanilah saya!” ");
INSERT INTO indags_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Banyak orang menyuruhnya diam, tetapi itu hanya membuatnya semakin berteriak, “Yesus, Anak Daud, kasihanilah saya!” ");
INSERT INTO indags_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus berhenti, dan berkata, “Bawa dia kemari.” Jadi mereka memanggilnya, berkata kepadanya, “Kabar baik! Bangun. Dia memanggilmu.” ");
INSERT INTO indags_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus melompat dan melepaskan jubahnya, dan datang kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Apa yang kamu ingin Aku lakukan untukmu?” Yesus bertanya padanya. “Guru,” katanya kepada Yesus, “Saya ingin melihat!” ");
INSERT INTO indags_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus berkata kepada orang itu, “Kamu bisa pergi. Imanmu pada-Ku sudah menyembuhkanmu.” Bartimeus segera bisa melihat dan dia mengikuti Yesus saat Dia melanjutkan perjalanannya. ");
INSERT INTO indags_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ketika mereka mendekati Yerusalem, mereka tiba di Betfage dan Betania, yang berada di dekat Bukit Zaitun. Lalu Yesus menyuruh dua murid-Nya berjalan lebih dulu. ");
INSERT INTO indags_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Lalu Yesus berkata kepada mereka, “Pergilah ke desa di depan itu. Sesudah kamu masuk, kamu akan menemukan seekor keledai muda yang diikat yang belum pernah ditunggangi siapa pun. Lepaskan ikatannya dan bawa kemari. ");
INSERT INTO indags_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dan kalau ada yang bertanya apa yang kamu lakukan, katakan kepada mereka, ‘Tuhan membutuhkannya dan akan segera kembalikan.’” ");
INSERT INTO indags_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jadi kedua murid itu pergi, dan menemukan seekor keledai muda diikat ke pintu, di jalan dekat sebuah rumah, lalu mereka melepaskannya. ");
INSERT INTO indags_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ada beberapa orang yang berdiri di sekitar situ bertanya, “Kenapa kalian melepaskan keledai itu”? ");
INSERT INTO indags_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kedua murid itu menjawab tepat seperti yang Yesus perintahkan, dan orang-orang itu membiarkan mereka pergi. ");
INSERT INTO indags_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mereka membawa keledai itu kepada Yesus, mengenakan jubah mereka di atas punggungnya, dan Yesus duduk di atasnya. ");
INSERT INTO indags_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Banyak orang mengalas jubah mereka di jalan, sementara yang lain meletakkan dahan dan daun-daun yang mereka potong di ladang. ");
INSERT INTO indags_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Semua orang yang mengikuti Yesus dari belakang berseru, “Hosana! Pujilah Dia yang datang dalam nama Tuhan. ");
INSERT INTO indags_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Memberkati kerajaan ayah kita Daud yang akan datang! Hosana di tempat tertinggi!” ");
INSERT INTO indags_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Waktu Yesus memasuki Yerusalem dan masuk ke rumah Tuhan. Dia melihat sekelilingnya, mengamati segalanya, dan kemudian, karena hari sudah larut, Dia kembali ke Betania bersama kedua belas murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Keesokan harinya, ketika mereka meninggalkan Betania, Yesus merasa lapar. ");
INSERT INTO indags_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dari kejauhan Dia melihat pohon ara dengan daun di atasnya. Jadi Dia mendekati pohon itu untuk melihat apakah ada buahnya. Tetapi ternyata tidak ada buahnya, hanya daun saja, karena itu belum musim buah ara. ");
INSERT INTO indags_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lalu Yesus berkata kepada pohon itu, “Mulai sekarang tidak akan ada orang yang makan buahmu.” Murid-murid-Nya mendengar kata-kata-Nya. ");
INSERT INTO indags_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ketika mereka tiba kembali di Yerusalem, Yesus masuk ke rumah Tuhan. Dia mulai mengusir orang-orang yang membeli dan menjual di rumah Tuhan. Dia membalikkan meja penukar uang dan kursi penjual merpati. ");
INSERT INTO indags_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dia melarang orang yang membawa barang melalui teras rumah Tuhan. ");
INSERT INTO indags_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dia menjelaskan kepada mereka, “Bukankah Kitab Suci mengatakan, ‘Rumah-Ku akan disebut rumah doa untuk semua bangsa’? Tetapi kamu sudah mengubahnya menjadi sarang pencuri!” ");
INSERT INTO indags_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Waktu para imam kepala dan guru-guru agama Yahudi mendengar apa yang terjadi, mereka mencoba menemukan cara untuk membunuh Yesus. Tetapi mereka takut kepada Yesus, karena semua orang sangat terkesan dengan ajaran-Nya. ");
INSERT INTO indags_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ketika malam tiba, Yesus dan murid-murid-Nya meninggalkan kota. ");
INSERT INTO indags_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Keesokan paginya ketika Yesus dan murid-murid-Nya kembali, mereka melihat pohon ara itu sudah layu dari akarnya sampai ke atas. ");
INSERT INTO indags_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus teringat apa yang sudah Yesus lakukan, lalu dia berkata kepada-Nya, “Guru, lihat, pohon ara yang Engkau kutuk itu sudah menjadi kering.” ");
INSERT INTO indags_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Percaya pada Allah,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Percayalah ketika Aku berkata kepadamu bahwa jika kamu perintahkan gunung ini, ‘Keluarlah dari sini dan terbuanglah ke laut,’ dan kamu tidak ragu dalam hati, tetapi yakin tentang apa yang kamu minta, maka itu akan terjadi! ");
INSERT INTO indags_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aku berkata kepadamu bahwa apa pun yang kamu doakan, apa pun yang kamu minta, percayalah bahwa kamu sudah menerimanya, dan kamu akan menerimanya. ");
INSERT INTO indags_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tetapi ketika kamu berdoa, dan kalau kamu memiliki sesuatu yang melawan seseorang, ampunilah mereka, sehingga Bapamu yang di surga juga dapat mengampuni dosa-dosamu.” ");
INSERT INTO indags_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Waktu Yesus dan murid-murid-Nya kembali ke Yerusalem, dan ketika Dia sedang berjalan keliling teras rumah Tuhan, para imam kepala, guru-guru agama Yahudi, dan para pemimpin Yahudi datang kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lalu mereka bertanya kepada-Nya, “Dengan otoritas apa Engkau melakukan semua ini?” Siapa yang memberi-Mu hak? ");
INSERT INTO indags_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lalu Yesus berkata kepada mereka, “Izinkan Aku mengajukan pertanyaan. Kalau kalian menjawab-Ku, maka Aku akan memberitahukan kepadamu dengan otoritas siapa Aku melakukan hal-hal ini. ");
INSERT INTO indags_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Baptisan Yohanes — apakah itu datang dari surga, atau dari manusia?” ");
INSERT INTO indags_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lalu mereka mendiskusikannya di antara mereka sendiri. Mereka berkata, “Jika kita mengatakan Allah yang berikan, Dia akan menjawab, ‘Jadi mengapa kamu tidak percaya kepada Yohanes?’ ");
INSERT INTO indags_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tetapi jika kita mengatakan, itu berasal dari manusia, yah…” Mereka takut pada orang banyak, karena semua orang percaya bahwa Yohanes sebagai seorang nabi sejati. ");
INSERT INTO indags_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jadi mereka menjawab Yesus, “Kami tidak tahu.” “Kalau begitu, Aku tidak akan memberitahumu dengan otoritas siapa Aku melakukan hal-hal ini,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kemudian Yesus mulai berbicara kepada mereka menggunakan ilustrasi: “Suatu ketika ada seorang laki-laki yang membuat kebun anggur. Dia memasang pagar di sekelilingnya, menggali lubang untuk memeras buah anggur, dan membangun menara pengawas. Kemudian dia menyewakannya kepada beberapa petani, lalu dia pergi melakukan perjalanan. ");
INSERT INTO indags_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ketika waktu panen tiba, dia mengirim salah satu hambanya ke petani penyewa untuk mengambil beberapa buah anggur dari kebun anggur. ");
INSERT INTO indags_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tetapi mereka menangkapnya, memukulinya, dan mengirimnya pergi tanpa apa-apa. ");
INSERT INTO indags_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lalu orang itu mengirim seorang hamba yang lain. Mereka memukul kepalanya dan menyiksanya. ");
INSERT INTO indags_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dia mengirim pelayan lain, dan yang ini mereka bunuh. Dia mengirim banyak pelayan lain, dan mereka memukuli beberapa dari mereka dan membunuh yang lain. ");
INSERT INTO indags_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pada akhirnya satu-satunya yang tersisa adalah anak laki-lakinya yang dia cintai, dan akhirnya dia mengirimnya, dia berpikir ‘pasti mereka akan menghormati anak saya sendiri.’ ");
INSERT INTO indags_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tetapi para petani berkata satu sama lain, ‘Ini ahli waris pemiliknya — jika kita membunuhnya, kita bisa mendapatkan apa yang akan dia warisi!’ ");
INSERT INTO indags_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jadi mereka membawanya dan membunuhnya, dan melemparkannya ke luar kebun anggur itu. ");
INSERT INTO indags_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sekarang apa yang akan dilakukan oleh pemilik kebun anggur itu? Dia akan datang dan membunuh para petani itu, dan kemudian dia akan menyewa kebun anggur itu kepada orang lain. ");
INSERT INTO indags_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pernahkah kalian membaca Kitab Suci ini: ‘Batu yang dianggap tidak berguna oleh tukang-tukang bangunan, sudah menjadi batu fondasi yang utama. ");
INSERT INTO indags_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ini dari Tuhan, dan sungguh menakjubkan untuk dilihat!’” ");
INSERT INTO indags_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Para pemimpin Yahudi berusaha agar Yesus ditangkap karena mereka menyadari bahwa ilustrasi itu ditujukan kepada mereka, tetapi mereka takut pada orang banyak. Jadi mereka meninggalkan-Nya sendirian dan pergi. ");
INSERT INTO indags_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kemudian mereka mengirim beberapa orang Farisi dengan beberapa pendukung Herodes kepada Yesus dalam upaya untuk menjebak-Nya dengan apa yang Dia katakan. ");
INSERT INTO indags_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mereka datang dan berkata, “Guru, kami tahu Engkau orang yang jujur dan Engkau tidak peduli dengan pendapat orang lain. Sebaliknya Engkau mengajarkan kehendak Allah tanpa memandang kedudukan orang. Jadi apakah menurut Hukum Taurat, boleh atau tidak kita membayar pajak kepada pemerintah Romawi? ");
INSERT INTO indags_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Haruskah kami membayar, atau haruskah kami menolak?” Yesus, menyadari betapa munafiknya mereka, lalu Dia bertanya kepada mereka, “Mengapa kamu mencoba untuk menjebak-Ku dengan pertanyaan seperti itu? Coba bawakan kemari satu keping uang perak yang biasa dipakai untuk bayar pajak.” ");
INSERT INTO indags_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mereka memberi-Nya uang itu. Lalu Yesus bertanya kepada mereka, “Gambar dan tulisan siapa ini?” “Kaisar,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lalu kata Yesus, “Kalau begitu kembalikan kepada Kaisar apa yang menjadi miliknya, dan berikan kembali kepada Allah apa yang menjadi milik-Nya,” Mereka heran dengan jawaban-Nya. ");
INSERT INTO indags_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kemudian orang Saduki, yang tidak percaya dengan kebangkitan, datang dan mengajukan pertanyaan: ");
INSERT INTO indags_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Guru, Musa memberitahu kami bahwa jika seorang laki-laki yang sudah beristri meninggal tanpa memiliki anak, maka jandanya harus menikah dengan saudara laki-lakinya, dan meneruskan keturunan bagi saudaranya itu. ");
INSERT INTO indags_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dulu ada tujuh orang laki-laki bersaudara. Yang pertama menikah, lalu meninggal tanpa punya anak. ");
INSERT INTO indags_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yang kedua menikahi jandanya, dan kemudian meninggal, tanpa anak. Yang ketiga melakukan hal yang sama. ");
INSERT INTO indags_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Faktanya ketujuh orang itu meninggal tanpa memiliki anak. Akhirnya perempuan itu mati juga. ");
INSERT INTO indags_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jadi nanti waktu kebangkitan, dia akan menjadi istri siapa, karena dia adalah istri dari ketujuh bersaudara?” ");
INSERT INTO indags_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus berkata kepada mereka, “Ini membuktikan bahwa kalian keliru, dan bahwa kalian tidak mengetahui Kitab Suci atau kuasa Allah. ");
INSERT INTO indags_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ketika orang mati bangkit, mereka tidak menikah, dan tidak dikawinkan. Mereka seperti malaikat di surga. ");
INSERT INTO indags_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tetapi mengenai kebangkitan, bukankah kalian membaca dalam tulisan-tulisan Musa kisah tentang semak yang terbakar, di mana Allah berbicara kepada Musa dan berkata kepadanya, ‘Akulah Allah Abraham, Allah Isak, dan Allah Yakub.’ ");
INSERT INTO indags_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dia bukan Allah orang mati, tetapi Allah yang hidup. Kalian sudah sangat keliru!” ");
INSERT INTO indags_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kemudian salah satu guru agama datang dan mendengar mereka berdebat. Dia menyadari bahwa Yesus sudah memberi mereka jawaban yang bagus. Jadi dia bertanya kepada-Nya, “Perintah mana yang paling penting dari semuanya?” ");
INSERT INTO indags_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus menjawab, “Perintah pertama adalah, ‘Dengarlah, hai umat Israel, Tuhan Allah kita adalah satu-satunya Allah. ");
INSERT INTO indags_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kasihilah Tuhan, Allahmu, dengan segenap hatimu, dengan segenap jiwamu, dengan segenap pikiranmu, dan dengan segenap kekuatanmu.’ ");
INSERT INTO indags_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yang kedua adalah, ‘Kasihilah sesamamu sama seperti kamu mengasihi dirimu sendiri.’ Tidak ada perintah yang lebih penting daripada ini.” ");
INSERT INTO indags_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Benar, Guru,” jawab laki-laki itu. “Memang benar seperti yang Engkau katakan bahwa Allah itu satu, dan tidak ada yang lain. ");
INSERT INTO indags_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kita harus mengasihi-Nya dengan segenap hati kita, semua pengertian kita, dan seluruh kekuatan kita, dan kita harus mengasihi sesama kita seperti diri kita sendiri. Ini jauh lebih penting daripada persembahan dan kurban.” ");
INSERT INTO indags_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus melihat bahwa dia memberikan jawaban yang bijaksana, dan berkata, “Kamu tidak jauh dari kerajaan Allah.” Sesudah ini tidak ada yang cukup berani untuk bertanya lebih banyak lagi pada Yesus. ");
INSERT INTO indags_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ketika Yesus sedang mengajar di rumah Allah, Dia bertanya, “Mengapa para guru agama menyatakan bahwa Kristus adalah Anak Daud? ");
INSERT INTO indags_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sebagaimana Daud sendiri menyatakan, ketika dikuasai oleh Roh Allah berkata, ‘Tuhan Allah berkata kepada Tuhanku, “Duduklah di sebelah kanan-Ku sampai Aku menyerahkan musuhmu di bawah kakimu.”’ ");
INSERT INTO indags_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Karena Daud sendiri memanggil-Nya Tuan, bagaimana Dia bisa menjadi anak Daud?” Orang banyak mendengarkan apa yang Yesus katakan dengan sangat senang. ");
INSERT INTO indags_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus terus mengajar mereka dengan mengatakan, “Hati-hatilah terhadap para pemimpin agama! Mereka suka berjalan-jalan di pasar dan tempat-tempat umum dengan jubah panjang supaya dihormati. ");
INSERT INTO indags_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mereka senang duduk di kursi paling depan di rumah pertemuan orang Yahudi, dan tempat terbaik di pesta-pesta makan. ");
INSERT INTO indags_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mereka biasa menipu janda-janda dengan merampas harta mereka, dan untuk menutupi kejahatan mereka, mereka selalu berdoa panjang-panjang, supaya orang lain mengira mereka orang baik. Akibat perbuatan mereka itu, mereka akan menerima hukuman yang berat dalam penghakiman.” ");
INSERT INTO indags_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus duduk di dekat peti persembahan sambil memperhatikan orang-orang yang mengisi uang di kotak persembahan. Banyak dari orang kaya memberi uang dalam jumlah yang banyak. ");
INSERT INTO indags_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kemudian seorang janda miskin datang dan memasukkan hanya dua uang logam yang kecil nilainya. ");
INSERT INTO indags_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus memanggil murid-murid-Nya dan mengatakan kepada mereka, “Aku berkata yang sebenarnya: janda miskin ini sudah memberi persembahan yang nilainya lebih besar dari semua yang lain. ");
INSERT INTO indags_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Karena mereka semua memberi dari kekayaan mereka, tetapi janda itu memberi dari apa yang dia miliki. Dia memberikan semua biaya hidup yang dia punya.” ");
INSERT INTO indags_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saat Yesus meninggalkan rumah Tuhan, salah satu murid-Nya berkata kepada-Nya, “Guru, lihatlah batu-batu besar dan bangunan-bangunan megah ini!” ");
INSERT INTO indags_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jawab Yesus, “Kalian perhatikan baik-baik semua bangunan besar ini? Tidak satu pun batu yang akan tersusun di atas batu yang lain. Semuanya akan dirobohkan.” ");
INSERT INTO indags_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Saat Yesus duduk di Bukit Zaitun menghadap rumah Tuhan, Petrus, Yakobus, Yohanes, dan Andreas bertanya secara pribadi, ");
INSERT INTO indags_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Guru, tolong beritahukan kepada kami kapan ini akan terjadi. Apa tanda bahwa semua ini akan segera terpenuhi?” ");
INSERT INTO indags_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus mulai memberitahukan mereka, kata-Nya, “Kalian harus hati-hati supaya tidak ada yang menipu kalian. ");
INSERT INTO indags_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Banyak orang akan datang dan berkata, ‘Aku adalah Kristus.’ Mereka akan menipu banyak orang. ");
INSERT INTO indags_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jangan kuatir jika kalian mendengar tentang perang di sekitar dan perang di tempat yang jauh. Hal-hal ini harus terjadi tetapi ini bukanlah akhir. ");
INSERT INTO indags_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bangsa akan berperang melawan bangsa, dan kerajaan melawan kerajaan. Akan ada gempa bumi di berbagai tempat, dan kelaparan juga. Ini baru awal, seperti ibu hamil yang rasa sakit untuk melahirkan. ");
INSERT INTO indags_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hati-hati dengan dirimu sendiri! Mereka akan menyerahkan kalian ke pengadilan untuk diadili. Kalian akan dipukuli di tempat pertemuan orang Yahudi. Karena Aku, kalian harus berdiri di hadapan para gubernur dan raja, dan kalian akan menjadi saksi-Ku. ");
INSERT INTO indags_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sebelum akhir dunia ini, Kabar Baik tentang Aku harus disampaikan ke semua suku bangsa di seluruh dunia. ");
INSERT INTO indags_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Saat mereka datang untuk menangkap dan mengadilimu, jangan kuatir tentang apa yang harus kamu jawab. Katakan saja apa yang kamu katakan pada saat itu, karena itu bukan kamu yang berbicara, tetapi Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Saudara laki-laki akan menyerahkan saudaranya sendiri untuk dibunuh, dan seorang bapak akan menyerahkan anaknya untuk dibunuh. Anak-anak akan berbalik melawan orang tua mereka dan membuat mereka dihukum mati. ");
INSERT INTO indags_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kamu akan dibenci oleh semua orang karena Aku, tetapi siapapun yang bertahan sampai akhir akan diselamatkan. ");
INSERT INTO indags_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tetapi ketika kalian melihat ‘penyembahan berhala yang menajiskan’ berdiri di tempat yang tidak seharusnya (biar pembaca mengerti), maka mereka yang ada di Yudea harus lari ke gunung. ");
INSERT INTO indags_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dan untuk mereka yang sedang ada di atap rumah — janganlah turun untuk mengambil barang apapun juga yang ada di dalam rumah. ");
INSERT INTO indags_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mereka yang bekerja di ladang — jangan pulang untuk mengambil jubahmu. ");
INSERT INTO indags_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pada waktu bencana itu terjadi, benar-benar sulit bagi ibu-ibu yang sedang hamil atau menyusui pada saat itu, karena mereka akan sulit untuk melarikan diri! ");
INSERT INTO indags_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Berdoalah supaya kesusahan besar itu tidak terjadi selama musim dingin. ");
INSERT INTO indags_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Karena ini akan menjadi hari-hari penuh kesulitan yang belum pernah terjadi sebelumnya sejak awal penciptaan Allah hingga sekarang, dan kesusahan yang seperti ini tidak akan pernah terjadi lagi. ");
INSERT INTO indags_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jika Allah tidak mempersingkat hari ini, tidak ada yang akan selamat. Namun demi mereka yang sudah Allah pilih, maka kesusahan itu tidak akan berlangsung lama. ");
INSERT INTO indags_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jadi, jika ada yang memberitahu kalian, ‘Lihat, inilah Kristus,’ atau ‘lihat, Dia ada di sana,’ jangan kalian percaya. ");
INSERT INTO indags_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Karena Kristus-Kristus palsu dan nabi-nabi palsu akan muncul, dan mereka akan melakukan tanda-tanda dan mujizat-mujizat untuk menipu orang-orang pilihan Allah, jika itu mungkin. ");
INSERT INTO indags_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Karena itu kalian harus hati-hati! Aku sudah memberitahukan segalanya kepada kalian sebelum hal-hal itu terjadi. ");
INSERT INTO indags_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Inilah yang akan terjadi setelah masalah itu: ‘matahari akan menjadi gelap, bulan tidak akan bersinar lagi, ");
INSERT INTO indags_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bintang-bintang akan jatuh dari langit, dan kekuatan surgawi akan terguncang.’ ");
INSERT INTO indags_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pada waktu itu semua orang akan melihat Anak Manusia datang di antara awan-awan, dengan kuasa dan kemuliaan yang besar dari surga. ");
INSERT INTO indags_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dia akan mengutus para malaikat, dan mengumpulkan semua orang pilihan-Nya dari mana pun mereka berada, dari bagian terjauh di bumi hingga titik terjauh di surga. ");
INSERT INTO indags_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ambil pelajaran dari pohon ara. Ketika ranting-rantingnya sudah menjadi lunak dan tunas-tunasnya mulai mengeluarkan daun, kalian tahu bahwa musim panas sudah dekat. ");
INSERT INTO indags_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ketika kalian melihat tanda-tanda itu mulai terjadi, kalian harus tahu bahwa waktu kedatangan-Ku kembali sudah dekat! ");
INSERT INTO indags_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Saya katakan yang sebenarnya, generasi ini tidak akan berakhir sampai semua hal ini terjadi. ");
INSERT INTO indags_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit dan bumi akan berakhir, tetapi perkataan-Ku tetap berlaku untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tidak ada yang tahu hari atau jam kapan ini akan terjadi — para malaikat di surga pun tidak tahu, dan Anak pun tidak; hanya Bapa sendiri yang tahu. ");
INSERT INTO indags_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jadi kalian harus berhati-hati, tetap berjaga-jaga dan berdoa! Karena kamu tidak tahu kapan ini akan terjadi. ");
INSERT INTO indags_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ini seperti seorang pria yang pergi dalam perjalanan. Sebelum dia meninggalkan rumahnya, dia membagi tugas kepada setiap pelayannya dan menjelaskan tanggung jawab mereka masing-masing. Dia juga menyuruh penjaga pintu untuk menjaga baik-baik sampai dia kembali. ");
INSERT INTO indags_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jadi tetap bersiap-siap dan berjaga-jaga, karena kamu tidak tahu kapan pemilik rumah akan kembali. Mungkin di sore hari, di tengah malam, sebelum matahari terbit, atau di pagi hari. ");
INSERT INTO indags_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jangan sampai waktu pemilik rumah datang, ternyata kalian sedang tidur. ");
INSERT INTO indags_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Apa yang saya katakan, saya memberitahu semua orang: Perhatikan!” ");
INSERT INTO indags_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Itu dua hari sebelum Paskah dan Pesta Roti Tidak Beragi. Para imam kepala dan para pemimpin agama mencoba mencari cara yang sembunyi-sembunyi untuk menangkap Yesus dan membunuh-Nya. ");
INSERT INTO indags_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lalu kata mereka satu sama lain, “Jangan kita melakukannya selama Paskah berlangsung, karena kalau tidak, orang banyak bisa marah dan membuat kekacauan.” ");
INSERT INTO indags_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sesudah itu Yesus dan murid-murid-Nya pergi ke Betania. Mereka makan di rumah Simon si penderita kusta. Waktu itu seorang perempuan datang dengan botol pualam yang berisi parfum narwastu murni yang sangat mahal. Dia memecahkan stoples dan menuangkan parfum ke kepala Yesus. ");
INSERT INTO indags_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tetapi ada beberapa orang dari mereka yang ada di sana menjadi kesal dan berkata, “Mengapa memboroskan minyak wangi seperti ini? ");
INSERT INTO indags_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Itu bisa saja dijual dengan harga yang mahal dan uangnya bisa diberikan kepada orang miskin.” Mereka marah padanya. ");
INSERT INTO indags_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tetapi Yesus berkata kepada mereka, “Biarkan dia sendiri! Mengapa kalian tegur dia karena melakukan sesuatu yang baik kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Karena kesempatan untuk menolong orang miskin selalu ada, dan kalian dapat membantu mereka kapan pun kalian mau. Tetapi Aku tidak akan selalu ada bersama kalian. ");
INSERT INTO indags_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sebenarnya perempuan ini sudah melakukan apa yang dia bisa: dia mengurapi tubuh-Ku untuk mempersiapkan penguburan-Ku. ");
INSERT INTO indags_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Apa yang Aku katakan ini benar: di mana pun Kabar Baik tersebar di dunia, orang akan mengingat apa yang dia lakukan.” ");
INSERT INTO indags_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kemudian Yudas Iskariot, salah satu dari dua belas murid Yesus, pergi ke imam-imam kepala dan mengatur untuk menyerahkan Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ketika mereka mendengar ini, mereka sangat senang, dan berjanji akan membayarnya dia. Jadi Yudas mulai mencari kesempatan untuk mengkhianati Yesus. ");
INSERT INTO indags_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pada hari pertama Pesta Roti Tidak Beragi, saat domba Paskah dikurbankan, murid-murid Yesus bertanya kepada-Nya, “Guru, di mana Engkau mau kami pergi dan menyiapkan perjamuan Paskah untuk-Mu?” ");
INSERT INTO indags_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesus menyuruh dua murid-Nya, dan berkata, “Pergilah ke kota dan di sana kamu akan bertemu dengan seorang laki-laki yang membawa kendi air. Ikuti dia, ");
INSERT INTO indags_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","dan ketika dia masuk ke sebuah rumah, tanyakan kepada pemiliknya di mana tempat Aku dan murid-murid-Ku dapat merayakan perjamuan Paskah. ");
INSERT INTO indags_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dia akan membawa kalian ke ruang besar di lantai atas yang sudah dilengkapi dengan meja dan perabot lainnya. Kalian dapat membuat persiapan untuk perjamuan Paskah kita di sana.” ");
INSERT INTO indags_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Maka kedua murid itu pergi ke kota, dan menemukan hal-hal seperti yang Yesus katakan. Lalu mereka menyiapkan perjamuan Paskah. ");
INSERT INTO indags_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pada malam hari Yesus pergi ke sana dengan kedua belas murid-Nya. ");
INSERT INTO indags_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Saat mereka duduk makan, Yesus berkata, “Aku berkata kepada kalian yang sebenarnya: salah satu dari kalian akan mengkhianati-Ku; orang yang makan dengan-Ku sekarang.” ");
INSERT INTO indags_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mereka terkejut, dan mereka masing-masing bertanya, “Pasti bukan saya, Yesus?” ");
INSERT INTO indags_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Itu salah satu dari Dua Belas, salah satu dari kalian berbagi makanan ini denganku,” jawabnya. ");
INSERT INTO indags_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Anak Manusia akan mati, seperti yang sudah ditulis dalam Kitab Suci. Tetapi betapa mengerikannya bagi orang yang mengkhianati Anak Manusia! Akan lebih baik bagi dia jika dia tidak pernah dilahirkan.” ");
INSERT INTO indags_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Saat mereka sedang makan, Yesus mengambil roti. Dia memberkatinya, dan memberikannya kepada mereka. “Ambil. Ini adalah tubuh saya,” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lalu dia mengambil cangkir itu. Dia memberkatinya, dan memberikannya kepada mereka. Mereka semua meminumnya. ");
INSERT INTO indags_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kata Yesus kepada mereka, “Inilah darah-Ku, menjadi tanda perjanjian yang dicurahkan bagi banyak orang. ");
INSERT INTO indags_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Saya mengatakan yang sebenarnya, saya tidak akan minum anggur sampai hari saya meminumnya segar di kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lalu mereka menyanyikan lagu pujian kepada Allah, Yesus dan murid-murid-Nya pergi ke Bukit Zaitun. ");
INSERT INTO indags_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dalam perjalanan Yesus berkata kepada mereka, “Kalian semua akan meninggalkan-Ku. Karena seperti yang dikatakan Kitab Suci, ‘Aku akan memukul Gembala, dan domba-domba-Nya akan lari tercerai berai.’ ");
INSERT INTO indags_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tetapi sesudah Aku bangkit dari antara orang mati, Aku akan mendahului kalian ke Galilea.” ");
INSERT INTO indags_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lalu kata Petrus kepada Yesus, “Aku tidak akan meninggalkan Engkau bahkan jika semua orang melakukannya.” ");
INSERT INTO indags_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus menjawabnya, “Aku mengatakan yang sebenarnya bahwa hari ini, malam ini, sebelum ayam berkokok dua kali, kamu akan menyangkal Aku tiga kali.” ");
INSERT INTO indags_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tetapi Petrus menjawab lagi dengan tegas dan berkata, “Bahkan jika saya harus mati bersama-Mu, saya tidak akan pernah menyangkal-Mu.” Semuanya mengatakan hal yang sama. ");
INSERT INTO indags_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mereka tiba di sebuah tempat bernama Getsemani, di mana Yesus memberitahu murid-murid-Nya, “Duduklah di sini sementara Aku pergi untuk berdoa.” ");
INSERT INTO indags_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesus mengajak Petrus, Yakobus, dan Yohanes ikut bersama-Nya. Dia membawa Petrus, Yakobus, dan Yohanes bersamanya. Dia mulai sangat sedih dan bermasalah. ");
INSERT INTO indags_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yesus mengatakan kepada mereka, “Penderitaan saya sangat menyakitkan rasanya seperti saya sekarat. Tolong, tetap di sini dan tetap terjaga.” ");
INSERT INTO indags_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dia pergi sedikit lebih jauh dan kemudian jatuh ke tanah. Dia berdoa, meminta untuk dijauhkan dari waktu yang akan datang, jika memungkinkan. ");
INSERT INTO indags_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Lalu Yesus berdoa, “Abba, Bapa! Engkau dapat melakukan segala sesuatu. Tolong, ambillah cawan penderitaan ini dari-Ku. Tetapi jangan menurut kehendak-Ku, melainkan kehendak-Mu yang jadi.” ");
INSERT INTO indags_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kemudian Yesus kembali dan menemukan murid-murid-Nya tertidur. Lalu Yesus bertanya kepada Petrus, “Simon, apakah kamu sedang tidur? Tidak bisakah kamu tetap terjaga satu jam? ");
INSERT INTO indags_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tetap terjaga, dan berdoalah supaya kamu tidak jatuh ke dalam godaan. Semangat memang rela, tapi raga lemah.” ");
INSERT INTO indags_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesus meninggalkan mereka sekali lagi, dan kembali berdoa dengan hal yang sama. ");
INSERT INTO indags_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kemudian Yesus kembali, dan sekali lagi Dia menemukan mereka sedang tidur karena mereka sangat mengantuk. Mereka tidak tahu harus berkata apa! ");
INSERT INTO indags_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sesudah itu Yesus kembali untuk ketiga kalinya, dan waktu Dia kembali, Dia bertanya kepada mereka, “Apakah kamu masih tidur? Apakah kamu masih istirahat? Itu sudah cukup, karena waktunya sudah tiba! Lihat, Anak Manusia akan diserahkan ke tangan orang berdosa. ");
INSERT INTO indags_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangunlah! Mari kita pergi! Lihat, orang yang menyerahkan Aku sudah datang.” ");
INSERT INTO indags_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waktu Yesus masih bicara, Yudas — salah satu dari kedua belas murid-Nya — datang dengan segerombolan orang yang membawa pedang dan pentungan, yang dikirim oleh para imam kepala, pemimpin agama, dan para pemimpin orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sebelumnya Yudas sudah memberitahukan kepada mereka: “Dia yang saya peluk, itulah Yesus. Tangkap Dia, dan bawa Dia pergi dengan penjagaan.” ");
INSERT INTO indags_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas langsung mendekati Yesus dan berkata. “Guru,” lalu memeluk-Nya. ");
INSERT INTO indags_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dan orang-orang itu langsung menangkap Yesus. ");
INSERT INTO indags_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tetapi salah satu murid Yesus mengeluarkan parangnya dan menyerang pelayan imam besar, dan memotong salah satu telinganya sampai putus. ");
INSERT INTO indags_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lalu Yesus berkata kepada mereka, “Apakah kalian pikir Aku ini pemberontak sehingga kalian datang untuk menangkap Aku dengan menggunakan pedang dan pentungan?” ");
INSERT INTO indags_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","“Padahal Aku ada di sana bersama kalian, mengajar di rumah Tuhan setiap hari. Mengapa kalian tidak menangkap Aku? Tetapi ini terjadi untuk menggenapi apa yang sudah tertulis dalam Kitab Suci.” ");
INSERT INTO indags_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kemudian semua murid Yesus meninggalkan Dia dan melarikan diri. ");
INSERT INTO indags_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Salah satu pengikut-Nya adalah seorang pemuda yang hanya mengenakan pakaian linen. ");
INSERT INTO indags_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mereka menangkapnya, tetapi dia lari telanjang, meninggalkan pakaiannya. ");
INSERT INTO indags_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mereka membawa Yesus ke rumah imam besar tempat semua imam kepala, para pemimpin Yahudi, dan guru-guru agama berkumpul. ");
INSERT INTO indags_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus mengikuti Yesus dari kejauhan, dan sampai ke halaman rumah imam besar. Dia duduk bersama para penjaga dan menghangatkan diri di dekat api. ");
INSERT INTO indags_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Di dalam para imam kepala dan seluruh dewan pemerintahan mencoba mencari cara untuk membuktikan Yesus bersalah supaya mereka bisa membunuh Yesus. Tetapi mereka tidak menemukan bukti apa pun. ");
INSERT INTO indags_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Banyak yang memberikan kesaksian palsu terhadap Yesus, tetapi pernyataan mereka tidak setuju. ");
INSERT INTO indags_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Beberapa dari mereka berdiri memberi kesaksian palsu untuk melawan Yesus. ");
INSERT INTO indags_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kami mendengar Dia berkata, ‘Aku akan menghancurkan rumah Tuhan yang dibangun oleh tangan manusia ini, dan dalam tiga hari Aku akan membangun kembali yang baru.’” ");
INSERT INTO indags_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tetapi meski begitu kesaksian mereka tidak ada yang sama. ");
INSERT INTO indags_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kemudian imam besar berdiri di depan majelis, dan bertanya kepada Yesus, “Apakah kamu tidak punya apa-apa untuk dikatakan sebagai tanggapan atas tuduhan yang dibuat terhadap kamu ini?” ");
INSERT INTO indags_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tetapi Yesus tetap diam dan tidak menjawab. Jadi imam besar bertanya lagi, “Apakah kamu Mesias, Anak Allah Yang diberkati?” ");
INSERT INTO indags_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dan jawab Yesus, “Aku, dan kamu akan melihat Anak Manusia duduk di sebelah kanan Yang Mahakuasa, dan akan datang dari surga di antara awan-awan.” ");
INSERT INTO indags_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Maka imam besar merobek pakaiannya dan berkata, “Buat apa kita mencari saksi-saksi lain lagi? ");
INSERT INTO indags_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kalian telah mendengar penghujatan! Jadi bagaimana menurut kalian?” Mereka semua menganggapnya bersalah dan menghukumnya mati. ");
INSERT INTO indags_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kemudian beberapa dari mereka mulai meludahi Dia. Mereka juga menutup mata-Nya, memukul-Nya dengan tinju, dan berkata, “Kalau kamu seorang nabi, coba tebak, siapa yang baru memukul kamu!” Para penjaga membawanya pergi dan memukulinya. ");
INSERT INTO indags_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sementara semua itu terjadi, Petrus ada di bawah, di halaman. Salah satu perempuan pembantu imam agung lewat, ");
INSERT INTO indags_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","dan melihat Petrus sedang menghangatkan tubuhnya dekat api, menatap lurus ke arahnya dan berkata, “Kamu juga bersama Yesus dari Nazaret!” ");
INSERT INTO indags_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tetapi Petrus berkata, “Saya tidak tahu apa yang kamu bicarakan dan apa maksud kamu.” Kemudian dia pergi ke halaman depan, dan saat itu juga ayam jantan berkokok. ");
INSERT INTO indags_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Waktu pelayan perempuan itu melihat Petrus lagi, dia berkata kepada mereka yang berdiri di sekitar situ, “Orang ini adalah salah satu dari mereka yang mengikut Yesus!” ");
INSERT INTO indags_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sekali lagi Petrus menyangkalnya. Beberapa saat kemudian mereka berkata kepada Petrus lagi, “Kamu pasti salah satu dari mereka karena kamu juga orang Galilea!” ");
INSERT INTO indags_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lalu Petrus mulai berkata pada dirinya sendiri dan dia bersumpah, “Saya tidak tahu orang yang kalian bicarakan ini.” ");
INSERT INTO indags_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pada waktu ayam jantan berkokok untuk kedua kalinya. Lalu Petrus teringat apa yang Yesus katakan kepadanya: “Sebelum ayam berkokok dua kali, kamu akan menyangkal Aku tiga kali.” Ketika Petrus menyadari apa yang sudah dia lakukan, dia menangis dengan sangat sedih. ");
INSERT INTO indags_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Keesokan paginya, imam kepala, pemimpin-pemimpin Yahudi, dan guru-guru agama — seluruh dewan pemerintahan — sampai pada sebuah keputusan. Lalu mereka mengikat Yesus dan membawa-Nya pergi untuk diserahkan kepada Pilatus. ");
INSERT INTO indags_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus bertanya kepada-Nya, “Apakah kamu raja orang Yahudi?” “Kamu mengatakannya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Para imam kepala terus melontarkan banyak tuduhan terhadap-Nya. ");
INSERT INTO indags_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus kembali bertanya kepada Yesus, “Tidakkah Engkau akan menjawab tuduhan itu? Dengar betapa banyak tuduhan yang mereka berikan kepada-Mu!” ");
INSERT INTO indags_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tetapi Yesus tidak memberikan jawaban lagi, sehingga Pilatus sangat heran. ");
INSERT INTO indags_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Setiap tahun ada kebiasaan bahwa gubernur Pilatus selalu membebaskan seorang tahanan pada pesta Paskah, sesuai dengan permintaan banyak orang. ");
INSERT INTO indags_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pada waktu itu, salah satu tawanannya adalah seorang laki-laki bernama Barabas yang termasuk dalam kelompok pemberontak yang sudah melakukan pembunuhan selama pemberontakan. ");
INSERT INTO indags_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Orang banyak datang kepada gubernur Pilatus dan memintanya untuk membebaskan seorang tahanan mengikuti kebiasaan mereka. ");
INSERT INTO indags_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lalu Pilatus menjawab mereka, “Apakah kalian mau supaya saya membebaskan raja orang Yahudi untuk kalian?” ");
INSERT INTO indags_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Karena Pilatus menyadari bahwa para imam kepala iri hati kepada Yesus sehingga mereka menyerahkan Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tetapi para imam kepala menghasut orang banyak supaya Pilatus melepaskan Barabas untuk mereka sebagai ganti Yesus. ");
INSERT INTO indags_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Lalu Pilatus bertanya sekali lagi kepada mereka, “Apa yang harus saya lakukan dengan orang yang kalian sebut raja orang Yahudi?” ");
INSERT INTO indags_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tetapi mereka berteriak, “Salibkan dia!” ");
INSERT INTO indags_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Mengapa? Kejahatan apa yang sudah dia lakukan?” Pilatus bertanya pada mereka. Tetapi mereka semakin keras berteriak, “Salibkan dia!” ");
INSERT INTO indags_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Karena Pilatus ingin orang banyak itu senang kepadanya, maka dia melepaskan Barabas untuk mereka. Pertama dia menyuruh Yesus dicambuk dan kemudian menyerahkannya untuk disalibkan. ");
INSERT INTO indags_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lalu tentara-tentara membawa Yesus pergi ke halaman istana gubernur, lalu mereka memanggil semua tentara berkumpul di sana. ");
INSERT INTO indags_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sesudah mereka mencambuk Yesus, mereka memakaikan jubah ungu kerajaan pada-Nya dan membuat mahkota duri dan memakaikan di kepala-Nya. ");
INSERT INTO indags_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kemudian mereka pura-pura memberi hormat dan berkata, “Salam raja orang Yahudi!” ");
INSERT INTO indags_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mereka berulang kali memukul kepala-Nya dengan tongkat, meludahi Dia, dan berlutut di hadapan-Nya seolah-olah sedang memberi hormat kepada raja. ");
INSERT INTO indags_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sesudah mereka selesai mengejek Yesus, mereka melepaskan jubah ungu itu dan mengenakan kembali pakaian-Nya sendiri. Kemudian mereka membawa-Nya pergi untuk disalibkan. ");
INSERT INTO indags_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dalam perjalanan mereka bertemu dengan seorang yang sedang lewat dan memaksa dia untuk memikul salib. Orang itu adalah Simon dari Kirene, yang datang dari pedesaan. Simon adalah bapak dari Alexander dan Rufus. ");
INSERT INTO indags_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mereka membawa Yesus ke tempat yang disebut Golgota, yang berarti “Tempat Tengkorak”. ");
INSERT INTO indags_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mereka memberikan air anggur yang dicampur dengan mur, tetapi Yesus menolaknya. ");
INSERT INTO indags_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kemudian mereka menyalibkan Dia. Mereka membagi-bagi pakaian-Nya dengan cara membuang undi untuk memutuskan siapa yang akan mendapat bagian yang ditentukan. ");
INSERT INTO indags_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mereka menyalibkan Yesus sekitar jam sembilan pagi. ");
INSERT INTO indags_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lalu mereka memasang sebuah papan dibagian atas salib-Nya dengan tulisan yang menyatakan tuduhan terhadap-Nya yang berbunyi: “Raja orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bersama Yesus mereka menyalibkan dua orang penjahat, satu di kiri dan satu di kanan. ");
INSERT INTO indags_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Orang-orang yang melewati tempat itu menghina Dia. Mereka menggelengkan kepala, dan berkata. “Hei! Kamu yang dulu berkata bahwa kamu akan menghancurkan rumah Tuhan dan membangunnya kembali dalam tiga hari; ");
INSERT INTO indags_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","selamatkan dirimu dan turunlah dari salib!” ");
INSERT INTO indags_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Demikian pula para imam kepala dan guru-guru agama mengejek-ejek Yesus dengan suara keras, “Dia menyelamatkan orang lain, tetapi dia tidak bisa selamatkan dirinya sendiri. ");
INSERT INTO indags_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jika dia benar-benar Mesias, Raja Israel, mengapa dia tidak turun dari salib agar kita bisa melihat dan percaya!” Bahkan mereka yang disalibkan bersamanya menghina dia. ");
INSERT INTO indags_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pada jam dua belas siang, kegelapan menutupi seluruh negeri sampai jam tiga sore. ");
INSERT INTO indags_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pada jam tiga, Yesus berseru dengan suara keras, “Eloi, Eloi, lama sabaktani,” yang artinya, “Ya Allah, Allah-Ku, mengapa Engkau meninggalkan Aku?” ");
INSERT INTO indags_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Beberapa orang yang berdiri di sana mendengar ini, dan mereka berkata, “Dia memanggil Elia.” ");
INSERT INTO indags_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Seorang laki-laki berlari dan mengambil spons dan mencelupkannya ke dalam air anggur yang asam, menaruhnya di atas tongkat, dan mencoba memberikannya kepada Yesus untuk diminum. “Tinggalkan dia sendiri,” katanya. Mari kita lihat apakah Elia akan datang untuk menurunkan dia dari salib ini. ");
INSERT INTO indags_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kemudian Yesus berteriak dengan keras, dan mati. ");
INSERT INTO indags_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Waktu Yesus mati, gorden rumah Tuhan robek dari atas sampai ke bawah menjadi dua bagian. ");
INSERT INTO indags_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ketika perwira yang berdiri di depan salib Yesus melihat bagaimana Yesus mati, dia berkata, “Orang ini benar-benar Anak Allah.” ");
INSERT INTO indags_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Di situ ada beberapa perempuan yang berdiri dan melihat dari jauh termasuk Maria Magdalena, Maria ibu dari Yakobus Muda dan Yoses, dan Salome. ");
INSERT INTO indags_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mereka sudah mengikuti Yesus dan menjaganya selama dia di Galilea. Banyak perempuan lain yang ikut bersama-Nya ke Yerusalem juga ada di sana. ");
INSERT INTO indags_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Saat itu hari Jumat, sehari sebelum hari Sabat. ");
INSERT INTO indags_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Karena itu Yusuf dari Arimatea, seorang anggota dewan pimpinan yang menunggu kerajaan Allah, memiliki keberanian untuk pergi ke Pilatus dan meminta jenazah Yesus. ");
INSERT INTO indags_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus heran waktu mendengar bahwa Yesus sudah mati begitu cepat, jadi dia memanggil perwira itu dan bertanya apakah Yesus sudah mati. ");
INSERT INTO indags_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sesudah Pilatus mendengar laporan dari perwira itu, Pilatus memberikan izin kepada Yusuf untuk mengambil jenazah Yesus. ");
INSERT INTO indags_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lalu Yusuf membeli kain putih. Kemudian dia menurunkan tubuh Yesus dari salib dan membungkusnya dengan kain itu, dan menaruh jenazah Yesus di dalam kuburan yang sudah digali dari batu. Lalu dia menggulingkan batu besar sebagai penutup pintu kubur. ");
INSERT INTO indags_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena dan Maria ibu dari Yoses melihat tempat Yesus dibaringkan. ");
INSERT INTO indags_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sesudah Sabat berakhir, pagi-pagi sekali Maria Magdalena, Maria ibu Yakobus, dan Salome membeli minyak yang harum agar mereka bisa pergi dan meminyaki tubuh Yesus. ");
INSERT INTO indags_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sangat awal pada hari pertama minggu itu, tepat saat matahari terbit, mereka pergi ke kuburan. ");
INSERT INTO indags_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mereka bertanya satu sama lain, “Siapa yang akan menggulingkan batu itu dari kubur untuk kita?” ");
INSERT INTO indags_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tetapi ketika mereka tiba di kuburan, mereka melihat bahwa batu yang sangat besar dan berat sudah terguling. ");
INSERT INTO indags_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ketika mereka pergi ke kuburan, mereka melihat seorang pemuda duduk di dalam gua sebelah kanan, mengenakan jubah putih panjang. Mereka menjadi sangat ketakutan. ");
INSERT INTO indags_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tetapi malaikat itu berkata kepada mereka, “Jangan takut! Kalian mencari Yesus, Orang Nazaret yang sudah disalibkan itu. Dia sudah bangkit dari kematian. Dia tidak ada di sini. ");
INSERT INTO indags_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lihat, ini adalah tempat mereka membaringkan-Nya untuk beristirahat. Sekarang pergi, dan beritahu murid-murid-Nya dan Petrus bahwa Dia akan mendahului kalian ke Galilea. Kalian akan melihat Yesus di sana seperti yang Dia pernah katakan.” ");
INSERT INTO indags_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mereka pergi dan berlari dari kuburan itu, karena gemetar dan bingung. Mereka tidak bicara apa-apa kepada siapa pun karena mereka terlalu takut. ");
INSERT INTO indags_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ketika Yesus bangkit dari kematian pada hari pertama minggu itu, Dia pertama-tama Yesus menampakkan diri kepada Maria Magdalena, yang pernah Yesus mengusir tujuh roh jahat. ");
INSERT INTO indags_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lalu Maria memberitahukan hal itu kepada orang-orang yang dulu bersamanya saat mereka masih berduka dan menangis. ");
INSERT INTO indags_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ketika mereka mendengar bahwa Yesus sudah hidup kembali dari kematian dan bahwa dia sudah melihat-Nya, mereka tidak percaya. ");
INSERT INTO indags_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kemudian Yesus menampakkan diri dalam bentuk yang berbeda kepada dua murid lainnya yang akan pergi ke sebuah desa. ");
INSERT INTO indags_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kedua murid itu kembali dan memberitahukan kepada yang lain, tetapi mereka tidak percaya juga. ");
INSERT INTO indags_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Akhirnya Yesus memperlihatkan diri kepada sebelas murid-Nya saat mereka sedang makan. Dia menegur mereka karena mereka kurang percaya dan keras kepala, karena mereka tidak percaya kepada orang-orang yang telah melihatnya setelah dia bangkit. ");
INSERT INTO indags_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kemudian Yesus berkata kepada mereka, “Pergilah ke seluruh dunia, dan beritakanlah Kabar Baik kepada semua orang. ");
INSERT INTO indags_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Siapa pun yang percaya kepada-Ku dan dibaptis akan diselamatkan, tetapi siapa pun yang memilih untuk tidak percaya akan dihukum. ");
INSERT INTO indags_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Dan tanda-tanda berikut akan menyertai mereka yang percaya kepada-Ku: dalam nama-Ku mereka akan mengusir setan; mereka akan berbicara bahasa baru; ");
INSERT INTO indags_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mereka akan memegang ular dengan tangan mereka; jika mereka meminum sesuatu yang beracun mereka tidak akan sakit dan mati; mereka akan meletakkan tangan pada orang sakit dan menjadi sembuh.” ");
INSERT INTO indags_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kemudian, Tuhan Yesus, sesudah Dia selesai berbicara dengan murid-murid-Nya, Dia terangkat ke surga, di mana Dia duduk di sebelah kanan Allah. ");
INSERT INTO indags_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lalu para murid Yesus pergi dan memberitakan Kabar Baik ke mana-mana, dan Tuhan Yesus menyertai mereka dan melakukan banyak keajaiban sebagai bukti bahwa Kabar Baik itu benar. Amin. ");
INSERT INTO indags_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Seperti yang kamu tahu, banyak orang telah mencoba menuliskan segala sesuatu yang telah terpenuhi melibatkan kami. ");
INSERT INTO indags_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mereka mendasarkan laporan mereka pada bukti dari saksi mata yang paling awal dan pelayan Firman, ");
INSERT INTO indags_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","maka sayapun memutuskan sebab saya juga mengikuti peristiwa-peristiwa yang sudah terjadi mulai dari awalnya, maka merupakan ide yang baik untuk menuliskannya dengan akurat. ");
INSERT INTO indags_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Saya melakukan ini Teofilus terkasih agar kamu bisa yakin bahwa apa yang diajarkan kepadamu benar-benar bisa dipercaya. ");
INSERT INTO indags_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ketika masa Herodes menjadi Raja di Yudea, ada seorang imam yang bernama Zakaria, dari keluarga Abia. Zakaria menikah dengan Elisabet, yang juga adalah keturunan dari Imam Harun. ");
INSERT INTO indags_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mereka berdua melakukan apa yang benar di hadapan Allah, dengan hati-hati mengikuti semua perintah dan peraturan Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mereka tidak memiliki anak sebab Elisabet mandul, dan mereka berdua sudah lanjut usia. ");
INSERT INTO indags_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ketika Zakaria sedang bertugas sebagai imam di hadapan Allah, sebagai wakil dari kelompok imamnya ");
INSERT INTO indags_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakaria dipilih berdasarkan undian menurut adat keimaman untuk masuk ke dalam rumah Tuhan dan membakar dupa. ");
INSERT INTO indags_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Selama waktu persembahan dupa, kerumunan masyarakat sedang berdoa di luar. ");
INSERT INTO indags_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Seorang malaikat Tuhan muncul di hadapan Zakaria, berdiri di sebelah kanan mezbah dupa. ");
INSERT INTO indags_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ketika Zakaria melihat malaikat itu, tertegunlah dia dan merasa takut sekali. ");
INSERT INTO indags_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tetapi malaikat itu berkata kepadanya, “Janganlah takut, hai Zakaria. Allah sudah mendengar doamu. Elisabet, istrimu itu, akan mengandung dan melahirkan seorang anak laki-laki, dan kamu akan memberi nama anak itu, Yohanes. ");
INSERT INTO indags_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dia akan memberikan kamusukacita dan kebahagiaan, dan banyak yang akan merayakan kelahirannya. ");
INSERT INTO indags_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Anakmu itu akan menjadi luar biasa di hadapan Tuhan. Dia tidak akan mau minum air anggur ataupun minuman yang memabukkan lainnya. Dan dia akan dipenuhi oleh Roh Allah bahkan sebelum dia dilahirkan. ");
INSERT INTO indags_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dia akan membuat banyak orang Israel kembali percaya kepada Tuhan Allah mereka. ");
INSERT INTO indags_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dia akan mendahului Tuhan dalam roh dan kuasa Elia, untuk mengembalikan hati para ayah kepada anak-anak mereka, dan mereka yang memberontak kembali ke jalan yang benar — untuk mempersiapkan orang-orang menerima Tuhan.” ");
INSERT INTO indags_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","“Bagaimana saya bisa yakin hal itu akan terjadi?” tanya Zakaria kepada malaikat. “Aku sudah tua, demikian juga istriku.” ");
INSERT INTO indags_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Aku adalah Gabriel,” jawab sang Malaikat. “Aku berdiri di hadapan Allah, dan dikirim untuk berbicara kepadamu dan memberitakan kepadamu kabar baik ini. ");
INSERT INTO indags_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tetapi karena kamu tidak percaya pada perkataanku, kamu akan menjadi bisu, tidak dapat berkata-kata, sampai pada waktunya ketika setiap ucapanku menjadi kenyataan.” ");
INSERT INTO indags_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sementara di luar orang-orang sedang menunggu Zakaria, dan bertanya-tanya mengapa dia begitu lama ada di dalam rumah Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ketika akhirnya Zakaria keluar, dia tidak bisa mengucapkan perkataan apa pun kepada mereka. Mereka menyadari bahwa tentunya Zakaria mendapat penglihatan di rumah Tuhan, sebab sekalipun dia bisa memberi bahasa isyarat, tetapi Zakaria benar-benar menjadi bisu. ");
INSERT INTO indags_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sesudah selesai masa bertugasnya, kembalilah Zakaria ke rumah. ");
INSERT INTO indags_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Beberapa waktu kemudian, Elisabet, istri Zakaria mengandung. Dan dia tinggal di rumah selama lima bulan lamanya. ");
INSERT INTO indags_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tuhan yang melakukan ini kepadaku,” katanya, “Tuhan sudah mengambil aibku di mata orang lain.” ");
INSERT INTO indags_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pada bulan ke enam di masa kehamilan Elisabet, Allah mengirim malaikat Gabriel kepada seorang perempuan muda yang bernama Maria, yang tinggal di kota Nazaret di Galilea. ");
INSERT INTO indags_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Maria bertunangan dengan seorang pemuda yang bernama Yusuf. ");
INSERT INTO indags_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sang malaikat menyapa Maria. “Sungguh dirimu ini diberkati, Maria,” kata malaikat. “Tuhan beserta denganmu.” ");
INSERT INTO indags_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria sangat bingung dengan apa yang dia katakan, dan bertanya-tanya apa arti salam ini. ");
INSERT INTO indags_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Janganlah kuatir, Maria,” lanjut malaikat itu, “sebab Allah menunjukkan kebaikan hati-Nya kepadamu. ");
INSERT INTO indags_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kamu akan mengandung dan melahirkan seorang anak laki-laki. Dan kamu akan memberi nama Yesus kepada anak itu. ");
INSERT INTO indags_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dia akan menjadi sangat hebat, dan dia akan disebut Anak Yang Mahatinggi. Tuhan Allah akan memberinya takhta Daud, ayahnya, ");
INSERT INTO indags_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","dan Dia akan memerintah atas bangsa Israel selamanya. Kerajaan-Nya tidak akan pernah berakhir.” ");
INSERT INTO indags_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Bagaimana mungkin hal itu terjadi?” kata Maria. “Saya ini seorang perawan.” ");
INSERT INTO indags_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jawab malaikat itu, “Roh Kudus akan datang ke atasmu, dan kuasa dari Yang Mahatinggi akan menguasaimu. Bayi yang ada dalam kandunganmu itu kudus, dan akan dipanggil dengan sebutan Anak Allah. ");
INSERT INTO indags_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dan sepupumu, Elisabet, bahkan dia hamil di usia tuanya. Wanita yang dikatakan orang tidak bisa punya anak itu sudah hamil enam bulan. ");
INSERT INTO indags_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tidak ada sesuatu yang tidak mungkin bagi Allah.” ");
INSERT INTO indags_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Aku ini pelayan Tuhan,” kata Maria. “Terjadilah padaku sesuai dengan perkataanmu.” Lalu malaikat itu meninggalkan Maria. ");
INSERT INTO indags_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Beberapa waktu kemudian, Maria menyiapkan dirinya, dan pergi ke daerah perbukitan Yudea, ke kota kecil tempat ");
INSERT INTO indags_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakaria tinggal. Maria memanggil Elisabet ketika dia masuk ke rumah mereka. ");
INSERT INTO indags_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Segera ketika Elisabet mendengar suara Maria, bayi yang ada dalam kandungannya seakan-akan melompat kegirangan di dalam perutnya. Dan Elisabet penuh dengan Roh Kudus, ");
INSERT INTO indags_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dan berseru dengan suara nyaring, “Diberkatilah kamu di antara para perempuan, dan diberkatilah anak yang akan kamu lahirkan itu! ");
INSERT INTO indags_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mengapa saya begitu terhormat bahwa ibu Tuhan saya harus mengunjungi saya? ");
INSERT INTO indags_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Segera sesudah saya mendengar salammu, bayi saya melompat kegirangan di dalam diri saya. ");
INSERT INTO indags_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Betapa beruntungnya kamu, sebab kamu percaya bahwa Tuhan akan melakukan apa yang Dia janjikan kepadamu!” ");
INSERT INTO indags_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jawab Maria, “Sungguh saya memuji Tuhan! ");
INSERT INTO indags_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aku bersukacita karena Allah penyelamatku, ");
INSERT INTO indags_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sebab Dia sudah memutuskan bahwa saya, hamba-Nya, layak mendapat perhatian-Nya, meskipun latar belakangku hanya orang biasa saja. Mulai dari sekarang, setiap generasi akan berkata bahwa saya sungguh diberkati. ");
INSERT INTO indags_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Allah yang Mahakuasa sudah melakukan perbuatan-perbuatan yang luar biasa untukku, kuduslah nama-Nya. ");
INSERT INTO indags_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Belas kasihan-Nya dari generasi ke generasi terus selamanya kepada mereka yang hormat kepada Dia. ");
INSERT INTO indags_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dengan kuasa-Nya Dia telah menghancurkan orang-orang yang dengan sombongnya berpikir bahwa mereka sangat pintar. ");
INSERT INTO indags_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tuhan meruntuhkan orang-orang yang berkuasa dari tahta mereka, dan menaikkan orang-orang yang rendah hati. ");
INSERT INTO indags_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dan memberi makan orang-orang yang lapar dengan makanan yang enak, dan mengirim orang-orang kaya pergi dengan tangan kosong. ");
INSERT INTO indags_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tuhan menolong hamba-Nya Israel, mengingat dia dalam belas kasihan-Nya, ");
INSERT INTO indags_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","seperti janji-Nya kepada nenek moyang kita, kepada Abraham dan keturunannya sampai selamanya.” ");
INSERT INTO indags_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dan Maria tinggal di rumah Elisabet tiga bulan lamanya, lalu dia kembali pulang. ");
INSERT INTO indags_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sementara itu, tibalah waktunya bagi Elisabet untuk melahirkan bayinya. ");
INSERT INTO indags_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Para tetangga dan keluarga besarnya mendengar bagaimana Tuhan menunjukkan kebaikan yang sangat besar kepadanya, dan bersama-sama mereka bersukacita. ");
INSERT INTO indags_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Delapan hari kemudian mereka datang untuk menyunat anak itu. Bermaksud menamakan anak itu Zakaria seperti nama ayahnya. ");
INSERT INTO indags_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","“Bukan,” jawab Elisabet. “Namanya adalah Yohanes.” ");
INSERT INTO indags_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Tetapi tidak seorangpun di antara keluargamu yang memiliki nama itu,” kata mereka kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mereka bertanya kepada Zakaria, ayah anak itu, dengan menggunakan bahasa isyarat, “Bapak hendak memberi nama apa kepada anak bapak?” ");
INSERT INTO indags_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakharia memberi isyarat untuk menulis sesuatu, dan menulis, “Namanya adalah Yohanes.” Dan semua orang heran membacanya. ");
INSERT INTO indags_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dengan segera Zakaria bisa berbicara kembali, dan dia mulai memuji Allah. ");
INSERT INTO indags_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mereka yang tinggal di sekeliling rumah itu kagum dengan apa yang sudah terjadi, dan berita itu tersebar sampai ke seluruh bagian perbukitan di Yudea. ");
INSERT INTO indags_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Setiap orang yang mendengar berita itu bertanya-tanya apa yang sesungguhnya akan terjadi. “Akan menjadi apa anak ini jika besar nanti?” tanya mereka, sebab mereka tahu bahwa Allah menyertai anak ini. ");
INSERT INTO indags_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaria, ayah anak itu, oleh karena dipenuhi Roh Kudus mulai menubuatkan perkataan ini: ");
INSERT INTO indags_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tuhan, Allah orang Israel, sungguh ajaib sebab Dia datang dan membebaskan umat-Nya. ");
INSERT INTO indags_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sudah diberikan oleh-Nya seorang Juruselamat dari garis keturunan Daud, ");
INSERT INTO indags_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","seperti yang sudah Dia janjikan melalui para nabi-Nya yang kudus dari masa lampau. ");
INSERT INTO indags_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dia berjanji akan menyelamatkan kita dari musuh-musuh kita, dari orang-orang yang membenci kita. ");
INSERT INTO indags_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dia bermurah hati kepada nenek moyang kita sebab Dia ingat perjanjian kudus-Nya — ");
INSERT INTO indags_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","janji yang Dia buat dengan Abraham, bapak leluhur kita. ");
INSERT INTO indags_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Dia membebaskan kita dari rasa takut dan menyelamatkan kita dari musuh-musuh kita, ");
INSERT INTO indags_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","agar kita bisa melayani Dia dengan cara melakukan perbuatan-perbuatan yang baik dan benar selama hidup kita. ");
INSERT INTO indags_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sekalipun kamu masih kecil, kamu akan dikenal sebagai nabi dari Allah yang Mahatinggi, sebab kamu akan berjalan di depan Tuhan dan membuka jalan bagi-Nya, ");
INSERT INTO indags_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","dengan memberikan pengetahuan tentang keselamatan melalui pengampunan atas dosa-dosa manusia kepada umat-Nya. ");
INSERT INTO indags_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Melalui kasih sayang Allah atas kita, keselamatan yang dari surga akan turun atas kita ");
INSERT INTO indags_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","untuk menyinari mereka yang hidup dalam kegelapan dan bayang-bayang kematian dan untuk membimbing kita sepanjang jalan yang membawa damai.” ");
INSERT INTO indags_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohanes bertambah besar dan bertambah kuat rohaninya. Dia hidup di padang gurun sampai tiba saatnya untuk dia melayani umat Israel dengan terbuka. ");
INSERT INTO indags_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Itu adalah waktu ketika Kaisar Agustus mengeluarkan sebuah perintah untuk diadakannya perhitungan jumlah penduduk di seluruh Kerajaan Romawi. ");
INSERT INTO indags_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sensus ini adalah sensus pertama di bawah pemerintahan Gubernur Kirenius di wilayah Siria. ");
INSERT INTO indags_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Maka setiap penduduk pergi ke kota kelahiran mereka untuk mendaftarkan dirinya. ");
INSERT INTO indags_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Oleh karena Yusuf adalah keturunan dari Raja Daud, maka dia berangkat dari Nazaret yang terletak di daerah Galilea menuju ke Betlehem, yang dikenal sebagai kota Daud, di daerah Yudea. ");
INSERT INTO indags_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dia pergi mendaftarkan dirinya di kota itu bersama dengan Maria, yang sudah bertunangan dengannya dan sedang menantikan kelahiran bayinya. ");
INSERT INTO indags_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sementara mereka di sana, tiba waktunya bagi Maria untuk melahirkan bayinya. ");
INSERT INTO indags_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dan Maria melahirkan anak laki-laki sulungnya. Dia membungkusnya dengan kain dan membaringkannya di palungan karena penginapan tidak memiliki kamar lagi. ");
INSERT INTO indags_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Di dekat daerah itu, beberapa orang gembala menghabiskan malam hari dengan menggembalakan domba-domba mereka di padang rumput. ");
INSERT INTO indags_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Seorang malaikat Tuhan muncul di hadapan mereka, dan kemuliaan Tuhan bersinar mengelilingi mereka. Mereka sangat ketakutan. ");
INSERT INTO indags_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Jangan takut!” kata malaikat itu kepada mereka. “Aku di sini untuk membawakan kabar baik kepada kalian yang akan membuat seluruh umat manusia bersukacita. ");
INSERT INTO indags_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Seorang Juruselamat sudah lahir bagi kalian hari ini, di kota Daud. Dia adalah Mesias, Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kalian akan mengenali Dia dengan tanda ini, yaitu, kalian akan menemukan seorang anak yang dibungkus dengan kain dan diletakkan di dalam palungan.” ");
INSERT INTO indags_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tiba-tiba banyak sekali malaikat yang muncul, memuji Allah dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kemuliaan bagi Allah yang di surga, dan damai di bumi kepada mereka yang menyenangkan Dia.” ");
INSERT INTO indags_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sesudah para malaikat meninggalkan mereka dan kembali ke surga, para gembala itu saling berkata, “Mari kita pergi ke Betlehem dan lihat kejadian yang sudah terjadi seperti yang sudah diceritakan oleh Tuhan kepada kita.” ");
INSERT INTO indags_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mereka dengan bergegas pergi ke Betlehem dan menemukan Maria, Yusuf, serta bayi itu, yang sedang berbaring di palungan. ");
INSERT INTO indags_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sesudah mereka melihat Dia dengan mata mereka sendiri, mereka menyebarkan berita tentang segala sesuatu yang terjadi dan tentang si bayi yang sudah mereka dengar. ");
INSERT INTO indags_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dan mereka yang mendengar berita ini kagum dengan apa yang para gembala ceritakan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tetapi Maria mengingat dan merenungkan segala kejadian yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Para gembala kembali menjaga ternak-ternak mereka, memuji dan bersyukur kepada Allah untuk segala berita yang sudah mereka dengar dan lihat, sebab sama seperti yang sudah pernah diberitahukan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sesudah Yesus berumur delapan hari, tiba waktunya bagi bayi itu untuk disunat, dan diberi nama Yesus. ");
INSERT INTO indags_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ketika tiba waktunya penyucian sesuai dengan hukum Taurat selesai dilaksanakan, Yusuf dan Maria membawa Yesus ke Yerusalem untuk diserahkan kepada Tuhan, ");
INSERT INTO indags_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","seperti yang Tuhan sudah perintahkan, “Setiap anak laki-laki sulung haruslah diserahkan kepada Tuhan.” ");
INSERT INTO indags_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Lalu di sana mereka memberikan kurban persembahan, seperti hukum Allah perintahkan, berupa “sepasang burung tekukur atau dua ekor burung merpati muda.” ");
INSERT INTO indags_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pada masa itu hiduplah seorang laki-laki bernama Simeon di Yerusalem. Simeon melakukan perbuatan yang benar dan sangat berbakti kepada Allah. Dia sangat menanti-nantikan janji Tuhan akan keselamatan bagi Israel, dan Roh Kudus ada di atasnya. ");
INSERT INTO indags_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roh Kudus sudah ditunjukkan kepadanya bahwa dia tidak akan mati sebelum dia bertemu dengan Tuhan sang Mesias. ");
INSERT INTO indags_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dengan mengikuti arahan Roh Kudus, Simeon datang ke Rumah Allah ketika orangtua Yesus membawanya untuk diserahkan kepada Tuhan sesuai dengan ketentuan Hukum Taurat. ");
INSERT INTO indags_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon menggendong Yesus, mengucap syukur kepada Allah, dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tuhanku, sekarang ijinkanlah hamba-Mu ini meninggal dengan tenang seperti yang sudah Engkau janjikan, ");
INSERT INTO indags_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","sebab sudah kulihat dengan mataku sendiri bagaimana Engkau akan menyelamatkan umat-Mu, ");
INSERT INTO indags_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yang sudah Engkau persiapkan bagi semua orang. ");
INSERT INTO indags_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dia akan menjadi seperti terang yang akan menerangi bangsa-bangsa lain, Dia akan menjadi kemuliaan bagi umat-Mu orang Israel.” ");
INSERT INTO indags_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ayah dan ibu Yesus terkejut mendengar perkataan Simeon tentang Yesus. ");
INSERT INTO indags_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lalu Simeon memberkati mereka, dan berkata kepada Maria, ibu Yesus, “Anak ini ditakdirkan untuk menyebabkan banyak orang di Israel yang jatuh dan yang bangkit. Anak ini adalah tanda dari Allah bahwa banyak dari mereka yang akan menolak, ");
INSERT INTO indags_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sebab Dia akan menyatakan pikiran-pikiran yang tersembunyi dalam benak mereka. Hal itu akan terasa seperti sebuah pedang yang menembus jantungmu, Ibu.” ");
INSERT INTO indags_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lalu nabiah Hana juga tinggal di Yerusalem. Dia adalah anak perempuan dari Fanuel dari suku Asyer, dan sudah sangat tua. Dia sudah menikah selama tujuh tahun, ");
INSERT INTO indags_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","namun sesudah itu dia menjadi janda, sebab suaminya meninggal dunia. Usianya sudah 84 tahun. Dia menghabiskan waktunya dengan menyembah, berpuasa dan berdoa di rumah Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dia juga menghampiri mereka kala itu, dan mulai memuji Allah. Dia berbicara tentang Yesus kepada semua yang menanti-nantikan waktunya Allah untuk membebaskan Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sesudah mereka menyelesaikan segala sesuatu yang diperinthakan oleh hukum Allah, mereka kembali ke rumah mereka di kota Nazaret di Galilea. ");
INSERT INTO indags_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anak itu tumbuh bertambah kuat dan sangat bijak. Berkat Allah ada bersama Dia. ");
INSERT INTO indags_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Orang tua Yesus pergi ke Yerusalem setiap tahun untuk merayakan Paskah. ");
INSERT INTO indags_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ketika Yesus berusia 12 tahun, Yesus ikut mereka ke perayaan tersebut. ");
INSERT INTO indags_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ketika perayaan sudah selesai dan sudah tiba waktunya kembali ke kota asal, Yesus yang masih kanak-kanak itu tetap tinggal di Yerusalem, namun orang tua-Nya tidak menyadari hal ini. ");
INSERT INTO indags_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Orang tua Yesus berpikir kalau Yesus bersama dengan rombongan anak-anak yang juga sedang kembali pulang. Sehari perjalanan sudah berlalu sebelum mereka mulai mencari Dia diantara teman dan keluarga mereka. ");
INSERT INTO indags_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ketika mereka tidak bisa menemukan-Nya, kembalilah mereka ke Yerusalem untuk mencari Dia di sana. ");
INSERT INTO indags_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sudah berlalu tiga hari sebelum mereka berhasil menemukan Yesus di rumah Tuhan. Yesus sedang duduk di antara para guru-guru agama, mendengarkan mereka dan bertanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Semua yang mendengarkan cara Yesus berbicara terkejut dengan pemahaman dan jawaban-jawaban-Nya. ");
INSERT INTO indags_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Orangtua-Nya sungguh-sungguh bingung ketika mereka melihat apa yang sedang dilakukan-Nya. Ibu-Nya bertanya kepada-Nya, “Putraku, mengapa Kamu memperlakukan kami seperti ini? Ayah-Mu dan aku — kami sudah sangat kuatir! Kami mencari-Mu kemana-mana!” ");
INSERT INTO indags_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Mengapa Ibu mencari Aku?” jawab Yesus. “Tidakkah Ibu tahu bahwa Aku harus ada di rumah Bapa-Ku?” ");
INSERT INTO indags_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tetapi mereka tidak mengerti arti perkataan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lalu kembalilah Dia bersama mereka ke Nazaret, dan taat kepada kedua orangtuanya. Ibu-Nya menyimpan setiap kejadian yang sudah terjadi dan sering merenungkannya. ");
INSERT INTO indags_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dan Yesus semakin kuat dan semakin bijak, dan disukai oleh Allah dan manusia. ");
INSERT INTO indags_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saat ini adalah tahun ke lima belas Tiberius menjadi Kaisar di Roma. Pontius Pilatus menjadi Gubernur di wilayah Yudea. Herodes adalah penguasa Galilea, dan Filipus adalah penguasa Iturea dan Trakonitis, serta Lisanias sebagai penguasa daerah Abilene. ");
INSERT INTO indags_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanas dan Kayafas adalah imam besar yang bertanggung jawab. Pada masa inilah Firman Allah datang kepada Yohanes, anak Zakaria, yang hidup di padang gurun. ");
INSERT INTO indags_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanes pergi ke seluruh wilayah Sungai Yordan, mengumumkan kepada setiap orang bahwa mereka harus dibaptis sebagai tanda pertobatan dan bahwa dosa-dosa mereka sudah diampuni. ");
INSERT INTO indags_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Seperti yang sudah ditulis oleh nabi Yesaya: “Terdengar suara di padang gurun yang berteriak, ‘Persiapkanlah jalan bagi Tuhan: luruskanlah jalan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Setiap lembah akan ditinggikan, setiap gunung dan bukit akan diratakan. Jalan yang bengkok akan diluruskan, dan jalan yang berbatu-batu akan dihaluskan. ");
INSERT INTO indags_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dan setiap orang akan melihat keselamatan yang datang dari Allah.’” ");
INSERT INTO indags_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tetapi ketika Yohanes melihat banyak orang Farisi dan Saduki yang datang dan minta diri untuk dibaptis, berkatalah dia kepada mereka, “Dasar kalian keturunan ular berbisa! Siapa yang bilang kalian bisa melarikan diri dari penghukuman yang akan datang? ");
INSERT INTO indags_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tunjukkan dengan perbuatan kalian bahwa kalian sungguh-sungguh bertobat. Jangan sekali-kali membenarkan diri kalian dengan mengatakan, ‘Kami ini keturunan Abraham.’ Biar saya katakan kepada kalian, Allah bisa menciptakan anak-anak bagi Abraham dari batu-batu ini. ");
INSERT INTO indags_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kapak diatur untuk mulai menebang di pangkal pohon. Setiap pohon yang tidak menghasilkan buah yang baik akan ditebang dan dibuang ke dalam api.” ");
INSERT INTO indags_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Jadi, apa yang harus kami lakukan?” tanya orang banyak kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Jika kalian punya dua jubah, maka bagilah dengan mereka yang tidak punya. Jika kalian punya makanan, maka berbagilah kepada mereka yang tidak punya,” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dan beberapa penagih pajak juga datang untuk dibaptis. “Guru, apakah yang harus kami lakukan?” tanya mereka. ");
INSERT INTO indags_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Janganlah menagih pajak lebih dari yang seharusnya,” jawab Yohanes. ");
INSERT INTO indags_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","“Bagaimana dengan kami?” beberapa prajurit bertanya. “Apa yang harus kami lakukan?” “Jangan meminta uang dengan ancaman kekejaman. Jangan membuat tuduhan yang tidak benar. Cukupkanlah dirimu dengan gajimu,” jawab Yohanes. ");
INSERT INTO indags_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Orang-orang menantikan dengan penuh harap, dan bertanya-tanya apakah Yohanes adalah Mesias itu sendiri. ");
INSERT INTO indags_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohanes menjawab dan menjelaskan kepada semua orang, “Benar, saya membaptis kalian dengan air. Tetapi Dia yang akan datang lebih penting dariku, dan saya bahkan tidak layak untuk melepaskan sandal-Nya. Dia akan membaptis kalian dengan Roh Kudus dan dengan api. ");
INSERT INTO indags_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Alat penampi sudah ada di tangan-Nya dan dia siap untuk memisahkan gandum dari kulitnya pada tempat pengirikan. Dia akan mengumpulkan biji-biji gandum di gudang penyimpanan, sedangkan kulitnya akan dibakar dengan api yang tidak bisa padam.” ");
INSERT INTO indags_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanes memberikan banyak peringatan seperti ini ketika dia memberitakan tentang kabar baik itu kepada orang-orang. ");
INSERT INTO indags_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tetapi ketika Yohanes menegur Herodes sang penguasa karena menikah dengan Herodias yang adalah istri saudaranya, dan tentang segala kejahatan yang sudah dilakukan Herodes, ");
INSERT INTO indags_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","maka Herodes menambahkan kejahatannya dengan memasukan Yohanes ke dalam penjara. ");
INSERT INTO indags_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ternyata terjadi ketika sesudah semua orang dibaptis, Yesuspun dibaptis juga. Dan ketika Dia berdoa, surga terbuka, ");
INSERT INTO indags_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","dan Roh Kudus turun ke atas-Nya, dengan mengambil wujud seekor burung merpati. Dan terdengar suara dari surga, berkata, “Engkaulah anak-Ku, yang Ku kasihi. Aku sungguh berkenan kepada-Mu.” ");
INSERT INTO indags_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus berumur sekitar tiga puluh tahun ketika memulai pelayanan-Nya secara umum. Orang-orang menduga bahwa Dia adalah anak Yusuf. Yusuf adalah anak Eli, ");
INSERT INTO indags_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","anak Matat, anak Lewi, anak Malki, anak Yanai, anak Yusuf, ");
INSERT INTO indags_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","anak Matatias, anak Amos, anak Nahum, anak Esli, anak Nagai, ");
INSERT INTO indags_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","anak Maat, anak Matatias, anak Simei, anak Yosek, anak Yoda, ");
INSERT INTO indags_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","anak Yohanan, anak Resa, anak Zerubabel, anak Sealtiel, anak Neri, ");
INSERT INTO indags_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","anak Malki, anak Adi, anak Kosam, anak Elmadam, anak Er, ");
INSERT INTO indags_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","anak Yesua, anak Eliezer, anak Yorim, anak Matat, anak Lewi, ");
INSERT INTO indags_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","anak Simeon, anak Yehuda, anak Yusuf, anak Yonam, anak Elyakim, ");
INSERT INTO indags_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","anak Melea, anak Mina, anak Matata, anak Natan, anak Daud, ");
INSERT INTO indags_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","anak Isai, anak Obed, anak Boas, anak Salmon, anak Nahason, ");
INSERT INTO indags_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","anak Aminadab, anak Aram, anak Hesro, anak Peres, anak Yehuda, ");
INSERT INTO indags_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","anak Yakub, anak Isak, anak Abraham, anak Terah, anak Nahor, ");
INSERT INTO indags_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","anak Serug, anak Ragau, anak Peleg, anak Eber, anak Salmon, ");
INSERT INTO indags_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","anak Kenan, anak Arfaksad, anak Sem, anak Nuh, anak Lamek, ");
INSERT INTO indags_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","anak Metusalah, anak Henok, anak Yared, anak Mahalaleel, anak Kenan, ");
INSERT INTO indags_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","anak Enos, anak Set, anak Adam, anak Allah. ");
INSERT INTO indags_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus, yang dipenuhi oleh Roh Kudus, kembali dari sungai Yordan dan dipimpin oleh Roh itu ke padang gurun, ");
INSERT INTO indags_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","tempat di mana Dia dicobai oleh Iblis selama empat puluh hari. Dia tidak makan ataupun minum selama itu, sehingga ketika hari terakhir puasa, Yesus merasa kelaparan. ");
INSERT INTO indags_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lalu Iblis berkata kepada-Nya, “Jika Engkau anak Allah, perintahkanlaha agar batu ini berubah menjadi roti.” ");
INSERT INTO indags_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","“Ada tertulis, ‘Janganlah kamu hidup hanya dari roti saja,’” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lalu Iblis memimpin-Nya naik ke tempat yang tinggi, dan dengan cepat menunjukkan kepada-Nya seluruh kerajaan yang ada di dunia ini. ");
INSERT INTO indags_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lalu berkatalah Iblis kepada Yesus, “Aku akan memberikan kepada-Mu kekuasaan atas mereka semua, dan juga kemuliaan yang mereka miliki. Kekuasaan ini sudah diberikan kepadaku, dan aku bisa memberikannya kepada siapapun yang aku mau. ");
INSERT INTO indags_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Sujudlah dan sembahlah saya, dan Engkau bisa memiliki semua ini.” ");
INSERT INTO indags_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","“Sudah tertulis dalam Kitab Suci, ‘Haruslah kamu menyembah hanya kepada Tuhan Allahmu, dan hanya Dialah yang harus kamu layani,’” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lalu Iblis membawa Yesus ke Yerusalem, menempatkan dia di atas rumah Tuhan, dan berkata, “Jika Engkau anak Allah, lompatlah! ");
INSERT INTO indags_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sebab tertulis di Kitab Suci, ‘Dia akan memerintahkan para malaikat-Nya untuk menjaga Engkau, ");
INSERT INTO indags_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mengangkat Engkau untuk melindungi-Mu sehingga Engkau tidak akan tersandung batu.’” ");
INSERT INTO indags_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","“Ada tertulis, ‘Janganlah kamu mencobai Tuhan Allahmu,’” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ketika Iblis sudah selesai mencobai, mundurlah dia dan menunggu waktu yang tepat. ");
INSERT INTO indags_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lalu Yesus kembali ke Galilea, penuh dengan kuasa Roh Kudus. Berita tentang diri-Nya tersebar ke seluruh wilayah. ");
INSERT INTO indags_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesus mengajar mereka di rumah-rumah ibadah mereka, dan semua orang memuji Dia. ");
INSERT INTO indags_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ketika Dia tiba di Nazaret, tempat Dia tumbuh besar, pergilah Yesus ke rumah ibadah di situ pada suatu hari Sabat seperti biasanya. ");
INSERT INTO indags_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Gulungan kitab nabi Yesaya diserahkan kepada-Nya. Yesus membuka gulungan itu dan menemukan tempat tertulis: ");
INSERT INTO indags_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Roh Tuhan ada pada-Ku, sebab Dia sudah mengurapi Aku untuk memberitakan kabar baik kepada mereka yang berkekurangan. Dia mengirimku untuk menyatakan pembebasan kepada orang-orang yang tertawan, membuat orang-orang yang buta bisa melihat kembali, dan mereka yang tertekan bisa terlepas, ");
INSERT INTO indags_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","dan menyatakan masa kemurahan Tuhan.” ");
INSERT INTO indags_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lalu Dia digulung kembali gulungan itu dan memberikannya kepada sang petugas. Kemudian duduklah Yesus. Setiap orang yang hadir di rumah ibadah itu menatap-Nya. ");
INSERT INTO indags_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","“Kitab Suci yang baru saja kalian dengar ini telah digenapi hari ini!” kata-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Setiap orang menyatakan persetujuan atas ucapan-Nya, kagum dengan setiap perkataan yang diucapkan Yesus. “Bukankah Dia ini anak Yusuf?” tanya mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jawab Yesus, “Aku yakin kalian akan mengatakan peribahasa ini kepada-Ku, ‘Hai dokter, sembuhkanlah dirimu sendiri!’ dan berkata, ‘Lakukanlah perbuatan-perbuatan ajaib yang Engkau lakukan di sini seperti yang kami dengar Engkau lakukan di kota Kapernaum!’ ");
INSERT INTO indags_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Biar Aku katakan sejujurnya kepada kalian, tidak ada nabi yang diterima di kotanya sendiri. ");
INSERT INTO indags_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Seperti yang terjadi pada masa nabi Elia, ketika kelaparan melanda seluruh negeri Israel selama tiga setengah tahun. Ada begitu banyak janda yang tinggal di Isreal. ");
INSERT INTO indags_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Namun Elia tidak dikirim kepada satupun di antara mereka. Elia dikirim kepada seorang janda di Sarfat di wilayah Sidon! ");
INSERT INTO indags_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dan sekalipun ada begitu banyak orang yang menderita penyakit kusta di Israel pada masa hidup Elisa, namun hanya satu orang yang disembuhkan, yaitu Naaman, si orang Siria!” ");
INSERT INTO indags_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mereka yang ada di rumah ibadah itu menjadi murka mendengar ucapan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Maka berdirilah mereka dan mengusir-Nya keluar kota. Lalu mereka menyeret-Nya ke puncak bukit tempat kota itu berdiri untuk melemparkan Dia dari tebing. ");
INSERT INTO indags_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tetapi Dia berjalan melewati mereka dan melanjutkan perjalanan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lalu Yesus pergi ke kota Kapernaum di daerah Galilea. Pada hari Sabat Dia mulai mengajar mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Orang-orang di sana kagum akan pengajaran-Nya, sebab Yesus mengajar mereka dengan otoritas. ");
INSERT INTO indags_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Di rumah ibadah itu ada seorang yang dirasuki oleh roh jahat. Dan dia berteriak, ");
INSERT INTO indags_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Apa yang ingin Engkau lakukan kepada kami, Yesus dari Nazaret? Apakah Engkau ingin membinasakan kami? Aku tahu siapa Engkau: Yang Kudus dari Allah!” ");
INSERT INTO indags_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus memotong ucapannya dengan berkata, “Diam!” Lalu Dia memerintahkan setan itu, “Keluar dari orang ini!” Melemparkan orang ini ke tanah di hadapan mereka, setan itu keluar dari tubuh orang itu tanpa melukai dia. ");
INSERT INTO indags_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mereka semua menjadi terkejut dan heran serta saling bertanya, “Pengajaran apa ini? Dengan kuasa dan otoritas Dia memerintahkan roh-roh jahat untuk pergi — dan mereka taat!” ");
INSERT INTO indags_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Berita tentang Yesus tersebar ke seluruh wilayah itu. ");
INSERT INTO indags_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus pergi mengunjungi Simon sesudah pulang dari rumah ibadah itu. Ibu mertua Simon sedang sakit terkena demam tinggi dan mereka yang ada disana datang kepada Yesus dan minta tolong kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus datang dan berdiri di atasnya, memerintahkan agar sakit itu meninggalkan perempuan itu — dan sakit itu pergi. Dengan segera perempuan itu bangun dan menyiapkan makanan untuk mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dan ketika matahari sudah terbenam, mereka membawa kepada-Nya semua orang yang sakit, yang menderita dari berbagai penyakit. Yesus menumpangkan tangan-Nya ke atas mereka, satu demi satu, dan menyembuhkan mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Banyak setan yang keluar dari banyak orang dan berteriak, “Engkau anak Allah.” Tetapi Yesus menghentikan dan menolak membiarkan mereka berbicara, sebab setan-setan itu tahu bahwa Dia adalah Kristus. ");
INSERT INTO indags_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Keesokan harinya, ketika hari masih subuh, Yesus pergi untuk menemukan tempat yang tenang dan damai. Tetapi orang-orang banyak keluar dan mencari Dia, dan akhirnya menemukan-Nya. Mereka mencoba menghentikan Dia agar tidak pergi meninggalkan mereka. ");
INSERT INTO indags_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tetapi berkatalah Dia kepada mereka, “Aku harus pergi ke kota-kota lain untuk menyatakan kepada mereka kabar baik tentang Kerajaan Allah juga, sebab untuk tujuan inilah Aku diutus.” ");
INSERT INTO indags_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Maka Yesus berkeliling ke seluruh Yudea, mengajarkan tentang kabar baik di rumah-rumah ibadah di sana. ");
INSERT INTO indags_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Suatu hari Yesus sedang berdiri di tepi laut Galilea, dan orang banyak mengelilingi Dia untuk mendengarkan perkataan Allah. ");
INSERT INTO indags_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus memperhatikan dua buah perahu yang ada di tepi pantai, tertinggal disana oleh para nelayan yang sedang mencuci jala-jala mereka. ");
INSERT INTO indags_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lalu naiklah Yesus ke atas salah satu perahu, yang ternyata kepunyaan seorang bernama Simon, dan memintanya untuk mendorong perahu itu masuk ke perairan dangkal. Lalu Yesus duduk di dalam perahu dan mengajar orang-orang dari sana. ");
INSERT INTO indags_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sesudah Yesus selesai berbicara, berkatalah Dia kepada Simon, “Pergilah ke perairan yang lebih dalam, dan tebarkanlah jala-jalamu untuk menangkap ikan.” ");
INSERT INTO indags_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Guru, kami bekerja keras sepanjang malam, dan tidak ada satu ekorpun yang berhasil kami tangkap. Tetapi karena Engkau yang mengatakannya, aku akan menebarkan jala-jalaku,” jawab Simon. ");
INSERT INTO indags_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sesudah menebarkan jala-jala mereka, begitu banyak ikan yang mereka tangkap, begitu penuh jala mereka sampai-sampai hampir robek. ");
INSERT INTO indags_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mereka melambaikan tangan kepada rekan-rekan mereka yang ada di perahu yang lain, meminta agar mereka mau datang menolong. Rekan-rekan mereka datang dan bersama-sama mereka memenuhi kedua perahu itu dengan ikan. Bahkan begitu penuhnya sampai-sampai kedua perahu itu hampir tenggelam. ");
INSERT INTO indags_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ketika Simon Petrus melihat kejadian ini, berlututlah dia di hadapan Yesus. “Tuhan, menjauhlah dariku, sebab saya ini orang berdosa!” katanya. ");
INSERT INTO indags_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sebab dia dan setiap orang yang bersamanya benar-benar kagum dengan hasil tangkapan ikan yang sudah mereka bawa ke darat. ");
INSERT INTO indags_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobus dan Yohanes, anak-anak laki-laki Zebedeus, yang adalah rekan-rekan Simon, merasakan perasaan yang sama. “Jangan takut,” kata Yesus kepada Simon. “Mulai sekarang kamu akan memancing untuk menangkap orang!” ");
INSERT INTO indags_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jadi mereka menarik perahu-perahu mereka ke pantai, meninggalkan segala sesuatunya, dan mengikut Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sekali waktu, ketika Yesus sedang mengunjungi salah satu kota, Dia bertemu dengan seorang yang menderita sakit kusta parah. Orang itu bersujud hingga wajahnya menyentuh tanah dan memohon kepada Yesus, “Tolonglah Tuhan, jika Engkau mau, sembuhkanlah saya agar saya bisa diterima kembali oleh sekelilingku.” ");
INSERT INTO indags_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dan Yesus mengulurkan tangan-Nya dan menyentuh orang itu. “Aku mau,” kata Yesus. “Sembuhlah!” Dengan segera penyakit kusta itu menghilang. ");
INSERT INTO indags_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","“Jangan ceritakan kepada seorangpun mengenai hal ini,” kata Yesus kepada orang yang baru saja sembuh itu. “Tetapi pergilah dan tunjukkanlah dirimu kepada imam. Berilah persembahan yang diperintahkan oleh Musa untuk menyatakan bahwa dirimu sudah sembuh.” ");
INSERT INTO indags_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Namun berita tentang Yesus tersebar lebih luas lagi. Banyak orang datang untuk mendengarkan Dia dan disembuhkan sakit mereka oleh-Nya. ");
INSERT INTO indags_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Namun Yesus sering mengundurkan diri dari mereka dan pergi ke tempat yang sunyi dan sepi untuk berdoa. ");
INSERT INTO indags_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Suatu hari, ketika Yesus sedang mengajar, orang Farisi dan para pengajar agama yang datang dari seluruh wilayah Galilea, Yudea dan Yerusalem sedang duduk di sana. Kuasa kesembuhan dari Tuhan menyertai Yesus sehingga Yesus bisa menyembuhkan. ");
INSERT INTO indags_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Beberapa orang tiba membawa seorang yang sedang lumpuh di atas sebuah tilam. Mereka mencoba membawanya masuk dan membaringkan orang itu di depan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tetapi mereka tidak bisa menembus orang banyak itu, sehingga akhirnya mereka naik ke atas atap dan membuat sebuah lubang. Lalu mereka menurunkan orang itu dengan tilamnya, tepat ke dalam kerumunan itu di hadapan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ketika Yesus melihat kenyakinan yang mereka miliki kepada Dia, berkatalah Dia kepada orang yang lumpuh itu, “Dosamu sudah diampuni.” ");
INSERT INTO indags_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Para guru agama dan orang Farisi mulai berdebat dengan perkataan-Nya, “Siapa yang berbicara dengan menghujat itu?” tanya mereka. “Siapa yang bisa mengampuni dosa? Hanya Allah saja yang bisa melakukan hal itu!” ");
INSERT INTO indags_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus mengetahui perdebatan mereka, maka bertanyalah Dia kepada mereka, “Mengapa kalian mempertanyakan hal ini? ");
INSERT INTO indags_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yang mana yang lebih mudah? Mengatakan bahwa dosamu sudah diampuni, atau bangun dan berjalanlah? ");
INSERT INTO indags_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Namun, Aku akan membuktikan kepada kalian bahwa Anak Manusia memiliki kuasa di bumi ini untuk mengampuni dosa.” Lalu berkatalah dia kepada orang lumpuh ini, “Aku berkata kepadamu, bangun, angkat tempat tidurmu, dan pulanglah.” ");
INSERT INTO indags_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dengan segera, orang itu berdiri di hadapan mereka. Dia mengangkat matras tempat dia berbaring, dan pulang, memuji Allah sepanjang perjalanan. ");
INSERT INTO indags_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Semua orang benar-benar kagum dengan peristiwa yang baru saja terjadi, dan begitu kagumnya mereka memuji Allah dengan berkata, “Peristiwa yang kita lihat hari ini sungguh sangat menakjubkan!” ");
INSERT INTO indags_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sesudah itu, ketika Yesus meninggalkan kota itu, dia melihat seorang petugas penagih pajak yang bernama Lewi sedang duduk di dalam stannya. “Ikutlah Aku,” kata Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Maka Lewipun berdiri, meninggalkan segalanya, dan mengikut Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi mengadakan pesta perjamuan yang besar di rumahnya untuk menghormati Yesus. Banyak penagih pajak dan yang lainnya yang bersama-sama dalam kerumuman orang yang duduk dan makan bersama. Tetapi orang-orang Farisi dan guru-guru agama berkeluh kesah kepada para murid Yesus dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","“Mengapa kalian makan dam minum dengan para penagih pajak dan orang-orang berdosa?” ");
INSERT INTO indags_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","“Orang yang sehat tidak perlu pergi ke dokter — tetapi orang sakit yang pergi,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Saya tidak datang untuk memanggil mereka yang hidup benar untuk pertobatan — Aku datang untuk memanggil orang-orang yang berdosa.” ");
INSERT INTO indags_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","“Bukan begitu, murid-murid Yohanes dan para pengikut orang Farisi sering sekali berpuasa dan berdoa. Tetapi para pengikut-Mu tidak, mereka terus makan dan minum,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","“Apakah pengiring dari mempelai laki-laki berpuasa ketika mempelai itu ada bersama dengan mereka?” tanya Yesus. ");
INSERT INTO indags_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","“Tentu tidak — tetapi akan tiba ketika mempelai laki-laki itu akan dimabil dari mereka. Maka barulah mereka berpuasa.” ");
INSERT INTO indags_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lalu Yesus memberi mereka sebuah kisah sebagai contoh: “Kalian tidak merobek kain dari pakaian yang baru untuk menambal pakaian yang lama. Jika kalian melakukannya, kalian hanya merusak kedua pakaian itu. ");
INSERT INTO indags_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kalian juga tidak memasukkan air anggur yang baru jadi ke dalam kantong tempat penyimpannan air anggur yang lama, sebab air anggur yang baru itu akan merusak kantong tempat penyimpanannya yang lama. Dan baik air anggur maupun kantong itu, keduanya akan terbuang sia-sia. ");
INSERT INTO indags_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pastilah kalian menaruh air anggur yang baru ke dalam kantong anggur yang baru juga. ");
INSERT INTO indags_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dan tidak seorangpun yang mau minum air anggur yang baru jadi sesudah mereka mencicipi air anggur yang lama, sebab katanya, ‘air anggur yang lama rasanya lebih enak.’” ");
INSERT INTO indags_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pada suatu hari Sabat ketika Yesus sedang melintasi ladang gandum, murid-murid-Nya mulai memetik bulir-bulir gandum, menggosokkannya dengan tangan mereka untuk melepaskan kulit gandumnya, dan memakannya. ");
INSERT INTO indags_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Beberapa orang Farisi bertanya kepada-Nya, “Mengapa kalian melakukan perbuatan yang dilarang dilakukan pada hari Sabat?” ");
INSERT INTO indags_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus menjawab, “Belum pernahkah kalian baca dalam kitab suci perbuatan Daud ketika dia dan para pengikutnya lapar? ");
INSERT INTO indags_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bagaimana dia masuk ke rumah Tuhan dan mengambil roti yang sudah dikuduskan? Dia memakannya dan memberikannya kepada para pengikutnya. Itu perbuatan yang terlarang. Roti yang sudah dikuduskan adalah roti yang dikhususkan bagi para imam.” ");
INSERT INTO indags_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kata-Nya kepada mereka, “Anak Manusia adalah Tuhan atas hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pada hari sabat yang lain, Yesus masuk ke sebuah rumah ibadah untuk mengajar. Di sana hadir seorang laki-laki yang lumpuh tangan tangannya. ");
INSERT INTO indags_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Para pengajar guru agama dan orang-orang Farisi memperhatikan Yesus dengan seksama untuk melihat jika Yesus akan menyembuhkan pada hari Sabat. Mereka ingin menemukan sesuatu untuk bisa mendakwa Dia. ");
INSERT INTO indags_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tetapi Yesus tahu apa yang mereka pikirkan. Berkatalah Yesus kepada orang yang lumpuh tangannya itu, “Bangunlah, dan berdirilah di hadapan semua orang.” Dan orang itu bangun dan berdiri di sana. ");
INSERT INTO indags_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lalu Yesus berpaling kepada mereka dan berkata, “Mari saya tanya kepada kalian. Apakah sah berbuat baik pada hari Sabat, atau berbuat jahat? Untuk menyelamatkan hidup, atau menghancurkannya?” ");
INSERT INTO indags_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus menatap setiap orang yang hadir di sana. Lalu berkatalah Dia kepada laki-laki itu, “Ulurkanlah tanganmu.” Orang itu melakukan perintah-Nya, dan tangannya menjadi seperti baru. ");
INSERT INTO indags_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tetapi para pengajar kitab suci dan orang-orang Farisi menjadi sangat marah. Mereka mulai berdiskusi, “Apa yang harus kita lakukan terhadap Yesus?” ");
INSERT INTO indags_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Suatu hari tak lama setelah itu, Yesus naik gunung untuk berdoa. Dia tinggal di sana sepanjang malam, berdoa kepada Allah. ");
INSERT INTO indags_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ketika pagi hari tiba, Dia memanggil murid-murid-Nya berkumpul, dan memilih dua belas orang dari antara mereka. Inilah nama-nama para rasul: ");
INSERT INTO indags_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (Yesus memberi nama Petrus kepadanya), Andreas, saudara Simon, Yakobus, Yohanes, Filipus, Bartolomeus, ");
INSERT INTO indags_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus anak Alfeus, Simon sang Revolusioner, ");
INSERT INTO indags_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas anak Yakobus, dan Yudas Iskariot yang kemudian mengkhianati Yesus. ");
INSERT INTO indags_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus turun dari gunung bersama dengan mereka, dan berhenti di sebuah tempat yang datar. Ada sana kerumunan yang terdiri dari murid-murid-Nya dan juga orang-orang yang berasal dari seluruh Yudea, Yerusalem, pesisir laut Tirus dan Sidon, berkumpul untuk mendengarkan Dia dan untuk disembuhkan dari sakit penyakit mereka. ");
INSERT INTO indags_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mereka yang dirasuki roh-roh jahat juga disembuhkan. ");
INSERT INTO indags_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Semua orang yang ada dalam rombongan mencoba menyentuh Dia, sebab kuasa mengalir keluar dari diri-Nya dan menyembuhkan mereka semua. ");
INSERT INTO indags_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Menatap murid-murid-Nya, Yesus berkata, ");
INSERT INTO indags_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Betapa senangnya kalian yang miskin, sebab kerajaan Allah adalah milikmu. Betapa senangnya kalian yang lapar, sebab kalian akan dikenyangkan. Betapa senangnya kalian yang sekarang menangis, sebab kalian akan tertawa. ");
INSERT INTO indags_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Betapa bahagianya kalian jika orang-orang membenci kalian, mengucilkan, menghina dan mengutuk nama kalian sebagai kejahatan oleh karena Aku, Anak Manusia. ");
INSERT INTO indags_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ketika tiba waktunya, bersukacitalah. Berlompatlah dengan penuh sukacita, sebab besarlah upahmu di surga. Jangan lupa nenek moyang mereka menganiaya para nabi seperti ini. ");
INSERT INTO indags_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tetapi betapa sedihnya kalian yang kaya, sebab kalian telah menerima upahmu. ");
INSERT INTO indags_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Betapa sedihnya kalian yang sekarang kenyang, sebab kalian akan menjadi lapar. Betapa sedihnya kalianyang sekarang tertawa, sebab kalian akan meratap dan menangis. ");
INSERT INTO indags_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Betapa sedihnya kalian ketika semua orang memuji kalian. Janganlah lupa bahwa nenek moyang merekapun memuji nabi-nabi palsu seperti ini. ");
INSERT INTO indags_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tetapi kepada kalian yang memperhatikan, Aku perintahkan: Kasihilah musuhmu. Berbuatlah baiklah kepada mereka yang membenci kamu. ");
INSERT INTO indags_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Berkatilah mereka yang mengutuk kamu. Berdoalah bagi mereka yang suka menganiaya kamu. ");
INSERT INTO indags_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jika ada yang menampar pipi kananmu, berikanlah juga pipi kirimu. Jika seseorang meminta jubahmu, jangan halangi mereka untuk mengambil bajumu. ");
INSERT INTO indags_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Berikanlah kepada mereka yang meminta kepadamu. Jika seorang mengambil sesuatu darimu, janganlah memintanya untuk mengembalikannya. ");
INSERT INTO indags_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Perlakukanlah orang lain seperti kamu sendiri ingin diperlakukan. ");
INSERT INTO indags_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Jika kalian mengasihi mereka yang mengasihi kalian, mengapa kalian harus mendapat imbalan untuk itu? Bahkan orang-orang berdosapun mencintai orang yang mencintai mereka. ");
INSERT INTO indags_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jika kalian berbuat baik kepada mereka yang berbuat baik kepada kalian, mengapa kalian harus mendapat imbalan? Orang-orang berdosapun melakukannya juga. ");
INSERT INTO indags_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jika kalian memberi hutang dengan mengharapkan akan dikembalikan, mengapa kalian harus mendapat imbalan untuk itu? Orang-orang berdosapun juga meminjamkan uang kepada pendosa lain, berharap akan dilunasi apa yang mereka pinjamkan. ");
INSERT INTO indags_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tidak: kasihilah musuhmu, berbuat baiklah kepada mereka, dan pinjamkan tanpa mengharapkan imbalan apa pun. Maka kamu akan menerima imbalah yang besar, dan kamu akan menjadi anak-anak dari Allah yang Mahatinggi, sebab Dia baik bahkan kepada mereka yang tidak tahu berterima kasih dan yang jahat. ");
INSERT INTO indags_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Berbelaskasihanlah, sebab Bapamu juga penuh dengan belas kasihan. ");
INSERT INTO indags_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Janganlah menghakimi, dan kamupun tidak akan dihakimi, janganlah menuduh, dan kamupun tidak akan dituduh, maafkanlah, dan kamupun akan mendapatkan pengampunan, ");
INSERT INTO indags_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","berilah, dan kamupun akan mendapatkan pemberian yang melimpah. Sebab ketika pemberianmu diukur, hasilnya akan ditekan agar lebih banyak lagi yang bisa ditambahkan, bahkan begitu luar biasanya melimpah, sampai tumpah keluar. Sebab jumlah yang kamu beri akan menentukan jumlah yang kamu terima.” ");
INSERT INTO indags_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Lalu Yesus memberikan contoh dengan sebuah cerita: “Bisakah seorang buta menuntun seorang buta lainnya? Tidakkah mereka berdua akan jatuh ke dalam lubang? ");
INSERT INTO indags_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Apakah seorang murid mengetahui banyak hal lebih dari pada gurunya? Hanya ketika mereka telah mempelajari segalanya maka mereka akan menjadi seperti guru mereka. ");
INSERT INTO indags_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mengapa kalian kuatir dengan serbuk kayu yang ada di mata saudaramu, ketika kalian bahkan tidak menyadari balok kayu yang ada di matamu sendiri? ");
INSERT INTO indags_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bagaimana bisa kalian berkata kepada saudara kalian, ‘Saudaraku, ijinkan aku mengeluarkan serbuk dari matamu,’ sementara kalian bahkan tidak melihat balok kayu yang ada di matamu? Dasar orang munafik! Keluarkanlah dahulu balok kayu dimatamu itu, maka kamu akan dengan jelas bisa melihat dengan baik serbuk kayu yang ada di mata saudaramu itu. ");
INSERT INTO indags_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Pohon yang baik pasti akan menghasilkan buah yang baik juga, dan pohon yang buruk akan menghasilkan buah yang buruk. ");
INSERT INTO indags_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kalian akan mengenali sebuah pohon dari buah yang dihasilkannya. Kalian tidak bisa memetik buah ara dari semak berduri, ataupun buah anggur dari semak belukar. ");
INSERT INTO indags_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Orang-orang baik akan mengeluarkan hal-hal baik dari segala apa yang sudah diajarkan kepada mereka. Orang-orang jahat mengeluarkan hal-hal jahat dari segala apa yang sudah diajarkan kepada mereka. Perkataan orang adalah buah pikiran orang itu. ");
INSERT INTO indags_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jadi mengapa kalian memanggilku, ‘Tuhan, Tuhan,’ ketika kalian tidak melakukan perintah-Ku? ");
INSERT INTO indags_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Akan Aku beritahu seperti apa seorang yang datang kepada-Ku, mendengarkan perintah-Ku dan mengikutinya. ");
INSERT INTO indags_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dia sama seperti seseorang yang membangun rumahnya. Dia menggali dalam-dalam dan meletakkan landasan pada batu yang kokoh. Ketika sungai meluap keluar dan banjirnya menghantam rumah itu, rumah itu tetap berdiri sebab dibangun dengan sangat baik. ");
INSERT INTO indags_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tetapi seseorang yang mendengar perkataan-Ku tapi tidak melakukannya, sama seperti seseorang yang membangun rumahnya tanpa landasan. Ketika banjir menyerang rumah itu, robohlah rumah itu, sampai rata dengan tanah.” ");
INSERT INTO indags_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sesudah Yesus selesai mengajar orang banyak itu, berangkatlah Dia ke kota Kapernaum. ");
INSERT INTO indags_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ada seorang kepala pasukan yang tinggal di sana yang memiliki seorang pelayan yang sangat dia hargai yang sedang sakit dan hampir meninggal. ");
INSERT INTO indags_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ketika kepala pasukan ini mendengar tentang Yesus, dia mengirim beberapa pemimpin orang Yahudi, meminta Yesus untuk datang dan menyembuhkan pelayannya. ");
INSERT INTO indags_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Para pemimpin itu datang menemui Yesus, dan memohon dengan sangat kepada-Nya, dan berkata, “Tolong segera datang dan lakukanlah permintaannya. Dia layak mendapatkan pertolongan-Mu, ");
INSERT INTO indags_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sebab dia mengasihi bangsa kita dan membangun rumah ibadah bagi kita.” ");
INSERT INTO indags_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus pergi bersama mereka dan ketika mereka hampir mencapai rumah itu, kepala pasukan mengirimkan beberapa temannya untuk bertemu dengan Yesus dan memberitahu-Nya, “Tuhan, tidak perlu repot dengan masuk ke dalam rumahku, sebab saya tidak layak menerima Engkau. ");
INSERT INTO indags_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aku bahkan tidak berpikir bahwa saya layak untuk datang dan bertemu dengan-Mu. Cukup katakan satu perintah saja, dan pelayanku pasti akan sembuh. ");
INSERT INTO indags_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sebab saya sendiri juga di bawah atasanku, dan saya mempunyai para prajurit sebagai bawahanku. Jika saya memerintahkan satu orang untuk pergi, maka orang itu akan pergi, dan kepada yang lain untuk datang, maka dia akan datang. Aku memerintahkan pelayanku untuk melsayakan sesuatu, maka dia akan menurutinya.” ");
INSERT INTO indags_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ketika Yesus mendengar hal ini, terheran-heranlah Dia. Berkatalah Dia kepada mereka yang mengikuti Dia, “Aku katakan kepada kalian, belum pernah Aku jumpai rasa percaya seperti ini bahkan di antara orang Israel.” ");
INSERT INTO indags_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lalu pulanglah teman-teman kepala pasukan itu ke rumah dan menemukan bahwa pelayan itu sudah sembuh. ");
INSERT INTO indags_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sesudah itu Yesus pergi ke kota Nain, dengan ditemani oleh murid-murid-Nya dan diikuti oleh orang banyak. ");
INSERT INTO indags_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ketika Yesus mencapai gerbang kota, ada upacara penguburan yang sedang berlangsung dari arah yang berlawanan. Seorang pemuda, anak satu-satunya seorang janda, baru saja meninggal, dan ada banyak orang dari kota itu yang bersama dengan si janda. ");
INSERT INTO indags_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ketika Tuhan melihat ibu sang pemuda, Dia merasa kasihan kepadanya. “Janganlah menangis,” kata Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus menghampiri usungan tempat mayat itu dibawa dan menyentuhnya, dan para pengusungnya berhenti berjalan. Yesus berkata, “Hai pemuda, Aku katakan kepadamu, bangunlah.” ");
INSERT INTO indags_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bangunlah si pemuda yang sudah meninggal itu dan mulai berbicara, dan Yesus membawanya kembali kepada ibunya. ");
INSERT INTO indags_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Semua orang merasa kagum melihat kejadian itu dan memuji Allah serta berkata, “Seorang nabi besar sudah diutus ke tengah-tengah kita!” dan “Allah sudah datang di antara kita.” ");
INSERT INTO indags_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Berita tentang Yesus tersebar ke seluruh Yudea dan sekitarnya. ");
INSERT INTO indags_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Murid-murid Yohanes memberitahukan kepada Yohanes peristiwa-peristiwa yang terjadi. ");
INSERT INTO indags_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dan Yohanes memanggil kedua muridnya, meminta mereka untuk pergi dan bertemu Yesus serta bertanya, “Apakah Engkau yang dinanti-nantikan itu, atau haruskah kami menunggu orang lain?” ");
INSERT INTO indags_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ketika mereka bertemu dengan Yesus, berkatalah mereka, “Yohanes Pembaptis mengirim kami kepada-Mu untuk bertanya, ‘Apakah Engkau orang yang dinanti-nantikan atau haruskah kami menantikan orang lain lagi?’” ");
INSERT INTO indags_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tepat waktu itu Yesus sedang menyembuhkan banyak orang dari segala sakit penyakit, roh-roh jahat dan membuat mata mereka yang buta bisa melihat kembali. ");
INSERT INTO indags_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesus menjawab murid-murid Yohanes, “Kembalilah dan beritahu Yohanes semua yang sudah kalian lihat dan dengar. Orang-orang buta bisa melihat kembali, orang-orang lumpuh bisa berjalan, orang-orang yang sakit kusta disembuhkan, orang-orang yang tuli mendengar, orang-orang yang mati jadi hidup kembali, dan mereka yang kekurangan menerima kabar baik. ");
INSERT INTO indags_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Diberkatilah mereka yang tidak menjadi ragu karena Aku!” ");
INSERT INTO indags_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sesudah murid-murid Yesus meninggalkan mereka, Yesus mulai berkata kepada orang banyak tentang Yohanes, “Apa yang kalian harapkan untuk kalian temui ketika pergi ke padang gurun? Buluh yang ditiup oleh angin? ");
INSERT INTO indags_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Jadi apa yang akan kalian lihat? Seseorang yang mengenakan pakaian yang indah dan mewah? Orang-orang yang berpakaian indah dan mewah tinggalnya di istana raja-raja. ");
INSERT INTO indags_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Apakah kalian mencari seorang nabi dari Tuhan? Ya, dan Aku katakan kepada kalian, orang ini lebih dari sekedar nabi. ");
INSERT INTO indags_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tertulis tentang dia di dalam Kitab Suci: ‘Dengar, Aku mengutus seorang pembawa pesan untuk menyiapkan jalan bagimu.’ ");
INSERT INTO indags_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aku beritahu kalian, tidak seorangpun yang dilahirkan dari seorang wanita yang lebih besar daripada Yohanes, tetapi bahkan orang yang dianggap paling tidak penting dalam Kerajaan Allah menjadi orang yang lebih penting daripada Yohanes!” ");
INSERT INTO indags_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ketika mereka mendengar hal ini, setiap orang — bahkan para pemungut pajak — mengakui bahwa yang Allah katakan adalah sesuatu yang benar, sebab mereka semua sudah dibaptis oleh Yohanes. ");
INSERT INTO indags_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tetapi orang-orang Farisi dan para guru agama menolak apa yang Allah ingin mereka lakukan, karena mereka telah menolak untuk dibaptis oleh Yohanes. ");
INSERT INTO indags_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Dengan apakah Aku harus membandingkan orang-orang ini?” tanya Yesus. “Seperti apakah mereka?” ");
INSERT INTO indags_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","“Mereka seperti anak-anak yang duduk di pasar yang saling berkata, ‘Kami bermain suling bagimu, tetapi kamu tidak menari, kami bernyanyi lagu sedih, tetapi kamu tidak menangis.’ ");
INSERT INTO indags_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ketika Yohanes Pembaptis datang, dia tidak makan roti ataupun minum anggur, namun kalian katakan dia dirasuki setan. ");
INSERT INTO indags_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sekarang Anak Manusia ada di sini, dan makan dan minum dengan orang-orang, tetapi kalian berkata, ‘Lihat, dia menghabiskan waktunya dengan makan terlalu banyak makanan dan minum terlalu banyak anggur. Ditambah lagi dia adalah teman pemungut cukai dan orang berdosa.’ ");
INSERT INTO indags_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Namun, cara Allah yang bijaksana terbukti benar oleh semua yang mengikuti Dia!” ");
INSERT INTO indags_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Salah seorang dari kaum Farisi mengundang Yesus untuk datang dan makan bersama dia. Maka pergilah Yesus menghadiri undangan itu. ");
INSERT INTO indags_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Seorang perempuan di kota itu yang telah menjalani kehidupan yang tidak bermoral mendapat kabar bahwa Yesus sedang makan di rumah orang dari kaum Farisi tersebut. Dia pergi ke sana, membawa toples alabaster berisi minyak wangi-wangian. ");
INSERT INTO indags_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Berlututlah perempuan itu di sisi Yesus dan dengan air matanya, dia membasahi kaki Yesus, serta mengeringkannya dengan rambutnya. Perempuan itu mencium kaki Yesus, dan menuang minyak wangi-wangian itu di atas mereka. ");
INSERT INTO indags_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ketika sang tuan rumah melihat kejadian itu, berkatalah dia kepada dirinya sendiri, “Jika pria ini benar-benar seorang nabi, dia akan tahu siapa perempuan ini yang menyentuhnya, dan perempuan macam apa dia, seorang perempuan tidak bermoral!” ");
INSERT INTO indags_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Berkatalah Yesus kepada sang tuan rumah, “Simon, Aku hendak mengatakan sesuatu kepadamu.” “Katakanlah, Guru,” jawab Simon. ");
INSERT INTO indags_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Suatu ketika ada dua orang yang berhutang kepada seorang tukang kredit. Yang satu meminjam sebanyak lima ratus keping uang perak, yang satu lagi sebanyak lima puluh keping uang perak. ");
INSERT INTO indags_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tidak seorangpun yang sanggup membayar kembali hutang mereka, sehingga akhirnya sang tukang kredit memutuskan untuk menghapus hutang mereka dan mengampuni mereka. Menurutmu, siapa di antara kedua orang ini yang akan lebih mengasihi dia?” ");
INSERT INTO indags_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Orang yang memiliki hutang yang paling banyak, menurutku,” jawab Simon. “Kamu benar sekali, Simon,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Berpaling melihat perempuan itu, Yesus berkata kepada Simon, “Kamu lihat perempuan ini? Ketika Aku masuk ke rumahmu, kamu tidak memberi-Ku air untuk mencuci kaki-Ku. Tetapi perempuan ini mencuci kaki-Ku dengan air matanya, dan menyeka mereka dengan rambutnya. ");
INSERT INTO indags_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kamu tidak memberiku salam, tetapi sejak Aku masuk, perempuan ini tidak henti-hentinya menyiumi kaki-Ku. ");
INSERT INTO indags_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kamu tidak mengurapi kepala-Ku dengan minyak, tetapi perempuan ini menuangkan minyak wangi-wangian ke atas kakiku. ");
INSERT INTO indags_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jadi, Aku katakan kepadamu, dosanya yang begitu banyak sudah diampuni — itu sebabnya dia begitu mengasihi. Tetapi siapa pun yang diampuni sedikit, hanya mencintai sedikit.” ");
INSERT INTO indags_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lalu berkatalah Yesus kepada perempuan itu, “Dosa-dosamu sudah diampuni.” ");
INSERT INTO indags_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mereka yang sedang duduk makan bersama Yesus mulai saling berkata, “Siapakah orang ini sehingga bisa mengampuni dosa?” ");
INSERT INTO indags_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tetapi kata Yesus kepada perempuan itu, “Kepercayaanmu telah menyelamatkanmu, pergilah dengan damai.” ");
INSERT INTO indags_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yesus berkeliling ke seluruh wilayah, mengunjungi kota-kota kecil dan desa-desa. Dia mengajar dalam rumah ibadah-rumah ibadah mereka, memberitahu mereka tentang kabar baik Kerajaan Allah, serta menyembuhkan mereka dari segala macam sakit penyakit. ");
INSERT INTO indags_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Beserta dengan Yesus adalah beberapa perempuan yang sudah Yesus sembuhkan dari roh-roh jahat dan sakit penyakit: Maria Magdalena yang pernah dirasuki oleh tujuh roh jahat; ");
INSERT INTO indags_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana, istri Kuza — pengurus rumah tangga Herodes, Susana, dan banyak lagi yang memberikan dukungan dengan dana mereka sendiri. ");
INSERT INTO indags_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sesudah banyak orang berkumpul, yang datang dari berbagai kota untuk bertemu dengan Yesus, berbicaralah Yesus kepada mereka, menggunakan cerita sebagai ilustrasi. ");
INSERT INTO indags_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ada seorang petani yang keluar untuk menabur benih. Ketika dia menabur benih itu, beberapa jatuh ke jalan, yang kemudian diinjak-injak orang dan burung-burung memakannya. ");
INSERT INTO indags_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Beberapa jatuh di tanah yang berbatu, dan ketika benih itu tumbuh, mereka segera menjadi layu, sebab kurangnya kelembaban. ");
INSERT INTO indags_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Benih-benih lainnya ada yang jatuh di antara semak berduri, dan ketika mereka tumbuh, semak-semak itu menghambatnya sampai mati. ");
INSERT INTO indags_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Beberapa benih jatuh ke tanah yang subur dan sesudah mereka bertumbuh, mereka menghasilkan 100 kali lipat dari ketika mereka ditabur.” Sesudah Yesus mengatakan ini kepada mereka, berserulah Dia, “Jika kalian memiliki telinga, perhatikanlah!” ");
INSERT INTO indags_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tetapi para murid-Nya bertanya kepada-Nya, “Apa arti dari kisah tadi?” ");
INSERT INTO indags_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jawab Yesus, “Kalian diberi pemahaman tentang rahasia kerajaan Allah, tetapi kepada yang lain hanya diberikan kisah, jadi ‘Sekalipun mereka melihat, tetapi mereka tidak benar-benar melihat, dan sekalipun mereka mendengar, mereka tidak benar-benar mengerti.’ ");
INSERT INTO indags_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Inilah arti dari kisah itu: Benih itu adalah Firman Allah. ");
INSERT INTO indags_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Benih yang jatuh di jalan adalah mereka yang mendengarkan pesan itu, tetapi kemudian si Iblis datang dan merampas kebenaran dari pikiran mereka, sehingga mereka tidak percaya kepada Allah dan diselamatkan. ");
INSERT INTO indags_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Benih yang jatuh ke tanah yang berbatu adalah mereka yang mendengarkan pesan itu serta menyambutnya dengan gembira, tetapi tidak memiliki akar. Rasa percaya mereka hanya sekejap saja, dan ketika mereka ditimpa kesulitan, mereka menyerah. ");
INSERT INTO indags_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Benih yang jatuh di antara semak berduri adalah mereka yang mendengarkan pesan itu, tetapi rasa percaya mereka terhimpit oleh kesulitan dalam hidup ini — kekuatiran, kekayaan, kesenangan diri — sehingga tidak ada buah-buah pertobatan yang mereka hasilkan. ");
INSERT INTO indags_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Benih-benih yang jatuh ke tanah yang subur adalah mereka yang jujur dan melakukan perbuatan-perbuatan yang benar. Mereka mendengar pesan tentang kebenaran, berpegang teguh kepadanya, dan melalui keteguhan mereka menghasilkan tuaian yang bagus. ");
INSERT INTO indags_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kalian tidak menyalakan lilin lalu menutupnya dengan ember, ataupun menyembunyikannya di bawah tempat tidur. Tidak, kalian akan meletakkan lilin itu di atas tempat lilin, agar setiap orang yang datang bisa melihat cahayanya. ");
INSERT INTO indags_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sebab tidak ada sesuatupun yang tersembunyi yang tidak akan disingkapkan, dan tidak ada rahasia yang tidak akan dibongkar dan dibuat jelas. ");
INSERT INTO indags_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jadi perhatikanlah bagaimana kalian ‘mendengar.’ Kepada mereka yang telah menerima, akan diberikan lebih banyak; dari mereka yang tidak menerima, bahkan apa yang mereka pikir mereka miliki akan diambil!” ");
INSERT INTO indags_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lalu datanglah ibu dan saudara-saudara Yesus, tetetapi mereka tidak dapat menembus orang banyak itu untuk bertemu dengan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kepada Yesus diberitahukan, “Ibu-Mu dan saudara-saudara-Mu sedang di luar. Mereka ingin bertemu dengan-Mu.” ");
INSERT INTO indags_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","“Ibu-Ku dan saudara-saudara-Ku adalah mereka yang mendengar firman Allah, dan melakukan apa yang dikatakannya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Suatu hari Yesus berkata kepada murid-murid-Nya, “Mari kita menyeberang ke sisi lain danau.” Maka naiklah mereka semua ke dalam perahu dan berangkat berlayar. ");
INSERT INTO indags_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ketika mereka sedang berlayar, tertidurlah Yesus, dan angin ribut melanda danau itu. Perahu yang mereka tumpangi mulai terisi air dan mereka terancam tenggelam. ");
INSERT INTO indags_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Maka datanglah murid-murid-Nya kepada-Nya dan membangunkan-Nya. “Guru, Guru, kita akan tenggelam!” kata mereka. Yesus bangun dan memerintahkan angin dan gelombang untuk berhenti. Mereka berhenti, dan keadaan menjadi tenang. ");
INSERT INTO indags_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Dimana rasa percaya kalian?” tanya-Nya kepada mereka. Dengan takjub dan penuh ketakutan, murid-murid-Nya saling berkata, “Siapa orang ini sebenarnya? Dia memberi perintah, dan angin serta air taat kepada-Nya!” ");
INSERT INTO indags_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mereka berlayar menyeberang menuju wilayah Gerasa yang terletak di seberang Galilea. ");
INSERT INTO indags_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ketika Yesus melangkah keluar dari perahu ke pantai, seorang yang dirasuki setan datang dari arah kota menemui Dia. Sudah sejak lama laki-laki itu tidak mengenakan pakaian atau tinggal di rumah. Dia tinggal di kuburan. ");
INSERT INTO indags_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ketika laki-laki itu melihat Yesus, berteriaklah dia, jatuh di depan kaki Yesus, dan bertanya dengan suara keras, “Apa yang Engkau inginkan dengan saya, Yesus, hai Anak Allah yang Mahatinggi? Kumohon, jangan siksa saya!” ");
INSERT INTO indags_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sebab Yesus sudah memerintahkan roh jahat itu untuk keluar dari tubuh laki-laki itu. Roh itu seringkali menangkap dia, dan sekalipun diikat dengan rantai dan belenggu, dan dijaga oleh penjaga, dia akan memutuskan rantai itu dan akan dikendalikan oleh setan menuju ke daerah padang gurun. ");
INSERT INTO indags_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Siapa namamu?” tanya Yesus. “Legion,” jawabnya, sebab banyak setan sudah masuk ke dalam tubuhnya. ");
INSERT INTO indags_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Para setan itu memohon kepada Yesus untuk tidak memerintahkan mereka pergi ke jurang maut. ");
INSERT INTO indags_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Di dekat sana ada sekelompok ternak babi yang sedang diberi makan, dan setan-setan itu memohon kepada-Nya untuk mengijinkan mereka masuk ke dalam babi-babi itu. Yesus memberikan ijin kepada mereka, ");
INSERT INTO indags_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","maka setan-setan itu meninggalkan si laki-laki itu dan masuk ke dalam babi-babi itu. Kumpulan ternak itu bergegas lari ke arah tebing dan melompat ke dalam danau serta tenggelam. ");
INSERT INTO indags_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ketika para penjaga babi-babi itu melihat apa yang sudah terjadi, mereka kabur dan menyebarkan berita itu ke seluruh kota dan daerah-daerah sekelilingnya. ");
INSERT INTO indags_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Orang-orang keluar dari kota untuk melihat apa yang sesungguhnya sudah terjadi. Ketika mereka menemui Yesus, mereka temukan juga laki-laki itu sudah bebas dari setan-setan. Dia sedang duduk di dekat kaki Yesus, memakai baju dan pikirannya waras. Hal ini membuat orang-orang itu merasa takut. ");
INSERT INTO indags_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mereka yang telah melihat apa yang terjadi menjelaskan bagaimana orang yang kerasukan setan itu telah disembuhkan. ");
INSERT INTO indags_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Maka semua orang dari wilayah Gerasi memihon agar Yesus meninggalkan daerah itu sebab mereka sangat ketakutan. Maka masuklah Yesus dan murid-murid-Nya ke dalam perahu dan berlayar pulang. ");
INSERT INTO indags_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Laki-laki yang sudah dibebaskan dari iblis itu memohon agar boleh mengikuti Yesus, tetapi Yesus mengirimnya pergi. ");
INSERT INTO indags_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kembalilah ke rumahmu, dan ceritakanlah kepada orang-orang segala yang sudah Allah lakukan untukmu,” kata Yesus kepadanya. Maka pulanglah dia, memberitahukan ke seluruh kota apa yang sudah Yesus lakukan kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sekelompok besar orang berkumpul untuk menyambut Yesus ketika Dia kembali, semua orang sangat menanti-nantikan Dia. ");
INSERT INTO indags_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yairus, seorang pemimpin rumah ibadah di sana, datang dan bersujud di depan kaki Yesus. Dia memohon agar Yesus ikut ke rumahnya ");
INSERT INTO indags_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sebab anak perempuan satu-satunya sedang sekarat. Umurnya sekitar dua belas tahun. Sementara Yesus sedang di jalan menuju ke rumahnya, orang-orang sedang berkelompok mengelilingi Dia. ");
INSERT INTO indags_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dan di antara orang-orang itu ada seorang perempuan yang menderita sakit pendarahan sudah selama dua belas tahun. Uangnya sudah habis untuk berobat ke dokter, tetapi tidak satupun dari mereka yang bisa menyembuhkan dia. ");
INSERT INTO indags_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Maka dengan diam-diam perempuan ini mendekati Yesus dari belakang dan menyentuh bagian bawah jubah-Nya. Dengan segera pendarahannya berhenti. ");
INSERT INTO indags_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Siapa yang menyentuh-Ku?” Yesus bertanya. Setiap orang di sekeliling-Nya tidak ada yang mengakuinya. “Tetapi, Guru,” jawab Petrus, “ada banyak orang yang mengelilingi Engkau, dan mereka terus menerus mendorong Engkau.” ");
INSERT INTO indags_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Seseorang baru saja menyentuh-Ku,” jawab Yesus. “Aku tahu karena ada kuasa yang keluar dari-Ku.” ");
INSERT INTO indags_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ketika perempuan itu menyadari bahwa dia tidak bisa luput dari perhatian, majulah dia, dengan gemetar, dan sujud di dekat kaki Yesus. Di hadapan semua orang dia menjelaskan alasan dia harus menjamah Yesus, dan bahwa dia sudah disembuhkan. ");
INSERT INTO indags_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kata Yesus kepadanya, “Anak-Ku, rasa percayamu kepadaku sudah menyembuhkan kamu, pulanglah dengan damai.” ");
INSERT INTO indags_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ketika Yesus masih berbicara, datanglah seseorang dari rumah Yairus untuk memberitahu kepadanya, “Anak perempuanmu sudah mati. Kamu sudah tidak perlu merepotkan Guru lagi.” ");
INSERT INTO indags_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tetapi ketika Yesus mendengar perkataan itu, berkatalah Dia kepada Yairus, “Jangan takut. Jika kamu percaya, anakmu akan sembuh.” ");
INSERT INTO indags_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ketika Yesus tiba di rumah Yairus, Dia tidak mengijinkan siapapun untuk ikut masuk kecuali Petrus, Yohanes, Yakobus dan kedua orang tua anak itu. ");
INSERT INTO indags_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Semua orang disitu sedang menangis dan berkabung untuknya. “Jangan menangis,” kata Yesus kepada mereka. “Anak itu tidak mati, dia hanya tidur saja.” ");
INSERT INTO indags_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tetapi orang banyak itu menertawakan Dia, sebab mereka tahu dengan pasti bahwa anak perempuan itu sudah mati. ");
INSERT INTO indags_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tetapi Yesus memegang tangan anak perempuan itu, dan berkata dengan suara keras, “Anak-Ku, bangun!” ");
INSERT INTO indags_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gadis itu hidup kembali, dan dengan segera dia bangun. Yesus menyuruh mereka untuk memberinya sesuatu untuk dimakan. ");
INSERT INTO indags_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Orang tuanya tertegun dengan kejadian ini, tetapi Yesus melarang mereka untuk tidak menceritakan kepada siapapun mengenai hal ini. ");
INSERT INTO indags_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus kemudian memanggil kedua belas murid-Nya berkumpul. Dia memberikan kepada mereka kuasa dan otoritas atas semua setan, dan kemampuan untuk menyembuhkan penyakit. ");
INSERT INTO indags_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lalu Dia mengutus mereka untuk memberitakan tentang Kerajaan Allah dan menyembuhkan orang sakit. ");
INSERT INTO indags_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Jangan membawa apapun juga dalam perjalanan kalian,” kata-Nya kepada mereka. “Baik tongkat, tas, roti, uang, ataupun juga baju ganti. ");
INSERT INTO indags_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pada rumah manapun yang kalian masuki, tinggallah di sana, dan ketika kalian melanjutkan perjalanan, berangkatlah dari tempat itu juga. ");
INSERT INTO indags_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jika orang-orang menolak untuk menerima kalian, kibaskanlah debu dari kaki kalian sebagai tanda peringatan terhadap mereka.” ");
INSERT INTO indags_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dan mereka pergi berkeliling ke desa-desa, memberitakan tentang kabar baik itu dan menyembuhkan banyak orang, kemanapun mereka pergi. ");
INSERT INTO indags_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Raja Herodes sudah mendengar segala sesuatu yang terjadi, dan dia sangat kebingungan. Beberapa orang berkata bahwa Yohanes Pembaptis sudah bangkit dari kematian; ");
INSERT INTO indags_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ada yang mengatakan Elia telah muncul; ada juga yang berkata, Yesus adalah salah satu nabi jaman dulu yang hidup kembali. ");
INSERT INTO indags_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes berkata, “Aku sudah memenggal kepala Yohanes Pembaptis. Jadi siapa orang ini? Aku mendengarkan segala perbuatan yang dilakukan orang ini.” Herodes mulai mencari cara untuk bertemu dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ketika para rasul itu kembali dari perjalanan mereka, mereka memberitahu Yesus segala sesuatu yang sudah mereka lakukan. Lalu Yesus pergi bersama mereka menuju kota Betsaida. ");
INSERT INTO indags_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Namun, orang menemukan itu tahu kemana tujuan Yesus dan mengikuti Dia. Yesus menyambut mereka dan menjelaskan kepada mereka tentang Kerajaan Allah, serta menyembuhkan banyak orang yang sakit. ");
INSERT INTO indags_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ketika hari hampir gelap, datanglah murid-murid-Nya kepadanya dan berkata, “Guru, Engkau harus mengirim orang banyak ini pergi agar mereka bisa datang ke desa-desa dan pertanian-pertanian di sekitar sini. Dengan demikian mereka bisa menemukan tempat untuk bermalam serta makanan untuk mereka makan — kita tidak punya apa-apa dengan kita.” ");
INSERT INTO indags_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","“Kalian lah yang harus memberi mereka makan!” kata Yesus. “Kita hanya punya lima bongkah roti dan dua ekor ikan — kecuali Engkau ingin kami pergi dan membeli makanan untuk semua orang,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Di situ ada sekitar lima ribu orang laki-laki yang hadir. “Kumpulkan mereka per lima puluh orang dalam satu kelompok, dan mintalah agar mereka duduk,” kata Yesus kepada murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Para murid-Nya melakukan yang diperintahkan kepada mereka, dan setiap orang duduk berkelompok. ");
INSERT INTO indags_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus mengambil kelima roti dan dua ekor ikan itu, menengadah ke surga, memberkati makanannya dan memecah-mecahkannya menjadi potongan-potongan. Yesus terus menerus memberikan makanan kepada murid-murid-Nya untuk dibagikan kepada orang-orang. ");
INSERT INTO indags_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Semua orang makan sampai mereka kenyang, dan masih ada sisa dua belas bakul makanan yang tersisa ketika dikumpulkan. ");
INSERT INTO indags_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pada suatu ketika, saat Yesus sedang berdoa bersama dengan ke dua belas rasulnya, bertanyalah Dia kepada mereka, “Menurut orang-orang banyak ini — siapakah Aku ini?” ");
INSERT INTO indags_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Beberapa berkata Engkau adalah Yohanes Pembaptis, ada yang berkata bahwa Engkau adalah Elia, dan beberapa lagi berkata Engkau adalah salah satu nabi dari jaman dahulu yang bangkit dari kematian,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Tetapi bagaimana dengan kalian?” tanya Yesus. “Menurut kalian, siapa Aku ini?” “Engkau adalah Mesias Allah,” jawab Petrus. ");
INSERT INTO indags_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dan Yesus melarang murid-murid-Nya untuk menceritakan hal ini kepada siapapun. ");
INSERT INTO indags_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Anak manusia harus mengalami penderitaan yang luar biasa,” kata-Nya. “Dia akan ditolak oleh para pemimpin, imam kepala, dan para pengajar agama. Dia akan dibunuh, tetapi pada hari yang ketiga dia akan bangkit kembali.” ");
INSERT INTO indags_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","“Jika ada di antara kamu yang ingin mengikuti Aku, kamu harus menyangkal dirimu sendiri, memikul salibmu setiap hari, dan mengikuti Aku,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Sebab jika kamu ingin menyelamatkan hidup kamu, kamu akan kehilangannya; dan jika kamu kehilangan hidup kamu demi saya, kamu akan menyelamatkannya. ");
INSERT INTO indags_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Keuntungan apa yang kalian dapat sekalipun kalian memiliki seluruh dunia ini, tetapi pada akhirnya kalian kalah dan dihancurkan? ");
INSERT INTO indags_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jika kamu malu tentang Aku dan pengajaran-Ku, maka Aku juga akan malu mengakui kamu ketika Aku datang dalam kemuliaan-Ku, dan dalam kemuliaan Bapa-Ku dengan para malaikat-Nya. ");
INSERT INTO indags_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sejujurnya Aku katakan kepada kalian. Beberapa dari antara kalian yang berdiri di sini akan masih hidup sampai mereka melihat kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sekitar delapan hari kemudian, sesudah Yesus mengatakan semua ini, Dia membawa Petrus, Yohanes dan Yakobus bersama-Nya untuk berdoa di gunung. ");
INSERT INTO indags_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sementara Yesus berdoa, tampilan wajah-Nya berubah, dan pakaian-Nya menjadi putih berkilauan. ");
INSERT INTO indags_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dan dua orang hadir dengan kemuliaan yang terang benderang. Mereka adalah Musa dan Elia, dan mereka mulai berbicara dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mereka sedang berbicara tentang kematian Yesus, yang akan segera terjadi di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus dan kedua lainnya sedang tertidur. Ketika mereka terbangun, mereka melihat Yesus dalam kemuliaannya, dan juga kedua orang yang berdiri di sisi-Nya. ");
INSERT INTO indags_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ketika kedua orang itu hendak berangkat, berkatalah Petrus kepada Yesus, “Guru, sungguh luar biasa bisa ada di sini. Mari buat beberapa tempat penampungan, satu untuk-Mu, satu untuk Musa dan satu untuk Elia.” (Dia benar-benar tidak tahu apa yang dia katakan.) ");
INSERT INTO indags_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sementara dia sedang berkata-kata, ada awan datang dan menyelimuti mereka. Mereka menjadi ketakutan ketika berada di dalam awan itu. ");
INSERT INTO indags_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ada suara yang terdengar berbicara dari dalam awan, berkata, “Inilah Anak-Ku, yang Kupilih. Dengarkanlah Dia!” ");
INSERT INTO indags_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ketika suara itu selesai berbicara, Yesus ada di sana sendirian. Mereka menyimpan peristiwa ini di antara mereka sendiri dan tidak menceritakannya kepada siapapun apa yang sudah mereka lihat pada waktu itu. ");
INSERT INTO indags_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Keesokan harinya ketika mereka sudah turun dari gunung, sekelompok besar orang sedang menunggu untuk bertemu dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Seorang laki-laki di antara mereka berteriak, “Guru, tolong tengok anak laki-lakiku satu-satunya. ");
INSERT INTO indags_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Roh jahat menguasai dia dan dengan segera dia berteriak. Roh itu membuatnya kejang dan mengeluarkan busa dari mulutnya. Itu hampir tidak pernah meninggalkannya sendirian dan itu menyebabkan dia sangat kesakitan. ");
INSERT INTO indags_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aku sudah memohon kepada murid-murid-Mu untuk mengusir setan itu, tetapi mereka tidak bisa melakukannya.” ");
INSERT INTO indags_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","“Sungguh kalian orang yang tidak punya rasa percaya dan jahat! Berapa lama lagi Aku harus bersama dengan kalian, dan bersabar dengan kalian?!” kata Yesus. “Bawa anakmu ke sini.” ");
INSERT INTO indags_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bahkan ketika anak itu dibawa, iblis membuat anak itu kejang, dan melemparkan dia ke atas tanah. Tetapi Yesus campur tangan, menghardik setan itu dan menyembuhkan si anak laki-laki, lalu mengembalikannya kepada ayahnya. ");
INSERT INTO indags_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Setiap orang terheran-heran dengan pembuktian kuasa Allah ini. Namun demikian, sekalipun semua orang kagum dengan segala perbuatan-Nya, Yesus memperingati murid-murid-Nya, ");
INSERT INTO indags_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dengarkan baik-baik perkataan-Ku: Anak Manusia akan dikhianati dan diserahkan ke tangan manusia.” ");
INSERT INTO indags_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tetapi ketika itu murid-murid-Nya tidak memahami perkataan-Nya dan mereka terlalu takut untuk bertanya kepada-Nya apa arti perkataan-Nya itu. ");
INSERT INTO indags_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lalu timbulah perdebatan di antara murid-murid-Nya tentang siapa di antara mereka yang terhebat. ");
INSERT INTO indags_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tetapi Yesus, mengetahui perdebatan mereka, mengangkat dan memangku seorang anak kecil. ");
INSERT INTO indags_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lalu berkatalah Dia kepada mereka, “Siapaun yang menerima anak kecil ini demi nama-Ku, maka dia menerima Aku, dan siapapun yang menerima Aku menerima Dia yang mengutus Aku. Siapapun yang menjadi yang terkecil di antara kalian, dialah yang akan menjadi yang terbesar.” ");
INSERT INTO indags_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanes berkata, “Guru, kami melihat seseorang mengusir setan demi nama-Mu dan kami mencoba menghentikan dia, sebab dia tidak termasuk dalam kelompok kita.” ");
INSERT INTO indags_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Jangan hentikan dia,” jawab Yesus. “Siapapun yang tidak menentang kalian adalah untuk kalian.” ");
INSERT INTO indags_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ketika waktunya semakin dekat baginya untuk naik ke surga, Yesus bertekad untuk pergi ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lalu Yesus mengirim pesan ke sebuah desa di Samaria untuk mempersiapkan segala sesuatu bagi-Nya. ");
INSERT INTO indags_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tetapi orang-orang di desa itu tidak menyambut Dia sebab ternyata Dia hanya ingin melewati desa mereka dalam perjalanan-Nya menuju Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ketika Yakobus dan Yohanes melihat hal ini, bertanyalah mereka kepada Yesus, “Guru, apakah Engkau ingin kami memanggil api dari surga untuk membakar mereka?” ");
INSERT INTO indags_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tetapi Yesus berbalik dan menghardik mereka. ");
INSERT INTO indags_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lalu mereka melanjutkan perjalanan ke desa selanjutnya. ");
INSERT INTO indags_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sementara mereka dalam perjalanan, seorang laki-laki berkata kepada Yesus, “Guru, saya akan mengikuti-Mu kemanapun Engkau pergi!” ");
INSERT INTO indags_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Berkatalah Yesus kepada laki-laki itu, “Rubah-rubah memiliki lubang, demikian juga burung-burung mempunyai sarang, tetapi Anak Manusia tidak memiliki tempat untuk berbaring dan beristirahat,” kata Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Berkatalah Yesus kepada yang lainnya, “Ikutlah Aku.” Tetapi laki-laki itu menjawab, “Guru, ijinkan saya pulang dan menguburkan ayahku.” ");
INSERT INTO indags_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","“Biarlah mereka yang mati menguburkan orang-orang mati mereka,” jawab Yesus. “Tetapi kamu, pergilah dan beritakanlah tentang Kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lalu seorang lagi berkata, “Tuhan, saya akan mengikuti Engkau! Tetapi biarkanlah saya pulang dahulu untuk berpamitan dahulu kepada keluarga saya.” ");
INSERT INTO indags_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tetapi berkatalah Yesus kepadanya, “Mereka yang mulai membajak tetapi lalu melihat ke belakang tidak layak untuk kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sesudah itu Yesus memilih 70 orang murid lainnya, dan mengutus mereka sepasang-sepasang ke setiap kota-kota kecil dan tempat-tempat yang Dia akan mengunjungi. ");
INSERT INTO indags_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Hasil panen melimpah, tetapi orang yang bisa memanennya sedikit,” kata Yesus kepada mereka. “Berdoalah kepada Tuhan pemilik hasil panen ini agar Dia segera mengirim pekerja-pekerjanya untuk memanen di ladang-ladang. ");
INSERT INTO indags_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sekarang, pergilah! Ketahuilah bahwa Aku mengirim kalian seperti seekor domba ke tengah-tengah gerombolan serigala. ");
INSERT INTO indags_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jangan membawa uang ataupun tas ataupun sandal pengganti, dan jangan menghabiskan waktu kalian dengan mengobrol bersama orang-orang yang kalian temui. ");
INSERT INTO indags_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ke rumah manapun yang kalian masuki, pertama-tama katakanlah, ‘Semoga damai memenuhi rumah ini.’ ");
INSERT INTO indags_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dan jika di sana ada orang yang menyukai damai hidup di sana, maka salam penuh damaimu akan mereka terima, jika tidak, salam itu akan kembali kepadamu. ");
INSERT INTO indags_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tinggallah di rumah itu, makan dan minum apa pun yang mereka berikan kepadamu, karena seorang pekerja layak dibayar. Janganlah pergi dari rumah ke rumah. ");
INSERT INTO indags_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jika kalian memasuki suatu kota dan orang-orang di sana menyambut kalian, maka makanlah makanan yang disajikan di hadapan kalian ");
INSERT INTO indags_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","dan sembuhkan mereka yang sakit. Katakanlah kepada mereka, ‘Kerajaan Allah sudah datang kepadamu.’ ");
INSERT INTO indags_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tetapi jika kalian memasuki sebuah kota dan orang-orang di sana tidak menyambut kalian, lewatilah jalan-jalan mereka sambil berkata, ");
INSERT INTO indags_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kami bahkan menghapus debu dari kota kalian yang menempel pada kaki kami untuk menunjukkan ketidaksetujuan kami. Tetapi kalian harus menyadari ini: Kerajaan Allah sudah datang.’ ");
INSERT INTO indags_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aku berkata kepadamu, pada Hari Pembalasan akan lebih baik bagi Sodom daripada kota seperti itu. ");
INSERT INTO indags_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Malu pada kalian pendudu Korazim! Malu pada kalian penduduk Betsaida! Karena jika mujizat yang kalian lihat terjadi di kota Tirus dan Sidon, penduduk mereka sudah lama bertobat, dan akan duduk di kain karung dan abu. ");
INSERT INTO indags_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Itulah sebabnya dalam penghakiman itu akan lebih baik bagi Tirus dan Sidon daripada bagimu. ");
INSERT INTO indags_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dan kamu, penduduk Kapernaum, kamu tidak akan ditinggikan ke surga; kamu akan diturunkan ke Hades. ");
INSERT INTO indags_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Siapapun yang mendengarkan kalian, dia akan mendengarkan Aku, dan siapapun yang menolak kalian, dia menolak Aku. Dan siapapun yang menolak Aku, menolak Dia yang mengutus Aku.” ");
INSERT INTO indags_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ketujuh puluh murid itu kembali dengan penuh sukacita dan berkata, “Tuhan, bahkan setan-setan taat kepada kami dalam nama-Mu!” ");
INSERT INTO indags_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jawab Yesus, “Aku melihat setan jatuh seperti kilat dari langit. ");
INSERT INTO indags_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ya, saya telah memberi kalian kekuatan untuk menginjak ular dan kalajengking, dan untuk mengatasi semua kekuatan musuh, dan tidak ada yang akan membahayakan kalian. ");
INSERT INTO indags_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tetapi jangan senang bahwa roh melakukan apa yang kalian katakan kepada mereka — tetapi bergembiralah karena nama kalian tercatat di surga.” ");
INSERT INTO indags_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maka penuhlah Yesus dengan sukacita yang berasal dari Roh Kudus, dan berkata, “Aku bersyukur, Bapa, Tuhan penguasa bumi dan surga, sebab Engkau menyembunyikan hal-hal ini dari mereka yang menganggap diri bijak dan pandai, dan menyatakan pengertian-pengertian ini kepada anak-anak! Ya, Bapa, cara ini menyenangkan diri-Mu. ");
INSERT INTO indags_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bapa-Ku sudah menyerahkan segalanya kepada-Ku. Tidak seorangpun yang mengerti tentang Anak kecuali Bapa, dan tidak seorangpun yang memahami Bapa kecuali Anak, dan kepada siapa sang Anak memutuskan untuk memperkenalkan Bapa kepadanya.” ");
INSERT INTO indags_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ketika hanya mereka saja, berpalinglah Yesus kepada murid-murid-Nya dan bertanya kepada mereka, “Mereka yang melihat segala sesuatu yang kalian lihat akan bener-benar berbahagia! ");
INSERT INTO indags_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aku beritahu kalian, banyak nabi dan raja yang ingin melihat apa yang kalian lihat, tetapi tidak dapat mereka lihat, dan ingin mendengar apa yang kalian dengar, tetapi tidak bisa mereka dengar.” ");
INSERT INTO indags_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sekali, seorang pengajar hukum Taurat berdiri dan mencoba untuk menjebak Yesus. “Guru,” katanya, “Apa yang harus aku lakukan untuk bisa hidup selamanya?” ");
INSERT INTO indags_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Apa yang tertulis dalam hukum Taurat? Apa yang kamu baca?” tanya Yesus. ");
INSERT INTO indags_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“Kasihilah Tuhan Allahmu dengan seluruh hatimu, seluruh jiwamu, seluruh kekuatanmu, dan seluruh pikiranmu, dan kasihilah sesamamu manusia seperti dirimu sendiri,” jawab orang itu. ");
INSERT INTO indags_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Benar katamu,” jawab Yesus kepada orang itu. “Lakukanlah itu, dan kamu akan beroleh hidup selamanya.” ");
INSERT INTO indags_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Namun orang itu ingin membenarkan dirinya, maka dia kembali bertanya kepada Yesus, “Dan siapakah sesamaku itu?” ");
INSERT INTO indags_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus menjawab dia dengan cerita ini, “Ada seorang laki-laki yang pergi dari kota Yerusalem menuju ke kota Yeriko. Di tengah jalan dia diserang oleh para perampok yang merampas pakaiannya, memukulinya, dan meninggalkannya agar mati di jalan. ");
INSERT INTO indags_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kebetulan sekali, saat itu ada seorang imam yang melewati jalan yang sama. Imam itu melihat si laki-laki itu, tetapi melewatinya dari sisi seberang jalan. ");
INSERT INTO indags_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lalu lewatlah seorang keturunan suku Lewi. Tetapi ketika dia melihat laki-laki itu, dia pun melewatinya dari sisi seberang jalan. ");
INSERT INTO indags_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akhirnya lewatlah seorang Samaria. Ketika dia tiba di tempat itu, dilihatlah laki-laki itu dan merasa kasihan padanya. ");
INSERT INTO indags_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Orang Samaria itu menghampiri si laki-laki itu dan mengobati lukanya dengan minyak dan air anggur, serta membalut mereka. Lalu dia meletakkan laki-laki itu di atas keledainya, serta membawanya ke sebuah penginapan untuk merawat dia. ");
INSERT INTO indags_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Keesokkan harinya, orang Samaria itu memberikan dua keping uang perak kepada pemilik penginapan dan berkata kepadanya, ‘Rawatlah orang ini, dan jika anda harus membelanjakan lebih dari jumlah ini untuk merawatnya, maka saya akan membayarnya ketika saya kembali.’ ");
INSERT INTO indags_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yang mana dari ketiga orang ini menurutmu adalah sesama dari laki-laki yang mengalami perampokan itu?” ");
INSERT INTO indags_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Orang yang menunjukkan kebaikan kepadanya,” jawab orang itu. “Pergilah dan lakukanlah hal yang sama,” kata Yesus kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sementara mereka melanjutkan perjalanan ke Yerusalem, Yesus tiba di sebuah desa, dan seorang wanita yang bernama Marta mengundang Yesus untuk bertamu ke rumahnya. ");
INSERT INTO indags_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta memiliki seorang saudara perempuan bernama Maria, yang duduk di sebelah kaki Yesus dan mendengarkan pengajaran-Nya. ");
INSERT INTO indags_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta kuatir dengan semua hal yang harus dikerjakan untuk menyiapkan sajian, maka datanglah dia kepada Yesus dan berkata, “Guru, tidakkah Engkau peduli bahwa saudara perempuanku meninggalkanku seorang diri mengurus semua pekerjaan ini? Suruhlah agar dia mau membantu saya!” ");
INSERT INTO indags_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","“Marta, Marta,” jawab Tuhan, “kamu kuatir dan kecewa dengan semua ini. ");
INSERT INTO indags_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tetapi hanya satu hal yang paling diperlukan. Maria sudah memilih tindakan yang benar untuk dilakukan, dan hal itu tidak akan diambil oleh siapapun juga darinya.” ");
INSERT INTO indags_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Suatu ketika, Yesus berdoa di tempat yang biasanya. Ketika Dia sudah selesai, bertanyalah salah seorang murid-Nya kepada-Nya, “Guru, ajarlah kami untuk berdoa, sama seperti Yohanes mengajarkan murid-muridnya untuk berdoa.” ");
INSERT INTO indags_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kata Yesus kepada mereka, “Ketika kalian berdoa, katakanlah, ‘Bapa, biarlah nama-Mu dihormati sebab nama-Mu kudus. Datanglah kerajaan-Mu. ");
INSERT INTO indags_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Berilah kami makanan yang kami butuhkan setiap hari. ");
INSERT INTO indags_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampunilah dosa-dosa kami, seperti kami mengampuni orang-orang yang berdosa kepada kami. Jauhkan kami dari pencobaan.’” ");
INSERT INTO indags_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesus menjelaskan kepada mereka, “Seandainya kalian harus pergi ke tempat teman kalian pada tengah malam hari dan minta kepadanya, ‘Kawan, tolong pinjamkan tiga bongkah roti kepada saya ");
INSERT INTO indags_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sebab seorang kawanku datang mengunjungi rumahku, dan saya tidak punya makanan untuk diberikan kepadanya.’ ");
INSERT INTO indags_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kawan kalian mungkin akan menjawab dari dalam rumah, ‘Jangan ganggu saya — saya sudah mengunci pintu, dan saya serta anak-anakku sudah tidur. Aku tidak bisa bangun hanya untuk memberimu sesuatu.’ ");
INSERT INTO indags_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aku katakan kepada kalian, sekalipun dia menolak untuk bangun dan memberikan sesuatu kepada kalian, sekalipun kalian adalah temannya, jika kalian memintanya terus menerus, kawan kalian akan bangun dan memberikan segala yang kamu butuhkan. ");
INSERT INTO indags_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aku katakan kepada kalian, mintalah, dan kamu akan menerima, carilah, maka kamu akan menemukan, ketuklah, maka pintu akan dibukakan untukmu. ");
INSERT INTO indags_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sebab bagi mereka yang meminta, akan menerima, bagi mereka yang mencari, akan menemukan, dan bagi mereka yang mengetuk, pintu akan dibukakan. ");
INSERT INTO indags_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Siapakah di antara kalian, hai para ayah, jika anak laki-laki kalian minta makan ikan, kalian malah memberinya seekor ular? ");
INSERT INTO indags_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atau jika dia minta sebutir telur, kalian memberinya seekor kalajengking? ");
INSERT INTO indags_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jadi jika kamu, sekalipun kamu jahat, masih tahu untuk memberikan pemberian yang baik untuk anak-anakmu, betapa lebih lagi Bapa di Surga memberikan Roh Kudus kepada mereka yang meminta kepada-Nya?” ");
INSERT INTO indags_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesus mengusir setan yang membuat seseorang menjadi bisu. Ketika setan itu sudah pergi, orang bisu itu berbicara kembali, dan orang banyak menjadi kagum. ");
INSERT INTO indags_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tetapi beberapa dari mereka berkata, “Dia mengusir setan dengan kuasa Belzebul, penguasa setan.” ");
INSERT INTO indags_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yang lain mencoba menguji Yesus dengan meminta tanda ajaib dari surga. ");
INSERT INTO indags_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesus tahu pikiran mereka dan berkata, “Setiap kerajaan yang terpecah-pecah karena perang saudara pasti akan hancur. Sebuah keluarga yang saling melawan pasti akan runtuh. ");
INSERT INTO indags_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jika kerajaan setan terbagi-bagi dan saling melawan, bagaimana kerajaannya bisa bertahan? Kamu berkata bahwa Aku mengusir setan menggunakan kuasa Belzebul. ");
INSERT INTO indags_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tetapi jika Aku mengusir setan dengan kuasa Belzebul, dengan kuasa siapa pengikut kalian mengusir mereka? Pengikut kalian sendiri yang membuktikan bahwa kalian salah! ");
INSERT INTO indags_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bagaimanapun, jika Aku mengusir setan dengan kuasa Allah, maka ini adalah bukti bahwa Kerajaan Allah sudah datang. Itu ada di sini di antara kalian! ");
INSERT INTO indags_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ketika seorang yang kuat yang memiliki persenjataan lengkap menjada rumahnya, maka seluruh miliknya aman. ");
INSERT INTO indags_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tetapi jika ada orang yang lebih kuat datang dan mengalahkan dia, mengambil semua persenjataan yang amat diandalkannya, makan orang itu akan bisa mengambil seluruh harta milik orang yang pertama. ");
INSERT INTO indags_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Siapapun yang tidak ada di pihak-Ku, berarti melawan Aku, dan siapapun yang tidak membangun bersama-Ku sedang menghancurkan semuanya. ");
INSERT INTO indags_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ketika satu roh jahat meninggalkan seseorang, roh itu mengembara di daerah padang pasir mencari tempat untuk menetap. Ketika dia tidak menemukan tempat di manapun, maka berkatalah dia, ‘Aku akan kembali ke rumah yang dulu saya tinggalkan.’ ");
INSERT INTO indags_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ketika dia sampai, dilihatnya rumah itu bersih dan rapi. ");
INSERT INTO indags_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Maka pergilah setan itu dan menemukan tujuh setan yang lebih jahat dari dirinya, dan masuklah mereka semua serta tinggal di sana. Pada akhirnya orang itu lebih buruk daripada keadaan dia yang sebelumnya.” ");
INSERT INTO indags_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ketika Yesus sedang berbicara, berserulah salah seorang wanita, “Diberkatilah rahim yang mengandung Engkau dan buah dada yang menyusui Engkau.” ");
INSERT INTO indags_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tetapi Yesus berkata, “Diberkatilah mereka yang mendengar Firman Allah, dan melakukannya.” ");
INSERT INTO indags_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ketika orang-orang mengelilingi Dia, Yesus mulai berbicara kepada mereka, “Generasi yang jahat ini meminta tanja ajaib, tetapi mereka tidak akan mendapatkan tanda apapun kecuali tanda nabi Yunus. ");
INSERT INTO indags_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dengan cara yang sama Yunus menjadi tanda bagi orang Niniwe, demikianlah Anak Manusia menjadi tanda bagi generasi ini. ");
INSERT INTO indags_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ratu Selatan akan bangkit pada hari penghakiman bersama-sama dengan orang-orang dari generasi ini dan akan mendakwa mereka, sebab dia datang dari ujung bumi untuk mendengarkan kebijaksanaan Salomo, dan saat ini ada seseorang yang lebih besar dari pada Salomo di tempat ini! ");
INSERT INTO indags_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Penduduk Niniwe akan bangkit pada hari penghakiman bersama-sama dengan angkatan ini, dan akan mendakwa mereka, sebab mereka bertobat ketika mereka mendengar pesan Yunus, dan ada orang yang lebih besar dari pada Yunus saat ini di sini! ");
INSERT INTO indags_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tidak ada yang menyalakan lilin lalu menutupinya dengan mangkuk. Kalian akan menaruhnya di atas tempat lilin agar siapapun yang masuk ke dalam rumah bisa melihat cahayanya. ");
INSERT INTO indags_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata adalah cahaya bagi tubuhmu. Jika matamu baik, seluruh tubuhmu akan penuh dengan cahaya. Tetapi ketika matamu buruk, tubuhmu juga penuh dengan kegelapan. ");
INSERT INTO indags_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jadi pastikanlah cahaya yang kamu miliki benar-benar cahaya dan bukannya kegelapan. ");
INSERT INTO indags_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jadi jika seluruh tubuhmu penuh dengan kebaikan, tanpa adanya kejahatan, maka tubuhmu benar-benar membawa cahaya, seperti lampu yang memberimu terang.” ");
INSERT INTO indags_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sesudah Yesus selesai berbicara, seorang Farisi mengundang Dia untuk datang dan makan bersamanya. Maka Yesus pergi dan duduk untuk makan. ");
INSERT INTO indags_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Orang Farisi itu terkejut sebab Yesus tidak mencuci tangan-Nya sebelum makan. ");
INSERT INTO indags_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maka berkatalah Tuhan kepadanya, “Kalian orang Farisi hanya membersihkan bagian luar dari cangkir dan piring, tetapi bagian dalam kalian penuh dengan keserakahan dan kejahatan. ");
INSERT INTO indags_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kalian orang-orang bodoh! Kalian pikir Pencipta bagian luar tidak menciptakan bagian dalam?! ");
INSERT INTO indags_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jika perbuatan baik kalian kepada orang lain adalah karena ketulusan hati kalian, maka segalanya akan menjadi bersih bagimu. ");
INSERT INTO indags_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Malu pada kalian hai orang Farisi! Kalian membayar persembahan perpuluhan akan rempah-rempah dan tumbuhan, tetapi kalian mengabaikan keadilan dan kasih Allah. Kalian perlu memperhatikan yang terakhir, sementara tidak membiarkan hal-hal sebelumnya dibatalkan. ");
INSERT INTO indags_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Malu pada kalian hari roang Farisi! Kalian senang mendapatkan tempat duduk terbaik di sinagoga, dan disambut dengan hormat ketika kalian pergi ke pasar. ");
INSERT INTO indags_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Malu pada kalian! Kalian seperti kubur yang tidak ada tandanya, sehingga orang-orang yang lewat di atasnya tidak menyadarinya.” ");
INSERT INTO indags_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Salah seorang yang ahli dalam hukum Taurat berkata, “Guru, perkataanmu juga menghina kami!” ");
INSERT INTO indags_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus menjawab, “Malu pada juga kalian para pengajar ahli Taurat! Kalian memberikan orang-orang peraturan yang sulit untuk dijalani dan tidak mau menolong mereka sedikitpun untuk menjalaninya. ");
INSERT INTO indags_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Malu pada kalian! Kalian membangun kuburan-kuburan untuk menghormati para nabi, tetapi nenek moyang kalianlah yang membunuhi para nabi itu! ");
INSERT INTO indags_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dengan melakukan hal itu, kalian sendiri menjadi saksi bahwa kalian setuju dengan tindakan nenek moyang kalian. Mereka membunuhi para nabi dan kalian yang membangun kuburan bagi nabi-nabi itu! ");
INSERT INTO indags_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Itu sebabnya dalam kebijaksanaan-Nya, Allah berkata, ‘Aku akan mengirimkan kepada mereka para nabi dan rasul; beberapa dari antara mereka akan mereka bunuh, dan yang lain akan mereka hukum mati.’ ");
INSERT INTO indags_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sebagai akibatnya, generasi ini harus bertanggung jawab atas darah semua nabi yang tertumpah sejak awal dunia dijadikan, ");
INSERT INTO indags_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mulai dari darah Habel sampai darah Zakaria yang dibunuh di antara mezbah dan ruang kudus. Ya, Aku katakan kepadamu sejujurnya, angkatan ini harus bertanggungjawab untuk semua itu. ");
INSERT INTO indags_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Malu pada juga kalian para pengajar ahli Taurat! Kalian telah menghilangkan kunci pengetahuan. Kalian tidak masuk ke dalamnya, dan kalian melarang orang untuk masuk juga.” ");
INSERT INTO indags_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ketika Yesus meninggalkan mereka, para pengajar agama dan orang Farisi mulai menyerang dia dengan agresif, memberi pertanyaan-pertanyaan untuk mencobai Dia. ");
INSERT INTO indags_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mereka berusaha menjebak-Nya, mencoba agar Yesus mengatakan sesuatu yang bisa mereka gunakan untuk melawan Dia. ");
INSERT INTO indags_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sementara itu begitu banyak orang yang berkumpul sehingga mereka saling menginjak. Yesus mulai berbicara kepada murid-murid-Nya terlebih dahulu. “Berhati-hatilah terhadap ragi orang Farisi — kemunafikan. ");
INSERT INTO indags_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sebab tidak ada satupun yang tersembunyi yang tidak akan disingkapkan, tidak ada rahasia yang tidak akan dibukakan. ");
INSERT INTO indags_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Apa pun yang kalian katakan dalam kegelapan akan terdengar dalam terang,, dan apapun yang kalian bisikan dengan diam-diam, akan diumumkan ke mana-mana. ");
INSERT INTO indags_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Saya beritahu kalian, kawan-kawan, janganlah takut kepada mereka yang hanya bisa membunuh tubuh kalian saja, sebab sesudah mereka melakukannya, tidak ada perbuatan lain lagi yang bisa mereka lakukan. ");
INSERT INTO indags_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Biar Aku perjelas kepada kalian kepada siapa kalian harus takut. Kalian harus takut pada orang yang setelah dia membunuh memiliki kekuatan untuk menghancurkan mereka di Gehenna. ");
INSERT INTO indags_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bukankah lima burung pipit dijual dengan harga dua penni? Tetapi Allah tidak melupakan satu ekorpun dari mereka. ");
INSERT INTO indags_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bahkan rambut di atas kepalamu pun sudah dihitung-Nya. Jangan takut — kalian jauh lebih berharga dibandingkan burung pipit! ");
INSERT INTO indags_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Saya katakan yang sebenarnya, mereka yang menyatakan bahwa mereka adalah milik saya, Anak manusia juga akan menyatakan bahwa mereka adalah miliknya di hadapan para malaikat Allah, ");
INSERT INTO indags_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","tetapi mereka yang menyangkal saya akan ditolak di hadapan para malaikat Allah. ");
INSERT INTO indags_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Setiap orang yang berbicara melawan Anak Manusia akan dimaafkan, tetapi setiap orang yang menghujat Roh Kudus tidak akan dimaafkan. ");
INSERT INTO indags_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Apabila kalian dibawa ke pengadilan di hadapan para penguasa, pemimpin agama dan pemerintahan, janganlah kuatir tentang cara membela dirimu sendiri, ataupun apa yang harus kamu katakan. ");
INSERT INTO indags_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roh Kudus akan mengajarkan kamu langsung pada saat itu juga hal-hal penting yang harus kamu katakan.” ");
INSERT INTO indags_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Seseorang di dalam kerumunan itu bertanya kepada Yesus, “Guru, tolong beri tahu saudara laki-laki saya untuk berbagi warisan dengan saya.” ");
INSERT INTO indags_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","“Teman,” jawab Yesus, “Siapakah yang menunjuk Aku menjadi hakim bagi kalian untuk membagikan warisan yang kalian dapatkan?” Katanya kepada orang-orang yang ada di sana, ");
INSERT INTO indags_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","“Waspadalah, dan berjaga-jagalah dari setiap pikiran dan tindakan yang memperlihatkan keserakahan, sebab hidup seseorang tidaklah diukur dengan banyaknya barang yang mereka miliki.” ");
INSERT INTO indags_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lalu Yesus menceritakan kepada mereka sebuah kisah. “Ada seorang kaya yang memiliki sebidang tanah yang sangat memberikan hasil yang melimpah. ");
INSERT INTO indags_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Orang itu berkata kepada dirinya sendiri, ‘Apa yang harus aku lakukan? Aku sudah tidak punya tempat untuk menyimpan hasil panenku.’ ");
INSERT INTO indags_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Aku tahu apa yang harus aku lakukan,’ katanya sendiri. ‘Aku akan meruntuhkan tempat penyimpanan yang lama dan membangun kembali tempat penyimpanan yang lebih besar, maka aku akan bisa menyimpan seluruh hasil panenku dan segala kepunyaanku. ");
INSERT INTO indags_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dan saya akan bisa berkata kepada diriku sendiri: Kamu punya cukup banyak bekal untuk hidup dengan nyaman selama bertahun-tahun, karena itu santai saja: makan, minum, dan nikmatilah hidupmu!’ ");
INSERT INTO indags_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tetapi Allah berkata kepadanya, ‘Hai orang bodoh! Hidupmu akan diambil malam ini juga, maka siapa yang akan mendapatkan segala milikmu yang kamu simpan?’ ");
INSERT INTO indags_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Inilah yang akan terjadi kepada mereka yang menumpuk harta bagi diri mereka sendiri, tetapi mereka tidak menjadi kaya di hadapan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kata Yesus kepada murid-murid-Nya, “Itu sebabnya Aku katakan kepada kalian untuk tidak kuatir tentang hidup ini, tentang makanan, ataupun pakaian yang harus kalian pakai. ");
INSERT INTO indags_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hidup itu lebih dari sekedar makanan, dan tubuh lebih dari sekedar pakaian. ");
INSERT INTO indags_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lihatlah burung gagak itu. Mereka tidak menabur ataupun menuai, mereka tidak memiliki tempat untuk menyimpan makanan mereka, namun Allah memberi mereka makan. Dan kalian jauh lebih berharga dibandingkan dengan burung-burung itu! ");
INSERT INTO indags_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bisakah kalian menambah masa hidup kalian satu jam dengan menguatirkan hal-hal itu? ");
INSERT INTO indags_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jika kalian tidak dapat melakukan apa pun tentang hal-hal kecil seperti itu, mengapa khawatir tentang sisanya? ");
INSERT INTO indags_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lihatlah bunga lili dan cara mereka bertumbuh. Mereka tidak bekerja, dan mereka tidak memintal benang untuk pakaian mereka, tetapi Aku katakan kepada kalian, bahkan Salomo pun dalam segala kemegahannya tidaklah berpakaian seindah dari salah satu bunga itu. ");
INSERT INTO indags_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jadi jika Allah mendandani padang-padang dengan bunga-bunga yang indah, yang hari ini ada dan besok hilang karena dibakar dalam api untuk menghangatkan tungku, betapa lebih lagi Allah akan mendandani kalian, hai orang yang kurang percaya! ");
INSERT INTO indags_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Janganlah kuatir tentang apa yang akan kalian makan atau minum — jangan kuatir tentang itu. ");
INSERT INTO indags_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hal-hal ini adalah yang dikuatirkan oleh mereka yang tidak percaya, tetapi Bapamu yang di surga tahu kamu membutuhkan semua ini. ");
INSERT INTO indags_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Carilah kerajaan Allah, dan kalian akan diberikan hal-hal ini juga. ");
INSERT INTO indags_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Janganlah takut, para pengikut-Ku, sebab Bapamu dengan senang hati memberikan kepada kalian kerajaan itu. ");
INSERT INTO indags_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jualah harta milikmu, dan berikanlah uangnya kepada orang miskin. Dapatkan sendiri dompet yang tidak aus — tempat penyimpanan harta yang tidak pernah rusak, yaitu harta di surga yang tidak akan pernah habis, dimana pencuri tidak bisa mencurinya, dan ngengat tidak bisa merusaknya. ");
INSERT INTO indags_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sebab apa yang paling kamu hargai menunjukkan siapa kamu sebenarnya. ");
INSERT INTO indags_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Bersiaplah selalu, dan biarkan lilinmu menyala, ");
INSERT INTO indags_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","seperti seorang pelayan yang menunggu kepulangan tuannya dari tempat pesta, bersiap untuk membukakan pintu dengan cepat baginya, ketika majikannya pulang dan mengetuk pintu. ");
INSERT INTO indags_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Betapa baiknya untuk pelayan yang ketika tuannya kembali melihat mereka berjaga-jaga. Aku katakan sejujurnya kepada kalian, majikannya itu akan bersiap-siap, membuat mereka duduk di meja, dan pada akhirnya melayani mereka seperti mereka melayani dia! ");
INSERT INTO indags_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bahkan ketika dia pulang saat tengah malam, ataupun sebelum subuh — betapa baik bagi mereka jika tuannya menemukan mereka berjaga-jaga dan siap sedia! ");
INSERT INTO indags_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tetapi ingatlah ini: jika tuannya tahu waktunya seorang pencuri akan datang, dia pasti akan berjaga-jaga, dan tidak akan membiarkan rumahnya dimasuki oleh pencuri itu. ");
INSERT INTO indags_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Demikian juga kalian harus siap, sebab Anak Manusia datang di waktu yang paling tidak kalian harapkan.” ");
INSERT INTO indags_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","“Apakah kisah ini Engkau ceritakan khusus untuk kami, atau untuk semua orang?” tanya Petrus. ");
INSERT INTO indags_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jawab Yesus, “Siapakah pengawas yang bijak dan bisa diandalkan, bukankah dia adalah orang yang tuannya percayakan untuk mengelola makanan yang bisa dibagikan pada waktu yang tepat? ");
INSERT INTO indags_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Betapa baiknya bagi pelayan itu jika ketika tuannya kembali dan menemukan dia bekerja seperti yang seharusnya. ");
INSERT INTO indags_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aku katakan sejujurnya kepada kalian, tuannya itu akan mengangkat pelayannya menjadi pengawas untuk mengelola harta miliknya. ");
INSERT INTO indags_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tetapi apa jadinya jika pelayan itu berkata kepada dirinya sendiri, ‘Tuanku akan pergi sangat lama,’ dan mulai memukuli pelayan-pelayan lain, baik laki-laki maupun perempuan, berpesta dan mabuk-mabukan? ");
INSERT INTO indags_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ketika tuannya kembali di saat yang tidak dia duga, dia akan menghukumnya dengan kejam, memperlakukan dia sebagai orang yang benar-benar tidak dapat dipercaya. ");
INSERT INTO indags_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pelayan yang memahami kehendak tuannya, namun tidak bersiap-siap ataupun mengikuti perintah tuannya, akan dipukuli dengan kejam, ");
INSERT INTO indags_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","tetapi pelayan yang tidak tahu kehendak tuannya, dan melakukan pelanggaran-pelanggaran, hanya akan mendapatkan hukuman ringan. Kepada mereka yang diberikan banyak hal, akan diminta memberi yang besar juga, dan kepada mereka yang dipercayakan dengan banyak hal, akan diminta pertanggungjawaban yang lebih besar juga. ");
INSERT INTO indags_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Aku datang untuk menyalakan api di dunia ini, dan Aku benar-benar berharap api itu sudah menyala! ");
INSERT INTO indags_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Namun Aku harus menghadapi sebuah baptisan, dan Aku sangat kesakitan, berharap semua itu berakhir! ");
INSERT INTO indags_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kalian pikir Aku datang untuk membawa damai ke dunia ini? Tidak, saya membawa perpecahan di antara orang-orang. ");
INSERT INTO indags_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mulai saat ini, jika ada lima anggota keluarga, maka tiga orang akan melawan yang dua orang. ");
INSERT INTO indags_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mereka akan saling bertentangan — ayah menentang anak laki-laki, anak laki-laki menentang ayahnya, ibu menentang anak perempuan, dan anak perempuan menentang ibunya, mertua perempuan menentang menantu perempuan, dan menantu perempuan menentang mertua perempuannya.” ");
INSERT INTO indags_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Lalu Yesus berbicara kepada orang banyak itu. “Ketika kalian melihat awan naik di sebelah barat, dengan segera kalian berkata, ‘akan turun hujan hari ini,’ dan itu terjadi. ");
INSERT INTO indags_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ketika angin bertiup dari arah selatan, kalian berkata, ‘hari ini akan terasa panas,’ dan memang demikian terjadi. ");
INSERT INTO indags_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hai orang munafik, bagaimana bisa kalian tahu dengan benar untuk mengartikan cuaca tetapi kalian tidak tahu cara mengartikan saat-saat ini? ");
INSERT INTO indags_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mengapa kalian tidak berpikir untuk diri kalian sendiri dan memilih jalan yang benar? ");
INSERT INTO indags_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kalau penuduhmu mengadukan kamu ke pengadilan, buatlah kesepakatan sebelum hukum dijalankan. Jika tidak, kalian akan diseret ke hadapan hakim, dan hakim itu akan menyerahkan kalian kepada petugasnya yang akan memasukan kalian ke dalam penjara. ");
INSERT INTO indags_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Aku katakan sejujurnya kepada kalian, kalian tidak akan keluar dari penjara itu sebelum kalian melunasi denda kalian.” ");
INSERT INTO indags_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sekitar waktu ini beberapa orang memberitahukan Yesus mengenai Pilatus yang membunuh beberapa orang Galilea sementara mereka sedang memberikan kurban persembahan di rumah Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","“Apakah menurut kalian orang-orang Galilea yang mengalami penderitaan seperti ini memiliki dosa yang lebih besar dibandingkan dengan orang-orang Galilea lainnya?” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Tidak, Aku katakan sejujurnya. Tetapi kecuali kalian bertobat, kalian semua juga akan binasa. ");
INSERT INTO indags_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bagaimana dengan 18 orang yang terbunuh ketika menara di Siloam jatuh menimpa mereka? Apakah menurut kalian mereka orang-orang yang paling jahat dari antara seluruh penduduk Yerusalem? ");
INSERT INTO indags_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tidak. Tetapi kecuali kalian bertobat, kalian juga akan binasa.” ");
INSERT INTO indags_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lalu Yesus memberikan kisah ini sebagai gambaran bagi mereka. “Suatu ketika ada seorang laki-laki yang memiliki pohon ara di kebun anggurnya. Datanglah dia ke kebun itu untuk mencari buah ara, tetapi tidak didapatinya. ");
INSERT INTO indags_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Maka berkatalah si laki-laki ini kepada tukang kebunnya, ‘Dengar, sudah tiga tahun saya mengharapkan buah dari pohon ara ini, namun saya tidak mendapatkannya. Tebanglah pohon itu! Mengapa harus memakan tempat?’ ");
INSERT INTO indags_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Tuan,’ jawab si tukang kebun, ‘Tolonglah bersabar satu tahun lagi. Aku akan menggali tanah di sekeliling pohon itu dan memberinya pupuk lebih banyak. ");
INSERT INTO indags_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Semoga pohon itu bisa berbuah. Tetapi jika tidak, maka akan kita tebang saja.’” ");
INSERT INTO indags_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pada suatu hari Sabat, Yesus sedang mengajar di rumah ibadah, ");
INSERT INTO indags_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","dan di sana ada seorang perempuan yang menjadi cacat karena dirasuki oleh setan selama delapan belas tahun. Tubuhnya menjadi bungkuk, dan dia tidak bisa berdiri tegak. ");
INSERT INTO indags_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ketika Yesus melihat perempuan itu, Dia memanggilnya, dan berkata, “Kamu sudah sembuh.” ");
INSERT INTO indags_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lalu diletakkan-Nya tangan-Nya atas perempuan itu, dan dengan segera perempuan itu menegakkan tubuhnya, dan memuji Allah. ");
INSERT INTO indags_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Namun demikian, sang pemimpin rumah ibadah gundah sebab Yesus menyembuhkan seseorang pada hari Sabat. Katanya kepada orang banyak, “Ada enam hari untuk bekerja. Datang dan disembuhkanlah pada hari-hari itu, tidak pada hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tetapi Tuhan menjawab dia, “Dasar munafik! Bukankah setiap kalian membuka ikatan lembu atau keledai kalian dari kandang dan membawanya untuk minum? ");
INSERT INTO indags_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mengapa tidak perempuan ini, anak perempuan Abraham yang sudah diikat setan selama delapan belas tahun, dilepaskan pada hari Sabat?” ");
INSERT INTO indags_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Perkataan Yesus membuat malu para lawannya, tetapi mereka yang ada dalam kerumunan senang dengan segala perbuatan ajaib yang dia lakukan. ");
INSERT INTO indags_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lalu Yesus bertanya, “Jadi seperti apakah Kerajaan Allah itu? Dengan apa Aku harus membandingkannya? ");
INSERT INTO indags_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kerajaan Allah seumpama benih sesawi yang ditanam seorang petani di kebunnya. Benih itu tumbuh menjadi sebuah pohon, dan burung-burung datang dan membangun sarang pada cabang-cabangnya.” ");
INSERT INTO indags_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus bertanya lagi, “Dengan apakah Aku harus membandingkan Kerajaan Allah? ");
INSERT INTO indags_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kerajaan Allah itu seperti ragi yang dimasukkan seorang perempuan ke dalam tiga belas liter tepung agar seluruh adonan mengembang.” ");
INSERT INTO indags_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus mengajar ke kota-kota kecil dan ke desa-desa, sambil melanjutkan perjalanan-Nya ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ada yang bertanya kepada-Nya, “Tuhan, apakah hanya sedikit orang yang akan diselamatkan?” Jawab Yesus, ");
INSERT INTO indags_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Cobalah dengan sekuat tenagamu untuk masuk melalui pintu yang sempit itu, sebab sejujurnya Aku katakan, banyak yang akan mencoba untuk melewatinya, tetapi sedikit yang berhasil. ");
INSERT INTO indags_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ketika pemilik rumah bangun dan menutup pintu, kalian hanya akan berdiri di luar rumah dan berseru, ‘Tuan, tolong bukakan pintu bagi kami.’ Tetapi dia hanya akan menjawab, ‘Aku tidak mengenal kalian ataupun asal kalian.’ ");
INSERT INTO indags_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dan kalian akan berkata, ‘Tetapi kami makan dan minum bersamamu, dan kamu mengajar di jalan-jalan kami!’ ");
INSERT INTO indags_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jawabnya, ‘Aku sudah katakan, aku tidak mengenalmu ataupun asalmu. Pergilah dariku, hai kalian semua yang tidak melakukan perbuatan yang benar!’ ");
INSERT INTO indags_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akan ada tangisan dan kertakan gigi ketika kalian melihat Abraham, Ishak, Yakub dan semua nabi di kerajaan Allah tetapi kalian diusir. ");
INSERT INTO indags_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Orang-orang akan datang dari ke empat penjuru angin, dan mereka kan duduk dan makan dalam Kerajaan Allah. ");
INSERT INTO indags_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sebab yang terakhir akan menjadi yang pertama, dan yang pertama akan menjadi yang terakhir.” ");
INSERT INTO indags_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pada saat itu, beberapa orang Farisi datang menemui Yesus dan berkata, “Engkau harus meninggalkan tempat ini. Raja Herodes ingin membunuh-Mu!” ");
INSERT INTO indags_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus menjawab mereka, “Pergi dan beritahu rubah itu bahwa Aku akan terus mengusir setan dan menyembuhkan orang-orang pada hari ini dan esok hari, dan pada hari yang ke tiga, Aku sudah menyelesaikan maksud-Ku datang ke sini. ");
INSERT INTO indags_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bagaimanapun juga Aku harus meneruskan perjalanan-Ku untuk hari ini, besok dan lusa. Sebab tidak benar tempatnya jika seorang nabi mati di luar kota Yerusalem! ");
INSERT INTO indags_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem, Yerusalem, kamu yang membunuhi para nabi dan menimpuki dengan batu orang-orang yang dikirm kepadamu! Betapa sering Aku ingin mengumpulkan anak-anakmu seperti seekor induk ayam yang mengumpulkan anak-anaknya di bawah sayapnya, tetapi kamu menolaknya. ");
INSERT INTO indags_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dengar, rumahmu ditinggalkan, dan sejujurnya Aku katakan kepadamu, bahwa kamu tidak akan melihat Aku lagi, sampai kamu berkata, ‘Diberkatilah Dia yang datang dalam nama Tuhan.’” ");
INSERT INTO indags_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Suatu hari Sabat Yesus pergi makan di salah satu rumah seorang pemimpin kaum Farisi di mana mereka dengan ketat mengawasi Dia. ");
INSERT INTO indags_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ada seorang laki-laki yang lengan dan kakinya bengkak. ");
INSERT INTO indags_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jadi bertanyalah Yesus kepada para ahli hukum Taurat dan orang Farisi, “Apakah hukum Taurat mengijinkan menyembuhkan orang pada hari Sabat atau tidak?” ");
INSERT INTO indags_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tetapi mereka diam saja. Lalu Yesus menyentuh orang itu, menyembuhkannya dan menyuruhnya pulang. ");
INSERT INTO indags_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lalu berkatalah Yesus kepada mereka, “Jika anak laki-laki atau lembu kalian terjatuh di dalam sebuah sumur pada hari Sabat, tidakkah kalian akan segera pergi dan menariknya keluar dengan segera?” ");
INSERT INTO indags_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mereka tidak sanggup menjawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Maka Yesus menceritakan sebuah cerita lain kepada para tamu, menyadari bagaimana mereka memilih untuk duduk di tempat terhormat dalam perjamuan makan ini. ");
INSERT INTO indags_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ketika kalian diundang ke sebuah pesta pernikahan, janganlah mengambil tempat yang terhormat, sebab mungkin seseorang yang lebih penting dari kalian sudah diundang,” kata-Nya memulai kisah. ");
INSERT INTO indags_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Tuan rumah yang mengundang kalian berdua akan datang dan berkata kepadamu, ‘Berikanlah kepada orang ini tempatmu.’ Dan dengan penuh rasa malu, kamu harus pindah ke tempat duduk tersisa yang ada di daerah manapun. ");
INSERT INTO indags_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sebaliknya, jika kalian diundang, duduklah di tempat yang dianggap paling tidak terhormat, sehingga ketika tuan rumah datang, dia berkata kepadamu, ‘Teman, mari pindah ke kursi yang lebih baik.’ Maka kalian akan dihormati di hadapan semua tamu undangan yang duduk bersama dengan kalian. ");
INSERT INTO indags_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sebab mereka yang meninggikan dirinya akan direndahkan, dan mereka yang merendahkan dirinya akan ditinggikan.” ");
INSERT INTO indags_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lalu berkatalah Yesus kepada tuan rumah-Nya, “Ketika kamu mengadakan jamuan makan siang atau malam, janganlah mengundang teman-temanmu, ataupun saudara-saudramu, ataupun tetanggamu yang kaya, sebab mereka sanggup mengundangmu kembali, dan kamu sudah mendapat balasan perbuatan baikmu. ");
INSERT INTO indags_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sebaliknya, jika kamu mengadakan suatu jamuan makan, undanglah mereka yang miskin, yang cacat, yang lumpuh, yang buta, ");
INSERT INTO indags_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","dan kamu akan diberkati, sebab mereka tidak bisa membalas perbuatan baikmu, dan kamu akan mendapatkan hadiahmu pada hari ketika orang-orang benar dibangkitkan kembali.” ");
INSERT INTO indags_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ketika salah satu tamu undangan mendengar Yesus mengatakan hal ini, berkatalah dia, “Berbahagialah mereka yang berpesta dalam kerajaan Allah!” ");
INSERT INTO indags_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","“Suatu ketika ada seorang laki-laki yang menyiapkan suatu jamuan makan yang besar, dan mengundang banyak tamu,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Lalu orang itu mengirim para pelayannya ketika sudah tiba waktunya untuk berpesta dan mengatakan kepada mereka yang sudah menerima undangan, ‘Mari, jamuan makan sudah siap.’ ");
INSERT INTO indags_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tetapi para tamu yang diundang itu mulai membuat berbagai alasan agar tidak perlu hadir di pesta. Yang pertama berkata, ‘Aku baru saja membeli sebidang ladang. Aku harus pergi dan melihatnya. Mohon maafkan saya.’ ");
INSERT INTO indags_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yang lainnya berkata, ‘Aku baru saja membeli lima ekor lembu dan harus pergi serta mencoba mengendalikan mereka. Mohon maafkan saya.’ Dan yang lainnya lagi berkata, ");
INSERT INTO indags_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Aku baru saja menikah, jadi aku tidak bisa datang.’ ");
INSERT INTO indags_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Para pelayan orang itu kembali dan memberi tahu tuan mereka apa yang sudah dikatakan oleh para tamu yang diundang. Pemilik rumah menjadi sangat marah dan berkata kepada para pelayannya, ‘Cepat, pergilah ke jalan-jalan dan gang-gang kota ini, dan bawalah mereka yang miskin, dan cacat, dan buta, dan lumpuh.’ ");
INSERT INTO indags_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lalu pelayannya berkata, ‘Tuan, aku sudah melakukan perintah tuan, tetapi masih banyak terdapat ruang kosong di pesta ini.’ ");
INSERT INTO indags_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jadi sang tuan berkata kepada pelayannya, ‘Pergilah ke jalan-jalan di pedesaan, juga di persimpangan-persimpangan, dan buatlah orang-orang pada datang — Aku ingin rumahku ini penuh. ");
INSERT INTO indags_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aku katakan kepada kalian, tidak seorangpun dari orang-orang yang saya undang akan mencicipi jamuan makanku.’” ");
INSERT INTO indags_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sejumlah besar orang mengelilingi Yesus. Berpalinglah Dia kepada mereka dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Jika kalian ingin mengikuti Aku, tetapi kalian tidak menganggap Aku lebih berharga dari pada orang tua kalian, pasangan dan anak-anak kalian, saudara-saudara kalian, bahkan nyawa kalian sendiri, maka kalian tidak bisa menjadi murid-Ku. ");
INSERT INTO indags_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jika kalian tidak memikul salib kalian dan mengikuti saya, kalian tidak dapat menjadi murid saya. ");
INSERT INTO indags_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jika kalian ingin membangun sebuah menara, tidakkah kalian akan duduk dan membuat rencana biaya yang harus dikeluarkan, dan menghitung apakah kalian memiliki cukup biaya untuk menyelesaikan pembangunan itu? ");
INSERT INTO indags_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jika tidak, sesudah kalian meletakkan pondasinya, kalian tidak akan bisa menyelesaikannya, dan setiap orang yang melihatnya akan menertawakan kalian, dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Lihat dia. Dia mulai membangunnya, tetapi tidak dapat menyelesaikannya.’ ");
INSERT INTO indags_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Raja mana yang jika ingin berperang dengan negara lain tidak lebih dulu duduk bersama para penasihatnya untuk mencari tahu apakah dia bersama sepuluh ribu tentaranya bisa mengalahkan mereka yang membawa dua puluh ribu tentara? ");
INSERT INTO indags_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jika sesudah dihitungnya, dia tahu bahwa dia akan kalah, maka dia akan mengirim utusan untuk bisa berdamai sementara lawannya masih ada di tempat yang jauh. ");
INSERT INTO indags_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dengan cara yang sama, setiap kalian yang tidak menyerahkan segalanya, tidak bisa menjadi murid-Ku. ");
INSERT INTO indags_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Garam itu baik, tetapi apabila garam itu sudah kehilangan rasanya, kalian tidak bisa membuatnya asin kembali. ");
INSERT INTO indags_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Garam itu sudah tidak lagi berguna, baik untuk tanah maupun untuk pupuk — kamu hanya bisa melemparnya keluar. Siapapun yang memiliki telinga, maka dengarkan!” ");
INSERT INTO indags_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Para penagih pajak dan “orang-orang berdosa” lainnya sering kali datang dan mendengarkan pengajaran Yesus. ");
INSERT INTO indags_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sebagai hasilnya, para orang Farisi dan pengajar hukum Taurat mengeluh, “Orang ini menyambut orang-orang berdosa, dan seringkali makan bersama mereka.” ");
INSERT INTO indags_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Maka Yesus menceritakan suatu kisah kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bayangkan seseorang yang memiliki seratus ekor domba dan dia kehilangan satu ekor dari antara mereka. Tidakkah dia akan meninggalkan yang 99 ekor di padang terbuka, dan mencari satu yang hilang itu sampai dia bisa menemukannya? ");
INSERT INTO indags_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dan ketika dia menemukannya, dengan gembira, dia akan mengangkat domba itu ke atas bahunya. ");
INSERT INTO indags_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sesudah orang itu tiba di rumah, dia memanggil teman-teman dan tetangganya berkumpul, dan berkata, ‘Mari datang dan rayakan bersamaku! Aku sudah menemukan dombaku yang hilang!’ ");
INSERT INTO indags_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aku katakan kepada kalian, ada lebih banyak sukacita di surga karena satu orang berdosa bertobat dibandingkan 99 orang baik yang tidak memerlukan pertobatan. ");
INSERT INTO indags_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bayangkan seorang perempuan yang kehilangan satu keping uang perak dari antara sepuluh keping miliknya. Tidakkah dia akan menyalakan lilin dan menyapu rumah, dengan berhati-hati mencari uang itu sampai menemukannya? ");
INSERT INTO indags_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sesudah dia menemukannya, dia akan memanggil teman-teman dan tetangganya berkumpul serta berkata, ‘Mari datang dan bersukacitalah bersamaku! Aku sudah menemukan uang perakku yang hilang.’ ");
INSERT INTO indags_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Demikian juga ada sukacita yang besar di hadapan para malaikat di Surga karena satu orang berdosa yang bertobat. ");
INSERT INTO indags_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Suatu ketika ada seorang laki-laki yang mempunyai dua orang anak laki-laki,” kata Yesus memulai kisahnya. ");
INSERT INTO indags_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Anak yang lebih muda berkata kepada ayahnya, ‘Ayah, berikanlah bagian warisanku sekarang.’ Jadi laki-laki itu membagi harta miliknya kepada kedua anaknya itu. ");
INSERT INTO indags_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Beberapa hari kemudian, anak yang lebih muda mengemas semua barang-barangnya dan pergi merantau ke daerah yang jauh. Di sana dia menghambur-hamburkan semua uang yang dimilikinya dengan menjalani kehidupan liar. ");
INSERT INTO indags_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sesudah dia kehabisan segala miliknya, negeri itu mengalami masa kelaparan yang luar biasa, dan si dia ini merasa kelaparan. ");
INSERT INTO indags_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Maka pergilah dia dan mendapat pekerjaan di salah seorang pemilik pertanian yang menyewanya sebagai salah seorang penjaga untuk memberi makan ternak babinya. ");
INSERT INTO indags_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dia merasa begitu lapar sehingga jika bisa dia ingin makan makanan babi, tetapi tidak seorangpun memberinya apapun untuk di makan. ");
INSERT INTO indags_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ketika dia akhirnya menyadari keadaannya, berkatalah dia kepada dirinya sendiri, ‘Seluruh pekerja ayahku memiliki lebih dari cukup untuk dimakan — mengapa saya harus mati kelaparan di tempat ini? ");
INSERT INTO indags_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aku akan kembali pulang ke rumah ayahku! Aku akan berkata kepadanya, Ayah, aku sudah berdosa terhadap surga dan ayah. ");
INSERT INTO indags_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aku sudah tidak layak lagi dipanggil sebagai anak ayah. Tolong perlakukan aku sebagai salah satu pekerja sewaanmu.’ ");
INSERT INTO indags_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Maka pergilah dia dan kembali ke rumah ayahnya. Sekalipun dia masih jauh dari rumah, ayahnya melihat kedatangannya, dan hati sang ayah penuh dengan belas kasihan kepada anaknya. Maka berlarilah sang ayah menyambut anaknya, memeluk dan menciumi dia. ");
INSERT INTO indags_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kata sang anak kepada ayahnya, ‘Ayah, aku sudah berdosa terhadap surga dan bapa. Aku tidak layak lagi disebut anak bapa.’ ");
INSERT INTO indags_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tetapi sang bapak berkata kepada para pekerjanya, ‘Cepat — bawa jubah yang terbaik dan pakaikan itu kepadanya. Pakaikan cincin di jarinya dan sandal di kakinya. ");
INSERT INTO indags_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bawalah anak kambing yang sudah digemukkan dan sembelihlah itu. Mari kita mengadakan pesta untuk merayakan ");
INSERT INTO indags_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","sebab anakku yang saya pikir sudah mati, ternyata masih hidup dan kembali, dia yang sudah hilang, sekarang ditemukan kembali.’ Maka mereka mulai mengadakan perayaan. ");
INSERT INTO indags_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lalu datanglah anak yang lebih tua baru saja selesai bekerja dari ladang. Ketika dalam perjalanan pulang, dia mendengar suara musik dan tari-tarian. ");
INSERT INTO indags_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jadi dia memanggil salah satu pelayan dan bertanya apa yang terjadi. ");
INSERT INTO indags_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Adik tuan sudah kembali,’ jawabnya, ‘dan ayah tuan sudah menyembeli anak kambing yang digemukkan, sebab adik tuan sudah kembali pulang dengan selamat.’ ");
INSERT INTO indags_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Anak yang lebih tua itu menjadi marah, Dan dia menolak masuk ke dalam rumah. Maka sang ayah datang keluar untuk berbicara kepada dia. ");
INSERT INTO indags_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Katanya kepada ayahnya, ‘Selama bertahun-tahun saya sudah melayani ayah, dan tidak pernah tidak taat kepada ayah, tetapi tidak sekalipun ayah memberiku seekor kambing muda agar saya bisa berpesta bersama dengan teman-temanku. ");
INSERT INTO indags_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sekarang anakmu sudah kembali, menghabiskan semua uang ayah dengan perempuan murahan, dan ayah malah menyembelih anak kambing gemukan untuk dia!’ ");
INSERT INTO indags_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Nak,’ jawab ayahnya, ‘kamu selalu bersama-sama dengan ayah. Segala milik ayah adalah milikmu. ");
INSERT INTO indags_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tetapi tentulah kita harus senang dan mengadakan perayaan! Ini adikmu, yang dikira sudah mati, ternyata masih hidup, dia hilang tapi sekarang dia ditemukan!!’” ");
INSERT INTO indags_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus memberikan cerita ini kepada murid-murid-Nya. “Tersebutlah ada seorang kaya yang pengurus rumahnya dituduh menghambur-hamburkan kekayaannya. ");
INSERT INTO indags_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Maka si orang kaya ini memanggil pengurus rumahnya, dan bertanya, ‘Apa ini yang saya dengar tentang kamu? Bawa akun kamu, karena kamu tidak akan melanjutkan sebagai manajer.’ ");
INSERT INTO indags_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Si pengurus rumah berkata kepada dirinya sendiri, ‘Apa yang harus aku lakukan sebab tuanku akan memecat aku? Aku tidak kuat untuk menjadi penggali lubang, dan aku tidak mau menjadi pengemis. ");
INSERT INTO indags_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Baiklah, aku tahu apa yang harus aku lakukan ketika aku dipecat sebagai pengurus rumah, orang-orang masih akan menerima aku di rumah mereka.’ ");
INSERT INTO indags_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jadi dia mengundang semua orang yang sedang berhutang kepada tuannya untuk datang dan menemui dia. Dan dia bertanya kepada yang pertama, ‘Berapa banyak hutangmu kepada tuanku?’ ");
INSERT INTO indags_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Orang itu menjawab, ‘dua puluh dua liter minyak.’ Kata si pengurus rumah kepadanya, ‘Duduklah cepat. Ambil tagihanmu, dan ubahlah menjadi sebelas liter.’ ");
INSERT INTO indags_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lalu katanya kepada yang lain, ‘Berapa hutangmu?’ Orang itu menjawab, ‘tiga ratus sembilan puluh liter gandum.’ Kata si pengurus rumah keapdanya, ‘Ambillah tagihanmu dan gantilah menjadi tiga ratus dua belas liter.’ ");
INSERT INTO indags_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Orang kaya itu memuji manajernya yang tidak jujur karena idenya yang licik. Sungguh, orang-orang yang hanya mengurusi urusan duniawi memang lebih licik terhadap satu sama lain dibandingkan mereka yang anak-anak cahaya. ");
INSERT INTO indags_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aku beritahu kepada kalian, gunakan kekayaan dunia ini untuk mencari teman bagi dirimu sendiri sehingga ketika semuanya berakhir, kalian akan disambut di rumah abadi. ");
INSERT INTO indags_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jika kalian bisa dipercaya untuk hal yang paling kecil, kalian juga bisa dipercaya untuk hal yang besar; jika kalian tidak jujur dengan hal yang sangat kecil, kalian juga tidak akan jujur dengan hal yang besar. ");
INSERT INTO indags_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jadi, jika kalian tidak bisa dipercaya dengan harta dunia ini, bagaimana kalian bisa dipercaya dengan kekayaan sejati? ");
INSERT INTO indags_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dan jika kalian tidak bisa dipercaya dengan harta milik orang lain, siapa yang akan mempercayai kalian dengan harta milik kalian sendiri? ");
INSERT INTO indags_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tidak ada pelayan yang bisa melayani dua tuan. Entah dia akan membenci yang seorang dan mengasihi yang lain, atau dia akan berbakti dengan yang seorang dan mengabaikan yang lain. Kalian tidak bisa melayani Allah dan Uang.” ");
INSERT INTO indags_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Orang Farisi yang sangat menyukai uang, mendengar perkataan Yesus dan menertawakan Dia. ");
INSERT INTO indags_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tetapi Yesus berkata kepada mereka, “Kalian memang tampak seperti orang saleh di hadapan orang-orang, tetapi Allah tahu apa yang kalian pikirkan. Dan apa yang sangat dihargai manusia ini dibenci oleh Allah. ");
INSERT INTO indags_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Semua yang tertulis di dalam hukum Taurat dan kitab para nabi berlangsung sampai pada masa tampilnya Yohanes Pembaptis. Sejak itu berita tentang Kerajaan Allah disebarluaskan, dan setiap orang mencoba memaksa masuk. ");
INSERT INTO indags_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Namun demikian, lebih mudah bagi surga dan bumi untuk lenyap dibandingkan titik terkecil dari Hukum Taurat dibatalkan. ");
INSERT INTO indags_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Setiap laki-laki yang menceraikan istrinya untuk menikah dengan perempuan lain sudah melakukan perselingkuhan, dan setiap laki-laki yang menikahi perempuan yang diceraikan juga melakukan perselingkuhan. ");
INSERT INTO indags_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ada seorang laki-laki yang sangat kaya. Dia mengenakan pakaian berwarna ungu dengan kain halus, dan menikmati hidup yang mewah. ");
INSERT INTO indags_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lalu ada seorang pengemis bernama Lasarus yang biasa duduk di depan pintu gerbang rumah si orang kaya. Seluruh tubuhnya dipenuhi luka bernanah, ");
INSERT INTO indags_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","menunggu untuk mendapatkan makanan sisa dari meja si orang kaya. Bahkan anjing-anjing datang dan menjilati luka-lukanya.” ");
INSERT INTO indags_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kemudian si pengemis itu mati, dan para malaikat membawanya kepada Abraham. Si orang kaya juga mati dan dikuburkan. ");
INSERT INTO indags_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Di dalam Hades, di mana si orang kaya menderita penyiksaan, dia menengadahkan kepalanya dan melihat Abaraham di kejauhan, bersama Lazarus di sampingnya. ");
INSERT INTO indags_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Bapa Abaraham,’ serunya, ‘Berbelas kasihanlah kepadaku dan kirimkanlah Lazarus untuk mencelupkan ujung jarinya ke dalam air dan memberiku minum untuk mendinginkan lidahku, sebab aku terbakar kesakitan.’ ");
INSERT INTO indags_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tetapi Abaraham menjawab, ‘Anakku, ingatlah bahwa kamu sudah menikmati kehidupan yang baik, sementara Lazarus mengalami hidup yang sangat buruk. Sekarang Lazarus sudah hidup damai, sementara kamu menderita siksaan. ");
INSERT INTO indags_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Selain itu, ada jurang besar yang membentang antara kami dan kamu. Tak seorang pun yang ingin menyeberang dari sini ke kamu dapat melakukannya, dan tak seorang pun dapat menyeberang dari sana ke kami.’ ");
INSERT INTO indags_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jawab si orang kaya itu, ‘Jika demikian, bapa, saya mohon, tolong kirim Lazarus kepada keluarga ayahku. ");
INSERT INTO indags_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sebab saya masih punya lima saudara, dan dia bisa memperingati mereka agar mereka tidak berakhir di tempat penyiksaan ini.’ ");
INSERT INTO indags_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tetapi Abaraham menjawab dia, ‘Mereka bisa mendengarkan Musa dan para nabi.’ ");
INSERT INTO indags_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Mereka tidak akan mendengarkan Musa dan para nabi, Bapa Abaraham,’ kata orang itu. ‘Tetapi mereka akan bertobat jika ada seseorang yang bangkit dari kematian mengunjungi mereka!’ ");
INSERT INTO indags_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jawab Abaraham kepada orang itu, ‘Jika mereka tidak mendengarkan perkataan Musa dan para nabi, maka mereka juga tidak akan diyakinkan bahwa oleh orang yang dibangkitkan dari kematian.’” ");
INSERT INTO indags_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Berkatalah Yesus kepada murid-murid-Nya, “Pencobaan tidak dapat dihindari, tetapi itu akan menjadi bencana bagi mereka yang melaluinya mereka datang! ");
INSERT INTO indags_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sebab orang-orang seperti itu, akan lebih baik jika sebuah batu kilangan digantungkan pada lehernya dan dibuang ke laut daripada menyebabkan anak-anak kecil ini berbuat dosa. ");
INSERT INTO indags_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jadi berhati-hatilah dengan perbuatanmu. Jika saudaramu berdosa, peringatilah dia, dan jika dia bertobat, ampunilah dia. ");
INSERT INTO indags_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bahkan jika dia berdosa kepada kalian sebanyak tujuh kali dalam sehari, dan dia datang kepada kalian meminta maaf sebanyak tujuh kali, ‘Aku sungguh menyesal,’ ampunilah dia.” ");
INSERT INTO indags_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Para rasul itu berkata kepada Tuhan, “Tolong agar kami bisa lebih percaya lagi kepada-Mu!” ");
INSERT INTO indags_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tuhan menjawab mereka, “Bahkan jika rasa percaya kalian sebesar biji sesawi, kalian bisa berkata kepada pohon murbai ini, ‘Pindahlah dirimu ke dalam laut,’ maka hal itu akan terjadi. ");
INSERT INTO indags_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Katakanlah kalian mempunyai seorang pekerja yang membajak di ladang atau mengembalakan ternakmu. Ketika dia kembali dari pekerjaan, apakah kalian berkata kepadanya, ‘Mari masuk dan makanlah!?’ ");
INSERT INTO indags_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tidak. Yang kalian katakan adalah, ‘Siapkanlah makananku, berpakaian dan layanilah sampai saya selesai makan. Sesudah itu barulah kamu makan.’ ");
INSERT INTO indags_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dan apakah kalian mengucapkan terima kasih karena dia taat kepada kalian? Tidak. ");
INSERT INTO indags_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Demikian juga kalian, jika kalian sudah selesai mengerjakan tugas yang dibebankan kepada kalian, cukup katakan, ‘Kami hanyalah seorang pekerja. Kami hanya melakukan tugas kami.’” ");
INSERT INTO indags_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ketika Yesus melanjutkan perjalanannya menuju kota Yerusalem, dia melewati perbatasan antara daerah Samaria dan Galilea. ");
INSERT INTO indags_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ketika Dia memasuki sebuah desa, ada sepuluh orang kusta yang menemui Dia, berdiri di kejauhan. ");
INSERT INTO indags_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mereka berseru, “Yesus, kasihanilah kami.” ");
INSERT INTO indags_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ketika Yesus melihat mereka, berkatalah Dia, “Pergi dan tunjukkanlah diri kalian kepada para imam.” Dan dalam perjalanan mereka menuju ke tempat para imam, orang-orang kusta ini disembuhkan. ");
INSERT INTO indags_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Salah seorang dari mereka menyadari bahwa mereka sudah disembuhkan, kembalilah dia kepada Yesus, sambil berseru memuji Allah. ");
INSERT INTO indags_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tersungkurlah dia di kaki Yesus, berterima kasih kepada-Nya. Orang yang disembuhkan ini adalah seorang Samaria. ");
INSERT INTO indags_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","“Bukankah ada sepuluh orang yang disembuhkan?” tanya Yesus. “Dimana sembilan orang lainnya? ");
INSERT INTO indags_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apakah tidak ada yang lain yang kembali untuk memuji Allah selain dari orang asing ini?” ");
INSERT INTO indags_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kata Yesus kepada orang itu, “Bangun dan pulanglah. Karena kamu percaya kepada-Ku, maka kamu sudah disembuhkan.” ");
INSERT INTO indags_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Suatu ketika, pada saat orang-orang Farisi datang dan bertanya kapan Kerajaan Allah akan datang, Yesus menjawab mereka, “Kerajaan Allah tidak datang dengan disertai tanda-tanda yang bisa kalian lihat dan amati. ");
INSERT INTO indags_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Orang-orang tidak akan berkata, ‘Lihat, itu dia disana’ atau ‘Lihat, dia disini,’ sebab Kerajaan Allah itu ada di antara kamu.” ");
INSERT INTO indags_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lalu berkatalah Yesus kepada murid-murid-Nya, “Waktunya sudah dekat ketika kalian akan merindukan untuk melihat hari kedatangan Anak Manusia, tetapi kalian tidak akan melihatnya. ");
INSERT INTO indags_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mereka akan memberitahu kepada kalian, ‘Lihat, Dia ada di sana,’ atau ‘lihat, Dia disini,’ tetapi janganlah pergi ke tempat-tempat yang mereka sebutkan itu. ");
INSERT INTO indags_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hari kedatangan Anak Manusia seumpama seperti kilat yang memancar, menerangi langit dari sisi yang satu ke sisi lainnya. ");
INSERT INTO indags_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tetapi Anak Manusia haruslah mengalami banyak penderitaan, dan akan ditolak oleh angkatan ini. ");
INSERT INTO indags_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hari kedatangan Anak Manusia akan seperti hari-hari ketika masa hidup Nuh. ");
INSERT INTO indags_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Manusia akan makan dan minum, menikah dan dinikahi sampai tiba harinya Nuh masuk ke dalam perahu besar. Lalu datanglah banjir dan menghancurkan mereka semua. ");
INSERT INTO indags_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hari kedatangan Anak Manusia juga seperti pada masa hidup Lot. Orang-orang makan dan minum, membeli dan menjual, bertanam dan membangun. ");
INSERT INTO indags_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tetapi pada hari ketika Lot meninggalkan kota Sodom, hujan api dan batu belerang turun dari surga dan menghancurkan mereka semua. ");
INSERT INTO indags_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Demikianlah hari kedatangan Anak Manusia. ");
INSERT INTO indags_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jika kalian ada di atas atap, janganlah turun ke bawah untuk membereskan barang-barang kalian, dan jika kalian ada di tengah ladang, janganlah kalian kembali ke rumah. ");
INSERT INTO indags_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ingatlah kejadian yang menimpa istri Lot! ");
INSERT INTO indags_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jika kalian mencoba menyelamatkan nyawa kalian, kalian akan kehilangan nyawa kalian, tetapi jika kalian kehilangan hidup kalian, kalian akan menyelamatkannya. ");
INSERT INTO indags_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Aku katakan kepada kalian, jika ada dua orang di atas tempat tidur malam itu, yang seorang akan diangkat dan yang lain akan ditinggalkan. ");
INSERT INTO indags_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jika ada dua orang perempuan sedang menggiling gandum, yang seorang akan diangkat dan yang seorang akan ditinggalkan.” ");
INSERT INTO indags_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Ke mana, Tuhan?” tanya murid-murid Yesus. “Dimana ada bangkai, di situlah burung-burung pemakan bangkai berkumpul,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus memberikan kisah ini untuk memberikan semangat agar murid-muridnya mau terus menerus berdoa dan tidak menjadi patah semangat. ");
INSERT INTO indags_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Suatu ketika ada seorang hakim di sebuah kota yang tidak menghormati Allah dan tidak peduli kepada siapapun,” kata Yesus memulai. ");
INSERT INTO indags_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“Di kota itu hidup juga seorang janda yang dari waktu ke waktu pergi menemui hakim itu dan berkata, ‘Berilah keadilan dalam perkaraku terhadap lawanku!’ ");
INSERT INTO indags_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Selama beberapa saat, si hakim tidak ingin melakukan apapun juga tentang perkara si janda, tetapi pada akhirnya si hakim berkata kepada dirinya sendiri, ‘Sekalipun aku tidak menghormati Allah ataupun peduli dengan orang lain, ");
INSERT INTO indags_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","janda ini sangat mengesalkan, maka saya akan pastikan dia menerima keadilan. Sehingga dia tidak menyusahkanku dengan mendatangiku begitu sering.’” ");
INSERT INTO indags_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Perhatikanlah kata-kata yang diucapkan hakim yang tidak adil itu,” kata Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“Apakah menurut kalian Allah tidak akan memastikan orang-orang pilihan-Nya menerima keadilan, mereka yang berseru kepada-Nya siang dan malam? Menurut kalian, Dia akan membuat mereka menunggu? ");
INSERT INTO indags_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tidak, Aku katakan kepada kalian. Dia pasti akan dengan segera memutuskan perkara mereka dengan adil. Namun demikian, ketika Anak Manusia datang, apakah Dia akan menemukan masih ada orang-orang di dunia ini yang percaya kepada-Nya?” ");
INSERT INTO indags_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus juga menceritakan kisah tentang orang-orang yang merasa yakin bahwa dirinya sudah hidup benar, dan membuat orang lain merasa diri mereka tidak hidup dengan benar. ");
INSERT INTO indags_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ada dua orang yang datang ke rumah Tuhan untuk berdoa. Yang seorang adalah orang Farisi, dan yang lain adalah seorang penagih pajak. ");
INSERT INTO indags_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Si orang Farisi berdiri dan berdoa kepada dirinya sendiri, ‘Allah, saya bersyukur sebab saya tidak seperti orang-orang lain — tukang tipu, penjahat, tukang selingkuh — atau bahkan seperti penagih pajak ini. ");
INSERT INTO indags_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aku berpuasa dua kali dalam seminggu, dan aku juga memberikan persembahan sebesar sepuluh persen dari upahku.’ ");
INSERT INTO indags_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tetapi si penagih pajak berdiri di kejauhan. Dia bahkan tidak menengadahkan kepalanya menatap langit. Sebaliknya, dia memukuli dadanya dan berdoa, ‘Allah, kasihanilah saya. Aku ini orang berdosa.’ ");
INSERT INTO indags_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aku katakan sejujurnya kepada kalian, si penagih pajak inilah yang pulang ke rumah yang diterima oleh Allah, dan bukan si orang Farisi. Mereka yang suka meninggikan dirinya akan direndahkan, dan mereka yang suka merendahkan dirinya akan ditinggikan.” ");
INSERT INTO indags_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kemudian para orang tua membawa bayi-bayi mereka kepada Yesus agar Yesus memberkati anak-anak mereka. Ketika para murid melihat apa yang sedang terjadi, mereka mencoba menghentikan mereka. ");
INSERT INTO indags_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tetapi Yesus memanggil anak-anak itu untuk mendekat kepada-Nya. “Biarkan anak-anak itu datang kepada-Ku,” kata-Nya. “Jangan menghentikan mereka, sebab kerajaan Allah adalah milik mereka yang seperti mereka. ");
INSERT INTO indags_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sejujurnya Aku katakan kepada kalian, siapapun yang tidak menyambut Kerajaan Allah seperti seorang anak kecil tidak akan bisa memasukinya.” ");
INSERT INTO indags_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Salah satu pemimpin datang kepada Yesus dan bertanya, “Guru yang baik, apakah yang harus aku lakukan agar aku bisa hidup selamanya?” ");
INSERT INTO indags_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Mengapa kamu menyebut-Ku baik?” jawab Yesus. “Hanya Allah saja yang baik, tidak seorangpun baik. ");
INSERT INTO indags_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kamu sudah tahu perintah-perintahnya: jangan berzina, jangan membunuh, jangan mencuri, jangan memberi kesaksian palsu, hormatilah ayahmu dan ibumu.” ");
INSERT INTO indags_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Aku sudah menaati semua perintah-perintah ini sejak saya masih kanak-kanak,” jawab orang itu. ");
INSERT INTO indags_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ketika Yesus mendengar jawaban ini, berkatalah Dia kepada laki-laki ini, “Masih ada satu hal yang belum kamu lakukan. Pergilah dan jualah segala milik kepunyaanmu, berikanlah uangnya kepada orang-orang miskin, dan kamu akan mendapat harta bagi dirimu di surga. Lalu datang ke mari dan ikutlah Aku!” ");
INSERT INTO indags_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ketika laki-laki muda ini mendengar perkataan Yesus, dia pun merasa sedih, sebab dia sangat kaya. ");
INSERT INTO indags_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Melihat reaksi laki-laki ini, Yesus berkata, “Betapa sulitnya bagi orang kaya untuk masuk Kerajaan Allah! ");
INSERT INTO indags_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lebih mudah bagi seekor unta untuk melewati lubang jarum jahit, dibandingkan bagi seorang kaya untuk masuk ke dalam kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mereka yang mendengar perkataan-Nya saling bertanya, “Jika seperti itu keadaannya, siapa yang bisa diselamatkan?” ");
INSERT INTO indags_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jawab Yesus, “Segala sesuatu yang tidak mungkin bagi manusia, menjadi bisa dilakukan oleh Allah.” ");
INSERT INTO indags_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter berkata, “Kami sudah meninggalkan segala sesuatunya untuk mengikut Engkau!” ");
INSERT INTO indags_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Sejujurnya Aku katakan kepada kalian!” kata Yesus. “Siapapun yang sudah meninggalkan rumah mereka ataupun sanak keluarga mereka serta milik mereka demi Aku, dan demi kabar baik yang harus diberitakan, ");
INSERT INTO indags_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","akan menerima lebih banyak lagi dalam kehidupan sekarang ini, dan dalam kehidupan untuk selamanya di dunia yang akan datang.” ");
INSERT INTO indags_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kemudian Yesus berkumpul dengan murid-murid-Nya, terpisah dari kerumunan orang banyak, dan memberi tahu mereka, “Kita akan berangkat ke kota Yerusalem, dan semua yang sudah dinubuatkan oleh para nabi secara tertulis tentang Anak Manusia akan digenapi. ");
INSERT INTO indags_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anak Manusia akan diserahkan kepada orang Romawi; Dia akan diejek, dihina, dan diludahi. ");
INSERT INTO indags_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mereka akan memecut-Nya dan membunuh Dia, tetapi pada hari yang ke tiga Dia akan bangkit kembali.” ");
INSERT INTO indags_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tetapi mereka tidak mengerti apapun yang sudah Yesus katakan kepada mereka. Makna perkataan itu tersembunyi dari mereka, dan mereka tidak menangkap apa yang dikatakan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ketika mereka tiba di kota Yeriko, seorang laki-laki yang buta sedang duduk di pinggir jalan mengemis. ");
INSERT INTO indags_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dia mendengar orang banyak lewat, jadi bertanyalah dia kepada seseorang apa yang sedang terjadi. ");
INSERT INTO indags_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kata mereka kepadanya, “Yesus si orang Nazaret akan lewat.” ");
INSERT INTO indags_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Maka berserulah laki-laki itu, “Yesus, anak Daud, kasihanilah saya!” ");
INSERT INTO indags_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mereka yang berada di bagian depan kerumunan meminta orang buta itu berhenti berteriak dan berdiam, namum si laki-laki itu berteriak lebih keras lagi, “Yesus, Anak Daud, kasihanilah saya!” ");
INSERT INTO indags_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus berhenti dan memberitahu mereka untuk membawa si orang buta kepada-Nya. Ketika orang itu tiba, bertanyalah Yesus, ");
INSERT INTO indags_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Apa yang kamu ingin untuk Aku lakukan bagimu?” “Tuhan, tolong, aku ingin bisa melihat,” kata orang itu memohon. ");
INSERT INTO indags_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Kalau begitu, melihatlah!” kata Yesus kepadanya. “Kamu disembuhkan sebab kamu percaya kepada-Ku.” ");
INSERT INTO indags_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dengan segera si laki-laki itu bisa melihat. Dia mengikuti Yesus, memuji Allah. Dan setiap orang yang melihat kejadian itu secara langsung juga memuji Allah. ");
INSERT INTO indags_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus masuk ke kota Yeriko dan melintasi kota itu. ");
INSERT INTO indags_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Di sana ada seorang bernama Zakeus, seorang kepala penagih pajak. Dia sangat kaya. ");
INSERT INTO indags_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dia ingin melihat siapa Yesus itu, tetapi karena tubuhnya pendek, dia tidak bisa melihat melalui kerumunan orang. ");
INSERT INTO indags_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jadi dia berlari mendahului kerumunan orang, dan memanjat pohon ara untuk melihat Yesus ketika Yesus lewat. ");
INSERT INTO indags_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ketika Yesus tiba di bawah pohon ara, Dia menengadah ke atas dan berkata, “Zakeus, mari turun cepat! Aku perlu menginap di rumahmu hari ini.” ");
INSERT INTO indags_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dengan segera Zakeus turun dan begitu gembira menyambut Yesus ke dalam rumahnya. ");
INSERT INTO indags_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ketika orang-orang melihat ini, mereka menggerutu, “Dia akan menginap di rumah orang yang sangat berdosa!” ");
INSERT INTO indags_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tetapi Zakeus berdiri dan berkata di hadapan Tuhan, “Lihat, saya akan memberikan setengah dari seluruh harta milikku kepada orang miskin, dan jika saya pernah curang kepada siapapun, saya akan membayar mereka empat kali lipat!” ");
INSERT INTO indags_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dan Yesus menjawab perkataan Zakeus dengan mengatakan, “Hari ini, keselamatan sudah tiba atas keluarga ini, sebab sekarang, laki-laki ini pun sudah menunjukkan bahwa dia adalah keturunan Abraham. ");
INSERT INTO indags_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sebab Anak Manusia datang untuk mencari dan menyelamatkan yang hilang.” ");
INSERT INTO indags_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sementara orang-orang masih mendengarkan, Yesus memceritakan sebuah kisah sebab mereka sudah dekat dengan kota Yerusalem, dan orang-orang itu berpikir bahwa Kerajaan Allah akan segera menjadi sebuah kenyataan. ");
INSERT INTO indags_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Tersebutlah seorang yang terhormat yang meninggalkan rumahnya untuk pergi ke negeri yang jauh dan menjadi raja di sana, lalu akan kembali lagi ke rumah. ");
INSERT INTO indags_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sebelum dia berangkat, dipanggillah olehnya tiga orang pekerjanya, dan membagi uang sejumlah seratus hari upah pekerja dan berkata, ‘Usahakanlah uang ini sampai saya kembali.’ ");
INSERT INTO indags_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tetapi rakyatnya membenci orang ini, dan mengirim seorang utusan kepadanya dengan berkata, ‘Kami tidak ingin orang ini menjadi raja atas kami.’ ");
INSERT INTO indags_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sesudah orang ini dinobatkan menjadi raja, kembalilah dia ke rumahnya. Dia memerintahkan agar para pekerjanya dibawa menghadap dia. Dia ingin tahu keuntungan apa yang sudah mereka buat dengan mengusahakan uang yang dia berikan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pekerja yang pertama masuk dan berkata, ‘Tuan, uang tuan sudah menghasilkan sepuluh kali lipat.’ ");
INSERT INTO indags_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Baik sekali! Kamu pekerja yang baik,’ kata sang raja. ‘Karena kamu sudah membuktikan dirimu layak dipercaya untuk hal yang kecil, maka saya memberimu tanggung jawab untuk mengurus sepuluh kota.’ ");
INSERT INTO indags_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pekerja yang kedua masuk dan berkata, ‘Tuan, uang tuan sudah menghasilkan lima kali lipat.’ ");
INSERT INTO indags_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Aku mempercayakan kamu untuk mengurus lima kota,’ kata sang raja. ");
INSERT INTO indags_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Datanglah pekerja yang terakhir dan berkata, ‘Tuan, ini ambil kembali uangmu. Aku sudah menyimpannya di tempat yang aman, membungkuskan dalam kain. ");
INSERT INTO indags_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aku takut kepada tuan, sebab tuan seorang yang kejam. Tuan mengambil barang yang bukan milik tuan, dan menuai dari tanaman yang tidak tuan tanam.’ ");
INSERT INTO indags_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Sesuai dengan perkataanmu,’ jawab sang raja. ‘Kamu tahu saya tuan yang kejam, yang “mengambil apa yang bukan milikku, dan menuai di tempat saya tidak menanam.” ");
INSERT INTO indags_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jika begitu, mengapa tidak kamu taruh uangku di bank, sehingga ketika saya kembali, saya bisa mendapatkannya kembali berikut dengan bunga simpanannya?’ ");
INSERT INTO indags_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sang raja memberi perintah kepada mereka yang berdiri di sampingnya, ‘Ambillah uang itu darinya, dan berikan kepada dia yang bisa menghasilkan sepuluh kali lipat.’ ");
INSERT INTO indags_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Tetapi Tuan, orang itu sudah punya sepuluh kali lebih banyak,’ mereka menjawab. ");
INSERT INTO indags_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jawab sang raja, ‘Aku katakan kepada kalian, kepada siapa yang punya, akan diberikan lebih lagi, tetapi kepada siapa yang tidak punya, bahkan apa ang mereka miliki akan diambil dari mereka. ");
INSERT INTO indags_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dan kepada musuh-musuhku yang tidak ingin saya menjadi raja atas mereka, bawa mereka ke mari dan bunuh mereka di hadapanku.’” ");
INSERT INTO indags_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sesudah Yesus selesai menceritakan kisah ini, Yesus melanjutkan perjalanan menuju kota Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ketika Yesus hampir tiba di Betsfage dan Betania di Bukit Zaitun, dia mengirim dua orang murid-Nya, dan memberitahu mereka: ");
INSERT INTO indags_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Pergilah jauh ke dalam desa. Ketika kalian masuk ke desa itu, kalian akan menemukan seekor keledai betina yang belum pernah ditunggangi oleh seorangpun. Bukalah ikatannya dan bawalah hewan itu ke sini. ");
INSERT INTO indags_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jika ada yang bertanya kepada kalian, ‘Mengapa kalian melepaskan ikatan hewan itu?’ katakan saja, ‘Tuhan memerlukan hewan ini.’” ");
INSERT INTO indags_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Maka kedua murid itu pergi dan menemukan segala yang baru saja Yesus katakan. ");
INSERT INTO indags_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ketika mereka melepaskan ikatan keledai betina itu, pemiliknya bertanya kepada mereka, “Mengapa kalian melepaskan ikatan keledai betina itu?” ");
INSERT INTO indags_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Murid-murid itu menjawab, “Tuhan memerlukannya.” ");
INSERT INTO indags_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mereka membawa keledai betina itu kepada Yesus. Lalu mereka menutupi punggung keledai itu dengan jubah-jubah mereka, dan Yesus duduk di atas punggung hewan itu. ");
INSERT INTO indags_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Orang-orang mulai melepaskan jubah-jubah mereka ke atas jalan ketika Yesus lewat mengendarai keledai itu. ");
INSERT INTO indags_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ketika Yesus mendekati kota Yerusalem, tepat ketika jalan menurun dari Bukit Zaitun, rombongan murid-murid-Nya mulai menyerukan sorakan pujian kepada Allah sekeras mungkin untuk semua keajaiban yang sudah mereka lihat. ");
INSERT INTO indags_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Diberkatilah raja yang datang dalam nama Tuhan,” seru mereka. “Damai di surga dan kemuliaan di tempat yang paling tinggi.” ");
INSERT INTO indags_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Beberapa orang Farisi yang ada di antara kerumunan itu berkata kepada Yesus, “Guru, minta murid-murid-Mu untuk tidak berkata-kata seperti itu.” ");
INSERT INTO indags_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tetapi Yesus menjawab mereka, “Aku katakan kepada kalian, bahkan jika mulut mereka diam, batu-batu inilah yang akan bersorak!” ");
INSERT INTO indags_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Namun ketika Yesus semakin mendekati Yerusalem, menangislah Yesus ketika Dia melihat kota itu. ");
INSERT INTO indags_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Saya sangat berharap bahwa hari ini kalian, bahkan kalian, telah mengetahui jalan menuju perdamaian!” Dia berkata. “Tetapi sekarang hal itu tersembunyi dari kalian. ");
INSERT INTO indags_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Waktunya sudah hampir tiba atasmu ketika musuh-musuhmu akan mengepung kamu, membangun lereng untuk menyerang kamu, mengelilingi kamu dan mengepung kamu dari segala sisi. ");
INSERT INTO indags_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mereka akan menghancurkanmu ke atas tanah, baik kamu maupun anak-anakmu. Tidak akan dibiarkan ada satu batupun yang akan tumpah tindih dari reruntuhanmu, sebab kamu menolak menerima keselamatan ketika keselamatan itu datang kepadamu.” ");
INSERT INTO indags_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus lalu memasuki rumah Tuhan dan mulai mengusir semua pedagang yang ada di sana. ");
INSERT INTO indags_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kata-Nya kepada mereka, “Bukankah ada tertulis bahwa rumah-Ku akan menjadi Rumah doa, tetapi kalian sudah mengubahnya menjadi sarang pencuri.” ");
INSERT INTO indags_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus mengajar di rumah Tuhan setiap hari. Para imam kepala, pengajar-pengajar agama, dan para pemimpin orang Israel mencoba membunuh Dia. ");
INSERT INTO indags_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tetapi mereka tidak bisa menemukan cara untuk melakukannya, sebab setiap orang menghormati Yesus, percaya pada setiap perkataan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Suatu ketika saat Yesus sedang mengajar orang banyak di rumah Tuhan, menceritakan kepada mereka tentang Kabar Baik, beberapa imam kepala dan pengajar-pengajar agama datang bersama dengan para pemimpin Israel. ");
INSERT INTO indags_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Dan mereka bertanya kepada-Nya, “Beritahukan kepada kami, dengan otoritas siapa Engkau melakukan perbuatan-perbuatan ini? Siapa yang memberi-Mu hak untuk melakukan ini?” ");
INSERT INTO indags_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","“Jika begitu, biarkan Aku bertanya juga kepada kalian,” jawab Yesus. “Beritahu aku: ");
INSERT INTO indags_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","baptisan Yohanes — apakah itu berasal dari surga, atau itu hanya perbuatan manusia?” ");
INSERT INTO indags_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Maka mereka merundingkan jawaban untuk pertanyaan Yesus: “Jika kita katakan itu berasal dari surga, Dia akan bertanya, ‘Lalu mengapa kalian tidak percaya kepadanya?’ ");
INSERT INTO indags_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dan jika kita katakan berasal dari manusia, setiap orang akan menimpuki kita dengan batu sebab mereka yakin bahwa Yohanes adalah seorang nabi.” ");
INSERT INTO indags_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Maka jawab mereka kepada Yesus, “Kami tidak tahu dari mana asal baptisan Yohanes.” ");
INSERT INTO indags_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dan Yesus menjawab mereka, “Jika demikian, Aku juga tidak akan mengatakan dengan otoritas siapa Aku melakukan perbuatan-perbuatan ajaib.” ");
INSERT INTO indags_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lalu Yesus mulai menceritakan sebuah kisah: “Suatu ketika ada seseorang yang menanam kebun anggur, menyewakannya kepada beberapa orang petani, dan pergi tinggal di negara lain untuk sementara waktu. ");
INSERT INTO indags_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ketika tiba waktunya memanen, dia mengirim pekerjanya kepada para petani sewaan itu untuk mengambil hasil panen yang menjadi bagiannya, tetapi para petani itu memukuli pekerjanya dan mengirimnya pulang dengan tangan kosong. ");
INSERT INTO indags_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Maka si pemilik kebun mengirim pekerja yang lain, tetapi pekerja inipun mereka pukuli juga dan mempermalukan dia, lalu mengirimnya pulang dengan tangan kosong. ");
INSERT INTO indags_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lalu dikirimnya pekerja yang ketiga, tetapi mereka melukainya dan melemparkannya keluar.” ");
INSERT INTO indags_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Pemilik kebun itu berpikir, ‘Apa yang harus aku lakukan? Aku tahu, aku akan mengirimkan anak yang sangat aku sayangi, karena berpikir, mereka tentu akan menghormati anakku.’ ");
INSERT INTO indags_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Namun ketika para penyewa kebun itu melihat anak pemilik kebun yang datang, mereka berkata, ‘Ini si pewaris kebun ini. Mari kita bunuh dia! Dengan demikian kebun ini akan menjadi warisan kita.’ ");
INSERT INTO indags_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mereka lalu melemparkan anak itu keluar kebun anggur dan membunuhnya. Sekarang apa yang akan dilakukan oleh si pemilik kebuh kepada para penyewa ini? ");
INSERT INTO indags_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pastilah si pemilik ini akan datang dan membunuh para penyewa kebun anggurnya dan memberikannya kepada para penyewa lainnya.” Ketika mereka mendengar cerita ini, berkatalah mereka, “Semoga hal ini tidak pernah terjadi!” ");
INSERT INTO indags_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tetapi Yesus menatap mereka dan berkata, “Lalu mengapa tertulis dalam Kitab Suci, ‘Batu yang sudah ditolak oleh tukang bangunan sekarang menjadi batu penjuru’? ");
INSERT INTO indags_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dan siapapun yang jatuh ke atas batu itu akan jatuh berkeping-keping, dan ke atas siapa batu itu jatuh, maka orang itu akan hancur.” ");
INSERT INTO indags_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Segera sesudah para pengajar agama dan para imam kepala mendengar kisah itu, mereka ingin segera menangkap Yesus, sebab mereka menyadari bahwa kisah yang Yesus ceritakan tertuju kepada mereka, tetapi mereka takut kepada orang banyak itu. ");
INSERT INTO indags_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mereka menunggu kesempatan yang tepat untuk menangkap Yesus dengan mengirimkan mata-mata yang berpura-pura menjadi orang yang tulus. Mereka mencoba melawan Yesus dengan memakai perkataan-Nya sendiri agar mereka bisa menyerahkan Dia ke tangan kuasa dan otoritas gubernur setempat. ");
INSERT INTO indags_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kata mereka, “Guru, kami tahu bahwa Engkau selalu berkata tentang kebenaran dan mengajarkan pengajaran yang benar, dan Engkau tidak terombang-ambingkan dengan pendapat orang lain. Engkau sungguh-sungguh mengajar tentang jalan Allah. ");
INSERT INTO indags_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Haruskah kami membayar pajak kepada Kaisar?” ");
INSERT INTO indags_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tetapi Yesus melihat dengan jelas rancangan jahat mereka, dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Tunjukkan kepada-Ku uang logam yang kalian pakai untuk membayar pajak. Gambar dan ukiran wajah siapa yang ada pada koin ini?” “Kaisar,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Kalau begitu berikanlah kepada Kaisar segala yang memang hak Kaisar, dan berikanlah kepada Allah segala yang adalah hak Allah,” kata-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mereka tidak dapat menjerat Dia dengan apa yang Dia sampaikan kepada orang-orang. Mereka tertegun mendengar jawaban-Nya, dan terdiam. ");
INSERT INTO indags_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lalu datanglah beberapa orang Saduki, kelompok orang yang menolak adanya kebangkitan sesudah kematian, kepada Yesus dengan pertanyaan: ");
INSERT INTO indags_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru,” kata mereka, “Musa memberikan kami sebuah perintah bahwa jika seorang laki-laki menikah lalu meninggalkan istrinya tanpa anak, maka saudara laki-laki itu harus menikahi janda yang ditinggalkan dan memberikan keturunan untuk kakaknya yang sudah meninggal. ");
INSERT INTO indags_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bagaimana jika ada tujuh orang bersaudara. Yang sulung menikah, dan kemudian meninggal tanpa memiliki keturunan. ");
INSERT INTO indags_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yang kedua ");
INSERT INTO indags_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","dan yang ketiga juga menikahi janda yang pertama. Pada akhirnya ketujuh kakak beradik itu menikahi si perempuan, dan kemudian meninggal tanpa memiliki anak. ");
INSERT INTO indags_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Akhirnya yang perempuan meninggal juga. ");
INSERT INTO indags_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jika seperti ini, perempuan itu akan menjadi istri siapa pada masa kebangkitan, sebab semua laki-laki itu menikahi dia?” ");
INSERT INTO indags_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","“Di masa ini, orang-orang memang menikah dan dinikahkan,” Yesus menjelaskan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","“Tetapi mereka yang dianggap layak untuk berbagi di masa yang akan datang dan di masa kebangkitan tidaklah menikah ataupun dinikahkan. ");
INSERT INTO indags_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mereka tidak lagi bisa mati, mereka seperti malaikat dan menjadi anak-anak Allah sebab mereka adalah orang-orang yang dibangkitkan. ");
INSERT INTO indags_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tetapi pertanyaan tentang kebangkitan dari kematian, bahkan Musa membuktikan ini ketika dia menulis tentang semak yang terbakar, ketika dia menyebut Tuhan sebagai ‘Allah Abraham, Allah Isak, dan Allah Yakub.’ ");
INSERT INTO indags_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dia bukanlah Allah orang mati, melainkan Allah orang hidup, sebab bagi Dia mereka semua masih tetap hidup.” ");
INSERT INTO indags_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Beberapa pengajar agama menjawab, “Itu jawaban yang bagus, Guru.” ");
INSERT INTO indags_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sesudah itu tidak seorangpun berani bertanya lagi padanya. ");
INSERT INTO indags_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lalu bertanyalah Yesus kepada mereka, “Mengapa dikatakan bahwa Kristus itu keturunan Daud? ");
INSERT INTO indags_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sebab Daud sendiri berkata dalam kitab Mazmur: ‘Tuhan berkata kepada Tuanku: Duduklah di sebelah kanan-Ku ");
INSERT INTO indags_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampai Aku menempatkan semua musuh-Mu di bawah kaki-Mu.’ ");
INSERT INTO indags_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daud menyebut-Nya ‘Tuan,’ jadi bagaimana bisa Dia menjadi keturunannya Daud?” ");
INSERT INTO indags_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sementara banyak orang masih memperhatikan, berkatalah Yesus kepada murid-murid-Nya, ");
INSERT INTO indags_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Berhati-hatilah kepada para pengajar hukum taurat yang suka berkeliling dengan memakai jubah yang panjang, dan suka dihormati di pasar-pasar, dan suka duduk di tempat yang terhormat di rumah-rumah ibadah dan pesta-pesta. ");
INSERT INTO indags_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mereka menipu janda dari apa yang mereka miliki, dan menutupi orang seperti apa mereka sebenarnya dengan doa yang bertele-tele. Mereka akan menerima hukuman yang berat pada hari penghakiman nanti.” ");
INSERT INTO indags_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Melihat ke sekelilingnya, Yesus memperhatikan orang-orang kaya yang melemparkan uang logam mereka ke kotak persembahan. ");
INSERT INTO indags_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Lalu Yesus juga melihat seorang janda yang sangat miskin memasukkan dua keping uang logam yang bernilai sangat kecil. ");
INSERT INTO indags_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Sejujurnya Aku katakan kepada kalian,” kata Yesus, “Janda ini memberikan pesembahan lebih banyak dari jumlah seluruh persembahan dijadikan satu. ");
INSERT INTO indags_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Setiap mereka memberikan sebagian dari kekayaan mereka, tetapi dia memberi dari kemiskinannya semua yang dia miliki untuk hidupnya.” ");
INSERT INTO indags_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Beberapa dari murid-murid berbicara tentang kemegahan rumah Tuhan, keindahan pekerjaan bangunannya dan hadiah-hadiah indah yang sudah diberikan. Tetapi Yesus berkata, ");
INSERT INTO indags_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mengenai semua hal yang sedang kalian lihat ini. Waktunya sudah hampir tiba ketika tidak ada satu batu pun yang akan menumpuk di atas batu yang lain, segala sesuatunya akan dihancurkan!” ");
INSERT INTO indags_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Guru, kapankah hal itu akan terjadi?” tanya murid-murid kepada-Nya. “Apa tanda-tandanya bahwa segala sesuatu akan segera terjadi?” ");
INSERT INTO indags_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","“Pastikanlah kalian tidak tertipu,” kata Yesus memperingatkan mereka. “Banyak orang akan datang mengaku sebagai saya, mengatakan, ‘Ini saya!’ dan, ‘Waktunya telah tiba!’ tetapi jangan ikuti mereka. ");
INSERT INTO indags_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ketika kalian mendengar berita tentang peperangan dan pemberontakan, janganlah takut, sebab hal-hal itu haruslah terjadi lebih dahulu, tetapi masa akhir belumlah akan datang.” ");
INSERT INTO indags_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Bangsa akan berperang melawan bangsa, dan kerajaan akan berperang melawan kerajaan,” kata Yesus. ");
INSERT INTO indags_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Akan terjadi gempa bumi yang dahsyat, kelaparan, dan wabah penyakit di banyak negeri, juga tanda-tanda menyeramkan di langit. ");
INSERT INTO indags_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tetapi sebelum hal-hal ini terjadi, mereka akan menangkap kalian dan menganiaya kalian. Mereka akan menyeret kalian ke depan rumah-rumah ibadah dan memasukkan kalian ke dalam penjara, dan mengadili kalian di hadapan raja-raja dan gubernur-gubernur karena Aku. ");
INSERT INTO indags_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Namun hal ini akan memberikan kepada kalian kesempatan untuk berbicara sebagai perwakilan-Ku di hadapan mereka. ");
INSERT INTO indags_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jadi putuskanlah di dalam pikiranmu sebelumnya, untuk tidak kuatir bagaimana caramu membela diri, ");
INSERT INTO indags_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sebab Aku akan memberikan kata-kata bijaksana yang tidak bisa dibantah ataupun disanggah oleh lawan-lawanmu. ");
INSERT INTO indags_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kalian akan dikhianati bahkan oleh orang tua kalian, saudara-saudara sekandung, sanak keluarga, dan teman-teman kalian, dan beberapa akan membunuh kalian. ");
INSERT INTO indags_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dan setiap orang akan membenci kalian karena Aku. ");
INSERT INTO indags_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tetapi tidak satu helai rambutmu akan hilang. ");
INSERT INTO indags_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dengan tetap berdiri teguh pada pendirianmu, kalian menyelamatkan nyawa kalian. ");
INSERT INTO indags_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Namun, ketika kalian melihat Yerusalem sudah dikepung oleh banyak pasukan, maka kalian tahu bahwa kehancuran sudah semakin dekat. ");
INSERT INTO indags_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mereka yang tinggal di Yudea haruslah melarikan diri ke arah pegunungan, dan mereka yang tinggal di Yerusalem haruslah pergi, dan yang tinggal di pinggiran negeri janganlah masuk ke dalam kota. ");
INSERT INTO indags_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sebab hari-hari itu adalah hari penghukuman, unutk menggenapi semua yang sudah dituliskan sebelumnya. ");
INSERT INTO indags_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sungguh sulit bagi mereka yang sedang dalam kondisi hamil ataupun menyusui pada masa-masa itu! Sebab kesulitan yang mengerikan datang ke atas negeri dan hukuman atas orang-orang ini. ");
INSERT INTO indags_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mereka akan dibunuh oleh pedang dan diangkut sebagai tawanan ke seluruh bangsa. Yerusalem akan diinjak-injak oleh bangsa-bangsa asing sampai waktunya terpenuhi. ");
INSERT INTO indags_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Akan ada tanda-tanda pada matahari, bulan dan bintang-bintang, dan bangsa-bangsa di bumi akan tertekan, bingung akan laut yang bergelora dan menggelegar. ");
INSERT INTO indags_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Orang-orang akan pingsan ketakutan, ngeri tentang apa yang terjadi dengan dunia ini, sebab kuasa surga akan diguncangkan. ");
INSERT INTO indags_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lalu mereka akan melihat Anak Manusia datang dalam awan-awan dengan penuh kuasa dan kemuliaan yang besar. ");
INSERT INTO indags_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tetapi ketika peristiwa-peristiwa ini terjadi, berdirilah tegap dan menengadah, sebab itu tanda bahwa kalian akan segera diselamatkan.” ");
INSERT INTO indags_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lalu Yesus mengisahkan kepada mereka cerita ini. “Lihatlah pohon ara, ataupun pohon-pohon yang sejenis. ");
INSERT INTO indags_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ketika kalian melihat daun-daun yang baru bertunas, kalian langsung tahu bahwa musim panas sudah dekat. ");
INSERT INTO indags_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Demikian juga, ketika kalian melihat hal ini terjadi, kalian tidak perlu lagi diberi tahu bahwa Kerajaan Allah sudah dekat. ");
INSERT INTO indags_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aku katakan kepada kalian sesungguhnya, generasi ini tidak akan berakhir sebelum semua ini terjadi. ");
INSERT INTO indags_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Surga dan bumi akan berakhir, tetapi Firman-Ku adalah tetap untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Waspadalah sehingga perhatian kalian tidak dialihkan oleh pesta pora ataupun mabuk-mabukkan ataupun kesulitan di dunia ini, sehingga kalian menjadi terkejut ketika hari tiba. ");
INSERT INTO indags_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sebab hari ini akan dialami oleh semua orang yang hidup di permukaan bumi. ");
INSERT INTO indags_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Teruslah berjaga-jaga dan berdoalah, agar kalian mampu meloloskan diri dari semua yang akan terjadi dan tetap berdiri di hadapan Anak Manusia.” ");
INSERT INTO indags_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Setiap hari Yesus mengajar di rumah Tuhan, dan setiap sore Dia pergi dan menginap di Bukit Zaitun. ");
INSERT INTO indags_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Semua orang datang pada pagi hari ke rumah Tuhan untuk mendengarkan Dia. ");
INSERT INTO indags_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sudah waktunya Hari Raya Roti Tidak Beragi atau yang disebut juga Paskah. ");
INSERT INTO indags_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Para Imam kepala dan pengajar-pengajar Hukum Taurat sedang mencari cara untuk membunuh Yesus, tetapi takut akan reaksi orang banyak. ");
INSERT INTO indags_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Setan masuk ke dalam Yudas, bermarga Iskariot, salah satu dari dua belas murid. ");
INSERT INTO indags_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dia pergi dan berbicara dengan para imam kepala dan petugas penjaga tentang cara dia bisa mengkhianati Yesus. ");
INSERT INTO indags_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Para mereka sangat bersukacita dan menawari dia sejumlah uang. ");
INSERT INTO indags_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas setuju, dan mulai mencari sebuah kesempatan untuk menyerahkan Yesus ketika kerumunan orang tidak ada di sana. ");
INSERT INTO indags_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hari Raya Roti Tidak Beragi tiba ketika domba Paskah harus dikorbankan. ");
INSERT INTO indags_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Maka Yesus mengirim Petrus dan Yohanes, memberitahu mereka, “Pergilah dan siapkanlah perjamuan Paskah, agar kita bisa makan bersama.” ");
INSERT INTO indags_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Dimana Guru ingin kita menyiapkan semua itu?” tanya Yesus. ");
INSERT INTO indags_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jawab-Nya, “Ketika kalian masuk ke dalam kota, kalian akan bertemu seorang laki-laki yang sedang membawa sebuah kendi berisi air. Ikutilah dia dan masuklah ke dalam rumah yang dia masuki. ");
INSERT INTO indags_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Katakan kepada pemilik rumah, ‘Guru bertanya: Dimanakah ruang makan agar Aku bisa makan perjamuan paskah dengan murid-murid-Ku?’ ");
INSERT INTO indags_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dan orang itu akan memperlihatkan kepada kalian ruangan atas yang besar yang sudah ada perabotan yang lengkap. Siapkanlah perjamuan itu di sana.” ");
INSERT INTO indags_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pergilah kedua murid itu dan menemukan segala sesuatu yang sudah dikatakan Yesus kepada mereka, dan mereka menyiapkan perjamuan Paskah di sana. ");
INSERT INTO indags_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ketika waktunya tiba, duduklah Yesus bersama dengan rasul-rasul-Nya. Katanya, ");
INSERT INTO indags_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","“Aku sungguh-sungguh menantikan perjamuan Paskah ini bersama kalian sebelum masa penderitaan-Ku dimulai. ");
INSERT INTO indags_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Aku beritahu kalian bahwa Aku tidak akan makan perjamuan ini lagi sampai tiba waktunya digenapi dalam Kerajaan Allah.” ");
INSERT INTO indags_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lalu Yesus mengangkat cangkirnya, dan sesudah mengucap syukur, Dia berkata, “Ambillah ini dan bagikanlah. ");
INSERT INTO indags_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aku beritahu kalian, bahwa Aku tidak akan meminumnya lagi air anggur itu sampai Kerajaan Allah datang.” ");
INSERT INTO indags_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Lalu Yesus mengambil roti, dan sesudah mengucap syukur, dia memisah-misahkan roti itu menjadi potongan-potongan kecil dan memberikannya kepada mereka. “Roti ini melambangkan tubuh-Ku yang diberikan untuk kalian, lakukanlah ini untuk mengingat tentang Aku,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dengan cara yang sama sesudah mereka selesai makan, Yesus mengangkat cangkir dan berkata, “Cangkir ini menjadi sebuah kesepakatan baru dalam darah-Ku yang akan mencurahkan demi kalian.” ");
INSERT INTO indags_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Meskipun demikian, orang yang akan mengkhianati Aku duduk bersama-Ku pada perjamuan ini. ");
INSERT INTO indags_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sebab sudah ditentukan bahwa Anak Manusia pasti akan mati, tetapi sungguh betapa buruknya itu bagi orang yang mengkhianati Dia!” ");
INSERT INTO indags_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mereka mulai berdebat di antara mereka sendiri tentang siapa ini dan siapa yang bisa melakukan ini. ");
INSERT INTO indags_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pada saat yang sama, mereka juga bertengkar di antara mereka tentang siapa di antara mereka yang paling penting. ");
INSERT INTO indags_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus berkata kepada mereka, “Raja-raja bangsa-bangsa lain menindas rakyatnya, dan bahkan mereka yang punya otoritas ingin orang-orang memanggil mereka ‘penolong.’ ");
INSERT INTO indags_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tetapi tidaklah demikian dengan kalian! Siapapun yang paling penting di antara kalian haruslah menjadi yang paling tidak penting, dan sang pemimpin haruslah menjadi seperti pelayan. ");
INSERT INTO indags_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Siapakah yang paling hebat — mereka yang duduk pada meja atau mereka yang melayani? Bukankah dia yang duduk pada meja? Tetapi Aku ada bersama dengan kalian sebagai salah seorang yang melayani. ");
INSERT INTO indags_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kalian sudah bersama-Ku menghadapi melalui setiap ujian yang Aku hadapi. ");
INSERT INTO indags_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dan Aku memberi kalian otoritas untuk memerintah, sama seperti yang diberikan Bapa di Surga kepadaku, ");
INSERT INTO indags_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","agar kalian boleh ikut serta dalam perjamuan yang akan diadakan dalam Kerajaan-Ku, dan duduk di atas tahta menghakimi ke dua belas suku Israel.” ");
INSERT INTO indags_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon — Setan sudah minta agar bisa memiliki kalian seperti menyaring gandum, ");
INSERT INTO indags_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","tetapi Aku sudah berdoa agar kamu dalam rasa percayamu kepada-Ku tidak gagal. Dan ketika kamu sudah kembali ke kebenaran itu, berilah semangat kepada saudara-saudaramu.” ");
INSERT INTO indags_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrus berkata, “Tuhan, saya siap untuk masuk penjara bersama dengan Engkau, dan untuk mati bersama dengan Engkau!” ");
INSERT INTO indags_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tetapi Yesus menjawab, “Sejujurnya Aku katakan kepadamu, Petrus, sebelum ayam jantan berkokok hari ini, kamu sudah akan mengatakan kepada orang lain bahwa kamu tidak mengenal Aku sebanyak tiga kali.” ");
INSERT INTO indags_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bertanyalah Yesus kepada murid-murid-Nya, “Ketika Aku mengirim kalian tanpa membawa uang, tas, bahkan sandal untuk berganti, apakah kalian ada yang mengalami kekurangan?” “Tidak, kami tidak kekurangan apa-apa,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Tetapi sekarang, dengarkan ini, jika kalian punya uang, bawalah bersama dengan kalian, demikian juga tas. Bahkan jika kalian tidak punya pedang, maka juallah jubahmu untuk bisa membeli sebuah pedang. ");
INSERT INTO indags_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sejujurnya Aku katakan kepada kalian bahwa kalimat di dalam Hukum Taurat tentang Aku haruslah digenapi: ‘Dia akan terhitung bersama orang-orang jahat.’ Tulisan tentang Aku sekarang mulai digenapi.” ");
INSERT INTO indags_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Tuhan, lihat, di sini sudah ada dua pedang,” kata mereka. “Cukuplah,” jawab-Nya. ");
INSERT INTO indags_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus lalu berangkat ke Bukit Zaitun seperti biasa bersama-sama dengan para murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ketika tiba di situ, berkatalah Dia kepada mereka, “Berdoalah agar kalian tidka jatuh ke dalam pencobaan.” ");
INSERT INTO indags_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lalu menyingkirlah Yesus dari antara mereka dan maju kira-kira satu lemparan batu jauhnya, di mana Dia berlutut dan berdoa. ");
INSERT INTO indags_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bapa,” kata-Nya, “jika Engkau ingin, tolong ambillah penderitaan ini dari-Ku. Tetapi Aku ingin melakukan apa yang menjadi keinginan-Mu, bukan keinginan-Ku.” ");
INSERT INTO indags_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lalu ada malaikat yang menampakkan diri di hadapan Yesus untuk menguatkan Dia. ");
INSERT INTO indags_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dalam penderitaan yang mengerikan, Yesus bahkan berdoa lebih keras lagi, sehingga keringatnya seakan-akan seperti tetesan darah yang jatuh ke atas tanah. ");
INSERT INTO indags_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sesudah Yesus selesai berdoa, Dia berdiri, dan pergi kepada para rasulnya. Dia menemukan mereka sudah tertidur, lelah karena kesedihan. ");
INSERT INTO indags_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Mengapa kalian tidur?” tanya-Nya kepada mereka. “Bangun dan berdoalah agar kalian tidak jatuh ke dalam pencobaan.” ");
INSERT INTO indags_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sementara Yesus masih berbicara, ada segerombolan orang datang yang dipimpin oleh Yudas, salah seorang dari dua belas rasul. Yudas menghampiri Yesus untuk memberi salam dengan cara mencium Dia. ");
INSERT INTO indags_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tetapi Yesus bertanya kepadanya, “Yudas, apakah kamu mengkhianati Anak Manusia dengan sebuah ciuman?” ");
INSERT INTO indags_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pengikut Yesus lainnya bertanya, “Tuhan, apakah kami harus menyerang mereka dengan pedang kami?” ");
INSERT INTO indags_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Salah satu dari mereka menyerang pelayan iman besar, memotong telinga bagian sebelah kanan. ");
INSERT INTO indags_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","“Hentikan! Cukup sampai disini!” kata Yesus. Lalu Dia menyentuh telinga orang itu dan menyembuhkan dia. ");
INSERT INTO indags_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lalu Yesus berbicara kepada para imam kepala, dan petugas penjaga rumah Tuhan serta para pemimpin. “Apakah Aku seperti seorang penjahat sehingga kalian datang dengan pedang dan tongkat?” tanya-Nya. ");
INSERT INTO indags_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","“Kalian tidak pernah menangkap Aku sebelumnya, sekalipun Aku bersama-sama dengan kalian di rumah Tuhan setiap hari. Tetapi ini adalah momenmu sekarang, ketika kegelapan sedang berkuasa.” ");
INSERT INTO indags_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mereka lalu menangkap Dia dan membawa Dia ke rumah imam kepala. Dan Petrus mengikuti dari jarak jauh. ");
INSERT INTO indags_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mereka menyalakan api unggun di tengah-tengah halaman dan duduk di situ. Petrus duduk di antara mereka. ");
INSERT INTO indags_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ketika dia sedang duduk di sana, seorang gadis pelayan menyadari dia dalam terang api unggun, dan menatapnya langsung serta berkata, ");
INSERT INTO indags_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","“Orang ini bersama-sama dengan Orang itu.” Tetapi Petrus menyangkalinya. “Hai perempuan, saya tidak mengenal Dia!” katanya. ");
INSERT INTO indags_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Beberapa waktu kemudian seseorang lainnya melihat Petrus dan berkata, “Kamu juga salah seorang dari mereka.” “Tidak, bukan!” jawab Petrus. ");
INSERT INTO indags_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sekitar satu jam kemudian, ada orang lain yang berkata, “Aku yakin dia bersama dengan-Nya juga — dia seorang Galilea.” ");
INSERT INTO indags_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Aku tidak mengerti apa maksudmu!” jawab Petrus. Seketika itu juga, sementara Petrus masih berkata-kata, ayam jantan berkokok. Tuhan berpaling dan menatap Petrus. ");
INSERT INTO indags_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dan Petrus teringat akan perkataan Yesus, “Sebelum ayam berkokok hari ini, kamu sudah akan menyangkal Aku tiga kali.” ");
INSERT INTO indags_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petrus keluar dan menangis dengan sangat sedih. ");
INSERT INTO indags_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Para penjaga Yesus mulai mengejek dan memukuli Dia. ");
INSERT INTO indags_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mereka membuat penutup mata dan bertanya, “Jika Engkau bisa bernubuat, beritahu kami, siapa yang memukul-Mu saat itu!” ");
INSERT INTO indags_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","dan menghina dengan sebutan-sebutan lain. ");
INSERT INTO indags_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Keesokan paginya, para pemimpin bangsa Israel berkumpul bersama para imam kepala dan pengajar-pengajar hukum Taurat. Yesus diadili di hadapan mereka. ");
INSERT INTO indags_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Jika Engkau sungguh-sungguh Mesias, beritahukan kami.” “Sekalipun Aku mengatakannya kepada kalian, kalian tidak akan mempercayai Aku,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“Dan jika Aku bertanya pertanyaan kepada kalian, kalianpun tidak akan menjawab. ");
INSERT INTO indags_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tetapi mulai dari sekarang Anak Manusia akan duduk di sebelah kanan Allah yang Mahakuasa.” ");
INSERT INTO indags_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mereka semua bertanya, “Jadi Engkau ini Anak Allah?” “Kalianlah yang mengatakannya,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Kita sudah tidak memerlukan saksi!” kata mereka. “Kita mendengarnya dari mulut-Nya sendiri!” ");
INSERT INTO indags_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Seluruh anggota sidang itu bangkit dan membawa Yesus kepada Pilatus. ");
INSERT INTO indags_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mereka mulai menyampaikan tuduhan mereka. “Kami temukan bahwa Orang ini menipu bangsa kita, mengatakan bahwa orang-orang tidak harus membayar pajak kepada Kaisar, dan menyatakan bahwa diri-Nya adalah Mesias, sang raja,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","“Apakah Engkau Raja orang Yahudi?” tanya Pilatus kepada Yesus. “Seperti perkataanmu,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lalu Pilatus berkata kepada para imam kepala dan kerumunan orang itu, “Saya tidak menemukan orang ini bersalah atas kejahatan apa pun.” ");
INSERT INTO indags_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tetapi mereka tetap memaksa, katanya, “Dia menghasut orang-orang di seluruh Yudea untuk memberontak dengan pengajaran-Nya, mulai dari Galilea sampai ke Yerusalem.” ");
INSERT INTO indags_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ketika Pilatus mendengar hal ini, bertanyalah dia, “Apakah orang ini orang Galilea?” ");
INSERT INTO indags_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ketika Pilatus mengetahui bahwa Yesus ada di bawah wilayah kekuasaan Raja Herodes, maka dikirimnya Yesus kepada Herodes yang saat itu juga sedang ada di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes sangat senang sebab dia akhirnya bisa bertemu dengan Yesus, sebab dia sudah sangat menanti-nantikan hal ini sejak lama. Herodes sudah lama mendengar tentang Yesus dan berharap untuk bisa melihat Yesus melakukan suatu perbuatan ajaib. ");
INSERT INTO indags_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dia memberikan banyak pertanyaan kepada Yesus, tetapi Yesus tidak memberikan satu jawabanpun kepadanya. ");
INSERT INTO indags_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Para imam kepala dan pengajar hukum taurat berdiri di sana, dengan marah melemparkan tuduhan kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes dan para prajuritnya mengejek dan menghina Yesus. Mengenakan jubah kerajaan kepada-Nya dan mengirim-Nya kembali kepada Pilatus. ");
INSERT INTO indags_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sejak hari itu Herodes dan Pilatus menjadi sahabat — sebab sebelumnya mereka saling bermusuhan. ");
INSERT INTO indags_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus memanggil seluruh imam kepala, penguasa-penguasa dan masyarakat, ");
INSERT INTO indags_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","dan memberitahu mereka, “Kalian membawa orang ini ke hadapanku, menuduh Dia menghasut orang-orang untuk memberontak. Aku sudah memeriksa-Nya dengan teliti di hadapan kalian, dan tidak menemukan Dia bersalah atas tuduhan yang kalian sampaikan. ");
INSERT INTO indags_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Demikian juga Herodes, sebab dia mengirim Yesus kembali kepada kita. Yesus tidak melakukan perbuatan apapun yang membuat Dia layak menerima hukuman mati. ");
INSERT INTO indags_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jadi aku hanya akan memerintahkan agar Yesus menerima hukuman cambuk dan melepaskan dia.” ");
INSERT INTO indags_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tetapi mereka semua berteriak, “Bunuh orang ini, dan lepaskan saja Barabas untuk kami.” ");
INSERT INTO indags_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas telah dimasukkan ke dalam penjara karena ikut serta dalam pemberontakan di kota, dan karena pembunuhan.) ");
INSERT INTO indags_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus ingin membebaskan Yesus, jadi dia berbicara lagi kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tetapi mereka terus berteriak, “Salibkan Dia! Salibkan Dia!” ");
INSERT INTO indags_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus bertanya kepada mereka untuk ketiga kalinya, “Tetapi kenapa? Kejahatan apa yang sudah Dia lakukan? Aku tidak menemukan alasan apapun untuk menghukum mati Dia. Jadi aku hanya akan minta agar Dia dicambuk dan lalu melepaskan Dia.” ");
INSERT INTO indags_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tetapi mereka terus memaksa dengan suara keras, meminta agar Yesus disalibkan. Suara teriakan mereka begitu keras, ");
INSERT INTO indags_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","dan Pilatus mengabulkan permintaan mereka. ");
INSERT INTO indags_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dia membebaskan tawanan yang dipenjara karena pemberontakan dan pembunuhan, dan mengirim Yesus untuk di hukum mati sesuai dengan tuntutan mereka. ");
INSERT INTO indags_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ketika para prajurit membawa Yesus pergi, mereka menangkap seorang laki-laki yang berasal dari Kirene bernama Simon. Mereka memaksanya untuk membawakan salib Yesus. ");
INSERT INTO indags_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gerombolan besar orang mengikuti Dia, bersama dengan para perempuan yang menangisi dan meratapi penderitaan-Nya. ");
INSERT INTO indags_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dan Yesus berpaling kepada mereka serta berkata, “Hai, perempuan-perempuan Yerusalem, janganlah menangis karena Aku. Menangislah karena diri kalian dan anak-anak kalian. ");
INSERT INTO indags_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sebab sudah dekat waktunya ketika mereka akan berkata, ‘Diberkatilah mereka yang tidak memiliki anak, dan yang tidak pernah melahirkan, dan mereka yang tidak pernah menyusui.’ ");
INSERT INTO indags_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mereka aakn berkata kepada pegunungan, ‘Jatuhlah menimpa kami,’ dan kepada perbukitan, ‘Tutupilah kami.’ ");
INSERT INTO indags_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sebab jika mereka melakukan hal ini pohon yang masih muda, apa yang terjadi kepada pohon itu jika ia sudah menjadi tua?” ");
INSERT INTO indags_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mereka juga membawa serta dua orang yang akan dihukum mati bersama-sama dengan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ketika mereka tiba di tempat yang disebut Tengkorak, mereka menyalibkan Yesus bersama-sama dengan para penjahat, satu di sebelah kanan-Nya, dan yang lain di sebelah kiri-Nya. ");
INSERT INTO indags_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lalu Yesus berkata, “Bapa, tolong maafkan mereka, sebab mereka tidak tahu apa yang mereka lakukan.” Lalu mereka melemparkan undian untuk mendapatkan pakaian-Nya. ");
INSERT INTO indags_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Orang-orang berdiri dan memperhatikan sementara para pemimpin menatap Yesus dengan sinis. “Orang lain Dia selamatkan, biarkan Dia menyelamatkan diri-Nya sendiri, jika Dia memang benar-benar Mesias, Yang Terpilih,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Para prajurit mengolok-olok Dia, mendatangi dan menawari-Nya cuka anggur, dan berkata, ");
INSERT INTO indags_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Jika Engkau Raja orang Yahudi, maka selamatkanlah diri-Mu.” ");
INSERT INTO indags_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di atas kepala Yesus ada tulisan yang berbunyi, “Inilah Raja orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Salah seorang penjahat yang tergantung di salib juga menghina Yesus. “Bukankah Engkau Mesias?” tanyanya. “Kalau begitu selamatkanlah diri-Mu — dan juga kami!” ");
INSERT INTO indags_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tetapi penjahat yang satu tidak setuju dan berdebat dengan sesamanya, “Tidakkah kamu punya rasa hormat kepada Allah sekalipun kamu menderita hukuman yang sama?” tanyanya. ");
INSERT INTO indags_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","“Hukuman yang kita terima sudah layak sebab kita dihukum sesuai dengan perbuatan kita, tetapi Orang ini tidak melakukan kejahatan apapun.” ");
INSERT INTO indags_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lalu dia berkata, “Yesus, tolong ingat aku ketika Engkau masuk ke dalam kerajaan-Mu.” ");
INSERT INTO indags_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus menjawab, “Aku berjanji kepadamu hari ini kamu akan ada bersama-Ku dalam kerajaan-Ku.” ");
INSERT INTO indags_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Saat itu waktu sudah sekitar tengah hari, tiba-tiba kegelapan menutupi seluruh wilayah itu sampai pukul tiga sore. ");
INSERT INTO indags_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Matahari berhenti bersinar, dan horden di Rumah Allah robek menjadi dua. ");
INSERT INTO indags_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lalu Yesus berseru dengan suara keras, “Bapa, ke dalam tangan-Mu Aku serahkan diri-Ku.” Sesudah selesai mengatakan ini, Yesus menghembuskan napas terakhirnya. ");
INSERT INTO indags_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ketika kepala pasukan melihat kejadian yang baru saja berlangsung, dia memuji Allah dan berkata, “Orang ini pastilah tidak bersalah.” ");
INSERT INTO indags_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ketika semua orang banyak yang datang untuk menonton melihat apa yang terjadi, mereka pulang sambil memukuli dada mereka dengan sedih. ");
INSERT INTO indags_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tetapi mereka yang mengenal Yesus, termasuk para perempuan yang mengikuti Dia dari Galilea, memperhatikan dari jarak jauh. ");
INSERT INTO indags_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Di situ ada seorang laki-laki bernama Yusuf yang adalah seorang yang baik dan jujur. Dia juga salah seorang anggota sidang jemaat Yahudi, ");
INSERT INTO indags_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","tetapi dia tidak sepakat dengan keputusan dan tindakan mereka. Dia datang dari kota Arimatea di daerah Yudea, dan sedang menantikan datangnya Kerajaan Allah. ");
INSERT INTO indags_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusuf pergi menemui Pilatus dan meminta ijin untuk mengambil tubuh Yesus. ");
INSERT INTO indags_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ketika dia sudah menurunkannya, Yusuf membungkusnya dengan kain lenan, dan membaringkan Yesus dalam sebuah kuburan dari batu yang belum pernah dipakai. ");
INSERT INTO indags_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hari itu adalah hari persiapan menjelang hari Sabat. ");
INSERT INTO indags_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Para perempuan yang datang bersama Yesus dari Galilea sudah mengikuti Yusuf dan sudah melihat kuburan tempat tubuh Yesus dibaringkan. ");
INSERT INTO indags_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mereka pulang dan menyiapkan rempah dan balsam untuk mengurapi tubuh Yesus. Tetapi pada hari Sabat mereka beristirahat, mengikuti perintah. ");
INSERT INTO indags_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ketika hari masih subuh, pada hari pertama minggu itu, para perempuan pergi ke kuburan Yesus, membawa rempah-rempah yang sudah mereka siapkan. ");
INSERT INTO indags_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mereka temukan bawa batu penutup kubur sudah terguling dari bagian pintu masuk kubur, ");
INSERT INTO indags_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tetapi ketika mereka masuk ke dalam kubur Yesus, mereka tidak menemukan tubuh Tuhan. ");
INSERT INTO indags_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sementara mereka sedang bingung, dua orang laki-laki tiba-tiba muncul di hadapan mereka mengenakan pakaian yang bersinar sangat terang. ");
INSERT INTO indags_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Para perempuan itu sangat ketakutan dan bersujud, wajah mereka menyentuh tanah. Kata mereka kepada para perempuan ini, “Mengapa kalian mencari orang yang hidup di antara orang mati? ");
INSERT INTO indags_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dia tidak ada di sini, Dia sudah bangkit dari antara orang mati! Ingatlah yang dikatakan-Nya sementara kalian masih di Galilea: ");
INSERT INTO indags_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Anak Manusia haruslah dikhianati dan diserahkan ke tangan orang-orang jahat, disalibkan, dan pada hari yang ketiga akan bangkit kembali.’” ");
INSERT INTO indags_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lalu teringatlah mereka akan perkataan Yesus. ");
INSERT INTO indags_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ketika mereka kembali dari kuburan itu, para perempuan ini menceritakan semua yang sudah terjadi kepada kesebelas rasul dan semua yang ada di sana. ");
INSERT INTO indags_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mereka yang memberitahukan kisah ini kepada para rasul adalah Maria Magdalena, Yohana, Maria ibu Yakobus, dan juga perempuan-perempuan lain yang bersama mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tetapi kisah ini terdengar tidak masuk di akal oleh para rasul, sehingga mereka tidak mempercayai para perempuan ini. ");
INSERT INTO indags_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Namun demikian Petrus berdiri dan berlari ke arah kubur. Membungkuk, dia melihat ke dalam dan hanya melihat kain linen kuburan. Jadi dia kembali ke rumah, bertanya-tanya apa yang terjadi. ");
INSERT INTO indags_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pada hari yang sama, dua orang murid sedang dalam perjalanan menuju ke desa Emaus, sekitar sebelas kilometer dari kota Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mereka sedang membicarakan segala sesuatu yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ketika mereka sedang berdiskusi dan berdebat, Yesus datang dan melangkah bersama dengan mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tetapi mereka tidak dapat mengenali Dia. ");
INSERT INTO indags_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","“Apa yang sedang kalian diskusikan sepanjang perjalanan?” tanya-Nya kepada mereka. Kedua murid itu menghentikan langkah mereka, wajah mereka tampak sedih. ");
INSERT INTO indags_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Salah seorang dari mereka yang bernama Kleopas berkata, “Apakah kamu baru saja datang ke Yerusalem? Kamu pastilah satu-satunya orang yang tidak tahu segala kejadian yang baru saja terjadi akhir-akhir ini.” ");
INSERT INTO indags_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Kejadian apa?” kata Yesus. “Tentang Yesus dari Nazaret,” jawab mereka. “Dia adalah seorang nabi yang berbicara dengan penuh kuasa dan melakukan banyak perbuatan ajabi di hadapan Allah dan manusia. ");
INSERT INTO indags_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tetapi para imam besar dan pemimpin kami menyerahkan Dia agar dihukum mati, dan mereka menyalibkan Dia. ");
INSERT INTO indags_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kita sudah berharap bahwa Dialah yang akan menyelamatkan bangsa Israel. Sudah tiga hari berlalu sejak semua hal ini terjadi.” ");
INSERT INTO indags_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Tetapi lalu beberapa perempuan dari kelompok kami mengejutkan kami. ");
INSERT INTO indags_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ketika subuh, mereka berangkat ke kuburan dan tidak menemukan tubuh-Nya. Mereka kembali dan berkata mereka mendapat penglihatan tentang para malaikat yang memberitahu mereka bahwa Yesus hidup. ");
INSERT INTO indags_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Beberapa dari kami pergi ke kuburan, dan menemukan seperti yang dikatakan para perempuan itu — tetapi mereka tidak melihat Dia.” ");
INSERT INTO indags_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesus berkata kepada mereka, “Pikiran kalian dangkal sekali! Mengapa kalian sangat lambat untuk percaya semua yang sudah ditulis oleh para nabi?! ");
INSERT INTO indags_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bukankah Mesias harus menderita sebelum Dia bisa masuk ke dalam kemuliaan-Nya?” ");
INSERT INTO indags_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesus mulai menjelaskan kepada mereka, mulai dari kitab yang ditulis oleh Musa sampai semua kitab yang ditulis oleh para nabi, segala hal yang dituliskan oleh Kitab Suci tentang diri-Nya sendiri. ");
INSERT INTO indags_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ketika mereka tiba di desa tempat tujuan, Yesus berbuat seolah-olah Dia akan melanjutkan perjalanan. ");
INSERT INTO indags_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tetapi mereka mendesak Dia, dan berkata, “Mari datang dan bergabung dengan kami. Ini sudah malam — hari sudah hampir berakhir.” Maka tinggallah Yesus bersama mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ketika Yesus duduk untuk makan bersama mereka, Dia mengambil roti, membelahnya, dan memberikannya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mata mereka terbuka, dan mereka mengenalinya. Kemudian dia menghilang dari pandangan. ");
INSERT INTO indags_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kedua murid itu saling berkata, “Bukankah pikiran kita terbakar ketika dia berbicara kepada kita, saat dia menjelaskan Kitab Suci kepada kita?” ");
INSERT INTO indags_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mereka segera bangun dan kembali ke Yerusalem. Di sana mereka menemukan sebelas rasul dan juga semua orang yang sedang berkumpul bersama, ");
INSERT INTO indags_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","yang berkata, “Tuhan sudah benar-benar bangkit! Dia muncul di hadapan Simon.” ");
INSERT INTO indags_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lalu kedua murid yang baru tiba itu menjelaskan kepada para murid yang sedang berkumpul tentang apa yang baru saja mereka alami dalam perjalanan, dan bagaimana mereka mengenali Yesus ketika Dia membagi-bagikan roti. ");
INSERT INTO indags_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sementara mereka masih berbicara, Yesus sendiri yang menunjukkan diri kepada mereka, dan berkata, “Damai bagi kalian!” ");
INSERT INTO indags_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mereka tertegun dan ketakutan, berpikir kalau yang mereka lihat adalah hantu. ");
INSERT INTO indags_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","“Mengapa kalian takut? Mengapa kalian ragu?” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Lihatlah tangan dan kaki-Ku — kalian bisa melihat ini Aku. Sentuhlah Aku agar kalian yakin, sebab hantu tidak memiliki daging dan tulang, sementara Aku punya.” ");
INSERT INTO indags_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sesudah mengatakan ini, Yesus memperlihatkan tangan dan kaki-Nya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tetapi mereka masih sulit mempercayainya, sebab mereka begitu gembira dan kagum. Kata-Nya kepada mereka, “Adakah sesuatu yang bisa Aku makan?” ");
INSERT INTO indags_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dan mereka memberinya sepotong ikan yang sudah dimasak, ");
INSERT INTO indags_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","dan Yesus mengambil serta memakannya di hadapan mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lalu Yesus berkata kepada mereka, “Inilah yang Aku jelaskan kepada kalian ketika Aku masih bersama dengan kalian. Segala yang tertulis tentang Aku di hukum Taurat, kitab para nabi, dan kitab Mazmur, haruslah digenapi.” ");
INSERT INTO indags_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kemudian Ia membuka pikiran mereka sehingga mereka dapat memahami Kitab Suci. ");
INSERT INTO indags_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kata-Nya kepada mereka, “Demikian tertulis seperti ini: Mesias akan menderita dan bangkit dari antara orang mati pada hari yang ke tiga, dan dalam nama-Nya ");
INSERT INTO indags_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","pertobatan akan pengampunan dosa akan diberitakan kepada segala bangsa, dimulai dari Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kalian adalah saksi dari semua ini. ");
INSERT INTO indags_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sekarang Aku akan mengirimkan kepadamu apa yang dijanjikan Bapa-Ku — tetapi tunggulah di kota ini sampai kalian menerima kuasa dari surga.” ");
INSERT INTO indags_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lalu Yesus memimpin mereka keluar sampai mereka tiba di dekat kota Betania, dan dengan mengangkat tangan-Nya, Dia memberkati mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sementara Dia memberkati mereka, Dia terangkat ke surga dan meninggalkan mereka. ");
INSERT INTO indags_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mereka menyembah Dia, dan kemudian dengan penuh sukacita mereka kembali ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mereka menghabiskan waktu mereka di rumah Tuhan memuji Allah. ");
INSERT INTO indags_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pada mulanya Firman itu adalah. Firman itu bersama-sama dengan Allah, dan Firman itu adalah Allah. ");
INSERT INTO indags_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dari permulaan, Dia bersama Allah. ");
INSERT INTO indags_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Allah menciptakan segala sesuatu melalui Dia; tidak ada satu pun yang diciptakan tanpa Firman. ");
INSERT INTO indags_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Di dalam Firman ada kuasa yang memberi hidup kepada semua ciptaan-Nya, dan hidup yang menjadi terang bagi setiap orang. ");
INSERT INTO indags_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cahaya bersinar dalam kegelapan, dan kegelapan tidak memadamkannya. ");
INSERT INTO indags_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Allah mengutus seorang bernama Yohanes. ");
INSERT INTO indags_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohanes datang sebagai saksi untuk memberitakan tentang Terang itu agar semua orang menjadi percaya melalui Dia. ");
INSERT INTO indags_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanes sendiri bukanlah Terang itu, tetapi dia datang untuk memberitakan tentang Terang itu kepada manusia. ");
INSERT INTO indags_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Terang yang sesungguhnya sedang datang ke dunia untuk memberikan cahaya kepada semua orang. ");
INSERT INTO indags_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Firman itu sudah ada di dunia, dan meskipun dunia diciptakan melalui Dia, tetapi dunia tidak tahu siapa Dia. ");
INSERT INTO indags_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dia datang kepada bangsanya pilihan-Nya sendiri, tetapi mereka tidak menerima-Nya. ");
INSERT INTO indags_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tetapi kepada semua orang yang menerima-Nya dan percaya pada-Nya, Dia memberikan hak untuk menjadi anak-anak Allah. ");
INSERT INTO indags_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mereka adalah anak-anak yang lahir bukan dengan cara biasa, dan bukan karena keinginan manusia atau keputusan seorang laki-laki, tetapi mereka lahir dari Allah. ");
INSERT INTO indags_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Firman menjadi manusia dan tinggal di antara kita, dan kita melihat kemuliaan-Nya, kemuliaan Anak tunggal Bapa, penuh kasih karunia dan kebenaran. ");
INSERT INTO indags_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes memberikan kesaksiannya tentang Firman itu, dengan suara keras dia berkata kepada orang-orang, “Inilah Dia yang saya ceritakan kepada kalian ketika saya berkata, ‘Dia yang datang sesudah saya lebih penting daripada saya, karena sebelum saya ada Dia sudah ada.’” ");
INSERT INTO indags_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kita semua sudah menerima sifat kemurahan hati-Nya, yang terus-menerus bertambah dalam hidup kita. ");
INSERT INTO indags_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Allah memberikan Hukum melalui Musa; tetapi belas kasihan dan kebenaran datang melalui Yesus Kristus. ");
INSERT INTO indags_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Meskipun tidak ada yang pernah melihat Allah, Allah yang satu-satunya, yang dekat kepada Bapa, telah menunjukkan kepada kita seperti apa Allah itu. ");
INSERT INTO indags_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Inilah yang dikatakan Yohanes secara terbuka ketika para pemimpin Yahudi mengirim para imam dan orang Lewi dari Yerusalem untuk bertanya kepada-Nya, “Siapa kamu?” ");
INSERT INTO indags_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanes menyatakan dengan jelas dan mengaku, “Saya bukanlah Mesias.” ");
INSERT INTO indags_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Jadi, siapa kamu?” mereka bertanya. “Apakah kamu pengganti nabi Elia?” “Bukan, saya bukan Elia,” jawabnya. “Apakah kamu sang Nabi?” “Bukan,” jawabnya. ");
INSERT INTO indags_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Kalau begitu, siapa kamu?” mereka bertanya. “Kami harus memberikan jawaban kepada mereka yang menyuruh kami datang kepadamu. Apa yang kamu katakan tentang dirimu?” ");
INSERT INTO indags_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","“Saya adalah suara yang berseru-seru di padang gurun, ‘Persiapkanlah jalan untuk Tuhan!’” seperti yang dikatakan nabi Yesaya. ");
INSERT INTO indags_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Para imam dan orang Lewi diutus oleh orang-orang Farisi ");
INSERT INTO indags_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","untuk bertanya kepadanya, “Lalu mengapa kamu membaptis orang, jika kamu bukan Mesias, atau Elia, atau Nabi?” ");
INSERT INTO indags_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kemudian Yohanes menjawab, “Saya membaptis dengan air, tetapi Seorang yang berdiri di tengah-tengah kamu adalah seseorang yang belum kamu kenal. ");
INSERT INTO indags_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dia adalah Orang yang datang sesudah saya. Saya tidak pantas untuk melayani Dia, bahkan sekalipun hanya untuk melepaskan sandal-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Semua ini terjadi di Betania di seberang Sungai Yordan, tempat Yohanes membaptis. ");
INSERT INTO indags_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Keesokan harinya Yohanes melihat Yesus datang kepadanya. Lalu berkatalah Yohanes kepada orang-orang yang ada di situ, “Lihat, Anak Domba Allah, yang menghapus dosa manusia di dunia ini! ");
INSERT INTO indags_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Inilah yang saya maksudkan ketika saya berkata, ‘Seorang yang datang sesudah saya lebih penting daripada saya, karena sebelum saya ada Dia sudah ada.’ ");
INSERT INTO indags_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Saya sendiri tidak tahu siapa dia, tapi saya datang membaptis dengan air agar dia bisa diwahyukan ke Israel.” ");
INSERT INTO indags_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanes menjelaskan tentang Dia, dan berkata, “Saya melihat Roh Kudus turun dari surga seperti burung merpati dan hinggap di atas Dia. ");
INSERT INTO indags_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Saya tidak akan mengenalnya kecuali Dia yang mengirim saya untuk membaptis dengan air sudah mengatakan kepada saya, ‘Orang yang kamu lihat Roh Kudus turun dan hinggap di atas-Nya, Dialah yang akan membaptis dengan Roh Kudus.’ ");
INSERT INTO indags_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Saya melihat itu terjadi dan saya menyatakan bahwa ini adalah Anak Allah.” ");
INSERT INTO indags_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Keesokan harinya Yohanes Pembaptis berdiri lagi di tempat itu bersama dua muridnya. ");
INSERT INTO indags_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Waktu dia melihat Yesus lewat, dan berkata, “Lihat! Ini adalah Anak Domba Allah!” ");
INSERT INTO indags_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ketika kedua murid itu mendengar apa yang dia katakan, mereka pergi dan mengikuti Yesus. ");
INSERT INTO indags_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesus berbalik dan melihat mereka mengikuti Dia, “Apa yang kalian cari?” tanya-Nya kepada mereka, “Rabi (yang artinya ‘Guru’), dimanakah Guru tinggal?” jawab mereka dengan pertanyaan. ");
INSERT INTO indags_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Mari ikut,” kata-Nya kepada mereka. Maka mereka mengikuti Dia menuju tempat tinggalnya. Hari itu menjelang pukul 4 sore, dan mereka menghabiskan sisa hari bersama dengan Dia. ");
INSERT INTO indags_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andreas, saudara dari Simon Petrus, adalah satu dari dua orang murid yang sudah mendengar perkataan Yohanes Pembaptis dan mengikuti Yesus. ");
INSERT INTO indags_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dia segera menemui saudaranya Simon dan berkata, “Kami sudah bertemu dengan Mesias!” (yang artinya “Kristus atau Yang diurapi”). ");
INSERT INTO indags_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas membawa Simon menemui Yesus. Menatap langsung kepada Simon, Yesus berkata, “Kamu Simon, anak Yohanes. Tetapi sekarang kamu akan dipanggil dengan nama Kefas atau Petrus.” (Kedua nama ini memiliki arti “batu”). ");
INSERT INTO indags_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Keesokan harinya Yesus memutuskan untuk pergi ke Galilea. Yesus bertemu dengan Filipus di sana, dan berkata kepadanya, “Ikutlah Aku.” ");
INSERT INTO indags_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus berasal dari kota Betsaida, kota yang sama dengan asal Andreas dan Petrus. ");
INSERT INTO indags_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus mencari Natanael dan berkata kepadanya, “Kami bertemu dengan Dia yang Musa tulis di dalam hukum Taurat dan yang ditulis oleh para nabi juga — Yesus dari Nazaret, anak Yusuf.” ");
INSERT INTO indags_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Dari kota Nazaret?! Mana pernah ada seseorang yang baik berasal dari kota itu?” kata Natanael. “Datang dan lihatlah sendiri,” jawab Filipus. ");
INSERT INTO indags_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus melihat Natanael mendekat, dan kata-Nya tentang Natanael, “Lihat, inilah orang Israel sejati! Tidak ada yang palsu tentang dia.” ");
INSERT INTO indags_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Bagaimana Bapa bisa tahu tentang saya?” tanya Natanael. “Aku melihat kamu di bawa pohon ara, sebelum Filipus memanggil kamu,” jawab Yesus. ");
INSERT INTO indags_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Guru, Engkau sungguh Anak Allah, raja Israel!” Natanael berseru. ");
INSERT INTO indags_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“Kamu percaya hanya karena Aku berkata Aku melihat kamu di bawah pohon ara?” jawab Yesus. “Kamu akan melihat lebih banyak hal lagi dibandingkan itu!” ");
INSERT INTO indags_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lalu Yesus berkata, “Aku berkata kepada kalian, kalian semua akan melihat surga terbuka, dan malaikat Allah naik dan turun atas Anak Manusia.” ");
INSERT INTO indags_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dua hari kemudian, ada pesta perkawinan di desa Kana, di daerah Galilea. ");
INSERT INTO indags_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus dan murid-muridnya juga hadir di sana karena mereka juga diundang. ");
INSERT INTO indags_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Saat pesta perkawinan sedang berlangsung, persediaan minuman anggur habis, jadi ibu Yesus berkata kepada-Nya, “Mereka kehabisan anggur.” ");
INSERT INTO indags_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jawab Yesus, “Mengapa hal itu menjadi urusan ibu dan saya? Waktuku belum tiba.” ");
INSERT INTO indags_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ibunya berkata kepada pelayan-pelayan yang ada di situ, “Lakukanlah apa saja yang Dia katakan padamu.” ");
INSERT INTO indags_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Di tempat itu ada enam tempat toples penyimpanan air yang terbuat dari batu. Air yang ditampung di situ biasanya dipakai untuk mencuci tangan dan kaki mereka, sesuai dengan adat Yahudi. Masing-masing toples penyimpanan air itu bisa menampung sekitar 75 sampai dengan 115 liter. ");
INSERT INTO indags_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus berkata kepada pelayan-pelayan, “Isilah air ke dalam setiap toples penyimpanan air itu sampai penuh.” ");
INSERT INTO indags_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lalu Dia berkata kepada mereka, “Timbahlah beberapa dan berilah kepada pengurus pesta.” Pelayan-pelayan itu melakukan sesuai dengan apa yang Yesus katakan. ");
INSERT INTO indags_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bahwa pengurus pesta acara tidak tahu dari mana asalnya, hanya pelayan-pelayan saja yang tahu. Tetapi ketika dia mencicipi air yang telah berubah menjadi anggur, dia memanggil mempelai laki-laki. ");
INSERT INTO indags_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Orang lain biasanya menyajikan minum anggur terbaik pada awal pesta,” katanya. “Lalu sesudah tamu undangan sudah banyak minum barulah dia mengeluarkan air anggur yang biasa. Tetapi kamu menyimpan air anggur terbaik untuk dikeluarkan paling akhir.” ");
INSERT INTO indags_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Apa yang terjadi di desa Kana, di daerah Galilea merupakan kali pertama Yesus melakukan keajaiban. Di sini Ia menyatakan kemuliaan-Nya, dan murid-murid-Nya menaruh kepercayaan mereka kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sesudah itu, Yesus pergi ke Kapernaum untuk beberapa hari bersama ibunya, saudara-saudaranya dan jua murid-muridnya. ");
INSERT INTO indags_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tiba waktunya untuk orang Yahudi merayakan hari keagamaan yang disebut Paskah, jadi Yesus pergi ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Di rumah Allah, Yesus mendapatkan orang-orang yang sedang berjualan lembu, domba dan burung merpati. Di sana juga ada orang-orang penukar uang yang sedang duduk. ");
INSERT INTO indags_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesus membuat cambuk dari beberapa potong tali, dan mengusir orang-orang itu bersama dengan domba dan lembu mereka, dan membalikkan meja-meja orang-orang penukar uang sampai uang-uang koin mereka terhambur ke mana-mana. ");
INSERT INTO indags_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dan Dia berkata kepada penjual-penjual burung merpati, “Keluarkanlah semua burung ini dari sini. Jangan jadikan Rumah Bapa-ku ini seperti pasar!” ");
INSERT INTO indags_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Murid-muridnya ingat Kitab Suci yang mengatakan, “Pengabdianku untuk rumahmu seperti api yang menyala-nyala di dalam diriku!” ");
INSERT INTO indags_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pemimpin-pemimpin Yahudi menentang Yesus, “Hak apa yang kamu miliki untuk melakukan ini? Tunjukkan pada kami beberapa tanda ajaib untuk membuktikannya!” ");
INSERT INTO indags_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jawab Yesus, “Hancurkanlah rumah Allah ini dan Aku akan membangunnya kembali dalam tiga hari saja!” ");
INSERT INTO indags_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Apa?” jawab mereka, “Memakan waktu empat puluh enam tahun untuk membangun rumah Allah ini, dan kamu bilang akan membangunnya kembali hanya dalam tiga hari!” ");
INSERT INTO indags_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tetapi yang Yesus maksudkan dengan rumah Allah adalah tubuh-Nya sendiri. ");
INSERT INTO indags_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Di kemudian hari, saat Yesus hidup kembali dari kematian, barulah murid-murid-Nya mengingat kembali apa yang dikatakan-Nya itu. Murid-muridnya benar-benar percaya dengan apa yang dikatakan dalam Kitab Suci dan juga apa yang dikatakan Yesus. ");
INSERT INTO indags_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ketika Yesus berada di Yerusalem selama perayaan Paskah, banyak orang menjadi percaya kepada-Nya, karena mereka melihat keajaiban-keajaibanyang dilakukan Yesus. ");
INSERT INTO indags_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Walaupun demikian, karena Yesus sudah mengetahui sifat manusia yang sebenarnya, Dia tetap menjaga jarak dengan mereka. ");
INSERT INTO indags_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dia tidak membutuhkan siapa pun untuk memberitahunya tentang sifat manusia karena Dia tahu cara orang berpikir. ");
INSERT INTO indags_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ada seorang dari kelompok agama Yahudi yang disebut Farisi bernama Nikodemus. Dia juga salah satu dari pemimpin mereka. ");
INSERT INTO indags_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pada suatu malam, dia pergi bertemu Yesus dan berkata, “Guru, kami tahu engkau adalah seorang guru yang diutus oleh Allah, karena tidak ada seorang pun yang bisa melakukan keajaiban-keajaiban seperti yang engkalu lakukan kecuali Allah bersamanya.” ");
INSERT INTO indags_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jawab Yesus kepadanya, “Dengan sungguh-sungguh Aku berkata kepadamu, tidak ada yang bisa melihat kerajaan Allah kalau dia tidak dilahirkan kembali.” ");
INSERT INTO indags_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus lalu bertanya, “Mana mungkin ada orang yang bisa dilahirkan lagi kalau dia sudah dewasa? Mana mungkin dia bisa masuk kembali ke dalam kandungan ibunya lalu dilahirkan lagi!” ");
INSERT INTO indags_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus kembali menjawab, “Engkau tidak dapat masuk ke dalam kerajaan Allah kecuali engkau dilahirkan dari air dan Roh. ");
INSERT INTO indags_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Manusia hanya bisa dilahirkan oleh orang tua secara jasmani, tetapi secara rohani, manusia harus dilahirkan oleh Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Oleh karena itu, jangan merasa heran kalau Aku berkata, ‘Kalian semua harus dilahirkan kembali.’ ");
INSERT INTO indags_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hanya Roh Kudus yang memberi hidup baru. Roh Kudus seperti angin yang bertiup ke arah mana saja yang diinginkan. Kita hanya bisa mendengar bunyinya, tetapi tidak tahu angin itu datang dari mana, atau angin itu mau pergi ke mana. Seperti itu cara Roh Kudus bekerja dalam hati manusia.” ");
INSERT INTO indags_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Bagaimana mungkin hal-hal itu bisa terjadi?” tanya Nikodemus. ");
INSERT INTO indags_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jawab Yesus, “Engkau adalah seorang guru agama yang dihormati di Israel, namun engkau sendiri tidak mengerti hal-hal ini? ");
INSERT INTO indags_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Dengan sungguh-sungguh aku berkata kepadamu, kami mengajar tentang hal-hal yang sudah kami tahu. Kami pun bersaksi tentang apa yang sudah kami lihat, tetapi kalian tidak mau terima kesaksian kami. ");
INSERT INTO indags_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kalau kalian tidak percaya ketika Aku mengajar tentang hal-hal yang terjadi di bumi, bagaimana bisa kalian percaya ketika Aku mengajar mengenai hal-hal yang terjadi di surga? ");
INSERT INTO indags_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tidak ada seorang pun yang naik ke surga, tetapi Anak Manusia turun dari surga. ");
INSERT INTO indags_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sama seperti Musa mengangkat ular di padang gurun, demikian juga Anak Manusia harus ditinggikan, ");
INSERT INTO indags_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sehingga setiap orang yang percaya padanya akan memiliki hidup yang kekal. ");
INSERT INTO indags_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Karena Allah mencintai dunia, dan begini caranya: Dia memberikan Anak satu-satu-Nya, supaya masing-masing orang yang percaya kepada Anak-Nya, tidak akan mati, tetapi akan menerima hidup untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Allah tidak mengirim Anak ke dunia untuk menghukum dunia, tetapi untuk menyelamatkan dunia melalui Dia. ");
INSERT INTO indags_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mereka yang percaya kepada-Nya tidak dihukum, sedangkan mereka yang tidak percaya kepada-Nya sudah dihukum karena mereka tidak percaya kepada Anak Allah yang tunggal. ");
INSERT INTO indags_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Beginilah keputusan dibuat: terang datang ke dunia, tetapi orang-orang lebih menyukai kegelapan daripada terang, karena tindakan mereka jahat. ");
INSERT INTO indags_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Semua orang yang melakukan hal-hal jahat membenci terang, dan mereka tidak akan pernah datang kepada terang itu. Terang itu akan memperlihatkan semua perbuatan mereka yang jahat. ");
INSERT INTO indags_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tetapi bagi setiap orang yang hidup dengan benar akan datang kepada terang, sehingga apa yang Allah capai di dalam mereka dapat dinyatakan.” ");
INSERT INTO indags_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sesudah hal itu terjadi, Yesus bersama murid-murid-Nya pergi ke daerah Yudea. Di sana Dia tinggal bersama mereka untuk beberapa waktu dan Dia membaptiskan orang di sana. ");
INSERT INTO indags_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pada waktu itu, Yohanes Pembaptis sedang membaptiskan orang-orang di Ainon, dekat Salem, karena di tempat itu ada banyak air. ");
INSERT INTO indags_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ini terjadi sebelum dia dipenjara.) ");
INSERT INTO indags_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pada suatu waktu, ada orang-orang yang mulai bertengkar dengan murid-murid Yohanes tentang syarat-syarat pembersihan diri sesuai dengan adat Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jadi, mereka pergi untuk bertemu Yohanes sambil berkata, “Guru, orang yang bersama-sama denganmu di seberang Sungai Yordan, orang yang pernah engkau bicara tentang dia — saat ini dia sedang membaptis orang-orang dan hampir semua orang pergi kepadanya.” ");
INSERT INTO indags_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jawab Yohanes kepada mereka, “Tidak ada yang menerima apa pun kecuali mereka diberikan dari surga. ");
INSERT INTO indags_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kalian sendiri sudah mendengar ketika saya berkata, ‘Saya bukan Mesias yang sudah dijanjikan itu. Saya dikirim Allah hanya untuk menyiapkan jalan untuk Dia.’ ");
INSERT INTO indags_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pengantin wanita milik mempelai pria. Saya sama seperti sahabat dari seorang pengantin laki-laki. Saya berdiri sambil menunggu pengantin laki-laki itu datang. Sahabat dari pengantin laki-laki sangat bahagia saat dia mendengar suara pengantin laki-laki saat dia tiba — dengan cara yang sama kebahagiaan saya sekarang lengkap. ");
INSERT INTO indags_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dia harus menjadi lebih terkenal, dan saya harus menjadi semakin tidak terkenal.” ");
INSERT INTO indags_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dia yang datang dari atas lebih besar dari semuanya; dia yang datang dari bumi adalah milik bumi dan berbicara tentang hal-hal duniawi. Dia yang datang dari surga lebih besar dari semuanya. ");
INSERT INTO indags_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Dia membagikan tentang hal-hal yang sudah Dia lihat dan dengar di surga, tetapi tidak banyak orang yang bisa terima apa yang Dia sampaikan itu. ");
INSERT INTO indags_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tetapi bagi mereka yang bisa terima apa yang Dia sampaikan itu mengakui bahwa Dia bisa dipercaya karena dia datang dari Allah. ");
INSERT INTO indags_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kita tahu bahwa apa yang disampaikan itu adalah benar, karena Dia dikirim Allah ke dalam dunia ini sesungguhnya menyampaikan ajaran dari Allah sendiri. Sudah jelas bahwa Allah sudah memberikan Roh-Nya sepenuhnya kepada Dia. ");
INSERT INTO indags_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Allah Bapa mengasihi Anak-Nya dan sudah serahkan segala sesuatu kepada Dia. ");
INSERT INTO indags_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Siapa pun yang percaya kepada Anak memiliki hidup yang kekal, tetapi siapa pun yang menolak untuk percaya kepada Anak tidak akan mengalami hidup yang kekal tetapi tetap berada di bawah penghukuman Allah. ");
INSERT INTO indags_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ketika Yesus menyadari bahwa orang-orang Farisi telah mengetahui bahwa Ia memperoleh dan membaptis lebih banyak murid daripada Yohanes, ");
INSERT INTO indags_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(sebenarnya Yesus sendiri tidak yang membaptis mereka, tetapi murid-muridnya yang melakukan hal itu), ");
INSERT INTO indags_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Dia tinggalkan Yudea dan kembali ke Galilea. ");
INSERT INTO indags_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dalam perjalanannya ke sana Yesus harus melewati daerah Samaria. ");
INSERT INTO indags_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Di Samaria, Yesus dan murid-muridnya sampai di sebuah kota bernama Sikar yang berada di dekat tanah yang dulu diberikan Yakub kepada anaknya, Yusuf. ");
INSERT INTO indags_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sumur Yakub berada di sana. Yesus merasa lelah karena perjalanannya jauh, jadi dia duduk di pinggir sumur itu. Waktu itu sekitar jam dua belas siang. ");
INSERT INTO indags_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lalu ada seorang perempuan Samaria yang datang ke sumur itu untuk menimba air. Yesus berkata kepadanya, “Bisa tolong berikan Aku air untuk minum.” ");
INSERT INTO indags_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Murid-muridnya sedang ke kota untuk membeli makanan.) ");
INSERT INTO indags_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Perempuan itu menjawab, “Bukankah engkau adalah orang Yahudi? Saya adalah orang Samaria, jadi bagaimana mungkin engkau meminta aku memberimu air untuk minum?” (Karena orang Yahudi jangan bergaul dengan orang Samaria.) ");
INSERT INTO indags_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jawab Yesus, “Kalau saja engkau tahu, hadiah apa yang Allah mau berikan kepadamu, dan kalau saja engkau mengenal siapa yang meminta air darimu, engkau pasti akan minta air hidup kepada Aku, dan Aku akan memberikannya kepadamu.” ");
INSERT INTO indags_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kata perempuan itu, “Bapak tidak mempunyai timba. Sumur ini sangat dalam. Dari maka Bapak bisa mendapatkan air hidup itu? ");
INSERT INTO indags_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apakah Bapak lebih besar daripada nenek moyang kami, Yakub? Bagaimana Bapak bisa menawarkan air yang lebih baik daripada air ini yang dulu sudah Yakub, anak-anaknya dan juga semua ternaknya nikmati dari sumur ini?” ");
INSERT INTO indags_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jawab Yesus, “Setiap orang yang minum air sumur ini pasti akan menjadi haus lagi. ");
INSERT INTO indags_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tetapi bagi siapa saja yang minum air yang Aku berikan, untuk selama-lamanya mereka tidak akan pernah merasa haus. Air yang Aku berikan itu akan menjadi seperti mata air dari dalam diri mereka sendiri, dan akan mengalis terus menerus dan memberikan hidup untuk selama-lamanya.” ");
INSERT INTO indags_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Perempuan itu berkata, “Bapak, berikanlah air itu kepada saya, supaya saya tidak merasa haus lagi dan tidak perlu kembali untuk menimba air di sini.” ");
INSERT INTO indags_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus lalu berkata kepadanya, “Pergilah, panggilah suamimu dan bawalah dia kembali ke sini.” ");
INSERT INTO indags_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jawab perempuan itu, “Saya tidak mempunyai suami.” Kata Yesus kepadanya, “Memang betul apa yang Ibu jawab. Ibu memang tidak mempunyai suami ");
INSERT INTO indags_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","karena Ibu sudah kawin lima kali dengan laki-laki yang berbeda-beda. Saat ini laki-laki yang hidup bersamamu juga bukanlah suamimu.” ");
INSERT INTO indags_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Perempuan itu pun menjawab, “Bapak, saya menyadari bahwa Bapak adalah seorang nabi. ");
INSERT INTO indags_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nenek moyang kami menyembah di gunung ini, tetapi mengapa kalian orang Yahudi mengatakan bahwa orang hanya bisa menyembah Allah di Yerusalem?” ");
INSERT INTO indags_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jawab Yesus, “Percayalah waktunya akan datang ketika kalian tidak akan menyembah Bapa baik di gunung ini atau di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kalian orang Samaria memang menyembah Allah, tetapi sebenarnya tidak mengenal-Nya. Tetapi kami orang Yahudi tahu bahwa kami menyembah Allah, karena keselamatan datang dari orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tetapi waktunyaakan tiba, dan sebenarnya sudah tiba saat ini ketika orang-orang yang sembah dengan sungguh-sungguh akan menyembah dia dengan persatuan dengan Roh Kudus, dan sesuai dengan ajaran benar yang dari Allah. Allah menginginkan orang-orang yang sungguh-sungguh menyembah Dia. ");
INSERT INTO indags_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Karena Allah adalah Roh, jadi setiap orang yang mau menyembah dia harus dengan cara mempersatukan diri dengan Roh Kudus dan sesuai dengan ajaran benar yang dari Allah.” ");
INSERT INTO indags_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Perempuan itu berkata, “Saya sudah tahu bahwa Mesias, yaitu Kristus akan datang. Ketika Dia datang Dia akan menjelaskan semuanya kepada kita.” ");
INSERT INTO indags_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus lalu menjawabnya, “Aku, yang sedang berbicara denganmu, adalah Mesias.” ");
INSERT INTO indags_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Murid-murid Yesus pada saat iu tiba. Mereka merasa heran melihat Yesus seang berbicara engan seorang perempuan, tetapi tidak satupun dari mereka bertanya “Apa yang Engkau lakukan?” atau “Mengapa Engkau berbicara dengannya?” ");
INSERT INTO indags_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Perempuan itu meninggalkan tempat airnya yang terbuat dari tanah liat, dan kembali ke kotanya sambil memberitahu semua orang, ");
INSERT INTO indags_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ayo, ketemulah dengan seseorang yang sudah memberitahukan sayasemua yang pernah saya lakukan. Apakah benar dia itu Mesias?” ");
INSERT INTO indags_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jadi orang-orang itu meninggalkan kota mereka dan pergi menemui Yesus. ");
INSERT INTO indags_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sementara itu, murid-murid Yesus mengajak-Nya makan. ");
INSERT INTO indags_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Tidak,” jawabnya, “Aku mempunyai makanan yang kalian tidak tahu.” ");
INSERT INTO indags_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Murid-muridnya bertanya satu sama yang lain, “Apakah ada orang yang sudah membawa makanan untuk Dia?” ");
INSERT INTO indags_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jawab Yesus, “Makanan-Ku itu adalah melakukan apa yang menjadi kehendak Allah! Dialah yang sudah mengutus Aku, dan Aku harus menyelesaikan pekerjaan yang sudah Dia serahkan kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bukankah kalian mengatakan ‘ada empat bulan sampai panen’? Bukalah mata kalian dan lihat sekeliling dan kalian akan menemukan panaman di ladang sudah matang dan siap panen. ");
INSERT INTO indags_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bahkan pada saat ini, para pekerja ladang sedang menerima imbalan merek dengan memanen apa yang memberikan hidup untuk selama-lamanya. Oleh karena itu, semua orang yang sudah menanam benih dan semua orang yang sudah memanen akan merayakannya bersama-sama. ");
INSERT INTO indags_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jadi perkataan yang biasa kami dengarkan ini adalah benar: ‘Ada orang yang bertugas menanam, dan ada juga yang bertugas untuk memanen.’ ");
INSERT INTO indags_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aku menyuruh kalian untuk memanen hasil di ladang-Ku, di mana sebelumnya orang lain sudah melakukan pekerjaan berat. Saat ini kalian tinggal menerima keuntungan dari pekerjaan mereka.” ");
INSERT INTO indags_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Banyak orang Samaria di kota itu sudah percaya kepada Yesus karena perempuan itu sudah katakan, “Orang ini sudah memberitahu saya semua yang pernah saya lakukan.” ");
INSERT INTO indags_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mereka datang kepada-Nya, dan meminta Dia untuk tinggal bersama mereka, jadi Dia tinggal di sana selama dua hari. ");
INSERT INTO indags_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lebih banyak lagi orang Samaria menjadi percaya kepada Yesus karena mereka sendiri mendengar apa yang Dia ajarkan. ");
INSERT INTO indags_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mereka berkata kepada perempuan itu, “Kami tidaklagi percaya kepada Yesus hanya berdasarkan apa yang sudah kamu katakan. Kamu sudah mendengar sendiri, dan kami yakin bahwa Dia benar-benar adalah Raja Penyelamat manusia.” ");
INSERT INTO indags_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sesudah tinggal selama dua hari di Sikar, Yesus melanjutkan perjalanan ke Galilea bersama murid-murid-Nya. ");
INSERT INTO indags_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sebelumnya Yesus sendiri pernah mengatakan bahwa seorang nabi biasanya tidak dihormati di negerinya sendiri, ");
INSERT INTO indags_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","tetapi ketika dia tiba di Galilea, banyak orang menyambut Dia dengan baik. Mereka sebelumnya sudah menghadiri perayaan keagamaan di Yerusalem dan sudah melihat semua yang Dia lakukan di sana. ");
INSERT INTO indags_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Saat berada di Galilea, Dia kembali ke desa Kana, tempat di mana Dia mengubah air menjadi anggur. Ada seorang pejabat raja yang tinggal di kota Kapernaum, yang berjarak tidak terlalu jauh dari desa itu. Anak laki-laki pejabat itu sedang sakit, ");
INSERT INTO indags_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","dan hampir mati. Ketika pejabat itu mendengar bahwa Yesus sedang berkunjung ke Galilea dari Yudea dia pergi menemui Yesus di Kana dan memohon kepadanya, “Tolong datang dan sembuhkanlah anak saya. Dia hampir mati!” ");
INSERT INTO indags_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus berkata kepadanya, “Kecuali jika kalian melihat tanda-tanda dan keajaiban, kalian orang-orang tidak akan percaya kepada saya.” ");
INSERT INTO indags_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pejabat itu berkata, “Bapak, ikutlah denganku sekarang, sebelum anak saya meninggal.” ");
INSERT INTO indags_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jawab Yesus, “Pulanglah, anakmu sudah sembuh!” Orang itu percaya kepada Yesus, dan dia pulang. ");
INSERT INTO indags_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Saat dia masih dalam perjalanan pulang, ada beberapa orang pelayannya yang menyambut dia dengan berita yang gembira, bahwa anaknya sudah sembuh! ");
INSERT INTO indags_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dia bertanya kepada mereka, “Jam berapa dia sembuh?” Jawab mereka, “Kemarin sore, sekitar jam satu siang, demamnya tiba-tiba menghilang!” ");
INSERT INTO indags_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lalu dia teringat kembali, bahwa pada saat itulah, Yesus berkata, “Anakmu sudah sembuh.” Pejabat itu dan semua yang tinggal bersama dia menjadi percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Itulah hal ajaib kedua yang Yesus lakukan di Galilea sesudah kembali dari Yudea. ");
INSERT INTO indags_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Waktu pun berlalu, dan Yesus pergi ke Yerusalem untuk mengikuti salah satu perayaan orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Di dekat pintu gerbang kota Yerusalem yang diberi nama Gerbang Domba, ada sebuah kolam yang disebut Betesda (dalam bahasa Ibrani). Di sebelah kolam itu ada lima teras yang beratap. ");
INSERT INTO indags_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kerumunan orang sakit berbohong di teras-teras ini — mereka yang buta, lumpuh, atau lumpuh. ");
INSERT INTO indags_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Salah satu orang yang terbaring di situ sudah menderita sakit selama tiga puluh delapan tahun. ");
INSERT INTO indags_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus melihat dia terbaring di situ dan menyadari bahwa dia sudah menderita sakit untuk waktu yang lama. Yesus berkata kepaa orang itu, “Apakah kamu mau sembuh?” ");
INSERT INTO indags_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Orang itu menjawab, “Saya tidak memiliki siapa-siapa untuk mengangkat saya ke dalam kolam ketika air digoncangkan. Saya sudah berusaha, tetapi selalu saja orang lain yang lebih dulu.” ");
INSERT INTO indags_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus berkata kepadanya, “Berdirilah! Angkatlah tikarmu dan berjalanlah!” ");
INSERT INTO indags_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saat itu juga, orang itu sembuh! Dia mengangkat tikarnya dan berjalan. Kejadian ajaib ini terjadi pada hari Sabat. ");
INSERT INTO indags_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ketika pemimpin-pemimpin Yahudi melihat orang itu mengangkat tikarnya, mereka berkata kepada dia, “Inilah hari Sabat! Tidak ada seorang pun yang boleh mengangkat tikar pada hari ini.” ");
INSERT INTO indags_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tetapi orang yang baru saja disembuhkan kepada mereka, “Tetapi orang yang menyembuhkan saya menyuruh untuk mengangkat tikar saya dan berjalan!” ");
INSERT INTO indags_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mereka bertanya, “Siapakah orang yang menyuruh kamu mengangkat tikarmu dan berjalan?” ");
INSERT INTO indags_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tetapi dia tidak mengenal siapa orang itu, karena Yesus sudah menghilang diantara banyak orang. ");
INSERT INTO indags_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sesudah itu, Yesus bertemu dengan orang itu di rumah Allah dan berkata kepada dia, “Sekarang kamu sudah sembuh. Berhentilah berbuat dosa kalau tidak akan hal yang lebih parah menimpa kamu.” ");
INSERT INTO indags_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Orang itu pergi dan memberitahu pemimpin-pemimpin Yahudi bahwa orang yang menyembuhkannya adalah Yesus. ");
INSERT INTO indags_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jadi mereka mulai melecehkan Yesus karena Dia sudah melakukan keajaiban ajaib pada hari Sabat. ");
INSERT INTO indags_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tetapi yesus berkata kepada mereka, “Ayah saya masih bekerja, begitu juga saya.” ");
INSERT INTO indags_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Inilah sebabnya mengapa orang-orang Yahudi berusaha lebih keras untuk membunuh-Nya, karena Dia tidak hanya melanggar hari Sabat tetapi juga menyebut Allah sebagai Bapa-Nya, membuat diri-Nya setara dengan Allah. ");
INSERT INTO indags_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus menjawab mereka, “Aku berkata yang sebenarnya. Aku, Anak Manusia tidak bisa melakukan apa-apa atas kuasa Aku sendiri. Aku hanya bisa melakukan apa yang saya melihat Bapa-Ku lakukan. Apa yang Bapa, itu juga yang dilakukan oleh Anak. ");
INSERT INTO indags_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Karena Bapa mengasihi Anak, Dia menunjukkan kepada-Nya segala sesuatu yang Dia lakukan. Bapa juga menunjukkan kepada-Nya hal-hal yang lebih besar, supaya kalian menjadi heran. ");
INSERT INTO indags_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bahkan Aku akan membangkitkan dari antara orang mati siapa saja yang Aku mau sama seperti apa yang dilakukan oleh Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bapa tidak menghakimi siapa-siapa. Dia telah memberikan kepada Anak semua otoritas untuk menghakimi, ");
INSERT INTO indags_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","supaya semua orang menghormati Anak sama seperti mereka menghormati Bapa. Tetapi jika kalian menolak untuk menghormati Anak, maka sudah pasti kalian juga tidak menghormati Bapa yang suah mengutusa Anak ke dalam dunia ini. ");
INSERT INTO indags_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Dengan tegas Aku katakan kepada kalian, bahwa apa yang Aku katakan ini adalah benar. Setiap orang yang mengikuti apa yang Aku katakan dan yang percaya kepada Bapa yang sudah mengutus Aku, mereka akan memiliki hidup untuk selama-lamanya. Mereka tidak akan dihukum, tetapi telah pergi dari kematian ke kehidupan. ");
INSERT INTO indags_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Aku tegaskan kepada kalian, bahwa apa yang Aku katakan ini adalah benar. Waktunya akan tiba — bahkan sudah tiba — ketika orang mati akan mendengar suara Anak Allah, dan mereka yang mendengar akan hidup! ");
INSERT INTO indags_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sama seperti Bapa memiliki kuasa yang memberi hidup dalam diri-Nya, demikian pula Dia telah memberikan kepada Anak kuasa yang sama yang memberi hidup di dalam diri-Nya. ");
INSERT INTO indags_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bapa juga memberikan otoritas untuk penghakiman kepadanya, karena dia adalah Anak manusia. ");
INSERT INTO indags_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jangan heran! Akan tiba saatnya di mana semua orang yang sudah mati yang sudah ada dalam kubur akan mendengar suara-Nya ");
INSERT INTO indags_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dan akan bangkit kembali: mereka yang telah berbuat baik untuk kebangkitan kehidupan, dan mereka yang telah melakukan kejahatan untuk kebangkitan penghukuman. ");
INSERT INTO indags_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aku tidak bisa melakukan apa-apa sendiri. Saya menilai berdasarkan apa yang saya diberitahu, dan keputusan saya benar, karena saya tidak melakukan kehendak saya sendiri tetapi kehendak orang yang mengutus saya. ");
INSERT INTO indags_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kalau Aku memberikan kesaksian untuk diri-Ku sendiri, tidak ada cara untuk bisa membuktikan bahwa apa yang Aku katakan adalah benar, ");
INSERT INTO indags_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","tetapi Seseorang yang lain memberikan bukti tentang Aku, dan Aku tahu apa yang Dia katakan tentang Aku adalah benar. ");
INSERT INTO indags_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kalian bertanya kepada Yohanes Pembaptis tentang saya, dan dia mengatakan yang sebenarnya, ");
INSERT INTO indags_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","tetapi Aku tidak tergantung pada apa yang orang lain katakan tentang Aku. Saya menjelaskan ini kepada kalian sehingga kalian dapat diselamatkan. ");
INSERT INTO indags_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John seperti cahaya yang menyala terang, dan kalian bersedia menikmati cahayanya untuk sementara waktu. ");
INSERT INTO indags_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tetapi bukti yang saya berikan lebih besar dari John, karena saya melakukan pekerjaan yang diberikan Bapa kepada saya untuk dilakukan, ");
INSERT INTO indags_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","dan ini adalah bukti bahwa Bapa mengutus Aku. Bapa yang mengutus Aku, Dia sendiri yang berbicara atas nama-Ku. Kalian belum pernah mendengar suara-Nya ataupun melihat wajah-Nya. ");
INSERT INTO indags_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kalian tidak percaya apa yang Dia katakan, karena kalian menolak untuk percaya kepada-Ku yang sudah Dia utus. ");
INSERT INTO indags_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kalian mempelajari Kitab Suci, karena kalian yakin bahwa melaluinya kalian akan bisa hidup untuk selama-lamanya. Tetapi Kitab Suci itu menjelaskan tentang Aku, ");
INSERT INTO indags_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tetapi kalian menolak untuk datang kepada Aku untuk belajar bagaimana bisa memiliki kehidupan. ");
INSERT INTO indags_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Aku tidak perlu terima pujian dari manusia. ");
INSERT INTO indags_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Saya mengenal kalian, dan bahwa kalian tidak memiliki kasih Allah di dalam diri kalian. ");
INSERT INTO indags_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aku datang untuk mewakili Bapa-Ku, dan kalian tidak terima Aku. Tetapi kalian akan menerima orang-orang yang datang mewakili diri mereka sendiri. ");
INSERT INTO indags_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bagaimana mungkin kalian percaya kepada-Ku? Kalian lebih suka dipuji orang lain dan tidak pedulikan akan hormat yang hanya bisa datang satu-satu-Nya Allah. ");
INSERT INTO indags_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jangan kalian berpikir bahwa Aku yang akan menuduh kalian di hadapan Bapa. Kalian menaruh harapan pada Musa, tetapi dia malah yang sudah menuduh kalian. ");
INSERT INTO indags_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musa menulis tentang Aku, dan kalau kalian percaya Musa, seharusnya kalian juga percaya apa yang Aku katakan. ");
INSERT INTO indags_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tetapi karena kalian tidak percaya apa yang ditulis Musa, mana mungkin kalian akan percaya apa yang sudah Aku katakan!” ");
INSERT INTO indags_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sesudah itu, Yesus menyeberangi Danau Galilea yang juga dikenal sebagai Danau Tiberias. ");
INSERT INTO indags_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ada banyak orang yang sudah melihat Dia melakukan perbuatan-perbuatan ajaib yang menyembuhkan orang-orang sakit, dan mereka mengikuti Dia. ");
INSERT INTO indags_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesus naik ke sebuah gunung bersama dengan murid-muridnya duduk di sana. ");
INSERT INTO indags_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sudah hampir tiba waktunya untuk perayaan keagamaan Paskah. ");
INSERT INTO indags_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ketika Yesus memperhatikan bahwa ada banyak orang yang datang kepada-Nya, dia bertanya kepada Filipus, “Dari manakah kita akan mendapatkan cukup makanan untuk memberi makan semua orang ini?” ");
INSERT INTO indags_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus mengatakan hal ini untuk menguji Filipus, karena Dia sudah tahu apa yang akan dilakukan-Nya. ");
INSERT INTO indags_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jawab Filipus, “Dua ratus koin perak tidak akan cukup untuk membeli roti untuk memberi semua orang hanya sedikit.” ");
INSERT INTO indags_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lalu Andreas, yaitu saudaranya Simon Petrus berkata, ");
INSERT INTO indags_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Di sini ada seorang anak yang membawa bekal berupa lima buah roti jelai dan dua ekor ikan, tetapi apa gunanya untuk orang sebanyak ini?” ");
INSERT INTO indags_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Suruhlah semua orang duduk,” kata Yesus. Ada banyak rumput di sana, jadi mereka semua duduk, berjumlah sekitar lima ribu pria. ");
INSERT INTO indags_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lalu Yesus mengambil roti-roti itu dan mengucap syukur kepada Allah, lalu mulai membagi-bagikan roti itu. Sesudah itu, dia melakukan hal yang sama dengan kedua ekor ikan, memastikan orang-orang memiliki sebanyak yang mereka inginkan. ");
INSERT INTO indags_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Setiap orang yang ada di sana makan sampai kenyang, lalu Yesus perintahkan agar semua makanan yang masih tersisa dikumpulkan supaya tidak ada yang terbuang. ");
INSERT INTO indags_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maka mereka mengumpulkan dan mengisi dua belas bakul dengan potongan-potongan dari lima roti jelai yang telah dimakan orang-orang itu. ");
INSERT INTO indags_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ketika orang-orang melihat keajaiban ini, mereka berkata, “Sesungguhnya ini adalah Nabi yang akan datang ke dunia.” ");
INSERT INTO indags_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesus sudah tahu bahwa mereka akan berusaha memaksa Dia untuk menjadi raja mereka. Jadi Dia menaiki sebuah gunung supaya bisa menyendiri. ");
INSERT INTO indags_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hari sudah semakin sore, dan murid-murid Yesus turun ke tepi danau. ");
INSERT INTO indags_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mereka naik ke perahu, dan menyeberangi air menuju Kapernaum. Sekarang sudah malam dan Yesus belum bergabung dengan mereka. Mereka naik ke perahu, dan menyeberangi air menuju Kapernaum. Sekarang sudah malam dan Yesus belum bergabung dengan mereka. ");
INSERT INTO indags_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Saat mereka sedang berdayung, angin ribut menghantam mereka dan ombak menjadi besar. ");
INSERT INTO indags_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pada saat itu terjadi, mereka sudah mendayung sekitar lima atau enam kilometer. Tiba-tiba mereka melihat Yesus sedang berjalan di atas air menuju mereka. Mereka sangat ketakutan. ");
INSERT INTO indags_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesus berkata kepada mereka, “Jangan takut! Itu saya!” ");
INSERT INTO indags_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Murid-muridnya dengan senang hati menolong Dia masuk ke dalam perahu. Dan saat itu, perahu mereka sudah tiba di tempat tujuan. ");
INSERT INTO indags_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Keesokan harinya, orang banyak yang masih berada di seberang danau menyadari bahwa pada hari sebelumnya hanya ada sebuah perahu di sana. Mereka juga tahu bahwa Yesus tidak pergi menggunakan perahu itu, hanya murid-muridnya. ");
INSERT INTO indags_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kemudian beberapa perahu dari Tiberias yang berlabuh di dekat tempat orang makan roti setelah Tuhan memberkatinya. ");
INSERT INTO indags_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mereka melihat bahwa Yesus bersama murid-muridnya sudah pergi. Mereka juga masuk kedalam perahu-perahu dan pergi ke Kapernaum untuk mencari Yesus. ");
INSERT INTO indags_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mereka mencari-cari-Nya dan menemukan Yesus di Kapernaum diseberang Danau Galilea. Mereka pun bertanya, “Rabi, bagaimana caranya Engkau bisa berada di sini?” ");
INSERT INTO indags_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jawab Yesus, “Aku bisa pastikan bahwa kalian tidak mencari Aku karena kalian sudah melihat perbuatan-perbuatan ajaib, tetapi karena kalian sudah bisa makan dengan kenyang. ");
INSERT INTO indags_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Janganlah mencari makanan yang akan basi. Berusahalah untuk mendapatkan makanan yang akan memberikan hidup untuk selama-lamanya. Anak Manusia akan memberikan makanan itu kepada kalian, karena Allah Bapa telah memberikan meterai persetujuan-Nya kepada-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mereka bertanya, “Apa sih yang sebenarnya Allah inginkan dari kita?” ");
INSERT INTO indags_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jawab Yesus, “Allah menginginkan adalah kalian percaya kepada Aku, yaitu yang sudah Dia utus.” ");
INSERT INTO indags_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jadi mereka berkata kepada Dia, “Kalau begitu, perbuatan ajaib apakah yang akan Engkau lakukan supaya kami bisa percaya kepada-Mu? ");
INSERT INTO indags_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ketika nenek moyang kami berada di padang gurun mereka diberikan manna untuk makan sama seperti yang sudah tertulis di dalam Kitab Suci, ‘Allah memberikan mereka roti dari surga sebagai makanan mereka.’” ");
INSERT INTO indags_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus lalu katakan kepada mereka, “Aku bisa pastikan bahwa bukanlah Musa yang menyediakan kalian roti dari surga. Yang memberikan roti kepada kalian yang benar-benar aalah rot dari surga aalah Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Karena roti Allah adalah Dia yang datang dari surga dan memberi hidup kepada dunia.” ");
INSERT INTO indags_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lalu mereka berkata lagi kepada Yesus, “Tuan, berikanlah roti itu kepada kami.” ");
INSERT INTO indags_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jawab Yesus, “Akulah roti yang memberi hidup. Setiap orang yang datang kepada-Ku tidak akan lapar, dan setiap orang yang percaya tidak akan haus. ");
INSERT INTO indags_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tetapi Aku sudah katakan sebelumnya bahwa kalian sudah melihat Aku, tetapi kalian tetap tidak percaya. ");
INSERT INTO indags_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Semua orang yang Bapa sudah percayakan kepada-Ku akana datang kepada-Ku, dan Aku tidak akan menolak satupun dari mereka. ");
INSERT INTO indags_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Karena saya turun dari surga bukan untuk melakukan apa yang saya inginkan, tetapi untuk melakukan apa yang Dia yang mengutus saya ingin saya lakukan. ");
INSERT INTO indags_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Apa yang Dia inginkan adalah untuk memastikan bahwa tidak ada di antara mereka yang sudah Dia serahkan kepada-Ku hilang. Dia mau supaya Aku menghidupkan mereka kembali pada hari terakhir. ");
INSERT INTO indags_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Apa yang Bapa-Ku saya inginkan adalah agar setiap orang yang melihat Putra dan percaya kepada-Nya memiliki hidup yang kekal, dan bagi Saya untuk membangkitkan mereka pada hari terakhir.” ");
INSERT INTO indags_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Orang-orang Yahudi yang berada di situ mulai bersungut-sungut karena Yesus berkata bahwa Dia adalah roti yang turun dari surga. ");
INSERT INTO indags_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mereka berkata kepada satu sama yang lain, “Bukannya itu Yesus, anak Yusuf? Bukannya kita mengenal bapaknya dan ibunya? Bagaimana mungkin Dia mengatakan bahwa dia turun dari surga?” ");
INSERT INTO indags_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jadi Yesus menjawab mereka, “Berhentilah bersungut-sungut! ");
INSERT INTO indags_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tidak ada yang bisa datang kepada-Ku kecuali Bapa-Ku yang mengutus Aku menarik mereka, dan Aku akan menghidupkan mereka pada hari terakhir. ");
INSERT INTO indags_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sama seperti apa yang sudah tertulis oleh salah seorang nabi, ‘Allah akan mengajar mereka semua.’ Oleh karena itu setiap orang yang mendengar dan menerima ajaran dari Bapa akan datang kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tidak ada seorang pun yang pernah melihat Bapa-ku kecuali Aku, yang sudah datang dari Dia, yang sudah melihat-Nya. ");
INSERT INTO indags_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Aku katakan dengan pasti, bahwa setiap orang yang percaya kepada-Ku akan memiliki hidup untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Akulah roti yang memberi hidup. ");
INSERT INTO indags_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nenek moyang kalian saat berada di padang gurun memang makan manna, dan kemudian mereka mati. ");
INSERT INTO indags_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tetapi ini adalah roti yang turun dari surga, dan siapa pun yang memakannya tidak akan pernah mati. ");
INSERT INTO indags_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Akulah roti dari surga itu! Setiap orang yang memakannya akan hidup untuk selama-lamanya. Tubuh-Ku merupakan roti yang memberi kehidupkan yang Aku berikan kepada orang-orang di dunia ini.” ");
INSERT INTO indags_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kemudian orang-orang Yahudi itu mulai bertengkar satu sama yang lain dan bertanya, “Bagaimana Dia memberi tubuh-Nya kepada kita untuk dimakan?” ");
INSERT INTO indags_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jawab Yesus, “Aku berkata dengan sungguh-sungguh, jika kamu tidak makan daging Anak Manusia dan minum darah-Nya, kamu tidak dapat benar-benar hidup. ");
INSERT INTO indags_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mereka yang makan daging-Ku dan minum darah-Ku memiliki hidup yang kekal, dan Aku akan membangkitkan mereka pada hari terakhir. ");
INSERT INTO indags_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tubuh-Ku adalah makanan yang sebenarnya, dan darah-Ku adalah minuman yang sebenarnya. ");
INSERT INTO indags_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Siapapun yang memakan tubuh-Ku dan meminum darah-Ku hidup bersatu dengan Aku dan Aku dengan dia. ");
INSERT INTO indags_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bapa-Ku adalah sumber hidup. Dialah yang sudah mengutus Aku, dan Aku hidup bersatu dengan Dia. Sama halnya bagi setiap orang yang memakan tubuh-Ku dan meminum darah-Ku juga akan hidup karena dia menjadi satu dengan Aku. ");
INSERT INTO indags_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sekarang ini adalah roti yang turun dari surga, bukan jenis yang dimakan nenek moyangmu dan masih mati. Siapapun yang makan roti ini akan hidup selamanya.” ");
INSERT INTO indags_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus menyampaikan hal-hal ini saat Dia sedang mengajar di rumah ibadah orang Yahudi di Kapernaum. ");
INSERT INTO indags_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Banyak dari murid-muridnya mendengarkan Dia dan mengatakan, “Ini sulit diterima! Siapa yang bisa mengikuti ini?” ");
INSERT INTO indags_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus mengetahui bahwa murid-muridnya sedang mengeluh. Jadi Dia bertanya kepada mereka, “Apakah kalian merasa terganggu dengan apa yang sudah saya ajarkan? ");
INSERT INTO indags_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bagaiamana kalau kalian melihat Anak Manusia naik kembali ke surga? ");
INSERT INTO indags_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Roh memberi hidup; tubuh fisik tidak melakukan apa-apa. Kata-kata yang saya katakan adalah roh dan kehidupan! ");
INSERT INTO indags_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Akan tetapi bagi beberapa dari antara kalian menolak untuk percaya kepada-Ku.” (Yesus mengatakan hal ini karena dari awal Dia sudah tahu siapa yang akan percaya kepada-Nya dan siapa yang akan mengkhianati-Nya.) ");
INSERT INTO indags_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lalu Yesus berkata, “Inilah sebabnya saya mengatakan kepada kalian bahwa tidak ada yang bisa datang kepada saya kecuali itu dimungkinkan oleh Bapa.” ");
INSERT INTO indags_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Karena apa yang Yesus katakan, banyak dari antara orang-orang yang sudah mengikuti Dia pergi meninggalkan Dia karena tidak mau mengikuti-Nya. ");
INSERT INTO indags_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lalu Yesus bertanya kepada kedua belas murid-Nya, “Apakah kalian juga akan meninggalkan-Ku?” ");
INSERT INTO indags_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jawab Simon Petrus, “Tuhan, kepada siapakah akan kami pergi? Hanya Engkaulah yang mengajarkan kami tentang hidup selama-lamanya! ");
INSERT INTO indags_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kami percaya kepada-Mu, dan kami yakin bahwa Engkau adalah Yang Kudus dari Allah.” ");
INSERT INTO indags_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus jawab mereka, “Bukankah aku memilihmu, dua belas murid? Tetapi ada satu orang di antara kalian yang adalah setan.” ");
INSERT INTO indags_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yesus sedang membicarakan Yudas, anak Simon Iskariot. Dia adalah salah satu dari dua belas murid yang akan mengkhianati Yesus.) ");
INSERT INTO indags_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Setelah itu, Yesus menghabiskan waktunya untuk pergi dari satu tempat ke tempat lain di Galilea. Dia tidak ingin melakukannya di Yudea karena orang-orang Yahudi berusaha membunuhnya. ");
INSERT INTO indags_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pada waktu itu, sudah hampir tiba waktunya untuk Pesta Pondok yang dirayakan orang-orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Saudara-saudara Yesus berkata kepada-Nya, “Mengapa Engkau tidak ke Yudea, supaya pengikut-pengikut-Mu bisa melihat hal-hal ajaib yang kamu lakukan? ");
INSERT INTO indags_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tidak ada seorang pun yang melakukan sesuatu secara diam-diam kalau mereka ingin orang lain tahu tentang apa yang mereka buat. Jika kamu bisa melakukan keajaiban seperti itu, maka tunjukkan dirimu pada dunia!” ");
INSERT INTO indags_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Saudara-saudaranya Yesus berkata seperti itu karena mereka sendiri tidak percaya kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus menjawab mereka, “Sekarang belum tiba waktunya untuk Aku ke Yerusalem. Tapi untuk kalian, kalian bisa pergi ke sana kapan pun kalian mau, karena setiap saat adalah waktu yang tepat untuk kalian. ");
INSERT INTO indags_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Orang-orang yang hidup untuk diri mereka sendiri dan mencintai segala hal duniawi tidak akan membeci kalian. Tetapi mereka membenci Aku, karena saya menjelaskan bahwa cara mereka jahat. ");
INSERT INTO indags_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kalian saja yang pergi mengikuti perayaan itu. Waktu-Ku belum tiba, dan Aku tidak akan pergi, belum.” ");
INSERT INTO indags_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sesudah Yesus mengatakan hal ini, Dia tetap tinggal di Galilea. ");
INSERT INTO indags_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Namun sesudah saudara-saudara-Nya sudah pergi mengikuti perayaan itu, Yesus diam-diam juga pergi biar tidak diketahui orang banyak. ");
INSERT INTO indags_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Saat perayaan itu berlangsung, pemimpin-pemimpin Yahudi mencari-cari Yesus dan bertanya ke orang-orang, “Dimanakah Dia?” ");
INSERT INTO indags_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Orang-orang yang ada di sana pun mulai bertengkar mengenai Yesus. Ada yang mengatakan, “Yesus adalah orang yang baik,” sementara yang lain mengatakan, “Tidak, dia menipu banyak orang.” ");
INSERT INTO indags_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tetapi oang-orang tidak berani bicara secara terbuka karena takut kepada pemimpin-pemimpin Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Di tengah-tengah perayaan itu, Yesus pergi ke rumah Tuhan dan mulai mengajar. ");
INSERT INTO indags_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pemimpin-pemimpin terkejut dan berkata, “Bagaimana orang ini bisa tahu banyak hal, padahal dia tidak pernah telah dididik?” ");
INSERT INTO indags_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jawab Yesus, “Apa yang Aku ajarkan tidak berasal dari diri-Ku sendiri tetapi dari Bapa-Ku yang mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Siapa pun yang memilih untuk melakukan apa yang diinginkan Allah akan tahu bahwa apa yang Aku ajarkan benar-benar datang dari Allah atau adalah pikiran-Ku sendiri. ");
INSERT INTO indags_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mereka yang berbicara sendiri ingin memuliakan diri mereka sendiri, tetapi seseorang yang memuliakan orang yang mengutusnya adalah orang yang jujur dan tidak pendusta. ");
INSERT INTO indags_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Apa gunanya Musa memberikan Hukum Taurat kepada kalian? Tidak ad diantara kalian yang mengikuti Hukum Taurat itu! Mengapa kalian berusaha untuk membunuh-ku?” ");
INSERT INTO indags_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Orang-orang yang berkumpul di situ menjawab, “Kamu kerasukan setan! Tidak ada yang mencoba membunuhmu!” ");
INSERT INTO indags_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jawab Yesus kepada mereka, “Aku melakukan keajaiban dan itu tersinggung kalian. ");
INSERT INTO indags_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tetapi kalian juga melakukan pekerjaan pada hari Sabat dengan melakukan sunat kepada anak laki-laki kalau anak itu lahir pada hari Sabat sebelumnya. Hal itu kalian lakukan sesuai dengan Hukum Musa, walaupun ada sunat tidak berasal dari Musa, tetapi dari nenek moyang kita. ");
INSERT INTO indags_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Untuk menaati Hukum Musa, kalian kadang-kadang harus menyunat anak laki-laki pada hari Sabat. Karena itu, mengapa kalian marah kepada Aku karena sudah menyembuhkan seluruh tubuh orang sakit pada hari Sabat? ");
INSERT INTO indags_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jangan menghakimi orang berdasarkan apa yang kalian lihat. Tetapi hakimi berdasarkan apa yang benar.” ");
INSERT INTO indags_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ada beberapa orang dari Yerusalem yang berkata, “Bukankah orang ini yang mereka coba bunuh? ");
INSERT INTO indags_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Namun lihatlah, Dia ada di sini dan sedang mengajarkan di depan umum, dan mereka tidak melakukan apa-apa terhadap dia! Mungkin pemimpin-pemimpin sudah tahu bahwa Dia adalah Kristus? ");
INSERT INTO indags_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tetapi tidak mungkin Dia Kristus, karena kami tahu tempat asalnya. Ketika Kristus datang, tidak akan ada seorang pun yang tahu dari mana dia berasal.” ");
INSERT INTO indags_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Saat Yesus sedang mengajar di rumah Tuhan, Dia berseru, “Jadi kalian pikir kalianmengenal Aku dan dari mana Aku berasal? Namun, Aku tidak datang untuk kepentingan-Ku sendiri. Dia yang mengutus saya adalah benar. Kalian tidak mengenal Dia, ");
INSERT INTO indags_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","tetapi Aku mengenal Dia, karena Aku datang dari Dia. Dia yang sudah mengutus Aku.” ");
INSERT INTO indags_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ada beberapa pemimpin yang ingin menangkap Yesus saat itu juga. Tetapi tidak ada seorang pun di antara mereka yang berani melakukannya karena belum tiba waktunya untuk menangkap Dia. ");
INSERT INTO indags_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ada banyak di antara orang-orang itu yang percaya kepada-Nya. Kata mereka, “Ketika Mesias muncul, apakah dia akan melakukan lebih banyak keajaiban daripada yang dilakukan orang ini?” ");
INSERT INTO indags_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ketika orang-orang Farisi mendengar orang-orang sedang bertengkar mengenai Yesus, mereka berkumpul bersama imam-imam kepala dan menyuruh tentara penjaga rumah Tuhan untuk menangkap Dia. ");
INSERT INTO indags_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tetapi Yesus berkata kepada mereka, “Aku akan berada bersama kalian untuk sebentar saja, lalu Aku akan kembali kepada Dia yang mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kalian akan mencari Aku, tetapi kalian tidak akan menemukan Aku. Kalian tidak bisa pergi ke tempat yang saya akan pergi.” ");
INSERT INTO indags_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pemimpin-pemimpin Yahudi bertanya satu sama yang lain, “Ke manakah bisa dia pergi di mana kita tidak bisa menemukan dia? Apakah dia berencana untuk pergi ke mereka yang tersebar di antara orang asing, dan mengajar orang asing? ");
INSERT INTO indags_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Apa maksudnya dengan mengatakan, ‘Kalian akan mencariku tetapi kalian tidak akan menemukanku; dan kalian tidak bisa datang ke tempat yang saya tuju’?” ");
INSERT INTO indags_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pada hari terakhir yang juga hari yang paling penting dari perayaan, Yesus berdiri dan berkata dengan suara keras, “Kalau kamu haus, datanglah kepada-Ku untuk minum. ");
INSERT INTO indags_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Percaya kepada Aku, dan kalian akan mendapatkan seperti yang tertulis di dalam Firman Allah, dari dalam hatinya akan mengalir aliran-aliran air yang memberi hidup.” ");
INSERT INTO indags_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Dia mengacu pada Roh yang nantinya akan diterima oleh mereka yang percaya padanya. Roh belum diberikan karena Yesus belum dimuliakan.) ");
INSERT INTO indags_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Waktu orang banyak yang ada di situ mendengar apa yang dikatakan Yesus, ada sebagian yang berkata, “Dia ini memang benar adalah nabi yang sudah kita tunggu-tunggu!” ");
INSERT INTO indags_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sebagian lagi berkata, “Dia adalah Kristus!” Ada juga yang berkata, “Mana mungkin Kristus berasal dari Galilea? ");
INSERT INTO indags_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dalam Firman Allah sudah tertulis bahwa Kristus berasal dari keturunan Daud, dan ituberarti bahwa dia harus lahir di Betlehem, kampung di mana Daud juga lahir.” ");
INSERT INTO indags_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jadi orang berdebat tentang Yesus. ");
INSERT INTO indags_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Beberapa ingin menangkapnya, tetapi tidak ada yang menyentuhnya. ");
INSERT INTO indags_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ketika tentara penjaga rumah Tuhan yang ditugaskan untuk menahan Yesus kembali kepada imama-imam kepala dan orang-orang Farisi, mereka ditanya, “Mengapa kalian tidak membawa Yesus ke sini?” ");
INSERT INTO indags_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jawab mereka, “Kami belum pernah mendengar orang yang berbicara seperti dia!” ");
INSERT INTO indags_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Orang-orang Farisi menjawab, “Apakah kalian juga tertipu? ");
INSERT INTO indags_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Apakah ada seseorang dari antara kami imam-imam kepala atau orang-orang Farisi yang percaya kepada Yesus? ");
INSERT INTO indags_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tetapi orang banyak ini tidak tahu apa-apa tentang ajaran hukum — mereka terkutuk!” ");
INSERT INTO indags_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus, yang sebelumnya pergi menemui Yesus, adalah salah satu dari mereka dan bertanya, ");
INSERT INTO indags_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Apakah hukum kita menghukum seseorang tanpa pemeriksaan dan tanpa mengetahui apa yang sebenarnya dia lakukan?” ");
INSERT INTO indags_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lalu mereka berkata, “Nikodemus, engkau pasti berasal dari Galilea! Bacalah Firman Allah, dan engkau akan tahu bahwa tidak ada seorang nabi pun yang berasal dari sana.” ");
INSERT INTO indags_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sesudah itu, mereka semua pulang ke rumah mereka masing-masing, ");
INSERT INTO indags_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","tetapi Yesus pergi ke Bukit Zaitun. ");
INSERT INTO indags_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagi-pagi sekali pada hari berikut, Yesus pergi ke rumah Tuhan, dan orang-orang datang kepada Dia, dan Dia duduk dan mulai mengajar mereka. ");
INSERT INTO indags_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Beberapa orang Farisi dan orang-orang yang ahli dalam Taurat membawa seorang perempuan kepada Yesus. Perempuan itu tertangkap basah berbuat zina, dan mereka memaksanya berdiri di depan orang banyak. ");
INSERT INTO indags_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kata mereka, “Guru, perempuan ini tertangkap basah sedang berzina. ");
INSERT INTO indags_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Seperti yang diajarkan di dalam Hukum Taurat, perempuan seperti ini harus dilempari dengan batu sampai mati. Bagaimana menurutmu?” ");
INSERT INTO indags_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mereka bertanya seperti itu karena mau mencari alasan untuk bisa menuduh-Nya, tetapi Yesus hanya tunduk dan menulis dengan jari-Nya di tanah. ");
INSERT INTO indags_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mereka terus-menerus meminta Yesus memberi jawaban tentang perempuan itu. Akhirnya Dia berdiri dan berkata, “Kalau ada di antara kalian yang tidak pernah melakukan dosa, silahkan lebih dulu lempar perempuan ini dengan batu.” ");
INSERT INTO indags_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lalu Yesus tundik lagi dan tulis di tanah. ");
INSERT INTO indags_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sesudah mereka mendengar jawaban-Nya, satu demi satu dari mereka mulai dari yang paling tua, meninggalkan tempat itu. Akhirnya yang masih berdiri di sana hanya Yesus dan perempuan itu. ");
INSERT INTO indags_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus berdiri dan berkata kepada dia, “Di mana orang-orang itu? Apakah tidak ada siapa-siapa yang menghukum kamu?” ");
INSERT INTO indags_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jawab perempuan itu, “Tidak ada siapa-siapa, Bapak.” Lalu Yesus berkata, “Aku juga tidak menghukum kamu. Sekarang pergilah dan jangan lagi berbuat dosa.” ");
INSERT INTO indags_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sesudah itu, Yesus kembali berbicara kepada orang banyak itu. Dia berkata, “Aku adalah terang dunia. Setiap orang yang ikut Aku tidak akan hidup dalam gelap. Karena terang-Ku akan memberi kehidupan.” ");
INSERT INTO indags_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Orang-orang Farisi tidak setuju dan berkata kepada-Nya, “Hanya kamu yang bicara atas nama dirimu sendiri! Apa yang kamu katakan tidak membuktikan apa-apa!” ");
INSERT INTO indags_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jawab Yesus, “Sekalipun Aku berbicara untuk diri-Ku sendiri, apa yang Aku katakan adalah benar! Aku tahu dari mana aku datang dan kemana Aku pergi. Tetapi kalian tidak tahu dari mana aku berasal atau kemana aku pergi. ");
INSERT INTO indags_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kalian menghakimi Aku sesuai dengan kebiasaan manusia, tetapi saya tidak menghakimi siapa pun. ");
INSERT INTO indags_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tetapi kalau memang Aku menghakimi orang, Aku akan melakukannya dengan adil karena Aku tidak sendiri, tetapi Bapa yang mengutus Aku ada bersama-Ku. ");
INSERT INTO indags_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tertulis dalam hukum kalian bahwa memerlukan dua orang yang mengatakan hal yang sama, untuk membenarkan sesuatu. ");
INSERT INTO indags_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aku berbicara tentang diri-Ku sendiri, dan Bapa-Ku yang mengutus aku berbicara tentang Aku.” ");
INSERT INTO indags_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mereka lalu bertanya kepada-Nya, “Di manakah Bapa-mu?” Jawab Yesus, “Kalian tidak mengenalku, dan kalian tidak mengenal Bapa-Ku. Kalau kalian mengenal Aku, maka kalian juga akan mengenal Bapa-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ketika Yesus mengucapkan kata-kata ini, dia sedang mengajar di rumah Allah. Dia sedang berada di tempat di mana uang disimpan. Tetapi tidak ada yang menangkap-Nya karena waktu-Nya belum tiba. ");
INSERT INTO indags_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus sekali lagi berbicara kepada mereka, katanya, “Aku akan pergi, dan kalian akan berusaha mencari-Ku, tetapi kalian akan mati dalam dosa-dosa kalian. Kalian tidak bisa pergi ke tempat yang Aku pergi.” ");
INSERT INTO indags_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Orang-orang Yahudi lalu bertanya, “Apakah dia mau membunuh diri? Mungkin karena itu dia berkata, ‘Kalian tidak bisa datang ke tempat yang Aku akan pergi.’?” ");
INSERT INTO indags_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesus berkata, “Kalian berasal dari bawah, tetapi Aku berasal dari atas. Kalian berasal dari dunia ini, tetapi Aku tidak berasal pada dunia. ");
INSERT INTO indags_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Itulah sebabnya saya mengatakan kepada kalian bahwa kalian akan mati dalam dosa-dosa kalian. Karena jika kalian tidak percaya pada saya, ‘Aku,’ kalian akan mati dalam dosa-dosa kalian.” ");
INSERT INTO indags_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mereka bertanya lagi kepada-Nya, “Kamu siapa?” Jawab Yesus, “Aku sudah menjelaskan tentang diri-Ku dari pertama kali Aku mengajar kalian! ");
INSERT INTO indags_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ada banyak yang bisa saya katakan tentang kalian, dan banyak yang bisa saya kutuk. Tetapi orang yang mengutus saya mengatakan yang sebenarnya, dan apa yang saya katakan kepada kalian di dunia ini adalah apa yang saya dengar darinya.” ");
INSERT INTO indags_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tidak ada seorang pun dari mereka yang mengerti bahwa yang sedang Yesus sampaikan adalah tentang Bapa-Nya. ");
INSERT INTO indags_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Oleh karena itu, Yesus berkata kepada mereka, “Saat kalian mengangkat Anak Manusia, barulah kalian tahu bahwa Aku-lah yang dibicarakan. Kalian akan tahu bahwa Aku tidak melakukan apa pun dengan kemauani-Ku sendiri, tetapi Aku berkata sesuai dengan apa yang sudah Bapa-Ku diajarkan kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dia yang mengutus Aku selalu berada bersama-Ku. Dia tidak meninggalkan Aku sendiri, karena Aku selalu melaksanakan apa yang Dia ingingkan.” ");
INSERT INTO indags_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Saat Yesus menyampaikan semuanya ini, banyak orang percaya kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lalu Yesus berkata kepada orang-orang Yahudi yang sudah percaya penuh kepada-Nya, “Kalau kalian tetap taat pada perkataan-Ku, kalian benar-benar adalah murid-murid-Ku. ");
INSERT INTO indags_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kalian akan mengerti kebenaran, dan kebenaran itu akan membebaskan kalian.” ");
INSERT INTO indags_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mereka lalu menjawab, “Kami adalah keturunan Abraham! Kami tidak pernah menjadi budak bagi orang lain! Bagaimana mungkin Engkau berkata, ‘Kalian akan dibebaskan?’” ");
INSERT INTO indags_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","“Aku berkata dengan sungguh-sungguh kepada kalian, bahwa apa yang Aku katakan adalah benar. Setiap orang yang berbuat dosa, sudah menjadi budak dari dosanya itu. ");
INSERT INTO indags_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Seorang budak tidak tinggal dalam rumah tuannya untuk selama-lamanya. Tetapi seorang anak akan selama-lamanya menjadi anggota keluarga. ");
INSERT INTO indags_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kalian akan benar-benar bebas kalau Anak itu yang membebaskan kalian. ");
INSERT INTO indags_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aku tahu bahwa kalian adalah keturunan Abraham, tetapi kalian mau membunuh Aku karena kalian tidak suka apa yang Aku sampaikan. ");
INSERT INTO indags_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Saya memberi tahu kalian apa yang telah diwahyukan Bapa kepada saya, sementara kalian melakukan apa yang ayah kalian katakan.” ");
INSERT INTO indags_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jawab mereka, “Abraham adalah bapak kami.” Lanjut Yesus, “Kalau kalian benar-benar adalah keturunan Abraham, kalian akan perbuat apa yang dia buat! ");
INSERT INTO indags_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tetapi sekarang kalian ingin membunuh-Ku, karena apa yang Aku ajarkan, adalah kebenaran yang Aku belajar dari Allah. Hal itu tidak dilakukan Abraham. ");
INSERT INTO indags_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kalian sedang melakukan pekerjaan bapak kalian.” Lalu mereka menjawab, “Kami tidak lahir diluar nikah. Hanya Allah Bapa kita.” ");
INSERT INTO indags_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jawab Yesus, “Kalau memang benar Allah adalah Bapa kalian, kalian akan mengasihi Aku, karena Aku datang dari Allah. Keputusan untuk datang bukanlah milikku, tetapi Dia yang mengutusku. ");
INSERT INTO indags_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mengapa kalian masih tidak mengerti apa yang Aku katakan? Alasannya adalah karena kalian tidak mau mengerti. ");
INSERT INTO indags_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kalian semua berasal dari bapak kalian yaitu iblis! Dan kalian sudah tidak sabar lagi untuk melakukan apa yang dia inginkan. Dari permulaan, dia adalah seorang pembunuh, tidak pernah tinggal dalam kebenaran karena tidak ada sesuatu yang benar tentangnya. Caranya adalah dengan tipu. Dia sendiri adalah seorang penipu dan semua dusta berasal darinya. ");
INSERT INTO indags_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tetapi karena apa yang Aku katakan adalah benar, kalian tidak mau percaya. ");
INSERT INTO indags_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Siapa di antara kalian yang bisa buktikan bahwa apa yang Aku lakukan adalah jahat? Aku sampaikan kebenaran. Lalu mengapa kalian tidak percaya kepada-Ku? ");
INSERT INTO indags_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dia yang berasal dari Allah menyampaikan pesan Allah. Itulah alasan mengapa kalian tidak mau dengar, karena kalian bukan dari Allah.” ");
INSERT INTO indags_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","“Bukankah kami berhak menyebutmu orang Samaria yang kerasukan setan?” kata orang-orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jawab Yesus, “Tidak ada roh jahat di dalam Aku. Aku menghormati Bapa-ku, tetapi kalian tidak menghormati-Ku. ");
INSERT INTO indags_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Saya di sini tidak ingin memuliakan diri saya sendiri. Tetapi ada Dia yang melakukan ini untukku dan yang menghakimi untuk kepentinganku. ");
INSERT INTO indags_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Apa yang Aku katakan adalah benar. Siapa pun yang taat kepada perkataan-Ku tidak akan pernah mati.” ");
INSERT INTO indags_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jawab pemimpin-pemimpin Yahudi, “Sekarang kami sudah pasti bahwa ada roh jahat di dalammu. Abraham meninggal, demikian juga dengan nabi-nabi. Baru sekarang Engkau ada di sini dan berkata, ‘Bagi siapa saja yang taat kepada-Ku tidak akan pernah mati’! ");
INSERT INTO indags_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Apakah kamu lebih hebat dari nenek moyang kami Abraham, dan nabi-nabi yang sudah lama meninggal? Jadi sebenarnya kamu ini siapa?” ");
INSERT INTO indags_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jawab Yesus, “Kalau Aku membuat diri-Ku sendiri hebat, itu berarti bahwa sebenarnya Aku tidak hebat. Tetapi Bapa-ku yang membuat Aku hebat. Kalian berkata bahwa Dia adalah Bapa kalian. ");
INSERT INTO indags_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tetapi kalian tidak mengenal Allah. Tetapi aku mengenal Dia. Kalau Aku berkata, ‘Aku tidak mengenal-Nya,’ maka Aku ada seorang pendusta, sama seperti kalian. Tetapi Aku memang kenal dan taat terhadap perkataan-Nya. ");
INSERT INTO indags_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ayahmu, Abraham, sangat senang ketika dia menantikan kedatanganku, dan sangat bahagia ketika dia melihat hal itu terjadi.” ");
INSERT INTO indags_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pemimpin-pemimpin Yahud berkata kepada dia, “Usia-Mu belum sampai lima puluh tahun. Bagaimana mungkin Engkau melihat Abraham?” ");
INSERT INTO indags_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jawab Yesus, “Apa yang Aku sampaikan adalah benar, Aku sudah ada sebelum Abraham dilahirkan!” ");
INSERT INTO indags_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mendengar ini mereka mengambil batu untuk melempari dia, tetapi Yesus disembunyikan dari mereka dan dia meninggalkan rumah Allah. ");
INSERT INTO indags_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Saat Yesus sedang berjalan, Dia melihat ada seorang laki-laki yang buta sejak lahir. ");
INSERT INTO indags_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Murid-murid-Nya bertanya kepada-Nya, “Guru, dosa siapakah yang membuat orang ini lahir buta? Apakah dia yang berbuat dosa ataukah orang tuanya yang berbuat dosa?” ");
INSERT INTO indags_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jawab Yesus, “Dia ataupun kedua orang tuanya tidak berbuat dosa. Hal ini terjadi supaya orang banyak bisa melihat apa yang Allah akan buat dengan kuasa-Nya melalui dia. ");
INSERT INTO indags_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aku harus melakukan tugas-tugas dari Bapa yang sudah mengutus Aku selagi hari masih siang. Malam akan tiba, dan akan terlalu gelap untuk melakukan apapun. ");
INSERT INTO indags_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Selama Aku masih berada di dunia ini Aku adalah terang dunia.” ");
INSERT INTO indags_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sesudah itu, Yesus membuang ludah ke tanah, lalu Dia mengambil dan menaruh tanah yang basah dari ludah-Nya itu, pada kedua mata orang buta itu. ");
INSERT INTO indags_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Pergilah,” perintah Yesus, “dan cucilah matamu di kolam Siloam.” (Dalam bahasa Ibrani arti “Siloam” adalah “Diutus.”) Orang itu pergi dan mencuci matanya Sesudah itu, dia bisa melihat. ");
INSERT INTO indags_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tetangga-tetangganya, dan orang-orang yang pernah melihat dia waktu dia buta berkata, “Bukankah orang ini yang biasanya duduk di sini dan mengemis.” ");
INSERT INTO indags_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ada beberapa orang berkata, “Benar, inilah orangnya.” Yang lain berkata, “Bukan, dia memang mirip orang itu.” ");
INSERT INTO indags_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mereka, lalu bertanya, “Bagaimana caranya kamu sekarang bisa melihat.” ");
INSERT INTO indags_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dia menjawab, “Orang yang bernama Yesus membuat lumpur dengan cara mencampur ludah-Nya dengan tanah untuk membuat lumpur. Lalu dia menaruh lumpur itu pada kelopak mata saya. Dia menyuruh saya pergi mencuci mata di kolam Siloam. Sesudah saya lakukan itu, saya bisa melihat.” ");
INSERT INTO indags_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Di mana orang itu sekarang?” tanya mereka. Dia menjawab, “Saya tidak tahu.” ");
INSERT INTO indags_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mereka membawa orang yang sebelumnya buta itu menghadap orang-orang Farisi, ");
INSERT INTO indags_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","karena Yesus membuat lumpur dan menyembuhkan orang buta itu pada hari Sabat. ");
INSERT INTO indags_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jadi orang Farisi bertanya kepada pria itu, “Bagaimana kamu sekarang bisa melihat?” Jawab orang itu, “Yesus yang menaruh lumpur pada mata saya, dan lalu saya pergi mencucinya, dan sekarang saya bisa melihat.” ");
INSERT INTO indags_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kemudian ada beberapa orang Farisi yang berkata, “Orang itu tidak mungkin diutus Allah. Dia tidak taat pada hukum hari Sabat.” Yang lainnya berkata, “Bagaimana mungkin dia orang jahat kalau dia melakukan hal ajaib?” Di antara orang-orang Farisi sendiri terjadi beda pendapat. ");
INSERT INTO indags_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lalu mereka bertanya kepada orang yang dilahirkan buta itu, “Apa pendapatmu tentang orang yang menyembuhkanmu?” Jawab orang itu, “Menurut saya, dia adalah seorang nabi.” ");
INSERT INTO indags_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tetapi pemimpin-pemimpin Yahudi sebenarnya tidak percaya bahwa orang itu sebelumnya buta dan sekarang bisa melihat. Jadi mereka memanggil orang tua pria itu. ");
INSERT INTO indags_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mereka bertanya kepada mereka, “Apakah ini anakmu yang kamu katakan terlahir buta? Jadi bagaimana sekarang dia bisa melihat?” ");
INSERT INTO indags_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jawab mereka, “Kami yakin bahwa dia adalah anak kami yang dilahirkan buta. ");
INSERT INTO indags_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tetapi kami tidak tahu bagaimana dia bisa melihat, dan kami juga tidak mengenal orang yang menyembuhkan matanya! Tanyakan saja padanya! Dia sudah dewasa dan bisa menjawab sendiri.” ");
INSERT INTO indags_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Orang tuanya menjawab seperti itu sebab mereka takut kepada pemimpin-pemimpin Yahudi. Mereka tahu bahwa pemimpin-pemimpin itu sudah sepakat kalau ada orang yang menyatakan bahwa Yesus adalah Kristus, mereka akan menjadi dikeluarkan dari rumah pertemuan. ");
INSERT INTO indags_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Itulah alasan mengapa orang tuanya menjawab, “Dia sudah cukup umur untuk bisa menjawab sendiri.” ");
INSERT INTO indags_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sekali lagi orang yang sebelumnya buta itu dipanggil untuk menghadap. Pemimpin-pemimpin itu berkata kepadanya, “Kamu harus mengucap syukur kepada Allah. Kami tahu bahwa orang yang menyembuhkanmu itu berdosa.” ");
INSERT INTO indags_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dia jawab, “Saya tidak tahu apakah orang itu baik atau jahat Yang saya tahu adalah: Dulu saya buta, tetapi sekarang saya sudah bisa melihat!” ");
INSERT INTO indags_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lalu mereka bertanya lagi, “Apa yang dia lakukan kepadamu? Bagaimana dia menyembuhkanmu?” ");
INSERT INTO indags_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dia menjawab, “Saya sudah katakan tadi, dan kalian tidak mendengar? Mengapa kalian ingin saya menceritakannya kembali? Apakah kalian juga ingin menjadi pengikutnya?” ");
INSERT INTO indags_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hal ini membuat mereka marah, dan mereka menghinanya dengan berkata, “Kamulah pengikut orang itu, tetapi kami adalah pengikut-pengikut Musa. ");
INSERT INTO indags_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kami tahu bahwa Allah berbicara dengan Musa, sedangkan orang ini, kita bahkan tidak tahu dari mana dia berasal!” ");
INSERT INTO indags_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jawaban orang itu, “Sangat mengherankan! Dia menyembuhkan saya tetapi kalian tidak tahu asal usulnya! ");
INSERT INTO indags_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kami tahu bahwa Allah tidak mendengarkan orang-orang berdosa Tetapi Allah mendengarkan permohonan orang yang menunjukkan rasa hormat dan taat kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sebelum hal ini terjadi, belum pernah ada orang yang menyembuhkan mata orang yang dilahirkan buta. ");
INSERT INTO indags_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kalau orang ini tidak berasal dari Allah, dia tidak akan mungkin melakukan sesuatu seperti ini.” ");
INSERT INTO indags_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jawab mereka, “Kamu dilahirkan buta! Dan sekarang kamu mau mengajar kami?!” Lalu mereka mengusir dia dari rumah pertemuan. ");
INSERT INTO indags_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus mendengar bahwa orang itu diusir dari rumah pertemuan Dia mencarinya dan berkata, “Apakah kamu percaya kepada Anak Allah?” ");
INSERT INTO indags_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jawab orang itu, “Bapak, siapakah Anak Allah Katakanlah, supaya saya bisa percaya kepada-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus berkata, “Kamu sudah melihat Dia Orang yang sedang bicara denganmu saat ini adalah Anak Allah.” ");
INSERT INTO indags_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jawab orang itu, “Saya percaya!” Dia lalu dia bersujud menyembah-Nya. ");
INSERT INTO indags_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus berkata, “Aku datang ke dunia ini untuk menghakimi orang, supaya orang buta bisa melihat, dan orang yang bisa melihat akan menjadi buta.” ");
INSERT INTO indags_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pada saat itu ada beberapa orang Farisi yang sedang berdiri bersama Yesus. Mereka mendengar apa yang Dia katakan. Lalu mereka bertanya, “Jadi yang Engkau maksudkan adalah kami juga buta?” ");
INSERT INTO indags_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jawab Yesus kepada mereka, “Kalau kalian buta, kalian tidak akan bersalah, tetapi karena sekarang kalian mengatakan bahwa ‘Kami bisa melihat,’ maka kalian tetap bersalah.” ");
INSERT INTO indags_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Apa yang Aku katakan adalah benar: siapa pun yang tidak masuk melalui gerbang kandang domba tetapi memanjat dengan cara lain adalah pencuri dan perampok. ");
INSERT INTO indags_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tetapi orang yang masuk melalui pintu, dialah orang yang memelihara domba-domba. ");
INSERT INTO indags_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penjaga pintu akan membuka pintu untuk dia, dan domba-domba mengenali suaranya. Dia memanggil nama setiap domba dan menuntun keluar domba-domba itu. ");
INSERT INTO indags_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ketika domba-domba miliknya berada di luar, dia berjalan di depan domba-dombanya Domba-domba akan mengikutinya karena mengenali suaranya. ");
INSERT INTO indags_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Domba-domba itu tidak akan mengikuti orang lain, malah akan melarikan diri dari orang itu karena tidak mengenali suaranya. ");
INSERT INTO indags_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ketika Yesus memberikan ilustrasi ini, mereka yang mendengarkan dia tidak mengerti apa yang dia maksud.” ");
INSERT INTO indags_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jadi Yesus berkata lagi, “Aku mengatakan yang sesungguhnya Aku-lah pintu dari kandang domba. ");
INSERT INTO indags_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Semua orang yang datang sebelum saya adalah pencuri dan perampok, tetapi domba-domba itu tidak mendengarkan mereka. ");
INSERT INTO indags_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akulah pintu Siapapun yang masuk melalui Aku akan disembuhkan. Dia bisa masuk keluar sesuka hatinya dan tersedia makanan untuk dia makan. ");
INSERT INTO indags_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Si pencuri hanya datang untuk mencuri, membunuh dan menghabisi domba-domba itu. Aku sudah datang supaya manusia bisa hidup dan bisa benar-benar menikmati hidup. ");
INSERT INTO indags_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Aku adalah gembala yang baik. Akulah yang merawat domba-domba itu. Gembala yang baik rela mati demi domba-dombanya. ");
INSERT INTO indags_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ada orang yang bekerja supaya bisa menerima upah. Siapa yang melakukan itu tidak begitu peduli karena domba-domba bukan miliknya. Kalau dia melihat ada binatang buas yang datang, dia akan melarikan diri supaya bisa selamat. Binatang buas itu akan menangkap salah satu domba, dan yang lain akan lari kemana-mana. ");
INSERT INTO indags_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pekerja itu melakukannya karena dia tidak peduli pada yang terjadi pada domba-domba dan dia hanya bekerja supaya bisa menerima upah. ");
INSERT INTO indags_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Akulah Gembala yang baik. Aku mengenali domba-domba-Ku, dan domba-domba-Ku juga mengenali Aku. ");
INSERT INTO indags_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Sama seperti Bapa-Ku mengenali Aku, Aku juga mengenali-Nya. Aku rela mati untuk menyelamatkan domba-domba. ");
INSERT INTO indags_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aku juga punya domba-domba lain yang tidak tergabung dengan kawanan domba ini. Saya juga akan membawa mereka juga. Domba-domba itu akan mendengarkan suara-Ku. Lalu semua domba akan berkumpul menjadi satu kawanan, dan dengan hanya satu gembala saja. ");
INSERT INTO indags_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Oleh karena itu, Bapa-Ku sangat mengasihi Aku, karena Aku rela mati supaya Aku bisa hidup kembali. ");
INSERT INTO indags_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tidak seorangpun yang mengambil nyawa-Ku, Aku yang memutuskan untuk menyerahkannya. Aku mempunyai kuasa hak untuk menyerahkan nyawa-Ku dan hak untuk mengambilnya kembali. Inilah perintah yang Bapa-Ku berikan kepada-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lalu terjadi pertengkaran antara orang-orang Yahudi karena perkataan Yesus. ");
INSERT INTO indags_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Banyak di antara mereka berkata, “Dia dikuasai roh jahat sehingga dia menjadi gila. Untuk apa mendengarkan dia?” ");
INSERT INTO indags_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ada sebagian yang mengatakan, “Orang mana yang dikuasai roh jahat yang akan berkata-kata seperti Dia. Apakah ada roh jahat yang bisa membuat orang buta melihat!” ");
INSERT INTO indags_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Saat itu musim dingin, dan waktu Festival Penahbisan di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus sedang berjalan di bagian rumah Allah yang disebut tempat peristirahatan Salomo. ");
INSERT INTO indags_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Orang-orang Yahudi mengelilingi Yesus dan berkata, “Untuk berapa lamakah Engkau akan membuat kami bertanya-tanya tentang hal ini? Kalau memang Engkau adalah Kristus, katakanlah dengan terus terang.” ");
INSERT INTO indags_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Lalu Yesus berkata, “Aku sudah mengatakannya, tetapi kalian tidak percaya. Bapa-Ku sudah memberi kuasa kepada-Ku untuk melakukan hal-hal ajaib. Keajaiban yang Aku lakukan membuktikan siapa Aku yang sebenarnya. ");
INSERT INTO indags_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kalian masih tidak percaya, karena kalian tidak termasuk dari domba-dombaku. Aku sudah mengatakan hal ini sebelumnya. ");
INSERT INTO indags_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Domba-dombaku mengenali suara-Ku, dan sebaliknya Aku juga mengenal mereka. Mereka akan selalu mengikuti Aku. ");
INSERT INTO indags_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aku memberikan kepada mereka hidup untuk selama-lamanya. Mereka tidak akan pernah mati. Tidak ada seorang pun yang bisa merampas mereka dari tangan-Ku. ");
INSERT INTO indags_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bapa-Ku yang sudah memberikan domba-domba itu kepada-Ku. Dia lebih berkuasa daripada dari semua yang ada. Tidak ada seorang pun yang bisa merampas mereka dari tangan Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bapa dan Aku adalah satu.” ");
INSERT INTO indags_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lalu pemimpin-pemimpin Yahudi mengambil batu untuk melempari Yesus sampai mati. ");
INSERT INTO indags_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesus berkata kepada mereka, “Aku sudah mengerjakan banyak hal baik yang datang dari Bapa-Ku. Dari banyak hal itu, untuk hal manakah kalian ingin membunuh-Ku?” ");
INSERT INTO indags_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jawab pemimpin-pemimpin Yahudi, “Kami tidak membunuh-Mu untuk hal-hal baik yang Kamu lakukan, tetapi untuk penistaan. Kamu hanya adalah manusia biasa, namun kamu katakan diri-Mu adalah Allah.” ");
INSERT INTO indags_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Lalu Yesus menjawab mereka, “Bukankah sudah tertulis dalam hukummu bahwa ‘Aku berkata, Kamu adalah allah’? ");
INSERT INTO indags_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tertulis bahwa Allah berbicara kepada manusia, dan Dia menyebut mereka dengan allah-allah. Tidak ada yang bisa mengubah perkataan dalam Kitab Suci. ");
INSERT INTO indags_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jadi mengapa kalian mengatakan orang yang dipilih dan diutus Bapa ke dunia adalah penghujatan karena saya berkata ‘Aku adalah Anak Allah’? ");
INSERT INTO indags_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kalau Aku tidak melakukan pekerjaan Bapa-ku, kalian tidak usah taat kepada apa yang Aku ajarkan ");
INSERT INTO indags_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tetapi kalau Aku mengerjakan pekerjaan Allah, percayalah pada hal-hal yang Aku kerjakan itu sekalipun kalian tidak percaya kepada Aku. Dengan begitu, kalian akan ketahui dan kalian akan percaya bahwa Bapa-Ku ada di dalam Aku, dan Aku ada di dalam Bapa-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jadi mereka berusaha untuk menahan-Nya. Tetapi Yesus berhasil meloloskan diri dari mereka. ");
INSERT INTO indags_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kemudian Yesus pergi ke seberang Sungai Yordan. Dia pergi ke tempat di mana Yohanes pertama kali membaptiskan orang. Yesus tinggal di sana untuk beberapa waktu lamanya. ");
INSERT INTO indags_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Banyak orang yang datang kepada-Nya di sana dan mereka berkata, “Yohanes sendiri tidak melakukan hal-hal ajaib. Tetapi segala sesuatu yang Yohanes katakan tentang orang ini memang benar.” ");
INSERT INTO indags_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Di sana, banyak orang menjadi percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ada seorang yang bernama Lazarus yang jatuh sakit. Dia tinggal di Betania bersama kedua saudara perempuannya bernama Maria dan Marta. ");
INSERT INTO indags_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maria adalah perempuan yang sama yang akan menyirami minyak wangi pada kaki Yesus dan mengeringkannya dengan rambutnya.) ");
INSERT INTO indags_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jadi kedua saudara perempuan itu mengutus seseorang untuk memberitahu Yesus. Orang itu berkata, “Tuan, orang yang Engkau kasihi sedang jatuh sakit.” ");
INSERT INTO indags_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ketika Yesus menerima pesan itu, Dia berkata, “Penyakit ini tidak akan mengakibatkan kematian. Hal ini terjadi untuk membuktikan kepada manusia tentang kuasa Allah Anak Allah akan dimuliakan melalui kejadian ini.” ");
INSERT INTO indags_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus sangat mengasihi Marta, saudara perempuannya dan Lazarus. ");
INSERT INTO indags_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tetapi ketika Dia mendengar bahwa Lazarus sedang jatuh sakit, selama dua hari, Dia tetap tinggal di tempat di mana dia sedang berada saat itu. ");
INSERT INTO indags_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sesudah itu, Dia berkata kepada murid-muridnya, “Marilah kita balik ke Yehuda.” ");
INSERT INTO indags_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lalu murid-muridnya berkata, “Rabi, belum lama ini pemimpin-pemimpin Yahudi ingin melemparimu dengan batu sampai mati. Apakah Engkau benar-benar mau kembali ke sana?” ");
INSERT INTO indags_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jawab Yesus kepada mereka, “Bukankah dalam satu hari matahari bersinar selama dua belas jam Kalau? Seseorang berjalan pada siang hari, dia tidak akan jatuh Dia dapat melihat karena terang bagi dunia ini ");
INSERT INTO indags_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tetapi kalau seseorang berjalan pada malam hari, dia akan tersandung karena tidak ada terang.” ");
INSERT INTO indags_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sesudah Yesus berkata itu, Dia berkata, “Sahabat kita, Lazarus sedang tidur, tetapi Aku akan membangunkannya.” ");
INSERT INTO indags_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Murid-muridnya berkata, “Tuhan, kalau dia sedang tidur, berarti tidak akan terjadi sesuatu.” ");
INSERT INTO indags_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Murid-murid berpikir bahwa apa yang Dia maksudkan adalah tidur untuk beristirahat. ");
INSERT INTO indags_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lalu dengan terus terang Yesus berkata, “Lazarus sudah mati. ");
INSERT INTO indags_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sebenarnya, aku senang tidak berada di sana untuk menyembuhkan dia. Karena dengan kejadian ini, kalian akan benar-benar percaya pada Aku Tetapi marilah, kita pergi kepadanya.” ");
INSERT INTO indags_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Lalu Tomas, yang juga disebut Si Kembar, berkata kepada murid-murid yang lain “Ayo, kita juga ikut, biarlah kita mati bersama-sama dengan Yesus.” ");
INSERT INTO indags_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jadi, waktu Yesus tiba dia menemukan bahwa Lazarus sudah dikubur selama empat hari. ");
INSERT INTO indags_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(Betania jaraknya kurang lebih tiga kilometer dari Yerusalem.) ");
INSERT INTO indags_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Banyak orang Yahudi sudah datang untuk melayat dan sedang mengunjungi Marta dan Maria untuk memberi penghiburan atas kematian saudara laki-laki mereka. ");
INSERT INTO indags_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ketika Marta mendengar bahwa Yesus sudah tiba, dia pergi menyambutnya. Sementara itu, Maria tinggal di rumah. ");
INSERT INTO indags_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta berkata kepada Yesus, “Tuhan, kalau saja Engkau berada di sini, saudaraku tidak akan meninggal! ");
INSERT INTO indags_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tetapi walaupun seperti itu, saya yakin bahwa Allah akan memberi-Mu apa pun yang Engkau minta dari-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jawab Yesus, “Saudaramu itu akan hidup kembali.” ");
INSERT INTO indags_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta berkata kepada-Nya, “Saya tahu bahwa dia akan bangkit pada waktu semua orang mati dibangkitkan pada di hari terakhir.” ");
INSERT INTO indags_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus berkata, “Aku-lah yang akan membangkitkan kembali dan memberi hidup bagi mereka. Siapa pun yang percaya kepada-Ku akan hidup, sekalipun dia sudah mati. ");
INSERT INTO indags_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dan siapa pun yang masih hidup dan percaya kepada Aku tidak akan pernah mati. Apakah kamu percaya hal ini?” ");
INSERT INTO indags_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jawabnya, “Iya, Tuhan, saya percaya bahwa Engkau adalah Mesias, Anak Allah yang akan datang ke dalam dunia ini.” ");
INSERT INTO indags_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Sesudah dia berkata itu, dia kembali untuk memanggil saudaranya, Maria katanya, “Maria, Guru sudah datang, dan Dia mau bertemu denganmu.” ");
INSERT INTO indags_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ketika Maria mendengar hal ini, dia langsung berdiri dan pergi untuk ketemu Yesus. ");
INSERT INTO indags_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Saat itu, Yesus belum sampai di kampung Dia masih berada di tempat yang sama di mana Marta menyambut-Nya. ");
INSERT INTO indags_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Orang-orang Yahudi yang sedang berada di rumah bersama Maria untuk menghiburnya melihat bahwa dia bangun dengan cepat dan pergi. Mereka mengikuti dia. Mereka berkata, “Dia akan pergi ke kubur untuk meratap.” ");
INSERT INTO indags_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Saat Maria sampai di tempat di mana Yesus sedang berada, dia melihatnya, dan berlutut di hadapan-Nya sambil berkata, “Tuhan, kalau saja Engkau ada di sini, saudaraku tidak mungkin meninggal!” ");
INSERT INTO indags_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus melihat bahwa dia sedang menangis. Dia juga melihat bahwa orang-orang yang datang bersama dia juga sedang menangis. Yesus merasa sangat sedih dan bermasalah. ");
INSERT INTO indags_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Katanya, “Di manakah kalian menguburnya?” Jawab mereka, “Ikutlah bersama kami, Tuhan dan lihatlah.” ");
INSERT INTO indags_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lalu Yesus pun menangis. ");
INSERT INTO indags_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kata orang-orang yang berada di sana, Lihatlah, Dia benar-benar mengasihi Lazarus. ");
INSERT INTO indags_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ada di antara orang-orang itu yang berkata, “Orang ini membuat orang buta melihat Mengapa dia tidak selamatkan Lazarus dari kematian.” ");
INSERT INTO indags_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus sangat bermasalah dan dia pergi ke kuburan yaitu sebuah goa dengan batu besar ditempatkan di pintu masuk. ");
INSERT INTO indags_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lalu Yesus berkata kepada orang-orang yang berada di situ, “Pindahkan batu itu.” Marta saudara orang yang sudah mati berkata, “Tuhan, pastilah jenazahnya sudah bau karena sudah empat hari dia dikuburkan.” ");
INSERT INTO indags_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jawab Yesus kepadanya, “Bukankah Aku sudah katakan, kalau kamu percaya Allah, kamu akan melihat kemuliaan-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jadi mereka mendorong batu besar yang menutupi pintu kuburan, dan Yesus melihat ke atas dan berkata, “Bapa, Aku bersyukur karena Engkau sudah mendengarkan Aku. ");
INSERT INTO indags_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aku tahu bahwa Engkau selalu mendengarkan Aku, tetapi Aku katakan hal ini supaya orang-orang yang sedang berdiri di sini percaya bahwa Engkaulah yang mengutus Aku.” ");
INSERT INTO indags_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sesudah dia berkata seperti itu, dia berteriak, “Lazarus, keluarlah!” ");
INSERT INTO indags_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lalu keluarlah orang mati itu. Kain yang mereka pakai untuk menguburnya masih terikat pada tangan dan kakinya. Mukanya juga masih terikat dengan kain. Kata Yesus kepada orang-orang, “Lepaskanlah kain-kain itu supaya dia bisa bebas berjalan.” ");
INSERT INTO indags_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Akibatnya banyak orang Yahudi yang datang untuk menghibur Maria dan yang melihat apa yang dilakukan Yesus menaruh kepercayaan mereka kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tetapi ada dari antara mereka yang pergi kepada orang-orang Farisi untuk menceritakan apa yang sudah dibuat Yesus. ");
INSERT INTO indags_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jadi Kepala Imam dan orang-orang Farisi berkumpul untuk rapat dewan penguasa. Mereka berkata, “Apa yang kan kami lakukan. Orang ini melakukan banyak hal ajaib. ");
INSERT INTO indags_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kalau kami tidak membuatnya berhenti, orang-orang akan percaya kepada-Nya. Nanti penguasa Romawi akan datang dan menghancurkan kota suci kita, dan juga bangsa kita.” ");
INSERT INTO indags_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pada tahun itu, Kayafas bertugas sebagai imam kepala dan dia adalah salah satu orang di antara mereka yang berada di situ Dia berkata, “Kalian tidak tahu apa-apa! ");
INSERT INTO indags_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kalian tidak mengerti, akan lebih baik bagi kita kalau ada satu orang yang mati demi bangsa kita.” ");
INSERT INTO indags_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dia tidak mengatakan ini atas namanya sendiri, tetapi sebagai imam kepala tahun itu dia menubuatkan bahwa Yesus akan mati untuk bangsa itu. ");
INSERT INTO indags_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dan ini bukan hanya untuk bangsa Yahudi, tetapi untuk semua anak-anak Allah yang tercerai-berai agar mereka dapat dikumpulkan dan dijadikan satu. ");
INSERT INTO indags_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jadi, pada hari itu pemimpin-pemimpin Yahudi membuat rencana untuk membunuh Yesus. ");
INSERT INTO indags_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Itulah mengapa Yesus tidak lagi keluar terang-terangan di depan umum Dia pergi ke daerah yang lain dekat padang gurun, ke kota Efraim. Di sana Dia tinggal bersama murid-muridnya. ");
INSERT INTO indags_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tibalah waktunya untuk orang Yahudi merayakan Paskah, dan banyak orang pergi dari pedesaan ke Yerusalem untuk menyucikan diri mereka untuk Paskah. ");
INSERT INTO indags_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Banyak orang mencari Yesus, mereka berdiri di halaman rumah Allah berbicara satu sama yang lain, “Bagaimana menurutmu? Apakah dia akan datang mengikuti perayaan?” ");
INSERT INTO indags_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Imam-imam kepala dan orang-orang Farisi telah memberi perintah agar siapa pun yang mengetahui di mana Yesus berada, harus melaporkannya sehingga mereka dapat menangkapnya. ");
INSERT INTO indags_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Enam hari sebelum perayaan Paskah, Yesus pergi ke tempat tinggal Lazarus di Betania. Larazus ini adalah orang yang sama yang Yesus hidupkan kembali. ");
INSERT INTO indags_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Di sana makan malam diatur untuk menghormati-Nya. Marta membantu menyajikan makanan sementara Lazarus duduk di meja bersama Yesus dan tamu-tamu lainnya. ");
INSERT INTO indags_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria membawa setengah liter parfum yang sangat mahal itu dan mengoleskannya di kaki Yesus, lalu mengeringkan kaki-Nya dengan rambut panjangnya. Aroma parfum tercium di seluruh rumah. ");
INSERT INTO indags_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tetapi, salah satu dari para murid, yaitu Yudas Iskariot, yang di kemudian hari mengkhianati Yesus, berkata, ");
INSERT INTO indags_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mengapa minyak ini tidak dijual dan uangnya diberikan untuk orang-orang miskin? Minyak itu setidaknya seharga tiga ratus dinari.” ");
INSERT INTO indags_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas mengatakan hal itu bukan karena dia peduli dengan orang miskin, tetapi karena dia seorang pencuri. Dia adalah orang yang menjaga uang para murid dan dia sering mengambil sebagian untuk dirinya sendiri. ");
INSERT INTO indags_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lalu Yesus menegurnya, “Jangan mencela dia. Dia melakukan ini sebagai persiapan untuk hari penguburan saya. ");
INSERT INTO indags_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Orang miskin akan selalu berada di sekitar kalian, tetapi Aku tidak selamanya akan ada bersama kalian.” ");
INSERT INTO indags_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Banyak orang Yahudi tahu bahwa Yesus sedang berada di Betania, jadi mereka ke sana bukan saja untuk bertemu Yesus, tetapi juga untuk bertemu Lazarus yang sudah Yesus hidupkan kembali dari kematian. ");
INSERT INTO indags_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Imam-imam kepala juga membuat rencana untuk membunuh Lazarus, ");
INSERT INTO indags_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","karena banyak orang Yahudi meninggalkan imam-imam dan menjadi percaya kepada Yesus karena Lazarus. ");
INSERT INTO indags_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Keesokan harinya orang banyak yang datang untuk perayaan Paskah mendengar bahwa Yesus sedang dalam perjalanan ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jadi mereka membawa daun-daun palem dan pergi keluar kota untuk menyambut dia Mereka berteriak, “Pujilah Allah! Allah memberkati Raja Israel, Dia datang dalam nama Tuhan!” ");
INSERT INTO indags_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus menemukan seekor keledai kecil, dan menaikinya dia melakukan hal ini seperti yang sudah tertulis di dalam Firman Tuhan, ");
INSERT INTO indags_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Hai orang-orang yang tinggal di Yerusalem, Jangan takut! Lihatlah, rajamu datang, menunggangi seekor keledai muda.” ");
INSERT INTO indags_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Murid-murid-Nya tidak mengerti saat peristiwa itu terjadi Tetapi waktu Yesus dimuliakan, mereka ingat kembali pada hal-hal ini yang sudah tertulis tentang Dia Mereka ingat bahwa orang-orang sudah melakukan hal-hal ini kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Banyak orang yang ada bersama Yesus, waktu dia memanggil Lazarus keluar dari kubur dan menghidupkan dia kembali dari kematian dan sedang bercerita. Mereka menceritakan tenang apa yang sudah Yesus lakukan. ");
INSERT INTO indags_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Itulah alasan mengapa banyak orang pergi untuk menyambut Yesus, karena mereka sudah mendengar tentang hal ajaib yang sudah Dia buat. ");
INSERT INTO indags_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Orang-orang Farisi berkata yang satu kepada yang lain, “Lihatlah, kalian tidak bisa menghentikan hal ini Orang-orang dari mana-mana mengikuti Dia.” ");
INSERT INTO indags_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ada orang-orang Yunani yang juga berada di Yerusalem untuk mengikuti perayaan untuk menyembah Allah. ");
INSERT INTO indags_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mereka pergi bertemu Filipus yang berasal dari Betania, di daerah Galilea Mereka berkata, “Bapak, kami ingin bertemu Yesus.” ");
INSERT INTO indags_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipus lalu memberitahu Andreas, dan mereka berdua pergi memberitahu Yesus. ");
INSERT INTO indags_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus berkata, “Waktunya sudah tiba untuk Anak Manusia dimuliakan. ");
INSERT INTO indags_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Dengan pasti, Aku katakan yang sebenar-benarnya, Yang akan terjadi pada-Ku bisa disamakan seperti satu biji gandum. Kalau biji gandum tidak ditanam dalam tanah untuk mati, biji gandum itu akan tetap biji saja. Tetapi kalau biji gandum itu ditanam lalu mati, berarti biji itu akan tumbuh dan menghasilkan banyak gandum. ");
INSERT INTO indags_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Siapapun yang berusaha untuk mempertahankan hidupnya akan kehilangannya. Siapapun yang merelakan hidupnya dalam dunia iniakan memiliki hidup untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kalau ada yang mau mengerjakan tugas-Ku, dia harus pergi ke mana pun Aku pergi Dengan begiu, dia dan Aku akan bersama Bapa-Ku akan menghargai siapapun yang bekerja melayani Aku. ");
INSERT INTO indags_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Saat ini saya sangat bermasalah. Apakah Aku harus katakan, Ya Bapa, selamatkanlah Aku dari penderitaan ini Tidak! Oleh karena Aku datang ke dunia untuk mengalami penderitaan ini. ");
INSERT INTO indags_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bapa, tunjukkan kemuliaan karaktermu.” Lalu terdengar suara dari surga yang berkata, “Saya telah menunjukkan kemuliaannya, dan saya akan menunjukkannya lagi.” ");
INSERT INTO indags_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ada orang-orang yang berdiri tidak jauh. Ketika mereka mendengar suara, mereka berkata, “Itu suara guntur.” Yang lain katakan, “Bukan, itu suara malaikat yang berbicara dengan-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus menjawab mereka, “Suara itu bukan untuk Aku dengar, tetapi supaya kalian mendengar. ");
INSERT INTO indags_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sekarang adalah penghakiman dunia ini; sekarang pangeran dunia ini akan dibuang. ");
INSERT INTO indags_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tetapi ketika saya diangkat dari bumi, saya akan menarik semua orang kepada saya.” ");
INSERT INTO indags_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Yesus menyampaikan hal itu untuk memberitahu bagaimana dia akan mati.) ");
INSERT INTO indags_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Orang-orang menjawab-Nya, “Dalam Hukum Taurat kami, dikatakan bahwa Mesias akan hidup untuk selama-lamanya. Jadi bagaimana kamu bisa mengatakan Anak Manusia harus ‘diangkat’? Siapakah ‘Anak Manusia’ itu?” ");
INSERT INTO indags_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Lalu Yesus katakan kepada mereka, “Terang di antara kalian tinggal sebentar saja Berjalanlah terus selagi masih ada terang, jangan sampai kalian harus berjalan dalam kegelapan, sehingga kalian tidak bisa melihat kemana kalian pergi. ");
INSERT INTO indags_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Taruh kepercayaan kalian pada terang selagi kalian masih memilikinya sehingga kalian bisa menjadi anak-anak terang.” Ketika Yesus mengatakan ini kepada mereka, dia pergi dan menyembunyikan diri dari mereka. ");
INSERT INTO indags_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tetapi mereka tetap tidak mempercayai Dia sekalipun mereka sudah melihat segala perbuatan ajaib yang Dia lakukan di tengah-tengah mereka. ");
INSERT INTO indags_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Apa yang dulu dikatakan nabi Yesaya menjadi nyata Dia sudah katakan, “Tuhan, siapakah yang sudah percaya apa yang sudah kami ajarkan? Kepada siapa kuasa Tuhan dinyatakan?” ");
INSERT INTO indags_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mereka tidak dapat mempercayainya, dan sebagai hasilnya mereka memenuhi apa yang juga dikatakan Yesaya: ");
INSERT INTO indags_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Dia sudah membuat mata mereka menjadi buta, dan membuat hati mereka menjadi keras, jadi mereka tidak bisa melihat dengan mata mereka, atau mengerti dengan hati merekaalau saja mereka berbalik, Dia akan menyembuhkan mereka.” ");
INSERT INTO indags_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya melihat kemuliaan Yesus dan mengatakan ini tentang Dia. ");
INSERT INTO indags_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bahkan banyak dari para pemimpin yang mempercayai-Nya. Namun, mereka tidak menyatakannya dengan terus terang sebab mereka tidak ingin kelompok Farisi mengeluarkan mereka dari rumah-rumah ibadah. ");
INSERT INTO indags_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hal ini terjadi karena mereka lebih ingin dipuji manusia dibandingkan mendapatkan pujian dari Allah. ");
INSERT INTO indags_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus katakan dengan suara keras, “Siapapun yang percaya kepada Aku, tidak saja percaya kepada-Ku, tetapi percaya juga pada Dia yang mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Siapapun yang melihat Aku juga akan melihat Dia yang mengutus Aku! ");
INSERT INTO indags_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Akulah terang yang sudah datang ke dunia. Siapapun yang percaya kepada-Ku tidak akan tinggal dalam kegelapan. ");
INSERT INTO indags_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Siapapun yang mendengar perkataan-Ku dan tidak percaya pada perkataan-Ku itu, Aku tidak akan menghakimi mereka. Aku tidak datang ke dunia ini untuk menghakimi Aku datang untuk menyelamatkan dunia. ");
INSERT INTO indags_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Siapapun yang menolak Aku, dan tidak menghiraukan apa yang Aku ajarkan akan dihakimi pada Hari Penghakiman sesuai dengan apa yang sudah Aku katakan. ");
INSERT INTO indags_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sebab Aku tidak mengatakannya atas kuasa-Ku sendiri tetapi dari Bapa-Ku yang sudah mengutus Aku. Dialah yang memberi perintah langsung soal apa yang harus Aku katakan dan cara menyampaikannya. ");
INSERT INTO indags_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aku tahu bahwa apa yang Dia katakan kepada-Ku untuk dikatakan membawa hidup yang kekal — jadi apa pun yang Aku katakan adalah apa yang Bapa katakan kepada-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Itu adalah hari sebelum perayaan Paskah, dan Yesus tahu bahwa waktunya telah tiba untuk meninggalkan dunia ini dan pergi kepada Bapa-Nya. Dia telah mencintai orang-orang di dunia yang adalah miliknya, dan dia sekarang menunjukkan cintanya yang sepenuhnya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Saat itu saat makan malam, dan iblis telah menaruh pikiran untuk mengkhianati Yesus ke dalam pikiran Yudas, putra Simon Iskariot. ");
INSERT INTO indags_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus tahu bahwa Bapa-Nya sudah menyerahkan segalanya di bawah kuasa-Nya, dan Dia tahu bahwa Dia datang dari Allah dan akan kembali kepada Allah. ");
INSERT INTO indags_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Saat mereka sedang makan, Yesus berdiri dan membuka jubahnya, dan Dia mengambil sebuah handuk dan mengikat handuk itu di pinggang-Nya. ");
INSERT INTO indags_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lalu Yesus mengisi air ke dalam sebuah baskom, dan mulai mencuci kaki murid-murid-Nya. Dia mengeringkan kaki mereka menggunakan handuk yang sudah Dia ikat di pinggang-Nya. ");
INSERT INTO indags_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saat Dia sampai pada Simon Petrus, Petrus berkata kepada-Nya, “Tuhan, apakah Engkau akan mencuci kaki saya?” ");
INSERT INTO indags_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jawab Yesus, “Kamu tidak mengerti sekarang apa yang sedang Aku lakukan, tetapi nanti kamu akan mengerti.” ");
INSERT INTO indags_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus berkata kepada-Nya, “Saya tidak mau Engkau mencuci kaki saya!” Jawab Yesus, “Kalau Aku tidak mencuci kakimu, berarti kamu bukan milik-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petrus memprotes, “Tidak! Engkau tidak akan pernah mencuci kaki saya!” ");
INSERT INTO indags_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus berkata, “Mereka yang telah mandi hanya perlu membasuh kaki mereka dan kemudian mereka benar-benar bersih. Kalian bersih, tetapi beberapa dari kalian tidak bersih.” ");
INSERT INTO indags_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Karena Dia tahu siapa yang akan mengkhianati Dia. Itulah alasannya itu Dia berkata, “Ada di antara kalian yang belum bersih.” ");
INSERT INTO indags_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sesudah Yesus selesai mencuci kaki mereka, Dia mengambil dan memakai jubah-Nya dan duduk kembali bersama mereka. Dia bertanya, “Apakah kalian mengerti apa yang sudah saya buat bagi kalian?” ");
INSERT INTO indags_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Kalian memanggil-Ku ‘Guru’ dan ‘Tuhan,’ dan memang benar, karena Aku adalah Guru dan Tuhan kalian. ");
INSERT INTO indags_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jadi jika Aku, Tuhan dan Guru kalian yang sudah mencuci kaki kalian, kemudian kalian juga harus mencuci kaki satu sama yang lain. ");
INSERT INTO indags_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aku sudah memberikan contoh tentang apa yang harus kalian lakukan. Sekarang lakukanlah seperti yang sudah Aku lakukan. ");
INSERT INTO indags_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Aku katakan yang sesungguhnya, seorang hamba tidak lebih baik dari pada tuannya. Seorang pembawa pesan tidak lebih besar daripada yang mengirimnya. ");
INSERT INTO indags_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sekarang karena kalian sudah mengerti semua ini, kalian akan mendapatkan berkat jika kalian melakukannya. ");
INSERT INTO indags_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Aku tidak bicara soal kalian semua, tetapi Aku sudah kenal benar orang-orang yang sudah Aku pilih. Namun hal ini untuk memastikan bahwa yang tertulis di dalam Firman Tuhan akan terjadi, ‘Dia yang makan bersama-Ku dia telah berbalik melawan Aku.’ ");
INSERT INTO indags_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aku menyampaikan hal ini sekarang supaya kalau hal itu terjadi, kalian akan menjadi yakin tentang Aku. ");
INSERT INTO indags_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Apa yang Aku katakan adalah benar. Orang yang menerima orang yang Aku utus, menerima Aku. Siapa yang menerima Aku juga menerima Bapa yang mengutus Aku.” ");
INSERT INTO indags_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ketika Yesus selesai menyampaikan hal itu, Dia menjadi sangat sedih. Dia berkata, “Aku katakan yang sebenar-benarnya, salah satu dari antara kalian akan mengkhianati aku.” ");
INSERT INTO indags_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Murid-murid saling melihat satu sama yang lain. Mereka tidak tahu siapa di antara mereka yang sedang Yesus bicarakan. ");
INSERT INTO indags_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Di sebelah kanan duduk murid yang dikasihi Yesus dan sedang bersandar kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petrus memberi tanda dengan gerakan tangan kepada murid itu supaya dia bertanya kepada Yesus siapa yang Dia maksudkan. ");
INSERT INTO indags_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dengan mendekatkan kepala ke arah Yesus, murid itu bertanya, “Tuhan, siapa yang Kamu maksudkan itu?” ");
INSERT INTO indags_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jawab Yesus, “Orangnya adalah dia yang akan menerima sepotong roti yang Aku celupkan ke dalam mangkok.” ");
INSERT INTO indags_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Begitu Yudas menerima sepotong roti itu, Iblis masuk ke dalam dirinya. Yesus berkata kepadanya, “Cepat lakukanlah apa yang kamu rencanakan.” ");
INSERT INTO indags_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tidak ada seorang pun yang ada di meja itu yang mengerti apa yang Yesus maksudkan. ");
INSERT INTO indags_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Karena Yudas yang menyimpan kantong uang bersama, ada di antara mereka yang kira bahwa Yesus sedang menyuruhnya untuk membeli sesuatu untuk perayaan, atau Dia menginginkan Yudas memberi sesuatu kepada orang miskin. ");
INSERT INTO indags_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ketika Yudas menerima roti, dia langsung keluar dalam malam. ");
INSERT INTO indags_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sesudah Yudas keluar, Yesus berkata, “Sekarang Anak Manusia akan dimuliakan. Dan Allah akan dimuliakan melalui apa yang terjadi atas-Ku. ");
INSERT INTO indags_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dan kalau Allah dimuliakan melalui-Ku, Allah akan segera memuliakan Aku. ");
INSERT INTO indags_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anak-anak-Ku, waktu-Ku dengan kalian tinggal sedikit saja. Kalian akan mencari Aku, dan seperti yang sudah Saya sampaikan kepada orang-orang Yahudi, kalian tidak bisa ikut ke tempat yang Aku akan pergi. ");
INSERT INTO indags_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Aku memberikan kalian perintah yang baru: Kasihilah satu sama yang lain. Sama seperti Aku sudah mengasihi kalian, oleh karena itu kalian harus saling mengasihi. ");
INSERT INTO indags_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Dengan begitu, setiap orang akan tahu bahwa kalian adalah murid-murid-Ku, kalau kalian saling mengasihi.” ");
INSERT INTO indags_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrus berkata, “Kemanakah Engkau akan pergi, Tuhan?” Jawab Yesus, “Tempat ke mana Aku pergi, untuk saat ini kamu tidak bisa ikut. Tetapi nanti kamu akan menyusul-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus bertanya lagi, “Tuhan, mengapa aku tidak bisa ikut dengan-Mu sekarang? Aku rela mati untuk-Mu.” ");
INSERT INTO indags_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jawab Yesus, “Apakah kamu rela mati untuk-Ku? Inilah yang sebenarnya, sebelum ayam berkokok, kamu akan berkata bahwa kamu tidak mengenal Aku sampai tiga kali.” ");
INSERT INTO indags_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus berkata kepada murid-murid-Nya, “Janganlah kalian kuatir. Percayalah kepada Allah dan juga kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Di rumah Ayah saya ada banyak kamar. Jika ini bukan jadi saya akan sudah memberitahu kalian. Aku akan menyiapkan tempat untuk kalian. ");
INSERT INTO indags_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kalau Aku pergi untuk menyiapkan tempat bagi kalian, Aku akan kembali. Aku akan membawa kalian supaya kalian bisa berada bersama-Ku. ");
INSERT INTO indags_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kalian sudah tahu ke mana Aku pergi, dan kalian sudah tahu jalan ke sana.” ");
INSERT INTO indags_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas berkata kepada Yesus, “Tuhan, kami tidak tahu kemana Engkau mau pergi. Bagaimana mungkin kami tahu jalan ke sana?” ");
INSERT INTO indags_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus menjawab, “Akulah jalan dan kebenaran dan hidup. Tidak seorang pun datang kepada Bapa kecuali melalui Aku. ");
INSERT INTO indags_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kalau kamu mengenal Aku, kamu juga akan mengenal Bapa-Ku. Tetapi mulai sekarang, kamu sudah mengenal-Nya, karena kamu sudah melihat-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kata Filipus kepada-Nya, “Tuhan, tunjukkanlah Bapa-Mu kepada kami, dengan begitu kami akan puas.” ");
INSERT INTO indags_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jawab Yesus, “Apakah Aku sudah lama bersamamu, Filipus, tetapi kamu masih tidak mengenal Aku? Siapapun yang telah melihat saya telah melihat Bapa. Bagaimana kamu bisa mengatakan, ‘Tunjukkan kepada kami Bapa’? ");
INSERT INTO indags_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Apakah kamu masih belum percaya bahwa Aku bersatu dengan Bapa-Ku, dan Bapa-Ku bersatu dengan Aku? Apapun yang Aku katakan, Aku tidak bicara dari pikiran-Ku sendiri. Tetapi Bapa-Ku hidup bersatu di dalam Aku. Dialah yang melakukan pekerjaan-Nya. ");
INSERT INTO indags_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kalau memang kalian tidak percaya pada perkataan-Ku, percayalah kepada-Ku karena hal-hal ajaib yang sudah kalian lihat Aku lakukan. ");
INSERT INTO indags_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aku katakan yang sebenar-benarnya. Orang yang percaya pada-Ku akan melakukan hal-hal besar yang Aku kerjakan. Dan dia akan mengerjakan hal-hal yang lebih hebat lagi karena Aku akan pergi kepada Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Apapun yang kalian minta dari Bapa-ku di dalam nama-Ku akan Aku lakukan. Dengan begitu Bapa-Ku akan dimuliakan melalui Aku, Anak-Nya. ");
INSERT INTO indags_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kalau kamu minta sesuatu di dalam nama-Ku, akan Aku lakukan. ");
INSERT INTO indags_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kalau kalian mengasihi-Ku, kalian akan taat pada perintah-Ku. ");
INSERT INTO indags_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Saya akan meminta kepada Bapa, bahwa Dia akan memberi untuk kalian Penghibur yang lain. ");
INSERT INTO indags_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ini adalah Roh kebenaran, yang akan selalu bersamamu. Dunia tidak bisa menerima Roh yang sesungguhnya karena tidak melihat dan tidak mengenal-Nya Tetapi kalian akan mengenal-Nya karena Roh itu bersatu dengan kalian, dan kalian bersatu dengan-Nya. ");
INSERT INTO indags_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aku tidak akan meninggalkan seperti anak yatim: Aku sendiri akan kembali untuk kalian. ");
INSERT INTO indags_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dalam waktu yang tidak lama lagi dunia tidak akan melihat Aku lagi tetapi kalian akan melihat Aku lagi. Karena Aku hidup, kalian juga akan hidup. ");
INSERT INTO indags_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pada waktu itulah kalian akan tahu bahwa Aku bersatu dengan Bapa-Ku. Kalian akan bersatu dengan-Ku dan Aku bersatu dengan kalian. ");
INSERT INTO indags_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Orang yang menuruti perintah-Ku adalah orang yang mengasihi Aku, orang yang mengasihi Aku akan dikasihi oleh Bapa-Ku. Aku akan mencintai mereka juga, dan akan mengungkapkan Diri-Ku kepada mereka.” ");
INSERT INTO indags_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Lalu Yudas (bukan Iskariot) berkata, “Guru, bagaimanakah Engkau akan menunjukkan diri-Mu hanya kepada kita dan bukan kepada dunia?” ");
INSERT INTO indags_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jawab Yesus, “Semua orang yang mengasihi-Ku akan melakukan apa yang Aku katakan. Bapa-Ku akan mengasihi mereka, dan kami akan mendatangi mereka, dan hidup di dalam hati mereka. ");
INSERT INTO indags_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mereka yang tidak mencintai saya tidak melakukan apa yang saya katakan. Apa yang Aku ajarkan bukan dari-Ku, tetapi adalah Bapa-Ku. Dia-lah yang mengirim Aku. ");
INSERT INTO indags_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Aku sudah mengatakan semuanya ini kepada kalian selagi Aku masih berada bersama kalian ");
INSERT INTO indags_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tetapi ketika Bapa mengirimkan Penghibur, Roh Kudus, menggantikan-Ku, Diaitu yang akan mengajarkan segala sesuatu yang sudah Aku sampaikan kepada kalian. Dia juga yang akan mengingatkan kalian tentang semua yang Aku sudah sampaikan. ");
INSERT INTO indags_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aku meninggalkan damai bersama kalian. Aku memberikan kepada kalian damai-Ku sendiri. Aku tidak memberi pemberian seperti yang diberikan dunia. Jangan biarkan hati kalian susah Jangan takut. ");
INSERT INTO indags_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kalian mendengar apa yang sudah Aku katakan kepada kalian, ‘Aku akan pergi, tetapi nanti kembali kepada kalian.’ Kalau kalian mengasihi Aku, kalian seharusnya bersukacita bahwa Aku kembali kepada Bapa-Ku, karena Bapa-Ku lebih besar daripada Aku. ");
INSERT INTO indags_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Saya telah menjelaskan ini kepada kalian sekarang sebelum itu terjadi sehingga ketika itu terjadi, kalian akan diyakinkan. ");
INSERT INTO indags_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Saya tidak dapat berbicara dengan kalian lebih lama lagi, karena penguasa dunia ini akan datang. Dia tidak memiliki kuasa apa pun di atas Aku, ");
INSERT INTO indags_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","tetapi Aku melakukan apa yang Bapa-ku perintahkan supaya orang-orang dalam dunia ini bisa tahu bahwa Aku mengasihi Bapa-Ku. Sekarang bangunlah! Kita harus pergi.” ");
INSERT INTO indags_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus berkata kepada murid-muridnya, “Aku adalah pohon anggur yang sesungguhnya. Bapa-Ku adalah petani yang merawatnya. ");
INSERT INTO indags_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Dia memotong setiap cabang yang tidak menghasilkan buah. Dan Dia membersihkan setiap cabang yang berbuah, supaya bisa menghasilkan buah yang lebat. ");
INSERT INTO indags_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kalian telah dipangkas dan dibersihkan melalui apa yang saya ajarkan kepada kalian. ");
INSERT INTO indags_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tetapi kalian harus hidup satu dengan Aku dan Aku juga akan hidup satu dengan kalian. Sama seperti ranting tidak dapat menghasilkan buah, kecuali jika ia tetap menjadi bagian dari pokok anggur, demikian juga bagi kalian: kalian tidak dapat berbuah, kecuali jika kalian harus hidup satu dengan Aku. ");
INSERT INTO indags_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Akulah pohon anggur, dan kalian adalah cabang-cabangnya. Siapa pun yang hidup di dalam Aku, dan Aku hidup di dalam dia, dia akan menghasilkan banyak buah. Karena kalau hidup terpisah aku, kalian tidak bisa berbuat apa-apa. ");
INSERT INTO indags_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kalau ada orang yang hidup terpisah dari-Ku, dia seperti cabang yang mati yang harus dipotong. Orang-orang akan mengumpulkan, membuang dan membakar cabang-cabang yang kering. ");
INSERT INTO indags_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kalau kalian hidup di dalam Aku, dan kalian mengikuti kata-kataku, apa pun yang kalian minta akan Aku berikan. ");
INSERT INTO indags_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kalau kalian menghasilkan banyak buah ditunakan menu jukkan bahwa kalian adalah murid-murid-Ku, yang memuliakan Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sama seperti Bapa sudah mengasihi kalian, seperti itu juga Aku mengasihi kalian. Untuk itu, kalian harus selalu hidup sebagai orang-orang yang Aku kasihi. ");
INSERT INTO indags_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jika kalian melakukan apa yang saya katakan, Aku akan selalu mencintaimu. Itulah yang telah saya lakukan. Saya telah melakukan apa yang ayah saya katakan dan Dia akan selalu mengasihi saya. ");
INSERT INTO indags_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aku memberitahu semuanya ini supaya kalian bisa merasakan bersukacita yang sama seperti yang Aku rasakan dan sukacita kalian akan lengkap. ");
INSERT INTO indags_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inilah perintah yang Aku berikan kepada kalian: saling mengasihi satu sama yang lian, sama seperti Aku mengasihi kalian. ");
INSERT INTO indags_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kasih yang paling luar biasa adalah kasih seseorang yang rela mati untuk bisa menyelamatkan sahabat-sahabatnya. ");
INSERT INTO indags_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kalian adalah sahabat-sahabat-Ku, kalau kalian lakukan apa yang saya katakan. ");
INSERT INTO indags_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aku tidak lagi menyebut kalian sebagai pelayan-pelayan, karena seorang pelayan tidak tahu apa yang tuannya lakukan. Tetapi Aku sebut kalian sebagai sahabat-sahabat karena Aku memberitahu kalian semua yang Bapa-Ku katakan kepada saya. ");
INSERT INTO indags_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kalian tidak memilih Aku, tetapi Aku yang memilih kalian. Aku telah memberi kalian tanggung jawab untuk pergi dan menghasilkan buah yang langgeng. Jadi Bapa akan memberikan apa pun yang kalian minta dalam nama-Ku. ");
INSERT INTO indags_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inilah perintah yang Aku berikan: Kasihilah satu sama yang lain. ");
INSERT INTO indags_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jika orang-orang di dunia membencimu, ingatlah bahwa mereka membenci Aku sebelum mereka membenci kalian. ");
INSERT INTO indags_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jika kalian seperti orang-orang di dunia, mereka akan mencintai kalian seperti diri mereka sendiri. Tetapi kalian tidak seperti orang-orang di dunia, dan saya memilih kalian untuk meninggalkan mereka — itulah sebabnya orang-orang di dunia membenci kalian. ");
INSERT INTO indags_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ingat apa yang saya katakan: pelayan tidak lebih penting daripada tuannya. Jika mereka menganiaya Aku, mereka juga akan menganiaya kalian. Jika mereka melakukan apa yang saya katakan, mereka juga akan melakukan apa yang kalian katakan. ");
INSERT INTO indags_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mereka akan melakukan semua hal ini kepada kalian, karena kalian adalah milik-Ku Mereka tidak mengenal Bapa-Ku yang sudah mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kalau Aku tidak datang dan bicara dengan mereka, mereka tidak akan bersalah atas dosa-dosa mereka Tetapi sekarang, mereka tidak memiliki alasan untuk dosa mereka. ");
INSERT INTO indags_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Siapa pun yang membenci Aku, juga membenci Bapa-Ku. ");
INSERT INTO indags_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jika saya tidak memberi mereka demonstrasi seperti itu melalui hal-hal yang belum pernah dilakukan siapa pun sebelumnya, mereka tidak akan bersalah karena melakukan kesalahan, tetapi meskipun melihat semua ini mereka membenci saya dan Ayah saya. ");
INSERT INTO indags_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Semuanya ini sudah terjadi, supaya apa yang tertulis di dalam Kitab Suci bisa menjadi nyata, ‘Mereka membenci Aku tanpa alasan.’ ");
INSERT INTO indags_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aku akan mengirim mengutus Roh Kebenaran untuk menghibur kalian Roh itu datang dari Bapa-Ku Saat Dia datang, Dia akan berbicara memberikan bukti bersaksi tentang Aku. ");
INSERT INTO indags_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kalian juga akan memberikan kesaksian tentang Aku karena kalian telah bersama-Ku sejak Aku memulai pelayanan-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Aku sudah katakan semua ini kepada kalian, supaya kalian tidak meninggalkan kepercayaan kalian pada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kalian akan diusir dari rumah-rumah pertemuan. Benar, saatnya akan tiba di mana seseorang akan membunuh kalian, dan orang itu akan berpikir bahwa apa yang dia lakukan adalah melayani Allah. ");
INSERT INTO indags_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mereka akan melakukan hal-hal seperti itu karena mereka tidak mengenal Bapa-Ku atau pun Aku. ");
INSERT INTO indags_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aku sampaikan kepada kalian hal-hal ini sekarang, supaya pada waktu itu terjadi, kalian akan ingat bahwa Aku sudah memberitahu kalian. Aku tidak mengatakan hal-hal ini dari awal karena waktu itu, Aku masih berada bersama kalian. ");
INSERT INTO indags_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Tetapi sekarang, Aku akan kembali kepada Bapa-Ku yang sudah mengutus aku ke dunia. Tetapi tidak ada di antara kalian yang bertanya, ‘Ke mana Engkau pergi?’ ");
INSERT INTO indags_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sekarang hati kalian terasa sedih karena semua yang sudah Aku katakan. ");
INSERT INTO indags_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tetapi saya mengatakan yang sebenarnya: lebih baik bagi kalian bahwa saya pergi, karena jika tidak, Penghibur tidak akan datang kepada kalian. Jika saya pergi, saya akan mengirimnya kepada kalian. ");
INSERT INTO indags_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ketika Roh Penolong itu datang, Dia akan membuktikan bahwa seluruh dunia salah karena tiga hal — dosa, keadilan, dan penghakiman. ");
INSERT INTO indags_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Soal dosa — karena mereka tidak percaya padaku. ");
INSERT INTO indags_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Soal keadilan — Dia akan menunjukkan apa yang benar, karena Aku akan kembali kepada Bapa-Ku, kalian tidak lagi akan melihat-ku. ");
INSERT INTO indags_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Soal penghakiman — karena penguasa dunia akan dihakimi. ");
INSERT INTO indags_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Masih ada banyak hal yang Aku masih harus sampaikan kepada kalian, tetapi sekarang kamu tidak tahan. ");
INSERT INTO indags_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Roh Kebenaran itu akan menunjukkan kepada kalian apa yang benar, dan Dia akan datang untuk menunjukkan jalan supaya kalian bisa tahu segala sesuatu tentang kebenaran. Dia tidak bicara untuk diri-Nya sendiri, tetapi akan menyampaikan apa yang Dia dengar dari Bapa-Ku Dia akan memberitahu kalian apa ang akan terjadi nanti ");
INSERT INTO indags_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dia akan memuliakan Aku, melalui apa yang Dia ajarkan karena dia akan memberitahu kalian semua yang Dia terima dari-Ku. ");
INSERT INTO indags_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Segala sesuatu yang adalah milik Bapa-Ku juga menjadi milik-Ku. Oleh karena itu Aku berkata bahwa Roh mengajarkan kalian apa pun yang dia terima dari saya. ");
INSERT INTO indags_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sebentar lagi, kalian tidak akan melihat-Ku. Tidak lama sesudah itu, kalian akan melihat Aku lagi, karena Aku pergi kepada Bapa-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Beberapa muridnya berkata satu sama lain, “Apa maksudnya, ‘Sebentar lagi kamu tidak akan melihatku, tetapi sebentar lagi kamu akan melihatku’? dan ‘Karena aku pergi kepada Bapa’?” ");
INSERT INTO indags_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mereka bertanya, “Apa yang dia maksud dengan ‘sebentar lagi’? Kami tidak tahu apa yang dia bicarakan.” ");
INSERT INTO indags_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus tahu bahwa mereka ingin bertanya tentang hal ini kepada-Nya. Jadi dia bertanya kepada mereka, “Apakah kalian bertanya-tanya tentang komentar saya, ‘Sebentar lagi kalian tidak akan melihat saya, tetapi beberapa saat setelah itu kalian akan melihat saya’? ");
INSERT INTO indags_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Aku akan katakan yang sebenar-benarnya kalian akan menangis dan menjadi sangat sedih, tetapi orang-orang di dunia ini akan sangat senang Pada awalnya kalian akan sedih, tetapi rasa sedih itu kalian akan berubah menjadi bersuka cita. ");
INSERT INTO indags_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Saat tiba waktunya untuk seorang perempuan melahirkan, dia kesakitan. Tetapi sesudah anaknya lahir, dia lupa rasa sakit itu Dia sangat senang karena bayinya sudah lahir dengan selamat ke dunia. ");
INSERT INTO indags_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sama seperti kalian saat ini merasa sangat sedih Tetapi Aku akan melihat kalan lagi, dan saat itu kalian akan bersuka cita Tidak ada seorang pun yang bisa mengambil rasa suka cita itu dari kalian. ");
INSERT INTO indags_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ketika hari itu tiba, kalian tidak perlu minta apa-apa dari-Ku Aku katakan dengan sungguh-sungguh Bapa-Ku akan melakukan apa saja yang kalian minta di dalam nama-Ku. ");
INSERT INTO indags_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sampai sekarang kalian belum meminta apapun dalam nama-Ku, maka mintalah maka kalian akan menerima, maka kebahagiaan kalian akan lengkap. ");
INSERT INTO indags_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aku sudah sampaikan semua ini dengan memberi contoh dalam cerita. Akan tiba waktunya ketika Aku tidak akan menyampaikan sesuatu dalam bentuk cerita Aku akan memberitahu kalian tentang Bapa-ku secara terus terang. ");
INSERT INTO indags_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pada hari itulah, kalian akan meminta dalam nama-Ku. Aku tidak akan mewakili kalian untuk meminta sesuatu kepada Bapa-Ku, ");
INSERT INTO indags_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","karena Bapa-Ku sendiri mengasihi kalian. Dia mengasihi kalian karena kalian sudah lebih dulu mengasihi Aku. Dan Dia mencintaimu karena kalian mencintai-Ku dan percaya bahwa Aku berasal dari Allah. ");
INSERT INTO indags_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bapa-Ku sudah mengutus Aku ke dalam dunia ini Dan sekarang Aku akan tinggalkan dunia ini untuk kembali kepada Bapa-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Lalu murid-murid berkata kepada-Nya, “Ya, sekarang Engkau katakan dengan terus terang kepada kami dan tidak memberikan contoh dalam cerita. ");
INSERT INTO indags_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sekarang kami yakin bahwa Engkau tahu segalanya, dan untuk mengetahui pertanyaan apa yang dipikirkan orang, Engkau tidak perlu bertanya kepada mereka. Ini meyakinkan kami bahwa Engkau berasal dari Allah.” ");
INSERT INTO indags_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jawab Yesus, “Apakah sekarang kalian benar-benar percaya Aku. ");
INSERT INTO indags_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Waktunya akan datang — Tidak! Sudah tiba saatnya di maa kalian akan melarikan diri. Setiap orang akan pulang ke rumahnya sendiri. Kalian akan meninggalkan Aku sendirian. Tetapi sebenarnya Aku tidak sendiri, karena Bapa-Ku berada bersama-Ku. ");
INSERT INTO indags_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Saya telah mengatakan semua ini kepada kalian sehingga kalian dapat memiliki kedamaian karena kalian adalah satu dengan saya. Kalian akan menderita di dunia ini, tapi jadilah berani — aku telah mengalahkan dunia!” ");
INSERT INTO indags_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sesudah Yesus selesai mengatakan semua ini kepada murid-muridnya, Dia melihat ke langit dan berkata, “Bapa, waktunya sudah tiba. Muliakanlah Aku supaya melalui apa yang terjadi kepada Anak-Mu ini, Aku dapat memuliakan Engkau. ");
INSERT INTO indags_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Karena Engkau telah memberikan kuasa kepada-Nya atas semua orang, sehingga Dia dapat memberikan hidup yang kekal kepada semua orang yang telah Engkau berikan kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hanya Engkaulah satu-satunya Allah. Kalau mereka mengenal Engkau, dan Yesus Kristus yang Engkau utus, mereka akan hidup untuk selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aku sudah memuliakan Engkau di dunia ini. Aku sudah menyelesaikan pekerjaan yang Engkau berikan kepada-Ku. ");
INSERT INTO indags_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sekarang Bapa, muliakan Aku di hadirat Engkau dengan kemuliaan yang kumiliki bersama Engkau sebelum awal dunia. ");
INSERT INTO indags_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Aku sudah tunjukkan kepada manusia siapa Engkau yang sebenarnya. Merekalah manusia yang sudah Engkau serahkan kepada-Ku dari dunia. Mereka milik-Mu dan Engkau sudah memberikan mereka kepada-Ku, dan mereka telah melakukan apa yang Engkau katakan. ");
INSERT INTO indags_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sekarang mereka benar-benar tahu bahwa segala sesuatu yang sudah Engkau berikan kepada Aku berasal dari-Mu. ");
INSERT INTO indags_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Saya telah memberi mereka pesan yang Engkau berikan kepada saya. Mereka menerimanya, sepenuhnya yakin bahwa Aku berasal dari Engkau, dan mereka percaya bahwa Engkau yang mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Untuk orang-orang inilah yang Aku minta dari-Mu. Aku tidak minta semua orang di dunia ini. Tetapi Aku meminta orang-orang yang sudah Engkau berikan kepada-Ku, karena mereka adalah milik-Mu. ");
INSERT INTO indags_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Setiap orang yang adalah milik-Ku adalah milik-Mu. Dan semua yang adalah milik-Mu, juga adalah milik-Ku, dan mereka sudah memuliakan Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sekarang saya meninggalkan dunia, dan merekalah yang masih tetap ada. Aku akan datang kepada-Mu. Ya Bapa, jagalah mereka dalam nama-Mu, nama yang sudah Engkau berikan kepada-Ku. Dengan begitu mereka akan menjadi satu, sama seperti Engkau dan Aku adalah satu. ");
INSERT INTO indags_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ketika saya bersama mereka, saya melindungi mereka atas nama Engkau yang Engkau berikan kepada saya. Saya menjaga mereka sehingga tidak ada yang hilang kecuali ‘anak yang hilang’, sehingga Kitab Suci digenapi. ");
INSERT INTO indags_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tetapi sekarang Aku datang kepada-Mu, dan Aku katakan hal-hal ini selagi Aku masih berada di dunia ini, supaya mereka bisa bersuka cita, sama seperti Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Aku memberi mereka pesan Engkau, dan dunia membenci mereka karena mereka bukan dari dunia, sama seperti Aku bukan dari dunia. ");
INSERT INTO indags_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aku tidak minta Engkau membawa mereka keluar dari dunia ini Tetapi Aku minta Engkau melindungi mereka dari si jahat. ");
INSERT INTO indags_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mereka bukan milik dunia ini sama seperti Aku bukan milik dunia ini. ");
INSERT INTO indags_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jadikan mereka kudus dengan kebenaran; Kata Engkau adalah kebenaran. ");
INSERT INTO indags_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sama seperti Engkau mengutus Aku ke dunia ini, Aku juga mengutus mereka ke seluruh dunia. ");
INSERT INTO indags_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Saya mendedikasikan diri saya untuk mereka agar mereka juga benar-benar kudus. ");
INSERT INTO indags_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Aku tidak berdoa hanya untuk mereka, Aku juga berdoa untuk orang-orang yang akan percaya kepada-Ku karena apa yang mereka katakan. ");
INSERT INTO indags_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aku berdoa agar mereka semua menjadi satu, sama seperti Engkau, Bapa, hidup di dalam Aku, dan Aku hidup di dalam Engkau, sehingga mereka juga dapat hidup di dalam Kami sehingga dunia akan percaya bahwa Engkau yang mengutus aku. ");
INSERT INTO indags_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aku telah memberi mereka kemuliaan yang Engkau berikan kepadaku, agar mereka menjadi satu, sama seperti Kami adalah satu. ");
INSERT INTO indags_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aku tinggal di dalam mereka, dan Engkau tinggal di dalam Aku. Semoga mereka benar-benar satu, sehingga seluruh dunia akan tahu bahwa Engkau yang mengutus Aku, dan bahwa Engkau mengasihi mereka, sama seperti Engkau mengasihi Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ya Bapa, Saya ingin orang-orang yang telah Engkau berikan kepada saya untuk bersama saya di mana saya berada. Dengan begitu mereka bisa melihat kemuliaan yang Engkau sudah berikan kepada-Ku, sebelum Engkau menciptakan dunia, karena Engkau mengasihi Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ya Bapa yang baik, dunia tidak mengenal Engkau, tetapi Aku mengenal-Mu dan murid-murid-Ku ini tahu bahwa Engkaulah yang sudah mengutus Aku. ");
INSERT INTO indags_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aku telah mengungkapkan karakter Engkau kepada mereka dan akan terus memberitahukannya, sehingga kasih yang Engkau miliki untuk-Ku akan ada di dalam mereka, dan Aku akan hidup di dalam mereka.” ");
INSERT INTO indags_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Setelah Yesus selesai berbicara, Dia dan murid-muridnya menyeberangi sungai Kidron dan pergi ke sebuah kebun zaitun. ");
INSERT INTO indags_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas yang mengkhianati Yesus juga sudah tahu tentang tempat ini. ");
INSERT INTO indags_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Maka Yudas membawa serta sepasukan prajurit beserta pengawal dari imam-imam kepala dan orang-orang Farisi. Mereka tiba di sana membawa obor, lentera, dan senjata. ");
INSERT INTO indags_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus sudah tahu semua yang akan terjadi kepada-Nya. Dia keluar untuk menerima mereka bertanya, “Siapa yang kalian cari?” ");
INSERT INTO indags_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jawab mereka, “Yesus dari Nazaret.” Jawab Yesus, “Akulah Dia.” Yudas yang sudah mengkhianati Yesus berada bersama mereka. ");
INSERT INTO indags_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ketika Yesus menjawab, “Akulah Dia,” mereka mundur beberapa langkah dan tiba-tiba jatuh ke tanah. ");
INSERT INTO indags_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesus kembali bertanya kepada mereka, “Siapakah yang kalian cari?” Jawab mereka, “Yesus dari Nazaret.” ");
INSERT INTO indags_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus kemudian berkata, “Aku sudah katakan bahwa Akulah Dia.” ");
INSERT INTO indags_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Dia katakan ini supaya perkataan-Nya yaitu, “Aku tidak kehilangan satu orang pun dari mereka yang sudah Engkau berikan kepada-Ku” menjadi nyata. ");
INSERT INTO indags_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kemudian Simon Petrus menghunus pedang dan memukul Malkus, hamba imam besar, memotong telinga kanannya. ");
INSERT INTO indags_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesus berkata kepada Petrus, “Singkirkan pedang itu! Apakah menurutmu aku tidak boleh meminum cawan penderitaan yang telah diberikan Bapa kepadaku?” ");
INSERT INTO indags_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kemudian kepala pasukan, anggota pasukannya dan penjaga-penjaga menangkap dan mengikat Yesus. ");
INSERT INTO indags_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mereka pertama-tama membawa-Nya kepada Annas. Dia adalah bapa dari istri Kayafas. Kayafas menjabat sebagai imam besar tahun itu. ");
INSERT INTO indags_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafas adalah orang yang pernah memberi nasehat kepada pemimpin-pemimpin Yahudi bahwa lebih baik satu orang mati untuk semua. ");
INSERT INTO indags_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrus dan satu orang murid yang lain mengikuti Yesus dari belakang. Murid yang satu itu mengenal imam besar, dan dia diizinkan masuk ke dalam halaman rumah imam besar bersama dengan Yesus, ");
INSERT INTO indags_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","tetapi Petrus berdiri menunggu di luar pintu pagar halaman. Jadi murid yang satu, yang sudah dikenal imam besar bicara dengan pembantu perempuan yang menjaga di pintu pagar dan Petrus diberi izin untuk masuk. ");
INSERT INTO indags_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pembantu itu bertanya kepada Petrus, “Bukankah Bapak salah satu murid Yesus?” Jawab Petrus, “Bukan, saya bukan murid-Nya!” ");
INSERT INTO indags_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Saat itu dingin, dan para pelayan serta penjaga berdiri di dekat api yang mereka buat, menghangatkan diri. Peter pergi dan berdiri bersama mereka, menghangatkan dirinya. ");
INSERT INTO indags_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imam besar bertanya kepada Yesus mengenai murid-murid-Nya dan juga tentang ajaran-Nya. ");
INSERT INTO indags_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jawab Yesus, “Aku sudah bicara dengan terbuka supaya semua bisa mendengar. Aku selalu mengajar di rumah-rumah pertemuan dan di rumah Tuhan di mana orang-orang Yahudi berkumpul Aku tidak pernah mengatakan sesuatu dengan sembunyi diam-diam. ");
INSERT INTO indags_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mengapa engkau bertanya saya? Orang-orang yang ada di sana mendengar Aku bicara. Tanyalah mereka apa yang Aku katakan. Mereka tahu apa yang saya dikatakan.” ");
INSERT INTO indags_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ketika Yesus menjawab seperti itu, salah satu petugas yang berdiri di situ memukul Yesus sambil berkata, “Apakah itulah caranya bicara dengan imam besar?” ");
INSERT INTO indags_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jawab Yesus, “Kalau Aku sudah membicarakan sesuatu yang salah, katakanlah dengan terus terang. Tetapi kalau Aku tidak mengatakan sesuatu yang salah, mengapa kamu memukul-Ku?” ");
INSERT INTO indags_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lalu Annas mengirim Yesus dengan tangan terikat kepada imam besar Kayafas. ");
INSERT INTO indags_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pada waktu Petrus sedang berdiri menghangatkan badan di dekat api, salah satu orang yang berdiri di situ bertanya kepadanya, “Bukankah kamu juga salah satu murid orang itu?” Tetapi Petrus menyangkal dan menjawab, “Bukan!” ");
INSERT INTO indags_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Salah satu pelayan imam besar, kerabat dari pria yang telinganya dipotong Petrus, bertanya kepada Petrus, “Apakah aku tidak melihatmu di kebun zaitun bersama-Nya?” ");
INSERT INTO indags_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sekali lagi Petrus menjawab “Tidak!” Dan pada saat itu juga, ayam jantan berkokok. ");
INSERT INTO indags_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pagi-pagi sekali mereka membawa Yesus dari Kayafas ke istana gubernur Romawi. Para pemimpin Yahudi tidak memasuki istana karena jika mereka melakukannya, mereka akan menjadi najis secara seremonial dan mereka ingin dapat makan makanan Paskah. ");
INSERT INTO indags_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Maka Pilatus keluar menemui mereka. “Tuduhan apa yang kamu ajukan terhadap orang ini?” dia bertanya. ");
INSERT INTO indags_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jawab mereka, “Kalau orang ini bukan penjahat, tidak mungkin kami membawa-Nya ke sini.” ");
INSERT INTO indags_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus menjawab mereka, “Lalu bawalah Dia pergi dari sini dan adili Dia sesuai dengan hukum kalian.” Tetapi jawab pemimpin-pemimpin itu, “Kami tidak diperbolehkan membunuh seseorang.” ");
INSERT INTO indags_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ini menggenapi apa yang Yesus katakan tentang bagaimana Dia akan mati. ");
INSERT INTO indags_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kemudian Pilatus masuk kembali ke dalam istana gubernur. Dia memanggil Yesus dan bertanya kepada-Nya, “Apakah Engkau adalah Raja orang Yahudi?” ");
INSERT INTO indags_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jawab Yesus, “Apakah engkau bertanya karena engkau sendiri berpikir bahwa Aku memang Raja, ataukah engkau bertanya karena itu yang dikatakan orang lain tentang diri-Ku?” ");
INSERT INTO indags_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jawab Pilatus, “Apakah saya ini orang Yahudi?! Bangsa-Mu sendiri dan pemimpin-pemimpin dan imam-imam besar Yahudi yang membawa-Mu ke sini. Katakanlah, apa yang sudah Engkau lakukan?” ");
INSERT INTO indags_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus menjawab, “Kerajaan-Ku bukan dari dunia ini. Jika itu dari dunia ini, rakyat-Ku akan berjuang agar Aku tidak diserahkan kepada orang-orang Yahudi. Tapi kerajaan-Ku bukan dari sini.” ");
INSERT INTO indags_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jawab Pilatus, “Oh, kalau begitu memang kamu seorang raja?” Yesus menjawab, “Engkaulah yang katakan bahwa Aku seorang Raja. Aku dilahirkan untuk ini. Aku datang ke dunia ini untuk ini, untuk memberi bukti atas kebenaran. Siapa pun yang senang mendengar tentang kebenaran akan mendengarkan apa yang Aku katakan.” ");
INSERT INTO indags_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tanya Pilatus, “Apakah kebenaran itu?” Sesudah dia berkata itu, dia keluar dan berkata kepada orang-orang Yahudi, “Saya tidak bisa mencari kesalahan-Nya, Dia tidak bersalah!” ");
INSERT INTO indags_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Kalian mempunyai kebiasaan bahwa dalam perayaan Paskah, kalian meminta saya membebaskan seorang tahanan. Jadi, bagaimana? Apakah saya membebaskan saja, Raja orang Yahudi ini?” ");
INSERT INTO indags_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Semua yang berkumpul di sana berteriak, “Tidak! Jangan orang ini! Bebaskan saja Barabas!” Barabas adalah seorang yang ditahan karena adalah seorang pemberontak. ");
INSERT INTO indags_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kemudian Pilatus memberi perintah agar Yesus dibawa dan dicambuk. ");
INSERT INTO indags_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pasukannya membuat lingkaran dari duri-duri seperti mahkota dan meletakkannya di kepala Yesus, dan mengenakan jubah ungu padanya. ");
INSERT INTO indags_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kata mereka, “Hidup, hai Raja orang Yahudi!” lalu mereka menampar muka Yesus. ");
INSERT INTO indags_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kemudian Pilatus keluar lagi untuk bertemu orang-orang lagi dan berkata kepada mereka, “Lihatlah, saya membawa orang ini dihadapan kalian. Saya lakukan ini karena saya tidak bisa mencari kesalahan-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lalu Yesus keluar. Di atas kepala-Nya ada mahkota duri dan Dia memakai baju meungu. Pilatus berkata, “Inilah dia!” ");
INSERT INTO indags_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ketika imam-imam besar dan penjaga-penjaga rumah Tuhan melihat Yesus, mereka berteriak, “Salibkan Dia! Salibkan Dia!” Jawab Pilatus, “Pergilah dan salibkan Dia sendiri! Saya tidak mendapat bukti bahwa Dia bersalah!” ");
INSERT INTO indags_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jawab pemimpin-pemimpin Yahudi itu kepadanya, “Kami punya sebuah hukum. Hukum itu berkata dia harus mati, karena Dia menyebut diri-Nya sebagai Anak Allah.” ");
INSERT INTO indags_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ketika Pilatus mendengar apa yang mereka katakan, dia menjadi takut. ");
INSERT INTO indags_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilatus masuk kembali ke dalam istananya dan bertanya kepada Yesus, “Engkau datang dari mana?” Tetapi Yesus tidak menjawabnya. ");
INSERT INTO indags_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus bertanya lagi, “Mengapa tidak jawab? Apakah Engkau tidak tahu bahwa saya memiliki kuasa untuk salibkan atau membebaskan-Mu?” ");
INSERT INTO indags_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jawab Yesus, “Engkau tidak ada kuasa di atas Aku kalau bukan Allah yang memberimu kuasa. Oleh karena itu, orang yang sudah menyerahkan Aku kepadamu sudah membuat dosa yang lebih besar.” ");
INSERT INTO indags_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sesudah itu, Pilatus berusaha untuk bebaskan Yesus, tetapi orang-orang Yahudi berteriak, “Kalau engkau membebaskan orang ini, berarti engkau bukan sahabat Kaisar! Siapa pun orang yang menyebut dirinya raja berarti melawan Kaisar!” ");
INSERT INTO indags_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ketika Pilatus mendengar ini, dia membawa Yesus keluar dan duduk di kursi pengadilan di sebuah tempat yang disebut Perkerasan Batu (Gabbatha dalam bahasa Ibrani). ");
INSERT INTO indags_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hari sudah siang, hari sebelum perayaan Paskah. Pilatus berkata kepada orang-orang Yahudi, “Lihatlah, inilah Raja kalian!” ");
INSERT INTO indags_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mereka berteriak, “Bunuh Dia! Bunuh Dia! Salibkan Dia!” Pilatus berkata kepada mereka, “Apakah kalian mau saya salibkan Dia?” Jawab imam-imam besar, “Hanya Kaisar yang adalah raja kami.” ");
INSERT INTO indags_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jadi Pilatus menyerahkan Yesus kepada mereka untuk disalibkan. ");
INSERT INTO indags_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mereka membawa Yesus pergi. Yesus sendiri keluar dengan memikul salib-Nya sendiri ke tempat yang disebut “Tempat Tengkorak” (“Golgota” dalam bahasa Ibrani). ");
INSERT INTO indags_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Di sana mereka salibkan Yesus. Ada dua orang lain yang juga disalibkan. Satu di sebelah kanan Yesus, dan yang satunya lagi di sebelah kiri. Yesus disalibkan di antara mereka. ");
INSERT INTO indags_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus sudah menyuruh untuk memasang sebuah papan dengan tulisan, “Yesus dari Nazaret, Raja orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Banyak orang membaca pemberitahuan itu karena tempat di mana Yesus disalibkan berada di dekat kota, dan itu ditulis dalam bahasa Ibrani, Latin, dan Yunani. ");
INSERT INTO indags_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Imam-imam kepala berkata kepada Pilatus, “Jangan menulis ‘Raja orang Yahudi’, tetapi tulislah, ‘Orang ini berkata dia adalah Raja orang Yahudi.’” ");
INSERT INTO indags_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jawab Pilatus, “Apa yang sudah saya perintahkan untuk ditulis, sudah ditulis!” ");
INSERT INTO indags_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Waktu pasukan salibkan Yesus ke kayu salib, mereka mengambil pakaian-Nya dan membagi baju-Nya menjadi empat bagian. Setiap mereka mendapat satu bagian. Lalu mereka mengambil baju luar-Nya. Baju-Nya itu tidak dijahit tetapi terbuat dari satu potong kain tenun jadi tidak ada sambungan. ");
INSERT INTO indags_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mereka saling bicara, katanya, “Jangan merobeknya. Tetapi mari kita membuang undi untuk melihat siapa ya memenangkan baju itu.” Apa yang tertulis dalam Kitab Suci menjadi nyata, bahwa “Mereka akan membagi-bagikan pakaian-Ku di antara mereka dan membuang undi untuk melihat siapa yang memenangkan baju luar itu.” Jadi inilah yang mereka lakukan. ");
INSERT INTO indags_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Berdiri di dekat salib adalah ibu-Nya, saudara perempuan ibu-Nya, istri Kleopas yang juga bernama Maria, dan Maria Magdalena. ");
INSERT INTO indags_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus melihat ibu-Nya dan juga murid-Nya yang Dia kasihi. Dia berkata kepada ibu-Nya, “Ibu, ini anakmu sekarang!” ");
INSERT INTO indags_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dan Yesus berkata kepada murid-murid-Nya, “Ini ibumu! Sejak saat itu, murid Yesus membawa pulang ibu Yesus untuk tinggal di rumahnya. ");
INSERT INTO indags_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus sekarang menyadari bahwa Dia telah menyelesaikan semua yang harus Dia lakukan. Dalam pemenuhan Kitab Suci, Dia berkata, Aku haus.” ");
INSERT INTO indags_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sebuah botol cuka anggur berdiri di sana, jadi mereka merendam spons di dalam cuka, meletakkannya di atas sebatang hisop, dan menempelkannya ke bibir-Nya. ");
INSERT INTO indags_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus mengisap sedikit air cuka. Dia berkata, “Sudah selesai!” Lalu menundukkan kepala-Nya dan mati. ");
INSERT INTO indags_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Itu adalah hari persiapan sebelum Sabat, yang adalah hari yang istimewa dalam perayaan Paskah. Pemimpin-pemimpin Yahudi tidak mau ada orang yang masih tergantung pada salib pada hari Sabat. Jadi mereka meminta kepada Pilatus izin untuk mematahkan kaki dari orang-orang yang disalibkan dan jenazah mereka diangkat dari tempat itu. ");
INSERT INTO indags_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pasukan datang, mematahkan kaki dari kedua orang yang disalibkan di sebelah kiri dan kanan Yesus. ");
INSERT INTO indags_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ketika gilirannya Yesus, mereka melihat bahwa Dia sudah mati, jadi mereka tidak mematahkan kaki-Nya. ");
INSERT INTO indags_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Salah satu anggota pasukan menikam lambung Yesus. Dan saat itunjuga keluar darah dan air. ");
INSERT INTO indags_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Orang yang melihat itu terjadi menceritakan apa yang dilihatnya upaya kalian bisa percaya. Apa yang dia katakan adalah benar dan orang itu yang tahu kebenaran. ");
INSERT INTO indags_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Apa yang tertulis dalam Kitab Suci, “Tidak akan ada satu tulang pun yang patah.” ");
INSERT INTO indags_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tertulis juga, “Mereka akan melihat kepada orang yang mereka tikam dengan tombak.” ");
INSERT INTO indags_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sesudah itu, orang yang bernama Yusuf dari Arimatea yang adalah salah satu pengikut Yesus pergi menghadap Pilatus untuk meminta izin untuk memindahkan mayat Yesus. Pilatus memberikan izin, jadi Yusuf kembali dan membawa mayat-Nya untuk dikubur. ");
INSERT INTO indags_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus juga datang dan membantu Yusuf. Nikodemus adalah orang yang pernah ketemu dengan Yesus di malam hari. Dia membawa ramuan yang berbau harum Ramuan itu terbuat dari campuran mur dan gaharu seberat lebih dari tiga puluh kilogram. ");
INSERT INTO indags_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sesuai dengan adat Yahudi, mereka menggosok ramuan itu pada tubuh Yesus, lalu membungkus tubuh-Nya dengan kain linen. ");
INSERT INTO indags_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ada sebuah taman di dekat tempat Yesus disalibkan; dan di taman itu ada makam baru yang tidak terpakai. ");
INSERT INTO indags_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mereka membaringkan tubuh Yesus di situ, karena matahari sudah hampir terbenam dan sudah hampir memasuki hari Sabat. ");
INSERT INTO indags_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pagi-pagi sekali pada hari pertama minggu itu, ketika hari masih gelap, Maria Magdalena pergi ke kuburan. Dia melihat bahwa batu besar yang menutupi pintu kubur sudah dipindahkan. ");
INSERT INTO indags_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dia berlari untuk mencari Simon Petrus dan juga murid yang Yesus kasihi. Maria berkata kepada mereka, “Ada orang yang sudah mengambil mayat Tuhan dari kuburan, dan kami tidak tahu mereka membawanya ke mana.” ");
INSERT INTO indags_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Saat Petrus dan muridnya itu pergi ke kuburan itu. ");
INSERT INTO indags_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mereka berdua lari, tetapi muridnya yang lain itu berlari lebih cepat dan duluan tiba di kubur. ");
INSERT INTO indags_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dia menunduk ke dalam kuburan dan melihat kain pembungkus mayat ada di situ, tetapi dia tidak masuk. ");
INSERT INTO indags_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saat Simon Petrus tiba dia masuk ke dalam. Dia juga hanya melihat kain pembungkus mayat di situ. ");
INSERT INTO indags_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dia juga melihat kain yang digunakan untuk membungkus kepala Yesus. Kain itu sudah terlipat dan ditaruh sendiri. ");
INSERT INTO indags_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kemudian murid Yesus yang pertama sampai di sana juga masuk ke dalam kubur dan saat dia sendiri melihat, dan percaya. ");
INSERT INTO indags_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Saat itu, mereka belum mengerti apa yang tertulis dalam Kitab Suci bahwa Yesus akan hidup kembali. ");
INSERT INTO indags_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sesudah itu, mereka berdua pulang. ");
INSERT INTO indags_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalena berdiri diluar kubur sambil menangis. Dia masih menangis ketika dia menunduk untuk melihat ke dalam kuburan. ");
INSERT INTO indags_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Dan dia melihat ada dua malaikat yang berpakaian putih sedang duduk di tempat bekas mayat Yesus ditaruh. Yang satu duduk di bagian kepala dan yang satunya lagi di bagian kaki. ");
INSERT INTO indags_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kedua malaikat lalu bertanya kepadanya, “Mengapa kamu menangis?” Dia menjawab, “Saya menangis karena mayat Tuhan saya sudah diambil, dan saya tidak tahu mereka memindahkan dia ke mana.” ");
INSERT INTO indags_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dia lalu berbalik dan melihat bahwa Yesus sedang berdiri di situ. Tetapi Maria tidak kenal Dia. ");
INSERT INTO indags_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kata Yesus kepadanya, “Kenapa kamu menangis? Siapa yang sedang kamu cari?” Maria berpikir bahwa Orang yang sedang bicara itu adalah tukang kebun. Jadi dia jawab, “Kalau Bapak yang ambil mayat Yesus, tolong kasih tahu, di mana mayatnya dibawa, supaya saya bisa ambil dan kuburkan kembali.” ");
INSERT INTO indags_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus berkata kepadanya, “Maria!” Maria pun berbalik dan berkata kepada Dia, “Guru!” ");
INSERT INTO indags_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus berkata kepada-Nya, “Jangan berpegang kepada-Ku! Aku belum naik kepada Bapa. Tetapi carilah saudara-saudara-Ku dan katakan kepada mereka bahwa aku akan naik kepada Bapa-Ku, dan Bapamu, Allah-Ku dan Allahmu.” ");
INSERT INTO indags_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalena pergi dan berkata kepada murid-murid, “Aku sudah melihat Tuhan!” Dia juga sampaikan kepada mereka apa yang sudah Dia katakan kepadanya. ");
INSERT INTO indags_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Malam itu, pada hari pertama minggu itu, ketika para murid berkumpul bersama di balik pintu yang terkunci karena mereka takut kepada orang-orang Yahudi, Yesus datang dan berdiri di antara mereka dan berkata, “Semoga ada kedamaian bagi kalian.” ");
INSERT INTO indags_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Setelah salam ini Dia menunjukkan kepada mereka tangan dan lambung-Nya. Para murid sangat bersukacita melihat Tuhan. ");
INSERT INTO indags_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus lalu berkata, “Aku mengutus kalian, sama seperti Bapa-Ku sudah mengutus Aku.” ");
INSERT INTO indags_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lalu Dia meniupkan nafas-Nya kepada mereka dan berkata, “Terimalah Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kalau kalian mengampuni dosa-dosa seseorang, mereka akan diampuni. Tetapi kalau kalian tidak mengampuni dosa-dosa, mereka tidak akan diampuni.” ");
INSERT INTO indags_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Saat Yesus memperlihatkan diri-Nya kepada murid-murid, ada salah satu dari mereka yang tidak hadir. Dia bernama Tomas, yang juga dipanggil “si Anak Kembar.” ");
INSERT INTO indags_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jadi murid-murid yang lain sampaikan kepada dia, “Kami sudah melihat Tuhan!” Tetapi Tomas menjawab, “Saya tidak akan percaya sebelum saya melihat sendiri bekas luka paku di kedua tangan-Nya, dan memasukkan jari saya ke dalam bekas luka itu, dan juga memasukkan tanganku ke dalam bekas luka tombak pada lambung-Nya.” ");
INSERT INTO indags_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Satu minggu kemudian murid-murid sekali lagi sedang berkumpul. Saat itu, Tomas juga ada bersama mereka. Ketika Yesus memasuki ruangan saat pintu-pintu ruangan itu masih dalam terkunci dan berdiri di tengah-tengah mereka dan berkata, “Semoga ada kedamaian bagi kalian.” ");
INSERT INTO indags_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lalu Dia berkata kepada Tomas, “Lihatlah tangan-Ku dan masukanlah jarimu. Masukan juga tanganmu ke dalam bekas luka tombak pada lambung-Ku. Jangan ragu-ragu lagi, tetapi percayalah!” ");
INSERT INTO indags_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jawab Tomas, “Engkau memang Tuhanku dan Allahku!” ");
INSERT INTO indags_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus berkata, “Tomas, apakah sekarang kamu percaya karena sudah melihat Aku? Allah sangat memberkati orang-orang yang percaya walaupun mereka tidak melihat Aku.” ");
INSERT INTO indags_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus melakukan banyak hal-hal ajaib yang lain di hadapan murid-murid-Nya, tetapi tidak semua tertulis dalam buku ini. ");
INSERT INTO indags_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yang tertulis di dalam buku ini supaya kalian bisa menjadi percaya bahwa Yesus adalah Mesias dan Dia adalah Anak Allah. Kalau kalian sungguh-sungguh percaya kepada-Nya, kalian akan mendapatkan hidup yang selama-lamanya. ");
INSERT INTO indags_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sesudah itu, Yesus memperlihatkan diri-Nya kepada murid-muridnya di tepi Danau Galilea. ");
INSERT INTO indags_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Murid-murid yang ada di sana adalah, Simon Petrus, Tomas (yang diberi nama panggilan, “Si Kembar”) Natanael dari Kana di Galilea, Yakobus dan Yohanes (anak-anak Zebedeus) dan juga dua orang muri Yesus yang lain. ");
INSERT INTO indags_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus kemudian berkata, “Aku akan pergi memancing.” Jawab mereka, “Kami akan pergi denganmu.” Lalu mereka pergi naik perahu. Tetapi sepanjang malam mereka tidak berhasil menangkap seekor ikan pun. ");
INSERT INTO indags_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Besok pagi ketika matahari terbit, Yesus berdiri di pantai, tetapi mereka tidak tahu bahwa yang berdiri itu Yesus. ");
INSERT INTO indags_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lalu Dia berkata kepada mereka dengan suara keras, “Hei teman-teman-Ku, apakah kalian sudah menangkap ikan?” Jawab murid-murid, “Belum.” ");
INSERT INTO indags_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kata Yesus, “Buanglah jala kalian ke sebelah kanan perahu kalian, dan kalian akan mendapatkan banyak ikan!” Jadi mereka melakukan apa yang diperintahkan-Nya, dan mereka tidak mampu menarik jala karena penuh dengan ikan. ");
INSERT INTO indags_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Murid yang dikasihi Yesus berkata kepada Petrus, “Itu Tuhan!” Ketika Simon Petrus mendengar itu, dia memakai lagi jubahnya, karena sebelumnya dia sudah melepaskan jubanya saat sedang bekerja, lalu dia melompat ke dalam air dan berenang ke tepi danau. ");
INSERT INTO indags_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Murid-murid yang lain tetap di dalam perahu dan menarik jala yang penuh dengan ikan ke pantai yang jaraknya sekitar seratus meter. ");
INSERT INTO indags_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ketika mereka sampai di pantai, mereka melihat ada roti dan ikan yang sedang dibakar di atas bara api. ");
INSERT INTO indags_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lalu Yesus berkata kepada mereka, “Bawalah kepada Aku, ikan yang baru saja kalian tangkap.” ");
INSERT INTO indags_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petrus naik ke dalam perahu dan menarik jala yang penuh dengan ikan-ikan besar, berjumlah seratus lima puluh tiga ekor. Walaupun jalanya begitu penuh dengan banyaknya jumlah ikan, jalanya tidak robek. ");
INSERT INTO indags_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus berkata kepada mereka, “Mari makan.” Tetapi tidak ada seorang pun dari murid-muridnya yang berani bertanya, “Bapak ini siapa?” Karena mereka sudah tahu bahwa itu Tuhan. ");
INSERT INTO indags_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kemudian Yesus datang mendekat, mengambil roti dan ikan itu dan bagikan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kejadian ini adalah ketiga kalinya Yesus memperlihatkan diri-Nya kepada mereka sesudah Dia hidup kembali. ");
INSERT INTO indags_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Sesudah mereka makan pagi, Yesus bertanya kepada Simon yang juga dipanggil Petrus, “Simon, anak Yohanes, apakah kamu mengasihi-Ku lebih daripada mereka yang lain mengasihi Aku?” Jawab Petrus, “Ya, Tuhan, Engkau tahu aku mencintai-Mu.” Lanjut Yesus kepadanya, “Kalau begitu, berilah makan domba-domba-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesus berkata lagi kepada dia, “Simon, anak Yohanes, apakah kamu mengasihiku.” Jawabnya, “Ya, Tuhan, Engkau tahu aku mencintai-Mu.” Yesus menjawab, “Kalau begitu, peliharalah domba-domba-Ku.” ");
INSERT INTO indags_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesus bertanya lagi untuk ketiga kalinya, “Simon, anak Yohanes, apakah kamu mengasihiku?” Petrus merasa sedih karena Yesus sudah bertanya pertanyaan yang sama tiga kali. Jadi dia jawab, “Tuhan, Engkau tahu segalanya. Engkau tahu aku mencintai-Mu.” Jawab Yesus, “Berilah makan domba-dombaku. ");
INSERT INTO indags_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Aku katakan kepadamu ketika kamu masih muda, kamu bisa berbuat sesukamu, pergi ke mana pun kamu suka. Tetapi ketika kamu sudah tua, kamu akan mengulurkan tanganmu, dan orang lain akan memakaikan kamu pakaian dan menuntunmu ke mana kamu tidak ingin pergi.” ");
INSERT INTO indags_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Dengan berkata seperti itu, Yesus menyatakan bagaimana nanti Petrus akan mati untuk memuliakan Allah. Yesus berkata lagi kepadana, “Ikuti aku!” ");
INSERT INTO indags_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus berbalik dan melihat murid kesayangan Yesus sedang mengikuti mereka. Dialah orang yang sama yang duduk berseblahan dengan Yesus ketika mereka makan, dan bertanya, “Tuhan, siapakah di antara kami yang akan mengkhianati-Mu?” ");
INSERT INTO indags_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jadi waktu Petrus melihat murid itu, dia bertanya kepada Yesus, “Tuhan, bagaimana dengan dia?” ");
INSERT INTO indags_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus berkata kepadanya, “Jika saya ingin dia tetap hidup di sini sampai saya kembali, mengapa itu menjadi perhatian kamu? Kamu mengikuti saya!” ");
INSERT INTO indags_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sebab itu, ada berita yang teserbar di antara orang-orang seiman bahwa murid itu tidak akan mati sebelum Yesus kembali. Tetapi Yesus tidak berkata seperti itu. Dia hanya mengatakan, “Kalau Aku mau supaya dia hidup sampai Aku kembali, maka hal itu bukan urusanmu.” ");
INSERT INTO indags_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Murid yang dimaksud itu yang memberikan kesaksian tentang semua kejadian ini. Dia menulisnya, dankami tahu apa yang dicatatnya itu adalah benar. ");
INSERT INTO indags_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus melakukan banyak hal yang lain. Kalau semua yang dilakukannya itu ditulis, maka saya rasa tidak akan ada cukup tempat untuk menyimpan semua buku itu di seluruh bumi. ");
INSERT INTO indags_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus yang terhormat, dalam bukuku yang pertama, aku menulis tentang semua yang Yesus lakukan dan ajarkan sejak dari awal pelayanan-Nya ");
INSERT INTO indags_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sampai pada hari Dia naik ke surga. Hal ini terjadi ketika Dia sudah memberikan instruksi melalui Roh Kudus kepada rasul-rasul pilihan-Nya. ");
INSERT INTO indags_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Selama 40 hari sesudah kematian yang Dia alami, Dia menunjukkan diri-Nya kepada mereka, membuktikan bahwa Dia hidup dengan bukti yang meyakinkan. Dia muncul di hadapan mereka, dan memberitahu mereka tentang Kerajaan Allah. ");
INSERT INTO indags_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sementara Yesus masih bersama mereka, Dia memberi mereka perintah, “Janganlah meninggalkan Yerusalem. Tunggulah sampai kalian menerima apa yang dijanjikan oleh Bapa di surga, seperti yang kalian dengar dari pada-Ku. ");
INSERT INTO indags_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Benar bahwa Yohanes membaptis kalian dengan air, tetapi dalam beberapa hari ke depan, kalian akan dibaptis oleh Roh Kudus.” ");
INSERT INTO indags_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jadi ketika para murid bertemu dengan Yesus, bertanyalah mereka, “Tuhan, apakah sekarang saatnya Engkau mendirikan kembali kerajaan Israel?” ");
INSERT INTO indags_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","“Kalian tidak perlu tahu tentang tanggal dan masa yang sudah ditetapkan oleh Bapa sesuai dengan otoritasnya,” kata Yesus kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","“Tetapi kalian akan diberikan kuasa ketika Roh Kudus turun ke atas kalian, dan kalian akan menjadi saksi-Ku di Yerusalem, di seluruh Yudea dan Samaria, dan sampai ke tempat yang paling jauh di muka bumi.” ");
INSERT INTO indags_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sesudah Yesus menyampaikan semua ini kepada mereka, Dia naik ke surga sementara mereka semua memperhatikan Dia, dan ada awan yang menutupi Dia dari pandangan mereka. ");
INSERT INTO indags_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sementara mereka masih menatap dengan seksama ke arah langit ketika Yesus naik, dua orang yang berpakaian putih tiba-tiba berdiri di sisi mereka. ");
INSERT INTO indags_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Hai orang-orang Galilea, mengapa kalian berdiri di sini sambil menatap langit?” tanya mereka. “Yesus yang sama yang naik ke surga akan datang dengan cara yang sama kalian melihat Dia naik.” ");
INSERT INTO indags_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lalu para murid kembali ke Yerusalem dari Bukit Zaitun yang jaraknya kira-kira satu kilometer dari kota itu. ");
INSERT INTO indags_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ketika mereka tiba, naiklah mereka ke ruangan atas tempat mereka tinggal: Petrus, Yohanes, Yakobus dan Andreas, Filipus dan Tomas, Bartolomeus dan Matius, Yakobus anak Alfeus, Simon orang Zelot, serta Yudas anak Yakobus. ");
INSERT INTO indags_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mereka semua bersatu dalam doa, bersama dengan para perempuan, dan juga Maria, ibu Yesus, beserta dengan saudara-saudara-Nya. ");
INSERT INTO indags_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pada waktu ini, Petrus berdiri dan menyapa sekitar 120 orang percaya yang sedang berkumpul bersama. ");
INSERT INTO indags_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Saudara dan saudariku,” katanya, “Kitab Suci, yang dikatakan oleh Roh Kudus melalui Daud, sudah tergenapi mengenai Yudas, yang memimpin mereka untuk menangkap Yesus. ");
INSERT INTO indags_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Dia tadinya terhitung sebagai salah satu di antara kami, dan berbagi dalam pelayanan ini.” ");
INSERT INTO indags_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudas membeli sebidang tanah dari uang kejatahannya. Di tempat itu dia terjatuh dengan kepala terlebih dahulu, dan seluruh tubuhnya terbelah, sehingga isi perutnya tertumpah keluar. ");
INSERT INTO indags_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Setiap orang yang hidup di Yerusalem mendengar tentang hal ini sehingga tanah itu dinamakan “Akeldama,” yang berarti, “Tanah darah.”) ");
INSERT INTO indags_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Seperti yang tertulis dalam kitab Mazmur, “Biarlah rumahnya ditinggalkan, dan tidak seorangpun yang hidup di sana,” dan “Biarlah orang lain yang akan mengambil posisinya.” ");
INSERT INTO indags_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Jadi sekarang kita harus memilih seseorang di antara kita yang sudah bersama-sama dengan kita sepanjang waktu ketika Yesus sudah bersama dengan kita, ");
INSERT INTO indags_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mulai dari ketika Yohanes membaptis sampai pada hari Yesus naik ke surga dari kita. Salah seorang dari mereka ini haruslah dipilih untuk bersama-sama dengan kami sebagai saksi, memberi bukti akan kebangkitan Yesus.” ");
INSERT INTO indags_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Akhirnya terpilihlah dua nama: Yusuf Yustus, atau Barsabas, dan Matias. ");
INSERT INTO indags_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mereka semua berdoa bersama, “Tuhan, Engkau tahu pikiran setiap kami, tolong tunjukkan siapa dari antara kedua orang ini yang Engkau pilih ");
INSERT INTO indags_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","untuk menggantikan posisi Yudas sebagai salah seorang rasul dalam pelayanan ini, yang sudah ditinggalkannya untuk pergi ke tempat yang sepantasnya untuk dia.” ");
INSERT INTO indags_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mereka lalu membuang undi, dan Matias yang terpilih. Dia terhitung sebagai salah satu rasul bersama dengan kesebelas rasul lainnya. ");
INSERT INTO indags_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ketika tiba hari Pentakosta, mereka semua bertemu bersama dalam satu tempat. ");
INSERT INTO indags_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tiba-tiba ada suara datang dari surga seperti angin yang menderu yang memenuhi seluruh rumah tempat mereka tinggal. ");
INSERT INTO indags_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mereka melihat api yang berbentuk seperti lidah yang terpisah-pisah di atas masing-masing mereka. ");
INSERT INTO indags_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Semua mereka dipenuhi dengan Roh Kudus dan mulai berbicara dengan bahasa yang berbeda sesuai dengan kemampuan yang diberikan Roh itu kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pada waktu itu ada orang-orang beragama Yahudi yang sungguh-sungguh mencari Allah yang datang dari seluruh penjuru dunia sedang berkumpul di kota Yerusalem. ");
INSERT INTO indags_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ketika kerumunan orang ini mendengar suara ini, segerombolan orang berkumpul. Mereka bertanya-tanya sebab setiap mereka mendengar bahasa mereka sendiri diucapkan. ");
INSERT INTO indags_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mereka sungguh-sungguh terkesan, dan berkata, “Dengar, orang-orang yang berbicara ini — bukankah mereka semua orang-orang Galilea? ");
INSERT INTO indags_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Jadi bagaimana mungkin kita semua mendengar mereka berbicara dalam bahasa kita sendiri? ");
INSERT INTO indags_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kita ini adalah orang-orang Partia, Media, Elam, Mesopotamia, Yudea, Kapadokia Pontus, Asia, ");
INSERT INTO indags_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Mesir, daerah-daerah di wilayah Libia dekat Kirene, pendatang dari Roma, baik mereka penganut agama Yahudi maupun yang baru ikut, ");
INSERT INTO indags_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","orang Kreta dan orang Arab — dan kita mendengar mereka berbicara dengan bahasa kita sendiri tentang semua perbuatan ajaib yang sudah Allah lakukan.” ");
INSERT INTO indags_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mereka semua tertegun dan bingung. “Apa arti dari semua ini?” tanya mereka satu sama lain. ");
INSERT INTO indags_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tetapi ada juga yang mengejek dan berkata, “Mereka pasti minum terlalu banyak air anggur dan mabuk!” ");
INSERT INTO indags_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lalu Petrus berdiri bersama dengan ke sebelas rasul lainnya dan berbicara dengan suara keras: “Saudara-saudari orang Yahudi dan setiap mereka yang tinggal di Yerusalem: perhatikanlah aku dan aku akan menjelaskan segala kejadian ini kepada kalian! ");
INSERT INTO indags_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Orang-orang ini tidak mabuk seperti sangkaan kalian. Saat ini barulah pukul sembilan pagi! ");
INSERT INTO indags_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Apa yang sedang terjadi di sini sudah dinubuatkan oleh nabi Yoel: ");
INSERT INTO indags_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Allah berkata: Pada hari-hari terakhir Aku akan mencurahkan Rohku kepada setiap orang. Anak-anak laki-laki dan perempuanmu akan bernubuat. Para pemuda dan pemudimu akan mendapat penglihatan. Dan orang-orang tuamu akan mendapat mimpi. ");
INSERT INTO indags_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aku akan mencurahkan Roh-Ku ke atas para pekerja-Ku, baik laki-laki maupun perempuan, dan mereka akan bernubuat. ");
INSERT INTO indags_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aku juga akan memberikan kepada kalian tanda-tanda ajaib baik di surga maupun di bumi — darah, api dan gumpalan asap! ");
INSERT INTO indags_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Matahari akan menjadi gelap, dan bulan akan berubah menjadi semerah darah sebelum tibanya hari Tuhan yang dahsyat dan mulia. ");
INSERT INTO indags_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tetapi mereka yang memanggil nama Tuhan akan diselamatkan.’ ");
INSERT INTO indags_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hai orang Israel, dengarkanlah ini: Yesus orang Nazaret adalah seorang yang diutus oleh Allah kepada kalian. Hal ini terbukti dengan tanda-tanda dan perbuatan ajaib yang Allah lakukan melalui Dia, ada di antara kalian — seperti yang kalian ketahui. ");
INSERT INTO indags_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Allah, sudah mengetahui sebelumnya apa yang akan terjadi, mengikuti rencana yang sudah Dia tetapkan dan memutuskan menyerahkan Yesus ke dalam tangan kalian. Dan dengan bantuan orang-orang jahat, kalian membunuh Dia dengan memaku Dia di atas kayu salib. ");
INSERT INTO indags_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tetapi Allah membangkitkan Dia kembali, membebaskan Dia dari kuasa kematian, sebab kematian tidak lagi memiliki kuasa untuk menawan Dia. ");
INSERT INTO indags_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daud berkata tentang Dia, ‘Aku melihat Tuhan selalu ada mendahului Aku. Aku tidak akan tergoncangkan, sebab Dia ada di sisi-Ku. ");
INSERT INTO indags_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Itu sebabnya hati-Ku bersukacita! Itu sebabnya ucapan-Ku riang gembira! Itu sebabnya tubuh-Ku hidup dalam pengharapan! ");
INSERT INTO indags_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sebab Engkau tidak akan meninggalkanku di dalam Hades, ataupun membiarkan Orang Kudus-Mu mengalami kehancuran. ");
INSERT INTO indags_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sudah Engkau nyatakan jalan kehidupan kepada-Ku. Dengan kehadiran-Mu Engkau memenuhiku dengan sukacita.’ ");
INSERT INTO indags_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Saudara dan saudariku, ijinkan aku mengatakan kepada kalian dengan terus terang, bahwa nenek moyang kita Daud, sudah mati dan dikuburkan, dan kuburannya masih ada bersama dengan kita hingga hari ini. ");
INSERT INTO indags_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tetapi Daud adalah seorang nabi, dan tahu bahwa Allah sudah berjanji dengan bersumpah untuk membuat salah satu keturunannya akan menduduki tahtanya. ");
INSERT INTO indags_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daud sudah melihat apa yang akan terjadi dan berbicara tentang kebangkitan Kristus — sebab Kristus tidak akan ditinggalkan di liang kubur ataupun Dia akan membusuk di dalamnya. ");
INSERT INTO indags_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Allah sudah membangkitkan Yesus dari orang mati, dan kami semua adalah saksi dari hal itu. ");
INSERT INTO indags_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sekarang Dia sudah ditinggikan dan mendapat tempat yang paling terhormat di sebelah kanan Allah, dan sudah menerima dari Bapa di Surga, Roh Kudus yang Dia janjikan, dan sudah mencurahkan Roh itu, dan itulah yang saat ini sedang kalian lihat dan dengar. ");
INSERT INTO indags_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sebab Daud sendiri tidak naik ke surga, tetapi dia berkata, ‘Tuhan berkata kepada Tuanku, Duduklah di sebelah kanan-Ku ");
INSERT INTO indags_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampai Aku membuat musuh-musuh-Mu menjadi alat tempat Engkau mengistirahatkan kaki-Mu.’ ");
INSERT INTO indags_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sekarang biarlah setiap orang yang ada di Israel benar-benar yakin akan hal ini: Allah sudah membuat Yesus, yang kalian salibkan, adalah Tuhan dan Mesias!” ");
INSERT INTO indags_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ketika orang-orang mendengar hal ini, hati nurani mereka disadarkan. Mereka bertanya kepada Petrus dan rasul-rasul lainnya, “Saudara, apa yang harus kami lakukan?” ");
INSERT INTO indags_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","“Bertobat!” kata Petrus kepada mereka. “Semua kalian haruslah dibaptis dalam nama Yesus Kristus untuk pengampunan dosa kalian, dan kalian akan menerima Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Janji ini diberikan kepada kalian, anak-anak kalian, dan juga kepada semua yang ada di tempat yang jauh — kepada semua orang yang Tuhan Allah kita panggil.” ");
INSERT INTO indags_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus terus berbicara, memberikan lebih banyak bukti kepada mereka. Dia memperingati mereka, “Selamatkanlah diri kalian dari generasi yang jahat ini.” ");
INSERT INTO indags_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dan mereka yang menerima ucapannya, ikut dibaptis, menambah jumlah mereka sekitar 3.000 orang percaya pada hari itu. ");
INSERT INTO indags_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mereka rajin mempelajari ajaran para rasul, juga sering berkumpul di antara para orang percaya untuk bersekutu, mengadakan Perjamuan memecahkan roti seperti yang Yesus lakukan, serta berdoa bersama. ");
INSERT INTO indags_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Setiap orang terkagum-kagum, dan banyak tanda dan perbuatan ajaib yang dilakukan oleh para rasul. ");
INSERT INTO indags_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Semua orang percaya berkumpul dan saling berbagi milik kepunyaan mereka. ");
INSERT INTO indags_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mereka menjual seluruh kepunyaan mereka, dan membagikan hasil penjualannya kepada setiap orang sesuai dengan kebutuhan mereka. ");
INSERT INTO indags_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Setiap hari mereka terus berkumpul bersama di rumah Tuhan, dan makan bersama di rumah-rumah mereka. Mereka menikmati jamuan sederhana mereka dengan rendah hati dan penuh sukacita. Mereka memuji Allah, dan setiap orang senang kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Setiap hari Tuhan menambahkan jumlah orang percaya ke dalam persekutuan mereka. ");
INSERT INTO indags_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petrus dan Yohanes sedang dalam perjalanan menuju ke rumah Tuhan untuk berdoa pada pukul 3 sore. ");
INSERT INTO indags_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Seorang yang lumpuh sejak lahir sedang dibawa ke sana. Setiap hari dia diletakkan di samping pintu gerbang rumah Tuhan yang dinamakan Gerbang “Indah” agar dia bisa mengemis dari orang-orang yang akan pergi ke rumah Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lalu orang itu melihat Petrus dan Yohanes yang akan masuk ke dalam rumah Tuhan dan meminta sedekah dari mereka. ");
INSERT INTO indags_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petrus dan Yohanes menatap orang itu. “Lihat kami!” kata Petrus. ");
INSERT INTO indags_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Si orang lumpuh itu memberikan mereka perhatian penuh, berharap agar ia menerima sesuatu dari mereka. ");
INSERT INTO indags_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","“Aku tidak punya uang perak ataupun emas,” kata Petrus kepadanya, “tetapi aku akan memberikan kepadamu apa yang aku punya. Dalam nama Yesus Kristus orang Nazaret itu, berjalanlah!” ");
INSERT INTO indags_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petrus mengambil tangan kanan si pengemis itu dan menolong dia berdiri. Dengan segera kaki dan tumitnya menjadi kuat. ");
INSERT INTO indags_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Si pengemis itu melompat, dan mulai berjalan. Dia masuk ke dalam rumah Tuhan bersama mereka, berjalan dan melompat dan memuji Allah. ");
INSERT INTO indags_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Setiap orang yang di sana melihat dia berjalan berkeliling dan memuji Allah. ");
INSERT INTO indags_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mereka mengenali dia sebagai pengemis yang biasa duduk di Pintu Gerbang Indah rumah Tuhan, dan mereka terkejut dan heran dengan apa yang sudah terjadi padanya. ");
INSERT INTO indags_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Orang itu terus mengikuti Petrus dan Yohanes sementara setiap orang lari menghampiri mereka di dalam teras yang disebut Serambi Salomo dengan penuh kekaguman dengan apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ketika Petrus melihat kesempatan untuk dia berbicara, berkatalah dia kepada orang banyak itu, “Hai orang Israel, mengapa kalian terkejut dengan apa yang sudah terjadi pada orang ini? Mengapa kalian menatap kami seakan-akan karena kuasa kami atau iman yang membuat kami bisa membuat dia berjalan? ");
INSERT INTO indags_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Allah Abraham, Isak dan Yakub — Allah nenek moyang kita — sudah meninggikan Yesus, hamba-Nya. Dialah yang kalian khianati dan kalian tolak di hadapan Pilatus, bahkan sesudah Pilatus memutuskan untuk melepaskan dia. ");
INSERT INTO indags_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kalian sudah menolak Dia yang Kudus dan Benar, dan menuntut agar seorang pembunuh dibebaskan untuk kalian. ");
INSERT INTO indags_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kalian sudah membunuh Penulis kehidupan, yang Allah bangkitkan dari antara orang mati — dan kami adalah saksi dari semua ini. ");
INSERT INTO indags_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dengan mempercayai nama Yesus, laki-laki ini disembuhkan oleh-Nya. Kalian lihat laki-laki itu di sini, kalian mengenal dia. Melalui rasa percaya kepada Yesus, orang ini menerima kesembuhan total tepat di hadapan kalian semua. ");
INSERT INTO indags_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Sekarang aku tahu, saudara dan saudariku, kalian melakukan hal ini oleh karena ketidak tahuan kalian, sama seperti pemimpin kalian. ");
INSERT INTO indags_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tetapi Allah menggenapi apa yang sudah Dia nubuatkan melalui semua nabi: yaitu bahwa Mesias akan menderita. ");
INSERT INTO indags_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sekarang bertobatlah, dan ubahkan cara hidupmu, agar dosa-dosa kalian bisa dihapuskan, agar Tuhan dapat memberikan kesempatan bagi kalian untuk disembuhkan dan dipulihkan, ");
INSERT INTO indags_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","dan mengirim Yesus, sang Mesias yang dipilih Allah bagi kalian. ");
INSERT INTO indags_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sebab Dia harus tetap di surga sampai tiba waktunya segala sesuatunya kembali seperti semula, seperti Allah nyatakan melalui nabi-nabinya yang kudus sejak jaman dulu. ");
INSERT INTO indags_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa berkata, ‘Tuhan Allah akan mengirimkan kepada kalian seorang nabi dari antara bangsa kita sendiri yang seperti diriku. Kalian haruslah mendengarkan segala yang Dia katakan kepada kalian. ");
INSERT INTO indags_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Siapa saja yang tidak mendengarkan Dia akan benar-benar dipisahkan dari masyarakatnya.’ ");
INSERT INTO indags_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Semua nabi yang sudah berbicara, mulai dari Samuel, sudah menubuatkan tentang hari ini. ");
INSERT INTO indags_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kalian adalah anak dari para nabi dan perjanjian yang Allah buat dengan nenek moyang kalian ketika Allah berkata kepada Abraham, ‘Dari keturunanmulah seluruh keluarga di seluruh dunia akan diberkati.’ ");
INSERT INTO indags_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Allah menyiapkan Hamba-Nya dan mengirimkan Dia lebih dahulu kepada kalian, untuk memberkati kalian dengan mengubah kalian masing-masing dari jalan-jalan kalian yang jahat.” ");
INSERT INTO indags_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sementara mereka sedang berbicara kepada orang banyak, para imam, kepala pasukan rumah Tuhan, dan kelompok Saduki mendatangi mereka. ");
INSERT INTO indags_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mereka marah sebab Petrus dan Yohanes mengajari banyak orang, memberitahu mereka bahwa melalui Yesus ada kebangkitan dari antara orang mati. ");
INSERT INTO indags_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Maka mereka menangkap Petrus dan Yohanes dan menempatkan mereka di bawah pengawasan penjaga sampai keesokan harinya sebab saat itu hari sudah menjelang malam. ");
INSERT INTO indags_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tetapi banyak dari antara mereka yang sudah mendengarkan pesan Petrus dan Yohanes mempercayainya, dan jumlah orang percaya bertambah sampai berjumlah 5.000 orang. ");
INSERT INTO indags_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Keesokan harinya, para penguasa, pemimpin-pemimpin suku, dan pengajar-pengajar agama bertemu bersama di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Termasuk di antaranya adalah Imam Agung Hanas, Kayafas, Yohanes, Aleksander, dan anggota keluarga Imam besar lainnya. ");
INSERT INTO indags_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mereka membawa Petrus dan Yohanes ke hadapan mereka dan bertanya, “Dengan kuasa apa atau dengan otoritas siapa kalian melakukan hal ini?” ");
INSERT INTO indags_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petrus, penuh dengan Roh Kudus, menjawab mereka. “Para penguasa dan pemimpin rakyat: ");
INSERT INTO indags_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Apakah kami ditanyai mengenai sebuah perbuatan baik yang dilakukan kepada seorang yang tidak bisa menolong dirinya sendiri, dan bagaimana dia bisa disembuhkan? ");
INSERT INTO indags_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jika memang demikian, semua kalian harus tahu, dan juga semua orang di Israel, bahwa di dalam nama Yesus Kristus orang Nasaret, yang kalian salibkan dan yang Allah bangkitkan dari antara orang mati — oleh karena Dialah orang ini berdiri di hadapan kalian dalam keadaan benar-benar sembuh. ");
INSERT INTO indags_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘Dialah yang dikatakan sebagai batu yang sudah dibuang oleh tukang bangunan, tetapi sudah menjadi sebuah batu penjuru.’ ");
INSERT INTO indags_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hanya Dia satu-satunya yang bisa menyelamatkan, tidak ada nama lain di bawah langit ini yang diberikan kepada manusia yang bisa menyelamatkan kita.” ");
INSERT INTO indags_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ketika mereka melihat rasa percaya diri Petrus dan Yohanes, dan menyadari bahwa keduanya bukanlah orang yang berpendidikan, mereka sangat terkejut. Mereka juga mengenali keduanya sebagai murid-murid Yesus. ");
INSERT INTO indags_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sebab mereka bisa melihat orang yang sudah disembuhkan itu berdiri di hadapan mereka, tidak ada satu katapun yang bisa mereka ucapkan untuk membantah apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jadi mereka memerintahkan keduanya untuk menunggu di luar sementara sidang berdiskusi mengenai masalah yang ada di antara mereka sendiri. ");
INSERT INTO indags_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Apa yang harus kita lakukan kepada orang-orang ini?” tanya mereka. “Kita tidak bisa menyangkal keajaiban yang luar biasa yang terjadi melalui mereka. Setiap orang yang tinggal di Yerusalem mengetahui hal itu. ");
INSERT INTO indags_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tetapi agar hal itu tidak tersebar lebih jauh lagi di antara masyarakat, kita harus mengancam agar mereka tidak pernah berbicara dengan siapa pun dalam nama ini lagi.” ");
INSERT INTO indags_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jadi mereka kembali memanggil kedua rasul masuk ke dalam dan memerintahkan mereka untuk tidak pernah lagi berbicara ataupun mengajar tentang Yesus lagi. ");
INSERT INTO indags_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tetapi Petrus dan Yohanes menjawab, “Pikirkanlah menurut kalian, mana yang lebih benar dalam pandangan Allah, menaati kalian atau menaati Allah! ");
INSERT INTO indags_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kami tidak dapat berhenti berbicara tentang apa yang sudah kami lihat dan kami dengar!” ");
INSERT INTO indags_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sesudah mengancam kedua rasul lebih lagi, para anggota sidang melepaskan mereka. Para anggota sidang ini tidak bisa menemukan cara untuk menghukum para rasul sebab setiap orang memuliakan Allah untuk peristiwa yang terjadi. ");
INSERT INTO indags_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sebab orang yang mengalami kesembuhan secara ajaib itu usianya sudah lebih dari 40 tahun. ");
INSERT INTO indags_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sesudah para murid dilepaskan, mereka pergi ke tempat orang-orang percaya lainnya berkumpul dan menceritakan segala sesuatu yang dikatakan oleh Imam besar dan para pemimpin kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ketika mereka mendengar apa yang terjadi, mereka berdoa kepada Allah bersama-sama: “Tuhan, Engkaulah yang membuat surga, bumi, laut dan segala yang ada di dalamnya. ");
INSERT INTO indags_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Engkau berbicara dengan perantara Roh Kudus melalui Daud, nenek moyang kami dan pelayan-Mu, dengan perkataan, ‘Mengapa bangsa-bangsa menjadi begitu marah? Mengapa mereka berencanakan sesuatu yang bodoh melawan aku? ");
INSERT INTO indags_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Raja-raja di bumi bersiap untuk berperang, para penguasa bersatu melawan Tuhan dan Dia yang Terpilih.’ ");
INSERT INTO indags_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hal ini sudah benar-benar terjadi di kota ini! Baik Herodes maupun Pontius Pilatus, bersama dengan orang-orang asing dan orang Israel, berkumpul bersama melawan Hamba-Mu yang Kudus yaitu Yesus, yang sudah Engkau urapi sebagai Mesias. ");
INSERT INTO indags_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mereka melakukan apapun yang sudah Engkau putuskan sebab Engkaulah memiliki kuasa dan semua sesuai rencana-Mu. ");
INSERT INTO indags_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sekarang Tuhan, lihatlah ancaman-ancaman mereka terhadap kami! Tolong kami para pekerja-Mu untuk mengatakan Firman-Mu dengan benar-benar berani. ");
INSERT INTO indags_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ketika Engkau menunjukkan kuasa-Mu yang menyembuhkan, biarlah tanda-tanda dan keajaiban terjadi melalui nama Yesus, Hamba-Mu yang Kudus!” ");
INSERT INTO indags_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ketika mereka selesai berdoa, gedung tempat mereka berkumpul bergoncang. Semua mereka dipenuhi oleh Roh Kudus dan dengan berani mereka memberitakan Firman Allah. ");
INSERT INTO indags_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Seluruh kelompok orang percaya bersatu hati dan satu pemikiran. Tidak seorangpun mengatakan sesuatu adalah milikku, tetapi membaginya dengan yang lain. ");
INSERT INTO indags_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Para rasul memberikan kesaksian mereka tentang kebangkitan Tuhan Yesus dengan kuasa yang luar biasa, dan Allah sungguh-sungguh memberkati mereka semua. ");
INSERT INTO indags_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tidak seorangpun di antara mereka berkekurangan sebab mereka yang memiliki rumah atau sawah menjualnya. ");
INSERT INTO indags_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Hasil penjualan itu mereka bawa dan persembahkan kepada para rasul untuk dibagikan kepada mereka yang membutuhkan. ");
INSERT INTO indags_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusuf, yang diberi nama Barnabas (artinya orang yang suka menguatkan orang lain) oleh para rasul, adalah seorang keturunan suku Lewi, yang dilahirkan di pulau Siprus. ");
INSERT INTO indags_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Dia menjual ladang yang menjadi miliknya, dan membawa uangnya serta mempersembahkannya kepada para rasul. ");
INSERT INTO indags_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ada seorang bernama Ananias, dan istrinya Safira, yang menjual sebagian harta milik mereka. ");
INSERT INTO indags_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sebagian hasil penjualan dia sisihkan untuk dirinya sendiri, dan membawa sisanya ke hadapan para rasul. Istrinya tahu segala perbuatannya. ");
INSERT INTO indags_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ketika Petrus bertanya kepadanya, “Ananias, mengapa Setan memenuhi hatimu agar kamu berbohong kepada Roh Kudus dan menyimpan sebagian dari hasil penjualan tanahmu? ");
INSERT INTO indags_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bukankah itu tanah milikmu? Dan sesudah kamu menjualnya, hasilnya adalah milikmu? Mengapa kamu mengambil keputusan untuk melakukan kebohongan ini? Kamu bukan berbohong kepada manusia, tetapi kepada Allah!” ");
INSERT INTO indags_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Mendengar kata-kata ini, Ananias jatuh dan mati. Setiap orang yang mendengar berita ini menjadi sangat takut. ");
INSERT INTO indags_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Beberapa pemuda bangun dan membungkus dia dalam kain kafan. Lalu mereka memboyong-nya keluar dan menguburkan dia. ");
INSERT INTO indags_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Sekitar tiga jam kemudian, datanglah istri Ananias, tanpa mengetahui apa yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus bertanya kepadanya, “Katakan, apakah kalian menjual tanah ini dengan harga sekian?” “Ya, benar. Memang sebesar itu nilainya,” jawab perempuan itu. ");
INSERT INTO indags_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lalu Petrus memberitahu dia, “Bagaimana bisa kalian sepakat untuk mencobai Roh Tuhan? Dengar, mereka yang menguburkan suamimu baru saja kembali, dan mereka akan membawa kamu juga!” ");
INSERT INTO indags_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dengan segera Safira jatuh dan mati di dekat kaki Petrus. Para pemuda baru saja masuk dan menemukan bahwa dia sudah meninggal, maka mereka menggotongnya keluar dan menguburkan dia di sisi suaminya. ");
INSERT INTO indags_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ketakutan yang besar dirasakan oleh seluruh anggota jemaat, demikian juga di antara mereka yang mendengarkan kejadian ini. ");
INSERT INTO indags_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Banyak tanda-tanda perbuatan yang ajaib terjadi di antara orang-orang yang dilakukan oleh para rasul. Semua orang percaya biasa berkumpul bersama di Serambi Salomo. ");
INSERT INTO indags_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kejadian ini membuat tidak seorangpun berani bergabung dengan mereka sekalipun orang-orang sangat menghormati mereka. ");
INSERT INTO indags_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Namun demikian banyak orang yang menjadi percaya kepada Tuhan — baik laki-laki maupun perempuan. ");
INSERT INTO indags_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sebagai akibatnya, orang-orang membawa banyak orang sakit ke jalan-jalan dan membaringkan mereka di atas kasur dan matras, agar ketika Petrus lewat, bayangannya akan dapat menyembuhkan mereka. ");
INSERT INTO indags_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kerumuman orang dari kota-kota kecil di sekitar Yerusalem membawa kerabat mereka yang sakit dan yang dirasuki oleh roh jahat. Dan mereka semua disembuhkan. ");
INSERT INTO indags_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Namun demikian, para imam besar dan kelompok Saduki menjadi sangat iri hati dan memutuskan untuk mengambil tindakan. ");
INSERT INTO indags_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mereka menangkap para rasul itu dan memasukkan mereka ke dalam penjara. ");
INSERT INTO indags_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tetapi ketika malam tiba, ada malaikat Tuhan yang membuka pintu penjara dan memimpin mereka keluar. ");
INSERT INTO indags_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Pergilah ke rumah Tuhan dan ceritakan kepada orang-orang tentang cara hidup yang baru ini!” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mereka melakukan apa yang diperintahkan dan pergi ke rumah Tuhan ketika hari masih pagi-pagi benar dan mulai mengajar. Lalu imam besar dan para pengikutnya mengadakan sidang pertemuan dengan seluruh pemimpin di Israel. Dia mengirim pesan agar para rasul itu dibawa dari penjara. ");
INSERT INTO indags_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tetapi ketika para petugas pergi ke penjara untuk menjemput para rasul, mereka tidak bisa menemukan mereka, sehingga mereka kembali ke dewan dan melaporkan, ");
INSERT INTO indags_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Pintu penjara masih terkunci, dengan para penjaga masih ada di depan pintu. Tetapi ketika kami minta pintu di buka, kami tidak menemukan siapapun di dalam.” ");
INSERT INTO indags_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ketika kepala pasukan rumah Tuhan dan para imam kepala mendengar hal ini, mereka benar-benar kebingungan, dan bertanya-tanya apa yang sedang terjadi. ");
INSERT INTO indags_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lalu seseorang masuk dan berkata, “Dengar, orang-orang yang kalian masukkan ke dalam penjara ada di dalam rumah Tuhan sedang mengajar!” ");
INSERT INTO indags_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jadi kepala pengawal pergi bersama para prajuritnya dan membawa para rasul itu kembali ke sidang, tetapi mereka tidak menggunakan paksaan sebab mereka takut jangan sampai orang banyak yang mendengarkan para rasul itu melempari mereka dengan batu. ");
INSERT INTO indags_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Para rasul dibawa masuk dan diperintahkan untuk berdiri di hadapan sidang. ");
INSERT INTO indags_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Bukankah sudah kami perintahkan kepada kalian untuk tidak mengajar dalam nama ini?” tanya Imam Besar. “Sekarang dengar — kalian sudah membawa pengajaran kalian ke seluruh Yerusalem, dan kalian mencoba menyalahkan kami sebagai penyebab kematian-Nya!” ");
INSERT INTO indags_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tetapi Petrus dan para rasul menjawab, “Kami harus lebih taat kepada Allah daripada kepada manusia. ");
INSERT INTO indags_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Allah nenek moyang kita membangkitkan Yesus dari kematian — Dia yang kalian bunuh dengan cara disalibkan. ");
INSERT INTO indags_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Allah meninggikan Dia dan menempatkan Dia di posisi yang paling terhormat di sebelah kanan Allah sebagai Raja dan Penyelamat. Dengan demikian Allah memberikan jalan melalui Dia agar orang-orang Israel bisa bertobat dan menerima pengampunan dosa. ");
INSERT INTO indags_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami adalah saksi dari semua kejadian yang ada, demikian juga dengan Roh Kudus, yang Allah berikan kepada mereka yang taat kepada-Nya.” ");
INSERT INTO indags_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ketika anggota sidang mendengar hal ini, marahlah mereka dan ingin membunuh para rasul itu. ");
INSERT INTO indags_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tetapi kemudian salah satu anggota sidang berdiri dan berbicara. Dia adalah Gamaliel, seorang Farisi dan ahli hukum Taurat yang sangat dihormati oleh semua orang. Dia memerintahkan agar para rasul keluar dari ruang sidang terlebih dahulu. ");
INSERT INTO indags_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel berkata kepada para anggota sidang: “Para pemimpin Israel, berhati-hatilah dengan rencana yang hendak kalian lakukan kepada orang-orang ini. ");
INSERT INTO indags_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Beberapa waktu lalu Tedeus mencoba mencari nama agar dirinya dikenal, dan sekitar 400 orang bergabung menjadi pengikutnya. Dia dibunuh dan semua pengikutnya tercerai berai dan gerakannya hilang. ");
INSERT INTO indags_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lalu sesudah dia, ada Yudas dari Galilea, yang muncul sekitar masa sensus penduduk, yang menarik cukup banyak pengikut. Dia juga mati, dan mereka yang mendengarkan dia tercerai berai. ");
INSERT INTO indags_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jadi dengan kasus yang sekarang ini, aku menasihatkan agar kalian membiarkan orang-orang ini, dan lepaskan mereka. Jika yang mereka rencanakan atau lakukan datang dari pikiran manusia, maka gerakan mereka pasti akan dikalahkan. ");
INSERT INTO indags_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tetapi jika kegerakan mereka datang dari Allah, kalian tidak akan bisa mengalahkan mereka. Kalian bahkan akan melawan Allah!” ");
INSERT INTO indags_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Para anggota sidang diyakinkan oleh perkataannya. Jadi mereka kembali memanggil para rasul ke dalam ruang sidang, mencambuk mereka, dan memerintahkan agar para rasul tidak lagi mengatakan apapun dalam nama Yesus. Lalu melepaskan mereka. ");
INSERT INTO indags_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Para rasul itu meninggalkan tempat sidang, gembira sebab dianggap layak untuk menderita demi nama Yesus. ");
INSERT INTO indags_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Setiap hari mereka terus mengajar dan memberitakan nama Yesus sebagai Mesias, dalam rumah Tuhan dan di rumah-rumah. ");
INSERT INTO indags_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pada waktu ini, jumlah orang percaya meningkat dengan cepat. Orang percaya yang berbicara dengan bahasa Yunani mulai berdebat dengan mereka yang berbicara dengan bahasa Aram. Orang-orang yang berbahasa Yunani ini mengeluh bahwa janda-janda mereka mendapat perlakuan yang tidak adil dalam pembagian makanan setiap hari. ");
INSERT INTO indags_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kedua belas rasul memanggil kedua belah pihak untuk berkumpul, dan memberitahu mereka, “Tidak baik bagi kami untuk meninggalkan tugas memberitakan Firman Allah hanya agar kami bisa mengurus tugas pembagian makanan. ");
INSERT INTO indags_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Saudara-saudara, pilihlah tujuh orang dari antara kalian yang bisa dipercaya, penuh dengan Roh Kudus dan kemampuan untuk mengambil keputusan yang bijak. Kami akan mengalihkan tanggung jawab ini kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kami sendiri akan memberi perhatian penuh kepada doa dan pelayanan penyebaran Firman.” ");
INSERT INTO indags_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Setiap orang senang dengan pengaturan ini, dan mereka memilih Stefanus, seorang yang sangat percaya kepada Allah dan penuh dengan Roh Kudus, Filipus, Prokorus, Nikanor, Timon, Permenas, dan Nikolaus, seorang Yahudi yang menjadi pengikut Kristus yang berasal dari Antiokia. ");
INSERT INTO indags_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Orang-orang ini dihadapkan kepada para rasul yang berdoa dan menumpangkan tangan atas mereka serta memberkati mereka. ");
INSERT INTO indags_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Firman Allah terus menyebar, dan jumlah murid di Yerusalem terus bertambah dengan cepat, bahkan sejumlah besar imam juga menjadi percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus, penuh dengan kuasa dan kemurahan Allah, banyak melakukan perbuatan-perbuatan yang ajaib di antara orang banyak. ");
INSERT INTO indags_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tetapi beberapa orang mulai berdebat dengan dia. Mereka datang dari rumah-rumah ibadah yang dinamakan “Orang-orang yang Merdeka”, demikian juga orang-orang Kirene, Aleksandira, Kilikia dan Asia Kecil. ");
INSERT INTO indags_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tetapi tidak seorangpun dari mereka yang bisa menjawab hikmat yang dimiliki Stefanus sebab dia selalu dipenuhi oleh Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jadi mereka menyuap beberapa orang untuk memberikan kesaksian palsu. Mereka berkata, “Kami mendengar orang ini menghujat Musa, dan Allah juga!” ");
INSERT INTO indags_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mereka menghasut orang-orang, dan bersama dengan para pemimpin dan pengajar hukum Taurat, datang dan menangkap dia. Mereka membawanya ke sidang Mahkamah Agama, ");
INSERT INTO indags_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","dan memanggil saksi palsu untuk bersaksi menuduh mereka. “Orang ini selalu mengumpat tentang rumah Tuhan dan hukum Taurat,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Kami mendengar dia berkata kalau Yesus si Orang Nasaret itu akan menghancurkan rumah Tuhan, dan akan mengganti hukum Taurat yang kita terima dari Musa.” ");
INSERT INTO indags_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Setiap orang yang duduk dalam sidang Mahkamah Agama itu menatap lekat kepada Stefanus, dan wajahnya bersinar seperti wajah seorang malaikat. ");
INSERT INTO indags_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","“Apakah seluruh tuduhan ini benar?” tanya Imam Besar. ");
INSERT INTO indags_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","“Saudara-saudara dan ayah-ayah sekalian, dengarkan aku!” jawab Stefanus. “Allah dalam kemuliaan-Nya menyatakan diri kepada bapa leluhur kita Abraham ketika dia masih hidup di Mesopotamia, sebelum dia pindah ke Haran. ");
INSERT INTO indags_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Allah berkata kepadanya, ‘Pergilah dari negerimu dan dari sanak keluargamu, dan pergilah menuju negeri yang akan Aku tunjukkan kepadamu.’ ");
INSERT INTO indags_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Maka pergilah Abraham meninggalkan negeri orang Kasdim dan tinggal di Haran. Sesudah kematian ayahnya, Allah mengirim dia ke sini, ke negeri tempat di mana kita sekarang. ");
INSERT INTO indags_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Allah tidak memberikan kepada Abraham satu bidang tanahpun kepadanya di sini. Tetapi yang Allah janjikan adalah Abraham akan mendapatkan hak kepemilikan atas negeri ini, dia beserta keturunannya, sekalipun saat itu Abraham tidak memiliki anak. ");
INSERT INTO indags_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Allah juga memberitahu dia bahwa keturunannya akan hidup di negeri asing, dan mereka akan diperbudak di sana, dan akan ditindas selama 400 tahun. ");
INSERT INTO indags_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Allah berkata, ‘Aku akan menghukum negeri yang sudah memperbudak mereka. Pada akhirnya keturunanmu akan pergi dan datang ke tempat ini untuk menyembah Aku.’ ");
INSERT INTO indags_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Allah juga memberikan kepada Abraham perjanjian sunat, maka, ketika Isak lahir, Abraham menyunat dia pada hari yang ke delapan. Isak, adalah ayah Yakub, dan Yakub adalah ayah dari ke dua belas kepala suku bangsa Israel. ");
INSERT INTO indags_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nenek moyang kita karena cemburu kepada Yusuf, menjualnya menjadi budak di Mesir. Tetapi Allah beserta dengan dia, ");
INSERT INTO indags_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dan menyelamatkan dia dari semua kesukaran dia. Allah memberinya kemampuan untuk mengambil keputusan yang tepat dan menolongnya mendapat perkenanan Raja Mesir, yang mengangkat dia menjadi gubernur atas Mesir dan rumah tangga kerajaan. ");
INSERT INTO indags_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Namun sebuah bencana kelaparan melanda seluruh Mesir dan Kanaan. Bencana ini menyebabkan penderitaan yang hebat, dan nenek moyang kita kehabisan bahan makanan. ");
INSERT INTO indags_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ketika Yakub mendengar bahwa gandum tersedia di negeri Mesir, dia mengirim nenek moyang kita dalam kunjungan pertama mereka. ");
INSERT INTO indags_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pada kunjungan kedua mereka, Yusuf memperkenalkan dirinya kepada saudara-saudaranya, dan Raja Mesir mengetahui latar belakang keluarga Yusuf. ");
INSERT INTO indags_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusuf mengirim utusan untuk menjemput ayah dan seluruh sanak keluarganya yang berjumlah 72 orang. ");
INSERT INTO indags_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakub akhirnya berangkat ke Mesir, dan meninggal di sana — demikian juga dengan nenek moyang kita. ");
INSERT INTO indags_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mayat-mayat mereka dibawa kembali ke Sikhem dan diletakkan di kuburan yang Abraham sudah beli dengan koin perak dari anak-anak Hamor di Sikhem. ");
INSERT INTO indags_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Waktunya sudah semakin dekat untuk menggenapi janji yang Allah buat kepada Abraham, jumlah orang Israel di Mesir meningkat. ");
INSERT INTO indags_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Seorang raja baru yang tidak mengenal Yusuf memerintah di negeri Mesir. ");
INSERT INTO indags_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Dia memanfaatkan dan menyiksa nenek moyang kita, memaksa mereka membuang bayi-bayi mereka supaya mati. ");
INSERT INTO indags_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pada masa inilah Musa dilahirkan. Dia seorang bayi yang rupawan, dan selama tiga bulan dia dipelihara di dalam rumah ayahnya. ");
INSERT INTO indags_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ketika dia harus dibuang, putri Raja Mesir menyelamatkan dan merawatnya seperti anak laki-lakinya sendiri. ");
INSERT INTO indags_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa menerima didikan dan ilmu bangsa Mesir, dan menjadi berkuasa, baik di dalam perkataan maupun perbuatan. ");
INSERT INTO indags_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Namun ketika dia berusia 40 tahun, Musa memutuskan untuk mengunjungi saudara-saudaranya, orang Israel. ");
INSERT INTO indags_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dia melihat salah seorang dari mereka sedang dianiaya oleh orang Mesir, jadi dia membela saudaranya bangsa Israel itu. Musa memukul orang Mesir itu sampai mati. ");
INSERT INTO indags_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa mengira bahwa bangsanya akan melihat bahwa Allah akan menyelamatnya mereka melalui dia, tetapi tidak terjadi seperti itu. ");
INSERT INTO indags_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Keesokan harinya dalam kunjungannya yang kedua, dua orang Israel sedang berkelahi. Musa mencoba mendamaikan mereka dan menghentikan perkelahian. ‘Kawan, kalian ini bersaudara!’ katanya kepada mereka. ‘Mengapa kalian saling menyerang?’ ");
INSERT INTO indags_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tetapi orang yang memulai perkelahian mendorong Musa. Jawab orang itu, ‘Siapa yang mengangkat kamu menjadi pengawas atas kami? Apakah kamu yang menjadi hakim kami sekarang?’ ");
INSERT INTO indags_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Apakah kamu akan membunuhku seperti kamu membunuh orang Mesir itu kemarin?’ ");
INSERT INTO indags_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ketika Musa mendengar perkataan orang itu, dia melarikan diri sebab dia tahu dia akan dihukum mati. Dia pergi dan hidup dalam pengasingan di negeri Midian, dan mendapatkan dua orang anak laki-laki sebagai keturunannya. ");
INSERT INTO indags_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Sesudah lewat 40 tahun, datanglah malaikat di hadapan Musa dalam bentuk semak yang terbakar di Gunung Sinai. ");
INSERT INTO indags_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa tertegun melihat hal ini, dan mendekat menghampirinya. Suara Tuhan berbicara kepadanya: ");
INSERT INTO indags_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Akulah Allah ayahmu, Allah Abraham dan Isak dan Yakub.’ Musa gemetar ketakutan dan tidak berani mengangkat kepalanya. ");
INSERT INTO indags_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tuhan berkata kepadanya, ‘Lepaskanlah sendalmu, sebab tanah tempat kamu berdiri itu kudus. ");
INSERT INTO indags_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aku sudah memperhatikan dengan seksama penderitaan dari umat-Ku di negeri Mesir, dan sudah Kudengar erangan mereka. Aku turun untuk menyelamatkan mereka. Datanglah ke sini, sebab Aku akan mengirim kamu ke Mesir.’ ");
INSERT INTO indags_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa ini sama dengan Musa yang ditolak oleh orang Israel ketika mereka berkata, ‘Siapa yang mengangkat kamu menjadi penguasa dan hakim atas kami?’ Allah mengirim dia kembali baik sebagai penguasa maupun pembebas, dengan bantuan malaikat yang muncul di hadapan dia di semak. ");
INSERT INTO indags_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa memimpin mereka keluar dengan melakukan banyak perbuatan ajaib di Mesir, di Laut Merah, dan terus melakukannya sepanjang perjalanan mereka di gurun pasir selama 40 tahun. ");
INSERT INTO indags_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa yang sama yang berjanji kepada orang Israel, ‘Allah akan mengirimkan kepada kalian seorang nabi yang seperti diriku dari antara saudara-saudara kita sendiri.’ ");
INSERT INTO indags_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa masih bersama dengan umat Allah di gurun pasir ketika malaikat berbicara dengannya di Gunung Sinai, dan di sana, nenek moyang kita bersama dengan Musa menerima Firman Allah untuk diteruskan kepada kita. ");
INSERT INTO indags_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tetapi mereka tidak mau mendengarkan dia dan memutuskan untuk kembali ke Mesir. ");
INSERT INTO indags_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mereka berkata kepada Harun, ‘Dirikanlah sebuah patung untuk kami sembah sebagai dewa yang memimpin kita, sebab kita tidak tahu apa yang terjadi pada Musa yang sudah memimpin kita keluar dari tanah Mesir.’ ");
INSERT INTO indags_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lalu mereka membuat patung berbentuk anak lembu, memberikan kurban persembahan kepadanya, dan merayakan patung buatan tangan mereka sendiri! ");
INSERT INTO indags_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Maka menyerahlah Allah terhadap mereka. Ditinggalkannya mereka untuk menyembah dewa-dewa di langit. Inilah yang dikatakan oleh para nabi, ‘Apakah kalian memberikan persembahan atau kurban bakaran kepada-Ku selama masa 40 tahun di gurun pasir, hai orang Israel? ");
INSERT INTO indags_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tidak! Kalian membawa kemah dewa Molok dan patung dari dewa bintang Refan, patung yang kalian buat agar kalian bisa menyembah mereka. Maka Aku akan membuang kalian ke pengasingan melewati negeri Babilonia.’ ");
INSERT INTO indags_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nenek moyang kita selalu membawa Kemah Kesaksian selama di gurun pasir. Allah memberitahu Musa cara mendirikannya mengikuti rancangan yang sudah dia lihat. ");
INSERT INTO indags_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lalu, nenek moyang kita membawanya bersama mereka ketika mereka masuk bersama Yosua untuk menduduki negeri yang mereka ambil dari bangsa-bangsa yang Tuhan usir dari hadapan mereka. Dan kemah itu tetap ada di sana sampai masa Daud menjadi raja. ");
INSERT INTO indags_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daud mendapat perkenanan di mata Allah dan bertanya apakah ia boleh membangun Rumah bagi Allah Yakub. ");
INSERT INTO indags_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tetapi pada akhirnya Salomolah yang membangun Rumah itu bagi Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tentu saja Tuhan yang Mahakuasa tidak tinggal dalam Rumah-rumah ibadah yang kita bangun. Seperti yang dikatakan para nabi, ");
INSERT INTO indags_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit adalah tahta-Ku, dan bumi adalah tempat Aku meletakkan kaki-Ku. Rumah kediaman seperti apa yang ingin kamu bangun untuk-Ku?’ tanya Tuhan. ‘Tempat tidur seperti apa yang ingin kamu buat sebagai tempat bagi-Ku untuk beristirahat? ");
INSERT INTO indags_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Akulah pencipta segalanya!’ ");
INSERT INTO indags_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Hai orang-orang yang sombong dan keras kepala! Kalian tidak pernah mau mendengar! Kalian selalu melawan Roh Kudus! Perbuatan kalian sama dengan perbuatan nenek moyang kalian! ");
INSERT INTO indags_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Adakah nabi yang tidak dibunuh oleh nenek moyang kalian? Mereka membunuh nabi-nabi yang bernubuat tentang kedatangan Seorang yang sungguh-sungguh baik dan benar. Dia yang kalian khianati dan bunuh — ");
INSERT INTO indags_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kalian yang menerima Hukum Taurat melalui para malaikat, tetapi menolak untuk menjalankannya.” ");
INSERT INTO indags_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ketika para pemimpin orang Yahudi mendengar perkataan ini, mereka menjadi sangat murka, membelakkan mata mereka dan menggertakkan gigi kepadanya. ");
INSERT INTO indags_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tetapi Stefanus, penuh dengan Roh Kudus, menatap ke langit dan melihat kemuliaan Allah, dengan Yesus berdiri di sebelah kanan-Nya. ");
INSERT INTO indags_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Dengar,” katanya, “Aku melihat surga terbuka, dan Anak Manusia berdiri di sebelah kanan Allah.” ");
INSERT INTO indags_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tetapi mereka menutup telinga mereka sambil berteriak sekeras-kerasnya. Dan mereka menyerang dia bersama-sama, ");
INSERT INTO indags_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","menyeretnya keluar kota, dan mulai melempari dia dengan batu. Para penuduh dia meletakkan jubah-jubah mereka di tanah dan dijaga oleh seorang pemuda yang bernama Saulus. ");
INSERT INTO indags_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ketika mereka semua melempari dia dengan batu, Stefanus berdoa, “Tuhan Yesus, terimalah rohku.” ");
INSERT INTO indags_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lalu sambil berlutut, Stefanus berseru, “Tuhan, tolong jangan pegang dosa ini terhadap mereka!” Sesudah mengatakan hal ini, matilah dia. ");
INSERT INTO indags_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus setuju bahwa Stefanus haruslah dibunuh. Pada hari itu penganiayaan besar mulai terjadi terhadap orang percaya di Yerusalem, dan setiap orang kecuali para rasul tersebar ke seluruh Yudea dan Samaria. ");
INSERT INTO indags_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","(Beberapa pengikut Allah yang setia menguburkan Stefanus, dengan berkabung yang besar.) ");
INSERT INTO indags_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tetapi Saulus sedang bersiap-siap menghancurkan kumpulan orang percaya, berangkat dari rumah ke rumah, menyeret baik laki-laki maupun perempuan ke dalam penjara. ");
INSERT INTO indags_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Dan mereka yang tersebar ke seluruh daerah menyebarkan juga Firman ke manapun mereka pergi. ");
INSERT INTO indags_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipus pergi ke kota di daerah Samaria, dan memberitahu mereka tentang Mesias. ");
INSERT INTO indags_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ketika orang banyak mendengar perkataan Filipus dan melihat perbuatan ajaib yang dilakukannya, mereka memperhatikan setiap pengajaran yang dia berikan. ");
INSERT INTO indags_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Banyak di antara mereka yang dilepaskan dari kerasukan setan yang menjerit ketika keluar dari orang yang mereka jadikan tempat berdiam, dan banyak di antara mereka yang lumpuh atau cacat disembuhkan. ");
INSERT INTO indags_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Orang-orang yang hidup di kota itu sangat bersukacita. ");
INSERT INTO indags_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Di kota itu ada seorang bernama Simon yang mempraktekkan ilmu sihir. Dia menyatakan bahwa dia adalah seorang yang sangat penting, dan sudah membuat orang-orang Samaria terpesona, ");
INSERT INTO indags_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","sehingga ereka memperhatikan perkataan dia. Mulai dari orang biasa sampai ke orang penting di kota itu berkata, “Laki-laki ini adalah ‘Allah dengan Kuasa Besar.’” ");
INSERT INTO indags_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mereka terpesona karena dia sudah menawan mereka dengan sihirnya sejak lama. ");
INSERT INTO indags_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tetapi ketika mereka menjadi percaya karena ucapan Filipus tentang kabar baik Kerjaan Allah dan nama Yesus Kristus, mereka semua dibaptis, baik laki-laki maupun perempuan. ");
INSERT INTO indags_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon juga menjadi orang percaya dan dibaptis. Dia mengikuti Filipus, kagum akan tanda-tanda dan perbuatan-perbuatan ajaib yang dia lihat. ");
INSERT INTO indags_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ketika para rasul yang ada di Yerusalem mendengar bahwa orang-orang di Samaria sudah menerima Firman Allah, mereka mengirim Petrus dan Yohanes untuk mengunjungi orang-orang itu. ");
INSERT INTO indags_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ketika mereka tiba di tempat itu, mereka berdoa agar orang-orang percaya yang ada di Samaria menerima Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Orang-orang percaya ini memang sudah dibaptis dalam nama Yesus Tuhan, tetapi mereka belum dipenuhi oleh Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Para rasul meletakkan tangan mereka ke atas orang-orang percaya ini, dan mereka menerima Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ketika Simon melihat bahwa Roh Kudus diberikan ketika para rasul meletakkan tangan mereka ke atas orang-orang, Simon menawarkan sejumlah uang kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Berikan kepadaku kuasa itu juga,” katanya kepada mereka, “agar setiap orang yang aku letakkan tangan ke atas mereka menerima Roh Kudus.” ");
INSERT INTO indags_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","“Kiranya uangmu binasa bersama-sama dengan kamu sebab kamu memiliki pikiran bahwa pemberian Allah adalah sesuatu yang bisa dibeli dengan uang!” jawab Petrus. ");
INSERT INTO indags_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","“Kamu bukanlah bagian dalam pekerjaan ini. Tindakanmu benar-benar salah dalam pandangan Allah. ");
INSERT INTO indags_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Berhentilah berbuat jahat dan kembalilah berbuat yang benar! Berdoalah kepada Tuhan dan mintalah pengampunan dari-Nya oleh karena pikiranmu ini. ");
INSERT INTO indags_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sudah jelas terlihat bahwa kamu penuh dengan iri hati dan kamu terjerat dalam dosa-dosamu.” ");
INSERT INTO indags_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Tolong doakan saya, agar segala yang kamu katakan tidak terjadi atas diriku!” jawab Simon. ");
INSERT INTO indags_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sesudah Petrus dan Yohanes memberikan kesaksian dan memberitakan Firman Tuhan, kembalilah mereka ke Yerusalem, menceritakan kabar baik kepada desa-desa di Samaria dalam perjalanan pulang mereka. ");
INSERT INTO indags_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pada suatu hari salah satu malaikat Tuhan berbicara kepada Filipus, “Bersiap-siaplah dan pergilah ke arah selatan ke jalan di padang pasir yang menghubungkan antara Yerusalem dan Gaza.” ");
INSERT INTO indags_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Maka berangkatlah Filipus, dan bertemu dengan seorang dari Etopia, seorang kasim yang memiliki posisi yang tinggi dari Kandake, Ratu Etopia. Orang ini adalah bendahara kerajaan. Dia pergi ke Yerusalem untuk menyembah dan ");
INSERT INTO indags_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","sedang dalam perjalanan pulang kembali ke daerah asalnya, dan sedang duduk dalam sebuah kereta kuda. Dia membaca salah satu bagian dari ktiab Yesaya dengan suara keras. ");
INSERT INTO indags_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roh Kudus berbicara kepada Filipus, “Mendekatlah ke arah kereta itu.” ");
INSERT INTO indags_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Maka Filipus berlari menghampiri, dan mendengar si laki-laki membaca dari kitab nabi Yesaya. “Apakah Engkau mengerti apa yang Engkau baca?” tanya Filipus. ");
INSERT INTO indags_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Bagaimana bisa saya mengerti jika tidak ada seorangpun yang bisa menjelaskannya kepada saya?” jawab laki-laki itu. Dia mengundang Filipus untuk naik dan duduk di selelahnya. ");
INSERT INTO indags_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bagian Kitab Suci yang dia baca adalah ini: “Dia dituntun seperti seekor domba yang hendak disembelih. Seperti anak domba yang diam di hadapan orang yang akan menggunting bulunya, tidak satu katapun yang dia ucapkan. ");
INSERT INTO indags_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dia dipermalukan dan tidak mengalami keadilan. Tidak seorangpun yang berkata apa-apa mengenai keturunannya, sebab hidupnya sudah sampai titik penghabisan.” ");
INSERT INTO indags_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sang kasim bertanya kepada Filipus, “Beritahu saya, siapa yang dimaksud oleh sang nabi? Apakah dia berbicara tentang dirinya sendiri, atau orang lian?” ");
INSERT INTO indags_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipus mulai menjelaskan, mulai dari Kitab Suci ini, memberitahunya tentang Yesus. ");
INSERT INTO indags_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ketika mereka melanjutkan perjalanan, mereka tiba di sebuah tempat yang ada airnya. Sang kasim berkata, “Dengar, ada air di sini — mengapa aku tidak dibaptis?” ");
INSERT INTO indags_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dia memerintahkan agar kereta itu dihentikan. Filipus dan sang kasim masuk ke dalam air dan Filipus membaptis dia. ");
INSERT INTO indags_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ketika mereka keluar dari air, Roh yang dari Tuhan membawa Filipus pergi. Sang kasim tidak pernah melihat dia lagi, tetapi sang kasim meneruskan perjalanan dengan penuh sukacita. Dan Filipus sendiri pergi ke Azotus. ");
INSERT INTO indags_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dan dia menyebarkan Kabar Baik di seluruh kota sepanjang perjalanannya menuju Kaisarea. ");
INSERT INTO indags_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sementara itu Saulus membuat ancaman kejam terhadap murid-murid Tuhan, dia ingin membunuh mereka. Saulus menghadap kepada Imam Besar, ");
INSERT INTO indags_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dan minta surat otoritas untuk dia bawa kepada rumah-rumah ibadah di daerah Dasmaskus, memberikan ijin kepadanya untuk menangkap setiap orang yang percaya kepada pada Jalan yang dia temukan, baik laki-laki maupun perempuan, dan membawa mereka kembali ke Yerusalem sebagai tawanan. ");
INSERT INTO indags_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ketika Saulus mencapai kota Damsyik, tiba-tiba dia dikelilingi oleh cahaya yang memancar dari surga. ");
INSERT INTO indags_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jatuhlah Saulus ke tanah, dan mendengar ada suara berkata, “Saulus, Saulus, mengapa kamu menganiaya Aku?” ");
INSERT INTO indags_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Siapakah Engkau, Tuhan?” tanya Saulus. “Akulah Yesus, orang yang kamu aniaya,” jawab Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Bangunlah, masuklah ke dalam kota, dan kamu akan diberitahu apa yang harus kamu lakukan.” ");
INSERT INTO indags_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Orang-orang yang pergi bersama dengan Saulus berdiri di sana tanpa bisa mengeluarkan suara. Mereka mendengar ada orang yang berbicara, tetapi mereka tidak bisa melihat orangnya. ");
INSERT INTO indags_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Berdirilah Saulus, dan ketika dia membuka matanya, ternyata dia menjadi buta. Rekan seperjalanannya menuntunnya masuk ke kota Damsyik. ");
INSERT INTO indags_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saulus menjadi buta selama tiga hari, dan dia tidak makan atau minum sesuatu apapun selama itu. ");
INSERT INTO indags_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Di kota itu ada seorang pengikut Yesus yang bernama Ananias, dan Tuhan berbicara kepadanya dalam sebuah penglihatan. “Ananias!” kata Tuhan. “Saya disini, Tuhan,” jawab Ananias. ");
INSERT INTO indags_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Bangunlah, dan pergilah ke jalan yang bernama Lurus,” kata Tuhan kepadanya. “Bertanyalah di rumah Yudas seseorang yang bernama Saulus, dari Tarsis. Dia sedang berdoa. ");
INSERT INTO indags_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulus sudah mendapat penglihatan bahwa ada seseorang bernama Ananias yang datang dan meletakkan tangannya ke atas dia agar dia bisa kembali melihat.” ");
INSERT INTO indags_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Tetapi Tuhan,” jawab Ananias, “Aku sudah banyak mendengar tentang orang ini — tentang semua tindakan jahat yang dia lakukan kepada orang-orang percaya di Yerusalem. ");
INSERT INTO indags_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Para imam kepala sudah memberikan kepada dia otoritas untuk menangkap siapa saja di sini yang menyembah dan mengikuti Engkau.” ");
INSERT INTO indags_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Namun Tuhan berkata kepadanya, “Pergilah, sebab dialah orang yang sudah Aku pilih untuk mengabarkan nama-Ku ke orang-orang asing dan raja-raja, juga kepada orang Israel. ");
INSERT INTO indags_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aku sendiri yang akan menunjukkan kepadanya penderitaan yang akan dia alami demi nama-Ku.” ");
INSERT INTO indags_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Maka pergilah Ananias dan masuk ke rumah itu. Dia meletakkan tangannya ke atas Saulus. “Saulus, saudaraku,” katanya, “Tuhan Yesus, yang menampakkan diri kepadamu ketika kamu dalam perjalanan menuju ke tempat ini, sudah mengirim aku agar kamu bisa kembali melihat dan dipenuhi oleh Roh Kudus.” ");
INSERT INTO indags_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dengan segera, sesuatu seperti sisik ikan jatuh dari matanya, dan penglihatannya pulih kembali. Saulus bangun dan memberi dirinya untuk dibaptis. ");
INSERT INTO indags_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulus juga makan dan merasa lebih kuat. Dia menghabiskan waktu bersama murid-murid Yesus di Damsyik selama beberapa hari. ");
INSERT INTO indags_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dan Saulus mulai berbicara di rumah-rumah ibadat dan menyatakan, “Yesus adalah Anak Allah!” ");
INSERT INTO indags_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Semua yang mendengar dia terkejut, dan bertanya, “Bukankah laki-laki ini yang menyebabkan begitu banyak kesulitan di Yerusalem bagi mereka yang percaya kepada Yesus? Bukankah dia datang ke kota ini untuk menangkap orang-orang percaya dan membawanya sebagai tawanan dengan rantai kepada para imam kepala?” ");
INSERT INTO indags_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus menjadi lebih percaya diri, membuktikan bahwa Yesus adalah Mesias begitu meyakinkan sehingga orang-orang Yahudi yang ada di kota Damsyik tidak ada yang bisa mengalahkan dia. ");
INSERT INTO indags_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Beberapa waktu kemudian orang-orang Yahudi bersekongkol untuk membunuhnya, ");
INSERT INTO indags_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","tetapi Saulus mendapat tahu niat mereka. Siang dan malam mereka menunggu di gerbang kota mencari kesempatan untuk membunuh dia. ");
INSERT INTO indags_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jadi suatu hari, ketika hari sudah malam, para pengikut Saulus membawanya dan menurunkan dia melalui lubang yang ada di tembok kota dalam sebuah keranjang. ");
INSERT INTO indags_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ketika Saulus tiba di Yerusalem, dia mencoba bertemu dengan para murid, tetapi mereka semua takut kepadanya karena mereka tidak yakin bahwa Saulus sudah menjadi seorang murid juga. ");
INSERT INTO indags_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Namun, Barnabas membawa Saulus untuk bertemu dengan para rasul, dan menjelaskan kepada mereka bagaimana Saulus sudah melihat Tuhan di jalan dan bagaimana Tuhan sudah berbicara kepada Saulus. Barnabas juga menjelaskan bagaimana di kota Damsyik Saulus sudah berbicara dengan berani tentang Yesus. ");
INSERT INTO indags_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulus tinggal bersama dengan para rasul dan mengikuti mereka ke seluruh Yerusalem, ");
INSERT INTO indags_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","serta berbicara dengan berani tentang Yesus. Dia berbicara dan berdebat dengan orang-orang Yahudi yang berbicara dengan bahasa Yunani, tetapi mereka mencoba membunuh dia. ");
INSERT INTO indags_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ketika saudara-saudara seiman mengetahui hal ini, mereka membawa Saulus ke kota Kaisarea, lalu mengirim dia ke Tarsus. ");
INSERT INTO indags_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Selama waktu ini, seluruh gereja di seluruh Yudea, Galilea dan Samaria ada dalam keadaan damai. Gereja menjadi kuat dan anggotanya bertambah banyak dengan cepat. Orang-orang percaya ini hidup dalam hormat kepada Tuhan,, dan mendapat semangat dari Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus sedang melakukan perjalanan dan pergi mengunjungi orang-orang percaya yang tinggal di Lida. ");
INSERT INTO indags_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Di sana Petrus bertemu dengan seorang yang bernama Eneas yang lumpuh dan tidak bisa bangun dari tempat tidur selama delapan tahun. ");
INSERT INTO indags_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus berkata kepadanya, “Eneas, Yesus Kristus menyembuhkan kamu! Bangun dan angkat tikarmu!” Dengan segera Eneas bangun. ");
INSERT INTO indags_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Setiap orang yang tinggal di Lida dan Asaron melihat dia, dan menjadi percaya kepada Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Di Yope tinggal seorang murid yang bernama Tabita atau Dorkas dalam bahasa Yunani. Dia selalu melakukan perbuatan yang baik dan menolong orang-orang miskin. ");
INSERT INTO indags_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Namun pada waktu Petrus sedang di Lida, Dorkas jatuh sakit dan meninggal. Sesudah memandikan dia, mereka membaringkan mayatnya di ruangan atas. ");
INSERT INTO indags_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kota Lida dekat dengan kota Yopa, maka para murid yang ada di kota Yopa, mendengar bahwa Petrus sedang ada di kota Lida, mengirimkan dua orang kepadanya dengan pesan, “Segeralah datang mengunjungi kami.” ");
INSERT INTO indags_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Maka Petrus bersiap-siap dan berangkat bersama mereka. Ketika dia tiba, mereka membawanya ke ruangan atas. Semua janda-janda sedang menangis di sana, dan mereka menunjukkan kepada Petrus jubah dan pakaian yang dibuat oleh Dorkas ketika dia masih hidup. ");
INSERT INTO indags_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus minta agar mereka semua pergi, lalu dia berlutut dan berdoa. Sesudah itu berkatalah dia kepada mayat itu, “Tabita, bangunlah.” Dan perempuan itu membuka matanya, dan ketika dia melihat Petrus, dia bangun dan duduk. ");
INSERT INTO indags_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus memegang tangan Dorkas dan membantunya berdiri. Dia memanggil para orang percaya dan janda-janda, dan mempersembahkan kepada mereka Dorkas yang hidup. ");
INSERT INTO indags_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Berita itu menyebar ke seluruh daerah Yopa, dan banyak orang menjadi percaya kepada Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus menghabiskan waktu yang lama di kota Yopa, tinggal di rumah seorang bernama Simon, yang adalah seorang penyamak kulit binatang. ");
INSERT INTO indags_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Di kota Kaisarea tinggallah seorang laki-laki bernama Kornelius yang merupakan perwira Romawi yang memimpin seratus pasukan yang bernama batalyon Italia. ");
INSERT INTO indags_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Dia adalah seorang yang taat kepada agamanya, bersama dengan seluruh anggota keluarganya, menyembah Allah. Dia sangat murah hati kepada orang-orang miskin, dan dengan teratur berdoa kepada Allah. ");
INSERT INTO indags_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sekitar pukul 3 sore, suatu hari Kornelius mendapat sebuah penglihatan di mana dia sangat jelas melihat malaikat Allah datang kepadanya dan memanggil dia, “Kornelius!” ");
INSERT INTO indags_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Takut, Kornelius menatap malaikat itu dan bertanya, “Apakah yang Engkau inginkan, Tuhan?” “Allah menaruh perhatian kepada doa-doamu, dan sedekahmu kepada orang miskin sudah dilihat-Nya,” kata malaikat itu kepada Kornelius. ");
INSERT INTO indags_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Sekarang, kirimlah beberapa orang ke kota Yopa, dan panggillah Simon yang juga diberi nama Petrus, ");
INSERT INTO indags_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","yang sedang menginap di rumah seorang penyamak kulit yang bernama Simon di dekat tepi pantai.” ");
INSERT INTO indags_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ketika malaikat yang memberikan pesan itu sudah pergi, Kornelius memanggil dua orang pekerja rumahnya dan seorang prajurit pengawal pribadinya yang juga seorang yang menyembah Allah. ");
INSERT INTO indags_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Sesudah dia menjelaskan kepada mereka segala yang sudah terjadi, dia mengirim mereka ke kota Yope. ");
INSERT INTO indags_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Keesokan harinya, sementara mereka dalam perjalanan menuju kota, Petrus naik ke bagian atas rumah untuk berdoa. Hari ketika itu menjelang tengah hari, ");
INSERT INTO indags_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","dan Petrus mulai merasa lapar dan ingin makan. Tetapi sementara makanan sedang disiapkan, Petrus mendapatkan suatu penglihatan, dan ");
INSERT INTO indags_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","dia melihat surga terbuka. Dia melihat sesuatu yang seperti selembar kain yang sangat lebar dipegang oleh keempat sudutnya sedang diturunkan ke atas bumi. ");
INSERT INTO indags_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Di dalamnya terdapat berbagai macam jenis hewan dan binatang yang reptil dan burung-burung. ");
INSERT INTO indags_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dan dia mendengar suara berkata, “Bangunlah Petrus, bunuhlah dan makanlah!” ");
INSERT INTO indags_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tetapi Petrus menjawab, “Tidak akan, Tuhan! Aku tidak pernah makan sesuatu yang dinyatakan haram atau najis.” ");
INSERT INTO indags_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dia mendengar suara itu kembali berkata, “Jangan mengatakan sesuatu itu haram jika Allah sudah membuatnya halal!” ");
INSERT INTO indags_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hal ini terjadi sampai tiga kali, dan lalu kain itu dengan cepat terangkat kembali ke surga. ");
INSERT INTO indags_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus masih bertanya-tanya arti dari penglihatan yang baru saja dia terima ketika orang-orang yang dikirim oleh Kornelius sudah menemukan rumah Simon dan sedang berdiri di pintu pagar. ");
INSERT INTO indags_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mereka memanggil, dan bertanya, “Apakah seorang yang bernama Simon yang disebut juga Petrus tinggal disini?” ");
INSERT INTO indags_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Sementara Petrus masih memikirkan penglihatan itu, Roh Kudus berkata kepadanya, “Dengar, ada tiga orang sedang mencari kamu. ");
INSERT INTO indags_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Berdiri dan turunlah, dan pergilah bersama mereka. Jangan kuatir sebab Akulah yang mengutus mereka.” ");
INSERT INTO indags_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Maka Petrus turun ke bawah dan menemui para tamu itu. “Akulah orang yang kalian cari,” katanya, “Mengapa kalian ada disini?” ");
INSERT INTO indags_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Kami adalah para pekerja Kornelius, seorang yang takut akan Allah, baik, beragama dan dihormati oleh orang Yahudi secara luas,” jawab mereka. “Seorang malaikat memerintahkan agar dia mengirim pesan untuk menjemput Bapak untuk datang ke rumahnya agar dia bisa mendengarkan pengajaran Bapak.” ");
INSERT INTO indags_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lalu Petrus mengundang mereka masuk dan mereka bermalam di rumah itu. Keesokan harinya dia bangun dan ikut pergi dengan mereka. Beberapa orang percaya dari Yope juga ikut bersama dengan mereka. ");
INSERT INTO indags_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Keesokan harinya mereka tiba di kota Kaisarea dimana Kornelius sedang menunggu mereka bersama-sama dengan saudara-saudara dan teman-teman dekatnya yang dipanggilnya untuk berkumpul. ");
INSERT INTO indags_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ketika Petrus masuk ke dalam rumah itu, Kornelius menemui dia dan sujud menyembah dia. ");
INSERT INTO indags_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tetapi Petrus menariknya naik, dan berkata, “Berdirilah! Aku hanya seorang manusia!” ");
INSERT INTO indags_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petrus berbicara kepada Kornelius, dan masuk ke dalam rumah di mana dia mendapati banyak orang sedang menunggunya. ");
INSERT INTO indags_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Katanya kepada mereka, “Kalian tentu tahu bahwa tidak diijinkan bagi seorang Yahudi untuk bergaul ataupun mengunjungi orang yang bukan Yahudi. Tetapi Allah sudah menunjukkan kepadaku bahwa bukanlah hakku untuk mengatakan seseorang itu najis ataupun tidak kudus. ");
INSERT INTO indags_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Itu sebabnya aku datang tanpa merasa keberatan ketika aku diundang. Sekarang, aku ingin tahu alasan aku diundang ke sini.” ");
INSERT INTO indags_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","“Empat hari lalu, sekitar waktu ini — jam tiga di sore hari — aku sedang berdoa di dalam rumah,” kata Kornelius. “Tiba-tiba aku melihat seseorang berdiri di depanku, mengenakan pakaian yang bersinar terang. ");
INSERT INTO indags_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Katanya kepadaku, ‘Kornelius, doamu sudah didengar, dan Allah sudah mengetahui kemurahan hatimu kepada orang-orang miskin. ");
INSERT INTO indags_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kirimlah seseorang ke kota Yope untuk mencari Simon Petrus. Dia sedang menginap di rumah seorang penyamak kulit yang bernama Simon di dekat tepi pantai.’ ");
INSERT INTO indags_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jadi aku segera mengirimkan utusan kepadamu, dan sungguh Bapak baik sekali mau datang. Itu sebabnya kami semua berkumpul di sini di hadapan Allah, siap mendengarkan segala yang sudah Tuhan sampaikan kepada Bapak.” ");
INSERT INTO indags_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petrus menjawab, “Aku sangat yakin bahwa Allah menganggap kita semua sama. ");
INSERT INTO indags_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dalam setiap bangsa, Allah menerima mereka yang menghormati Dia, dan lakukan apa yang baik dan benar. ");
INSERT INTO indags_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kalian tahu pesan yang Allah sampaikan kepada bangsa Israel, membagikan kabar baik tentang damai melalui Yesus Kristus, yang adalah Tuhan atas semua. ");
INSERT INTO indags_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kalian sudah tahu bahwa kabar baik ini menyebar ke seluruh Yudea, dimulai dari Galilea, dengan panggilan untuk dibaptis dari Yohanes. ");
INSERT INTO indags_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Hal itu adalah berita tentang Yesus dari Nasaret — bagaimana Allah sudah mengurapi Dia dengan Roh Kudus dan dengan kuasa, dan bagaimana Dia melakukan perjalanan mengelilingi daerah-daerah sambil berbuat baik, menyembuhkan mereka yang ada di bawah kuasa setan, sebab Allah bersama dengan Dia. ");
INSERT INTO indags_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kami dapat menyampaikan kesaksian untuk semua yang Dia lakukan di Yudea dan di Yerusalem. Mereka membunuh Dia dengan cara menyalibkan Dia. ");
INSERT INTO indags_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tetapi Allah kembali membangkitkan Dia dari antara orang mati pada hari yang ketiga, dan Dia menampakkan diri, ");
INSERT INTO indags_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","tidak kepada semua orang, tetapi kepada para saksi yang sudah dipilih oleh Allah — termasuk kami, yang makan dan minum bersama-Nya sesudah Dia bangkit dari antara orang mati. ");
INSERT INTO indags_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dia memberikan kami tanggung jawab untuk memberitakan hal ini secara umum kepada semua orang, bersaksi bahwa Dia adalah yang Allah pilih menjadi hakim antara orang yang hidup dan yang mati. ");
INSERT INTO indags_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dialah yang diberitakan oleh para nabi, bahwa barangsiapa yang percaya kepada-Nya akan menerima pengampunan melalui nama-Nya.” ");
INSERT INTO indags_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sementara Petrus masih berbicara, Roh Kudus turun atas ke semua pendengar berita itu. ");
INSERT INTO indags_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Para orang percaya yang berasal dari Yahudi yang datang bersama Petrus merasa sangat heran, sebab karunia Roh Kudus juga diberikan kepada orang-orang asing. ");
INSERT INTO indags_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Orang-orang percaya ini mendengar orang-orang bukan Yahudi ini berbicara dalam berbagai macam bahasa — sesuai dengan yang diberikan Roh Kudus kepada mereka, memuji Allah. ");
INSERT INTO indags_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Lalu Petrus berkata, “Adakah yang akan melarang mereka untuk dibaptis dengan air, sebab mereka sudah menerima baptisan Roh Kudus seperti yang kita dapat?” ");
INSERT INTO indags_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Petrus memerintahkan agar orang-orang ini dibaptis dalam nama Yesus Kristus. Lalu mereka memohon agar dia masih mau tinggal bersama-sama dengan mereka beberapa waktu lamanya. ");
INSERT INTO indags_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Para rasul dan saudara-saudara di Yudea mendengar bahwa orang-orang bukan Yahudi juga sudah mendengar Firman Allah. ");
INSERT INTO indags_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ketika Petrus kembali ke kota Yerusalem, mereka yang percaya kepada adat istiadat sunat berdebat dengan dia. ");
INSERT INTO indags_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kamu masuk ke rumah orang bukan Yahudi, dan mereka bahkan tidak disunat, dan makan bersama mereka,” kata orang-orang ini. ");
INSERT INTO indags_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petrus mulai menjelaskan kepada mereka tentang segala sesuatu yang sudah terjadi. ");
INSERT INTO indags_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Sementara aku sedang ada di kota Yopa, aku sedang berdoa, dan aku mendapat sebuah penglihatan. Ada sebuah kain yang sangat lebar yang sedang diturunkan dengan empat sudutnya dari surga, dan turun tepat di depan saya. ");
INSERT INTO indags_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ketika aku memeriksa isinya, aku melihat ada berbagai jenis binatang, hewan-hewan liar, binatang reptil dan berbagai jenis burung. ");
INSERT INTO indags_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lalu aku mendengar sebuah suara berkata kepadaku, ‘Bangunlah, Petrus, sembelihlah dan makanlah.’ ");
INSERT INTO indags_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tetapi aku menjawab, ‘Sudah tentu tidak, Tuhan! Tidak pernah ada makanan apapun yang haram atau najis masuk dalam mulutku!’ ");
INSERT INTO indags_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Suara yang dari surga kembali berkata, ‘Jangan kamu menyatakan apa yang sudah Allah buat halal menjadi haram!’ ");
INSERT INTO indags_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hal ini terjadi sebanyak tiga kali, dan sesudah itu semua terangkat naik ke surga. ");
INSERT INTO indags_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tepat saat itu tiga orang berdiri di depan pagar rumah tempat kami menginap. Mereka dikirim dari kota Kaisarea untuk menjemput aku. ");
INSERT INTO indags_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roh Kudus mengatakan agar aku pergi bersama mereka, dan untuk tidak merasa kuatir tentang siapa mereka. Enam orang saudara-saudara ini juga hadir bersamaku, dan kami masuk ke dalam rumah orang itu. ");
INSERT INTO indags_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kornelius menjelaskan kepada kami bagaimana malaikat muncul di hadapannya di dalam rumahnya, yang berkata, ‘Utuslah seseorang ke kota Yopa, dan jemputlah Simon, yang disebut juga Petrus, ");
INSERT INTO indags_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","yang akan memberitahu kepada kamu apa yang kamu perlu dengar agar kamu bisa diselamatkan — kamu dan seluruh rumah tangga kamu.’ ");
INSERT INTO indags_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ketika aku mulai berbicara, Roh Kudus turun atas mereka, seperti yang terjadi kepada kita dulu. ");
INSERT INTO indags_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lalu aku ingat yang Tuhan katakan, ‘Yohanes membaptis kalian dengan air, tetapi kalian akan dibaptis dengan Roh Kudus.’ ");
INSERT INTO indags_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Sejak Allah memberikan mereka hadiah yang sama seperti yang Dia berikan kepada kita ketika kita menjadi percaya dalam Tuhan Yesus Kristus, otoritas apa yang aku punya hingga aku bisa menentang Allah?” ");
INSERT INTO indags_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sesudah mendengarkan penjelasan Petrus, mereka tidak lagi berdebat dengan dia, sebaliknya mereka memuji Allah dan berkata, “Sekarang Allah sudah memberikan kesempatan juga kepada orang-orang bukan Yahudi untuk bertobat dan memiliki kehidupan untuk selama-lamanya.” ");
INSERT INTO indags_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mereka yang tercerai berai oleh karena penganiayaan yang terjadi ketika Stefanus dibunuh melakukan perjalanan sampai ke Fenisia, Siprus dan Antiokia. Namun mereka hanya menceritakan kabar baik ini kepada sesama orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tetapi ketika beberapa dari mereka yang berasal dari Siprus dan Kirene tiba di kota Antiokia, mereka menceritakan tentang kabar baik ini kepada orang-orang Yunani juga, menceritakan kepada mereka tentang Tuhan Yesus. ");
INSERT INTO indags_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kuat kuasa Tuhan menyertai mereka dan banyak orang menjadi percaya kepada Tuhan dan menyembah Yesus. ");
INSERT INTO indags_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Berita tentang orang-orang yang baru percaya ini sampai ke kota Yerusalem dan para rasul memutuskan untuk mengutus Barnabas ke Antiokia. ");
INSERT INTO indags_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ketika Barnabas tiba di kota ini dan melihat sendiri betapa belas kasihan Allah bekerja, dia sangat bersukacita. Dia menguatkan mereka semua untuk benar-benar mendedikasikan diri mereka kepada Allah dan terus setia kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas adalah seorang yang baik, penuh dengan Roh Kudus dan sangat mempercayai Allah. Banyak orang yang menjadi percaya kepada Tuhan oleh karena pelayanan Barnabas. ");
INSERT INTO indags_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lalu Barnabas pergi ke kota Tarsus untuk mencari Saulus, ");
INSERT INTO indags_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","dan ketika bertemu dengannya, Barnabas membawa Saulus kembali bersamanya ke kota Antiokia. Sepanjang tahun berikutnya mereka bekerja sama dengan gereja, mengajar pesan kepada orang banyak. Di kota Antiokialah orang-orang percaya pertama kali diberi nama “Kristen.” ");
INSERT INTO indags_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pada waktu inilah beberapa orang yang memiliki karunia untuk bernubuat datang dari Yerusalem ke kota Antiokia. ");
INSERT INTO indags_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Salah seorang diantaranya bernama Agabus yang berdiri dan mengucapkan kata-kata peringatan oleh Roh Kudus bahwa akan ada bencana kelaparan dahsyat yang akan dialami Kerajaan Romawi. (Hal ini menjadi kenyataan pada masa pemerintahan Kaisar Klaudius.) ");
INSERT INTO indags_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Orang-orang percaya memutuskan untuk mengirimkan bantuan dana untuk menolong saudara-saudara yang tinggal di Yudea, dengan setiap orang memberikan menurut kemampuan mereka. ");
INSERT INTO indags_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jadi mereka melakukan ini dan mengirim uang yang terkumpul melalui Barnabas dan Saulus kepada para pemimpin gereja yang ada di sana. ");
INSERT INTO indags_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sekitar waktu itu juga, Raja Herodes mulai menganiaya beberapa anggota gereja. ");
INSERT INTO indags_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dia memerintahkan agar Yakobus, saudara laki-laki Yohanes, dieksekusi dengan pedang. ");
INSERT INTO indags_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ketika dia melihat bahwa orang-orang Yahudi senang dengan perbuatan yang dia lakukan, dia kemudian menangkap Petrus juga. (Peristiwa ini terjadi pada Hari Raya Roti Tidak Beragi.) ");
INSERT INTO indags_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petrus ditangkap, dan dijebloskan ke dalam penjara, dengan dijaga oleh empat regu yang masing-masing terdiri dari empat tentara. Herodes berencana mengadili Petrus di muka umum sesudah perayaan Paskah. ");
INSERT INTO indags_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ketika Petrus ditahan di dalam penjara, anggota jemaat berdoa dengan sungguh-sungguh kepada Allah untuknya. ");
INSERT INTO indags_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pada malam sebelum Herodes harus mengadili dia, Petrus sedang tidur di antara dua tentara, kedua tangannya diikat dengan rantai ke tangan masing-masing prajurit, dan dengan penjaga di depan pintu berjaga-jaga. ");
INSERT INTO indags_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tiba-tiba ada malaikat Tuhan muncul, dan cahaya bersinar di dalam sel. Malaikat itu membangunkan Petrus sambil berkata, “Cepat! Bangun!” Rantai-rantai itu lepas dari pergelangan tangannya, ");
INSERT INTO indags_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","dan malaikat itu berkata kepadanya, “Berpakaianlah, dan kenakan sandalmu.” Dan Petrus melakukannya. Kemudian malaikat itu berkata kepadanya, “Pakai mantelmu dan ikuti aku.” ");
INSERT INTO indags_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Lalu Petrus mengikuti malaikat itu keluar. Dia tidak menyadari bahwa apa yang malaikat itu lakukan benar-benar terjadi — dia pikir dia sedang melihat sebuah penglihatan. ");
INSERT INTO indags_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mereka melewati pasukan penjaga pertama dan kedua, dan sampai di pintu gerbang besi yang menuju ke kota. Pintu gerbang ini terbuka untuk mereka dengan sendirinya. Mereka keluar dan melanjutkan perjalanan, ketika tiba-tiba malaikat itu meninggalkannya. ");
INSERT INTO indags_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ketika Petrus sadar, dia berkata, “Sekarang aku sadar ini benar-benar terjadi! Tuhan sudah mengutus malaikat untuk menyelamatkan aku dari kekuasaan Herodes, dan dari segala sesuatu yang sudah direncanakan oleh orang-orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sekarang sesudah dia menyadari apa yang terjadi, Petrus pergi ke rumah Maria, ibu dari Yohanes Markus. Banyak orang percaya berkumpul di sana, dan berdoa. ");
INSERT INTO indags_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ketika dia mengetuk pintu gerbang, seorang gadis pelayan bernama Rhoda datang untuk membuka. ");
INSERT INTO indags_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Namun gadis itu tidak membukakan pintu karena terlalu gembira ketika dia mengenali suara Petrus. Dia kembali berlari masuk ke dalam rumah sambil berteriak, “Petrus ada di depan pintu!” ");
INSERT INTO indags_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Kamu gila!” kata mereka. Tetapi Rhoda terus bersikeras bahwa itu benar. Jadi mereka berkata, “Itu pasti malaikatnya.” ");
INSERT INTO indags_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrus terus mengetuk. Ketika mereka akhirnya membuka pintu, mereka melihat ternyata benar memang Petrus, dan mereka sangat terkejut. ");
INSERT INTO indags_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrus mengangkat tangannya agar mereka diam, lalu menjelaskan kepada mereka bagaimana Tuhan sudah menuntunnya keluar dari penjara. “Katakan kepada Yakobus dan saudara-saudara lainnya tentang ini,” katanya kepada mereka, lalu pergi ke tempat lain. ");
INSERT INTO indags_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ketika fajar tiba, tentara-tentara itu sangat bingung dengan apa yang terjadi pada Petrus. ");
INSERT INTO indags_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes sudah memerintahkan untuk mencari dia dengan saksama, tetapi para prajurit tidak dapat menemukannya. Sesudah menginterogasi para penjaga, Herodes memerintahkan agar mereka dieksekusi. ");
INSERT INTO indags_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes marah kepada orang Tirus dan Sidon. Mereka bersatu mengirim pesan untuk menemuinya dan berhasil memenangkan Blastus, asisten pribadi raja, untuk berpihak kepada mereka. Mereka memohon perdamaian dengan Herodes karena mereka bergantung pada wilayah raja untuk memenuhi kebutuhan makanan mereka. ");
INSERT INTO indags_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ketika harinya tiba untuk perjanjian mereka dengan raja, Herodes mengenakan jubah kerajaannya, duduk di singgasananya, dan memberikan pidato kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Penonton berteriak menanggapi, “Ini adalah suara dewa, bukan suara manusia!” ");
INSERT INTO indags_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Seketika itu juga malaikat Tuhan memukulnya, sebab Herodes mengambil kemuliaan yang seharusnya diberikan kepada Allah. Dia dimakan oleh cacing dan mati. ");
INSERT INTO indags_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tetapi firman Tuhan menyebar, dan semakin banyak orang menjadi percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas dan Saul kembali dari Yerusalem sesudah mereka menyelesaikan misi mereka, membawa serta Yohanes Markus bersama dengan mereka. ");
INSERT INTO indags_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pada waktu itu ada beberapa orang di gereja di Antiokia yang memiliki karunia bernubuat dan mengajar, yaitu: Barnabas, Simeon Niger, Lucius dari Kirene, Manaen (teman masa kecil Herodes sang raja wilayah), dan Saulus. ");
INSERT INTO indags_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sementara mereka menyembah Tuhan dan berpuasa, Roh Kudus berkata, “Khususkanlah Barnabas dan Saulus untuk melakukan pekerjaan yang sudah Aku rencanakan bagi mereka.” ");
INSERT INTO indags_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sesudah mereka berpuasa, berdoa, dan meletakkan tangan ke atas Barnabas dan Saulus sebagai tanda berkat, mereka mengirim keduanya untuk melakukan tugas yang Tuhan sudah tetapkan. ");
INSERT INTO indags_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jadi Barnabas dan Saulus, dipimpin oleh Roh Kudus, pergi ke Seleukia. Dari sana mereka berlayar ke Siprus. ");
INSERT INTO indags_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Setibanya di Salamis, mereka memberitakan Firman Allah di rumah-rumah ibadah orang Yahudi. Yohanes Markus ikut bersama mereka sebagai asisten. ");
INSERT INTO indags_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mereka melakukan perjalanan ke seluruh pulau dan akhirnya sampai ke Pafos. Di sana mereka menemukan seorang tukang sihir Yahudi, seorang nabi palsu bernama Bar-yesus. ");
INSERT INTO indags_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia dekat dengan gubernur, Sergius Paulus, seorang yang cerdas. Sergius Paulus mengundang Barnabas dan Saulus untuk datang mengunjunginya karena dia ingin mendengar Firman Allah. ");
INSERT INTO indags_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tetapi tukang sihir Elimas (nama Yunaninya) menentang mereka, berusaha mencegah gubernur percaya kepada Allah. ");
INSERT INTO indags_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulus, yang juga dipanggil Paulus, dipenuhi dengan Roh Kudus, dan menatap lurus ke arah Elimas. ");
INSERT INTO indags_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Kamu penuh tipu daya dan segala macam kejahatan, hai anak iblis, hai musuh semua yang benar! Berhentilah memutar balikkan jalan Tuhan! ");
INSERT INTO indags_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lihatlah, tangan Tuhan turun atasmu dan kamu akan menjadi buta. Kamu tidak akan melihat matahari untuk sementara.” Tiba-tiba ada yang serupa dengan kabut dan kegelapan menimpanya, dan dia harus menemukan seseorang yang bisa menuntun tangannya. ");
INSERT INTO indags_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ketika gubernur melihat apa yang terjadi, dia menjadi percaya kepada Allah, dan kagum pada ajaran tentang Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kemudian Paulus dan orang-orang yang bersamanya berlayar dari Pafos menuju ke Perga di Pamfilia, sedangkan Yohanes Markus meninggalkan mereka dan kembali ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mereka melewati Perga dan terus ke Antiokia di Pisidia. Pada hari Sabat mereka pergi ke rumah-rumah ibadah dan duduk. ");
INSERT INTO indags_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sesudah pembacaan dari Hukum Taurat dan Kitab Para Nabi, para pemimpin rumah ibadah mengirimi mereka pesan yang mengatakan, “Saudara-saudara, silakan berbagi dengan jemaat kata-kata yang bisa menguatkan kami di sini.” ");
INSERT INTO indags_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus berdiri, memberi isyarat dengan tangannya untuk menarik perhatian mereka, dan mulai berbicara. “Orang-orang Israel, dan kalian semua yang menghormati Allah, dengarkan aku. ");
INSERT INTO indags_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allah orang Israel memilih nenek moyang kita, dan memberikan kemakmuran kepada mereka selama tinggal di tanah Mesir. Kemudian dengan kekuatannya yang besar Dia memimpin mereka keluar dari Mesir, ");
INSERT INTO indags_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","dan dengan sabar Dia menangani mereka di padang gurun selama kira-kira empat puluh tahun. ");
INSERT INTO indags_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sesudah Dia menggulingkan tujuh bangsa yang tinggal di tanah Kanaan, Allah membagi tanah mereka di antara orang Israel dan memberistiwa ini memakan waktu sekitar empat ratus lima puluh tahun. ");
INSERT INTO indags_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kemudian Dia menyediakan mereka hakim-hakin sebagai pemimpin sampai zaman nabi Samuel. ");
INSERT INTO indags_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lalu bangsa Israel meminta supaya mereka dipimpin oleh seorang raja, dan Allah memberi mereka Saul, anak laki-laki Kish dari suku Benyamin, yang memerintah atas Israel selama empat puluh tahun. ");
INSERT INTO indags_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kemudian Allah menyingkirkan Saul, dan menjadikan Daud raja mereka. Allah mengakui Daud, dengan mengatakan ‘Aku mendapati Daud anak Isai sebagai seorang yang sangat memahami Aku; dia akan melakukan semua yang Aku inginkan.’ ");
INSERT INTO indags_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yesus adalah keturunan Daud; Dia adalah Juruselamat yang Allah janjikan untuk menyelamatkan Israel. ");
INSERT INTO indags_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sebelum Yesus datang, Yohanes mengumumkan baptisan pertobatan kepada semua orang Israel. ");
INSERT INTO indags_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sewaktu Yohanes menyelesaikan misinya, dia berkata, ‘Menurut kalian, siapakah saya ini? Saya bukan orang yang kalian cari. Tetapi sesudah aku akan datang seseorang yang sandalnya tidak layak untuk kulepaskan.’ ");
INSERT INTO indags_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Saudaraku, anak-anak Abraham dan kalian semua yang menghormati Allah: pesan keselamatan ini sudah dikirim kepada kami! ");
INSERT INTO indags_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Orang-orang yang tinggal di Yerusalem dan para pemimpin mereka tidak mengenali Yesus atau memahami perkataan yang diucapkan oleh para nabi yang dibacakan setiap Sabat. Nyatanya mereka menggenapi kata-kata nubuatan dengan menghukum mati dia! ");
INSERT INTO indags_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Meskipun mereka tidak dapat menemukan bukti untuk menghukum mati Dia, mereka tetap meminta agar Pilatus melakukannya. ");
INSERT INTO indags_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sesudah mereka memenuhi setiap nubuatan yang tertulis oleh para nabi terhadap Dia, mereka menurunkan Dia dari salib dan menguburkan Dia di dalam kuburan batu. ");
INSERT INTO indags_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tetapi Allah membangkitkan dia dari antara orang mati, ");
INSERT INTO indags_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","dan selama beberapa hari Dia menampakkan diri kepada orang-orang yang sudah mengikuti dia dari Galilea ke Yerusalem. Mereka sekarang menjadi saksinya kepada orang banyak. ");
INSERT INTO indags_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kami di sini untuk membawakan kepada kalian kabar baik tentang janji yang Allah buat kepada nenek moyang kita, ");
INSERT INTO indags_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","bahwa Dia sekarang sudah menggenapi kepada kita, anak-anak mereka, dengan membangkitkan Yesus dari antara orang mati. Seperti yang tertulis dalam Mazmur 2: ‘Kamu adalah Putraku; hari ini Aku sudah menjadi Ayahmu.’ ");
INSERT INTO indags_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allah membangkitkan Dia dari antara orang mati, tidak akan pernah mati lagi, seperti yang Dia tunjukkan dengan mengatakan, ‘Aku akan memberimu apa yang kudus dan dapat dipercaya, seperti yang Aku janjikan kepada Daud.’ ");
INSERT INTO indags_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sebagaimana mazmur lain berkata, ‘Engkau tidak akan membiarkan Yang Kudusmu membusuk dalam kubur.’ ");
INSERT INTO indags_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tetapi Daud mati, sesudah dia melakukan apa yang Allah inginkan pada masa hidupnya, dan dia dikuburkan bersama leluhurnya, dan tubuhnya membusuk. ");
INSERT INTO indags_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dia yang dibangkitkan Allah dari antara orang mati tidak mengalami pembusukan. ");
INSERT INTO indags_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Saudaraku, saya ingin kalian memahami bahwa kami memberi tahu kalian bahwa melalui Orang ini dosa diampuni. ");
INSERT INTO indags_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Melalui Dia setiap orang yang percaya kepada-Nya dibuat benar secara moral dari semua yang salah — dengan cara yang jika diatur dengan hukum Taurat, kalian tidak akan pernah dapat dianggap orang yang hidup dalam kebenaran. ");
INSERT INTO indags_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pastikan bahwa apa yang para nabi katakan tidak terjadi kepadamu: ");
INSERT INTO indags_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kamu yang mencemooh, lihatlah dengan takjub, dan matilah! Sebab untuk apa yang Aku lakukan dalam hidupmu adalah sesuatu yang tidak pernah kamu bisa percaya, bahkan jika seseorang mengatakan kepadamu!’” ");
INSERT INTO indags_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ketika mereka pergi, orang-orang memohon mereka untuk memberitahu mereka lebih lagi pada hari Sabat berikutnya. ");
INSERT INTO indags_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sesudah pertemuan di rumah ibadah, banyak orang Yahudi dan orang yang pindah ke agama Yahudi mengikuti Paulus dan Barnabas yang berbicara dengan mereka, mendorong mereka untuk terus berpegang pada kasih karunia Allah. ");
INSERT INTO indags_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pada hari Sabat berikutnya hampir seluruh kota datang untuk mendengarkan firman Allah. ");
INSERT INTO indags_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Akan tetapi, ketika orang-orang Yahudi melihat orang banyak itu, mereka menjadi sangat cemburu, menentang apa yang dikatakan Paulus dan mengutuknya. ");
INSERT INTO indags_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jadi Paulus dan Barnabas berbicara dengan tegas, mengatakan “Kami harus mengucapkan firman Allah kepadamu terlebih dahulu. Tetapi sekarang sesudah kamu menolaknya — kamu memutuskan bahwa kamu tidak layak untuk kehidupan kekal — sekarang kami akan mengucapkan firman Allah kepada orang-orang bukan Yahudi. ");
INSERT INTO indags_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Itulah yang Tuhan perintahkan agar kita lakukan: ‘Aku sudah menjadikanmu terang bagi orang-orang bukan Yahudi, dan melalui kamu keselamatan akan sampai ke ujung bumi.’” ");
INSERT INTO indags_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ketika orang-orang bukan Yahudi mendengar perkataan ini, mereka sangat gembira, memuji firman Tuhan, dan semua orang yang dipilih untuk hidup kekal percaya kepada Allah. ");
INSERT INTO indags_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Maka Firman Allah disebarkan ke seluruh wilayah. ");
INSERT INTO indags_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tetapi orang-orang Yahudi menghasut para perempuan terkemuka yang menyembah Allah dan pemimpin kota untuk menganiaya Paulus dan Barnabas, dan mengusir keduanya dari wilayah mereka. ");
INSERT INTO indags_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Maka keduanya mengibaskan debu dari kaki mereka sebagai tanda peringatan, dan pergi ke Ikonium. ");
INSERT INTO indags_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dan orang-orang percaya terus dipenuhi dengan sukacita dan dengan Roh Kudus. ");
INSERT INTO indags_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Di kota Ikonium hal yang sama terjadi. Paulus dan Barnabas pergi ke rumah ibadah orang Yahudi dan berbicara begitu meyakinkan sehingga banyak orang Yahudi dan orang bukan Yahudi menjadi percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tetapi orang-orang Yahudi yang menolak untuk percaya kepada Yesus menghasut orang-orang bukan Yahudi, supa mereka menentang orang-orang percaya itu. ");
INSERT INTO indags_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulus dan Barnabas tinggal cukup lama di tempat itu, berbicara tentang Firman Tuhan dengan berani. Dan Tuhan menguatkan pesan mereka melalui perbuatan-perbuatan ajaib yang mereka lakukan. ");
INSERT INTO indags_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Penghuni kota terbagi menjadi dua kelompok, ada yang mendukung orang-orang Yahudi dan ada yang menjadi pendukung para rasul. ");
INSERT INTO indags_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tetapi kemudian sebagian orang-orang bukan Yahudi dan orang-orang Yahudi bersama dengan pemimpin mereka, merencanakan untuk menyerang dan melempari Paulus dan Barnabas dengan batu. ");
INSERT INTO indags_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Namun niat itu diketahui oleh Paulus dan Barnabas dan mereka segera pergi dari kota itu ke daerah Likaonia, menuju kota Listra dan Derbe, ");
INSERT INTO indags_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","di situ mereka meneruskan menyebarkan berita kabar baik. ");
INSERT INTO indags_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Di kota Listra ada seorang yang cacat karena kedua kakinya lumpuh. Dia sudah cacat sejak lahir dan tidak pernah bis berjalan. ");
INSERT INTO indags_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Orang itu duduk mendengarkan Paulus berbicara. Ketika Paulus menatap langsung kepadanya, Paulus menyadari bahwa orang ini memiliki rasa percaya yang kuat kepada Allah untuk bisa menyembuhkan dia, ");
INSERT INTO indags_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulus berkata dengan suara keras, “Berdirilah dengan kakimu!” Orang itu melompat dan berdiri dan mulai berjalan. ");
INSERT INTO indags_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ketika orang banyak melihat perbuatan Paulus, mereka berseru dakam bahasa Likaonia, “Dewa-dewa sudah turun ke antara kita dalam rupa manusia!” ");
INSERT INTO indags_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mereka menganggap Barnabas sebagai Zeus dewa Yunani, dan Paulus sebagai dewa Hermes sebab dialah yang paling banyak bicara. ");
INSERT INTO indags_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Imam dari kuil dewa Zeus yang letaknya dekat dengan kota, membawa lembu jantan dan karangan bunga ke gerbang kota. Dia berencana mengadakan kurban persembahan di hadapan orang banyak. ");
INSERT INTO indags_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tetapi ketika rasul Barnabas dan Paulus memahami apa yang sedang terjadi, mereka merobek jubah mereka, dan bergegas menuju ke orang banyak sambil berteriak dengan kencang, ");
INSERT INTO indags_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Teman-teman, kalian sedang apa? Kami hanya manusia biasa sama seperti kalian semua. Kami membawa kabar baik untuk kalian, agar kalian bisa berhenti percaya kepada sesembahan palsu dan mau menyembah Allah sejati yang hidup. Dialah pencipta langit, bumi, laut dan segala isi yang ada didalamnya. ");
INSERT INTO indags_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Di masa lalu Dia mengijinkan bangsa-bangsa mengikuti cara mereka sendiri. ");
INSERT INTO indags_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Namun demikian Dia masih membuktikan keberadaan diri-Nya dengan melakukan kebaikan, mengirimkan kepada kalian hujan dari langit, dan hasil panen pada musimnya, menyediakan segala kebutuhan makanan kalian, dan membuat hati kalian merasa gembira.” ");
INSERT INTO indags_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Dengan kata-kata ini mereka hampir saja tidak bisa menghentikan orang banyak itu dari memberikan kurban persembahan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tetapi kemudian beberapa orang Yahudi dari kota Antiokia dan Ikonium tiba dan memenangkan banyak orang. Mereka melempari Paulus dengan batu dan menyeretnya ke luar kota, mengira bahwa Paulus sudah mati. ");
INSERT INTO indags_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tetapi ketika orang-orang percaya mengelilingi dia, bangunlah Paulus dan masuk kembali ke kota. Keesokan harinya, dia dan Barnabas meninggalkan Derbe. ");
INSERT INTO indags_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Sesudah membagikan kabar baik dengan orang-orang di sana, dan banyak orang yang menjadi percaya, mereka kembali ke Listra, Ikonium dan Antiokia. ");
INSERT INTO indags_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mereka memberikan kata-kata yang menambah semangat kepada para orang percaya untuk tetap teguh dan terus percaya kepada Yesus. “Kita harus mengalami banyak pencobaan untuk masuk ke dalam Kerajaan Allah,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sesudah menetapkan penatuapenatua untuk setiap jemaat, dan sesudah berdoa dan berpuasa bersama mereka, Paulus dan Barnabas meninggalkan mereka dalam lindungan Yesus, Tuhan yang mereka percayai. ");
INSERT INTO indags_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mereka berjalan kembali melalui daerah Pisidia, dan tiba di wilayah Pamfilia. ");
INSERT INTO indags_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mereka memberitakan Firman Allah di Perga, lalu melanjutkan perjalanan ke Attalia. ");
INSERT INTO indags_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dari Attalia mereka berlayar kembali ke tempat awal mereka memulai perjalanan, kota Antiokia, sesudah dikhususkan di sana dalam kemuliaan Allah untuk mengerjakan tugas yang sekarang sudah mereka selesaikan. ");
INSERT INTO indags_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ketika mereka tiba, mereka mengumpulkan seluruh jemaat. Mereka melaporkan segala sesuatu yang Allah lakukan melalui mereka, dan bagaimana Allah sudah membuka pintu bagi orang-orang bukan Yahudi untuk percaya kepada Dia. ");
INSERT INTO indags_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mereka tetap diam di Antiokia bersama para orang percaya untuk waktu yang lama. ");
INSERT INTO indags_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tetapi kemudian, beberapa orang tiba dari wilayah Yudea yang mulai mengajarkan orang-orang percaya demikian, “Kecuali kalian disunat sesuai dengan peraturan yang sudah ditetapkan oleh Musa, kalian tidak bisa diselamatkan.” ");
INSERT INTO indags_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus dan Barnabas banyak menyanggah dan berdebat dengan mereka. Maka Paulus dan Barnabas serta beberapa orang ditunjuk untuk pergi ke Yerusalem dan berbicara kepada para rasul dan pemimpin tentang masalah ini. ");
INSERT INTO indags_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dengan dukungan jemaat, mereka pergi ke Yerusalem, dan dalam perjalanan menuju Fenisia dan Samaria, Paulus dan Barnabas menjelaskan bagaimana orang-orang bukan Yahudi bertobat, yang membuat orang-orang percaya sangat senang. ");
INSERT INTO indags_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ketika mereka tiba di Yerusalem, mereka disambut oleh anggota jemaat, para rasul dan pemimpin-pemimpin jemaat lainnya. Mereka menjelaskan segala sesuatu yang sudah Allah lakukan melalui mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tetapi mereka ditentang oleh beberapa orang percaya yang masuk dalam kelompok Farisi. Kata mereka, “Orang-orang percaya itu harus disunat, dan diperintahkan untuk melakukan hukum Taurat.” ");
INSERT INTO indags_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Para rasul dan pemimpin jemaat mengadakan pertemuan untuk mendiskusikan masalah ini. ");
INSERT INTO indags_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sesudah perdebatan yang panjang, Petrus akhirnya berdiri dan berkata kepada mereka, “Saudara-saudara, kalian tahu bahwa beberapa waktu lalu Allah memilih aku dari antara kalian agar orang-orang bukan Yahudi boleh mendengarkan pesan kabar baik ini dan percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Allah, yang mengetahui cara berpikir kita, sudah menunjukkan bahwa Dia menerima mereka, memberikan Roh Kudus kepada mereka seperti juga kepada kita. ");
INSERT INTO indags_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Allah tidak membedakan antara kita dengan mereka — Dia membersihkan hati mereka ketika mereka percaya kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jadi mengapa kalian ingin menentang Allah dan menaruh beban atas orang-orang percaya yang tidak sanggup ditanggung baik oleh kita maupun nenek moyang kita? ");
INSERT INTO indags_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kita sudah percaya bahwa kita diselamatkan melalui kasih karunia dari Tuhan Yesus, sama seperti mereka yang bukan orang Yahudi.” ");
INSERT INTO indags_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Setiap orang mendengarkan dengan penuh perhatian setiap ucapan Barnabas dan Paulus ketika mereka menjelaskan berbagai perbuatan ajaib yang Allah lakukan melalui mereka di antara orang-orang bukan Yahudi. ");
INSERT INTO indags_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sesudah mereka selesai berbicara, Yakobus berkata, “Saudara-saudara, dengarkan saya. ");
INSERT INTO indags_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Petrus sudah menjelaskan cara Allah menunjukkan kepedulian-Nya kepada orang-orang bukan Yahudi dengan mengambil beberapa orang di antara mereka yang percaya kepada-Nya. ");
INSERT INTO indags_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dan hal ini sejalan dengan perkataan para nabi, seperti tertulis, ");
INSERT INTO indags_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Suatu saat Aku akan kembali, dan Aku akan membangun kembali reruntuhan keluarga Daud, Aku akan membangun kembali tembok-temboknya dan menegakkannya. ");
INSERT INTO indags_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Aku akan melakukan ini agar mereka yang masih hidup bisa datang kepada Tuhan, termasuk orang-orang bukan Yahudi yang percaya kepadaku. ");
INSERT INTO indags_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Inilah yang Tuhan katakan, yang menyatakan hal-hal ini jauh sebelum hal ini terjadi.’ ");
INSERT INTO indags_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jadi keputusanku adalah tidak seharusnya kita menyulitkan orang-orang bukan Yahudi yang sudah menjadi percaya kepada Allah. ");
INSERT INTO indags_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kita akan menulis kepada mereka dan memberitahu mereka untuk tidak makan makanan yang sudah dipersembahkan kepada dewa-dewa, tidak melakukan perselingkuhan, tidak makan daging hewan yang dibunuh dengan diputuskan lehernya, dan tidak boleh makan darah. ");
INSERT INTO indags_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sebab hukum Taurat sudah diajarkan di setiap kota sejak dari dahulu sampai sekarang — dan dibacakan di rumah-rumah ibadah setiap hari Sabat.” ");
INSERT INTO indags_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Lalu para rasul dan pemimpin-pemimpin jemaat, bersama dengan seluruh anggota jemaat, memutuskan adalah baik untuk memilih beberapa orang sebagai perwakilan mereka dan mengirim orang-orang ini bersama dengan Paulus dan Barnabas ke kota Antiokia. Mereka memilih Yudas Barsabas dan Silas, para pemimpin di antara jemaat, ");
INSERT INTO indags_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","dan mengirim mereka dengan surat yang berisi: “Salam dari kami, para rasul, pemimpin dan saudara-saudara, kepada saudara-saudara bukan orang Yahudi yang di kota Antiokia, Siria dan Silisia: ");
INSERT INTO indags_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kami sudah mendengar bahwa beberapa orang dari kelompok kita sudah membingungkan kalian dengan pengajaran mereka dan menyusahkan kalian. Sudah pasti kami tidak memerintahkan mereka untuk melakukan hal ini! ");
INSERT INTO indags_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jadi kami sudah bersepakat untuk memilih beberapa orang perwakilan dan mengirim mereka kepada kalian bersama dengan saudara-saudara kami terkasih, Barnabas dan Paulus, ");
INSERT INTO indags_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","yang sudah mempertaruhkan nyawa mereka demi Tuhan kita Yesus Kristus. ");
INSERT INTO indags_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jadi kami mengirimkan kepada kalian Yudas dan Silas yang bisa memberitahukan kepada kalian secara langsung perkataan kami. ");
INSERT INTO indags_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Keputusan yang terbaik bagi kalian sesuai dengan tuntunan Roh Kudus atas kami adalah untuk kami tidak menaruh beban yang tidak diperlukan kecuali untuk hal-hal ini: ");
INSERT INTO indags_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","yaitu, kalian haruslah menghindari apapun juga yang sudah dipersembahkan kepada berhala, darah, daging dari hewan yang dibunuh dengan cara dicekik, dan perselingkuhan. Kalian sudah benar jika kalian melakukan perbuatan-perbuatan ini. Allah memberkati kalian.” ");
INSERT INTO indags_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Orang-orang ini diutus menuju ke kota Antiokia. Ketika mereka tiba di sana, mereka mengumpulkan semua orang dan menyampaikan surat yang dititipkan kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Orang-orang bukan Yahudi di Antiokia merasa gembira sesudah mereka membaca pesan yang menguatkan mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas dan Silas, yang juga memiliki karunia bernubuat, memberi semangat para saudara-saudara yang hadir, menjelaskan banyak hal, dan menguatkan mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sesudah menghabiskan beberapa waktu lamanya bersama mereka, Yudas dan Silas diutus kembali oleh jemaat kepada orang-orang percaya di Yerusalem disertai dengan doa berkat bagi mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tetapi Paulus dan Barnabas tetap tinggal di kota Antiokia, mengajar dan memberitakan firman Allah bersama dengan orang-orang lain. ");
INSERT INTO indags_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Beberapa waktu kemudian, Paulus berkata kepada Barabas, “Mari kita mengunjungi orang-orang percaya di setiap kota di mana kita pernah menyampaikan firman Tuhan, dan sekaligus melihat keadaan mereka.” ");
INSERT INTO indags_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas juga berencana untuk membawa serta Yohanes Markus. ");
INSERT INTO indags_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tetapi menurut Paulus bukan ide yang baik untuk membawa serta Yohanes Markus, sebab dia meninggalkan mereka di kota Pamfilia dan tidak lagi melanjutkan pelayanan bersama mereka. ");
INSERT INTO indags_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Karena ketidaksepahaman ini, Paulus dan Barnabas akhirnya berpisah. Barnabas membawa Markus bersama dengan dia dan berlayar menuju ke pulau Siprus. ");
INSERT INTO indags_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus membawa Silas bersama dengannya, dan sementara mereka berangkat, orang-orang percaya mendoakan mereka agar mereka ada dalam lindungan Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulus melakukan perjalanan melalui daerah Siria dan Silisia, menguatkan keyakinan dari jemaat-jemaat yang ada di sana. ");
INSERT INTO indags_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Awal perjalanan Paulus berangkat ke Derbe, lalu menuju ke Listra, di mana dia bertemu dengan seorang percaya bernama Timotius. Ibu Timotius adalah seorang Kristen Yahudi, sedang ayahnya adalah seorang Yunani. ");
INSERT INTO indags_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Saudara-saudara di daerah Listra dan Ikonium mengatakan hal-hal yang baik tentang Timotius. ");
INSERT INTO indags_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ingin Timotius untuk ikut serta dalam perjalanannya, maka Paulus menyunat Timotius sebab orang-orang Yahudi di daerah itu tahu bahwa ayah Timotius adalah seorang Yunani. ");
INSERT INTO indags_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sepanjang kunjungan mereka ke berbagai kota, mereka menyampaikan aturan-aturan yang sudah diputuskan oleh para rasul dan pemimpin di Yerusalem kepada jemaat-jemaat untuk diikuti. ");
INSERT INTO indags_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jemaat merasa dikuatkan rasa percaya mereka dalam Tuhan dan setiap hari jumlah orang yang percaya semakin bertambah. ");
INSERT INTO indags_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mereka melalui daerah Frigia dan Galatia, sebab Roh Kudus mencegah mereka untuk memberitakan kabar baik ke provinsi Asia. ");
INSERT INTO indags_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ketika mereka tiba di perbatasan Misia, mereka mencoba masuk ke provinsi Bitinia, tetapi Roh Yesus sekali lagi mencegah mereka untuk masuk ke situ. ");
INSERT INTO indags_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jadi mereka melewati Misia dan pergi ke Troas. ");
INSERT INTO indags_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Di sana Paulus melihat dalam penglihatan pada malam hari seorang yang datang dari Makedonia sedang berdiri, memohon kepadanya, “Segeralah datang ke Makedonia dan tolonglah kami!” ");
INSERT INTO indags_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sesudah Paulus mendapat penglihatan ini, kami dengan segera membuat pengaturan untuk berangkat ke Makedonia, sebab kami mengambil kesimpulan bahwa Allah sudah memanggil kami untuk membagikan kabar baik itu kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kami berlayar dari Troas dan langsung menuju Samotrake. Pada keesokan harinya kami pergi ke Neapolis, ");
INSERT INTO indags_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","dan dari arah sana ke kota Filipi, kota yang paling penting di wilayah Makedonia, yang juga termasuk dalam wilayah Romawi. Kami tinggal di kota ini selama beberapa hari. ");
INSERT INTO indags_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pada hari Sabat kami pergi ke gerbang kota di sisi sungai di mana kami pikir orang-orang akan datang ke sana untuk berdoa. Kami duduk dan berbicara dengan perempuan-perempuan yang sedang berkumpul di tempat itu. ");
INSERT INTO indags_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Salah seorang di antaranya bernama Lidia, yang menjual kain ungu dari kota Tiatira. Dia menyembah Allah, dan mendengarkan kami Tuhan memberikan pemahaman ke dalam pikirannya atas ucapan-ucapan Paulus, dan dia menerima setiap ucapan yang dikatakan oleh Paulus. ");
INSERT INTO indags_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sesudah dia dan seluruh keluarganya dibaptis, dia memohon kepada kami, “Jika kalian sungguh-sungguh merasa saya benar-benar percaya kepada Tuhan, maka datang dan tinggallah di rumahku.” Dia terus mendesak sampai kami menerima permintaannya! ");
INSERT INTO indags_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Suatu hari ketika kami sedang pergi ke tempat berdoa, kami bertemu dengan seorang gadis pelayan yang dirasuki oleh roh jahat. Gadis itu menghasilkan uang yang besar bagi tuannya dengan memberikan ramalan. ");
INSERT INTO indags_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Gadis ini mengikuti Paulus dan kami sambil berteriak, “Orang-orang ini adalah pelayan dari Allah yang Mahakuasa. Mereka akan menceritakan kepada kalian bagaimana kalian bisa diselamatkan!” ");
INSERT INTO indags_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dia terus melakukan hal ini selama beberapa hari. Kegiatan ini sangat mengganggu Paulus sehingga dia berbalik dan berkata kepada roh itu, “Dalam nama Yesus Kristus, aku perintahkan keluar dari gadis ini!” Dan roh itu dengan segera meninggalkan gadis itu. ");
INSERT INTO indags_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tetapi ketika tuannya melihat bahwa mereka sudah kehilangan sumber pendapatan mereka, mereka menahan Paulus dan Silas dan menyeret mereka ke hadapan pejabat kota di pasar. ");
INSERT INTO indags_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Di hadapan para pejabat itu, orang-orang ini mendakwa Paulus dan Silas: “Orang-orang Yahudi ini menyebabkan kekacauan yang besar di kota kita,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","“Mereka mengajarkan hal-hal yang tidak sah bagi kita sebagai warga negara Romawi untuk menerima ataupun melakukannya.” ");
INSERT INTO indags_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gerombolan orang bergabung untuk menyerang mereka. Pejabat itu merobek baju Paulus dan Silas dan memerintahkan agar mereka dipukuli dengan tongkat. ");
INSERT INTO indags_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Setelah memukuli mereka dengan keras, mereka melemparkan Paulus dan Silas ke dalam penjara, dan memerintahkan agar penjaga penjara menjada mereka tetap terkunci. ");
INSERT INTO indags_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Penjaga penjara itu mengikuti perintahnya. Dia menempatkan Paulus dan Silas di penjara bagian dalam dan memasung kaki mereka pada balok kayu. ");
INSERT INTO indags_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sekitar tengah malam hari, Paulus dan Silas sedang berdoa dan bernyanyi memuji Allah, dan para penghuni penjara lainnya mendengarkan mereka. ");
INSERT INTO indags_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tiba-tiba terjadi gemba bumi yang dahsyat yang mengguncang pondasi bangunan penjara. Dengan segera semua pintu terbuka dan rantai yang membelenggu setiap orang di penjara terlepas. ");
INSERT INTO indags_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Penjaga penjara terbangun dan melihat bahwa pintu-pintu tempat tahanan terbuka. Dia menarik pedangnya keluar dari sarungnya dan hendak membunuh dirinya sendiri, berpikir bahwa semua tahanan tentu sudah melarikan diri. ");
INSERT INTO indags_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tetapi Paulus berteriak, “Jangan menyakiti dirimu sendiri — kami semua masih ada disini!” ");
INSERT INTO indags_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Petugas penjara itu minta agar dibawakan penerangan kepadanya dan bergegas masuk. Gemetar ketakutan dia sujud kepada Paulus dan Silas. ");
INSERT INTO indags_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Dia membawa mereka keluar dan bertanya, “Tuan-tuan, apa yang harus aku lakukan agar aku bisa selamat?” ");
INSERT INTO indags_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Percayalah kepada Tuhan Yesus, dan kamu akan diselamatkan — kamu dan juga semua orang yang tinggal di rumahmu,” jawab Paulus dan Silas. ");
INSERT INTO indags_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lalu mereka mulai membagikan firman Tuhan kepadanya dan kepada semua orang yang tinggal di dalam rumahnya. ");
INSERT INTO indags_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sekalipun hari sudah sangat larut, sang penjaga penjara membalut luka mereka, dan minta agar dia dan semua orang yang tinggal dalam rumahnya juga ikut dibaptis. ");
INSERT INTO indags_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sang penjaga penjara membawa mereka pulang dan menyiapkan makanan untuk mereka. Dia dan seluruh keluarganya bersukacita sebab mereka percaya pada Allah. ");
INSERT INTO indags_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagi-pagi keesokan harinya, para pejabat mengirim petugas kepada penjaga penjara, dan berkata, “Lepaskanlah orang-orang itu.” ");
INSERT INTO indags_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Penjaga penjara itu berkata kepada Paulus, “Para pejabat sudah mengirim pesan untuk melepaskan kalian. Jadi kalian boleh keluar dan pergi dengan selamat.” ");
INSERT INTO indags_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Tetapi kata Paulus kepada mereka, “Para pejabat itu sudah menghukum kami di depan umum tanpa melalui sebuah persidangan — dan kami adalah warga negara Roma! Lalu mereka memasukkan kami ke dalam penjara. Dan sekarang mereka ingin melepaskan kami dengan diam-diam? Tidak, harus mereka sendirilah yang datang dan melepaskan kami!” ");
INSERT INTO indags_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Para petugas itu kembali dan melaporkan hal ini kepada para pejabat. Ketika mereka mendengar bahwa Paulus dan Silas adalah warga negara Roma, mereka menjadi sangat kuatir, ");
INSERT INTO indags_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","lalu pergi dan minta maaf kepada kedua orang itu. Mereka mengawal Paulus dan Silas keluar dan memohon agar keduanya meninggalkan kota. ");
INSERT INTO indags_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jadi Paulus dan Silas meninggalkan penjara dan pergi ke rumah Lidia. Di sana mereka bertemu dengan anggota jemaat, memberi semangat kepada mereka, dan pergi melanjutkan perjalanan mereka. ");
INSERT INTO indags_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Sesudah Paulus dan Silas melewati daerah Amfipolis dan Apolonia, mereka tiba di kota Tesalonika. Di kota itu ada rumah ibadah orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Seperti biasa, Paulus pergi ke rumah ibadah itu dan selama tiga kali hari Sabat, dia berdebat dengan mereka tentang Kitab Suci. ");
INSERT INTO indags_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Paulus menjelaskan isi Kitab Suci, membuktikan bahwa Mesias harus mati dan bangkit kembali dari kematian. “Yesus yang aku ceritakan kepada kalian — Dialah sang Mesias,” katanya kepada mereka. ");
INSERT INTO indags_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Beberapa dari mereka menjadi percaya dan bergabung dengan Paulus dan Silas, bersama dengan orang-orang Yunani yang sudah menjadi penyembah Allah dan juga beberapa perempuan terpandang yang ada di kota itu. ");
INSERT INTO indags_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tetapi orang-orang Yahudi menjadi iri hati dan bersama beberapa penghasut yang mereka kumpulkan dari pasar, mereka membentuk gerombolan. Gerombolan ini menimbulkan kerusuhan di kota, dan menyerang rumah Yason. Mereka mencoba menemukan Paulus dan Silas agar mereka bisa membawa keduanya ke hadapan umum. ");
INSERT INTO indags_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ketika mereka tidak bisa menemukan keduanya, mereka menyeret Yason dan beberapa orang percaya ke hadapan para pemimpin kota, sambil berteriak, “Orang-orang ini terkenal karena suka menimbulkan masalah, mereka orang-orang yang menyebabkan kekacauan di seluruh dunia. Sekarang mereka datang ke kota ini, ");
INSERT INTO indags_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","dan Yason menyambut mereka di rumahnya. Mereka semua menentang keputusan-keputusan Kaisar, merencanakan pengkhianatan dengan mengatakan bahwa ada raja lain yang bernama Yesus.” ");
INSERT INTO indags_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Orang banyak dan para pemimpin kota menjadi marah ketika mereka mendengar perkataan ini. ");
INSERT INTO indags_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Maka mereka membuat Yason dan yang lainnya membayar denda sebelum melepaskan mereka. ");
INSERT INTO indags_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Malam itu juga, jemaat di Tesalonika mengirim Paulus dan Silas ke kota Berea. Setibanya mereka di sana, mereka pergi ke rumah ibadah orang Yahudi. ");
INSERT INTO indags_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Orang-orang Yahudi di Berea lebih baik perilakunya di bandingkan mereka yang ada di Tesalonika. Mereka dengan cepat menerima Firman, dan setiap hari mereka menyelidiki Kitab Suci untuk memastikan bahwa perkataan yang mereka dengar adalah benar. ");
INSERT INTO indags_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Sebagai hasilnya, banyak dari antara mereka bergabung menjadi orang yang percaya kepada Yesus, di antaranya adalah para laki-laki dan perempuan Yunani yang terpandang. ");
INSERT INTO indags_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tetapi ketika orang-orang Yahudi di Tesalonika mendengar bahwa Paulus juga menyebarkan firman Allah di kota Berea, mereka pergi ke sana dan menimbulkan kekacauan yang sama, menghasut orang banyak. ");
INSERT INTO indags_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dengan segera jemaat membawa Paulus ke tepi pantai, sementara Silas dan Timotius masih tinggal di kota Berea. ");
INSERT INTO indags_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mereka yang menemani Paulus membawanya sampai ke kota Atena, dan kembali dengan membawa pesan dari Paulus kepada Silas dan Timotius agar mereka segera bergabung dengan Paulus secepat mungkin. ");
INSERT INTO indags_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sementara Paulus menunggu keduanya di kota Atena, dia merasa terganggu melihat semua patung yang ada di kota itu. ");
INSERT INTO indags_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Paulus berdebat dengan orang-orang Yahudi di rumah ibadah dan juga dengan orang-orang bukan Yahudi yang menyembah Allah. Dia juga berdebat di pasar-pasar dengan orang-orang yang dia temui dari hari ke hari. ");
INSERT INTO indags_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Beberapa ahli filsafat dari golongan Epikuros dan Stoa mulai berdebat dengan Paulus. “Apa yang pengoceh ini bicarakan?” tanya mereka. Yang lain menyimpulkan, “Dia tampaknya mengajar tentang dewa-dewa asing,” sebab Paulus berbicara tentang Yesus dan kebangkitan-Nya. ");
INSERT INTO indags_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jadi mereka membawa Paulus ke suatu tempat yang dinamakan Areopagus, yaitu tempat berdiskusi bagi para ahli filsafat, dan bertanya kepadanya, “Tolong beritahu kami tentang ajaran baru yang kamu sampaikan. ");
INSERT INTO indags_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kami mendengarkan dari kamu hal-hal yang terdengar aneh bagi kami, jadi kami ingin tahu apa artinya.” ");
INSERT INTO indags_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Semua orang Atena, termasuk orang-orang asing yang tinggal di sana, menghabiskan waktu mereka dengan menjelaskan atau mendengarkan segala sesuatu yang baru.) ");
INSERT INTO indags_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulus berdiri tepat di tengah Areopagus dan berkata, “Hai orang-orang Atena, saya menyadari bahwa kalian sangat mengaitkan segala sesuatunya dengan agama. ");
INSERT INTO indags_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ketika aku berjalan, melihat kepada patung-patung kalian, aku menemukan sebuah mezbah yang memiliki keterangan, ‘Kepada Allah yang tidak dikenal.’ Allah yang tidak kalian kenal yang kalian sembah inilah yang aku perkenalkan kepada kalian. ");
INSERT INTO indags_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Allah yang menciptakan dunia ini dengan segala sesuatu yang ada di dalamnya, Tuhan atas langit dan bumi, yang tidak hidup di dalam bangunan-bangunan rumah ibadah yang kita dirikan. ");
INSERT INTO indags_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dia tidak butuh untuk kita layani seakan-akan Dia membutuhkan sesuatu, sebab Dia adalah sumber dari seluruh kehidupan bagi setiap mahkluk hidup. ");
INSERT INTO indags_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hanya dari satu laki-laki, Dia membuat seluruh manusia yang hidup di bumi ini, dan sudah membuat keputusan kapan dan di mana mereka akan hidup. ");
INSERT INTO indags_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tujuan Allah adalah agar mereka mencari Dia, berharap agar mereka akan menggapai dan menemukan Dia — sekalipun sebenarnya Dia tidaklah terlalu jauh dari kita masing-masing. ");
INSERT INTO indags_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Dalam Dialah kita hidup, bergerak dan memiliki keberadaan. Sama seperti ungkapan dari salah seorang pujangga kalian sendiri, ‘Kita adalah keluarga-Nya.’ ");
INSERT INTO indags_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Karena kita adalah keluarga-Nya, tidak seharusnya kita berpikir bahwa Allah serupa dengan emas, atau perak atau batu, yang dibentuk oleh karya seni manusia dan kepandaian kita. ");
INSERT INTO indags_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dengan tidak memperhitungkan ketidaktahuan manusia di masa lampau, Dia sekarang memerintahkan agar setiap orang di segala tempat untuk bertobat. ");
INSERT INTO indags_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Sebab sudah Dia tentukan waktunya ketika Dia akan menghakimi seluruh dunia dengan menunjuk satu orang yang sudah Dia tetapkan, dan Allah membuktikan kepada semua orang bahwa orang ini adalah pilihan-Nya dengan membangkitkan Dia dari antara orang mati.” ");
INSERT INTO indags_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Beberapa dari antara mereka tertawa ketika mereka mendengar tentang kebangkitan dari antara orang mati, sementara yang lain berkata, “Silahkan datang kembali agar kami bisa mendengarkan tentang hal ini lebih lagi di kemudian hari.” ");
INSERT INTO indags_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Maka Paulus meninggalkan mereka. ");
INSERT INTO indags_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Beberapa orang percaya kepada Yesus dan bergabung dengan dia, termasuk Dionisius, salah satu anggota Areopagus, demikian juga seorang perempuan bernama Damaris dan juga beberapa orang lainnya. ");
INSERT INTO indags_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paulus lalu meninggalkan kota Atena dan pergi ke kota Korintus. ");
INSERT INTO indags_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Di sana Paulus bertemu dengan seorang Yahudi yang bernama Akwila. Akwila berasal dari Pontus, dan baru saja tiba dari Italia dengan istrinya Prisilla, sebab Klaudius yang kala itu menjabat sebagai Kaisar Roma sudah memerintahkan agar orang-orang Yahudi disingkirkan dari Roma. Paulus pergi menemui mereka, ");
INSERT INTO indags_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","dan karena mereka memiliki pekerjaan yang sama sebagai pembuat tenda, maka Paulus tinggal bersama dengan mereka. ");
INSERT INTO indags_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulus pergi ke rumah-rumah ibadah orang Yahudi setiap hari sabat. Dan di sana dia mencoba meyakinkan baik orang Yahudi maupun orang Yunani. ");
INSERT INTO indags_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ketika Silas dan Timotius tiba dari Makedonia, Paulus merasa bahwa dia harus berkata dengan tegas dalam ucapannya, dan memberitahukan kepada orang-orang Yahudi bahwa Yesus adalah Mesias. ");
INSERT INTO indags_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ketika mereka menentang dan mengutuk dia, maka dia mengibaskan debu dari pakaiannya dan berkata, “Kesalahan kalian tanggung sendiri! Aku tidak bersalah, dan mulai sekarang aku akan mengabarkan berita baik ini kepada orang-orang bukan Yahudi.” ");
INSERT INTO indags_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dia pergi dan tinggal dengan Titius Yustus, yang menyembah Allah dan rumahnya bersebelahan dengan rumah ibadah. ");
INSERT INTO indags_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, sang pemimpin rumah ibadah, baik dia maupun semua yang tinggal di dalam rumahnya percaya kepada Tuhan. Banyak orang Korintus yang mendengar pesan ini menjadi percaya kepada Yesus dan dibaptis. ");
INSERT INTO indags_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tuhan memberi sebuah penglihatan kepada Paulus di waktu malam: “Jangan takut. Teruslah mengajar, janganlah berdiam diri — ");
INSERT INTO indags_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","sebab Aku bersama dengan kamu, dan tidak seorangpun akan menyerangmu, sebab banyak orang di kota ini akan menjadi umat-Ku.” ");
INSERT INTO indags_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulus tinggal di kota Korintus selama 18 bulan, mengajarkan kepada orang-orang tentang Firman Allah. ");
INSERT INTO indags_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Namun demikian, ketika Galio menjadi Gubernur di Akaya, orang-orang Yahudi bersekutu untuk menyerang Paulus dan membawanya ke hadapan pengadilan. ");
INSERT INTO indags_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Orang ini menghasut banyak orang agar menyembah Allah dengan cara yang tidak sesuai dengan Hukum kami,” kata mereka. ");
INSERT INTO indags_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Tetapi ketika Paulus hendak membela diri, Galio berkata kepada orang Yahudi, “Jika kalian orang-orang Yahudi melaporkan dia karena dia berbuat kejahatan, ada alasan bagiku untuk mendengarkan perkara kalian. ");
INSERT INTO indags_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Tetapi jika kalian hanya berdebat tentang kata-kata dan nama-nama serta hukum kalian sendiri, maka bereskanlah sesuai hukum kalian. Aku tidak akan menjadi hakim untuk perkara seperti itu.” ");
INSERT INTO indags_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Lalu Galio minta agar mereka dikeluarkan dari ruang sidang. ");
INSERT INTO indags_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Maka kerumunan orang itu menangkap Sostenes — pemimpin rumah ibadah, dan memukuli dia tepat di luar gedung pengadilan, tetapi Galio tidak peduli dengan semua itu. ");
INSERT INTO indags_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus tinggal di sana sebentar saja. Lalu meninggalkan jemaat dan berlayar menuju Siria, membawa serta Prisilla dan Akwila bersama dengannya. Di Kengkrea, Paulus mencukur habis rambutnya sampai botak, sebab dia sudah bersumpah. ");
INSERT INTO indags_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mereka tiba di kota Efesus, di mana Paulus meninggalkan Prisilla dan Akwila di kota itu. Dia pergi ke rumah ibadah orang Yahudi untuk berbicara dengan mereka. ");
INSERT INTO indags_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mereka minta agar Paulus bisa tinggal lebih lama bersama mereka, tetapi dia menolaknya. ");
INSERT INTO indags_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Dia mengucapkan selamat tinggal, dan berlayar dari kota Efesus, berkata kepada mereka, “Aku akan kembali dan menemui kalian jika Allah memang menghendaki.” ");
INSERT INTO indags_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sesudah berlabuh di Kaesarea, dia pergi untuk menemui anggota jemaat, dan kemudian melanjutkan perjalanan menuju kota Antiokia. ");
INSERT INTO indags_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Dia menghabiskan waktunya beberapa saat lamanya di kota itu, lalu pergi dari kota ke kota di seluruh wilayah Galatia dan Frigia, memberi semangat kepada semua orang yang percaya. ");
INSERT INTO indags_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sementara itu seorang Yahudi yang bernama Apolos, yang berasal dari kota Aleksandria, tiba di kota Efesus. Dia memiliki kemampuan berbicara dengan sangat baik dan dia juga sudah memahami Kitab Suci dengan baik. ");
INSERT INTO indags_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Dia sudah pernah diajari tentang jalan Tuhan, dan memiliki semangat yang menyala-nyala dengan kerohanian. Cara Apolos mengajar dan berbicara tentang Yesus begitu akurat, tetapi dia hanya memahami tentang baptisan Yohanes. ");
INSERT INTO indags_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos mulai berbicara dengan berani di rumah-rumah ibadah. Jadi ketika Prisilla dan Akwila mendengarkan dia, mereka mengundang dia untuk bergabung dengan mereka, serta menjelaskan kepadanya jalan Allah dengan lebih lengkap lagi. ");
INSERT INTO indags_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ketika dia memutuskan untuk pergi ke Akaya, para saudara seiman memberikan semangat kepadanya, dan menulis kepada murid-murid di sana agar mereka mau menyambut Apolos. Ketika Apolos tiba di Akaya, ternyata dia sangat menolong mereka yang oleh karena kebaikan Allah percaya kepada Yesus, ");
INSERT INTO indags_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","sebab dia bisa dengan luar biasa menyanggah orang-orang Yahudi dalam perdebatan umum, menunjukkan dari Kitab Suci bahwa Yesus adalah Mesias. ");
INSERT INTO indags_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Sementara Apolos sedang ada di kota Korintus, Paulus mengambil jalan darat dan tiba di kota Efesus di mana dia bertemu dengan beberapa orang yang percaya kepada Yesus. ");
INSERT INTO indags_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“Apakah kalian menerima Roh Kudus ketika kalian percaya?” tanya Paulus kepada mereka. “Tidak, kami belum pernah mendengar apapun tentang Roh Kudus,” jawab mereka kepadanya. ");
INSERT INTO indags_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Jadi baptisan siapa yang kalian terima?” tanya Paulus. “Baptisan Yohanes,” jawab mereka. ");
INSERT INTO indags_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","“Baptisan Yohanes adalah baptisan pertobatan,” kata Paulus. “Dia memberitahu mereka bahwa mereka harus percaya kepada Dia yang datang sesudah Yohanes — yaitu, mereka seharusnya percaya kepada Yesus.” ");
INSERT INTO indags_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ketika mereka mendengar hal ini, mereka dibaptis dalam nama Tuhan Yesus. ");
INSERT INTO indags_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Sesudah Paulus meletakkan tangannya ke atas kepala mereka, Roh Kudus datang ke atas mereka dan mereka semua berbicara dengan berbagai bahasa — sesuai dengan bahasa yang Roh berikan kepada mereka. Dan mereka juga bernubuat. ");
INSERT INTO indags_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jumlah mereka kurang lebih dua belas orang. ");
INSERT INTO indags_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulus pergi ke rumah-rumah ibadah dan selama tiga bulan selanjutnya dia berbicara dengan berani kepada mereka yang datang ke tempat itu, berdiskusi dengan mereka dan mencoba meyakinkan mereka tentang kerajaan Allah. ");
INSERT INTO indags_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tetapi ada di antara mereka yang berdegil, dan enggan menerima. Mereka menghina Jalan keselamatan itu di hadapan orang banyak. Jadi Paulus meninggalkan rumah ibadah itu, dengan membawa mereka yang percaya kepadanya. Lalu dia memakai balai pertemuan di Tiranus sebagai tempat pertemuan. ");
INSERT INTO indags_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hal ini terus berlanjut selama dua tahun, dengan akibat setiap orang yang tinggal di provinsi Asia, baik orang-orang Yahudi maupun orang-orang Yunani, mendengarkan Firman Tuhan. ");
INSERT INTO indags_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Allah melakukan keajaiban-keajaiban yang tidak biasa melalui Paulus, ");
INSERT INTO indags_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","begitu luar biasa sehingga mereka mengambil sapu tangan atau kain yang pernah dijamah oleh Paulus untuk menyembuhkan orang sakit dan untuk mengusir setan. ");
INSERT INTO indags_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Beberapa orang Yahudi yang mempraktekkan ilmu sihir memutuskan untuk menggunakan nama Yesus ketika mereka mengusir roh jahat. Kata mereka, “Aku perintahkan kamu untuk pergi di dalam nama Yesus yang diajarkan oleh Paulus itu.” ");
INSERT INTO indags_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mereka yang melakukan hal ini adalah ketujuh anak laki-laki Skewa, seorang keturunan Yahudi yang menyatakan dirinya sebagai imam kepala. ");
INSERT INTO indags_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tetapi suatu hari roh jahat menjawab mereka, “Aku kenal Yesus, dan aku kenal Paulus, tetapi siapa kalian?” ");
INSERT INTO indags_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Orang yang dirasuki roh jahat itu melompat ke atas mereka dan mengalahkan mereka semua. Dia memukuli mereka dengan sangat kejam sehingga mereka harus keluar dari rumah itu, dalam keadaan telanjang dan luka parah. ");
INSERT INTO indags_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Orang-orang yang hidup di Efesus, baik orang Yahudi maupun orang Yunani mendengar tentang hal ini. Mereka semua kagum dengan peristiwa yang terjadi, dan nama Tuhan Yesus semakin dihormati. ");
INSERT INTO indags_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Banyak orang yang menjadi percaya kepada Tuhan serta mengakui dosa-dosa mereka, secara terbuka mengakui perbuatan-perbuatan buruk mereka. ");
INSERT INTO indags_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Sebagian dari mereka yang dahulu melakukan praktek sihir mengumpulkan buku-buku sihir mereka dan membawanya untuk dibakar di depan umum. Mereka menghitung nilai semua buku yang dibakar itu, dan jumlahnya ternyata 50.000 keping perak. ");
INSERT INTO indags_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Dengan cara ini Firman Tuhan semakin kuat dan semakin tersebar luas. ");
INSERT INTO indags_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Beberapa saat sesudah semua peristiwa ini, Paulus memutuskan untuk berangkat ke Yerusalem, melewati Makedonia dan Akaya. “Setelah saya ke sana, saya harus pergi ke Roma,” katanya. ");
INSERT INTO indags_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dia mengirim dua orang yang selalu membantu dia dalam pelayanannya, yaitu Timotius dan Eratus, ke Makedonia, sementara dia tinggal sesaat lamanya di provinsi Asia. ");
INSERT INTO indags_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sekitar waktu inilah mulai timbul masalah yang besar berkaitan dengan Jalan. ");
INSERT INTO indags_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Seorang pria bernama Demetrius, seorang tukang perak, sedang membuat replika perak kecil dari kuil dewi Artemis. Usaha ini memberi keuntungan besar bagi pengusahanya. ");
INSERT INTO indags_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius memanggil teman-teman yang memiliki usaha yang sama untuk berkumpul dan berkata, “Rekan-rekan sekalian, kalian tahu bahwa melalui bisnis inilah kita mendapatkan penghasilan kita. ");
INSERT INTO indags_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Seperti yang sudah kalian lihat dan dengar — bukan hanya di kota Efesus ini, tetapi hampir di seluruh wilayah Asia — orang yang bernama Paulus ini sudah menyakinkan dan menghasut banyak orang, mengatakan kepada mereka bahwa tidak ada dewa yang bisa dibuat oleh tangan manusia. ");
INSERT INTO indags_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jadi bukan hanya usaha kita akan berada dalam bahaya karena orang-orang tidak akan lagi menghormatinya, tetapi kuil dari dewi besar Artemis juga akan dianggap tidak berharga. Dewi Artemis sendiri juga akan disingkirkan dari posisinya sebagai dewi yang dipuja oleh setiap orang baik di Asia maupun di seluruh dunia.” ");
INSERT INTO indags_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ketika para pengusaha itu mendengar ucapan Demetrius, mereka menjadi marah dan berteriak, “Besarlah Artemis, dewi orang Efesus!” ");
INSERT INTO indags_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Seluruh kota menjadi benar-benar kacau. Orang-orang bergegas menuju ke stadion, menyeret Gayus dan Aristarkus, teman seperjalanan Paulus yang berasal dari Makedonia. ");
INSERT INTO indags_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus berpikir untuk menemui orang banyak itu, tetapi yang lain tidak mengijinkan dia melakukannya. ");
INSERT INTO indags_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Beberapa pejabat dari provinsi Asia, yang adalah kawan-kawan Paulus, juga mengirim pesan memohon agar dia tidak masuk ke dalam stadion. ");
INSERT INTO indags_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Beberapa orang yang berkumpul berteriak tentang satu hal, yang lainnya berteriak tentang hal lain, sebab orang-orang yang sudah berkumpul itu sedang kebingungan — banyak dari mereka tidak paham mengapa mereka berkumpul di sana. ");
INSERT INTO indags_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Orang-orang Yahudi yang ada dalam kerumunan itu mendorong agar Aleksander mau maju ke depan. Aleksander memberi tanda dengan tangannya agar mereka diam, dia ingin memberi penjelasan kepada orang banyak itu. ");
INSERT INTO indags_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tetapi ketika orang banyak menyadari bahwa Aleksander adalah seorang Yahudi, mereka semua meneriakkan lantunan perkataan, “Besarlah Artemis, dewi orang Efesus!” selama kurang lebih dua jam. ");
INSERT INTO indags_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Sesudah sekretaris kota berhasil membuat gerombolan itu mereda, dia berkata kepada mereka, “Hai orang-orang Efesus, siapa yang tidak tahu bahwa kota orang Efesus adalah penjaga dari dewi besar Artemis dan tentang patungnya yang jatuh dari langit? ");
INSERT INTO indags_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Karena kenyataan-kenyataan ini tidak bisa disangkal, kalian seharusnya tetap tenang — jangan melakukan tindakan yang terburu-buru. ");
INSERT INTO indags_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kalian membawa orang-orang ini ke mari, tetapi mereka tidak merampok kuil-kuil ataupun menghujat dewi kita. ");
INSERT INTO indags_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jadi jika Demetrius dan rekan-rekannya memiliki keluhan terhadap seseorang, baiklah mereka membawa pengaduan mereka ke pengadilan. ");
INSERT INTO indags_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Jika ada masalah-masalah lain, bisa diselesaikan dalam sidang rakyat yang sah. ");
INSERT INTO indags_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bahkan kita sendiri sedang dalam bahaya menjadi terdakwa sebagai penanggung jawab kerusuhan yang timbul hari ini, sebab tidak ada alasan untuk menimbulkan keributan, dan kita tidak bisa memberi penjelasan tentang ini.” ");
INSERT INTO indags_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sesudah sang sekretaris selesai berbicara, dia membubarkan kerumunan itu. ");
INSERT INTO indags_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ketika kerusuhan itu sudah mereda, Paulus memanggil seluruh jemaat berkumpul dan memberi semangat kepada mereka. Lalu dia mengucapkan selamat tinggal, dan pergi ke Makedonia. ");
INSERT INTO indags_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Paulus mengunjungi jemaat-jemaat yang ada di daerah itu, membagikan banyak kata-kata penguatan kepada jemaat yang di sana, lalu melanjutkan perjalanan ke Yunani. ");
INSERT INTO indags_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sesudah menghabiskan 3 bulan lamanya di sana dan ketika dia akan berlayar ke Siria, Paulus mendapat tahu bahwa orang-orang Yahudi sedang merencanakan untuk membunuh dia. Jadi dia memutuskan untuk kembali melalui Makedonia. ");
INSERT INTO indags_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Inilah mereka yang ikut bersama dengan Paulus: Sopater dari Berea, anak laki-laki Firus, Aristarkus dan sekundus dari kota Tesalonika, Gayus dari Derbe, Timotius, Tikikus dan Trofimus dari provinsi Asia. ");
INSERT INTO indags_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mereka berangkat lebih dulu dan menunggu kami di Troas. ");
INSERT INTO indags_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sesudah hari Raya Roti tidak Beragi, kami berlayar dari Filipi, dan bertemu dengan mereka lima hari kemudian di Troas, di mana kami menghabiskan waktu di kota itu selama satu minggu. ");
INSERT INTO indags_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Paulus sedang berbicara pada hari pertama minggu itu ketika kami berkumpul untuk memecahkan roti. Dia berencana untuk berangkat di pagi hari, sehingga dia berbicara hingga larut malam hari itu. ");
INSERT INTO indags_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","(Ruangan atas ketika kami mengadakan pertemuan itu diterangi oleh banyak lilin.) ");
INSERT INTO indags_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Seorang pemuda bernama Eutikus sedang duduk di ambang jendlea, dan mulai merasa sangat mengantuk. Ketika Paulus masih berbicara, Eutikus tertidur dan terjatuh dari jendela yang ada di tingkat tiga. Ketika mereka mengangkat dia, mereka temukan kalau anak itu sudah mati. ");
INSERT INTO indags_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus turun ke bawah, membujurkan dirinya di atas tubuh pemuda itu, dan memeluknya. “Jangan kuatir, dia masih hidup,” katanya. ");
INSERT INTO indags_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paul kembali ke atas, memecahkan roti, dan makan bersama dengan mereka. Dia terus berbicara bersama mereka sampai subuh tiba, dan kemudian dia berangkat. ");
INSERT INTO indags_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mereka membawa kembali pemuda ini ke rumahnya dalam keadaan hidup dan sehat, dan sangat bersyukur atas ini. ");
INSERT INTO indags_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kami naik ke atas kapal dan berlayar menuju Asos. Di sana kami bermaksud menjemput Paulus, sebab demikianlah yang sudah direncanakan sebelumnya ketika Paulus memutuskan untuk lewat jalan darat. ");
INSERT INTO indags_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paulus bertemu dengan kami di Asos. Kami menjemputnya dan melanjutkan perjalanan menuju Mitilene. ");
INSERT INTO indags_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hari berikutnya kami melanjutkan perjalanan ke Kios, dan berhenti sebentar di Samos, melanjutkan perjalanan sampai keesokan harinya tiba di Miletus. ");
INSERT INTO indags_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus sudah berencana untuk terus berlayar melewati Efesus, agar dia tidak perlu menghabiskan waktu di provinsi Asia. Dia sangat ingin pergi ke Yerusalem pada waktunya untuk Hari Pentakosta. ");
INSERT INTO indags_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dari kota Miletus Paulus mengirim pesan kepada para pemimpin jemaat di kota Efesus. ");
INSERT INTO indags_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ketika mereka tiba, berkatalah Paulus kepada mereka, “Kalian tahu cara hidupku sewaktu aku masih bersama kalian mulai dari hari pertama aku tiba di provinsi Asia. ");
INSERT INTO indags_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Aku melayani Tuhan dengan rendah hati dan sering menangis. Aku mengalami banyak kesusahan dan tekanan yang disebabkan oleh rencana-rencana yang disusun oleh orang-orang Yahudi terhadap aku. ");
INSERT INTO indags_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Namun, tidak pernah aku menahan diri untuk berbagi segala sesuatu dengan kalian yang akan menjadi keuntungan bagi kalian, dan aku mengajar kalian di hadapan umum, berkunjung dari rumah ke rumah. ");
INSERT INTO indags_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Aku memberi kesaksian baik kepada orang-orang Yahudi maupun orang-orang Yunani bahwa penting untuk bertobat dan kembali kepada Allah, dan untuk percaya kepada Tuhan kita Yesus Kristus. ");
INSERT INTO indags_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Sekarang, Roh Kudus menyuruh aku pergi ke Yerusalem, dan aku tidak tahu apa yang akan terjadi kepadaku di sana. ");
INSERT INTO indags_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aku hanya tahu satu hal, yaitu di setiap kota yang aku kunjungi Roh Kudus selalu memperingatkan aku bahwa penjara dan penderitaan akan menungguku. ");
INSERT INTO indags_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tetapi untukku, hidupku tidaklah lebih berharga dari apapun juga. Aku hanya ingin menyelesaikan misi dan pelayanan yang Tuhan Yesus berikan kepadaku, memberi kesaksian tentang kabar baik dari kasih karunia Allah. ");
INSERT INTO indags_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Sekarang aku yakin bahwa kita tidak akan saling berjumpa lagi, kalian di antara mereka yang menerima berita tentang Kerajaan Allah yang aku beritakan. ");
INSERT INTO indags_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Maka aku nyatakan kepada kalian bahwa hari ini aku tidak bertanggung jawab jika ada di antara kalian yang tersesat. ");
INSERT INTO indags_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Aku tidak ragu-ragu mengatakan kepada kalian segala hal yang Allah ingin kalian ketahui. ");
INSERT INTO indags_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jagalah diri kalian dan jagalah seluruh jemaat, yang sudah diberikan oleh Roh Kudus untuk kalian bantu. Berilah gereja Tuhan makanan rohani yang sudah Dia beli dengan darah-Nya sendiri. ");
INSERT INTO indags_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aku tahu bahwa sesudah aku pergi akan ada orang-orang yang seperti serigala-serigala yang jahat datang ke antara kalian, dan akan mencoba membinasakan jemaat. ");
INSERT INTO indags_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bahkan dari antara kalian sendiri akan bangkit juga orang-orang yang menyelewengkan kebenaran dan sesuatu yang baik agar mereka bisa mempengaruhi jemaat agar bisa mendapatkan pengikut. ");
INSERT INTO indags_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jadi berjaga-jagalah! Janganlah lupakan bahwa selama tiga tahun aku mengajar kalian semua baik pada siang hari maupun pada malam hari, dan juga sering menangis oleh karena kalian. ");
INSERT INTO indags_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Sekarang aku menyerahkan kalian dalam pemeliharaan Allah dan kepada pesan-Nya tentang kasih karunia, yang dapat membangun manusia rohani kalian dan menyediakan bagi kalian warisan yang menjadi milik mereka yang tetap melakukan perbuatan yang benar dengan Dia. ");
INSERT INTO indags_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tidak pernah ada keinginan dariku untuk mendapatkan uang baik uang perak maupun uang emas, demikian juga dengan pakaian. ");
INSERT INTO indags_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kalian tahu bahwa aku bahkan bekerja untuk memenuhi kebutuhan hidupku, dan juga untuk kebutuhan mereka yang ikut bersamaku. ");
INSERT INTO indags_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aku sudah menjadi contoh bagi kalian dalam segala hal: bekerja untuk menolong mereka yang lemah, sebab aku mengingat firman Tuhan Yesus: ‘Lebih baik memberi dari pada menerima.’” ");
INSERT INTO indags_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Sesudah selesai berbicara, Paulus berlutut dan berdoa bersama mereka. ");
INSERT INTO indags_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dan mereka semua menangis ketika mereka memeluk dan mengucapkan selamat jalan. ");
INSERT INTO indags_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mereka merasa kecewa sebab dia berkata kalau dia tidak akan pernah bertemu dengan mereka lagi... Lalu mereka berjalan ke pelabuhan untuk mengantar dia. ");
INSERT INTO indags_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sesudah Paulus mengucapkan selamat berpisah dengan mereka, kami berlayar langsung ke pulau Kos, dan keesokan harinya menuju ke pulau Rodos. Dari sana kami melanjutkan perjalanan menuju ke kota Patara ");
INSERT INTO indags_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","dan dari sana kami menemukan kapal yang akan pergi ke kota Fenisia. Kami naik ke kapal itu dan berangkat. ");
INSERT INTO indags_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kami melewati pulau Siprus pada sisi sebelah kiri kapal, dan melanjutkan pelayaran sampai ke wilayah Siria, di mana kami berlabuh di kota Tirus, tempat muatan kapal harus diturunkan. ");
INSERT INTO indags_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kami bertemu dengan jemaat di kota Tirus dan tinggal di sana selama seminggu. Jemaat di kota tersebut melalui tuntunan Roh Kudus menasihatkan Paulus untuk tidak pergi ke Yerusalem. ");
INSERT INTO indags_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ketika sudah tiba waktunya, kami berangkat kembali dengan kapal untuk melanjutkan perjalanan kami. Seluruh jemaat, beserta dengan istri dan anak-anak mereka, mengantar kami ketika kami meninggalkan kota. Kami berlutut di tepi pantai dan berdoa, serta mengucapkan selamat tinggal. ");
INSERT INTO indags_vpl VALUES ("A