﻿USE sofia;
DROP TABLE IF EXISTS sofia.ind_vpl;
CREATE TABLE ind_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ind_vpl WRITE;
INSERT INTO ind_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pada permulaan segala sesuatu, Allah menciptakan tingkat-tingkat surga dan langit serta bumi. ");
INSERT INTO ind_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Waktu itu, bumi belum berbentuk dan kosong. Bumi gelap gulita dan digenangi air yang sangat dalam. Roh Allah hadir di atas permukaan air itu. ");
INSERT INTO ind_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Berkatalah Allah, “Jadilah terang!” Maka terang itu jadi. ");
INSERT INTO ind_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah melihat bahwa terang itu baik, maka Dia memisahkan terang dari kegelapan. ");
INSERT INTO ind_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allah menyebut terang itu ‘siang’ dan kegelapan itu ‘malam’. Hari pertama berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Pada pagi berikutnya, berkatalah Allah, “Hendaklah ada ruang kosong untuk memisahkan air yang di bumi dengan air yang di atas bumi.” ");
INSERT INTO ind_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Maka jadilah demikian. ");
INSERT INTO ind_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allah menyebut ruang kosong itu ‘langit’. Hari kedua berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Pada pagi berikutnya, berkatalah Allah, “Hendaklah air yang ada di bawah langit berkumpul di satu tempat, supaya tanah kering bisa terlihat.” Maka jadilah demikian. ");
INSERT INTO ind_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allah menyebut tanah kering itu ‘darat’ dan kumpulan air itu ‘laut’. Allah melihat bahwa semuanya itu baik. ");
INSERT INTO ind_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kemudian Allah berkata, “Hendaklah tanah mengeluarkan berbagai jenis tumbuhan, termasuk yang menghasilkan biji-bijian dan berbagai jenis pohon yang buahnya berbiji. Hendaklah tiap jenis biji itu nanti menghasilkan tumbuhan atau pohon yang sama sesuai jenisnya.” Maka jadilah demikian. ");
INSERT INTO ind_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tanah menumbuhkan segala jenis tumbuhan, termasuk yang menghasilkan biji-bijian dan berbagai jenis pohon yang buahnya berbiji. Dan setiap jenis biji selalu menghasilkan tumbuhan atau pohon yang sama jenisnya. Allah melihat bahwa semuanya itu baik. ");
INSERT INTO ind_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Hari ketiga berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Pada pagi berikutnya, berkatalah Allah, “Hendaklah ada berbagai benda penerang di langit supaya sinarnya terpancar ke bumi. Biarlah benda-benda itu menunjukkan perbedaan antara siang dan malam, serta menjadi tanda untuk menentukan hari, tahun, dan musim.” Maka jadilah demikian. ");
INSERT INTO ind_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allah membuat dua benda penerang yang besar. Yang lebih besar bersinar pada siang hari, dan yang lebih kecil bersinar pada malam hari. Allah juga membuat banyak sekali bintang. ");
INSERT INTO ind_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allah mengatur benda-benda itu di langit untuk menerangi bumi, ");
INSERT INTO ind_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","untuk bersinar pada siang dan malam, dan untuk memisahkan terang dari gelap. Allah melihat bahwa semuanya itu baik. ");
INSERT INTO ind_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hari keempat berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Pada pagi berikutnya, berkatalah Allah, “Hendaklah air dipenuhi dengan berbagai jenis makhluk hidup yang berenang, dan langit dipenuhi dengan berbagai jenis burung yang beterbangan di atas permukaan bumi.” ");
INSERT INTO ind_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Lalu Allah menciptakan berbagai jenis binatang laut yang besar dan segala jenis makhluk yang bergerak di dalam air. Dia juga menciptakan segala jenis binatang yang bersayap. Allah melihat bahwa semuanya itu baik. ");
INSERT INTO ind_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Lalu Allah memberkati semua makhluk hidup itu, kata-Nya, “Hendaklah segala makhluk yang hidup di laut berkembang biak dan memenuhi lautan. Dan segala binatang yang bersayap hendaklah bertambah banyak di bumi.” ");
INSERT INTO ind_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hari kelima berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Pada pagi berikutnya, berkatalah Allah, “Hendaklah ada berbagai jenis makhluk hidup di bumi, termasuk hewan ternak, binatang liar, binatang melata, dan binatang yang merayap di atas permukaan tanah.” Maka Allah menjadikan segala binatang itu, yaitu hewan ternak, binatang liar, binatang melata, dan binatang yang merayap, sesuai jenisnya masing-masing. Allah melihat bahwa semuanya itu baik. ");
INSERT INTO ind_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kemudian Allah berkata, “Marilah Kita menciptakan manusia supaya menyerupai Kita dan mencerminkan sifat-sifat Kita. Mereka akan berkuasa atas seluruh bumi, yaitu atas segala jenis ikan, burung, hewan ternak, binatang liar, bahkan serangga.” ");
INSERT INTO ind_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Maka Allah menciptakan manusia supaya menyerupai Dia. Allah menciptakan mereka, laki-laki dan perempuan. ");
INSERT INTO ind_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kemudian Allah memberkati mereka, “Beranakcuculah hingga kalian menjadi banyak. Penuhilah seluruh bumi dan berkuasalah atasnya. Hendaklah kalian berkuasa atas semua binatang di laut, di udara, dan di bumi.” ");
INSERT INTO ind_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Berkatalah Allah kepada manusia itu, “Dengarlah! Aku memberikan kepada kalian segala tumbuhan yang menghasilkan biji-bijian dan semua pohon yang buahnya berbiji. Semua itu akan menjadi makanan bagi kalian. ");
INSERT INTO ind_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tetapi untuk semua jenis binatang, burung, dan serangga, Aku memberikan segala tumbuhan hijau sebagai makanan mereka.” Maka jadilah demikian. ");
INSERT INTO ind_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allah melihat bahwa semua yang sudah diciptakan-Nya itu sungguh amat baik. Hari keenam berakhir ketika petang menjadi malam. ");
INSERT INTO ind_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Pada pagi berikutnya, selesailah penciptaan segala sesuatu yang ada di surga, di langit, dan di bumi. ");
INSERT INTO ind_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Jadi, pada hari ketujuh, karena Allah sudah selesai menciptakan segala sesuatu, Dia berhenti bekerja. ");
INSERT INTO ind_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Lalu Allah memberkati hari ketujuh dan menetapkannya sebagai hari yang kudus, sebab pada hari ketujuh itulah Dia berhenti setelah menciptakan segala sesuatu. ");
INSERT INTO ind_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Beginilah yang terjadi pada waktu TUHAN Allah baru saja menciptakan surga, langit, dan bumi: ");
INSERT INTO ind_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Pada awalnya, belum ada tumbuhan apa pun yang tumbuh karena TUHAN belum menurunkan hujan ke atas permukaan bumi. Lagipula belum ada orang yang mengerjakan tanah itu dan menanam di atasnya. ");
INSERT INTO ind_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Akan tetapi, banyak mata air meluap dari dalam tanah sehingga seluruh permukaan tanah menjadi basah. ");
INSERT INTO ind_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Lalu TUHAN Allah mengambil sedikit tanah dan membentuknya menjadi seorang manusia. Dia meniupkan nafas kehidupan ke dalam lubang hidung manusia itu, sehingga manusia itu menjadi makhluk yang hidup. ");
INSERT INTO ind_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Sebelumnya TUHAN Allah sudah membuat sebuah taman yang terletak di sebelah timur, di daerah yang bernama Eden. Di taman inilah Dia menempatkan manusia yang sudah diciptakan-Nya itu. ");
INSERT INTO ind_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kemudian TUHAN menumbuhkan segala jenis pohon yang indah dan yang menghasilkan buah yang lezat. Di tengah taman itu, Dia juga menempatkan dua pohon: Yang pertama adalah pohon yang buahnya mampu memberikan hidup selamanya. Yang kedua adalah pohon yang buahnya mampu memberi pengetahuan untuk membedakan hal yang baik dan yang buruk. ");
INSERT INTO ind_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Taman itu diairi oleh sebuah sungai besar yang hulunya bersumber dari Eden. Begitu keluar dari Eden, sungai itu bercabang menjadi empat anak sungai. ");
INSERT INTO ind_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yang pertama disebut Pison. Itulah sungai yang mengalir melalui sepanjang daerah Hawila. Di sana terdapat banyak emas. ");
INSERT INTO ind_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Emas di Hawila sangat murni, dan di situ terdapat juga wangi-wangian dari getah tumbuhan dan batu-batu permata yang berwarna-warni. ");
INSERT INTO ind_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sungai yang kedua disebut Gihon. Sungai itu mengalir sepanjang tanah Kus. ");
INSERT INTO ind_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sungai yang ketiga disebut Tigris. Sungai itu mengalir di sebelah timur Asyur. Dan sungai yang keempat disebut Efrat. ");
INSERT INTO ind_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","TUHAN Allah mengambil dan menempatkan manusia di dalam Taman Eden untuk merawat dan mengurus taman itu. ");
INSERT INTO ind_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","TUHAN berkata kepadanya, “Aku mengizinkan kamu untuk makan buah dari setiap pohon di taman ini sepuasnya. ");
INSERT INTO ind_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hanya satu yang tidak boleh dimakan, yaitu buah dari pohon yang mampu memberikan pengetahuan untuk membedakan hal yang baik dan yang buruk. Janganlah kamu makan buah itu. Karena jika kamu memakannya, kamu pasti mati pada hari itu juga!” ");
INSERT INTO ind_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kemudian TUHAN Allah berkata, “Tidak baik kalau laki-laki ini hanya sendirian. Aku akan menjadikan seorang pendamping yang cocok baginya.” ");
INSERT INTO ind_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Sebelum itu, TUHAN sudah menjadikan semua jenis binatang dan burung dari bahan tanah. Setiap jenis binatang dan burung ditunjukkan kepada laki-laki itu supaya diberi nama olehnya. Demikianlah asal mula nama semua jenis binatang. ");
INSERT INTO ind_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Laki-laki itu memberi nama kepada setiap jenis hewan, binatang liar, dan burung. Tetapi di antara semua makhluk itu, dia tidak menemukan satu pun yang cocok untuk menjadi pendampingnya. ");
INSERT INTO ind_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Maka TUHAN membuat laki-laki itu tertidur sangat nyenyak. Saat itulah TUHAN mengambil salah satu tulang rusuknya dan menutup kembali bekasnya dengan daging. ");
INSERT INTO ind_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","TUHAN Allah menjadikan seorang perempuan dari tulang rusuk yang sudah diambil-Nya, kemudian membawanya kepada laki-laki itu. ");
INSERT INTO ind_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Maka laki-laki itu berkata, “Inilah dia yang cocok bagiku! Tulangnya dari tulangku, dan dagingnya dari dagingku! Aku akan menyebut dia ‘perempuan’, karena dia diambil dariku.” ");
INSERT INTO ind_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Itulah sebabnya, ketika seorang laki-laki dan seorang perempuan membentuk keluarga baru, laki-laki akan meninggalkan orangtuanya dan bersatu dengan istrinya, sehingga mereka berdua menjadi satu. ");
INSERT INTO ind_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Laki-laki dan perempuan itu telanjang, tetapi keduanya tidak merasa malu satu sama lain. ");
INSERT INTO ind_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ular merupakan binatang yang paling licik di antara semua binatang liar yang diciptakan TUHAN Allah. Suatu hari, ular datang kepada perempuan dan bertanya, “Apa benar Allah berkata kepada kalian bahwa kalian tidak boleh makan buah-buahan dari pohon mana pun di dalam taman ini?” ");
INSERT INTO ind_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Jawab perempuan itu kepadanya, “Bukan begitu. Kami boleh makan semua buah di taman ini, ");
INSERT INTO ind_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kecuali buah dari pohon yang ada di tengah taman. TUHAN melarang kami menyentuh, apalagi memakan buahnya. Kalau kami melanggar, kami akan mati.” ");
INSERT INTO ind_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lalu kata ular kepadanya, “Tidak! Kamu tidak akan mati! ");
INSERT INTO ind_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Allah berkata begitu karena Dia tahu bahwa kalau kalian memakan buah dari pohon yang di tengah taman itu, mata dan pikiran kalian akan terbuka, sehingga kalian menjadi seperti Dia, yaitu mengetahui hal yang baik dan yang buruk.” ");
INSERT INTO ind_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Perempuan itu pun melihat bahwa buah pohon tersebut sangat indah dipandang dan tampaknya sedap untuk dimakan. Lagipula, dia juga ingin menjadi bijaksana. Karena itu, dia memetik beberapa buah pohon itu dan memakannya. Dia juga memberikan buah itu kepada suaminya untuk dimakan. Segera sesudah mereka makan buah itu, ");
INSERT INTO ind_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","mata dan pikiran mereka tiba-tiba terbuka. Mereka malu karena menyadari bahwa mereka telanjang. Maka keduanya menyambung beberapa daun pohon ara untuk menutupi tubuhnya masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Menjelang sore hari, ketika angin sepoi-sepoi mulai berhembus, mereka mendengar langkah kaki TUHAN Allah yang sedang berjalan di taman. Laki-laki itu dan istrinya pun bersembunyi di balik pepohonan, supaya TUHAN tidak melihat mereka. ");
INSERT INTO ind_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tetapi TUHAN memanggil laki-laki itu dan berkata, “Di manakah kamu?” ");
INSERT INTO ind_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Jawab laki-laki itu, “Aku mendengar bunyi langkah kaki-Mu di taman ini dan aku takut, karena aku telanjang. Jadi aku bersembunyi.” ");
INSERT INTO ind_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Lalu TUHAN berkata, “Bagaimana kamu bisa tahu bahwa kamu telanjang? Apa kamu sudah makan buah dari pohon yang Aku larang itu?” ");
INSERT INTO ind_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Laki-laki itu menjawab, “Ya, tetapi itu gara-gara perempuan yang Engkau berikan kepadaku. Dialah yang memberikan buah itu, sehingga aku memakannya.” ");
INSERT INTO ind_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lalu TUHAN Allah bertanya kepada perempuan, “Mengapa kamu melakukan itu?” Jawab perempuan itu, “Ular sudah menipu aku, sehingga aku makan buah itu!” ");
INSERT INTO ind_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Maka berkatalah TUHAN kepada ular itu, “Karena kamu sudah melakukan hal ini, maka di antara semua hewan ternak dan binatang buas, hanya kamu dan keturunanmu yang akan Aku hukum. Mulai sekarang, kamu dan semua keturunanmu akan bergerak dengan menjalar menggunakan perut, dan kamu terpaksa menjilat debu seumur hidupmu. ");
INSERT INTO ind_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aku akan membuat kamu dan perempuan ini saling bermusuhan. Keturunanmu dan keturunannya akan selalu bermusuhan. Kamu akan menggigit tumit keturunannya yang laki-laki, tetapi keturunannya itu akan menghancurkan kepalamu.” ");
INSERT INTO ind_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kepada perempuan itu, TUHAN berkata, “Aku akan memperbesar penderitaan dan kesakitanmu saat melahirkan. Kamu akan merasa ingin berkuasa atas suamimu, tetapi dialah yang akan berkuasa atasmu.” ");
INSERT INTO ind_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kepada laki-laki itu, TUHAN berkata, “Aku memerintahkanmu untuk tidak makan buah dari pohon itu, tetapi kamu melanggarnya dengan menuruti perkataan istrimu. Oleh karena perbuatanmu itu, Aku mengutuk tanah. Sepanjang hidupmu, kamu akan bekerja dengan susah payah untuk dapat menghasilkan makanan dari tanah. ");
INSERT INTO ind_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tanah akan cenderung menghasilkan semak dan tumbuhan berduri, dan kamu terpaksa makan tumbuh-tumbuhan liar. ");
INSERT INTO ind_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Sepanjang hidupmu, sebelum kamu mati dan kembali menjadi tanah, kamu harus bermandi keringat untuk menghasilkan makanan dari tanah kebunmu. Aku menciptakanmu dari tanah, dan kamu akan kembali menjadi tanah sesudah kamu mati.” ");
INSERT INTO ind_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Laki-laki itu bernama Adam. Adam menamai istrinya Hawa— yang berarti ‘pemberi kehidupan’— karena seluruh umat manusia adalah keturunannya. ");
INSERT INTO ind_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","TUHAN membuat pakaian dari kulit binatang dan memakaikannya kepada mereka. ");
INSERT INTO ind_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kemudian berkatalah TUHAN, “Sekarang mereka sudah menjadi seperti Kita dalam hal dapat membedakan yang baik dan yang buruk. Karena itu, jangan sampai mereka memetik dan makan buah dari pohon kehidupan. Aku tidak mengizinkan mereka untuk hidup selama-lamanya.” ");
INSERT INTO ind_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Jadi, TUHAN mengusir Adam dan Hawa keluar dari Taman Eden untuk menggarap tanah, yang darinya Adam dibentuk. ");
INSERT INTO ind_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Sesudah itu, TUHAN menempatkan beberapa malaikat penjaga di pintu masuk Taman Eden, yang terletak di sebelah timur taman itu. TUHAN juga menempatkan sebilah pedang berapi yang dengan sendirinya bergerak menghalangi jalan yang menuju ke pohon kehidupan, sehingga tidak ada orang yang bisa mengambil buahnya. ");
INSERT INTO ind_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam dan Hawa pun hidup bersama sebagai suami-istri. Lalu Hawa mengandung dan melahirkan seorang anak laki-laki. Pada waktu anak itu lahir, Hawa berkata, “TUHAN sudah menolongku untuk memperoleh seorang anak laki-laki.” Maka dia menamai anak itu Kain. ");
INSERT INTO ind_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Beberapa waktu kemudian, Hawa melahirkan seorang anak laki-laki lagi, dan menamai dia Habel. Sesudah kedua anak itu dewasa, Kain menjadi petani, sedangkan Habel menjadi gembala kambing domba. ");
INSERT INTO ind_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Suatu hari, Kain memanen hasil kebunnya lalu mempersembahkan sebagian kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel juga mengambil beberapa ekor anak domba yang sulung dari kawanan ternaknya, lalu mempersembahkan bagian-bagian terbaik dari daging domba-domba itu kepada TUHAN. TUHAN senang kepada Habel dan persembahannya, ");
INSERT INTO ind_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tetapi tidak kepada Kain dan persembahannya. Karena itu, Kain sangat sakit hati, dan mukanya kelihatan masam. ");
INSERT INTO ind_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Maka TUHAN berkata kepada Kain, “Tidak usah marah! Janganlah mukamu masam! ");
INSERT INTO ind_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalau kamu melakukan yang benar, tentu Aku akan menerima persembahan-persembahanmu. Tetapi kalau kamu terus melakukan yang tidak benar, kuasa dosa— yang bagaikan binatang buas— sudah siap menerkam dan menguasaimu. Kamu harus mampu mengalahkannya.” ");
INSERT INTO ind_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Meski begitu, suatu hari Kain berkata kepada adiknya, “Habel, ayo kita ke ladang.” Setibanya mereka di ladang, tiba-tiba Kain menyerang dan membunuh Habel. ");
INSERT INTO ind_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kemudian TUHAN bertanya kepada Kain, “Di manakah Habel adikmu?” Jawab Kain, “Aku tidak tahu. Aku bukan penjaganya!” ");
INSERT INTO ind_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Maka berkatalah TUHAN kepadanya, “Kamu sudah melakukan dosa besar! Dalam pandangan-Ku, darah adikmu yang sudah meresap ke tanah bagaikan suara Habel yang berseru-seru meminta pembalasan. ");
INSERT INTO ind_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Karena kamu sudah membunuh adikmu sendiri, Aku mengusir kamu dari tanah yang sudah tercemar oleh darah adikmu ini. Sebagai kutukan bagimu, biarlah tanah di bumi tidak lagi memberi hasil yang baik untukmu, meskipun kamu berusaha keras menggarapnya! ");
INSERT INTO ind_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sebelumnya, tanah sangat subur bagimu. Tetapi mulai sekarang, apabila kamu menggarap dan menanam, tanah tidak akan memberi hasil yang baik lagi kepadamu, sehingga kamu terpaksa hidup berpindah-pindah.” ");
INSERT INTO ind_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Jawab Kain kepada TUHAN, “Hukuman itu terlalu berat! Aku tidak sanggup menanggungnya. ");
INSERT INTO ind_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Engkau mengusir aku dari tanah ini dan menjauhkan aku dari hadapan-Mu. Aku terpaksa hidup berpindah-pindah, dan siapa saja yang melihatku akan membunuhku!” ");
INSERT INTO ind_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tetapi TUHAN berkata kepadanya, “Tidak. Hal itu tidak akan terjadi. Aku akan memberi tanda di tubuhmu supaya orang tahu bahwa kamu tidak boleh dibunuh. Kalau kamu dibunuh, maka tujuh orang lain harus dibunuh sebagai pembalasan atas pembunuhanmu.” Lalu TUHAN memberi tanda pada dahi Kain. ");
INSERT INTO ind_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kemudian Kain pergi dari hadapan TUHAN dan tinggal di tanah yang disebut Nod, letaknya di sebelah timur Taman Eden. ");
INSERT INTO ind_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain menikah, lalu istrinya mengandung dan melahirkan seorang anak laki-laki yang diberi nama Henok. Pada waktu Kain membangun sebuah kota, dia menamai kota itu Henok, seperti nama anaknya. ");
INSERT INTO ind_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Selanjutnya, anak Henok adalah Irad. Anak Irad adalah Mehuyael. Anak Mehuyael adalah Metusael. Dan anak Metusael adalah Lamek. ");
INSERT INTO ind_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek menikahi dua perempuan, yaitu Adah dan Zilah. ");
INSERT INTO ind_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","21","Adah melahirkan dua anak yang bernama Yabal dan Yubal. Yabal adalah leluhur dari bangsa yang menjadi peternak. Karena kawanan ternak perlu berpindah-pindah tempat, maka Yabal menjadi orang pertama yang selalu hidup berkemah. Yubal, adik Yabal, adalah orang pertama yang membuat alat musik kecapi dan seruling. ");
INSERT INTO ind_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilah melahirkan seorang anak yang diberi nama Tubal Kain. Dialah orang pertama yang menjadi tukang tembaga dan besi. Tubal Kain mempunyai seorang adik perempuan bernama Naama. ");
INSERT INTO ind_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Suatu hari, Lamek berkata kepada kedua istrinya, “Adah dan Zilah, dengarkanlah aku! Aku membunuh seorang pemuda hanya karena dia membuatku memar. ");
INSERT INTO ind_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mengingat pembalasan bagi Kain, yaitu tujuh orang harus dibunuh bila dia dibunuh, maka kalau aku yang dibunuh, tujuh puluh tujuh orang harus dibunuh!” ");
INSERT INTO ind_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kemudian Hawa mengandung dan melahirkan seorang anak laki-laki lagi. Hawa berkata, “TUHAN sudah memberiku seorang anak sebagai pengganti Habel, yang sudah dibunuh oleh Kain.” Maka dia menamai anak itu Set. ");
INSERT INTO ind_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Selanjutnya, Set mempunyai anak bernama Enos. Pada zaman Enos inilah orang-orang mulai menyembah TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Inilah daftar keturunan Adam: Pada waktu Allah menciptakan manusia, Allah membuat mereka mencerminkan sifat-sifat-Nya. ");
INSERT INTO ind_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Allah menciptakan mereka sebagai laki-laki dan perempuan, memberkati mereka, dan menyebut mereka ‘manusia’. ");
INSERT INTO ind_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam berumur 130 tahun ketika anak laki-lakinya yang ketiga lahir. Adam menamai anaknya itu Set. Dia mencerminkan sifat-sifat Adam. ");
INSERT INTO ind_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sesudah Set lahir, Adam masih hidup selama 800 tahun. Sepanjang hidupnya, Adam mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Umur Adam mencapai 930 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set berumur 105 tahun ketika anaknya yang bernama Enos lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sesudah Enos lahir, Set masih hidup selama 807 tahun. Sepanjang hidupnya, Set mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Umur Set mencapai 912 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos berumur 90 tahun ketika anaknya yang bernama Kenan lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sesudah Kenan lahir, Enos masih hidup selama 815 tahun. Sepanjang hidupnya, Enos mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Umur Enos mencapai 905 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan berumur 70 tahun ketika anaknya yang bernama Mahalalel lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sesudah Mahalalel lahir, Kenan masih hidup selama 840 tahun lagi. Sepanjang hidupnya, Kenan mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Umur Kenan mencapai 910 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel berumur 65 tahun ketika anaknya yang bernama Yared lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sesudah Yared lahir, Mahalalel masih hidup selama 830 tahun. Sepanjang hidupnya, Mahalalel mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Umur Mahalalel mencapai 895 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared berumur 162 tahun ketika anaknya yang bernama Henok lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sesudah Henok lahir, Yared masih hidup selama 800 tahun. Sepanjang hidupnya, Yared mempunyai beberapa anak laki-laki dan perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Umur Yared mencapai 962 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok berumur 65 tahun ketika anaknya yang bernama Metusalah lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sesudah Metusalah lahir, Henok hidup bersekutu erat dengan Allah selama 300 tahun. Sepanjang hidupnya, Henok mempunyai beberapa anak laki-laki dan perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Jadi Henok hidup selama 365 tahun. ");
INSERT INTO ind_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok hidup bersekutu erat dengan Allah. Pada suatu hari, dia tidak ada lagi di bumi karena Allah membawanya ke surga. ");
INSERT INTO ind_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalah berumur 187 tahun ketika anaknya yang bernama Lamek lahir. ");
INSERT INTO ind_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sesudah Lamek lahir, Metusalah masih hidup selama 782 tahun. Sepanjang hidupnya, Metusalah mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Umur Metusalah mencapai 969 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Lamek berumur 182 tahun ketika anaknya, Nuh, dilahirkan. Lamek berkata, “Anak ini akan membawa kelegaan atas semua usaha dan susah payah kita untuk menghasilkan makanan dari tanah yang sudah dikutuk TUHAN.” Maka dia menamai anak itu Nuh. ");
INSERT INTO ind_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sesudah Nuh lahir, Lamek masih hidup selama 595 tahun. Sepanjang hidupnya, Lamek mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Umur Lamek mencapai 777 tahun, dan dia pun mati. ");
INSERT INTO ind_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Sejak Nuh berumur 500 tahun, dia mempunyai tiga anak laki-laki, yaitu Sem, Yafet, dan Ham. ");
INSERT INTO ind_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Jumlah manusia semakin bertambah dan menyebar di muka bumi. Di antara mereka terdapat banyak gadis yang begitu cantik sehingga anak-anak laki-laki Allah mengambil dan mengawini siapa saja yang mereka sukai dari para gadis itu. ");
INSERT INTO ind_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Maka berkatalah TUHAN, “Aku tidak mau nafas kehidupan-Ku tinggal dalam diri manusia selamanya-lamanya. Semua manusia adalah makhluk fana yang harus mati. Aku menetapkan bahwa umur setiap manusia tidak akan melebihi 120 tahun.” ");
INSERT INTO ind_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Banyak anak dilahirkan karena kawin campur tersebut. Pada waktu itu, muncullah orang-orang yang disebut Nefilim. Mereka terkenal pada zaman itu sebagai orang-orang yang sangat kuat dan tangguh dalam perang. ");
INSERT INTO ind_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","TUHAN melihat bahwa manusia di muka bumi sudah sangat jahat, dan isi hati mereka pun jahat. ");
INSERT INTO ind_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Dia sangat menyesal sudah menciptakan manusia di bumi. Hal itu membuat hati-Nya amat sedih. ");
INSERT INTO ind_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Berkatalah TUHAN, “Aku akan memusnahkan seluruh manusia, binatang berkaki empat, binatang melata, binatang merayap, dan burung-burung. Tidak akan ada satu pun yang tertinggal dari segala yang masih hidup di atas bumi. Aku sangat menyesal karena sudah menciptakan semua makhluk hidup itu.” ");
INSERT INTO ind_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tetapi TUHAN bermurah hati kepada Nuh. ");
INSERT INTO ind_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Beginilah riwayat tentang Nuh: Di antara semua orang yang hidup pada masa itu, hanya Nuh yang hidupnya benar di mata Allah. Nuh bersekutu erat dengan Allah. ");
INSERT INTO ind_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuh mempunyai tiga anak laki-laki, yaitu Sem, Yafet, dan Ham. ");
INSERT INTO ind_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Waktu itu, Allah melihat bahwa semua manusia yang lain di muka bumi sudah sangat jahat. Mereka bertindak kejam dan keras satu sama lain. ");
INSERT INTO ind_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allah begitu kecewa karena bumi sudah sangat rusak akibat kejahatan yang dilakukan manusia. ");
INSERT INTO ind_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Berkatalah Allah kepada Nuh, “Aku sudah memutuskan untuk memusnahkan seluruh manusia dan makhluk hidup yang lain, karena kekerasan manusia terhadap satu sama lain sudah memenuhi bumi. ");
INSERT INTO ind_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Buatlah bagimu kapal dari kayu pilihan. Di dalamnya, buatlah banyak ruang. Dan supaya air tidak bisa masuk, lapisilah bagian dalam dan luar kapal itu dengan ter. ");
INSERT INTO ind_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Inilah ukuran kapal yang harus kamu buat: Panjangnya 138 meter, lebarnya 23 meter, dan tingginya 14 meter. ");
INSERT INTO ind_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Buatlah atap kapal itu, dan berilah jarak 46 sentimeter antara atap dengan semua dinding di bawahnya, supaya udara dan cahaya dapat masuk. Buatlah tiga dek di dalamnya, dek atas, dek tengah, dan dek bawah. Buatlah juga pintu di bagian samping kapal. ");
INSERT INTO ind_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dengarlah baik-baik! Aku akan mendatangkan banjir besar di atas bumi untuk membinasakan semua makhluk yang bernafas di bawah langit. Segala sesuatu yang ada di bumi akan mati. ");
INSERT INTO ind_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Namun, sekarang Aku mengadakan perjanjian denganmu. Kamu, istrimu, ketiga putramu, dan ketiga menantumu akan selamat di dalam kapal itu. ");
INSERT INTO ind_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Dan karena Aku ingin menyelamatkan semua jenis makhluk hidup, maka kamu harus membawa sepasang dari tiap jenis, yaitu satu jantan dan satu betina, supaya setiap jenis binatang juga tetap hidup. ");
INSERT INTO ind_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sepasang dari masing-masing jenis burung, jenis binatang berkaki empat, jenis binatang melata, dan jenis binatang merayap akan datang kepadamu, agar dapat ikut ke dalam kapal dan tetap terpelihara. ");
INSERT INTO ind_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kamu juga harus membawa persediaan makanan untuk keluargamu dan untuk semua binatang itu. Simpanlah semuanya di dalam kapal.” ");
INSERT INTO ind_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Maka Nuh melakukan semua yang sudah Allah perintahkan kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kemudian TUHAN berkata kepada Nuh, “Aku melihat bahwa kamulah satu-satunya orang yang melakukan kehendak-Ku di zaman ini. Karena itu, masuklah ke kapal bersama seluruh keluargamu. ");
INSERT INTO ind_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Dari setiap jenis binatang yang layak dipersembahkan, bawalah tujuh pasang ke dalam kapal, yaitu tujuh jantan dan tujuh betina. Sedangkan dari setiap jenis binatang yang haram, bawalah satu pasang saja. ");
INSERT INTO ind_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Begitu juga dengan burung-burung, ambillah tujuh pasang dari setiap jenisnya. Dengan demikian, setiap jenis makhluk hidup tetap dapat berkembang biak sesudah banjir. ");
INSERT INTO ind_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Tujuh hari lagi, Aku akan menurunkan hujan lebat di bumi selama empat puluh hari empat puluh malam. Aku akan memusnahkan segala makhluk hidup yang sudah Aku ciptakan di muka bumi.” ");
INSERT INTO ind_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lalu Nuh melakukan semua yang sudah diperintahkan TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Pada waktu banjir besar itu melanda bumi, Nuh berumur 600 tahun. ");
INSERT INTO ind_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Untuk menyelamatkan diri dari banjir besar itu, Nuh masuk ke kapal bersama istrinya, ketiga putranya, dan ketiga menantunya. ");
INSERT INTO ind_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Sesuai dengan yang sudah diperintahkan Allah kepada Nuh, segala jenis binatang yang halal dan yang haram, burung, serta binatang yang melata dan yang merayap datang kepada Nuh berpasang-pasangan untuk masuk ke kapal. ");
INSERT INTO ind_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tujuh hari kemudian, banjir besar pun datang ke atas bumi. ");
INSERT INTO ind_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Sebulan setelah Nuh berumur 600 tahun, pada hari ketujuh belas bulan itu, semua mata air di bawah permukaan tanah tiba-tiba meluap, dan hujan turun begitu derasnya seakan semua pintu air yang ada di langit terbuka. ");
INSERT INTO ind_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Hujan terus-menerus mengguyur bumi selama empat puluh hari dan empat puluh malam. ");
INSERT INTO ind_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ketika hujan itu mulai turun, Nuh, istrinya, ketiga anaknya (Sem, Yafet, dan Ham), serta ketiga menantunya masuk ke dalam kapal. ");
INSERT INTO ind_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Begitu juga segala jenis binatang liar, hewan ternak, burung-burung, hewan bersayap, binatang melata, dan binatang merayap, ");
INSERT INTO ind_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","semuanya datang berpasang-pasangan dan masuk ke kapal itu bersama Nuh, ");
INSERT INTO ind_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","yaitu seekor jantan dan seekor betina, seperti yang sudah Allah perintahkan kepada Nuh. Setelah semuanya masuk, TUHAN menutup pintu kapal itu. ");
INSERT INTO ind_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Banjir yang merendam seluruh bumi terus bertambah tinggi selama empat puluh hari. Airnya semakin naik dan terus naik, sehingga kapal itu terangkat dan terapung-apung. ");
INSERT INTO ind_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Air itu kian bertambah tinggi hingga menutupi semua gunung, bahkan mencapai ketinggian sekitar tujuh meter di atas puncak gunung-gunung tertinggi di seluruh dunia. ");
INSERT INTO ind_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Maka matilah semua makhluk hidup di permukaan bumi, termasuk burung, hewan ternak, binatang liar, binatang melata, binatang merayap, dan manusia. ");
INSERT INTO ind_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Demikianlah semua makhluk hidup dibinasakan, kecuali Nuh dan semua yang ikut bersamanya di dalam kapal. ");
INSERT INTO ind_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Air itu menggenangi permukaan bumi selama 150 hari. ");
INSERT INTO ind_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Sesudah itu, perhatian Allah kembali tertuju kepada Nuh dan keluarganya serta semua yang bersama-sama dengan dia di dalam kapal itu. Maka Allah membuat angin bertiup di atas permukaan bumi, sehingga air mulai surut. ");
INSERT INTO ind_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Allah menghentikan hujan dan membuat semua mata air di bawah permukaan tanah berhenti menyembur. ");
INSERT INTO ind_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Air banjir yang tadinya menutupi permukaan bumi perlahan-lahan surut, sehingga sesudah 150 hari, air semakin berkurang. ");
INSERT INTO ind_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pada tanggal tujuh belas bulan ketujuh, kapal itu terdampar di salah satu gunung di wilayah Ararat. ");
INSERT INTO ind_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tanggal satu bulan kesepuluh, puncak-puncak gunung mulai terlihat karena permukaan air terus menurun. ");
INSERT INTO ind_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Empat puluh hari kemudian, Nuh membuka jendela yang sudah dibuatnya pada kapal itu, ");
INSERT INTO ind_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","lalu melepaskan seekor burung gagak. Burung gagak itu tidak kembali lagi ke kapal, tetapi terus terbang ke sana kemari sampai air banjir benar-benar kering dari permukaan bumi. ");
INSERT INTO ind_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Karena burung gagak itu tidak kembali, Nuh melepaskan seekor burung merpati untuk mencari tahu apakah air sudah surut. ");
INSERT INTO ind_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Merpati itu tidak dapat menemukan tempat untuk hinggap, karena air masih memenuhi seluruh permukaan bumi. Akhirnya, burung merpati itu kembali ke kapal. Nuh mengulurkan tangannya ke luar untuk menangkapnya, lalu mengembalikannya ke dalam kapal. ");
INSERT INTO ind_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tujuh hari kemudian, Nuh melepaskannya lagi. ");
INSERT INTO ind_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Menjelang malam, burung merpati itu kembali kepada Nuh dengan membawa sehelai daun zaitun segar di paruhnya. Dari situlah Nuh tahu bahwa air benar-benar sudah surut. ");
INSERT INTO ind_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tujuh hari sesudahnya, Nuh melepaskan burung itu lagi, tetapi kali ini burung merpati itu tidak kembali kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pada waktu Nuh berusia 601 tahun, pada tanggal satu bulan satu, air sudah surut sepenuhnya. Kemudian Nuh membuka penutup di bagian atas kapal dan melihat bahwa permukaan bumi sudah kering. ");
INSERT INTO ind_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pada tanggal dua puluh tujuh bulan berikutnya, seluruh permukaan bumi sudah benar-benar kering. ");
INSERT INTO ind_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Allah berkata kepada Nuh, ");
INSERT INTO ind_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Keluarlah dari kapal itu bersama istrimu, anak-anakmu, juga menantu-menantumu. ");
INSERT INTO ind_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Lepaskanlah semua jenis burung, hewan, binatang melata, dan semua yang merayap di tanah, supaya mereka dapat berkembang biak, bertambah banyak, serta menyebar ke seluruh bumi.” ");
INSERT INTO ind_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Lalu Nuh keluar dari kapal bersama istrinya, anak-anaknya, dan menantu-menantunya. ");
INSERT INTO ind_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Setiap jenis makhluk hidup juga meninggalkan kapal itu secara berkelompok, menurut jenisnya masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sesudah itu, Nuh membangun sebuah mezbah dari batu-batu untuk mempersembahkan kurban kepada TUHAN. Nuh memilih seekor dari tiap jenis binatang dan burung yang layak dipersembahkan kepada TUHAN, lalu mempersembahkannya di atas mezbah itu sebagai kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ketika TUHAN mencium bau harum kurban itu, Dia berkenan dan memutuskan dalam hati-Nya, “Aku tidak akan lagi mengutuk bumi ini sebagai hukuman atas manusia, meskipun sejak kanak-kanak keinginan mereka selalu jahat. Aku tidak akan lagi membinasakan semua makhluk hidup seperti yang sudah Aku lakukan ini! ");
INSERT INTO ind_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Selama bumi masih ada, tak akan pernah berhenti musim tanam dan musim panen, musim dingin dan musim panas, musim kemarau dan musim hujan, siang dan malam.” ");
INSERT INTO ind_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Lalu Allah memberkati Nuh dan anak-anaknya serta berkata kepada mereka, “Beranakcuculah hingga kalian menjadi banyak. Penuhilah bumi. ");
INSERT INTO ind_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Semua binatang di bumi, yaitu segala jenis ikan, burung, hewan ternak, binatang liar, dan serangga akan sangat takut kepada kalian. Semuanya itu Aku serahkan menjadi milik dan tanggung jawab kalian. ");
INSERT INTO ind_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dahulu Aku memberikan segala tumbuhan hijau sebagai makanan manusia. Sekarang Aku juga memberikan segala jenis binatang sebagai makanan kalian. ");
INSERT INTO ind_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tetapi darah dari binatang yang dipotong itu tidak boleh ikut dimakan, karena darah melambangkan kehidupan yang Aku berikan kepada setiap makhluk. ");
INSERT INTO ind_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Itulah sebabnya, Aku akan menjatuhkan hukuman kepada setiap manusia maupun binatang yang membunuh manusia, ");
INSERT INTO ind_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","karena manusia diciptakan untuk mencerminkan sifat-sifat-Ku. Siapa pun yang membunuh manusia, biarlah dia dibunuh oleh manusia juga. ");
INSERT INTO ind_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Sekali lagi Aku berkata kepada kalian: Beranakcuculah hingga kalian menjadi banyak, supaya keturunan kalian memenuhi seluruh bumi.” ");
INSERT INTO ind_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Allah berkata kepada Nuh dan anak-anaknya, ");
INSERT INTO ind_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Dengarkanlah baik-baik! Sekarang Aku mengadakan perjanjian dengan kalian dan keturunan-keturunan kalian, ");
INSERT INTO ind_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","juga dengan segala makhluk hidup yang sudah keluar dari kapal itu bersama kalian, termasuk burung-burung, berbagai binatang ternak, dan binatang-binatang liar. ");
INSERT INTO ind_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Aku berjanji bahwa Aku tidak akan lagi mendatangkan bencana banjir ke atas bumi yang membinasakan semua makhluk hidup.” ");
INSERT INTO ind_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Kemudian Allah berkata kepada mereka, “Aku akan memenuhi perjanjian-Ku ini kepada seluruh makhluk hidup, termasuk kalian dan seluruh keturunan kalian sampai selama-lamanya. Sebagai tanda perjanjian, Aku akan menempatkan pelangi di langit. ");
INSERT INTO ind_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ketika Aku mendatangkan hujan dari awan, pelangi akan muncul di langit, ");
INSERT INTO ind_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","dan Aku akan mengingat perjanjian yang sudah Aku buat dengan kalian dan semua makhluk hidup, bahwa Aku tidak akan lagi mendatangkan banjir untuk memusnahkan segala makhluk hidup. ");
INSERT INTO ind_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Setiap kali Aku melihat pelangi itu muncul di langit, Aku akan mengingat perjanjian yang sudah Aku tetapkan tadi dengan semua makhluk hidup di bumi. Perjanjian itu berlaku untuk selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dan pelangi merupakan tanda jaminan terhadap perjanjian itu, yang sudah Aku adakan dengan semua makhluk hidup di bumi.” ");
INSERT INTO ind_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Anak-anak Nuh yang keluar dari kapal itu adalah Sem, Yafet, dan Ham. Ketiga anak Nuh inilah yang menjadi nenek moyang semua bangsa di dunia. Ham adalah bapak Kanaan. (Di kemudian hari, keturunan Kanaan disebut bangsa Kanaan.) ");
INSERT INTO ind_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh menjadi petani dan membuat kebun anggur. ");
INSERT INTO ind_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Suatu hari, dia minum anggur terlalu banyak sampai mabuk. Lalu dia berbaring telanjang di dalam kemahnya. ");
INSERT INTO ind_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ketika Ham, bapak Kanaan, melihat ayahnya sendiri sedang berbaring di dalam kemahnya dengan telanjang, dia keluar memberitahukan hal itu kepada kedua kakaknya. ");
INSERT INTO ind_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kemudian Sem dan Yafet mengambil sehelai jubah untuk menutupi tubuh ayah mereka. Dan supaya tidak melihat ketelanjangan ayah mereka, jubah itu mereka bentangkan terlebih dahulu dengan cara menaruh ujungnya di bahu mereka masing-masing, kemudian mereka berjalan mundur ke dalam kemah. Demikianlah mereka menutupi Nuh dengan jubah itu. ");
INSERT INTO ind_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ketika Nuh sadar dari mabuknya dan mengetahui apa yang sudah diperbuat anak bungsunya terhadap dirinya, ");
INSERT INTO ind_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","berkatalah dia, “Karena kesalahan Ham, terkutuklah bangsa Kanaan. Biarlah mereka menjadi budak terhina bagi keturunan Sem dan Yafet. ");
INSERT INTO ind_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Terpujilah TUHAN, Allah yang disembah oleh Sem! Biarlah keturunan Ham menjadi budaknya. ");
INSERT INTO ind_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kiranya TUHAN menambahkan berkat kepada Yafet dengan memperluas wilayahnya. Biarlah keturunannya hidup rukun dengan keturunan Sem, dan biarlah keturunan Kanaan menjadi budak keturunan Yafet juga.” ");
INSERT INTO ind_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Sesudah peristiwa banjir besar itu, Nuh masih hidup selama 350 tahun lagi. ");
INSERT INTO ind_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kemudian dia meninggal di usia 950 tahun. ");
INSERT INTO ind_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ketiga anak laki-laki Nuh adalah Sem, Yafet, dan Ham. Sesudah peristiwa banjir berlalu, mereka masing-masing memiliki banyak anak laki-laki. ");
INSERT INTO ind_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Anak-anak Yafet bernama Gomer, Magog, Madai, Yawan, Tubal, Mesek, dan Tiras. ");
INSERT INTO ind_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Anak-anak Gomer bernama Askenas, Rifat, dan Togarma. ");
INSERT INTO ind_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Anak-anak Yawan bernama Elisa, Tarsis, Kit, dan Dodan. ");
INSERT INTO ind_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Merekalah yang menjadi nenek moyang orang-orang yang tinggal di daerah pesisir dan pulau-pulau di Laut Tengah. Mereka tersebar dan menetap di daerah masing-masing menurut suku, bangsa, dan bahasa mereka. ");
INSERT INTO ind_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Anak-anak Ham bernama Kus, Mesir, Put, dan Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Anak-anak Kus bernama Seba, Hawila, Sabta, Rama, dan Sabteka. Kedua anak Rama bernama Syeba dan Dedan. ");
INSERT INTO ind_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus mempunyai seorang anak bernama Nimrod. Dialah orang pertama yang terkenal di dunia sebagai orang yang sangat tangguh dalam berperang. ");
INSERT INTO ind_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","TUHAN memberkati Nimrod sehingga dia menjadi seorang pemburu yang perkasa. Itulah sebabnya orang-orang sering mengatakan, “Semoga anakmu menjadi seperti Nimrod, pemburu yang gagah perkasa karena berkat TUHAN.” ");
INSERT INTO ind_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod menjadi raja dan memerintah di negeri Babel, yang juga disebut tanah Sinear. Ada empat wilayah penting dalam kerajaannya. Keempatnya mempunyai ibukota sendiri, yaitu: Babel, Erek, Akad, dan Kalne. ");
INSERT INTO ind_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kemudian dia pergi ke tanah Asyur dan mendirikan kota Niniwe, Rehobot Ir, Kalah, ");
INSERT INTO ind_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","dan Resen. Resen merupakan kota terbesar di antara kota Niniwe dan kota Kalah. ");
INSERT INTO ind_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Anak Ham yang kedua adalah Mesir. Dia menjadi nenek moyang dari orang-orang Lud, Anam, Lehab, Naftuh, ");
INSERT INTO ind_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Kaftor, dan Kasluh. Orang-orang Kasluh adalah nenek moyang bangsa Filistin. ");
INSERT INTO ind_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Anak Ham yang bungsu adalah Kanaan. Kanaan memiliki dua anak bernama Sidon dan Het. ");
INSERT INTO ind_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan adalah nenek moyang orang-orang Yebus, Amori, Girgasi, ");
INSERT INTO ind_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hewi, Arki, Sini, ");
INSERT INTO ind_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari, dan Hamat. Keturunan Kanaan tersebar luas. ");
INSERT INTO ind_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tanah yang menjadi milik mereka terbentang mulai dari kota Sidon di utara dan meluas hingga ke kota Gaza di selatan. Di wilayah timur, mereka menempati kota Gerar, kemudian meluas ke kota Sodom, Gomora, Adma, Zeboim, hingga ke kota Lasa. ");
INSERT INTO ind_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Semuanya itu adalah keturunan Ham. Mereka tinggal dalam wilayahnya masing-masing menurut suku, bangsa, dan bahasa mereka. ");
INSERT INTO ind_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, kakak Yafet, adalah nenek moyang Eber. Keturunan Eber menjadi bangsa Ibrani. ");
INSERT INTO ind_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Nama anak-anak Sem adalah Elam, Asyur, Arpaksad, Lud, dan Aram. ");
INSERT INTO ind_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Nama anak-anak Aram adalah Us, Hul, Geter, dan Mas. ");
INSERT INTO ind_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Anak Arpaksad bernama Selah. Anak Selah bernama Eber. ");
INSERT INTO ind_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber memiliki dua anak. Yang pertama bernama Peleg dan yang kedua bernama Yoktan. Arti nama Peleg adalah ‘terbagi’. Dia diberi nama demikian karena pada zamannya orang-orang di bumi terpisah-pisah dan tersebar ke seluruh bumi. ");
INSERT INTO ind_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan adalah nenek moyang dari Almodad, Selef, Hazarmawet, Yerah, ");
INSERT INTO ind_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO ind_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO ind_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Hawila, dan Yobab. Itulah keturunan Yoktan. ");
INSERT INTO ind_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Daerah-daerah tempat tinggal mereka terbentang mulai dari Mesa dan meluas ke Sefar, daerah perbukitan di sebelah timur. ");
INSERT INTO ind_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Semua suku itu adalah keturunan Sem. Mereka hidup dan tinggal dalam wilayahnya masing-masing menurut suku, bangsa, dan bahasa mereka. ");
INSERT INTO ind_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Itulah suku-suku keturunan anak-anak Nuh. Setiap suku memiliki daftar silsilahnya masing-masing. Sesudah peristiwa banjir berlalu, suku-suku bangsa tersebut tersebar luas di atas permukaan bumi. ");
INSERT INTO ind_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Awalnya, semua manusia di bumi berbicara dalam bahasa yang sama. ");
INSERT INTO ind_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Waktu mereka mengembara ke arah timur, sampailah mereka di sebuah dataran, yaitu negeri yang kemudian disebut Babel. Mereka pun mulai menetap di sana. ");
INSERT INTO ind_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Lalu mereka berkata satu sama lain, “Marilah kita membangun sebuah kota besar dengan gedung menara yang puncaknya sampai ke langit. Kita akan memakai batu bata dan ter untuk bahan perekatnya. Dengan demikian, kita akan terkenal dan tidak tercerai-berai ke seluruh bumi!” ");
INSERT INTO ind_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pada waktu mereka mulai membangun kota dan menara itu, turunlah TUHAN untuk melihat pekerjaan manusia-manusia yang fana itu. ");
INSERT INTO ind_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","TUHAN berkata, “Orang-orang ini satu bangsa dan berbicara dalam satu bahasa. Jika Kita membiarkan mereka melakukan hal besar seperti ini, maka nanti tidak ada lagi hal yang tak mampu mereka lakukan. ");
INSERT INTO ind_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mari Kita turun ke sana dan mengacaukan bahasa mereka, supaya mereka tidak saling mengerti apa yang dikatakan satu sama lain.” ");
INSERT INTO ind_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Demikianlah cara TUHAN mencerai-beraikan mereka ke seluruh bumi. Lalu berhentilah mereka membangun kota tersebut. ");
INSERT INTO ind_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Itulah sebabnya kota itu dinamai Babel, yang berarti ‘kacau’, karena di sanalah TUHAN mengacaukan bahasa manusia di seluruh bumi sehingga orang-orang tidak lagi berbicara dalam satu bahasa saja, tetapi banyak bahasa, dan karena dari tempat itulah TUHAN mencerai-beraikan mereka ke seluruh bumi. ");
INSERT INTO ind_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Inilah daftar keturunan Sem: Dua tahun sesudah banjir besar, Sem genap berumur 100 tahun. Pada tahun itu, dia mendapat seorang anak laki-laki bernama Arpaksad. ");
INSERT INTO ind_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sesudah Arpaksad lahir, Sem masih hidup 500 tahun lagi. Dan sepanjang hidupnya, Sem mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Pada waktu Arpaksad berumur 35 tahun, dia mempunyai anak laki-laki bernama Selah. ");
INSERT INTO ind_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sesudah Selah lahir, Arpaksad masih hidup 403 tahun lagi. Dan sepanjang hidupnya, Arpaksad mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Pada waktu Selah berumur 30 tahun, dia mempunyai anak laki-laki bernama Eber. ");
INSERT INTO ind_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sesudah Eber lahir, Selah masih hidup 403 tahun lagi. Dan sepanjang hidupnya, Selah mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Pada waktu Eber berumur 34 tahun, dia mempunyai anak laki-laki bernama Peleg. ");
INSERT INTO ind_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sesudah Peleg lahir, Eber masih hidup 430 tahun lagi. Sepanjang hidupnya, Eber mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pada waktu Peleg berumur 30 tahun, dia mempunyai anak laki-laki bernama Rehu. ");
INSERT INTO ind_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sesudah Rehu lahir, Peleg masih hidup 209 tahun lagi. Sepanjang hidupnya, Peleg mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Pada waktu Rehu berumur 32 tahun, dia mempunyai anak laki-laki bernama Serug. ");
INSERT INTO ind_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sesudah Serug lahir, Rehu masih hidup 207 tahun lagi. Sepanjang hidupnya, Rehu mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Pada waktu Serug berumur 30 tahun, dia mempunyai anak laki-laki bernama Nahor. ");
INSERT INTO ind_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sesudah Nahor lahir, Serug masih hidup 200 tahun lagi. Sepanjang hidupnya, Serug mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Pada waktu Nahor berumur 29 tahun, dia mempunyai anak laki-laki bernama Terah. ");
INSERT INTO ind_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sesudah Terah lahir, Nahor masih hidup 119 tahun lagi. Sepanjang hidupnya, Nahor mempunyai beberapa anak laki-laki dan anak perempuan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pada waktu Terah berumur 70 tahun, dia mempunyai anak laki-laki bernama Abram. Selain Abram, lahir pula dua orang lagi anak laki-laki bagi Terah, yaitu Nahor dan Haran. ");
INSERT INTO ind_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Inilah keturunan Terah: Terah adalah ayah dari Abram, Nahor, dan Haran. Haran mempunyai seorang anak laki-laki bernama Lot. ");
INSERT INTO ind_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran meninggal di kampung halamannya, yaitu Ur di Babel, sementara ayahnya masih hidup. ");
INSERT INTO ind_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram menikah dengan Sarai. Nahor menikah dengan Milka, anak Haran. Anak perempuan Haran yang lainnya bernama Yiska. ");
INSERT INTO ind_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sesudah menikah selama beberapa tahun, Sarai tetap tidak mempunyai anak karena dia mandul. ");
INSERT INTO ind_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Beberapa tahun kemudian, Terah meninggalkan kota Ur di Babel bersama Abram anaknya dan Sarai menantunya. Cucunya yang bernama Lot juga ikut. Terah bermaksud pergi ke negeri Kanaan. Namun, setibanya di kota Haran, mereka menetap di sana. ");
INSERT INTO ind_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ketika berumur 205 tahun, Terah meninggal di kota Haran. ");
INSERT INTO ind_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kemudian TUHAN berkata kepada Abram, “Tinggalkanlah negerimu, rumah ayahmu, dan kaum keluargamu. Pergilah ke negeri yang akan Aku tunjukkan kepadamu. ");
INSERT INTO ind_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aku akan memberkatimu dan memberikan kepadamu keturunan yang banyak hingga menjadi bangsa yang besar. Aku akan membuat namamu dikenal oleh banyak orang dan kamu akan menjadi berkat. ");
INSERT INTO ind_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aku akan memberkati orang-orang yang memberkatimu dan mengutuk siapa pun yang mengutukmu. Semua suku bangsa di bumi akan diberkati melalui kamu.” ");
INSERT INTO ind_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Pada waktu itu, Abram sudah berusia 75 tahun. Lalu dia, Sarai, dan Lot, pergi meninggalkan Haran, seperti yang diperintahkan TUHAN kepadanya. Abram membawa segala harta benda serta budak yang sudah mereka peroleh di Haran, dan pergi menuju Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Mereka melakukan perjalanan sampai tiba di suatu tempat dekat Sikem, tidak jauh dari pohon yang dianggap keramat di More. Pada masa itu, orang-orang Kanaan masih mendiami tanah itu. ");
INSERT INTO ind_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kemudian TUHAN menampakkan diri kepada Abram dan berkata, “Aku akan memberikan tanah ini kepada keturunanmu.” Lalu Abram membangun sebuah mezbah dari batu di tempat itu, untuk mempersembahkan kurban kepada TUHAN yang sudah menampakkan diri kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Dari Sikem, Abram dan keluarganya pindah ke daerah perbukitan di sebelah timur Betel. Di sana, mereka mendirikan kemah tepat di antara Betel dan Ai, sehingga dari tempat mereka berkemah itu, posisi Betel berada di sebelah barat dan Ai di sebelah timur. Di tempat itu, Abram membangun sebuah mezbah lagi untuk mempersembahkan kurban sembelihan kepada TUHAN dan meminta pertolongan-Nya. ");
INSERT INTO ind_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kemudian mereka meninggalkan tempat itu dan berpindah ke daerah Kanaan bagian selatan. ");
INSERT INTO ind_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lalu timbullah bencana kelaparan di negeri itu sehingga mereka terpaksa pergi ke Mesir dan tinggal di sana untuk sementara waktu. ");
INSERT INTO ind_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pada waktu mereka hendak melewati perbatasan wilayah negeri Mesir, berkatalah Abram kepada Sarai, “Kamu sangat cantik. ");
INSERT INTO ind_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Karena itu, kalau orang-orang Mesir melihatmu, mereka akan berkata, ‘Perempuan itu adalah istrinya!’ Lalu demi memperolehmu, mereka akan membunuh aku, sedangkan kamu akan mereka biarkan hidup. ");
INSERT INTO ind_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Jadi, lebih baik katakan saja kepada mereka bahwa kamu adalah adikku, supaya mereka membiarkan aku hidup dan aku diperlakukan dengan baik.” ");
INSERT INTO ind_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ternyata benar. Begitu mereka tiba, orang-orang Mesir melihat bahwa Sarai sangat cantik. ");
INSERT INTO ind_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ketika para pejabat kerajaan melihatnya, datanglah mereka kepada raja Mesir dan memuji-muji kecantikan perempuan itu di hadapannya. Maka atas perintah raja, Sarai dibawa ke dalam istana. ");
INSERT INTO ind_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Demi mendapatkan Sarai, raja memperlakukan Abram dengan baik, sehingga Abram diberi banyak domba, sapi, keledai, dan unta. Raja juga memberikan beberapa budak laki-laki dan perempuan kepada Abram. ");
INSERT INTO ind_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Namun, karena raja hendak menikahi Sarai, TUHAN membuat raja dan semua orang di dalam istana itu menderita berbagai penyakit yang berbahaya. ");
INSERT INTO ind_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Akhirnya raja menyadari penyebab penyakit berbahaya yang menyerang orang-orang di istananya. Dia pun memanggil Abram dan berkata, “Kamu sudah membohongi aku! Kenapa kamu tidak memberitahuku bahwa dia adalah istrimu?! ");
INSERT INTO ind_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Kenapa kamu berbohong dengan mengatakan bahwa dia itu adikmu, sehingga aku mengambilnya menjadi istriku?! Sekarang bawalah istrimu dan pergi tinggalkan tempat ini!” ");
INSERT INTO ind_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kemudian raja menyuruh anak buahnya mengusir Abram dari Mesir, dengan membawa istrinya dan segala miliknya. ");
INSERT INTO ind_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Maka Abram meninggalkan Mesir bersama Sarai. Dia membawa segala harta miliknya. Lot, keponakan Abram, juga ikut bersamanya. Mereka pergi menuju negeri Kanaan bagian selatan. ");
INSERT INTO ind_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram sangat kaya. Ternak, perak, dan emasnya begitu banyak. ");
INSERT INTO ind_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Abram dan keluarganya hidup berpindah-pindah. Mereka pindah mulai dari selatan Kanaan dan tinggal di beberapa tempat lain yang bisa menghasilkan makanan bagi mereka dan ternak-ternak mereka. Akhirnya mereka tiba di suatu tempat antara Betel dan Ai, di mana dulu Abram pernah berkemah dan mendirikan mezbah dari batu-batu untuk mempersembahkan hewan kurban dan meminta pertolongan dari TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Seperti Abram, Lot juga memiliki banyak domba dan kambing serta perkemahan yang luas. ");
INSERT INTO ind_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Karena ternak mereka semakin banyak, lahan itu tidak memungkinkan bagi Abram dan Lot untuk tinggal bersama. Di sana tidak ada cukup air dan padang rumput hijau bagi semua ternak mereka. Maka terjadilah pertengkaran antara para gembala Abram dan Lot. Pada waktu itu, bangsa Kanaan dan Feris juga tinggal di wilayah tersebut. ");
INSERT INTO ind_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Jadi, berkatalah Abram kepada Lot, “Kita ini bersaudara. Tidak baik jika para gembalaku dan para gembalamu bertengkar. ");
INSERT INTO ind_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Sebaiknya kita berpisah saja, dan biarlah kamu yang pertama memilih tempat. Ada banyak daerah yang masih terbuka untuk kita. Kalau kamu mau yang di sebelah sana, aku akan tinggal di sini. Kalau kamu mau yang di sini, aku akan pergi ke sebelah sana.” ");
INSERT INTO ind_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Maka Lot melayangkan pandangannya dan melihat bahwa seluruh lembah Yordan sampai ke Zoar dialiri banyak air, seperti Taman Eden dan tanah Mesir yang dekat sungai Nil. (Hal ini terjadi sebelum TUHAN membinasakan Sodom dan Gomora.) ");
INSERT INTO ind_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jadi Lot memilih tanah di daerah itu. Dia pindah ke sebelah timur dari tempat tinggal Abram. Demikianlah keduanya berpisah. ");
INSERT INTO ind_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram menetap di daerah Kanaan, sementara Lot menetap di lembah Yordan dekat kota Sodom. ");
INSERT INTO ind_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tetapi ternyata penduduk kota Sodom luar biasa jahat dan sangat berdosa terhadap TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sesudah mereka berpisah, Allah berkata kepada Abram, “Layangkanlah pandanganmu ke arah timur, barat, utara, dan selatan dari tempat kamu berdiri itu. ");
INSERT INTO ind_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Aku akan memberikan seluruh negeri yang kamu lihat itu kepadamu dan kepada keturunanmu untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aku akan memberikan kepadamu keturunan yang sangat banyak, seperti banyaknya debu tanah di bumi! Sebagaimana orang tidak bisa menghitung debu tanah, demikianlah keturunanmu tidak akan bisa dihitung jumlahnya. ");
INSERT INTO ind_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Sekarang, pergi dan jelajahilah seluruh tanah itu, karena Aku akan memberikannya kepadamu.” ");
INSERT INTO ind_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Lalu Abram berpindah dari tempat itu ke dekat Hebron dan menetap di dekat pohon-pohon yang dianggap keramat milik orang bernama Mamre. Di tempat itulah dia mendirikan mezbah untuk menyembah TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Pada waktu itu, terjadi perang di daerah Lot. Ada empat raja dari wilayah timur yang bergabung untuk melawan lima raja dari wilayah barat. Keempat raja dari wilayah timur itu adalah Raja Amrafel dari Babel, Raja Ariok dari Elasar, Raja Kedorlaomer dari Elam, dan Raja Tidal dari Goyim. Sedangkan kelima raja dari wilayah barat adalah Raja Bera dari Sodom, Raja Birsa dari Gomora, Raja Sinab dari Adma, Raja Semeber dari Zeboim, dan seorang raja dari Bela yang juga disebut Zoar. ");
INSERT INTO ind_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kelima raja itu bergabung dan mengumpulkan tentara mereka di Lembah Sidim, yaitu lembah yang sekarang tertutup oleh Laut Mati. ");
INSERT INTO ind_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Sebelum perang itu, selama dua belas tahun, Raja Kedorlaomer menguasai lima kerajaan di wilayah barat dan memaksa mereka membayar pajak kepadanya dalam jumlah yang sangat besar. Namun, pada tahun ketiga belas, mereka memberontak dan menolak untuk membayar pajak tersebut. ");
INSERT INTO ind_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pada tahun keempat belas, Raja Kedorlaomer bersama raja-raja yang bergabung dengan dia datang dengan tentara mereka dan mengalahkan orang Refaim di Asterot Karna, orang Susim di Ham, orang Emim di Syawe Kiryataim, ");
INSERT INTO ind_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","dan orang Hori yang tinggal di daerah perbukitan Seir sampai sejauh El Paran, yang terletak dekat padang belantara. ");
INSERT INTO ind_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kemudian Raja Kedorlaomer dan sekutunya kembali ke wilayah Lot, lalu menyerang kota En Mispat, yang sekarang disebut Kades. Mereka mengalahkan bangsa Amalek dan menguasai seluruh daerahnya, juga daerah sebagian bangsa Amori yang tinggal di kota Hasason Tamar. ");
INSERT INTO ind_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kemudian raja-raja dari Sodom, Gomora, Adma, Zeboim dan Bela mengerahkan seluruh tentara mereka untuk berperang melawan tentara musuh di Lembah Sidim. ");
INSERT INTO ind_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Mereka berperang melawan tentara gabungan dari Kedorlaomer raja Elam, Tidal raja Goim, Amrafel raja Babel, dan Ariok raja Elasar. Jadi, empat kekuatan gabungan melawan lima. ");
INSERT INTO ind_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Di Lembah Sidim itu banyak sekali lubang berisi ter. Ketika raja Sodom dan raja Gomora serta pasukan mereka melarikan diri, banyak tentara jatuh ke dalam lubang-lubang berisi ter itu. Orang-orang lain yang berhasil lolos melarikan diri ke daerah perbukitan. ");
INSERT INTO ind_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Pasukan keempat raja tersebut merampas segala yang berharga dari Sodom dan Gomora, termasuk semua persediaan makanan. Ketika peristiwa ini terjadi, Lot, keponakan Abram, sedang tinggal di Sodom. Pasukan musuh menawan dia juga dan merampas seluruh harta benda miliknya. Lalu mereka berangkat kembali ke arah timur. ");
INSERT INTO ind_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Namun, seseorang berhasil melarikan diri dan melaporkan peristiwa itu kepada Abram. Waktu itu, Abram, orang Ibrani itu, tinggal sebagai pendatang di dekat pohon yang dianggap keramat di tanah milik Mamre, orang Amori. Mamre dan kedua saudaranya yang bernama Eskol dan Aner adalah sekutu Abram. ");
INSERT INTO ind_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ketika Abram mendengar bahwa keponakannya sudah ditawan, dia mengerahkan 318 orang budaknya yang terlatih sebagai tentara. (Mereka lahir di rumah Abram sehingga sudah berstatus sebagai budaknya sejak lahir.) Pasukan Abram bersama para tentara dari ketiga bersaudara yang bersekutu dengannya mengejar keempat raja yang dipimpin oleh Kedorlaomer ke arah utara sampai ke kota Dan. ");
INSERT INTO ind_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abram membagi para tentaranya menjadi beberapa kelompok. Pada tengah malam, mereka menyerang musuh secara serentak dari berbagai arah dan berhasil mengalahkan mereka. Ketika musuh-musuh itu lari, Abram dan para tentaranya mengejar mereka hingga ke kota Hobah, yang terletak di utara kota Damsik. ");
INSERT INTO ind_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram dan orang-orangnya berhasil merebut kembali segala harta benda yang sudah dirampas, juga menyelamatkan Lot beserta semua harta bendanya, termasuk para wanita dan tawanan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ketika Abram dalam perjalanan pulang setelah dia dan para tentaranya mengalahkan pasukan Raja Kedorlaomer dan sekutunya, Raja Sodom pergi untuk menemui Abram di Lembah Syawe, yang juga disebut Lembah Raja. ");
INSERT INTO ind_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek adalah raja dari kota Salem. Dia juga seorang imam yang mempersembahkan kurban kepada Allah Yang Mahatinggi. Dia keluar dari Salem membawa hadiah roti dan anggur untuk mensyukuri kemenangan Abram. ");
INSERT INTO ind_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Kemudian dia memberkati Abram dengan berkata, “Semoga Allah Yang Mahatinggi, Pencipta surga, langit, dan bumi, memberkatimu. ");
INSERT INTO ind_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Marilah kita memuji Allah Yang Mahatinggi karena Dialah yang sudah menolongmu mengalahkan musuh-musuhmu!” Kemudian Abram menyerahkan sepersepuluh dari seluruh hasil rampasan mereka kepada Melkisedek. ");
INSERT INTO ind_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Raja Sodom berkata kepada Abram, “Engkau tidak usah memberikan kepadaku harta benda kami yang sudah kalian rebut kembali dari tangan mereka. Saya hanya minta supaya engkau mengembalikan rakyatku.” ");
INSERT INTO ind_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Namun, Abram menjawab Raja Sodom, “Saya sudah bersumpah kepada TUHAN, Allah Yang Mahatinggi, Pencipta surga, langit, dan bumi, ");
INSERT INTO ind_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","bahwa saya tidak akan mengambil apa pun dari milikmu, bahkan sehelai benang atau sepotong tali sandal pun tidak! Dengan begitu, engkau tidak akan dapat berkata, ‘Abram menjadi kaya karena harta rampasan dari saya.’ ");
INSERT INTO ind_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Saya tidak akan mengambil apa pun untuk saya sendiri, selain yang sudah dimakan oleh para budak saya. Tetapi biarlah sekutu saya ini, Aner, Eskol, dan Mamre, mengambil bagian mereka.” ");
INSERT INTO ind_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Beberapa waktu kemudian, TUHAN berbicara kepada Abram dalam suatu penglihatan, kata-Nya, “Jangan takut, Abram! Aku akan melindungimu dari apa pun dan akan memberikan upah yang besar kepadamu.” ");
INSERT INTO ind_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Jawab Abram, “Ya TUHAN Penguasaku, untuk apa Engkau memberikan upah yang besar kepadaku, sementara aku tidak memiliki keturunan untuk mewarisinya. Aku terpaksa memilih Eliezer, budakku yang berasal dari Damsik itu, sebagai ahli warisku.” ");
INSERT INTO ind_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","TUHAN berkata, “Tidak! Budakmu itu tidak akan mewarisi hartamu. Kamu akan mempunyai keturunan, yaitu seorang anak laki-laki yang akan mewarisi segala sesuatu yang kamu miliki.” ");
INSERT INTO ind_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kemudian TUHAN membawa Abram keluar dari kemahnya dan berkata, “Lihatlah ke langit. Dapatkah kamu menghitung jumlah bintang? Tentu tidak! Demikianlah kelak keturunanmu akan terlalu banyak untuk dihitung, seperti bintang di langit.” ");
INSERT INTO ind_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram percaya penuh kepada semua yang dikatakan Allah. Karena itu Allah menerima Abram sebagai orang benar. ");
INSERT INTO ind_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Allah berkata lagi kepadanya, “Akulah TUHAN. Aku yang sudah membawa kamu keluar dari kota Ur di negeri Babel untuk memberikan negeri ini kepadamu agar menjadi milikmu.” ");
INSERT INTO ind_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Jawab Abram, “Ya TUHAN Penguasaku, bagaimanakah aku tahu bahwa Engkau pasti akan memberikan negeri ini kepadaku?” ");
INSERT INTO ind_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","TUHAN berkata kepadanya, “Bawalah kepada-Ku seekor sapi betina, seekor kambing betina, dan seekor domba jantan yang masing-masing berumur tiga tahun. Bawa juga seekor burung tekukur dan seekor burung merpati yang masih muda.” ");
INSERT INTO ind_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Lalu Abram membawa binatang-binatang itu, menyembelihnya, dan membelah setiap ekor menjadi dua bagian, kecuali kedua burung itu tidak dibelahnya. Dia menjejerkan tiap belahan dari binatang-binatang itu menjadi dua baris secara berpasang-pasangan. Demikian juga kedua burung diletakkan sejajar dalam baris itu. ");
INSERT INTO ind_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Burung-burung pemakan bangkai hinggap untuk memakan daging tersebut, tetapi Abram mengusir mereka. ");
INSERT INTO ind_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sore hari, ketika matahari mulai terbenam, Abram tertidur nyenyak. Tiba-tiba dalam kegelapan itu, rasa takut yang amat kuat meliputinya. ");
INSERT INTO ind_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Saat itu, TUHAN berkata kepadanya, “Ketahuilah bahwa keturunanmu akan menjadi pendatang di negeri lain. Mereka akan menjadi budak bagi penduduk setempat dan akan ditindas selama 400 tahun. ");
INSERT INTO ind_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Namun, Aku akan menghukum penduduk negeri yang memperbudak keturunanmu. Setelah itu, keturunanmu akan meninggalkan negeri itu dengan membawa banyak harta benda. ");
INSERT INTO ind_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kamu sendiri akan meninggal dengan tenang ketika usiamu sudah sangat tua, lalu kamu dikuburkan. ");
INSERT INTO ind_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Setelah 400 tahun diperbudak, keturunanmu akan kembali ke negeri ini, lalu merebut negeri ini dari bangsa Amori. Sekarang kejahatan bangsa Amori belum melampaui batas untuk dihukum.” ");
INSERT INTO ind_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Setelah matahari terbenam dan langit menjadi gelap, tiba-tiba muncullah obor yang menyala dengan sebuah tempayan berisi arang berasap melintas di antara kedua baris potongan daging dan kedua burung tadi. ");
INSERT INTO ind_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Saat itu juga, TUHAN mengadakan perjanjian dengan Abram, kata-Nya, “Kepada keturunanmu akan Aku berikan seluruh negeri ini, mulai dari perbatasan Mesir di selatan sampai ke sungai Efrat di utara, ");
INSERT INTO ind_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","yaitu wilayah bangsa Keni, Kenas, Kadmon, Het, Feris, Refaim, Amori, Kanaan, Girgasi, dan Yebus.” ");
INSERT INTO ind_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Hingga saat itu, Sarai belum juga memberikan keturunan bagi Abram. Namun, karena dia memiliki seorang budak perempuan dari Mesir bernama Hagar, ");
INSERT INTO ind_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","berkatalah Sarai kepada Abram, “Sampai sekarang TUHAN belum mengizinkan aku mengandung. Kalau kamu setuju, aku akan memberikan budakku Hagar kepadamu. Barangkali dia bisa hamil dan memberikan keturunan yang diperhitungkan sebagai anak yang aku lahirkan.” Abram menyetujui usul Sarai. ");
INSERT INTO ind_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kemudian Sarai menyerahkan Hagar kepada Abram untuk dijadikan istri berstatus budak. Hal ini terjadi sesudah mereka menetap di Kanaan selama sepuluh tahun. ");
INSERT INTO ind_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram bersetubuh dengan Hagar, dan Hagar pun hamil. Ketika Hagar tahu bahwa dirinya hamil, dia menganggap rendah Sarai, majikannya. ");
INSERT INTO ind_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Lalu berkatalah Sarai kepada Abram, “Kamu yang salah dalam hal ini! Aku sudah memberikan budakku kepadamu. Tetapi sejak dia tahu bahwa dia hamil, dia malah meremehkan dan menghinaku! Semua ini salahmu! Biarlah TUHAN yang menghukummu!” ");
INSERT INTO ind_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Jawab Abram kepada Sarai, “Baiklah! Hagar adalah budakmu, dan kamu berkuasa penuh atas dia. Jadi lakukanlah apa pun yang kamu mau terhadapnya!” Maka Sarai mulai memperlakukan Hagar dengan kejam, sehingga Hagar melarikan diri dari Sarai. ");
INSERT INTO ind_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tetapi TUHAN mengutus malaikat untuk menemui Hagar di padang belantara, dekat mata air yang terletak di pinggir jalan menuju ke Syur. ");
INSERT INTO ind_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","TUHAN berbicara melalui malaikat itu kepadanya, “Hagar, budak Sarai, kamu dari mana dan hendak pergi ke mana?” Jawab Hagar, “Saya melarikan diri dari majikan saya, Sarai.” ");
INSERT INTO ind_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","10","Lalu malaikat itu menyampaikan pesan TUHAN, “Kembalilah kepada majikanmu dan lakukanlah apa yang dia perintahkan kepadamu. Aku akan memberikan kepadamu keturunan yang sangat banyak, sehingga tidak seorang pun dapat menghitung mereka! ");
INSERT INTO ind_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Dengarlah! Kamu sedang mengandung dan akan melahirkan anak laki-laki. Namailah dia Ismael, karena TUHAN sudah mendengar ratapanmu. ");
INSERT INTO ind_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Namun, anakmu itu akan suka menentang orang lain bagaikan keledai liar. Dia akan menentang semua orang dan mereka pun akan menolaknya. Dia akan hidup jauh dari sanak saudaranya.” ");
INSERT INTO ind_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Karena malaikat itu menyampaikan pesan TUHAN kepadanya, maka Hagar bertanya dalam hati, “Benarkah aku sudah melihat Allah yang memperhatikanku?” Sejak saat itu, Hagar sering menyebut TUHAN sebagai ‘Dia yang memperhatikan aku’. ");
INSERT INTO ind_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Itulah sebabnya mata air tersebut dinamai Beer Lahai Roi. Sampai kitab ini ditulis, mata air itu masih ada. Letaknya di antara Kades dan Bered. ");
INSERT INTO ind_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Lalu tibalah saatnya Hagar melahirkan seorang bayi laki-laki. Abram menamainya Ismael. Pada waktu itu, Abram berusia delapan puluh enam tahun. ");
INSERT INTO ind_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ketika Abram berumur 99 tahun, TUHAN menampakkan diri lagi kepadanya dan berkata, “Akulah Allah Yang Mahakuasa. Taatilah Aku dengan setia dan hiduplah dengan tidak bercela. ");
INSERT INTO ind_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jika kamu melakukan itu, Aku akan meneguhkan perjanjian yang sudah Aku buat dengan kamu, dan Aku akan memberimu banyak keturunan.” ");
INSERT INTO ind_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lalu Abram bersujud, dan Allah berkata kepadanya, ");
INSERT INTO ind_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Aku berjanji bahwa kamu akan menjadi bapak dari banyak bangsa. ");
INSERT INTO ind_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Oleh karena itu, namamu bukan lagi Abram, melainkan Abraham, sebab Aku sudah menetapkanmu sebagai bapak atas banyak bangsa. ");
INSERT INTO ind_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aku akan memberikan anak cucu yang banyak kepadamu dan membuat mereka menjadi bangsa-bangsa. Di antara mereka, akan ada yang menjadi raja-raja. ");
INSERT INTO ind_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Aku akan meneguhkan perjanjian-Ku denganmu. Aku juga akan meneruskan perjanjian itu kepada anak cucumu turun-temurun sampai selama-lamanya. Aku akan menjadi Allahmu dan Allah keturunanmu. ");
INSERT INTO ind_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Aku akan memberikan tanah ini kepadamu dan kepada keturunanmu, yaitu seluruh negeri Kanaan yang sekarang kamu diami sebagai pendatang. Semua itu akan menjadi milik anak cucumu untuk selama-lamanya. Aku akan menjadi Allah mereka.” ");
INSERT INTO ind_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Lalu TUHAN berkata kepada Abraham, “Sebagai tanda bahwa kamu dan anak cucumu turun-temurun setuju untuk mematuhi segala ketentuan dalam perjanjian dengan-Ku, kalian harus memenuhi syarat ini: Setiap laki-laki di antara keturunanmu harus disunat. ");
INSERT INTO ind_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Mulai sekarang, ketetapan-Ku ini akan berlaku secara turun-temurun. Setiap anak laki-laki dalam keluargamu harus disunat ketika berumur delapan hari. Begitu pula dengan para budakmu laki-laki, baik yang lahir di rumahmu maupun yang kamu beli dari orang lain. Sunat itu akan menjadi tanda bahwa kalian masing-masing sudah berjanji untuk menaati perjanjian antara Aku dan kalian. ");
INSERT INTO ind_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Baik anak yang lahir dari anggota keluargamu sendiri, maupun budak yang kamu beli, semua bayi laki-laki harus disunat. Sunat itu merupakan tanda pengingat bagi kalian masing-masing bahwa kalian sepakat untuk mengikuti segala syarat dalam perjanjian-Ku, yang terus berlaku sampai selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Setiap laki-laki yang tidak disunat akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.” ");
INSERT INTO ind_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kemudian TUHAN berkata lagi kepada Abraham, “Mengenai istrimu Sarai, janganlah kamu memanggilnya Sarai lagi, karena sekarang Aku mengubah namanya menjadi Sara. ");
INSERT INTO ind_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aku akan memberkatinya sehingga dia akan melahirkan seorang anak laki-laki bagimu. Sara akan menjadi ibu bangsa-bangsa. Di antara keturunannya akan ada yang menjadi raja-raja.” ");
INSERT INTO ind_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Lalu bersujudlah Abraham, tetapi dia tertawa ketika berpikir, “Mungkinkah aku, yang sudah berumur 100 tahun ini, akan punya anak?! Lagipula Sara sudah 90 puluh tahun!” ");
INSERT INTO ind_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Dia berkata kepada Allah, “Oh TUHAN, biarlah Ismael saja yang menjadi ahli warisku.” ");
INSERT INTO ind_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tetapi jawab Allah, “Tidak! Sara akan melahirkan seorang anak laki-laki bagimu. Namailah dia Isak. Aku akan mewariskan perjanjian-Ku itu kepadanya dan kepada keturunannya sampai selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mengenai permintaanmu untuk Ismael, Aku sudah mengabulkannya. Aku akan memberkatinya sehingga dia juga memiliki keturunan yang banyak. Aku akan membuat keturunannya menjadi bangsa yang besar, dan dua belas dari keturunannya akan menjadi raja atas dua belas bangsa. ");
INSERT INTO ind_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tetapi Aku akan meneguhkan perjanjian-Ku yang resmi itu dengan Isak. Sara akan melahirkan dia satu tahun dari sekarang.” ");
INSERT INTO ind_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sesudah Allah selesai berbicara kepada Abraham, Dia meninggalkannya. ");
INSERT INTO ind_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hari itu juga, Abraham menyunat Ismael. Semua laki-laki di rumahnya— termasuk anak-anak laki-laki dari para budak yang sudah dibelinya— juga disunat. Dia melakukan tepat seperti yang sudah diperintahkan Allah kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham berumur 99 tahun ketika dia disunat, ");
INSERT INTO ind_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","dan Ismael berumur 13 tahun ketika Abraham menyunat dia. ");
INSERT INTO ind_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Semua laki-laki dalam keluarga Abraham— baik yang lahir di rumahnya maupun yang dibeli dari orang asing— disunat bersama-sama dengannya pada hari yang sama. ");
INSERT INTO ind_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Pada suatu siang, waktu Abraham sedang duduk di pintu kemahnya dekat pohon yang dianggap keramat milik Mamre, sekali lagi TUHAN menampakkan diri kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Saat itu, ketika Abraham memandang ke depan, dia melihat tiga orang laki-laki sedang berdiri tidak jauh dari kemahnya. Abraham pun berlari menyambut orang-orang itu dan bersujud untuk menghormati mereka. ");
INSERT INTO ind_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Dia berkata kepada salah satu dari orang-orang itu, yang kelihatannya seperti pemimpin mereka, “Tuan, jika tidak keberatan, mampirlah di sini. ");
INSERT INTO ind_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Biarlah saya mengambilkan air untuk mencuci kaki kalian. Sesudah itu beristirahatlah di bawah pohon ini. ");
INSERT INTO ind_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Karena Tuan-tuan sudah datang ke sini, izinkan hamba melayani kalian dengan membawa sedikit makanan, supaya tenaga kalian pulih kembali sebelum melanjutkan perjalanan.” Jawab mereka, “Baiklah, lakukan seperti yang kamu katakan itu.” ");
INSERT INTO ind_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham segera masuk ke kemahnya dan berkata kepada Sara, “Cepat, ambillah sekarung tepung yang terbaik dan buatlah roti!” ");
INSERT INTO ind_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kemudian dia berlari ke tempat kawanan ternaknya dan mengambil seekor anak sapi terbaik yang dagingnya empuk. Diserahkannya hewan itu kepada salah seorang budak laki-lakinya untuk segera diolah. ");
INSERT INTO ind_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Sesudah itu, Abraham mengambil dua macam susu dan daging yang sudah dimasak tadi, lalu menghidangkan semua itu di depan para tamunya. Selama mereka menikmati makanan, Abraham berdiri dekat mereka di bawah pohon itu. ");
INSERT INTO ind_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kemudian mereka bertanya kepadanya, “Di mana Sara, istrimu?” Jawab Abraham, “Dia ada di sana, di dalam kemah.” ");
INSERT INTO ind_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Orang yang kelihatannya seperti pemimpin di antara mereka bertiga itu berkata, “Aku akan kembali satu tahun dari sekarang. Pada waktu itu, Sara sudah memiliki seorang anak laki-laki!” Sara sedang berada di pintu kemah, di belakang orang yang sedang berbicara itu. Dia mendengar pembicaraan mereka. ");
INSERT INTO ind_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham dan Sara sudah sangat tua, dan Sara sudah tidak haid lagi. Berarti dia sudah tidak bisa hamil. ");
INSERT INTO ind_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Karena itu, Sara tertawa dalam hati dan berpikir, “Aku sudah lanjut usia, suamiku juga sudah sangat tua. Bagaimana mungkin aku bisa mengalami berkat semacam itu!” ");
INSERT INTO ind_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kemudian, orang yang kelihatannya seperti pemimpin di antara tiga orang itu— yang ternyata adalah TUHAN— berkata kepada Abraham, “Mengapa Sara tertawa dan berpikir bahwa dia sudah terlalu tua untuk bisa mengandung? ");
INSERT INTO ind_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Akulah TUHAN! Tidak ada yang mustahil bagi-Ku. Satu tahun dari sekarang, Aku akan kembali, dan saat itu Sara sudah memiliki seorang anak!” ");
INSERT INTO ind_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mendengar itu, Sara menjadi takut dan membantah, “Aku tidak tertawa.” Tetapi TUHAN berkata, “Tidak usah menyangkal! Tadi kamu memang tertawa.” ");
INSERT INTO ind_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Lalu ketiga orang itu pergi, dan Abraham ikut mengantar mereka. Ketika mereka memandang ke bawah, ke arah kota Sodom, ");
INSERT INTO ind_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","berkatalah TUHAN dalam hati-Nya, “Aku tidak mau menyembunyikan dari Abraham apa yang akan Aku lakukan, ");
INSERT INTO ind_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","karena keturunannya akan menjadi bangsa yang besar dan berkuasa. Lagipula, melalui dialah Aku akan memberkati semua bangsa. ");
INSERT INTO ind_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Aku sudah memilihnya supaya dia menyuruh anak-anak dan keturunannya untuk taat kepada-Ku dan melakukan semua yang baik dan adil. Dan Aku akan menepati semua janji-Ku kepadanya.” ");
INSERT INTO ind_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Maka TUHAN berkata kepada Abraham, “Aku sudah banyak mendengar keluhan atas perbuatan-perbuatan jahat yang terus dilakukan orang-orang Sodom dan Gomora. Dosa-dosa mereka sudah melampaui batas. ");
INSERT INTO ind_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Karena itu, sekarang Aku akan turun ke sana untuk melihat apakah keluhan-keluhan tentang segala kejahatan mereka itu benar atau tidak.” ");
INSERT INTO ind_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Lalu dua orang lainnya berangkat menuju kota Sodom, sedangkan Abraham dan TUHAN masih berdiri di tempat itu saling berhadapan. ");
INSERT INTO ind_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham mendekati TUHAN dan berkata, “Apakah Engkau akan membinasakan orang-orang baik bersama dengan orang-orang jahat? ");
INSERT INTO ind_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Seandainya ada lima puluh orang baik di kota itu, apakah Engkau tetap akan membinasakan semua orang di kota itu? Tidakkah Engkau akan mengampuni semua orang di kota itu karena kelima puluh orang baik yang ada? ");
INSERT INTO ind_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tentu tidak baik bagi-Mu untuk membinasakan orang baik bersama dengan orang jahat, atau memperlakukan orang baik seperti orang jahat. Tentu Engkau tidak akan melakukan itu, karena Engkau adalah hakim atas semua orang di bumi. Engkau pasti menghakimi dengan adil!” ");
INSERT INTO ind_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","TUHAN berkata, “Jika Aku menemukan lima puluh orang baik di Sodom, Aku akan mengampuni semua orang di kota itu karena mereka.” ");
INSERT INTO ind_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kemudian Abraham berkata, “Maaf kalau aku memberanikan diri untuk berbicara lebih lanjut, ya Penguasaku. Sesungguhnya, aku hanya manusia, dan tidak berhak berbicara langsung dengan Engkau seperti ini. ");
INSERT INTO ind_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tetapi, bagaimana jika hanya ada empat puluh lima orang baik, dan bukan lima puluh? Apakah Engkau akan membinasakan seluruh kota itu karena selisih lima orang saja?” Jawab TUHAN, “Aku tidak akan membinasakannya jika Aku mendapati empat puluh lima orang baik di situ.” ");
INSERT INTO ind_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham berkata lagi, “Bagaimana kalau hanya ada empat puluh orang?” Jawab TUHAN, “Aku tidak akan membinasakannya karena keempat puluh orang baik itu.” ");
INSERT INTO ind_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kemudian Abraham berkata lagi, “Penguasaku, mohon jangan marah apabila saya berbicara lagi. Bagaimana jika hanya ada tiga puluh orang baik?” Jawab TUHAN, “Aku tidak akan membinasakannya jika Aku mendapati tiga puluh orang baik di situ.” ");
INSERT INTO ind_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham berkata lagi, “Sekali lagi mohon maaf, Penguasaku, apabila aku terus berbicara. Bagaimana seandainya hanya ada dua puluh orang?” Jawab TUHAN, “Aku tidak akan membinasakan kota itu karena dua puluh orang baik itu.” ");
INSERT INTO ind_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kata Abraham lagi, “Penguasaku, mohon jangan marah apabila aku berbicara sekali lagi. Bagaimana jika hanya ada sepuluh orang baik di situ?” Jawab TUHAN, “Aku tidak akan membinasakannya karena kesepuluh orang baik itu.” ");
INSERT INTO ind_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Demikianlah TUHAN mengakhiri pembicaraan mereka dan pergi, lalu Abraham kembali ke kemahnya. ");
INSERT INTO ind_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ketika hari petang, kedua orang tadi— yang ternyata adalah malaikat— tiba di kota Sodom. Saat itu, Lot sedang duduk di pintu gerbang kota. Melihat mereka, dia bangkit menyambut dan bersujud untuk menghormati mereka. ");
INSERT INTO ind_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kata Lot kepada dua orang itu, “Tuan-tuan, silakan menginap di rumah saya malam ini. Kalian bisa mencuci kaki, dan besok kalian dapat melanjutkan perjalanan.” Jawab mereka, “Tidak. Kami akan bermalam di luar saja, di alun-alun kota.” ");
INSERT INTO ind_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tetapi Lot terus mendesak mereka supaya mau menginap di rumahnya. Akhirnya mereka pun masuk ke rumah Lot, dan Lot menyiapkan makanan untuk mereka. Dia memanggang roti tanpa ragi, lalu mereka memakannya. ");
INSERT INTO ind_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sebelum mereka pergi tidur, semua laki-laki dari seluruh penjuru kota Sodom, tua maupun muda, datang mengepung rumah Lot. ");
INSERT INTO ind_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mereka berteriak-teriak kepada Lot, “Di mana kedua orang yang menginap di rumahmu malam ini? Bawa mereka keluar, supaya kami bisa bersetubuh dengan mereka!” ");
INSERT INTO ind_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kemudian Lot keluar dari dalam rumah dan menutup pintu di belakangnya supaya mereka tidak bisa masuk. ");
INSERT INTO ind_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Katanya kepada mereka, “Saudara-saudaraku, janganlah berbuat jahat seperti itu! ");
INSERT INTO ind_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mohon dengarkan saya! Saya punya dua anak perempuan yang masih perawan. Biarlah saya membawa mereka keluar untuk kalian sekarang, dan kalian boleh melakukan apa saja yang kalian mau kepada mereka. Tetapi jangan lakukan apa pun terhadap kedua laki-laki itu. Mereka adalah tamu di rumah saya, maka saya harus melindungi mereka!” ");
INSERT INTO ind_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tetapi orang-orang itu menjawab, “Berani-beraninya kamu mengatur kami! Kamu hanya pendatang di sini. Menyingkirlah dari situ! Kalau tidak, kami akan melakukan yang lebih buruk kepadamu daripada yang akan kami lakukan terhadap kedua orang itu!” Kemudian mereka menyerbu ke arah Lot hendak mendobrak pintu. ");
INSERT INTO ind_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tetapi kedua malaikat itu membuka pintu dengan cepat dan menarik Lot masuk ke rumah, lalu langsung menutup pintu itu kembali. ");
INSERT INTO ind_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dua malaikat itu membuat semua orang yang berdiri di luar menjadi buta, baik yang tua maupun yang muda, sehingga mereka tidak dapat menemukan pintunya. ");
INSERT INTO ind_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Lalu malaikat-malaikat itu berkata kepada Lot, “Siapa lagi keluargamu yang tinggal di kota ini? Kalau kamu memiliki anak laki-laki, anak perempuan, menantu, ataupun sanak saudara lainnya, bawalah mereka keluar dari kota ini! ");
INSERT INTO ind_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kami diutus TUHAN untuk menghancurkan tempat ini, karena berdasarkan keluhan-keluhan yang didengar TUHAN, penduduk kota ini sudah jahat sekali.” ");
INSERT INTO ind_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Maka pergilah Lot menemui kedua calon menantunya dan berkata, “Cepat! Keluar dari kota ini, karena TUHAN akan segera menghancurkannya!” Namun, mereka menganggap Lot sedang bercanda. ");
INSERT INTO ind_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Menjelang fajar, kedua malaikat itu mendesak Lot agar bergegas, “Cepatlah! Bawa istrimu dan kedua anak gadismu pergi dari sini! Kalau tidak, kalian akan ikut mati waktu kami menghancurkan kota ini!” ");
INSERT INTO ind_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ketika Lot belum bergerak juga, kedua malaikat itu langsung memegang tangannya dan tangan istrinya serta kedua anak gadisnya, lalu menarik mereka keluar dari kota itu dengan aman. Para malaikat melakukan itu karena TUHAN berbelas kasih kepada Lot dan keluarganya. ");
INSERT INTO ind_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sesampainya mereka di luar kota, salah satu malaikat itu berkata, “Larilah untuk menyelamatkan nyawamu! Jangan menoleh ke belakang! Jangan berhenti di lembah! Larilah ke daerah perbukitan supaya kalian tidak mati!” ");
INSERT INTO ind_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tetapi kata Lot kepada mereka, “Aduh, jangan begitu, Tuan-tuanku! ");
INSERT INTO ind_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tuan sudah sangat berbaik hati dengan menyelamatkan nyawa saya. Tetapi daerah perbukitan itu terlalu jauh! Kalau saya berusaha lari ke sana, saya akan mati sebelum sampai. ");
INSERT INTO ind_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tetapi lihat, di sebelah situ ada kampung yang cukup dekat dari sini. Izinkanlah kami pergi ke kampung kecil itu supaya kami selamat.” ");
INSERT INTO ind_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Salah satu malaikat itu berkata, “Baiklah, saya mengabulkan permintaanmu. Saya tidak akan menghancurkan kampung kecil itu. ");
INSERT INTO ind_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tetapi cepat! Larilah ke sana, karena saya tidak bisa mulai menjatuhkan hukuman sebelum kalian sampai di sana.” Sesudah peristiwa ini, kampung tersebut dinamai Zoar, karena Lot mengatakan bahwa kampung itu kecil. ");
INSERT INTO ind_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot dan keluarganya tiba di kampung yang sekarang dinamai Zoar itu sesudah matahari terbit. ");
INSERT INTO ind_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kemudian TUHAN menjatuhkan api dan belerang ke atas Sodom dan Gomora, seperti hujan dari langit. ");
INSERT INTO ind_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Demikianlah TUHAN menghancurkan kedua kota itu dan semua penduduk di dalamnya. Dia juga menghancurkan segala sesuatu yang ada di lembah itu, termasuk seluruh tumbuhan. ");
INSERT INTO ind_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Namun, istri Lot berhenti di tengah jalan dan menoleh ke belakang, maka dia mati dan menjadi tiang garam. ");
INSERT INTO ind_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Pagi itu, Abraham bangun dan segera pergi ke tempat dia bercakap-cakap dengan TUHAN kemarin. ");
INSERT INTO ind_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Saat memandang ke arah Sodom dan Gomora, dia melihat seluruh lembah itu berasap tebal, seperti asap dari tungku yang sangat besar. ");
INSERT INTO ind_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Jadi, TUHAN mengingat permintaan Abraham ketika Dia memusnahkan kota-kota di lembah itu. Itulah sebabnya Lot diselamatkan dari bencana yang terjadi di sana. ");
INSERT INTO ind_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot takut untuk tinggal di Zoar, maka dia meninggalkan kampung itu dan pindah ke gunung bersama kedua anak gadisnya. Di sana, mereka tinggal di sebuah gua. ");
INSERT INTO ind_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Suatu hari, anak gadis Lot yang sulung berkata kepada adiknya, “Aduh, dengan siapa kita akan menikah di tempat yang sunyi ini! Tidak ada lagi laki-laki. Ayah kita sudah terlalu tua untuk mengurus pernikahan seperti yang dilakukan di daerah-daerah lain. ");
INSERT INTO ind_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Mari kita membuat ayah kita mabuk dengan minum anggur sehingga dia tidak sadar, lalu kita bisa bersetubuh dengannya. Dengan cara inilah kita dapat menyambung keturunan keluarga kita.” ");
INSERT INTO ind_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Malam itu, mereka berhasil membuat Lot mabuk. Lalu anak gadis yang sulung masuk dan bersetubuh dengan ayahnya. Lot tidak tahu apa-apa karena dia sudah terlalu mabuk. ");
INSERT INTO ind_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Keesokan harinya, anak gadis Lot yang sulung itu berkata lagi kepada adiknya, “Tadi malam aku sudah tidur dengan ayah kita! Nanti malam, kita buat dia mabuk lagi. Lalu kamu tidurlah dengannya, supaya kita masing-masing mendapat anak.” ");
INSERT INTO ind_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Maka malam itu mereka membuat Lot mabuk lagi, kemudian anak gadis yang bungsu juga bersetubuh dengan ayahnya. Kali ini pun Lot terlalu mabuk sehingga dia tidak tahu apa yang terjadi. ");
INSERT INTO ind_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Dengan demikian, kedua anak gadis Lot hamil dari ayah mereka. ");
INSERT INTO ind_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kakaknya melahirkan anak laki-laki yang dia namai Moab. Anak ini menjadi nenek moyang dari bangsa Moab. ");
INSERT INTO ind_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Adiknya melahirkan seorang anak laki-laki juga, yang dia namai Ben Ami. Dialah yang menjadi nenek moyang dari bangsa Amon. ");
INSERT INTO ind_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Lalu Abraham pergi dari tanah milik Mamre ke bagian selatan Kanaan, di wilayah Filistin. Dalam perjalanannya, untuk sementara waktu dia tinggal di suatu tempat di antara Kades dan Syur, kemudian pindah ke Gerar. Sewaktu di Gerar, ");
INSERT INTO ind_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham tidak mengakui dengan terus terang kepada orang Gerar bahwa Sara adalah istrinya. Dia berkata, “Sara ini adik saya.” Oleh karena itu, Abimelek, raja Gerar, menyuruh beberapa anak buahnya membawa Sara kepadanya di istana. ");
INSERT INTO ind_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tetapi suatu malam, Allah memperlihatkan diri kepada Abimelek melalui mimpi dan berkata, “Dengarlah! Aku akan menjatuhkan hukuman mati atasmu karena perempuan yang kamu ambil itu sudah bersuami.” ");
INSERT INTO ind_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek belum bersetubuh dengan Sara, maka dia berkata, “Ya Penguasaku, aku dan bangsaku tidak bersalah sama sekali! Apakah Engkau akan tetap membinasakan bangsa yang tidak bersalah? ");
INSERT INTO ind_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham sendiri yang mengatakan bahwa perempuan itu adiknya, dan perempuan itu juga mengaku demikian. Jadi, aku melakukan semua ini tanpa niat jahat dan tidak bersalah!” ");
INSERT INTO ind_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kemudian dalam mimpi itu Allah berkata kepadanya, “Aku tahu bahwa kamu melakukannya tanpa maksud jahat. Itulah sebabnya Aku mencegah kamu menyentuh perempuan itu, supaya kamu tidak berdosa terhadap Aku. ");
INSERT INTO ind_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Maka sekarang, kembalikanlah dia kepada Abraham, karena Abraham adalah nabi dan dia akan berdoa untukmu supaya kamu tetap hidup. Bila kamu tidak mengembalikan perempuan itu, ketahuilah, kamu dan seluruh rakyatmu akan mati!” ");
INSERT INTO ind_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Besok paginya, Abimelek memanggil semua pejabat kerajaannya dan memberitahu mereka tentang segala hal yang sudah terjadi. Mendengar itu, mereka sangat ketakutan. ");
INSERT INTO ind_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Lalu Abimelek memanggil Abraham dan berkata kepadanya, “Kamu sudah membohongiku! Apa salahku kepadamu sehingga kamu mendatangkan musibah besar bagiku dan bagi rakyatku?! Sungguh tidak pantas kamu berbuat demikian! ");
INSERT INTO ind_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Apa yang membuat kamu melakukan itu?” ");
INSERT INTO ind_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Jawab Abraham, “Saya berbuat demikian karena berpikir, ‘Tidak ada orang yang menghormati Allah di tempat ini. Kalau saya mengatakan bahwa dia istri saya, pasti ada orang yang membunuh saya demi mendapatkan dia.’ ");
INSERT INTO ind_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Lagipula, dia memang adik tiri saya. Kami satu ayah tetapi beda ibu, kemudian saya menikahi dia. ");
INSERT INTO ind_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ketika Allah menyuruh saya meninggalkan rumah ayah saya untuk merantau ke negeri lain, saya berkata kepada Sara, ‘Tunjukkanlah kesetiaanmu kepadaku ke mana saja kita pergi, dengan mengatakan kepada siapa pun bahwa aku adalah kakakmu.’” ");
INSERT INTO ind_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Sesudah itu, Abimelek mengembalikan Sara kepada Abraham. Dia juga memberikan beberapa ekor domba dan sapi, serta beberapa orang budak laki-laki dan budak perempuan. ");
INSERT INTO ind_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Katanya kepada Abraham, “Silakan pilih daerah mana saja yang kamu suka dari seluruh kerajaanku untuk kamu tempati.” ");
INSERT INTO ind_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kemudian dia berkata kepada Sara, “Lihatlah, aku sudah memberikan 11 kilogram perak kepada kakakmu. Itu adalah denda yang harus aku bayar untuk menutupi semua kesalahan ini di mata semua orang dan untuk menjaga nama baikmu.” ");
INSERT INTO ind_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Karena kejadian itu, TUHAN sudah membuat semua perempuan di istana Abimelek mandul. Namun, ketika Abraham berdoa, Allah menyembuhkan Abimelek, istrinya, dan budak-budak perempuannya, sehingga mereka bisa hamil lagi. ");
INSERT INTO ind_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TUHAN memberkati Sara dan memenuhi janji-Nya sebagaimana yang sudah dikatakan-Nya. ");
INSERT INTO ind_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Maka Sara mengandung dan melahirkan seorang anak laki-laki bagi Abraham, tepat pada waktu yang sudah dijanjikan Allah kepadanya. Pada waktu itu, Abraham sudah sangat tua. ");
INSERT INTO ind_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Lalu Abraham menamai anak itu Isak. ");
INSERT INTO ind_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sesudah Isak berumur satu minggu, Abraham menyunat dia sebagaimana yang sudah diperintahkan Allah kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham berumur 100 tahun ketika Isak lahir. ");
INSERT INTO ind_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Berkatalah Sara, “Karena apa yang sudah Allah perbuat bagiku, aku tertawa! Dan setiap orang yang mendengar kejadian ini akan turut bergembira dan tertawa! ");
INSERT INTO ind_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tidak ada seorang pun yang mengira bahwa aku akan melahirkan anak bagi Abraham. Tetapi sekarang, aku sudah melahirkan seorang anak bagi dia di usia tuanya.” ");
INSERT INTO ind_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isak pun bertambah besar. Ketika umurnya sudah beberapa tahun, tibalah waktunya dia dipisahkan dari susu ibunya. Pada hari itu, Abraham mengadakan pesta besar untuk merayakannya. ");
INSERT INTO ind_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lalu Sara melihat anak Hagar, Ismael, sedang mengolok-olok Isak. ");
INSERT INTO ind_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Karena itu, Sara berkata kepada Abraham, “Usirlah perempuan Mesir itu beserta anaknya! Anak budak itu tidak boleh menjadi ahli waris bersama dengan Isak anakku!” ");
INSERT INTO ind_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hal itu membuat Abraham sedih, karena biar bagaimana pun, Ismael adalah anaknya juga. ");
INSERT INTO ind_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tetapi Allah berkata kepada Abraham, “Jangan bersedih karena Ismael dan Hagar. Perbuatlah sesuai perkataan Sara, karena melalui Isaklah Aku akan memberikan keturunan yang sudah Aku janjikan. ");
INSERT INTO ind_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Meski demikian, Aku juga akan membuat anak budakmu itu menjadi nenek moyang suatu bangsa yang besar, karena dia pun anakmu.” ");
INSERT INTO ind_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Besoknya, Abraham bangun pagi-pagi, lalu mengambil makanan dan kantong kulit besar tempat air minum. Dia meletakkan semuanya itu di atas bahu Hagar, dan menyuruh dia pergi bersama anaknya. Maka pergilah Hagar dan Ismael mengembara di padang belantara dekat Bersyeba. ");
INSERT INTO ind_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sesudah air minum di dalam kantong kulit itu habis, Hagar meninggalkan anaknya di bawah pohon kecil. ");
INSERT INTO ind_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kemudian dia menjauh sekitar 100 meter dari tempat itu, karena katanya dalam hati, “Aku tidak sanggup melihat anakku mati.” Hagar duduk di sana dan menangis tersedu-sedu. ");
INSERT INTO ind_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Berkatalah malaikat dari surga kepada Hagar, “Jangan menangis, Hagar! Jangan takut, karena Allah sudah mendengar tangisan anakmu. ");
INSERT INTO ind_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Bangunlah! Bantu anakmu itu berdiri dan tuntunlah dia berjalan. Aku sudah berjanji bahwa Ismael akan menjadi nenek moyang dari bangsa yang besar.” ");
INSERT INTO ind_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kemudian Allah membuat Hagar melihat sebuah mata air yang tidak jauh dari tempat itu. Maka pergilah dia mengisi kantong kulitnya dengan air dan memberi anaknya minum. ");
INSERT INTO ind_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah menyertai anak itu. Dia bertumbuh dewasa dan tinggal di padang belantara Paran. Ismael menjadi seorang pemanah yang sangat terlatih. ");
INSERT INTO ind_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Hagar memilih seorang perempuan Mesir menjadi istri bagi anaknya itu. ");
INSERT INTO ind_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pada waktu itu, Raja Abimelek beserta panglima tentaranya yang bernama Pikol datang kepada Abraham dan berkata, “Kami sudah melihat bahwa Allah selalu memberkati segala usahamu. ");
INSERT INTO ind_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Oleh karena itu, mari kita membuat perjanjian di hadapan Allah, bahwa engkau dan semua keturunanmu akan selalu bertindak jujur kepada saya dan seluruh keturunan saya nanti. Sebagaimana saya sudah berbuat baik kepada Tuan, hendaklah Tuan juga berjanji untuk berbuat baik kepada saya dan semua orang di negeri yang Tuan diami ini.” ");
INSERT INTO ind_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Jawab Abraham, “Baik, saya berjanji!” ");
INSERT INTO ind_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sebelumnya, para budak Abimelek pernah merampas sebuah sumur yang digali oleh para budak Abraham. Jadi, Abraham mengungkapkan kekecewaannya kepada Abimelek atas kejadian itu. ");
INSERT INTO ind_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kata Abimelek, “Saya tidak tahu siapa yang sudah melakukan itu. Tuan belum pernah memberitahu saya, dan saya baru mengetahuinya hari ini.” ");
INSERT INTO ind_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kemudian Abraham memberikan beberapa ekor domba dan sapi kepada Abimelek. Lalu mereka berdua mengadakan perjanjian. ");
INSERT INTO ind_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Setelah itu, Abraham memisahkan tujuh ekor anak domba betina dari kawanan ternaknya. ");
INSERT INTO ind_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek bertanya kepadanya, “Untuk apa ketujuh anak domba betina itu?” ");
INSERT INTO ind_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Jawab Abraham, “Terimalah tujuh ekor anak domba betina ini dari saya sebagai tanda bahwa Tuan mengakui kalau sayalah yang menggali sumur ini dan berhak menggunakannya.” ");
INSERT INTO ind_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Itulah sebabnya tempat itu dinamai Bersyeba, karena mereka berdua mengadakan perjanjian di sana. ");
INSERT INTO ind_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Setelah perjanjian di Bersyeba itu selesai dibuat, Abimelek dan Pikol, komandan pasukannya, kembali ke kota mereka di wilayah Filistin. ");
INSERT INTO ind_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Lalu Abraham menanam sebatang pohon tamariska di sana sebagai tanda peringatan, dan di situ dia menyembah TUHAN, Allah yang kekal. ");
INSERT INTO ind_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Sesudah itu, cukup lama Abraham tinggal sebagai pendatang di wilayah Filistin. ");
INSERT INTO ind_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Beberapa waktu kemudian, sesudah semua peristiwa itu berlalu, Allah menguji sejauh mana Abraham taat kepada-Nya. Dia memanggil, “Abraham!” Jawabnya, “Ya, TUHAN, ini aku.” ");
INSERT INTO ind_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allah berkata, “Bawalah Isak, anakmu satu-satunya yang sangat kamu kasihi itu, ke bukit wilayah Moria. Persembahkanlah dia kepada-Ku sebagai kurban yang dibakar habis di atas salah satu bukit yang akan Aku tunjukkan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Besoknya, Abraham bangun pagi-pagi sekali dan menyiapkan kayu bakar untuk kurban itu. Dia memasang pelana di atas punggung keledai. Lalu dibawanya Isak beserta dua orang budaknya pergi ke tempat yang sudah dikatakan Allah kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pada hari ketiga, Abraham melayangkan pandangannya dan melihat tempat itu. ");
INSERT INTO ind_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Dia pun berkata kepada kedua budaknya, “Tinggallah di sini bersama keledai ini. Saya dan Isak akan pergi ke sana untuk menyembah TUHAN. Sesudah itu, kami akan kembali kepada kalian.” ");
INSERT INTO ind_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham menaruh kayu bakar di atas pundak Isak, sedangkan dia sendiri membawa pisau dan api. Lalu keduanya pergi bersama-sama. ");
INSERT INTO ind_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak berkata kepada bapaknya, “Ayah!” Jawab Abraham, “Ya, anakku.” Lanjut Isak, “Kayu bakar dan api sudah ada, tetapi di mana anak domba untuk dikurbankan?” ");
INSERT INTO ind_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Jawab Abraham, “Anakku, Allah sendiri yang akan menyediakan anak domba yang diperlukan untuk kurban itu.” Lalu keduanya meneruskan perjalanan. ");
INSERT INTO ind_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sesampainya mereka di tempat yang dikatakan Allah, Abraham mendirikan sebuah mezbah di situ dan menyusun kayu bakar di atasnya. Lalu dia mengikat anaknya dan membaringkan dia di mezbah, di atas kayu bakar. ");
INSERT INTO ind_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham mengambil pisau, hendak mengurbankan anaknya. ");
INSERT INTO ind_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tetapi tiba-tiba TUHAN berseru dari surga melalui malaikat-Nya, “Abraham, Abraham!” Lalu jawabnya, “Ya TUHAN, ini aku!” ");
INSERT INTO ind_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Dia berkata kepada Abraham, “Jangan lakukan apa pun terhadap anakmu itu! Sekarang Aku tahu bahwa kamu percaya penuh dan taat kepada-Ku, karena kamu tidak segan-segan menyerahkan anakmu satu-satunya yang sangat kamu kasihi itu kepada-Ku.” ");
INSERT INTO ind_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ketika Abraham menoleh ke belakang, dia melihat seekor domba jantan yang tersangkut tanduknya pada semak belukar. Dia mengambil domba jantan itu, menyembelihnya, dan mempersembahkannya kepada TUHAN sebagai kurban yang dibakar habis. Jadi, domba itulah yang disembelih menggantikan Isak. ");
INSERT INTO ind_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham pun menamai tempat itu ‘TUHAN menyediakan yang diperlukan’. Sampai kitab ini ditulis, nama itu menjadi seperti pepatah, yakni, “Di bukit TUHAN, Dia menyediakan yang diperlukan.” ");
INSERT INTO ind_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kemudian sekali lagi TUHAN berbicara dari surga kepada Abraham melalui malaikat-Nya, ");
INSERT INTO ind_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Karena kamu sudah melakukan hal ini dan tidak menolak untuk menyerahkan anakmu satu-satunya kepada-Ku, maka Aku bersumpah demi diri-Ku sendiri: ");
INSERT INTO ind_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Aku akan memberkatimu berlimpah-limpah dan memberikan banyak keturunan kepadamu, seperti banyaknya bintang di langit dan pasir di tepi laut. Keturunanmu akan menang atas segala musuhnya. ");
INSERT INTO ind_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Melalui keturunanmulah Aku akan memberkati segala bangsa di bumi, karena kamu sudah menaati perintah-Ku.” ");
INSERT INTO ind_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Sesudah itu, Abraham dan Isak kembali kepada kedua budak tadi, lalu mereka bersama-sama pulang ke Bersyeba. Abraham dan keluarganya menetap di sana. ");
INSERT INTO ind_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Abraham mempunyai saudara bernama Nahor. Setelah semua peristiwa itu, sampailah kabar kepada Abraham bahwa Milka, istri Nahor, sudah memiliki delapan anak laki-laki. ");
INSERT INTO ind_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Anak sulung bernama Us, anak kedua Bus, dan anak ketiga Kemuel, yang kemudian menjadi bapak dari Aram. ");
INSERT INTO ind_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","23","Anak-anak berikutnya adalah Kesed, Hazo, Pildas, Yidlaf, dan Betuel, yang kemudian memiliki anak perempuan bernama Ribka. Itulah delapan anak laki-laki yang dilahirkan Milka bagi Nahor. ");
INSERT INTO ind_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor juga mempunyai budak perempuan yang dia jadikan istri keduanya, yaitu Reuma. Dia memberikan empat anak laki-laki bagi Nahor, yakni Tebah, Gaham, Tahas, dan Maaka. ");
INSERT INTO ind_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara meninggal dunia pada usia 127 tahun di kota Kiryat Arba, yang sekarang disebut Hebron, di negeri Kanaan. Abraham berkabung dan menangisi kematian istrinya. ");
INSERT INTO ind_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Sesudah itu, Abraham meninggalkan jenazah istrinya dan pergi menemui orang-orang Het, penduduk asli negeri itu, lalu berkata kepada mereka, ");
INSERT INTO ind_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Saya hanyalah pendatang yang tinggal di antara kalian. Izinkanlah saya membeli sebidang tanah dari kalian untuk menguburkan jenazah istri saya.” ");
INSERT INTO ind_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Jawab mereka kepadanya, ");
INSERT INTO ind_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tuan, kami sudah menganggap engkau sebagai seorang penguasa yang hebat di antara kami. Silakan memilih tempat kuburan terbaik yang kami miliki, dan kuburkanlah istri Tuan di situ. Kami semua bersedia memberikan tempat mana pun yang Tuan mau secara cuma-cuma.” ");
INSERT INTO ind_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Maka Abraham bersujud untuk berterima kasih kepada mereka ");
INSERT INTO ind_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","dan berkata, “Kalau begitu, tolong Saudara-saudara berbicara kepada Efron anak Zohar, ");
INSERT INTO ind_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","supaya dia menjual gua yang terletak di pinggir ladangnya di Makpela. Saya bersedia membayar sesuai harga jualnya, supaya gua itu menjadi milik saya. Dan biarlah kalian menjadi saksi atas pembelian itu.” ");
INSERT INTO ind_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kebetulan, Efron sedang duduk di antara orang-orang Het yang hadir di tempat pertemuan dekat pintu gerbang kota. Lalu di hadapan semua orang yang ada di situ, dia menjawab, ");
INSERT INTO ind_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Tidak usah, Tuan! Biarlah saudara sebangsaku sendiri, yakni semua orang Het yang ada di sini, menjadi saksi di antara kita berdua bahwa ladang beserta gua yang ada di dalamnya, di Makpela itu, saya berikan kepada Tuan dengan cuma-cuma! Silakan mengubur istri Tuan di sana.” ");
INSERT INTO ind_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham kembali bersujud di hadapan orang-orang Het itu. ");
INSERT INTO ind_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Kemudian, dengan didengar oleh semua orang yang ada di situ, dia berkata kepada Efron, “Mohon dengarkan saya! Saya ingin membeli ladang itu darimu sesuai harga jualnya. Terimalah tawaran ini supaya istri saya bisa dikuburkan di sana.” ");
INSERT INTO ind_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Jawab Efron kepada Abraham, ");
INSERT INTO ind_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Dengarlah Tuan, harga tanah itu hanya lima kilogram perak. Jumlah uang sekecil itu tidak perlu dipersoalkan. Ambillah ladang itu dan kuburkan istri Tuan di sana.” ");
INSERT INTO ind_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham setuju dengan harga yang disebutkan Efron. Lalu dia menimbang lima kilogram perak untuk diberikan kepada Efron di hadapan semua orang yang hadir di situ. Beratnya sesuai dengan ukuran timbangan yang berlaku pada masa itu. ");
INSERT INTO ind_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Demikianlah ladang Efron yang ada di Makpela, di sebelah timur Hebron, menjadi milik Abraham, termasuk gua di ladang itu beserta semua pohon yang ada di dalamnya. ");
INSERT INTO ind_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Semua orang Het yang hadir dalam pertemuan di pintu gerbang kota itu mengakui bahwa tanah tersebut sudah menjadi milik Abraham. ");
INSERT INTO ind_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Setelah itu, Abraham menguburkan istrinya di dalam gua tersebut, di Makpela. Tempat itu termasuk daerah Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Dengan demikian, ladang dan gua Efron menjadi milik Abraham sebagai tempat pekuburan. ");
INSERT INTO ind_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham sudah sangat tua dan TUHAN sudah memberkati dia dalam segala hal. ");
INSERT INTO ind_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Suatu hari, dia berkata kepada pelayannya yang paling senior, yang bertanggung jawab atas semua harta miliknya. Kata Abraham, “Letakkanlah tanganmu di antara pangkal pahaku. ");
INSERT INTO ind_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Berjanjilah di hadapan TUHAN, Allah penguasa surga, langit, dan bumi, bahwa kamu tidak akan memilih istri bagi anakku Isak dari antara orang Kanaan ini. ");
INSERT INTO ind_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kamu harus pergi ke negeri kelahiranku, kepada sanak saudaraku, dan memilih seorang perempuan dari sana untuk menjadi istri bagi anakku Isak.” ");
INSERT INTO ind_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pelayannya berkata, “Seandainya perempuan itu tidak mau ikut dengan saya ke negeri ini, apakah saya harus membawa kembali anak Tuan ke sana?” ");
INSERT INTO ind_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Jawab Abraham kepadanya, “Tidak! Jangan sekali-kali kamu bawa anakku ke negeri itu! ");
INSERT INTO ind_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TUHAN, Allah Penguasa langit, yang sudah membawa aku dari rumah ayahku dan dari tanah kelahiranku, yang sudah berkata dan bersumpah kepadaku bahwa Dia akan memberikan negeri ini kepada keturunanku, Dialah yang akan mengutus malaikat-Nya untuk menolongmu, supaya kamu dapat menemukan seorang istri bagi anakku. ");
INSERT INTO ind_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Namun, kalau gadis itu tidak mau ikut denganmu, maka kamu bebas dari sumpahmu ini. Yang jelas, janganlah membawa anakku kembali ke sana.” ");
INSERT INTO ind_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lalu pelayan itu meletakkan tangannya di antara pangkal paha Abraham dan bersumpah bahwa dia akan melakukan seperti yang diminta Abraham. ");
INSERT INTO ind_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kemudian pelayan itu dan beberapa budak Abraham lainnya memuat berbagai macam harta ke atas sepuluh ekor unta milik Abraham, lalu pergi ke kota Aram Naharaim, tempat tinggal Nahor, adik Abraham. ");
INSERT INTO ind_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Setibanya di sana, dia menyuruh unta-unta itu duduk di dekat sebuah mata air di luar kota. Saat itu, hari sudah sore dan tiba waktunya perempuan-perempuan di kota itu datang ke sumur untuk menimba air. ");
INSERT INTO ind_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Lalu berdoalah pelayan itu, “Ya TUHAN, Allah tuanku Abraham, mohon tunjukkanlah kasih dan kesetiaan-Mu kepada tuanku Abraham dengan membuat aku berhasil mendapatkan seorang istri bagi anaknya hari ini. ");
INSERT INTO ind_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Sekarang, aku berada di dekat sumur. Sebentar lagi anak-anak perempuan penduduk kota ini akan keluar untuk menimba air. ");
INSERT INTO ind_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Aku mohon, biarlah terjadi seperti ini: Aku akan berkata kepada salah satu dari mereka, ‘Tolong berilah saya minum.’ Kalau dia menjawab, ‘Minumlah, dan saya juga akan mengambilkan air untuk unta-untamu,’ maka kiranya dialah yang Engkau pilih bagi hamba-Mu Isak. Dengan demikian, aku akan mengetahui bahwa Engkau menunjukkan kebaikan hati-Mu kepada tuanku Abraham.” ");
INSERT INTO ind_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sebelum hamba itu selesai berdoa, Ribka, anak Betuel, yaitu cucu Nahor dan Milka, keluar dari kota dengan membawa tempayan di bahunya. ");
INSERT INTO ind_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribka sangat cantik dan masih gadis. Dia turun ke sumur itu dan mengisi tempayannya, lalu naik kembali. ");
INSERT INTO ind_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Pelayan Abraham segera berlari menemuinya dan berkata, “Tolong beri saya sedikit air minum dari tempayanmu.” ");
INSERT INTO ind_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Jawab gadis itu, “Minumlah, Tuan!” Dia cepat-cepat menurunkan tempayannya dan memberikan air kepada pelayan itu. ");
INSERT INTO ind_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kemudian dia berkata lagi, “Biarlah saya menimba air untuk unta-unta Tuan juga, sampai semuanya puas minum.” ");
INSERT INTO ind_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Lalu segeralah dia menuangkan air dari tempayannya itu ke tempat minum unta. Kemudian dia berlari lagi ke sumur untuk menimba air lebih banyak, sehingga semua unta minum sampai puas. ");
INSERT INTO ind_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Pelayan Abraham diam-diam memperhatikan Ribka, sambil bertanya-tanya dalam hatinya apakah perempuan itu yang TUHAN berikan sebagai jawaban doanya. ");
INSERT INTO ind_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sesudah semua unta minum sampai puas, pelayan itu mengambil anting-anting emas untuk hidung yang beratnya enam gram dan dua gelang emas yang masing-masing beratnya kira-kira 110 gram. Dia memberikan semua itu kepada Ribka sebagai hadiah ");
INSERT INTO ind_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","sambil berkata, “Kamu anak siapa? Apakah ada tempat di rumah keluargamu untuk kami bisa menginap?” ");
INSERT INTO ind_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Jawab Ribka kepadanya, “Ayah saya bernama Betuel. Kakek saya Nahor dan nenek saya Milka. ");
INSERT INTO ind_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Di rumah kami ada tempat untuk menginap. Kami juga punya banyak jerami dan makanan bagi unta-unta Tuan.” ");
INSERT INTO ind_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lalu bersujudlah pelayan itu menyembah TUHAN ");
INSERT INTO ind_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","dan berkata, “Terpujilah TUHAN, Allah tuanku Abraham, yang sudah berbaik hati dan setia kepada tuanku! Ternyata Dia memimpin saya langsung kepada sanak saudara tuanku!” ");
INSERT INTO ind_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kemudian Ribka berlari ke rumah ibunya dan menceritakan segala kejadian itu. ");
INSERT INTO ind_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka mempunyai saudara laki-laki bernama Laban. Setelah Laban mendengar penjelasan Ribka tentang kata-kata pelayan Abraham itu, dan karena melihat perhiasan yang ada di hidung dan gelang di lengan adiknya, berlarilah Laban keluar untuk menemui pelayan Abraham yang masih berada di samping unta-untanya, di dekat sumur tadi. ");
INSERT INTO ind_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kata Laban, “Marilah Tuan yang diberkati TUHAN. Janganlah Tuan berdiri di luar saja. Saya sudah menyediakan kamar penginapan bagimu di rumah kami, juga tempat bagi unta-untamu.” ");
INSERT INTO ind_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Pelayan Abraham itu pun masuk ke rumah keluarga Betuel. Para budak Betuel menurunkan beban dari unta-unta itu dan memberi makan semuanya. Mereka juga mengalasi kandang-kandang dengan jerami sebagai tempat tidur bagi unta-unta itu. Para budak Betuel yang lainnya menyediakan air supaya pelayan Abraham dan semua budak yang bersamanya dapat membersihkan kaki mereka. ");
INSERT INTO ind_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ketika makanan sudah dihidangkan, pelayan Abraham tidak mau langsung makan. Dia berkata kepada Betuel dan Laban, “Saya tidak akan makan sebelum menyampaikan tujuan kedatangan saya.” Jawab Laban, “Silakan, sampaikanlah.” ");
INSERT INTO ind_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Maka pelayan itu mulai bercerita, katanya, “Saya ini pelayan Abraham. ");
INSERT INTO ind_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TUHAN sudah memberkati tuanku itu sehingga dia menjadi kaya raya. TUHAN sudah memberinya banyak kambing, domba, sapi, unta, keledai, perak dan emas, serta budak laki-laki dan perempuan. ");
INSERT INTO ind_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","“Sara, istri tuanku itu, pada usianya yang sangat tua sudah melahirkan seorang anak laki-laki bagi tuanku Abraham. Dan sekarang, segala harta milik tuanku sudah diserahkannya kepada anak itu. ");
INSERT INTO ind_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tuanku menyuruh saya bersumpah untuk menaati perintahnya, yaitu, ‘Janganlah kamu mencari istri bagi anakku Isak dari antara orang-orang Kanaan ini. ");
INSERT INTO ind_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kamu harus pergi ke negeri kelahiranku, kepada sanak saudaraku, dan mengambil seorang gadis dari sana untuk menjadi istri bagi anakku.’ ");
INSERT INTO ind_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Lalu saya bertanya kepadanya, ‘Bagaimana kalau perempuan itu tidak mau ikut dengan saya ke negeri ini?’ ");
INSERT INTO ind_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Dia berkata kepada saya, ‘TUHAN, yang selalu aku taati sepanjang hidupku, akan mengutus malaikat-Nya untuk menolongmu dan membuat kamu berhasil menemukan seorang istri bagi anakku Isak dari kaumku sendiri, yaitu dari sanak saudaraku. ");
INSERT INTO ind_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tetapi jika kaumku sendiri tidak mengizinkan perempuan yang kamu temui itu pulang bersamamu ke sini, maka kamu akan lepas dari sumpahmu kepadaku.’ Demikian kata tuan saya. ");
INSERT INTO ind_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ketika saya tiba di sumur tadi, saya berdoa dalam hati, ‘Ya TUHAN, Allah tuanku Abraham, jika Engkau mau, buatlah perjalananku berhasil hari ini. ");
INSERT INTO ind_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Sekarang saya berada di dekat sumur. Ketika seorang gadis datang untuk menimba air, lalu saya memintanya memberi saya minum, ");
INSERT INTO ind_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kalau dia mau memberi, bahkan bersedia mengambilkan air untuk unta-untaku, maka biarlah itu menjadi tanda bahwa dialah perempuan yang sudah TUHAN pilih menjadi istri bagi Isak, anak tuanku.’ ");
INSERT INTO ind_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Selagi saya berdoa demikian dalam hati, datanglah Ribka dengan membawa tempayan air di bahunya. Dia turun ke mata air dan mengambil air. Lalu saya berkata kepadanya, ‘Tolong beri saya minum.’ ");
INSERT INTO ind_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Dengan segera, dia menurunkan tempayan dari bahunya dan berkata, ‘Minumlah. Saya juga akan memberi minum unta-untamu.’ Lalu saya minum, dan dia memberi minum unta-unta itu. ");
INSERT INTO ind_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Saya bertanya, ‘Kamu anak siapa?’ Dia menjawab, ‘Ayah saya bernama Betuel. Kakek saya Nahor dan nenek saya Milka.’ Lalu saya mengenakan anting pada hidungnya dan sepasang gelang pada tangannya. ");
INSERT INTO ind_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Sesudah itu, saya pun bersujud menyembah dan memuji TUHAN, Allah tuanku Abraham, sebab Dia sudah membawa saya langsung kepada sanak saudara tuanku, sehingga saya dapat menemukan gadis ini bagi anaknya. ");
INSERT INTO ind_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Jadi, tolong beritahu saya, apakah kalian bersedia menunjukkan kebaikan hati kepada tuanku? Dengan begitu, saya tahu apa yang harus saya lakukan.” ");
INSERT INTO ind_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban dan Betuel berkata kepadanya, “Hal ini jelas datangnya dari TUHAN. Maka kami berdua sudah pasti setuju. ");
INSERT INTO ind_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nah, ini Ribka! Bawalah dia menjadi istri bagi anak tuanmu, sebagaimana yang sudah TUHAN tunjukkan.” ");
INSERT INTO ind_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mendengar perkataan mereka, pelayan Abraham sekali lagi bersujud dan memuji TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kemudian dia mengeluarkan perhiasan emas, perak, dan pakaian indah, lalu memberikannya kepada Ribka. Dia juga memberikan hadiah-hadiah mahal kepada ibu dan saudara laki-laki Ribka. ");
INSERT INTO ind_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Sesudah itu, dia dan para budak yang menyertainya makan dan minum bersama. Malam itu, mereka menginap di sana. Besok paginya, pelayan Abraham berkata, “Izinkanlah kami pulang kepada tuan kami Abraham.” ");
INSERT INTO ind_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tetapi kakak laki-laki dan ibu Ribka berkata, “Biarlah Ribka tinggal bersama kami kira-kira sepuluh hari lagi.” ");
INSERT INTO ind_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Jawabnya kepada mereka, “TUHAN sudah membuat perjalanan saya berhasil. Janganlah membuat saya tinggal lebih lama lagi. Mohon izinkan kami pulang kepada tuanku Abraham.” ");
INSERT INTO ind_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kata mereka kepadanya, “Baik. Kalau begitu kita tanyakan bagaimana pendapat Ribka.” ");
INSERT INTO ind_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Lalu mereka memanggil Ribka dan bertanya kepadanya, “Apakah kamu mau pergi bersama orang ini?” Jawab Ribka, “Ya, aku mau.” ");
INSERT INTO ind_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Maka mereka mengizinkan Ribka beserta hamba perempuan yang sudah mengasuhnya sejak kecil pergi bersama pelayan Abraham dan para budak Abraham itu. ");
INSERT INTO ind_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Sebelum pergi, keluarganya memberkati Ribka dengan berkata, “Adik kami, kiranya TUHAN memberimu beribu-ribu bahkan berjuta-juta anak cucu, dan biarlah mereka menguasai kota-kota musuh mereka.” ");
INSERT INTO ind_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Lalu berangkatlah Ribka beserta para budak perempuannya. Mereka menunggangi unta-unta, lalu berangkat mengikuti pelayan Abraham itu. Demikianlah pelayan Abraham membawa Ribka dan pergi. ");
INSERT INTO ind_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Adapun Isak baru saja kembali ke tempat tinggalnya di bagian selatan Kanaan, dari arah mata air yang bernama Beer Lahai Roi. ");
INSERT INTO ind_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Suatu sore, dia keluar dari perkemahan untuk menyendiri. Sewaktu berjalan-jalan di padang, dia melihat unta-unta datang dari jauh. ");
INSERT INTO ind_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ketika Ribka melihat Isak, dia turun dari untanya ");
INSERT INTO ind_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","dan bertanya kepada pelayan Abraham, “Siapakah pria yang di padang itu, yang sedang berjalan ke arah kita?” Jawab pelayan itu, “Dialah anak tuanku.” Lalu Ribka mengambil kain penutup kepala dan menutupi wajahnya. ");
INSERT INTO ind_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Pelayan itu menceritakan kepada Isak semua yang sudah terjadi. ");
INSERT INTO ind_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Lalu Isak membawa Ribka ke dalam kemah ibunya, Sara, dan mengambil dia menjadi istrinya. Isak sangat mencintai Ribka. Demikianlah hatinya terhibur setelah kematian ibunya. ");
INSERT INTO ind_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham mengambil lagi seorang istri bernama Ketura. ");
INSERT INTO ind_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Dia melahirkan enam anak laki-laki yang diberi nama Zimran, Yoksan, Medan, Midian, Isbak, dan Suah. ");
INSERT INTO ind_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan mempunyai dua anak laki-laki bernama Seba dan Dedan. Keturunan Dedan menjadi bangsa Asyur, bangsa Letus, dan bangsa Leum. ");
INSERT INTO ind_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Anak laki-laki Midian adalah Efa, Efer, Henok, Abida, dan Eldaa. Itulah keturunan Ketura. ");
INSERT INTO ind_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham mewariskan segala kepunyaannya kepada Isak, ");
INSERT INTO ind_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","sedangkan kepada anak-anaknya yang lain, yaitu anak-anak dari para budak perempuan yang dia jadikan istri, dia memberikan hadiah-hadiah berharga. Sesudah itu, Abraham menyuruh mereka pindah ke daerah sebelah timur untuk meninggalkan Isak. ");
INSERT INTO ind_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham menikmati umur panjang selama 175 tahun, lalu mati. Sesudah itu, dia mendapat tempat bersama dengan nenek moyangnya yang sudah meninggal dunia. ");
INSERT INTO ind_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Isak dan Ismael menguburkan ayah mereka di gua yang ada di Makpela, di sebelah timur Hebron, di ladang yang dulu sudah dibeli Abraham dari Efron, anak orang Het bernama Zohar. Abraham dikuburkan di sisi Sara. ");
INSERT INTO ind_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Sesudah itu, Allah memberkati Isak sebagaimana Dia memberkati ayahnya. Isak menetap di dekat sumur Beer Lahai Roi. ");
INSERT INTO ind_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Inilah daftar keturunan Ismael, anak Abraham melalui Hagar, orang Mesir itu, yang adalah budaknya Sara. ");
INSERT INTO ind_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael memiliki dua belas anak laki-laki. Nama-nama mereka adalah Nebayot, Kedar, Adbeel, Mibsam, ");
INSERT INTO ind_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO ind_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, dan Kedma. ");
INSERT INTO ind_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Itulah nama kedua belas anak Ismael. Semuanya menjadi pemimpin suku. Dan setiap kota yang menjadi pusat suku yang dipimpin dinamai sesuai dengan nama mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael hidup selama 137 tahun, lalu meninggal dunia. Kemudian TUHAN menempatkan dia bersama dengan nenek moyangnya yang sudah meninggal. ");
INSERT INTO ind_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Keturunan Ismael tinggal di sebelah timur wilayah keturunan Isak, yaitu di daerah Hawila sampai Syur, ke arah negeri Asyur, di sebelah timur Mesir. Kedua belas suku ini tinggal jauh dari keturunan Isak. ");
INSERT INTO ind_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Inilah riwayat keluarga Isak, anak Abraham: ");
INSERT INTO ind_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ketika Isak berumur 40 tahun, dia menikah dengan Ribka, anak Betuel, adik perempuan Laban. Mereka adalah orang Aram dari Padan Aram. ");
INSERT INTO ind_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tetapi Ribka mandul. Maka Isak berdoa kepada TUHAN, dan TUHAN menjawab doanya sehingga istrinya mengandung. ");
INSERT INTO ind_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ternyata Ribka mengandung anak kembar. Kedua anaknya itu saling bertentangan di dalam rahimnya. Lalu Ribka berdoa meminta petunjuk TUHAN, katanya, “Ya TUHAN, mengapa hal ini terjadi padaku?” ");
INSERT INTO ind_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Jawab TUHAN kepadanya, “Dua anak laki-laki ada di dalam kandunganmu. Keturunan mereka akan menjadi nenek moyang dari dua bangsa yang besar dan saling bermusuhan. Yang muda akan lebih kuat. Yang tua akan menjadi pelayannya.” ");
INSERT INTO ind_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kemudian tibalah waktunya Ribka melahirkan dua anak kembar itu. ");
INSERT INTO ind_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Anak yang pertama kulitnya kemerahan dan seluruh tubuhnya berbulu. Mereka menamai dia Esau. ");
INSERT INTO ind_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Waktu anak yang kedua lahir, tangannya memegang tumit kakaknya. Maka mereka menamai dia Yakub. Isak berumur 60 tahun ketika anak-anaknya itu lahir. ");
INSERT INTO ind_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sesudah kedua anak itu dewasa, Esau menjadi seorang pemburu ulung dan suka tinggal di padang, sedangkan Yakub menjadi seorang yang tenang dan suka tinggal di dalam kemah. ");
INSERT INTO ind_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Karena itu, Isak lebih sayang kepada Esau karena dia suka makan daging hasil buruan Esau, sementara Ribka lebih sayang kepada Yakub. ");
INSERT INTO ind_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Suatu hari, ketika Yakub sedang memasak sup kacang merah, Esau pulang berburu dari padang dalam keadaan sangat lapar. ");
INSERT INTO ind_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Berkatalah Esau kepada Yakub, “Aku kelaparan! Berilah aku sebagian sup kacang merah itu.” Inilah sebabnya Esau diberi nama julukan ‘Edom’, yang berarti ‘merah’. ");
INSERT INTO ind_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jawab Yakub kepada Esau, “Baiklah, tetapi kamu harus menukarnya dengan hak kesulunganmu.” ");
INSERT INTO ind_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau berkata, “Aku hampir mati kelaparan! Apalah gunanya hak kesulungan itu bagiku?!” ");
INSERT INTO ind_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kata Yakub, “Bersumpahlah terlebih dahulu bahwa kamu akan memberikan hak kesulunganmu kepadaku.” Lalu dengan bersumpah, Esau menukar hak kesulungannya dengan masakan Yakub. ");
INSERT INTO ind_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Maka Yakub memberikan roti dan sup kacang merah itu kepada Esau. Dia makan dan minum, lalu pergi. Demikianlah Esau tidak menghargai hak kesulungannya. ");
INSERT INTO ind_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Beberapa waktu kemudian, terjadilah bencana kelaparan di negeri itu, seperti yang pernah terjadi pada zaman Abraham. Karena itu, Isak pergi ke Gerar, yaitu wilayah kekuasaan Abimelek, raja orang Filistin. ");
INSERT INTO ind_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","TUHAN menampakkan diri kepada Isak dan berkata, “Jangan pergi ke Mesir! Tetaplah di negeri yang Aku tunjukkan kepadamu. ");
INSERT INTO ind_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Tinggallah di negeri itu sebagai pendatang. Aku akan menyertai dan memberkatimu. Seluruh wilayah Kanaan akan Aku berikan kepadamu dan kepada keturunanmu. Aku akan menepati perjanjian-Ku dengan ayahmu Abraham. ");
INSERT INTO ind_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kepadamu akan Aku berikan keturunan yang sangat banyak, seperti banyaknya bintang di langit. Aku akan memberikan seluruh wilayah ini kepada mereka, dan mereka akan menjadi berkat bagi seluruh bangsa di bumi, ");
INSERT INTO ind_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","karena dulu ayahmu Abraham selalu menaati semua perkataan-Ku, petunjuk-Ku, perintah-Ku, ketetapan-Ku, dan hukum-Ku.” ");
INSERT INTO ind_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Maka tinggallah Isak di Gerar. ");
INSERT INTO ind_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Adapun Ribka sangat cantik. Karena itu, ketika para laki-laki di Gerar bertanya tentang Ribka, Isak selalu menjawab, “Dia adikku.” Isak takut untuk menjawab, “Itu istri saya,” karena dia berpikir, “Bisa saja ada yang membunuh aku demi mendapatkan Ribka.” ");
INSERT INTO ind_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sesudah Isak tinggal beberapa lama di sana, suatu hari Abimelek melihat-lihat dari jendela istananya, dan dia terkejut melihat Isak dan Ribka sedang bermesraan sebagai suami-istri. ");
INSERT INTO ind_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lalu Abimelek memanggil Isak dan berkata, “Sekarang saya tahu bahwa dia istrimu! Kenapa kamu mengatakan bahwa dia adikmu?” Jawab Isak, “Karena saya pikir, ‘Kalau saya mengaku bahwa Ribka adalah istri saya, pasti ada yang akan membunuh saya demi mendapatkannya.’” ");
INSERT INTO ind_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kata Abimelek, “Seharusnya kamu tidak melakukan itu kepada kami! Bisa saja salah seorang dari antara kami meniduri istrimu. Kalau sampai itu terjadi, maka kamulah yang menyebabkan seluruh bangsa kami bersalah atas dosa besar!” ");
INSERT INTO ind_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kemudian Abimelek memberi peringatan kepada rakyatnya, “Siapa saja yang mengganggu orang ini ataupun istrinya akan dihukum mati!” ");
INSERT INTO ind_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak menanam gandum di negeri itu, dan dalam tahun itu juga dia mendapat hasil panen seratus kali lipat, karena TUHAN sangat memberkatinya. ");
INSERT INTO ind_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Harta Isak semakin bertambah banyak sehingga dia kaya raya. ");
INSERT INTO ind_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Isak memiliki sangat banyak budak dan ternak, termasuk sapi, domba, serta kambing. Orang-orang Filistin pun iri kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Karena itu, mereka menutup semua sumur yang dahulu digali oleh para budak Abraham. Mereka menimbun sumur-sumur itu dengan tanah. ");
INSERT INTO ind_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Akhirnya, Abimelek berkata kepada Isak, “Pergilah kamu beserta seluruh budakmu dari kerajaan saya, karena kekuatanmu dan jumlah orang-orangmu sudah terlalu besar dibanding kami yang adalah penduduk asli tempat ini.” ");
INSERT INTO ind_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Maka Isak, semua budaknya, dan segala miliknya pindah dari tempat itu. Mereka pergi dan berkemah di lembah Gerar lalu menetap di sana. ");
INSERT INTO ind_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ada beberapa sumur di tempat itu yang dahulu digali oleh para budak Abraham. Namun, sesudah Abraham meninggal, sumur-sumur itu ditutup oleh orang Filistin dengan tanah. Para budak Isak menggali kembali sumur-sumur itu, dan Isak menamai masing-masing sumur seperti nama yang diberikan oleh ayahnya dahulu. ");
INSERT INTO ind_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Budak-budak Isak juga menggali sebuah sumur lain di lembah itu, dan mereka menemukan mata air yang berbual-bual. ");
INSERT INTO ind_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tetapi penduduk yang menggembalakan domba di lembah Gerar bertengkar dengan gembala-gembala Isak. Mereka berkata, “Air ini milik kami!” Lalu Isak menamai sumur itu Esek, yang berarti ‘sengketa’, karena di tempat itu orang-orang bertengkar dengan para gembalanya. ");
INSERT INTO ind_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Para budak Isak menggali sumur yang lain, tetapi lagi-lagi terjadi pertengkaran memperebutkan sumur itu. Maka Isak menamai sumur itu Sitna, yang berarti ‘permusuhan’. ");
INSERT INTO ind_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mereka pindah dari situ dan menggali sumur yang lain. Kali ini, tidak ada pertengkaran. Isak menamai sumur itu Rehobot, yang berarti ‘tempat luas’, karena katanya, “TUHAN sudah memberikan kebebasan kepada kami untuk tinggal di daerah ini, dan kami akan makmur di sini.” ");
INSERT INTO ind_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dari situ, Isak pergi ke Bersyeba. ");
INSERT INTO ind_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pada malam pertama di situ, TUHAN menampakkan diri dan berkata kepadanya, “Akulah Allah ayahmu Abraham. Jangan takut, Aku menyertaimu. Sesuai janji-Ku kepada hamba-Ku Abraham, Aku akan memberkatimu dan memberimu keturunan yang banyak.” ");
INSERT INTO ind_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Lalu Isak mendirikan mezbah dan menyembah TUHAN di tempat itu. Dia juga mendirikan perkemahan di situ, dan para budaknya menggali sumur. ");
INSERT INTO ind_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sementara mereka tinggal di situ, Raja Abimelek datang dari Gerar bersama Ahuzat, penasihatnya, dan Pikol, panglima tentaranya. ");
INSERT INTO ind_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak berkata kepada mereka, “Kenapa kalian menemui saya? Bukankah sebelumnya kalian membenci dan mengusir saya dari daerah kalian?” ");
INSERT INTO ind_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Salah satu dari mereka menjawab, “Sekarang sudah nyata bagi kami bahwa TUHAN menyertaimu. Karena itu, kami berpikir bahwa sebaiknya kita membuat perjanjian damai. ");
INSERT INTO ind_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Berjanjilah kepada kami bahwa engkau tidak akan berbuat jahat kepada kami, seperti halnya kami selalu berbuat baik kepada kalian. Waktu itu, daripada kita berselisih, saya menyuruh kalian meninggalkan wilayah kami, lalu kita berpisah dengan damai. Sekarang lihatlah betapa luar biasa TUHAN sudah memberkati kalian!” ");
INSERT INTO ind_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kemudian Isak mengadakan pesta makan dengan mereka, dan semuanya makan dan minum. ");
INSERT INTO ind_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Keesokan paginya, Abimelek dan Isak mengesahkan perjanjian damai dengan bersumpah satu sama lain. Sesudah itu, Abimelek pamit pulang, dan Isak mengucapkan selamat jalan kepada mereka. ");
INSERT INTO ind_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Pada hari itu juga, para budak Isak datang memberitahukan kepadanya tentang sumur yang sudah selesai mereka gali. Mereka berkata, “Kami sudah menemukan air!” ");
INSERT INTO ind_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Maka Isak menamai sumur itu Syeba, yang artinya ‘sumpah’. Sampai saat ini, kota itu dinamai Bersyeba, yang berarti ‘sumur sumpah’. ");
INSERT INTO ind_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ketika Esau berumur empat puluh tahun, dia menikah dengan dua perempuan dari suku Het, yaitu Yudit anak Beeri dan Basmat anak Elon. ");
INSERT INTO ind_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kedua istri Esau itu menimbulkan kepedihan hati bagi Isak dan Ribka. ");
INSERT INTO ind_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ketika Isak sudah tua dan tidak bisa melihat lagi, dia memanggil Esau, anaknya yang sulung, dan berkata, “Anakku!” Jawab Esau, “Ya, Ayah!” ");
INSERT INTO ind_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak berkata, “Aku sudah tua, dan hari kematianku semakin dekat. ");
INSERT INTO ind_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ambillah panahmu beserta tabung anak panahnya, lalu pergilah berburu ke padang. ");
INSERT INTO ind_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Masaklah daging hasil buruan itu dengan enak, seperti yang aku sukai. Kemudian bawalah ke sini untuk aku makan, supaya aku bisa memberkatimu sebelum aku mati.” ");
INSERT INTO ind_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribka mendengar Isak berbicara kepada Esau. Maka ketika Esau pergi berburu, ");
INSERT INTO ind_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","berkatalah Ribka kepada Yakub, “Aku sudah mendengar ayahmu bicara kepada Esau. ");
INSERT INTO ind_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Ayah menyuruh kakakmu, ‘Pergilah berburu, lalu masaklah daging buruanmu bagiku. Sesudah aku memakannya, aku akan memberikan berkat TUHAN kepadamu sebelum aku mati.’ ");
INSERT INTO ind_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nah, Yakub anakku, sekarang lakukanlah apa yang aku perintahkan kepadamu. ");
INSERT INTO ind_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pergilah dan pilihlah dua ekor kambing muda terbaik dari kawanan ternak. Bawalah ke sini agar aku memasak dagingnya seperti kesukaan ayahmu. ");
INSERT INTO ind_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nanti, bawalah makanan itu kepada ayahmu untuk dimakannya, supaya ayahmu memberkatimu sebelum dia meninggal.” ");
INSERT INTO ind_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jawab Yakub, “Ibu, tubuh Esau berbulu, sedangkan aku tidak. ");
INSERT INTO ind_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Bagaimana kalau ayah memegangku?! Dia pasti langsung tahu bahwa aku bukan Esau dan bahwa aku sedang berusaha menipunya. Aku tidak akan diberkati ayah, malahan dikutuknya.” ");
INSERT INTO ind_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kata Ribka, “Bila terjadi demikian, biar ibumu ini yang menanggung kutukan ayahmu. Ikuti saja perkataan ibu. Ambillah dua anak kambing, dan segera bawalah ke sini.” ");
INSERT INTO ind_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakub mengikuti perintah ibunya. Dia pergi dan kembali dengan membawa anak kambing itu. Lalu ibunya menyiapkan hidangan yang sangat enak kesukaan Isak. ");
INSERT INTO ind_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Sesudah itu, Ribka mengambil pakaian Esau yang sangat bagus, yang disimpan di rumahnya, kemudian memberikannya kepada Yakub untuk dipakai. ");
INSERT INTO ind_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Dia menutupi lengan Yakub dengan kulit kambing muda, juga bagian lehernya yang tidak berbulu. ");
INSERT INTO ind_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ribka menyerahkan masakan daging yang lezat itu serta roti yang baru dibakar kepadanya, ");
INSERT INTO ind_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","dan Yakub mendatangi ayahnya. “Ayah, ini aku,” katanya. Isak bertanya, “Kamu siapa, Esau atau Yakub?” ");
INSERT INTO ind_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jawab Yakub, “Aku Esau, anak sulungmu. Aku sudah melakukan semua yang Ayah minta. Duduklah dan nikmatilah daging buruan yang aku masak ini, supaya Ayah dapat memberkatiku.” ");
INSERT INTO ind_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak bertanya lagi kepada anaknya, “Bagaimana mungkin secepat itu kamu bisa mendapatkannya, anakku?” Jawab Yakub, “Karena TUHAN, Allah yang Ayah sembah, sudah menolongku.” ");
INSERT INTO ind_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kemudian Isak berkata kepada Yakub, “Mendekatlah supaya ayah bisa memegangmu untuk memastikan bahwa kamu benar-benar Esau.” ");
INSERT INTO ind_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakub mendekat dan Isak merabanya sambil berkata, “Suaranya suara Yakub, tetapi lengannya lengan Esau.” ");
INSERT INTO ind_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak tidak tahu bahwa sebenarnya yang dia sentuh adalah Yakub karena lengannya berbulu seperti Esau. Sebelum memberkati Yakub, ");
INSERT INTO ind_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isak bertanya lagi, “Apa benar kamu Esau?” Yakub menjawab, “Benar, aku Esau.” ");
INSERT INTO ind_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Lalu berkatalah Isak, “Dekatkanlah makanan itu agar ayah dapat memakannya lalu memberkatimu.” Yakub mendekatkan makanan itu dan Isak memakannya. Yakub membawa anggur dan Isak meminumnya juga. ");
INSERT INTO ind_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kemudian Isak berkata kepadanya, “Anakku, mendekatlah dan ciumlah aku.” ");
INSERT INTO ind_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Maka Yakub mendekat dan mencium ayahnya. Ketika Isak mencium bau pakaian Esau yang dikenakan Yakub, dia memberkati Yakub dengan berkata, “Bau anakku ini bagaikan bau padang yang sudah diberkati TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Semoga Allah memberikan kepadamu embun dari langit, dan membuat ladang-ladangmu subur! Semoga Dia memberikan kepadamu hasil panen dan anggur berlimpah-limpah! ");
INSERT INTO ind_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kiranya banyak orang akan melayanimu, dan bangsa-bangsa berlutut di hadapanmu. Biarlah kamu berkuasa atas saudara-saudaramu, dan anak-anak ibumu tunduk kepadamu. Terkutuklah orang yang mengutukmu dan diberkatilah orang yang memberkatimu!” ");
INSERT INTO ind_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Segera sesudah Isak memberkati Yakub, dan Yakub baru saja meninggalkan ayahnya, Esau tiba dengan membawa hasil buruannya. ");
INSERT INTO ind_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau memasak daging hasil buruannya dengan enak dan membawanya kepada Isak sambil berkata, “Ayah, duduklah dan makanlah makanan yang sudah aku siapkan, supaya Ayah bisa memberkatiku.” ");
INSERT INTO ind_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Bertanyalah Isak “Kamu siapa?” Jawab Esau, “Aku Esau, anak sulung Ayah.” ");
INSERT INTO ind_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak sangat terkejut dan dengan gemetar dia bertanya, “Lalu siapakah yang sudah pergi berburu dan membawa makanan kepadaku sebelum kamu datang? Aku sudah memakan semuanya, dan sudah memberkati dia dengan berkat yang tidak bisa ditarik kembali!” ");
INSERT INTO ind_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mendengar itu, Esau sakit hati dan menangis keras-keras. Dia memohon, “Ayah, berkatilah aku juga!” ");
INSERT INTO ind_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tetapi Isak menjawab, “Adikmu sudah menipuku dan mengambil berkatmu.” ");
INSERT INTO ind_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Berkatalah Esau, “Pantaslah namanya Yakub! Dia sudah dua kali menipuku. Pertama, dia merampas hakku sebagai anak sulung. Sekarang, dia merampas lagi hakku untuk mendapat berkat.” Lalu Esau bertanya kepada ayahnya, “Apakah Ayah tidak ada berkat lain untukku?” ");
INSERT INTO ind_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak menjawab, “Sesungguhnya, aku sudah memberi dia kuasa atas kamu dan semua sanak saudaranya, untuk menjadi hamba-hambanya. Semua hasil panen serta anggur juga menjadi miliknya. Tidak ada lagi yang bisa ayah berikan kepadamu, anakku!” ");
INSERT INTO ind_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau bertanya lagi kepada ayahnya, “Hanya berkat itukah yang ada pada Ayah? Berkatilah aku juga, Ayah!” Lalu Esau meratap dengan nyaring. ");
INSERT INTO ind_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isak menjawab, “Kamu akan hidup di tempat yang tidak subur, tanpa ada embun dari langit. ");
INSERT INTO ind_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kamu akan hidup dengan pedangmu dan kamu akan menjadi hamba adikmu. Tetapi kalau kamu memberontak, kamu akan bebas dari kuasanya.” ");
INSERT INTO ind_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau membenci Yakub karena ayah mereka sudah memberikan berkat kepadanya. Dalam hatinya, Esau berkata, “Tidak lama lagi ayah meninggal. Nanti, sesudah selesai acara berduka, aku akan membunuh Yakub!” ");
INSERT INTO ind_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ketika mengetahui rencana Esau, Ribka memanggil Yakub dan berkata, “Dengarkanlah. Kakakmu Esau berniat untuk membalas dendam dan membunuhmu. ");
INSERT INTO ind_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Anakku, lakukanlah yang ibu sampaikan: Selamatkanlah dirimu. Pergilah segera kepada saudaraku Laban di Haran. ");
INSERT INTO ind_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tinggallah di sana untuk sementara waktu sampai kakakmu tidak lagi marah kepadamu ");
INSERT INTO ind_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","dan melupakan perbuatanmu kepadanya. Nanti, ibu akan mengutus seseorang untuk memanggil dan membawa kamu pulang. Ibu tidak ingin kehilangan kedua anak ibu pada hari yang sama.” ");
INSERT INTO ind_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Setelah itu, Ribka berkata kepada Isak, “Aku benci hidup karena perempuan Het semacam istri-istri Esau itu. Kalau sampai Yakub menikahi perempuan dari daerah ini juga, lebih baik aku mati saja!” ");
INSERT INTO ind_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Lalu Isak memanggil Yakub, memberkati dia, dan berkata kepadanya, “Kamu tidak boleh menikah dengan perempuan Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Pergilah segera ke rumah kakekmu Betuel, ayah dari ibumu, di Padan Aram. Carilah istri dari salah seorang anak perempuan pamanmu, Laban. ");
INSERT INTO ind_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kiranya Allah Yang Mahakuasa memberkatimu dan memberimu keturunan yang banyak, sehingga kelak kamu menjadi nenek moyang bangsa-bangsa. ");
INSERT INTO ind_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Semoga TUHAN memberkatimu dan seluruh keturunanmu sesuai berkat yang sudah diberikan-Nya kepada Abraham, supaya kamu memiliki negeri yang sudah dijanjikan-Nya kepada Abraham, yaitu negeri tempat kita sekarang hidup sebagai pendatang.” ");
INSERT INTO ind_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Demikianlah Isak melepas Yakub pergi ke Padan Aram, ke rumah Laban, anak Betuel, orang Aram itu. Laban adalah saudara Ribka, ibu Yakub dan Esau. ");
INSERT INTO ind_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau mengetahui bahwa ayahnya sudah memberkati Yakub dan menyuruhnya ke Padan Aram untuk mencari seorang istri di sana. Dia juga mendengar bahwa ayahnya melarang Yakub menikah dengan perempuan Kanaan, ");
INSERT INTO ind_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","dan bahwa Yakub menuruti perintah ayah dan ibunya, lalu pergi ke Padan Aram. ");
INSERT INTO ind_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Saat itu Esau baru sadar bahwa ayahnya tidak suka dengan perempuan Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Karena itu, Esau pergi kepada Ismael, anak Abraham dari Hagar, dan menikahi anaknya yang bernama Mahalat. Demikianlah Esau memiliki istri baru selain dua istrinya yang sudah ada. Mahalat adalah adik Nebayot. ");
INSERT INTO ind_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakub meninggalkan Bersyeba dan pergi ke Haran. ");
INSERT INTO ind_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Karena matahari sudah terbenam, Yakub memutuskan untuk bermalam di suatu tempat. Dia mengambil sebuah batu besar untuk dijadikan alas kepala, lalu tidur. ");
INSERT INTO ind_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Saat Yakub terlelap, dia bermimpi melihat sebuah tangga. Bagian bawah tangga itu berpijak pada bumi dan ujungnya sampai ke langit. Para malaikat berjalan turun naik di tangga itu. ");
INSERT INTO ind_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Lalu TUHAN berdiri di puncak tangga itu dan berkata, “Akulah TUHAN, Allah kakekmu Abraham, dan Allah ayahmu Isak. Tanah di mana kamu sedang tidur ini akan Aku berikan kepadamu dan kepada seluruh keturunanmu. ");
INSERT INTO ind_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Jumlah keturunanmu akan seperti debu di atas bumi. Mereka akan tersebar dari timur sampai ke barat, dan dari utara sampai ke selatan. Semua suku bangsa akan diberkati melalui kamu dan keturunanmu. ");
INSERT INTO ind_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aku menyertaimu dan akan menjagamu ke mana pun kamu pergi. Aku akan menuntunmu kembali ke tanah ini. Aku tidak akan meninggalkanmu dan Aku akan menepati janji-Ku.” ");
INSERT INTO ind_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Lalu Yakub terbangun dari tidurnya dan berkata, “Pasti TUHAN ada di tempat ini, dan aku tidak mengetahuinya.” ");
INSERT INTO ind_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Dia pun menjadi takut dan berkata, “Tempat ini sangat mengagumkan! Ini pasti rumah Allah, dan di sini adalah gerbang surga!” ");
INSERT INTO ind_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Maka pagi-pagi benar dia bangun dan mendirikan batu yang dipakainya itu sebagai batu peringatan. Dia menuangkan minyak di atas batu tersebut untuk menandakan bahwa batu itu dikhususkan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yakub menamai tempat itu Betel. Sebelumnya, kota itu bernama Lus. ");
INSERT INTO ind_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Lalu Yakub berjanji, katanya, “Kalau Allah menyertai dan menjagaku dalam perjalanan yang sedang aku tempuh ini, serta menyediakan makanan dan pakaian untukku, ");
INSERT INTO ind_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sehingga aku dapat kembali ke rumah ayahku dengan selamat, maka Engkau, TUHAN, akan menjadi Allahku. ");
INSERT INTO ind_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Batu yang sudah aku tegakkan sebagai peringatan akan menjadi tempat untuk menyembah Engkau. Dan aku akan memberikan kepada-Mu sepersepuluh dari segala sesuatu yang Engkau berikan kepadaku.” ");
INSERT INTO ind_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kemudian Yakub meneruskan perjalanan hingga tiba di tanah orang-orang di sebelah timur Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Dari jauh, dia melihat sebuah sumur dengan tiga kawanan domba sedang berbaring di dekatnya. Dari sumur itulah domba-domba akan diberi minum. Namun, saat itu sumur masih ditutup dengan sebuah batu besar. ");
INSERT INTO ind_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sudah menjadi kebiasaan di sana untuk menunggu sampai semua gembala dan kawanan domba mereka berkumpul, barulah batu besar itu digulingkan ke samping, lalu semua kawanan domba diberi minum. Setelah itu, sumur akan ditutup kembali dengan batu besar tadi. ");
INSERT INTO ind_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakub mendekati para gembala di situ dan berkata, “Saudara-saudara, dari manakah kalian ini?” Jawab mereka, “Kami dari Haran.” ");
INSERT INTO ind_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakub bertanya lagi, “Apakah kalian mengenal Laban, cucu Nahor?” Jawab mereka, “Ya, kami kenal dia.” ");
INSERT INTO ind_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Lalu kata Yakub, “Bagaimana kabarnya?” Jawab mereka, “Dia baik-baik saja. Lihatlah, itu anaknya yang bernama Rahel datang. Dia membawa domba-domba ayahnya.” ");
INSERT INTO ind_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakub berkata, “Ya, tetapi hari masih siang. Belum waktunya domba-domba dikumpulkan dan dimasukkan ke kandang. Sebaiknya domba-domba ini diberi minum lalu digiring kembali ke padang untuk merumput.” ");
INSERT INTO ind_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Jawab mereka, “Tidak bisa. Kalau semua kawanan domba sudah berkumpul, barulah kami dapat menggulingkan batu penutup sumur itu dan memberi minum domba-domba kami.” ");
INSERT INTO ind_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ketika Yakub masih berbicara dengan mereka, Rahel tiba di tempat itu sambil menggiring domba-domba milik ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Begitu Yakub melihat Rahel, sepupunya, yaitu anak Laban, saudara ibunya, dia menggulingkan batu penutup sumur itu. Kemudian Yakub memberi minum domba-domba pamannya. ");
INSERT INTO ind_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakub mencium pipi kanan dan kiri Rahel sambil menangis dengan nyaring karena senangnya. ");
INSERT INTO ind_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakub menceritakan kepada Rahel bahwa mereka adalah sepupu, karena Laban adalah saudara ibunya, Ribka. Mendengar itu, Rahel berlari pulang untuk memberitahu ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Begitu Laban mendengar tentang kedatangan Yakub, dia langsung berlari menemuinya, kemudian memeluk dan mencium pipi kanan dan kiri Yakub. Laban mengajak Yakub ke rumahnya, dan Yakub menceritakan semua hal yang sudah terjadi padanya. ");
INSERT INTO ind_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lalu kata Laban kepadanya, “Kamu benar-benar keponakanku.” Maka Yakub tinggal di rumah Laban selama sebulan penuh. ");
INSERT INTO ind_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kemudian Laban berkata kepada Yakub, “Tidak pantas kamu bekerja untukku tanpa digaji hanya karena kita masih keluarga. Katakanlah berapa bayaran yang kamu inginkan.” ");
INSERT INTO ind_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban mempunyai dua anak perempuan, yang sulung Lea, dan adiknya bernama Rahel. ");
INSERT INTO ind_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea bermata sayu, sedangkan Rahel cantik wajahnya maupun perawakannya. ");
INSERT INTO ind_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakub sudah jatuh cinta kepada Rahel. Karena itu, dia berkata, “Aku bersedia bekerja pada Paman selama tujuh tahun. Sebagai bayarannya, izinkanlah aku menikah dengan Rahel.” ");
INSERT INTO ind_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Jawab Laban, “Ya. Lebih baik aku memberikan Rahel kepadamu daripada kepada orang lain! Tinggallah di sini bekerja padaku.” ");
INSERT INTO ind_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Maka Yakub pun bekerja selama tujuh tahun untuk mendapatkan Rahel. Bagi Yakub, tujuh tahun terasa seperti beberapa hari saja, karena dia sangat mencintai Rahel. ");
INSERT INTO ind_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sesudah tujuh tahun berlalu, berkatalah Yakub kepada Laban, “Masa kerjaku selama tujuh tahun sudah berakhir. Sekarang izinkanlah aku menikah dengan Rahel.” ");
INSERT INTO ind_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Maka Laban mengundang semua orang di tempat itu dan mengadakan pesta pernikahan yang besar. ");
INSERT INTO ind_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Namun, malam itu Laban membawa Lea kepada Yakub, dan Yakub pun bersetubuh dengannya. ");
INSERT INTO ind_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban memberikan seorang budak perempuan bernama Zilpa kepada Lea untuk menjadi pelayannya. ");
INSERT INTO ind_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Keesokan paginya, Yakub baru menyadari bahwa yang bersama dia semalam adalah Lea. Maka berkatalah Yakub kepada Laban, “Kenapa Paman memperlakukan aku seperti ini?! Aku bekerja tujuh tahun demi mendapatkan Rahel! Kenapa Paman menipu aku?!” ");
INSERT INTO ind_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Jawab Laban, “Dalam adat kami, seorang adik perempuan tidak boleh menikah mendahului kakaknya. ");
INSERT INTO ind_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Jalanilah dulu perayaan pernikahanmu dengan Lea selama satu minggu, lalu aku akan memberikan Rahel kepadamu. Tetapi kamu harus berjanji untuk bekerja padaku selama tujuh tahun lagi.” ");
INSERT INTO ind_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakub memenuhi permintaan Laban dan menjalani perayaan pernikahan untuk Lea selama satu minggu. Kemudian Laban memberikan Rahel kepada Yakub untuk diperistri. ");
INSERT INTO ind_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban memberikan juga budak perempuan bernama Bilha kepada Rahel untuk menjadi pelayannya. ");
INSERT INTO ind_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jadi Yakub juga bersetubuh dengan Rahel, dan dia lebih mencintai Rahel daripada Lea. Sesudah itu, Yakub masih tinggal dan bekerja untuk Laban selama tujuh tahun lagi. ");
INSERT INTO ind_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","TUHAN tahu bahwa Yakub tidak mencintai Lea, maka TUHAN mengizinkan Lea hamil, sedangkan Rahel tetap mandul. ");
INSERT INTO ind_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea melahirkan seorang anak laki-laki. Dia berkata, “TUHAN sudah melihat penderitaanku. Sekarang suamiku pasti mencintai aku.” Karena itu, dia menamai anaknya Ruben. ");
INSERT INTO ind_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kemudian Lea hamil lagi, dan ketika dia melahirkan seorang anak laki-laki, dia berkata, “TUHAN sudah mendengar bahwa aku tidak dicintai. Itu sebabnya TUHAN memberikan seorang anak lagi kepadaku.” Maka dia menamai anak itu Simeon. ");
INSERT INTO ind_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Sesudah itu, Lea kembali mengandung, dan ketika melahirkan seorang anak laki-laki, dia berkata, “Sekarang suamiku pasti semakin erat kepadaku karena aku sudah melahirkan tiga anak laki-laki baginya.” Maka Lea menamai anak itu Lewi. ");
INSERT INTO ind_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Beberapa waktu kemudian, Lea hamil lagi dan melahirkan seorang anak laki-laki. Kali ini dia berkata, “Aku memuji TUHAN!” Maka dia menamai anak keempatnya itu Yehuda. Setelah itu, Lea berhenti mengandung. ");
INSERT INTO ind_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ketika Rahel menyadari bahwa dirinya mandul, dia merasa iri kepada kakaknya, Lea. Lalu dia berkata kepada Yakub, “Berikanlah aku anak! Kalau tidak, lebih baik aku mati saja!” ");
INSERT INTO ind_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Mendengar itu, Yakub menjadi sangat marah dan berkata, “Memangnya aku ini Allah?! Dialah yang sudah membuat kamu mandul! Bukan aku!” ");
INSERT INTO ind_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Jawab Rahel, “Ini budakku, Bilha! Ambillah dia dan tidurlah dengannya, supaya dia melahirkan seorang anak yang nantinya kita anggap sebagai anak kita.” ");
INSERT INTO ind_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yakub pun setuju, dan Rahel memberikan budaknya Bilha kepada suaminya sebagai istri. Yakub tidur dengan Bilha, ");
INSERT INTO ind_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","lalu Bilha mengandung dan melahirkan seorang anak laki-laki bagi Yakub. ");
INSERT INTO ind_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Maka berkatalah Rahel, “Allah sudah membenarkan aku dan mendengar permohonanku. Dia sudah memberikan kepadaku seorang anak laki-laki!” Itulah sebabnya dia menamai anak itu Dan. ");
INSERT INTO ind_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Lalu Bilha hamil lagi dan melahirkan anak laki-laki yang kedua. ");
INSERT INTO ind_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Berkatalah Rahel, “Aku sudah berjuang keras melawan kakakku, dan akhirnya aku menang.” Itulah sebabnya dia menamai anak itu Naftali. ");
INSERT INTO ind_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ketika Lea menyadari bahwa dirinya sudah lama tidak hamil lagi, dia memberikan budaknya, Zilpa, kepada suaminya untuk diperistri. ");
INSERT INTO ind_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lalu Zilpa hamil dan melahirkan seorang anak laki-laki bagi Yakub. ");
INSERT INTO ind_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea berkata, “Aku sungguh beruntung.” Maka dia menamai anak itu Gad. ");
INSERT INTO ind_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sesudah itu Zilpa melahirkan lagi seorang anak laki-laki. ");
INSERT INTO ind_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea berkata, “Betapa bahagianya aku. Perempuan-perempuan akan mengatakan bahwa aku bahagia.” Maka dia menamai anak itu Asyer. ");
INSERT INTO ind_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pada musim panen gandum, Ruben berjalan-jalan dan menemukan tanaman mandragora di ladang, lalu membawanya kepada ibunya, Lea. Berkatalah Rahel kepada Lea, “Bolehkah aku minta beberapa mandragora yang dibawa anakmu?” ");
INSERT INTO ind_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Jawab Lea, “Apa belum cukup kamu mengambil suamiku? Sekarang kamu masih berani meminta mandragora yang dibawakan anakku untukku!” Rahel menjawab, “Kalau begitu, sebagai gantinya, biarlah malam ini Yakub tidur denganmu, dan berikanlah kepadaku mandragora yang dibawa anakmu itu.” ");
INSERT INTO ind_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Petang harinya, ketika Yakub pulang dari ladang, Lea menyambut dia dan berkata, “Malam ini kamu harus tidur denganku, karena aku sudah memberikan mandragora kepada Rahel sebagai bayarannya.” Maka malam itu, Yakub tidur dengan Lea. ");
INSERT INTO ind_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allah menjawab doa Lea, dia mengandung lagi dan melahirkan anak laki-laki yang kelima bagi Yakub. ");
INSERT INTO ind_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea pun berkata, “Allah sudah memberi upah kepadaku karena aku memberikan budakku kepada suamiku.” Itulah sebabnya Lea menamai anak itu Isakar. ");
INSERT INTO ind_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lalu Lea mengandung lagi dan melahirkan anak laki-laki yang keenam bagi Yakub. ");
INSERT INTO ind_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea berkata, “Allah sudah memberiku suatu pemberian yang luar biasa. Kali ini, suamiku pasti akan menghargaiku karena aku sudah memberinya enam anak laki-laki.” Maka dia menamai anak itu Zebulon. ");
INSERT INTO ind_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sesudah itu, Lea melahirkan seorang anak perempuan dan menamainya Dina. ");
INSERT INTO ind_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Lalu Allah mendengar dan menjawab permohonan Rahel, sehingga Allah membuatnya bisa hamil. ");
INSERT INTO ind_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rahel pun mengandung dan melahirkan seorang anak laki-laki. Rahel berkata, “Allah sudah menghapus aib pada diriku.” ");
INSERT INTO ind_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Maka dia menamai anaknya itu Yusuf, karena dia berkata, “Semoga TUHAN memberiku seorang anak laki-laki lagi.” ");
INSERT INTO ind_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sesudah Rahel melahirkan Yusuf, Yakub menemui Laban dan berkata, “Paman, izinkanlah aku kembali ke tanah kelahiranku. ");
INSERT INTO ind_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Biarkan aku membawa istri-istri dan anak-anakku, yang aku peroleh karena bekerja padamu. Paman tahu bahwa selama ini aku sudah bekerja keras untukmu.” ");
INSERT INTO ind_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tetapi Laban menjawab, “Kalau kamu berkenan, tinggallah di sini. Aku tahu melalui ramalan bahwa selama ini TUHAN memberkatiku karena kamu bekerja padaku. ");
INSERT INTO ind_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Katakan saja berapa upah yang kamu mau. Aku siap membayarnya.” ");
INSERT INTO ind_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jawab Yakub, “Paman sendiri tahu bagaimana aku sudah bekerja keras untukmu, dan bagaimana keadaan kawanan ternak milikmu selama aku mengurusnya. ");
INSERT INTO ind_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sebelum aku datang, harta kekayaan Paman sedikit, tetapi sekarang sudah berlipat ganda banyaknya. TUHAN sudah memberkatimu di mana pun aku bekerja. Jadi, sekarang sudah waktunya aku bekerja memenuhi kebutuhan keluargaku sendiri.” ");
INSERT INTO ind_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban bertanya, “Kalau begitu, apa yang harus aku berikan kepadamu untuk tetap bekerja bagiku di sini?” Jawab Yakub, “Paman tidak perlu memberikan apa-apa kepadaku. Tetapi kalau Paman setuju dengan usulanku, aku akan terus mengurus kawanan ternak Paman. ");
INSERT INTO ind_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Biarlah hari ini aku memisahkan dari antara kawanan ternakmu setiap domba yang berbintik-bintik atau berbelang-belang, setiap anak domba yang berbulu hitam, dan setiap kambing yang berbintik-bintik atau berbelang-belang. Biarlah hewan-hewan itu menjadi upahku. ");
INSERT INTO ind_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Di kemudian hari, Paman bisa membuktikan kejujuranku. Paman bisa datang memeriksa kawanan ternakku. Kalau ada kambing yang tidak berbintik atau berbelang-belang, atau domba yang tidak berwarna hitam, Paman berhak menganggapku sudah mencuri hewan-hewan itu darimu.” ");
INSERT INTO ind_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Jawab Laban, “Baiklah, aku setuju!” ");
INSERT INTO ind_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Namun, pada hari itu Laban memisahkan semua kambing jantan dan betina yang berbintik-bintik atau berbelang-belang, yang ada warna putih pada bulunya, dan semua anak domba yang berbulu hitam. Dia menyerahkan ternak itu kepada anak-anak laki-lakinya untuk dijaga. ");
INSERT INTO ind_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Lalu anak-anak Laban membawa kawanan ternak itu menjauh dari Yakub dan dari kawanan ternak Laban yang masih dijaga Yakub. Jarak perjalanan antara mereka dengan Yakub adalah tiga hari. ");
INSERT INTO ind_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kemudian Yakub memotong dahan dari tiga jenis pohon dan mengupas sebagian kulit kayunya sampai ke dalam, sehingga dahan-dahan tersebut kelihatan bergaris-garis putih. ");
INSERT INTO ind_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Dia menaruh dahan-dahan itu di dalam palungan tempat air minum kawanan ternak, sehingga hewan ternak melihat dahan-dahan itu ketika minum. Binatang-binatang biasanya kawin pada waktu datang minum. ");
INSERT INTO ind_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ketika hewan ternak itu kawin di depan dahan-dahan yang bergaris-garis, maka bulu anak-anaknya yang kemudian lahir menjadi bergaris-garis, berbintik-bintik, atau berbelang-belang. ");
INSERT INTO ind_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Lalu Yakub memisahkan domba-domba yang baru lahir itu. Pada musim kawin, Yakub membuat kawanan kambing domba melihat ke arah kawanan yang berbelang-belang atau berwarna gelap, sehingga bulu binatang-binatang yang kemudian lahir menjadi berwarna. Dengan cara ini, dia mulai mengumpulkan kawanan ternaknya sendiri, terpisah dari kawanan ternak Laban. ");
INSERT INTO ind_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Saat kambing dan domba betina yang sehat sedang berahi, Yakub selalu meletakkan dahan-dahan itu di palungan di hadapan kawanan itu, sehingga mereka kawin di dekat dahan-dahan tersebut. ");
INSERT INTO ind_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Akan tetapi, Yakub tidak menaruh dahan-dahan itu di depan hewan ternak yang kurang sehat. Dengan demikian, binatang-binatang yang lahir dari induk yang kurang sehat menjadi milik Laban, sedangkan yang lahir dari induk yang sehat menjadi milik Yakub. ");
INSERT INTO ind_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Akhirnya, Yakub menjadi sangat kaya. Dia memiliki banyak ternak, budak laki-laki dan perempuan, unta, serta keledai. ");
INSERT INTO ind_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Suatu hari, Yakub mendapat kabar bahwa anak-anak lelaki Laban saling bersungut-sungut tentang dia, “Yakub sudah merampas harta ayah kita. Semua kekayaannya itu dia peroleh dari ayah kita!” ");
INSERT INTO ind_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakub juga memperhatikan bahwa sikap Laban terhadapnya sudah tidak seperti sebelumnya. ");
INSERT INTO ind_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lalu TUHAN berkata kepada Yakub, “Kembalilah ke negeri nenek moyangmu dan kepada kaum keluargamu. Aku akan menyertai kamu.” ");
INSERT INTO ind_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Sesudah itu, Yakub menyuruh seseorang memanggil kedua istrinya, Rahel dan Lea, untuk menemuinya di padang rumput tempat dia menggembalakan kambing dombanya. ");
INSERT INTO ind_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ketika Rahel dan Lea datang, Yakub berkata kepada mereka, “Aku memperhatikan bahwa sekarang sikap ayah kalian sudah berubah terhadapku. Tetapi Allah yang disembah ayahku tetap menyertai aku. ");
INSERT INTO ind_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kalian sendiri tahu bahwa selama ini aku bekerja keras untuk ayah kalian sekuat tenaga. ");
INSERT INTO ind_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Namun, dia sudah menipuku dengan berulang kali mengubah gajiku. Meski demikian, Allah tidak membiarkan dia berbuat jahat kepadaku. ");
INSERT INTO ind_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Buktinya, ketika dia berkata, ‘Kambing dan domba yang berbintik-bintik akan menjadi upahmu,’ maka semua anak kambing dan domba lahir berbintik-bintik. Ketika dia berkata, ‘Kambing dan domba yang bergaris-garis akan menjadi upahmu,’ maka semua anak kambing dan domba lahir bergaris-garis. ");
INSERT INTO ind_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Allah sudah mengambil ternak-ternak ayah kalian dan memberikannya kepadaku. ");
INSERT INTO ind_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ketika musim kawin binatang tiba, aku bermimpi. Dalam mimpi itu aku melihat bahwa kambing-kambing jantan yang kawin dengan kambing-kambing betina berbulu belang-belang, garis-garis, dan bintik-bintik. ");
INSERT INTO ind_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Dalam mimpi itu, ada malaikat yang menyampaikan pesan Allah. Dia memanggilku, ‘Yakub!’ Jawabku, ‘Ya TUHAN, aku di sini!’ ");
INSERT INTO ind_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Lalu malaikat itu berkata kepadaku, ‘Lihat dan perhatikanlah bahwa semua kambing jantan yang mengawini kawanan ternak betina ini memiliki bulu belang-belang, garis-garis, dan bintik-bintik. Aku membuat semuanya seperti itu karena Aku sudah melihat bagaimana Laban memperlakukanmu. ");
INSERT INTO ind_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Akulah Allah yang sudah menjumpaimu di Betel, di tempat kamu mendirikan batu peringatan dan menuang minyak di atasnya lalu berjanji kepada-Ku. Sekarang, bersiaplah untuk pergi dari tempat ini dan kembali ke negeri kelahiranmu.’” ");
INSERT INTO ind_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","Rahel dan Lea menjawab, “Kami tahu bahwa kamu sudah bertahun-tahun bekerja pada ayah untuk mendapatkan kami sebagai istrimu. Sekarang dia sudah menghabiskan semua kekayaan yang dia hasilkan dari kerja kerasmu. Kami tahu bahwa kami tidak akan mendapat warisan apa-apa, bahkan dia memperlakukan kami seperti orang asing. ");
INSERT INTO ind_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Semua kekayaan dari ayah kami yang sudah Allah berikan kepadamu adalah milik kita dan milik anak-anak kita. Jadi, lakukanlah apa yang sudah Allah perintahkan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","20","Yakub mengakali Laban, orang Aram itu, dengan pergi tanpa memberitahu dia. Ketika Laban beserta para pekerjanya dan seluruh sanak saudaranya sudah pergi ke padang untuk menggunting bulu domba-dombanya, Yakub cepat-cepat berangkat bersama istri-istri dan anak-anaknya dengan menunggangi beberapa ekor unta. Mereka menuju Kanaan, ke tempat Isak, ayahnya. Yakub menyuruh para budaknya membawa semua ternak dan harta yang diperolehnya selama bekerja di Padan Aram. Namun, tanpa sepengetahuan Yakub, Rahel sudah mencuri patung-patung berhala pelindung keluarga milik ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Demikianlah Yakub lari dengan membawa semua harta dan keluarganya, lalu menyeberangi sungai Efrat menuju perbukitan Gilead. ");
INSERT INTO ind_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Pada hari ketiga, seseorang memberitahu Laban bahwa Yakub sudah melarikan diri. ");
INSERT INTO ind_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mendengar berita itu, Laban langsung membawa rombongan untuk mengejar Yakub. Sesudah tujuh hari perjalanan, mereka melihat Yakub di perbukitan Gilead. ");
INSERT INTO ind_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Ketika Laban mencapai tempat mereka, Yakub sudah mendirikan perkemahan di perbukitan itu. Jadi, Laban dan rombongannya mendirikan perkemahan mereka dekat tempat Yakub. Malam harinya, ketika Laban sedang tidur, datanglah Allah kepadanya dalam mimpi dan berkata, “Perhatikanlah! Ketika bertemu dengan Yakub, jangan mengatakan apa pun kepadanya dalam keadaan marah.” ");
INSERT INTO ind_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lalu, ketika Laban bertemu Yakub, dia berkata, “Apa yang kamu lakukan ini! Kamu sudah menipuku dengan membawa anak-anak perempuanku seperti tawanan perang. ");
INSERT INTO ind_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mengapa kamu menipuku dengan pergi diam-diam? Kalau saja kamu memberitahuku, tentu aku akan merelakan kepergian kalian dengan sukacita. Aku akan mengantar kalian dengan nyanyian diiringi rebana dan kecapi. ");
INSERT INTO ind_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kamu bahkan tidak memberiku kesempatan mencium cucu-cucuku dan anak-anak perempuanku untuk mengucapkan selamat jalan kepada mereka. Bodoh sekali tindakanmu ini! ");
INSERT INTO ind_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aku bisa saja mencelakaimu, tetapi semalam, Allah yang disembah ayahmu sudah melarang aku untuk mengatakan apa pun kepadamu dalam keadaan marah. ");
INSERT INTO ind_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Baiklah, sekarang kamu sudah memutuskan untuk pergi dengan alasan sangat rindu kepada ayahmu. Tetapi mengapa kamu juga mencuri patung-patung dewaku?” ");
INSERT INTO ind_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jawab Yakub kepadanya, “Aku pergi diam-diam karena takut kalau Paman akan berusaha keras menahan anak-anak perempuanmu ini secara paksa, sehingga aku tidak bisa membawa mereka pergi. ");
INSERT INTO ind_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Namun, mengenai patung-patung Paman itu, siapa pun nanti yang ketahuan mencurinya, biarlah dia dihukum mati! Dengan disaksikan oleh saudara-saudara kita, Paman boleh memeriksa sendiri apakah ada barang milik Paman di antara barang bawaan kami. Jika ada, silakan mengambilnya.” Yakub berkata demikian karena tidak tahu bahwa Rahel yang mencuri patung-patung itu. ");
INSERT INTO ind_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Maka Laban mulai mencari patung-patung tersebut. Dia mencari di dalam kemah Yakub, kemudian di kemah Lea, dan selanjutnya di kemah Zilpa dan Bilha, tetapi Laban tidak menemukan patung-patung itu. Kemudian dia masuk ke kemah Rahel. ");
INSERT INTO ind_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Namun, Rahel sudah menyembunyikan patung-patung itu di dalam pelana untanya dan duduk di atas pelana tersebut. Jadi, saat Laban mencari di kemahnya, dia tidak menemukan apa-apa. ");
INSERT INTO ind_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Sementara Laban sibuk memeriksa kemah Rahel, berkatalah Rahel kepada ayahnya itu, “Ayah, aku minta maaf. Aku tidak dapat berdiri dari tempat dudukku untuk menyambut Ayah karena aku sedang datang bulan.” Maka Laban tidak berhasil menemukan patung-patungnya. ");
INSERT INTO ind_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakub pun marah dan menegur Laban, katanya, “Apa salahku dan dosaku sehingga Paman mengejar-ngejar aku seperti seorang penjahat?! ");
INSERT INTO ind_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Paman sudah memeriksa seluruh barang-barang kami! Apakah Paman menemukan barang milik Paman?! Kalau ada, tunjukkanlah di sini di hadapan saudara-saudara Paman dan saudara-saudaraku, supaya mereka memutuskan siapa yang benar di antara kita berdua! ");
INSERT INTO ind_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Dua puluh tahun lamanya aku tinggal bersama Paman dan bekerja keras memelihara ternakmu. Kambing dombamu bertambah banyak bahkan tidak ada satu pun anaknya yang mati. Tidak pernah satu kali pun aku makan daging dari ternak Paman itu. ");
INSERT INTO ind_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Paman selalu menuntut ganti rugi dariku untuk setiap binatang yang dicuri pada waktu siang ataupun malam. Yang mati tercabik-cabik karena dimangsa binatang buas tidak pernah aku bawa kepada Paman. ");
INSERT INTO ind_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Aku menanggung sengatan panasnya siang dan dinginnya malam, juga hampir tidak punya waktu untuk tidur. ");
INSERT INTO ind_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Inilah yang Paman lakukan terhadapku selama dua puluh tahun aku tinggal di rumah Paman. Aku bekerja seperti budak, empat belas tahun untuk mendapatkan kedua anak perempuan Paman, dan enam tahun untuk mendapatkan ternak-ternak ini sebagai upahku. Tetapi selama itu, Paman sudah berulang kali mengubah upahku. ");
INSERT INTO ind_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kalau bukan karena Allah nenek moyangku, yaitu Allah yang disembah Abraham dan Isak, yang menyertai aku, tentulah Paman sudah menyuruh aku pergi dengan tangan kosong! Namun, Allah melihat bahwa aku sudah bekerja keras dan Paman terus membuatku menderita. Itulah sebabnya tadi malam Dia menegur Paman dan hal itu menunjukkan bahwa Pamanlah yang salah!” ");
INSERT INTO ind_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jawab Laban kepada Yakub, “Kedua perempuan ini adalah anak-anakku, dan anak-anak yang mereka lahirkan adalah cucu-cucuku. Ternak-ternak ini juga adalah milikku. Semua yang kamu lihat adalah milikku. Tidak mungkin aku akan mencelakai anak-anak dan cucu-cucuku! ");
INSERT INTO ind_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Karena itu, marilah kita membuat perjanjian sebagai tanda peringatan bahwa aku dan kamu sudah berdamai.” ");
INSERT INTO ind_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lalu Yakub dan orang-orang yang mengikutinya mendirikan sebuah batu besar sebagai tugu peringatan. ");
INSERT INTO ind_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakub juga meminta bantuan rombongan Laban untuk mengumpulkan batu. Maka mereka semua mengambil batu-batu itu dan menyusunnya menjadi suatu tumpukan. Sesudah itu, mereka makan di samping tumpukan batu itu. ");
INSERT INTO ind_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban menamai tumpukan batu itu Yegar Sahaduta, sedangkan Yakub menamainya Galed. ");
INSERT INTO ind_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban berkata kepada Yakub, “Mulai hari ini, biarlah tugu tanda perjanjian ini menjadi saksi antara aku dan kamu.” Itulah sebabnya tempat itu dinamai Galed. ");
INSERT INTO ind_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tugu peringatan itu juga disebut Mispa, karena Laban berkata kepada Yakub, “TUHANlah yang mengawasi perbuatanmu dan perbuatanku setelah kita berpisah. ");
INSERT INTO ind_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Jika kamu menyakiti hati anak-anakku atau mengambil perempuan-perempuan lain untuk menjadi istrimu selain mereka berdua— biarpun tidak ada saksi yang memberitahuku tentang hal itu— ingatlah bahwa Allah akan menjadi saksi atas perbuatanmu itu.” ");
INSERT INTO ind_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lalu katanya lagi kepada Yakub, “Perhatikanlah tumpukan batu dan tugu yang kita dirikan ini, yang aku taruh antara aku dan kamu. ");
INSERT INTO ind_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Keduanya akan menjadi tanda batas antara kita, sebagai peringatan bahwa aku tidak akan melewati tempat ini dengan tujuan berbuat jahat terhadap kamu, dan kamu pun tidak akan melewatinya untuk berbuat jahat terhadap aku. ");
INSERT INTO ind_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Biarlah kiranya Allah Abraham dan Dewa Nahor menghakimi siapa pun di antara kita yang melanggar perjanjian ini.” Lalu Yakub berjanji atas nama Allah yang disembah oleh Isak, ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakub mempersembahkan kurban di atas bukit itu dan mengundang seluruh rombongan Laban untuk makan bersama. Mereka pun makan dan bermalam di sana. ");
INSERT INTO ind_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Keesokan harinya, pagi-pagi sekali, Laban bangun dan memberikan ciuman perpisahan kepada cucu-cucunya dan anak-anaknya serta memberkati mereka. Sesudah itu, Laban pulang. ");
INSERT INTO ind_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakub dan keluarganya melanjutkan perjalanan. Dalam perjalanan itu, malaikat-malaikat menemui dia. ");
INSERT INTO ind_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ketika Yakub melihat mereka, dia berkata, “Ini perkemahan Allah!” Maka dia menamai tempat itu Mahanaim. ");
INSERT INTO ind_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Sesudah peristiwa itu, Yakub mengirim sejumlah utusan untuk membawa berita kepada Esau, kakaknya, di daerah Seir di negeri Edom. ");
INSERT INTO ind_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Dia memerintahkan mereka untuk menyampaikan pesan kepada Esau, “Tuan, selama ini aku sudah tinggal bersama paman kita Laban. ");
INSERT INTO ind_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Sekarang aku sudah memiliki sapi, keledai, kambing, domba, budak laki-laki, dan budak perempuan. Aku mengirim utusan untuk memberitahu Tuan mengenai kedatanganku dengan harapan agar Tuan mau menerima aku dengan baik.” ");
INSERT INTO ind_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Lalu pulanglah para utusan tersebut dan memberitahu Yakub, “Tuan, kami sudah bertemu Esau. Dia sedang dalam perjalanan untuk menemui Tuan, disertai empat ratus orang laki-laki!” ");
INSERT INTO ind_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mendengar itu, Yakub menjadi sangat takut. Maka dia menyuruh agar semua orang dalam rombongannya dan semua binatang miliknya dibagi menjadi dua kelompok, termasuk domba, kambing, sapi, dan unta. ");
INSERT INTO ind_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakub melakukan itu karena berpikir, “Kalau Esau menyerang kelompok yang satu, orang-orang dalam kelompok yang lain mungkin dapat menyelamatkan diri.” ");
INSERT INTO ind_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kemudian Yakub berdoa, “Ya TUHAN, Allah kakekku Abraham dan ayahku Isak! Engkaulah yang menyuruh aku pulang ke negeriku dan kepada keluargaku. Engkau juga yang berjanji untuk memperlakukan aku dengan murah hati. ");
INSERT INTO ind_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Aku tidak layak menerima kasih dan kesetiaan yang sudah Engkau tunjukkan kepadaku. Ketika aku menyeberangi sungai Yordan untuk pergi ke Haran, aku tidak punya apa-apa selain tongkat ini. Tetapi sekarang aku memiliki dua rombongan besar, dengan keluarga dan segala harta benda. ");
INSERT INTO ind_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Aku mohon, ya TUHAN, selamatkanlah aku dari kakakku Esau, sebab aku takut kalau dia datang dan membunuhku beserta para istri dan anak-anakku. ");
INSERT INTO ind_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ingatlah bahwa Engkau sudah berjanji untuk memperlakukan aku dengan murah hati dan membuat keturunanku banyak, seperti pasir di laut yang tidak dapat dihitung.” ");
INSERT INTO ind_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Lalu Yakub bermalam di sana. Keesokan harinya, dia mempersiapkan hadiah untuk Esau ");
INSERT INTO ind_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","berupa 200 kambing betina, 20 kambing jantan, 200 domba betina, 20 domba jantan, ");
INSERT INTO ind_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 unta betina beserta anak-anaknya, 40 sapi betina, 10 sapi jantan, 20 keledai betina, dan 10 keledai jantan. ");
INSERT INTO ind_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakub membagi hewan-hewan itu menjadi beberapa kelompok dan menyerahkannya kepada budak-budaknya dengan berpesan, “Pergilah mendahului aku kelompok demi kelompok, dan pastikanlah ada jarak antara setiap kelompok.” ");
INSERT INTO ind_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Dia memberi perintah kepada para budak dalam kelompok pertama, katanya, “Waktu kalian bertemu kakakku Esau, dan kalau dia bertanya, ‘Kalian mau ke mana? Siapakah majikan kalian? Milik siapa kawanan ternak ini?’ ");
INSERT INTO ind_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Maka jawablah, ‘Ternak ini milik hambamu Yakub. Dia menyuruh kami membawa semua ini sebagai hadiah untuk Tuan. Yakub sendiri ada di belakang rombongan kami.’” ");
INSERT INTO ind_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakub memberi perintah serupa kepada setiap kelompok budak yang menggiring kawanan ternaknya, “Kalian semua harus menyampaikan hal yang sama ketika bertemu dengan kakakku Esau. ");
INSERT INTO ind_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Dan jangan lupa untuk mengatakan kepadanya, ‘Hambamu Yakub juga ada di belakang kami.’” Yakub berkata dalam hatinya, “Mudah-mudahan dengan hadiah ini, Esau akan memaafkan aku sebelum kami bertemu, dan dia akan menerimaku dengan baik.” ");
INSERT INTO ind_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Demikianlah Yakub mengirimkan hadiah-hadiah itu terlebih dahulu kepada Esau, sementara dia sendiri bermalam di perkemahan. ");
INSERT INTO ind_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Malam itu, Yakub segera mengantar seluruh keluarganya untuk menyeberangi sungai Yabok, termasuk kedua istrinya, kedua budak istrinya, serta kesebelas anaknya. ");
INSERT INTO ind_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sesudah keluarganya tiba di seberang, Yakub juga menyuruh para budaknya untuk membawa seluruh miliknya ke seberang mendahului dia. ");
INSERT INTO ind_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakub tinggal sendirian di tempat dia berkemah tadi. Lalu datanglah seorang laki-laki dan bergulat dengan Yakub sampai fajar tiba. ");
INSERT INTO ind_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ketika orang itu sadar bahwa dia tidak bisa mengalahkan Yakub, dia memukul pangkal paha Yakub hingga terkilir. ");
INSERT INTO ind_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kemudian laki-laki itu berkata, “Biarkanlah saya pergi karena fajar sudah tiba.” Tetapi Yakub menjawab, “Tidak! Saya tidak akan melepaskan engkau sampai engkau memberkati saya!” ");
INSERT INTO ind_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Laki-laki itu bertanya, “Siapa namamu?” Jawabnya, “Yakub.” ");
INSERT INTO ind_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kata orang itu kepadanya, “Namamu tidak lagi disebut Yakub. Aku memberikan nama baru kepadamu, yaitu Israel, karena kamu sudah menang dalam perjuangan menghadapi manusia dan pergulatan dengan Allah.” ");
INSERT INTO ind_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Lalu Yakub bertanya, “Siapakah nama-Mu?” Tetapi jawab Orang itu, “Kamu tidak perlu tahu nama-Ku.” Dia pun memberkati Yakub di situ. ");
INSERT INTO ind_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakub menamai tempat itu Peniel, karena dia sudah bertatapan muka dengan Allah secara langsung dan dia masih hidup. ");
INSERT INTO ind_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Matahari sudah terbit ketika Yakub meninggalkan Peniel, dan Yakub pincang akibat pangkal pahanya yang terkilir. ");
INSERT INTO ind_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Itulah sebabnya sampai sekarang orang Israel tidak makan daging yang menutupi sendi pangkal paha, sebagai peringatan akan kejadian yang sudah dialami Yakub malam itu. ");
INSERT INTO ind_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Dari jauh, Yakub melihat Esau dengan empat ratus anak buahnya mulai mendekat ke arah mereka. Maka dia membagi keluarganya menjadi empat kelompok: Lea dengan anak-anaknya, Rahel dengan anaknya, dan kedua budak perempuannya dengan anak-anak mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakub menempatkan kelompok dua budak perempuannya bersama anak-anak mereka paling depan. Di belakang mereka adalah kelompok Lea bersama anak-anaknya, dan di barisan paling belakang, dia menempatkan Rahel dan Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakub sendiri berjalan di depan mereka semua. Sambil mendekati kakaknya, Yakub bersujud tujuh kali untuk menghormati Esau. ");
INSERT INTO ind_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tetapi Esau berlari menghampiri Yakub, lalu memeluk dan menciumnya. Mereka pun bertangis-tangisan. ");
INSERT INTO ind_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ketika Esau melihat para perempuan dan anak-anak di belakang Yakub, dia bertanya, “Siapa orang-orang yang bersamamu itu?” Jawab Yakub, “Mereka adalah anak-anak yang sudah Allah karuniakan kepada hambamu ini.” ");
INSERT INTO ind_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kedua budak perempuan itu beserta anak-anak mendekat. Mereka bersujud untuk menghormati Esau. ");
INSERT INTO ind_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kemudian Lea bersama anak-anaknya mendekat dan bersujud untuk menghormati Esau. Demikian juga Rahel dan Yusuf melakukan hal yang sama kepada Esau. ");
INSERT INTO ind_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau berkata, “Apa maksudmu dengan kelompok-kelompok yang aku temui dalam perjalanan menuju ke sini?” Yakub menjawab, “Untuk mendapatkan kebaikan hati Tuan, supaya Tuan mau menerima aku.” ");
INSERT INTO ind_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kata Esau, “Adikku, aku sudah berkecukupan, biarlah apa yang kamu miliki itu tetap menjadi milikmu!” ");
INSERT INTO ind_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tetapi jawab Yakub, “Jangan! Kalau memang Tuan sudah berbaik hati dan mau menerima aku kembali, mohon terimalah pemberianku. Aku sangat senang melihat wajah Tuan lagi, rasanya seperti sedang melihat wajah Allah. ");
INSERT INTO ind_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tolong terimalah pemberian yang aku bawa ini, karena Allah sudah sangat berbaik hati kepadaku dan memberikan segala sesuatu yang aku perlukan.” Yakub terus memohon sampai akhirnya Esau mau menerima pemberian itu. ");
INSERT INTO ind_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau berkata, “Mari kita teruskan perjalanan ini. Biarlah aku berjalan di depanmu, dan orang-orangku akan mendampingimu untuk menunjukkan jalan.” ");
INSERT INTO ind_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tetapi Yakub menjawab, “Tuan pasti maklum bahwa anak-anak ini masih lemah, dan kami juga membawa beberapa induk sapi, domba, dan kambing yang masih menyusui. Kalau mereka harus berjalan jauh selama satu hari saja, semua kawanan ternak itu akan mati. ");
INSERT INTO ind_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Biarlah Tuan berjalan lebih dulu. Kami akan menyusul pelan-pelan, agar sapi dan ternak lainnya selamat dan anak-anak tidak terlalu lelah, sampai kami bertemu dengan Tuan di Seir.” ");
INSERT INTO ind_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kata Esau lagi, “Kalau begitu, biarlah aku meninggalkan beberapa anak buahku untuk berjalan bersamamu.” Jawab Yakub, “Tidak usah, Tuan! Aku sudah sangat senang bisa mendapat kebaikan hati Tuan yang begitu besar.” ");
INSERT INTO ind_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Maka pada hari itu juga, Esau kembali ke Seir, ");
INSERT INTO ind_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","sedangkan Yakub berjalan menuju Sukot. Di Sukot, Yakub membangun sebuah rumah bagi keluarganya dan membuat beberapa kandang bagi ternaknya. Itulah sebabnya tempat itu dinamai Sukot. ");
INSERT INTO ind_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Beberapa waktu sesudah Yakub dan keluarganya berangkat dari Padan Aram, mereka tiba dengan selamat di kota Sikem di negeri Kanaan. Lalu mereka mendirikan kemah di dekat kota itu. ");
INSERT INTO ind_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yakub membeli tanah tempat mereka berkemah dari keluarga Hemor, ayah Sikem, seharga seratus keping perak. ");
INSERT INTO ind_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Di situ, Yakub mendirikan mezbah dan menamainya Allah Israel Berkuasa. ");
INSERT INTO ind_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pada suatu hari, Dina, anak perempuan Lea dan Yakub, keluar untuk menemui perempuan-perempuan di daerah itu. ");
INSERT INTO ind_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Seseorang bernama Sikem melihat Dina dan memaksa gadis itu ikut bersamanya, lalu memperkosa dia. Sikem adalah anak Hemor, kepala suku Hewi. ");
INSERT INTO ind_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tetapi Sikem tertarik dan jatuh cinta kepada Dina. Karena itu, dia berusaha merayu Dina untuk mengambil hatinya. ");
INSERT INTO ind_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Lalu Sikem berkata kepada ayahnya, “Ayah, aku ingin menikahi perempuan muda itu. Tolong Ayah melamarkan dia untukku!” ");
INSERT INTO ind_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sewaktu Yakub mendengar berita bahwa Sikem sudah mencabuli Dina, semua anak laki-lakinya sedang menggembalakan ternak di padang. Karena itu, Yakub belum mengambil tindakan apa-apa. Dia menunggu sampai anak-anaknya pulang. ");
INSERT INTO ind_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sementara itu, Hemor, ayah Sikem, pergi menemui Yakub untuk berbicara dengannya. ");
INSERT INTO ind_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Namun, ketika semua anak laki-laki Yakub mendengar apa yang sudah terjadi, mereka langsung pulang. Mereka sangat marah atas perbuatan Sikem yang sudah mempermalukan keluarga Israel dengan meniduri saudara perempuan mereka. ");
INSERT INTO ind_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Lalu Hemor berkata kepada mereka semua, “Sikem, anak saya, sangat menyukai Dina, anak perempuan keluarga kalian. Karena itu, saya mohon persetujuan kalian supaya dia bisa menikahi Dina. ");
INSERT INTO ind_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kalian dapat menikah dengan anak-anak perempuan kami, dan izinkanlah kami menikahi anak-anak perempuan kalian. ");
INSERT INTO ind_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kalian dapat menetap bersama kami. Wilayah ini terbuka bagi kalian. Tinggallah di sini dan berdaganglah dengan bebas. Kalian dapat memiliki tanah di sini.” ");
INSERT INTO ind_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikem berkata kepada ayah dan saudara-saudara Dina, “Saya memohon agar kalian mau bermurah hati dan memenuhi permintaan saya. Sebaliknya, apa pun yang kalian minta akan saya berikan. ");
INSERT INTO ind_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Saya akan menyanggupi segala sesuatu yang kalian minta sebagai mas kawin, tetapi saya mohon, berikanlah anak perempuanmu kepada saya sebagai istri.” ");
INSERT INTO ind_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Karena Sikem sudah menodai Dina, saudara mereka, maka semua anak Yakub menjawab Sikem dan Hemor dengan tipu muslihat. ");
INSERT INTO ind_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kata mereka, “Kami tidak mungkin memberikan adik kami kepada seorang laki-laki yang belum disunat, karena hal seperti itu akan mempermalukan kami. ");
INSERT INTO ind_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kami hanya bisa setuju dengan satu syarat: Kalian harus menjadi sama dengan kami, yaitu semua laki-laki di antara kalian disunat. ");
INSERT INTO ind_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Bila kalian melakukan itu, kami bersedia memberikan anak-anak perempuan kami untuk dinikahi, dan mengambil anak-anak perempuan kalian untuk diperistri. Kami akan menetap di antara kalian sehingga kita menjadi satu bangsa. ");
INSERT INTO ind_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Namun, jika kalian tidak setuju dengan persyaratan kami, maka kami akan pindah dari daerah ini dengan membawa adik kami.” ");
INSERT INTO ind_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor dan Sikem merasa senang dengan persyaratan itu. ");
INSERT INTO ind_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikem, anak yang paling dihormati di antara kaum keluarganya, tidak menunggu lagi dan segera melaksanakan permintaan itu, karena dia sangat menginginkan Dina. ");
INSERT INTO ind_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Maka Hemor dan Sikem pergi ke pintu gerbang kota lalu berkata kepada para pemimpin kota itu, ");
INSERT INTO ind_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Orang-orang ini tidak ada perselisihan dengan kita. Biarkanlah mereka menetap di sini dan berdagang, karena sesungguhnya, tanah ini cukup luas untuk menampung mereka. Kita akan menikah dengan perempuan-perempuan mereka, dan sebaliknya mereka pun dapat menikah dengan perempuan-perempuan kita. ");
INSERT INTO ind_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Namun, ada satu persyaratan yang mereka ingin kita penuhi untuk mempersatukan kita sebagai satu bangsa. Setiap laki-laki di antara kita harus disunat sama seperti mereka. ");
INSERT INTO ind_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Jika kita melakukannya, pastilah hewan ternak, harta benda, dan semua binatang mereka yang lain akan menjadi milik kita. Karena itu, marilah kita penuhi permintaan mereka agar kita dapat hidup bersama.” ");
INSERT INTO ind_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Semua pemimpin yang berkumpul di gerbang kota setuju dengan perkataan Hemor dan Sikem. Jadi, setiap laki-laki di kota itu disunat. ");
INSERT INTO ind_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tetapi pada hari ketiga, ketika orang-orang yang disunat itu masih kesakitan, dua anak Yakub yakni Simeon dan Lewi— yang adalah kakak kandung Dina— membawa pedang mereka dan menyerang kota itu secara tiba-tiba serta membantai semua laki-laki di sana. ");
INSERT INTO ind_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Mereka juga membunuh Hemor dan Sikem, lalu membawa Dina pulang dari rumah Sikem. ");
INSERT INTO ind_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Sesudah pembantaian itu, anak-anak Yakub yang lain menjarah kota sebagai pembalasan karena saudara perempuan mereka sudah dinodai. ");
INSERT INTO ind_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Mereka mengambil semua ternak domba, sapi, dan keledai, juga segala sesuatu yang ada di dalam kota maupun di ladang-ladang sekitarnya. ");
INSERT INTO ind_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Mereka mengambil semua kekayaan dan harta benda dari rumah-rumah, serta menawan anak-anak kecil dan para perempuan. ");
INSERT INTO ind_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakub berkata kepada Simeon dan Lewi, “Kalian sudah membawa malapetaka bagiku dengan membusukkan nama baikku di mata orang Kanaan, Feris, dan semua penduduk negeri ini. Mereka akan bersatu menyerang keluarga kita yang jumlahnya sedikit, dan kita akan binasa.” ");
INSERT INTO ind_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tetapi jawab Simeon dan Lewi, “Pantaskah dia memperlakukan adik kita seperti pelacur?” ");
INSERT INTO ind_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Allah berkata kepada Yakub, “Bersiaplah dan kembalilah ke Betel, di mana Aku berjumpa denganmu pada waktu kamu melarikan diri dari kakakmu Esau. Buatlah sebuah mezbah untuk-Ku di tempat itu, dan tinggallah di sana.” ");
INSERT INTO ind_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Maka Yakub berkata kepada seluruh anggota keluarganya dan semua orang yang bersama-sama dengan dia, “Singkirkanlah semua patung berhala asing yang ada padamu. Bersihkanlah diri kalian, lalu kenakan pakaian yang bersih juga. ");
INSERT INTO ind_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Marilah kita bersiap-siap pergi ke Betel. Di sana, aku hendak mendirikan mezbah untuk Allah, yang selalu menolongku saat aku kesulitan dan selalu menyertaiku ke mana pun aku pergi.” ");
INSERT INTO ind_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Lalu mereka menyerahkan kepada Yakub semua patung berhala asing yang ada pada mereka, juga anting-anting di telinga mereka. Yakub mengubur semua benda itu di bawah sebuah pohon besar dekat kota Sikem. ");
INSERT INTO ind_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pada waktu Yakub dan rombongan keluarganya berangkat, Allah mendatangkan rasa takut yang hebat atas seluruh penduduk kota-kota sekitar, sehingga tidak ada seorang pun yang berani mengejar mereka. ");
INSERT INTO ind_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Keluarga Yakub tiba di tempat bernama Lus, yang disebut Betel, di Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Di sana, Yakub membuat sebuah mezbah dan menamai tempat itu El Betel, karena di situlah Allah sudah menjumpainya ketika dia lari dari Esau, kakaknya. ");
INSERT INTO ind_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Di tempat itu jugalah Debora, pengasuh Ribka, meninggal dunia. Dia dikuburkan di bawah pohon besar yang di dataran rendah dekat Betel. Sejak saat itu, pohon tersebut dinamai Alon Bakut. ");
INSERT INTO ind_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Saat Yakub kembali dari Padan Aram, Allah menjumpai dia lagi dan memberkatinya. ");
INSERT INTO ind_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kata Allah kepadanya, “Namamu memang Yakub, tetapi mulai sekarang Aku memberi nama baru kepadamu. Kamu akan dikenal dengan nama Israel. ");
INSERT INTO ind_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Aku, Allah Yang Mahakuasa, memberkatimu supaya kamu beranak cucu hingga menjadi banyak. Bangsa-bangsa akan lahir dari keturunanmu dan kamu akan menjadi leluhur para raja. ");
INSERT INTO ind_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tanah yang sudah Aku berikan kepada Abraham dan Isak, akan Aku berikan kepadamu dan keturunanmu.” ");
INSERT INTO ind_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Sesudah Allah selesai berbicara kepada Yakub, Dia kembali ke surga. ");
INSERT INTO ind_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Lalu Yakub mendirikan sebuah batu sebagai peringatan bahwa di tempat itulah Allah sudah berbicara kepadanya. Yakub menuangkan persembahan air anggur dan minyak zaitun di atas batu tersebut. ");
INSERT INTO ind_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakub menamai tempat itu Betel, karena di situ Allah sudah berbicara kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kemudian mereka meninggalkan Betel dan melanjutkan perjalanan menuju Efrata. Tetapi sebelum tiba di Efrata, Rahel merasakan sakit menjelang persalinan. Dan persalinannya pun sangat sulit. ");
INSERT INTO ind_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Pada titik paling berat dalam persalinannya itu, bidan berkata kepadanya, “Jangan takut, karena kamu melahirkan seorang anak laki-laki.” ");
INSERT INTO ind_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Sambil menghembuskan nafas terakhirnya, Rahel menamai anaknya yang baru lahir itu Ben Oni, tetapi Yakub menamainya Benyamin. ");
INSERT INTO ind_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Sesudah Rahel meninggal, dia dikuburkan di suatu tempat di jalan menuju Efrata, yang juga disebut Betlehem. ");
INSERT INTO ind_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakub mendirikan sebuah batu peringatan di kuburannya, dan batu itu masih ada sampai kitab ini ditulis. ");
INSERT INTO ind_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Sesudah itu, Yakub meneruskan perjalanan sampai di bagian selatan menara Eder dan mendirikan kemahnya di sana. ");
INSERT INTO ind_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sewaktu Yakub tinggal di sana, Ruben tidur dengan Bilha, budak Rahel yang diperistri Yakub. Berita itu pun sampai kepada Yakub. Inilah kedua belas anak laki-laki Yakub: ");
INSERT INTO ind_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Anak-anaknya dari Lea adalah Ruben (anak sulung), Simeon, Lewi, Yehuda, Isakar, dan Zebulon. ");
INSERT INTO ind_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Anak-anaknya dari Rahel adalah Yusuf dan Benyamin. ");
INSERT INTO ind_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Anak-anaknya dari Bilha, budak Rahel, adalah Dan serta Naftali. ");
INSERT INTO ind_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Anak-anaknya dari Zilpa, budak Lea, adalah Gad dan Asyer. Itulah semua anak laki-laki Yakub yang lahir di Padan Aram. ");
INSERT INTO ind_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakub kembali kepada Isak, ayahnya, di Mamre yang juga disebut Kiryat Arba dan sekarang dikenal dengan nama Hebron. Kakeknya (Abraham) dahulu menetap di sana juga. ");
INSERT INTO ind_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak meninggal pada usia yang sangat tua, 180 tahun. Lalu TUHAN menempatkan dia bersama dengan nenek moyangnya yang sudah meninggal dunia. Esau dan Yakub menguburkan dia. ");
INSERT INTO ind_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Berikut ini adalah keturunan Esau, yang juga disebut Edom. ");
INSERT INTO ind_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esau menikah dengan dua perempuan Kanaan dan seorang dari kaum Ismael. Istri pertama bernama Adah (anak Elon, orang Het). Istri kedua bernama Oholibama (anak Anah dan cucu Zibeon, orang Hewi). Istri ketiga bernama Basmat (anak Ismael). Basmat adalah adik Nebayot. ");
INSERT INTO ind_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Ketiga istri Esau melahirkan lima anak laki-laki baginya di Kanaan. Adah melahirkan Elifas. Basmat melahirkan Rehuel. Dan Oholibama melahirkan tiga anak bernama Yeus, Yalam, dan Korah. ");
INSERT INTO ind_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Esau dan Yakub memiliki banyak harta dan ternak. Karena ternak mereka terlalu banyak, lahan tempat tinggal mereka tidak cukup untuk memenuhi kebutuhan ternak-ternak itu. Jadi, Esau (yang juga disebut Edom) pergi meninggalkan Yakub dengan membawa ketiga istrinya, anak-anaknya, dan semua orang yang tinggal bersamanya, juga semua kawanan ternak dan seluruh harta benda yang dia peroleh selama di Kanaan. Mereka pindah ke negeri yang jauh, di daerah pegunungan Seir. ");
INSERT INTO ind_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Inilah daftar keturunan Esau, bapak dari orang-orang Edom di daerah pegunungan Seir. ");
INSERT INTO ind_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Anaknya dari Adah bernama Elifas. Anaknya dari Basmat bernama Rehuel. ");
INSERT INTO ind_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas mempunyai lima anak laki-laki bernama Teman, Omar, Sefo, Gatam, dan Kenas. ");
INSERT INTO ind_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas juga mempunyai seorang anak laki-laki bernama Amalek dari gundiknya yang bernama Timna. Itulah keenam cucu Adah, istri Esau yang pertama. ");
INSERT INTO ind_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rehuel mempunyai empat anak laki-laki bernama Nahat, Serah, Syama, dan Miza. Itulah keempat cucu Basmat, istri Esau yang ketiga. ");
INSERT INTO ind_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dari istri Esau yang bernama Oholibama, yaitu anak Anah dan cucu Zibeon, Esau memperoleh tiga anak laki-laki bernama Yeus, Yalam, dan Korah. ");
INSERT INTO ind_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Berikut adalah nama-nama kepala suku keturunan Esau: Elifas, anak sulung Esau, mempunyai anak-anak bernama Teman, Omar, Sefo, Kenas, Korah, Gatam, dan Amalek. Mereka menjadi kepala-kepala suku keturunan Esau dari Adah yang berkuasa di Edom. Setiap suku dinamai sesuai dengan nama mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rehuel, anak kedua Esau, mempunyai anak-anak bernama Nahat, Serah, Syama, dan Miza. Mereka menjadi kepala-kepala suku keturunan Esau dari Basmat. Setiap suku dinamai sesuai dengan nama mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yeus, Yalam, dan Korah, yaitu ketiga anak Esau dari Oholibama (yang adalah anak Anah), menjadi kepala-kepala atas suku-suku yang dinamai sesuai dengan nama mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Demikianlah daftar nama anak laki-laki Esau, yang juga disebut Edom. Mereka adalah nenek moyang dari masing-masing suku mereka. ");
INSERT INTO ind_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Berikut ini adalah anak-anak Seir, orang Hori: Lotan, Syobal, Zibeon, Ana, Disyon, Ezer, dan Disyan. Mereka menjadi kepala-kepala suku penduduk asli di daerah itu. ");
INSERT INTO ind_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan mempunyai dua anak laki-laki, yaitu Hori dan Hemam. Lotan juga mempunyai saudara perempuan bernama Timna. ");
INSERT INTO ind_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Syobal mempunyai lima anak laki-laki, yaitu Alwan, Manahat, Ebal, Syefo, dan Onam. ");
INSERT INTO ind_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon mempunyai dua anak laki-laki, yaitu Aya dan Ana. Ana inilah yang menemukan sumber mata air panas di padang belantara ketika dia sedang menggembalakan keledai-keledai milik ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana mempunyai seorang anak laki-laki bernama Disyon dan seorang anak perempuan bernama Oholibama. ");
INSERT INTO ind_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disyon mempunyai empat anak laki-laki bernama Hemdan, Esban, Yitran, dan Keran. ");
INSERT INTO ind_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer mempunyai tiga anak laki-laki bernama Bilhan, Zaawan, dan Akan. ");
INSERT INTO ind_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyan mempunyai dua anak laki-laki, yaitu Us dan Aran. ");
INSERT INTO ind_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Itulah nama-nama kepala suku orang Hori. Mereka mendiami tanah Seir. Masing-masing suku dinamai sesuai nama kepala suku mereka, yaitu suku Lotan, Syobal, Zibeon, Ana, Disyon, Ezer, dan Disyan. ");
INSERT INTO ind_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Sebelum ada raja yang memerintah bangsa Israel, raja-raja berikut ini sudah lebih dulu memerintah di negeri Edom. Mereka memerintah sebagai raja sampai akhir hidup mereka. Berikut ini nama-nama mereka secara berurutan: Bela anak Beor dari kota Dinhaba, Yobab anak Serah dari kota Bosra, Husyam dari daerah Teman, Hadad anak Bedad dari kota Awit, dialah yang mengalahkan orang Midian di negeri Moab, Samla dari kota Masreka, Saul dari kota Rehobot Dekat Sungai, Baal Hanan anak Akbor, dan Hadad dari kota Pau. Istri Hadad bernama Mehetabel, yaitu anak Matred dan cucu Mezahab. ");
INSERT INTO ind_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Berikut ini adalah nama-nama kepala suku Edom, yaitu suku-suku dari keturunan Esau: Timna, Alfa, Yetet, Oholibama, Elah, Pinon, Kenas, Teman, Mibsar, Magdiel, dan Iram. Nama-nama mereka menjadi nama suku di wilayah tempat tinggal mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub tinggal di Kanaan, tempat ayahnya dahulu menetap. ");
INSERT INTO ind_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Inilah riwayat keturunan Yakub. Pada waktu Yusuf berusia tujuh belas tahun, dia biasa menggembalakan kawanan kambing domba milik ayahnya bersama kakak-kakak tirinya, yaitu anak-anak Yakub dari Bilha dan Zilpa. Suatu hari, Yusuf melaporkan kepada ayahnya tentang berbagai kenakalan yang dilakukan kakak-kakaknya. ");
INSERT INTO ind_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Adapun Yakub lebih menyayangi Yusuf daripada anak-anaknya yang lain karena Yusuf lahir pada hari tuanya. Yakub menyuruh orang untuk membuatkan jubah yang indah berwarna-warni sebagai hadiah istimewa untuk Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ketika kakak-kakaknya menyadari bahwa ayah mereka lebih sayang kepada Yusuf, mereka pun membenci Yusuf dan tidak mau lagi berbicara baik-baik dengan dia. ");
INSERT INTO ind_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kebencian mereka semakin menjadi-jadi ketika Yusuf menceritakan mimpinya kepada mereka. ");
INSERT INTO ind_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Begini kata Yusuf, “Dengarkanlah, aku ingin menceritakan mimpiku. ");
INSERT INTO ind_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Dalam mimpiku, kita sedang bekerja bersama-sama mengikat gandum di ladang. Tiba-tiba ikatan gandumku berdiri, dan ikatan-ikatan gandum kalian mengelilingi dan bersujud kepada ikatan gandumku.” ");
INSERT INTO ind_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Jawab kakak-kakaknya, “Jadi, kamu pikir kamu akan memerintah dan berkuasa atas kami?!” Mereka pun semakin membenci Yusuf karena mimpi dan perkataannya itu. ");
INSERT INTO ind_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kemudian Yusuf bermimpi lagi, dan dia menceritakannya kembali kepada kakak-kakaknya, “Aku bermimpi lagi. Dalam mimpi itu, aku melihat matahari, bulan, dan sebelas bintang bersujud kepadaku.” ");
INSERT INTO ind_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ketika Yusuf menceritakan mimpinya itu kepada ayahnya, dia ditegur, “Mimpi apa lagi yang kamu mimpikan ini?! Kamu pikir aku, ibumu, dan saudara-saudaramu akan datang bersujud kepadamu?!” ");
INSERT INTO ind_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kakak-kakaknya semakin iri kepada Yusuf, tetapi Yakub merenungkan perkataan dan arti dari mimpi itu. ");
INSERT INTO ind_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Pada suatu hari, ketika kakak-kakak Yusuf sedang menggembalakan kawanan kambing domba di Sikem, ");
INSERT INTO ind_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yakub berkata kepada Yusuf, “Pergilah ke Sikem. Kakak-kakakmu sedang menggembalakan kawanan kambing domba di sana.” Jawab Yusuf, “Ya Ayah, aku akan pergi!” ");
INSERT INTO ind_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Lanjut Yakub, “Lihatlah bagaimana keadaan kakak-kakakmu dan kawanan kambing domba kita, lalu kembalilah dan laporkan kepada ayah.” Demikianlah Yakub menyuruh Yusuf pergi meninggalkan Lembah Hebron. Sesampainya Yusuf di Sikem, ");
INSERT INTO ind_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","dia berjalan ke sana kemari mencari kakak-kakaknya di padang. Seseorang melihat dia dan bertanya, “Kamu sedang mencari apa?” ");
INSERT INTO ind_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Jawab Yusuf, “Saya mencari kakak-kakak saya yang sedang menggembalakan ternak. Apakah kamu melihat mereka dan tahu ke mana mereka pergi?” ");
INSERT INTO ind_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Jawab orang itu, “Mereka sudah pergi. Saya mendengar mereka berkata, ‘Ayo kita ke Dotan.’” Maka Yusuf menyusul saudara-saudaranya dan menemukan mereka di Dotan. ");
INSERT INTO ind_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ketika kakak-kakaknya melihat Yusuf dari jauh, mereka bersepakat untuk membunuhnya. ");
INSERT INTO ind_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kata mereka satu sama lain, “Lihat, si tukang mimpi datang! ");
INSERT INTO ind_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ayo kita bunuh dia, dan mayatnya kita buang ke dalam sumur kosong. Nanti kita katakan saja bahwa dia diterkam dan dimakan binatang buas. Kita lihat akan jadi apa mimpinya itu!” ");
INSERT INTO ind_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Ketika Ruben mendengar rencana itu, dia berkata, “Janganlah kita membunuhnya.” Ruben berniat menyelamatkan Yusuf dari tangan mereka dan membawa dia pulang kepada ayah mereka. Lanjut Ruben, “Jangan menumpahkan darah. Buang saja dia ke dalam sumur kosong di padang belantara ini, tetapi tidak usah menyakitinya.” ");
INSERT INTO ind_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Maka ketika Yusuf sampai kepada kakak-kakaknya, dengan kasar mereka langsung merenggut jubah Yusuf yang berwarna-warni itu ");
INSERT INTO ind_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","dan membuang Yusuf ke dalam sumur yang kosong. ");
INSERT INTO ind_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Sesudah itu, mereka duduk untuk makan. Tak lama kemudian, tampaklah di kejauhan rombongan pedagang orang Ismael yang datang dari daerah Gilead menuju Mesir. Mereka menuntun unta-unta yang mengangkut tiga jenis wangi-wangian dari getah pohon. ");
INSERT INTO ind_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Lalu Yehuda berkata kepada saudara-saudaranya, “Apa untungnya kalau kita membunuh Yusuf dan menyembunyikan mayatnya? ");
INSERT INTO ind_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bagaimana kalau kita menjual dia kepada pedagang-pedagang itu? Dengan begitu, kita tidak membunuhnya, karena dia saudara kita dan satu ayah dengan kita.” Saudara-saudaranya pun setuju. ");
INSERT INTO ind_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Jadi, pada waktu pedagang-pedagang Midian yang adalah orang Ismael itu lewat, mereka mengeluarkan Yusuf dari sumur dan menjualnya kepada pedagang-pedagang itu seharga dua puluh keping perak. Lalu pedagang-pedagang itu membawa Yusuf ke Mesir. ");
INSERT INTO ind_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ketika Ruben kembali ke sumur dan melihat bahwa Yusuf sudah tidak ada, dia merobek pakaiannya karena sangat menyesal. ");
INSERT INTO ind_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Lalu dia kembali kepada saudara-saudaranya dan berkata, “Anak itu sudah tidak ada di sumur! Apa yang harus aku lakukan?!” ");
INSERT INTO ind_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mereka lalu membunuh seekor kambing dan mencelupkan jubah Yusuf ke dalam darah kambing itu. ");
INSERT INTO ind_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Mereka membawa jubah itu kepada ayah mereka dan berkata, “Kami menemukan ini. Periksalah. Apakah jubah ini milik anakmu?” ");
INSERT INTO ind_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakub mengenali jubah itu dan berkata, “Benar, ini jubah anakku Yusuf. Pasti binatang buas sudah mencabik-cabik dia sampai mati dan memakannya!” ");
INSERT INTO ind_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakub merobek-robek pakaiannya tanda berduka dan mengikat kain karung pada pinggangnya. Dia berkabung untuk anaknya itu selama berhari-hari. ");
INSERT INTO ind_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Semua anak Yakub yang lain, baik perempuan maupun laki-laki, berusaha menghibur ayah mereka, tetapi dia tidak mau dihibur. Katanya kepada mereka, “Biarkan aku berduka sampai hari aku masuk ke Syeol!” Yakub terus bersedih karena Yusuf, anaknya. ");
INSERT INTO ind_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Sementara itu, di Mesir, para pedagang Midian menjual Yusuf kepada seorang komandan pengawal raja bernama Potifar. ");
INSERT INTO ind_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Pada waktu itu, Yehuda meninggalkan saudara-saudaranya dan tinggal bersama seseorang bernama Hira, orang Adulam. ");
INSERT INTO ind_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Di sana, dia bertemu dengan seorang perempuan Kanaan, anak Syua. Lalu Yehuda menikah dengan dia dan tidur dengannya. ");
INSERT INTO ind_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Perempuan itu mengandung dan melahirkan seorang anak laki-laki. Yehuda menamai anak itu Er. ");
INSERT INTO ind_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sesudah itu, dia mengandung lagi dan melahirkan anak laki-laki, lalu menamai anak itu Onan. ");
INSERT INTO ind_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Beberapa waktu kemudian, ketika Yehuda dan keluarganya sudah pindah dan tinggal di Kesib, perempuan itu mengandung lagi dan melahirkan anak laki-laki. Dia menamai anak itu Syela. ");
INSERT INTO ind_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ketika Er, anak sulung Yehuda, sudah dewasa, Yehuda menikahkan dia dengan seorang perempuan bernama Tamar. ");
INSERT INTO ind_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kelakuan Er sangatlah jahat di mata TUHAN. Maka TUHAN mengambil nyawanya. ");
INSERT INTO ind_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Lalu berkatalah Yehuda kepada Onan, “Penuhilah kewajibanmu kepada istri kakakmu Er, sebagaimana biasanya adat kita. Nikahilah dia sehingga anak laki-laki yang lahir pertama akan menjadi penerus garis keturunan kakakmu.” ");
INSERT INTO ind_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tetapi Onan tahu bahwa dengan berbuat demikian, artinya dia tidak membangun garis keturunan sendiri. Maka setiap kali dia bersetubuh dengan Tamar, dia sengaja menumpahkan air maninya di tanah supaya tidak memberi keturunan bagi kakaknya. ");
INSERT INTO ind_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Perbuatan Onan itu sangat jahat di mata TUHAN. Maka TUHAN mengambil nyawanya juga. ");
INSERT INTO ind_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Karena takut hal yang sama akan terjadi kepada Syela, anak bungsunya, berkatalah Yehuda kepada Tamar, “Pergilah dan tinggallah di rumah orangtuamu sebagai janda sampai Syela dewasa.” Maka Tamar kembali ke rumah orangtuanya. ");
INSERT INTO ind_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Beberapa waktu kemudian, istri Yehuda, anak Syua, meninggal dunia. Sesudah Yehuda melalui masa perkabungannya, dia pergi ke Timna bersama Hira, sahabatnya dari Adulam, untuk mengawasi orang-orang yang bekerja menggunting bulu domba-dombanya. ");
INSERT INTO ind_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar mendapat kabar bahwa Yehuda akan datang ke Timna untuk menggunting bulu domba. ");
INSERT INTO ind_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Saat itu, Tamar mengetahui bahwa Syela sudah dewasa, tetapi tidak dinikahkan dengannya. Karena itu, Tamar mengganti pakaian kejandaannya, menutupi kepala dan wajahnya dengan kerudung sehingga tidak dikenali orang, lalu dia pergi dan duduk di depan gerbang kota Enaim, di pinggir jalan yang menuju ke Timna. ");
INSERT INTO ind_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ketika Yehuda melihat dia, Yehuda mengira bahwa dia seorang pelacur, sebab wajahnya tertutup kerudung. ");
INSERT INTO ind_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Karena tidak tahu bahwa perempuan itu adalah menantunya, Yehuda pun mendekati dia dan berkata, “Mari. Aku mau tidur denganmu.” Jawab Tamar, “Apa imbalannya bagiku?” ");
INSERT INTO ind_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kata Yehuda, “Sebagai imbalan, aku akan memberikan seekor anak kambing.” Lalu kata Tamar, “Jaminan apa yang akan Bapak berikan sebelum aku menerima anak kambing itu?” ");
INSERT INTO ind_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tetapi Yehuda balik bertanya, “Jaminan apa yang kamu inginkan dariku?” Jawab Tamar, “Aku minta cincin meteraimu, juga kalung dan tongkatmu.” Yehuda memenuhi permintaannya. Mereka pun bersetubuh, lalu Tamar mengandung. ");
INSERT INTO ind_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sesudah itu, Tamar pulang dan membuka kerudungnya. Dia kembali mengenakan pakaian kejandaannya. ");
INSERT INTO ind_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Beberapa waktu kemudian, Yehuda meminta sahabatnya Hira, orang Adulam, untuk mengantarkan anak kambing kepada perempuan itu dan mengambil kembali benda-benda miliknya yang dijadikan jaminan. Namun, Hira tidak berhasil menemukan perempuan itu. ");
INSERT INTO ind_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Maka dia bertanya kepada orang-orang di sekitar situ, “Di manakah pelacur yang biasa ada di pinggir jalan yang menuju ke Timna, di depan gerbang kota Enaim?” Jawab mereka, “Di sini tidak ada pelacur seperti itu.” ");
INSERT INTO ind_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Maka Hira kembali dan berkata kepada Yehuda, “Aku tidak menemukan pelacur itu. Aku sudah bertanya kepada orang-orang di sana, tetapi kata mereka, ‘Tidak pernah ada pelacur di sini.’” ");
INSERT INTO ind_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Jawab Yehuda, “Baiklah. Yang penting kita sudah berusaha menepati janji dengan membawa anak kambing imbalannya. Biarlah dia menahan barang-barangku yang dijadikan jaminan, sebab kalau kita terus mencarinya, kita akan menjadi bahan tertawaan orang.” ");
INSERT INTO ind_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kurang lebih tiga bulan kemudian, Yehuda mendapat kabar bahwa menantunya, Tamar, sudah melacurkan diri dan hamil di luar nikah. Maka Yehuda berkata dengan tegas, “Bawalah dia keluar dan bakarlah perempuan itu karena perbuatannya!” ");
INSERT INTO ind_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ketika Tamar dibawa keluar untuk dibunuh, dia menyuruh seseorang untuk menyampaikan pesan kepada Yehuda, mertuanya, “Pemilik cincin meterai, kalung, dan tongkat ini, adalah orang yang menghamiliku. Apakah Bapak mengenali benda-benda ini?” ");
INSERT INTO ind_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kemudian Yehuda memeriksa benda-benda tersebut dan berkata, “Dia yang benar! Saya tidak menepati janji untuk menikahkannya dengan anak saya Syela.” Lalu Yehuda tidak pernah lagi tidur dengannya. ");
INSERT INTO ind_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ketika tiba waktunya Tamar bersalin, ternyata dia melahirkan anak kembar. ");
INSERT INTO ind_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Dalam kesakitan karena persalinannya itu, salah satu bayi mengeluarkan tangannya. Maka bidan yang membantu persalinan Tamar mengikatkan benang merah pada tangan bayi itu. Kata bidan itu, “Bayi inilah yang lahir duluan.” ");
INSERT INTO ind_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tetapi bayi itu menarik kembali tangannya dan bayi yang lain keluar lebih dulu. Lalu bidan itu berkata, “Bagaimana kamu bisa keluar duluan?!” Maka anak laki-laki itu dinamai Peres. ");
INSERT INTO ind_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Sesudah itu, barulah lahir bayi laki-laki yang ada benang merah di tangannya. Dia dinamai Zerah. ");
INSERT INTO ind_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Sementara itu, Yusuf sudah dibawa ke Mesir oleh para pedagang orang Ismael dan dijual kepada Potifar, komandan pengawal raja Mesir. ");
INSERT INTO ind_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tetapi TUHAN menyertai Yusuf selama dia bekerja sebagai budak orang Mesir itu, sehingga dia selalu berhasil dalam semua pekerjaannya. ");
INSERT INTO ind_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar melihat bahwa TUHAN membuat Yusuf mengerjakan seluruh pekerjaannya dengan baik. ");
INSERT INTO ind_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Karena itu dia senang kepada Yusuf dan menunjuk dia sebagai pelayan pribadi untuk menangani urusan rumahnya dan mengelola segala miliknya. ");
INSERT INTO ind_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sejak Yusuf mengurus segala sesuatu yang dipercayakan Potifar kepadanya, TUHAN semakin memberkati keluarga orang Mesir itu. TUHAN memberkati segala miliknya, baik di rumah maupun di ladang. ");
INSERT INTO ind_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar mempercayakan segala miliknya kepada Yusuf sepenuhnya. Dengan demikian dia hanya perlu mengurus urusan pribadinya sendiri. Yusuf bertubuh kekar dan dia sangat tampan. ");
INSERT INTO ind_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Seiring berjalannya waktu, istri Potifar mulai menaruh hati pada Yusuf, dan dia berkata, “Marilah tidur denganku.” ");
INSERT INTO ind_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tetapi Yusuf menolak istri majikannya itu. Kata Yusuf, “Tuan Potifar sudah mempercayakan segala miliknya kepada saya. ");
INSERT INTO ind_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tidak ada orang lain di dalam rumah ini yang diberi kuasa sebesar saya. Tuan sudah mempercayakan semuanya kepada saya, kecuali Nyonya, karena Nyonya adalah istrinya. Bagaimana mungkin saya berdosa terhadap Allah dengan melakukan perbuatan sejahat ini!” ");
INSERT INTO ind_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hari demi hari, istri Potifar berulang kali mengajak Yusuf tidur dengannya, tetapi Yusuf tetap pada pendiriannya dan menolak setiap ajakannya. ");
INSERT INTO ind_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pada suatu hari, Yusuf sedang melakukan tugas-tugasnya dan kebetulan tidak ada pekerja lain di rumah. ");
INSERT INTO ind_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Istri Potifar menarik pakaian Yusuf dan berkata, “Ayolah, tidurlah denganku!” Yusuf berhasil melarikan diri, tetapi pakaiannya tertinggal dalam genggaman istri Potifar. ");
INSERT INTO ind_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ketika perempuan itu melihat Yusuf sudah melarikan diri dengan meninggalkan pakaiannya, ");
INSERT INTO ind_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","dia berteriak memanggil para pekerjanya di luar, “Lihatlah, orang Ibrani yang dibawa suamiku ke rumah ini sudah meremehkan kita! Dia baru saja berusaha memperkosaku! Karena itulah aku berteriak. ");
INSERT INTO ind_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ketika dia mendengar aku berteriak, dia melarikan diri dan pakaiannya tertinggal.” ");
INSERT INTO ind_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Istri Potifar membiarkan pakaian Yusuf di sampingnya sampai suaminya pulang. ");
INSERT INTO ind_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ketika suaminya datang, dia berkata, “Budak Ibrani yang kamu bawa ke rumah ini hendak mempermalukanku. ");
INSERT INTO ind_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ketika aku berteriak, dia melarikan diri dan meninggalkan pakaiannya. ");
INSERT INTO ind_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Rupanya beginilah kelakuan budakmu terhadapku!” Mendengar cerita istrinya itu, Potifar sangat marah. ");
INSERT INTO ind_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifar pun melemparkan Yusuf ke dalam penjara tempat tahanan raja. ");
INSERT INTO ind_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Namun, TUHAN menyertai Yusuf dan setia mengasihinya. TUHAN membuat kepala penjara terkesan dengan Yusuf, sehingga ");
INSERT INTO ind_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","dia mempercayakan Yusuf tanggung jawab untuk mengurus segala sesuatu yang berkaitan dengan para tahanan lainnya. ");
INSERT INTO ind_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kepala penjara tidak pernah mempertanyakan tugas yang berada dalam tanggung jawab Yusuf, karena Yusuf selalu berhasil dalam segala sesuatu yang dia lakukan, sebab TUHAN menyertainya. ");
INSERT INTO ind_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Waktu pun berlalu. Pada suatu hari, kepala juru minuman dan kepala juru roti di istana membuat kesalahan terhadap raja Mesir. ");
INSERT INTO ind_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Raja sangat marah terhadap kedua pegawai istananya itu ");
INSERT INTO ind_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","dan memerintahkan supaya mereka dimasukkan ke dalam penjara yang diawasi oleh komandan pengawal raja, yakni tempat Yusuf ditahan. ");
INSERT INTO ind_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Komandan pengawal menugaskan Yusuf untuk mengurus kebutuhan dua tahanan itu. Lama mereka dikurung di sana. ");
INSERT INTO ind_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Suatu malam, kepala juru minuman dan kepala juru roti sama-sama bermimpi. Mimpi mereka berbeda dan memiliki arti masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Keesokan harinya, ketika Yusuf bertemu kedua pegawai istana itu, mereka kelihatan sedang bersusah hati. ");
INSERT INTO ind_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Maka Yusuf bertanya kepada mereka, “Mengapa hari ini kalian tampak murung? Ada apa?” ");
INSERT INTO ind_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Jawab mereka, “Tadi malam kami bermimpi, tetapi tidak ada yang bisa mengartikan mimpi-mimpi kami.” Jawab Yusuf, “Hanya Allah yang tahu arti mimpi. Ceritakanlah kepada saya, dan dengan pertolongan-Nya, saya akan menerangkan arti mimpi kalian.” ");
INSERT INTO ind_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Lalu kepala juru minuman menceritakan mimpinya kepada Yusuf, “Dalam mimpi itu, saya melihat ada pohon anggur di depan saya. ");
INSERT INTO ind_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Pohon anggur itu bercabang tiga. Pada ketiga cabangnya tumbuh tunas, kemudian bunga, lalu buah. ");
INSERT INTO ind_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Saat itu saya sedang memegang gelas minum raja. Saya memetik beberapa buah anggur dan memerasnya ke dalam gelas itu, lalu saya hidangkan kepada raja.” ");
INSERT INTO ind_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jawab Yusuf, “Inilah arti mimpimu: Tiga cabang berarti tiga hari. ");
INSERT INTO ind_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dalam tiga hari, raja akan membebaskan dan mengembalikanmu pada jabatan yang dulu. Kamu akan kembali menyajikan minuman kepada raja seperti sebelum kamu dipenjara. ");
INSERT INTO ind_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Namun, waktu kamu sudah bebas nanti dan keadaanmu sudah baik, tolong jangan lupakan saya. Bantulah saya untuk keluar dari penjara ini. Berbaik hatilah kepada saya dengan memberitahu raja tentang saya. ");
INSERT INTO ind_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Dulu, saya diculik dan dibawa paksa dari negeri orang Ibrani. Di sini pun saya dipenjarakan karena tuduhan yang tidak pernah saya lakukan.” ");
INSERT INTO ind_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ketika kepala juru roti melihat bahwa mimpi kepala juru minuman itu memiliki arti yang baik, dia pun berkata kepada Yusuf, “Aku juga bermimpi. Dalam mimpiku, ada tiga keranjang roti di atas kepalaku. ");
INSERT INTO ind_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Keranjang yang paling atas berisi macam-macam roti untuk raja. Tetapi burung-burung datang dan memakannya dari keranjang di atas kepala saya itu.” ");
INSERT INTO ind_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jawab Yusuf, “Inilah arti mimpimu: Tiga keranjang berarti tiga hari. ");
INSERT INTO ind_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dalam tiga hari, raja akan memerintahkan supaya kepalamu dipenggal dan mayatmu digantung pada sebuah tiang. Lalu burung-burung akan memakan dagingmu.” ");
INSERT INTO ind_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tiga hari kemudian adalah hari ulang tahun raja. Dia mengadakan pesta dan mengundang semua pejabatnya. Pada pesta tersebut, raja mengeluarkan kedua pegawainya dari penjara. ");
INSERT INTO ind_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kepala juru minuman dikembalikan kepada jabatannya semula untuk menyajikan anggur kepada raja, ");
INSERT INTO ind_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","sedangkan kepala juru roti dihukum mati. Semua itu terjadi tepat seperti yang dikatakan Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Namun, kepala juru minuman tidak ingat kepada Yusuf. Dia melupakannya. ");
INSERT INTO ind_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dua tahun kemudian, raja Mesir bermimpi bahwa dia sedang berdiri di tepi sungai Nil. ");
INSERT INTO ind_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Dalam mimpinya itu, dia melihat tujuh ekor sapi yang sehat dan gemuk keluar dari sungai Nil lalu memakan rumput di pinggir sungai. ");
INSERT INTO ind_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kemudian tujuh ekor sapi lain yang kurus kering dan buruk rupa keluar juga dari sungai Nil dan berdiri di tepi sungai itu bersama ketujuh sapi yang sehat tadi. ");
INSERT INTO ind_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Lalu ketujuh sapi yang kurus memakan ketujuh sapi yang gemuk. Sesudah itu raja terbangun dari tidurnya. ");
INSERT INTO ind_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Dia kembali tidur dan bermimpi lagi. Dalam mimpinya yang kedua, dia melihat tujuh bulir gandum tumbuh pada satu batang. Ketujuh bulir gandum itu sangat baik dan berisi. ");
INSERT INTO ind_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kemudian dia melihat tujuh bulir gandum lain tumbuh. Yang ini layu dan kurus karena hembusan angin timur yang panas dan kering. ");
INSERT INTO ind_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Lalu ketujuh bulir gandum yang kurus kering itu menelan ketujuh bulir gandum yang baik dan berisi. Raja kembali terbangun dan sadar bahwa itu hanya mimpi. ");
INSERT INTO ind_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Keesokan paginya, raja merasa gelisah. Maka dia memanggil semua ahli sihir dan orang bijaksana di Mesir, lalu menceritakan mimpinya kepada mereka. Namun, tidak seorang pun dapat mengartikan mimpi-mimpi itu. ");
INSERT INTO ind_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kata juru minuman kepada raja, “Hari ini saya teringat kesalahan saya. ");
INSERT INTO ind_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Waktu itu, Tuanku Raja sangat marah kepada beberapa pegawai istana, sehingga saya dan kepala juru roti dimasukkan ke penjara di bawah pengawasan komandan pengawal raja. ");
INSERT INTO ind_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Suatu malam, kami berdua bermimpi dan masing-masing mimpi itu mempunyai arti. ");
INSERT INTO ind_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Di sana ada seorang pemuda Ibrani yang menjadi budak komandan pengawal raja. Kami menceritakan mimpi-mimpi itu kepadanya, dan dia menjelaskan artinya kepada kami. ");
INSERT INTO ind_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Lalu semuanya terjadi seperti yang dia katakan: Saya dikembalikan ke jabatan semula, sedangkan kepala juru roti dihukum mati dan digantung pada tiang.” ");
INSERT INTO ind_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Maka raja memerintahkan agar Yusuf dipanggil. Dengan segera, Yusuf pun dikeluarkan dari penjara. Dia mencukur janggut dan mengenakan pakaian yang bersih, lalu pergi menghadap raja. ");
INSERT INTO ind_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kata raja kepada Yusuf, “Saya bermimpi, tetapi tidak ada seorang pun yang dapat mengartikannya. Saya sudah mendengar bahwa kamu dapat mengartikan mimpi.” ");
INSERT INTO ind_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jawab Yusuf, “Bukan hamba, melainkan Allah yang akan memberikan penjelasan yang tepat bagi Tuanku.” ");
INSERT INTO ind_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Lalu raja menceritakan mimpinya kepada Yusuf, “Dalam mimpi itu, saya berdiri di tepi sungai Nil, ");
INSERT INTO ind_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","dan saya melihat tujuh ekor sapi yang sehat dan gemuk keluar dari sungai Nil lalu memakan rumput di pinggir sungai. ");
INSERT INTO ind_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kemudian tujuh ekor sapi lain yang kurus dan buruk rupa keluar juga dari sungai. Baru kali ini saya melihat sapi sejelek itu di Mesir! ");
INSERT INTO ind_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sapi yang kurus memakan ketujuh sapi yang gemuk. ");
INSERT INTO ind_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tetapi walaupun sudah memakan ketujuh sapi gemuk itu, tetap saja mereka kurus kering. Sesudah itu saya terbangun. ");
INSERT INTO ind_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Kemudian saya tertidur lagi dan kembali bermimpi. Dalam mimpi yang kedua, saya melihat tujuh bulir gandum yang baik dan berisi tumbuh pada satu batang. ");
INSERT INTO ind_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Lalu tumbuhlah tujuh bulir gandum lain yang tampak layu dan kurus karena ditiup angin timur yang panas dan kering. ");
INSERT INTO ind_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ketujuh bulir gandum yang layu itu menelan ketujuh bulir gandum yang baik. “Saya sudah menceritakan mimpi-mimpi ini kepada para ahli sihir, tetapi tidak ada seorang pun yang dapat mengartikannya.” ");
INSERT INTO ind_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jawab Yusuf kepada raja, “Kedua mimpi itu memiliki arti yang sama. Allah sudah memberitahu Baginda apa yang hendak dilakukan-Nya. ");
INSERT INTO ind_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tujuh sapi yang sehat dan tujuh bulir gandum yang baik sama artinya, yaitu tujuh tahun penuh kemakmuran. ");
INSERT INTO ind_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sedangkan tujuh sapi yang kurus kering dan tujuh bulir gandum yang layu karena angin timur berarti tujuh tahun bencana kelaparan. ");
INSERT INTO ind_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Inilah yang saya maksud dengan perkataan tadi, ‘Allah sudah memberitahu Baginda apa yang hendak dilakukan-Nya.’ ");
INSERT INTO ind_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Akan ada tujuh tahun penuh kemakmuran di seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Sesudah itu, selama tujuh tahun kemudian, akan ada bencana kelaparan di negeri ini. Bencana kelaparan itu sedemikian parahnya hingga orang lupa akan masa sebelumnya yang penuh kelimpahan. ");
INSERT INTO ind_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dua kali mimpi itu disampaikan Allah kepada Baginda, artinya Dia sudah menetapkan bahwa hal itu harus terjadi, dan Dia akan segera melaksanakannya. ");
INSERT INTO ind_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Sekarang, sebaiknya Baginda mencari orang yang cerdas dan bijaksana. Tugaskanlah dia untuk mengelola seluruh negeri Mesir. ");
INSERT INTO ind_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Selain itu, biarlah Baginda juga menugaskan pejabat-pejabat lain untuk mengumpulkan hasil panen dari rakyat Mesir. Selama tujuh tahun kemakmuran, orang-orang harus memberikan dua puluh persen dari seluruh hasil panen mereka. ");
INSERT INTO ind_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Dengan demikian, mereka mengumpulkan gandum selama tujuh tahun yang berlimpah. Dan biarlah Baginda memerintahkan agar bahan makanan itu disimpan di berbagai kota di seluruh Mesir dan dijaga dengan baik. ");
INSERT INTO ind_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Itulah cadangan makanan untuk masa kelaparan yang akan terjadi di seluruh negeri nantinya. Hanya dengan cara ini, seluruh penduduk Mesir akan dapat bertahan hidup.” ");
INSERT INTO ind_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Usulan Yusuf dipandang baik oleh raja dan para pejabatnya. ");
INSERT INTO ind_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Lalu kata raja kepada para pejabatnya itu, “Nyatalah bahwa tidak ada seorang pun yang bisa menangani persoalan ini lebih baik daripada Yusuf, karena dia dipimpin oleh roh-roh ilahi.” ");
INSERT INTO ind_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Raja kemudian berkata kepada Yusuf, “Karena roh-roh ilahi sudah menunjukkan semua ini kepadamu, tidak ada orang lain yang lebih bijaksana dan cerdas daripadamu! ");
INSERT INTO ind_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Saya berikan kepadamu kuasa atas seluruh kerajaan dan rakyat Mesir. Tidak ada yang lebih berkuasa daripadamu kecuali saya sebagai raja. ");
INSERT INTO ind_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","“Dengan ini, saya mengangkatmu menjadi orang kedua yang berkuasa atas seluruh Mesir.” ");
INSERT INTO ind_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Lalu raja melepas cincin dengan cap kerajaan dari jarinya dan memasangnya pada jari Yusuf. Raja juga memberikan pakaian linen berkualitas tinggi dan kalung emas untuk dikenakan Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Raja kemudian menyuruh Yusuf naik ke kereta kuda yang biasanya digunakan oleh orang kedua yang berkuasa di Mesir. Pasukan pengawal raja membawa Yusuf berkeliling, sambil mengumumkan kepada seluruh rakyat bahwa mereka harus berlutut, karena Yusuf sudah diangkat menjadi penguasa nomor dua di Mesir. ");
INSERT INTO ind_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kata raja kepada Yusuf, “Saya memang raja, tetapi tidak ada seorang pun yang dapat bertindak di negeri ini tanpa seizinmu.” ");
INSERT INTO ind_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Demikianlah Yusuf dilantik menjadi penguasa. Usianya tiga puluh tahun ketika dia mulai melayani raja dan memerintah atas seluruh Mesir. Raja memberikan nama baru bagi Yusuf, yakni Safnat Paneah, serta memberinya seorang istri bernama Asnat. Asnat adalah anak Potifera, imam dewa matahari di kota Heliopolis. ");
INSERT INTO ind_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Selama tujuh tahun kemakmuran, hasil panen sangat melimpah. ");
INSERT INTO ind_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Dalam tahun-tahun itu, Yusuf mengumpulkan semua kelebihan hasil panen di negeri Mesir. Dia membangun gudang-gudang di setiap kota dan menyimpan hasil panen dari ladang-ladang di wilayah sekitarnya. ");
INSERT INTO ind_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hasil panen gandum yang dikumpulkan Yusuf begitu melimpah bagaikan pasir di laut sehingga jumlahnya tak dapat dihitung lagi. ");
INSERT INTO ind_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sebelum bencana kelaparan melanda Mesir, Asnat istri Yusuf melahirkan dua anak laki-laki. ");
INSERT INTO ind_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuf menamai anak sulungnya Manasye, sebab katanya, “Allah sudah membuatku melupakan segala penderitaanku dan kaum keluarga ayahku.” ");
INSERT INTO ind_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Anak keduanya diberi nama Efraim karena dia berkata, “Di negeri penderitaan, Allah sudah membuatku berhasil.” ");
INSERT INTO ind_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sesudah tujuh tahun, berakhirlah masa kemakmuran di Mesir ");
INSERT INTO ind_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","dan mulailah bencana kelaparan selama tujuh tahun berikutnya, tepat seperti perkataan Yusuf. Kelaparan melanda berbagai negeri, tetapi di Mesir tetap ada makanan. ");
INSERT INTO ind_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ketika seluruh rakyat Mesir kelaparan, mereka berseru kepada raja meminta makanan. Raja menyuruh mereka menghadap Yusuf dan melakukan apa yang dia perintahkan. ");
INSERT INTO ind_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Sewaktu bencana kelaparan itu semakin parah di seluruh Mesir, Yusuf membuka gudang-gudang gandum dan menjualnya kepada penduduk Mesir. Bencana itu juga menyebar ke seluruh bumi sehingga orang dari bangsa-bangsa lain pun berdatangan kepada Yusuf untuk membeli gandum. ");
INSERT INTO ind_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ketika Yakub mendapat kabar bahwa ada persediaan gandum di Mesir, dia berkata kepada anak-anaknya, “Kalian jangan diam saja!” ");
INSERT INTO ind_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Lanjut Yakub, “Aku dengar ada gandum di Mesir. Pergilah ke sana dan belilah gandum supaya kita tidak mati kelaparan!” ");
INSERT INTO ind_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Maka kesepuluh kakak Yusuf pergi ke Mesir untuk membeli gandum. ");
INSERT INTO ind_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tetapi Yakub sengaja tidak mengizinkan Benyamin, adik kandung Yusuf, untuk ikut bersama kakak-kakak tirinya, sebab pikirnya, “Jangan sampai terjadi apa-apa padanya.” ");
INSERT INTO ind_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kesepuluh anak Yakub berangkat bersama para pembeli lainnya, karena bencana kelaparan melanda seluruh negeri Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Pada waktu itu, Yusuf adalah pejabat tertinggi di Mesir dan dialah yang berkuasa untuk menjual gandum kepada seluruh rakyat negeri. Karena itu, kakak-kakak Yusuf datang dan bersujud untuk menghormatinya. ");
INSERT INTO ind_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ketika Yusuf melihat kakak-kakaknya, dia mengenali mereka, tetapi dia berpura-pura tidak tahu dan berbicara kepada mereka dengan kasar. Tanya Yusuf, “Dari mana kalian?!” Jawab mereka, “Kami datang dari Kanaan hendak membeli gandum.” ");
INSERT INTO ind_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Meskipun Yusuf mengenali kakak-kakaknya, mereka sudah tidak mengenalinya lagi. ");
INSERT INTO ind_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Saat itu, teringatlah Yusuf pada mimpinya tentang mereka. Lalu dia berkata, “Kalian ini mata-mata dan sengaja menyusup ke sini untuk mencari tahu letak kelemahan negeri kami!” ");
INSERT INTO ind_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Jawab mereka, “Tidak, Tuan! Hamba-hambamu ini datang hanya untuk membeli bahan makanan. ");
INSERT INTO ind_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kami semua anak dari satu ayah. Kami bukan penipu atau mata-mata!” ");
INSERT INTO ind_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kata Yusuf, “Tidak! Kalian pasti datang ke sini untuk menyelidiki letak kelemahan negeri kami!” ");
INSERT INTO ind_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Mereka kembali menjawab, “Kami datang dari Kanaan, anak dari satu ayah. Kami ini kakak beradik, semuanya ada dua belas laki-laki. Satu sudah meninggal dan adik kami yang bungsu ada bersama ayah kami.” ");
INSERT INTO ind_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tetapi Yusuf berkata kepada mereka, “Seperti yang sudah saya katakan, kalian ini mata-mata! ");
INSERT INTO ind_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Namun, untuk membuktikan kejujuran kalian, saya bersumpah atas nama raja Mesir bahwa saya tidak akan membiarkan kalian pergi dari tempat ini sebelum adik bungsumu datang ke sini. ");
INSERT INTO ind_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Pilihlah salah satu di antara kalian untuk pulang menjemput adik kalian dan membawanya ke sini. Sementara itu, yang lain akan ditahan dalam penjara sampai ucapan kalian tadi terbukti benar. Kalau ternyata kalian tidak punya adik, maka demi nama raja Mesir, kalian pasti mata-mata!” ");
INSERT INTO ind_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","18","Lalu Yusuf memasukkan mereka ke dalam penjara. Pada hari ketiga, Yusuf berkata kepada mereka, “Karena saya orang yang takut dan hormat kepada Allah, saya akan membebaskan kalian dengan satu syarat. ");
INSERT INTO ind_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kalau kalian benar-benar orang jujur, maka biarlah salah satu dari antara kalian tetap ditahan, dan yang lainnya boleh pulang membawa gandum untuk keluarga kalian yang kelaparan. ");
INSERT INTO ind_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bawalah adik bungsu kalian kepadaku. Dengan begitu, kalian membuktikan bahwa kalian dapat dipercaya, sehingga kalian tidak akan dihukum mati.” Saudara-saudara Yusuf pun setuju. ");
INSERT INTO ind_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Berkatalah mereka satu sama lain, “Sekarang kita sedang dihukum atas kesalahan kita terhadap adik kita. Ingatlah betapa dulu kita melihat kepedihan hatinya, dan betapa dia memohon belas kasihan kepada kita, tetapi kita tidak mempedulikannya. Itulah sebabnya kita mengalami semua ini.” ");
INSERT INTO ind_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben berkata, “Saat itu sudah kukatakan agar kita jangan menyakiti anak itu, tetapi kalian tidak menghiraukan perkataanku. Sekarang kita menerima balasan atas perbuatan kita.” ");
INSERT INTO ind_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Mereka tidak tahu bahwa Yusuf mengerti percakapan mereka, karena sebelumnya mereka berbicara dengan Yusuf melalui seorang penerjemah. ");
INSERT INTO ind_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mendengar semuanya itu, Yusuf pergi meninggalkan mereka dan menangis. Sesudah mampu menahan perasaannya, dia kembali dan memerintahkan agar Simeon ditahan. Simeon diikat di hadapan saudara-saudaranya, lalu yang lain diperbolehkan pulang ke Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusuf menyuruh anak buahnya untuk mengisi penuh karung-karung mereka dengan gandum serta memasukkan uang pembayaran gandum ke itu dalam karung mereka masing-masing. Yusuf juga memerintahkan supaya mereka dibawakan bekal dalam perjalanan pulang. ");
INSERT INTO ind_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Sesudah karung-karung itu dimuat ke atas punggung keledai-keledai mereka, orang-orang itu pun berangkat. ");
INSERT INTO ind_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Malam harinya, di tempat mereka beristirahat, salah satu saudara Yusuf membuka karungnya untuk memberi makan keledai. Ketika dia membuka karung itu, dilihatnyalah bahwa uang pembayaran ada di atas gandum. ");
INSERT INTO ind_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Lalu dia berkata kepada saudara-saudaranya, “Lihat, uangku dikembalikan! Ini ada di dalam karung!” Mereka pun menjadi takut dan gelisah, lalu berkata satu sama lain, “Apa yang sedang Allah perbuat terhadap kita?” ");
INSERT INTO ind_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Beberapa hari kemudian, setibanya di rumah, mereka menceritakan kepada Yakub semua yang sudah terjadi, ");
INSERT INTO ind_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Penguasa di negeri itu berbicara dengan kasar dan menuduh kami sebagai mata-mata. ");
INSERT INTO ind_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kami sudah menjelaskan, ‘Kami bukan penipu, bukan mata-mata. ");
INSERT INTO ind_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Kami dua belas bersaudara. Satu adik kami sudah meninggal, dan yang bungsu tinggal bersama ayah kami di Kanaan.’ ");
INSERT INTO ind_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Lalu penguasa itu berkata, ‘Buktikanlah kalau kalian memang orang jujur. Salah satu dari kalian harus tinggal, sedangkan yang lain boleh pulang membawa gandum untuk keluarga kalian. ");
INSERT INTO ind_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tetapi kalian harus membawa adik bungsumu itu kepada saya. Dengan begitu, saya akan tahu bahwa kalian jujur dan bukan mata-mata. Saya akan melepaskan saudara kalian, dan kalian bebas berjual beli di Mesir.’” ");
INSERT INTO ind_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sewaktu mereka membongkar muatan bahan makanan, tampaklah uang mereka sudah dikembalikan ke dalam karung masing-masing. Melihat itu, Yakub dan anak-anaknya sangat ketakutan. ");
INSERT INTO ind_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Lalu berkatalah Yakub, “Apa kalian mau aku kehilangan semua anakku?! Yusuf sudah mati, Simeon tidak kembali, dan sekarang kalian akan mengambil Benyamin dariku! Betapa malangnya aku!” ");
INSERT INTO ind_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben menjawab, “Aku akan bertanggung jawab penuh atas Benyamin. Aku pasti membawanya kembali. Kalau aku tidak membawa dia pulang, Ayah boleh membunuh kedua anak laki-lakiku!” ");
INSERT INTO ind_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tetapi kata Yakub, “Aku tidak mengizinkan Benyamin pergi! Kakaknya sudah mati. Tinggal dia saja anakku dari Rahel. Aku sudah tua, dan kalau sampai terjadi sesuatu terhadapnya, pastilah aku segera masuk Syeol karena dukacita.” ");
INSERT INTO ind_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Bencana kelaparan semakin parah di negeri itu. ");
INSERT INTO ind_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Sesudah persediaan makanan mereka habis, Yakub berkata kepada anak-anaknya, “Pergilah ke Mesir untuk membeli sedikit bahan makanan lagi.” ");
INSERT INTO ind_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Jawab Yehuda, “Ayah, penguasa Mesir itu sudah memperingatkan kita dengan keras untuk jangan menghadap dia bila kami tidak membawa Benyamin. ");
INSERT INTO ind_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kalau Ayah mengizinkan dia ikut, kami akan segera berangkat untuk membeli gandum. ");
INSERT INTO ind_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tetapi kalau Ayah tidak mengizinkannya ikut, kami tidak akan pergi, karena penguasa itu sudah mengatakan bahwa kami tidak boleh menghadap tanpa adik kami.” ");
INSERT INTO ind_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kata Yakub, “Mengapa kalian menambah masalah bagiku dengan memberitahu orang itu bahwa kalian masih punya adik?” ");
INSERT INTO ind_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Jawab mereka, “Orang itu menanyai kami dengan teliti mengenai diri kita dan keluarga kita. Katanya kepada kami, ‘Apakah ayah kalian masih hidup? Apakah kalian mempunyai saudara yang lain?’ Jadi kami menjawab semua pertanyaannya. Kami tidak tahu kalau dia akan menyuruh kami membawa Benyamin!” ");
INSERT INTO ind_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yehuda berkata kepada ayah mereka, “Izinkanlah Benyamin ikut dan kami akan segera berangkat. Aku yang bertanggung jawab atas dia. Kalau tidak, kita semua akan mati kelaparan. ");
INSERT INTO ind_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Aku menjamin bahwa dia tetap hidup. Jika aku tidak membawanya pulang dengan selamat, biar aku menanggung kesalahan seumur hidupku. ");
INSERT INTO ind_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Seandainya waktu itu Ayah memperbolehkan dia ikut, kami pasti sudah pulang pergi dua kali ke Mesir untuk membeli bahan makanan.” ");
INSERT INTO ind_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Jawab Yakub, “Ya sudah. Kalau begitu jangan pergi dengan tangan kosong. Bawalah pemberian untuk penguasa itu dari hasil terbaik negeri ini, sedikit madu, kacang-kacangan, dan wangi-wangian dari getah pohon. ");
INSERT INTO ind_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bawalah uang dua kali lipat karena kalian harus memberikan uang yang waktu itu dikembalikan ke dalam karung-karungmu. Mungkin itu suatu kekeliruan. ");
INSERT INTO ind_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bawalah adikmu juga dan pergilah menghadap orang itu. ");
INSERT INTO ind_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Semoga Allah Yang Mahakuasa membuat orang itu berbelas kasihan kepada kalian, sehingga kamu semua serta Benyamin dan Simeon kembali kepadaku. Namun, jika aku harus kehilangan anak-anakku lagi, ya sudahlah, yang harus terjadi terjadilah.” ");
INSERT INTO ind_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Maka mereka berangkat bersama Benyamin ke Mesir dengan membawa pemberian dari negeri mereka beserta uang pembayaran dua kali lipat. Setibanya di sana, mereka datang menghadap Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ketika Yusuf melihat Benyamin ada bersama kakak-kakaknya, dia segera menyuruh kepala pengurus rumahnya, “Bawalah orang-orang ini ke rumah saya. Lalu sembelihlah seekor hewan dan masaklah. Siang ini mereka akan makan bersama saya.” ");
INSERT INTO ind_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","18","Kepala pengurus rumah pun melaksanakan perintah Yusuf. Tetapi kakak-kakaknya ketakutan saat menyadari bahwa mereka dibawa ke rumah Yusuf. Kata mereka, “Ini pasti karena uang yang dikembalikan ke dalam karung-karung kita saat pertama kali datang ke sini. Mungkin sekarang kita akan dijadikan budak dan keledai-keledai kita akan dirampas.” ");
INSERT INTO ind_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Sesampainya di pintu rumah Yusuf, mereka mendekati kepala pengurus rumah itu dan berkata, ");
INSERT INTO ind_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Tuan, mohon izin berbicara. Dulu kami pernah datang ke sini membeli gandum. ");
INSERT INTO ind_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Dalam perjalanan pulang, ketika kami bermalam, kami membuka karung masing-masing dan menemukan semua uang pembayaran ada di dalam karung. Sekarang kami membawa uang itu untuk dikembalikan. ");
INSERT INTO ind_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kami tidak tahu siapa yang menaruh uang itu ke dalam karung-karung kami. Kali ini kami juga membawa uang tambahan untuk membeli bahan makanan lagi.” ");
INSERT INTO ind_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kepala pengurus rumah itu berkata, “Jangan kuatir. Tentang uang tersebut, tentulah itu pemberian dari Allahmu, yaitu Allah yang disembah ayahmu. Saya sudah menerima pembayaran kalian yang waktu itu.” Kemudian dia membawa Simeon kepada mereka. ");
INSERT INTO ind_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Diantarnya orang-orang itu masuk ke rumah Yusuf, lalu dia membawakan mereka air untuk mencuci kaki serta memberi makan keledai-keledai mereka. ");
INSERT INTO ind_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Anak-anak Yakub kemudian menyiapkan hadiah-hadiah yang akan diberikan kepada Yusuf, karena mereka sudah diberitahu bahwa mereka akan makan siang bersamanya. ");
INSERT INTO ind_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ketika Yusuf pulang, mereka menyerahkan semua pemberian itu sambil bersujud untuk menghormatinya. ");
INSERT INTO ind_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusuf menanyakan keadaan mereka, kemudian berkata, “Bagaimana kabar ayahmu yang pernah kalian ceritakan waktu itu? Apakah dia masih hidup?” ");
INSERT INTO ind_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Jawab mereka, “Hambamu, ayah kami, masih hidup dan keadaannya baik-baik saja.” Lalu mereka bersujud lagi kepadanya. ");
INSERT INTO ind_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ketika Yusuf melihat Benyamin, dia berkata, “Inikah adik yang pernah kalian ceritakan? Nak, semoga Allah memberkatimu.” ");
INSERT INTO ind_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tetapi Yusuf tidak dapat menahan perasaan sayang dan rindu kepada adiknya. Jadi dia cepat-cepat masuk ke kamarnya dan menangis. ");
INSERT INTO ind_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sesudah mencuci muka, Yusuf pun keluar dan sambil menahan perasaannya, dia menyuruh agar makan siang dihidangkan. ");
INSERT INTO ind_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Para pelayannya sudah menyediakan meja untuk Yusuf sendiri, meja terpisah untuk kakak beradik itu, dan sebuah meja lain untuk orang-orang Mesir yang biasanya makan bersama Yusuf. Hal ini dilakukan karena bagi orang Mesir, duduk makan bersama orang Ibrani adalah suatu kehinaan. ");
INSERT INTO ind_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Saudara-saudara Yusuf diberi tempat di meja yang berhadapan dengan Yusuf. Tempat duduk mereka diatur menurut urutan kelahiran, mulai dari yang tertua sampai yang termuda. Ketika menyadari hal itu, mereka saling berpandangan dengan terheran-heran. ");
INSERT INTO ind_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Makanan mereka dihidangkan dari meja Yusuf sendiri. Benyamin diberi bagian lima kali lebih banyak daripada kakak-kakaknya. Yusuf dan saudara-saudaranya itu menikmati makan dan minum sampai puas. ");
INSERT INTO ind_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sesudah itu, Yusuf berkata kepada kepala pengurus rumahnya, “Isilah karung orang-orang ini dengan gandum sebanyak yang mampu mereka bawa. Masukkan juga uang pembayaran mereka masing-masing di dekat mulut karungnya. ");
INSERT INTO ind_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Untuk karung milik adik mereka yang paling bungsu, taruhlah cawan perakku bersama uang pembayarannya.” Maka kepala pengurus rumah itu melakukan sesuai perintah Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Keesokan harinya, waktu masih subuh, saudara-saudara Yusuf dipersilakan berangkat dengan keledai mereka. ");
INSERT INTO ind_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tetapi baru saja mereka keluar dari kota itu, belum jauh jaraknya, Yusuf berkata kepada kepala pengurus rumahnya, “Kejarlah orang-orang itu. Sesudah kamu menyusul mereka, katakanlah, ‘Tuan kami sudah sangat baik kepada kalian, tetapi kalian malah membalas kebaikannya dengan mencuri cawan peraknya! ");
INSERT INTO ind_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Jahat sekali perbuatanmu! Tuan kami tidak hanya minum dari cawan itu, tetapi juga menggunakannya untuk meramal masa depan.’” ");
INSERT INTO ind_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kepala pengurus rumah itu pun mengejar mereka, lalu berbicara kepada mereka sesuai dengan perintah Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tetapi jawab saudara-saudara Yusuf kepadanya, “Mengapa Tuan berkata begitu? Hamba-hambamu ini tidak mungkin melakukan hal jahat seperti itu! ");
INSERT INTO ind_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tuan sendiri tahu bahwa ketika datang kembali dari Kanaan, kami sudah mengembalikan uang pembayaran yang ditemukan dalam karung-karung kami. Untuk apa kami mencuri emas atau perak dari rumah tuanmu? ");
INSERT INTO ind_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Bila Tuan menemukan benda itu di dalam salah satu karung kami, biarlah pemilik karung itu dihukum mati dan kami yang lain dijadikan budak Tuan.” ");
INSERT INTO ind_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kepala pengurus rumah Yusuf berkata, “Baiklah, sesuai dengan hukuman yang kalian tentukan, maka bila benda itu ditemukan, pemilik karung itulah yang akan dijadikan budak bagiku, sedangkan yang lainnya boleh pergi.” ");
INSERT INTO ind_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mereka segera menurunkan karung-karungnya dari keledai masing-masing dan membukanya. ");
INSERT INTO ind_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Lalu kepala pengurus rumah tangga itu memeriksa semua karung, mulai dari anak yang tertua hingga berakhir pada yang bungsu. Cawan perak itu ditemukan di dalam karung milik Benyamin. ");
INSERT INTO ind_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Seketika mereka langsung merobek pakaian masing-masing sebagai tanda duka, lalu memuat lagi karung-karung pada keledai-keledai mereka dan kembali menuju kota. ");
INSERT INTO ind_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yusuf masih di rumahnya saat Yehuda dan saudara-saudaranya tiba. Mereka bersujud di hadapan Yusuf karena sangat takut. ");
INSERT INTO ind_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Berkatalah Yusuf kepada mereka, “Apa-apaan perbuatanmu itu! Tidakkah kalian tahu bahwa orang seperti saya pasti bisa meramalkan apa pun yang disembunyikan?” ");
INSERT INTO ind_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Lalu Yehuda menjawab, “Tuan, kami tidak bisa berkata apa-apa. Kami tidak dapat membuktikan bahwa kami benar. Allah sudah mengungkapkan kesalahan kami. Karena itu, biarlah kami semua menjadi budak Tuan, jangan hanya pemilik karung yang kedapatan cawan Tuan.” ");
INSERT INTO ind_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Jawab Yusuf, “Tidak! Saya tidak akan berbuat seperti itu. Orang yang di dalam karungnya ditemukan cawan perak saya, dialah yang akan menjadi budak saya. Yang lainnya boleh pergi dengan selamat kepada ayah kalian.” ");
INSERT INTO ind_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yehuda pun mendekat dan berkata kepada Yusuf, “Tuan, mohon izinkan saya berbicara, dan janganlah marah kepada hambamu ini, karena saya tahu bahwa Tuan mempunyai kekuasaan besar seperti raja. ");
INSERT INTO ind_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tuan pernah menanyakan apakah kami memiliki ayah atau adik. ");
INSERT INTO ind_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kami pun sudah menjawab bahwa kami memiliki ayah yang sudah lanjut usia. Dalam masa tuanya, dia mendapat dua anak lagi dari salah seorang istrinya. Yang satu sudah meninggal, dan sekarang tinggal yang bungsu. Itu sebabnya ayah kami sangat menyayanginya. ");
INSERT INTO ind_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Lalu Tuan berkata kepada kami, ‘Bawalah adikmu itu agar saya dapat melihatnya.’ ");
INSERT INTO ind_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kami pun sudah mengatakan kepada Tuan bahwa anak itu tidak dapat dipisahkan dari ayahnya, karena bila itu terjadi, ayah bisa mati. ");
INSERT INTO ind_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Lalu Tuan mengatakan bahwa kami tidak akan diperbolehkan menghadap jika tidak membawa adik kami itu. ");
INSERT INTO ind_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ketika pulang, kami pun sudah menyampaikan pesan Tuan kepada ayah kami. ");
INSERT INTO ind_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lalu ayah menyuruh kami ke sini lagi untuk membeli bahan makanan. ");
INSERT INTO ind_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tetapi kami mengatakan bahwa tidak mungkin menghadap Tuan tanpa membawa adik kami, karena itu adalah perintah dari Tuan sendiri. ");
INSERT INTO ind_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lalu berkatalah hambamu, yaitu ayah kami, ‘Kalian sudah tahu bahwa istriku, Rahel, hanya memberiku dua anak laki-laki. ");
INSERT INTO ind_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Yang satu sudah meninggalkanku, dan aku berkata, “Pasti dia diterkam binatang buas.” Sejak saat itu, aku tidak pernah melihatnya lagi. ");
INSERT INTO ind_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Sekarang kalian mau membawa anakku yang bungsu juga. Kalau sampai terjadi sesuatu terhadapnya, aku akan segera masuk Syeol karena dukacita.’” ");
INSERT INTO ind_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Lanjut Yehuda, “Jadi Tuan, apa yang akan terjadi pada ayah jika kami pulang tanpa adik bungsu kami itu? Hanya dialah semangat hidup ayah kami! ");
INSERT INTO ind_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Jika ayah melihat adik bungsu kami tidak pulang bersama hamba-hambamu ini, dia akan mati, dan kami yang bersalah, karena kami seakan membunuh dia dengan dukacita. ");
INSERT INTO ind_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Sebagai jaminan kepada ayah, hambamu ini sudah berjanji akan membawa pulang adik bungsu kami. Kalau dia tidak pulang, saya akan bersalah terhadap ayah seumur hidup. ");
INSERT INTO ind_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Karena itu, hamba mohon untuk dapat menggantikan adik kami menjadi budak Tuan. Izinkanlah Benyamin pulang bersama kakak-kakaknya yang lain. ");
INSERT INTO ind_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Saya tidak sanggup menyaksikan duka macam apa yang akan diderita ayah kami apabila saya kembali tanpa membawa adik kami!” ");
INSERT INTO ind_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf tidak mampu lagi menahan perasaannya, maka disuruhnya semua pelayannya untuk keluar ruangan. Ketika dia tinggal sendirian bersama saudara-saudaranya, dia berkata, “Ini aku, Yusuf!” ");
INSERT INTO ind_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yusuf pun menangis tersedu-sedu hingga terdengar oleh beberapa orang Mesir, dan berita itu dengan cepat sampai ke istana raja. ");
INSERT INTO ind_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Katanya lagi, “Akulah Yusuf! Benarkah ayahku masih hidup?” Tetapi saudara-saudaranya hanya bisa diam karena terkejut dan takut. ");
INSERT INTO ind_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Berkatalah Yusuf kepada saudara-saudaranya, “Mari, mendekatlah.” Maka mereka pun mendekat. “Aku Yusuf, saudara kalian, yang kalian jual kepada para pedagang yang waktu itu sedang menuju Mesir. ");
INSERT INTO ind_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Janganlah menyesali diri atau marah terhadap dirimu sendiri karena kalian sudah menjualku. Sesungguhnya Allahlah yang sudah mengatur agar aku ke sini terlebih dahulu, untuk dapat menyelamatkan hidup banyak orang. ");
INSERT INTO ind_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bencana kelaparan sudah dua tahun dan masih akan terus berlangsung selama lima tahun ke depan. Tidak ada yang bisa membajak ataupun memanen kebun mereka. ");
INSERT INTO ind_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Allah sudah mengutus aku mendahului kalian untuk menyelamatkanmu dengan cara yang luar biasa ini, supaya keturunan kalian tetap bertahan di bumi. ");
INSERT INTO ind_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Jadi, bukan kalian yang mengatur supaya aku dibawa ke sini, melainkan Allah sendiri. Dia sudah menempatkan aku sebagai penasihat bagi raja, tuan atas seluruh istananya, dan penguasa atas seluruh Mesir.” ");
INSERT INTO ind_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Sesudah itu Yusuf berkata lagi, “Segeralah kembali kepada ayah dan katakan kepadanya, ‘Anakmu Yusuf masih hidup! Allah sudah menempatkan dia sebagai penguasa atas seluruh Mesir. Segeralah datang! Jangan lama-lama! ");
INSERT INTO ind_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bawalah semua harta benda, sapi, domba, dan kambing kalian. Ayah dan semua anak cucu kalian akan tinggal di daerah Gosyen, supaya lebih dekat dengan aku. ");
INSERT INTO ind_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Bencana kelaparan ini masih akan berlangsung selama lima tahun lagi. Karena itu, sebaiknya ayah dan semua saudaraku tinggal dekat dengan aku, supaya aku dapat mencukupi semua kebutuhan kalian dan ternak kalian. Dengan begitu kalian bisa bertahan melalui bencana kelaparan yang hebat ini.’” ");
INSERT INTO ind_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kata Yusuf lagi, “Kalian semua, khususnya Benyamin, sudah melihat dengan mata kepalamu sendiri bahwa akulah Yusuf. ");
INSERT INTO ind_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ceritakanlah kepada ayah tentang kejayaanku di Mesir yang sudah kalian lihat sendiri ini. Dan segeralah bawa ayah kepadaku!” ");
INSERT INTO ind_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Lalu Yusuf dan adiknya Benyamin saling berpelukan dan keduanya menangis. ");
INSERT INTO ind_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Dia juga mencium dan memeluk kakak-kakaknya sambil menangis. Sesudah itu, mereka bercakap-cakap dengan dia. ");
INSERT INTO ind_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Berita tentang kedatangan saudara-saudara Yusuf terdengar sampai ke istana. Raja dan semua pejabatnya turut senang. ");
INSERT INTO ind_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Lalu kata raja kepada Yusuf, “Suruhlah saudara-saudaramu memuat bahan makanan sebanyak yang mereka perlukan ke atas keledai-keledai mereka dan pulang ke Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Biarlah mereka kembali ke sini dengan membawa serta ayah kalian dan seluruh anggota keluargamu untuk menetap di sini. Saya akan memberikan tanah terbaik di Mesir, dan mereka akan hidup berkecukupan di sini. ");
INSERT INTO ind_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Juga suruhlah mereka membawa sejumlah kereta untuk menjemput ayah kalian, kaum perempuan, dan anak-anak kecil. ");
INSERT INTO ind_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mereka tidak perlu memikirkan soal harta benda yang harus ditinggalkan, karena barang-barang terbaik di negeri ini akan menjadi milik mereka.” ");
INSERT INTO ind_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Anak-anak Yakub pun melaksanakan semua hal itu. Dan sesuai perintah raja, Yusuf membawakan beberapa kereta serta bekal yang cukup untuk perjalanan. ");
INSERT INTO ind_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf juga memberikan kepada kakaknya masing-masing satu pasang pakaian. Tetapi kepada adiknya, Benyamin, diberikannya lima pasang pakaian ganti dan 3,5 kilogram keping perak. ");
INSERT INTO ind_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Selain itu, Yusuf mengirimkan untuk ayahnya sepuluh keledai jantan yang mengangkut muatan berupa hasil terbaik Mesir, juga sepuluh keledai betina yang mengangkut gandum, roti, serta bahan makanan lain untuk bekal perjalanan ayahnya ke Mesir. ");
INSERT INTO ind_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Sesudah itu, saudara-saudaranya berpamitan, dan Yusuf berpesan agar mereka tidak bertengkar satu sama lain dalam perjalanan. ");
INSERT INTO ind_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Demikianlah mereka keluar dari Mesir dan kembali ke Kanaan, kepada ayah mereka. ");
INSERT INTO ind_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Setibanya di rumah, mereka menceritakan kepada Yakub, “Yusuf masih hidup! Dia sudah menjadi penguasa atas seluruh Mesir!” Mendengar berita itu, Yakub terkejut dan tidak langsung percaya. ");
INSERT INTO ind_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tetapi ketika mereka menyampaikan semua pesan Yusuf kepadanya dan sesudah melihat kereta-kereta yang dikirim untuk menjemputnya, bangkitlah semangat hidup Yakub. ");
INSERT INTO ind_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Katanya, “Anakku Yusuf masih hidup! Hanya inilah kerinduan hatiku sekarang, untuk dapat bertemu dengannya sebelum aku mati.” ");
INSERT INTO ind_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Lalu Yakub memulai perjalanannya ke Mesir dengan membawa semua yang dia miliki. Setibanya di Bersyeba, dia mempersembahkan beberapa hewan kurban kepada Allah Isak, ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Malam itu, Allah berbicara kepadanya dalam mimpi, “Yakub, Yakub!” Jawabnya, “Ya, ini aku.” ");
INSERT INTO ind_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Allah berkata, “Akulah Allah, Allah ayahmu. Janganlah takut untuk pergi ke Mesir, karena di sana Aku akan menjadikan keturunanmu bangsa yang besar. ");
INSERT INTO ind_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aku akan menyertaimu sampai ke Mesir, dan suatu hari nanti Aku akan membawa keturunanmu kembali ke Kanaan. Yusuf akan ada bersamamu ketika kamu meninggal.” ");
INSERT INTO ind_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Lalu Yakub bersama rombongan keluarga besarnya berangkat dari Bersyeba menuju Mesir. Anak-anaknya mengatur muatan kereta-kereta yang sudah dikirim oleh raja, supaya Yakub, para menantunya, serta anak-anak kecil dapat naik. ");
INSERT INTO ind_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Mereka membawa semua harta benda dan ternak yang mereka peroleh selama di negeri Kanaan. Seluruh keturunan Yakub juga ikut ke Mesir, ");
INSERT INTO ind_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","yaitu semua anak cucunya, baik laki-laki maupun perempuan. ");
INSERT INTO ind_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Inilah daftar nama anak-anak lelaki Yakub yang pergi ke Mesir. Pertama, keturunan dari Lea, yang semuanya lahir di Padan Aram: Ruben, anak sulung, beserta empat anak laki-lakinya, yaitu Henok, Palu, Hesron, dan Karmi. Simeon beserta enam anak laki-lakinya, yaitu Yemuel, Yamin, Ohad, Yakin, Zohar, dan Saul. (Saul adalah anak Simeon dari istrinya yang berasal dari Kanaan.) Lewi beserta tiga anak laki-lakinya, yaitu Gerson, Kehat, dan Merari. Yehuda beserta tiga anak laki-lakinya yang masih hidup, yaitu Syela, Peres, dan Zerah. (Dua kakak mereka, Er dan Onan, sudah meninggal di Kanaan.) Peres mempunyai dua anak laki-laki, yaitu Hesron dan Hamul. Isakar beserta empat anak laki-lakinya, yaitu Tola, Pua, Ayub, dan Simron. Zebulon beserta tiga anak laki-lakinya, yaitu Sered, Elon, dan Yahleel. Selain anak laki-laki tersebut, ada juga seorang anak perempuan bernama Dina. Jumlah keturunan dari Lea yang ikut ke Mesir adalah 33 orang. ");
INSERT INTO ind_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Kedua, keturunan dari Zilpa, budak perempuan Lea pemberian Laban: Gad beserta tujuh anak laki-lakinya, yaitu Sifion, Hagi, Suni, Esbon, Eri, Arodi, dan Areli. Asyer beserta empat anak laki-lakinya, yaitu Yimna, Yiswa, Yiswi, dan Beria. Asyer juga mempunyai seorang anak perempuan bernama Sera. Beria mempunyai dua anak laki-laki, yakni Heber dan Malkiel. Jumlah keturunan dari Zilpa yang ikut ke Mesir adalah 16 orang. ");
INSERT INTO ind_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Ketiga, keturunan dari Rahel: Yusuf, yang sudah lebih dulu pergi ke Mesir dan mempunyai dua anak lelaki di sana, yaitu Manasye dan Efraim, dari istrinya yang bernama Asnat dari kota Heliopolis. (Asnat adalah anak Potifera, imam dewa matahari yang disebut Ra.) Benyamin beserta sepuluh anak laki-lakinya, yaitu Bela, Beker, Asbel, Gera, Naaman, Ehi, Rosi, Mupim, Hupim, dan Ared. Jumlah keturunan dari Rahel adalah 14 orang. ");
INSERT INTO ind_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Keempat, keturunan dari Bilha, budak perempuan Rahel pemberian Laban: Dan beserta seorang anak lelakinya, yaitu Husim. Naftali beserta empat anak laki-lakinya, yaitu Yahzel, Guni, Yezer, dan Syilem. Jumlah keturunan dari Bilha yang ikut ke Mesir adalah 7 orang. ");
INSERT INTO ind_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Seluruh keturunan Yakub dari keempat istrinya yang ikut bersamanya ke Mesir adalah 66 orang, belum termasuk menantu-menantu perempuan. ");
INSERT INTO ind_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Jumlah keseluruhan keturunan Yakub bila ditambah dua anak Yusuf yang lahir di Mesir serta keturunan mereka adalah 70 orang. ");
INSERT INTO ind_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Sebelum mereka sampai di Gosyen, Yehuda diutus terlebih dahulu menghadap Yusuf untuk menanyakan petunjuk tentang tempat yang disediakan bagi mereka di daerah Gosyen. Ketika rombongan Yakub tiba di situ, ");
INSERT INTO ind_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf menyuruh supaya keretanya disiapkan, lalu dia pergi menyambut ayahnya. Saat mereka bertemu, Yusuf memeluk leher ayahnya dan menangis lama sekali. ");
INSERT INTO ind_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakub berkata kepada Yusuf, “Sekarang aku bisa mati dengan tenang karena sudah melihat wajahmu dan mengetahui bahwa ternyata kamu masih hidup!” ");
INSERT INTO ind_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Lalu Yusuf menyampaikan pesan kepada saudara-saudaranya dan seluruh keluarga Yakub, “Aku akan pergi menghadap raja Mesir untuk memberitahu bahwa ayah, saudara-saudaraku, dan semua anggota keluarga besar kita sudah datang dari Kanaan. ");
INSERT INTO ind_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Aku juga akan menyampaikan bahwa kalian adalah gembala, dan bahwa kalian membawa seluruh kawanan ternak kalian dan semua harta benda lain. ");
INSERT INTO ind_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Apabila raja bertanya, ‘Apa pekerjaan kalian,’ ");
INSERT INTO ind_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","maka kalian harus menjawab, ‘Sejak kecil, kami menggembalakan ternak sama seperti nenek moyang kami.’ Dengan begitu, kalian akan diperbolehkan untuk menetap dan menggembalakan ternak di Gosyen. Yusuf menyuruh mereka menjawab demikian karena bagi orang Mesir, mata pencaharian sebagai gembala dianggap hina.” ");
INSERT INTO ind_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Lalu Yusuf pergi menghadap raja Mesir dan melaporkan, “Baginda, ayah saya dan semua saudara saya sudah tiba dari Kanaan. Mereka membawa kawanan ternak dan segala harta benda mereka. Sekarang mereka sudah sampai di Gosyen.” ");
INSERT INTO ind_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusuf juga membawa lima orang kakaknya menghadap raja. ");
INSERT INTO ind_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kemudian raja bertanya, “Apa mata pencaharian kalian?” Jawab mereka, “Kami gembala ternak turun temurun, sejak zaman nenek moyang kami. ");
INSERT INTO ind_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Negeri Kanaan sedang dilanda kekeringan. Kami kesulitan menggembalakan kawanan ternak. Karena itu, bila Baginda berkenan, kami mohon agar diizinkan menggembalakan kawanan ternak kami di Gosyen dan menetap untuk sementara waktu di situ.” ");
INSERT INTO ind_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Raja berkata kepada Yusuf, “Ayahmu dan saudara-saudaramu sudah datang kepadamu. ");
INSERT INTO ind_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Negeri Mesir terbuka bagimu. Gosyen adalah wilayah terbaik di negeri ini. Biarkanlah ayah dan saudara-saudaramu menetap di situ. Bila ada di antara mereka yang mahir menggembala, pekerjakanlah mereka untuk mengurus ternakku.” ");
INSERT INTO ind_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Lalu Yusuf mengajak ayahnya menghadap raja, dan Yakub memberkati raja. ");
INSERT INTO ind_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tanya raja kepada Yakub, “Berapakah usiamu?” ");
INSERT INTO ind_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jawab Yakub, “Hambamu ini sudah menjalani hidup yang penuh kesusahan sebagai pengembara selama seratus tiga puluh tahun. Itu sangat singkat dibandingkan usia nenek moyang saya dalam pengembaraan mereka.” ");
INSERT INTO ind_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Sebelum pamit, Yakub mengucapkan berkat perpisahan kepada raja. ");
INSERT INTO ind_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Sesudah itu Yusuf membantu ayah dan saudara-saudaranya untuk menetap di tanah terbaik di Mesir, di daerah Rameses, sesuai perintah raja. ");
INSERT INTO ind_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf memberikan bahan makanan yang cukup untuk ayahnya, saudara-saudaranya, serta seluruh sanak saudara mereka menurut jumlah kebutuhan masing-masing keluarga. ");
INSERT INTO ind_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bencana kelaparan semakin memburuk. Di mana-mana tidak ada makanan, sehingga seluruh penduduk Mesir dan Kanaan menderita karena kelaparan dahsyat itu. ");
INSERT INTO ind_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Orang-orang Mesir dan Kanaan membeli bahan makanan dari Yusuf hingga semua uang mereka masuk ke kas Yusuf. Lalu dia menyerahkan uang itu kepada raja. ");
INSERT INTO ind_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ketika seluruh uang warga Mesir maupun Kanaan terpakai habis, orang-orang Mesir mendatangi Yusuf dan berkata, “Berilah kami makanan. Uang kami sudah habis. Haruskah kami mati kelaparan di hadapanmu?” ");
INSERT INTO ind_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuf menjawab, “Kalau kalian sudah tidak punya uang lagi, berikanlah ternak kalian sebagai pembayaran.” ");
INSERT INTO ind_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Maka mereka membawa hewan ternak kepada Yusuf untuk ditukar dengan bahan makanan. Ada yang membawa kuda, keledai, sapi, kambing, ataupun domba. Yusuf pun memberi mereka bahan makanan sebagai gantinya. Hal ini terjadi sepanjang tahun itu. ");
INSERT INTO ind_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pada tahun berikutnya, rakyat kembali menghadap Yusuf dan berkata, “Kami tidak dapat menyembunyikan dari Tuan bahwa uang kami sudah habis, dan semua hewan kami juga sudah menjadi milik Tuan. Tidak ada lagi yang dapat kami jual untuk makanan, kecuali tanah kami. Atau kami terpaksa menjual diri kami sebagai budak! ");
INSERT INTO ind_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Apakah kami harus binasa di hadapanmu, dan tanah kami menjadi tandus?! Ambillah kami dan tanah kami sebagai pembayaran bahan makanan, karena kami sudah tidak punya apa-apa lagi. Biarlah kami menjadi budak raja dan tanah kami menjadi miliknya! Berilah kami benih untuk ditanam, agar kami tetap bertahan hidup dan tidak binasa, dan agar tanah kami tidak menjadi tandus!” ");
INSERT INTO ind_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Maka Yusuf membeli semua tanah di Mesir untuk raja. Para pemilik ladang terpaksa menjual ladang mereka karena bencana kelaparan begitu hebat. Semua ladang pun menjadi milik raja Mesir. ");
INSERT INTO ind_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Lalu seluruh rakyat— dari ujung perbatasan Mesir sampai ke ujung perbatasan yang lain— dijadikan budak. ");
INSERT INTO ind_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Hanya tanah milik para imam Mesir yang tidak dibeli Yusuf, karena mereka menerima jatah makanan dari raja sehingga tidak perlu menjual tanah mereka. ");
INSERT INTO ind_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusuf berkata kepada rakyatnya, “Perhatikanlah, saya sudah membeli kalian dan ladang kalian untuk raja, maka tanamlah benih-benih ini. ");
INSERT INTO ind_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pada waktu panen nanti, kalian wajib memberikan dua puluh persen kepada raja. Yang delapan puluh persen adalah milikmu untuk dijadikan benih dan untuk bahan makanan bagi anak-anakmu dan semua yang tinggal di rumahmu.” ");
INSERT INTO ind_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Rakyat menjawab, “Tuan sudah menyelamatkan nyawa kami! Biarlah kami berkenan di hadapan Tuan. Kami akan menjadi budak raja.” ");
INSERT INTO ind_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusuf menjadikan ketetapan itu sebagai undang-undang yang masih berlaku di Mesir hingga kitab ini ditulis, yaitu dua puluh persen dari semua hasil panen adalah milik raja. Hanya tanah para imam yang tidak menjadi milik raja. ");
INSERT INTO ind_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Orang-orang Israel menetap di wilayah Gosyen. Mereka memiliki tanah di sana dan hidup mereka berhasil. Jumlah mereka semakin bertambah. ");
INSERT INTO ind_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub tinggal di Mesir selama tujuh belas tahun, sampai umurnya mencapai 147 tahun. ");
INSERT INTO ind_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ketika Yakub sudah hampir mati, dia memanggil Yusuf dan berkata, “Kalau kamu benar-benar mengasihi aku, letakkan tanganmu di antara pangkal pahaku untuk menunjukkan kesetiaanmu memegang janji bahwa kamu tidak akan menguburkan aku di Mesir. ");
INSERT INTO ind_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Aku ingin dikubur bersama nenek moyangku. Sesudah aku mati, bawalah aku keluar dari Mesir dan kuburkanlah aku bersama mereka.” Jawab Yusuf, “Aku akan melaksanakan permintaan Ayah.” ");
INSERT INTO ind_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kata Yakub, “Bersumpahlah bahwa kamu akan melakukannya.” Maka Yusuf pun bersumpah. Lalu Yakub bersujud di tempat tidur, pada bagian di mana dia biasa meletakkan kepalanya, dan mengucap syukur kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Beberapa waktu kemudian, seseorang mengabarkan pada Yusuf, “Tuan, keadaan ayahmu semakin memburuk.” Maka Yusuf mengajak kedua anaknya, Manasye dan Efraim, untuk mengunjungi Yakub. ");
INSERT INTO ind_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ketika Yakub diberitahu bahwa Yusuf sudah datang, dia mengumpulkan segenap tenaganya untuk duduk di tempat tidur. ");
INSERT INTO ind_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Berkatalah Yakub kepada Yusuf, “Allah Yang Mahakuasa datang kepadaku di Lus, di negeri Kanaan, dan memberkati aku. ");
INSERT INTO ind_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Dia berkata kepadaku, ‘Aku akan memberimu keturunan yang banyak. Mereka akan bertambah banyak dan menjadi bangsa yang besar. Aku akan memberikan tanah ini kepada keturunanmu untuk menjadi milik mereka selamanya.’ ");
INSERT INTO ind_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yusuf anakku, kedua putramu yang lahir di Mesir sebelum ayah datang kepadamu sudah ayah anggap sebagai anak sendiri, sama seperti Ruben dan Simeon. ");
INSERT INTO ind_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Apabila kamu mempunyai keturunan lagi, barulah anak-anak yang berikutnya itu menjadi milikmu dan warisan mereka akan dicatat di bawah kakak-kakak mereka. ");
INSERT INTO ind_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mengenai aku, ketika aku dalam perjalanan dari Padan Aram, aku sangat sedih karena meninggalnya Rahel di Kanaan, tidak jauh dari Efrata. Aku menguburnya dalam perjalanan ke Efrata.” (Kota itu sekarang dikenal sebagai Betlehem.) ");
INSERT INTO ind_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ketika Yakub melihat kedua anak Yusuf, dia bertanya, “Siapakah anak-anak ini?” ");
INSERT INTO ind_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jawab Yusuf kepada ayahnya, “Mereka inilah anak-anakku yang sudah Allah berikan kepadaku di Mesir.” Lalu berkatalah Yakub, “Dekatkanlah kepadaku agar aku memberkati mereka.” ");
INSERT INTO ind_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Saat itu penglihatan Yakub sudah rabun karena usianya yang sangat lanjut. Yusuf membawa kedua anaknya mendekati Yakub, dan Yakub mencium serta memeluk mereka. ");
INSERT INTO ind_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Katanya kepada Yusuf, “Ayah tidak menyangka akan dapat melihat wajahmu lagi. Tetapi Allah bahkan mengizinkan aku bertemu anak-anakmu juga!” ");
INSERT INTO ind_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Lalu Yusuf melepaskan anak-anaknya dari pangkuan Yakub. Dia bersujud untuk memberi hormat kepada ayahnya. ");
INSERT INTO ind_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusuf mengatur posisi kedua anaknya di hadapan Yakub. Dengan tangan kanannya, Yusuf menempatkan Efraim di sisi kiri Yakub, dan dengan tangan kirinya, Yusuf menempatkan Manasye di sisi kanan Yakub. ");
INSERT INTO ind_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Namun, Yakub mengulurkan tangan kanannya menjamah kepala Efraim, anak bungsu yang berada di sisi kirinya, dan dengan tangan kirinya, dia menjamah kepala Manasye, anak sulung yang ada di sisi kanan, sehingga tangan Yakub bersilangan. ");
INSERT INTO ind_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Dia kemudian memberkati keturunan Yusuf dengan berkata, “Allah yang disembah nenek moyangku, Abraham dan Isak, yaitu Allah yang sudah menggembalakan aku setiap hari selama hidupku ");
INSERT INTO ind_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","dan yang melalui malaikat-Nya sudah melindungi aku dari segala kejahatan, Dialah yang memberkati anak-anak ini. Kiranya melalui anak-anak ini, namaku dan nama nenek moyang kita, Abraham dan Isak, diteruskan, dan kiranya keturunan mereka memenuhi seluruh bumi.” ");
INSERT INTO ind_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Saat Yusuf melihat bahwa ayahnya menaruh tangan kanan pada kepala Efraim, dia tidak setuju. Maka Yusuf memegang tangan kanan Yakub, hendak memindahkannya dari atas kepala Efraim dan menaruhnya ke atas kepala Manasye. ");
INSERT INTO ind_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Jangan seperti itu, Ayah,” kata Yusuf kepada Yakub. “Yang sulung ada di sebelah sini. Letakkanlah tangan kanan Ayah di kepala anakku yang sulung.” ");
INSERT INTO ind_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tetapi Yakub menolak dan berkata, “Aku tahu, Nak, aku tahu. Keturunan Manasye akan menjadi suatu bangsa yang hebat. Walaupun demikian, Efraim akan menjadi bangsa yang lebih hebat, dan jumlah keturunannya akan menjadi banyak bangsa.” ");
INSERT INTO ind_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Pada hari itu, Yakub memberkati mereka, “Mulai sekarang, semua orang Israel akan memakai nama kalian ketika memberkati orang lain. Mereka akan berkata, ‘Semoga Allah memberkatimu seperti Efraim dan Manasye.’” Dengan demikian, Yakub mendahulukan Efraim daripada Manasye. ");
INSERT INTO ind_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kemudian Yakub berkata kepada Yusuf, “Tidak lama lagi, aku akan meninggal, tetapi Allah akan menyertaimu dan memimpin kamu kembali ke tanah nenek moyangmu. ");
INSERT INTO ind_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Selain itu, aku berikan kepadamu dan bukan kepada saudara-saudaramu, daerah perbukitan yang sudah aku rebut dari orang Amori ketika berperang melawan mereka dengan pedang dan busur panahku.” ");
INSERT INTO ind_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakub memanggil anak-anaknya untuk berkumpul lalu berpesan kepada mereka, “Anak-anakku, aku hendak menyampaikan apa yang akan terjadi kepada kalian di masa mendatang. ");
INSERT INTO ind_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Berkumpullah, hai anak-anak Yakub, dengarkanlah Israel, ayahmu. ");
INSERT INTO ind_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, kamulah anak sulungku yang lahir ketika aku masih muda. Kamu yang seharusnya paling dihormati dan yang terkuat dari semua anakku. ");
INSERT INTO ind_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tetapi kamu tidak dapat dikendalikan, bagaikan banjir yang tidak bisa dibendung. Kamu sudah melakukan dosa yang sangat memalukan dengan meniduri salah seorang istriku! Karena itu, kamu dan keturunanmu tidak akan menjadi yang terutama dan tidak akan memimpin adik-adikmu. ");
INSERT INTO ind_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon dan Lewi— kakak beradik yang menggunakan pedang untuk melakukan kekerasan— ");
INSERT INTO ind_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","aku tidak mau terlibat dalam persekongkolan kalian ataupun bersepakat dengan kalian dalam rencana yang jahat. Kalian berdua sudah membunuh orang karena amarah dan melumpuhkan banteng sebagai hiburan. ");
INSERT INTO ind_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Terkutuklah amarah kalian yang begitu keji dan tidak dapat dikendalikan. Aku akan menyebarkan keturunan kalian di antara suku-suku dari keturunanku yang lain, dan mencerai-beraikan keturunan kalian di antara bangsa Israel. ");
INSERT INTO ind_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, saudara-saudaramu memujimu! Keturunanmu akan menaklukkan musuh-musuh. Anak-anakku yang lain akan tunduk kepadamu. ");
INSERT INTO ind_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Kekuasaan suku Yehuda bagaikan seekor singa muda yang beristirahat sesudah mencabik dan puas memakan mangsanya. Tidak ada seorang pun yang akan berani mengganggu kalian. ");
INSERT INTO ind_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tongkat kerajaan tidak akan beralih dari suku Yehuda, dan keturunannya akan memerintah hingga tiba saatnya kelak datang seseorang yang berhak memiliki tongkat kerajaan itu. Dialah penguasa yang akan ditaati oleh segala bangsa. ");
INSERT INTO ind_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Dia akan mengikat keledainya pada pohon anggur pilihan dan mencuci pakaiannya dalam air anggur yang berwarna merah darah. ");
INSERT INTO ind_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matanya indah, lebih gelap daripada air anggur, dan giginya kuat, lebih putih daripada susu. ");
INSERT INTO ind_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon, kamu dan keturunanmu akan hidup makmur di tepi laut dan berdagang dengan kapal-kapal dagang yang berlabuh di lepas pantai. Kalian akan menguasai perdagangan sampai ke batas wilayah Sidon. ");
INSERT INTO ind_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar, kamu dan keturunanmu akan seperti seekor keledai yang kuat tetapi malas. Kalian berbaring di antara keranjang-keranjang bebanmu, ");
INSERT INTO ind_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","karena kalian melihat tempat bersantaimu itu baik keadaannya dan indah pemandangannya. Oleh sebab itu, kalian akan terpaksa membawa beban pada punggung kalian dan bekerja sebagai budak. ");
INSERT INTO ind_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Untuk Dan, kamu beserta keturunanmu akan memimpin dan mengadili suku kalian sendiri, serta hidup seperti suku-suku Israel yang lain. ");
INSERT INTO ind_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Bagaikan ular-ular di pinggir jalan, ular-ular berbisa di tepi jalan setapak, para keturunanmu akan menggigit kaki kuda yang lewat sehingga penunggangnya terlempar ke belakang.” ");
INSERT INTO ind_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Lalu Yakub berdoa, “Ya TUHAN, aku menantikan keselamatan dari Engkau bagi keturunanku.” ");
INSERT INTO ind_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Sesudah itu, Yakub melanjutkan penyataan masa depan untuk anak-anaknya yang lain. “Gad, kamu dan keturunanmu akan diserang oleh perampok, tetapi kalian akan berbalik merampok mereka. ");
INSERT INTO ind_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer, kamu dan keturunanmu akan menghasilkan bahan makanan yang melimpah dan bermutu tinggi, yang pantas disajikan bagi para raja. ");
INSERT INTO ind_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, kamu dan keturunanmu akan seperti rusa yang bebas berlari, yang menghasilkan keturunan yang gagah. ");
INSERT INTO ind_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf, kamu dan keturunanmu akan seperti pohon yang subur di tepi mata air, dengan cabang-cabang yang tumbuh melewati tembok dan berbuah lebat. ");
INSERT INTO ind_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Musuh-musuh akan menyerang kalian dengan busur panah mereka dan menganiaya kalian. ");
INSERT INTO ind_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Namun, busur kalian tetap kokoh dan lengan kalian tetap kuat. Kekuatan kalian adalah kekuatan dari Yang Mahakuasa, Allah dan Pelindung Yakub. Karena TUHAN bagaikan gembala dan gunung batu tempat perlindungan bagi seluruh Israel. ");
INSERT INTO ind_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Biarlah Allahku menolong kalian. Kiranya Allah Yang Mahakuasa memberkati kalian dengan air hujan dari langit dan mata air dari dalam bumi. Dialah yang akan memberkati kalian dengan banyak keturunan dan ternak berlimpah. ");
INSERT INTO ind_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Berkat-berkat dari aku, ayahmu, lebih besar dan lebih menguntungkan daripada kelimpahan hasil alam di gunung-gunung dan bukit-bukit yang sudah ada sejak purba kala. Biarlah semua berkat ini dilimpahkan atas kalian, keturunan Yusuf. Kalian akan memimpin di antara saudara-saudaramu sesama bangsa Israel. ");
INSERT INTO ind_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin, kamu dan keturunanmu akan seperti seekor serigala yang ganas. Pada pagi hari kalian akan menghabisi musuh-musuh kalian, dan pada petang hari kalian akan membagi-bagikan jarahan.” ");
INSERT INTO ind_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Itulah nubuatan terakhir Yakub bagi kedua belas suku Israel. Dia memberkati mereka dengan berkat yang sesuai bagi mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kemudian Yakub menyampaikan ucapan terakhirnya kepada mereka, “Sudah dekat waktunya bagiku untuk menyusul nenek moyangku dalam kematian. Kuburkanlah aku bersama nenek moyangku di gua yang dibeli Abraham dari Efron orang Het. ");
INSERT INTO ind_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Gua itu berada di Makpela, tidak jauh dari Hebron di Kanaan. Abraham membeli ladang itu dari Efron untuk dijadikan sebagai kuburan keluarga. ");
INSERT INTO ind_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham dan Sara istrinya dikuburkan di sana, juga Isak dan istrinya, Ribka. Di sanalah juga aku menguburkan Lea. ");
INSERT INTO ind_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Lahan dan gua itu dibeli dari orang Het. Kuburkanlah aku di sana.” ");
INSERT INTO ind_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sesudah menyampaikan pesan-pesan terakhirnya, Yakub berbaring kembali dan meninggal dunia. ");
INSERT INTO ind_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Dengan sangat sedih, Yusuf memeluk ayahnya dan mencium wajahnya sambil menangis. ");
INSERT INTO ind_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Lalu Yusuf memberi perintah agar jenazah ayahnya diawetkan dengan wangi-wangian dari getah pohon. Perintah itu dikerjakan oleh orang-orang Mesir yang ahli dalam pengawetan jenazah. ");
INSERT INTO ind_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Waktu yang diperlukan untuk mengerjakannya adalah empat puluh hari. Orang-orang Mesir berkabung untuk Yakub selama tujuh puluh hari. ");
INSERT INTO ind_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Setelah masa berkabung selesai, Yusuf berkata kepada para pegawai istana, “Kalau kalian bersedia membantu saya, tolong sampaikan pesan ini kepada raja, ");
INSERT INTO ind_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Sebelum ayah meninggal, dia meminta saya bersumpah untuk menguburkannya di makam yang sudah dia siapkan di negeri Kanaan. Mohon izinkan saya pergi ke sana untuk menguburnya. Setelah itu saya akan kembali.’” ");
INSERT INTO ind_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Jawab raja, “Ya, tepatilah janjimu kepadanya. Pergilah menguburkan ayahmu.” ");
INSERT INTO ind_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Maka Yusuf pergi menguburkan ayahnya. Semua pejabat kerajaan, tua-tua istana, dan para pejabat senior negeri Mesir juga ikut bersama dia. ");
INSERT INTO ind_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Seluruh anggota keluarga Yusuf, saudara-saudaranya, dan segenap keluarga besar Yakub pergi bersamanya. Hanya anak-anak kecil dan kawanan ternak mereka yang tetap di Gosyen. ");
INSERT INTO ind_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Selain itu, ada juga pasukan berkereta dan berkuda yang ikut, sehingga rombongan itu menjadi sangat besar. ");
INSERT INTO ind_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sesudah mereka tiba di tempat pengirikan milik Atad yang terletak di seberang sungai Yordan, acara perkabungan selama tujuh hari dimulai. Acara itu diiringi dengan tangisan dan ratapan. ");
INSERT INTO ind_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ketika orang-orang Kanaan melihat acara perkabungan dan penguburan itu, mereka berkata, “Betapa dalamnya dukacita orang-orang Mesir itu!” Maka sejak saat itu, tempat tersebut dinamai Tempat Orang Mesir Berkabung. ");
INSERT INTO ind_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Anak-anak Yakub pun melaksanakan pesan terakhir ayah mereka. ");
INSERT INTO ind_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Jenazah Yakub dibawa dan dikuburkan di gua yang ada di Makpela, dekat Hebron di Kanaan. Gua itu berada di ladang yang sudah dibeli Abraham dari Efron, orang Het. Abraham membelinya untuk dijadikan tempat peristirahatan terakhir keluarga mereka. ");
INSERT INTO ind_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Sesudah menguburkan Yakub, kembalilah Yusuf beserta saudara-saudaranya dan seluruh rombongan itu ke Mesir. ");
INSERT INTO ind_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kini, setelah ayah mereka tiada, kakak-kakak Yusuf merasa takut terhadapnya. Kata mereka, “Bagaimana kalau Yusuf masih menyimpan dendam atas semua perbuatan jahat yang dulu kita lakukan kepadanya?” ");
INSERT INTO ind_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Maka mereka sepakat untuk mengirim permohonan kepada Yusuf, yang isinya, “Sebelum ayah meninggal, ");
INSERT INTO ind_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","dia memberi pesan untuk disampaikan kepadamu, katanya, ‘Maafkanlah semua perbuatan jahat yang pernah dilakukan saudara-saudaramu terhadapmu.’ Jadi kami, kakakmu— yang sama seperti engkau juga menyembah Allah yang disembah ayah kita— memohon agar engkau bersedia memaafkan kami.” Maka menangislah Yusuf ketika menerima pesan itu. ");
INSERT INTO ind_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Saudara-saudaranya datang dan bersujud di hadapan Yusuf untuk memohon belas kasihan sambil berkata, “Kami ini adalah hambamu.” ");
INSERT INTO ind_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jawab Yusuf kepada mereka, “Jangan takut! Aku tidak berhak untuk menghakimi kalian karena aku bukan Allah. ");
INSERT INTO ind_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Dulu, kalian memang merencanakan hal yang jahat terhadapku. Tetapi sesungguhnya Allah memiliki rencana yang baik dalam kejadian itu, supaya banyak orang dapat diselamatkan, seperti yang sudah terjadi. ");
INSERT INTO ind_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tidak ada yang perlu kalian takuti. Aku akan mencukupi kebutuhan kalian dan anak-anak kalian.” Demikianlah Yusuf menenangkan hati mereka. ");
INSERT INTO ind_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusuf dan saudara-saudaranya bersama keluarga mereka tetap tinggal di Mesir. Yusuf meninggal pada usia 110 tahun. ");
INSERT INTO ind_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Sebelum meninggal, Yusuf sempat melihat anak dan cucu Efraim, juga cicitnya dari Makir, anak Manasye. Mereka diangkat oleh Yusuf sebagai anak dan menerima warisan darinya. ");
INSERT INTO ind_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf berkata kepada saudara-saudaranya, “Kematianku sudah dekat, tetapi Allah akan menyertai kalian dan memimpin kalian keluar dari Mesir untuk kembali ke tanah yang sudah dijanjikan-Nya kepada Abraham, Isak, dan Yakub. ");
INSERT INTO ind_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","“Jadi, aku mohon agar kalian bersumpah bahwa ketika Allah membawa kalian keluar dari Mesir untuk kembali ke Kanaan, kalian harus membawa tulang-tulangku untuk dikuburkan di sana.” ");
INSERT INTO ind_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusuf meninggal pada usia 110 tahun. Lalu jenazahnya diawetkan dan disimpan di Mesir dalam peti.");
INSERT INTO ind_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Inilah kelanjutan cerita tentang keluarga Yakub yang pindah bersamanya ke negeri Mesir. Sesuai nama baru Yakub, mereka disebut umat Israel. Nama-nama anaknya adalah ");
INSERT INTO ind_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Lewi, Yehuda, ");
INSERT INTO ind_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Zebulon, Benyamin, Dan, ");
INSERT INTO ind_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Naftali, Gad, dan Asyer. ");
INSERT INTO ind_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jumlah keluarga Yakub pada waktu itu adalah tujuh puluh orang, termasuk Yusuf yang sudah lama berada di Mesir. ");
INSERT INTO ind_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Waktu pun berlalu. Akhirnya Yusuf dan saudara-saudaranya serta semua orang dari generasi mereka meninggal. ");
INSERT INTO ind_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Umat Israel beranak cucu dan jumlah mereka bertambah banyak, sehingga mereka sangat kuat dan tersebar di seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Setelah beberapa generasi berlalu, seorang raja baru yang tidak tahu apa-apa tentang kisah Yusuf mulai berkuasa atas seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Raja itu berkata kepada para pejabatnya, “Lihatlah, orang-orang Israel sudah terlalu banyak, sehingga mereka lebih kuat daripada kita. ");
INSERT INTO ind_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kalau suatu saat musuh menyerang kita, bisa saja mereka bergabung dengan pihak musuh, lalu melawan kita dan meninggalkan negeri ini. Karena itu, kita harus mencari cara mengendalikan orang Israel supaya tidak bertambah banyak.” ");
INSERT INTO ind_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Jadi, mereka menempatkan para mandor kepala budak untuk menindas umat Israel dengan kerja paksa. Umat Israel dipaksa untuk membangun kota Pitom dan kota Rameses, yang akan dijadikan sebagai pusat penyimpanan hasil panen dan harta benda raja Mesir. ");
INSERT INTO ind_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Namun, semakin ditindas, jumlah umat Israel malah semakin bertambah dan semakin menyebar ke seluruh negeri itu. Hal itu membuat orang Mesir semakin takut kepada mereka. ");
INSERT INTO ind_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Karena itu, dengan kejam orang Mesir memaksa mereka bekerja lebih keras. ");
INSERT INTO ind_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Mereka membuat hidup umat Israel semakin sengsara dengan memaksa mereka bekerja keras membuat batu bata dari campuran lumpur. Umat Israel juga disuruh melakukan segala macam pekerjaan berat, termasuk pekerjaan di ladang. Orang Mesir juga semakin menindas umat Israel dengan segala macam pekerjaan yang sangat berat. ");
INSERT INTO ind_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kemudian raja Mesir memanggil dua perempuan Israel yang bertugas sebagai bidan untuk menolong ibu-ibu Israel saat melahirkan. Nama bidan itu Sifra dan Pua. ");
INSERT INTO ind_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Raja berkata kepada mereka, “Perhatikanlah setiap kali kalian menolong para perempuan Israel melahirkan. Apabila bayinya perempuan, kalian boleh membiarkannya hidup, tetapi kalau laki-laki, kalian harus membunuhnya!” ");
INSERT INTO ind_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Namun, kedua bidan itu takut akan Allah, sehingga mereka tidak menuruti perintah raja Mesir. Mereka membiarkan semua bayi laki-laki yang lahir tetap hidup. ");
INSERT INTO ind_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Maka raja Mesir memanggil kedua bidan itu dan berkata, “Berani-beraninya kalian sengaja melanggar perintah raja dengan membiarkan semua bayi laki-laki hidup!” ");
INSERT INTO ind_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Jawab mereka, “Perempuan Israel tidak sama dengan perempuan Mesir. Mereka sangat kuat, sehingga sebelum bidan tiba mereka sudah melahirkan.” ");
INSERT INTO ind_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Karena bidan-bidan itu takut akan Allah, maka Allah memberkati mereka dengan memberikan mereka keluarga dan anak-anak. Umat Israel semakin bertambah banyak dan menjadi semakin kuat. ");
INSERT INTO ind_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Lalu raja Mesir memerintahkan seluruh rakyatnya, “Setiap anak laki-laki yang lahir dari orang Israel harus dibuang ke sungai Nil, tetapi bayi perempuan boleh dibiarkan hidup.” ");
INSERT INTO ind_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ada seorang laki-laki dari suku Lewi yang menikahi seorang perempuan dari suku yang sama. ");
INSERT INTO ind_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Pada waktu raja Mesir sudah memberikan perintah tadi, perempuan itu melahirkan bayi laki-laki. Karena dilihatnya bahwa bayinya tampan, dia menyembunyikan bayi itu selama tiga bulan. ");
INSERT INTO ind_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ketika dia tidak bisa menyembunyikannya lebih lama lagi, perempuan itu pun mengambil sebuah keranjang, lalu melapisinya dengan ter dan getah tanaman supaya bisa terapung. Kemudian dia membaringkan anaknya di dalam keranjang itu dan menyembunyikannya di antara alang-alang air yang tinggi di tepi sungai Nil. ");
INSERT INTO ind_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kakak perempuan bayi itu mengawasi adiknya dari kejauhan. ");
INSERT INTO ind_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Lalu datanglah putri raja untuk mandi di sungai Nil, sementara para pelayan perempuannya berjalan-jalan di tepian sungai. Saat itulah putri raja melihat keranjang tadi di antara alang-alang air yang tinggi. Dia menyuruh salah satu pelayannya untuk mengambil keranjang itu. ");
INSERT INTO ind_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ketika dia membukanya, dia melihat bayi itu sedang menangis. Putri raja merasa kasihan terhadapnya dan berkata, “Pastilah ini bayi orang Israel.” ");
INSERT INTO ind_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kemudian kakak bayi itu mendekati putri raja dan bertanya, “Bolehkah saya mencarikan perempuan Israel yang dapat menyusui bayi ini bagi Tuan Putri?” ");
INSERT INTO ind_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Jawab putri raja, “Baiklah.” Maka gadis itu pergi dan memanggil ibu bayi itu sendiri. ");
INSERT INTO ind_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Putri raja berkata kepada ibu itu, “Bawalah bayi ini dan rawatlah dia bagi saya. Saya akan membayar kamu untuk itu.” Jadi sang ibu membawa bayinya dan merawat dia. ");
INSERT INTO ind_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ketika anak itu sudah disapih, ibunya membawa dia kembali kepada putri raja. Lalu putri raja mengangkat anak itu menjadi anaknya sendiri dan menamai dia Musa, dengan berkata, “Aku sudah mengangkatnya dari air.” ");
INSERT INTO ind_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Pada suatu hari, ketika Musa sudah dewasa, dia pergi keluar mengunjungi orang-orang sebangsanya, dan melihat betapa beratnya kerja paksa mereka. Dia juga melihat seorang Mesir sedang memukuli seorang Israel, saudara sebangsanya. ");
INSERT INTO ind_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa menoleh ke kiri kanan untuk memastikan tidak ada seorang pun yang melihatnya. Lalu dia membunuh orang Mesir itu dan cepat-cepat menyembunyikan mayatnya di dalam pasir. ");
INSERT INTO ind_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Keesokan harinya, Musa keluar lagi dan melihat dua orang Israel sedang berkelahi. Lalu dia bertanya kepada orang yang bersalah, “Mengapa kamu memukuli sesamamu orang Israel?” ");
INSERT INTO ind_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Jawab orang itu, “Apa urusanmu! Kamu bukan pemimpin ataupun hakim kami! Apakah kamu mau membunuh saya juga, seperti kamu membunuh orang Mesir itu kemarin?!” Musa pun menjadi takut dan berpikir, “Pasti semua orang sudah tahu perbuatanku.” ");
INSERT INTO ind_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Sewaktu raja Mesir mendengar tentang pembunuhan itu, dia mengeluarkan perintah untuk membunuh Musa. Tetapi Musa melarikan diri dan menetap di Midian. Di sana, ada seorang imam Midian bernama Rehuel. Dia mempunyai tujuh anak perempuan. Suatu hari, ketika Musa sedang duduk di dekat sumur, ketujuh anak perempuan Rehuel datang menimba air untuk memberi minum kawanan domba dan kambing milik ayah mereka. ");
INSERT INTO ind_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Beberapa gembala datang dan mengusir mereka, tetapi Musa membela mereka dari gembala-gembala itu, lalu membantu memberikan air kepada kawanan domba dan kambing mereka. ");
INSERT INTO ind_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ketika para perempuan itu pulang ke rumah, Rehuel bertanya, “Bagaimana kalian bisa pulang begitu cepat hari ini?” ");
INSERT INTO ind_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Jawab mereka, “Ada orang Mesir yang membela kami dari gembala-gembala yang sering mengganggu kami. Dia bahkan membantu memberi minum kawanan hewan kita.” ");
INSERT INTO ind_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Lalu Rehuel bertanya lagi kepada anak-anaknya, “Di manakah orang itu? Mengapa tidak kalian ajak kemari! Pergilah dan undanglah dia untuk makan bersama kita.” ");
INSERT INTO ind_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Karena undangan itu, Musa kemudian setuju untuk tinggal dengan mereka. Dan Rehuel memberikan anaknya, Sipora, untuk menjadi istri Musa. ");
INSERT INTO ind_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipora melahirkan anak laki-laki dan Musa menamainya Gersom, karena dia berkata, “Aku sudah menjadi pendatang di negeri asing.” ");
INSERT INTO ind_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Waktu pun berlalu, dan raja Mesir itu meninggal dunia. Namun, di bawah pemerintahan raja baru, bangsa Israel tetap saja sengsara dan ditindas sebagai budak. Mereka berseru meminta tolong karena perbudakan itu, dan seruan mereka sampai kepada Allah. ");
INSERT INTO ind_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allah mendengar semua keluhan mereka dan mengingat perjanjian-Nya dengan Abraham, Isak, dan Yakub. ");
INSERT INTO ind_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Allah melihat penderitaan bangsa Israel dan Dia mempedulikan mereka. ");
INSERT INTO ind_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Pada suatu hari, Musa sedang menggembalakan domba dan kambing milik mertuanya, Yitro, yang juga dikenal dengan nama Rehuel, seorang imam di Midian. Musa menggiring kawanan ternak menyeberangi padang belantara dan sampai di gunung Sinai, yang juga disebut ‘gunung Allah’. ");
INSERT INTO ind_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Di sana, malaikat wakil TUHAN menampakkan diri kepada Musa dalam bentuk nyala api di tengah-tengah semak. Musa melihat semak itu berapi tetapi tidak terbakar. ");
INSERT INTO ind_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Maka berkatalah Musa, “Sungguh aneh! Mengapa semak itu tidak terbakar? Aku akan melihatnya dari dekat.” ");
INSERT INTO ind_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ketika TUHAN melihat bahwa Musa mendekat, berkatalah Allah dari semak itu, “Musa, Musa!” Jawab Musa, “Ya, ini aku!” ");
INSERT INTO ind_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Lalu TUHAN berkata, “Jangan mendekat! Lepaskan alas kakimu, karena tanah yang kamu injak itu suci. ");
INSERT INTO ind_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Akulah Allah yang disembah oleh ayahmu, dan yang disembah oleh nenek moyangmu Abraham, Isak, dan Yakub.” Maka Musa menyembunyikan wajahnya karena takut melihat Allah. ");
INSERT INTO ind_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kata TUHAN kepadanya, “Sesungguhnya, Aku sudah melihat betapa umat-Ku ditindas di Mesir dan Aku mendengar seruan mereka atas perlakuan kejam para mandor terhadap mereka. Aku mengetahui penderitaan mereka. ");
INSERT INTO ind_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kini Aku datang untuk membebaskan mereka dari tangan orang Mesir. Aku akan memimpin mereka keluar dari negeri itu dan membawa mereka ke negeri yang baik dan luas, yang berlimpah dengan hasil alam, yaitu ke negeri orang Kanaan, Het, Amori, Feris, Hewi, dan Yebus. ");
INSERT INTO ind_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Seruan umat Israel sudah sampai kepada-Ku, dan Aku sudah menyaksikan betapa kejamnya orang Mesir menindas mereka. ");
INSERT INTO ind_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sekarang, pergilah. Aku mengutusmu menghadap raja Mesir untuk membawa umat-Ku, keturunan Israel, keluar dari Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Jawab Musa kepada Allah, “Aku ini bukan siapa-siapa! Bagaimana mungkin aku bisa menghadap raja dan membawa keturunan Israel keluar dari Mesir?” ");
INSERT INTO ind_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Jawab Allah, “Aku akan menyertaimu, dan inilah tanda bagimu bahwa Akulah yang mengutusmu: Setelah kamu membawa umat-Ku keluar dari Mesir, kalian akan menyembah-Ku di gunung ini.” ");
INSERT INTO ind_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa menjawab, “Kalau aku pergi menemui umat Israel dan berkata kepada mereka, ‘Allah nenek moyang kita sudah mengutus saya kepada kalian,’ tentu mereka akan bertanya, ‘Siapakah nama-Nya?’ Lalu aku harus menjawab apa?” ");
INSERT INTO ind_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kata Allah kepada Musa, “Aku adalah Aku. Katakanlah kepada umat Israel bahwa ‘Akulah Aku’ yang mengutus kamu kepada mereka. ");
INSERT INTO ind_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Katakan juga kepada mereka, ‘TUHAN, Allah Abraham, Allah Isak, dan Allah Yakub, yaitu Allah nenek moyang kalian, sudah mengutus saya kepadamu.’ Semua sebutan itu merupakan nama-Ku untuk selama-lamanya. Demikianlah kalian akan memanggil nama-Ku turun temurun. ");
INSERT INTO ind_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Pergilah dan kumpulkan tua-tua Israel, lalu katakanlah kepada mereka: TUHAN Allah nenek moyang kita, Allah Abraham, Isak, dan Yakub, sudah menjumpai saya dan berkata, ‘Aku sudah memperhatikan kalian dan melihat bagaimana kalian diperlakukan di Mesir. ");
INSERT INTO ind_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Aku berjanji akan membawa kalian keluar dari penindasan di Mesir ke negeri orang Kanaan, Het, Amori, Feris, Hewi dan Yebus, ke negeri yang berlimpah dengan hasil alam.’” ");
INSERT INTO ind_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Kata Allah selanjutnya kepada Musa, “Para tua-tua Israel akan mendengarkanmu, lalu kalian akan pergi menghadap raja dan berkata kepadanya, ‘TUHAN, Allah umat Israel, sudah menjumpai kami. Oleh karena itu, izinkanlah kami melakukan perjalanan selama tiga hari ke padang belantara, agar kami dapat mempersembahkan kurban kepada TUHAN Allah kami.’ ");
INSERT INTO ind_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Aku tahu bahwa raja Mesir tidak akan membiarkan kalian pergi begitu saja, kecuali dipaksa oleh kuasa yang besar. ");
INSERT INTO ind_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Maka Aku akan memakai kuasa-Ku dan menghantam Mesir dengan segala perbuatan-Ku yang ajaib. Sesudah itu barulah dia akan membiarkan kalian pergi. ");
INSERT INTO ind_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Aku akan menggerakkan hati orang Mesir agar mereka berbaik hati kepada kalian, sehingga kalian tidak akan pergi dengan tangan kosong. ");
INSERT INTO ind_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Setiap perempuan Israel akan meminta perhiasan emas, perak, dan pakaian dari tetangganya yang orang Mesir, termasuk siapa pun perempuan Mesir yang kebetulan menginap di rumah tetangga itu. Kamu akan mengenakan perhiasan dan pakaian itu pada anak-anakmu, baik yang laki-laki maupun perempuan. Demikianlah kamu akan merampas harta orang Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Jawab Musa, “Bagaimana kalau umat Israel tidak percaya dan tidak mau mendengarkanku? Bagaimana kalau mereka berkata, ‘TUHAN tidak menjumpai kamu!’” ");
INSERT INTO ind_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kata TUHAN kepada Musa, “Apa itu yang ada di tanganmu?” Jawab Musa, “Tongkat.” ");
INSERT INTO ind_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Lalu TUHAN berkata, “Lemparkanlah tongkat itu ke tanah.” Maka Musa melemparkan tongkatnya ke tanah, dan seketika tongkat itu berubah menjadi seekor ular. Musa pun lari menjauh. ");
INSERT INTO ind_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tetapi TUHAN berkata kepada Musa, “Ulurkanlah tanganmu dan peganglah ekornya.” Musa mengulurkan tangannya dan menangkap ekor ular itu, lalu ular itu berubah kembali menjadi tongkat. ");
INSERT INTO ind_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Berkatalah TUHAN, “Lakukanlah itu supaya umat Israel percaya bahwa TUHAN Allah nenek moyang mereka, yaitu Allah Abraham, Allah Isak, dan Allah Yakub, sudah menjumpai kamu.” ");
INSERT INTO ind_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","TUHAN berkata lagi kepada Musa, “Masukkanlah tanganmu ke dalam jubahmu.” Maka Musa memasukkan tangannya ke dalam jubahnya, dan ketika dia mengeluarkan tangannya, tampaklah tangannya terkena penyakit kulit sehingga terkelupas dan bersisik warna putih seperti salju. ");
INSERT INTO ind_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Lalu TUHAN berkata lagi, “Masukkan kembali tanganmu ke dalam jubahmu.” Maka Musa pun memasukkan lagi tangannya ke dalam jubahnya, dan ketika dia mengeluarkan tangannya, tampaklah tangannya sudah pulih seperti semula. ");
INSERT INTO ind_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","TUHAN berkata, “Jika mereka tidak percaya kepadamu atau tidak mengindahkan keajaiban pertama yang Aku berikan, mereka akan percaya pada keajaiban yang kedua. ");
INSERT INTO ind_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Apabila mereka tidak mempercayai dua keajaiban itu dan tidak menuruti perkataanmu, ambillah air dari sungai Nil dan tumpahkanlah ke tanah. Air itu akan berubah menjadi darah.” ");
INSERT INTO ind_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Tetapi Musa berkata kepada TUHAN, “Ya Penguasaku, aku ini tidak pandai berbicara. Sejak dulu hingga sekarang setelah TUHAN berbicara denganku pun, cara bicaraku lambat dan tidak lancar.” ");
INSERT INTO ind_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kemudian TUHAN berkata, “Siapakah yang menciptakan mulut manusia? Siapakah yang menetapkan seseorang menjadi bisu atau tuli? Siapakah yang membuat manusia buta atau melihat? Bukankah Aku, TUHAN yang melakukannya? ");
INSERT INTO ind_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Pergilah sekarang! Aku akan menyertaimu ketika kamu berbicara dan memberitahukan apa yang harus kamu katakan.” ");
INSERT INTO ind_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tetapi Musa menjawab, “Ya Penguasaku, mohon utuslah orang lain saja.” ");
INSERT INTO ind_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Maka TUHAN menjadi marah kepada Musa dan berkata, “Bagaimana dengan Harun, kakakmu itu? Dia seorang Lewi yang fasih berbicara. Sekarang dia sedang dalam perjalanan untuk menemuimu. Dia akan sangat senang saat bertemu denganmu. ");
INSERT INTO ind_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kamu akan berbicara dengannya dan menyampaikan apa yang harus dia katakan. Aku akan menolong kalian berdua untuk berbicara dan memberitahukan apa yang harus kalian lakukan. ");
INSERT INTO ind_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Harun akan menjadi juru bicaramu kepada umat Israel, dan kamu akan menjadi seperti Allah baginya dengan cara memberitahukan kepadanya apa yang harus dia katakan. ");
INSERT INTO ind_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Bawalah tongkat ini. Kamu akan menggunakannya untuk melakukan berbagai keajaiban.” ");
INSERT INTO ind_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Kemudian Musa kembali ke Midian, dan TUHAN berkata kepadanya, “Kembalilah ke Mesir, karena semua yang ingin membunuhmu sudah mati.” Maka Musa pamit kepada Yitro mertuanya, “Izinkanlah aku kembali ke Mesir untuk mencari tahu apakah saudara-saudaraku masih hidup.” Jawab Yitro, “Baik, pergilah. Semoga kamu selamat dalam perjalanan.” ");
INSERT INTO ind_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Jadi, berangkatlah Musa ke Mesir dengan membawa istri dan anak-anaknya di atas keledai. Dia juga membawa tongkatnya sesuai perintah Allah. ");
INSERT INTO ind_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","TUHAN berkata kepada Musa, “Aku sudah membuat kamu mampu melakukan keajaiban-keajaiban. Ketika kamu sudah di Mesir, lakukanlah keajaiban itu di hadapan raja. Namun, Aku akan mengeraskan hatinya sehingga dia tidak membiarkan umat-Ku pergi. ");
INSERT INTO ind_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Lalu katakanlah kepadanya, ‘Inilah perkataan TUHAN: Umat Israel itu bagaikan anak-Ku, anak yang sulung. ");
INSERT INTO ind_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Aku sudah menyuruhmu untuk membiarkan anak-Ku itu pergi menyembah-Ku. Tetapi karena kamu menolak, maka Aku akan membunuh anakmu yang sulung!’” ");
INSERT INTO ind_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dalam perjalanan ke Mesir itu, ketika mereka sedang berkemah pada suatu malam, TUHAN menemui Musa dan bermaksud membunuhnya. ");
INSERT INTO ind_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Lalu Sipora mengambil sebuah batu yang tajam seperti pisau dan menyunat anak mereka. Kemudian dia menyentuh kaki Musa dengan kulit khatan itu sambil berkata, “Suamiku, kamu ditandai dengan darah.” Darah yang dimaksud Sipora adalah darah karena sunat tersebut. Sesudah itu, TUHAN membiarkan Musa hidup. ");
INSERT INTO ind_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","TUHAN berkata kepada Harun, “Pergilah ke padang belantara untuk menemui Musa.” Maka dia pergi dan menemui Musa di gunung Allah, lalu dia memeluk adiknya itu. ");
INSERT INTO ind_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa memberitahu Harun semua perkataan TUHAN yang harus disampaikan kepada raja Mesir, juga keajaiban-keajaiban yang TUHAN perintahkan kepada Musa untuk dilakukan. ");
INSERT INTO ind_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kemudian mereka pergi ke Mesir. Setibanya di sana, Musa dan Harun mengumpulkan semua tua-tua umat Israel. ");
INSERT INTO ind_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harun menyampaikan kepada mereka segala hal yang sudah TUHAN sampaikan kepada Musa. Lalu Musa melakukan keajaiban-keajaiban di hadapan mereka. ");
INSERT INTO ind_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Para tua-tua itu pun percaya, dan ketika mereka mendengar bahwa TUHAN sudah memperhatikan umat Israel dan segala penindasan yang mereka alami, bersujudlah mereka menyembah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Sesudah itu, Musa dan Harun pergi menghadap raja Mesir untuk berbicara kepadanya, “TUHAN Allah Israel berkata, ‘Biarkanlah umat-Ku pergi, agar mereka dapat mengadakan perayaan bagi-Ku di padang belantara.’” ");
INSERT INTO ind_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tetapi raja Mesir menjawab, “Siapakah ‘Tuhan’ itu sehingga saya harus mematuhi perintahnya dan membiarkan orang Israel pergi? Saya tidak mengenal ‘Tuhan’, dan saya juga tidak akan membiarkan orang Israel pergi!” ");
INSERT INTO ind_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Lalu mereka berkata, “Allah Israel sudah menjumpai kami. Kami mohon, izinkanlah kami pergi dan melakukan perjalanan selama tiga hari ke padang belantara untuk mempersembahkan kurban kepada TUHAN Allah kami, agar Dia tidak menghukum kami dengan wabah penyakit atau perang.” ");
INSERT INTO ind_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Namun, raja Mesir berkata kepada mereka, “Hei, Musa dan Harun, mengapa kalian membawa-bawa para budak? Mereka harus tetap bekerja! ");
INSERT INTO ind_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Jumlah bangsamu sudah sangat banyak, dan sekarang kalian sengaja hendak membuat mereka berhenti bekerja!” ");
INSERT INTO ind_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hari itu juga, raja Mesir memerintahkan para kepala mandor Mesir dan mandor Israel dengan berkata, ");
INSERT INTO ind_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mulai sekarang, kalian tidak boleh memberikan jerami kepada budak-budak itu untuk membuat batu bata seperti sebelumnya. Biarlah mereka pergi mengumpulkan jerami sendiri. ");
INSERT INTO ind_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tetapi pastikan bahwa jumlah batu bata yang mereka hasilkan dalam sehari tetap sama seperti sebelumnya. Mereka itu pemalas! Itulah sebabnya mereka menuntut untuk pergi mempersembahkan kurban kepada dewa mereka. ");
INSERT INTO ind_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Paksalah mereka bekerja lebih keras lagi, supaya mereka sibuk dengan pekerjaan sehingga tidak ada waktu untuk mendengarkan omong kosong itu.” ");
INSERT INTO ind_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Maka semua kepala mandor Mesir dan mandor Israel pergi dan berkata kepada umat Israel, “Raja sudah menetapkan bahwa dia tidak akan menyediakan jerami lagi untuk pembuatan batu bata. ");
INSERT INTO ind_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Pergilah mencari jerami sendiri, terserah dari mana saja, tetapi kalian harus tetap menghasilkan batu bata sebanyak sebelumnya, tidak boleh berkurang sedikit pun!” ");
INSERT INTO ind_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Jadi, umat Israel menyebar untuk mencari jerami ke seluruh negeri Mesir. ");
INSERT INTO ind_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Dan para kepala mandor Mesir menekan mereka dengan berkata, “Selesaikan pekerjaan harian kalian sama seperti dulu waktu jerami masih disediakan.” ");
INSERT INTO ind_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Para kepala mandor Mesir memukuli mandor-mandor Israel, yang diberi tanggung jawab atas pekerjaan umat Israel. Kata mereka, “Kenapa kamu tidak menghasilkan batu bata sebanyak kemarin?!” ");
INSERT INTO ind_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Lalu para mandor Israel menghadap raja dan memohon, “Yang Mulia, mengapa engkau memperlakukan kami, hamba-hambamu, seperti ini? ");
INSERT INTO ind_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Sekarang kami tidak diberi jerami, tetapi kami tetap dituntut membuat batu bata. Rakyatmu sendiri yang bersalah! Mengapa kami yang harus dipukuli?!” ");
INSERT INTO ind_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Namun raja menjawab, “Pemalas! Kalian memang malas! Karena itu kalian terus berkata, ‘Izinkan kami pergi menyembah dewa kami’ sebagai alasan untuk tidak bekerja! ");
INSERT INTO ind_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pergi dan kembalilah bekerja! Jerami tetap tidak akan disediakan untuk kalian, tetapi kalian harus memenuhi jumlah batu bata yang sama seperti sebelumnya.” ");
INSERT INTO ind_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Mendengar perintah itu, yakni bahwa jumlah batu bata yang harus mereka penuhi tetap sama dan tidak dikurangi, para mandor Israel pun menyadari betapa berat masalah yang kini mereka hadapi. ");
INSERT INTO ind_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Sesudah pertemuan dengan raja Mesir, mandor-mandor Israel itu menemui Musa dan Harun yang sedang menunggu mereka keluar. ");
INSERT INTO ind_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kata mereka kepada Musa dan Harun, “Gara-gara kalian, kami semakin dibenci oleh raja dan para pejabatnya! Biarlah TUHAN mengadili dan menghukum kalian berdua! Akibat perbuatanmu, matilah kami!” ");
INSERT INTO ind_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa kembali menghadap TUHAN dan berkata, “Ya Penguasaku, mengapa Engkau menambah masalah kepada umat-Mu? Untuk apa Engkau mengutus aku? ");
INSERT INTO ind_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sejak aku menghadap raja dan menyampaikan pesan-Mu, dia malah semakin keras menindas umat-Mu dan Engkau tidak melakukan apa pun untuk menolong mereka!” ");
INSERT INTO ind_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Lalu TUHAN berkata kepada Musa, “Sekarang kamu akan melihat apa yang akan Aku lakukan terhadap raja Mesir. Aku akan memaksanya untuk membiarkan umat-Ku pergi, bahkan dia akan mengusir mereka keluar dari negerinya.” ");
INSERT INTO ind_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Lagi kata TUHAN kepada Musa, “Akulah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Aku sudah menyatakan diri kepada Abraham, Isak, dan Yakub sebagai Allah Yang Mahakuasa, tetapi Aku tidak memperkenalkan nama-Ku, TUHAN, kepada mereka. ");
INSERT INTO ind_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Aku juga sudah mengadakan perjanjian dengan mereka. Aku berjanji akan memberikan kepada mereka negeri Kanaan, di mana mereka dulu hidup sebagai pendatang. ");
INSERT INTO ind_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Aku pun sudah mendengar keluh kesah umat Israel yang diperbudak bangsa Mesir, dan Aku mengingat perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Karena itu, sampaikanlah kepada umat Israel, ‘Akulah TUHAN. Aku akan membawa kalian keluar dari perbudakan bangsa Mesir. Aku akan menghukum bangsa Mesir dengan hukuman berat, dan dengan kuasa-Ku, Aku akan membebaskan kalian. ");
INSERT INTO ind_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Aku akan mengangkat kalian sebagai umat-Ku, dan Aku akan menjadi Allah kalian. Kalian akan tahu bahwa Akulah TUHAN Allahmu yang sudah membebaskan kalian dari perbudakan bangsa Mesir. ");
INSERT INTO ind_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Aku akan membawa kalian ke negeri yang Aku janjikan dengan bersumpah kepada Abraham, Isak, dan Yakub. Aku akan memberikan negeri itu kepada kalian sebagai milikmu sendiri. Akulah TUHAN.’” ");
INSERT INTO ind_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa menyampaikan semua pesan itu kepada bangsa Israel, tetapi mereka tidak mau percaya, karena terlalu tertekan oleh perbudakan yang kejam dan sudah sangat putus asa. ");
INSERT INTO ind_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kemudian TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pergilah menghadap raja Mesir dan katakan kepadanya bahwa dia harus membiarkan umat Israel pergi dari negerinya.” ");
INSERT INTO ind_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa menjawab, “Tetapi selama ini umat Israel pun tidak mendengarkan aku, apalagi raja Mesir! Mana mungkin dia mendengarkan aku, orang yang tidak pandai bicara ini!” ");
INSERT INTO ind_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Meski demikian, TUHAN tetap mengutus Musa dan Harun kepada umat Israel dan raja Mesir dengan perintah untuk memimpin umat Israel keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Berikut ini adalah nama-nama kepala keluarga keturunan Yakub. Anak sulungnya adalah Ruben. Anak-anak Ruben bernama Henok, Palu, Hesron, dan Karmi. Keturunan mereka masing-masing menjadi marga-marga dalam suku Ruben. ");
INSERT INTO ind_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Anak-anak Simeon bernama Yemuel, Yamin, Ohad, Yakin, Zohar, dan Saul (ibu Saul adalah orang Kanaan). Keturunan mereka masing-masing menjadi marga-marga dalam suku Simeon. ");
INSERT INTO ind_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Anak-anak Lewi sesuai urutan bernama Gerson, Kehat, dan Merari. Lewi hidup selama 137 tahun. ");
INSERT INTO ind_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Anak-anak Gerson bernama Libni dan Simei. Keturunan mereka menjadi marga Libni dan marga Simei. ");
INSERT INTO ind_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Anak-anak Kehat bernama Amram, Yisar, Hebron, dan Uziel. Kehat hidup selama 133 tahun. ");
INSERT INTO ind_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Anak-anak Merari bernama Mahli dan Musi. Itulah marga-marga dalam suku Lewi sesuai garis keturunan mereka. ");
INSERT INTO ind_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram menikah dengan saudara perempuan ayahnya bernama Yokebet. Mereka mempunyai dua anak laki-laki, Harun dan Musa. Amram hidup selama 137 tahun. ");
INSERT INTO ind_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Anak-anak Yisar bernama Korah, Nefeg, dan Sikri. ");
INSERT INTO ind_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Anak-anak Uziel bernama Misael, Elsafan, dan Sitri. ");
INSERT INTO ind_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harun menikah dengan Eliseba, anak Aminadab, saudara perempuan Nahason. Dia melahirkan Nadab, Abihu, Eleasar, dan Itamar. ");
INSERT INTO ind_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Anak-anak Korah bernama Asir, Elkana, dan Abiasaf. Keturunan mereka masing-masing menjadi marga-marga Korah. ");
INSERT INTO ind_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar, anak Harun, menikah dengan salah satu anak perempuan Putiel. Dia melahirkan Pinehas. Itulah nenek moyang marga-marga dalam suku Lewi. ");
INSERT INTO ind_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Harun dan Musa diperintahkan TUHAN untuk membawa umat Israel keluar dari tanah Mesir, dalam rombongan besar menurut pasukan-pasukan mereka. ");
INSERT INTO ind_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Kedua orang itulah yang berbicara kepada raja Mesir untuk membawa umat Israel keluar dari negeri Mesir. ");
INSERT INTO ind_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","TUHAN berkata kepada Musa di Mesir, ");
INSERT INTO ind_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Akulah TUHAN! Beritahukanlah kepada raja Mesir segala pesan yang Aku sampaikan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Namun, Musa menjawab TUHAN, “Aku tidak pandai berbicara. Raja pasti tidak akan mendengarkan aku!” ");
INSERT INTO ind_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","TUHAN berkata kepada Musa, “Lihatlah, Aku mengangkatmu menjadi seperti Allah bagi raja Mesir, dan kakakmu Harun akan menjadi seperti nabimu. ");
INSERT INTO ind_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kamu akan mengatakan semua yang Aku perintahkan kepadamu, dan Harun akan menyampaikan kepada raja untuk membiarkan umat Israel keluar dari negerinya. ");
INSERT INTO ind_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tetapi Aku akan mengeraskan hati raja, sehingga meskipun Aku membuat berbagai macam keajaiban-Ku di Mesir, ");
INSERT INTO ind_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","dia tetap tidak akan mendengarkanmu. Maka dengan kuasa-Ku, Aku akan menjatuhkan hukuman berat kepada bangsa Mesir dan membawa kedua belas suku umat-Ku keluar dari sana dalam rombongan besar, menurut pasukan-pasukan mereka. ");
INSERT INTO ind_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Saat itu, orang-orang Mesir akan mengetahui bahwa Akulah TUHAN, yakni ketika Aku menghukum Mesir dengan kuasa-Ku dan membawa umat-Ku Israel keluar dari antara mereka.” ");
INSERT INTO ind_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Lalu Musa dan Harun melakukan tepat seperti yang diperintahkan TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Saat mereka pergi menghadap raja, Musa berusia delapan puluh tahun dan Harun berusia delapan puluh tiga tahun. ");
INSERT INTO ind_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Jika raja Mesir berkata kepada kalian, ‘Buktikanlah dirimu dengan melakukan keajaiban,’ maka katakanlah kepada Harun, ‘Ambillah tongkatmu dan lemparkanlah ke tanah di hadapan raja.’ Nanti tongkat itu akan berubah menjadi ular.” ");
INSERT INTO ind_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa dan Harun pun menghadap raja dan melakukan sesuai dengan yang diperintahkan TUHAN. Harun melemparkan tongkatnya di hadapan raja dan para pejabatnya, lalu tongkat itu berubah menjadi ular. ");
INSERT INTO ind_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kemudian raja memanggil orang-orang pintar serta para ahli sihir untuk menghadap, dan mereka juga melakukan hal yang sama dengan keahlian mereka. ");
INSERT INTO ind_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Masing-masing melemparkan tongkatnya, dan tongkat-tongkat itu berubah menjadi ular. Namun, ular dari tongkat Harun menelan semua ular mereka. ");
INSERT INTO ind_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Meski demikian, raja tetap mengeraskan hatinya, seperti yang sudah dikatakan TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kemudian TUHAN berkata kepada Musa, “Raja Mesir tetap berkeras hati. Dia menolak untuk membiarkan umat Israel pergi. ");
INSERT INTO ind_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Karena itu, besok pagi datanglah kepadanya pada waktu biasanya dia pergi ke tepi sungai Nil. Ketika kamu melihatnya berjalan menuju sungai, tunggulah di tepi sungai untuk menemui dia. Bawalah tongkatmu yang bisa berubah menjadi ular, ");
INSERT INTO ind_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","dan katakanlah kepadanya, ‘TUHAN, Allah umat Israel, sudah mengutus saya untuk menyampaikan kepadamu, “Biarkan umat-Ku pergi supaya mereka dapat menyembah-Ku di padang belantara.” Tetapi sampai sekarang, engkau tetap tidak mau mendengarkan. ");
INSERT INTO ind_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Jadi, beginilah kata TUHAN, “Dengan ini, engkau akan tahu bahwa Akulah TUHAN.” Lihatlah! Saya akan memukul permukaan air sungai Nil dengan tongkat yang di tangan saya ini, dan airnya akan berubah menjadi darah. ");
INSERT INTO ind_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ikan di sungai akan mati sehingga airnya berbau busuk dan orang Mesir tidak dapat meminumnya.’” ");
INSERT INTO ind_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Lalu TUHAN berkata kepada Musa, “Katakanlah kepada Harun, ‘Ambillah tongkatmu dan ulurkanlah ke atas segala macam perairan di Mesir, termasuk sungai-sungai, aliran air, kolam-kolam, dan tempat-tempat menampung air, agar semuanya berubah menjadi darah. Akan ada darah di seluruh negeri Mesir, bahkan di dalam tempat penyimpanan air dari kayu maupun batu.’” ");
INSERT INTO ind_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa dan Harun melakukan tepat seperti yang TUHAN perintahkan. Di depan mata raja dan para pejabatnya, Harun mengangkat tongkatnya dan memukul air sungai Nil. Maka semua air itu berubah menjadi darah, ");
INSERT INTO ind_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","dan matilah ikan-ikan di sungai itu sehingga airnya berbau busuk dan orang Mesir tidak dapat meminumnya. Di seluruh Mesir ada darah. ");
INSERT INTO ind_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Namun, para ahli sihir Mesir juga melakukan hal yang sama dengan keahlian mereka. Karena itu raja tetap mengeraskan hatinya dan tidak mendengarkan mereka, seperti yang sudah dikatakan TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Raja berpaling dan kembali ke istananya tanpa menghiraukan bencana yang sudah terjadi. ");
INSERT INTO ind_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sementara itu, seluruh rakyat Mesir menggali-gali lubang di sepanjang sungai Nil untuk mencari air yang bisa diminum, karena mereka tidak dapat meminum air sungai itu. ");
INSERT INTO ind_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tujuh hari pun berlalu setelah TUHAN mengubah air sungai Nil menjadi darah. ");
INSERT INTO ind_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","TUHAN berkata kepada Musa, “Pergilah menghadap raja Mesir dan sampaikan kepadanya, ‘Inilah yang dikatakan TUHAN: Biarkanlah umat-Ku pergi supaya mereka dapat menyembah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kalau engkau menolak, Aku akan memenuhi negerimu dengan katak. ");
INSERT INTO ind_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sungai Nil akan penuh dengan katak, sampai hewan-hewan itu memasuki istanamu, kamar tidurmu, tempat tidurmu, rumah-rumah para pejabatmu dan seluruh rakyatmu, bahkan ke dalam semua tempat pembakaran makanan dan peralatan masak kalian. ");
INSERT INTO ind_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Katak-katak itu akan melompat ke atas tubuhmu, seluruh pegawaimu, juga rakyatmu.’” ");
INSERT INTO ind_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kemudian TUHAN berkata kepada Musa, “Sampaikan kepada Harun untuk mengulurkan tongkat yang ada di tangannya ke atas sungai-sungai, aliran air, serta kolam. Buatlah katak-katak bermunculan memenuhi seluruh negeri Mesir!” ");
INSERT INTO ind_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Maka Harun mengulurkan tongkatnya ke atas perairan Mesir, lalu katak-katak keluar dan menutupi seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Akan tetapi, para ahli sihir negeri itu juga melakukan hal yang sama dengan keahlian mereka, dan katak-katak pun bermunculan memenuhi Mesir. ");
INSERT INTO ind_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kemudian raja memanggil Musa dan Harun untuk menghadap dan berkata kepada mereka, “Mintalah kepada dewamu itu untuk melenyapkan katak-katak ini dari saya dan bangsa saya, maka saya akan membiarkan bangsamu pergi untuk mempersembahkan kurban kepada dewamu.” ");
INSERT INTO ind_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Jawab Musa, “Tentukanlah waktunya, maka saya akan berdoa kepada TUHAN meminta agar semua katak ini dilenyapkan darimu, dari para pegawaimu, dari rakyatmu, dan dari rumah-rumah kalian. Katak hanya akan berada di sungai Nil.” ");
INSERT INTO ind_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Raja menjawab, “Paling lama besok.” Kata Musa, “Baik, permintaanmu akan dipenuhi, agar kalian tahu bahwa tidak ada dewa yang seperti TUHAN Allah kami. ");
INSERT INTO ind_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Katak-katak itu akan menyingkir darimu, dari para pejabatmu, rakyatmu, dan dari rumah-rumah kalian. Katak hanya akan tinggal di sungai Nil.” ");
INSERT INTO ind_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Lalu Musa dan Harun pergi meninggalkan raja. Sesuai janjinya kepada raja Mesir, Musa berseru dalam doanya kepada TUHAN, meminta agar bencana katak disingkirkan. ");
INSERT INTO ind_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","TUHAN mengabulkan permintaan Musa. Maka matilah semua katak yang ada di setiap rumah, halaman, dan ladang. ");
INSERT INTO ind_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Orang-orang Mesir mengumpulkan bangkai katak itu, hingga seluruh negeri berbau busuk. ");
INSERT INTO ind_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Namun, ketika raja melihat bahwa mereka sudah terbebas dari katak-katak itu, dia kembali mengeraskan hatinya dan tidak mau mendengarkan Musa dan Harun, tepat seperti yang sudah dikatakan TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kemudian TUHAN berkata kepada Musa, “Katakanlah kepada Harun, ‘Angkatlah tongkatmu dan pukulkan ke tanah, maka debu akan berubah menjadi agas yang memenuhi seluruh negeri Mesir.’” ");
INSERT INTO ind_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Lalu terjadilah demikian. Harun mengulurkan tongkat yang ada di tangannya dan memukulkannya ke tanah yang berdebu, maka semua debu di seluruh Mesir berubah menjadi agas lalu menghinggapi semua orang dan binatang. ");
INSERT INTO ind_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Agas-agas itu mengerubungi manusia maupun hewan. Para ahli sihir berusaha dengan seluruh kemampuan mereka untuk melakukan hal yang sama, tetapi mereka tidak dapat membuat agas dari debu. ");
INSERT INTO ind_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Maka berkatalah para ahli sihir itu kepada raja, “Ini pasti perbuatan Allahnya Musa dan Harun!” Namun, seperti yang sudah TUHAN katakan sebelumnya, raja tetap bersikeras dan tidak mau mendengarkan mereka. ");
INSERT INTO ind_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kemudian TUHAN berkata kepada Musa, “Besok kamu harus bangun pagi-pagi sekali dan pergi menghadap raja ketika dia turun ke sungai. Sampaikanlah kepadanya: Beginilah perkataan TUHAN kepadamu, ‘Biarkanlah umat-Ku pergi, supaya mereka dapat menyembah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kalau engkau tidak membiarkan umat-Ku pergi, Aku akan mengirimkan kerumunan lalat kepadamu, kepada semua pejabatmu, rakyatmu, dan ke dalam rumah-rumah kalian. Setiap rumah orang Mesir akan dipenuhi dengan kerumunan lalat, bahkan tanah tempat kalian berdiri pun akan penuh dengan lalat. ");
INSERT INTO ind_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pada hari itu, Aku akan membedakan tempat tinggal umat-Ku di Gosyen. Daerah itu akan bebas dari kerumunan lalat, supaya engkau tahu bahwa Aku, TUHAN, ada di negeri ini. ");
INSERT INTO ind_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Aku akan membedakan antara umat-Ku dan rakyatmu. Keajaiban ini akan terjadi besok.’” ");
INSERT INTO ind_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Dan TUHAN melakukan apa yang Dia katakan. Kerumunan lalat mengerubungi istana raja serta rumah para pejabat. Lalat-lalat itu memenuhi dan membuat seluruh negeri menjadi kotor. ");
INSERT INTO ind_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Sesudah itu, raja memanggil Musa dan Harun lalu berkata, “Pergilah, persembahkanlah kurban bagi dewa kalian, tetapi di dalam negeri ini saja.” ");
INSERT INTO ind_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Jawab Musa, “Tidak bisa, karena memberikan persembahan kurban bagi TUHAN Allah kami merupakan suatu kegiatan yang menjijikkan di mata orang Mesir. Apabila kami melakukannya di depan mereka, pasti mereka melempari kami dengan batu. ");
INSERT INTO ind_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Untuk memberikan persembahan sesuai perintah TUHAN yang kami sembah, kami harus melakukan perjalanan selama tiga hari ke padang belantara.” ");
INSERT INTO ind_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Raja pun menjawab, “Saya akan memperbolehkan kalian pergi untuk mempersembahkan kurban kepada dewa kalian, di padang belantara, tetapi jangan pergi terlalu jauh. Dan saya minta kalian mendoakan saya.” ");
INSERT INTO ind_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Lalu Musa berkata, “Baik. Sekarang saya akan pergi dan memohon kepada TUHAN agar besok kerumunan lalat meninggalkan engkau, para pejabatmu, serta rakyatmu. Tetapi, kali ini janganlah Baginda berbuat curang lagi dengan melarang bangsa Israel pergi mempersembahkan kurban kepada TUHAN!” ");
INSERT INTO ind_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Kemudian Musa pergi meninggalkan raja dan berdoa kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","TUHAN mengabulkan permintaan Musa dengan menghilangkan kerumunan lalat dari raja, para pejabat, serta rakyatnya. Tidak ada seekor pun lalat yang tertinggal. ");
INSERT INTO ind_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Namun, kali ini pun raja kembali mengeraskan hatinya dan tidak memperbolehkan bangsa Israel pergi. ");
INSERT INTO ind_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","TUHAN berkata kepada Musa, “Pergilah menghadap raja dan sampaikan bahwa TUHAN, Allah umat Israel, berkata, ‘Biarkanlah umat-Ku pergi agar mereka dapat menyembah-Ku! ");
INSERT INTO ind_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Jika engkau menolak dan tetap menahan mereka, ");
INSERT INTO ind_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","maka dengan kuasa-Ku, Aku akan mendatangkan wabah penyakit yang sangat parah atas ternakmu, yaitu kuda, keledai, unta, domba, kambing, dan sapi. ");
INSERT INTO ind_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Dalam wabah ini, Aku akan membedakan ternak milik umat Israel dari ternak milik orang Mesir. Tidak seekor pun ternak milik umat Israel yang akan mati.’” ");
INSERT INTO ind_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","TUHAN juga menentukan waktu terjadinya wabah itu. Dia berkata kepada Musa, “Aku akan melakukan bencana ini besok.” ");
INSERT INTO ind_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Keesokan harinya, TUHAN menepati perkataan-Nya itu. Semua ternak milik orang Mesir mati, tetapi tidak satu pun ternak orang Israel yang mati. ");
INSERT INTO ind_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Lalu raja mengirim utusannya untuk menyelidiki, dan benarlah demikian, bahwa tidak ada satu pun ternak umat Israel yang mati. Meski begitu, raja mengeraskan hatinya dan tidak mau membiarkan mereka pergi. ");
INSERT INTO ind_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Lalu TUHAN berkata kepada Musa dan Harun, “Ambillah beberapa genggam abu dari tempat pembakaran. Musa harus melemparkan abu itu ke udara di hadapan raja. ");
INSERT INTO ind_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Abu itu akan menjadi debu halus yang akan tersebar ke seluruh Mesir dan menyebabkan bisul-bisul bernanah pada manusia dan binatang di seluruh Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","11","Maka Musa dan Harun mengambil abu dari tempat pembakaran dan menghadap raja. Musa melemparkan abu itu ke udara, lalu timbullah bisul-bisul bernanah pada kulit semua orang dan binatang di Mesir. Mereka sangat menderita, bahkan para ahli sihir tidak sanggup berdiri di hadapan Musa karena kesakitan akibat bisul bernanah itu. ");
INSERT INTO ind_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tetapi TUHAN mengeraskan hati raja, dan seperti yang sudah TUHAN katakan sebelumnya, raja tetap tidak menghiraukan perkataan Musa dan Harun. ");
INSERT INTO ind_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kemudian TUHAN berkata kepada Musa, “Besok, bangunlah pagi-pagi dan pergilah menghadap raja Mesir. Katakanlah kepadanya, ‘TUHAN, Allah umat Israel, berkata: Biarkanlah umat-Ku pergi agar mereka dapat menyembah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kalau tidak, maka kali ini Aku akan mendatangkan bencana yang lebih hebat lagi kepadamu, para pegawaimu, dan rakyatmu, agar engkau tahu bahwa tidak ada yang seperti Aku di seluruh bumi ini. ");
INSERT INTO ind_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Aku bisa saja menggunakan kuasa-Ku untuk menyerang engkau dan rakyatmu dengan penyakit serta melenyapkan kalian dari muka bumi. ");
INSERT INTO ind_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tetapi Aku membiarkan engkau hidup untuk tujuan ini, yaitu menunjukkan kuasa-Ku kepadamu. Dengan demikian, nama-Ku akan dimuliakan di seluruh bumi. ");
INSERT INTO ind_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Meskipun demikian, engkau masih saja sombong dan tidak membiarkan umat-Ku pergi. ");
INSERT INTO ind_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Besok, sekitar waktu yang sama seperti sekarang, Aku akan menurunkan hujan es yang sangat dahsyat, yang belum pernah terjadi sebelumnya di seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Karena itu, bawalah seluruh ternak kalian yang berada di padang untuk berlindung ke tempat yang aman. Setiap orang dan binatang yang masih di padang akan mati tertimpa hujan es!’” ");
INSERT INTO ind_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Maka para pejabat raja yang takut akan perkataan TUHAN segera membawa masuk semua budak dan ternak mereka untuk berlindung. ");
INSERT INTO ind_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tetapi orang-orang yang tidak menghiraukan perkataan TUHAN membiarkan budak dan ternak mereka di padang. ");
INSERT INTO ind_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Lalu TUHAN berkata kepada Musa, “Arahkanlah tanganmu ke langit, agar hujan es turun di seluruh Mesir menimpa setiap orang, binatang, dan tanaman di padang.” ");
INSERT INTO ind_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa mengarahkan tongkatnya ke langit, dan TUHAN menurunkan hujan es di seluruh tanah Mesir disertai guntur dan petir yang menyambar-nyambar ke tanah. ");
INSERT INTO ind_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sepanjang sejarah bangsa Mesir, belum pernah terjadi hujan es yang turun terus-menerus beserta sambaran petir seperti ini. ");
INSERT INTO ind_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Hujan es menghantam semua yang ada di ladang di seluruh Mesir, baik manusia, binatang, tanaman, maupun pepohonan. ");
INSERT INTO ind_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Hanya Gosyen, tempat tinggal umat Israel, yang tidak terkena hujan es. ");
INSERT INTO ind_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Lalu raja memanggil Musa dan Harun untuk menghadap dia dan berkata, “Kali ini saya mengaku sudah berdosa. Dewamu memang benar, dan saya beserta seluruh rakyat saya bersalah. ");
INSERT INTO ind_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mintalah kepada dewamu untuk menghentikan hujan es dan guntur yang dahsyat ini! Kami tidak tahan lagi. Saya akan membiarkan kalian pergi. Kalian tidak usah tinggal lebih lama lagi.” ");
INSERT INTO ind_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Jawab Musa kepada raja, “Baik. Ketika saya meninggalkan kota ini, saya akan mengangkat tangan kepada TUHAN. Guntur akan berhenti dan tidak akan ada hujan es lagi, agar kalian tahu bahwa bumi adalah milik TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tetapi saya tahu bahwa engkau dan pejabatmu masih tidak takut kepada TUHAN Allah.” ");
INSERT INTO ind_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Pada waktu itu, jelai sudah hampir siap panen dan rami sedang berbunga. Jadi, hujan es menggagalkan panen tanaman-tanaman tersebut. ");
INSERT INTO ind_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Akan tetapi, gandum dan sekoi tidak rusak karena belum musimnya. ");
INSERT INTO ind_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kemudian Musa meninggalkan raja. Dia pergi ke luar kota dan mengangkat tangannya kepada TUHAN. Maka berhentilah guntur, hujan, dan hujan es itu. ");
INSERT INTO ind_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ketika raja melihat bahwa hujan, hujan es, dan guntur sudah berhenti, dia dan para pejabatnya pun berdosa lagi dengan mengeraskan hati mereka. ");
INSERT INTO ind_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Raja tetap tidak membiarkan umat Israel pergi, sesuai dengan yang sudah TUHAN katakan kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kemudian TUHAN berkata kepada Musa, “Pergilah menghadap raja, karena Aku sudah mengeraskan hatinya dan hati para pejabatnya, supaya Aku dapat menunjukkan berbagai keajaiban kepada mereka, ");
INSERT INTO ind_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","dan supaya kamu dapat menceritakan kepada anak cucumu bagaimana Aku, Allahmu, sudah mempermainkan orang Mesir. Kelak, kamu akan menceritakan semua keajaiban yang sudah Aku tunjukkan kepada mereka. Dengan demikian, kamu semua akan tahu bahwa Akulah TUHAN.” ");
INSERT INTO ind_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Maka Musa dan Harun pergi menghadap raja dan berkata kepadanya, “TUHAN, Allah umat Israel, berkata, ‘Sampai kapankah engkau akan menolak tunduk kepada-Ku? Biarkanlah umat-Ku pergi untuk menyembah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Apabila engkau tetap menolak, maka besok Aku akan mendatangkan belalang ke negerimu. ");
INSERT INTO ind_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Belalang-belalang itu akan menutupi seluruh daratan Mesir sehingga tanah tidak lagi terlihat. Belalang-belalang itu akan memakan sisa tanaman yang tidak rusak karena hujan es dan setiap pohon di ladang. ");
INSERT INTO ind_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Rumah-rumahmu dan semua rumah pejabatmu serta rakyat Mesir akan dipenuhi belalang. Orangtua maupun nenek moyang kalian belum pernah melihat bencana seperti ini!’” Sesudah itu, Musa langsung berbalik dan meninggalkan raja. ");
INSERT INTO ind_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Para pejabat raja berkata kepadanya, “Baginda, sampai kapankah orang ini akan terus menyusahkan kita? Biarkanlah rakyat itu pergi agar mereka dapat menyembah dewa mereka. Sadarilah, Mesir sudah hancur!” ");
INSERT INTO ind_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kemudian Musa dan Harun dibawa kembali untuk menghadap raja, dan raja berkata kepada mereka, “Pergilah menyembah dewa kalian. Tetapi siapa saja yang akan pergi?” ");
INSERT INTO ind_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Jawab Musa, “Kami akan pergi membawa seluruh anggota keluarga kami, semua orang baik tua maupun muda, juga semua ternak kami, karena kami harus mengadakan perayaan bagi TUHAN.” ");
INSERT INTO ind_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tetapi kata raja kepada mereka, “Ha! Kalau begitu hanya mujizat dewamu itu yang bisa membuatku mengizinkan kalian pergi membawa para perempuan dan anak-anak kalian! Aku tahu kalian sedang menyusun rencana jahat! ");
INSERT INTO ind_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tidak bisa! Hanya para laki-laki yang boleh pergi dan menyembah dewamu itu, sesuai permintaan kalian!” Setelah itu Musa dan Harun diusir dari hadapan raja. ");
INSERT INTO ind_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kemudian TUHAN berkata kepada Musa, “Ulurkanlah tanganmu ke atas tanah Mesir, maka belalang-belalang akan datang menutupi seluruh daratan dan memakan setiap tanaman di Mesir yang tidak dirusak oleh hujan es.” ");
INSERT INTO ind_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa pun mengulurkan tongkatnya ke atas tanah Mesir, dan TUHAN membuat angin timur bertiup di seluruh negeri sepanjang siang dan malam. Keesokan paginya, belalang-belalang sudah datang terbawa oleh angin timur itu. ");
INSERT INTO ind_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Belalang-belalang menutupi seluruh permukaan tanah negeri Mesir. Dalam sejarah Mesir, belum pernah terjadi bencana belalang seperti itu, dan untuk selamanya tidak akan pernah terjadi lagi. ");
INSERT INTO ind_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Permukaan tanah menjadi gelap karena tertutup oleh banyaknya belalang. Hewan-hewan itu memakan habis semua tanaman dan buah-buahan pada pohon-pohon yang masih bertahan dari hujan es. Tidak ada tumbuhan hijau yang tersisa di seluruh Mesir, baik tanaman maupun pohon. ");
INSERT INTO ind_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Raja segera memanggil Musa dan Harun dan berkata kepada mereka “Saya sudah berdosa terhadap ‘Tuhan’ dan terhadap kalian. ");
INSERT INTO ind_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Saya mohon sekali ini saja, ampunilah dosa saya dan mintalah kepada dewa kalian itu agar dia menjauhkan hukuman maut ini dari saya.” ");
INSERT INTO ind_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa meninggalkan raja dan memohon kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Maka TUHAN membalikkan arah angin menjadi angin barat yang kencang dan meniup belalang-belalang itu ke Laut Merah. Tidak ada seekor pun yang tertinggal di seluruh Mesir. ");
INSERT INTO ind_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Namun, TUHAN mengeraskan hati raja, dan lagi-lagi dia melarang umat Israel pergi. ");
INSERT INTO ind_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Lalu TUHAN berkata kepada Musa, “Angkatlah tanganmu ke arah langit, maka kegelapan yang sangat dahsyat akan meliputi seluruh negeri Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa mengangkat tangannya ke langit dan gelap gulita menyelimuti seluruh Mesir selama tiga hari. ");
INSERT INTO ind_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Rakyat Mesir tidak dapat melihat satu sama lain dan tidak dapat pergi kemana-mana selama tiga hari. Tetapi di daerah umat Israel tinggal tidak terjadi kegelapan seperti itu. ");
INSERT INTO ind_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Raja memanggil Musa dan berkata, “Pergilah menyembah dewamu. Perempuan-perempuan dan anak-anak kalian boleh ikut, tetapi semua ternak kalian harus ditinggalkan di sini.” ");
INSERT INTO ind_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Jawab Musa, “Engkau harus membiarkan kami membawa kurban bakaran agar kami mempersembahkannya kepada TUHAN Allah kami. ");
INSERT INTO ind_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Semua ternak harus kami bawa. Kami tidak akan meninggalkan seekor pun karena kami harus mempersembahkan sebagian dari ternak kami kepada TUHAN Allah, dan kami tidak tahu mana yang akan kami persembahkan kepada TUHAN sebelum kami tiba di sana.” ");
INSERT INTO ind_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Namun, TUHAN mengeraskan hati raja sehingga dia tidak membiarkan mereka pergi. ");
INSERT INTO ind_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Raja berkata kepada Musa, “Pergi kamu! Jangan pernah melihat mukaku lagi! Kalau kamu berani-berani datang, kamu pasti mati!” ");
INSERT INTO ind_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Jawab Musa, “Terjadilah sesuai perkataanmu! Saya tidak akan pernah melihat mukamu lagi!” ");
INSERT INTO ind_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","TUHAN berkata kepada Musa, “Masih ada satu bencana lagi yang akan Aku datangkan pada raja Mesir dan rakyatnya. Sesudah itu, raja akan membiarkan kalian pergi. Waktu dia melepas kalian pergi, dia benar-benar akan mengusir kalian dari tempat ini. ");
INSERT INTO ind_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Sekarang suruhlah umat Israel meminta perhiasan emas dan perak dari para tetangga mereka yang orang Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","TUHAN membuat orang-orang Mesir bermurah hati kepada umat Israel, bahkan Musa sangat dihormati oleh para pejabat dan rakyat Mesir. ");
INSERT INTO ind_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kemudian Musa menghadap raja dan berkata, “TUHAN mengatakan bahwa sekitar tengah malam nanti, Dia akan mengelilingi seluruh negeri. ");
INSERT INTO ind_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Setiap anak laki-laki sulung di negeri Mesir akan mati, mulai dari anak sulungmu yang akan duduk di takhtamu, sampai anak sulung budak perempuan yang menggiling gandum. Selain itu, anak sulung jantan dari semua ternak juga akan mati. ");
INSERT INTO ind_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Di seluruh Mesir akan terdengar ratapan yang begitu keras, yang belum pernah terjadi sebelumnya dan tidak akan pernah terjadi lagi. ");
INSERT INTO ind_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tetapi bangsa Israel akan tetap aman, bahkan seekor anjing pun tidak akan menggonggong kepada mereka ataupun hewan mereka, supaya engkau tahu bahwa TUHANlah yang sudah memperlakukan umat Israel berbeda dengan rakyat Mesir. ");
INSERT INTO ind_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Semua pejabatmu akan datang bersujud di hadapan saya untuk memohon, ‘Tolong pergilah bersama seluruh umat Israel.’ Sesudah itu kami akan pergi.” Lalu dengan sangat marah Musa meninggalkan raja. ");
INSERT INTO ind_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Sebelumnya, TUHAN sudah berkata kepada Musa, “Raja Mesir tidak akan mempedulikan perkataan kalian berdua. Hal itu terjadi supaya Aku dapat mengadakan banyak keajaiban di Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa dan Harun melakukan semua keajaiban itu di hadapan raja Mesir, tetapi TUHAN mengeraskan hati raja sehingga dia tetap bersikeras untuk tidak membiarkan umat Israel pergi dari negerinya. ");
INSERT INTO ind_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","TUHAN berkata kepada Musa dan Harun di Mesir, ");
INSERT INTO ind_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mulai sekarang, bulan ini akan menjadi bulan pertama dalam kalender tahunan kalian. ");
INSERT INTO ind_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Umumkanlah kepada seluruh umat Israel: Pada hari kesepuluh bulan ini, setiap kepala keluarga harus mengambil seekor anak domba atau anak kambing. ");
INSERT INTO ind_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kalau jumlah anggota keluarganya terlalu sedikit untuk memakan habis seekor anak domba atau anak kambing, mereka boleh membaginya dengan keluarga tetangga terdekat sesuai jumlah anggota keluarga dan jumlah yang bisa dimakan oleh masing-masing orang. ");
INSERT INTO ind_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kamu harus memilih anak domba atau anak kambing jantan yang berumur satu tahun dan tidak ada cacat. ");
INSERT INTO ind_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Setiap keluarga harus memelihara anak domba atau anak kambing itu hingga hari keempat belas bulan ini. Pada hari itu, waktu matahari terbenam, seluruh umat Israel harus menyembelih anak domba atau anak kambing tersebut. ");
INSERT INTO ind_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kemudian mereka harus mengoleskan darahnya pada kedua tiang pintu dan ambang atas pintu rumah tempat domba atau kambing itu akan dimakan. ");
INSERT INTO ind_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Malam itu juga, mereka harus memanggang dagingnya di atas api lalu memakannya dengan roti yang tidak beragi dan sayur pahit. ");
INSERT INTO ind_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Jangan memakannya mentah-mentah atau direbus dalam air. Anak domba atau kambing itu harus dipanggang utuh di atas api, termasuk kepala, kaki, dan semua bagian tubuhnya. ");
INSERT INTO ind_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Dagingnya harus dihabiskan pada malam itu juga. Jangan menyisakan daging hingga keesokan paginya. Apa pun yang tersisa harus dibakar habis sebelum pagi. ");
INSERT INTO ind_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Ini adalah permulaan dari Perayaan Paskah, yang senantiasa akan dirayakan untuk menghormati Aku, TUHAN kalian: Pada malam itu, kalian harus sudah mengenakan pakaian seperti orang yang siap bepergian jauh, mengenakan ikat pinggang, alas kaki, dan memegang tongkat. Lalu makanlah makanan itu dengan buru-buru. ");
INSERT INTO ind_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Malam itu, Aku akan berkeliling di seluruh Mesir dan membunuh setiap anak laki-laki yang sulung dan anak hewan jantan yang sulung. Aku akan menjatuhkan hukuman terhadap semua dewa Mesir, karena Akulah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Darah pada pintu rumah kalian akan menandakan tempat kalian berada. Waktu Aku melihat darah itu, Aku akan melewatinya, dan bencana tidak akan menimpa kalian ketika Aku menyerang Mesir. ");
INSERT INTO ind_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Setiap tahun kalian akan memperingati hari itu dan mengadakan perayaan untuk TUHAN turun temurun. Lakukanlah itu sebagai suatu ketetapan untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kalian akan makan roti yang tidak beragi selama tujuh hari. Pada hari pertama, kalian akan membuang semua ragi dari rumah kalian. Siapa pun yang memakan roti yang mengandung ragi selama tujuh hari itu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pada tanggal empat belas dan dua puluh, yaitu hari pertama dan hari ketujuh dalam perayaan ini, kalian harus mengadakan ibadah besar untuk menyembah dan menghormati Aku. Dalam dua hari itu kalian tidak boleh melakukan pekerjaan apa pun kecuali untuk menyiapkan makanan. ");
INSERT INTO ind_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sesudah Hari Paskah, keesokan harinya, kalian akan memperingati Perayaan Roti Tidak Beragi, agar kalian ingat bahwa hari ini Aku membawa kalian keluar dari Mesir. Kalian harus memperingati hari ini secara turun temurun, sebagai ketetapan selamanya. ");
INSERT INTO ind_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mulai petang hari tanggal empat belas sampai petang tanggal dua puluh satu dalam bulan pertama, kalian akan makan roti yang tidak beragi. ");
INSERT INTO ind_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Selama tujuh hari itu, tidak boleh ada ragi sama sekali di dalam rumah kalian. Apabila seseorang makan sesuatu yang beragi, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, baik itu pendatang maupun orang Israel asli. ");
INSERT INTO ind_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Kalian tidak boleh makan apa pun yang beragi. Makanlah roti yang tidak mengandung ragi di mana saja kalian tinggal.” ");
INSERT INTO ind_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kemudian Musa mengumpulkan semua tua-tua Israel dan berkata kepada mereka, “Pergilah dan pilihlah anak domba atau anak kambing untuk setiap keluarga dan sembelihlah sebagai kurban Paskah. ");
INSERT INTO ind_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ambillah segenggam tanaman hisop, celupkanlah ke dalam darah yang ditampung di baskom, lalu oleskan pada ambang atas dan kedua tiang pintu rumah kalian masing-masing. Tidak ada seorang pun yang boleh keluar rumah sampai besok paginya. ");
INSERT INTO ind_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","TUHAN akan berkeliling di seluruh negeri untuk membunuh setiap anak sulung orang Mesir. Ketika Dia melihat rumah yang ada darahnya pada ambang atas pintu dan kedua tiang pintu, TUHAN akan melewatinya. Dia tidak akan membiarkan malaikat maut masuk ke rumah-rumah kalian dan membunuh setiap anak sulung kalian. ");
INSERT INTO ind_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Kamu semua harus menaati ketetapan ini, dan anak cucumu harus memperingatinya untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Setelah masuk ke negeri yang sudah dijanjikan TUHAN kepadamu, kamu harus terus melaksanakan perayaan ini. ");
INSERT INTO ind_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Dan ketika anak-anakmu bertanya, ‘Apakah arti upacara ini?’ ");
INSERT INTO ind_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kamu akan menjawab, ‘Inilah persembahan Paskah untuk menghormati TUHAN, karena Dia sudah melewati rumah-rumah umat Israel di Mesir. Saat itu, Dia membunuh setiap anak laki-laki sulung orang Mesir, tetapi Dia membiarkan keluarga kita hidup.’” Setelah Musa menyampaikan semua itu, umat Israel bersujud menyembah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kemudian umat Israel melakukan apa yang sudah TUHAN perintahkan kepada Musa dan Harun. ");
INSERT INTO ind_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pada tengah malam, TUHAN membunuh setiap anak laki-laki yang sulung di seluruh Mesir, mulai dari anak sulung pewaris takhta raja Mesir sampai anak sulung tahanan di penjara, juga setiap anak sulung ternak. ");
INSERT INTO ind_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Malam itu, raja Mesir beserta semua pejabatnya dan seluruh rakyat Mesir terbangun. Terdengarlah jerit tangis yang keras di seluruh Mesir, karena ada yang mati di setiap rumah. ");
INSERT INTO ind_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Malam itu juga, raja memanggil Musa dan Harun untuk menghadapnya lalu berkata kepada mereka, “Pergi! Menjauhlah dari rakyat saya! Kalian dan semua umat Israel, pergilah menyembah TUHAN, dewamu itu, seperti yang kalian minta! ");
INSERT INTO ind_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bawalah ternakmu seperti yang kalian katakan. Yang penting pergilah! Dan nanti kalian doakanlah saya juga!” ");
INSERT INTO ind_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Rakyat Mesir mendesak umat Israel untuk segera meninggalkan negeri itu. Kata mereka, “Kami semua akan mati kalau kalian tidak pergi!” ");
INSERT INTO ind_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Jadi, umat Israel membawa adonan roti mereka yang masih di dalam wadah adonan dan belum diragi, membungkusnya dengan jubah mereka, lalu memikulnya. ");
INSERT INTO ind_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Sesuai perintah Musa sebelumnya, umat Israel meminta perhiasan emas, perak, dan pakaian dari orang Mesir tetangga mereka. ");
INSERT INTO ind_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","TUHAN membuat rakyat Mesir bermurah hati terhadap umat Israel, dan mereka memberikan segala sesuatu yang diminta oleh umat Israel. Dengan cara demikian, umat Israel membawa keluar harta kekayaan orang Mesir. ");
INSERT INTO ind_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Kemudian umat Israel berjalan dari Rameses ke Sukot. Jumlah laki-laki dewasa sekitar 600.000 orang, belum termasuk perempuan dan anak-anak. ");
INSERT INTO ind_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Sejumlah besar orang yang bukan keturunan Israel juga ikut serta. Dan ada kawanan ternak yang sangat banyak. ");
INSERT INTO ind_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Mereka diusir keluar dari Mesir dengan sangat mendesak sehingga tidak punya waktu untuk menyiapkan bekal. Mereka hanya dapat memanggang roti dari adonan tidak beragi yang sempat mereka bawa dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Hari itu, genap 430 tahun umat Israel tinggal di Mesir, dan saat itu juga pasukan TUHAN meninggalkan negeri itu. ");
INSERT INTO ind_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Pada malam itu, TUHAN menjaga umat Israel supaya Dia dapat membawa mereka keluar dari Mesir sesuai dengan waktu yang Dia tetapkan. Maka sebagai peringatan untuk menghormati TUHAN, setiap tahun pada malam yang sama seluruh umat Israel berjaga sepanjang malam. ");
INSERT INTO ind_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","TUHAN berkata kepada Musa dan Harun, “Inilah ketetapan mengenai Paskah. Orang yang bukan bangsa Israel dilarang memakan makanan Paskah, ");
INSERT INTO ind_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","kecuali budak laki-laki yang sudah dibeli boleh memakannya apabila sudah disunat. ");
INSERT INTO ind_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pendatang ataupun pekerja upahan dari bangsa lain tidak boleh memakannya. ");
INSERT INTO ind_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Setiap kurban Paskah harus dimakan di dalam satu rumah. Kamu tidak boleh membawa dagingnya keluar dari rumah itu, dan tidak boleh mematahkan satu pun tulangnya. ");
INSERT INTO ind_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Seluruh umat Israel harus merayakannya. ");
INSERT INTO ind_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Bila pendatang dari bangsa lain yang tinggal di antara kalian ingin merayakan Paskah untuk menghormati-Ku, maka dia dan seluruh anggota keluarganya beserta para budak laki-lakinya wajib disunat. Setelah itu, mereka boleh merayakan Paskah. Mereka akan diperlakukan sama seperti orang Israel asli. Orang yang belum disunat tidak boleh memakan makanan Paskah. ");
INSERT INTO ind_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Peraturan yang sama berlaku bagi orang Israel asli dan pendatang yang menetap bersama kalian.” ");
INSERT INTO ind_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Seluruh umat Israel taat dan melakukan tepat seperti yang sudah diperintahkan TUHAN kepada Musa dan Harun. ");
INSERT INTO ind_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Malam itu juga, TUHAN membawa pasukan Israel keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Khususkanlah bagi-Ku semua anak sulung di Israel. Semua yang lahir pertama, baik manusia maupun hewan, adalah milik-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kemudian Musa berkata kepada umat Israel, “Ingatlah, hari ini adalah hari kalian keluar dari Mesir, tempat perbudakan. TUHAN sudah membawa kalian keluar dari sana dengan kuasa-Nya yang besar. Peringatilah hari ini dengan cara tidak memakan roti yang beragi. ");
INSERT INTO ind_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Pada hari ini di bulan Abib, kalian keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Jadi, kamu semua harus memperingatinya pada bulan ini setiap tahun, setelah TUHAN membawamu masuk ke negeri yang berlimpah dengan hasil alam, sesuai janji-Nya kepada nenek moyang kalian, yaitu negeri yang sekarang didiami bangsa Kanaan, Het, Amori, Hewi, dan Yebus. ");
INSERT INTO ind_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kamu harus memakan roti yang tidak beragi selama tujuh hari. Lalu pada hari ketujuh, adakanlah perayaan untuk menghormati TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Selama tujuh hari, tidak boleh ada roti beragi atau apa pun yang beragi di seluruh wilayahmu. ");
INSERT INTO ind_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Pada hari itu, katakanlah kepada anak-anakmu yang laki-laki, ‘Aku melakukan semua ketentuan tentang Perayaan Roti Tidak Beragi ini untuk memperingati pertolongan TUHAN bagi kita ketika kita keluar dari Mesir.’ ");
INSERT INTO ind_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ibarat catatan diikat pada tangan atau dahi sebagai pengingat, demikianlah perayaan ini akan menjadi pengingat bagi kita, agar kita selalu saling mengingatkan tentang perintah-perintah TUHAN. Perayaan ini akan mengingatkan kita tentang cara TUHAN membawa kita keluar dari Mesir dengan kuasa-Nya yang luar biasa. ");
INSERT INTO ind_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Karena itu, lakukan ketetapan ini setiap tahun pada waktu yang sudah ditentukan. ");
INSERT INTO ind_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“TUHAN akan membawa kalian masuk ke negeri orang Kanaan dan memberikan negeri itu kepada kalian, sesuai dengan janji-Nya kepada nenek moyang kita. Sewaktu kamu sudah menempati negeri itu, ");
INSERT INTO ind_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","kamu harus menyerahkan setiap anak laki-laki yang sulung dan setiap anak ternak jantan yang sulung menjadi milik TUHAN. Setiap anak ternak jantan akan dipersembahkan kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tetapi setiap anak laki-laki yang sulung harus ditebus. Dan ada juga perkecualian untuk anak keledai jantan yang sulung. Anak keledai bisa ditebus dengan mempersembahkan kepada TUHAN seekor anak domba. Kalau kamu tidak menebusnya, kamu harus membunuh keledai itu dengan cara mematahkan lehernya. ");
INSERT INTO ind_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Suatu hari nanti, ketika anak-anakmu bertanya, ‘Mengapa kita memberikan persembahan-persembahan ini?’ Kamu harus menjawab, ‘Karena TUHAN sudah membawa kami keluar dari perbudakan di Mesir dengan kuasa-Nya yang besar. ");
INSERT INTO ind_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ketika raja Mesir dengan keras kepala menolak untuk membiarkan kami pergi, TUHAN membunuh setiap anak sulung yang laki-laki di Mesir, baik manusia maupun binatang. Itulah sebabnya kita mempersembahkan kepada TUHAN setiap ternak jantan yang sulung dan menebus setiap anak laki-laki kita yang sulung.’ ");
INSERT INTO ind_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","“Perayaan ini adalah pengingat bagi kita setiap saat, seperti suatu catatan diikat pada tangan atau dahi sebagai pengingat, bahwa TUHAN sudah membawa kita keluar dari Mesir dengan kuasa-Nya yang besar.” ");
INSERT INTO ind_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ketika raja Mesir membiarkan umat Israel pergi, Allah tidak menuntun mereka melalui jalan utama yang melintasi negeri orang Filistin, sekalipun jaraknya lebih dekat. Allah berkata, “Seandainya mereka pergi melalui jalan itu dan diserang musuh, bisa-bisa mereka berubah pikiran dan kembali ke Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Jadi, Allah membawa mereka melalui jalan yang lebih jauh dengan melintasi padang belantara menuju Laut Merah. Umat Israel keluar dari Mesir dalam keadaan siap berperang. ");
INSERT INTO ind_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa membawa tulang-tulang Yusuf bersamanya, karena Yusuf sudah meminta umat Israel berjanji, “Allah pasti akan datang menolong kalian. Pada waktu itu, kalian harus membawa tulangku keluar dari Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Setelah meninggalkan Sukot, mereka berkemah di Etam, di tepi padang belantara. ");
INSERT INTO ind_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","TUHAN selalu bergerak di depan mereka untuk menuntun perjalanan mereka. Pada siang hari, TUHAN menuntun mereka dalam bentuk tiang awan, dan pada malam hari dalam bentuk tiang api yang menerangi mereka. Dengan begitu, mereka dapat melakukan perjalanan baik siang maupun malam dengan mengikuti tiang awan dan tiang api itu. ");
INSERT INTO ind_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Demikianlah tiang awan pada waktu siang dan tiang api pada waktu malam selalu bersama umat Israel. ");
INSERT INTO ind_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kemudian TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Perintahkanlah umat Israel untuk kembali dan berkemah di tepi laut di Pi Hahirot, yang terletak di antara kota Migdol dan Laut Merah, berhadapan dengan Baal Zefon. ");
INSERT INTO ind_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Nanti raja Mesir akan berkata, ‘Umat Israel sudah tersesat dan terjebak di padang belantara.’ ");
INSERT INTO ind_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Aku akan mengeraskan hati raja sehingga dia mengejar kalian. Saat itulah Aku akan dimuliakan, ketika Aku mengalahkan raja Mesir beserta seluruh pasukannya, dan orang Mesir akan tahu bahwa Akulah TUHAN.” Maka umat Israel berkemah di sana sesuai perintah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sewaktu raja Mesir diberitahu bahwa umat Israel sudah melarikan diri, raja dan para pejabatnya berubah pikiran lalu berkata, “Mengapa kita membiarkan umat Israel pergi?! Sekarang kita kehilangan budak!” ");
INSERT INTO ind_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Dia pun menyuruh supaya kereta perang disiapkan, juga para tentara yang akan ikut bersamanya. ");
INSERT INTO ind_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Dia membawa 600 kereta perang pilihan bersama semua kereta perang lain yang ada di Mesir. Setiap kereta perang dikendarai oleh seorang perwira. ");
INSERT INTO ind_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","TUHAN mengeraskan hati raja Mesir sehingga dia mengejar umat Israel, yang sudah pergi keluar dengan gagah berani. ");
INSERT INTO ind_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Seluruh pasukan Mesir, termasuk semua pasukan berkuda, kereta, dan pengendaranya, mengejar umat Israel, dan mereka berhasil menyusul sampai perkemahan Israel di tepi laut dekat Pi Hahirot, di depan Baal Zefon. ");
INSERT INTO ind_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ketika umat Israel melihat raja Mesir dan pasukannya mendekat, mereka sangat ketakutan dan berseru-seru minta tolong kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Kata mereka kepada Musa, “Apakah di Mesir tidak ada kuburan, sehingga kamu membawa kami untuk mati di padang belantara ini! Kamu sudah mencelakakan kami dengan membawa kami keluar dari Mesir! ");
INSERT INTO ind_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Bukankah dulu di Mesir, kami pernah berkata kepadamu, ‘Jangan ikut campur! Biarkanlah kami tetap menjadi budak orang Mesir. Lebih baik hidup sebagai budak orang Mesir daripada mati di padang belantara!’” ");
INSERT INTO ind_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tetapi Musa menjawab mereka, “Jangan takut! Berdirilah teguh dan lihatlah yang akan TUHAN lakukan hari ini untuk menyelamatkan kita! Kita tidak akan melihat lagi pasukan Mesir yang kita hadapi hari ini. ");
INSERT INTO ind_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","TUHAN akan berperang bagi kita, dan kita tidak perlu melakukan apa-apa.” ");
INSERT INTO ind_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","TUHAN berkata kepada Musa, “Mengapa kamu berseru minta tolong kepada-Ku? Perintahkanlah umat Israel untuk berjalan maju! ");
INSERT INTO ind_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Angkatlah tongkatmu dan arahkanlah ke atas laut. Laut akan terbelah agar umat Israel bisa berjalan menyeberanginya di atas tanah kering. ");
INSERT INTO ind_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Aku akan mengeraskan hati orang Mesir sehingga mereka mengejar umat Israel ke tengah laut, dan Aku akan dimuliakan ketika Aku mengalahkan raja Mesir beserta seluruh pasukannya, termasuk pasukan berkuda, kereta, dan pengendaranya. ");
INSERT INTO ind_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Orang Mesir akan melihat kemuliaan-Ku dan tahu bahwa Akulah TUHAN ketika Aku mengalahkan mereka.” ");
INSERT INTO ind_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kemudian malaikat yang sebelumnya berjalan di depan umat Israel berpindah ke belakang mereka. Demikian juga tiang awan pindah dari depan ke belakang, ");
INSERT INTO ind_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","sehingga berada di antara perkemahan pasukan Mesir dan perkemahan umat Israel. Ketika hari menjelang malam, tiang awan berubah menjadi tiang api yang menerangi. Dengan demikian, pasukan Mesir tidak dapat mendekati umat Israel sepanjang malam itu. ");
INSERT INTO ind_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kemudian Musa mengarahkan tongkatnya ke atas laut, dan TUHAN membuat angin timur bertiup sangat kencang sepanjang malam sehingga air laut terbelah dua dan dasar laut menjadi kering. ");
INSERT INTO ind_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Umat Israel berjalan di atas tanah yang kering menyeberangi laut, sementara sisi kiri dan kanan mereka dipagari oleh tembok air. ");
INSERT INTO ind_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Seluruh pasukan Mesir, termasuk semua pasukan berkuda, kereta, dan pengendaranya, mengejar umat Israel hingga ke tengah laut. ");
INSERT INTO ind_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Menjelang fajar, TUHAN, yang berada di dalam tiang api dan awan, melihat ke bawah kepada pasukan Mesir lalu mengacaukan mereka. ");
INSERT INTO ind_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Dia membuat roda-roda kereta tentara Mesir macet sehingga mereka susah maju. Kata mereka, “Mari kita lari dari sini! Dewa Israel sedang berperang untuk umat Israel melawan kita!” ");
INSERT INTO ind_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","TUHAN berkata kepada Musa, “Arahkanlah tongkatmu ke atas laut, supaya air laut berbalik dan menutupi semua pasukan Mesir.” ");
INSERT INTO ind_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Maka pada waktu fajar sesudah umat Israel menyeberang, Musa mengarahkan tongkatnya ke atas laut, dan air laut menyatu kembali seperti semula. Pasukan Mesir berusaha melarikan diri, tetapi TUHAN menenggelamkan mereka di tengah laut. ");
INSERT INTO ind_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Air laut tiba-tiba berbalik dan menutupi semua pasukan berkuda dan pengendara kereta, bahkan semua pasukan raja Mesir yang mengejar umat Israel ke tengah laut. Tidak ada seorang pun yang selamat. ");
INSERT INTO ind_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Demikianlah umat Israel sudah menyeberangi laut itu dengan berjalan di atas tanah yang kering, dipagari oleh tembok air di sisi kiri dan kanan mereka. ");
INSERT INTO ind_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Pada hari itu, TUHAN menyelamatkan umat Israel dari pasukan Mesir, dan orang Israel melihat mayat-mayat tentara Mesir terdampar di pantai. ");
INSERT INTO ind_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ketika umat Israel melihat betapa besarnya kuasa TUHAN terhadap pasukan Mesir, mereka pun hormat dan takut kepada TUHAN, dan percaya kepada Dia serta kepada Musa, hamba-Nya. ");
INSERT INTO ind_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kemudian Musa dan umat Israel menyanyikan lagu ini untuk memuji TUHAN, “Aku akan bernyanyi bagi TUHAN sebab Dia sudah menang dengan jaya. Dia sudah melemparkan kuda dan penunggangnya ke dalam laut. ");
INSERT INTO ind_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TUHAN adalah sumber kekuatanku, karena itu aku bernyanyi. Dialah yang menyelamatkan aku. Dialah Allah yang akan aku puji. Dialah Allah yang disembah ayahku dan nenek moyangku. Aku akan meninggikan Dia! ");
INSERT INTO ind_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TUHAN adalah pahlawan perang. Nama-Nya adalah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Dia sudah melemparkan kereta-kereta raja Mesir dan segenap pasukannya ke dalam laut. Perwira-perwira terbaik ditenggelamkan-Nya ke Laut Merah. ");
INSERT INTO ind_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Laut yang dalam menelan mereka. Seperti batu mereka tenggelam ke dasar laut. ");
INSERT INTO ind_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Tangan kanan-Mu, ya TUHAN, hebat penuh kuasa. Tangan kanan-Mu, ya TUHAN, menghancurkan semua musuh. ");
INSERT INTO ind_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ketika Engkau membinasakan musuh-musuh-Mu Engkau mendapat kehormatan besar. Engkau melepaskan api murka-Mu dan membakar mereka bagai rumput kering belaka. ");
INSERT INTO ind_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Oleh hembusan nafas-Mu, air laut menggulung tinggi, berdiri tegak seperti tembok, dan dasar laut menjadi kering. ");
INSERT INTO ind_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Musuh kami berkata, ‘Aku akan mengejar dan menangkap mereka. Aku akan membunuh mereka dengan pedang. Lalu aku merampas semua harta mereka, membagi-bagikannya, dan menikmatinya sampai puas.’ ");
INSERT INTO ind_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tetapi dengan hembusan nafas-Mu, laut menggulung mereka. Mereka tenggelam bagaikan sepotong besi di dalam gelora air yang dahsyat. ");
INSERT INTO ind_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Tidak ada penguasa seperti Engkau, ya TUHAN! Engkau hebat dalam kekudusan-Mu, dikagumi dan dipuji karena perbuatan-Mu yang menakjubkan. Engkau pembuat keajaiban. ");
INSERT INTO ind_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Engkau merentangkan tangan kanan-Mu, dan bumi pun menelan mereka. ");
INSERT INTO ind_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Karena Engkau setia dan berbaik hati, Engkau memimpin orang-orang yang sudah Engkau tebus. Dengan kekuatan-Mu, Engkau menuntun mereka menuju tempat kediaman-Mu yang kudus. ");
INSERT INTO ind_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bangsa-bangsa lain akan mendengar perbuatan-Mu, dan mereka akan gemetar. Penduduk Filistin akan dilanda ketakutan. ");
INSERT INTO ind_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Para pemimpin Edom akan terguncang. Para pemimpin Moab akan gemetar. Orang Kanaan akan lemas karena kegentaran. ");
INSERT INTO ind_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Mereka akan merasa ngeri dan ketakutan menyaksikan kuasa-Mu, dan mereka akan terdiam seperti batu sampai umat-Mu yang sudah Engkau tebus, ya TUHAN, berjalan melewati mereka. ");
INSERT INTO ind_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Engkau akan membawa umat-Mu ke atas gunung-Mu, di mana Engkau membuat kediaman-Mu, ya TUHAN, ke tempat kudus yang Engkau dirikan dengan tangan-Mu sendiri, ya Penguasa kami. ");
INSERT INTO ind_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Engkaulah, TUHAN, yang berkuasa dan memerintah sampai selama-lamanya!” ");
INSERT INTO ind_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ketika umat Israel berjalan menyeberang laut di atas tanah yang kering, semua pasukan raja Mesir, termasuk pasukan berkuda, kereta, dan pengendaranya, mengejar mereka ke tengah laut. Lalu TUHAN membuat tembok air menyatu kembali seperti semula dan menenggelamkan mereka. ");
INSERT INTO ind_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Lalu Miryam, kakak perempuan Harun yang juga seorang nabi perempuan, mengambil rebana dan memukulnya sambil menari-nari. Semua perempuan mengikutinya, ");
INSERT INTO ind_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","dan Miryam memimpin mereka menyanyi, “Bernyanyilah bagi TUHAN, karena Dia sudah menang dengan jaya. Dia sudah melemparkan seluruh pasukan berkuda itu ke dalam laut.” ");
INSERT INTO ind_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kemudian Musa memimpin umat Israel meninggalkan Laut Merah menuju padang belantara Syur. Mereka berjalan selama tiga hari di padang belantara itu tanpa menemukan air. ");
INSERT INTO ind_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Setibanya di Mara, mereka menemukan air, tetapi air di sana tidak bisa diminum karena pahit. Itulah sebabnya tempat itu dinamai ‘Mara’, yang artinya ‘pahit’. ");
INSERT INTO ind_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mereka bersungut-sungut kepada Musa dan berkata, “Apa yang akan kita minum?!” ");
INSERT INTO ind_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Maka Musa berseru kepada TUHAN, dan TUHAN menunjukkan kepadanya sebatang kayu. Musa melemparkan kayu itu ke air, lalu air itu berubah menjadi air tawar sehingga dapat diminum. Di tempat itu, TUHAN memberikan ketetapan sebagai pengukur untuk menguji ketaatan mereka masing-masing dengan berkata, ");
INSERT INTO ind_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Taatilah Aku, TUHAN Allahmu, dengan sungguh-sungguh. Turutilah semua perintah dan ketetapan-Ku, dan lakukanlah yang baik di mata-Ku, maka Aku tidak akan menghukum kamu dengan berbagai penyakit seperti yang sudah Aku lakukan terhadap bangsa Mesir. Akulah TUHAN yang menyembuhkan kamu.” ");
INSERT INTO ind_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Sesudah itu, tibalah mereka di Elim. Di sana terdapat dua belas mata air dan tujuh puluh pohon kurma. Mereka berkemah di dekat mata air itu. ");
INSERT INTO ind_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kemudian umat Israel meninggalkan Elim. Pada hari kelima belas bulan kedua, satu bulan sejak mereka keluar dari Mesir, tibalah mereka di padang belantara Sin yang terletak di antara Elim dan gunung Sinai. ");
INSERT INTO ind_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Di padang belantara itu, umat Israel bersungut-sungut terhadap Musa dan Harun. ");
INSERT INTO ind_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kata mereka, “Lebih baik kalau TUHAN membunuh kami ketika kami masih di Mesir, daripada kalian berdua membawa kami ke padang belantara ini dan membiarkan kami mati kelaparan! Setidaknya, di Mesir kami tidak pernah kekurangan roti dan daging!” ");
INSERT INTO ind_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Maka TUHAN berkata kepada Musa, “Aku akan memberi kalian makanan dari surga seperti hujan turun dari langit. Setiap hari, umat itu harus keluar mengumpulkan makanan secukupnya untuk sehari. Aku hendak menguji apakah mereka mau menuruti perintah-Ku atau tidak. ");
INSERT INTO ind_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pada hari yang keenam dalam tiap-tiap minggu, mereka akan memperoleh dua kali lebih banyak daripada biasanya.” ");
INSERT INTO ind_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Lalu Musa dan Harun berkata kepada seluruh umat Israel, “Nanti saat matahari terbenam, kamu semua akan tahu bahwa TUHANlah yang sudah membawa kita keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Besok pagi, kamu akan melihat kemuliaan TUHAN, karena Dia sudah mendengar keluhanmu terhadap-Nya. Sesungguhnya, terhadap Dialah kamu bersungut-sungut, bukan terhadap kami, karena kami hanya utusan-Nya! ");
INSERT INTO ind_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","TUHAN akan memberikan daging kepada setiap keluarga pada waktu sore, dan roti pada waktu pagi, sebab TUHAN sudah mendengar gerutuanmu terhadap-Nya. Siapakah kami ini?! Sebenarnya keluhanmu bukanlah terhadap kami, melainkan terhadap TUHAN.” ");
INSERT INTO ind_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kemudian Musa berkata kepada Harun, “Beritahukanlah kepada seluruh umat Israel: Datanglah kepada TUHAN, karena Dia sudah mendengar gerutuan kalian.” ");
INSERT INTO ind_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Sementara Harun berbicara kepada umat Israel, tiba-tiba dari arah padang belantara tampaklah kepada mereka kemuliaan TUHAN di dalam awan. ");
INSERT INTO ind_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Aku sudah mendengar keluhan umat Israel. Katakanlah kepada mereka, ‘Sewaktu matahari terbenam, kamu semua akan makan daging, dan pada waktu pagi kamu akan kenyang makan roti. Dengan demikian, kamu akan tahu bahwa Akulah TUHAN, Allahmu.’” ");
INSERT INTO ind_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Sore itu juga, burung puyuh berdatangan begitu banyaknya hingga menutupi perkemahan mereka. Pada pagi harinya, turunlah embun di sekitar perkemahan. ");
INSERT INTO ind_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ketika embun itu sudah menguap, tampaklah di permukaan tanah sesuatu yang tipis seperti sisik dan halus seperti tetesan embun beku pada musim dingin. ");
INSERT INTO ind_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Melihat itu, umat Israel bertanya-tanya satu sama lain, “Apa ini?” Karena mereka tidak mengetahui benda itu. Lalu kata Musa, “Inilah makanan yang TUHAN berikan kepada kita. ");
INSERT INTO ind_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","TUHAN memerintahkan agar kalian masing-masing mengumpulkan sebanyak yang dibutuhkan, yaitu dua liter untuk setiap anggota keluarga.” ");
INSERT INTO ind_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Maka umat Israel melakukannya. Ada yang mengumpulkan banyak, dan ada yang mengumpulkan sedikit. ");
INSERT INTO ind_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Walaupun begitu, ketika mereka menakarnya, ternyata yang mengumpulkan banyak tidak kelebihan, dan yang mengumpulkan sedikit tidak kekurangan. Masing-masing mengumpulkan sejumlah yang mereka perlukan. ");
INSERT INTO ind_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa berkata kepada mereka, “Jangan sisakan sedikit pun untuk besok.” ");
INSERT INTO ind_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Namun, beberapa di antara mereka tidak taat kepada Musa. Mereka menyisakan sebagian makanan itu sampai pagi. Ternyata sisa makanan itu menjadi berulat dan berbau busuk. Musa pun memarahi mereka. ");
INSERT INTO ind_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Setiap pagi, orang Israel mengumpulkan makanan itu sebanyak yang mereka perlukan. Ketika matahari semakin panas, makanan itu mencair dan lenyap. ");
INSERT INTO ind_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pada hari yang keenam, mereka mengumpulkan makanan itu seperti biasa, tetapi ketika pulang, mereka melihat bahwa makanan itu sudah menjadi dua kali lipat. Ternyata setiap orang mendapat enam liter. Para pemimpin menjadi bingung lalu datang kepada Musa untuk memberitahukannya. ");
INSERT INTO ind_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Jawab Musa, “Inilah perintah TUHAN: Besok adalah hari Sabat, hari yang dikhususkan bagi TUHAN sebagai hari untuk beristirahat. Masaklah sebanyak yang kamu inginkan, makanlah sebagian pada hari ini, dan simpanlah sebagian lainnya yang untuk dimakan besok.” ");
INSERT INTO ind_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Maka mereka menyimpan sisa makanan itu sesuai perintah Musa. Keesokan harinya, makanan yang mereka simpan itu tidak basi dan tidak berulat. ");
INSERT INTO ind_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kata Musa kepada mereka, “Makanlah makanan itu, karena hari ini adalah hari Sabat bagi TUHAN, yaitu hari peristirahatan untuk menghormati TUHAN. Hari ini kamu tidak akan menemukan makanan itu di padang. ");
INSERT INTO ind_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Selama enam hari kamu mengumpulkan makanan itu, tetapi hari yang ketujuh adalah Sabat. Makanan tidak akan turun pada hari itu.” ");
INSERT INTO ind_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pada hari Sabat, beberapa orang keluar untuk mengumpulkan makanan, tetapi mereka tidak menemukan apa-apa. ");
INSERT INTO ind_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Lalu TUHAN berkata kepada Musa, “Sampai kapan mereka terus menolak untuk taat pada perintah-Ku dan ajaran-Ku? ");
INSERT INTO ind_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hendaklah mereka ingat bahwa Aku, TUHAN, sudah memberikan hari yang ketujuh bagi kalian untuk beristirahat. Oleh karena itu, pada hari yang keenam Aku memberikan makanan dua kali lipat supaya cukup untuk dua hari. Pada hari Sabat, hari yang ketujuh, diamlah di dalam kemahmu masing-masing dan jangan keluar.” ");
INSERT INTO ind_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Demikianlah sejak hari itu umat Israel tidak bekerja pada hari Sabat. ");
INSERT INTO ind_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Umat Israel menamai makanan itu manna. Bentuknya seperti biji ketumbar, kecil, warnanya putih, dan rasanya seperti kue madu. ");
INSERT INTO ind_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa berkata, “Inilah perintah TUHAN, ‘Ambillah dua liter manna dan simpanlah itu, supaya setiap generasimu turun temurun dapat melihat makanan yang Aku berikan kepadamu di padang belantara, ketika Aku membawamu keluar dari Mesir.’” ");
INSERT INTO ind_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Lagi kata Musa kepada Harun, “Ambillah sebuah kendi dan isilah dengan dua liter manna, lalu taruhlah kendi itu di hadapan TUHAN untuk disimpan turun temurun.” ");
INSERT INTO ind_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Harun melakukan sesuai perintah TUHAN kepada Musa dan menyimpan kendi itu di depan peti perjanjian. ");
INSERT INTO ind_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Orang Israel makan manna selama empat puluh tahun sampai mereka tiba di Kanaan. ");
INSERT INTO ind_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Pada zaman itu, takaran manna yang orang Yahudi gunakan disebut gomer. Satu gomer sama dengan sepersepuluh efa. ");
INSERT INTO ind_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kemudian seluruh umat Israel melanjutkan perjalanan dari padang belantara Sin, lalu berpindah-pindah dari satu tempat ke tempat lain sesuai dengan perintah TUHAN. Mereka tiba di Rafidim dan berkemah di sana, tetapi di tempat itu tidak ada air untuk diminum. ");
INSERT INTO ind_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Maka mereka menuntut Musa dengan berkata, “Berikan kami air minum!” Jawab Musa, “Mengapa kalian menuntut saya dan mencobai TUHAN?!” ");
INSERT INTO ind_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Orang-orang itu kehausan sehingga mereka bersungut-sungut terhadap Musa dan berkata, “Apakah engkau membawa kami keluar dari Mesir supaya kami, anak-anak kami, dan ternak kami mati kehausan?!” ");
INSERT INTO ind_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Lalu Musa berseru kepada TUHAN, “Apa yang harus aku lakukan untuk menghadapi orang-orang ini? Sebentar lagi mereka akan melempari aku dengan batu!” ");
INSERT INTO ind_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kata TUHAN kepada Musa, “Berjalanlah mendahului umat itu dan ajaklah bersamamu beberapa tua-tua Israel. Bawalah juga tongkat yang kamu pakai untuk memukul sungai Nil. ");
INSERT INTO ind_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Aku akan berdiri di depanmu di sana, di atas sebuah batu di gunung Sinai. Pukullah batu itu, dan air akan keluar dari dalamnya sehingga umat bisa minum.” Maka Musa melakukan hal itu di depan mata para tua-tua Israel. ");
INSERT INTO ind_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa menamai tempat itu Masa dan Meriba, karena di sana umat Israel bersungut-sungut dan mencobai TUHAN dengan berkata, “Apakah TUHAN bersama dengan kita atau tidak?” ");
INSERT INTO ind_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Di Rafidim, orang Amalek datang menyerang umat Israel. ");
INSERT INTO ind_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kata Musa kepada Yosua, “Pilihlah beberapa orang dari kita dan keluarlah melawan orang Amalek. Besok saya akan berdiri di puncak bukit dengan membawa tongkat yang sering Allah suruh untuk saya pakai membuat keajaiban.” ");
INSERT INTO ind_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosua pun melakukan perintah Musa. Dia berperang melawan orang Amalek, sementara Musa, Harun, dan Hur naik ke puncak bukit. ");
INSERT INTO ind_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Selama Musa mengangkat tongkat Allah dengan kedua tangannya, umat Israel lebih kuat. Tetapi kalau dia menurunkan tangannya, orang Amalek lebih kuat. ");
INSERT INTO ind_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Setelah beberapa waktu, tangan Musa menjadi lelah. Maka Harun dan Hur mengambil sebuah batu untuk Musa duduk, dan mereka menopang kedua tangan Musa, sehingga tangannya tetap terangkat sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Dengan demikian, Yosua mengalahkan pasukan Amalek dalam perang itu. ");
INSERT INTO ind_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Lalu TUHAN berkata kepada Musa, “Tuliskanlah pesan ini dalam sebuah kitab supaya tetap diingat, dan bacakanlah kepada Yosua: Aku akan memusnahkan bangsa Amalek dari muka bumi sampai mereka tidak diingat lagi.” ");
INSERT INTO ind_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kemudian Musa mendirikan sebuah mezbah dan menamainya “TUHAN, bendera kemenanganku.” ");
INSERT INTO ind_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kata Musa, “Angkatlah tinggi bendera kemenangan TUHAN! TUHAN akan memerangi bangsa Amalek dari generasi ke generasi!” ");
INSERT INTO ind_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","4","Pada waktu Musa masih sering berurusan dengan raja Mesir untuk menuntut dia membebaskan umat Israel, Musa menyuruh orang mengantar Sipora dan kedua anaknya kembali kepada mertuanya, Yitro, seorang imam di Midian. Anak laki-laki Musa yang pertama dinamai Gersom, karena saat dia lahir Musa berkata, “Aku sudah menjadi pendatang di negeri asing.” Anaknya yang kedua diberi nama Eliezer, karena Musa berkata, “Allah ayahku adalah Penolongku dan Dia menyelamatkanku dari ancaman hukuman mati raja Mesir.” Setelah sekian waktu lamanya, Yitro mendengar semua yang sudah Allah lakukan bagi umat Israel dan bagi Musa, serta cara TUHAN membawa mereka keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Maka saat umat Israel berkemah di padang belantara dekat kaki gunung Allah, yaitu gunung Sinai, datanglah Yitro kepada Musa mengantarkan istri dan kedua anaknya. ");
INSERT INTO ind_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Sebelum tiba, Yitro sudah mengirim pesan, “Aku, Yitro, ayah mertuamu, sedang dalam perjalanan untuk menjumpaimu bersama anak-anak dan istrimu.” ");
INSERT INTO ind_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ketika Yitro tiba, Musa pergi keluar perkemahan untuk menemui mertuanya itu. Dia bersujud untuk menghormati Yitro, lalu memeluknya. Setelah menanyakan kabar masing-masing, mereka masuk ke kemah Musa. ");
INSERT INTO ind_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa menceritakan kepada mertuanya semua yang sudah TUHAN lakukan terhadap raja dan orang Mesir untuk menolong Israel, juga semua kesulitan yang mereka hadapi sepanjang perjalanan, dan bagaimana TUHAN sudah menyelamatkan mereka. ");
INSERT INTO ind_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yitro sangat senang mendengar semua kebaikan yang sudah TUHAN lakukan bagi Israel, yaitu segala cara-Nya menyelamatkan mereka dari tangan orang Mesir. ");
INSERT INTO ind_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Kata Yitro, “Puji TUHAN. Dia sudah menyelamatkan kalian dari kuasa raja Mesir dan penindasan bangsanya! ");
INSERT INTO ind_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sekarang saya tahu bahwa TUHAN lebih besar daripada segala dewa, karena Dia menghancurkan pasukan Mesir yang membesarkan diri terhadap umat Israel.” ");
INSERT INTO ind_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Lalu Yitro memberikan persembahan kurban bagi Allah. Pertama, dia mempersembahkan kurban yang dibakar habis, sesudah itu kurban yang sebagian dagingnya boleh dimakan. Harun dan semua tua-tua Israel berkumpul untuk makan bersama ayah mertua Musa di hadapan Allah. ");
INSERT INTO ind_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Keesokan harinya, Musa duduk untuk mengadili perselisihan-perselisihan di antara orang Israel, dan umat itu berdiri di sekeliling Musa dari pagi hingga petang. ");
INSERT INTO ind_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Saat Yitro melihat semua yang Musa lakukan, dia berkata, “Apa yang sedang kamu kerjakan untuk umatmu? Mengapa hanya kamu sendiri yang duduk mengadili, sementara mereka semua berdiri di sekelilingmu dari pagi sampai petang?” ");
INSERT INTO ind_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa menjawab, “Karena umat itu datang kepada saya untuk meminta petunjuk dari Allah. ");
INSERT INTO ind_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Saat ada perselisihan di antara mereka, mereka menjelaskan perkaranya kepada saya, lalu saya memberikan keputusan bagi mereka. Saya juga mengajar mereka perintah dan ketetapan Allah.” ");
INSERT INTO ind_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kata mertua Musa kepadanya, “Caramu ini tidak baik! ");
INSERT INTO ind_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kamu dan umatmu akan sama-sama terlalu lelah. Hal itu terlalu berat untukmu. Kamu tidak bisa melakukannya seorang diri. ");
INSERT INTO ind_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Dengarkanlah nasihatku, dan semoga Allah besertamu: Jadilah perantara antara Allah dengan umatmu dan sampaikanlah perkara mereka kepada Allah. ");
INSERT INTO ind_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ajarilah mereka tentang semua ketetapan dan perintah Allah. Beritahukanlah kepada mereka cara hidup yang baik dan hal-hal yang harus mereka lakukan. ");
INSERT INTO ind_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tetapi pilihlah dari antara umat ini orang-orang yang cakap, yaitu yang takut dan hormat kepada Allah, yang bisa dipercaya, dan tidak menerima suap. Angkatlah mereka menjadi pemimpin atas seribu orang, seratus orang, lima puluh orang, dan atas sepuluh orang. ");
INSERT INTO ind_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mereka akan mengadili perkara-perkara umat ini. Bila ada perkara yang sulit, mereka bisa membawanya kepadamu, tetapi perkara yang lebih mudah biarlah mereka adili. Dengan begitu, mereka menanggung beban ini bersama denganmu sehingga meringankan pekerjaanmu. ");
INSERT INTO ind_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Jika kamu melakukannya, dan Allah menyuruhmu demikian, maka kamu akan dapat menanggung beban pekerjaan ini, dan seluruh umat ini akan pulang ke rumah masing-masing dengan tenang.” ");
INSERT INTO ind_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa mengikuti nasihat mertuanya itu. ");
INSERT INTO ind_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa memilih orang-orang yang cakap dari seluruh Israel, lalu mengangkat mereka menjadi pemimpin atas bangsa itu, yakni pemimpin atas seribu orang, seratus orang, lima puluh orang, dan sepuluh orang. ");
INSERT INTO ind_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Merekalah yang kemudian mengadili perkara-perkara umat Israel. Hanya perkara-perkara sulit yang mereka bawa kepada Musa, sedangkan perkara-perkara yang mudah mereka selesaikan sendiri. ");
INSERT INTO ind_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sesudah itu, mertua Musa pamit pulang ke negerinya, dan Musa melepasnya pergi. ");
INSERT INTO ind_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Kemudian bangsa Israel berangkat dari Rafidim, dan tepat dua bulan setelah meninggalkan Mesir, tibalah mereka di padang belantara Sinai. Mereka pun berkemah di kaki gunung Sinai. ");
INSERT INTO ind_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa naik ke gunung itu untuk menghadap Allah. Lalu dari tempat yang lebih tinggi di gunung itu, TUHAN memanggilnya untuk mendekat, dan Dia berkata, “Sampaikanlah kepada keturunan Yakub, umat Israel, ");
INSERT INTO ind_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kalian sendiri sudah menjadi saksi atas perbuatan yang Aku lakukan terhadap bangsa Mesir, dan bagaimana Aku membawa kalian keluar dari negeri itu. Seperti seekor rajawali membawa anaknya di atas sayapnya, demikianlah Aku membawa kalian ke sini, kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Seluruh bumi adalah milik-Ku, tetapi jika kalian taat kepada perintah-Ku dan berpegang pada perjanjian-Ku, kalian akan menjadi milik-Ku yang paling berharga di antara semua bangsa. ");
INSERT INTO ind_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kalian akan menjadi bangsa yang Aku sucikan, yakni suatu kerajaan yang semua penduduknya bagaikan imam.’ Itulah yang harus kamu sampaikan kepada bangsa Israel.” ");
INSERT INTO ind_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Setelah Musa kembali dari gunung, dia memanggil para tua-tua umat Israel dan memberitahukan kepada mereka semua yang TUHAN perintahkan untuk dikatakannya. ");
INSERT INTO ind_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ketika pesan itu disampaikan kepada seluruh umat, mereka bersama-sama menjawab dengan lantang, “Kami akan melakukan segala yang TUHAN perintahkan!” Dan Musa menyampaikan jawaban mereka kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Lalu berkatalah TUHAN kepada Musa, “Sesungguhnya Aku akan datang kepadamu dalam awan tebal, sehingga umat Israel dapat mendengar ketika Aku berbicara denganmu, dan supaya mereka selalu percaya kepadamu.” Sesudah Musa menyampaikan perkataan bangsa Israel kepada TUHAN, ");
INSERT INTO ind_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","TUHAN berkata kepada Musa, “Pergilah kepada umat Israel dan suruhlah mereka untuk bersiap menyambut kedatangan-Ku. Hari ini dan besok, mereka harus membersihkan diri serta mencuci pakaian yang akan dikenakan. ");
INSERT INTO ind_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Bersiap-siaplah! Besok lusa, Aku akan turun ke gunung Sinai dengan disaksikan oleh seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pasanglah pembatas di sekeliling gunung itu dan beritahukanlah kepada mereka untuk tidak melewati batas itu. Katakan kepada mereka, ‘Berhati-hatilah, jangan naik ke gunung atau menyentuh batas itu. Siapa pun yang melanggarnya akan mati. ");
INSERT INTO ind_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tidak ada yang boleh melewati batas itu, baik manusia ataupun binatang. Manusia maupun binatang yang melewatinya tidak boleh disentuh, tetapi harus langsung dilempari batu atau dipanah sampai mati. Orang Israel tidak boleh mendekati gunung itu sampai mereka mendengar bunyi sangkakala yang panjang.’” ");
INSERT INTO ind_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kemudian Musa turun dari gunung Sinai lalu menyuruh umat untuk membersihkan diri dan mencuci pakaian mereka. ");
INSERT INTO ind_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kata Musa kepada mereka, “Hari ini dan besok, kamu masing-masing harus mempersiapkan diri untuk kedatangan TUHAN pada hari berikutnya. Jangan ada yang berhubungan badan sampai lewat besok lusa.” ");
INSERT INTO ind_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Pada pagi di hari kedatangan TUHAN, ada guntur dan kilat yang dahsyat serta awan tebal di atas gunung, juga bunyi sangkakala yang sangat keras. Seluruh umat Israel gemetar ketakutan. ");
INSERT INTO ind_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa membawa mereka keluar dari perkemahan untuk bertemu dengan Allah, dan mereka berdiri di kaki gunung itu. ");
INSERT INTO ind_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Seluruh gunung Sinai ditutupi oleh asap, karena TUHAN turun ke atasnya dalam bentuk api. Asap itu membubung tinggi ke langit seperti asap dari cerobong pembakaran, dan gunung itu berguncang dengan keras. ");
INSERT INTO ind_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Sementara bunyi sangkakala bertambah nyaring, Musa berseru kepada Allah, dan Allah menjawabnya dengan suara gemuruh seperti bunyi guntur. ");
INSERT INTO ind_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Lalu TUHAN turun ke puncak gunung Sinai dan memanggil Musa untuk naik ke sana. Musa pun naik. ");
INSERT INTO ind_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","TUHAN berkata kepadanya, “Turunlah dan peringatkan umat Israel supaya mereka tidak melewati pembatas untuk datang melihat TUHAN. Apabila mereka melanggarnya, banyak di antara mereka akan mati. ");
INSERT INTO ind_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Imam-imam yang akan datang menghadap-Ku juga harus menguduskan diri. Kalau tidak, Aku akan menghukum mereka.” ");
INSERT INTO ind_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa berkata kepada TUHAN, “Orang Israel tidak mungkin naik ke gunung Sinai karena Engkau sendiri sudah memperingatkan kami, ‘Pasanglah pembatas mengelilingi gunung itu untuk menandainya sebagai tempat kudus.’” ");
INSERT INTO ind_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kemudian TUHAN berkata, “Turunlah dan ajaklah Harun naik kembali bersamamu. Tetapi jangan biarkan imam-imam dan umat Israel melewati pembatas itu untuk datang kepada-Ku. Jika mereka melanggarnya, Aku akan menghukum mereka.” ");
INSERT INTO ind_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Maka Musa turun dan menyampaikan kepada mereka pesan TUHAN itu. ");
INSERT INTO ind_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Lalu Allah berkata, ");
INSERT INTO ind_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Akulah TUHAN Allahmu, yang sudah membawa kalian keluar dari perbudakan di Mesir. ");
INSERT INTO ind_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Jangan menyembah dewa apa pun. Sembahlah hanya Aku! ");
INSERT INTO ind_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Jangan membuat bagimu berhala menyerupai apa pun yang ada di langit, di bumi, ataupun di dalam air. ");
INSERT INTO ind_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Jangan bersujud kepada dewa apa pun, dan jangan melayani mereka, karena Aku, TUHAN Allahmu, akan cemburu. Siapa pun yang menentang Aku dengan melakukan itu akan Aku hukum sampai generasinya yang ketiga dan keempat. ");
INSERT INTO ind_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Tetapi kepada orang-orang yang mengasihi Aku dan menaati perintah-Ku, Aku akan menunjukkan kebaikan hati-Ku atas keluarganya sampai ribuan generasi. ");
INSERT INTO ind_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Jangan menyalahgunakan nama-Ku, TUHAN Allahmu. Aku akan menghukum siapa pun yang memakai nama-Ku dengan maksud yang salah. ");
INSERT INTO ind_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ingatlah untuk menjaga kekudusan hari Sabat dengan menaati peraturan tentang hari itu. ");
INSERT INTO ind_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Enam hari lamanya kalian bekerja dan melakukan kegiatanmu sehari-hari, ");
INSERT INTO ind_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","tetapi pada hari ketujuh, yaitu Sabat, kalian harus menghormati Aku, TUHAN Allahmu, dengan menghentikan segala pekerjaan. Tidak ada yang boleh melakukan pekerjaan, baik kamu, anak-anakmu, hamba-hambamu, maupun para pendatang yang tinggal di antaramu, bahkan hewan ternakmu. ");
INSERT INTO ind_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Aku, TUHAN, sudah menciptakan langit, bumi, laut dan semua yang ada di dalamnya selama enam hari, lalu Aku beristirahat pada hari ketujuh. Karena itulah Aku memberkati hari Sabat dan menguduskannya. Maka kalian harus mengkhususkan hari itu. ");
INSERT INTO ind_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hormatilah ayah dan ibumu, supaya kamu hidup sejahtera di negeri yang Aku berikan kepadamu. ");
INSERT INTO ind_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Jangan membunuh. ");
INSERT INTO ind_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Jangan berzina. ");
INSERT INTO ind_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Jangan mencuri. ");
INSERT INTO ind_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Jangan memfitnah sesamamu. ");
INSERT INTO ind_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Jangan mengingini milik orang lain, baik istrinya, rumahnya, hambanya laki-laki atau perempuan, sapi, keledai, maupun segala miliknya yang lain.” ");
INSERT INTO ind_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ketika umat Israel mendengar guruh dan bunyi sangkakala yang keras serta melihat kilat dan gunung yang diselimuti asap, mereka gemetar ketakutan dan tetap berdiri jauh-jauh. ");
INSERT INTO ind_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Lalu mereka berkata kepada Musa, “Sampaikanlah kepada kami apa yang TUHAN katakan kepadamu. Kami akan mendengarkan. Tetapi jangan biarkan TUHAN berbicara langsung kepada kami, karena kami akan mati!” ");
INSERT INTO ind_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Jawab Musa kepada mereka, “Jangan takut, sebab TUHAN datang untuk menguji kamu masing-masing, supaya kamu takut dan hormat kepada Dia, sehingga kamu terhindar dari dosa.” ");
INSERT INTO ind_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Lalu Musa mendekati awan yang tebal dan gelap di mana Allah berada, sementara umat Israel tetap berdiri di kejauhan. ");
INSERT INTO ind_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Selanjutnya TUHAN berkata kepada Musa, “Sampaikanlah kepada umat Israel: Kalian sendiri sudah melihat bagaimana Aku berbicara dengan kalian dari surga. ");
INSERT INTO ind_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Karena itu, jangan membuat patung berhala, baik dari perak maupun emas. ");
INSERT INTO ind_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Buatlah sebuah mezbah dari tanah untuk-Ku, dan persembahkanlah sapi, domba, dan kambingmu di atasnya sebagai kurban yang dibakar habis serta kurban tanda damai. Ketika kamu melakukannya di setiap tempat yang Aku tentukan untuk menyembah-Ku, Aku akan hadir dan memberkatimu. ");
INSERT INTO ind_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Apabila kamu hendak membuat mezbah untuk-Ku dari batu, jangan menggunakan batu yang sudah dipahat. Karena jika kamu memahatnya dengan peralatan, kamu mencemarkan mezbah itu. ");
INSERT INTO ind_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Janganlah membuat mezbah terlalu tinggi sehingga membutuhkan banyak anak tangga, supaya kemaluanmu tidak terlihat.” ");
INSERT INTO ind_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","TUHAN berkata kepada Musa, “Sampaikanlah peraturan-peraturan ini kepada umat Israel: ");
INSERT INTO ind_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Apabila kamu membeli budak laki-laki sesama orang Israel, dia hanya boleh mengabdi kepadamu selama enam tahun. Pada tahun yang ketujuh, kamu harus membebaskan dia secara cuma-cuma, tanpa meminta uang tebusan darinya. ");
INSERT INTO ind_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Jika dia belum menikah ketika menjadi budakmu, maka dia akan keluar seorang diri. Jika dia sudah beristri ketika menjadi budakmu, maka istrinya juga ikut keluar bersama dengannya. ");
INSERT INTO ind_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","“Jika kamu memberikan istri kepadanya ketika statusnya masih sebagai budak, dan mereka mempunyai anak laki-laki atau perempuan, maka istri dan anak-anaknya tetap menjadi milik mu. Hanya budak itu sendiri yang keluar menjadi orang merdeka. ");
INSERT INTO ind_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Akan tetapi, jika budak itu menyatakan, ‘Aku mengasihi majikanku, istriku, dan anak-anakku. Aku memutuskan untuk tetap menjadi budak,’ ");
INSERT INTO ind_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","maka kamu harus membawa dia ke hadapan-Ku di kemah TUHAN, lalu membawanya ke pintu atau tiang pintu sebagai alas untuk melubangi daun telinganya sebagai tanda statusnya sebagai budak. Dengan demikian, budak itu akan menjadi milikmu seumur hidup. ");
INSERT INTO ind_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Apabila seorang ayah dari bangsa Israel menjual anak perempuannya sebagai budak, maka budak perempuan itu tidak akan dibebaskan setelah enam tahun— berbeda dengan budak laki-laki. ");
INSERT INTO ind_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Jika majikan laki-laki membeli budak perempuan Israel untuk dijadikan gundik, tetapi kemudian dia tidak menyukainya, maka dia harus mengizinkan keluarga budak perempuan itu menebusnya. Dia tidak boleh menjual perempuan itu kepada orang asing, karena dialah yang melanggar perjanjian dengan budak itu. ");
INSERT INTO ind_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Jika seorang majikan membeli budak perempuan untuk dinikahkan dengan anak laki-lakinya, dia tidak boleh memperlakukan perempuan itu sebagai budak, tetapi sebagai menantu perempuannya. ");
INSERT INTO ind_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Jika seorang majikan memperistri budak perempuannya, kemudian memperistri perempuan lain, dia tidak boleh mengurangi jatah makanan, pakaian, maupun hak persetubuhan bagi budak yang pertama itu. ");
INSERT INTO ind_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Apabila dia tidak memenuhi ketiga hal itu, maka dia harus membebaskan perempuan tersebut secara cuma-cuma, tanpa meminta uang tebusan darinya.” ");
INSERT INTO ind_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Siapa pun yang memukul sesamanya sampai mati harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tetapi pasti akan ada pembunuhan yang terjadi secara tidak sengaja, dan Aku tidak mencegah hal itu. Itulah sebabnya Aku akan menentukan beberapa kota perlindungan, agar orang yang membunuh secara tidak sengaja dapat melarikan diri. ");
INSERT INTO ind_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Namun, apabila seseorang dengan sengaja membunuh sesamanya, dia harus ditangkap sekalipun berlindung di mezbah-Ku, dan harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Siapa pun yang memukul ayah atau ibunya harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Siapa pun yang menculik harus dihukum mati, tak peduli orang yang diculiknya sudah dijual sebagai budak atau masih ada padanya. ");
INSERT INTO ind_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Siapa pun yang menyumpahi ayah atau ibunya harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Jika dua orang bertengkar dan yang seorang memukul lawannya dengan batu, atau meninjunya, sehingga lawannya tidak bisa bangun dari tempat tidur, tetapi tidak mati, ");
INSERT INTO ind_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kemudian dia sembuh dan dapat berjalan kembali meskipun dengan tongkat, maka orang yang memukulnya akan dibebaskan dari hukuman. Hanya saja, selama waktu penyembuhan korban, orang yang memukul harus membayar semua biaya pengobatan dan kerugian yang timbul karena korban itu tidak dapat bekerja. ");
INSERT INTO ind_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Jika seorang majikan memukul budak laki-laki atau perempuannya dengan tongkat sehingga budak itu mati, dia harus dihukum. ");
INSERT INTO ind_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Tetapi jika budak itu sembuh dan dapat berjalan kembali satu atau dua hari kemudian, majikannya tidak akan dihukum, karena budak itu adalah miliknya. ");
INSERT INTO ind_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Jika dua orang berkelahi, dan salah satu dari mereka tidak sengaja mencederai seorang perempuan hamil sehingga keguguran, tetapi tidak terluka parah, maka orang yang mencederainya harus membayar denda kepada suami perempuan itu sejumlah yang dituntut suaminya dan disetujui oleh para hakim. ");
INSERT INTO ind_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Namun, jika perempuan itu terluka parah, maka orang yang memukulnya harus dihukum sesuai akibat perbuatannya: Nyawa dibayar nyawa, ");
INSERT INTO ind_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mata dibayar mata, gigi dibayar gigi, tangan dibayar tangan, kaki dibayar kaki, ");
INSERT INTO ind_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","luka bakar dibayar luka bakar, luka dibayar luka, memar dibayar memar. ");
INSERT INTO ind_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Jika majikan memukul mata budaknya laki-laki atau perempuan sehingga buta, dia harus membebaskan budak itu sebagai ganti matanya yang rusak. ");
INSERT INTO ind_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Jika majikan memukul gigi budaknya laki-laki atau perempuan sehingga patah, dia harus membebaskan budak itu sebagai ganti giginya yang patah. ");
INSERT INTO ind_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Jika seekor sapi jantan menanduk seorang laki-laki atau perempuan sampai mati, sapi itu harus dilempari batu sampai mati, dan dagingnya tidak boleh dimakan. Pemilik sapi itu tidak perlu dihukum. ");
INSERT INTO ind_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Namun, jika sapi jantan itu sudah sering menanduk orang dan pemiliknya tidak menghiraukan peringatan untuk menjaga sapinya, maka sapi itu harus dilempari batu sampai mati dan pemiliknya juga harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Apabila keluarga korban tidak mau pemilik sapi itu dihukum mati, dan hanya menuntut uang tebusan, maka pemilik sapi harus membayar uang tebusan sejumlah yang diminta oleh keluarga korban. ");
INSERT INTO ind_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“Hal yang sama juga berlaku jika sapi jantan itu menanduk seorang anak, laki-laki maupun perempuan. ");
INSERT INTO ind_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Jika sapi itu menanduk seorang budak laki-laki atau perempuan, pemilik sapi harus membayar 340 gram perak kepada pemilik budak itu, dan sapi itu dilempari batu sampai mati. ");
INSERT INTO ind_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Jika seseorang membuka penampungan air atau menggali yang baru dan tidak menutupnya, lalu seekor sapi atau keledai jatuh ke dalamnya dan mati, ");
INSERT INTO ind_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","maka pemilik penampungan air itu harus membayar ganti rugi kepada pemilik hewan, dan hewan yang mati itu menjadi miliknya. ");
INSERT INTO ind_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Jika seekor sapi jantan milik seseorang melukai sapi jantan tetangganya hingga mati, maka mereka harus menjual sapi yang hidup dan uangnya dibagi dua. Daging sapi yang mati juga dibagi dua di antara mereka. ");
INSERT INTO ind_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Namun, jika sapi jantan itu memang terkenal sering menanduk dan pemiliknya tidak menjaganya dengan baik, maka pemilik sapi ganas itu harus mengganti sapi yang mati dengan uang atau sapi lain, sedangkan sapi yang mati itu menjadi miliknya.” ");
INSERT INTO ind_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Peraturan selanjutnya dari TUHAN, “Jika seseorang mencuri seekor sapi atau domba, lalu menyembelihnya atau menjualnya, maka dia harus mengganti seekor sapi itu dengan lima ekor sapi, atau seekor domba dengan empat ekor domba. ");
INSERT INTO ind_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Jika pada malam hari seorang pencuri tertangkap basah sedang masuk ke rumah seseorang dan dia dibunuh, maka orang yang membunuhnya tidak dianggap bersalah. ");
INSERT INTO ind_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Namun, apabila pencuri itu tertangkap basah pada pagi atau siang hari dan dia dibunuh, maka pembunuhnya dianggap bersalah dan harus dihukum mati. “Seorang pencuri harus membayar ganti rugi atas semua yang sudah dicurinya. Jika dia tidak mampu membayar ganti rugi, dia harus dijual sebagai budak untuk membayarnya. ");
INSERT INTO ind_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Apabila sapi, keledai, atau domba yang dicurinya ditemukan ada padanya dalam keadaan hidup, dia harus membayar ganti rugi sebesar dua kali lipat.” ");
INSERT INTO ind_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Jika seseorang membiarkan ternaknya makan rumput di ladang atau kebun anggur miliknya, lalu hewan itu berkeliaran sehingga memakan tanaman di ladang orang lain, maka pemilik hewan harus membayar ganti rugi kepada pemilik ladang itu dengan memberikan hasil panen terbaik dari ladang atau kebun anggurnya. ");
INSERT INTO ind_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Jika seseorang menyalakan api untuk membakar semak-semak duri, dan api itu menyebar ke ladang orang lain sehingga membakar gandum di ladang itu, maka dia harus membayar ganti rugi.” ");
INSERT INTO ind_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Jika seseorang menitipkan uang atau barang kepada temannya, dan titipan itu dicuri dari rumah temannya, maka apabila pencuri itu tertangkap, dia harus membayar ganti rugi sebesar dua kali lipat. ");
INSERT INTO ind_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Namun, jika pencurinya tidak tertangkap, maka pemilik rumah harus menghadap para hakim di kemah-Ku agar mereka menentukan apakah dia pelaku pencurian itu atau bukan. ");
INSERT INTO ind_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Jika dua orang berselisih mengenai sapi, keledai, domba, pakaian, atau barang lain yang hilang, maka kedua belah pihak yang berselisih itu harus menghadap para hakim di kemah-Ku. Para hakim akan menyatakan siapa yang bersalah. Orang yang bersalah harus membayar dua kali lipat kepada pemilik sebenarnya. ");
INSERT INTO ind_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Jika seseorang menitipkan keledai, sapi, domba, atau hewan lain kepada temannya, lalu hewan itu mati, terluka, atau hilang, dan tidak ada seorang pun yang melihat kejadiannya, ");
INSERT INTO ind_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","maka temannya itu harus bersumpah di hadapan TUHAN bahwa dia tidak mengambil hewan tersebut. Pemilik hewan harus menerima sumpah temannya dan tidak meminta ganti rugi. ");
INSERT INTO ind_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Apabila diketahui dengan pasti bahwa hewan itu hilang karena dicuri, maka temannya harus membayar ganti rugi kepada pemiliknya. ");
INSERT INTO ind_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Apabila ternyata hewan itu diserang binatang buas dan temannya bisa menunjukkan bangkainya sebagai bukti, dia tidak perlu membayar ganti rugi. ");
INSERT INTO ind_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Jika seseorang meminjam seekor hewan dari temannya, lalu binatang itu terluka atau mati saat pemiliknya tidak berada di tempat, maka peminjam harus membayar ganti rugi. ");
INSERT INTO ind_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Namun, apabila pemiliknya ada di sana saat hal itu terjadi, maka peminjam tidak usah membayar ganti rugi. “Apabila hewan itu dipinjam dengan bayaran, yakni disewa, maka penyewa tidak usah membayar ganti rugi karena uang sewanya sudah meliputi biaya ganti rugi.” ");
INSERT INTO ind_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Jika seorang laki-laki merayu seorang perawan yang belum bertunangan, lalu bersetubuh dengannya, maka dia harus membayar mas kawin untuk perempuan itu dan menikahinya. ");
INSERT INTO ind_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Apabila ayah perempuan itu menolak untuk menikahkan anaknya dengan laki-laki tersebut, dia tetap harus membayar uang sejumlah mas kawin untuk perawan.” ");
INSERT INTO ind_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Jangan membiarkan seorang perempuan tukang sihir tetap hidup. ");
INSERT INTO ind_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Siapa pun yang bersetubuh dengan binatang harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Siapa pun yang mempersembahkan kurban kepada dewa, Aku menentukan dia untuk dimusnahkan.” ");
INSERT INTO ind_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Jangan menindas orang asing. Ingatlah bahwa dahulu kalian pernah hidup sebagai orang asing di Mesir. ");
INSERT INTO ind_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Jangan melakukan perbuatan yang merugikan para janda atau anak yatim. ");
INSERT INTO ind_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Apabila kamu merugikan mereka dan mereka berseru kepada-Ku, Aku pasti membela mereka. ");
INSERT INTO ind_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Aku akan memurkaimu dengan membiarkan kamu dibunuh oleh musuhmu. Istrimu akan menjadi janda dan anak-anakmu akan menjadi yatim. ");
INSERT INTO ind_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Jika kamu meminjamkan uang kepada salah seorang umat-Ku yang miskin, janganlah berlaku seperti lintah darat dengan membebankan bunga kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","“Jika kamu mengambil jubah sesamamu sebagai jaminan utang, kamu harus mengembalikan jubah itu sebelum matahari terbenam, ");
INSERT INTO ind_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","karena mungkin jubah itu adalah satu-satunya baju hangat miliknya, dan dia membutuhkannya untuk tidur. Apabila kamu tidak mengembalikannya lalu dia berseru minta tolong kepada-Ku, Aku akan membela dia, karena Aku penuh belas kasihan.” ");
INSERT INTO ind_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Jangan menghina Allah ataupun mengutuki pemimpin bangsamu. ");
INSERT INTO ind_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Jangan menunda dalam memberikan kepada-Ku bagian pertama dari setiap jenis gandum-ganduman yang kamu panen dan anggur yang kamu peras. “Serahkanlah kepada-Ku setiap anak laki-lakimu yang sulung. ");
INSERT INTO ind_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“Demikian juga dengan anak sulung jantan dari sapi, kambing, dan domba. Biarkanlah anak-anak binatang itu tinggal bersama induknya selama tujuh hari, lalu persembahkanlah kepada-Ku pada hari kedelapan. ");
INSERT INTO ind_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Kalian harus menjadi orang-orang yang kudus bagi-Ku. Karena itu, jangan makan daging binatang yang mati dibunuh oleh binatang buas. Berikanlah bangkainya kepada anjing.” ");
INSERT INTO ind_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Jangan menyebarkan berita bohong. Jangan membantu orang bersalah dengan memberikan kesaksian palsu di pengadilan. ");
INSERT INTO ind_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Jangan mengikuti pengaruh orang banyak yang mendesak untuk melakukan sesuatu yang tidak adil. Jangan memihak kepada mereka dengan bersaksi palsu di pengadilan untuk memutarbalikkan kebenaran. ");
INSERT INTO ind_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Jangan membela orang yang bersalah dalam perkara pengadilan hanya karena dia miskin. ");
INSERT INTO ind_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Jika kamu melihat sapi atau keledai milik musuhmu tersesat, kembalikanlah kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Jika kamu melihat keledai seseorang yang membencimu jatuh karena bebannya terlalu berat, bantulah dia agar keledainya berdiri kembali. Jangan tinggalkan orang itu dalam keadaan susah. ");
INSERT INTO ind_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Jangan memperlakukan orang miskin dengan tidak adil dalam perkaranya di pengadilan. ");
INSERT INTO ind_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Jangan membuat tuduhan palsu dan jangan menghukum mati orang yang tidak bersalah. Aku tidak akan mengampuni orang yang melakukan kejahatan itu. ");
INSERT INTO ind_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Jangan menerima suap, karena suap membutakan orang dan memutarbalikkan kesaksian yang benar. ");
INSERT INTO ind_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Jangan menindas orang asing yang menjadi pendatang, karena kalian pernah hidup sebagai orang asing di Mesir dan tahu bagaimana rasanya menjadi pendatang.” ");
INSERT INTO ind_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Selama enam tahun kamu boleh menanami ladang-ladangmu dan memanen hasilnya. ");
INSERT INTO ind_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Tetapi tahun yang ketujuh adalah Tahun Sabat. Pada tahun itu biarkanlah ladangmu, supaya orang miskin di antara kalian dapat mengumpulkan makanan dari situ dan binatang liar bisa memakan sisanya. Lakukanlah juga demikian pada kebun anggur dan kebun zaitunmu. ");
INSERT INTO ind_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Bekerjalah selama enam hari. Tetapi pada hari yang ketujuh kamu harus berhenti bekerja, supaya sapimu, keledaimu, semua budakmu, dan pendatang asing yang tinggal padamu bisa beristirahat. ");
INSERT INTO ind_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Taatilah semua perkataan-Ku dengan teliti. Dan jangan sekali-kali menyebut nama dewa dalam situasi apa pun!” ");
INSERT INTO ind_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Setiap tahun, rayakanlah tiga perayaan ini untuk menghormati Aku: ");
INSERT INTO ind_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Yang pertama adalah Hari Raya Roti Tidak Beragi. Selama seminggu kamu tidak boleh makan roti yang mengandung ragi sebagaimana yang sudah Aku perintahkan kepada kalian. Rayakanlah ini setiap tahun pada waktu yang sudah ditetapkan pada bulan Abib, karena pada bulan itulah kalian keluar dari Mesir. Setiap kali kamu menghadiri perayaan di hadapan-Ku, kamu harus mempersembahkan kurban. ");
INSERT INTO ind_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Yang kedua adalah Hari Raya Panen. Pada perayaan ini, persembahkanlah hasil panenmu yang pertama kepada-Ku. “Yang ketiga adalah Hari Raya Pondok Cabang-cabang Berdaun. Rayakanlah ini pada akhir musim panen, sesudah kamu mengumpulkan seluruh hasil kebun dan ladangmu. ");
INSERT INTO ind_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Pada ketiga perayaan tahunan itu, semua laki-laki harus menghadap kepada-Ku, TUHAN Allahmu, di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Saat mempersembahkan kurban sembelihan, jangan mempersembahkan roti yang beragi. Jangan membiarkan lemak dari kurban perayaan tersisa sampai besok paginya. ");
INSERT INTO ind_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Bawalah hasil terbaik panen pertamamu ke kemah TUHAN Allahmu. “Jangan memasak daging anak kambing dengan air susu induknya.” ");
INSERT INTO ind_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Aku akan mengutus malaikat untuk menjaga kalian dalam perjalanan dan menuntun kalian menuju tempat yang sudah Aku persiapkan. ");
INSERT INTO ind_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Perhatikan dan taatilah dia. Jangan menentangnya, karena dia mewakili Aku. Dia tidak akan mengampuni pemberontakanmu. ");
INSERT INTO ind_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Namun, apabila kalian sungguh-sungguh menaati dia dan melakukan semua perintah-Ku, Aku akan memusuhi semua musuhmu dan melawan semua lawanmu. ");
INSERT INTO ind_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malaikat itu akan berjalan di depan kalian dan memimpin kalian ke negeri yang didiami orang Amori, Het, Feris, Kanaan, Hewi, dan Yebus. Aku akan memusnahkan mereka. ");
INSERT INTO ind_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Jangan bersujud kepada dewa-dewa mereka, dan jangan menyembah atau menghormati dewa-dewa itu dengan cara apa pun. Jangan pula meniru cara ibadah mereka. Tetapi musnahkanlah patung-patung berhala mereka dan hancurkanlah tugu-tugu tempat mereka beribadat. ");
INSERT INTO ind_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Sembahlah hanya Aku, TUHAN Allahmu, maka Aku akan memberkatimu sehingga kamu tidak akan kekurangan makanan dan minuman, dan Aku akan menjauhkan kamu dari penyakit. ");
INSERT INTO ind_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tidak akan ada perempuan di negerimu yang akan keguguran atau mandul, dan Aku akan memberimu umur panjang. ");
INSERT INTO ind_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Aku akan membuat semua bangsa musuh yang kalian hadapi ketakutan. Mereka akan menjadi kalang kabut dan lari dari hadapan kalian. ");
INSERT INTO ind_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Aku akan membuat orang Hewi, Kanaan, dan Het begitu ketakutan ketika kalian siap memasuki daerah mereka, sehingga mereka lari dari kalian. ");
INSERT INTO ind_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tetapi Aku tidak akan mengusir mereka semuanya dalam waktu satu tahun, supaya negeri itu tidak terlantar dan binatang buas tidak bertambah banyak sehingga membahayakan kalian. ");
INSERT INTO ind_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Aku akan mengusir mereka sedikit demi sedikit sampai jumlah kalian bertambah dan cukup banyak untuk menguasai negeri itu. ");
INSERT INTO ind_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Aku akan menetapkan batas daerah kalian dari Laut Merah sampai Laut Tengah, dari padang belantara sampai sungai Efrat. Aku akan menyerahkan penghuni negeri itu kepada kalian dan kalian akan mengusir mereka. ");
INSERT INTO ind_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Janganlah membuat perjanjian apa pun dengan orang-orang negeri itu, dan jangan bersepakat untuk menyembah dewa-dewa mereka. ");
INSERT INTO ind_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Janganlah membiarkan mereka tinggal di antara kalian. Apabila kalian membiarkan mereka tinggal di sana, mereka akan membuat kalian berdosa terhadap-Ku dengan menyembah dewa-dewa mereka, sehingga kalian terjerat dalam kejahatan itu.” ");
INSERT INTO ind_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","2","Lalu TUHAN berkata pada Musa, “Naiklah ke gunung Sinai menghadap Aku bersama Harun, Nadab, Abihu, dan tujuh puluh orang dari tua-tua Israel. Selain mereka, tidak ada yang boleh ikut naik. Sesampai di atas, sujudlah kalian menyembah Aku dari jauh. Sesudah itu, datanglah kamu seorang diri mendekat kepada-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kemudian Musa menyampaikan kepada bangsa itu segala perintah dan peraturan yang diberikan TUHAN. Seluruh umat dengan satu suara menjawab, “Kami akan melakukan semua yang TUHAN perintahkan.” ");
INSERT INTO ind_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Lalu Musa menuliskan seluruh perintah TUHAN dalam gulungan kitab. Keesokan harinya, pagi-pagi sekali Musa mendirikan mezbah di kaki gunung dan menegakkan dua belas batu peringatan. Setiap batu mewakili satu suku Israel. ");
INSERT INTO ind_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Lalu dia menyuruh beberapa pemuda untuk mempersembahkan kurban yang dibakar habis dan menyembelih sapi-sapi jantan muda sebagai kurban tanda damai kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa menuangkan separuh dari darah kurban yang disembelih itu ke dalam baskom-baskom dan mencurahkan separuhnya lagi pada mezbah. ");
INSERT INTO ind_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Kemudian dia mengambil Kitab Perjanjian itu dan membacakannya dengan suara keras kepada seluruh umat. Mereka menjawab, “Kami akan melakukan perintah TUHAN. Kami akan menaati-Nya.” ");
INSERT INTO ind_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Lalu Musa mengambil darah yang ada di baskom-baskom tadi dan memercikkannya kepada umat itu sambil berkata, “Berdasarkan semua perintah-Nya itu, darah ini mengesahkan perjanjian yang sudah TUHAN buat denganmu.” ");
INSERT INTO ind_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Sesudah upacara tersebut, Musa, Harun, Nadab, dan Abihu, beserta ketujuh puluh tua-tua Israel naik ke gunung ");
INSERT INTO ind_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","dan melihat Allah Israel. Di bawah kaki-Nya terlihat sesuatu seperti lantai yang terbuat dari batu permata biru, jernih seperti langit tanpa awan. ");
INSERT INTO ind_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Walaupun para pemimpin Israel itu melihat Allah, Dia tidak membinasakan mereka, bahkan mereka makan dan minum di hadapan-Nya sebagai tanda pengikatan perjanjian dengan-Nya. ");
INSERT INTO ind_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Sesudah mereka turun, TUHAN berkata kepada Musa, “Datanglah kepada-Ku di atas gunung ini dan berdiamlah di sini. Aku akan memberimu dua lempengan batu. Di situ Aku sudah menuliskan perintah-perintah-Ku, agar kamu bisa mengajarkannya kepada umat-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","15","Maka Musa berangkat bersama tangan kanannya bernama Yosua, dengan berpesan kepada para tua-tua, “Tunggulah di bawah sampai kami kembali. Harun dan Hur ada bersama kalian. Apabila terjadi masalah di antara umat, kalian bisa membawanya kepada Harun dan Hur.” Kemudian naiklah Musa ke atas gunung, dan awan menutupi gunung itu. ");
INSERT INTO ind_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kemuliaan TUHAN berdiam di atas gunung Sinai. Awan menutupi gunung itu selama enam hari. Pada hari yang ketujuh, TUHAN memanggil Musa dari dalam awan. ");
INSERT INTO ind_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Dari pandangan umat Israel yang berada di kaki gunung, kemuliaan TUHAN di atas gunung terlihat seperti api yang berkobar-kobar. ");
INSERT INTO ind_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Lalu Musa mendaki lebih tinggi dan masuk ke dalam awan itu. Dia tinggal di atas gunung selama empat puluh hari empat puluh malam. ");
INSERT INTO ind_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Suruhlah umat Israel membawa berbagai pemberian bagi-Ku untuk membuat kemah-Ku. Terimalah pemberian dari setiap orang yang hatinya terdorong untuk memberi. ");
INSERT INTO ind_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Inilah pemberian yang boleh kamu terima dari mereka: emas, perak, perunggu, ");
INSERT INTO ind_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","benang linen warna merah, biru, dan ungu, kain linen yang berkualitas tinggi, kain dari bulu kambing, ");
INSERT INTO ind_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kulit domba jantan yang diwarnai merah, kulit yang tidak menyerap air, kayu akasia, ");
INSERT INTO ind_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","minyak zaitun untuk penerangan, wangi-wangian dari getah pohon untuk dimasukkan ke dalam minyak urapan dan untuk membakar dupa, ");
INSERT INTO ind_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","batu permata hijau dan batu permata lainnya untuk dipasang pada baju efod dan penutup dada imam besar. ");
INSERT INTO ind_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Katakan kepada mereka bahwa mereka perlu membangun kemah yang kudus bagi-Ku, supaya Aku tinggal di tengah-tengah mereka. ");
INSERT INTO ind_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Kamu akan memimpin mereka untuk membuat kemah-Ku ini dan perabotannya sesuai dengan semua pola yang akan Aku tunjukkan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","TUHAN berbicara kepada Musa, “Buatlah sebuah peti untuk mengingat perjanjian yang Aku adakan dengan umat Israel. Peti itu haruslah dibuat dari kayu akasia, dengan panjang 115 sentimeter, lebar 69 sentimeter, dan tinggi 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lapisilah bagian dalam dan luarnya dengan emas murni, juga buatlah bingkai emas untuk bagian atasnya. ");
INSERT INTO ind_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Supaya peti dapat diangkut dengan dua tongkat pengusung, buatlah empat gelang yang dicetak dari emas dan pasanglah di keempat kakinya, yakni dua gelang pada tiap sisi panjangnya. ");
INSERT INTO ind_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Buatlah dua tongkat pengusung dari kayu akasia dan lapisilah dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Masukkan kedua tongkat itu ke dalam gelang-gelang yang ada di kedua sisi peti, agar peti dapat diusung. ");
INSERT INTO ind_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tongkat-tongkat itu harus tetap terpasang pada gelang-gelang peti dan tidak boleh dilepaskan. ");
INSERT INTO ind_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“Aku akan memberikan dua lempengan batu bertuliskan kewajiban yang harus dipenuhi umat Israel dalam perjanjian dengan Aku. Letakkanlah kedua lempengan itu di dalam peti ini. ");
INSERT INTO ind_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Berikut ini cara membuat penutup untuk peti. Penutupnya disebut Takhta Pendamaian dan harus dibuat dari emas murni, dengan panjang 115 sentimeter dan lebar 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","20","Cetaklah penutup peti itu sekaligus dengan dua bentuk malaikat penjaga di atasnya, yang berdiri saling berhadapan di kanan dan kiri penutup itu. Wajah kedua malaikat itu mengarah ke penutup peti dan sayap-sayapnya membentang ke atas sehingga menaungi penutup peti. Bentuk kedua malaikat dan penutup peti sudah menjadi satu bagian sejak awal pembuatannya. ");
INSERT INTO ind_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Masukkan lempengan batu yang akan Aku berikan kepadamu ke dalam peti itu dan tutuplah dengan penutupnya. ");
INSERT INTO ind_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Di sanalah, yaitu di antara kedua malaikat penjaga yang ada di atas penutup peti perjanjian itu, Aku akan menjumpaimu dan memberikan semua perintah-Ku kepadamu untuk disampaikan kepada bangsa Israel.” ");
INSERT INTO ind_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","TUHAN berkata kepada Musa, “Buatlah meja dari kayu akasia untuk menyajikan roti bagi-Ku, panjangnya 92 sentimeter, lebarnya 46 sentimeter, dan tingginya 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Lapisilah meja itu dengan emas murni, dan buatlah bingkai emas di sekelilingnya. ");
INSERT INTO ind_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Buatlah juga pinggiran mengelilinginya selebar 8 sentimeter, dan buatlah bingkai dari emas di sepanjang pinggiran itu. ");
INSERT INTO ind_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Buatlah empat gelang emas dan pasanglah di keempat sudutnya, yakni pada keempat kaki meja. ");
INSERT INTO ind_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Keempat gelang itu harus dipasang dekat dengan pinggiran meja sebagai lubang untuk memasang dua tongkat pengusung meja. ");
INSERT INTO ind_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Buatlah dua tongkat pengusung itu dari kayu akasia dan lapisilah dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Untuk ditaruh juga pada meja ini, buatlah dari emas murni beberapa piring, sendok, kendi, dan mangkuk, untuk digunakan dalam persembahan air anggur. ");
INSERT INTO ind_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","“Hendaklah roti sajian bagi-Ku selalu ada di atas meja ini.” ");
INSERT INTO ind_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Buatlah tiang pelita bercabang dari emas murni. Semua bagian tiang pelita itu harus dibentuk dengan cara ditempa dari satu bongkah emas, termasuk bagian kakinya, batangnya, dan tujuh pelitanya, juga hiasannya yang berbentuk seperti kelopak dan mahkota bunga. ");
INSERT INTO ind_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Buatlah tiang pelita itu dengan enam cabang, tiga pada sisi kiri dan tiga pada sisi kanan. ");
INSERT INTO ind_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Setiap cabang memiliki tiga hiasan yang berbentuk bunga badam, lengkap dengan kelopak dan mahkota bunganya. ");
INSERT INTO ind_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Buatlah tiang utama yang di tengah memiliki empat hiasan berbentuk bunga badam, lengkap dengan kelopak dan mahkota bunganya. ");
INSERT INTO ind_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Buatlah juga hiasan berbentuk kuncup bunga badam di bawah masing-masing pasangan cabang yang keluar dari tiang utama pelita. ");
INSERT INTO ind_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tiang pelita itu dan semua cabangnya serta hiasannya harus dibuat dari emas murni dengan cara ditempa dari satu bongkah emas. ");
INSERT INTO ind_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Buatlah tujuh pelita dan letakkanlah di ujung atas tiang utama itu dan keenam cabangnya, supaya menerangi bagian depannya. ");
INSERT INTO ind_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Buatlah juga dari emas murni sejumlah penjepit untuk membersihkan sumbu pelita, dan wadah-wadah kecil untuk menampung sumbu yang hangus. ");
INSERT INTO ind_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Emas murni yang diperlukan untuk membuat tiang pelita bercabang itu beserta semua perlengkapannya adalah 34 kilogram. ");
INSERT INTO ind_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Pastikanlah untuk membuat semuanya sesuai dengan pola yang ditunjukkan kepadamu di atas gunung ini.” ");
INSERT INTO ind_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","TUHAN berkata kepada Musa, “Inilah cara membuat atap kemah-Ku. Lapisan paling bawah dibuat dari sepuluh helai kain linen berkualitas tinggi yang ditenun dengan benang berwarna merah, biru, dan ungu. Tenunan itu membentuk pola yang indah berupa malaikat-malaikat penjaga. ");
INSERT INTO ind_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ukuran setiap helai kain harus sama, panjangnya 13 meter dan lebarnya 1,8 meter. ");
INSERT INTO ind_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Dari kesepuluh helai kain itu, buatlah dua rangkaian kain yang masing-masing terdiri dari lima helai. Setiap helai disambung dengan cara dijahit pada sisi panjangnya. Sesudah disambung, panjang setiap rangkaian itu tetap 13 meter dan lebarnya menjadi 9 meter. ");
INSERT INTO ind_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Pada kedua sisi 13 meter di tempat kedua rangkaian kain itu disambung, buatlah lima puluh lubang kait dari tali biru. Setiap lubang kait di rangkaian kain yang satu harus saling berhadapan dengan sebuah lubang kait pada rangkaian kain lainnya yang akan disambungkan. ");
INSERT INTO ind_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Untuk menyambung kedua rangkaian itu, buatlah lima puluh pengait dari emas. Letakkan kedua sisi rangkaian itu supaya kelimapuluh lubang kait saling berhadapan, lalu gunakanlah lima puluh pengait emas untuk mengaitkan setiap pasang lubang kait itu, agar atap kemah-Ku menjadi satu kesatuan. ");
INSERT INTO ind_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","8","“Untuk lapisan kedua pada atap kemah-Ku, buatlah sebelas helai kain yang ditenun dari bulu kambing. Setiap helai harus berukuran sama, panjangnya 14 meter dan lebarnya 1,8 meter. ");
INSERT INTO ind_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","11","Pada tiap sisi panjang kain, buatlah lima puluh lubang kait. Setiap lubang kait di helai kain yang satu harus saling berhadapan dengan lubang kait pada helai kain yang akan disambungkan. Dari kesebelas helai kain itu buatlah dua rangkaian. Dengan menggunakan pengait-pengait, sambungkan lima helai menjadi satu rangkaian, dan enam helai lainnya menjadi rangkaian kedua. Helai kain yang keenam dilipat dua di atas bagian depan kemah itu. ");
INSERT INTO ind_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Rangkaian kain bulu kambing ini lebih lebar hampir satu meter daripada atap kain linen di bawahnya. Biarkanlah bagian yang lebih ini tergantung dari belakang kemah untuk menutupi sisi belakang. ");
INSERT INTO ind_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kain penutup ini juga lebih panjang satu meter daripada kain atap dari linen. Biarkanlah setengah meter kelebihan itu menggantung di sisi kiri dan kanan, agar menutupi kedua sisi kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Di atas kain-kain penutup itu, taruhlah penutup yang dibuat dari kulit domba jantan yang diwarnai merah. Dan di atasnya lagi taruhlah penutup yang dibuat dari kulit yang tidak menyerap air.” ");
INSERT INTO ind_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Untuk menopang atap kemah-Ku, buatlah papan-papan rangka dari kayu akasia. ");
INSERT INTO ind_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Setiap papan berukuran tinggi 4,6 meter dan lebar 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","22","Semua papan rangka ini dibuat sama, yakni dengan dua pasak yang menjulur dari bawah di ujung kiri dan kanan setiap rangka. Buatlah dua puluh rangka untuk sisi selatan kemah, dua puluh untuk sisi utara, dan delapan untuk sisi barat, yaitu bagian belakang kemah. Sebagai tempat untuk menahan rangka-rangka itu, setiap pasak akan dimasukkan ke dalam lubang pada alas penahan yang dibuat dari perak. Seluruhnya akan ada sembilan puluh enam alas untuk keempat puluh delapan rangka itu. ");
INSERT INTO ind_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","25","Mengenai delapan rangka di bagian belakang kemah, buatlah enam rangka dengan cara yang sama seperti semua rangka di kedua sisi. Namun, dua papan rangka di kedua sudut belakang kemah perlu dibuat secara khusus. Kedua rangka itu akan menyatukan sudut kiri dan kanan, dari bawah sampai ke atas, dan tersambung di ujung atas dengan gelang penahan yang dibuat dari emas. Kedelapan rangka untuk sisi belakang Kemah-Ku akan dipasang di atas enam belas alas penahan yang dibuat dari perak, dua alas untuk setiap rangka. ");
INSERT INTO ind_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Agar kemah-Ku kokoh, buatlah kayu lintang dari kayu akasia, untuk melintangi dan menyatukan rangka-rangka itu. Lima batang melintangi sisi utara kemah, ");
INSERT INTO ind_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima batang di sisi selatan, dan lima batang yang lebih pendek di bagian belakang kemah, yaitu sisi yang menghadap ke barat. ");
INSERT INTO ind_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Empat dari kayu lintang dipasang di atas dan di bawah, sedangkan kayu lintang yang di tengah akan dipasang pada setengah dari tinggi rangka-rangka, dan melintang dari ujung yang satu sampai ke ujung yang lain. ");
INSERT INTO ind_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Sebagai tempat untuk memasukkan semua kayu lintang itu, buatlah gelang-gelang emas yang dipasang pada setiap rangka. Semua rangka dan kayu lintang haruslah dilapisi dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Dirikan kemah-Ku sesuai dengan rancangan yang Aku tunjukkan kepadamu di atas gunung.” ");
INSERT INTO ind_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Untuk memisahkan bagian dalam kemah-Ku menjadi dua ruangan, buatlah sebuah tirai dari kain linen berkualitas tinggi yang ditenun berbentuk malaikat-malaikat penjaga, dari benang linen merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Gantungkan tirai itu dengan pengait-pengait emas pada empat tiang kayu akasia yang dilapisi dengan emas. Tiang-tiang itu didirikan di atas empat alas penahan yang dicetak dari perak. ");
INSERT INTO ind_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","34","Gantungkan tirai itu pada kaitan emas, dan letakkan peti perjanjian lengkap dengan penutupnya pada ruangan di belakang tirai itu, yang disebut ruang mahakudus. Ruang di depannya disebut ruang kudus. ");
INSERT INTO ind_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Di ruang depan tirai itu, tempatkanlah meja di sebelah utara dan tiang pelita bercabang di sebelah selatan, sehingga keduanya saling berhadapan. ");
INSERT INTO ind_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Untuk pintu masuk kemah, tenunlah satu tirai dari benang linen berkualitas tinggi yang berwarna merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tirai itu akan digantung dengan pengait-pengait emas pada lima tiang kayu akasia yang dilapisi dengan emas. Tiang-tiang ini akan berdiri di atas lima alas yang dicetak dari perunggu.” ");
INSERT INTO ind_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","TUHAN berbicara kepada Musa, “Buatlah sebuah mezbah dari kayu akasia berbentuk persegi, dengan panjang keempat sisinya 2,3 meter dan tingginya 1,4 meter. ");
INSERT INTO ind_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Di keempat sudut atas, buatlah bentuk seperti tanduk sapi yang dipahat sekaligus dari balok kayu mezbah itu. Lalu lapisilah seluruh mezbah itu dengan perunggu. ");
INSERT INTO ind_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Buatlah semua perlengkapan mezbah dari perunggu, yaitu sejumlah tempat abu, sekop, bejana, pengait daging, kuali untuk mengangkut bara. ");
INSERT INTO ind_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","5","Buatlah alas yang berlubang-lubang dari perunggu tebal untuk menahan kayu bakar. Posisi alas itu di dalam mezbah adalah setengah dari tinggi mezbah. Dan di bagian luar mezbah, pasanglah empat gelang dari perunggu pada setiap sudutnya sebagai tempat untuk memasukkan dua tongkat pengusung. ");
INSERT INTO ind_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Buatlah juga dua tongkat pengusung dari kayu akasia, dan lapisilah tongkat itu dengan perunggu. ");
INSERT INTO ind_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ketika mezbah perlu diangkut, kedua tongkat pengusung itu akan dimasukkan pada gelang-gelang di sisi kanan dan kiri mezbah. ");
INSERT INTO ind_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Jadi, mezbah itu berbentuk kotak kosong, seperti yang sudah ditunjukkan kepadamu di atas gunung.” ");
INSERT INTO ind_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","11","“Buatlah halaman untuk kemah-Ku itu. Halaman harus diberi pagar keliling dengan tirai-tirai yang ditenun dari benang linen yang berkualitas tinggi. Rangkaian tirai untuk sisi selatan dan utara masing-masing sepanjang 45 meter. Pada masing-masing sisi, pasanglah tirai itu membentang pada dua puluh tiang menggunakan lubang kait dan pengait perak. Setiap tiang berdiri di atas satu alas yang terbuat dari perunggu. ");
INSERT INTO ind_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Di bagian belakang kemah, yaitu di sebelah barat, lebar tirainya adalah 22,5 meter, yaitu tepat setengah dari panjang sisi utara dan selatan. Pasanglah tirai itu membentang pada sepuluh tiang yang masing-masing didirikan pada alasnya. ");
INSERT INTO ind_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","“Pintu gerbang halaman TUHAN terletak di sebelah timur, dan lebar sisi itu juga 22,5 meter. ");
INSERT INTO ind_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Pintu gerbang masuk akan ada di sisi timur pada bagian tengah, diapit dengan dua rangkaian tirai di kiri dan kanannya, yang lebarnya masing-masing 6,75 meter. Jadi, lebar pintu masuk itu adalah 9 meter. Pasanglah setiap rangkaian tirai itu membentang pada tiga tiang yang masing-masing didirikan pada alasnya. ");
INSERT INTO ind_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Untuk pintu gerbang yang berada di tengah, tenunlah tirai dari benang linen yang berkualitas tinggi berwarna merah, biru, dan ungu, dengan panjang 9 meter. Pasanglah tirai itu membentang pada empat tiang yang masing-masing didirikan pada alasnya. ");
INSERT INTO ind_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","“Bagian ujung atas semua tiang di sekeliling halaman itu haruslah dipasangi gelang penyambung, gunanya sebagai tempat memasang pengait dari perak. Alas tiang-tiang itu harus terbuat dari perunggu. ");
INSERT INTO ind_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Jadi, seluruh halaman akan berukuran 45 meter panjangnya dan 22,5 meter lebarnya. Tinggi tirainya 2,25 meter dan ditenun dari benang linen yang berkualitas. Semua alas tiangnya terbuat dari perunggu. ");
INSERT INTO ind_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Semua perlengkapan lain di kemah-Ku, termasuk pasak-pasak yang ditancapkan ke tanah untuk mengikat tali-tali yang menahan pagar halaman itu, harus dibuat dari perunggu.” ");
INSERT INTO ind_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Perintahkanlah umat Israel untuk membawa kepadamu minyak zaitun murni untuk pelita, agar pelita-pelita di kemah-Ku menyala terus. ");
INSERT INTO ind_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Harun dan anak-anaknya akan bertanggung jawab untuk menjaga agar pelita-pelita di depan tirai ruang mahakudus itu terus menyala di hadapan-Ku, dari petang sampai pagi. Inilah ketetapan bagi bangsa Israel turun temurun.” ");
INSERT INTO ind_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kata TUHAN kepada Musa, “Panggillah kakakmu Harun, beserta anak-anaknya yaitu Nadab, Abihu, Eleazar, dan Itamar. Khususkanlah mereka untuk melayani-Ku sebagai imam. ");
INSERT INTO ind_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","3","Sebelum Harun dapat ditahbiskan untuk melayani-Ku sebagai imam besar, harus dibuat pakaian khusus baginya untuk menunjukkan bahwa dia memegang pelayanan yang terhomat dan mulia bagi-Ku. Suruhlah para perajin ahli yang sudah Aku penuhi dengan kebijaksanaan untuk membuat pakaian khusus itu. ");
INSERT INTO ind_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","5","Inilah pakaian yang perlu mereka buat: Penutup dada, efod, jubah, baju panjang yang ditenun dengan pola yang indah, serban, dan ikat pinggang. Tenunlah kain untuk itu dari benang linen berkualitas tinggi yang berwarna merah, biru, dan ungu, juga dihiasi dengan benang emas. Semua itu dibuat bagi Harun dan anak-anaknya untuk mereka pakai saat melayani-Ku sebagai imam. Pakaian-pakaian itu akan dianggap kudus karena dikhususkan bagi pelayanan bagi-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Para perajin ahli haruslah membuat baju efod dari kain yang ditenun dengan benang linen yang berkualitas tinggi berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas. ");
INSERT INTO ind_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efod itu terdiri dari dua bagian, yaitu bagian depan dan bagian belakang. Keduanya disambungkan dengan dua penutup bahu. ");
INSERT INTO ind_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ikat pinggang yang disatukan dengan efod haruslah dibuat dari bahan yang sama dengan efod, yaitu kain yang ditenun dengan benang linen yang berkualitas berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas. ");
INSERT INTO ind_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Kedua penutup bahu itu dihiasi dengan dua batu permata hijau yang besar, satu di bahu kiri dan satu di kanan. Kedua batu tersebut diukir dengan nama-nama kedua belas anak Yakub, ");
INSERT INTO ind_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","enam nama pada batu yang pertama dan enam nama lainnya pada batu yang kedua, sesuai urutan kelahiran mereka. ");
INSERT INTO ind_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","14","Cara mengukir nama-nama pada kedua batu tersebut adalah sebagaimana ahli pengukir membuat cap meterai. Kedua batu permata itu harus dipasang pada bingkai emas yang dijahit pada penutup dada. Kedua bingkai emas itu dikaitkan ke penutup dada dengan dua rantai emas murni yang dijalin seperti tali. Ketika Harun datang ke hadapan-Ku dengan membawa nama-nama mereka di atas kedua bahunya, Aku akan selalu diingatkan bahwa Harun mewakili seluruh umat-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Para perajin ahli itu haruslah membuat penutup dada untuk digunakan oleh imam dalam mengambil keputusan menurut kehendak-Ku. Penutup dada ini ditenun dari benang linen yang berkualitas tinggi berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas, supaya karyanya serupa dengan efod. ");
INSERT INTO ind_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Penutup dada itu dilipat dua membentuk kantong persegi empat, dengan panjang dan lebar 22 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pasanglah empat baris batu permata pada penutup dada itu. Baris pertama terdiri dari batu permata merah, bening, dan hijau tua. ");
INSERT INTO ind_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Baris kedua terdiri dari batu permata hijau campur biru, biru tua, dan bening. ");
INSERT INTO ind_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Baris ketiga terdiri dari batu permata biru, putih campur cokelat, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Baris keempat terdiri dari batu permata bening, hijau, dan hijau campur merah. Semua permata itu harus dipasang pada bingkai emas. ");
INSERT INTO ind_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Dua belas batu permata itu melambangkan kedua belas anak Yakub, yang kemudian menjadi dua belas suku Israel. Pada setiap batu permata, ukirlah masing-masing satu nama suku Israel, dengan ukiran seperti cap meterai. ");
INSERT INTO ind_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","25","“Sebagai penahan untuk penutup dada dari bagian atas, buatlah dua rantai dari emas murni yang dijalin seperti tali, beserta dua cincin emas. Cincin yang satu dijahit pada pojok kiri atas penutup dada, dan cincin yang satunya lagi dijahit pada pojok kanan atas. Kedua rantai emas itu disambungkan kepada masing-masing cincin untuk mengikat penutup dada itu pada kedua bingkai emas di penutup bahu efod. ");
INSERT INTO ind_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","27","Sebagai penahan bagian bawah, buatlah empat cincin emas lagi. Satu cincin dijahit pada pojok kiri bawah penutup dada, dan satu lagi pada pojok kanan bawah, di bagian dalam yang berdekatan dengan efod. Dua cincin emas lainnya dijahit pada bagian depan efod, di sebelah kiri dan kanan, posisinya di antara bagian bawah penutup bahu dan sambungan ikat pinggang. ");
INSERT INTO ind_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ikatkan kedua cincin di sisi kiri, yaitu cincin pada efod dan cincin pada penutup dada, dengan tali biru. Lakukan hal yang sama pada sisi kanan. Dengan demikian, penutup dada tidak bergantung lepas ketika Harun membungkuk. ");
INSERT INTO ind_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Setiap kali Harun masuk ke ruang kudus, dia harus selalu memakai penutup dada itu. Dengan begitu, dia akan senantiasa membawa nama-nama suku Israel di dekat jantungnya, dan Aku akan selalu diingatkan bahwa Harun mewakili seluruh umat-Ku. ");
INSERT INTO ind_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kedua alat yang akan digunakan untuk mengetahui kehendak-Ku, yaitu Urim dan Tumim, ditaruh di dalam penutup dada itu agar benda-benda tersebut selalu berada di dekat jantung Harun ketika dia menghadap Aku untuk mengetahui kehendak-Ku bagi umat Israel.” ");
INSERT INTO ind_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Jubah Harun yang akan dipakai di bawah efod itu harus ditenun seluruhnya dari benang warna biru. ");
INSERT INTO ind_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Tenunlah jubah itu dengan kerah yang tebal agar tidak mudah robek. ");
INSERT INTO ind_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Pada ujung bawah jubah, tenunlah hiasan-hiasan berbentuk buah delima dari benang warna merah, biru, dan ungu. Pasanglah lonceng-lonceng emas berselang-seling dengan hiasan-hiasan itu. ");
INSERT INTO ind_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harun wajib memakai jubah ini setiap kali memasuki ruang kudus untuk melayani Aku, dan lonceng-loncengnya akan berbunyi setiap kali dia masuk dan keluar dari hadirat-Ku. Hal ini adalah kewajiban bagi Harun dan anak-anaknya yang menjadi imam besar, karena siapa pun yang melanggar ketentuan ini akan Aku hukum mati.” ");
INSERT INTO ind_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Buatlah medali untuk serban Harun dari emas murni, yang diukir dengan kata-kata ‘Kudus bagi TUHAN’. Ukiran itu haruslah dibuat dengan cara seperti perajin mengukir cap meterai. ");
INSERT INTO ind_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Medali ini diikatkan di bagian depan serban dengan tali warna biru. ");
INSERT INTO ind_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Setiap kali Harun mempersembahkan sesuatu yang diberikan orang Israel kepada-Ku, dia harus memakai medali ini pada dahinya sebagai tanda bahwa Aku menganggap kudus persembahan itu, meskipun terjadi kesalahan dalam cara umat Israel memberi persembahan itu. Dengan demikian, Aku akan berkenan kepada umat-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Baju panjang untuk Harun harus ditenun dari benang linen yang berkualitas tinggi dengan pola berwarna-warni. Serban dan ikat pinggangnya juga ditenun dengan cara yang sama. ");
INSERT INTO ind_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Bagi anak-anak Harun, buatlah baju panjang, ikat pinggang, dan ikat kepala. Pakaian mereka melambangkan kehormatan dan kemuliaan sebagai imam. ");
INSERT INTO ind_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","43","Harun dan anak-anaknya juga akan membutuhkan celana dalam dari kain linen, dengan panjang dari pinggang sampai paha. Mereka harus memakai celana itu saat mereka memasuki ruang kudus di kemah-Ku, atau saat melaksanakan pelayanan di mezbah kurban di halaman kemah-Ku. Hal ini adalah kewajiban bagi Harun dan anak-anaknya, karena siapa pun yang melanggar ketentuan ini akan Aku hukum mati. “Ketika segala macam pakaian itu sudah siap, urapi dan tahbiskanlah Harun serta anak-anaknya, agar mereka dikhususkan dan dikuduskan menjadi imam yang melayani-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","TUHAN berkata kepada Musa, “Harun dan anak-anaknya harus ditahbiskan sebagai imam agar mereka bisa melayani Aku. Untuk upacara pentahbisan itu, siapkanlah keperluan ini: Seekor sapi jantan muda dan dua ekor domba jantan. Ketiganya haruslah yang tidak ada cacat. ");
INSERT INTO ind_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Dari tepung terbaik, buatlah tiga macam roti yang tidak beragi, yakni roti tanpa minyak zaitun, roti yang mengandung minyak zaitun, dan roti tipis kering yang diolesi minyak zaitun setelah dibakar. ");
INSERT INTO ind_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Taruhlah semua roti itu di dalam sebuah bakul untuk dipersembahkan kepada-Ku bersama sapi jantan muda dan kedua domba jantan tadi. ");
INSERT INTO ind_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Lalu bawalah Harun dan anak-anaknya ke depan pintu kemah-Ku dan lakukanlah upacara pembasuhan bagi mereka. Dalam upacara itu kamu harus membasuh mereka masing-masing dengan air. ");
INSERT INTO ind_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kemudian ambillah pakaian yang sudah disiapkan, yaitu jubah, baju panjang, efod, dan penutup dada. Kenakanlah semuanya kepada Harun, dan ikatkanlah ikat pinggang tenun pada efod yang sudah dikenakannya. ");
INSERT INTO ind_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Lilitkanlah serban di kepalanya, dan pasanglah pada serban itu medali emas yang sudah diukir dengan tulisan ‘Kudus bagi TUHAN’. ");
INSERT INTO ind_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Sesudah itu urapilah dia dengan menuangkan minyak pengurapan di kepalanya. ");
INSERT INTO ind_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Suruhlah juga anak-anaknya mendekat, lalu kenakanlah baju-baju panjang yang sudah disiapkan itu pada mereka. ");
INSERT INTO ind_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Pasanglah ikat pinggang dan ikat kepala pada mereka masing-masing.” “Berikut ini adalah ketetapan mengenai tata cara pentahbisan Harun dan anak-anaknya. Upacara ini juga harus dilakukan secara turun-temurun untuk setiap keturunan mereka yang akan melayani Aku sebagai imam: ");
INSERT INTO ind_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","11","Bawalah sapi jantan tadi ke depan gerbang kemah-Ku, lalu suruhlah Harun dan anak-anaknya meletakkan tangan mereka di atas kepala sapi itu. Sembelihlah sapi itu di hadapan-Ku, di tempat itu juga. ");
INSERT INTO ind_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ambillah sebagian darahnya, lalu oleskan pada tanduk-tanduk mezbah dengan jarimu. Sisa darah itu harus kamu tuangkan ke bagian bawah mezbah. ");
INSERT INTO ind_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Sesudah itu ambillah semua lemak yang menutupi isi perutnya bagian bawah hati, dan kedua ginjal beserta lemaknya. Bakarlah semua itu di atas mezbah sebagai persembahan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Tetapi daging, kulit, dan kotorannya, harus kamu bakar di luar perkemahan. Begitulah cara mempersembahkan kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Kemudian ambillah salah satu dari kedua domba jantan, dan suruhlah Harun serta anak-anaknya meletakkan tangan mereka di atas kepala domba itu. ");
INSERT INTO ind_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Lalu sembelihlah domba itu, ambil darahnya, dan siramkan dengan kuat pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Potonglah domba utuh itu menjadi beberapa bagian dan cucilah semua bagian dalamnya serta kakinya. Letakkan semuanya itu di samping kepala dan bagian tubuh lainnya. ");
INSERT INTO ind_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Bakarlah semua itu di atas mezbah. Begitulah cara mempersembahkan kurban yang dibakar habis, yang bau harumnya akan menyenangkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Kemudian ambillah domba jantan yang satunya lagi, yang khusus untuk mentahbiskan mereka. Suruhlah Harun dan anak-anaknya meletakkan tangan mereka di atas kepala domba itu. ");
INSERT INTO ind_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Lalu sembelihlah domba itu, ambil sedikit darahnya, dan oleskanlah pada telinga kanan Harun dan masing-masing anaknya, juga pada ibu jari tangan kanan dan ibu jari kaki kanan mereka. Sisa darah domba itu harus kamu siramkan dengan kuat pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ambillah sedikit darah dari mezbah itu dan campurkan dengan minyak pengurapan. Lalu percikkan kepada Harun dan anak-anaknya, juga pada pakaian mereka. Dengan cara inilah mereka serta pakaian mereka dikuduskan bagi pelayanan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Selanjutnya, ambillah bagian yang berlemak dari domba jantan, lemak yang melapisi bagian ekor, dan lemak yang menutupi isi perut. Ambillah juga bagian bawah hati, kedua ginjal beserta lemak yang menutupinya, dan paha kanannya, karena domba ini untuk pentahbisan. Letakkanlah semua itu di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Dari bakul roti yang sudah ditempatkan di hadapan-Ku, ambillah satu roti yang tanpa minyak zaitun, satu roti yang mengandung minyak zaitun, dan satu roti tipis kering yang diolesi minyak zaitun setelah dibakar. ");
INSERT INTO ind_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kamu harus menaruh semuanya itu ke tangan Harun dan anak-anaknya, dan memerintahkan mereka untuk mengangkatnya tinggi sebagai persembahan khusus kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Setelah itu, ambillah semua roti itu kembali dan bakarlah di atas mezbah bersama kurban yang dibakar habis. Bau harumnya saat dibakar akan menyenangkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kemudian ambillah dada domba jantan yang digunakan untuk mentahbiskan Harun, dan angkatlah tinggi sebagai persembahan khusus kepada-Ku. Musa, inilah bagian yang boleh kamu makan. ");
INSERT INTO ind_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Pisahkanlah bagian-bagian yang akan menjadi milik Harun dan anak-anaknya, yaitu dada dan paha domba yang digunakan untuk pentahbisan mereka, yang diangkat tinggi sebagai persembahan khusus. ");
INSERT INTO ind_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Untuk seterusnya, setiap kali umat Israel mempersembahkan kurban tanda damai, bagian itu harus dipisahkan untuk Harun dan keturunannya. Umat Israel wajib mempersembahkan bagian tersebut kepada-Ku dengan memberikannya kepada mereka. ");
INSERT INTO ind_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Pakaian Harun, yang dikhususkan bagi pelayanan bagi-Ku, akan menjadi milik keturunannya. Kelak mereka akan memakai pakaian ini ketika diurapi dan ditahbiskan. ");
INSERT INTO ind_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Anak Harun, yang akan menggantikan ayahnya, harus memakai pakaian ini selama tujuh hari ketika dia masuk ke ruang kudus di kemah-Ku untuk melaksanakan berbagai tugas imam sesuai ketetapan-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Dari domba jantan pentahbisan itu, ambillah semua bagian daging yang dikhususkan untuk kalian makan, dan rebuslah daging itu di tempat yang kudus. ");
INSERT INTO ind_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Daging domba itu beserta roti di dalam bakul haruslah dimakan Harun dan anak-anaknya di pintu masuk kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Hanya mereka yang boleh memakan daging dan roti yang dipakai untuk menghapus dosa-dosa mereka dan mengkhususkan mereka bagi-Ku pada upacara pentahbisan. Orang lain tidak boleh memakannya, karena makanan ini suci dan dikhususkan bagi acara pentahbisan. ");
INSERT INTO ind_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Apabila keesokan paginya masih ada daging atau roti yang tersisa, maka sisanya harus dibakar dan tidak boleh dimakan oleh siapa pun, karena makanan ini suci dan dikhususkan bagi acara pentahbisan. ");
INSERT INTO ind_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Semua langkah tersebut harus diulangi setiap hari selama tujuh hari upacara pentahbisan Harun dan anak-anaknya, tepat seperti yang Aku sudah perintahkan. ");
INSERT INTO ind_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Setiap hari selama tujuh hari itu, persembahkanlah seekor sapi jantan muda untuk menghapus dosa-dosa mereka. Melalui kurban itu, mezbah kurban juga ikut dikuduskan. Kemudian, setiap hari selama tujuh hari itu kamu juga harus mengoleskan minyak pengurapan pada setiap tanduk mezbah sebagai tanda bahwa mezbah itu sudah dikhususkan untuk pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Upacara itu harus diulangi setiap hari selama tujuh hari, supaya mezbah dikuduskan sempurna untuk pelayanan bagi-Ku, sehingga apa pun yang menyentuh mezbah itu menjadi kudus. ");
INSERT INTO ind_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Yang harus dipersembahkan setiap hari di atas mezbah adalah dua ekor anak domba jantan berumur satu tahun. ");
INSERT INTO ind_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Persembahkanlah seekor pada pagi hari dan yang lainnya pada sore hari. ");
INSERT INTO ind_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Bersama anak domba yang pertama, persembahkan juga tiga liter tepung terigu terbaik dicampur dengan satu liter minyak zaitun terbaik. Siramkan juga satu liter anggur sebagai persembahan curahan. ");
INSERT INTO ind_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Pada sore hari, persembahkanlah domba kedua bersama persembahan gandum-ganduman dan persembahan curahan dengan takaran yang sama seperti persembahan pagi. Bau harum persembahan ini akan menyenangkan bagi-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Kemudian TUHAN berbicara kepada Musa, “Mulai sekarang dan seterusnya secara turun temurun, kedua persembahan harian itu akan dilaksanakan bagi umat Israel di pintu gerbang halaman kemah-Ku, karena di situlah Aku akan bertemu dengan umat-Ku dan berbicara kepadamu maupun penggantimu nanti. ");
INSERT INTO ind_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Di situ Aku akan menemui umat Israel, dan tempat itu akan menjadi kudus karena kemuliaan-Ku. ");
INSERT INTO ind_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Aku akan menguduskan kemah-Ku dan mezbahnya. Aku akan mengkhususkan Harun dan anak-anaknya supaya mereka bisa bertugas sebagai imam. ");
INSERT INTO ind_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Aku akan tinggal di antara umat Israel dan menjadi Allah mereka. ");
INSERT INTO ind_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Mereka akan tahu bahwa Akulah TUHAN, Allah mereka yang sudah membawa mereka keluar dari Mesir supaya Aku dapat tinggal bersama mereka. Akulah TUHAN Allah mereka.” ");
INSERT INTO ind_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","TUHAN berkata kepada Musa, “Buatlah sebuah mezbah dari kayu akasia untuk membakar dupa. ");
INSERT INTO ind_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Mezbah ini berbentuk persegi, dengan panjang setiap sisinya 45 sentimeter. Tingginya 90 sentimeter. Di setiap sudut atas, buatlah bentuk seperti tanduk sapi yang dipahat sekaligus dengan kayu mezbah itu. ");
INSERT INTO ind_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lapisilah seluruhnya dengan emas murni, termasuk bagian atas mezbah, keempat sisinya, dan tanduk-tanduknya. Buatlah juga bingkai emas di sekelilingnya. ");
INSERT INTO ind_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Untuk mengusung, buatlah dua buah gelang emas dan pasangkan di bawah bingkainya, di tengah-tengah dua sisi yang berseberangan. Tongkat pengusung akan dimasukkan ke dalam gelang-gelang itu. ");
INSERT INTO ind_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tongkat pengusung itu juga harus dibuat dari kayu akasia dan dilapisi dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Letakkan mezbah dupa itu di luar tirai yang menutupi ruang mahakudus. Ruang mahakudus adalah tempat Aku akan bertemu denganmu atau imam besar, ketika dia melayani-Ku di depan Takhta Pendamaian. ");
INSERT INTO ind_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Haruslah Harun membakar dupa yang harum di mezbah itu setiap pagi, saat dia membereskan sumbu pelita-pelita, ");
INSERT INTO ind_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","dan setiap sore, saat dia menyalakan pelita-pelita. Lakukanlah persembahan dupa ini di hadapan TUHAN secara rutin dan turun temurun. ");
INSERT INTO ind_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Dupa yang dipersembahkan di mezbah itu haruslah yang dibuat khusus untuk keperluan kemah-Ku. Jangan menggunakan mezbah itu untuk mempersembahkan hal lain, termasuk kurban sembelihan, gandum-ganduman, maupun air anggur. ");
INSERT INTO ind_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“Setahun sekali, yaitu pada Hari Pendamaian, Harun harus mengoleskan sedikit darah kurban itu pada tanduk-tanduk mezbah dupa. Upacara ini harus dilakukan secara turun temurun, karena dengan cara demikian mezbah ini dikuduskan untuk pelayanan bagi-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Waktu kamu mengadakan sensus untuk menghitung jumlah umat Israel, saat penghitungan dilakukan, setiap laki-laki harus membayar uang pendamaian untuk menebus hidupnya di mata-Ku. Dengan tebusan itu, Aku tidak akan menghukum umat-Ku dengan wabah penyakit karena sensus tersebut. ");
INSERT INTO ind_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Setiap laki-laki yang ikut dihitung pada sensus itu harus membayar enam gram perak sebagai persembahan kepada TUHAN. Pembayaran ini ditimbang sesuai pengukur berat yang sah, yaitu syikal yang tersimpan di kemah TUHAN. Satu syikal sama dengan 12 gram. ");
INSERT INTO ind_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Setiap laki-laki yang berumur 20 tahun ke atas harus dihitung dalam sensus dan harus membayar persembahan ini kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Baik orang kaya maupun orang miskin harus membayar jumlah yang sama, untuk mengadakan pendamaian bagi hidup mereka di mata-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Musa, kamu akan menerima uang pendamaian yang dibayar oleh bangsa Israel. Gunakanlah dalam pelayanan di kemah-Ku. Dengan demikian, Aku akan berkenan kepada umat Israel dan menganggap setiap orang sudah berdamai dengan-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Buatlah bejana air untuk pembasuhan lengkap dengan tumpuannya. Keduanya harus dibuat dari perunggu. Letakkan bejana ini di antara mezbah dan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harun serta anak-anaknya akan membasuh tangan dan kaki mereka dengan air itu. ");
INSERT INTO ind_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","Mereka harus membasuh tangan dan kaki dengan air itu ketika hendak memasuki kemah-Ku, atau ketika mendekati mezbah untuk membakar persembahan bagi-Ku. Pembasuhan ini adalah kewajiban bagi mereka, agar mereka tidak mati saat melaksanakan tugas. Hal ini menjadi ketetapan bagi Harun dan keturunannya secara turun temurun sampai selamanya.” ");
INSERT INTO ind_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Buatlah minyak pengurapan dari wangi-wangian yang terbaik berupa: minyak mur sebanyak 6 kilogram kayu manis sebanyak 3 kilogram, batang serai sebanyak 3 kilogram, ");
INSERT INTO ind_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","minyak zaitun sebanyak 4 liter, kayu teja sebanyak 6 kilogram. Semua itu ditimbang sesuai pengukur berat yang sah yang tersimpan di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Dari bahan-bahan itu, buatlah minyak pengurapan dengan cara seperti yang dilakukan oleh ahli pembuat minyak wangi. Minyak ini suci dan hanya boleh digunakan dalam pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Dengan minyak inilah kamu akan mengurapi kemah-Ku, peti perjanjian, ");
INSERT INTO ind_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","meja dengan segala peralatannya, tiang pelita dengan segala peralatannya, mezbah dupa, ");
INSERT INTO ind_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mezbah kurban dengan segala peralatannya, dan bejana pembasuhan dari perunggu serta tumpuannya. ");
INSERT INTO ind_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Urapilah semuanya itu agar menjadi kudus, sehingga apa pun yang menyentuhnya juga dikuduskan untuk pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Urapilah Harun dan anak-anaknya dengan minyak itu, agar mereka dikhususkan untuk melayani sebagai imam. ");
INSERT INTO ind_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Kamu harus mengatakan kepada umat Israel, ‘Sesuai perintah TUHAN, kita akan senantiasa menganggap minyak pengurapan ini sangat kudus dan hanya digunakan untuk pelayanan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Minyak ini tidak boleh dioleskan pada tubuh orang biasa, dan kalian tidak boleh membuat minyak yang campurannya serupa dengan minyak ini. Minyak ini khusus untuk pelayanan bagi TUHAN, dan kalian harus memperlakukannya sebagai sesuatu yang kudus. ");
INSERT INTO ind_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Siapa pun yang membuat minyak dengan campuran serupa, atau mengoleskannya kepada seseorang yang bukan imam, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.’” ");
INSERT INTO ind_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","TUHAN berkata kepada Musa, “Buatlah dupa dengan wangi-wangian berikut ini: getah damar, kulit lokan, getah rasamala, kemenyan murni, masing-masing dengan jumlah yang sama. ");
INSERT INTO ind_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Campurkan semua itu menjadi dupa, seperti buatan seorang ahli pencampur dupa. Dupa itu harus dicampur dengan garam. Biarlah campuran ini selalu murni dan dianggap kudus. ");
INSERT INTO ind_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tumbuklah sedikit dari dupa itu sampai sangat halus dan letakkan di depan peti perjanjian. Itulah tempat di mana Aku akan bertemu denganmu atau imam besar yang bertugas di dalam kemah-Ku. Dupa itu harus selalu dianggap kudus dan hanya boleh dipakai untuk pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Kalian tidak boleh membuat campuran dupa yang sama untuk diri sendiri. Dupa ini dikhususkan bagi penyembahan-Ku, dan kalian harus memperlakukannya sebagai sesuatu yang kudus. ");
INSERT INTO ind_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Siapa pun yang membuat dupa yang serupa dengan itu bagi dirinya sendiri dan untuk menikmati wanginya, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Untuk memimpin semua tugas dalam pembuatan kemah-Ku, Aku sudah memilih Bezalel dari suku Yehuda. Dia adalah anak Uri dan cucu Hur. ");
INSERT INTO ind_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Aku sudah memenuhi Bezalel dengan Roh-Ku dan memberi dia kebijaksanaan, kepandaian, serta kemampuan dalam segala bidang kerajinan, ");
INSERT INTO ind_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","termasuk pembuatan rancangan dari emas, perak, dan perunggu, ");
INSERT INTO ind_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","pemotongan dan pemasangan batu permata, pemahatan kayu, serta segala macam kerajinan lainnya. ");
INSERT INTO ind_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Aku juga sudah memilih Aholiab anak Ahisamak, dari suku Dan, untuk membantu pekerjaannya. Kepada semua perajin di antara umat Israel, Aku sudah memberikan kemampuan untuk membuat semua yang Aku perintahkan kepadamu: ");
INSERT INTO ind_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Kemah-Ku, peti perjanjian, penutupnya yang disebut Takhta Pendamaian, dan segala perlengkapan untuk kemah itu, ");
INSERT INTO ind_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meja dengan segala peralatannya, tiang pelita emas murni dengan segala peralatannya, mezbah dupa, ");
INSERT INTO ind_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","mezbah kurban beserta peralatannya, bejana pembasuhan dan tumpuannya, ");
INSERT INTO ind_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","pakaian imam yang indah, yang akan dikhususkan bagi Harun dan anak-anaknya ketika mereka bertugas melayani sebagai imam, ");
INSERT INTO ind_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","minyak pengurapan, dan dupa untuk ruang kudus. Mereka harus membuat semuanya itu sesuai dengan perintah-Ku.” ");
INSERT INTO ind_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Katakanlah kepada umat Israel, ‘Setiap orang di antara kalian harus menaati peraturan tentang hari Sabat. Karena Aku sudah menetapkan hari Sabat sebagai penanda secara turun temurun bahwa kamu menaati perjanjian antara Aku dan kamu. Dengan demikian, kamu akan mengingat bahwa Akulah TUHAN yang menguduskanmu. ");
INSERT INTO ind_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Taatilah segala peraturan yang Aku buat tentang hari Sabat dan anggaplah hari itu kudus senantiasa. Siapa pun yang menodai kekudusan Sabat dengan bekerja pada hari itu, dia harus dimusnahkan dari antara umat Israel dengan hukuman mati. ");
INSERT INTO ind_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Selama enam hari kamu boleh bekerja, tetapi hari yang ketujuh adalah hari Sabat, yaitu hari peristirahatan penuh yang dikhususkan bagi-Ku. Siapa pun yang tetap bekerja pada hari Sabat akan dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Umat Israel harus tetap menjaga hari Sabat dan menaatinya secara turun-temurun sampai selamanya. ");
INSERT INTO ind_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Karena, selama enam hari Aku menciptakan surga, langit, dan bumi, lalu pada hari yang ketujuh Aku berhenti bekerja dan beristirahat. Itulah sebabnya hari Sabat menjadi tanda perjanjian antara Aku dengan kalian umat Israel untuk selamanya.’” ");
INSERT INTO ind_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Setelah TUHAN berbicara kepada Musa di gunung Sinai, TUHAN memberikan dua lempengan batu kepadanya, yaitu lempengan berisi perintah-perintah yang ditulis oleh jari Allah. ");
INSERT INTO ind_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ketika orang-orang melihat bahwa Musa lama sekali tidak turun dari gunung, mereka bersama-sama datang kepada Harun dan berkata, “Kita tidak tahu apa yang terjadi dengan si Musa itu, yang sudah menghasut kita keluar dari Mesir! Karena itu ayolah, buatkan patung dewa bagi kami untuk memimpin kita!” ");
INSERT INTO ind_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Jawab Harun “Ambillah anting-anting emas dari istri-istrimu dan anak-anakmu, lalu bawalah kepadaku.” ");
INSERT INTO ind_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Maka semua orang melepaskan anting-anting emas mereka dan membawanya kepada Harun. ");
INSERT INTO ind_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kemudian Harun mengambil barang-barang emas itu dan dia melebur, membentuk, serta memahatnya menjadi patung berbentuk anak sapi. Melihat patung itu, umat pun saling berkata, “Hai umat Israel, inilah dewa kita yang sudah membawa kita keluar dari Mesir!” ");
INSERT INTO ind_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ketika Harun melihat bahwa umat merasa senang, dia mendirikan mezbah di depan patung anak sapi itu dan berkata kepada mereka, “Besok kita akan mengadakan perayaan bagi TUHAN!” ");
INSERT INTO ind_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Keesokan harinya mereka bangun pagi-pagi untuk mempersembahkan kurban yang dibakar habis dan kurban tanda damai kepada patung itu. Lalu mereka makan dan minum serta berpesta pora. ");
INSERT INTO ind_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Berkatalah TUHAN kepada Musa, “Segeralah turun! Umat yang kamu bawa keluar dari Mesir sudah menajiskan diri! ");
INSERT INTO ind_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mereka cepat sekali menyimpang dari jalan yang Aku perintahkan. Mereka sudah membuat patung berhala berbentuk anak sapi, lalu bersujud kepadanya dan mempersembahkan kurban baginya. Mereka berkata, ‘Hai umat Israel, inilah dewa yang sudah membawa kita keluar dari Mesir!’” ");
INSERT INTO ind_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Kata TUHAN lagi, “Aku sudah melihat betapa keras kepalanya umat ini. ");
INSERT INTO ind_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sekarang, biarlah Aku melepaskan murka-Ku terhadap mereka dan menghanguskan mereka! Kemudian Aku akan membuat kamu menjadi suatu bangsa yang besar!” ");
INSERT INTO ind_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tetapi Musa memohon kepada TUHAN Allahnya, “Janganlah Engkau menghanguskan mereka dengan murka-Mu! Ingatlah bahwa mereka itu umat-Mu, yang Engkau bawa keluar dari Mesir dengan kuasa dan kekuatan-Mu. ");
INSERT INTO ind_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Jangan sampai orang Mesir berkata, ‘TUHAN membawa umat Israel keluar dari Mesir dengan maksud jahat, supaya Dia membunuh mereka di pegunungan dan membinasakan mereka dari muka bumi.’ Ya TUHAN, mohon redakanlah murka-Mu, batalkan niat-Mu, dan jangan binasakan umat-Mu! ");
INSERT INTO ind_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ingatlah kepada hamba-hamba-Mu, Abraham, Isak, dan Yakub. Engkau sudah bersumpah demi diri-Mu sendiri dan berkata kepada mereka, ‘Aku akan membuat keturunanmu sebanyak bintang-bintang di langit. Aku akan memberikan semua tanah ini yang sudah Aku janjikan kepada keturunanmu dan mereka akan memiliki tanah itu selamanya.’” ");
INSERT INTO ind_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Maka TUHAN membatalkan niat untuk membinasakan umat-Nya. ");
INSERT INTO ind_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kemudian Musa berbalik dan turun dari gunung sambil memegang dua lempengan batu yang bertuliskan perintah-perintah Allah pada sisi depan dan belakangnya. Perintah-perintah itu adalah kewajiban utama bagi umat Israel dalam perjanjian mereka dengan Allah. ");
INSERT INTO ind_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kedua lempengan batu itu adalah karya Allah. Dia sendirilah yang menuliskan perintah-perintah pada kedua lempengan tersebut. ");
INSERT INTO ind_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosua mendengar suara keramaian umat di bawah dan dia berkata kepada Musa, “Sepertinya ada peperangan di perkemahan!” ");
INSERT INTO ind_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Jawab Musa, “Bukan! Itu bukan suara sorak kemenangan ataupun tangisan kekalahan. Aku mendengar suara nyanyian.” ");
INSERT INTO ind_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ketika Musa sudah dekat dengan perkemahan itu, dia pun melihat patung anak sapi emas dan orang-orang sedang menari-nari. Maka sangat marahlah Musa. Dia melemparkan kedua lempengan batu di tangannya ke tanah di kaki gunung itu sehingga hancur. ");
INSERT INTO ind_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Musa mengambil patung anak sapi emas yang mereka buat, dan bersama beberapa orang lain dia meleburnya ke dalam api, menumbuknya sampai halus seperti debu, dan menaburkannya ke atas air. Kemudian Musa menyuruh umat Israel meminum air itu. ");
INSERT INTO ind_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Setelah itu, Musa memarahi Harun, katanya, “Apa yang sudah dilakukan umat ini kepadamu sehingga kamu memimpin mereka melakukan dosa yang sangat besar?!” ");
INSERT INTO ind_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harun berkata, “Janganlah marah, Tuanku. Tuan sendiri tahu betapa jahatnya bangsa ini. ");
INSERT INTO ind_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mereka berkata kepadaku, ‘Buatkanlah bagi kami patung dewa untuk memimpin kita. Kita tidak tahu apa yang terjadi kepada Musa itu, orang yang sudah menghasut kita keluar dari Mesir.’ ");
INSERT INTO ind_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Maka saya berkata kepada mereka, ‘Lepaskanlah anting-anting emas kalian dan bawalah ke sini.’ Lalu mereka memberikannya kepadaku. Sesudah itu, aku melemparkan emas itu ke dalam api, dan jadilah patung ini!” ");
INSERT INTO ind_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa melihat bahwa umat Israel sudah hilang kendali dan Harun tidak berusaha mengendalikan mereka sehingga mereka dapat ditertawakan oleh musuh. ");
INSERT INTO ind_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Maka dia berdiri di depan pintu masuk perkemahan dan berkata, “Setiap orang yang berpihak kepada TUHAN, kemari dan bergabunglah dengan saya!” Lalu datanglah semua orang Lewi mengelilinginya. ");
INSERT INTO ind_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Musa berkata kepada mereka, “TUHAN Allah Israel berkata, ‘Ambillah pedangmu masing-masing dan berjalanlah dari ujung perkemahan ke ujung yang lain. Bunuhlah saudaramu, temanmu, dan tetanggamu yang sudah terlibat dalam penyembahan berhala ini!’” ");
INSERT INTO ind_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Orang-orang Lewi melakukan seperti yang diperintahkan Musa, dan hari itu juga sekitar tiga ribu orang mati terbunuh. ");
INSERT INTO ind_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa berkata, “Hari ini kamu masing-masing sudah mengkhususkan diri untuk melayani TUHAN dengan menaati perintah-Nya, meskipun kamu harus membunuh anak-anakmu dan saudara-saudaramu sendiri. Oleh karena tindakanmu itu, TUHAN akan memberkatimu.” ");
INSERT INTO ind_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Keesokan harinya Musa berkata kepada bangsa Israel, “Kalian sudah melakukan dosa besar! Tetapi saya akan naik untuk menghadap TUHAN dan meminta pendamaian atas dosamu.” ");
INSERT INTO ind_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Lalu kembalilah Musa menghadap TUHAN dan berkata, “Bangsa ini sudah berbuat dosa besar. Mereka membuat patung dewa emas untuk disembah. ");
INSERT INTO ind_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Tetapi aku mohon ampunilah dosa mereka. Jika tidak, maka biarlah namaku juga dihapuskan dari kitab yang berisi daftar nama-nama umat-Mu.” ");
INSERT INTO ind_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tetapi TUHAN berkata kepada Musa, “Tidak! Yang Aku hapuskan dari kitab itu hanyalah orang yang berdosa terhadap-Ku. ");
INSERT INTO ind_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sekarang pergilah, pimpinlah mereka ke tempat yang sudah Aku beritahukan kepadamu. Malaikat yang mewakili Aku akan berjalan di depanmu. Namun, akan tiba saatnya Aku menghukum mereka atas dosa mereka!” ");
INSERT INTO ind_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kemudian TUHAN mendatangkan wabah penyakit pada bangsa Israel karena mereka sudah mendesak Harun untuk membuat patung tadi. ");
INSERT INTO ind_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","TUHAN berkata kepada Musa, “Pergilah dari tempat ini bersama umat yang sudah kamu bawa keluar dari negeri Mesir. Lanjutkanlah perjalanan ke negeri yang sudah Aku janjikan dengan bersumpah kepada Abraham, Isak, dan Yakub untuk memberikannya kepada keturunan mereka. ");
INSERT INTO ind_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Aku akan mengutus malaikat itu berjalan di depan kalian, dan Aku akan mengusir orang-orang Kanaan, Amori, Het, Feris, Hewi, dan Yebus. ");
INSERT INTO ind_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pergilah ke negeri yang berlimpah dengan hasil alam itu, tetapi Aku tidak akan berjalan bersama kalian. Kalian adalah bangsa yang keras kepala dan tidak taat kepada-Ku. Jika Aku pergi bersama kalian, mungkin saja Aku akan marah dan membinasakan kalian di jalan.” ");
INSERT INTO ind_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","Lalu TUHAN berkata kepada Musa, “Katakanlah kepada umat Israel, ‘Kalian adalah bangsa yang keras kepala dan tidak taat. Apabila Aku berjalan bersama kalian sesaat saja, Aku dapat membinasakan kalian. Sekarang lepaslah semua perhiasan di tubuhmu. Aku akan memutuskan apa yang akan Aku lakukan terhadap kalian.’” Mendengar kabar buruk itu, bangsa Israel sangat sedih dan berkabung. Tidak seorang pun memakai perhiasannya. ");
INSERT INTO ind_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Sejak dari gunung Sinai itu, umat Israel tidak lagi mengenakan perhiasan. ");
INSERT INTO ind_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Selama ini, tiap kali bangsa Israel berkemah di suatu tempat, Musa mendirikan sebuah kemah di luar, jauh dari perkemahan. Musa menyebutnya Kemah Pertemuan. Siapa pun yang ingin mencari kehendak TUHAN bisa datang ke kemah itu. ");
INSERT INTO ind_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Setiap kali Musa pergi ke Kemah Pertemuan, seluruh umat Israel bangkit lalu berdiri di depan pintu kemah mereka masing-masing dan memperhatikan Musa sampai dia masuk ke dalam kemah itu. ");
INSERT INTO ind_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Sewaktu Musa berada di dalam, tiang awan selalu turun dan berdiri di depan pintu kemah itu sementara TUHAN berbicara dengan Musa. ");
INSERT INTO ind_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ketika seluruh umat melihat tiang awan berdiri di depan pintu kemah itu, mereka berdiri lalu sujud menyembah kepada TUHAN dari pintu kemah mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Di dalam kemah itu, TUHAN berbicara kepada Musa secara langsung, sebagaimana seseorang berbicara kepada temannya. Dan ketika Musa kembali ke perkemahan, Yosua anak Nun tetap tinggal di Kemah Pertemuan. Yosua adalah seorang muda, tangan kanan Musa. ");
INSERT INTO ind_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa berkata kepada TUHAN, “Engkau menyuruhku untuk membawa umat ini ke negeri yang Engkau janjikan. Tetapi Engkau belum memberitahukan kepadaku siapa yang akan Engkau utus bersamaku. Namun, Engkau pernah berkata, ‘Aku mengenalmu dan berkenan kepadamu.’ ");
INSERT INTO ind_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Karena itu, ya TUHAN, aku memohon, apabila aku sungguh berkenan di mata-Mu, perkenalkanlah diri-Mu lebih dalam kepadaku, agar aku dapat semakin mengenal Engkau dan terus melakukan yang berkenan kepada-Mu. Ingatlah bahwa bangsa ini adalah umat-Mu.” ");
INSERT INTO ind_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Lalu TUHAN menjawab, “Aku sendiri akan menyertaimu dan memberikan kelegaan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Lagi kata Musa, “Jika Engkau tidak menyertai kami, janganlah suruh kami berangkat dari sini. ");
INSERT INTO ind_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bagaimana bangsa-bangsa lain bisa tahu bahwa Engkau berkenan kepada kami jika Engkau tidak menyertai kami? Justru yang membedakan kami dari semua bangsa lain di bumi adalah kehadiran-Mu bersama kami!” ");
INSERT INTO ind_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Jawab TUHAN kepada Musa, “Aku akan mengabulkan permintaanmu, karena Aku berkenan kepadamu dan mengenalmu.” ");
INSERT INTO ind_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Lalu Musa berkata, “Aku mohon, tunjukkanlah kepadaku pancaran kemuliaan-Mu.” ");
INSERT INTO ind_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kata TUHAN, “Aku akan memperlihatkan kepadamu seluruh kebaikan-Ku sambil menyatakan arti nama-Ku, yaitu ‘Akulah TUHAN. Aku akan berbaik hati dan berbelas kasihan kepada siapa pun yang Aku inginkan.’ ");
INSERT INTO ind_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Namun, kamu tidak akan melihat wajah-Ku, sebab tidak seorang pun yang memandang-Ku dapat tetap hidup. ");
INSERT INTO ind_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tetapi lihat! Berdirilah di atas gunung batu ini di dekat-Ku. ");
INSERT INTO ind_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ketika kemuliaan-Ku lewat, Aku akan menempatkan kamu di celah batu ini dan menutupi kamu dengan tangan-Ku sampai Aku sudah lewat. ");
INSERT INTO ind_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Lalu Aku akan menarik tangan-Ku, dan kamu akan dapat melihat Aku dari belakang, tetapi wajah-Ku tidak akan kamu lihat.” ");
INSERT INTO ind_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Lalu TUHAN berkata kepada Musa, “Pahatlah dua lempengan batu yang baru, seperti kedua lempengan yang sudah kamu hancurkan. Aku akan menuliskan pada lempengan baru itu kata-kata yang sama seperti sebelumnya. ");
INSERT INTO ind_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Besok pagi, kamu harus sudah siap untuk naik ke gunung Sinai dengan membawa kedua lempengan itu. Berdirilah di hadapan-Ku di puncak gunung itu. ");
INSERT INTO ind_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tidak seorang pun boleh ikut ke atas bersamamu atau berada di mana pun di sekitar gunung itu, bahkan kawanan domba dan sapi tidak boleh merumput di dekat gunung.” ");
INSERT INTO ind_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Maka Musa memahat dua lempengan batu seperti yang pertama. Keesokan harinya, pagi-pagi sekali dia membawa kedua lempengan itu dan naik ke gunung Sinai, seperti yang diperintahkan TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Lalu TUHAN turun dalam awan dan berdiri tak jauh dari Musa. Dia pun menyatakan nama-Nya sendiri, yaitu TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Lalu TUHAN lewat di depan Musa dan berkata, “Akulah TUHAN, Allah yang penyayang dan penuh belas kasihan, panjang sabar, baik hati, dan setia. ");
INSERT INTO ind_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Memang Aku selalu setia dan berbaik hati kepada beribu-ribu keturunan dengan mengampuni kesalahan, pelanggaran, dan dosa mereka. Tetapi di sisi lain, Aku tidak akan membebaskan orang-orang yang bersalah dari hukuman. Aku akan menghukum anak cucu mereka atas kesalahan mereka, bahkan sampai keturunan yang ketiga dan keempat.” ");
INSERT INTO ind_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Saat itu juga Musa bersujud menyembah TUHAN ");
INSERT INTO ind_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","dan berkata, “Ya TUHAN, jika Engkau sungguh berkenan kepadaku, aku mohon berjalanlah bersama kami. Walaupun kami adalah bangsa yang keras kepala dan tidak taat, tolong ampunilah kesalahan dan dosa kami. Jadikanlah kami milik-Mu sendiri.” ");
INSERT INTO ind_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Lalu TUHAN menjawab, “Perhatikanlah, sekarang Aku meneguhkan kembali perjanjian-Ku dengan kalian. Aku akan melakukan keajaiban-keajaiban baru yang belum pernah disaksikan oleh bangsa mana pun di bumi. Semua bangsa di sekitar kalian akan melihat betapa dahsyatnya kuasa-Ku ketika mereka menyaksikan perbuatan-Ku bagimu, Musa. ");
INSERT INTO ind_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Taatilah perintah-perintah yang akan Aku berikan kembali kepadamu hari ini, dan Aku akan mengusir orang-orang Amori, Kanaan, Het, Feris, Hewi, dan Yebus dari hadapanmu. ");
INSERT INTO ind_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Berhati-hatilah! Jangan membuat perjanjian dengan penduduk di negeri yang akan kalian masuki. Jika kalian melakukannya, kalian akan terjerat dalam cara hidup mereka yang jahat. ");
INSERT INTO ind_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Sebaliknya, robohkanlah mezbah-mezbah mereka, hancurkan semua patung berhala mereka, dan tebanglah semua tiang penyembahan dewi Asyera. ");
INSERT INTO ind_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Kalian tidak boleh menyembah dewa apa pun, karena Aku adalah Allah yang cemburu. ");
INSERT INTO ind_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Jangan membuat perjanjian dengan penduduk negeri itu, karena mereka melacurkan diri mereka dengan menyembah berhala. Apabila kalian berkawan dengan mereka, maka mereka akan mengundang kalian untuk ikut memakan daging hewan-hewan yang mereka kurbankan kepada berhala. ");
INSERT INTO ind_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kalian juga akan mengambil anak-anak perempuan mereka sebagai istri bagi anak-anak lelakimu. Dan ketika anak perempuan mereka melacurkan diri, yaitu dengan menyembah patung berhala, mereka akan mempengaruhi anak-anak lelakimu untuk ikut menyembah berhala. ");
INSERT INTO ind_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Janganlah membuat patung berhala dari logam untuk kalian sembah.” ");
INSERT INTO ind_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Peringatilah Hari Raya Roti Tidak Beragi. Setiap tahun pada waktu yang sudah Aku tentukan dan perintahkan, kalian harus makan roti tidak beragi selama tujuh hari. Perayaan ini dilakukan pada bulan Abib untuk mengingat bahwa pada bulan itulah kalian keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Semua anak laki-laki yang sulung adalah milik-Ku. Begitu juga semua ternak jantan yang pertama lahir, baik sapi, kambing, maupun domba. ");
INSERT INTO ind_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Anak keledai jantan yang pertama lahir bisa kamu tebus dengan mempersembahkan kepada-Ku seekor anak domba atau kambing. Bila kamu tidak ingin menebusnya, kamu harus membunuh keledai itu dengan cara mematahkan lehernya. Akan tetapi, setiap anak laki-lakimu yang sulung harus kamu tebus. “Ketika menghadiri ketiga hari perayaan yang diwajibkan, tidak seorang pun boleh datang ke hadapan-Ku tanpa memberi persembahan. ");
INSERT INTO ind_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Enam hari lamanya kamu bekerja, tetapi pada hari ketujuh kamu harus beristirahat, bahkan pada masa membajak atau masa menuai sekalipun. ");
INSERT INTO ind_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Peringatilah Hari Raya Panen untuk merayakan hasil pertama dari panen gandum, dan Hari Raya Pondok Cabang-cabang Berdaun pada akhir musim panen. ");
INSERT INTO ind_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tiga kali dalam setahun setiap laki-laki harus datang menghadap Aku, Penguasa dan Allah Israel, di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Saat kamu menghadap Aku pada ketiga perayaan itu, Aku menjamin bahwa tidak akan ada musuh yang berani merebut tanahmu. Bahkan Aku akan mengusir bangsa-bangsa lain dari hadapan kalian dan memperluas batas wilayah kalian. ");
INSERT INTO ind_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Saat mempersembahkan kurban sembelihan, jangan memberikannya bersama roti yang beragi. “Pada perayaan Paskah, janganlah menyisakan daging kurban itu sampai besok paginya. Sisa yang ada harus dibakar habis sebelum fajar. ");
INSERT INTO ind_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Bawalah hasil terbaik panen pertamamu ke kemah-Ku, TUHAN Allahmu. “Jangan memasak daging anak kambing dengan air susu induknya.” ");
INSERT INTO ind_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kemudian TUHAN berkata kepada Musa, “Tuliskanlah semuanya itu sebagai pengingat, karena seluruh peraturan itu adalah kewajiban yang harus kalian lakukan untuk tetap menjadi bagian dalam ikatan perjanjian-Ku dengan Israel.” ");
INSERT INTO ind_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa berada di atas gunung bersama TUHAN empat puluh hari empat puluh malam, dan selama itu dia tidak makan ataupun minum. TUHAN menuliskan kata-kata perjanjian, yaitu sepuluh perintah Allah, pada kedua lempengan batu itu. ");
INSERT INTO ind_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sewaktu Musa turun dari gunung Sinai dengan membawa kedua lempengan batu yang bertuliskan hukum TUHAN, dia tidak menyadari bahwa wajahnya bercahaya karena TUHAN sudah berbicara dengannya. ");
INSERT INTO ind_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ketika Harun dan umat Israel melihat wajah Musa yang bercahaya, mereka takut mendekatinya. ");
INSERT INTO ind_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tetapi Musa memanggil mereka dan meminta Harun serta seluruh pemimpin bangsa Israel untuk datang, lalu dia berbicara kepada mereka. ");
INSERT INTO ind_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Seluruh umat Israel mendekati Musa, dan dia menyampaikan kepada mereka semua perintah yang TUHAN berikan kepadanya di gunung Sinai. ");
INSERT INTO ind_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Setelah Musa selesai berbicara dengan mereka, dia menutupi wajahnya dengan kain. ");
INSERT INTO ind_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","35","Musa tetap menutupi wajahnya sampai dia masuk kembali ke Kemah Pertemuan untuk berbicara dengan TUHAN. Setiap kali Musa masuk ke kemah itu, dia melepaskan kain dari wajahnya dan baru memakainya lagi saat keluar. Ketika dia keluar, umat Israel dapat melihat wajah Musa masih bercahaya. Karena itulah dia segera menutupi wajahnya dan menyampaikan berbagai pesan TUHAN kepada umat. ");
INSERT INTO ind_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa memanggil seluruh umat Israel untuk berkumpul lalu berkata kepada mereka, “Inilah perintah TUHAN yang harus kita lakukan: ");
INSERT INTO ind_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Enam hari kita boleh bekerja dalam seminggu, tetapi pada hari yang ketujuh kita harus beristirahat penuh, karena hari itu adalah hari Sabat, yang kita khususkan bagi TUHAN. Siapa pun yang bekerja pada hari itu akan dihukum mati. ");
INSERT INTO ind_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Kita tidak boleh menyalakan api di dalam tempat tinggal kita pada hari Sabat.” ");
INSERT INTO ind_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Selanjutnya kata Musa kepada seluruh umat Israel, “Inilah perintah TUHAN: ");
INSERT INTO ind_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kumpulkanlah persembahan bagi TUHAN yang akan digunakan untuk mengerjakan kemah-Nya. Hendaklah setiap orang yang tergerak hatinya membawa persembahan kepada TUHAN, berupa emas, perak, perunggu, ");
INSERT INTO ind_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","benang linen merah, biru, dan ungu, kain linen yang berkualitas tinggi, bulu kambing yang akan dipintal dan ditenun menjadi kain, ");
INSERT INTO ind_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kulit domba jantan yang diwarnai merah, kulit yang tidak meresap air, kayu akasia, ");
INSERT INTO ind_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","minyak zaitun untuk tiang pelita bercabang, berbagai wangi-wangian dari getah pohon untuk membuat minyak pengurapan dan dupa, ");
INSERT INTO ind_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","permata hijau dan berbagai permata lain yang berwarna-warni, untuk dipasang pada efod dan penutup dada yang akan dipakai oleh imam besar. ");
INSERT INTO ind_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Setiap orang yang memiliki keterampilan untuk mengerjakan hal-hal yang diperintahkan TUHAN, datanglah kepada saya. Mari kita membuat hal-hal ini: ");
INSERT INTO ind_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Seluruh bagian kemah TUHAN, termasuk kemah dan kain penutupnya, pengait-pengait, rangka-rangka, kayu lintang, tiang-tiang dan alasnya yang dibuat dari logam, ");
INSERT INTO ind_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","peti perjanjian dengan tongkat pengusungnya, penutup peti, tirai penutup ruangan untuk peti itu, ");
INSERT INTO ind_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meja dengan tongkat pengusungnya, segala perlengkapannya, roti sajian, ");
INSERT INTO ind_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","tiang pelita bercabang dengan pelita-pelitanya dan segala perlengkapannya, minyak untuk pelita itu, ");
INSERT INTO ind_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","mezbah dupa dengan tongkat pengusungnya, minyak pengurapan dan dupa, tirai pintu masuk kemah, ");
INSERT INTO ind_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","mezbah kurban dengan alas bakar dari perunggu, tongkat pengusung mezbah, dan segala perlengkapan lainnya, bejana pembasuhan dari perunggu dan tumpuannya, ");
INSERT INTO ind_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","tirai-tirai untuk halaman, tiang penyangga, tirai pintu gerbang halaman, ");
INSERT INTO ind_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","pasak-pasak kemah TUHAN, pagar halamannya, semua talinya, ");
INSERT INTO ind_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","dan segala macam pakaian indah yang dikhususkan bagi Harun dan anak-anaknya untuk dipakai ketika mereka melayani di ruang kudus.” ");
INSERT INTO ind_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Seluruh umat Israel mendengarkan semua petunjuk yang Musa sampaikan itu, lalu kembali ke kemah mereka. ");
INSERT INTO ind_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kemudian setiap orang yang tergerak hatinya dan terdorong semangatnya berdatangan sambil membawa persembahan bagi TUHAN untuk mengerjakan kemah-Nya, segala macam perlengkapan yang akan diperlukan dalam penyembahan-Nya, dan bahan-bahan untuk pakaian imam. ");
INSERT INTO ind_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Baik laki-laki maupun perempuan, semua orang yang tergerak hatinya datang kepada Musa dengan membawa bros, anting-anting, cincin, kalung, dan segala macam perhiasan emas lainnya. Ketika menyerahkan benda-benda itu kepada Musa, mereka mengangkat tinggi perhiasan-perhiasan itu sebagai tanda bahwa mereka mempersembahkannya bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Setiap orang yang memiliki bahan yang diperlukan datang membawanya, yaitu benang linen merah, biru atau ungu, kain linen yang berkualitas tinggi, bulu kambing untuk ditenun, kulit domba jantan yang diwarnai merah, dan kulit yang tidak meresap air. ");
INSERT INTO ind_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Setiap orang yang hendak mempersembahkan perak atau perunggu membawanya sebagai persembahan kepada TUHAN. Demikian pula setiap orang yang mempunyai kayu akasia datang membawanya. ");
INSERT INTO ind_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","26","Setiap perempuan yang terampil memintal membawa hasil pintalan mereka, berupa benang linen merah, biru, atau ungu. Dan perempuan yang terampil memintal bulu kambing datang membawa benang. Ada juga perempuan yang membawa hasil tenun linen berkualitas tinggi. ");
INSERT INTO ind_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Para pemimpin membawa segala macam permata yang berwarna-warni untuk dipasang pada efod dan penutup dada. ");
INSERT INTO ind_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Mereka juga membawa minyak zaitun untuk pelita dan berbagai wangi-wangian dari getah pohon untuk dicampur dalam pembuatan minyak pengurapan dan dupa. ");
INSERT INTO ind_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Baik laki-laki maupun perempuan, setiap orang Israel yang tergerak hatinya membawa sumbangan sukarela kepada TUHAN untuk mendukung pekerjaan yang TUHAN perintahkan melalui Musa. ");
INSERT INTO ind_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Lalu Musa berkata kepada umat Israel, “TUHAN sudah mengangkat Bezalel anak Uri, cucu Hur dari suku Yehuda, sebagai kepala dalam pekerjaan besar ini. ");
INSERT INTO ind_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","TUHAN sudah memenuhi Bezalel dengan Roh-Nya dan memberinya kebijaksanaan, kepandaian, serta kemampuan dalam segala bidang pekerjaannya, ");
INSERT INTO ind_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","yaitu pembuatan rancangan dari emas, perak, dan perunggu, ");
INSERT INTO ind_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pemotongan dan pemasangan batu permata, pemahatan kayu, serta segala macam kerajinan lainnya. ");
INSERT INTO ind_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","TUHAN juga sudah mengangkat Aholiab anak Ahisamak dari suku Dan sebagai wakil Bezalel dalam pekerjaan besar ini. TUHAN sudah memampukan keduanya untuk mengajarkan keahlian mereka kepada orang lain. ");
INSERT INTO ind_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","TUHAN sudah memberikan keahlian khusus kepada para perajin, termasuk pemahat, perancang, dan penenun yang bisa menghasilkan gambar dalam kain linen yang berkualitas tinggi dengan menggunakan benang merah, biru, dan ungu. Mereka ahli dalam segala macam pekerjaan dan karya seni.” ");
INSERT INTO ind_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Kata Musa, “TUHAN sudah memberikan kemampuan dan kebijaksanaan kepada Bezalel, Aholiab, dan para perajin ahli lainnya, untuk melakukan semua pekerjaan dalam pembuatan kemah TUHAN dan perlengkapannya. Mereka harus mengerjakannya sesuai dengan yang sudah TUHAN perintahkan.” ");
INSERT INTO ind_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Maka Musa memanggil Bezalel, Aholiab, dan setiap perajin, yaitu orang-orang yang diberi keahlian khusus oleh TUHAN dan yang hatinya tergerak untuk melakukan pekerjaan itu. ");
INSERT INTO ind_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mereka menerima dari Musa seluruh sumbangan yang diberikan oleh umat Israel untuk mengerjakan kemah TUHAN. Namun, meski bahan-bahan sudah cukup, setiap pagi umat Israel masih terus membawa sumbangan bahan kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Karena itu semua perajin meninggalkan pekerjaan mereka dan datang kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mereka berkata, “Rakyat sudah menyumbang lebih banyak daripada yang diperlukan untuk menyelesaikan segala sesuatu yang TUHAN perintahkan.” ");
INSERT INTO ind_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Maka Musa mengumumkan ke seluruh perkemahan, “Bahan-bahan yang dibutuhkan sudah cukup! Mulai sekarang, baik laki-laki maupun perempuan jangan ada lagi yang membawa sumbangan untuk pembuatan kemah TUHAN.” Lalu mereka pun berhenti menyumbangkan bahan, ");
INSERT INTO ind_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","karena semua keperluan untuk menyelesaikan kemah TUHAN sudah cukup, bahkan lebih dari cukup. ");
INSERT INTO ind_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Para ahli tenun membuat sepuluh helai kain untuk lapisan atap kemah yang paling bawah. Semua kain itu merupakan karya seni yang indah dari linen berkualitas tinggi, yang ditenun dari benang berwarna merah, biru, dan ungu dengan gambar malaikat penjaga. ");
INSERT INTO ind_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Setiap lembar kain berukuran sama, yaitu 13 meter panjangnya dan 1,8 meter lebarnya. ");
INSERT INTO ind_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","13","Kesepuluh helai kain itu disambungkan menjadi dua rangkaian yang masing-masing terdiri dari lima helai. Setiap sisi panjang mempunyai lima puluh lubang kait yang dibuat dari tali biru, dan setiap helai disambungkan pada helai berikutnya dengan lima puluh pengait dari emas. Jadi, ketika lima kain disambungkan sepanjang sisi panjangnya, rangkaian itu menjadi satu dengan panjang 13 meter dan lebar 9 meter. ");
INSERT INTO ind_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Untuk atap lapisan yang kedua, para ahli tenun juga membuat sebelas lembar kain dari bulu kambing. ");
INSERT INTO ind_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","18","Setiap lembar berukuran sama, yaitu 14 meter panjangnya dan 1,8 meter lebarnya. Setiap sisi panjang mempunyai lima puluh lubang kait yang disambungkan pada helai lain dengan lima puluh pengait dari perunggu. Kesebelas helai itu disambungkan menjadi dua rangkaian, yang satu terdiri dari lima lembar, dan yang lainnya enam lembar. ");
INSERT INTO ind_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Untuk atap lapisan yang ketiga, mereka membuat penutup dari kulit domba jantan yang diwarnai merah. Dan untuk lapisan yang paling atas, mereka membuat penutup dari kulit yang tidak menyerap air. ");
INSERT INTO ind_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","22","Para perajin juga membuat papan-papan rangka dari kayu akasia untuk menopang atap kemah TUHAN. Semua rangka dibuat dengan sama persis. Setiap papan berukuran tinggi 4,6 meter dan lebar 69 sentimeter, serta mempunyai dua pasak yang menjulur dari bawah. ");
INSERT INTO ind_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","26","Mereka membuat dua puluh rangka untuk sisi selatan kemah dan dua puluh untuk sisi utara. Setiap pasak dari empat puluh kayu rangka itu dimasukkan ke dalam delapan puluh alas penahan yang dicetak dari perak. ");
INSERT INTO ind_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","28","Untuk bagian belakang kemah, di sisi barat, mereka membuat delapan rangka, dengan dua yang dibuat khusus untuk kedua sudut belakang kemah. ");
INSERT INTO ind_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kedua rangka khusus itu menyatukan sudut kiri dan kanan, dari bawah sampai ke atas, dan tersambung di ujung atas dengan gelang penahan yang terbuat dari emas. ");
INSERT INTO ind_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kedelapan rangka untuk sisi belakang kemah TUHAN dipasang di atas enam belas alas penahan yang dicetak dari perak, dua alas untuk setiap papan rangka. ");
INSERT INTO ind_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Mereka juga membuat kayu-kayu lintang dari kayu akasia dan memasangnya melintangi rangka-rangka itu, lima kayu lintang untuk sisi utara kemah TUHAN, ");
INSERT INTO ind_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima untuk sisi selatan, dan lima lagi untuk bagian belakang kemah yang menghadap ke barat. ");
INSERT INTO ind_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kayu lintang yang di tengah dipasang pada setengah tinggi papan rangka dan melintang dari ujung yang satu sampai ke ujung lainnya. ");
INSERT INTO ind_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mereka melapisi rangka-rangka dan kayu-kayu lintang itu dengan emas, dan membuat gelang-gelang emas pada setiap rangka untuk memasang kayu lintang. ");
INSERT INTO ind_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Untuk memisahkan bagian dalam kemah TUHAN, mereka membuat tirai dari kain linen berkualitas tinggi yang ditenun berbentuk malaikat-malaikat penjaga, dari benang linen merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Tirai ini digantungkan dengan pengait-pengait emas pada empat tiang kayu akasia yang dilapisi dengan emas. Tiang-tiang kayu itu berdiri di atas alas yang dicetak dari perak. ");
INSERT INTO ind_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mereka juga membuat tirai untuk pintu kemah TUHAN, yang ditenun dari benang linen berkualitas tinggi yang berwarna merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Tirai ini digantungkan dengan pengait-pengait emas pada lima tiang kayu akasia. Kelima tiang ini mempunyai dekorasi di ujung atas dan gelang besar sebagai tempat memasang pengait, dan semuanya dilapisi dengan emas. Tiang-tiang ini berdiri di atas lima alas yang dicetak dari perunggu. ");
INSERT INTO ind_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel membuat peti perjanjian dari kayu akasia. Panjangnya 115 sentimeter, lebarnya 69 sentimeter, dan tingginya 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Dia melapisi bagian dalam dan luar peti itu dengan emas murni, serta membuat bingkai emas di sekeliling peti itu pada bagian atas. ");
INSERT INTO ind_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Dia juga mencetak empat buah gelang emas dan memasangnya pada keempat kaki peti itu, dua gelang pada tiap sisi panjang. ");
INSERT INTO ind_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Dia membuat dua tongkat pengusung dari kayu akasia, melapisinya dengan emas, ");
INSERT INTO ind_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","dan memasukkannya ke dalam gelang-gelang pada kedua sisi peti. ");
INSERT INTO ind_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Lalu Bezalel membuat penutup peti yang disebut Takhta Pendamaian dari emas murni dengan panjang 115 sentimeter dan lebar 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Dia mencetak emas untuk membuat penutup peti sekaligus dengan dua bentuk malaikat penjaga yang saling berhadapan di atasnya. Satu bentuk makhluk bersayap berada pada setiap ujung penutup peti itu. ");
INSERT INTO ind_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kedua bentuk malaikat itu saling berhadapan, dengan muka mengarah ke penutup peti dan sayap-sayapnya terbentang ke atas sehingga menaungi penutup peti itu. ");
INSERT INTO ind_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezalel membuat sebuah meja dari kayu akasia. Panjangnya 92 sentimeter, lebarnya 46 sentimeter, dan tingginya 69 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Dia melapisi meja itu dengan emas murni dan membuat bingkai emas di sekelilingnya. ");
INSERT INTO ind_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Dia membuat pinggiran mengelilinginya selebar 8 sentimeter dan membuat bingkai emas pada pinggiran itu. ");
INSERT INTO ind_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Kemudian Bezalel mencetak empat gelang emas dan memasangnya pada keempat sudut kaki meja. ");
INSERT INTO ind_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Gelang-gelang itu dipasang dekat dengan bingkai sebagai tempat memasang dua tongkat pengusung. ");
INSERT INTO ind_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Kedua tongkat itu dibuatnya dari kayu akasia dan dilapisi dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Dia juga membuat perkakas dari emas murni untuk diletakkan di atas meja, yaitu piring-piring dan sendok-sendok untuk dupa, juga kendi-kendi dan mangkuk-mangkuk untuk menuangkan persembahan air anggur. ");
INSERT INTO ind_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bezalel membuat tiang pelita bercabang dari emas murni. Dia menempa sebongkah emas murni untuk membentuk bagian-bagian tiang pelita, yakni kaki, batang, cabang-cabangnya, dan ketujuh pelita yang berbentuk bunga. ");
INSERT INTO ind_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Tiang pelita itu memiliki enam cabang, tiga pada sisi kiri dan tiga pada sisi kanan. ");
INSERT INTO ind_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Setiap cabang memiliki tiga hiasan yang berbentuk seperti bunga badam, lengkap dengan kelopak dan mahkota bunganya. ");
INSERT INTO ind_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Tiang utama pelita itu sendiri memiliki empat hiasan yang berbentuk seperti bunga badam, lengkap dengan kelopak dan mahkota bunganya. ");
INSERT INTO ind_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Juga ada sebuah hiasan berbentuk kuncup bunga badam di bawah setiap pasangan cabang yang keluar dari tiang utama pelita. ");
INSERT INTO ind_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Semua bagian tiang pelita ini, termasuk cabang-cabangnya dan hiasan-hiasannya yang berbentuk bunga, ditempa dari satu bongkahan emas murni. ");
INSERT INTO ind_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Bezalel juga membuat ketujuh tempat pelitanya, penjepitnya, dan wadah-wadah kecil untuk menampung sumbu yang hangus dari emas murni. ");
INSERT INTO ind_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Dia membuat tiang pelita bercabang itu dan semua perkakasnya dari 34 kilogram emas murni. ");
INSERT INTO ind_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezalel membuat mezbah dupa dari kayu akasia berbentuk persegi. Panjang setiap sisinya 46 sentimeter, dan tingginya 92 sentimeter. Tanduk-tanduknya tidak ditempel saja, tetapi dipahat sehingga menyatu dengan mezbah itu. ");
INSERT INTO ind_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Dia melapisi seluruh bagian mezbah dengan emas murni, yakni bagian atas, keempat sisi, dan tanduk-tanduknya, serta membuat bingkai emas di sekelilingnya. ");
INSERT INTO ind_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Dia juga membuat dua gelang emas dan memasangnya di bawah bingkai itu, pada kedua sisi yang berseberangan, untuk memasukkan tongkat pengusung. ");
INSERT INTO ind_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Dia membuat tongkat-tongkat pengusung dari kayu akasia dan melapisinya dengan emas. ");
INSERT INTO ind_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Selanjutnya dia membuat minyak pengurapan dan dupa dengan cara pembuatan seperti yang dilakukan ahli pembuat minyak wangi dan pencampur dupa. Minyak pengurapan dan dupa ini harus senantiasa diperlakukan sebagai barang yang kudus. ");
INSERT INTO ind_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel bersama para perajin membuat mezbah kurban dari kayu akasia. Mezbah itu berbentuk persegi dengan panjang keempat sisinya 2,3 meter dan tingginya 1,4 meter. ");
INSERT INTO ind_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Pada keempat sudutnya, mereka membuat tanduk-tanduk yang dipahat menyatu dengan mezbah itu. Kemudian seluruh mezbah dilapisi dengan perunggu. ");
INSERT INTO ind_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Mereka juga membuat perkakas untuk mezbah itu dari perunggu, yaitu tempat-tempat abu, sekop-sekop, bejana-bejana, pengait daging, dan kuali-kuali untuk mengangkut bara. ");
INSERT INTO ind_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mereka membuat alas tebal yang berlubang-lubang dari perunggu untuk menahan kayu bakar. Alas itu dipasang pada posisi setengah dari tinggi mezbah. ");
INSERT INTO ind_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Mereka mencetak empat gelang dari perunggu dan memasangnya pada keempat sudut luar mezbah sebagai tempat untuk memasukkan dua tongkat pengusung. ");
INSERT INTO ind_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Tongkat-tongkat pengusung itu dibuat dari kayu akasia dan dilapisi dengan perunggu. ");
INSERT INTO ind_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ketika mezbah perlu diusung, kedua tongkat dimasukkan ke dalam keempat gelang itu. Mezbah kurban berbentuk seperti kotak kosong yang terbuka. ");
INSERT INTO ind_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezalel bersama para pengerja juga membuat sebuah bejana pembasuhan beserta tumpuannya dari perunggu. Perunggu untuk membuat bejana itu berasal dari cermin-cermin perunggu yang disumbangkan oleh para perempuan yang mengerjakan pelayanan di pintu masuk Kemah Pertemuan. ");
INSERT INTO ind_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","11","Di bawah pimpinan Bezalel, para perajin menenun tirai-tirai kain linen yang berkualitas tinggi untuk pagar halaman kemah TUHAN. Rangkaian tirai untuk sisi selatan dan utara masing-masing sepanjang 45 meter. Sebagai tempat untuk menggantung tirai-tirai itu, mereka membuat dua puluh tiang dan 20 alas perunggu. Setiap tiang dilengkapi dengan gelang perak besar di ujung atas sebagai tempat memasang pengait perak. ");
INSERT INTO ind_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Di sebelah barat, rangkaian tirai panjangnya 22,5 meter, digantungkan pada sepuluh tiang yang berdiri di atas sepuluh alas. Ujung atas setiap tiang memiliki gelang perak besar sebagai tempat memasang pengait perak. ");
INSERT INTO ind_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Di sebelah timur, tempat pintu gerbang kemah, lebar halaman juga 22,5 meter. ");
INSERT INTO ind_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Pintu gerbang halaman itu diapit oleh dua rangkaian tirai, masing-masing sepanjang 6,75 meter, yang digantungkan pada tiga tiang yang berdiri di atas tiga alas. ");
INSERT INTO ind_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mereka menenun tirai-tirai linen yang berkualitas tinggi untuk memagari halaman. ");
INSERT INTO ind_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Semua alas untuk tiang dibuat dari perunggu, sedangkan semua gelang penyambung dan pengait-pengaitnya dari perak. Ujung atas setiap tiang di halaman dilapisi dengan perak. ");
INSERT INTO ind_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Di tengah sisi timur, tirai pintu gerbang ditenun dari benang linen yang berkualitas tinggi berwarna merah, biru, dan ungu. Panjang tirai itu 9 meter dan tingginya 2,25 meter. Tingginya sama dengan semua tirai yang mengelilingi halaman. ");
INSERT INTO ind_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Tirai pintu gerbang itu digantung pada empat tiang yang berdiri di atas empat alas perunggu. Ujung atas setiap tiang ini dilapisi dengan perak, dan memiliki gelang penyambung sebagai tempat memasang pengait-pengait tirai. Gelang-gelang dan semua pengait dibuat dari perak. ");
INSERT INTO ind_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Semua pasak kemah TUHAN dan halamannya dibuat dari perunggu. ");
INSERT INTO ind_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Atas perintah Musa, para sekretaris dari suku Lewi mencatat semua jenis dan total berat logam yang digunakan dalam pembuatan halaman dan kemah TUHAN, tempat peti perjanjian disimpan. Mereka mencatat semua itu di bawah pengawasan Itamar anak Harun. ");
INSERT INTO ind_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel anak Uri, cucu Hur dari suku Yehuda, memimpin para perajin supaya segala sesuatu dikerjakan persis seperti yang TUHAN perintahkan kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bezalel dibantu oleh Aholiab anak Ahisamak, dari suku Dan, seorang yang ahli mengukir, merancang, dan menenun dengan benang linen berkualitas tinggi berwarna merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Seluruh emas yang disumbangkan umat Israel untuk mengerjakan kemah TUHAN berjumlah 1.000 kilogram. Jumlah ini ditimbang sesuai pengukur berat yang sah. ");
INSERT INTO ind_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Seluruh perak yang disumbangkan umat Israel saat sensus berjumlah 3.420 kilogram. Jumlah ini ditimbang sesuai pengukur berat yang sah. ");
INSERT INTO ind_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Semua laki-laki yang berumur dua puluh tahun ke atas dihitung dalam sensus itu dan masing-masing membayar 6 gram perak. Jumlah ini juga ditimbang sesuai pengukur berat yang sah. Jumlah orang yang terdaftar adalah 603.550 orang. ");
INSERT INTO ind_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Perak sebanyak 3.400 kilogram digunakan untuk membuat seratus buah alas dengan cara dicetak. Sembilan puluh enam alas digunakan sebagai tempat mendirikan rangka-rangka kemah TUHAN, dan empat digunakan untuk mendirikan empat tiang yang menopang tirai pemisah ruang mahakudus. Satu alas memerlukan 34 kilogram perak. ");
INSERT INTO ind_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Sisa perak sejumlah 20 kilogram digunakan untuk membuat gelang-gelang penyambung untuk tiang-tiang, pengait-pengaitnya, dan untuk melapisi ujung atas tiang. ");
INSERT INTO ind_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Perunggu yang disumbangkan oleh umat Israel seluruhnya berjumlah 2.400 kilogram. ");
INSERT INTO ind_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Perunggu itu dipakai untuk membuat alas tiang-tiang gerbang kemah TUHAN, melapisi kayu mezbah kurban, membuat alas berlubang-lubang untuk menahan kayu bakar di dalam mezbah itu, membuat semua perkakas mezbah, ");
INSERT INTO ind_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","membuat alas untuk semua tiang pagar sekeliling halaman kemah TUHAN dan gerbang halaman, serta membuat seluruh pasak kemah itu dan pasak untuk pagar halamannya. ");
INSERT INTO ind_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Sesuai perintah TUHAN kepada Musa, Bezalel dan para perajin membuat pakaian khusus untuk Harun. Pakaian itu harus dianggap kudus dan dipakai saat melayani TUHAN di kemah-Nya. Semua pakaian itu dibuat dengan menenun pola yang indah dari benang merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Mereka menenun efod dari benang linen yang berkualitas tinggi berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas. ");
INSERT INTO ind_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Mereka membuat benang dari emas yang ditempa menjadi lempengan-lempengan yang sangat tipis, lalu diiris-iris sehingga menjadi seperti benang. Benang emas itu digunakan untuk menghiasi pola yang mereka tenun dari benang linen berkualitas yang berwarna merah, biru, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Efod itu terdiri dari dua bagian, yaitu bagian depan dan bagian belakang. Kedua bagian ini disambungkan dengan dua penutup bahu. ");
INSERT INTO ind_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Sesuai perintah TUHAN kepada Musa, ikat pinggang yang disatukan dengan efod dibuat dari bahan yang sama dengan efod itu, yakni kain linen berkualitas tinggi yang ditenun oleh perajin ahli menggunakan benang linen berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas. ");
INSERT INTO ind_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mereka menghias kedua penutup bahu dengan dua batu permata hijau yang dipasang pada dua bingkai emas, satu di bahu kiri dan satu di kanan. Mereka mengukir nama-nama suku Israel pada kedua batu permata itu dengan cara seperti yang biasa dilakukan oleh ahli permata saat mengukir meterai. ");
INSERT INTO ind_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kemudian, sesuai perintah TUHAN kepada Musa, mereka memasang kedua batu permata yang sudah dibingkai itu pada kedua penutup bahu efod. Hal itu dilakukan sebagai tanda pengingat di hadapan TUHAN bahwa Harun mewakili seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bezalel juga membuat penutup dada yang ditenun dari benang linen berkualitas tinggi yang berwarna merah, biru, dan ungu, serta dihiasi dengan benang emas menjadi karya seni yang serupa dengan efod. ");
INSERT INTO ind_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Penutup dada itu dilipat dua membentuk kantong persegi empat dengan panjang dan lebar 22 sentimeter. ");
INSERT INTO ind_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mereka memasang empat baris batu permata pada penutup dada itu. Baris pertama terdiri dari batu permata merah, bening, dan hijau tua. ");
INSERT INTO ind_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Baris kedua terdiri dari batu permata hijau campur biru, biru tua, dan bening. ");
INSERT INTO ind_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Baris ketiga terdiri dari batu permata biru, putih campur cokelat, dan ungu. ");
INSERT INTO ind_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Baris keempat terdiri dari batu permata bening, hijau, dan hijau campur merah. Setiap batu permata ini dipasang dengan bingkai emas. ");
INSERT INTO ind_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Dua belas batu permata itu melambangkan kedua belas anak Yakub, yang kemudian menjadi dua belas suku Israel. Pada setiap batu permata itu diukir masing-masing satu nama suku Israel, dengan ukiran seperti cap meterai. ");
INSERT INTO ind_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","18","Di bagian atas penutup dada, mereka membuat penahan berupa dua rantai dari emas murni yang dijalin seperti tali, serta dua cincin emas. Cincin yang satu dijahit pada pojok kiri atas penutup dada, dan yang lainnya dijahit pada pojok kanan atas, untuk mengikat penutup dada dengan rantai itu pada kedua bingkai di penutup bahu efod. ");
INSERT INTO ind_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","20","Sebagai penahan di bagian bawah, mereka membuat empat cincin emas lagi. Satu cincin dijahit pada pojok kiri bawah penutup dada, dan satu lagi pada pojok kanan bawah, di bagian dalam yang berdekatan dengan efod. Dua cincin emas lainnya dijahit pada bagian depan efod, di sebelah kiri dan kanan, posisinya di antara bagian bawah penutup bahu dan sambungan ikat pinggang. ");
INSERT INTO ind_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kedua cincin di sisi kiri, yaitu cincin pada efod dan cincin pada penutup dada, diikatkan dengan tali biru. Demikian juga dengan kedua cincin di sisi kanan. Dengan begitu, penutup dada tidak bergantung lepas ketika Harun membungkuk. Mereka melakukan semua ini sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Para perajin menenun jubah yang akan dipakai Harun di bawah efod dari benang warna biru ");
INSERT INTO ind_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","dengan kerah yang tebal, agar jubah tidak mudah robek. ");
INSERT INTO ind_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Sekeliling ujung bawah jubah ditenun dengan hiasan-hiasan berbentuk buah delima dari benang warna merah, biru, dan ungu. Lonceng-lonceng emas dipasang secara berselang-seling dengan hiasan-hiasan itu. Harun wajib memakai jubah ini setiap kali dia melayani TUHAN, seperti yang sudah TUHAN perintahkan kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","28","Para perajin membuat baju panjang dan celana dalam untuk Harun dan anak-anaknya, juga serban khusus untuk Harun dan ikat kepala untuk anak-anaknya. Semua itu dibuat dengan cara menenun benang linen yang berkualitas tinggi. ");
INSERT INTO ind_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ikat pinggang untuk anak-anak Harun juga ditenun dari benang linen berkualitas yang berwarna merah, biru, dan ungu, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Sebagai tanda kekudusan pelayanan Harun, mereka membuat medali dari emas murni untuk serbannya. Permukaan medali itu diukir dengan kata-kata, “Kudus bagi TUHAN,” yang dibuat seperti ukiran untuk cap meterai. ");
INSERT INTO ind_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Medali itu diikatkan pada serban Harun dengan tali berwarna biru, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Demikianlah mereka menyelesaikan seluruh tugas untuk mengerjakan kemah TUHAN. Orang Israel melakukan segalanya sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Lalu mereka menunjukkan semua itu kepada Musa, yakni kemah dengan segala perlengkapannya, pengait-pengait, rangka-rangka, kayu-kayu lintang, tiang-tiang dan alasnya, ");
INSERT INTO ind_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","penutup kemah dari kulit domba jantan yang diwarnai merah, penutup paling atas dari kulit yang tidak menyerap air, tirai yang menutupi ruang mahakudus, ");
INSERT INTO ind_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","peti perjanjian dengan tongkat pengusungnya, penutup peti yang disebut Takhta Pendamaian, ");
INSERT INTO ind_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meja dan segala peralatannya, roti sajian, ");
INSERT INTO ind_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","tiang pelita bercabang, pelita-pelitanya, semua perlengkapannya, dan minyak untuk menyalakan pelita, ");
INSERT INTO ind_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","mezbah dupa dari emas, minyak pengurapan, dupa, tirai pintu masuk kemah TUHAN, ");
INSERT INTO ind_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","mezbah kurban yang dilapisi perunggu, alasnya yang berlubang-lubang dari perunggu, tongkat-tongkat pengusung, dan segala perlengkapan mezbah, bejana pembasuhan beserta tumpuannya, ");
INSERT INTO ind_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","tirai-tirai untuk halaman, tiang penyangga, tirai pintu gerbang halaman, semua tali dan pasak-pasaknya, juga segala perlengkapan lain untuk kemah TUHAN, ");
INSERT INTO ind_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","juga pakaian untuk para imam ketika melayani di kemah TUHAN, yaitu pakaian yang menunjukkan bahwa Harun dan anak-anaknya melaksanakan pelayanan kudus bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Demikianlah umat Israel melakukan segala pekerjaan sesuai dengan perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa memeriksa hasil pekerjaan mereka dan merasa senang karena mereka sudah melakukan semuanya sesuai perintah TUHAN. Kemudian Musa mendoakan berkat TUHAN atas mereka. ");
INSERT INTO ind_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Pada hari pertama bulan pertama, dirikanlah kemah-Ku. Kemah itu melambangkan kehadiran-Ku di antara umat-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tempatkanlah peti perjanjian di dalamnya, di ruang mahakudus. Lalu pasanglah tirai pemisah antara ruang mahakudus dengan ruang kudus. ");
INSERT INTO ind_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Taruhlah meja roti sajian di dalam kemah itu dan aturlah semua perlengkapannya. Bawalah juga tiang pelita bercabang dan nyalakanlah sumbu-sumbu pelitanya. ");
INSERT INTO ind_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Letakkan mezbah emas untuk membakar dupa di depan peti perjanjian, dan pasanglah tirai di pintu masuk kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tempatkanlah mezbah kurban di bagian halaman yang di dekat pintu kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Taruhlah bejana pembasuhan di antara kemah-Ku dan mezbah itu, lalu isilah dengan air. ");
INSERT INTO ind_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Dirikanlah pagar di sekeliling halaman kemah dan pasanglah tirai di pintu gerbang halaman. ");
INSERT INTO ind_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Kemudian ambillah minyak pengurapan yang sudah dikuduskan bagi-Ku, dan urapilah kemah-Ku beserta semua perlengkapan di dalamnya, supaya semuanya itu dikuduskan demi pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Urapilah juga mezbah kurban dan semua perlengkapannya, supaya semua itu— terkhusus mezbahnya— dikuduskan demi pelayanan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Urapilah juga bejana pembasuhan dan tumpuannya agar menjadi kudus bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Kemudian ajaklah Harun dan anak-anaknya mendekat ke pintu masuk kemah-Ku dan basuhlah mereka dengan air. ");
INSERT INTO ind_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Sesudah itu, kenakanlah pada Harun pakaian yang sudah dibuat khusus bagi dia untuk melayani di hadapan-Ku. Urapilah Harun agar dia dikhususkan untuk melayani-Ku sebagai imam. ");
INSERT INTO ind_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Lalu ajaklah anak-anak Harun maju dan kenakanlah pada mereka baju panjang yang sudah disiapkan. ");
INSERT INTO ind_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Urapilah mereka seperti kamu mengurapi ayah mereka, agar mereka juga dapat melayani-Ku sebagai imam. Dengan pengurapan itu, mereka dan keturunan mereka dikhususkan untuk senantiasa melayani Aku sebagai imam.” ");
INSERT INTO ind_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa melaksanakan semuanya itu sesuai dengan perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Maka kemah TUHAN didirikan pada hari pertama bulan pertama dalam tahun kedua sesudah mereka meninggalkan Mesir. ");
INSERT INTO ind_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Dibantu oleh orang-orang suku Lewi, Musa mendirikan kemah itu dengan meletakan alas-alasnya, memasang papan-papan rangka dan kayu-kayu lintangnya, kemudian mendirikan tiang-tiangnya. ");
INSERT INTO ind_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Lalu mereka membentangkan semua lapisan atap di atas rangka-rangka itu, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Musa mengambil kedua lempengan batu yang bertuliskan sepuluh perintah Allah dan memasukkannya ke dalam peti perjanjian. Selanjutnya dia memasang tongkat pengusung pada peti itu dan meletakkan penutup peti, yaitu Takhta Pendamaian, di atasnya. ");
INSERT INTO ind_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Lalu dia membawa peti itu ke dalam ruang mahakudus di kemah TUHAN dan memasang tirai pemisah antara ruang kudus dengan ruang mahakudus agar peti itu tidak terlihat dari luar, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Kemudian Musa menempatkan meja roti sajian di dalam kemah TUHAN, pada sisi utara di depan tirai pemisah, ");
INSERT INTO ind_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","dan menyusun roti sajian di atas meja itu, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Musa menempatkan tiang pelita di dalam kemah TUHAN di sisi selatan, berhadapan dengan meja itu. ");
INSERT INTO ind_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Dia juga menyalakan pelita-pelita di hadapan TUHAN, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Lalu Musa meletakkan mezbah dupa di depan tirai di dalam kemah itu ");
INSERT INTO ind_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","dan membakar dupa di sana, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Sesudah itu, Musa dibantu beberapa orang dari suku Lewi memasang tirai pada pintu masuk kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Mereka juga meletakkan mezbah kurban di depan pintu masuk kemah itu. Lalu Musa mempersembahkan kurban yang dibakar habis dan persembahan gandum-ganduman, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Musa menyuruh beberapa orang meletakkan bejana pembasuhan di antara kemah dan mezbah, lalu mengisinya dengan air. ");
INSERT INTO ind_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Air itu disiapkan supaya Musa, Harun, dan anak-anak Harun dapat membasuh tangan dan kaki mereka di sana. ");
INSERT INTO ind_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mereka wajib membasuh tangan dan kaki setiap hendak memasuki kemah itu atau mendekat ke mezbah, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Terakhir, Musa dan orang-orang Lewi mendirikan pagar halaman di sekeliling kemah itu serta mezbah, dan memasang tirai pada pintu gerbang halaman. Dengan demikian, selesailah seluruh pekerjaan mendirikan kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Kemudian awan kemuliaan TUHAN menutup dan memenuhi kemah TUHAN. Musa tidak bisa masuk selama kemuliaan TUHAN masih memenuhi kemah itu. ");
INSERT INTO ind_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Sepanjang perjalanan umat Israel, setiap kali awan itu naik dari atas kemah TUHAN, umat Israel berangkat melanjutkan perjalanan mereka. ");
INSERT INTO ind_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Selama awan itu tidak naik dari kemah, mereka tetap tinggal di tempat perkemahan. ");
INSERT INTO ind_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Awan TUHAN berdiam di atas kemah itu pada siang hari dan menjadi berapi pada malam hari, sehingga dapat terlihat setiap saat oleh seluruh umat Israel sepanjang perjalanan mereka.");
INSERT INTO ind_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Dari kemah-Nya, TUHAN memanggil Musa dan berkata kepadanya, ");
INSERT INTO ind_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Sampaikanlah kepada bangsa Israel: Pada waktu seseorang di antara kalian hendak mempersembahkan ternak kepada-Ku, kurban itu bisa berupa sapi, kambing, atau domba. ");
INSERT INTO ind_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Apabila kamu mempersembahkan sapi sebagai kurban yang dibakar habis, sapi itu haruslah jantan, muda, dan tidak bercacat. Supaya persembahanmu diterima, bawalah itu ke depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Letakkanlah tanganmu di atas kepala kurban itu, dan Aku akan menganggapnya layak untuk memulihkan hubunganmu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Lalu sembelihlah sapi itu di hadapan-Ku. Darahnya akan ditampung dan disiramkan oleh imam yang bertugas pada keempat sisi mezbah di depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","9","Lalu kamu akan menguliti dan memotongnya menjadi beberapa bagian, serta mencuci kaki dan seluruh isi perut kurban itu. Para imam bertanggung jawab mengurus api di mezbah. Mereka akan menyusun semua potongan kurban itu beserta kepala dan lemaknya di atas api mezbah. Selanjutnya, imam yang bertugas akan membakar semuanya itu sampai habis. Bau harum asap persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Apabila kamu mempersembahkan domba atau kambing sebagai kurban yang dibakar habis, hewan itu haruslah jantan dan tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Saat kamu membawa hewan itu, kamu akan menyembelihnya di hadapan-Ku di sebelah utara mezbah. Darah kurban itu akan ditampung dan disiramkan pada keempat sisi mezbah oleh imam. ");
INSERT INTO ind_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","Lalu kamu akan memotong kurban itu menjadi beberapa bagian, serta mencuci kaki dan seluruh isi perutnya. Imam akan menyusun semua potongan itu beserta kepala dan lemaknya di atas api di mezbah. Semuanya akan dibakar habis, dan bau harum asap persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Apabila kamu mempersembahkan burung sebagai kurban yang dibakar habis, burung itu haruslah burung tekukur atau anak burung merpati. ");
INSERT INTO ind_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Imam yang bertugas akan membawa burung itu ke mezbah, memelintir lehernya sampai terkoyak, dan membakarnya di atas mezbah itu. Darah burung itu haruslah dibiarkan mengalir sampai habis pada sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Imam akan mengambil kantong makanan yang ada pada leher burung itu beserta seluruh isinya, lalu melemparkannya ke sebelah timur mezbah, yaitu tempat abu dibuang. ");
INSERT INTO ind_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Selanjutnya, imam akan memegang burung itu pada kedua sayapnya dan menarik sayap itu dari badan, tetapi tidak boleh sampai putus. Imam kemudian membakar seluruhnya di atas mezbah. Bau harum asap saat persembahan itu dibakar akan menyenangkan Aku.” ");
INSERT INTO ind_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Pada waktu kamu hendak mempersembahkan gandum-ganduman kepada-Ku, apabila persembahan itu berupa tepung yang belum diolah, tepung itu haruslah yang terbaik, serta dituangi minyak zaitun dan ditaburi serbuk dupa di atasnya. ");
INSERT INTO ind_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Persembahan itu akan dibawa kepada para imam. Imam akan mengambil segenggam dari tepung yang sudah dicampuri minyak zaitun beserta semua dupa di atasnya, lalu membakarnya di atas mezbah sebagai tanda bahwa seluruh persembahan itu adalah milik-Ku. Bau harum asap persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Selebihnya dari persembahan gandum-ganduman itu akan menjadi bagian para imam. Semuanya itu sangat suci karena sudah dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Apabila persembahan gandum-gandumannya berupa roti yang dipanggang, roti itu harus dibuat dari tepung terbaik, tanpa ragi, dan dicampur dengan minyak zaitun, atau berupa roti tipis yang diolesi minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Persembahan itu harus dibuat dari tepung terbaik, tanpa ragi, dan dicampur dengan minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Roti itu akan dipatah-patahkan menjadi potongan kecil lalu dituangi minyak zaitun di atasnya. ");
INSERT INTO ind_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Apabila persembahan gandum-gandumannya berupa roti yang dimasak di panci, roti itu harus dibuat dari tepung terbaik yang dicampur dengan minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“Kamu boleh menyiapkan persembahan gandum-ganduman dengan salah satu cara tersebut. Serahkan persembahan itu kepada imam yang bertugas, dan dia akan membawanya ke mezbah. ");
INSERT INTO ind_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Dia akan mengambil segenggam dari persembahan itu dan membakarnya di atas mezbah sebagai tanda bahwa seluruh persembahan itu adalah milik-Ku. Bau harum asap persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Selebihnya dari persembahan itu akan menjadi bagian para imam. Semuanya itu sangat suci karena sudah dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Persembahan gandum-ganduman yang kamu bawa kepada-Ku harus diolah tanpa ragi, karena segala sesuatu yang mengandung ragi ataupun madu tidak boleh dipersembahkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","“Namun, gandum yang diolah dengan ragi atau madu boleh dibawa sebagai persembahan hasil panen pertama, tetapi jangan dibakar di atas mezbah untuk menghasilkan bau harum yang menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","“Taburkanlah garam pada semua persembahan gandum-gandumanmu, karena garam melambangkan perjanjian yang Aku buat dengan kalian. Jadi, pastikan agar kalian tidak lupa memberi garam pada semua persembahan gandum-ganduman. ");
INSERT INTO ind_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Apabila kamu memberikan persembahan gandum-ganduman bagi-Ku dari hasil panenmu yang pertama, berikanlah gandum baru yang sudah ditumbuk dan dipanggang di atas api. ");
INSERT INTO ind_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tuangkan minyak zaitun dan taruhlah serbuk dupa di atasnya, seperti yang dilakukan pada segala persembahan gandum-ganduman. ");
INSERT INTO ind_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Bagian yang sudah dituangi minyak beserta semua dupanya akan dibakar sebagai tanda bahwa seluruhnya diberikan kepada-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","TUHAN berkata lagi kepada Musa, “Pada waktu seseorang di antara kalian hendak mempersembahkan kurban tanda damai kepada-Ku, hewan itu haruslah yang tidak bercacat, boleh jantan atau betina. ");
INSERT INTO ind_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Bawalah persembahan itu ke depan mezbah-Ku dan letakkan tanganmu di atas kepala hewan itu sebelum menyembelihnya. Lalu imam yang bertugas akan menampung darah kurban itu dengan wadah dan menyiramkannya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Kemudian pisahkan semua lemak yang melapisi isi perut dan yang melekat pada bagian-bagian perut hewan itu, termasuk kedua ginjal dan bagian bawah hati. Semua itu diserahkan kepada imam supaya dibakar sampai habis di atas mezbah sebagai persembahan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kemudian imam akan membakar bagian-bagian tersebut di atas daging persembahan lain yang sedang dibakar habis di atas mezbah. Bau harum asap persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Kalau hewan yang kamu bawa sebagai kurban tanda damai adalah domba atau kambing, hewan itu boleh jantan atau betina, tetapi harus yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Apabila kurbanmu adalah seekor domba, bawalah itu ke hadapan-Ku di depan mezbah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Letakkanlah tanganmu di atas kepalanya dan sembelihlah domba itu. Kemudian imam akan menyiramkan darahnya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Lalu kamu akan memisahkan semua lemaknya untuk dipersembahkan, termasuk lemak di bagian ekor yang sudah dipotong dari dekat tulang punggung, semua lemak yang melapisi isi perut, dan lemak yang melekat pada bagian-bagian perutnya. ");
INSERT INTO ind_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Yang dipersembahkan juga termasuk kedua ginjal dan lemak yang melekat pada ginjal, lemak yang ada di dekat otot punggung bawah, serta bagian bawah hati. ");
INSERT INTO ind_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kemudian imam akan membakar semua bagian tersebut di atas mezbah sebagai persembahan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Apabila hewan yang kamu bawa sebagai kurban tanda damai adalah seekor kambing, bawalah itu ke hadapan-Ku di depan mezbah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Letakkanlah tanganmu di atas kepalanya dan sembelihlah kambing itu. Kemudian imam akan menyiramkan darahnya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Lalu kamu akan memisahkan semua lemaknya untuk dipersembahkan, termasuk semua lemak yang melapisi isi perut dan semua yang melekat pada bagian-bagian perutnya. ");
INSERT INTO ind_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Yang dipersembahkan juga termasuk dua ginjal dan lemak yang melekat pada ginjal, lemak yang ada di dekat otot punggung bawah, serta bagian bawah hati. ");
INSERT INTO ind_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Imam akan membakar semua bagian tersebut di atas mezbah sebagai persembahan bagi-Ku. Bau harum asap kurban itu akan menyenangkan Aku. Ingatlah bahwa semua lemak dari hewan yang dikurbankan adalah milik-Ku. ");
INSERT INTO ind_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Ini suatu ketetapan yang harus kalian patuhi turun-temurun di mana pun kalian tinggal: Kalian tidak boleh makan lemak ataupun darah dalam bentuk apa pun.” ");
INSERT INTO ind_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kemudian TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Sampaikanlah kepada umat Israel: Apabila seseorang tidak sengaja melanggar perintah-Ku sehingga dia berdosa, orang itu harus mengikuti aturan-aturan berikut supaya dosanya diampuni.” ");
INSERT INTO ind_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Apabila yang berdosa adalah imam besar sehingga seluruh umat Israel ikut dinyatakan berdosa, dia harus mempersembahkan kepada-Ku seekor sapi jantan muda yang tidak bercacat. Itu akan menjadi kurban penghapus dosa atas apa yang sudah dilakukannya. ");
INSERT INTO ind_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dia akan membawa sapi jantan itu ke hadapan-Ku di depan kemah-Ku. Dia harus meletakkan tangannya di atas kepala sapi itu dan menyembelihnya. ");
INSERT INTO ind_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kemudian dia akan membawa sebagian darah kurban yang ditampung dengan wadah ke dalam kemah-Ku, ");
INSERT INTO ind_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","mencelupkan salah satu jarinya ke dalam darah itu, dan memercikkannya tujuh kali ke arah tirai yang memisahkan ruang kudus dan ruang mahakudus. ");
INSERT INTO ind_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Sebagian dari darah kurban itu haruslah dia oleskan pada tanduk-tanduk mezbah dupa yang ada di dalam kemah, dan sisanya dicurahkan ke dasar mezbah kurban yang ada di depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Dari kurban sapi jantan itu dia akan memisahkan bagian-bagian ini: Semua lemak yang melapisi isi perut dan yang melekat pada bagian-bagian perut, ");
INSERT INTO ind_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","termasuk kedua ginjal, lemak yang melekat pada ginjal, dan bagian bawah hati. ");
INSERT INTO ind_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Langkah ini sama seperti ketika lemak diambil dari hewan kurban tanda damai. Kemudian imam yang bertugas akan membakar semuanya itu di mezbah. ");
INSERT INTO ind_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Tetapi semua bagian lain dari sapi itu, yakni kulit dan seluruh dagingnya, kepala, kaki, isi perut serta kotorannya ");
INSERT INTO ind_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","harus dibawa ke luar perkemahan oleh imam, lalu dia akan membakar semua itu sampai habis di atas kayu api di tempat pembuangan abu.” ");
INSERT INTO ind_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Apabila yang berdosa adalah seluruh umat Israel dengan tidak sengaja melanggar perintah-Ku, dan mereka sama sekali tidak menyadarinya, mereka tetap bersalah. ");
INSERT INTO ind_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ketika dosa itu diketahui, mereka harus membawa seekor sapi jantan muda ke depan kemah-Ku sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Para tua-tua setiap suku Israel akan meletakkan tangan mereka di atas kepala kurban itu dan menyembelihnya di hadapan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Darah kurban akan ditampung dalam wadah. Kemudian imam yang bertugas akan membawanya ke dalam kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Haruslah dia mencelupkan salah satu jarinya ke dalam darah itu dan memercikkannya tujuh kali ke arah tirai yang memisahkan ruang kudus dan ruang mahakudus. ");
INSERT INTO ind_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Sebagian dari darah itu harus dia oleskan pada tanduk-tanduk mezbah dupa yang ada di dalam kemah, dan sisa darah selebihnya dicurahkan ke dasar mezbah kurban yang ada di depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Lalu dia akan memisahkan semua lemak kurban itu dan membakarnya di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Tata cara untuk mempersembahkan kurban penghapus dosa bagi seluruh umat Israel sama persis dengan kurban penghapus dosa imam besar. Dengan demikian, imam akan memulihkan hubungan umat Israel dengan-Ku dan Aku akan mengampuni dosa mereka. ");
INSERT INTO ind_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kemudian imam akan membawa semua bagian lain dari sapi itu keluar perkemahan Israel lalu membakarnya sampai habis, sama seperti kurban penghapus dosa bagi imam besar. Itulah syarat-syarat untuk kurban penghapus dosa bagi semua umat Israel.” ");
INSERT INTO ind_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Apabila yang berdosa adalah seorang pemimpin Israel dengan tidak sengaja melanggar perintah-Ku, dia tetap bersalah. ");
INSERT INTO ind_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ketika dosa itu diketahui, dia harus membawa kambing jantan yang tidak bercacat sebagai kurban penghapus dosanya. ");
INSERT INTO ind_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Dia akan meletakkan tangannya di atas kepala kambing itu dan menyembelihnya di hadapan-Ku, yaitu di tempat penyembelihan kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kemudian imam akan mencelupkan salah satu jarinya ke darah kambing itu dan mengoleskannya pada tanduk-tanduk mezbah kurban. Sisa darah selebihnya dicurahkan ke dasar mezbah itu. ");
INSERT INTO ind_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Lalu imam akan membakar semua lemak kurban itu di atas mezbah, seperti yang dilakukan pada kurban tanda damai. Demikianlah imam akan memulihkan hubungan orang itu dengan Aku dan dosanya akan diampuni.” ");
INSERT INTO ind_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Apabila kamu, seorang umat Israel biasa, dengan tidak sengaja melanggar perintah-Ku, kamu tetap bersalah. ");
INSERT INTO ind_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ketika kamu mengetahui dosamu itu, kamu akan membawa kambing betina atau domba betina yang tidak bercacat sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Apabila persembahannya adalah kambing betina, kamu akan meletakkan tangannya di atas kepala kambing itu dan menyembelihnya di tempat penyembelihan kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kemudian imam akan mencelupkan salah satu jarinya ke darah kambing itu dan mengoleskannya pada tanduk-tanduk mezbah kurban. Sisa darah selebihnya dicurahkan ke dasar mezbah itu. ");
INSERT INTO ind_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kemudian kamu akan memisahkan semua lemak, seperti yang dilakukan pada kurban tanda damai. Lalu imam akan membakar semuanya itu di atas mezbah, sehingga bau harum asapnya menyenangkan Aku. Demikianlah imam akan memulihkan hubunganmu dengan Aku dan dosamu akan diampuni. ");
INSERT INTO ind_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Apabila persembahannya untuk kurban penghapus dosa adalah domba, domba itu haruslah seekor betina yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","35","Untuk mempersembahkan domba, ikutilah semua langkah untuk mempersembahkan kambing. Perbedaannya, imam akan meletakkan semua lemak domba itu di atas bagian-bagian lain yang sedang dibakar. Bau harum asapnya menyenangkan Aku. Demikianlah imam akan memulihkan hubunganmu dengan Aku dan dosamu akan diampuni.” ");
INSERT INTO ind_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","TUHAN melanjutkan perkataan-Nya kepada Musa untuk disampaikan kepada umat Israel, “Apabila kamu dipanggil ke pengadilan untuk menjadi saksi dalam suatu perkara yang pernah kamu lihat atau ketahui, tetapi kamu menolak untuk bersaksi, maka kamu harus mempersembahkan kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Apabila kamu dengan tidak sadar sudah menyentuh sesuatu yang najis, seperti bangkai binatang liar, bangkai hewan ternak, atau binatang yang berkeriapan di tanah, kamu menjadi najis. Ketika kamu sadar akan kesalahanmu itu, kamu harus mempersembahkan kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Apabila kamu dengan tidak sadar sudah menyentuh sesuatu yang najis yang berasal dari tubuh manusia, kamu menjadi najis. Ketika kamu sadar akan kesalahanmu itu, kamu harus mempersembahkan kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Apabila kamu dengan sembarangan bersumpah untuk melakukan suatu tindakan, entah hal yang baik ataupun yang buruk, kemudian kamu menyadari kesalahanmu itu, maka kamu harus mengakuinya dan mempersembahkan kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Jadi, ketika kamu melakukan kesalahan seperti itu, kamu harus mengakuinya. ");
INSERT INTO ind_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Lalu persembahkanlah kurban penghapus dosa, yaitu seekor kambing betina atau domba betina. Imam yang mempersembahkannya akan memulihkan hubunganmu dengan-Ku, dan dosamu akan diampuni. ");
INSERT INTO ind_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Apabila kamu tidak mampu mempersembahkan seekor kambing atau domba betina, kamu boleh menggantinya dengan dua ekor burung tekukur atau dua ekor anak burung merpati. Yang seekor menjadi kurban penghapus dosa dan yang lainnya menjadi kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Bawalah kedua burung itu kepada imam, lalu imam akan terlebih dahulu mempersembahkan salah satu sebagai kurban penghapus dosa. Dia akan memutar leher burung itu sampai patah, tetapi tidak boleh sampai putus. ");
INSERT INTO ind_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kemudian dia akan memercikkan sebagian darah kurban itu ke sisi mezbah, dan sisa darah selebihnya harus dibiarkan mengalir ke dasar mezbah. ");
INSERT INTO ind_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Selanjutnya dia akan mempersembahkan burung yang satu lagi sebagai kurban yang dibakar habis. Dengan demikian imam memulihkan hubunganmu dengan-Ku, dan dosamu akan diampuni. ");
INSERT INTO ind_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","12","“Namun, jika kamu sangat miskin dan tidak mampu membeli dua ekor burung tekukur atau dua ekor anak burung merpati, bawalah tepung yang terbaik sebanyak tiga liter sebagai kurban penghapus dosamu. Tetapi jangan menuangkan minyak zaitun dan menaruh serbuk dupa di atasnya, karena tepung itu adalah persembahan penghapus dosa. Bawalah tepung itu kepada imam. Dia akan mengambil segenggam dari tepung itu lalu membakarnya di atas kurban dan persembahan yang lain di mezbah. Segenggam tepung itu menjadi tanda bahwa persembahan itu seluruhnya milik-Ku. ");
INSERT INTO ind_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Dengan demikian imam memulihkan hubunganmu dengan-Ku, dan dosamu akan diampuni. Selebihnya dari tepung itu menjadi bagian untuk imam, sama seperti persembahan gandum-ganduman.” ");
INSERT INTO ind_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Lagi kata TUHAN kepada Musa untuk disampaikan kepada umat Israel, ");
INSERT INTO ind_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","16","“Kalau kamu lalai sehingga melakukan kekeliruan dengan jumlah persembahan yang harus kamu berikan kepada-Ku maka kamu berdosa. Kamu harus membayar denda 120% dari nilainya yang gagal kamu berikan. Denda itu akan diserahkan kepada imam yang bertugas. Kamu juga harus membawa kepada-Ku kurban penebus kesalahan, yaitu seekor domba jantan yang tidak bercacat. Imam akan menilai apakah domba itu layak dipersembahkan, serta menentukan harganya sesuai pengukur berat yang sah. Lalu imam akan mempersembahkan domba itu sebagai kurban untuk menebus kesalahan yang sudah kamu akui, dan Aku akan mengampunimu. ");
INSERT INTO ind_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Apabila kamu tanpa sadar melanggar perintah-Ku dengan melakukan apa yang sudah Aku larang, maka kamu harus mempersembahkan kurban penebus kesalahan. ");
INSERT INTO ind_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ketika kamu menyadari pelanggaranmu itu, kamu harus membawa seekor domba jantan yang tidak bercacat sebagai kurban penebus kesalahan. Imam akan menilai apakah domba itu layak dipersembahkan dan menentukan harganya. Dengan mempersembahkan kurban itu, imam memulihkan hubunganmu dengan-Ku dan dosamu akan diampuni. ");
INSERT INTO ind_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Demikianlah aturan untuk menebus kesalahan di hadapan Aku, TUHAN.” ");
INSERT INTO ind_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","TUHAN berkata lagi kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Inilah beberapa contoh kesalahan yang merupakan dosa terhadap-Ku: Menyangkal tentang barang yang dititipkan atau digadaikan kepadamu, merampok, menipu sesamamu, ");
INSERT INTO ind_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","menemukan barang hilang dan tidak mengaku kepada pemiliknya, bersumpah mengatakan yang benar padahal berbohong, atau bentuk kecurangan apa pun. ");
INSERT INTO ind_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Pada waktu kamu terbukti bersalah, kamu harus mengembalikan segala sesuatu yang kamu ambil dengan tidak jujur itu, serta membayar denda dua puluh persen dari nilai barang kepada pemiliknya. ");
INSERT INTO ind_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Kemudian kamu harus memberikan kurban penebus kesalahan kepada-Ku berupa seekor domba jantan yang tidak bercacat, dan yang harganya sesuai pengukur berat yang sah. Serahkanlah domba itu kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Lalu imam akan mempersembahkan domba itu untuk memulihkan hubunganmu dengan Aku, TUHAN, dan Aku akan mengampunimu atas kesalahan yang sudah kamu perbuat.” ");
INSERT INTO ind_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","TUHAN melanjutkan perkataan-Nya kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Sampaikanlah kepada para imam: Inilah peraturan tentang kurban yang dibakar habis. Daging kurban yang dibakar habis harus dibiarkan di atas mezbah sepanjang malam sampai pagi. Apinya harus tetap menyala. ");
INSERT INTO ind_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Pada pagi hari, imam yang bertugas akan memakai pakaian imam dari kain linen, termasuk celana dalam dan baju panjangnya, lalu mengumpulkan abu kurban yang tersisa di mezbah dan menaruhnya di samping mezbah. ");
INSERT INTO ind_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Sesudah itu, dia harus mengganti pakaiannya dan mengenakan pakaian biasa, lalu membawa abu itu keluar dari perkemahan dan membuangnya di tempat yang tidak najis. ");
INSERT INTO ind_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Api pada mezbah itu harus terus menyala, tidak boleh padam. Setiap pagi imam harus menambahkan kayu bakar dan mengatur kurban pagi yang dibakar habis di atasnya. Kemudian dia akan membakar lemak kurban tanda damai di atas daging kurban yang dibakar habis itu. ");
INSERT INTO ind_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Api pada mezbah harus dijaga agar tetap menyala, tidak boleh padam.” ");
INSERT INTO ind_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Inilah peraturan tentang persembahan gandum-ganduman: Para imam harus membawa persembahan itu ke depan mezbah sebagai persembahan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Imam akan mengambil segenggam tepung terbaik dari persembahan itu beserta minyak zaitun dan seluruh dupa di atasnya, lalu membakar semuanya itu di atas mezbah sebagai tanda bahwa persembahan itu seluruhnya milik-Ku. Bau harum persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sisa tepung dari persembahan itu akan diolah menjadi roti tidak beragi. Para imam akan memakannya di halaman kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Roti yang dibuat dari tepung itu tidak boleh mengandung ragi. Roti itu adalah bagian mereka dari berbagai makanan yang dipersembahkan di mezbah bagi-Ku. Roti itu sangat suci, sama seperti kurban penghapus dosa dan kurban penebus kesalahan. ");
INSERT INTO ind_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Setiap imam boleh memakan roti tersebut. Itulah bagian mereka turun-temurun dari berbagai makanan yang dipersembahkan di mezbah bagi-Ku. Selain imam, orang yang menyentuh roti itu akan celaka, karena roti itu suci dan dia tidak layak menyentuhnya.” ");
INSERT INTO ind_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","TUHAN juga berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Pada hari seorang keturunan Harun ditahbiskan sebagai imam, dia harus mempersembahkan tiga liter tepung yang terbaik sebagai persembahan gandum-ganduman kepada-Ku. Setengahnya dipersembahkan pada waktu pagi dan setengahnya lagi pada waktu sore, seperti persembahan gandum-gaduman yang dipersembahkan secara rutin setiap pagi dan sore. ");
INSERT INTO ind_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tepung itu harus dicampur dengan minyak zaitun lalu dipanggang. Sesudah itu, roti itu akan dipatahkan kecil-kecil lalu dipersembahkan kepada-Ku. Bau harum saat roti itu dibakar akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Setiap keturunan Harun yang ditahbiskan untuk menjadi imam harus memberikan persembahan gandum-ganduman seperti ini kepada-Ku. Persembahan itu harus dibakar habis seluruhnya. Peraturan ini berlaku selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Setiap persembahan gandum-ganduman yang dipersembahkan oleh seorang imam pada hari pentahbisannya haruslah dibakar habis seluruhnya. Sedikit pun tidak boleh dimakan.” ");
INSERT INTO ind_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Kemudian TUHAN berbicara lagi kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Sampaikanlah peraturan mengenai kurban penghapus dosa kepada para imam: Kurban penghapus dosa harus disembelih di hadapan-Ku, di tempat penyembelihan kurban yang dibakar habis. Persembahan ini sangat suci. ");
INSERT INTO ind_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Imam yang mempersembahkannya akan memakan daging kurban itu di halaman kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","29","Kurban itu sangat suci. Hanya laki-laki dari keturunan imam yang boleh memakannya. Orang lain yang menyentuh daging itu akan celaka. Apabila percikan darah hewan kurban itu mengenai pakaian, maka pakaian itu harus dicuci di dalam halaman kemah-Ku. Apabila daging kurban itu dimasak menggunakan periuk tanah liat, maka sesudahnya, periuk itu harus dipecahkan. Apabila menggunakan periuk logam, maka periuk itu harus digosok dan dibilas dengan air. ");
INSERT INTO ind_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Setiap daging kurban penghapus dosa yang darahnya dibawa ke dalam ruang kudus di kemah-Ku untuk memulihkan hubungan umat dengan-Ku tidak boleh dimakan, tetapi harus dibakar habis.” ");
INSERT INTO ind_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","TUHAN berkata kepada Musa, “Inilah peraturan tentang kurban penebus kesalahan. Kurban itu sangat suci. ");
INSERT INTO ind_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Setiap hewan yang dipersembahkan sebagai kurban penebus kesalahan harus disembelih di tempat penyembelihan kurban yang dibakar habis. Darah kurban itu harus disiramkan pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Semua lemak kurban itu, yakni lemak di bagian ekor dan lemak yang melapisi isi perut, ");
INSERT INTO ind_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kedua ginjal beserta lemak yang menempel padanya, dan bagian bawah hati ikut dipisahkan. ");
INSERT INTO ind_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","6","Imam akan membakar semuanya di atas mezbah sebagai persembahan bagi-Ku. Hanya laki-laki dari keturunan imam yang boleh makan daging dari kurban penebus kesalahan itu. Mereka harus memakannya di halaman kemah-Ku, karena kurban itu sangat suci. ");
INSERT INTO ind_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Peraturan untuk kurban penebus kesalahan sama seperti kurban penghapus dosa. Imam yang mempersembahkan kurban itu untuk memulihkan hubungan umat dengan-Ku akan mendapat dagingnya. ");
INSERT INTO ind_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Imam yang mempersembahkan kurban yang dibakar habis bagi seseorang akan mendapat kulit hewan kurban itu sebagai bagiannya. ");
INSERT INTO ind_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Setiap persembahan gandum-ganduman yang dimasak atau dipanggang menjadi bagian imam yang mempersembahkannya. ");
INSERT INTO ind_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tetapi segala persembahan gandum-ganduman yang mentah, baik yang sudah dicampur dengan minyak maupun yang kering, dibagi rata di antara semua keturunan Harun, yaitu para imam.” ");
INSERT INTO ind_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Inilah peraturan tentang kurban tanda damai yang boleh dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“Bila kamu mempersembahkan kurban itu sebagai ucapan syukur, maka hewan yang dikurbankan harus disertai dengan: roti tanpa ragi yang mengandung minyak zaitun, roti tipis kering tanpa ragi yang diolesi minyak zaitun, serta roti tebal yang dibuat dari tepung terbaik dicampur minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Selain itu, kamu juga harus mempersembahkan beberapa roti tebal yang dibuat dengan ragi. ");
INSERT INTO ind_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Satu buah dari setiap macam roti itu akan disisihkan. Persembahan itu akan menjadi bagian imam yang menyiramkan darah kurban tanda damai pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kamu dan keluargamu harus memakan habis daging kurban tanda damai pada hari kamu mempersembahkannya. Tidak boleh ada sisa sampai besok paginya. ");
INSERT INTO ind_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Namun, bila kurban itu adalah kurban sukarela atau kurban untuk memenuhi janjimu kepada-Ku, maka dagingnya boleh dimakan sampai hari kedua. ");
INSERT INTO ind_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Tetapi pada hari yang ketiga, daging kurban yang masih tersisa haruslah dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Apabila pada hari yang ketiga sisa daging itu dimakan, kurbanmu itu tidak Aku terima dan tidak membawa berkat apa pun bagimu. Daging itu sudah tercemar, dan orang yang memakan dagingnya akan menerima hukuman dari-Ku. ");
INSERT INTO ind_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Hanya orang yang sedang tidak najis yang boleh memakan daging kurban itu. Namun, apabila daging kurban itu terkena sesuatu yang najis, daging tersebut harus dibakar habis dan tidak boleh dimakan. ");
INSERT INTO ind_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Apabila seseorang yang sedang najis memakan daging kurban tanda damai yang dipersembahkan kepada-Ku, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Apabila orang yang memakan daging kurban itu sesudah menyentuh sesuatu yang najis, baik yang berasal dari manusia maupun segala binatang atau benda yang najis, maka orang itu juga akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","TUHAN berkata lagi kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Sampaikanlah kepada orang Israel: Jangan memakan lemak sapi, domba, ataupun kambing. ");
INSERT INTO ind_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Lemak hewan yang mati dengan sendirinya atau mati karena diterkam binatang buas tidak boleh dimakan, tetapi boleh digunakan untuk keperluan yang lain. ");
INSERT INTO ind_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Jika ada orang yang memakan lemak hewan yang dipersembahkan kepada-Ku, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Di mana pun kalian tinggal, kalian tidak boleh makan darah burung atau binatang meski diolah dalam bentuk apa pun. ");
INSERT INTO ind_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Siapa saja yang memakan darah akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","33","“Sampaikan kepada umat Israel: Jika kamu membawa kurban tanda damai, kamu harus memisahkan tiga bagian sebagai persembahan khusus bagi-Ku, yaitu semua lemak, rusuk kurban, paha kanan. Saat kamu sendiri membawanya kepada-Ku di mezbah, angkatlah tinggi semuanya itu sebagai persembahan khusus bagi-Ku. Kemudian imam yang bertugas akan menyiram darah kurban pada keempat sisi mezbah dan membakar lemak kurban itu di atas mezbah. Paha kanan itu diberikan kepada imam yang bertugas, sedangkan rusuk itu diberikan kepada semua imam. ");
INSERT INTO ind_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Aku sudah menetapkan bahwa rusuk dan paha kanan dari semua kurban tanda damai umat Israel menjadi milik para imam untuk selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Itulah bagian mereka turun-temurun dari berbagai makanan yang dipersembahkan di mezbah bagi-Ku, berlaku sejak mereka ditahbiskan menjadi imam untuk melayani Aku. ");
INSERT INTO ind_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Pada hari mereka ditahbiskan menjadi imam, bagian-bagian dari kurban itu sudah Aku tentukan untuk menjadi milik mereka. Ketetapan ini berlaku untuk selama-lamanya.” ");
INSERT INTO ind_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Demikianlah peraturan tentang kurban yang dibakar habis, persembahan gandum-ganduman, kurban penghapus dosa, kurban penebus kesalahan, kurban pentahbisan imam, dan kurban tanda damai. ");
INSERT INTO ind_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","TUHAN menyampaikan peraturan tentang semuanya itu kepada Musa ketika umat Israel masih tinggal di padang belantara Sinai. ");
INSERT INTO ind_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Panggillah Harun dan anak-anaknya yang laki-laki untuk ditahbiskan sebagai imam. Bawalah pakaian yang dikhususkan untuk imam, minyak pengurapan, sapi jantan sebagai kurban penghapus dosa, dua ekor domba jantan, dan satu keranjang roti yang tidak beragi. ");
INSERT INTO ind_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Lalu kumpulkanlah semua bangsa Israel di depan kemah-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa melakukan perintah TUHAN kepadanya, dan semua bangsa Israel berkumpul di depan kemah itu. ");
INSERT INTO ind_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Kemudian Musa berkata kepada mereka, “Pentahbisan yang akan kita lakukan ini adalah perintah TUHAN.” ");
INSERT INTO ind_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Lalu Musa menyuruh Harun dan anak-anaknya mendekat. Dia membasuh mereka dengan air. ");
INSERT INTO ind_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Sesudah itu Musa memakaikan pakaian imam kepada Harun, yaitu baju panjang, ikat pinggang kain, jubah, efod, dan ikat pinggang baju efod. ");
INSERT INTO ind_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Musa juga memakaikan penutup dada kepada Harun. Di dalam penutup dada itu diletakkan Urim dan Tumim yang gunanya untuk mengetahui kehendak Allah. ");
INSERT INTO ind_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Kemudian Musa mengikatkan serban pada kepala Harun. Pada bagian depan serban itu Musa sudah memasang medali emas, yang menandakan bahwa imam yang memakainya dikuduskan bagi TUHAN. Semuanya itu sesuai dengan apa yang sudah diperintahkan TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Lalu Musa mengambil minyak pengurapan. Dia mengoleskannya pada kemah TUHAN dan semua peralatan yang ada di dalamnya. Dengan demikian semuanya itu dikhususkan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Sebagian dari minyak pengurapan itu dipercikkan tujuh kali ke atas mezbah kurban dan dioleskan pada semua peralatannya, juga pada bejana pembasuhan serta tumpuannya. Dengan demikian semuanya itu dikhususkan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Sesudah itu Musa mentahbiskan Harun dengan menuangkan minyak pengurapan di atas kepalanya. Demikianlah Harun dikhususkan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Selanjutnya, Musa memanggil anak-anak Harun mendekat. Lalu Musa memakaikan baju panjang, ikat pinggang, serta melilitkan penutup pada kepala mereka. Musa melakukan semuanya itu sesuai dengan yang diperintahkan TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kemudian Musa mengambil sapi jantan muda untuk kurban penghapus dosa. Harun serta anak-anaknya meletakkan tangan mereka di atas kepala kurban itu. ");
INSERT INTO ind_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa lalu menyembelih sapi itu dan menampung sebagian darahnya. Dia mengoleskan darah kurban itu dengan jarinya pada keempat tanduk mezbah. Sisa darah selebihnya dia tuangkan pada dasar mezbah. Dengan demikian mezbah itu sudah disucikan dan dikhususkan bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Dari kurban itu, Musa mengambil lemak yang melapisi isi perut, lapisan lemak pada hati, dan kedua ginjal beserta lemaknya lalu membakar semuanya itu di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Segala bagian yang lain dari kurban penghapus dosa itu, termasuk daging, kulit, isi perut, dan kotorannya, diserahkannya kepada orang-orang yang sudah ditugaskan untuk membawa bagian-bagian itu keluar perkemahan untuk dibakar sampai habis. Hal itu juga dilaksanakan sesuai dengan apa yang sudah diperintahkan TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kemudian Musa mengambil domba jantan untuk kurban yang dibakar habis. Harun dan anak-anaknya meletakkan tangan mereka di atas kepala domba itu. ");
INSERT INTO ind_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa menyembelih domba itu, menampung darahnya, dan menyiramkannya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Kemudian Musa memotong-motong domba jantan itu menjadi beberapa bagian. Isi perut dan bagian kakinya dicuci dengan air. Musa mengambil kepala, lemak, dan bagian-bagian lainnya lalu membakar semua itu di atas mezbah. Musa melaksanakan semuanya sesuai dengan peraturan dari TUHAN, supaya bau harum kurban yang dibakar habis ini menyenangkan TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kemudian Musa membawa domba jantan yang lain untuk kurban pentahbisan imam. Harun dan anak-anaknya meletakkan tangan mereka di atas kepala domba tersebut. ");
INSERT INTO ind_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Selanjutnya Musa menyembelih domba jantan itu, mengambil darahnya, dan mengoleskannya pada telinga kanan Harun, pada ibu jari tangan kanan, dan pada ibu jari kaki kanannya. ");
INSERT INTO ind_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Musa meminta anak-anak Harun mendekat, lalu mengoleskan juga darah domba itu pada telinga kanan mereka, pada ibu jari tangan kanan, dan pada ibu jari kaki kanan mereka. Kemudian Musa menyiramkan sisa darah kurban pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Kemudian Musa mengambil semua lemak domba itu, baik lemak di bagian ekor maupun lemak yang melapisi isi perut, bagian bawah hati, kedua ginjal dengan lemaknya, dan paha kanan domba itu. ");
INSERT INTO ind_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Dari keranjang berisi roti tidak beragi yang sudah disiapkan untuk acara ini di hadapan TUHAN, Musa mengambil roti tebal yang dibuat dari tepung terbaik tanpa ragi, roti tebal yang dibuat dari tepung terbaik dicampur minyak zaitun, serta roti tipis kering, lalu meletakkannya di atas lemak dan paha kanan kurban itu. ");
INSERT INTO ind_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Musa menaruh semuanya di tangan Harun dan anak-anaknya, lalu mereka mengangkatnya tinggi sebagai persembahan khusus bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Sesudah itu Musa mengambil kembali semuanya itu dari tangan Harun dan anak-anaknya, lalu membakarnya di atas mezbah bersama dengan kurban yang dibakar habis untuk pentahbisan imam. Bau harum asap persembahan itu menyenangkan TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa mengambil dada domba itu dan mengangkatnya tinggi sebagai persembahan khusus bagi TUHAN. Itulah yang menjadi bagian Musa dari domba kurban pentahbisan imam, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Sesudah itu Musa mengambil sebagian minyak pengurapan dan mencampurnya dengan sebagian darah domba yang masih ada di mezbah. Lalu dia memercikkan campuran itu pada Harun dan anak-anaknya serta pakaian mereka. Dengan demikian Musa mengkhususkan mereka serta pakaian mereka bagi TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa berkata kepada Harun dan anak-anaknya, “Masaklah daging kurban pentahbisan itu di depan kemah TUHAN. Makanlah daging itu di sana bersama roti yang di dalam keranjang persembahan pentahbisan, sesuai dengan perintah TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kalau ada daging dan roti yang tersisa, haruslah kalian membakarnya habis. ");
INSERT INTO ind_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Masa pentahbisan kalian adalah tujuh hari. Selama tujuh hari itu kalian harus tetap tinggal di depan kemah TUHAN sampai upacara pentahbisan selesai. Kalian tidak boleh keluar dari halaman kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Semua yang sudah kita lakukan hari ini adalah sesuai dengan perintah TUHAN, untuk memulihkan hubungan kalian dengan TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kalian harus tetap tinggal di depan kemah TUHAN siang dan malam selama tujuh hari dan tetap melakukan segala yang TUHAN perintahkan. Jika kalian tidak melakukannya, kalian akan mati. Itulah yang diperintahkan TUHAN kepada saya.” ");
INSERT INTO ind_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Harun dan anak-anaknya melakukan semua yang TUHAN perintahkan kepada mereka melalui Musa. ");
INSERT INTO ind_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Upacara pentahbisan Harun dan anak-anaknya berlangsung selama tujuh hari. Pada hari berikutnya, Musa memanggil mereka serta para tua-tua umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Lalu Musa berkata kepada Harun, “Hari ini TUHAN akan menampakkan diri-Nya kepada kita. Oleh karena itu, persembahkanlah kepada TUHAN seekor sapi jantan muda sebagai kurban penghapus dosa bagi dirimu sendiri dan seekor domba jantan sebagai kurban yang dibakar habis. Kedua hewan itu haruslah yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Sampaikan juga kepada umat Israel untuk menyediakan seekor kambing jantan sebagai kurban penghapus dosa, juga seekor sapi dan seekor domba sebagai kurban yang dibakar habis, masing-masing berumur satu tahun dan tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Selain itu, sebagai kurban tanda damai persembahkanlah seekor sapi jantan dan seekor domba jantan. Keduanya dipersembahkan bersama persembahan gandum-ganduman berupa tepung yang dicampur dengan minyak. Hal-hal itu dilakukan sebagai persiapan, karena hari ini TUHAN akan menampakkan diri-Nya kepada kita.” ");
INSERT INTO ind_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Umat Israel membawa semua itu ke depan kemah TUHAN sesuai dengan yang diperintahkan Musa. Mereka mendekat dan berdiri di hadapan TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Lalu Musa berkata kepada mereka, “Inilah yang diperintahkan TUHAN untuk kita lakukan supaya kita dapat melihat cahaya kehadiran-Nya.” ");
INSERT INTO ind_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Sesudah itu, Musa berkata kepada Harun, “Sesuai dengan perintah TUHAN, persembahkanlah kurban penghapus dosa dan kurban yang dibakar habis untuk dirimu sendiri, supaya hubunganmu dengan TUHAN dipulihkan. Kemudian persembahkanlah semua kurban yang lain untuk umat Israel, supaya hubungan mereka dengan TUHAN dipulihkan.” ");
INSERT INTO ind_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Maka Harun menuju ke mezbah dan menyembelih sapi muda yang menjadi kurban penghapus dosa untuk dirinya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Anak-anaknya menampung darah kurban itu, lalu Harun mencelupkan satu jarinya ke dalam darah dan mengoleskannya pada keempat tanduk mezbah. Sisa darah selebihnya dituangkan ke dasar mezbah. ");
INSERT INTO ind_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Kemudian, sesuai peraturan yang sudah TUHAN perintahkan kepada Musa, Harun membakar lemak kurban, kedua ginjal, dan bagian bawah hati kurban tersebut di atas mezbah, ");
INSERT INTO ind_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","tetapi daging dan kulit hewan kurban itu dibakar habis di luar perkemahan. ");
INSERT INTO ind_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Kemudian Harun menyembelih hewan kurban yang dibakar habis bagi dirinya sendiri. Anak-anaknya menampung darah hewan kurban itu, lalu Harun menyiramkannya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Sesudah itu, anak-anaknya membawa kepada Harun kepala dan bagian-bagian lain dari kurban itu, dan Harun membakarnya di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Harun mencuci bagian-bagian isi perut dan keempat kaki kurban itu, lalu membakarnya di atas potongan-potongan kurban yang tadi, di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Sesudah itu, Harun mempersembahkan kambing yang disediakan sebagai kurban penghapus dosa bagi seluruh umat Israel. Harun menyembelih kambing itu dan mempersembahkannya persis seperti kurban penghapus dosa bagi dirinya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Selanjutnya Harun mempersembahkan kurban yang dibakar habis untuk seluruh umat Israel, sesuai peraturan yang sudah ditentukan. ");
INSERT INTO ind_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Harun juga mempersembahkan persembahan gandum-ganduman. Dia mengambil segenggam tepung dan membakarnya di atas mezbah. Semua persembahan itu diberikan tanpa mengabaikan kurban yang dibakar habis, yang dipersembahkan setiap pagi. ");
INSERT INTO ind_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Kemudian Harun menyembelih sapi jantan dan domba jantan untuk kurban tanda damai bagi umat Israel. Anak-anaknya memberikan kepada Harun darah kurban itu, lalu Harun menyiramkannya pada keempat sisi mezbah. ");
INSERT INTO ind_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Lemak dari kedua kurban itu— yakni lemak di bagian ekor, lemak yang melapisi isi perut, serta ginjal dan bagian bawah hati— ");
INSERT INTO ind_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","21","untuk sementara diletakkan di atas bagian rusuk dari kedua kurban itu. Lalu Harun mengangkat tinggi semua bagian tersebut bersama dengan kedua paha kanan sebagai persembahan khusus bagi TUHAN. Kemudian Harun meletakkan semua bagian lemak itu di atas mezbah, sedangkan kedua rusuk dan paha disimpan sebagai jatah imam. Semuanya itu dilakukan sesuai perintah Musa. ");
INSERT INTO ind_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sesudah Harun mempersembahkan kurban penghapus dosa, kurban yang dibakar habis, dan kurban tanda damai, dia mengangkat tangannya ke arah seluruh umat Israel dan berdoa meminta berkat atas mereka. Lalu dia turun dari samping tempat mezbah itu. ");
INSERT INTO ind_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Kemudian Harun dan Musa masuk ke dalam kemah TUHAN. Ketika mereka keluar, mereka berdoa meminta berkat lagi atas umat Israel. Pada saat itu juga, cahaya kehadiran TUHAN terlihat oleh seluruh umat. ");
INSERT INTO ind_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tiba-tiba api dari TUHAN turun menghanguskan kurban yang dibakar habis dan semua lemak yang ada di atas mezbah. Ketika umat melihatnya, mereka bersorak-sorai dan sujud menyembah TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Suatu hari, dua anak Harun yang bernama Nadab dan Abihu masing-masing mengambil wadah pembakaran dupa dan mengisinya dengan bara api. Mereka lalu meletakkan dupa di atas bara itu dan mempersembahkannya di hadapan TUHAN. Namun, tindakan itu melanggar perintah TUHAN karena TUHAN tidak menyuruh hal itu dilakukan. ");
INSERT INTO ind_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Maka keluarlah api menyambar dari hadapan TUHAN dan menghanguskan mereka berdua. ");
INSERT INTO ind_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kemudian Musa berkata kepada Harun, “Inilah yang TUHAN maksudkan waktu Dia berkata, ‘Semua imam dan orang Lewi yang melayani Aku harus menghormati-Ku. Ketika mereka melakukan pelanggaran dengan tidak menghormati kekudusan-Ku, maka aku akan menghukum mereka, sehingga seluruh umat-Ku melihatnya dan belajar menghormati-Ku juga.’” Harun hanya diam dan tidak mengatakan apa pun. ");
INSERT INTO ind_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Kemudian Musa memanggil Misael dan Elisafan, anak-anak Uziel, paman Harun. Katanya kepada mereka, “Datanglah kemari. Angkat dan bawalah mayat kedua sepupu kalian itu dari tempat kudus ini ke luar perkemahan.” ");
INSERT INTO ind_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Lalu Misael dan Elisafan membawa kedua mayat itu ke luar perkemahan, seperti yang diperintahkan Musa. Kedua anak Harun itu masih memakai baju panjang, pakaian imam. ");
INSERT INTO ind_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kemudian Musa berkata kepada Harun dan kedua anaknya yang lain, Eleazar dan Itamar, “Janganlah kalian berdukacita dengan cara mengoyakkan pakaian dan tidak menyisir rambut. Kalau kalian berdukacita, kalian pasti mati, dan semua umat Israel akan kena murka TUHAN. Biarlah hanya umat Israel yang berdukacita untuk Nabad dan Abihu yang mati karena api hukuman TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Janganlah meninggalkan halaman kemah TUHAN, supaya kalian tidak mati, karena kalian sudah ditahbiskan dengan minyak pengurapan untuk melayani TUHAN.” Harun dan anak-anaknya melakukan tepat seperti yang diperintahkan Musa. ");
INSERT INTO ind_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Lalu TUHAN berkata kepada Harun, ");
INSERT INTO ind_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Janganlah kamu dan kedua anakmu meminum anggur atau minuman keras sebelum masuk ke kemah-Ku. Bila kalian melanggar peraturan ini, kalian akan mati. Ini adalah ketetapan yang berlaku bagi para imam turun temurun untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kalian tidak boleh mabuk karena sebagai imam, kalian harus mampu membedakan antara sesuatu yang kudus dengan yang tidak kudus, dan antara yang najis dengan yang tidak najis, ");
INSERT INTO ind_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","juga supaya kalian dapat mengajarkan kepada umat Israel segala hukum yang sudah Aku berikan melalui Musa.” ");
INSERT INTO ind_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa berkata kepada Harun dan kepada kedua anaknya yang masih hidup, “Ambillah tepung dari sisa persembahan gandum-ganduman yang sudah dipersembahkan kepada TUHAN. Dari tepung itu buatlah roti tanpa ragi, lalu makanlah di samping mezbah, karena persembahan itu sangat kudus. ");
INSERT INTO ind_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Makanlah itu di halaman kemah TUHAN. Itulah yang menjadi bagianmu dan anak-anak lelakimu dari semua persembahan yang sudah diberikan kepada TUHAN. Itulah yang diperintahkan TUHAN kepadaku. ");
INSERT INTO ind_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Namun, untuk bagian dada dan paha kanan yang diangkat tinggi sebagai persembahan khusus bagi TUHAN, kamu dan anak-anakmu laki-laki maupun perempuan boleh memakannya di tempat yang tidak najis, sebab itulah yang menjadi bagian kalian dari kurban tanda damai. ");
INSERT INTO ind_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Paha kanan dan dada itu harus diangkat tinggi sebagai persembahan khusus bagi TUHAN, bersama dengan lemak yang akan dibakar di atas mezbah. Menurut perintah TUHAN, kedua bagian itu adalah milik kalian turun temurun untuk selamanya.” ");
INSERT INTO ind_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Tidak lama sesudah itu, ketika Musa menanyakan tentang kambing jantan kurban penghapus dosa, ternyata seluruh bagian daging kambing itu sudah dibakar habis. Maka Musa memarahi Eleazar dan Itamar dengan berkata, ");
INSERT INTO ind_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Mengapa kurban penghapus dosa itu tidak kalian makan di halaman kemah TUHAN? Kurban itu sangat suci! TUHAN memberikannya kepada kalian sebagai imbalan, karena kalian memikul tanggung jawab yang berat untuk memulihkan hubungan umat dengan TUHAN. ");
INSERT INTO ind_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Darah kurban kambing jantan itu tidak dibawa masuk ke kemah TUHAN. Itu berarti seharusnya kalian memakan kedua bagian daging kurban itu di halaman kemah TUHAN.” ");
INSERT INTO ind_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Jawab Harun kepada Musa, “Hari ini umat Israel mempersembahkan di hadapan TUHAN kurban penghapus dosa dan kurban yang dibakar habis. Namun, bencana besar telah menimpaku. Apakah TUHAN akan berkenan seandainya hari ini aku memakan daging dari kurban penghapus dosa itu?” ");
INSERT INTO ind_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mendengar jawaban itu, Musa pun memahami keadaan Harun. ");
INSERT INTO ind_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Katakan kepada umat Israel: Dari semua binatang yang hidup di darat, inilah yang Aku izinkan untuk kalian makan. ");
INSERT INTO ind_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Binatang yang berkuku belah sekaligus memamah biak boleh dimakan. ");
INSERT INTO ind_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Ada beberapa binatang yang memamah biak tetapi tidak berkuku belah, seperti unta, tikus gunung, dan kelinci. Binatang-binatang itu haram bagi kalian. ");
INSERT INTO ind_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Babi hutan juga haram bagi kalian, karena babi berkuku belah tetapi tidak memamah biak. ");
INSERT INTO ind_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Semua binatang tersebut haram. Jadi, kalian tidak boleh memakan dagingnya ataupun menyentuh bangkainya.” ");
INSERT INTO ind_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Dari semua binatang yang hidup di lautan dan di sungai, kalian hanya boleh memakan binatang yang memiliki sirip sekaligus sisik. ");
INSERT INTO ind_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Semua binatang yang tidak bersirip dan bersisik, atau yang berkeriapan, adalah haram bagi kalian. ");
INSERT INTO ind_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Jijiklah terhadap binatang-binatang itu. Kalian tidak boleh memakan dagingnya ataupun menyentuh bangkainya. ");
INSERT INTO ind_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Segala hewan air yang tidak memiliki sirip sekaligus sisik adalah haram.” ");
INSERT INTO ind_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Anggaplah haram dan jijiklah terhadap semua jenis burung ini: burung pemakan bangkai, burung elang hitam, ");
INSERT INTO ind_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","burung layang-layang, semua jenis burung elang, ");
INSERT INTO ind_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","semua jenis burung gagak, ");
INSERT INTO ind_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","burung hantu bertanduk, burung unta, burung camar, semua jenis rajawali, ");
INSERT INTO ind_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","burung pungguk, burung dendang air, ");
INSERT INTO ind_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","burung hantu putih, burung hantu padang pasir, burung nasar, ");
INSERT INTO ind_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","burung dandang, semua jenis bangau, hupo, dan kelelawar.” ");
INSERT INTO ind_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Anggaplah haram dan jijiklah terhadap semua jenis serangga bersayap yang merayap tetapi tidak bisa melompat. ");
INSERT INTO ind_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Namun, kalian boleh memakan semua jenis serangga bersayap yang merayap sekaligus mempunyai kaki belakang yang bisa ditekuk untuk melompat. ");
INSERT INTO ind_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kalian boleh makan semua jenis jangkrik dan belalang, seperti belalang pelahap dan belalang gandum. ");
INSERT INTO ind_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Tetapi jijiklah dan anggaplah haram segala jenis serangga bersayap lainnya yang merayap.” ");
INSERT INTO ind_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","“Apabila kamu menyentuh bangkai binatang-binatang haram ini, kamu menjadi najis sampai matahari terbenam: semua binatang yang berkuku satu, semua binatang berkuku belah yang tidak memamah biak, dan semua binatang berkaki empat yang berjalan dengan seluruh telapak kaki menyentuh tanah. Kalau kamu membawa atau menyentuh bangkai binatang-binatang seperti itu, kamu harus mencuci pakaianmu, dan kamu tetap dalam keadaan najis sampai matahari terbenam.” ");
INSERT INTO ind_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Kalian akan menjadi najis apabila bersentuhan dengan binatang kecil yang merayap atau berkeriapan, seperti tikus tanah, tikus kecil, tikus besar, semua jenis kadal, ");
INSERT INTO ind_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","tokek, cicak, bengkarung, siput, dan bunglon. ");
INSERT INTO ind_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Begitu juga, jika binatang itu mati dan kamu menyentuh bangkainya, kamu harus mencuci pakaianmu dan kamu tetap dalam keadaan najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Apabila ada salah satu dari binatang itu yang mati dan jatuh pada benda apa pun— baik yang terbuat dari kayu, kain, kulit binatang, maupun karung— benda itu menjadi najis. Barang-barang itu harus dicuci dengan air dan kalian tidak boleh menggunakannya sampai matahari terbenam. Sesudah itu barulah benda tersebut tidak najis lagi. ");
INSERT INTO ind_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Jika salah satu dari binatang itu jatuh ke dalam belanga tanah liat, maka segala sesuatu di dalamnya menjadi najis, dan kalian harus memecahkan belanga itu. ");
INSERT INTO ind_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Jika air dari belanga tersebut tumpah pada makanan apa pun, makanan itu menjadi najis. Kalian tidak boleh memakannya ataupun meminum air dari belanga yang najis itu. ");
INSERT INTO ind_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Apabila bangkai salah satu binatang tersebut jatuh ke atas benda yang terbuat dari tanah liat, misalnya alat pemanggang atau panci masak, maka benda itu menjadi najis dan harus dipecahkan. Kalian tidak boleh menggunakannya lagi. ");
INSERT INTO ind_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“Namun, jika bangkai binatang tersebut jatuh ke mata air atau kolam penyimpan air, air itu tidak menjadi najis dan masih boleh diminum. Tetapi siapa pun yang menyentuh bangkai itu menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Jika bangkai tersebut jatuh pada benih yang akan ditanam, benih tersebut tidak menjadi najis dan tetap dapat ditanam. ");
INSERT INTO ind_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Tetapi jika benih itu sudah direndam air dan kemudian bangkai jatuh ke atasnya, maka benih itu menjadi najis dan harus dibuang. ");
INSERT INTO ind_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Jika seekor binatang yang dagingnya boleh dimakan mati atau dibunuh oleh binatang lain, maka dagingnya menjadi najis. Siapa pun yang menyentuh bangkainya tetap dalam keadaan najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Siapa pun yang mengambil atau memakan daging bangkai binatang tersebut harus mencuci pakaiannya dan dia tetap dalam keadaan najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","“Jijiklah dan anggaplah haram semua jenis binatang yang merayap atau berkeriapan, termasuk binatang yang melata dan yang berkaki banyak. ");
INSERT INTO ind_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","45","Ingatlah bahwa Akulah TUHAN, yang sudah membebaskan kalian dari perbudakan di Mesir, supaya Aku menjadi Allah kalian. Akulah Allahmu yang kudus, yang kalian sembah! Karena itu jagalah dirimu agar kamu tetap hidup secara suci. Kamu harus hidup suci, karena Aku kudus. Janganlah menajiskan dirimu dengan memakan ataupun menyentuh binatang tersebut.” ");
INSERT INTO ind_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Demikianlah peraturan-peraturan tentang berbagai jenis hewan darat, burung, ikan, binatang laut, dan binatang yang merayap atau berkeriapan. ");
INSERT INTO ind_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kalian harus membedakan antara yang najis dan yang tidak najis, antara binatang yang boleh dimakan dan binatang yang tidak boleh dimakan. ");
INSERT INTO ind_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Sampaikanlah kepada bangsa Israel: Jika seorang wanita melahirkan anak laki-laki, dia menjadi najis selama tujuh hari. Keadaannya sama seperti saat dia sedang haid. ");
INSERT INTO ind_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pada hari kedelapan, bayi laki-laki itu harus disunat. ");
INSERT INTO ind_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Sesudah itu, ibunya dalam masa pentahiran selama tiga puluh tiga hari karena darah yang keluar dari rahimnya waktu melahirkan. Selama hari-hari itu, dia tidak boleh menyentuh apa pun yang kudus dan tidak boleh memasuki halaman kemah-Ku. Sesudah tiga puluh tiga hari itu berakhir, dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Jika seorang wanita melahirkan seorang anak perempuan, dia menjadi najis selama dua minggu. Keadaannya sama seperti saat dia sedang haid. Sesudah dua minggu itu, selama enam puluh enam hari berikutnya dia dalam masa pentahiran karena darah yang keluar dari rahimnya waktu melahirkan. ");
INSERT INTO ind_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Sesudah masa pentahiran seorang ibu berakhir— baik yang melahirkan bayi laki-laki maupun perempuan— dia harus membawa dua macam kurban kepada imam yang bertugas di depan kemah-Ku. Kedua kurban tersebut adalah seekor anak domba berumur setahun sebagai kurban yang dibakar habis, dan seekor burung tekukur atau seekor anak burung merpati sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Imam akan mempersembahkan kedua kurban itu untuk memulihkan hubungannya dengan-Ku. Sesudah itu, perempuan itu menjadi tahir.” Demikianlah peraturan bagi setiap ibu yang melahirkan, baik anak laki-laki maupun anak perempuan. ");
INSERT INTO ind_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Jika seorang ibu yang baru melahirkan tidak mampu mempersembahkan seekor anak domba, dia harus membawa dua ekor burung tekukur atau dua ekor anak burung merpati. Seekor untuk kurban yang dibakar habis, dan seekor lagi untuk kurban penghapus dosa. Imam akan mempersembahkan kedua kurban itu untuk memulihkan hubungannya dengan-Ku, dan sesudah itu dia menjadi tahir.” ");
INSERT INTO ind_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","TUHAN berkata kepada Harun dan Musa, ");
INSERT INTO ind_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Apabila seseorang memiliki bengkak, ruam, atau bercak terang pada kulitnya yang bisa menjadi penyakit kulit menular, dia harus menghadap kepada salah seorang imam yang bertugas. ");
INSERT INTO ind_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Imam akan memeriksa bagian kulit yang sakit pada orang itu. Jika bulu di daerah kulit yang terkena penyakit menjadi putih dan ada radang hingga di bagian dalam kulit, maka itu adalah penyakit menular. Imam akan menyatakan bahwa orang itu najis. ");
INSERT INTO ind_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Tetapi jika hanya ada bercak berwarna putih, dan bagian itu tidak terlihat lebih dalam daripada bagian kulit sekitarnya, serta warna bulunya tidak menjadi putih, maka imam akan menyuruh orang itu untuk mengasingkan diri dari antara umat selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pada hari ketujuh orang itu akan kembali untuk diperiksa lagi. Jika imam melihat bahwa penyakitnya masih sama dan tidak menyebar pada kulit, maka imam akan menyuruh orang itu mengasingkan diri selama tujuh hari lagi. ");
INSERT INTO ind_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Pada hari yang ketujuh sesudah pengasingan yang kedua, orang itu harus kembali untuk diperiksa lagi. Jika imam melihat bahwa penyakitnya memudar dan tidak menyebar, imam akan menyatakan bahwa orang itu tidak najis. Ruam itu tidak berbahaya. Kemudian orang itu harus mencuci pakaiannya, dan dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Tetapi jika dalam beberapa waktu sesudah imam menyatakan dia tidak najis, ternyata gejala penyakit kulit itu menyebar di kulitnya, dia harus kembali melapor kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Lalu imam akan memeriksa dia lagi. Jika benar bahwa penyakitnya itu memang sudah menyebar ke bagian kulit lainnya, maka imam akan menyatakan orang itu najis. Orang itu terkena penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Apabila seseorang terkena penyakit kulit, dia harus dibawa kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Imam akan memeriksanya. Jika di bagian kulitnya terjadi pembengkakan berwarna putih yang menyebabkan bulu di bagian itu juga menjadi putih, dan jika ada luka terbuka sehingga dagingnya terlihat, ");
INSERT INTO ind_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","maka orang itu menderita penyakit kulit menular. Imam akan menyatakan bahwa orang itu najis. Dengan keadaan seperti itu, imam tidak perlu mengasingkan dia untuk memantau keadaannya, karena sudah jelas bahwa dia najis. ");
INSERT INTO ind_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Akan tetapi, jika imam melihat bahwa penyakit tersebut sudah menyebar ke seluruh tubuh orang itu, dari atas kepalanya sampai ke kakinya, ");
INSERT INTO ind_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","dan jika seluruh kulitnya sudah menjadi putih, maka imam akan menyatakan bahwa orang itu tidak najis. ");
INSERT INTO ind_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Namun, jika ada luka terbuka sehingga dagingnya terlihat, orang itu najis. ");
INSERT INTO ind_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Setiap kali imam melihat luka terbuka, dia akan menyatakan bahwa orang itu dalam keadaan najis. Luka terbuka adalah najis. Gejala itu menandakan penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Tetapi jika luka yang terbuka itu sembuh dan memutih seperti warna kulit lainnya, dia harus kembali melapor kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Imam akan memeriksanya. Jika bekas luka itu sudah memutih, imam akan menyatakan bahwa orang itu tidak najis lagi. ");
INSERT INTO ind_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Apabila seseorang memiliki bisul di kulit lalu sembuh, ");
INSERT INTO ind_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","tetapi bekasnya menjadi bengkak berwarna putih atau muncul bercak putih kemerah-merahan, dia harus datang kepada imam untuk diperiksa. ");
INSERT INTO ind_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ketika imam memeriksanya dan menemukan bahwa nanah bisul sudah tembus ke dalam daging sekitarnya dan warna bulu di bagian itu menjadi putih, maka imam akan menyatakan bahwa orang itu najis. Bekas bisul itu sudah menjadi penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Namun, jika menurut pemeriksaan imam bulu di bekas bisul itu tidak memutih dan nanah bisul belum tembus ke bawah kulit sekitarnya, tetapi warnanya sedikit memudar, maka imam akan mengasingkan orang itu selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Jika selama pengasingan bercak itu menyebar, imam akan menyatakan orang itu najis. Gejala itu menandakan penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Tetapi jika bercak itu tidak berubah dan tidak menyebar, berarti itu hanya bekas bisul. Imam akan menyatakan bahwa orang itu tidak najis.” ");
INSERT INTO ind_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Apabila seseorang mengalami luka bakar dan daging pada luka itu menjadi putih atau putih kemerah-merahan, ");
INSERT INTO ind_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","maka dia harus menunjukkannya kepada imam. Jika warna bulu pada luka itu memutih dan permukaan kulit pada lukanya tampak lebih dalam daripada bagian kulit sekitarnya, maka penyakit kulit menular sudah muncul pada luka bakar itu. Imam akan menyatakan bahwa orang itu najis. ");
INSERT INTO ind_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Namun, jika menurut pemeriksaan imam bulu pada luka bakar itu tidak memutih dan permukaan kulit pada lukanya tidak tampak lebih dalam daripada permukaan kulit sekitarnya, tetapi warnanya memudar, imam akan menyuruh orang itu mengasingkan diri selama tujuh hari dari antara umat. ");
INSERT INTO ind_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pada hari ketujuh, orang itu harus kembali untuk diperiksa lagi. Jika ternyata luka itu menyebar di kulit, imam akan menyatakan bahwa orang itu najis. Orang itu menderita penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Jika bagian luka tidak menyebar, bahkan telah memudar, berarti itu hanya bengkak bekas luka bakar, dan imam akan menyatakan bahwa orang itu tidak najis.” ");
INSERT INTO ind_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Apabila seorang laki-laki atau perempuan terkena penyakit kulit di kepala atau di dagunya, ");
INSERT INTO ind_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","dia harus diperiksa oleh imam. Jika permukaan kulit yang sakit itu tampak lebih dalam daripada bagian kulit lainnya, dan rambut atau janggut di bagian itu menjadi lebih tipis serta berwarna kuning, maka imam akan menyatakan bahwa orang itu najis, karena dia menderita penyakit kulit menular di kepala atau dagunya. ");
INSERT INTO ind_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Jika menurut pemeriksaan imam permukaan kulit yang sakit itu tidak tampak lebih dalam daripada bagian kulit sekitarnya, tetapi tidak ada rambut sehat berwarna hitam pada bagian itu, imam akan mengasingkan orang itu selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pada hari ketujuh orang itu harus kembali untuk diperiksa. Jika penyakitnya tidak menyebar, tidak ada rambut kuning pada bagian kulit itu, dan permukaan kulit di bagian itu tidak terlihat lebih dalam daripada kulit sekitarnya, ");
INSERT INTO ind_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","maka orang itu harus mencukur rambut dan janggutnya, kecuali pada bagian kulit yang sakit. Lalu imam akan menyuruh orang itu mengasingkan diri selama tujuh hari lagi. ");
INSERT INTO ind_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Pada hari ketujuh orang itu akan diperiksa lagi. Jika penyakitnya tidak menyebar dan permukaan kulit yang sakit tidak lebih dalam daripada bagian kulit di sekitarnya, imam akan menyatakan bahwa orang itu sudah tidak najis. Orang itu harus mencuci pakaiannya, dan dia tidak najis lagi. ");
INSERT INTO ind_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Tetapi jika dalam beberapa waktu, sesudah imam menyatakan bahwa dia tidak najis, ternyata penyakit kulitnya menyebar, ");
INSERT INTO ind_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","maka orang itu harus kembali untuk diperiksa. Jika benar bahwa penyakitnya memang sudah menyebar, imam tidak perlu lagi mencari rambut berwarna kuning, karena orang itu sudah pasti najis. ");
INSERT INTO ind_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Namun, jika imam melihat bahwa penyakit kulit itu tidak menyebar, dan rambut sehat berwarna hitam sudah tumbuh di daerah itu, berarti penyakitnya sudah sembuh. Imam akan menyatakan bahwa orang itu tidak najis. ");
INSERT INTO ind_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Apabila seorang laki-laki atau perempuan memiliki bercak putih pada kulit, ");
INSERT INTO ind_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","dia harus diperiksa oleh imam. Jika bercak itu berwarna putih kusam, berarti itu hanya ruam yang tidak berbahaya, dan orang itu tidak najis. ");
INSERT INTO ind_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","“Jika rambut seseorang laki-laki rontok sampai dia menjadi botak, baik di bagian belakang maupun bagian depan kepalanya, dia tidak menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Namun, jika di bagian kepalanya yang botak terdapat kulit yang berwarna putih kemerahan, berarti orang itu menderita penyakit kulit menular. ");
INSERT INTO ind_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Imam akan memeriksanya. Bila ada bagian yang bengkak dan putih kemerah-merahan pada kepalanya yang botak itu dan terlihat seperti penyakit kulit menular, ");
INSERT INTO ind_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","imam akan menyatakan bahwa orang itu najis, karena penyakit kulit menular ada di kepalanya.” ");
INSERT INTO ind_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Seseorang yang menderita penyakit kulit menular harus memakai pakaian sobek dan tidak menyisir rambutnya. Dia juga harus menutupi bagian bawah mukanya, dan ketika pergi ke mana pun haruslah dia berteriak, ‘Jangan mendekat! Najis! Najis!’ ");
INSERT INTO ind_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Selama seseorang menderita penyakit kulit menular, dia tetap najis. Dia harus tinggal sendirian di luar perkemahan.” ");
INSERT INTO ind_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“Ada kalanya pakaian ditumbuhi jamur, baik pakaian yang ditenun dari wol, terbuat dari linen, maupun dari bahan kulit. ");
INSERT INTO ind_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Jika bagian pakaian berubah warna menjadi kehijauan atau kemerahan, itu tandanya ada jamur pada kain, dan harus ditunjukkan kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Imam akan memeriksanya, lalu menyuruh supaya pakaian itu ditaruh di tempat terpisah selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pada hari ketujuh pakaian itu harus ditunjukkan lagi kepada imam. Jika jamurnya menyebar, jelaslah bahwa itu adalah jamur yang menghancurkan pakaian, maka pakaian itu menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Pemiliknya harus membakar pakaian berjamur itu, karena itu adalah jamur yang parah dan dapat menular. ");
INSERT INTO ind_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Tetapi jika menurut pemeriksaan imam, jamur itu belum menyebar, ");
INSERT INTO ind_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","imam harus menyuruh pemilik pakaian untuk mencucinya. Kemudian pakaian itu akan ditaruh di tempat terpisah selama tujuh hari lagi. ");
INSERT INTO ind_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sesudah itu, pakaian tersebut harus ditunjukkan lagi kepada imam. Jika jamur itu tidak menyebar tetapi warnanya tetap sama, maka pakaian itu masih najis dan harus dibakar. Baik jamurnya berada di bagian dalam maupun di bagian luar, pakaian itu tetap harus dibakar. ");
INSERT INTO ind_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tetapi jika menurut pemeriksaan imam jamurnya memudar sesudah pakaian itu dicuci, maka dia akan menyobek dan membuang bagian yang berjamur pada pakaian itu. ");
INSERT INTO ind_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Jika dalam beberapa waktu jamur itu tumbuh kembali pada pakaian tersebut, berarti jamur itu menyebar, dan pakaian itu harus dibakar. ");
INSERT INTO ind_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Jika sesudah pakaian itu dicuci jamurnya hilang, maka pakaian itu harus dicuci untuk kedua kalinya, kemudian pakaian itu tidak najis lagi.” ");
INSERT INTO ind_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Demikianlah peraturan mengenai jamur pada pakaian yang terbuat dari wol, linen, atau bahan kulit, untuk menentukan apakah pakaian itu najis atau tidak. ");
INSERT INTO ind_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Bila penderita penyakit kulit telah sembuh, kesembuhan itu harus diberitahukan kepada imam, supaya imam melakukan upacara penyucian baginya. ");
INSERT INTO ind_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Imam akan pergi ke luar perkemahan untuk memeriksa dia. Jika penyakitnya memang sudah sembuh, ");
INSERT INTO ind_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","imam akan mengadakan upacara penyucian sebagai berikut: Penderita penyakit kulit yang sudah sembuh diminta membawa dua ekor burung hidup yang tidak haram, sepotong kayu aras, seutas tali merah, dan beberapa ranting hisop. ");
INSERT INTO ind_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kemudian imam akan memerintahkan agar salah satu burung itu disembelih di atas kuali tanah liat yang berisi air bersih dari mata air, supaya darahnya jatuh ke dalam air tersebut. ");
INSERT INTO ind_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Selanjutnya imam mengambil burung yang masih hidup dan mencelupkannya bersama dengan batang kayu aras, tali merah, dan ranting hisop ke dalam campuran air dan darah burung yang sudah disembelih tadi. ");
INSERT INTO ind_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Dengan semua benda yang dicelupkan itu, imam akan memercikkan campuran air dan darah tersebut tujuh kali pada orang yang sudah sembuh itu. Imam akan menyatakan bahwa orang itu sudah tidak najis lagi. Kemudian imam akan melepaskan burung yang masih hidup supaya terbang bebas. ");
INSERT INTO ind_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Orang yang sudah sembuh dari penyakit kulit tadi harus mencuci pakaiannya, mencukur habis rambutnya, lalu mandi. Sesudah itu, dia tidak najis lagi dan boleh masuk ke perkemahan. Namun, dia masih harus tinggal di luar kemahnya selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pada hari ketujuh, dia harus mencukur semua rambutnya, jenggotnya, alisnya, bahkan seluruh bulu di tubuhnya. Kemudian dia harus mencuci pakaiannya dan mandi. Sesudah itu dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Pada hari kedelapan, orang itu harus membawa dua ekor anak domba jantan dan seekor anak domba betina yang berumur satu tahun, semuanya yang tidak bercacat. Dia juga harus membawa enam liter tepung terbaik yang dicampur minyak zaitun sebagai persembahan gandum-ganduman, serta sepertiga liter minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Imam yang bertugas dalam upacara penyucian akan membawa orang itu dan persembahannya ke hadapan-Ku di depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","13","“Kemudian imam akan menyembelih salah satu anak domba jantan sebagai kurban penebus kesalahan. Anak domba itu harus disembelih di tempat khusus di sebelah utara mezbah, yaitu tempat penyembelihan kurban penghapus dosa dan kurban yang dibakar habis. Hal ini dilakukan karena kurban penebus kesalahan, sama seperti kurban penghapus dosa, adalah sangat kudus dan menjadi bagian imam. Lalu di hadapan-Ku, imam akan mengangkat tinggi daging kurban itu bersama minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Selanjutnya imam harus mengambil sebagian dari darah domba itu dan mengoleskannya ke daun telinga kanan, ibu jari tangan kanan, dan ibu jari kaki kanan orang yang sedang disucikan itu. ");
INSERT INTO ind_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Kemudian imam akan mengambil sebagian dari minyak zaitun dan menuangkannya ke telapak tangan kirinya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Berikutnya dia akan mencelupkan jari tangan kanannya ke dalam minyak yang ada di telapak tangan kirinya itu, dan memercikkannya tujuh kali ke arah kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kemudian imam akan mengoleskan minyak yang masih ada di telapak tangannya ke daun telinga kanan, ibu jari tangan kanan, dan ibu jari kaki kanan orang yang sedang disucikan. Dia akan mengoleskannya di atas darah yang sudah dioleskan sebelumnya. ");
INSERT INTO ind_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Minyak yang tersisa di telapak tangan imam akan dioleskan ke atas kepala orang itu. Dengan demikian imam memulihkan hubungan orang itu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Berikutnya, imam akan mempersembahkan domba betina sebagai kurban penghapus dosa untuk memulihkan hubungannya dengan-Ku. Kemudian imam akan menyembelih kurban yang dibakar habis ");
INSERT INTO ind_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","dan mempersembahkannya di atas mezbah beserta dengan persembahan gandum-ganduman.” Demikianlah peraturan untuk upacara penyucian yang dilakukan imam untuk memulihkan hubungan orang yang pernah menderita penyakit kulit dengan TUHAN. Dengan demikian orang itu tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Jika orang yang sudah sembuh itu miskin dan tidak mampu menyediakan semua hewan kurban tadi, dia harus membawa kepada imam seekor domba jantan yang akan diangkat tinggi sebagai kurban penebus kesalahan, tiga liter tepung terbaik yang dicampur dengan minyak zaitun sebagai persembahan gandum-ganduman, serta sepertiga liter minyak zaitun. Dengan demikian imam akan memulihkan hubungan orang itu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Dia juga harus membawa dua ekor burung tekukur atau dua ekor anak burung merpati, yang satu untuk kurban penghapus dosa, dan yang satunya untuk kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Pada hari kedelapan sesudah dia tinggal di luar kemahnya, orang yang sudah sembuh itu harus membawa ketiga kurban tersebut ke hadapan-Ku di depan kemah-Ku, supaya imam melakukan upacara penyuciannya. ");
INSERT INTO ind_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","29","Imam akan melakukan semua langkah pengurbanan anak domba jantan sebagai kurban penebus kesalahan sama seperti yang diuraikan di atas. Daging kurban itu beserta minyak zaitun diangkat tinggi di hadapan-Ku. Darah domba itu dioleskan pada daun telinga kanan, ibu jari tangan kanan, dan ibu jari kaki kanan orang yang sedang disucikan. Sesudah imam memercikkan minyak zaitun ke arah kemah-Ku sebanyak tujuh kali, dia akan mengoleskannya pada ketiga tempat yang sama dengan darah tadi, dan sisanya dioleskan pada kepala orang yang sedang disucikan itu. Dengan demikian imam memulihkan hubungan orang itu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Kemudian imam harus mempersembahkan kedua burung tekukur atau anak burung merpati. Orang itu boleh membawa yang mana saja sesuai kemampuannya. ");
INSERT INTO ind_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","32","Burung yang satu akan dipersembahkan sebagai kurban penghapus dosa, dan yang satunya lagi sebagai kurban yang dibakar habis. Kedua burung itu dipersembahkan di mezbah bersama persembahan gandum-ganduman.” Demikianlah peraturan upacara penyucian bagi orang yang pernah menderita penyakit kulit, bila dia tidak mampu memberikan persembahan sesuai dengan peraturan pertama. Imam memulihkan hubungannya dengan TUHAN sebab dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ketika kalian sudah memasuki negeri Kanaan yang telah Aku berikan menjadi milik kalian, lalu Aku membuat jamur tumbuh di dalam beberapa rumah kalian, ");
INSERT INTO ind_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","maka pemilik rumah harus datang kepada imam dan memberitahukan, ‘Ada sesuatu yang kelihatan seperti jamur tumbuh di rumahku.’ ");
INSERT INTO ind_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Sebelum imam datang memeriksa, dia akan memerintahkan supaya rumah itu dikosongkan. Itu dilakukan supaya barang-barang lain tidak ikut dinyatakan najis. Sesudah itu imam akan datang untuk memeriksa rumah tersebut. ");
INSERT INTO ind_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ketika imam memeriksa jamur itu dan tampak warna kehijauan atau kemerahan pada dinding, serta kelihatan lebih dalam daripada permukaan dinding lainnya, ");
INSERT INTO ind_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","imam akan keluar dari rumah itu dan menguncinya selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pada hari ketujuh imam akan memeriksanya kembali. Jika jamur di dinding ternyata sudah menyebar, ");
INSERT INTO ind_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","imam akan menyuruh agar batu-batu di dinding yang terkena jamur itu dicungkil, lalu dibuang ke tempat pembuangan barang najis di luar kota. ");
INSERT INTO ind_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Selanjutnya, seluruh bagian dalam dinding rumah itu harus dikikis. Semua plester hasil kikisan harus dibuang ke tempat pembuangan barang najis di luar kota. ");
INSERT INTO ind_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Batu-batu baru akan dipasang untuk mengganti batu-batu yang terkena jamur tadi, dan seluruh dinding rumah yang sudah dikikis akan dilapisi dengan plester baru. ");
INSERT INTO ind_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Jika jamur timbul lagi di rumah itu sesudah batu-batu dan plesternya diganti, ");
INSERT INTO ind_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","imam harus kembali memeriksa rumah tersebut. Apabila jamurnya sudah menyebar, dapat dipastikan bahwa jamur itu adalah jenis yang merusak rumah, sehingga rumah itu najis. ");
INSERT INTO ind_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Rumah itu harus dirobohkan seluruhnya, lalu semua batunya, kayunya, dan plesternya harus dibuang ke tempat pembuangan barang najis di luar kota. ");
INSERT INTO ind_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Siapa pun yang masuk ke rumah itu selama dalam keadaan tertutup karena kenajisan, orang itu juga menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Dan siapa pun yang tidur atau makan di dalam rumah itu harus mencuci pakaiannya. ");
INSERT INTO ind_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Tetapi jika setelah batu dan plester rumah itu diganti, imam memeriksanya dan melihat bahwa jamur itu tidak timbul kembali, maka imam akan menyatakan bahwa rumah itu tidak najis lagi. ");
INSERT INTO ind_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Untuk penyucian rumah, inilah yang perlu disediakan bagi imam yang bertugas: dua ekor burung kecil, sepotong kayu aras, seutas tali merah, dan beberapa ranting hisop. ");
INSERT INTO ind_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Imam akan menyembelih seekor burung di atas kuali tanah liat yang berisi air bersih dari mata air, supaya darahnya jatuh ke dalam air itu. ");
INSERT INTO ind_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Lalu imam akan mengambil burung yang masih hidup dan mencelupkannya bersama kayu aras, tali merah, dan ranting hisop ke dalam campuran air dan darah burung yang sudah disembelih tadi. Dengan semua benda yang dicelupkan itu, imam akan memercikkan campuran air dan darah pada rumah itu tujuh kali. ");
INSERT INTO ind_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Dengan demikian imam sudah melakukan upacara penyucian untuk rumah tersebut. ");
INSERT INTO ind_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kemudian imam akan melepaskan burung yang masih hidup supaya terbang bebas. Demikianlah imam sudah menyucikan rumah itu dan memulihkan hubungan pemiliknya dengan Aku.” ");
INSERT INTO ind_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","57","Demikianlah peraturan-peraturan mengenai penyakit kulit menular, termasuk luka gatal, bengkak, ruam, bintik-bintik putih, serta jamur pada pakaian dan rumah. Petunjuk ini harus diikuti guna menentukan sesuatu najis atau tidak najis. ");
INSERT INTO ind_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Sampaikanlah pesan ini kepada orang Israel: Apabila seorang laki-laki terkena penyakit yang menyebabkan alat kelaminnya sering mengeluarkan cairan, dia menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Baik cairan itu keluar terus-menerus ataupun tersumbat, dia tetap najis. ");
INSERT INTO ind_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Setiap tempat tidur yang dia pakai dan setiap barang yang dia duduki akan menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","7","Siapa pun yang menyentuh tempat tidur orang yang mengeluarkan cairan itu, atau menduduki barang yang telah dia duduki, atau bersentuhan dengan dia, harus mencuci pakaiannya dan mandi, dan dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Apabila orang yang mengeluarkan cairan itu meludah kepada seseorang yang tidak najis, maka orang yang kena ludahnya harus mencuci pakaiannya dan mandi, dan dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Pelana kuda atau keledai yang diduduki orang yang mengeluarkan cairan juga akan menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Siapa pun yang menyentuh barang yang dia duduki menjadi najis sampai matahari terbenam. Siapa pun yang mengangkat barang itu harus mencuci pakaiannya dan mandi, dan dia juga menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Jika orang yang mengeluarkan cairan itu menyentuh orang lain tanpa mencuci tangannya terlebih dahulu, maka orang yang disentuhnya itu harus mencuci pakaiannya dan mandi, dan dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Jika orang yang mengeluarkan cairan itu menyentuh periuk tanah, maka periuk itu harus dipecahkan. Apabila dia menyentuh alat yang terbuat dari kayu, alat itu harus dicuci dengan air. ");
INSERT INTO ind_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Setelah tujuh hari sembuh dari penyakitnya, dia akan menjalani penyucian. Dia harus mencuci pakaiannya dan mandi di air mengalir. Sesudah itu dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Besoknya, yaitu hari yang kedelapan, dia harus membawa dua ekor burung tekukur atau dua ekor anak burung merpati ke depan kemah-Ku, lalu menyerahkannya kepada imam yang bertugas. ");
INSERT INTO ind_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Imam akan mempersembahkan yang seekor untuk kurban penghapus dosa, dan yang satunya sebagai kurban yang dibakar habis. Dengan demikian, imam sudah memulihkan hubungan orang itu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Apabila seorang laki-laki mengeluarkan air mani, dia harus membasuh seluruh tubuhnya dengan air, dan dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Jika air mani itu mengenai pakaian atau bahan kulit apa pun, barang itu harus dicuci dan menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Setiap laki-laki dan perempuan harus mandi sesudah bersetubuh. Dengan adanya air mani yang keluar, mereka menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Ketika seorang perempuan sedang haid, dia menjadi najis selama tujuh hari. Siapa pun yang bersentuhan dengannya selama itu akan menjadi najis juga sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Alas tidur yang dia pakai berbaring dan benda apa pun yang diduduki perempuan yang sedang haid menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Siapa pun yang menyentuh tempat tidurnya atau barang apa pun yang dia duduki harus mencuci pakaiannya, dan orang itu juga menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Jika seorang laki-laki bersetubuh dengan seorang perempuan yang sedang haid dan laki-laki itu terkena darah haidnya, maka lelaki itu juga menjadi najis selama tujuh hari. Tempat tidur yang dipakainya pun menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Ketika seorang perempuan mengalami pendarahan dalam waktu lama yang bukan pada masa haidnya, atau jika pendarahannya berlanjut sesudah masa haidnya berakhir, dia tetap najis selama pendarahan itu, sama seperti pada saat haid. ");
INSERT INTO ind_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Setiap tempat tidur di mana dia berbaring dan benda apa pun yang dia duduki selama pendarahan menjadi najis, sama seperti saat dia sedang haid. ");
INSERT INTO ind_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Siapa pun yang menyentuh benda-benda itu harus mencuci pakaiannya lalu mandi, dan dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Setelah pendarahan itu berhenti, dia harus menunggu tujuh hari, sesudah itu barulah dia tidak najis lagi. ");
INSERT INTO ind_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Besoknya, yaitu hari yang kedelapan, dia harus membawa dua ekor burung tekukur atau dua ekor anak burung merpati kepada imam di depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Imam akan mempersembahkan yang seekor untuk kurban penghapus dosa, dan yang lainnya untuk kurban yang dibakar habis. Dengan demikian imam memulihkan hubungan perempuan itu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Dengan cara demikianlah kalian umat Israel harus menjaga diri dari kenajisan, supaya kenajisanmu tidak menodai kemah-Ku yang ada di tengah-tengah kalian, dan supaya kalian tidak kena hukuman mati.” ");
INSERT INTO ind_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Demikianlah peraturan untuk laki-laki yang sedang najis karena penyakit yang membuat alat kelaminnya mengeluarkan cairan, atau karena air maninya keluar, ");
INSERT INTO ind_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","dan demikianlah peraturan untuk perempuan selama masa haidnya, juga laki-laki yang bersetubuh dengan perempuan yang sedang haid. Peraturan ini berlaku untuk setiap orang, baik laki-laki maupun perempuan, yang alat kelaminnya mengeluarkan cairan. ");
INSERT INTO ind_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Sesudah kematian dua anak Harun, yang mati karena datang ke hadapan TUHAN dengan cara yang tidak sesuai peraturan-Nya, TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Beritahukanlah kepada kakakmu Harun agar tidak sembarangan masuk ke ruang mahakudus yang dipisahkan dengan tirai, sebab di sana Aku memperlihatkan diri dalam awan di atas tutup peti perjanjian. Apabila dia melanggar perintah ini, dia akan mati. ");
INSERT INTO ind_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","4","Untuk diperbolehkan masuk ke ruang mahakudus, Harun harus mengikuti peraturan ini: Dia harus memakai seluruh pakaian imam, termasuk celana dalam, baju panjang, ikat pinggang, dan penutup kepala, yang semuanya terbuat dari kain linen. Dia harus mandi sebelum mengenakannya, karena pakaian itu suci. Dia harus mempersembahkan dua kurban untuk dosanya sendiri, yaitu seekor sapi jantan muda sebagai kurban penghapus dosa dan seekor domba jantan untuk kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Pada Hari Pendamaian, umat Israel akan membawa kepada Harun dua ekor kambing jantan untuk kurban penghapus dosa dan seekor domba jantan untuk kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Harun akan mempersembahkan seekor sapi jantan muda miliknya sendiri sebagai kurban penghapus dosa, untuk memulihkan hubungan dia dan keluarganya dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Lalu dia akan mengambil kedua ekor kambing jantan dari umat Israel dan membawanya ke depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Dia akan mengundi untuk memilih antara kedua kambing jantan itu. Yang terpilih akan dipersembahkan kepada-Ku, dan yang satunya akan dilepas ke padang belantara untuk menanggung hukuman dosa umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Selanjutnya, dia akan mempersembahkan kambing yang terpilih bagi-Ku sebagai kurban penghapus dosa, ");
INSERT INTO ind_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","sedangkan kambing yang terpilih untuk dilepas harus tetap berdiri di hadapan-Ku sampai kambing yang pertama dikurbankan. Lalu kambing kedua itu akan dibawa hidup-hidup ke padang belantara untuk memulihkan hubungan umat Israel dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Setelah Harun menyembelih sapi jantan muda miliknya sendiri sebagai kurban penghapus dosa untuk dirinya dan keluarganya, ");
INSERT INTO ind_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","dia akan mengisi wadah pembakaran dupa dengan bara api dari mezbah-Ku serta mengambil dua genggam serbuk dupa harum, lalu membawanya ke ruang mahakudus di belakang tirai pemisah. ");
INSERT INTO ind_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Di sana, di hadapan-Ku, dia akan menaburkan dupa itu di atas bara api, supaya asapnya menutupi penutup peti yang ada di atas peti perjanjian, yaitu tempat Aku memperlihatkan diri. Dengan demikian, Harun tidak dapat melihat kehadiran-Ku secara langsung, sehingga dia tidak mati. ");
INSERT INTO ind_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Berikutnya dia akan mengambil sedikit darah sapi itu dengan ujung jarinya dan memercikkannya tujuh kali ke arah sisi depan peti itu, yaitu sisi yang menghadap ke timur. ");
INSERT INTO ind_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Sesudah keluar dari kemah-Ku, dia akan menyembelih kambing yang terpilih bagi-Ku sebagai kurban penghapus dosa umat Israel. Dia akan membawa darah kambing itu ke dalam ruang mahakudus lalu memercikkannya tujuh kali ke arah sisi depan peti, seperti yang dilakukannya dengan darah sapi tadi. ");
INSERT INTO ind_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Dengan cara itu, Harun menyucikan ruang mahakudus dan seluruh kemah-Ku dari kenajisan dan dosa-dosa umat Israel, sehingga hubungan umat dengan-Ku dipulihkan. ");
INSERT INTO ind_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“Sementara Harun keluar dan masuk di ruang mahakudus untuk melakukan setiap langkah upacara pendamaian sampai selesai, tidak boleh ada orang lain di dalam kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Selanjutnya, untuk menyucikan mezbah-Ku, dia akan mengambil sedikit darah sapi dan darah kambing tadi dan mengoleskannya pada keempat tanduk mezbah kurban. ");
INSERT INTO ind_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Lalu dengan jarinya, dia akan memercikkan darah itu tujuh kali ke atas mezbah untuk menyucikan mezbah itu dari kenajisan umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Sesudah menyelesaikan upacara pendamaian untuk ruang mahakudus, kemah-Ku, dan mezbah kurban, Harun akan membawa ke hadapan-Ku kambing hidup yang terpilih untuk dilepaskan. ");
INSERT INTO ind_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Dia akan meletakkan kedua tangannya di atas kepala kambing itu, dan sebagai wakil seluruh umat Israel, dia akan mengakui semua dosa dan pelanggaran mereka. Tindakan itu menjadi lambang bahwa seluruh beban dosa ditaruh ke atas kepala kambing itu. Lalu seseorang yang sudah ditugaskan akan membawa dan melepaskan kambing itu di tempat yang jauh di padang belantara. ");
INSERT INTO ind_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Demikianlah kambing itu akan membawa semua dosa umat Israel ke tempat yang sunyi di padang belantara. Kambing itu akan dibiarkan lepas di sana. ");
INSERT INTO ind_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Kemudian Harun akan masuk ke kemah-Ku, melepaskan pakaian imam yang dipakainya ketika masuk ke ruang mahakudus, dan meninggalkannya di sana. ");
INSERT INTO ind_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Lalu dia akan mandi di dalam halaman kemah-Ku dan memakai pakaian yang biasa dipakainya. Kemudian dia akan kembali ke mezbah untuk meletakkan bagian-bagian daging kurban yang akan dibakar habis. Daging sapi jantan muda dibakar habis untuk dosanya sendiri, dan daging kambing dibakar habis untuk seluruh umat Israel. Dengan demikian, dia memulihkan hubungan dirinya sendiri dan umat Israel dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Berikutnya dia akan membakar lemak kurban penghapus dosa di atas mezbah. ");
INSERT INTO ind_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Orang yang ditugaskan untuk melepas kambing ke padang belantara harus mencuci pakaiannya dan mandi sebelum masuk kembali ke perkemahan umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Karena darah sapi jantan dan kambing yang pertama tadi dibawa masuk ke ruang mahakudus untuk penghabus dosa, bagian-bagian lain dari kedua kurban itu yang tidak dibakar di mezbah harus dibawa ke luar perkemahan— termasuk kulit, daging, dan seluruh isi perut serta kotorannya. Semua itu harus dibakar habis di luar perkemahan. ");
INSERT INTO ind_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Orang yang membakarnya harus mencuci pakaiannya dan mandi sebelum masuk kembali ke perkemahan. ");
INSERT INTO ind_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","30","“Setiap tahun, Hari Pendamaian jatuh pada tanggal sepuluh bulan ketujuh. Pada hari itu kalian dan orang-orang bukan Israel yang tinggal di antara kalian harus berpuasa dan tidak diperbolehkan mengerjakan apa pun. Semua ketetapan mengenai upacara pendamaian ini berlaku bagi umat Israel untuk selamanya, agar setiap tahun hubungan kalian dengan-Ku dipulihkan. ");
INSERT INTO ind_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hari Pendamaian itu dianggap seperti perayaan hari Sabat yang besar, di mana kalian harus beristirahat penuh dan berpuasa sejak matahari terbenam sampai terbenam lagi keesokan harinya. Peraturan ini berlaku untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Di kemudian hari, secara turun temurun setiap imam besar yang ditahbiskan untuk menggantikan Harun akan memakai pakaian khusus imam yang dia warisi untuk melakukan upacara pendamaian. ");
INSERT INTO ind_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Upacara ini berlaku untuk menyucikan ruang mahakudus, kemah-Ku, mezbah kurban, para imam yang lain, dan seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Upacara Hari Pendamaian harus dilakukan setiap tahun untuk selamanya agar hubungan umat Israel dengan-Ku dipulihkan karena dosa-dosa mereka diampuni.” Maka Harun melakukan sesuai dengan perintah TUHAN melalui Musa. ");
INSERT INTO ind_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Sampaikanlah pesan ini kepada Harun, anak-anaknya, dan semua orang Israel: ");
INSERT INTO ind_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Apabila kamu, orang asli Israel, menyembelih sapi, domba, atau kambing, kamu harus melakukannya di depan kemah-Ku sebagai persembahan bagi-Ku. Apabila kamu menyembelihnya di tempat lain, baik di dalam maupun di luar perkemahan, kamu sudah melanggar perintah-Ku karena menumpahkan darah, dan kamu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Tujuan dari perintah ini adalah supaya orang Israel tidak lagi mempersembahkan kurban di padang, tetapi membawanya ke hadapan-Ku, kepada imam yang bertugas di depan kemah-Ku, agar setiap kurban disembelih di sana sebagai kurban tanda damai bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Imam akan menyiramkan darah hewan itu pada sisi mezbah di depan kemah-Ku, lalu membakar lemaknya sehingga asapnya menjadi bau harum yang menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Kalian tidak boleh lagi melacurkan diri dengan mempersembahkan kurban kepada berhala. Taatilah peraturan ini untuk selama-lamanya. ");
INSERT INTO ind_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","“Sampaikan juga kepada umat-Ku: Apabila kamu hendak memberikan kurban yang dibakar habis atau kurban sembelihan lainnya, tetapi tidak membawanya ke depan kemah-Ku sebagai persembahan bagi-Ku, maka kamu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. Peraturan ini berlaku juga untuk orang asing yang tinggal di antara kalian.” ");
INSERT INTO ind_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Apabila di antara kalian, baik orang asli Israel maupun orang asing, ada yang meminum atau memakan darah, maka Aku sendiri yang akan menentang dan menyingkirkan dia dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Karena darah melambangkan nyawa setiap makhluk hidup. Dan kalau darah kurban disiramkan pada sisi mezbah, kurban itu akan memulihkan hubunganmu dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Itulah sebabnya Aku melarang kamu semua untuk memakan atau pun meminum darah. ");
INSERT INTO ind_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Apabila seorang Israel asli maupun orang asing di antara kalian berburu binatang atau burung yang halal, dia harus menumpahkan darah binatang atau burung itu, lalu menutupinya dengan tanah. ");
INSERT INTO ind_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Karena darah melambangkan nyawa setiap makhluk hidup. Itulah sebabnya Aku menegaskan bahwa siapa saja yang meminum atau memakan darah akan disingkirkan dari antara umat yang taat pada perjanjian-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Apabila ada di antara kalian, baik orang Israel asli maupun pendatang, yang memakan daging dari bangkai binatang yang mati secara alami atau sisa mangsa binatang buas, dia harus mencuci pakaiannya dan mandi. Dia menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Tetapi jika dia tidak mencuci pakaiannya dan mandi, maka Aku akan menganggap dia berdosa dan dia sendiri akan menanggung akibatnya.” ");
INSERT INTO ind_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Sampaikan kepada semua orang Israel: Akulah TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Jangan meniru cara hidup orang di Mesir, di mana dulu kamu tinggal, ataupun cara hidup orang di Kanaan, negeri ke mana Aku sedang membawamu. ");
INSERT INTO ind_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","Taatilah hukum-hukum yang Aku berikan dan lakukanlah segala perintah-Ku. Dengan melakukannya, kamu pasti selamat. Aku, TUHAN Allahmu, menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Janganlah bersetubuh dengan kerabat dekat. ");
INSERT INTO ind_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Jangan melecehkan ayahmu dengan bersetubuh dengan ibumu sendiri. ");
INSERT INTO ind_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Jangan pula melecehkan ayahmu dengan bersetubuh dengan istrinya yang lain. ");
INSERT INTO ind_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Jangan bersetubuh dengan saudari kandungmu ataupun saudari tirimu, baik yang lahir serumah denganmu maupun di rumah lain. ");
INSERT INTO ind_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Jangan bersetubuh dengan cucu perempuanmu, karena itu merupakan pelecehan terhadap dirimu sendiri. ");
INSERT INTO ind_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Jangan bersetubuh dengan adik atau kakak perempuanmu dari satu ayah, meskipun lain ibu, karena dia masih saudarimu. ");
INSERT INTO ind_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Jangan bersetubuh dengan saudari ayahmu, karena dia masih keluarga dekat dari ayahmu. ");
INSERT INTO ind_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Jangan bersetubuh dengan saudari ibumu, karena dia masih keluarga dekat dari ibumu. ");
INSERT INTO ind_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Jangan melecehkan saudara ayahmu dengan bersetubuh dengan istrinya, yaitu bibimu. ");
INSERT INTO ind_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Jangan bersetubuh dengan menantu perempuanmu. ");
INSERT INTO ind_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Jangan melecehkan saudaramu dengan bersetubuh dengan istrinya. ");
INSERT INTO ind_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Jangan bersetubuh dengan anak atau cucu dari perempuan yang pernah bersetubuh denganmu, karena mereka masih satu keluarga. Perbuatan itu merupakan kejahatan. ");
INSERT INTO ind_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Jangan melecehkan istrimu dengan menikahi saudarinya selama istrimu masih hidup. ");
INSERT INTO ind_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Jangan bersetubuh dengan perempuan yang sedang haid, karena dia dalam keadaan najis. ");
INSERT INTO ind_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Jangan menajiskan dirimu dengan bersetubuh dengan istri orang lain. ");
INSERT INTO ind_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Jangan menyerahkan satu pun dari anak-anakmu sebagai kurban pemujaan bagi dewa Molok, karena perbuatan itu melecehkan Aku, TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Laki-laki dilarang bersetubuh dengan laki-laki. Itu kejahatan besar. ");
INSERT INTO ind_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Jangan bersetubuh dengan binatang apa pun karena perbuatan itu menajiskan dirimu. Perempuan dilarang memberi dirinya bersetubuh dengan binatang, karena hal itu adalah perbuatan yang sangat menyimpang. ");
INSERT INTO ind_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Jangan menajiskan dirimu dengan melakukan hal-hal tersebut, sebab bangsa-bangsa yang akan Aku usir dari hadapanmu sudah menajiskan diri mereka dengan melakukan semuanya itu. ");
INSERT INTO ind_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Mereka menajiskan negeri Kanaan dengan perbuatan-perbuatan mereka, sehingga Aku mengusir mereka keluar dari sana. ");
INSERT INTO ind_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Oleh karena itu, kamu masing-masing, baik orang Israel asli maupun pendatang, harus mematuhi semua perintah dan hukum-Ku. Kalian tidak boleh melakukan berbagai kejahatan yang menjijikkan itu. ");
INSERT INTO ind_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","“Penduduk yang tinggal di negeri itu sebelum kamu sudah melakukan semua kekejian tersebut sehingga negeri itu menjadi najis. ");
INSERT INTO ind_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Apabila kamu melakukan perbuatan-perbuatan seperti mereka dan menajiskan negeri itu lagi, kamu juga akan Aku usir dari sana. ");
INSERT INTO ind_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Siapa pun di antara kalian yang melakukan salah satu kejahatan besar tersebut akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Maka taatilah semua perintah-Ku dan janganlah melakukan kejahatan seperti yang dilakukan oleh bangsa-bangsa yang sebelumnya tinggal di negeri Kanaan. Jangan menajiskan dirimu dengan mengikuti cara hidup mereka. Aku, TUHAN Allahmu, menegaskan hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Sampaikanlah kepada seluruh umat Israel: Kamu masing-masing harus hidup suci, karena Aku, TUHAN Allahmu, adalah kudus. ");
INSERT INTO ind_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Setiap orang wajib menghormati ayah dan ibunya serta menaati peraturan hari Sabat, seperti yang sudah Aku perintahkan kepada kalian. Aku, TUHAN Allahmu, menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Jangan menyembah berhala, dan jangan membuat patung-patung logam untuk disembah, sebab Akulah TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Apabila kamu mempersembahkan kurban tanda damai kepada-Ku, lakukanlah itu sesuai dengan peraturan yang sudah Aku berikan, supaya Aku berkenan kepada persembahanmu. ");
INSERT INTO ind_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Daging kurban tanda damai harus dimakan pada hari kurban itu dipersembahkan, atau paling lambat pada keesokan harinya. Daging yang tersisa pada hari ketiga haruslah dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Pada hari ketiga, sisa daging kurban sudah menjadi haram. Apabila ada yang memakannya, Aku tidak akan menerima persembahan kurban itu. ");
INSERT INTO ind_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Siapa pun yang memakan daging itu akan menanggung kesalahannya, karena dia sudah mencemarkan persembahan kudus yang diberikan kepada-Ku. Orang itu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ketika kamu memanen gandum, janganlah memanen seluruhnya sampai ke sudut-sudut ladang, dan jangan kembali untuk mengumpulkan sisa-sisa yang terjatuh. ");
INSERT INTO ind_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Janganlah kembali ke kebun anggur untuk memanen habis buah-buah yang tertinggal atau memungut buah yang jatuh dari pohon anggurmu. Biarkanlah buah-buah yang tersisa itu untuk orang miskin dan pendatang. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Jangan mencuri. Jangan berbohong. Jangan menipu orang lain. ");
INSERT INTO ind_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Apabila kamu berjanji dengan menyebut nama-Ku sebagai saksi untuk janjimu, kamu harus menepati janji itu. Jika tidak, kamu sudah mencemarkan nama-Ku. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Jangan menindas sesamamu. Jangan merampas barang orang lain. Bayarlah upah pekerjamu dengan tepat waktu. Jangan menahan upahnya meski hanya semalam. ");
INSERT INTO ind_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Jangan menghina orang tuli dan jangan meletakkan sandungan di depan orang buta. Kalau kamu berbuat demikian, berarti kamu tidak menghormati Aku. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Jangan bersikap tidak adil dalam memutuskan kasus hukum. Jangan memihak kepada orang miskin maupun kepada orang kaya. Kamu harus mengadili sesamamu dengan adil. ");
INSERT INTO ind_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Jangan menyebarkan fitnah tentang sesamamu. Kalau sesamamu sedang diadili dan terancam hukuman mati, jangan diam saja bila kamu mempunyai kesaksian yang dapat menyelamatkan dia. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Jika sesamamu berbuat salah, janganlah kamu diam-diam membencinya. Tegurlah dia dengan terus terang, agar kamu tidak menanggung kesalahannya juga. ");
INSERT INTO ind_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Jangan membalas dendam atau menyimpan dendam terhadap orang sebangsamu, tetapi kasihilah sesamamu seperti kamu mengasihi dirimu sendiri. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Taatilah peraturan-peraturan-Ku. Jangan mengawinkan ternakmu dengan jenis yang berbeda. Jangan menanami ladangmu dengan dua jenis benih yang berbeda. Jangan memakai pakaian yang terbuat dari dua jenis bahan yang berbeda. ");
INSERT INTO ind_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Jika seorang laki-laki bersetubuh dengan seorang budak perempuan yang sudah direncanakan untuk menjadi milik orang lain, tetapi budak itu belum dibayar atau ditebus menjadi orang merdeka, maka lelaki itu harus membayar denda. Tetapi mereka berdua tidak dihukum mati, karena perempuan itu belum berstatus merdeka. ");
INSERT INTO ind_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Lelaki yang bersetubuh dengannya itu harus membawa kepada-Ku seekor domba jantan sebagai kurban penebus kesalahan ke depan kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Imam yang bertugas akan mempersembahkan domba kurban penebus kesalahan itu kepada-Ku. Maka hubungan orang itu dengan-Ku dipulihkan dan dosanya diampuni. ");
INSERT INTO ind_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Sesudah kamu masuk ke negeri Kanaan dan menanam berbagai macam pohon buah-buahan, janganlah memakan buahnya selama tiga tahun pertama. ");
INSERT INTO ind_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Pada tahun yang keempat, seluruh buahnya harus dijadikan suatu persembahan kudus sebagai ucapan syukur kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pada tahun yang kelima barulah kamu boleh memakan buah dari pohon-pohon itu. Apabila kamu menaati peraturan ini, buah-buahanmu akan berlimpah. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Jangan memakan daging yang masih ada darahnya. “Jangan melakukan ramalan ataupun perdukunan. ");
INSERT INTO ind_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","28","“Ketika kamu berduka karena orang yang meninggal, jangan mencukur rambut pada bagian sisi kepalamu atau jenggotmu. Jangan menggores-gores tubuhmu atau membuat tato di kulitmu. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Jangan mencemarkan anak perempuanmu dengan menjadikannya pelacur, supaya negeri yang kalian diami tidak menjadi tempat persundalan dan dipenuhi perbuatan keji. ");
INSERT INTO ind_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Taatilah semua peraturan tentang hari Sabat dan hormatilah kemah-Ku. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Jangan mendatangi pemanggil arwah atau dukun untuk meminta nasihat dari roh orang mati, karena perbuatan itu menjadikan kalian najis. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Tunjukkanlah hormat kepada orang-orang tua, dan berdirilah waktu menyambut mereka. Kalian juga harus hormat dan takut akan Aku. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Apabila ada pendatang yang tinggal di antara kalian di Kanaan, jangan menindas mereka. ");
INSERT INTO ind_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Perlakukanlah mereka sama seperti orang sebangsamu. Kasihilah mereka seperti dirimu sendiri. Ingatlah bahwa dulu kamu juga hidup sebagai orang asing di Mesir. Aku, TUHAN Allahmu, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Kalian tidak boleh mencurangi orang lain dengan menggunakan pengukur, timbangan, atau takaran yang salah. ");
INSERT INTO ind_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Gunakanlah pengukur, timbangan, dan takaran yang benar. Aku TUHAN yang membawamu keluar dari perbudakan di Mesir, menegaskan perintah ini. ");
INSERT INTO ind_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Perhatikan dan lakukanlah semua hukum dan perintah-Ku. Aku, TUHAN Allahmu, menegaskan perintah ini.” ");
INSERT INTO ind_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Sampaikanlah kepada seluruh umat Israel dan semua pendatang yang tinggal di antara mereka: Siapa pun yang memberikan anaknya untuk dibakar sebagai persembahan kepada dewa Molok harus dihukum mati dengan cara dilempari batu oleh penduduk setempat. ");
INSERT INTO ind_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Aku sendiri akan menentang dan menyingkirkan orang itu dari antara umat yang taat pada perjanjian-Ku, karena dengan melakukan itu dia sudah menajiskan kemah-Ku dan melecehkan kekudusan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Jika kalian membiarkan orang itu mempersembahkan anaknya kepada Molok dan tidak menjatuhkan hukuman mati padanya, ");
INSERT INTO ind_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Aku sendiri yang akan menentang dan menyingkirkan orang itu beserta seluruh keluarganya, juga semua orang yang ikut melacurkan diri dengan menyembah dewa Molok. ");
INSERT INTO ind_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Demikian juga bila ada yang melacurkan diri dengan meminta nasihat dari pemanggil arwah atau dukun, Aku sendiri akan menentang dan menyingkirkan orang itu dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Jagalah diri kalian tetap suci, sebab Akulah TUHAN, Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Perhatikan dan lakukanlah semua peraturan-Ku, karena Akulah TUHAN yang menyucikanmu. ");
INSERT INTO ind_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Setiap orang yang mengutuki ayah atau ibunya harus dihukum mati. Demikianlah dia bertanggung jawab atas perbuatannya itu.” ");
INSERT INTO ind_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Jika seorang laki-laki berzina dengan perempuan yang sudah bersuami, maka laki-laki dan perempuan yang berzina itu harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Jika seorang laki-laki melecehkan ayahnya dengan bersetubuh dengan salah seorang istri ayahnya, maka laki-laki dan perempuan itu harus dihukum mati. Demikianlah mereka bertanggung jawab atas perbuatan itu. ");
INSERT INTO ind_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Jika seorang laki-laki bersetubuh dengan menantu perempuannya, laki-laki dan perempuan itu harus dihukum mati, karena mereka sudah melakukan perilaku menyimpang. Demikianlah mereka bertanggung jawab atas perbuatan itu. ");
INSERT INTO ind_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Jika seorang laki-laki bersetubuh dengan sesama laki-laki seperti bersetubuh dengan perempuan, maka kedua laki-laki itu harus dihukum mati karena mereka melakukan perilaku yang menjijikkan. Demikianlah mereka bertanggung jawab atas perbuatan itu. ");
INSERT INTO ind_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Jika seorang laki-laki menikahi seorang perempuan sekaligus ibu perempuan itu, mereka bertiga harus dihukum mati dengan cara dibakar, karena mereka sudah melakukan kejahatan besar. Biarlah kejahatan seperti itu tidak dilakukan lagi di antara umat-Ku. ");
INSERT INTO ind_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","Jika seorang laki-laki atau perempuan bersetubuh dengan binatang, orang itu harus dihukum mati dan binatang itu harus dibunuh. Demikianlah orang itu bertanggung jawab atas perbuatannya. ");
INSERT INTO ind_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Jika seorang laki-laki menikahi saudarinya sendiri, baik saudari kandung maupun saudari tiri yang berasal dari satu ayah atau satu ibu, mereka akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. Mereka sudah melakukan perbuatan hina dan biarlah mereka menanggung akibat dari perbuatan itu. ");
INSERT INTO ind_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Apabila seorang laki-laki bersetubuh dengan perempuan yang sedang haid, mereka akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, karena mereka melakukan hal yang sangat najis. ");
INSERT INTO ind_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Jika seorang laki-laki bersetubuh dengan bibinya, baik saudari ayahnya ataupun ibunya, dia sudah melecehkan kerabat dekat. Biarlah mereka menanggung akibat dari perbuatan itu. ");
INSERT INTO ind_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Demikian juga bila seorang laki-laki bersetubuh dengan istri pamannya, dia sudah melecehkan pamannya itu. Biarlah laki-laki dan perempuan itu menanggung akibat dari perbuatan mereka. Sampai mati mereka tidak akan mempunyai keturunan. ");
INSERT INTO ind_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Jika seorang laki-laki mengambil istri saudaranya, itu merupakan perbuatan hina. Dia sudah melecehkan saudaranya. Sampai mati mereka tidak akan mempunyai keturunan.” ");
INSERT INTO ind_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Lakukanlah dengan setia semua peraturan yang sudah Aku berikan, supaya kalian tidak diusir dari negeri ke mana Aku membawa kalian. ");
INSERT INTO ind_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Jangan meniru kebiasaan hidup penduduk di sana. Karena mereka melakukan segala macam kelakuan jahat tersebut, Aku membenci dan mengusir mereka dari negeri itu. ");
INSERT INTO ind_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Aku sudah mengatakan kepada kalian, negeri ini akan Aku berikan kepada kalian, negeri yang berlimpah dengan hasil alam. Akulah TUHAN Allahmu, yang membuat kalian berbeda dari bangsa-bangsa lain. ");
INSERT INTO ind_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Karena itu kamu masing-masing harus membedakan antara binatang dan burung yang haram dan yang tidak haram. Jangan menajiskan dirimu dengan memakan binatang atau burung yang sudah Aku tentukan untuk kamu haramkan. ");
INSERT INTO ind_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kamu semua harus hidup suci, karena Aku, TUHAN Allahmu, adalah kudus, dan Aku sudah memisahkan kalian dari bangsa-bangsa lain untuk menjadi milik-Ku. ");
INSERT INTO ind_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Siapa pun di antara kalian, baik laki-laki maupun perempuan, yang menjadi pemanggil arwah atau dukun harus dihukum mati dengan cara dilempari batu. Demikianlah dia bertanggung jawab atas perbuatannya itu.” ");
INSERT INTO ind_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","TUHAN berbicara kepada Musa, “Sampaikanlah kepada para imam, yakni keturunan Harun, tentang peraturan-peraturan yang berlaku bagi semua imam. Imam tidak boleh menajiskan dirinya dengan menyentuh jenazah, ");
INSERT INTO ind_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","kecuali jenazah anggota keluarga dekatnya sendiri, yaitu ibunya, ayahnya, anaknya laki-laki atau perempuan, saudaranya, ");
INSERT INTO ind_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","atau saudarinya yang belum menikah dan masih tinggal dengannya. Bagi saudarinya yang masih berada di bawah naungannya itu, imam diperbolehkan menjadi najis dengan menguburkan jenazahnya. ");
INSERT INTO ind_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Imam tidak boleh menajiskan diri dengan menyentuh jenazah iparnya. ");
INSERT INTO ind_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Ketika berduka karena orang yang meninggal, imam tidak boleh membuat tanda pada tubuhnya seperti menggundul kepala, mencukur tepi jenggotnya, atau menggores-gores tubuhnya dengan benda tajam. ");
INSERT INTO ind_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Para imam harus hidup suci bagi-Ku dan tidak boleh mencemarkan nama-Ku, karena merekalah yang mempersembahkan segala macam kurban daging dan gandum-ganduman di mezbah-Ku. Oleh sebab itu, mereka harus menjaga kesuciannya masing-masing. ");
INSERT INTO ind_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Imam tidak boleh menikah dengan pelacur, perempuan yang sudah tidak perawan, atau yang sudah bercerai dari suaminya, karena imam dikhususkan untuk hidup suci bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Dan kalian, umat Israel, harus memandang para imam dengan hormat sebagai orang yang suci, karena mereka adalah perantara untuk mempersembahkan kurban yang menjadi bagian Allahmu. Aku, Allahmu yang kudus dan yang menyucikan kalian, menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Bila anak perempuan seorang imam mencemarkan dirinya dengan menjadi pelacur, dia melecehkan ayahnya dan harus dihukum mati dengan cara dibakar. ");
INSERT INTO ind_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Imam besar mengepalai saudara-saudaranya, yaitu para imam lain. Dia dilantik dengan cara menuangkan minyak pengurapan ke atas kepalanya, dan dia memakai pakaian khusus imam besar. Ketika berkabung, imam besar tidak boleh membuat tanda dukacita seperti membiarkan rambutnya kusut atau merobek pakaiannya. ");
INSERT INTO ind_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Imam besar tidak boleh menajiskan diri dengan mendekati jenazah, sekalipun yang meninggal adalah ayah atau ibunya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Dia juga tidak boleh meninggalkan kemah-Ku untuk pergi ke tempat orang meninggal. Hal itu akan mencemari kemah-Ku, karena seorang imam besar sudah menerima minyak pengurapan di atas kepalanya sebagai tanda bahwa dia dikhususkan untuk mengabdi kepada Allahnya. Akulah TUHAN yang menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Seorang imam besar harus menikah dengan seorang perempuan yang masih perawan. ");
INSERT INTO ind_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Dia tidak boleh menikah dengan janda, atau pelacur, ataupun perempuan yang sudah bercerai dari suaminya. Imam besar hanya boleh menikah dengan seorang gadis perawan dari bangsanya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Tujuannya untuk menjaga supaya garis keturunannya tidak tercemar, sebab Aku, TUHAN, sudah menyucikan dia.” ");
INSERT INTO ind_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","TUHAN juga berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Sampaikanlah pesan-pesan ini kepada Harun: Untuk selamanya, setiap keturunanmu yang memiliki cacat tubuh dilarang mendekati mezbah untuk mempersembahkan sesuatu bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Seorang imam tidak boleh mempunyai satu pun cacat tubuh berikut ini: lumpuh atau pincang, tuna netra, bibir sumbing atau kelainan apa pun pada wajah, kelainan pada anggota badan, ");
INSERT INTO ind_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kecacatan pada kaki atau tangan, ");
INSERT INTO ind_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","punggung bungkuk, badan kerdil, mata rabun, penyakit kulit apa pun, kerusakan pada buah pelir. ");
INSERT INTO ind_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Jadi, keturunan Harun yang memiliki cacat tubuh tidak boleh datang ke mezbah untuk mempersembahkan sesuatu bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Tetapi dia boleh mendapat bagian dari berbagai jenis persembahan yang diberikan kepada-Ku, baik yang suci maupun yang sangat suci. ");
INSERT INTO ind_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Hanya saja, karena kelainan tubuhnya itu, dia tidak diizinkan mendekati mezbah atau masuk ke kemah-Ku, supaya tidak mencemari seluruh tempat suci-Ku, sebab Aku, TUHAN, sudah menyucikan semuanya itu.” ");
INSERT INTO ind_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Maka Musa menyampaikan pesan-pesan tersebut kepada Harun dan anak-anaknya, serta kepada seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Sampaikanlah kepada Harun dan anak-anaknya: Semua kurban maupun persembahan lain yang dipersembahkan oleh umat Israel kepada-Ku haruslah kalian perlakukan dengan hati-hati sebagai benda yang suci, agar kalian tidak mencemarkan nama-Ku yang kudus. Akulah TUHAN, yang menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Siapa pun imam yang dalam keadaan najis mendekati makanan yang sudah dipersembahkan kepada-Ku oleh umat Israel akan disingkirkan dari antara semua imam yang melayani di kemah-Ku. Peraturan ini berlaku selamanya untuk semua keturunan Harun. Akulah TUHAN, yang menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Seorang imam yang menderita penyakit kulit menular, atau penyakit kelamin yang menyebabkan tubuhnya mengeluarkan cairan, tidak boleh memakan makanan yang sudah diperpersembahkan kepada-Ku sebelum dia sembuh dan tidak najis lagi. Imam juga akan menjadi najis jika menyentuh jenazah, atau mengeluarkan air mani, ");
INSERT INTO ind_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","atau menyentuh binatang najis maupun orang yang sedang najis. ");
INSERT INTO ind_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Imam yang menyentuh benda najis seperti itu akan menjadi najis sampai matahari terbenam, dan sebelum mandi, dia tidak boleh memakan makanan yang sudah dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sesudah matahari terbenam, dia tidak najis lagi dan boleh memakan makanan yang sudah dipersembahkan kepada-Ku, karena itulah makanannya. ");
INSERT INTO ind_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Imam tidak boleh memakan daging binatang yang mati secara alami atau mati dimangsa binatang liar, karena hal itu akan membuatnya najis. Akulah TUHAN, yang menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Para imam harus melakukan peraturan-peraturan-Ku dengan seksama. Jika melanggarnya, mereka berdosa dan akan mati karena dosanya. Aku, TUHAN yang menyucikan mereka, menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Makanan yang sudah dipersembahkan kepada-Ku hanya boleh dimakan oleh keluarga imam. Selain mereka, tidak ada yang boleh memakannya, bahkan tamu yang menginap di rumah imam itu ataupun pekerja upahannya. ");
INSERT INTO ind_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Tetapi budak yang dibeli oleh imam dengan uangnya sendiri atau yang lahir di rumah imam boleh ikut memakan makanan yang sudah dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Jika anak perempuan seorang imam menikah dengan laki-laki yang bukan dari keturunan imam, perempuan itu tidak boleh memakan makanan yang sudah diperpersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Namun, jika dia menjadi janda atau bercerai tanpa memiliki anak, dan dia kembali tinggal di rumah ayahnya seperti masa gadisnya, dia boleh memakan bagian ayahnya. Orang lain yang bukan dari keluarga imam tidak boleh memakannya. ");
INSERT INTO ind_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Jika orang yang bukan dari keluarga imam tidak sengaja memakan makanan yang sudah dipersembahkan kepada-Ku, dia harus menggantinya kepada imam dengan menambah 20 persen. ");
INSERT INTO ind_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Para imam tidak boleh mencemari makanan yang sudah dipersembahkan kepada-Ku oleh umat Israel ");
INSERT INTO ind_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","dengan membiarkan orang yang bukan keluarga imam memakannya. Hal itu akan mewajibkan mereka untuk membayar ganti rugi atas kesalahan mereka. Aku menegaskan hal ini, karena Akulah TUHAN yang menyucikan semua persembahan yang diberikan kepada-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kemudian TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Sampaikanlah kepada para imam dan seluruh orang Israel: Ketika kalian, orang Israel asli ataupun pendatang, mempersembahkan kurban yang dibakar habis kepada TUHAN, baik sebagai persembahan untuk memenuhi janji maupun persembahan sukarela, ");
INSERT INTO ind_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","dia harus membawa sapi jantan, kambing jantan, atau domba jantan yang tidak bercacat, agar persembahan itu Aku terima. ");
INSERT INTO ind_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Jangan mempersembahkan binatang yang bercacat, karena Aku tidak akan menerimanya. ");
INSERT INTO ind_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Demikian juga jika seseorang mempersembahkan kurban tanda damai kepada-Ku, baik sebagai persembahan untuk memenuhi janji maupun persembahan sukarela, binatang itu tidak boleh bercacat supaya dapat diterima. ");
INSERT INTO ind_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Binatang yang bercacat, seperti buta, pincang, luka, atau berpenyakit kulit apa pun tidak boleh dipersembahkan di atas mezbah sebagai kurban bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Sapi jantan atau domba dengan salah satu kaki yang terlalu panjang atau pendek boleh kamu berikan sebagai persembahan sukarela, tetapi tidak boleh sebagai persembahan untuk memenuhi janji. ");
INSERT INTO ind_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","25","Binatang yang buah pelirnya memar, rusak, robek, atau dikebiri sama sekali tidak boleh dipersembahkan kepada-Ku. Mempersembahkan binatang yang seperti itu merupakan penghinaan terhadap-Ku. Itulah sebabnya orang Israel asli maupun pendatang tidak boleh mempersembahkan hewan seperti itu.” ");
INSERT INTO ind_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ketika seekor anak sapi, domba, atau kambing lahir, biarlah dia tinggal dengan induknya selama tujuh hari. Sesudah hari kedelapan barulah anak hewan boleh dipersembahkan di mezbah bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Jangan mempersembahkan seekor induk sapi atau induk domba beserta anaknya pada hari yang sama. ");
INSERT INTO ind_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Jika kamu membawa persembahan syukur kepada TUHAN, persembahkanlah itu sesuai peraturan, supaya persembahanmu diterima. ");
INSERT INTO ind_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Makanlah dagingnya pada hari kurban itu dipersembahkan, dan jangan menyisakannya sampai besok pagi. Akulah TUHAN, yang menegaskan hal ini. ");
INSERT INTO ind_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Maka taatilah perintah-Ku, sebab Akulah TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Jangan mencemarkan kekudusan-Ku, supaya Aku tetap dihormati di tengah umat Israel sebagai Allahmu yang kudus. Akulah TUHAN, yang menyucikan kalian. ");
INSERT INTO ind_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ingatlah bahwa Aku membawa kalian keluar dari Mesir, supaya Aku menjadi Allahmu. Akulah TUHAN, yang menegaskan semua hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Sampaikanlah kepada orang Israel: Inilah hari-hari raya yang Aku tetapkan. Kalian harus berkumpul untuk beribadah bersama pada hari-hari berikut ini.” ");
INSERT INTO ind_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Selama enam hari kalian boleh bekerja, tetapi hari ketujuh adalah hari Sabat, yaitu hari yang dikhususkan bagi-Ku. Berkumpullah bersama untuk beribadah pada hari itu. Di mana pun kalian tinggal, pada hari Sabat kalian harus beristirahat penuh dan tidak boleh melakukan pekerjaan apa pun.” ");
INSERT INTO ind_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Berikut ini adalah hari-hari raya yang Aku tetapkan untuk kalian berkumpul dan beribadah.” ");
INSERT INTO ind_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Hari Paskah dimulai pada tanggal empat belas bulan pertama waktu matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Pada hari berikutnya, yaitu tanggal lima belas bulan pertama, Hari Raya Roti Tidak Beragi dimulai dan akan berlangsung selama tujuh hari. Selama perayaan ini berlangsung, kalian hanya boleh makan roti yang dibuat tanpa ragi. ");
INSERT INTO ind_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Pada hari pertama perayaan ini, berkumpullah untuk beribadah bersama dan janganlah melakukan pekerjaan sehari-hari. ");
INSERT INTO ind_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Selama tujuh hari kalian harus mempersembahkan kurban yang dibakar habis bagi-Ku. Lalu pada hari yang ketujuh, kalian akan bertemu lagi untuk beribadah bersama dan tidak boleh melakukan pekerjaan sehari-hari.” ");
INSERT INTO ind_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Sampaikanlah kepada orang Israel: Sesudah kalian tiba di negeri yang Aku berikan kepada kalian dan memanen hasil jelai yang pertama dari ladang-ladangmu, haruslah kamu masing-masing membawa seikat dari hasil panen itu kepada imam yang bertugas. ");
INSERT INTO ind_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Pada hari sesudah Sabat, imam akan mengangkat tinggi hasil panen itu di hadapan-Ku sebagai persembahan khusus, agar Aku berkenan kepada kalian. ");
INSERT INTO ind_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pada hari yang sama, umat Israel juga akan mempersembahkan kepada-Ku seekor anak domba jantan berumur satu tahun yang tidak bercacat sebagai kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Sertakanlah juga persembahan gandum-ganduman berupa tepung terbaik sebanyak 4,4 liter dicampur dengan minyak zaitun. Imam yang bertugas akan membakar segenggam bagi-Ku sehingga bau harumnya akan menyenangkan Aku. Bersama dengan itu, persembahkan juga satu liter air anggur. ");
INSERT INTO ind_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Sebelum umat memberikan persembahan-persembahan tersebut kepada-Ku, kalian tidak boleh memakan roti atau jelai dari hasil panen pertama, baik mentah maupun dipanggang. Demikianlah peraturan yang harus ditaati turun-temurun di mana pun kalian tinggal.” ");
INSERT INTO ind_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","16","“Hari Raya Panen dimulai pada hari kelima puluh, yaitu tujuh minggu sesudah Hari Raya Hasil Panen Pertama. Pada hari itu, kalian harus memberikan persembahan khusus bagi-Ku dari panen gandum yang baru. Persembahan itu harus diangkat tinggi di hadapan-Ku. ");
INSERT INTO ind_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bawalah dua buah roti dari tempat tinggal kalian masing-masing untuk diangkat tinggi sebagai persembahan khusus kepada-Ku. Setiap roti harus dibuat dari 2,2 liter tepung terbaik dari hasil panen pertamamu, yang diolah dengan ragi dan dipanggang. ");
INSERT INTO ind_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Bersama dengan roti itu, umat Israel akan mempersembahkan tujuh ekor domba jantan berumur satu tahun yang tidak bercacat, seekor sapi jantan muda, dan dua ekor domba jantan sebagai kurban yang dibakar habis. Setiap kurban itu akan disertai dengan persembahan curahan dan persembahan gandum-ganduman sesuai ketentuan. Bau harum persembahan itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Persembahkanlah juga seekor kambing jantan sebagai kurban penghapus dosa dan dua ekor anak domba jantan berumur satu tahun sebagai kurban tanda damai. ");
INSERT INTO ind_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“Imam akan mengangkat tinggi roti dari hasil panen pertama beserta bagian daging dari kedua ekor domba itu sebagai persembahan khusus kepada-Ku. Persembahan itu akan menjadi bagian imam yang mempersembahkannya. ");
INSERT INTO ind_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Pada hari itu kalian harus berkumpul untuk beribadah bersama dan tidak boleh melakukan pekerjaan sehari-hari. Demikianlah peraturan yang harus ditaati turun-temurun di mana pun kalian tinggal. ");
INSERT INTO ind_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Waktu memanen ladang, janganlah kalian memotongnya sampai ke pinggir ladang dan jangan kembali untuk mengumpulkan sisa yang terjatuh. Biarkanlah itu untuk dipungut oleh orang miskin dan pendatang yang ada di antara kalian. Aku, TUHAN Allahmu, menegaskan hal-hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Sampaikanlah kepada orang Israel: Hari Raya Terompet dimulai pada tanggal satu bulan ketujuh. Kalian akan merayakan hari itu dengan berkumpul untuk beribadah bersama dan beristirahat penuh. Perayaan ini ditandai dengan membunyikan terompet berulang kali. ");
INSERT INTO ind_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Kalian tidak boleh melakukan pekerjaan sehari-hari dan dalam perayaan itu banyak kurban akan dipersembahkan di mezbah bagi-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Hari Raya Pendamaian dimulai pada tanggal sepuluh bulan ketujuh. Kalian akan merayakan hari itu dengan cara merendahkan diri dengan berpuasa, berkumpul untuk beribadah bersama, dan mempersembahkan kurban di mezbah bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Kalian tidak boleh melakukan pekerjaan apa pun hari itu, karena pada hari itu dipersembahkan kurban untuk memulihkan hubungan kalian dengan Aku, TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Siapa pun yang tidak merendahkan diri dengan berpuasa pada hari itu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, ");
INSERT INTO ind_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","dan siapa pun yang melakukan pekerjaan pada hari itu, Aku sendiri yang akan membinasakan dia dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Jangan melakukan pekerjaan apa pun pada hari itu. Ini adalah peraturan yang harus ditaati secara turun-temurun di mana pun kalian tinggal. ");
INSERT INTO ind_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Pada Hari Raya Pendamaian, kalian akan beristirahat penuh seperti pada hari Sabat. Kalian juga harus merendahkan diri dengan berpuasa. Hari Raya Pendamaian dimulai ketika matahari terbenam pada tanggal sembilan bulan ketujuh sampai matahari terbenam di tanggal sepuluh.” ");
INSERT INTO ind_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Sampaikanlah kepada orang Israel: Hari Raya Pondok jatuh pada tanggal lima belas bulan ketujuh, yaitu lima hari sesudah Hari Raya Pendamaian. Perayaan untuk menghormati-Ku ini akan berlangsung selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Pada hari pertama, kalian akan berkumpul bersama untuk beribadah dan tidak boleh melakukan pekerjaan sehari-hari. ");
INSERT INTO ind_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Selama tujuh hari itu, setiap harinya kalian akan mempersembahkan berbagai kurban di mezbah-Ku. Pada hari kedelapan kalian akan berkumpul lagi untuk beribadah bersama dan mempersembahkan kurban. Janganlah melakukan pekerjaan sehari-hari.” ");
INSERT INTO ind_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Itulah hari-hari raya yang TUHAN tetapkan. Pada hari-hari tersebut, umat-Nya akan berkumpul untuk beribadah bersama dan mempersembahkan kurban di mezbah bagi-Nya, termasuk kurban yang dibakar habis, kurban sembelihan yang lain, persembahan gandum-ganduman dan air anggur, sesuai dengan peraturan yang berlaku untuk tiap-tiap hari raya. ");
INSERT INTO ind_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Perayaan-perayaan itu tidak mengganti kewajiban-kewajiban yang lain bagi TUHAN, termasuk hari-hari Sabat yang biasa dan berbagai persembahan lain, seperti persembahan untuk memenuhi janji dan persembahan sukarelamu. ");
INSERT INTO ind_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ingatlah, pada tanggal lima belas bulan ketujuh, sesudah memanen hasil ladang, kalian harus merayakan Hari Raya Pondok bagi-Ku selama tujuh hari. Hari pertama dan hari kedelapan perayaan itu dikhususkan untuk beristirahat penuh. ");
INSERT INTO ind_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pada hari pertama, dirikanlah pondok untuk keluargamu dari cabang-cabang yang kalian potong dari pohon palem, pohon berdaun indah, dan berbagai jenis pohon berdaun lebat. Lalu selama tujuh hari berpestalah di hadapan-Ku, TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","42","Rayakanlah pesta ini secara turun temurun setiap tahun pada bulan yang ketujuh. Selama tujuh hari perayaan ini, setiap orang Israel asli harus tinggal di pondok dari cabang-cabang berdaun. ");
INSERT INTO ind_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ini dilakukan untuk mengenang bahwa nenek moyang Israel pernah tinggal di pondok-pondok ketika Aku membawa mereka keluar dari negeri Mesir. Akulah TUHAN Allahmu yang menegaskan hal-hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Maka Musa mengumumkan hari-hari raya bagi TUHAN itu kepada umat Israel. ");
INSERT INTO ind_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Perintahkanlah kepada umat Israel agar mereka membawa kepadamu minyak zaitun murni untuk ketujuh pelita kemah-Ku, agar pelita itu tetap menyala setiap malam. ");
INSERT INTO ind_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","Para imam harus selalu menjaga supaya pelita-pelita pada tiang pelita bercabang dari emas murni itu terus menyala sepanjang malam di hadapan-Ku, di bagian luar tirai pemisah ruang mahakudus. Peraturan ini harus ditaati secara turun temurun sampai selamanya.” ");
INSERT INTO ind_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","8","“Dua belas roti akan dipanggang dan disajikan bagi-Ku setiap hari Sabat. Setiap roti akan dibuat dari 4,4 liter tepung yang terbaik. Imam yang bertugas akan menyajikan roti di meja emas di hadapan-Ku dalam dua susunan. Setiap susun terdiri dari enam roti. Sewaktu roti disusun di meja, kemenyan murni juga akan dibakar sebagai persembahan bagi-Ku, karena tidak ada bagian dari roti itu yang akan dibakar habis di mezbah. Kedua belas roti itu melambangkan perjanjian-Ku dengan kedua belas suku Israel. Itulah sebabnya roti tersebut harus disajikan setiap hari Sabat turun temurun untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Kedua belas roti itu menjadi bagian para imam untuk selamanya. Mereka harus memakannya di tempat yang suci, karena roti itu adalah bagian yang paling kudus dari antara semua yang dipersembahkan kepada TUHAN.” ");
INSERT INTO ind_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Di antara orang Israel, ada seorang laki-laki yang ayahnya seorang Mesir dan ibunya seorang Israel. Ibunya bernama Selomit, anak Dibri dari suku Dan. Suatu hari, anak Selomit itu bertengkar dengan seorang Israel lain. Ketika sedang bertengkar, dia menyebut nama TUHAN dengan tidak hormat. Karena itu orang Israel membawa dia ke hadapan Musa. ");
INSERT INTO ind_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mereka memasukkan dia ke dalam tahanan sambil menunggu keputusan TUHAN terhadapnya. ");
INSERT INTO ind_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Bawalah orang yang sudah menghina-Ku itu keluar dari perkemahan. Setiap orang yang mendengar dia menghina Aku harus meletakkan tangannya di atas kepala orang itu sebagai pernyataan bahwa orang itu menanggung dosanya sendiri. Sesudah itu, mereka harus melemparinya dengan batu sampai mati. ");
INSERT INTO ind_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Sampaikan kepada seluruh orang Israel, ‘Siapa pun yang menghina Aku akan menanggung dosanya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Setiap orang yang menyebut nama TUHAN dengan tidak hormat, baik orang Israel asli maupun pendatang, harus dihukum mati dengan dilempari batu oleh seluruh umat. ");
INSERT INTO ind_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Siapa pun yang membunuh orang lain harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Siapa pun yang membunuh hewan milik orang lain harus menggantinya dengan jenis hewan yang sama kepada pemiliknya. ");
INSERT INTO ind_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Jika seseorang mencederai orang lain hingga menjadi cacat, kepadanya harus dibalaskan perbuatan yang sama. ");
INSERT INTO ind_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Patah tulang dibayar patah tulang, mata dibayar mata, dan gigi dibayar gigi. Sebagaimana dia mencederai sesamanya hingga cacat, demikian jugalah harus dibalaskan kepadanya. ");
INSERT INTO ind_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Siapa pun yang membunuh hewan milik orang lain harus menggantinya dengan hewan yang hidup, tetapi siapa pun yang membunuh sesama manusia harus dihukum mati.’ ");
INSERT INTO ind_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“Baik orang Israel asli maupun pendatang terikat oleh peraturan yang sama. Akulah TUHAN yang menegaskan hal-hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Sesudah Musa menyampaikan perintah-perintah TUHAN itu kepada orang Israel, mereka membawa orang yang menghina TUHAN tadi keluar perkemahan, lalu melempari dia dengan batu sampai mati. Dengan demikian bangsa Israel melakukan sesuai dengan perintah TUHAN melalui Musa. ");
INSERT INTO ind_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","TUHAN berkata kepada Musa di gunung Sinai, ");
INSERT INTO ind_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Sampaikanlah kepada umat Israel: Sesudah kalian masuk ke negeri yang Aku berikan, ketahuilah bahwa tanah negeri itu memerlukan waktu perhentian juga, sama seperti kalian beristirahat pada hari Sabat. Setiap tahun ketujuh adalah Tahun Sabat. ");
INSERT INTO ind_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","“Kalian boleh menanami ladang dan memangkas pohon anggur di kebun-kebunmu serta memanen hasilnya selama enam tahun, ");
INSERT INTO ind_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","tetapi pada tahun ketujuh, kalian harus menaati Aku dengan berhenti sepenuhnya dari pekerjaan bercocok tanam itu supaya tanahmu mengalami masa perhentian. ");
INSERT INTO ind_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Jadi, dalam tahun Sabat, jangan memanen tanaman yang tumbuh sendiri di ladang sesudah musim panen sebelumnya, ataupun dari kebun-kebun anggur yang tidak kalian rawat. Biarkanlah tanah itu mengalami masa perhentiannya. ");
INSERT INTO ind_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Tetapi dalam tahun itu kalian boleh memetik dan memakan hasil tanah yang tumbuh sendiri, sehingga para budakmu laki-laki dan perempuan, pekerja upahan, pendatang yang menginap di rumahmu, juga kalian sendiri, tetap bisa makan. ");
INSERT INTO ind_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Begitu juga dengan ternakmu dan binatang liar yang berkembang biak di negeri itu. Daging hewan-hewan itu akan menjadi makananmu selama Tahun Sabat.” ");
INSERT INTO ind_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Kalian harus menghitung tujuh kali Tahun Sabat, yaitu tujuh kali tujuh tahun, atau sama dengan empat puluh sembilan tahun. ");
INSERT INTO ind_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","10","Lalu, pada tanggal sepuluh bulan ketujuh, yaitu Hari Raya Pendamaian, kalian akan meniup terompet-terompet di seluruh negeri untuk mengumumkan bahwa Tahun Pemulihan sudah mulai, yaitu tahun kelima puluh. Kalian juga akan mengumumkan tibanya waktu pembebasan kepada seluruh penduduk negeri Israel. Pada tahun itu, tanah yang sebelumnya dijual akan dikembalikan kepada pemilik asalnya atau keturunannya, dan orang Israel asli yang dijual sebagai budak bebas untuk kembali kepada tanah warisan mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Pada Tahun Pemulihan itu, kalian juga tidak boleh bercocok tanam ataupun memanen kebun-kebun anggur yang tidak kalian rawat. ");
INSERT INTO ind_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Hormatilah Tahun Pemulihan sebagai tahun yang kudus. Kalian boleh memetik dan memakan hasil tanah yang tumbuh sendiri tanpa mengusahakannya. ");
INSERT INTO ind_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Pada Tahun Pemulihan, kalian akan kembali ke tanah warisanmu masing-masing. ");
INSERT INTO ind_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Jika ada di antara kalian yang menjual atau membeli tanah dengan sesama orang Israel, janganlah merugikan satu sama lain. ");
INSERT INTO ind_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kalian harus menentukan harga tanah berdasarkan jumlah tahun tanah itu bisa dipanen sampai Tahun Pemulihan berikutnya. ");
INSERT INTO ind_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Semakin banyak jumlah tahun sebelum Tahun Pemulihan, semakin tinggi harga tanah. Demikian juga sebaliknya, semakin sedikit jumlah tahun sebelum Tahun Pemulihan, semakin rendah pula harga tanah itu. Karena sebenarnya yang dijual bukan tanah, melainkan jumlah panen yang bisa dihasilkan tanah itu. ");
INSERT INTO ind_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Jangan merugikan satu sama lain, tetapi hormat dan takutlah akan Aku. Aku, TUHAN Allahmu, menegaskan hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Patuhilah semua peraturan yang sudah Aku berikan, maka kalian akan hidup aman di negeri Kanaan. ");
INSERT INTO ind_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tanah itu akan menghasilkan panen melimpah sehingga kalian akan makan sampai kenyang dan tinggal di sana dengan aman. ");
INSERT INTO ind_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Tetapi mungkin ada orang yang bertanya, ‘Apa yang akan kami makan pada tahun ketujuh jika kami tidak boleh menanam dan tidak boleh memanen?’ ");
INSERT INTO ind_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","22","Jawabannya, Aku akan memberkati kalian pada tahun yang keenam dengan panen berlimpah, sehingga pada tahun kedelapan, ketika kalian menabur kembali di ladang— bahkan sampai masa panennya— kalian masih akan memakan hasil panen dari tahun keenam.” ");
INSERT INTO ind_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Janganlah menjual tanah secara permanen karena tanah itu adalah milik-Ku. Kalian hanyalah pendatang yang Aku izinkan menumpang di sana dan mengolah tanah itu. ");
INSERT INTO ind_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Kalau kalian membeli tanah, kalian harus memberi hak kepada pemilik asalnya untuk menebus tanah itu. ");
INSERT INTO ind_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Jika sesamamu orang Israel menjadi miskin sehingga dia terpaksa menjual sebagian tanahnya, saudara terdekat orang itu diperbolehkan menebus tanah yang sudah dijual oleh saudaranya itu. ");
INSERT INTO ind_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kalau dia tidak punya saudara dekat untuk menebus tanahnya, tetapi di kemudian hari dia mendapat uang yang cukup untuk menebus tanahnya kembali, ");
INSERT INTO ind_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","dia berhak membayar nilai tebus tanah itu kepada orang yang membelinya, supaya dia bisa kembali ke sana. Nilai tebusnya dihitung berdasarkan jumlah nilai hasil panen dalam tahun-tahun yang tersisa hingga Tahun Pemulihan berikutnya. ");
INSERT INTO ind_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Namun, jika dia tidak mampu menebus tanahnya, tanah itu tetap menjadi milik si pembeli sampai Tahun Pemulihan. Lalu pada tahun itu, tanah akan dibebaskan dan pemilik semula bisa kembali ke tanahnya. ");
INSERT INTO ind_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Jika seseorang menjual rumah di suatu kota yang berbenteng, dia hanya punya waktu satu tahun untuk menebusnya, terhitung sejak rumah itu dijual. ");
INSERT INTO ind_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Bila dia tidak menebus rumah itu dalam jangka waktu satu tahun, rumah itu akan seterusnya menjadi milik pembelinya dan keturunannya. Pada Tahun Pemulihan, rumah itu tidak akan dikembalikan kepada pemilik asalnya. ");
INSERT INTO ind_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Akan tetapi, rumah di desa yang tidak dikelilingi benteng akan diperlakukan seperti lahan terbuka. Jika seseorang menjual rumahnya di desa, dia boleh menebus kembali rumah itu di kemudian hari. Dan bila tidak ditebus, rumah itu harus dikembalikan kepadanya pada Tahun Pemulihan. ");
INSERT INTO ind_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Khusus untuk orang Lewi, mereka akan selalu berhak kapan saja untuk menebus kembali rumah yang mereka jual di kota-kota yang ditetapkan untuk suku Lewi. ");
INSERT INTO ind_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Setiap rumah di kota-kota Lewi yang dijual harus dikembalikan pada Tahun Pemulihan, karena rumah-rumah itu adalah milik mereka di antara bangsa Israel. ");
INSERT INTO ind_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Namun, padang rumput tempat menggembalakan ternak di sekitar kota-kota mereka tidak boleh dijual karena padang rumput itu adalah milik mereka selamanya.” ");
INSERT INTO ind_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Jika saudaramu sesama orang Israel jatuh miskin sehingga tidak mampu bertahan hidup di antara kalian, haruslah kamu menolong dia seperti menolong orang asing dan pendatang, agar mereka bisa tetap tinggal di antara kalian. ");
INSERT INTO ind_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Bila kamu meminjamkan uang kepadanya, janganlah mengambil bunga atau keuntungan, tetapi hormat dan takutlah akan Allahmu dengan menolong saudaramu itu agar dia bisa bertahan hidup di antara kalian. ");
INSERT INTO ind_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Jangan menarik keuntungan dari uang yang kamu pinjamkan maupun dari makanan yang kamu jual kepadanya. ");
INSERT INTO ind_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Aku, TUHAN, menegaskan hal ini karena Akulah yang membawa kalian keluar dari Mesir dan memberikan negeri Kanaan kepada kalian supaya Aku menjadi Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Jika sesamamu orang Israel jatuh miskin sehingga menjual dirinya kepadamu sebagai budak, janganlah memperlakukan dia seperti budak. ");
INSERT INTO ind_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Perlakukan dia seperti pekerja upahan atau perantau, sampai Tahun Pemulihan tiba. ");
INSERT INTO ind_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Pada Tahun Pemulihan, dia dan anak-anaknya harus dibebaskan supaya mereka bisa kembali kepada keluarga dan tanah warisan nenek moyangnya. ");
INSERT INTO ind_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Jangan menjual orang Israel sebagai budak kepada bangsa lain, karena mereka adalah milik-Ku yang Aku bawa keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Jika kamu membeli sesama orang Israel sebagai budak, sebagai rasa hormat dan takut kepada-Ku, janganlah memperlakukan dia dengan kejam. ");
INSERT INTO ind_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Kalian boleh membeli budak laki-laki dan perempuan dari bangsa-bangsa lain yang tinggal di sekitarmu ");
INSERT INTO ind_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","atau anak-anak orang asing yang tinggal di antara kalian, juga keturunan mereka yang lahir di negerimu. Mereka boleh menjadi milikmu. ");
INSERT INTO ind_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Hak milik atas mereka boleh kalian wariskan kepada anak-anakmu turun temurun. Kalian boleh mempekerjakan orang dari bangsa lain sebagai budak, tetapi sesama orang Israel tidak boleh kalian perlakukan seperti itu. ");
INSERT INTO ind_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Apabila ada pendatang yang tinggal di antara kalian menjadi kaya, dan sesamamu orang Israel jatuh miskin sehingga menjual dirinya sebagai budak kepada orang asing itu, ");
INSERT INTO ind_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","orang Israel tersebut boleh ditebus oleh anggota keluarganya, walaupun dia sudah dibeli sebagai budak. ");
INSERT INTO ind_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Pamannya, sepupunya, atau kerabatnya yang lain boleh menebusnya. Atau jika dia mendapat uang yang cukup, dia boleh menebus dirinya sendiri. ");
INSERT INTO ind_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Penebus dan pemilik budak itu akan menghitung jumlah tahun sejak dia menjual dirinya sebagai budak sampai Tahun Pemulihan berikutnya. Nilai tebus dirinya dihitung berdasarkan upah pekerja upahan selama jumlah tahun yang tersisa itu. ");
INSERT INTO ind_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","“Semakin banyak jumlah tahun yang terhitung sampai Tahun Pemulihan, semakin mahal harga tebusannya. ");
INSERT INTO ind_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Sebaliknya, semakin sedikit jumlah tahun yang terhitung sampai Tahun Pemulihan, semakin kecil pula harga tebusannya. ");
INSERT INTO ind_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Orang asing yang membelinya harus memperlakukan dia seperti pekerja upahan yang dipekerjakan tahun demi tahun. Kalian warga Israel yang bertetangga dengan pemilik budak itu tidak boleh membiarkan dia memperbudak orang Israel itu dengan kejam. ");
INSERT INTO ind_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Bila orang Israel itu tidak ditebus dengan cara-cara tersebut, dia dan anak-anaknya tetap akan dibebaskan pada Tahun Pemulihan. ");
INSERT INTO ind_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Aku menegaskan hal ini, karena Akulah TUHAN Allahmu yang membebaskan kalian dari perbudakan di Mesir untuk menjadikan kalian hamba-hamba-Ku.” ");
INSERT INTO ind_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","2","TUHAN berkata, “Jangan membuat berhala, atau mendirikan patung dan tiang berhala, ataupun memasang ukiran batu di negeri kalian untuk disembah. Taatilah peraturan-peraturan hari Sabat-Ku dan hormatilah kemah-Ku. Aku, TUHAN Allahmu, menegaskan kedua hal ini. ");
INSERT INTO ind_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Jika kamu melakukan semua perintah-Ku dengan setia, ");
INSERT INTO ind_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Aku akan menurunkan hujan pada musimnya, dan hasil ladang serta pohonmu akan melimpah. ");
INSERT INTO ind_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Panenmu akan begitu banyak, sehingga kamu masih akan mengirik hasil gandum sampai masa panen anggur tiba. Dan kamu masih akan terus memanen serta mengolah anggur sampai masa menanam bibit gandum-ganduman tiba. Kamu akan makan sampai kenyang dan tinggal dengan aman di negerimu. ");
INSERT INTO ind_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Aku akan memberi ketenangan di negerimu sehingga kamu bisa tidur tanpa takut apa pun. Aku akan menjaga negerimu dari binatang buas dan serangan musuh. ");
INSERT INTO ind_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Saat perang, kalian akan mengejar musuh-musuhmu dan membunuh mereka. ");
INSERT INTO ind_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Lima dari kalian akan mengejar seratus musuh, dan seratus dari kalian akan mengejar sepuluh ribu musuh. Semua musuh akan tewas di hadapan kalian. ");
INSERT INTO ind_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Aku akan memberkati dan membuatmu beranak cucu sangat banyak. Perjanjian-Ku denganmu akan tetap berlaku untuk seterusnya. ");
INSERT INTO ind_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Hasil panenmu akan begitu melimpah, hingga kamu masih memakan hasil lama sementara hasil panen baru sudah ada, sehingga kamu akan terpaksa mengeluarkan hasil lama dari lumbungnya untuk dapat menyimpan hasil panen yang baru. ");
INSERT INTO ind_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Aku akan tinggal di antara kalian dan tidak akan pernah muak terhadap kalian. ");
INSERT INTO ind_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Aku akan menyertai kalian. Aku akan selalu menjadi Allahmu, dan kalian turun temurun akan menjadi umat-Ku. ");
INSERT INTO ind_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Akulah TUHAN, Allahmu, yang membawamu keluar dari perbudakan di Mesir. Aku sudah membebaskanmu dari belenggu dan beban berat sehingga kalian bisa berjalan tegak.” ");
INSERT INTO ind_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Akan tetapi, jika kamu tidak taat melakukan semua perintah-Ku, ");
INSERT INTO ind_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","jika kamu tidak mau mematuhi ketetapan-Ku, dan hatimu muak mendengar peraturan-Ku sehingga melanggar perintah-Ku dan mengingkari perjanjian-Ku, ");
INSERT INTO ind_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","maka Aku akan menghukummu. Aku akan mendatangkan berbagai macam bencana berikut: Kamu akan diserang penyakit yang membunuh secara perlahan, sehingga hatimu semakin tertekan dan matamu tidak tahan melihatnya. Kamu akan menabur benih, tetapi musuh-musuhmu yang akan memakan hasilnya. ");
INSERT INTO ind_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Saat perang, Aku akan berbalik melawanmu sehingga kalian dikalahkan oleh musuhmu. Orang-orang yang membencimu akan menguasai kalian, dan kalian akan lari ketakutan walaupun tidak ada yang mengejar. ");
INSERT INTO ind_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Jika sesudah mengalami semuanya itu kalian tetap tidak taat kepada-Ku, Aku akan menambah hukuman atas dosa-dosamu berkali-kali lebih berat. ");
INSERT INTO ind_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Aku akan mematahkan kesombonganmu dan menahan turunnya hujan, hingga seolah-olah langit terbuat dari besi dan tanahmu menjadi keras seperti tembaga. ");
INSERT INTO ind_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Kerja kerasmu akan sia-sia karena ladangmu tidak menghasilkan panen dan pohon-pohon tidak berbuah. ");
INSERT INTO ind_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Jika kalian terus melawan Aku dan tidak mau taat kepada-Ku, Aku akan menambah hukuman atas dosa-dosamu berkali-kali lipat lebih berat lagi. ");
INSERT INTO ind_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Aku akan mendatangkan binatang-binatang buas ke tengah-tengah kalian, untuk membunuh anak-anakmu dan menghabisi ternakmu. Jumlah kalian akan menjadi sedikit, sehingga jalan-jalan yang biasanya ramai menjadi sepi. ");
INSERT INTO ind_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Apabila sesudah semua hukuman itu, kalian tetap tidak belajar dan masih terus melawan Aku, ");
INSERT INTO ind_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Aku pun akan melawan dan menghajar kalian berkali-kali lipat lebih berat lagi karena dosa-dosamu. ");
INSERT INTO ind_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Aku akan membuat musuh-musuh menyerang kalian sebagai pembalasan atas perjanjian-Ku yang kalian ingkari. Bila kalian berlindung di dalam kota-kota berbenteng, Aku akan menimpakan wabah penyakit ke atas kalian, dan kalian akan jatuh ke tangan musuh. ");
INSERT INTO ind_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Aku akan membuat kalian tidak bisa mengumpulkan persediaan makanan. Masa kelaparan akan begitu parah sehingga sepuluh ibu rumah tangga hanya perlu satu tempat pembakaran roti untuk keluarga mereka. Mereka akan menimbang dan membagi roti dalam jatah yang kecil-kecil. Kalian masih bisa makan, tetapi tidak akan pernah merasa kenyang. ");
INSERT INTO ind_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Apabila sesudah semuanya itu kalian tetap tidak taat kepada-Ku dan masih melawan Aku, ");
INSERT INTO ind_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Aku pun akan melawan kalian dengan murka. Aku sendiri akan menghukum kalian berkali-kali lipat lagi. ");
INSERT INTO ind_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kalian akan begitu kelaparan hingga memakan daging anak-anakmu sendiri. ");
INSERT INTO ind_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Aku akan menghancurkan tempat-tempat pemujaan berhalamu di bukit-bukit dan meruntuhkan mezbah-mezbah dupamu. Mayat-mayat kalian akan bergelimpangan dan menumpuk di atas patung-patung dewa palsu yang kalian sembah. Aku akan muak terhadap kalian. ");
INSERT INTO ind_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kota-kotamu akan Aku runtuhkan. Tempat-tempat pemujaan dewamu akan Aku jadikan puing-puing. Aku tidak akan lagi menerima bau harum asap persembahan kalian. ");
INSERT INTO ind_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Aku akan menghancurkan negeri itu, sehingga musuh-musuhmu yang sudah menetap di negerimu akan terkejut melihat kehancuran yang terjadi. ");
INSERT INTO ind_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Aku akan membuat kalian tercerai-berai di antara bangsa-bangsa lain. Melalui pedang musuh, Aku akan menghabisi kalian, sehingga tanahmu terlantar dan kota-kotamu menjadi tumpukan puing-puing. ");
INSERT INTO ind_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Sementara kalian berada di negeri musuh, tanah itu akan terlantar untuk menikmati masa perhentian yang tidak didapatkannya pada tahun-tahun Sabat selama kalian menetap di sana. ");
INSERT INTO ind_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","“Bagi yang masih hidup, Aku akan membuat hatimu selalu gelisah di negeri musuh. Suara daun yang ditiup angin pun akan membuatmu ketakutan hingga kalian lari seperti sedang diserang. Kalian akan jatuh tersandung satu sama lain meskipun tidak ada yang mengejar. Kalian sama sekali tidak akan sanggup berdiri melawan musuh. ");
INSERT INTO ind_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Di negeri bangsa-bangsa asing, kalian akan mati dan membusuk. ");
INSERT INTO ind_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Dan kalian yang masih hidup akan merana di negeri musuh karena dosa-dosamu sendiri dan dosa nenek moyangmu yang sudah binasa lebih dulu. ");
INSERT INTO ind_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","42","“Akan tetapi, jika kalian mengakui dosa-dosamu dan dosa nenek moyangmu, yaitu tidak taat terhadap-Ku dan melawan Aku— dosa yang membuat Aku melawan kalian dan membawamu ke negeri musuh— maka Aku akan menepati lagi perjanjian-Ku dengan Yakub, Isak, dan Abraham. Jika kalian merendahkan hatimu dan dengan rela menerima hukuman atas dosa-dosamu, Aku akan memulihkan negerimu. ");
INSERT INTO ind_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Namun, negeri itu harus dikosongkan dahulu untuk menikmati tahun-tahun Sabatnya, sementara kalian tinggal di negeri musuh untuk menanggung hukuman atas dosa-dosamu, yaitu menolak peraturan-Ku dan muak terhadap perintah-Ku. ");
INSERT INTO ind_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Meski demikian, Aku tidak akan sepenuhnya menolak kalian ataupun muak terhadapmu selama kalian berada di negeri musuh. Aku tidak akan melanggar perjanjian-Ku dengan memusnahkan kalian seluruhnya, sebab Akulah TUHAN Allahmu. ");
INSERT INTO ind_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Demi kebaikanmu, Aku akan tetap menepati perjanjian-Ku dengan nenek moyang kalian, karena Aku membawa mereka keluar dari Mesir supaya Aku menjadi Allah mereka, dan peristiwa besar itu disaksikan oleh bangsa-bangsa lain. Aku, TUHAN, menegaskan semua hal ini.” ");
INSERT INTO ind_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Demikianlah seluruh ketetapan, peraturan, dan hukum yang diberikan TUHAN kepada Israel melalui Musa di gunung Sinai. ");
INSERT INTO ind_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Sampaikanlah kepada umat Israel: Apabila kamu berjanji untuk menyerahkan orang lain menjadi pengabdi kepada-Ku seumur hidupnya, tetapi kemudian kamu ingin membebaskan dia dari pengabdiannya, kamu harus menebus dia dengan membayar kepada imam sesuai nilai yang ditetapkan. ");
INSERT INTO ind_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","“Berikut ini adalah ketentuan nilai tebus seseorang dalam jumlah keping perak, sesuai pengukur berat yang sah. Usia Jenis Kelamin Nilai 1 bulan -5 tahun Laki-laki 5 keping perak 1 bulan -5 tahun Perempuan 3 keping perak 5-20 tahun Laki-laki 20 keping perak 5-20 tahun Perempuan 10 keping perak 20-60 tahun Laki-laki 50 keping perak 20-60 tahun Perempuan 30 keping perak di atas 60 tahun Laki-laki 15 keping perak di atas 60 tahun Perempuan 10 keping perak ");
INSERT INTO ind_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Jika orang yang berjanji itu terlalu miskin sehingga tidak mampu membayar nilai tebus yang berlaku, dia harus membawa orang yang hendak ditebusnya kepada imam. Imam akan menentukan nilai yang lebih rendah sesuai kemampuan orang itu. ");
INSERT INTO ind_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Apabila kamu berjanji untuk memberikan kepada-Ku hewan yang halal untuk dipersembahkan, maka seluruh persembahan itu adalah suci. ");
INSERT INTO ind_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kamu tidak boleh menukar hewan itu dengan hewan lain, baik menukar hewan yang bagus dengan hewan yang buruk, maupun sebaliknya. Jika kamu menukarnya, maka kedua hewan itu akan dianggap suci dan keduanya harus dipersembahkan kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Tetapi apabila hewan yang dijanjikan adalah hewan yang haram, yang tidak boleh dipersembahkan kepada-Ku, dia harus membawa hewan itu kepada imam. ");
INSERT INTO ind_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Imam akan menentukan nilai hewan itu berdasarkan baik buruknya. Berapa pun nilai yang ditetapkan imam, itulah harga hewan itu. ");
INSERT INTO ind_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Jika kamu ingin menebus hewan itu kembali, kamu harus membayar nilai hewan itu ditambah dua puluh persen. ");
INSERT INTO ind_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Apabila kamu memberikan rumahmu sebagai persembahan kudus bagi-Ku, imam akan menentukan nilainya berdasarkan baik buruknya rumah itu. Berapa pun nilai yang ditetapkan imam, itulah harga rumah itu. ");
INSERT INTO ind_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Jika kamu ingin menebus rumahmu kembali, kamu harus membayar nilai rumah itu ditambah dua puluh persen. Maka rumah itu akan kembali menjadi milikmu. ");
INSERT INTO ind_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Apabila kamu memberikan sebagian tanahmu sebagai persembahan bagi-Ku, nilai tanah yang ditentukan harus sesuai dengan jumlah benih yang dibutuhkan untuk menanami tanah tersebut. Ketentuannya adalah sepuluh keping perak untuk setiap luasan tanah yang membutuhkan dua puluh kilogram benih jelai. ");
INSERT INTO ind_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jika kamu menyerahkan tanah itu pada Tahun Pemulihan, nilai tanah tersebut tetap utuh. ");
INSERT INTO ind_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Namun, jika kamu mempersembahkan tanah itu sesudah Tahun Pemulihan, imam akan menentukan nilai yang lebih rendah untuk tanah itu, menurut jumlah tahun yang tersisa sampai Tahun Pemulihan berikutnya. ");
INSERT INTO ind_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Jika kamu ingin menebus tanahmu kembali, kamu harus membayar nilai tanah itu ditambah dua puluh persen. Maka tanah itu akan kembali menjadi milikmu. ");
INSERT INTO ind_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Jika kamu tidak menebus tanah itu kembali dan para imam sudah menjualnya kepada orang lain, kamu tidak berhak lagi untuk menebusnya. ");
INSERT INTO ind_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Pada Tahun Pemulihan berikutnya, tanah itu menjadi suci bagi-Ku dan akan menjadi milik para imam. ");
INSERT INTO ind_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Apabila kamu memberikan tanah yang kamu beli dari pemilik aslinya, yang bukan milik keluargamu, sebagai persembahan bagi-ku, ");
INSERT INTO ind_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","imam akan menentukan nilai tanah itu berdasarkan jumlah tahun yang tersisa sampai Tahun Pemulihan berikutnya. Pada hari penilaian itu, pemilik pertama harus membayar nilai tanah tersebut sebagai persembahan suci bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Kalau itu dilakukan, maka pada Tahun Pemulihan nanti tanah itu akan dikembalikan kepada pemilik aslinya atau keturunannya. ");
INSERT INTO ind_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Semua nilai harus ditentukan dalam jumlah keping perak, sesuai pengukur berat yang sah, yaitu sebelas gram. ");
INSERT INTO ind_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Kalian tidak boleh mempersembahkan anak sulung hewan-hewanmu sebagai persembahan sukarela, baik sapi, domba, atau kambing, karena hewan-hewan itu memang sudah merupakan milik-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Namun, jika hewan itu adalah hewan yang haram, kamu dapat menebusnya sejumlah nilai yang ditentukan oleh imam ditambah dua puluh persen. Jika tidak ditebus, imam akan menjual hewan itu sesuai nilainya. ");
INSERT INTO ind_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Apa saja yang sudah dikhususkan sebagai persembahan suci bagi-Ku, baik itu manusia, hewan, maupun tanah, tidak boleh ditebus atau dijual. Semua binatang dan benda yang dikhususkan seperti itu harus diperlakukan sebagai persembahan sangat suci bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Setiap orang yang Aku tentukan untuk dimusnahkan tidak boleh ditebus, tetapi harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Sepersepuluh dari setiap hasil panen, baik gandum-ganduman maupun buah-buahan, adalah milik-Ku. Itu harus dipersembahkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Apabila kamu ingin menebus sebagian dari persembahan perpuluhan hasil panenmu, kamu dapat melakukannya dengan membayar nilainya sesuai ketentuan ditambah dua puluh persen. ");
INSERT INTO ind_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mengenai persembahan perpuluhan dari ternak, setiap hitungan hewan yang kesepuluh harus menjadi persembahan suci bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Pemilik ternak tidak boleh memilih antara yang baik dan yang buruk. Dia juga tidak boleh menukarnya. Jika ditukar, maka kedua hewan itu menjadi persembahan suci dan tidak boleh ditebus.” ");
INSERT INTO ind_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Demikianlah perintah-perintah yang TUHAN berikan kepada Musa di gunung Sinai untuk orang Israel.");
INSERT INTO ind_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Pada hari pertama, bulan kedua, pada tahun kedua sejak bangsa Israel keluar dari Mesir, TUHAN berkata kepada Musa di dalam kemah-Nya di padang belantara Sinai, ");
INSERT INTO ind_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Kamu dan Harun harus mengadakan sensus seluruh rakyat Israel menurut marga dan keluarga mereka, kecuali suku Lewi. Catatlah nama semua laki-laki ");
INSERT INTO ind_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","yang berumur dua puluh tahun ke atas yang sanggup berperang, berdasarkan regu mereka masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","9","“Kalian akan dibantu oleh para kepala suku ini: Suku Kepala suku Ruben Elizur anak Syedeur Simeon Selumiel anak Zurisyadai Yehuda Nahason anak Aminadab Isakar Netanel anak Zuar Zebulon Eliab anak Helon ");
INSERT INTO ind_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","15","Suku Kepala suku Benyamin Abidan anak Gideoni Dan Ahiezer anak Amisydai Asyer Pagiel anak Okran Gad Eliasaf anak Rehuel Naftali Ahira anak Enan Efraim Elisama anak Amihud Manasye Gamaliel anak Pedazur (Suku Efraim dan Manasye adalah keturunan Yusuf.) ");
INSERT INTO ind_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Orang-orang itu adalah kepala setiap suku di Israel.” ");
INSERT INTO ind_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","19","Sesuai perintah TUHAN, Musa dan Harun memanggil kedua belas orang yang dipilih tadi. Kemudian, pada hari itu juga para kepala suku mengumpulkan seluruh umat Israel. Nama setiap laki-laki yang berumur dua puluh tahun ke atas dicatat menurut marga dan keluarga masing-masing. Pencatatan itu dilakukan di padang belantara Sinai. ");
INSERT INTO ind_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Berikut ini hasil sensus laki-laki yang berumur dua puluh tahun ke atas yang sanggup berperang, berdasarkan catatan marga dan keluarga mereka. Suku Jumlah orang Ruben (anak sulung Yakub) 46.500 Simeon 59.300 Gad 45.650 Yehuda 74.600 Isakar 54.400 Zebulon 57.400 Efraim 40.500 Menasye 32.200 Benyamin 35.400 Dan 62.700 Asyer 41.500 Naftali 53.400 ");
INSERT INTO ind_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Itulah jumlah orang yang dicatat di bawah pengawasan Musa, Harun, dan kedua belas kepala suku. ");
INSERT INTO ind_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Dengan demikian, jumlah keseluruhan laki-laki yang berumur dua puluh tahun ke atas yang sanggup berperang, berdasarkan catatan marga dan keluarga mereka, ");
INSERT INTO ind_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","adalah 603.550 orang. ");
INSERT INTO ind_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Jumlah itu tidak termasuk suku Lewi ");
INSERT INTO ind_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","karena TUHAN sudah berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ketika menghitung jumlah pasukan suku-suku Israel, janganlah menghitung suku Lewi, ");
INSERT INTO ind_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","sebab mereka ditugaskan untuk mengurus kemah-Ku, tempat peti perjanjian-Ku disimpan. Mereka bertanggungjawab atas pengangkutan kemah-Ku dan semua perlengkapannya. Mereka akan berkemah di sekelilingnya dan merawatnya. ");
INSERT INTO ind_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Setiap kali kemah-Ku dipindahkan, hanya orang Lewi yang bertugas membongkar dan mendirikannya kembali. Selain mereka, siapa pun yang mendekati kemah-Ku akan dihukum mati. ");
INSERT INTO ind_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Setiap suku Israel yang lain akan berkemah di lingkungan perkemahan masing-masing, yang ditandai dengan bendera lambang pasukan mereka. ");
INSERT INTO ind_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Tetapi orang Lewi akan berkemah di sekeliling kemah-Ku untuk menjaganya, supaya umat Israel yang lain tidak mendekati kemah-Ku dan ditimpa murka-Ku.” ");
INSERT INTO ind_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Maka bangsa Israel melakukan semua itu sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Lalu TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Bangsa Israel harus berkemah mengelilingi Kemah Suci di tempat yang agak jauh, menghadap ke arah kemah itu. Setiap orang Israel harus berkemah di lingkungan perkemahan mereka masing-masing, menurut bendera lambang pasukan dan bendera lambang marga mereka. ");
INSERT INTO ind_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","“Kelompok pasukan Yehuda harus berkemah di sebelah timur, menurut regu mereka. Berikut ini adalah ketiga suku dalam perkemahan kelompok pasukan Yehuda, beserta nama pemimpin mereka dan jumlah pasukan yang tercatat: Suku Pemimpin Jumlah Yehuda Nahason anak Aminadab 74.600 ");
INSERT INTO ind_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Isakar Netaneel anak Zuar 54.400 ");
INSERT INTO ind_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Zebulon Eliab anak Helon 57.400 ");
INSERT INTO ind_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Jumlah seluruh anggota pasukan Yehuda 186.400 orang. Ketiga suku inilah yang berada di barisan terdepan setiap kali bangsa Israel akan berangkat. ");
INSERT INTO ind_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","“Kelompok pasukan Ruben harus berkemah di sebelah selatan, menurut regu mereka. Berikut ini adalah ketiga suku dalam perkemahan kelompok pasukan Ruben, beserta nama pemimpin mereka dan jumlah pasukan yang tercatat: Suku Pemimpin Jumlah Ruben Elizur anak Syedeur 46.500 ");
INSERT INTO ind_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","Simeon Selumiel anak Zurisyadai 59.300 ");
INSERT INTO ind_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Gad Eliasaf anak Rehuel 45.650 ");
INSERT INTO ind_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Jumlah seluruh anggota pasukan Ruben 151.450 orang. Ketiga suku ini berangkat pada urutan kedua. ");
INSERT INTO ind_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Sesudah itu, orang Lewi maju membawa kemah suci dari tengah-tengah perkemahan. Setiap suku Israel harus berjalan dalam urutan yang sama seperti saat mereka berkemah, menurut bendera kelompok pasukan mereka. ");
INSERT INTO ind_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","“Kelompok pasukan Efraim harus berkemah di sebelah barat, menurut regu mereka. Berikut ini adalah ketiga suku dalam perkemahan kelompok pasukan Efraim, beserta nama pemimpin mereka dan jumlah pasukan yang tercatat: Suku Pemimpin Jumlah Efraim Elisama anak Amihud 40.500 ");
INSERT INTO ind_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Manasye Gamaliel anak Pedazur 32.200 ");
INSERT INTO ind_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Benyamin Abidan anak Gideoni 35.400 ");
INSERT INTO ind_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Jumlah seluruh anggota pasukan Efraim 108.100 orang. Ketiga suku ini berangkat pada urutan ketiga. ");
INSERT INTO ind_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","“Kelompok pasukan Dan harus berkemah di sebelah utara, menurut regu mereka. Berikut ini adalah ketiga suku dalam perkemahan kelompok pasukan Dan, beserta nama pemimpin mereka dan jumlah pasukan yang tercatat: Suku Pemimpin Jumlah Dan Ahiezer anak Amisyadai 62.700 ");
INSERT INTO ind_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Asyer Pagiel anak Okran 41.500 ");
INSERT INTO ind_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Naftali Ahira anak Enan 53.400 ");
INSERT INTO ind_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Jumlah seluruh anggota pasukan Dan 157.600 orang. Ketiga suku ini berangkat pada urutan terakhir.” ");
INSERT INTO ind_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Demikianlah sensus umat Israel menurut keluarga mereka masing-masing. Jumlah seluruh anggota pasukan Israel menurut regu mereka terhitung sebanyak 603.550 orang. ");
INSERT INTO ind_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tetapi suku Lewi tidak dicatat bersama suku-suku Israel lainnya, seperti perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Bangsa Israel menaati semua yang TUHAN perintahkan kepada Musa. Mereka berkemah menurut bendera kelompok pasukan mereka, dan waktu berangkat, setiap orang berjalan dalam kelompok marganya dan keluarganya masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Inilah catatan tentang keluarga Harun dan Musa pada waktu TUHAN berbicara kepada Musa di gunung Sinai. ");
INSERT INTO ind_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harun memiliki empat anak laki-laki, yaitu Nadab (yang sulung), Abihu, Eleazar, dan Itamar. ");
INSERT INTO ind_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Keempat anak Harun ini diurapi dan ditugaskan untuk melayani sebagai imam. ");
INSERT INTO ind_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Tetapi Nadab dan Abihu mati di padang belantara Sinai saat mereka membakar dupa di hadapan TUHAN dengan cara yang melanggar perintah TUHAN karena TUHAN tidak perintahkan untuk hal itu dilakukan. Pada waktu itu keduanya tidak punya anak laki-laki yang bisa menggantikan mereka sebagai imam. Jadi, hanya tertinggal Eleazar dan Itamar yang dapat melayani sebagai imam bersama ayah mereka, Harun. ");
INSERT INTO ind_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Kumpulkanlah suku Lewi di hadapan Imam Harun, supaya dia mengadakan upacara penahbisan untuk mengangkat mereka menjadi pembantu para imam. ");
INSERT INTO ind_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Tugas mereka adalah melakukan perintah-perintah imam berkenaan dengan kemah-Ku, demi kebaikan seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Mereka harus memelihara semua perlengkapan kemah-Ku, serta membantu seluruh umat-Ku dalam menjalankan pelayanan yang Aku tetapkan untuk dilakukan di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Dari antara bangsa Israel, tugas khusus suku Lewi adalah membantu pekerjaan Harun dan keturunannya. ");
INSERT INTO ind_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“Angkatlah Harun dan anak-anaknya untuk menjabat sebagai imam. Orang selain imam dan suku Lewi yang dengan sembarangan mendekat ke kemah-Ku harus dihukum mati.” ");
INSERT INTO ind_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kata TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Dulu, ketika Aku membunuh semua anak sulung laki-laki orang Mesir, Aku mengkhususkan bagi-Ku semua anak sulung laki-laki Israel, baik manusia maupun ternak. Mereka menjadi milik-Ku. Tetapi sekarang Aku sudah memilih suku Lewi sebagai pengganti semua anak sulung bangsa Israel. Maka suku Lewilah yang menjadi milik-Ku. Akulah TUHAN yang menegaskan hal ini.” ");
INSERT INTO ind_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","TUHAN berkata kepada Musa di padang belantara Sinai, ");
INSERT INTO ind_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Adakanlah sensus untuk semua laki-laki suku Lewi yang berumur satu bulan ke atas menurut keluarga dan marga mereka masing-masing.” ");
INSERT INTO ind_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Lalu Musa melakukan sensus sesuai dengan perintah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lewi memiliki tiga anak laki-laki bernama Gerson, Kehat, dan Merari. ");
INSERT INTO ind_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","20","Gerson memiliki dua anak laki-laki bernama Libni dan Simei. Kehat memiliki empat anak laki-laki bernama Amram, Yisar, Hebron, dan Uziel. Merari memiliki dua anak laki-laki bernama Mahli dan Musi. Nama setiap cucu Lewi ini masing-masing menjadi marga. ");
INSERT INTO ind_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Keturunan Gerson terdiri dari marga Libni dan Simei. ");
INSERT INTO ind_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Jumlah laki-laki yang berumur satu bulan ke atas adalah 7.500 orang. ");
INSERT INTO ind_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Kedua marga itu berkemah di belakang kemah TUHAN di sebelah barat. ");
INSERT INTO ind_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Pemimpin kedua marga itu bernama Eliasaf anak Lael. ");
INSERT INTO ind_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Mereka bertanggung jawab memelihara kemah TUHAN, termasuk kain-kain penutup kemah, tirai pintu masuk kemah, ");
INSERT INTO ind_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","tirai-tirai yang memagari halaman di sekeliling kemah dan mezbah, tirai pintu gerbang, tali-talinya, dan semua perlengkapannya. ");
INSERT INTO ind_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keturunan Kehat terdiri dari marga Amram, Yisar, Hebron, dan Uziel. ");
INSERT INTO ind_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Jumlah laki-laki yang berumur satu bulan ke atas adalah 8.600 orang. Mereka bertugas memelihara barang-barang di dalam kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Empat marga itu berkemah di sebelah selatan kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Pemimpin keempat marga itu bernama Elisafan anak Uziel. ");
INSERT INTO ind_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mereka bertanggung jawab memelihara peti perjanjian, meja, tiang pelita bercabang, mezbah-mezbah, peralatan di dalam kemah suci yang digunakan untuk ibadah, tirai pemisah ruang mahakudus, dan semua perlengkapannya. ");
INSERT INTO ind_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Kepala pemimpin semua suku Lewi adalah Eleazar anak Harun. Dia bertugas mengawasi semua pekerjaan di kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Keturunan Merari terdiri dari marga Mahli dan Musi. ");
INSERT INTO ind_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Jumlah laki-laki yang berumur satu bulan ke atas adalah 6.200 orang. ");
INSERT INTO ind_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Pemimpin kedua marga itu bernama Zuriel anak Abihail. Mereka berkemah di sebelah utara kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mereka bertanggung jawab untuk memelihara rangka-rangka kemah TUHAN, kayu-kayu lintangnya, tiang-tiangnya, alas-alas penahannya, dan semua perlengkapannya. ");
INSERT INTO ind_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Mereka juga bertanggung jawab atas tiang-tiang di sekeliling halaman serta alas-alas penahannya, pasak-pasaknya, dan tali-talinya. ");
INSERT INTO ind_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Tempat yang ditetapkan untuk perkemahan Musa, Harun, serta anak-anaknya adalah di depan kemah TUHAN, yaitu di sebelah timur. Mereka bertanggung jawab mengurus ibadah di kemah TUHAN demi kepentingan bangsa Israel. Siapa pun selain imam dan suku Lewi yang dengan sembarangan mendekat ke kemah-Ku harus dihukum mati. ");
INSERT INTO ind_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Sensus ini dilakukan atas perintah TUHAN, sehingga diketahui jumlah semua laki-laki Lewi adalah 22.000 orang. ");
INSERT INTO ind_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Kemudian TUHAN berkata kepada Musa, “Adakanlah sensus untuk semua laki-laki yang sulung di seluruh Israel, yang berumur satu bulan ke atas, kecuali dari suku Lewi. ");
INSERT INTO ind_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Mulai sekarang laki-laki suku Lewi diperhitungkan sebagai pengganti semua laki-laki yang sulung dari suku-suku Israel yang lain. Demikian juga dengan ternak. Ternak milik suku Lewi menggantikan semua ternak sulung milik suku-suku lain. Akulah TUHAN yang menegaskan perintah ini.” ");
INSERT INTO ind_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Lalu Musa mengadakan sensus itu sesuai dengan perintah TUHAN, ");
INSERT INTO ind_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","sehingga diketahui jumlah semua laki-laki sulung dari suku-suku Israel selain Lewi adalah 22.273 orang. ");
INSERT INTO ind_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Lalu TUHAN berkata lagi kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Aku, TUHAN, telah menetapkan bahwa laki-laki sulung Israel digantikan oleh semua laki-laki suku Lewi. ");
INSERT INTO ind_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Namun, ternyata jumlah lelaki sulung Israel lebih banyak daripada semua lelaki suku Lewi. Kelebihannya 273 orang. Maka jumlah yang berlebih itu harus ditebus dengan ");
INSERT INTO ind_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","membayar lima keping perak per orang. Berat keping untuk membayar tebusan ini harus sesuai pengukur berat yang sah, yaitu 11 gram. ");
INSERT INTO ind_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Uang tebusan itu akan diserahkan kepada para imam.” ");
INSERT INTO ind_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","51","Jadi, sesuai perintah TUHAN, Musa menyerahkan uang tebusan itu sebanyak 1.365 keping perak kepada Harun dan anak-anaknya. ");
INSERT INTO ind_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Dari antara suku Lewi, adakanlah sensus untuk marga-marga Kehat, yaitu laki-laki ");
INSERT INTO ind_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","yang berumur 30-50 tahun, yang mampu melakukan tugas di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Tanggung jawab mereka di kemah-Ku adalah mengurus barang-barang yang paling kudus. ");
INSERT INTO ind_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Setiap kali perkemahan Israel hendak pindah ke tempat lain, Harun dan anak-anaknya harus masuk ke dalam kemah-Ku dan melakukan hal-hal berikut ini: Turunkan tirai pemisah ruang mahakudus dan tutupi peti perjanjian dengan tirai itu. ");
INSERT INTO ind_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Tutupi tirai itu dengan kulit yang tidak menyerap air dan bentangkan sehelai kain biru di atasnya. Pasang tongkat-tongkat pengusung pada peti perjanjian. ");
INSERT INTO ind_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Selanjutnya, bentangkan sehelai kain biru pada meja roti sajian-Ku. Di atas kain itu, letakkan piring-piring, sendok-sendok untuk dupa, serta mangkuk-mangkuk dan kendi-kendi untuk persembahan air anggur. Roti sajian juga harus tetap ada di meja itu. ");
INSERT INTO ind_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Bentangkan sehelai kain merah di atas semuanya itu dan tutupi dengan kulit yang tidak menyerap air. Pasang tongkat-tongkat pengusung pada meja. ");
INSERT INTO ind_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Selanjutnya, ambil sehelai kain biru yang lain dan tutupi tiang pelita bercabang beserta pelita-pelita, penjepit-penjepit untuk membuang sumbu yang sudah hangus, wadah kecil untuk menampung sumbu yang hangus, dan semua tempat minyak yang digunakan untuk pelita-pelita. ");
INSERT INTO ind_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Tiang pelita bercabang beserta semua peralatan ini harus ditutupi lagi dengan kulit yang tidak menyerap air, dan diletakkan di atas usungan. ");
INSERT INTO ind_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Selanjutnya, bentangkan sehelai kain biru di atas mezbah dupa dari emas, tutupi dengan kulit yang tidak menyerap air, dan pasang tongkat-tongkat pengusung mezbah dupa. ");
INSERT INTO ind_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Bungkus semua perlengkapan lainnya yang dipakai untuk melayani di kemah-Ku dengan sehelai kain biru, tutupi dengan kulit yang tidak menyerap air, dan letakkan di atas usungan. ");
INSERT INTO ind_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Bersihkan abu dari mezbah kurban, bentangkan sehelai kain ungu di atasnya, ");
INSERT INTO ind_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","dan letakkan semua peralatan mezbah kurban di atas kain itu: kuali-kuali untuk mengangkut bara, garpu penusuk daging, sekop-sekop dan baskom-baskom. Tutupi semuanya itu dengan kulit yang tidak menyerap air dan pasang tongkat-tongkat pengusung pada mezbah kurban. ");
INSERT INTO ind_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Sesudah para imam membungkus semua barang kudus beserta perlengkapannya, barulah kemah siap dipindahkan, dan hanya pada saat itulah keturunan Kehat boleh masuk dengan tongkat pemikul. Mereka dilarang menyentuh barang-barang kudus secara langsung. Apabila menyentuhnya, mereka akan mati. Demikianlah tugas marga-marga Kehat setiap kali kemah-Ku dipindahkan. ");
INSERT INTO ind_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazar anak Harun bertanggung jawab atas minyak untuk pelita, dupa dari wangi-wangian, persembahan gandum rutin, dan minyak pengurapan. Dia juga bertanggung jawab mengawasi seluruh kemah-Ku dan segala isinya, termasuk barang-barang kudus dan peralatannya.” ");
INSERT INTO ind_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“Untuk menjaga agar keturunan Kehat dari suku Lewi tetap hidup dan tidak mati saat mendekati barang-barang kudus, Harun dan anak-anaknya harus mendampingi mereka masuk ke kemah dan memberikan tugas kepada mereka masing-masing tentang barang apa yang harus dibawa oleh setiap orang. ");
INSERT INTO ind_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Keturunan Kehat tidak boleh melihat barang-barang kudus itu sesaat pun, karena mereka akan mati bila melihatnya.” ");
INSERT INTO ind_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","23","“Adakanlah sensus untuk marga-marga Gerson, yaitu laki-laki yang berumur 30-50 tahun, yang mampu melakukan tugas di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Tugas mereka adalah untuk memelihara dan mengangkut barang-barang ini: ");
INSERT INTO ind_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","tirai-tirai kemah-Ku, kemah itu sendiri, serta semua kain linen yang digunakan sebagai penutup, juga kulit-kulit yang tidak menyerap air yang digunakan sebagai penutup, tirai pintu masuk kemah-Ku, ");
INSERT INTO ind_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","tirai-tirai yang mengelilingi halaman kemah dan mezbah, tirai di jalan masuk, tali-tali, dan semua perlengkapannya. ");
INSERT INTO ind_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","“Mereka harus melaksanakan setiap tugas mereka menurut perintah para imam, baik untuk mengangkut barang maupun tugas lainnya. ");
INSERT INTO ind_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Demikianlah tugas keturunan Gerson di kemah-Ku. Pekerjaan mereka dilakukan di bawah pimpinan Itamar anak Harun.” ");
INSERT INTO ind_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","30","“Adakanlah sensus untuk marga-marga Merari, yaitu laki-laki yang berumur 30-50 tahun, yang mampu melakukan tugas di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“Tugas mereka di kemah-Ku adalah mengangkut barang-barang berikut ini: rangka-rangka kemah, kayu-kayu lintang, tiang-tiang serta alas-alas penahannya, ");
INSERT INTO ind_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","juga tiang-tiang di sekeliling halaman kemah serta alas-alas penahannya, pasak-pasaknya, tali-talinya, dan semua perlengkapannya. “Tugaskanlah kepada masing-masing orang mengenai barang apa yang harus mereka angkut. ");
INSERT INTO ind_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Demikianlah seluruh tugas keturunan Merari di kemah-Ku. Pekerjaan mereka dilakukan di bawah pimpinan Itamar anak Harun.” ");
INSERT INTO ind_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Musa, Harun, dan para pemimpin umat Israel menghitung semua laki-laki suku Lewi dari marga-marga Kehat, Gerson, dan Merari yang berumur 30-50 tahun, yang mampu melakukan tugas di kemah TUHAN dan mengangkut barang-barangnya. Nama-nama mereka dicatat berdasarkan nama marga dan keluarga masing-masing. Inilah jumlah mereka: Keturunan Jumlah orang Kehat 2.750 Gerson 2.630 Merari 3.200 Jadi, jumlah keseluruhannya adalah 8.580 orang. ");
INSERT INTO ind_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Demikianlah sensus dilaksanakan sesuai perintah TUHAN kepada Musa. Setiap orang pun terdaftar dan tugasnya ditentukan. ");
INSERT INTO ind_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Perintahkanlah kepada umat Israel supaya mereka mengeluarkan dari perkemahan setiap orang yang menderita penyakit kulit menular, yang tubuhnya sedang mengalami gangguan sehingga mengeluarkan cairan terus-menerus, dan yang najis karena menyentuh mayat. ");
INSERT INTO ind_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Perintah ini berlaku untuk semua orang, baik laki-laki maupun perempuan. Alasannya supaya mereka tidak menajiskan perkemahan, karena Aku tinggal di antara kalian.” ");
INSERT INTO ind_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Maka umat Israel mengeluarkan orang-orang yang seperti itu untuk tinggal di luar perkemahan, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Sampaikanlah kepada umat Israel: Apabila seorang laki-laki atau perempuan tidak setia kepada-Ku dengan melakukan kejahatan terhadap orang lain, orang itu bersalah ");
INSERT INTO ind_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","dan harus mengakui dosanya. Dia harus membayar ganti rugi secara penuh dengan ditambah 20 persen kepada orang yang dia rugikan. ");
INSERT INTO ind_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Tetapi kalau orang yang dirugikan sudah mati dan tidak memiliki kerabat dekat, maka ganti rugi itu adalah hak-Ku dan harus diserahkan kepada imam. Orang yang bersalah juga harus menyerahkan kurban berupa domba jantan supaya kejahatannya diampuni. ");
INSERT INTO ind_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","10","Semua pembayaran yang diberikan kepada-Ku melalui imam dianggap kudus dan menjadi milik imam yang menerimanya.” ");
INSERT INTO ind_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","“Sampaikanlah hal ini kepada umat Israel: Apabila seorang suami merasa cemburu karena dia menduga istrinya berselingkuh, maka ada dua kemungkinan. Pertama, mungkin istrinya memang berselingkuh dan sudah bersetubuh dengan orang lain, tetapi tidak ada saksi dan tidak tertangkap basah. Kedua, istrinya tidak selingkuh. ");
INSERT INTO ind_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Untuk itu, suami yang merasa curiga tadi harus membawa istrinya kepada imam. Dia harus mempersembahkan satu kilogram tepung jelai karena persoalan dengan istrinya itu. Jangan menuang minyak zaitun ataupun menaburkan kemenyan pada tepung itu, karena tepung itu dipersembahkan atas kecemburuan, untuk membuktikan apakah istrinya berselingkuh atau tidak. ");
INSERT INTO ind_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Imam yang bertugas akan menyuruh perempuan itu berdiri di hadapan-Ku. ");
INSERT INTO ind_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","18","Selanjutnya imam akan menyediakan air pahit yang mendatangkan kutuk. Pertama dia akan mengambil air dari bejana pembasuhan di pelataran kemah-Ku dengan baskom tanah liat, lalu memungut debu dari lantai tanah kemah-Ku dan memasukannya ke dalam air itu. Kemudian dia akan melepas ikatan rambut perempuan itu supaya terurai dan menaruh persembahan kecemburuan tersebut ke tangan perempuan itu, sementara imam sendiri memegang baskom berisi air pahit yang mendatangkan kutuk. ");
INSERT INTO ind_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Lalu imam akan menyuruh perempuan itu menyetujui sumpah berikut: ‘Apabila kamu tidak menajiskan dirimu, yaitu bersetubuh dengan laki-laki selain suamimu, maka kutukan air pahit ini tidak akan terjadi kepadamu. ");
INSERT INTO ind_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Tetapi kalau kamu sudah melakukannya, ");
INSERT INTO ind_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","22","TUHAN akan membuat air pahit ini membawa kutukan ke dalam tubuhmu sehingga perutmu membengkak, menjadi mandul, dan semua orang akan mengecam serta mengucilkan kamu.’ Lalu perempuan itu harus menjawab, ‘Amin. Terjadilah seperti sumpah itu.’ ");
INSERT INTO ind_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kemudian imam akan menuliskan kutuk itu pada sehelai kertas dan mencuci kertas itu di dalam air pahit sehingga tintanya larut. ");
INSERT INTO ind_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","26","“Sesudah itu, dia akan mengambil persembahan kecemburuan dari tangan perempuan itu, mengangkatnya untuk menyerahkannya kepada-Ku, dan membawanya ke mezbah. Lalu imam akan mengambil segenggam tepung dari persembahan itu dan membakarnya di atas mezbah sebagai tanda bahwa semua tepung itu sudah dipersembahkan kepada-Ku. Kemudian dia akan menyuruh perempuan itu minum air pahit yang mendatangkan kutuk. ");
INSERT INTO ind_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kalau perempuan itu memang sudah menajiskan diri dengan berselingkuh, air itu akan membawa kutukan ke dalam tubuh perempuan itu dan dia akan sangat menderita. Perutnya akan membengkak, menjadi mandul, dan semua orang akan mengucilkan dia. ");
INSERT INTO ind_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Tetapi kalau perempuan itu tidak berselingkuh, maka dia tidak akan terpengaruh oleh kutukan itu dan tidak menjadi mandul. ");
INSERT INTO ind_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“Demikanlah peraturannya ketika seorang suami merasa cemburu karena dia mencurigai istrinya sudah berselingkuh. Suami akan membawa istrinya menghadap imam, dan imam akan melaksanakan semua peraturan tersebut terhadap perempuan itu di hadapan-Ku. ");
INSERT INTO ind_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kalau perempuan itu memang bersalah, dia akan menanggung akibat dosanya. Tetapi kalau dia ternyata tidak berselingkuh, suaminya pun tidak akan dianggap bersalah karena meminta pelaksanaan peraturan ini.” ");
INSERT INTO ind_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Sampaikanlah kepada umat Israel: Setiap orang, baik laki-laki maupun perempuan bisa menjadi pengabdi Allah dengan menyerahkan diri sepenuhnya kepada-Ku. Dia harus bersumpah khusus sebelum melakukannya. ");
INSERT INTO ind_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Seorang pengabdi Allah dilarang minum air anggur atau minuman keras lainnya. Dia tidak boleh minum apa pun yang dibuat dari anggur, termasuk cuka anggur dan hasil perasan anggur. Dia juga tidak boleh memakan buah anggur, baik yang segar maupun yang sudah dikeringkan. ");
INSERT INTO ind_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Selama masa sumpahnya, pengabdi tidak boleh makan apa pun yang berasal dari pohon anggur, bahkan biji atau kulitnya pun jangan. ");
INSERT INTO ind_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Selama mengabdi bagi-Ku, dia harus menjaga diri supaya tidak menjadi najis. Dia juga tidak boleh mencukur atau memotong rambutnya. Rambutnya harus dibiarkan tumbuh panjang sampai akhir masa sumpah pengabdiannya kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Rambutnya itu adalah tanda bahwa dia dikhususkan bagi-Ku. Dia tidak boleh mendekati jenazah selama masa pengabdiannya itu, sekalipun yang meninggal adalah orang tuanya atau saudara kandungnya sendiri. ");
INSERT INTO ind_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Peraturan-peraturan tersebut berlaku selama masa pengabdiannya. ");
INSERT INTO ind_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Apabila seseorang tiba-tiba mati di dekatnya, maka rambutnya yang menandakan pengabdiannya itu menjadi najis. Dia harus menunggu selama tujuh hari. Pada hari yang ketujuh dia harus mencukur rambutnya. Sesudah itu dia dianggap tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Lalu pada hari yang kedelapan, dia harus membawa dua ekor burung tekukur atau dua ekor anak burung merpati kepada imam yang bertugas di pintu masuk kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Imam itu akan mempersembahkan salah satu burung sebagai kurban penghapus dosa, dan burung yang satunya sebagai kurban yang dibakar habis. Dengan demikian, imam memulihkan hubungan orang itu dengan-Ku atas kenajisannya karena dia sudah berada di dekat jenazah. Kemudian, pada hari itu juga rambut kepalanya kembali menjadi tanda bahwa dia dikhususkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Dia juga harus mengulang masa pengabdiannya dari awal dan sekali lagi menyerahkan diri sepenuhnya kepada-Ku. Dia harus membawa seekor domba jantan berumur setahun sebagai kurban penebus kesalahan. Masa pengabdian yang sudah dia lewati sebelumnya dianggap batal.” ");
INSERT INTO ind_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Beginilah peraturan bagi seorang pengabdi ketika masa sumpahnya selesai. Dia harus pergi ke pintu masuk kemah-Ku ");
INSERT INTO ind_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","dengan membawa persembahan berupa seekor anak domba jantan berumur setahun yang tidak bercacat sebagai kurban yang dibakar habis, seekor anak domba betina berumur setahun yang tidak bercacat sebagai kurban penghapus dosa, dan seekor domba jantan yang tidak bercacat untuk kurban tanda damai, ");
INSERT INTO ind_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","bersama dengan persembahan gandum-ganduman dan persembahan air anggurnya. Dia juga harus membawa satu keranjang berisi dua macam roti yang tidak beragi, yaitu roti yang dibuat dari tepung terbaik dicampur dengan minyak, dan roti tipis kering yang diolesi minyak. ");
INSERT INTO ind_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Imam yang bertugas akan membawa semuanya itu ke hadapan-Ku, lalu mempersembahkan kurban penghapus dosa dan kurban yang dibakar habis itu. ");
INSERT INTO ind_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Selanjutnya imam akan mempersembahkan sekeranjang roti yang tidak beragi dan domba jantan kepada-Ku sebagai kurban tanda damai, beserta persembahan gandum-ganduman dan persembahan air anggur. ");
INSERT INTO ind_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Di pintu kemah-Ku, pengabdi itu akan mencukur habis rambut kepalanya, yang adalah tanda pengabdiannya. Lalu dia akan mengambil rambutnya itu dan melemparkannya ke dalam api di mana kurban tanda damai sedang dibakar. ");
INSERT INTO ind_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Sesudah itu, imam akan mengambil salah satu paha depan domba jantan yang sudah direbus, dan meletakkannya di tangan pengabdi itu bersama satu roti yang tidak beragi dan satu roti tipis. ");
INSERT INTO ind_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Selanjutnya, pengabdi itu akan menyerahkannya kembali kepada imam, dan imam akan mengangkatnya tinggi sebagai persembahan khusus bagi-Ku. Yang juga diangkat tinggi oleh imam adalah bagian dada dari kurban tanda damai dan paha belakangnya. Bagian-bagian itu akan menjadi milik imam, sesuai dengan peraturan kurban. Semua bagian tersebut harus diperlakukan sebagai sesuatu yang kudus. Setelah semuanya selesai, orang itu boleh minum air anggur karena sumpah pengabdiannya sudah berakhir. ");
INSERT INTO ind_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Demikianlah peraturan-peraturan untuk pengabdi. Kalau seorang pengabdi berjanji untuk mempersembahkan kepada-Ku melebihi yang diwajibkan, dia harus menepatinya janjinya itu.” ");
INSERT INTO ind_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Sampaikanlah kepada Harun dan anak-anaknya: Saat kalian mengucapkan berkat kepada umat Israel, katakanlah begini, ");
INSERT INTO ind_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘TUHAN memberkatimu dan menjagamu. ");
INSERT INTO ind_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","TUHAN berkenan kepadamu senantiasa dan menyatakan belas kasih-Nya. ");
INSERT INTO ind_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","TUHAN berbuat baik kepadamu serta memberimu hidup tenteram.’ ");
INSERT INTO ind_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Para imam harus mengucapkan berkat atas nama-Ku bagi umat Israel, karena demikianlah Aku akan memberkati mereka.” ");
INSERT INTO ind_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ketika Musa selesai mendirikan kemah TUHAN, dia mengurapi kemah itu beserta segala perlengkapannya untuk menguduskannya, juga mezbah kurban dan semua peralatannya. ");
INSERT INTO ind_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","3","Pada hari itu juga kedua belas kepala suku Israel memulai giliran untuk datang menyerahkan persembahan peresmian dari suku mereka masing-masing ke hadapan TUHAN, yaitu ke depan kemah-Nya. Mereka adalah kepala-kepala suku yang bertanggung jawab atas sensus. Persembahan tersebut berupa enam gerobak bertutup dan dua belas ekor sapi. Setiap kepala suku memberikan seekor sapi, dan setiap dua kepala suku memberikan satu gerobak. ");
INSERT INTO ind_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Terimalah pemberian mereka dan berikanlah kepada orang Lewi agar dipergunakan untuk mengangkut barang-barang kemah-Ku, sesuai tugas mereka masing-masing.” ");
INSERT INTO ind_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Maka Musa menerima gerobak-gerobak dan sapi-sapi itu, lalu memberikannya kepada keturunan Lewi. ");
INSERT INTO ind_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Marga Gerson menerima dua gerobak dan empat sapi untuk digunakan dalam tugas-tugas mereka. ");
INSERT INTO ind_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Marga Merari menerima empat gerobak dan delapan sapi untuk digunakan dalam tugas-tugas mereka di bawah pengawasan Itamar anak Harun. ");
INSERT INTO ind_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Tetapi marga Kehat tidak menerima apa pun karena mereka bertanggung jawab atas barang-barang kudus yang harus dipikul di atas bahu. ");
INSERT INTO ind_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","11","Sebelumnya TUHAN sudah berkata kepada Musa, “Untuk peresmian mezbah, setiap hari seorang kepala suku akan mendapat giliran untuk menyerahkan persembahan atas nama suku mereka masing-masing.” Kemudian giliran itu dimulai pada hari pertama upacara pengurapan mezbah. Setiap hari seorang kepala suku mendapat giliran menyerahkan persembahan dari sukunya ke depan mezbah. ");
INSERT INTO ind_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Giliran untuk membawa persembahan peresmian tersebut berlangsung selama dua belas hari dengan urutan sebagai berikut: Hari Pemimpin Suku Ke-1 Nahason anak Aminadab Yehuda Ke-2 Netaneel anak Zuar Isakar Ke-3 Eliab anak Helon Zebulon Ke-4 Elizur anak Syedeur Ruben Ke-5 Selumiel anak Zurisyadai Simeon Ke-6 Elyasaf anak Rehuel Gad Ke-7 Elisama anak Amihud Efraim Ke-8 Gamaliel anak Pedazur Manasye Ke-9 Abidan anak Gideoni Benyamin Ke-10 Ahiezer anak Amisyadai Dan Ke-11 Pagiel anak Okran Asyer Ke-12 Ahira anak Enan Naftali Setiap pemimpin membawa persembahan yang sama, yaitu: 1 buah piring perak seberat 1,5 kilogram dan 1 buah mangkok perak seberat 800 gram, keduanya berisi penuh dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak. 1 buah cawan emas seberat 110 gram yang berisi dupa. Untuk kurban yang dibakar habis: 1 ekor sapi jantan muda 1 ekor domba jantan 1 ekor anak domba jantan berumur satu tahun Untuk kurban penghapus dosa: 1 ekor kambing jantan Untuk kurban tanda damai: 2 ekor sapi jantan 5 ekor domba jantan 5 ekor kambing jantan 5 ekor anak domba jantan berumur satu tahun. ");
INSERT INTO ind_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","86","Inilah jumlah seluruh persembahan yang dibawa oleh para pemimpin Israel untuk peresmian mezbah: 12 piring perak dan 12 mangkok perak, semuanya 27 kilogram 12 cawan emas, semuanya 1,4 kilogram, masing-masing berisi dupa. ");
INSERT INTO ind_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Untuk kurban yang dibakar habis: 12 ekor sapi jantan muda 12 ekor domba jantan 12 ekor anak domba jantan berumur satu tahun serta persembahan gandum-gandumannya. Untuk kurban penghapus dosa: 12 ekor kambing jantan ");
INSERT INTO ind_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Untuk kurban tanda perdamaian: 24 ekor sapi jantan 60 ekor domba jantan 60 ekor kambing jantan 60 ekor anak domba jantan berumur satu tahun. Persembahan-persembahan itu diserahkan dalam upacara peresmian mezbah, sesudah mezbah diurapi. ");
INSERT INTO ind_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ketika Musa masuk ke kemah TUHAN untuk berbicara dengan-Nya, Musa mendengar suara TUHAN dari antara kedua bentuk malaikat penjaga di atas penutup peti perjanjian. ");
INSERT INTO ind_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Sampaikanlah kepada Harun: Ketika kamu memasang ketujuh pelita pada tiang pelita, aturlah supaya cahayanya menerangi bagian depan kaki tiang pelita itu.” ");
INSERT INTO ind_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harun pun melakukan seperti yang diperintahkan TUHAN melalui Musa. ");
INSERT INTO ind_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Seluruh tiang pelita itu, mulai dari kakinya sampai hiasan bunganya, dibuat dari emas yang ditempa. Demikianlah tiang pelita itu dikerjakan persis seperti pola yang ditunjukkan TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","7","“Pisahkanlah orang-orang Lewi dari antara umat Israel yang lain dan lakukan tata cara berikut untuk menyucikan mereka: Percikkan air penyucian pada mereka, lalu suruh mereka masing-masing mencukur seluruh tubuh dan mencuci pakaian. ");
INSERT INTO ind_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kemudian mereka harus membawa seekor sapi jantan muda beserta persembahan gandum-gandumannya berupa tepung terbaik yang sudah dicampur dengan minyak zaitun, dan seekor sapi jantan muda lain sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Selanjutnya, suruhlah orang-orang Lewi itu berdiri di depan kemah-Ku dan kumpulkanlah seluruh umat Israel di sana. ");
INSERT INTO ind_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ketika orang-orang Lewi datang ke hadapan-Ku, orang-orang Israel yang lain harus meletakkan tangan atas mereka. ");
INSERT INTO ind_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Sementara itu, Harun akan mengangkat tangannya sebagai lambang bahwa orang-orang Lewi itu dipersembahkan kepada-Ku sebagai pelayan yang dikhususkan dari antara umat Israel untuk melakukan tugas-tugas bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Lalu orang-orang Lewi akan meletakkan tangan mereka di atas kepala kedua sapi jantan muda tadi. Yang seekor dipersembahkan oleh para imam sebagai kurban penghapus dosa, dan yang seekor lagi sebagai kurban yang dibakar habis kepada TUHAN. Dengan kurban itu, hubungan mereka dengan-Ku sudah dipulihkan. ");
INSERT INTO ind_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kemudian suruhlah orang-orang Lewi berdiri di hadapan para imam lagi dan angkatlah tanganmu sebagai lambang bahwa mereka dipersembahkan sebagai pelayan yang dikhususkan bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Dengan demikian, orang-orang Lewi dipisahkan dari antara umat Israel yang lain dan menjadi milik-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Sesudah acara penyucian dan pentahbisan itu, mereka boleh mulai melaksanakan tugas di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Orang Lewi sepenuhnya diserahkan kepada-Ku dari antara umat Israel. Merekalah yang Aku ambil sebagai ganti setiap anak sulung orang Israel. ");
INSERT INTO ind_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ketika aku membunuh semua anak sulung di Mesir, Aku menetapkan bahwa setiap anak sulung di Israel, baik manusia maupun hewan, adalah milik-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Akan tetapi, Aku mengambil orang-orang Lewi sebagai pengganti semua anak sulung umat Israel. ");
INSERT INTO ind_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Aku sudah menyerahkan orang-orang Lewi kepada para imam untuk melaksanakan tugas di kemah-Ku mewakili umat Israel. Mereka juga akan membantu para penyembah dalam melaksanakan berbagai peraturan untuk memulihkan kembali hubungan mereka dengan Aku, supaya mereka tidak ditimpa bencana ketika mendekati kemah-Ku.” ");
INSERT INTO ind_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Maka Musa, Harun, dan seluruh umat Israel melakukan semua perintah TUHAN itu terhadap orang-orang Lewi. ");
INSERT INTO ind_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Orang-orang Lewi melakukan penyucian diri, Harun mempersembahkan mereka kepada TUHAN, dan para imam memberikan kurban yang memulihkan hubungan mereka dengan TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Setelah itu, orang-orang Lewi memulai tugas di kemah TUHAN, di bawah pengawasan para imam. Demikianlah pentahbisan orang-orang Lewi dilakukan sesuai dengan perintah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kata TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Orang-orang Lewi yang berumur dua puluh lima tahun ke atas akan bertugas di kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Pada usia lima puluh tahun, mereka harus berhenti. ");
INSERT INTO ind_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mereka masih diperbolehkan membantu orang-orang Lewi lainnya yang bertugas, tetapi mereka sendiri tidak boleh melaksanakan tugas itu. Demikianlah pengaturan yang harus diterapkan untuk orang Lewi dan tugas-tugas mereka.” ");
INSERT INTO ind_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Pada bulan pertama di tahun kedua sejak orang Israel meninggalkan Mesir, berkatalah TUHAN kepada Musa di padang gurun Sinai, ");
INSERT INTO ind_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Sampaikanlah kepada umat Israel untuk merayakan Paskah pada waktu yang sudah ditentukan, ");
INSERT INTO ind_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","yaitu hari keempat belas bulan ini, pada saat matahari terbenam. Rayakanlah sesuai dengan semua ketentuan dan tata caranya.” ");
INSERT INTO ind_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Maka Musa memerintahkan demikian. ");
INSERT INTO ind_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Mereka pun merayakan Paskah di padang belantara Sinai pada hari keempat belas bulan pertama, saat matahari terbenam. Mereka melakukan semuanya sesuai dengan perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Waktu itu, ada beberapa orang yang sedang najis karena menyentuh mayat, sehingga mereka tidak bisa ikut merayakan Paskah hari itu. Mereka menghadap Musa dan Harun ");
INSERT INTO ind_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","dan bertanya, “Kami sedang najis karena sudah menyentuh mayat. Tetapi apakah gara-gara itu kami tidak boleh merayakan Paskah dan memberikan persembahan kepada TUHAN bersama saudara-saudara kami yang lain pada waktu yang ditentukan?” ");
INSERT INTO ind_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Jawab Musa, “Tunggu. Saya akan meminta petunjuk dari TUHAN tentang hal ini.” ");
INSERT INTO ind_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","11","“Sampaikanlah kepada umat Israel: Apabila ada di antara kalian atau keturunan kalian yang sedang najis karena menyentuh mayat, atau sedang dalam perjalanan jauh, mereka harus merayakan Paskah pada hari keempat belas di bulan kedua, saat matahari terbenam. Mereka harus makan daging kurban Paskah dengan roti yang tidak beragi dan sayur pahit. ");
INSERT INTO ind_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Mereka tidak boleh menyisakan daging itu sampai pagi, dan tidak boleh mematahkan satu pun tulang hewan kurban Paskah. Mereka harus mengikuti semua peraturan Paskah. ");
INSERT INTO ind_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Tetapi kalau orang yang tidak sedang najis dan tidak sedang dalam perjalanan jauh lalai merayakan Paskah, orang itu akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, karena dia tidak memberikan persembahan kepada TUHAN pada waktu yang ditentukan. Dia akan menanggung akibat dosanya. ");
INSERT INTO ind_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Apabila orang asing yang tinggal di antara kalian mau merayakan Paskah bagi TUHAN, mereka harus merayakannya sesuai dengan peraturan dan ketetapan Paskah. Satu peraturan yang sama berlaku baik untuk orang Israel maupun pendatang.” ");
INSERT INTO ind_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Kemah TUHAN adalah tempat disimpannya bukti perjanjian TUHAN. Setiap kali kemah TUHAN selesai didirikan, ada awan yang tampak di atasnya. Pada malam hingga pagi awan itu terlihat seperti api. Demikianlah selalu setiap harinya. ");
INSERT INTO ind_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ketika awan itu naik dari atas kemah dan bergerak, umat Israel pun membongkar perkemahan mereka lalu berangkat mengikutinya. Di mana pun awan itu berhenti, di situlah mereka berkemah lagi. ");
INSERT INTO ind_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Atas perintah TUHAN umat Israel berangkat, dan atas perintah TUHAN juga mereka berhenti dan berkemah. Selama awan itu masih diam di atas kemah-Nya, mereka tetap tinggal di tempat itu. ");
INSERT INTO ind_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ada kalanya awan itu lama berdiam di atas kemah TUHAN, dan selama itu pun umat Israel taat pada perintah TUHAN dan tidak berangkat. ");
INSERT INTO ind_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ada kalanya juga awan itu hanya tinggal beberapa hari di atas kemah-Nya dan segera berpindah lagi. Atas perintah TUHAN saja mereka berkemah dan berangkat. ");
INSERT INTO ind_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Bahkan, terkadang awan itu hanya diam dari malam sampai pagi. Pada waktu awan itu naik di pagi hari, umat Israel pun berangkat. Kapan saja awan itu naik, baik siang maupun malam, mereka berangkat. ");
INSERT INTO ind_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Tetapi selama awan itu berdiam di atas kemah TUHAN— entah dua hari, sebulan, atau lebih— selama itu juga mereka tetap berkemah di tempat itu. Ketika awan itu naik, barulah mereka pergi. ");
INSERT INTO ind_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Atas perintah TUHANlah umat Israel berkemah, dan atas perintah TUHAN juga mereka berangkat. Mereka menaati perintah TUHAN yang Dia sampaikan melalui Musa. ");
INSERT INTO ind_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Buatlah dua terompet dari perak tempaan. Gunakanlah terompet itu untuk memanggil umat Israel dan untuk memberi tahu jika sudah tiba waktunya perkemahan dipindahkan. ");
INSERT INTO ind_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kalau kedua terompet itu ditiup, seluruh umat Israel harus datang berkumpul kepadamu di depan pintu kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Tetapi kalau hanya satu terompet yang ditiup, hanya para pemimpin suku Israel yang harus datang berkumpul kepadamu. ");
INSERT INTO ind_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“Kalau terompet ditiup dengan suara melengking dan berulang-ulang, pasukan yang berkemah di sebelah timur kemah-Ku harus berangkat. ");
INSERT INTO ind_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kalau terompet ditiup untuk kedua kalinya dengan cara yang sama, pasukan di sebelah selatan harus berangkat. Jadi, bunyi terompet seperti itu adalah tanda bahwa umat harus berangkat. ");
INSERT INTO ind_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Namun, untuk memanggil seluruh umat Israel berkumpul, tiuplah terompet itu dengan nada yang berbeda. ");
INSERT INTO ind_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Terompet-terompet itu harus ditiup oleh para imam. Ketentuan ini wajib kalian taati turun-temurun untuk selamanya. ");
INSERT INTO ind_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Di negeri kalian nanti, saat musuh menyerang, tiuplah terompet itu dengan nada peringatan agar terdengar oleh seluruh bangsa Israel. Aku, TUHAN Allahmu, akan menyelamatkan kalian dari musuh. ");
INSERT INTO ind_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Pada waktu kalian bersukacita, misalnya pada hari-hari raya dan perayaan awal bulan, tiuplah terompet itu saat kalian mempersembahkan kurban yang dibakar habis dan kurban tanda damai, maka Aku, TUHAN Allahmu, akan berkenan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Pada hari kedua puluh, bulan kedua, di tahun kedua sejak Israel keluar dari Mesir, awan itu naik dari atas kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Maka umat Israel berangkat dari padang belantara Sinai dan berjalan terus sampai awan itu berhenti di padang belantara Paran. ");
INSERT INTO ind_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Itulah perjalanan mereka yang pertama atas perintah TUHAN melalui Musa. ");
INSERT INTO ind_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Barisan paling depan adalah kelompok pasukan Yehuda dengan benderanya, dipimpin oleh Nahason anak Aminadab. Mereka berjalan menurut regu masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Di belakang mereka adalah kelompok pasukan Isakar, dipimpin oleh Netaneel anak Zuar. ");
INSERT INTO ind_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Selanjutnya, kelompok pasukan Zebulon di bawah pimpinan Eliab anak Helon. ");
INSERT INTO ind_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Sesudah kemah TUHAN dibongkar, rombongan marga-marga Gerson dan Merari berangkat mengangkut kemah itu. ");
INSERT INTO ind_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Di belakang mereka, menyusul kelompok pasukan Ruben dengan benderanya, dipimpin oleh Elizur anak Syedeur. ");
INSERT INTO ind_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Berikutnya, kelompok pasukan Simeon di bawah pimpinan Selumiel anak Zurisyadai, ");
INSERT INTO ind_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","dan kelompok pasukan Gad di bawah pimpinan Eliasaf anak Rehuel. ");
INSERT INTO ind_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Sesudah itu, berangkatlah rombongan orang-orang Kehat mengangkut barang-barang kudus dari kemah TUHAN. Urutan pemindahan kemah TUHAN diatur supaya marga Gerson dan Merari sudah selesai mendirikan kembali kemah itu di tempat perhentian baru, sebelum marga Kehat yang membawa barang kudus itu tiba. ");
INSERT INTO ind_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Di belakang rombongan Kehat adalah kelompok pasukan Efraim dengan benderanya, dipimpin oleh Elisama anak Amihud. Mereka berjalan menurut regu masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Berikutnya adalah kelompok pasukan Manasye di bawah pimpinan Gamaliel anak Pedazur dan ");
INSERT INTO ind_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","kelompok pasukan Benyamin di bawah pimpinan Abidan anak Gideoni. ");
INSERT INTO ind_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Di barisan belakang adalah kelompok pasukan Dan dengan benderanya. Mereka berjalan menurut regu masing-masing, dipimpin oleh Ahiezer anak Amisyadai, ");
INSERT INTO ind_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","lalu kelompok pasukan Asyer di bawah pimpinan Pagiel anak Okran, ");
INSERT INTO ind_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","dan pasukan suku Naftali di bawah pimpinan Ahira anak Enan. ");
INSERT INTO ind_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Demikianlah urutan keberangkatan orang Israel berdasarkan kelompok-kelompok pasukan mereka setiap kali mereka berpindah tempat. ");
INSERT INTO ind_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa mengajak iparnya, Hobab anak Rehuel, orang Midian, “Kami hendak berangkat ke tempat yang TUHAN janjikan untuk diberikan kepada kami. Ikutlah bersama kami. TUHAN sudah menjanjikan yang baik bagi orang Israel, dan kami akan memperlakukanmu dengan baik juga.” ");
INSERT INTO ind_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Tetapi Hobab menjawab, “Tidak. Aku akan kembali ke negeriku sendiri, kepada sanak saudaraku.” ");
INSERT INTO ind_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa memohon, “Tolong jangan tinggalkan kami. Kamulah yang tahu tempat-tempat untuk berkemah di padang belantara dan bisa menjadi penunjuk jalan bagi kami. ");
INSERT INTO ind_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kalau kamu ikut bersama kami, segala hal baik yang TUHAN perbuat bagi kami akan kami lakukan juga kepadamu.” ");
INSERT INTO ind_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Lalu orang Israel berangkat dari Sinai, gunung kediaman TUHAN, dan melakukan perjalanan tiga hari lamanya. Selama tiga hari itu peti perjanjian TUHAN diangkut paling depan, untuk mengarahkan mereka pada tempat perhentian selanjutnya. ");
INSERT INTO ind_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Awan TUHAN selalu berada di atas mereka pada siang hari ketika mereka berangkat dari perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Setiap kali peti perjanjian mulai diangkut, Musa berkata, “Bangkitlah, TUHAN! Buatlah musuh-musuh-Mu tercerai-berai. Biarlah semua yang membenci-Mu lari berhamburan.” ");
INSERT INTO ind_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Dan setiap kali peti perjanjian itu berhenti di suatu tempat berkemah, Musa berkata, “Kembalilah, ya TUHAN, kepada beribu-ribu umat Israel ini.” ");
INSERT INTO ind_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Suatu kali, orang Israel mulai menggerutu tentang berbagai kesulitan hidup mereka. TUHAN mendengar mereka dan Dia pun murka, lalu mendatangkan api di perkemahan mereka sehingga beberapa orang di tepi perkemahan mati terbakar. ");
INSERT INTO ind_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Maka orang Israel berseru minta tolong kepada Musa. Lalu dia berdoa dan api itu padam. ");
INSERT INTO ind_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Itulah sebabnya tempat itu dinamai Tabera, yang berarti kobaran api, karena api TUHAN sudah berkobar di antara mereka. ");
INSERT INTO ind_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Dalam perjalanan rakyat Israel, ada orang-orang asing yang ikut bersama mereka dari Mesir. Orang asing itu merindukan makanan yang dulu mereka makan di Mesir, sehingga umat Israel pun kembali menggerutu, “Ah, kalau saja kita bisa makan daging! ");
INSERT INTO ind_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Kita masih ingat betapa nikmatnya ikan yang dulu kita makan dengan gratis di Mesir, juga mentimun, melon, bawang daun, bawang merah, dan bawang putih. ");
INSERT INTO ind_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Tetapi sekarang, yang kita punya hanya manna ini saja! Kita sudah muak memakannya!” ");
INSERT INTO ind_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna itu berbentuk seperti biji ketumbar dan warnanya putih kekuning-kuningan. ");
INSERT INTO ind_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Setiap pagi orang Israel berjalan di sekitar perkemahan untuk mengumpulkan manna. Kemudian mereka menggilingnya dengan batu gilingan atau menumbuknya dalam lesung, lalu merebusnya dalam panci atau mengolahnya menjadi roti bundar yang rasanya seperti roti yang dipanggang dengan minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Setiap malam, manna turun ke perkemahan bersama dengan embun. ");
INSERT INTO ind_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa mendengar setiap orang Israel bersungut-sungut di pintu kemah mereka masing-masing. TUHAN sangat marah, dan Musa sangat kesal. ");
INSERT INTO ind_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Lalu berkatalah Musa kepada TUHAN, “Mengapa Engkau menyiksa hamba-Mu ini, dengan menanggungkan beban seluruh bangsa kepadaku? Apakah Engkau tidak berkenan kepadaku? ");
INSERT INTO ind_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Memangnya aku ini ibu mereka? Memangnya aku yang melahirkan mereka?— sehingga Engkau menyuruh aku menggendong mereka seperti seorang ibu menggendong bayinya, sepanjang perjalanan ke tanah yang Engkau janjikan kepada nenek moyang mereka! ");
INSERT INTO ind_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Dari mana aku bisa mendapat daging untuk mereka semua? Mereka terus merengek minta daging. ");
INSERT INTO ind_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Aku tidak sanggup menanggung seluruh bangsa ini sendirian. Beban ini terlalu berat bagiku. ");
INSERT INTO ind_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kalau Engkau memperlakukan aku seperti ini, lebih baik cabut saja nyawaku sekarang. Kalau Engkau berkenan kepadaku, biarlah aku mati saja, daripada aku menanggung derita ini.” ");
INSERT INTO ind_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Lalu TUHAN berbicara kepada Musa, “Kumpulkanlah tujuh puluh tua-tua Israel yang kamu kenal sebagai pemimpin umat ini. Bawalah mereka ke kemah-Ku untuk menghadap Aku bersamamu. ");
INSERT INTO ind_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Aku akan turun untuk berbicara denganmu di tempat itu. Sebagian dari wibawa yang Aku berikan kepadamu akan Aku berikan kepada mereka, supaya mereka dapat membantumu memikul tanggung jawab atas bangsa ini. Dengan begitu, kamu tidak lagi menanggungnya sendirian. ");
INSERT INTO ind_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Katakanlah kepada seluruh orang Israel: Sucikanlah diri kalian untuk besok. Besok kalian akan makan daging. TUHAN sudah mendengar rengekan kalian, ‘Kami mau makan daging. Hidup kami di Mesir lebih baik!’ Karena itu, TUHAN akan memberi kalian daging, dan kalian harus memakannya. ");
INSERT INTO ind_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Kalian akan makan daging bukan hanya satu atau dua hari, bukan juga lima, sepuluh, atau dua puluh hari, ");
INSERT INTO ind_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","tetapi satu bulan penuh, sampai daging keluar dari hidung kalian dan sampai kalian mau muntah melihat daging! Karena kalian sudah berbalik melawan TUHAN yang ada bersama kalian dengan berkata, ‘Harusnya kita jangan keluar dari Mesir!’” ");
INSERT INTO ind_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Jawab Musa kepada TUHAN, “Pasukan kami saja ada 600.000 laki-laki, belum lagi perempuan dan anak-anak. Bagaimana Engkau menjanjikan daging untuk mereka setiap hari selama sebulan? ");
INSERT INTO ind_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Sekalipun kami menyembelih semua domba dan sapi kami, apakah itu cukup? Bahkan sekalipun kami menangkap semua ikan di laut, apakah itu cukup untuk mereka?” ");
INSERT INTO ind_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jawab TUHAN, “Kamu pikir kuasa-Ku tidak cukup untuk melakukan itu? Nanti kamu akan melihat, apakah perkataan-Ku terjadi atau tidak.” ");
INSERT INTO ind_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Lalu Musa keluar dan menyampaikan perkataan TUHAN kepada seluruh Israel. Dia juga memanggil tujuh puluh tua-tua Israel untuk berkumpul di sekeliling kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kemudian TUHAN turun dalam awan dan berbicara kepada Musa. TUHAN mengambil sebagian kuasa yang sudah Dia berikan kepada Musa dan memberikannya kepada tujuh puluh tua-tua Israel itu. Saat itu juga Roh Allah menguasai mereka, dan mereka pun berseru-seru mengatakan pesan dari Allah,, tetapi hanya sekali itu saja. ");
INSERT INTO ind_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Di antara tujuh puluh tua-tua Israel yang tercatat namanya, ada dua orang yang tetap tinggal di perkemahan dan tidak ikut berkumpul di kemah TUHAN, yaitu Eldad dan Medad. Lalu Roh Allah menguasai mereka sehingga mereka pun berseru-seru mengatakan pesan dari Allah di perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Seorang pemuda berlari memberitahu Musa, “Eldad dan Medad sedang berseru-seru mengatakan pesan dari Roh Allah di perkemahan!” ");
INSERT INTO ind_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Maka Yosua anak Nun, yang menjadi tangan kanan Musa sejak masa mudanya, berkata, “Tuanku Musa, suruhlah mereka berhenti!” ");
INSERT INTO ind_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Tetapi jawab Musa, “Apakah kamu kuatir mereka menyaingi aku? Aku malah berharap kuasa dari TUHAN diberikan kepada seluruh umat-Nya supaya mereka semua dimampukan untuk menyampaikan pesan dari-Nya.” ");
INSERT INTO ind_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Sesudah itu Musa dan para tua-tua itu kembali ke perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Lalu TUHAN mendatangkan angin dari laut yang menerbangkan banyak sekali burung puyuh. Burung-burung itu terdampar di perkemahan Israel dan sekitarnya, bertumpuk-tumpuk hingga kira-kira satu meter tingginya. Burung-burung itu menutupi tanah hingga sejauh beberapa kilometer di sekeliling perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Maka orang Israel keluar mengumpulkan burung puyuh itu sepanjang hari, sepanjang malam, dan sepanjang hari berikutnya. Setiap orang mendapatkan paling sedikit 60 keranjang besar penuh! Daging burung puyuh itu mereka hamparkan di sekeliling perkemahan untuk dijemur. ");
INSERT INTO ind_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Sementara mereka masih mengunyah daging-daging itu, berkobarlah murka TUHAN kepada orang Israel. Dia mendatangkan wabah penyakit di antara mereka sehingga banyak orang meninggal. ");
INSERT INTO ind_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Itu sebabnya, tempat itu dinamai Kibrot Hatawa, artinya kuburan nafsu, karena di sana dikuburkan orang-orang yang bernafsu makan daging. ");
INSERT INTO ind_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Dari Kibrot Hatawa, orang Israel melanjutkan perjalanan ke daerah Hazerot dan berkemah di situ. ");
INSERT INTO ind_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","3","Musa adalah orang yang sangat rendah hati, bahkan paling rendah hati di antara semua orang di dunia. Suatu kali, Miryam dan Harun mencela Musa karena dia menikahi perempuan dari Etiopia. Mereka juga berkata, “TUHAN tidak hanya bicara melalui Musa! TUHAN juga berbicara melalui kami berdua.” TUHAN mendengar ucapan mereka itu. ");
INSERT INTO ind_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Tiba-tiba TUHAN berbicara kepada Musa, Harun, dan Miryam, “Kalian bertiga, datanglah ke kemah-Ku.” Maka mereka datang ke depan pintu kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kemudian TUHAN turun ke pintu kemah-Nya dalam tiang awan lalu memanggil Harun dan Miryam. Mereka berdua pun melangkah ke depan. ");
INSERT INTO ind_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Lalu TUHAN berkata, “Dengarkanlah perkataan-Ku ini! Bila ada nabi-nabi lain di antara kalian, Aku akan menyatakan diri-Ku atau berbicara dengan mereka lewat penglihatan dan mimpi. ");
INSERT INTO ind_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Namun, tidak demikian dengan hamba-Ku Musa. Di antara seluruh umat-Ku, dialah yang paling setia kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Dengan dia Aku berbicara berhadapan muka, secara jelas dan terus terang tanpa menggunakan kiasan. Dia sudah melihat wujud-Ku. Seharusnya kalian takut mencela hamba-Ku Musa!” ");
INSERT INTO ind_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Murka TUHAN berkobar atas Miryam dan Harun. Saat TUHAN pergi ");
INSERT INTO ind_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","dan tiang awan lenyap dari kemah TUHAN, tampaklah kulit Miryam menjadi putih seperti kapas. Dia terkena penyakit kulit menular! Ketika Harun melihat keadaan Miryam, ");
INSERT INTO ind_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","dia memohon kepada Musa, “Tuanku, tolong jangan hukum kami! Kami sudah bertindak bodoh dan berbuat dosa. ");
INSERT INTO ind_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Jangan biarkan penyakit ini menggerogoti Miryam. Dia tampak seperti bayi yang sudah mati waktu lahir dan dagingnya setengah busuk.” ");
INSERT INTO ind_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Maka Musa berseru kepada TUHAN, “Ya Allah, aku mohon, tolong sembuhkanlah dia!” ");
INSERT INTO ind_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Jawab TUHAN kepada Musa, “Andaikan ayahnya meludahi mukanya sebagai teguran keras, tentu dia merasa dipermalukan selama tujuh hari. Miryam harus menanggung aib atas perbuatannya. Kucilkanlah dia di luar perkemahan tujuh hari lamanya. Sesudah itu, dia boleh kembali.” ");
INSERT INTO ind_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Lalu Miryam dikucilkan di luar perkemahan selama tujuh hari. Orang Israel tidak melanjutkan perjalanan sampai Miryam kembali ke perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Sesudah itu, umat Israel meninggalkan Hazerot dan berkemah di padang belantara Paran. ");
INSERT INTO ind_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Utuslah satu orang pemimpin dari tiap suku untuk mengintai negeri Kanaan yang Aku berikan kepada bangsa Israel.” ");
INSERT INTO ind_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Maka sesuai perintah TUHAN itu, Musa mengutus dua belas pemimpin terpilih dari padang belantara Paran. ");
INSERT INTO ind_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Berikut ini nama-nama pemimpin dari tiap suku: Suku Pemimpin Ruben Syamua anak Zakur Simeon Safat anak Hori Yehuda Kaleb anak Yefune Isakar Igal anak Yusuf Efraim Hosea anak Nun Benyamin Palti anak Rafu Zebulon Gadiel anak Sodi Manasye Gadi anak Susi Dan Amiel anak Gemali Asyer Setur anak Mikael Naftali Nahbi anak Wofsi Gad Guel anak Maki ");
INSERT INTO ind_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Itulah nama-nama orang yang diutus Musa untuk mengintai negeri Kanaan. Musa memberikan nama baru kepada Hosea anak Nun, yaitu Yosua. ");
INSERT INTO ind_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Saat mengutus mereka, Musa berpesan, “Mulailah dari padang belantara Negeb di bagian selatan Kanaan, dan berjalanlah terus ke utara sampai daerah perbukitan. ");
INSERT INTO ind_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Lihatlah keadaan negeri itu. Perhatikan apakah penduduknya kuat atau lemah, sedikit atau banyak. ");
INSERT INTO ind_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Amati juga apakah negeri itu baik atau buruk, dan seperti apa tempat tinggal mereka— apakah berupa kota-kota berbenteng atau terbuka tanpa benteng. ");
INSERT INTO ind_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Selidiki apakah tanahnya subur atau tandus, dan apakah di sana ada pohon-pohonan atau tidak. Usahakan untuk membawa beberapa buah-buahan.” Kebetulan waktu itu adalah awal musim panen anggur. ");
INSERT INTO ind_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Maka mereka pergi dan menyelidiki negeri Kanaan mulai dari padang belantara Zin sampai ke kota Rehob, dekat jalan masuk Hamat. ");
INSERT INTO ind_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Sesudah memulai dari Negeb, mereka tiba di kota Hebron, tempat tinggal suku-suku Ahiman, Sesai, dan Talmai, yang adalah keturunan raksasa yang disebut Anakim. (Kota Hebron didirikan tujuh tahun sebelum kota Zoan di Mesir.) ");
INSERT INTO ind_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","24","Dalam perjalanan kembali, mereka sampai di lembah yang sekarang disebut Eskol. Di situ mereka memotong satu tandan buah anggur yang begitu berat sehingga harus dipikul dengan sebatang kayu oleh dua orang. Itulah sebabnya lembah itu dinamai Eskol (yang artinya Lembah Tandan Anggur). Mereka juga membawa beberapa buah delima dan buah ara dari sana. ");
INSERT INTO ind_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sesudah mengintai negeri itu selama empat puluh hari, mereka pun kembali lalu ");
INSERT INTO ind_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","menghadap Musa, Harun, dan seluruh umat Israel di Kades, di padang belantara Paran, untuk menceritakan apa yang sudah mereka lihat. Mereka menunjukkan buah-buahan dari negeri itu. ");
INSERT INTO ind_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kata mereka kepada Musa, “Kami sudah pergi ke negeri yang Tuan perintahkan. Benar, negeri itu berlimpah dengan hasil alam. Lihat, ini buah-buahan dari sana. ");
INSERT INTO ind_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Tetapi penduduk negeri itu sangat kuat. Kota-kota mereka besar dan berbenteng. Kami juga melihat keturunan raksasa Anakim di sana. ");
INSERT INTO ind_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Orang Amalek tinggal di bagian selatan negeri itu. Orang Het, Yebus, dan Amori tinggal di perbukitan. Sedangkan orang Kanaan tinggal di sepanjang tepi laut dan di sepanjang tepi sungai Yordan.” ");
INSERT INTO ind_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaleb berusaha menenangkan semua orang yang hadir di hadapan Musa. Dia berkata, “Ayo! Mari kita maju menduduki negeri itu. Kita pasti bisa menang!” ");
INSERT INTO ind_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Tetapi kebanyakan pengintai yang lain menentang Kaleb dengan berkata, “Kita tidak bisa menyerang bangsa-bangsa itu! Mereka lebih kuat daripada kita!” ");
INSERT INTO ind_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Bahkan untuk menguatkan pendapat mereka, ada yang berbohong dengan berkata, “Negeri itu penuh dengan bahaya mematikan! Banyak sekali korban dari penyakit dan peperangan.” Ada juga yang menambahkan, “Orang-orang yang kami lihat di sana semuanya tinggi besar. ");
INSERT INTO ind_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Bahkan ada juga raksasa keturunan Anakim! Kami merasa seperti belalang dibandingkan dengan mereka. Dan mereka juga melihat kami begitu kecil seperti belalang.” ");
INSERT INTO ind_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Sepanjang malam itu, seluruh umat Israel menangis keras-keras. ");
INSERT INTO ind_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Mereka semua menggerutu kepada Musa dan Harun. Kata mereka, “Lebih baik kami mati di Mesir, atau bahkan di padang belantara ini! ");
INSERT INTO ind_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","TUHAN membawa kita ke negeri itu agar kita dibunuh! Istri dan anak-anak kita akan menjadi tawanan! Lebih baik kita kembali ke Mesir!” ");
INSERT INTO ind_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Lalu mereka berkata satu sama lain, “Mari kita angkat seorang pemimpin dan kembali ke Mesir.” ");
INSERT INTO ind_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mendengar itu, Musa dan Harun tersungkur di hadapan seluruh umat Israel yang sedang berkumpul. ");
INSERT INTO ind_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yosua anak Nun dan Kaleb anak Yefune, dua di antara para pengintai negeri Kanaan, merobek pakaian mereka karena sangat gusar terhadap umat itu. ");
INSERT INTO ind_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Yosua dan Kaleb berkata, “Negeri yang kami selidiki itu sangat baik. ");
INSERT INTO ind_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kalau TUHAN berkenan kepada kita, Dia pasti membawa kita masuk dan memberikan kepada kita negeri yang berlimpah dengan hasil alam itu. ");
INSERT INTO ind_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hanya janganlah memberontak kepada TUHAN. Jangan takut kepada penduduk negeri itu. Mereka akan kita lalap habis. Tidak ada yang melindungi mereka, sedangkan kita disertai TUHAN. Jangan takut kepada mereka.” ");
INSERT INTO ind_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mendengar itu, seluruh umat Israel mengancam untuk melempari Yosua dan Kaleb dengan batu. Tetapi tiba-tiba mereka semua melihat kemuliaan TUHAN muncul di kemah-Nya. ");
INSERT INTO ind_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kata TUHAN kepada Musa, “Sampai kapan bangsa ini terus menolak Aku? Sampai kapan mereka tidak mau percaya kepada-Ku walaupun sudah banyak tanda ajaib yang Aku lakukan di tengah-tengah mereka? ");
INSERT INTO ind_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Aku akan mendatangkan wabah untuk membinasakan mereka. Lalu dari keturunanmu, Aku akan menjadikan bangsa yang lebih besar dan lebih kuat daripada mereka.” ");
INSERT INTO ind_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Jawab Musa, “Jangan, ya TUHAN. Kalau Engkau membinasakan mereka, orang Mesir akan mendengar beritanya, padahal mereka sudah menyaksikan bagaimana dengan kuasa-Mu yang besar Engkau membawa umat-Mu ini pergi dari tengah-tengah mereka. ");
INSERT INTO ind_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Nanti orang Mesir akan menceritakannya kepada bangsa-bangsa penduduk negeri ini. Ya TUHAN, orang-orang di negeri ini sudah mendengar bahwa Engkau hadir di tengah-tengah Israel, dan bahwa Engkau menunjukkan diri secara langsung kepada kami. Mereka tahu bahwa awan-Mu menaungi kami, dan bahwa Engkau berjalan di depan kami dalam tiang awan di siang hari dan tiang api di malam hari. ");
INSERT INTO ind_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kalau sekarang Engkau membinasakan umat-Mu sekaligus, nanti bangsa-bangsa yang pernah mendengar tentang kemasyhuran-Mu itu akan berkata, ");
INSERT INTO ind_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Ternyata TUHAN tidak mampu membawa bangsa Israel ke negeri yang Dia janjikan bagi mereka. Karena itulah Dia membunuh mereka di padang belantara.’ ");
INSERT INTO ind_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Jadi, ya Penguasaku, tunjukkanlah kuasa-Mu yang besar itu, sebagaimana Engkau sudah berkata, ");
INSERT INTO ind_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Akulah TUHAN. Aku panjang sabar, berlimpah kasih sayang, dan setia. Aku mengampuni orang yang berdosa dan yang melawan Aku, tetapi Aku tidak membiarkan dosa tanpa hukuman. Dosa orang tua akan Aku perhitungkan kepada anak cucu mereka, sampai generasi yang ketiga dan keempat.’ ");
INSERT INTO ind_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kasih sayang-Mu begitu besar dan tidak berubah. Karena itu, tolong ampuni dosa umat-Mu ini, sebagaimana Engkau terus mengampuni mereka sejak dari Mesir sampai sekarang.” ");
INSERT INTO ind_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jawab TUHAN, “Aku sudah mengampuni mereka seperti permintaanmu. ");
INSERT INTO ind_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Akan tetapi, demi diri-Ku yang hidup dan demi kemuliaan-Ku yang nyata di seluruh bumi ini, Aku bersumpah: ");
INSERT INTO ind_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Semua orang yang meskipun sudah melihat kemuliaan-Ku dan perbuatan-perbuatan ajaib-Ku di Mesir dan di padang belantara, tetap tidak mau menaati-Ku dan terus mencobai Aku sampai sepuluh kali ini, ");
INSERT INTO ind_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","mereka tidak akan masuk ke negeri yang Aku janjikan kepada nenek moyang mereka. Semua orang yang menolak Aku tidak akan melihat negeri itu. ");
INSERT INTO ind_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Tetapi hamba-Ku Kaleb berbeda dari mereka. Dia taat kepada-Ku sepenuhnya. Karena itu Aku akan membawa dia masuk ke negeri yang dijelajahinya itu, dan daerah itu akan menjadi warisan milik keturunannya ");
INSERT INTO ind_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","walaupun sekarang daerah lembah itu ditinggali oleh Amalek dan orang Kanaan. Besok kalian harus balik ke padang belantara melalui jalan menuju ke Laut Merah.” ");
INSERT INTO ind_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Sampai kapan umat yang jahat ini terus bersungut-sungut kepada-Ku? Semua gerutu bangsa Israel terhadap-Ku sudah Aku dengar. ");
INSERT INTO ind_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Sampaikanlah kepada mereka: Beginilah kata TUHAN, ‘Aku bersumpah, demi diri-Ku yang hidup, Aku akan membuat kalian mengalami apa yang Aku dengar kalian ucapkan. ");
INSERT INTO ind_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mayat-mayat kalian akan bergelimpangan di padang belantara ini! Semua yang namanya dicatat dalam pendataan umat Israel dari umur 20 tahun ke atas akan mati di sini karena kalian semua sudah bersungut-sungut terhadap Aku. ");
INSERT INTO ind_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Tidak akan ada yang masuk ke negeri yang Aku janjikan untuk menjadi tempat tinggal kalian kecuali Kaleb anak Yefune dan Yosua anak Nun. ");
INSERT INTO ind_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Tetapi anak-anak kalian, yang kalian katakan akan menjadi tawanan, merekalah yang akan Aku bawa masuk. Dan mereka akan menikmati negeri yang kalian tolak itu. ");
INSERT INTO ind_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Namun, generasi kalian akan mati di padang belantara ini. ");
INSERT INTO ind_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Karena kalian tidak setia kepada-Ku, anak-anak kalian harus mengembara di padang belantara selama empat puluh tahun, sampai seluruh generasi kalian habis di padang belantara. ");
INSERT INTO ind_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Karena kalian mengintai negeri itu selama empat puluh hari, kalian harus mengembara di padang belantara selama empat puluh tahun untuk menanggung akibat dosa-dosa kalian. Satu tahun untuk setiap hari. Dengan begitu, kalian akan tahu bagaimana rasanya bila Aku menentang kalian.’ ");
INSERT INTO ind_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Aku, TUHAN, sudah berjanji. Aku pasti akan melakukan itu kepada seluruh umat yang jahat ini, yang sudah bersekongkol melawan Aku. Di padang belantara ini, mereka semua akan habis binasa.” ");
INSERT INTO ind_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","38","Dari dua belas orang yang Musa utus untuk mengintai negeri itu, kesepuluh orang yang membawa berita buruk sehingga seluruh umat menggerutu terhadap TUHAN, dibinasakan oleh TUHAN dengan wabah penyakit. Hanya Yosua dan Kaleb yang tetap hidup. ");
INSERT INTO ind_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ketika Musa menyampaikan perkataan TUHAN kepada umat Israel, bangsa itu meratap dengan penuh duka. ");
INSERT INTO ind_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Besoknya, pagi-pagi sekali mereka hendak naik ke daerah bukit. Kata mereka, “Memang kami sudah berdosa, tetapi sekarang kami siap maju. Kami mau pergi ke tempat yang TUHAN janjikan.” ");
INSERT INTO ind_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Jawab Musa, “Kalian tidak akan berhasil. Buat apa kalian menentang perintah TUHAN lagi? ");
INSERT INTO ind_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Jangan ke sana. Kalian pasti akan dikalahkan musuh karena TUHAN tidak bersama dengan kalian. ");
INSERT INTO ind_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kalian akan berhadapan dengan orang Amalek dan orang Kanaan, dan mereka akan membunuh kalian. TUHAN tidak menyertai kalian karena kalian sudah meninggalkan-Nya.” ");
INSERT INTO ind_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Tetapi mereka bersikeras pergi ke perbukitan, walaupun Musa dan peti perjanjian TUHAN tetap di perkemahan. ");
INSERT INTO ind_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Kemudian orang-orang Amalek dan Kanaan yang tinggal di perbukitan itu turun menyerang orang Israel dan mengalahkan mereka, bahkan mengejar mereka sampai ke Horma. ");
INSERT INTO ind_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Sampaikanlah kepada umat Israel: Ketika kalian mendiami negeri yang Aku berikan itu, ");
INSERT INTO ind_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kalian akan mempersembahkan berbagai macam kurban hewan di mezbah-Ku untuk membuat bau harum yang menyenangkan Aku, termasuk yang dibakar habis, dan kurban sembelihan yang lainnya. Ada juga kurban untuk memenuhi sumpah, kurban sukarela, dan kurban tertentu untuk setiap perayaan. ");
INSERT INTO ind_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Setiap kurban harus disertai dengan persembahan gandum-ganduman berupa tiga liter tepung terbaik dicampur dengan satu liter minyak zaitun. ");
INSERT INTO ind_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Dan setiap ekor anak domba jantan yang dipersembahkan, baik sebagai kurban yang dibakar habis maupun kurban sembelihan lainnya, harus disertai dengan persembahan curahan satu liter air anggur. ");
INSERT INTO ind_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Setiap ekor domba jantan yang dipersembahkan harus disertai dengan persembahan gandum-ganduman enam liter tepung terbaik dicampur dengan 1,3 liter minyak zaitun ");
INSERT INTO ind_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","dan persembahan curahan 1,3 liter anggur. Semua itu akan menjadi bau harum yang menyenangkan TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Setiap ekor sapi jantan yang dipersembahkan, baik sebagai kurban yang dibakar habis maupun kurban sembelihan lainnya, baik untuk memenuhi sumpah maupun sebagai kurban tanda damai bagi TUHAN, ");
INSERT INTO ind_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","akan disertai dengan persembahan gandum-ganduman sembilan liter tepung yang terbaik dicampur dengan dua liter minyak zaitun, ");
INSERT INTO ind_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","dan persembahan curahan berupa dua liter anggur. Ketika kurban sapi jantan dilengkapi dengan ketiga persembahan tersebut di mezbah-Ku asapnya akan berbau harum dan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Demikianlah aturan persembahan untuk setiap sapi jantan, domba jantan, dan anak domba jantan atau anak kambing. ");
INSERT INTO ind_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Berapa pun jumlah hewan yang kalian kurbankan, kalian harus menyertakan persembahan curahan dan gandum-ganduman sesuai aturan ini untuk setiap ekor kurban. ");
INSERT INTO ind_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","14","Setiap orang Israel yang mempersembahkan kurban di mezbah-Ku akan mengikuti aturan-aturan ini supaya bau harumnya menyenangkan Aku. Ketika seorang pendatang, baik yang tinggal sementara maupun yang menetap dengan kalian, hendak mempersembahkan kurban, dia akan mengikuti aturan yang sama. ");
INSERT INTO ind_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ketetapan ini berlaku turun-temurun untuk selamanya bagi seluruh umat, baik kalian maupun pendatang yang tinggal di antara kalian. Di hadapan TUHAN, pendatang sama saja dengan kalian. ");
INSERT INTO ind_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ketetapan dan hukum yang sama berlaku bagi kalian dan bagi pendatang yang tinggal di antara kalian.” ");
INSERT INTO ind_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Lagi kata TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Sampaikanlah kepada umat Israel: Sesudah Aku membawa kalian masuk ke negeri ini ");
INSERT INTO ind_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","dan kalian menikmati hasil panen pertama di sana, persembahkanlah sebagian kepada-Ku. ");
INSERT INTO ind_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pada setiap awal musim panen jelai, buatlah roti tebal dari hasil pengirikan pertama dan bawalah ke kemah-Ku. Imam yang bertugas akan mengangkatnya tinggi sebagai persembahan khusus bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Demikianlah turun-temurun kalian harus mempersembahkan roti yang pertama sebagai persembahan khusus kepada TUHAN.” ");
INSERT INTO ind_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“Mungkin seluruh umat Israel, baik kalian sekarang atau di masa yang akan datang, tanpa sengaja lalai melakukan salah satu dari perintah yang disampaikan oleh Musa. ");
INSERT INTO ind_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Apabila kelalaian itu terjadi, maka seluruh umat Israel harus mempersembahkan seekor sapi jantan muda sebagai kurban yang dibakar habis beserta persembahan curahan dan gandum-gandumannya yang ditentukan. Asap dari kurban itu akan menghasilkan bau harum yang menyenangkan TUHAN. Persembahkanlah juga seekor kambing jantan sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","26","Imam yang mempersembahkannya di mezbah akan memulihkan hubungan seluruh umat Israel dengan-Ku. Dengan demikian pelanggaran yang tidak sengaja itu akan Aku ampuni. Yang diampuni termasuk juga para pendatang yang tinggal di antara kalian. ");
INSERT INTO ind_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Siapa pun umat Israel yang berbuat dosa tanpa sengaja, harus mempersembahkan kambing betina berumur setahun sebagai kurban penghapus dosa. ");
INSERT INTO ind_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Imam yang mempersembahkannya di mezbah akan memulihkan hubunganmu dengan Aku dan Aku akan mengampunimu. ");
INSERT INTO ind_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Hukum tentang dosa yang tidak disengaja berlaku baik bagi orang Israel maupun pendatang. ");
INSERT INTO ind_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Akan tetapi, siapa pun yang berbuat dosa dengan sengaja berarti menghina Aku. Dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, baik itu orang Israel maupun pendatang. ");
INSERT INTO ind_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Dia harus benar-benar disingkirkan karena dia sudah meremehkan dan dengan sengaja melanggar perintah-Ku. Orang itu akan menanggung akibatnya sendiri.” ");
INSERT INTO ind_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Suatu hari, ketika bangsa Israel berada di padang belantara, salah seorang di antara mereka tertangkap basah sedang mengumpulkan kayu bakar pada hari Sabat. ");
INSERT INTO ind_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Orang-orang yang mendapati dia sedang melakukan itu membawanya ke hadapan Musa, Harun, dan seluruh umat Israel. ");
INSERT INTO ind_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Dia ditahan untuk sementara karena mereka belum tahu apa yang harus dilakukan kepadanya. ");
INSERT INTO ind_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Kemudian TUHAN berkata kepada Musa, “Orang itu harus dihukum mati. Seluruh umat harus melempari dia dengan batu di luar perkemahan.” ");
INSERT INTO ind_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Maka seluruh umat itu membawanya ke luar perkemahan, dan orang itu dilempari batu sampai mati, sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Sampaikanlah kepada umat Israel: Buatlah rumbai-rumbai dan gantungkanlah pada keempat ujung bawah pakaian kalian. Setiap rumbai harus memiliki paling sedikit satu tali berwarna ungu. Hal ini harus kalian lakukan turun-temurun. ");
INSERT INTO ind_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Setiap kali kamu melihat rumbai-rumbai itu, hendaklah kamu teringat tentang segala perintah TUHAN, supaya kamu melakukannya dan tidak mengkhianati Aku dengan menuruti kehendak dan keinginan hawa nafsumu sendiri. ");
INSERT INTO ind_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Dengan demikian, kalian akan selalu ingat untuk melakukan seluruh perintah-Ku dan hidup suci bagi-Ku. ");
INSERT INTO ind_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Akulah TUHAN Allah kalian, yang membawa kalian keluar dari Mesir supaya menjadi Allah kalian. Aku TUHAN, menegaskan hal ini.” ");
INSERT INTO ind_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Suatu hari, Korah anak Izar, dari marga Kehat suku Lewi, bersekongkol dengan tiga orang dari suku Ruben, yaitu Datan dan Abiram, keduanya anak Eliab, serta On anak Pelet. ");
INSERT INTO ind_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Mereka mengumpulkan sejumlah pendukung dari antara bangsa Israel termasuk 250 orang pemimpin, orang-orang terkemuka dari sukunya, untuk memberontak terhadap Musa. ");
INSERT INTO ind_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Kemudian mereka beramai-ramai mendatangi Musa dan Harun dan berkata, “Kalian sudah keterlaluan! Seluruh umat Israel itu dikhususkan bagi TUHAN dan TUHAN ada di tengah-tengah kita! Kenapa kalian menganggap diri kalian lebih tinggi dari umat TUHAN lainnya?” ");
INSERT INTO ind_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mendengar perkataan itu, Musa bersujud dan berdoa kepada TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Lalu Musa menjawab Korah dan gerombolannya itu, “Besok pagi TUHAN akan menunjukkan kepada kita siapa milik-Nya dan yang dikhususkan bagi-Nya. Hanya orang yang dipilih-Nya itu yang diizinkan TUHAN untuk mendekat ke hadapan-Nya. ");
INSERT INTO ind_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hai Korah dan semua pengikutmu, siapkanlah wadah pembakaran dupamu masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Besok, taruhlah bara api dan dupa ke dalamnya, dan bawalah itu ke hadapan TUHAN. Nanti Dia akan menunjukkan siapa yang dipilih-Nya. Kalian orang Lewi, benar-benar keterlaluan!” ");
INSERT INTO ind_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Lanjut Musa kepada Korah dan sekutunya, “Dengarkanlah, keturunan Lewi! ");
INSERT INTO ind_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Allah Israel sudah mengkhususkan kalian dari antara umat Israel. Kalian diizinkan mendekat kepada-Nya, untuk melayani Dia di kemah-Nya dan menjadi perantara bagi umat-Nya. Apakah menurutmu itu hal sepele? ");
INSERT INTO ind_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Korah, TUHAN sudah membawamu dan seluruh suku Lewi mendekat kepada-Nya. Apa sekarang kalian menuntut ingin menjadi imam juga? ");
INSERT INTO ind_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Waktu kamu dan gerombolanmu bersungut-sungut terhadap Harun, sebenarnya kalian sedang memberontak terhadap TUHAN.” ");
INSERT INTO ind_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Lalu Musa mengundang Datan dan Abiram, tetapi mereka menjawab, “Kami tidak mau datang! ");
INSERT INTO ind_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kamu membawa kami keluar dari negeri Mesir yang berlimpah dengan hasil alam untuk membunuh kami di padang belantara. Apakah menurutmu itu hal sepele? Dan sekarang kamu mau menjadi penguasa atas kami. ");
INSERT INTO ind_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Bahkan, kamu tidak membawa kami ke negeri yang berlimpah dengan hasil alam, di mana ladang dan kebun anggur akan menjadi warisan kami. Kamu sudah menganggap kami seperti kerbau yang dicocok hidungnya! Kami tidak mau datang!” ");
INSERT INTO ind_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Maka Musa menjadi sangat marah, lalu berkata kepada TUHAN, “Janganlah terima persembahan mereka. Aku tidak pernah menyakiti seorangpun dari mereka. Bahkan seekor keledai pun tidak pernah aku ambil dari mereka.” ");
INSERT INTO ind_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Berkatalah Musa kepada Korah, “Besok pagi kamu dan semua pengikutmu harus datang menghadap TUHAN di kemah-Nya. Harun juga akan datang. ");
INSERT INTO ind_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kamu dan 250 pengikutmu harus datang semua dengan membawa wadah pembakaran dupa dan menaruh dupa di dalamnya sebagai persembahan kepada TUHAN. Harun juga akan membawa wadah pembakaran dupanya.” ");
INSERT INTO ind_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Maka keesokan harinya, Korah dan para pengikutnya mengambil wadah pembakaran dupa mereka masing-masing dan menaruh bara api serta dupa ke dalamnya. Lalu mereka berdiri di depan kemah TUHAN bersama dengan Musa dan Harun. ");
INSERT INTO ind_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah juga menghasut seluruh umat Israel untuk berkumpul di depan kemah TUHAN. Tetapi saat itu juga tampaklah kemuliaan TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Lalu TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Menjauhlah dari orang-orang ini, karena Aku mau menghabisi mereka semua sekaligus!” ");
INSERT INTO ind_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Tetapi Musa dan Harun bersujud serta berkata, “Ya Allah, Engkau Allah atas segala makhluk hidup. Apakah Engkau murka kepada seluruh umat hanya karena satu orang berbuat dosa?” ");
INSERT INTO ind_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Maka jawab TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Suruhlah seluruh umat untuk menjauh dari kemah-kemah Korah, Datan, dan Abiram.” ");
INSERT INTO ind_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Maka Musa berdiri lalu pergi ke kemah-kemah Datan dan Abiram, diikuti oleh para pemimpin Israel. ");
INSERT INTO ind_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kata Musa kepada umat Israel, “Menjauhlah dari kemah-kemah orang-orang jahat ini dan jangan sentuh apa pun milik mereka, supaya kalian tidak ikut binasa karena dosa mereka!” ");
INSERT INTO ind_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Maka umat Israel menjauh dari kemah-kemah Korah, Datan dan Abiram. Datan dan Abiram keluar dari kemah-kemah mereka dan berdiri di depan kemah mereka bersama dengan istri dan anak-anak mereka. ");
INSERT INTO ind_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa berkata kepada mereka, “Dengan cara ini kalian akan tahu bahwa saya mengerjakan hal-hal ini karena TUHANlah yang mengutus saya, bukan atas kemauan saya sendiri. ");
INSERT INTO ind_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Jika orang-orang ini meninggal dengan cara yang wajar, maka jelaslah bahwa TUHAN tidak memilih saya. ");
INSERT INTO ind_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Tetapi jika TUHAN melakukan sesuatu yang belum pernah terjadi sebelumnya, jika tanah seolah-olah membuka mulutnya dan menelan mereka beserta segala milik mereka, dan mereka hidup-hidup turun ke Syeol, maka kalian akan tahu bahwa mereka sudah melawan TUHAN.” ");
INSERT INTO ind_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Begitu Musa selesai mengatakan itu, terbelahlah tanah di tempat Datan dan Abiram berdiri. ");
INSERT INTO ind_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Bumi membuka mulutnya dan menelan mereka dan keluarga mereka, serta semua pengikut Korah dan segala milik mereka. ");
INSERT INTO ind_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mereka pun terperosok ke Syeol dalam keadaan hidup, lalu tanah itu kembali merapat. Demikianlah mereka lenyap dari antara umat Israel. ");
INSERT INTO ind_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mendengar jeritan mereka, semua orang Israel di sana lari ketakutan. “Jangan sampai kita juga ditelan bumi!” seru mereka. ");
INSERT INTO ind_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Sementara itu, api datang dari TUHAN dan membakar habis 250 orang yang mempersembahkan dupa itu. ");
INSERT INTO ind_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Berkatalah TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“Orang-orang itu sudah mati terbakar habis karena dosa mereka. Tetapi wadah pembakaran dupa mereka menjadi kudus sesudah digunakan untuk mempersembahkan dupa kepada-Ku. Karena itu, suruhlah Eleazar anak Harun untuk mengambil wadah itu dari tempat kebakaran dan menebarkan bara apinya jauh-jauh. Semua wadah itu harus ditempa menjadi lempengan tipis untuk lapisan luar mezbah kurban, sebagai peringatan bagi orang Israel.” ");
INSERT INTO ind_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Maka imam Eleazar mengambil wadah yang digunakan oleh mereka yang mati terbakar itu, dan semuanya ditempa menjadi lempengan tipis untuk lapisan luar mezbah, ");
INSERT INTO ind_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","sesuai dengan perintah TUHAN kepadanya melalui Musa. Lempengan itu menjadi peringatan kepada orang Israel bahwa hanya keturunan Harun yang boleh mempersembahkan dupa kepada TUHAN. Jika orang lain berbuat demikian, nasibnya akan sama dengan Korah dan para pengikutnya. ");
INSERT INTO ind_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Tetapi besoknya, seluruh umat Israel bersungut-sungut kepada Harun dan Musa. Kata mereka, “Kalian sudah membunuh umat TUHAN!” ");
INSERT INTO ind_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Sesudah umat berkumpul untuk melawan Musa dan Harun, mereka menengok ke kemah TUHAN dan melihat kemah itu tertutup awan dan cahaya kehadiran TUHAN terlihat di sana. ");
INSERT INTO ind_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Lalu Musa dan Harun datang ke depan kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Di sana TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Menjauhlah dari orang-orang ini, karena Aku mau menghabisi mereka semua sekaligus.” Maka bersujudlah Musa dan Harun untuk berdoa. ");
INSERT INTO ind_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kata Musa kepada Harun, “Cepat, ambil wadah pembakaran dupa, masukkan bara api dari mezbah ke dalamnya dan taruh dupa di atasnya. Bawa wadah pembakaran dupa itu ke tengah-tengah umat Israel untuk mendamaikan mereka dengan TUHAN. TUHAN sangat murka dan wabah sudah mulai.” ");
INSERT INTO ind_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Maka Harun membawa wadah pembakaran dupa seperti yang diperintahkan Musa dan lari ke tengah-tengah umat yang sudah mulai terserang wabah itu. Di sana Harun membakar dupa supaya mereka didamaikan dengan TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Harun berdiri di antara orang-orang yang sudah meninggal dan orang-orang yang masih hidup, dan wabah itu pun berhenti. ");
INSERT INTO ind_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Sebanyak 14.700 orang meninggal karena wabah itu, tidak termasuk mereka yang mati karena perkara Korah. ");
INSERT INTO ind_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Sesudah wabah itu berhenti, Harun kembali kepada Musa di depan Kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Suruhlah umat Israel membawa dua belas tongkat— satu tongkat dari setiap kepala suku. Tuliskanlah nama setiap kepala suku itu pada tongkatnya masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Juga tuliskanlah nama Harun pada tongkat suku Lewi, karena setiap kepala suku harus diwakili oleh satu tongkat. ");
INSERT INTO ind_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Letakkan ketiga belas tongkat itu di dalam kemah-Ku, di depan peti perjanjian di tempat dimana Aku bertemu dengan kalian. ");
INSERT INTO ind_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Aku akan membuat tongkat orang yang Aku pilih menjadi berbunga. Dengan demikian umat Israel akan berhenti bersungut-sungut terhadap kalian.” ");
INSERT INTO ind_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Lalu Musa menyampaikan hal ini kepada seluruh bangsa Israel. Maka keduabelas kepala suku Israel dan Harun sendiri menyerahkan tongkat mereka masing-masing kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa meletakkan semua tongkat itu di depan peti perjanjian di dalam kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Besoknya, Musa masuk ke dalam kemah, dan dilihatnya tongkat Harun sudah bertunas dan mengeluarkan kuncup-kuncup serta bunga-bunga. Bahkan sudah ada buah-buah badam yang matang! ");
INSERT INTO ind_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musa membawa keluar semua tongkat itu dari kemah TUHAN dan menunjukkannya kepada semua orang Israel. Lalu setiap kepala suku mengambil kembali tongkatnya masing-masing. ");
INSERT INTO ind_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Lalu TUHAN berkata kepada Musa, “Letakkan kembali tongkat Harun di depan peti perjanjian sebagai peringatan bagi para pemberontak supaya mereka berhenti bersungut-sungut. Dengan demikian, mereka tidak akan mati.” ");
INSERT INTO ind_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Maka Musa berbuat sesuai apa yang diperintahkan itu. ");
INSERT INTO ind_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Lalu berkatalah orang Israel kepada Musa, “Celaka! Pasti kami mati! Pasti kami semua akan binasa! ");
INSERT INTO ind_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Semua orang yang mendekat ke kemah TUHAN pasti akan mati. Celakalah kami semua!” ");
INSERT INTO ind_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","TUHAN berkata kepada Harun, “Kamu, anak-anakmu, dan seluruh suku Lewi akan menanggung pelanggaran yang terjadi dalam pelaksanaan semua tugas mereka di kemah-Ku, sedangkan hanya kamu dan anak-anakmu yang akan menanggung pelanggaran yang terjadi dalam pelaksanaan semua tugas sebagai imam. ");
INSERT INTO ind_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","“Suruhlah saudara-saudaramu suku Lewi untuk membantu di halaman kemah-Ku dalam tugas-tugas yang diberikan kepadamu dan anak-anakmu. ");
INSERT INTO ind_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Namun ketika melakukan tugas mereka, mereka tidak boleh mendekati mezbah maupun barang-barang kudus di kemah-Ku. Jika mereka mendekatinya, mereka dan kalian juga akan mati. ");
INSERT INTO ind_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Mereka harus bekerja bersama dengan kalian dan bertugas mengurus segala kebutuhan kemah-Ku. Selain mereka, tidak ada yang boleh membantu kalian. ");
INSERT INTO ind_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Kalianlah yang harus mengurus segala hal yang berhubungan dengan kemah-Ku dan mezbah kurban, supaya Aku tidak akan murka kepada umat Israel lagi. ");
INSERT INTO ind_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Aku sendiri yang sudah memilih suku Lewi dari antara bangsa Israel sebagai hadiah bagi kalian. Mereka dikhususkan bagi-Ku untuk melayani di halaman kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Sedangkan kamu dan anak-anakmu harus bertugas sebagai imam atas segala yang terkait dengan mezbah kurban dan semua yang ada di dalam ruang mahakudus. Aku sudah menghadiahkan jabatan imam kepada kalian. Selain kalian, siapa pun yang mendekati barang-barang kudus itu harus dihukum mati.” ");
INSERT INTO ind_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","9","TUHAN berbicara lagi kepada Harun, “Aku sudah memberi kepadamu dan keturunanmu semua persembahan dari umat Israel untuk-Ku yang tidak dibakar habis. Itu adalah jatah kalian sampai selamanya. Bagianmu termasuk setiap persembahan gandum-ganduman, kurban penghapus dosa, dan kurban penebus kesalahan. Bagian yang kalian terima itu sangatlah kudus ");
INSERT INTO ind_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","dan harus diperlakukan sebagai sesuatu yang sangat kudus. Kalian akan memakannya di tempat yang kudus, dan hanya laki-laki yang boleh memakannya. ");
INSERT INTO ind_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Aku juga memberikan kepada kalian semua persembahan khusus dari orang Israel yang diangkat tinggi di hadapan-Ku tetapi tidak diletakkan di atas mezbah. Ini adalah jatahmu dan keturunanmu, baik laki-laki maupun perempuan, sampai selamanya. Setiap anggota keluargamu yang tidak najis boleh memakannya. ");
INSERT INTO ind_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Hasil panen pertama yang dipersembahkan umat Israel kepada-Ku juga Aku berikan kepada kalian, baik itu minyak zaitun terbaik, air anggur yang baru, maupun gandum-ganduman. ");
INSERT INTO ind_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Segala hasil panen pertama yang mereka persembahkan kepada-Ku adalah milik kalian. Setiap anggota keluargamu yang tidak najis boleh memakannya. ");
INSERT INTO ind_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Segala sesuatu di Israel yang dikhususkan bagi-Ku sebagai persembahan kudus menjadi bagian kalian. ");
INSERT INTO ind_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Semua anak laki-laki sulung dan hewan jantan yang lahir pertama yang dipersembahkan kepada-Ku menjadi milik kalian. Tetapi setiap anak laki-laki sulung dan anak keledai jantan pertama harus ditebus kembali ");
INSERT INTO ind_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","waktu berumur satu bulan dengan uang tebusan sebesar 55 gram perak, ditimbang sesuai pengukur berat yang sah. ");
INSERT INTO ind_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Anak jantan pertama dari sapi, domba, dan kambing tidak boleh ditebus karena hewan itu sudah dikhususkan bagi-Ku. Siramkanlah darahnya pada mezbah kurban dan bakarlah lemaknya sebagai persembahan yang bau harumnya menyenangkan-Ku. ");
INSERT INTO ind_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Semua daging dari persembahan anak jantan hewan adalah milik kalian, sebagaimana kalian juga selalu mendapat bagian rusuk dan paha kanan yang diangkat tinggi dari kurban tanda damai. ");
INSERT INTO ind_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Aku memberikan kepada kalian semua persembahan kudus yang dipersembahkan orang Israel kepada-Ku. Bagian ini selalu untukmu dan anak-anakmu, laki-laki maupun perempuan. Perjanjian yang Aku buat denganmu dan keturunanmu ini berlaku untuk selama-lamanya.” ");
INSERT INTO ind_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","“Kamu dan keturunanmu tidak akan mendapat tanah warisan seperti suku-suku Israel lainnya. Akulah yang menjadi warisan kalian dan yang akan memenuhi kebutuhan kalian.” ");
INSERT INTO ind_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Untuk para pelayan suku Lewi, Aku memberikan setiap persembahan perpuluhan dari hasil panen bangsa Israel sebagai warisan mereka. Itulah upah untuk pelayanan mereka di halaman kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","“Suku Israel lainnya tidak boleh mendekat ke kemah-Ku. Kalau mereka mendekat, pelanggaran itu akan mengakibatkan kematian mereka. ");
INSERT INTO ind_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Hanya orang Lewi yang akan bekerja di halaman kemah-Ku, dan mereka akan menanggung hukuman atas pelanggaran yang terjadi dalam pelaksanaan tugas mereka. Peraturan ini berlaku turun temurun sampai selamanya. Suku Lewi tidak akan mendapat tanah warisan seperti suku-suku Israel lainnya, ");
INSERT INTO ind_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","karena Aku memberikan persembahan perpuluhan yang dibawa oleh bangsa Israel kepada-Ku sebagai warisan bagi mereka. Itulah sebabnya Aku berkata bahwa mereka tidak akan menerima warisan seperti suku-suku Israel lainnya.” ");
INSERT INTO ind_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","27","“Katakanlah ini kepada para pelayan suku Lewi: Ketika kalian menerima persembahan perpuluhan itu, kalian harus mempersembahkan sepersepuluhnya kepada-Ku. Perpuluhan kalian ini memang berasal dari perpuluhan umat Israel tetapi dianggap sama dengan apa yang mereka berikan dari panen gandum dan perasan air anggur mereka. ");
INSERT INTO ind_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Jadi, kalian harus mempersembahkan kepada-Ku sebagian dari semua persembahan perpuluhan yang kalian terima dari umat Israel. Persembahan itu harus kalian berikan kepada para imam. ");
INSERT INTO ind_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Persembahkanlah kepada-Ku bagian terbaik dari semua yang kalian terima. Itu juga akan dianggap bagian yang paling kudus. ");
INSERT INTO ind_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Sesudah kalian mempersembahkan bagian yang terbaik, sisanya akan dianggap sebagai milik kalian, sama seperti panenan gandum dan perasan air anggur umat Israel adalah milik mereka sesudah perpuluhan dipersembahkan. ");
INSERT INTO ind_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Kalian dan keluarga kalian boleh memakannya dimana saja, karena itu adalah upah kalian untuk pekerjaan yang kalian lakukan di halaman kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kalian tidak bersalah apabila kalian memakannya, asalkan kalian sudah mempersembahkan bagian terbaik kepada-Ku. Tetapi kalau kalian mencemari persembahan kudus bangsa Israel dengan memakannya sebelum bagian yang terbaik dipersembahkan, kalian akan mati.” ");
INSERT INTO ind_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","TUHAN berbicara kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Aku juga memberikan peraturan-peraturan ini kepada kalian. Suruhlah orang Israel untuk membawa sapi betina berwarna merah yang sama sekali tidak bercacat dan belum pernah dipakai untuk membawa beban. ");
INSERT INTO ind_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","4","Serahkanlah sapi itu kepada Imam Eleazar. Sapi itu akan dibawa keluar perkemahan Israel ke arah timur dan disembelih di hadapannya. Di tempat itu dia akan mengambil sedikit darah dengan jarinya dan memercikkannya sebanyak tujuh kali ke arah pintu masuk kemah-Ku. ");
INSERT INTO ind_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Lalu seluruh bagian sapi itu akan dibakar dalam pengawasan Eleazar sampai habis semuanya. Jangan ada yang tertinggal, baik kulit, daging, darah, bahkan kotorannya. ");
INSERT INTO ind_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kemudian Eleazar akan mengambil sebatang kayu aras, ranting hisop, dan tali merah, dan melemparkan semua itu ke dalam api yang membakar sapi itu. ");
INSERT INTO ind_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","“Lalu Eleazar harus mandi dan mencuci pakaiannya. Sesudah itu, dia baru boleh masuk kembali ke perkemahan. Tetapi dia tetap najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Orang yang membakar sapi itu juga harus mandi dan mencuci pakaiannya, dan dia juga najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Kemudian seseorang yang tidak najis harus mengumpulkan abu sapi itu dan menyimpannya di tempat yang kudus di luar perkemahan. Abu itu akan dicampurkan dengan air untuk menjadi air penyucian, yang akan dipercikkan pada orang Israel dalam upacara penyucian diri dari dosa. ");
INSERT INTO ind_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Dan orang yang mengumpulkan abu itu juga harus mencuci pakaiannya, dan tetap najis sampai matahari terbenam. Peraturan tentang pengolahan air penyucian ini harus ditaati sampai selama-lamanya, baik untuk kepentingan orang Israel maupun orang asing yang tinggal bersama dengan kalian.” ");
INSERT INTO ind_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Siapa pun yang menyentuh mayat menjadi najis selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dia harus dipercikkan dengan air penyucian itu pada hari yang ketiga dan hari yang ketujuh. Sesudah percikan kedua, dia tidak lagi najis. Tetapi kalau dia tidak dipercikkan dengan air penyucian itu pada hari yang ketiga dan hari yang ketujuh, dia tetap najis. ");
INSERT INTO ind_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Jadi, siapa pun yang menyentuh mayat dan tidak menyucikan dirinya dengan dipercikkan dengan air penyucian, dia tetap najis. Kenajisannya mencemari kemah-Ku dan dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku. ");
INSERT INTO ind_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Inilah peraturan yang akan dilakukan jika seseorang meninggal di dalam sebuah kemah. Semua orang yang berada di kemah itu ketika dia meninggal atau siapa pun yang masuk ke dalam kemah itu menjadi najis selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Semua wadah yang terbuka dan tidak tertutup rapat di dalam kemah itu menjadi najis. ");
INSERT INTO ind_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Jika seseorang di padang menyentuh mayat, baik yang mati dibunuh maupun yang mati secara wajar, ataupun menyentuh tulang manusia atau kuburan, orang itu menjadi najis selama tujuh hari. ");
INSERT INTO ind_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Untuk upacara penyucian, masukkanlah sedikit abu penyucian ke dalam kendi dan tuangkanlah air yang diambil dari mata air ke dalamnya. ");
INSERT INTO ind_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Lalu seseorang yang tidak najis harus mengambil ranting hisop, mencelupkannya ke air itu, lalu mengibaskan ranting itu untuk memercikkan air itu pada orang-orang yang hadir di kemah saat kematian, semua barang-barang di dalam kemah itu, dan kemah itu. Air itu juga harus dipercikkan kepada siapa pun yang menyentuh tulang manusia, mayat, ataupun kuburan. ");
INSERT INTO ind_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Orang yang tidak najis harus memercikkan air itu pada yang najis pada hari ketiga dan hari ketujuh. Pada hari yang ketujuh, orang yang sedang disucikan harus mandi dan mencuci pakaiannya. Dan sesudah matahari terbenam, dia tidak lagi najis. ");
INSERT INTO ind_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Jika orang yang menjadi najis tidak disucikan, dia akan disingkirkan dari antara umat yang taat pada perjanjian-Ku, karena kenajisannya mencemari kemah-Ku. Orang itu tetap najis karena dia tidak dipercikkan dengan air penyucian. ");
INSERT INTO ind_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Peraturan ini berlaku bagi kalian untuk selama-lamanya. “Orang yang memercikkan air penyucian itu harus mencuci pakaiannya. Siapa pun yang menyentuh wadah yang digunakan untuk air penyucian menjadi najis sampai matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Apa pun dan siapa pun yang disentuh oleh orang yang najis akan menjadi najis sampai matahari terbenam.” ");
INSERT INTO ind_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Pada bulan pertama di tahun keempat puluh sejak bangsa Israel berangkat dari Mesir, bangsa Israel sampai di padang gurun Zin dan berkemah di dekat Kades. Di tempat ini Miryam meninggal dan dikuburkan. ");
INSERT INTO ind_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Di tempat itu tidak ada air. Maka bangsa Israel datang mengerumuni Musa dan Harun ");
INSERT INTO ind_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","dan menggerutu, “Lebih baik kami mati bersama saudara-saudara kami waktu mereka mati di hadapan TUHAN! ");
INSERT INTO ind_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Buat apa kamu membawa kami keluar dari Mesir untuk hidup di padang belantara ini?! Tampaknya kamu sengaja mau membuat kami dan ternak kami mati! ");
INSERT INTO ind_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Lebih baik kami tidak mendengarkan kamu waktu mengajak kami tinggalkan Mesir! Di tempat yang mengerikan ini tidak ada gandum, buah ara, anggur ataupun delima, bahkan tidak ada air untuk kami minum!” ");
INSERT INTO ind_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Maka Harun dan Musa meninggalkan kerumunan itu dan pergi ke depan kemah TUHAN dan bersujud. Lalu tampaklah kemuliaan-Nya ");
INSERT INTO ind_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","dan berkatalah TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ambillah tongkat Harun, lalu kumpulkanlah umat-Ku. Di depan mata mereka, perintahkanlah batu besar itu untuk mengeluarkan air. Dengan demikian, kalian akan membuat air keluar dari bukit batu itu dan seluruh umat dan ternak mereka bisa minum.” ");
INSERT INTO ind_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Maka Musa mengambil tongkat Harun dari depan peti perjanjian, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Lalu Harun dan Musa mengumpulkan seluruh umat di depan bukit batu itu. Kemudian berserulah Musa kepada mereka, “Dasar para pemberontak! Sepertinya kalian pikir kami mampu mengeluarkan air dari batu besar ini!” ");
INSERT INTO ind_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Lalu Musa mengangkat tangannya dan memukul bukit batu itu dua kali dengan tongkat Harun. Maka keluarlah air dari batu itu dengan deras, lalu orang Israel dan ternak mereka minum. ");
INSERT INTO ind_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tetapi TUHAN berkata kepada Musa dan Harun, “Karena kalian berdua tidak percaya kepada-Ku dan tidak menghormati Aku sebagai Allah yang kudus di depan mata orang Israel, kalian tidak akan membawa umat ini masuk ke negeri yang Aku berikan kepada mereka.” ");
INSERT INTO ind_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Kemudian tempat itu diberi nama mata air Meriba, yang berarti ‘pertentangan’, karena di sana orang Israel menentang TUHAN, dan TUHAN menunjukkan kekudusan-Nya kepada mereka. ");
INSERT INTO ind_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ketika bangsa Israel berada di dekat kota Kades, Musa mengirim pesan kepada raja Edom, “Kami orang Israel, sanak saudaramu, mengirim pesan kepadamu. Engkau tahu segala kesulitan yang sudah kami alami, ");
INSERT INTO ind_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","dan khususnya bagaimana nenek moyang kami pergi ke Mesir dan tinggal di sana untuk waktu yang lama. Di sana orang Mesir memperlakukan nenek moyang kami dengan kejam, sampai dengan generasi kami. ");
INSERT INTO ind_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Tetapi ketika kami berseru kepada TUHAN, Dia mendengarkan seruan kami dan mengutus malaikat untuk membawa kami keluar dari Mesir. Saat ini kami berkemah di Kades, kota yang ada di perbatasan wilayah kalian. ");
INSERT INTO ind_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Izinkanlah kami melewati negerimu. Kami tidak akan berjalan melewati ladang ataupun kebun anggur kalian. Kami juga tidak akan minum air dari sumur kalian. Kami hanya akan lewat jalan utama dan kami tidak akan menyimpang dari jalan itu sampai kami keluar dari wilayahmu.” ");
INSERT INTO ind_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Tetapi raja Edom menjawab, “Tidak bisa! Kalau kalian lewat wilayah kami, kami akan menyerang kalian!” ");
INSERT INTO ind_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Orang Israel berkata, “Kami hanya akan lewat jalan utama. Kalau kami atau ternak kami minum air kalian, kami akan membayarnya. Kami hanya minta izin berjalan lewat negeri ini. Kami tidak punya maksud apa-apa lagi.” ");
INSERT INTO ind_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Tetapi raja Edom bersikeras, “Kalian tidak boleh lewat!” Lalu raja Edom mengirim para tentaranya yang banyak dan kuat untuk menghadang mereka. ");
INSERT INTO ind_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Karena Edom melarang bangsa Israel untuk lewat, bangsa Israel terpaksa berbalik dan pergi melewati jalan lain. ");
INSERT INTO ind_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Lalu seluruh umat Israel pergi dari Kades dan tiba di gunung Hor, ");
INSERT INTO ind_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","di perbatasan negeri Edom. Di sana TUHAN berkata kepada Musa dan Harun, ");
INSERT INTO ind_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Sudah waktunya Harun mendapat tempat bersama dengan nenek moyangnya yang sudah meninggal. Dia tidak akan masuk ke negeri yang Aku janjikan kepada orang Israel karena kalian berdua melawan perintah-Ku di mata air Meriba. ");
INSERT INTO ind_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Musa, bawalah Harun dan Eleazar, anaknya, naik ke gunung Hor. ");
INSERT INTO ind_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Di sana, lepaskanlah pakaian imam yang dipakai Harun dan kenakanlah pakaian itu kepada Eleazar. Harun akan mati di sana dan mendapat tempat bersama dengan nenek moyangnya yang sudah meninggal.” ");
INSERT INTO ind_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Maka Musa melakukan sesuai perintah TUHAN. Mereka bertiga naik ke puncak gunung Hor sementara seluruh umat Israel memperhatikan. ");
INSERT INTO ind_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Lalu Musa melepaskan pakaian Imam Harun dan mengenakannya pada Eleazar. Harun meninggal di puncak gunung Hor, lalu Musa dan Eleazar turun kembali. ");
INSERT INTO ind_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ketika umat Israel tahu bahwa Harun sudah meninggal, mereka meratap untuk Harun selama tiga puluh hari. ");
INSERT INTO ind_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Di bagian selatan negeri Kanaan, terdapat kota Arad milik orang Kanaan. Ketika raja Arad mendengar bahwa orang Israel datang melewati jalan desa Atarim, dia menyergap mereka dan menangkap beberapa orang sebagai tawanan. ");
INSERT INTO ind_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Maka orang Israel bersumpah kepada TUHAN, “Apabila Engkau membuat kami menang atas bangsa itu maka kami akan memusnahkan mereka seluruhnya dan kami akan membumihanguskan kota mereka sebagai akibat kutukan-Mu.” ");
INSERT INTO ind_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","TUHAN mendengar permintaan orang Israel dan membuat mereka menang atas bangsa Kanaan. Kemudian mereka memusnahkan banyak orang dari daerah itu dan menghancurkan kota-kota mereka untuk menjadi bukti kuasa kutukan TUHAN. Itulah sebabnya tempat itu dinamakan Horma, yang berarti kehancuran. ");
INSERT INTO ind_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kemudian orang Israel berangkat dari gunung Hor dan pergi melalui jalan yang menuju ke Laut Merah supaya tidak memasuki daerah bangsa Edom. Tetapi di tengah perjalanan, mereka menjadi tidak sabar ");
INSERT INTO ind_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","dan mulai bersungut-sungut terhadap Musa— yang berarti terhadap Allah juga— dengan berkata, “Buat apa kamu membawa kami keluar dari Mesir untuk hidup di padang belantara ini?! Tampaknya kamu sengaja mau membunuh kami! Di sini tidak ada roti ataupun air minum. Yang ada hanya manna, dan kami sudah muak makan roti murahan ini!” ");
INSERT INTO ind_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Maka TUHAN mengirim ular-ular berbisa ke tengah-tengah orang Israel. Ular-ular itu menggigit mereka, sehingga banyak yang mati. ");
INSERT INTO ind_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Kemudian mereka datang kepada Musa dan berkata, “Kami sudah berdosa karena kami bersungut-sungut terhadap TUHAN dan terhadapmu. Berdoalah kepada TUHAN supaya Dia menyingkirkan ular-ular ini.” Maka Musa mendoakan mereka. ");
INSERT INTO ind_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Lalu berkatalah TUHAN kepada Musa, “Buatlah tiruan ular dari perunggu dan taruhlah di atas tiang. Setiap orang yang digigit ular akan sembuh jika dia memandang benda itu.” ");
INSERT INTO ind_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Lalu Musa membuat tiruan ular dari perunggu dan menaruhnya di atas tiang. Setiap orang yang digigit ular menjadi sembuh kalau dia memandang tiruan ular dari perunggu itu. ");
INSERT INTO ind_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Sesudah itu, orang Israel meneruskan perjalanan dan berkemah di Obot. ");
INSERT INTO ind_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Dari sana, mereka melanjutkan perjalanan dan berkemah di reruntuhan Abarim, di padang belantara di sebelah timur daerah Moab. ");
INSERT INTO ind_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kemudian mereka kembali melanjutkan perjalanan dan berkemah di lembah Zered. ");
INSERT INTO ind_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Dari sana, mereka terus pergi dan menyeberangi sungai Arnon, dan berkemah di padang belantara di wilayah orang Amori. Sungai Arnon adalah perbatasan antara wilayah orang Moab dan wilayah orang Amori. ");
INSERT INTO ind_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Tempat-tempat ini juga disebut dalam Kitab Pertempuran TUHAN. Di kitab itu tertulis, “… Waheb di daerah Sufa, jurang-jurang di sekitar anak sungai Arnon, ");
INSERT INTO ind_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","dan lereng-lereng lembah yang terbentang sampai ke kota Ar dan menuju perbatasan daerah Moab.” ");
INSERT INTO ind_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Dari sana, mereka pergi ke sebuah tempat yang disebut Sumur. Di sinilah TUHAN pernah berkata kepada Musa, “Kumpulkanlah bangsa Israel. Aku akan memberi air kepada mereka.” ");
INSERT INTO ind_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Pada waktu itu, orang Israel menyanyikan lagu ini: “Hai Sumur, meluaplah! Mari kita nyanyikan lagu mengenai sumur ini, ");
INSERT INTO ind_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","yang digali para pemuka dan pemimpin Israel dengan tongkat-tongkat kepemimpinan mereka.” Dari sana mereka melanjutkan perjalanan ke Matana, ");
INSERT INTO ind_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","lalu ke Nahaliel, dan kemudian ke Bamot. ");
INSERT INTO ind_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Sesudah itu mereka pergi ke lembah di daerah Moab di bawah puncak gunung Pisga yang menghadap padang belantara. ");
INSERT INTO ind_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Lalu orang Israel mengirim utusan kepada Sihon, raja orang Amori, untuk menyampaikan pesan ini, ");
INSERT INTO ind_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Izinkanlah kami melewati negerimu. Kami tidak akan berjalan lewat ladang ataupun kebun anggur kalian. Kami juga tidak akan minum air dari sumur kalian. Kami hanya akan lewat jalan utama sampai kami keluar dari wilayahmu.” ");
INSERT INTO ind_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Tetapi Sihon tidak mengizinkan orang Israel melewati negerinya, dia malah mengumpulkan seluruh pasukannya untuk menyerang di padang belantara, di mana mereka menyerang bangsa Israel di desa Yahas. ");
INSERT INTO ind_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Tetapi orang Israel membantai mereka dan menduduki negeri itu, mulai dari sungai Arnon di selatan sampai ke sungai Yabok di utara. Di timur, Israel hanya menguasai sampai perbatasan wilayah orang Amon, karena pertahanan mereka sangat kuat. ");
INSERT INTO ind_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Dengan demikian orang Israel merebut semua kota orang Amori, termasuk Hesbon dan kota-kota kecil lainnya, lalu mereka menetap di sana. ");
INSERT INTO ind_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbon adalah ibukota Sihon. Dulu, Sihon berperang melawan raja orang Moab yang sebelumnya berkuasa di sana dan merebut seluruh wilayahnya sampai ke sungai Arnon. ");
INSERT INTO ind_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Itulah sebabnya para penyair menceritakan kisah kemenangan Raja Sihon, “Datanglah ke Hesbon, biarlah kota ini dibangun kembali. Mulai sekarang, biarlah kota kedudukan Raja Sihon ini berjaya. ");
INSERT INTO ind_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Dahulu, pasukan Sihon maju dari Hesbon seperti nyala api. Mereka keluar dari kota Raja Sihon bagaikan kobaran api yang membakar habis kota Ar di Moab dan melahap penduduk bukit-bukit di sepanjang sungai Arnon. ");
INSERT INTO ind_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Celakalah kalian, orang Moab! Binasalah kalian, para pemuja Kamos! Dewa kalian sudah membiarkan anak-anak laki-laki kalian menjadi pengungsi dan anak-anak perempuan kalian menjadi tawanan Sihon, raja orang Amori. ");
INSERT INTO ind_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Tetapi sekarang, pasukan Sihon sudah membinasakan bangsa Moab dari Hesbon ke Dibon, dan sampai Nofah dekat Medeba.” ");
INSERT INTO ind_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Orang Israel pun menetap di daerah orang Amori. ");
INSERT INTO ind_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Kemudian Musa menyuruh beberapa orang mengintai kota Yazer untuk mencari jalan menyerang kota itu. Lalu orang Israel merebut kota itu serta kota-kota kecil di sekitarnya, dan mengusir orang-orang Amori yang ada di sana. ");
INSERT INTO ind_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kemudian orang Israel berbelok dan naik ke arah daerah Basan. Di sana pasukan Og, raja orang Basan, menyerang mereka di kota Edrei. ");
INSERT INTO ind_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Tetapi TUHAN berkata kepada Musa, “Jangan takut kepadanya! Sebab Aku sudah putuskan untuk membuat kamu menang atas dia. Rakyatnya dan seluruh daerahnya pun akan jatuh ke tanganmu. Kalian akan memperlakukan dia sama seperti kalian memperlakukan raja Sihon.” ");
INSERT INTO ind_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Maka pasukan Israel mengalahkan dan membunuh Raja Og, anak-anaknya, dan seluruh rakyatnya. Tidak ada seorang pun yang selamat. Kemudian bangsa Israel menduduki negeri itu juga. ");
INSERT INTO ind_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Bangsa Israel berangkat lagi dan berkemah di dataran Moab, di sebelah timur sungai Yordan, berseberangan dengan kota Yeriko. ");
INSERT INTO ind_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","4","Pada waktu itu, Moab dikuasai oleh Balak anak Zipor. Ketika Raja Balak mendengar bagaimana orang Israel sudah memperlakukan orang Amori dan bahwa jumlah orang Israel sangat banyak, dia dan seluruh Moab menjadi gentar dan takut terhadap orang Israel. Lalu Balak berkata kepada para pemimpin daerah Midian, “Gerombolan itu akan melahap habis semua yang ada di sekitar kita seperti sapi melahap hijau-hijauan di padang.” Maka Balak ");
INSERT INTO ind_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","mengirim utusan kepada Bileam anak Beor. Bileam adalah seorang peramal yang tinggal di kota Petor, dekat sungai Efrat, di daerah orang Amau. Inilah pesan Balak: “Ada suatu bangsa yang datang dari Mesir. Orang-orangnya menyebar kemana-mana dan sekarang mereka berkemah di pinggiran wilayahku. ");
INSERT INTO ind_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Mereka lebih kuat dari kami, jadi tolong datang untuk mengutuk mereka bagi kami. Dengan demikian mungkin kami bisa mengalahkan mereka dan mengusir mereka dari negeri ini. Karena saya tahu orang yang kamu berkati akan mendapat berkat, dan orang yang kamu kutuk akan mendapat kutuk.” ");
INSERT INTO ind_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Lalu berangkatlah para tua-tua dari bangsa Moab dan bangsa Midian dengan membawa bayaran untuk mengutuk bangsa Israel. Sesudah sampai kepada Bileam, mereka menyampaikan kepadanya pesan dari Balak. ");
INSERT INTO ind_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Jawab Bileam kepada mereka, “Menginaplah di sini malam ini dan besok saya akan memberitahukan kepadamu apa yang dikatakan TUHAN kepadaku.” Maka tinggallah para tua-tua itu di rumah Bileam. ");
INSERT INTO ind_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Malam itu datanglah Allah kepada Bileam dan bertanya, “Siapakah orang-orang yang tinggal bersamamu itu?” ");
INSERT INTO ind_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Jawab Bileam kepada-Nya, “Mereka utusan Raja Balak dari Moab yang datang untuk membawa pesan ini, ");
INSERT INTO ind_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Ada suatu bangsa yang datang dari Mesir dan mereka menyebar kemana-mana. Jadi tolong datang dan kutuklah mereka bagi kami. Dengan demikian mungkin kami bisa mengalahkan mereka dan mengusir mereka.’” ");
INSERT INTO ind_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kata Allah kepada Bileam, “Jangan pergi dengan mereka. Jangan kutuk bangsa itu karena mereka sudah Aku berkati.” ");
INSERT INTO ind_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Pada pagi berikutnya, Bileam berkata kepada para pemuka utusan Balak, “Pulanglah ke negeri kalian. TUHAN melarang saya pergi dengan kalian.” ");
INSERT INTO ind_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Lalu kembalilah mereka kepada Balak dan berkata, “Bileam menolak untuk ikut bersama dengan kami.” ");
INSERT INTO ind_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Maka Balak mengutus lebih banyak lagi pemuka-pemuka yang lebih terhormat dari utusan yang pertama. ");
INSERT INTO ind_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Sesudah mereka sampai kepada Bileam, mereka menyampaikan pesan Balak kepadanya, “Saya mohon, jangan biarkan apa pun menghalangimu untuk datang. ");
INSERT INTO ind_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Saya akan membalas jasamu dengan luar biasa, dan apa pun yang kamu minta akan saya lakukan. Datanglah dan kutuklah bangsa itu bagi saya.” ");
INSERT INTO ind_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Tetapi Bileam menjawab, “Meskipun Balak memberikan istananya beserta semua perak dan emas di dalamnya, saya tidak bisa melanggar perintah TUHAN, Allah saya, bahkan dalam hal kecil sekalipun. ");
INSERT INTO ind_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Silakan tinggal di sini malam ini, seperti yang dilakukan oleh para utusan sebelumnya. Barangkali masih ada yang TUHAN mau katakan kepada saya.” ");
INSERT INTO ind_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Malam itu, datanglah Allah kepada Bileam dan berkata, “Karena orang-orang itu sudah datang untuk memanggilmu, Aku izinkan kamu pergi bersama mereka. Tetapi kamu hanya boleh melakukan apa yang Aku perintahkan kepadamu.” ");
INSERT INTO ind_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Keesokan paginya, Bileam memasang pelana pada keledainya dan pergi bersama dengan para pemuka bangsa Moab itu. ");
INSERT INTO ind_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Namun Allah menjadi marah karena Bileam pergi. Ketika Bileam sedang mengendarai keledainya dengan diiringi oleh dua pelayannya, malaikat datang dan berdiri di tengah jalan untuk melawannya. ");
INSERT INTO ind_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ketika keledai itu melihat malaikat berdiri di jalan dengan pedang di tangannya, keledai itu membelok dari jalan dan masuk ke ladang. Namun Bileam memukul keledai itu sampai kembali ke jalan. ");
INSERT INTO ind_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Kemudian malaikat itu pindah ke bagian jalan yang sempit di antara dua kebun anggur. Kedua sisi jalan itu dipagari oleh tembok batu. ");
INSERT INTO ind_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ketika keledai itu melihat malaikat itu berdiri di depannya, dia minggir ke tembok sehingga kaki Bileam terjepit ke tembok. Lalu Bileam memukul lagi keledai itu. ");
INSERT INTO ind_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Lalu malaikat itu pergi mendahului mereka dan berdiri di bagian jalan yang lebih sempit lagi sehingga keledai itu tidak bisa lewat sama sekali. ");
INSERT INTO ind_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ketika melihat malaikat berdiri di depannya lagi, keledai itu langsung merebahkan diri dengan perutnya ke tanah sementara Bileam masih di atas punggungnya. Bileam menjadi sangat marah dan memukul keledai itu lagi dengan tongkatnya. ");
INSERT INTO ind_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Lalu TUHAN membuat keledai itu bisa berbicara. Kata keledai itu kepada Bileam, “Apa salahku? Kenapa Tuan memukulku sampai tiga kali?” ");
INSERT INTO ind_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Jawab Bileam, “Karena kamu membuatku terlihat seperti orang bodoh! Kalau saja ada pedang di tanganku, aku bunuh kamu sekarang juga!” ");
INSERT INTO ind_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Tetapi jawab keledai itu kepada Bileam, “Bukankah aku ini keledai Tuan? Dari dulu sampai sekarang Tuan selalu menunggangiku, benar? Apakah pernah aku memperlakukan Tuan seperti ini?” Jawab Bileam, “Tidak.” ");
INSERT INTO ind_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Kemudian TUHAN membuat Bileam bisa melihat malaikat itu. Malaikat itu sedang berdiri di jalan sambil memegang pedang di tangan-Nya. Bileam pun bersujud. ");
INSERT INTO ind_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Lalu malaikat itu menyampaikan pesan TUHAN, “Percuma kamu memukul keledaimu sampai tiga kali! Akulah yang melawanmu karena tujuan perjalananmu ini melawan kehendak-Ku. ");
INSERT INTO ind_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Tiga kali keledaimu melihat Aku dan menyingkir. Kalau tidak, pasti Aku sudah membunuhmu dan membiarkan keledai itu hidup.” ");
INSERT INTO ind_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Lalu Bileam menjawab, “Aku sudah berdosa! Aku tidak tahu kalau Engkau yang berdiri menentangku di jalan. Kalau perjalananku ini jahat di mata-Mu, sekarang aku akan pulang.” ");
INSERT INTO ind_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Tetapi TUHAN menjawab melalui perkataan malaikat itu, “Pergilah bersama dengan orang-orang itu, tetapi kamu hanya boleh mengatakan apa yang akan Aku katakan kepadamu.” Lalu Bileam melanjutkan perjalanannya bersama para pemuka itu. ");
INSERT INTO ind_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ketika Raja Balak mendengar bahwa Bileam datang, dia pergi menemuinya di sebuah kota Moab yang terletak di tepi sungai Arnon. Sungai Arnon adalah perbatasan wilayah Moab. ");
INSERT INTO ind_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak berkata kepada Bileam, “Kenapa kamu tidak datang waktu pertama kali saya panggil? Tentu kamu tahu saya sanggup membayarmu!” ");
INSERT INTO ind_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bileam menjawab, “Sekarang saya sudah datang. Tetapi saya tidak bisa mengatakan apa-apa selain apa yang Allah suruh saya katakan.” ");
INSERT INTO ind_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Kemudian pergilah Bileam bersama dengan Balak ke kota Huzot. ");
INSERT INTO ind_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Di sana Balak mengurbankan beberapa ekor domba dan sapi. Sebagian daging kurban itu diberikan kepada Bileam dan kepada para pemuka yang bersama-sama dengan dia. ");
INSERT INTO ind_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Besok paginya Balak membawa Bileam mendaki bukit Penyembahan Dewa Baal. Dari sana Bileam dapat melihat sebagian dari bangsa Israel. ");
INSERT INTO ind_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bileam berkata kepada Raja Balak, “Dirikanlah tujuh mezbah di tempat ini untuk saya. Sediakanlah juga di sini tujuh ekor sapi jantan dan tujuh ekor domba jantan untuk saya persembahkan.” ");
INSERT INTO ind_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak melakukan seperti yang dikatakan Bileam. Kemudian mereka mempersembahkan seekor sapi jantan dan seekor domba jantan di atas setiap mezbah ");
INSERT INTO ind_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","sebagai kurban yang dibakar habis. Sesudah itu Bileam berkata kepada Balak, “Berdirilah dekat mezbah-mezbah ini sementara saya pergi sendiri ke sana. Mungkin TUHAN akan datang menemui saya. Apa pun yang TUHAN nyatakan kepada saya akan saya sampaikan kepadamu.” Lalu Bileam pergi ke atas sebuah bukit yang gundul, ");
INSERT INTO ind_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","dan di sana Allah menemui Bileam. Lalu Bileam berkata kepada-Nya, “Saya sudah menyiapkan tujuh mezbah dan mempersembahkan seekor sapi jantan dan seekor domba jantan di atas masing-masing mezbah itu.” ");
INSERT INTO ind_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Kemudian TUHAN memberikan Bileam sebuah pesan untuk Balak. Kata-Nya, “Kembalilah dan sampaikan pesan ini kepada Balak.” ");
INSERT INTO ind_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bileam pun kembali dan melihat Balak masih berdiri di tempat semula bersama para pemuka Moab. ");
INSERT INTO ind_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Lalu Bileam menyampaikan pesannya, “Dari Aram, saya dipanggil oleh Balak, raja bangsa Moab. Dari pegunungan di timur sana, saya dibawa ke sini. Katanya, ‘Datanglah, kutuklah Yakub untuk saya! Nyatakanlah kejatuhan orang Israel!’ ");
INSERT INTO ind_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Tetapi bagaimana mungkin saya bisa mengutuk orang yang tidak dikutuk Allah? Bagaimana mungkin saya mengecam orang yang tidak dikecam oleh TUHAN? ");
INSERT INTO ind_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Dari puncak gunung-gunung batu saya melihat mereka, dari atas ketinggian saya memperhatikan mereka. Mereka adalah suatu bangsa yang tidak bercampur dengan bangsa lain, karena mereka menjaga kemurnian bangsanya. ");
INSERT INTO ind_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Adakah yang dapat menghitung keturunan Israel? Jumlah mereka terlalu banyak seperti debu. Seperempatnya pun tidak mungkin dihitung. Semoga akhir hidup saya seperti akhir hidup mereka, semoga saya mati sebagai orang yang berjalan di jalan yang benar.” ");
INSERT INTO ind_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Lalu berkatalah Balak kepadanya, “Apa yang sudah kamu lakukan kepadaku? Saya memanggilmu ke sini untuk mengutuk musuh-musuhku, tetapi sebaliknya kamu justru memberkati mereka.” ");
INSERT INTO ind_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Jawab Bileam, “Bukankah saya harus menyampaikan pesan TUHAN sesuai dengan apa yang Dia sampaikan?” ");
INSERT INTO ind_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Lalu Balak berkata kepada Bileam, “Ikutlah dengan saya ke tempat lain. Kamu bisa melihat bangsa Israel dari sana, tetapi hanya sebagian saja, tidak semuanya. Kutuklah mereka dari sana.” ");
INSERT INTO ind_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Kemudian Balak membawa Bileam ke Padang Pemantauan di atas puncak gunung Pisga. Di sana Balak mendirikan tujuh mezbah dan mempersembahkan seekor sapi jantan dan seekor domba jantan di atas setiap mezbah sebagai kurban yang dibakar habis. ");
INSERT INTO ind_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bileam berkata kepada Balak, “Berdirilah di sini dekat kurbanmu sementara saya pergi ke sana untuk bertemu dengan TUHAN.” ");
INSERT INTO ind_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Lalu TUHAN datang menemui Bileam dan memberinya sebuah pesan untuk Balak. Kata-Nya, “Kembalilah dan sampaikan pesan ini kepada Balak.” ");
INSERT INTO ind_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ketika Bileam kembali, dia melihat Balak masih berdiri di dekat semua kurbannya bersama para pemimpin Moab. Lalu Balak bertanya, “Apakah yang dikatakan TUHAN?” ");
INSERT INTO ind_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bileam menyampaikan pesan ini, “Hai Balak anak Zipor, dengarkanlah pesan yang saya sampaikan ini! ");
INSERT INTO ind_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Allah itu bukan seperti manusia, jadi Dia tidak pernah berbohong. Dia tidak pernah berubah pikiran seperti kita. Semua yang dikatakan-Nya, pasti Dia lakukan. Semua yang dijanjikan-Nya, pasti Dia tepati. ");
INSERT INTO ind_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Saya diperintahkan untuk memberkati bangsa pilihan-Nya. Kalau Dia sudah memberikan berkat-Nya, saya tidak bisa menariknya kembali. ");
INSERT INTO ind_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Allah tidak merencanakan kemalangan atau kesusahan bagi keturunan Yakub. TUHAN Allah mereka menyertai mereka, dan mereka bersorak-sorak karena Allah mereka sendiri memimpin dan menyertai mereka. ");
INSERT INTO ind_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Allah, yang sudah membawa mereka keluar dari Mesir menguatkan para pasukan Israel sehingga mereka menyerang musuh seperti sapi jantan yang ganas. ");
INSERT INTO ind_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tidak ada ilmu gaib atau kutukan dukun yang bisa menyakiti bangsa keturunan Yakub. Malah orang dari segala bangsa akan takjub dan berkata, ‘Sungguh luar biasa apa yang Allah sudah lakukan bagi bangsa Israel!’ ");
INSERT INTO ind_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mereka seperti singa yang bangkit untuk mencari mangsa dan tidak akan beristirahat sampai melahap mangsanya dan minum darahnya!” ");
INSERT INTO ind_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Lalu Balak berkata kepada Bileam, “Ya sudah, kalau kamu tetap tidak mau mengutuk mereka, janganlah memberkati mereka!” ");
INSERT INTO ind_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bileam menjawab, “Saya sudah jelaskan kepadamu bahwa hanya perintah TUHAN yang dapat saya lakukan!” ");
INSERT INTO ind_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Maka Balak berkata kepada Bileam, “Ikutlah dengan saya ke tempat lain. Mungkin dari tempat itu Allah akan mengizinkan kamu untuk mengutuk mereka bagi saya.” ");
INSERT INTO ind_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Lalu Balak membawa Bileam ke puncak gunung Peor yang menghadap ke padang belantara. ");
INSERT INTO ind_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Lalu Bileam berkata kepada Balak, “Dirikanlah bagi saya di sini tujuh mezbah dan siapkan juga tujuh ekor sapi jantan dan tujuh ekor domba jantan.” ");
INSERT INTO ind_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak melakukan seperti yang dikatakan Bileam, dan mempersembahkan seekor sapi jantan dan seekor domba jantan di atas setiap mezbah. ");
INSERT INTO ind_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Sekarang Bileam sudah tahu bahwa TUHAN ingin memberkati bangsa Israel. Karena itu dia tidak lagi pergi mencari pertanda dengan ilmu gaib seperti yang dia lakukan sebelumnya, tetapi dia memandang ke padang belantara ");
INSERT INTO ind_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","di mana dia melihat perkemahan suku-suku Israel. Roh Allah menguasai dia ");
INSERT INTO ind_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","dan memberikan pesan ini kepadanya, “Inilah nubuatan Bileam anak Beor, nubuatan seseorang yang dapat melihat secara rohani dengan jelas. ");
INSERT INTO ind_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Inilah nubuatan seseorang yang dapat mendengar perkataan Allah, melihat penglihatan yang ditunjukkan Yang Mahakuasa, dan bersujud dengan mata rohani terbuka. ");
INSERT INTO ind_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hai keturunan Yakub, bagus sekali perkemahanmu! Betapa indahnya tempat kediamanmu! ");
INSERT INTO ind_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Perkemahan kalian indah seperti lembah penuh dengan kebun yang dilintasi sungai, dan seperti pohon-pohon gaharu dan aras yang ditanam TUHAN di tepi aliran air. ");
INSERT INTO ind_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Bukan saja tanaman mereka subur karena tidak kekurangan air, setiap keluarga mereka juga makmur. Raja mereka lebih agung dari Raja Agag dan kerajaan mereka akan berjaya. ");
INSERT INTO ind_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Allah, yang sudah membawa mereka keluar dari Mesir menguatkan para pasukan Israel sehingga mereka menyerang musuh seperti banteng yang ganas. Para pasukan Israel akan melahap bangsa-bangsa musuh, meremukkan tulang-tulang mereka, dan menghabisi mereka dengan panah. ");
INSERT INTO ind_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Bangsa Israel itu seperti singa yang berbaring. Siapa yang berani membangunkannya? Diberkatilah orang yang memberkati mereka dan terkutuklah orang yang mengutuk mereka!” ");
INSERT INTO ind_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Maka Balak menjadi geram kepada Bileam. Dengan mengepalkan tinjunya dia berkata, “Saya memanggil kamu untuk mengutuk musuh-musuh saya, tetapi kamu malah memberkati mereka sampai tiga kali! ");
INSERT INTO ind_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Pulang sekarang juga! Saya sudah katakan bahwa saya akan memberimu bayaran yang sangat besar. Tetapi TUHAN tidak mengizinkan kamu mendapatkannya.” ");
INSERT INTO ind_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Jawab Bileam, “Dulu saya sudah katakan kepada utusan-utusan yang kamu kirim kepada saya, ");
INSERT INTO ind_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Meskipun Balak memberikan istananya beserta semua perak dan emas di dalamnya, saya tidak bisa melanggar perintah TUHAN dengan melakukan apa pun sesuai kemauan saya sendiri, baik hal yang baik maupun jahat. Saya hanya akan mengatakan apa yang diperintahkan TUHAN.’ ");
INSERT INTO ind_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Sekarang saya akan pulang kepada bangsa saya. Tetapi sebelumnya, saya ingin memberitahukanmu apa yang akan dilakukan bangsa Israel kepada bangsamu di kemudian hari.” ");
INSERT INTO ind_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Lalu Bileam mengucapkan pesan ini, “Inilah nubuatan Bileam anak Beor, nubuatan seorang yang dapat melihat secara rohani dengan jelas. ");
INSERT INTO ind_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Inilah nubuatan seseorang yang dapat mendengar perkataan Allah, yang memiliki pengetahuan dari Yang Mahatinggi, melihat penglihatan yang ditunjukkan Yang Mahakuasa, dan bersujud dengan mata rohani terbuka. ");
INSERT INTO ind_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Kelak akan tampil seorang keturunan Yakub yang bagaikan bintang. Dengan tongkat kerajaannya raja Israel ini akan meremukkan bangsa Moab dan seluruh bangsa musuhnya yang lain. Aku melihat dia, tapi sekarang belum waktunya. Dia masih jauh di masa yang akan datang. ");
INSERT INTO ind_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","19","Pegunungan Seir dan sampai seluruh negeri Edom akan ditaklukkan oleh raja itu. Bahkan dia akan menumpas orang-orang yang kabur dari ibukota mereka. Sedangkan di bawah pimpinan raja keturunan Yakub itu Israel akan terus berjaya.” ");
INSERT INTO ind_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ketika Bileam melihat bangsa Amalek dalam penglihatannya, dia menyampaikan pesan ini: “Dulu, di antara bangsa-bangsa lain, Amalek adalah yang terkemuka, akan tetapi pada akhirnya semua bangsa itu akan dilenyapkan untuk selamanya.” ");
INSERT INTO ind_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kemudian dalam penglihatannya, Bileam melihat orang Keni. Lalu dia menyampaikan pesan ini: “Biarpun kalian orang Keni merasa aman, seperti burung yang bersarang di bukit batu, ");
INSERT INTO ind_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","tetapi kalian akan ditumpas dan ditawan oleh orang Asyur.” ");
INSERT INTO ind_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kemudian Bileam menyampaikan pesannya yang terakhir, “Celaka! Siapakah yang bisa bertahan hidup ketika Allah melakukan semua ini?! ");
INSERT INTO ind_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Namun, kapal-kapal perang akan datang dari pesisir Siprus dan mereka akan menindas Asyur dan Heber. Tetapi kemudian para penindas itu pun akan binasa.” ");
INSERT INTO ind_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Kemudian Bileam pulang ke tempat tinggalnya, dan Balak juga meninggalkan tempat itu. ");
INSERT INTO ind_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Sementara orang Israel tinggal di padang Akasia, sebagian laki-laki Israel mulai melacur dengan perempuan-perempuan Moab yang ada di sana. ");
INSERT INTO ind_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","Perempuan-perempuan itu mengajak mereka ke upacara persembahan kurban kepada dewa-dewa setempat yang disebut para dewa Baal di gunung Peor. Di situ mereka ikut makan kurban itu dan bersujud menyembah dewa-dewa itu. Dengan berbuat demikian, berarti para laki-laki Israel itu mengikatkan diri mereka kepada dewa Baal sehingga bangkitlah amarah TUHAN terhadap Israel. ");
INSERT INTO ind_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kata TUHAN kepada Musa, “Tangkaplah semua pemimpin gerombolan penyembah Baal di antara bangsa Israel dan bunuhlah mereka di hadapan-Ku. Gantunglah mereka di depan umum pada siang hari supaya murka-Ku terhadap Israel reda.” ");
INSERT INTO ind_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kemudian berkatalah Musa kepada hakim-hakim Israel, “Kamu sekalian harus membunuh orang-orang dari suku kalian masing-masing yang menyembah para dewa Baal di gunung Peor.” ");
INSERT INTO ind_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","8","Pada waktu itu wabah mulai membunuh sebagian orang Israel. Ketika Musa dan seluruh umat sedang meratap di depan kemah TUHAN, mereka melihat seorang Israel membawa seorang perempuan Midian ke dalam kemahnya. Ketika Pinehas anak Imam Eleazar melihat hal itu, dia meninggalkan perkumpulan itu, mengambil sebuah tombak, dan mengejar kedua orang itu sampai ke dalam kemah. Lalu dengan satu kali tikaman Pinehas membunuh kedua-duanya, karena tombak menembus si laki-laki dan menusuk sampai ke perut perempuan itu. Sesudah itu wabah yang sedang menimpa umat Israel pun berhenti. ");
INSERT INTO ind_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ada dua puluh empat ribu orang yang mati karena wabah itu. ");
INSERT INTO ind_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Kemudian TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Pinehas sudah meredakan amarah-Ku terhadap umat-Ku. Dia turut merasakan kecemburuan-Ku dan tidak rela umat Israel menyembah siapa pun selain Aku. Kalau dia tidak bertindak lebih dahulu, Aku nyaris membinasakan mereka semua! ");
INSERT INTO ind_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Oleh karena itu, katakan kepadanya bahwa Aku membuat perjanjian damai dengannya. ");
INSERT INTO ind_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Aku menetapkan Pinehas dan keturunannya sebagai imam untuk selama-lamanya karena dia tidak rela Allahnya dikhianati dan dia sudah memulihkan hubungan bangsa Israel dengan-Ku.” ");
INSERT INTO ind_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Nama orang Israel yang dibunuh bersama dengan perempuan Midian itu adalah Zimri anak Salu. Salu adalah seorang kepala keluarga dari suku Simeon. ");
INSERT INTO ind_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Dan nama perempuan Midian yang dibunuh adalah Kozbi anak Zur. Zur adalah seorang kepala marga di bangsa Midian. ");
INSERT INTO ind_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Seranglah orang Midian dan tewaskanlah mereka, ");
INSERT INTO ind_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","karena mereka sudah menyerang kalian dengan kelicikan mereka sehingga kalian menyembah Baal Peor. Mereka juga menipu kalian melalui Kozbi, anak perempuan pemimpin Midian yang dibunuh ketika wabah sedang merajalela karena Israel menyembah para dewa Baal di gunung Peor.” ");
INSERT INTO ind_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Sesudah wabah itu berakhir, TUHAN berkata kepada Musa dan Eleazar, anak almarhum Imam Harun, ");
INSERT INTO ind_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Adakanlah sensus prajurit Israel, yaitu semua laki-laki yang berumur dua puluh tahun ke atas yang sanggup berperang.” ");
INSERT INTO ind_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Lalu di dataran Moab, di tepi sungai Yordan, berseberangan dengan kota Yeriko, Musa dan Imam Eleazar berkata kepada bangsa Israel, ");
INSERT INTO ind_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Sesuai perintah TUHAN kepada Musa, sensus ini menghitung semua laki-laki yang berumur dua puluh tahun ke atas.” Berikut ini adalah keturunan bangsa Israel yang keluar dari Mesir. ");
INSERT INTO ind_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","6","Marga-marga dari keturunan Ruben, anak sulung Israel, menurut nama anak-anaknya: marga Henokh marga Palu marga Hezron marga Karmi. ");
INSERT INTO ind_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Pasukan yang terdaftar dari keturunan Ruben ini berjumlah 43.730 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliab adalah salah satu keturunan dari Palu, ");
INSERT INTO ind_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","dan dia mempunyai anak-anak yang bernama Nemuel, Datan dan Abiram. Datan dan Abiram adalah dua orang pemimpin yang menentang Musa dan Harun dan memberontak terhadap TUHAN bersama dengan para pengikut Korah. ");
INSERT INTO ind_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","11","Waktu itu, tanah terbelah seolah-olah membuka mulutnya dan menelan mereka bersama-sama dengan Korah, seorang dari suku Lewi. Saat itu juga api membakar 250 orang pengikutnya. Kejadian ini menjadi peringatan bagi seluruh orang Israel. ");
INSERT INTO ind_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","13","Marga-marga dari keturunan Simeon, menurut nama anak-anaknya: marga Nemuel marga Yamin marga Yakhin marga Zerah marga Saul. ");
INSERT INTO ind_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Pasukan yang terdaftar dari keturunan Simeon ini berjumlah 22.200 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","17","Marga-marga dari keturunan Gad, menurut nama anak-anaknya: marga Zefon marga Hagi marga Syuni marga Ozni marga Eri marga Arod marga Areli. ");
INSERT INTO ind_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Pasukan yang terdaftar dari keturunan Gad ini berjumlah 40.500 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Marga-marga dari keturunan Yehuda, menurut nama anak-anaknya: marga Syela marga Peres marga Zerah. Keturunan dari marga Peres dibagi menjadi dua marga, yaitu marga Hezron dan marga Hamul, keduanya adalah anak laki-laki Peres. Yehuda dulu mempunyai dua anak yang bernama Er dan Onan, tetapi mereka mati di negeri Kanaan tanpa memiliki keturunan. ");
INSERT INTO ind_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Pasukan yang terdaftar dari keturunan Yehuda ini berjumlah 76.500 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","24","Marga-marga dari keturunan Isakar, menurut nama anak-anaknya: marga Tola marga Pua marga Yasub marga Simron. ");
INSERT INTO ind_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Pasukan yang terdaftar dari keturunan Isakar ini berjumlah 64.300 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Marga-marga dari keturunan Zebulon, menurut nama anak-anaknya: marga Sered marga Elon marga Yahleel. ");
INSERT INTO ind_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Pasukan yang terdaftar dari keturunan Zebulon ini berjumlah 60.500 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Berikut ini adalah marga-marga dari Manasye dan Efraim, kedua suku keturunan Yusuf. ");
INSERT INTO ind_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Dari keturunan Manasye: marga Makir (anak Manasye) marga Gilead (anak Makir) ");
INSERT INTO ind_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","32","Keturunan dari marga Gilead dibagi menjadi enam marga, menurut nama anak-anaknya: marga Iezer marga Helek marga Asriel marga Sekhem marga Semida marga Hefer. ");
INSERT INTO ind_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelafehad anak Hefer tidak punya anak laki-laki, tetapi dia punya lima anak perempuan. Nama anak-anak perempuannya adalah Mahla, Noa, Hogla, Milka dan Tirza. ");
INSERT INTO ind_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Pasukan yang terdaftar dari keturunan Manasye ini berjumlah 52.700 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","36","Marga-marga dari keturunan Efraim, menurut nama anak-anaknya: nama marga cabang Sutelah Bekher Sutelah Tahan Sutelah hanya mempunyai satu anak laki-laki, tetapi setelah beberapa waktu marganya disebut marga Eran dan bercabang. ");
INSERT INTO ind_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Pasukan yang terdaftar dari keturunan Efraim ini berjumlah 32.500 orang. Demikianlah marga-marga keturunan Yusuf dari Manasye dan Efraim. ");
INSERT INTO ind_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","39","Marga-marga dari keturunan Benyamin, menurut nama anak-anaknya: nama marga cabang Bela Ared Bela Naaman Asybel Ahiram Sefufam Hufam ");
INSERT INTO ind_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Keturunan dari marga Bela bercabang sesuai nama kedua anak laki-lakinya. ");
INSERT INTO ind_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Pasukan yang terdaftar dari marga-marga keturunan Benyamin ini berjumlah 45.600 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","Marga dari keturunan Dan, menurut nama anaknya: marga Suham. Pasukan yang terdaftar dari marga ini berjumlah 64.400 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Marga-marga dari keturunan Asyer, menurut nama anak-anaknya: nama marga cabang Yimna Yiswi Beria Heber Beria Malkiel ");
INSERT INTO ind_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Keturunan dari marga Beria dibagi menjadi dua marga, menurut nama anak-anaknya. ");
INSERT INTO ind_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asyer mempunyai seorang anak perempuan yang bernama Serah. ");
INSERT INTO ind_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Pasukan yang terdaftar dari marga Asyer ini berjumlah 53.400 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","49","Marga-marga dari keturunan Naftali, menurut nama anak-anaknya: marga Yahzeel marga Guni marga Yezer marga Syilem. ");
INSERT INTO ind_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Pasukan yang terdaftar dari keturunan Naftali ini berjumlah 45.400 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Jumlah keseluruhan pasukan Israel yang terdaftar adalah 601.730 orang. ");
INSERT INTO ind_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Lalu TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","56","“Nanti tanah yang Aku berikan kepada suku-suku Israel akan dibagi sesuai cara ini: Tanah warisan yang lebih luas akan dibagikan kepada suku yang jumlah pasukannya besar, dan tanah warisan yang lebih kecil kepada suku yang jumlah pasukannya kecil. Adakanlah pengundian diantara suku-suku besar untuk menentukan pembagian tanah warisan yang lebih luas, lalu mengadakan pengundian diantara suku-suku yang lebih kecil untuk menentukan pembagian tanah warisan yang cocok bagi mereka.” ");
INSERT INTO ind_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Marga-marga dari keturunan Lewi, menurut nama anak-anaknya: nama marga keterangan Gerson akhirnya disebut marga Libni (anak Gerson) Kehat cabang marga Hebron Kehat cabang Korah anak Izhar, cucu Kehat Merari yang akhirnya bercabang marga Merari dan marga Musi. ");
INSERT INTO ind_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Kehat mempunyai seorang anak laki-laki yang bernama Amram. ");
INSERT INTO ind_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram menikah dengan Yokebet, anak perempuan Lewi yang lahir di Mesir. Mereka mempunyai dua anak laki-laki, yaitu Harun dan Musa, dan seorang anak perempuan bernama Miryam. ");
INSERT INTO ind_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harun mempunyai empat anak laki-laki, yaitu Nadab, Abihu, Eleazar dan Itamar. ");
INSERT INTO ind_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Tetapi Nadab dan Abihu mati karena mereka mempersembahkan dupa dengan cara yang tidak sesuai dengan perintah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Semua laki-laki dari suku Lewi yang berumur satu bulan ke atas berjumlah 23.000 orang. Sensus suku Lewi diadakan terpisah dari suku-suku Israel lainnya karena mereka tidak menerima tanah warisan seperti yang lainnya. ");
INSERT INTO ind_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Demikianlah hasil sensus prajurit Israel yang diadakan oleh Musa dan Imam Eleazar di dataran Moab di tepi sungai Yordan, berseberangan dengan kota Yeriko. ");
INSERT INTO ind_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","65","Dari semua orang yang terdaftar oleh Musa dan Harun di gunung Sinai dalam sensus yang pertama, tidak ada satupun yang terdaftar ulang dalam sensus kedua kecuali Kaleb anak Yefune dan Yosua anak Nun. Hal ini terjadi karena TUHAN sudah mengatakan bahwa selain mereka, semua orang dewasa yang terdaftar di sensus pertama akan mati di padang belantara. ");
INSERT INTO ind_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Lalu mendekatlah kelima anak perempuan Zelafehad. Nama-nama mereka adalah Mahla, Noa, Hogla, Milka, dan Tirza. Garis keturunan mereka adalah Yusuf, Manasye, Makir, Gilead, Hefer, dan Zelafehad. ");
INSERT INTO ind_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Mereka menghadap Musa, Imam Eleazar, para pemimpin serta seluruh umat di depan kemah TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Mereka berkata, “Ayah kami sudah meninggal di padang belantara dan dia tidak mempunyai anak laki-laki. Ayah kami tidak ikut memberontak terhadap TUHAN bersama dengan pengikut-pengikut Korah, tetapi dia mati karena dosanya sendiri. ");
INSERT INTO ind_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Apakah hanya karena dia tidak punya anak laki-laki sebagai pewaris, namanya terhapus dari marganya? Mohon berikanlah kami tanah warisan bersama dengan saudara-saudara ayah kami.” ");
INSERT INTO ind_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Lalu Musa membawa perkara itu di hadapan TUHAN. ");
INSERT INTO ind_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Maka TUHAN menjawab Musa, ");
INSERT INTO ind_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Apa yang dikatakan anak perempuan Zelafehad itu benar. Berikanlah kepada mereka tanah warisan bersama dengan saudara-saudara ayah mereka. Tanah untuk Zelafehad harus diwariskan kepada mereka. ");
INSERT INTO ind_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Katakanlah kepada orang Israel, ‘Apabila seorang laki-laki meninggal dan dia tidak punya anak laki-laki, warisannya harus diberikan kepada anak-anak perempuannya. ");
INSERT INTO ind_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kalau dia juga tidak punya anak perempuan, berikanlah warisannya itu kepada saudaranya laki-laki. ");
INSERT INTO ind_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Jika dia tidak juga punya saudara laki-laki, berikanlah warisannya itu kepada saudara laki-laki ayahnya. ");
INSERT INTO ind_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Dan apabila ayahnya tidak punya saudara laki-laki, berikanlah warisannya itu kepada kerabat terdekatnya dalam kaumnya.’ Itulah perintah-Ku kepadamu dan hal ini harus menjadi peraturan yang berlaku turun temurun bagi orang Israel.” ");
INSERT INTO ind_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","TUHAN berkata kepada Musa, “Naiklah ke pegunungan Abarim ini, dan dari sana pandanglah negeri yang sudah Aku berikan kepada bangsa Israel. ");
INSERT INTO ind_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Sesudah kamu memandang negeri itu, kamu akan mati sama seperti kakakmu Harun dan mendapat tempat bersama nenek moyangmu yang sudah meninggal, ");
INSERT INTO ind_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","karena waktu bangsa Israel bersungut-sungut di padang belantara Zin, kalian berdua melawan perintah-Ku tentang air itu. Kalian tidak menghormati Aku sebagai Allah yang kudus di hadapan mereka.” (Peristiwa itu terjadi di mata air Meriba di Kades di padang belantara Zin.) ");
INSERT INTO ind_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Lalu Musa berkata kepada TUHAN, ");
INSERT INTO ind_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ya TUHAN, Engkau Allah atas segala makhluk hidup. Aku mohon kepada-Mu, tunjuklah seorang pemimpin untuk umat-Mu ini, ");
INSERT INTO ind_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","untuk memimpin mereka dalam perang, dan menjaga mereka supaya tidak menjadi seperti kawanan domba tanpa gembala.” ");
INSERT INTO ind_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","19","Maka berkatalah TUHAN kepada Musa, “Panggillah Yosua anak Nun. Dia mempunyai bakat memimpin. Lalu suruh dia berdiri di hadapan Imam Eleazar dan seluruh umat-Ku. Kemudian letakkan tanganmu pada kepalanya untuk melantiknya sebagai penggantimu yang memimpin atas umat-Ku. ");
INSERT INTO ind_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Alihkanlah kepadanya sebagian kewenangan yang ada padamu supaya seluruh umat Israel patuh kepadanya. ");
INSERT INTO ind_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kapan saja Yosua perlu mengambil suatu keputusan, dia akan minta Imam Eleazar menggunakan Urim untuk mengetahui keputusan-Ku. Begitulah cara Yosua dan seluruh bangsa Israel akan diarahkan sesuai dengan kehendak-Ku, sesudah kamu tidak ada lagi di dunia.” ");
INSERT INTO ind_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","23","Lalu, sesuai perintah TUHAN, Musa melantik Yosua. Dalam pertemuan seluruh umat dan disaksikan oleh Imam Eleazar, Musa meletakkan tangan di atas Yosua dan berdoa bagi dia sebagai penggantinya. ");
INSERT INTO ind_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","TUHAN berkata kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Sampaikanlah kepada umat Israel: Persembahan kalian merupakan makanan bagi-Ku dan asapnya harum bagi-Ku. Pastikan semua itu dipersembahkan pada waktu yang ditentukan. ");
INSERT INTO ind_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“Setiap hari, persembahkanlah dua ekor anak domba jantan yang berumur satu tahun sebagai kurban yang dibakar habis. Setiap domba itu harus yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Satu ekor dipersembahkan pada pagi hari dan satu ekor dipersembahkan pada waktu matahari terbenam. ");
INSERT INTO ind_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","8","Baik itu kurban waktu pagi maupun kurban waktu matahari terbenam, setiap kurban anak domba akan disertai dengan persembahan gandum-ganduman berupa 3 liter tepung terbaik dicampur dengan 1 liter minyak zaitun. Berilah juga persembahan curahan satu liter air anggur. Kurban bakaran seperti ini pertama kali dipersembahkan kepada-Ku di gunung Sinai dan akan terus dipersembahkan setiap hari. Bau harum persembahan ini akan menyenangkan Aku.” ");
INSERT INTO ind_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","10","“Setiap hari Sabat, selain kurban dan persembahan curahan harian, kalian juga akan mempersembahkan dua ekor anak domba jantan yang berumur satu tahun sebagai kurban yang dibakar habis. Setiap domba itu harus yang tidak bercacat, dan setiap kurban itu akan disertai dengan persembahan gandum-ganduman yang berupa 6 liter tepung terbaik yang dicampur dengan minyak zaitun dan persembahan curahannya.” ");
INSERT INTO ind_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Setiap awal bulan, persembahkanlah semua hewan ini sebagai kurban yang dibakar habis: dua ekor sapi jantan muda, satu ekor domba jantan, dan tujuh ekor anak domba jantan berumur satu tahun. Semua hewan itu harus yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","14","Setiap kurban itu akan disertai dengan persembahan curahan dan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun. Inilah ketentuan banyaknya tepung dan air anggur yang akan dipersembahkan untuk setiap macam hewan: kurban tepung curahan sapi jantan muda 9 liter 2 liter domba jantan 6 liter 1,3 liter anak domba jantan 3 liter 1 liter Kurban-kurban bakaran ini akan dipersembahkan setiap awal bulan. Bau harum kurban-kurban ini akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","“Pada pagi hari setiap awal bulan, sesudah kalian mempersembahkan kurban-kurban bakaran harian dengan persembahan curahannya, persembahkanlah seekor kambing jantan kepada-Ku sebagai kurban penghapus dosa.” ");
INSERT INTO ind_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Pada tanggal empat belas bulan pertama, kalian akan merayakan hari Paskah bagi-Ku. Kalian merayakannya untuk mengenang malam saat Aku menebus bangsa Israel dari perbudakan di Mesir. ");
INSERT INTO ind_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Lalu, mulai hari berikutnya, tanggal kelima belas, Perayaan Roti Tidak Beragi dimulai. Selama tujuh hari kalian tidak boleh makan roti yang beragi. ");
INSERT INTO ind_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","“Pada hari pertama perayaan itu, kalian harus berkumpul untuk beribadah bersama dan tidak boleh melakukan perkerjaan sehari-hari. ");
INSERT INTO ind_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","24","Selama tujuh hari itu, setiap hari persembahkanlah semua hewan ini sebagai kurban yang dibakar habis: dua ekor sapi jantan muda, satu ekor domba jantan, dan tujuh ekor anak domba yang berumur satu tahun. Semuanya harus yang tidak bercacat. Bau harum kurban-kurban ini menyenangkan hati-Ku. Setiap kurban tersebut akan disertai dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun. Inilah banyaknya tepung yang akan dipersembahkan untuk setiap macam hewan: kurban tepung sapi jantan muda 9 liter domba jantan 6 liter anak domba jantan 3 liter Kalian juga akan mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa, untuk memulihkan hubungan kalian dengan-Ku. Semua ini akan dipersembahkan setiap pagi selama tujuh hari itu, sesudah kalian mempersembahkan kurban bakaran harian dengan persembahan curahannya. ");
INSERT INTO ind_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Pada hari ketujuh perayaan itu kalian harus kembali berkumpul untuk beribadah bersama dan tidak boleh melakukan pekerjaan sehari-hari.” ");
INSERT INTO ind_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Pada Hari Raya Panen Pertama, waktu kalian mempersembahkan kepada-Ku persembahan gandum-ganduman dari hasil panen jelai pertama, kalian akan berkumpul untuk beribadah bersama. Tidak boleh kalian melakukan pekerjaan sehari-hari pada hari itu. ");
INSERT INTO ind_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Persembahkanlah kepada-Ku semua hewan ini sebagai persembahan yang dibakar habis: dua ekor sapi jantan muda, satu ekor domba jantan, dan tujuh ekor anak domba jantan berumur satu tahun. ");
INSERT INTO ind_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Setiap kurban harus disertai dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun. Inilah banyaknya tepung yang akan dipersembahkan untuk setiap macam hewan: ");
INSERT INTO ind_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","kurban tepung Sapi jantan muda 9 liter Domba jantan 6 liter Anak domba jantan 3 liter ");
INSERT INTO ind_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","“Kalian juga harus mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa, untuk memulihkan hubungan kalian dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Pastikanlah bahwa semua hewan yang dikurbankan itu tidak bercacat. Persembahkanlah kurban-kurban ini beserta persembahan curahannya yang ditentukan. Semua ini akan dipersembahkan pada pagi hari sesudah kalian mempersembahkan kurban bakaran harian dengan persembahan gandum-gandumannya yang ditentukan.” ");
INSERT INTO ind_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Tanggal satu bulan ketujuh adalah Hari Raya Terompet. Pada hari itu kalian tidak boleh melakukan pekerjaan sehari-hari. Berkumpullah untuk beribadah bersama dan bunyikanlah terompet berulang kali. ");
INSERT INTO ind_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Persembahkanlah hewan-hewan ini sebagai kurban yang dibakar habis: seekor sapi jantan muda, seekor domba jantan, dan tujuh ekor anak domba jantan yang berumur satu tahun Semuanya harus yang tidak bercacat. Bau harum kurban-kurban itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","4","Setiap ekor hewan kurban harus disertai dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun. Inilah jumlah tepung yang harus dipersembahkan untuk setiap macam hewan: kurban tepung sapi jantan muda 9 liter domba jantan 6 liter anak domba jantan 3 liter ");
INSERT INTO ind_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kalian juga harus mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa untuk memulihkan hubungan kalian dengan-Ku. ");
INSERT INTO ind_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Bau harum semua kurban ini akan menyenangkan Aku. Semua kurban untuk hari raya ini adalah tambahan selain kurban bakaran harian dan bulanan. Setiap kurban tetap harus dilakukan dengan persembahan curahan dan gandum-gandumannya yang ditentukan.” ");
INSERT INTO ind_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Tanggal sepuluh bulan ketujuh adalah Hari Raya Pendamaian. Pada hari itu, kalian harus berpuasa dan tidak boleh melakukan pekerjaan sehari-hari. Kalian akan berkumpul untuk beribadah bersama. ");
INSERT INTO ind_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Persembahkanlah semua hewan ini sebagai kurban yang dibakar habis: seekor sapi jantan muda, seekor domba jantan, dan tujuh ekor anak domba jantan berumur satu tahun. Bau harum kurban-kurban itu akan menyenangkan Aku. Setiap ekor hewan itu harus yang tidak bercacat. ");
INSERT INTO ind_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","10","Setiap ekor hewan kurban harus disertai dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun. Inilah banyaknya tepung yang harus dipersembahkan untuk setiap macam hewan: Kurban Tepung sapi jantan muda 9 liter domba jantan 6 liter anak domba jantan 3 liter ");
INSERT INTO ind_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Kalian juga harus mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa. Semua kurban untuk hari raya ini terpisah dari kurban upacara pendamaian dan kurban bakaran harian beserta persembahan curahan dan gandum-gandumannya yang ditentukan.” ");
INSERT INTO ind_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Perayaan Pondok-pondok jatuh pada tanggal lima belas bulan ketujuh. Kalian akan berkumpul untuk ibadah bersama dan tidak boleh melakukan pekerjaan sehari-hari. Kalian harus mengadakan perayaan bagi-Ku selama tujuh hari, dimulai pada hari itu. ");
INSERT INTO ind_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","34","Inilah jumlah hewan yang akan dipersembahkan sebagai kurban yang dibakar habis selama tujuh hari perayaan itu: hari sapi jantan muda domba jantan anak domba jantan pertama 13 2 14 kedua 12 2 14 ketiga 11 2 14 keempat 10 2 14 kelima 9 2 14 keenam 8 2 14 ketujuh 7 2 14 Semuanya harus hewan yang tidak bercacat. Bau harum kurban-kurban itu akan menyenangkan Aku. Setiap ekor hewan kurban itu harus disertai dengan persembahan gandum-ganduman berupa tepung terbaik yang dicampur dengan minyak zaitun dan persembahan curahannya. Inilah banyaknya tepung yang akan dipersembahkan untuk setiap macam hewan: kurban tepung sapi jantan muda 9 liter domba jantan 6 liter anak domba jantan 3 liter Setiap hari selama tujuh hari itu, kalian juga akan mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa. Semua itu akan dipersembahkan sesudah kalian mempersembahkan kurban bakaran harian dengan persembahan curahan dan gandum-ganduman yang sesuai ketentuannya. ");
INSERT INTO ind_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Pada hari kedelapan, kalian akan kembali berkumpul untuk beribadah bersama dan tidak boleh melakukan pekerjaan sehari-hari. ");
INSERT INTO ind_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Pada hari itu, persembahkanlah semua hewan itu sebagai kurban yang dibakar habis: seekor sapi jantan muda, seekor domba jantan, dan tujuh ekor anak domba berumur satu tahun. Setiap hewan itu harus yang tidak bercacat. Bau harum kurban-kurban itu akan menyenangkan Aku. ");
INSERT INTO ind_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Setiap kurban itu akan disertai dengan persembahan curahan dan gandum-ganduman yang sesuai yang ditentukan. ");
INSERT INTO ind_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Pada hari itu kalian juga akan mempersembahkan seekor kambing jantan sebagai kurban penghapus dosa. Semua ini akan dipersembahkan pada pagi hari sesudah kalian mempersembahkan kurban bakaran harian dengan persembahan curahannya yang ditentukan. ");
INSERT INTO ind_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Itulah kurban-kurban yang akan kalian persembahkan kepada-Ku pada hari-hari raya. Semua persembahan itu terpisah dari kurban lainnya, seperti kurban untuk memenuhi janji, kurban sukarela, kurban yang dibakar habis, kurban tanda damai, dan persembahan curahan dan gandum-ganduman.” ");
INSERT INTO ind_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Lalu Musa menyampaikan semua ini kepada orang Israel sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa mengumpulkan para pemimpin suku-suku Israel lalu berkata kepada mereka, “Inilah yang diperintahkan TUHAN: ");
INSERT INTO ind_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Apabila seorang laki-laki berjanji dengan sumpah demi Aku, baik untuk melakukan sesuatu atau berpantang melakukan sesuatu, maka dia harus melakukan sesuai janjinya itu dan tidak boleh mengingkarinya. ");
INSERT INTO ind_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Apabila seorang gadis yang masih tinggal di rumah ayahnya berjanji dengan bersumpah demi Aku, baik untuk melakukan sesuatu atau berpantang melakukan sesuatu, ");
INSERT INTO ind_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","kalau ayahnya diam saja pada hari dia mendengar tentang sumpahnya itu, maka sumpahnya itu tetap berlaku dan gadis itu harus memenuhi janjinya itu. ");
INSERT INTO ind_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Tetapi jika ayahnya melarangnya pada hari dia mendengar tentang sumpah itu, maka sumpahnya itu tidak berlaku dan janjinya tidak perlu dipenuhi. Aku akan mengampuni gadis itu karena ayahnya melarangnya untuk memenuhi sumpahnya. ");
INSERT INTO ind_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Andaikan seorang perempuan secara gegabah mengikat diri sendiri dengan berjanji dan bersumpah demi Aku dan kemudian menikah, ");
INSERT INTO ind_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","kalau suaminya tidak melarangnya pada hari dia mendengar tentang sumpah itu, maka sumpah itu tetap berlaku dan perempuan itu harus memenuhi janjinya itu. ");
INSERT INTO ind_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Tetapi kalau suaminya melarangnya pada hari dia mendengar tentang sumpah itu, maka sumpahnya menjadi tidak berlaku dan janjinya tidak perlu dipenuhi. Aku akan mengampuni perempuan itu. ");
INSERT INTO ind_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Apabila seorang janda atau seorang perempuan yang sudah bercerai mengikat diri sendiri dengan berjanji dan bersumpah demi Aku, dia harus memenuhi janjinya itu. ");
INSERT INTO ind_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Andaikan seorang perempuan yang sudah bersuami berjanji dengan bersumpah demi Aku, untuk melakukan sesuatu atau pantang melakukan sesuatu, ");
INSERT INTO ind_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","kalau suaminya tidak melarangnya pada hari dia mendengar tentang sumpah itu, maka sumpah itu berlaku dan perempuan itu harus memenuhi janjinya itu. ");
INSERT INTO ind_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Tetapi kalau suaminya melarangnya pada hari dia mendengar tentang sumpah itu, maka sumpah itu menjadi tidak berlaku dan janjinya tidak perlu dipenuhi. Suaminya membatalkan sumpah itu dan Aku akan mengampuni perempuan itu. ");
INSERT INTO ind_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Seorang suami berhak menyetujui atau membatalkan semua janji dengan sumpah apa pun yang diucapkan oleh istrinya, termasuk janji untuk berpantang melakukan sesuatu. ");
INSERT INTO ind_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Tetapi kalau suami tidak melarangnya pada hari dia mendengar tentang sumpah itu, berarti suami itu sudah menyetujui sumpah istrinya. ");
INSERT INTO ind_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kalau di kemudian hari suami itu melarang istrinya memenuhi sumpah itu, maka si suami akan menanggung akibat pelanggaran sumpah istrinya.” ");
INSERT INTO ind_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Itulah aturan-aturan yang TUHAN berikan kepada Musa tentang peran seorang suami terhadap sumpah yang dibuat oleh istrinya, dan juga peran seorang ayah terhadap sumpah yang dibuat oleh anak perempuannya yang belum menikah. ");
INSERT INTO ind_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","TUHAN berbicara kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Kamu harus membalas orang Midian karena mereka menjerumuskan bangsa Israel ke dalam perzinaan. Sesudah itu, kamu akan mati dan mendapat tempat bersama nenek moyangmu yang sudah meninggal.” ");
INSERT INTO ind_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Lalu Musa berkata kepada orang Israel, “Mari kita bersiap-siap untuk perang! Pilihlah orang yang akan masuk dalam pasukan kita. Kita akan menyerang Midian untuk melaksanakan pembalasan bagi TUHAN karena mereka menjerumuskan bangsa kita ke dalam perzinaan. ");
INSERT INTO ind_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Setiap suku Israel akan mempersiapkan 1.000 orang untuk maju berperang.” ");
INSERT INTO ind_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Maka setiap suku mempersiapkan 1.000 orang, sehingga ada 12.000 orang bersenjata yang siap berperang. ");
INSERT INTO ind_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa memerintahkan mereka pergi berperang di bawah pimpinan Pinehas, anak Imam Eleazar. Pinehas membawa beberapa benda suci dari kemah TUHAN dan terompet-terompet untuk memberi aba-aba perang. ");
INSERT INTO ind_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Kemudian mereka menyerang Midian, seperti yang TUHAN perintahkan kepada Musa, dan membunuh semua laki-laki Midian, ");
INSERT INTO ind_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","termasuk kelima raja Midian, yaitu Ewi, Rekem, Zur, Hur, dan Reba. Mereka juga membunuh Bileam anak Beor. ");
INSERT INTO ind_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Kemudian pasukan Israel menawan perempuan-perempuan dan anak-anak orang Midian, serta merampas semua ternak dan seluruh kekayaan Midian. ");
INSERT INTO ind_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Semua kota-kota dan perkemahan orang Midian dibakar. ");
INSERT INTO ind_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Sesudah pasukan Israel mengumpulkan semua rampasan, ternak, dan tawanan perang, ");
INSERT INTO ind_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","mereka membawa semuanya itu kepada Eleazar, Musa, dan seluruh umat Israel di perkemahan mereka di dataran Moab, di tepi sungai Yordan, berseberangan dengan kota Yeriko. ");
INSERT INTO ind_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Maka Musa, Eleazar, dan semua pemimpin umat Israel menyambut kedatangan mereka. ");
INSERT INTO ind_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Tetapi Musa marah kepada para perwira dan komandan pasukan Israel. ");
INSERT INTO ind_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Dia berkata kepada mereka, “Kenapa kalian membiarkan semua perempuan itu hidup? ");
INSERT INTO ind_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Perempuan-perempuan inilah yang memikat orang Israel atas nasihat Bileam sehingga mereka berkhianat kepada TUHAN di Peor. Karena itu umat TUHAN ditimpa wabah. ");
INSERT INTO ind_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Jadi, kalian harus membunuh semua anak laki-laki orang Midian dan juga semua perempuan yang sudah tidak perawan. ");
INSERT INTO ind_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Tetapi biarkanlah gadis yang masih perawan tetap hidup untuk menjadi istri atau budakmu. ");
INSERT INTO ind_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Lalu kalian harus berkemah di luar perkemahan Israel selama tujuh hari. Pada hari yang ketiga dan ketujuh, semua orang di antara kalian yang sudah membunuh atau menyentuh mayat, dan juga semua gadis tawanan kalian, harus menyucikan diri. ");
INSERT INTO ind_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Semua pakaian dan barang-barang yang terbuat dari kulit binatang, bulu kambing, dan kayu, harus disucikan juga.” ");
INSERT INTO ind_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kemudian Imam Eleazar berkata kepada seluruh tentara yang kembali dari pertempuran itu, “Inilah perintah yang TUHAN berikan melalui Musa: ");
INSERT INTO ind_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Kalian harus menyucikan semua barang yang tahan api, seperti emas, perak, perunggu, besi, timah putih, dan timah hitam, dengan menaruhnya di atas api lalu memercikinya dengan air penyucian. Sedangkan semua barang yang tidak tahan api harus disucikan dengan air penyucian saja. ");
INSERT INTO ind_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Pada hari ketujuh, kalian harus mencuci pakaian kalian. Sesudah itu kalian tidak lagi najis dan bisa kembali ke perkemahan. ” ");
INSERT INTO ind_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Berkatalah TUHAN kepada Musa, ");
INSERT INTO ind_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Kamu, Eleazar, dan para pemimpin marga dalam setiap suku harus menghitung hasil rampasan dari pertempuran, termasuk para tawanan dan ternak. ");
INSERT INTO ind_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Bagilah hasil rampasan itu menjadi dua. Setengah diberikan kepada pasukan yang pergi berperang, dan yang setengah lagi diberikan kepada umat Israel yang lain. ");
INSERT INTO ind_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","29","Dari setengah hasil rampasan itu yang adalah milik pasukan yang pergi berperang, berikanlah persembahan khusus kepada-Ku. Persembahan khusus itu adalah satu dari setiap lima ratus tawanan. Begitu juga untuk keledai, sapi, kambing, dan domba. Seekor hewan diberikan dari setiap lima ratus hewan sejenisnya. Semua persembahan khusus itu diberikan kepada Eleazar, yang akan membagikannya kepada para imam. ");
INSERT INTO ind_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Persembahan khusus juga diambil dari hasil rampasan milik umat Israel, tetapi itu diberikan kepada suku Lewi, karena merekalah yang mengurus kemah-Ku. Mereka terima dua persen (yaitu satu dari setiap lima puluh) dari tawanan, kambing, sapi, domba, dan ternak lainnya.” ");
INSERT INTO ind_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Maka Eleazar dan Musa melakukan sesuai perintah TUHAN kepada Musa. ");
INSERT INTO ind_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Adapun jumlah hasil rampasan dari pertempuran itu adalah: 675.000 ekor kambing domba 72.000 ekor sapi 61.000 ekor keledai 32.000 gadis perawan. ");
INSERT INTO ind_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","Pasukan yang pergi berperang menerima setengahnya, yaitu: 337.500 ekor kambing domba 36.000 ekor sapi 30.500 ekor keledai 16.000 gadis perawan. Dari jumlah itu, yang diserahkan kepada para imam adalah: 675 ekor kambing domba 72 ekor sapi 61 ekor keledai 32 gadis perawan. ");
INSERT INTO ind_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa menyerahkan bagian untuk TUHAN kepada Eleazar, sesuai perintah TUHAN kepadanya. ");
INSERT INTO ind_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Dari hasil rampasan itu, setengahnya lagi adalah untuk umat Israel. Musa memisahkan bagian itu dari setengahnya yang menjadi milik pasukan yang pergi berperang. ");
INSERT INTO ind_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Bagian untuk umat Israel adalah: 337.500 ekor kambing domba ");
INSERT INTO ind_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 ekor sapi ");
INSERT INTO ind_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 ekor keledai ");
INSERT INTO ind_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16.000 gadis perawan. ");
INSERT INTO ind_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Sesuai perintah TUHAN tersebut, Musa mengambil dua persen (yaitu satu dari setiap lima puluh) dari tawanan dan ternak, dan menyerahkannya kepada suku Lewi. ");
INSERT INTO ind_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kemudian para perwira dan komandan pasukan Israel datang menghadap Musa. ");
INSERT INTO ind_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Mereka berkata, “Kami sudah menghitung setiap orang yang pergi berperang di bawah pimpinan kami, dan kami mendapati bahwa tidak ada satu pun yang mati terbunuh. ");
INSERT INTO ind_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Karena itu, kami membawa perhiasan emas berupa gelang, cincin, anting, dan kalung dari hasil rampasan yang kami ambil masing-masing. Semua ini kami persembahkan kepada TUHAN sebagai ucapan terima kasih karena Dia melindungi kami.” ");
INSERT INTO ind_vpl VALUES ("NU31_51","