﻿USE sofia;
DROP TABLE IF EXISTS sofia.inb_vpl;
CREATE TABLE inb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES inb_vpl WRITE;
INSERT INTO inb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesu­cristopa ñugpa­manda achala taita­kuna, kasa­sik suti kar­ka­kuna. Pai Jesús, atun taita David i Abra­hampa iawar­sik karka. ");
INSERT INTO inb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abra­ham, Isaak suti wawata iukarka. Isaakka, Jakob suti wawata iukarka. Jakobka, Judá suti i sug waugkindi­kuna­ta­pas iukarka. ");
INSERT INTO inb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaka, Fares i Zara suti wawa­kunata iukarka. Pai­kunapa mamaka, Tamar suti karka. Fareska, Esrom suti wawata; Esromka, Aram suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramka, Aminadab suti wawata; Aminadabka, Naasón suti wawata; Naasonka, Salmón suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonka, Booz suti wawata iukarka. Boozpa mamaka, Rahab suti karka. Boozka, Obed suti wawata iukarka. Obedpa mamaka, Rut suti karka. Obedka, Isaí suti wawata iukarka. ");
INSERT INTO inb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaika, atun mandag Davidta iukarka. Davidka, Salomón suti wawata iukarka. Paipa mamaka, Uriaspa warmi kaska karka. ");
INSERT INTO inb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonka, Roboam suti wawata; Roboamka, Abías suti wawata; Abiaska, Asa suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaka, Josafat suti wawata; Josafatka, Joram suti wawata; Joramka, Uzías suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziaska, Jotam suti wawata; Jotamka, Akaz suti wawata; Akazka, Ezekías suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiaska, Manasés suti wawata; Manaseska, Amón suti wawata; Amonka, Josías suti wawata iukarka. ");
INSERT INTO inb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiaska, Jekonías suti i sug waugkindi­kuna­ta­pas iukarka. Pai­kuna kaugsa­na­kun­kama, Israel alpa­manda runa­kuna Babi­lo­nia suti alpama prisu apai tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chi alpama apai tukus­kapi, Jekoniaska Salatiel suti wawata iukarka. Salatielka, Zorobabel suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelka, Abiud suti wawata; Abiudka, Eliakim suti wawata; Eliakimka, Azor suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorka, Sadok suti wawata; Sadokka, Akim suti wawata; Akimka, Eliud suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudka, Eleazar suti wawata; Eleazarka, Matán suti wawata; Matanka, Jakob suti wawata; ");
INSERT INTO inb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobka, José suti wawata iukarka. Chi Joseka, Mariapa kusa­mi tukug­samurka. Mariaka, Mesías u Cristo suti Jesuspa mama­mi tukurka. ");
INSERT INTO inb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chasaka, ñugpa taita Abra­ham­manda­ta atun mandag David­kama, chunga chusku achala taita­kuna­sik karka. David­manda­ta Israel­manda runa­kuna Babi­lo­nia alpama prisu apai tukun­kama, chunga chusku achala taita­kuna­sik tukug­samurka. Chi alpama apai tukuska­ura­manda­ta Cristo tiag­samun­kama, ikuti chunga chusku achala taita­kuna­sik tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kasami tukug­samurka, Jesu­cristo tiag­samun­gapa ka­ura. Paipa mama María, Josewa kasa­ran­gapa karka. Pai­kuna manara sug­lla­pi kaug­sagpi, Mariaka Santu Ispi­ri­tu­mandami wigsi­ta­wa ungug ña karka. ");
INSERT INTO inb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Paipa kusa tukunga Joseka kawarka, paipa warmi ña wam­bra­wa ungug kagta. Pai, alli runa kaspa, mana munarka, sug­kunapa ñawipi pinga­ia­chin­gapa. Nispa iuia­rirka, pai­manda pakalla sitaspa anchu­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chasa iuia­kun­kama, atun Taita Diuspa sug anjilka, Joseta muskui ukupi kawa­rispa, nirka: —Davidpa wawa­kunapa wawa José, mana mancha­ri­kui. Kamba warmi tukunga Mariata kamba wasima kaiai. Paika, Santu Ispi­ri­tu­mandami ungug ka. ");
INSERT INTO inb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kari wam­brami iukan­gapa ka. Paitaka suti­chinkangimi Jesús. Paimi, paipa alpa­manda kag­kunata panda­ris­ka­kunata pasin­siaspa, kispi­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chasami atun Taita Dius pai­pa Ispi­ri­tu­wa rimagwa ñug­pata willas­ka­sina tukug­samurka. Kasa­mi ñug­pa­manda­ta willa­raiarka: ");
INSERT INTO inb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Uiai­chi. Mana kari rigsiska sipas, ungu­rispa, sug kari wam­brami iukag­samun­gapa ka. Paita Emanuelmi suti­chin­gapa kan­kuna. (Emanuel ni­raianmi “Dius nukan­chiwa”.) ");
INSERT INTO inb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José, ña rigcha­rispaka, atun Taita Diuspa anjil imasa nis­ka­sina rurarka. Mariata paipa wasima warmi­ta­sina kaiarka. ");
INSERT INTO inb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Chasa kaiaspa­pas, mana sug­lla­pi tukur­ka­kuna, willaska kari wam­bra tiag­samun­kama. Ña tiag­samu­ura, paita Jesús suti­chirka. ");
INSERT INTO inb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judea alpa­manda Belén pui­blu­pi­mi Jesús tiag­samurka. Chi alpapi kaugsa­nakus­kata mandag, Herodes suti karka. Chi­ura­kuna magu suti istri­lla­kunata iachai­kug taita­kunaka, indi llugsi­diru­nig­manda Jeru­salén pui­bluma chaiag­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chipika tapu­na­kurka: —Judiu­kunapa atun mandag ña tiag­samuska, ¿maipitak ka? Istrilla pai tiag­samuska kawa­chig­ta­mi indi llugsi­dirupi kawarkan­chi. Chi­mandami samurkan­chi, paita kungu­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Chasa uiaspa, atun mandag Herodes i Jeru­salenpi tukui kaug­sa­na­kug iapa mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodeska, tukui iaia sasir­duti­kunata i Moisés ima nis­kata iacha­chig taita­kunata kaiaspa, tapur­ka­kunata: —Cristo, ¿maipitak tiag­samun­gapa willa­raiá? ");
INSERT INTO inb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chi­ura ainir­ka­kuna: —Judá alpa­manda Belén pui­blu­pi­mi willa­raiá. Kasa­mi Santu Ispi­ri­tu­wa ñug­pa­manda rimag nirka: ");
INSERT INTO inb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Kam Belén, Judá alpa­manda sug pui­blu­kuna­manda mas uchulla mana kangichu. Kam­bag­mandami sug atun mandag llugsin­gapa ka. Paika, nuka­pa Israel alpa­manda tukui runa­kunata kawaspa ñug­pagmi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chasa uianga­lla­wa Herodeska, pakalla magu­kunata kaiaspa, alli­lla tapu­chirka: —¿Ima­ura­mandatak chi istrilla llugsis­kata kawarkan­gi­chi?—. ");
INSERT INTO inb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tukui tapu­chispaka, nirka— Belenma rii­chi. Chipika, chi wawa­manda alli­lla tapun­gi­chi. Paita tarispaka, willa­wag­samun­gi­chi, nuka­pas rispa, paita kungu­rig­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chasa uiaspa, chi magu­kunaka chi­manda llugsir­ka­kuna. Chi­ura chi istrilla ñug­pa kawas­kaka, ikuti kawa­rispa, ñug­parka. Belén pui­bluma chaiag­rispa, chi wawa kas­kapi saia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Istri­lla­ta kawaspaka, magu­kuna iapa suma iuia­chii­wa tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chi wasi ukuma iaikug­rispaka, wawata mama Maria­wanta tarig­rir­ka­kuna. Kungu­rispaka, wawata muchar­ka­kuna. Ima apa­mus­kata paskaspaka, paita karar­ka­kuna: kuri, suma asna insinsu, mira kupal. ");
INSERT INTO inb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chi­ura­manda, magu­kunata muskui ukupi willai tukur­ka­kuna, Hero­des­pagma mana kutin­gapa. Chi­manda, pai kikin­kuna­pagma sug ñambita kutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Magu­kuna ña riska­ura­manda, atun Taita Diuspa anjilka, muskui ukupi kawa­rispa, Joseta kasa­mi nirka: —Atarii. Wawata mamandi­wan­ta, Ejipto suti alpama miti­kui­chi. Chi alpapi chisiag­rii­chi, nuka ikuti kamta willan­kama. Hero­desmi wawata wañu­chin­gapa maska­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Chi tutalla Joseka, atarispa, wawata mamandi­wanta pusaspa, Ejip­toma miti­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chi alpapika kaug­sag­rir­ka­kuna, Hero­des wañun­kama. Chasami atun Taita Dius, paipa Ispi­ri­tu­wa rimagwa ñug­pata willas­ka­sina tukug­samurka. Kasa­mi ñug­pa­manda­ta willa­raiarka: “Ejipto alpa­mandami nuka­pa wam­brata kaiarkani”. ");
INSERT INTO inb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodeska iuia­rig­samurka: “Nuka imasa nis­ka­sina, magu­kuna mana willa­wag­samur­ka­kuna”. Chi­wanka, iapa rabia­wa tukug­samurka. Nispaka, sul­da­du­kunata Belén pui­bluma chi suiu kaugsa­nakuska­pagma kacharka, tukui manara iskai wata­iug kari wam­bra­kunata wañu­chin­gapa. Istri­lla ima­ura kawa­ris­kata magu­kunata alli­lla tapu­chis­ka­wa iuia­rispasi chasa kacharka. ");
INSERT INTO inb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sutipa­mi Jeremías suti Santu Ispi­ri­tu­wa rimag ñug­pata willas­ka­sina tukug­samurka. Kasa­mi ñug­pa­manda­ta willa­raiarka: ");
INSERT INTO inb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá suti pui­blupi, iapa lla­kii wakai­kuna­mi uia­ri­ku. Chika, Rakel suti mama­mi paipa wawa­kuna­manda waka­ku. Mana mas paipa wawa­kuna kawa­rig­samun­gapa kag­mandami ñi pi mana pudin­kuna, paipa llakiita anchu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ña Herodes wañuska­ura­manda, atun Taita Diuspa anjilka, Ejipto alpama rispa, ikuti Joseta muskui ukupi kawa­rig­rirka, ");
INSERT INTO inb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kasa nispa: —Atarii. Wawata mamandi­wan­ta pusaspa, Israel alpama kutii. Wawata wañu­chin­gapa munag­kuna, ñami wañur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Chasa uiaspa José, atarispa, wawata mamandi­wanta pusaspa, Israel alpama samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Chaiag­samuspaka, iachar­ka­kuna, Arkelao suti Herodespa wam­bra, Judea alpa­lla­pita mandag kagta. Chasa iachaspaka, mancha­rirka chi alpapi kaug­sag­rin­gapa. Nispa, muskui ukupi paita willai tukuspa, Galilea suti alpama rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chima chaiag­rispaka, Nazaret suti pui­blupi kaug­sai kalla­rir­ka­kuna. Chasami Santu Ispi­ri­tu­wa ñug­pata willa­raias­ka­sina tukug­samurka. Kasa­mi willa­raiarka: “Paika, naza­reno sutimi kan­gapa ka”. ");
INSERT INTO inb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chi puncha­kuna Juan Bau­tis­ta, Judea­manda chusa sitaska alpapi kawa­rig­samurka, ");
INSERT INTO inb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kasa nispa: —Suma luar­manda mandai, ñami chaia­mun­gapa ka. Panda­rii­kunata sakispa, Taita Diuswa tukug­samui­chi. ");
INSERT INTO inb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pai­mandami Santu Ispi­ri­tu­wa rimag Isaías suti, kasa willaska karka: Chusa sitaska alpapi, sug runa kapa­rispa­mi puri­ku, kasa nispa: “Imasami ñambi alli­chin­chi: chasa­lla­ta alli iuiai­kunata apii­chi, atun Taita Diusta chaskin­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanka, kamello suti animalpa agchata awaska katanga chura­riskami karka. Karata siñi­dur­sina ruraspa chumbi­lliskami karka. Lan­gos­ta suti cha­pu­lin­sina i sachuku­manda abijun­kunapa dusi miski­lla­mi mikuspa kaug­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jeru­salén pui­blu­nig­manda, Judea suiu alpa­manda i Jordán iaku suiu ladu­manda, tukui­nig­manda runa­kuna pai­pagma chaiai kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Paika, Jordán iakupi mai­kan panda­ris­ka­kuna­manda willa­ri­na­kus­kata baug­ti­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Achka fari­seo i sadu­seo suti tai­ta­kuna­pas, Juan­pagma chaiag­rir­ka­kuna baug­ti­sa­rin­gapa. Chi­kunata kawaspaka, paika nirka: —Mana alli runa­kuna, kulibra­sina­mi kan­gi­chi. ¿Pitak kam­kunata willag­rirka: “Taita Dius iapa rabia­rispa llakii puncha, ñami chaia­mu­ku. Miti­kui­chi, kispi­riska kan­gapa”? ");
INSERT INTO inb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tukui panda­rii­kunata sakispa, alli­lla rurai­chi. ");
INSERT INTO inb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mana iuia­rispa kai­chi: “Ñug­pa­manda taita Abra­hampa iawarmi kan­chi”. Niiki­chitami: Taita Dius munag­pika, kai rumi­kuna­pas pudin­kunami, Abra­hampa wam­bra­kuna tukug­samun­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ñami tukui­manda justi­sian­gapa ka; imasa­mi sacha­kunata acha­wa urma­chin­gapa kawa­ku: chasa. Tukui sacha chusa u mana mikunga­sina muiu iukas­ka­kunata angu­wanta urma­chispa, nina­pi­mi churan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Kasapas. Kam­kuna alli­lla iuia­rispa panda­rii­kunata sakigpika, nuka iaku­wa­mi baug­ti­sai­ki­chita. Ikuti sug nuka­manda mas iachaka, nuka­pa katimi samun­gapa ka. Paita, nuka mana pudi­nichu, kungu­rispa, paipa chaki­kunapi chura­raias­kata surkunga­pag­lla­pas. Paika, Santu Ispi­ri­tu­wa i nina sindi­wa­sina­mi baug­ti­san­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Imasa­mi chagrapi trigu agllag runa, pala­wa mana alli ugsa­kunata chabsi­chispa anchu­chí: chasa­lla­ta­mi pai suia­ku, mana alli iuiag­kunata alli iuiag­kunapa chaugpi­manda anchu­chin­gapa. Alli trigu­sina kag­kunata sug­lla­pi suma­mi waka­chin­gapa ka. Ikuti mana alli ugsa­sina kag­kuna­taka mana wañug ninapi rupa­kun­ga­pa­mi sitan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chi puncha­kuna Jesuspas, Gali­lea alpa­manda llugsispa, Jor­dán iakuma chaiag­rirka, Juan paita baug­ti­san­gapa. ");
INSERT INTO inb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanka, piña­rispa nirka: —¿Imapatak chasa maña­waspa samu­kungi? Nuka­ta­mi iukarkangi, kam baug­ti­sa­wanga. ");
INSERT INTO inb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesuska ainirka: —Baugtisawailla. Chasa­mi chaia­ku, Taita Dius tukui imasa nis­ka­sina nukan­chi ruran­gapa. Chasa aini­ura, Juanka paita baug­ti­sarka. ");
INSERT INTO inb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús baug­ti­sai tukunga­lla­wa, iaku­manda llugsirka. Chi­ura­lla, awa suma luar paska­rirka. Chi­manda kawarka, Diuspa Ispí­ritu palu­ma­sina rigcha kawa­rispa­mi pai­pagma urai­ku­mugta. ");
INSERT INTO inb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Suma luar­manda rimai­pas uia­rig­samurka, kasa nispa: —Kai, nuka­pa kuiaska wam­bra­mi ka­puá. Paita kawaspa, iapa alli suma­mi iuia­chii­wa kawani. ");
INSERT INTO inb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chi­ura­mandaka Santu Ispí­ritu, chusa sitaska alpama Jesus­ta pusarka. Chipika iaia kuku, panda­rii­kunapi paita urma­chin­gapa muna­kurka. ");
INSERT INTO inb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chusku chunga puncha tuta­kuna­wan­ta­mi Jesús mana ñi imapas mikuspa­lla chisia­kurka. Nispaka, iapa iarkai­manda iuia­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chi­ura chi mana alli­lla iuia­chig iaia kukuka, pai­pagma chaiag­rispa, nirka: —Kam Diuspa wam­bra kagpika, kai rumi­kunata nii: “Tanda tukui­chi”. ");
INSERT INTO inb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesuska ainirka: —Ñugpa­manda librupi, kasa­mi willa­raiá: Ru­na­kuna, mana tanda­lla­wa kaug­san­gapa kan­kunachu. Taita Dius tukui ima rimas­ka­kuna­wa­mi kaug­san­gapa chaiá. ");
INSERT INTO inb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nispaka chi iaia kuku, Jeru­sa­lén suti Taita Diuspa­lla kaska pui­bluma pusaspa, Diuspa atun wasi awa puntapi saia­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nis­paka, nirka: —Kam Diuspa wam­bra kagpika, alpama sita­rii. Ñug­pa­manda librupi, kasa­mi willa­raiá: Taita Dius, paipa anjil­kuna­ta­mi ninga, kamta kawag­samun­gapa. Pai­kunapa makipimi urman­kangi. Chasaka, mana rumipi u ima­pipas chaki taka­rin­kan­gi­chu. ");
INSERT INTO inb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesuska ainirka: —Kasapasmi willa­raiá: Kamba atun Taita Diusta mana ianga ningi: “Abir kawasaki: ¿pudingi­chu?”. ");
INSERT INTO inb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ikuti chi iaia kukuka, iapa awa filuma pusaspa, kai luarpi tukui alpa­kuna i tukui ima chipi suma tias­ka­kunata kawa­chirka. ");
INSERT INTO inb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nis­paka, nirka: —Kam kungu­ri­wagpika, tukui kawarkangi: chi­kuna­ta­mi karasaki. ");
INSERT INTO inb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Chi­ura Jesuska, chi iaia kukuta nirka: —Nuka­pa ñawi­manda anchu­rii. Ñug­pa­manda librupi, kasa­mi willa­raiá: Kamba atun Taita Dius­lla­ta kungu­rispa kangi. Pai ima niska­lla­ta­mi iukangi ruraspa kanga. ");
INSERT INTO inb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Chasa ni­ura, chi iaia kuku, Jesusta sakispa, anchu­rirka. Chi­ura­lla anjil­kuna, samuspa, paita ima minis­tiskami karag­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista karsilpi wich­kaska kagta iachaspa, Jesuska Gali­lea alpama rirka. ");
INSERT INTO inb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Manima Naza­ret pui­blupi kida­rirka. Kafar­naum suti pui­blu­pi­mi kaug­sai kalla­rirka. Chi Kafarnaumka, Galilea atun kucha ladu­pi­mi ka, Zabulón i Nef­talí suti ñug­pa­manda taita­kuna kaug­saska alpapi. ");
INSERT INTO inb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Isaías suti Santu Ispi­ri­tu­wa rimag, ima ñug­pa­manda willaska tukug­samun­ga­pa­mi Jesús chipi kaug­san­gapa chaiarka. Kasa­mi Isaías niska karka: ");
INSERT INTO inb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón i Neftalipa alpa­kuna­pi, atun kuchama ri­diru ñambi ladu suiu, Jordán iaku sug ladu chimba, Galilea alpapimi Taita Diusta mana rigsig­kuna kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chi alpa­kunapi iana tutapi­sina kaug­sa­na­kug, sug atun puncha­ia­chig­sina runa­ta­mi kawan­gapa kan­kuna. Chi alpa suiu, wañun­gapa manchai­wa kaugsa­nakus­ka­pi­mi chi runa kawa­rig­samun­gapa kan­kunata. ");
INSERT INTO inb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesuska, Kafarnaum pui­blupi kaug­sa­kuspaka, kasa­mi willai kalla­rirka: —Suma luar­manda mandai, ñami chaia­mun­gapa ka. Panda­rii­kunata sakispa, Taita Diuswa tukug­samui­chi. ");
INSERT INTO inb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Galilea atun kucha pata pata puri­kuspa, Jesús, iskai waugkindi­kunata kawarka: sug, Simón suti; pai­lla­ta­ta Pedro. Sugka, Andresmi suti karka. Pai­kuna, chalwa­dur­kuna kaspa, ata­raia iaku ukuma sitaspa­mi puri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pai­kunata kawaspaka, Jesuska nir­ka­kunata: —Kati­wai­chi. Iacha­chisaki­chitami, chalwa­kunata apig­sina, runa­pura maska­puag­kuna kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chasa uianga­lla­wa, ata­raia­kunata sakispa, Jesusta katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chi­manda mailla ris­kapi, ikuti Jesús, sug iskai waugkindi­kuna­ta­mi kawarka. Pai­kuna, Zebedeopa wam­bra­kuna­mi karka; sug Santi­ago suti; sugka Juan. Pai­kuna, taitandi­wa kanuapi kaspa, ata­raia­kunata alli­chi­na­kurka. Pai­kunata kawas­paka, Jesuska kaiar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pai­kuna­pas, uianga­lla­wa, taitata i kanuata sakispa, Jesusta katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chi­manda Jesuska, Galilea alpa suiu, judiu­kuna tanda­ri­diru wasi­kunapi iacha­chispa, Diuspa suma mandai­manda Alli Willaita willaspa, tukui­kunata mai­tuku ungui­kuna­wa kas­ka­kuna­ta­pas ambispa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria suti alpa suiu­pas­mi pai­manda iapa iacha­rig­rirka. Chi­wanka, tukui ungug­kunata pai­pagma pusa­na­kurka. Sug rigcha sug rigcha ungui i nanai­kuna­wa kas­ka­kunata, kuku waira­wa kag­kunata, wañui ungui iukas­ka­kunata, mana kuir­pu kuiu­rin­gapa pudig­kuna­ta­pas, tukui chasa­kuna­ta­mi Jesús ambispa puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Chi puncha­kuna iapa achka runa­kuna, pai­wa sug­lla­pi tanda­rispa puri­na­kurka, Gali­lea i Judea alpa­kuna­nig­manda, De­ká­polis suti pui­blu­kuna­nig­manda, Jeru­salen­nig­manda i Jor­dán iaku sug ladu chimba­nig­manda. ");
INSERT INTO inb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Chi achka runa­kunata kawas­paka, Jesús awa lumama rirka. Chipi tia­rig­ri­ura, paita kati­raiag­kuna kailla­iag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chi­ura, Jesuska iacha­chii kalla­rir­ka­kunata, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Kam­kuna, Taita Diuswa iuia­rispa, mana iukag­sina tukug­kuna, paipa iapa kuiaskami kan­gi­chi. Chasa kag­kuna, Dius suma manda­kus­ka­pi­mi iaikug­rin­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Pi­wapas mana atun­ia­chi­riska iuiaspa kag­kuna­pas, Taita Diuspa iapa kuiaskami kan­gi­chi. Chasa kag­kuna, kai alpa duiñu karaska kag­kuna­mi ni­raian­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Kuna­ura iapa llakii­wa waka­na­kuskapas, Taita Diuspa iapa kuias­kami kan­gi­chi. Chasa kag­kuna­ta, paimi sumag­lla llakii­kuna­ta anchu­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Iarkai i iaku­nai­wa­sina Taita Dius imasa munas­ka­sina ruran­gapa munag­kuna­pas, paipa iapa kuias­kami kan­gi­chi. Pai­lla­ta­ta­mi ima alli munas­kata kara­mun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Sug­kuna­manda iapa llakii­wa kag­kuna­pas, Taita Diuspa iapa kuias­kami kan­gi­chi. Chasa kag­kuna­manda, pai­pas­mi iapa llakii­wa kawan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Tukuipi alli­lla suma iuiai­wa kag­kuna­pas, Taita Diuspa iapa kuias­kami kan­gi­chi. Chasa kag­kuna, paipa ñawi­ta­mi kawag­rin­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Rabia­wa kag­kunata pasin­sia­chig­kuna­pas, Taita Diuspa iapa kuiaskami kan­gi­chi. Chasa rurag­kunata, pai nin­ga­pa­mi ka: “Nuka­pa wam­bra­kuna­mi kan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Kam­kuna alli ruraspa kaug­sa­na­kug­manda, sug­kuna mana suma kam­kunata rura­na­kugpi­pas, Taita Diuspa iapa kuiaskami kan­gi­chi. Chasa pasaspa kag­kuna, Dius suma manda­kus­ka­pi­mi iaikug­rin­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Nuka­manda iuia­rispa, mai­kan­pas kam­kunata kamispa, mana suma ruraspa, kam­kuna­manda llullaspa jucha­chispa rimagpi­kunaka, Taita Diuspa iapa kuias­kami kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chasa mana alli­lla kam­kunata ruragpi­pas, kun­tin­ta­rispa­lla kan­gi­chi. Kam­kunata Taita Dius, sug luarpi asku­rinti suma­mi tukui karan­gapa ka. Chasa­lla­ta­mi kam­kuna­manda mas ñug­pa kaug­sas­ka­kuna, Santu Ispi­ri­tu­wa rimag­kuna­ta­pas mana alli­lla rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Kam­kuna, kai alpapi kaug­sa­na­kuska­manda kachi­sina­mi kan­gi­chi, tukui­kuna mas sumag­lla kaug­sa­na­kun­gapa. Kachi wag­lli­rigpika, mana pudi­ringachu kachia­chin­gapa. Ñi imapapas mana balin­gapa kanchu. Chasa­taka, sitaimi chaiá, pipas saruspa ialin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Kam­kuna, kai alpapi kaug­sa­na­kuskapa iuiai­kunata puncha­ia­chig­kuna­mi kan­gi­chi. Mai­kan pui­blu luma awapi tiag, mana paka­lla­pi­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chasa­lla­ta, ñi pipas mana bila sindi­chin­kangi­chi­chu, kawitu ukuma churan­gapa. Awa­pi­mi churan­gapa kan­gi­chi, tukui chi ukupi kag­kunata puncha­ia­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chasa­lla­ta kam­kuna­pas, runa­kunapa ñug­pa ladu alli rurai­kuna­wa puncha­ia­chig­kuna­sina kaug­san­gi­chi. Chasapika, kam­kunapa alli rurai­kunata kawas­paka, pai­kuna­pas kam­kunapa Taita Dius suma luarpi kag­ta­mi iapa suma atun­ia­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Mana samurka­nichu, Moisés i Santu Ispi­ri­tu­wa rimag­kuna ima ruran­gapa nis­kata puchukan­gapa. Mana chasa iuia­na­kui­chi. Chi­kunapi ima willa­raias­kata ruran­ga­pa­mi samurkani. ");
INSERT INTO inb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kasa­mi nuka nii­ki­chita: sug luar i kai alpa luar tuku­rig­sina kagpi­pas, chi ñug­pa­manda ima willa­raias­kaka, ñi mailla mana anchu­chii tukun­gapa kanchu. Tukui imasa ñug­pa­manda librupi willa­raias­ka­sina­mi tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chasa­manda, mai­kan­pas tukui ima nis­kata mana ruraspa sug­kuna­ta­pas chasa­lla­ta iacha­chigpika, suma luarma iaikug­rig­pura mas uchu­lla­mi ni­raian­gapa kan­kuna. Ikuti mai­kan­pas tukui ima nis­kata ruraspa sug­kuna­ta­pas chasa­lla­ta iacha­chigpika, suma luarma iaikug­rig­pura atunmi ni­raian­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kasa­mi nii­ki­chita: Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna­manda­pas mas alli­lla kam­kuna mana ruragpi­kunaka, suma luarma mana iaikug­rin­gapa kangi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Ñami ñug­pa­manda runa­kunata kasa ni­raias­kata uiarkan­gi­chi: “Mana wañu­chin­gi­chi. Mai­kan wañu­chigtaka justi­siaimi tukun­ga­pa ka”. ");
INSERT INTO inb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Chasa kagpi­pas, nukaka kasa­mi nii­ki­chita: pi­wapas rabia­rig­kuna­ta­mi justi­siai tukun­gapa kan­kuna. Mai­kan kamig­kunata mas atun justi­siaimi tukun­gapa kan­kuna. “Kam, iapa upa­iaska­mi kangi” mai­kan nig­kunata dil­tudupa nina­ma­mi sitai tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Chasa­manda kamta, kama­ri­ku altarma apa­ku­ura sug runa­wa mana alli­lla kagta iuia­rigpi, ");
INSERT INTO inb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kama­ri­kuta sakispa, ñug­pa rin­ga­pa­mi chaiá, chi runa­wa alli­lla tukun­gapa. Chi­ura­manda kutingi, kama­ri­kuta Taita Diusta kawa­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Mai­kan kamta dimandaspa, justi­sia­pagma pusa­na­kugpika, chara ñambi ri­na­kuska­lla­pi paita sumag­lla rimangi, manara justi­sia­pag­ma chaia­chig­rigpi. Mana kagpika, chaia­chig­ri­ura, justi­siaka kamta alwa­sil­kunapa maki­pi­mi sakinga. Chi­ura alwa­sil­kunaka, kamta kar­sil­pi­mi wichkanga. ");
INSERT INTO inb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kasa­mi nuka niiki: chi­manda mana llugsin­gapa kangichu, tukui kulki manara kuti­chin­kama. ");
INSERT INTO inb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Ñami kasa ni­raias­kata uiarkan­gi­chi: “Mana sugpa war­mi­wa panda­ri­kungi”. ");
INSERT INTO inb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Chasa kag­pi­pas, nukaka kasa­mi nii­ki­chita: mai­kan­pas, sugpa warmita kawaspa, pai­wa siri­rin­gapa munas­paka, ñami chasa iuiaipi atun panda­rii rurarkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Kasapas. Kam­kunapa alli ñawi­wa kawaspa, panda­rin­gapa kagpika, chi ñawita chaianmi sur­kuspa sitan­gapa, mana panda­rin­gapa. Chasa­paka, mas alli­char kantra, kuir­pu­manda suglla imapas sitas­pa, pisi kan­gapa. Mana kagpika, ¿tukui kuir­pu­wan­tachu munaipa, dil­tudu­pa ninama sitai tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Chasa­lla­ta, kam­kunapa alli maki­wa panda­rin­gapa kagpika, chi makita chaianmi kuchuspa sitan­gapa, mana panda­rin­gapa. Chasa­paka, mas allichar kantra, kuir­pu­manda suglla imapas sitaspa, pisi kan­gapa. Mana kagpika, ¿tukui kuir­pu­wan­tachu munaipa, dil­tudupa ninama rin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Kasapasmi Moisés ima willa­raias­kapi ni­raiarka: “Mai­kan­pas kikin­pa warmita sitan­gapa munagpika, chasa munas­kata iskri­bispa, chi warmita kuan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Chasa kagpi­pas, nukaka kasa­mi nii­ki­chita: mai­kan­pas, kikin­pa warmita ima­manda­lla­pas sitagpika, atun panda­riima kachag­sina­mi rurá. Chi warmi sug kari­wa api­rigpika, chi­manda­kar pudinmi sitanga. Chasa­lla­ta, mai­kan­pas kusa sitaska warmi­wa kasa­ragpika, atun panda­riimi rurá. ");
INSERT INTO inb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Kasapasmi ñug­pa­manda runa­kunata ni­raiarka: “Atun Taita Diuspa ñawipi mana llullan­gi­chi. Imasa­mi Taita Diuspa ñawipi alli­lla ruran­gapa nirkan­gi­chi: chasa ruran­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Chasa kagpi­pas, nukaka kasa­mi nii­ki­chita: mana ima­ta­pas kawag churan­gi­chi, kam ni­kuska alli­lla kagta. Suma luarta mana kawag churan­gi­chi; suma luar, Taita Diuspa manda­dirumi ka. ");
INSERT INTO inb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kai alpa­ta­pas mana kawag churan­gi­chi; kai alpa, paipa saru­dirumi ka. Jeru­sa­len­ta­pas mana kawag churan­gi­chi; chita, tukui mandu­iug Taita Diuspa pui­blumi ka. ");
INSERT INTO inb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kam­kunapa uma­ta­pas mana kawag churan­gi­chi; kam­kuna manima pudin­gapa kangi­chi­chu, ñi sug agcha iura­ia­chin­gapa u iana­ia­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Chasa­paka, “Ari” nin­gapa chaiag­pika, “Ari” nin­gi­chi­lla. “Mana” nin­gapa ka­ura, nin­gi­chi­lla: “Mana”. Ima­ta­pas chi­wa kawag churag­pika, iaia kukumi iuia­chi­ku. ");
INSERT INTO inb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Ñami kasa ñug­pa­manda ni­raias­kata uiarkan­gi­chi: “Mai­kan­pas rabia­rispa ñawi sur­kus­kataka chasa­lla­ta randi­chin­gapa. Mai­kan­pas kiru llugsigta pias­ka­taka chasa­lla­ta randi­chin­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Chasa kagpi­pas, nukaka kasa­mi nii­ki­chita: mai­kan­pas kamta mana suma ruras­ka­kunata mana randi­chingi. Pipas alli ladu kachi­tipi kamta piag­pika, sug ladu kachi­tipi pian­gapa­pas saki­ringi. ");
INSERT INTO inb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mai­kan kamta diman­daspa, kusma kichun­gapa munag­pika, kapi­saiu­ta­pas kuangi apachu. ");
INSERT INTO inb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mai­kan­pas kamta chunga kuadra apa­rispa katin­gapa chaiag­pika, iskai chunga kuadra­pas katingi. ");
INSERT INTO inb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mai­kan­pas ima mañas­kata karan­gilla. Mai­kan “Maña­chi­wai” nis­kata, ¡ujala­lla­pas ningi: “Mana”! ");
INSERT INTO inb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Ñami kasa ñug­pa­manda ni­raias­kata uiarkan­gi­chi: “Kam­kunapa iacha­ridu­kunata kuiaimi iukan­gi­chi. Ikuti kam­kunata mana munag­kuna­takar rabia­wa kawan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chasa kagpi­pas, nukaka kasa­mi nii­ki­chita: kam­kunata mana munaspa piña­na­kus­kata kuian­gi­chi. Kam­kunata mana suma ruraspa puchu­kan­gapa muna­na­kuska­manda, Taita Diusta pai­kuna­manda alli­lla maña­pun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chasa­waka, kam­kunapa Taita Dius suma luarpi kagpa wam­bra­kuna­mi tukun­gapa kan­gi­chi. Paimi alli rurag­kuna­manda i mana alli rurag­kuna­manda­pas indi llugsi­chimú. Chasa­lla­ta, alli runa­kuna­manda i mana alli runa­kuna­manda­pas­mi tamia­chimú. ");
INSERT INTO inb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Kasapas. Kam kikin­pura­lla kuia­na­kuspa kagpika, kam­kunata, ¿imatak Taita Dius karan­gapa suia­na­kun­gi­chi? Mai­kan mana suma rurag­pura­pas kuia­na­kuspa­mi kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kam­kunapa waug­kindi­pura­lla “Puangi” ni­na­kug­pika, ¿imapi­tak alli­lla rura­na­kun­gi­chi? Chasa­mi Taita Diusta manara rigsig­kuna­pas, kikin­pura kaug­sa­nakú. ");
INSERT INTO inb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imasa­mi kam­kunapa Taita Dius suma luarpi kag, tukuipi alli ka: chasa­lla­ta­mi kam­kuna­pas iukan­gi­chi, tukui­pi alli kan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Sug­kunata: “Allimi kani” kawa­chi­ringa­paglla, Taita Dius imasa nis­ka­sina rura­na­kugta mana ruran­gi­chi. Chasa rurag­kunata, Taita Dius suma luarpi kag, kawaspa, mana ñi imapas karan­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Chi­manda, kam­kuna imapas sug­kunata karan­gapa chaia­ura, kawa­chi­ringa­paglla mana karan­gi­chi. Chasa karag­kuna, tanda­ri­diru wasi­kunapi i ñambi­kuna­nigta tukui­kunata willaspa purin­kuna, sug­kuna pai­kuna­manda “Iapa allimi ka” ni­wa­chu­kuna iuiaspa­lla. Kasa­mi nuka nii­ki­chita: chasa ruraspa purig­kuna, ñami kaipi munas­ka­sina chas­kir­ka­kuna. Ikuti sug luar­pika ñi ima manima chas­kin­gapa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","—Kam­kuna imapas karas­ka­taka, ñi kamba wasi uku­pura­lla­pas mana iacha­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Paka­lla karag­sina ruran­gi­chi. Chasa­waka, kam­kunapa Taita Dius paka­lla­ta kawagmi kam­kunata imasa chaias­ka­sina karan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Chasa­lla­ta, kam­kuna Taita Diusta mañan­gapa chaia­ura, kawa­chi­ringa­paglla mana mañan­gi­chi. Chasa rimag­kuna, tanda­ri­diru wasi­kunapi i ñambi­kuna­nigta saia­rispa­mi Taita Diusta mañan­kuna, “Sug­kuna kawa­wa­chu­kuna” iuiaspa­lla. Kasa­mi nuka nii­ki­chita: chasa rurag­kuna, ñami kaipi munas­ka­sina chaskir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Kam­kunaka, Taita Diusta mañan­gapa ka­ura, ukuma iaikuspa, pungu­kuna wichka­rispa, Taita Dius kam­kunapa ñawi­wa mana kawa­rigta mañan­gi­chi. Pai Taita Dius paka­lla­ta kawagmi kam­kunata imasa chaias­ka­sina karan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Kam­kuna Taita Diusta maña­na­ku­uraka, ikuti ikuti ianga rima­rispa mana mañan­gi­chi. Taita Diusta mana rigsig­kuna­mi iuian­kuna, chasa ikuti ikuti rima­rispa maña­ura, Taita Dius uian­gapa kagta. ");
INSERT INTO inb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kam­kunaka, mana pai­kuna­sina mañan­gi­chi. Kam­kuna manara mañagpi, kam­kunapa Taita Diuska ima minis­tis­ka­kunata ñami iachá. ");
INSERT INTO inb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chi­manda kam­kuna, Taita Diusta maña­na­ku­ura, kasa nin­gi­chi: Nukan­chipa Atun Taita, suma luar­pi­mi kangi. Kam tukuipi mas alli kagta tukui­kuna ni­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nukan­chi­wa samui, iaia kan­gapa. Imasami suma luarpi kam munas­kata ruran­kuna: chasa­lla­ta kai alpa­pipas rura­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kuna puncha, tanda minis­tiska nukan­chita kara­mui. ");
INSERT INTO inb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nukan­chi ima panda­ris­ka­kunata pasin­siai. Chasa­lla­ta nukan­chipas, sug­kuna ima llaki­chis­ka­kunata pasin­sian­chimi. ");
INSERT INTO inb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mana sakii, nukan­chi mana alli iuiai­kunata iuia­na­kun­gapa. Tukui mana alli­kuna­ta­pas nukan­chita kispi­chii. ");
INSERT INTO inb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Kasapas. Sug­kuna ima llaki­chis­ka­kunata kam­kuna pasin­siagpika, kam­kunapa Taita Dius suma luarpi kag­pas­mi kam­kunata pasin­sianga. ");
INSERT INTO inb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ikuti kam­kuna sug­kunata mana pasin­siagpika, Taita Diuspas kam­kuna panda­ris­ka­kunata manami pasin­sianga. ");
INSERT INTO inb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Ikuti chasa­lla­ta, kam­kuna Taita Dius­manda iuia­rispa mana mikuspa­lla kan­gapa chaia­ura, kawa­chi­ringa­paglla mana ruran­gi­chi. Chasa rurag­kuna, llulla ñawi­wa iapa irkiaspa­mi tukun­kuna, “Sug­kuna kawa­wa­chu­kuna” iuiaspa­lla. Kasa­mi nuka nii­ki­chita: chasa rurag­kuna, ñami kaipi munas­ka­sina chaskir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—Kam­kunaka, Taita Dius­manda iuia­rispa mana mikuspa­lla ka­ura, ñawi suma mailla­rispa, uma llambu kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chasa, sug­kunaka mana iachan­ga­kunachu, mana mikuspa­lla kagta. Taita Dius kam­kunapa ñawi­wa mana kawa­rig, pai­lla­mi iachan­gapa ka. Pai Taita Dius paka­lla­ta kawagmi imasa chaias­ka­sina kam­kunata karan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Mana kai alpapi mira­chin­gi­chi, iapa iukag kan­gapa. Bur­bu­jumi kaipi waglli­chispa puchu­kan­kuna. Chasa­lla­ta, iru waka­ris­ka­sina­mi tukun­kuna. Sisai­kuna­pas­mi kichun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Chasa­paka ruran­gi­chi, suma luarpi waka­chi­kus­ka­sina, chipi iukag kan­gapa. Chipika, bur­buju mana tian­gapa kanchu, waglli­chispa puchu­kan­gapa. Ñi mana imapas waka­riska tukun­gapa kanchu. Ñi sisai­kuna mana tian­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kam­kuna maipi waka­chis­ka­pi­mi kam­kunapa iuiaita churaska kan­gi­chi: kai luarpi u sug luarpi. ");
INSERT INTO inb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Kam­kunapa ñawi­kuna, kuir­pupi puncha­ia­chig­sina­mi kan­kuna. Ima­ta­pas alli iuiai­wa kawag­pika, kam­kunapa kuir­pu­pas suma puncha­iag­sina­mi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ikuti mana alli iuiai­wa kawag­pika, kam­kunapa kuir­pupas iana tutapi kag­sina­mi kan­gapa ka. Kam­kunapa iuiai mana puncha­pi­sina kagpika, tukuimi mas iana tuta­pi­sina kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Ñi mai­kan­pas, iskai patrun­kunapa sug­lla­pi mana trabajapun­gapa pudin­gapa kan­kunachu. Sug patrunta mana munangachu; ikuti sugtaka kuiangami. Sug patrunta wabu­tingami; ikuti sugtaka sumag­lla­mi rimanga. Chasa­lla­ta, Taita Diusta i kai alpa­manda iukai­kunata mana pudin­kangi­chi­chu, iskan­dima su­ura­lla iuia­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Chi­mandami kasa nii­ki­chita: mana iapa iuia­ri­na­kun­gi­chi: “¿Imatak miku­sun­chi i upia­sun­chi, nukan­chi kaug­san­kama? ¿Ima katan­gatak chura­ri­sun­chi?”. Kam­ba kaug­saika, mikui­kuna­manda masmi ka. Chasa­lla­ta kamba kuir­pu­pas, katanga­manda masmi ka. ");
INSERT INTO inb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pisku­kuna­manda iuia­rii­chi. Pai­kunaka mana tarpun­kunachu. Mikui pallaspa, mana waka­chin­kunachu. Chasa kagpi­pas, kam­kunapa Taita Dius suma luarpi kagka ñi ima mana pisi­chin­kuna­tachu. Kam­kunaka, pisku­kuna­manda mas balimi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—¿Pi­kunatak, maituku iuia­rispa­pas, sug palmu­lla­pas awa wiñai pudin­gapa kan­gi­chi? Ñi pipas manima. ");
INSERT INTO inb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Imapatak iapa iuia­ri­na­kun­gi­chi: “¿Ima katan­gatak chura­ri­sun­chi?”? Kawai­chi imasa liriu tugtu­kuna chagra­pi suma wiña­ris­ka­kunata. Iuia­rii­chi: pai­kuna mana puch­kaspa awan­kuna­chu. Ñi ima mana ruran­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kasa­mi nii­ki­chita: ñi atun mandag Salo­món, pai tukui iapa suma katanga chura­rispa­pas, chi tugtu­kuna­manda mas suma mana kawa­rirkachu. ");
INSERT INTO inb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ugsa kuna puncha chagra­pi suma kas­kata, kaiandi rupa­chin­gapa kagta, Taita Dius chasa suma kawá. Kam­kuna­taka, ¿ima­wantak mana mas sumag­lla kawanga? Kam­kuna mana alli­lla Taita Dius­manda iuia­rispa kag­kuna, paita mas sumag­lla iuia­rii­chi. ");
INSERT INTO inb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Chi­manda, mana iapa iuia­ri­na­kun­gi­chi: “¿Imatak miku­su­n­chi? ¿Imatak upia­sun­chi? ¿Ima katan­gatak chura­ri­sun­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kai alpa­manda­lla iuiai­wa kag­kuna­mi chasa maskaspa kaug­sa­nakú. Kam­kuna tukui ima minis­tis­ka­kuna­mandaka, kam­kunapa Taita Dius suma luarpi kag ñami iachá. ");
INSERT INTO inb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","—Kam­kuna ñug­pa suma iuia­rispa kan­gi­chi, Taita Dius imasa mandas­ka­sina kaug­san­gapa. Chasa­lla­ta, pai imasa nis­ka­sina ruran­gapa iuia­rispa kan­gi­chi. Chasa kagpi­kunaka, kam­kunata tukui ima minis­tis­ka­kuna­ta­mi kara­munga. ");
INSERT INTO inb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—Chi­manda, mana iapa iuia­ri­na­kun­gi­chi: “Kaia, ¿ima­sik pasa­sa?”. Kada punchami ima llakii­kuna­pas tiag­samú. Kaia­manda llakii­kunata mana iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Mana pi­ta­pas panda­ris­ka­kunata kawan­gi­chi. Chasaka, Taita Dius mana kam­kuna panda­ris­kata kawan­gachu. ");
INSERT INTO inb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imasa­mi kam­kuna, sug­kuna panda­ris­ka­kunata kawan­gi­chi: chasa­lla­ta­mi Taita Dius, kam­kuna­ta­pas panda­ris­kata kawan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Nigpika, ¿imapatak sugpa ñawipi juitu­riska ugsata kawa­kungi; ikuti kam kikinpa ñawipi sug atun ugsa juitu­riska iukas­ka­taka mana kawa­ringi? ");
INSERT INTO inb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chasa­lla­ta, kam kikinpa ñawipi chi atun juitu­riska iukas­paka, ¿imasa­tak sugta ninkangi: “Ñawipi juitu­riska ugsata anchu­chi­saki”? ");
INSERT INTO inb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sungu awa­lla rimag, kam kikinpa ñawita chi atun juitu­riska iukas­kata ñug­pa anchu­chi­rii. Chasa ruraspa­mi alli­lla kawan­kangi, sugpa ñawita juitu­riska ugsata anchu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Kasapas. Taita Diuspa­lla tia­pus­kata, ¿alku­kuna­tachu sita­puntran­gi­chi; chi­wanka, kam kikin­kunata rabia­rispa kanin­gapa? ¿Kam­kunapa kuri pirla­kunatachu kuchi­kunata sita­puntran­gi­chi, sarun­gapa? Manima. Chasa­lla­ta, Diuspa Rimai­ta mana sitag­sina ruran­gi­chi, mai­kan mana suma iuiai­wa chaskin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Taita Diusta mañagpika, kara­mun­ga­pa­mi ka. Paita mas­kag­pika, tarin­ga­pa­mi kan­gi­chi. Pungu taka­chig­rigpika, kam­kunata paska­pun­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mai­kan­pas chasa mañagpika, chaskin­ga­pa­mi ka. Mai­kan­pas maskagpika, tarin­ga­pa­mi ka. Mai­kan pungu taka­chig­rigpika, iaiku­chin­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Sug wam­bra, paipa taitata tanda maña­kugpika, ¿rumichu karan­tra? ");
INSERT INTO inb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chasa­lla­ta, chalwa maña­kugpika, ¿kulibra­chu karan­tra? Manima. ");
INSERT INTO inb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kam­kuna, mana alli kaspa­pas, kam­kunapa wam­bra­kunata suma imapas karan­gi­chi. Nigpika kam­kunapa Taita suma luarpi kagka, ¿ima­wantak mana sumag­lla kara­munga, mai­kan suma mañagpika? ");
INSERT INTO inb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Imasami muna­na­kun­gi­chi, sug­kuna kam­kuna­manda alli­lla rura­chu­kuna: chasa­lla­ta kam­kuna­pas, pai­kuna­manda alli­lla ruran­gi­chi. Chasa­mi Moisés i Santu Ispi­ri­tu­wa rimag­kuna iacha­chiska ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Suma luarma iaikug­rin­gapa, kichki pungupi­sina ialin­gi­chi. Dil­tudupa chingan­gapa luarma ri­diru, atun suma ñambi­sina­mi ka. Chima iaiku­diru, atun pungu paskas­ka­sina­mi ka. Achka­kuna­mi chi pungu­sina kas­kapi iaikun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ikuti dil­tudupa kaug­sai iukan­gapa luarma ri­diruka, iapa amchi ñambi­sina­mi ka. Chima iaikun­gapa, iapa kichki pungu­sina­mi ka. Mailla­kuna­lla­mi chi ñambi­sinata kati­chin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Iuiaipilla uian­gi­chi. Llulla­kuna­mi tia, kasa nispa: “Santu Ispi­ri­tu­wa rimagmi kani”. Chi­kuna, ubija­sina alli kawa­rispa­mi kam­kuna­pagma samun­ga­kuna. Nigpika pai­kunapa iuiai­pika, sug sacha alku ima­ta­pas mikun­gapa iuiai­wa kag­sina­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imasa­mi kawan­gi­chi sacha­kuna, miski muiu u winja muiu tia­rigta: chasa­lla­ta­mi pai­kunata ima ruras­kata kawas­paka, rigsin­kan­gi­chi. Ispina­iug sacha­kunapi, mana ubas muiu tanda­chi­rinchu. Chini sacha­kunapi, mana igus palla­rinchu. ");
INSERT INTO inb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mai­kan alli sacha­kuna­pi­mi miski muiu­kuna tukú. Mana alli sacha­kuna­pika, winja muiu­kuna­mi tukú. ");
INSERT INTO inb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Alli sacha­kunapi, winja muiu­kuna mana tukug­samunchu. Mana alli sacha­kuna­pika, miski muiu­kuna mana tia­rin­chu. ");
INSERT INTO inb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tukui sacha mana alli­lla muiu tukus­ka­kunata kuchus­pa, nina­pi­mi churan­gapa chaiá. ");
INSERT INTO inb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chasa­lla­ta, runa­kuna ima ruras­kata kawaspa­mi pai­kunata rigsin­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Achkakunami nukata: “Iaia Jesús, Iaia Jesús” ni­wan­kuna. Chasa ni­wag­kuna, tukui­kunaka suma luarma mana iaikug­rin­gapa kan­kunachu. Nuka­pa Taita suma luarpi kag imasa pai munas­ka­sina alli rurag­kuna­lla­mi iaikug­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chi puncha, achka­kuna­mi ni­wan­gapa kan­kuna: “Iaia Jesús, ¿manachu kam­manda willas­pa purir­kan­chi? ¿Manachu, kam­manda iuia­rispa, kuku waira­kunata llugsi­chir­kan­chi? ¿Manachu achka mana ima­ura­pas kawas­ka­sina kam­manda iuia­rispa rurar­kan­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","—Nukaka, chi­ura ainin­ga­pa­mi kani: “Kam­kunata mana ima­ura­pas rigsii­ki­chitachu. Kam­kuna mana alli­lla rurag­kuna, nuka­pa ñawi­manda anchu­rii­chi”. ");
INSERT INTO inb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Chi­mandami nii­ki­chita: mai­kan nuka ima rimas­kata uiaspa rurag­kuna, suma iuiai­iug runa­sina­mi kan­kuna. Chi runa, rumi­sina muruchu alpapi wasi­chirka. ");
INSERT INTO inb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tamia samurka; iaku jundarka; sin­chi wairapas pukug­samurka. Maituku chi wasita piag­ri­kugpi­pas, manima urmarkachu, rumi­sina muruchu alpapi saia­chiska kag­manda. ");
INSERT INTO inb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Mai­kan uia­waspa­pas, nuka imasa rimas­ka­sina mana rurag­kunaka, mana iuiai­iug runa­sina­mi kan­kuna. Chi runa, kaskaju awa­lla­pi wasi­chirka. ");
INSERT INTO inb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tamia samurka; iaku jundarka; sin­chi wairapas pukug­samurka. Chi wasita iaku jun­daspa piag­rig­lla­pi, urma­chispa, waglli­chispa­mi aparka. ");
INSERT INTO inb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús chasa rimas­kata puchu­ka­uraka, chipi kag­kuna, pai iacha­chis­kata uiaspa, iapa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pai­kunapa iacha­chig taita­kuna­sinalla pai mana iacha­chirkachu. Tukui­kuna­manda mas suma alli­lla mandag­sina­mi iacha­chirka. ");
INSERT INTO inb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús chi luma­manda urai­ku­uraka, iapa achka runa­kuna paita kati­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Diulpilla sug runa, aicha ismui ungui iukaspa, pai­pagma kailla­iag­rirka. Chi runa­ka, kungu­rispa, nirka: —Taita waugki, kam munas­paka, pudingimi nukata ambi­wanga. ");
INSERT INTO inb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Chi­ura Jesuska, ungugta maki churaspa, nirka: —Ari, muna­nimi. Ambi­riska tukui. Chasa nig­lla­pi, chi ungui alli­lla ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chi­ura, Jesuska nirka: —Uiamui. Mana pi­ta­pas willa­kungi. Sasir­dutita kawa­chi­rig­rii. Moisés kama­ri­ku karan­gapa ni­raias­ka­sina karag­rii. Chasaka, tukui­kuna­mi kawan­ga­kuna, kam alli­lla ambi­riska kagta. ");
INSERT INTO inb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Kafarnaum pui­bluma chaiag­ri­kus­kapi, Roma­manda achka suldadu­kunata mandagka, paita kailla­iaspa mañarka, ");
INSERT INTO inb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kasa nispa: —Taita waugki, nuka­pa uchulla lutrinmi mana kuiu­rin­gapa ungui­wa sin­chi nanai­wa wasipi siri­pua­ku. ");
INSERT INTO inb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chi­ura, Jesús nirka: —Nuka, kam­bagma rispa, alia­chig­ri­sami. ");
INSERT INTO inb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Chi runaka ainirka: —Taita waugki, nuka mana miri­si­nichu, kam nuka­pa wasi uku­ma iaikug­rin­gapa. Chasapaka, sug rimailla ni­puai; nuka­pa ungug ambi­ri­puanga­llami. ");
INSERT INTO inb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nuka­pas, sug­kuna manda­was­ka­pi­mi kani. Chasa­lla­ta nuka­pas, sug sul­da­du­kunata mandagmi kani. Mai­kan sulda­duta nuka “Rii” nisa; chi­ura rin­llami. Ikuti mai­kanta: “Samui” nisa; chi­ura samun­llami. Nuka­pa lu­trin­ta: “Kasa rurai” nisa; chi­ura ruran­llami. ");
INSERT INTO inb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chi­ura Jesús, chi runata ujna­rispa uiarka. Nispaka, kati­raiag­kunata nirka: —Kasami nuka nii­ki­chita: ñi mai­kan Israel­manda runa, kai mandag­sina suma alli­lla iuia­wag mana tarirka­nichu. ");
INSERT INTO inb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kasa­mi nii­ki­chita: mana judíu kag­kuna­pas, achka­kuna­mi suma luarma iaikug­rin­gapa kan­kuna, Dius suma manda­kus­kapi, Abra­ham, Isaak i Jakob­wa sug­lla­pi kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ikuti Taita Dius kikin agllaska judiu­kunaka, mana uia­wag­manda, iana tuta kancha­pi­sina dil­tudupa nina­ma­mi sitai tukun­gapa kan­kuna. Chipi, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Chasa nispaka, chi mandagta nirka: —Riilla kamba wasima. Imasa­mi kam nuka­manda suma iuia­wangi: chasa­lla­ta kam iuia­kuska, suma tuku­chu. Chi­urallami chi ungug ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chi­mandaka Jesús, Pedropa wasipi iaikug­rirka. Chipika Pedropa suigra, rupai­wa­mi ungug siri­kurka. Chasa kawaspa, ");
INSERT INTO inb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesuska paipa makita tantiarka. Tantia­ura­lla, rupai anchu­rirka. Chi­ura chi warmi, atarispa, mikui ianuspa, karai kalla­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chi tuta, kuku waira­wa kas­ka­kunata, achka­kuna­ta­mi Jesus­pagma chaia­chig­rir­ka­kuna. Chi­ura, suglla rimai­lla­wa­mi chi kuku waira­kunata llugsi­chirka. Tukui ungui­wa kas­ka­kuna­ta­pas­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chasami tukug­samurka, Isaías suti Santu Ispi­ri­tu­wa rimag ñug­pata willas­ka­sina. Kasa­mi willa­raiarka: “Nukan­chipa llakii i ungui­kuna­ta­pas­mi pai aparka”. ");
INSERT INTO inb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iapa achka runa­kuna, Jesusta muiu­chir­ka­kuna. Chasa kawaspa, Jesuska paita kati­raiag­kunata nirka: —Kai kuchata chimba­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chi­ura Moisés ima nis­kata sug iacha­chig taita, kailla­iaspa, nirka: —Iacha­chig taita, kamta kati­sa­kimi maima kam ri­kuska­ma. ");
INSERT INTO inb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesuska ainirka: —Chucha­kuna, kuiba­kuna­mi iukan­kuna, pai­kuna kaug­san­gapa. Pisku­kuna­pas, tasinwa suma alli­chiska wasimi iukan­kuna. Ikuti kai Runa Tukus­kaka mana iukanchu, ñi mai­pipas sama­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sug kati­raiagka, paita nirka: —Taita waugki, ñug­pa saki­wai, nuka­pa taitata pambag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesuska ainirka: —Kati­wailla. Nukata mana iuia­ri­wag­kuna pamba­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chi­ura­manda, Jesús kanuapi iaiku­ura, kati­raiag­kuna­pas iai­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ña iaku chimba­na­kus­kapi, iapa sin­chi waira atarii kalla­rirka. Chi­wanka, kanua ukuma iaku ña iaiku­kurka. Jesuska puñu­kurka. ");
INSERT INTO inb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Chi­ura kati­raiag­kuna, kailla­iaspa, paita rigcha­chir­ka­kuna, kasa nispa: —Taita waugki, nukan­chita kispi­chii. Mana kagpika, kaipichar wañu­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesuska, rigcha­rispa, ainir­ka­kunata: —¿Imapatak chi­tuku mancha­rin­gi­chi? Kam­kuna, mai­lla­mi nuka­manda iuia­waspa kan­gi­chi. Chasa nispaka, atarispa, wai­rata i iakuta piñarka. Chasa piña­uraka, tukui alli­lla­mi kasilla­iag­samurka. ");
INSERT INTO inb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kati­raiag­kuna, ujna­rispa­mi pai­pura tapu­ri­na­kurka: —¿Ima runa­sik ka? Waira i iaku­pas, paita uian­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kucha ialispaka, sug ladu chim­ba chaiag­rir­ka­kuna Gadara suti alpama. Chipika, wañus­ka­kuna pamba­raiaska­nig­manda iskai runa­kuna, kuku waira­kuna iaikuska, Jesusta tupag­rir­ka­kuna. Chi runa­kuna, wañu­chin­gapa mancha­chig kar­ka­kuna. Chi­wanka, mana pipas chi suiu ialin­gapa pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chi runa­kunaka, Jesusta kawas­pa, kapa­rispa nir­ka­kuna: —Ai, kam Diuspa wam­bra, ¿ima­pa­tak nukan­chi kaska­ma samu­kungi? ¿Samu­kungichu, sin­chi nana­chii puncha manara chaiag­pi­pas, nukan­chita llaki­chin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Manancha karu­lla­pi, achka kuchi­kuna mikuspa puri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nigpika chi runa­kunapi kag kuku waira­kunaka, Jesusta mañar­ka­kuna, kasa nispa: —Kai­manda nukan­chita llugsi­chispaka, kachai, chi kuchi­kunapa ukuma iaikug­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chi­ura, Jesús nir­ka­kunata: —Rii­chilla. Chasaka chi kuku waira­kunaka, ña runa­kuna­manda llugsispa, kuchi­kunapa ukuma iaikug­rir­ka­kuna. Chi­wanka tukui kuchi­kuna, iapa saia patata kalpaspa, kucha iaku ukuma sita­rig­rir­ka­kuna. Chipi chuka­rispa, tukui puchuka­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chasa kawaspa, kuchi­kunata kawag­kunaka, mitikuspa, pui­bluma chaiag­rispaka, tukui imasa pasa­ris­kata willag­rir­ka­kuna. Chi kuku waira­kuna iukaska runa­kunata imasa pasa­rig­ta­pas willar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Chi uiag­kunaka, chi pui­blu­manda tukui­kuna llugsi­rir­ka­kuna, Jesus­wa tupa­na­kun­gapa. Paita kawag­rispaka, mañar­ka­kuna: —Nukan­chipa alpa­manda llugsi­puai. ");
INSERT INTO inb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chi­ura Jesús, kanuapi iai­kus­pa, ikuti kucha ialispa, pai kaug­sa­kuska pui­bluma chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chasa uiaspa sug runa­kunaka, mana kuiu­rin­gapa ungui­wa kas­kata chakanapi siri­chispa, Jesus­pagma apar­ka­kuna. Chi­ura Jesuska, “Ambi­puanga­mi” iuia­na­kus­kata kawas­paka, mana kuiu­rin­gapa ungui­wa kas­kata nirka: —Wam­bra, mana llakii­wa kai. Kam panda­rii­kunata ñami pasin­siaska kangi. ");
INSERT INTO inb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Chasa uiaspa, Moisés ima nis­ka­ta iacha­chig taita chipi kag­kunaka, kikin­pura tapu­ri­na­kurka: —Kai runa, ¿imapatak Dius­sina tukuspa rima­ku? ");
INSERT INTO inb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesuska, chasa iuia­na­kus­kata iachas­pa, nir­ka­kunata: —¿Imapatak sungu­lla­pi mana suma iuia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Mai­kantak mas alli ka: nin­gapa: “Kam panda­rii­kunata ñami pasin­siaska kangi”? Mana kagpika, ¿nin­gapa: “Atarii, kam­ba wasima riilla; ña ambi­riskami kangi”? ");
INSERT INTO inb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kuna­ura kawa­chi­sa­ki­chita: kai Runa Tukuska, kai alpapi pudinmi, panda­rii­kunata pasin­sian­gapa. Chasa nispa, mana kuiu­rin­gapa ungui­wa kas­kataka nirka: —Atarii. Chakanata marka­rispa, kamba wasima rii. ");
INSERT INTO inb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Chasa ni­ura, chi runa, atarispa, wasima rirka. ");
INSERT INTO inb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chasa kawaspaka, chipi kag­kuna iapa mancha­rir­ka­kuna. Taita Diusta iapa suma atun­ia­chir­ka­kuna, kasa nispa: —Paimi runa­kunata chi­tuku iachai­ta kara­muska ka. ");
INSERT INTO inb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús, chi­manda ri­kuspa, mana judíu kas­ka­kuna­manda kulki chaski­kus­kapi iali­kurka. Chipika, Mateo suti runami tia­kurka. Chi runata kawaspaka, Jesuska nirka: —Kati­wai. Chi­ura chi runa, atarispa, Jesusta katii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chi­ura­manda, Jesuswa sug­lla­pi kati­raiag­kuna Mateopa wasima iaikug­rir­ka­kuna. Chipi mikun­gapa tia­naku­ura, pai­pura kulki chaskig­kuna i mana alli­lla rurag­kuna, achka­kuna­mi, chaiag­rispa, sug­lla­pi tia­rig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Chasa kawas­paka, fari­seo­kuna chi kati­raiag­kunata tapur­ka­kuna: —Kam­kunata iacha­chig, ¿ima­pa­tak mana judíu kag­kuna­manda kulki chaskig i mana alli­lla rurag­kuna­wa sug­lla­pi miku­ku? ");
INSERT INTO inb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Chasa uiaspaka, Jesuska nirka: —Mana ungui­wa kag­kuna mana minis­tin­kunachu, ambigta maskan­gapa. Ungug­kuna­mi ambigta mas­kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kam­kuna, rispa, ñug­pa­manda librupi imasa ni­ra­ias­ka­ta iachai­kug­rii­chi kasa willa­raias­kata: Mana muna­nichu kam­kuna, nuka­manda animal­kunata wañu­chispa rupa­chi­puan­gapa. Kam­kuna sug runa­kuna­manda llakispa kaug­sa­na­kun­ga­pa­mi munani. Chasa­lla­ta, nukaka mana samurka­nichu, alli­lla rurag­kunata kaian­gapa. Mana alli­lla rurag­kuna­ta maskan­ga­pa­mi samurkani; chasaka, Taita Diuswa alli­lla tukun­gapa­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chi­ura Juan Bautista­wa purig­kuna, kailla­iaspa, Jesusta tapur­ka­kuna: —Kamta kati­raiag­kuna, ¿ima­wan­tak ima­ura­pas mikuspa­lla kan­kuna? Ikuti nukan­chika fari­seo­kuna­pas, achka puncha­kuna mana mikuspa­lla­mi chisian­chi. ");
INSERT INTO inb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Chi­ura, Jesuska ainir­ka­kunata: —Kasaraipi, kusa tukunga kun­bi­das­ka­kuna­wa kan­kama, ¿ir­kiaspa llakii­wa mana mikuspa­lla­chu kan­ga­kuna? Manima. Ima­ura chaia­chu, kusa anchu­chii tukun­gapa: chi­ura­mi pai­kunata chaianga, mana mikuspa­lla kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Ñi pipas, ruku katangapi musu linsu­wa mana sirangi­chi­chu. Chasa siragpika, tagsa­ura, chi linsu uchullaiaspa, ruku katanga­ta­mi lliki­chinga. ");
INSERT INTO inb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chasa­lla­ta musu binu, ruku kara taligapi mana tallingi­chi­chu. Chasa talligpika, musu binu timbu­ura, taligata tugia­chispa­mi icha­ringa. Kara taliga­pas mana balin­chu. Chi­mandami musu binu, musu taligapi tallin­gapa chaiá. Chasa talligpika, binu taliga­pas­mi alli­lla tukunga. ");
INSERT INTO inb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús chara rima­kug­lla­pi, sug mandag runa, kailla­iaspa, kungu­rispa, paita nirka: —Nuka­pa warmi wam­bra, kuna­ura­lla­mi wañupuá. Kamba maki chura­puag­rii. Chasaka, kaug­sa­ri­puan­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Chi­ura Jesús, atarispa, chi runa­wa rii kalla­rirka. Paita kati­raiag­kuna­pas, kati kati rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ri­na­kun­kama sug warmi, paipa kati­nig­manda kailla­iarka. Chi warmi, chunga iskai wata iawar sitai­wa ungug karka. ");
INSERT INTO inb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Paipa iuiaipi ni­kurka: “Jesuspa katangata llam­kai­lla­wa­mi ambi­rig­samusa”. Chasa iuia­kuspaka, paipa katanga puntapi llam­karka. ");
INSERT INTO inb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesuska, tigra­rispa, chi warmita kawaspa, nirka: —Kam warmisita, mana llaki­kui. Nuka­manda suma iuia­riska­mandami ambi­rig­samurkangi. Chasa nig­lla­pi, chi ungui anchu­rirka. ");
INSERT INTO inb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chi mandagpa wasima Jesús chaiag­ri­uraka, flaugta­kuna uia­chis­pa, iapa killa­chispa waka­na­kurka, wañus­kata apan­gapa. Chasa kawaspaka, ");
INSERT INTO inb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesuska nir­ka­kunata: —Anchu­rii­chi. Chi wam­bra mana wañuska kanchu. Puñui­lla­mi puñu­ku. Uiag­kuna, paita asir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tukui­kuna llugsi­chii tuku­uraka, Jesuska wam­bra kaska­ma iaikug­rirka. Chi wam­brata maki­manda api­ura, kaug­sa­rispa atarirka. ");
INSERT INTO inb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chi­wanka chi alpa suiu, tukuipi chasa pasa­riska­manda iacha­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús chi­manda llugsispa ri­kus­kata, iskai runa­kuna mana ñawi kawag­kuna kati­na­kurka, kasa kapa­rispa: —Davidpa wam­bra, nukan­chi­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús wasima chaiag­ri­ura, chi runa­kuna kailla­iag­rir­ka­kuna. Chi­ura, Jesuska tapur­ka­kunata: —Kam­kuna nuka­manda, ¿suma­chu iuia­na­kun­gi­chi, nuka kam­kunata ambii pudin­gapa kagta? —Ari, taita waugki— ainir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Chi­ura Jesuska, ñawita llam­kar­ka­kunata, kasa nispa: —Imasami nuka­manda suma iuia­wa­nakun­gi­chi: chasa tukuchu. ");
INSERT INTO inb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chasa ni­ura, alli­lla kawai pudir­ka­kuna. Nispaka, Jesús nir­ka­kunata: —¡Ujala­llapas sug­kunata willa­na­kun­gi­chi! ");
INSERT INTO inb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Chi runa­kunaka, chi nis­kata mana uiaspa­lla, maipi ris­kapi, tukuipi Jesus­manda willaspa purig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chi runa­kuna ña riska ka­uraka, sug runata kuku waira iukas­kata Jesus­pagma chaia­chig­rir­ka­kuna. Chi runa, mana riman­gapa pudi karka. ");
INSERT INTO inb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús chi kuku wairata llugsi­chi­uraka, chi runa alli­lla rimag­samurka. Chasa kawas­paka, achka chipi kag­kuna iapa ujna­rispa nir­ka­kuna: —Kai Israel alpapi, ñi ima­ura­pas mana iacha­riska kanchu pipas chasa ambigta. ");
INSERT INTO inb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ikuti fari­seo­kunaka ni­na­kurka: —Iaia kukupa iachai­wa­mi kuku waira­kunata llugsi­chi­ku. ");
INSERT INTO inb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chi alpapi, tukui atun i uchulla pui­blu­kuna­pi­mi Jesús puri­kurka. Judiu­kuna tanda­ri­diru wasi­kunapi iacha­chispa, Diuspa suma mandai­manda Alli Willaita willaspa i tukui­kunata, mai­tuku ungui i nanai­kuna­wa kas­ka­kuna­ta­pas ambis­pa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tukui chipi kaug­sag­kuna, sitaska ubija­kuna­sina, ñi pipas mana kawan­gapa tiag­sina­mi kar­ka­kuna. Pai­kunata chasa kawaspaka, Jesús iapa llaki­rirka. ");
INSERT INTO inb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nispaka, paita kati­raiag­kunata chi runa­kuna­manda kasa nirka: —Pallan­gapaka, achkami tia. Nigpika pallag­kunaka, mai­lla­mi tian­kuna. ");
INSERT INTO inb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chi pallaika, atun Taita Diuspa chagra­sina­mi ka. Chi­manda, paita mañai­chi, achka pallag­kuna kacha­muchu. ");
INSERT INTO inb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chi­ura­manda Jesuska, pai­pa chunga iskai kati­ra­iag­kunata kaiarka. Nispaka kuarka, pai­kuna kuku waira­kunata llugsi­chii, ima ungui­wa i nanai­wa kas­ka­kuna­ta­pas ambii pudin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chi chunga iskai agllas­ka­kuna, kasa­mi suti kar­ka­kuna: tukui­kuna­manda mas ñug­pa karkami Simón; paita, Jesús suti­chirka Pedro; chi­manda, paipa waugki Andrés; San­tiago i paipa waugki Juan (pai­kuna, Zebedeopa wam­bra­kuna­mi kar­ka­kuna); ");
INSERT INTO inb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé i Tomás; Mateo (pai karkami mana judíu kas­ka­kuna­manda kulki chaskig); Alfeopa wam­bra Santiago­lla­ta­ta suti i Tadeo; ");
INSERT INTO inb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","sug Simón (ka­na­neo suti runa­kuna­wa ñug­pata purig); i Judas Iska­riote, Jesusta katuspa api­chig. ");
INSERT INTO inb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Chi chunga iskai runa­kunata kacha­kuspa, Jesuska kasa­mi nirka: —Mana ri­na­kun­gi­chi mana judíu kag­kuna­pagma. Chasa­lla­ta, Sama­ria alpa pui­blu­kunama mana iaiku­nakug­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Chasapaka, Israel­manda runa­kunapagma rii­chi. Pai­kuna, ubija­kuna chingas­ka­sina­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—Tukuipi willaspa rin­gi­chi: “Suma luar­manda mandai, ñami chaia­mu­ku”. ");
INSERT INTO inb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ungui­wa kas­ka­kunata ambin­gi­chi. Wañus­ka­kunata kaug­sa­chin­gi­chi. Aicha ismui ungui­wa kas­ka­kuna­ta­pas alia­chin­gi­chi. Kuku waira­kunata llugsi­chin­gi­chi. Mana pagaspa­lla­mi kam­kuna chaskirkan­gi­chi. Chasa­lla­ta kam­kuna­pas, ñi ima mana ku­bras­pa­lla kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mana puri­chii­chi kuri, kulki ñi imapas chumbillis­kapi watas­ka­sina. ");
INSERT INTO inb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mana apa­na­kui­chi jigra, ñi chaki­kunapi chura­ri­diru, ñi ta­wi­na ñi imapas ñambipa. Katan­ga­pas, imasa chura­riska kaska­lla­wa rii­chi. Mai­kan trabajag­kunata chaianmi, mikui u ima minis­tiska pai­kuna chaskin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Mai­kan atun i uchulla pui­blupi chaiag­rispaka, mai­kan alli iuiai­wa runa kaska­manda tapug­rin­gi­chi. Tarig­rispaka, chi alli runa­pag­lla­pi kida­rin­gi­chi, chi pui­blu­manda sug­sinama llugsin­kama. ");
INSERT INTO inb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Paipa wasipi iaikuspa, nin­gi­chi: “Puangi. Sumag­lla alli­lla ka­puai­chi”. ");
INSERT INTO inb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chi wasipi sutipa alli iuiai­wa kaug­sa­na­kugpika, pai­kunata tukuipi alli­lla­mi tukug­samun­ga­kunata. Ikuti mana alli iuiai­wa kagpi­kunaka, pai­kunata mana alli­lla tukug­samun­ga­kuna­tachu. ");
INSERT INTO inb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","—Maipi kam­kunata mana chas­kin­gapa i kam­kuna ima rimas­kata mana uian­gapa muna­chu­kuna, chi wasi i pui­blu­manda llugsi­kuspaka, chakipi alpa lluta­raias­kata chabsin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kasa­mi nuka nii­ki­chita: Taita Dius justi­siai ruran­gapa puncha chaia­uraka, Sodoma i Gomorra suti alpa­kuna­manda runa­kunata llaki­chiska­manda­pas masmi chi pui­blu­kuna­manda runa­kuna llakii iukan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Uiamui­chi. Kam­kunata ubija­kunata­sina sacha alku kaug­sa­na­kus­ka­sina­ma­mi kacha­na­kui­ki­chita. Chi­manda kam­kuna, iacha­kuna­sina alli­lla kawaspa, uiaspa, ruraspa purin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kam­kunata jiru iuiaspa kawa­na­kus­kata mana kawa­rin­gi­chi. Pai­kuna, kam­kunata apispa, justi­sia­kuna­pag­ma­mi apan­ga­kuna. Pai­kuna tanda­ri­diru wasi­kuna­pi­mi kam­kunata asu­tin­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kam­kuna nuka­wa kag­manda, atun mandag­kuna­pag­ma­mi puri­chin­ga­kuna, justi­siai rurai tukun­gapa. Chi­ura, pai­kunata i mana judíu kag­kuna­ta­pas­mi nuka­manda willan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—Justi­sia­kuna­pagma kam­kunata apa­ura, mana iapa iuia­na­kun­gi­chi: “¿Imasa­mi pai­kunata aini­ni?”. Ainin­gapa chaia­ura, kikin Santu Ispi­ri­tumi iuia­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kam kikin­kunapa iuiai­wa mana rima­na­kun­gapa kangi­chi­chu. Kam­kunapa Taita Diuspa Ispi­ri­tumi kam­kunata alli­lla rima­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Chi puncha­kuna sug­kuna, waugkindi­kuna­ta­mi kuan­ga­kuna, wañu­chii tukun­gapa. Chasa­lla­ta taita­kuna­pas, pai­kunapa wam­bra­kuna­ta­mi wañu­chin­gapa kuan­ga­kuna. Wam­bra­kuna­pas, taita i maman­dita kuntra tukuspa, wañu­chin­ga­pa­mi kuan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tukui­kuna­mi kam­kuna­wa rabia­rin­ga­kuna, kam­kuna nuka­wa kag­manda. Chasa pasa­na­kuspa­pas, wañun­kama nuka­lla­wa iuia­rispa kag­kuna­mi kispi­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Kam­kuna kaska pui­blupi mana alli­lla ruran­gapa maskai kalla­rigpi­kunaka, sug pui­bluma miti­kun­gi­chi. Kasa­mi nuka nii­ki­chita: kai Israel alpapi tukui pui­blu­kunama kam­kuna manara chaiag­rigpi­mi kai Runa Tukuska ikuti samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Ñi mai­kan iachai­kug­kuna, iacha­chi­kuska­manda mas iacha mana kan­kunachu. Chasa­lla­ta ñi mai­kan lutrin­kuna­pas, paipa taita­kuna­manda mas mana kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iachai­kug­kunata iacha­chigta­sina suma kawagpi­kuna, alli­lla­mi kantra. Chasa­lla­ta, lutrin­kunata kikinpata­sina suma kawagpi­kuna, alli­lla­mi kantra. Nuka­taka wasi duiñu­sina­ta­mi kami­wan­kuna, kasa nispa: “Beel­zebú suti iaia kuku­wa­mi kangi”. Chasa nukata kami­wagpika, mas­char nuka ima nis­kata rurag­kunata kami­puan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Chi runa­kunata mana man­chan­gi­chi. Mai­kan pakalla iuiaspa rimas­kaka, ima­ura­pas­mi iacha­rí. Chasa­lla­ta, ima pakalla waka­chiska­pas­mi ima­ura­pas kawa­rig­samú. ");
INSERT INTO inb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nuka tutapi kam­kunata ima nis­kata punchapi willan­gi­chi. Chasa­lla­ta, ima pakalla uias­ka­ta­pas wasi awa­manda sin­chi kapa­rispa willan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Kam­kunapa kuir­puta wañu­chispa, kam­kunapa almata mana puchu­kan­gapa kan­kunachu. Chi­manda, ñi ima mana pai­kunata manchai­chi. Chasa­paka, Taita Dius dil­tudupa ninama kuir­puta alma­wanta sitan­gapa kag­manda, paita manchan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—¿Manachu iskai pisku, asllita kulki­manda­lla katu­rí? Chasa kagpi­pas, kam­kunapa Taita Dius mana lisin­siagpika, ñi sug pai­pura manachar wañuntra. ");
INSERT INTO inb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kam­kunapa uma­manda agcha­pas, Taita Dius kuin­taskami iuká. ");
INSERT INTO inb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chi­manda kam­kuna, mana man­chaspa­lla kaug­sai­chi. Mai­tuku achka pisku­kuna­manda­pas mas balimi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Mai­kan­pas, sug­kunapa ñawipi nuka­manda willa­chu: “Paita rigsi­nimi”: nuka­pas, chi runa­mandaka nuka­pa Taita suma luarpi kagpa ñawipi willa­sami: “Paita rigsi­nimi”. ");
INSERT INTO inb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ikuti mai­kan­pas, sug­kunapa ñawipi nuka­manda nichu: “Paita mana rigsi­nichu”: nuka­pas, pai­mandaka nuka­pa Taita suma luarpi kagpa ñawipi ni­sami: “Paita mana rigsi­nichu”. ");
INSERT INTO inb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Mana iuia­na­kui­chi nuka kai alpama samugta, tukui sumag­lla kaug­sa­na­kun­gapa. Mana chasa­manda samurka­nichu. Nuka samug­manda, maka­na­kug­sina­mi tian­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nuka samug­mandami taitan­di­wa wam­brandi­wa mana alli­lla kaug­sa­na­kun­gapa ka. Chasa­lla­ta, mamandi­wa warmi wam­bran­di­wa, suigran­di­wa nuiran­di­wa mana alli­lla­mi kaug­sa­na­kun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kikinpa wasipi kaug­sa­na­kug­pura llaki­chi­na­kuspa­mi kan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Mai­kan­pas taitata i mamata nuka­manda mas kuiagpika, mana nuka­pa ni­raian­kunachu. Chasa­lla­ta mai­kan­pas wam­brata nuka­manda mas kuiag­kunaka, mana nuka­pa ni­raian­kunachu. ");
INSERT INTO inb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mai­kan­pas mana paipa krusta marka­rig­sina ruraspa kati­raia­wag­kunaka, mana nuka­pa ni­raian­kunachu. ");
INSERT INTO inb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—Mai­kan kikinpa kaug­saita kispi­chinga­paglla iuia­kugpika, kikinmi puchuka­rin­gapa ka. Ikuti mai­kan­pas nuka­manda wañu­chii tukug­pika, mana mas wañui kaug­sai­ta­mi tarin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Mai­kan­pas kam­kunata chaskig­kuna, nuka kikinta chaski­wagmi ni­raian­kuna. Chasa chaski­waspaka, nukata kacha­mu­wag­ta­pas­mi chaskig ni­raian­kuna. ");
INSERT INTO inb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Mai­kan­pas Santu Ispi­ri­tu­wa rimag runata chaskig­pika, imasa­mi Santu Ispi­ri­tu­wa rimagta karanga: chasa­lla­ta­mi pai­ta­pas karan­gapa ka. Chasa­lla­ta, mai­kan­pas alli runata chaskig­pika, imasa­mi Taita Dius, alli runata karanga: chasa­lla­ta­mi pai­ta­pas karan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kasa­mi nuka nii­ki­chita: kai uchulla­kuna nukata kati­raia­wag­kuna kag­manda, pai­kuna­ta­pas mai­kan­pas sug kuashag chiri iaku­lla­pas karagpika, Taita Dius chi runa­manda mana kunga­rin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesuska, chunga iskai pai­ta kati­raiag­kunata tukui iacha­chispaka, rirka, chi suiu pui­blu­kunapi iacha­chispa i willaspa purin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista, karsilpi wichka­raiaspa, Jesu­cristo ima rura­kuska­manda iachaspa, paita kati­raiag­kunata Jesus­pagma kacharka. ");
INSERT INTO inb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Chi runa­kunaka, Jesusta tapug­rir­ka­kuna: —¿Kamchu kangi chi samun­ga­pa kaska? Mana kagpika, ¿sugta­chu suia­sun­chi? ");
INSERT INTO inb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Chi­ura, Jesuska ainir­ka­kunata: —Juanta willag­rii­chi kam­kuna kuna­ura imasa uiaska i kawas­kata. ");
INSERT INTO inb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mana ñawi kawag­kuna kawa­na­kumi. Mana purig pudig­kuna­pas alli­lla­mi puri­nakú. Aicha ismui ungui iukas­ka­kuna­pas­mi ambi­rig­samuska kan­kuna. Mana uiag­kuna­pas­mi alli­lla uia­nakú. Wañus­ka­kuna­pas­mi kaug­sa­ri­nakú. Mana ñi ima iukag­kuna­pas­mi Alli Willai­ta chaski­nakú. ");
INSERT INTO inb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mai­kan nuka­manda suma iuiaita mana sakig­pika, Taita Diuspa iapa kuias­kami kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan kachas­ka­kuna ikuti pai­pagma­lla­ta­ta kuti­na­ku­ura, Jesuska chipi kag­kunata Juan­manda nirka: —Kam­kuna, chusa sitaska alpa­pi Juan kaska­ma chaiag­rispaka, ¿imatak kawag­rirkan­gi­chi? ¿Sug wiru waira­wa paki­chinga­sina kuiu­chi­kus­ka­ta­sina­chu kawag­rirkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mana kagpika, ¿imatak kawag­rirkan­gi­chi? ¿Sug runa iapa suma musu katanga chura­ris­ka­tachu tarig­rirkan­gi­chi? Manima. Chasa suma chura­rig­kuna, mandag­kunapa wasi­kuna­lla­pi­mi kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Chasa kagpika, ¿imatak kawag­rirkan­gi­chi? ¿Santu Ispi­ri­tu­wa rimag­tachu tarig­rirkan­gi­chi? Ari, niiki­chitami: Santu Ispi­ri­tu­wa ñug­pa­manda rimag­kuna­manda­pas, Juan mas atunmi ka. ");
INSERT INTO inb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pai­mandami kasa ni­raiá: Kawai. Nuka ima nis­kata willagta kamba ñug­pa­mi kacha­kuni, kam­manda ñambi­kunata alli­chipun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kasami nuka nii­ki­chita: kai alpa­pi tukui tiag­samus­ka­kuna­manda, Juan­lla­mi mas atun ka. Chasa kagpi­pas, Dius suma manda­kus­kapi mai­kan mas uchu­lla­pas, Juan­manda mas atunmi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—Juan Bautista kawa­riska­ura­manda­ta kunan­kama, Diuspa suma mandai­manda willag­kuna tukui llakiimi iukan­kuna. Chi llaki­chig­kuna muna­na­kumi, chi suma mandai­manda willaita puchu­kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan kawa­rin­kama, tukui Santu Ispi­ri­tu­wa rimag­kuna i Moisés ima ruran­gapa iacha­chis­ka­pi­pas­mi willa­na­kurka, chi suma mandai samun­gapa kagta. ");
INSERT INTO inb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kam­kuna suma iuiaipi chaskin­gapa munagpi­kuna, pai Juanka ni­raianmi Elías suti Santu Ispi­ri­tu­wa rimag samun­gapa niska pai kagta. ");
INSERT INTO inb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Kai puncha­kuna kaug­sa­na­kuska runa­kunata, ¿imasa kag­tatak nisa? Sug wam­bra­kuna kalli­pi tia­rispa puglla­na­kug­sina­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Chipika, pai­pura kapa­ri­nakú: “Nukan­chi flaugta uia­chigpi­pas, mana bailangi­chi­chu. Lla­kispa kantagpi­pas, mana wakangi­chi­chu”. ");
INSERT INTO inb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Chasa­lla­ta, Juan Bautista­manda i nuka­mandami riman­kuna. Juan mana tanda mikug­manda, mana binu upiag­mandami nin­kuna: “Kai runa, kuku waira iaikuskami ka”. ");
INSERT INTO inb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kai Runa Tukuska, tukui mikuspa i upiaspa kag­manda, nin­kunami: “Iapa miku­dur i iapa upia­durmi ka. Mana judíu kas­ka­kuna­manda kulki chaskig­kuna­wa i mana alli rurag­kuna­wa sug­lla­pi­mi puri­ku”. Chasa kawaspa nigpi­kuna­pas, Taita Diusmi kawa­chí, pai kikin ruras­ka­wa iapa iachag kagta. ");
INSERT INTO inb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chasa nispaka Jesús, pai achka suma mana ima­ura­pas kawas­ka­sina ruraska pui­blu­kuna­manda runa­kuna­ta­mi piñai kalla­rirka. Tukui chasa­kunata kawaspa­pas, alli­lla rurai­kunama mana tigraska­mandami piñarka. ");
INSERT INTO inb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kasa­mi nir­ka­kunata: —¡Ai, kam­kuna Korazín suti pui­blupi kaug­sag­kuna! ¡Ai, kam­kuna Betsaida pui­blupi kaug­sag­kuna! Tiro i Sidón suti pui­blu­kuna­manda runa­kuna, imasa kam­kunapa pui­blu­kunapi chi­tuku mana ima­ura­pas kawas­ka­sina ruras­kata kawas­paka, chi­ura­lla­mi pai­kunaka, llakii­wa iana katan­ga­kuna chura­rispa, uchpa­wa umapi arma­rispa, alli rurai­kunama tigraska kantra­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kasa­mi nii­ki­chita: Taita Dius justi­siai ruran­gapa puncha chaia­uraka, Tiro i Sidón pui­blu­kuna­manda runa­kunata llaki­chiska­manda masmi kam­kuna llakii iukan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Kam­kuna, Kafarnaum pui­blu­manda­kunaka, ¿imapatak iuia­na­kun­gi­chi: “Sug luar­pi­mi atun­ia­chii tukun­gapa kani”? Manima. Dil­tudupa nina­ma­mi sitai tukun­gapa kan­gi­chi. Sodoma suti pui­blupi kaug­sa­na­kus­kaka, imasa kam­kunapa pui­blupi chi­tuku mana ima­ura­pas kawas­ka­sina ruras­kata kawas­paka, pai­kuna alli rurai­kunama tigraspa­mi kunan­kama kan­gapa kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kasa­mi nii­ki­chita: Taita Dius justi­siai ruran­gapa puncha chaia­uraka, Sodoma alpa­manda runa­kunata llaki­chiska­manda masmi kam­kuna llakii iukan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chi­ura Jesús, kasa­mi Taita Diusta nirka: —Taitiku, suma luar i kai alpa luarta iaia mandagmi kangi. Kamta iapa suma atun kag­ta­mi niiki. Kam­bagma iaikug­rin­gapa, iacha i iapa iuiai­iug runa­kuna­manda pakas­ka­sina­mi ka­pungi. Ikuti mana iacha i mana iapa iuiai­iug­kuna­ta­mi kawa­chirkangi. ");
INSERT INTO inb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari, Taitiku, chasa­mi kam munarkangi. ");
INSERT INTO inb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kasapasmi Jesús nirka: —Nuka­pa Taita, tukuimi nuka­ta kara­waska ka. Paipa wam­bra nuka kagta, ñi mai­kan runa­pas mana iachan­kunachu. Nuka­pa Taita­lla­mi rigsi­wá. Chasa­lla­ta, nuka­pa Taitata mana pipas rigsin­kunachu. Nuka­lla­mi rigsi­ni, paipa wam­bra kaspa. Mai­kan nuka munas­ka­kuna­lla­mi nuka­pa Taitata rigsin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Tukui­kuna saikui­wa i llakii­wa kag­kuna, nuka­wa samui­chi. Nukami tukuipi sama­chi­sa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wagra­kunapa iugu churas­ka­sina nuka ima iacha­chis­kata chaskii­chi. Nukata iachai­ku­wai­chi, nuka imasa uchulla­kuna­sina sumag­lla iuiag, mana subirbi ima­pipas kas­kata. ");
INSERT INTO inb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nuka ima iacha­chiska, mana llasa iugu churas­ka­sina­mi ka. Chi­wanka, nukata iachai­ku­waspaka, kam kikin­kunapa almapi alli iuia­chi­riimi tarispa iukan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sug warda puncha, Jesús kati­raiag­kuna­wanta chagra tarpu­raias­ka­kunapi iali­na­kurka. Kati­raiag­kunaka, iapa iarkai­manda kaspa, trigu ispiga­kunata pitispa, mikui kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Chasa kawas­paka, sug fari­seo­kuna Jesusta nir­ka­kuna: —Kawa­mui. Kamta kati­raiag­kuna, warda punchami panda­ri­nakú. ");
INSERT INTO inb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesuska ainir­ka­kunata: —¿Manachu ñug­pa­manda li­bru­pi willa­raias­kata kawarkan­gi­chi, taita David i pai­wa kag­kuna­pas, iarkai­manda kaspa, imasa ruragta­kuna? ");
INSERT INTO inb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pai kikin, Diuspa wasi ukuma iaikuspa, altarpi chu­raska tanda­kuna tias­kata mikurka, mana imapas mancha­rispa­lla. Chi tanda­kuna, sasir­duti­kunalla miku­dirumi karka. Ñi pai­wa kag­kunata ñi pi­ta­pas mana kara­diru karkachu. ");
INSERT INTO inb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Moisés ima ruran­gapa nis­kapi, ¿manachu kawarkan­gi­chi imasa willa­raias­kata? Kasa­mi ni­raiá: ianga puncha­sina sasir­duti­kuna warda puncha Diuspa atun wasipi imasa ni­raias­ka­sina ruraika, mana panda­rii ni­raianchu. ");
INSERT INTO inb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kasa­mi nii­ki­chita: kuna­ura Diuspa atun wasi­manda­pas mas atunmi kaipi ka. ");
INSERT INTO inb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—Kasami ñug­pa­manda librupi ni­raiá: Mana muna­nichu kam­kuna, nuka­manda animal­kunata wañu­chispa rupa­chi­puan­gapa. Kam­kuna sug runa­kuna­manda llakispa kaug­sa­na­kun­ga­pa­mi muna­ni. Chi willa­raias­kapi alli­lla kawaspa iachaspaka, nukata kati­raia­wag­kuna­manda manami ni­wan­gi­chi: “Warda punchami panda­ri­nakú”. ");
INSERT INTO inb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kai Runa Tukus­kaka pudinmi ninga, warda puncha­kuna­ta­pas imasa chaias­ka­sina ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chi­manda rispaka, pai­kuna tanda­ri­diru wasipi iaikug­rirka. ");
INSERT INTO inb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chipika sug maki chaki­riska ungui­wa kag runa, pai­kuna­wa sug­lla­pi karka. Chi­ura, Jesusta tapur­ka­kuna: —Warda punchapas ungug­kunata alia­chin­gapa, ¿pudi­rinchu u mana?—. Chasa tapu­chi­na­kurka, pai­manda justi­sia­kuna­pagma willag­rin­gapa. Jesuska ainir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—Kam­kunapa ubija sanjapi urmag­pika, ¿manachu warda puncha kagpi­pas surkuntran­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sug runaka, ubija­manda­pas mas balimi ka. Chi­mandami mana michá, warda puncha­kuna tukui alli ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Chasa nispa, chi ungug runa­taka nirka: —Maki chuta­chii. Chasa chuta­chig­lla­pi, chi makika aliarka, sug ladu maki­sina. ");
INSERT INTO inb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Chasa kawaspa fari­seo­kunaka, llugsispa, Jesus­manda rima­na­kui kalla­rir­ka­kuna, imasa­pipas paita wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesuska, chasa iachaspa, chi­manda anchu­rirka. Achka runa­kuna­mi paita kati­chi­na­kurka. Paika, tukui ungug­kuna­ta­mi am­bispa sakirka. ");
INSERT INTO inb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chasa ambis­paka, nir­ka­kunata: —Nuka­manda mana willa­na­kun­gi­chi, nuka pi kagta. ");
INSERT INTO inb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chasami Isaías suti Santu Ispi­ri­tu­wa rimag ima ñug­pata willas­ka­sina tukug­samurka. Kasa­mi Isaías niska karka: ");
INSERT INTO inb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Kaimi ka nuka­pa lutrin­sina, nuka imasa nis­kata rurag. Paimi nuka agllaska i kuiaska kapuá. Paita kawaspa, iapa­mi alli iuia­chii­wa kawani. Nuka­pa Santu Ispi­ri­tu­ta­mi paita karan­gapa kani. Chi­wanka, tukui alpa­manda runa­kuna­ta­mi pai willan­gapa ka, nuka imasa alli­lla justi­sian­gapa kagta. ");
INSERT INTO inb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mana pi­wapas piña­rispa kapa­rispa kan­gapa kanchu. Ñi mai­pipas, pi­ta­pas mana kapa­rispa riman­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wiru paki­ri­kus­kata mana paki­chin­gapa kanchu. Wañu­kug­sina kusni­kuska michun­ta­pas mana wañu­chin­gapa kanchu, ima­ura tukui­kunata sumag­lla mandai chaian­kama. ");
INSERT INTO inb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pai­llatami tukui alpa­manda runa­kuna suia­na­kun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chi puncha­kuna­lla­ta­ta, sug runata kuku waira iaikuska kag­mandami Jesus­pagma pusar­ka­kuna. Chi runata kuku waira mana kawan­gapa i riman­gapa rurag­samuska karka. Jesús ña ambi­ura, chi runa ikuti riman­gapa i kawan­gapa alli­lla tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chasa kawaspaka, achka chipi kag­kuna, iapa ujna­rispa­mi kikin­pura tapu­ri­na­kurka: —Chi ambig runa, ¿manacha ñug­pa­manda taita Davidpa wam­bra­kunapa wam­bra kantra? ");
INSERT INTO inb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fari­seo­kunaka, chasa uiaspa, nir­ka­kuna: —Chi, Beelzebú suti iaia kukupa iachai­wa­mi kuku waira­kunata llugsi­chi­ku. ");
INSERT INTO inb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pai­kuna ima iuia­na­kus­kata iachaspa, Jesuska nir­ka­kunata: —Sug alpapi mandag­pura piña­chi­na­kuspa maka­na­kuspa­lla kaug­sa­na­kugpika, tukuimi waglli­rí. Sug pui­blupi u wasipi piña­na­kuspa­lla kaug­sa­na­kugpika, mana alli­lla kan­gapa kanchu, sumag­lla sug­lla­pi kaug­sa­na­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chasa­lla­ta iaia kuku­wa kag­kuna iaia kuku­wa kag­kunata llugsi­chigpi­kunaka, kikin­pura piña­chi­ri­na­kug­sina­mi ni­raiantra. Chasa piña­chi­ri­na­kugpika, ¿manachu pai­pura mandai, chi­ura­lla puchuka­rintra? ");
INSERT INTO inb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—Beelzebupa iachai­wa nuka kuku waira­kunata llugsi­chi­kugpika, kam­pura­kunaka, ¿pipa iachai­watak llugsi­chin­kuna? Pai kikin­kuna­mi kawa­chin­gapa kan­kuna, imasa kam­kuna mana alli­lla nuka­manda iuia­rispa ni­na­kugta. ");
INSERT INTO inb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Taita Diuspa Ispi­ri­tu­wa nuka kuku waira­kunata llugsi­chi­kugpika, sutipa­mi Diuspa suma mandai ña kam­kuna­pagma chaia­murka. ");
INSERT INTO inb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Mai­kan­pas sug wapu runa­pa wasima iaikuspa, ima iukas­kata kichun­gapa munaspa, iukanmi ñug­pa paita watanga. Mana kag­pika, manima kichun­gapa pudin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Mai­kan­pas mana nuka­wa suma iuiai­wa kag­kuna, nukata piña­wagmi kan­kuna. Chasa­lla­ta, mai­kan­pas nuka­wa mana suma tanda­chig­kuna, tukuimi susu­ri­puan­gapa kan­kunata. ");
INSERT INTO inb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Chasa­manda niiki­chitami: runa­kuna panda­ris­ka­kunata i Taita Dius­manda iapa jiru mana uianga­sina rimaska panda­ris­ka­kunata, tukui­ta­mi pasin­siai tia. Ikuti mai­kan Santu Ispi­ri­tu­manda iapa jiru­kuna rimas­kataka mana pasin­siai tian­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kasa­pas­mi nii­ki­chita: mai­kan kai Runa Tukuska­manda kuntra rimag­kuna­manda pasin­siaimi tia. Chasa kagpi­pas, mai­kan Santu Ispi­ri­tu­manda kuntra rimag­kuna­manda ñi ima­ura­pas mana pasin­siai tian­gapa kanchu, ñi kai alpa luarpi ñi sug luarpi. ");
INSERT INTO inb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Sacha alli kagpi, miski miku­diru muiumi tukú. Sacha mana alli kagpika, winja muiu mana miku­dirumi tukú. Tukui sacha, muiu­kuna tia­ri­ura­mi rigsirí, alli u mana alli kagta. ");
INSERT INTO inb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kam­kunaka, kuli­bra­kuna­sina­mi mana alli runa­kuna kan­gi­chi. Kam kikin­kuna mana alli iuiai­kuna iukaspa, ¿imasa­tak alli rimaita iukankan­gi­chi? Iuiaipi imasa iuia­na­kus­ka­sina­mi simipi rima­chig­samú. ");
INSERT INTO inb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","—Alli runa­kuna, alli iuiai­kuna iukaspa­mi alli­lla rimag­samun­kuna. Ikuti mana alli runa­kunaka, mana alli iuiai­kuna iukaspa­mi mana alli­lla rimag­samun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kasa­mi nii­ki­chita: Taita Dius justi­siai ruran­gapa puncha chaia­ura, tukui ianga rimas­ka­ta­pas tapu­chin­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chasa tapu­chi­ura, kam­kuna alli­lla rimaska kagpika, allimi ni­raian­gapa kan­gi­chi. Mana alli­lla rimaska kagpika, justi­siaimi tukun­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chi­uraka Moisés ima nis­kata sug iacha­chig taita­kuna i fari­seo­kuna, Jesusta nir­ka­kuna: —Iacha­chig taita, muna­na­kun­chimi: kam nukan­chita mana ima­ura­pas kawas­ka­sinata kawa­chi­mui. ");
INSERT INTO inb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Paika ainirka: —Kam­kuna Taita Diusta mana iuia­rispa, mana alli­lla ruraspa kaug­sa­na­kuspa­mi maña­wa­nakun­gi­chi: “Mana ima­ura­pas kawas­ka­sinata kawa­chi­mui”. Ñi imapas mana kam­kuna munas­ka­sina kawan­gapa kangi­chi­chu. Ñug­pa­manda Santu Ispi­ri­tu­wa rimag Jonás suti, imasa­mi pasarka: chasa­lla­ta kawa­ri­lla­mi kawan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Imasa­mi Jonás, kimsa puncha i kimsa tuta atun chalwapa wigsa ukupi karka: chasa­lla­ta­mi kai Runa Tukuska, kimsa puncha i kimsa tuta alpa ukuma kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Taita Dius justi­siai ruran­ga­pa puncha chaia­ura, Níneve pui­blu­manda kag­kuna saia­rispa­mi kuna­ura­manda runa­kunata nin­ga­pa kan­kuna: “Mana alli­lla rurag­kuna­mi kan­gi­chi”. Chi Nineve­manda runa­kuna, Jonás ima willas­kata uiaspaka, alli rurai­kuna­ma­mi tigrar­ka­kuna. Kai rima­kug­ka, Jonas­manda­pas mas iachami ka. ");
INSERT INTO inb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Chasa­lla­ta, Taita Dius justi­siai ruran­gapa puncha chaia­uraka, Chaugpuncha suti alpata mandag warmipas saia­rispa­mi kuna­ura­manda runa­kunata nin­gapa kan­kunata: “Mana alli­lla rurag­kuna­mi kan­gi­chi”. Ñug­pata chi warmi, iapa karu alpa­mandami samurka, atun mandag Salomonpa iapa iachai­wa rima­kus­kata uian­gapa. Kai rima­kug­ka, Salomon­manda­pas mas iachami ka. ");
INSERT INTO inb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Mai­kan runa­manda kuku waira llugsi­chii tukus­kaka, tusta alpa kas­kapi sama­rin­ga­pa­mi mas­kaspa purirka. Ñi maipi mana sama­rin­gapa tarispaka, ");
INSERT INTO inb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","iuia­rirkami: “Mai­mandami nuka llugsi­murkani: chima­lla­ta­ta­mi kutin­gapa kani”. Chi runa­pagma kutispa ikuti iaikug­ri­ura, chusa uku suma pichaska i alli­chis­ka­sina­mi tarig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Chasa kawas­paka, kan­chis kuku waira­kuna pai­manda mas jiru rura­dur­kunata pusan­ga­pa­mi rirka. Chi runapi iaikug­rispa, chi kuku­kuna kaug­saimi kalla­rir­ka­kuna. Chasaka chi runa, ñug­pa­manda­pas mas jiru mana alli­lla­mi tukuipi tukurka. Kai puncha­kuna mana alli­lla ruraspa kaug­sa­na­kugta chasa­lla­ta­mi tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chara chipi kag­kunata rima­kun­kamaka, paipa mama i waug­kindi­kuna kancha ladu saia­rig­rir­ka­kuna, paita riman­gapa munaspa. ");
INSERT INTO inb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chi­ura sug runa, paita nig­rirka: —Uiamui. Kamba mama i waug­kindi­kuna­mi kanchapi suia­nakú, kamta riman­gapa. ");
INSERT INTO inb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Paika, chi runata ainirka: —¿Pitak nuka­pa mama ni­raiá? ¿Pi­kunatak ni­raian­kuna nuka­pa waug­ki­kuna? ");
INSERT INTO inb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chasa nispa, paita kati­raiag­kunata maki­wa kawa­chispa, nir­ka­kunata: —Kaikunami nuka­pa mama, nuka­pa waugki­kuna kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nuka­pa Taita suma luarpi kag, pai imasa munas­ka­sina mai­kan­pas ruragmi nuka­pa waugki, nuka­pa pani, nuka­pa mama ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chi puncha­lla­ta­ta Jesús, wasi­manda llugsispa, kucha pata ladu tia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chi­ura iapa achka runa­kuna, pai­pagma chaiag­rir­ka­kuna. Chasa kawaspaka Jesus­ka, kanua ukuma iaikuspa, tia­rirka. Tukui chipi kag­kuna, iaku pata ladu saia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chi­ura Jesuska, iuiai apinga­sina achka suma parlu­kuna­wa iacha­chispa, kasa­mi nirka: —Sug runasi llugsirka, similla­kunata sitaspa tarpun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tarpu­ku­ura, sug similla­kunaka ñambipisi urmar­ka­kuna. Chi similla­kunataka, pisku­kunasi mikug­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Sug similla­kunaka, rumilla tias­kapisi urmar­ka­kuna, mailla alpa tias­kapi. Mana achka alpa tiag­manda, mana unailla wiña­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nigpika, indi piaspa, rupa­chirka. Mana achka angu­iug kas­paka, utkalla chaki­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","—Sug similla­kunaka, ispina sacha­kuna tias­kapisi urmar­ka­kuna. Nigpika, ispina sacha wiñarka, similla­kunata kilpagta. ");
INSERT INTO inb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","—Ikuti sug similla­kunakar, suma alpapisi urmar­ka­kuna. Chasaka, alli­lla palla­rir­ka­kuna. Sug similla­manda­lla, patsa patsasi palla­rirka. Sug­manda­lla, sugta chunga sugta chunga; ikuti sug­manda­lla, kimsa chunga kimsa chungasi palla­rirka. ");
INSERT INTO inb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chasa uiaspaka kati­raiag­kuna, Jesus­pagma kailla­iaspa, tapur­ka­kuna: —¿Imapatak chasa parlu­kuna­lla­wa runa­kunata rimangi? ");
INSERT INTO inb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chi­ura Jesuska, kasa ainirka: —Kam­kunata niskami ka, Taita Dius imasa suma manda­kus­ka­sina kas­kata ñi ima­ura­pas mana iachas­kata iachan­gapa. Ikuti pai­kunataka mana chasa lisinsiaska kanchu. ");
INSERT INTO inb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mai­kan achka iukagta mas­mi karan­gapa ka, puchugta. Mai­kan mailla iukas­kataka tukuimi kichun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chi­mandami iuiai apinga­sina parlu­kuna­lla­wa pai­kunata rimani. Pai­kuna, kawa­na­kuspa­pas, mana kawag­sina­mi kan­kuna. Uia­na­kuspa­pas, mana uiag­sina kaspa, mana iuiai apin­kunata. ");
INSERT INTO inb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pai­kuna chasa kag­mandami Isaías imasa ñug­pata willas­ka­sina tukug­samú. Kasa­mi ni­raiá: Rinri­wa uiaspa­pas, mana uiag­sina­mi tukunkan­gi­chi. Ñawi­wa kawaspa­pas, mana kawag­sina­mi tukunkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kai runa­kunapa iuiai, iana tutapi kag­sina­mi tukug­samur­ka­kuna. Rinri tapa­ris­ka­sina­mi tukug­samur­ka­kuna. Ñawi wichkas­ka­sina­mi tukug­samur­ka­kuna. Chasaka pai­kuna, mana ñawi­wa kawag­sina, mana rinri­wa uiag­sina, mana iuiai iukag­sina­mi tukun­gapa kan­kuna. Mana munan­kuna, nuka­wa tigramun­gapa. Tigramugpika, nukami ambintrani­kunata. ");
INSERT INTO inb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Ikuti kam­kunaka, ñawi­wa sumag­lla kawa­na­kuspa, rinri­wa alli­lla uiaspa kag­mandami Taita Diuspa iapa kuiaska kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kasa­mi nuka nii­ki­chita: ñug­pa­manda Santu Ispi­ri­tu­wa rimag­kuna i alli runa­kuna, achka­kuna­mi, kuna­ura kam­kuna kawa­na­kus­kata kawan­gapa muna­na­kuspa­pas, mana kawar­ka­kuna. Chasa­lla­ta, kuna­ura kam­kuna uia­na­kus­kata uian­gapa muna­na­kuspa­pas, manima uiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Kasa uiai­chi, tarpug runa­manda parlu imasa ni­raiagta. ");
INSERT INTO inb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dius imasa suma manda­kus­ka­sina rimaita mai­kan uiaspa­pas, mana iuiai alli­lla apis­kataka, chi uias­kata iaia kukuka tukuimi kichug­samú. Chasa­mi ñambipi similla urmag­kuna ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Similla rumilla tias­kapi urmag­ka, sug runa Diuspa Rimaita uiag­sina­mi ni­raiá. Chi uianga­lla­waka, alli iuia­chii­wa­mi chaskin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nispaka, imasa­mi chi mana achka angu­iug similla­kuna tukú: chasa­lla­ta sug ratu­lla­mi Taita Diuswa iuia­rispa kan­kuna. Ima Diuspa Rimai­manda unz̈agpi­kunaka, llakiimi apig­samú. Chi­ura­manda, mana mas Taita Diuswa iuia­rin­gapa munan­kunachu. ");
INSERT INTO inb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Similla ispina sacha­kuna tias­kapi urmagka, sug runa Diuspa Rimai­ta uiag­sina­mi ni­raiá. Uias­pa­pas, kai alpapi tias­ka­kuna­lla­wa sumag­lla kaug­san­ga­pa­mi iuia­rin­kuna, mas achka iukag tukun­gapa. Chasaka, Diuspa Rimaita tukuimi kunga­rin­kuna. Ñi ima mana pallan­gapa tia­ringa­sina­mi tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Similla suma alpapi urmag­kar, sug runa, Diuspa Rimai­ta sumag­lla uiaspa, iuiai apig­sina­mi ni­raiá. Chi runa­kuna­pi­mi ni­raiá, suma alpapi similla urmas­ka­manda, achka suma pallai tukun­gapa. Imasa­mi sug similla­manda­lla patsa patsa u sugta chunga sugta chunga u kimsa chunga kimsa chunga pallarí: chasa­lla­ta­mi pai­kuna, Taita Dius­manda alli­lla ruras­ka­kuna­wa achka palla­rig­sina tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kai iuiai apinga­sina suma par­lu­ta­pas, Jesús iacha­chir­ka­kunata: —Suma luar­manda mandai, kasa­mi ni­raiá. Sug runa, paipa cha­gra­pi alli simillasi tarpurka. ");
INSERT INTO inb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nigpika, tukui­kuna puñu­na­kun­kama, pai­wa mana munag runa cha­gra­pi iaikurka. Chi runaka, mana alli ugsa, trigu chaugpipi susu­chispasi rirka. ");
INSERT INTO inb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","—Trigu ña wiñaspa, granu kawa­rig­samu­uraka, mana alli ugsa­pas chapu wiñaska kawa­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Chasa kawaspaka piun­kuna, chagra­iug­pagma rispa, tapug­rir­ka­kuna: “Taita waugki, ¿mana­chu kam, alli similla tar­pur­kangi? ¿Mai­manda­sik mana alli ugsa llugsi­rirka?”. ");
INSERT INTO inb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—Chi­ura, paika ainirka: “Mana nukata muna­wag, chi runa­mi chasa rura­waska kan­gapa ka”. —Chasa uiaspaka, piun­kuna nir­ka­kuna: “Kam munagpika, nukan­chi chi ugsata surkug­ri­sun­chimi”. ");
INSERT INTO inb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Chi­ura, paika ainirka: “Manima. Ugsata surkugpika, tri­gu­ta­pas­mi surkunkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ianga kawai­chi, iskandi wiña­chu­kuna killuian­kama, pallai puncha chaian­kama. Chi punchaka, pallag­kuna­ta­mi nisa: ‘Ñug­pa, mana alli ugsa­ta tanda­chii­chi. Wangu ruran­gi­chi, ninapi rupa­chin­gapa. Triguta tanda­chispaka, nuka­pa trujapi chura­puan­gi­chi’.” ");
INSERT INTO inb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kai iuiai apinga­sina suma par­lu­ta­pas, Jesús nir­ka­kunata: —Suma luar­manda mandai, kasa­mi ni­raiá. Sug runa, paipa cha­grapi mustasa similla tarpug­sina­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Chi simillaka, tukui­kuna­manda­pas mas uchu­lla­mi ka. Ña wiñai puchuka­uraka, tukui mikui chagrapi tias­ka­kuna­manda­pas mas atunmi tukú. Sug puntu uchulla sacha­sina­mi tukú. Chasa­pika pisku­kuna­pas, malki­kunapi sumag­lla­mi wasi­chig­samun­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kai iuiai apinga­sina suma par­lu­ta­pas, Jesús nir­ka­kunata: —Suma luar­manda mandai, kasa­mi ni­raiá. Imasa­mi sug warmi, kimsa tasa arinata liba­dura­wa chapu­uraka, suma timbuspa, miraspa achkaiag­samú: chasa­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chasami Jesús, iuiai apinga­sina suma parlu­kuna­wa runa­kuna­ta rima­dur karka. Suma parlu­kuna­lla­wa­mi tukui iacha­chi­dur karka. ");
INSERT INTO inb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imasa­mi Santu Ispi­ri­tu­wa ñug­pata willaska karka: chasa­mi tukug­samurka. Kasa­mi niska karka: Iuiai apinga­sina suma parlu­kuna­wa­mi rimasa. Kai alpa tiag­samu­ura­manda­ta, mana pipas iachas­ka­ta­mi willasa. ");
INSERT INTO inb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chi­ura­manda Jesús, chi runa­kunata: “Kaia­kama” nispaka, wasi­ma rirka. Chi­ura paita kati­raiag­kunaka, kailla­iaspa, nir­ka­kuna: —Nukan­chita willai: mana alli ugsa chagrapi susu­chig­samuska­manda parlu, ¿imatak ni­raiá? ");
INSERT INTO inb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Chi­ura Jesuska, kasa­mi ainirka: —Alli similla tarpug runa, kai Runa Tukuska nuka kag­ta­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chagraka, kai alpa­mi ni­raiá. Alli simillaka, suma luar­manda mandai­wa kag runa­kuna­mi ni­raiá. Mana alli ugsaka, runa­kunalla­ta­ta iaia kuku­wa iuiag­kuna­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chagra­iugta mana munaspa mana alli ugsa susu­chig runaka, kikin iaia kukumi ni­raiá. Pallai punchaka, kai luarpi alpa puchu­ka­rin­gapa punchami ni­raiá. Pallag­kunaka, anjil­kuna­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","—Imasami mana alli ugsata tanda­chispa, ninapi rupa­chin­gapa chaiá: chasa­lla­ta­ta­mi kai luarpi alpa puchuka­rii puncha tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kai Runa Tukuskami paipa anjil­kunata kacha­mun­gapa ka. Pai­kuna­mi, tukui mana alli­lla ruras­ka­kunata i ima jiru panda­rii­kuna­pipas urma­chig­kunata nuka suma manda­kuska­manda llugsi­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nispaka, iapa atun nina rupa­kuska­ma­mi sitan­gapa kan­kuna. Chipi, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Alli­lla ruraska kag­kunaka, suma­ia­chiska kaspa­mi, pai­kunapa Taita Dius suma manda­kus­kapi indi­sina puncha­iag­rin­gapa kan­kuna. Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kasapasmi Jesús nir­ka­kunata: —Suma luar­manda mandai, achka kuri kulki alpa ukuma pam­baska tias­ka­sina­mi ni­raiá. Chi kuri kulkita, sug runa tarispaka, chi­lla­pita pakaspasi sakirka. Nispaka, iapa kun­tin­ta­rispa rirka. Tukui ima iukas­kata katuspa, chi alpa­tasi randirka. ");
INSERT INTO inb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Suma luar­manda mandai, sug iapa bali pirla­sina­mi ni­raiá. Sug suma pirla­kuna randispa purig runa, ");
INSERT INTO inb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","chi pirla iapa bali kag­manda kawaspaka, tukui pai ima iukas­ka­ta­pas katuspasi chi pirlata randig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Ikuti suma luar­manda man­dai, ata­raia atun kucha iaku ukupi sitag­sina­mi ni­raiá. Chi ata­ra­ia­wa imasa tiaska chalwa­kuna­mi api­rin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ña chalwa jundagta apis­ka­kunata patama llugsi­chispa, tia­rispaka, alli chalwa­kunata agllaspa, saparu­kuna­pi­mi waka­chin­kuna. Ikuti mana alli­kuna­taka sitan­kunami. ");
INSERT INTO inb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","—Chasa­llatami kai luarpi alpa puchuka­rin­gapa puncha, anjil­kuna samuspa, mana alli runa­kunata alli runa­kunapa ladu­manda anchu­chig­samun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nispaka, iapa atun nina rupa­kus­ka­pi­mi sitan­gapa kan­kuna. Chipi, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Chasa nispaka, Jesús tapur­ka­kunata: —Nuka kam­kunata tukui ima rimaska, ¿ñachu iuia­rin­gi­chi ima ni­raiagta? —Ari— ainir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Chi­ura, Jesuska nir­ka­kunata: —Mai­kan ñug­pata Moisés ima nis­kata iacha­chig taita, chasa­lla­ta suma luar­manda mandai­wa ni­raiagta iachai­kug­kunaka, kasa­mi ni­raiá. Imasa­mi sug runa, waka­chiska tias­kata iapa bali musu i maugka­kuna­ta­pas surkú, sug­kunata aidan­gapa: chasa­lla­ta­mi kuna­ura­manda i ñug­pa­manda Alli Willaita iacha­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús chi parlu­kunata iacha­chii puchukaska­mandaka, llugsispa, kikinpa pui­bluma rirka. ");
INSERT INTO inb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pai­pagma chaiag­rispaka, tanda­ri­diru wasima iaikuspa, iacha­chii kalla­rirka. Paita uiaspa, iapa ujna­rispa, kasa kikin­pura tapu­ri­na­kurka: —Kai runa, ¿ima­wa­sik chi­tuku suma iachai­wa tukurka? ¿Ima­wa­sik chi­tuku mana ima­ura­pas kawas­ka­sina rurai pudí? ");
INSERT INTO inb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Manachu ka kar­pin­tirupa wam­bra? ¿Manachu paipa mama, María suti ka? ¿Mana­chu Santiago, José, Simón i Judaspa waugkindi ka? ");
INSERT INTO inb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Mana­chu tukui paipa panindi­kuna­pas, nukan­chi­wa kan­kuna? ¿Maipi­sik chi­tuku iachai­kug­rirka?—. ");
INSERT INTO inb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Chasa nispaka, Jesusta mana munar­ka­kuna, pai ima iacha­chi­kus­kata uian­gapa. Mana uiag­manda­kuna, Jesuska kasa­mi nir­ka­kunata: —Santu Ispi­ri­tu­wa rimagtaka sug­nigta puris­kapi sumag­lla kuias­pa­mi uian­kuna. Ikuti kikinpa alpa­pi, kikinpa wasipi, ñi pi mana munan­kunachu uian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chi runa­kuna mana paita suma uiag­manda, Jesús chi pui­blupi mana achka milagru­kuna rurarka. ");
INSERT INTO inb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chi puncha­kuna mandag Herodes, Jesus­manda iachag­samurka. ");
INSERT INTO inb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chasa iachaspaka, pai­wa kag­kunata nirka: —Chimi kan­gapa ka Juan Bau­tista. Wañuspaka, ikuti kaug­sa­riskami kan­gapa ka. Chi­manda­mi mana ima­ura­pas kawas­ka­sina ruraspa puri­ku. ");
INSERT INTO inb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Manara Jesus­manda iacha­rigpi, Herodes, Juanta api­chispa, wataspa, karsilpisi chu­rarka. Erodías suti warmipa kaug­sasi chasa rurarka. Chi warmi karkasi Felipepa warmi. Chi Felipe, Hero­despa waugkisi karka. Chi warmika, Herodeswasi kaug­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chi­mandasi Juanka, Hero­desta piñaspa ni­kurka: “Kamta michan­mi, chi warmi­wa kaug­sa­kun­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chasa piña­kug­manda Hero­des, Juanta wañu­chin­gapasi muna­kurka. Nigpika, chi alpapi kaug­sa­na­kuska runa­kunata manchai iukarka. Chi runa­kuna, Juan­manda ni­na­kurka: “Santu Ispi­ri­tu­wa rimagmi ka”. ");
INSERT INTO inb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodes tiag­samuska puncha chaia­uraka, pai kunbidaspa upiaisi rura­kurka. Chipika, Erodiaspa sipas warmi wam­bra, iapa sumasi bailarka. Chasa bailag­manda, Hero­desta iapasi sumarka. ");
INSERT INTO inb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chi­ura paika, sipasta nirka: —Diuspa ñawipimi niiki: kam ima maña­waskami karasaki. ");
INSERT INTO inb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chasa uiaspaka, mamandita willag­rirka. Mamandi nirka: —Juan Bautistapa umata pla­tu­pi mañai—. Chi­wanka, Hero­desta chasa mañag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mana pai iuia­kus­ka­sina mañag­manda, iapasi llaki­rig­samurka. Kikin, Taita Diuspa ñawi­pi nis­kata pai­wa kag­kuna uia­na­kug­manda, iukarka ninga: —Ari—. ");
INSERT INTO inb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chasa nispaka, sug sul­daduta karsilmasi kacharka. Juanta uma anchu­chig­rispaka, ");
INSERT INTO inb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","pla­tupi apaspa, sipastasi kuag­rirka. Sipas, chaskispa, maman­di­tasi kuag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juanwa purig­kuna, chasa pasa­rigta iachaspaka, kuir­puta apag­rispa, pambag­rir­ka­kuna. Nis­paka, Jesusta willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan­manda chasa uiaspaka, Jesús, mai­kan runapas mana kaug­sa­na­kuska alpama kanuapi rirka, sapalla kan­gapa. Chasa iachaspaka achka runa­kuna, chi pui­blu suiu­manda chaki­wa pai kaska­ma rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús kanua­manda llugsi­ura, iapa achka runa­kuna kawa­rirka. Pai­kunata kawaspa, suma llaki­rig­samurka. Pai­kuna­wa ungug kas­ka­kuna­ta­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ña chisia­ku­uraka, Jesusta kati­raiag­kuna, kailla­iaspa, nir­ka­kuna: —Kai suiu, ñi pipas mana kaug­sa­na­kunchu. Ñami chisi ka. Kai runa­kunata pui­blu­kunama kachai, mikui randispa miku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesuska nir­ka­kunata: —Mana chaianchu, pai­kuna rin­gapa. Kam­kuna, pai­kunata mikui karai­chi. ");
INSERT INTO inb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pai­kunaka ainir­ka­kuna: —Pichka tanda i iskai chalwa­lla­mi kaipi tia. ");
INSERT INTO inb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chi­ura, Jesuska nirka: —Apa­mu­wai­chi. ");
INSERT INTO inb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nispaka, chipi kag­kunata nirka: —Ugsapi tia­rii­chi. Tia­ri­ura, chi pichka tandata i iskai chalwata chari­rispa, awa­sina­ma kawaspa, “Pai Siñur” Taita Diusta nirka. Tanda­kunata piti­chispaka, kati­raiag­kunata kuaspa richirka. Chi­ura, tukui­kunata karaspa apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tukuikunami sagsagta mikur­ka­kuna. Nispaka, chunga iskai saparu junda piti piti­kuna tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mai pichka waran­ga kari­kuna­mi mikur­ka­kuna, warmi i wam­bra­kunata mana kuintaspa­lla. ");
INSERT INTO inb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chi­ura­lla Jesuska, paita kati­raiag­kunata nirka: —Kanuama iaikui­chi. Sug ladu chimba ialii­chi. Nukaka, kai tukui runa­kunata: “Kaia­kama” nispa, kacha­sa­kunata—. ");
INSERT INTO inb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chi runa­kuna­ta kachaspaka, sug lumama rirka, sapalla, paipa Taita Diuswa rima­na­kun­gapa. Chi tutaka Jesús, sapa­lla chi lumapi karka. ");
INSERT INTO inb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kati­raiag­kunaka, ña karupi alpa­manda ri­na­kurka. Iapa sin­chi waira, ñug­pag­nig­manda puku­kurka. Chi­wanka, kanuata awapi urapi iaku apa­kurka. ");
INSERT INTO inb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ña paka­ringama Jesús, chi iaku­pi awalla chaki­wa saruspa sarus­pa, pai­kuna­pagma ña chaia­kug­rirka. ");
INSERT INTO inb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pai­kunaka, chasa iaku­pi saruspa awalla ri­kugta kawaspa, iapa mancha­rispa, nir­ka­kuna: —Sug wairachar ka—. Iapa man­cha­rispa­mi kapa­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kapa­rig­lla­pi, Jesuska nir­ka­kunata: —Sin­chi iuiai­chi. Nukami kani. Mana mancha­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Chi­ura, Pedroka nirka: —Kam kikin Taita Jesús kag­pika, ni­wai, nuka­pas iakupi chaki­wa kam­bagma rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Samui— Jesús nirka. Chasa ni­ura Pedroka, kanua­manda llugsispa, chaki­wa iakupi rii kalla­rirka Jesus­pagma. ");
INSERT INTO inb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Chasa ri­ku­ura, sin­chi waira pia­kug­manda, iapa mancha­rirka. Nispaka, ri­kuska iaku ukuma junda­rii kalla­rispa, kapa­rirka: —Taita waugki, kispi­chi­wai. ");
INSERT INTO inb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kapa­rig­lla­pi Jesuska, maki suniaspa, Pedrota apispa, kasa­mi nirka: —Kam, ¿imapatak nuka­manda mana mas suma alli­lla iuia­ringi? ");
INSERT INTO inb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pai­kuna ña kanuama iaikug­ri­uraka, waira kasillaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kanuapi kag­kunaka, Jesusta kungu­rispa, nir­ka­kuna: —Kam sutipami Taita Diuspa wam­bra kangi. ");
INSERT INTO inb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kucha ialispaka, sug ladu chim­ba Jenesaret suti alpama chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chi­manda runa­kunaka, Jesusta rigsispa, tukui­ma parlu willar­ka­kuna. Chasa iachaspa­kunaka, tukui ungug­kunata pai­pagma apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chaiag­rispaka, ungug­kuna paita mañar­ka­kuna: —Kamba katanga punta­lla­pas saki­wai llamkan­gapa—. Chi­wanka, tukui llamkag­kuna ambi­rig­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chi­ura­manda sug fari­seo­kuna i Moisés ima nis­kata iacha­chig taita­kuna, Jeru­salen­manda chaiag­rir­ka­kuna. Nispaka, Jesus­pagma kailla­iaspa, kasa tapur­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Kamta kati­raiag­kuna, ¿ima­patak ñug­pa­manda­kuna imasa iacha­chis­ka­sina mana ruraspa kaug­sa­nakú? Mana maki mailla­rispa­lla­mi miku­nakú. ");
INSERT INTO inb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesuska nir­ka­kunata: —Kam­kunaka, ¿imapatak Taita Dius ima nis­kata mana ruran­gi­chi? Ñug­pa­manda­kuna iacha­chiska­lla­ta ruraspa­mi kaug­sa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Taita Diuska, kasa­mi nirka: “Kam­ba taitata mamandita sumag­lla kuiangi”. Kasa­pas­mi nirka: “Mai­kan­pas taitata i mamata kamig­pika, chitaka chaianmi wañu­chin­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ikuti kam­kunaka, kasa­mi iacha­chin­gi­chi, mai­kanpa taitata u mamata nin­gapa: “Nuka mana pudii­ki­chitachu aidan­gapa. Tukui nuka ima iukaska, Taita Dius­ta karaskami ni­raiá”. ");
INSERT INTO inb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kam­kuna chasa nispa­mi iacha­chi­na­kun­gi­chi, taitata i mamata mana kuiaspa uian­gapa. Chasa iacha­chispa, Diuspa Rimaitaka wabu­tingi­chimi. Kam­kuna­pura ñug­pa­manda iacha­chiska­lla­ta­mi ruraspa kaug­san­gapa munan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","—¡Miski simi, sungu awalla rimag­kuna! Kam­kuna­mandami ñug­pata rimag Isaías suti, Santu Ispi­ri­tu­wa kasa sutipa nirka: ");
INSERT INTO inb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kai alpapi kaug­sag­kuna, sungu awalla rimaspa­mi kuia­wan­kuna. Ikuti pai­kuna sungupi iuiai­waka nuka­manda sug­pi­mi iuia­nakú. ");
INSERT INTO inb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iangami nukata kungu­ri­wag­sina ruran­kuna. Nuka nis­kata iacha­chinga­taka, runa­pura imasa ruran­gapa niska­lla­ta­mi iacha­chin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Chasa nispa, tukui chipi kag­kunataka pai kaska­ma kaiaspa, Jesús nir­ka­kunata: —Suma iuia­rispa uia­wai­chi. ");
INSERT INTO inb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ru­na­kuna ima mikus­kaka, Diuspa ñawipi ñi ima mana mapa­sina ni­raianchu. Ru­na­kunapa sungu­manda jiru iuiai­kuna llugsiskami mapa ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Chi­ura­manda Jesusta kati­raiag­kuna, kailla­iaspa, paita tapur­ka­kuna: —¿Ñachu iachangi, fari­seo­kuna, kam chasa rimaska­manda sungu nanagta uiagta­kuna? ");
INSERT INTO inb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Chi­ura, Jesuska ainirka: —Mai­kan sachapas, nuka­pa Tai­ta suma luarpi kag mana tarpuska kagpika, angundi pilaimi tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chi fari­seo­kunata ianga kawai­chi. Mana ñawi kawag, sug mana ñawi kawagta pusagmi ni­raian­kuna. Chasaka, iskandi­kuna­mi pusuma urmag­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Chi­uraka, Pedro nirka: —Kam ima iacha­chi­kus­kata nukan­chita alli­lla willai. ");
INSERT INTO inb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chi­ura, Jesuska ainir­ka­kunata: —Kam­kuna­pas, nuka­wa kaspa, ¿manarachu iachai­kun­gi­chi ima ni­raiagta? ");
INSERT INTO inb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Manachu iachan­gi­chi, ima mikuskapas, wig­sama iaikuspa, wig­samandaka kanchama llugsigta? ");
INSERT INTO inb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sungu­manda jiru iuiai­kuna llug­siskami Diuspa ñawipi mapa ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sungu­mandami jiru iuiai­kuna llugsí, kasa panda­rin­gapa: wañu­chin­gapa, sugpa warmi­wa u sapa­lla warmi­wa siri­rin­gapa, sisan­gapa, sug­kuna­manda llullaspa riman­gapa, Taita Dius­ta­pas kamin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chasa panda­rii­kuna­mi Diuspa ñawipi mapa ni­raiá. Mana maki mailla­rispa­lla mikug­kuna­taka, Diuspa ñawipi ñi ima mana mapa­sina ni­raianchu. ");
INSERT INTO inb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chi­manda llugsispa, Jesuska Ti­ro i Sidón suti pui­blu­kuna suiu rirka. ");
INSERT INTO inb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chi­uraka sug warmi, chi Kanaán suti alpa­manda pai­pagma kailla­iaspa, kasa nispa kapa­rirka: —Davidpa wam­bra Iaia Jesús, nuka­manda llaki­ri­puai. Nuka­pa warmi wam­brata kuku waira iai­kus­pa­mi iapa nana­chi­pua­ku. ");
INSERT INTO inb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesuska, mana imapas ai­nirka. Nigpika kati­raiag­kuna, pai­pag­ma kailla­iaspa, nir­ka­kuna: —Chi warmita, ¿imapatak mana pai­pagma kachangi? Iapa­mi kapa­rispa kapa­rispa kati­chi­mu­ku. ");
INSERT INTO inb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús ainir­ka­kunata: —Israel­manda runa­kuna chin­gaska ubija­kuna­sina kaska­manda­lla­mi nuka kacha­muska kani. ");
INSERT INTO inb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Chi­ura chi warmika, Jesusta kungu­rispa, nirka: —Taita turi, nuka maña­kus­kata aida­wai. ");
INSERT INTO inb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Chi­ura, Jesuska ainirka: —Mana chaianchu, wam­bra­kunapa tandata kichuspa, alku­kunata sitapun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chi­ura, chi warmika nirka: —Ari, taita turi. Alku­kunapa dui­ñu­kuna miku­nakus­kapi, misa uku­ma piti urmas­ka­kunata, pai­kuna­pas mikun­kunami. ");
INSERT INTO inb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Chasa uiaspa, Jesuska paita nirka: —Iapa sumami nuka­manda iuiarkangi. Kam imasa iuia­kus­ka­sina, alli­lla tukuchu. Chi­urallami chi warmipa wam­bra ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chi­manda llugsispaka Jesús, Gali­lea kucha patama rirka. Chi­mandaka, awa lumama sikaspa, tia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iapa achka runa­kuna, ungug­kunata apaspa, pai kaska­ma chaiag­rir­ka­kuna. Mana purii pudig­kunata, maki u chaki illa kas­ka­kunata, mana ñawi kawan­gapa pudis­ka­kunata i mana rimai iukas­ka­kunata Jesuspa chaki ladu churag­rir­ka­kuna. Chi­ura Jesuska, tukui­kuna­ta­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Cha­saka, mana rimai iukas­ka­kuna rimag­samur­ka­kuna. Maki i chaki illa kas­ka­kuna­pas, alli­lla­mi tukug­samur­ka­kuna. Mana purii pudig­kuna­pas purig­samur­ka­kuna. Mana ñawi kawan­gapa pudig­kuna­pas kawag­samur­ka­kuna. Chasa kawaspaka, chipi kag­kuna ujna­rispa nir­ka­kuna: —Israel­manda runa­kunapa Taita Dius, iapa suma atunmi ka. ");
INSERT INTO inb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chi­ura­manda Jesuska, kati­raiag­kunata kaiaspa, nir­ka­kunata: —Kai tukui runa­kuna, ña kimsa punchami nuka­wa kaipi kan­kuna. Pai­kuna ñi ima mana mikun­gapa iukag­manda, nukata iapa­mi llaki­ri­wag­samú. Mana muna­nichu, pai­kunata mana mikui karaspa­lla kikin­kuna­pagma kachan­gapa. ¡Amalai ñambi ri­kuska­lla­pi diiarkai samba­iaspa urmag­rintra­kuna! ");
INSERT INTO inb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kati­raiag­kuna ainir­ka­kuna: —Kai mai­kan runapas mana kaug­sa­na­kus­kapi, ¿maipitak chi­tuku achka tanda randi­sun­chi, kai tukui runa­kunata karan­gapa? ");
INSERT INTO inb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesuska tapur­ka­kunata: —¿Maituku tandatak tiapun­gi­chita? Chi­ura ainir­ka­kuna: —Kan­chis tandallami tia, sug uchulla chalwa­kuna­pas. ");
INSERT INTO inb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Chasa uiaspa Jesuska, chipi kag­kunata nirka: —Alpapi tia­rii­chi—. ");
INSERT INTO inb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nispaka, chi kan­chis tandata i chalwa­kunata chari­rispa, “Pai Siñur” Taita Dius­ta nirka. Chi­ura­lla piti­chispa, kati­raiag­kunata kuaspa richirka. Pai­kunaka, tukui­kunata karaspa apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tukuikunami sagsagta mikur­ka­kuna. Nispaka, kan­chis saparu junda piti piti­kuna tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mai chusku wa­ran­ga kari­kuna­mi mikur­ka­kuna, warmi i wam­bra­kunata mana kuintaspa­lla. ");
INSERT INTO inb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chi­ura­manda Jesús, chi runa­kunata: “Kaia­kama” nispaka, kanua­ma iaikurka. Chi­mandaka, Maga­dán suti alpama rirka. ");
INSERT INTO inb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fari­seo­kuna i sadu­seo­kuna, kailla­iag­rispa, Jesus­ta maña­na­kurka, mana ima­ura­pas kawas­ka­sina awa luar­manda kawa­chin­gapa; chasaka, pai­manda iachan­gapa, sutipa Taita Dius kacha­muska kagta. ");
INSERT INTO inb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesuska ainir­ka­kunata: —Kam­kuna, ¿manachu nin­gi­chi: “Chisima puka puiu kawa­rigpika, kaia alli punchami kan­gapa ka”? ");
INSERT INTO inb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chasa­lla­ta, tutata amsa puka puiu paka­rigpika, ¿manachu nin­gi­chi: “Tamia punchami kan­gapa ka”? Imasa awapi kawa­ris­ka­kunata kawaspaka, iachangi­chimi ninga, puncha­kuna imasa kan­gapa kagta. Ikuti, kai puncha­kuna nuka ima rura­kus­kata kawaspa­pas, mana iuia­ringi­chi­chu ima pasa­ri­kugta. ");
INSERT INTO inb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Taita Diusta mana iuia­rispa, mana alli­lla ruraspa kaug­sa­na­kuspa­mi maña­wa­nakun­gi­chi: “Mana kawas­ka­sina kawa­chi­mui”. Ñi imapas mana kam­kuna munas­ka­sina kawan­gapa kangi­chi­chu. Ñug­pa­manda Santu Ispi­ri­tu­wa rimag Jonás suti, imasa­mi pasarka: chasa­lla­ta kawa­ri­lla­mi kawan­gapa kan­gi­chi. Chasa nispaka, pai­kunata sakispa, kucha sug ladu chimba kati­raiag­kunawa rirka. ");
INSERT INTO inb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kati­raiag­kuna kunga­riska kar­ka­kuna, tanda apan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chi­ura, Jesuska nir­ka­kunata: —Suma iuia­rispa uia­wai­chi. Fari­seo­kunapa i sadu­seo­kunapa liba­dura­sina iuiaita, ¡ujala­lla­pas iuia­na­kun­gi­chi! ");
INSERT INTO inb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Chasa uiaspaka, kikin­pura rima­ri­na­kurka, iuiaspa: —Tanda mana apa­muska­mandami chasa nukan­chita ni­ku. ");
INSERT INTO inb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Chi rima­na­kus­kata uiaspa, Jesuska nirka: —¿Imapatak ni­na­kun­gi­chi: “Tan­da mana apa­muska­mandami chasa nukan­chita ni­ku”? Nuka­mandaka, ¿imapatak mana mas suma alli­lla iuia­rin­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ima­wantak, uia­waspa­pas, kam­kuna­pa umapika manara iaikú? Nuka pichka tandata piti­chi­uraka, pichka waranga runa­kuna mikur­ka­kuna; chi puchus­ka­kunataka, ¿mana­chu iuia­rin­gi­chi, mai­tuku saparu junda tanda­chigta­kuna? ");
INSERT INTO inb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chasa­lla­ta, nuka kan­chis tandata piti­chi­uraka, chusku waranga runa­kuna mikur­ka­kuna; chi puchus­ka­kunataka, ¿manachu iuia­rin­gi­chi, mai­tuku saparu junda tanda­chigta­kuna? ");
INSERT INTO inb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Imapatak mana iuia­rin­gi­chi, nukaka tanda­manda­lla mana kam­kunata rima­kugta? Fari­seo­kunapa i sadu­seo­kunapa liba­dura­sina iuiaita, ¡ujala­lla­pas iuian­gi­chi! ");
INSERT INTO inb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chasa ni­uraka, iuiai apir­ka­kunata, mana tanda liba­dura­manda rima­kuska kagta; fari­seo­kunapa i sadu­seo­kunapa iacha­chii­kunata kuidadu iukan­gapa ni­raiagta. ");
INSERT INTO inb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús, Filipopa Sesarea suti alpa­ma chaiag­rispaka, paita kati­ra­iag­kunata tapurka: —Ru­na­kunaka kai Runa Tukus­ka­manda, ¿pitak kagta nin­kuna? ");
INSERT INTO inb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pai­kunaka ainir­ka­kuna: —Mai­kan­kuna ninkunami: kam kangisi Juan Bautista. Sug­kunaka: kam ñug­pa­manda rimag Elías; ikuti sug­kunaka: Jeremías u Santu Ispi­ri­tu­wa sug ñug­pata rimagsi kangi. ");
INSERT INTO inb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Chi­ura, Jesús tapur­ka­kunata: —Kam­kunaka nuka­manda, ¿pi kagtatak ni­wan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Chasa tapu­ura, Simón Pe­droka ainirka: —Kam kangimi kaug­sag Diuspa wam­bra. Pai agllaska Cristomi kangi. ");
INSERT INTO inb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chi­ura, Jesuska nirka: —Kam Jonaspa wam­bra Simón, Taita Diuspa iapa kuiaskami kangi. Ñi mai­kan runapas, kamta mana iuia­chirkachu, chasa ainin­gapa. Nuka­pa Taita suma luarpi kagmi kamta chasa iuia­chirka. ");
INSERT INTO inb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nuka kam­ta­mi niiki: kam, Pedro u rumi­mi ni­raiangi. Kai atun rumipi wasi­chig­sina­mi iglisia tukus­ka­kunata mira­chin­gapa kani. Chitaka, mai­tuku infirnu­manda puchukan­gapa muna­na­kugpi­pas, mana puchu­kai pudin­gapa kan­kunachu. ");
INSERT INTO inb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Suma luarma iaikug­ri­diru lla­bi­kuna­ta­mi kuan­gapa kaiki. Mai­kan panda­ris­ka­kunata, kam kai alpapi mana pasin­siaska nigpika, sug luar­pipas chasa­lla­ta­mi tukun­gapa kan­kuna. Chasa­lla­ta, mai­kan panda­ris­ka­kunata kam kai alpapi pasin­sias­kaka, sug luar­pipas chasa­lla­ta­mi pasin­siai tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Chasa nispaka, kati­raiag­kunata nirka: —Mana pi­ta­pas willa­na­kun­gi­chi, nuka, Taita Dius agllaska Cristo kagta. ");
INSERT INTO inb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chi­ura­manda Jesuska, paita kati­raiag­kunata iacha­chii kalla­rirka, kasa nispa: —Nukata, Jeru­salenma rin­ga­pa­mi chaia­wa­ku. Chipika, iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas iapa llakii i nanaimi pasa­chi­wan­gapa kan­kuna. Nukata wañu­chi­wan­ga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa puncha­pika ikutimi kaug­sa­rin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chasa uiaspaka Pedroka, Jesús sapa­lla­ta mana uia­na­kuska­ma pusaspa, kasa piñag­sina nii kalla­rirka: —¡Ujala­lla­pas Taita Dius chasa muna­chu, taita waugki! Chasa llakii­kuna, mana ima­ura­pas kamta pasa­rin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chi­ura Jesuska, tigra­rispa, Pedrota nirka: —Nuka­pa ladu­manda, iaia kuku, anchu­rii. Kam chasa ni­was­paka, panda­chi­wan­ga­pa­mi muna­kungi. Kam mana iuia­kungi­chu Taita Dius imasa iuia­kus­ka­sina. Runa­kunapa iuiai­lla­wa­mi chasa iuia­kungi. ");
INSERT INTO inb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chasa nispaka, kati­raiag­kunata nirka: —Mai­kan nukata kati­raia­wan­ga­pa munagka, kikin­manda kunga­richu. Paipa krusta marka­rig­sina ruraspa­mi iuká kati­raia­wanga. ");
INSERT INTO inb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mai­kan kikinpa kaug­saita kispi­chinga­paglla iuia­kugpika, kikinmi puchu­ka­rin­gapa ka. Ikuti mai­kan­pas nuka­manda wañu­chii tukug­pika, mana mas wañui kaug­sai­ta­mi tarin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—Sug runa, tukui kai alpapi ima munaska iukagpi­pas, paipa alma­ta mana kispi­chigpika, chi iukas­ka­kuna, ñi imapa mana bali­pun­gapa kanchu. Chi runaka, paipa almata chinga­chispaka, ¿ima­watak pudin­gapa ka, ikuti tarin­gapa? Ñi ima­wapas manima. ");
INSERT INTO inb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Kai Runa Tukuska samu­ura, nuka­pa Taita suma atun­ia­chis­ka­wa­mi nuka­pa anjil­kuna­wa samun­gapa ka. Samuspaka, tukui­kuna­ta­mi imasa alli­lla u mana alli­lla ruras­ka­kunata kawa­chig­samun­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","—Kasami nuka nii­ki­chita: mai­kan kaipi kag­kuna manara wañug­kuna, kai Runa Tukuska suma mandai­wa samug­ta­mi kawa­wan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chi­ura­manda sugta pun­cha­pika, Jesuska, Pedro­ta, Santiagota i waugkindi Juan­ta pusaspa, sug awa lumama pai­kuna­lla­wa sikag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chipi chaiag­rispaka, pai­kuna kawa­nakug­lla­pi, sug rigcha kawa­ri tukug­samurka. Paipa ñawi, indi­sina punchami tukug­samurka. Paipa katan­ga­pas, iapa iura puncha­lla­mi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kawa­na­kug­lla­pi, Moisés i Elías kawa­rig­samur­ka­kuna. Chi runa­kunaka, Jesuswa rima­na­kui kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Chasa kawaspaka Pedroka, Jesusta kasa nirka: —Taita waugki, kaipi iapa alli iuia­chimi kan­chi. Kam munagpika, kimsa tambu kaipi rurasa: kam­manda sug, Moises­manda sug, sugka Elias­manda. ");
INSERT INTO inb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chasa Pedro rima­kun­kama, puncha puiulla, pai­kunata kilpag­samurka. Chi puiu uku­manda, sug rimagta uia­rig­samurka, kasa nispa: —Kai, nuka­pa kuiaska wam­brami kapuá. Paita kawaspa, iapa alli suma­mi iuia­chii­wa kawani. Paita uia­puan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Chasa uiaspaka chi kati­raiag­kuna, asku­rinti mancha­rispa, uma­ta alpama kumu­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Chi­ura­manda Jesús kikin, kailla­iaspa, pai­kunata llamkaspa, nirka: —Ata­rii­chi. Mana mancha­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pai­kuna uma ata­ri­chispa kawa­ura, Jesuska ikuti sapalla kawa­rig­samur­ka­kunata; sug­kunaka manima. ");
INSERT INTO inb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chi luma­manda uraiku­naku­uraka, Jesuska nir­ka­kunata: —Kam­kuna ima kawas­kata mana pi­ta­pas willa­na­kun­gi­chi. Kai Runa Tukuska wañuspa kaug­sa­riska­ura­mandami chasa kawas­kata willankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Chi­ura kati­raiag­kuna, paita tapur­ka­kuna: —Nigpi, ¿imapatak Moisés ima nis­kata iacha­chig taita­kuna nin­kuna: “Elias­ta­mi chaia­ku, Taita Dius agllaska Cristopa ñug­pa samun­gapa”? ");
INSERT INTO inb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chi­ura, Jesuska ainir­ka­kunata: —Sutipami Elías ñug­pa samun­ga­pa ka. Tukuimi alli­chig­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Chasa samun­gapa kag­pi­pas, nukaka kasa­mi nii­ki­chita: Elías ñami samurka. Paitaka mana rigsir­ka­kunachu pi kagta. Imasa munas­ka­sina­mi paita mana alli­lla rurar­ka­kuna. Kai Runa Tukus­ka­ta­pas chasa­lla­ta­mi rura­wan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Chasa uiaspaka, kati­raiag­kunata iuia­rirka: “Juan Bautista­mandami chasa rima­kuska”. ");
INSERT INTO inb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pai­kuna iapa achka runa­kunapagma chaiag­ri­uraka, sug runaka, kailla­iaspa, Jesusta kungu­rispa nirka: ");
INSERT INTO inb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Taita waugki, nuka­pa wam­bra­manda llaki­ri­puai. Wañui ungui­wa iapa llakinga­sina­mi kapuá. Nina­pi i iakupi achka biajimi urma­puá. ");
INSERT INTO inb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chi­mandami kamta kati­raiag­kuna­pagma apa­muspa kawa­chirkani. Nigpika, pai­kuna manima ambi­puan­gapa pudir­ka­kunachu. ");
INSERT INTO inb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesuska ainirka: —¡Ai, kam mana alli runa­kuna, Taita Diuswa ñi ima mana iuiag­kuna­mi kan­gi­chi! ¿Ima­ura­kamatak kam­kunata chasa chari­na­kusa­ki­chita?—. Chasa nispaka— Chi ungug­ta kaima pusamui­chi— nirka. ");
INSERT INTO inb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chaia­chig­ri­ura, Jesuska chi kuku wairata sin­chi piñarka. Chasa piña­ura, chi kuku waira chi wam­bra­manda llugsirka. Chi­ura­lla, suma ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Paita kati­raiag­kuna, chasa kawas­paka, Jesús sapalla kas­kapi kailla­iaspa, tapur­ka­kuna: —¿Ima­wantak nukan­chika mana pudirkan­chi, chi kuku wai­ra­ta llugsi­chin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chi­ura, Jesuska ainir­ka­kunata: —Kam­kuna nuka­manda mailla iuia­nakug­mandami mana llugsi­chin­gapa pudirkan­gi­chi. Kasa­mi nuka nii­ki­chita: sug uchulla muritu mustasa­sina­lla­pas kam­kuna nuka­manda iuiai iukantran­gi­chi; kai lumata nintran­gi­chi: “Kai­manda chasa­ma iali­rii”. Chi­ura­lla­mi chi luma, sug­sinama iali­rintra. Tukui­mi chasa pudi­rintra. ");
INSERT INTO inb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Chi kuku waira­kunataka, mana mikuspa­lla Taita Diusta sin­chi mañas­ka­wa­mi llugsi­chin­gapa pudi­rí. ");
INSERT INTO inb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chara Galileapi kan­kama, Jesús nir­ka­kunata: —Kai Runa Tukus­kaka, mana alli runa­kuna­pag­ma­mi chaia­chii tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pai­kunaka wañu­chi­wan­ga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa puncha­pika ikutimi kaug­sa­rin­gapa kani. Pai­kuna, chasa uiaspaka, iapa llaki­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pai­kuna Kafarnaum pui­bluma chaiag­ri­uraka, Diuspa atun wasi­manda impuistu chaskig­kuna, kailla­iaspa, Pedrota tapur­ka­kuna: —Kam­kunata iacha­chig, ¿im­puis­tu paganchu? Chi­ura ainirka: —Ari. ");
INSERT INTO inb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro wasi ukuma iaikug­rispa, manara imapas rimagpi, Jesus­ka paita tapurka: —Kai alpapi mandag­kuna, ¿pi­kunata­tak impuistu chaskin­kuna: kikinpa wam­bra­kunata u sug­kunata? Kam, ¿imatak aini­wangi? ");
INSERT INTO inb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Sug­kunata— Pedro ainirka. Chi­ura, Jesuska nirka: —Nigpi, wam­bra­kunataka mana pagan­gapa chaianchu. ");
INSERT INTO inb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Chasa kag­pi­pas, mana chi maña­na­kus­kata piña­chin­gapa, kucha patama rii. Chipi, ansuilu sitangi. Mai­kan ñug­pa chalwa urmas­kata simita kawangi. Chi­pi­mi sug kulki tarin­kangi. Chita apaspa, nuka­manda i kam­manda maña­na­kus­kata kuag­ringi. ");
INSERT INTO inb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chasa kag­lla­pi, Jesusta kati­raiag­kunaka, kailla­iaspa, tapur­ka­kuna: —Suma luarpi, Taita Dius manda­kus­kapi, ¿pitak mas atun taita tukuska kan­gapa ka? ");
INSERT INTO inb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Chi­ura Jesuska, sug uchulla wam­brata kaiaspa, chaugpipi saia­chirka, ");
INSERT INTO inb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kasa nispa: —Kasami nuka nii­ki­chita: kam­kuna, mana Diuspa ñawipi kai wawa­sina alli­lla tukug­samuspaka, mana suma luarma iaikug­rin­gapa kangi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mai­kan­pas kai uchulla­sina mana ima­kuna­pipas subir­biaspa­lla tukug­samug, paimi, suma luarpi, Taita Dius suma manda­kus­kapi, mas atun taita tukuska kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mai­kan­pas kai uchu­lla­ta­sina nuka­manda iuia­rispa chaskigpika, nukata chaski­wag­sina­mi rurá. ");
INSERT INTO inb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Ikuti mai­kan­pas kasa uchu­lla nuka­manda suma iuia­wagta panda­chi­puagpika, paita chaian­trami, sug atun kutanga rumi kungapi wataspa, atun kucha iakuma sitag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Kai alpapi panda­rii­kunapi urma­chin­gapa, achkami tia. Chasa­mi ima­ura­pas tian­gapa ka. Chasa tiagpi­pas, ¡ai, mai­kan runa, sug­kunata panda­rii­kunapi urma­chig! ");
INSERT INTO inb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Kamba maki­wa u chaki­wa panda­rin­gapa chaiagpika, chita chaianmi kuchuspa sitan­gapa, mana panda­rin­gapa. Chasapaka, mas allichar kantra, maki u chaki kuru suma luarma iaikug­rin­gapa. Mana kagpika, ¿iskandi maki i chaki­kuna­wantachu munaipa, atun nina ñi ima­ura­pas mana wañun­gapa kaska­ma sitai tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Chasa­lla­ta, kamba ñawi­wa kawaspa panda­rin­gapa chaiagpika, chita chaianmi surkuspa sitan­gapa, mana panda­rin­gapa. Chasapaka, mas allichar kantra, suglla ñawi­lla­wapas suma luarma iaikug­rin­ga­pa. Mana kagpika, ¿iskandi ñawi­kuna­wantachu munaipa, dil­tudupa ninama sitai tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Ñi mai­kan kai uchulla­kunata mana wabutin­gi­chi. Kasa­mi nuka nii­ki­chita: pai­kunata kawag anjil­kunaka, suma luarpi ima­ura­pas nuka­pa Taitapa ñawi­pi­mi kan­kuna.  ");
INSERT INTO inb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kai Runa Tukus­kaka samur­kami, mai­kan chingas­ka­sinata maskaspa tarin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—¿Imatak iuian­gi­chi? Mai­kan runapas, patsa ubija iukaspa, sug ubija chingapugpika, ¿manachu iskun chunga iskunta sakispa, maskai kalla­rintra, chi ubijata tarin­kama? Ari. ");
INSERT INTO inb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kasa­mi nuka nii­ki­chita: chi chingas­kata tari­ura, iskun chunga iskun mana ima­ura­pas chingag­kuna­manda masmi chi tarigta alli iuia­chi­rintra. ");
INSERT INTO inb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Chasa­lla­ta, kam­kunapa Taita suma luarpi kag mana munanchu, ñi sug kai uchulla­kuna chinga­rispa, pai­pagma mana chaiag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Mai­kan­pas kamta mana alli­lla ruragpika, pai sapa­lla­ta rimaspa iuia­chig­ringi. Kamta alli­lla uiag­pika, ikutimi sumag­lla waug­kindi tukunkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana kamta uiagpika, sug u iskai runa­kunata pusaspa, ikuti rimag­ringi; chipika, iskai u kimsa uiag­kuna tiachu, tukui imasa rima­na­kuska uian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pai­kuna­ta­pas mana uiag­pika, iglisia tukus­ka­kunata willan­gi­chi. Iglisia tukus­ka­kuna­ta­pas mana uiagpika, chi runa, kam kikin­pura i Taita Diusta mana rigsigmi tukú. ");
INSERT INTO inb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Kasami nuka nii­ki­chita: mai­kan panda­ris­ka­kunata, kam­kuna kai alpapi mana pasin­siaska nig­pika, sug luar­pipas chasa­lla­ta­mi tukun­gapa kan­kuna. Ikuti mai­kan panda­ris­ka­kunata kam­kuna kai alpapi pasin­sias­kaka, sug luar­pipas chasa­lla­ta­mi pasin­siai tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Kasapasmi nii­ki­chita: iskai­kuna­lla­pas, kai alpapi suglla­sina iuia­rispa, nuka­pa Taita suma luarpi kagta mañagpika, chasa­lla­ta­mi ima mañaska kara­mun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iskai u kimsa­kuna­lla­pas kas­kapi nukata iuia­ri­wa­chu­kuna: nuka kikinmi pai­kuna­wa sug­lla­pi kan­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Chi­ura Pedro, kailla­iaspa, Jesusta tapurka: —Taita waugki, mai­kan­pas nukata mana alli­lla rura­wagpika, ¿mai­tuku biajitak chaia­wa­ku, paita pasin­sian­gapa? ¿Kan­chis biaji­kamachu pasin­sian­gapa chaia­wan­gapa ka? ");
INSERT INTO inb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesuska ainirka: —Mana niikichu, kan­chis biaji­kamalla pasin­sian­gapa. Niikimi, kan­chis chungata kan­chis biaji ialig­ta­pas pasin­sian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Chasa­manda Taita Dius suma luarpi kag, sug atun mandag­sina­mi ni­raiá. Kasa niipa: chi man­dagka munarka, paipa piun­kunata: “Ima maña­chis­kata kuti­chi­wai” nin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Chasa kalla­ri­ku­uraka, sug piuntasi pai­pagma pusag­rir­ka­kuna. Chi piunta chunga wa­ran­ga kuri kulkisi maña­chiska karka. ");
INSERT INTO inb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nigpika, mana kuti­chin­ga­pa pudi­kug­manda, chi mandag, jus­ti­sia­kunata nirkasi: “Paita, warmin­dita, wam­bra­kunata i tukui ima tia­pus­ka­kuna­ta­pas katug­rii­chi, imasa maña­chis­ka­sina kuti­chi­wan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—Chi­ura chi piun, kungu­rispa, mañai kalla­rirka, kasa nispa: “Taita waugki, nuka­manda llaki­rii. Suia­wai. Tukuimi kuti­chi­sa­ki”. ");
INSERT INTO inb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Chasa maña­ura mandagka, suma llaki­rispa, piunta uiaspa, tukui maña­chis­kata pasin­siarka. Nispaka, sakirkasi rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Ri­ku­ura, pai piun­pura kawa­na­kurka. Chi sug piuntaka patsa billitisi pai maña­chiska karka. Chita kawaspaka, kungapi apispa, sipi­kug­sina chari­rispa, nirka: “Nuka­pa kulkita kuti­chi­wai”. ");
INSERT INTO inb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Chi­ura chi sug piun, kungu­rispa, mañai kalla­rirka, kasa nispa: “Nuka­manda llaki­rii. Suia­wai. Tukuimi kuti­chi­saki”. ");
INSERT INTO inb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Paikar mana munarka, ñi imasa­pipas pasin­sian­gapa. Chi piunta karsilpi chura­chirka, tukui maña­chis­kata kuti­chin­kama iuiaspa. ");
INSERT INTO inb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Pai piun­pura, chasa kawas­paka, iapasi llaki­rir­ka­kuna. Nis­paka, chi mandagta tukui imasa kawaska willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Chasa iachas­paka chi mandagka, paita kaiaspa, nirkasi: “¡Mana alli iuiai­iug­mi kangi! Kam maña­wag­manda­mi nuka tukui maña­chis­kata pasin­siarkaiki. ");
INSERT INTO inb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nuka kamta suma­mi llaki­rirkaiki. Nigpika kam­ta­pas, ¿manachu chaia­kurka, chasa­lla­ta kam piun­pura llaki­rin­gapa?”. ");
INSERT INTO inb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Chasa nispaka, iapa rabia­rispa, justi­sia­kunata nirka: “Kar­sil­pi wichka­puai­chi, tukui kulki kuti­chi­wan­kama”. ");
INSERT INTO inb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chasa parlaspaka, Jesús nirka: —Kam­kuna suma iuiai­wa sug­kunata mana pasin­siagpi­kunaka, nuka­pa Taita suma luarpi kagpas kam­kuna­ta­pas chasa­lla­ta­mi mana pasin­sian­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús, chasa rimai puchu­kaspaka, Galilea alpa­manda llugsispa rirka. Jordán iaku sug ladu chimba ialispa, Judea alpama chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chi laduka, iapa achka runa­kuna paita kati­chii kalla­rir­ka­kuna. Jesuska, chipi chaiag­rispa, ungui­wa kas­ka­kunata ambig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sug fari­seo­kuna, pai­pagma kailla­iag­rir­ka­kuna. Chi runa­kuna­ka, Jesusta panda­chin­gapa iuiai­wa tapur­ka­kuna: —¿Pudin­chi­chu, nukan­chipa warmita ima­manda­lla­pas sitan­ga­pa? ");
INSERT INTO inb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesuska ainirka: —¿Manachu kasa Moisés ni­ra­ias­kata kawarkan­gi­chi, Taita Dius runa­kunata wiña­chig, kalla­riska­ura­manda­ta kari i warmi wiña­chispa ruragta? ");
INSERT INTO inb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wiña­chis­paka, nirka: “Chi­mandami, kari kagpi, paipa taitata maman­dita sakispa, paipa warmi­wa iskan­di­kuna sug­lla­sina tukug­samun­gapa kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chasa kaspaka, mana iskai ni­raianchu. Sug­lla tukuskami ni­raiá. Taita Dius chasa sug­lla tukuska ni­raias­kata, ñi mai­kan runa­pas mana iukanchu “Sita­nakui” ninga. ");
INSERT INTO inb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pai­kunaka tapur­ka­kuna: —Nigpika, ¿imapatak Moisés sakirka, kusa, sug iskribiska war­mi­ta kuaspaka, ña paitaka sitaska ni­raian­gapa? ");
INSERT INTO inb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chi­ura, Jesuska ainirka: —Kam­kuna upa iuiai tukuska kag­mandami Moisés kam­kunata chasa ruran­gapa sakirka. Ñug­pa, runa­kuna tiai kalla­ri­ura, mana chasa karkachu. ");
INSERT INTO inb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kasa­mi nuka nii­ki­chita: mai­kan­pas, kikinpa warmita sitaspa, sug warmi­wa kasaragpika, atun panda­riimi rurá. Paipa warmi sug kari­wa api­rigpika, chi­mandakar pudingi­chimi sitan­ga­pa. Mai­kan­pas kusa sitaska warmi­wa kasaragpika, atun panda­riimi chasa­lla­ta rurá. ");
INSERT INTO inb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Chi­ura­manda kati­raiag­kuna, Jesusta nir­ka­kuna: —Mai­kan kusapas mana kikin­pa warmita sitan­gapa pudig­pika, mas allichar kantra mana kasaran­gapa. ");
INSERT INTO inb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesuska nir­ka­kunata: —Mana tukui­kuna pudin­kunachu, chi iacha­chis­kata suma uian­gapa. Taita Dius suma iuiai karaska iukag­kuna­lla­mi suma uian­kuna. ");
INSERT INTO inb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mai­kan­kuna, tiag­samuska­ura­manda­ta­mi mana pudin­kuna kasa­ran­gapa. Sug­kunaka, kapai tukus­kami kan­kuna, mana warmi iukan­gapa. Ikuti sug­kunaka, Taita Dius suma luarpi kag ima nis­kata ruran­gapa iuiaspa­mi mana warmi iukan­gapa munan­kuna. Mai­kan chasa alli­lla uiaspa ruran­gapa pudig­kuna, uia­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chi­ura­manda uchulla­kunata, pai­kunapa atun­kuna Jesus­pagma pusar­ka­kuna, Taita Diusta pai­kuna­manda mañaspa, maki churan­ga­pa. Jesusta kati­raiag­kunaka, pusa­nakug­ta piñaspa, nir­ka­kuna: —Mana kailla­ia­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Chi­ura, Jesuska nirka: —Ianga kawai­chi, wawa­kuna nuka­pagma samu­chu­kuna. ¿Ima­pa­tak arka­na­kun­gi­chi? Kai wawa­kuna­sina kag­kuna­mi suma luarma iaikug­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chasa nispaka, wawa­kunata maki churarka. Nispaka, chi­manda llugsispa rirka. ");
INSERT INTO inb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sug musu, Jesus­pagma kai­lla­iag­rispa, tapurka: —Iacha­chig taita, ¿ima alli rurai­watak iukani ruranga, mana puchu­ka­ri­diru suma kaug­saita tarin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesuska ainirka: —¿Imapatak alli rurai­manda tapu­wa­kungi? Taita Dius­lla­mi alli ka. Chi kaug­saita iukan­gapa munas­paka, Moisés ima nis­kata alli­lla ruraspa kaug­sangi. ");
INSERT INTO inb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chi musuka ikuti tapurka: —¿Mai­kan­kuna? Chi­ura, Jesuska ainirka: —Mana wañu­chingi. Mana sug­pa warmi­wa siri­ringi. Mana sisangi. Mana pi­manda­pas llu­llan­gi. ");
INSERT INTO inb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kamba taitata maman­dita sumag­lla kuiangi. Kam kikin­ta­sina­mi iukangi, tukui runa­kunata kuianga. ");
INSERT INTO inb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chasa uiaspa, chi musu nirka: —Tukui chi nis­kata chasa ruras­pa­mi kaug­sani. Ni­wai: ¿imatak pisi­wa­ku? ");
INSERT INTO inb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chi­ura, Jesuska ainirka: —Kam tukuipi alli kan­gapa munas­paka, kuna­ura­lla rii. Tukui ima iukas­kata katug­rii. Katuska kulki­taka mana iukas­ka­kunata tukui­ta karag­rii. Chasa ruraspaka, suma luarpi iapa iukagmi tukun­ga­pa kangi. Nispaka samungi, nuka­ta kati­wan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chasa rimas­kata uiaspaka, chi musu llaki­rispa­mi rirka, iapa iukag kaspa. ");
INSERT INTO inb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesuska, kati­raiag­kunata nirka: —Kasami nuka nii­ki­chita: iapa iukag­kuna suma luarma iaikug­rin­gapaka, iapa trabajusumi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ikuti niiki­chitami: maschar alli kantra, sug wagra sug aguja ñawi­pi ialin­gapa. Chi­manda mas tra­ba­ju­sumi ka, chi iapa iukag­kuna suma luarma iaikug­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Chasa uiaspaka kati­raiag­kuna, iapa ujna­rispa, kasa tapur­ka­kuna: —Nigpika, ¿pi­sik kispi­rin­gapa pudinga? ");
INSERT INTO inb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chi­ura Jesuska, pai­kunata kawaspa, nirka: —Ñi mai­kan runa mana pudin­chu. Taita Dius­lla­mi kispi­chin­gapa pudí. ");
INSERT INTO inb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Chi­ura, Pedroka nirka: —Uiamui. Nukan­chi, tukui ima iukas­kata sakispa­mi kamta kati­raian­chi. Nigpika, ¿imatak nukan­chi­manda tian­gapa ka? ");
INSERT INTO inb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesuska, pai­kunata ainirka: —Kasami nuka nii­ki­chita: tukui musuia­chii tukug­samu­uraka, kai Runa Tukuska iapa suma atun manda­diru­pi­mi tia­rig­rin­gapa ka. Chi­uraka, kam­kuna nukata kati­raia­wag­kuna­pas, chi­lla­pita chunga iskai manda­diru­pi­mi tia­rig­rin­gapa kan­gi­chi; chasaka, ñug­pa­manda achala taita Israelpa chunga iskai wam­bra­kunapa wam­bra­kunata kawaspa justi­sian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mai­kan­pas, nukata kuia­waspa, wasita, waugki i pani­kunata, taita i maman­dita, wam­bra­kunata, alpa­kunata u ima iukas­kata sakispa kati­wagka, patsa­manda mas patsa­mi chaskin­gapa kan­kuna. Mana puchuka­ri­diru suma kaug­sai­ta­pas­mi tarig­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Chasa kagpi­pas, kuna­ura ñug­pa ni­raias­ka­kuna, achka­kuna­mi kati laduma tukun­gapa kan­kuna. Ikuti kuna­ura kati ni­raias­ka­kunaka, achka­kuna­mi ñug­pa laduma tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Taita Dius sug luarpi suma mandag, ubas chagra­iug runa­sina­mi ni­raiá. Kasa niipa: chi runaka, iapa tutatasi rirka, pallag­kuna maskan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pallag­rin­gapa munag­kunata nirka: “Sug sug chisiagta pallag­sina bali kulkimi kuasa­ki­chita”. —“Ari” ainis­ka­kunatasi ka­char­ka, ubas chagrapi pallan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Chaugpi tuta­ta­pas, ikutisi kallima rirka. Chipi ianga saia­na­kus­kata tarispaka, ");
INSERT INTO inb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","tapur­ka­kunata: “¿Kam­kuna­pas munan­trangi­chi­chu, nuka­pa chagrapi pallag­rin­gapa? Imasa balis­ka­sina­mi kuasa­ki­chita”. Chasa tapu­ura, chi­kuna­pas rir­ka­kuna pallan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Ikuti chaugpuncha i chaugpi chisimapas, chasa­lla­tasi maskag­rirka. ");
INSERT INTO inb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ña indi chinga­ku­ura­pas, ikuti kallima rispa, sug­kuna saia­na­kus­katasi tarig­rirka. Chi­kuna­tasi tapurka: “¿Imapatak chisiagta ianga saia­na­kun­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Chi­ura ainir­ka­kuna: “Ñi pi­pas nukan­chita mana ñi imapapas maskan­kunachu”. —“Nigpika kam­kuna­pas, nuka­pa ubas chagrama rii­chi pallan­gapa” nir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Ña amsaia­ku­uraka, chi cha­gra­iugka paipa kapuralta nir­ka­si: “Pallag­kunata kaiaspa, kalla­ringi, kati chaia­mug­kunata ñug­pa pagan­gapa. Nispaka, suiu suiu, tutata kalla­rigta pagangi”. ");
INSERT INTO inb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Ña pagai kalla­ri­uraka, chisi­ma chaiag­rig­kuna, chisiagta pallag­sina bali kulkisi chaskig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chasa chaski­na­kuska iachas­paka, tutata­manda­ta pallag­kunaka iuia­na­kurka: “Nukan­chita masmi chaskin­gapa chaianga”. Chasa iuia­na­kugpi­pas, sug­kuna chas­kis­ka­sina­lla­ta­ta chaskin­gapa chaiarka. ");
INSERT INTO inb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—Chaskispaka, chagra­iugta kalla­rir­ka­kuna, rabia­rispa, kasa nin­gapa: ");
INSERT INTO inb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Kati chaia­mug­kuna, sug ura­lla­mi pallar­ka­kuna. Nukan­chikar, indi iapa rupa­ri­kus­ka­pi­mi chisiarkan­chi. ¿Ima­pa­tak pai­kuna chaskis­ka­sina­lla­ta­ta nukan­chita paga­chirkangi?”. ");
INSERT INTO inb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Chasa uiaspa chagra­iugka, sug pai­purata nirka: “Waugki, nuka kamta mana jiru ima­pipas rura­kui­kichu. ‘Chisiagta pallag­sina bali kulkimi kuasaki’ nuka ni­ura, ¿mana­chu aini­warkangi: ‘Ari’? ");
INSERT INTO inb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kam­ta chaia­kuska kulkita apaspa rii. Nukami munarkani, kam­ba kati samus­ka­kuna­ta­pas, kam­kunata imasa­mi kuan­gapa chaiá: chasa­lla­ta kuan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nuka­pa kulkita, ¿manachu pudi­ni, nuka imasa munas­ka­sina ruran­gapa? Nuka­pa alli iuiai­wa chasa kuaska­manda, ¿imapatak kam­ka mana alli­lla iuiaspa kawa­kungi?”. ");
INSERT INTO inb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Chasa­llatami tukun­gapa ka: kuna­ura kati ni­raias­ka­kuna, ñug­pa ladu­ma­mi tukun­gapa kan­kuna. Ikuti kuna­ura ñug­pa ni­raias­ka­kunaka, kati ladu­ma­mi tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jeru­salén pui­bluma ñambi ri­na­kus­kapi, Jesuska, chunga iskai kati­raiag­kuna­lla­ta kaiaspa, nirka: ");
INSERT INTO inb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Uia­wai­chi. Jeru­salen­ma­mi ri­na­kun­chi. Chipika, kai Runa Tukus­kaka iaia sasir­duti­kunapa i Moisés ima nis­kata iacha­chig taita­kunapa maki­pi­mi api­chii tukun­gapa ka. Chi runa­kunaka, nuka­manda nin­ga­pa­mi kan­kuna: “Wañu­chiimi chaiá”. ");
INSERT INTO inb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nispaka, mana judíu kas­ka­kuna­pag­ma­mi chaia­chi­wan­ga­pa kan­kuna. Pai­kuna, nukata unz̈a­waspa, asuti­waspa, kruspi kla­baspa­mi wañu­chi­wan­gapa kan­kuna. Chasa wañuska kaspa­pas, kimsa punchapika ikutimi kaug­sa­rin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chi­ura Zebedeopa warmi, iskan­di wambra­kuna­wa Jesus­pagma kailla­iaspaka, kungu­rirka, kasa nispa: —Nuka ima maña­kus­kata, ¿mana­chu uia­wantrangi? ");
INSERT INTO inb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chi­ura, Jesús tapurka: —¿Imatak muna­kungi? Chasa uiaspa, chi warmika ai­nirka: —Kam mandangapa tia­rispa chaia­ura, kai nuka­pa iskandi wam­bra­kunata tia­ri­chi­puangi: sug­taka, kamba alli ladu; sugtaka, kam­ba lluki ladu. ");
INSERT INTO inb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesuska nirka: —Mana iachangichichu ima maña­na­kugta. Nukata chaia­wan­ga­pa­mi ka, iapa achka llakii­kuna iukan­gapa. ¿Kam­kuna­paschu chasa­lla­ta pudintran­gi­chi, llakii­kunata pasan­gapa? —Ari— ainir­ka­kuna—, chasa pudin­ga­pa­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesuska nir­ka­kunata: —Ari, nuka llakii­kuna­sina­lla­ta­ta, kam­kuna­pas­mi pasankan­gi­chi. Chi nuka­pa alli ladu lluki ladu tia­ri­chin­gapaka, nukata mana chaia­wa­kunchu kawan­gapa. Mai­kan nuka­pa Taita agllas­ka­kuna­ta­mi chasa tia­ri­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chi iskai waugkindi­kuna ima maña­na­kus­kata uiaspaka, chi sug chunga kati­raiag­kuna rabia­rii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesuska, pai­kunata kaiaspa, nir­ka­kunata: —Kam­kuna alli­lla­mi iachan­gi­chi: kai alpapi atun mandag­kuna, manda­nakus­kapi kaug­sag­kunata ñi ima mana llakispa­lla­mi mandan­kuna. Chasa­lla­ta, mai­kan­pas atun mandag­sina tukuspa, mana llakispa­lla­mi runa­kunata charin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kam kikin­puraka, chasa rurag runa­kunaka mana kan­gi­chi. Kam kikin­pura mai­kan, Diuspa ñawi­pi atun kan­gapa munaspaka, sug­kunapa lutrin­sina tukuchu. ");
INSERT INTO inb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mai­kan mas atun taita kan­gapa munagpas, ñug­pa iukanmi sug­kunapa lutrin­sina kanga. ");
INSERT INTO inb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chasa­lla­ta kai Runa Tukus­kaka mana samurkachu, sug­kunata lutrin­sina churan­gapa. Tukui­kunapa lutrin­sina kan­ga­pa­mi nuka samurka­ni. Nuka­pa wañui­wa­mi achka­kunata kispi­chin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pai­kuna Jerikó suti pui­blu­manda llugsispa ri­na­kus­kata, iapa achka runa­kuna Jesusta kati­chii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chi ñambi kuchu­pi, iskai runa mana ñawi kawag­kuna­mi tia­na­kurka. Chi runa­kunaka, Jesús ña iali­kugta uiaspa, kapa­rii kalla­rir­ka­kuna, kasa nispa: —Davidpa wam­bra Iaia Jesús, nukan­chi­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chi achka kati­raiag­kuna, pai­kunata piñaspa, ni­na­kurka: —Upalla kai­chi. Pai­kunaka, upallanga­taka, mas sin­chimi kapa­rii kalla­rir­ka­kuna, nispa: —Davidpa wam­bra Iaia Jesús, nukan­chi­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Chasa uiaspa Jesuska, saia­rispa, chi runa­kunata kaiaspa, tapurka: —¿Imatak muna­na­kun­gi­chi, nuka kam­kunata ruran­gapa? ");
INSERT INTO inb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chi­ura ainir­ka­kuna: —Taita waugki, nukan­chi kawan­ga­pa­mi muna­na­kun­chi. ");
INSERT INTO inb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Chi­ura Jesuska, suma llaki­rispa, ñawi­kunata llamkarka. Chasa llamkag­lla­pi, alli­lla kawai kalla­rir­ka­kuna. Nispaka, Jesusta katii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jeru­salenma ña kailla­ia­na­kuspa, Betfajé suti pui­blu ña kawa­ri­kuska­manda, Olivos suti luma­kama chaiag­rir­ka­kuna. Chi­manda Jesuska, iskai kati­raiag­kunata kacharka, ");
INSERT INTO inb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kasa nispa: —Rii­chi chi ñug­pa ladu uchulla pui­bluma. Chaiag­rispaka, sug bura wata­raias­ka­ta­mi tarig­rinkan­gi­chi. Wawa burupas, sug­lla­pi­mi kanga. Chi burata paskaspa, iskandi­kunata apa­mun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mai­kan tapuchu: “¿Ima­pa­tak apa­pua­kungi?”: chi­ura ainin­gi­chi: “Iaia Jesus­ta­mi minis­ti­ku. Maña­chii. Ñami kuti­chi­munga”. ");
INSERT INTO inb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chasa tukug­samurka, Santu Ispi­ri­tu­wa ñug­pata willa­raias­ka­sina. Chipika, kasa­mi ni­raiá: ");
INSERT INTO inb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sión luma­manda warmi­kuna­ta kasa willa­puai­chi: “Kawai­chi. Kam­kunapa atun mandagmi samu­ku. Mana imapas iukag­sina­mi samu­ku, sug burupi tia­riska. Apa­ri­chi­diru animalpa maltu wawa buru­pi­mi tia­riska samu­ku”. ");
INSERT INTO inb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chi kachai tukus­ka­kunaka, rispa, imasa Jesús nis­ka­sina rurag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burata wawandi­wanta Jesus­pagma apar­ka­kuna. Chaia­chig­rispaka, burapa wasapi pai­kunapa katan­ga­kunata churar­ka­kuna. Chasapika Jesús, tia­rispa, rii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chasa Jesús ri­kugta kawaspa, achka runa­kuna, pai­kuna kata­raiaska katan­ga­kunata ñambi suiu manda­chir­ka­kuna. Sug­kunaka, panga­iug sacha uchulla malki­kunata kuchuspa, ñambi ñambi churar­ka­kuna, pai ialin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nispaka Jesusta ñug­pag­kuna i paipa kati ri­na­kug, kasa kapa­rispa nii kalla­rir­ka­kuna: —Ñug­pa­manda taita Davidpa wam­brami kangi. Kam iapa suma kag­ta­mi nin­chi. Atun Taita Dius kacha­muskami samu­kungi. Paipa iapa kuiaskami kangi. Taita Dius awa suma luarpi kag­ta­pas­mi nin­chi: “Kam, iapa suma­mi kangi”. ");
INSERT INTO inb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús chasa Jeru­salenma chaiag­ri­uraka, chipi kaug­sag­kuna, iapa achka runa­kuna kati­raiag­kunata kawaspa, mancha­rispa tapu­na­kurka: —Chi runa, ¿pi­sik ka? ");
INSERT INTO inb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kati­raiag­kunaka ainir­ka­kuna: —Jesús suti Santu Ispi­ri­tu­wa rimag­mi ka. Galilea alpa i Nazaret pui­blu­manda­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chi­ura­manda Jesuska, Diuspa atun wasi ukuma iaikug­rispaka, katug­kunata i randi­na­kugta chi ukupi kawarka. Chi­manda, iapa rabia­rispa, tukui­kunata llugsi­chii kalla­rirka. Kulki trukag­kunapa misa­kunata i paluma katug­kunapa banku­kuna­ta­pas bula­chirka, ");
INSERT INTO inb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","kasa nispa: —Ñugpa­manda librupi, kasa­mi willa­raiá: “Nuka­pa wasi, Taita Dius­ta iuia­rispa maña­dirumi kan­ga­pa ka”. “Kam­kunaka, sisai kaug­sa­diru­sina­mi rura­na­kun­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús chi ukupi kag­lla­pi, mana ñawi kawag­kuna i mana purii pudig­kuna pai­pagma kailla­iar­ka­kuna. Chi­ura, paika ambir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iaia sasir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kuna, Jesús chasa mana ima­ura­pas kawas­ka­sina rura­kus­kata kawa­na­kurka. Wam­bra­kuna­pas, Diuspa atun wasi ukupi kapa­rispa ni­na­kurka: Ñug­pa­manda taita Davidpa wam­brami kangi. Kam iapa suma kag­ta­mi nin­chi. Chasa uiaspaka, chi taita­kuna, rabia­rispa, ");
INSERT INTO inb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesusta tapur­ka­kuna: —Kai­kuna ima kam­manda kapa­ri­na­kugta, ¿manachu uia­kungi? Chi­ura, Jesuska ainirka: —Ari. ¿Manachu ñug­pa­manda li­bru­pi kawarkan­gi­chi kasa willa­raiagta? Uchulla wawa­kunata chu­chug wawa­kuna­wan­ta­mi iacha­chirkangi, “Tukuipi iapa suma atunmi kangi” nin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chasa nispaka, pai­kuna­pag­manda anchu­rirka. Chi atun pui­blu­manda llugsispaka, Betania pui­bluma rispa, chipi paka­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chi tutata, Jeru­salenma ikuti ri­na­kus­kapika, Jesusta iarkai apig­samurka. ");
INSERT INTO inb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sug igus sachata ñambi kuchupi kawarka. Chi sachama chaiag­ri­uraka, ñi ima mikui mana iukarka; pangalla iukarka. Chi­ura, Jesuska nirka: —Kuna­ura­manda, ñi ima­ura­pas mana kai sacha mikui muiu tia­ri­chu. Chasa nig­lla­pi, chi sacha lim­piumi chaki­rirka. ");
INSERT INTO inb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chasa kawas­paka, kati­raiag­kuna iapa ujna­rir­ka­kuna, kasa tapuspa: —¿Ima­wasik chi sacha, chasa nig­lla­pi chaki­rirka? ");
INSERT INTO inb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesuska, pai­kunata ainirka: —Kasami nuka nii­ki­chita: kam­kuna mana sug rigcha iuiaspa­lla nuka­manda­lla iuiagpi­kunaka, imasa­mi chi sacha tukurka: chi­manda­pas masmi pudintran­gi­chi. Kai lumata nintran­gi­chi: “Kai­manda anchu­rispa, atun kucha iaku ukuma sita­rig­rii”; kam­kuna ima nis­ka­sina­mi tukug­samuntra. ");
INSERT INTO inb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chasa­lla­ta, nuka­manda suma iuia­rispa, tukui Taita Diusta mañagpi­kunaka, kam­kuna ima mañas­ka­sina­mi tukug­samuntra. ");
INSERT INTO inb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chi­mandaka Jesús, Diuspa atun wasi ukuma ikuti iaikug­rirka. Chipi iacha­chi­ku­uraka, iaia sasir­duti­kuna i sug taita­kuna­pas pai­pagma kailla­iar­ka­kuna, kasa tapun­gapa: —¿Imapatak chasa ruraspa puri­kungi? ¿Pitak kamta kacha­murka, atun tukuspa puri­kun­gapa? ");
INSERT INTO inb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesuska ainir­ka­kunata: —Nuka­pas, kam­kunata tapu­sa­ki­chita. Kam­kuna aini­wagpika, nuka­pas willa­sa­ki­chi­ta­mi, pi nukata kacha­mu­waspa atun­ia­chi­waska kagta. ");
INSERT INTO inb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pitak Juanta kacharka, baug­ti­san­gapa? ¿Taita Diuschu kacha­murka? Mana kagpika, ¿runa­kuna­lla­chu kacharka? Chi­uraka, kikin­pura rima­ri­na­kurka, kasa iuia­rispa: —“Taita Dius kacha­muskami karka” nigpika, paika ainingami: “Nig­pika, ¿imapatak mana paita uiar­kan­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Ru­na­kunalla kacha­muskami karka” mana ni­sun­chi. Tukui­kuna­mi Juan­manda iuia­nakú: “Santu Ispi­ri­tu­wa rimag­mi karka”. Pai­kunata chi­mandami manchai iukan­chi. ");
INSERT INTO inb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chasa rima­na­kuspa, Jesusta ainir­ka­kuna: —Mana iachan­chichu, Juanta pi kacha­muska kagta. Chasa aini­ura, Jesuska nir­ka­kunata: —Chi­mandami nuka­pas mana willai­ki­chita, pi kacha­mu­waska kagta, atun tukuspa kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kasapasmi Jesús nir­ka­kunata: —¿Imasatak kai parlu, kam­kunata uia­rintra? Sug runa, iskai wam­bra­kunasi iukarka. Chi runaka, atun wam­brata kaiaspa, nirkasi: “Rii chagrama. Ubas pallag­rii”. ");
INSERT INTO inb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Paika ainirka: “Mana muna­ni­chu rin­gapa”. Chasa ainispa­pas, kipama alli­lla iuia­rispa, maima kacha­kuska­ma rirkalla. ");
INSERT INTO inb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Uchulla wam­bra­ta­pas, taita kailla­iaspa, chasa­lla­tasi nirka. Chi­ura ainirka: “Ñami risa, taita”. Chasa ainispa­pas, manimasi rirka. ");
INSERT INTO inb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chasa parlaspaka, Jesús tapur­ka­kunata: —Chi iskandi­kuna, ¿mai­kantak taita imasa muna­kus­ka­sina alli­lla rurarka? —Atun wam­bra— ainir­ka­kuna. Chasa aini­ura, Jesuska nir­ka­kunata: —Kasami nuka nii­ki­chita: mana judíu kas­ka­kuna­manda kulki chaskig­kuna i kari­sapa warmi­kuna, kam­kunapa ñug­pa­mi suma luarma iaikug­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bau­tista samurkami, kam­kunata imasa sumag­lla kaug­saita iacha­chin­gapa. Kam­kunakar, mana paita uiarkan­gi­chi. Kulki chaskig­kuna i kari­sapa warmi­kuna­pas, pai rima­kus­kata suma iuia­rispa, suma kaug­sai­wa­mi kalla­rir­ka­kuna. Chasa kawaspa­pas, kam­kunakar ñi ima manima. ");
INSERT INTO inb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Sug iuiai apinga­sina parlu­ta­pas uia­wai­chi. Sug runa, achka ubas sacha malki­kunasi paipa alpa­pi tarpurka. Chi alpa muiundi kincha saia­chispa, ubas iaku surku­diru­pas­si rurarka. Chasa­lla­ta, awa kawitu saia­chirka, tarpus­kata kawa­nakun­gapa. Chasa ruraspaka, sug runa­kunata chi ubas sacha­kunata sakirka, almaspa, chaugpi chaugpi pallan­gapa. Chasa sakis­paka, karu alpama rirka. ");
INSERT INTO inb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","—Ña pallan­gapa chaia­uraka, sug piun­kunata chi almag­kuna­pag­ma kacharka, paipa rasiunta chas­kin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chi runa­kunaka, kachai tukus­ka­kunata apispa, sugta makar­ka­kuna; sugta wañu­chir­ka­kuna; ikuti sugtaka rumi­kuna­wa piar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","—Chi­ura­manda, ikuti ñug­pa­manda mas achka piun­kunatasi kacharka. Chi­kuna­ta­pas chasa­lla­tasi mana alli rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—Katimakar duiñuka, kikin­pa wam­bratasi kacharka, kasa iuia­rispa: “Nuka­pa wam­bra kag­manda, mana imapas rura­puan­ga­kunachu”. ");
INSERT INTO inb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—Nigpika chi almag­kunaka, chi wam­brata kawaspa, kikin­pura rima­rir­ka­kuna, kasa nispa: “Kawai­chi. Kai alpa duiñupa wam­brami samu­ku. Pai­ta­pas wañu­chi­sun­chi. Chasaka, nukan­chi­pa­lla­mi kai alpa tukunga”. ");
INSERT INTO inb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—Chasa nispaka, paita apispa, chi alpa­manda llugsi­chispa, wañu­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chasa parlaspaka, Jesús tapurka: —Nigpi chi duiñuka, ¿imatak chi runa­kunata rurag­samunga? ");
INSERT INTO inb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chi­ura ainir­ka­kuna: —Chasa mana alli rurag­kunata mana llakispa­lla­mi wañu­chin­ga­kunata. Nispaka, chi sacha­kunata ikuti sug­kuna­ta­mi alman­gapa sakinga. Mikui palla­ura, paipa rasiunta alli­lla kuag­kuna­ta­mi sakinga. ");
INSERT INTO inb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pai­kuna chasa aini­ura, Jesus­ka nirka: —¿Manachu ñug­pa­manda li­bru­pi kasa willa­raias­kata kawarkan­gi­chi? Wasi­chig­kuna wabutiska rumi, wasita charigmi tukug­samurka. Atun Taita Diusmi chasa rurarka. Nukan­chi, iapa ujna­rispa­mi chasa ruras­kata kawa­na­kun­chi. ");
INSERT INTO inb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chi­mandami kasa nii­ki­chita: Taita Dius, kam­kunata suma mandag kaska­manda anchu­rin­ga­pa­mi ka. Sug­kuna, pai imasa munas­ka­sina alli rurag­kuna­pag­pi­mi suma mandag tukun­gapa ka.  ");
INSERT INTO inb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kasapas. Mai­kan chi rumipi urmag­kuna, piti pitimi tukun­ga­kuna. Chasa­lla­ta, chi rumi awalla urmag­pika, ñutumi tukun­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chasa parlu­kunata uiaspaka, iaia sasir­duti­kuna i fari­seo­kuna iuia­rir­ka­kuna: “Nukan­chi­mandami chasa parlu­wa ni­ku”. ");
INSERT INTO inb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chi­manda, rabia­rispa, Jesusta api­chin­gapa muna­nakurka. Chasa muna­nakuspa­pas, achka runa­kuna chipi kag­manda, manchai apir­ka­kunata. Tukui­kuna­mi iuia­na­kurka: “Jesús, Santu Ispi­ri­tu­wa rimagmi ka”. ");
INSERT INTO inb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesuska, sug luar­manda man­dai­manda ikuti iuiai apinga­sina suma parlar­ka­kunata, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Sug atun mandag, paipa wam­bra kasara­ku­ura, suma mikui mikun­gapa kaiarka. ");
INSERT INTO inb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Chi kasarai puncha ña chaia­mu­uraka, lutrin­kunata kacharkasi, tukui kun­bi­das­ka­kunata: “Samui” nig­rin­ga­pa. Chasa willag­ri­ura, kun­bi­das­ka­kunaka nir­ka­kunasi: “Manima pudi­nichu”. ");
INSERT INTO inb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—Chasa uiaspaka, chi mandagka ikuti sug lutrin­kunata kacharkasi, kasa nispa: “Kun­bi­das­ka­kunata willag­rii­chi: ‘Tukui alli­chiskami ka. Maltu i wira wagra wañu­chis­ka­kuna i tukui mikui ianuskami tia’. Tukui samu­chu­kuna, kasarag­kuna­wa sug­lla­pi mikun­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Chasa ikuti willag­rigpi­pas, chi kunbidas­ka­kuna manimasi uiar­ka­kuna. Sugka, paipa chagrama rirka. Sugka rirkasi, paipa katu­diru­kunata katun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ikuti sug­kunaka, piun­kunata tanda­rispa, wañug­tasi makar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Chasa uiaspaka, chi man­dag­ka, rabia­rispa, paipa sul­da­du­kunata kacharka, chi wañu­chig­kunata puchukan­gapa i pai­kunapa pui­bluta rupa­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nis­paka, piun­kunata nirkasi: “Tukui mikui, ñami alli­chiska ka, kasarag­kuna­wa sug­lla­pi mikun­ga­pa. Nuka ñug­pa kunbidas­ka­kuna, mana alli iuiag­kuna kaspa, mana samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chi­manda kam­kuna, tukui ñambi­kunama rii­chi. Tukui iali­na­kus­kata nig­rii­chi samu­chu­kuna, kasarag­kuna­wa sug­lla­pi mikun­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Chi­ura piun­kuna, tukui ñambi­kunama rispa, mai­tuku iali­na­kus­kata kasarag­kunapa wasima pusar­ka­kunata. Alli u mana alli runa­kuna, mai­tuku tari­ris­ka­kunata tanda­chir­ka­kuna. Chasaka, wasi ukupi junda­chig­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Ña chi mandagka, kun­bi­das­ka­kunata kawan­gapa iaiku­ura, sug runaka suma katanga maña­chis­kata mana chura­riska kagta kawarka. ");
INSERT INTO inb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Paita kawas­paka, nirka: “Kam waugki, ¿ima­pa­tak nuka katanga maña­chis­kata mana chura­rispa­lla iaikurkangi?”. —Chi runa, ñi ima mana ai­nirka. ");
INSERT INTO inb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Chi­ura chi mandagka, piun­kunata nirkasi: “Kai runata apii­chi. Chakita i makita watai­chi. Nis­paka, kanchama iana tutapi sitag­rii­chi. Chipi, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa ka”. ");
INSERT INTO inb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chasa parlaspa, Jesuska nirka: —Achkakunami kaiaska kan­kuna. Agllas­ka­kunaka, mai­lla­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Chasa uiaspa, fari­seo­kunaka pai­pura rima­na­kug­rirka, Jesús ima rima­kus­kata uiaspa, ima­pipas panda­rigpika, justi­sia­kunata willag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nispaka, sug pai­pura­kunata i mandag Herodeswa purig­kunata Jesus­pagma kachar­ka­kuna, kasa sumag­lla nin­gapa: —Iacha­chig taita, nukan­chi iachan­chimi, kam mana llullaspa­lla rimagta. Mana pi­ta­pas kawaspa­lla­mi tukui­kunata iwal­lla sutipa kas­kata iacha­chingi, imasa Taita Dius munas­ka­sina ruraspa kaug­san­gapa­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chi­mandami tapug­samun­chi: kam, ¿imatak ningi? ¿Alli­lla­chu ka, Roma­manda iaia mandagta nukan­chi impuistu kuan­gapa? ¿Paga­sun­chi­chu u mana? ");
INSERT INTO inb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesuska iacharka, mana alli­lla iuiai­wa chasa tapu­na­kugta. Nis­paka, nir­ka­kunata: —Kam­kuna sungu awalla iuiag­kuna, ¿imapatak muna­na­kun­gi­chi pan­da­chi­wan­gapa? ");
INSERT INTO inb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Impuistu kul­ki kua­diruta kawa­chi­wai­chi. Chi­ura, sug kulki apag­rispa kuag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chita kawaspa, Jesus­ka tapur­ka­kunata: —Kai kulkipi, ¿pipa ñawitak kawa­ri­ku? ¿Pi­mandatak willaska ni­raiá? ");
INSERT INTO inb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Roma­manda iaia mandag­manda— ainir­ka­kuna. Chasa aini­ura, Jesuska nir­ka­kunata: —Chasa kagpika, Roma­manda iaia mandagpa kas­kata paita kuai­chi. Taita Diuspa kas­kataka Taita Diusta kuai­chi. ");
INSERT INTO inb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Chasa uiaspaka, iapa ujna­rir­ka­kuna. Nispaka, paita sakispa, anchu­rir­ka­kunalla. ");
INSERT INTO inb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chi puncha­lla­ta­ta, sug sadu­seo suti runa­kuna Jesus­pagma chaiag­rir­ka­kuna. Chi runa­kuna iacha­chi­durmi kan­kuna, wañus­ka­kuna mana mas kaug­sa­rin­gapa kagta. Chaiag­rispaka, Jesusta nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Iacha­chig taita, Moiseska kasa­si nirka. Sug kari kasaraspa, war­mi manara wam­bra­kuna iukag­lla­pi wañugpika, sug waugkindisi iuká chi biuda­wa kasaranga; chasaka, wañug waugkindipa kuinta wawa­kuna iukan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","—Nigpika, kan­chis waug­kin­di­kunasi nukan­chipa alpapi tiarka. Atun waugkindika, kasa­raspa, warmi manara wawa­kuna iukag­lla­pisi wañurka. Chi­wanka, kipa­manda waug­kin­disi chi sapalla kidaska warmi­wa kasarai iukarka. ");
INSERT INTO inb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chi waug­kin­di­pas, chasa­lla­ta wañurka. Kati­manda waug­kin­di­ta­pas chasa­lla­ta pasa­rirka. Chasa­lla­tasi tukui kan­chis waug­kin­di­kuna wañur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Katimakar, chi warmipas wañurka. ");
INSERT INTO inb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nigpika, wañus­ka­kuna kaug­sa­ri­uraka, ¿pipatak chi warmika kanga, tukui chi kan­chis waug­kin­di­kuna­wa kasadu kaspa? ");
INSERT INTO inb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesuska ainir­ka­kunata: —Kam­kuna, ñug­pa­manda li­brupi willa­raias­kata ñi Taita Diuspa iapa iachaita mana iuiai iukangi­chi­chu. Chi­man­da­mi panda­rispa iuia­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wañus­ka­kuna kaug­sa­riska­ura­mandaka, kari ñi warmi mana kasa­ran­gapa kan­kunachu. Imasa suma luar­manda anjil­kuna­sina­mi kaug­san­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Kasapas. ¿Imapatak kam­kuna nin­gi­chi: “Wañus­ka­kuna mana mas kaug­sa­rin­gapa kan­kunachu?”. ¿Manachu kasa willa­raias­kata kawarkan­gi­chi? “Taita Dius nirka: ");
INSERT INTO inb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nukami kani Abra­hampa, Isaakpa i Jakobpa Taita Dius’.” Taita Dius mana kanchu wañus­ka­kunapa. Kaug­sag­kuna­pa­mi Taita Dius ka. ");
INSERT INTO inb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesús chasa iacha­chis­kata uias­paka, tukui chipi kag­kuna iapa ujna­rispa mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús sadu­seo­kunata chasa ai­ni­ura, upalla uiar­ka­kuna. Chasa iachaspa, sug fari­seo­kunaka Jesus­pagma tanda­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nispa sug pai­pura, Moisés ima nis­kata iacha­chig taita kaspa, Jesusta panda­chin­gapa iuiaspa, tapurka: ");
INSERT INTO inb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Iacha­chig taita, tukui man­dai­kuna­manda, ¿mai­kantak mas atun ka? ");
INSERT INTO inb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chi­ura, Jesuska ainirka: —“Kamba atun Taita Diusta ku­iangi kam kikinpa alma­wa, tukui animu­wa i tukui iuiai­kuna­wa”. ");
INSERT INTO inb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chi mandaimi tukui­kuna­manda mas atun ka. ");
INSERT INTO inb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","—Kai kati­mandapasmi chi man­dai­sina­lla­ta­ta atun ka: “Kam kikin­ta­sina­mi iukangi, tukui runa­kuna­ta­pas kuianga”. ");
INSERT INTO inb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moisés i Santu Ispi­ri­tu­wa rimag­kuna tukui iacha­chis­ka­kuna, chi iskandi mandai­kuna­pi­mi willa­raiá. ");
INSERT INTO inb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chi fari­seo­kuna chara tanda­riska kan­kama, Jesuska tapur­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Taita Dius agllaska Cristo­manda, ¿imasatak kam­kuna iuia­na­kun­gi­chi? ¿Pipa wam­brapa kati wam­bratak ka? Chi­ura ainir­ka­kuna: —Davidpa wam­brapa kati wam­bra. ");
INSERT INTO inb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chi­ura, Jesuska nir­ka­kunata: —Chasa kagpika, ¿imapatak kikin Davidka, Santu Ispi­ri­tu­wa kaspa, Cristo­manda nirka: “Nuka­pa iaia”? Kasa willa­raias­ka­pi­mi David nirka: ");
INSERT INTO inb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Atun Taita Diusmi nuka­pa iaiata nirka: “Nuka­pa alli ladu tia­rii, nuka tukui kamta mana munag­kunata apag­rispa, kamba chaki saru­diru ukuma churan­kama”. ");
INSERT INTO inb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chasami David kikin, Cristo­manda nirka: “Nuka­pa iaia”. Nig­pika, ¿ima­wantak Cristo, paipa wam­brapa kati wam­bra kanga? ");
INSERT INTO inb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chi­ura, ñi pipas mana pudir­ka­kuna, ñi ima rimai­wa Jesus­ta ainin­gapa. Chi puncha­manda, ñi pipas mana animu iukar­ka­kuna, paita imapas tapun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Chi­ura Jesuska, paita kati­raiag­kunata i tukui chipi kag­kunata rimarka, ");
INSERT INTO inb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","kasa nispa: —Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna nin­kuna: “Nukan­chi­ta­mi chaia­ku, Moisés mandaraiaska imasa ni­raias­kata iacha­chin­gapa”. ");
INSERT INTO inb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chi­mandami kam­kunata nii­ki­chita: pai­kuna tukui ima iacha­chis­kata suma uiaspa ruran­gi­chi. Ikuti pai­kuna ima ruras­ka­kuna­sinaka mana ruran­gi­chi. Pai­kuna suma iacha­chispa­pas, kikin­kunaka sug rigchami ruran­kuna. ");
INSERT INTO inb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iapa mana pudi­ringa­sina llasa apa­ri­chig­sina­mi iacha­chin­kuna, pai­kuna imasa nis­ka­sina ruraspa kaug­san­gapa. Chasa iacha­chispa­pas, pai kikin­kunaka mana munan­kunachu, imasa iacha­chi­na­kus­ka­sina ruraspa kaug­san­gapa. ");
INSERT INTO inb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Pai­kuna, alli­lla imapas ruran­kuna, “Kawa­wa­chu­kuna” iuias­pa­lla. Chasa pai­kuna, printipi i makipi ñug­pa­manda librupi willa­raias­kata wata­rispa­mi purin­kuna, ianga kawa­chi­ringa­paglla. Chasa­lla­ta, sug­kuna­manda mas atun suma siñi­dur­kuna katangama wataspa­mi kawa­chi­ringa­paglla purin­kuna. ");
INSERT INTO inb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Maima kunbidagpi suma mikun­gapa kaia­ura, ñug­pa ladu tia­rin­ga­pa­mi munan­kuna. Tanda­ri­diru wasi­kuna­pipas munan­kunami, atun taita­kuna tia­ri­diru ñug­pa ladu tia­rig­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kallipi pai­kuna­wa tupa­na­kus­kapi munan­kunami, iapa suma kuiai­wa kumu­rispa, “Puan­gi, iacha­chig taita” nin­ga­pa­kunata. ");
INSERT INTO inb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Kam­kunaka mana saki­rin­gi­chi, sug­kuna, “Iacha­chig taita” nispa, kam­kunata kuian­gapa. Nuka­lla­mi kam­kunapa iacha­chig taita kani. Tukui kam­kuna, waug­kindimi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chasa­lla­ta, kai alpapi ñi pi­ta­pas mana nin­gi­chi: “Taita”. Suglla Taita­mi iukan­gi­chi: suma luarpi kaug­sag Taita Dius. ");
INSERT INTO inb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mana munan­gi­chi, sug­kuna kam­kunata atun­ia­chiska mandag­kuna ni­raian­gapa. Nuka­lla­mi kani kam­kunata kawaspa mandag Cristo. ");
INSERT INTO inb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chi­manda, kam­kunata mas mandag tukun­gapa munag­pika, kam­kunapa lutrin­sina tukuchu. ");
INSERT INTO inb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mai­kan­pas atun­ia­chi­rispa iuiagta, Taita Diuska uchulla­ia­chin­ga­pa­mi ka. Ikuti mai­kan­pas uchulla­iaspa iuias­ka­taka, Taita Dius atun­ia­chin­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Suma luarpi iaiku­nakus­kata arka­na­kug­sina­mi kan­gi­chi. Kam kikin­kuna mana muna­na­kungi­chi­chu iaikun­ga­pa. Iaikun­gapa muna­na­kug­ta­pas­mi arka­na­kug­sina rura­na­kun­gi­chi.  ");
INSERT INTO inb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Warmi sapalla kidas­ka­kunata wasi­kuna­ta­mi kichu­dur kan­gi­chi. Nispaka, kawa­chi­ringa­pag­lla­mi unai Taita Diusta rima­naku­dur kan­gi­chi. Chasa ruras­ka­kuna­mandami sug luarpi sug­kuna­manda­pas mas llakii­pi justi­siai tukun­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Kam­kuna­mi iapa munan­gi­chi, lamar iaku chimbaspa, karu alpa­kunapi purig­rispa, suglla runa­lla­pas kam­kuna­manda tarig­rin­gapa. Chi runa, ña kam­kuna­wa puri­kuspa, kam­kuna­manda­pas mas iapa jiru in­fir­nu­manda kuku­sina­mi tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—¡Ai, kam­kuna, mana ñawi­iug sug­kunata pusa­na­kug­sina­mi ni­raian­gi­chi! Kasa­mi iacha­chi­dur kan­gi­chi: “Mai­kan­pas nichu: ‘Diuspa atun wasi kawa­wa­kumi; kasa­mi rurasa’; chika mana balinchu. Ikuti, ‘Diuspa atun wasi ukupi kuri tiaska kawa­wa­kumi’ nigpika, chi­kar balinmi” nin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mana ñawi­iug upa­kuna­sina­mi kan­gi­chi! ¿Mai­kantak mas bali ni­raiá: kuri u Diuspa atun wasi? Chi wasi ukupi tiaska­mandami chi kuri Dius­pa­lla tukug­samuska ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Kasapasmi iacha­chi­dur kan­gi­chi: “Mai­kan­pas nichu: ‘Altarmi kawa­wa­ku; kasa­mi rurasa’; chika mana balinchu. Ikuti, ‘Altarpi churaska kama­ri­kumi kawa­wa­ku’ nigpika, chikar balinmi” nin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Mana ñawi­iug­kuna­sina­mi kan­gi­chi! ¿Mai­kantak mas bali ni­raiá: kama­ri­ku u altar? Altarpi churaska­mandami Taita Diusta kawa­chiska kama­ri­ku ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nigpika, mai­kan­pas: “Altarmi kawa­wa­ku” nig­pika, tukui ima altarpi churas­ka­kuna­pas­mi kawa­ku. ");
INSERT INTO inb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mai­kan­pas: “Diuspa atun wasimi kawa­wa­ku” nigpika, Taita Dius chipi kaug­sa­kuska­pas­mi kawa­ku. ");
INSERT INTO inb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mai­kan­pas: “Suma luarmi kawa­wa­ku” nig­pika, Taita Diuspa manda­diru, kikin chipi tia­kug­pas­mi kawa­ku. ");
INSERT INTO inb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Minta, anis i kuminu suti iuiu­kuna pallas­ka­kuna­manda chungapika, sug­lla­mi Taita Diusta karan­gi­chi. Chasa karaspa­pas, kam kikin­kuna kunga­riskami kan­gi­chi, sug­kuna­manda mas atun mandai­kunata ruran­gapa, kasa: sug­kunata imasa chaias­ka­sina alli­lla ruraspa, sug­kuna­manda llaki­rispa, Taita Diusta suma iuiaspa kaug­san­gapa. Chunga pallaska­manda sug karan­gapa mana sakispa­lla, iukangi­chimi chi sug atun mandai­kuna­ta­pas alli­lla ruraspa kaug­san­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kam­kuna mana ñawi­iug, sug­kunata pusa­na­kug­sina­mi ni­raian­gi­chi. Upia­na­kus­kapi sug kukitu tias­kata anchu­chig­sina­mi ruran­gi­chi. Ikuti sug wagra­taka tragag­sina­mi ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Kuashag i platuta awalla­lla­mi maillan­gi­chi. Ikuti kam­kunapa iuiai ukumaka, sug­kunapata iapa muna­rispa i sisa­rispa kaug­sag­kuna­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kam fari­seo­kuna mana ñawi­iug, sug­kunata pusa­na­kug­sina­mi ni­raian­gi­chi. Ñug­pa, kam­kunapa jiru iuiai­kunata maillag­sina rurai­chi. Chasa ruraspaka, tukui maillas­ka­sina­mi tukunkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Wañuska pamba­raiaska bubidata iura­ia­chis­ka­sina­lla­mi kan­gi­chi. Awalla, chi iura­ia­chiska bubida­kuna suma­mi kawa­rin­kuna. Ikuti chi ukumaka, wañuska ismuska tullu­kuna tukui millai jiru asna­kuna­mi junda­raiá. ");
INSERT INTO inb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kam­kuna­pas, chasa­sina­mi kan­gi­chi. Runa­kunapa ñawipi, suma alli iuiai iukag runa­kuna­sina­mi kawa­rin­gi­chi. Ikuti kam­kunapa iuiai ukumaka, tukui mana alli jiru iuiai­kuna jundami kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna, sungu awalla rimag­kuna! Ñug­pa­manda Santu Ispi­ri­tu­wa rimag­kuna­manda iuia­rispa, suma atun bubida­kuna ruraspa­mi kan­gi­chi. Chasa­lla­ta, ñug­pa­manda alli ruraspa kaug­sag runa­kuna pamba­raias­kata suma­ia­chispa­mi kan­gi­chi, ");
INSERT INTO inb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","kasa nispa: “Nukan­chipa ñug­pa­manda taita­kuna­wa nukan­chi kaug­san­gapa chaiagpika, manami chi Santu Ispi­ri­tu­wa rimag­kunata wañu­chin­gapa sakin­chi”. ");
INSERT INTO inb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chasa nispaka, kam kikin­kuna­mi willa­ri­na­kun­gi­chi, chi Santu Ispi­ri­tu­wa rimag­kunata wañu­chig­kunapa wam­bra­kuna kagta. ");
INSERT INTO inb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nigpika, kam­kunapa ñug­pa­manda taita­kuna imasa kalla­ris­kata, chi iuiai­lla­wan­ta puchukai­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—¡Kulibra­kuna­sina, mana alli runa­kuna­mi kan­gi­chi! ¿Imasatak kispi­rin­gapa kan­gi­chi, dil­tudupa nina­ma sitai tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chi­mandami Santu Ispi­ri­tu­wa rimag­kunata, suma iacha­kunata i iacha­chig­kunata nuka kacha­mun­gapa kai­ki­chi­ta. Chi kacha­mui tukus­ka­kunata, mai­kan­kuna­taka wañu­chin­ga­pa­mi kan­gi­chi. Sug­kuna­taka kruspi warku­chispa­mi wañu­chin­gapa kan­gi­chi. Ikuti sug­kuna­taka kam­kuna tanda­ri­diru wasi­kunapi asutispa kan­gapa kan­gi­chi. Sug­kuna­taka sug pui­bluma sug pui­bluma miti­ku­chispa­mi kan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Chi­manda, kai alpapi tukui alli­lla ruraspa kaug­sa­na­kuska wañu­chii tukus­ka­kuna­manda, kam kikin­kuna­mi iapa achka llakii iukan­gapa kan­gi­chi. Ari, Abel suti alli runa musug­lla wañu­chii tukuska­ura­manda­ta, sugka, Bere­kiaspa wam­bra Zaka­rías suti, Taita Diuswa iuia­ri­diru uku i altarwa chaugpipi wañu­chii tukuska­ura­kama, mai­tuku wañu­chii tukus­ka­kuna­manda­pas­mi iapa achka llakii iukan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kasa­mi nuka nii­ki­chita: kuna puncha­kuna­manda runa­kuna, tukui­kuna­mandami chasa llakii iukan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—¡Ai, Jeru­salén, Jeru­salen­manda runa­kuna! Kam­kuna, Santu Ispi­ri­tu­wa rimag­kunata wañu­chigmi kan­gi­chi. Kam­kuna­pagma kacha­muska runa­kuna­ta­mi rumi­wa piaspa wañu­chin­gi­chi. Imasa­mi ata­walpa, paipa pullitu­kunata kunu­chin­gapa kaiaspa ugllarí: chasa­lla­ta­mi nuka­pas, achka biaji kaiaspa, tanda­chin­gapa muna­na­kurkai­ki­chita. Chasa muna­kugpi­pas, kam­kunaka mana nukata muna­warkangi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chi­mandami kam­kunapa wasi­kuna, sitaska tukug­samun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kasa­mi nii­ki­chita: kuna­ura­manda mana kawa­wan­gapa kangi­chi­chu, ima­ura kam­kuna kasa ni­wan­kama: Atun Taita Dius kacha­muskami samu­kungi. Paipa iapa kuiaskami kam kangi. ");
INSERT INTO inb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Diuspa atun wasi uku­manda Jesús llugsispa ri­ku­uraka, paita kati­raiag­kuna kailla­iar­ka­kuna, chi wasi imasa suma kas­kata kawa­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesuska ainir­ka­kunata: —Kai kantiaska rumi­kuna­wa saia­chiska suma wasi­manda, kasa­mi nuka willai­ki­chita: chi tukui pia­chiska rumi­kuna, ñi sug mana sakin­gapa kan­kunachu. Tukui­ta­mi urma­chispa puchukan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Olivos lumapi chaiag­rispa tia­rig­ri­uraka, Jesusta kati­raiag­kunalla, kailla­iaspa, tapur­ka­kuna: —Nukan­chita willai: ¿ima­uratak chasa pasa­ringa? Kam ikuti samun­gapa puncha i kai alpa puchuka­rin­gapa puncha chaian­ga­pa ka­ura, ¿ima­watak chi pasa­rin­ga­pa kas­kata kawa­chinkangi? ");
INSERT INTO inb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Chi­ura, Jesuska ainir­ka­kunata: —¡Ujala­llapas mai­kan, kam­kunata llulla­chispa panda­chi­chu­kuna! ");
INSERT INTO inb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Achka­kuna­mi, nuka­sina tukuspa, samun­gapa kan­kuna, kasa nispa: “Nukami Taita Dius agllaska Cristo kani”. Chasa rima­na­kus­ka­waka achka runa­kuna­ta­mi llulla­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","—Tukuimami mana llakispa­lla wañu­chi­na­kugta iacha­rin­gapa ka; kam­kuna mana mancha­ri­na­kun­gi­chi. Chasa­mi pasa­rin­gapa ka. Nig­pi­pas, kai alpa puchuka­rii puncha manara chaia­muska ni­raian­chu. ");
INSERT INTO inb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ñug­pa­mi sug mandag alpa­nig­manda­kuna­wa sug­nig­manda­kuna­wa wañu­chi­nakui tian­gapa ka. Iapa iarkai­mi tian­gapa ka. Sug­nig­manda sug­nig­mandami alpa kuiu­rispa chapu­rispa rin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chi llakii­kuna pasa­riska, chara kalla­rii­lla­mi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Chi puncha­kuna, kam­kunata apispa, mandag­kuna­ta­mi apan­ga­kuna. Kam­kunata iapa llaki­chispa nana­chispa­mi wañu­chin­ga­kuna. Tukui alpa­manda runa­kuna­mi kam­kuna­wa rabia­rin­ga­kuna, kam­kuna nuka­wa kag­manda. ");
INSERT INTO inb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","—Chi puncha­kuna, achka­kuna­mi sakin­gapa kan­kuna, Taita Diusta iuia­rin­gapa. Chi­kunaka, pariju­ma­mi piña­chi­ri­na­kuspa­lla, api­chi­na­kuspa, mandag­kuna­pagma apa­na­kun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Achka llulla­chig­kuna­mi kawa­rig­samun­ga­pa kan­kuna, kasa nispa: “Nuka­mi Santu Ispi­ri­tu­wa rimag kani”. Chasa rimas­ka­kuna­waka achka runa­kuna­ta­mi llulla­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iapa achka mana alli rurag­kuna­mi miran­gapa kan­kuna. Chi­wanka, achka­kuna­mi sakin­gapa kan­kuna, pai kikin­pura kuia­na­kuspa kaug­san­gapa. ");
INSERT INTO inb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Chasa kag­pi­pas, wañun­kama nuka­lla­wa iuia­rispa kag­kuna­mi kispi­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Diuspa suma mandai­manda Alli Willaita, kai alpapi tukui kaug­sa­na­kus­kata willa­ura­mi kai alpa puchuka­rii puncha kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Ñugpa­manda Santu Ispi­ri­tu­wa rimag, Daniel suti, kasa­mi willarka: iapa jiru mana kawanga­sina­mi ruran­gapa kan­kuna. Sug ianga dius­sina rigchata Taita Diuspa tukui­kuna­manda mas alli uku­pi­mi saia­chin­gapa kan­kuna. Chi­taka, kam­kuna kawan­ga­pa­mi kan­gi­chi. (Chasa willa­raias­kata alli­lla iuiai­wa iuia­rispa kawan­gi­chi.) ");
INSERT INTO inb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chasa kawas­paka, Judea alpapi kaug­sa­na­kug, sachuku­ma miti­ku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mai­kan­pas wasi truja awapi kag­kuna, mana urai­ku­naku­chu, ukuma iaikuspa, ima­kuna apan­gapa. Imasa kas­ka­sinalla miti­ku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chasa­lla­ta mai­kan­pas chagrapi kag­kuna, mana wasima kuti­chu­kuna, katanga u imapas tanda­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ai, mai­kan warmi­jim­kuna, chi puncha­kuna wigsa­wa ungug u uchulla markaska kag­kuna! ");
INSERT INTO inb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taita Diusta mañan­gi­chi, mana chaia­chu, tamia puncha u warda puncha miti­kui tian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","—Chi puncha­kuna, asku­rinti iapa llakiimi tian­gapa ka. Taita Dius kai alpa wiña­chiska­ura­manda­ta kunan­kama, chasa llakii­ka mana tiaska kanchu. Chasa­lla­taka, kuna­ura­manda mana ikuti chasa tian­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Taita Dius chi llakii puncha­kunata mana pisia­chigpika, ñi pipas mana­char kispi­rintra. Pai agllaska runa­kunata iapa kuiaspa­mi chi puncha­kunata pisia­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Chi­ura­kuna, kam­kunata ni­na­kungami: “Uia­mui­chi. Taita Dius agllaska Cristo, kai­pi­mi ka” u “Chi­pi­mi ka”. Chasa ni­na­kugpi­pas, kam­kuna mana uian­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi puncha­kuna, iapa llulla­chig­kuna­mi kawa­rig­samun­gapa kan­kuna, kasa nispa: “Nukami Cristo kani” u “Nuka­mi Santu Ispi­ri­tu­wa rimag kani”. Chi runa­kunaka, mana ima­ura­pas kawas­ka­sina i iapa ujna­ringa­sina­mi kawa­chin­gapa kan­kuna. Chasa kawa­chis­ka­waka Taita Dius agllas­ka­kuna­ta­pas­mi ñalla llulla­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Manara chasa tukun­gapa chaiagpi­ta­mi alli­lla willai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—“Uia­mui­chi. Cristo, chusa sitaska alpa­pi­mi ka” nigpi­pas, kam­kuna mana chima rin­gi­chi. “Uia­mui­chi. Kai wasi uku­pi­mi ka” nigpi­pas, mana uian­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Imasa­mi rilampa, indi llugsi­diru­nig­manda puncha­ia­chig­samuspa, indi chinga­ri­dirupi puncha­ia­chí: chasa­lla­ta­mi kai Runa Tukuska, kuti­muspa, kawa­rig­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Imasa­mi, pipas mana willagpi, ga­lli­na­su­kuna wañuska kaska­ma tanda­rin­kuna: chasa­mi, nuka samu­ura, tukug­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Chi iapa llakii puncha­kuna ialig­lla­pika, indimi amsaian­gapa ka; killa­pas, manami puncha­ia­chin­ga­pa ka; istrilla­kuna, awa­mandami urman­gapa kan­kuna; kai alpa­manda awa ladu tias­ka­kuna­pas­mi kuiu­chii tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chi­ura kai Runa Tukuskapa siñalka, awa puiu­kuna­pi­mi kawa­rig­samun­gapa ka. Chasa kawas­paka, kai alpapi tukui runa­kuna ajaimi wakan­gapa kan­kuna. Kai Runa Tukuska samug­ta­mi kawa­wan­gapa kan­kuna. Nuka­pa tukui iapa suma iachai­wa awa puiu uku­pi­mi samun­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Samus­paka, nuka­pa anjil­kuna­ta­mi kachasa. Pai­kunaka, bututu­sina­wa sin­chi uia­chispa, tukui chusku kuchu­nig­mandami nuka agllaska runa­kunata tanda­chi­puan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—Kai iuiai apinga­sina suma rimai­wa iachai­kui­chi. Imasa­mi igus sacha malki­kuna wiñaspa, pan­ga­kuna ña susu­ri­ura, kam­kuna kawaspa, nin­gi­chi: “Ñami alli pun­cha­kuna chaia­mu­ku”: ");
INSERT INTO inb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","chasa­lla­ta kam­kuna, tukui chasa pasa­ri­na­kus­kata kawaspaka, ñami iachan­kan­gi­chi, nuka ña chaia­mu­kugta. ");
INSERT INTO inb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","—Kasami nuka nii­ki­chita: manara tukui kuna­ura kaug­sag­kuna wañugpi­mi tukui chasa tukug­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sug luar i kai alpa luar puchuka­rigpi­pas, nuka ima nis­kaka mana ialin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Ima puncha ima ura chasa tukug­samun­gapa kagta, mana pipas iachan­chi­chu. Ñi suma luar­manda anjil­kuna ñi Diuspa wam­brapas mana iachanchu. Nuka­pa Taita­lla­mi iachá. ");
INSERT INTO inb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Imasami, Noé kaug­sa­ku­ura, mana iuia­na­kus­ka­sina tukug­samurka: chasa­lla­ta­mi kai Runa Tukuska kawa­rig­samun­gapa pun­cha tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noé kaug­sa­kuska puncha­kunaka, manara atun iaku­wa puchukai tukun­kama, sumag­lla mikuspa, upiaspa, kasaraspa­mi kaug­sa­na­kurka, Noé ruraska atun barkupi iaikun­kama. ");
INSERT INTO inb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pai­kuna kungaska kaug­sa­naku­ura­mi, chi atun tamia tukug­samuspa, tukui­kunata puchu­kag­samur­ka­kunata. Chasa­lla­ta­mi kai Runa Tukuska kawa­rig­samun­gapa puncha tukug­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Chi­ura, iskai runa­kuna chagrukupi puri­na­kus­kata, sugtaka apangami; sugtaka sakingami. ");
INSERT INTO inb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chasa­lla­ta, iskai warmi­kuna sug­lla­pi kuta­na­kus­kata, sugtaka apangami; sugtaka sakingami. ");
INSERT INTO inb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—Chi­manda, iuiaipilla kan­gi­chi. Kam­kuna mana iachangi­chi­chu, ima ura kam­kunapa iaia samun­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","—Kasa iachai­chi: wasi duiñu iachantra, ima ura sisai samun­gapa kagta. Iachaspaka, mana puñu­rispa­llachar rigcha­raiantra, paipa wasipi mana sisai iaikun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chasa­lla­ta kam­kuna­pas, alli­chi­ris­ka­sina suia­na­kun­gi­chi. Kam­kuna mana iuia­na­ku­ura­mi kai Runa Tukuska chaia­mun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Mai­kan tukuipi alli rurag piun kag­ta­mi paipa patrun sakirka, ima wasipi kawa­pun­gapa, sug piun­kunata mikui karaspa, pai kikin chaia­mun­kama. ");
INSERT INTO inb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patrun ikuti chaiag­samuspa, imasa nis­ka­sina alli­lla rura­kugta kawaspaka, chi piunta sumag­lla­mi “Pai Siñur” nispa, kuian­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chi­mandami paita mai­tuku ima iukas­ka­ta­pas mingaspa sakin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","—Ikuti chi piun, mana alli­lla iuia­rispa­lla nintra: “Nuka­pa pa­trun mana utka chaia­mun­gapa ka”. ");
INSERT INTO inb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chasa nispaka, sug piun­kuna­ta makai kalla­rintra. Kikinka, sug machangi­chu­kuna­wa sug­lla­pi mikuspa upiaspa kantra. ");
INSERT INTO inb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chi piun kungaska mana iuia­ku­ura­mi patrunka, chaia­muspa, shachig­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chasa shachig­samuspaka, paita sin­chimi asutin­ga­pa ka. Nispaka kachangami, sungu awalla rima­na­kugwa justi­siai tukun­gapa. Chipika, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús, suma luar­manda man­dai­manda kasa nirka: —Sug tuta chunga sipas­kuna, michun sindi chari­rispasi rir­ka­kuna, kusa tukun­gapa kas­kata tupan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Chi sipas­kunaka, pichkaka, alli­lla iuia­rispa kag­kuna; ikuti sug pichkaka, mana alli­lla iuia­rispa kag­kuna. ");
INSERT INTO inb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mana alli­lla iuia­rispa kag­kunaka, mana kirusin apar­ka­kuna, tallispa sindilla iukan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ikuti alli­lla iuia­rispa kag­kunakar, kirusinsi apar­ka­kuna, tallin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kusa tukun­gapa kag, mana utka chaia­murka. Chi­wanka, tukui­kuna puñu­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Chaugpi tutaka, kapa­riisi uia­rir­ka­kunata: “Uia­mui­chi. Kusa tukun­gapa kag, ñami samu­ku. Tukui­kuna tupag­ri­sun­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Chi­ura tukui sipas­kuna, ata­rispa, alli­chi­rir­ka­kuna, atun sindi michun ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chi­ura­lla­ta­ta mana alli­lla iuia­rispa kag­kuna, sug­kunata nir­ka­kuna: “Nukan­chipa michun sindi, ña­mi wañu­ku. Kam­kunapa kiru­sinta kara­wai­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Alli­lla iuia­rispa kag­kunaka ai­nir­ka­kuna: “Manima. Tukui­kuna­manda mana pagtangachu. Katug­kuna­pagpi randig­rii­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Chi mana alli­lla iuia­rispa kag­kuna kirusin randin­gapa rin­kamaka, kusa tukun­gapa kag ña chaia­murka. Chi­ura chi alli­chi­riska suia­nakug sipas­kunaka, kasarag­kuna­wa iaikur­ka­kuna, sumag­lla mikun­gapa. Iaikuspaka, punguta wichkar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Kipamaka, chi sug sipas­kuna­pas chaiag­samur­ka­kuna. Nispaka, kapa­rii kalla­rir­ka­kuna: “Taita turi, taita turi, pungu paska­puai”. ");
INSERT INTO inb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Paika, uku­nig­manda­lla ainir­ka­kunata: “Kasa­mi nuka nii­ki­chita: kam­kunata mana rigsii­ki­chi­tachu”. ");
INSERT INTO inb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chasa parlaspa, Jesuska nir­ka­kunata: —Kam­kuna­pas, alli­chi­ris­ka­sinalla suian­gi­chi. Mana iachangi­chi­chu, nuka ima puncha, masa ura chaia­mun­gapa kagta. ");
INSERT INTO inb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sug iuiai apinga­sina, Jesús suma parlarka, kasa nispa: —Sug patrun, sug­sinama rin­ga­pa kaspaka, lutrin­kunata kaias­pa, paipa kulki­kunata min­garka. ");
INSERT INTO inb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pai­kuna imasa pudinga­sina kawaspa­mi mingarka. Sug runata pichka kuri kulkisi min­garka; sug­taka iskai; ikuti sug­taka suglla. Chasa pai­kunata mingaspaka, sug­sinama rirka. ");
INSERT INTO inb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Chi pichka chaskig runaka, chi­ura­lla rispa, randispa katuspa, sug pichka mas­si mira­chirka. ");
INSERT INTO inb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iskai chaskig runapas, sug iskai mas­si mira­chirka. ");
INSERT INTO inb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ikuti suglla chaskig runaka, alpapisi pusu utkuspa, patrunpa kulkita pam­barka. ");
INSERT INTO inb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Ña unaipika, chi lutrin­kunapa patrunka kuti­murka. Nis­paka, pai­kunata kaiarka tapun­ga­pa, masa kulkimi mira­chiska tia­pun­kunata. ");
INSERT INTO inb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Chi­ura pichka chaskig runaka, chaia­muspa, sug pichka iapa­wa apa­muspa, nirka: “Taita waugki, kamta pichka kuri kulki­mi chaskirkaiki. Sug pichka mas­mi mira­chirkani”. ");
INSERT INTO inb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Chi­ura, chi patrunka ai­nirka: “Kam, iapa allimi kangi. Alli­lla­mi rurarkangi. Chasa mailla­lla­wa mira­chig­manda, kuna­ura­manda achkami mingasaki. Iaikui uku­ma, nuka­wa sumag­lla kan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Iskai chaskig runapas, cha­ia­muspa, sug iskai iapa­wa apa­muspa, nirka: “Taita waugki, kam­ta iskai kuri kulkimi chas­kirkai­ki. Sug iskai masmi mira­chirkani”. ");
INSERT INTO inb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Chi­ura, chi patrunka ai­nirka: “Kam, iapa allimi kangi. Alli­lla­mi rurarkangi. Chasa mailla­lla­wa mira­chig­manda, kuna­ura­manda achkami mingasaki. Iaikui uku­ma, nuka­wa sumag­lla kan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Chi suglla chaskig runaka, chaia­muspa, nirka: “Taita waugki, nuka iacha­nimi, kam sin­chi sungu iukagta; kam maipi mana tar­pus­kapi pallan­gapa munagta, maipi mana similla sitas­kapi tanda­chin­gapa munagta. ");
INSERT INTO inb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chasa iachas­paka, iapa­mi manchai api­warka. Chi­mandami kamba kulki­ta alpa ukuma pambarkani. Chi­ká. Kai­pi­mi tiapungi”. ");
INSERT INTO inb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—Chasa uiaspaka, chi pa­trun­ka nirka: “Kam, mana alli iuiai­iug, iapa killa wangu lutrinmi kangi. Kam alli­lla­mi iacharkangi, nuka maipi mana tarpus­kapi palla­dur kagta, maipi mana similla sitas­ka­pi tanda­chi­dur kagta. ");
INSERT INTO inb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Chasa iachas­paka, ¿imapatak nuka­pa kulki miran­gapa, mana banku­pi minga­puarkangi; chasaka, nuka kuti­mu­ura, iapa­wa kua­wan­ga­pa?”. ");
INSERT INTO inb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Chasa rimaspaka, chipi kag­kunata nirka: “Kai runata kulki ki­chus­pa, chi chunga iukagta kuai­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mai­kan iapa achka iukag­ta masmi karan­gapa ka, pu­chug­ta. Ikuti mai­kan mailla iukas­ka­taka tukuimi kichun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kai ñi imapapas mana balig lutrin­taka iana tuta kancha­pi­sina nina­ma sitag­rii­chi. Chipika, iapa llakispa, wakaspa, kiru mukuspa­mi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kasapasmi Jesús nirka: —Kai Runa Tukuska suma atun­ia­chiska samu­ura, tukui anjil­kuna­mi pai­wa samun­gapa kan­kuna. Paipa suma atun manda­diru­pi­mi tia­rig­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chi­ura, tukui­nig­manda runa­kuna­mi paipa ñug­pa ladu chaia­chii tukun­gapa kan­kuna. —Chasa chaia­chiska ka­uraka, alli­lla ruraspa kag­kunata i mana alli­lla ruraspa kag­kunata iskai­ma­mi saia­chin­gapa ka; imasa­mi ubija i kabra­kunata kawag, iskaima churá: chasa. ");
INSERT INTO inb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Alli­lla ruraspa kag­kunata alli ladumi saia­chin­gapa ka. Mana alli­lla ruraspa kag­kunataka lluki ladumi saia­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Nispaka chi atun man­dag­ka, paipa alli ladu kas­ka­kunata nin­ga­pa­mi ka: “Nuka­pa Taita­pa iapa kuias­ka­kuna, samui­chi, nuka­wa mandangapa. Kam­kuna chasa mandangapaka, alpa tukuska­ura­manda­ta­mi alli­chiska ka­purkan­gi­chita. ");
INSERT INTO inb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kam­kunaka, nuka iarkai­wa ka­ura, mikuimi kara­warkan­gi­chi. Nuka iaku­nai­wa ka­ura, upian­ga­pa­mi kara­warkan­gi­chi. Nuka ñambipi ia­lispa puri­ku­ura, kam­kunapa wasi­ma­mi kaia­warkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nuka mana katanga­wa ka­ura, kam­kuna­mi chura­chi­warkan­gi­chi. Nuka ungug ka­ura, kawa­wan­ga­pa­mi rirkan­gi­chi. Chasa­lla­ta, kar­sil­pi ka­ura, chaia­wag­rirkangi­chimi”. ");
INSERT INTO inb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Chi­ura, chi alli­lla ruraspa kag­kuna tapun­ga­pa­mi kan­kuna: “Tai­tiku, ¿ima­uratak, kam iarkai­wa kas­kata kawaspa, mikui kararkan­chi? ¿Ima­uratak, kam iaku­nai­wa kas­kata kawaspa, upian­ga­pa kararkan­chi? ");
INSERT INTO inb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ima­uratak, kam ñambipi ialispa puri­kus­kata kawaspa, kaiarkan­chi? ¿Ima­uratak, kam mana katanga­wa kas­kata kawaspa, chura­chirkan­chi? ");
INSERT INTO inb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ima­uratak kam ungug u karsilpi kas­kata chaian­gapa rirkan­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Pai­kuna chasa tapu­ura, chi atun mandag ainin­ga­pa­mi ka: “Kasa­mi nuka nii­ki­chita: kai nuka­pa uchulla waugki­kunata kam­kuna chasa ruras­kaka, nukata rura­wag­sina­mi rurarkan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Chasa nispaka, paipa lluki ladu kas­ka­kunataka kasa­mi nin­ga­pa ka: “Kam­kuna maldisis­ka­kuna, nuka­pa ñawi­manda anchu­rii­chi. Mana wañu­diru nina­ma rupan­gapa rii­chi, iaia kukuta i paipa anjil­kunata rupa­chin­gapa kaska­ma. ");
INSERT INTO inb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kam­kunaka, nuka iarkai­wa ka­ura, mana mikui kara­warkangi­chi­chu. Iaku­nai­wa ka­ura, mana upian­gapa kara­warkangi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ñam­bi­pi ialispa puri­ku­ura, mana wasima kaia­warkangi­chi­chu. Mana katanga­wa ka­ura, ñi ima mana chura­chi­warkangi­chi­chu. Ungug u karsilpi ka­ura, mana chaia­wan­gapa rirkangi­chi­chu”. ");
INSERT INTO inb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Chi­ura tapun­ga­pa­mi kan­kuna: “Tai­tiku, ¿ima­uratak kam iarkai­wa u iaku­nai­wa kas­kata, ñambipi puri­kus­kata u mana katan­ga­wa u ungug u karsilpi kas­kata kawaspa­pas, mana ñi imapas rurarkan­chi?”. ");
INSERT INTO inb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Pai­kuna chasa tapu­ura, ai­nin­ga­pa­mi ka: “Kasa­mi nuka nii­ki­chita: kai uchulla waugki­kunata ima­ura mana ñi imapas ruras­kaka, nukata rura­wag­sina­mi mana ñi imapas rurarkan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Chi mana alli­lla ruraspa kag­kuna, dil­tudupa llakii kaska­ma­mi rin­gapa kan­kuna. Alli­lla ruraspa kag­kunakar, suma luar mana puchuka­ri­diru kaug­sai tiaska­ma­mi rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Chi tukui ima rimas­kata puchukaspaka, Jesús, paita kati­raiag­kunata nirka: ");
INSERT INTO inb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Kasami kam­kuna iachan­gi­chi: paskua atun punchapa iskai puncha­lla­mi pisi­ku. Chi punchami kai Runa Tukuska apii tukun­gapa ka, kruspi wañu­chii tukun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chi puncha­lla­ta­ta, iaia sa­sir­duti­kuna i sug judíu taita­kuna tanda­rir­ka­kuna Kaifás suti iaia sa­sir­dutipa atun wasipi. ");
INSERT INTO inb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chipika, pai­pura rima­ri­na­kurka, Jesusta pakalla apispa wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iuia­rispa ni­na­kurka: —Kai atun puncha­kunaka, mana paita api­chi­sun­chi. Api­chigpika, tukui runa­kuna, iachas­paka, nukan­chi­wa­mi rabia­rin­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús, Betania pui­blu­pi­mi karka, Simón suti runapa wasipi. Chi Simón, aicha ismui ungui­wa ñug­pata karka. ");
INSERT INTO inb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús mikuspa tia­ku­uraka, sug warmi kailla­iarka. Chi warmi, suma asna asiti iapa bali kulki­wa randispa, marmul rumi buti­lla­pi apaspa­mi kailla­iarka. Nispaka, Jesuspa uma­pi­mi asitita tallirka. ");
INSERT INTO inb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Paita kati­raiag­kuna, chasa kawaspaka, rabia­rispa, kasa­mi kikin­pura ni­na­kurka: —¿Imapatak ianga tallí? ");
INSERT INTO inb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Chi asi­tita achka kulki­manda katuspa, mana ñi imapas iukas­ka­kunata chi kulki­kunata karan­ga­pa­mi chaia­kurka. ");
INSERT INTO inb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesuska, chasa uiaspa, nir­ka­kunata: —¿Imapatak kai warmita ni­na­kun­gi­chi, mana alli­lla ruragta? Pai­ka alli­lla­mi rura­warka. ");
INSERT INTO inb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ñi ima mana iukag­kunata ima­ura­pas­mi iukan­gapa kan­gi­chi. Ikuti nukataka sug ratu­lla­mi kawa­wa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kai warmi suma asiti­wa talli­was­kaka ni­raianmi, nuka­pa kuir­pu wañus­kata pamban­gapa ña alli­chiska sakig­sina. ");
INSERT INTO inb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kasa­mi nuka nii­ki­chita: tukui alpapi, mai­pipas nuka­manda Alli Willaita willas­kapi, kai warmi ima rura­was­ka­ta­pas parlan­ga­pa­mi kan­kuna, pai­manda mana kunga­rispa­lla. ");
INSERT INTO inb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nigpika chunga iskai Jesús agllas­ka­kuna­manda Judas Iska­riote sutika, iaia sasir­duti­kuna­pagma rispa, ");
INSERT INTO inb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tapur­ka­kunata: —Nuka kam­kunata Jesusta api­chigpika, ¿mai­tuku kulkitak kara­wantran­gi­chi? Chi­ura, pai­kuna ainir­ka­kuna: —Kimsa chunga kulkimi kamta kara­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chasa kulki chaskispaka, Judas maskai kalla­rirka, imasa Jesus­ta api­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tanda mana liba­dura­wa miku­diru atun puncha­kuna kalla­ri­ura, chi punchaka Jesusta kati­raiag­kuna, kailla­iaspa, tapur­ka­kuna: —Paskua punchapa mikui kam mikun­gapa, ¿maipitak munangi, nukan­chi alli­chig­rin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Chi­ura, Jesuska ainirka: —Rii­chi Jeru­salén pui­bluma, kasa suti runapa wasima. Paita nig­rii­chi: “Nukan­chita iacha­chig taita­mi kachamú, kamta nin­gapa: ‘Nuka­pa puncha, ñami chaia­mu­ku. Nuka muna­ku­nimi, kamba wasipi kati­raia­wag­kuna­wa paskua mikun­ga­pa’.” ");
INSERT INTO inb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Chasa uiaspa chi kati­raiag­kuna, imasa Jesús nis­ka­sina rurag­rispaka, alli­chir­ka­kuna, paskua mikun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ña tutaia­uraka, Jesús paipa chun­ga iskai agllaska runa­kuna­wan­ta tia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tukui­kuna mikuspa tia­na­ku­ura, Jesuska nir­ka­kunata: —Kasami nuka nii­ki­chita: kam­kuna­pura­manda, sugmi api­chi­wan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Chasa uiaspa, iapa llaki­rir­ka­kuna. Nispaka tukui­kuna, sug sug­lla tapui kalla­rir­ka­kuna: —Taita waugki, ¿nukachu api­chin­gapa kaiki? ");
INSERT INTO inb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesuska ainir­ka­kunata: —Kai platupi nuka­wa maki churag­pura­mi api­chi­wan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ima­sa­mi ñug­pa­manda­ta willa­raiá: chasa­lla­ta­mi kai Runa Tukus­kata pasa­ri­wan­gapa ka. Chasa kag­pi­pas, ¡ai, chi runa api­chi­wag! Chasa­paka, chi runa mana tiag­samunmi. ");
INSERT INTO inb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Chasa uiaspaka, Judas Jesus­ta api­chin­gapa kagka tapurka: —Iacha­chig taita, ¿nukachu api­chin­gapa kaiki? Chi­ura, Jesuska ainirka: —Ari, kammi kangi. ");
INSERT INTO inb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chara miku­nakun­kama Jesús, tandata makipi chari­rispa, “Pai Siñur” Taita Diusta nirka. Tanda­ta piti­chispa, kati­raiag­kunata kuaspa, kasa­mi nirka: —Chaskiwai­chi, mikun­gi­chi. Kai, nuka­pa kuir­pumi ka. ");
INSERT INTO inb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nispaka, sug binu kupata maki­pi chari­rispa, “Pai Siñur” Taita Diusta nispa, pai­kunata kuaspa, kasa­mi nirka: —Tukui­kuna upiai­chi. ");
INSERT INTO inb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kai, nuka­pa iawarmi ka, Taita Diuswa i runa­kuna­wa ikuti pasin­sia­chi­rispa sumag­lla tukun­gapa. Achka­kuna­manda­mi chi iawar llugsispa, icha­rin­gapa ka, panda­rii­kunata pasin­sian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kasa­mi nii­ki­chita: kai ubas iaku mana mas upian­gapa kani­chu, ima­ura nuka Taitapa suma mandai puncha chaian­kama. Chi punchami musu binuta ikuti kam­kuna­wa upian­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mikuska­ura­manda, kan­tas­paka, Olivos lumama rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chipi, Jesuska nir­ka­kunata: —Kasami ñugpa­manda librupi willa­raiá: “Ubija kawag­ta­mi wañu­chi­sa. Chi­ura paipa ubija­kuna, kasa­ma chasa­ma­mi miti­kun­gapa kan­kuna”. Chasa­lla­ta­mi kam­kuna, kai tuta nukata mana rigsi­wag­sina saki­waspa, miti­kun­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nuka, wañuspa kaug­sa­rispaka, Gali­lea alpa­pi­mi ñug­pa kag­risa. Chi­pi­mi kawa­risa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Chi­ura, Pedroka nirka: —Kamta tukui­kuna sakigpi­pas, nukakar ñi ima­ura­pas mana sakin­gapa kaikichu. ");
INSERT INTO inb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesuska nirka: —Kasami nuka niiki: kai tuta, gallu manara kantagpi­mi kamka kim­sa biaji nuka­manda nin­gapa kan­gi: “Paita mana rigsi­nichu”. ");
INSERT INTO inb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedroka ainirka: —Kamwa wañun­gapa chaia­wagpi­pas, ñi ima­ura­pas mana chasa nin­gapa ka­nichu. Tukui Jesusta kati­raiag­kuna, chasa­lla­ta nir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jetsemaní suti wirtapi chaiag­rispaka, Jesuska kati­raiag­kunata nirka: —Kai­lla­pi tia­na­kui­chi, nuka chi ladu Taita Diusta mañaspa rimag­rin­kama. ");
INSERT INTO inb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chasa nispa, Pedrota i Ze­be­deopa iskai wam­bra­kunata pusas­pa, mas karuajma rirka. Chi­pika, llakii irkiaimi tukurka. ");
INSERT INTO inb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nis­paka, chi kimsandi­kunata nirka: —Nukata iapa llakii wañunga­sina­mi iuia­chi­wa­ku. Kam­kuna, kai­lla­pi suia­wai­chi, nuka­sina mana puñu­rispa­lla. ");
INSERT INTO inb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chasa nispaka, mas ñugpa­sinama rispa, alpama tupagta kumu­rispa, Taita Diusta mañai kalla­rirka, kasa nispa: —Nuka­pa Taitiku, pudi­rigpika, kai iapa llakiita anchu­chi­wai. Nuka chasa muna­kugpi­pas, nuka imasa munas­ka­sina mana tuku­chu. Kam imasa munas­ka­sina rurai. ");
INSERT INTO inb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chasa nispa, chi kimsandi­kuna­pagma kutispaka, puñu­na­kus­kata tarig­rispa, Pedrota nirka: —¿Manachu ñi sug ratu­lla­pas nuka­wa rigcha­raian­gapa pudirkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mana puñu­rispa­lla, Taita Diusta maña­na­kui­chi, tukui mana alli­lla rurai­kuna kam­kunata mana chaiachu. Sungupi alli­lla ruran­gapa muna­na­kuspa­pas, kuir­pupika iapa sambami kan­gi­chi. Chi­wa­mi mana pudin­gi­chi, alli­lla ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chasa nispaka, ikuti rispa, Taita Diusta mañarka, kasa nispa: —Taitiku, kai iapa llakiita mana anchu­chi­wai pudi­rin­gapa kag­pika, kam imasa munas­ka­sina rurai. ");
INSERT INTO inb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sug ratuma ikuti pai­kuna­pag­ma kuti­ura, puñu­na­kus­kata tarig­rirka. Pai­kunapa ñawi, di­puñui wañu­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chasa kawaspaka, pai­kunata sakispa, Taita Diusta imasa­mi ñug­pata maña­kurka: chasa­lla­ta­mi kimsama mañarka. ");
INSERT INTO inb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nispaka, ikuti pai­kuna­pagma kutispa, nirka: —Kuna­ura sama­rii­chi, puñui­chi. Nuka­pa ura chaiarkami. Kai Runa Tukuska, mana alli­lla rurag runa­kunapa maki­pi­mi ña urmarka. ");
INSERT INTO inb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ata­rii­chi. Akushi. Api­chi­wag runa, ñami kailla­ia­mu­ku. ");
INSERT INTO inb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús chasa rima­kug­lla­pi, Judas­ka chipi chaiag­rirka. Chi runa, Jesuspa chunga iskai ag­llas­ka­kuna­mandami karka. Chi runa­waka iapa achka­kuna­mi chaiag­rir­ka­kuna, ispada i garuti­kuna charispa. Pai­kunaka, iaia sasir­duti­kuna i sug judíu taita­kuna kachas­ka­kuna­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Chi Judas, manara rispa­lla, wi­llaska karka, kasa nispa: “Mai­kanta nuka muchasa; chimi ka. Chi­ta apin­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Imasa nis­ka­sina chaiag­ringa­lla­wa, Jesus­pagma kailla­iaspa, nirka: —Puangi, iacha­chig taita—. Chasa nispaka, paita mucharka. ");
INSERT INTO inb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesuska nirka: —Waugki, ¿imapatak samu­kungi? Chi­ura­lla, kailla­iaspa, Jesusta apir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Chasa kawaspaka, sug Jesus­wa kag­pura, maki suniaspa, is­pa­da surkurka. Nispaka, iaia sasir­dutipa lutrinta piaspa, sug rinri ialigta kuchurka. ");
INSERT INTO inb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesuska, paita nirka: —Kamba ispadata chura­chi­diru­lla­pita waka­chii. Ispada­wa wañu­chi­nakugka, ispada­lla­wan­ta­mi wañu­chii tukunga. ");
INSERT INTO inb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Manachu iachan­gi: nuka­pa Taitata nuka mañag­pika, kuna­ura­lla mana kuintai pudinga­sina anjil­kuna­ta­mi kacha­mu­wantra? ");
INSERT INTO inb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Chasa tukug­pika, ¿imasatak ima nuka­manda willa­raias­ka­sina alli­lla tukunga? ");
INSERT INTO inb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chasa nispaka, Judaswa ris­ka­kunata nirka: —¿Imapatak nukata, sisaita­sina ispada i garuti kaspi­kuna­wa api­wan­gapa samu­na­kun­gi­chi? Tukui puncha­kuna­mi Diuspa atun wasi ukupi nuka iacha­chispa tia­kurkani. Chipika, ¿imapatak mana api­warkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nigpika iukarkami, tukui kasa pasa­ringa, ñug­pa­manda Santu Ispi­ri­tu­wa rimag­kuna willas­ka­sina tukug­samun­gapa. Chi­ura Jesusta tukui kati­raiag­kuna, pai­lla­ta sakispa, miti­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesusta apispaka, Kaifás suti iaia sasir­dutipa wasima chaia­chig­rir­ka­kuna. Moisés ima nis­kata iacha­chig taita­kuna i sug judíu taita­kuna­pas, chipi tanda­riska kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedroka, karu karu­lla­pi kati­chispa, chi wasi kancha­kama chaiag­rirka. Nispaka, iaikuspa, chi wasi kawag runa­kuna­wa tia­rig­rirka, kawan­gapa: Jesus­ta, ¿ima­mi pasa­rig­samú? ");
INSERT INTO inb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iaia sasir­duti­kuna i tukui judíu taita­kuna­pas maska­na­kurka, pipas maski llullaspa­pas willantra, ima panda­riipas Jesús iukagta; chasa­ka, paita wañu­chin­gapa pudin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Achka­kuna pai­manda llu­llas­pa willa­na­kugpi­pas, manima panda­rii­kuna iukagta tarir­ka­kuna. Kati­ma­kar, iskai­kunaka chaiag­rir­ka­kuna, ");
INSERT INTO inb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kasa nispa: —Kasa nis­katami uiarkan­chi: “Nuka­mi pudini, Diuspa atun wasi­ta puchukan­gapa; nispaka, kimsa puncha­lla­pi ikuti saia­chin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chasa uiaspaka, iaia sasir­duti, saia­rispa, Jesusta tapu­chirka: —Kam­manda mana alli­lla rima­na­kus­kataka, ¿imapatak mana ainingi? ");
INSERT INTO inb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesuska, ñi ima mana ainirka. Chi­ura chi iaia sasir­dutika, paita nirka: —Kamta dil­tudupa kaug­sag Taita Diuspa ñawi­pi­mi niiki, kasa willan­gapa: ¿kamchu kangi Cristo suti Taita Diuspa wam­bra? ");
INSERT INTO inb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chi­ura, Jesuska ainirka: —Sutipami kam chasa nuka­manda ningi. Kasa­pas­mi nii­ki­chita: kai Runa Tukus­kata kawa­wan­ga­pa­mi kan­gi­chi, tukui mandu­iug Taita Diuspa alli ladu tia­kugta. Suma luar­manda puiu­kunapi samu­kug­ta­pas­mi kawa­wan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Chasa uiaspaka, chi iaia sa­sir­dutika, iapa rabia­rispa, kikin­pa katangata lliki­chi­rirka, kasa nispa: —Kikin Taita Dius­sina tukus­pa­mi willa­ri­ku. ¿Imapatak sug­kunata suia­na­ku­sun­chi, pai­manda imapas willan­gapa? Ñami nukan­chi kikin uiarkan­chi, imasa Taita Dius­sina tukuspa willa­rigta. ");
INSERT INTO inb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kam­kuna, ¿imatak nin­gi­chi? Chi­ura chi taita­kuna, Jesus­manda ainir­ka­kuna: —Paita wañu­chiimi chaiá. ");
INSERT INTO inb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chasa ainispaka, Jesusta ñawi­pi tukaspa, puñitiaspa rurar­ka­kuna. Sug­kunaka, paita ñawi kilpaspa, piaspa, ");
INSERT INTO inb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ni­na­kurka: —Kam Taita Dius agllaska Cris­to kaspaka, willamui: ¿pitak kam­ta piarka? ");
INSERT INTO inb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chi­kama Pedroka, chi wasi kan­cha­lla­pi­mi tia­kurka. Chi­ura sug kawag warmi, kailla­iaspa, paita tapurka: —¿Manachu kampas, chi Gali­lea­manda Jesuswa puri­kurkangi? ");
INSERT INTO inb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedroka, chasa uiaspa, tukui­kunapa ñawipi ainirka: —Manima iachanichu, kam ima­manda chasa rima­kugta. ");
INSERT INTO inb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Chasa ainispaka, ata­rispa, iai­ku­diru atun punguma rirka. Ikuti chi­pipas sug warmi, paita kawas­paka, chipi kag­kunata nirka: —Kai runapasmi chi Nazaret­manda Jesuswa puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedroka, ikuti chasa uiaspa, ai­nirka: —Diuspa ñawipimi niiki: nuka mana chi runata rigsi­nichu. ");
INSERT INTO inb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ikuti sug ratu­lla­pi, chipi kag­kuna­pas, kailla­iaspa, Pedrota nir­ka­kuna: —Kampas, sutipami chi runa­pura kangi. Kamba rimai­lla­pi­mi alli­lla rigsirí, pai­wa kam­pura­kuna kagta. ");
INSERT INTO inb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Chi­ura Pedroka, kikin­manda mana suma rima­rispa, nii kalla­rirka: —Nukaka, Diuspa ñawipi sutipa­mi nii­ki­chita, mana llu­llas­pa­lla. Nukaka, chi runata mana rigsi­nichu. Pedro chasa nig­lla­pika, gallu kan­tarka. ");
INSERT INTO inb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chi­ura iuia­rig­samurka, imasa Jesús kikin Pedrota nigta: “Gallu manara kantagpi­mi kamka kimsa biaji nuka­manda nin­gapa kan­gi: ‘Paita mana rigsi­nichu’.” Chasa iuia­rig­samuspaka, kanchama llugsispa, dillakii wakai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Paka­rig­lla­pi, iaia sasir­duti­kuna i judíu taita­kuna, tukui­kuna tanda­rispaka, Jesus­manda rima­na­kuspa iuia­rir­ka­kuna, paita wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Chasa iuia­rispaka, paita wataspa, Pilatos suti mandag­pagma chaia­chig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tukui chasa uiaspa, Judas Jesus­ta api­chigka kawarka, Jesús sutipa wañu­chii tukun­gapa kagta. Nispaka, kikin mana alli­lla ruraska­manda llakii piarka. Chi kimsa chunga kulkita iaia sasir­duti­kunata i sug taita­kuna­ta­pas kuti­chig­rirka, ");
INSERT INTO inb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","kasa nispa: —Nukaka, kunaurami iuia­ri­warka, mana alli­lla ruragta. Ñi ima panda­riipas mana ruraska runa­ta­mi wañu­chin­gapa api­chir­kani. Pai­kunaka nir­ka­kuna: —Nukan­chitaka, ¿imatak nin­kangi? Chika, kam kikin­lla­mi iachan­kangi. ");
INSERT INTO inb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Chasa uiaspa Judaska, Diuspa atun wasi ukuma kulki­kunata si­tas­pa, rirka sipi­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Iaia sa­sir­duti­kunaka, chi kulki­kunata tanda­chispa, nir­ka­kuna: —Kai kulkika kanmi sug runata katuska; chasaka, paita wañu­chin­ga­pa. Chi­mandami michá, Taita Dius­ta karaska kulki­kuna­wa chapun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chasa nispaka, tukui iuia­rir­ka­kuna, chi kulki­kuna­wa manga rura­diru suti alpata randin­gapa. Karu­nig­manda runa­kuna samuspa wañus­ka­kunata pamban­ga­pa­mi randir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chasa­mandami kunan­kama chi alpata suti­chiska ka­pun­kunata: “Iawar alpa”. ");
INSERT INTO inb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chasami tukug­samurka, imasa Jeremías suti Santu Ispi­ri­tu­wa rimag ñug­pata willas­ka­sina. Kasa­mi willa­raiarka: Israel­manda runa­kuna, kimsa chunga kulki kuas­kata ikuti sitaska kas­ka­ta­mi tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chi­kuna­waka, manga rura­diru alpata randir­ka­kuna. Chasami atun Taita Dius nukata: “Rurangi” ni­waska karka. ");
INSERT INTO inb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús, mandag Pilatos kas­kapi saia­rig­rirka. Paitaka, Pilatos tapu­chii kalla­rirka: —Kam, ¿judiu­kunapa atun mandagchu kangi? Chi­ura, Jesús ainirka: —Sutipami kam chasa nirkangi. ");
INSERT INTO inb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iaia sasir­duti­kuna i sug taita­kuna­pas Jesus­manda mana alli­lla ruragta nispa jucha­chi­na­kugpi­pas, paika tukui­pi­mi upalla karka. ");
INSERT INTO inb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chi­manda Pilatoska, paita tapurka: —¿Manachu uia­kungi, kam achka mana alli­lla ruras­ka­kunata willa­na­kugpi­pas? ");
INSERT INTO inb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesuska, ñi imapas mana ai­nirka. Chi­manda Pilatos, iapa ujna­rispa kawarka. ");
INSERT INTO inb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wata watapi atun puncha cha­ia­ura, Pilatos iacharka, sug mai­kan karsilpi kas­kata runa­kuna mañas­kata kacha­ringa. ");
INSERT INTO inb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chi puncha­kuna, tukui­kuna rigsiska Jesús Barra­bás suti runami kar­sil­pi wichka­raiarka. ");
INSERT INTO inb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tukui runa­kuna tanda­riska ka­ura, Pilatos tapur­ka­kunata: —¿Mai­kan­tatak kam­kuna muna­na­kun­gi­chi, nuka kacha­rin­ga­pa: Jesús Barra­basta u Cristo suti Jesusta?—. ");
INSERT INTO inb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Pilatos alli­lla­mi iacharka, ianga Jesusta mana munas­pa, wañu­chin­gapa muna­na­kugta. Chi­mandami chasa chipi kag­kunata tapurka.) ");
INSERT INTO inb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chi­uraka, Pilatos justi­siai rura­dirupi tia­kuska­ma, paipa warmika kasa nispa kacharka: “Chi alli runata ianga kawai. Nuka, kunan­tuta iapa mana suma­mi pai­manda muskurkani”. ");
INSERT INTO inb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Chi­kamaka iaia sasir­duti­kuna i sug taita­kuna­pas, chipi kag­kuna­wa chapu­rispa chapu­rispa rir­ka­kuna, kasa nispa: —Mañai­chi, Barra­basta kacha­richu. Jesustaka wañu­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ikuti Pilatoska tapur­ka­kunata: —Chi iskai runa­kunataka, ¿mai­kan­tatak kam­kuna muna­na­kun­gi­chi, nuka kacha­rin­gapa? Chi­ura, tukui chipi kag­kuna kapa­rir­ka­kuna: —Barra­basta. ");
INSERT INTO inb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Chasa uiaspaka, Pilatos tapur­ka­kunata: —Nigpika, ¿imatak muna­na­kun­gi­chi, kai Cristo suti Jesusta nuka ruran­gapa? Chi­ura, tukui­kuna kapa­rir­ka­kuna: —Kruspi churaspa wañu­chii. ");
INSERT INTO inb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatos tapur­ka­kunata: —Kam­kunataka, ¿imapitak kawa­rí, mana alli­lla ruraska kagta? Pai­kunaka, mas sin­chi kapa­rispa, ikuti nir­ka­kuna: —Kruspi churaspa wañu­chii. ");
INSERT INTO inb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Chasa iapa kapa­rispa uia­ri­na­kug­manda, Pilatos iuia­rirka, pai ñi imapas mana pudin­gapa kagta, kispi­chin­gapa. Nispaka, chipi kag­kuna­pa ñawipi iaku­wa maki mailla­rirka, kasa nispa: —Kai alli runa kam­kunapa maki­pi wañu­chii tukun­gapa kaska­manda, nukataka mana iuia­chi­wan­chu, ñi ima kulpa iukag­sina. Chika, kam­kuna­ta­mi chaian­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chi­ura tukui chipi kag­kunaka, kasa ainir­ka­kuna: —Ari, chi runa wañu­chii tukus­ka­manda, nukan­chita i nukan­chi­pa wam­bra­kunata imasa chaias­ka­sina chaiachu. ");
INSERT INTO inb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chasa uiaspaka Pilatoska, Barra­basta kacha­rirka. Jesustakar mana llakispa­lla iapa asuti­chirka. Nispaka, suldadu­kunapa makipi sakirka, pai­kuna kruspi klabaspa wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Chi­ura chi mandagpa suldadu­kunaka, Jesusta wasi kanchamalla pusar­ka­kuna. Chipika, tukui sul­da­du­kuna tanda­chi­rir­ka­kuna. Jesús kas­kapi muiugta saia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nispaka, paipa katangata surkuspa, sutipa mandag­sina kawa­rin­gapa, pichi katanga kata­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ispina­kunalla llaugtu simbaspa, paipa umapi chura­chir­ka­kuna. Pukunga bara alli makipi chari­chispaka, ñug­pa ladu kungu­rispa, mucha­na­kug­sina burla­ri­na­kurka, kasa nispa: —Puangi, kam judiu­kunapa atun mandag. ¿Alli­lla­chu ka­puan­gi?—. ");
INSERT INTO inb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Chasa ni­na­kuspaka, pai­ta tukaspa, pukungata kichus­pa, chi­lla­wanta umapi pia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Paita chasa asiska­ura­mandaka, pichi katangata sur­kuspa, ikuti kikinpata chura­chir­ka­kuna. Chi wasi­mandaka Jesusta llugsi­chir­ka­kuna, paita kruspi klabag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ri­na­kus­kapika, Sirene pui­blu­manda Simón suti runa, ñambi­pi tuparka. Chi runataka Jesús markaspa apa­kuska krusta marka­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota suti pamba­ma­mi Jesus­ta chaia­chig­rir­ka­kuna. (Chi Gól­gota ni­raianmi: “Uma Tullu pam­ba”.) ");
INSERT INTO inb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Chipika, mira kupal chapuska binu paita kara­na­kurka upian­gapa. Paika, chi binuta tan­tiaspa, mana munarka upian­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesusta kruspi klabaspaka, pai­pa katan­ga­kunataka suirtipi pug­llar­ka­kuna, iachan­gapa: imasa­mi chaiá, pai­pura sug sug apan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nispaka, chipi tia­rir­ka­kuna, paita kawa­na­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kruspi, Jesuspa uma awa la­du, sug willa­raiaskami churar­ka­kuna, kawaspa, ima­manda wañu­chii tuku­kugta iachan­gapa. Chipi, kasa­mi ni­raiarka: “Kaimi ka Jesús suti judiu­kunapa atun mandag”. ");
INSERT INTO inb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chi­lla­pita, iskai sisai­kunata krus­pi klabaspa saia­chir­ka­kuna: sug­taka Jesuspa alli ladu, sug­taka paipa lluki ladu. ");
INSERT INTO inb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chipi iali­na­kug, Jesus­ta kawaspaka, uma kaima chima chabsi­chi­rispa, kami­na­kurka, ");
INSERT INTO inb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kasa nispa: —Kam­sina ningi, Diuspa atun wasi­ta lim waglli­chispa, ikuti kimsa puncha­lla­pi saia­chin­gapa; kuna­ura kam kikin kispi­chi­rii. Kam sutipa Taita Diuspa wam­bra kaspaka, krus­manda urai­kui. ");
INSERT INTO inb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chasa­lla­ta iaia sasir­duti­kuna­pas, Moisés ima nis­kata iacha­chig taita­kuna, sug taita­kuna­wapas, Jesusta iapa unz̈aspa ni­na­kurka: ");
INSERT INTO inb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Chiins, sug­kunata kispi­chig­samurkasi. Nigpika pai kikinka, mana pudí kispi­chi­rin­gapa. Israel­manda runa­kunapa atun mandagsi ka. Kuna­urakar, krus­manda kikin­lla urai­kuchu. Chasa kawas­pa­mi pai­manda suma iuia­ri­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Taita Dius­lla­tasi iuiaspa karka. “Taita Diuspa wam­brami ka­ni” ni­kurka. Sutipa Taita Dius paita kuiagpika, kuna­ura kispi­chig­samu­chu. ");
INSERT INTO inb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sisai­kuna Jesuswa sug­lla­pi krus­pi kag­kuna­pas, chasa­lla­ta kami­nakurka. ");
INSERT INTO inb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ña chaugpuncha tuku­ura­manda chaugpi chisi­kama, tukui alpa tutaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chaugpi chisi ka­ura, Jesuska sin­chi kapa­rii­wa kapa­rirka, kasa nispa: —Elí, Elí, ¿lema sabaktani?—. Chi ni­raianmi: “Nuka­pa Dius, nuka­pa Dius, ¿imapatak nukata sapa­lla saki­wangi?”. ");
INSERT INTO inb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chasa uiaspaka, chipi saia­na­kug­pura nir­ka­kuna: —Kai runa, Elías suti ñug­pa­manda willag­ta­mi kaia­ku. ");
INSERT INTO inb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Chasa iuia­ringa­lla­waka, sug pai­pura saia­na­kuska­manda kal­parka. Sug ispunja apispa, chi­wa winja binuta juku­chispa, chaglla punta­pi churarka, Jesuspa simima ata­ri­chispa, chupa­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sug­kunaka nir­ka­kuna: —Ianga kawai. ¿Sutipachu Elías samú, paita kispi­chin­gapa? ");
INSERT INTO inb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesuska, ikuti sin­chi kapa­rispa, paipa ispi­ri­tuta Taita Diusta mingaspa, wañurka. ");
INSERT INTO inb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wañug­lla­pi, Diuspa atun wasi ukupi atun linsu arka­raiaska, awa­nig­manda ura ladu­kama chaugpi chaugpi­mi lliki­rig­samurka. Alpapas kuiu­rirka. Rumi piña­kuna­pas, chaugpi chaugpi paki­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chi­wanka, wañus­ka­kunapa bubida­kuna­pas paska­rir­ka­kuna. Taita Dius­manda­lla kaug­saspa wañus­ka­kuna, Jesús kaug­sa­riska­ura­manda, achka­kuna­pas­mi kaug­sa­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nispaka, pamba­raiaska­manda llugsispa, Taita Dius­pa­lla kaska Jeru­salén pui­bluma iaikug­rir­ka­kuna. Chipika, achka runa­kuna­ta­mi kawa­chi­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Alpa iapa kuiu­ri­kug­mandaka, kapitan i pai­wa Jesusta kawa­na­kugka, ima pasa­ri­kus­kata kawas­paka, iapa mancha­rispa, nir­ka­kuna: —Kai runa, sutipa­mi Taita Dius­pa wam­bra karka. ");
INSERT INTO inb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Achka warmi­kunapasmi chipi kar­ka­kuna, karu­manda­lla kawas­pa. Pai­kuna kar­ka­kunami Gali­lea alpa­nig­manda Jesusta sug­lla­pi kati­raiag­kuna, paita ima­pipas aidaspa. ");
INSERT INTO inb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pai­pura kar­ka­kunami María Magdalena, Zebedeopa wam­bra­kunapa mama i sug María suti­pas; chi María, Santiago i Jose­pa mama. ");
INSERT INTO inb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ña chisia­ku­uraka, Arimatea pui­blu­manda José suti achka iukag runaka Pilatos­pagma rirka. Chi runa­pas, Jesús iacha­chi­kus­kata iuiai apa­kurka. ");
INSERT INTO inb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chi runaka, Pilatos­pagpi iaikug­rispa, Jesuspa kuir­puta mañarka. Chi­ura, Pila­toska nirka: —Allillami ka. Apai­chi. ");
INSERT INTO inb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chi­ura Joseka, Jesusta krus­manda urai­ku­chig­rirka. Nispaka, musu linsu­wa maituspa, mur­ta­jarka. ");
INSERT INTO inb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sug rumi piñapi, José iukarka atun utku­chiska; chipika, kikin pambai tukun­gapa. Chi­pi­mi Jesuspa kuir­puta churag­rir­ka­kuna. Nispaka, utku punguta sug atun rumi­wa wichkaspa, sakir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","José ri­ura, María Magdalena i sug Maria­pas chi pungu ñug­pa ladu tia­rispa kidar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Warda punchapa alli­chi­diru pun­cha ña iali­ura, kaiandi iaia sa­sir­duti­kuna i fari­seo­kunaka Pila­tos­pagma chaiag­rir­ka­kuna, ");
INSERT INTO inb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kasa nispa: —Taita waugki, nukan­chi iuia­rirkan­chimi: chi llulla runaka, kaug­sa­kun­kama kasa­mi nirka: “Kimsa punchapika ikutimi kaug­sa­rin­gapa kani”. ");
INSERT INTO inb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chi­manda, sul­da­du­kunata kacha­puai, pamba­raiaska punguta chapa­na­kuchu, kimsa puncha ialin­kama. Mana kag­pika, pai­wa purig­kuna, kuir­puta apag­rispa, nin­ga­kunami: “Wañus­kaka, sutipa­mi kaug­sa­rirka”. Chasa llulla­chigpi­kuna, chi runa ñug­pa llulla­chis­ka­kuna­manda­pas mas mana alli­lla­mi tukug­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chi­ura, Pilatos nirka: —Suldadukunami iukan­gi­chi. Pusai­chi. Kam­kuna imasa munas­ka­sina rurag­rii­chi. ");
INSERT INTO inb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Chi­ura pai­kuna, rispa, pamba­raiaska punguta siñalaspa, mas suma wichkag­rir­ka­kuna. Nispaka, sul­da­du­kunata sakir­ka­kuna, chipi chapa­na­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judiu­kunapa warda pun­cha ña ialiska ka­ura, si­ma­na kalla­rii puncha u dumingu paka­ri­ku­uraka, María Magdalena sug Maria­wa rir­ka­kuna Jesús pamba­raiaska­ma, kawan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Chi­ura alpa, iapa kuiu­rig­samurka. Atun Taita Diuspa anjilsi, suma luar­manda urai­ku­muspa, chima kailla­iaspa, kawa­rig­samurka. Nis­paka, kilpa­raiaska rumita anchu­chispa, chi awalla tia­rirka. ");
INSERT INTO inb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chi anjil, rilampa puncha­ia­chii­sina­si kawa­rirka. Katanga­pas, iapa iura puiu­sinasi kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chasa kawas­paka, chi pamba­raiaska pungu­ta chapa­na­kug suldadu­kuna, iapa mancha­rispa, chugchu­rispa, wañus­ka­sinasi alpama urmar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Warmi­kunataka, anjil nirka: —Mana mancha­na­kui­chi. Iacha­nimi: kam­kuna, Jesús kruspi wañus­ka­ta­mi maska­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kai­pika mana kanchu. Imasa­mi pai kikin nirka: chasa­mi kaug­sa­rirka. Pai churaska kas­kata kawag­samui­chi. ");
INSERT INTO inb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kawaspaka, utka rii­chi. Paita kati­raiag­kunata willag­rii­chi: “Pai Jesús wañuska, ñami kaug­sa­rirka. Ñug­pa­mi Galilea alpa­ma rin­gapa ka. Chi­pi­mi kawa­na­kun­gapa kan­gi­chi”. Ñami willarkai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Chi warmi­kunaka, chasa uiaspa, chi­manda utka­lla anchu­rir­ka­kuna. Mancha­rispa, alli iuia­rispa, kalpar­ka­kuna, Jesusta kati­raiag­kunata willan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ri­nakug­lla­pi, Jesús kikinka pai­kunata kawa­rirka, “Puangi” nispa. Chi­ura pai­kuna, kungu­rispa, chakita ugllaspa, paita muchar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chi­ura, Jesuska nir­ka­kunata: —Mana mancha­nakui­chi. Rii­chi; nukata kati­raia­wag waugki­kunata willag­rii­chi, Gali­lea alpama ri­chu­kuna. Chi­pi­mi kawa­wan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Warmi­kuna ri­na­kun­kama, sul­dadu­kuna pamba­raiaska pungu­ta chapa­na­kug, Jeru­salén pui­bluma sug­kuna rir­ka­kuna, iaia sasir­duti­kunata tukui imasa pasa­rigta willag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chasa uias­paka, tukui taita­kuna­wa tanda­chi­ri­na­kuspa, suglla­sina iuia­rig­samur­ka­kuna, chi suldadu­kunata achka kulki karan­gapa. ");
INSERT INTO inb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kasa­si suldadu­kunata nir­ka­kuna: —Ningichi: “Tuta nukan­chi puñu­nakun­kama, Jesusta kati­raiag­kuna kuir­puta llugsi­chispa apar­ka­kuna”. ");
INSERT INTO inb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mandag Pilatos iachag­samugpika, nukan­chimi paita imasapas ni­sun­chi. Chasaka, kam­kuna­ta ñi imapas mana pasa­ringachu. ");
INSERT INTO inb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Chi suldadu­kuna, kulki chas­kispaka, imasa pai­kunata nis­ka­sina tukui­kunata willa­na­kurka. Chasa iacha­ris­kataka kunan­kama­mi judiu­kuna iuian­kuna chasa kagta. ");
INSERT INTO inb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesusta chunga sug kati­raiag­kunaka, Jeru­salen­manda Galilea alpama rispa, Jesús ñug­pata niska lumama chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chi­pika, paita tarig­rir­ka­kuna. Paita kawaspaka, kungu­rig­rir­ka­kuna. Sug­kunaka, Jesusta alli­lla kawa­na­kuspa­pas, iuia­na­kurka: “¿Sutipa­cha kantra?”. ");
INSERT INTO inb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kailla­iaspa, Jesuska nir­ka­kunata: —Taita Diusmi nukata kua­warka, sug luarpi i kai alpa luar­pi­pas nuka tukui­kunata mandan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chi­mandami tukui alpa suiu kachai­ki­chita, tukui runa­kunata iacha­chispa purin­gapa. Chasaka pai­kuna­pas, nuka­wa­mi tukun­ga­kuna. Pai­kunataka, Taita Diuspa, Wam­brapa i Santu Ispi­ri­tupa suti­wa baug­ti­saspa purin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iacha­chispa purin­gi­chi, nuka tukui kam­kunata nis­kata ruran­ga­pa. Nuka, tukui puncha­kuna­mi kam­kuna­wa sug­lla­pi kan­gapa kani, kai alpa ima­ura puchuka­rin­kama.");
INSERT INTO inb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diuspa Wam­bra Jesu­cristo­manda Alli Willai, kasa­mi kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Santu Ispi­ri­tu­wa ñugpa­manda rimag Isaías suti, kasa willaska ni­raiarka: Kawai. Nuka ima nis­kata willagta kamba ñugpa­mi kacha­kuni, kam­manda ñambi­kunata alli­chi­pun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chusa sitaska alpapi, sug runa kapa­ris­pa­mi puri­ku, kasa nispa: “Imasami ñambi alli­chin­chi: chasa­lla­ta alli iuiai­kunata apii­chi, atun Taita Diusta chaskin­gapa”. ");
INSERT INTO inb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chasami Juan Bautista, chusa sitaska alpapi kawa­rig­samurka, kasa nispa: —Panda­rii­kunata sakispa, Taita Dius­wa tukug­samui­chi. Baug­ti­sa­rii­chi, panda­rii­kunata pasin­siai tukun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea suiu alpa­manda i Jeru­sa­lén suti pui­blu­nig­manda, tukui­nig­manda runa­kuna pai­pagma chaiai kalla­rir­ka­kuna. Paika, Jor­dán suti iakupi mai­kan panda­ris­ka­kuna­manda willa­ri­na­kus­kata baug­ti­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanka, kamello suti animalpa agchata awaska katanga chura­ris­ka­mi karka. Karata siñi­dur­sina ruraspa chumbi­llis­ka­mi karka. Lan­gosta suti cha­pulin­sina i sachu­ku­manda abijun­kunapa dusi miski­lla­mi mikuspa kaug­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Paika, kasa nis­pa­mi willa­kurka: —Sug nuka­manda mas iachaka, nuka­pa katimi samun­gapa ka. Pai­ta, nuka mana pudi­nichu, kumu­rispa, paipa chaki­kunapi chura­ra­iaska wata­raias­kata paska­punga­pag­lla­pas. ");
INSERT INTO inb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nuka, iaku­lla­wa­mi baug­ti­sai­ki­chita. Paika, Santu Ispi­ri­tu­wa­mi baug­ti­san­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chi puncha­kuna Jesuska, Gali­lea suti alpa i Nazaret pui­blu­manda llugsispa, Juan­pagma rirka. Chipi chaiag­ri­ura, Juan, Jor­dán iaku­pi paita baug­ti­sarka. ");
INSERT INTO inb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús iaku­manda llugsi­ku­ura, paita awa suma luar paska­rigta kawa­rirka. Chi­manda Santu Ispí­ritu, paluma­sina rigcha kawa­ris­pa­mi pai­pagma urai­ku­murka. ");
INSERT INTO inb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Suma luar­manda rimaipas uia­rig­samurka, kasa nispa: —Kam, nuka­pa kuiaska wam­bra­mi kangi. Kamta kawaspa, iapa alli suma­mi iuia­chii­wa kawaiki. ");
INSERT INTO inb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chi­ura­mandaka Santu Ispí­ritu, Jesusta chusa sitaska alpa­ma pusarka. ");
INSERT INTO inb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chipika, sachu­ku­manda animal­kuna tias­kapi, chusku chunga puncha tuta­kuna­wan­ta­mi chisiarka. Chi puncha­kunaka iaia kuku, panda­rii­kunapi paita urma­chin­gapa muna­kurka. Chi puncha­kuna iali­ura, anjil­kuna paita ima minis­tis­ka­mi karag­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chi­ura­manda, Juan Bautista ña karsilpi wichkai tukuska ka­ura, Jesuska Gali­lea alpama rirka. Dius­manda Alli Willaita kasa nispa purii kalla­rirka: ");
INSERT INTO inb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Taita Dius niska puncha, ña­mi chaia­murka. Diuspa suma man­dai, ña­mi chaia­mun­gapa ka. Panda­rii­kunata sakispa, Taita Dius­wa tukug­samui­chi. Dius­manda Alli Willaita nuka willa­kus­kata suma uia­wai­chi. ");
INSERT INTO inb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gali­lea atun kucha pata pata puri­kuspa, Jesús, Simonta i waug­kindi Andresta kawarka. Pai­kuna, chalwa­dur­kuna kaspa, ata­raia iaku ukuma sitaspa puri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pai­kunata kawas­paka, Jesus­ka nir­ka­kunata: —Kati­wai­chi. Iacha­chisa­ki­chitami, chalwa­kunata apig­sina, runa­pura maska­puag­kuna kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Chasa uianga­lla­wa, ata­raia­kuna­ta sakispa, Jesusta katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chimanda mailla ris­kapi, San­tiago i waugkindi Juan suti­ta­mi kawarka. Pai­kuna, Zebedeopa wam­bra­kuna­mi karka. Kanuapi ata­raia­kunata alli­chi­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pai­kunata kawaspa, Jesuska kaiar­ka­kunata. Pai­kuna­pas uianga­lla­wa, taitata piun­kuna­lla­wa kanua­pi sakispa, Jesusta katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chimandaka, Kafarnaum suti pui­bluma chaiag­rir­ka­kuna. Warda pun­cha tanda­ri­diru wasima iai­kuspa, Jesús iacha­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pai iacha­chi­kus­kata uias­paka, iapa ujna­rir­ka­kuna. Moisés ima nis­ka­ta iacha­chig taita­kuna­sinalla, pai mana iacha­chi­kurka. Tukui­kuna­manda mas suma alli­lla mandag­sina­mi iacha­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chi tanda­ri­diru wasipika, sug kuku waira iai­kuska runami chaiag­rirka. Chi runaka, kapa­rispa nirka: ");
INSERT INTO inb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Nazaret pui­blu­manda Jesús, ¿imapatak nukan­chi­pagma samur­kangi? Nukan­chita puchu­kan­ga­pa­char samur­kangi. Nuka alli­lla­mi rigsiiki, kam Taita Dius­pa tukuipi mas alli wam­bra kagta. ");
INSERT INTO inb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesuska, kuku wairata piñas­pa, nirka: —Upalla ri­kui, kai runa­manda llugsispa. ");
INSERT INTO inb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chi­ura kuku waira, chi runata chugchu­chispa, sin­chi kapa­ri­chispa, llugsirka. ");
INSERT INTO inb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tukui chasa kawag­kuna, iapa mancha­rir­ka­kuna. Kikin­pura tapu­ri­na­kurka: —Chi pasa­riska, ¿imasik ni­raiá? Kai runaka, musu rimai­wa­mi atun mandag­sina suma iacha­chi­ku. Kuku waira­kunata pai rima­ura, ima nis­kata uiaspa, runa­manda anchu­rin­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chi­wanka, mana unailla Gali­lea alpa suiu Jesus­manda iacha­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chi tanda­ri­diru wasi­manda llugsispa, Jesús, Santiago i Juan­wan­ta Simón i Andrespa wasipi iai­kug­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Chipika Simon­pa suigra, rupai­wa­mi ungug siri­kurka. Pai­mandaka Jesusta willar­ka­kuna: —Ungugmi siri­ku. ");
INSERT INTO inb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Chasa uiaspa Jesuska, pai­pagma kai­lla­iaspa, makita apispa, atari­chirka. Atarig­lla­pi, rupai anchu­rirka. Chi­ura chi warmi, ata­rispa, mikui ianuspa, karai kalla­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chi tuta, indi ña chingaska ka­ura, ungug­kuna i kuku waira­wa kas­ka­kunata, tukui­kuna­ta­mi Jesus­pagma chaia­chig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chi pui­blu­manda tukui runa­kuna, wasi punguma tanda­rig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chi­ura Jesuska, mai­tuku ungug­kuna kas­ka­kuna­ta­pas­mi ambir­ka. Chasa­lla­ta, achka kuku waira­kuna­ta­mi llugsi­chirka. Chi kuku waira­kuna iachar­ka­kuna pi Jesús kagta. Chi­manda­mi chi kuku­kuna­ta mana saki­kurka, chasa willan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaiandi iapa tutata, Jesuska ata­rirka. Chi pui­blu­mandaka rirka mana mai­kan runa­kunapas kaug­sa­na­kuska alpama. Chipika, Taita Dius­wa rima­na­kui kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón i pai­wa kag­kunaka, Jesusta maskag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Paita tarig­ris­paka, nir­ka­kuna: —Kamta, tukui­kuna­mi maska­nakú. ");
INSERT INTO inb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesuska ainir­ka­kunata: —Kai suiu pui­blu­kunama ri­sun­chi, Alli Willaita willan­gapa. Chasa­manda­mi nuka llugsi­muspa puri­kuni. ");
INSERT INTO inb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pai imasa nis­ka­sina, Gali­lea alpa­pi tukui tanda­ri­diru wasi­kuna­pi iai­kuspa, Alli Willaita willas­pa, kuku waira­kunata llugsi­chis­pa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sug runa, aicha ismui ungui iukas­pa, Jesus­pagma chaiag­rirka. Chi runaka, kungu­rispa, nirka: —Kam munas­paka, pudingimi nuka­ta ambi­wanga. ");
INSERT INTO inb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Chi­ura Jesuska, iapa llaki­ris­pa, ungugta maki churaspa, nirka: —Ari, muna­nimi. Ambi­riska tukui. ");
INSERT INTO inb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chasa nig­lla­pi, chi ungui alli­lla ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chi­ura Jesuska, chi runata kacha­kuspa, sin­chi rimas­pa, nirka: ");
INSERT INTO inb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Uiamui. Mana pi­ta­pas willa­kungi. Sasir­dutita kawa­chi­rig­rii. Moisés kama­ri­ku karan­gapa ni­raias­ka­sina karag­rii. Chasaka, tukui­kuna­mi kawan­ga­kuna, kam alli­lla ambi­riska kagta. ");
INSERT INTO inb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Chi runaka, mana uias­pa­lla, mai­pi ris­kapi tukui­kunata imasa pasa­riska willaspa aparka. Chasa kag­manda, Jesuska ñi mai­kan pui­blu­mapas mana pudi­kurka iai­kuspa kawa­rig­rin­gapa. Chi­wanka, mai­kan runapas mana kaug­sa­na­kus­ka­pi­mi puri­kurka. Chasa kagpi­pas, tukui­nig­manda­mi pai­pagma chaia­na­kug­rirka. ");
INSERT INTO inb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sug puncha­kuna iali­ura, Jesus­ka Kafarnaum pui­bluma ikuti iai­kug­rirka. Pai wasipi kagta iacha­ri­ura, ");
INSERT INTO inb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","achka runa­kuna chi uku­pi kancha­wan­ta jundag­rir­ka­kuna. Chi­ura Jesús, Diuspa Rimaita willai kalla­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chasa iacha­chi­ku­ura, chusku runa­kunaka, mana kuiu­rin­gapa ungui­wa kas­kata wanduspa, chi wasi­ma apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Iapa achka runa­kuna ukupi junda kag­manda, mana pudir­ka­kuna Jesús kaska­ma iaiku­chin­gapa. Chi­mandaka, wasi awama sika­chir­ka­kuna. Jesuspa awa ladu wasita utku­chispa, chi runa cha­ka­na­pi siri­kus­kata Jesuspa ñawi ladu urai­ku­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chi­ura Jesuska, “Ambi­puangami” iuia­nakus­ka­ta kawas­paka, mana kuiu­rin­gapa ungui­wa kas­kata nirka: —Wam­bra, kam panda­rii­kunata ña­mi pasin­siaska kangi. ");
INSERT INTO inb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisés ima nis­kata iacha­chig taita­kuna­pas­mi chi ukupi tia­na­kurka. Jesús chasa nis­kata uiaspa, chi runa­kunaka sungu­lla­pi iuia­na­kurka: ");
INSERT INTO inb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kai runa, ¿ima­pa­tak Dius­sina tukuspa, chasa rima­ku? Ñi pipas mana pudin­kunachu, panda­rii­kunata pasin­sian­gapa. Taita Dius­lla­mi pasin­sian­gapa pudí”. ");
INSERT INTO inb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesuska, chasa iuia­na­kus­kata iachaspa, nir­ka­kunata: —¿Imapatak chasa sungu­lla­pi iuia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Mai­kantak mas alli ka: kai runata nin­gapa: “Kam panda­rii­kunata ña­mi pasin­siaska kan­gi”? Mana kag­pika, ¿nin­gapa: “Ata­rii; chakanata marka­rispa, kam­ba wasima riilla; ña ambi­ris­ka­mi kangi”? ");
INSERT INTO inb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kuna­ura kawa­chi­sa­ki­chita: kai Runa Tukuska, kai alpapi pudinmi, panda­rii­kunata pasin­sian­gapa. Chasa nispa, mana kuiu­rin­gapa ungui­wa kas­kataka nirka: ");
INSERT INTO inb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nukami niiki: atarii. Cha­ka­na­ta marka­rispa, kamba wasi­ma rii. ");
INSERT INTO inb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Chasa nig­lla­pi, chi runa ata­rirka. Chakana siri­kus­kata marka­rispa, tukui chipi kag­kuna kawa­nakug­lla­pi, llugsispa rirka. Chasa kawas­paka, iapa ujna­rispa tukug­samur­ka­kuna. Taita Diusta iapa suma atun­ia­chir­ka­kuna, kasa nispa: —Kuna­ura­sina suma ruras­kata ñi ima­ura­pas mana kawaska kan­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chi­ura­manda Jesuska, ikuti kucha pata laduma rirka. Chi­ura iapa achka runa­kuna, pai­pagma chaiag­rir­ka­kuna. Chipika, pai­kuna­ta iacha­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ña puchu­kaska­ura­manda, mana judíu kas­ka­kuna­manda kulki chaski­kus­kapi iali­kurka. Chipika, Alfeo­pa wam­bra Leví sutimi tia­kurka. Chi runata kawas­paka, Jesuska nirka: —Kati­wai. Chi­ura chi runa, ata­rispa, Jesus­ta katii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nis­paka, Jesus­wa sug­lla­pi kati­raiag­kuna­wan­ta Levipa wasima iai­kug­rispa, mikun­gapa tia­rig­rir­ka­kuna. Pai­pura kulki chaskig­kuna i mana alli­lla rurag­kuna­pas, achka­kuna­mi pai­kuna­wa tia­na­kurka. Iapa achka­kuna­mi Jesusta kati­raiar­ka­kuna, pai iacha­chi­kus­kata uian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesús chi runa­kuna­wa miku­nakus­kata kawas­paka, Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kuna paipa kati­raiag­kunata tapur­ka­kuna: —Kamkunata iachachig, ¿ima­pa­tak mana judíu kas­ka­kuna­manda kulki chaskig i mana alli­lla rurag­kuna­wa sug­lla­pi miku­ku? ");
INSERT INTO inb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chasa uias­paka, Jesuska nir­ka­kunata: —Mana ungui­wa kag­kuna mana minis­tin­kunachu, ambigta maskan­ga­pa. Ungug­kuna­mi ambigta mas­kan­kuna. Chasa­lla­ta, nukaka mana samurka­nichu, alli­lla rurag­kunata kaian­gapa. Mana alli­lla rurag­kuna­ta maskanga­pa­mi samurka­ni; chasaka, Taita Dius­wa alli­lla tukun­gapa­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan Bautista­wa i fari­seo­kuna­wa purig­kuna iukar­ka­kuna, sug puncha­kuna mana mikus­pa­lla chisianga. Chi­manda sug runa­kuna, Jesusta tapug­rir­ka­kuna: —Kamta kati­raiag­kuna, ¿ima­wan­tak ima­ura­pas mikus­pa­lla kan­kuna? Ikuti Juanwa i fari­seo­kuna­wa purig­kunaka, achka puncha­kuna mana mikus­pa­lla­mi chisian­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Chi­ura, Jesuska ainir­ka­kunata: —Kasaraipi, kusa tukunga kun­bi­das­ka­kuna­wa kan­kama, ¿mana mikus­pa­lla­chu kan­ga­kuna? Mani­ma. Ima­ura kusa tukunga pai­kuna­wa kan­kama, iukan­kunami sumag­lla mikuspa kan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ima­ura chaia­chu, kusa anchu­chii tukun­gapa: chi­ura­mi pai­kunata chaianga, mana mikus­pa­lla kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Ñi pipas, ruku katangapi musu linsu­wa mana siran­gi­chi­chu. Chasa sirag­pika, tagsa­ura, chi linsu, uchulla­iaspa, ruku katanga­ta­mi lliki­chinga. ");
INSERT INTO inb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chasa­lla­ta ñi pipas, musu binu, ruku kara taligapi mana tallin­gi­chi­chu. Chasa tallig­pika, musu binu timbu­ura, taligata tugia­chis­pa­mi icha­ringa. Kara taliga­pas mana balinchu. Chi­manda­mi musu binu, musu taligapi tallin­gapa chaiá. ");
INSERT INTO inb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sug warda puncha, Jesús kati­raiag­kuna­wan­ta chagra tarpu­ra­ias­ka­kunapi iali­na­kurka. Kati­ra­iag­kunaka, trigu ispiga­kunata pitii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Chasa kawas­paka, sug fari­seo­kuna Jesus­ta tapur­ka­kuna: —Kawamui. Kamta kati­raiag­kuna, ¿imapatak warda puncha panda­ri­nakú? ");
INSERT INTO inb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesuska ainir­ka­kunata: —¿Mana­chu ima­ura­pas ñugpa­manda librupi willa­raias­kata kawar­kan­gi­chi, taita David i pai­wa kag­kuna­pas, iarkai­manda i minis­tiska kaspa, imasa ruragta­kuna? ");
INSERT INTO inb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pai kikin, Diuspa wasi uku­ma iai­kuspa, Abiatar suti iaia sasir­duti ka­ura, altarpi churaska tanda­kuna tias­kata mikurka, mana ima­pas mancha­ris­pa­lla. Chi tanda­kuna, sasir­duti­kunalla miku­diru­mi karka. Chi tanda­kuna­lla­tata pai­wa kag­kuna­ta­pas kararka, mikun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kasapasmi Jesús nir­ka­kunata: —Runa­kuna­manda­mi Taita Dius nirka, warda puncha­kuna saman­gapa tiachu. Mana runa­kuna­ta rurarkachu, warda puncha­kuna samanga­pag­lla. ");
INSERT INTO inb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chi­manda kai Runa Tukuska pudinmi ninga, warda puncha­kuna­ta­pas imasa chaias­ka­sina ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Chi puncha­lla­tata, tanda­ri­diru wasipi ikuti Jesús iaikug­rirka. Chipika, sug maki chaki­riska ungui­wa kag runa, pai­kuna­wa sug­lla­pi karka. ");
INSERT INTO inb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesusta chapa­na­kurka, warda puncha chi ungugta ambi­chu; ambig­pika, pai­manda jus­ti­sia­kuna­pagma willag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus­ka, chi runa maki chaki­riska kas­ka­ta nirka: —Atarii. Runa­kunapa chaugpipi saia­rig­samui—. ");
INSERT INTO inb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chasa nispa, chipi kag­kunataka tapurka— Warda puncha, ¿imatak mas alli ka: alli­lla u mana alli­lla ruran­gapa; runata kispi­chin­ga­pa, ubi wañu­chin­gapa? Chi­ura, upa­lla­mi tia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus­ka, rabia­wa kawar­ka­kunata. Pai­kunapa iuiai iana tutapi­sina kag­manda­mi llaki­rirka. Nis­paka, chi ungug runata nirka: —Maki chuta­chii. Chasa chutachigllapi, chi maki­ka aliarka. ");
INSERT INTO inb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Chasa kawaspa fari­seo­kunaka, llugsispa, mandag Herodes­wa purig­kuna­wa tanda­rig­rispa, Jesus­manda rima­na­kui kalla­rir­ka­kuna, imasa­pi­pas paita wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús kati­raiag­kuna­wan­ta kucha patama rir­ka­kuna. Gali­lea alpa­nig­manda achka runa­kuna­mi paita kati­chi­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pai tukuipi iapa suma ruras­ka­kunata iachaspa, Judea alpa­nig­manda, Jeru­salén pui­blu­nig­manda, Idumea suti alpa­nig­manda, Jor­dán iaku sug ladu chimba­nig­manda, Tiro i Sidón pui­blu kuchu­kuna­manda, tukui­nig­manda­pas­mi iapa achka runa­kuna pai kaska­ma chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Iapa achka­kunata ambi­kug­manda iachaspa, tukui ungui­wa kag­kuna muna­na­kurka, paita llam­kaspa ambi­rin­gapa. Kichu­nakui­wan­ta­mi junda­na­kurka. Chi­manda Jesuska, kati­raiag­kunata nirka: —Sug kanuata alli­chiskalla suia­wan­gi­chi—. Chi achka runa­kuna paita tanga­na­kui­wanta iapa junda­na­kug­manda­mi chasa nirka. ");
INSERT INTO inb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kuku waira iaikui tukuska runa­kunapas, paita kawaspa, paipa ñugpa ladu kungu­rispa, kapa­ri­na­kurka, kasa nispa: —Diuspa wam­bra­mi kangi. ");
INSERT INTO inb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Chi­ura Jesuska, chasa kapa­ri­na­kus­kata sin­chi rimaspa nir­ka­kunata: —Nuka­manda mana willa­na­kui­chi nuka pi kagta. ");
INSERT INTO inb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chi­ura­manda Jesuska, awa luma­ma sikag­rispa, pai munas­ka­kuna­ta kaiarka. Chi­ura, pai­pagma kai­lla­iar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chi­ura, chunga iskai­kuna­ta­mi agllarka. Chi agllas­ka­kunataka nirka: —Kam­kunata agllai­ki­chitami, kam­kuna nuka­wa kan­gapa i kam­kuna­ta kachan­ga­pa, Diuspa Rimai­ta willaspa purin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chasa­lla­ta­mi pudin­gapa kan­gi­chi, kuku waira­kuna­ta­pas llugsi­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Chi chunga iskai agllas­ka­kuna, kasa­mi suti kar­ka­kuna: Simón (paita, Jesús suti­chirka Pedro); ");
INSERT INTO inb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago i paipa waugki Juan (pai­kuna, Zebedeopa wam­bra­kuna­mi karka; pai­kuna iapa kurinti kag­manda, Jesús suti­chir­ka­kunata Boanerjes; chi ni­raianmi “Triwinu wam­bra­kuna”); ");
INSERT INTO inb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés; Felipe; Bar­tolomé; Mateo; Tomás; Alfeopa wam­bra Santiago­lla­tata suti; Tadeo; sug Simón (kananeo suti runa­kuna­wa ñugpata purig); ");
INSERT INTO inb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","i Judas Iska­riote, Jesusta katuspa api­chig. ");
INSERT INTO inb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesús ikuti wasima chaiag­riska­ura­manda, iapa achka runa­kuna ikuti jundag­rir­ka­kuna. Jesus­wa kag­kunata ñi mikunga­pag­lla­pas mana saki­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesus­pa pai­pura­kunaka, chasa iachas­pa, ni­na­kurka: —Upami tukurka—. Chi­manda chaiag­rir­ka­kuna, paita pusan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moisés ima nis­kata iacha­chig taita­kuna, Jeru­salen­manda chaiag­riska kar­ka­kuna. Chi runa­kunaka nii kalla­rir­ka­kuna: —Beelzebú suti iaia kukumi iuká. Chi iaia kukupa iachai­wa­mi kuku waira­kunata llugsi­chi­ku. ");
INSERT INTO inb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Chasa ni­na­kug­manda, Jesus­ka, pai­kunata kaiaspa, iuiai apin­ga­sina suma parlarka, kasa nispa: —¿Imasatak iaia kuku, pai­pura kaspa, llugsi­chin­gapa munanga? ");
INSERT INTO inb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nin­tran­chi: sug alpapi mandag­pura piña­chi­na­kuspa maka­na­kus­pa­lla kaug­sa­na­kug­pika, chipi mandai iukanmi puchuka­ringa. ");
INSERT INTO inb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chasa­lla­ta, sug wasipi piña­na­kus­pa­lla kaug­sa­na­kug­pika, mana alli­lla kan­gapa kanchu, sumag­lla sug­lla­pi kaug­sa­na­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cha­sa­lla­ta­mi kan­tra: iaia kuku­wa kag­pura piña­chi­ri­na­kuspa kag­pika, iukan­kunami parijuma puchuka­ri­na­kunga. ");
INSERT INTO inb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Maikanpas sug wapu runa­pa wasima iai­kuspa, ima iukas­ka­ta kichun­gapa munaspa, iukan­mi ñugpa paita watanga. Mana kag­pika, mani­ma kichun­gapa pudin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Kasami nuka nii­ki­chita: runa­kuna panda­ris­kata tukui­ta­mi pasin­siai tia. Taita Dius­manda iapa jiru mana uian­ga­sina rimaska panda­ris­ka­kuna­ta­pas­mi pasin­siai tia. ");
INSERT INTO inb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ikuti mai­kan Santu Ispi­ri­tu­manda iapa jiru­kuna rimas­kataka ñi ima­ura­pas mana pasin­siai tian­gapa kanchu. Chasa jiru rimas­ka­kuna­manda­mi chi runa­kunaka dil­tudupa kulpa iukan­gapa kan­kuna—. ");
INSERT INTO inb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Jesuska, kuku waira iai­kus­ka­mi ka” ni­na­kug­manda­mi pai chasa ainir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús kaska­ma, paipa mama i waugkindi­kuna chaiag­rir­ka­kuna. Kancha­manda­lla kachar­ka­kuna, paita kaian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iapa achka runa­kuna, Jesús kas­kapi muiugta tia­na­kurka. Chi­uraka, paita nig­rir­ka­kuna: —Uiamui. Kamba mama, waug­ki­kuna i pani­kuna­mi kanchapi suia­nakú, kamta riman­gapa. ");
INSERT INTO inb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Paika ainir­ka­kunata: —¿Pi­kunatak nuka­pa mama, nuka­pa waugki­kuna ni­raian­kuna? ");
INSERT INTO inb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chasa nis­paka, muiugta pai­wa tia­na­kus­kata kawaspa, nir­ka­kunata: —Kaikunami nuka­pa mama, nuka­pa waugki­kuna kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Taita Dius imasa munas­ka­sina mai­kan­pas ruragmi nuka­pa waugki, nuka­pa pani, nuka­pa mama ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kucha pata ladu, Jesús ikuti iacha­chii kalla­rirka. Chi­ura iapa achka runa­kuna, pai­pagma chaiag­rir­ka­kuna. Chasa kawas­paka Jesus­ka, iakupi kaska kanua uku­ma iai­kuspa, tia­rirka. Tukui chipi kag­kuna, iaku pata ladu alpapi kar­ka­kuna, paita uian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chi­ura Jesuska, iuiai apin­ga­sina achka suma parlu­kuna­wa iacha­chii kalla­rirka. Iacha­chi­kus­paka, kasa­mi nir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Sumag­lla uia­wai­chi. Sug runa­si llugsirka, similla­kunata sitaspa tarpun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tarpu­ku­ura, sug similla­kunaka ñambipisi urmar­ka­kuna. Chi similla­kunataka, pisku­kunasi mikug­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","—Sug similla­kunaka, rumilla tias­kapisi urmar­ka­kuna, mailla alpa tias­kapi. Mana achka alpa tiag­manda, mana unailla wiña­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nig­pika, indi piaspa, rupa­chirka. Mana achka angu­iug kas­paka, utka­lla chaki­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","—Sug similla­kunaka, ispina sacha­kuna tias­kapisi urmar­ka­kuna. Nig­pika, ispina sacha wiñarka, similla­kunata kilpagta. Chi­wanka, ñi ima­pas mana tia­rirka. ");
INSERT INTO inb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Ikuti sug similla­kunakar, suma alpapisi urmar­ka­kuna. Chasa­ka, suma wiñaspa, alli­lla palla­rir­ka­kuna. Sug similla­manda­lla, kimsa chunga kimsa chunga palla­rirka. Sug­manda­lla, sugta chunga sugta chunga; ikuti sug­manda­lla, patsa patsasi palla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chasa parlas­paka, nir­ka­kunata: —Rinri iukag­kuna, nuka nis­ka­ta uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús iacha­chi­kus­kata uiag­kuna riska­ura­mandaka, chunga iskai pai agllas­ka­kuna sug­lla­pi kati­raiag­kuna­wa paita tapur­ka­kuna: —Chi parlu kam iachachiska, ¿ima­tak ni­raiá? ");
INSERT INTO inb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chi­ura Jesuska, kasa­mi ai­nirka: —Kam­kunata nis­ka­mi ka, Taita Dius imasa suma manda­kus­ka­sina kas­kata ñi ima­ura­pas mana iachas­ka­ta iachan­gapa. Ikuti mana kai­manda kag­kunataka iuiai apin­ga­sina parlu­kuna­lla­wa­mi rima­ni. ");
INSERT INTO inb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chasaka pai­kuna, kawa­na­kuspa­pas, mana kawag­sina­mi kan­kuna. Uia­na­kuspa­pas, mana uiag­sina­mi kan­kuna. Mana kag­pika pai­kuna, Taita Dius­wa tigramuspa, pasin­siaimi tukun­tra­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kasapasmi Jesús nir­ka­kunata: —Chi iuiai apin­ga­sina par­laska­ka, ¿kam­kuna­paschu ima ni­raias­ka­ta mana iachan­gi­chi? Chasa­ka, ¿imasatak kuna­ura­manda sug parlu­kunata ima ni­raias­kata iachan­kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Tarpug runaka, Diuspa Rimai­ta willag­sina­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","—Similla ñambipi urmagka, sug runa Diuspa Rimaita uiag­sina­mi ni­raiá. Chasa uiag­lla­pi, iaia kukuka chi rimas­kata tukuimi kichug­samú. ");
INSERT INTO inb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Chasa­lla­ta, similla rumilla tias­ka­pi urmagka sug runa Diuspa Rimaita uiag­sina­mi ni­raiá. Chi uianga­lla­waka alli iuia­chii­wa­mi chaskin­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nis­paka, imasa­mi chi mana achka angu­iug similla­kuna tukú: chasa­lla­ta sug ratu­lla­mi Taita Dius­wa iuia­rispa kan­kuna. Ima Diuspa Rimai­manda unz̈agpi­kunaka, llakiimi apig­samú. Chi­ura­manda, mana mas Taita Dius­wa iuia­rin­gapa munan­kunachu. ");
INSERT INTO inb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Similla ispina sacha­kuna tias­kapi urmagka, sug runa Diuspa Rimaita uiag­sina­mi ni­raiá. Uiaspa­pas, ");
INSERT INTO inb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kai alpapi tias­ka­kuna­lla­wa sumag­lla kaug­sanga­pa­mi iuia­rin­kuna, mas achka iukag tukun­ga­pa. Chasaka, Diuspa Rimaita tukui­mi kunga­rin­kuna. Ñi ima mana pallan­gapa tia­rin­ga­sina­mi tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Similla suma alpapi urmag­kar, sug runa Diuspa Rimaita sumag­lla uiaspa, mana kunga­ris­pa­lla kag­sina­mi ni­raiá. Chi runa­kuna­pi­mi ni­raiá, suma alpapi similla urmas­ka­manda, achka suma pallai tukun­gapa. Imasa­mi sug similla­manda­lla kimsa chunga kimsa chunga, u sugta chunga sugta chunga, u patsa patsa pallarí: chasa­lla­ta­mi pai­kuna, Taita Dius­manda alli­lla ruras­ka­kuna­wa achka palla­rig­sina tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kasapasmi Jesús nirka: —Ñi pipas, ima sindi apa­mus­kata manga ukupi u kawitu uku­ma mana churan­gapa chaian­chu. Awa kawitu­pi­mi churan­ga­pa chaiá. ");
INSERT INTO inb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chasa­lla­ta, ima paka­lla kaska­pas, ima­ura­pas­mi iacha­rí. Ima pakalla waka­chiska­pas­mi ima­ura­pas kawa­rig­samú. ");
INSERT INTO inb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kasapasmi Jesús nirka: —Nuka ima rimas­kata suma iuiai­wa uia­wan­gi­chi. Kam­kuna imasa­mi sug­kunata tupun­gi­chi: chasa­lla­ta­mi Taita Dius, kam­kunata alli­lla u mana alli­lla ruras­ka­ta iapa­wa tupun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mai­kan achka iukagta mas­mi karan­gapa ka. Ikuti mai­kan mailla iukas­ka­taka tukuimi kichun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kasapasmi Jesús nirka: —Diuspa suma mandaika, similla alpapi tarpuska wiña­kus­ka­sina­mi ni­raiá. Tarpug runa, ");
INSERT INTO inb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","tuta­kunaka puñuspa, puncha­kunaka atarispa, ima­pas rura­kun­kama, simillaka, llugsispa, wiñaspa wiñaspa, atunmi tukuspa ri. Chasa kagpi­pas, chi runa mana iachanchu, simillaka imasa wiña­kugta. ");
INSERT INTO inb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Alpa­pi similla tarpus­kaka wiñan­lla­mi, ñugpaka panga, nis­paka kiki, nis­paka chugllu. ");
INSERT INTO inb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ña pallan­gapa tuku­ura, chi runaka tanda­chinga­pag­lla­mi ri. ");
INSERT INTO inb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kasapasmi Jesús nirka: —Diuspa suma mandai, ¿ima­sa­tak rigchá? ¿Ima parlu­watak iacha­chin­trai­ki­chita? ");
INSERT INTO inb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mustasa similla­sina kag­ta­mi ni­raiá. Chi simi­llaka, chagrapi tarpu­ura, tukui­kuna­manda­pas mas uchu­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ña wiñai puchuka­uraka, tukui mikui chagrapi tias­ka­kuna­manda­pas mas atunmi tukú. Malki­kuna­pas­mi atun tukú. Chasa­kuna­pika, pisku­kuna­pas pudin­kuna, sum­bra ukupi sumag­lla wasi­chig­samun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chasa­lla­ta iuiai apin­ga­sina achka suma parlu­kuna­wa­mi Diuspa Rimaita iacha­chi­dur karka, imasa pai­kuna iachai­kun­ga­sina. ");
INSERT INTO inb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sug­kuna­taka parlu­kuna­lla­wa­mi iacha­chi­dur karka. Ikuti paita kati­raiag­kuna­lla­wa ka­ura, pai­kunataka iachar­kami willanga, chi parlu­kuna ima ni­raiagta. ");
INSERT INTO inb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chi puncha­lla­tata amsaia­ku­ura, Jesuska kati­raiag­kunata nirka: —Akushi. Kai kuchata chimba­sun­chi. ");
INSERT INTO inb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Chi­ura, runa­kuna chipi uia­na­kus­kata sakispa, Jesús ña kanua­pi tia­kus­kata chimba­chii kalla­rir­ka­kuna. Sug kanua­kunapi sug runa­kunapas, sug­lla­pi katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ña iaku chimba­na­kus­kapi, iapa sin­chi waira atarii kalla­rirka. Ulas­kuna­pas, iapa awa atarirka. Chi­wanka, kanua ukuma iaku ña iaiku­kurka. ");
INSERT INTO inb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesuska, kati ladu puñu­kurka, sawinapi uma churaspa. Chi­ura kati­raiag­kuna, paita rigcha­chir­ka­kuna, kasa nispa: —Iacha­chig taita, ¿mana­chu nukan­chi­manda llakingi, wañun­ga­pa kagpi­pas? ");
INSERT INTO inb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesuska, rigcha­rispa, ata­rirka. Nis­paka, wairata piñarka. Iaku­ta­pas piñarka, kasa nispa: —Upalla. Ianga kawai. Chasa pai ni­uraka, wairami iali­rig­samurka. Tukui alli­lla­mi kasi­lla­iag­samurka. ");
INSERT INTO inb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chi­ura, Jesus­ka nir­ka­kunata: —¿Imapatak chi­tuku mancha­rin­gi­chi? ¿Manarachu nuka­manda suma iuia­waspa rigsi­wan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Paikunaka, iapa mancha­ris­pa­mi kikin­pura tapu­ri­na­kurka: —Kai runa, ¿imasik ka? Waira i iaku­pas, paita uian­kuna. ");
INSERT INTO inb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kucha ialis­paka, sug ladu chim­ba chaiag­rir­ka­kuna Je­ra­sa suti alpama. ");
INSERT INTO inb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús ña kanua­manda alpama uraiku­uraka, wañus­ka­kuna pamba­raiaska­nig­manda sug runa kuku waira­kuna iai­kuska, paita tupag­rirka. ");
INSERT INTO inb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chi runa, wañus­ka­kuna pamba­raias­ka­pi­mi kaug­sa­kurka. Paita ñi kadina­kuna­wapas mana pudir­ka­kuna, wataspa charin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ñug­paka, achka biaji­si sin­chi kadina­kuna­wa watas­pa, alli­lla chari­dur kar­ka­kuna. Chasa kagpi­pas, lim piti pitisi watas­ka­kuna­ta­pas rura­dur karka. Chi­manda, ñi mai­kan wapu runa­pas mana pudir­ka­kuna, wataspa charin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tukui tuta i puncha­kuna, luma­kuna suiu i pan­tiun­nig­manda kapa­rispa, rumi­wa pia­rispa puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Chi runaka, karu­manda­ta Jesusta kawaspa, kalpa kai­lla­iag­rispa, paipa ñugpa ladu kungu­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sin­chi rimai­wa kapa­rispa, nirka: —Ai, kam tukui­manda mas atun Taita Diuspa wam­bra Jesús, ¿imapatak nuka kaska­ma samu­kungi? Dius­manda purdius­lla­mi mañaiki: mana nukata sungu nanagta llaki­chi­wa­kug­samui—. ");
INSERT INTO inb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesús, chi kuku wairata ña­mi niska karka: “Chi runa­manda llugsii”. Chi­manda­mi chasa nirka. ");
INSERT INTO inb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesuska, chi runata tapurka: —Kam, ¿imatak suti kangi? Chi­ura ainirka: —Nuka, achka waran­ga­kuna­mi suti kani. Iapa achka­kuna­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nis­paka, Jesusta sin­chi mañai kalla­rirka: —Mana kai­manda nukan­chita sug luarma kacha­kui. ");
INSERT INTO inb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chi ladira ladu­lla­pi, iapa achka kuchi­kuna mikuspa puri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nig­pika chi runapi kag kuku waira­kunaka, Jesusta mañar­ka­kuna, kasa nispa: —Nukan­chita kachai, chi kuchi­kunapa ukuma iaikug­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Chi­ura, Jesuska sakirka, chasa tukun­gapa. Chasaka chi kuku waira­kunaka, ña runa­manda llugsispa, kuchi­kunapa ukuma iaikug­rir­ka­kuna. Chi­wanka tukui kuchi­kuna, mai iskai waran­ga­sina, iapa saia patata kalpaspa, kucha iaku ukuma sita­rig­rir­ka­kuna. Chipi chuka­rispa, tukui puchuka­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chasa kawaspa, kuchi­kunata kawag­kunaka, miti­kuspa, pui­blu­nig­ta i ñambi­nigta suiu parlaspa purig­rir­ka­kuna. Chasa uiag­kunaka rir­ka­kuna, imasa pasa­ris­kata kawan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus­pagma chaiag­ris­paka, chi achka kuku waira­kuna­ta llugsi­chii tukuska runata kawag­rir­ka­kuna. Paika, alli­lla katanga chura­riska tia­kurka; paipa iuiai­pas, ña alli­lla. Chasa kawas­paka, iapa mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chi imasa pasa­ris­kata kawag­kunaka willar­ka­kunata, kuku waira­kunata imasa Jesús llugsi­chispa, kuchi­kuna ukuma kachagta. ");
INSERT INTO inb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chasa uias­paka, Jesus­pagma kai­lla­iaspa, nir­ka­kuna: —Nukan­chipa alpa­manda llugsi­puai. ");
INSERT INTO inb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús ña kanuama iai­kuska ka­uraka, chi kuku waira llugsi­chii tukuska runa, paita mañai kalla­rirka: —Nuka­ta­pas pusa­wai. ");
INSERT INTO inb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesuska, paita ainirka: —Manima. Kamba wasima rii. Kam­ba­kunata willag­rii, kamta imasa atun Taita Dius suma llakii­wa kawagta i alli­lla ruraspa sakigta. ");
INSERT INTO inb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chi runaka, Dekápolis suti pui­blu­kuna suiu rispa, tukuipi imasa Jesús paita alli­lla ruras­kata willaspa purig­rirka. Chi­ura tukui uiag­kuna, iapa mancha­rispa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús ña ikuti kucha ialispa, sug ladu chimba chaiag­ri­uraka, iapa achka runa­kuna pai­pagma tanda­rig­rir­ka­kuna. Jesús, chi iaku pata­lla­pi karka. ");
INSERT INTO inb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Chi­ura sug tanda­ri­diru wasi­manda taita, Jairo suti­mi pai­pagma chaiag­rirka. Chi taitaka, Jesusta kawaspa, paipa chaki ladu kungu­rispa, ");
INSERT INTO inb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","sumag­lla mañai kalla­rirka, kasa nispa: —Nuka­pa warmi wam­bra, ña­mi wañu­pua­ku. Kamba maki chura­puag­rii. Chasaka, ambi­ri­puanga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Chi­ura Jesús, chi taita­wa rii kalla­rirka. Nig­pika iapa achka runa­kuna, Jesusta tanga­na­kui­wanta kati kati ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kati­chi­na­kug­pura sug warmimi sug­lla­pi ri­kurka. Chi warmi, chunga iskai wata iawar sitai­wa ungug karka. ");
INSERT INTO inb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tukui ima iukas­kata tuku­chigpi­pas, ñi mai­kan ambig­kuna­pas mani­ma alia­chir­ka­kuna. Chasapaka, chi ambig­kuna­wa mas ungu­rispa ri­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chi war­mika, Jesus­manda uiaspa, chi achka runa­kunapa chaugpipi Jesusta kati kati kai­lla­iaspa kati­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Jesuspa katangata llam­kai­lla­wa­mi ambi­rig­samusa”; chasa iuiaspa kati­raiarka. Ña alli ka­ura, paipa katangata llamkarka. ");
INSERT INTO inb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Llam­kag­lla­pi, chi ungui ambi­rirka. Chi warmi, kikinpa kuir­pupi ungui ambi­riska iuia­chi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Chasa ambi­rig­lla­pi Jesuska, pai­pa iachai­lla­wa mai­kan ambi­ris­ka­ta iuia­chi­rispa, kati­raiag­kunata tigraspa, tapurka: —¿Pitak nuka­pa katangata llamka­warka? ");
INSERT INTO inb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pai­wa iachai­kug­kunaka nir­ka­kuna: —¿Mana­chu tukui­kuna, tanga­na­kui­wanta kamta kati­raia­nakú? Nig­pika, ¿imapatak tapu­kungi: “¿Pitak llamka­warka?”? ");
INSERT INTO inb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesuska, muiugta kawai aparka, pi llamkagta iachan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Chi­ura chi ambi­rig warmika, manchai­wa chugchuspa, ña ambi­riska kagta iuia­rispa, kai­lla­iaspa, Jesusta kungu­rispa, sutipa tukui ima pasa­ris­kata willarka. ");
INSERT INTO inb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chi­ura, Jesuska nirka: —Kam warmisita, nuka­manda suma iuia­ris­ka­manda­mi ambi­rig­samur­kangi. Rii, mana man­chas­pa­lla. Kamba ungui, tukui ambi­ris­ka­mi kangi. ");
INSERT INTO inb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús chara rima­kug­lla­pi, chi taitapa wasi­manda chaiag­rir­ka­kuna, kasa nispa: —Kamba wam­bra ña­mi wa­ñur­ka. ¿Imapatak chara kai iacha­chig taitata ima­pas maña­kun­kangi? ");
INSERT INTO inb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesuska, pai­kunata chasa uiaspa, chi taitata nirka: —Mana llaki­kui. Nuka­manda suma iuia­wai. ");
INSERT INTO inb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chasa nis­paka, tukui­kuna­ta­mi sakirka. Pedro, Santiago i waugkindi Juan­lla­ta­mi pusaspa rirka. ");
INSERT INTO inb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Chi wasima chaiag­ri­uraka, iapa killa­chi­na­kugta uia­ri­na­kurka. Sin­chi llakii­wa kapa­rispa waka­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesuska, ukuma iai­kuspa, nir­ka­kunata: —¿Imapatak wakaspa killa­chi­na­kun­gi­chi? Chi wam­bra mana wañuska kanchu. Puñui­lla­mi puñu­ku. ");
INSERT INTO inb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Uiag­kuna, paita asir­ka­kuna. Jesuska, tukui­kunata nirka: —Kanchama llugsii­chi—. Nis­paka, wam­brapa taita i mama i pai­wa sug­kuna kas­ka­kuna­lla­ta pusas­pa, wam­bra kaska­ma iaikug­rirka. ");
INSERT INTO inb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chi wam­brata maki­manda apis­pa, nirka— Talita kum—. Chi ni­raianmi: “Wam­brita, niikimi: ata­rii”. ");
INSERT INTO inb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Chasa nig­lla­pika, chi wam­bra ata­rirka. Ata­ris­paka, purii kalla­rirka. Ña chunga iskai wata­mi iukarka. Chasa kawas­paka, chipi kag­kuna iapa mancha­rispa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesuska nir­ka­kunata: —Chi wam­brata mikui karai­chi—. Kasa­pas­mi nir­ka­kunata— Chasa kawas­kata, ¡ujala­lla­pas sug­kunata willa­na­kun­gi­chi! ");
INSERT INTO inb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chi­manda llugsis­paka Jesús, kikinpa pui­bluma chaiag­rirka. Paita kati­raiag­kuna­pas katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Warda punchaka Jesús, tanda­ri­diru wasima iai­kuspa, iapa achka­kunata iacha­chii kalla­rirka. Paita uiaspa tukui­kuna, iapa ujna­rispa, kasa­mi kikin­pura tapu­ri­na­kurka: —Kai runa, ¿maipisik chi­tuku iachai­kug­rirka? ¿Ima­wasik chi­tuku suma iachai­wa tukurka? ¿Ima­wasik chi­tuku mana ima­ura­pas kawas­ka­sina rurai pudí? ");
INSERT INTO inb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Mana­chu kar­pin­tiru ka? ¿Mana­chu Mariapa wam­bra ka? ¿Mana­chu Santiago, José, Judas i Simonpa waugkindi ka? ¿Mana­chu paipa panindi­kuna­pas, kai­lla­pita nukan­chi­wa kan­kuna?—. Chasa nis­paka, Jesusta mana munar­ka­kuna, pai ima iacha­chi­kus­kata uian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mana uiag­manda­kuna, Jesus­ka kasa­mi nir­ka­kunata: —Santu Ispi­ri­tu­wa rimagtaka sug­nigta puris­kapi sumag­lla kuias­pa­mi uian­kuna. Ikuti kikinpa alpa­pi, kikinpa wasipi, kikin­pura­kuna mana munan­kunachu uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chi­manda Jesús, chi pui­blupi mana milagru­kuna rurarka. Mailla ungug­kunata maki churaspa, ambirka. ");
INSERT INTO inb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chi runa­kuna pai­manda mana suma uiag­manda, ujna­rirka. Chi­manda llugsis­paka, chi suiulla kaug­sa­na­kus­kata iacha­chispa puri­kurka. ");
INSERT INTO inb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chunga iskai pai agllas­ka­kunata kaiaspa, iskai iskai kachai kalla­rirka. Kacha­kus­paka, paipa iachaita karar­ka­kunata, kuku waira­kunata llugsi­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kasa­mi nir­ka­kunata: —Mana apa­na­kui­chi tanda, jigra, kulki ñi ima­pas ñambipa. Tawinalla makipi chari­rispa rii­chi. ");
INSERT INTO inb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Chaki­kunapi chura­ri­dirukar chura­rin­gi­chi. Katanga­pas, imasa chura­riska kaska­lla­wa rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kasapasmi nir­ka­kunata: —Mai­kan wasipi iai­kus­paka, chi wasi­lla­pi kan­gi­chi, chi pui­blu­manda sug­sinama llugsin­kama. ");
INSERT INTO inb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ikuti mai­pi kam­kunata mana chaskin­ga­pa u uian­gapa munas­ka­kuna­pag­pika, chi pui­blu­manda llugsi­kuspa, chakipi alpa lluta­raias­kata chab­sispa, pai­kunata willag­sina kawa­chin­gi­chi, mana alli rurag kagta­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Chi kachai tukus­ka­kunaka, purii kalla­rir­ka­kuna, kasa iuia­chispa: —Panda­rii­kunata sakispa, Taita Dius­wa tigramui­chi—. ");
INSERT INTO inb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Chasa­lla­ta, achka kuku waira­kunata llugsi­chispa, achka ungug­kunata asiti­wa kakuspa ambispa purir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesús iapa suma ruraspa puri­kus­ka­manda, tukui­pi­mi iacha­rig­samurka. Chasa parla­na­kus­kata uiaspa, mandag Hero­deska pai­manda nirka: —Chimi kan­gapa ka Juan Bau­tista. Wañus­paka, ikuti kaugsa­ris­ka­mi kan­gapa ka. Chi­manda­mi mana ima­ura­pas kawas­ka­sina ruraspa puri­ku. ");
INSERT INTO inb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sug­kuna, Jesus­manda ni­na­kurka: —Ñugpa­manda Santu Ispi­ri­tu­wa rimag Elias­mi kan­gapa ka. Ikuti sug­kunaka ni­na­kurka: —Ñugpata tiarka Santu Ispi­ri­tu­wa rimag­kuna; chasa­lla­ta rimag­char ka. ");
INSERT INTO inb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodeska, chasa uiaspa, ni­kurka: —Juanmi sutipa kan­gapa ka. Pai­pa umata, nuka­mi anchu­chin­ga­pa kachar­kani. Pai Juanmi ikuti kaugsa­riska kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Manara Jesus­manda iacha­rigpi, Herodeska kacharka, Juanta apispa, karsilpi churan­gapa. Ero­días suti warmipa kaug­sasi chasa rurarka. Chi warmi karkasi Feli­pepa warmi. Chi Felipe, Hero­despa waugkisi karka. Chi warmika, Herodes­wasi kasararka. ");
INSERT INTO inb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chi­mandasi Juanka, Herodesta piñaspa ni­kurka: —Kamta michanmi, kamba waug­kipa warmi­wa kaug­sa­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chasa piña­kug­manda, chi war­mi iapa rabia­wa muna­kurka, Juan­ta wañu­chi­chin­gapa. Chasa muna­kuspa­pas, manasi pudi­kurka. ");
INSERT INTO inb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kikin Herodeska, Juan­manda tukui­pi alli­lla rurag i iuiag kagta iachas­paka, paita manchaspa, imasa­pi­pas kispi­chi­kurka. Juanta uias­paka, mana iacha­ri­kurka ima ruranga. Chasa kagpi­pas, Juan rimas­kata iacharka, kuntintulla uianga. ");
INSERT INTO inb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chi warmi imasa iuia­kus­ka­sina pai­manda puncha, kasasi cha­iarka. Herodes tiag­samuska pun­cha chaia­ura, paika, kati mandag­kunata, suldadu­kunata mandag­kunata i Gali­lea alpa­manda taita­kunata kun­bi­daspa, achka suma mikui karar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tukui kun­bi­das­ka­kuna kawaspa tia­nakun­kama, chi warmipa sipas warmi wam­bra, chi ukupi iaikug­rispa, iapa sumasi bailarka. Chasa bailag­manda, mandag Herodesta i pai­wa miku­nakus­ka­ta iapasi sumarka. Chi­ura paika, sipasta nirka: —Kam ima munaska maña­wai; kara­sa­kimi—. ");
INSERT INTO inb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sipasta ikuti kasa­passi nirka— Taita Diuspa ñawi­pi­mi niiki: kam ima maña­was­ka­mi kara­saki. Nuka manda­kuska alpata chaugpi­pas­mi kara­saki. ");
INSERT INTO inb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chasa uias­paka chi sipaska, llugsispa, mamandita tapug­rirka: —¿Imatak mañasa? Chi warmika ainirka: —Juan Bautistapa umata mañai. ");
INSERT INTO inb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Chasa uias­paka, kalpalla iaikug­rispa, mandagta mañarka: —Kasami munani: kuna­ura­lla Juan Bautistapa umata platupi kara­wai. ");
INSERT INTO inb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mana pai iuia­kus­ka­sina mañag­manda, iapasi llaki­rig­samurka. Kikin, Taita Diuspa ñawipi nis­kata pai­wa kag­kuna uia­na­kug­manda, mana alli karka, sipasta: “Mana” nin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chasa­ka, chi­ura­lla sug suldaduta kacharka, kasa nispa: —Juanta kunga anchu­chispa, uma­ta apag­rii—. Chasa uianga­lla­wa, karsilma rispa, umata anchu­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chita platupi apaspa, sipas­tasi kuag­rirka. Sipas chaskis­pa, mamanditasi kuag­rirka. ");
INSERT INTO inb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan­wa purig­kuna, chasa pasa­rigta iachas­paka, kuir­puta apag­rispa, pambag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús kachaska runa­kuna, pai­pagma ikuti chaiag­ris­paka, tukui imasa ruraspa i iacha­chispa puriska willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Chipi iapa achka runa­kuna chaiaspa i llugsispa puri­na­kug­manda, mana iukar­ka­kuna, ñi imasa mikunga. Chi­manda Jesus­ka, pai agllas­ka­kunata nirka: —Akushi nukan­chilla, maipi mana runa­kuna tiaska­ma. Chipika sama­ri­sun­chimi. ");
INSERT INTO inb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chasa pai­kuna kanuapi iai­kuspa, mai­kan runapas mana kaug­sa­nakuska alpama rir­ka­kuna, pai­kuna­lla kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ri­na­kugta kawas­paka, achka runa­kuna, mai­ma rin­gapa kas­kata iachaspa, tukui ladu­lla­pi pui­blu suiu­nig­manda chaki­lla­wa kalpaspa rir­ka­kuna. Chasaka, pai­kunapa ñugpa chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús kanua­manda llugsi­ura, iapa achka runa­kuna kawa­rirka. Sitaska ubija­kuna­sina ñi pipas mana kawan­gapa tiag­sina­mi kar­ka­kuna. Pai­kunata chasa kawas­paka, Jesús iapa llaki­rig­samurka. Nis­paka, achka ima­kuna alli­lla iacha­chii kalla­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ña chisia­ku­uraka, Jesusta kati­raiag­kuna, kai­lla­iaspa, nir­ka­kuna: —Kai suiu, ñi pipas mana kaug­sa­nakunchu. Ña­mi chisi ka. ");
INSERT INTO inb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kai runa­kunata kachai kai suiulla kaug­sa­nakuska wasi­kunama, mikui randispa miku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesuska nir­ka­kunata: —Kam­kuna, pai­kunata mikui karai­chi. Pai­kunaka ainir­ka­kuna: —¿Iskai patsa puncha ganaska kulki­wa tanda randig­rispachu pai­kunata kara­sun­chi? ");
INSERT INTO inb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesuska nir­ka­kunata: —Kawag­rii­chi: ¿mai­tuku tanda­tak tia­pun­gi­chita? Kawag­ris­paka, nig­rir­ka­kuna: —Pichka tanda i iskai chalwa­lla­mi tia. ");
INSERT INTO inb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chi­ura, Jesuska nir­ka­kunata: —Tukui­kunata, achka achka, sug­lla­pi sug­lla­pi, suma ugsapi tia­ri­chii­chi. ");
INSERT INTO inb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Chasa uias­paka, patsa patsa i pichka chunga pichka chunga tia­ri­chir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nigpi Jesuska, chi pichka tandata i iskai chalwata chari­rispa, awa­sinama kawaspa, “Pai Siñur” Taita Diusta nirka. Tanda­kunata piti­chis­paka, kati­raiag­kunata kuaspa richirka, tukui­kunata karaspa apan­gapa. Iskai chalwa­ta­pas chasa­lla­ta tukui­kunata karaspa richirka. ");
INSERT INTO inb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tukuikunami sagsagta mikur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nis­paka, chunga iskai saparu junda piti piti­kuna tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Chi tanda­kuna­ta, mai pichka waranga kari­kuna­mi mikur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tanda puchus­kata tanda­chig­lla­pi, Jesuska paita kati­raiag­kunata nirka: —Kanuama iaikui­chi. Sug ladu chim­ba Betsaida pui­bluma ialii­chi. Nukaka, kai tukui runa­kunata: “Kaia­kama” nispa, kachasa­kunata—. ");
INSERT INTO inb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chi runa­kunata kachas­paka, sug lumama rirka, paipa Taita Dius­wa rima­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chi tutaka Jesús, sapalla chi lumapi karka. Kati­raiag­kunaka, kanuapi kucha chaugpipi bugaspa ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iapa sin­chi waira ñugpag­nig­manda arka­kug­manda­mi iapa sai­kuska ri­na­kurka. Chasa kawas­paka Jesuska, ña paka­ringa­ma, chi iakupi awalla chaki­wa saruspa saruspa, pai­kuna­pag­ma ña chaia­kug­rirka. Pai­kuna kaska karu­lla­pi ialin­gapa kag­sina rigcha­kurka. ");
INSERT INTO inb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pai­kunaka, chasa iaku­pi saruspa awalla ri­kugta kawaspa, iuia­na­kurka: “Sug waira­char ka”. Iapa mancha­ris­pa­mi kapa­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tukui­kuna­mi paita chasa kawar­ka­kuna. Kapa­rig­lla­pi, Jesuska nir­ka­kunata: —Sin­chi iuiai­chi. Nuka­mi kani. Mana mancha­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chasa nis­paka, pai­kuna ri­na­kuska kanuapi iaikug­rirka. Chi­ura, wairapas kasillaiag­samurka. Chasa kawas­paka, iapa ujna­rig­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús tanda­kunata achka­ia­chig­samuska ima ni­raias­ka­ta manara iuiai apiska kas­pa­mi chasa ujna­rir­ka­kuna. Pai­kuna­pa iuiaika, charami iana tuta­pi­sina kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kucha ialis­paka, sug ladu chim­ba Jenesaret suti alpama chaiag­rir­ka­kuna. Chipika, kuchupi kanuata watag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kanua­manda llugsiska kag­lla­pi, chipi kag­kunaka Jesusta rigsir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Chi suiulla pai­pura willa­na­kuspa, kalpalla rir­ka­kuna. Nis­paka, ungug­kunata chakana­kunapi apai kalla­rir­ka­kuna maipi Jesús kagta iachaska­ma. ");
INSERT INTO inb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mai­kan atun u uchulla pui­blupi, maipi runa­kuna kaug­sa­na­kus­kapi, Jesús ialin­ga­pa kaska­nigta ungug­kunata churar­ka­kuna. Jesús iali­ku­ura, ungug­kuna­pas paita maña­na­kurka: —Kamba katanga punta­lla­pas saki­wai llamkan­gapa—. Chi­wanka, tukui llamkag­kuna ambi­rig­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sug fari­seo­kuna i Moisés ima nis­kata iacha­chig taita­kuna, Jeru­salen­manda chaiag­ris­paka, Jesus­pagma kai­lla­iag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesusta sug kati­raiag­kuna, mana maki mailla­ris­pa­lla miku­nakurka. Chasa, ñugpa­manda­kuna imasa iacha­chis­ka­sina mana rura­na­kurka. Chasa kawaspa chi runa­kunaka, iapa mana alli­lla pai­kuna­manda rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Fari­seo­kuna i tukui judiu­kuna­pas, ñugpa­manda­kuna imasa iacha­chis­ka­sina maki mailla­ris­pa­mi mikun­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chasa­lla­ta, wasi­manda llugsispa, ikuti mai­nig­manda­pas chaiag­ris­paka, mana maki mailla­ris­pa­lla mana mikun­kuna­chu. Achka ñugpa­manda­kuna imasa iacha­chis­ka­sina­mi chasa­lla­ta ruran­kuna; imasa­mi wisinga, manga, iura paila­kuna i puñu­diru kawitu­kunata maillai iukan­kuna: chasa.) ");
INSERT INTO inb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chasa rura­diru kag­manda­mi chi runa­kuna, Jesusta tapur­ka­kuna: —Kamta kati­raiag­kuna, ¿ima­pa­tak ñugpa­manda­kuna imasa iacha­chis­ka­sina mana ruraspa kaug­sa­nakú? Mana maki mailla­ris­pa­lla­mi miku­nakú. ");
INSERT INTO inb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesuska ainir­ka­kunata: —¡Miski simi, sungu awalla rimag­kuna! Kam­kuna­manda­mi ñugpata rimag Isaías suti, Santu Ispi­ri­tu­wa kasa sutipa nirka: Kai alpapi kaug­sag­kuna, sungu awalla rimas­pa­mi kuia­wan­kuna. Ikuti pai­kuna sungupi iuiai­waka nuka­manda sug­pi­mi iuia­nakú. ");
INSERT INTO inb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iangami nukata kungu­ri­wag­sina ruran­kuna. Nuka nis­kata iacha­chinga­ta­ka, runa­pura imasa ruran­gapa niska­lla­ta­mi iacha­chin­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chasa nis­paka, nir­ka­kunata: —Kam­kuna­pas, Taita Dius ima ruran­gapa willa­raias­kata sakispa, ñugpa­manda­kuna iacha­chiska­lla­ta ruras­pa­mi kaug­sa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kasapasmi nir­ka­kunata: —Kam­kunapa ñugpa iacha­chiska­lla­ta ruraspa kaug­san­gapaka, Taita Dius ima ruran­gapa willa­ra­ias­ka­ta wabutin­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moi­ses­ka, kasa­mi nirka: “Kamba taitata mamandita sumag­lla kuiangi”. Kasa­pas­mi nirka: “Mai­kan­pas taitata i mamata kamig­pika, chitaka chaianmi wañu­chin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ikuti kam­kunaka, kasa­mi iacha­chin­gi­chi, mai­kanpa taitata u mamata nin­gapa: “Nuka mana pudii­ki­chi­ta­chu aidan­gapa. Tukui nuka ima iukaska, ‘Korbán’ u Taita Diusta karas­ka­mi ni­raiá”. ");
INSERT INTO inb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kam­kuna chasa nis­pa­mi iacha­chi­na­kun­gi­chi, kuna­ura­manda taitata i mamata mana kuiaspa aidan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chasa iacha­chispa, Taita Dius ima ruran­gapa willa­ra­ias­ka­taka wabutin­gi­chimi. Kam­kuna­pura ñugpa­manda iacha­chiska­lla­ta­mi ruraspa kaug­san­gapa munan­gi­chi. Achka chasa­lla­ta rigcha­kuna­ta­mi ruraspa kaug­sa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chasa nispa, tukui chipi kag­kunataka ikuti pai kaska­ma kaiaspa, nir­ka­kunata: —Tukui runa­kuna, suma iuia­rispa uia­wai­chi. ");
INSERT INTO inb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Runa­kuna ima mikus­kaka, Diuspa ñawipi ñi ima mana mapa­sina ni­raianchu. Runa­kunapa sungu­manda jiru iuiai­kuna llugsis­ka­mi mapa ni­raiá.  ");
INSERT INTO inb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chi runa­kunata sakispa, wasima chaiag­ri­uraka, Jesusta kati­raiag­kuna pai chasa iacha­chis­ka­manda tapur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chi­ura, Jesuska ainir­ka­kunata: —Kam­kuna­pas, nuka­wa kaspa, ¿manara­chu iachai­kun­gi­chi ima ni­raiagta? ¿Mana­chu iachan­gi­chi, ima mikuskapas Diuspa ñawipi mana mapa­sina ni­raiagta? ");
INSERT INTO inb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi mikui, mana sunguma iai­kunchu. Wigsa­ma­mi iaikú. Wigsa­mandaka, kancha­ma­mi llugsí—. (Chasa nis­paka, iacha­chir­kami, tukui mikui­kunaka alli kagta.) ");
INSERT INTO inb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kasapasmi nirka: —Sungu­manda jiru iuiai­kuna llugsis­ka­mi Diuspa ñawipi mapa ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sungu­manda­mi jiru iuiai­kuna llugsí, kasa panda­rin­gapa: sugpa warmi­wa u sapalla warmi­wa siri­rin­ga­pa, sisan­ga­pa, wañu­chin­ga­pa, ");
INSERT INTO inb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sug­kunapata kichun­gapa muna­rin­ga­pa, jiru mana alli­lla rurai­kuna ruran­ga­pa, llulla­chin­ga­pa, tukui mana alli­lla ruraspa kaug­san­ga­pa, sug­kunata jiru iuiai­wa kawan­ga­pa, Taita Diusta kamin­ga­pa, iapa atun iuiai­kuna­wa tukun­ga­pa, Taita Dius iuia­chis­ka­kunata mana uias­pa­lla upa­sina purin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tukui chasa panda­rin­ga­paka, sungu­manda­mi jiru iuiai­kuna llugsí. Chasa panda­rii­kuna­mi Diuspa ñawipi mapa ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chi­manda llugsispa, Jesuska Tiro suti pui­blu suiu rirka. Chipi chaiag­ris­paka, sug wasipi iaikug­rirka. Kikinka muna­kurka, pipas mana iachachu chaiag­rigta. Chasa muna­kug­pi­pas, mana pudirka paka­lla kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pai­manda iacha­rig­lla­pi, sug warmi, pai­pagma rispa, kungu­rig­rirka. Chi warmipa warmi wam­bra, kuku waira iai­kuska karka. ");
INSERT INTO inb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Chi warmi mana karka Israel­manda. Sirofenisia suti alpa­manda karka. Kungu­rispa, Jesusta mañarka: —Nuka­pa wam­bra­manda kuku wairata llugsi­chi­puai. ");
INSERT INTO inb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesuska nirka: —Ñugpa, wasi­manda wam­bra­kuna miku­chu­kuna sagsagta. Mana chaianchu, wam­bra­kunapa tandata kichuspa, alku­kunata sita­pun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Chi­ura, chi warmika ainirka: —Ari, taita turi. Wam­bra­kuna miku­nakus­kapi, misa ukuma piti urmas­ka­kunata, alku­kuna­pas­mi mikun­kuna. ");
INSERT INTO inb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Chasa uiaspa, Jesuska paita nirka: —Allillami aini­war­kangi. Kuku waira, ña­mi kamba wam­bra­manda llugsirka. Kuna­ura riilla kam­bag­ma. ");
INSERT INTO inb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Chi warmi pai­pagma chaiag­ri­uraka, paipa wam­braka alli­lla siri­kus­ka­ta­mi tarig­rirka, kuku waira ña llugsiska. ");
INSERT INTO inb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro pui­blu­nig­manda llug­sis­paka, Sidón suti pui­bluta Deká­polis pui­blu­kuna­nig­ta­pas ialispa, Gali­lea kuchama ikuti chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chipi kag­kunaka, sug runa mana uiai i mana alli­lla rimai pudigta Jesus­pagma pusar­ka­kuna, kasa nispa: —Kai runata maki chura­puai, ambi­riska kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Chi­ura Jesuska, runa­kunapa sug­lla­pi kas­kata sapa­lla­ta karuajma pusarka. Nis­paka, paipa iskandi rinri utkupi paipa didu churarka. Chasa­lla­ta, makipi tuka churaspa, paipa kallupi iali­chirka. ");
INSERT INTO inb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nis­paka, awa­sinama kawaspa, sin­chi samai kachaspa, nirka: —Efata—. (Chi ni­raianmi: “Paska­richu”.) ");
INSERT INTO inb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Chasa nig­lla­pi, chi runapa rinri­kuna alli­lla uiarka. Kallupas, alli­lla rimai kacha­ri­rirka. ");
INSERT INTO inb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Chipi kag­kunata, Jesuska nirka: —Kam­kuna kawas­kata mana ñi pi­ta­pas willa­na­kun­gi­chi. Mai­tuku “Mana willa­na­kun­gi­chi” nigpi­pas, kawag­kuna, mana uias­pa­lla, iapa ujna­rispa, tukui­pi­mi parlai apa­na­kurka, ");
INSERT INTO inb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","kasa nispa: —Tukuipimi iapa suma alli­lla, Jesús rurá. Mana rinri uia­na­kug­ta­pas­mi uian­gapa ambí. Mana rimai pudis­ka­kuna­ta­pas­mi riman­gapa ambí. ");
INSERT INTO inb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chi puncha­kuna, iapa achka runa tanda­ris­ka­kuna kas­paka, ikuti mana iukar­ka­kuna ima mikun­gapa. Nigpi Jesuska, kati­ra­iag­kunata kaiaspa, nir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kai tukui runa­kuna, ña kimsa punchami nuka­wa kaipi kan­kuna. Pai­kuna ñi ima mana mikun­gapa iukag­manda, nukata iapa­mi llaki­ri­wag­samú. ");
INSERT INTO inb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sug­kuna, karu­manda­mi kan­kuna. Pai­kunata mana mikui karas­pa­lla kikin­kuna­pag­ma nuka kachag­pika, ñambi ri­na­kuska­lla­pi­mi diiarkai samba­iaspa urmag­rin­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kati­raiag­kuna ainir­ka­kuna: —Kai mai­kan runapas mana kaug­sa­nakus­kapi, pai­kunata, ¿ima­watak iarkai anchu­chi­sun­chi? ");
INSERT INTO inb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesuska tapur­ka­kunata: —¿Maituku tandatak tia­pun­gi­chita? Chi­ura ainir­ka­kuna: —Kan­chis tandallami tia. ");
INSERT INTO inb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Chasa uiaspa, Jesuska chipi kag­kunata nirka: —Alpapi tia­rii­chi—. Nis­paka, chi kan­chis tandata chari­rispa, “Pai Siñur” Taita Diusta nirka. Chi­ura­lla piti­chispa, kati­raiag­kunata kuaspa richirka. Pai­kunaka, tukui­kunata karaspa apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sug uchulla chalwa­kuna­pas­mi tia­pur­ka­kunata. Chi­kuna­ta­pas chasa­lla­ta makipi chari­rispa, “Pai Siñur” Taita Diusta nirka. Nis­paka, kati­raiag­kunata nirka: —Tukui­kunata karai­chi. ");
INSERT INTO inb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tukuikunami sagsagta mikur­ka­kuna. Nis­paka, kan­chis saparu junda piti piti­kuna tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mai chusku waranga runa­kuna­mi mikur­ka­kuna. Chi­ura­manda Jesús, chi runa­kuna­ta: “Kaia­kama” nispa, kachar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kachanga­lla­wa, kati­raiag­kuna­wa kanuapi iai­kur­ka­kuna. Chi­mandaka, Dalmanuta suti alpama rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chi alpama chaiag­ri­uraka, fari­seo­kuna, kai­lla­iag­rispa, Jesus­wa kalla­rir­ka­kuna sin­chi rima­na­kun­gapa. Paita maña­na­kurka, mana ima­ura­pas kawas­ka­sina awa luar­manda kawa­chin­gapa; chasaka, pai­manda iachan­ga­pa, sutipa Taita Dius kacha­muska kagta. ");
INSERT INTO inb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesuska, llaki­rispa, sin­chi samai kachaspa, nir­ka­kunata: —¿Imapatak kai puncha­kuna­manda runa­kuna maña­wa­na­kun­gi­chi: “Mana kawas­ka­sina kawa­chi­wai”? Kasa­mi nuka nii­ki­chita: ñi ima­pas mana kam­kuna munas­ka­sina kawan­gapa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chasa nis­paka, pai­kunata sakispa, ikuti kanuapi kati­raiag­kuna­wan­ta iai­kuspa, llugsir­ka­kuna, kucha sug ladu chimba ialin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kati­raiag­kuna kunga­riska kar­ka­kuna, tanda apan­gapa. Kanua ukupi, sug tanda­lla­mi tia­pur­ka­kuna­ta. ");
INSERT INTO inb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ña kuchapi ri­na­ku­ura, Jesus­ka nir­ka­kunata: —Suma iuia­rispa uia­wai­chi. Fari­seo­kunapa i Herodespa liba­du­ra­sina iuiaita, ¡ujala­lla­pas iuia­na­kun­gi­chi! ");
INSERT INTO inb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chasa uias­paka, kikin­pura rima­ri­na­kurka, iuiaspa: “Tanda mana apa­mus­ka­manda­mi chasa nukan­chita ni­ku”. ");
INSERT INTO inb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chi rimari­na­kus­kata uiaspa, Jesuska nir­ka­kunata: —¿Imapatak ni­na­kun­gi­chi: “Tanda mana apa­mus­ka­manda­mi chasa nukan­chita ni­ku”? ¿Ima­wan­tak, uia­waspa­pas, kam­kunapa uma­pika manara iaikú? Kam­kuna­pa iuiaika, ¿charachu amsapi­sina kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ñawi iukaspa­pas, ¿chara­chu mana kawag­sina kan­gi­chi? Chasa­lla­ta, rinri iukaspa­pas, ¿chara­chu mana uiag­sina kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Mana­chu iuia­rin­gi­chi, nuka pichka tandata piti­chi­uraka, pichka waranga runa­kuna mikugta­kuna? Chi puchus­ka­kunataka, ¿mai­tuku saparu jundatak tanda­chir­kan­gi­chi? Paikunaka ainir­ka­kuna: —Chunga iskai saparu. ");
INSERT INTO inb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesuska tapurka: —Chasa­llata, nuka kan­chis tanda­ta piti­chi­uraka, chusku waranga runa­kuna mikur­ka­kuna; chi puchus­ka­kunataka, ¿mai­tuku saparu jundatak tanda­chir­kan­gi­chi? Ainir­ka­kuna: —Kan­chis saparu. ");
INSERT INTO inb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chasa aini­ura, Jesuska nir­ka­kunata: —Chasa kagpi­pas, ¿manarachu kam­kunapa iuiaipi iaikú? ");
INSERT INTO inb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chi­ura­mandaka, Betsaida pui­bluma ikuti chaiag­rir­ka­kuna. Chi­pika, sug runa mana ñawi kawagta Jesus­pagma pusaspa, mañar­ka­kuna, kasa nispa: —Kamba maki­wa kai runata llam­ka­puai, ambi­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Chi­ura Jesuska, chi mana ñawi kawagta maki­manda apispa, chi pui­blu­manda sug­sinama pusarka. Chaia­chig­ris­paka, paipa tuka makipi churaspa, ñawipi llam­karka. Nis­paka, paita maki churaspa, tapurka: —¿Ñachu ima­pas kawangi? ");
INSERT INTO inb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chi­ura ainirka: —Runa­kunaka, sacha­kuna­sina puri­na­kug­ta­mi kawa­kuni. ");
INSERT INTO inb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ikuti Jesús, ñawipi maki churarka. Chasa chura­ura, mas alli­lla tukug­samurka. Chasaka, tukui alli­lla ñawi­wa kawai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Chi­ura Jesuska, wasima paita kacharka, kasa nispa: —¡Ujala­lla­pas pui­blupi kuti­kungi! ");
INSERT INTO inb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chi­mandaka, Filipopa Sesarea suti suiu paita kati­raiag­kuna­wan­ta puri­na­kurka. Ñambi ri­na­kus­ka­pika, Jesús tapur­ka­kunata: —Mai­kan­kuna nuka­manda, ¿pitak kagta nin­kuna? ");
INSERT INTO inb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pai­kunaka ainir­ka­kuna: —Sug­kuna ninkunami: kam kangi­si Juan Bautista. Sug­kunaka: kam ñugpa­manda rimag Elías; ikuti sug­kunaka, mai­kan ñugpa­manda Santu Ispi­ri­tu­wa rimagsi kangi. ");
INSERT INTO inb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Chi­ura, Jesús tapur­ka­kunata: —Kam­kunaka nuka­manda, ¿pi kagtatak ni­wan­gi­chi? Chasa tapu­ura, Pedroka ainirka: —Taita Dius agllaska Cristo­mi kangi. ");
INSERT INTO inb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pedro chasa ni­ura, Jesuska pai­kunata nirka: —Mana pi­ta­pas nuka­manda chasa willa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nis­paka iacha­chii kalla­rir­ka­kunata, kasa nispa: —Kai Runa Tukus­kataka iapa llakii i nanai iukanga­pa­mi chaia­wa­ku. Iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas wabuti­wanga­pa­mi kan­kuna. Nukata wañu­chi­wanga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa puncha­pika ikutimi kaugsa­rin­gapa kani—. ");
INSERT INTO inb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chasa ni­kurka, kati­raiag­kuna alli­lla iachan­gapa. Chasa uiaspa Pedroka, Jesús sapa­lla­ta mana uia­na­kuska­ma pusaspa, piñai­mi kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Chi­ura Jesuska, tigra­rispa, kati­raiag­kunata kawaspa, Pedrotaka piñarka, kasa nispa: —Nuka­pa ladu­manda, iaia kuku, anchu­rii. Kam mana iuia­kungi­chu Taita Dius imasa iuia­kus­ka­sina. Runa­kunapa iuiai­lla­wa­mi chasa iuia­kungi. ");
INSERT INTO inb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Chasa nis­paka, achka runa­kunata paita kati­raiag­kuna­wan­ta kaiaspa, nir­ka­kunata: —Mai­kan nukata kati­raia­wan­ga­pa munagka, kikin­manda kunga­richu. Paipa krusta marka­rig­sina ruras­pa­mi iuká kati­raia­wanga. ");
INSERT INTO inb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mai­kan kikinpa kaug­saita kispi­chinga­pag­lla iuia­kug­pika, kikinmi puchu­ka­rin­gapa ka. Ikuti mai­kan­pas nuka­manda i Alli Willai­manda wañu­chii tukug­pika, mana mas wañui kaug­sai­ta­mi tarin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—Sug runa tukui kai alpapi ima munaska iukagpi­pas, paipa alma­ta mana kispi­chig­pika, chi iukas­ka­kuna ñi imapa mana bali­pun­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chi runaka, pai­pa almata chinga­chis­paka, ¿ima­wa­tak pudin­gapa ka, ikuti tarin­ga­pa? Ñi ima­wa­pas mani­ma. ");
INSERT INTO inb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Taita Diusta ñi imapa mana iuia­rispa, mana alli­lla ruraspa puri­na­kug runa­kuna­wa­mi kam­kuna kaug­sa­nakun­gi­chi. Chi runa­kunapa ñawi­pi mai­kan­pas nuka­manda i nuka­pa rimai­kuna­manda unz̈aspa, “Mana rigsi­nichu” nig­kunata, nuka­pas­mi chasa­lla­ta rurasa. Kai Runa Tukuska samu­ura, nuka­pa Taita suma atun­ia­chis­ka­wa­mi tukuipi alli anjil­kuna­wa samun­gapa ka. Chi­ura samus­pa­mi, mai­kan nuka­manda wabutispa, “Mana rigsi­nichu” nig­kunata, chasa­lla­ta nuka­pas nin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kasapasmi nir­ka­kunata: —Kasami nuka nii­ki­chita: mai­kan kaipi kag­kuna manara wañug­kuna, tukui imasa Diuspa suma mandai chaia­mug­ta­mi kawan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chi­ura­manda sugta puncha­pika, Pedrota, Santiagota i Juan­ta pusaspa, sug awa lumama pai­kuna­lla­wa sikag­rirka. Chipi chaiag­ris­paka, pai­kuna kawa­na­kug­lla­pi, sug rigcha kawa­rimi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paipa katanga, iapa iura puncha­lla­mi tukurka, kai alpapi ñi mai­kan katanga tagsag mana chasa iura­ia­chii pudin­ga­sina. ");
INSERT INTO inb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kawa­na­kug­lla­pi, Elías i Moisés kawa­rig­samur­ka­kuna. Chi runa­kuna­ka, Jesus­wa rima­na­kui kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Chasa kawas­paka, Pedro­ka Jesusta kasa­mi nirka: —Iacha­chig taita, kaipi iapa alli iuia­chi­mi kan­chi. Kimsa tambu kai­pi rura­sun­chi: kam­manda sug, Moises­manda sug, sugka Elias­manda—. ");
INSERT INTO inb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tukui kimsandi­kuna iapa manchai­wa kas­pa­mi mana ima­pas iuia­ris­pa­lla Pedro chasa nirka. ");
INSERT INTO inb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chi­ura puiulla, pai­kunata kilpag­samurka. Chi puiu uku­manda sug rimagta uia­rig­samurka, kasa nispa: —Kai, nuka­pa kuiaska wam­bra­mi ka­puá. Paita uia­puan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pai­kuna ikuti muiugta kawa­ura, Jesuska ikuti sapalla kawa­rig­samur­ka­kunata; sug­kunaka mani­ma. ");
INSERT INTO inb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chi luma­manda urai­ku­naku­ura­ka, Jesuska nir­ka­kunata: —Kam­kuna ima kawas­kata mana pi­ta­pas willa­na­kun­gi­chi. Kai Runa Tukuska wañuspa kaugsa­riska­ura­manda­mi chasa kawas­ka­ta willankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chasa pai­kuna uias­paka, ñi pi­ta mana willar­ka­kuna. Chi kimsan­di­kunaka tapu­ri­na­kurka: —Chi “wañuspa, ikuti kaugsa­riska”, ¿imatak ni­raiá?—. ");
INSERT INTO inb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nis­paka, Jesustaka tapur­ka­kuna— ¿Imapatak Moisés ima nis­kata iacha­chig taita­kuna nin­kuna: “Elias­ta­mi chaia­ku, Taita Dius agllaska Cristopa ñugpa samun­gapa”? ");
INSERT INTO inb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chi­ura, Jesuska ainir­ka­kunata: —Sutipami Elías ñugpa samun­ga­pa ka. Tukuimi alli­chig­samun­ga­pa ka. Chasa samun­gapa willa­ra­ias­kaka, alli­lla­mi ka. Kasa­pas­mi ñugpa­manda librupi willa­raiá: Runa Tukuska, achka llakii i nanai iukaspa, wabutiimi tukun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nukaka, kasa­mi nii­ki­chita: Elías ña­mi samurka. Paitaka imasa munas­ka­sina­mi mana alli­lla rurar­ka­kuna, imasa pai­manda willa­raias­ka­sina. ");
INSERT INTO inb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús chi kimsandi­kuna­wa paita kati­raiag­kuna­pagma chaiag­ri­ura, iapa achka runa­kuna pai­kuna­pa muiugta saia­na­kug­ta­mi kawag­rir­ka­kuna. Paita kati­raiag­kuna­wa Moisés ima nis­kata iacha­chig taita­kuna­wa sin­chi rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tukui chipi kag­kunaka, Jesusta kawaspa, iapa ujna­rir­ka­kuna. Nis­paka, pai­pagma kalpalla rir­ka­kuna, “Puangi” nin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chi­ura, Jesuska tapur­ka­kunata: —¿Imatak chi­kuna­wa sin­chi rima­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Chi runa­kuna­pura­manda sug runaka, Jesusta ainirka: —Iacha­chig taita, nuka­pa wam­bra­ta­mi kam­bagma pusa­mur­kani. Paita, sug kuku waira­mi iaiku­puarka. Chi­manda­mi mana riman­gapa pudi­puá. ");
INSERT INTO inb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chi kuku waira, paipa kag­sina, ima­ura­pas apispa, alpa­pi­mi urma­chi­puá. Chi­ura, tuka sitaspa, kiru mukuspa, kani­ris­pa­mi kallarí. Nis­paka, wañus­ka­sina­mi tukug­samú. Chi­manda­mi kamta kati­raiag­kunata mañag­samur­kani: “Chi kuku wairata llugsi­chi­puai­chi”. Nig­pika, pai­kuna mani­ma llugsi­chi­puan­gapa pudir­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesuska, pai­kunata nirka: —¡Ai, kam runa­kuna, Taita Dius­wa ñi ima mana iuiag­kuna­mi kan­gi­chi! ¿Ima­ura­kamatak kam­kuna­ta chasa chari­na­kusa­ki­chi­ta?—. Chasa nis­paka— Chi ungug­ta, kaima pusa­mui­chi— nirka. ");
INSERT INTO inb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Chi­ura, wam­brata Jesus­pag­ma pusar­ka­kuna. Kuku waira­ka, Jesusta kawanga­lla­wa­mi wam­bra­ta iapa chabsi­chig­samurka. Chi­wanka, alpapi urmaspa, tukui­ma builtia­ri­kurka, tuka sitaspa. ");
INSERT INTO inb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Chi­ura Jesuska, taitan­dita tapurka: —¿Maituku unaitak chasa ungui iuká? Chi­ura ainirka: —Uchulla­ura­mandata. ");
INSERT INTO inb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Achka biajimi chi kuku waira, nina ukupi i iakupi urma­chi­puá, paita puchu­kan­gapa. Kamka, ima­lla­pas pudis­paka, nukan­chi­manda llaki­rispa, aida­wai. ");
INSERT INTO inb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesuska nirka: —¿Imapatak niwakungi: “Kam­ka, ima­lla­pas pudis­paka, aida­wai”? Mai­kan­pas nuka­manda suma iuia­wagtaka tukui ima­pas alli­lla­mi tukug­samú. ");
INSERT INTO inb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Chasa nig­lla­pi, chi wam­brapa taitaka, kapa­rispa, nirka: —Ari, kam­manda suma­mi iuia­ni. Aida­wai, mas iuia­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Achka runa­kuna, chima kalpa chaia­na­kug­rirka. Chasa kawaspa, Jesus­ka chi mana alli kuku wairata sin­chi piñarka, kasa nispa: —Kam kuku waira mana riman­ga­pa i mana uian­gapa sakig­ta­mi nii­ki: wam­bra­manda llugsii. Mana mas ikuti iaikug­samungi. ");
INSERT INTO inb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Chasa ni­uraka, kapa­ri­chispa, ikuti iapa chabsi­chispa, llugsirka. Chi­ura chi wam­bra, wañus­ka­sina tukug­samurka. Chasa kawas­paka, achka­kuna ni­na­kurka: —Wañuskami ka—. ");
INSERT INTO inb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesuska, chi wam­brata maki­manda apispa, atari­chirka. Chi­ura­lla, alli­lla saia­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chi­ura­manda Jesuska, sug wasipi iaikug­rirka. Chipika pai sapa­lla ka­ura, paita kati­raiag­kuna tapur­ka­kuna: —¿Ima­wan­tak nukan­chika mana pudir­kan­chi, chi kuku waira­ta llugsi­chin­gapa? ");
INSERT INTO inb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Chi­ura, Jesuska ainir­ka­kunata: —Taita Diusta sin­chi mañas­ka­kuna­wa­mi chi kuku waira­kunata llugsi­chin­gapa pudirí. ");
INSERT INTO inb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chi­manda llugsis­paka, Gali­lea alpata iali­na­kurka. Chita iali­na­kuspa, Jesús munarka, mana pipas iacha­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kati­raiag­kuna­ta­mi iacha­chispa ri­kurka, kasa nispa: —Kai Runa Tukus­kaka, mana alli runa­kuna­pag­ma­mi chaia­chii tukun­gapa ka. Pai­kunaka wañu­chi­wanga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa puncha­pika ikuti­mi kaugsa­rin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Chasa nis­kata uias­paka, kati­raiag­kuna mana iachar­ka­kuna ima ni­raiagta. Chi uias­kata mana iachas­pa­pas, manchaspa kar­ka­kuna, ima ni­raiagta Jesusta tapun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kafarnaum pui­bluma chaiag­ris­paka, wasima iai­kur­ka­kuna. Chipika, Jesuska tapur­ka­kunata: —Ñambi samunakus­kapi, ¿ima­tak sin­chi rima­na­kur­kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pai­kunaka, upalla tia­na­kurka. Ñambi ri­na­kus­kapika, kikin­pura sin­chi rima­ri­na­kurka, kasa iuia­rispa: “Nukan­chi­manda­ka, ¿pi­sik mas atun taita tukuska ni­ra­ian­chi?”. ");
INSERT INTO inb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Chi­manda Jesuska, tia­rispa, chunga iskai pai agllas­ka­kunata kaiaspa, nir­ka­kunata: —Mai­kan mas atun taita kan­ga­pa munagka iukanmi ñugpa mas uchulla­sina, tukui­kunapa lutrin­sina kanga. ");
INSERT INTO inb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chasa nis­paka, sug uchulla wam­brata kaiaspa, chaugpipi saia­chirka. Chi wam­brata ugllaspa, pai­kunata nirka: ");
INSERT INTO inb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mai­kan­pas kai uchu­lla­ta­sina nuka­manda iuia­rispa chas­kig­pika, nukata chaski­wag­sina­mi rurá. Chasa chaski­was­paka, mana nuka­lla­ta chaski­wag ni­raian­chu. Nukata kacha­mu­wag­ta­pas­mi chaskig ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juanka, Jesusta kasa­mi nig­rirka: —Iacha­chig taita, sug runa kam­ba suti­wa­mi kuku waira­kunata llugsi­chi­kugta kawar­kan­chi. Pai mana nukan­chi­wa sug­lla­pi purig kag­manda, nukan­chika nir­kan­chimi: “Mana chasa rura­kui”. ");
INSERT INTO inb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesuska, kati­raiag­kunata ai­nirka: —Ianga kawan­gi­chi. Mai­kan nuka­pa suti­wa suma mana ima­ura­pas kawas­ka­sina rurag­kuna, nuka­manda tukuipi alli­lla­mi riman­kuna. ");
INSERT INTO inb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mai­kan­pas mana nukan­chita piñag­kuna, nukan­chi­wa suma iuiai­wa­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kasa­mi nuka nii­ki­chita: mai­kan­pas kam­kunata, Cristota kati­raiag­manda iuia­rispa, sug kuashag chiri iaku­lla­pas karag­pika, Taita Dius, pai­manda mana kunga­rin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Ikuti mai­kan­pas kasa uchu­lla nuka­manda suma iuia­wagta panda­chi­puag­pika, paita chaian­trami, sug atun kutanga rumi kunga­pi walka­chispa, atun kucha iaku­ma sitag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kamba maki­wa panda­rin­gapa chaiag­pika, chita chaianmi kuchun­ga­pa, mana panda­rin­gapa. Chasapaka, mas alli­char kan­tra, maki kuru suma luarma iaikug­rin­gapa. Mana kag­pika, ¿iskandi maki­kuna­wan­tachu munaipa, atun nina ñi ima­ura­pas mana wañun­gapa kas­kapi kaug­sag­rin­gapa?  ");
INSERT INTO inb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chipika, kuru kuir­puta mikug­kuna mana wañun­gapa kanchu. Nina­pas chasa­lla­ta ñi ima­ura­pas mana wañun­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","—Chasa­lla­ta, kamba chaki­wa panda­rin­gapa chaiag­pika, chita chaian­mi kuchun­ga­pa, mana panda­rin­gapa. Chasapaka, mas allichar kan­tra, chaki kuru suma luarma iai­kug­rin­gapa. Mana kag­pika, ¿iskandi chaki­kuna­wan­tachu munai­pa, dil­tudupa ninama sitai tukun­gapa?  ");
INSERT INTO inb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chipika, kuru kuir­puta mikug­kuna mana wañun­ga­pa kanchu. Ninapas chasa­lla­ta ñi ima­ura­pas mana wañun­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—Ikuti chasa­lla­ta, kamba ñawi­wa kawaspa panda­rin­gapa chaiag­pika, chita chaianmi surkun­ga­pa, mana panda­rin­gapa. Chasa­paka, mas allichar kan­tra, sug­lla ñawi­lla­wapas Taita Dius suma manda­kuska­ma iaikug­rin­ga­pa. Mana kag­pika, ¿iskandi ñawi­kuna­wan­tachu munaipa, dil­tudupa ninama sitai tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chipika, kuru kuir­puta mikug­kuna mana wañun­gapa kanchu. Ninapas chasa­lla­ta ñi ima­ura­pas mana wañun­ga­pa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kasapasmi Jesús nirka: —Tukui­kuna alli kan­gapaka, nina­pi rupa­kug­sina llakii­wa­mi kan­ga­pa kan­kuna, kaug­san­kama. ");
INSERT INTO inb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","—Kasapas. Kachi, alli­lla­mi ka. Kachi waglli­rig­pika, mana pudi­ringa­chu kachia­chin­gapa. Imasa alli­lla kachi­wa mikuita kachia­chig­sina, kam kikin­pura tukui­pi sumag­lla kaug­san­gi­chi, mana piña­chi­ri­na­kus­pa­lla. ");
INSERT INTO inb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chi pui­blu­manda llug­sis­paka, Jor­dán iaku sug ladu chimba ialispa, Judea alpama chaiag­rir­ka­kuna. Chipika, ikuti achka runa­kuna tanda­rir­ka­kuna. Chi­ura chi runa­kunata, Jesús iacha­chii kalla­rirka; imasa­mi iacha­chi­dur karka: chasa­lla­ta. ");
INSERT INTO inb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chi iacha­chi­kun­kama, sug fari­seo­kuna­pas kai­lla­iag­rir­ka­kuna. Chi runa­kuna­ka, Jesusta panda­chin­ga­pa iuiai­wa tapur­ka­kuna, kasa nispa: —¿Sug runa pudinchu, kikinpa warmita sitan­gapa? ");
INSERT INTO inb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Chi­ura, Jesuska tapur­ka­kunata: —Moiseska, ¿imatak kam­kuna­pa ñugpa­manda­kunata nirka? ");
INSERT INTO inb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chi­ura, paita ainir­ka­kuna: —Moiseska sakirka, kusa, sug iskri­biska warmita kuas­paka, ña pai­taka sitaska ni­raian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesuska nir­ka­kunata: —Kam­kuna upa iuiai tukuska kag­manda­mi Moisés kam­kunata chasa ruran­gapa sakirka. ");
INSERT INTO inb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Taita Dius­ka, ñugpata kai alpata wiña­chispa, “Kari i warmimi rurarka. ");
INSERT INTO inb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chi­manda­mi, kari kagpi, paipa taitata mamandita sakispa, paipa warmi­wa iskandi­kuna suglla­sina tukug­samun­gapa kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Chasa kas­paka, mana iskai ni­raian­chu. Suglla tukus­ka­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Taita Dius chasa suglla tukuska ni­raias­kata, ñi mai­kan runa­pas mana iukanchu, “Sita­na­kui” ninga. ");
INSERT INTO inb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chi­ura­mandaka wasipi kag­ri­ura, Jesusta kati­raiag­kuna chasa pai iacha­chi­kus­ka­manda ikuti tapug­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Chi­ura, Jesuska ainir­ka­kunata: —Mai­kan­pas, kikinpa warmita sitaspa, sug warmi­wa kasarag­pika, ñugpa warmi­manda kun­tra atun panda­riimi rurá. ");
INSERT INTO inb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chasa­lla­ta mai­kan warmi, paipa kusata sitaspa, sug kari­wa kasarag­pika, atun panda­riimi rurá. ");
INSERT INTO inb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Su­ura uchulla­kunata, pai­kuna­pa atun­kuna Jesus­pagma pusar­ka­kuna, pai­kunata maki churaspa, Taita Diusta pai­kuna­manda mañan­gapa. Jesusta kati­raiag­kunaka, pusa­na­kugta piñaspa, nir­ka­kuna: —Mana kailla­ia­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Chasa kawaspa Jesuska, paita kati­raiag­kunata rabia­wa piñaspa, nirka: —Ianga kawai­chi, wawa­kuna nuka­pagma samu­chu­kuna. ¿Ima­pa­tak arka­na­kun­gi­chi? Kai wawa­kuna­sina kag­kuna­mi suma luar­ma iaikug­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kasa­mi nuka nii­ki­chita: mai­kan­pas mana Diuspa ñawipi kai uchulla­kuna­sina alli­lla tukug­samug­pika, mana suma luarma iaikug­rin­gapa kan­kunachu. ");
INSERT INTO inb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chasa nis­paka, wawa­kunata ugllaspa, pai­kunata maki churaspa, nirka: —Taita Dius, kam­kunata iapa kuiaspa kawa­puachu. ");
INSERT INTO inb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chi­manda ñambi llug­si­kus­ka­pika, sug runa, kalpaspa, Jesuspa ñugpa ladu kungu­rig­rirka, kasa tapuspa: —Alli iacha­chig taita, ¿imasatak iukani ruranga, mana puchuka­ri­diru suma kaug­saita tarin­gapa? ");
INSERT INTO inb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesuska ainirka: —¿Imapatak nukata: “Alli iacha­chig taita” ni­wa­kungi? Mai­kan­pas mana alli tianchu. Taita Dius­lla­mi alli ka. ");
INSERT INTO inb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Moisés ima nis­ka­ta ña­mi iachangi: “Mana wañu­chingi. Mana sugpa warmi­wa siri­ringi. Mana sisangi. Mana pi­manda­pas llullangi. Ima­pas mana llulla­chispa sisangi. Kamba taitata maman­dita sumag­lla kuiangi”. ");
INSERT INTO inb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chi­ura, chi runa ainirka: —Iacha­chig taita, nuka uchulla ka­ura­manda­ta­mi tukui chi nis­kata chasa ruraspa kaug­sani. ");
INSERT INTO inb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesuska, paita kuiai­wa kawaspa, nirka: —Nig­pika, kasami pisi­pu­kungi. Kuna­ura­lla rii. Tukui ima iukas­kata katug­rii. Katuska kulki­taka mana iukas­ka­kunata tukuita karag­rii. Chasa ruras­paka, suma luarpika iapa iukagmi tukun­ga­pa kangi. Nis­paka samungi, nukata kati­wan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Chasa rimas­kata uias­paka, chi runa llaki­rirka. Irkias­pa­mi rirka, iapa iukag kaspa. ");
INSERT INTO inb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesuska, muiug­ta kawaspa, kati­raiag­kunata nirka: —Iapa iukag­kuna suma luarma iaikug­rin­gapaka, iapa trabajusumi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chasa uiaspa, kati­raiag­kuna­ka iapa ujna­rir­ka­kuna. Jesus­ka, ikuti nir­ka­kunata: —Wam­bra­kuna, iapa tra­ba­ju­su­mi ka, suma luarma iaikug­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maschar alli kan­tra, sug wagra, sug aguja ñawipi ialin­gapa. Chi­manda mas tra­ba­ju­su­mi ka, chi iapa iukag­kuna suma luarma iaikug­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Chasa uias­paka kati­raiag­kuna, iapa mancha­rispa, kikin­pura tapu­ri­na­kurka: —Nig­pika, ¿pisik kispi­rin­gapa pudinga? ");
INSERT INTO inb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Chi­ura Jesuska, pai­kunata kawaspa, nirka: —Ñi mai­kan runa mana pudin­chu. Taita Dius­lla­mi kispi­chin­gapa pudí. Taita Diusmi ima­pas pudí. ");
INSERT INTO inb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Chi­ura Pedroka, nii kalla­rirka: —Uiamui. Nukan­chi, tukui ima iukas­kata sakis­pa­mi kamta kati­ra­ian­chi. ");
INSERT INTO inb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesuska ainirka: —Kasami nuka nii­ki­chita: mai­kan­pas, nukata i Alli Willaita kuiaspa, wasita, waugki i pani­kuna­ta, mama i taitandita, wam­bra­kuna­ta, alpa­kunata u ima iukas­ka­ta sakispa kati­wagka, ");
INSERT INTO inb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","patsa­manda mas patsa­mi kai alpa­pita chaskin­gapa kan­kuna. Chasa­lla­ta wasi­kuna, waugki i pani­kunata, mamandi­kunata, wam­bra­kunata i alpa­kuna­ta­pas­mi chaskin­ga­pa kan­kuna, nukata kati­raia­wag­manda llakii pasaspa. Suma luar­pi­pas, mana puchuka­ri­diru kaug­sai­ta­pas­mi tarig­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Chasa kagpi­pas, kuna­ura ñugpa ni­raias­ka­kuna, achka­kuna­mi kati laduma tukun­gapa kan­kuna. Ikuti kuna­ura kati ni­raias­ka­kunaka, achka­kuna­mi ñugpa laduma tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Chi­ura­manda, Jeru­salén pui­bluma ñambi ri­na­kurka. Jesus­ka ñugpa ri­kurka. Paita kati­raiag­kunaka, ujna­rispa kati kati ri­na­kurka. Sug runa­kunaka, man­chas­pa­mi kati­chi­na­kurka. Jesuska, ikuti chunga iskai pai agllas­ka­kuna­lla­ta kaiaspa, ima paita pasa­rin­gapa kagta willai kalla­rirka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Uia­wai­chi. Jeru­salen­ma­mi ri­na­kun­chi. Chipika, kai Runa Tukus­kaka iaia sasir­duti­kunapa i Moisés ima nis­kata iacha­chig taita­kunapa maki­pi­mi api­chii tukun­gapa ka. Chi runa­kunaka, nuka­manda ninga­pa­mi kan­kuna: “Wañu­chiimi chaiá”. Nis­paka, mana judíu kas­ka­kuna­pag­ma­mi chaia­chi­wan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pai­kuna, nukata unz̈a­waspa, tuka­waspa, asuti­waspa, wañu­chi­wanga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa puncha­pika ikuti­mi kaugsa­rin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeopa wambrakuna, San­tiago i Juan suti, Jesus­pagma kailla­ias­paka, kasa­mi nir­ka­kuna: —Iacha­chig taita, nukan­chi ima maña­na­kus­kata, ¿mana­chu uia­wan­trangi? ");
INSERT INTO inb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chi­ura, Jesús tapurka: —¿Imatak muna­na­kun­gi­chi, nuka ruran­gapa? ");
INSERT INTO inb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chi­ura ainir­ka­kuna: —Kam sumag­lla mandangapa tia­rispa chaia­ura, nukan­chita tia­ri­chingi: sugtaka kamba alli ladu, sugtaka kamba lluki ladu. ");
INSERT INTO inb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesuska nir­ka­kunata: —Mana iachan­gichichu ima maña­na­kugta. Nukata chaia­wanga­pa­mi ka, iapa achka llakii­kuna iukan­gapa. ¿Kam­kuna­paschu chasa­lla­ta pudin­tran­gi­chi, llakii­kunata pasan­gapa? Chasa­lla­ta, nukata chaia­wanga­pa­mi ka, wañu­chii tukun­gapa. ¿Kam­kuna­paschu chasa­lla­ta pudin­tran­gi­chi, wañu­chii tukun­gapa? ");
INSERT INTO inb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Chi­ura ainir­ka­kuna: —Ari, chasa pudinga­pa­mi kan­chi. Jesuska nir­ka­kunata: —Ari, nuka llakii­kuna­sina­lla­tata, kam­kuna­pas­mi pasankan­gi­chi. Imasa­mi nuka wañu­chii tukun­gapa kani: kam­kuna­pas­mi chasa­lla­ta wañunkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Chi nuka­pa alli ladu lluki ladu tia­ri­chin­ga­paka, nukata mana chaia­wa­kunchu kawan­gapa. Mai­kan nuka­pa Taita agllas­ka­kuna­ta­mi chasa tia­ri­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Santiago i Juan ima maña­na­kus­kata uias­paka, chi sug chunga kati­raiag­kuna rabia­rii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesuska, pai­kunata kaias­pa, nir­ka­kunata: —Kam­kuna alli­lla­mi iachan­gi­chi: kai alpapi atun mandag­kuna, manda­nakus­kapi kaug­sag­kunata ñi ima mana lla­kis­pa­lla­mi mandan­kuna. Chasa­lla­ta, mai­kan­pas atun mandag­sina tukuspa, mana llakis­pa­lla­mi runa­kunata charin­kuna. ");
INSERT INTO inb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kam kikin­puraka, chasa rurag runa­kunaka mana kan­gi­chi. Kam kikin­pura mai­kan, Diuspa ñawipi atun kan­gapa munas­paka, sug­kuna­pa lutrin­sina tukuchu. ");
INSERT INTO inb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mai­kan mas atun taita kan­gapa munag­pas, ñugpa iukanmi, tukui­kuna­pa lutrin­sina kanga. ");
INSERT INTO inb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chasa­lla­ta kai Runa Tukus­kaka mana samurka­chu, sug­kunata lutrin­sina churan­gapa. Tukui­kunapa lutrin­sina kanga­pa­mi nuka samurka­ni. Nuka­pa wañui­wa­mi achka­kunata kispi­chin­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús kati­raiag­kuna­wan­ta, Jerikó suti pui­bluma chaiag­rir­ka­kuna. Iapa achka runa­kuna, paita kati­chir­ka­kuna. Chi­manda llugsi­naku­ura, sug runa mana ñawi kawag, limusna mañaspa, ñambi kuchu­pi tia­kurka. Chi runa, Timeo­pa wam­bra Bartimeo suti karka. ");
INSERT INTO inb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chi runaka, Nazaret­manda Jesús ña iali­kugta uiaspa, kapa­rii kalla­rirka, kasa nispa: —Davidpa wam­bra Iaia Jesús, nuka­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Achka runa­kuna, paita piñaspa, ni­na­kurka: —Upalla kai. Paika, ikuti mas sin­chi­mi kapa­rii kalla­rirka, nispa: —Davidpa wam­bra, nuka­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chasa uiaspa Jesuska, saia­rispa, nirka: —Paita kaiamui­chi. Chi runata kaias­paka, nir­ka­kuna: —Alli iuia­chi­rispa, atarii. Kam­ta­mi kaia­ku. ");
INSERT INTO inb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chasa uias­paka, kataraiaska katan­gata sitaspa, utkalla Jesus­pag­ma chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chaiag­ri­ura, Jesus­ka paita tapurka: —¿Imatak muna­kungi, nuka kam­ta ruran­gapa? Chi­ura ainirka: —Nuka­pa iacha­chig taita, nuka kawanga­pa­mi muna­kuni. ");
INSERT INTO inb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Chi­ura, Jesuska nirka: —Kam nuka­manda suma iuia­ris­ka­manda­mi ambi­rig­samungi. Kuna­ura kam­bagma riilla. Chasa nig­lla­pi, alli­lla kawai kalla­rirka. Nis­paka, Jesús maima ri­kuska­ma katii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jeru­salenma ña kailla­ia­na­kuspa, Betfajé i Betania suti pui­blu­kuna ña kawa­ri­kus­ka­manda, Olivos suti luma­kama chaiag­rir­ka­kuna. Chi­manda Jesus­ka, iskai kati­raiag­kunata kacharka, ");
INSERT INTO inb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kasa nispa: —Rii­chi chi ñugpa ladu uchulla pui­bluma. Chaiag­ris­paka, tarig­rin­kan­gi­chimi sug buru wata­ra­ias­ka­ta, manara pipas tia­riska. Chi buruta paskaspa, apa­mun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mai­kan tapu­chu: “¿Imapatak chasa rura­na­kun­gi­chi?”: chi­ura ai­nin­gi­chi: “Iaia Jesus­ta­mi minis­ti­ku. Maña­chii. Ña­mi kuti­chi­munga”. ");
INSERT INTO inb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Chi kachai tukus­ka­kunaka, rispa, sug wasi ladu­lla­pi buru watas­ka­ta tarig­rir­ka­kuna. Chitaka paskar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Chipi kag­kunaka tapur­ka­kuna: —¿Imapatak buruta paska­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chi­ura, Jesús imasa nis­ka­sina ainir­ka­kuna. Chasa uias­paka, sakir­ka­kuna apan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chi­ura, buruta Jesus­pagma apar­ka­kuna. Chaia­chig­ris­paka, burupa wasapi pai­kunapa katan­ga­kunata churar­ka­kuna. Chasapika Jesús, tia­rispa, rii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Chasa Jesús ri­kugta kawaspa, achka runa­kuna, pai­kuna kata­ra­iaska katan­ga­kunata ñambi suiu manda­chir­ka­kuna. Sug­kunaka, panga­iug sacha uchulla malki­kuna­ta kuchuspa, ñambi ñambi churar­ka­kuna, pai ialin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nis­paka Jesusta ñugpag­kuna i paipa kati ri­na­kug, kasa kapa­rispa nii kalla­rir­ka­kuna: —Taita Diusta iapa suma kag­ta­mi nin­chi. Atun Taita Dius kacha­mus­ka­mi samu­kungi. Paipa iapa kuias­ka­mi kangi. ");
INSERT INTO inb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kam samu­kungimi, nukan­chipa ñugpa­manda taita David mandas­ka­sina­lla­tata suma mandag kan­ga­pa. Taita Dius awa suma luarpi kag­ta­mi nin­chi: “Kam, iapa suma­mi kangi”. ");
INSERT INTO inb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús chasa Jeru­salenma chaiag­ris­paka, Diuspa atun wasi uku­ma iaikug­rirka. Chi ukupi tukui­ta kawas­paka, ña chisiaska ka­ura, chunga iskai pai agllas­ka­kuna­wan­ta Betania pui­bluma rirka. ");
INSERT INTO inb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chi kaiandi, Betania pui­blu­manda ri­kus­kapika, Jesusta iarkai apig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sug igus panga­iug sachata karu­manda­ta kawarka. “Chi sachapi mikui muiumi tianga” iuiaspa, chima kailla­iarka. Chi sacha­ma chaiag­ri­uraka, ñi ima mikui mana iukarka, manara tia­riska kag­manda. ");
INSERT INTO inb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Chi­ura, Jesuska nirka: —Kuna­ura­manda, ñi ima­ura­pas mana pipas, kai sacha­manda muiu mikun­gapa kan­kunachu. Chasa rimagtaka, paita kati­ra­iag­kuna uiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chi­mandaka, Jeru­salén pui­bluma ikuti chaiag­rir­ka­kuna. Diuspa atun wasi ukuma iaikug­rispa, Jesuska katug­kunata i randi­na­kugta chi ukupi kawarka. Chi­manda, iapa rabia­rispa, pai­kunata llugsi­chii kalla­rirka. Kulki trukag­kunapa misa­kunata i paluma katug­kunapa banku­kuna­ta­pas bula­chirka. ");
INSERT INTO inb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chasa­lla­ta, mana sakirka, pipas chi wasi ukuta ima­pas apa­rispa ialin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chipi kag­kuna­ta­pas iacha­chirka, kasa nispa: —Ñugpa­manda librupi, kasa­mi willa­raiá: “Nuka­pa wasi, Taita Dius­ta iuia­rispa tukui alpa­kuna­manda runa­kuna maña­diru­mi kan­ga­pa ka”. “Kam­kunaka, sisai kaug­sa­diru­sina­mi rurar­kan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesús chasa rimas­kataka, iaia sasir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kuna uiar­ka­kuna. Chasa uias­paka, paita iuia­ri­na­kurka, imasa­pi­pas wañu­chin­ga­pa. Nig­pika, pai ima iacha­chis­ka­kuna­ta tukui runa­kuna suma ujna­rispa kag­manda­mi paita manchar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ña tutaia­ku­ura, Jesús kati­ra­iag­kuna­wan­ta chi atun pui­blu­manda llugsir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chi kaiandi tutata ñambi ri­na­kus­kapika, chi igus sachata angu­manda­ta limpiu chaki­riska kagta kawar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Chi­ura Pedro, iuia­rispa, Jesusta nirka: —Kawai, iacha­chig taita. Sacha­ta kam nir­kangi wañun­gapa; chika ña­mi chaki­riska ka. ");
INSERT INTO inb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesuska, pai­kunata ainirka: —Taita Dius­manda suma iuiai iukan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kasa­mi nuka nii­ki­chi­ta: kam­kuna chi suma iuiai­wa mana sug rigcha iuias­pa­lla, kai luma­ta nin­tran­gi­chi: “Kai­manda anchu­rispa, atun kucha iaku ukuma sita­rig­rii”; kam­kuna ima nis­ka­sina­mi tukug­samun­tra. Imasa nis­ka­sina pasa­rin­gapa kagta suma iuiag­pika, chasa­lla­ta­mi tukug­samunga. ");
INSERT INTO inb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chi­manda, kasa­mi nii­ki­chita: Taita Diusta kam­kuna ima mañas­paka, suma iuia­rispa, kasa iuian­gi­chi: “Ña­mi chaskiska kani”. Chasa suma iuiagpi­kunaka, kam­kuna ima mañas­ka­sina­mi tukug­samun­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","—Kasapas. Taita Diusta mañan­gapa ka­ura, mai­kanwa piña­chi­ri­na­kuska kagta iuia­richu: ringa­pa­mi chaiá, ñugpa parijuma pasin­sia­chi­ri­na­kun­gapa. Sug­kuna­ta pasin­siag­pika, kam­kunapa Taita Dius suma luarpi kag­pas­mi kam­kuna panda­ris­ka­kuna­ta­pas pasin­sianga.  ");
INSERT INTO inb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ikuti kam­kuna sug­kuna­ta mana pasin­siag­pika, kam­kuna­pa Taita Dius suma luarpi kag­pas kam­kuna panda­ris­ka­kunata manami pasin­sianga. ");
INSERT INTO inb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chi­mandaka, ikuti Jeru­sa­lenma chaiag­rir­ka­kuna. Diuspa atun wasi ukupi Jesús puri­ku­ura, iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas pai­pagma kailla­iar­ka­kuna, ");
INSERT INTO inb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tapun­gapa: —¿Imapatak chasa ruraspa puri­kungi? ¿Pitak kamta kacha­murka, atun tukuspa puri­kun­gapa? ");
INSERT INTO inb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesuska ainir­ka­kunata: —Nuka­pas, kam­kunata tapu­sa­ki­chita. Kam­kuna aini­wag­pika, nuka­pas willa­sa­ki­chitami, pi nukata kacha­mu­waspa atun­ia­chi­waska kagta. ");
INSERT INTO inb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Pitak Juanta kacharka, baug­ti­san­gapa? ¿Taita Dius­chu kacha­murka? Mana kag­pika, ¿runa­kunachu kacharka? Aini­wai­chi. ");
INSERT INTO inb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Chi­uraka, kikin­pura rima­ri­na­kurka, kasa iuia­rispa: —“Taita Dius kacha­mus­ka­mi karka” nig­pika, paika ainingami: “Nig­pika, ¿imapatak mana paita uiar­kan­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Runa­kunalla kacha­mus­ka­mi karka” mana ni­sun­chi. Tukui­kuna­mi Juan­manda iuia­nakú: “Sutipa­mi Santu Ispi­ri­tu­wa rimag karka”. Pai­kunata chi­manda­mi manchai iukan­chi. ");
INSERT INTO inb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chasa rima­na­kuspa, Jesusta ainir­ka­kuna: —Mana iachan­chichu, Juanta pi kacha­muska kagta. Chasa aini­ura, Jesuska nir­ka­kunata: —Chi­manda­mi nuka­pas mana willai­ki­chita, pi kacha­mu­waska kag­ta, atun tukuspa kan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Chi­ura­mandaka, iuiai apin­ga­sina suma parlu­kuna­wa­mi rimai kalla­rir­ka­kunata, kasa nispa: —Sug runa, achka ubas sacha malki­kunasi paipa alpapi tarpurka. Chi alpa muiundi kincha saia­chispa, ubas iaku surku­dirupassi rurarka. Chasa­lla­ta, awa kawitu saia­chirka, tarpus­kata kawa­na­kun­gapa. Chasa ruras­paka, sug runa­kunata chi ubas sacha­kunata sakirka, almaspa, chaugpi chaugpi pallan­gapa. Chasa sakis­paka, karu alpama rirka. ");
INSERT INTO inb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","—Ña pallan­gapa chaia­uraka, sug piunta chi almag­kuna­pagma kacharka, paipa rasiunta chaskin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Chi runa­kunaka, kachai tukus­kata apispa, makaspa, chusa maki kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","—Chi­ura­manda, ikuti sug piun­ta­si kacharka. Chitaka kamispa, makaspa, umapi kuchur­ka­kuna. Chasa­lla­ta, chusa maki rirka. ");
INSERT INTO inb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","—Ikuti sug piun­ta­passi kacharka. Chitaka wañu­chir­ka­kuna­si. Chi­ura­mandaka, ikuti achka­kunata kacharka. Pai­kuna­ta­ka makar­ka­kuna. Sug­kuna­taka wañu­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Chi duiñuka iukarkasi suglla wam­bra, iapa kuiaska. Katimakar, paita kacharka, kasa nispa: “Nuka­pa wam­bra kag­manda, mana ima­pas rura­puan­ga­kunachu”. ");
INSERT INTO inb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Nigpika chi almag­kunaka, chi wam­brata kawaspa, kikin­pura rima­rir­ka­kuna, kasa nispa: “Kawai­chi. Kai alpa duiñupa wam­bra­mi samu­ku. Pai­ta­pas wañu­chi­sun­chi. Chasaka, nukan­chipa­lla­mi kai alpa tukunga”. ");
INSERT INTO inb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Chasa nis­paka, paita apispa, wañu­chir­ka­kuna. Chi alpa­manda llugsi­chispa, sitag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Chasa parlas­paka, Jesús nirka: —Nigpi chi duiñuka, ¿mana­chu samuspa, chi runa­kunata tukuita wañu­chig­samun­tra; nis­paka, chi sacha­kunata ikuti sug­kunata alman­gapa sakin­tra? ");
INSERT INTO inb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—¿Mana­chu ñugpa­manda li­bru­pi kasa willa­raias­kata kawar­kan­gi­chi? Wasi­chig­kuna wabutiska rumi, wasita charigmi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Atun Taita Diusmi chasa rurarka. Nukan­chi, iapa ujna­ris­pa­mi chasa ruras­kata kawa­na­kun­chi. ");
INSERT INTO inb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chi parluta uias­paka, judíu taita­kuna nir­ka­kuna: —Nukan­chitami uia­chi­ku—. Chi­manda, Jesusta api­chin­gapa muna­na­kurka. Chasa muna­na­kuspa­pas, achka runa­kuna chipi kag­manda, manchai apir­ka­kunata. Chi­manda, paita sakispa, anchu­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nis­paka, sug fari­seo­kunata i mandag Herodes­wa purig­kunata Jesus­pagma kachar­ka­kuna, pai rima­kus­kata uiaspa, ima­pi­pas panda­rig­pika, jus­ti­sia­kunata willag­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Chaiag­ris­paka, chi runa­kuna Jesusta sumag­lla nir­ka­kuna: —Iacha­chig taita, nukan­chi iachan­chimi, kam mana llullas­pa­lla rimagta. Mana pi­ta­pas kawas­pa­lla­mi tukui­kunata iwallla sutipa kas­ka­ta iacha­chingi, imasa Taita Dius munas­ka­sina ruraspa kaug­san­gapa­kuna. Chi­manda­mi kasa tapug­samun­chi: ¿alli­lla­chu ka, Roma­manda iaia mandagta nukan­chi impuistu kuan­gapa? ¿Paga­sun­chi­chu u mana? ");
INSERT INTO inb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesuska iacharka, sungu awa­lla chasa tapu­na­kugta. Nis­paka nir­ka­kunata: —¿Imapatak muna­na­kun­gi­chi panda­chi­wan­gapa? Impuistu kulki kua­diruta apa­mui­chi, nuka kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Chi­ura, sug kulki apag­rispa kuag­rir­ka­kuna. Chita kawaspa, Jesuska tapur­ka­kunata: —Kai kulkipi, ¿pipa ñawitak kawa­ri­ku? ¿Pi­mandatak willaska ni­raiá? —Roma­manda iaia mandag­manda— ainir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chasa aini­ura, Jesuska nir­ka­kunata: —Chasa kagpika, Roma­manda iaia mandagpa kas­kata paita kuai­chi. Taita Diuspa kas­kataka Taita Diusta kuai­chi. Chasa uias­paka, iapa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chi­ura­manda sug sadu­seo suti runa­kuna, Jesus­pagma chaiag­rir­ka­kuna. Chi runa­kuna iacha­chi­dur­mi kan­kuna, wañus­ka­kuna mana mas kaugsa­rin­gapa kagta. Chaiag­ris­paka, Jesusta nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Iacha­chig taita, Moiseska nukan­chi­manda kasasi willaspa sakirka. Sug kari kasaraspa, warmi manara wam­bra­kuna iukag­lla­pi wañug­pika, sug waugkindisi iuká chi biuda­wa kasaranga; chasaka, wañug waugkindipa kuinta wawa­kuna iukan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Nigpika, kan­chis waug­kin­di­kunasi tiarka. Atun waug­kin­dika, kasaraspa, warmi manara wawa­kuna iukag­lla­pisi wañurka. ");
INSERT INTO inb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chi­wanka, kipa­manda waug­kin­disi chi sapalla kidaska warmi­wa kasarai iukarka. Chi waug­kin­di­pas, warmi manara wawa­kuna iukag­lla­pisi wañurka. Kati­manda waug­kindi­ta­pas chasa­lla­ta pasa­rirka. ");
INSERT INTO inb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chasa­lla­tasi tukui kan­chis waug­kindi­kuna, warmi manara wawa­kuna iukag­lla­pi wañur­ka­kuna. Kati­ma­kar, chi warmi­pas wañurka. ");
INSERT INTO inb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nig­pika, wañus­ka­kuna kaugsa­ri­uraka, ¿pipatak chi warmika kanga, chi kan­chis waug­kin­di­kuna­wa kasadu kaspa? ");
INSERT INTO inb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesuska ainir­ka­kunata: —Kasa­manda­mi kam­kuna panda­rispa iuia­na­kun­gi­chi: ñug­pa­manda librupi willa­raias­kata ñi Taita Diuspa iapa iachaita mana iuiai iukan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wañus­ka­kuna kaugsa­riska­ura­mandaka, kari ñi warmi mana kasa­ran­gapa kan­kunachu. Imasa suma luar­manda anjil­kuna­sina­mi kaug­san­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Kasapas. ¿Imapatak kam­kuna nin­gi­chi: “Wañus­ka­kuna mana mas kaugsa­rin­gapa kan­kuna­chu”? ¿Mana­chu kasa Moisés willa­raias­kata kawar­kan­gi­chi? Taita Dius, sacha rupa­kus­ka­manda rimaspa, kasa­mi paita nirka: “Nuka­mi kani Abra­hampa, Isaakpa i Jakobpa Taita Dius”. ");
INSERT INTO inb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Taita Dius mana kanchu wañus­ka­kunapa. Kaug­sag­kunapa­mi Taita Dius ka. Chasa mana iachas­pa­mi iapa panda­rispa iuia­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés ima nis­kata sug iacha­chig taita, Jesús sadu­seo­kuna­wa rima­na­kus­kata uia­kurka. Jesús chasa suma ainis­kata iachaspa, chi runaka, pai­pagma kailla­iaspa, tapurka: —Tukui mandai­kuna­manda, ¿mai­kantak mas atun ka? ");
INSERT INTO inb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Chi­ura, Jesuska ainirka: —Kai mandaimi tukui­kuna­manda mas atun ka: “Uiai­chi, Israel­manda runa­kuna. Nukan­chipa atun Taita Diuska, suglla iaia­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kamba atun Taita Diusta kuiangi kam kikinpa alma­wa, sungu­wa, tukui animu­wa i tukui iuiai­kuna­wa”. ");
INSERT INTO inb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kai kati­manda­pas­mi chi mandai­sina­lla­tata atun ka: “Kam kikinta­sina­mi iukangi, tukui runa­kunatapas kuianga”. Chi iskandi mandaimi tukui­kuna­manda mas atun ka. ");
INSERT INTO inb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Chi­ura, chi runaka nirka: —Allillami aini­wangi, iacha­chig taita. Sutipa­mi ningi: “Taita Dius, sug­lla­mi tia”. Sug rigcha diuska, mana tianchu. ");
INSERT INTO inb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Kam kikinpa sungu­wa, tukui iuiai­wa i tukui animu­wa Taita Diusta kuian­gi­chi” i “Kam kikinta­sina­mi iukangi, tukui runa­kunata kuianga”: chasa rurai­kuna­waka, Diuspa ñawipi tukui alli­lla kag­ta­mi kawá. Ikuti mai­tuku­pas Taita Diusta kama­ri­ku karaspa, ima wagra u animal altarpi rupa­chis­kaka, Diuspa ñawipi mai­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Chi runa suma ainis­kata uiaspa, Jesuska paita nirka: —Kamta mai­lla­mi pisi­ku, Taita Dius­wa tukuska­pura kan­gapa. Chi­ura­manda ñi pipas, mana mas animu iukar­ka­kuna, Jesusta tapun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Diuspa atun wasi ukupi iacha­chi­kuspa, Jesuska nirka: —Taita Diuspa agllaska Cristo­manda, ¿imapatak Moisés ima nis­kata iacha­chig taita­kuna nin­kuna, Davidpa wam­brapa kati wam­bra kagta? ");
INSERT INTO inb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","¿Mana­chu David kikin, Santu Ispi­ri­tu­wa kaspa, Cristo­manda kasa willarka? Atun Taita Diusmi nuka­pa iaiata nirka: “Nuka­pa alli ladu tia­rii, nuka tukui kamta mana munag­kunata apag­rispa, kamba chaki saru­diru ukuma churan­kama”. ");
INSERT INTO inb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Chasami David kikin, Cristo­manda nirka: “Nuka­pa iaia”. Nig­pika, ¿ima­wan­tak Cristo, paipa wam­brapa kati wam­bra kanga? Iapa achka runa­kuna, Jesusta sumag­lla­mi uia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kasapasmi Jesuska iacha­chispa ni­kurka: —Moisés ima nis­kata iacha­chig taita­kuna­wa mana iapa sug­lla­pi iuiai­wa kan­gi­chi. Pai­kuna munan­kuna­mi, iapa suma kawa­ri katan­ga­kuna chura­rispa purin­gapa. Kallipi pai­kuna­wa tupa­na­kus­kapi munan­kuna­mi, iapa suma kuiai­wa kumu­rispa, “Puangi, taita waugki” nin­gapa­kunata. ");
INSERT INTO inb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tanda­ri­diru wasi­kuna­pi­pas munan­kunami, atun taita­kuna tia­ri­diru ñugpa ladu tia­rin­gapa. Chasa­lla­ta, maima kun­bi­dagpi suma mikun­gapa kaia­ura, ñugpa ladu tia­ringa­pa­mi munan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Warmi sapa­lla kidas­ka­kunata wasi­kuna­ta­mi kichu­dur kan­kuna. Nis­paka, kawa­chi­ringa­pag­lla­mi unai Taita Diusta rima­na­ku­dur kan­kuna. Chasa ruras­ka­kuna­manda­mi sug luarpi sug­kuna­manda­pas mas llakii­pi jus­ti­siai tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Diuspa atun wasi ukuma sug­nig­manda iaikug­ris­paka, Jesús, kulki chura­diru­kuna ladu­lla­pi tia­rig­rirka. Chipika, runa­kuna imasa kulki chura­na­kus­kata kawa­kurka. Achka­kuna, iapa iukag­kuna kaspa, achka kulki chura­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chi­ura sug warmi mana iukag sapalla kidas­kaka, chaiag­rispa, iskai uchulla kulki­lla­mi churarka. ");
INSERT INTO inb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chasa kawaspa Jesus­ka, paita kati­raiag­kunata kaiaspa, nirka: —Kasami nuka nii­ki­chita: chi warmi mana iukag sapalla kidaska, tukui­kuna­manda mas achka churag­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sug­kunaka, pai­kuna­pa puchus­ka­ta­mi churar­ka­kuna. Ikuti chi warmika, mana iukaspa­pas, pai mikun­gapa chari­kus­ka­ta­mi tukuita kararka. ");
INSERT INTO inb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Diuspa atun wasi uku­manda Jesús llugsi­ku­uraka, sug paita kati­raiag, ujna­rispa, nirka: —Kawamui, iacha­chig taita. Asku­rinti iapa atun kantiaska rumi­kuna­wa saia­chiska suma wasi­kuna­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesuska, paita nirka: —Kai atun wasi­kuna­manda kasa­mi willaiki: chi tukui pia­chiska rumi­kuna, ñi sug mana sakin­gapa kan­kunachu. Tukui­ta­mi urma­chispa puchukan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús ña Olivos lumapi, Diuspa atun wasi sug ladu chimba kawa­rii­pi tia­rig­rirka. Chi­ura Pedro, San­tia­go, Juan i Andrés, pai­lla­wa kaspa, tapur­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Nukan­chita willai: ¿ima­ura­tak chasa pasa­ringa? Ña tukui chasa pasa­rin­gapa kagta, ¿ima­wa­tak kawa­chinga? ");
INSERT INTO inb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Chi­ura Jesuska, nii kalla­rir­ka­kunata: —¡Ujala­lla­pas mai­kan, kam­kuna­ta llulla­chispa panda­chi­chu­kuna! ");
INSERT INTO inb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Achka­kuna­mi, nuka­sina tukuspa, samun­gapa kan­kuna, kasa nispa: “Nuka­mi Taita Dius agllaska Cristo kani”. Chasa rima­na­kus­ka­waka achka runa­kuna­ta­mi llulla­chin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Tukuimami mana llakis­pa­lla wañu­chi­na­kugta iacha­rin­gapa ka; kam­kuna mana mancha­ri­na­kun­gi­chi. Chasa­mi pasa­rin­gapa ka. Nig­pi­pas, kai alpa puchuka­rii pun­cha manara chaia­muska ni­raian­chu. ");
INSERT INTO inb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ñugpa­mi sug mandag alpa­nig­manda­kuna­wa sug­nig­manda­kuna­wa wañu­chi­na­kui tian­ga­pa ka. Sug­nig­manda sug­nig­manda­mi alpa kuiu­rispa chapu­rispa rin­ga­pa ka. Iapa iarkaimi tian­gapa ka. Chi llakii­kuna pasa­riska, chara kalla­rii­lla­mi kan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Alli­lla iuia­rispa kaug­sa­na­kun­gi­chi. Kam­kunata apispa, jus­ti­sia­kuna­pag­ma­mi apan­ga­kuna. Tanda­ri­diru wasi­kuna­pi­mi kam­kuna­ta asutin­ga­kuna. Kam­kuna nuka­wa kag­manda, atun mandag­kuna­pag­ma­mi puri­chin­ga­kuna, jus­ti­siai tukun­gapa. Chi­ura, pai­kunata nuka­manda­mi willankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nuka­manda Alli Willaita tukui runa­kunata kai alpapi willa­ura­mi kai alpa puchuka­rii puncha kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Jus­ti­sia­kuna­pagma kam­kunata apa­ura, mana iapa iuia­na­kun­gi­chi: “¿Imasa­mi pai­kunata ai­ni­ni?”. Ainin­gapa chaia­ura, kikin Santu Ispi­ri­tumi iuia­chin­gapa ka. Kam kikin­kunapa iuiai­wa mana rima­na­kun­gapa kan­gi­chi­chu. Santu Ispi­ri­tu­mi kam­kunata alli­lla rima­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Chi puncha­kuna sug­kuna, waugkindi­kuna­ta­mi kuan­ga­kuna, wañu­chii tukun­gapa. Chasa­lla­ta taita­kuna­pas, pai­kunapa wam­bra­kuna­ta­mi wañu­chin­gapa kuan­ga­kuna. Wam­bra­kuna­pas, taita i maman­dita kun­tra tukuspa, wañu­chinga­pa­mi kuan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tukui­kuna­mi kam­kuna­wa rabia­rin­gapa kan­kuna, kam­kuna nuka­wa kag­manda. Chasa pasa­nakuspa­pas, wañun­kama nuka­lla­wa iuia­rispa kag­kuna­mi kispi­rin­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","—Iapa jiru mana kawan­ga­sina­mi ruran­gapa kan­kuna; sug ianga dius­sina rigchata Diuspa atun wasi uku­pi­mi saia­chin­gapa kan­kuna. Chitaka, kam­kuna kawanga­pa­mi kan­gi­chi. (Santu Ispi­ri­tu­wa rimag willa­raias­kata alli­lla iuiai­wa iuia­rispa kawan­gi­chi.) Chasa kawas­paka, Judea alpapi kaug­sa­na­kug sachukuma miti­ku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mai­kan­pas wasi truja awapi kag­kuna, mana urai­ku­nakuchu, uku­ma iai­kuspa, ima­kuna apan­ga­pa. Imasa kas­ka­sinalla miti­ku­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chasa­lla­ta mai­kan­pas chagrapi kag­kuna, mana wasima kuti­chu­kuna, katanga u ima­pas tanda­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ai, mai­kan warmijim­kuna, chi puncha­kuna wigsa­wa ungug u uchulla markaska kag­kuna! ");
INSERT INTO inb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taita Diusta mañan­gi­chi, mana chaia­chu, tamia puncha miti­kui tian­gapa. ");
INSERT INTO inb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","—Chi puncha­kuna, asku­rinti iapa llakiimi tian­gapa ka. Taita Dius kai alpa wiña­chiska­ura­manda­ta kunan­kama, chasa llakii­ka mana tiaska kanchu. Chasa­lla­taka, kuna­ura­manda mana ikuti chasa tian­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Atun Taita Dius chi llakii puncha­kunata mana pisia­chig­pika, ñi pipas mana­char kispi­rin­tra. Pai agllas­ka­kunata iapa kuias­pa­mi chi puncha­kunata pisia­chin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Chi­ura­kuna, kam­kunata ni­na­kungami: “Uiamui­chi. Taita Dius agllaska Cristo, kai­pi­mi ka” u “Chi­pi­mi ka”. Chasa ni­na­kugpi­pas, kam­kuna mana uian­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi pun­cha­kuna, iapa llulla­chig­kuna­mi kawa­rig­samun­gapa kan­kuna, kasa nispa: “Nuka­mi Cristo kani” u “Nuka­mi Santu Ispi­ri­tu­wa rimag kani”. Chi runa­kunaka, mana ima­ura­pas kawas­ka­sina i ujna­rin­ga­sina­mi kawa­chin­gapa kan­kuna. Chasa kawa­chis­ka­waka Taita Dius agllas­ka­kuna­ta­pas­mi ñalla llulla­chin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chasa uiaspa, kam­kunaka alli­lla iuia­rispa kaug­sa­na­kun­gi­chi. Manara chasa tukun­ga­pa chaiagpi­ta­mi tukui alli­lla willai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Chi iapa llakii puncha­kuna ialiska­ura­mandaka, indimi amsa­ian­gapa ka; ki­lla­pas, manami puncha­ia­chin­gapa ka; ");
INSERT INTO inb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","istrilla­kuna, awa­manda­mi urman­gapa kan­kuna; kai alpa­manda awa ladu tias­ka­kuna­pas­mi kuiu­chii tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Chi­ura, kai Runa Tukus­ka­ta­mi kawa­wan­ga­pa kan­kuna. Nuka­pa tukui iapa suma iachai­wa puiu­kuna­pi­mi samun­gapa kani. ");
INSERT INTO inb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Samus­paka, nuka­pa anjil­kuna­ta­mi kacha­sa. Pai­kunaka, nuka agllaska runa­kuna sug kuchu sug ladu kuchu kai alpapi kas­ka­kunata, tukui­kuna­ta­mi tanda­chi­puan­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—Kai iuiai apin­ga­sina suma rimai­wa iachai­kui­chi. Imasa­mi igus sacha malki­kuna wiñaspa, panga­kuna ña susu­ri­ura, kam­kuna kawaspa, nin­gi­chi: “Ña­mi alli puncha­kuna chaia­mu­ku”: ");
INSERT INTO inb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","chasa­lla­ta kam­kuna, tukui chasa pasa­ri­na­kus­kata kawas­paka, ña­mi iachankan­gi­chi, nuka ña chaia­mu­kugta. ");
INSERT INTO inb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","—Kasami nuka nii­ki­chita: manara tukui kuna­ura kaug­sag­kuna wañug­pi­mi tukui chasa pasa­rin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sug luar i kai alpa luar puchuka­rigpi­pas, nuka ima nis­kaka mana ialin­gapa kanchu. ");
INSERT INTO inb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Ima puncha ima ura chasa tukug­samun­gapa kagta, mana pipas iachan­chi­chu. Ñi suma luar­manda anjil­kuna ñi Diuspa wam­brapas mana iachanchu. Nuka­pa Taita­lla­mi iachá. ");
INSERT INTO inb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chi­manda, sumag­lla iuiai­wa rigcha­raiag­sina kan­gi­chi. Kam­kuna­pas mana iachan­gi­chi­chu, ima ura nuka samun­gapa kagta. ");
INSERT INTO inb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Chi puncha chaian­gapa kagta kasa iuia­rin­tran­chi. Sug pa­trun, sug­sinama rin­gapa kaspa, wasi­manda llugsi­kuspa, paipa piun­kunata sug sug imasa chaias­ka­sina ruran­gapa sakirka. Shanz̈a­ta­pas iuia­chirka, rigcha­raias­pa­lla suia­kun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chi runa­kuna mana iachar­ka­kuna, patrun ima­ura kuti­mun­gapa kagta. Chasa­lla­ta­mi kam­kuna­pas mana iachan­gi­chi: ¿amsa­ia­ku­ura­chu chaia­musa, u chaugpi tuta, u gallu kanta­ura u tutata paka­ri­ku­ura? Chi­manda, iuiai­pilla kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¡Amalai puñu­riska kag­sinata shachig­samun­trani! ");
INSERT INTO inb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nuka ima kam­kunata niska, tukui­kuna­ta­mi nini: “Iuiaipilla kan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tanda mana liba­dura­wa miku­diru puncha­kuna ña chaia­ku­ura, paskua suti atun pun­cha­pa iskai punchalla pisi­ku­ura, chi puncha­kuna, iaia sasir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kunaka pai­pura rima­ri­na­kurka, Jesus­ta pakalla apispa wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iuia­rispa ni­na­kurka: —Kai atun puncha­kunaka, mana paita api­chi­sun­chi. Api­chig­pika, tukui runa­kuna, iachas­paka, nukan­chi­wa­mi rabia­rin­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús, Betania pui­blupi karka, Si­món suti runapa wasipi. Chi Si­món, aicha ismui ungui­wa ñugpata karka. Jesús mikuspa tia­ku­uraka, sug warmi chaiag­rirka. Chi warmi, nardo suti suma asna asiti iapa bali kulki­wa randispa, mar­mul rumi buti­lla­pi apas­pa­mi chaiag­rirka. Nis­paka, chi butilla kungata pakispa, Jesuspa umapi asitita tallirka. ");
INSERT INTO inb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Chasa kawas­paka sug­kuna, rabia­rispa, kasa­mi kikin­pura ni­na­kurka: —¿Imapatak chi suma asna asiti, ianga tallí? ");
INSERT INTO inb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Chita, kimsa patsa puncha ganaska ialigta bali kulki­manda katuspa, mana ñi ima­pas iukas­ka­kunata chi kulki­kunata karanga­pa­mi chaia­kurka—. Chasa rima­na­kuspa, chi warmita piñag­sina­mi ni­nakurka. ");
INSERT INTO inb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesuska nir­ka­kunata: —Ianga kawai­chi. ¿Imapatak kai warmita ni­na­kun­gi­chi, mana alli­lla ruragta? Paika, alli­lla­mi rura­warka. ");
INSERT INTO inb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ñi ima mana iukag­kunata ima­ura­pas­mi iukan­gapa kan­gi­chi. Kam­kuna pai­kunata suma ruran­gapa munagpi­kuna, pai­kunaka tianga­pag­lla­mi kan­kuna. Ikuti nukataka sug ratu­lla­mi kawa­wa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kai warmi, mailla pudis­kaka alli­lla­mi rurawá. Kai suma asiti­wa talli­was­kaka ni­raianmi nuka­pa kuir­pu wañus­kata pamban­gapa ña alli­chiska sakig­sina. ");
INSERT INTO inb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kasa­mi nuka nii­ki­chita: tukui alpapi, mai­pi­pas nuka­manda Alli Willaita willas­kapi, kai warmi ima rura­was­ka­ta­pas parlanga­pa­mi kan­kuna, pai­manda mana kunga­ris­pa­lla. ");
INSERT INTO inb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nigpika chunga iskai Jesús agllas­ka­kuna­manda Judas Iska­riote sutika, iaia sasir­duti­kuna­pag­ma rispa, nir­ka­kunata: —Jesusta api­chisa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chasa uias­paka, sumag­lla kun­tin­ta­rispa nir­ka­kuna: —Kulkimi kamta kara­sun­chi—. Chi­ura­mandaka, Judas maskai kalla­rirka, imasa Jesusta api­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tanda mana liba­dura­wa miku­diru kalla­rii puncha chaiarka; chi­ura­lla­tata paskua ubija wañu­chispa mikun­gapa. Chi punchaka, Jesusta kati­raiag­kuna paita tapur­ka­kuna: —Paskua punchapa mikui kam mikun­ga­pa, ¿maipitak munangi, nukan­chi alli­chig­rin­gapa? ");
INSERT INTO inb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Chi­ura Jesuska, iskai paita kati­raiag­kunata kacharka, kasa nispa: —Rii­chi Jeru­salén pui­bluma. Chi­pi chaiag­ri­uraka, sug runa iaku wab­kana­wa­mi tupanga. Paita kati­chin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chi runa sug wasi­ma chaiag­ris­kapika, chi wasi­iug­ta nig­rin­gi­chi: “Nukan­chita iacha­chig taita­mi kachamú, kamta tapun­gapa: ‘¿Mai­kan uku ladutak nuka­pa purig­kuna­wa paskua mikun­gapa kani?’.” ");
INSERT INTO inb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chi­ura chi runaka, awapi sug atun uku tukui ima minis­tis­ka­kuna­wa tim alli­chis­ka­ta­mi kawa­chin­gapa ka. Nukan­chi mikun­ga­pa, chipi alli­chin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Chi kachai tukus­ka­kuna Jeru­salén pui­bluma chaiag­ri­uraka, tukui imasa Jesús nis­ka­sina alli­lla tukug­samurka. Chi­pi­mi alli­chir­ka­kuna, paskua mikun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ña tutaia­uraka, Jesús paipa chunga iskai agllaska runa­kuna­wanta chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tukui­kuna mikuspa tia­na­ku­ura, Jesuska nir­ka­kunata: —Kasami nuka nii­ki­chita: kam­kuna nuka­wa miku­nakus­ka­manda, sugmi api­chi­wan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Chasa uiaspa, iapa llaki­rir­ka­kuna. Nis­paka tukui­kuna, sug sug­lla tapui kalla­rir­ka­kuna: —¿Nukachu api­chin­gapa kaiki? ");
INSERT INTO inb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesuska ainir­ka­kunata: —Kam chunga iskai­kuna­manda, kai platupi nuka­wa tanda maki­wa juku­chispa miku­nakug­manda sugmi api­chi­wan­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Imasa­mi ñug­pa­manda­ta willa­raiá: chasa­lla­ta­mi kai Runa Tukus­kata pasa­ri­wan­ga­pa ka. Chasa kagpi­pas, ¡ai, chi runa api­chi­wag! Chasapaka, chi runa mana tiag­samunmi. ");
INSERT INTO inb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chara miku­nakun­kama Jesús, tandata makipi chari­rispa, “Pai Siñur” Taita Diusta nirka. Tanda­ta piti­chispa, pai­kunata kuaspa, kasa­mi nirka: —Chaski­wai­chi. Kai, nuka­pa kuir­pu­mi ka. ");
INSERT INTO inb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nis­paka, sug binu kupata maki­pi chari­rispa, “Pai Siñur” Taita Diusta nispa, pai­kunata kuarka. Chi­ura, tukui­kuna­mi upiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Upia­na­kun­kama, Jesuska nir­ka­kunata: —Kai, nuka­pa iawar­mi ka, Taita Dius­wa i runa­kuna­wa ikuti pasin­sia­chi­rispa sumag­lla tukun­ga­pa. Achka­kuna­manda­mi chi iawar llugsispa icha­rin­gapa ka. ");
INSERT INTO inb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kasa­mi nuka nii­ki­chita: ubas iaku mana mas upian­gapa ka­nichu, ima­ura Diuspa suma mandai puncha chaian­kama. ");
INSERT INTO inb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mikuska­ura­manda, kan­tas­paka, Olivos lumama rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chipi, Jesuska nir­ka­kunata: —Kasami ñugpa­manda librupi willa­raiá: “Ubija kawag­ta­mi wañu­chisa. Chi­ura paipa ubija­kuna, kasa­ma chasa­ma­mi miti­kun­gapa kan­kuna”. Chasa­lla­ta­mi kam­kuna, saki­waspa, miti­kun­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nuka, wañuspa kaugsa­ris­paka, Gali­lea alpa­pi­mi ñugpa kag­risa. Chi­pi­mi kawa­risa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Chi­ura, Pedroka nirka: —Kamta tukui­kuna sakigpi­pas, nukakar mani­ma. ");
INSERT INTO inb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesuska nirka: —Kasami nuka niiki: kai tuta, gallu manara iskai biaji kantag­pi­mi kamka kimsa biaji nuka­manda nin­ga­pa kangi: “Paita mana rigsi­ni­chu”. ");
INSERT INTO inb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedroka, mas sin­chi nirka: —Kamwa wañun­gapa chaia­wagpi­pas, ñi ima­ura­pas mana chasa nin­gapa ka­nichu. Tukui­kuna, chasa­lla­ta nir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jetsemaní suti wirtapi chaiag­ris­paka, Jesuska kati­raiag­kunata nirka: —Kai­lla­pi tia­na­kui­chi, nuka Taita Diusta mañaspa rimag­rin­kama. ");
INSERT INTO inb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chasa nispa, Pedro, Santiago i Juanta pusaspa, mas karuajma rirka. Chipika, iapa llakii irkiaimi tukurka. ");
INSERT INTO inb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nis­paka, chi kimsandi­kunata nirka: —Nukata iapa llakii wañun­ga­sina­mi iuia­chi­wa­ku. Kam­kuna kai­lla­pi suia­wai­chi, mana puñu­ris­pa­lla. ");
INSERT INTO inb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Chasa nis­paka, mas ñugpa­sina­ma rispa, kungu­rirka. Alpama tupagta kumu­rispa, Taita Diusta mañai kalla­rirka, kasa nispa: —Alli kagpika, ¿mana­chu pudi­rin­tra, kai llakiita anchu­chi­wan­gapa?—. ");
INSERT INTO inb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kasa­pas­mi ni­kurka— Kam Tai­tiku, tukuimi pudingi. Kai iapa llakiita anchu­chi­wai. Nuka chasa muna­kug­pi­pas, nuka imasa munas­ka­sina mana tuku­chu. Kam imasa munas­ka­sina rurai. ");
INSERT INTO inb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chasa nispa, chi kimsandi­kuna­pagma kutis­paka, puñu­na­kus­kata tarig­rispa, Simón Pe­dro­ta nirka: —¿Imapatak puñu­rir­kangi? ¿Mana­chu ñi sug ratu­lla­pas rigcha­ra­ian­gapa pudir­kangi? ");
INSERT INTO inb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mana puñu­ris­pa­lla, Taita Diusta maña­na­kui­chi, tukui mana alli­lla rurai­kuna kam­kunata mana chaiachu. Sungu­pi alli­lla ruran­gapa muna­na­kuspa­pas, kuir­pupika iapa samba­mi kan­gi­chi. Chi­wa­mi mana pudin­gi­chi, alli­lla ruran­gapa. ");
INSERT INTO inb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chasa nis­paka, ikuti rispa, Taita Diusta imasa­mi ñugpata maña­kurka: chasa­lla­ta­mi parisma mañarka. ");
INSERT INTO inb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sug ratuma ikuti pai­kuna­pagma kuti­ura, puñu­na­kus­ka­ta tarig­rirka. Pai­kunapa ñawi, di­puñui wañu­na­kurka. Chi­manda, pai­kunata ni­ura, mana iachar­ka­kuna ima aininga. ");
INSERT INTO inb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Chasa­lla­ta ña kimsama Taita Diusta maña­kug­rispa, pai­kuna­pag­ma kutispa, Jesuska nir­ka­kunata: —Kuna­ura sama­rii­chi, puñui­chi—. Nis­paka, chi­ura­lla nirka— Chilla. Nuka­pa ura chaiar­kami. Kai Runa Tukuska, mana alli­lla rurag runa­kunapa maki­pi­mi ña urmarka. ");
INSERT INTO inb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Atarii­chi. Akushi. Api­chi­wag runa, ña­mi kailla­iamu­ku. ");
INSERT INTO inb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús chasa rima­kug­lla­pi, Judas­ka chipi chaiag­rirka. Chi runa, Jesuspa chunga iskai agllas­ka­kuna­manda­mi karka. Chi runa­waka achka­kuna­mi chaiag­rir­ka­kuna, ispada i garuti­kuna cha­rispa. Pai­kunaka, iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug judíu taita­kuna kachas­ka­kuna­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Chi Judas, manara ris­pa­lla, willaska karka, kasa nispa: “Mai­kanta nuka muchasa; chi­mi ka. Chita apispa, suma wataspa apan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Imasa nis­ka­sina chaiag­ringa­lla­wa, Jesus­pagma kailla­iaspa, nirka: —Puangi, iacha­chig taita—. Chasa nis­paka, paita mucharka. ");
INSERT INTO inb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Chasa mucha­ura, Jesusta apir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Chasa kawas­paka, sug Jesus­wa kag­pura, ispada surkuspa, iaia sasir­dutipa lutrinta piaspa, sug rinri ialigta kuchurka. ");
INSERT INTO inb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chi­kama Jesuska, Judas­wa ris­ka­kunata tapurka: —¿Imapatak nukata, sisaita­sina ispada i garuti kaspi­kuna­wa api­wan­gapa samu­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tukui puncha­kuna­mi nuka, kam­kuna­pa chaugpipi, Diuspa atun wasi uku­pi iacha­chispa kar­kani. Chipika, ¿ima­pa­tak mana api­war­kan­gi­chi? Nig­pika iukar­kami, tukui kasa pasa­ringa, ñugpa­manda librupi willa­raias­ka­sina tukug­samun­gapa. ");
INSERT INTO inb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chi­ura Jesus­wa tukui kag­kuna, pai­lla­ta sakispa, miti­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesusta apa­na­ku­ura, sug musuka, suglla katanga kata­rispa, kati­chi­kurka. Pai­ta­pas api­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Paika, katangata sitaspa, llatan­mi miti­kurka. ");
INSERT INTO inb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesusta apis­paka, chi runa­kuna iaia sasir­dutipa wasima chaia­chig­rir­ka­kuna. Iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas, tukui­kuna­mi chipi tanda­riska kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedroka, karu karu­lla­pi kati­chispa, chi wasi kancha­kama chaiag­rirka. Nis­paka, iai­kuspa, chi wasi kawag runa­kuna­wa tia­rig­rirka, nina kunuspa. ");
INSERT INTO inb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iaia sasir­duti­kuna i tukui judíu taita­kuna­pas maska­na­kurka, pipas willan­tra, ima panda­riipas Jesús iukagta; chasaka, paita wañu­chin­gapa pudin­gapa. Chasa maska­na­kuspa­pas, mani­ma tarir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Achka­kuna, pai­manda llullaspa willa­na­kurka. Nig­pika, kikin­pura sug rigcha sug rigcha ni­na­kuspa, mana iacha­rirka, mai­kan mana alli­lla kagta. ");
INSERT INTO inb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ikuti sug­kunaka, saia­rispa, Jesus­manda llullaspa, kasa nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Kasa nis­katami uiar­kan­chi: “Kai Diuspa wasi runa­kuna ruras­kata, nuka­mi puchukan­gapa kani. Nis­paka, kimsa puncha­lla­pi­mi sug wasi runa­kuna mana saia­chis­ka­sina saia­chin­gapa kani”. ");
INSERT INTO inb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chi runa­kuna chasa rima­na­kuspa­pas, ikuti pai­pura sug rigcha sug rigcha ni­nakus­paka, ñi imapi mana alli­lla tukurka. ");
INSERT INTO inb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Chi­ura­manda iaia sasir­duti, chaugpipi saia­rispa, Jesusta tapu­chirka: —Kam­manda mana alli­lla rima­na­kus­kataka, ¿imapatak mana ainingi? ");
INSERT INTO inb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesuska, upalla­mi karka, mana ima­pas ainis­pa­lla. Ikuti chi iaia sasir­dutika, paita tapu­chirka: —Nigpi, ¿kamchu kangi Cristo suti iapa suma atun Taita Diuspa wam­bra? ");
INSERT INTO inb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chi­ura, Jesuska ainirka: —Ari, nukami kani. Kai Runa Tukus­kata kawa­wanga­pa­mi kan­gi­chi, tukui mandu­iug Taita Diuspa alli ladu tia­kugta. Suma luar­manda puiu­kunapi samu­kug­ta­pas­mi kawa­wan­gapa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Chasa uiaspa chi iaia sasir­dutika, iapa rabia­rispa, kikin­pa katangata lliki­chi­rirka, kasa nispa: —¿Imapatak sug­kunata suia­na­ku­sun­chi, pai­manda ima­pas willan­gapa? ");
INSERT INTO inb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ña­mi nukan­chi kikin uiar­kan­chi, imasa Taita Dius­sina tukuspa willa­rigta. Kam­kuna, ¿ima­tak nin­gi­chi? Chi­ura tukui chi taita­kuna, Jesus­manda ainir­ka­kuna: —Paita wañu­chiimi chaiá. ");
INSERT INTO inb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Chi­ura­lla sug­kuna, Jesusta tukas­pa, paipa ñawita kilpaspa, puñi­tiaspa rurar­ka­kuna, kasa nispa: —Willamui: ¿pitak kamta piarka?—. Nis­paka, Jesús mana miti­kun­gapa kawag­kuna­pas chasa­lla­ta piaspa charir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Chi­kama Pedroka, chi wasi ura ladu kancha­lla­pi­mi karka. Chi­ura iaia sasir­duti­pagpi sug kawag war­mi, Pedro­pagma kailla­iarka. ");
INSERT INTO inb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chi warmika, paita nina kunu­kus­kata kawaspa, ikuti alli­lla kawaspa, tapurka: —¿Mana­chu kampas, chi Naza­ret­manda Jesus­wa puri­kur­kangi? ");
INSERT INTO inb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedroka, chasa uiaspa, ainirka: —Manima iacha­nichu, kam ima­manda chasa rima­kugta. Chasa ainis­paka, kancha ladu, iai­ku­diru atun punguma llugsirka. Chasa kag­lla­pi, gallu kantarka. ");
INSERT INTO inb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Chi warmika, Pedrota ikuti chipi kawaspa, chipi kag­kunata nii kalla­rirka: —Kai runapasmi pai­pura ka. ");
INSERT INTO inb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedroka, ikuti chasa uiaspa, ai­nirka: —Manima. Ikuti sug ratu­lla­pi, chipi kag­kuna­pas Pedrota nir­ka­kuna: —Kampas, sutipami chi runa­pura kangi. Gali­lea alpa­manda­mi kangi. ");
INSERT INTO inb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Chi­ura Pedroka, kikin­manda mana suma rima­rispa, nii kalla­rirka: —Nukaka, Diuspa ñawipi sutipa­mi nii­ki­chita, mana llu­llas­pa­lla. Nukaka, chi kam­kuna rima­na­kus­ka­manda runata mana rigsi­nichu. ");
INSERT INTO inb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedro chasa nig­lla­pika, gallu ikuti kantarka. Chi­ura iuia­rig­samurka, imasa Jesús kikin Pedrota nigta: “Gallu manara iskai biaji kan­tag­pi­mi kamka kimsa biaji nuka­manda nin­gapa kangi: ‘Paita mana rigsi­nichu’.” Chasa iuia­rig­samus­paka, iapa llaki­rispa, wakai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Paka­riska kag­lla­pi, iaia sasir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kuna, tukui judíu taita­kuna­wa ikuti tanda­rir­ka­kuna. Nis­paka, Jesusta wataspa, Pila­tos suti mandag­pagma chaia­chig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chi­ura Pilatoska, Jesusta tapu­chii kalla­rirka: —Kam, ¿judiu­kunapa atun mandagchu kangi? Chi­ura, Jesús ainirka: —Sutipami kam chasa nir­kangi. ");
INSERT INTO inb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chi­uraka iaia sasir­duti­kuna, Jesus­manda achka mana alli­lla ruragta nispa jucha­chi­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pila­toska, ikuti Jesusta tapu­chirka: —¿Imapatak mana ima­pas ai­ningi? ¿Mana­chu uia­kungi, kam achka mana alli­lla ruras­ka­kunata willa­wa­na­kugpi­pas? ");
INSERT INTO inb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesuska, ñi ima­pas mana ai­nirka. Chi­manda Pilatos, iapa ujna­rispa kawarka. ");
INSERT INTO inb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wata watapi atun puncha chaia­ura, Pilatos iacharka, sug karsilpi kas­kata runa­kuna mañas­kata kacha­ringa. ");
INSERT INTO inb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chi puncha­kuna, Barra­bás suti runa­mi karsilpi wich­ka­raiarka. Chi runa kar­kami mandag­kunata wañu­chispa puchu­kan­gapa kag­kunapa iaia. ");
INSERT INTO inb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nig­pika sug runa­kuna, Pilatos­pag­ma chaiag­rispa, paita mañai kalla­rir­ka­kuna: —Kam imasami iachangi kacha­ringa: chasa­lla­ta kuna­ura­pas sug runata kacha­rii. ");
INSERT INTO inb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatoska tapur­ka­kunata: —¿Muna­na­kun­gichichu, judiu­kunapa atun mandagta nuka kacha­rin­gapa?—. ");
INSERT INTO inb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatos alli­lla­mi iacharka, iaia sasir­duti­kuna, ianga Jesusta mana munaspa, wañu­chin­gapa muna­na­kugta. Chi­manda­mi chasa chipi kag­kunata tapurka. ");
INSERT INTO inb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iaia sasir­duti­kunaka, chipi kag­kuna­wa chapu­rispa chapu­rispa rir­ka­kuna, kasa nispa: —Mañai­chi, Barra­basta kacha­richu. ");
INSERT INTO inb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pai­kuna chasa maña­ura, Pila­toska ikuti tapur­ka­kunata: —Nigpika, ¿imatak muna­na­kun­gi­chi, kai runata kam­kuna judiu­kunapa atun mandag suti­chis­kata nuka ruran­gapa? ");
INSERT INTO inb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pai­kunaka, kapa­rispa ai­nir­ka­kuna: —Kruspi churaspa wañu­chii. ");
INSERT INTO inb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatos tapur­ka­kunata: —Kam­kunataka, ¿imapitak kawarí, mana alli­lla ruraska kagta? Pai­kunaka, mas sin­chi kapa­rispa, ikuti nir­ka­kuna: —Kruspi churaspa wañu­chii. ");
INSERT INTO inb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Chi­ura Pilatos, pai­kunata alli iuia­chii­wa sakin­ga­pa, Barra­basta kacha­rirka. Jesustakar mana llakis­pa­lla iapa asuti­chirka. Nis­paka, suldadu­kunapa makipi sakirka, pai­kuna kruspi klabaspa wañu­chin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Chi­ura chi suldadu­kunaka, Jesus­ta chi mandagpa wasi kancha­malla pusar­ka­kuna. (Chi wasi, “pretorio” suti ka.) Chipika, tukui suldadu­kuna tanda­chi­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nis­paka, Jesusta sutipa mandag­sina kawa­rin­ga­pa, puka katanga kata­chir­ka­kuna. Ispina­kuna­lla llaugtu simbaspa, paita umapi chura­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chura­chis­paka, paita kamispa, nii kalla­rir­ka­kuna: —Puangi, kam judiu­kunapa atun mandag. ¿Alli­lla­chu ka­puan­gi?—. ");
INSERT INTO inb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chasa ni­na­kus­paka, paita umapi pukunga­wa piaspa, tukaspa richir­ka­kuna. Chasa­lla­ta, mucha­na­kug­sina, ñugpa ladu kungu­rispa kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Paita chasa asiska­ura­mandaka, puka katangata surkuspa, ikuti kikinpata chura­chir­ka­kuna. Chi wasi­mandaka Jesusta llugsi­chir­ka­kuna, paita kruspi klabag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ri­na­kus­kapika, Sirene pui­blu­manda Simón suti runa ñambi­pi tuparka. Chi Simón, Ale­jan­dro i Rufopa taita karka. Paika, chagra­manda­mi chaia­mu­kurka. Paitaka, Jesús markaspa apa­kuska krusta marka­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota suti pamba­ma­mi Jesusta chaia­chig­rir­ka­kuna. (Chi Gól­gota ni­raianmi: “Uma Tullu pamba”.) ");
INSERT INTO inb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chipika, mira kupal cha­puska binu paita kara­na­kurka. Paika, chita mana upian­gapa munarka. ");
INSERT INTO inb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nis­paka, paita kruspi klabar­ka­kuna. Jesuspa katan­ga­kuna­taka, suldadu­kuna suirtipi pugllar­ka­kuna, iachan­gapa: imasa­mi chaiá, pai­pura sug sug apan­gapa. ");
INSERT INTO inb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chaugpi tutatami Jesusta kruspi klabar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Krus uma awa ladu, sug willa­raias­ka­mi churar­ka­kuna, kawaspa, ima­manda wañu­chii tuku­kugta iachan­gapa. Chi­pi, kasa­mi ni­raiarka: “Judiu­kuna­pa atun mandag­mi ka”. ");
INSERT INTO inb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chi­lla­pita, iskai sisai­kunata krus­pi klabaspa saia­chir­ka­kuna: sug­taka Jesuspa alli ladu, sugtaka paipa lluki ladu.  ");
INSERT INTO inb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chasa­wa­mi ñugpa­manda librupi imasa willa­ra­ias­ka­sina tukug­samurka. Chi­pika, kasa­mi ni­raiarka: “Paipas, jiru rurag­kuna­wa sug­lla­pi­mi kawa­rirka”. ");
INSERT INTO inb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chipi iali­na­kug, Jesusta kawas­paka, uma kaima chima chabsi­chi­rispa kami­na­kurka, kasa nispa: —Ajaa, wanai. Kam­sina ningi, Dius­pa atun wasita lim waglli­chispa, ikuti kimsa puncha­lla­pi saia­chin­gapa; ");
INSERT INTO inb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kuna­ura kam kikin kispi­chi­rii. Krus­manda urai­kui. ");
INSERT INTO inb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chasa­lla­ta iaia sasir­duti­kuna­pas, Moisés ima nis­kata iacha­chig taita­kuna­wa Jesusta iapa unz̈aspa ni­na­kurka: —Chiins, sug­kunata kispi­chig­samurkasi. Nig­pika, pai kikinka mana pudí kispi­chi­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo suti Israel­manda runa­kunapa atun mandag, kuna­uraka krus­manda kam kikinlla urai­kui. Chasa kawas­pa­mi kam­manda suma iuia­ri­sun­chi. Jesuswa sug­lla­pi kruspi kag­kuna­pas, paita kami­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ña chaugpuncha tukuska­ura­manda chaugpi chisi­kama, tukui alpa lim tutaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chaugpi chisi ka­ura, Jesuska sin­chi kapa­rii­wa kapa­rirka, kasa nispa: —Elí, Elí, ¿lema sabaktani?—. Chi ni­raianmi: “Nuka­pa Dius, nuka­pa Dius, ¿imapatak nukata sapa­lla saki­wangi?”. ");
INSERT INTO inb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chasa uias­paka, chipi saia­na­kug­pura ni­na­kurka: —Uiamui. Elías suti ñugpa­manda willag­ta­mi kaia­ku. ");
INSERT INTO inb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Chasa iuia­ris­paka, sug pai­pura saia­na­kus­ka­manda kalparka. Winja binuta ispunja­wa juku­chispa, chaglla puntapi churarka, Jesuspa simima atari­chispa, chupa­chin­gapa. —Kawa­sun­chi— nirka—, ¿sutipa­chu Elías samú, paita urai­ku­chin­gapa? ");
INSERT INTO inb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesuska, sin­chi kapa­rispa, wañurka. ");
INSERT INTO inb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wañug­lla­pi, Diuspa atun wasi ukupi atun linsu arka­ra­iaska, awa­nig­manda ura ladu­kama chaugpi chaugpi­mi lliki­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesuspa ñawi ladu kapi­tan saia­kugka, Jesusta imasa wañugta kawas­paka, nirka: —Kai runa, sutipa­mi Taita Dius­pa wam­bra karka. ");
INSERT INTO inb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sug warmi­kunapasmi chipi kar­ka­kuna, karu­manda­lla kawas­pa. Pai­pura kar­ka­kuna­mi María Magdalena, Salomé i sug María sutipas; chi María, kati San­tiago i Josepa mama. ");
INSERT INTO inb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Pai­kuna kar­ka­kuna­mi Gali­lea alpa suiu Jesus­ta sug­lla­pi kati­raiag­kuna, paita ima­pi­pas aidaspa. Achka sug warmi­kuna­pas, Jesus­wa Jeru­sa­lenma Gali­lea­manda rispa, pai­kuna­wa sug­lla­pi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Warda punchapa tukui suma alli­chi­diru puncha ña chisiarka. Kaiandika, warda puncha paka­ri­kurka. ");
INSERT INTO inb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chi­manda Ari­ma­tea pui­blu­manda José suti runaka, Pilatos­pagma rirka. Chi runa, judíu mandag­kuna­pura atun taita­mi karka. Paika, Diuspa suma mandai chaia­mun­gapa punchata suia­kurka. Pilatos­pagma ris­paka, mana manchas­pa­lla iai­kug­rispa, Jesus­pa kuir­puta mañarka. ");
INSERT INTO inb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pila­toska, Jesus­manda ujna­ris­pa­mi uiarka, ña wañuska kagta nig­manda. Nis­paka, chi kapi­tanta kaiaspa, tapu­chirka: —¿Sutipachu Jesús ña wañuska ka? ");
INSERT INTO inb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sutipa kagta iachas­paka, Jose­ta: —Imasa maña­kus­ka­sina, chasa rurai— nirka. ");
INSERT INTO inb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Chi­ura Jose­ka, suma linsu randispa, Jesusta krus­manda urai­ku­chig­rirka. Nis­paka, suma linsu­wa maituspa, murtajarka. Sug rumi piña­pi atun utku­chis­ka­pi­mi Jesuspa kuir­puta churag­rir­ka­kuna. Nis­paka, utku punguta sug atun rumi­wa wich­kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Mag­da­lena i Josepa mama Maria­pas kawar­ka­kuna, maipi Jesuspa kuir­puta churag­rigta­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judiu­kunapa warda pun­cha ña ialiska ka­ura, María Magdalena, Santiagopa maman­di María i Salomé, suma asna iaku randir­ka­kuna, Jesuspa kuir­pupi tallig­rin­gapa. ");
INSERT INTO inb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nis­paka, simana kalla­rii puncha u dumingu iapa tutata, indi ña llugsig­lla­pi, Jesús pamba­raiaska­ma rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ñam­bi­pi, kikin­pura tapu­ri­na­kurka: —Chi atun utku­chiska pungupi kilpa­raiaska rumita, ¿pisik anchu­chinga, nukan­chi iai­kun­gapa? ");
INSERT INTO inb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Chaiag­rispa kawa­uraka, chi kilpa­raiaska iapa atun rumi tim anchu­chis­ka­mi karka. ");
INSERT INTO inb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ukuma iai­kug­ri­uraka, alli ladu kawa­rir­ka­kuna­ta sug musu iura katanga chura­riska tia­kugta. Chasa kawas­paka, chi warmi­kuna iapa mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Chi musuka nirka: —Mana mancha­na­kui­chi. Naza­ret­manda Jesús kruspi wañus­ka­ta­mi maska­na­kun­gi­chi. Paika kaugsa­rir­kami. Kaipi mana kanchu. Pai churaska kas­kata kawai­chi. ");
INSERT INTO inb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kuna­uraka, paita kati­ra­iag­kunata Pedro­wan­ta willag­rii­chi: “Pai Jesús, ñugpa­mi Gali­lea alpama rin­gapa ka. Chi­pi­mi kawa­na­kun­gapa kan­gi­chi; imasa­mi kam­kunata ñugpa willaska karka: chasa”. ");
INSERT INTO inb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Chi warmi­kunaka, chasa kawaspa i uiaspa, iapa mancha­rispa chugchuspa, chi­manda llugsispa miti­kur­ka­kuna. Dimanchai ñi pi­ta­pas mana willag­rir­ka­kuna.  ");
INSERT INTO inb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chi simana kalla­rii puncha u dumingu paka­ri­ura, Jesuska kaugsa­rirka. Kaugsa­ris­paka, ñugpa María Magdalena­ta­mi kawa­rirka. Chi warmi­ta­mi kan­chis kuku waira­kunata Jesús llugsi­chiska karka. ");
INSERT INTO inb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chi warmika, Jesusta kawaspa, pai­wa sug­lla­pi purig­kunata willan­ga­pa rirka. Pai­kuna, Jesus­manda llakispa wakaspa tia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pai­kunata willag­rirka, kasa nispa: —Jesús kaug­satami kawar­ka­ni—. Pai­kunaka mana munar­ka­kuna, chasa kagta uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chi­ura­manda Jesuska, iskai runa­kunata kawa­rirka, mana rigsiska runa­sina tukuspa. Chi iskai­kunaka, kikin­kunapa wasima ñambimi ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chipi Jesus­ta kawas­paka, Jeru­salenma kutir­ka­kuna, sug­kunata willan­ga­pa. Chasa uiaspa­pas, ikuti mana munar­ka­kuna, chasa kagta uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chi­ura­manda, chunga sug pai agllaska runa­kuna mikuspa tia­na­ku­ura, Jesuska kawa­rig­samur­ka­kunata. Pai­kuna mana pai­manda suma iuias­ka­manda, piñaspa nir­ka­kunata: —Nuka kaugsaris­kata kawa­wag­kuna kam­kunata willag­pi­pas, ¿imapatak mana uiar­kan­gi­chi? ¿Imapatak, chi­tuku ni­na­kus­ka­ta uiaspa­pas, kam­kuna­pa uma upa tukus­ka­sina kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús, kasa nis­pa­mi kachar­ka­kunata: —Kai alpapi tukui kaug­sa­na­kus­kata nuka­manda Alli Willaita rimaspa purig­rii­chi. ");
INSERT INTO inb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chi nuka­manda Alli Willai­wa suma iuia­rig­kunaka, baug­ti­sa­rispa, kispi­ringa­pa­mi kan­kuna. Ikuti mana uiag­kunaka, dil­tudupa nina­ma­mi kachai tukun­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Chi nuka­manda Alli Wi­llai­wa suma iuiag­kunaka, kasa­mi kawa­chin­gapa kan­kuna: nuka­pa suti­wa­mi kuku waira­kunata llugsi­chin­gapa kan­kuna. Mana iachaska rimai­kuna­wa­mi riman­gapa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Maki­wa kulibrata apig­pi­pas u ima wañu­diruta upiag­pi­pas, mana ima­pas tukun­ga­pa kanchu. Ungug­kunata maki churag­pika, ambi­rig­samunga­pa­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iaia Jesús chasa rimas­paka, suma luarma sikai kalla­rirka. Suma luarpi chaiag­ris­paka, Taita Diuspa alli ladu tia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pai agllaska runa­kunaka, Jeru­salen­manda llugsispa, tukui alpapi Alli Willaita rimaspa purii kalla­rir­ka­kuna. Iaia Jesús kikinmi suma luar­manda pai­kunata aidamu­kurka. Pai­kunata iachai kara­murka, mana ima­ura­pas kawas­ka­sina ruran­gapa; chasaka, pai­kuna ima rimas­ka­kunaka sutipa kagta kawa­chin­gapa.");
INSERT INTO inb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nuka­pa kuiaska Teófilo: Achka runa­kunami iuia­rir­ka­kuna, tukui ima nukan­chipa alpapi pasa­ris­kata iskribispa willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chasa ñugpa­manda­ta kawaspa willag­kuna­mi nukan­chita iacha­chir­ka­kuna. Pai­kunaka, Dius­pa Suma Rimaita willag­kuna­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nuka­pas, tukui chi­kuna­manda ñugpa­manda­ta suma tapu­durmi karkani. Chi­manda­mi suma iuia­riwá, kamta suiu­manda­ta iskribispa willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Chasaka, alli­lla­mi iachankangi, kamta ima iacha­chiska sutipa kagta. ");
INSERT INTO inb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes suti Judea alpapi atun mandag ka­ura, Zakarías suti judíu sasir­duti chipi kaug­sa­kurka. Sug sasir­duti­kuna­manda paika, Abía suti sasir­duti­kuna­pura­mi karka. Paipa warmi, Isabel suti, Aarón suti sasir­duti­purapa wam­brapa wam­bra­mi karka. ");
INSERT INTO inb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pai­kuna, Dius­pa ñawi­pi alli­lla iuiai­wa kawa­ri­mi kar­ka­kuna. Atun Taita Dius ima ruran­ga­pa nis­kata tukuimi alli­lla rura­dur kar­ka­kuna. Chasapika, ñi pipas mana pudir­ka­kuna­chu, ñi ima­pas ninga. ");
INSERT INTO inb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isabel chusa kaspa, mana wawita iukar­ka­kuna. Iskan­di­kuna­mi ña ruku kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Chi puncha­kuna, Zaka­riasta chaiarka, pai­pura sasir­duti­kuna­wa Dius­pa atun wasipi imasa ni­raiaska­sina rurag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pai­kuna kustum­bri iukar­ka­kuna, suir­ti­pi maskan­ga­pa: pita­mi chaiá, Taita Dius­pa atun wasi ukuma iai­kuspa, insinsu rupa­chispa kusni­chin­ga­pa. Chi­ura, Zaka­rias­ta­mi chaiarka, chi ukuma iaikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pai insinsu rupa­chi­kun­kama, tukui kanchapi kag­kuna Taita Diusta suma iuia­rispa­mi maña­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chi­uraka atun Taita Dius­pa sug anjil, Zaka­riasta kawa­rig­samurka. In­sin­su rupa­chi­diru altar alli ladumi saia­kurka. ");
INSERT INTO inb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anjilta kawas­paka, Zakarías iapa ujna­rispa mancha­rirka. ");
INSERT INTO inb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Chi­ura anjilka, paita nirka: —Mana mancha­ri­kui. Kam ima maña­kus­kata, Taita Dius uiar­kami. Chi­manda­mi kamba warmi Isabel, sug kari wam­bra iuka­pun­ga­pa kangi. Paitaka suti­chinkangimi Juan. ");
INSERT INTO inb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Paika, atun Taita Dius­pa ñawipi atun­mi kan­ga­pa ka. Chi­manda, pai tiag­samu­ura, iapa suma alli iuia­chii­wa­mi tukun­ga­pa kangi. Chasa­lla­ta, achka runa­kuna­pas­mi kun­tin­ta­rin­ga­pa kan­kuna. Binuta i ima macha­diru­ta­pas, pai mana upian­ga­pa kan­chu. Manara tiag­samuska­ura­manda­ta, Santu Ispí­ritu jundaska­mi kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Paimi Israel­manda achka runa­kunata atun Taita Dius­wa tigra­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nukan­chipa Iaia­ta­mi ñugpan­ga­pa ka. Elías suti San­tu Ispi­ri­tu­wa ñugpa rimag­sina­mi kan­ga­pa ka; chasa­lla­ta tukui alli­lla pudig. Paimi taita­kuna­wa wam­bra­kuna­wa piña­chi­ri­na­kus­kata pasin­sia­chin­ga­pa ka. Chasa­lla­ta, subirbiaspa mana uiai munag­kunata iuia­chinga­pa­mi ka, uia kan­ga­pa; chasaka, nukan­chipa Iaia samu­ura, runa­kuna suma iuiai­wa alli­chi­riska suia­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chi­ura Zakarías, anjilta tapurka: —¿Imasatak nuka iachasa, kam willa­waska sutipa kagta? Nuka­pa warmi i nuka­pas, iapa ruku­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anjilka ainirka: —Nukami kani Taita Dius­pa ñawi ladulla saia­kug. Gabrielmi suti kani. Pai­mi kacha­mu­warka, chi imasa suma tukun­ga­pa kagta kam­ta willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nuka ima willa­kus­kata kam mana uia­was­ka­manda, kuna­ura­mandaka mana rimai pudin­ga­pa kangichu, ima­ura wa­wita tiag­samun­kama. Nuka nis­kaka, chasa­mi tukunga, ima­ura chaian­kama. ");
INSERT INTO inb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pai­kuna chasa rima­na­kun­kama, kanchapi kag­kuna Zaka­riasta unai suia­na­kurka. Mana utka llugsig­manda mancha­rispa, tapu­ri­na­kurka: “¿Ima­wa­sik ukupi iapa unaia­ku?”. ");
INSERT INTO inb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chi­uraka Zaka­rías, llugsispa, mana rimai pu­dir­ka. Maki­lla­wa siñas ruraspa kawa­chi­kurka. Chi­ura iuia­rir­ka­kuna: paita sutipa­mi Dius­pa atun wasi ukupi muskui ukupi­sina ima kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Taita Dius­pa wasipi ima rurai­kuna chaias­kata ruras­paka, Zaka­rías paipa wasima kutirka. ");
INSERT INTO inb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chi­ura­mandaka paipa warmi Isa­belka, wigsa­wa ungug tukug­samurka. Paika, pichka killa mana wasi­manda llugsirka. Chi­lla­pi karka, kasa iuia­rispa: ");
INSERT INTO inb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kuna­ura, atun Taita Dius nukata chasa kara­wag­manda, mana mai­kan­pas wabuti­wan­ga­pa kan­kuna­chu”. ");
INSERT INTO inb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Isabel ña sugta killa wigsa­wa ungug ka­ura, Taita Diuska ikuti anjil Gabrielta kacha­murka María suti sipas­pagma. Pai warmi, Gali­lea alpa­manda Nazaret suti pui­blupi kaug­sa­kurka. Mana kari rigsiska karka, ña José suti kari­wa kasaran­ga­pa. José kar­kami David suti atun mandagpa wam­brapa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anjilka, María kas­kapi iai­kus­paka, nirka: —Puangi. Atun Taita Dius, kam­wa­mi ka. Paipa suma kuiaita chas­kiska­mi kangi. Kamka, tukui warmi­kuna­manda­pas masmi iapa kuiaska kangi. ");
INSERT INTO inb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Chasa uias­paka María, iapa man­cha­rirka. Iuia­ri­kurka: “¿Ima­pa­tak chasa saluda­wa­ku?”. ");
INSERT INTO inb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anjilka nirka: —María, mana mancha­ri­kui. Kamta, Taita Dius iapa suma kuiai­wa­mi kawá. ");
INSERT INTO inb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kuna­uraka, ungu­ringa­pa­mi kangi. Nis­paka, sug kari wam­brami iukan­ga­pa kangi. Paitaka suti­chinkangimi Jesús. ");
INSERT INTO inb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dius­pa ñawipi, paika iapa atun niska­mi kanga. Tukui­manda mas atun Taita Dius­pa wam­brami suti kanga. Atun Taita Diuska, paita kuanga­pa­mi ka, ñugpa­manda taita David­sina mandan­ga­pa; ");
INSERT INTO inb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chasa­lla­ta, Jakob­pa wam­brapa wam­bra­kunata tukui puncha­kuna manda­kunga­pag­lla. Paipa mandai­ka, mana ima­ura­pas puchu­ka­rin­ga­pa kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—Nukaka, manara kusa­iug ka­nichu— María anjilta ainirka—. Chi­manda, ¿imasatak chasa tuku­wanga? ");
INSERT INTO inb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chi­ura, anjilka ainirka: —Santu Ispi­ri­tumi kam kikinma urai­ku­munga. Tukui­manda mas atun Taita Dius­pa iapa iachai­wa puiu­sina­mi kamta kilpag­samunga. Chi­manda wawita tiag­samugka, tukuipi mas alli­mi kan­ga­pa ka. Taita Dius­pa wam­brami suti kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Willasaki. Kam kikin­pura Isa­bel­pas, ña achalaia­ku­ura, wawita­mi iukan­ga­pa ka. Pai­manda “Chusa” ni­na­kugpi­pas, ña sugta killa­mi wigsita­wa ungug ka. ");
INSERT INTO inb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Taita Dius­manda mana tian­chu ñi ima­pas pai mana pudinga­sina. ");
INSERT INTO inb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Chasa ni­ura, María ainirka: —Atun Taita Dius­pa lutrin­sina­mi nuka kani. Kam imasa ni­waska­sina tuku­wachu. Chi­ura anjil, Maria­pag­manda llugsispa rirka. ");
INSERT INTO inb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chi puncha­kuna­mandaka, Mariaka mana unailla rirka Judea sachuku sug pui­blu tiaska­ma. ");
INSERT INTO inb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chima chaiag­ris­paka, Zaka­riaspa wasima iai­kuspa, Isabelta nirka: —Puangi. ");
INSERT INTO inb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chasa nis­kata Isabel uia­ura, pai­pa wawitaka wigsa ukupi sin­chi kuiu­rig­samurka. Chi­ura Isabelta, Santu Ispí­ritu iai­kuspa iuia­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chi­wanka, sin­chi rimai­wa kasa­mi nirka: —Kamka, tukui warmi­kuna­manda­pas mas iapa kuiaska­mi kangi. Kamba wigsapi tiaska wawi­ta­pas­mi chasa­lla­ta iapa kuiaska ka. ");
INSERT INTO inb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nukaka, ¿imatak kani, chi­tuku suma nuka Iaiapa mama chaia­wag­samun­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kam “Puangi” ni­wag­lla­pi, nuka­pa wigsapi tiaska wa­wi­ta, alli iuia­chi­rispa­mi kuiu­ri­wag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kam, Taita Diusta suma iuia­kus­ka­manda­mi paipa iapa kuiaska kangi. Tukui imasa atun Taita Dius niska­sina­mi sutipa chasa tukug­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chi­ura, Mariaka nirka: —Nuka­pa alma­wa atun Taita Dius­ta­mi nini: “Kam, iapa atun­mi kangi”. ");
INSERT INTO inb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nuka­pa ispi­ri­tu­wa­pas­mi nini: “Taita Dius kispi­chi­wag­man­da, alli iuia­chi­mi kani”. ");
INSERT INTO inb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Paipa upalla lutrin­sina kag­manda­mi nukata iapa kuiaspa kawa­warka. Chi­manda­mi kuna­ura­manda­ta tukui kaug­sag­kuna, nukata suti­chi­wan­ga­pa kan­kuna, Taita Dius­pa iapa kuiaska kagta. ");
INSERT INTO inb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tukui alli­lla pudig Taita Dius, mana ima­ura­pas ruraska­sina­mi nukapi rurarka. Pai, tukuipi mas alli­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mai­kan paita suma kuiaspa manchaspa suma rurag­kuna­manda ima­ura­pas llakinga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pai tukui alli­lla pudig kag­ta­mi kawa­chirka. Tukui runa­kuna kikin atun­ia­chi­rispa mana alli iuiag kas­ka­kunata tuntia­chir­kami. ");
INSERT INTO inb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Atun mandag­kuna­ta­pas kikinpa mandadiru­manda­mi urai­ku­chir­ka­kunata. Ikuti uchulla mana atun kas­ka­kunataka atun mandadiru­pi­mi tia­ri­chirka. ");
INSERT INTO inb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iarkai­wa kas­ka­kunata sagsagta suma mikui­mi kararka. Ikuti iapa iukag­kunataka chusa maki­mi kacharka. ");
INSERT INTO inb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nukan­chi Israel­manda runa­kuna paipa lutrin kag­kuna­ta­mi aidarka. Paipa suma llakii­wa­mi nukan­chi­manda iuia­rirka. ");
INSERT INTO inb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Imasami nukan­chipa ñugpa­manda taita­kunata, Abra­hamta i paipa wam­brapa wam­bra­kunata ruran­ga­pa nirka: chasami kuna­ura rurag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kimsa killa­sina Isabelpa wasi­pi kaspa, María, kikinpa wasi­ma kutirka. ");
INSERT INTO inb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Isabelta ña puncha chaia­ura, sug kari wam­brami iukag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ladu­lla­pi kaug­sa­na­kug i pai­pura­kuna­pas uiaska kar­ka­kuna, imasa atun Taita Dius pai­kunata alli suma ruragta. Nis­paka, chaian­ga­pa rir­ka­kuna, wawita tias­ka­manda kun­tin­tulla kas­ka­kuna­wa sug ratu­lla­pas kag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pusag puncha­pika, ikuti chaiag­rir­ka­kuna, wawata judiu­kuna­pa marka chura­chin­ga­pa ka­ura. Muna­na­kur­kami, Zaka­rias­lla­tata taita­pa suti­sina suti­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Maman­dika nirka: —Manima. Juanmi suti kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chi­ura nir­ka­kuna: —¿Imapa? Kam­kuna­pura, mana tian­chu pipas chasa suti. ");
INSERT INTO inb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chasa nis­paka, paipa taitata siñas ruraspa, tapur­ka­kuna: —¿Imatak suti kanga? ");
INSERT INTO inb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chiura Zakariaska, sug kaspi tablilla mañaspa, iskribispa chu­rarka: —Juanmi suti ka. Chasa kawas­paka, tukui­kuna iapa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Chi­ura­lla­tata Zaka­riaspas, ikuti rimai pudirka. Nis­paka, Taita Diusta sumag­lla nii kalla­rirka: —Kam, iapa suma atun­mi kangi. ");
INSERT INTO inb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Chi­wa, tukui ladu­lla­pi kaug­sa­na­kug mancha­rir­ka­kuna. Judea sachuku suiupas, tukui ima pasa­ris­kata uiaspa, pai­pura rima­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atun Taita Dius sutipa pai­wa kag­manda, tukui uiag­kuna, iuia­rispa, tapu­ri­na­kurka: —Chi wam­bra, wiñas­paka, ¿ima­sik tukunga? ");
INSERT INTO inb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Juanpa taita Zaka­riasta, San­tu Ispí­ritu iaikug­samurka. Chi­wanka, imasa kan­ga­pa kas­kata kasa­mi nirka: ");
INSERT INTO inb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Nukan­chi Israel­manda runa­kunapa atun Taita Diusta ni­sun­chi: “Kam, iapa suma atun­mi kangi”. Paipa runa­kunata kispi­chin­ga­pa­mi samurka. ");
INSERT INTO inb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pai ima nis­kata rurag David­pa wam­brapa wam­bra­ta­mi kacha­murka, tukui alli­lla pudig kaspa, nukan­chita kispi­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chasami ñugpa­manda­ta paipa Ispi­ri­tu­wa alli runa­kunata rima­chirka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Tukui kam­kunata mana munag­kuna­manda i piñag­kuna­manda kispi­chisa­ki­chitami. ");
INSERT INTO inb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kam­kunapa ñugpa­manda­kunata niska­mi karkani, kam­kuna­manda llakin­ga­pa. Chasa­lla­ta, nuka ñugpa­manda runa­kuna­wa iuia­ris­kata mana kunga­ri­nichu”. ");
INSERT INTO inb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Imasami nukan­chipa ñugpa­manda taita Abra­hamta jurarka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Kam­kunata mana munag­kuna­manda kispi­chisa­ki­chitami; chasaka, mana manchaspa­lla, ");
INSERT INTO inb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tukuipi suma alli­lla iuiai iukaspa, Dius­pa ñawipi pai ima nis­kata ruran­ga­pa, kaug­san­kama”. ");
INSERT INTO inb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kam nuka­pa wawa, tukui­manda mas atun Taita Dius­pa Ispi­ri­tu­wa rimagmi suti kankangi. Nukan­chipa iaia­ta­mi ñugpankangi, kam ñambi alli­chis­kapi pai chaia­mun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Israel­manda runa­kuna­ta­mi iacha­chinkangi, imasa Taita Dius, panda­ris­ka­kunata pasin­siaspa, nukan­chita kispi­chin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nukan­chipa Taita Dius, paipa suma llakii­wa awa suma luar­manda punchaia­chin­ga­pa paka­riska suma puncha kag­sina­mi kacha­mu­ku; ");
INSERT INTO inb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chasaka, iapa iana tutapi­sina iuiai­kuna­wa kaug­sa­na­kus­kata punchaia­chig­samun­ga­pa; chasa­lla­ta, nukan­chita alli ñambi ri­kus­kapi pusag­sina iuia­chin­ga­pa; chasaka, sumag­lla sug­lla­pi kaug­sa­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Chi wawa, wiñas­paka, Taita Dius­pa alli iachai­wa­mi tukurka. Paika, chusa sitaska alpa­pi­mi kaug­sa­kurka, ima­ura Israel­manda runa­kunata kawa­rin­ga­pa chaian­kama. ");
INSERT INTO inb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chi puncha­kuna Augusto suti Romapi iaia mandag, paipa alpa­kuna suiu tukui kaug­sa­na­kuska­pagma kacharka, pai­kuna mai­tuku kaug­sa­na­kus­kata tapu­chig­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Musug­lla sinsu­mi rura­kurka, Siria suti alpapi Sire­nio manda­ku­ura. ");
INSERT INTO inb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tukui­kuna­mi iukar­ka­kuna, ñugpata taita­kuna kaug­saska­ma ringa, chipi pai­kuna mai­tuku kaug­sa­na­kuska willag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chi­wanka, Joseta chaiarka, Gali­lea alpa i Naza­ret pui­blu­manda llug­sispa, Judea alpama rin­ga­pa. Belén suti pui­bluma rirka, paipa ñugpa­manda taita David chipi tiag­samuska kag­manda. ");
INSERT INTO inb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María, Jose­wa kasa­ran­ga­pa kaspa, pai­wa rirka. María, wigsi­ta­wa­mi ungug karka. ");
INSERT INTO inb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belenma chaiag­ri­uraka, tiag­samun­ga­pa puncha chaiarka. ");
INSERT INTO inb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mana tarir­ka­kuna, mai­kan wasi­pipas sama­rin­ga­pa, iapa junda runa­kuna kag­manda. Chi­manda, animal­kunapa kaug­sa­diru ukupi iai­kur­ka­kuna. Chi ukupika, Maria­ka kari wam­brami iukag­samurka. Paitaka linsu piti­wa mai­tuspa, animal­kuna miku­diru batia­sina­pi siri­chirka. ");
INSERT INTO inb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén pui­blu kuchu kuchu, sug runa­kuna tuta ubija­kunata kawag paka­ri­dur tiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Diul­pi­lla­kar atun Taita Dius­pa sug anjil, Dius­pa suma puncha­ia­chii­wa pai­kunata kawa­rig­samurka. Chasa kawa­ri­ura, pai­kuna iapa man­cha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anjil­ka nir­ka­kunata: —Mana mancha­ri­na­kui­chi. Suma Willaimi apa­mu­kuni. Chi Willai­ta uias­paka, tukui runa­kuna­mi iapa kun­tin­ta­rin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kuna­ura­mi David tiag­samuska pui­blupi kam­kunata kispi­chig tiag­samurka. Taita Dius agllaska iaia Cristo­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kasa kawaspa­mi paita rigsin­kan­gi­chi: animal­kuna miku­diru batia­sina­pi linsu­wa mai­tuska wawita siri­kus­ka­ta­mi tarig­rinkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kawa­rig­samug anjil rima­kug­lla­pi, asku­rinti achka anjil­kuna kawa­rig­samur­ka­kuna. Taita Diusta iapa suma atun­ia­chispa, nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Taita Dius awa suma luarpi kag­ta­mi nin­chi: “Kam, iapa suma atun­mi kangi”. Alpapipas, Taita Diusta kuiag runa­kuna sumag­lla ka­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Samug anjil­kuna pai­kunapa suma luarma kuti­ura, chi ubija­kuna­ta kawag­kunaka pai­pura rima­rir­ka­kuna, kasa nispa: —Akushi Belenma. Atun Taita Dius imasa nukan­chita anjil­kuna­wa willan­ga­pa kacha­mus­kata kawag­ri­sun­chi. ");
INSERT INTO inb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Chi­ura­lla, Belén pui­bluma kalpalla rir­ka­kuna. Chaiag­ris­paka, Mariata, Joseta i wawita animal miku­diru batia­sinapi siri­kus­ka­ta­mi tarig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chasa kawas­paka, tukui ima anjil­kuna chi wawita­manda nis­ka­ta tukui­kuna­ta­mi willai apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tukui uiag­kuna­mi ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria­ka, tukui ima uias­ka­ta suma waka­chi­rirka, alli­lla iuia­rispa kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chi­ura­manda, chi ubija­kunata kawag­kuna kutir­ka­kuna. Tukui ima­sa willaska­sina pasa­rigta uiaspa i kawaspa, Taita Diusta nir­ka­kuna: —Kam, iapa suma atun­mi kangi. ");
INSERT INTO inb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pusag puncha chi wawita iuka­ura, judiu­kunapa marka chura­chir­ka­kuna. Jesus­mi suti­chir­ka­kuna, imasa anjil, María manara wigsi­ta­wa ungug kag­pita, niska­sina. ");
INSERT INTO inb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nis­paka, imasa Moisés niska­sina chaiag­mandaka, wawa tiag­samuska­ura­manda limpiulla tukun­ga­pa puncha­kuna ña iali­ura, Jesus­pa atun­kuna paita Jeru­sa­len­ma apar­ka­kuna, atun Taita Diusta kawa­chispa, nin­ga­pa: “Kam­ba­lla­mi ka”. ");
INSERT INTO inb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ñugpa­manda librupi willa­raiá, tukui ñugpa tiag­samuska kari wam­bra­kunata chasa ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kasa­pas­mi willa­raiá: iskai tur­tu­lita u wawa palu­mita­kuna apan­ga­pa, atun Taita Dius­manda rupa­chig­rin­ga­pa. Pai­kuna, imasa ni­raiaska­sina­mi rurag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chi puncha­kuna, Jeru­salenpi kaug­sa­kurka sug runa, Simeón suti. Chi runa, tukuipi alli rurag, Taita Diusta iuia­rispa kaug­sagmi karka. Israel­manda runa­kunata kispi­chin­ga­pa puncha­kuna­mi pai suia­kurka. Santu Ispí­ritu, pai­wa kaspa, ");
INSERT INTO inb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iuia­chiska karka: “Kam manara wañus­pa­lla, atun Taita Dius agllaska Cristo­ta­mi kawankangi”. ");
INSERT INTO inb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pai­ka, Santu Ispi­ri­tu­wa iuia­chiska kaspa, Dius­pa atun wasima rirka. Ña chipi ka­uraka, wawita Jesus­pa atun­kuna paita chaia­chig­rir­ka­kuna, imasa chi librupi willa­raiaska­sina ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Chi­ura Si­meon­ka, wawata chaskispa mar­kaspa, Taita Diusta iapa suma atun kagta nispa, kasa nirka: ");
INSERT INTO inb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Kuna­ura, nuka kam Taiti­kupa lutrin­sina kas­kata saki­wai, sumag­lla wañun­ga­pa. Ñami kam imasa ni­waska­sina tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kam kacha­muska kispi­chig­ta­mi nuka­pa ñawi­wa ña kawa­kuni. ");
INSERT INTO inb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Paita alli­lla­pi­mi kacha­murkangi, tukui runa­kunata kawa­rin­ga­pa; ");
INSERT INTO inb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","mana Israel­manda kag­kunata iuiai­kunata punchaia­chin­ga­pa; chasa­lla­ta, kamba Israel­manda runa­kunata pai­manda iapa suma atun kagta kawa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón chasa wawita­manda nis­kata uias­paka, taita i mamandi ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chi­ura Simeonka, pai­kunata nirka: —Taita Dius, kam­kunata iapa kuiaspa kawa­pua­chu—. Nis­paka, mamandi Mariata nirka— Uiamui. Kai wawita­manda­mi achka Israel­manda runa­kuna urman­ga­pa kan­kuna. Ikuti sug­kunaka, pai­manda­mi kispi­rin­ga­pa kan­kuna. Paita kawaspa, achka­kuna­mi wabu­tin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kamtaka sug ispada almapi iali­chig­sina­mi iapa llakii iukan­ga­pa kangi. Chi­wanka, tukui imasa iuia­na­kuska iacha­rig­samunga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chi­lla­pita karka Santu Ispi­ri­tu­wa rimag sug warmi, Ana suti, ña iapa awila. Chi warmi, ñugpa­manda Aser suti runapa iawar karka. Fanuel suti runapa wam­bra­mi karka. Paika, sipas kasa­rarka. Kan­chis wata kasa­raska­ura­manda, kusa wañurka. ");
INSERT INTO inb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chi­ura­manda, mana ikuti kasaraspa­lla, ña pusag chunga chusku wata kaug­sa­kurka. Dius­pa atun wasi­manda mana llugsispa­lla, puncha i tuta Taita Dius ima nis­kata rurag­lla­mi karka. Mana mikuspa­lla chisiaspa i paita iuia­rispa­lla­mi karka. ");
INSERT INTO inb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón chasa rima­kug­lla­pi, chi warmika, kai­lla­iaspa, Taita Diusta: “Pai Siñur” nii kalla­rirka. Nis­paka, Taita Diusta tukui iuia­ri­na­kugta wawita Jesus­manda willa­kurka, kasa nispa: —Kaimi ka Jeru­salenta kispi­chin­ga­pa samug. Pai­ta­mi suia­na­kurkan­chi. ");
INSERT INTO inb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Atun Taita Dius imasa nis­kata tukui ruraska­ura­mandaka, Jesuspa atun­kunaka Gali­lea alpama Nazaret pui­blupi ñugpata kaug­sa­na­kuska­ma kutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chi­pika wam­bra Jesús, sumag­lla wi­ñas­pa rirka. Chasa­lla­ta, iachai pagta tukurka. Taita Dius­pas, iapa suma­mi paita kuiarka. ");
INSERT INTO inb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesuspa mama taitandi, Jeru­sa­lén pui­bluma wata watapi ri­dur kar­ka­kuna, paskua atun puncha­kuna iali­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús ña chunga iskai wata iuka­uraka, tukui­kuna rir­ka­kuna, imasa kaska­sina ruraspa iali­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chi pun­cha­kuna sumag­lla iali­chis­paka, mama tai­tandi pai­kuna­pag­ma kutir­ka­kuna. Wam­bra Jesuska, Jeru­sa­len­manda mana rirka. Chi­taka, mama tai­tandi mana iachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iuia­na­kurka: “Sug­kuna­wa­char ri­ku”. Chi­manda, chi­siagta rir­ka­kuna. Nis­paka, pai­pura­kuna­pag­pi i rig­si­du­kuna­pag­pi pai­manda tapui kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mana taris­paka, Jeru­sa­lenma kutir­ka­kuna, maskan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kimsa puncha maska­na­kus­ka­pika, Dius­pa atun wasi uku­pi paita tarir­ka­kuna. Moisés ima nis­kata iacha­chig taita­kunapa chaugpi­pi­mi tia­kurka, uiaspa i pai­kunata tapuspa. ");
INSERT INTO inb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tukui­kuna, ujna­rispa­mi paita uia­na­kurka, paipa iachai­wa imasa aini­kugta. ");
INSERT INTO inb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesuspa mama taitandika, iapa ujna­rispa paita kawar­ka­kuna. Mamandi nirka: —Nuka­pa wam­bra, ¿imapatak nukan­chita chasa rurarkangi? Kamba taita i nuka, iapa llakii­wa­mi maskaspa puri­na­kurkan­chi. ");
INSERT INTO inb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Chi­ura, Jesuska ainirka: —¿Imapatak maska­wa­na­kur­kan­gi­chi? ¿Mana­chu kam­kuna iachan­gi­chi, nuka­pa Taita imasa munas­kata ruran­ga­pa nukata chaia­wa­kugta? ");
INSERT INTO inb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jesuspa mama taitandi mana iachar­ka­kuna, chika ima ni­raiagta. ");
INSERT INTO inb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Chi­ura­mandaka Jesús, Na­za­ret pui­bluma pai­kuna­wa kutirka. Chipika, pai­kuna tukui ima nis­kata uiaspa, alli­lla ruras­pa­mi sug­lla­pi kaug­sa­kurka. Paipa mamaka, tukui ima pasa­ris­kata sumag­lla iuiaipi waka­chi­rirka. ");
INSERT INTO inb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesuska, sumag­lla wiñaspa rirka, Taita Dius i runa­kunapa ñawipi iapa alli kagta kawa­ri. ");
INSERT INTO inb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio suti Romapi iaia man­dag ña chunga pichka wata man­da­ku­ura, Judea alpapi mandag karka Ponsio Pila­tos. Hero­des, Gali­leapi manda­kurka. Waugkindi Fe­li­peka, Iturea i Trakonite suti alpa­kunapi mandag karka. Abilene suti alpapika, Lisanias manda­kurka. ");
INSERT INTO inb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Iaia sasir­duti­kuna suti kar­ka­kuna Anás i Kaifás. Chi puncha­kuna Zaka­riaspa wam­bra, Juan suti, chusa sitaska alpapi kaug­sa­ku­ura, paita Dius­pa Rimaita willan­ga­pa iuia­chi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nis­paka, Jor­dán suti iaku pata pata kasa willaspa purii kalla­rirka: —Panda­rii­kunata sakispa, Taita Dius­wa tukug­samui­chi. Baug­ti­sa­rii­chi, panda­rii­kunata pasin­siai tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chasami pasa­rirka, imasa Santu Ispi­ri­tu­wa ñugpa­manda rimag Isaías suti willaska­sina. Kasa­mi willa­raiá: Chusa sitaska alpapi, sug runa kapa­rispa­mi puri­ku, kasa nispa: “Imasami ñambi alli­chin­chi: chasa­lla­ta alli iuiai­kunata apii­chi, atun Taita Diusta chaskin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tukui waiku­kunata junda­chispa pambaia­chii­chi. Tukui filu i luma­kuna­ta­pas pambaia­chii­chi. Wistu ñambi­kunata diri­chai­chi. Chasa­lla­ta, ñambi pusu­kunata junda­chii­chi. ");
INSERT INTO inb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tukui runa­kuna kawanga­pa­mi kan­kuna, Taita Dius imasa kispi­chin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Achka runa­kuna Juan­pagma chaia­na­kurka, baug­ti­sa­rin­ga­pa. Chi­ura paika, mai­kan­kunataka ni­kurka: —Mana alli runa­kuna, kulibra­sina­mi kan­gi­chi. ¿Pitak kam­kunata willag­rirka: “Taita Dius iapa rabia­rispa llakii puncha ñami chaia­mu­ku. Miti­kui­chi, kispi­riska kan­ga­pa.”? ");
INSERT INTO inb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Alli­lla rurai­chi, tukui panda­rii­kunata sakispa. Mana iuia­rispa kai­chi: “Ñugpa­manda taita Abra­hampa iawar­mi kan­chi”. Nii­ki­chitami: Taita Dius munag­pika, kai rumi­kuna­pas pudin­kunami, Abra­hampa wam­bra­kuna tukug­samun­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ñami tukui­manda jus­ti­sian­ga­pa ka; imasa­mi sacha­kunata acha­wa urma­chin­ga­pa kawa­ku: chasa. Tukui sacha chusa i mana mikunga­sina muiu iukas­ka­kunata angu­wan­ta urma­chispa, nina­pi­mi churan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Chipi kag­kuna tapur­ka­kuna: —Nigpika nukan­chitaka, ¿ima­tak ruran­ga­pa chaiá? ");
INSERT INTO inb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chi­ura, Juanka ainirka: —Mai­kan­pas, iskai kapisaiu iukas­paka, mana iukas­kata sug iuka­chin­gi­chi. Chasa­lla­ta, mai­kan achka mikui iukas­kaka mana iukas­kata karan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mana judíu kas­ka­kuna­manda kulki chaskig­kuna­pas, baug­ti­sa­rin­ga­pa chaiag­ris­paka, Juanta tapur­ka­kuna: —Iacha­chig taita, nukan­chitaka, ¿imatak ruran­ga­pa chaiá? ");
INSERT INTO inb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chi­ura, Juanka ainirka: —Mana iapa kubran­gi­chi. Mai­lla kaskalla mañan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sug suldadu­kuna­pas tapug­rir­ka­kuna: —Nukan­chitaka, ¿imatak ruran­ga­pa chaiá? Chi­ura, Juanka ainirka: —Mancha­chispa, ñi llullaspa i ianga jucha­chispa mana pi­ta­pas kichun­gi­chi. Mailla gana­na­kuska­lla­wa kun­tin­ta­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juan chasa ni­kug­manda, tukui chipi kag­kuna, Taita Dius agllaska Cristota suia­na­kuspa, pai­manda iuia­rispa, tapu­ri­na­kurka: —¿Paichu Cristo kan­tra? ");
INSERT INTO inb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juanka, tukui­kunata nirka: —Nuka, iaku­lla­wa­mi baug­ti­sai­ki­chita. Ikuti sugmi nuka­manda mas iacha samun­ga­pa ka. Paita, nuka mana pudi­nichu, kungu­rispa, paipa chaki­kunapi chura­raiaska watas­kata paska­pun­ga­pa. Paika, Santu Ispi­ri­tu­wa i nina sindi­wa­sina­mi baug­ti­san­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Imasa­mi chagrapi trigu agllag runa, pala­wa mana alli ugsa­kunata chabsi­chispa anchu­chí: chasa­lla­ta­mi pai suia­ku, mana alli iuiag­kunata alli iuiag­kunapa chaugpi­manda anchu­chin­ga­pa. Alli trigu­sina kag­kunata sug­lla­pi suma­mi waka­chin­ga­pa ka. Ikuti mana alli ugsa­sina kag­kunataka mana wañug ninapi rupa­kunga­pa­mi sitan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Achka sug rigcha sug rigcha rimai­kuna­wapas Cristo­manda Alli Willai­ta­mi Juan willa­kurka. ");
INSERT INTO inb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kasapas. Mandag Hero­desta piñaspa­mi iuia­chi­kurka, chi Hero­des, waugkindipa warmi Ero­días suti­wa kaug­sa­kug­manda. Tukui sug mana alli­lla ruras­ka­kuna­manda­pas­mi piñaspa iuia­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chasa piña­kug­manda, Hero­deska karsilpi chura­chirka. Chasa ruras­paka, mas mana alli­lla rurag kag­ta­mi kawa­chi­rirka. ");
INSERT INTO inb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanta manara karsilpi chu­rag­pi, tukui chipi kag­kuna­mi baug­ti­sa­rir­ka­kuna. Chi­ura, Jesus­pas­mi baug­ti­sa­rig­rirka. Taita Diusta rima­kun­kama, awa suma luar paska­rirka. ");
INSERT INTO inb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chi­ura Santu Ispí­ritu, paluma­sina rigcha kawa­rispa­mi Jesus­pagma urai­ku­murka. Suma luar­manda rimai­pas uia­rig­sa­murka, kasa nispa: —Kam, nuka­pa kuiaska wam­bra­mi kangi. Kamta kawaspa, iapa alli suma­mi iuia­chii­wa kawaiki. ");
INSERT INTO inb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús, Alli Willaita willai kalla­ri­ura, kimsa chunga wata­sina iukarka. Tukui­kuna iuia­na­kurka, pai Josepa wam­bra kagta. José karka Elipa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí karka Matatpa wam­bra. Matat karka Levipa wam­bra. Leví karka Melkipa wam­bra. Melki karka Janapa wam­bra. Jana karka Josepa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José karka Matatiaspa wam­bra. Matatías karka Amospa wam­bra. Amós karka Naumpa wam­bra. Naum karka Eslipa wam­bra. Esli karka Nagaipa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai karka Maatpa wam­bra. Maat karka Matatiaspa wam­bra. Matatías karka Semeipa wam­bra. Semei karka Josekpa wam­bra. Josek karka Judapa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá karka Joananpa wam­bra. Joanán karka Resapa wam­bra. Resa karka Zorobabelpa wam­bra. Zorobabel karka Salatielpa wam­bra. Salatiel karka Neripa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri karka Melkipa wam­bra. Melki karka Adipa wam­bra. Adi karka Kosampa wam­bra. Kosam karka Elmadampa wam­bra. Elmadam karka Erpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er karka Jesuspa wam­bra. Jesús karka Eliezerpa wam­bra. Eliezer karka Jorimpa wam­bra. Jorim karka Matatpa wam­bra. Matat karka Levipa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví karka Simeonpa wam­bra. Simeón karka Judapa wam­bra. Judá karka Josepa wam­bra. José karka Jonampa wam­bra. Jonam karka Eliakimpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim karka Meleapa wam­bra. Melea karka Menapa wam­bra. Mena karka Matatapa wam­bra. Matata karka Natanpa wam­bra. Natán karka Davidpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David karka Isaipa wam­bra. Isaí karka Obedpa wam­bra. Obed karka Boozpa wam­bra. Booz karka Salapa wam­bra. Sala karka Naasonpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón karka Aminadabpa wam­bra. Aminadab karka Adminpa wam­bra. Admin karka Arnipa wam­bra. Arni karka Esrompa wam­bra. Esrom karka Farespa wam­bra. Fares karka Judapa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá karka Jakobpa wam­bra. Jakob karka Isaakpa wam­bra. Isaak karka Abra­hampa wam­bra. Abra­ham karka Tarepa wam­bra. Taré karka Nakorpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor karka Serugpa wam­bra. Serug karka Ragaupa wam­bra. Ragau karka Pelegpa wam­bra. Peleg karka Eberpa wam­bra. Eber karka Salapa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala karka Kainanpa wam­bra. Kainán karka Arfaxadpa wam­bra. Arfaxad karka Sempa wam­bra. Sem karka Noepa wam­bra. Noé karka Lamekpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek karka Matusalenpa wam­bra. Matusalén karka Enokpa wam­bra. Enok karka Jaredpa wam­bra. Jared karka Maalaleelpa wam­bra. Maalaleel karka Kainanpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainán karka Enospa wam­bra. Enós karka Setpa wam­bra. Set karka Adanpa wam­bra. Adán karka Taita Dius­pa wam­bra. ");
INSERT INTO inb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús baug­ti­sa­riska­ura­man­da, Santu Ispí­ritu paima iai­kurka. Nis­paka, Jor­dán iaku­manda kutirka. Chi­ura Santu Ispí­ritu, chusa sitaska alpama paita pusarka. ");
INSERT INTO inb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chipika, chusku chunga pun­cha­mi chisiarka. Chi puncha­kuna iaia kuku, panda­rii­kunapi paita urma­chin­ga­pa muna­kurka. Tukui chi puncha­kuna Jesús, mana ñi ima­pas mikuspa­lla chisia­kurka. Chi chusku chunga puncha ialiska­ura­mandaka, iapa iarkai­manda iuia­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Chi­ura, chi iaia kukuka nirka: —Kam Dius­pa wam­bra kag­pika, kai rumita nii: “Tanda tukui”. ");
INSERT INTO inb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesuska ainirka: —Ñugpa­manda librupi, kasa­mi willa­raiá: Runa­kuna, mana tanda­lla­wa kaug­san­ga­pa kan­kuna­chu. Taita Dius tukui ima rimas­ka­kuna­wa­mi kaug­san­ga­pa chaiá. ");
INSERT INTO inb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nis­paka chi iaia kukuka, iapa awa filuma pusaspa, sug kawa­ri­diru­manda kai luarpi tukui alpa­kunata kawa­chirka. ");
INSERT INTO inb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nis­paka nirka: —Tukui chi alpa­kuna­ta­mi kara­sa­ki, kam mandag kan­ga­pa; chasa­lla­ta, tukui ima chipi suma tias­ka­kuna­ta­pas, kamballa kan­ga­pa. Tukuimi nukata kua­waska ka. Chi­manda, nuka mai­kan munas­ka­ta­mi karasa. ");
INSERT INTO inb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kam kungu­ri­wag­pika, tukui kamba­lla­mi kanga. ");
INSERT INTO inb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Chi­ura Jesuska, chi iaia kukuta ainirka: —Ñugpa­manda librupi, kasa­mi willa­raiá: Kamba atun Taita Dius­lla­ta kungu­rispa kangi. Pai ima niska­lla­ta­mi iukangi ruraspa kanga. ");
INSERT INTO inb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ikuti chi iaia kukuka, Jeru­sa­lén pui­bluma pusaspa, Dius­pa atun wasi awa puntapi saia­chig­rirka. Nis­paka nirka: ");
INSERT INTO inb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","—Kam Dius­pa wam­bra kag­pika, kai­manda alpama sita­rii. Ñugpa­manda librupi, kasa­mi willa­raiá: Taita Dius, paipa anjil­kuna­ta­mi ninga, kamta kawag­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pai­kunapa maki­pi­mi urman­kangi. Chasaka, mana rumipi u ima­pipas chaki taka­rin­kangi­chu. ");
INSERT INTO inb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesuska ainirka: —Kasapasmi willa­raiá: Kamba atun Taita Diusta mana ianga ningi: “Abir kawasaki: ¿pudingi­chu?”. ");
INSERT INTO inb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Chasa chi iaia kuku, tukui ima­wapas panda­chin­ga­pa mana pudis­paka, Jesusta sakispa, sug puncha­kuna­kama rirka. ");
INSERT INTO inb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Jesuska, Santu Ispi­ri­tupa iapa iachai­wa Gali­lea alpama ikuti rirka. Chipika, judiu­kuna tanda­ri­diru wasi­kunapi iacha­chii kalla­rig­rirka. Pai­manda, tukui­kuna sumag­lla uiaspa rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Chi­ura­manda Jesús, pai wiñaska Nazaret pui­bluma chaiag­rirka. Sug warda punchaka, tanda­ri­diru wasima iai­kurka, imasa kustum­bri kaska­sina. Chipika saia­rirka, ñugpa­manda librupi willa­raias­kata chaskin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chi­ura, Isaías suti Santu Ispi­ri­tu­wa rimag ima willa­raias­kata kuar­ka­kuna. Maskaspa, tarirka maipi kasa ni­raias­kata: ");
INSERT INTO inb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Atun Taita Dius­pa Ispí­ritu, nuka­wa­mi ka. Agllaskami kani, mana iukag­kunata Alli Willaita willag­rin­ga­pa­kunata. Kacha­muskami kani, karsilpi kas­ka­kunata willan­ga­pa kacha­rii tukun­ga­pa kagta­kuna; chasa­lla­ta, mana ñawi kawag­kuna ikuti kawag­samun­ga­pa­kuna; mana alli­lla rurai tukus­ka­kunata kispi­chin­ga­pa; ");
INSERT INTO inb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","atun Taita Dius kispi­chii wata chaia­mus­kata willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesús chasa rimas­paka, chi ni­raiaska libruta wichkaspa, kuti­chis­paka, tia­rirka. Tukui chipi kag­kuna, paita upalla kawa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Chi­ura Jesuska, kasa­mi nii kalla­rir­ka­kunata: —Kuna punchami, kam­kunapa ñawipi, imasa chi willa­raiaska­sina tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chipi tukui kag­kuna, pai­manda alli­lla rima­na­kurka. Pai iapa suma rima­kug­manda, ujna­rispa tapu­ri­na­kurka: —Kai runaka, ¿mana­chu ka Jose­pa wam­bra? ");
INSERT INTO inb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesuska nir­ka­kunata: —Imasami nin­kuna: chasa­mi ni­wankan­gi­chi: “Ambig runa, kam kikin­lla ambi­rii”. Kasa­pas­mi ni­wan­kan­gi­chi: “Kam, tukui imasa Kafar­naum pui­blupi ruras­kata uia­riska­sina kai kam kikinpa alpa­pipas chasa­lla­ta rurai”. ");
INSERT INTO inb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kasapasmi Jesús nirka: —Kasami nuka nii­ki­chita: ñi mai­kan Santu Ispi­ri­tu­wa rimag­kunata kikinpa alpapi kaug­sag­kuna mana munan­kuna­chu uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sutipa­mi kasa nii­ki­chita: ñugpa­manda rimag Elías kaug­sa­ku­ura, kimsa wata sugta killa­mi mana tamiarka. Tukui alpapi iapa iarkaimi tukurka. Chi­ura­kuna, kai Israel alpapi achka sapalla kidaska warmi­kuna­mi tiarka. ");
INSERT INTO inb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Chi warmi­kuna­pagma, Taita Dius Eliasta mana kacharka. Sidón pui­blu ladu­lla­pi Sarepta suti pui­blupi kaug­sag biuda­pag­ma­mi kacharka. ");
INSERT INTO inb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Chasa­lla­ta, ñugpa­manda Eli­seo Santu Ispi­ri­tu­wa rimag kaug­sa­ku­ura, kai Israel alpapi achka­kuna aicha ismui ungui­wa tiar­ka­kuna. Chi ungug­kunata, Eli­seo mana ambirka. Siria alpa­manda samuska Naamán suti runa­lla­ta­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Chasa uiaspa, chi wasi uku tukui kag­kuna iapa­mi rabia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tukui­kuna, ata­rispa, Jesus­ta pui­blu­manda llugsi­chii kalla­rir­ka­kuna. Chi pui­blu, luma awa­pi wasi­kuna saia­chis­ka­mi iukar­ka­kuna. Chi luma awa­manda tangan­ga­pa iuiai­wa­mi Jesusta apa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Paika, pai­kunapa chaugpi­manda kichu­chi­rispa, llugsispa rirkalla. ");
INSERT INTO inb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nis­paka, Gali­lea alpapi Ka­far­naum suti pui­bluma chaiag­rirka. Chipika, warda puncha­kuna ");
INSERT INTO inb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","iacha­chii kalla­rirka. Pai iacha­chi­kus­kata uiaspa, tukui­kuna iapa ujna­rir­ka­kuna. Alli­lla mandag­sina­mi iacha­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chi tanda­ri­diru wasipika, sug kuku waira iai­kuska runami chaiag­rirka. Chi runaka, sin­chi kapa­rispa nirka: ");
INSERT INTO inb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ai, Nazaret pui­blu­manda Jesús, ¿imapatak nukan­chi­pagma samurkangi? Nukan­chita puchu­kan­ga­pachar samurkangi. Nuka alli­lla­mi rigsii­ki, kam Taita Dius­pa tukui­pi mas alli wam­bra kagta. ");
INSERT INTO inb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesuska, kuku wairata pi­ñas­pa, nirka: —Upalla ri­kui, kai runa­manda llugsispa. Chi­ura chi kuku wairaka, tukui­kunapa ñawipi chi runata alpama urma­chispa, llugsirka, mana ima­pas lisia­chispa­lla. ");
INSERT INTO inb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tukui chasa kawag­kuna, iapa mancha­rir­ka­kuna. Kikin­pura tapu­ri­na­kurka: —¿Ima rimai­sik ka? Kai runaka, paipa iapa iachai­wa atun mandag­sina kuku waira­kunata rimaspa, runa­manda llugsichí. ");
INSERT INTO inb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Chasa ruras­ka­kunata kawag­kuna­waka, tukuima Jesus­manda iacha­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chi tanda­ri­diru wasi­manda llugsispa, Jesús, Simonpa wasipi iai­kug­rirka. Chipika Simonpa sui­gra, iapa rupai­wa­mi ungug siri­kurka. Jesusta mañar­ka­kuna: —Ambi­puai. ");
INSERT INTO inb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chi­ura Jesuska, chi ungug­pag­ma kailla­iaspa, kumu­rispa nirka: —Kai rupai anchu­rii. Chi­ura­lla, rupai anchu­rirka. Anchu­rig­lla­pi chi warmi, ata­rispa, mikui ianuspa, karai kalla­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Indi ña chinga­ku­uraka, achka­kuna ima ungui­wa kas­ka­kuna­ta­mi Jesus­pagma chaia­chig­rir­ka­kuna. Chi­ura Jesuska, tukui­kunata maki churaspa, ambir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chasa­lla­ta kuku waira­kuna­ta­pas, achka­kuna­ta­mi llugsi­chirka. Chi kuku waira­kuna, kapa­rispa, ni­na­kurka: —Taita Dius­pa wam­bra­mi kangi. Jesuska, chasa kapa­ri­na­kus­kata piñarka. Chi kuku waira­kuna iachar­ka­kuna, pai Taita Dius ag­llaska Cristo kagta. Chi­manda­mi chi kuku­kunata mana saki­kurka, chasa riman­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Paka­rii­lla­pi Jesuska, chi pui­blu­manda rirka, mana mai­kan runa­kunapas kaug­sa­na­kuska pamba­ma. Chi pui­blu­manda achka runa­kunaka, paita maskaspa, pai kaska­ma chaiag­rir­ka­kuna. Muna­na­kurka pai­kuna­pag­lla­pi kan­ga­pa, mana mai­mapas rispa­lla. ");
INSERT INTO inb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Chasa maña­na­kus­kata uiaspa, Jesuska kasa­mi nirka: —Nukata chaia­wa­kumi, sug pui­blu­kuna­pipas Dius­pa suma mandai­manda Alli Willaita willaspa purin­ga­pa. Chasa­manda­mi nuka kacha­muska kani. ");
INSERT INTO inb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pai imasa niska­sina, Judea alpa­pi tukui tanda­ri­diru wasi­kuna­pi iai­kuspa, Alli Willaita willaspa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesús Jenesaret suti kucha pata­pi ka­uraka, achka runa­kuna paita tanga­na­kui­wan­ta­mi kai­lla­iag­rir­ka­kuna, Dius­pa Rimaita uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Chi iaku patapi, iskai chusa kanuami tiarka. Kanua­manda chalwa­dur­kuna, llugsispa, ata­ra­ia­kuna tagsa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chasa kawas­paka, Jesuska sug kanuapi iai­kurka. Nis­paka, chi kanua Si­mon­pa kag­manda, paita mañarka: —Kai kanuata alpa­manda asllita karuia­chi­puai. Chasa rura­uraka, kanuapi tia­rispa, chipi kag­kunata iacha­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iacha­chii puchu­kas­paka, Simonta nirka: —Kanuata jundu kuchama apas­paka, ata­raiag­rii­chi, chalwa apin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonka ainirka: —Iacha­chig taita, paka­rig­ta­mi chalwa­na­kurkan­chi. Ñi ima­pas mana apirkan­chi­chu. Kam chasa ni­wag­manda, nig­pika ata­raiag­risa. ");
INSERT INTO inb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Chasa ata­raiag­ri­uraka, iapa achka chalwa apir­ka­kuna, ata­raia­kuna­pas ñalla lliki­rigta. ");
INSERT INTO inb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chi­ura, sug kanuapi kas­ka­kunata maki­wa kaiar­ka­kuna, aidag­rin­ga­pa. Chaiag­ris­paka, iskandi kanuapi chalwa­kuna junda­chig­rir­ka­kuna, ñalla kanua­kuna­pas asinta­rigta. ");
INSERT INTO inb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Chasa kawas­paka Simón Pedroka, kungu­rispa, Jesusta nirka: —Taita waugki, nuka­manda anchu­ri­puai. Nuka, iapa panda­ri­durmi kani—. ");
INSERT INTO inb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iapa achka chalwa­kuna api­rig­manda, Simón i tukui pai­wa kag­kuna asku­rinti mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiago i Juan suti Zebedeopa wam­bra­kuna Simonwa purig kag­kuna­pas, chasa­lla­ta mancha­rir­ka­kuna. Jesuska, Simonta nirka: —Mana mancha­ri­kui. Kuna­ura­manda iacha­chi­sa­kimi, chalwa­kunata apig­sina, runa­pura maska­puag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chasa uias­paka, kanua­kunata alpama llugsi­chispa, tukui ima tias­ka­kunata sakispa, Jesusta katir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús ña sug pui­blupi kag­ri­uraka, sug runa, aicha ismui ungui iukaspa, pai­pagma kailla­iag­rirka. Chi runaka, Jesusta kawaspa, ña­lla­pas alpa­kama kumu­rispa, nirka: —Taita waugki, kam munas­paka, pudingimi nukata ambi­wanga. ");
INSERT INTO inb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Chi­ura Jesuska, ungugta maki churaspa, nirka: —Ari, munanimi. Ambi­riska tukui. Chasa nig­lla­pi, chi ungui alli­lla ambi­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chi­ura, Jesuska nirka: —Mana pi­ta­pas willa­kungi. Sa­sir­dutita kawa­chi­rig­rii. Moisés kama­ri­ku karan­ga­pa ni­raias­kata karag­rii. Chasaka, tukui­kuna­mi kawan­ga­kuna, kam alli­lla ambi­riska kagta. ");
INSERT INTO inb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","“Mana willa­kungi” nigpi­pas, Jesús ima ruras­ka­manda masmi iacha­ri­kurka. Chi­wanka, iapa achka runa­kuna tanda­ri­dur kar­ka­kuna, paita uian­ga­pa. Chasa­lla­ta, ungug­kuna­ta­pas ambi­chin­ga­pa apa­dur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Chi­manda Jesus­ka, mai­kan runapas mana kaug­sa­na­kuska­ma ri­dur karka, Taita Dius­wa rima­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sug puncha­kuna iali­ura, Jesus­ka iacha­chi­kurka. Chipika, sug fari­seo­kuna i Moisés ima nis­ka­ta iacha­chig taita­kuna tia­na­kurka. Chi taita­kuna kar­ka­kuna Gali­lea i Judea alpa­kuna suiu i Je­ru­sa­len­manda chaiag­ris­ka­kuna. Chi­ura Jesuska, atun Taita Dius­pa iapa iachai­wa karka, ungug­kunata ambin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesús iacha­chi­ku­uraka, sug runa­kunaka, mana kuiu­rin­ga­pa ungui­wa kas­kata chakanapi siri­chispa, chi wasima apar­ka­kuna. Iuia­na­kurka: “Wasi ukuma iaiku­chispa, Jesuspa ñugpa ladumi chura­sun­chi”. ");
INSERT INTO inb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Chasa iuia­na­kuspa­pas, iapa achka runa­kuna ukupi junda kag­manda, mana iaiku­chii pudir­ka­kuna. Chi­mandaka, wasi awama sika­chir­ka­kuna. Wasita utku­chispa, chi runa chaka­na­pi siri­kus­ka­ta tukui­kunapa chaugpi­pi Jesuspa ñawi ladu urai­ku­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chi­ura Jesuska, “Ambi­puangami” iuia­na­kus­kata kawas­paka, mana kuiu­rin­ga­pa ungui­wa kas­kata nirka: —Waugki, kam panda­rii­kunata ñami pasin­siaska kangi. ");
INSERT INTO inb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Chasa uias­paka, Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kunaka kikin­pura ni­na­kurka: “Kai chasa rimag, Dius­sina tukuspa, ¿pi­sik ka? Ñi pipas mana pudin­kuna­chu, panda­rii­kunata pasin­sian­ga­pa. Taita Dius­lla­mi pasin­sian­ga­pa pudí”. ");
INSERT INTO inb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesuska, chasa iuia­na­kus­kata iachas­paka, nir­ka­kunata: —¿Imapatak chasa sungu­lla­pi iuia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Mai­kantak mas alli ka nin­ga­pa: “Kam panda­rii­kuna­ta ñami pasin­siaska kangi”? Mana kag­pika, ¿nin­ga­pa: “Ata­rii; kam­ba wasima riilla; ña ambi­riska­mi kangi”? ");
INSERT INTO inb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kuna­ura kawa­chisa­ki­chita: kai Runa Tukuska, kai alpapi pudin­mi, panda­rii­kunata pasin­sian­ga­pa. Chasa nispa, mana kuiu­rin­ga­pa ungui­wa kas­kataka nirka: —Nukami niiki: atarii. Cha­ka­na­ta marka­rispa, kamba wasima rii. ");
INSERT INTO inb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chasa nig­lla­pi, tukui chipi kag­kuna kawa­na­kug­lla­pi, chi runa ata­rirka. Chakana siri­kus­kata mar­ka­rispa, wasima rirka, Taita Dius iapa suma atun kagta nispa. ");
INSERT INTO inb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chi­wa tukui­kuna, iapa ujna­rispa tukug­samur­ka­kuna. Taita Diusta iapa suma atun­ia­chir­ka­kuna. Iapa mancha­rispa, nir­ka­kuna: —Kuna puncha, ñi ima­ura­pas mana kawas­ka­ta­mi kawarkan­chi. ");
INSERT INTO inb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chi­ura­manda Jesuska, llug­sispa, Leví suti runa mana judíu kas­ka­kuna­manda kulki chas­ki­kus­ka­pi tia­kugta kawaspa, nirka: —Kati­wai. ");
INSERT INTO inb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Chi­ura chi runa, ata­rispa, Jesusta kati­chirkalla, tukui sakispa. ");
INSERT INTO inb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nis­paka, atun puncha­sina suma mikui Jesusta paipa wasipi karag­rirka. Pai­pura kulki chaskig­kuna i sug achka­kuna­pas, sug­lla­pi pai­kuna­wa tia­rig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Chasa kawas­paka, fari­seo­kuna i Moisés ima nis­kata iacha­chig taita­kuna Jesusta kati­raiag­kunata piñaspa tapur­ka­kuna: —¿Imapatak mana judíu kas­ka­kuna­manda kulki chaskig i mana alli­lla rurag­kuna­wa sug­lla­pi miku­nakun­gi­chi i upia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesuska nir­ka­kunata: —Mana ungui­wa kag­kuna mana minis­tin­kuna­chu, ambigta maskan­ga­pa. Ungug­kuna­mi ambigta mas­kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Chasa­lla­ta, nukaka mana samurka­nichu, alli­lla rurag­kunata kaian­ga­pa. Mana alli­lla rurag­kunata maskanga­pa­mi samur­ka­ni, pai­kunata alli­lla rurai­kuna­ma tigra­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Chipi kag­kuna, Jesusta nir­ka­kuna: —Juanwa i fari­seo­kuna­wa purig­kuna, achka puncha­kuna mana mikuspa­lla­mi chisia­dur kan­kuna, Taita Diusta mañaspa­lla. Ikuti kamta kati­raiag­kunaka, ima­ura­pas­mi mikun­kuna i upian­kuna. ");
INSERT INTO inb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chi­ura, Jesuska ainir­ka­kunata: —Kasaraipi, kusa tukunga kun­bidas­ka­kuna­wa kan­kama, ¿pudin­kan­gi­chi­chu ninga: “Mana mikus­pa­lla kai­chi”? Manima. ");
INSERT INTO inb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ima­ura chaiachu, kusa anchu­chii tukun­ga­pa: chi­ura­mi pai­kunata chaianga, mana mikuspa­lla kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nis­paka, chipi kag­kunata iuiai apinga­sina suma parlarka, kasa nispa: —Ñi pipas, musu katanga­manda piti mana lliki­chinkan­gi­chi­chu, ruku katangapi siran­ga­pa. Chasa sirag­pika, musu katangami wagllirí. Musu­manda pitipas rukupi siraska mana suman­chu. ");
INSERT INTO inb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Chasa­lla­ta ñi pipas, musu binu, ruku kara taligapi mana tallin­gi­chi­chu. Chasa tallig­pika, musu binu timbu­ura, taligata tugia­chispa­mi icha­ringa. Kara taligapas mana balinga­chu. ");
INSERT INTO inb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chi­manda­mi musu binu, musu taligapi tallin­ga­pa chaiá. ");
INSERT INTO inb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Ñi pipas, suma timbuska binu upias­paka, llullu binutaka mana upiai munan­ga­pa kan­gi­chi­chu. “Timbus­ka­ta­mi mas alli ka” ninga­pa­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sug warda puncha, Jesús kati­raiag­kuna­wan­ta chagra tarpu­raias­ka­kunapi iali­na­kurka. Kati­ra­iag­kunaka, trigu ispiga­kunata pitispa, maki­wa kakuspa, muru­kuna­ta miku­nakurka. ");
INSERT INTO inb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Chasa kawas­paka, sug fari­seo­kuna tapur­ka­kuna: —¿Imapatak warda puncha panda­ri­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesuska ainir­ka­kunata: —¿Mana­chu ñugpa­manda li­bru­pi willa­raias­kata kawarkan­gi­chi, taita David i pai­wa kag­kuna­pas, iar­kai­manda kaspa, imasa ruragta­kuna? ");
INSERT INTO inb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pai kikin, Dius­pa wasi uku­ma iai­kuspa, altarpi churaska tanda­kuna tias­kata aisas­pa, mikurka, mana ima­pas mancha­rispa­lla. Chi tanda­kuna, sasir­duti­kunalla miku­diru­mi karka. Chi tanda­kuna­lla­tata pai­wa kag­kuna­ta­pas kararka, mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kasapasmi Jesús nir­ka­kunata: —Kai Runa Tukuska pudin­mi ninga, warda puncha­kuna­ta­pas imasa chaiaska­sina ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sug warda punchaka Jesús, tanda­ri­diru wasipi iai­kuspa, iacha­chi­kurka. Chipika, sug alli ladu maki chaki­riska ungui­wa kag runa, pai­kuna­wa sug­lla­pi karka. ");
INSERT INTO inb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chi­ura Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kunaka, Jesusta cha­pa­na­kurka, warda puncha ambi­chu; ambig­pika, pai­manda jus­ti­sia­kuna­pagma willag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus­ka, pai­kuna ima iuia­na­kus­kata iachaspa, chi runa maki chaki­riska kas­kata nirka: —Atarii. Runa­kunapa chaugpipi saia­rig­samui. Chi­ura chi runa, ata­rispa, chipi saia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Chi­ura Jesuska, chi taita­kunata nirka: —Tapusa­ki­chita: warda puncha, ¿imatak mas alli ka: alli­lla u mana alli­lla ruran­ga­pa; runata kispi­chin­ga­pa ubi puchukan­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chasa tapus­paka, tukui paipa muiugta kag­kunata kawaspa, chi runata nirka: —Maki chutachii. Chasa chutachig­lla­pi, chi maki­ka aliarka. ");
INSERT INTO inb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Chipi kag taita­kuna, Jesus­wa iapa rabia­rispa, kikin­pura tapu­ri­na­kurka: —¿Imatak kai runata rura­sun­chi? ");
INSERT INTO inb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chi puncha­kuna Jesuska, awa lumama rirka, Taita Diusta riman­ga­pa. Chipi, paka­rig­ta­mi Taita Dius­wa rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Paka­ri­uraka, tukui paita kati­raiag­kunata kaiaspa, chunga iskai­kuna­ta­mi agllarka. Chi agllas­ka­kuna­taka nirka: —Nukami kam­kunata kacha­na­kui­ki­chita, nuka­manda Alli Willaita willag­kuna kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chi agllas­ka­kuna, kasa­mi suti kar­ka­kuna: Simón (paita, Jesús suti­chirka Pedro); paipa waugki Andrés; Santiago i Juan; Felipe i Bartolomé; ");
INSERT INTO inb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo i Tomás; Alfeopa wam­bra Santiago­lla­tata suti; sug Simón (kananeo suti runa­kuna­wa ñugpata purig); ");
INSERT INTO inb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","San­tiagopa waugki Judas; i Judas Iska­riote, Jesusta katuspa api­chig. ");
INSERT INTO inb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chi­ura­manda Jesús, chi luma­manda pai agllaska runa­kuna­wan­ta urai­kuspa, sug pamba alpama chaiag­rir­ka­kuna. Chipika, achka paita kati­raiag­kuna tanda­riska kar­ka­kuna. Chasa­lla­ta iapa achka runa­kuna, Judea alpa suiu­nig­manda, Jeru­salén pui­blu­nig­manda, i Tiro i Sidón pui­blu lamar iaku pata­manda­kuna, Jesusta uian­ga­pa i ungug­kunata ambi­chin­ga­pa tanda­rig­riska kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chi­ura­lla­tata, kuku waira­wa kag­kuna­pas­mi ambi­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesús, paipa iapa iachai­lla­wa tukui ungui­wa kas­ka­kuna­ta­mi alia­chi­kurka. Chi­manda tukui chipi kag­kuna, paita llam­kanga­pa­mi muna­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chi­ura Jesuska, paita kati­ra­iag­kunata kawaspa, kasa­mi nirka: —Kam­kuna Taita Dius­wa iuia­rispa mana iukag­sina tukug­kuna, pai­pa iapa kuiaska­mi kan­gi­chi. Kam­kuna, Dius suma manda­kus­ka­pi­mi iaikug­rin­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Iapa iarkai­manda kuna­ura kag­kuna­pas, Taita Dius­pa iapa kuiaska­mi kan­gi­chi. Pai­lla­ta­ta­mi ima alli munas­kata kara­mun­ga­pa ka. —Kuna­ura iapa llakii­wa waka­na­kuskapas, Taita Dius­pa iapa kuiaska­mi kan­gi­chi. Nis­paka asin­kan­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Kai Runa Tukus­ka­manda iuia­rispa, mai­kan­pas kam­kunata piñaspa, llugsi­chispa, kamispa, imasa mana alli­lla­wa suti­chi­na­kugpi­pas, Taita Dius­pa iapa kuiaska­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chasa mana alli­lla kam­kunata ruragpi­pas, kun­tin­ta­rispa­lla kan­gi­chi. Kam­kunata, Taita Dius sug luarpi asku­rinti suma­mi tukui karan­ga­pa ka. Chasa­lla­ta­mi ñugpata kaug­sag runa­kuna Santu Ispi­ri­tu­wa rimag­kuna­ta­pas mana alli­lla rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—¡Ai, kam­kuna iapa iukag kag­kuna! Ñami tukui chaskirkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—¡Ai, kam­kuna kuna­ura sagsaskalla kag­kuna! Kam­kunata chaianga­pa­mi ka, iapa iarkai­wa kan­ga­pa­kuna. —¡Ai, kam­kuna kuna­ura asig­kuna! Kam­kunata chaianga­pa­mi ka, iapa llakii­wa wakaspa kan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—¡Ai, kam­kuna­manda iapa alli­lla tukui runa­kuna rimag­manda! Chasa­lla­ta­mi ñugpata kaug­sag runa­kunapas, Dius­pa Rimaita llullaspa willa­na­kug­manda, “Iapa alli­lla­mi ka” nir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Chasa kagpi­pas, kam­kuna uia­wag­kunata kasa­mi nii­ki­chita: kam­kunata piña­na­kus­kata kuian­gi­chi. Kam­kunata mana muna­na­kus­ka­ta­pas alli­lla ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kam­kunata kamig­kuna­ta­pas nin­gi­chi: “Taita Dius, kam­kunata iapa kuiaspa kawa­pua­chu”. Kam­kunata mana suma rurag­kuna­manda­pas Taita Diusta pai­kuna­manda alli­lla maña­pun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Mai­kan­pas kachitipi kamta piag­pika, sug ladu kachitipi pian­ga­papas saki­ringi. Mai­kan kamta kapi­saiu kichun­ga­pa munag­pika, kusma­ta­pas kuangi apachu. ");
INSERT INTO inb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mai­kan­pas ima mañas­kata karangi­lla. Ima kamba­ta­pas mai­kan kichugpi­pas, mana ningi: “Kuti­chi­wai”. ");
INSERT INTO inb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Imasa­mi muna­na­kun­gi­chi, sug­kuna kam­kuna­manda alli­lla rura­chu­kuna: chasa­lla­ta kam­kuna­pas, pai­kuna­manda alli­lla ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Kam kikin­puralla kuia­na­kuspa kag­pika, kam­kunaka, ¿ima­tak Taita Dius karan­ga­pa suia­na­kun­gi­chi? Mai­kan mana alli­lla ruraspa kaug­sa­na­kug­purapas kuia­na­kuspa­mi kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chasa­lla­ta, kam­kunata suma rurag­kuna­lla­ta suma rurag­pika, kam­kunaka, ¿imatak Taita Dius karan­ga­pa suia­na­kun­gi­chi? Mana alli­lla rurag­kuna­pas, pai­pura suma rura­na­kuspa­mi kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mai­kan­pas kuti­chi­wa­chu iuias­pa­lla maña­chig­pika, kam­kunaka, ¿imatak Taita Dius karan­ga­pa suia­na­kun­gi­chi? Mana alli­lla rurag­kuna­pas, pai­pura maña­chi­ri­nakú, parijuma kuti­chi­ri­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Chasapaka, kam­kunata mana munaspa piña­na­kus­kata kuiaspa, tukui alli­llata ruran­gi­chi. Maña­chin­gi­chi, mana kuti­chin­ga­pa iuiaspa­lla. Chasaka, tukui sumag­lla­mi sug luarpi chaskig­rinkan­gi­chi. Chasapi, tukui­kuna­manda mas atun Taita Dius­pa wam­bra­kuna­mi tukun­ga­pa kan­gi­chi. Taita Diuska, tukui mana “Pai Siñur” nis­ka­kuna­ta i mana alli­lla rurag­kuna­ta­pas paipa llakii­wa sumag­lla­mi kawá. ");
INSERT INTO inb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imasa­mi kam­kunapa Taita Dius, kam­kunata llakii­wa sumag­lla kawá: kam­kuna­pas chasa­lla­ta­mi iukan­gi­chi, sug­kunata llakii­wa kuiaspa kawanga. ");
INSERT INTO inb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Mana pi­ta­pas panda­ris­ka­kunata kawan­gi­chi. Chasaka Taita Dius, mana kam­kuna panda­ris­kata kawanga­chu. Mana sug­kunata nin­gi­chi: “Dil­tudupa ninama rin­ga­pa­mi kan­gi­chi”. Chasaka Taita Dius, mana kam­kunata chi ninama kachanga­chu. Sug­kuna panda­ris­ka­kunata pasin­sian­gi­chi; chasaka Taita Dius, kam­kuna panda­ris­ka­kuna­ta­pas pasin­siangami. ");
INSERT INTO inb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Sug­kunata karan­gi­chi; chasaka Taita Dius, kam­kuna­ta­pas karangami. Achka, junda, icha­rig­ta­mi karanga. Imasa­mi sug­kunata kam­kuna tupun­gi­chi: chasa­lla­ta­mi Taita Dius, kam­kunata alli­lla u mana alli­lla ruras­kata tupun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chasa nis­paka, chipi kag­kuna­ta iuiai apinga­sina suma par­larka, kasa nispa: —Mana ñawi kawag, sug mana ñawi kawagta pusag­pika, ¿mana­chu iskandi­kuna pusuma urmag­rin­tra­kuna? ");
INSERT INTO inb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ñi mai­kan iachai­kug­kuna, iacha­chis­ka­manda mas iacha mana kan­kuna­chu. Tukuipi alli­lla iachai­kug­pika, iacha­chiska­sina­lla­ta­ta­mi tukunga. ");
INSERT INTO inb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—¿Imapatak sugpa ñawipi juitu­riska ugsata kawa­kungi; ikuti kam kikinpa ñawipi sug atun ugsa juitu­riska iukas­kataka mana kawa­ringi? ");
INSERT INTO inb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chasa­lla­ta, kam kikin­pa ñawipi chi atun juitu­riska iukas­kata mana kawa­rispa­lla, ¿ima­sa­tak sugta ninkangi: “Waugki, ñawipi juitu­riska ugsata anchu­chi­sa­ki”? Sungu awalla rimag, kam kikinpa ñawita chi atun juitu­riska iukas­kata ñugpa anchu­chi­rii. Chasa ruras­pa­mi alli­lla kawankangi, sug­pa ñawita juitu­riska ugsata anchu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Kasapas. Alli sacha­kunapi winja muiu mana tukug­samun­chu. Mana alli sacha­kunapika miski muiu­kuna mana tia­rin­chu. ");
INSERT INTO inb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tukui sacha, muiu­kuna tia­ri­ura­mi rigsirí, alli u mana alli kagta. Ispina­iug sacha­kunapi mana igus muiu tanda­chi­rin­chu. Chini sacha­kunapi mana ubas palla­rin­chu. ");
INSERT INTO inb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Chasa­lla­ta alli runa­kuna, alli iuiai­kuna iukaspa­mi alli­lla rimag­samun­kuna. Ikuti mana alli runa­kunaka, mana alli iuiai­kuna iukaspa­mi mana alli­lla rimag­samun­kuna. Iuiaipi imasa iuia­na­kus­ka­ta­mi simipi rima­chig­samú. ");
INSERT INTO inb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—¿Imapatak, nuka imasa nis­kata mana ruraspa­pas, nukata: “Iaia Jesús, Iaia Jesús” ni­wan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mai­kan nuka­pagma samuspa, nuka ima rimas­kata uiaspa rurag­kuna, nisa­ki­chita kasa kagta. ");
INSERT INTO inb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sug runa, suma jundu utkuspa, atun rumipi sug wasi saia­chig­sina­mi ka. Mai­tuku iaku junda­ura, chi wasita piag­ri­kugpi­pas, mana kuiu­chin­ga­pa kan­chu, alli­lla saia­chiska kag­manda. ");
INSERT INTO inb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mai­kan uia­waspa­pas, nuka imasa rimaska­sina mana rurag­kunaka kan­mi mana rumipi utkuspa, chusa alpa­lla­pi wasi­chig­sina. Chitaka, iaku jundaspa, piag­rig­lla­pi urma­chispa, waglli­chispa­mi apá. ");
INSERT INTO inb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chipi kag­kunata Jesús chasa rimaspa, Ka­far­naum pui­bluma rirka. ");
INSERT INTO inb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chipika, Roma­manda achka suldadu­kunata mandagpa iapa ku­ias­ka lutrin, sin­chi ungug siri­kurka, ña wañunga­sina. ");
INSERT INTO inb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesús chaiag­ris­kata uias­paka, chi mandag­ka sug judíu taita­kunata kacharka, mañan­ga­pa: “Ungugta ambi­puag­samu­chu”. ");
INSERT INTO inb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesus­pagma chaiag­ris­paka, chi taita­kunaka, suma mañaspa, nir­ka­kuna: —Chi mandag, alli runa­mi ka. Aida­puai. ");
INSERT INTO inb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nukan­chipa alpa­manda­kunata iapa­mi muná. Paimi nukan­chi tanda­ri­diru wasi­ta­pas saia­chirka. ");
INSERT INTO inb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Chi­ura Jesús, chi runa­kuna­wa rirka. Ña wasima chaia­na­kug­ri­uraka, chi mandagka pai­wa rima­na­ku­diruta kacharka, Jesusta nin­ga­pa: —Taita waugki, mana iapa llaki­ri­puangi. Nuka mana miri­si­ni­chu, kam nuka­pa wasi uku­ma iaikug­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chi­manda­mi nuka kikin kam­bagma mana rirkani, kamta maskan­ga­pa. Chasa­paka, sug rimai­lla ni­puai; nuka­pa ungug ambi­ri­puanga­llami. ");
INSERT INTO inb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nuka­pas, sug­kuna manda­was­ka­pi­mi kani. Chasa­lla­ta nuka­pas, sug suldadu­kuna­ta mandag­mi kani. Mai­kan sul­da­duta nuka “Rii” nisa; chi­ura rin­llami. Ikuti mai­kanta: “Samui” nisa; chi­ura samun­llami. Nuka­pa lutrinta: “Kasa rurai” nisa; chi­ura ruran­llami. ");
INSERT INTO inb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chi rimas­kata uias­paka, Jesús iapa­mi ujna­rirka. Nis­paka, tigra­rispa, chi achka kati­raiag­kunata nirka: —Nukami kasa nii­ki­chita: ñi mai­kan Israel­manda runa, chi mandag­sina suma alli­lla iuia­wag mana tarirka­nichu. ");
INSERT INTO inb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Chi mandag kachas­ka­kuna, wasima kutispa chaiag­ri­uraka, ungug ña ambi­riska kas­kata tarig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chi­ura­manda, Jesús rirka Naín suti pui­bluma. Paita kati­raiag­kuna i iapa achka runa­kuna, pai­wa ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chi pui­blu punguma ña chaiag­ri­ura, kawar­ka­kuna: sug biuda warmipa sug­lla wam­bra iukas­kata, ña wañuska kag­manda, apa­na­kurka pamban­ga­pa. Achka chi pui­blupi kaug­sa­na­kug, sug­lla­pi ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Chasa kawas­paka Iaia Jesuska, chi warmi­manda llaki­rispa, paita nirka: —Mana wakakui. ");
INSERT INTO inb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chasa nis­paka, kailla­iaspa, chaka­nata tupa­rirka. Chi­ura, wandug­kuna saia­rir­ka­kuna. Chi­ura Jesuska, wañus­kata nirka: —Kam musutami niiki: atarii. ");
INSERT INTO inb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chasa nig­lla­pi, wañuska, kaug­sa­rispa, tia­rirka. Nis­paka, rimai kalla­rirka. Jesuska, chasa kaug­sa­chis­paka, paipa mama­wa sakirka. ");
INSERT INTO inb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tukui chasa kawag­kuna, iapa mancha­rispa, Taita Diusta iapa suma atun kagta nir­ka­kuna. Kasa­pas­mi nir­ka­kuna: —Santu Ispi­ri­tu­wa sug atun rimagmi nukan­chipa chaugpipi kawa­rig­samurka. Dius­mi nukan­chita kawan­ga­pa chaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Chasa Jesús ruras­kaka, Judea alpa i chi muiugta tukui­nig­manda iacha­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautista­wa purig­kuna, tukui imasa Jesús ruras­kata kawas­paka, paita willag­rir­ka­kuna. Chasa uias­paka Juanka, iskai kati­raiag­purata kaiaspa, ");
INSERT INTO inb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Iaia Jesus­pagma kacharka, tapun­ga­pa: “¿Kamchu kangi chi samun­ga­pa kaska? Mana kag­pika, ¿sugtachu suia­sun­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chi runa­kunaka, Jesus­pagma chaiag­rispa, nir­ka­kuna: —Nukan­chita, Juan Bau­tis­ta­mi kacha­murka, kamta tapun­ga­pa: “¿Kam­chu kangi chi samun­ga­pa kaska? Mana kag­pika, ¿sugtachu suia­sun­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chi­ura, pai­kuna kawa­na­kug­lla­pi, Jesuska ima ungui­wa kas­ka­kunata ambirka. Kuku waira iai­kus­ka­kunata i mana ñawi kawa­na­kus­ka­ta­pas, achka­kuna­ta­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nis­paka ainir­ka­kunata: —Juanta willag­rii­chi kam­kuna kuna­ura imasa kawaska i uias­kata. Mana ñawi kawag­kuna kawa­na­kumi. Mana purig pudig­kuna­pas, alli­lla­mi puri­nakú. Aicha ismui ungui iukas­ka­kuna­pas­mi ambi­rig­samuska kan­kuna. Mana uiag­kuna­pas­mi alli­lla uia­nakú. Wañus­ka­kuna­pas­mi kaugsa­ri­nakú. Mana ñi ima iukag­kuna­pas­mi Alli Willaita chaski­nakú. ");
INSERT INTO inb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mai­kan nuka­manda suma iuiaita mana sakig­pika, Taita Dius­pa iapa kuiaska­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan kachas­ka­kuna chi­manda ri­ura, Jesuska chipi kag­kunata Juan­manda nirka: —Kam­kuna, chusa sitaska alpapi Juan kaska­ma chaiag­ris­paka, ¿imatak kawag­rirkan­gi­chi? ¿Sug wiru waira­wa paki­chinga­sina kuiu­chi­kus­kata­sinachu kawag­rirkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mana kag­pika, ¿imatak kawag­rirkan­gi­chi? ¿Sug runa iapa suma musu katanga chura­ris­katachu tarig­rirkan­gi­chi? Manima. Chasa suma chura­rig­kuna, mandag­kunapa wasi­kuna­lla­pi­mi iapa suma iuia­chilla kaug­san­kuna. ");
INSERT INTO inb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Chasa kag­pika, ¿imatak kawag­rirkan­gi­chi? ¿Santu Ispi­ri­tu­wa rimagtachu tarig­rirkan­gi­chi? Ari, nii­ki­chitami: Santu Ispi­ri­tu­wa ñugpa­manda rimag­kuna­manda­pas, Juan mas atun­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pai­manda­mi kasa ni­raiá: Kawai. Nuka ima nis­kata willagta kamba ñugpa­mi kacha­kuni, kam­manda ñambi­kunata alli­chi­pun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kasami nii­ki­chita: kai alpapi tukui tiag­samus­ka­kuna­manda, Juan­lla­mi mas atun ka. Chasa kag­pi­pas, Dius suma manda­kus­kapi mai­kan mas uchu­lla­pas, Juan­manda mas atun­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chasa uiaspa, tukui chipi kag­kuna i mana judíu kas­ka­kuna­manda kulki chaskig­kuna Juan baug­ti­saska kag­kuna, iuia­rispa nir­ka­kuna: —Taita Dius, tukuipi iapa alli­mi ka—. ");
INSERT INTO inb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ikuti fari­seo­kuna i Moisés ima nis­kata iacha­chig taita­kuna Juan mana baug­ti­saska kag­kunaka, Taita Dius imasa alli­lla rura­kus­ka­ta­mi wabutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kasapasmi Jesús nirka: —Kai puncha­kuna kaug­sa­na­kuska runa­kunata, ¿imasatak kagta nisa? Kasa nin­trani. ");
INSERT INTO inb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sug wam­bra­kuna kallipi tia­rispa puglla­na­kug­sina­mi kan­kuna. Chipika, pai­pura kapa­ri­nakú: “Nukan­chi flaugta uia­chigpi­pas, mana bailan­gi­chi­chu. Llakispa kantagpi­pas, mana wakan­gi­chi­chu”. ");
INSERT INTO inb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Chasa­lla­ta, Juan Bautista­manda i nuka­manda­mi riman­gi­chi. Juan mana tanda mikug­manda, mana binu upiag­manda­mi kam­kuna nirkan­gi­chi: “Kai runa, kuku waira iai­kuska­mi ka”. ");
INSERT INTO inb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kai Runa Tukuska tukui mikuspa i upiaspa kag­manda, nin­gi­chimi: “Iapa miku­dur i iapa upia­dur­mi ka. Mana judíu kas­ka­kuna­manda kulki chaskig­kuna­wa i mana alli rurag­kuna­wa sug­lla­pi­mi puri­ku”. ");
INSERT INTO inb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Chasa kawaspa nigpi­kuna­pas, Taita Diuska tukui paipa wam­bra­kuna­wa­mi kawa­chí, pai iapa iacha kagta. ");
INSERT INTO inb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sug fari­seo, Jesusta kun­bi­darka, paipa wasipi mikug­rin­ga­pa. Wasima iaikug­ris­paka, Jesús mikun­ga­pa tia­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chi pui­blupi kaug­sa­kurka sug mana alli­lla rurag warmi. Chi war­mika, Jesús fari­seo­pagpi mikun­ga­pa ris­kata iachas­paka, suma asna asiti­wa marmul rumi buti­lla­pi apas­pa­mi chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesuspa wasa­nig­manda kailla­ias­paka, kungu­rirka. Wakaspa, paipa wiki­wa chaki­ta maillarka. Nis­paka, kikinpa agcha­wa tusta­chispa, chaki­kunata mucharka. Chi asiti­ta­pas chaki­pi­mi tallirka. ");
INSERT INTO inb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chasa kawas­paka, chi Jesusta kunbidag fari­seo, iuiaspa, kawa­kurka: “Chi runa, sutipa Santu Ispi­ri­tu­wa rimag kas­paka, iachan­trami, chi tupa­ri­kug warmi mana alli­lla rurag kagta”. ");
INSERT INTO inb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesuska, chi runata nirka: —Simón, muna­kuiki­mi kamta riman­ga­pa. Chi­ura ainirka: —Iacha­chig taita, ni­wai. ");
INSERT INTO inb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chi­ura, Jesuska nirka: —Iskai runa­kunasi kulki maña­chigta dibi­na­kurka. Sug runa, pichka patsa bali kulkisi dibi­kurka. Sugka, pichka chungallasi dibi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nigpi, kuti­chin­ga­pa mana pudi­na­kug­mandaka, kulki maña­chig, iskandi­kunatasi pasin­siarka. —Kuna­ura ni­wai: chi iskandi kulki dibi­na­kugka, ¿mai­kantak maña­chigta mas kuianga? ");
INSERT INTO inb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chi­ura, Simón ainirka: —Nukata rigchawanmi: mai­kan mas achka pasin­siai tukug. —Allillami aini­warkangi— Jesuska nirka. ");
INSERT INTO inb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nis­paka, warmita kawaspa, Simonta nirka: —Kai warmi ima ruras­kata kawarkangi. Nuka kamba wasima iai­ku­uraka, kam mana iaku kara­warkan­gi­chu, chaki mailla­rin­ga­pa. Ikuti kai warmika, wiki­wa­mi chakita mai­lla­warka. Nis­paka, agcha­wa chaki­chi­warka. ");
INSERT INTO inb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kam, “Puan­gi” ni­was­paka, mana mucha­warkan­gi­chu. Ikuti kai warmika, nuka iaiku­ura­manda­ta, chaki­kuna­ta­mi mucha­wai­lla ka. ");
INSERT INTO inb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kam ñi ima asiti mana umapi talli­warkan­gi­chu. Ikuti kai warmika, iapa suma asna asiti­wa chaki­kuna­pi­mi talli­warka. ");
INSERT INTO inb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chi­manda­mi niiki: chasa suma kuia­wag­manda­mi ni­raiá, pai achka panda­ris­kata pasin­siai tukugta. Chasa­lla­ta, mai­kan mailla panda­ris­kata pasin­siai tukugka, mai­lla­mi kuiá. ");
INSERT INTO inb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Chasa nis­paka, chi warmita nirka: —Kam panda­ris­ka­kunata ñami pasin­siaska kangi. ");
INSERT INTO inb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jesus­wa mikun­ga­pa kunbida­na­kuska­pura tapu­ri­na­kurka: —Kai runa, panda­ris­ka­kunata pasin­siag ni­ku; ¿pi­sik ka? ");
INSERT INTO inb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesuska, chi warmita nirka: —Kam nukata iapa alli iuia­wag­manda­mi ña kispi­riska tukurkangi. Rii, mana manchaspa­lla. ");
INSERT INTO inb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chi­ura­manda Jesuska, Dius­pa suma mandai­manda Alli Willaita willaspa, atun i uchulla pui­blu­kunapi puri­kurka. Chunga iskai pai agllaska runa­kunapas, pai­wa sug­lla­pi puri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sug warmi­kuna, kuku waira i ungui iukaspa alia­chis­ka­kuna, paita kati­ra­iar­ka­kuna. Chi warmi­pura kar­ka­kuna: sugka, María, Magdalena suti (chi warmita, kan­chis kuku waira­kuna­ta Jesús llugsi­chiska karka); ");
INSERT INTO inb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","sug­ka, atun mandag Hero­despa wasita kawag Kuza suti runapa warmi, Juana suti; chi­manda, Su­sa­na suti i achka sug warmi­kuna­pas. Tukui chi warmi­kuna, ima iukas­ka­kuna­wa Jesusta aida­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iapa achka runa­kuna, tukui pui­blu­kuna­manda Jesus­pagma tanda­rig­rir­ka­kuna. Chi­ura Jesus­ka, pai­kunata iuiai apinga­sina suma parlarka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Sug runasi llugsirka, similla­kunata sitaspa tarpun­ga­pa. Tar­pu­ku­ura, sug similla­kunaka, ñambipi urmaspa, sarui tukur­ka­kuna. Chi similla­kunataka, pisku­kunasi mikur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","—Sug similla­kunaka, rumilla tias­kapisi urmar­ka­kuna. Tusta alpapi urmaspa, mailla wiña­rispa­lla, lim chaki­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","—Sug similla­kunaka, ispina sacha­kuna tias­kapisi urmar­ka­kuna. Nig­pika, ispina sacha wiñarka, similla­kunata kilpagta. ");
INSERT INTO inb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","—Ikuti sug similla­kunakar, suma alpapisi urmar­ka­kuna. Chasaka, suma wiñaspa, alli­lla palla­rir­ka­kuna. Sug similla­manda­lla, patsa patsasi palla­rirka. Chasa nis­paka, sin­chi kapa­rirka: —Rinri iukag­kuna, nuka nis­ka­ta uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Chi­ura­mandaka kati­raiag­kuna, paita tapur­ka­kuna: —Chi parlu kam iacha­chiska, ¿imatak ni­raiá? ");
INSERT INTO inb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chi­ura Jesuska, kasa ainirka: —Kam­kunata niska­mi ka, Taita Dius imasa suma manda­kuska­sina kas­kata ñi ima­ura­pas mana iachas­kata iachan­ga­pa. Ikuti sug­kuna­taka iuiai apinga­sina parlu­kuna­lla­wa­mi rimani. Chasaka pai­kuna, kawa­na­kuspa­pas, mana kawag­sina­mi kan­kuna. Uia­na­kuspa­pas, mana uiag­sina­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Chi parlu nuka rimas­kaka, kasa­mi ni­raiá. Similla­kuna, Dius­pa Rimaimi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Similla ñambipi urmagka, sug runa Dius­pa Rimaita uiag­sina­mi ni­raiá. Chi uias­kata, iaia kukuka tukuimi kichug­samú; chasaka, mana suma iuiaspa, kispi­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Similla rumilla tias­kapi urmagka, sug runa Dius­pa Rimaita uiag­sina­mi ni­raiá. Chi uianga­lla­waka, alli iuia­chii­wa­mi chaskin­kuna. Nis­paka, imasa­mi chi mana achka angu­iug similla­kuna tukú: chasa­lla­ta sug ratu­lla­mi Taita Dius­wa iuia­rispa kan­kuna. Ima­ura unz̈agpi­kunaka, chi­ura­manda mana mas Taita Dius­wa iuia­rin­ga­pa munan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Similla ispina sacha­kuna tias­kapi urmagka, sug runa Dius­pa Rimaita uiag­sina­mi ni­raiá. Uias­pa­pas, kai alpa­manda­kuna­lla­wa sumag­lla kaug­san­ga­pa iuia­rispa, mas achka iukag tukun­ga­pa iapa munaspa i sumag­lla kai alpapi kaspa, Dius­pa Rimaita tukuimi kunga­rin­kuna. Chasaka, ñi ima mana pallan­ga­pa tia­ringa­sina­mi tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Similla suma alpapi urmag­kar, sug runa Dius­pa Rimaita uiag­sina­mi ni­raiá. Sumag­lla uias­kata suma umapi waka­chi­rispa, mana kunga­rispa­lla­mi kan­kuna. Chi­wanka pai­kuna, Taita Dius­manda alli­lla ruras­ka­kuna­wa mana sakispa­lla, achka palla­rig­sina­mi tukun­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Ñi pipas, ima sindi sindi­chis­paka, manga ukupi u kawitu ukuma mana churan­ga­pa chaian­chu. Awa kawitu­pi­mi churan­ga­pa chaiá, mai­kan iaikug­kunata punchaia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chasa­lla­ta, ima pakalla kaskapas ima­ura­pas­mi iacharí. Ima pakalla waka­chiska­pas­mi ima­ura­pas kawa­rig­samú. ");
INSERT INTO inb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chi­manda, nuka ima rimas­kata suma iuiai­wa uia­wan­gi­chi. Mai­kan achka iukagta mas­mi karan­ga­pa ka. Ikuti mai­kan “Mai­lla­mi iukani” iuia­kus­kataka kichunga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús kaska­ma, paipa mama i waugkindi­kuna chaiag­rir­ka­kuna. Iapa achka runa­kuna chi ukupi kag­manda, manima kailla­ian­ga­pa pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chi­ura sug runa, paita nig­rirka: —Kamba mama i waugkindi­kuna­mi kanchapi kan­kuna. Kamta rimanga­pa­mi muna­nakú. ");
INSERT INTO inb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Paika ainirka: —Dius­pa Rimaita uiaspa rurag­kuna­mi nuka­pa mama i nuka­pa waug­ki­kuna ni­raian­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sug puncha­kuna Jesús, kanua­pi iai­kurka, paita kati­raiag­kuna­wan­ta. Nis­paka, pai­kunata nirka: —Akushi. Kai kuchata chimba­sun­chi. Nispa, ña rii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ña iaku chimba­na­kus­kapi, Jesús puñu­rig­samurka. Chi­ura iapa sin­chi waira, chi kuchapi ata­rii kalla­rirka. Chi­wanka, kanua ukuma iaku ña iaiku­kurka. ");
INSERT INTO inb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesusta kati­raiag­kuna, paita rigcha­chir­ka­kuna, kasa nispa: —Iacha­chig taita, iacha­chig taita, wañunga­pa­mi kan­chi. Jesuska, rigcha­rispa, wairata i iakuta piñarka. Chasa piña­uraka, tukui alli­lla­mi kasillaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chi­ura Jesuska, kati­raiag­kunata nirka: —¿Manarachu nuka­manda suma iuia­waspa rigsi­wan­gi­chi? Chi­ura, iapa mancha­rispa ujna­rispa­mi pai­pura tapu­ri­na­kurka: —Kai runa, ¿ima­sik ka? Waira i iakupas, paita uian­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kucha ialis­paka, Gali­lea sug ladu chimba chaiag­rir­ka­kuna Je­ra­sa suti alpama. ");
INSERT INTO inb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús ña kanua­manda alpama urai­ku­ku­uraka, chi pui­blu­manda sug runa kuku waira­kuna iai­kuska, paita tupag­rirka. Chi runa, ña unai ñi ima katanga mana chura­riska karka. Ñi ima wasipi mana kaug­sa­kurka. Wañus­ka­kuna pamba­raias­ka­pi­mi karka. ");
INSERT INTO inb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chi runaka, Jesusta kawas­paka, kapa­rispa, paipa ñugpa ladu kungu­rig­rirka. Sin­chi rimai­wa nirka: —Ai, kam tukui­manda mas atun Taita Dius­pa wam­bra Jesús, ¿ima­pa­tak nuka kaska­ma samu­kungi? Mañaikimi: mana nukata sungu nanagta llaki­chi­wa­kug­samui. ");
INSERT INTO inb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús, chi kuku wairata ñami niska karka: “Chi runa­manda llugsii”. Chi­manda­mi chasa nirka. (Chi runata, kuku waira­kuna achka biajisi apiska kar­ka­kuna. Chi­manda, paita makipi i chakipi sin­chi kadina­kuna­wa wataspa, alli­lla chari­dur kar­ka­kuna. Chasa chari­na­kugpi­pas, kuku waira­kuna, kadina­kunata piti­chispa, chusa sitaska alpama paita apa­dur kar­ka­kuna.) ");
INSERT INTO inb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Chi­ura Jesuska, chi runata tapurka: —Kam, ¿imatak suti kangi? Chi­ura ainirka: —Nuka, achka waran­ga­kuna­mi suti kani—. Iapa achka kuku waira­kuna paita iai­kuska kaspa­mi chasa ainirka. ");
INSERT INTO inb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Chi­ura chi runapa kag kuku waira­kunaka, Jesusta mañai kalla­rir­ka­kuna: —Mana nukan­chita kacha­kui, chi iapa jiru alpa ukuma ikuti rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chi ladira ladu­lla­pi, iapa achka kuchi­kuna mikuspa puri­na­kurka. Nig­pika, chi runapi kag kuku waira­kunaka Jesusta mañar­ka­kuna, kasa nispa: —Nukan­chita sakii, chi kuchi­kunapa ukuma iaikug­rin­ga­pa. Chi­ura, Jesuska sakirka, chasa tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Chasaka chi kuku waira­kunaka, ña runa­manda llugsispa, kuchi­kunapa ukuma iaikug­rir­ka­kuna. Chi­wanka tukui kuchi­kuna, iapa saia patata kalpaspa, kucha iaku ukuma sita­rig­rir­ka­kuna. Chipi chuka­rispa, tukui puchuka­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kuchi­kunata kawag­kuna, imasa pasa­ris­kata kawas­paka, miti­kuspa, pui­blu­nigta i ñambi­nigta suiu parlaspa purig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Chasa uiag­kunaka rir­ka­kuna, imasa pasa­ris­kata kawan­ga­pa. Jesus­pagma chaiag­ris­paka, chi kuku waira­kunata llugsi­chii tukuska runata tarig­rir­ka­kuna. Paipa iuiai ña alli­lla, suma katanga chura­riska, Jesuspa chaki ladu tia­kus­kata tarig­rir­ka­kuna. Chasa kawas­paka, iapa mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chi kuku waira­kuna iukaska runata imasa alia­chiska kas­kata kawag­kuna­pas willar­ka­kunata imasa pasa­rigta. ");
INSERT INTO inb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chi­ura chi alpa­nig­manda tukui uiag­kunaka, asku­rinti manchai­wa kaspa, Jesus­pagma kailla­iaspa, nir­ka­kuna: —Nukan­chipa alpa­manda llugsi­puai. Chasa uias­paka Jesús, kanuama iai­kuspa, kutirka. ");
INSERT INTO inb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Manara rig­lla­pi, chi kuku waira­kuna llugsi­chii tukuska runa, paita mañai kalla­rirka: —Nuka­ta­pas pusawai. Jesuska, paita ainirka: ");
INSERT INTO inb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kamba wasima rii. Willag­rii, kamta imasa Taita Dius alli­lla ruraspa sakigta. Chi­ura chi runa, rispa, imasa Jesús paita alli­lla ruras­kata chi pui­blu suiu willaspa purig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús kutispa chaiag­ri­uraka, tukui paita suia­na­kug sumag­lla chaskir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Sug tanda­ri­diru wasi­manda taita Jairo suti­pas­mi chaiag­rirka. Chi taitaka, sug­lla warmi wam­bra iukarka, chunga iskai wata­iug. Chi wam­braka ña wañu­pu­kurka. Chaiag­ris­paka, Jesusta kungu­rispa, mañarka: —Nuka­pa wasima ri­puai. Jesús chi taita­wa paipa wasima ri­kus­kapika, achka runa­kuna paita tanga­na­kui­wan­ta kati kati ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kati­chi­na­kug­pura sug warmimi sug­lla­pi ri­kurka. Chi warmi, chunga iskai wata iawar sitai­wa ungug karka. Tukui ima iukas­kata tuku­chigpi­pas, ñi mai­kan ambig­kuna­pas manima ambir­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chi warmika, Jesusta kati kati kailla­iaspa, paipa katanga puntapi llamkarka. Llamkag­lla­pi, chi ungui ambi­rirka. ");
INSERT INTO inb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Chi­ura, Jesuska tapurka: —¿Pitak llamka­warka? Tukui­kuna: “Ñi pipas manima” aini­ura, Pedro nirka: —Iacha­chig taita, ¿mana­chu tukui­kuna, tanga­na­kui­wan­ta kam­ta kati­raia­nakú? ");
INSERT INTO inb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesuska nirka: —Nuka­pa iachaitami aisagta iuia­chi­ri­warka. Chi­wa­mi iachani, mai­kan ima iuiaspa llamka­wagta. ");
INSERT INTO inb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Chi­ura chi ambi­rig warmika, Jesús imasa iachas­kata uias­paka, chugchuspa kailla­iaspa, Jesusta kungu­rispa, tukui­kunapa ñawipi willa­rirka, imapa Jesusta llam­kagta i imasa llamkag­lla­pi ungui ña ambi­rig­samugta. ");
INSERT INTO inb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Chi­ura, Jesus­ka nirka: —Kam warmisita, nuka­manda suma iuia­ris­ka­manda­mi ambi­rig­samurkangi. Rii, mana man­chas­pa­lla. ");
INSERT INTO inb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús chara rima­kug­lla­pi, sug runa, chi taitapa wasi­manda chaiag­rispa, nirka: —Kamba wam­bra, ñami wa­ñur­ka. Mana mas kai iacha­chig taitata ima­pas maña­kui. ");
INSERT INTO inb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesuska, chasa uiaspa, chi taitata nirka: —Mana llaki­kui. Nuka­manda suma iuia­wai. Ungugka ambi­ri­pun­kangimi. ");
INSERT INTO inb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wasima chaiag­ris­paka, Jesús mana tukui­kunata sakirka iaikun­ga­pa. Pedro, Juan, Santiago i wam­brapa taita i mamandilla, pai­kuna pai­lla­wa iai­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tukui chipi kag­kuna, wañuska kag­manda iuia­rispa, waka­na­kurka. Jesuska nirka: —Mana waka­na­kui­chi. Chi wam­bra mana wañuska kan­chu. Puñui­lla­mi puñu­ku. ");
INSERT INTO inb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Uiag­kuna, tim wañuska kagta alli­lla iachas­paka, paita asir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesuska, chi wañus­kata maki­manda apispa, sin­chi kapa­rispa, nirka: —Wam­brita, atarii. ");
INSERT INTO inb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Chasa nig­lla­pi, alma ikuti samuspa, kaugsa­rig­samurka. Nis­paka ata­rirka. Chi­ura, Jesuska nirka: —Wam­britata mikui karai­chi. ");
INSERT INTO inb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chasa kawas­paka, wam­brapa atun­kuna iapa ujna­rir­ka­kuna. Jesuska nir­ka­kunata: —Chasa kawas­kata, ¡ujala­lla­pas sug­kunata willa­na­kun­gi­chi! ");
INSERT INTO inb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Chi­ura­manda Jesuska, chi chunga iskai pai agllas­ka­kuna­ta kaiaspa, paipa iapa iachaita kararka, pai­kuna­pas kuku waira­kunata llugsi­chii i ungui­wa kas­ka­kunata ambii pudin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nis­paka kachar­ka­kunata, Dius­pa suma man­dai­manda willan­ga­pa i ungug­kunata ambin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kacha­kus­pa­ka, nirka: —Mana apa­na­kui­chi tawina, ñi jigra, ñi tanda kukawi ñi ima kulkipas ñambipa. Katanga­pas, imasa chura­riska kaska­lla­wa rii­chi. ");
INSERT INTO inb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mai­kan wasipi iai­kus­paka, chi wasi­lla­pi kan­gi­chi, chi pui­blu­manda sug­sinama llugsin­kama. ");
INSERT INTO inb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ikuti maipi kam­kunata mana chaskin­ga­pa muna­na­kuska­pag­pika, chi pui­blu­manda llugsi­kuspa, chakipi alpa lluta­raias­kata chabsispa, pai­kunata willag­sina kawa­chin­gi­chi, mana alli rurag kagta­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Chi kachai tukus­ka­kunaka, Alli Willaita willaspa i ungug­kunata ambispa, chi pui­blu suiu purig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mandag Herodes, Jesús tukui imasa rura­kugta uiaspa, pai­manda mana iacharka imasa iuia­ringa. Sug­kuna, Jesus­manda ni­na­kurka: —Chimi kan­ga­pa ka Juan Bau­tista. Wañus­paka, ikuti kaug­sa­ris­ka­mi kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sug­kunaka ni­na­kurka: —Ñugpa­manda Santu Ispi­ri­tu­wa rimag Eliaschar ikuti kawa­rig­samurka. Ikuti sug­kunaka ni­na­kurka: —Mai­kan ñugpa­manda Santu Ispi­ri­tu­wa rimagchar kaugsa­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodeska ni­kurka: —Nuka kikinmi Juanta uma anchu­chin­ga­pa kacharkani. Chi­wanka, chi tukui ima ruras­kata uiaspa, pai­manda nuka ni­nimi: “¿Pi­sik ka?”—. Chi­manda muna­kurka, Jesusta rigsin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús kachaska runa­kuna, pai­pagma ikuti chaiag­ris­paka, imasa ruraspa puriska willag­rir­ka­kuna. Chi­ura­manda Jesuska, pai­kuna­lla­ta pusaspa, Betsaida suti pui­blu kuchumalla rirka, ñi mai­kan runa­pas mana kaug­sa­na­kuska­ma, pai­kuna­lla­wa kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Chasa iachas­paka, achka runa­kuna kati­chir­ka­kuna. Chi­ura Jesuska, chi kati­chi­na­kus­kata sumag­lla kaiaspa, Dius­pa suma mandai­manda iacha­chir­ka­kunata. Tukui chipi ungui­wa kas­ka­kuna­ta­pas­mi ambirka. ");
INSERT INTO inb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ña chisia­ku­uraka, chunga iskai Jesús agllas­ka­kuna, pai­pagma kailla­iaspa, nir­ka­kuna: —Kai runa­kunata kachai kai suiu­lla kaug­sa­na­kuska wasi­kuna­ma, mikui maskag­rispa puñug­ri­chu­kuna. Nukan­chi kaipi kas­kapi, ñi pipas mana kaug­san­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesuska nir­ka­kunata: —Kam­kuna, pai­kunata mikui karai­chi. Pai­kunaka ainir­ka­kuna: —Pichka tanda i iskai chalwa­lla­mi kaipi iukan­chi. Mana kag­pika, chaia­kunchar kai tukui­kuna­manda mikui randig­rin­ga­pa—. ");
INSERT INTO inb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mai pichka waranga kari­kuna­mi chipi kar­ka­kuna. Chi­ura Jesuska, kati­raiag­kunata nirka: —Pai­kunata mai pichka chunga pichka chunga tia­ri­chii­chi. ");
INSERT INTO inb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pai­kuna uias­paka, chasa rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nigpi Jesuska, chi pichka tandata i iskai chalwata chari­rispa, awa­sinama kawaspa, “Pai Siñur” Taita Diusta nirka. Chi mikui­kunata piti­chis­paka, kati­raiag­kunata kuaspa aparka, pai­kuna tukui­kunata karaspa richingapa. ");
INSERT INTO inb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tukui­kuna­mi sag­sagta mikur­ka­kuna. Nis­paka, chunga iskai saparu junda piti piti­kuna tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sug puncha Jesús, Taita Diusta rima­kurka, kati­raiag­kuna­lla­wa sug­lla­pi kaspa. Nis­paka, pai­kunata tapurka: —Mai­kan­kuna nuka­manda, ¿pi kagtatak nin­kuna? ");
INSERT INTO inb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pai­kunaka ainir­ka­kuna: —Sug­kuna nin­kunami: kam kangisi Juan Bautista. Sug­kunaka: kam ñugpa­manda rimag Elías; ikuti sug­kunaka: mai­kan ñugpa­manda Santu Ispi­ri­tu­wa rimag kaugsa­riskasi kangi. ");
INSERT INTO inb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chi­ura, Jesuska tapur­ka­kunata: —Kam­kunaka nuka­manda, ¿pi kagtatak ni­wan­gi­chi? Chasa tapu­ura, Pedroka ainirka: —Taita Dius kikin agllaska Cris­to­mi kangi. ");
INSERT INTO inb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedro chasa ni­ura, Jesuska pai­kunata nirka: —Mana pi­ta­pas nuka­manda chasa willa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kasapasmi Jesús nir­ka­kunata: —Kai Runa Tukus­kataka iapa llakii i nanai iukanga­pa­mi chaia­wa­ku. Iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas wabu­ti­wanga­pa­mi kan­kuna. Nuka­ta wañu­chi­wanga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa punchapika ikutimi kaug­sa­rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chasa nis­paka, tukui­kunata nirka: —Mai­kan nukata kati­raia­wan­ga­pa munagka, kikin­manda kunga­richu. Tukui puncha­kuna, paipa krusta marka­rig­sina ruras­pa­mi iuká kati­raia­wanga. ");
INSERT INTO inb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mai­kan kikinpa kaug­saita kispi­chinga­pag­lla iuia­kug­pika, kikin­mi puchuka­rin­ga­pa ka. Ikuti mai­kan nuka­manda wañu­chii tukug­pika, mana mas wañui kaug­sai­ta­mi tarin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—Sug runa tukui kai alpapi ima munaska iukagpi­pas, paipa almata mana kispi­chig­pika, chi iukas­ka­kuna ñi imapa mana bali­pun­ga­pa kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kai Runa Tukuska samu­ura, nuka­pa i nuka Taitapa i tukuipi alli anjil­kunapa suma atun­ia­chis­ka­wa­mi samun­ga­pa ka. Chi punchaka, mai­kan­pas nuka­manda i nuka­pa rimai­kunata wabutispa, “Mana rigsi­nichu” nig­kunata, nuka­pas­mi chasa­lla­ta nin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nuka­mi kasa nii­ki­chi­ta: mai­kan kaipi kag­kuna manara wañug­kuna, Taita Dius­pa suma mandai­ta­mi kawan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chasa niska­ura­manda mai pusag punchapika, Jesuska, Pedro­ta, Juanta i Santiagota pusaspa, sug awa lumama sikag­rirka, Taita Dius­wa rima­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús chasa rima­kun­kamaka, paipa ñawi, sug rigcha kawa­rimi tukug­samurka. Paipa katanga­pas, iapa iura puncha­lla­mi tukurka. ");
INSERT INTO inb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chi­uraka iskai ñugpa­manda runa­kuna, Moisés i Elías suti, kawa­rig­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Chi runa­kunaka, Taita Dius­pa suma puncha­ia­chii­wa kawa­rispa, Jesus­wa rima­na­kui kalla­rir­ka­kuna. Jesusta imasa Jeru­salenpi wañu­chin­ga­pa kas­ka­ta­mi rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro i pai­wa kag­kuna, iapa puñui­wa kaspa­pas, mana puñu­rir­ka­kuna. Jesús chasa puncha­iai­wa kas­kata i chi iskandi runa­kunata kawar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chi runa­kuna Jesus­wa kas­ka­manda ña anchu­ri­na­ku­uraka, Pedroka Jesus­ta nirka: —Iacha­chig taita, kaipi iapa alli iuia­chi­mi kan­chi. Kimsa tambu kaipi rura­sun­chi: kam­manda sug, Moises­manda sug, sugka Elias­manda—. Mana ima­pas iuia­rispa­lla­mi Pedro chasa nirka. ");
INSERT INTO inb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chasa rima­kug­lla­pika, puiulla pai­kunata kilpag­samurka. Chi puiu kilpa­ura, mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Puiu uku­mandaka sug rimagta uia­rig­samurka, kasa nispa: —Kai, nuka­pa agllaska wam­bra­mi ka­puá. Paita uia­puan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chi rimai uia­rig­samu­ura, Jesus­ka ikuti sapalla kawa­rig­sa­mur­ka­kunata. Pai­kuna chasa kawas­kata chi­ura­kuna ñi pita mana willar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kaiandika chi luma­manda urai­ku­ura, iapa achka runa­kuna Jesusta tupag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chipi kag­kuna­pura­manda sug runaka, kapa­rispa nirka: —Iacha­chig taita, nuka­pa wam­brata kawa­puai. Pai, sug­lla wam­bra­mi ka­puá. ");
INSERT INTO inb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paita, sug kuku waira iai­kuspa, diulpi­lla­mi kapa­ri­chi­puá. Kaima chi­ma­mi chabsi­chi­puá. Simi­manda­pas tuka­lla­mi jundaspa sita­puá. Iapa tukuipi nana­chis­paka, mailla mai­lla­mi anchurí. ");
INSERT INTO inb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chi­manda­mi kamta kati­raiag­kunata mañag­samurkani: “Chi kuku wairata llugsi­chi­puai­chi”. Nig­pika, pai­kuna manima llugsi­chi­puan­ga­pa pudir­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesuska, pai­kunata nirka: —¡Ai, kam mana alli runa­kuna, Taita Dius­wa ñi ima mana iuiag­kuna­mi kan­gi­chi! ¿Ima­ura­kamatak kam­kunata chasa chari­na­kusa­ki­chita?—. Chasa nis­paka, wam­brapa taitataka nirka— Kamba wam­brata kaima pusamui. ");
INSERT INTO inb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chi wam­bra ña kailla­ia­ku­ura, kuku wairaka, paita ikuti chab­si­chispa, alpama urma­chispa, kaima chima aparka. Chi­ura Jesus­ka, kuku wairata sin­chi piñaspa, llugsi­chirka. Wam­brata ambis­paka, paipa taitata kuti­chirka. ");
INSERT INTO inb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chi­wanka tukui chipi kag­kuna, Taita Dius­pa iapa suma iachai­wa imasa rura­kus­kata kawaspa, iapa ujna­rir­ka­kuna. Tukui­kuna imasa Jesús rura­kus­kata ujna­rispa kawa­na­ku­ura, paika kati­raiag­kunata nirka: ");
INSERT INTO inb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Kai nuka ima willa­kus­kata suma uiaspa, mana kunga­rin­gi­chi. Kai Runa Tukus­kaka, mana alli runa­kuna­pag­ma­mi chaia­chii tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Chasa nis­kata uias­paka, kati­raiag­kuna mana iachar­ka­kuna ima ni­raiagta, Taita Dius pai­kunapa iuiai­ta pakaska­sina chari­kug­manda. Chi uias­kata mana iachas­pa­pas, manchaspa kar­ka­kuna, ima ni­raiagta Jesusta tapun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Chi­ura­manda Jesusta kati­raiag­kunaka, pai­pura rima­ri­na­kurka, kasa nispa: —¿Pi­sik mas atun taita tukuska ni­raian­chi?. ");
INSERT INTO inb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chi­manda Jesuska, imasa iuia­na­kus­kata iachas­paka, sug uchulla wam­brata kaiaspa, paipa ladu­lla­pi saia­chirka. ");
INSERT INTO inb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nis­paka, paita kati­raiag­kunata nirka: —Mai­kan­pas kai uchu­lla­ta­sina nuka­manda iuia­rispa chaskig­pika, nukata chaski­wag­sina­mi rurá. Chasa chaski­was­paka, nukata kacha­mu­wag­ta­pas­mi chaskig ni­raiá. Kam­kuna­pas mai­kan tukui­kuna­manda mas uchulla tukugka, mas atun­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Chi­ura, Juanka nirka: —Iacha­chig taita, sug runa kam­ba suti­wa­mi kuku waira­kunata llugsi­chi­kugta kawarkan­chi. Pai mana nukan­chi­wa sug­lla­pi purig kag­manda, nukan­chika nirkan­chimi: “Mana chasa rura­kui”. ");
INSERT INTO inb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesuska, paita ainirka: —Ianga kawan­gi­chi. Mai­kan­pas mana kam­kunata piñag­kuna, kam­kuna­wa suma iuiai­wa­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús ña suma luarma sikan­ga­pa puncha chaia­ku­uraka, pai ñi ima mana manchaspa­lla Jeru­salenma rirka. ");
INSERT INTO inb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ri­kus­ka­mandaka, sug­kunata ñugpa kacharka, “Ñami samu­ku” willan­ga­pa. Chi kachai tukus­ka­kuna, Sama­ria alpapi sug pui­bluma chaiag­rir­ka­kuna, Jesus­manda pusada maña­pun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Chi­manda runa­kunaka, Jesús Jeru­salenma ri­kugta iachas­paka, mana munar­ka­kuna paita chaskin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Chasa kawas­paka, Santiago i Juan suti Jesusta kati­raiag­kuna tapur­ka­kuna: —Taita waugki, ¿munangichu, nukan­chi mañan­ga­pa: “Awa­nig­manda nina kacha­mu­wai, pai­kunata puchukan­ga­pa”? ");
INSERT INTO inb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesuska, tigra­rispa, pai iskan­di­kunata piñarka. ");
INSERT INTO inb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chi­ura­manda, sug pui­bluma rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ñambi ri­na­kus­kapi, sug runa, kailla­iaspa, Jesusta nirka: —Taita waugki, kamta kati­sa­kimi maima kam ri­kuska­ma. ");
INSERT INTO inb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesuska ainirka: —Chucha­kuna, kuiba­kuna­mi iukan­kuna, pai­kuna kaug­san­ga­pa. Pisku­kuna­pas, tasinwa suma alli­chiska wasimi iukan­kuna. Ikuti kai Runa Tukus­kaka mana iukan­chu, ñi mai­pipas sama­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nis­paka, sug runata nirka: —Kati­wai. Chika ainirka: —Taita waugki, ñugpa saki­wai, nuka­pa taitata pambag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesuska nirka: —Nukata mana iuia­ri­wag­kuna pamba­chu­kuna. Kamka riilla, Dius­pa suma mandai­manda runa­kunata willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ikuti sugka, Jesusta nirka: —Taita waugki, kamta katin­ga­pa­mi muna­kuiki. Ñugpa saki­wai; nuka­pa wasipi kag­kunata: “Kaia­kama” nig­risa. ");
INSERT INTO inb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesuska ainirka: —Mai­kan, ñugpa­sinama tra­ba­jaspa ri­kuspa, kati­sinama kawag­ka, mana balin­chu, Dius­pa suma mandai­manda willag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chi­ura­manda Iaia Jesus­ka, sug kan­chis chunga iskai runa­kunata agllas­paka, tukui pui­blu i wasi­kunama pai rin­ga­pa kas­ka­ma iskai iskai ñugpa kacharka. ");
INSERT INTO inb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kacha­kus­paka, kasa­mi nirka: —Pallan­ga­paka, ach­ka­mi tia. Nig­pika pallag­kunaka, mai­lla­mi tian­kuna. Chi pallaika, atun Taita Dius­pa chagra­sina­mi ka. Chi­manda, paita mañai­chi, achka pallag­kuna kacha­muchu. ");
INSERT INTO inb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Kam­kuna rii­chilla. Kam­kunata ubija­kunata­sina sacha alku kaug­sa­na­kuska­sina­ma­mi kacha­na­kui­ki­chita. ");
INSERT INTO inb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mana puri­chii­chi kulki waka­chi­diru, ñi jigra ñi chaki­kunapi chura­ri­dirupas. Mana ñambipi saia­rispa, pi­wapas ianga parla­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Mai­kan wasi­pipas iai­kus­pa­ka, ñugpa nin­gi­chi: “Puangi. Sumag­lla alli­lla ka­puai­chi”. ");
INSERT INTO inb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chi wasipi sutipa sumag­lla iuiai­wa kaug­sa­na­kug­pika, chasa nis­ka­manda, pai­kunata tukuipi alli­lla­mi tukug­samun­ga­kunata. Ikuti mana sumag­lla chi wasipi kaug­sa­na­kug­pika, chasa nigpi­pas, pai­kunata mana alli­lla tukug­samun­ga­kunata­chu. ");
INSERT INTO inb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—Mai­kan wasipi kam­kunata chaskig­pika, chi wasi­lla­pi kan­gi­chi, ima karas­kata mikuspa i upiaspa. Mai­kan trabajag­kunata chaian­mi, mikui u ima minis­tiska pai­kuna chaskin­ga­pa. Mana wasi wasi puri­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mai­kan pui­bluma kam­kuna chaiag­ris­kapi kaia­chu­kuna: pai­kuna ima karas­kata mikun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chipi ungui­wa kas­ka­kunata ambin­gi­chi. Pai­kunata willan­gi­chi: “Dius­pa suma mandai, kam­kuna­pagma ñami chaia­mu­ku”. ");
INSERT INTO inb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Ikuti mai­kan pui­blupi kam­kunata mana chaskin­ga­pa muna­chu­kuna: kalli­kunama llugsispa, nin­gi­chi: ");
INSERT INTO inb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kam­kunapa pui­blu­manda alpa chakipi lluta­raias­ka­ta chabsi­chin­chimi. Chasaka, kam­kuna mana alli rurag kagta­kuna­mi kawa­chin­chi. Chasa kagpi­kuna­pas, kasa­mi willai­ki­chita: Dius­pa suma mandai, ñami chaia­mu­ku”. ");
INSERT INTO inb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kasa­mi nii­ki­chita: Taita Dius jus­ti­siai ruran­ga­pa puncha chaia­uraka, Sodoma pui­blu­manda runa­kunata llaki­chis­ka­manda­pas masmi chi pui­blu­kuna­manda runa­kuna llakii iukan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—¡Ai, kam­kuna Korazín suti pui­blupi kaug­sag­kuna! ¡Ai, kam­kuna Betsaida pui­blupi kaug­sag­kuna! Tiro i Sidón suti pui­blu­kuna­manda runa­kuna, imasa kam­kunapa pui­blu­kunapi chi­tuku mana ima­ura­pas kawaska­sina ruras­kata kawas­paka, chi­ura­lla­mi pai­kunaka, llakii­wa iana katan­ga­kuna chura­rispa, uchpa­wa umapi arma­rispa, alli rurai­kunama tigraska kan­tra­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Taita Dius jus­ti­siai ruran­ga­pa puncha chaia­uraka, Tiro i Sidón pui­blu­kuna­manda runa­kunata llaki­chis­ka­manda mas­mi kam­kuna llakii iukan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Kam­kuna, Ka­far­naum pui­blu­manda­kunaka, ¿imapatak iuia­na­kun­gi­chi: “Sug luar­pi­mi atun­ia­chii tukun­ga­pa kani”? Manima. Dil­tudupa nina­ma­mi sitai tukun­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kasapasmi kati­raiag­kunata nirka: —Mai­kan kam­kunata uiag­kunaka, nuka kikin­ta­mi uia­wan­kuna. Mai­kan kam­kunata wabutig­kunaka, nuka­ta­mi wabuti­wan­kuna. Chasa wabuti­was­paka, nukata kacha­mu­wag­ta­pas­mi wabutig ni­raian­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chi kan­chis chunga iskai Jesús kachaska runa­kunaka, iapa suma alli iuia­chii­wa kutispa, chaiag­rir­ka­kuna, kasa nispa: —Taita waugki, kuku waira­kuna­pas­mi kamba suti­wa nukan­chita uiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesuska nirka: —Ari, chi­ura iaia kuku rilampa­sina awa­manda urmag­ta­mi kawar­ka­ni. ");
INSERT INTO inb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nuka­pa iapa iachai­ta­mi kararkai­ki­chita, kulibra­kunata i alakran­kuna­ta­pas sarugpi, kam­kunata ñi ima­pas mana tukun­ga­pa; chasa­lla­ta, iaia kuku tukuipi ima mana alli­lla rurai munas­ka­ta­pas binsii pudin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Chasa kagpi­pas, kam­kunata kuku waira­kuna uiag­manda­lla, mana iuia­na­kun­gi­chi, suma alli­lla iuia­chii­wa kan­ga­pa. Kam­kuna ima suti kaska, suma luar­manda librupi willa­raias­ka­manda­mi iukan­gi­chi iapa kun­tin­ta­rispa kan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesús, Santu Ispi­ri­tu­wa suma alli iuia­chii­wa kaspa, chi­ura­lla nirka: —Taitiku, suma luar i kai alpa luarta iaia mandag­mi kangi. Kamta iapa suma atun kag­ta­mi niiki. Kam­bagma iaikug­rin­ga­pa, iacha i iapa iuiai­iug runa­kuna­manda pakaska­sina­mi ka­pungi. Ikuti mana iacha i mana iapa iuiai­iug­kuna­ta­mi kawa­chirkangi. Ari, Taita, chasa­mi kam munarkangi. ");
INSERT INTO inb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kasapasmi Jesús nirka: —Nuka­pa Taita, tukuimi nuka­ta kara­waska ka. Paipa wam­bra nuka kagta, ñi mai­kan runa­pas mana iachan­kuna­chu. Nuka­pa Taita­lla­mi rigsiwá. Chasa­lla­ta, nuka­pa Taitata mana pipas rigsin­kuna­chu. Nuka­lla­mi rigsini, paipa wam­bra kaspa. Mai­kan nuka munas­ka­kuna­lla­mi nuka­pa Taitata rigsin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chasa nis­paka, tigra­rispa, paita kati­raiag­kuna­lla­ta nirka: —Mai­kan kam­kuna kuna­ura kawa­na­kuska kawag­kuna, Taita Dius­pa iapa kuiaska­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kasa­pas­mi nii­ki­chita: ñugpa­manda Santu Ispi­ri­tu­wa rimag­kuna i atun mandag­kuna, achka­kuna­mi, kuna­ura kam­kuna kawa­na­kus­kata kawan­ga­pa muna­na­kuspa­pas, mana kawar­ka­kuna. Chasa­lla­ta, kuna­ura kam­kuna uia­na­kus­kata uian­ga­pa muna­na­kuspa­pas, mani­ma uiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tia­na­kuska­manda, Moisés ima nis­kata sug iacha­chig taita saia­rirka. Chi runaka, Jesusta panda­chin­ga­pa iuiai­wa tapurka: —Iacha­chig taita, ¿imasatak iukani ruranga, mana puchuka­ri­diru suma kaug­saita tarin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chi­ura, Jesús tapurka: —Moisés ima willa­raias­kapi, ¿ima­tak ruran­ga­pa ni­raiá? Willa­wai. ");
INSERT INTO inb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chi­ura, chi runaka ainirka: —“Kamba atun Taita Diusta kuiangi kam kikinpa sungu­wa, alma­wa, tukui animu­wa i tukui iuiai­kuna­wa. Kam kikinta­sina­mi iukangi, tukui runa­kuna­ta­pas kuianga”. ");
INSERT INTO inb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Chi­ura, Jesús nirka: —Allillami aini­wangi. Chasa ruras­pa­mi alli suma kaug­saita iukankangi. ");
INSERT INTO inb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Chi runaka, alli­lla iuiai­iug kagta kawa­chi­rin­ga­pa, Jesusta tapurka: —¿Pitak nuka­pa waugki­sina ni­raiá? ");
INSERT INTO inb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Chi­ura, Jesuska ainirka: —Sug runa Jeru­salen­manda Jerikó pui­bluma ñambi ri­kus­kata, sisai­kuna apispa, tukui ima apa­kus­kata katanga­wan­ta ki­chus­pa, ñalla wañunaiagta lisia­chispa­si sakir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chasa ka­uraka, sug sasir­dutisi chi ñambi­lla­pita ri­kurka. Chi runaka, ñalla wañu­kuska runata kawas­paka, muiuspa ialirka. ");
INSERT INTO inb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nis­paka, Dius­pa atun wasipi aidag­pas­si chi­lla­tata ri­kurka. Chi runa­pas, ñalla wañu­kugta kawas­paka, muiuspa ialirka. ");
INSERT INTO inb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kipama, Sama­ria alpa­manda sug runasi, chi ñambi­lla­pita ri­kuspa, wañu­kuska­pagma chaiag­rirka. Chi runa­kar, kawaspa, pai­manda llaki­rirka. ");
INSERT INTO inb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pai­pagma kailla­iaspa, wira i binu­wa pias­ka­kunapi ambispa, watarka. Atari­chispa, kikinpa burupi tia­ri­chispa, pusarka. Pusada maña­chi­diru wasima chaia­chig­ris­paka, sumag­lla siri­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kaian­dika, sugma ri­kuspa, wasi maña­chigta iskai puncha­pa kulki surkuspa kuarka, kasa nispa: “Kai runata suma kawa­puangi. Kai kulki sakiska pisig­pika, nuka kuti­mu­ura kua­sa­kimi”. ");
INSERT INTO inb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chasa parlas­paka, Jesuska tapurka: —¿Imasatak kamta rigchá? Sisai­kuna apiska wañu­kus­kapika, chi kimsandi­kuna­manda, ¿mai­kan­tak waugkindi­sina kawarí? ");
INSERT INTO inb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chi­ura, chi runa ainirka: —Mai­kan pai­manda llaki­rispa ambig. Chasa aini­ura, Jesuska nirka: —Riilla. Kampas, chasa­lla­ta rurag­rii. ");
INSERT INTO inb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ñambi ri­kuspa, sug uchulla pui­bluma chaiag­rirka. Chipika Marta suti warmi, Jesusta paipa wasipi sumag­lla kaiarka. ");
INSERT INTO inb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Chi warmi iukarka María suti ñaña. Mariaka, Iaia Jesuspa chaki ladu tia­rispa, ima rima­kus­kata uia­kurka. ");
INSERT INTO inb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaka, achka rurai­kuna­wa kaspa, puri­ri­kurka, tukui rurai­kunata sapalla ruraspa. Nis­paka, Jesus­pagma kailla­iaspa, nirka: —Taita turi, ¿mana­chu llakingi, nuka­pa ñaña kai tukui ima ruran­ga­pa nuka­lla­ta saki­wagta? Ni­puai aida­wachu. ");
INSERT INTO inb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Iaia Jesuska ainirka: —Kam Marta, achka rurai­kuna iukaspa, iapa llakispa iuiai­kuna­wa­mi puri­ri­kungi. ");
INSERT INTO inb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nuka niikimi: sug­lla­mi tukui­kuna­manda mas minis­tidu ka. Chi mas minis­tis­ka­ta­mi María agllarka. Pai chasa agllas­kataka, ñi pipas mana kichun­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Su­ura Jesús, Taita Dius­wa rima­na­kurka. Rima­na­kui puchu­ka­uraka, sug paita kati­raiag nirka: —Taita waugki, nukan­chita Taita Diusta mañan­ga­pa iacha­chii; imasa­mi Juan Bautista, paita kati­raiag­kunata mañan­ga­pa iacha­chirka: chasa. ");
INSERT INTO inb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chi­ura, Jesuska nirka: —Kam­kuna Taita Diusta maña­na­ku­ura, kasa nin­gi­chi: Nukan­chipa atun Taita: kam tukuipi mas alli kagta tukui­kuna ni­sun­chi. Nukan­chi­wa samui, iaia kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tukui puncha­kuna, tanda minis­tiska nukan­chita kara­mungi. ");
INSERT INTO inb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nukan­chi ima panda­ris­ka­kunata pasin­siai. Chasa­lla­ta nukan­chipas, sug­kuna ima llaki­chis­ka­kunata pasin­sian­chimi. Mana sakii, nukan­chi mana alli iuiai­kunata iuia­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kasapasmi Jesús nirka: —Kasa iuia­ri­sun­chi. Mai­kan iacha­ridu­pura, chaugpi tuta pai­pag­ma rispa, maña­kug­rin­tra: “Waugki, kimsa tanda maña­chi­wai. ");
INSERT INTO inb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kuna­urita­lla­mi sug waugki, karu­nig­manda chaia­mu­warka. Nuka, ñi ima­pas mana iuka­nichu, paita karan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—Sugka, uku­manda­lla ai­nin­tra: “Mana killa­chi­wai. Pungu­kuna­pas, suma wichkaska­mi ka­puá. Nuka­pa wam­bra­kuna­wan­ta­mi ña siri­na­kun­chi. Chi­manda­mi mana pudini, ata­rispa, kamta maña­chin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Iuia­ri­sun­chi: mai­tuku iacha­ridu kag­manda­lla, mana ata­rispa kan­chu. Nii­ki­chitami: “Mana mas killa­chi­wachu” iuias­pa­mi tukui ima maña­kus­kata kuan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Chi­manda nii­ki­chitami: Taita Diusta mañag­pika, kara­mun­ga­pa­mi ka. Paita maskag­pika, tarin­ga­pa­mi kan­gi­chi. Pungu taka­chig­rig­pika, kam­kunata paska­pun­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mai­kan­pas chasa mañag­pika, chaskinga­pa­mi ka. Mai­kan­pas maskag­pika, taringa­pa­mi ka. Mai­kan pungu taka­chig­rig­pika, iaiku­chinga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Sug wam­bra paipa taitata chalwa maña­kug­pika, ¿kulibrachu karan­tra? ");
INSERT INTO inb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Chasa­lla­ta, sug wibus maña­kug­pika, ¿chini kuku­chu karan­tra? Manima. ");
INSERT INTO inb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kam­kuna, mana alli kaspa­pas, kam­kunapa wam­bra­kunata suma ima­pas karan­gi­chi. Nig­pika kam­kunapa Taita suma luarpi kagka, ¿ima­wan­tak mana Santu Ispi­ri­tuta kara­munga, mai­kan suma mañag­pika? ");
INSERT INTO inb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús, kuku wairata sug runa­manda llugsi­chi­kurka. Chi runata, kuku waira mana riman­ga­pa rurag­samuska karka. Chi kuku waira llugsi­chii tuku­uraka, chi runa alli­lla rimag­samurka. Chasa kawas­paka, achka chipi kag­kuna iapa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mai­kan­kunaka nir­ka­kuna: —Chi, Beelzebú suti iaia kukupa iachai­wa­mi kuku waira­kunata llugsi­chi­ku—. ");
INSERT INTO inb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ikuti sug­kunaka, Jesusta maña­na­kurka, mana ima­ura­pas kawaska­sina awa luar­manda kawa­chi­chu; chasaka, pai­manda iachan­ga­pa, sutipa Taita Dius kacha­muska kagta. ");
INSERT INTO inb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pai­kuna ima iuia­na­kus­kata iachas­paka, Jesuska nir­ka­kunata: —Sug alpapi mandag­pura piña­chi­na­kuspa maka­na­kuspa­lla kaug­sa­na­kug­pika, tukuimi wagllirí. Sug wasipi piña­na­kuspa­lla kaug­sa­na­kug­pika, mana alli­lla kan­ga­pa kan­chu, sumag­lla sug­lla­pi kaug­sa­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chasa­lla­ta iaia kuku­wa kag­kuna sugma sugma tukugpi­kunaka, ¿mana­chu pai­pura mandai chi­ura­lla puchuka­rin­tra? Kam­kuna nuka­manda ni­na­kun­gi­chi: “Beel­zebupa iachai­wa­mi kuku waira­kunata llugsi­chi­ku”; chi­manda­mi chasa ni­na­kui­ki­chita. ");
INSERT INTO inb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Beelzebupa iachai­wa nuka kuku waira­kunata llugsi­chi­kug­pika, kam­pura­kunaka, ¿pipa iachai­watak llugsi­chin­kuna? Pai kikin­kuna­mi kawa­chin­ga­pa kan­kuna, imasa kam­kuna mana alli­lla nuka­manda iuia­rispa ni­na­kugta. ");
INSERT INTO inb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Taita Dius­pa iapa iachai­wa nuka kuku waira­kunata llugsi­chi­kug­pika, sutipa­mi Dius­pa suma mandai ña kam­kuna­pagma chaia­murka. ");
INSERT INTO inb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Sug wapu runa, chunta makana cha­rispa, paipa wasita kawa­kug­pika, tukui ima waka­chi­raias­ka­mi mana chinganga. ");
INSERT INTO inb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ikuti pai­manda sug mas wapu runa chaiag­rig­pika, binsiimi tukunga. Binsis­paka, makanata i ima chari­kus­ka­ta­mi kichunga. Ukupi tukui ima tias­kata sisaspa­mi ringa. ");
INSERT INTO inb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Mai­kan­pas mana nuka­wa suma iuiai­wa kag­kuna, nukata piña­wag­mi kan­kuna. Chasa­lla­ta mai­kan­pas nuka­wa mana suma tanda­chig­kuna, tukuimi susu­ri­puan­ga­pa kan­kunata. ");
INSERT INTO inb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Mai­kan runa­manda kuku waira llugsi­chii tukus­kaka, tusta alpa kas­kapi sama­ringa­pa­mi mas­kaspa purirka. Ñi maipi mana sama­rin­ga­pa taris­paka, iuia­rir­kami: “Mai­manda­mi nuka llugsi­murkani: chima­lla­ta­ta­mi kutin­ga­pa kani”. ");
INSERT INTO inb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chi runa­pagma ku­tispa ikuti iaikug­ri­ura, uku suma pichaska i alli­chiska­sina­mi tarig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chasa kawas­paka, kan­chis kuku waira­kuna pai­manda mas jiru rura­dur­kunata pusan­ga­pa rirka. Chi runapi iaikug­rispa, chi kuku­kuna kaug­sai­mi kalla­rir­ka­kuna. Chasaka chi runa, ñugpa­manda­pas mas jiru mana alli­lla­mi tukuipi tukurka. ");
INSERT INTO inb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chasa ni­kun­kamaka, chipi kag­pura sug warmi, kapa­rispa, nirka: —Mai­kan warmi kamta iukag­samuska chuchu­chispa wiña­chig, Taita Dius­pa iapa kuiaska­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesuska nirka: —Chasapaka, Taita Dius ima rima­kus­kata suma uiaspa rurag­kuna­mi paipa mas iapa kuiaska kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesus­pagma tanda­rispa mirai apa­na­ku­ura, Jesús nirka: —Kuna­ura­manda runa­kuna, mana alli­lla ruraspa kaug­sa­na­kug­mi kan­gi­chi. Maña­wa­na­kun­gi­chi: “Mana kawaska­sina kawa­chi­mui”. Ñi ima­pas mana kam­kuna munaska­sina kawan­ga­pa kan­gi­chi­chu. Ñugpa­manda Santu Ispi­ri­tu­wa rimag Jonás suti imasa­mi pasarka: chasa­lla­ta kawa­ri­lla­mi kawan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Imasa­mi Jonás, Nínive pui­blupi kaug­sa­na­kus­kata iuia­chispa kawa­rirka: chasa­lla­ta­mi kai Runa Tukuskapas, kuna­ura­manda runa­kunata iuia­chispa kawa­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Taita Dius jus­ti­siai ruran­ga­pa puncha chaia­uraka, Chaug­pun­cha suti alpata mandag warmi­ka saia­rispa­mi kuna­ura­manda runa­kunata nin­ga­pa kan­kunata: “Mana alli­lla rurag­kuna­mi kan­gi­chi”. Ñugpata chi warmi, iapa karu alpa­manda­mi samurka, atun mandag Salo­monpa iapa iachai­wa rima­kus­kata uian­ga­pa. Kai rima­kug­ka, Salo­mon­manda­pas mas iacha­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Chasa­lla­ta, Taita Dius jus­ti­siai ruran­ga­pa puncha chaia­ura, Níneve pui­blu­manda kag­kuna­pas saia­rispa­mi kuna­ura­manda runa­kunata nin­ga­pa kan­kunata: “Mana alli­lla rurag­kuna­mi kan­gi­chi”. Chi Nineve­manda runa­kuna, Jonás ima willas­kata uias­paka, alli rurai­kuna­ma­mi tigrar­ka­kuna. Kai rima­kug­ka, Jonas­manda­pas mas iacha­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Ñi pipas mana bila sin­di­chin­kan­gi­chi­chu, paka­lla­pi u ka­wi­tu ukuma churan­ga­pa. Awa­pi­mi churan­ga­pa kan­gi­chi, mai­kan iaikug­kunata puncha­ia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kam­kunapa ñawi­kuna, kuir­pupi puncha­ia­chig­sina­mi kan­kuna. Ima­ta­pas alli iuiai­wa kawag­pika, kam­kunapa kuir­pupas suma puncha­iag­sina­mi kan­ga­pa ka. Ikuti mana alli iuiai­wa kawag­pika, kam­kunapa kuir­pupas iana tutapi kag­sina­mi kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chi­manda­mi nii­ki­chita: ¡ujala­lla­pas kam­kunapa iuiai mana puncha­pi­sina kachu! ");
INSERT INTO inb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kam­kunapa kuir­pupi ima­pipas mana iana tutapi­sina kag­pika, suma puncha­iag­sina­mi kan­ga­pa kan­gi­chi; imasa­mi bila sindi puncha­ia­chí: chasa. ");
INSERT INTO inb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús rimai puchuka­ura­manda, sug fari­seo runa paita kun­bidarka, paipa wasipi mikug­rin­ga­pa. Chaiag­rispa­lla, Jesús tia­rig­rirka mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mana maki mailla­rispa­lla mikui kalla­rirka; ñugpa­manda­kuna imasa iacha­chiska­sina, manima. Chasa kawas­paka, chi fari­seo ujna­rirka. ");
INSERT INTO inb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Chi­ura Iaia Jesuska, paita nirka: —Uia­wai. Kam fari­seo­kuna, kuashag i platuta awalla­lla­mi maillan­gi­chi. Ikuti kam­kunapa iuiai ukumaka sug­kunapata iapa muna­rispa i sisa­rispa kaug­sag­kuna­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kam­kuna, mana alli iuiag­kuna­mi kan­gi­chi. Taita Dius awalla kawa­ri kuir­puta rurag, ¿mana­chu uku­mapas rurarka? ");
INSERT INTO inb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Chi­manda, suma iuiai­wa limusna karan­gi­chi. Chasa rurag­pika, tukui maillaska­sina­mi ni­raiankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—¡Ai, kam fari­seo­kuna! Min­ta, ruda i tukui iuiu mikui­kuna­pas pallas­ka­kuna­manda chunga­pika, sug­lla­mi Taita Diusta karan­gi­chi. Chasa karaspa­pas, kam kikin­kuna kunga­riska­mi kan­gi­chi, sug­kunata imasa chaiaska­sina alli­lla ruran­ga­pa i Taita Diusta suma kuiaspa kaug­san­ga­pa. Chunga pallas­ka­manda sug karan­ga­pa mana sakispa­lla, iukan­gi­chimi chi sug atun mandai­kuna­ta­pas alli­lla ruraspa kaug­san­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—¡Ai, kam fari­seo­kuna! Tan­da­ri­diru wasi­kunapi munan­gi­chimi, atun taita­kuna tia­ri­diru ñugpa ladu tia­rig­rin­ga­pa. Kallipi sug­kuna­wa tupa­na­kus­kapi munan­gi­chimi, iapa suma kuiai­wa kumu­rispa, “Puan­gi, taita waugki” nukata ni­wa­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—¡Ai, kam­kuna! Wañuska pamba­raiaska mana kawa­rig­sina­mi kan­gi­chi. Chi awalla saruspa ialig­pi­kuna­pas, chi ukupi ima tias­kata mana iachan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesús chasa ni­uraka, Moisés ima nis­kata sug iacha­chig taitaka nirka: —Kam iacha­chig taita, chasa nis­paka, nukan­chi­ta­paschar piña­kungi. ");
INSERT INTO inb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Chi­ura, Jesuska nirka: —¡Ai, kam­kuna Moisés ima nis­kata iacha­chig taita­kuna­pas! Kam­kuna, mana pudi­ringa­sina llasa apa­ri­chig­sina­mi runa­kunata iacha­chin­gi­chi, pai­kuna imasa niska­sina ruraspa kaug­san­ga­pa. Chasa iacha­chispa­pas, kam kikin­kunaka mana munan­gi­chi­chu, imasa iacha­chi­na­kuska­sina ruraspa kaug­san­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—¡Ai, kam­kuna! Ñugpa­manda Santu Ispi­ri­tu­wa rimag­kunata kam­kunapa ñugpa­manda­kuna wañu­chis­kata iuia­rin­ga­pa, kam­kunaka suma atun bubida­kuna ruraspa­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chasa ruras­paka, kawa­chin­gi­chimi, imasa kam­kunapa ñugpa­manda­kuna ruras­kata, kam­kuna­pas chasa­lla­ta rurag­kuna kagta. Pai­kuna wañu­chir­ka­kuna; kam­kunaka, suma atun bubida­kuna­mi ruran­gi­chi, iuia­ringa­pag­lla. ");
INSERT INTO inb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Chimandami Taita Dius, paipa iachai­wa nirka: Santu Ispirituwa rimagkuna­ta i nuka kikin agllaska runa­kuna­ta­mi kacha­mun­ga­pa kani. Maikankunataka wañuchinga­pa­mi kan­kuna. Sugkunataka mitikuchinga­pa­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chi­manda­mi, kai alpata wiña­chiska­ura­manda­ta tukui ñugpa­manda Santu Ispi­ri­tu­wa rimag­kunata wañu­chis­ka­kuna­manda, kuna­ura­manda runa­kuna iapa achka llakii iukan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kasa­mi nii­ki­chita: Abel suti alli runa musug­lla wañu­chii tukuska­ura­manda­ta, sugka, Zaka­rías suti, Taita Dius­wa iuia­ri­diru uku i altarwa chaugpipi wañu­chii tukuska­ura­kama; mai­tuku wañu­chii tukus­ka­kuna­manda­pas­mi kuna­ura­manda runa­kuna iapa achka llakii iukan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—¡Ai, kam Moisés ima nis­kata iacha­chig taita­kuna! Iachaita kam­kunapa iuiai­pi­mi paka­dur kan­gi­chi. Kam kikin­kuna, nuka­manda Alli Willaita mana munan­gi­chi­chu iachan­ga­pa. Sug­kuna iachai­kun­ga­pa muna­na­kus­ka­ta­pas arkag­sina­mi rura­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús chi­manda llugsi­uraka, Moisés ima nis­kata iacha­chig taita­kuna i fari­seo­kunaka, iapa rabia­rispa, paita achka­pi­mi tapu­chii kalla­rir­ka­kuna; ");
INSERT INTO inb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chasaka, pai ainis­kata uiaspa, ima­pipas panda­rig­pika, jus­ti­sia­kunata willag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chi­kamaka, achka wa­ran­ga runa­kuna tanda­rir­ka­kuna, saru­na­kui­wan­ta. Chi­ura Jesus­ka, paita kati­raiag­kunata kasa­mi nirka: —Fari­seo­kunapa liba­dura­sina iuiaita, ¡ujala­lla­pas iuia­na­kun­gi­chi! Pai­kuna, sungu awa­lla­mi riman­kuna. ");
INSERT INTO inb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mai­kan pakalla iuiaspa rimas­kaka, ima­ura­pas­mi iacharí. Chasa­lla­ta, ima pakalla waka­chiska­pas­mi ima­ura­pas kawa­rig­samú. ");
INSERT INTO inb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tukui ima kam­kuna pakalla iana tutapi rimaska­pas, puncha­pi­mi iacha­rig­samun­ga­pa ka. Chasa­lla­ta, mai­tuku wasi ukuma pungu wichka­rispa rima­na­kugpi­pas, wasi awa­manda­mi sin­chi kapa­rii uia­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Kam­kuna nuka­pa iacha­ridu kuiaska kag­manda, kasa­mi nii­ki­chita: kam­kunapa kuir­puta wañu­chig­pika, mana manchan­gi­chi. Nis­paka, mana ima­pas ruran­ga­pa pudin­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Willa­sa­ki­chita, pita­mi manchan­ga­pa chaiá: wañu­ura, Taita Dius dil­tudupa ninama sitan­ga­pa kag­ta­mi man­chan­ga­pa chaiá. Ari, nii­ki­chitami: paita manchan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—¿Manachu pichka pisku, iskai uchulla kulki­manda­lla katurí? Chasa kagpi­pas, Taita Dius pai­kuna­manda mana kunga­rin­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kam­kunapa uma­manda agchapas, Taita Dius kuintas­ka­mi iuká. Chi­manda, kam­kuna mana man­chas­pa­lla kaug­sai­chi. Mai­tuku achka pisku­kuna­manda­pas mas bali­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Kasapasmi nii­ki­chita: nuka­manda mai­kan­pas, sug­kunapa ñawipi willa­chu: “Paita rigsi­nimi”: kai Runa Tukuskapas, chi runa­manda­ka Dius­pa anjil­kunapa ñawi­pi willa­sami: “Paita rigsi­nimi”. ");
INSERT INTO inb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ikuti mai­kan­pas, sug­kunapa ñawi­pi nuka­manda nichu: “Paita mana rigsi­nichu”: nuka­pas, pai­mandaka Dius­pa anjil­kunapa ñawipi ni­sami: “Paita mana rigsi­nichu”. ");
INSERT INTO inb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Mai­kan kai Runa Tukus­ka­manda kun­tra rimag­kuna­manda pasin­siaimi tia. Chasa kagpi­pas, mai­kan Santu Ispi­ri­tu­manda kamis­ka­mandaka mana pasin­siai tian­ga­pa kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Tanda­ri­diru wasi­kunama, jus­ti­sia i mandag­kuna­pagma kam­kunata apa­ura, mana iapa iuia­na­kun­gi­chi: “¿Imasa­mi pai­kunata ai­nini u willani?”. ");
INSERT INTO inb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ainin­ga­pa chaia­ura, Santu Ispí­ritu kikin­mi iuia­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chipi kag­pura sug runa, Jesusta nirka: —Iacha­chig taita, nuka­pa waug­kita ni­puai, nuka­pa atun­kuna sakis­kata chaugpi kara­wachu. ");
INSERT INTO inb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesuska ainirka: —Waugki, ñi pipas mana chu­ra­warka­chu, kam­kunapa jus­ti­sia kan­ga­pa, ima kam­kunata sakis­ka­ta chaugpin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chasa nis­paka, chipi kag­kuna­ta nirka: —¡Ujala­lla­pas iapa iukag kikin­manda­lla micha­rispa kan­gi­chi! Kai alpapi mai­tuku iukagpas, paipa kaug­saita mana pudin­chu dil­tudupa chari­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nis­paka, chipi kag­kunata iuiai apinga­sina suma parlarka, kasa nispa: —Sug runa iapa iukagsi tiarka. Chi runapa alpa­kunapi, iapa achka mikui­kuna pallarka. ");
INSERT INTO inb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nis­paka iuia­rirka: “¿Imasatak rurasa? Kuna­ura palla­ri­puas­kata, ¿mai­pi­tak waka­chisa?”. ");
INSERT INTO inb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","—Nis­paka iuia­rirka: “Ñami iachani ima ruran­ga­pa chaia­wa­kug­ta. Pallas­ka­kuna waka­chi­diru wasi­kunata waglli­chispa, sug mas atun­kuna­mi saia­chin­ga­pa kani. Chi­kuna­pi­mi tukui ima palla­riska i tukui ima tia­puas­kata waka­chisa. ");
INSERT INTO inb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nis­paka, nuka kikin ni­ri­sami: ‘Kuna­ura, ñami achka wata­kunapa achka waka­chiska iukangi. Chi­mandaka, samaspa, mikuspa, upiaspa, alli­lla sumag­lla­mi chisian­kangi’.” ");
INSERT INTO inb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—Chasa iuia­ri­kun­kamaka, Taita Diuska nirka: “Ja, kam mana alli­lla iuiai­iug. Kunantuta­lla­mi kamba almata mañan­ga­pa kaiki. Nig­pika chi waka­chis­kaka, ¿pi­manda­sik kanga?”. ");
INSERT INTO inb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Chasa, mai­kan­pas kikin­manda­lla waka­chigka, Dius­pa ñawi­pi ñi ima mana iukag ni­raian­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Chasa nis­paka, paita kati­raiag­kunata nirka: —Chi­manda­mi kasa nii­ki­chita: mana iapa iuia­ri­na­kun­gi­chi: “¿Ima­tak miku­sun­chi, nukan­chi kaug­san­kama?” u “¿Ima katan­ga­tak chura­ri­sun­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kam­ba kaug­saika, mikui­kuna­manda mas­mi ka. Chasa­lla­ta kamba kuir­pu­pas, katanga­manda mas­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chiwaku­kuna­manda iuia­rii­chi. Pai­kunaka mana tarpun­kuna­chu. Mikui pallaspa, waka­chi­diru trujapas mana iukan­kuna­chu. Chasa kagpi­pas, Taita Diuska ñi ima mana pisi­chin­kunatachu. Kam­kunaka, pisku­kuna­manda mas bali­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—¿Pi­kunatak, mai­tuku iuia­ris­pa­pas, sug palmu­lla­pas awa wiñai pudin­ga­pa kan­gi­chi? Ñi pipas manima. ");
INSERT INTO inb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chi uchulla ruraita mana pudis­paka, ¿imapatak sug ima­kuna­manda iapa iuia­ri­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Kawai­chi imasa liriu tugtu­kuna chagrapi suma wiña­ris­ka­kunata. Iuia­rii­chi: pai­kuna mana puch­kaspa awan­kuna­chu. Ñi ima mana ruran­kuna­chu. Kasa­mi nii­ki­chita: ñi atun mandag Salomón, pai tukui iapa suma katanga chura­ris­pa­pas, chi tugtu­kuna­manda mas suma mana kawa­rirka­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ugsa, kuna puncha chagrapi suma kas­kata kaiandi rupa­chin­ga­pa kagta, Taita Dius chasa suma kawá. Kam­kunataka, ¿ima­wan­tak mana mas sumag­lla kawanga? Kam­kuna mana alli­lla Taita Dius­manda iuia­rispa kag­kuna, paita mas sumag­lla iuia­rii­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Chi­manda, mana iapa mas­kaspa puri­na­kun­gi­chi, ima mikun­ga­pa i upian­ga­pa iuia­rispa­lla. ");
INSERT INTO inb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kai alpa­manda­lla iuiai­wa kag­kuna­mi chasa maskaspa kaug­sa­nakú. Kam­kuna tukui ima minis­tis­ka­kuna­mandaka, kam­kunapa Taita Dius ñami iachá. ");
INSERT INTO inb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kam­kuna suma iuia­rispa kan­gi­chi, Taita Dius imasa mandaska­sina kaug­san­ga­pa. Chasa kagpi­kunaka, kam­kunata tukui ima minis­tis­ka­kuna­ta­mi kara­munga. ");
INSERT INTO inb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Nuka­pa kuiaska asllita ubija­kuna­sina kaspa­pas, mana man­chaspa­lla kai­chi. Kam­kunapa Taita Dius muna­kumi, kam­kuna­pas pai suma manda­kus­kapi kag­samu­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kam­kuna ima iukas­kata lim katuspa, minis­tis­ka­kunata karai­chi. Chasa karas­paka, suma luarpi kulki ima­pas mana puchuka­ringa­sina mana ismug waka­chi­dirupi­sina waka­chis­ka­mi iukan­kan­gi­chi. Chi luarpi, sisai­kuna mana tian­ga­pa kan­chu. Ñi burbuju­kuna­pas mana waglli­chispa mikun­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kam­kuna maipi waka­chis­ka­pi­mi kam­kunapa iuiaita churaska kan­gi­chi: kai luarpi u sug luarpi. ");
INSERT INTO inb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Kam­kuna, suma chum­bi­lliska i bila sindi­chiska, alli­chi­riska­sina suia­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imasa piun­kuna, patrun kasarai­manda paipa wasima chaiag­samu­ku­ura, pungupi kaiag­lla­pika, paskan­ga­pa suia­na­kug­sina kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Piun­kuna chasa rigcha­raias­kata tarig­samus­paka, chi patrun sumag­lla­mi kawag­samunga. Kasa­mi nuka nii­ki­chita: chi patrunka, sumag­lla tia­ri­chispa, kikin­mi mikui karan­ga­pa kan­kunata. ");
INSERT INTO inb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chaugpi tuta u paka­ringa­ma chaia­muspa, chi piun­kuna rigcha­raias­ka­ta tarig­samug­pika, pai­kuna iapa allimi pasan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Kasa iachai­chi: wasi duiñu iachan­tra, ima ura sisai samun­ga­pa kagta. Iachas­paka, mana puñu­rispa­lla­char rigcha­raian­tra, paipa wasipi mana sisai iaikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Chasa­lla­ta kam­kuna­pas, alli­chi­riska­sina suia­na­kun­gi­chi. Kam­kuna mana iuia­na­ku­ura­mi kai Runa Tukuska chaia­mun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Chi­ura, Pedro tapurka: —Taita waugki, ¿chi parluta nukan­chi­lla­ta­chu ubi tukui­kunatachu ni­kungi? ");
INSERT INTO inb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chi­ura, Iaia Jesuska ainirka: —Mai­kan tukuipi alli rurag runa kag­ta­mi paipa patrun sakirka, ima wasipi kawa­pun­ga­pa, sug piun­kuna­ta mikui karaspa, pai kikin chaia­mun­kama. ");
INSERT INTO inb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Patrun ikuti chaiag­samuspa, imasa niska­sina alli­lla rura­kugta kawas­paka, chi runata sumag­lla­mi, “Pai Siñur” nispa, kuian­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chi­manda­mi paita mai­tuku ima iukas­ka­ta­pas mingaspa sakin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Ikuti chi piun, kasa iuia­rispa nin­tra: “Nuka­pa patrun, mana utka chaia­mun­ga­pa ka”. Chasa nis­paka, sug piun­kunata, kari i warmi­kunata makai kalla­rin­tra. Kikinka, mikuspa i ma­chag­ta upiaspa kan­tra. ");
INSERT INTO inb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Chi runa kun­gaska mana iuia­ku­ura­mi patrunka, chaia­muspa, shachig­samun­ga­pa ka. Chasa shachig­samus­paka, paita sin­chimi asutin­ga­pa ka. Nis­paka kachangami, pai ima nis­kata mana uiag­kuna­wa jus­ti­siai tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Chi piun, ima patrun muna­kuska­sina alli­lla iachaspa­pas, ima tias­ka­kunata mana alli­chispa, ñi ima muna­kuska­sina mana ruras­ka­manda, paita achka­mi asutin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mai­kan piun, mana alli­lla iachaspa­lla panda­rig­pika, mailla asutimi chaian­ga­pa ka. Mai­kanta achka karas­kata chasa­lla­ta­mi achka mañanga. Mai­kanta achka mingas­kataka mas achka­mi mañan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Nuka samurka­nimi, kai alpa­pi nina sindi­chig­sina ruran­ga­pa. Muna­ku­nimi, ña sindi rupa­kug­sina kan­tra. ");
INSERT INTO inb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nukata chaia­wa­kumi, wañu­chii tukun­ga­pa. Manara chaia­wagpi, iapa llakii­wa­mi kani. ");
INSERT INTO inb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","—¿Kam­kuna iuian­gi­chi­chu nuka kai alpama samugta, tukui sumag­lla kaug­sa­na­kun­ga­pa? Nii­ki­chitami: manima. Nuka samug­manda, tukuima chaugpi­na­kug­sina­mi tian­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chasa kuna­ura­manda, sug wasipi pichka­kuna kaug­sa­na­kus­kapika, iskaima tukus­pa, kimsa­kuna­wa iskai­kuna­wa­mi mana alli­lla kaug­sa­na­kun­ga­pa ka, nuka samug­manda. ");
INSERT INTO inb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Taitan­di­wa wam­brandi­wa, maman­di­wa warmi wam­brandi­wa, sui­gran­di­wa nuiran­di­wa, chasa­lla­ta mana alli­lla­mi kaug­sa­na­kun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kasapasmi Jesús, tukui chipi kag­kunata nirka: —Indi chinga­ri­diru­nig­manda puiu kawa­rig­pika, chi­ura­lla­mi nin­gi­chi: “Tamianga­pa­mi ka”. I sutipa. ");
INSERT INTO inb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chasa­lla­ta, alli maki­nig­manda sin­chi wairamug­pika, nin­gi­chimi: “Iapa­mi indi rupa­rin­ga­pa ka”. I sutipa. ");
INSERT INTO inb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kam­kuna, sungu awalla rimag­kuna­mi kan­gi­chi. Imasa awa­pi i alpapi kawa­ris­ka­kunata kawas­paka, iachan­gi­chimi ninga, puncha­kuna imasa kan­ga­pa kagta. Nig­pika, kai puncha­kuna nuka ima rura­kus­kata kawas­paka, ¿imapatak mana iuia­rin­gi­chi ima ni­raiagta? ");
INSERT INTO inb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—¿Imapatak kam kikin­kuna mana iuia­rin­gi­chi, ima alli­lla u mana alli­lla kagta? ");
INSERT INTO inb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mai­kan kam­ta dimandaspa, jus­ti­sia­pagma pusa­na­kug­pika, paita sumag­lla rimangi, manara jus­ti­sia­pagma chaia­chig­rigpi. Mana kag­pika chaia­chig­ri­ura, jus­ti­siaka kamta alwasil­kunapa maki­pi­mi sakinga. Chi­ura alwasil­kunaka, kamta karsil­pi­mi wich­kanga. ");
INSERT INTO inb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kasa­mi niiki: chi­manda mana llugsin­ga­pa kangichu, tukui kulki manara kuti­chin­kama. ");
INSERT INTO inb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesús chasa iacha­chi­kug­lla­pika, sug runa­kuna, chaias­pa, paita willai kalla­rir­ka­kuna: —Gali­lea alpa­manda sug runa­kuna, Dius­pa atun wasipi animal­kunata rupa­chi­na­ku­ura, chi runa­kunataka mandag Pila­tos wañu­chi­chispa, chi animal­kunapa iawar­wa­mi chapu­chirka. ");
INSERT INTO inb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesuska ainir­ka­kunata: —¿Iuia­na­kun­gi­chi­chu: chi Ga­li­lea­manda­kuna, tukui­kuna­manda mas panda­rig­kuna kas­ka­manda­char chasa wañu­chir­ka­kunata? ");
INSERT INTO inb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nii­ki­chitami: manima. Kam­kuna­pas, alli­lla rurai­kunama mana tigrag­pika, tukui­kuna­mi puchu­ka­rin­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Chasa­lla­ta, chi chunga pusag runa­kuna, Siloepi sug asku­rinti iapa awa wasi pai­kunapa awalla urma­ura, wañus­ka­kuna: ¿iuia­na­kun­gi­chi­chu: chi­kuna, tukui Jeru­salenpi kaug­sa­na­kus­ka­manda­pas mas panda­rig­kuna­char kar­ka­kuna? ");
INSERT INTO inb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nii­ki­chitami: mani­ma. Kam­kuna­pas, alli­lla rurai­kuna­ma mana tigrag­pika, tukui­kuna­mi puchu­ka­rin­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chasa nis­paka, chipi kag­kunata iuiai apinga­sina suma parlarka, kasa nispa: —Sug runa, ubas sacha­kuna tias­ka­pi sug igus sacha tarpuskasi iukarka. Unaipika rirka kawan­ga­pa: ¿igus ñachu tia­rirka? Chi­ura, manara tia­riska karka. ");
INSERT INTO inb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chi­manda, chagra kawagta nirka: “Kawamui. Ñami kimsa wata samu­kuni, kai sacha­pi igus tian­chu kawan­ga­pa. Ñi ima­pas mana tarig­samu­nichu. Kuchui­lla. ¿Imapatak kai sacha, alpa­pi ianga saia­kunga?”. ");
INSERT INTO inb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—Chagra kawagka ainirka: “Taita waugki, kai watalla saki­wai. Nuka, alpata ñutu­chis­paka, suma majada chura­sami; ");
INSERT INTO inb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","chi­wanka, kawan­ga­pa: ¿watapika igus tia­rin­chu? Mana tia­rig­pika, kuchun­gi”. ");
INSERT INTO inb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sug warda puncha Jesús, sug tanda­ri­diru wasipi iacha­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chi­pi karka sug warmi ña chunga pusag wata kuku waira iai­kuspa unguglla. Chi warmi, wasa ku­mu­ridu kaspa, mana pudirka, ñi ima­ura alli­lla diricha­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pai­ta kawas­paka, Jesuska kaias­pa, nirka: —Kam warmi, ñami kamba ungui anchu­riska kangi. ");
INSERT INTO inb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nis­paka, chi warmita paipa maki churarka. Churag­lla­pi, chi war­mika suma alli­lla saia­rispa diri­cha­rirka. Nis­paka, Taita Diusta nii kalla­rirka: “Kam, iapa suma atun­mi kangi”. ");
INSERT INTO inb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chasa warda puncha alia­chigta kawaspa, chi tanda­ri­diru wasi­manda taitaka, Jesus­wa piña­rispa, tukui chipi kag­kunata nirka: —¿Manachu sugta puncha iukan­chi, trabajan­ga­pa? Chi pun­cha­kuna samun­gi­chi, ambi­chi­rin­ga­pa; warda punchaka, mana. ");
INSERT INTO inb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Chasa ni­ura, Iaia Jesuska nirka: —Kam­kuna, sungu awalla rimag­kuna­mi kan­gi­chi. Kam­kunapa wagra u buru wata­raias­ka­kunata, ¿mana­chu paskan­gi­chi, iaku upia­chig­rin­ga­pa, warda puncha kag­pi­pas? ");
INSERT INTO inb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kai warmika, ñugpa­manda taita Abra­hampa iawar­mi ka. Paita iaia kukumi chunga pusag wata chi ungui­wa wataska­sina cha­ri­kurka. Warda puncha kag­mandaka, ¿mana­chu pudirí, paita ungui­ma watas­kata alia­chinga? ");
INSERT INTO inb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús chasa ni­uraka, tukui pai­wa mana alli iuiai­wa kag­kuna iapa­mi pingai pasar­ka­kuna. Ikuti sug­kunaka, Jesús chi suma alli­lla ruras­ka­kunata kawaspa, iapa kun­tin­ta­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kasapasmi Jesús nirka: —Dius­pa suma mandai, ¿ima­sa­tak rigchá? Kasa nin­trani. ");
INSERT INTO inb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sug runa, paipa chagrapi mustasa similla tarpug­sina­mi ni­raiá. Ña wiñai puchuka­uraka, sachami tukú. Chasa­pika pisku­kuna­pas, malki­kuna­pi sumag­lla­mi wasi­chig­samun­kuna. ");
INSERT INTO inb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kasapasmi nirka: —Dius­pa suma mandai, ¿ima kag­sinatak nin­trani? ");
INSERT INTO inb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Imasa­mi sug warmi, kimsa tasa arinata liba­dura­wa chapu­uraka, suma tim­bus­pa, miraspa achkaiag­samú: chasa­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús Jeru­salenma ri­kuspa, atun i uchulla pui­blu­kunata iacha­chispa ialirka. ");
INSERT INTO inb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ri­kus­kapika, sug runa paita tapurka: —Taita waugki, ¿mailla­kuna­lla­chu kispi­rin­ga­kuna? Chi­ura, paika ainirka: ");
INSERT INTO inb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Suma luarma iaikug­rin­ga­pa, iuia­rin­gi­chi kichki pungupi­sina ialin­ga­pa. Kasa­mi nii­ki­chita: achka­kuna, iaikun­ga­pa muna­na­kugpi­pas, mana pudin­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Kam­kuna kanchapi kan­kama, wasi duiñu pungu wich­kag­pika, kam­kuna kaiaspa, nin­kan­gi­chimi: “Taita waugki, nukan­chi­manda pungu paska­puai”. —Paika ainingami: “Kam­kuna­ta mana rigsii­ki­chitachu. ¿Mai­manda­kuna­char kan­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Chi­ura, kam­kuna ninkan­gi­chimi: “¿Mana­chu iuiangi? Kam­wa­mi mikurkan­chi i upiar­kan­chi. Nukan­chipa pui­blu­manda kalli­kuna­pi­mi kam iacha­chir­kan­gi”. ");
INSERT INTO inb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","—Paika ningami: “Ikutimi nii­ki­chita: mana rigsii­ki­chitachu. ¿Mai­manda­kuna­char kan­gi­chi? Tukui kam­kuna mana alli­lla rurag­kuna, nuka­pa ñawi­manda anchu­rii­chi”. ");
INSERT INTO inb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Ñugpa­manda Abra­ham, Isaak i Jakob suti taita­kuna i Santu Ispi­ri­tu­wa tukui rimag­kuna, sug luarpi Dius suma manda­kus­ka­pi­mi kan­ga­pa kan­kuna. Chasa kawas­pa­ka, kam­kuna kanchama sitaska kag­kuna, iapa llakispa, wakaspa, kiru mukuspa­mi kan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Indi llugsi­diru­nig­manda i chinga­ri­diru­nig­manda, alli maki ladu­nig­manda i lluki maki ladu­nig­manda, tukui­nig­manda­mi rin­ga­pa kan­kuna, Dius suma manda­kus­kapi tia­rispa mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chi­ura sug­kuna kuna­ura kati ni­raias­ka­kuna, ñugpa ladu­ma­mi tukun­ga­pa kan­kuna. Ikuti sug­kuna kuna­ura ñugpa ni­raias­ka­kunaka, kati ladu­ma­mi tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chi­ura­lla­tata sug fari­seo­kuna, Jesus­pagma kailla­iag­rispa, nir­ka­kuna: —Kai­manda llugsispa, utka rii­lla. Mandag Hero­des, kamta wañu­chinga­pa­mi muna­ku. ");
INSERT INTO inb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesuska ainirka: —Ianga kawai­chi. Chi miski simi iukaska sungu awalla rimagta kasa nig­rii­chi: “Kuna puncha kaiandi­kuna­pas, kuku waira­kunata llugsi­chi­nimi; ungug­kuna­ta­pas ambi­nimi. Kimsa puncha­kunaka ñami ialinga, nukata ima chaia­wa­kus­kata ruran­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kuna puncha, kaia, sug puncha­pas chaia­wa­kumi rin­ga­pa. Santu Ispi­ri­tu­wa rimagtaka mana chaian­chu, Jeru­salén mana kas­kapi wañu­chii tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—¡Ai, Jeru­salén, Jeru­salen­manda runa­kuna! Kam­kuna, Santu Ispi­ri­tu­wa rimag­kunata wañu­chig­mi kan­gi­chi. Kam­kuna­pagma kacha­muska runa­kuna­ta­mi rumi­wa piaspa wañu­chin­gi­chi. Imasa­mi ata­walpa, paipa pullitu­kunata kunu­chin­ga­pa kaiaspa ugllarí: chasa­lla­ta­mi nuka­pas, achka biaji kaiaspa, tanda­chin­ga­pa muna­na­kurkai­ki­chita. Chasa muna­kug­pipas, kam­kunaka mana nukata muna­warkan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chi­manda­mi kam­kunapa wasi­kuna, sitaska tukug­samun­ga­pa kan­kuna. Kasa­mi nii­ki­chita: kuna­ura­manda mana kawa­wan­ga­pa kan­gi­chi­chu, ima­ura kam­kuna kasa ni­wan­kama: “Atun Taita Dius kacha­mus­ka­mi samu­kungi. Paipa iapa kuiaska­mi kam kangi”. ");
INSERT INTO inb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sug warda puncha Jesus­ka, fari­seo­kuna­manda tai­ta­pa wasima rirka, mikun­ga­pa. Chi­pika fari­seo­kuna, mana alli­lla iuiai­wa paita chapa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesus­pa ñugpa ladu, sug runa, pungii ungui iukaspa, tukui kuir­pu pun­gis­ka­mi tia­kurka. ");
INSERT INTO inb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Chi­ura Jesus­ka, Moisés ima nis­kata iacha­chig taita­kunata i fari­seo­kunata tapurka: —Warda punchapas ungug­kuna­ta alia­chin­ga­pa, ¿pudi­rin­chu u mana? ");
INSERT INTO inb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Chi­ura, upalla tia­na­kurka. Nig­pi Jesuska, ungug runata maki chu­raspa, ambirka. Nis­paka, pai­pag­ma kacharka. ");
INSERT INTO inb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kachas­paka, chipi kag­kunata nirka: —Kam­kunapa wam­bra u wagra sanjapi urmag­pika, ¿mana­chu warda puncha kagpi­pas chi­ura­lla sur­kun­tran­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Chi­ura, ñi pipas mana ainin­ga­pa pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chi mikun­ga­pa chaiag­rig­kuna, taita­kuna tia­ri­diru­kunata aglla­na­kurka tia­rin­ga­pa. Jesuska, chasa kawaspa, pai­kunata iuiai apinga­sina kasa­mi nirka: ");
INSERT INTO inb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Mai­kan kam­kunata kasarai mikuima kunbida­chu­kuna: taita­kuna tia­ri­dirupi mana tia­rig­rin­gi­chi. Chasa tia­rig­pika, kam­kuna­manda sug mas atun taita chaia­mug­pika, ");
INSERT INTO inb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","chi kunbidagka, samus­pa, pudin­mi kam­kunata ninga: “Kai tia­ri­diruta saki­puai, kai runa tia­rin­ga­pa”. Chi­ura, kam­kunata pingaipa­mi iuia­chinga, kati ladu tia­rig­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Kam­kunata kunbida­chu­kuna: chi­uraka kati ladulla tia­rig­rin­gi­chi. Nigpi kunbidagka, sa­mus­pa, kam­kunata ningami: “Taita waug­ki, mas ñugpa ladu ia­lis­pa tia­rii”. Chi­uraka, tukui chi­pi kam­kuna­wa tia­na­kuskapa ñawi­pi atun­ia­chig­sina iuia­chimi tukun­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Chasa­lla­ta mai­kan­pas atun­ia­chi­rispa iuiagta, Taita Dius­ka uchullaia­chinga­pa­mi ka. Ikuti mai­kan­pas uchullaiaspa iuias­ka­taka, Taita Dius atun­ia­chin­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chasa nis­paka, paita kunbidag runata nirka: —Mikun­ga­pa kunbidan­ga­pa chaia­ura, mana kaia­kungi kamba iacha­ridu­kuna­lla­ta, waugkindi­kuna­lla­ta ñi kam kikin­pura­kuna­lla­ta; iapa iukag kamba ladu suiu kaug­sa­na­kus­ka­ta­pas mana kun­bi­da­kungi. Chasa kunbidag­pika, pai­kuna­pas, kamta kunbidaspa, kuti­chin­ga­kunami. ");
INSERT INTO inb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","—Chasapaka, mikun­ga­pa kun­bidan­ga­pa chaia­ura, kaiangi mana iukag­kunata, mana alli­lla sarun­ga­pa i chaki mana kuiu­chin­ga­pa pudis­ka­kunata; mana ñawi kawag­kuna­ta­pas kunbidangi. ");
INSERT INTO inb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pai­kuna mana kamta kuti­chin­ga­pa pudig­manda­mi Taita Dius­pa iapa kuiaska kankangi. Alli­lla iuiai­wa kag­pura kaugsa­rii puncha­mi pai, kamta sumag­lla kuti­chinga. ");
INSERT INTO inb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chasa uias­paka, sug kun­bi­daska Jesus­wa tia­na­kuska­puraka paita nirka: —Dius suma manda­kus­kapi mai­kan mikug, paipa iapa ku­ias­ka­mi kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Chi­ura, Jesuska ainirka: —Sug runa, suma mikui karan­ga­pa kas­paka, achka runa­kunatasi kunbidarka. ");
INSERT INTO inb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ña chi mikun­ga­pa puncha chaia­mu­uraka, sug lutrinta kacharkasi, tukui kunbidas­ka­kunata nig­rin­ga­pa: “Samui­chi. Ña tukui alli­chiska­lla­mi tia”. ");
INSERT INTO inb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Chasa willag­ri­uraka, tukui­kuna nir­ka­kunasi: “Mana pudin­ga­pa kan­chi­chu”. Sug runa nirkasi: “Kuna­ura­lla­mi sug alpa randirkani. Iuka­nimi kawan­ga­pa ringa. Chi­manda ni­puag­rii, pasin­sia­wachu”. ");
INSERT INTO inb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Sugka nirka: “Kuna­ura­lla­mi pichka pa­ris wagra ran­dirka­ni. Kawag­risa: ¿imasachar ka­puá? Chi­manda ni­puag­rii, pasin­sia­wachu”. ");
INSERT INTO inb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Ikuti sugka nirka: “Kuna­ura­lla­mi kasararkani. Chi­manda­mi manima rin­ga­pa pudini. Pai Siñur ni­puangi”. ");
INSERT INTO inb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Chi lutrín, kutis­paka, tukui­kuna imasa ainiska­sina mikui karan­ga­pa kagta patrunta willag­rirka. Chasa uias­paka, rabia­rispa, nirkasi: “Rii pui­blu suiu tukui ñambi­kunama. Tukui ñi ima mana iukas­ka­kunata, mana alli­lla sarun­ga­pa, mana chaki kuiu­chin­ga­pa pudis­ka­kunata i mana ñawi kawag­kuna­ta­pas utka pusag­rii”. ");
INSERT INTO inb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—Chasa ruras­paka, chi runa nirka: “Taita waugki, ña­mi kam ima­sa ni­waska­sina rurarkani. Chasa kagpi­pas, charami pagtá, mas achka mikug­kuna junda­chin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—Chi­ura, patrunka nirkasi: “Ñambi suiu rispa, mai­kan tupas­ka­kuna­ta­pas iaiku­chig­rii, kai nuka­pa wasi jundan­kama. ");
INSERT INTO inb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nii­ki­chitami: nuka ñugpa kunbidaska runa­kuna, ñi pipas kai suma mikuita mana mikun­ga­pa kan­kuna­chu”. ");
INSERT INTO inb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iapa achka runa­kuna Jesusta kati­raiar­ka­kuna. Paika, tigra­rispa, nir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mai­kan­pas, nuka­wa samun­ga­pa munas­paka, taitata i maman­dita, warmindita, wam­bra­kunata, waugki i panindi­kunata, kikin­pa kaug­sai­ta­pas mana sakig­sina rurag­pika, mana nukata kati­raia­wag ni­raian­chu. ");
INSERT INTO inb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mai­kan­pas mana krusta marka­rig­sina ruraspa kati­raia­wag­kunaka, mana nuka­wa purig­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Mai­kan kam­kuna­pura, atun awa wasi ruran­ga­pa munas­paka, mana­ra kalla­rispa­lla, ¿mana­chu tia­rin­tra, iuia­rin­ga­pa: mai­tuku kulki­wa­sik pagta­wanga puchukagta ruran­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana chasa iuia­rispa­lla kalla­rig­pika, pudin­mi mana puchukanga. Nig­pika, tukui chasa kawag­kuna, asispa­mi ");
INSERT INTO inb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nin­ga­kuna: “Kai runa, wasi rurai kalla­ris­paka, mana puchukai pudirka­chu”. ");
INSERT INTO inb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Chasa­lla­ta mai­kan mandag, sug­nig­manda mandagwa manara wañu­chi­na­kun­ga­pa llugsispa­lla, ¿mana­chu iuia­rin­tra: chunga wa­ran­ga suldadu­kuna­lla­wachu pagta­wanga, sug mandag iskai chunga waranga suldadu­kuna samu­na­kus­ka­wa wañu­chi­na­kun­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana pudinga­sina kawas­paka, chi sug mandag chara karupi samu­kugpita, mañanga­pa­mi kachanga, mana wañu­chi­na­kui tiachu. ");
INSERT INTO inb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Chasa­lla­ta mai­kan kam­kuna­purapas, tukui ima iukas­kata mana sakig­sina rurag­pika, mana nuka­wa purigmi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Kachi, allilla­mi ka. Kachi waglli­rig­pika, mana pudi­ringa­chu kachia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Alpa suiu ichan­ga­pa, ñi majada alpa mun­tu­na­ra­ias­kapi chu­ran­ga­pa ñi ima­pa­pas mana balin­ga­pa kan­chu. Chasa­taka, sitai­mi chaiá. Rinri iukag­kuna, nuka nis­kata uia­waspa, suma iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mana judíu kag­kuna­man­da kulki chaskig­kuna i mana alli­llata rurag­kuna, achka­kuna­mi Jesus­pagma kailla­ia­na­kurka, paita uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Chasa kawas­paka, fari­seo­kuna i Moisés ima nis­kata iacha­chig taita­kuna mana alli­lla iuiai­wa pai­manda ni­na­kurka: —Chi runa, mana alli­lla rurag­kunata chaskispa, pai­kuna­wa sug­lla­pi­mi miku­ku. ");
INSERT INTO inb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesuska, chipi kag­kunata iuiai apinga­sina suma parlarka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mai­kan kam­kuna­pura, patsa ubija iukaspa, sug ubija chinga­pug­pika, ¿mana­chu iskun chunga iskunta sakispa, maskai kalla­rin­tra, chi ubijata tarin­kama? Ari. ");
INSERT INTO inb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Chi chingas­kata ta­ris­paka, iapa kun­tin­ta­rispa, markaspa­mi apanga. ");
INSERT INTO inb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Paipa wasima chaiag­ris­paka, iacha­ridu­kunata i ladu suiu kaug­sa­na­kus­kata kaiaspa, ningami: “Nuka­wa tukui­kuna suma kun­tin­ta­ri­puai­chi. Chi ubija chinga­puaska, ñami tari­ri­warka”. ");
INSERT INTO inb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kasa­mi nii­ki­chita: chasa­lla­ta kag­sina iuia­ri­sun­chi: iskun chunga iskun alli­lla rurag­kuna mana minis­tin­kuna­chu, alli­lla rurai­kunama tigrag­sina tukun­ga­pa. Ikuti sug panda­rig runa alli­lla rurai­kunama tigramu­uraka, pai­manda­mi mas suma kun­tin­ta­rispa iuiai­wa suma luar­manda kawan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Chasa­lla­ta mai­kan warmi, chunga kuri kulki iukaspa, sug kulki chinga­pug­pika, ¿mana­chu bila sindi­chispa, wasi ukuma suma alli­manda pichanga, ima­ura chinga­pus­kata tarin­kama? ");
INSERT INTO inb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Taris­paka, paipa iacha­ridu­kunata i ladu suiu kaug­sa­na­kus­kata kaias­pa­mi ninga: “Nuka­wa tukui­kuna suma kun­tin­ta­ri­puai­chi. Chi kuri kulki chinga­puaska, ñami tari­ri­warka”. ");
INSERT INTO inb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kasa­mi nii­ki­chita: chasa­lla­ta sug panda­rig runa alli­lla rurai­kunama tigramu­uraka, Dius­pa anjil­kuna­pas alli iuia­chi­rispa­mi kawan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kasapasmi Jesús nirka: —Sug runa, iskai wam­bra­kunasi iukarka. ");
INSERT INTO inb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uchulla waugkika, taitata nirka: “Taita, kam ima saki­wan­ga­pa kas­kata nukata kara­wai”. —Chi­ura taitandi, ima iukas­ka­ta pai­kunata chaugpi chaugpi kararka. ");
INSERT INTO inb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Mailla puncha­kuna iali­uraka, chi uchulla waugkika, tukui ima karas­kata katuspa, kulki tanda­chispa, sug karu alpamasi rirka. Chipika, mana alli­lla rurai­kunapi tukui kulkita puchukarka. ");
INSERT INTO inb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Tukui tuku­chispa ka­uraka, chi alpapi iapa iarkai tukug­samurka. Chi­ura, chi musutaka iapa iarkai pasai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chasa kas­paka, sug chi­manda runa­pagma chaiag­ris­kataka kacharka, kuchi­kunata mikui karag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chi­uraka, diiarkai muna­kurka, kuchi­kuna miku­nakus­ka­ta­pas paipa wigsa junda­chi­rin­ga­pa. Chasa muna­kug­pipas, ñi pi mana paita sakir­ka­kuna mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Chi­uraka iuia­rirka: “Nuka­pa taita­pagpi, tukui piun­kuna­mi mikun­kuna mai­tuku munaska. Ikuti nukaka, diiarkai­mi kai­pi wañu­kuni. ");
INSERT INTO inb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ata­rispa, risa. Nuka­pa taita­pagma rispa, kasa­mi nig­risa: ‘Taita Dius­manda i kam taitata mana alli­lla rurai­wa­mi panda­rirkani. ");
INSERT INTO inb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mana chaia­wa­kun­chu, kam nukata: “wam­bra” ni­wan­ga­pa. Kamba sug lutrinta­sina kan­ga­pa chaski­wai’.” ");
INSERT INTO inb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Chasa iuia­rispa, ata­rispa, taita­pagma rii kalla­rirka. —Chara karu chaiag­rin­ga­pa pisi­kugpita, taitandika, kawaspa, pai­manda iapa llakii piarka. Kalpa­lla rispa, tupag­rirka. Ugllas­pa, kuiaspa mucharka. ");
INSERT INTO inb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chi­uraka, wam­bra nirka: “Taita Dius­manda i kam taitata mana alli­lla rurai­wa­mi panda­rirkani. Mana chaia­wa­kun­chu, kam nukata: ‘wam­bra’ ni­wan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Taitandika, nis­ka­kunata mana uiaspa­lla, piun­kunata nirka: “Utka mas suma katan­ga­kunata apa­muspa, chura­chi­puai­chi. Chasa­lla­ta makipi surtija, chaki­kunapi chura­ri­dirupas chura­chi­puai­chi. ");
INSERT INTO inb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mai­kan mas wira wagrata apig­rispa, wañu­chii­chi. Mikuspa, tukui­kuna iapa suma kun­tin­ta­ri­sun­chi. ");
INSERT INTO inb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kai nuka­pa wam­braka, ña wañuska­sina kaspa­pas­mi kaugsa­riska tuku­puarka. Chingaska­sina kaspa­pas­mi tari­ri­warka”. Chi­ura, kusi­kui atun puncha­sina iali­chii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Atun waugkika, chagrapi kaspa, wasima kuti­muspa chaiag­samu­ku­ura, musika uia­chi­na­kus­kata i baila­na­kus­kata uiarka. ");
INSERT INTO inb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sug piunta kaias­paka, tapurka: “¿Ima atun punchatak kaipi iali­chi­nakú?”. ");
INSERT INTO inb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—Chi­ura, chi runa ainirka: “Kamba waugkimi kuna­ura cha­ia­murka, alli­lla, mana ungug. Chi­manda­mi kamba taita kacharka, suma wira wagrata wañu­chispa, mikuspa, kun­tin­ta­rin­ga­pa­kuna”. ");
INSERT INTO inb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Chasa uias­paka atun waug­kin­dika, rabia­rispa, mana ukuma iaikun­ga­pa muna­kurka. Chi­manda taitandika, llugsispa, nirka: “Iaiku­mui”. ");
INSERT INTO inb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","—Paika ainirka: “Taita, uia­wai. Mai­tuku wata­kuna kam ima ni­was­kata ima­ura­pas alli­lla ruraspa­lla kaug­sa­kuni. Chasa kag­pi­pas, nukata ñi ima­ura­pas mana kara­wangichu ñi sug kuchi­lla­pas, nuka iacha­ridu­kuna­wa mikuspa, kun­tin­ta­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kuna­ura ñasi kamba wam­brakar chaia­mu­purkangi, chi mana alli warmi­kuna­wa kam kulki karas­kata tukui­ta puchu­kaspa. Pai­mandakar mai­kan mas wira wagratasi wañu­chirkangi mikun­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Chasa uiaspa, taitandika nirka: “Nuka­pa wam­britu, kamka ima­ura­pas nuka­lla­wa­mi kangi. Tukui nuka ima iukas­kaka, kamba­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Chasa kagpi­pas, kuna­uraka nukan­chita chaia­kumi, alli iuia­chi­rispa, kusi­ku­chii atun puncha­sina iali­chin­ga­pa. Kamba waugki, ña wañuska­sina kaspa­pas, kaug­sa­mi ka. Chingaska­sina kaspa­pas, tari­ri­war­kami”. ");
INSERT INTO inb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kasapasmi kati­raiag­kuna­ta iuiai apinga­sina iacha­chirka: —Sug iapa iukag runa, pai ima iukas­kata kawan­ga­pasi sakirka. Mana unai­lla­pika, patrunta willar­ka­kuna, imasa chi kawag tukui tia­pus­ka­kunata tuku­chi­pu­kugta. ");
INSERT INTO inb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Chi­ura patrunka, chi kawagta kaiaspa, nirkasi: “Kam­manda, ¿imasatak nukata willa­wa­nakú? Kam imasa trabaju­kuna ruras­kata kawa­chi­wai. Ña kuna­ura­manda, mana mas nuka ima iukas­ka­ta kawa­puag kan­ga­pa kangichu”. ");
INSERT INTO inb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Chi­ura, chi runataka iuia­rirka: “¿Imasa­mi rurani? Nuka­pa patrun, ñami llugsi­chi­wa­ku. Mana animu iuka­nichu, alpa pikan­ga­pa. Limusna mañaspa purin­ga­pa, nukata pingaimi iuia­chiwá. ");
INSERT INTO inb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ñami iuia­ri­warka, ima nuka ruran­ga­pa kagta; nuka ñi pipa kawag­pas mana ka­ura, mai­kan­pas pai­kunapa wasima nukata kaia­wan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Chasa iuia­ris­paka, paipa patrunta dibi­na­kus­kata sug sug­llasi kaiarka. Sug runata tapurka: “¿Masa­tak nuka­pa patrunta dibi­kungi?”. ");
INSERT INTO inb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—Chi­ura ainirka: “Patsa baril asitimi dibi­kuni”. —Chasa uias­paka, chi kawagka nirkasi: “Chiká. Kam, patrunta dibi­kuska listata kawai. Nis­paka, utka tia­rispa, pichka chungalla dibi­kugta churai”. ");
INSERT INTO inb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Chasa­lla­ta, sug runata tapurka: “Kamka, ¿mai­tukutak dibi­kungi?”. —Chi­ura ainirka: “Patsa tupu trigumi dibi­kuni”. —Chasa uias­paka, chi kawagka nirka: “Chiká. Kam, patrunta dibi­kuska listata kawai. Nis­paka, pusag chungalla dibi­kugta churai”. ");
INSERT INTO inb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Patrunka, paipa mana alli kawag ima ruras­kata iachas­paka, nirkasi: “Mana alli­lla ruraspa­pas, su­urapipaka alli­lla­mi rurarkangi”. Chasa­lla­ta, kai alpapi tias­ka­kuna­lla­wa iuia­rispa kag­kunaka, kikin­pura imasa chaiaska­sina rura­dur­mi kan­kuna, Taita Dius punchaia­chiska runa­kuna­manda­pas mas. ");
INSERT INTO inb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Kasami nii­ki­chita: kai mana alli alpa­manda iukas­ka­kuna­wa chita karaspa maskan­gi­chi, iacha­ridu runa­kuna iukan­ga­pa. Chi­wanka, kai alpapi ima iukaska tuku­ri­uraka, kam­kunata ñi ima­ura­pas mana tuku­ri­diru suma luarpi kaug­sanga­pa­mi kaian­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Mai­kan­pas, asllita min­gas­ka­ta alli­lla rurag­pika, chasa­lla­ta­mi achka mingas­ka­ta­pas alli­lla ruranga. Ikuti mai­kan­pas, asllita min­gas­ka­ta mana alli­lla rurag­pika, chasa­lla­ta­mi achka mingas­ka­ta­pas mana alli­lla ruranga. ");
INSERT INTO inb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kai mana alli alpa­manda kulki u ima­pas iu­kas­ka­ta kam­kuna mana alli­lla rurag­pika, ¿imasatak suma luar­manda sutipa iukai­kunata kam­kunata mingan­ga­kuna? ");
INSERT INTO inb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chasa­lla­ta, sug­kuna mingas­kata mana alli­lla rurag­pika, ¿imasatak kam kikin­kunata chaia­kus­kata kuan­ga­kuna? ");
INSERT INTO inb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Ñi mai­kan­pas, iskai patrun­kunapa sug­lla­pi mana trabaja­pun­ga­pa pudin­ga­pa kan­kuna­chu. Sug patrunta mana munanga­chu; ikuti sugtaka kuiangami. Sug patrunta wabutingami; ikuti sugtaka sumag­lla­mi rimanga. Chasa­lla­ta, Taita Diusta i kai alpa­manda iukai­kunata mana pudinkan­gi­chi­chu, iskandima su­ura­lla iuia­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Chasa uiaspa fari­seo­kunaka, iapa kulki iukan­ga­pa iuia­rii­lla­wa kaspa, Jesusta unz̈ar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesuska nir­ka­kunata: —Kam­kuna, runa­kunapa ñawi­pi iapa alli­lla rura­na­kug­sina­mi kan­gi­chi. Chasa kagpi­pas, Taita Dius­ka iachan­mi kam­kuna ima iuia­na­kugta. Kai alpa­manda­kunalla atun­ia­chiska runa­kunata, pai mana munan­chu. ");
INSERT INTO inb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Moisés i Santu Ispi­ri­tu­wa rimag­kuna ima willa­raiaska, Juan Bau­tista kaug­san­kama­lla­mi chaia­murka. Chi­ura­mandaka, Dius­pa suma mandai­manda Alli Willai­lla­wa­mi willai tian­ga­pa ka. Tukui­kuna­mi muna­nakú, imasa­pipas chima iaikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Sug luar i kai alpa luar tuku­rig­sina kagpi­pas, chi ñugpa­manda ima willa­raias­kaka ñi mailla mana ialin­ga­pa kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Kasapasmi nii­ki­chita: mai­kan­pas, kikinpa warmita sitaspa, sug warmi­wa kasarag­pika, atun panda­riimi rurá. Chasa­lla­ta, mai­kan­pas kusa sitaska warmi­wa kasarag­pika, atun panda­riimi rurá. ");
INSERT INTO inb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Sug iapa iukag runasi tiarka. Paika, iapa suma katanga chu­ra­rispa, atun puncha­sina iapa alli mikui­lla­wa kuntintulla iuia­chi­rispasi tukui puncha­kuna iali­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ikuti Lázaro suti ñi ima mana iukag runasi tiarka. Chi runa, aicha ismui ungui iukarka. Paika, chi iapa iukagpa wasi pungupi sitaska siri­kuspa, ");
INSERT INTO inb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","muna­kurka, mikui miku­nakus­ka­manda urmas­ka­wa wigsa junda­chi­rin­ga­pa. Alku­kunalla, kailla­iaspa, paipa aicha ismus­ka­kunata llakua­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Chasa kaug­sas­paka, chi mana iukag runa wañurkasi. Pai­taka, anjil­kuna sug luarma apar­ka­kuna, ñugpa­manda taita Abra­ham kaska­ma. Chi iapa iukag­pas wañurka. Paitaka sumag­lla pam­bar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chi­ura paika, mana wañu­diru ninapi rupa­kuspa, iapa llakii­wa kaspa, chi­manda wichai kawas­paka, karupi Abra­hamta i Lázaro paipa mig­lla­pi chari­kus­kata kawarka. ");
INSERT INTO inb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Abra­hamta kapa­rispa, nirkasi: “Taita, nuka­manda llaki­ri­wai. Lazarota kacha­mu­wai, maki didu punta­lla­ta­pas iakupi juku­chispa, nuka­pa kalluta chiria­chi­wag­samuchu. Kai nina sindi­kus­kapi iapa­mi rupa­kuni. Tukui nanaimi iukani”. ");
INSERT INTO inb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Chi­ura, Abra­hamka ainirka: “Wam­bra, iuia­rii: kam kaug­san­kama, kamba iukai­wa iapa sumag­lla­mi kaug­sarkangi. Ikuti Lazaroka, tukui llakii­kuna­mi kaug­san­kama iukarka. Kuna­uraka, kaipi pai alli iuia­chii­wa­mi kuntintulla ka. Kamka iukangimi, tukui llakii­wa nanai­wa kanga. ");
INSERT INTO inb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kasapas. Nukan­chi­wa kam­kuna­wa tupa­rin­ga­pa, iapa atun waiku­sina­mi tia. Chi­manda mai­kan­pas kai­manda kam­kuna­pagma ialin­ga­pa munaspa­pas, mana alli kan­chu. Chasa­lla­ta, kam­kuna­pag­manda kaima iali­mun­ga­pa munas­pa­pas, mana alli kan­chu”. ");
INSERT INTO inb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Chi­ura, chi iukag runa nir­kasi: “Nuka­pa taita, mañaikimi: Lazarota kacha­puai nuka taitapa wasi­ma. ");
INSERT INTO inb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pichka waugkindi­kuna­mi chipi iukani. Pai­kunata nuka­manda willag­rigpi, uias­paka, mana kai iapa llakii ka­diruma samun­ga­pa chaian­ga­kunatachu”. ");
INSERT INTO inb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Abra­hamka nirkasi: “Moi­sés i Santu Ispi­ri­tu­wa rimag­kuna imasa kaug­san­ga­pa willa­raias­ka­kunata iukan­kuna­mi. Chi­kunata alli­lla iuia­rispa uia­chu­kuna”. ");
INSERT INTO inb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Chi iukag runa, Abra­hamta ainirka: “Mana, taita. Sug wañuska kaugsa­rispa, pai­kuna­pagma chaiag­rig­pika, alli­lla rurai­kuna­ma­mi tigraspa, suma kaug­sai kalla­rin­tra­kuna”. ");
INSERT INTO inb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Chasa aini­ura, Abra­hamka nirkasi: “Moisés i Santu Ispi­ri­tu­wa rimag­kuna ima willa­raias­kata mana uiai munas­paka, mana uian­ga­kuna­chu, ñi sug wañuska kaugsa­rigpi­pas”. ");
INSERT INTO inb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kasapasmi Jesús, paita kati­raiag­kunata nirka: —Ima­urapasmi tian­ga­pa ka, runa­kunata panda­rii­kunapi urma­chin­ga­pa. Chasa tiagpi­pas, ¡ai, mai­kan runa, sug­kunata panda­rii­kunapi urma­chig! ");
INSERT INTO inb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mai­kan kai uchulla­kunata panda­chi­puag­pika, paita chaian­trami, sug atun kutanga rumi kungapi walka­chispa, atun kucha iakuma sitag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Suma iuia­rii­chi. Mai­kan­pas mana alli­lla ruraipi panda­rig­pika, paita iuia­chispa rimangi. Alli tukug­pika, pasin­siangi. ");
INSERT INTO inb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sug­lla puncha kan­chis biaji kamta mana alli­lla ruraspa, kamta nig­samuchu: “Mana mas ikuti chasa rura­sa­ki­chu”: tukui kan­chis biaji pasin­sian­gi­lla. ");
INSERT INTO inb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chi­ura Iaia Jesús agllaska runa­kuna, paita nir­ka­kuna: —Nukan­chita aidai, kam­manda mas iuia­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Paika nirka: —Sug uchulla muritu mustasa­sina­lla­pas kam­kuna nuka­manda iuiai iukan­tran­gi­chi; kai sachata nin­tran­gi­chi: “Kai­manda anchu­rispa, atun kucha iakupi saia­rig­rii”. Chi­ura­lla­mi chi sacha, chasa ruran­tra. ");
INSERT INTO inb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Kamba lutrin chagrapi tra­ba­ja­kuspa u wagra kawa­kuspa, kuti­mu­uraka, ¿mai­kan kam­pura­tak nin­trangi: “Tia­rispa, mikug­samui”? ");
INSERT INTO inb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chasapaka, nin­tran­gimi: “Alli­chi­rispa ianui, nukata kara­wan­ga­pa. Nuka mikusa i upia­sa. Chi­ura­mandaka, kamka mikungi i upian­gi”. ");
INSERT INTO inb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Kam­kuna ima nis­kata rurag lutrintachu iukan­gi­chi ninga: “Pai Siñur”? Manima. ");
INSERT INTO inb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chasa­lla­ta kam­kuna­pas, tukui imasa Taita Dius niska­sina ruras­paka, nin­gi­chi: “Ñi imapa mana bali lutrin­sina­kuna­mi kan­chi. Nukan­chita ruran­ga­pa chaia­kuska­lla­ta­mi rurar­kan­chi”. ");
INSERT INTO inb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jeru­salenma ri­kuspa, Sama­ria i Gali­lea alpa kuchu kuchu ialirka. ");
INSERT INTO inb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Sug uchulla pui­blupi chaia­kug­ri­uraka, chunga runa­kuna aicha ismui ungui­wa kag­kuna pai­pagma rir­ka­kuna tupan­ga­pa. Karu­lla­pi saia­ris­paka, ");
INSERT INTO inb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sin­chi kapa­rispa, nir­ka­kuna: —Iacha­chig taita, nukan­chi­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chi runa­kunata kawas­paka, Jesuska nirka: —Sasir­duti­kunata kawa­chi­rig­rii­chi. Imasa uiaska­sina ñambi ri­na­kus­kapika, ambi­rig­samur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ambi­riska­pura sug­lla, chasa kawa­ris­paka, Jesus­pagma kutirka. Kutis­paka, Taita Diusta iapa suma atun kagta kapa­rispa ni­kurka. ");
INSERT INTO inb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesuspa chaki ladu kungu­rispa, ña­lla­pas alpa­kama kumu­rispa, nirka: “Pai Siñur”. Chi runa karka Sama­ria suti alpa­manda. ");
INSERT INTO inb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nigpi Jesuska, chipi kag­kuna­ta nirka: —¿Manachu chunga runa ambi­riska kan­kuna? Sug iskun­kuna­ka, ¿maipitak kan­kuna? ");
INSERT INTO inb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ima­pa­tak kai mana judíu runalla kuti­murka, Taita Diusta iapa suma atun kagta nin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chasa nis­paka, chi runata nirka: —Ata­rispa riilla. Kam nuka­manda suma iuia­ris­ka­manda­mi ambi­rig­samurkangi. ");
INSERT INTO inb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fari­seo­kuna, Jesusta tapur­ka­kuna: —Dius­pa suma mandai puncha, ¿ima­uratak chaia­mun­ga­pa ka? Chi­ura, paika ainirka: —Dius­pa suma mandai puncha chaia­mugtaka kam­kunapa ñawi­wa mana kawan­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mana nin­ga­pa pudi­rin­chu: “Kai­pi­mi ka” u “Chi­pi­mi ka”. Kam kikin­kunapa chaugpi­pi­mi Taita Dius­pa suma mandaika ña tiag­samú. ");
INSERT INTO inb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chasa nis­paka, paita kati­ra­iag­kunata nirka: —Kai Runa Tukuska illa­ura, kam­kuna munan­tran­gi­chimi: “¡Ama­lai sug­lla puncha­lla­pas kuti­muspa kawa­rig­samun­tra!”. Kam­kuna chasa munagpi­pas, mana chasa kawa­wan­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chi­ura, kam­kunata nuka­manda ni­na­kungami: “Chi­pi­mi ka” u “Kai­pi­mi ka”. Chasa ni­na­kugpi­pas, mana kawan­ga­pa katin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imasa­mi rilampa, awapi sug­nig­manda punchaia­chig­samuspa, sug ladu­kama punchaiachí: chasa­lla­ta­mi iapa suma punchaia­chii­wa kuti­muspa, kai Runa Tukuska kawa­rig­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","—Ima kagpi­pas, ñugpa­mi kai Runa Tukus­kata chaia­wa­ku, iapa lla­kii i nanai pasan­ga­pa. Kuna­ura­manda runa­kuna­mi wabuti­wan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Imasami, Noé kaug­sa­ku­ura, mana iuia­na­kuska­sina tukug­samurka: chasa­lla­ta­mi kai Runa Tu­kuska kawa­rig­samun­ga­pa pun­cha tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé kaug­sa­kuska puncha­kunaka, sumag­lla mikuspa, upiaspa, kasa­raspa­mi kaug­sa­na­kurka, Noé ruraska atun kanuapi iaikun­kama. Chi­ura, iapa atun tamia tukug­samuspa, tukui­kunata puchukag­samur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chasa­lla­ta, Lot kaug­sa­ku­ura, mana iuia­na­kuska­sina­mi tukug­samurka; Sodoma suti pui­blu­manda­kuna, sumag­lla mikuspa upiaspa, randispa katuspa, tarpuspa wasi­chispa kaug­sa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot chi pui­blu­manda llugsi­uraka, nina i asufrimi, awa­nig­manda tamiag­samuspa, tukui­kunata puchukag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cha­sa­lla­ta­mi kai Runa Tukuska kawa­rig­samun­ga­pa punchapas tukug­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Chi puncha, mai­kan­pas wasi truja awapi kag­kuna mana urai­ku­chu­kuna, ukuma iaikuspa, ima­kuna apan­ga­pa. Imasa kaska­sina­lla miti­ku­chu­kuna. Chasa­lla­ta, mai­kan­pas chagrapi kag­kuna mana wasima kuti­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot­pa warmi imasa pasas­kata iuia­rii­chi. ");
INSERT INTO inb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mai­kan kikinpa kaug­sai­ta kispi­chinga­pag­lla iuia­kug­pika, kikin­mi puchuka­rin­ga­pa ka. Ikuti mai­kan­pas nuka­manda wañu­chii tukug­pika, mana mas wañui kaug­sai­ta­mi tarin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Kasami nii­ki­chita: chi tuta, sug­lla kawitupi iskai­kuna kas­ka­kunata, sugtaka apangami; sugtaka sakingami. ");
INSERT INTO inb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chasa­lla­ta, iskai war­mi­kuna sug­lla­pi kuta­na­kus­ka­ta, sugtaka apangami; sug­taka sakingami. ");
INSERT INTO inb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chi­ura, chasa uiag­kuna tapur­ka­kuna: —Taita waugki, ¿maipitak chasa pasa­ringa? ");
INSERT INTO inb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Chasa tapu­ura, Jesuska ai­nirka: —Imasami gallinasu­kuna, pipas mana willagpi, pai­kuna wañuska kaska­ma tanda­rin­kuna: chasa­mi tukug­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús, chipi kag­kunata iacha­chirka, ima­ura­pas mana samba­iaspa­lla Taita Diusta mañan­ga­pa chaiagta. Chasaka, iuiai apinga­sina suma parlar­ka­kunata, ");
INSERT INTO inb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","kasa nispa: —Sug pui­blupi tiarkasi sug jus­ti­siai rurag. Chi runa, Taita Diusta ñi pi­ta­pas mana mancharka. ");
INSERT INTO inb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chi pui­blu­lla­pita tiarkasi sug sapa­lla kidaska warmi. Chi war­mika, jus­ti­sia­pagma ikuti ikuti mañan­ga­pa ri­kurka, kasa nispa: “Nukata piña­wagta kaiaspa, jus­ti­sia­puai”. ");
INSERT INTO inb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","—Achka puncha­kuna rigpi­pas, chi jus­ti­siai rurag, paita mana uian­ga­pa munarka. Nis­paka, kikinlla iuia­rirka: “Taita Diusta ñi pi­ta­pas sutipa mana manchani. ");
INSERT INTO inb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Chasa kagpi­pas, chi sapalla warmi iapa killa­chi­wa­kug­mandaka, pai­manda jus­ti­sia­pu­sami. Chimi pai mana mas killa­chi­wag­samunga”. ");
INSERT INTO inb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kasapasmi Iaia Jesús nirka: —Chi mana imasa chaiaska­sina jus­ti­siai rurag ima nis­kata iuia­rii­chi. ");
INSERT INTO inb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Mana­chu Taita Dius agllas­ka­kuna tuta i puncha paita maña­na­kug­pika, paika jus­ti­sia­punga, unaia­chispa­pas? ");
INSERT INTO inb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kasa­mi nii­ki­chita: mana unaiaspa­lla­mi pai­kuna­manda jus­ti­sianga. Chasa kagpi­pas, kai Runa Tukuska ikuti samu­uraka, ¿pai­manda suma iuiag­kuna, kai alpapi charachu tianga? ");
INSERT INTO inb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sug runa­kuna: “Nuka, tukuipi alli­mi kani” iuia­rispa, sug­kunataka wabuti­na­kurka. Chi­kunata iuiai apinga­sina, Jesuska suma parlarka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Iskai runa­kuna, Dius­pa atun wasimasi rir­ka­kuna, paita iuia­rispa mañan­ga­pa. Sug karka fari­seo; sugka, mana judíu kag­kuna­manda kulki chaskig. ");
INSERT INTO inb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fari­seoka, saia­rispa­lla, Taita Diusta rima­kug­sina kikin­manda­lla kasa ni­kurka: “Nuka­pa Dius, nuka mana sug­kuna­sina ka­nichu. Ñi sisai, ñi panda­rig, ñi sugpa warmi­kuna­wa siri­rig ñi kai kulki chaskig­sina­pas mana ka­nichu. Chi­manda­mi niiki: ‘Pai Siñur’. ");
INSERT INTO inb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Simanapi iskai punchami mana mikuspa­lla chisia­dur kani. Tukui nuka ima ganas­ka­ta­pas chungapika sug­mi kara­dur kaiki”. ");
INSERT INTO inb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Ikuti chi kulki chaskigka, karu­lla­pi kumu­ridu saia­kurka, mana awa­sinama ñawi­lla­pas ata­ri­chispa­lla. Pichupi maki­wa pia­rispa, ni­kurka: “Nuka­pa Dius, nuka­manda llaki­ri­wai. Nuka, iapa panda­rigmi kani”. ");
INSERT INTO inb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Kasami nii­ki­chita: chi kulki chaskig wasima kuti­uraka, pai­ta­mi Taita Dius, pasin­siaspa, nirka: “Mana panda­rigmi ni­raia­puangi”. Ikuti chi fari­seotaka chasa manima. Mai­kan­pas atun­ia­chi­rispa iuiagta, Taita Diuska uchullaia­chinga­pa­mi ka. Ikuti mai­kan­pas uchullaiaspa iuias­kataka, Taita Dius atun­ia­chinga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Su­ura uchulla­kunata, pai­kuna­pa atun­kuna Jesus­pagma pusar­ka­kuna, pai­kunata maki churaspa, Taita Diusta pai­kuna­manda mañan­ga­pa. Jesusta kati­ra­iag­kunaka, pusa­na­kugta piñaspa, nir­ka­kuna: —Mana kailla­ia­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesuska, wawa­kunata kaias­pa, paita kati­raiag­kunataka nirka: —Ianga kawai­chi, wawa­kuna nuka­pagma samu­chu­kuna. ¿Ima­pa­tak arka­na­kun­gi­chi? Kai wawa­kuna­sina kag­kuna­mi suma luar­ma iaikug­rin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kasa­mi nuka nii­ki­chita: mai­kan­pas, mana Dius­pa ñawipi kai uchulla­kuna­sina alli­lla tukug­samug­pika, mana suma luarma iaikug­rin­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sug mandag runa, Jesusta tapurka: —Alli iacha­chig taita, ¿imasatak iukani ruranga, mana puchuka­ri­diru suma kaug­saita tarin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesuska ainirka: —¿Imapatak nukata: “Alli iacha­chig taita” ni­wa­kungi? Mai­kan­pas mana alli tian­chu. Taita Dius­lla­mi alli ka. ");
INSERT INTO inb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moisés ima nis­kata ñami iachangi: “Mana sug­pa warmi­wa siri­ringi. Mana wañu­chingi. Mana sisangi. Mana pi­manda­pas llullangi. Kamba taita­ta mamandita sumag­lla kuiangi”. ");
INSERT INTO inb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chi­ura, chi runa ainirka: —Nuka, uchulla ka­ura­manda­ta­mi tukui chi nis­kata chasa ruraspa kaug­sani. ");
INSERT INTO inb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chasa uiaspa, Jesuska nirka: —Nig­pika, kasa­mi pisi­pu­kungi. Kam tukui ima iukas­kata katug­rii. Katuska kulkitaka mana iukas­ka­kunata tukuita karag­rii. Chasa ruras­paka, suma luarpika iapa iukag­mi tukun­ga­pa kangi. Nis­paka samun­gi, nukata kati­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chasa rimas­kata uias­paka, chi runa irkiaspa­mi llaki­rirka, iapa iukag kaspa. ");
INSERT INTO inb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chasa llaki­rigta kawas­paka, Jesuska nirka: —Iapa iukag­kuna suma luarma iaikug­rin­ga­paka, iapa trabajusumi ka. ");
INSERT INTO inb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maschar alli kan­tra, sug wa­gra, sug aguja ñawipi ialin­ga­pa. Chi­manda mas trabajusu­mi ka, chi iapa iukag­kuna suma luarma iaikug­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Chasa uiag­kuna tapur­ka­kuna: —Nig­pika, ¿pi­sik kispi­rin­ga­pa pudinga? ");
INSERT INTO inb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Chi­ura, Jesuska ainirka: —Ñi mai­kan runa mana pudis­ka­taka, Taita Dius­mi tukui pudí. ");
INSERT INTO inb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Chi­ura, Pedroka nirka: —Uiamui. Nukan­chi, tukui ima iukas­kata sakispa­mi kamta kati­raian­chi. ");
INSERT INTO inb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesuska, pai­kunata ainirka: —Kasami nuka nii­ki­chita: mai­kan­pas, Dius suma man­da­kus­kata munaspa, wasita, war­min­dita, waug­kin­di­kunata, taita i maman­dita i wam­bra­kunata sakispa kati­wagka, ");
INSERT INTO inb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mas achka­mi kai alpapita chaskin­ga­pa kan­kuna. Suma luar­pipas mana puchuka­ri­diru kaug­sai­ta­pas­mi tarig­rin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Chunga iskai pai agllas­ka­kuna­lla­ta kaias­paka, Jesuska nirka: —Uia­wai­chi. Jeru­salen­ma­mi ri­na­kun­chi. Chipika, tukui ima Santu Ispi­ri­tu­wa rimag­kuna kai Runa Tukus­ka­manda ñugpa­manda librupi willa­raias­kata tukuipi chasa­mi pasa­ri­wan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mana judíu kas­ka­kuna­pag­ma­mi chaia­chii tukun­ga­pa kani. Pai­kuna unz̈a­waspa, kami­waspa, tuka­was­pa­mi kan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Asuti­was­paka, wañu­chi­wan­ga­pa­mi kan­kuna. Chasa wañuska kaspa­pas, kimsa punchapika ikuti­mi kaugsa­rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Chasa nis­kataka, kati­raiag­kuna mana iachar­ka­kuna ima ni­raiagta. Pai­kuna­manda pakaska kag­sina karka; chi­wanka, chi ima ni­raias­kata mana iachan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús ña Jerikó pui­bluma chaia­kug­ris­kapika, sug runa mana ñawi kawag, limusna mañaspa ñambi kuchupi tia­kurka. ");
INSERT INTO inb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chi runaka, achka­kuna iali­na­kus­kata uiaspa, tapurka: —¿Imatak pasa­ri­ku? ");
INSERT INTO inb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Chi­ura ainir­ka­kuna: —Nazaret pui­blu­manda Jesus­mi iali­ku. ");
INSERT INTO inb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Chasa uiaspa, chi runaka kapa­rirka, kasa nispa: —Davidpa wam­bra Iaia Jesús, nuka­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ñugpa ri­na­kug, paita piñaspa, nir­ka­kuna: —Upalla kai. Paika, upallanga­taka, mas sin­chi­mi kapa­rii kalla­rirka, nispa: —Davidpa wam­bra, nuka­manda llaki­rii. ");
INSERT INTO inb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Chasa uias­paka Jesuska, saia­rispa, kacharka, chi runata pusan­ga­pa. Chaia­chig­ri­uraka, paita tapurka: ");
INSERT INTO inb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Imatak muna­kungi, nuka kamta ruran­ga­pa? Chi­ura ainirka: —Taita waugki, nuka kawanga­pa­mi muna­kuni. ");
INSERT INTO inb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chi­ura, Jesuska nirka: —Nig­pika, kawai. Kam nuka­manda suma iuia­ris­ka­manda­mi ambi­rig­samungi. ");
INSERT INTO inb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chasa nig­lla­pi, alli­lla kawai kalla­rirka. Nis­paka, Jesusta katii kalla­rirka, Taita Diusta nispa: —Kam, iapa suma atun­mi kangi. Chasa kawaspa, tukui chipi kag­kuna­pas Taita Diusta nir­ka­kuna: —Tukui­kuna­manda mas suma atun­mi kangi. ");
INSERT INTO inb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Chi Jerikó pui­blu ukupi, Jesús ña iali­kurka. ");
INSERT INTO inb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chipi kaug­sa­kurka Zakeo suti iapa iukag runa, mana judíu kag­kuna­manda kulki chaskig­kunata mandag. ");
INSERT INTO inb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chi runa muna­kurka, Jesusta rigsin­ga­pa. Chasa muna­kuspapas, iapa achka runa­kuna chipi kag­mandaka, paitaka mana alli karka kawan­ga­pa, iapa uchulla runa kaspa. ");
INSERT INTO inb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chi­mandaka, ñugpa kalpaspa, maipi Jesús ialin­ga­pa kas­kapi sug sikó­moro suti sachapi sikag­rirka, chi­manda kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Chi ladu­lla­pi Jesuska, iali­kuspa, wichai kawaspa, Za­keo­ta nirka: —Utka uraiku­mui. Kuna pun­cha chaia­wa­kumi, kamba wasi­ma chaiag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Chi­ura­lla Zakeo, urai­kuspa, Jesus­ta pusarka. Alli iuia­chii­wa pai­pag­ma iaiku­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tukui chasa kawag­kuna, pai­pura mana alli­lla iuiai­wa ni­na­kurka: —Panda­rig­pag­ma­mi Jesús iai­kug­rirka, pai­wa sug­lla­pi kag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakeoka, saia­rispa, Iaia Jesus­ta nirka: —Taita waugki, tukui ima nuka iukas­kata mana iukas­ka­kunata chaug­pi­mi karan­ga­pa kani. Mai­kanta llulla­chispa, kulki mañas­ka­kuna­ta­pas chusku biaji iapa­wa­mi kuti­chin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chi­ura, Jesuska nirka: —Kuna puncha­mi kai wasi­manda runa­kuna kispi­rig­samur­ka­kuna. Kai runapas, ñugpa­manda taita Abra­hampa iawar­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kai Runa Tukuska samur­kami, mai­kan chingaska­sinata maskaspa, tarispa, kispi­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús ña Jeru­salenma kailla­ia­kug­manda, chasa nis­kata uiag­kuna iuia­na­kurka: “Dius­pa suma man­dai, ñachar chaia­mu­ku”. Chi­manda, pai­kunata iuiai apinga­sina suma parlarka, ");
INSERT INTO inb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","kasa nispa: —Sug runa, mandagpa wam­bra­si tiarka. Chi runaka, sug karu alpama rirka, atun mandag tukuspa kuti­mun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Llugsi­kus­paka, chunga lutrin­kunata kaiaspa, sug sug kuri kulki min­garka, kasa nispa: “Kai­wa ran­dispa i katuspa, mira­chi­puan­gi­chi, ima­ura nuka chaia­mun­kama”. ");
INSERT INTO inb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pai rig­lla­pi, chi alpa­manda runa­kuna, paita mana munaspa, kachar­ka­kuna, ñugpa willan­ga­pa: “Chi runata mana munan­chi­chu, nukan­chipa atun mandag kan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Atun mandag tukuspa kuti­mus­paka, chi runaka ka­char­ka, tukui kulki mingas­ka­kuna­ta kaiaspa, tapun­ga­pa: masa kulki­mi mira­chiska tia­pun­kunata. ");
INSERT INTO inb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chi­ura sug runaka, chaia­muspa, nirka: “Taita waugki, kamta chas­kis­ka­wa ña chunga biaji masmi mira­chi­puiki”. ");
INSERT INTO inb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Chi­ura, chi atun mandagka ainirka: “Kam, iapa alli­mi kangi. Alli­lla­mi rurarkangi. Chasa mailla­lla­wa mira­chig­manda, chunga pui­blu­ta­mi mandag kankangi”. ");
INSERT INTO inb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Chasa­lla­ta sug runaka, chaia­muspa, nirka: “Taita waugki, kamta chaskis­ka­wa ña pichka biaji masmi mira­chi­puiki”. ");
INSERT INTO inb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Chi­ura nirkasi: “Kamka, pichka pui­blu­ta­mi mandag kan­kangi”. ");
INSERT INTO inb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Ikuti sugka, chaia­muspa, nirka­si: “Taita waugki, kamba kulki kai­pi­mi tia­pungi. Nuka, kamta man­chai­wa kaspa, sug piti linsupi maituspa waka­chi­purkaikimi. ");
INSERT INTO inb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kamka, sin­chi sungumi iukangi. Kam mana waka­chiska iukas­ka­ta­mi tanda­chi­dur kangi. Chasa­lla­ta, maipi mana tarpus­kapi palla­durmi kangi”. ");
INSERT INTO inb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—Chasa uias­paka, chi atun mandagka nirka: “Kam kikinpa rimai­wa­mi iacha­ri­warka, kam mana alli kagta. Kam, alli­lla­mi iacharkangi, nuka sin­chi sungu iukagta; nuka mana waka­chiska iukas­kata tanda­chi­dur kagta; chasa­lla­ta, maipi mana tarpus­kapi palla­dur kagta. ");
INSERT INTO inb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Chasa iachas­paka, ¿imapatak nuka­pa kulki miran­ga­pa, mana bankupi minga­puarkangi; chasaka, nuka kuti­mu­ura, iapa­wa kua­wan­ga­pa?”. ");
INSERT INTO inb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Chasa rimas­paka, chipi kag­kunata nirka: “Kai lutrinta kulki kichuspa, chi chunga iukagta kuai­chi”. ");
INSERT INTO inb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Chi­ura nir­ka­kuna: “Taita waugki, paika ñami chunga iuká”. ");
INSERT INTO inb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Chasa ni­ura, chi atun mandagka nirkasi: “Kasa­mi nii­ki­chita: mai­kan iapa achka iukagta mas­mi karan­ga­pa ka. Ikuti mai­kan mailla iukas­kataka tukuimi kichun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kasapas. Mai­kan nuka atun mandag tukun­ga­pa mana muna­was­ka­kunataka pusag­rispa, nuka­pa ñawipi wañu­chii­chi”. ");
INSERT INTO inb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús rimai puchukas­paka, paita kati­raiag­kunata Jeru­salenma ñambi ñugparka. ");
INSERT INTO inb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfajé i Beta­nia suti pui­blu­kuna ña kawa­ri­kus­ka­manda, Olivos suti luma­kama chaiag­rirka. Chi­manda, iskai kati­raiag­kunata kacharka, ");
INSERT INTO inb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kasa nispa: —Rii­chi chi ñugpa ladu uchulla pui­bluma. Chaiag­ris­paka, tarig­rinkan­gi­chimi sug buru wata­ra­ias­kata, manara pipas tia­riska. Chi buruta paskaspa, apa­mun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mai­kan tapuchu: “¿Imapatak buruta paska­na­kun­gi­chi?”: chi­ura ainin­gi­chi: “Iaia Jesus­ta­mi minis­ti­ku”. ");
INSERT INTO inb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Chi kachai tukus­ka­kuna chaiag­ri­uraka, tukui imasa Jesús niska­sina alli­lla tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Buruta paska­na­ku­uraka, duiñu­kuna tapur­ka­kuna: —¿Imapatak buruta paska­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chi­ura ainir­ka­kuna: —Iaia Jesustami minis­ti­ku. ");
INSERT INTO inb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Apan­ga­pa saki­uraka, buruta Jesus­pagma apar­ka­kuna. Chaia­chig­ris­paka, buru wasapi pai­kunapa katan­ga­kunata churaspa, Jesusta tia­ri­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús ñambi ri­kus­kapika, pai­kuna kata­raiaska katan­ga­kunata ñambi suiu manda­chir­ka­kuna, pai ialin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ña Jeru­salenma chaia­na­kug­ri­ura, Olivos luma­manda urai­ku­nakus­kapika, iapa achka runa­kuna Jesusta kati­raiag­kunaka, iapa alli iuia­chi­rispa, kalla­rir­ka­kuna, Taita Diusta kapa­rispa nin­ga­pa: “Kam, iapa suma atun­mi kangi”. Tukui ima mana ima­ura­pas kawaska­sina pai ruras­ka­kunata kawas­kata iuia­rispa­mi chasa kapa­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kasa­pas­mi kapa­rispa ni­na­kurka: —Atun Taita Dius kacha­muska atun mandagmi samu­kungi. Paipa iapa kuiaska­mi kangi. Sug luarpi, sumag­lla kachu. Taita Dius awa suma luarpi kag­ta­mi nin­chi: “Kam, iapa suma­mi kangi”. ");
INSERT INTO inb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chipi kag­pura sug fari­seo­kuna, Jesusta nir­ka­kuna: —Iacha­chig taita, kamta kati­raiag­kunata piñai. ");
INSERT INTO inb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesuska ainir­ka­kunata: —Kasami nii­ki­chita: pai­kuna upallag­pika, rumi­kuna­mi chasa­lla­ta kapa­rin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jeru­salenma ña kailla ri­kus­paka, chi pui­bluta kawaspa, pai­manda wakarka. ");
INSERT INTO inb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Waka­kus­paka, nirka: —Kuna­ura kam­kuna, kai pun­cha­kuna imasa karas­kata iachan­tran­gi­chi, sumag­lla kaug­san­ga­pa. Nig­pika, pakaska­sina­mi ka, kam­kuna mana iachai pudin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sug puncha­kuna chaia­munga­pa­mi ka; kam­kunata wañu­chin­ga­pa samug­kunaka, tukui­nig­manda kinchaspa, sug awa pata ruraspa­mi muiu­chin­ga­pa kan­kuna, ñi pipas mana ialinga­sina. ");
INSERT INTO inb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nis­paka, kai pui­bluta lim urma­chispa, tukui ukupi kaug­sa­na­kus­ka­ta­mi wañu­chin­ga­pa kan­kuna. Tukui pia­chiska rumi­kuna­pas, ñi sug mana sakin­ga­pa kan­kuna­chu. Taita Dius kacha­muska kam­kuna­pagma chaia­mu­ura, mana rigsig­manda­mi chasa iapa llakii pasan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Dius­pa atun wasi ukuma iaikug­ris­paka, tukui chipi katug­kunata llugsi­chii kalla­rirka, ");
INSERT INTO inb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kasa nispa: —Ñugpa­manda librupi, kasa­mi willa­raiá: “Nuka­pa wasi, Taita Diusta iuia­rispa maña­diru­mi kan­ga­pa ka”. “Kam­kunaka, sisai kaug­sa­diru­sina­mi rurarkan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chi­ura­manda tukui puncha­kuna, Dius­pa atun wasi uku­pi­mi iacha­chi­kurka. Iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas, paita iuia­ri­na­kurka imasa­pipas wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pai ima iacha­chi­kus­kata, tukui runa­kuna suma alli­lla uiaspa kag­manda­mi pai­kunata mana iacha­rir­ka­kunata imasa wañu­chinga. ");
INSERT INTO inb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sug punchaka Jesús, Dius­pa atun wasi ukupi kag­kunata iacha­chi­kuspa, Alli Willai­ta willa­kurka. Chi­ura iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas, pai­pagma chaiag­rispa, ");
INSERT INTO inb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tapur­ka­kuna: —Nukan­chita willai: ¿imapatak chasa ruraspa puri­kungi? ¿Pitak kam­ta kacha­murka, atun tukuspa puri­kun­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesuska ainir­ka­kunata: —Nuka­pas, kam­kunata tapu­sa­ki­chita. Willa­wai­chi: ");
INSERT INTO inb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿pitak Juanta kacharka, baug­ti­san­ga­pa? ¿Taita Diuschu kacha­murka? Mana kag­pika, ¿runa­kuna­chu kacharka? ");
INSERT INTO inb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Chi­uraka, kikin­pura rima­ri­na­kurka, kasa iuia­rispa: —“Taita Dius kacha­muska­mi karka” nig­pika, paika ainingami: “Nig­pika, ¿imapatak mana paita uiarkan­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Runa­kunalla kacha­muska­mi karka” mana ni­sun­chi. Tukui­kuna­mi Juan­manda iuia­nakú: “Santu Ispi­ri­tu­wa rimag­mi karka”. ¡Amalai nukan­chita rumi­wa piaspa wañu­chin­tra­kuna! ");
INSERT INTO inb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chasa rima­na­kuspa, Jesusta ai­nir­ka­kuna: —Mana iachan­chi­chu, Juanta pi kacha­muska kagta. ");
INSERT INTO inb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Chasa aini­ura, Jesuska nir­ka­kunata: —Chi­manda­mi nuka­pas mana willai­ki­chita, pi kacha­mu­waska kagta, atun tukuspa kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Chasa nis­paka, chipi kag­kunata iuiai apinga­sina suma parlarka, kasa nispa: —Sug runa, achka ubas sacha malki­kunasi paipa alpapi tarpurka. Nis­paka, sug runa­kunata chi ubas sacha­kunata sakirka, almaspa, chaugpi chaugpi pallan­ga­pa. Chasa sakis­paka, iapa unai karu alpama rirka. ");
INSERT INTO inb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ña pallan­ga­pa chaia­uraka, sug lutrinta chi almag­kuna­pagma kacharka, paipa rasiunta chaskin­ga­pa. Chi runa­kunaka, kachai tukus­kata makaspa, chusa maki kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","—Chi­ura­manda, ikuti sug lutrin­ta­si kacharka. Chi­ta­pas makaspa, kamispa, chasa­lla­ta chusa maki kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ña kimsa­maka, ikuti sug lutrin­ta­passi kacharka. Chi­taka lisia­chispa, kancha­masi llugsi­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—Nigpi, chi duiñuka iuia­rirkasi: “¿Imatak rurasa? Nuka­pa iapa kuiaska wam­bra­ta­mi kachasa. Nuka­pa wam­bra kag­manda, mana ima­pas rura­puan­ga­kuna­chu”. ");
INSERT INTO inb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Nig­pika chi almag­kunaka, chi wam­brata kawaspa, kikin­pura rima­rir­ka­kuna, kasa nispa: “Kai alpa duiñupa wam­brami samu­ku. Pai­taka wañu­chi­sun­chi. Chasaka, nukan­chipa­lla­mi kai alpa tukunga”. ");
INSERT INTO inb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chasa nis­paka, paita chi alpa­manda llugsi­chispa, wañu­chir­ka­kuna. Chasa parlas­paka, Jesús tapurka: —Nigpi chi alpa duiñuka, ");
INSERT INTO inb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿mana­chu samuspa, chi runa­kuna­ta tukuita wañu­chig­samun­tra; nis­paka, chi sacha­kunata ikuti sug­kuna­ta alman­ga­pa sakin­tra? Chasa uiag­kuna ainir­ka­kuna: —Chasa mana pasa­richu. ");
INSERT INTO inb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Chasa ni­ura Jesuska, ñawima kawaspa, nir­ka­kunata: —Nigpi, ñugpa­manda librupi kasa willa­raiaska, ¿imatak ni­raiá? Wasi­chig­kuna wabutiska rumi, wasita cha­rigmi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mai­kan chi rumipi urmag­kuna, piti pitimi tukun­ga­kuna. Chasa­lla­ta, chi rumi awalla urmag­pika, ñutu­mi tukun­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Chi parluta uias­paka, Moisés ima nis­kata iacha­chig taita­kuna i iaia sasir­duti­kuna­pas nir­ka­kuna: —Nukan­chitami uia­chi­ku—. Chi­manda, chi­ura­lla Jesusta api­chin­ga­pa muna­na­kurka. Chasa muna­na­kuspa­pas, achka runa­kuna chipi kag­manda, manchai apir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nis­paka, suma rimag­kuna­sina kawa­ri kas­ka­kunata kachar­ka­kuna, Jesusta chapan­ga­pa. Chi runa­kuna rir­ka­kuna, pai rima­kus­kata uiaspa, ima­pipas panda­rig­pika, paita api­chin­ga­pa; apis­paka, tukui­kunata mandag­pagma chaia­chispa, paita jus­ti­sian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kachai tukus­ka­kunaka, cha­iag­rispa, Jesusta sumag­lla nir­ka­kuna: —Iacha­chig taita, nukan­chi iachan­chimi, kam mana llullaspa­lla rimagta. Mana pi­ta­pas kawaspa­lla­mi tukui­kunata iwallla sutipa kas­kata iacha­chingi, imasa Taita Dius munaska­sina ruraspa kaug­san­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chi­manda­mi kasa tapug­samun­chi: ¿alli­lla­chu ka, Roma­manda iaia mandagta nukan­chi impuistu kuan­ga­pa? ¿Paga­sun­chi­chu u mana? ");
INSERT INTO inb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesuska iacharka, mana alli­lla iuiai­wa chasa tapu­na­kugta. Nis­paka nir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Impuistu kulki kua­diruta kawa­chi­wai­chi—. Kawa­chi­uraka, tapurka— ¿Pipa ñawitak kawa­ri­ku? ¿Pi­manda­tak willaska ni­raiá? Chi­ura ainir­ka­kuna: —Roma­manda iaia mandag­manda. ");
INSERT INTO inb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Chasa aini­ura, Jesuska nir­ka­kunata: —Chasa kag­pika, Roma­manda iaia mandagpa kas­kata paita kuai­chi. Taita Dius­pa kas­kataka Taita Diusta kuai­chi. ");
INSERT INTO inb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chasa, tukui­kunapa ñawipi, Jesús ai­nig­manda mana api­chin­ga­pa pudir­ka­kuna. Chi ainis­kata uias­paka, iapa ujna­rispa­mi upalla kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chi­ura­manda sug sadu­seo suti runa­kuna, Jesus­pagma chaiag­rir­ka­kuna. Chi runa­kuna iacha­chi­dur­mi kan­kuna, wañus­ka­kuna mana mas kaugsa­rin­ga­pa kagta. Chaiag­ris­paka, Jesusta nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Iacha­chig taita, Moiseska nukan­chi­manda kasasi willaspa sakirka. Sug kari kasaraspa, warmi manara wam­bra­kuna iukag­lla­pi wañug­pika, sug waugkindisi iuká chi biuda­wa kasaranga; chasaka, wañug waugkindipa kuinta wawa­kuna iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Nig­pika, kan­chis waug­kin­di­kunasi tiarka. Atun waug­kin­dika, kasaraspa, warmi manara wawa­kuna iukag­lla­pisi wañurka. ");
INSERT INTO inb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chi­wanka, kipa­manda waug­kin­disi chi sapalla kidaska warmi­wa kasarai iukarka. Chi waug­kin­di­pas, warmi manara wawa­kuna iukag­lla­pisi wañurka. ");
INSERT INTO inb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kati­manda waug­kin­di­ta­pas chasa­lla­ta pasa­rirka. Chasa­lla­tasi tukui kan­chis waug­kin­di­kuna, warmi manara wawa­kuna iukag­lla­pi wañur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kati­ma­kar, chi warmi­pas wañurka. ");
INSERT INTO inb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nig­pika, wañus­ka­kuna kaugsa­ri­uraka, ¿pipatak chi warmi kanga, chi kan­chis waug­kin­di­kuna­wa kasadu kaspa? ");
INSERT INTO inb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesuska ainir­ka­kunata: —Kuna­ura kaug­sag­kuna, kari­kuna i warmi­kuna kasara­na­kumi. ");
INSERT INTO inb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Chasa kagpi­pas, mai­kan wañuska Dius­pa ñawipi alli­lla kaspa, kaugsa­rispa, suma luarma chaiag­rispa kag­kunaka, kari ñi warmi mana kasa­ran­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pai­kuna, mana mas wañun­ga­pa kan­kuna­chu. Anjil­kuna­sina kaspa, Dius­pa wam­bra­kuna­mi tukuska kan­ga­pa kan­kuna, pai­kunata kaug­sa­chii ruras­ka­manda. ");
INSERT INTO inb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Kasapas. ¿Imapatak kam­kuna nin­gi­chi: “Wañus­ka­kuna mana mas kaugsa­rin­ga­pa kan­kuna­chu”? Moisespas, sacha rupa­kus­ka­manda rimaspa, chasa­lla­ta­mi iacha­chirka, kasa nispa: “Atun Taita Dius, Abra­hampa, Isaak­pa i Jakobpa Dius­mi ka”. ");
INSERT INTO inb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chi­wanka, Taita Dius mana kan­chu wañus­ka­kunapa. Kaug­sag­kuna­pa­mi Taita Dius ka. Paipa ñawi­pika, tukui­kuna­mi kaug­sa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Chi­ura Moisés ima nis­kata sug iacha­chig taita­kunaka, Jesusta nir­ka­kuna: —Iacha­chig taita, iapa alli­lla­mi rimarkangi. ");
INSERT INTO inb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Chi­ura­manda, Jesusta man­cha­rispa, ñi mai­kan mana mas paita tapun­ga­pa munar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Chi­ura, Jesuska nir­ka­kunata: —Taita Dius agllaska Cristo­manda, ¿imapatak nin­kuna, David­pa wam­brapa kati wam­bra kagta? ");
INSERT INTO inb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","¿Mana­chu David kikin, Sal­mos suti librupi, Cristo­manda kasa willarka? Atun Taita Dius­mi nuka­pa iaiata nirka: “Nuka­pa alli ladu tia­rii, ");
INSERT INTO inb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nuka tukui kamta mana munag­kunata apag­rispa, kamba chaki saru­diru uku­ma churan­kama”. ");
INSERT INTO inb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chasami David kikin, Cristo­manda nirka: “Nuka­pa iaia”. Nig­pika, ¿ima­wan­tak Cristo, paipa wam­brapa kati wam­bra kanga? ");
INSERT INTO inb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chasa nis­paka, tukui chipi kag­kuna uia­na­kun­kama, paita kati­raiag­kunataka nirka: ");
INSERT INTO inb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moisés ima nis­kata iacha­chig taita­kuna­wa mana iapa sug­lla­pi iuiai­wa kan­gi­chi. Pai­kuna munan­kunami, iapa suma kawa­ri katan­ga­kuna chura­rispa purin­ga­pa. Kallipi pai­kuna­wa tupa­na­kus­kapi munan­kunami, iapa suma kuiai­wa kumu­rispa, “Puangi, taita waugki” nin­ga­pa­kunata. Tanda­ri­diru wasi­kuna­pipas munan­kunami, atun taita­kuna tia­ri­diru ñugpa ladu tia­rin­ga­pa. Chasa­lla­ta, maima kun­bi­dagpi suma mikun­ga­pa kaia­ura, ñugpa ladu tia­ringa­pa­mi munan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Warmi sapalla kidas­ka­kunata wasi­kuna­ta­mi kichu­dur kan­kuna. Nis­paka, kawa­chi­ringa­pag­lla­mi unai Taita Diusta rima­na­ku­dur kan­kuna. Chasa ruras­ka­kuna­manda­mi sug luarpi sug­kuna­manda­pas mas llakiipi jus­ti­siai tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chi­ura­manda Jesús, iapa iukag­kuna imasa kulki chu­ra­diru­kunapi chura­na­kus­kata kawa­kurka. ");
INSERT INTO inb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chipi chaiag­rispa, sug warmi mana iukag sapalla kidas­kaka, iskai uchulla kulki­lla­mi churarka. ");
INSERT INTO inb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chasa kawas­paka, Jesuska nirka: —Nukami kasa nii­ki­chita: chi warmi mana iukag sapalla kidaska, tukui­kuna­manda mas achka churagmi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sug­kunaka, pai­kunapa puchus­ka­ta­mi churar­ka­kuna. Ikuti chi warmika, mana iukaspa­pas, pai mikun­ga­pa cha­ri­kus­ka­ta­mi tukuita kararka. ");
INSERT INTO inb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sug runa­kuna, Dius­pa atun wasi­manda rimaspa, ni­na­kurka: —Iapa atun kantiaska rumi­kuna­wa i Taita Diusta karas­ka­kuna­wa saia­chiska, ña iapa suma­mi kawa­ri­ku. Chasa uiaspa, Jesuska nirka: ");
INSERT INTO inb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Tukui ima kam­kuna kawa­na­kuska puchuka­rin­ga­pa puncha­kuna­mi chaia­mun­ga­pa ka. Chi tukui pia­chiska rumi­kuna, ñi sug mana sakin­ga­pa kan­kuna­chu. Tukui­ta­mi urma­chispa puchukan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chi­ura, paita tapur­ka­kuna: —Iacha­chig taita, ¿ima­uratak chasa pasa­ringa? Ña chasa pasa­rin­ga­pa kagta, ¿ima­watak kawa­chinga? ");
INSERT INTO inb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chi­ura, Jesuska ainirka: —¡Ujala­lla­pas mai­kan, kam­kunata llulla­chispa panda­chi­chu­kuna! Achka­kuna­mi, nuka­sina tukuspa, samun­ga­pa kan­kuna, kasa nispa: “Nukami Taita Dius agllaska Cristo kani”. Kasa­pas­mi nin­ga­kuna: “Ñami chi puncha chaia­mu­ku”. Chasa nigpi­kuna­pas, mana pai­kunata katin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tukui­ma­mi mana llakispa­lla wañu­chi­na­kugta, ñi pita mana uiaspa­lla piña­chi­ri­na­kugta iacha­rin­ga­pa ka; kam­kuna mana mancha­ri­na­kun­gi­chi. Chasa­mi ñugpa pasa­rin­ga­pa ka. Nigpi­pas, kai alpa puchuka­rii puncha manara chaia­muska ni­raian­chu. ");
INSERT INTO inb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Chasa nis­paka, kasa­pas­mi nir­ka­kunata: —Sug mandag alpa­nig­manda­kuna­wa sug­nig­manda­kuna­wa wañu­chi­na­kuimi tian­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Alpa kuiu­rispa chapu­rispa­mi rin­ga­pa ka. Sug­nig­manda sug­nig­manda iapa iarkai i purig ungui­kuna­pas­mi tian­ga­pa ka. Awa­pipas iapa manchanga­sina mana ima­ura­pas kawaska­sina­mi kawa­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Tukui chi­kuna manara pasa­rig­pi­mi, kam­kunata apispa, mana alli­lla ruran­ga­pa kan­kuna. Tanda­ri­diru wasi­kunama kam­kunata chaia­chispa, karsil­pi­mi wichkan­ga­pa kan­kuna. Kam­kuna nuka­wa kag­manda, atun mandag­kuna­pag­ma­mi puri­chin­ga­pa kan­kuna, jus­ti­siai rurai tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chi­ura, pai­kunata nuka­manda­mi willankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mana iuia­na­kun­gi­chi imasa ainingata. ");
INSERT INTO inb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nuka­mi suma iachai­wa kam­kunata iuia­chisa­ki­chita imasa ai­nin­gata. Chi kam­kuna iachas­kata, ñi mai­kan kam­kunata piñag­kuna mana pudin­ga­kuna­chu ima­pas ai­nin­ga­pa. Upa­lla­mi kan­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Chi puncha­kuna, kam­kuna­pa atun­kuna, waugkindi­kuna, kam­pura­kuna i iacha­ridu­pura­pas­mi kam­kunata api­chin­ga­kuna, jus­ti­siai tukun­ga­pa. Kam­kunata, achka­kuna­ta­mi wañu­chin­ga­pa api­chin­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tukui­kuna­mi kam­kuna­wa rabia­rin­ga­kuna, kam­kuna nuka­wa kag­manda. ");
INSERT INTO inb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Chasa rabia­rigpi­kuna­pas, kam­kunapa uma­manda ñi sug agcha mana chinga­chig­sina­mi kankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nuka­manda iuiai­lla­wa apa­na­kun­gi­chi. Chasaka, kam­kunapa almata kispi­chinkan­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Jeru­salén pui­bluta achka suldadu­kuna muiu­chi­na­kugta kawas­paka, iuia­na­kun­gi­chi, chi pui­blu ña puchuka­rin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Chasa kawas­paka, Judea alpapi kaug­sa­na­kug, sachukuma miti­ku­chu­kuna. Jeru­salenpi kag­kuna, chi­manda miti­kuspa, llugsi­chu­kuna. Chagrapi kag­kuna­pas, mana Jeru­salenma samu­chu­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi puncha­kuna, iapa llakiimi tukun­ga­pa ka. Tukui imasa ñugpa­manda librupi ni­raiaska­sina­mi pasa­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—¡Ai, mai­kan warmijim­kuna, chi puncha­kuna wigsa­wa ungug u uchulla markaska kag­kuna! Kai alpapi iapa achka llakii­kuna­mi tian­ga­pa ka. Kai Israel­manda runa­kuna­wa, Taita Dius­pa rabiami chaia­mun­ga­pa ka, tukui llakii­kuna tian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Chi­ura, sug­kunata ispada­wa­mi wañu­chin­ga­pa kan­kunata. Sug­kunataka wataspa, sug alpa­kuna­ma­mi apan­ga­pa kan­kunata. Jeru­salentaka, mana Israel­manda runa­kuna­mi mandan­ga­pa kan­kuna, ima­ura Taita Dius pai­kuna chipi kan­ga­pa ni­raiaska puncha chaian­kama. ");
INSERT INTO inb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Indi, killa, istrilla­kuna­pas, mana ima­ura­pas kawaska­sina­mi kawa­rin­ga­pa ka. Kai alpa­pipas lamar iaku­kuna iapa sin­chi uia­ri­uraka, tukui kaug­sag­kuna, iapa mancha­rispa, tuntiadu­sina mana iacha­rin­ga­pa ka ima ruranga. ");
INSERT INTO inb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kai alpapi imasa pasa­ri­kugta iuia­rispa, dimanchaimi wañuska­sina builta­na­kun­ga­pa ka. Kai alpa­manda awa ladu tias­ka­kuna­pas­mi kuiu­chii tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","—Chi­ura, kai Runa Tukus­ka­ta­mi kawa­wan­ga­pa kan­kuna. Nuka­pa tukui iapa suma iachai­wa puiu­pi­mi samun­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","—Chasa pasa­rii kalla­ri­uraka, kuntintulla alli iuia­chii­wa kan­gi­chi. Kam­kunata kispi­chii puncha ñami chaia­munga. ");
INSERT INTO inb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chasa nis­paka, pai­kunata iuiai apinga­sina suma parlarka, kasa nispa: —Igus u mai­kan sachata kawas­pa, iachai­kui­chi. ");
INSERT INTO inb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pan­ga­kuna ña susu­ri­ura, kam­kuna kawas­pa, nin­gi­chimi: “Ñami alli puncha­kuna chaia­mu­ku”. ");
INSERT INTO inb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chasa­lla­ta kam­kuna, tukui chasa pasa­ri­na­kus­kata kawas­paka, ñami iachan­kan­gi­chi, Dius­pa suma mandai puncha ña chaia­mu­kugta. ");
INSERT INTO inb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Kasami nuka nii­ki­chita: manara tukui kuna­ura kaug­sag­kuna wañug­pi­mi tukui chasa pasa­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sug luar i kai alpa luar puchuka­rigpi­pas, nuka ima nis­kaka mana ialin­ga­pa kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Sumag­lla iuia­na­kun­gi­chi. ¡Ujala­lla­pas jiru iuiai­kuna­lla­wa, machai­wa i kai alpa­manda ima­kuna­pas munai­lla­wa kan­tran­gi­chi! Chasa kaug­sa­na­kug­pika, chi pun­cha chaia­mungami, kam­kuna mana iuia­na­ku­ura. ");
INSERT INTO inb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Imasa­mi tuglla urmá: chasa­lla­ta­mi chi puncha, kai alpapi tukui kaug­sa­na­kug­pagma chaia­mun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chi­manda, ima­ura­pas iuiaipilla kan­gi­chi. Taita Diusta iuia­rispa maña­na­kun­gi­chi, tukui chasa pasa­rin­ga­pa puncha­kuna chaia­mu­ura, kam­kuna kispi­riska kan­ga­pa; chasa­lla­ta, kai Runa Tukuskapa ñugpa ladu mana manchaspa­lla saia­rig­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús, chi puncha­kuna Dius­pa atun wasi ukupi chisiagta iacha­chi­kurka. Tuta­kunaka, Olivos suti lumapi paka­ri­kug­rirka. ");
INSERT INTO inb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tutata­kunaka, achka runa­kuna Dius­pa atun wasima chaia­na­kug­rirka, paita uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tanda mana liba­dura­wa miku­diru paskua suti atun puncha ña chaia­ku­ura, ");
INSERT INTO inb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","iaia sa­sir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kunaka, Jeru­salenpi achka runa­kuna kas­kata mancha­na­kuspa, pai­pura rima­ri­na­kurka, imasa Jesusta pakalla wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chi­ura, chunga iskai Jesús agllas­ka­kuna­manda Judas Iska­riote suti runapa sungu­pi­mi iaia kuku iaikurka. ");
INSERT INTO inb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Chi runaka, iaia sasir­duti­kuna i Dius­pa atun wasita kawag­kuna­pagma rispa, rima­na­kurka imasa Jesusta api­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pai­kuna, chasa uias­paka, sumag­lla kun­tin­ta­rispa, nir­ka­kuna: —Kulkimi kamta kara­sun­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Chi­ura­manda Judas, “Ari” nispa, maskai kalla­rirka imasa Jesusta api­chin­ga­pa, mana achka runa­kuna kawa­na­ku­ura. ");
INSERT INTO inb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tanda mana liba­dura­wa miku­diru atun puncha chaiarka; chi­ura­lla­tata paskua ubija wañu­chispa mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nigpi Jesuska, Pedro i Juanta kacharka, kasa nispa: —Alli­chig­rii­chi, paskua pun­cha­pa mikui nukan­chi mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chi­ura tapur­ka­kuna: —¿Maipitak munangi, nukan­chi alli­chig­rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chi­ura, Jesuska ainirka: —Kam­kuna pui­blupi chaiag­ri­uraka, sug runa iaku wab­ka­na­wa­mi tupanga. Paita kati­chin­gi­chi, sug wasima iaikun­kama. ");
INSERT INTO inb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chi wasi­iugta nig­rin­gi­chi: “Nukan­chita iacha­chig taita­mi kachamú, kamta tapun­ga­pa: ‘¿Mai­kan uku ladutak nuka­pa kati­raiag­kuna­wa paskua mikun­ga­pa kani?’.” ");
INSERT INTO inb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chi­ura chi runaka, awapi sug atun uku tukui ima minis­tis­ka­kuna­wa tim alli­chis­ka­ta­mi kawa­chin­ga­pa ka. Nukan­chi mikun­ga­pa, chipi alli­chin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chi kachai tukus­ka­kuna chaiag­ri­uraka, tukui imasa Jesús niska­sina alli­lla tukug­samurka. Chi­pi­mi alli­chir­ka­kuna, paskua mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ña mikui kalla­rin­ga­pa chaia­uraka, Jesús, pai agllaska runa­kuna­wan­ta tia­rig­rirka. Tukui mikuspa tia­na­ku­ura, ");
INSERT INTO inb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesuska nir­ka­kunata: —Iapami muna­kurkani, kam­kuna­wa kai paskua mikun­ga­pa, nuka manara wañu­chii tukugpi. ");
INSERT INTO inb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kasa­mi nii­ki­chita: kai mikui mana mas mikun­ga­pa ka­nichu, ima­ura Dius­pa suma mandai puncha chaian­kama. ");
INSERT INTO inb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Chasa nis­paka, sug binu kupata makipi chari­rispa, “Pai Siñur” Taita Diusta nispa, pai­kunata nirka: —Chari­rii­chi. Rasiuna­rispa, upiai­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kasa­mi nii­ki­chita: kuna­ura­manda, ubas iaku mana mas upian­ga­pa ka­nichu, ima­ura Dius­pa suma mandai puncha chaian­kama. ");
INSERT INTO inb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nis­paka, tandata makipi chari­rispa, “Pai Siñur” Taita Dius­ta nirka. Tandata piti­chispa, pai­kunata kuaspa, kasa­mi nirka: —Kai, nuka­pa kuir­pu­mi ka, kam­kuna­manda karaska kan­ga­pa. Nuka­manda iuia­rispa, chasa­lla­ta tandata piti­chispa ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ña mikuska­ura­mandaka, sug binu kupata chasa­lla­ta chari­rispa, kasa­mi nirka: —Kai binu kupa, nuka­pa iawar­mi ka, Taita Dius­wa i runa­kuna­wa ikuti pasin­sia­chi­rispa sumag­lla tukun­ga­pa. Kam­kuna­manda­mi chi iawar llugsispa icha­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Uiamui­chi. Sug nuka­wa sug­lla­pi kai misapi tia­kugmi api­chi­wan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Imasa­mi ñugpa­manda­ta willa­raiá: chasa­lla­ta­mi kai Runa Tukus­kata pasa­ri­wan­ga­pa ka. Chasa kagpi­pas, ¡ai, chi runa api­chi­wag! ");
INSERT INTO inb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Chi­ura Jesuspa agllaska runa­kuna, kikin­pura tapu­ri­na­kurka: —¿Mai­kan­sik nukan­chi­pura Jesusta api­chin­ga­pa ka? ");
INSERT INTO inb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nis­paka, kikin­pura sin­chi rima­ri­na­kurka, kasa iuia­rispa: “Nukan­chi­mandaka, ¿pi­sik mas atun taita­sina tukuska ni­ra­ian­chi?”. ");
INSERT INTO inb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesuska nir­ka­kunata: —Kai alpapi atun mandag­kuna, manda­nakus­kapi kaug­sag­kunata ñi ima mana llakispa­lla­mi mandan­kuna. Chi mandag­kuna­pas suti­chi­rin­kunami: “Alli­lla rurag­kuna”. ");
INSERT INTO inb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kam kikin­puraka, chasa rurag runaka mana kan­gi­chi. Kam­kuna­manda mas atuniaska kag, mas uchulla­sina tuku­chu. Chasa­lla­ta, kam­kunata mas atun taita kag, sug­kunapa lutrin­sina tuku­chu. ");
INSERT INTO inb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Mai­kantak mas atun taita ka: mikun­ga­pa tia­kug u paita mikui iali­chig? Mikun­ga­pa tia­kug­mi ka. Chasa kagpi­pas, nuka­mi kam­kunata mikui iali­chig­sina kani. ");
INSERT INTO inb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Kam­kuna, nuka­wa­mi kar­kan­gi­chi, nuka ima llakii­kuna iukag­pi­pas. ");
INSERT INTO inb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chi­manda­mi kam­kunata tia­rispa mandan­ga­pa kuai­ki­chita; imasa­mi nuka­pa Taita mandan­ga­pa kua­warka: chasa. ");
INSERT INTO inb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nis­paka, maipi nuka manda­kus­kapi, kam­kuna­pas nuka­wa­mi mikun­kan­gi­chi i upian­kan­gi­chi. Manda­diru­kuna­pi­mi tia­rin­kan­gi­chi; chasaka, ñugpa­manda achala taita Israelpa chunga iskai wam­bra­kunapa wam­bra­kunata kawaspa, jus­ti­sian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kasapasmi nirka: —Simón, Simón, uiamui. Iaia kuku­ka maska­kumi, trigalta chabsi­chig­sina, kam­kunata waglli­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nukaka, kam­manda Taita Diusta mañarka­nimi, kam mana nuka­manda suma iuiaita sakin­ga­pa. Kam, Taita Dius­wa ikuti tigras­paka, kai waugkindi­kunata alli­lla iuia­chispa kangi. ");
INSERT INTO inb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Chi­ura, Simón ainirka: —Taita waugki, kamta karsilpi wichkaspa, wañu­chin­ga­pa apagpi­kunapas, nuka kam­wa­mi rin­trani. ");
INSERT INTO inb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Chasa ni­ura, Jesuska Pedrota nirka: —Kasami niiki: kai tuta, gallu manara kantag­pi­mi kamka kimsa biaji nuka­manda nin­ga­pa kangi: “Paita mana rigsi­nichu”. ");
INSERT INTO inb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chasa nis­paka, pai­kunata tapurka: —Nuka kam­kunata kachar­kai­ki­chita mana jigra­wa, ñi kulki waka­chi­diruwa ñi ima chakipi chura­ri­diruwa; chi­ura, ¿imatak pisi karkan­gi­chi? Pai­kuna ainir­ka­kuna: —Ñi ima­pas manima. ");
INSERT INTO inb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Chi­ura, Jesuska nirka: —Kuna­uraka, mai­kan­pas jigra u kulki waka­chi­diru iukag, apai­chi. Mai­kan mana ispada iukag­pika, kikinpa katangata katuspa, sug ispada randichu. ");
INSERT INTO inb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kasa­mi nii­ki­chita: ñugpa­manda librupi imasa ni­raiaska­sina­mi nukata pasa­ri­wan­ga­pa ka. Chipika, kasa­mi willa­raiá: “Paipas, jiru rurag­kuna­wa sug­lla­pi­mi kawa­rirka”. Tukui imasa nuka­manda willa­raiaska­sina­mi tukug­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chi­ura nir­ka­kuna: —Taita waugki, iskai ispada­kuna kai­pi­mi tia. Chi­ura, Jesuska ainirka: —Chilla. ");
INSERT INTO inb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chasa nis­paka, Olivos lumama rirka; imasa­mi tukui tuta­kuna ri­dur karka: chasa. Paita kati­raiag­kuna­pas kati­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ña chima chaiag­rispa, Jesuska nir­ka­kunata: —Taita Diusta maña­na­kui­chi, tukui mana alli­lla rurai­kuna kam­kunata mana chaiachu. ");
INSERT INTO inb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chasa nis­paka, pai­kuna­pag­manda sug rumi sitaska urmag­riska­sina karuajma rispa, chipi kungu­rispa, Taita Diusta mañai kalla­rirka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Taitiku, kam munas­paka, kai iapa llakiita anchu­chi­wai. Nuka chasa muna­kug­pipas, nuka imasa munaska­sina mana tuku­chu. Kam imasa munaska­sina rurai. ");
INSERT INTO inb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chi­ura suma luar­manda sug anjil, kawa­rig­samuspa, mas animu­chirka. ");
INSERT INTO inb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iapa llaki­kuspa, Jesuska paipa Taita Diusta masmi maña­kurka. Alpama sutu­chig­ta­mi iawar­sina jumbi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Taita Diusta mañai puchu­kas­paka, ata­rispa, kati­raiag­kuna­pagma kutirka. Llakii­wa puñu­na­kus­kata tarig­rispa, ");
INSERT INTO inb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","nirka: —¿Imapatak puñu­rirkan­gi­chi? Ata­rispa, Taita Diusta maña­na­kui­chi, tukui mana alli­lla rurai­kuna kam­kunata mana chaia­chu. ");
INSERT INTO inb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús chasa rima­kug­lla­pi, achka runa­kuna chima chaiag­rir­ka­kuna. Chi runa­kunata, chunga iskai Jesús agllas­ka­kuna­manda Judas suti runami ñugpa­raiarka. Jesusta muchan­ga­pa iuiai­wa pai­pagma kailla­iarka. ");
INSERT INTO inb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesuska, Judasta nirka: —¿Kai Runa Tukus­kata mu­chas­pa­lla­chu api­chi­wankangi? ");
INSERT INTO inb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ima pasa­rin­ga­pa kas­kata kawas­paka, Jesus­wa kag­kuna paita tapur­ka­kuna: —Taita waugki, ¿ispada­kuna­wa­chu micha­ri­sun­chi?—. ");
INSERT INTO inb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chasa tapuspa, sug Jesus­wa kag­puraka, ispada surkuspa, iaia sasir­dutipa lutrinta piaspa, alli ladu rinrita ialigta kuchurka. ");
INSERT INTO inb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesuska nirka: —Chilla. Ianga kawai­chi—. Chasa nis­paka, chi runapa rinrita tupa­rispa, alia­chirka. ");
INSERT INTO inb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iaia sasir­duti­kuna, Dius­pa atun wasita kawag­kuna i sug taita­kuna­pas riska kar­ka­kuna, Jesusta api­chin­ga­pa. Chi runa­kunataka, Jesús tapurka: —¿Imapatak nukata, sisaita­sina ispada i garuti kaspi­kuna­wa api­wan­ga­pa samu­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tukui puncha­kuna­mi Dius­pa atun wasi ukupi nuka kam­kuna­wa karkani. Chipika, ¿imapatak mana maki­wa api­warkan­gi­chi? Nig­pika, kuna­ura­mi kam­kuna iana tutapi mandag iaia kuku­wa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesusta apis­paka, chi runa­kuna iaia sasir­dutipa wasima chaia­chig­rir­ka­kuna. Pedroka, karu karu­lla­pi kati­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chi wasi kan­cha chaugpipi nina sindi­chispa, muiugta tia­rir­ka­kuna. Pedropas, pai­kuna­wa tia­rirka. ");
INSERT INTO inb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chi­ura sug kawag warmika, Pedro chasa tia­kus­kata nina sindi puncha­ia­chis­ka­wa kawaspa, ikuti alli­lla kawaspa, nirka: —Kai runapas, chi Jesus­wa­mi karka. ");
INSERT INTO inb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedroka, chasa uiaspa, nirka: —Pani, mana paita rigsi­nichu. ");
INSERT INTO inb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sug manancha unai­lla­pika, sug runapas, paita kawaspa, nirka: —Kampasmi chi runa­pura kangi. Pedroka, ikuti chasa uias­paka, ainirka: —Waugki, nuka manima pai­wa ka­nichu. ");
INSERT INTO inb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ikuti sug ura­sina ka­uraka, sug runapas mas sin­chi rimai­wa nirka: —Kai runapas, sutipa­mi chi Jesus­wa karka. Gali­lea alpa­manda­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Chi­ura, Pedroka nirka: —Waugki, manima iacha­nichu, kam ima­manda chasa rima­wa­kugta. Pedro chara rima­kug­lla­pi, gallu kantarka. ");
INSERT INTO inb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Chi­ura Iaia Jesuska, tigra­rispa, Pedrota kawarka. Chi­ura iuia­rig­samurka, imasa Jesús kikin Pedrota nigta: “Kai tuta, gallu manara kantag­pi­mi kamka kimsa biaji nuka­manda nin­ga­pa kangi: ‘Paita mana rigsi­nichu’.” ");
INSERT INTO inb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Chasa iuia­rig­samus­paka, kanchama llugsispa, dillakii wakai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesusta kawag runa­kunaka, paita unz̈aspa, piaspa cha­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Paipa ñawita kilpaspa, pias­paka, ni­na­kurka: —Willamui: ¿pitak kamta piar­ka?—. ");
INSERT INTO inb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pai­kuna imasa mu­nas­ka­sina Jesusta kami­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pakariska ka­uraka, iaia sasir­duti­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas tanda­rir­ka­kuna. Pai­kuna tanda­riska kaska­ma­mi Jesusta chaia­chig­rir­ka­kuna. Chipi chaia­chig­ri­uraka, paita nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Kam, Taita Dius agllaska Cristo kas­paka, nukan­chita willai. Chi­ura, Jesuska ainirka: —Nuka “Ari” nig­pika, kam­kuna mana uia­wankan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nuka ima tapugpi­pas, mana aini­wankan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Chasa kagpi­pas, kuna­ura­manda­ta kai Runa Tu­kus­ka, tukui mandu­iug Taita Dius­pa alli ladumi tia­rig­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chi­ura, tukui­kuna tapur­ka­kuna: —Nig­pika kam, ¿Taita Dius­pa wam­brachu kangi? Chi­ura, Jesuska ainirka: —Sutipami kam­kuna chasa nuka­manda nirkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Chasa aini­ura, nir­ka­kuna: —Chi­wanka, ¿imapatak chara pai­manda willag­kunata minis­ti­sun­chi? Nukan­chi kikin­mi uiar­kan­chi, pai kikin Taita Dius­sina tukuspa willa­rigta. ");
INSERT INTO inb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nis­paka tukui chipi kag­kuna, ata­rispa, Pila­tos suti mandag­pagma Jesusta chaia­chig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chipika, Jesus­manda willai kalla­rir­ka­kuna: —Kai runa, nukan­chi Israel­manda­kunata sug rigcha sug rigcha iuia­chispa puri­kus­ka­ta­mi uiar­kan­chi. Ni­kur­kami: “Roma­manda iaia mandagta mana im­puis­tu kulki kuan­gi­chi”. Kasa­pas­mi ni­kurka: “Cristo, atun mandag­mi kani”. ");
INSERT INTO inb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Chasa uiaspa Pila­toska, Jesusta tapu­chirka: —Kam, ¿judiu­kunapa atun mandagchu kangi? Chi­ura, Jesús ainirka: —Sutipami kam chasa nirkangi. ");
INSERT INTO inb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Chi­ura Pilatoska, iaia sasir­du­ti­kunata i tukui chipi kag­kunata nirka: —Kai runata mana tari­nichu ñi ima panda­riska kagta. ");
INSERT INTO inb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Chipi kag­kunaka, mas sin­chi rimai­wa nir­ka­kuna: —Tukui Judea alpapi, Gali­lea­manda­ta kai pui­blu­kama, runa­kunata iacha­chispa, sug rigcha sug rigcha iuia­chispa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Chasa uias­paka, Pila­toska tapurka: —Kai runa, ¿Gali­lea­mandachu ka?—. ");
INSERT INTO inb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ari” aini­ura, Hero­des Gali­leapi mandag Jeru­salenpi kag­manda iachas­paka, Jesusta pai­pag­ma kacharka. ");
INSERT INTO inb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusta kawas­paka, Hero­deska iapa kun­tin­ta­rirka. Ña unai­manda­ta pai­manda uiaspa, muna­kurka, ñi ima­ura­pas mana kawas­ka­sina ruragta kawa­pun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nis­paka, Jesusta ima­kuna­pas achka­mi tapu­chi­kurka. Nig­pika Jesuska, ñi ima mana ai­nirka. ");
INSERT INTO inb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Iaia sasir­duti­kuna i Moisés ima nis­kata iacha­chig taita­kuna­pas, chipi kaspa, Jesus­manda iapa sug rigcha sug rigcha willa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jesús mana ai­nig­manda, Hero­deska, suldadu­kuna­wa paita asispa, sutipa mandag­sina kawa­rin­ga­pa, iapa suma katanga kata­chir­ka­kuna. Nis­paka, Pila­tos­pag­ma paita ikuti kacharka. ");
INSERT INTO inb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chi puncha­manda, Pila­tos­wa Hero­des­wa ikuti alli­lla tukur­ka­kuna. Ñugpata pai­pura piña­chi­riska­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatoska, iaia sasir­duti­kuna­ta, judíu taita­kunata i tukui chipi kag­kuna­ta­pas tanda­chispa, ");
INSERT INTO inb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nirka: —Kai runata pusamus­paka, ni­warkan­gi­chimi: “Kaika, tukui­kuna­ta­mi sug rigcha sug rigcha iuia­chispa puri­kurka”. Nukaka, kam­kunapa ñawipi paita ña tapu­chispa, imasa pai­manda willa­waska­sina ñi ima panda­riipas mana tari­pu­nichu. ");
INSERT INTO inb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hero­despas, mana ima­pas tarir­ka­chu. Nispa­mi nukan­chi­pag­ma ikuti kacha­murka. Nig­pika, ñi ima­pas mana panda­riska kag­manda, ¿ima­manda­tak wañu­chin­ga­pa chaiá? ");
INSERT INTO inb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Asuti­chis­paka, kacha­ringa­pa­mi kani.  ");
INSERT INTO inb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wata watapi atun puncha chaia­ura, Pila­tos iacharka, sug kar­silpi kas­kata kacha­ringa. ");
INSERT INTO inb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pila­tos Jesusta kacha­rin­ga­pa ni­uraka, tukui chipi kag­kuna sug­lla­sina kapa­rii kalla­rir­ka­kuna, nispa: —Jesusta manima. Barra­bas­taka kacha­rii. ");
INSERT INTO inb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Chi Barra­bás, chi pui­blupi mandag­kunapa kun­tra ata­ri­chispa, wañu­chi­dur kag­manda­mi karsilpi wichka­raiarka. ");
INSERT INTO inb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pila­toska, Jesusta kacha­rin­ga­pa muna­kuspa, ikuti rimar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pai­kunaka kapa­rir­ka­kuna, nispa: —Kruspi churai. Kruspi chu­raspa wañu­chii. ");
INSERT INTO inb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatoska, ña kimsama ikuti nirka: —¿Imapitak kawarí, mana alli­lla ruraska kagta? Ñi ima panda­riipas mana tari­nichu. ¿Ima­manda­tak paita wañu­chin­ga­pa chaiá? Asuti­chis­paka, kacha­ringa­pa­mi kani. ");
INSERT INTO inb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Chi­ura, mas sin­chi kapa­rispa, tukui­kuna mañar­ka­kuna, Jesusta kruspi churai tukun­ga­pa. Chasa kapa­ri­na­kus­ka­manda, pai­kuna imasa muna­na­kuska­sina tukurka. ");
INSERT INTO inb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pila­tospas iuia­rig­samurka, pai­kuna maña­na­kus­kata: “Ari” nin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chi mandag­kuna­wa kun­tra ata­ri­chispa wañu­chi­durta karsilpi wichka­raias­kata kacha­rirka, imasa maña­na­kuska­sina. Jesustakar kacharka, imasa pai­kuna muna­na­kuska­sina wañu­chii tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ña Jesusta llugsi­chi­na­kus­ka­pi­ka, Sirene pui­blu­manda Simón suti runata apir­ka­kuna. Chi runa, chagra­manda­mi chaia­mu­kurka. Paitaka Jesús mar­kaspa apa­kuska krusta marka­chir­ka­kuna; chasaka, Jesusta kati­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Achka runa­kuna, Jesusta kati­chi­na­kurka. Achka warmi­kuna­pas, kati­chi­na­kuspa, pai­manda llakii­wa kapa­rispa waka­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus­ka, chi warmi­kuna­pagma tigra­rispa, nirka: —Kam Jeru­salen­manda warmi­kuna, nuka­manda mana waka­na­kui­chi. Kam kikin­kuna­manda i kam­kunapa wam­bra­kuna­mandakar wakan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sug puncha­kuna chaia­mu­uraka, nin­ga­kunami: “Mana wam­bra iukag­kuna, ima­ura­pas mana wigsa­wa ungu­rig­kuna i mana chuchu­chig­kuna, kun­tin­tulla alli iuiai­wa­mi kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chi­ura, luma­kunata nin­ga­kunami: “Nukan­chi­pagma urmag­samui­chi”. “Awa luma­kuna, nukan­chita kilpag­samui­chi”. ");
INSERT INTO inb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chawa kaspita kasa ruragpi­kunaka, chakiska kas­ka­taka, ¿imasa­sik ruran­ga­kuna? ");
INSERT INTO inb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iskai mana alli­lla rurag­kuna­ta­pas­mi apa­na­kurka, Jesus­wa sug­lla­pi wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Uma Tullu suti pambama chaiag­ris­paka, Jesusta kruspi klabar­ka­kuna. Chi iskandi mana alli­lla rurag­kuna­ta­pas kruspi klabaspa saia­chir­ka­kuna: sugtaka Jesuspa alli ladu, sugtaka paipa lluki ladu.  ");
INSERT INTO inb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesuska nirka: —Taitiku, pai­kunata pasin­siai. Mana iachan­kuna­chu ima rura­na­kugta. Jesuspa katan­ga­kunataka, sul­da­du­kuna suirtipi pugllar­ka­kuna, iachan­ga­pa: imasa­mi chaiá, pai­pura sug sug apan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tukui chipi kag­kuna kawa­na­kurka. Judíu taita­kunaka, Jesusta iapa unz̈aspa, ni­na­kurka: —Kam, sug­kunata kispi­chig­samurkangisi. Kuna­ura, kam kikin kispi­chi­rii, Taita Dius agllaska Cristo kas­paka. ");
INSERT INTO inb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suldadu­kuna­pas, unz̈aspa, pai­pagma kailla­iaspa, winja binu chupa­chispa, ");
INSERT INTO inb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ni­na­kurka: —Judiu­kunapa atun mandag kas­paka, kam kikinlla kispi­chi­rii. ");
INSERT INTO inb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kruspi, Jesuspa uma awa ladu, sug willa­raias­ka­mi churar­ka­kuna. Chipi, kasa­mi ni­raiarka: “Kai­mi ka judiu­kunapa atun mandag”. ");
INSERT INTO inb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chi iskandi mana alli­lla rurag­pura­manda klaba­raiaskapas, sugka, Jesusta kamispa, ni­kurka: —Kam, ¿mana­chu Cristo kangi? Chasa kas­paka, ¿imapatak mana kis­pi­chi­ringi, kam kikin i nukan­chi­ta­pas? ");
INSERT INTO inb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ikuti sugka, kami­kus­kata piñarka, kasa nispa: —Kam, ¿imapatak mana Taita Dius­ta manchangi, kai runa pasa­kuska­sina­lla­tata pasa­kuspa­pas? ");
INSERT INTO inb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nukan­chitakar sutipa­mi chaia­kurka, kasa pasan­ga­pa, panda­ris­ka­kuna­manda. Ikuti kai runaka, ñi imapi mana panda­riska kan­chu. ");
INSERT INTO inb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nis­paka, Jesusta nirka: —Kam atun mandag tukus­paka, nuka­manda iuia­ri­wangi. ");
INSERT INTO inb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chasa ni­ura, Jesuska ainirka: —Kasami nuka niiki: kuna­ura­manda­ta­mi nuka­wa kag­rin­ga­pa kangi, paraíso suti suma luarpi. ");
INSERT INTO inb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ña chaugpuncha­sina tuku­ura­manda chaugpi chisi­kama, tukui alpa lim tutaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Indipas, lim amsaiarka. Dius­pa atun wasi uku­pipas atun linsu arka­raiaska, chaugpi chaugpi­mi lliki­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chi­ura Jesuska, sin­chi kapa­rirka, kasa nispa: —Taitiku, nuka­pa ispi­ri­tu­ta­mi kamta mingaiki—. Chasa nis­paka, wañurka. ");
INSERT INTO inb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Imasa pasa­ris­kata kawas­pa­ka, kapitanka, Taita Diusta iapa suma atun kagta nispa, nirka: —Kai runa, sutipa­mi ñi imapi mana panda­rig karka. ");
INSERT INTO inb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chima kawan­ga­pa ris­ka­kuna­ka, tukui ima pasa­ris­kata kawas­paka, llakii­wa pichupi maki­wa pia­rispa, pai­kuna­pagma ku­tir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesusta tukui rigsig­kuna i Gali­lea alpa­nig­manda paita kati­raiaska warmi­kunaka, karu­manda­lla tukui ima pasa­ri­kus­kata kawa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Judíu taita­pura­manda tiarka sug runa José suti, suma rurag i alli­lla iuiai­wa kag. ");
INSERT INTO inb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Chi Jesuspa kun­tra iuia­rispa ruraska taita­kuna­wa, paika chasa mana mu­nas­ka karka. Judea alpa i Ari­ma­tea suti pui­blu­manda karka. Dius­pa suma mandai chaia­mun­ga­pa puncha­ta suia­kurka. ");
INSERT INTO inb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Paika, Pila­tos­pagpi iai­kug­rispa, Jesuspa kuir­puta mañarka. ");
INSERT INTO inb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","“Ari” ni­uraka, Jesusta krus­manda urai­ku­chig­rispa, suma linsu­wa maituspa, murta­jarka. Sug rumi piñapi atun utku­chis­kapi, ñi pita manara pam­baska kas­ka­pi­mi utka­lla churag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ña warda puncha chaia­kug­manda, chi chisika chaiarka, tukui sumag­lla alli­chi­ri­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilea­manda Jesusta katig warmi­kunaka, Joseta kati­chispa, kawar­ka­kuna, maipi i imasa kuir­puta churaspa sakigta­kuna. ");
INSERT INTO inb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chi­manda kutis­paka, suma asnari ugsa­kuna i chasa­lla­ta suma asna iaku alli­chir­ka­kuna. Kaian­dika, warda puncha kag­manda, imasa ni­raiaska­sina sama­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Simana kalla­rii puncha u duminguka iapa tutata, chi warmi­kunaka, chi suma asnari alli­chis­kata apaspa, Jesús pamba­ra­ias­ka­ma rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chaiag­ris­paka, chi atun utku­chiska pungu­pi kilpa­raiaska rumita tim anchu­chiska kas­kata tarig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iai­kus­paka, Iaia Jesuspa kuir­puta manima tarir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mana tiag­manda ujna­rispa kawa­na­ku­uraka, iskai runa, iapa iura puncha katanga chura­ris­ka­kuna­mi kawa­rig­samur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chi warmi­kuna, iapa mancha­rispa, ña­lla­pas alpa­kama kumu­rispa kawa­na­kurka. Chi­ura, chi runa­kunaka nir­ka­kunata: —¿Imapatak kaugsa­ris­kata maska­na­kun­gi­chi wañus­ka­kuna pamba­dirupi? ");
INSERT INTO inb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kaipi mana kan­chu. Kaugsa­rir­kami. Iuia­rii­chi ima kam­kunata rimas­kata, Gali­lea alpapi ka­ura. ");
INSERT INTO inb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kasa­mi nirka: “Kai Runa Tukus­kataka mana alli­lla rurag­kuna apispa, kruspi churaspa­mi wañu­chi­wan­ga­pa kan­kuna. Kimsa punchapika ikuti­mi kaugsa­rin­ga­pa kani”. ");
INSERT INTO inb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Chi­ura chi warmi­kunaka, Jesús chasa nis­kata iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Chi pamba­diru­manda kutis­paka, chunga sug Jesús agllas­ka­kunata i tukui paita kati­raiag­kuna­ta­pas tukui imasa kawaska­sina willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jesús agllas­ka­kunata chasa willag­kuna kar­ka­kunami María Magdalena, Juana, San­tiagopa mamandi María i sug war­mi­kuna­pas. ");
INSERT INTO inb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pai­kuna chasa willa­na­kugpi­pas, chi runa­kunataka uia­rirka mana iuiai­lla­pi rima­na­kug­sina. Chi­manda mana munar­ka­kuna, chasa kagta uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pe­droka, ata­rispa, chi pamba­raiaska­ma kalparka, kawan­ga­pa. Chaiag­ris­paka, kumu­rispa kawarka. Chi­ura, linsu­kunalla chipi tiarka. Chasa kawas­paka, ima pasa­ri­kugta iapa ujna­rispa kutirka. ");
INSERT INTO inb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chi puncha­lla­tata, iskai Jesusta kati­raiag­kuna Emaús suti pui­bluma ñambipi ri­na­kurka. (Chi­manda Jeru­salenma chunga sug kilumitru­sina­mi tia.) ");
INSERT INTO inb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ri­na­kus­ka­pika, tukui ima pasa­ris­ka­manda rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pai­kuna rimaspa ri­na­kus­kapi, Jesús kikin, kailla­iaspa, pai­kuna­wa sug­lla­pi rii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Chasa sug­lla­pi ri­na­kuspa­pas, pai­kuna mana rigsin­ga­pa pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesuska tapur­ka­kunata: —¿Ima­manda­tak rimaspa ri­na­kun­gi­chi? Chi­ura, llakii­wa irkiaspa, saia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sug­lla­pi rig­pura, Kleo­fas sutika, ainirka: —¿Ima­wan­tak kam mana iachan­gi, kai puncha­kuna Jeru­sa­len­pi ima pasa­rigta? Kamllachar, mai­nig­manda samuska kaspa, ñi ima mana iachangi. ");
INSERT INTO inb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Imatak pasa­rirka?— Jesús tapurka. Chi­ura ainir­ka­kuna: —Nazaret pui­blu­manda Jesús ima pasagta. Pai runa, Santu Ispi­ri­tu­wa rimag kaspa, Taita Dius­pa i runa­kunapa ñawipi mana ima­ura­pas kawaska­sina ruraspa, tukuipi alli­lla iacha­chispa­mi karka. ");
INSERT INTO inb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paitaka, iaia sasir­duti­kuna i nukan­chipa taita­kuna api­chir­ka­kuna, kruspi churaspa wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nukan­chikar iuia­na­kur­kan­chimi: “Paimi Israel­manda runa­kunata kispi­chinga”. —Kasapas. Kuna­ura, kimsa punchami ña chasa pasa­riska ka. ");
INSERT INTO inb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nukan­chi­pura sug warmi­kuna, nukan­chita ujna­chir­ka­kunami. Pai­kuna, kai tutata pamba­raiaska­ma rispa, ");
INSERT INTO inb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kuir­puta manimasi tarig­rir­ka­kuna. Chi­manda kuti­muspa, ni­na­kur­kami: “Anjil­kuna, muskui ukupi­sina kawa­rispa, nir­ka­kunasi: ‘Paika, kaug­sa­mi ka’.” ");
INSERT INTO inb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chi­ura nukan­chi­wa sug kag­kuna­pas, pamba­raiaska­ma rispa, imasa war­mi­kuna niska­sina tarig­rir­ka­kuna. Jesuska, manimasi kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Chi­ura, Jesuska nirka: —Ai, kam runa­kuna, ¿mana­ra­char iuiai iukan­gi­chi? Santu Ispi­ri­tu­wa rimag­kuna tukui ima ñugpata willa­raias­kata, ¿ima­wan­tak kam­kuna, iapa alli­manda iuia­rin­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mana­chu Cristota chaiarka, chasa pasan­ga­pa; chi­wanka pai suma atun­ia­chiska, Taita Dius kas­kapi iaikug­rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Chasa nis­paka, Moisés i Santu Ispi­ri­tu­wa tukui rimag­kuna imasa willa­raias­ka­manda iuia­chin­ga­pa kalla­rirka; chasaka, tukui ima ñugpa­manda librupi pai­manda willa­raias­kata ima ni­raiagta pai­kuna iachan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pai­kuna ri­na­kuska pui­bluma ña chaia­na­kug­ri­uraka, Jesús mas karuma iali­kug­sina rii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Chi­ura nir­ka­kuna: —Mana rikui. Nukan­chi­wa sama­rii. Ñami chisi ka. Kamta tuta­ian­ga­pa­mi ka. ");
INSERT INTO inb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chasa ni­ura, Jesuska pai­kuna­pagpi iai­kurka, sama­rin­ga­pa. Nispa, ña pai­kuna­wa mikun­ga­pa tia­kus­paka, tanda chari­rispa, “Pai Siñur” Taita Diusta nirka. Tandata piti­chispa, pai­kunata kararka. ");
INSERT INTO inb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chasa rura­ura­mi ñawi paska­rig­sina tukur­ka­kunata. Chasaka, Jesusta rigsir­ka­kuna. Chi­ura­lla, pai­kunapa ñawipi mana mas kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chi­ura, pai­pura ni­na­kurka: —Ñambi samu­na­kus­kapika nukan­chi­wa rima­na­kuspa, ñugpa­manda librupi willa­raiaska imasa ni­raiagta willa­ku­ura, ¿mana­chu nukan­chita iapa alli iuia­chi­rig­samurka? ");
INSERT INTO inb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Chasa ninga­lla­waka, ata­rispa, Jeru­salenma kutir­ka­kuna. Jesús kikin chunga sug agllas­ka­kuna­pag­ma chaiag­rir­ka­kuna. Chipika, sug­kuna­pas sug­lla­pi kas­ka­ta­mi tarig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chipi kag­kuna­ka, pai­kunata nir­ka­kuna: —Iaia Jesús, sutipa­mi kaugsa­riska ka. Simon­ta­mi kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chi­ura, pai­kuna­pas willar­ka­kuna imasa ñambi ri­na­kus­kapi pasa­rigta. Imasa Jesús tandata piti­chi­ura rigsigta­kuna­pas willar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chasa rima­na­kug­lla­pi, Jesus­ka, pai­kunapa chaugpipi saia­rig­sa­muspa, “¿Alli­lla­chu ka­puan­gi­chi?” nir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Chi­ura, iapa mancha­rispa, ujna­rispa­mi iuia­na­kurka: “Sug waira­tachar kawa­na­kun­chi”. ");
INSERT INTO inb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Chi­ura, Jesuska nirka: —¿Imapatak mancha­rin­gi­chi? ¿Imapatak kam­kunapa sungupi chasa iuia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nuka­pa maki i chaki­kunata kawai­chi. Nuka kikin­lla­ta­ta­mi kani. Llam­ka­waspa, kawa­wai­chi. Waira, aicha ñi tullu mana iukan­kuna­chu. Ikuti nukaka, imasa kam­kuna kawa­wa­na­kug­sina­mi aicha i tullu iukani—. ");
INSERT INTO inb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chasa nis­paka, maki i chakita kawa­chir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Chasa kawaspa pai­kuna, iapa ujna­rispa, di­kuntintu manara pai kikin kas­kata iuia­ri­na­kug­mandaka, tapur­ka­kunata: —¿Imatak mikun­ga­pa tia­pun­gi­chita? ");
INSERT INTO inb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chi­ura, sug piti chalwa kusaska karar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chita chaskis­paka, pai­kuna kawa­na­kug­lla­pi mikurka. ");
INSERT INTO inb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mikus­paka, nir­ka­kunata: —Nuka, ñugpa kam­kuna­wa kas­pa, kasa­mi nirkai­ki­chita: Moisés imasa ruran­ga­pa niska­sina, Santu Ispi­ri­tu­wa rima­raiaska­sina i Sal­mos librupi tukui imasa nuka­manda willa­raiaska­sina­mi iukarka pasa­ringa. ");
INSERT INTO inb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Chasa nis­paka, pai­kunapa umapi iuiai­kunata punchaia­chig­sina iuia­chirka; chasaka, ñugpa­manda librupi willa­raiaska ima ni­raias­kata iachan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kasapasmi nir­ka­kunata: —Kasami chi librupi willa­raiá: Taita Dius agllaska Cristo, iapa nanai i llakii iukaspa­mi wañun­ga­pa ka. Nis­paka, kimsa punchapi ikuti­mi kaugsa­rin­ga­pa willa­raiá. ");
INSERT INTO inb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pai­manda, Jeru­salenpi kalla­rispa, tukui alpa­kunapi willag­ringa­pa­mi ni­raiá. Mai­kan panda­rii­kunata sakispa Taita Dius­wa tukug­samus­ka­kunataka, panda­rii­kuna pasin­siai tukunga­pa­mi willa­raiá. ");
INSERT INTO inb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Kam­kunaka, tukui ima pasa­ris­kata kawaspa, nuka­manda willag­kuna­mi kankan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nig­pika, nuka­pa Taita kam­kunata kara­mun­ga­pa nis­ka­ta­mi nuka kacha­musa­ki­chita. Chi­manda, kai pui­blu­lla­pi suian­gi­chi, ima­ura suma luar­manda paipa iapa iachaita chaskin­kama. ");
INSERT INTO inb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Chasa nis­paka, Betania pui­blu­ma ña chaian­kama pai­kunata pusarka. Chipi chaiag­ris­paka, maki­kunata ata­ri­chispa, Taita Diusta pai­kuna­manda maña­pur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chasa maña­kuspa­lla, pai­kuna kawa­na­kug­lla­pi, suma luar­ma­mi sikai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pai­kunaka, Jesusta kungu­rir­ka­kuna. Nis­paka, suma alli iuia­chii­wa Jeru­salenma kutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chipika, Dius­pa atun wasipi ima­ura­pas ni­dur kar­ka­kuna: —Kam Taitiku, iapa suma atun­mi kangi.");
INSERT INTO inb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kalla­ri­ura, ñi imapas manima tia­ura, timpumi Diuspa Rimai tiarka. Paimi Taita Diuspi tiarka. Diusllatatami karka. ");
INSERT INTO inb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kalla­ri­ura, mana imapas tiaska­ura­manda­ta, Taita Diuspimi tiarka. ");
INSERT INTO inb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Paiwami tukui ima ruraska tia. Mana pai kagpika, ñi imapas mana ruraska­mi kantra. ");
INSERT INTO inb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pai kikinpami kaug­sai tiarka. Chi kaug­saimi runa­kunapa iuiai­kunata puncha­ia­chig­samú. ");
INSERT INTO inb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chi punchaia­chig runa samurkami, maipi iana tuta iuiai­wa kas­ka­kunata puncha­ia­chin­ga­pa. Chi puncha­ia­chii iuiaitaka, tuta­ia­chig mana puchukan­ga­pa pudirka. Puncha­llami kidá. ");
INSERT INTO inb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tiarka sug runa, Juan suti, Taita Dius paita kacha­muska. ");
INSERT INTO inb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pai samurkami, runa­kunapa iuiai­kunata puncha­ia­chig­manda willag kan­ga­pa; chasaka, tukui­kuna pai ima willaskata suma iuia­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan, mana chi puncha­ia­chig karkachu. Chi puncha­ia­chig­manda willanga­pa­mi samurka. ");
INSERT INTO inb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chi puncha­ia­chig runaka, sutipa puncha­ia­chig­mi ka. Paimi tukui runa­kunapa iuiai­kunata puncha­ia­chig­samú. Pai­lla­ta­ta­mi kai alpama samurka. ");
INSERT INTO inb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pai­wa kai alpa wiña­chiska kagpi­pas, ña kai alpama samuska ka­ura, kai alpa­manda runa­kuna mana paita rigsir­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pai kikinpa alpa­manda runa­kuna­pagma samurka. Chi­ura, pai kikinpa runa­kuna mana munar­ka­kuna, paita chaskin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mai­kan­kuna paita suma iuia­rispa chaskig­kunatakar nir­ka­kunata, Diuspa wam­bra­kuna tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Chi suma iuiag­kuna, runapa iawar­manda, ñi kasadu­pura­manda ñi kari munaska­manda mana tiag­samun­kuna­chu. Taita Dius­manda­lla­mi tiag­samun­kuna, paipa wam­bra­kuna kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Diuspa Rimai, runa tukuspa, nukan­chi­wa­mi kaug­sag­samurka. Taita Diuspa suglla wam­bra kag­manda, pai iapa suma atun kag­ta­mi kawarkan­chi. Iapa suma kuiag pag­ta­mi karka, ñi imapi mana llullaspa­lla. ");
INSERT INTO inb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pai­manda, Juanka sin­chi rimai­wa­mi willarka, kasa nispa: —Kai runa­mandami nirkai­ki­chi­ta: “Sug nuka­manda mas iacha­ka, nuka­pa katimi samun­ga­pa ka. Paimi nuka­manda mas ñugpa kalla­riska­ura­manda­ta tiaska ka”. ");
INSERT INTO inb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pai tukui iapa alli­lla iukas­paka, iapa suma kuiai­wa­mi tukui nukan­chita ima­ura­pas karamú. ");
INSERT INTO inb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moises­man­da­mi imasa Taita Dius ruran­ga­pa niskata iachan­chi. Ikuti Jesu­cristo­mandaka tukui suma kuiaita i sutipa kaska­ta­mi chas­kin­chi. ");
INSERT INTO inb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ñi pi­ta­pas mana ima­ura­pas Taita Dius kawa­riska kanchu. Pai­pa suglla wam­bra Dius­lla­ta­ta­mi, Taita Diuspi kaspa, paita nukan­chita kawa­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jeru­salen­manda judíu taita­kuna, sasir­duti­kunata i Diuspa atun wasipi aidag­kunata Juan­pagma kachar­ka­kuna, tapun­ga­pa: —Kam, ¿pitak kangi? ");
INSERT INTO inb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chi­ura paika, imasa kaska­sina willarka, kasa nispa: —Nuka, mana Taita Dius agllaska Cristo ka­nichu. ");
INSERT INTO inb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—Nigpika— tapur­ka­kuna—, ¿ima­tak kangi? ¿Eliaschu kangi? Chi­ura, paika ainirka: —Manima. —Mana kagpika, ¿Santu Ispi­ri­tu­wa rimag samun­ga­pa ni­ra­iaska­chu kangi? —Manima. ");
INSERT INTO inb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chi­ura tapur­ka­kuna: —¿Pitak kangi; chasaka, nukan­chi kacha­mus­ka­kunata willag­rin­ga­pa? Kam kikin­manda, ¿ima­tak ni­ringi? ");
INSERT INTO inb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Chasa tapu­ura, Juanka ai­nirka: —Nuka kanimi chusa sitaska alpa­pi sug sin­chi rimai­wa kapa­rig, kasa nispa: “Imasa­mi ñambi alli­chin­chi: chasa­lla­ta alli iuiai­kunata apii­chi, atun Taita Diusta chaskin­ga­pa”. Chasa­mi Isaías suti Santu Ispi­ri­tu­wa ñugpa­manda­ta nuka­manda willaska karka. ");
INSERT INTO inb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chi Juan­pagma kachaska runa­kuna, fari­seo­kuna­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nis­paka, paita tapur­ka­kuna: —Nigpi kamka, Cristo, ñi Elías ñi chi Santu Ispi­ri­tu­wa rimag mana kas­paka, ¿imapatak baug­ti­sa­kungi? ");
INSERT INTO inb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Chasa tapu­ura, Juanka ai­nirka: —Nuka, iaku­lla­wa­mi baug­ti­sani. Sug­mi kam­kunapa chaugpipi ka. Kam­kuna manara paita rigsin­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Paika, nuka­pa katimi samun­ga­pa ka. Paita, nuka mana pudi­ni­chu, kungu­rispa, paipa chaki­kunapi chura­raiaska wataskata paska­pun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jor­dán iaku sug ladu chimba, Betania suti pui­blupi, Juan baug­ti­sa­kuska­pi­mi chasa pasa­rirka. ");
INSERT INTO inb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kaiandi, Jesús Juan­pagma kai­lla­ia­kuskata kawaspa, nirka: —Kawai­chi. Kai­mi ka Taita Diuspa Ubija­sina ni­raiaska. Paika, kai alpapi kaug­sag­kunapa panda­rii­kuna­ta­mi anchuchí. ");
INSERT INTO inb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Pai­manda­mi nuka nirkai­ki­chita: “Sug nuka­manda mas iachami nuka­pa kati samun­ga­pa ka. Paika, ñugpa­manda­ta­mi tiarka”. ");
INSERT INTO inb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Paita, nuka mana rigsirka­nichu. Mana rigsis­pa­pas, nuka, samuspa, iaku­wa baug­ti­sarka­nimi; chasaka, Israel­manda runa­kuna paita rigsin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan, imasa kawaska­sina willaspa, kasa­mi nirka: —Santu Ispí­ritu, paluma­sina rig­cha awa­manda urai­ku­muspa, pai­pagma chaiag­samuska­ta­mi kawarka­ni. ");
INSERT INTO inb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Chi­kama, paita mana rigsirka­nichu. Taita Dius iaku­wa baug­ti­san­ga­pa kacha­mu­wagmi ni­waska karka: “Kam kawan­kangimi, Santu Ispí­ritu urai­ku­muspa, sug runa­pagma chaiag­samugta. Chi runami Santu Ispi­ri­tu­wa baug­ti­sag ni­raiá”. ");
INSERT INTO inb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","—Nukaka, chasa kawas­paka, willai­ki­chitami: “Paimi Taita Dius­pa wam­bra ka”. ");
INSERT INTO inb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Sug kaiandi Juanka, ikuti iskai paita kati­raiag­kuna­wa kaspa, ");
INSERT INTO inb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús iali­kuskata kawas­paka, nirka: —Kawai­chi. Kai­mi ka Taita Dius­pa Ubija­sina ni­raiaska. ");
INSERT INTO inb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chasa niskata uias­paka, chi iskandi runa­kuna Jesusta katii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesuska, tigra­rispa, chi kati­na­kugta kawas­pa, tapurka: —¿Imatak maska­na­kun­gi­chi? Chi­ura ainir­ka­kuna: —Rabí, ¿maipitak kaug­sangi?—. (Rabí ni­raianmi: “Iacha­chig taita”.) ");
INSERT INTO inb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Chi­ura, Jesuska nirka: —Akushi; kawan­kan­gi­chimi. Pai­kuna, ris­paka, Jesús kaug­sa­diru wasita kawag­rir­ka­kuna. Ña chisi, mai las kuatru kag­mandaka, Jesus­wa chipi kida­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chi iskandi Juanta uiaspa Jesus­ta katig­kuna, sug karkami Andrés suti Simón Pedropa waugki. ");
INSERT INTO inb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Paika, kikinpa waugki Simonta willag­rirka, kasa nispa: —Mesías runa­ta­mi tarir­kan­chi—. (Mesías ni­raianmi Taita Dius agllaska Cristo.) ");
INSERT INTO inb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chasa nis­paka, Simonta Jesus­pagma pusarka. Chi­ura Jesus­ka, Simonta alli­lla kawaspa, nirka: —Kam kangimi Simón, Jonaspa wam­bra. Kuna­ura­manda, Sefas suti­chi­sa­ki—. (Sefas ni­raianmi Pedro.) ");
INSERT INTO inb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kaiandi Jesús, Gali­lea alpama rin­ga­pa muna­kus­paka, Felipe suti runata maskan­ga­pa rirka. Tarig­ris­paka, paita nirka: —Kati­wai. ");
INSERT INTO inb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe, Betsaida suti pui­blu­manda­mi karka, Andrés i Pedropa pui­blu­manda­lla­tata. ");
INSERT INTO inb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chi­ura­manda Felipeka, Natanael suti runata maskan­ga­pa rirka. Tarig­ris­paka, paita nirka: —Moisés ima ruran­ga­pa niskapi willa­raiaska­sina i Santu Ispi­ri­tu­wa ñugpata rimag­kuna willaska­sina, pai runa­wa­mi kawa­na­kurkan­chi. Jesús suti Naza­ret pui­blu­manda José suti runapa wam­bra­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelka nirka: —¿Ima­uratak uiaska kan­chi, Naza­ret pui­blu­manda suma alli runa llugsigta? Chi­ura, Felipeka nirka: —Akushi; kawankangimi. ");
INSERT INTO inb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael kailla­iag­ri­ku­ura, Jesuska, kawaspa, pai­manda nirka: —Kaimi ka Israel­manda sug sutipa alli runa, ñi ima­pipas mana llulla. ");
INSERT INTO inb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelka tapurka: —Nukata, ¿imasatak rigsi­wangi? Chi­ura, Jesús ainirka: —Felipe manara kam­bagma chaiag­rigpita, kam igira sacha sikipi tia­kuska­ta­mi kawa­kurkaiki. ");
INSERT INTO inb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chasa aini­ura, Natanael nirka: —Kam iacha­chig taita, Taita Dius­pa wam­bra­mi kangi. Israel­manda runa­kunata iaia mandag­mi kangi. ");
INSERT INTO inb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chi­ura, Jesuska ainirka: —“Kam igira sacha sikipi tia­kuskata kawaspa”, ¿chasa nig­man­da­llachu chasa suma iuia­ri­wangi? Kuna­ura­manda mas suma mana ima­ura­pas kawas­ka­kuna­mi kawan­ga­pa kangi—. ");
INSERT INTO inb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kasa­pas­mi nirka— Kasa­mi nuka nii­ki­chita: suma luar paska­riska­ta­mi kawan­ga­pa kan­gi­chi, Taita Diuspa anjil­kuna kai Runa Tukuska­pagma urai­ku­muspa sika­na­kuska­ta. ");
INSERT INTO inb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kimsa punchapika, Gali­lea alpa­manda Kaná suti pui­blupi sug kasaraimi tiarka. Chi kasaraipi, Jesuspa mama­pas­mi kag­rirka. ");
INSERT INTO inb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus­ta i paita kati­raiag­kuna­ta­pas­mi kunbidar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chi kasaraipika, binu pisig­samurka. Chasa kag­mandaka, Jesus­pa mama, paita nirka: —Binu, ña mana iukan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Paika ainirka: —Mama, ¿imapatak chasa ni­wa­kungi? Nuka­pa puncha manara chaia­munchu. ");
INSERT INTO inb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Paipa mamaka, chi kasaraipi aidag­kunata nirka: —Pai tukui imasa niska­sina ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chi wasipi tiarka sugta atun rumi manga­kuna; chi­kunapi, ñug­pa­manda judiu­kuna iacha­chiska­sina mailla­rin­ga­pa. Sug sug man­ga­pi, pichka chunga u kan­chis chunga litru pagtarka. ");
INSERT INTO inb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nig­pika Jesuska, aidag­kunata nirka: —Manga­kunapi iaku junda­chii­chi. Chi­ura­lla, tukui manga­kunapi junda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chi­ura, Jesuska nir­ka­kunata: —Kuna­ura wisispa, butijiruta tantia­chig­rii­chi. ");
INSERT INTO inb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kara­ura, butijiruka iaku binu tukuskata upiarka, mai­manda wisiska kagta mana iachaspa­lla. Iaku junda­chig­kuna­lla­mi iachar­ka­kuna. Upias­paka, kusa tukun­ga­pa kagta kaiaspa, ");
INSERT INTO inb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nirka: —Tukui­kuna­pag­pi­mi ñugpa alli binuta karan­kuna. Nis­paka, ña alli upiaska ka­ura, manancha­ta­mi karan­kuna. Ikuti kamka, kunan­kama­mi mas alli binuta waka­chiska kangi. ");
INSERT INTO inb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chasami, Gali­lea alpa­manda Kaná pui­blupi, Jesús musuglla mana ima­ura­pas kawaska­sina rurarka. Chi­wa, pai suma atun kag­ta­mi kawa­chi­rirka. Chasa kawas­paka, paita kati­raiag­kuna mas suma pai­manda iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chi­ura­mandaka Jesús, paipa mama i waugki­kuna i paita kati­ra­iag­kuna­wan­ta Kafarnaum suti pui­bluma rir­ka­kuna. Chipi chaiag­ris­paka, sug mailla puncha­kuna­mi chisiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judiu­kunapa paskua atun puncha ña chaia­mu­ku­ura, Jesús Jeru­salenma rirka. ");
INSERT INTO inb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diuspa atun wasi ukuma iai­kug­ris­paka, wagra, ubija i paluma­kuna katug­kunata i kulki trukag­kuna tia­na­kuskata tarig­rirka. ");
INSERT INTO inb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chasa tarig­ris­paka, kabristu asuti­diru pata­rispa, tukui chi ukupi kag­kunata, ubija i wagra­kuna­wan­ta kanchama llugsi­chirka. Trukag­kunapa kulkita misa­kuna­wan­ta kaima chima bula­chirka. ");
INSERT INTO inb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Paluma katug­kuna­ta­pas nirka: —Tukui kai­kuna­ta­pas kai­manda llugsi­chii­chi. Nuka Taitapa wasita mana rurai­chi randig­samu­diru i katu­diru wasi. ");
INSERT INTO inb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesusta kati­raiag­kuna iuia­rir­ka­kuna, ñugpa­manda librupi kasa willa­raiaskata: “Kamba atun wasita kawaspa­mi dillakii puchuka­ri­kuni”. ");
INSERT INTO inb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesús chasa rurag­mandaka, judiu­kuna paita tapur­ka­kuna: —Kamka, ¿ima­watak kawa­chin­kangi, kam chasa llugsi­chin­ga­pa pudigta? ");
INSERT INTO inb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Chi­ura, Jesuska ainirka: —Kai Diuspa wasita puchu­kai­chi. Nukaka, kimsa puncha­pika ikutimi saia­chisa. ");
INSERT INTO inb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Chi­ura, judiu­kuna nir­ka­kuna: —Kai atun wasi, chusku chunga sugta wata­pi­mi saia­chiska ka. Kam­ka, ¿imasatak kimsa puncha­lla­pi saia­chin­kangi? ");
INSERT INTO inb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesuska, Diuspa wasi­manda chasa nispa, pai kikinpa kuir­pu­manda­mi ni­kurka. ");
INSERT INTO inb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pai ña wañuspa, kaugsa­riska ka­ura, paita kati­raiag­kuna chasa niskata iuia­rir­ka­kuna. Chasa iuia­ris­paka, ñugpa­manda librupi willa­raiaskata i Jesús ima rimaskata mas suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Chi paskua atun puncha Jesús Jeru­salenpi ka­ura, achka runa­kuna, mana ima­ura­pas kawaska­sina pai rura­kuskata kawas­paka, paita suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Chasa kagpi­pas, Jesuska, tukui­kunata imasa sungupi iuia­na­kuskata kawas­paka, pai­kunata mana alli­lla munarka. ");
INSERT INTO inb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mana paita minis­tirka, kikin runa­kuna imasa kaska­sina willa­rin­ga­pa. Pai kikin­mi kawarka, sungupi imasa iuia­na­kugta. ");
INSERT INTO inb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Sug judíu taita fari­seo runa­mi karka, Nikodemo suti. ");
INSERT INTO inb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chi runa­ka, sug tuta Jesus­pagma cha­iag­rispa, nirka: —Iachanchimi, kam iacha­chig taita, Taita Dius kacha­muska iacha­chig kan­ga­pa kagta. Taita Dius mana kamwa kag­pika, manachar pudin­trangi, chi mana ima­ura­pas kawaska­sinata kam ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesuska ainirka: —Kasami nuka niiki: mana ikuti llullu wawa­sina tiag­samug­pika, ñi mai­kan­pas mana pudin­ga­pa kan­chu, Taita Dius suma manda­kus­kapi kawa­rig­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Chi­ura, Nikodemo tapurka: —Ña ruku runa kaspa, ¿ima­sa­tak ikuti pudi­ringa tiag­samun­ga­pa? Nigpi, ¿ikutichu maman­dipa wigsa ukuma iai­ku­rispa, pudirí tiag­samun­ga­pa; chasa­chu pudirí? ");
INSERT INTO inb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Chi­ura, Jesuska ainirka: —Kasami nuka niiki: mana iaku­wa i Santu Ispi­ri­tu­manda tiag­samug­pika, ñi mai­kan­pas mana pudin­ga­pa kanchu, Taita Dius suma manda­kuskapi iai­kug­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mama­pa wig­samanda tiag­samug, aicha­lla­mi ka. Ikuti Santu Ispi­ri­tu­manda tiag­samugka, alli ispi­ri­tu­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Chaia­kumi, kam­kuna ikuti tiag­samun­ga­pa”; nuka kamta chasa niskata mana ujna­ri­kui. ");
INSERT INTO inb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wairaka, maima munaska­ma­mi pukunlla. Waira puku­kuskata uias­paka, mana iachan­gi­chi­chu, mai­nig­manda pukumu­kugta ñi masama ri­kugta. Chasa­lla­ta­mi Santu Ispi­ri­tu­manda tukui tiag­samug­kuna tukug­samun­kuna. ");
INSERT INTO inb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Chi­ura, Nikodemo tapurka: —¿Imasatak chasa kanga? ");
INSERT INTO inb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesuska nirka: —Kam, Israel­manda runa­kunata iacha­chig taita­mi kangi. Ikuti chasataka, ¿ima­wan­tak mana iachangi? ");
INSERT INTO inb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kasa­mi nuka niiki: nukan­chika, iachaspa­mi riman­chi; kawaspa­mi willan­chi. Nukan­chi chasa willaskata, kam­kunaka mana munan­gi­chi­chu uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nuka kai alpapi tiaska­manda willa­kuskata kam­kuna mana uia­wag­pika, ¿imasatak suma luarpi tiaska­manda willa­kuskataka uia­wan­kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Ñi pipas mana suma luarma sikaska kanchu. Kai Runa Tukuska suma luar­manda urai­ku­muska, pai­lla­mi ikuti suma luarma sikan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Imasa­mi Moisés, chusa si­tas­ka alpapi sug kulibra­sina rig­cha­ta ata­ri­chirka: chasa­lla­ta­mi kai Runa Tukuska­ta­pas chaia­ku, ata­ri­chii tukun­ga­pa; ");
INSERT INTO inb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chasaka, pai­manda tukui suma iuiag­kuna mana puchuka­ri­diru kaug­saita iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Taita Dius, kai alpa­manda tukui runa­kunata ña iapa kuiaspa, kikinpa suglla wam­bra­ta­mi kacha­murka; chasaka, pai­manda tukui suma iuiag­kuna, puchuka­ringa­taka, mana puchuka­ri­diru kaug­saita iukan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taita Dius, kikinpa wam­brata kai alpama mana kacha­murka, kai­manda runa­kunata justi­siai ruran­ga­pa. Nukan­chita kispi­chinga­pa­mi paita kacha­murka. ");
INSERT INTO inb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mai­kan­pas Taita Diuspa wam­brata suma iuiag­kuna mana justi­siai tukun­ga­pa kan­kuna­chu. Ikuti mai­kan paita mana uiag­kunaka, Taita Diuspa suglla wam­brata mana uiag­manda, timpumi justi­siai tukuska kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kasa­mi justi­siai tukur­ka­kuna: pai­kunapa iuiai­kunata puncha­ia­chig runa kai alpama samu­ura, pai­kuna, mana alli rurag runa­kuna kaspa, chi puncha­ia­chigta mana munar­ka­kuna. Munar­ka­kunami, tuta­ia­chiska iuiai­kuna­lla­wa kaug­sa­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mai­kan mana alli rurag­kuna, puncha­ia­chigta mana munan­kuna­chu. Chi­wanka, chi puncha­ia­chig­pagma mana kailla­iai munan­kuna­chu. Kailla­iagpi­kunaka, mana alli­lla ruraska­manda­mi piñai tukuntra­kuna. ");
INSERT INTO inb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ikuti mai­kan­pas sutipa alli rurag­kunaka, puncha­ia­chig­pag­ma­mi samun­kuna; chasaka, pai­kuna ima alli rura­na­kuskata Taita Dius imasa munaska­sina kagta kawa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chi­ura­manda, Jesús kati­raiag­kuna­wan­ta Judea alpama rirka. Chipi pai­kuna­wa kag­ris­paka, baug­ti­sa­chii­mi kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Enón suti Salim pui­blu ladu­lla­pi, achka iaku tiaska­pika Juan­pas­mi baug­ti­sa­kurka. Achka runa­kunaka, Juan­pagma chaia­na­kug­rirka baug­ti­sa­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Paika, manara kar­sil­pi churai tukuska karkachu. ");
INSERT INTO inb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juanta kati­raiag­kuna i sug judiu­wa sin­chi rima­na­kurka, kasa nispa: “Baug­ti­sa­ris­paka, ¿imasa­sik Diuspa ñawipi mailla­riska­sina alli­lla kawa­ringa?”. ");
INSERT INTO inb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nis­paka, Juan­pag­ma kailla­iaspa, nir­ka­kuna: —Iacha­chig taita, kam Jor­dán iaku sug ladu chimba ka­ura, sug runa kamwa kaska­manda pai pi kag­ta willarkangi; chi runapassi kuna­ura baug­ti­sa­ku. Tukui­kuna­mi pai­wa ri­nakú. ");
INSERT INTO inb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chi­ura, Juanka ainirka: —Suma luar­manda mana paita ima­pas kara­muska kag­pika, mana­char paipas ñi ima­pas pudin­tra karan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kam kikin­kuna­mi uia­warkan­gi­chi imasa nuka nigta: “Taita Dius agllaska Cristo, nuka mana ka­nichu. Pai­manda ñugpa rimag kacha­muska­lla­mi kani”. ");
INSERT INTO inb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kasarai punchaka, kusa tukun­ga­pa kagmi warmita chaskí. Kusa tukun­ga­pa kagwa iacha­riduka, paita uias­paka, iapa allimi iuia­chirí. Chasa­lla­ta nuka­ta­pas, chi runa­manda uiaspa, ajai iapa allimi iuia­chi­riwá. ");
INSERT INTO inb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pai­ta­mi chaia­ku, kuna­ura nuka­manda mas atun­ia­chii tukun­ga­pa. Ikuti nukataka chaia­wa­kumi, pai­manda mas uchulla tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Suma luar­manda samugmi tukui iaia­kuna­manda­pas mas iaia ka. Kai alpa­manda kagka, kai alpa­manda­lla­mi ka. Chasa­lla­ta, kai alpapi tias­ka­kuna­manda­lla­mi rimá. Suma luar­nig­manda samugka, tukui iaia­kuna­manda­pas mas iaia­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pai ima kawaska i uiaska­ta­mi alli­lla willá. Chasa willag­pi­pas, ñi pipas mana munan­kuna­chu uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mai­kan pai ima willaskata uiaspa suma chas­kig­kunaka, alli­lla­mi iuia­rin­ga­kuna, Taita Dius kikin ima­pipas mana llulla kagta. ");
INSERT INTO inb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Taita Dius, paipa Ispi­ri­tuta mana tupuspa­lla­mi pai kacha­muskata kara­murka. Chi­wa­mi paipa rimai­lla­wa willa­ku. ");
INSERT INTO inb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taita Dius, kikinpa wam­brata iapa kuiaspa, paipa maki­pi­mi churarka, tukuipi mandag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mai­kan­pas Taita Diuspa wam­brata suma iuiag­kuna, mana puchuka­ri­diru kaug­sai­ta­mi iukan­kuna. Ikuti Taita Diuspa wam­brata mana uian­ga­pa munag­kunaka, chi kaug­saita mana iukan­ga­pa kan­kuna­chu. Taita Diuspa iapa rabia­wa llakii­ta­mi chaskin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fari­seo­kunaka iachag­samur­ka­kuna, Jesusta kati­raiag­kuna, Juan­manda­pas mas achka miraspa, baug­ti­sa­ri­na­kugta. ");
INSERT INTO inb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesús kikinka mana baug­ti­sa­kurka. Paita kati­raiag­kuna­mi baug­ti­sa­na­kurka. Fari­seo­kuna chasa iachaskata uias­paka, ");
INSERT INTO inb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesuska, kati­raiag­kuna­wan­ta Judea­manda llugsispa, Gali­lea alpa­ma­mi kutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chima ri­na­ku­ura, paita cha­iarka, Sama­ria alpa suiu ialin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chi suiu iali­kuspa, Sikar suti pui­blu­ma­mi chaiag­rirka. Chi pui­blu kailla­ia­kuska­pika, ñugpa­manda taita Jakob, José suti paipa wam­bran­dita chi alpata karaskasi karka. ");
INSERT INTO inb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chi­pika, sug pusumi tiarka, Jakob sakiska. Jesuska, iapa sai­kuska puri­kuspa, chi pusu ladu­pi­mi tia­rig­rirka, ña chaug­puncha­sina. ");
INSERT INTO inb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chi­uraka, sug Sama­ria­manda warmisi chaiag­rirka, pusu­manda iaku surkun­ga­pa. Chi warmitaka, Jesús nirka: —Iaku kara­wai, upian­ga­pa—. ");
INSERT INTO inb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Jesusta kati­raiag­kuna, pui­blu­ma­mi riska kar­ka­kuna, mikui randin­ga­pa.) ");
INSERT INTO inb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Chi warmika ainirkasi: —¿Imasa­manda­tak kamka, judíu kaspa, nukata iaku maña­wa­kungi, nuka Sama­ria­manda warmi kaskata?—. (Judiu­kuna­wa i Sama­ria­manda runa­kuna­wa mana rima­na­ku­dur kan­kuna.) ");
INSERT INTO inb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesuska ainirka: —Kam mana iachangichu, Taita Dius ima karan­ga­pa tia­pugta ñi pi kamta iaku maña­kugta. Kam chasa iachas­paka, maña­wantrangichar, nuka mana wañu­diru iakuta karan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Chi warmika nirka: —Kam taita turika, mana ima­pas iukangichu, iaku surkun­ga­pa. Kai pusu, iapa jundu­mi ka. Nig­pika, ¿ima­watak chi mana wañu­diru iakuta surku­puan­kangi? ");
INSERT INTO inb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Nukan­chipa ñugpa­manda taita Jakob­manda mas atunchu kangi? Pai­sik kai pusuta nukan­chi­manda sakirka. Kikin­sik kai pusu­manda iakuta upia­dur karka. Paipa wam­bra­kuna i wagra­kuna­pas, chi­lla­tata upia­dur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesuska ainirka: —Kai pusu­manda iakuta upiag­kuna, ikutimi iaku­naiai iukan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ikuti mai­kan­pas nuka karaska iakuta upiag­kunaka, mana mas iaku­naiai iukan­ga­pa kan­kuna­chu. Chi iaku nuka karaska, pai kikin­kunapa kuir­pupi iaku ñawi iukag­sina­mi tukun­ga­pa ka. Chi­wanka, mana puchuka­ri­diru suma kaug­sai­ta­mi chaskin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Chasa aini­ura, chi warmi nirka: —Taita turi, chi iakuta kara­wai, nuka mana mas iaku­naiai iukan­ga­pa. Chasaka, mana nukata chaia­wangachu, ikuti kai pusupi iaku surkug­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesuska nirka: —Riilla. Kamba kusata kaiag­ris­pa, kaima ikuti samun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chi warmika ainirka: —Nuka, mana kusa­iug ka­nichu. Jesuska nirka: —“Mana kusa­iug ka­nichu” kam ni­wangi; alli­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pichka kusa­kuna­mi iukarkangi. Kuna­ura kam­wa kaug­sa­kug, mana kamba kusa kanchu. Chasapi, sutipa­mi ni­wangi. ");
INSERT INTO inb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Chi­ura, chi warmi nirka: —Kam taita turi rigcha­wangimi Santu Ispi­ri­tu­wa rimag kag­sina. ");
INSERT INTO inb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nukan­chipa ñugpa­manda taita­kuna, kai luma­pi­mi Taita Diusta kungu­ri­dur kar­ka­kuna. Ikuti kam­kunaka nin­gi­chimi: Jeru­salen­lla­pi­mi Taita Diusta kungu­rig­ri­diru ka. ");
INSERT INTO inb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesuska nirka: —Kam warmi, nukata suma iuia­wai. Kuna­ura chaia­mu­kumi, mana kai lumapi ñi Jeru­salenpi kam­kuna Taita Diusta kungu­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kam­kunaka mana iachan­gi­chi­chu, pita kungu­ri­na­kugta suma atun­ia­chin­ga­pa. Nukan­chikar iachan­chimi, pita suma atun­ia­chi­na­kugta. Tukui runa­kunata kispi­chig, judiu­kuna­pag­manda­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","—Suia­na­kuska puncha ñami chaia­murka. Kuna­ura­manda­ta Taita Diusta sutipa suma atun­ia­chig­kuna, Santu Ispi­ri­tu­wa i sutipa iuiai­wa­mi paita suma atun­ia­chin­ga­pa kan­kuna. Chasa atun­ia­chig­kuna­ta­mi Taita Dius maska­ku. ");
INSERT INTO inb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Taita Diuska, ispi­ri­tu­lla­mi ka. Mai­kan­pas paita suma atun­ia­chig­kunata chaia­kumi, Santu Ispi­ri­tu­wa i sutipa iuiai­wa suma atun­ia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Chi­ura, chi warmi nirka: —Nuka iachanimi, Mesías u Cristo samun­ga­pa kagta. Pai samu­uraka, nukan­chita tukuimi willan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Chasa ni­ura, Jesuska paita nirka: —Kamwa rima­kug, kam niska­ka, nuka­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chi­kama Jesusta kati­raiag­kunaka, chima chaiag­rispa, paita sug warmi­wa rima­na­kuskata kawas­paka, iapa ujna­rir­ka­kuna. Chasa kawaspa­pas, mana pipas paita tapur­ka­kuna: “¿Imatak muna­kungi?” u “¿Imatak chi warmi­wa rima­na­kun­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Chi warmika, iaku apag­ri­diru wabkanata sakispa, pui­bluma kalparka. Chaiag­ris­paka, tukui runa­kunata nirka: ");
INSERT INTO inb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Samui­chi. Akushi, kawan­ga­pa. Sug runa, tukui nuka ima ruras­ka­ta­mi willa­warka. ¿Manacha Cristo kantra? ");
INSERT INTO inb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chasa uias­paka, chi pui­blupi kag­kunaka, llugsispa, Jesus­pagma chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chi­kamaka, Jesusta kati­raiag­kuna ni­na­kurka: —Iacha­chig taita, kaita mailla­lla­pas mikui. ");
INSERT INTO inb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Paika ainirka: —Sug rigcha mikuimi nuka iuka­ni. Chita, kam­kuna mana rigsin­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kati­raiag­kunaka, pai­pura tapu­ri­na­kurka: —¿Mai­kanchu paita mikui apa­mu­purka? ");
INSERT INTO inb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesuska nirka: —Nukata kacha­mu­wag­manda, pai imasa munaska­sina tukui ruraspa puchukagta kawa­chiska, chimi nuka­pa mikui ni­raiá. ");
INSERT INTO inb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Kasapas. Kam­kuna, ¿mana­chu nin­gi­chi: “Chusku killa­mi chara pisi­ku, pallan­ga­pa”? Nuka­ka, kasa­mi nii­ki­chita: chagra­kunata­sina ñawi­wa runa­kunata alli­lla kawai­chi. Pai­kunaka, tim­pu­mi killuiaska pallan­ga­pa­sina kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mai­kan pallag­kunaka, ganan­kunami. Chi pallas­ka­kunaka, mana puchuka­ri­diru suma kaug­sai­ta­mi iukan­ga­kuna. Chasaka, tarpug i pallag sug­lla­pi­mi kun­tin­ta­rispa tukug­samun­ga­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","—Imasami su­ura nin­chi kasa: “Sugka, tarpug­mi ka; sugka, pa­llag­mi ka”: ");
INSERT INTO inb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","chasa­lla­ta­mi nukaka kachai­ki­chita, kam kikin­kuna mana tarpuskata pallag­sina ruran­ga­pa. Sug ñugpa­manda­kuna, tarpug­sina­mi iacha­chir­ka­kuna. Kam­kunaka, pai­kuna ima tarpus­ka­kunata pallag­kuna­sina­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chi Sama­ria pui­blu­manda war­mika, chipi kaug­sa­na­kuskata Jesus­manda willag­rirka, kasa nispa: —Tukui nuka ima ruraska­ta­mi willa­warka. Chasa uias­paka, achka­kuna Jesus­manda suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nis­paka, pai­pagma chaiag­rispa, maña­na­kurka: —Nukan­chi­wa kai­lla­pi kai. Chi­manda Jesús, iskai punchami pai­kuna­wa karka. ");
INSERT INTO inb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pai rima­kuska­ta uias­paka, mas achka­kuna­mi paita suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nis­paka, chi warmita nir­ka­kuna: —Ña kuna­ura­manda, kam rima­kuska­lla­taka mana pai­manda suma iuia­rin­chi­chu. Nukan­chi kikin­kuna, paita uiaspa­mi iachan­chi, pai sutipa kai alpa­manda runa­kunata kispi­chig kan­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chi pui­blupi iskai puncha chi­sias­paka, Jesuska llugsirka, pai kikin­pa Gali­lea alpama rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús kikin willaska karka, kasa nispa: “Kikinpa alpapi, Santu Ispi­ri­tu­wa rimag­kunata mana alli­lla kuian­kuna­chu”. ");
INSERT INTO inb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chi Gali­lea alpapi kaug­sa­na­kug, paskua atun puncha Jeru­salenpi Jesús tukui mana ima­ura­pas kawaska­sina ruraska­ta­mi kawaska kar­ka­kuna. Chi­manda­mi, Jesús chipi chaiag­ri­uraka, paita iapa sumag­lla chas­kir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús ña Gali­leapi kaspa, Kaná pui­bluma ikuti chaiag­rirka, ñug­pa­ta iakuta binu ruraska kaska­ma. Chipi karkami sug atun mandag­ta aidag runa. Chi runapa wam­braka, Kafarnaum pui­blupi ungug­si siri­kurka. ");
INSERT INTO inb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chi runaka, Jesús Judea­manda Gali­leama chaia­kugta iachas­paka, pai kaska­ma rirka. Chaiag­ris­paka, mañai kalla­rirka, kasa nispa: —Nuka­pa wasima ri­puai, nuka­pa wam­brata ambi­puan­ga­pa. Ñami wañu­pua­ku. ");
INSERT INTO inb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesuska nirka: —Mana kam­kunata ima­ura­pas kawas­ka­sina mana kawa­chig­pika, mana nuka­manda suma iuia­wan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chi runaka nirka: —Taita waugki, ri­puai, nuka­pa wam­bra manara wañu­puagpi. ");
INSERT INTO inb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chasa ni­ura, Jesús nirka: —Riilla kamba wasima. Kamba wam­bra, kaug­sa­mi ka. Jesús niskata uiaspa, suma iuiai­lla­wa­mi chi runaka rirkalla. ");
INSERT INTO inb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ña wasima chaia­kug­ri­uraka, pai­pa sug lutrin­kuna, wasi­manda llug­sispa, tupag­rir­ka­kuna, paita willaspa: —Kamba wam­bra, alli­lla kaug­sa­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chi­ura, paika tapurka: —¿Imasa­uratak ambi­rirka? —Kaina, chaugpuncha ialimi rupai­ka anchurka— ainir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Chasa aini­uraka, chi ungugpa taitaka iuia­rirka: “Chasa­ura­lla­ta­ta­mi Jesús ni­warka: ‘Kamba wam­bra, kaug­sa­mi ka’.” Chasa iuia­ris­paka, pai i paipa tukui wasi­manda­kuna, Jesus­manda mas suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chasaka Jesús, Judea alpa­manda Gali­leama chaiag­ris­paka, ña paris­ma­mi mana ima­ura­pas kawas­kata rurarka. ");
INSERT INTO inb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chi­ura­manda, judiu­kuna ikuti sug atun puncha iali­chin­ga­pa chaia­uraka, Jesuspas ikuti Jeru­salenma rirka. ");
INSERT INTO inb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chi pui­blupi, ubija­kunata iaiku­chi­diru pungu ladu­lla­pi tianmi sug iaku kuchaia­chiska. Chi iaku, hebreo rimai­wa suti kanmi Betzata. Chipi, pichka atun pungu­kuna­mi tia. ");
INSERT INTO inb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chi­kunapi, achka ungug­kuna siri­na­kurka: ñawi mana kawag­kuna, chaki­wa mana alli­lla sarui pudig­kuna i mana kuiu­rii pudig­kuna. Tukui chi­kuna suia­na­kurka, chi kuchaia­chiska iaku kuiu­rin­kama. ");
INSERT INTO inb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Atun Taita Diuspa anjil, diul diulpi urai­ku­muspa, chi iakuta kuiu­chi­dur karka. Iaku kuiu­chi­uraka, mai­kan ñugpa iakuma iai­kugka ima unguipas ambi­riska­sik kida­dur karka. ");
INSERT INTO inb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chipika karka sug runa, kimsa chunga pusag wata ungug. ");
INSERT INTO inb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Chi runata kawas­paka, Jesuska, unai­manda­ta chipi siri­kugta iachaspa, tapurka: —¿Munangichu ambi­riska kan­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chi­ura, chi ungug runa ainirka: —Taita waugki, iaku kuiu­chig­samu­uraka, mana iuka­nichu ñi pipas nukata iakuma iaiku­chi­wan­ga­pa. Nuka ima­ura­pas kailla­ia­kun­kamaka, sugmi nuka­pa ñugpa iai­kug­rí. ");
INSERT INTO inb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesuska nirka: —Atarii. Chakanata atari­chis­pa, kamba wasima rii. ");
INSERT INTO inb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chasa nig­lla­pi, chi runaka ambi­rig­samurka. Chakanata atari­chis­paka, purii kalla­rirka. Chi alia­chiska puncha, warda­mi karka. ");
INSERT INTO inb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Chi­manda judiu­kunaka, chi ambi­riska runataka nir­ka­kuna: —Warda puncha­mi ka. Kamba chakanata apan­ga­pa, kuna puncha micha­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Paika ainirka: —Nukata ambi­wag­lla­ta­ta­mi ni­warka: “Chakanata atari­chispa, kam­ba wasima rii”. ");
INSERT INTO inb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Chi­ura tapur­ka­kuna: —¿Mai­kan runatak kamta: “Ata­ri­chispa, kamba wasima rii” nirka? ");
INSERT INTO inb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Chi ambi­riska runa mana iacharka pi ambigta. Achka runa­kunapi, Jesús chapu­riska karka. Chi­wanka, paipa ñawi­manda chinga­rirka. ");
INSERT INTO inb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chi­ura­manda Jesuska, Diuspa atun wasi ukupi ambi­riska runata kawa­ris­paka, nirka: —Uiamui. Aliaska­mi kangi. Mana mas Diuspa ñawipi panda­ringi. Ikuti panda­rig­pika, pudinmi kuna­ura­manda mas mana alli­llapas tukunga. ");
INSERT INTO inb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chi runaka, judiu­kuna­pagma rispa, nig­rirka: —Nukata ambi­wagka, Jesusmi suti ka. ");
INSERT INTO inb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chi­ura­manda judiu­kunaka, Jesús warda puncha chasa ambiska­manda, paita kuntrai kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Paika nir­ka­kunata: —Nuka­pa Taita, kuna puncha­pas­mi alli­lla rura­ku. Nuka­pas­mi alli­lla rura­kuni. ");
INSERT INTO inb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Judiu­kuna, chasa niskata uias­paka, mas wañu­chin­ga­pa iuiai apir­ka­kunata. Warda puncha ungugta alia­chiska­mandallaka, mana; kikin Jesús, Taita Dius­sina­lla­tata tukuspa, “Nuka­pa Taita­mi ka” nig­manda­mi muna­na­kurka wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chi­ura, Jesuska nirka: —Kasami nuka nii­ki­chita: Taita Diuspa wam­bra, kikinpa iuiai­lla­wa mana ima­pas rurai pudinchu. Imasa Taita Dius rura­kuskata kawas­ka­wa­mi rurá. Taita Dius imasa­mi rurá: chasa­lla­ta­mi paipa wam­bra­pas rurá. ");
INSERT INTO inb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taita Dius, paipa wam­brata iapa kuiaspa­mi tukui ima rura­kuskata kawa­chiwá. Kuna­ura­manda, ikuti mas sug rigcha­pas­mi rurai­kunata kawa­chi­wan­ga­pa ka; chasaka kam­kuna­pas, nuka chasa­lla­ta rura­kuskata ujna­rispa kawa­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imasa­mi Taita Dius, wañus­ka­kunata kaug­sa­chispa, paipa kaug­saita kará: chasa­lla­ta­mi paipa wam­brapas, mai­kan nuka munas­ka­ta kaug­saita karani. ");
INSERT INTO inb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","—Kasapas. Taita Dius, mana pi­ta­pas justi­siai ruranchu. Chasa­paka, paipa wam­bra­ta­mi tukui iachaita kararka, tukui­kunata justi­siai ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chi­wanka, imasa­mi Taita Diusta suma atun­ia­chin­kuna: chasa­lla­ta paipa wam­bra­ta­pas­mi tukui­kuna suma atun­ia­chin­ga­pa kan­kuna. Mai­kan­pas Taita Diuspa wam­brata mana suma atun­ia­chig­pika, ¿ima­sa­tak kikin Taita Dius kacha­mugta atun­ia­chin­ga­kuna? ");
INSERT INTO inb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Kasami nuka nii­ki­chita: mai­kan­pas nuka­pa rimai­kunata uia­waspa, nukata kacha­mu­wag­manda suma iuiag­kuna, mana puchu­ka­ri­diru kaug­sai­ta­mi iukan­kuna. Mana justi­siai tukun­ga­pa kan­kuna­chu. Dil­tudupa wañuita kispispa, mana mas wañun­ga­pa kaug­sai­ta­mi tarir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kasa­mi nuka nii­ki­chita: suia­na­kuska puncha ñami chaia­murka; wañus­ka­kuna­pas, Taita Diuspa wam­bra­pa rimaita uianga­pa­mi kan­kuna. Mai­kan uia­wag­kunaka, dil­tudu­pa kaug­sai­ta­mi tarin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imasa­mi Taita Dius kikin, kaug­saita iuká: chasa­lla­ta­mi paipa wam­brata kararka, kikinpa kaug­saita iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Paipa wam­bra runa tukuska kag­manda, tukui iachai­ta­mi kararka, justi­siai ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Chasa uia­wa­na­kus­paka, mana ujna­ri­na­kui­chi. Ñami chaia­mun­ga­pa ka, tukui wañus­ka­kuna, nuka­pa rimaita uia­waspa, ");
INSERT INTO inb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","pai­kuna pamba­raiaska­manda llugsin­ga­pa. Chi­ura, mai­kan­pas alli­lla ruraspa wañus­ka­kunaka kaugsa­ringa­pa­mi kan­kuna, mana puchu­ka­ri­diru suma kaug­saita iukan­ga­pa. Ikuti mana alli­lla ruraspa wañus­ka­kunaka, kaugsa­rispa, justi­siaimi tukun­ga­pa kan­kuna, dil­tudupa ninama kachai tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Nuka kikinpa iuiai­lla­wa mana ima­pas rura­nichu. Nuka­pa Taita imasa ni­waska­sina­wa­mi justi­siai rurani. Nuka justi­siai ruras­kaka, imasa chaiaska­sina alli­lla­mi ka. Chika, nuka mana rura­ni­chu nuka imasa munaska­sina. Nuka­pa Taita kacha­mu­wag imasa pai ni­waska­sina­mi rura­kuni. ");
INSERT INTO inb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Nuka kikin­manda­lla willa­ri­kugpi, manachar sutipa kantra. ");
INSERT INTO inb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sugmi nuka­manda willag ka. Iacha­nimi, pai nuka­manda willa­kuskaka tukui sutipa kagta. ");
INSERT INTO inb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—Kam­kuna Juan­pagma kacharkan­gi­chi, nuka­manda tapun­ga­pa. Chi­ura pai ainiskaka, tukui sutipa­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Chasa kagpi­pas, nuka­ta mana minis­ti­wanchu, ñi mai­kan runapas nuka­manda willan­ga­pa. Kam kikin­kuna kispi­chii tukuska kanga­pag­lla­mi nuka chasa nii­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan karkami sug bila puncha­ia­chi­kug sindi­kug­sina. Kam­kunaka, chi puncha­ia­chig­sinata kawas­paka, sug ratu­lla­mi alli iuia­chi­rispa karkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—Juan­manda mas suma­mi nuka­manda willag tia. Imasa­mi nuka­pa Taita ruran­ga­pa kacha­mu­warka: chasa­mi rura­kuni. Nuka ima ruraskata kawas­paka, chi­kuna­wa­mi iachan­kan­gi­chi, nuka­pa Taita nukata kacha­mu­waska kagta. ");
INSERT INTO inb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Nuka­pa Taita kacha­mu­wag­pas­mi nuka­manda willá. Kam­kunaka, mana ima­ura­pas paipa rimai­ta uiaska i pai imasa rigcha kagta kawaska kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pai kacha­mu­waska kagta mana uia­wan­ga­pa munag­manda­mi paipa rimaita mana kam­kunapa iuiaipi iukan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Diuspa Rimai librupi suma­mi kawan­gi­chi, kasa iuiaspa: chi­pi­mi mana puchuka­ri­diru suma kaug­sai­ta tari­rí. Chi­lla­pi­ta­mi nuka­man­da­pas willa­raiá, nuka kacha­muska kan­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Chasa willa­raiaskata kawaspa­pas, kam­kuna mana muna­na­kun­gi­chi, nuka­wa samuspa, chi kaug­saita iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Nuka mana munanichu, ñi mai­kan runapas atun­ia­chi­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kam­kunata alli­lla­mi rigsii­ki­chita. Iacha­nimi, kam­kuna mana Taita Diusta kuiagta­kuna. ");
INSERT INTO inb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","—Nukaka, nuka­pa Taita kacha­mu­waskami samurkani. Chasa samugpi­pas, nukata kam­kuna mana muna­wan­gi­chi­chu. Ikuti sug mai­kan­pas samuntra, kikin­man­da­lla iuia­rispa; chitakar chas­kin­tran­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—Suglla Taita Dius kam­kuna­ta atun­ia­chin­ga­pa kaskata mas­kan­ga­taka, kam­kuna­pura­lla­mi atun­ia­chi­rispa kan­gi­chi. Chasa rura­na­kus­paka, ¿imasatak nuka­manda suma iuia­wan­kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Mana iuia­na­kui­chi, nuka kam­kuna­manda nuka­pa Taitapa ñawipi mana alli­lla ruras­ka­kunata willag­rin­ga­pa kagta. Moisés kikin­mi kam­kuna­manda chasa willan­ga­pa ka, kam­kuna pai­wa sumag­lla iuia­na­kugpi­pas. ");
INSERT INTO inb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kam­kuna, Moi­sesta sutipa suma iuia­ris­paka, nuka­manda­pas­char chasa­lla­ta suma iuia­ri­wantran­gi­chi. Paimi nuka­manda ñugpa willarka. ");
INSERT INTO inb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pai librupi willaska sakiskata mana uias­paka, ¿imasatak nuka rima­kuskataka suma iuia­wan­kan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chi­ura­manda, Jesús rirka Gali­lea u Tiberias suti kucha sug ladu chimba. ");
INSERT INTO inb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Achka runa­kuna, paita kati­raiar­ka­kuna, mana alian­ga­sina ungui­kunata suma ambig­ta kawaspa. ");
INSERT INTO inb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesuska, awa lumama sikaspa, kati­raiag­kuna­wan­ta tia­rirka. ");
INSERT INTO inb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judiu­kunapa paskua atun puncha ñami chaia­kurka. ");
INSERT INTO inb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Chi lumapi tia­kus­paka, Jesus­ka tukui­kunata kawarka, chi achka runa­kuna pai­pagma kailla­ia­na­kug­ta. Chasa kawas­paka, Feli­peta tapurka: —¿Maipitak tanda randin­chi, kai tukui runa samu­na­kuskata karan­ga­pa?—. ");
INSERT INTO inb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chasa tapurka, Felipe imasa ai­nigta uian­ga­pa. Jesús kikin alli­lla­mi iacharka, imasa ruran­ga­pa chaia­kugta. ");
INSERT INTO inb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chi­ura, Felipe ainirka: —Iskai patsa puncha ganaska kulki­wa tanda randispa, manachar kai tukui runa­kunata sug sug uchu­lla piti­lla­pas karan­ga­pa pagtantra. ");
INSERT INTO inb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sug paita kati­raiag, Simón Pe­dropa waugki Andrés sutika, nirka: ");
INSERT INTO inb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kaipimi ka sug wam­bra. Pichka sibada tanda i iskai chalwa­mi iuká. Chika, ¿imatak pagtanga, kai tukui achka runa­kunata karan­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesuska nirka: —Tukui­kunata nig­rii­chi, tia­ri­chu­kuna. Suma ugsa chipi tiarka. Mai pichka waranga runa­kuna, chipi tia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chi­ura Jesuska, chi tan­da­kunata chari­rispa, “Pai Siñur” Taita Diusta nirka. Nis­paka, chipi tia­na­kuskata kuaspa richirka. Chalwa­kuna­ta­pas chasa­lla­ta kuaspa richirka. Chi­ura tukui­kuna, masa munaska chaskispa mikur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tukui­kuna ña sagsagta miku­uraka, Jesuska kati­raiag­kunata nirka: —Piti­kuna puchus­ka­kunata tanda­chii­chi, mana sita­na­kuchu. ");
INSERT INTO inb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chasa uias­paka, chi pichka si­ba­da tanda piti piti­kuna puchus­ka­kunata chunga iskai saparu jun­da­mi tanda­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Chi mana ima­ura­pas ruraska­sinata kawas­paka, tukui chipi kag­kuna nir­ka­kuna: —Santu Ispi­ri­tu­wa rimag runa kai alpama samun­ga­pa willa­ra­iaska, kaimi chi runa kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tukuikunami muna­na­kurka, Jesusta apispa, atun mandag chu­ran­ga­pa. Paika, chasa iuia­na­kugta iachas­paka, anchu­rispa, chi awa lumama kutirka, sapalla kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ña chisima ka­uraka, Jesusta kati­raiag­kunaka atun kuchama urai­kur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ña tuta­iaska ka­ura, Jesús manara pai­kuna­pagma chaiag­riska karka. Chi­manda, kanua­pi iai­kus­paka, kucha sug ladu chimba rii kalla­rir­ka­kuna, Kafar­naum pui­bluma chaiag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pai­kuna chimba­na­ku­uraka, iapa sin­chi waira, ata­rispa, iakuta wagta­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pai­kuna ña mai pichka u sugta chunga kuadra­sina iakupi ri­na­ku­ura, Jesús, chi iakupi awalla chaki­wa saruspa saruspa, pai­kuna­pagma kailla­ia­kugta kawar­ka­kuna. Chasa kawas­paka, ajaimi mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesuska nir­ka­kunata: —Nukami kani. Mana mancha­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chasa uias­paka, alli iuia­chi­rispa, paita: —Kanuama samui— nir­ka­kuna. Chasa ni­na­kug­lla­pi, mai­ma ri­na­kuska­ma chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kaiandika, tukui runa­kuna chi kucha sug ladu kag­kuna iuia­rir­ka­kuna, kaina suglla kanua chipi tiaska kagta; Jesusta kati­raiag­kunalla chi kanuapi iai­kuspa rigta­kuna; Jesús chipi pai­kuna­wa manima iai­kuspa rigta. ");
INSERT INTO inb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chi­kama sug­kunaka, Tiberias pui­blu­manda sug kanua­kunapi chi ladumalla chaiag­rir­ka­kuna; mai­pi­mi kikin Iaia Jesús, Taita Diusta: “Pai Siñur” nispa, tanda miku­chirka: chi ladumalla. ");
INSERT INTO inb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Chi­pika, Jesusta ñi paita kati­raiag­kunata manima tarig­rir­ka­kuna. Chasa kawas­paka chi runa­kuna, chi chusa kanua­kunapi iai­kuspa, sug ladu chimba Kafarnaumma maskan­ga­pa rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chaiag­ris­paka, Jesusta tarig­rir­ka­kuna. Nis­paka tapur­ka­kuna: —Iacha­chig taita, ¿ima­uratak kaima chaia­murkangi? ");
INSERT INTO inb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesuska ainirka: —Kasami nuka nii­ki­chita: mana maska­wa­na­kun­gi­chi­chu, ima­ura­pas mana kawaska­sina kam­kunapa ñawipi rurag­manda. Kam­kuna sagsagta mikuska­manda­mi mas­ka­wa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tuku­ri­diru mikui­ta mana maska­na­kui­chi. Mas­kai­chi mana puchuka­ri­diru mikui­ta; chasaka, dil­tudupa kaug­san­ga­pa. Chi mikuita, kai Runa Tukuska­mi kam­kunata karan­ga­pa kai­ki­chita. Chasa­pa­mi Taita Dius kikin nukata aglla­warka. ");
INSERT INTO inb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chi­ura tapur­ka­kuna: —¿Imasatak nukan­chi rura­sun­chi, Taita Dius imasa muna­kuska­sina paita kawa­chin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Chi­ura, Jesuska ainirka: —Pai nukata kacha­mu­wagka, kam­kuna­manda muna­kumi, nuka­manda suma iuia­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chi­ura, Jesusta tapur­ka­kuna: —¿Imasatak nukan­chita kawa­chin­kangi; chasaka, nukan­chi kamta suma iuia­rin­ga­pa? ¿Ima­ura­pas mana kawaska­sina ruraspachu kawa­chin­kangi? ");
INSERT INTO inb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nukan­chipa ñug­pa­manda taita­kuna, chusa sitaska alpapi kaug­sa­na­ku­ura, “maná” suti suma luar­manda mikui­ta­sik miku­dur kar­ka­kuna. Chasa­lla­ta­mi ñugpa­manda li­bru­pi willa­raiá, kasa nispa: “Suma luar­manda tandami mikun­ga­pa kara­murka”. ");
INSERT INTO inb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesuska ainirka: —Kasami nuka nii­ki­chita: Moiseska, chi suma luar­manda tandata mana pai­kunata kara­murkachu. Nuka­pa Taita­mi kai mana wañu­diru tanda kam­kunata suma luar­manda karamú. ");
INSERT INTO inb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi Taita Dius kara­muska tanda ni­raianmi suma luar­manda urai­ku­mug, kai alpa­manda runa­kunata dil­tudupa kaug­sai karan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Taita waugki, ima­ura­pas mana sakispa­lla chi tandata nukan­chita kara­mui— nir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesuska ainirka: —Nukami kani mana wañu­diru tanda. Mai­kan nuka­wa samug­kuna, mana iarkai iukan­ga­pa kan­kuna­chu. Chasa­lla­ta, nukata suma iuia­wag­kuna mana ima­ura­pas iaku­naiai iukan­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Chasa nispa­pas, ñami nirkai­ki­chita: ña nukata kawa­waspa­pas, chara manara suma iuia­wan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tukui nuka­pa Taita aglla­puas­ka­kuna, nuka­wa­mi samun­ga­pa kan­kuna. Mai­kan­pas nuka­wa samus­ka­kunaka, mana kanchama llugsi­chii tukun­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nukaka, suma luar­manda mana urai­ku­murka­nichu, nuka­pa iuiai­lla­wa ima­pas ruran­ga­pa. Imasa kacha­mu­wag muna­kuska­sina ruranga­pa­mi samurkani. ");
INSERT INTO inb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kasa­mi kacha­mu­wag muná: pai agllaska nuka­wa samug­kuna, ñi sug mana nuka­wa chinga­chii tukun­ga­pa. Puchuka­rii punchaka, tukui pai­kunata nuka kaug­sa­chinga­pa­mi muná. ");
INSERT INTO inb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kasa­mi nuka­pa Taita muná: mai­kan­pas pai­pa wam­brata rigsi­waspa suma iuia­wag­kuna, mana puchuka­ri­diru kaug­sai­ta­mi iukan­ga­pa kan­kuna. Pai­kuna­ta­mi, puchuka­rii puncha, nuka kaug­sa­chin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesús niska karka: “Nuka­mi kani suma luar­manda urai­ku­muska tanda”. Chi­manda judiu­kuna, mana alli iuiai­wa pai­manda rima­na­kurka, ");
INSERT INTO inb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","kasa nispa: —Kai runa, ¿manachu ka Josepa wam­bra Jesús? Paipa taita i maman­di­ta­pas, nukan­chi rig­sin­chimi. Nig­pika, ¿ima­wan­tak ni­ku: “Suma luar­manda­mi urai­ku­muska kani”? ");
INSERT INTO inb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesuska nir­ka­kunata: —Kam­kuna­pura jiru iuiai­wa mana rima­na­kui­chi. ");
INSERT INTO inb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nuka­pa Taita kacha­mu­wag mana agllag­pi­ka, ñi pipas mana nuka­wa samun­ga­pa pudin­kuna­chu. Agllas­ka­kuna­lla­ta­mi, puchuka­rii puncha, nuka kaug­sa­chin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Santu Ispi­ri­tu­wa rimag­kuna willa­raiaskapi, kasa­mi ni­raiá: “Tukui­kunata, Dius kikin­mi iacha­chin­ga­pa ka”. Mai­kan­pas nuka­pa Taitata uiaspa, pai imasa iacha­chiska­sina iachai­kug­kuna, nuka­wa­mi samun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Ñi mai­kan, nuka­pa Taitata mana kawaska kan­kuna­chu. Pai­pag­manda samuska kag­lla­mi paita rigsí. ");
INSERT INTO inb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kasa­mi nuka nii­ki­chita: mai­kan­pas suma iuia­wag­kuna, mana puchuka­ri­diru kaug­sai­ta­mi iukan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Nukami kani mana wañu­diru tanda. ");
INSERT INTO inb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kam­kunapa ñugpa­manda taita­kuna, chusa sitaska alpapi “maná” suti mikuita mikus­pa­pas, wañur­ka­kunami. ");
INSERT INTO inb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kai tandami ni­raiá suma luar­manda urai­ku­muska. Mai­kan­pas kai tandata mikug­kuna mana dil­tudupa wañun­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuka­mi kani chi mana wañu­diru tanda suma luar­manda urai­ku­muska. Mai­kan­pas kai tandata mikug­kuna, ima­ura­pas kaug­sa­na­kunga­pag­lla­mi kan­kuna. Chi nuka karan­ga­pa tandaka ni­raianmi nuka kikinpa aicha, kai alpa­manda runa­kuna alli suma kaug­saita iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Chi­ura judiu­kunaka, kikin­pura tapu­ri­na­kurka, kasa nispa: —Kai runa, ¿imasatak paipa aicha­ta karan­ga­pa ka, nukan­chi mikun­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesuska nir­ka­kunata: —Kasami nuka nii­ki­chita: kai Runa Tukuskapa aichata mana mikug­ka, nuka­pa iawarta chasa­lla­ta mana upiag­pika, alli suma kaug­saita mana iukan­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mai­kan­pas, nuka­pa aicha­ta mikuspa, nuka­pa iawarta upiaspa kag­kunaka, mana puchuka­ri­diru suma kaug­sai­ta­mi iukan­kuna. Pai­kuna­ta­mi, puchuka­rii puncha, nuka kaug­sa­chin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nuka­pa aicha kanmi sutipa mikui. Nuka­pa iawarpas, sutipa­mi upia­diru ka. ");
INSERT INTO inb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mai­kan­pas, nuka­pa aichata mikuspa, nuka­pa iawarta upiaspa kag­kuna, nuka­pi­mi kan­kuna. Nuka­pas, pai­kuna­pi­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","—Nukata kacha­mu­wag kaug­sa Taita­manda­mi nuka kaug­sai iukani. Chasa­lla­ta mai­kan­pas nukata miku­wag­kuna, nuka­manda­mi kaug­sai iukan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kai­mi ka suma luar­manda urai­ku­muska tanda. Chi “maná” suti tandata, ñugpa­manda taita­kuna mikuspa­pas wañur­ka­kunami; chi tanda­sina mana kanchu. Kai tandata mai­kan­pas mikus­paka, ima­ura­pas kaug­sa­lla­mi kan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kafarnaum pui­blu­pi­mi Jesús chasa nirka, judiu­kuna tanda­ri­diru wasi ukupi iacha­chi­kuspa. ");
INSERT INTO inb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Achka Jesusta kati­raiag­kuna, chasa uias­paka, nir­ka­kuna: —Chi rimai­kuna, iapa mana uianga­sina­mi ka. ¿Pi­sik chasa uian­ga­pa munanga? ");
INSERT INTO inb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Paita kati­raiag­kuna chasa mana alli iuiai­wa pai­manda rima­na­kuskata iachas­paka, Jesuska nirka: —Chasa uias­paka, ¿nuka­manda mana allichu uiarí? ");
INSERT INTO inb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kai Runa Tu­kus­ka ñugpata kaska­ma, chima­lla­tata sika­kuskata kam­kuna kawas­paka, ¿imasatak iuiantran­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Santu Ispi­ri­tu­lla­mi alli suma kaug­saita kará. Aichaka mana balinchu. Chi rimai­kuna nuka kam­kunata rimaskaka kanmi Ispi­ri­tupi kaug­sai. ");
INSERT INTO inb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Chasa kag­pi­pas, mai­kan­kunaka mana nuka­wa iuia­na­kun­gi­chi­chu—. Ñugpa­manda­ta­mi Jesús iacharka, pi­kuna mana paita iuiag kag­kuna­manda. Chasa­lla­ta, pi paita api­chin­ga­pa kag­ta­pas­mi iacharka. ");
INSERT INTO inb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kasa­pasmi nirka: —Chi­mandami nirkai­ki­chita: “Nuka­pa Taita mana agllag­pika, ñi pipas mana nuka­wa samun­ga­pa pudin­kuna­chu”. ");
INSERT INTO inb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chi­ura­manda paita kati­raiag­kuna, achka­kuna anchu­rispa, mana mas paita katin­ga­pa munar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Chi chunga iskai pai agllas­ka­kunataka, Jesús tapurka: —¿Kam­kuna­paschu muna­na­kun­gi­chi, nukata saki­waspa, rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Chi­ura, Simón Pedroka ai­nirka: —Taita waugki, kamta sakis­pa­ka, ¿pi­watak ri­sun­chi? Kam­lla­mi mana puchuka­ri­diru suma kaug­saita rimag kangi. ");
INSERT INTO inb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nukan­chika, kam­manda suma iuiaspa, ñami iachan­chi, kam Taita Diuspa tukuipi mas alli wam­bra kagta. ");
INSERT INTO inb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesuska nirka: —¿Manachu nuka, chunga iskai­kunata agllarkai­ki­chita? Chasa agllagpi­pas, kam­kuna­pura­manda sugka, iaia kuku­sina­mi ka—. ");
INSERT INTO inb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Chasa nispa, Judas Iska­riote suti Simonpa wam­bra­manda­mi rima­kurka, chi runa, chunga iskai agllas­ka­kuna­pura­manda kaspa, paita api­chin­ga­pa kag­manda. ");
INSERT INTO inb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chi­ura­manda Jesús, Gali­lea alpa suiulla puri­kurka. Mana munarka, Judea alpapi kag­rin­ga­pa, judiu­kuna wañu­chin­ga­pa paita mas­ka­na­kug­manda. ");
INSERT INTO inb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judiu­kunapa sug atun puncha­kuna ña chaia­kurka. Chi puncha­kuna iuia­ri­diru karka, tambu­kuna ruraska­lla­pi kaug­saska. ");
INSERT INTO inb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Chi­manda Jesuspa waug­ki­kunaka, paita nir­ka­kuna: —Kai­manda llugsispa, Judeama rii, chipi kamta kati­raiag­kunata kam ima rura­kuskata kawa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mai­kan­pas rigsi­chi­rin­ga­pa munag­kuna, mana pakalla ruran­kuna­chu. Kam chi­tuku ima­pas­sik alli­lla rurangi; chita tukui­kunapa ñawi­pi kawa­chig­rii—. ");
INSERT INTO inb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ñi kikin Jesus­pa waugkindi­kuna, paita mana iuia­na­kuspa­mi chasa kachan­ga­pa rima­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesuska ainirka: —Nuka rin­ga­pa puncha, mana­ra chaia­puanchu. Ikuti kam­kuna rin­ga­paka, ima­ura­pas alli­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kai alpapi tias­ka­kuna­lla­wa iuiag­kuna, mana kam­kuna­wa rabiai iukan­kuna­chu. Ikuti nuka­ta­mi mana muna­wan­kuna, pai­kuna mana alli­lla rurai­kunata piñaspa rimag­manda. ");
INSERT INTO inb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kam­kunaka rii­chi, chi atun puncha­kuna iali­chin­ga­pa. Nuka rin­ga­pa puncha manara chaia­puag­manda, nukaka manara rin­ga­pa kani—. ");
INSERT INTO inb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chasa nis­paka, Gali­lea alpa­lla­pi chisiarka. ");
INSERT INTO inb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ña paipa waugki­kuna atun puncha­kuna iali­chin­ga­pa riska­ura­mandaka, Jesuspas rirka. Pi­ta­pas mana kawa­rispa­lla paka­lla­mi rirka. ");
INSERT INTO inb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Chi­kama judiu­kunaka, chi puncha­kuna paita maska­na­kuspa, pai­pura tapu­ri­na­kurka: —Chi runa, ¿maipi­sik ka? ");
INSERT INTO inb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chi achka runa­kuna, ajaimi pai­manda rima­na­kurka. Sug­kuna ni­na­kurka: —Iapa allimi ka. Ikuti sug­kunaka ni­na­kurka: —Manima. Tukui runa­kunata llulla­chispa­lla­mi ka—. ");
INSERT INTO inb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Judiu­kunata manchaspa­mi pai­manda alli­lla mana kawa­riglla rima­na­kurka. ");
INSERT INTO inb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chi atun puncha­kuna ña chaugpi iali­ku­uraka, Jesuska, Diuspa atun wasi ukupi iai­kug­rispa, iacha­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Paita uias­paka, judiu­kuna iapa ujna­rispa­mi kikin­pura tapu­ri­na­kurka: —Kai runa, ¿imasa­manda­sik chi­tuku iachá, ñi pi­wapas mana iachai­kuspa­lla? ");
INSERT INTO inb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chi­uraka, Jesuska nirka: —Nuka kikinpa iuiai­lla­wa mana iacha­chi­na­kui­ki­chitachu. Nukata kacha­mu­wagpa iuiai­wa­mi iacha­chi­na­kui­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mai­kan­pas Taita Dius imasa munaska­sina ruran­ga­pa munag iachanga­pa­mi ka, nuka iacha­chi­kuska, Taita Diuspa iuiai­wa kagta. Mana nuka­pa iuiai­lla­wa kanchu. ");
INSERT INTO inb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mai­kan­pas kikinpa iuiai­lla­wa rimag, kikin­manda­lla­mi atun­ia­chi­ringa­pag­lla maskarí. Ikuti kacha­mu­wagta atun­ia­chin­ga­pa munagka, sutipa kaska­ta­mi alli­lla willá, ñi ima­pipas mana llullaspa­lla. ");
INSERT INTO inb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Manachu Moisés, kam­kunapa ñugpa­manda taita­kunata Taita Dius imasa ruran­ga­pa willarka? Chasa willa­raiagpi­pas, ñi pi mana chasa ruran­gi­chi­chu. Nukataka, ¿imapatak wañu­chi­wan­ga­pa muna­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chi­ura, chipi kag­kuna ainir­ka­kuna: —Sug kuku waira iai­kuska­mi kan­gi. ¿Pi­kunatak kamta wañu­chin­ga­pa muna­nakú? ");
INSERT INTO inb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Chi­uraka, Jesuska ainirka: —Nuka sug runata warda pun­cha alia­chiska­manda­mi tukui kam­kuna ujna­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moiseska, kam­kunata kasa ruranga­pa­mi nirka: pusag puncha­iug tukui kari wam­bra­kunata marka chura­chin­gi­chi. Chasa ni­raiagpi­pas, Moisés mana kalla­rig karkachu. Pai­manda mas ñugpa­manda taita­kuna­mi chasa ruran­ga­pa sakiska karka. Pusag puncha iukag­manda­mi, warda puncha kagpi­pas, kam­kuna kari wam­bra­kunata chi marka chura­chin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chasaka, warda puncha kagpi­pas, chi marka chura­chin­gi­chimi, Moisés imasa ni­raiaska­sina iuiaspa. Nig­pika, ¿ima­pa­tak warda puncha sug runata nuka alli­lla alia­chiska­manda, kam­kuna nuka­wa jiru iuia­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mana alli­lla iachas­pa­lla, mana ima­pas rima­na­kun­gi­chi. Maskan­gi­chi, alli­lla iuia­rispa riman­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nig­pika sug­kuna Jeru­salenpi kaug­sa­na­kug, pai­pura tapu­ri­na­kurka: —¿Manachu kai runata wañu­chin­ga­pa maska­nakú? ");
INSERT INTO inb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pai tukui­kunapa ñawipi rima­kugpi­pas, pai­taka mana ima­pas nin­kuna­chu. Nukan­chipa taita­kunaka pai­manda, ¿sutipacha Taita Dius agllaska Cristo kagta sumag­lla iuian­kuna? ");
INSERT INTO inb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nukan­chika, paita alli­lla­mi rigsin­chi mai­manda kagta. Ikuti Taita Dius agllaska runa samun­ga­pa kagtaka, mana pipas iachan­ga­pa kan­kuna­chu mai­manda samu­kugta. ");
INSERT INTO inb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Chasa uias­paka Jesuska, Diuspa atun wasipi iacha­chi­kuspa, sin­chi kapa­rirka, kasa nispa: —¿Sutipachu kam­kuna rigsi­wan­gi­chi? Nuka mai­manda kagta, ¿sutipachu iachan­gi­chi? Nuka­pa iuiai­lla­wa mana samurka­nichu. Nukata kacha­mu­wag, mana ima­pi­pas llulla kanchu. Paitaka, kam­kuna mana rigsin­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nukaka, paita alli­lla­mi rigsini. Pai­pag­manda­mi samuska kani. Pai­mi kacha­mu­warka. ");
INSERT INTO inb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesús chasa ni­ura, muna­na­kurka paita apin­ga­pa. Pai wañun­ga­pa puncha manara chaiaska kag­manda­mi mana pipas paita apii pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Chipi kag­kuna, achka­kuna paita suma iuia­rispa­mi kikin­pura tapu­ri­na­kurka: —Taita Dius agllaska samu­ura, ¿kai runa­manda­pas maschu suma rurai­kuna kawa­chig­samun­ga­pa ka? ");
INSERT INTO inb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fari­seo­kunaka uiar­ka­kuna imasa chipi kag­kuna Jesus­manda iapa rima­na­kugta. Chi­manda pai­kuna i iaia sasir­duti­kuna, alwasil­kunata kachar­ka­kuna, Jesusta apin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Chi­ura, Jesuska nirka: —Kuna­ura­manda, kam­kuna­wa mana unai kan­ga­pa ka­nichu. Nis­paka, nukata kacha­mu­waska­pag­ma­mi rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Chi­ura kam­kuna, nukata maska­waspa­pas, mana tari­wan­ga­pa kan­gi­chi­chu. Nuka maipi kaska­ma, kam­kunaka mana chaiag­rii pudin­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chi­ura judiu­kuna, kikin­pura tapu­ri­na­kurka: —Kai runa, ¿maimatak rin­ga­pa ka; chi­wanka, nukan­chi paita mana tarii pudin­ga­pa? ¿Manachu muna­ku, sug alpa­kunapi judiu­kuna kaug­sa­na­kuska­ma rin­ga­pa; chi­pika, mana judíu kag­kuna­ta­pas iacha­chig­rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Imatak ni­raiá kasa niskata: “Kam­kuna nukata maska­waspa­pas, mana tari­wan­ga­pa kan­gi­chi­chu. Nuka maipi kaska­ma, kam­kunaka mana chaiag­rii pudin­ga­pa kan­gi­chi­chu”? ");
INSERT INTO inb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chi atun puncha­kuna­manda mas atun puncha iali­chin­ga­pa chaia­ura, Jesuska, saia­rispa, sin­chi kapa­rirka, kasa nispa: —Mai­kan­pas Taita Dius­manda iaku­naiai iukag­pika, nuka­wa samui­chi, upiag­sina ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ñugpa­manda librupi, kasa­mi willa­raiá: “Mai­kan­pas nukata suma iuia­wagka, paipa sungu­manda llugsispa, kaug­sa iaku­sina­mi iukan­ga­pa ka”. ");
INSERT INTO inb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús chasa rimaskaka, Santu Ispi­ri­tu­manda­mi ni­kurka. Mai­kan­pas Jesusta suma iuiag­kuna, Santu Ispi­ri­tu­ta­mi chaskin­ga­pa ni­raiarka. Jesusta manara suma atun­ia­chiska kag­manda­mi Santu Ispi­ri­tuta manara kacha­muska karka. ");
INSERT INTO inb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Chasa uia­na­kug, mai­kan­kunaka ni­na­kurka: —Kai runa, sutipami Santu Ispi­ri­tu­wa rimag ka. ");
INSERT INTO inb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sug­kunaka ni­na­kurka: —Kaimi sutipa Taita Dius agllaska kan­ga­pa ka. Ikuti sug­kunaka nir­ka­kuna: —Taita Dius agllaska kag­pika, Gali­lea­manda mana kan­ga­pa kag­ta­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ñugpa­manda li­bru­pi, ¿manachu willa­raiá, David­pa iawar­manda, David kaug­saska Belén pui­blu­manda, Cristo kan­ga­pa kagta? ");
INSERT INTO inb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chasaka, sug rigcha sug rig­cha­mi chipi kag­pura Jesus­manda iuia­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sug­kuna paita apin­ga­pa muna­na­kuspa­pas, ñi pipas mana tupa­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kachaska alwasil­kunaka, iaia sasir­duti­kuna i fari­seo­kuna­pagma kutir­ka­kuna. Chaiag­ri­uraka, pai­kuna tapur­ka­kuna: —¿Imapatak mana Jesusta pusamurkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chi­ura, alwasil­kuna ainir­ka­kuna: —Chasa rimai, ñi mai­kan chi runa­sina mana ima­ura­pas uiaska karkan­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fari­seo­kunaka, pai­kunata nir­ka­kuna: —¿Kam­kuna­paschu, chi llu­llai­wa tuntia­chii tukurkan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Judíu taita­pura i fari­seo­pura, ñi pipas paita mana uian­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Chi ianga runa­kuna, Moisés ima niskata mana iachai­kuspa­mi maldisiska kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chi­ura Nikodemo, fari­seo­lla­ta­ta kaspa, ñugpata Jesusta rima­kuska kagka, nirka: ");
INSERT INTO inb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Moisés ima nukan­chita willa­raiaskapi, ¿manachu kasa ni­raiá: mai­kan runa­ta­pas, pai ima ruraska­manda mana tapu­chispa­lla i uiaspa­lla, mana justi­siai rurai pudi­rinchu? ");
INSERT INTO inb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Chi­ura ainir­ka­kuna: —¿Kam­paschu Gali­lea­manda kan­gi? Ñugpa­manda librupi iachai­kui. Kawan­kangimi, Gali­lea­manda ñi sug Santu Ispi­ri­tu­wa rimag mana llugsin­ga­pa kagta.  ");
INSERT INTO inb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chasa rima­na­kus­paka, tukui­kuna kikin­kunapa wasima rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesuska, Olivos suti lumama rirka. ");
INSERT INTO inb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaiandi tutataka, Dius­pa atun wasima ikuti chaiag­rirka. Chi pui­blupi tukui kaug­sa­na­kug pai­pagma kailla­iag­ri­uraka, tia­rispa, iacha­chii kalla­rir­ka­kuna­ta. ");
INSERT INTO inb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Chasa iacha­chi­ku­uraka, Moisés ima niskata iacha­chig taita­kuna i fari­seo­kunaka, sug kasada warmi sugpa kari­wa api­riskata pai­pagma chaia­chig­rir­ka­kuna. Tukui­kunapa chaugpipi saia­chig­ris­paka, ");
INSERT INTO inb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusta nir­ka­kuna: —Iacha­chig taita, kai warmita sug­pa kari­wa panda­ri­kuska­ta­mi apirkan­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés ima willa­raiaskapi, kasa­mi ni­raiá: “Mai­kan warmipas chasa rura­kugta apispa, rumi­wa piaspa, wañu­chinga­pa­mi ni­raiá”. Kamka, ¿imatak ningi?—. ");
INSERT INTO inb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chasa tapu­na­kurka, pai rimaskata ima­pipas panda­rig­pika, uiaspa, justi­sia­kunata willag­rin­ga­pa. Jesuska, kumu­rispa, maki didu­wa alpapi iskribii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pai­kuna tapui apa­na­ku­uraka, saia­rispa, nir­ka­kunata: —Mai­kan ñi ima­ura­pas mana panda­rispa­lla kaug­sag, kalla­richu, sug rumi aisaspa, ñugpa warmita pian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chasa nis­paka, ikuti ku­mu­rispa, alpapi maki didu­wa iskri­bii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chasa uias­paka, mas ruku­kuna­manda kalla­rispa, tukui­kuna­mi sug sug llugsispa anchu­rir­ka­kuna. Jesusta chi warmi­lla­wa sakir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chi­ura Jesus­ka, saia­rispa, tapurka: —Pani, ¿maipitak kam­manda willag­kuna kan­kuna? ¿Pipas manachu justi­siaspa, kamta wañu­chin­ga­pa nir­ka­kuna? ");
INSERT INTO inb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Chi­ura ainirka: —Taita turi, ñi pipas manima. Chasa aini­ura, Jesuska nirka: —Ñi nuka­pas mana justi­sian­ga­pa niikichu. Riilla. Kuna­ura­manda, mana mas panda­ringi. ");
INSERT INTO inb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Chi­ura­manda Jesús, Diuspa atun wasi ukupi kag­kunata ikuti iacha­chispa, nirka: —Nukami kai alpa­manda runa­kunapa iuiai­kunata puncha­ia­chig kani. Mai­kan­pas nukata kati­ra­ia­wag, mana amsapi­sina purin­ga­pa kanchu. Paipa iuiai­kunata puncha­ia­chii­wa kaspa, alli suma kaug­sai­ta­pas­mi iukan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Chasa uiaspa, fari­seo­kunaka paita nir­ka­kuna: —Kam kikin­manda­lla­mi chasa willa­ri­kungi. Kam ima rimaska willa­kuska, ianga­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesuska ainir­ka­kunata: —Nuka kikin­manda­lla willa­ri­kuska, mana ianga kanchu; sutipa­mi ka. Nuka mai­manda samuska kagta i maima rin­ga­pa kagta, nuka­lla­mi iachani. Ikuti kam­kunaka mana iachan­gi­chi­chu, nuka mai­manda samuska kagta ñi maima rin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kam kikin­kunapa iuiai­lla­wa­mi ima­pas kawan­gi­chi. Ikuti nukaka, mana pi­ta­pas chasa iuia­rispa kawa­nichu. ");
INSERT INTO inb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nuka, mana sapalla ka­nichu. Nuka­pa Taita kacha­mu­wag, nuka­wa­mi ka. Chi­mandaka, mai­kan­ta­pas nuka iuia­rispa kawag­pika, chi iuia­riskaka sutipa­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","—Moisés kam­kuna­manda willa­raiaskapi, kasa­mi ni­raiá: “Iskai runa­kuna chasa­lla­ta willa­na­kug­pika, mana llulla kanchu”. ");
INSERT INTO inb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chasaka, nuka kikin­manda­mi willa­rini. Nuka­pa Taita kacha­mu­wag­pas­mi nuka­manda chasa­lla­ta willag ka. ");
INSERT INTO inb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Chi­ura tapur­ka­kuna: —Kamba taitaka, ¿maipitak ka? Jesuska ainirka: —Kam­kunaka, nukata ñi nuka­pa Taitata mana rigsin­gi­chi­chu. Nukata rigsi­wagka, nuka­pa Taitata rigsig­sina­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Diuspa atun wasi ukupi, kulki chura­dirupi kaspa­mi Jesús chasa iacha­chi­kurka. Paita manara wañun­ga­pa puncha chaian­kama, ñi pipas mana maki churar­ka­kuna, apin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kasa­pasmi Jesús nirka: —Nuka ringa­pa­mi kani. Chi­ura maska­wanga­pa­mi kan­gi­chi. Mas­ka­wa­na­kuspa­pas, kam­kuna panda­ris­ka­kunata mana pasin­siai tukuspa­lla­mi wañun­ga­pa kan­gi­chi. Nuka maima rin­ga­pa kaska­ma, kam­kuna manima kati­wan­ga­pa pudin­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Chi­ura judiu­kunaka, kikin­pura tapu­ri­na­kurka: —¿Imatak? ¿Kikinllachu wañu­chi­rin­ga­pa iuia­ku? ¿Chi­mandachu ni­ku: “Nuka maima rin­ga­pa kaska­ma, kam­kuna manima kati­wan­ga­pa pudin­ga­pa kan­gi­chi­chu”? ");
INSERT INTO inb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesuska nirka: —Kam­kuna, kai alpa­manda­lla­mi kan­gi­chi. Ikuti nukaka, awa suma luar­manda­mi kani. Kam­kuna, kai alpa­manda­mi kan­gi­chi. Nukaka, manima. ");
INSERT INTO inb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nirkai­ki­chitami: “Kam­kuna panda­ris­ka­kunata mana pasin­siai tukuspa­lla­mi wañun­ga­pa kan­gi­chi”. Nuka pi kagta mana iuia­waspa­mi kam­kuna panda­ris­ka­kunata mana pasin­siai tukuspa­lla wañun­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Chi­ura tapur­ka­kuna: —Kam, ¿pitak kangi? Chi­ura, Jesuska ainirka: —Ñugpa­mandatami nuka ña kam­kunata willarkai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kam­kuna­mandaka iuka­nimi achka rimanga; chasa­lla­ta, kam­kuna achka panda­ris­ka­kunata iuia­chispa kawa­chin­ga­pa. Nukata kacha­mu­wagka, ñi imapi mana llullaspa­lla­mi rimá. Imasa paita uiaska­sina­mi nuka kai alpapi kaug­sa­na­kuskata rimai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Chasa uiag­kuna mana iachar­ka­kuna, Jesuska paipa Taita Dius­manda rima­kugta. ");
INSERT INTO inb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chi­manda, paika nirka: —Kai Runa Tukuskata kam­kuna awapi atari­chi­waspa­mi rig­si­wan­ga­pa kan­gi­chi nuka pi kagta. Chasa­lla­ta, nuka kikinpa iuiai­lla­wa mana ima­pas rura­nichu. Ima nuka­pa Taita iacha­chi­waska­ta­mi rimani. ");
INSERT INTO inb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nukata kacha­mu­wag, nuka­wa­mi ka. Pai imasa muna­kuska­sina­mi nuka ima­ura­pas rurani. Chi­manda­mi mana sapa­lla­ta sakiwá. ");
INSERT INTO inb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús chasa rimaskata uiag­kuna, achka­kuna­mi pai­wa suma iuia­rispa tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Chi­ura Jesuska, pai­wa suma iuia­rig judiu­kunata nirka: —Kam­kuna, nuka ima rimas­kata ima­ura­pas ruragpi­kunaka, sutipa­mi nuka­pa iachai­kug­kuna kan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sutipa kaska­ta­mi rigsin­kan­gi­chi. Sutipa kaskata rigsis­paka, kispi­chiimi tukun­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chi­ura nir­ka­kuna: —Nukan­chika kanchimi ñugpa taita Abra­hampa wam­brapa wam­bra­kuna. Ima­ura­pas ñi mai­kan runa­kuna­pagma mana wataska­sina kaska kan­chi­chu. Nig­pika, ¿ima­pa­tak kamka ni­kungi: “Kispi­chiimi tukun­kan­gi­chi”? ");
INSERT INTO inb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Chi­ura, Jesuska ainirka: —Kasami nuka nii­ki­chita: mai­kan­pas panda­richu: chi panda­rii­kuna­waka wataska­sina­mi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Lutrin, mana patrunpa wam­bra­sina chi­lla­pi kaug­sa­kun­ga­pa ni­raianchu. Patrunpa wam­brami ima­ura­pas chi­lla­pi kan­ga­pa ni­raiá. ");
INSERT INTO inb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chi­wanka, Taita Diuspa wam­bra kam­kunata kispi­chig­pika, sutipa­mi kispi­chiska tukun­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iacha­nimi, kam­kuna Abra­hampa wam­brapa wam­bra­kuna kagta­kuna. Chasa kagpi­pas, nuka­pa rimaita mana uia­warkan­gi­chi­chu. Chi nispa­mi kam­kuna muna­na­kun­gi­chi wañu­chi­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nuka­pa Taita imasa kawa­chi­waska­ta­mi rimani. Kam­kuna­pas chasa­lla­ta­mi kam­kunapa taitata imasa uiaska­sina ruran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chi­ura, pai­kuna ainir­ka­kuna: —Nukan­chipa atun taita, Abra­ham­mi ka. Jesuska nirka: —Kam­kuna, sutipa Abra­hampa wam­brapa kati wam­bra­kuna kagpi­kunaka, Abra­ham imasa ruraska­sina­mi rurantran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ikuti kuna­uraka, nuka imasa Taita Diusta uiaska­sina sutipa kaskata rima­kug­ta­mi wañu­chi­wan­ga­pa muna­na­kun­gi­chi. Chasaka, Abra­ham mana rurarkachu. ");
INSERT INTO inb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kam­kunapa taita imasa ruraska­sina­mi kam­kuna­pas rura­na­kun­gi­chi. Chi­ura nir­ka­kuna: —Nukan­chi mana kan­chi­chu sapalla warmipa wam­bra­kuna. Dius­mi ka nukan­chipa taita. ");
INSERT INTO inb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesuska nirka: —Dius kam­kunapa taita kag­pika, nuka­ta­mi kuia­wantran­gi­chi. Nukaka, Taita Dius­pag­manda llugsispa­mi samurkani. Nuka kikinpa iuiai­lla­wa mana samurka­nichu. Taita Dius­lla­ta­ta­mi nukata kacha­mu­warka. ");
INSERT INTO inb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ima­wan­tak nuka ima rima­kuskata mana iachai­kun­ga­pa munan­gi­chi? Mana munan­gi­chi­chu, nuka ima willa­kuskata uia­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kam­kuna, iaia kuku­ta­mi taita­sina iukan­gi­chi. Imasa pai muna­kuska­sina­mi kam­kuna ruraspa kan­gi­chi. Paika, ñugpa­manda­ta wañu­chigmi ni­raiá. Paipa iuiaipi llullalla tiag­manda­mi manima sutipa kaskata rimag ka. Pai rima­ura, tukuipi kikinpa llullai­lla­mi rimá. Pai, llulla­chig kaspa, tukui llulla­kunapa taita­mi ni­raiá. ");
INSERT INTO inb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ikuti nukaka, kam­kunata ñi imapi mana llullaspa­lla willa­kugtaka mana muna­wan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ñi pipas mana nukata kawa­chi­wan­ga­pa pudin­gi­chi­chu, ima­pipas panda­rig kagta. Nuka ñi imapi mana llullaspa­lla ni­kug­pika, ¿imapatak mana nuka­wa iuia­rin­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diuspa kag­pika, Taita Diuspa rimai­kuna­ta­mi uiá. Kam­kuna, mana Diuspa kaspa­mi mana paipa rimai­kunata uian­ga­pa munan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Chi­ura, judiu­kuna nir­ka­kuna: —¿Manachu nukan­chi alli­lla nin­chi: “Kam, Sama­ria alpa­manda­mi kangi. Kuku waira iai­kuska­mi kangi”? ");
INSERT INTO inb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesuska ainirka: —Nuka mana kuku waira iai­kuska ka­nichu. Nuka­pa Taita­manda ima­pipas alli­lla­mi rimani. Kam­kunaka, mana alli­lla iuia­rispa­mi jiru nuka­manda riman­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nuka kikin­manda mana maska­ku­nichu, iapa atun­ia­chi­rii tukun­ga­pa. Sugmi nukata atun­ia­chi­wan­ga­pa ka. Paimi sutipa kaskata tukuipi kawag ka. ");
INSERT INTO inb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kasa­pas­mi nuka nii­ki­chita: mai­kan­pas nuka­pa rimaita uiaspa rurag, mana ima­ura­pas wañun­ga­pa kanchu. ");
INSERT INTO inb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Chi­ura, judiu­kuna nir­ka­kuna: —Kuna­ura masmi iachan­chi, kam kuku waira iai­kuska kagta. Abra­ham i Santu Ispi­ri­tu­wa ñugpa­manda rimag­kuna­pas wañur­ka­kunami. Kamka ningimi: “Mai­kan­pas nuka­pa rimaita uiaspa rurag, mana ima­ura­pas wañun­ga­pa kanchu”. ");
INSERT INTO inb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nukan­chipa wañuska taita Abra­ham­manda­pas, ¿maschu atun kangi? Santu Ispi­ri­tu­wa ñugpa­manda rimag­kuna­pas­mi chasa­lla­ta wañur­ka­kuna. Kamka, ¿ima kagtatak iuia­kungi? ");
INSERT INTO inb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chi­ura, Jesuska ainirka: —Nuka kikin atun­ia­chi­riika, ñi imapa mana balinchu. Nuka­pa Taita­mi nukata suma atun­ia­chiwá. Pai­manda­lla­tata, ¿manachu kam­kuna­pas nin­gi­chi: “Nuka­pa Taita Dius­mi ka”? ");
INSERT INTO inb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Paita, kam­kuna mana rigsin­gi­chi­chu. Ikuti nukaka, paita alli­lla­mi rigsini. “Paita mana rigsi­nichu” nuka nig­pika, kam­kuna­sina llulla­lla­ta­ta­mi kantrani. Nuka, paita alli­lla­mi rigsini. Chasa rigsis­paka, paipa rimaita uiaspa, rurag­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","—Kasapas. Kam­kunapa atun taita Abra­hamta alli iuia­chi­rirka, nuka samun­ga­pa puncha paipa suma iuiai­lla­pi kawaspa. Chasa kawas­paka, iapa kun­tin­ta­rirka. ");
INSERT INTO inb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Chi­ura, judiu­kuna nir­ka­kuna: —Kam, manara pichka chunga wata­lla­pas iukas­paka, ¿ima­wan­tak ningi, Abra­hamta kawaska? ");
INSERT INTO inb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Chasa ni­ura, Jesuska ainirka: —Kasami nuka nii­ki­chita: Abra­ham manara tiagpita, nukaka ñami tiarkani. ");
INSERT INTO inb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chasa ai­nig­mandaka, rumi aisar­ka­kuna, piaspa wañu­chin­ga­pa. Jesuska, chipi kag­kuna­wa chapu­rispa, pakalla Diuspa atun wasi­manda llugsirka. ");
INSERT INTO inb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús iali­kus­paka, sug runa wawita tiag­samuska­ura­manda­ta mana ñawi kawag­ta­mi kawarka. ");
INSERT INTO inb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Chi runata kawas­paka, Jesusta kati­raiag­kunaka tapur­ka­kuna: —Iacha­chig taita, ¿ima­wan­tak kai runa, mana ñawi kawag tiag­samurka? ¿Paichu imapi mana alli­lla rurarka? Mana kag­pika, ¿paipa atun­kuna­chu imapi panda­rir­ka­kuna? ");
INSERT INTO inb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chi­ura, Jesuska ainirka: —Chasa tiag­samuska­manda, mana tukurkachu pai ñi paipa atun­kuna mana alli­llata rurag­manda. Taita Dius kikinmi chasa sakirka; chi­wanka, paipa iapa iachaita kai runa­wa kawa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Chara puncha­sina kag­lla­pi­mi nukata chaiawá, kacha­mu­wag imasa ni­waska­sina ruran­ga­pa. Ña tuta­sina tuku­uraka, ñi pipas mana ima­pas ruran­ga­pa pudi­rin­ga­pa kanchu. ");
INSERT INTO inb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nuka, kai alpapi kan­kama, kai alpapi kaug­sa­na­kuskapa iuiai­kunata puncha­ia­chig­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chasa nis­paka, alpapi tukaspa, turuia­chispa, mana kawag ñawita kakurka. ");
INSERT INTO inb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Chasa llun­chis­paka, nirka: —Siloé suti kuchaia­chiska iakupi mailla­rig­rii—. (Siloé ni­raian­mi “Kachaska”.) Chi­ura, chi runaka rirka. Mailla­rig­rig­lla­pika, alli­lla­mi ñawi kawag­samurka. Nis­paka, pai­pagma rirka. ");
INSERT INTO inb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Paipa ladu suiu kaug­sag­kuna i chi runa limusna mañaspa ñugpa kaskata rigsig­kuna, paita kawas­paka, tapu­ri­na­kurka: —Kai runa, ¿manachu ka limusna mañaspa­lla tia­kug? ");
INSERT INTO inb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sug­kuna aini­na­kurka: —Paimi ka. Ikuti sug­kuna ni­na­kurka: —Manima. Ñalla pai­sina rig­cha­mi ka. Chi runaka nikurka: —Aja, nukami kani. ");
INSERT INTO inb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Chi­ura tapur­ka­kuna: —Nigpika, ¿ima­wan­tak ñawi aliaska kangi? ");
INSERT INTO inb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Chasa tapu­ura, chi runaka ainirka: —Jesús suti runami, alpata tuka­wa turuia­chispa, nuka­pa ñawita kaku­waspa, ni­warka: “Rii. Siloé iakupi mailla­rig­rii”. Nuka mailla­rig­ris­paka, musug­lla­mi ñawi kawag­samurkani. ");
INSERT INTO inb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chi­ura tapur­ka­kuna: —Chi runaka, ¿maipitak ka? Chi runaka ainirka: —Mana iachanichu. ");
INSERT INTO inb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chi­ura, chi runata fari­seo­kuna­pagma pusar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Warda punchami Jesús, chasa alpata tuka­wa turuia­chispa, ñawita kakurka, pai kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chi­manda fari­seo­kuna, chi runata tapu­chir­ka­kuna: —¿Imasa­mandatak alli­lla ñawi kawa­kungi? Chi­ura ainirka: —Alpata tuka­wa turuia­chispa, nuka­pa ñawipi chura­warka. Nuka­ka mailla­rig­rirkani. Chi­ura­lla­mi kawa­ri­warka. ");
INSERT INTO inb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Chasa aini­ura, sug fari­seo­kuna nir­ka­kuna: —Chi alia­chig runa warda pun­cha mana samaspa­lla trabajag, mana Taita Dius kacha­muska kan­ga­pa kanchu. Ikuti sug­kunaka ni­na­kurka: —Panda­ri­dur­lla­tata runa kas­pa­ka, ¿ima­wan­tak chasa mana ima­ura­pas kawaska­sina suma ruran­ga­pa pudí? Chasa rima­na­kus­paka, iskaima tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Chi­manda, ikuti chi ñawi ambi­riskata tapu­chir­ka­kuna: —Chi runa kamba ñawita alia­chiska­manda, kamka, ¿imatak ningi? Chi­ura ainirka: —Paika, sutipa Santu Ispi­ri­tu­wa rimag­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Chi judiu­kunaka mana iuia­na­kurka, pai mana ñawi kawag kaspa, ña alia­chiska kagta. Chi­manda­mi paipa atun­kunata kaiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nis­paka tapu­chir­ka­kuna: —¿Kaichu ka kam­kunapa wam­bra? ¿Pai­mandachu nin­gi­chi: paimi mana ñawi kawag tiag­samurka? ¿Imasa­manda­tak kuna­ura kawa­ku? ");
INSERT INTO inb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Chi­ura, atun­kunaka ainir­ka­kuna: —Nukan­chi iachan­chimi, paika nukan­chipa wam­bra kagta. Mana ñawi kawagmi tiag­samurka. ");
INSERT INTO inb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Chasa kuna­ura kawag­samugtaka mana iachan­chi­chu: ¿pimi ñawita kawa­chig­samurka? Kikinta tapu­chii­chi. Ñami wiñaska ka. Pai kikin­mi willanga. ");
INSERT INTO inb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judiu­kuna, ñugpa rima­na­kuska kar­ka­kuna: “Mai­kan­pas ‘Jesús, Taita Dius agllaska­mi ka’ nigpi­kunaka, judiu­kuna tanda­ri­diru wasi­kuna­manda llugsi­chiimi tukun­ga­pa kan­kuna”. Chasa llugsi­chii ni­raiag­manda­mi chi runapa atun­kuna judiu­kunata manchar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chi­manda­mi ainir­ka­kuna: “Ñami wiñaska ka. Kikinta tapu­chii­chi”. ");
INSERT INTO inb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nigpika, chi ñawi ambi­riskata ikuti kaiaspa, nir­ka­kuna: —Diuspa ñawipi, nukan­chita sutipa kaska­lla­ta willa­rii. Nukan­chi iachan­chimi, chi runa mana alli rura­dur kagta. ");
INSERT INTO inb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Chasa ni­ura, paika ainirka: —Pai mana alli rura­dur kagta mana iacha­nichu. Kasa­lla­mi iacha­ni: nuka, ñugpata mana ñawi kawag kaspa, kuna­uraka alli­lla­mi kawani. ");
INSERT INTO inb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chi­ura, ikuti tapu­chir­ka­kuna: —¿Imatak kamta rurarka? ¿Imasatak ñawi alia­chirka? ");
INSERT INTO inb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Paika ainirka: —Timpumi willarkai­ki­chita. ¿Mana­chu uia­warkan­gi­chi? ¿Ima­pa­tak ikuti uia­wan­ga­pa muna­na­kun­gi­chi? ¿Kam­kuna­pas­char paita kati­raiag­kuna tukun­ga­pa muna­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chi­ura, paita kamispa, nir­ka­kuna: —Kam, chita kati­raiagchar kan­gi. Ikuti nukan­chika, Moisés ima iacha­chiskata kati­raiag­kuna­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Taita Dius Moisesta rimaska­ta­mi nukan­chi alli­lla iachan­chi. Chi kamta alia­chig­mandaka, nukan­chi mana iachan­chi­chu mai­manda samuska kagta. ");
INSERT INTO inb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chi runaka ainirka: —Nuka­pa ñawita alia­chig mai­manda samuska kagta kam­kuna mana iachagpi­kunaka, ujna­chi­wa­na­kun­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ñami iachan­chi, kai alpapi mana alli­lla rurag­kunata, Taita Dius mana uianchu. Ikuti mai­kan paita suma kuiaspa, pai ima muna­kuskata rurag­kunataka uian­llami. ");
INSERT INTO inb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kai alpapi runa­kuna tiaska­ura­manda­ta, ñi ima­ura­pas mana uia­riska kanchu, mai­kan­pas mana ñawi kawag tiag­samuska kaskata alia­chiska­manda. ");
INSERT INTO inb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chi runa, Taita Dius mana kacha­muska kag­pika, ñi ima­pas manachar chasa ruran­ga­pa pudintra. ");
INSERT INTO inb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pai­kunaka nir­ka­kuna: —Kam, tiag­samuska­ura­manda­ta panda­ri­dur­mi kangi. ¿Kuna­ura­chu tinlla kam nukan­chita iacha­chin­ga­pa muna­kungi?—. Chasa nis­paka, paita chi­manda llugsi­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chasa iachas­paka Jesuska, chi llugsi­chii tukuska runa­wa kawa­na­kuspa, nirka: —Kai Runa Tukuska­manda, kam, ¿sumachu iuiangi? ");
INSERT INTO inb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chi­ura ainirka: —Taita waugki, ni­wai: ¿pitak ka, nuka pai­manda suma iuian­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chi­ura, Jesuska nirka: —Kamwa rimakug, nuka­mi kani. Pai­ta­mi kawa­kungi. ");
INSERT INTO inb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chasa ni­ura, chi runaka nirka: —Kam taita waugki­ta­mi suma iuia­kuiki—. Chasa nispa, paita kungu­rirka. ");
INSERT INTO inb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chi­ura Jesuska, chipi kag­kunata nirka: —Nuka, kai alpama samur­ka­nimi, runa­kunata iuia­chispa kawa­chin­ga­pa; chi­wanka, suma iuia­wagpi­kuna, mana kawas­pa­pas, ñawi kawag­sina tukun­ga­pa; ikuti mana suma iuia­wagpi­kunaka, kawaspa­pas, mana ñawi kawag­sina tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Chasa uias­paka sug fari­seo­kuna, pai­wa sug­lla­pi kaspa, tapur­ka­kuna: —¿Nukan­chi­paschu mana kawag­sina kan­chi? ");
INSERT INTO inb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chasa tapu­ura, Jesuska ainirka: —Kam­kuna, sutipa mana kawa­na­kuska­sina kag­pika, manachar ñi ima panda­riipas iukantran­gi­chi. Kuna­uraka nin­gi­chimi: “Nukan­chika, tukui alli­lla­mi kawan­chi”. Chi­manda­mi kam­kuna iapa panda­rii­kuna iukan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kasa­pasmi Jesús nirka: —Kasami nuka nii­ki­chita: mai­kan­pas, ubija­kunapa kinchaska punguta iai­kunga­taka, kincha awa­ta iai­kug­pika, sisai u chapaspa wañu­chig­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pungu tiaskata iai­kugmi ubija­kunata alli­lla kawag ka. ");
INSERT INTO inb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pai­ta­mi punguta kawag iai­ku­chí. Paipa rimaita, ubija­kuna­pas­mi rigsin­kuna. Pai kikinpa ubija­kuna­ta, sug sug imasa suti kaska­sina kaiaspa­mi chi­manda llugsi­chí. ");
INSERT INTO inb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tukui paipa ubija­kunata llugsi­chis­paka, pai kikinmi ñugpan­kunata. Chi ubija­kunaka, paipa rimai­ta rigsispa, kati­chin­kuna­lla­mi. ");
INSERT INTO inb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ikuti mana rigsiskataka mana kati­chin­kuna­chu. Sugpa rimaita mana rigsis­paka, miti­kun­kuna­lla­mi. ");
INSERT INTO inb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús chasa iuiai apinga­sina parla­kugpi­pas, chipi kag­kuna mana iachar­ka­kuna ima­manda chasa rima­kugta. ");
INSERT INTO inb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Chi­manda Jesús, ikuti nirka: —Kasami nuka nii­ki­chita: nukami ubija­kunapa iaikun­ga­pa pungu­sina kani. ");
INSERT INTO inb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nuka­pa ñugpa samug­kuna­mi kar­ka­kuna sisai u chapaspa wañu­chig­sina rurag­kuna. Ikuti Taita Diuspa ubija­sina kag­kunaka, mana pai­kunata uiar­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","—Nukami pungu­sina kani. Mai­kan­pas nuka­wa iai­kugka, kispi­chiimi tukun­ga­pa kan­kuna; imasa­mi ubija­kuna, mana man­chas­pa­lla llugsispa, iai­kuspa, alli ugsa mikuspa kan­kuna: chasa. ");
INSERT INTO inb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sisai­kunaka samun­kunami, sisan­ga­pa, wañu­chin­ga­pa i tukui puchukan­ga­pa. Ikuti nukaka samurka­nimi, kam­kuna mas iapa suma kaug­saita iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Nukami kani ubija­kuna­sina alma­kunata alli­lla suma kawag. Sutipa alli­lla suma ubija­kunata kawag, wañun­ga­pa chaiagpi­pas saki­rinmi. ");
INSERT INTO inb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ikuti mai­kan kulki gananga­pag­lla kawagka, sacha alku samukugta kawas­paka, ubija­kunata sakispa miti­kun­lla­mi, paipa ubija­kuna mana kag­manda. Chi­ura sacha alku, sug ubija­kunata mikug­rí; sug­kunataka miti­ku­chí. ");
INSERT INTO inb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chi kulki gananga­pag­lla iuiai­wa kaspa­mi ubija­kuna­manda ñi ima mana llakí. ");
INSERT INTO inb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","—Nukami kani ubija­kuna­sina alma­kunata alli­lla suma kawag. Nuka­pa­kunata rigsi­nimi. Pai­kuna­pas, nukata rigsi­wan­kunami. ");
INSERT INTO inb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Cha­sa­lla­ta, nuka­pa Taita rigsiwá. Nuka­pas, nuka­pa Taitata rigsi­nimi. Nuka­pa ubija­sina­kuna­manda wañun­ga­pa chaia­wagpi­pas, saki­ringa­pa­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","—Sug ubija­sina­kuna­pas­mi iukani, mana kai kural­manda. Pai­kuna­ta­pas­mi chaia­wa­ku, nuka­pag­ma kaian­ga­pa. Pai­kuna­pas, nuka­pa rimaita rigsi­wanga­pa­mi kan­kuna. Chasaka, tukui­kuna­mi sug­lla­pi tukun­ga­pa kan­kuna. Nuka kikinmi tukui­kunata suglla alli­lla suma kawag kan­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Nuka­pa kaug­saita karan­ga­pa­mi kani, wañu­chii tukun­ga­pa. Nis­paka, ikuti­mi kaugsa­rin­ga­pa kani. Chi­manda­mi nuka­pa Taita kuiawá. ");
INSERT INTO inb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ñi pipas mana nuka­pa kaug­saita kichu­wan­ga­pa kanchu. Nuka kikin­lla­mi karan­ga­pa kani, wañu­chii tukun­ga­pa. Nuka kikin karan­ga­pa pudi­nimi, wañu­chii tukun­ga­pa. Chasa­lla­ta, nuka kikin pudi­nimi ikuti kaugsa­rin­ga­pa. Chasa­mi nuka­pa Taita pasan­ga­pa kacha­mu­warka. ");
INSERT INTO inb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús chasa rima­kuskata uias­paka, judiu­kunaka ikuti iskaima tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Achka­kuna ni­na­kurka: —Pai, kuku waira iai­kuska­mi ka. Upa tukuska­mi ka. ¿Imapatak chara uia­na­ku­sun­chi? ");
INSERT INTO inb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ikuti sug­kunaka ni­na­kurka: —Kuku waira iai­kuskaka, mana­char chasa rima­kuntra. Kuku waira iai­kuska kag­pika, manachar pudintra, mana ñawi kawag­kunata ambin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chi­ura­manda judiu­kuna, sug atun puncha Jeru­salenpi iali­chi­na­kurka; Diuspa atun wasita mana judíu kag­kuna jiru ruras­ka­kunata anchu­chig­sina iuia­rispa, chasaka, ikuti sumag­lla alli­lla tukun­ga­pa. Tamia puncha­kuna­mi karka. ");
INSERT INTO inb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chi wasi ukupi, Salomonpa suti kaska kancha­pi­mi Jesús puri­ri­kurka. ");
INSERT INTO inb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Chi­ura judiu­kunaka, paita muiu­chispa, tapur­ka­kuna: —¿Ima­ura­kamatak nukan­chita chari­kun­kangi, kam­manda mana iachaspa­lla kan­ga­pa? Kam kikin Cristo kag­pika, nukan­chita willa­rii. ");
INSERT INTO inb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesuska ainirka: —Ñami willarkai­ki­chita. Mana uia­warkan­gi­chi­chu. Nuka­pa Taita imasa ruran­ga­pa kacha­mu­waska­sina ruras­ka­kuna­mi nuka­manda willa­ku. ");
INSERT INTO inb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kam­kuna mana uia­wan­gi­chi­chu, mana nuka­pa ubija­sina­kuna kaspa. ");
INSERT INTO inb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikuti nuka­pa ubija­sina kag­kuna, nuka­pa rimai­ta­mi uia­wan­kuna. Nuka­pas, pai­kunata alli­lla­mi rigsini. Pai­kuna, nuka­ta­mi kati­chi­wan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nukaka, pai­kunata mana puchuka­ri­diru suma kaug­sai­ta­mi karani. Chi kaug­sai iukas­paka, ñi ima­ura­pas mana puchuka­rin­ga­pa kan­kuna­chu. Ñi pipas nuka­pa maki­manda mana pai­kunata kichu­wan­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nuka­pa Taita, tukui­kuna­manda mas atun­mi ka. Paimi nuka­pa makipi pai­kunata saki­warka. Paipa maki­mandaka, ñi pipas mana pai­kunata kichui pudin­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nukaka, nuka­pa Taita­wa sug­lla­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesús chasa ni­uraka, judiu­kuna ikuti rumi aisar­ka­kuna, piaspa wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Paika nirka: —Nuka­pa Taita imasa muna­kus­ka­sina ruraspa­mi kawa­chirkai­ki­chita, nuka achka alli­lla ruragta. ¿Mai­kan alli­lla ruraska­manda­tak nukata rumi­wa wañu­chi­wan­ga­pa muna­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chi­ura, judiu­kuna ainir­ka­kuna: —Chi alli­lla ruras­ka­kuna­mandaka mana kamta rumi­wa wañu­chin­ga­pa muna­na­kun­chi­chu. Kam ianga runa kaspa, Taita Dius­sina tukuspa, jiru llullaspa niska­manda­mi wañu­chin­ga­pa kan­chi. ");
INSERT INTO inb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesuska nirka: —Moisés ima kam­kuna­manda ruran­ga­pa ni­raiaskapi, ¿manachu kasa willa­raiá: “Nii­ki­chitami: ‘Taita Dius­sina­mi kan­gi­chi’?”. ");
INSERT INTO inb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chasaka, Diuspa Rimaita uiag­kuna­mi Taita Dius­sina kan­kuna. Kasapas. Ñugpa­manda librupi willa­raiaskaka, ñi ima mana llullanchu. ");
INSERT INTO inb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nukataka, Taita Dius kikin aglla­waska­manda­mi kai alpama kacha­mu­waska samurkani. Nuka: “Taita Diuspa wam­bra­mi kani” nig­mandaka, ¿imapatak ni­wa­na­kun­gi­chi: “Taita Dius­sina tukuspa, jiru llullaspa­mi ni­kungi”? ");
INSERT INTO inb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nuka­pa Taita imasa muna­kuska­sina nuka mana rurag­pika, mana nuka­wa iuia­wai­chi. ");
INSERT INTO inb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ikuti nuka­pa Taita imasa muna­kuska­sina rurag­pika, kam­kuna, mana nuka rimas­kata iuia­waspa­pas, chi nuka alli­lla ruras­ka­kunata kawaspa, suma iuia­wai­chi. Chasa iuia­was­paka, iachan­kan­gi­chimi nuka­pa Taita nuka­wa kagta i nuka­pas nuka­pa Taita­wa suglla kagta. ");
INSERT INTO inb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chasa uias­paka judiu­kunaka, ikuti Jesusta apin­ga­pa muna­na­kurka. Paika, pai­kunapa maki­manda llugsispa, miti­kurka. ");
INSERT INTO inb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Chi­manda, Jor­dán iaku sug ladu chimba, Juan ñugpata baug­ti­sa­diru kaska­ma ikuti rirka. Chi­pika, sug puncha­kuna chisiag­rirka. ");
INSERT INTO inb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Chi­ura achka runa­kuna, pai­pagma chaiag­rispa, ni­na­kurka: —Juanka, ñi ima kawa­chiipas mana rurarkachu. Ikuti tukui ima kai runa­manda willaskaka, sutipa­mi chasa tuku­ku—. ");
INSERT INTO inb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chasa nis­pa­ka, achka runa­kuna­mi chipi Jesusta suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania pui­blupi, Lázaro suti runa ungui­wa ña wañu­kurka. Chi runapa pani­kuna, María i Marta suti­kuna, sug­lla­pi kaug­sa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chi Maria­mi karka Iaia Jesusta suma asna asiti­wa tallispa, paipa chaki­kunata kikin­pa agcha­wa tusta­chig. Chi Mariapa turi Laza­ro­mi wañu­kurka. ");
INSERT INTO inb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chi pani­kunaka, Jesus­pagma kachar­ka­kuna, kasa nin­ga­pa: —Taita turi, kamba kuiaska Lázaro, iapa ungug­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Chasa uias­paka, Jesuska nirka: —Chi ungui­wa mana wañun­ga­pa ni­raianchu. Taita Diusta suma atun­ia­chinga­pa­mi ungug ka. Chi ungui­waka Taita Diuspa wam­bra­ta­pas­mi suma atun­ia­chii tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús, Martata, ñañandita i Laza­rota iapa­mi kuiarka. ");
INSERT INTO inb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Chasa ku­ias­pa­pas, Lázaro ungug kagta iachaspa, chara iskai punchami unaiarka. ");
INSERT INTO inb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chi­ura­mandaka, paita kati­raiag­kunata nirka: —Ikuti Judea alpama ri­sun­chi. ");
INSERT INTO inb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Paita kati­raiag­kunaka nir­ka­kuna: —Iacha­chig taita, mana iapa unai ka, kamta judiu­kuna rumi­wa wañu­chin­ga­pa muna­na­kugta. ¿Imapatak ikuti chima rin­ga­pa muna­kungi? ");
INSERT INTO inb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesuska ainir­ka­kunata: —Mana mancha­na­kui­chi. Pun­cha, ¿manachu chunga iskai ura iuká? Punchapi purig, kai alpata puncha­ia­chigwa kas­paka, ¿ima­sa­tak taka­riipa? ");
INSERT INTO inb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ikuti mai­kan tutapi puri­kugka taka­ringa­mi, kikin mana puncha­ia­chigwa puri­kuspa. ");
INSERT INTO inb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chasa nis­paka, kasa­pas­mi nirka: —Nukan­chipa kuiaska Lázaro, ñami puñu­rirka. Paita nuka rig­cha­chinga­pa­mi rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Chi­ura, kati­raiag­kuna nir­ka­kuna: —Taita waugki, pai puñu­riska kag­pika, ñachar askaia­ku. ");
INSERT INTO inb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesuska, Lazaro­manda ni­kur­ka: “Puñu­kumi”, sutipa wa­ñus­ka kag­manda. Ikuti kati­raiag­kunaka iuia­na­kurka: “La­za­roka, sutipachar puñuilla puñu­ku”. ");
INSERT INTO inb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Chasa iuia­na­kug­manda, Jesuska mana pakaspa­lla­mi nir­ka­kunata: —Sutipa­mi Lázaro wañuska ka. ");
INSERT INTO inb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nuka mana chipi kag­riska­manda, kam­kuna­manda­mi kun­tin­ta­riwá. Chipi kam­kuna, nuka ima ruras­ka­ta kawas­paka, suma­mi iuia­ri­wan­ga­pa kan­gi­chi. Kuna­ura­lla, akushi pai­pagma. ");
INSERT INTO inb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Chi­ura Tomás, Dídimo suti, sug­lla­pi kati­raiag­kunata nirka: —Akushi nukan­chipas, pai­wa wañug­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús Betaniama chaiag­ri­uraka, Lázaro ña wañuska, chus­ku punchasi pambaska karka. ");
INSERT INTO inb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beta­nia­ma Jeru­salen­manda karu mana kanchu. Sug kimsa chunga kuadra­sina­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Chi­manda achka judiu­kuna, Marta i Maria­pagma chaiag­riska kar­ka­kuna, pai­kunapa turi wañuska­manda iapa llakii­wa kaskata kunga­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martaka, Jesús chaia­kugta iachas­paka, tupan­ga­pa pai­pagma rirka. María, wasi­lla­pi suia­kurka. ");
INSERT INTO inb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesusta tupag­ris­paka, Marta nirka: —Taita turi, kam kaipi kag­pika, nuka­pa turi manami wañu­puá. ");
INSERT INTO inb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nukaka iacha­nimi: kam ima Taita Diusta mañaskaka, kamta uian­llami. ");
INSERT INTO inb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Chi­ura, Jesuska nirka: —Kamba turi ikuti­mi kaugsa­rin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaka nirka: —Puchuka­rii puncha, wañus­ka­kuna kaugsa­rin­ga­pa ka­ura, nuka­pa turi­pas kaugsa­rin­ga­pa kagta; chita iacha­nimi. ");
INSERT INTO inb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chasa ni­ura, Jesuska nirka: —Nukami kani wañuska kas­ka­kunata kaug­sa­chig. Nuka kikinmi kaug­sai karani. Mai­kan­pas nukata suma iuia­wag­kuna, wañuska kas­pa­pas, mana mas wañunga­pa­mi kaugsa­rin­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tukui kaug­sag­kuna nukata suma iuia­waspa kag­kunaka, mana dil­tudupa wañun­ga­pa kan­kuna­chu. Chi­taka, ¿kam chasachu suma iuiangi? ");
INSERT INTO inb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Ari, taita turi— ainirka—. Suma­mi iuiani, kam Taita Diuspa wam­bra, pai agllaska, kai alpama samuska kagta. ");
INSERT INTO inb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chasa nis­paka, rirka, ñañandi Mariata kaian­ga­pa. Kaias­paka, paka­lla­mi nirka: —Iacha­chig taita Jesús, kai­pi­mi ka. Kam­ta­mi kaia­ku. ");
INSERT INTO inb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chasa uianga­lla­waka, Ma­ria­ka, utkalla ata­rispa, Jesusta kawan­ga­pa rirka. ");
INSERT INTO inb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús, manara chi pui­bluma chaiag­rispa­lla, Marta­wa kawa­na­kuska­lla­pi­mi suia­kurka. ");
INSERT INTO inb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judiu­kuna Maria­wa sug­lla­pi llakii­wa kaskata kunga­chin­ga­pa kag­kunaka, pai ata­rispa, wasi­manda kalpa llugsigta kawas­paka, kati­chir­ka­kuna. Iuia­na­kurka: “Pamba­raiaska­machar ri­ku, chipi wakan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariaka, Jesus­pagma chaiag­rispa, paita kawas­paka, kungu­rispa, nirka: —Taita turi, kam kaipi kag­pika, nuka­pa turi manami wañu­puá. ");
INSERT INTO inb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesuska, María i judiu­kuna pai­wa chaiag­rispa waka­na­kuskata kawas­paka, sungu nanag­ta­mi iapa sin­chi llaki­rirka. ");
INSERT INTO inb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nis­paka tapurka: —¿Maipitak pambarkan­gi­chi? —Taita turi— ainir­ka­kuna—, akushi kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chi­ura, Jesuska wakarka. ");
INSERT INTO inb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Chasa kawas­paka, judiu­kuna nir­ka­kuna: —¡Chi­tuku­char Lazarota kuiarka! ");
INSERT INTO inb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sug­kuna chipi kag­kunaka nir­ka­kuna: —Pai mana ñawi kawag runata alia­chigka, ¿manachu pudirka, chara kaug­sa­kug­lla­pi, Lazaro­ta­pas wañuita kispi­chin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesuska, ikuti sin­chi llaki­rispa, Lázaro pamba­raiaska punguma chaiag­rirka. Chi pungupi, sug atun rumi kilpaska­mi karka. ");
INSERT INTO inb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kawag­ris­paka, Jesuska nirka: —Rumita anchu­chii­chi. Wañuskapa pani Martaka nirka: —Taita turi, ñami chusku puncha pambaska ka. Ñachar jiru asna­ri­ku. ");
INSERT INTO inb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesuska nirka: —¿Manachu nirkaiki: “Kam suma iuia­was­paka, Taita Diuspa suma iachai­ta­mi kawan­ga­pa kangi”? ");
INSERT INTO inb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Chasa uias­paka, chi pungu­manda kilpa­raiaska rumita anchu­chir­ka­kuna. Chi­ura Jesuska, awama kawaspa, nirka: —Taitiku, kam uia­waska­manda niikimi: “Pai Siñur”. ");
INSERT INTO inb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nuka iacha­nimi, kam ima­ura­pas uia­wa­dur kagta. Tukui kaipi nuka­wa muiugta kag­kuna­manda­mi niiki, kam nukata kacha­mu­waska kagta pai­kuna suma alli­lla iuia­wan­ga­pa—. ");
INSERT INTO inb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chasa nis­paka, sin­chi rimai­wa kapa­rirka— Lázaro, kanchama llugsi­mui. ");
INSERT INTO inb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Chasa kapa­rig­lla­pi, chi wañus­kaka, kuiu­rispa, llugsii kalla­rirka, chaki i maki­kuna linsu­kuna­wa wataskalla, uma i ñawipas chasa­lla­ta maitu­riskalla. Chi­ura, Jesuska nirka: —Paskai­chi, alli­lla purin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Achka judíu Maria­pagma chaiag­riska kag­kunaka, Jesús chasa ruraskata kawaspa, paita suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ikuti sug judiu­kunaka, pai ima ruraska kawaskata fari­seo­kunata willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Chasa willag­ri­ura, iaia sasir­duti­kuna i fari­seo­kunaka tukui judiu­kunapa taita­kunata tanda­chir­ka­kuna. Sug­lla­pi ka­ura, rima­na­kurka: —¿Imasami chi runata ruran­chi? Mana ima­ura­pas kawas­ka­sina mas achkami rura­ku. ");
INSERT INTO inb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Paita nukan­chi saki­sun­chi chasa rura­kun­ga­pa; tukui­kuna­mi pai­wa tukun­ga­pa kan­kuna. Chi­manda­mi Roma­manda­kuna­pas samun­ga­pa kan­kuna, nukan­chi Tai­ti­kupa suma atun wasita urma­chin­ga­pa. Kai alpapi kaug­sa­na­kuska­ta­pas­mi puchukan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sug pai­pura, Kaifás suti, chi wata iaia sasir­duti kaspa, nirka: —Kam­kuna, ñi ima­pas mana iachan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iuia­rii­chi: ¿mana­chu alli­lla kantra, suglla runa nukan­chipa alpapi kaug­sa­na­kuska­manda wañun­ga­pa; chasaka, tukui­kuna mana puchukai tukun­ga­pa?. ");
INSERT INTO inb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chasa, pai kikinpa iuiai­lla­wa mana rimarka. Chi wata pai iaia sasir­duti kaspa­mi Santu Ispi­ri­tu­wa sutipa kaskata willarka, chi alpapi tukui kaug­sa­na­kuska­manda Jesús wañun­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chi alpapi kaug­sa­na­kuska­mandallaka, mana; tukui Taita Diuspa wam­bra­kuna sugpi sugpi kaug­sa­na­kuskapas sug­lla tukunga­pa­mi wañun­ga­pa chaiarka. ");
INSERT INTO inb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Chi puncha­mandaka rima­na­kui kalla­rir­ka­kuna, imasa­pipas Jesusta wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chi­manda Jesuska, judiu­kunata mana kawa­rin­ga­paka, pakalla­lla­mi puri­kurka. Efraín suti pui­blupi, chusa sitaska alpa kuchu kuchumi kag­rirka. Chi­pika, paita kati­raiag­kuna­wan­ta sug puncha­kuna chisiag­rirka. ");
INSERT INTO inb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judiu­kunapa paskua atun puncha ñami chaia­kurka. Manara paskua chaiagpi, chi alpa suiu­kuna­manda achka­kuna Jeru­salenma chaia­na­kug­rirka, tukui panda­rii­kunata mailla­riska­sina ruran­ga­pa; chasaka, Diuspa ñawipi alli­lla kawa­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chi­pika, Jesusta maska­na­kurka. Diuspa atun wasipi kag­kuna­pas, kikin­pura tapu­ri­na­kurka: —¿Imatak iuia­na­kun­gi­chi? Kai atun puncha, ¿paipas samungacha? ");
INSERT INTO inb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Iaia sasir­duti­kuna i fari­seo­kuna niska kar­ka­kuna: —Mai­kan­pas Jesús maipi kaska­ta iachas­paka, willag­samun­gi­chi, paita api­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paskuapa sugta puncha pisi­ku­ura, Jesuska Betania pui­bluma rirka Lázaro kaug­sa­kus­ka­ma. Chi Lázaro wañuska­ta­mi kaug­sa­chiska karka. ");
INSERT INTO inb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesús chipi chaiag­ri­uraka, suma mikui mikun­ga­pa kaiar­ka­kuna. Marta, mikui ianuska iali­chi­kurka. Lazaropas, Jesus­wa sug­lla­pi miku­nakurka. ");
INSERT INTO inb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariaka, chipi miku­nakun­kama, sug libra­sina nardo suti suma asna asiti iapa bali kulki­wa randiskata chari­rispa, Jesuspa chaki­kunapi tallirka. Nis­paka, kikinpa agcha­wa tusta­chirka. Chasa talli­ura, chi wasi ukupi iapa suma asnaimi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chi­ura Judas Iska­riote, Jesus­ta kati­raiag­pura, Jesusta api­chin­ga­pa iuia­kugka, nirka: ");
INSERT INTO inb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Imapatak chi asitita kimsa patsa puncha ganaska bali kulki­manda mana katurka? Chi­wa pudi­rirka, mana ñi ima­pas iukas­ka­kunata chi kulki­kunata karan­ga­pa—. ");
INSERT INTO inb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Paipa iuiaipi chi Judaska, mana iukag­kuna­manda mana iuia­kurka. Kikin tukui pai­pura­kunapa kulki waka­chi­dur kaspa, pai kikin­manda sisai kaspa­mi chasa rima­kurka. ");
INSERT INTO inb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesuska nirka: —Ianga kawai. Chika, nukata pamba­wan­ga­pa puncha­pa­mi waka­chi­raiarka. ");
INSERT INTO inb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñi ima mana iukag­kunata ima­ura­pas­mi iukan­ga­pa kan­gi­chi. Ikuti nukataka sug ratu­lla­mi kawa­wa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús Betania pui­blupi kagta iachas­paka, iapa achka judiu­kuna chima chaiag­rir­ka­kuna. Jesusta kawanga­pag­lla, mana; Lázaro wañuska kaugsa­riskata kawan­ga­pa­wan­ta­mi rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chi­manda, iaia sasir­duti­kuna iuia­rir­ka­kuna, Lazaro­ta­pas wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro ikuti kaug­sa­riska kag­mandaka, achka judiu­kuna, chi taita­kunata sakispa, Jesus­wa tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chi kaiandi, iapa achka runa­kuna paskua atun puncha iali­chin­ga­pa chaiag­riska kar­ka­kuna. Jesuspas Jeru­salenma chaiag­ri­kugta iachas­paka, chi­manda llugsir­ka­kuna rin­ga­pa, ");
INSERT INTO inb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ramus palma­kuna kuchuspa, paita tupan­ga­pa. Tupag­ris­paka, kapa­rii kalla­rir­ka­kuna: —Taita Diusta iapa suma kag­ta­mi nin­chi. Atun Taita Dius kacha­muska Israel­manda runa­kunapa atun mandag samug, paipa iapa kuiaska­mi kangi. ");
INSERT INTO inb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesuska, sug maltu buruta ta­rispa, tia­rirka. Chi­wanka, imasa ñugpa­manda librupi willa­raiaska­sina tukug­samurka. Kasa­mi ni­raiá: ");
INSERT INTO inb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sión luma­manda warmi­kuna, mana mancha­na­kui­chi. Kawai­chi. Kam­kunapa atun mandagmi samu­ku. Sug burapa maltu wawa buru­pi­mi tia­riska samu­ku. ");
INSERT INTO inb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesusta kati­raiag­kuna, kawa­na­kuspa­pas, mana iachar­ka­kuna pai ima rura­kugta. Taita Dius paita suma atun­ia­chiska­ura­manda­mi, pai­manda imasa willa­raiaska­sina chasa ruraskata iuia­rig­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázaro wañuska pamba­raiaskata Jesús kaug­sa­chispa kaiagta kawag­kunaka, tukui­kunata willa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chi ima­ura­pas mana kawaska­sinata ruraska­manda iachaspa­mi achka­kuna paita tupag­rin­ga­pa llugsir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Cha­sa kawas­paka, fari­seo­kuna kikin­pura rima­ri­na­kurka: —Kawai­chi. Ñi ima­pas mana ruran­ga­pa pudi­na­kun­chi. Tukui­kuna­mi pai­lla­ta kati­nakú. ");
INSERT INTO inb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sug griego suti runa­kuna­pas­mi Jeru­salenma riska kar­ka­kuna, paskua atun puncha iali­chi­na­kus­kapi Taita Diusta kungu­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Chi runa­kunaka, Felipe­pagma kailla­iag­rispa, nir­ka­kuna: —Waugki, Jesusta kawaspa rigsinga­pa­mi muna­na­kun­chi—. (Felipe, Gali­lea alpa i Betsaida pui­blu­manda­mi karka.) ");
INSERT INTO inb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Chi­ura Felipeka, Andresta willag­rirka. Nispa pai iskandi­kuna, Jesusta willag­rir­ka­kuna, nispa: —Kamta muna­nakú rigsin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesuska ainirka: —Kai Runa Tukuskata suma atun­ia­chin­ga­pa puncha ñami chaia­mu­ku. ");
INSERT INTO inb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kasa­mi nuka nii­ki­chi­ta: trigu similla mana alpapi urmaspa wañug­sina tukug­pika, chasa­lla­mi kidá, ñi ima mana tukus­pa­lla. Ikuti alpapi urmaspa wañug­sina tukus­pa­kar, wiña­ri­ura, chi similla­manda achkami tiarí. ");
INSERT INTO inb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Chasa­lla­ta, mai­kan­pas kikin­manda­lla kaug­sai munag, kikinmi puchu­ka­rin­ga­pa ka. Ikuti mai­kan kai alpapi kikinpa kaug­saita nuka­manda iuia­rispa, mana kispi­chig­pika, mana puchuka­ri­diru suma kaug­sai­ta­mi tarin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mai­kan nuka ima munaskata ruran­ga­pa munagka kati­chi­wachu. Chasaka, nuka maipi kaskapi, chi­lla­pi­ta­mi chi runapas kag­rin­ga­pa ka. Mai­kan nuka ima munaskata ruragta, nuka­pa Taita­pas­mi kuian­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kasa­pasmi Jesús nirka: —Kuna­ura, sungu nanag­ta­mi llaki­wa­ku. Chi­manda, ¿kasachu nisa: “Tai­tiku, kai llakiita kuna­ura anchu­chi­wai”? Mana. Chasa­pa­mi samurkani—. ");
INSERT INTO inb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chasa nispa, Taita Diusta nirka— Tai­tiku, kam iapa suma atun kagta kawa­chi­rii. Chi­ura, suma luar­manda rimai uia­rig­samurka, kasa nispa: —Nuka iapa suma atun kagta kamwa ña­mi kawa­chi­rirkani. Mas nispa, ikuti­mi kam­lla­wan­ta kawa­chi­rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chipi kag­kuna, chasa uias­pa­ka, sug­kunaka nir­ka­kuna: —Sinchimi triwinarka. Ikuti sug­kunaka nir­ka­kuna: —Sug anjilmi paita rimarka. ");
INSERT INTO inb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesuska nir­ka­kunata: —Chi rimai uia­riskaka, nuka­manda mana uia­rirkachu. Kam­kuna­manda­mi uia­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kuna­ura­mi kai alpapi kaug­sag­kuna justi­siai tukun­ga­pa kan­kuna. Kuna­ura­mi kai alpapi mandag iaia kuku llugsi­chii tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nukaka, alpa­manda atari­chii tukuspa, tukui­kuna­ta­mi nuka­pag­ma kailla­ia­chin­ga­pa kani—. ");
INSERT INTO inb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pai imasa wañun­ga­pa kaska­ta­mi chasa willa­kurka. ");
INSERT INTO inb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jesús chasa ni­uraka, chipi kag­kunaka nir­ka­kuna: —Ñugpa­manda librupi kawas­pa­ka, iachan­chimi, Taita Dius agllaska Cristoka ñi ima­ura­pas mana wañun­ga­pa kagta. Nig­pika, ¿imapatak kamka ni­kungi: “Runa Tukuskata chaia­kumi, atari­chii tukun­ga­pa”? Chi Runa Tukuska, ¿pi­manda­tak ni­kungi? ");
INSERT INTO inb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chi­ura, Jesuska ainir­ka­kunata: —Mailla puncha­kuna­lla­mi kai puncha­ia­chig, kam­kunapa chaug­pi­pi kan­ga­pa ka. Kai puncha­ia­chig kam­kuna­wa kan­kama, nuka­wa purii­chi; chasaka, mana kam­kunata tuta­iai apig­samun­ga­pa. Tutapi purig mana iachanchu maipi ri­kugta. ");
INSERT INTO inb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kai puncha­ia­chig kam­kuna­wa kan­kama, suma iuia­wai­chi. Chasaka, puncha­ia­chig Taita Diuspa wam­bra­kuna­mi kan­kan­gi­chi. Chasa nis­paka Jesús, pai­kuna­pag­manda anchu­rispa, mana kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Chi­tuku achka suma mana ima­ura­pas kawaska­sina judiu­kunapa ñawipi ruragpi­pas, Jesus­wa mana tukur­ka­kuna; ");
INSERT INTO inb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","chasaka, Isaías suti Santu Ispi­ri­tu­wa rimag imasa willaska­sina tukug­samun­ga­pa. Kasa­mi ni­raiá: Tai­tiku, ¿pi­kunatak munar­ka­kuna, nukan­chi ima willaskata suma uian­ga­pa? Mailla­kunalla. Chasa­lla­ta, atun Taita Diuspa iapa iachaita, ¿pi­kunatatak kawa­chirka? ");
INSERT INTO inb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pai­kuna mana uian­ga­pa, Isaías ñugpa­mi willaska karka, kasapas nispa: ");
INSERT INTO inb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Taita Diusmi pai­kunapa ñawi­ta tuta­ia­chig­sina rurarka. Iuiai­kuna­ta­pas­mi kichurka. Chasaka pai­kuna, mana ñawi­wa kawag­sina, mana iuiai iukag­sina­mi tukun­ga­pa kan­kuna. Mana munan­kuna, nuka­wa tigramun­ga­pa. Tigramugpika, nukami ambintrani­kunata. ");
INSERT INTO inb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Paipa iuiaipi Jesús suma atun kagta ñugpata kawaspa­mi Isaías chasa pai­manda willarka. ");
INSERT INTO inb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Chasa willa­raiaska kagpi­pas, judiu­kunapa achka taita­kuna­pas­mi Jesus­wa tukur­ka­kuna. Chasa tukuspa­pas, dimanchaimi mana kawa­riilla Jesus­manda rimar­ka­kuna. Mana kag­pika, fari­seo­kunaka tanda­ri­diru wasi­manda­mi pai­kunata llugsi­chintra­kuna. ");
INSERT INTO inb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jesus­wa tukuspa­pas, masmi munar­ka­kuna, kikin­kuna­manda­lla suma atun­ia­chi­rii tukun­ga­pa, Taita Dius suma atun­ia­chiita sakispa. ");
INSERT INTO inb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesuska, kapa­rispa, nirka: —Mai­kan­pas nuka­wa tukus­ka­kunaka, mana nuka­lla­wa iuia­na­kun­chu. Nukata kacha­mu­wag­ta­pas­mi iuká iuia­na­kunga. ");
INSERT INTO inb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chasa­lla­ta nukata kawa­wa­na­kugka, kacha­mu­wag­ta­pas­mi kawa­nakú. ");
INSERT INTO inb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","—Kasapas. Nuka, kai alpapi kaug­sa­na­kuskapa iuiai­kunata puncha­ia­chinga­pa­mi samurkani; chasaka, mai­kan­pas nuka­wa tukugpi­kunaka, tutapi­sina mana kaug­sa­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mai­kan uia­waspa­pas, nuka ima rimaskata mana rurag­pika, pai panda­ris­ka­kunata nuka mana kawa­ku­nichu. Mana samurka­nichu, kai alpapi kaug­sag­kuna panda­ris­ka­kunata kawan­ga­pa. Pai­kunata kispi­chinga­pa­mi samurka­ni. ");
INSERT INTO inb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mai­kan nuka ima rimas­kata mana alli­lla uiaspa wabuti­wag­pika, sugmi pai panda­ris­ka­kunata kawa­chin­ga­pa ka. Chi nuka rimas­ka­kunata mana uia­wag­manda­mi puchu­ka­rii puncha tukui panda­ris­ka­kunata kawa­chii tukun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nuka­pa iuiai­lla­wa mana rima­ku­nichu. Nuka­pa Taita kacha­mu­wagmi willa­warka, imasa nuka rimaspa iacha­chin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nuka iacha­nimi, pai niskata uiaspa, mana puchu­ka­ri­diru suma kaug­saita chaskin­ga­pa tiagta. Chi­manda­mi nuka­pa Taita imasa willa­waska­sina kam­kunata willai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskuapa ruran­ga­pa sug­lla puncha pisi­ku­ura, Jesús ña iacharka, kai alpa­manda paipa Taita­pagma rin­ga­pa chaia­kugta. Kai alpapi pai­wa kag­kunata iapa kuiaspa, wañun­kama­mi munarka. ");
INSERT INTO inb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Paita kati­raiag­kuna­wa miku­nakun­kama, iaia kuku, ñami Judas Iska­riote suti Simonpa wam­brapa sungupi iuia­chiska karka, Jesusta api­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús ña iacharka, Taita Dius paipa makipi tukui karaska kagta; chasa­lla­ta, Taita Dius­pag­manda samuspa, Taita Dius­pagma­lla­tata kutin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nis­paka, miku­nakuska­manda ata­rispa, kikin kata­raiaska katangata anchu­chi­rispa, tusta­chi­diru linsuta aisaspa, chumbi­lli­rirka. ");
INSERT INTO inb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sug uchulla batiapi iaku tallispa, paita kati­raiag­kunapa chaki­kunata maillai kalla­rirka. Chaki­kunata maillas­paka, chumbi­lli­raiaska lin­su­wa­mi chaki­chispa aparka. ");
INSERT INTO inb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedropa chakita mai­llan­ga­pa chaia­uraka, Pedroka tapurka: —Taita waugki, ¿kamchu nuka­pa chaki­kunata mai­lla­wan­kangi? ");
INSERT INTO inb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesuska ainirka: —Nuka chasa rura­kuskata, kam kuna­ura mana iachangichu. Kipa­ma­mi ima ni­raiaskata iachan­ga­pa kangi. ");
INSERT INTO inb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedroka nirka: —Kam, ñi ima­ura­pas mana nuka­pa chaki­kunata mai­lla­wan­ga­pa kangichu. Jesuska ainirka: —Nuka kamta mana mai­llag­pi­ka, kamka mana nuka­pa kan­ga­pa kangi­chu. ");
INSERT INTO inb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chi­ura, Simón Pedro nirka: —Taita waugki, chasa kag­pika, chaki­kuna­lla­ta mana mai­lla­wai. Maki­kuna uma­wan­ta arma­chi­wai. ");
INSERT INTO inb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesuska nirka: —Mai­kan ña armaska kaskata mana ikuti maillai minis­tinchu. Chasa armaska, ñi ima mana mapa kan­chu. Chasa­lla­ta, kam­kuna armaska­sina­mi kan­gi­chi; nig­pika tukui­kunaka, manima—. ");
INSERT INTO inb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús, pi paita api­chin­ga­pa kagta iachas­pa­mi nirka: “Nig­pika, tukui­kunaka mana armaska­sina kan­gi­chi­chu”. ");
INSERT INTO inb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ña tukui­kunapa chaki­kunata maillaspa, paipa kata­ri­diruta kata­rispa, ikuti sug­lla­pi tia­rig­rirka. Nis­paka, nir­ka­kunata: —Nuka ima kam­kunata ruras­ka, ¿iachan­gi­chi­chu ima ni­ra­iag­ta? ");
INSERT INTO inb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nukata, kam­kuna ni­wan­gi­chimi: “Iacha­chig taita” i “Iaia Jesús”. Chasaka, alli­lla­mi ni­wan­gi­chi. Chasa­mi kani. ");
INSERT INTO inb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nuka, kam­kunapa iaia i iacha­chig taita kaspa­pas, kam­kunapa chaki­kuna­ta­mi maillarkai­ki­chita. Chi­manda­mi kam­kuna­ta­pas chasa­lla­ta chaia­ku, kam kikin­pura mailla­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nuka, kam­kunata ña­mi kawa­chirkai­ki­chita, imasa kam kikin­pura rura­na­kun­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kasa­mi nuka nii­ki­chita: lutrin, taita­kuna­manda mas atun mana kanchu. Chasa­lla­ta kacha­muska runa, kacha­mug­manda mas atun mana kanchu. ");
INSERT INTO inb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chi tukui ima iacha­chiskata suma ruras­paka, Taita Diuspa iapa kuiaska­mi ka­puan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Tukui kam­kuna­manda, nuka mana chasa ni­na­kui­ki­chi­ta­chu. Nuka agllas­ka­kuna­manda ña­mi iachani. Chi­wanka, ñugpa­manda librupi imasa willa­raiaska­sina tukug­samun­ga­pa ka. Kasa­mi ni­raiá: “Nuka­wa tanda sug­lla­pi mikug­pas, nuka­pa kuntrami tukurka”. ");
INSERT INTO inb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kuna­ura, manara chasa tukug­samug­pi­mi willai­ki­chita; chasa tukug­samu­uraka, kam­kuna, suma iuia­ri­waspa, nuka pi kagta rigsi­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kasa­mi nuka nii­ki­chita: mai­kan­pas nuka kachas­kata chaskig­pika, nukata chaski­wagmi ni­raiá. Chasa chaski­was­paka, nukata kacha­mu­wag­ta­pas­mi chaskig ni­raiá. ");
INSERT INTO inb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chasa nis­paka Jesuska, sungu nanagta llaki­rispa, imasa pasa­rin­ga­pa kagta willarka, kasa nispa: —Kasami nuka nii­ki­chita: kam kikin­pura­manda sugmi api­chi­wan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chi­ura paita kati­raiag­kuna, ñawima kawa­ri­na­kuspa iuia­na­kurka: “¿Pi­manda­sik chasa rima­ku?”. ");
INSERT INTO inb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesusta kati­raiag­pura mas kuiaskaka, paita kimi­rispa tia­kurka. ");
INSERT INTO inb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pai kimi­raiaskataka, Simón Pedro ñawi­wa siñas rurarka, tapu­chin­ga­pa: ¿pi­manda­mi Jesús chasa rima­ku? ");
INSERT INTO inb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chi­ura chi runaka, Jesus­pagma mas kimi­rispa, tapurka: —Taita waugki, willa­wai: ¿pitak ka? ");
INSERT INTO inb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Chi­ura, Jesuska ainirka: —Nuka sug piti tanda ju­ku­chispa, karasa; pai­mi ka—. Chasa nis­paka, tanda juku­chispa, Judas Iska­riote­ta­mi kararka. Chika karkami Simonpa wam­bra. ");
INSERT INTO inb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Chi tandata chaskispa miku­uraka, chi­ura­lla iaia kukuka Judas­pa sunguma iai­kurka. Nis­paka Jesus­ka, paita nirka: —Kam ima ruran­ga­pa kaskata utkalla rurai. ");
INSERT INTO inb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ñi mai­kan Jesus­wa miku­nakug­pura mana iachar­ka­kuna, ima­manda pai chasa ni­kugta. ");
INSERT INTO inb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sug­kuna iuia­na­kurka: “Judas kulki waka­chi­dur kag­manda, atun punchapipa ima minis­tis­ka­kuna randin­ga­pachar kacha­ku”. Ikuti sug­kunaka iuia­na­kurka: “Ñi ima mana iukas­ka­kunatachar karan­ga­pa kacha­ku”. ");
INSERT INTO inb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas chi tandata mikunga­lla­wa llugsi­ura, ña tuta­mi karka. ");
INSERT INTO inb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ña llugsi­ura, Jesuska nirka: —Kuna­ura­mi kai Runa Tukus­ka­ta suma atun­ia­chiska tuku­ku. Nuka­wa­mi Taita Diuspas suma atun­ia­chiska tuku­ku. ");
INSERT INTO inb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Taita Dius­ka, nuka­wa atun­ia­chiska tukuspa, nuka­ta­pas­mi atun­ia­chi­wan­ga­pa ka. Mana unai­lla­mi atun­ia­chi­wan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—Nuka­pa kuias­ka­kuna, kam­kuna­wa mana unai kan­ga­pa ka­nichu. Chi­ura­mandaka, kam­kunata iapa llakiimi tukun­ga­pa ka. Imasa­mi judiu­kunata nirkani: chasa­lla­ta­mi kuna­ura kam­kuna­ta­pas nii­ki­chita: “Nuka maima rin­ga­pa kaska­ma, kam­kunaka mana rii pudin­ga­pa kan­gi­chi­chu”. ");
INSERT INTO inb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","—Kam­kunata sug musu mandai­ta­mi sakii­ki­chita: kam kikin­pura kuia­na­kun­ga­pa. Imasa­mi nuka kam­kunata kuiar­kai­ki­chita: chasa­lla­ta kam kikin­pura­pas kuia­na­kuspa kaug­san­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Chasa kuia­na­kug­pika, tukui­kuna­mi iachan­ga­kuna, kam­kuna nukata kati­ra­ia­wag­kuna kagta. ");
INSERT INTO inb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Chi­ura, Simón Pedroka tapurka: —Taita waugki, ¿maimatak ri­kungi? Chi­ura, Jesús ainirka: —Nuka maima rin­ga­pa kaska­ma, kuna­ura kam mana kati­wai pudin­ga­pa kangichu. Kipa­ma­mi kati­chi­wan­kangi. ");
INSERT INTO inb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedroka tapurka: —Taita waugki, ¿ima­wan­tak kuna­ura nuka mana kamta katin­ga­pa pudiiki? Kam­manda wañu­chii­pas­mi tukuntrani. ");
INSERT INTO inb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Chasa ni­ura, Jesuska ainirka: —Nuka­manda wañun­ga­pa muna­kug­pipas, kasa­mi nuka niiki: gallu manara kantag­pi­mi kamka kimsa biaji nuka­manda nin­ga­pa kangi: “Paita mana rigsi­nichu”. ");
INSERT INTO inb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kasapasmi Jesús nirka: —Mana sungupi iapa irkias­pa kai­chi. Imasa­mi Taita Dius­ta suma iuian­gi­chi: nuka­ta­pas chasa­lla­ta suma iuia­wai­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nuka­pa Taita­pagpi achka kaug­sa­diru­mi tia. Mana chasa tiag­pika, tim­pu­mi willai­ki­chita. Kuna­ura, pai­pag­ma­mi rin­ga­pa kani, kam­kuna­manda kaug­sa­diruta alli­chig­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chi kaug­sa­diruta ña alli­chig­ris­paka, ikuti­mi samu­sa, kam­kunata pusan­ga­pa; chasaka, nuka maipi kaska­pi, kam­kuna­pas kaug­sag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nuka maima ri­kuska­maka, kam­kuna ñami iachan­gi­chi imasa chaiag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chasa uias­paka, Tomás nirka: —Taita waugki, nukan­chi mana iachan­chi kam maima ri­kugta. ¿Imasatak iacha­sun­chi mai­kan ñambi rin­ga­pa kagta? ");
INSERT INTO inb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chi­ura, Jesuska ainirka: —Nukami kani chaiag­ri­diru ñambi­sina. Ñi imapi mana llullag, kaug­sai karag­pas­mi kani. Nuka­lla­wa­mi nuka­pa Taita­pagma chaiag­ri­diru ka. ");
INSERT INTO inb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nukata rigsi­was­paka, nuka­pa Taita­ta­pas­mi rigsig­sina kan­gi­chi. Kuna­ura­manda­ta­mi ña paita rigsispa kawa­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chasa uias­paka, Felipe nirka: —Taita waugki, kamba taitata nukan­chita kawa­chii. Chi­lla­mi munan­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Chi­ura Jesuska, paita ainirka: —Nuka, ña unaimi kam­kuna­wa kani. Nig­pika, ¿manarachu kam nuka­ta rigsi­wangi? Mai­kan­pas nuka­ta kawa­wag, nuka­pa Taita­ta­pas­mi ña kawag ni­raiá. Nig­pika, ¿ima­wan­tak kam ni­wa­kungi: “Kamba taitata nukan­chita kawa­chii”? ");
INSERT INTO inb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Manara­chu suma iuiangi, nuka­pa Taita nuka­wa i nuka­pas Taita­wa sug­lla kagta? Nuka ima kam­kunata rima­kuskaka, nuka­pa iuiai­lla­wa mana rima­ku­ni­chu. Nuka­pa Taita, nuka­wa suglla kaspa­mi nuka tukui ima ruras­ka­ta rurag ka. ");
INSERT INTO inb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Suma iuia­wai­chi, nuka­pa Taita nuka­wa i nuka­pas nuka­pa Taita­wa sug­lla kagta. Mana nukata iuia­waspa­pas, nuka ima rura­kuska­lla­ta kawaspa, chasa kagta iuia­rii­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","—Kasami nuka nii­ki­chita: mai­kan­pas nukata suma iuia­wag, nuka imasa ruraska­sina­lla­ta­ta­mi ruran­ga­pa ka. Nuka­pa Taita­pag­ma­mi nuka ri­kuni. Chi­manda mai­kan suma iuia­wag, ima­ura­pas mana kawaska­sina mas suma­mi mai­nig­ta­pas ruran­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kam­kuna nuka­manda iuia­rispa mañagpi­kunaka, tukuimi chaskin­kan­gi­chi, nuka­pa Taitata paipa wam­bra­wa mas suma atun­ia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ima­pas kam­kuna nuka­manda iuia­rispa mañagpi­kuna, nuka­pas­mi karasa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Kam­kuna nukata kuia­was­paka, nuka imasa niska­sina­mi ruran­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nukaka, nuka­pa Taitata maña­pu­sa­ki­chitami, kam­kunata sug sumag­lla iuia­chigta kacha­mun­ga­pa. Paimi ima­ura­pas kam­kuna­wa kan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pai Santu Ispi­ri­tumi tukuipi sutipa kaskata willan­ga­pa ka. Kai alpapi tias­ka­kuna­lla­wa iuiag­kuna, paita mana iachaspa i mana rigsispa, mana paita chaskin­ga­pa kan­kuna­chu. Ikuti kam­kunaka, paita rigsin­gi­chimi. Pai, kam­kuna­wa­mi ka. Kam­kunapa iuiai­pi­pas­mi kaug­sag­samun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Chasaka, kam­kunata wagchu­sina mana sitai­ki­chitachu. Kam­kuna­pagma ikutimi samusa. ");
INSERT INTO inb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kai alpapi tias­ka­kuna­lla­wa iuiag­kuna, sug ratu­lla­mi kawa­wa­nakú. Nis­paka, mana mas kawa­wan­ga­pa kan­kuna­chu. Kam­kunakar, ikuti­mi kawa­wan­ga­pa kan­gi­chi. Nuka kaug­salla kag­manda, kam­kuna­pas kaug­sa­lla­mi kan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chi puncha­manda­mi iachan­kan­gi­chi, nuka­pa Taita­wa nuka suglla kagta; chasa­lla­ta, kam­kuna nuka­wa i nuka­pas kam­kuna­wa suglla ni­raiagta. ");
INSERT INTO inb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Mai­kan­pas nuka ima nis­ka­ta iachaspa suma rurag­kuna­mi sutipa nukata kuia­wag kan­kuna. Nukata kuia­wag­kuna­ta­ka, nuka­pa Taita­pas­mi kuianga. Nuka­pas, pai­kunata nuka kuiag kagta kawa­ri­sami. ");
INSERT INTO inb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Chi­ura sug Judas, mana Iska­riote kagka, tapurka: —Taita waugki, ¿imapatak ni­kungi, kai alpapi tias­ka­kuna­lla­wa iuiag­kunata mana kawa­rispa­lla, nukan­chi­lla­ta kawa­rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Chi­ura, Jesuska ainirka: —Mai­kan nukata kuia­wag­kunaka, nuka imasa niska­ta­mi ruran­ga­kuna. Pai­kunataka, nuka­pa Taita­pas­mi kuianga. Kuias­paka, samu­sun­chimi, pai­kunapi kaug­sa­diru ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ikuti nukata mana kuia­wag­kunaka, nuka ima niskata mana ruran­ga­pa kan­kuna­chu. Chi rimai­kuna kam­kuna uia­wa­na­kuskaka, nuka­pa iuiai­lla­wa mana kanchu. Nuka­pa Taita kacha­mu­waska, paipa iuiai­ta­mi willa­na­kui­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Nuka, chara kam­kuna­wa kan­kama­lla­mi tukui chi rimai­kunata willa­na­kui­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Santu Ispi­ri­tutaka nuka mañaska­manda­mi nuka­pa Taita kacha­mun­ga­pa ka. Pai Ispí­ritu kam­kunata sumag­lla iuia­chig, samus­paka, tukui imasa kaska­sina­mi iacha­chig­samun­ga­pa ka. Nuka kam­kunata kuna­ura tukui ima willaska­ta­pas­mi ikuti iuia­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Kam­kunata sakii­ki­chitami, nuka­sina­lla­tata sumag­lla kaug­san­ga­pa, pari­juma mana mancha­na­kuspa­lla. Chi suma kaug­sai mana kanchu imasa kai alpapi tias­ka­kuna­lla­wa iuiag­kuna kaug­san­kuna: chasa. Chi­manda, mana llakispa manchaspa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ñami willarkai­ki­chita: “Nukaka ri­ku­ni­mi. Chasa kagpi­pas, kam­kuna­pag­ma ikutimi samu­sa”. Kam­kuna sutipa kuia­wag­pika, nuka­pa Taita­pagma ri­kug­manda uiaspa, iapa­mi kun­tin­ta­rintran­gi­chi. Nuka­pa Taita, nuka­manda mas atun­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kuna­ura, manara chasa chaiag­pi­mi willai­ki­chita; chasa pasa­ri­uraka, kam­kuna, nuka ima willas­ka­ta iuia­rispa, suma iuia­wan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","—Kasapas. Iaia kuku kai alpapi mandag samu­kug­manda­mi nuka kam­kuna­wa mana iapa riman­ga­pa kani. Chi iaia kukuka mana iukanchu nuka­wa ñi ima­pas kawanga. ");
INSERT INTO inb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pai chasa samu­kug­pi­pas, nukataka chaia­wa­ku­mi, kai alpapi kaug­sag­kunata kawa­chin­ga­pa, nukaka nuka­pa Taitata kuiagta; chasa­lla­ta, nuka­pa Taita imasa ni­waska­sina nuka rurag kagta. —Atarii­chi. Kai­manda akushi. ");
INSERT INTO inb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kasapasmi Jesús nirka: —Nukami kani ubas alli sacha­sina. Nuka­pa Taitaka, chi suma sachata almag­sina­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sacha­ta almag, malki mana muiu apa­ris­ka­kunata kuchunmi. Ikuti mal­ki muiu iukas­ka­kunataka ladu ladu malki­kunata anchu­chispa, suma almaspa­mi sakí; chasaka, mas suma muiu­kuna tia­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kam­kuna, nuka ima rimaskata uia­was­paka, ñami alli malki­kunata almas­ka­sina kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nuka­wa kai­chi. Nuka­pas, kam­kuna­wa­mi kasa. Imasa­mi malki, kikin sacha­ma mana lluta­raiag­pika, ñi ima muiu mana tia­rin­ga­pa ka: chasa­lla­ta­mi kam­kuna, mana nuka­wa sug­lla­pi kag­pika, chi mana muiu­iug malki­kuna­sina kan­tran­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Nukami kani chi ubas alli sacha­sina. Kam­kuna­mi chi malki­kuna­sina kan­gi­chi. Mai­kan nuka­wa sug­lla­pi kag, nuka­pas pai­wa kag­pika, paika achka mikui muiu iukag­sina­mi ka. Mana nuka­wa sug­lla­pi kas­paka, ñi ima­pas mana pudin­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Imasa­mi malki sacha­manda anchu­chiska, ña tusta ka­uraka, tanda­chispa, ninapi sitan­kuna rupan­ga­pa: chasa­lla­ta­mi mai­kan mana nuka­wa sug­lla­pi kag­kunaka, sitai tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","—Kam­kuna nuka­wa sug­lla­pi kaspa, nuka imasa niskata ruras­paka, tukui ima mañaskaka chaskin­kan­gi­chimi. ");
INSERT INTO inb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kam­kuna achka mikui­sina iukaska­wa nuka­pa Taitata suma­mi atun­ia­chi­puan­ga­pa kan­gi­chi. Chasaka, nuka­pa iachai­kug­kuna kag­ta­mi kawa­chin­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","—Imasami nuka­pa Taita, nuka­ta kuiawá: chasa­lla­ta­mi nuka­pas, kam­kunata kuiai­ki­chita. Chi­wanka, sumag­lla kaug­sa­na­kun­gi­chi, nuka­pa kuias­ka­kuna kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nuka­pa Taita ima ni­waskata nuka ruras­paka, paipa kuiaskami kani. Chasa­lla­ta kam­kuna­pas, nuka ima niskata ruras­paka, nuka­pa kuias­ka­kuna­mi kan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Chasa nii­ki­chitami, nuka kam­kuna­wa iapa suma alli iuia­chii­wa kan­ga­pa. Chasaka kam­kuna­pas, nuka­wa iapa suma iuia­chii­wa­mi tukuipi alli­lla kan­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","—Kasa ruranga­pa­mi nii­ki­chita: imasa­mi nuka, kam­kunata kuiai­ki­chita: chasa­lla­ta kam­kuna­pas, kam kikin­pura kuia­na­kuspa kaug­san­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mai­kan­pas paipa kuiaska iacha­ridu­kuna­manda wañug­pika, tukui­kuna­manda­pas mas kuiag­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nuka ima nis­kata kam­kuna ruraspa kag­manda­mi nuka­pa kuiaska iacha­ridu­kuna ka­puan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","—Lutrin­kuna mana iachan­kuna­chu, taita­kuna ima rura­na­kugta. Chi­manda­mi kam­kunata mana nii­ki­chita: “Lutrin­kuna”. Kuna­ura­manda, nuka­pa kuiaska iacha­ridu­kuna­mi ka­puan­gi­chi. Nuka­pa Taitata tukui imasa uiaska­sina­mi kam­kunata willaspa iacha­chirkai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","—Kam­kuna mana nukata ag­lla­warkan­gi­chi­chu. Nuka­mi kam­kunata agllarkai­ki­chita. Chasaka, kam­kuna maima riskapi, malki suma muiu­iug­sina kaspa, alli­lla­mi rurag­rin­kan­gi­chi. Chi alli ruras­ka­kunaka, ñi ima­ura­pas mana puchuka­rin­ga­pa kanchu. Chi­wanka, tukui ima nuka­pa Taitata nuka­manda iuia­rispa mañag­pi­kunaka, paimi kam­kunata karan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kasa ruranga­pa­mi nii­ki­chita: kam kikin­pura kuia­na­kuspa kaug­san­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Kai alpapi tias­ka­kuna­lla­wa iuiag­kuna kam­kunata mana munag­pika, iuia­rin­gi­chi: pai­kuna ñugpa­mi nukata mana muna­war­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kam­kuna kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­sina kagpi, pai­kuna kikin­pura­sina­mi kam­kunata kuiantra­kuna. Kam­kuna mana kan­gi­chi­chu kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­sina. Nukami kam­kunata kai alpapi kaug­sa­na­kuska­pura­manda agllarkai­ki­chita. Chi­manda­mi kai alpapi tias­ka­kuna­lla­wa iuiag­kuna, kam­kunata wabu­tispa, mana munan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nuka ima rimaskata iuia­rii­chi: “Lutrin, paipa taita­kuna­manda mas atun mana kanchu”. Nukata mana muna­wag­kuna, kam­kuna­ta­pas­mi mana munan­ga­pa kan­kuna. Nuka ima rimaskata uiaspa rurag­kunaka, kam­kuna imasa rimas­ka­kuna­ta­pas­mi chasa­lla­ta uian­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ikuti mana uiag­kunaka, nukata kacha­mu­wagta mana rigsispa­mi kam­kunata chasa tukui ima­pas jiru ruran­ga­pa kan­kuna, kam­kuna nuka­wa tukug­manda. ");
INSERT INTO inb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","—Nuka mana samuspa, pai­kunata rimag­samu­nimi; pai­kuna, panda­riskapas, manachar panda­riska ni­raiantra. Chi­manda, kuna­ura mana pudin­kuna­chu nin­ga­pa: “Nuka mana iacharka­nichu”. ");
INSERT INTO inb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mai­kan­pas nukata mana muna­wag, nuka­pa Taita­ta­pas­mi mana munag ka. ");
INSERT INTO inb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mana pipas kawaska­sinata, pai­kunapa ñawipi, nuka mana rurag­samu­ni­mi; pai­kuna, panda­riskapas, mana­char panda­riska ni­raiantra. Chi­manda kuna­ura, nuka ima ruraskata kawaspa­pas­mi nukata mana muna­wan­kuna. Chasaka, nuka­pa Taita­ta­pas­mi mana muna­puan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Imasa pai­kuna­manda ñugpa­manda librupi willa­raiaska­sina­mi tukug­samu­ku. Kasa­mi ni­raiá: “Iangami nukata mana muna­war­ka­kuna”. ");
INSERT INTO inb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Kasapas. Sumag­lla iuia­chig­ta­mi nuka­pa Taita­pag­manda kacha­musa­ki­chita. Pai Santu Ispí­ritu kanmi ñi imapi mana llullaspa­lla sutipa kaskata willag. Nuka­pa Taita­pag­manda samuspa, nuka­manda­mi tukuipi alli­lla willan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chi­ura­manda­mi kam­kuna­pas, nuka­wa ñugpa­manda­ta kaspa, suma alli­lla iuia­rispa, nuka­manda willan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Chi­mandami ña nir­kai­ki­chita, kam­kuna chasa pasa­ri­ku­uraka, nuka­manda ñi ima­pipas mana sug rigcha iuia­wa­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kam­kunata judiu­kuna tanda­ri­diru wasi­kuna­manda­mi llug­si­chin­ga­pa kan­kuna. Chi pun­cha­kuna chaia­ura, mai­kan­pas kam­kunata wañu­chis­paka, iuia­na­kun­ga­mi: “Taita Dius imasa munas­ka­sina­mi alli­lla rura­kuni”. ");
INSERT INTO inb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nuka­pa Taitata ñi nukata mana rigsispa­mi chasa ruran­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nuka willaspa­mi sakii­ki­chita, chasa chaia­ura, nuka ima willaska­ta iuia­rin­ga­pa. —Nuka mana ñugpa willarkai­ki­chitachu, kam­kuna­wa kaspa. ");
INSERT INTO inb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ikuti kuna­uraka, nukata kacha­mu­wag­pag­ma­mi rin­ga­pa kani. Ñi pipas mana tapu­wan­gi­chi­chu: “¿Mai­ma­tak ri­kungi?”. ");
INSERT INTO inb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nuka chasa rimas­ka­manda­mi kam­kuna, iapa irkiaspa, sungu nanagta llakii­wa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Chasa kagpi­pas, sutipa kaska­ta­mi kasa nii­ki­chita: nuka, kam­kuna­manda alli­lla­pa­mi ri­kuni. Nuka mana rig­pika, kam­kunata sumag­lla iuia­chig Santu Ispí­ritu mana samun­ga­pa kan­chu. Nuka ris­paka, paita kam­kuna­pag­ma­mi kacha­mu­sa. ");
INSERT INTO inb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","—Pai samus­paka, kai alpapi tias­ka­kuna­lla­wa iuiag­kunata iuia­chinga­pa­mi ka mana alli­lla rura­na­kugta. Imasa chaiaska­sina alli­lla ruranga­pa­mi iuia­chin­ga­pa ka. Kasapas. Taita Dius justi­siag kag­ta­mi iacha­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nukata rigsin­ga­pa mana muna­wag­manda­mi pai­kunata iuia­chin­ga­pa ka mana alli­lla rura­na­kugta. ");
INSERT INTO inb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nuka­pa Taita­pagma ri­ura, kam­kuna mana mas nukata kawa­wan­ga­pa kan­gi­chi­chu. Chi­manda­mi pai, imasa chaiaska­sina alli­lla ruran­ga­pa iuia­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iaia kuku kai alpapi mandag ñami justi­siai tukuska ka. Chasa Taita Dius jus­ti­siag kag­ta­mi pai tukuipi iuia­chispa iacha­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Kam­kunata willan­ga­pa, achkami iukani. Chasa iukagpi­pas, kam­kuna kuna­ura manima tukui­manda iachai­kui pudin­ga­pa kan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Santu Ispí­ritu ñi imapi mana llullaspa­lla sutipa kaskata willag­mi samun­ga­pa ka. Paika, samuspa, tukui imasa sutipa kaska­ta­mi kam­kunata alli­lla suma iuia­chispa iacha­chin­ga­pa ka. Mana riman­ga­pa ka pai kikinpa iuiai­lla­wa. Taita Dius ima niskata uiaska­ta­mi kam­kunata willan­ga­pa ka. Imasa mas kipama chaian­ga­pa kaska­ta­pas­mi willan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nuka rimaskata chaski­waspa­mi kam­kunata mas alli­lla iacha­chig­samun­ga­pa ka. Chasa­manda­mi pai nukata suma atun­ia­chi­wan­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nuka­pa Taita tukui ima iukaska, nuka­pa­mi ka. Chi­manda­mi nii­ki­chita: “Nuka rimaskata chas­ki­waspa­mi kam­kunata mas alli­lla iacha­chig­samun­ga­pa ka”. ");
INSERT INTO inb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kasapasmi Jesús nirka: —Sug mana unailla, nukata mana kawa­wan­ga­pa kan­gi­chi­chu. Sug ratumaka, ikuti­mi kawa­wan­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chi­uraka paita sug kati­raiag­kuna, kikin­pura tapu­ri­na­kurka: —Nukan­chita chasa rimaika, ¿imatak ni­raiá? “Sug mana unailla, nukata mana kawa­wan­ga­pa kan­gi­chi­chu. Sug ratu­maka, ikutimi kawa­wan­ga­pa kan­gi­chi”. Kasa­pas­mi nirka: “Nuka­pa Taita­pag­ma­mi rin­ga­pa kani”. ");
INSERT INTO inb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Chi mana unailla, ¿ima­sik ni­raiá? Chasa rimai ima ni­raiagta mana iachan­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesuska, pai­kuna chasa tapun­ga­pa iuia­na­kuskata iachaspa, nirka: —Kasami nirkai­ki­chita: “Sug mana unailla, nukata mana kawa­wan­ga­pa kan­gi­chi­chu. Sug ratu­maka, ikuti­mi kawa­wan­ga­pa kan­gi­chi”. Chasa rimai­kuna­mandaka, ¿manachu kam­kuna­pura tapu­ri­na­kun­gi­chi: “¿Imatak ni­raiá?”? ");
INSERT INTO inb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kasa­mi nuka nii­ki­chita: kam­kuna, iapa llaki­rispa­mi wakan­kan­gi­chi. Ikuti kai alpapi tias­ka­kuna­lla­wa iuiag­kunaka, suma­mi kun­tin­ta­rin­ga­kuna. Kam­kunapa llakii­kuna iukaskaka, iapa alli iuia­chii­wa­mi tukun­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","—Mai­kan warmi, wawita iukan­ga­pa puncha chaia­ku­uraka, sin­chi llakii­wa­mi ka. Nis­paka, wawita tiag­samu­uraka, chi llakii iukaskata ñi ima mana iuiarí. Sug wawita kai alpama chaia­chig­samuska­manda­mi alli iuia­chirí. ");
INSERT INTO inb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chasa­lla­ta kam­kuna, kuna­ura sutipa­mi iapa llakii­wa kan­gi­chi. Nuka kam­kunata ikuti kawa­rig­samu­uraka, iapa alli iuia­chii­wa­mi tukun­ga­pa kan­gi­chi. Chi alli iuia­chiitaka, ñi pipas kam­kunapa sungu­manda mana kichun­ga­pa pudin­ga­pa kan­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Chi puncha, ñi ima­manda­pas mana tapu­chi­wan­ga­pa kan­gi­chi­chu. Kasa­mi nuka nii­ki­chi­ta: nuka­manda iuia­rispa, tukui ima nuka­pa Taitata kam­kuna mañag­pi­ka, paika tukui­mi kara­mun­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kunan­kama kam­kuna, nuka­manda iuia­rispa, manara ima­pas mañaska kan­gi­chi­chu. Chasa mañai­chi, chaskin­ga­pa. Chi­wanka, kam­kunapa iapa alli iuia­chii­wa­mi tukun­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kasapasmi Jesús nir­ka­kunata: —Iuiai apinga­sina parlu­kuna­lla­wa­mi rimarkai­ki­chita. Ñami chaia­mu­wan­ga­pa ka, mana parlu­kuna­lla­wa chasa riman­ga­pa. Chi­ura­mi tukui alli­lla nuka­pa Taita­manda willasa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chi pun­cha­mi, nuka­manda iuia­rispa, nuka­pa Taitata mañan­ga­pa kan­gi­chi. Mana nii­ki­chitachu: nuka­mi kam­kuna­manda nuka­pa Taitata maña­pu­sa­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nuka­pa Taita kikinmi alli­lla kam­kunata kuiá, kam­kuna nukata kuia­waspa, nuka Taita Dius­pag­manda llugsispa samuska kagta suma iuia­wag­manda. ");
INSERT INTO inb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sutipa­mi nii­ki­chita: nuka­pa Taita­pag­manda llugsispa­mi kai alpama samurkani. Kuna­uraka, ikuti kai alpata sakispa, nuka­pa Taita­pag­ma­mi rin­ga­pa kani. ");
INSERT INTO inb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Chi­ura, Jesusta kati­raiag­kuna nir­ka­kuna: —Kuna­urami nukan­chita alli­lla willa­kungi, mana iuiai apinga­sina parlu­kuna­lla­wa. ");
INSERT INTO inb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kuna­ura­mi iachan­chi, kam tukui iachagta. Chi­manda­mi mana minis­tingi, ñi pipas kamta tapu­chin­ga­pa. Chasa­manda­mi suma iuian­chi, kam Taita Dius­pag­manda llugsispa samuska kagta. ");
INSERT INTO inb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Chi­ura, Jesuska nirka: —¿Sutipachu kuna­ura suma iuia­wan­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chaia­mun­ga­pa puncha ñami chaia­murka; kam­kunaka, kam kikin­kuna­pag­ma­mi miti­kun­ga­pa kan­gi­chi. Chasaka, nuka­ta sapa­lla­mi saki­wan­ga­pa kan­gi­chi. Chasa kagpi­pas, nukaka mana sapalla ka­nichu. Nuka­pa Taita­mi nuka­wa ka. ");
INSERT INTO inb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chasa­mi rimai­ki­chita, kam­kuna kai alpapi iapa llakii­wa kaspa­pas, nuka­wa suma iuia­ris­paka, mana llakii­wa kag­sina kan­ga­pa. Chasa iapa llakii­wa kaspa­pas, mana mancha­na­kun­gi­chi. Nukaka, iaia kuku kai alpapi mandagta ñami miti­ku­chirkani. ");
INSERT INTO inb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chasa nis­paka Jesús, awa­sinama kawaspa, kasa­mi nirka: —Tai­tiku, nuka­pa puncha ñami chaia­murka. Nuka kamba wam­bra kagta suma atun­ia­chi­wai; chasaka, nuka­pas kamta atun­ia­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kam, tukui­kuna­ta­mi nuka­pa makipi churarkangi, tukui kam aglla­puas­ka­kunata mana puchuka­ri­diru suma kaug­saita nuka karan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kam sutipa suglla Taita Dius kagta i nuka Jesu­cristo kam kacha­mu­waska kagta rigsig­kuna­mi chi mana puchuka­ri­diru kaug­saita iukan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","—Nukaka, kam tukui imasa ni­waska­sina rurai puchukaspa­mi kai alpapi suma atun­ia­chirkaiki. ");
INSERT INTO inb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kuna­ura, Tai­tiku, imasa­mi, ñi ima­pas manara tiagpita, nuka kamwa suma atun­ia­chiska karkani: chasa­lla­ta kuna­ura, nukata kam­lla­wan­ta suma atun­ia­chi­wai. ");
INSERT INTO inb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—Kammi, kai runa­kunata kai alpapi kaug­sag­pura­manda agllaspa, nuka­pa makipi churarkangi. Pai­kuna­ta, kam imasa kaska­sina­mi nuka willarkani. Pai­kuna, kamba­mi kar­ka­kuna. Kammi nuka­pa makipi churarkangi. Kamba rimaita alli­lla uiaspa, mana kunga­rispa­lla­mi kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chi­wa, kuna­ura iachan­kunami, tukui ima nuka iukaskaka kam kara­waskata, nuka chaskiska kagta. ");
INSERT INTO inb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kam ima ni­waskata pai­kunata willarka­nimi. Pai­kuna, nuka ima willaskata suma iuiaspa, sutipa­mi iachan­kuna, nuka kam­bag­manda llugsispa samuska kagta. Kam nukata kacha­mu­waska kag­ta­pas­mi sumag­lla iuia­nakú. ");
INSERT INTO inb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Pai­kuna­mandami nuka maña­kuiki. Mana maña­kuikichu kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­manda. Kam nuka­pa makipi churas­ka­kuna­manda­mi maña­kuiki, pai­kuna kam kikinpa kag­manda. ");
INSERT INTO inb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tukui nuka­pa­kuna, kamba­mi ka. Chasa­lla­ta tukui kamba­kuna, nuka­pa­mi ka. Pai­kuna­pi­mi nuka suma atun­ia­chiska tukuni. ");
INSERT INTO inb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","—Nuka, ña mana kai alpapi kan­ga­pa ka­nichu. Pai­kunakar, cha­ra­mi kai alpapi kan­ga­pa kan­kuna. Nuka ri­ku­nimi, kamwa kan­ga­pa. Tukuipi mas alli Tai­tiku, kam nuka­pa makipi churaska runa­kunata kamba iapa iachai­wa chari­puai­kunata; chasaka, imasa­mi nukan­chi, suglla kan­chi: chasa­lla­ta pai­kuna­pas, suglla iuiai­wa kan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nuka, pai­kuna­wa kan­kama, kam nuka­pa makipi chu­ras­ka­kunata kamba iapa iachai­wa alli­lla­mi kawaspa cha­rir­ka­ni­kunata. Pai­kuna, ñi sug mana chingarka­chu. Chi chinga­rin­ga­pa ni­raiaska runa­lla­mi chin­garka, imasa ñugpa­manda librupi willa­raiaska­sina tukug­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Kuna­uraka nuka, kam­bag­ma­mi ri­kuni. Kai alpapi chasa­mi rima­kuiki, pai­kuna­pas, suma kun­tin­ta­rispa, nuka­pa alli iuia­chii­wa tukun­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pai­kunata, kam imasa ni­waska­sina­mi willarkani. Imasa­mi nuka, mana kai alpa­manda kani: chasa­lla­ta­mi pai­kuna­pas, mana kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­sina kan­kuna. Chi­manda­mi kai alpapi tias­ka­kuna­lla­wa iuiag­kuna, pai­kunata mana munan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mana maña­kui­ki­chu: kam, kai alpa­manda pai­kunata llugsi­chi­puai. Tukui mana alli­lla rurai­kuna­manda kispi­chi­puangi, pai­kuna­manda maña­kuiki. ");
INSERT INTO inb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ima­sa­mi nuka, mana kai alpa­manda ka­ni­chu: chasa­lla­ta­mi pai­kuna­pas, mana kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­sina kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tukui­pi sutipa kaska­ta pai­kunata sumag­lla iuia­chi­puai, pai­kuna kam­ba­lla kan­ga­pa. Kamba rimai, tukuipi sutipa­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Imasa­mi kam, nukata kai alpama kacha­mu­war­kan­gi: chasa­lla­ta­mi nuka­pas, pai­kunata kacha­kuni, kai alpapi willaspa purin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pai­kuna alli­lla kanga­pa­mi nuka ikuti nii­ki: “Kam­ba­lla­mi kani”; chasaka pai­kuna­pas, kamba mana llullaspa­lla sutipa rimai­wa kam­ba­lla kan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Kaipi kag­kuna­manda­lla mana maña­kuikichu. Pai­kuna nuka­manda willas­ka­kuna­wa tukui suma iuia­wa­na­kug­manda­pas­mi maña­kuiki; ");
INSERT INTO inb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","chasaka tukui­kuna, suglla ni­raian­ga­pa. Imasa­mi kam Tai­tiku nuka­wa suglla kangi i nuka kamwa suglla kani: chasa­lla­ta pai­kuna­pas, nukan­chi­wa suglla ni­raianga­pa­mi maña­kuiki. Chasa­ka, kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­pas iachan­ga­kunami, nukaka kam kacha­mu­waska kagta. ");
INSERT INTO inb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","—Kam imasami nukata suma atun­ia­chi­warkangi: chasa­lla­ta­mi nuka­pas, pai­kunata atun­ia­chirkani; chasaka, imasa­mi nukan­chi, suglla kan­chi; chasa­lla­ta pai­kuna­pas, suglla ni­raian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nuka pai­kuna­wa sug­lla­pi­mi kani; kampas nuka­wa sug­lla­mi kangi; chasaka pai­kuna­pas, tukuipi suglla ni­raian­ga­pa. Chasaka, kai alpapi tias­ka­kuna­lla­wa iuiag­kuna­pas iachan­ga­kunami, kam nukata kaima kacha­mu­waska kagta. Kasa­pas­mi iachan­ga­kuna: kam imasa­mi nukata kuia­wangi: chasa­lla­ta­mi pai­kuna­ta­pas kuiangi. ");
INSERT INTO inb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Taitiku, kam nuka­pa maki­pi chura­was­ka­kuna­manda, kasa­mi munani: nuka suma luarpi ka­ura, pai­kuna­pas chipi nuka­wa kag­ri­chu­kuna; chi­pika, nuka suma atun­ia­chiska kaskata kawa­wan­ga­pa. Kai alpa manara tiagpita kam, nukata kuia­waspa­mi suma atun­ia­chi­warkangi. ");
INSERT INTO inb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","—Tukuipi alli­lla rurag Tai­tiku, kai alpapi tias­ka­kuna­lla­wa iuiag­kuna mana kamta rigsigpi­pas, nukami alli­lla rigsiiki. Kaipi kag­kunaka iachan­kunami, kam nukata kacha­mu­waska kagta. ");
INSERT INTO inb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pai­kunata, kam imasa kaska­sina­mi nuka willar­ka­ni. Masmi pai­kunata willan­ga­pa kani; chi­wanka, imasa­mi kam kuia­wangi: chasa­lla­ta, pai kikin­purapas kuia­na­kuspa kaug­san­ga­pa; chasaka, nuka pai­kuna­wa suglla tukuska kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chasa nis­paka Jesús, paita kati­raiag­kuna­wa llugsispa, Kedrón suti iaku sug ladu chimba rispa, sug wirta tiaska­ma iai­kug­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chi wirtata Judas, Jesus­ta api­chin­ga­pa kag, alli­lla­mi rig­sirka. Chi­pi­mi karka Jesus­wa tukui kati­raiag­kuna­wa tanda­ri­diru. ");
INSERT INTO inb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Chi­manda Judaska, suldadu­kuna­ta, i iaia sasir­duti­kuna i fari­seo­kuna kachaska alwasil­kunata pusaspa, chi wirtama chaiag­rir­ka­kuna, lin­tirna, nina sindi i wañu­chi­na­ku­diru cha­rispa. ");
INSERT INTO inb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesuska, tukui imasa pasan­ga­pa kagta iachaspa, chaia­na­kuskata kailla­iaspa, tapurka: —¿Pitatak maska­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chi­ura ainir­ka­kuna: —Nazaret pui­blu­manda Jesus­ta. —Nukami kani— Jesús nirka. Judas paita api­chig­pas­mi chi alwa­sil­kuna­wa karka. ");
INSERT INTO inb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús “Nuka­mi kani” ni­ura, chipi kag­kunaka, katima kuti­rispa, alpama urmar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ikutimi Jesuska tapur­ka­kunata: —¿Pitatak maska­na­kun­gi­chi? Chi­ura ainir­ka­kuna: —Nazaret­manda Jesusta. ");
INSERT INTO inb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chasa aini­ura, Jesuska nirka: —Ñami nirkai­ki­chita: “Nuka­mi kani”. Nukata maska­wa­na­kug­pika, kai nuka­pa runa­kunata ianga kawai­chi ri­chu­kuna—. ");
INSERT INTO inb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chasaka nirkami, ñugpa­manda librupi imasa willa­raiaska­sina tukug­samun­ga­pa. Chi­pika, kasa­mi ni­raiá: “Kam nuka­ta minga­was­ka­kunaka, ñi sug mana chinga­chirka­nichu”. ");
INSERT INTO inb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chi­ura Simón Pedroka, ispada chari­kuskata surkuspa, Malko suti iaia sasir­dutipa lutrinta piaspa, alli ladu rinrita ialigta kuchurka. ");
INSERT INTO inb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus­ka, Pedrota nirka: —Kamba ispadata chura­chi­diru­lla­pita waka­chii. Nukata chaia­wa­kumi, nuka­pa Taita imasa ni­waska­sina iapa llakii iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Chi­uraka suldadu­kunata mandag i judiu­kunapa alwasil­kuna, tukui­kuna, Jesusta apispa, watar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nis­paka, Anas­pag­ma ñugpa chaia­chig­rir­ka­kuna. Anaska, Kaifaspa suigru­mi karka. Kai­faska, chi wata iaia sasir­duti­mi karka. ");
INSERT INTO inb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Chi Kaifasmi, judiu­kunata iuia­chispa, kasa niska karka: “Kai alpapi tukui kaug­sa­na­kuska­manda chaia­kumi, suglla runa wañun­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesusta chaia­chi­na­kug­ri­ura, Simón Pedro i sug kati­raiag­pura kati­chi­na­kurka. Iaia sasir­dutipa wasi kancha ladulla Jesusta iaiku­chig­ri­uraka, chi sug kati­raiagpas iai­kurka, iaia sasir­dutipa rigsidu kaspa. ");
INSERT INTO inb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro, kancha pungu­lla­pi saia­kurka. Ikuti iaia sasir­dutipa rigsiduka, ukupi kaspa, llugsispa, pungu kawag warmita rimaspa, Pedrota iaiku­chirka. ");
INSERT INTO inb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chi­ura chi warmika, Pedrota tapurka: —¿Manachu kampas, Jesusta kati­raiag­pura kangi? —Mana kanichu— ainirka. ");
INSERT INTO inb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iapa chiri kag­manda, iaia sasir­dutipa lutrin­kuna i alwasil­kuna, kilimsa nina sindi­chispa, kunu­na­kurka. Pedropas, pai­kuna­wa kunu­kurka. ");
INSERT INTO inb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Iaia sasir­dutika, Jesusta kati­raiag­kuna­manda i pai ima iacha­chi­kuska­manda paita tapu­chirka. ");
INSERT INTO inb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Chi­ura, Jesuska ainirka: —Tukui kawa­na­kuurami nuka rima­kurkani. Ima­ura­pas tanda­ri­diru wasi­kunapi i Diuspa atun wasi ukupi, maipi tukui judiu­kuna tanda­ri­diru kas­ka­kuna­pi­mi iacha­chi­kurkani. Pakallaka, ñi ima­pas mana rima­kurka­nichu. ");
INSERT INTO inb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ima­pa­tak nukata chasa tapu­chi­wa­kungi? Uia­wag­kunata tapu­chii, nuka ima pai­kunata rimagta. Pai­kuna iachan­kunami nuka ima rimaskata. ");
INSERT INTO inb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús chasa ni­ura, sug alwasil paipa ladu saia­kug, paita puñiti­wa piaspa, nirka: —¿Chasachu atun taitata aini­diru? ");
INSERT INTO inb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chi­ura, Jesuska ainirka: —Imapi nuka mana alli­lla rimaska kag­pika, chita willa­wai. Nuka alli­lla rima­kug­pika, ¿ima­pa­tak pia­wa­kungi? ");
INSERT INTO inb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nigpi Anaska, Jesusta watas­ka­lla kacharka, Kaifás suti iaia sasir­duti­pagma. ");
INSERT INTO inb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chi­kama Simón Pedro, nina kunuspa saia­kurka. Paita kawas­paka, tapur­ka­kuna: —Kampas, ¿manachu Jesusta kati­raiag­pura kangi? Paika ainirka: —Mana kanichu. ");
INSERT INTO inb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chi­ura iaia sasir­dutipa sug lutrin, Pedro rinrita kuchuska runapa­puraka, tapurka: —Jesús ka­diru wirtapi, ¿mana­chu nuka kamta kawarkaiki? ");
INSERT INTO inb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ikuti Pedro ainirka: —Chipika, nukaka manima karka­nichu. Chasa nig­lla­pi, gallu kantarka. ");
INSERT INTO inb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaifas­pag­manda Jesusta apar­ka­kuna Roma­manda man­dag­pa suma tia­ri­diruma. Iapa tutata­mi karka. Judiu­kuna, chi ukuma mana iai­kur­ka­kuna; chasaka, paskua puncha miku­diruta mikui pudin­ga­pa. Mana judíu runa­kunapa wasima iai­kus­paka, mapa­kuna­sina­mi pai­kuna­mandaka ni­raiarka. ");
INSERT INTO inb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chi­manda mandag Pila­toska, kan­cha­ma llugsispa, tapur­ka­kunata: —Kai runa, ¿ima mana alli­lla ruras­ka­manda­tak willa­wan­ga­pa samu­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chi­ura ainir­ka­kuna: —Kai alli­lla rurag kag­pika, mana­char kam­bagma apa­mun­tran­chi. ");
INSERT INTO inb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatoska nirka: —Chasa kagpika, kam­kuna iachai­chi. Imasa kam­kunapa ñugpa­manda librupi ni­raiaska­sina paita rurag­rii­chi. Chasa ni­ura, judiu­kuna nir­ka­kuna: —Nukan­chita mana lisin­sia­ra­ian­chu, ñi pi­ta­pas wañu­chin­ga­pa—. ");
INSERT INTO inb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chasa nir­ka­kuna, Jesús kikin imasa pai wañun­ga­pa kagta, ñugpa willaska­sina tukug­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatoska, pai suma tia­ri­diru­ma ikuti iai­kus­paka, Jesusta kaiaspa, tapu­chirka: —Kam, ¿judiu­kunapa atun man­dag­chu kangi? ");
INSERT INTO inb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Chi­ura, Jesuska ainirka: —¿Kamba iuiai­lla­wachu chasa nin­gi? Mana kag­pika, ¿sug­kuna­chu kamta chasa nuka­manda nir­ka­kuna? ");
INSERT INTO inb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Nuka, mana judíu ka­ni­chu— Pila­tos ainirka—. Kamba alpa­manda runa­kuna i iaia sasir­du­ti­kuna­mi kamta kaima apa­mur­ka­kuna. ¿Imatak ruraspa puri­kur­kan­gi? ");
INSERT INTO inb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Chi­ura, Jesuska ainirka: —Nuka­pa mandai, kai alpa­manda mana kanchu. Kai alpa­manda nuka­pa mandai kag­pika, nuka­pa runa­kunachar micha­wan­tra­kuna, judiu­kuna mana api­wan­ga­pa. Kai alpa­manda, nuka­pa man­dai mana kanchu. ");
INSERT INTO inb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Chi­ura, Pilatos tapurka: —Chasa kagpika, ¿atun man­dag­chu kangi? —Kam alli­llami ningi— Jesuska ainirka—, “Nuka, atun mandagmi kani”. Chasa­pa­mi nuka kai alpama samurkani, ñi imapi mana llu­llas­pa­lla sutipa kaskata willan­ga­pa. Mai­kan sutipa kaskata uian­ga­pa munag­kuna, nuka ima rimaskata uia­wan­kunami. ");
INSERT INTO inb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chasa uiaspa, Pila­toska nirka: —Kam chi sutipa kaskata willa­kuska, ¿imatak ni­raiá? Chasa nis­paka Pila­tos, kan­cha­ma ikuti llugsispa, judiu­kunata nirka: —Chi runata mana tari­nichu, ñi ima­pas panda­riska kagta. ");
INSERT INTO inb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kam­kuna imasa kustum­bri kaska­sina, sug runata kacha­ringa­pa­mi cha­ia­wá, paskua puncha chaia­kug­manda. Nig­pika, ¿munan­kan­gi­chi­chu, judiu­kunapa atun mandagta nuka kacha­rin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Judiu­kunaka, ikuti kapa­rispa, nir­ka­kuna: —Paitaka, mana. Barra­basta kacha­rii—. Barra­bás, iapa sisaimi karka. ");
INSERT INTO inb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Chi­ura Pilatoska, Jesusta mana llakispa­lla iapa asuti­chirka. ");
INSERT INTO inb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Chi­ura­manda sul­da­du­kunaka, ispina­kunalla llaugtu sim­baspa, paita umapi chura­chir­ka­kuna. Sutipa mandag­sina kawa­rin­ga­pa, pichi katanga­pas kata­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nis­paka, paita kamispa, kai­lla­iaspa, nii kalla­rir­ka­kuna: —Puangi, kam judiu­kunapa atun mandag. ¿Alli­llachu ka­puan­gi?—. Chasa nis­paka, paita puñiti­wa piaspa richir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Chi­ura­manda Pilatoska, ikuti kan­chama llugsispa, judiu­kunata nirka: —Kawamui­chi. Kai kancha­ma­mi pusamu­kuni, kam­kuna kawan­ga­pa: paita mana tari­nichu, ñi ima panda­riska kagta. ");
INSERT INTO inb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chi­ura Jesús, ispina­kunalla llaugtu chura­chii tukuska, pichi katanga kata­rispa, kanchama llug­sirka. Chi­ura, Pila­toska nir­ka­kunata: —Kawamui­chi kai runata. ");
INSERT INTO inb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesusta kawaspa, iaia sasir­du­ti­kuna i alwasil­kunaka kapa­rir­ka­kuna: —Kruspi churai. Kruspi chu­raspa wañu­chii. Chasa uiaspa, Pila­toska nirka: —Kam­kuna paita apai­chi, krus­pi churan­ga­pa. Nukaka mana tari­nichu, pai ñi ima panda­riska kagta. ");
INSERT INTO inb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chi­ura, judiu­kunaka ainir­ka­kuna: —Nukan­chipa mandaraiaskapi ni­raianmi, mai­kan­pas Taita Diuspa wam­bra tukuska nigta wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Chasa rimaskata uias­paka, Pila­tos masmi mancha­rirka. ");
INSERT INTO inb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chi wasi ukuma ikuti iai­kus­paka, Jesusta tapurka: —Kam, ¿mai­mandatak kangi? Jesuska, mana ima­pas ainirka. ");
INSERT INTO inb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ikuti Pilatos tapurka: —¿Imapatak nukata mana aini­wangi? ¿Manachu iachangi, nuka kamta kacha­rin­ga­pa u kruspi chura­chin­ga­pa pudigta? ");
INSERT INTO inb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chi­ura, Jesuska ainirka: —Awa luar­nig­manda kamta mana kuag­pika, manachar pudin­trangi ñi ima­pas nukata rura­wan­ga­pa. Chi­manda kam­bag­ma apa­mu­wag­kuna, kam­manda mas atun panda­rii­kuna­mi iukan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chi­ura­manda, Pila­tos mas­ka­kurka, imasa­pipas Jesusta kispi­chin­ga­pa. Judiu­kunaka, mas sin­chi mas sin­chi kapa­rir­ka­kuna: —Chi runata kacha­rig­pika, kam­ka Romapi iaia mandagwa mana­char kan­kangi ñi paipa rig­si­du­sina­lla­pas. Mai­kan­pas atun man­dag tukun­ga­pa munag, Romapi iaia mandagta llugsi­chinga­pa­mi muná. ");
INSERT INTO inb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chasa uiaspa Pila­toska, Jesusta llugsi­chispa, atun mandag jus­ti­siai rura­dirupi tia­rig­rirka. Chi tia­ri­diru suti karkami “Rumi­wa alpa pambaia­chiska”. Hebreo rimai­waka suti karkami “Gabata”. ");
INSERT INTO inb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pas­kua atun punchapa alli­chi­diru puncha, chara tutata­mi karka. Tia­rig­ris­paka, Jesusta kawa­chispa, judiu­kunata nirka: —Kawamui­chi kam­kunapa atun mandagta. ");
INSERT INTO inb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pai­kunaka kapa­rir­ka­kuna: —Anchu­chii. Anchu­chii. Kruspi churaspa wañu­chii. Chi­ura, Pilatos tapurka: —¿Kam­kunapa atun mandag­ta­chu kruspi klaba­chisa? Chi­ura, iaia sasir­duti­kunaka ainir­ka­kuna: —Roma­manda iaia mandag­lla­mi nukan­chika iukan­chi. Ñi sug mas man­dag mana iukan­chi­chu. ");
INSERT INTO inb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chi­ura Pilatoska, Jesusta krus­pi klaban­ga­pa kacharka. Chi­manda, Jesusta llugsi­chispa apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesuska, krusta markaspa, Uma Tullu suti pambama rii kalla­rirka. (Chi pamba, hebreo rimai­wa suti karkami Gólgota.) ");
INSERT INTO inb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chipi chaiag­ri­uraka, paita kruspi kla­bar­ka­kuna. Sug iskai­kuna­ta­pas pai­wa sug­lla­pi kruspi atari­chir­ka­kuna, sug sug kada ladu, Jesuska chaugpipi. ");
INSERT INTO inb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos kasa iskribiska chu­ran­ga­pa kacharka: “Naza­ret­manda Jesús, judiu­kunapa atun mandag”. Chasa willa­raiaskataka krus uma awa ladu churar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jesusta kruspi churaska­manda, Jeru­salén pui­bluma mana karu­lla­mi karka. Chi willa­raiaska, hebreo, latín i griego rimai­pi­mi iskribi­raiarka. Chitaka, achka judiu­kuna kawar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chi­manda iaia sasir­duti­kunaka, Pila­tosta nig­rir­ka­kuna: —Mana chasa chura­kui: “Judiu­kunapa atun mandag”. Chasapaka, kasa ni­raiachu: “Pai kikinmi ni­rirka: ‘Judiu­kunapa atun mandagmi kani’.” ");
INSERT INTO inb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatoska ainirka: —Nuka churaska kaska, churaska­mi ka. ");
INSERT INTO inb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Suldadu­kunaka, Jesusta kruspi churaspa, paipa katan­ga­kunata chuskuma churar­ka­kuna; chasaka, suldadu­pura sug sug apan­ga­pa. Jesús chura­raiaska kusma­sinaka, awa­manda­ta ura­kama tukui awaska­lla­mi karka, ñi imapi mana siraska. ");
INSERT INTO inb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chi­manda suldadu­kunaka, pai­pura rima­rir­ka­kuna: —Kaitaka mana lliki­chi­sun­chi. Suirtipi puglla­sun­chi. Chasaka kawa­sun­chimi: pita­mi chaiá—. Ñugpa­manda librupi, kasa­mi willa­raiarka: “Nuka­pa katan­ga­kunata pai­pura­mi rasiuna­rir­ka­kuna. Nuka chura­raiaska kusma­sinataka suirti­pi­mi pugllar­ka­kuna”. Chasa­mi suldadu­kuna rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesusta klabaspa atari­chiska­pi, paipa mama ñañan­dimi sug­lla­pi saia­na­kurka. María suti Kleofaspa warmi i María Magda­le­na­pas, chi­lla­pita pai­kuna­wa karka. ");
INSERT INTO inb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Paipa mama i paipa sug iapa kuiaska kati­raiag sug­lla­pi saia­na­kugta, Jesús kawarka. Chasa kawas­paka, maman­dita nirka: —Kamba wam­brata kawai. ");
INSERT INTO inb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chasa­lla­ta, chi kati­raiagtaka nirka: —Kamba mamata kawai. Chi­ura­mandaka, paipa wasima Jesuspa mamata pusarka, chipi kaug­san­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesuska ña iacharka, tukui imasa kikin­manda willa­raiaska­sina puchuka­ri­kugta. Chi­manda­mi, ñugpa­manda librupi imasa willa­raiaska­sina tukug­samun­ga­pa, nirka: —Ia­kunaia­wa­kumi. ");
INSERT INTO inb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chipi tiarka winja binu sug uchulla mangapi junda­chiska. Chi binutaka sug ispunja­wa aisaspa, hisopo suti birbina sacha­sina chaglla puntapi churaspa, Jesuspa simima atari­chirka, chupa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Chi binuta chupas­paka, Jesuska nirka: —Tukuimi imasa willa­raiaska­sina tukug­samurka—. Chasa nis­pa­ka, uma kumu­rispa, paipa ispi­ri­tuta Taita Diusta mingaspa, wañurka. ");
INSERT INTO inb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Warda punchapa tukui suma alli­chi­diru puncha karka. Kaiandika warda puncha kag­manda, judiu­kuna mana munar­ka­kuna, kuir­pu­kunata kruspi sakin­ga­pa. Chi kaiandi iapa atun warda puncha kag­manda, pai­kunaka Pila­tosta mañag­rir­ka­kuna: —Kruspi churas­ka­kunata chaki­kunata paki­chispa, chi­manda anchu­chii. ");
INSERT INTO inb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pilatoska: —Chasa rurai­chi— nirka. Chi­ura suldadu­kunaka, rispa, Jesus­wa sug­lla­pi klaba­raias­ka­kuna­pagma chaiag­ris­paka, sugpa chaki­kunata paki­chir­ka­kuna. Sug­ta­pas chasa­lla­ta rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ikuti Jesus­pagma kailla­ias­paka, ña wañuska kagta kawar­ka­kuna. Chi­wa, chaki­kunata paki­chinga­taka, ");
INSERT INTO inb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","sug suldadu, lansa­wa kusti­lla­pi tugsirka. Tugsig­lla­pi, iawar i iakumi llugsirka. ");
INSERT INTO inb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Sutipa chasa kawagmi willa­ku; chasaka kam­kuna­pas, sutipa kagta iachan­ga­pa. Nuka kikinmi iachani, sutipa willa­kugta. ");
INSERT INTO inb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Ñug­pa­manda librupi, kasa­mi willa­raiá: “Ñi sug tullu, mana paki­chiska kan­ga­pa kanchu”. Kasa­pas. “Pai kikin­kuna­mi ialigta tugsiskata kawan­ga­pa kan­kuna”. Imasa willa­raiaska­sina­mi tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chi­ura­manda Arimatea pui­blu­manda José suti runaka, Pila­tosta mañag­rirka, Jesuspa kuir­puta apan­ga­pa. Chi José, judiu­kunata manchaspa, pakalla Jesus­wa rima­na­ku­diru­mi karka. Chasa mañag­ri­uraka, Pila­tos paita apan­ga­pa sakirka. Chi­ura Joseka, rispa, Jesusta krus­manda urai­ku­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo ñugpata Jesus­pag­ma tuta ri­durpas chaiag­rirka. Mira i aloes suti suma asna cha­pus­ka, mai patsa libra­sina chaia­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chi iskandi runa­kuna, Jesuspa kuir­puta apas­paka, chi suma asna­kuna­wa suma linsu­kuna­wa maitur­ka­kuna, imasa judiu­kuna rura­dur kaska­sina. ");
INSERT INTO inb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús kruspi klaba­raiaska­manda mana karu­lla­pi tiarka sug wirta. Wirta­pika tiarka rumi piñapi atun utku­chiska, wañuskata pam­ban­ga­pa. Chi ukupi ñi pita manara pambaska karka. ");
INSERT INTO inb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chi utku­chiska manancha karu­lla­pi kag­manda, chipi Jesuspa kuir­puta churag­rir­ka­kuna. Chi chisi judiu­kunapa warda puncha ña kalla­rin­ga­pa kag­manda, utkalla chasa rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Simana kalla­rii puncha u dumingu amsamsa chara tuta kagpita, María Magdalenaka Jesús pamba­raiaska­ma rirka. Cha­iag­ris­paka, chi atun utku­chiska pun­gu­pi kilpa­raiaska rumita tim anchu­chiska kaskata kawag­rirka. ");
INSERT INTO inb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Chasa kawas­paka, kalpalla rirka Simón Pedro i Jesuspa sug iapa kuiaska kati­raiag­pagma. Chaiag­ris­paka, pai­kunata nirka: —Iaia Jesuspa kuir­puta pamba­raiaska­manda apaska­mi ka. Mana iachan­chi­chu maipi paita churagta­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chi­ura Pedro i chi sug kati­raiag­pura, llugsispa, Jesús pamba­raiaska­ma kalpar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iskandi, sin­chi kalpa­na­kurka. Sugka, Pedro­manda mas ñugpa kalpaspa, chaiag­rirka. ");
INSERT INTO inb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nis­paka, kumu­rispa, uku­sinama kawarka. Chi uku­pika, suma linsu maitu­raias­ka­kuna tiarka. Chasa kawaspa­pas, mana iai­kurka. ");
INSERT INTO inb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedroka, kati chaiag­rispa, ukuma iaikug­rirkalla. Paipas, chi suma linsu maitu­raias­ka­kunata chipi churaska kaskata kawarka. ");
INSERT INTO inb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sug linsu Jesuspa umata maitu­raiaska­ta­pas kawarka. Chi linsu, sug­kuna­wa mana sug­lla­pi tiarka. Sug­pi­mi pata­riska tiarka. ");
INSERT INTO inb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Chi­ura chi sug kati­raiag Pedro­manda ñugpa chaiag­rigpas, ukuma iai­kurka. Chi linsu­kunata kawas­paka, iuia­rirka: “Sutipa­mi kaska”. ");
INSERT INTO inb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pai­kuna manara iuia­rir­ka­kuna, ñugpa­manda librupi imasa willa­raiaskata: “Chaia­kumi, Cristo wañuspa­pas, ikuti kaugsa­rin­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chasa kawas­paka, chi iskandi kati­raiag­kuna kikinpa wasima kutir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariaka, Jesús pamba­ra­ias­kapi kancha ladulla wakaspa saia­kurka. Waka­kus­paka, kumu­rispa, ");
INSERT INTO inb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","uku­sinama kawarka. Chi­pika, iskai anjil iura chura­ris­ka­kuna kar­ka­kuna. Pai­kuna, Jesuspa kuir­puta churaska kaskapi tia­na­kurka, sugka uma ladu, sugka chaki ladu. ");
INSERT INTO inb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pai­kunaka, Mariata tapur­ka­kuna: —Kam warmisita, ¿imapatak waka­kungi? Chi­ura, María ainirka: —Nuka­pa iaiatami apa­puar­ka­kuna. Nuka mana iacha­nichu maipi chura­puag­rigta­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chasa ainis­paka, katima tigrarka. Chi­ura, Jesús saia­kuskata kawarka. Chasa kawaspa­pas, mana iacharka Jesús kagta. ");
INSERT INTO inb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Chi­ura, Jesuska tapurka: —Kam warmisita, ¿imapatak waka­kungi? ¿Pitatak maska­kungi? Mariaka, “Wirta kawagchar ka” iuiaspa, ainirka: —Turi, kam paita apaska kag­pika, willa­wai: ¿maipitak churag­rirkangi?, nuka apag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Chi­ura, Jesuska nirka: —María. Chasa uianga­lla­wa, tigra­rispa, hebreo rimai­wa nirka: —Rabuni—. (Rabuni ni­raianmi “Nuka­pa iacha­chig”.) ");
INSERT INTO inb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Chi­ura, Jesuska nirka: Mana llamka­wai. Manara nuka­pa Taita­pagma sika­nichu. Nuka­pa waugki­kunata willag­rii: “Nuka­pa i kam­kunapa Taita­pag­ma­mi sikan­ga­pa kani. Nuka­pa i kam­kunapa Taita Dius­mi ka”. ");
INSERT INTO inb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Chasa uiaspa, María Magda­le­naka Jesusta kati­raiag­kunata kalpa­lla willan­ga­pa rirka: —Iaia Jesus­ta­mi kawarkani—. Nis­paka, imasa Jesús niska­sina willar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chi dumingu­lla­tata chisima, Jesusta kati­raiag­kuna, judiu­kunata dimanchai pungu­kunata suma wichka­rispa, chi ukuma kar­ka­kuna. Mai­kan punguta mana iai­kuspa­lla, Jesuska, pai­kunapa chaugpipi saia­rig­samuspa, nir­ka­kunata: —¿Alli­llachu ka­puan­gi­chi?—. ");
INSERT INTO inb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chasa nis­paka, maki­kunata i kus­ti­lla­ta kawa­chir­ka­kunata. Iaia Jesusta kawas­paka, pai­kuna iapa kun­tin­ta­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ikuti —¿Alli­llachu ka­puan­gi­chi?— nis­paka, Jesuska nir­ka­kunata— Nuka­pa Taita imasa­mi nukata kacha­mu­warka: chasa­lla­ta­mi nuka­pas, kam­kunata kachai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Chasa nis­paka, pai­kunata samai churaspa, nirka: —Santu Ispi­ri­tuta chaskii­chi. ");
INSERT INTO inb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mai­kan panda­ris­ka­kunata kam­kuna pasin­siaska nig­pika, pa­sin­siaskami tukun­ga­pa kan­kuna. Ikuti mai­kan panda­ris­ka­kunata kam­kuna mana pasin­siaskaka, chasa­lla­ta­mi mana pasin­siai tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús ñugpa kawa­ri­ura, To­más, Dídimo suti, chunga iskai Jesús agllas­ka­kuna­pura, mana sug­lla­pi karka. Paitaka, sug kati­raiag­kuna nir­ka­kuna: —Iaia Jesustami kawarkan­chi. ");
INSERT INTO inb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chi­ura, paika nirka: —Klabus­kuna maki­kunapi utku­chis­ka­kunata nuka mana kawa­sa; chipi nuka­pa didu mana chura­sa; kustilla utku­chiska­pi­pas nuka­pa maki mana ñitisa; chasa mana kawaspa, mana iuian­ga­pa ka­ni­chu chasa kagta. ");
INSERT INTO inb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pusag puncha iali­ura, Jesus­ta kati­raiag­kuna chasa­lla­ta wasi­pi tanda­riska kar­ka­kuna. Chi­uraka Tomaspas, sug­lla­pi karka. Pungu­kuna suma wichka­rispa kag­pi­pas, Jesuska, pai­kunapa chaug­pi­pi saia­rig­samuspa, nir­ka­kunata: —¿Alli­llachu ka­puan­gi­chi?—. ");
INSERT INTO inb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chasa nis­paka, Tomasta kaiaspa, nirka— Kamba diduta kaipi churai. Nuka­pa maki­kunata kawai. Kamba makita sunia­muspa, nuka­pa kusti­lla­pi ñitii. Mana iuia­wag kanga­taka, suma iuia­wag kai. ");
INSERT INTO inb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Chi­ura, Tomás ainirka: —Nuka­pa Iaia i nuka­pa Dius­mi kangi. ");
INSERT INTO inb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Chi­ura, Jesuska nirka: —Kam, nukata kawa­waspa­mi suma iuia­warkangi. Mana kawa­waspa­lla nuka­manda suma iuia­wag­kunaka, Taita Diuspa iapa kuias­ka­mi kan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusta kati­raiag­kunapa ñawi­pi, achka mana ima­ura­pas kawaska­sina pai ruraskaka, kai librupi mana tukui willa­raianchu. ");
INSERT INTO inb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kaipi willa­raiaskaka kanmi, Jesús, Taita Dius agllaska Cristo i paipa wam­bra kagta, kam­kuna iachaspa iuia­rin­ga­pa; chasa iuia­ris­paka, pai­wa mana wañu­diru kaug­saita iukan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chi­ura­manda, Tiberias suti kucha pata­lla­pi, Jesus­ka paita kati­raiag­kunata kasa­mi ikuti kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro, Tomás Dídimo, Gali­lea alpa i Kaná pui­blu­manda Natanael, Zebe­deo­pa wam­bra­kuna i sug iskai kati­raiag­kuna­pas, sug­lla­pi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Chi­ura, Simón Pedroka nirka: —Nukaka chalwag­risa. —Nukan­chipas munan­chi­mi kamwa rin­ga­pa— nir­ka­kuna. Chasa nis­paka, tukui­kuna, kanuapi iai­kuspa, rir­ka­kuna. Chi tutaka, ñi sug chalwa manima apir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ña paka­ri­ku­uraka, Jesús kucha patapi kawa­rig­rir­ka­kunata. Paita kawaspa­pas, kati­raiag­kuna mana iachar­ka­kuna Jesús kagta. ");
INSERT INTO inb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Chi­uraka, paika tapur­ka­kunata: —Musu­kuna, ¿ñachu chalwa apin­gi­chi? Chi­ura ainir­ka­kuna: —Manima. ");
INSERT INTO inb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Chi­ura, paika nirka: —Kanua alli ladu ata­raiata sitai­chi, apin­ga­pa. Sitag­lla­pi, iapa achka chalwa apir­ka­kuna. Iapa llasa kag­manda, mana pudir­ka­kuna, kanuama ata­raiata sika­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Chi­uraka chi Jesuspa iapa kuiaska kati­raiag, Pedrota nirka: —Iaia Jesusmi ka. Iaia Jesús kagta uiaspa, Simón Pedroka, llatan kaspa, paipa katangata chura­rispa, iakuma saltarka, Jesus­pagma rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kanua­manda kucha patama chaiag­rin­ga­paka, mana iapa karu karkachu. Kimsa chunga tupu­sina­lla­mi karka. Chi­manda sug­kuna, chalwa junda ata­raiata iakupi aliuspa, kanua­wan­ta patama chaia­chig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kanua­manda alpa­ma llugsi­uraka, kilimsa nina sindi awalla sug chalwa kusa­ri­kugta i tanda tiaskapas kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chaiag­ri­ura, Jesuska nir­ka­kunata: —Kuna­ura apiska chalwa­kunata apag­rii­chi. ");
INSERT INTO inb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chi­ura Simón Pedroka, kanua­pi iai­kug­rispa, ata­raiata alpama aliurka. Ata­raia­pika, patsa pichka chunga kimsa atun chalwa­kuna­mi tiarka. Chi­tuku achka chalwa­kuna junda tiagpi­pas, ata­raia mana lliki­rirka. ");
INSERT INTO inb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Chi­ura­manda, Jesuska nir­ka­kunata: —Samui­chi mikun­ga­pa. Iaia Jesús kagta iachas­paka, ñi mai­kan kati­raiag­kuna mana tapur­ka­kuna: “Kam, ¿pitak kan­gi?”. ");
INSERT INTO inb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kailla­ias­paka, Jesuska, tanda i chalwata aisaspa, kati­raiag­kunata kararka. ");
INSERT INTO inb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesús wañuspa kaugsa­riska­ura­manda, ña kimsa­ma­mi paita kati­raiag­kunata kawa­rig­rirka. ");
INSERT INTO inb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ña mikuska­ura­mandaka, Jesuska Simón Pedrota tapurka: —Jonaspa wam­bra Simón, ¿kai­kuna­manda­pas maschu nukata kuia­wangi? Chi­ura, Pedro ainirka: —Ari, taita waugki. Kam iachan­gimi, nuka imasa kamta kuiagta. Chi­ura, Jesuska nirka: —Nuka­pa kuiaska ubija wawa­kuna­sinata kawa­puangi. ");
INSERT INTO inb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nis­paka, ikuti tapurka: —Jonaspa wam­bra Simón, ¿nukata kuia­wangichu? Chi­ura, Pedro ainirka: —Ari, taita waugki. Kam iachan­gimi, nuka imasa kamta kuiagta. Chi­ura, Jesuska nirka: —Nuka­pa ubija­kuna­sinata kawag ka­puangi. ");
INSERT INTO inb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kimsama ikuti nirka: —Jonaspa wam­bra Simón, ¿nuka­ta kuia­wangichu? Chi­ura Pedroka, Jesús paita kimsama: “¿Nukata kuia­wan­gi­chu?” tapu­kug­mandaka, ir­kiar­ka. Llakii­wa nirka: —Taita waugki, kam, tukui alli­lla­mi iachan­gi. Sumag­lla­mi iachan­gi, nuka imasa kamta kuiag­ta. Chi­ura, Jesuska nirka: —Nuka­pa ubija­kuna­sinata kawa­puangi. ");
INSERT INTO inb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kasa­mi nuka niiki: kam chara musu ka­uraka, kam kikin­mi, chum­billi­rispa, maima munaska­ma ri­dur karkangi. Ikuti kam ruku­iaska ka­uraka, maki­ta­mi chuta­chin­kangi. Sugmi, kamta chumbi­lli­chispa, kam maima mana muna­kus­kama apanga—. ");
INSERT INTO inb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús, chasa nis­paka, willa­kurkami Pedro imasa wañun­ga­pa kagta; chasa wañus­paka, Taita Diusta suma atun­ia­chin­ga­pa. Chasa nis­paka, kasa­pas­mi nirka— Nukata kati­wai. ");
INSERT INTO inb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Katima tigras­paka, Pedro kawarka, Jesús iapa kuiaska kati kati kati­raiagta. Pai runa karkami paskua atun puncha miku­diru miku­naku­ura, Jesusta kimi­rispa tapug, kasa nispa: “Taita waugki, ¿pitak kamta api­chin­ga­pa ka?”. ");
INSERT INTO inb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Paita kawas­paka, Pedroka Jesusta tapurka: —Taita waugki, paipas, ¿imatak pasanga? ");
INSERT INTO inb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesuska ainirka: —Nuka ikuti samun­kama kaug­sa­kuchu nig­pika, kamtaka, ¿ima­tak ministí? Kam, upalla nuka­ta kati­wai. ");
INSERT INTO inb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chasa niskata mana alli­lla uiaspa, Jesus­wa tukus­ka­kuna rima­na­kuskata iacha­rirka, kasa nigta: “Kai Jesusta kati­raiag, ñi ima­ura­pas mana wañun­ga­pa kanchu”. Chasaka, Jesús mana nirkachu. Kasa­mi nirka: “Nuka ikuti samun­kama kaug­sa­kuchu nig­pika, kam­taka, ¿imatak ministí?”. ");
INSERT INTO inb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pai Jesusta kati­raiagmi imasa kawaska­sina willa­ku. Kai libruta iskri­bigpas, pai­lla­ta­ta­mi ka. Iachan­chimi, ñi ima­pipas mana llullaspa­lla sutipa kaskata pai willagta. ");
INSERT INTO inb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sug rigcha sug rigcha alli­kuna­ka, achkami Jesús rurarka. Chi tukui ima ruras­ka­kuna­manda sug suglla iskribi­raiag­pika, iuia­nimi: kai alpapi manachar pagtan­tra, chi iskribi­raias­ka­kunata maipi waka­chinga.");
INSERT INTO inb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nuka­pa kuiaska Teófilo: Nuka ñugpata willa­raias­kapi, Jesús tukui ima ruraska i iacha­chiska, kalla­ri­ura­manda­ta pai ima­ura suma luarma sikan­kama willarkaiki. ");
INSERT INTO inb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Manara suma luarma sikaspa­lla, sug runa­kunata agllaspa kacharka, pai­manda Alli Willaita willaspa purin­ga­pa. Nis­paka, Santu Ispi­ri­tu­wa­mi iacha­chir­ka­kunata imasa ruran­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ña wañuska­ura­manda kaug­sa­ris­paka, chusku chunga punchami ikuti ikuti kawa­rir­ka­kunata, pai sutipa kaugsa­riska kagta alli­lla iachan­ga­pa­kuna. Chi puncha­kuna, Taita Dius imasa suma manda­kus­ka­sina iacha­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chara pai agllaska runa­kuna­wan­ta kaspa, Jesuska nir­ka­kunata: —Ñami willarkai­ki­chita: nuka­pa Taita, kikinpa Santu Ispi­ri­tuta karan­ga­pa­mi nirka. Paita kacha­mun­kama, Jeru­salén pui­blupi suian­gi­chi. Mana mai­ma­pas ri­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Iaku­lla­wa­mi Juan baug­ti­sarka. Kam­kunakar, mai­lla puncha­kuna iali­ura­manda, Santu Ispi­ri­tu­wa­mi baug­ti­sai tukun­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pai­kuna ikuti tanda­riska kas­ka­pi, Jesusta tapur­ka­kuna: —Taita waugki, ¿kai puncha­kuna­chu kuan­kangi, nukan­chi Israel­manda runa­kuna ikuti kai alpapi mandan­ga­pa? ");
INSERT INTO inb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Chi­ura, Jesuska ainirka: —Kam­kuna mana iachan­ga­pa kan­gi­chi­chu, ima ura, ima puncha nuka­pa Taita chasa ruran­ga­pa kagta. Pai­lla­mi iachá, ima puncha chasa tukug­samun­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kam­kunapa sungupi Santu Ispí­ritu iai­kug­samu­uraka, paipa iapa iachai­ta­mi chaskin­ga­pa kan­gi­chi. Chi iachai­waka, kai Jeru­sa­lenpi, Judea i Sama­ria alpa­kuna­pi i tukui karu suiu­pas­mi nuka­manda willag­rin­ga­pa kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chasa nis­paka, pai­kuna kawa­na­kug­lla­pi, Jesús suma luarma sikai kalla­rirka. Puiu ukupi chinga­rig­rirka. Mana mas pai­kunata kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús suma luarma sika­kus­kata kawa­na­ku­uraka, diulpilla iskai runa­sina rigcha­kuna iura katanga chura­ris­ka­kuna pai­kuna saia­na­kus­kata kawa­rig­samur­ka­kunata. Chi runa­kunaka nir­ka­kuna: ");
INSERT INTO inb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—Galilea­manda runa­kuna, ¿imapatak awa­sinama kawa­na­kun­gi­chilla? Pai Jesús ña suma luarma sikaska, ikutimi samun­ga­pa ka; imasa­mi kam­kuna sikai kawarkan­gi­chi: chasa­lla­ta. ");
INSERT INTO inb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chasa uias­paka, chi runa­kunaka chi Olivos suti luma­manda Jeru­sa­lenma kutir­ka­kuna. (Chi luma­manda Jeru­sa­lenma manan­cha karumi ka; imasa­mi warda puncha lisin­siaska ka purin­ga­pa: chilla karumi ka.) ");
INSERT INTO inb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jeru­sa­lenma chaiag­ris­paka, kida­ri­diru wasima iai­kuspa, chi awa ladu ukuma sikar­ka­kuna. Chipi tanda­ridu­pura kar­ka­kunami Pedro, Juan, San­tiago, Andrés, Felipe, Tomás, Bar­to­lomé, Mateo, Alfeopa wam­bra suti Santiago, Simón suti kananeo runa­kuna­wa purig­pura i Judas suti sug Santiagopa wam­bra. ");
INSERT INTO inb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tukui pai­kuna, sug­lla iuiai­wa Taita Diusta mañaspa kar­ka­kuna, mana kunga­rispa­lla. Sug warmi­kuna­pas­mi pai­kuna­wa sug­lla­pi kar­ka­kuna. Jesuspa mama María i Jesuspa waugkindi­kuna­pas­mi chipi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chi puncha­kuna, mai patsa iskai chunga runa­kunami chi ukupi sug­lla­pi kar­ka­kuna. Tukui­kuna chasa ka­uraka, Pedroka, chaugpipi saia­rispa, kasa­mi nirka: ");
INSERT INTO inb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","—Taita­kuna i mama­kuna, uia­mui­chi. Judas­mandaka, atun taita David, Santu Ispi­ri­tu­wa ñugpa­manda librupi willa­ra­iaskaka, imasa nis­ka­sina­mi tukug­samurka. Chi Judaska, nukan­chi­pura­mi karka. Nukan­chi­sina­lla­ta, pai­pas agllaska­mi karka, Jesus­manda willa­dur kan­ga­pa. Chi Judas­mi, Jesusta katuspa, apig­kunata pusaspa kawa­chig­rirka. ");
INSERT INTO inb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Chasa Jesusta katus­paka, alpa­sik randirka. Nis­paka, chi alpapi urai singa urmaspa, tugiarkasi, chun­chu­llu­kuna llugsigta. ");
INSERT INTO inb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Chasa iacha­ris­ka­ura­mandaka, Jeru­sa­lenpi tukui kaug­sa­na­kugmi chi alpata pai­kunapa rimai­wa suti­chir­ka­kuna Akél­dama—. (Chi ni­raianmi “Iawar alpa”.) ");
INSERT INTO inb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","—Chi Judas­mandaka, Salmos suti librupi kasa­mi willa­raiá: Paipa wasi sitai tuku­chu, ñi pipas mana chipi kaug­san­ga­pa. Paipa trabaju sakis­ka­taka, sug apichu. ");
INSERT INTO inb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Chasa willa­raiaska­mandaka, kuna­ura nukan­chi­ta­mi chaia­ku, sug runa agllan­ga­pa. Iaia Jesús nukan­chi­wa ka­ura, sug kaipi kag­kuna­pas­mi nukan­chi­wa puri­dur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Iaia Jesusta Juan baug­ti­saska­ura­manda­ta, pai suma luarma sika­ura­pas­mi chi runa­kuna­pas nukan­chi­wa sug­lla­pi kar­ka­kuna. Chi runa­pura­taka, sug­lla­ta aglla­sun­chi, paipas Jesús kaugsa­ris­kata nukan­chi­wa willa­dur kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pedro chasa ni­ura, pai kikin­pura iskai runa­kunata agllar­ka­kuna. Sug runa suti karka José Bar­sabás. Paita nir­ka­kuna: “Alli José”. Sugka, Matiasmi suti karka. ");
INSERT INTO inb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chi iskandi­kunata agllas­paka, Taita Diusta mañaspa, nir­ka­kuna: —Taitiku, kammi kangi tukui­kunapa sunguta rigsig. Chi­manda, nukan­chita kawa­chii: kai iskandi­kuna­mandaka, pitatak agllan­kangi, ");
INSERT INTO inb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Jesus­manda willa­dur kan­ga­pa; paika, Judaspa kuinta tukun­ga­pa. Chi Judas, Jesusta katuspa­mi, pai­manda willa­dur kas­kata sakispa, wañuspa, maima paita chaia­kuska­ma rirka. ");
INSERT INTO inb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Taita Diusta chasa mañas­paka, suirti­pi­mi maskar­ka­kuna. Chi­uraka, Matias­manda­mi llug­sirka. Chi­ura­lla, pai­taka cha­iarka, chunga sug Jesús kikin agllas­ka­kuna­wa sug­lla­pi tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés suti atun puncha chaia­mu­ura, Jesus­wa tukui tukuska runa­kuna, sug­lla­pi tanda­riska kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Diulpilla, chi uku­pi tia­na­kuska suiu, suma luar­manda sin­chi waira puku­kug­sina­mi uia­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chi­ura, puka nina sindi­sina­mi kawa­rig­samurka. Nis­paka, tukui­kunapa uma awa ladu sug sug tia­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Santu Ispi­ri­tumi tukui­kuna­pa sungupi iai­kug­samurka. Chi­ura, Santu Ispí­ritu imasa iuia­chis­ka­sina mana iachaska rimai­kuna­wapas rimai kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chi puncha­kuna, tukui alpa­nig­manda Jeru­sa­lenma chaiaska kar­ka­kuna Taita Dius­wa suma iuiaspa kaug­sag judiu­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Chi sin­chi uia­ris­kata uias­paka, iapa achka­kuna, Jesus­wa tukus­ka­kuna kida­ri­diru wasima tanda­rig­rir­ka­kuna. Chi­pika, tukui alpa­manda pai­kunapa rimaita uiaspa, mana iachar­ka­kuna, ima­manda chasa tukug­samugta. ");
INSERT INTO inb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iapa mancha­rispa ujna­rispa, rima­ri­na­kurka, kasa nispa: —Kai tukui rima­na­kug, ¿mana­chu Gali­lea alpa­manda runa­kuna kan­kuna? ");
INSERT INTO inb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nig­pika, ¿imasa­manda­tak tukui nukan­chi, sug rigcha sug rigcha uchulla ka­ura­manda­ta rimai­kunata alli­lla uia­na­kun­chi? ");
INSERT INTO inb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kaipi kan­chimi Partia suti pui­blu­kuna­manda runa­kuna; sug­kunaka Media­manda­kuna; ikuti sug­kunaka Elam alpa­nig­manda, Meso­po­ta­mia­nig­manda, Judea­nig­manda, Kapa­do­sia­nig­manda, Ponto­nig­manda, Asia alpa suiu­nig­manda, ");
INSERT INTO inb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fri­jia­nig­manda, Panfilia­nig­manda i Ejipto­nig­manda. Libia alpa i Sirene sug ladu­nig­manda­kuna­pas­mi kan­chi. Roma pui­blu­nig­manda kaipi kaug­sa­na­kug­pas­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Chi tukui­kuna­mandaka, sug­kunaka sutipa judiu­mi kan­chi. Sug­kunaka, judiu­kuna imasa iacha­chis­kata rurag­kuna­mi kan­chi. Chasa­lla­ta sug­kunaka, Kreta i Ara­bia alpa­kuna­nig­manda­mi kan­chi. Mai­nig­manda­kuna kaspa­pas, nukan­chi kikinpa rimai­wa tukui ima Taita Dius iapa suma ruras­kata willa­na­kus­ka­ta­mi uia­na­kun­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ñi ima­ura­pas mana kawas­ka­sina uias­ka­sina kag­manda, tukui­kuna, iapa ujna­rispa, pari­juma tapu­ri­na­kurka, kasa nispa: —¿Ima­manda­sik chasa pasa­ri­ku? ");
INSERT INTO inb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ikuti sug­kunaka, unz̈aspa ni­na­kurka: —Iapa machaska­kunami rima­nakú. ");
INSERT INTO inb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Chi­ura Pedroka, pai­pura chunga sug Jesús agllas­ka­kuna­wa sug­lla­pi saia­rispa, sin­chi rimag­samur­ka­kunata, kasa nispa: —Uiamui­chi, judiu­kuna i tukui kai Jeru­sa­lenpi kag­kuna. Rinri alli­lla churamui­chi uia­wan­ga­pa. Kasa­mi riman­ga­pa kai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","¿Ima­pa­tak iuia­na­kun­gi­chi, nukan­chi machaska kagta­kuna? Kai­tuku chara tutata, las nuibi­lla­mi chara ka. ");
INSERT INTO inb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Joel suti Santu Ispi­ri­tu­wa rimag, kai puncha­kuna­manda kasa­mi ñugpa­manda­ta willaska karka: ");
INSERT INTO inb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Taita Dius ni­kumi: “Tukurii puncha­kuna ña chaia­ku­ura, tukui­nig­manda runa­kunapa sunguma nuka­pa Ispi­ri­tu­ta­mi karan­ga­pa kani. Chi­uraka kam­kunapa kari i warmi wam­bra­kuna, Santu Ispí­ritu iuia­chis­ka­ta­mi willan­ga­pa kan­kuna. Kam­kunapa musu­kuna, muskui ukupi­sina ima pasa­rin­ga­pa kas­kata kawanga­pa­mi kan­kuna. Ruku­kuna­pas, muskui ukupi­sina chasa­lla­ta­mi kawan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chi puncha­kuna, kari i warmi nuka­manda alli­lla rurag­kuna­ta­mi pai­kunapa sunguma nuka­pa Ispi­ri­tuta karan­ga­pa kani. Chi­ura pai­kunaka, Santu Ispí­ritu iuia­chis­ka­ta­mi willan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Awa ladu, tukui ima­pas ujna­rigta rigcha­kunami kawa­chig­samun­ga­pa kani. Kai alpa luar­pipas, iawar­wa, nina­wa i puiu­wa kawa­chig­samunga­pa­mi kani nuka atun kagta. ");
INSERT INTO inb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Indi tutaianga­pa­mi ka; killa­pas, iawar­sina­mi tukun­ga­pa ka, atun Taita Diuspa atun pun­cha chaia­mun­ga­pa ka­ura. Chi tukurii punchaka, tukui suma alli­lla kas­ka­ta­mi kawa­chin­ga­pa ka. ");
INSERT INTO inb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mai­kan­pas atun Taita Diusta mañag­kunaka kispi­chiimi tukun­ga­pa kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Kam­kuna Israel­manda runa­kuna, kai­ta­pas uia­wai­chi. Naza­ret­manda Jesusta Taita Diuspa iachai­ta­mi karaska karka, kam­kunapa ñawipi ujna­chigta mana ima­ura­pas kawas­ka­sina ruran­ga­pa. Chasa­waka, pai Jesús Taita Dius agllaska kag­ta­mi kam­kunata kawa­chirka. Chi­taka, kam kikin­kuna alli­lla­mi iachan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Taita Dius, ñugpa­manda­ta imasa iuia­kus­ka­sina­mi sakirka, pai Jesús kam­kuna­wa kan­ga­pa. Chi­ura kam­kunaka, mana alli runa­kunapa maki­pi­mi kuarkan­gi­chi, kruspi klabaspa wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wañu­chigpi­pas, paita mana pudirkachu, wañui chari­rin­ga­pa. Wañui chari­kus­kata, Taita Dius kikinmi paita kaug­sa­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Chasa­lla­ta­mi ñugpa­manda taita Davidpas, pai Jesus­manda kasa willarka: Atun Taita Diusta nuka­pa ñugpa ladu ima­ura­pas­mi kawa­kuni. Pai, nuka­pa alli ladu­lla­mi ka; chasaka, nuka ñi imata mana mancha­rispa­lla kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chi­manda, nukata iapa allimi iuia­chi­wa­ku. Suma alli iuia­chii­wa­mi nuka rima­kuni. Kasapas. Nuka­pa kuir­pu wañus­paka, kun­tin­tu­lla­mi sama­kun­ga­pa kani, ");
INSERT INTO inb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nuka­pa almata wañus­ka­kuna­wa kas­kapi mana saki­puan­ga­pa kag­manda. Chasa­lla­ta, nuka kamballa kag­manda, mana saki­wan­kangichu, nuka­pa kuir­pu ismun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Iacha­chi­warkangimi imasa ruraspa kaug­san­ga­pa kagta. Kam nuka­wa kag­manda, iapa suma allimi iuia­chi­riwá. ");
INSERT INTO inb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—Taita­kuna i mama­kuna, nuka sutipa­mi ñugpa­manda taita David­manda kasa nii­ki­chita. Pai wañus­paka, pambaimi tukurka. Pamba­raias­kapi kas­ka­taka, nukan­chi chara­mi kawan­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chasa kag­pi­pas, pai David, Santu Ispi­ri­tu­wa rimag­mi karka. Pai­taka, Taita Dius jurarka, kasa nispa: Sutipa­mi niiki: kamba sug wambra­ta­mi kuan­ga­pa kani, kam imasa manda­kus­ka­sina atun mandag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chasa­mi David, ñugpa iachaspa, willarka, Cristo kaugsa­rin­ga­pa kagta, mana wañus­ka­kuna­wa kas­kapi Taita Dius sakin­ga­pa, paipa kuir­pu­ta­pas mana ismun­ga­pa sakin­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","—Pai Jesus­ta­mi Taita Dius kaug­sa­chirka. Chasa kawas­paka, nukan­chi tukui pai­manda willag­kuna­mi kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pai Jesus­taka, Taita Dius atun­ia­chispa, kikinpa alli ladu­mi tia­ri­chig­rirka. Chi­pika, ima­sa­mi Taita Dius niska karka: chasa Jesusta Santu Ispi­ri­tuta kuarka. Chi­mandaka kikin Jesuska, nukan­chi­pagma chi Santu Ispi­ri­tuta kacha­murka. Chi­ta­mi kam­kuna­pas kuna­ura kawa­na­kun­gi­chi i uia­na­kun­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","—Kikin David wañus­paka, paipa kuir­pu manara suma luarma rinchu. David­lla­ta­ta­mi kasa nirka: Atun Taita Diusmi nuka­pa iaiata nirka: “Nuka­pa alli ladu tia­rii, ");
INSERT INTO inb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nuka tukui kamta mana munag­kunata apag­rispa, kamba chaki saru­diru ukuma churan­kama”. ");
INSERT INTO inb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—Chi­manda, Israel­manda tukui runa­kuna, kasa iachai­chi: pai Jesusta kam­kuna kruspi kla­ba­chis­kata, sutipa­mi Taita Dius atun­ia­chirka, tukui­kunapa iaia Cristo ni­raian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Chasa uias­paka, chipi kag­kuna sungu nanagta llaki­rir­ka­kuna. Nis­paka, Pedrota i pai­pura Jesús kikin agllas­ka­kunata tapur­ka­kuna: —Ni­wai­chi, taita waugki­kuna: ¿imatak nukan­chi rura­sun­chi? ");
INSERT INTO inb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Chi­ura, Pedroka ainirka: —Kam­kuna panda­ris­ka­kunata sakispa, Taita Dius­wa tukui­chi. Jesu­cristopa suti­wa baug­ti­sa­rii­chi. Chasaka, kam­kunapa panda­rii­kunata pasin­siaskami tukun­kan­gi­chi. Chi­wanka, Santu Ispi­ri­tu­ta­mi chaskin­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chasa­lla­ta­mi Taita Dius nirka, kam­kunata, kam­kunapa wam­bra­kunata i karupi kaug­sag­kuna­ta­pas karan­ga­pa kagta. Tukui­kuna­ta­mi nukan­chipa atun Taita Dius ni: “Nuka tukui kaias­ka­kuna­ta­mi Santu Ispi­ri­tuta karan­ga­pa kani”. ");
INSERT INTO inb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sug rigcha sug rigcha rimas­pa­mi Pedro, Jesus­manda willa­kurka. Kasa­pas­mi iuia­chi­kurka, nispa: —Kai mana alli­lla iuiag­kuna­wa mana sug­lla­pi kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pedro ima rimas­kata suma uiag­kuna baug­ti­sai tukur­ka­kuna. Chi punchalla, sug kimsa waranga runa­kunami Jesus­wa kas­ka­kuna­wa sug­lla­pi tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chi­ura­manda tukui baug­ti­sa­ris­ka­kuna, Jesús agllas­ka­kuna ima iacha­chi­na­kus­kata uiaspa rura­na­kurka, ñi ima mana sakispa­lla. Sug­lla iuiai­pi­mi kaug­sa­na­kurka, Jesús imasa ruran­ga­pa nis­ka­sina tanda­rispa, tanda sug­lla­pi mikuspa. Chasa­lla­ta, Taita Diusta mañaspa rimaspa­mi kaug­sa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chi­ura­kuna Jesús agllas­ka­kunaka, achka sumag­lla mana ima­ura­pas kawa­ris­ka­sina­ta­mi rura­na­kurka. Tukui chasa kawag­kuna, iapa mancha­rispa­mi ujna­ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesu­cristo­wa tukui suma iuiag­kunaka, sug­lla iuiai­wa kaug­sa­na­kurka. Pai­kuna tukui ima iukaska, tukui­kunap­ami ni­raiarka. ");
INSERT INTO inb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Alpa u ima­pas iukag­kunaka, katus­pa­mi chura­na­kurka, minis­ti­na­kuska­manda tukui­kuna aida­ri­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tukui puncha­kuna, Dius­pa atun wasipi sug­lla iuiai­wa­mi tanda­ri­na­kurka. Wasi suiu­pas­mi iai­kuspa puri­na­kurka, Jesús nis­ka­sina tanda sug­lla­pi mikuspa. Tukui sug­lla­pi tanda­rispa mikuspa kar­ka­kuna, suma kun­tin­ta­rispa, ñi pi­wa­pas mana atun­ia­chi­rispa­lla. ");
INSERT INTO inb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Taita Dius­ta­mi ni­na­kurka: “Kam, iapa suma atun­mi kangi”. Jeru­sa­lenpi kaug­sag­kunaka, tukui­kunami pai­kunata sumag­lla kawa­na­kurka. Tukui puncha­kuna, atun Taita Diuska achka­kuna­ta­mi kaia­kurka. Chasaka Jesus­wa tukus­ka­kuna, tukui puncha­kunami mas achka mira­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Su­ura chaugpi chisima pun­cha, Taita Diusta risa­diru ura ña tuku­kug­manda, Pedro i Juan ri­na­kurka Diuspa atun wasima. ");
INSERT INTO inb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chi pun­gu­pi tia­kurka sug runa, tiag­sa­mus­ka­ura­manda­ta mana purin­ga­pa pudig. Chi runata tukui pun­cha­kuna apa­rispa apa­dur kar­ka­kuna, Diuspa atun wasipi iapa suma suti pungu suiu tia­ri­chig­rin­ga­pa. Chi pungupi, tukui ukuma iaiku­na­kus­kata kulki mañaspa tia­ku­dur karka. ");
INSERT INTO inb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Chi runaka, Pedro i Juan ña ukuma iaiku­na­kus­kata kawas­paka, kulki mañar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Chi­ura Pedroka, Juanwa paita alli­lla kawaspa, —Kawa­mu­wai— nirka. ");
INSERT INTO inb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Chi runaka, alli­lla kawar­ka­kunata, “Kara­wanga­pa­mi kan­kuna” iuia­rispa. ");
INSERT INTO inb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Chi­ura, Pedroka nirka: —Kulki ñi kuri mana iuka­ni­chu. Nuka ima iukas­kata kara­sa­ki. Nazaret­manda Jesu­cristo­wa­mi niiki: ata­rispa puri­rii—. ");
INSERT INTO inb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Chasa nis­paka, alli ladu makita apispa­mi ata­ri­chirka. Atari­chig­lla­pi, chaki­kuna i ñudu­kuna alli­lla tukug­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Chi­uraka, saltaspa saia­rirka. Purii­mi kalla­rirka. Nis­paka, saltaspa kalpaspa, Taita Diusta kuiaspa, Diuspa atun wasi ukuma pai­kuna­wa iai­kug­rirka. ");
INSERT INTO inb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tukui chipi kag­kuna, chi Taita Diusta kuiaspa puri­kus­kata kawas­paka, ");
INSERT INTO inb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","rigsir­ka­kuna: “Pai­mi ka chi mana purin­ga­pa pudig, Diuspa atun wasipi iapa suma suti pungu suiu kulki mañaspa tia­ku­dur”. Chasa paita pasa­ris­kata kawas­paka, tukui­kuna iapa mancha­rispa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chi ambi­riska runa, Diuspa atun wasi ukupi, Salomonpa kan­chapi Pedro i Juanta apispa cha­ri­kurka. Chipi kag tukui runa­kuna, iapa ujna­rispa, kalpa kai­lla­iag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pai­kunata kawas­paka, Pedroka kasa­mi nirka: —Kam­kuna Israel­manda taita­kuna, ¿imapatak kai runata nukan­chi­wan­ta ujna­rispa kawa­na­kun­gi­chi? Nukan­chipa iachai­wa ñi nukan­chipa risai­wa mana kai runa purig tukug­samurkachu. ");
INSERT INTO inb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nukan­chipa Abra­ham, Isaak i Jakob ñug­pa­manda taita­kunapa Taita Dius­mi paipa wam­bra Jesusta sumag­lla atun­ia­chig­samurka. Pai­ta­mi kam­kuna wañu­chin­ga­pa kuarkan­gi­chi. Pila­tos paita kacha­rin­ga­pa muna­ku­ura, kam­kunaka nirkan­gi­chimi: “Mana kacha­ri­kui”. ");
INSERT INTO inb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pai tukui suma alli­lla ruragta wabutispa, mañarkan­gi­chimi, sug runa wañu­chi­durta kacha­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pai tukui­kunata kaug­sai karag­ta­mi wañu­chin­ga­pa: “Ari” nirkan­gi­chi. —Chasa kagpi­pas, Taita Diuska paita kaug­sa­chirkami. Chasa sutipa kawaspa­mi nukan­chi pai­manda willag­kuna kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesus­wa suma iuiag­manda­mi kai kam­kuna kawaska i rigsiska runata alia­chispa wapu­ia­chig­samurka. Chasa suma iuiag­manda­mi tukui kam­kunapa ñawipi alia­chiska tukug­samurka. ");
INSERT INTO inb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Ñami iachani, taita­kuna: kam­kuna i kam­kunapa taita­kuna, pi Jesús kagta mana alli­lla iachas­pa­lla­mi paita wañu­chin­ga­pa: “Ari” nirkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chi­wanka, imasa Taita Dius, ñugpata tukui paipa Ispi­ri­tu­wa rimag­kuna­wa pai agllaska Cristo­manda willaska: imasa willa­raias­ka­sina­mi paita pasa­rig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chi­manda kam­kuna, panda­ris­ka­kunata sakispa, Taita Dius­wa tukug­samui­chi. Chasaka, kam­kunapa panda­rii­kuna pasin­sia­riimi tukun­kan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nig­pika Taita Dius kikin, pai agllaska Jesus­ta­mi kacha­munga, alli­lla iuia­chii puncha­kuna kam­kunata tukun­ga­pa. Taita Dius ñugpa­manda­ta­mi ni­raiarka, pai Jesusta kam­kuna­manda kacha­mun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Paita chaia­kumi, suma luarpi chara kan­ga­pa, Taita Dius tukui imasa kas­ka­sina sumag­lla churan­kama. Chasa­mi Taita Dius, paipa Ispi­ri­tu­wa alli rimag­kuna­wa ñugpa­manda­ta willarka. ");
INSERT INTO inb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","—Pai Jesus­manda, ñugpa­manda taita Moiseska sutipa­mi kasa rimarka: Atun Taita Dius kikinmi ni: “Kam kikin­pura­manda Santu Ispi­ri­tu­wa sug rimag­mi llugsin­ga­pa ka”. Paika, nuka­sina­mi kan­ga­pa ka. Pai tukui ima rima­kus­kata suma uian­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mai­kan chi rimagta mana uiag­kunaka, Israel­manda llugsi­chispa, puchukaimi tukun­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","—Tukui Santu Ispi­ri­tu­wa rimag­kuna, Samuel rimaska­ura­manda­ta, kai puncha­kuna imasa pasa­rin­ga­pa kas­ka­taka timpumi willa­raiarka. ");
INSERT INTO inb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kam­kuna, chi ñugpa­manda rimag­kunapa wam­bra­kunapa kati wam­bra­kuna­mi kan­gi­chi. Kam­kuna­manda­mi Taita Dius, kam­kunapa ñugpa­manda taita­kuna­wa alli­lla iuia­rirka. Abra­hamta kasa­mi nirka: Tukui alpa­manda runa­kuna­pas­mi kamba wam­brapa wam­brapa sug kati wam­bra­manda nuka­pa iapa kuiaska ka­puan­ga­pa kan­kuna. ");
INSERT INTO inb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","—Taita Diuska, pai kikinpa wam­brata kaug­sa­chispa, kam­kuna­pag­ma­mi ñugpa kacha­murka; chasaka, tukui kam­kuna panda­rii­kuna sakig­pika, paipa iapa kuiaska kan­ga­pa­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro i Juan chi runa­kunata chara rima­na­kug­lla­pika, iaia sasir­duti­kuna, Diuspa atun wasipi kawag taita i sadu­seo suti taita­kuna­ka chima chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pe­dro i Juan iacha­chi­na­kurka, Jesús kaugsa­riska­manda, tukui wañus­ka­kuna­pas kaugsa­rin­ga­pa kag­ta­kuna. Chi taita­kuna, mana chasa iuiaspa­mi iapa rabia­wa piña­rispa chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pedro i Juanta apis­paka, ña chisi kag­manda, kaiandi­kama kar­silpi chu­rag­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pedro chasa rimas­kata uiag­kunaka, achka runa­kuna Jesus­wa suma iuia­rir­ka­kuna. Ña pichka waranga­sina mirar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kaiandika, judiu­kunata man­dag taita­kuna, Moisés ima nis­kata iacha­chig taita­kuna i sug taita­kuna­pas, chi Jeru­sa­lenpi tanda­rig­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chipi kar­ka­kuna iaia sasir­duti, Anás suti, Kai­fás, Juan, Ale­jandro i tukui chi iaia sasir­dutipa kag­kuna­pas. ");
INSERT INTO inb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Chasa tanda­riska ka­uraka, Pedro i Juanta chaia­chig­rispa, chaugpipi saia­chispa, tapu­chii kalla­rir­ka­kuna: —¿Pitak kam­kunata kacha­murka, u pipa iachai­watak kam­kuna chasa rura­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Chi­ura Pedroka, Santu Ispi­ri­tu­wa iuiaipi junda kaspa, kasa­mi nirka: —Israel­manda runa­kunapa taita­kuna, ");
INSERT INTO inb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kam­kunaka nukan­chita kaian­gi­chi, kai runa­manda tapu­chin­ga­pa, imasa pai ambi­riska tukug­samugta. ");
INSERT INTO inb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tukui kam­kunata i tukui Israel­manda runa­kunata kasa­mi nii­ki­chita: Naza­ret­manda Jesu­cristo­wa­mi kai runa kam­kunapa ñawipi ambi­riska saia­ku. Pai Jesus­ta­mi kam­kuna kruspi kla­ba­chirkan­gi­chi. Pai wañus­ka­taka, Taita Dius­mi kaug­sa­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kasa­mi ñugpa­manda librupi willa­raiá: Wasichigkuna wabutiska rumi, wasita charig­mi tukug­samurka. Chasallata, pai Jesusta kam­kuna wabu­tiska, tukui­kunapa iaia­mi tukug­samuska ka. ");
INSERT INTO inb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kai alpapi manima tian­chu ñi sug mai­kan­pas nukan­chipa pan­da­rii­kunata kispi­chin­ga­pa. Jesús sapa­lla­ta­mi Taita Dius kacha­murka, nukan­chita kispi­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chi­ura chi taita­kunaka, Pedro i Juan mana manchaspa­lla rima­na­kus­kata uiaspa, ianga runa­kuna mana iachag­kuna kagta iachag­samuspa, iapa ujna­rir­ka­kuna. Jesus­wa purig­kuna kaska kag­ta­mi iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Chi ambi­riska runa­pas, pai­kuna kas­kapi saia­kurka. Chasa kawas­paka, mana iachar­ka­kuna ima pai­kunata ninga. ");
INSERT INTO inb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pedro i Juanta kanchama llug­si­chir­ka­kuna. Nis­paka, kikin­pura tapu­ri­na­kurka, ");
INSERT INTO inb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","kasa nispa: —¿Imatak chi runa­kunata rura­sun­chi? Jeru­sa­lenpi tukui kaug­sag­kuna­mi ña iachan­kuna, pai­kuna sug mana ima­ura­pas kawas­ka­sina­ta ruragta­kuna. Chita, nukan­chi mana piña­rii pudin­ga­pa kan­chi­chu. ");
INSERT INTO inb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sug­kuna chasa ruraska­manda mana uian­ga­paka, kasa mancha­chispa ni­sun­chi: “Kuna­ura­manda, ñi pi­ta­pas mana Jesus­manda willa­na­kun­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chi taita­kuna chasa iuia­rispa, Pedro i Juanta ikuti kaiar­ka­kuna. Kasa mancha­chispa­mi nir­ka­kunata: —Kuna­ura­mandaka, mana mas Jesus­manda rimaspa iacha­chispa purin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Chasa uiaspa, Pedro i Juanka ainir­ka­kuna: —¿Imasatak iuia­na­kun­gi­chi? Diuspa ñawipi, ¿alli­llachu ka, kam­kunata uian­ga­pa; u Taita Diustachu uia­sun­chi? ");
INSERT INTO inb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nukan­chi­taka chaia­kumi, imasa kawaska i uias­kata willaspa purin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Chi­ura, ikuti mancha­chispa, kacha­rir­ka­kuna. Chi runa mana ima­ura­pas kawas­ka­sina­wa ambi­riska, chusku chunga wata iali­mi iukarka. Chasa ambi­riska­mandaka, tukui runa­kuna Taita Dius­ta iapa suma atun kagta ni­na­kurka. Chi­manda chi taita­kuna, Pedro i Juanta ñi ima panda­riipas mana tarir­ka­kuna, asutin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pai­kunaka, ña kacha­rii tukus­paka, kikin­pura­kuna­pagma rir­ka­kuna. Chaiag­ris­paka, chi iaia sasir­duti­kuna i sug taita­kuna­pas pai­kunata imasa mancha­chispa llugsi­chiska­manda willag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chasa uias­paka tukui­kuna, sug­lla iuiai­wa Taita Diusta rimar­ka­kuna, kasa nispa: —Tukui mandu­iug Tai­tiku, sug luar, kai alpa luar i lamar iaku­kunata, tukui­mi kam rurarkangi. ");
INSERT INTO inb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kammi Santu Ispi­ri­tu­wa nukan­chipa ñugpa­manda taita David kam­manda alli­lla ruragta kasa rima­chirkangi: ¿Imapatak mana judíu kag­kuna kapa­rispa killa­chi­ri­nakú? ¿Imapatak iangalla ima­pas ruran­ga­pa iuia­ri­nakú? ");
INSERT INTO inb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kai alpapi atun mandag­kuna i pai­kunapa kati mandag­kuna, suglla iuiai­wa­mi tanda­rir­ka­kuna, atun Taita Diusta i pai agllaska Cristota wabu­tin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","—Chasa ñugpa­manda­ta willa­raiaskaka, sutipa­mi tukug­samurka. Kai atun pui­blupi, Hero­des i Ponsio Pila­tos, judíu i mana judíu kag­kuna­wa­mi tanda­rir­ka­kuna, kamba tukui­pi alli wam­bra Jesusta kam agllas­kata wabutin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chasa, kam tukui imasa ñugpa­manda­ta ruran­ga­pa ni­raias­ka­taka, chi taita­kuna­mi rurar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","—Kunauraka, Tai­tiku, pai­kuna ima man­cha­chis­ka­kunata kawa­mui. Nukan­chi kamba lutrin­sina­kunata iachai­ta kara­mui, kamba rimaita mana man­chas­pa­lla willaspa purin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chasa­lla­ta kara­mui, kamba iapa iachai­wa ungug­kunata ambispa, ima­kuna­pas kawa­chispa, kamba tukuipi alli wam­bra Jesus­wa tukui mana ima­ura­pas kawas­ka­sina­pas ruran­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chasa Taita Diusta mañai puchu­ka­ura, chi wasi ukupi tanda­ris­ka­kuna­pika kuiu­rig­sa­murka. Chi­ura tukui chipi kag­kuna, Santu Ispi­ri­tu­wa iuiaipi jundami tukug­samur­ka­kuna. Chi­ura­manda, Diuspa Rimaita mas sin­chimi rimaspa mana man­chas­pa­lla purii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesus­wa tukuska­kuna, iapa achka­kuna kaspa­pas, tukui­kunami sug­lla iuiai­wa kar­ka­kuna. Ñi pipas mana ni­na­kurkachu: “Kai, nuka­pa­mi ka”. Tukui ima iukas­ka­pas, tukui­kunap­ami ni­raiarka. ");
INSERT INTO inb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iaia Jesús kikin agllas­ka­kuna, paipa iapa iachai­wa­mi pai­manda willa­na­kurka, kaugsa­riska kagta. Tukui Jesus­wa tukus­ka­kunaka, Taita Diuspa sumag­lla iuia­chii­wa­mi kaug­sa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jesus­wa tukuska­pura­kuna­mandaka, ñi mai­kan­ta­pas mana ñi ima pisir­ka­kunatachu. Mai­kan­pas alpa u wasi iukas­ka­kunaka, iachar­ka­kuna­mi katunga. ");
INSERT INTO inb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nis­paka, chi katuska kulkita apaspa, Jesús agllas­ka­kuna­ta­mi iachar­ka­kuna kuag­ringa. Chas­kis­paka, tukui imasa minis­tis­ka­sina karas­pa­mi richidur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Chi­pre alpa­manda sug runa, José suti, Levi­pa­pura­kuna­manda, pai­kuna­wa kaug­sa­kurka. Chi runata, Jesús agllas­ka­kuna suti­chiska kar­ka­kuna Ber­nabé. (Chi ni­raianmi “Sumag­lla iuia­chig”.) ");
INSERT INTO inb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Chi runaka, alpa iukas­kata katus­paka, kulkita apaspa, Jesús agllas­ka­kunata kuag­rirka. ");
INSERT INTO inb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Chi­ura­kuna Ananías suti runa­pas, warmindi Safira­wa pai­kuna alpa iukas­kata katur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Chi runaka, alpa katus­kata chaugpi kulkimi pakalla waka­chi­rirka. Warmindipas, alli­lla­mi iacharka. Sug chaugpi kulki kas­ka­taka Jesús agllas­ka­kunata kuag­rirka, “Tukui kulki katus­ka­ta­mi kua­na­kui­ki­chita” llullaspa. ");
INSERT INTO inb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Chi­ura Pedroka, Ananiasta nirka: —¿Ima­wan­tak iaia kuku, kamba iuiaipi iai­kurka, Santu Ispi­ri­tuta llulla­chin­ga­pa? Chi alpa katuska kulkita, chaug­pi­mi pakalla waka­chi­rirkangi. ");
INSERT INTO inb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Alpata manara katu­ura, ¿mana­chu kamba karka? Chasa­lla­ta katuska­ura­manda, chi kulki, ¿mana­chu kamba karka? Nig­pika, ¿imapatak chasa iuia­ringi llulla­chig­samun­ga­pa? Mana runa­purata llulla­chi­kungichu. Taita Dius­ta­mi llulla­kungi. ");
INSERT INTO inb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Chasa uias­paka, Ananías wañus­ka­mi urmag­samurka. Pai wañus­kata iachag­samug­kuna, tukui­kuna iapa­mi mancha­rig­sa­mur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nigpi sug musu­kuna chi ukupi tia­na­kugka, saia­rispa, kuir­puta maitur­ka­kuna. Maitus­pa­ka, paita apar­ka­kuna pamban­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mai kimsa ura­pikar, Ananiaspa warmika iai­kug­samurka, imasa pasa­ris­kata mana iachaspa­lla. ");
INSERT INTO inb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Chaiag­ri­uraka, Pedroka paita tapurka: —Willa­wai: ¿kai­manda­llachu alpata katurkan­gi­chi? Chi­ura ainirka: —Sutipa, chi­manda­lla­mi katur­kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Chi­ura, Pedroka nirka: —¿Imapatak iuia­rirkan­gi­chi, atun Taita Diuspa Ispi­ri­tuta llulla­chin­ga­pa? Uiamui. Kamba kusata pamban­ga­pa apag­kuna, kancha­lla­pi­mi samu­nakú. Kuna­uraka, kam­ta­pas­mi apan­ga­pa kan­kuna, pamban­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Chasa nig­lla­pi, chi warmipas Pedropa chaki­kuna­lla­pi wañuska urmag­samurka. Musu­kuna, iai­kus­paka, tim wañus­ka­ta­mi tarir­ka­kuna. Nis­paka, chasa­lla­ta llugsi­chispa, apar­ka­kuna. Kusa pamba­raiaska ladu­lla­pi pai­ta­pas pambag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chi­ura tukui Jesus­wa tukus­ka­kunaka, iapa mancha­rir­ka­kuna. Chasa­lla­ta ima pasa­ris­kata iachag­kuna­pas, tukui­kunami mancha­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chi puncha­kuna Jesús ag­llas­ka­kuna, Jeru­sa­lenpi kaug­sa­na­kug­pa ñawipi achka mana ima­ura­pas kawas­ka­sina suma ruraspa­mi kar­ka­kuna. Tukui Jesus­wa tukus­ka­kuna, Diuspa atun wasipi, Salo­monpa suti atun pungu ladu­lla­pi­mi tanda­ri­dur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Chi pui­blupi kaug­sa­na­kugka, pai­kunata iapa­mi kuiar­ka­kuna. Pai­kunata kuias­pa­pas, sug­kuna mancha­na­kus­pa­mi pai­kuna­wa sug­lla­pi manara tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chasa kag­pi­pas, tukui puncha­kuna, kari i warmi­kuna, Iaia Jesus­wa suma iuia­rispa, pai­wa mas miraspa­mi ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jesús agllaska­kuna iapa suma rura­na­kus­kata kawaspa, chi pui­blu­pi kaug­sa­na­kugka, ungug­kunata wasi­kuna­manda chakanapi llugsi­chispa, kalli suiu chura­dur kar­ka­kuna; chasaka, Pedro iali­ku­ura, pai­pa sum­bra­lla­ta­pas chaskis­paka ambi­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jeru­salén ladu­kunapi kaug­sa­na­kug­pas, chasa­lla­ta achka ungug­kunata i kuku waira iai­kus­ka­kuna­ta­pas chima­lla­tata apa­dur kar­ka­kuna. Chi­ura, tukui­kuna­mi aliaska tukug­samu­dur kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Chasa kawas­paka, iaia sa­sir­duti i sadu­seo suti pai­wa purig­kuna­ka, mana alli­lla iuiai­wa rabia­rispa, ");
INSERT INTO inb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jesús agllas­ka­kunata api­chispa, kar­silpi churar­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Chi­ura­lla atun Taita Diuspa anjil­ka, tuta rispa, wichka­raiaska pun­gu­kunata paskaspa, pai­kunata chi­manda llugsi­chig­rir­ka­kunata. Llugsi­chis­paka, nir­ka­kunata: ");
INSERT INTO inb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Rii­chi. Diuspa atun wasi uku­pi runa­kunata mana man­chas­pa­lla willag­rii­chi, kasa nispa: “Jesu­cristo, sug rigcha musu kaug­sai­ta­mi apa­murka”. ");
INSERT INTO inb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Chasa uias­paka, kaiandi tutata Diuspa atun wasi ukupi iai­kug­rispa, iacha­chii­mi kalla­rir­ka­kuna. Chi tutata­lla­tata, iaia sasir­duti i pai­wa purig­kuna, Israel­manda tukui taita­kuna­wa tanda­rig­rir­ka­kuna. Ña tanda­ris­ka­kuna ka­uraka, alwasil­kunata kar­silma kachar­ka­kuna, Jesús agllas­ka­kunata pusan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Chima chaiag­ris­paka, chi alwa­sil­kuna manima pai­kunata tarig­rir­ka­kuna. Nis­paka, iaia sasir­du­ti­pagma kutir­ka­kuna willan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kasasi nir­ka­kuna: —Chi kar­sil pungu­kuna suma wichkas­ka­ta­mi tarig­rir­kan­chi. Sul­da­du­kuna­pas, tukui pungu­kuna­ta­mi kawa­na­kurka. Nukan­chi pungu­kunata paska­uraka, ñi pipas chi ukupi mana kar­ka­kuna­chu. ");
INSERT INTO inb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Chasa uias­paka, Diuspa atun wasipi kawag taita i iaia sasir­duti­kuna, iapa mancha­rispa, tapu­ri­na­kurka: —Chi­kunawa, ¿imasik pasa­ringa? ");
INSERT INTO inb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chasa tapu­ri­na­kug­lla­pi, sug runaka pai­kuna­pagma chaiag­rirka, kasa nispa: —Kam­kuna kar­silpi churaska runa­kunaka, kaska­lla­mi Diuspa atun wasi ukupi iacha­chi­nakú. ");
INSERT INTO inb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Chasa uias­paka, Diuspa atun wasipi kawag taitaka alwasil­kuna­wa rir­ka­kuna, Jesús agllas­ka­kunata pusan­ga­pa. Achka uia­na­kugta kawaspa­mi mancha­rispa, kasa nir­ka­kuna: “¡Amalai nukan­chita rumi­wa piantra­kuna!”. Chi­man­da­mi mana ima­pas pai­kunata ruras­pa­lla pusar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Chasa pusaspa, chi taita­kuna tanda­riska kas­kapi iaiku­chig­rir­ka­kuna. Chi­pika iaia sasir­duti, Jesús agllas­ka­kunata nirka: ");
INSERT INTO inb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Mana­chu uiarkan­gi­chi nukan­chi nis­kata: “Mana mas chi Jesus­manda iacha­chispa puri­na­kun­gi­chi”? Kam­kunaka, uianga­taka, Jeru­sa­lenpi tukui runa kaug­sa­na­kus­ka­ta­mi iacha­chispa upa­sina puri­na­kun­gi­chi. Kam­kuna muna­na­kun­gi­chimi, nukan­chita jucha­chispa, chi runata nukan­chi wañu­chigta. ");
INSERT INTO inb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chi­ura, Pedro i pai­pura Jesús agllas­ka­kunaka ainir­ka­kuna: —Nukan­chita chaia­kumi, Taita Dius imasa pai nis­kata uian­ga­pa, mai­tuku runa­kuna uia­ri­na­kug­pi­pas. ");
INSERT INTO inb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nukan­chipa ñugpa­manda taita­kunapa Taita Diusmi Jesusta kaug­sa­chirka. Pai Jesus­manda­mi kam­kuna mañarkan­gi­chi, kruspi klabas­ka­kuna­wa warku­chispa wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Taita Diuska, paita kaug­sa­chis­paka, suma luarpi atun­ia­chispa, kikinpa alli ladumi tia­ri­chig­rirka, tukui­kunapa iaia mandag i kispi­chig kan­ga­pa; chasaka, Israel­manda runa­kuna tukui panda­rii­kunata sakis­ka­kunata panda­rii­kuna pasin­siai tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","—Nukan­chika, chasa alli­lla kawaspa­mi pai Jesus­manda willag­kuna kan­chi. Santu Ispi­ri­tu­pas­mi pai­manda tukuipi alli­lla willag ka. Taita Dius, paita suma uiag­kuna­ta­mi Santu Ispi­ri­tuta karamú. ");
INSERT INTO inb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Chasa Jesús agllas­ka­kunata uias­paka, chi taita­kuna, iapa rabia­rispa, wañu­chinga­pa­mi muna­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Chasa iuia­na­kugpi­pas, pai­pura­kuna tiarka Gamaliel suti sug fari­seo. Chi runa, Moisés ima nis­kata iacha­chig taita­mi karka. Paita, tukui runa­kuna sumag­lla kuias­pa­mi uia­dur kar­ka­kuna. Chi runaka, saia­rispa, nirka: —Kai runa­kunata sug mana unai­lla kanchama llugsi­chii­chi—. Llugsi­chi­uraka, chipi kaska taita­kunata nirka— ");
INSERT INTO inb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kam­kuna Israel­manda taita­kuna, chi runa­kunata manara ima­pas ruraspa­lla, alli­lla iuia­rin­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kasa iuia­rii­chi: unai ña ka; Teudás suti runa­sik atun­ia­chi­ri­kurka, kasa nispa: “Taita Dius kacha­muska­mi kani”. Chi­ura­kuna, sug chusku patsa runa­kuna­sik pai­wa tukur­ka­kuna. Paita wañu­chi­uraka, tukui chi paita kati­raiag­kuna, sugma sugma rispa, puchuka­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","—Chi­ura­manda, ikuti kasa­pas­mi tukug­samurka: runa­kuna mai­tuku kaug­sa­na­kus­kata iachan­ga­pa tapu­chi­na­ku­ura, Judas suti Gali­lea­manda runami chasa­lla­ta atun tuku­kurka. Paipas, achka runa­kuna­ta­mi kaiaspa puri­chi­kurka. Pai­ta­pas­mi wañu­chir­ka­kuna. Chi­ura tukui pai­wa kag­kuna­pas, sug­sinama sug­sinama rispa­mi puchuka­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","—Chi­mandami kam­kunata kuna­ura nii­ki­chita: chi runa­kunata ianga kawai­chi. Ñi ima­pas pai­kunata mana rurai­chi. Pai­kuna imasa ianga runa­kunapa iuiai­lla­wa kagpi­kuna, pai­kuna­pas chasa­lla­ta­mi puchuka­ringa­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ikuti pai­kuna imasa Taita Diuspa iuiai­wa rura­na­kug­pika, kam­kunaka mana puchukai pudin­ga­pa kan­gi­chi­chu. ¡Ujala­lla­pas kam­kuna­wa Taita Dius rabia­rig­samuchu! Chasa uias­paka, tukui chi taita­kunaka Gamaliel rimas­kata sug­lla iuiai iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chi­ura­manda, Jesús agllas­ka­kunata kaias­paka, asuti­chispa, nir­ka­kunata: —Mana mas Jesus­manda rima­na­kun­gi­chi—. Chasa nis­paka, kacha­rir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesús agllaska­kunaka, chi taita­kuna­pag­manda llugsis­paka, kun­tin­ta­rispa rir­ka­kuna, kasa nispa: “Jesus­manda nukan­chi nanai­wa llakii pasar­kan­chi. Chi­manda­mi iapa alli iuia­chii­wa ri­na­kun­chi”. ");
INSERT INTO inb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chi­ura­manda, antis mas mana sakispa­lla, tukui puncha­kuna, Diuspa atun wasi ukupi i sug wasi­kuna­pipas Jesu­cristo­manda mas rimaspa i iacha­chispa purii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chi puncha­kuna, Jesus­wa tukus­ka­kuna miraspa miras­pa­mi ri­na­kurka. Chi­ura griego suti rimai­wa kag­kuna, he­breo suti­wa rimag­kuna­manda piña­chi­rii kalla­rir­ka­kuna, kasa nispa: —Tukui puncha­kuna, mikui kara­na­ku­ura, nukan­chi­purapa sapalla kidaska warmi­kuna manima sumag­lla chaski­na­kunchu. ");
INSERT INTO inb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Chasa uias­paka, chunga iskai Jesús kikin agllas­ka­kunaka, pai­wa tukui tukus­ka­kunata tanda­chispa, nir­ka­kuna: —Mana­char alli ka, nukan­chi Dius­pa Rimaita willa­na­kunga­taka, mikui kara­na­kus­kapi unaia­na­kun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chi­manda, taita­kuna i mama­kuna, kam kikin­pura kawas­pa, kan­chis runa­kunata mas­kai­chi, mikui i ima­kuna­pas kawag tian­ga­pa. Pai­kuna ka­chu­kuna tukuipi alli runa­kuna, achka iachag­kuna, Santu Ispi­ri­tupa iuiaita iukag­kuna. ");
INSERT INTO inb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Chasa tukug­samug­pika, nukan­chika Taita Diusta mañaimi apa­na­ku­sun­chi. Paipa Rimaita mana sakispa­lla­mi iacha­chi­na­ku­sun­chi. ");
INSERT INTO inb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chasa uias­paka, tukui­kuna sug­lla iuiaimi tukur­ka­kuna. Nis­paka, Esteban suti Santu Ispi­ri­tupa iuiaita iukag­ta­mi agllar­ka­kuna. Paika, Iaia Jesus­lla­wa­mi suma iuia­kurka. Chasa­lla­ta, Felipe, Prókoro, Nikanor, Timón, Parmenas i Niko­lás suti runa­kuna­ta­mi agllar­ka­kuna. Chi Niko­lás, Antio­kia pui­blu­manda­mi karka. Ñugpata judiu­kuna imasa iacha­chi­na­kus­kata uiaspa­mi pai­kuna­wa tukuska karka. ");
INSERT INTO inb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Chi agllaska runa­kuna­taka Jesús kikin agllas­ka­kunapa ñawima pusar­ka­kuna. Chi­ura pai­kunaka, umapi maki churaspa, chi runa­kuna­manda Taita Diusta mañar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chi puncha­kuna, Diuspa Rimai­ta mas achka­kunami uia­na­kurka. Chi Rimaita uiaspa, Jesus­wa tukus­ka­kuna masmi Jeru­sa­lenpi mira­na­kurka. Achka sasir­duti­kuna­pas­mi, Jesus­manda rimaita uiaspa, pai Jesus­wa suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estebanka, Taita Diuspa suma kuiaska­mi karka. Taita Diuspa iapa iachai­wa runa­kunapa ñawipi asku­rinti ujna­chinga­sina mana ima­ura­pas kawas­ka­kuna­ta­mi rura­kurka. ");
INSERT INTO inb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sug runa­kuna, Este­ban­wa piña­chi­rii kalla­rir­ka­kuna. Chi runa­kunaka kar­ka­kunami randiska kas­ka­kunata kacha­riska suti tanda­ri­diru wasi­manda. Sug­kunaka kar­ka­kunasi Sirene alpa­manda i Ale­jan­dría pui­blu­manda; sug­kunaka, Silisia i Asia alpa­kuna­nig­manda. ");
INSERT INTO inb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Chi runa­kuna Estebanwa piña­chi­ri­na­ku­uraka, paika Santu Ispí­ritu karaska iachai­wa­mi iapa suma rima­kurka. Chi­wanka chi runa­kuna, paipa rimaita mana ainii alli ka­pur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Chi­mandami pai­kuna, pakalla sug runa­kunata kulki karar­ka­kuna, Esteban­manda llullaspa, sutipa kag­sina kasa nin­ga­pa: —Chi runata uiar­kan­chimi, Moises­manda i Taita Dius­manda jiru rima­kugta. ");
INSERT INTO inb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chasakunawaka, chipi kag­kunata, Moisés ima nis­kata iacha­chig taita­kunata i sug taita­kuna­ta­pas Esteban­manda mana alli­lla tukuipi rimar­ka­kuna. Nis­paka, Este­ban kaska­ma chaiag­rir­ka­kuna. Paita apis­paka, judíu taita­kuna tanda­riska kaska­ma­mi apar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nis­paka, pai­manda willan­ga­pa sug runa­kunata chaia­chig­rir­ka­kuna. Chi runa­kunaka, Este­ban­manda llu­llaspa, kasa­mi nir­ka­kuna: —Kai runa, kai Diuspa­lla kaska wasi­manda i Moisés ima ruran­ga­pa willa­raiaska­manda ima­ura­pas­mi kami­ri­kunlla. ");
INSERT INTO inb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pai rima­kus­ka­taka, nukan­chi uiar­kan­chimi: “Chi Nazaret­manda Jesús, kai Diuspa atun wasita puchu­kan­ga­pasi ka”. Kasa­pas­mi uiar­kan­chi: “Chi Jesús iacha­chir­ka­si: Moisés ima nukan­chita ruran­ga­pa nis­kata sakispa, sug rigcha­si rura­sun­chi”. ");
INSERT INTO inb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Chi taita­kuna i tukui chipi tia­na­kug­kunata, Estebanpa ñawika sug anjilpa ñawi­sina­mi kawa­rig­samur­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chi­ura iaia sasir­dutika, Este­banta tapurka: —Kam­manda rima­nakú; chika, ¿sutipachu ka? ");
INSERT INTO inb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Chi­ura, Estebanka ainirka: —Taita­kuna, uia­wai­chi. Nukan­chipa ñugpa­manda atun taita, Abra­ham suti, chara Meso­po­ta­mia suti alpapi kaug­sa­ku­ura, manara Arán pui­blupi kaug­sa­kugpita, nukan­chipa suma atun Taita Diuska paita kawa­rirka, ");
INSERT INTO inb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kasa nispa: “Kamba alpa­kunata i tukui kamba­pura­kunata kai­manda sakispa, rii. Nuka, sug mas suma alpa­mi kawa­chi­sa­ki”. ");
INSERT INTO inb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","—Chasa uiaspa Abra­hamka, chi Kaldea alpa­manda llugsispa, Arán pui­bluma rirka kaug­san­ga­pa. Chi­mandaka, paipa taita wañu­ura, kai alpapi kam­kuna kuna­ura kaug­sa­na­kuska­ma chaiag­samurka. ");
INSERT INTO inb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kai alpapi kaug­sa­kugpi­pas, Taita Dius manara paita ima alpapas kararka, ñi mai chaki churanga­pag­lla­pas. Nii­lla­kar nirkami: “Sutipa­mi kai alpata kara­sa­ki, kam wañu­uraka, kamba wam­brapa wam­bra­kuna kaug­san­ga­pa­kuna”. Taita Dius chasa ni­ura, Abra­hampa warmi mana­ra­mi ñi sug wam­bra iukaska karka. ");
INSERT INTO inb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","—Kasa­pas­mi Taita Diuska nirka: “Kamba wam­brapa wam­bra­kuna, sug karu alpa­pi­mi kaug­sag­rin­ga­pa kan­kuna. Chi­pika chi­nig­manda runa­kunami, chusku patsa wata pai­kunata mana llakispa­lla tra­baja­chin­ga­pa kan­kunata. ");
INSERT INTO inb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Chi­ura­mandaka, chi alpa­manda runa­kunata trabaja­chi­puag­kuna­taka, nuka­mi randi­chi­pun­ga­pa kani. Chasa pasa­riska­ura­manda­mi kam­ba wam­brapa wam­bra­kuna, chi­nig­manda llugsi­muspa, kai alpa­lla­pita kungu­ri­wag­samun­ga­pa kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","—Taita Diuska, Abra­hamwa iuia­rispa, paita nirkami, kari wam­bra­kunata marka churan­ga­pa; chasaka, Taita Diuspa­lla kagta ni­raian­ga­pa. Chi­manda­mi Abra­ham, Isaak suti paipa wam­bra pusag puncha iukag­samus­kata chasa rurarka. Chasa­lla­ta­mi Isaak, paipa wam­bra Jakobta rurarka. Paipa chunga iskai kari wam­bra­kuna­ta­pas, Jakob chasa­lla­ta rurarka. Chi runa­kuna­mi kar­ka­kuna nukan­chi Israel­manda­kunapa ñugpa­manda achala taita­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","—Iachanchimi, chi Jakobpa wam­bra­kunaka, José suti waug­kin­di­wa mana alli­lla iuiai­wa rabia iukaspa, paita katugta­kuna, Ejip­to suti alpama ri­na­kuska apan­ga­pa. Chasa pai katui tukugpi­pas, Taita Diuska mana sakirka. ");
INSERT INTO inb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Chi­wanka, tukui llakii­wa kas­ka­ta­pas­mi kispi­chirka. Suma iachaimi paita kararka. Chasa­lla­ta, Ejiptopi iaia mandagpa ñugpa ladu José ka­ura, Taita Diuska chi mandagta iuia­chirka, Josewa sumag­lla kan­ga­pa. Chi mandag kikinmi Joseta chu­rarka, Ejiptopi tukui kaug­sa­na­kus­kata i paipa wasi­manda­kuna­wan­ta­pas mandag kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","—Chi­ura­mandaka, iapa iarkai iapa llakii­wa­mi chi Ejipto suiu tukurka, chasa­lla­ta Kanaán alpa suiu­pas. Chi­ura nukan­chipa ñugpa­manda taita­kuna manami tari­na­kurka ima mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ja­kob­ka iachag­samurkami, Ejip­to­pi trigu mikui iukagta­kuna. Chasa iachas­paka, paipa wam­bra­kunata u nukan­chipa ñugpa­manda taita­kuna nis­kata, pai­kuna­ta­mi kacharka, musug­lla chima rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","—Pai­kuna ña iskaima Ejip­to­ma ri­uraka, Joseka paipa waug­kin­di­kuna­ta­mi rigsi­chi­rirka. Chi­ura­mandaka, chi alpapi iaia mandag­pas iachag­samurkami, José pipa wam­bra kagta. ");
INSERT INTO inb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nis­paka, José kacharka, taitandi Jakobta i tukui pai­pura­kunata pusag­rin­ga­pa. Pai­pura­kuna, kan­chis chunga pichka runa­kuna­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chasa­manda­mi Jakob, Ejiptopi kaug­sai kalla­rig­rirka. Chi­pi­mi wañurka. Nukan­chipa ñugpa­manda taita­kuna­pas, chi­lla­pi­ta­mi wañur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pai­kuna wañu­uraka, Sikem suti pui­blu­ma­mi apar­ka­kuna, pamban­ga­pa. Chi­pi­mi ñugpa­ta Abra­ham, Amorpa wam­bra­kunata sug piti alpa kulki­wa randiska tiarka, chipi wañus­ka­kunata pamban­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","—Abra­hamta Taita Dius imasa nis­ka­sina tukug­samun­ga­pa ña chaia­ku­uraka, Jakobpa wam­bra­kunapa kati wam­bra­kuna, Ejiptopi iapa miraspa miraspa­mi ri­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ejiptopi Jose­manda ña kunga­riska ka­uraka, sug iaia man­dag­mi mandai kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Chi man­dag­ka, nukan­chipa ñugpa­manda­kunata llulla­chispa, mana llakis­pa­lla­mi trabaja­chii kalla­rir­ka­kunata. Nis­paka, tukui taita­kuna­ta­mi nirka, kari wam­bra tias­ka­kuna­taka sitan­ga­pa, iapa mira­na­kug­manda. ");
INSERT INTO inb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","—Chi­ura­kunaka, Moisesmi tiag­samurka. Paika, Diuspa ñawipi suma­mi kawa­rirka. Paipa atun­kunaka, kimsa killa­mi wasi ukupi paka­lla wiña­chi­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Paita sitag­rii chaia­uraka, kikin iaia mandagpa sipas warmi wam­brami, sitas­kata tarispa, pai­pagma aparka. Chi­ura­manda, pai kikinpa wam­bra­ta­sina­mi wiña­chirka. ");
INSERT INTO inb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chi­wanka Moisés, tukui Ejipto­manda iachai­kuna­ta­mi iachai­kurka. Chasaka, tukuipi iacha suma rimag, alli iuiag pagta­mi tukurka. ");
INSERT INTO inb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","—Ña chusku chunga wata iuka­ura, Moiseska iuia­rirkami, pai kikinpa Israel­manda runa­kuna­pag­ma chaiag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chipi chaiag­ri­uraka, sug Ejipto­manda runa, Israel­manda sug runata kaspi­wa mana llakispa­lla pia­kurka. Chasa kawaspa, Moiseska, chi Israel­manda runata michaspa, chi Ejipto­manda­ta wañugta piag­rirka. Chasa­mi randi­chi­purka. ");
INSERT INTO inb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Chasa rura­kuspa, kasa­mi iuia­kurka: “Israel­manda runa­kuna iachag­samunga­pa­mi kan­kuna: ‘Kai Moi­ses­manda­mi Taita Dius nukan­chita kispi­chig­samun­ga­pa ka’.” Moi­sés chasa iuia­kugpi­pas, Israel­manda­kunaka manami iuia­na­kurka, paika kispi­chig kan­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","—Chi kaiandi, Israel­manda iskai runa­kuna maka­na­kus­ka­ta­mi Moisés tarig­rirka. Tarig­ris­paka, pasin­sia­chispa­mi nirka: “Kam­kuna, waugkindi­kuna­mi kan­gi­chi. ¿Ima­pa­tak rabia­chi­ri­na­kuspa maka­na­kun­gi­chi?”. ");
INSERT INTO inb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","—Chi pai­pura maka­na­kui kalla­rigka, Moisesta tangaspa, nirka: “¿Pitak kamta mandag chu­rarka; chasaka, nukan­chita jus­ti­sian­ga­pa? ");
INSERT INTO inb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Imasa­mi kaina Ejip­to­manda runata wañu­chir­kan­gi: chasa­lla­tachar nuka­ta­pas wañu­chi­wan­ga­pa muna­kungi”. ");
INSERT INTO inb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","—Chasa uiaspa, Moiseska miti­kurka. Madián suti alpama cha­iag­ris­paka, chi luar­manda ajinu­sina­mi kaug­sa­kurka. Chi­pika, sug warmi­mi tarirka. Pai­wa kaspa, iskai wam­brami iukar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","—Chusku chunga wata­pika, Moisés, Sinaí suti chusa sitaska alpa­pi puri­kug­rirka. Chi­pika sug anjil, nina sindi sacha rupa­kus­ka­sina­mi kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chasa rupa­kus­kata kawas­paka, Moisés iapa ujna­rig­samurka. Nis­paka, kai­lla­iaspa rirka, mas alli­lla kawan­ga­pa. Chi­ura, atun Taita Diuspa rimai­mi uia­rirka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nuka­mi kani kamba ñugpa­manda taita­kunapa Dius. Abra­ham, Isaak i Jakobpa Taita Dius­mi kani”. —Chasa uias­paka Moisés, iapa mancha­rispa chugchu­rirka. Kawan­ga­papas, mana pudi­kurka. ");
INSERT INTO inb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Chi­ura, atun Taita Diuska nirka­mi: “Kamba chakipi chura­ra­ias­ka­kunata surku­rii. Kam saru­kuska alpaka, nuka­pa­lla­mi ka. ");
INSERT INTO inb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nuka­pa runa­kuna Ejipto alpapi iapa llakii iukas­ka­kuna­ta­mi kawa­kuni. Pai­kuna iapa llakii­wa waka­na­kus­ka­ta­pas­mi uia­kuni. Chi­manda­mi urai­ku­murkani, pai­kunata kispi­chin­ga­pa. Nukami niiki: samui. Uia­wai. Kam­ta­mi Ejip­toma kachan­ga­pa kaiki”. ");
INSERT INTO inb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","—Chi Moises­ta­mi Israel­manda runa­kuna wabutiska karka. “¿Pitak kamta mandag churarka; chasaka, nukan­chita justi­sian­ga­pa?” niska karka. Chi Moisesmi Taita Dius, mandag i kispi­chig chu­rarka, paipa anjilwa nina sacha rupa­kus­kapi kawa­chispa. ");
INSERT INTO inb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Chi Moi­ses­mi Israel­manda runa­kunata Ejip­to­manda llugsi­chig­rirka. Chi Ejip­to­manda llugsi­chig­rispa, Puka Kucha suti atun iaku­pi­mi iali­chir­ka­kunata. Nis­paka, chusa sitas­ka alpapi chusku chunga wata­mi puri­chir­ka­kunata. Chi puri­na­kus­kapi, ñi ima­ura­pas mana kawas­ka­sina­ta­mi kawa­chir­ka­kunata. ");
INSERT INTO inb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","—Chi Moisesllatata­mi Israel­manda runa­kunata nirka: “Taita Dius kikin­mi ni, kam kikin­pura­manda Santu Ispi­ri­tu­wa sug rimag­mi llug­sin­ga­pa ka. Paika, nuka­sina­mi kan­ga­pa ka”. ");
INSERT INTO inb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","—Chi Moisesllatata­mi Israel­manda tukui runa­kuna­wa chusa sitaska alpapi sug­lla­pi karka. Taita Diuspa anjil­pas­mi pai­wa karka. Chi anjil, Sinaí awa lumapi paita i nukan­chipa ñugpa­manda taita­kuna­ta­pas­mi rimarka. Chi Moi­ses­mi Taita Diuspa kaug­sai karag rimai­kunata uiaspa chas­kirka; chasaka pai­pas, nukan­chita karag­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","—Chi Moises­ta­mi nukan­chipa ñugpa­manda taita­kuna mana uian­ga­pa munar­ka­kuna. Paita wabu­tispa, ni­na­kurkami: “Tukui­kuna, Ejip­toma kuti­sun­chi”. ");
INSERT INTO inb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moisés mana pai­kuna­wa kag­manda, Aarón sutita nir­ka­kuna: “Chi Moisés nukan­chita Ejipto alpa­manda llugsi­chi­mus­kata, nukan­chi mana iachan­chi­chu ima tukugta. Chi­manda, sug dius­kuna rurai, nukan­chita ñugpan­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chi puncha­kuna­mi uchulla wagra­sina kawa­ri pai­kunapa dius ni­raian­ga­pa rurar­ka­kuna. Nis­paka, animal­kunata wañu­chispa rupa­chispa, chi ianga dius­ta­mi kungu­rispa muchar­ka­kuna. Chi pai kikin­kunapa maki­wa ruras­kata kawas­paka, iapa­mi kun­tin­ta­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","—Chi­manda Taita Diuska, pai­kuna­pag­manda anchu­rirka. Pai­kunata sakirka, awa­manda istrilla­kunata dius nispa, kungu­ri­chu­kuna. Chi­manda­mi Santu Ispi­ri­tu­wa rimag ñugpa­manda librupi willarka, kasa nispa: Kam­kuna Israel­manda­kuna, chi chusku chunga wata chusa sitaska alpapi puri­na­ku­ura, ¿nukatachu animal­kunata wañu­chispa rupa­chispa kungu­ri­warkan­gi­chi? Manima. ");
INSERT INTO inb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Molok suti ianga diuspa linsu wasi­ta­mi apa­rispa puri­na­kurkan­gi­chi. Chasa­lla­ta, Refán suti ianga diuspa istrilla­sina kawa­ris­ka­ta­pas­mi puri­chirkan­gi­chi. Chi imajin­kunata kam kikin­kunapa maki­wa ruras­ka­kuna­ta­mi muchar­kan­gi­chi, dius nispa. Chi­mandami nuka, kam­kunata llugsi­chispa, Babi­lo­nia suti sug ladu alpa­ma kachan­ga­pa kai­ki­chita. ");
INSERT INTO inb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kasa­pas­mi Esteban nir­ka­kunata: —Chi chusa sitaska alpapi, nukan­chipa ñugpa­manda taita­kuna, sug linsu wasimi puri­chi­na­kurka. Chi wasi­pika, Taita Dius pai­kuna­wa kag­ta­mi ni­raiarka. Chi wasi­manda, Taita Dius, Moisesta niska karka: “Imasa­mi kai wasita kawa­chiiki: chasa­lla­ta­mi wasi­chi­puan­kangi”. ");
INSERT INTO inb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chi wasi­taka, nukan­chipa ñugpa­manda taita­kuna­ta­mi Moisés sakirka. Chi wasita kai alpa­ma­mi chaia­chig­samur­ka­kuna. Josué suti taita kai suiu ñugpata kaug­sa­na­kus­kata puchuka­ku­uraka, chi linsu wasi pai­kuna­wa tiarka. Chi sug runa­kunata, Taita Dius­mi kai alpa­manda llugsi­chirka nukan­chipa ñugpa­manda taita­kunapa ñawipi. Chi linsu wasi, David suti atun mandag kaug­san­kama­mi tiarka. ");
INSERT INTO inb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","—Pai Davidta, Taita Dius suma kuiarka. Pai Davidka muna­kurka, suma wasi wasi­chi­pun­ga­pa; chi­pika, Jakobpa Taita Dius kag­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Chasa muna­kug­pipas, paika manima; paipa wam­bra Salomón sutimi wasi­chi­purka. ");
INSERT INTO inb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wasi­chi­pugpi­pas, runa ruraska wasi­kuna­pika, tukui­manda mas atun Taita Dius mana chi­pika kaug­sanchu. Chi­manda­mi Santu Ispi­ri­tu­wa rimagka ñugpa­manda librupi kasa willarka: ");
INSERT INTO inb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Atun Taita Diuska, kasa­mi ni: “Sug luar, nuka mandan­ga­pa tia­ri­dirumi ni­raiá. Alpaka, nuka­pa chaki saru­diru­mi ka. Nigpika, ¿imasa wasitak muna­na­kun­gi­chi saia­chi­puan­ga­pa? ¿Mai­kantak nuka sama­diru ka­puanga? ");
INSERT INTO inb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mana­chu tukui, nuka kikin ruraska ka?”. ");
INSERT INTO inb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kasa­pas­mi Esteban nir­ka­kunata: —Kam­kuna, ima­ura­pas upa­sina­mi karkan­gi­chi. Mana Taita Diusta rigsig­sina, mana rinri uiag­sina i mana sungu­iug­sina­mi kan­gi­chi. Kam­kunapa ñugpa­manda taita­kuna­sina, kam­kuna­pas chasa­lla­ta­mi kan­gi­chi. Ima­ura­pas Santu Ispi­ri­tuta mana munan­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kam­kunapa ñugpa­manda taita­kuna, Santu Ispi­ri­tu­wa rimag­kunata, ¿mai­kan­kunatatak mana llaki­chispa wañu­chir­ka­kuna? Chi rimag­kunaka willaska­mi kar­ka­kuna, alli iuiag Cristo samun­ga­pa kagta. Chi alli iuiag runa ña samu­uraka, kam­kunaka api­chispa­mi wañu­chii nirkan­gi­chi. ");
INSERT INTO inb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Taita Dius ima ruran­ga­pa nis­ka­taka kam­kunapa ñugpa­manda­kunata anjil­kuna­wa­mi willarka. Chasa willag­pi­pas, Taita Dius imasa munas­ka­ta mana ruran­gi­chi­chu. ");
INSERT INTO inb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Chasa uiaspa, chi taita­kunaka, iapa rabia­rispa, kiru­kuna­pas uia­rigta muku­rir­ka­kuna, Estebanta wañu­chin­ga­pa nispa. ");
INSERT INTO inb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Paika, Santu Ispi­ri­tupa iuiaita iukaspa, sug luarma Taita Dius iapa suma punchalla kas­katasi kawarka. Chasa­lla­ta, Taita Diuspa alli ladu Jesús saia­kugtasi kawarka. ");
INSERT INTO inb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Chasa kawas­paka, nirka: —Kawai­chi. Suma luar, pas­kas­ka­mi ka. Runa Tukuska Jesus­ka, Taita Diuspa alli ladu saia­kug­ta­mi kawa­kuni. ");
INSERT INTO inb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Chasa rimag­lla­pi, tukui­kuna, rinri tapa­rispa, sin­chi kapa­ris­paka, sug­lla­sina kalpar­ka­kuna, paita apin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nis­paka, chi pui­blu­manda paita llugsi­chir­ka­kuna, rumi­wa piaspa wañu­chig­rin­ga­pa. Esteban­manda kuntra willag­kuna, manara rumi­wa piai kalla­rispa­lla, kata­ri­diru­kunata Saulo suti musuta mingag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Chasa Este­banta rumi­wa pia­na­ku­uraka, paika Iaia Jesusta nirka: —Taitiku, nuka­pa ispi­ri­tuta kam­ta­mi mingaiki—. ");
INSERT INTO inb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nis­paka, kungu­rispa, sin­chi kapa­rirka, kasa nispa— Tai­tiku, pai­kuna kai mana suma rura­was­ka­kuna­manda, pai­kunata mana ima­pas iuia­ri­puangi—. Chasa nis­paka, wañurka. ");
INSERT INTO inb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulopas niska karka: “Este­ban­taka wañu­chiimi chaiá”. Chi puncha­lla­tata, Jeru­sa­lenpi Jesus­wa tukus­ka­kunata puchukan­ga­pa iuiai­wa wasi wasi maskai kalla­rir­ka­kuna. Chi­manda tukui Jesus­wa tukus­ka­kunaka, Judea i Sama­ria suti alpa suiu miti­kui kalla­rir­ka­kuna. Chi­wanka Jesús kikin agllaska runa­kuna, sapa­lla­mi Jeru­sa­lenpi kidar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Taita Dius­wa alli iuia­rispa kag runa­kunaka, iapa wakaspa, Esteban wañus­kata pambar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ikuti Sauloka, Jesus­wa tukus­ka­kunata puchukan­ga­pa iuiai­lla­wa­mi puri­kurka. Wasi wasi iai­kuspa, kari i warmi­kunata aliuspa llugsi­chispa, kar­silpi chura­chi­kurka. ");
INSERT INTO inb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalen­manda llugsig­kuna, tukui­pi­mi Diuspa Rimaita willaspa purii kalla­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chi­ura Feli­peka, Sama­ria suti alpapi chaiag­rispa, sug pui­blupi rimai kalla­rirka, Jesús, Taita Dius agllaska Cristo kagta willaspa. ");
INSERT INTO inb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chasa uias­paka achka­kuna, sug­lla­sina tukuspa, ima Felipe rima­kus­kata alli­lla uiai kalla­rir­ka­kuna, ñi pipas mana kawas­ka­sina rura­kug­manda. ");
INSERT INTO inb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Chi­ura­kuna kuku waira­kuna, achka­kuna­pag­manda kapa­rispa llugsi­chii tukur­ka­kuna. Sug­kuna kuiu­ringa­pag­lla­pas mana pudis­ka­kunata, chasa­lla­ta mana chaki­wa purin­ga­pa pudis­ka­kuna­ta­pas, achka­kuna­ta­mi alia­chispa sakir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tukui chasa kawas­ka­kuna, iapa alli iuia­chii­wa kun­tin­ta­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chipi tiarka sug runa, Simón suti. Chi runa, ña unai­manda­ta chi pui­blupi paipa mana alli iuiai­wa ruraspa kaug­sa­kurka. Kikinlla ni­kurka: “Nuka, tukui­kuna­manda mas iapa iacha­mi kani”. Chasaka, tukui chipi kaug­sa­na­kus­kata ujna­chispasi kaug­sa­kurka. ");
INSERT INTO inb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Paita man­cha­ris­ka­sinasi suma iuia­na­kurka. Atun taita­kuna­pas pai­manda ni­na­kurka: “Paimi Taita Diuspa iapa iachai­wa suma rura­ku”. ");
INSERT INTO inb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ña unai­manda­ta paipa mana alli iuiai­wa tukui­kunata ujna­chispa chari­kurka. ");
INSERT INTO inb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Chasapi kaug­sa­na­kuspa­pas, Felipe Jesu­cristo­manda i Diuspa suma mandaita willag­samus­kata uias­paka, Jesus­wa suma iuia­rir­ka­kuna. Nis­paka, kari i warmi baug­ti­sa­rii tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kikin Simon­pas­mi, Jesu­cristo­manda uias­paka, suma iuia­rig­samurka. Baug­ti­sa­rii tukus­paka, Felipewa purii kalla­rirka. Felipe ima­ura­pas mana kawas­ka­sina rura­kus­kata kawaspa, iapa ujna­rispa kawa­kurka. ");
INSERT INTO inb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Chi­ura­mandaka, Jesús kikin agllaska runa­kuna Jeru­sa­lenpi kas­ka­ma iacha­rig­samurka, Sama­ria­manda runa­kunapas Diuspa Rimaita suma uia­na­kugta. Chasa iacha­rig­samu­uraka, Pedro i Juanta chi pui­bluma kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Chi Sama­ria­manda­kuna, mana­ra Santu Ispi­ri­tuta chaskiska kar­ka­kuna. Iaia Jesuspa suti­lla­wa­mi baug­ti­sa­riska kar­ka­kuna. Chasa kag­manda, Pedro i Juanka, chaiag­rispa, Taita Dius­ta­mi mañar­ka­kuna, Santu Ispi­ri­tu­lla­tata pai­kuna­wa tukug­samuchu. ");
INSERT INTO inb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nis­paka, umapi maki churar­ka­kunata. Chasa­wa, Santu Ispi­ri­tu­ta­mi chas­kir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simonka kawarka, pai­kuna maki chura­ura, Santu Ispi­ri­tuta chas­kigta­kuna. Chasa kawas­paka, pai­kunata kulki muna­chispa, ");
INSERT INTO inb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nirka: —Nuka­ta­pas chasa­lla­ta iachai kara­wai­chi; chi­wanka, nuka mai­kan­ta­pas maki churaspa, Santu Ispi­ri­tuta karai pudin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedroka ainirka: —Kamba chi kulki kam kikin­wan­ta­mi puchuka­rin­ga­pa kan­gi­chi. Taita Dius kikin paipa Ispi­ri­tuta karan­ga­pa kacha­mus­kata, ¿kamba kulki­wachu muna­kungi randin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kamka, kai nukan­chi suma rura­na­kus­kapi mana pudingichu chapu­rin­ga­pa. Diuspa ñawipi, kam mana alli­lla iuiai­wa­mi kangi. ");
INSERT INTO inb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Kawa­kuikimi, kam nukan­chita llaki­rispa kawa­kugta. Kam kikin mana alli­lla ruras­ka­kuna watas­ka­sina­mi chari­nakú. Chasapaka, chi panda­rii­kunata sakispa, atun Taita Diusta nii: “Nuka imasa umapi mana alli­lla iuia­kus­kata pasin­sia­wai”. ");
INSERT INTO inb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Chi­ura, Simón ainirka: —Atun Taita Diusta nuka­manda maña­puai­chi, nukata imasa ni­was­ka­sina mana pasa­ri­wachu. ");
INSERT INTO inb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chi Jesús agllas­ka­kuna, Iaia Jesus­manda Suma Rimaita chi pui­blupi willas­paka, Sama­ria alpapi sug achka pui­blu­kuna­ta­pas willaspa ialir­ka­kuna, Jeru­sa­lenma kuti­na­kuspa. ");
INSERT INTO inb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Felipetaka, atun Taita Diuspa anjil nirka: —Ata­rispa, alli maki­sinama rii. Jeru­sa­len­manda Gaza suti pui­bluma ñambita rii—. (Chi ñambi, chusa sitaska alpa­lla­ta­mi ri­raiá.) ");
INSERT INTO inb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Chi­ura Felipe, ata­rispa, rirka. Chi ñambi­pika, Etiopía suti alpa­manda sug runa­wa tupa­na­kurka. Chi runa karka Kandase suti atun mandag warmipa aidag, kulkita waka­chig. Jeru­sa­lenma riska karka, Taita Diusta kungu­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kikin­pa alpama kuti­kus­paka, kaba­llu aliu­diru augtupi tia­kuspa, Isaías suti Santu Ispi­ri­tu­wa ñugpa­manda rimag ima willa­raias­kata kawa­kurka. ");
INSERT INTO inb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Felipewa chi runa­wa tupa­na­ku­ura, Santu Ispi­ri­tuka paita nirka: —Chi augtuma kai­lla­iag­rii. ");
INSERT INTO inb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Chi­ura Felipe, kalpa kai­lla­iag­rispa, uiarka chi runa imasa uia­ri­kus­kata. Nis­paka, tapurka: —Chi kawakus­kata, ¿iachan­gi­chu ima ni­raiagta? ");
INSERT INTO inb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Chi­ura, chi runaka ainirka: —Ñi pipas mana iacha­chi­wan­kuna­chu. Nig­pika, ¿imasatak nuka iachasa?—. Nis­paka, Felipeta mañarka— Dius­manda sika­mui, sug­lla­pi nuka­wa tia­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nigpika, kasa willa­ra­ias­ka­ta­chu chi runa kawa­kurka: Imasa­mi ubija, wañu­chii tukun­ga­pa apa­na­ku­ura i milma rutun­ga­pa ka­ura, mana kaparí: chasa­lla­ta­mi paika, wañu­chii tukun­ga­pa apa­na­ku­ura, mana ñi ima rima­rirka. ");
INSERT INTO inb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Justi­sia­kunaka, paita wabu­tispa, mana uiaspa­lla­mi wañu­chir­ka­kuna. Pai musu kagpita, kaug­sai­ta­mi anchu­chi­pur­ka­kuna. Chi­mandami wam­bra, mana paita tiapú. ");
INSERT INTO inb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chasa kawaspa willa­ura, chi runaka Felipeta tapurka: —Dius­manda willa­wai: chi rimag, ¿kikin­mandachu chasa rimarka; u sug­mandachu nirka? ");
INSERT INTO inb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Chasa willa­raias­kata kawas­paka, Felipe chi­ura­lla Jesus­manda willaspa, iacha­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chasa ñambi ri­na­kuska­pika, iaku tias­kapi chaiag­rir­ka­kuna. Chi­ura, chi runaka nirka: —Kaipi iakumi tia. ¿Mana­chu nuka­ta­pas pudi­rintra baug­ti­sa­wan­ga­pa?  ");
INSERT INTO inb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Chi­ura, Felipe nirka: —Jesu­cristo­wa kam suma iuia­riska kag­pika, baug­ti­sa­riimi pudingi. Chi­ura, chi runaka ainirka: —Suma­mi iuia­kuni, Jesu­cristo sutipa Taita Diuspa wam­bra kagta—. ");
INSERT INTO inb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chasa nis­paka, nirka— Augtuta saia­chii. Saia­chi­ura, iskandi­kuna iakuma urai­kus­paka, chi mandag runa­taka Felipe baug­ti­sarka. ");
INSERT INTO inb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Iskandi­kuna iaku­manda llugsi­ura, atun Taita Diuspa Ispi­ri­tu­wa diulpilla Felipeta aisaspa aparka. Chi mandag runa, paita mana mas kawarka. Chi runaka, iapa suma kun­tin­tu­lla paipa ñambi rii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipeka, Azoto suti pui­blupi kawa­rig­rirka. Chi­man­daka, pui­blu­kuna suiu purispa, Jesus­manda Alli Willaita willaspa ialirka, Sesarea suti pui­bluma chaian­kama. ");
INSERT INTO inb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chi­ura­kunaka Saulo, Iaia Jesus­wa tukus­ka­kunata wañu­chispa puchukan­ga­pa iuiai­lla­wa­mi puri­kurka. Chasa iuia­ris­paka, iaia sasir­duti iskribiska karta mañag­rirka, ");
INSERT INTO inb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Damasko suti pui­blu judiu­kuna tukui tanda­ri­diru wasi­kunapi iai­kui pudin­ga­pa; chi­kuna­pika, mai­kan kari i warmi­kuna Iaia Jesus­wa tukus­ka­kunata tarispa, apispa, Jeru­sa­lenma wataspa apan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Chasa mañas­paka, ñambi ri­kuska­pi, ñalla Damaskoma chaiag­rin­ga­pa ka­ura, diulpilla awa­nig­manda paita puncha­ia­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Puncha­ia­chig­lla­pi, Sauloka alpapi urmag­sa­murka. Chi­uraka, paita rimai uia­rig­samurka, kasa nispa: —Saulo, Saulo, ¿imapatak puchu­ka­wan­ga­pa iuiai­lla­wa puri­kungi? ");
INSERT INTO inb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Chi­ura, Saulo tapurka: —Kam Taitiku, ¿pitak kangi? Chasa tapu­ura, chi rimagka ainig­samurka: —Nukami kani Jesús. Nuka kikin­ta­mi puchuka­wan­ga­pa iuiai­lla­wa puri­kungi.  ");
INSERT INTO inb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Chasa uias­paka, Saulo, di­man­chai chugchuspa, tapurka: —Taitiku, ¿imatak nuka ruran­ga­pa muna­kungi? Chi­ura, Iaia Jesuska ainirka: —Atarispa rii. Chi pui­bluma iai­kug­rii. Chi­pi­mi kamta ninga­kuna, ima ruran­ga­pa chaiagta. ");
INSERT INTO inb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo­wa sug­lla­pi ri­na­kugka, rimaita uiar­ka­kuna. Kawaika, ñi pi­ta­pas mana kawar­ka­kuna. Chi­manda, iapa mancha­riska kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauloka, alpa­manda atari­uraka, ñi ima mana ñawi kawan­ga­pa pudirka. Nig­pika, paita maki­manda apispa, Damaskoma pusar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kimsa punchami chipi karka, mana ñawi kawan­ga­pa pudi. Chi puncha­kuna, ñi ima mana mikus­pa­lla upiaspa­lla­mi karka. ");
INSERT INTO inb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Chi pui­blu­lla­pita kaug­sa­kurka Jesus­wa tukuska runa, Ananías suti. Chi runa­taka Iaia Jesús, muskui ukupi­sina kawa­rispa, nirka: —Ananías. —Kaipi­mi kani, Taitiku— ai­nirka. ");
INSERT INTO inb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Chi­ura, Iaia Jesuska nirka: —Atarispa, Derecho suti ñam­bi­ma rii. Judaspa wasima chaiag­rii. Chi­pika, Tarso pui­blu­manda sug runa Saulo suti­mi kanga. Chi runa­pas, kuna­ura Taita Dius­ta­mi maña­ku. ");
INSERT INTO inb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ananías suti runa iai­kuspa, maki churag­ta­mi muskui uku­pi­sina kawarka, ikuti kawai pudin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Chasa uiaspa Ananiaska, Iaia Jesusta nirka: —Taitiku, achka­kuna­ta­mi chi runa­manda uiaska kani, Jeru­sa­lenpi kam­manda­lla iuia­rispa kag­kunata puchukan­ga­pa muna­kugta. ");
INSERT INTO inb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Chi runaka, kuna­ura iaia sasir­duti­kuna kacha­muskasi samu­ku, kaipi tukui kamwa suma iuia­rispa kag­kunata apis­paka, wataspa apan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Iaia Jesuska nirka: —Kamka riilla. Paita, nukami agllarkani, mana judíu kas­ka­kunata, pai­kunapa mandag­kunata i Israel­manda runa­kuna­ta­pas nuka­manda willa­puan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nukami paita kawa­chin­ga­pa kani, imasa pai kikin, nuka­manda iapa llakii­kuna iukan­ga­pa kagta. ");
INSERT INTO inb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Chasa uiaspa Ananiaska, Saulo kaska­ma­mi rirka. Chipi iai­kug­ris­paka, Saulota maki churaspa, nirka: —Waugki, Iaia Jesús, kam kikin­ta ñambipi samu­kus­kata kawa­rirka; pai Jesus­lla­ta­ta­mi nuka­ta kacha­mu­warka, kam ikuti kawai pudin­ga­pa. Chasa­lla­ta, Santu Ispi­ri­tupa iuiai­ta­mi chaskin­ga­pa kangi. ");
INSERT INTO inb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chasa nig­lla­pika, Saulota ñawi wichka­raiaska­manda­mi mapa­kuna­sina urmag­samurka. Chi­ura, ikuti alli­lla kawai pudirka. Nis­paka, ata­rispa, baug­ti­sa­rirka. ");
INSERT INTO inb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Miku­uraka, ikuti animu­pas chaiag­samurka. Chi­ura­manda Saulo, Jesus­wa tukus­ka­kuna Damaskopi kaug­sa­na­kugwa sug puncha­kunami chi­siarka. ");
INSERT INTO inb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chi puncha­kuna, judiu­kuna tanda­ri­diru wasi­kunapi Jesus­manda willai kalla­rirka, kasa nispa: —Jesús, Taita Diuspa wam­bra­mi ka. ");
INSERT INTO inb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tukui paita uiag­kuna, ujna­rispa, ni­na­kurka: —Kai, ¿mana­chu ka Jeru­sa­lenpi Jesus­wa tukus­ka­kunata puchukan­ga­pa muna­kug? Pai kikinsi kaima samurka, Jesus­wa tukus­ka­kunata wataspa, iaia sasir­duti­kuna­pagma apan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauloka, mana manchaspa­lla, ñugpa­manda librupi imasa willa­ra­ias­ka­sina iacha­chi­kurka, Jesús, Taita Dius agllaska Cristo kagta. Chasa iacha­chi­kuska­manda, Damas­kopi kaug­sag judiu­kuna, paipa rimaita ainin­ga­pa mana pudir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Achka puncha­kuna iali­ura, chi judiu­kuna, sug­lla iuiai tukuspa, rima­na­kurka, Saulota wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Puncha i tuta, chi pui­blu­manda llugsi­diru pungu­kunapi cha­paspa saia­na­kurka, paita apispa wañu­chin­ga­pa. Chi­taka, Saulo iachag­samurka. ");
INSERT INTO inb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Chasa iachas­paka, sug tuta Jesus­wa tukuska runa­kuna, paita atun saparu­pi junda­chispa, pui­blu kincha awa­nig­manda alpama urai­ku­chi­mur­ka­kuna. Chasa­pika, wañui kispirka. ");
INSERT INTO inb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jeru­salén pui­bluma chaiag­ris­paka, Saulo muna­kurka, Jesus­wa tukus­ka­kuna­wa sug­lla­pi kan­ga­pa. Chasa muna­kug­pipas, tukui­kuna pai­ta mancha­na­kurka. Saulo mani­ma Jesus­wa tukuska kagta iuia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Chasa iuia­na­kugpi­pas, Bernabeka, Saulo­pagma chaiag­ris­paka, Jesús kikin agllas­ka­kuna­pagma pusarka. Pai­kuna­pag­ma chaia­chig­ris­paka, willarka imasa Saulo, Damaskoma ñambipi ri­ku­ura, Iaia Jesús kawa­rispa, paita rimagta; chasa­lla­ta Damaskopi mana man­chas­pa­lla Jesus­manda willa­kugta. ");
INSERT INTO inb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Chi­ura­mandaka Saulo, chi Jesus­wa tukus­ka­kuna­wa Jeru­sa­lenpi purii kalla­rirka. Chi­pika, mana manchaspa­lla­mi Iaia Jesus­manda willai puri­kurka. ");
INSERT INTO inb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Paika, judiu­kuna griego rimai­wa rima­na­kuska­wa sin­chi sug rigcha sug rigcha Jesus­manda rima­na­kurka. Chi­mandaka, chi runa­kuna iuia­ri­na­kurka, paita wañu­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Chasa iachag­samuspa, Jesus­wa tukus­ka­kunaka paita pusar­ka­kuna Sesarea pui­bluma. Chi­mandaka, Tarso pui­bluma paita kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chi­ura­kuna, Judea, Gali­lea i Sama­ria alpa­kuna suiu, Jesus­wa tukus­ka­kuna sumag­lla kaug­sa­na­kurka, mana pi­ta­pas man­chas­pa­lla. Pai kikin­pura mas alli suma iuiai iuia­chi­na­kurka. Atun Taita Diusta suma manchaspa kuia­na­kurka. Santu Ispí­ritu pai­kunata sumag­lla iuia­chiska­wa masmi mira­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chi­kama Pedroka, Jesus­wa tukus­ka­kunata kawaspa puri­kurka. Puri­kuska­pika, Lida suti pui­bluma chaiag­rirka, chipi kaug­sa­na­kus­ka­ta­pas kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chi­pika, Eneas suti sug runa­wa tupa­na­kurka. Chi runa, mana kuir­pu kuiu­rin­ga­pa pudi, pusag wata ungug siri­kurka. ");
INSERT INTO inb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Chi runa­taka, Pedro nirka: —Jesu­cristomi kamta ambi­ku. Ata­rispa saia­rii. Kam puñu­diruta alli­chii. Chasa nig­lla­pi, Eneas ata­rispa saia­rirka. ");
INSERT INTO inb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Chasa kawas­paka, Lida i Sarón pui­blu­kuna­manda tukui runa­kuna Iaia Jesus­wa­mi tukur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope suti pui­blu­pika tiarka Jesus­wa tukuska sug warmi. Chi warmi suti karka Tabita u Dorkas. (Chi ni­raianmi taruka.) Iapa alli­lla ruraspa, tukui minis­tidu­kunata aidaspa kaug­sag warmimi karka. ");
INSERT INTO inb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chi warmika, Lida pui­blupi Pedro ka­ura, sin­chi ungui iukaspa, wañurka. Paita arma­chiska­ura­mandaka, awa ladu wasi atun ukupi iali­chispa churag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope­manda Lida pui­bluma mana iapa karu rin­ga­pa kanchu. Jesus­wa tukuska Jopepi kaug­sa­na­kugka, alli­lla­mi iachar­ka­kuna, Pedro Lidapi kagta. Chi­mandaka, iskai runa­kunata Lidama kachar­ka­kuna, “Utkalla Jopema samuchu” nin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Chaiag­rispa willag­rir­ka­kuna. Chi­ura Pedroka, chi runa­kuna­wa rirka. Jopema chaia­chig­ris­paka, paita pusar­ka­kuna wañuska kaska­ma. Chi ukupi iai­kug­ri­uraka, tukui chipi kag sapalla kidaska warmi­kuna wakaspa kalla­rir­ka­kuna, Dorkas kaug­sa­ura kikin ruraska i katanga iuka­chis­ka­kunata kawa­chin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedroka, tukui­kunata kanchama llugsi­chirka. Llugsi­chis­paka, kungu­rispa, Taita Diusta mañarka. Mañaska­ura­mandaka, chi warmi wañus­kata kawaspa, nirka: —Tabita, atarii. Chi­ura­lla, ñawi kawag­samurka. Pedrota kawas­paka, ata­rispa, tia­rirka. ");
INSERT INTO inb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Chi­ura Pedroka, maki­manda apispa, saia­chirka. Nis­paka, Jesus­wa tukus­ka­kunata i chi warmi­kunata kaiaspa, kaug­sa kag­ta­mi kawa­chig­samurka. ");
INSERT INTO inb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Cha­sa pasa­riskaka, Jope pui­blupi tukui kaug­sa­na­kuska­pag­pi­mi iacha­rig­samurka. Chi­manda, achka­kunami Iaia Jesus­wa tukug­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Chi­ura­manda Pedro, achka puncha­kuna chi pui­blupi chisiarka, Simón suti wagra kara jujuspa kurti­dur­pagpi. ");
INSERT INTO inb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesarea pui­blupi tiarka sug mana judíu runa, Kor­ne­lio suti. Pai, Italia­manda suti sul­da­du­kunata mandag­mi karka. ");
INSERT INTO inb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Taita Diusta suma kuiaspa man­chag­mi karka, chasa­lla­ta paipa wasipi tukui kag­kuna­pas. Achka kulki­wa judíu minis­tidu­kunata aida­dur­mi karka. Tukui puncha­kuna, Taita Diusta maña­dur karka. ");
INSERT INTO inb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chi runa­taka, sug chaugpi chisima ka­ura, Taita Diuspa anjil, muskui ukupi­sina diulpilla iai­kuspa, alli­lla kawa­rirka. Chi anjilka, paita nirka: —Kornelio. ");
INSERT INTO inb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Chasa kawas­paka, Kornelio iapa mancha­rig­samurka. Nis­paka, tapurka: —Kam taitaka, ¿imatak muna­kungi? Chi­ura, anjilka ainirka: —Taita Dius, kam ima maña­kus­ka­ta­mi uiarka. Chasa­lla­ta, iapa minis­tidu­kunata kulki kara­kus­ka­ta­mi kawarka. ");
INSERT INTO inb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kuna­uraka, kamba runa­kunata kachai Jope pui­bluma, Simón Pedro suti runata pusag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Chi runa, sug Simón suti wagra kara jujuspa kurti­durpa wasi­pi­mi ka. Chi Simonpa wasi, lamar iaku pata­lla­pi­mi saia­ku. ");
INSERT INTO inb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Chi anjil rig­lla­pi, Kornelioka, iskai paipa lutrin­kunata i sug sul­dadu Taita Dius­wa iuia­rig paipa iapa kuiaska kag­ta­mi kaiarka. ");
INSERT INTO inb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chi runa­kuna­taka tukui ima anjil rimas­kata willaspa, Jope pui­bluma kacharka. ");
INSERT INTO inb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kaiandika, chi runa­kuna Jopema kai­lla­ia­na­kug­ri­ura, Pe­dro­ka, ña chaugpuncha­sina ka­ura, wasi awa ladu truja­sinama sikarka, Taita Diusta mañan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pai­taka iarkai apirka. Mikui muna­kurka mikun­ga­pa. Mikui ianu­na­kun­kama, paita muskui ukupi­sina kawa­rig­samurka, ");
INSERT INTO inb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","sug luar paskaska kagta. Chi­pika, sug atun linsu­sina tukui chusku punta­kunata wataska urai­ku­mu­kug­sina kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lin­su uku­pika, sug rigcha sug rigcha chusku chaki­iug sachuku­manda animal­kuna, kuli­bra­kuna i pisku­kuna tiagtasi kawa­rirka. ");
INSERT INTO inb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chi­uraka, Pedrota rimai uia­rig­samurka: —Atarispa wañu­chii, mai­kan­ta­pas kam mikun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedroka ainirka: —Taitiku, nuka mana muna­ni­chu. Nuka, ñi ima­ura­pas chi mapa­sina ni­raias­ka­kunata mana mikuska ka­ni­chu. ");
INSERT INTO inb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ikuti chi rimaika uia­rig­sa­murka: —Kikin Taita Dius­mi kasa ni: “Mai­llas­ka­sina­mi kan­kuna”. Chi­manda­mi niiki: kam mana iuia­kui, chara mapa­sina kagta. ");
INSERT INTO inb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kimsa biaji chasa­lla­ta chasa­lla­ta kawa­chispa rimag­samurka. Chi­ura­mandaka linsu, awa­sinama tukui­wa sikarka. ");
INSERT INTO inb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chasa kawas­paka, Pedro iapa iuia­rii kalla­rirka: “Chi kawa­ri­waska, ¿ima­sik ni­raiá?”. Chasa iuia­ri­kun­kama, Kornelio kachas­ka­kunaka, Simonpa wasi­manda tapuspa tapuspa, wasi pungu­ma chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Chipi chaiag­ris­paka, tapur­ka­kuna: —Simón Pedro, ¿kaipichu kaugsá? ");
INSERT INTO inb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro chara imasa kawaska­manda iuia­ku­ura, Santu Ispi­ri­tuka paita nirka: —Kimsa runa­kunami kamta mas­ka­nakú. ");
INSERT INTO inb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nuka kacha­muska­mi kan­kuna. Chi­manda urai­kuspa, pai­kuna­wa riilla, mana man­chas­pa­lla. ");
INSERT INTO inb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Chi­ura Pedroka, urai­kuspa, chi runa­kunata nirka: —Nukami kani kam­kuna mas­ka­na­kuska. ¿Imapatak samu­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Chi­ura ainir­ka­kuna: —Kornelio suti sul­da­du­kunata mandagmi nukan­chita kacha­murka. Pai runa, alli iuiag, Taita Diusta suma kuiaspa manchag­mi ka. Paita, tukui judiu­kunami munan­kuna. Pai­taka, Taita Diuspa tukuipi alli anjilsi nirka: “Kachai Pedrota pusag­rin­ga­pa, samu­chu. Samu­uraka, uian­kangimi imasa­mi rimag­samú”. ");
INSERT INTO inb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Chasa uias­paka, Pedroka iai­ku­chir­ka­kunata, pusada maña­chin­ga­pa. Kaiandika, pai­kuna­wa rirka. Jope­manda Jesus­wa sug tukus­ka­kuna­pas, sug­lla­pi rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sug kaiandika, Sesarea pui­bluma chaiag­rir­ka­kuna. Chi­pika Kornelio, paipa­pura­kuna­wa chaia­na­ku­di­ruwa tanda­chispa, paipa wasipi suia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Chi wasima Pedro ña chaiag­ri­ku­uraka, Kornelio tupan­ga­pa rirka. Tupa­na­kus­paka, paita kungu­rirka. ");
INSERT INTO inb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedroka atari­chirka, kasa nispa: —Saiarii. Nuka­pas, kam­sina ianga runa­mi kani. ");
INSERT INTO inb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Chi­ura­manda, pai­wa rima­na­kuspa, wasi ukuma iai­kug­rir­ka­kuna. Chi­pika, achka runa­kuna tanda­riska kas­ka­kunata kawaspa, ");
INSERT INTO inb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedroka nir­ka­kunata: —Kam­kuna alli­lla­mi iachan­gi­chi: nukan­chi judiu­kunata michan­mi, sug­kuna­wa ianga rima­na­kun­ga­pa, piur pai­kunapa wasima iai­kug­rin­ga­pa. Chasa kagpi­pas, Taita Dius kikinmi willa­warka, mana pi­ta­pas mapa­sina kagta kawan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chi­manda­mi, kam­kuna pusa­mu­wan­ga­pa chaiag­rig­lla­pi, mana ñi ima piña­rispa­lla samur­kani. Chasa­manda­mi iachan­ga­pa munani: ¿imapatak kaia­wa­na­kun­gi­chi? ");
INSERT INTO inb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Chi­ura, Kornelioka ainirka: —Kasa­ura­lla­tata, ña chusku pun­cha­mi tukú; kai nuka­pa wasi uku­pi­mi karkani. Mana mikuspa­lla, chisima Taita Dius­ta­mi maña­kur­kani. Nig­pika diulpilla sug runa, pun­cha katanga chura­riska­mi kawa­ri­wag­samurka. ");
INSERT INTO inb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Chi runaka ni­warkami: “Kornelio, Taita Dius, kam ima maña­kus­ka­ta­mi uiarka. Chasa­lla­ta, iapa minis­tidu­kunata kulki kara­kus­ka­ta­mi kawarka. ");
INSERT INTO inb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kuna­uraka, kamba runa­kunata kachai Jope pui­bluma, Simón Pedro suti runata pusag­rin­ga­pa. Pai runa, sug Simón suti wagra kara jujuspa kurti­durpa wasi­pi­mi ka. Chi Simon­pa wasi, lamar iaku pata­lla­pi­mi ka”. ");
INSERT INTO inb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","—Anjil rima­wag­lla­pi­mi kachar­ka­ni, kamta maskag­rin­ga­pa. Kam, alli­lla­mi rurarkangi, nuka­wa samun­ga­pa. Kuna­ura, tukui­kuna­mi kan­chi Diuspa ñawipi. Muna­na­kun­chi­mi, tukui ima atun Taita Dius kamta nis­kata uian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Chi­ura, Pedroka nirka: —Kuna­ura nuka sutipa­mi iachani, Taita Diuspa ñawipi, tukui­kuna sug rigcha sug rigcha mana tiagta. ");
INSERT INTO inb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mai­kan runa­kunapas Taita Diusta suma kuiaspa man­chai­wa iuia­rispa alli­lla rurag­kunata, chi runa­kuna­ta­mi sutipa sumag­lla kawá. ");
INSERT INTO inb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","—Taita Dius, ñugpa­manda achala taita Israelpa wam­bra­kunapa kati wam­bra­kunata Jesu­cristo­wa­mi rimag­samurka, runa­kuna pai­wa sumag­lla kaug­sai tian­ga­pa. Pai Jesús, tukui­kunapa iaia­mi ka. ");
INSERT INTO inb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kam­kuna, alli­lla­mi iachan­gi­chi, Gali­lea alpa suiu, nis­paka Judea alpa suiupas imasa pasa­ri­kus­kata, Juan willaspa baug­ti­saspa puri­kus­ka­ura­manda­ta. ");
INSERT INTO inb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iachan­gi­chimi, imasa kikin Jesús, Nazaret pui­blu­manda kaspa, Taita Diusta Santu Ispi­ri­tu­wa chaskig­samugta; chasaka, tukui alli­lla pudin­ga­pa. Taita Dius pai­wa kag­manda, alli­lla ruraspa­mi puri­kurka. Mai­kanta iaia kuku­wa pagta­ris­ka­ta­pas anchu­chispa­mi puri­kurka. ");
INSERT INTO inb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","—Nukan­chika, Judea alpa suiu i Jeru­salén pui­blupi tukui ima Jesús suma ruras­kata kawaspa, sutipa willag­kuna­mi kan­chi. Pai­ta­ka, kruspi klabaspa­mi wañu­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Paita chasa wañu­chig­pi­kuna­pas, Taita Diuska kimsa pun­cha­pika ikuti­mi kaug­sa­chirka. Nis­paka sakirka, nukan­chita ikuti kawa­rig­samun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tukui runa­kunata mana kawa­rirkachu. Nukan­chi­lla­ta­mi kawa­rig­samurka. Nukan­chi­ta­mi Taita Dius ñugpa­man­da­ta agllarka, chasa kawas­kata willag­kuna kan­ga­pa. Nukan­chikar, Jesús ña wañuska kaugsa­riska­ura­manda­ta pai­wa mikuspa upiaspa­mi kar­kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chi­ura­manda paika, nukan­chi­ta­mi kacha­murka, tukui runa­kunata kasa willan­ga­pa: pai Jesus­ta­mi Taita Dius churarka, tukui kaug­sa i wañus­ka­kunata justi­sian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pai­manda­mi Santu Ispi­ri­tu­wa tukui ñugpata rimag­kuna willaska ni­raiarka, kasa nispa: “Mai­kan pai­wa suma iuia­rig­kuna, pai­kuna panda­ris­ka­kunata pasin­siaimi tukun­ga­pa kan­kuna”. ");
INSERT INTO inb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro rima­kug­lla­pi­mi kikin Santu Ispí­ritu, tukui kas­ka­kunapa sungupi iai­kug­samurka. ");
INSERT INTO inb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jesus­wa tukuska judiu­kuna Pedro­wa chaiag­ris­ka­kunaka, chi mana judíu kag­kuna­pas Santu Ispi­ri­tuta chaskigta kawaspa, iapa ujna­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Chi runa­kuna, mana iachaska rimai­kuna­wa rima­na­kus­kata i Taita Diusta iapa suma kagta ni­na­kus­kata uiaspa­mi chasa ujna­rir­ka­kuna. Chi­ura­manda, Pedroka nirka: ");
INSERT INTO inb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Kai runa­kunapas, Santu Ispi­ri­tuta ñami chaskir­ka­kuna, nukan­chi­sina­lla­tata. Nig­pika, ¿ima­manda­tak manara baug­ti­sa­ringa­kuna?—. ");
INSERT INTO inb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Chasa nispa, nirka— Jesu­cristopa suti­wa baug­ti­sa­rii­chi. Chi­ura­manda chipi kag­kuna, Pedrota mañar­ka­kuna, pai­kuna­wa sug puncha­kuna chisian­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesús kikin agllas­ka­kuna­ta i Judeapi kaug­sag Jesus­wa tukus­ka­kunata iacha­rig­sa­murka: mana judíu kag­kuna­pas, Diuspa Rimaita suma­mi uiar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro ikuti Jeru­sa­lenma chaiag­ri­uraka, Jesus­wa tukuska sug judiu­kuna mana muna­na­kurka, pai­kunapa ñugpa­manda­kuna ima ruran­ga­pa iacha­chis­kata sakin­ga­pa. Chi­manda­mi, paita piñaspa, ");
INSERT INTO inb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nir­ka­kuna: —¿Imapatak mana judíu kag­kunata chaia­kug­ringi? ¿Imapatak pai­kuna­wa sug­lla­pi miku­kug­ringi? ");
INSERT INTO inb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Chi­ura Pedroka, pai ima pasas­kata suiu­manda­ta willai kalla­rirka, kasa nispa: ");
INSERT INTO inb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nuka Jope suti kaska pui­blupi Taita Diusta maña­ku­ura­ka, muskui ukupi­sina kasa­mi kawar­kani. Sug atun linsu­sina tukui chusku punta­kunata wataska, awa­manda nuka kaska­ma­mi urai­ku­mu­kurka. ");
INSERT INTO inb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Alli­lla­mi kawarkani. Chi uku­pika, sug rigcha sug rigcha chusku chaki­iug sachu­ku­manda animal­kuna, kuli­bra­kuna i pisku­kuna tiag­ta­mi kawarka­ni. ");
INSERT INTO inb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chasa kawa­ku­uraka, kasa rimaimi uia­ri­wag­samurka: “Pedro, ata­rispa wañu­chii, mai­kan­ta­pas kam mikun­ga­pa”. ");
INSERT INTO inb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","—Nukaka ainirkani: “Tai­tiku, nuka mana muna­ni­chu. Nuka, ñi ima­ura­pas chi mapa­sina ni­raias­ka­kunata mana mikuska ka­ni­chu”. ");
INSERT INTO inb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","—Chi suma luar­manda rimaika, ikuti uia­ri­wag­samurka: “Kikin Taita Dius­mi kasa ni: ‘Mai­llas­ka­sina­mi kan­kuna’. Chi­manda­mi niiki: kam mana iuia­kui, chara mapa­sina kagta”. ");
INSERT INTO inb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","—Kimsa biaji chasa­lla­ta chasa­lla­ta kawa­chispa rima­wag­samurka. Chi­ura­mandaka chi linsu, awa­sinama tukui­wa sikarka. ");
INSERT INTO inb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","—Chi­ura­lla­tata, kimsa runa­kuna Sesarea­manda kachas­ka­kunami nuka kaska wasima chaiag­rir­ka­kuna, maska­wag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chi­ura, Santu Ispi­ri­tuka ni­warkami: “Pai­kuna­wa riilla, mana manchaspa­lla”. Sugta nukan­chi waug­kindi­kuna kaipi kag­kuna­pas­mi nuka­wa rir­ka­kuna. Chasa Sesa­reama chaiag­ris­paka, chi runa­kunata kachagpa wasipi iai­kug­rir­kan­chi. ");
INSERT INTO inb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Chi­ura chi runaka, kasa­mi nukan­chita willai kalla­rirka: “Sug anjil nuka­pa wasipi saia­kug­ta­mi kawarkani. Chi anjilka ni­warka: ‘Kamba runa­kunata kachai Jope pui­bluma, Simón Pedro suti runata pusag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pai runa­mi rimag­samun­ga­pa ka, kam i tukui wasipi kag­kuna imasa kispi­rin­ga­pa kagta­kuna’.” ");
INSERT INTO inb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","—Nuka chasa uiaspa, rimai kalla­ri­uraka, Santu Ispi­ri­tumi pai­kunapa sungupi iai­kug­samurka; imasa­mi ñugpata nukan­chi­pagma samuska karka: chasa­lla­ta. ");
INSERT INTO inb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iaia Jesús imasa nukan­chita nis­kata chi­ura­mi iuia­ri­wag­samurka. Kasa­mi niska karka: “Juan, iaku­lla­wa­mi baug­ti­sarka. Ikuti kam­kunaka, Santu Ispi­ri­tu­wa­mi baug­ti­sai tukun­ga­pa kan­gi­chi”. ");
INSERT INTO inb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nigpi, imasa­mi nukan­chi Iaia Jesu­cristo­manda suma iuias­ka­kunata, Taita Dius paipa Ispi­ri­tuta karag­sa­murka: chasa­lla­ta­mi pai­kuna­ta­pas kararka. Nig­pika nuka, ¿ima­tak kani, Taita Dius kikin muna­kus­kata: “Mana” nin­ga­pa? ");
INSERT INTO inb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Chasa uiaspa, Pedrota piñaspa kag­kunaka, upallaspa, Taita Diusta nir­ka­kuna: —Kam, iapa suma atun­mi kan­gi—. Kasa­pas­mi nir­ka­kuna— Sutipa­mi Taita Dius, mana judíu kag­kuna­ta­pas kará; chasaka pai­kuna, panda­rii­kunata sakispa, mana puchuka­ri­diru suma kaug­sai­ta iukan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Estebanta judiu­kuna wañu­chiska­ura­manda, tukui Jesus­wa tuku­na­kus­kata wañu­chin­ga­pa maskai kalla­rir­ka­kuna. Chi­manda sug­kuna, Fenisia i Chipre suti alpa­kunama miti­kur­ka­kuna. Sug­kunaka, Antio­kia suti pui­blu­ma­mi chaiag­rir­ka­kuna. Mai­ma­pas chaiag­ris­paka, judíu kag­kuna­lla­ta­mi Jesus­manda willa­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ikuti sug­kunaka, Antio­kiama chaiag­ris­paka, mana judíu kag­kuna­ta­pas­mi rimaspa, Iaia Jesus­manda willai kalla­rir­ka­kuna. Chi runa­kuna, Chipre­manda i Sirene pui­blu­manda­mi kar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Chi runa­kunaka, atun Taita Diuspa iapa iachaita iukaspa­mi Jesus­manda suma willa­na­kurka. Chasa uias­paka, achka runa­kunami, ñugpa­manda iuiai­kunata sakispa, Iaia Jesus­wa suma iuia­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalenpi Jesus­wa tukuska runa­kunata chasa iacha­rig­sa­murka. Chi­ura, Bernabe­ta­mi chi Antio­kiama kachar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Pai runaka karkami iapa alli, tukuipi Jesus­wa suma iuiag. Santu Ispi­ri­tupa iuiai­ta­mi iukarka. Paika, chi pui­bluma musug­lla chaiag­rispa, kawarka imasa Taita Dius pai­kunata sumag­lla kawaska kagta. Chi­manda­mi paika sumag­lla kun­tin­ta­rirka. Nis­paka, tukui pai­kuna­ta­mi suma iuia­chispa nirka: —Iaia Jesusta mana sakin­gi­chi. Pai­lla­wa iuia­rispa kaug­san­gi­chi—. Chi puncha­kunaka, iapa achka runa­kunami Iaia Jesus­wa tukug­samur­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chi­ura­manda Bernabeka, Tarso pui­bluma rirka, Saulota mas­kan­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chipi tarig­ris­paka, Antio­kia­ma­mi paita pusarka. Chipi chaiag­ris­paka, sug intiru wata­mi Jesus­wa tukus­ka­kuna­wa chisiag­rir­ka­kuna. Achka­kuna­ta­mi Jesus­manda iacha­chir­ka­kuna. Chi Antio­kia pui­blu­pi­mi Jesu­cristo­wa tukus­ka­kunata musug­lla suti­chii kalla­rir­ka­kuna: “cristiano”. ");
INSERT INTO inb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chi puncha­kuna Santu Ispi­ri­tu­wa sug rimag­kuna, Jeru­sa­len­manda chi pui­bluma chaiag­rir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Chipi chaiag­rig­pura sug, Agabo sutika, tukui­kuna uia­na­kus­kapi saia­rispa, Santu Ispi­ri­tu­wa­mi rimarka, kasa nispa: —Tukui alpa­pi­mi iapa iarkai tukug­samun­ga­pa ka—. (Imasa willas­ka­sina­mi nis­paka tukug­samurka, Klaudio suti Romapi iaia mandag ka­ura.) ");
INSERT INTO inb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Chasa willas­kata uias­paka, Jesus­wa tukus­ka­kunaka nir­ka­kuna: —Manara iarkai chaiagpi, nukan­chi kulki kacha­sun­chi, Judeapi kaug­sag Jesus­wa tukus­ka­kuna­manda. Imasa pudis­ka­sina, tukui­kuna karan­ga­pa kacha­sun­chi. ");
INSERT INTO inb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chasa­mi rurar­ka­kuna. Chi kulki tanda­chis­paka, Bernabeta i Saulota kachar­ka­kuna, pai­kuna, Judea alpama rispa, Jesus­wa tukuska iacha taita­kunata kuag­rin­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chi puncha­kuna, mandag Hero­deska Jeru­sa­lenpi Jesus­wa tukus­ka­kunata puchukan­ga­pa iuiai­wa api­chii kalla­rirka. ");
INSERT INTO inb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juan­pa waugki Santiago suti­ta­mi ispada­wa wañu­chir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chasa Hero­des rurag­manda, judiu­kunaka ajai kun­tin­ta­rig­samur­ka­kuna. Chi­manda, Pedro­ta­pas­mi api­chirka. Tan­da mana liba­dura­wa miku­diru puncha­kunami paita apir­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Paita api­chis­paka, kar­sil­pi­mi chu­ra­chirka. Chi kar­sil­pika, chusku chusku sul­da­du­kuna truka­rispa truka­rispa­mi kawa­na­kurka. Hero­des iuia­kurka, paskua atun pun­cha iali­ura, Pedrota llugsi­chispa, judiu­kunata kawa­chin­ga­pa, manara wañu­chispa­lla. ");
INSERT INTO inb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro kar­silpi kas­kata, sul­da­du­kuna alli­lla kawa­na­kurka. Ikuti Jesus­wa tukus­ka­kunaka, iapa­mi Taita Diusta maña­na­kurka, Hero­despa maki­manda kispi­chii tukun­ga­pa. ");
INSERT INTO inb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hero­des kaiandi judiu­kunata kawa­chin­ga­pa iuia­ku­ura, chi tutaka Pedro, iskai sul­da­du­kuna­pagma kadina­kuna­wa wataska puñu­kurka. Sug sul­da­du­kunaka, kar­sil pungupi saia­na­kurka. ");
INSERT INTO inb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Chi­uraka diulpilla atun Taita Dius­pa anjil, kar­silpi kawa­rig­samurka. Chi­ura, tukuipi puncha­iag­samurka. Chi anjilka, Pedrota taka­chispa rigcha­chirka, kasa nispa: —Utka atarii. Chasa nig­lla­pi, kadina­kunaka Pedropa maki­manda urmar­ka­kuna. ");
INSERT INTO inb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Chi­ura, chi anjilka nirka: —Chumbilli­rii. Chaki­kunapi chura­ri­diru­ta­pas chura­rii. Pedro chasa rura­uraka, nirka: —Kamba kata­ri­diru katangata kata­rispa, kati­wai. ");
INSERT INTO inb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Chi­ura­lla Pedro, anjilta kati­chispa, llugsirka, anjil chasa sutipa kagta mana iuia­kuspa­lla. Iuia­kurka: “Muskuichar musku­kuni”. ");
INSERT INTO inb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Uku ladu kawag sul­da­du­kunata ialir­ka­kuna. Ikuti sug pungupi kawa­na­kus­ka­ta­pas­mi ialir­ka­kuna. Kanchama llugsin­ga­pa iru punguma chaiag­ri­ura, chi pungu­pas­mi kikin­lla paska­rirka. Llugsispa, sug kallima chaiag­ri­ura, chi anjil, Pedrota sapalla sakirka.