﻿USE sofia;
DROP TABLE IF EXISTS sofia.iloulb_vpl;
CREATE TABLE iloulb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES iloulb_vpl WRITE;
INSERT INTO iloulb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Idi punganay, pinarsua ti Dios dagiti langit ken ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Awan langlanganga ti daga ken awan naggianna. Sipnget ti adda iti rabaw ti kaadalman. Ket ti Espiritu ti Dios, aggargaraw iti ngatoen ti rabaw dagiti danum. ");
INSERT INTO iloulb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kinuna ti Dios, “Mapaadda ti lawag” ket immadda ti lawag. ");
INSERT INTO iloulb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nakita ti Dios ti lawag, a daytoy ket nasayaat. Pinagsinana ti lawag ken ti sipnget. ");
INSERT INTO iloulb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Inawagan ti Dios ti lawag nga “aldaw,” ken inawaganna ti sipnget a “rabii.” Daytoy ket rabii ken bigat, ti umuna nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kinuna ti Dios, “Mapaadda ti nalawa a law-ang iti nagbaetan dagiti danum, ket daytoy ti mangbingay kadagiti danum manipud kadagiti danum.” ");
INSERT INTO iloulb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Inaramid ti Dios ti nalawa a law-ang ket pinagsinana dagiti danum nga adda iti babaen ti nalawa a law-ang ken ti danum nga adda iti ngatoen ti nalawa a law-ang. Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Inawagan ti Dios ti nalawa a law-ang a “tangatang.” Daytoy ket rabii ken bigat, ti maikadua nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kinuna ti Dios, “Maurnong iti maysa a disso dagiti danum nga adda iti babaen ti tangatang, ket agparang met ti disso nga awan danumna.” Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Inawagan ti Dios ti disso nga awan danumna iti “daga,” ken inawaganna dagiti nagmaymaysa a danum iti “baybay.” Nakitana a daytoy ket nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kinuna ti Dios, “Agrusing dagiti mulmula iti daga: mulmula a mangpatpataud iti bukel ken kaykayo nga agbunga iti adda bukelna, tunggal mula segun iti nagtaudanna.” Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nangpataud ti daga kadagiti mulmula, mulmula a mangpatpataud iti bukel segun iti ngataudanda. Nakita ti Dios a daytoy ket nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Daytoy ket rabii ken bigat, ti maika-tallo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kinuna ti Dios, “Mapaadda dagiti silaw iti tangatang a mangbngay iti aldaw ken iti rabii. Ket agbalinda a kas pagilasinan, kadagiti panawen, kadagiti aldaw ken kadagiti tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Agbalinda a silaw iti tangatang a mangted iti lawag iti daga.” Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Inaramid ti Dios iti dua a dakkel a silaw, ti dakdakkel a silaw nga agturay iti aldaw, ken ti basbassit a silaw nga agturay iti rabii. Inaramidna met dagiti bituen. ");
INSERT INTO iloulb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Inkabil ida ti Dios iti tangatang a manglawag iti daga, ");
INSERT INTO iloulb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","a mangituray iti aldaw ken iti rabii, ken mangbingay iti lawag ken iti sipnget. Nakita ti Dios a daytoy ket nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Daytoy ket rabii ken bigat, ti maika-uppat nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kinuna ti Dios, “Mapunno dagiti danum kadagiti pangen dagiti sibibiag a parsua, ken agtayab dagiti tumatayab iti ngatoen ti daga iti nalawa a law-ang ti tangatang.” ");
INSERT INTO iloulb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Pinarsua ti Dios dagiti dadakkel a parsua iti baybay, kasta met ti tunggal kita iti agbibiag a parsua, parsua nga aggargaraw ken aguummong iti danum, ken iti tunggal kita iti billit nga adda payyakna. Nakita ti Dios a daytoy ket nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Binendisionan ida ti Dios, a kunana, “Agbalinkayo a nabunga ken agpaadukayo, punuenyo dagiti danum nga adda kadagiti baybay. Agpaadu dagiti tumatayab iti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Daytoy ket rabii ken bigat, ti maika-lima nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kinuna ti Dios, “Mapataud iti daga dagiti sibibiag a parsua, tunggal maysa segun iti bukodda a kita, dagiti dingwen, dagiti agkarkarayam a banbanag, ken dagiti narurungsot iti daga, tunggal maysa segun iti bukodda a kita.” Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Pinarsua ti Dios dagiti narurungsot nga ayup iti daga iti bukodda a kita, dagiti dingwen iti bukodda a kita, ken amin nga agkarkarayam iti daga iti bukodda a kita. Nakitana a daytoy ket nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kinuna ti Dios, “Mangaramidtayo iti tao a kalanglangatayo, kas kadatayo. Iturayanda dagiti lames iti baybay, dagiti dingwen, ti entero a daga, ken ti tunggal agkarkarayam a banag iti rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Pinarsua ti Dios ti tao a kalanglangana. Iti bukodna a langa, pinarsuana isuna. Pinarsuana ida a lalaki ken babai. ");
INSERT INTO iloulb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Binendisionan ida ti Dios a kinunana kadakuada, “Agbalinkayo a nabunga ken agpaadukayo. Punwenyo ti daga ket iturayanyo daytoy. Iturayanyo dagiti lames iti baybay, dagiti tumatayab iti tangatang ken tunggal sibibiag a banag nga aggargaraw iti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kinuna ti Dios, “Kitaenyo, intedko kadakayo ti tunggal mula a mangpatpataud iti bukel iti rabaw ti daga, ken tunggal kayo nga agbungbunga nga addaan iti bukel. Taraonto dagitoy kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Iti tunggal narungsot nga ayup iti daga, iti tunggal tumatayab iti langit, ken kadagiti amin nga agkarkarayam iti rabaw ti daga, ken iti tunggal parsua nga addaan iti anges ti biag, intedko ti tunggal nalangto a mula nga agserbi a taraonda.” Ket kasta ngarud ti napasamak. ");
INSERT INTO iloulb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nakita ti Dios ti amin nga inaramidna. Pudno a nakasaysayaat daytoy. Daytoy ket rabii ken bigat, ti maika-innem nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ket nalpas dagiti langit ken ti daga, ken dagiti amin nga agbibiag a banbanag a nangpunno kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Iti maika-pito nga aldaw, nalpas ti Dios ti trabahona, isu a naginana isuna iti maika-pito nga aldaw manipud iti amin a trabahona. ");
INSERT INTO iloulb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Binendisionan ti Dios ti maika-pito nga aldaw ken imbilangna daytoy a nasantoan nga aldaw, gapu ta iti daytoy, naginana isuna manipud iti amin a trabahona iti panangparsuana. ");
INSERT INTO iloulb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dagitoy dagiti pasamak maipapan kadagiti langit ken iti daga, idi naparsua dagitoy, iti aldaw nga inaramid ni Yaweh a Dios ti daga ken dagiti langit. ");
INSERT INTO iloulb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Awan pay ti babassit a kayo ti tay-ak iti daga, ken awan pay ti nagrusing a mulmula iti daga, gapu ta saan pay a pinagtudo ni Yahweh a Dios, ken awan ti tao a mangsukay iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ngem adda angep a nagpangato manipud iti daga ket dinanumanna ti entero a rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Inaramid ni Yahweh a Dios ti tao manipud iti tapuk ti daga, inyangesna iti agongna ti anges ti biag, ket nagbalin a sibibiag a parsua ti tao. ");
INSERT INTO iloulb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nangikabil ni Yahweh a Dios iti minuyongan iti dayaen a paset, iti Eden, ket inkabilna sadiay ti lalaki a sinukogna. ");
INSERT INTO iloulb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Manipud iti daga, pinadakkel ni Yahweh a Dios ti tunggal kayo a makaay-ayo iti panagkita ken nasayaat a kanen. Nairaman ditoy ti kayo ti biag nga adda idiay tengnga ti minuyongan, ken ti kayo iti pannakaammo iti nasayaat ken dakes. ");
INSERT INTO iloulb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Adda karayan a rimmuar manipud iti Eden a mangdanum iti minuyongan. Manipud sadiay, nabingay daytoy ket nagbalin nga uppat a karayan. ");
INSERT INTO iloulb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ti nagan ti umuna ket Pison. Daytoy ti agay-ayus iti entero a daga ti Havila, a ditoy ket adda ti balitok. ");
INSERT INTO iloulb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Napintas ti balitok iti dayta a daga. Adda met ti bidelio ken ti onix a bato sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ti nagan ti maikadua a karayan ket Gihon. Agay-ayus daytoy iti entero a daga ti Cus. ");
INSERT INTO iloulb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ti nagan ti maika-tallo a karayan ket Tigris, nga agay-ayus iti daya ti Assur. Ti maika-uppat a karayan ket ti Eufrates. ");
INSERT INTO iloulb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Innala ni Yahweh a Dios ti tao ket impanna isuna idiay minuyongan ti Eden tapno sukayen ken taripatoenna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Binilin ni Yahweh a Dios ti tao a kunana, “Nawayaka a mangan manipud iti tunggal kayo iti minuyongan. ");
INSERT INTO iloulb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ngem saanka a mangmangan manipud iti kayo ti pannakaammo iti nasayaat ken dakes, ta iti kanito a manganka manipud iti daytoy, awan duadua a matayka.” ");
INSERT INTO iloulb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ket kinuna ni Yahweh a Dios, “Saan a nasayaat nga agmaymaysa ti lalaki. Mangaramidak iti kaduana a maitutop kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Manipud iti daga, inaramid ni Yaweh a Dios ti tunggal ayup iti daga ken tunggal tumatayab iti tangatang. Ket inyegna dagitoy iti ayan ti lalaki tapno kitaenna no ania ti iyawagna kadagitoy. Aniaman nga iyawag ti lalaki iti tunggal parsua, dayta ti naganna. ");
INSERT INTO iloulb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Pinanaganan ti lalaki dagiti amin a dingwen, dagiti billit iti tangatang, ken ti tunggal narungsot nga ayup nga adda iti tay-ak. Ngem iti lalaki, awan ti nasarakan a kaduana a maitutop kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Pinaturog ni Yahweh a Dios iti nasimbeng ti lalaki. Nangala ni Yahweh a Dios iti maysa kadagiti paragpagna ket inserrana ti lasag a nangalaanna iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Babaen iti paragpag nga innala ni Yahweh a Dios manipud iti lalaki, inaramidna ti babai ket inyegna daytoy iti lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kinuna ti lalaki, “Ita, daytoy ket tulang dagiti tulangko, ken lasag ti lasagko.” Maawagan isuna a 'babai,' gapu ta naala isuna manipud iti lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Iti kasta, panawanto iti lalaki ti ama ken inana, makipagmaymaysa isuna iti asawana, ket agbalinda a maymaysa a lasag. ");
INSERT INTO iloulb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Agpada a lamo-lamo ti lalaki ken ti asawana a babai, ngem saanda a mabain. ");
INSERT INTO iloulb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ita, ti uleg ket nasiksikap ngem kadagiti dadduma a narungsot nga ayup iti tay-ak nga inaramid ni Yahweh a Dios. Kinunana iti babai, “Agpayso kadi a kinuna ti Dios a, 'Saankayo a mangmangan manipud iti aniaman a kayo iti minuyongan?”' ");
INSERT INTO iloulb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kinuna ti babai iti uleg, “Mabalinmi a kanen ti bunga manipud kadagiti kayo iti minuyongan, ");
INSERT INTO iloulb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ngem maipapan iti bunga ti kayo nga adda iti tengnga ti minuyongan, kinuna ti Dios, 'Saanyo a mabalin a kanen daytoy, wenno sagiden man laeng daytoy, ta no aramidenyo dayta, mataykayo.”' ");
INSERT INTO iloulb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kinuna ti uleg iti babai, “Saan, saankayo a matay. ");
INSERT INTO iloulb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ta ammo ti Dios nga iti aldaw a kanenyo daytoy, malukatan dagiti matayo, ket agbalinkayonto a kas iti Dios, nga ammona ti naimbag ken dakes.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ket idi nakita ti babai a ti kayo ket nasayaat a kanen, ken makaay-ayo daytoy iti mata, ken ti kayo ket makapaawis a mangpasirib iti tao, nangala ti babai kadagiti bungana, ket kinnanna daytoy. Ken inikkanna met ti asawana a kaduana, ket kinnanna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Agpada a nalukatan dagiti matada, ken naamirisda a lamo-lamoda. Nangdaitda kadagiti bulbulong ti igos ket nangaramidda iti pangabbongda kadagiti bagbagida. ");
INSERT INTO iloulb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nanggegda ti arimpadek ni Yahweh a Dios iti minuyongan iti kalalammiisan ti aldaw, isu a naglemmeng ti lalaki ken ti asawana manipud iti presensia ti Dios, kadagiti kakay-kaywan iti minuyongan. ");
INSERT INTO iloulb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Immawag ni Yahweh a Dios iti lalaki ket kinunana kenkuana, “Sadino ti ayanmo?” ");
INSERT INTO iloulb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kinuna ti lalaki, “Nanggegko nga addaka iti minuyongan, ket nagbutengak, gapu ta lamo-lamoak. Isu't gapuna a naglemmengak.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kinuna ti Dios, “Siasino ti nangibaga kenka a lamo-lamoka? Nanganka kadi manipud iti kayo nga imbilinko a saanmo a mabalin a kanen?” ");
INSERT INTO iloulb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kinuna ti lalaki, “Ti babai nga intedmo a makaduak, inikkannak iti bunga manipud iti kayo, ket kinnanko.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kinuna ni Yahweh a Dios iti babai, “Ania daytoy nga inaramidmo?” Kinuna ti babai, “Inallilawnak ti uleg, ket nanganak.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kinuna ni Yahweh a Dios iti uleg, “Gapu ta inaramidmo daytoy, mailunodka kadagiti amin a dingwen ken kadagiti amin a narungsot nga ayup iti tay-ak. Aguyaska babaen iti tianmo, ken tapokto ti kanem iti amin nga aldaw ti panagbiagmo. ");
INSERT INTO iloulb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mangikabilak iti pagginnuraanyo iti babai, ken iti bukelmo ken ti bukelna. Dunurennanto ti ulom, ken dunuremto ti mukodna.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kinunana met iti babai, “Pakaruek iti kasta unay ti ut-ot iti panaganakmo; iti nakaro a rigat, ipasngaymo dagiti annakmo. Ti tarigagaymonto ket para iti asawam, ngem iturayannakanto.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kinunana kenni Adan, “Gapu ta dimngegka iti timek ti asawam, ken nanganka manipud iti kayo, maipapan iti imbilinko kenka, a kunak, 'Saanka a mabalin a mangan manipud iti daytoy,' mailunod ti daga gapu kenka; mangankanto manipud iti nagrigatam iti amin nga aldaw ti panagbiagmo. ");
INSERT INTO iloulb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mangpataudto daytoy kadagiti sisiit ken balang a mulmula a para kenka, ket kanemto dagiti mula iti tay-ak. ");
INSERT INTO iloulb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Babaen iti ling-et iti rupam, mangankanto iti tinapay aginggana nga agsublika iti daga, ta iti daytoy ti naggapuam. Gapu ta tapokka, ket agsublikanto met laeng iti tapok.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pinanaganan ti lalaki ti asawana nga Eva gapu ta isuna ti ina dagiti amin nga agbibiag a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nangaramid ni Yahweh a Dios kadagiti pagan-anay a lalat para kenni Adan ken iti asawana ket kinawesanna ida. ");
INSERT INTO iloulb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Kinuna ni Yahweh a Dios, “Ita, nagbalin a kasla kadatayo ti lalaki, ammona ti naimbag ken dakes. Isu nga ita, masapul a saanen isuna a mapalubusan a mangigaw-at iti imana a mangala manipud iti kayo ti biag, kanenna daytoy, ket agbiag iti agnanayon.” ");
INSERT INTO iloulb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Isu a pinapanaw isuna ni Yahweh a Dios manipud iti minuyongan ti Eden, tapno sukayenna ti daga nga isu ti nakaalaanna. ");
INSERT INTO iloulb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pinapanaw ngarud ti Dios ti lalaki iti minuyongan, ket nangikabil isuna iti kerubim iti daya ti minuyongan ti Eden, ken umap-apoy a kampilan nga agrikrikos, tapno mabantayan ti dalan nga agturong iti kayo ti biag. ");
INSERT INTO iloulb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kinaidda ti lalaki ti asawana a ni Eva. Nagsikog isuna ket impasngayna ni Cain. Kinuna ti babai, “Nangipasngayak iti lalaki babaen iti tulong ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kalpasanna, impasngayna ti kabsat ni Cain a ni Abel. Ita, ni Abel ket nagbalin nga agpaspastor, idinto a ni Cain ket nagtrabaho iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Napasamak nga iti panaglabas ti tiempo, nangidatag ni Cain kadagiti bunga ti daga kas daton kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ni Abel met ket nangidatag manipud kadagiti umuna nga annak ti arbanna ken kadagiti taba. Inawat ni Yahweh ni Abel ken ti datonna, ");
INSERT INTO iloulb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ngem saanna nga inawat ni Cain ken ti datonna. Isu a nakaunget unay ni Cain, ket nagruppanget isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kinuna ni Yahweh kenni Cain, “Apay ngay met a makaunget ken nakaruppangetka? ");
INSERT INTO iloulb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","No ar-aramidem ti umno, saanka kadi nga awaten? Ngem no saanmo nga ar-aramiden ti umno, agur-uray ti basol iti ruangan ket tartarigagayannaka a tenglen, ngem masapul nga iturayam daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nakisarita ni Cain iti kabsatna a ni Abel, ket kabayatan nga addada iti kataltalunan, dinuklos ni Cain ti kabsatna a ni Abel ket pinatayna isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kalpasanna, kinuna ni Yahweh kenni Cain, “Sadino ti ayan ti kabsatmo a ni Abel?” Kinunana, “Saanko nga ammo. Siak aya ti para-aywan iti kabsatko?” ");
INSERT INTO iloulb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kinuna ni Yahweh, “Ania ti inaramidmo? Umaw-awag kaniak ti dara ti kabsatmo manipud iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ita, nailunodka iti daga, inungapna dagiti ngiwatna a mangawat iti dara ti kabsatmo manipud iti imam. ");
INSERT INTO iloulb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Manipud ita, no sukayem ti daga, saanna nga ipaay ti pigsana kenka. Aglemmelemmeng ken agalla-allakanto iti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kinuna ni Cain kenni Yahweh, ” Ti dusak ket dakdakkel ngem iti kabaelak. ");
INSERT INTO iloulb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Pudno, iti daytoy nga aldaw ket pinatalawnakon manipud iti daytoy a daga ket mailemmengakto manipud iti rupam. Aglemmelemmeng ken agalla-allaakto iti daga, ket siasinoman a makasarak kaniak ket patayennak.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kinuna ni Yahweh kenkuana, “No addaman ti mangpapatay kenni Cain, mabalesto isuna iti maminpito a daras.” Kalpasanna, minarkaan ni Yahweh ni Cain, tapno saanto isuna a dangran ti siasinoman a tao a makasarak kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Isu a pimmanaw ni Cain manipud iti presensia ni Yahweh ket nagnaed iti daga iti Nod, iti daya iti Eden. ");
INSERT INTO iloulb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kinaidda ni Cain ti asawana ket nagsikog. Impasngayna ni Enoc. Nangibangon isuna iti siudad ket pinanagananna daytoy nga insurotna iti nagan ti putotna a ni Enoc. ");
INSERT INTO iloulb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Naaddaan ni Enoc iti putot ket isu ni Irad. Naaddaan ni Irad iti putot ket isu ni Mehujael. Naaddan ni Mehujael iti putot ket isu ni Metusael. Naaddaan ni Metusael iti putot ket isu ni Lamec. ");
INSERT INTO iloulb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dua iti inasawa ni Lamec: Ada ti nagan ti maysa ken Zilla met ti nagan ti maysa. ");
INSERT INTO iloulb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Impasngay ni Ada ni Jabal. Isuna ti ama dagiti agnanaed kadagiti tolda nga addaan kadagiti taraken nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jubal ti nagan ti kabsatna a lalaki. Isuna ti ama dagiti agtuktukar iti arpa ken plauta. ");
INSERT INTO iloulb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ni Zilla met, impasngayna ni Tubal Cain, nga agpanpanday kadagiti alikamen a tanso ken landok. Ti kabsat a babai ni Tubal Cain ket ni Naama. ");
INSERT INTO iloulb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kinuna ni Lamec kadagiti assawana, “Ada ken Zilla, dummegkayo iti timekko; dakayo nga assawa ni Lamec, dumngegkayo iti ibagak. Ta nakapatayak iti lalaki gapu iti panangsugatna kaniak, maysa nga agtutubo a lalaki gapu ta dinunornak. ");
INSERT INTO iloulb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","No ni Cain ket naibales iti naminpito a daras, pudno a maibales ni Lamec iti pitopulo ket pito a daras.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kinaidda manen ni Adan ti asawana ket naganak iti maysa pay a lalaki. Pinanaganan ni Eva dayta iti Set ket kinunana, “Inikkannak ti Dios iti maysa pay nga anak a lalaki a kasukat ni Abel, ta pinatay isuna ni Cain.” ");
INSERT INTO iloulb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Naaddaan ni Set iti putot ket pinanagananna iti Enos. Kalpasanna, ket inrugi dagiti tattao nga immawag iti nagan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Daytoy ti listaan dagiti kaputotan ni Adan. Iti aldaw a pinarsua ti Dios ti tao, inaramidna ida a kalanglangana. ");
INSERT INTO iloulb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Pinarsuana ida a lalaki ken babai. Binendisionanna ida ken pinanagananna ida iti tao, idi naparsuana ida. ");
INSERT INTO iloulb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Idi nagbiag ni Adan iti 130 a tawen, naaddaan isuna iti putot a lalaki a kalanglangana, a kaas-aspingna, ket pinanagananna daytoy iti Set. ");
INSERT INTO iloulb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kalpasan iti pannakaipasngay ni Set, nagbiag pay ni Adan iti 800 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nagbiag ni Adan iti 930 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Idi nadanon ni Set iti 105 a tawen, naaddaan isuna iti putot ket isu ni Enos. ");
INSERT INTO iloulb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kalpasan iti pannakaipasngay ni Enos, nagbiag pay ni Set iti 807 a tawen, ken naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nagbiag ni Set iti 912 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Idi nadanon ni Enos iti 90 a tawen, naaddaan isuna iti putot ket isu ni Kenan. ");
INSERT INTO iloulb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kalpasan iti pannakaipasngay ni Kenan, nagbiag pay ni Enos iti 815 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nagbiag ni Enos iti 905 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Idi nadanon ni Kenan iti 70 a tawen, naaddaan isuna iti putot ket isuni Mahalalel. ");
INSERT INTO iloulb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kalpasan iti pannakaiyanak ni Mahalalel, nagbiag pay isuna iti 840 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nagbiag ni Kenan iti 910 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Idi nadanon ni Mahalalel iti 65 a tawen, naaddaan isuna iti putot ket isu ni Jared. ");
INSERT INTO iloulb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kalpasan iti pannakaiyanak ni Jared, nagbiag pay ni Mahalalel iti 830 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Nagbiag ni Mahalalel iti 895 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Idi nadanon ni Jared iti 162 a tawen, naaddaan isuna iti putot ket isu ni Enoc. ");
INSERT INTO iloulb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kalpasan iti pannakaipasngay ni Enoc, nagbiag pay ni Jared iti 800 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Nagbiag ni Jared iti 962 a tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Idi nadanon ni Enoc iti 65 a tawen, naaddaan isuna iti putot ket isu ni Metusalem. ");
INSERT INTO iloulb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nagna ni Enoc a kaduana ti Dios iti 300 a tawen kalpasan iti pannakaipasngay ni Metusalem. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Nagbiag ni Enoc iti 365 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Nagna ni Enoch a kaduana ti Dios, ket kalpasanna, nagpukaw, ta innala isuna ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Idi nadanon ni Metusalem iti 187 a tawen, pinutotna ni Lamek. ");
INSERT INTO iloulb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kalpasan iti pannakaipasngay ni Lamek, nagbiag pay ni Metusalem iti 782 a tawen. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Nagbiag ni Metusalem iti 969 tawen, ket kalpasanna, natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Idi nadanon ni Lamek iti 182 a tawen, naaddaan isuna iti putot a lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Pinanagananna daytoy iti Noe, kinunana, “Mangiyegto daytoy iti inana manipud iti panagtrabahotayo ken kadagiti nadagsen a trabaho dagiti imatayo, nga isu iti masapul nga aramidentayo gapu iti daga nga inlunod ni Yaweh. ");
INSERT INTO iloulb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nagbiag ni Lamek iti 595 a tawen kalpasan iti pannakaipasngay ni Noe. Naaddaan isuna iti adu pay nga annak a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Nagbiag ni Lamek iti 777 a tawen. Kalpasanna ket natay. ");
INSERT INTO iloulb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kalpasan a nagbiag ni Noe iti 500 a tawen naaddaan isuna kadagiti annak a ni Sem, Ham ken Jafet. ");
INSERT INTO iloulb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Dimteng ti tiempo nga immadu ti tao iti rabaw ti daga ken nangipasngayda kadagiti annak a babbai, ");
INSERT INTO iloulb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ket nakita dagiti annak a lallaki ti Dios a makaay-ayo dagiti annak a babbai ti tao. Nangalada kadagiti inasawada, siasinoman kadakuada a napilida nga asawaen. ");
INSERT INTO iloulb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kinuna ni Yahweh, “Saan nga agtalinaed ti Espirituk iti sangkatao-an iti agnanayon, gapu ta isuda ket lasag. Agbiagda iti 120 a tawen.” ");
INSERT INTO iloulb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Addan iti rabaw ti daga dagiti higante kadagidiay nga al-aldaw, ken kasta met kadagiti simmaruno pay nga al-aldaw. Napasamak daytoy idi inasawa dagiti annak a lallaki ti Dios dagiti annak a babbai dagiti tattao, ket naaddaanda kadagiti annak. Dagitoy dagiti maingel a lallaki idi, nalalatakda a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nakita ni Yaweh a nakaru ti kinadakes ti sangkatao-an iti daga, ken agtultuloy a dakes laeng ti tunggal pagduyusan dagiti pagayatan dagiti pusoda. ");
INSERT INTO iloulb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Nagbabawi ni Yahweh a pinarsuana ti sangkatao-an iti rabaw ti daga, ken daytoy ti nagladingitan iti pusona. ");
INSERT INTO iloulb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Isu a kinuna ni Yahweh, “Pukawekto ti pinarsuak a sangkatao-an manipud iti rabaw ti daga; dagiti tattao ken dagiti dadakkel nga ayup, ken dagiti agkarkarayam a banbanag ken dagiti billit iti tangatang, ta agbabbabawiak nga inaramidko ida.” ");
INSERT INTO iloulb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ngem makaay-ayo ni Noe iti imatang ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dagitoy dagiti pasamak maipapan kenni Noe. Nalinteg a tao ni Noe, ken awan pakapilawanna kadagiti tattao iti tiempona. Nagna ni Noe a kaduana ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Naaddaan ni Noe iti tallo nga annak a lallaki: ni Sem, ni Ham, ken ni Jafet. ");
INSERT INTO iloulb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dakes ti lubong iti sangoanan ti Dios, ken napnoan daytoy iti kinaranggas. ");
INSERT INTO iloulb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nakita ti Dios ti daga; a daytoy ket dakes, ta amin a lasag ket dimmakesen ti wagasda iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kinuna ti Dios kenni Noe, “Makitak a panawenen a pagpatinggaen ti amin a lasag, ta napnoan iti kinaranggas ti daga gapu kadakuada. Pudno a dadaelekto ida agraman ti daga. Mangaramidka iti daongmo manipud iti tarikayo iti sedro. ");
INSERT INTO iloulb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mangaramidka kadagiti siled iti uneg ti daong, ken palitadaam daytoy iti alketran iti uneg ken ruarna. ");
INSERT INTO iloulb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kastoyto ti panangaramidmo iti daytoy: ti kaatiddog ti daong ket 300 a cubits, 50 a cubits ti kaakabana, ken ti kangatona daytoy ket 30 a cubits. ");
INSERT INTO iloulb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atepam ti daong, ket leppasem daytoy nga addaan iti maysa a cubit ti kangatona manipud iti tapaw ti didingna. Mangikabilka iti ruangan iti sikigan ti daong ken mangaramidka iti akin-baba, maikadua, ken maikatlo a kadsaaranna. ");
INSERT INTO iloulb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dumngegka, dandanikon a layusen ti daga, a mangdadael iti amin a lasag nga addaan anges ti biag iti sirok ti langit. Matayto amin nga adda iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ngem makitulagak kenka. Sumrekkanto iti uneg ti daong, sika, ken dagiti annakmo a lallaki, ken ti asawam, ken dagiti assawa dagiti annakmo. ");
INSERT INTO iloulb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tunggal sibibiag a parsua iti amin a lasag, masapul a mangitugotka iti uneg ti daong iti sagdudua iti tunggal kita, tapno agtalinaedda a sibibiag a kaduam, lalaki ken babai. ");
INSERT INTO iloulb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kadagiti amin a kita ti tumatayab, ken kadagiti amin a kita dagiti dadakkel nga ayup, ken tunggal kita dagiti agkarkarayam a parsua iti daga, dua iti tunggal kita ti umay kenka, tapno agtalinaedda a sibibiag. ");
INSERT INTO iloulb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mangurnongka iti tunggal kita iti taraon ket idulinmo daytoy, ket agserbi dagitoy a taraonmo ken taraonda.” ");
INSERT INTO iloulb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Inaramid ngarud daytoy ni Noe. Inaramidna dagitoy a maiyannurot iti amin nga imbilin ti Dios kenkuana,. ");
INSERT INTO iloulb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kinuna ni Yahweh kenni Noe, “Umayka iti uneg iti daong, sika ken dagiti amin a bumalaymo, ta nakitak a nalintegka iti imatangko iti daytoy a henerasion. ");
INSERT INTO iloulb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Iti tunggal nadalus nga ayup, mangitugotka iti sagpipito a lallaki ken sagpipito a babbai. Ken kadagiti ayup a saan a nadalus, mangitugotka iti dua, maysa a lalaki ken maysa a babai. ");
INSERT INTO iloulb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kasta met kadagiti billit iti tangatang, mangitugotka iti pito a lallaki ken pito a babbai, tapno mataginayonda iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ta kalpasan iti pito nga aldaw, pagtuduekto iti rabaw ti daga iti uppat a pulo nga aldaw ken uppat a pulo a rabii. Dadaelekto ti tunggal sibibiag a banbanag nga inaramidko, manipud iti rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Inaramid ni Noe ti amin nga imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Agtawen ni Noe iti innem a gasut idi immay ti layus iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Simrek ni Noe, dagiti annakna, ti asawana, ken dagiti assawa dagiti annakna iti daong gapu iti danum ti layus. ");
INSERT INTO iloulb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Dagiti nadalus nga ayup ken dagiti saan a nadalus nga ayup, dagiti billit, ken amin nga agkarkarayam iti rabaw ti daga ");
INSERT INTO iloulb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sagdudua, lalaki ken babai, immayda kenni Noe ket simrekda iti daong, kas iti imbilin ti Dios kenni Noe. ");
INSERT INTO iloulb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Napasamak a kalpasan iti pito nga aldaw, immay ti danum ti layus iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Iti maika-innem a gasut a tawen ni Noe, iti maikadua a bulan, iti maikasangapulo ket pito nga aldaw ti bulan, iti isu met laeng nga aldaw, pimsuak dagiti amin nga ubbog ti dakkel a taaw iti uneg ti daga, ken naglukat dagiti tawa ti langit. ");
INSERT INTO iloulb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nangrugi ti tudo ket nagtinnag iti rabaw ti daga iti uppat a pulo nga aldaw ken uppat a pulo a rabii. ");
INSERT INTO iloulb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Iti dayta met laeng nga aldaw, simrek iti daong ni Noe ken dagiti annakna, ni Sem, ni Ham kenni Jafet, ken ti asawa ni Noe, ken dagiti tallo nga assawa dagiti annakna. ");
INSERT INTO iloulb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Simrekda a kaduada dagiti atap nga ayup segun iti kitada, ken dagiti tunggal dingwen segun iti kitada, ken dagiti tunggal agkarkarayam a banag iti rabaw ti daga segun iti kitada, ken dagiti tunggal billit segun iti kitada, ken dagiti tunggal kita iti parsua nga addaan kadagiti payyak. ");
INSERT INTO iloulb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dua kadagiti amin a lasag nga addaan anges ti biag ket immay kenni Noe ken simrek iti uneg ti daong. ");
INSERT INTO iloulb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Dagiti ayup a simrek ket lalaki ken babai kadagiti amin a lasag; simrekda a kas iti imbilin ti Dios kenkuana. Ket inrikep ni Yahweh ti ruangan idi nakastrekdan. ");
INSERT INTO iloulb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kalpasanna, immay ti layus iti rabaw ti daga iti las-ud iti uppat a pulo nga aldaw, ket dimmakkel ti danum ket intapawna ti daong. Timpaw daytoy manipud iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Immay ti napegges ken napigsa a danum ket dimmakkel unay daytoy iti rabaw ti daga, ket timpaw ti daong iti danum. ");
INSERT INTO iloulb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nagpangpangato ti danum manipud iti rabaw ti daga. Naan-anay a linipus ti danum dagiti amin a nangangato a banbantay nga adda iti baba ti entero a langit. ");
INSERT INTO iloulb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ngimmato ti danum iti sangapulo ket lima a cubits manipud kadagiti tuktok dagiti bantay. ");
INSERT INTO iloulb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Natay amin nga agbibiag nga aggargaraw iti rabaw ti daga: dagiti billit, dagiti dingwen, dagiti atap nga ayup, dagiti amin nga aguummong a parsua iti rabaw ti daga, ken amin a sangkatao-an. ");
INSERT INTO iloulb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Amin dagiti agbibiag a naipuyot ti espiritu ti biag kadagiti agungda, amin dagiti adda iti daga, ket natay. ");
INSERT INTO iloulb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Napukaw ngarud amin dagiti agbibiag nga adda iti rabaw ti daga, ti sangkatao-an ken dagiti dadakkel nga ayup, dagiti agkarkarayam, ken dagiti billit iti tangatang. Nadadaelda amin manipud iti daga. Ni Noe laeng ken dagiti kakaduana iti daong ti nabati. ");
INSERT INTO iloulb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Inturayan ti danum ti daga iti las-ud iti sangagasut ket limapulo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Pinanunot ti Dios ni Noe, dagiti amin nga atap nga ayup, ken dagiti amin a dingwen a kaduana iti uneg ti daong. Pinagpuyupoy ti Dios ti angin iti entero a daga, ket nangrugi a bimmaba ti danum. ");
INSERT INTO iloulb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nairikep dagiti ubbog iti uneg ti daga ken dagiti tawa iti tangatang, ket nagsardeng a nagtudo. ");
INSERT INTO iloulb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nagtultuloy nga immababaw ti danum. Ket kalpasan iti 150 nga aldaw, ababaw metten ti danum. ");
INSERT INTO iloulb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Simmadsad ti daong kadagiti bantay ti Ararat iti maika-pito a bulan, iti maika-17 nga aldaw iti bulan. ");
INSERT INTO iloulb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nagtultuloy nga immababaw ti danum agingga iti maika-sangapulo a bulan. Iti umuna nga aldaw iti bulan, nagparang dagiti tuktok dagiti bantay. ");
INSERT INTO iloulb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Napasamak a kalpasan iti uppat a pulo nga aldaw, linukatan ni Noe ti tawa ti daong nga inaramidna. ");
INSERT INTO iloulb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Nangipatayab isuna iti uwak ket nagsublisubli daytoy aginggana a nagmaga ti danum manipud iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kalpasanna, nangipatayab isuna iti kalapati tapno makitana no immababawen ti danum, ");
INSERT INTO iloulb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ngem awan ti nasarakan ti kalapati a lugar a pagdissoan ti sakana, ket nagsubli daytoy kenkuana iti uneg ti daong, ta linipus pay laeng iti danum ti entero a daga. Inyunnatna ti imana ket innalana ken inyunegna daytoy iti daong. ");
INSERT INTO iloulb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Naguray manen isuna iti pito nga aldaw ket nangipatayab manen iti kalapati manipud iti daong. ");
INSERT INTO iloulb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nagsubli kenkuana ti kalapati iti karabianna. Ket adda nalangto a bulong ti olibo iti sippitna. Ngarud, naammoan ni Noe nga immababawen ti danum. ");
INSERT INTO iloulb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Naguray manen isuna iti pito nga aldaw, ket pinatayabna manen ti kalapati. Saanen daytoy a nagsubli kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Dimteng iti maika-601 a tawen, iti umuna a bulan, iti umuna nga aldaw ti bulan, nga agmagmagan ti daga. Inikkat ni Noe ti kalub ti daong, kimmita iti ruar, ket nakitana a namagaanen ti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Iti maikadua a bulan, iti maika-27 nga aldaw iti bulan, natiananen ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kinuna ti Dios kenni Noe, ");
INSERT INTO iloulb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Rumuarkayo iti daong, sika, ti asawam, dagiti annakmo, ken dagiti assawa dagiti annakmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Paruarem ti tunggal sibibiag a parsua iti amin a lasag a kaduam, karaman dagiti billit, dagiti dingwen, ken tunggal banag nga agkarkarayam iti rabaw ti daga, tapno umaduda iti entero a daga, agbungada, ken agpaaduda iti rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Rimuar ngarud ni Noe a kaduana dagiti annakna, ti asawana, ken dagiti assawa dagiti annakna. ");
INSERT INTO iloulb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tunggal agbibiag a parsua, tunggal parsua nga agkarkarayam, ken tunggal billit, amin nga aggargaraw iti daga segun kadagiti pamiliada ket pinanawanda ti daong. ");
INSERT INTO iloulb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nangaramid ni Noe iti altar para kenni Yahweh. Nangala isuna iti sumagmamano kadagiti nadalus nga ayup ken sumagmamano kadagiti nadalus a billit, ket nangidaton isuna kadagiti daton a maipuor iti altar. ");
INSERT INTO iloulb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nalang-ab ni Yahweh ti makaay-ayo nga ayamuom ket kinunana iti pusona, “Saankonton nga ilunod pay ti daga gapu iti sangkata-oan, uray pay no dagiti kababalin dagiti pusoda ket dakes sipud kinaubingda. Saanko met a dadaelen dagiti amin a banag a sibibiag, a kas iti inaramidko. ");
INSERT INTO iloulb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Bayat nga adda ti daga, addanto latta tiempo ti panagmula ken panagapit, lammiis ken pudot, panawen ti pudot ken lam-ek, aldaw ken rabii. ");
INSERT INTO iloulb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ket binendisionan ti Dios ni Noe ken dagiti annakna, a kinunana kadakuada, “Agbalinkayo a nabunga, agpaadukayo, ken punoenyo ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Panagbuteng kadakayo ken panagamak kadakayo ti maaddanto iti tunggal agbibiag nga ayup iti rabaw ti daga, iti tunggal tumatayab iti tangatang, iti tunggal parsua nga agkarkarayam iti daga, ken kadagiti amin a lames iti baybay. Naipaimada kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tunggal aggargaraw a banag nga agbibiag ket agserbi a taraonyo. Itedko kadakayo ita ti amin a banag, kas intedko met kadakayo dagiti nalangto a mulmula. ");
INSERT INTO iloulb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ngem nasken a saankayo a mangan kadagiti karne nga adda pay laeng iti daytoy ti biagna-nga isu ti darana. ");
INSERT INTO iloulb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ngem para iti darayo, ti biag nga adda iti darayo, pabayadak. Singirek daytoy manipud iti ima ti tunggal ayup. Manipud iti ima ti siasinoman a tao, dayta ket, manipud iti ima ti nangpatay iti kabsatna, singirek ti bayad ti biag dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Siasinoman a mangpadara iti maysa a tao, babaento met iti maysa a tao a mapadara isuna, ta iti langa ti Dios nga inaramidna ti tao. ");
INSERT INTO iloulb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Iti biangyo, agbalinkayo a nabunga ken agpaadukayo, agwaraskayo iti entero a daga ken agpaadukayo iti daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ket nagsao ti Dios kenni Noe ken kadagiti annakna, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Dumngegkayo! Iti biangko, makitulagak kadakayo ken kadagiti kaputotanyonto, ");
INSERT INTO iloulb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ken kadagiti amin nga agbibiag a parsua nga adda kadakayo, kadagiti tumatayab, kadagiti dingwen, ken iti tunggal parsua iti daga nga adda kadakayo, kadagiti amin a rimmuar manipud iti daong, iti tunggal agbibiag a parsua iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Makitulagak ngarud kadakayo, a saanto pulos a madadael amin a lasag babaen iti danum iti layus. Pulos nga awanton ti layus a mangdadael iti daga. ” ");
INSERT INTO iloulb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kinuna ti Dios, “Daytoy ti pagilasinan ti nakitulagak kadakayo ken iti tunggal agbibiag a parsua nga adda kadakayo, para iti amin a henerasion iti masakbayan. ");
INSERT INTO iloulb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Inkabilko ti bullalayawko iti ulep, ket agbalinto daytoy a pagilasinan iti nakitulagak iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mapasamakto nga inton iyumayko ti ulep iti daga ket makita ti bullalayaw iti ulep, ");
INSERT INTO iloulb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ket lagipekto ti katulagan, nga adda iti nagbaetantayo; siak, dakayo, ken iti tunggal agbibiag a nainlasagan a parsua. Saanto manen a pulos nga agbalin a layus dagiti danum a mangdadael iti amin a lasag. ");
INSERT INTO iloulb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Addanto ti bullalayaw kadagiti ul-ulep ket makitakto daytoy, tapno maipalagip ti agnanayon a katulagan ti Dios kadagiti amin nga agbibiag a parsua nga adda iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ket kinuna ti Dios kenni Noe, “Daytoy ti pagilasinan ti pannakitulagko kadagiti amin nga agbibiag iti rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Dagiti annak ni Noe a rimmuar iti daong ket da Sem, Ham, ken ni Jafet. Ket ni Ham ti ama ni Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dagitoy a tallo dagiti annak ni Noe, ken manipud kadagitoy, ti entero a daga ket napno iti tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nangrugi a nagbalin a mannalon ni Noe, ken nagmula isuna iti ubas. ");
INSERT INTO iloulb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Imminom isuna iti arak ket nabartek. Nakaidda isuna a lamo-lamo iti uneg ti toldana. ");
INSERT INTO iloulb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ket ni Ham, nga ama ni Canaan, nakitana ti kinalamo-lamo ni tatangna ket imbagana kadagiti dua a kakabsatna nga adda iti ruar. ");
INSERT INTO iloulb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nangala ngarud da Sem ken Jafet iti lupot ket inkabilda iti abagada, ken nagnada a patallikod ket inabbunganda ti kinalamo-lamo ni tatangda. Saanda a simmango, isu a saanda a nakita ti kinalamo-lamo ni tatangda. ");
INSERT INTO iloulb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Idi nariing ni Noe manipud iti pannakabartekna, natakuatanna ti inaramid kenkuana ti inaudi nga anakna. ");
INSERT INTO iloulb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Isu a kinunana, “Lunod koma ti umay kenni Canaan. Agbalin koma isuna nga adipen dagiti adipen dagiti kakabsatna.” ");
INSERT INTO iloulb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kinunana pay, “Madaydayaw koma ni Yahweh a Dios ni Sem, ket agbalin koma nga adipenna ni Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Palawaen koma ti Dios ni Jafet, ken itulokna nga agaramid isuna iti pagtaenganna kadagiti tolda ni Sem. Agbalin koma nga adipenna ni Canaan.” ");
INSERT INTO iloulb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kalpasan iti layus, nagbiag ni Noe iti tallo-gasut ken limapulo a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ti pakabuklan ti panagbiag ni Noe ket siyam a gasut ket limapulo a tawen, ket kalpasanna, natay isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dagitoy dagiti kaputotan dagiti putot ni Noe; ni Sem, ni Ham, ken ni Jafet. Naaddaanda kadagiti putot a lallaki kalpasan iti layus. ");
INSERT INTO iloulb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Dagiti putot a lallaki ni Jafet ket ni Gomer, ni Magog, ni Madai, ni Javan, ni Tubal, ni Mesec, ken ni Tiras. ");
INSERT INTO iloulb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Dagiti putot a lallaki ni Gomer ket ni Askenaz, ni Rifat, ken ni Togarma. ");
INSERT INTO iloulb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dagiti putot a lallaki ni Javan ket ni Eliseo, ni Tarsis, ni Kitim, ken ni Dodanim. ");
INSERT INTO iloulb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Manipud kadagitoy, nagsisina ken napan kadagiti dagdagada dagiti tattao nga adda iti igid ti baybay, tunggal maysa iti bukodna a pagsasao, segun kadagiti pulida, segun kadagiti nasionda. ");
INSERT INTO iloulb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dagiti putot a lallaki ni Ham ket ni Cus, ni Mizraim, ni Put, ken ni Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dagiti putot a lallaki ni Cus ket ni Seba, ni Havilah, ni Raamah, ken ni Sabteca. Dagiti putot a lallaki ni Raamah ket ni Sheva ken ni Dedan. ");
INSERT INTO iloulb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Naaddaan ni Cus iti putot a lalaki, isu ni Nimrod, a kaunaan a mammarmek iti rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Maysa isuna a maingel a mangnganop iti imatang ni Yahweh. Isu a naibaga a, “Kas kenni Nimrod, a maysa a maingel a mangnganop iti imatang ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Dagiti immuna a napapateg a siudad iti pagarianna ket Babel, Erec, Akkad, ken Calne, iti daga ti Sinar. ");
INSERT INTO iloulb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Manipud iti dayta a daga, napan isuna idiay Asiria ket binangonna ti Ninive, Rehobot-ir, Cala, ");
INSERT INTO iloulb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ken Resen, nga adda iti nagbaetan ti Ninive ken Cala. Dakkel daytoy a siudad. ");
INSERT INTO iloulb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ni Mizraim ti nagtaudan dagiti tattao iti Lydia, Anam, Lehab, Naftu, ");
INSERT INTO iloulb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrus, Caslu(a nagtaudan dagiti Filisteo), ken Caftur. ");
INSERT INTO iloulb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Naaddaan ni Canaan iti putot, isu ni Sidon, nga inauna a putotna, ken ni Het, ");
INSERT INTO iloulb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","kasta met dagiti Jebusio, dagiti Amoreo, dagiti Gergaseo, ");
INSERT INTO iloulb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","dagiti Heveo, dagiti Arkeo, dagiti Sineo, ");
INSERT INTO iloulb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","dagiti Arveo, dagiti Zemareo, ken dagiti Hamateo. Kalpasanna, nagwaras dagiti kaputotan ni Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ti beddeng dagiti Cananeo ket manipud idiay Sidon nga agpa-Gerar, ket agpatingga idiay Gaza, ken no agturong idiay Sodoma, Gomora, Adma, ken Zeboiim, agpatingga idiay Lasa. ");
INSERT INTO iloulb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dagitoy dagiti putot a lallaki ni Ham, segun kadagiti pulida, kadagiti pagsasaoda, kadagiti dagada, ken kadagiti nasionda. ");
INSERT INTO iloulb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Naaddaan met kadagiti putot a lallaki ni Sem a manong ni Jafet. Ni Sem met ti kapuonan dagiti amin a tattao ti Eber. ");
INSERT INTO iloulb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Dagiti putot a lallaki ni Sem ket ni Elam, ni Assur, ni Arpaksad, ni Lud, ken ni Aram. ");
INSERT INTO iloulb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Dagiti putot a lallaki ni Aram ket ni Us, ni Hul, ni Geter, ken ni Mesec. ");
INSERT INTO iloulb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Naaddaan ni Arpaksad iti putot a lalaki, isu ni Sela, ket ni Sela ti ama ni Eber. ");
INSERT INTO iloulb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Naadaan ni Eber iti dua a putot a lallaki. Ti nagan ti maysa ket Peleg, gapu ta kadagiti aldawna ket nabingay ti daga. Ti nagan ti kabsatna a lalaki ket Joktan. ");
INSERT INTO iloulb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ni Joktan ti ama da Almodad, Selef, Hasarmavet, Jera, ");
INSERT INTO iloulb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO iloulb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO iloulb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, ken Jobab. Amin dagitoy ket putot a lallaki ni Joktan. ");
INSERT INTO iloulb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ti masakupanda ket manipud idiay Mesa agingga idiay Sefar, ti bantay iti daya. ");
INSERT INTO iloulb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dagitoy dagiti putot a lallaki ni Sem, segun kadagiti kaputotanda ken kadagiti pagsasaoda, kadagiti dagada, ken kadagiti nasionda. ");
INSERT INTO iloulb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dagitoy dagiti tribu dagiti putot ni Noe, segun iti kaputotanda, segun iti nasionda. Manipud kadagitoy ket nasinasina ken nagwaras dagiti tattao iti entero a daga kalpasan iti layus. ");
INSERT INTO iloulb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ita, maymaysa a pagsasao ti nausar iti entero a daga ken addaanda iti agpapada a sasao. ");
INSERT INTO iloulb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Iti panagdaliasatda idiay daya, adda nasarakanda a patad iti daga ti Sinar ket nagnaedda sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Kinunada iti maysa ken maysa, “Umaykayo, agaramidtayo iti adu a ladrillo ket lutuentayo a naimbag.” Addaanda iti ladrillo imbes a bato ken alketran a pangsemento. ");
INSERT INTO iloulb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kinunada, “Umaykayo, mangbangontayo iti maysa a siudad ken maysa a torre a dumanon idiay langit ti tuktokna para kadatayo met laeng, ket agaramidtayo iti bukodtayo a nagan. Ta no saantayo nga aramiden daytoy, mawarawaratayonto iti entero a rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Isu a bimmaba ni Yahweh a mangkita iti siudad ken iti torre nga impatakder dagiti kaputotan ni Adan. ");
INSERT INTO iloulb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kinuna ni Yahweh, “Kitaenyo, sangsangkamaysa dagitoy a tattao nga addaan iti maymaysa a pagsasao, ket irugrugidan ti agaramid iti daytoy! Iti mabiit awanton ti banag a gandatenda nga aramiden a saandanto a kabaelan nga isayangkat. ");
INSERT INTO iloulb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Umaykayo, bumabatayo ket riribukentayo ti pagsasaoda tapno saanda nga agkikinnaawatan.” ");
INSERT INTO iloulb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Isu a winarawara ida ni Yahweh iti entero a rabaw ti daga ket insardengda ti panangbangonda iti siudad. ");
INSERT INTO iloulb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Napanaganan ngarud daytoy iti Babel gapu ta riniribok ni Yahweh ti pagsasao ti entero a daga ket manipud sadiay, iti panangwarawara kadakuada ni Yahweh, impanna ida iti ballasiw taaw iti entero a rabaw ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dagitoy dagiti kaputotan ni Sem. Sangagasut idi ti tawen ni Sem, ket naaddaan isuna iti putot ket isu ni Arpaksad, dua a tawen kalpasan iti layus. ");
INSERT INTO iloulb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nagbiag ni Sem iti limagasut a tawen kalpasan iti panangiputotna kenni Arpaksad. Naaddaan met isuna kadagiti dadduma pay a putot a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Idi nagbiag ni Arpaksad iti tallopulo ket lima a tawen, naaddaan isuna iti putot ket isu ni Sela. ");
INSERT INTO iloulb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nagbiag ni Arpaksad iti 403 a tawen kalpasan iti panangiputotna kenni Sela, ken naaddaan isuna iti adu pay a putot a lallaki ken babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Idi nagbiag ni Sela iti tallopulo a tawen, naaddaan isuna iti putot ket isu ni Eber. ");
INSERT INTO iloulb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nagbiag ni Sela iti 403 a tawen kalpasan iti panangiputotna kenni Eber, ket adu pay a lallaki ken babbai iti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Idi nagbiag ni Eber iti tallopulo ket uppat a tawen, naaddaan isuna iti putot ket isu ni Peleg. ");
INSERT INTO iloulb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nagbiag ni Eber iti 430 a tawen kalpasan iti panangiputotna kenni a Peleg. Ket adu pay a lallaki ken babbai iti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Idi nagbiag ni Peleg iti tallopulo a tawen, naaddaan isuna iti putot ket isu ni Reu. ");
INSERT INTO iloulb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nagbiag ni Peleg iti 209 a tawen kalpasan iti panangiputotna kenni Reu. Ket adu pay a lallaki ken babbai ti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Idi nagbiag ni Reu iti tallopulo ket dua a tawen, naaddaan isuna iti putot ket isu ni Serug. ");
INSERT INTO iloulb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nagbiag ni Reu iti 207 a tawen kalpasan a pinutotnani Serug. Ket adu pay a lallaki ken babbai iti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Idi nagbiag ni Serug iti tallopulo a tawen, naaddaan isuna iti putot ket isu ni Nahor. ");
INSERT INTO iloulb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nagbiag ni Serug iti dua gasut a tawen kalpasan a nagbalin nga ama ni Nahor. Ket adu pay a lallaki ken babbai iti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Idi nagbiag ni Nahor iti duapulo ket siam a tawen, naaddaan isuna iti putot ket isu ni Tera. ");
INSERT INTO iloulb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nagbiag ni Nahor iti 119 a tawen kalpasan a naiputotna ni Tera. Ket adu pay a lallaki ken babbai iti naiputotna. ");
INSERT INTO iloulb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kalpasan iti pitopulo a tawen a panagbiag ni Tera, naaddaan isuna kadagiti putot ket isu da Abram, Nahor, ken Haran. ");
INSERT INTO iloulb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ita, dagitoy dagiti kaputotan ni Tera. Isuna ti ama da Abram, Nahor, ken Haran, ket ni Haran ti ama ni Lot. ");
INSERT INTO iloulb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Natay ni Haran iti imatang ti amana a ni Tera iti nakaiyanakanna a daga, idiay Ur dagiti Caldeo. ");
INSERT INTO iloulb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nangasawa da Abram ken Nahor. Sarai ti nagan iti asawa ni Abram ken Milca ti nagan iti asawa ni Nahor a putot a babai ni Haran nga ama da Milca ken Isca. ");
INSERT INTO iloulb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ita, ni Sarai ket lupes; awanan isuna iti anak. ");
INSERT INTO iloulb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Inkuyog ni Tera ti putotna a lalaki a ni Abram, ti apokona a ni Lot a putot ni Haran, ken ti manugangna a ni Sarai nga asawa ni Abram a putotna a lalaki, ket nagkukuyogda a pimmanaw idiay Ur nga ayan dagiti Caldeo, tapno mapanda idiay daga ti Canaan. Ngem dimtengda idiay Haran ket nagtalinaedda sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Agtawen idi ni Tera iti 205 kalpasanna ket natay idiay Haran. ");
INSERT INTO iloulb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ita kinunana ni Yahweh kenni Abram, “Pumanawka manipud iti pagiliam, manipud kadagiti kakabagiam, manipud iti sangkabalayan ti amam, ket agturongka iti lugar nga ipakitakto kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Pagbalinenkanto a dakkel a nasion, ken bendisionankanto, ken pagbalinekto a naindaklan ti naganmo, ket agbalinkanto a pakabendisionan. ");
INSERT INTO iloulb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bendisionakto dagiti mangbendision kenka, ngem ilunodkonto dagiti saan nga agraem kenka. Babaen kenka, mabendisionanto amin a pamilia ti entero a daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Napan ngarud ni Abram kas iti imbaga ni Yahweh kenkuana nga aramidenna, ket simmurot ni Lot kenkuana. Pitopulo ket lima ti tawen ni Abram idi pimmanaw isuna idiay Haran. ");
INSERT INTO iloulb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Inkuyogna ti asawana a ni Sarai ken ti kaanakanna a lalaki a ni Lot a putot ti kabsatna, amin dagiti sanikuada a naipundarda ken amin a tattao a naalada idiay Haran. Pimmanawda a nagturong iti daga ti Canaan, ket dimtengda sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Dinaliasat ni Abram ti daga agingga iti Sikem, nga ayan ti lugo iti More. Iti dayta a tiempo agnanaed dagiti Cananeo iti dayta a daga. ");
INSERT INTO iloulb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nagparang ni Yahweh kenni Abram, ket kinunana, “Itedkonto kadagiti kaputotam daytoy a daga.” Isu a nangipatakder ni Abram iti altar a maipaay kenni Yahweh, a nagparang kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Manipud sadiay, immakar isuna ket nagturong idiay katurturodan a pagilian iti daya ti Betel, ket impatakderna sadiay ti toldana, iti nagbaetan ti Betel nga adda iti laud, ken Ai iti dayana. Nangbangon ni Abram sadiay iti altar a maipaay kenni Yahweh ken immawag isuna iti nagan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kalpasanna, intultuloy ni Abram ti nagdaldaliasat, ket nagturong idiay Negeb. ");
INSERT INTO iloulb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Adda panagbisin iti dayta a daga, isu a simmalog ni Abram ket nagturong iti Egipto tapno agnaed sadiay, gapu ta nakaro unay ti panagbisin iti daydiay a daga. ");
INSERT INTO iloulb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Idi dandanin a sumrek ti Egipto, kinunana kenni Sarai nga asawana, “Kitaem a, ammok a napintaska a babai. ");
INSERT INTO iloulb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Inton makitadaka dagiti Egipcio kunaendanto, 'Daytoy ti asawana,' ket papatayendakto, ngem pagtalinaedendaka a sibibiag. ");
INSERT INTO iloulb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ibagam lattan a kabsatka, tapno gapu kenka ket nasayaatakto, ket tapno gapu kenka ket maispal ti biagko.” ");
INSERT INTO iloulb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Napasamak nga idi nakastreken ni Abram idiay Egipto, nakita dagiti Egipcio a kasta unay ti kinapintas ni Sarai. ");
INSERT INTO iloulb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nakita isuna dagiti prinsipe ti Faraon, ket impasindayawda isuna iti Faraon, ket impanda ti babai iti pagtaengan ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nasayaat ti panangtrato ti Faraon kenni Abram gapu kenkuana, ket inikkanna isuna kadagiti karnero, baka, kalakian nga asno, tagabu a lallaki, tagabu a babbai, kabaian nga asno ken kadagiti kamelio. ");
INSERT INTO iloulb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kalpasanna, pinagrigat ni Yahweh ti Faraon ken ti balayna iti nakaro a didigra gapu kenni Sarai nga asawa ni Abram. ");
INSERT INTO iloulb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pinaayaban ti Faraon ni Abram, ket kinunana, “Ania daytoy nga inaramidmo kaniak? Apay a saanmo nga imbaga kaniak nga asawam isuna? ");
INSERT INTO iloulb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Apay nga imbagam, “Kabsatko isuna,' isu nga innalak nga agbalin nga asawak? Isu nga ita, adtoy ti asawam. Alaem isuna ket pumanaw kayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ket binilin ti Faraon dagiti tattaona maipapan kenkuana, ket pinapanawda isuna, agraman ti asawana ken amin nga adda kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Pimmanaw ngarud ni Abram iti Egipto ket napan idiay Negeb, isuna, ti asawana ken amin nga adda kenkuana. Kimmuyog met kadakuada ni Lot. ");
INSERT INTO iloulb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ita, nabaknang unay ni Abram kadagiti ayup, iti pirak, ken iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Intultuloyna ti panagdaliasatna manipud Negeb agingga idiay Betel, iti lugar nga ayan idi ti toldana, iti nagbaetan ti Betel ken Ai. ");
INSERT INTO iloulb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Daytoy a lugar idi ti nangbangonanna iti altar, ken ditoy isuna nga immawag iti nagan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ita, ni Lot, nga agdaldalliasat a kadua ni Abram ket addaan met kadagiti arban, bakbaka ken kadagiti tolda. ");
INSERT INTO iloulb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Saanen a makaanay ti daga a mangipaay iti pagbiaganda ta aginnasidegda a dua, gapu ta adu unay dagiti sanikuada, isu a saanda a mabalin nga agkuyog. ");
INSERT INTO iloulb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Maysa pay, adda rimsua a panagsisinnuppiat iti nagbaetan dagiti agpaspastor kadagiti ayup ni Abram ken agpaspastor kadagiti ayup ni Lot. Iti dayta a tiempo, agnanaed iti dayta a daga dagiti Cananeo ken dagiti Perezeo. ");
INSERT INTO iloulb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Isu a kinuna ni Abram kenni Lot, “Awan koma iti panagsinnuppiat iti nagbaetanta, ken iti nagbaetan dagiti parapastormo ken dagiti parapastorko, ta maymaysa ta laeng a pamilia. ");
INSERT INTO iloulb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Saan aya nga adda iti sangoanam ti isuamin a daga? Mapanka ket suminaka kaniak. No mapanka iti kannigid, mapanakto iti kannawan. Wenno no mapanka iti kannawan, mapanakto met iti kannigid.” ");
INSERT INTO iloulb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Isu a kimmita ni Lot iti aglawlaw, ken nakitana nga iti kabuklan ti kapatadan ti Jordan ket nasayaat ti pannakapadanumna iti sadinoman agingga idiay Zoar, kas iti minuyongan ni Yahweh, kas iti daga ti Egipto. Daytoy ket sakbay a dinadael ni Yahweh ti Sodoma ken Gomorra. ");
INSERT INTO iloulb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Isu a pinili ni Lot a para kenkuanna ti kapatadan ti Jordan ket nagdalliasat a napan iti daya, ket nagsina ngarud dagiti agkabagian. ");
INSERT INTO iloulb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nagnaed ni Abram iti daga ti Canaan, ket nagnaed ni Lot kadagiti siudad iti kapatadan. Impatakderna dagiti toldana idiay Sodoma. ");
INSERT INTO iloulb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ita, nakaro unay ti kinamanagbasol dagiti lallaki iti Sodoma maibusor kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Kinuna ni Yahweh kenni Abram kalpasan a simmina ni Lot kenkuana, “Manipud iti disso a pagtaktakderam, kumitaka iti amianan, iti abagatan, iti daya, ken iti laud. ");
INSERT INTO iloulb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Amin daytoy a makitkitam a daga, itedkonto kenka ken kadagiti kaputotam iti agnanayon. ");
INSERT INTO iloulb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ket paaduekto dagiti kaputotam a kas iti kaadu ti tapuk iti daga, ket no kabaelan a bilangen iti maysa tao ti tapuk iti daga, kastanto met iti pannakabilang dagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Agsaganaka, pagnaem ti kaatiddog ken kaakaba ti daga, ta itedkonto daytoy kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Isunga innala ni Abram ti toldana, ket napan nagnaed iti asideg dagiti kayo a lugo ti Mamre nga adda idiay Hebron, ket nangipatakder sadiay iti altar para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Napasamak daytoy kadagiti idi al-aldaw da Amrafel nga ari ti Sinar, ni Arioc nga ari ti Eliasar, ni Kedorlaomer nga ari ti Elam, ni Tidal nga ari ti Goiim, ");
INSERT INTO iloulb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","a nangparnuayda iti gubat a maibusor kada Bera nga ari ti Sodoma, ni Birsa nga ari ti Gomorra, ni Sinab nga ari ti Adma, ni Semeber nga ari ti Zeboiim ken iti ari ti Bela (maawagan met daytoy iti Zoar). ");
INSERT INTO iloulb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nagkakaddua dagitoy naud-udi a lima nga ar-ari idiay tanap ti Siddim (a maawagan met iti Naapgad a Baybay) ");
INSERT INTO iloulb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Nagserbida kenni Kedorlaomer iti sangapulo ket dua a tawen, ngem immalsada iti maikasangapulo ket tallo a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kalpasanna, iti maikasangapulo ket uppat a tawen, immay rinaut da Kedorlaomer ken dagiti ar-ari a kakadduana ti Refaim iti Asterot Karnaim, ti Zuzim iti Ham, ti Emim iti Save Kiriataim, ");
INSERT INTO iloulb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ken dagiti Horeo iti katurturod a pagilianda a Seir, agingga idiay El Paran nga asideg iti let-ang. ");
INSERT INTO iloulb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kalpasanna, nagsublida ket dimtengda idiay En Mispat (a maawagan met iti Kades), ket inabakda amin a pagilian dagiti Amalekita, ken kasta met dagiti Amorreo nga agnanaed iti Hazazon Tamar. ");
INSERT INTO iloulb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kalpasanna, napan nagsagana ti ari ti Sodoma, ti ari ti Gomorra, ti ari ti Adma, ti ari ti Zeboiim, ken ti ari ti Bela (a maawagan met iti Zoar) para iti gubat ");
INSERT INTO iloulb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","a maibusor kenni Kedorlaomer nga ari ti Elam, ni Tidal nga ari ti Goiim, ni Amrafel nga ari ti Sinar, ni Arioc nga ari ti Eliasar, uppat nga ar-ari a maibusor iti lima. ");
INSERT INTO iloulb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ita, ti tanap ti Siddim ket napunno kadagiti abut a naikkan iti alketran, ket idi timmaray dagiti ari ti Sodoma ken Gomorra, natinnagda sadiay. Ket dagiti nabati, nagkamangda kadagiti kabanbantayan. ");
INSERT INTO iloulb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Isu nga innala amin dagiti kabusor dagiti amin nga adda idiay Sodoma ken Gomorra kasta met dagiti amin a taraon, ket pimmanawda. ");
INSERT INTO iloulb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Iti ipapanda, innalada met ti putot a lalaki ti kabsat ni Abram a ni Lot, nga agnanaed idiay Sodoma agraman dagiti amin a sanikuana. ");
INSERT INTO iloulb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Maysa a nakalibas iti immay nangipadamag kenni Abram a Hebreo. Agnanaed isuna iti abay ti kayo a lugo a kukua ni Mamre, nga Amorreo, a kabsat a lalaki da Escol ken Aner, isuda amin ket addaan iti nasayaat a pannakikadua kenni Abram. ");
INSERT INTO iloulb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ita, idi nangngeg ni Abram a natiliw dagiti kabusorna ti kabagianna, indauloanna iti tallo-gasut ket sangapulo ket walo a nasursuruan a lallaki, a naiyanak iti balayna, ket sinunsonda ida agingga idiay Dan. ");
INSERT INTO iloulb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Biningayna dagiti tattaona a maibusor kadakuada iti rabii ket dinarupda ida, ken kinamatda ida inggana idiay Hobah, nga adda iti amianan ti Damasco. ");
INSERT INTO iloulb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kalpasanna, insublina amin dagiti sanikua, ken insublina met ti kabagianna a ni Lot ken dagiti taraonda, kasta met dagiti babbai ken dagiti dadduma a tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kalpasan a nagsubli ni Abram manipud iti panangparmekna kenni Kedorlaomer ken dagiti kakaduana nga ar-ari, rimmuar ti ari ti Sodoma tapno sabatenna isuna iti tanap ti Save (a maawagan met iti Tanap ti Ari). ");
INSERT INTO iloulb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ni Melkisedek nga ari iti Salem ket nangiruar iti tinapay ken arak. Isuna ket padi ti Kangatoan a Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Bendisionan koma ti Dios a Kangatoan a Nangparsua iti langit ken daga ni Abram. ");
INSERT INTO iloulb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Madaydayaw ti Dios a Kangatoan, nga isu iti nangipaima kadagiti kabusormo kenka”. Kalpasanna, inted ni Abram kenkuana ti apagkapullo dagiti amin a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kinuna ti ari ti Sodoma kenni Abram, “Itedmo kaniak dagiti tattao ket alaem dagiti banbanag para kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kinuna ni Abram iti ari ti Sodoma, “Intag-ayko ti imak kenni Yahweh a Kangatoan a Dios, a Nangparsua iti langit ken daga, ");
INSERT INTO iloulb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","a saanakto a mangala iti sinulid, galut iti sandalias, wenno aniaman a banag a kukuam, tapno saanmonto pulos nga ibaga, 'Pinabaknangko ni Abram.' ");
INSERT INTO iloulb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Awanto ti alaek malaksid iti kinnan dagiti agtutubo a lallaki ken ti bingay dagiti lallaki a kimmuyog kaniak. Palubosam da Aner, Escol, ken ni Mamre nga alaenda dagiti bingayda.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kalpasan dagitoy a banbanag, immay ti sao ni Yahweh kenni Abram iti maysa a sirmata, a kunana, “Saanka nga agbuteng, Abram! “Siak ti salaknibmo ken ti naidaklan unay a gunggonam.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kinuna ni Abram, “Apo a Yahweh, anianto ti ipaaymo kaniak, ta kastoy met latta, awananak iti anak, ken ti agtawid iti balayko ket ni Elieser a taga-Damasco?” ");
INSERT INTO iloulb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kinuna ni Abram, “Agsipud ta awan intedmo kaniak a kaputotan, kitaem, ti katalek iti balayko ket isu ti agtawid.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ket, pagammoan, immay kenkuana ti sao ni Yahweh, a kunana, “Saan a daytoy a lalaki ti agtawid iti sanikuam; ngem ketdi ti agtaudto a mismo iti bagim ti agtawidto.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kalpasanna, impanna isuna iti ruar ket kinunana, “Tumangadka iti langit, ket bilangem dagiti bituen, no kabaelam ida a bilangen.” Ket kinunana kenkuana, “Kastanto met ngarud dagiti kaputotam.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Namati isuna kenni Yahweh, ken imbilangna kenkuana daytoy a kinalinteg. ");
INSERT INTO iloulb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kinunana kenkuana, “Siak ni Yahweh a nangiruar kenka idiay Ur dagiti Caldeo, tapno itedko kenka daytoy a daga a tawidem.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kinunana “Apo a Yahweh, kasanonto a maammoak a tawidekto daytoy?” ");
INSERT INTO iloulb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ket kinunana kenkuana, “Mangidatagka kaniak iti tallo ti tawenna a baka a saan pay a nagmaya, tallo ti tawenna a kabaian a kalding, tallo ti tawenna a kalakian a karnero, kalapati ken sibong a pagaw.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Impanna amin kenkuana dagitoy, ket ginuduana dagitoy. Ket inkabilna ti tunggal kagudua iti batug ti kapisina, ngem saanna a ginudua dagiti billit. ");
INSERT INTO iloulb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Idi bimmaba dagiti billit a mangan kadagiti natay nga ayup, inabog ni Abram dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ket idi lumlumneken ti init, nakaturog iti nasimbeng ni Abram ket pagammoan, nasallukoban isuna iti nakaam-amak ken nakabutbuteng a sipnget. ");
INSERT INTO iloulb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kalpasanna, kinuna ni Yahweh kenni Abram, “Ammoem koma a gangannaetto dagiti kaputotam iti saanda a daga, ket matagabudanto ken maparigatdanto iti las-ud iti uppat a gasut a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ukomekto dayta a nasion a pagserbianda, ket rummuardanto kalpasan nga addaan iti nawadwad a sanikua. ");
INSERT INTO iloulb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ngem mapankanto kadagiti amam a sitatalna, ket lakaykanto unayen inton maitanemka. ");
INSERT INTO iloulb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Iti maikapat a henerasion ket umaydanto manen ditoy. Ta saan pay a nadanon ti pagpatinggaan ti kinadagsen iti basol dagiti Amorreo.” ");
INSERT INTO iloulb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Idi limneken ti init ket nasipngeten, adda maysa nga agas-asuk a banga ken sumsumged nga aluten a limmasat iti nagbabaetan dagiti pidaso ti ayup. ");
INSERT INTO iloulb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Iti dayta nga aldaw, nakitulag ni Yahweh kenni Abram, kunana, “Kadagiti kaputotamto, itedko daytoy a daga, manipud iti karayan ti Egipto inggana iti dakkel a karayan, ti Eufrates— ");
INSERT INTO iloulb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","dagiti Kineo, dagiti Kenizeo, dagiti Kadmoneo, ");
INSERT INTO iloulb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","dagiti Heteo, dagiti Perezeo, dagiti Refaim, ");
INSERT INTO iloulb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","dagiti Amorreo, dagiti Cananeo, dagiti Girgaseo ken dagiti Jebuseo.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ita, ni Sarai nga asawa ni Abram, ket saan pay a naaddaan iti annak para kenkuana, ngem adda adipenna a babai, a taga-Egipto, nga agnagan iti Agar. ");
INSERT INTO iloulb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Isu a kinuna ni Sarai kenni Abram, “Kitaem, saan nga impalubos ni Yahweh a maaddaanak kadagiti annak. Mapanmo kaiddaen ti adipenko. Mabalinak siguro a maaddaan iti annak babaen kenkuana.” Dinengngeg ni Abram ti timek ni Sarai. ");
INSERT INTO iloulb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Daytoy ket kalpasan iti sangapulo a tawen a panagnaed ni Abram idiay daga iti Canaan, idi nga inted ni Sarai nga asawa ni Abram ni Agar, nga adipenna a taga Egipto, kenni Abram tapno agbalin nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Isu a naaddaanda iti relasion kenni Agar, ket nagsikog isuna. Ket idi nakitana a masikogen isuna, bimmaba ti panangkitana iti amona a babai. ");
INSERT INTO iloulb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kalpasanna, kinuna ni Sarai kenni Abram, “Daytoy a sagsagrapek ket gapu kenka. Intedko ti adipenko a babai iti arakupmo, ket idi nakitana nga isuna ket masikogen, inumsinak kadagiti matana. Ni Yahweh koma iti mangukom kadata.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ngem kinuna ni Abram kenni Sarai, “Kitaem a, ti adipenmo a babai ket adda iti turaymo, aramidem kenkuana no ania ti ammom a kasayaatan.” Isu a nagbalin a naranggas ni Sarai kenkuana, ket nagtalaw ni Agar manipud kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nasarakan isuna ti anghel ni Yahweh iti ayan ti bubon iti danum idiay let-ang, ti bubon iti dalan nga agturong idiay Sur. ");
INSERT INTO iloulb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kinunana, “Agar nga adipen ni Sarai, sadino ti naggappuam ken sadino ti papanam?” Ket kinunana, “Itartarayak ti amok a ni Sarai.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kinuna ti anghel ni Yahweh kenkuana, “Agsublika iti amom a babai, paiturayanka kenkuana iti panagturayna.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kalpasanna, kinuna ti anghel ni Yahweh kenkuana, “Paaduekto iti kasta-unay dagiti kaputotam, ket adudanto unay a bilangen.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kinuna pay ti anghel ni Yahweh kenkuana, “Kitaem, masikogka, aganakkanto iti lalaki ket panaganamto iti Ismael, gapu ta dinengngeg ni Yahweh ti panagasugmo. ");
INSERT INTO iloulb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Agbalinto isuna nga atap nga asno iti tao. Kabusornanto iti tunggal tao, ket kabusorto met isuna iti tunggal tao. Ket agbiagto isuna nga adayo kadagiti amin a kakabsatna.” ");
INSERT INTO iloulb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kalpasanna, intedna daytoy a nagan kenni Yahweh a nagsao kenkuana, “Sika ti Dios a nakakita kaniak” ta kinunana, “Makakitaak latta kadi, uray kalpasan a nakitanak?” ");
INSERT INTO iloulb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Isu't gapuna a naawagan dayta a bubon iti Beer-lahai-roi; daytoy ket adda iti nagbaetan ti Kades ken Bered. ");
INSERT INTO iloulb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Impasngay ni Agar ti putot a lalaki ni Abram ket pinanaganan ni Abram ti putotna nga inyanak ni Agar iti Ismael. ");
INSERT INTO iloulb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Walu-pulo ket innem ti tawen ni Abram idi inyanak ni Agar ni Ismael kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Idi agtawen ni Abram iti siam a pulo ket siam, nagparang ni Yahweh kenkuana ket kinunana, “Siak ti Mannakabalin a Dios. Magnaka iti imatangko ket awanto iti pakapilawam. ");
INSERT INTO iloulb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ket pasingkedakto ti tulagko iti nagbaetanta, ket paaduenkanto iti aglaplapusanan.” ");
INSERT INTO iloulb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nagkurno ni Abram ken nakisao ti Dios kenkuana a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“No maipapan kaniak, kitaem, nakitulagak kenka. Sikanto ti ama iti adu a nasion. ");
INSERT INTO iloulb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Saanton nga Abram ti naganmo, ngem ti naganmonto ket Abraham- ta dutokanka nga agbalin nga ama dagiti adu a nasion. ");
INSERT INTO iloulb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Pagbalinenkanto a nabunga iti aglaplapusanan, mangaramidakto kadagiti nasion babaen kenka, ket adunto nga ari ti agtaud kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Makitulagak kenka ken kadagiti amin a kaputotam a sumarsaruno kenka, kadagiti amin a henerasionda, iti maysa nga agnanayon a katulagan, nga agbalinak a Dios kenka ken kadagiti sumaruno a kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Itedkonto kenka, ken kadagiti sumaruno a kaputotam, ti daga a pagnanaedam, amin a daga ti Canaan, kas agnanayon a sanikua, ken siakto ti Diosda.” ");
INSERT INTO iloulb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ket kinuna ti Dios kenni Abraham, “No maipapan kenka, masapul a tungpalem ti tulagko, sika ken dagiti sumaruno a kaputotam iti amin a henerasionda. ");
INSERT INTO iloulb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Daytoy ti katulagan iti nagbaetanta ken kadagiti sumaruno a kaputotam: Masapul a makugit ti tunggal lallaki kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Masapul a makugitkayo iti akinruar a kudil ti lasagyo, ket daytoyto ti pagilasinan ti tulag iti nagbaetanta. ");
INSERT INTO iloulb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Tunggal lallaki kadakayo a walo nga aldawnan ket masapul a makugit, kadagiti amin a henerasion dagiti tattaom. Daytoy ket pakairamanan dagiti naipasngay iti pagtaengam ken ti nagatang babaen iti kuarta a nagtaud iti siasinoman a ganggannaet a saan a maysa kadagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Masapul a makugit ti lalaki a naipasngay iti pagtaengam ken ti lalaki a nagatang iti kuartam. Iti kasta ket addanto iti lasagyo ti tulagko kas agnanayon a katulagan. ");
INSERT INTO iloulb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Siasinoman a lalaki a saan a nakugit, a saan a nakugit iti akinruar a kudil ti lasagna ket maisinanto manipud kadagiti tattaona. Sinalungasingna ti tulagko. ");
INSERT INTO iloulb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kinuna ti Dios kenni Abraham, “Maipapan met kenni Sarai nga asawam, saanmonton nga awagan isuna iti Sarai. Ngem ketdi, ti naganannanto ket Sarah, ");
INSERT INTO iloulb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bendisionakto isuna, ken ikkankanto iti anak a lalaki babaen kenkuana. Bendisionakto isuna, ket agbalinto isuna nga ina dagiti nasion. Adu nga ari dagiti tattao ti agtaudto kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kalpasanna ket nagrukob ni Abraham, ken nagkatawa, ket kunana iti nakemna, “Mabalin pay kadi met a pumutot ti maysa a lalaki nga agtawenen iti sangagasut? Ken kabaelan pay kadi met ni Sara, nga agtawenen iti siam a pulo, ti mangipasngay iti anak a lalaki?” ");
INSERT INTO iloulb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kinuna ni Abraham iti Dios, “Ni Ismael latta koman ti agbiag iti imatangmo!” ");
INSERT INTO iloulb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kinuna ti Dios, “Saan, ngem mangipasngayto ni Sarah nga asawam iti anak a lalaki para kenka, ket masapul a panaganam isuna iti Isaac. Tungpalekto ti tulagko kenkuana a kas maysa nga agnanayon a tulag a pakairamanan dagiti sumaruno a kaputotanna. ");
INSERT INTO iloulb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","No maipapan kenni Ismael, nangngegka. Kitaem, bendisionak isuna, ken pagbalinek isuna a nabunga, ken paaduekto isuna iti aglaplapusanan. Isunanto ti ama dagiti sangapulo ket dua a mangidaulo kadagiti tribu, ken pagbalinekto isuna a naindaklan a nasion. ");
INSERT INTO iloulb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ngem ipatungpalkonto ti tulagko kenni Isaac, nga ipasngayto ni Sarah kenka iti kastoy a tiempo iti sumaruno a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Idi nalpasna a kinatungtong ni Abraham, nagpangato ti Dios ket pinanawanna ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ket innala ni Abraham ni Ismael a putotna, ken dagiti amin a naiyanak iti sangkabalayanna, ken dagiti amin a nagatang babaen iti kuartana, tunggal lalaki kadagiti tattao iti sangkabalayan ni Abraham ket kinugitna ti akinruar a kudil ti lasagda iti dayta met laeng nga aldaw, a kas kinuna ti Dios kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Agtawen ni Abraham iti siam a pulo ket siam idi nakugit ti akinruar a kudil ti lasagna. ");
INSERT INTO iloulb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ken sangapulo ket tallo ti tawen ni Ismael idi nakugit ti akinruar a kudil ti lasagna. ");
INSERT INTO iloulb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Agpada a nakugit da Abraham ken Ismael iti dayta met laeng nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Amin a lallaki iti sangkabalayanna ket kaduana a nakugit, a pakairamanan dagidiay naiyanak iti uneg ti sangkabalayanna ken dagidiay nagatang babaen iti kuarta manipud iti ganggannaet. ");
INSERT INTO iloulb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nagparang ni Yahweh kenni Abraham iti ayan dagiti kayo a lugo idiay Mamre, bayat a nakatugaw isuna iti ruangan ti tolda iti kapudotan ti aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Timmangad isuna ket, pagammoan, nakitana nga adda tallo a lallaki nga agtaktakder iti batogna. Idi nakitana isuda, nagtaray isuna a nangsabat kadakuada manipud iti ruangan ti tolda ket nagdumog a nagparintumeng iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Kinunana, “Apo, no makaay-ayoak iti imatangmo, saanyo koma a labsan toy adipenmo. ");
INSERT INTO iloulb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Adda koma bassit a danum a maiyeg a pangbuggoyo kadagiti sakayo, ket aginanakayo iti sirok ti kayo. ");
INSERT INTO iloulb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ipalubosyo koma a mangiyegak iti bassit a taraon, tapno mabang-arankayo. Kalpasanna, mabalinyon iti mapan, agsipud ta immaykayo iti adipenyo.” Ket kinunada, “Aramidem kas iti imbagam.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kalpasanna, nagdardaras ni Abraham a napan iti tolda nga ayan ni Sarah, ket kinunana, “Darasem, mangalaka iti tallo a takal ti napino nga arina, masaem daytoy, ket agaramidka iti tinapay.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kalpasanna, nagtaray ni Abraham a napan iti ayan dagiti arban, ket nangala isuna iti ubing pay ken napintas a baka, ket intedna daytoy iti adipen, ket nagdardaras ti adipen a nangisagana iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nangala iti keso ken gatas, ken ti baka a naisaganan, ket inkabilna ti taraon iti sangoananda, ket nagtakder iti abayda bayat a mangmanganda iti sirok ti kayo. ");
INSERT INTO iloulb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kinunada kenkuana, “Sadino ti ayan ni Sarah nga asawam?” Insungbatna, “Idiay, uneg ti tolda.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kinunana, “Agsubliakto kenka iti kastoy met laeng a tiempo inton sumaruno a tawen, ket makitamto, maaddanto iti anak a lalaki ni Sarah nga asawam.” Agdengdengngeg ni Sarah nga adda iti ruangan ti tolda, iti likudanna. ");
INSERT INTO iloulb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ita, lakay ken baketen da Abraham ken Sarah, nataenganda unayen, ken limmabesen ni Sarah iti tiempo a kabaelan pay dagiti babbai iti agipasngay iti ubing. ");
INSERT INTO iloulb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Isu a kinatawaan ni Sarah ti bukodna a bagi, a kinunana iti bagina, “Kalpasan a bimmaketakon, maaddaanak pay ngata iti kastoy a pakaragsakan, kasta met a ti apok ket lakay metten?” ");
INSERT INTO iloulb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kinuna ni Yaweh kenni Abraham, “Apay a nagkatawa ni Sarah ken kunana, 'Pudno ngata nga aganakak, idinto a baketakon?' ");
INSERT INTO iloulb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Adda kadi aniaman a banag a narigat unay para kenni Yahweh? Iti tiempo nga intudingko, iti kastoy met laeng a tiempo inton sumaruno a tawen, agsubliakto kenka ket maaddaanto ni Sarah iti anak a lalaki.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ket inlibak ni Sarah daytoy a kinunana, “Saanak a nagkatawa,” ta nagbuteng isuna. Insungbatna, “Saan, nagkatawaka.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ket timmakderen dagiti lalaki tapno pumanaw ken kimmitada iti baba nga agturong iti Sodoma. Kimmuyog kadakuada ni Abraham tapno itulodna ida iti dalanda. ");
INSERT INTO iloulb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ngem kinuna ni Yahweh, “Rumbeng kadi nga ilimedko kenni Abraham ti maipanggep iti ngannganin nga aramidek, ");
INSERT INTO iloulb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","idinto a pudno nga agbalinto ni Abraham a naindaklan ken nabileg a nasion, ken mabendisionanto amin dagiti nasion iti daga kenkuana? ");
INSERT INTO iloulb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ta pinilik isuna tapno mabilinna dagiti annakna ken dagiti sumarsaruno a sangkabalayanna nga agtulnog iti wagas ni Yahweh, nga agaramid ti kinalinteg ken hustisia, tapno mabalin a tungpalen ni Yahweh kenni Abraham ti imbagana kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kalpasanna, kinuna ni Yahweh, “Gapu ta adu unay dagiti pammabasol a maibusor iti Sodoma ken Gomora, ken gapu ta nalabes unay dagiti basolda, ");
INSERT INTO iloulb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","bumabaak ita sadiay tapno kitaek no dakesda a kas kadagiti dimmanon a pammabasol kaniak. No saan, maammoakto.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pimmanaw ngarud dagiti lallaki manipud sadiay, ket nagturongda idiay Sodoma. Ngem nagtalinaed a nakatakder ni Abraham iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ket immasideg ni Abraham ket kinunana, “Iramanmo kadi a pukawen dagiti nalinteg kadagiti nadangkes? ");
INSERT INTO iloulb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nalabit nga adda limapulo a nalinteg iti uneg ti siudad. Pukawemto kadi daytoy ket saanmo a kaasian ti lugar gapu kadagiti limapulo a nalinteg nga adda sadiay? ");
INSERT INTO iloulb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sapay koma ta saanmo nga aramiden ti kasta a banag, nga iraman mo a papatayen dagiti nalinteg kadagiti nadangkes, ket matrato dagiti nalinteg a kas kadagiti nadangkes. Adayo koma nga aramidem iti kasta! Saan kadi a ti Ukom iti entero a daga ket agaramid iti nainkalintegan?” ");
INSERT INTO iloulb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kinuna ni Yahweh, “No makasarakak iti limapulo a nalinteg iti uneg ti siudad ti Sodoma, kaasiakto ti entero a lugar gapu kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Simmungbat ni Abraham a kinunana, “Kitaem ti inaramidko, a naturedak a nagsao iti Apok, uray no maysaak laeng a tapok ken dapo! ");
INSERT INTO iloulb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","No ngay adda iti nakurang iti lima a limapulo a nalinteg? Dadaelem kadi ti sibubukel a siudad no kurang iti lima?” Ket kinunana, “Saankonto a dadaelen daytoy, no adda masarakak idiay nga uppat a pulo ket lima.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ngem nakisarita pay isuna kenkuana, a kinunana, “No ngay adda masarakan nga uppat a pulo sadiay?” Insungbatna, “Saanko nga aramiden daytoy maigapu iti uppat a pulo.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kinunana, “Pangngaasim Apo ta saanka nga agunget, ta agsaoak. Nalabit nga addanto masarakan a tallopulo sadiay.” Insungbatna, “Saanko nga aramiden daytoy, no adda masarakak a tallopulo sadiay.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kinunana, “Dispensarem koma ti turedko nga agsao iti Apok! Nalabit nga addanto masarakan a duapulo sadiay.” Insungbatna, “Saanko a dadaelen daytoy maigapu iti duapulo.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kamauddiananna kinunana, “Pangngaasim Apo ta saanka nga agunget, ta agsaoak iti daytoy maudi a gundaway. Nalabit nga addanto iti sangapulo masarakan sadiay.” Ket kinunana, “Saankonto a dadaelen daytoy maigapu iti sangapulo.” ");
INSERT INTO iloulb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Napan ni Yahweh iti dalanna apaman a nalpas a nakitungtong kenni Abraham, ket nagawid met ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Rumabiin idi immay dagiti dua nga anghel idiay Sodoma, kabayatan nga agtugtugaw ni Lot iti ruangan ti Sodoma. Nakita ida ni Lot, ket nagtakder a nangsabat kadakuada ket nagkurno. ");
INSERT INTO iloulb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kinunana, “Pangngaasiyo appok, allukoyenkayo nga umay iti balay ti adipenyo, umyankayo iti agpatnag ken buggoanyo dagiti sakayo. Ket mabalin a masapakayo a bumangon ket agtuloykayo iti papananyo.” Ngem kinunada, “Saan, agpatpatnagkami idiay plasa ti ili.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ngem kasta unay ti panangallukoy ni Lot kadakuada, isu a kimmuyogda kenkuana ket simrekda iti balayna. Nangisagana isuna iti makan ken nangiluto iti tinapay nga awan lebadurana ket nanganda. ");
INSERT INTO iloulb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ngem sakbay a nagiddada, immay dagiti lallaki iti siudad, dagiti lallaki iti Sodoma, agraman dagiti agtutubo ken lakay, amin dagiti lallaki manipud iti tunggal paset iti siudad ket pinalawlawanda ti balay. ");
INSERT INTO iloulb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Pinukkawanda ni Lot a kinunada kenkuana, “Sadino ti ayan dagiti lallaki nga immay kenka ita a rabii! Irruarmo ida kadakami tapno kaiddaenmi ida!” ");
INSERT INTO iloulb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Isu a rimmuar ni Lot ket inserrana met laeng ti ridaw iti likudanna. ");
INSERT INTO iloulb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kinunana, “Ipakpakaasik kadakayo kakabsatko, saankayo koma nga agaramid iti dinadakes. ");
INSERT INTO iloulb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kitaenyo, adda dua nga anakko a babbai ket saanda pay a nakikaidda iti asinoman a lalaki. Ipakpakaasik kadakayo, bay-andak a mangirruar kadakuada ket aramidenyo kadakuada ti aniaman a nasayaat iti imatangyo. Saanyo laeng a sagiden dagitoy a lallaki, gapu ta simmangbayda iti salinong ti balayko.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kinunada “Aglisika!” Kinunada pay, “Immay ditoy daytoy a tao nga agnaed kas ganggannaet ket ita, nagbalinen isuna nga ukomtayo! Ita, dakdakes pay ti aramidenmi kenka ngem kadakuada.” Induronda ti lalaki a ni Lot, ket immasidegda a mangdadael iti ridaw. ");
INSERT INTO iloulb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ngem inggaw-at dagiti lallaki dagiti imada ket insublida ni Lot iti uneg ti balay ket inserrada ti ridaw. ");
INSERT INTO iloulb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ket dagiti lallaki nga adda iti ruar ti balay, binulsek ida dagiti lallaki a sangaili ni Lot, dagiti agtutubo ken lallakay, isu a narigatanda a nangbirok iti ridaw ti balay. ");
INSERT INTO iloulb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kalpasanna, kinuna dagiti lallaki kenni Lot, “Adda kadi pay sabali a kaduam ditoy? No adda manugangmo a lallaki, annakmo a lallaki ken babbai, ken siasinoman nga adda kenka iti siudad, irruarmo ida ditoy. ");
INSERT INTO iloulb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ta dadaelenmin daytoy a lugar gapu ta napigsa unayen dagiti pammabasol a maibusor iti daytoy a nakadanun iti sanggoanan ni Yahweh isu nga imbaonnakami a mangdadael iti daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Rimmuar ni Lot ket nakisarita kadagiti manugangna a lallaki, a nagkari a mangasawa kadagiti annakna a babbai, a kinunana, “Darasenyo, pumanawkayo iti daytoy a lugar, ta dadaelenen ni Yahweh ti siudad.” Ngem kadagiti manugangenna a lalaki ket kasla agang-angaw laeng isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Idi aglawagen, pinilit dagiti anghel ni Lot, a kunada, “Agawaam, ayabam ti asawam ken dagiti dua nga annakmo a babbai nga adda ditoy, tapno saankayo a mairaman a mapukaw iti pannakadusa ti siudad.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ngem nagsarimadeng isuna. Isu a ginammatan dagiti lallaki ti imana ken ti ima ti asawana ken dagiti ima dagiti dua nga annakna a babbai, gapu ta naasi unay ni Yahweh kenkuana. Inruarda ida, ket impanda ida iti ruar ti siudad. ");
INSERT INTO iloulb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ket idi nairruardan ida, kinuna ti maysa kadagiti lalaki, “Tumaraykayon, isalakanyo dagiti biagyo! Saankayo a tumalliaw, wenno agkamang iti sadinoman a tanap. Agkamangkayo kadagiti kabanbantayan tapno saankayo a mairaman.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kinuna ni Lot kadakuada, “Saan, pangngaasiyo appok! ");
INSERT INTO iloulb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ti adipenyo ket nakasarak iti pabor iti imatangyo, ket impakitayo kaniak ti naindaklan a kinaimbag gapu iti panangisalakanyo iti biagko, ngem saanak a makalibas a mapan kadagiti kabanbantayan, gapu ta makamakamnak ti didigra ket matayak. ");
INSERT INTO iloulb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kitaenyo, dayta a siudad nga adda sadiay ket asideg a mabalinko a pagkamangan ken bassit daytoy. Pangngaasiyo, bay-andak nga agkamang sadiay (saan kadi a bassit daytoy?) ket maisalakanto ti biagko.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kinunana kenkuana, “Ala wen, patgak met laeng daytoy a kiddaw, a saankonto a dadaelen ti siudad a dinakamatmo. ");
INSERT INTO iloulb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Darasem! Agkamangka sadiay, ta saanko a maaramid ti aniaman a banag agingga a saanka a nakadanon sadiay.” Naawagan ngarud ti siudad iti Soar. ");
INSERT INTO iloulb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nagsingisingen ti init iti daga idi nakadanon ni Lot iti Soar. ");
INSERT INTO iloulb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ket pinagtudo ni Yahweh iti asupre ken apuy manipud idiay tangatang idiay Sodoma ken Gomorra. ");
INSERT INTO iloulb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Dinadadaelna dagidiay a siudad, amin dagiti tanap, ken amin dagiti agnanaed kadagiti siudad, ken amin a nagtubo a mula iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ngem ti asawa ni Lot nga adda iti malikudanna, timmaliaw ket nagbalin isuna nga adigi nga asin. ");
INSERT INTO iloulb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nasapa a nagriing ni Abraham iti dayta a bigat ket napan iti lugar a nagtakderanna idi iti sanggoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tinannawaganna ti Sodoma ken Gomorra ken ti amin a daga iti tanap. Kimmita isuna ket nakitana ti asuk nga agpangpangato manipud iti daga a kas iti asuk iti maysa nga urno. ");
INSERT INTO iloulb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Isu nga idi dinadael ti Dios dagiti siudad iti tanap, linagip ti Dios ni Abraham. Inlisina ni Lot iti tengnga ti pannakadadael idi dinadaelna ti siudad a nagnaedan ni Lot. ");
INSERT INTO iloulb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ngem simmang-at ni Lot manipud iti Soar ket napan nagnaed kadagiti kabanbantayan a kaduana dagiti dua nga annakna a babbai, gapu ta mabuteng isuna nga agnaed iti Soar. Isu a nagnaed isuna iti maysa a rukib, isuna ken dagiti dua nga annakna a babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kinuna ti inauna nga anak iti inaudi, “Lakayen ti amata, ket awan ti siasinoman a lalaki iti sadinoman a makikaidda kadata segun iti wagas iti amin a lubong. ");
INSERT INTO iloulb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Umayka, painumenta iti arak ti amata, ket makikaiddata kenkuana, tapno iti kasta ket mapaaduta pay ti kaputotan ti amata.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Isu a pinainumda iti arak ti amada iti dayta a rabii. Ket napan nakikaidda ti inauna nga anak iti amana; saanna nga ammo idi nakikaidda isuna, uray idi bimmangon isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Iti simmaruno nga aldaw, kinuna ti inauna iti inaudi, “Dumngegka, idi rabii nakikaiddaak kenni amak, ket inton rabii painumenta manen iti arak, ket masapul a sumrekka ket makikaiddaka kenkuana, tapno iti kasta ket mapaaduta pay ti kaputotan ti amata.” ");
INSERT INTO iloulb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Isu a pinainumda iti arak ti amada iti dayta a rabii, ket napan ken nakikaidda ti inaudi kenkuana. Saanna nga ammo idi nagidda isuna, uray idi bimmangon isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Isu a dagiti annak ni Lot ket nagsikog babaen iti amada. ");
INSERT INTO iloulb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Impasngay ti inauna ti maysa a lalaki ket pinanagananna isuna iti Moab. Isuna ti nagbalin a kapuonan dagiti maaw-awagan iti agdama a Moabita. ");
INSERT INTO iloulb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kasta met ti inaudi nga anak, impasngayna met ti maysa lalaki, ket pinanaganna iti Ben Ammi. Isuna ti nagbalin a kapuonan dagiti tattao nga iti agdama ket maaw-awagan iti Ammonita. ");
INSERT INTO iloulb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nagdaliasat ni Abraham manipud sadiay a nagturong iti daga ti Negeb iti nagbaetan ti Kades ken Sur. Isuna ket gangganaet nga agnanaed iti Gerar. ");
INSERT INTO iloulb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Kastoy ti imbaga ni Abraham maipapan kenni Sarah nga asawana, “Isuna ket kabsatko a babai.” Isu a nangibaon ni Abimelec nga ari ti Gerar kadagiti soldadona ket innalada ni Sarah. ");
INSERT INTO iloulb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ngem immay ti Dios kenni Abimelec iti rabii babaen iti tagtagainep ket kinunana kenkuana, “Kitaem, kaiyarigam ti natay a tao gapu iti babai nga innalam ta asawa isuna ti maysa a lalaki.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ita, saan pay nga immasideg ni Abimelec kenkuana ket kinunana, “Apo, papatayem kadi uray ti nalinteg a nasion? ");
INSERT INTO iloulb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Saan kadi nga isuna a mismo ti nangibaga kaniak, 'Isuna ket kabsatko a babai'? Uray isuna a mismo ket kinunana nga 'Isuna ket kabsatko a lalaki.' Naaramidko daytoy a nadalus ti pusok ken awan basol kadagiti imak.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kalpasanna, kinuna ti Dios kenkuana iti tagtagainepna. “Wen ammok met nga inaramidmo daytoy a nadalus ti pusom ket inlisika met iti panagbasolmo kaniak. Isu a saanko nga impalubos a sagidem isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ngarud, isublim ti asawa ti lalaki, ta maysa isuna a profeta. Ikararagannakanto ket agbiagkanto. Ngem no saanmo nga isubli ti babai, ammoem a sika ken amin a kukuam ket awan duadua a matayto.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nasapa a bimmangon ni Abimelec iti agsapa ket inayabanna amin dagiti adipenna. Imbagana amin dagitoy a banag kadakuada ket nakaro ti buteng dagiti lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kalpasanna ket pinaayaban ni Abimelec ni Abraham ket kinunana kenkuana, “Ania daytoy nga inaramidmo kadakami? Kasano a nakabasolak kenka, ta inyegmo kaniak ken iti pagariak ti dakkel a basol? Inaramidmo kaniak ti saan a rumbeng.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kinuna ni Abimelec kenni Abraham, “Ania ti nangiduron kenka a mangaramid iti daytoy a banag?” ");
INSERT INTO iloulb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kinuna ni Abraham, “Gapu ta impagarupko, 'Sigurado nga awan ti panagbuteng iti Dios iti daytoy a lugar ket patayendak gapu iti asawak.' ");
INSERT INTO iloulb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Malaksid iti dayta, pudno a kabsatko isuna, ta anak isuna ti amak ngem saan nga anak ti inak; ket nagbalin isuna nga asawak.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Idi imbaga ti Dios a panawak ti pagtaengan ti amak tapno agdaliasat manipud iti maysa a lugar nga agturong iti maysa a lugar, kinunak kenkuana, 'Masapul nga ipakitam kaniak ti kinapudnom a kas asawak: Iti tunggal lugar a papananta, kastoy ti ibagam maipapan kaniak, “Isu ket kabsatko a lalaki.'” ");
INSERT INTO iloulb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kalpasanna, nangala ni Abimelec iti karnero, kalakian a baka, lalaki ken babai a tagabu ket intedna dagitoy kenni Abraham. Kalpasanna, insublina kenkuana ni Sarah nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kinuna ni Abimelec, “Kitaem, adda iti sanggoanam ti dagak. Aggianka iti sadinoman a kayatmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kenni Sara kinunana, “Kitaem, inikkak ti kabsatmo iti sangaribu a pidaso ti pirak. Daytoy ti mangakkob iti aniaman a babak kenka iti imatang ti amin a kaduam, ken iti sangoanan ti amin, naan-anayka a napalinteg.” ");
INSERT INTO iloulb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kalpasanna, nagkararag ni Abraham iti Dios ket pinaimbag ti Dios ni Abimelec, ti asawana ken dagiti babbai a tagabuna isu a naaddaanda iti kabaelan nga aganak. ");
INSERT INTO iloulb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ta pinagbalin ni Yahweh a baog dagiti babbai iti pagtaengan ni Abimelec, gapu kenni Sarah nga asawa ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Impangag ni Yahweh ni Sarah kas imbagana nga aramidenna, ket inaramid ni Yahweh para kenni Sara ti kas iti inkarina. ");
INSERT INTO iloulb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nagsikog ni Sara ket inyanakna ti anakna a lalaki kenni Abraham iti kinalakayna, iti naikeddeng a tiempo kas imbaga ti Dios kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pinanaganan ni Abraham ti putotna kenni Sara, iti Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kinugit ni Abraham ni Isaac nga anakna idi walo nga aldawnan, kas imbilin ti Dios kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Sangagasut ti tawen ni Abraham idi naiyanak ni Isaac kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kinuna ni Sarah, “Pinagkatawanak ti Dios; tunggal maysa a makangngeg ket makipagkatawanto kaniak.'' ");
INSERT INTO iloulb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kinunana pay, ''Siasino ngay koma iti nakaibaga kenni Abraham nga agpasusonto ni Sarah kadagiti ubbing, nupay kasta inyanakko ti putotna iti kinalakayna!” ");
INSERT INTO iloulb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Dimmakkel ti ubing ket napusot, ket nagparambak ni Abraham iti dakkel a padaya iti aldaw a pannakapusot ni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nakita ni Sara ti anak ni Hagar a taga-Egipto, nga anakna kenni Abraham, nga aguy- uyaw. ");
INSERT INTO iloulb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Isu a kinunana kenni Abraham, “ Papanawem daytoy a tagabu a babai ken ti anakna: Ta saanko a kayat a makipagtawid ti anakna iti anakko, a ni Isaac.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Daytoy ket naladingit unay a banag kenni Abraham gapu iti anakna. ");
INSERT INTO iloulb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ngem kinuna ti Dios kenni Abraham, saanka nga agladingit gapu iti ubing a lalaki, ken gapu iti tagabum a babai. Denggem dagiti amin nga ibagana maipanggep iti daytoy a banag, gapu ta babaen kenni Isaac a mapanagananto dagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Pagbalinekto met ti anak ti tagabum a babai a maysa a nasion, gapu ta isuna ket kaputotam.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Bimmangon ni Abraham iti nasapa iti dayta a bigat, nangala iti tinapay ken danum a naikarga iti supot a lalat ket intedna kenni Hagar, inkabilna daytoy iti abagana. Intedna kenkuana ti ubing a lalaki ket imbagana a pumanaw isuna. Pimmanaw ket nagkalkallautang iti let-ang ti Beerseba. ");
INSERT INTO iloulb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Idi naibusen ti danum iti supot a lalat, pinanawanna ti ubing iti sirok ti maysa a narukbos a kayo. ");
INSERT INTO iloulb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ket pimmanaw isuna, ket nagtugaw iti saan unay nga adayo manipud iti ubing, ti kaadayona ket kas iti kaadayo ti naibiat a pana, ta kinunana, “Saanko kayat a buyaen ti pannakatay ti ubing.” Bayat iti panagtugtugawna iti saan unay nga adayo, nagpukkaw isuna ket nagsangit. ");
INSERT INTO iloulb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nangngeg ti Dios ti timek ti ubing, ket inawagan ti anghel ti Apo ni Hagar, ket kinunana kenkuana, “Ania ti mangrirriribok kenka Hagar? Saanka nga agbuteng, ta nangeg ti Dios ti timek ti ubing iti ayanna. ");
INSERT INTO iloulb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tumakderka, bangonem ti ubing ken pabilgem isuna; ta pagbalinekto isuna a maysa a naindaklan a nasion.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ket, linukatan ti Dios ti matana, ket nakitana ti maysa a bubon. Napan na insakdo ti supot a lalat iti danum, ket pinainomna ti ubing a lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ti Dios ket adda iti ubing, ket dimmakkel isuna. Nagnaed isuna idiay let-ang ket nagbalin isuna a pumapana. ");
INSERT INTO iloulb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nagnaed isuna idiay let-ang ti Paran, ket nangala ti inana iti asawaenna manipud iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Napasamak iti dayta a tiempo a ni Abimelek kenni Pikol a kapitan ti armadana ket nakiao kenni Abraham, a kinunana, “Ti Dios ket adda kenka iti amin nga ar-aramidem. ");
INSERT INTO iloulb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ita ngarud agsapataka kaniak ditoy babaen iti Dios a saannakto nga allilawen, uray dagiti annakko, wenno kadagiti kaputotak. Ipakitam kaniak ken iti daga a pagnanaedam ti kinapudnom a kas iti kinapudno nga impakitak kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kinuna ni Abraham, “Isapatak.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nagriri met ni Abraham kenni Abimelek maipanggep iti bubon ti danum nga inagaw dagiti adipen ni Abimelech manipud kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kinuna ni Abimelek, “Saanko nga ammo no siasino ti nangaramid iti daytoy a banag. Saanmo nga imbagbaga idi kaniak sakbay ita; Saanko pay a nangnangegan ti maipanggep iti daytoy agingga ita nga aldaw.” ");
INSERT INTO iloulb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Isu a nangala ni Abraham iti karnero ken baka ket intedna kenni Abimelek, ket nagtulag dagiti dua a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ket nangilasin ni Abraham iti pito a kaba-ian a karnero manipud iti arban. ");
INSERT INTO iloulb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kinuna ni Abimelec kenni Abraham, “Ania ti kayat a sawen dagitoy pito a babbai a karnero nga inlasinmo? ");
INSERT INTO iloulb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Simmungbat isuna, “Dagitoy pito a babai a karnero ket awatem manipud iti imak, tapno agbalin a saksi para kaniak, a kinalik daytoy a bubon. ");
INSERT INTO iloulb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Isu nga inawaganna dayta a lugar iti Beerseba, gaputa ta nagkinnarida a dua. ");
INSERT INTO iloulb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Nagtulagda idiay Beerseba, ket kalpasanna, nagsubli ni Abimelec ken ni Picol a kapitan ti armadana iti daga dagiti Filisteo. ");
INSERT INTO iloulb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nagmula ni Abraham iti kayo a tamarisko idiay Beerseba. Sadiay, nagdayaw isuna kenni Yahweh, ti agnanayon a Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nagtalinaed a gangannaet ni Abraham iti daga dagiti Filisteo iti adu nga al-aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Napasamak a kalpasan dagitoy a banbanag ket pinadas ti Dios ni Abraham. Kinunana kenkuana, “Abraham!” Kinuna ni Abraham, “Adtoyak.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ket kinuna ti Dios, “Alaem ti anakmo, ti kakaisuna nga anakmo, a dungdungoem, ni Isaac, ket mapankayo idiay daga ti Moria. Idatonmo isuna a kas daton a mapuoran iti maysa kadagiti bantay sadiay, nga ibagakto kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Isu a nasapa a bimmangon ni Abraham iti bigbigat, insaganana ti asnona, ken nangikuyog iti dua nga agtutubo a lalaki nga adipenna, kasta met ni Isaac nga anakna. Nangputed iti kayo para iti daton a mapuoran, ket nagdaliasatda iti lugar nga imbaga ti Dios kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Iti maikatlo nga aldaw, timmangad ni Abraham ket nakitana ti lugar iti adayo. ");
INSERT INTO iloulb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Imbaga ni Abraham kadagiti agtutubo a lallaki nga adipenna, agbatikayo ditoy a kaduayo ti asno, ket mapanak ken ti ubing idiay. Agdayawkami ket subliandakayonto. ");
INSERT INTO iloulb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ket innala ni Abraham ti kayo para iti daton a mapuoran ket impabaklay kenni Isaac a putotna. Innalana ti beggang ken ti kutsilyo; ket napanda a dua. ");
INSERT INTO iloulb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nagsao ni Isaac kenni Abraham nga amana ket kinunana, “Ama,” ket kinunana, “Adtoyak, anakko.” Kinunana, ''Kitaem, adda ditoy ti beggang ken ti kayo, ngem ayanna ti kordero a para iti daton a mapuoran?” ");
INSERT INTO iloulb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kinuna ni Abraham, “Mangipaayto ti Dios iti kordero a para iti daton a mapuoran, anakko. “Isu nga intuloyda a dua iti napan. ");
INSERT INTO iloulb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Idi nakagtengda iti lugar nga imbaga ti Dios kenkuana, nangbangon ni Abraham iti altar sadiay ket imparabawna ti kayo iti daytoy. Kalpasanna, pinungona ni Isaac nga anakna, ket impaiddana iti altar, iti rabaw ti kayo. ");
INSERT INTO iloulb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ginaw-at ni Abraham ti kutsilyo tapno patayenna ti anakna. ");
INSERT INTO iloulb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kalpasanna, inawagan isuna ti anghel ni Yahweh manipud langit a kinunana, ''Abraham, Abraham!” ket kinunana, “Adtoyak.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kinunana, “Saanmo a sagiden ti ubing a lalaki, wenno agaramid iti aniaman a banag a mangdangran kenkuana, ta ita, ammokon nga agbutengka iti Dios, gapu ta saanmo nga impaidam ti anakmo a kakaisuna manipud kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Timmangad ni Abraham ket pagammoan, iti likudanna ket adda kalakian a karnero a naisalat dagiti sarana iti narukbos a kayo. Napan ni Abraham ket innalana ti kalakian a karnero ket indatonna a kas daton a mapuoran imbes a ti anakna a lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Isu a pinanaganan ni Abraham dayta a lugar iti “Isabet ni Yahweh'' ket maibagbaga agingga iti daytoy nga aldaw, “Iti rabaw ti bantay ni Yahweh, maisabetto.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Inawagan ti anghel ni Yahweh ni Abraham iti maikadua a daras manipud langit ");
INSERT INTO iloulb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ket kinunana - daytoy ket sasao a nagtaud kenni Yahweh, “Sinapataak iti bagik a gapu ta inaramidmo daytoy a banag, ken saanmo nga impaidam ti kakaisuna nga anakmo a lalaki, ");
INSERT INTO iloulb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pudno a bendisionankannto ken paaduekto ti kaputotam a kas iti kaadu dagiti bituen sadi langit, ken kas iti darat iti igid ti baybay; ken tagikuaento ti kaputotam ti ruangan dagiti kabusorda. ");
INSERT INTO iloulb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Babaen kadagiti kaputotam ket mabendisionanto amin a nasion ditoy daga, gapu ta nagtulnogka iti timekko.” ");
INSERT INTO iloulb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nagsubli ngarud ni Abraham iti ayan dagiti agtutubo nga adipenna, ket pimmanawda ken nagkukuyogda a napan idiay Beerseba, ket nagnaed isuna idiay Beerseba. ");
INSERT INTO iloulb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Napasamak a kalpasan dagitoy a banbanag ket naipadamag kenni Abraham, “Naganak met ni Milka, para iti kabsatmo a ni Nahor. ");
INSERT INTO iloulb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Isuda ket ni Uz nga inauna, ni Buz a kabsatna a lalaki, ni Kemuel nga ama ni Aram, ");
INSERT INTO iloulb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ni Kesed, ni Hazo, ni Pildas, ni Jidlap ken ni Betuel. ");
INSERT INTO iloulb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ni Betuel ti ama ni Rebecca. Dagitoy dagiti walo nga inyanak ni Milka kenni Nahor, a kabsat a lalaki ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Inyanak met ti inkabbalayna nga agnagan iti Reuma, da Teba, Taaz ken Maaca. ");
INSERT INTO iloulb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Nagbiag ni Sarah iti sangagasut duapulo ket pito a tawen. Daytoy ti dagup ti tawen ti panagbiag ni Sarah. ");
INSERT INTO iloulb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Natay ni Sarah idiay Kiriat Arba, dayta ket, Hebron, iti daga ti Canaan. Nagladingit ken dinung-awan ni Abraham ni Sarah. ");
INSERT INTO iloulb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kalpasanna, timmakder ni Abraham ket pimmanaw manipud iti ayan ti natay nga asawana, ket nakisao kadagiti lallaki nga annak ni Het, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","''Maysaak a ganggannaet a makipagnanaed kadakayo. Pangngaasiyo ta patgandak a manggatang iti maysa a daga a pagitaneman, tapno maitabonko ti minatayko.'' ");
INSERT INTO iloulb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Simmungbat dagiti lallaki nga annak ni Het kenni Abraham, a kunada, ");
INSERT INTO iloulb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","''Denggennakami, apo. Sika ket prinsipe ti Dios kadakami, itabonmo ti minataymo kadagiti kasasayaatan a pagitantanemanmi. Awan kadakami ti agkedkedto kenka iti tanemna, tapno maitabonmo ti minataymo.'' ");
INSERT INTO iloulb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Timmakder ni Abraham ket nagparintumeng iti sangoanan dagiti tattao iti dayta a daga, kadagiti lallaki nga annak ni Het. ");
INSERT INTO iloulb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kinasaona ida, a kunana, “No umanamongkayo a rumbeng nga itabonko ti minatayko, denggendak ngarud ket makipakpakaasiyo kenni Efron nga annak ni Zohar, para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Dawatenyo kenkuana nga ilakona kaniak ti rukib ti Macpela, a kukuana, nga adda iti pungto ti taltalonna. Ilakona kaniak iti maitutop a bayadna iti imatang ti kaaduan kas maysa a sanikua a mausar a pagitaneman.'' ");
INSERT INTO iloulb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ita, ni Efron ket agtugtugaw a kadua dagiti lallaki nga annak ni Het, ket simmungbat ni Efron a Heteo kenni Abraham iti panagdengngeg dagiti lallaki nga annak ni Het, kadagiti amin a napan iti ruangan iti siudadna, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Saan, apok, denggennak. Itedko kenka ti taltalon, ken ti rukib nga adda iti daytoy. Itedko kenka iti imatang dagiti annak dagiti tattaok. Itedko kenka tapno itabonmo ti minataymo.'' ");
INSERT INTO iloulb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ket nagkurno ni Abraham iti sangoanan dagiti tattao iti dayta a daga. ");
INSERT INTO iloulb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Kinasaona ni Efron a mangmangngeg dagiti tattao iti dayta a daga, a kunana, “Ngem no sipapaluboska, pangngaasim ta denggennak. Bayadak ti taltalon. Alaem ti kuarta manipud kaniak, ket itabonko ti minatayko sadiay.” ");
INSERT INTO iloulb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Sinungbatan ni Efron ni Abraham, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Pangngaasim, apok, denggennak. Ti paset ti daga ket aggatad iti uppat a gasut a bagi ti pirak, ania ngay dayta kadata? Itabonmo ti minataymo.” ");
INSERT INTO iloulb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Dimngeg ni Abraham kenni Efron ket nangtimbang ni Abraham iti gatad nga uppat a gasut a pirak segun iti imbaga ni Efron kabayatan a dedenggen dagiti lallaki nga annak ni Het, uppat a gasut a bagi ti pirak, a maiyannurot iti timbang nga us-usaren dagiti agtagtagilako. ");
INSERT INTO iloulb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Isu a ti taltalon ni Efron, nga adda idiay Macpela a kabangibang ti Mamre, ti taltalon ken ti rukib nga adda iti daytoy, ken amin a kaykayo nga adda iti taltalon ken ti amin nga adda iti aglawlaw ti beddengna, ket naited ");
INSERT INTO iloulb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kenni Abraham babaen iti pananggatangna iti daytoy iti imatang dagiti lallaki nga annak ni Het, ken iti sangoanan dagiti napan idiay ruangan ti siudadna. ");
INSERT INTO iloulb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kalpasan daytoy, intabon ni Abraham ni Sarah nga asawana iti rukib nga adda iti taltalon ti Macpela, a kabangibang ti Mamre, nga isu ti Hebron, iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Isu a ti taltalon ken ti rukib nga adda sadiay ket naipaima kenni Abraham kas maysa a sanikua a pagitaneman manipud kadagiti lallaki nga annak ni Het. ");
INSERT INTO iloulb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ita, lakayen ni Abraham, lakay unayen, ket binendisionan ni Yahweh ni Abraham iti amin a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kinuna ni Abraham iti adipenna a kalakayan iti pagtaenganna ken isu ti mangimatmaton iti amin nga adda kenni Abraham, ''Ikabilmo ta imam iti baet dagiti luppok ");
INSERT INTO iloulb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ket pagsapataenka kenni Yahweh, a Dios ti langit ken Dios ti daga, a saankanto a mangala iti asawa para iti anakko manipud kadagiti annak dagiti taga-Canaan, a nangaramidak iti pagtaengak. ");
INSERT INTO iloulb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ngem mapankanto iti pagiliak, ken kadagiti kabagiak, ket mangalaka iti asawa para iti anakko a ni Isaac.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kinuna ti adipen kenkuana, “Kasano no saan a kayat ti babai a sumurot kaniak iti daytoy a daga? Masapul kadi nga umayko ikuyog ti anakmo ket isublik iti daga a naggapuam? ");
INSERT INTO iloulb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kinuna ni Abraham kenkuana, “Siguradoem a saanmo nga isubli ti anakko sadiay! ");
INSERT INTO iloulb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ni Yahweh a Dios ti langit, a nangala kaniak manipud iti balay ni amak ken manipud iti daga dagiti kabagiak, ken nagkari kaniak babaen iti napasnek a sapata a kunana, 'Itedkonto kadagiti kaputotam daytoy a daga,' ibaonnanto ti anghelna nga umuna kenka, ket mangalakanto iti asawaen ti anakko manipud sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ngem no saan a kayat ti babai a sumurot kenka, mawayawayaankanto ngarud manipud iti daytoy a panagsapatam kaniak. Dayta laeng ta saan a mabalin nga isublim ti annakko sadiay.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Isu nga inkabil ti adipen ti imana iti baet ti luppo ni Abraham nga apona, ket nagsapata kenkuana maipanggep iti daytoy a banag. ");
INSERT INTO iloulb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nangala ti adipen iti sangapulo a kamelio ti apona ket pimmanaw. Nangala pay isuna kadagiti amin a kita dagiti sagut manipud iti apona. Pimmanaw isuna ket napan iti rehion ti Aram Naharaim, iti siudad ni Nahor. ");
INSERT INTO iloulb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pinaginanana dagiti kamelio iti ruar ti siudad iti abay ti bubon. Rabii idin, ti tiempo a panagruruar dagiti babbai a mapan agsakdo. ");
INSERT INTO iloulb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ket kinunana, “Yahweh, Dios ti apok a ni Abraham, ipaaymo koma kaniak ti panagballigi iti daytoy nga aldaw ken ipakitam ti napudno a katulagam kenni apok a ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kitaem, addaak ditoy nga agtaktakder iti abay ti ubbog, ket dagiti babbai a putot dagiti lallaki iti daytoy a siudad ket rummuarda nga umay agsakdo. ");
INSERT INTO iloulb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kastoy koma ngarud iti mapasamak. No ibagak iti maysa a balasang, 'Pangngaasim ta ibabam ta karambam tapno makiinumak,' ket kunaenna kaniak, 'Uminomka, ken painumek met dagiti kameliom,' ket isunanto ti intudingmo para iti adipenmo a ni Isaac. Babaen iti daytoy a maammoak nga impakitam ti kinapudnom iti tulagmo iti apok.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Napasamak a sakbay a nalpasna ti panagsaritana, adtoy met ni Rebecca a rimmuar nga addaan iti karamba iti abagana. Ni Rebecca ket putot ni Betuel nga anak a lalaki ni Milca nga asawa ni Nahor a kabsat a lalaki ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nakapinpintas unay ti balasang ken maysa isuna a birhen. Awan pay iti lalaki a nakikaidda kenkuana. Simmalog isuna iti ubbog ket pinunnona ti karambana, ket simmang-at. ");
INSERT INTO iloulb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ket nagtaray ti adipen tapno sabtenna isuna ket kinunana, “Pangngaasim ta ikkannak iti bassit a mainum manipud dita karambam.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kinunana, Uminomka, apok,” ket dagdagus nga imbabana ti karamba kadagiti imana, ket pinainomna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Idi nalpasna isuna a pinainom, kinunana, “Agsakdoakto met iti para kadagiti kameliom, agingga a malpasda nga uminom.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Isu a nagdardaras isuna ket imbukbokna ti nagyan iti karambana iti paginuman dagiti ayup, ket nagtaray manen a nagsubli idiay bubon tapno agsakdo, ket insakdoanna amin dagiti kamelio ti adipen. ");
INSERT INTO iloulb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Siuulimek a binuybuya isuna ti lalaki tapno makitana no pinagballigi ni Yahweh ti panagdaliasatna wenno saan. ");
INSERT INTO iloulb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Idi nalpas nga imminum dagiti kamelio, nangiruar ti lalaki iti balitok nga aritos ti agong nga agtimbang iti kagudua ti siklo, ken dua a pulseras a para kadagiti takyagna nga agdagsen iti sangapulo a siklo, ");
INSERT INTO iloulb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ken sinaludsodna, “Siasino ti akin anak kenka? Pangngaasim ta ibagam kaniak, adda kadi siled idiay balay ni amam para kadakami a pagpalabasanmi iti rabii?” ");
INSERT INTO iloulb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kinuna ti balasang kenkuana, “Siak ket anak ni Betuel nga anak a lalaki ni Milca, nga inyanakna kenni Nahor.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kinunana pay kenkuana, “Addaankami iti adu a garami ken makan, ken kasta met iti siled a para kenka a pagpalabasam ti rabii.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ket nagkurno ti lalaki ken indaydayawna ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kinunana, “Madaydayaw ni Yahweh a Dios ti amongko a ni Abraham, saanna a tinallikudan ti kinapudnona iti tulagna ken ti kinamapagtalkanna iti amongko. Iti biangko met, inturongnak a dagus ni Yahweh iti balay dagiti kabagian ti amongko.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kalpasanna, nagtaray ti balasang ket napanna imbaga iti sangkabalayan ni nanangna ti maipanggep kadagitoy amin a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ita, addaan ni Rebecca iti kabsat a lalaki, ket Laban ti naganna. Nagtaray ni Laban iti ruar, iti ayan ti lalaki nga adda iti kalsada iti abay ti ubbog. ");
INSERT INTO iloulb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Idi nakitana ti aritos ti agong ken dagiti pulseras iti takiag ti kabsatna, ken idi nangngeganna dagiti sinao ni Rebecca a kabsatna, “Daytoy ti imbaga ti lalaki kaniak,” napan isuna iti ayan ti lalaki, ket adda sadiay nga agtaktakder iti abay dagiti kamelio iti ayan ti ubbog. ");
INSERT INTO iloulb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ket kinuna ni Laban, “Umayka, sika a binendisionan ni Yahweh. Apay nga agtaktakderka dita ruar? Insaganak ti balay ken ti disso a para kadagiti kamelio.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Isu a napan ti lalaki iti balay ket inikkatna dagiti awit dagiti kamelio. Ket naikkan dagiti kamelio ti garami ken makan, ket naipaayan met iti danum a pangbuggona kadagiti sakana kasta met dagiti saka dagiti lallaki a kakaduana. ");
INSERT INTO iloulb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nangisaganada iti taraon iti sagoananna tapno mangan, ngem kinunana, “Saanak a mangan agingga a maibagak no ania ti masapul nga ibagak.” Isu a kinuna ni Laban, “Agsaoka” ");
INSERT INTO iloulb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kinunana, “Adipennak ni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Binendisionan ni Yahweh ti apok iti kasta unay ket nagbalin a naindaklan. Inikkanna isuna kadagiti karnero ken kadagiti kalding, pirak ken balitok, kadagiti lallaki nga adipen ken kadagiti babbai nga adipen, ken kadagiti kamelio ken kadagiti asno. ");
INSERT INTO iloulb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ni Sarah nga asawa ti apok ket nangipasngay iti maysa a lalaki kenni amongko idi baketen isuna, ket intedna amin a banbanag a sanikuana kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pinagsapatanak ti apok, a kinunana, 'Masapul a saanka a mangala iti asawa a para iti anakko manipud kadagiti annak a babbai dagiti taga-Canaan, daga a nangaramidak iti pagtaengak. ");
INSERT INTO iloulb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ngem ketdi, masapul a mapanka iti pamilia ni tatangko, ken kadagiti kabagiak, ket mangalaka iti asawaen ti anakko.' ");
INSERT INTO iloulb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kinunak iti apok, 'Nalabit a saanto a sumurot kaniak ti babai. ");
INSERT INTO iloulb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ngem kinunana kaniak, 'Ni Yahweh, a pagtultulnogak, ket ibaonnanto ti anghelna a kumuyog kenka ket pagballigiennanto ti dalanmo, tapno iti kasta ket mangalaka iti asawaen ti anakko manipud kadagiti kabagiak ken manipud iti linya ti pamilia ni tatangko. ");
INSERT INTO iloulb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ngem mawayawayaankanto manipud iti sinapataam kaniak no mapanka kadagiti kabagiak ket saanda nga ited isuna kenka. Ket mawayawayaankanto manipud iti sinapataam kaniak.' ");
INSERT INTO iloulb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Simmangpetak ngarud ita nga aldaw iti ayan ti ubbog, ket kinunak, 'O Yahweh, Dios ti apok a ni Abraham, pangngaasim, no pudno a panggepmo a pagballigien ti panagdaliasatko— ");
INSERT INTO iloulb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","addaak ditoy nga agtaktakder iti abay ti ubbog—Ti koma balasang nga umay agsakdo, iti babai a pangibagaak, “Pangngaasim ta ikkannak iti bassit a danum nga inumek manipud dita karambam,” ");
INSERT INTO iloulb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ti babai a mangibaga kaniak, “Uminomka, ket sumakdoakto met para kadagiti kameliom”— ket isuna ti babai nga inkapinili, Yahweh, para iti putot ti apok.' ");
INSERT INTO iloulb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Sakbay pay a nalpasak nga agsarita iti pusok, pagammoan, simmangpet ni Rebecca nga awitna ti karambana iti abagana ket simmalog idiay ubbog ket nagsakdo. Isu a kinunak kenkuana, 'Pangngaasim ta painumennak.' ");
INSERT INTO iloulb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Dagus nga imbabana ti karambana manipud iti abagana ket kinunana, 'Uminumka, ket painumek met dagiti kameliom.' Imminomak ngarud, ket pinainomna met dagiti kamelio. ");
INSERT INTO iloulb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ket dinamagko kenkuana, 'Siasino ti akin anak kenka? Kinunana, 'Putotnak ni Betuel a putot ni Nahor, nga impasngay ni Milca kenkuana.' Ket inkabilko ti aritos iti agongna ken dagiti pulseras kadagiti takiagna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kalpasanna, nagkurnoak ket nagdaydayawak kenni Yahweh, indaydayawko ni Yahweh a Dios ti apok a ni Abraham, nga isu iti nangidalan kaniak iti umno a dalan tapno masarakak ti anak dagiti kabagian ti amongko para iti anakna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ita ngarud, no nakasaganakayo a mangpadayaw iti apok babaen iti kinapudnoyo ken kinamapagtalkan iti pamilya, ibagayo kaniak. Ngem no saan, ibagayo kaniak, tapno ammok ti aramidek.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ket simmungbat da Laban ken Betuel a kinunada, “Ti banag ket naggapu kenni Yahweh; saankami a mabalin nga agsarita iti nasayaat wenno dakes kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Adtoy ni Rebecca iti sangoanam. Alaem isuna ket mapankayo, tapno agbalin nga asawa ti anak ti apom, kas imbaga ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Idi nangngegan ti adipen ni Abraham dagiti sinaoda, nagpakleb iti daga para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Inruar ti adipen dagiti banbanag a pirak, ken banbanag a balitok, ken pagan-anay, ket intedna kenni Rebecca. Inikkanna met iti napapateg a sagut ti kabsatna a lalaki ken ni nanangna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ket nangan ken imminom isuna ken dagiti lallaki a kaduana. Ket nagtalinaedda sadiay iti nagpatnag, ket idi bimmangonda iti kabigatan, kinunana, “Palubosandak a mapan iti apok.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kinuna ti kabsat a lalaki ken ti nanang ni Rebecca, “Agtalinaed pay koma ti balasang kadakami iti sumagmamano pay nga al-aldaw, uray sangapulo laeng. Kalpasan dayta, mabalinna ti mapan.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ngem kinunana kadakuada, “Saandak a lappedan, agsipud ta pinagballigi ni Yahweh ti panagdaliasatko. Palubosandak a pumanaw tapno mapanak kenni amongko.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kinunada, “Ayabanmi ti balasang ket saludsodenmi isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Isu nga inayabanda ni Rebecca ket sinaludsodda kenkuana, “Sumurotka kadi iti daytoy a lalaki?” Simmungbat isuna, “Sumurotak.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Pinalubosanda ngarud ni Rebecca, a kaduana dagiti adipenna a babbai, iti panagdaliasatna a kadua ti adipen ni Abraham ken dagiti lallaki a kaduana. ");
INSERT INTO iloulb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Binendisionanda ni Rebecca, a kinunada kenkuana, “Kabsatmi a babai, agbalinka koma nga ina iti rinibribu ti sangapulo a ribu, ken tagikuaen koma dagiti pulim ti ruangan dagiti manggura kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kalpasanna, nagrubbuat ni Rebecca ket insaganana ken dagiti adipenna a babbai dagiti kamelio, ket simmurotda iti lalaki. Kastoy ti panangala ti adipen kenni Rebecca, ket napan iti dalanna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ita, ni Isaac ket agnanaed idiay Negeb, ket kasubsublina laeng manipud Beer-lahai-roi. ");
INSERT INTO iloulb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Rimmuar ni Isaac tapno mapan agpanunot iti kataltalunan iti rabii, ket idi timmangad isuna ken kimmita, pagammoan ket adda nakitana a sumagmamano a kamelio a sumungsungad! ");
INSERT INTO iloulb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kimmita ni Rebecca, ket idi nakitana ni Isaac, limmagto nga immulog iti kamelio. ");
INSERT INTO iloulb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Kinunana iti adipen, “Siasino dayta a lalaki a magmagna idiay taltalon a sumabat kadatayo?” Kinuna ti adipen, “Ti apok.” Isu nga innalana ti dalungdongna, ket inabbunganna ti ulona. ");
INSERT INTO iloulb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Imbaga ti adipen kenni Isaac dagiti amin a banbanag nga inaramidna. ");
INSERT INTO iloulb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ket impan ni Isaac ni Rebecca idiay tolda ni Sarah nga inana ket innalana daytoy, ket nagbalin nga asawana ken inayatna. Naliwliwa ngarud ni Isaac kalpasan a natay ni nanangna. ");
INSERT INTO iloulb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nangala ni Abraham iti sabali pay nga asawana; ti naganna ket Ketura. ");
INSERT INTO iloulb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Inyanakna da Zimran, Jocsan, Medan, Midian, Isbac, ken Sua. ");
INSERT INTO iloulb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ni Jocsan ti ama da Seba ken Dedan. Dagiti kaputotan ni Dedan ket dagiti tattao nga Assurim, dagiti Letusim ken dagiti Leummim. ");
INSERT INTO iloulb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Dagiti putot a lallaki ni Midian ket da Efa, Efer, Hanoc, Abida ken Eldaa. Amin dagitoy ket nagtaud iti puli ni Ketura. ");
INSERT INTO iloulb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Inted ni Abraham amin a sanikuana kenni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nupay kasta, kabayatan a sibibiag pay laeng isuna, inikkanna kadagiti sagut dagiti annakna a lallaki kadagiti dadduma nga assawana ken imbaonna ida iti nga adda iti daya, nga adayo manipud kenni Isaac, a putotna. ");
INSERT INTO iloulb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dagitoy dagiti aldaw dagiti tawen iti panagbiag ni Abraham, 175 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Inyanges ni Abraham ti maudi nga angesna ket natay iti nasayaat a tawen iti kinalakay, lakay a napnoan iti biag, ket naitipon isuna kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Intabon isuna da Isaac ken Ismael a putotna idiay rukib ti Macpela, iti talon ni Efron nga anak ni Zohar a Heteo, nga asideg iti Mamre. ");
INSERT INTO iloulb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ginatang ni Abraham daytoy a talon manipud kadagiti annak a lallaki ni Het. Naitabon ni Abraham sadiay kasta met ni Sarah nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kalpasan iti ipapatay ni Abraham, binendisionan ti Dios ni Isaac nga anak ni Abraham, ket nagnaed ni Isaac iti asideg ti Beer-lahai-roi. ");
INSERT INTO iloulb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ita, dagitoy dagiti kaputotan ni Ismael, nga anak ni Abraham, nga inyanak ni Hagar, nga Egipcio nga adipen ni Sarah, kenni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dagitoy dagiti nagnagan dagiti annak a lallaki ni Ismael, segun iti panagsasarunoda a naiyanak: ni Nebayot- ti inauna nga anak ni Ismael, Kedar, Adbeel, Mibsam, ");
INSERT INTO iloulb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO iloulb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Nafis ken Kedema. ");
INSERT INTO iloulb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dagitoy dagiti annak a lallaki ni Ismael, ken dagitoy dagiti nagnaganda, a nagtaudan dagiti barrioda, ken dagiti kamkampoda; sangapulo ket dua a prinsipe segun kadagiti tribuda. ");
INSERT INTO iloulb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Dagitoy dagiti tawtawen iti panagbiag ni Ismael, 137 a tawen: inyangesna ti maudi nga angesna ket natay, ket naitipon kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nagnaed dagiti kaputotanna manipud iti Havila agingga iti Sur, nga asideg ti Egipto, nga agturong iti Asiria. Nagbiagda nga addaan iti gura iti tunggal maysa. ");
INSERT INTO iloulb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dagitoy dagiti pasamak maipapan kenni Isaac a putot ni Abraham. Ni Abraham ti ama ni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Agtawen iti uppat a pulo ni Isaac idi inasawana ni Rebecca nga anak a babai ni Betuel nga Arameo iti Padan-aram ken kabsat a babai ni Laban nga Arameo. ");
INSERT INTO iloulb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nagkararag ni Isaac kenni Yahweh para iti asawana gapu ta awan iti anakna, ket sinungbatan ni Yahweh ti kararagna, ket nagsikog ni Rebecca nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Agginginnubal dagiti ubbing a sikogna, ket kinunana, “Apay a mapaspasamak kaniak daytoy?” Indawatna kenni Yahweh ti maipanggep iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kinuna ni Yahweh kenkuana, “Dua a nasion ti adda iti aanakam, ken dua a tattao ti agsinanto nga agtaud kenka. Napigpigsanto ti maysa a tao ngem iti maysa, ken pagserbianto ti inauna ti ub-ubing.” ");
INSERT INTO iloulb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Idi tiempon ti panaganakna, singin gayam ti adda iti aanakanna. ");
INSERT INTO iloulb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ket rimmuar ti immun-una a nalabaga ti kudilna a kasla dutdotan a pagan-anay. Pinanagananda isuna iti Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kalpasan dayta, rimmuar ti kabsatna a lalaki. Ig-iggamanna ti mukod ni Esau. Napanaganan isuna iti Jacob. Agtawen iti innem a pulo ni Isaac idi inyanak ti asawana dagiti singin. ");
INSERT INTO iloulb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Dimmakkel dagiti lallaki, ket nagbalin ni Esau a nalaing a mangnganup, maysa a lalaki iti tay-ak; ngem ni Jacob ket naulimek a tao ken ad-adda nga agigian iti ayan dagiti tolda. ");
INSERT INTO iloulb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ita, ay-ayaten ni Isaac ni Esau gapu ta kankanenna dagiti ayup a maan-anupan ni Esau, ngem ay-ayaten ni Rebecca ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ita, aglutluto ni Jacob iti bukbukel. Simmangpet ni Esau manipud iti talon, ket uray la kimmapsut gapu iti bisin. ");
INSERT INTO iloulb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kinuna ni Esau kenni Jacob, “Pakanennak man iti dayta a nalabaga a bukel. Pangngaasim, nabannogak unay!” Dayta ti makagapu a napanaganan isuna iti Edom. ");
INSERT INTO iloulb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kinuna ni Jacob, “Ilakom nga umuna kaniak ti karbengam a kas inauna nga anak.” ");
INSERT INTO iloulb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kinuna ni Esau, “Kitaem, dandani-akon a matay. Ania pay ti pategna kaniak ti karbengak a kas inauna nga anak?” ");
INSERT INTO iloulb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kinuna ni Jacob, “Agsapataka nga umuna kaniak,” isu a sinapataan ni Esau ti karina ket iti kasta a wagas, inlakona kennu Jacob ti karbenganna a kas inauna nga anak. ");
INSERT INTO iloulb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Inikkan ni Jacob ni Esau iti tinapay ken ti naipaburek a nalabaga a bukbukel. Nangan isuna ken imminum, kalpasanna ket timmakder ken napan iti dalanna. Iti kastoy a wagas, tinagibassit ni Esau ti karbenganna a kas inauna nga anak. ");
INSERT INTO iloulb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ita, adda napasamak a panagbisin iti daga, malaksid iti immuna a panagbisin a napasamak kadagidi al-aldaw ni Abraham. Napan ni Isaac kenni Abimelec nga ari dagiti Filisteo idiay Gerar. ");
INSERT INTO iloulb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ita, nagparang ni Yahweh kenkuana ket kinunana, “Saanka a mapan idiay Egipto; agnaedka iti daga nga imbagak kenka a pagnaedam. ");
INSERT INTO iloulb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Agtalinaedka iti daytoy a daga, ket addaakto kenka ken bendisionankanto; ta kenka ken kadagiti kaputotamto, itedkonto amin dagitoy a dagdaga, ken tungpalekto ti kari a sinapataak kenni Abraham nga amam. ");
INSERT INTO iloulb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Paadduekto dagiti kaputotam a kas kadagiti bituen iti langit, ken itedkonto kadagiti kaputotam amin dagitoy a dagdaga. Mabendisionanto amin a nasion iti daga babaen kadagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Aramidek daytoy gapu ta nagtulnog ni Abraham iti timekko ken tinungpalna dagiti pagannurotak, dagiti bilinko, dagiti alagadek, ken dagiti lintegko.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nagnaed ngarud ni Isaac idiay Gerar. ");
INSERT INTO iloulb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Idi dinamag kenkuana dagiti lallaki iti dayta a lugar ti maipanggep iti asawana, kinunana, “Kabsatko isuna.” Mabuteng isuna a mangibaga nga, “Asawak isuna,” gapu ta ti napanunotna, “Papatayendak dagiti lallaki iti daytoy a lugar tapno alaenda ni Rebecca, gapu ta napintas unay isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kalpasan iti nabayag a tiempo a kaadda ni Isaac sadiay, nairana a timman-aw ni Abimelec nga ari dagiti Filisteo iti tawa. Nakitana a lalailoen ni Isaac ni Rebecca nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Inayaban ni Abimelec ni Isaac ket kinunana, “Kitaem, awan dua dua nga asawam isuna. Apay nga imbagam a, 'Kabsatko isuna'?” Kinuna ni Isaac kenkuana, ");
INSERT INTO iloulb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“Gapu ta napanunotko a mabalin a papatayendak ti siasinoman tapno maalada isuna.” Kinuna ni Abimelec, “Ania daytoy nga inaramidmo kadakami? Mabalin a maysa kadagiti tattao ket silalakada a kinaidda ti asawam ket no napasamak ti kasta, nganngani nakami nga insarsarak iti pakabasolanmi.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Isu a binallaagan ni Abimelec dagiti amin a tattao a kinunana, “Siasinoman a mangsagid iti daytoy a lalaki wenno iti asawana ket siguradonto a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nagmula ni Isaac kadagiti mulmula iti dayta a daga ken nagapit iti dayta met laeng a tawen iti mamingasut a kaadu, gapu ta binendisionan ni Yahweh isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nagbalin a nabaknang ti lalaki, ken rimmang-ay a rimmang-ay inggana a nagbalin isuna a naindaklan unay. ");
INSERT INTO iloulb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Addaan isuna kadagiti adu a karnero, ken bakbaka, ken dakkel a sangkabalayan. Ket immapal dagiti Filisteo kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ita, amin dagiti bubon a kinali dagiti adipen ni amana kadagidi al-aldaw ni Abraham nga amana, ket sinullatan dagiti Filisteo babaen iti pananggaburda kadagitoy iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kinuna ni Abimelec kenni Isaac, “Umadayoka kadakami, ta nabilbilegka nga adayo ngem kadakami.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isu a pimmanaw ni Isaac manipud sadiay ket nagkampo idiay tanap ti Gerar, ket nagnaed sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kinali manen ni Isaac dagiti bubon, a kinalida kadagidi al-aldaw ni Abraham nga amana. Sinullatan dagitoy dagiti Filisteo kalpasan ti ipapatay ni Abraham. Pinanaganan ni Isaac dagiti bubon iti isu met laeng a nagnagan nga impanagan ti amana kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Idi nagkali dagiti adipen ni Isaac idiay tanap, nakasarakda sadiay iti bubon ti agay-ayus a danum. ");
INSERT INTO iloulb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nakiapa dagiti agpaspastor a taga-Gerar kadagiti agpaspastor ni Isaac ket kinunada, “Kukuami daytoy a danum.” Isu a pinanaganan ni Isaac dayta a bubon iti “Esek,” gapu ta nakiapada kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kalpasanna, nangkalida iti sabali pay a bubon, ket pinagaapanda manen dayta, isu a pinanagananna dayta a bubon iti “Sitnah.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Pimmanaw isuna sadiay ket nangkalida iti sabali pay a bubon, ngem saandan a pinagaapaan dayta. Isu a pinanaganannam daytoy iti Rehobot, ket kinunana, “Ita nangaramid ni Yahweh iti lugar para kadatayo, ket rumang-aytayonto iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ket manipud sadiay, simmang-at ni Isaac idiay Beerseba. ");
INSERT INTO iloulb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nagparang ni Yahweh kenkuana iti dayta met laeng a rabii ket kinunana, “Siak ti Dios ni Abraham nga amam. Saanka nga agbuteng, ta addaak kenka ken bendisionankanto ken paadduek dagiti kaputotam, gapu kenni Abraham nga adipenko.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nangbangon ni Isaac iti altar sadiay ket immawag isuna iti nagan ni Yahweh. Sadiayna nga impatakder ti kampona, ket nagkali dagiti adipenna iti bubon. ");
INSERT INTO iloulb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kalpasanna, napan ni Abimelec kenkuana manipud Gerar, a kaduana ni Ahuzzat a gayyemna, ken ni Ficol a kapitan ti armadana. ");
INSERT INTO iloulb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kinuna ni Isaac kadakuada, “Apay nga immaykayo kaniak, idinto a kagurguradak ken pinapanawdak manipud kadakayo?” ");
INSERT INTO iloulb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ket kinunada, “Nalawag a nakitami nga adda ni Yahweh kenka. Isu nga inkeddengmi a masapul nga adda kari iti nagbaetantayo, wen, iti nagbaetantayo. Isu a mangaramidtayo iti katulagan, ");
INSERT INTO iloulb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","a saannakaminto a dangran, a kas iti saanmi a panangdangran kenka, ken kas iti panangtratomi kenka iti nasayaat ken pinapanawdaka nga addaan kapia. Pudno, binendisionannaka ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Nangisagana ngarud ni Isaac iti padaya para kadakuada, ket nangan ken imminumda. ");
INSERT INTO iloulb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bimmangonda a nasapa iti bigbigat ket nagsapatada iti kari iti tunggal maysa. Kalpasanna, pinalubosan ida ni Isaac a pumanaw, ket pinanawanda isuna nga addaan kapia. ");
INSERT INTO iloulb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Iti dayta met laeng nga aldaw, dimteng dagiti adipen ni Isaac ket imbagada kenkuana ti maipanggep iti bubon a kinalida. Kinunada, “Adda nasarakanmi a danum.” ");
INSERT INTO iloulb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Pinanagananna ti bubon iti Seba, isu a ti nagan dayta a siudad ket Beerseba agingga kadagitoy nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Idi agtawen ni Esau iti uppat a pulo, inasawana ni Judit a putot a babai ni Beeri a Heteo, kasta met ni Basemat a putot a babai ni Elon a Heteo. ");
INSERT INTO iloulb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ket ladingit ti impapaayda kada Isaac ken Rebecca. ");
INSERT INTO iloulb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Idi lakayen ni Isaac ket nakudrepen dagiti matana isu a saanen a makakita, inayabanna ni Esau, ti inauna nga anakna, ket kinunana kenkuana, “Anakko.” Kinunana kenkuana, “Adtoyak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kinunana, “Kitaem lakayakon. Diak ammo ti aldaw ti ipapatayko. ");
INSERT INTO iloulb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Isu nga alaem dagiti igammo, ti pagikkan dagiti baim kasta met ti panam, ket mapanka iti tay-ak ket iyanupannak. ");
INSERT INTO iloulb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mangisaganaka iti naimas a taraon para kaniak, ti potahe a pagaayatko, ken iyegmo kaniak tapno kanek ket bendisionanka sakbay a matayak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ita, nangngeg ni Rebecca daytoy idi nagsao ni Isaac kenni Esau nga anakna. Napan ni Esau iti tay-ak tapno aganup iti atap nga ayup ket iyawidna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Nagsao ni Rebecca kenni Jacob nga anakna a kinunana, “Kitaem, nanggegko a nagsao ti amam kenni Esau a kabsatmo. ");
INSERT INTO iloulb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Kinunana, ''Iyanupannak ket isaganaannak iti naimas a taraon, tapno kanek ket bendisionanka iti imatang ni Yahweh sakbay iti ipapatayko.' ");
INSERT INTO iloulb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ita ngarud, anakko, tungpalem no ania ti ibilinko kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mapanka iti ayan dagiti arban, ket iyalaannak iti dua a napipintas nga urbon a kalding; ket lutoek dagitoy iti naimas a taraon para ti amam, a kas iti pagaayatna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ipanmonto daytoy iti amam, tapno kanenna, tapno bendisionannaka sakbay ti ipapatayna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kinuna ni Jacob kenni Rebecca nga inana, “Kitaem, ni Esau a kabsatko ket barbonan a lalaki, ken siak ket lalaki nga addaan iti nalamuyot a kudil. ");
INSERT INTO iloulb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nalabit nga arikapennakto ti amak, ket kaslaakto manangallilaw kenkuana. Lunodto ti iyegko iti bagik a saan ket a bendision. ");
INSERT INTO iloulb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kinuna ti inana kenkuana, “Anakko, bay-am nga agtinnag ti aniaman a lunod kaniak. Basta tungpalem ti imbagak, ket mapanmo alaen dagiti imbagak ket iyegmo kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Napan ngarud ni Jacob ket nangala kadagiti urbon a kalding ket impanna dagitoy iti inana, ket nangisagana ni inangna iti naimas a taraon, a kas iti pagaayat ti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Innala ni Rebecca dagiti kapipintasan a pagan-anay ni Esau nga inauna nga anakna, nga adda kenkuana iti uneg ti balay, ket insuotna dagitoy kenni Jacob nga in-inaudi nga anakna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Inkabilna kadagiti ima ni Jacob dagiti lalat dagiti urbon a kalding ken iti nalamuyot a paset ti tenggedna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Inkabil ni Rebecca ti naimas a taraon ken ti tinapay nga insaganana iti ima ti anakna a ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Napan ni Jacob kenni amana ket kinunana, “Amak.” Kinunana, “Adtoyak; siasinoka, anakko?'” ");
INSERT INTO iloulb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kinuna ni Jacob iti amana, “Siak ni Esau nga inauna nga anakmo; inaramidkon kas imbagam kaniak. Ita agtugawka ket manganka iti naanupak, iti kasta ket bendisionannak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kinuna ni Isaac iti anakna, “Kasano a nakabirukka a dagus, anakko? Kinunana, “Gapu ta inyeg kaniak daytoy ni Yahweh a Diosmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kinuna ni Isaac kenni Jacob, “Umasidegka kaniak, tapno maarikapka, anakko, ket ammoek no pudno a sika ti anakko a ni Esau wenno saan.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Immasideg ni Jacob iti amana a ni Isaac; ket inarikap ni Isaac isuna ket kinunana, “Ti timek ket timek ni Jacob, ngem dagiti ima ket dagiti ima ni Esau.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Saan a nailasin ni Isaac isuna, gapu ta dagiti imana ket barbonan, a kas kadagiti ima ti kabsatna a ni Esau, isu a binendisionan isuna ni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kinunana, “Pudno kadi a sika ti anakko a ni Esau?” Ket kinunana, “Siak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kinuna ni Isaac, “Iyegmo ti taraon kaniak, ket manganak iti naanupam, tapno bendisionanka.” Impan ni Jacob ti taraon kenkuana. Nangan ni Isaac, ket nangiyeg pay ni Jacob iti arak, ket imminum isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kalpasanna, kinuna ni Isaac nga amana kenkuana, “Umasidegka itan ket agkannak, anakko.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Immasideg ni Jacob ket inagkanna isuna, ket naangotna ti angot dagiti pagan-anayna ket binendisionanna isuna. Kinunana, “Kitaem, ti ayamuom ti anakko ket kas iti ayamuom ti taltalon a benindisionan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ikkannaka koma ti Dios ti bingaymo kadagiti linnaaw ti langit, bingaymo iti kinadam-eg ti daga, ken nawadwad a bukel ken baro nga arak. ");
INSERT INTO iloulb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Pagserbiannaka koma dagiti tattao ken agdumog koma kenka dagiti pagilian. Iturayam koma dagiti kakabsatmo, ken agdumog koma kenka dagiti annak a lallaki ti inam. Tunggal maysa koma a mangilunod kenka ket mailunod; tunggal maysa koma a mangbendision kenka ket mabendisionan. ");
INSERT INTO iloulb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Apaman a binendisionan ni Isaac ni Jacob, ken kapanpanaw la unay ni Jacob iti imatang ti amana a ni Isaac - isu met ti isasangpet ni Esau a kabsatna manipud iti panaganupna. ");
INSERT INTO iloulb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nagluto met isuna iti naimas a taraon ket impanna daytoy iti amana. Kinunana iti amana, “Ama, bumangonka ket manganka iti naanupan toy anakmo, iti kasta ket bendisionannak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kinuna ni Isaac nga amana kenkuana, “Siasinoka?” Kinunana, “Siak ti anakmo, ti inaunam a ni Esau.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nagpigerger ni Isaac iti kasta unay ket kinunana, “ Siasino ti nanganup iti daytoy ket inyegna kaniak? Kinnanko amin daytoy sakbay nga immayka, ket binendisionakon isuna. Pudno, mabendisionan isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Idi nangngeg ni Esau dagiti sao ti amana, nagsangit isuna iti kasta unay ken nasaem ti panagsangitna, ket kinunana iti amana, “Bendisionannak met, amak.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kinuna ni Isaac, “Immay ditoy ti kabsatmo a nangallilaw ket innalanan ti bendisionmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kinuna ni Esau, “Saan kadi a rebbengna a napanaganan isuna iti Jacob? Ta inallilawnakon iti namindua. Innalana ti karbengak a kas inauna nga anak, ket ita, innalana ti bendisionko.” Ket kinunana pay, “Saanka kadi a nangibati iti bendision para kaniak? ");
INSERT INTO iloulb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Simmungbat ni Isaac a kinunana kenni Esau, “Kitaem, inaramidko isuna a mangituray kenka, ken intedko kenkuana amin a kakabsatna a kas adipenna. Ken inikkak isuna kadagiti bukel ken baro nga arak. Ania pay ngay iti maaramidko para kenka, anakko?” ");
INSERT INTO iloulb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kinuna ni Esau iti amana, “Awan kadin iti uray maysa laeng a bendision para kaniak, amak? Bendisionannak, uray siak met, amak.” Nagsangit iti napigsa ni Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Simmungbat ni Isaac nga amana ket kinunana kenkuana, “Kitaem, ti disso a pagnaedamto ket adayonto manipud iti kinabaknang ti daga, adayo manipud ti linnaaw iti tangatang. ");
INSERT INTO iloulb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Agbiagkanto babaen iti kampilam, ken pagserbiamto ti kabsatmo. Ngem no bumusorka, ikkatemto ti sangolna manipud ti tenggedmo. ");
INSERT INTO iloulb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ginura ni Esau ni Jacob gapu iti bendision nga inted ti amana kenkuana. Imbaga ni Esau iti pusona, “Dagiti al-aldaw a panagladingit para iti amak ket umasidegen; kalpasan dayta, papatayekto ti kabsatko a ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Naidanon kenni Rebecca dagiti sao ti inauna nga anakna a ni Esau. Isu a nangibaon iti mapan mangayab kenni Jacob nga in-inaudi nga anakna ket kinunana kenkuana, “Kitaem, ni kabsatmo nga Esau ket liwliwaenna ti bagina maipanggep kenka babaen iti panagpangpanggepna a mangpapatay kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ita ngarud, anak ko, tungpalennak ket umadayoka nga agturong idiay ayan ni Laban a kabsatko, idiay Haran. ");
INSERT INTO iloulb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Agtalinaedka kenkuana sadiay iti sumagmamano nga aldaw, ");
INSERT INTO iloulb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","inggana a bumaaw ti pungtot ti kabsatmo, aginggana a mapukaw ti unget ti kabsatmo kenka, ket malipatanna ti inaramidmo kenkuana. Kalpasanna, mangibaonakto iti mapan mangisubli kenka ditoy. Apay koma ta mapukawkayo nga agpadpada iti maymaysa nga aldaw? ");
INSERT INTO iloulb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kinuna ni Rebecca kenni Isaac, “Napunnoanakon iti biag gapu kadagiti annak a babbai dagiti Heteo. No mangasawa ni Jacob iti maysa kadagiti annak a babbai dagiti Heteo, kasla kadagitoy a babbai, sumagmamano kadagiti annak a babbai ti daga, ania ngay ti nasayaat a pagbanagan iti biag para kaniak? ");
INSERT INTO iloulb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Inayaban ni Isaac ni Jacob, binendisionanna isuna, ken binilinna isuna, “Masapul a saanka a mangala ti asawam manipud kadagiti Canaaneo a babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tumakderka, mapanka idiay Padan Aram, idiay balay ni Betuel nga ama ti inam, ket mangalaka iti asawam sadiay, maysa kadagiti annak a babbai ni Laban a kabsat ti inam. ");
INSERT INTO iloulb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bendisionannaka koma ti Dios a Mannakabalin-amin, pagbalinennaka a nabunga ken paaduennaka, tapno agbalinka a rineprep ti tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Itedna koma kenka ti bendision ni Abraham, kenka, ken kadagiti kaputotamto, tapno matawidmo ti daga a nagnanaedam nga inted ti Dios kenni Abraham. ");
INSERT INTO iloulb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Imbaon ngarud ni Isaac ni Jacob nga umadayo. Napan ni Jacob idiay Padan Aram, iti ayan ni Laban nga anak ni Betuel nga Arameo, a kabsat ni Rebecca nga ina da Jacob ken Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ita, nakita ni Esau a binendisionan ni Isaac ni Jacob ket imbaonna idiay Padan-aram tapno mangala iti asawana sadiay. Nakitana met a binendisionan ni Isaac isuna ken binilinna a kunana, “Masapul a saanka a mangala iti asawam manipud kadagiti babbai iti Canaan.” ");
INSERT INTO iloulb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nakita met ni Esau a tinungpal ni Jacob ti amana ken ti inana, ket napan idiay Padan-aram. ");
INSERT INTO iloulb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nakita ni Esau a saan a naay-ayo ni Isaac nga amana kadagiti babbai iti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Isu a napan isuna kenni Ismael, ket innalana a kas asawana ni Mahalat a kabsat ni Nebayot a putot ni Ismael, a putot ni Abraham, malaksid kadagiti addan nga assawana. ");
INSERT INTO iloulb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Pimmanaw ni Jacob idiay Beerseba ket nagturong idiay Haran. ");
INSERT INTO iloulb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nakadanun isuna iti maysa a lugar ket nagpatpatnag sadiay, gapu ta limneken ti init. Nangala isuna iti maysa kadagiti bato iti dayta a disso, impunganna daytoy, ket nagidda iti dayta a disso tapno maturog. ");
INSERT INTO iloulb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nagtagtagainep isuna ket nakitana ti maysa nga agdan a nakapasdek iti rabaw ti daga. Nakadanun ti murdongna idiay langit ket ngumato ken bumaba dagiti anghel ti Dios iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Pagammoan, nagtakder ni Yahweh iti ngatoen daytoy ket kinunana, “Siak ni Yahweh a Dios ni Abraham nga amam, ken ti Dios ni Isaac. Itedkonto kenka ken kadagiti kaputotam ti daga a pagid-iddaam. ");
INSERT INTO iloulb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kaslanto tapok iti daga dagiti kaputotam, ket agwaraskayto iti adayo; iti laud, iti daya, iti amianan ken iti abagatan. Kenka ken kadagiti kaputotam ket mabendisionanto dagiti amin a pamilia iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kitaem, addaak kenka, ket aywanankanto iti sadinoman a papanam. Iyegkanto manen iti daytoy a daga; ta saankanto a panawan. Aramidekto amin nga inkarik kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Nakariing ni Jacob iti pannaturogna, ket kinunana, “Awan duadua nga adda ditoy a disso ni Yahweh, ket saanko a napanunot dayta.” ");
INSERT INTO iloulb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nagbuteng isuna ket kinunana, “Anian a nakabutbuteng daytoy a disso! Daytoy ket awanen sabali no di ti balay ti Dios. Daytoy ti ruangan ti langit.” ");
INSERT INTO iloulb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nagriing ni Jacob iti nasapa ket innalana ti bato a nagpungananna. Impasdekna a kas adigi ket binukbukanna iti lana ti rabaw daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Pinanagananna dayta a lugar iti Betel, ngem ti sigud a nagan dayta a siudad ket Luz. ");
INSERT INTO iloulb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nagsapata ni Jacob a kunana, “No kaduaannak ti Dios ken salaknibannak iti daytoy a dalan a pagpagnaak, ken ikkannak iti tinapay a kanek, ken pagan-anay nga ikawesko, ");
INSERT INTO iloulb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","iti kasta ket makasangpetak a sitatalged idiay balay ni amak, ni Yahweh ti agbalinto a Diosko. ");
INSERT INTO iloulb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ket daytoy a bato nga impasdekko a kas adigi ket agbalinto a nasagradoan a bato. Manipud iti tunggal banag nga itedmo kaniak, sigurado nga isublikto kenka ti apagkapullo.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ket intuloy ni Jacob ti panagdaliasatna ket nakadanun iti daga dagiti tattao iti daya. ");
INSERT INTO iloulb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Idi kimmita isuna, nakakita iti bubon iti tay-ak, ket adda nakitana a tallo nga arban dagiti karnero nga agid-idda iti abay ti bubon. Ta manipud iti dayta a bubon ket painumenda dagiti arban, ket dakkel ti bato nga adda iti sungaban ti bubon. ");
INSERT INTO iloulb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","No kasta naurnongen dagiti amin nga arban sadiay, itulid dagiti agpaspastor ti bato manipud iti sungaban ti bubon ket painumenda dagiti karnero, ket ikabilda manen ti bato iti sungaban ti bubon, a sigud nga ayanna. ");
INSERT INTO iloulb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kinuna ni Jacob kadakuada, “Kakabsatko, taga-anokayo?” Ket kinunada, “Taga-Harankami.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kinunana kadakuada, “Am-ammoyo kadi ni Laban nga anak ni Nahor?” Kinunada, “Am-ammomi isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kinunana kadakuada, “Nasayaat kadi ti kasasaadna?” Kinunada, “Nasayaat ti kasasaadna, ken, kumitaka sadiay, um-umay ni Raquel nga anakna agraman dagiti karnero.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kinuna ni Jacob, “Kitaenyo, tengnga ti aldaw tatta. Saan pay a daytoy ti umno nga oras a maurnong dagiti arban. Masapul a painumenyo dagiti karnero ket kalpasanna, mapankayo ket bay-anyo ida nga agarab.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kinunada, “Saanmi a mabalin a painumen dagiti karnero agingga a saan pay a naurnong amin dagitoy. Ket itulidto dagiti lallaki ti bato manipud iti sungaban ti bubon, ket painumenminto dagiti karnero.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kabayatan a makisarsarita pay laeng ni Jacob kadakuada, dimteng ni Raquel agraman dagiti karnero ni tatangna, ta ipaspastorna dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Idi nakita ni Jacob ni Raquel a putot a babai ni Laban a kabsat ti inana, ken dagiti karnero ni Laban, immasideg ni Jacob, intulidna ti bato manipud iti sungaban ti bubon ket pinainumna dagiti arban ni Laban a kabsat ti inana. ");
INSERT INTO iloulb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Inagkan ni Jacob ni Raquel ket nagsangit iti napigsa. ");
INSERT INTO iloulb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Imbaga ni Jacob kenni Raquel a kabagian isuna ti amana, ken isuna ket anak ni Rebecca. Kalpasanna, nagtaray ni Raquel ket napanna imbaga kenni tatangna. ");
INSERT INTO iloulb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Idi nangngeg ni Laban ti damag maipanggep kenni Jacob nga anak ti kabsatna a babai, nagtaray isuna a nangsabat kenkuana, inarakupna, inagkanna, ken inkuyogna iti balayna. Imbaga ni Jacob kenni Laban amin dagitoy a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kinuna ni Laban kenkuana, “Pudno a sika ket tulang ken lasagko.” Ket nakipagnaed ni Jacob kenkuana iti agarup maysa a bulan. ");
INSERT INTO iloulb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kalpasanna, kinuna ni Laban kenni Jacob, “Gapu ta kabagianka, rumbeng kadi nga agserbika kaniak nga awan aniamanna? Ibagam kaniak, ania ti kayatmo nga itedko kas tangdanmo?” ");
INSERT INTO iloulb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ita, addaan ni Laban iti dua a putot a babbai. Ti nagan ti inauna ket Lea, ken ti nagan ti inaudi ket Raquel. ");
INSERT INTO iloulb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Napungay dagiti mata ni Lea, ngem napintas ti pammagi ken langa ni Raquel. ");
INSERT INTO iloulb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Inayat ni Jacob ni Raquel, isu a kinunana, “Agserbiak kenka iti pito a tawen para kenni Raquel, nga inaudi nga anakmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kinuna ni Laban, “Nasaysayaat nga itedko isuna kenka, ngem ti itedko isuna iti sabali a lalaki. Makipagnaedka kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Isu a nagserbi ni Jacob iti pito a tawen para kenni Raquel; ket kasla bassit laeng nga aldaw dagitoy kenkuana, gapu iti ayatna para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kalpasanna ket kinuna ni Jacob kenni Laban, “Itedmo kaniak ti asawak, ta naan-anayen dagiti aldawko - iti kasta ket maasawak isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Inummong ngarud ni Laban dagiti amin a tattao iti dayta a lugar ket nagpadaya. ");
INSERT INTO iloulb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Iti rabii, innala ni Laban ni Lea a putotna ket impanna kenni Jacob ket kinaiddana daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Inted met ni Laban ni Zilpa nga adipenna a babai kenni Lea a putotna nga agbalin nga adipen ni Lea. ");
INSERT INTO iloulb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Iti agsapa, ni Lea met gayam ti adda! Kinuna ni Jacob kenni Laban, “Ania daytoy nga inaramidmo kaniak? Saan kadi a nagserbiak kenka para kenni Raquel? Apay ngarud nga inallilawnak?” ");
INSERT INTO iloulb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kinuna ni Laban, “Saanmi a kaugalian nga ited ti inaudi nga anak a babai sakbay ti inauna. ");
INSERT INTO iloulb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Palpasem ti makalawas a rambak ti kasar para iti daytoy nga anakko, ket itedminto met kenka ti maysa pay kas kasukat ti panagserbim kaniak iti pito pay a tawen.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kasta ngarud ti inaramid ni Jacob, ket lineppasna ti makalawas a rambak para kenni Lea. Kalpasanna, inted ni Laban kenni Jacob ni Raquel a putotna kas maysa pay nga asawa daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Inted met ni Laban ni Bilha nga adipenna a babai kenni Raquel tapno agbalin nga adipenna. ");
INSERT INTO iloulb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Isu nga inasawa met ni Jacob ni Raquel, ngem ad-adda nga inayatna ni Raquel ngem ni Lea. Nagserbi ngarud ni Jacob kenni Laban iti pito pay a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nakita ni Yahweh a saan nga inayat ni Jacob ni Lea, isu a pinagsikogna daytoy, ngem ni Raquel ket awanan iti anak. ");
INSERT INTO iloulb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nagsikog ni Lea ket naganak iti maysa a lalaki, ket pinanagananna iti Ruben. Ta kinunana, “Gapu ta nakita ni Yahweh ti panagsagabak; ita, ayatennakon ti asawak.” ");
INSERT INTO iloulb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kalpasanna, nagsikog manen isuna ket naganak iti lalaki. Kinunana, “Gapu ta nangngeg ni Yahweh a saannak nga inayat ti asawak, intedna pay ngarud kaniak daytoy nga anak a lalaki,” ket pinanagananna iti Simeon. ");
INSERT INTO iloulb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kalpasanna, nagsikog manen ket naganak iti lalaki. Kinunana, “Ita, maisinggalut kaniakon ti asawak, gapu ta tallon a lallaki ti annakmi.” Isu a pinanagananna daytoy iti Levi. ");
INSERT INTO iloulb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nagsikog manen isuna ket naganak iti lalaki. Kinunana, “Ita, idaydayawko ni Yahweh.” Isu a pinanagananna iti Juda; kalpasanna simmardengen isuna nga aganak. ");
INSERT INTO iloulb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Idi nakita ni Raquel a saanna a maipaayan ni Jacob iti annak, inapalanna ti kabsatna. Kinunana kenni Jacob, “Ikkannak kadagiti annak, ta no saan ket matayak.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nakaunget ni Jacob kenni Raquel. Kinunana, “Addaak kadi iti lugar ti Dios a manglaplapped kenka a maaddaan kadagiti annak?” ");
INSERT INTO iloulb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kinunana, “Kitaem, daydiay ni Bilha nga adipenko. Makikaiddaka kenkuana, ta bareng no makaanak para kaniak, ket maaddaanakto kadagiti annak babaen kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Inted ngarud ni Raquel kenni Jacob ni Bilha nga adipenna kas maysa nga asawa, ket nakikaidda ni Jacob kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nagsikog ni Bilha ket naganak iti lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ket kinuna ni Raquel, “Dinengngegnak ti Dios. Pudno a nangngegna ti timekko ket inikkannak iti anak a lalaki.” Isu a pinanagananna daytoy iti Dan. ");
INSERT INTO iloulb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Nagsikog manen ni Bilha nga adipen ni Raquel ket naganak iti maikadua a lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kinuna ni Raquel, “Sipipinget a pannakigabbo ti pannakigabbok iti kabsatko ket nangabakak.” Pinanagananna daytoy iti Neftali. ");
INSERT INTO iloulb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Idi nakita ni Lea a nagsardengen isuna a maaddaan kadagiti annak, innalana ni Zilpa, nga adipenna, ket intedna kenni Jacob kas asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Naganak ni Zilpa nga adipen ni Lea iti lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Kinuna ni Lea, “Kinagasat daytoy!” isu a pinanagananna daytoy iti Gad. ");
INSERT INTO iloulb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kalpasanna, naganak ni Zilpa nga adipen ni Lea iti maikadua a lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kinuna ni Lea, “Naragsakak! Ta awagandakto dagiti annak a babbai iti naragsak.” Isu a pinanagananna iti Aser. ");
INSERT INTO iloulb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kadagiti aldaw ti panagapit iti trigo, napan ni Ruben iti talon ket nakasarak kadagiti mandragoras. Insangpetna dagitoy kenni nanangna a Lea. Ket kinuna ni Raquel kenni Lea, “Ikkannak iti sumagmamano kadagiti mandragoras ti anakmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kinuna ni Lea kenkuana, “Bassit laeng kadi a banag kenka, nga innalam ti asawak? Ita, kayatmo pay nga alaen dagiti mandragoras ti anakko?” Kinuna ni Raquel, “No kasta, makikaidda kenka ni Jacob inton rabii, kas kasukat dagiti mandragoras ti anakmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Simmangpet ni Jacob manipud iti talon iti rabii. Rimmuar ni Lea tapno sabtenna isuna ket kinunana, “Masapul a makikaiddaka kaniak ita a rabii, ta inabanganka babaen kadagiti mandragoras ti anakko.” Isu a nakikaidda ni Jacob kenni Lea iti dayta a rabii. ");
INSERT INTO iloulb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dinengngeg ti Dios ni Lea, ket nagsikog ken naganak iti maikalima a lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kinuna ni Lea, “Inikkannak ti Dios iti tangdanko, gapu ta intedko ti adipenko a babai iti asawak.” Pinanagananna daytoy iti Issacar. ");
INSERT INTO iloulb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nagsikog manen ni Lea ket naganak iti maika-innem a lalaki para kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kinuna ni Lea, “Inikkannak ti Dios iti nasayaat a sagut. Raemennakon ita ti asawak, gapu ta naganakak iti innem a lallaki para kenkuana.” Pinanagananna daytoy iti Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kalpasanna, naganak iti babai ket pinanagananna iti Dina. ");
INSERT INTO iloulb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Linagip ti Dios ni Raquel ket dinengngegna isuna. Pinagsikogna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nagsikog ket naganak iti lalaki. Kinunana, “Inikkat ti Dios ti pannakaibabainko.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Pinanagananna daytoy iti Jose, a kunana, “Innayon ni Yahweh kaniak ti maysa pay nga anak a lalaki.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kalpasan nga inyanak ni Raquel ni Jose, kinuna ni Jacob kenni Laban, “Ipalubosmo koma a pumanawak, tapno makaapanak iti bukodko a pagtaengan ken iti pagiliak. ");
INSERT INTO iloulb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Itedmo kaniak dagiti assawak ken dagiti annakko a gapuanan ti panagserbik kenka, ket palubosannak a pumanaw, ta ammom ti panagserbi nga impaayko kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kinuna ni Laban kenkuana, “No ita ket nakabirokak iti pabor kadagita matam, aguray, gapu ta natakkuatak a binendisionannak ti Dios gapu kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ket kinunana, “Naganam dagiti tangdanmo, ket bayadak dagitoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kinuna ni Jacob kenkuana, “Ammom no kasano iti pinagserbik kenka, ken no kasano nga immadu dagiti arbanmo kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ta addaanka laeng iti bassit sakbay nga immayak, ket immadu dagitoy iti kasta unay. Binendisionannaka ti Dios iti sadinoman a nagtrabahoak. Ita, kaanoakto ngay met a mangisabet para iti bukodko a pagtaengan?” ");
INSERT INTO iloulb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Isu a kinuna ni Laban, “Ania ti ibayadko kenka?” Kinuna ni Jacob, “Saannak nga ikkan iti aniaman. No aramidem daytoy a banag para kaniak, pakanek manen dagiti arbanmo ken aywanak dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Palubosannak koma laeng a mapan kadagiti amin nga arbanmo ita nga aldaw, ket ikkatek dagiti turikturikan ken labang a karnero, ken tunggal nangisit kadagiti karnero, ken dagiti labang ken turikturikan kadagiti kalding. Dagitoyto dagiti tangdanko.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ti kinapudnok ti mangpaneknekto kaniak iti masakbayan, inton umayka a mangsukimat kadagiti tangdanko. Tunggal maysa a saan a turikturikan ken labang kadagiti kalding, ken nangisit kadagiti karnero, no addaman ti masarakam kaniak, ket maibilangto a natakaw.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kinuna ni Laban, “Umanamongak. Maaramid koma ngarud, kas iti sinaom.” ");
INSERT INTO iloulb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Iti dayta nga aldaw, inikkat ni Laban dagiti amin a kalakian a kalding a garitan ken labang, ken amin a kabaian a kalding a turikturikan ken labang, amin nga adda purawna, ken amin a nangisit kadagiti karnero, ket impaimana kadagiti annakna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nangikabil met ni Laban iti tallo nga aldaw a panagdaliasat iti nagbaetanda kenni Jacob. Intuloy ngarud ni Jacob nga inay-aywanan dagiti nabati kadagiti arban ni Laban. ");
INSERT INTO iloulb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nangala ni Jacob kadagiti kaputputed a sanga dagiti alamo, ken kadagiti almendras ken kadagiti kastanio a kayo, sana inikkat ti dadduma nga ukisda tapno kasla garitan ti langada. ");
INSERT INTO iloulb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Kalpasanna, inkabilna dagiti sanga nga inukisanna iti sango dagiti arban, iti sango ti kahon a pagkargaan iti danum a pagin-inumanda. Agtitinnakbada no kasta nga umayda uminum. ");
INSERT INTO iloulb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Agtitinnakba dagiti ayup iti sango dagiti sanga, ket naganak dagiti arban iti garitan, turikturikan, ken labang nga urbon. ");
INSERT INTO iloulb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Insina ni Jacob dagiti kabaian a karnero ket inturongna dagiti rupada kadagiti garitan nga ayup ken amin a nangisit a karnero iti arban ni Laban. Ket insinana dagiti arbanna ken saanna nga inlaok kadagiti arban ni Laban. ");
INSERT INTO iloulb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tunggal agmaya dagiti napipigsa a karnero iti arban, ikabil ni Jacob dagiti sanga iti pagin-inumanda iti sangoanan dagiti arban, tapno agtitinnakbada iti ayan dagiti sanga. ");
INSERT INTO iloulb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ngem no kasta nga umay dagiti nakakapsut nga ayup iti arban, saanna nga ikabil dagiti sanga iti sangoananda. Kukua ngarud ni Laban dagiti nakakapsut nga ayup, ket kukua ni Jacob dagiti napipigsa nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Rimmang-ay iti kasta unay ti lalaki. Addaan isuna kadagiti adu nga arban, adipen a babbai ken adipen a lallaki, ken kadagiti kamelio ken asno. ");
INSERT INTO iloulb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ita, nangngeg ni Jacob dagiti sasao dagiti annak a lallaki ni Laban a kinunada, “Innala ni Jacob dagiti amin a kukua ti Amatayo, ken kadagiti sanikua ti amatayo ti nagappuan amin dagitoy a kinabaknangna. ");
INSERT INTO iloulb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nakita ni Jacob ti langa ti rupa ni Laban. Nakitana a nagbaliwen ti panakilangen-langenna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ket kinuna ni Yahweh kenni Jacob, “Agsublika iti daga dagiti ammam ken kadagiti kakabagiam, ket addaakto kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nangibaon ni Jacob iti napan nangayab kada Raquel ken Lea tapno mapanda iti kataltalonan, iti ayan dagiti arbanna ");
INSERT INTO iloulb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ket kinunana kadakuada, “Nakitak a nagbaliwen ti panakilangen-langen ti amayo kaniak, ngem ti Dios ti amak ket kanayon nga adda kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ammoyo a nagserbiak iti amayo iti amin a pigsak. ");
INSERT INTO iloulb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Inallilawnak ti amayo ken binaliwanna ti tangdanko iti naminsangapulo a daras, ngem saan nga impalubos ti Dios a dangrannak. ");
INSERT INTO iloulb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","No ibagana a, 'Dagiti burik nga ayup ti tangdanmo', aganak met iti burik nga urbon ti amin nga arban. Ket no ibagana, 'Dagiti garit nga ayup ti tangdanmo', aganak met iti garit nga urbon ti amin nga arban. ");
INSERT INTO iloulb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Iti kastoy a wagas, innala ti Dios dagiti taraken ti amayo ket intedna dagitoy kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Iti naminsan, idi panawen iti panagmamaya, nakitak iti tagtagainep dagiti kalakian a kalding a mangmaymaya iti arban. Dagiti kalakian a kalding ket garit, burik ken labang. ");
INSERT INTO iloulb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Imbaga ti anghel ti Dios kaniak iti tagtagainep, 'Jacob'. Kinunak, 'Adtoyak.' ");
INSERT INTO iloulb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kinunana, 'Kumitaka iti ngato ket kitaem dagiti amin a kalakian a kalding a mangmaymaya iti arban. Dagitoy ket garit, burik ken labang, ta nakitak ti amin nga ar-aramiden ni Laban kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Siak ti Dios ti Bethel, a nangpulutam iti maysa nga adigi, a nangsapataam kaniak iti maysa a kari. Ita, panawam daytoy a daga ket agsublika iti daga a nakaiyanakam.'” ");
INSERT INTO iloulb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Simmungbat da Raquel ken Lea a kinunada kenkuana, “Adda kadi met bingay wenno tawid a para kadakami iti balay ti amami? ");
INSERT INTO iloulb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Saan aya a kasla gangannaet iti panangtrato ti amami kadakami? Ta inlakonakami ket inibusna amin a kuartami. ");
INSERT INTO iloulb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ta amin a kinabaknang nga innala ti Dios manipud iti amami ket kukuamin ita ken dagiti annakmi. Ita ngarud, aniaman nga ibaga ti Dios kenka, aramidem.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ket timmakder ni Jacob ken inkabilna dagiti annakna a lallaki ken assawana kadagiti kamelio. ");
INSERT INTO iloulb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Rinugianna nga abugen dagiti amin a tarakenna ken amin a sanikuana a naalana, dagiti tarakenna a nagun-odna idiay Paddan Aram. Rinugianna ti mapan iti ayan ti amana a ni Isaac, iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ita, pimmanaw ni Laban tapno mapanna pukisan dagiti karnerona, ket tinakaw ni Raquel dagiti didiosen nga adda iti balay ti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Sinikapan met ni Jacob ni Laban nga Arameo iti saanna a panangibaga kenkuana a pumanawen isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nagtalaw ngarud a kaduana dagiti amin a sanikuana ket nagdardaras a bimmallasiw iti Karayan, ken nagturong iti katurturodan a pagilian ti Galaad. ");
INSERT INTO iloulb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Iti maikatlo nga aldaw, naibaga kenni Laban a nagtalawen ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Isu nga inkuyogna dagiti amin a kakabagianna ket kinamatda ni Jacob iti pito nga aldaw a panagdaliasat. Nakamakamda isuna iti katurturodan ti Gilead. ");
INSERT INTO iloulb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ita, immay ti Dios kenni Laban nga Arameo iti maysa a tagtagainep iti maysa a rabii ket kinunana kenkuana, “Agannadka a makisarita kenni Jacob iti nasayaat man wenno dakes.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Nakamakam ni Laban ni Jacob. Ita, nangipatakder ni Jacob iti toldana iti katurturodan a pagilian. Nagkampo met laeng da Laban ken dagiti kakabaggianna iti katurturodan a pagilian ti Galaad. ");
INSERT INTO iloulb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kinuna ni Laban kenni Jacob, “Ania daytoy nga inaramid mo, ta inallilawnak ken innalam dagiti annakko a babbai a kasla da la balud iti gubat? ");
INSERT INTO iloulb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Apay a pimmanawka a sililimed ken sinikapannak ken saanmo nga imbaga kaniak. Pinarubuatankayo koma nga addaan iti panagrambak ken kankanta, kadagiti tamborin ken kadagiti arpa. ");
INSERT INTO iloulb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Saanmo nga intulok nga agkak iti panagpakada dagiti appok ken annakko. Ita, nakaaramidka iti minamaag. ");
INSERT INTO iloulb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Addaanak iti kabaelan a mangdangran kenka, ngem nagsao kaniak ti Dios ti amam idi rabii a kinunana, 'Aggannadka a makisarita kenni Jacob iti nasaayaat man wenno saan'. ");
INSERT INTO iloulb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ket ita, pimmanawka gapu ta mailiwka unay iti balay ti amam. Ngem apay a tinakawmo dagiti diosko?” ");
INSERT INTO iloulb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Simmungbat ni Jacob a kinunana kenni Laban, “Gapu ta mabutengak ken impagarupko nga amangan no pilitem nga alaen dagiti annakmo manipud kaniak, pimmanawak a sililimed. ");
INSERT INTO iloulb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Siasinoman a nangtakaw kadagiti didiosem ket saanto nga agtuloy nga agbiag. Iti imatang dagiti kakabaggianta, lasinem ti aniaman nga adda kaniak a kukuam ket alaem.” Ta saan nga ammo ni Jacob a ni Raquel ti nangtakaw kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Napan ni Laban iti ayan ti tolda ni Jacob, iti tolda ni Lea ken iti tolda dagiti dua nga adipen a babbai, ngem saanna a nabirukan dagitoy. Rimuar isuna iti tolda ni Lea ket simrek iti tolda ni Raquel. ");
INSERT INTO iloulb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ita, innala ni Raquel dagiti didiosen iti balay ti amana, inkabilna iti silya ti kamelyo ket tinugawanna daytoy. Sinukimat ni Laban ti uneg ti sibubukel a tolda, ngem saanna a nasarakan dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kinuna ni Raquel iti amana, “Apok, saanka koma a makaunget no saanak a makatakder iti sangngoanam, madama ngamin ti binulanko. Nagsukimat ngarud ni Laban ngem saanna a nasarakan dagiti didiosen iti balayna. ");
INSERT INTO iloulb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nakaunget ni Jacob ket nakisinnupiat isuna kenni Laban. Kinunana kenkuana, “Ania ti naglabsingak? Ania ti nakabasolak, ta sipupungtotka a nangkamat kaniak? ");
INSERT INTO iloulb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ta sinukitmatmo amin a sanikuak. Ania ti nasarakam kadagiti amin a sanikua ti bumalaymo? Ikabilmo ida ditoy sangngoanan dagiti kakabagianta, tapno isuda iti mangukom kadata a dua. ");
INSERT INTO iloulb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Addaak kenka iti duapulo a tawen. Awan ti naalisan kadagiti kaba-ian a karnero ken kaldingmo, ken saanak a nangan iti aniaman a kalakian a karnero manipud kadagiti arbanmo. ");
INSERT INTO iloulb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Aniaman a rinangrangkay dagiti atap nga ayup ket saanko nga inyeg kenka. Ngem ketdi, inakok ti pannakapukawna dayta. Kankanayonmo nga ipabayad kaniak ti tunggal ayup a mapukpukaw, natakaw man iti aldaw wenno iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Addaak sadiay; main-initan iti aldaw, ken malamlammiisan iti rabii; ket napnapanak nga awan turogko. ");
INSERT INTO iloulb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Iti naglabas a duapulo a tawen, addaak iti balay mo. Nagtrabahoak kenka iti sangapulo ket uppat a tawen para kadagiti dua nga annakmo ken innem a tawen para iti arbanmo. Binaliwam ti tangdanko iti namin sangapulo a daras. ");
INSERT INTO iloulb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","No awan kaniak ti Dios ti amak, ti Dios ni Abraham, ken ti pagbutbutngan ni Isaac, awan duadua nga ita ket pinapanawnak nga ima-ima. Nakita ti Dios ti pannakaidadanesko ken ti panagrigatko a nagtrabtrabaho, isu a tinubngarnaka idi rabii.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Simmungbat ni Laban kenni Jacob a kinunana, “Dagiti annak a babbai ket putotko, ken dagiti appo ket appokok, ken dagiti arban ket arbanko. Amin a makitkitam ket kukuak. Ngem ania ngay ti maaramidak ita kadagitoy nga annakko a babbai, wenno kadagiti ubbing nga inyanakda? ");
INSERT INTO iloulb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ita ngarud, agaramidta iti katulagan, data a dua, ket agserbi koma a saksi iti nagbaetanta.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nangala ngarud ni Jacob iti bato ken impatakderna a kasla adigi. ");
INSERT INTO iloulb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Kinuna ni Jacob kadagiti kakabagianna, “Agurnongkayo iti bato.” Nagalada garud kadagiti batbato ket nagaramidda iti bunton. Kalpasanna, nanganda iti abay iti bunton. ");
INSERT INTO iloulb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Inawagan ni Laban daytoy iti Jegar Saha Dutha, ngem inawagan ni Jacob daytoy iti Galeed. ");
INSERT INTO iloulb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kinuna ni Laban, “Daytoy a bunton ket saksi iti nagbaetanta ita nga aldaw.” Ngarud ti naganna ket naawagan iti Galeed. ");
INSERT INTO iloulb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Naawagan met laeng daytoy a Mizpah, gapu ta kinuna ni Laban, “Ni Yahweh koma ti mangbantay kadata, inton saanta a makitkita ti maysa ken maysa. ");
INSERT INTO iloulb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","No tratoem iti saan a nasayaat dagiti putotko a babbai, wenno no mangala ka iti sabali nga asawa malaksid kadagiti putotko, uray no awan sabali a kaduata, kitaem, ti Dios ti saksi iti nagbaetanta.” ");
INSERT INTO iloulb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kinuna ni Laban kenni Jacob, “Kitaem daytoy a bunton, ken kitaem ti adigi nga impatakderko iti nagbaetanta. ");
INSERT INTO iloulb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Daytoy a bunton ket saksi, ken ti adigi ket saksi a saanakto a lumabes kenka iti daytoy a bunton ken saanka a lumabes kaniak iti daytoy a bunton ken daytoy nga adigi, tapno agaramid iti pakadangran. ");
INSERT INTO iloulb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ti Dios koma ni Abraham, ken ti Dios ni Nahor, ti Dios dagiti ama da, ti mangukom kadata. Nagsapata ni Jacob iti nagan ti Dios, kenkuana a pagbutbutngan ti amana a ni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nangidaton ni Jacob iti daton iti dayta a bantay ket inayabanna dagiti kakabagianna a mangan. Nanganda ken pinalabasda ti rabii iti bantay. ");
INSERT INTO iloulb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nariing ni Laban a nasapa iti kabigatanna, inagkanna dagiti appokona ken dagiti putotna a babbai ket binendisionanna ida. Kalpasanna, pimmanaw ni Laban ket nagsubli iti pagtaenganna. ");
INSERT INTO iloulb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Intuloy met ni Jacob ti panagdaliasatna, ket sinabat isuna dagiti anghel ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Idi nakita ida ni Jacob, kinunana, “Daytoy ket kampo ti Dios”, isu nga inawaganna dayta a lugar iti Mahanaim. ");
INSERT INTO iloulb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nangibaon ni Jacob kadagiti mensahero nga umun-una ngem isuna a mapan iti kabsatna a ni Esau, iti daga ti Seir, iti rehion ti Edom. ");
INSERT INTO iloulb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Binilinna ida, a kunana, “Kastoy ti ibagayo iti apok a ni Esau: Kastoy ti kuna ti adipenmo a ni Jacob: 'Nakipagnanaedak kenni Laban, ket nagtalinaedak a nakipagnanaed aginggana ita. ");
INSERT INTO iloulb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Addaanak kadagiti baka, asno, ken arban, lallaki nga adipen, ken babbai nga adipen. Nangibaonak tapno maibaga daytoy iti apok, tapno makasarakak koma iti pabor iti imatangmo.”' ");
INSERT INTO iloulb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nagsubli dagiti mensahero kenni Jacob ket kinunada, “Napankami iti kabsatmo a ni Esau. Umaynaka sabten, ket adda kaduana nga uppat a gasut a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ket nagbuteng ken nariribukan ni Jacob ti kasta unay. Isu a biningayna dagiti tattao a kaduana iti dua a kampo, ken kasta met dagiti arban ti karnero ken kalding, baka, ken dagiti kamelyo. ");
INSERT INTO iloulb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kinunana, “No umay ni Esau iti maysa kadagiti kampo ket darupenna daytoy, aglibasto ti maysa a kampo.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kinuna ni Jacob, “Dios ti amak a ni Abraham, ken Dios ti amak a ni Isaac, Yahweh, a nagkuna kaniak, 'Agsublika iti pagiliam ken kadagiti kakabagiam, ket parang-ayenkanto,' ");
INSERT INTO iloulb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Saanak a maikari iti amin nga aramidmo a nangipakita iti kinapudnom iti katulagan ken iti amin a kinamatalek nga inaramidmo para iti adipenmo. Ta sarukod laeng ti awitko idi bimmallasiwak iti daytoy a Jordan, ket ita nagbalinakon a dua a kampo. ");
INSERT INTO iloulb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Pangnga-asim ta ispalennak manipud iti ima ti kabsatko, manipud iti ima ni Esau, ta mabutengak kenkuana, nga umay isuna ket darupennak ken dagiti inna a kadua dagiti ubbing. ");
INSERT INTO iloulb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ngem kinunam, 'Pudno a parang-ayenkanto. Pagbalinekto dagiti kaputotam a kasla darat iti baybay, a saan a mabilang iti kinaaduda.”' ");
INSERT INTO iloulb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nagtalinaed ni Jacob sadiay iti dayta a rabii. Nangala isuna iti sumagmamano kadagiti adda kenkuana a kas sagut a maipaay kenni Esau, a kabsatna: ");
INSERT INTO iloulb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","dua gasut a kabaian a kalding ken duapulo a kalakian a kalding, dua gasut a kabaian a karnero ken duapulo a kalakian a karnero, ");
INSERT INTO iloulb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tallopulo nga agpagpagatas a kamelio ken dagiti urbonda, uppat a pulo a kabaian a baka ken sangapulo a kalakian a baka, duapulo a kabaian nga asno ken sangapulo a kalakian nga asno. ");
INSERT INTO iloulb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Impaaywanna dagitoy kadagiti adipenna, maysa nga arban iti tunggal adipen. Kinunana kadagiti adipenna, “Umunakayo kaniak ket ikkanyo iti pagbaetan ti tunggal arban.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Binilinna ti umuna nga adipen, a kunana, “Inton masabatnaka ni Esau a kabsatko ken agsaludsod kenka, a kunana, 'Siasino ti nakaibilangam? Sadino ti papanam? Ken siasino ti makinkukua kadagitoy nga ayup iti sangoanam?' ");
INSERT INTO iloulb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ket ibagamto a, 'Dagitoy ket kukua ti adipenmo a ni Jacob. Dagitoy ket sagut a naipatulod para iti apok a ni Esau. Ket makitamto, sumarsaruno isuna kadakami,'” ");
INSERT INTO iloulb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Binilin ni Jacob ti maikadua a bunggoy, ti maikatlo, ken dagiti amin a tattao a mangsarsaruno kadagiti arban. Kinunana, “Ibagayo ti isu met laeng a banag kenni Esau inton makitayo isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ibagayo met a, “Sumarsaruno kadakami ti adipenmo a ni Jacob.'” Ta pinanunotna nga, “Ay-ayoek isuna babaen kadagiti sagut nga ummun-una kaniak. Inton makitak isuna, barbareng no awatennakto.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Isu nga immuna a napan dagiti sagut ngem isuna. Nagtalinaed isuna iti dayta a rabii iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bimmangon ni Jacob iti dayta a rabii, ket inkuyogna dagiti dua nga assawana, dagiti dua a babai nga adipenna, ken dagiti sangapulo ket maysa a putotna a lallaki. Imbaonna ida iti ballasiw ti waig ti Jabbok. ");
INSERT INTO iloulb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Iti kastoy a wagas, imbaonna ida iti ballasiw ti waig kasta met dagiti amin a sanikuana. ");
INSERT INTO iloulb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nabati nga agmaymaysa ni Jacob, ket maysa a lalaki ti nakigabbo kenkuana inggana iti panagsingising ti init. ");
INSERT INTO iloulb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Idi nakita ti lalaki a saanna a maabak isuna, dinapigna ti patong ni Jacob. Naglagisi ti patong ni Jacob kabayatan a makigabgabbo isuna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kinuna ti lalaki, “Palubosannakon, ta sumingsingisingen ti init.” Kinuna ni Jacob, “Saanka a palubosan malaksid no bendisionannak.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kinuna ti lalaki kenkuana, “Ania iti naganmo? Simmungbat ni Jacob, “Jacob.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kinuna ti lalaki, “Ti naganmo ket saanen a Jacob, no di ket Israel. Ta nakibinnalubalka iti Dios ken kadagiti tattao ket nangabakka.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Sinaludsod ni Jacob kenkuana, “Pangngaasim ta ibagam kaniak ti naganmo.” Kinunana, “Apay a salsaludsudem ti naganko?” Ket binendisionanna isuna sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Pinanaganan ni Jacob ti lugar a Peniel ta kinunana, “Nakitak ti Dios iti rupan-rupa, ket naisalakan ti biagko.” ");
INSERT INTO iloulb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Lumgaken ti init idi pumanaw ni Jacob idiay Peniel. Agpilaypilay isuna gapu iti patongna. ");
INSERT INTO iloulb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Dayta ti makagapu no apay nga agingga iti daytoy nga aldaw ket saan a kankanen dagiti tattao ti Israel ti pennet iti patong nga adda iti nagsuopan iti patong, gapu ta dinangran ti lalaki dagidiay a pennet bayat iti panaglagisi ti patong ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Timmangad ni Jacob ket, adtoy, sumungsungad ni Esau, ken kadwana iti 400 a lallaki. Biningay ni Jacob dagiti ubbing kada Lea, Raquel ken kadagiti dua nga adipen a babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ket impasangona dagiti adipen a babbai ken dagiti annakda, simmaruno ni Lea ken dagiti annakna, ken simmaruno ni Raquel kenni Jose a kauddian iti amin. ");
INSERT INTO iloulb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Immun-una isuna ngem kadakuada. Nagpakleb isuna iti naminpito a daras agingga a nakaasideg isuna iti kabsatna. ");
INSERT INTO iloulb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nagtaray ni Esau a simmabat kenkuana, inarakupna, inapungolna iti tengngedna, ken inagkanna isuna. Ket nagsangitda. ");
INSERT INTO iloulb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Idi kimmita ni Esau, nakitana dagiti babbai ken dagiti ubbing. Kinunana, “Siasino dagitoy a tattao a kakuyogmo? Kinuna ni Jacob, “Dagiti annak a sipaparabur nga inted ti Dios iti adipenmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ket nagpasango dagiti adipen a babbai ken dagiti annakda, ket nagrukobda. ");
INSERT INTO iloulb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Simmaruno met a nagpasango ni Lea ken dagiti annakna ket nagrukobda. Kamaudiananna, nagpasango ni Jose ken ni Raquel ket nagrukobda. ");
INSERT INTO iloulb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kinuna ni Esau, “Ania ti kaipapanan amin dagitoy a bunggoy a nasabatko? Kinuna ni Jacob, “Tapno makasarak iti pabor iti imatang ti apok.” ");
INSERT INTO iloulb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kinuna ni Esau, “Umdasen ti adda kaniak, kabsatko. Idulinmo dagiti adda kenka a para kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kinuna ni Jacob, “Saan, pangngaasim, no nakasarakak iti pabor iti imatangmo, awatem ngarud ti sagutko manipud kadagiti imak, ta pudno unay, a nakitak ti rupam, ken daytoy ket kasla pannakakita iti rupa ti Dios, ken inawatnak. ");
INSERT INTO iloulb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Pangngaasim ta awatem ti sagutko a naiyeg kenka, gapu ta pinaraburannak ti Dios, ken gapu ta umdasen ti adda kaniak.” Iti kasta, naguyugoy isuna ni Jacob, ket inawat ni Esau dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ket kinuna ni Esau, “Intayo garuden. Umun-unaak ngem kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kinuna ni Jacob kenkuana, “Ammo ti apok a babassit pay laeng dagiti ubbing, ken addaan iti urbon dagiti arban a kakuyogko. No apuraenda ida iti uray maysa nga aldaw, matayto amin dagiti arban. ");
INSERT INTO iloulb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Umun-una koma ti apok ngem iti adipenna. Agdalliasatak a nainnayad a maitunos iti pannagna dagiti taraken iti sangngoanak, ken maitunos iti pannagna dagiti ubbing, agingga a makadanonak iti ayan ti apok idiay Seir.” ");
INSERT INTO iloulb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kinuna ni Esau, “Bay-am koma ngarud nga ibatik kadakayo iti dadduma kadagiti kakaduak a lallaki. Ngem kinuna ni Jacob, “Apay nga aramidem dayta? Nangipakitan ti apok iti naan-anay a kinaimbag kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Isu nga iti dayta nga aldaw ket inrugi ni Esau a nagsubli idiay Seir. ");
INSERT INTO iloulb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nagdaliasat ni Jacob idiay Succot, nangipatakder ti balayna, ken nangaramid kadagiti paglinungan para kadagiti tarakenna. Naawagan ngarud ti lugar iti Succot. ");
INSERT INTO iloulb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Idi naggapu ni Jacob idiay Padan-aram, nakasangpet isuna a sitatalged idiay siudad ti Sikem, nga adda iti daga ti Canaan. Nagkampo isuna iti asideg ti siudad. ");
INSERT INTO iloulb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ket ginatangna iti sangagasut a bagi ti pirak ti paset ti daga a nangibangonanna iti kampona manipud kadagiti annak ni Hamor, nga ama ni Sikem,. ");
INSERT INTO iloulb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nangipatakder isuna sadiay iti altar ket inwaganna daytoy iti El Elohe Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ita, ni Dina nga anak a babai ni Lea kenni Jacob, ket rimmuar tapno sarakenna dagiti babbalasang iti dayta a lugar. ");
INSERT INTO iloulb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Nakita isuna ni Sikem, a prinsipe iti dayta a lugar, a putot ni Hamor a Heveo, ket ginuyodna daytoy, ken pinilitna daytoy a makikaidda kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nakayawan isuna kenni Dina, nga anak a babai ni Jacob. Inayatna ti balasang ken kinasaritana daytoy iti naalumamay. ");
INSERT INTO iloulb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kinasarita ni Sikem ti amana a ni Hamor, kinunana, “Alaem daytoy a balasang tapno agbalin nga asawak.” ");
INSERT INTO iloulb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ita, nanggeg ni Jacob a rinames ni Sikem ni Dina a putotna a babai. Adda idi iti kataltalunan dagiti putotna a lallaki a mangay-aywan kadagiti tarakenna, isu a nagtatalna pay laeng ni Jacob agingga a nakasangpetda. ");
INSERT INTO iloulb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Napan ni Hamor nga ama ni Sikem kenni Jacob tapno makisarita kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Simrek dagiti annak a lallaki ni Jacob a naggapu iti taltalon idi nangngegda daytoy a pasamak. Napasakitan dagiti lallaki. Nakapungtotda unay gapu ta imbabainna ti Israel gapu iti panangipilitna iti bagina iti anak a babai ni Jacob, ta saan a rumbeng a napasamak ti kasta a banag. ");
INSERT INTO iloulb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nakisarita ni Hamor kadakuada, kinunana, “Ay-ayaten ni Sikem a putotko ti putotmo a babai. Pangngaasim ta itedmo isuna a kas asawana. ");
INSERT INTO iloulb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Makiinnasawakayo kadakami, itedyo kadakami dagiti annakyo a babbai, ket alaenyo dagiti annakmi a babbai para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Makipagnaedkayo kadakami, ken mabalinyo ti agnaed iti daga ken mabalinyo ti aglako, ken gumatang iti sanikua. ");
INSERT INTO iloulb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kinuna ni Sikem iti ama ni Dina ken kadagiti kakabsatna, “Makasarakak koma iti pabor iti imatangyo, ket itedkonto ti aniaman nga ibagayo kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Dawatandak iti gatad a kas kadakkel iti gatad a bayad ti nobya ken sagut a kas tarigagayanyo, ket itedkonto ti aniaman nga ibagayo kaniak, ngem itedyo kaniak ti balasang nga asawaek.” ");
INSERT INTO iloulb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Simmungbat dagiti putot a lallaki ni Jacob kada Sikem ken Hamor nga amana, nga addaan iti panangallilaw, gapu ta rinugitan ni Sikem ni Dina a kabsatda a babai. ");
INSERT INTO iloulb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kinunada kadakuada, “Saanmi a maaramid daytoy a banag, nga itedmi ti kabsatmi a babai iti siasinoman a saan a nakugit; ta pakaibabainanminto dayta. ");
INSERT INTO iloulb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Iti daytoy laeng a katulagan nga umanamongkami kadakayo: no makugitkayo a kas kadakami, no ti tunggal lalaki kadakayo ket nakugit. ");
INSERT INTO iloulb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ket iti dayta, itedmi kadakayo dagiti annakmi a babbai, ken alaenmi dagiti annakyo a babbai para kadakami, ket makipagnaedkaminto kadakayo ket agbalintayo a maymaysa a tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ngem no saankayo a dumngeg kadakami ken agpakugit, alaenmi ngarud ti kabsatmi a babai ket pumanawkami.” ");
INSERT INTO iloulb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Dagiti sasaoda ket nakaay-ayo kenni Hamor ken iti putotna a ni Sikem. ");
INSERT INTO iloulb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Saan a nagtaktak ti baro a mangaramid iti imbagada, gapu ta naragsakan isuna iti putot a babai ni Jacob, ken gapu ta isuna ti kangrunaan a mararaem a tao iti sangkabalayan ti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Napan ni Hamor ken ti putotna a ni Sikem iti ruangan ti siudad ket kinasaritada dagiti lallaki ti siudadda, a kunada, ");
INSERT INTO iloulb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","nasayaat dagidiay a tattao kadatayo, isu a palubusantayo ida nga agnaed iti daga ken aglako ditoy, ta kinapudnona, nalawa ti daga para kadakuada. Asawaentayo dagiti annakda a babbai, ken ipaasawatayo met kadakuada dagiti annaktayo a babbai. ");
INSERT INTO iloulb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iti daytoy laeng a katulagan nga umanamong dagiti lallaki a makipagnaed kadatayo ken agbalintayo a maymaysa a tattao: no ti tunggal lalaki kadatayo ket makugit a kas kadakuada a nakugit. ");
INSERT INTO iloulb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Saan kadi a dagiti taraken ken sanikuada-amin nga ayupda ket kukuatayonto? Umanamongtayo ngarud kadakuada, ket makipagnaedda kadatayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Dimngeg kada Hamor ken Sikem a putotna dagiti amin a lallaki iti siudad. Tunggal lalaki ket nakugit. ");
INSERT INTO iloulb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Iti maikatlo nga aldaw, idi lumlumteg pay laeng dagiti sugatda, innala dagiti dua a lallaki a putot ni Jacob, da Simeon ken Levi, a kakabsat a lallaki ni Dina, dagiti kampilanda, ken napanda iti siudad nga awan ti nakadlaw kadakuada, ket pinatayda dagiti amin a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pinatayda ni Hamor ken ni Sikem a putotna, babaen iti tadem ti kampilan. Innalada ni Dina manipud iti balay ni Sikem ket pimmanawda. ");
INSERT INTO iloulb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Immay dagiti dadduma a lallaki a putot ni Jacob kadagiti bangkay ken tinakawanda ti siudad, gapu ta rinugutan dagiti tattao ti kabsatda a babai. ");
INSERT INTO iloulb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Innalada dagiti arbanda, dagiti tarakenda, dagiti asnoda, ken amin a banag nga adda iti siudad ken kadagiti kataltalunan iti aglawlaw ");
INSERT INTO iloulb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","agraman dagiti amin a kinabaknangda. Tiniliwda amin nga annak ken assawa dagiti tattao sadiay. Innalada pay amin nga adda kadagiti babbalay. ");
INSERT INTO iloulb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kinuna ni Jacob kada Simeon ken Levi, “Nangiyegkayo iti riribuk kaniak a mangpabangsit kaniak kadagiti agtataeng iti daga, kadagiti Canaanita ken kadagiti Perezeo. Bassit laeng ti bilangko. No pagtitipunenda dagiti bagbagida a bumusor kaniak ken darupendak, ket madadaelakto, siak ken ti bumalayko.” ");
INSERT INTO iloulb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","“Ngem kinuna da Simeon ken Levi, “Rumbeng kadi a trinato ni Sikem iti kabsatmi a babai a kasla maysa a balangkantis?” ");
INSERT INTO iloulb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kinuna ti Dios kenni Jacob, “Tumakderka! Mapanka idiay Betel ket agtalinaedka sadiay. Mangbangonka sadiay iti Altar ti Dios a nagparang kenka idi timmarayka manipud iti kabsatmo a ni Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ket kinuna ni Jacob kadagiti kaballayna ken kadagiti amin a kakadwana, “Ibellengyo dagiti didiosen nga adda kadakayo, aramidenyo ti pakaibilanganyo a nasin-aw ken sukatanyo dagiti kawesyo. ");
INSERT INTO iloulb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kalpasanna, pumanawtayo ditoy ket mapantayo idiay Betel. Mangbangonak sadiay iti altar a maipaay iti Dios, a nangsungbat kaniak iti tiempo ti panagsagabak, ken kankanayon nga adda kaniak iti sadinoman a napnapanak. ");
INSERT INTO iloulb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Intedda ngarud kenni Jacob dagiti amin a didiosen nga adda kadagiti imada, ken dagiti aritos nga adda kadagiti lapayagda. Inkali ni Jacob dagitoy iti sirok ti kayo a Lugo nga asideg idiay Sikem. ");
INSERT INTO iloulb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Kabayatan iti panagdaliasatda, pinagdanag ti Dios dagiti siudad nga adda iti aglawlawda, isu a saan a dinarup dagidiay a tattao dagiti putot ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nakadanon ngarud ni Jacob idiay Luz (dayta ket Betel) nga adda iti daga ti Canaan, isuna ken amin a tattao a kadwana. ");
INSERT INTO iloulb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nangbangon isuna sadiay iti altar ket inawaganna iti El Betel gapu ta imparangarang ti Dios ti bagina kenkuana idi itartarayanna ti kabsatna. ");
INSERT INTO iloulb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ni Deborah, a mangay-aywan kenni Rebecca ket natay. Naitabon isuna idiay Betel iti sirok ti kayo a lugo, isu a naawagan dayta nga Allonbacuth. ");
INSERT INTO iloulb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Idi naggapu ni Jacob idiay Paddan-aram, nagparang manen ti Dios kenkuana ket binendissionanna isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kinuna ti Dios kenkuana “ Ti naganmo ket Jacob, ngem saankanton a maawagan iti Jacob, ti naganmonton ket Israel. ” Pinanaganan ngarud isuna ti Dios iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kinuna ti Dios kenkuana. “Siak ti Manakabalin-amin a Dios. Agbunga ken agpaaduka. Agtaudto kenka ti maysa a nasion ken bunggoy dagiti nasion, ken agtaudto dagiti ari manipud kadagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ti daga nga intedko kenni Abraham ken kenni Isaac ket itedkonto kenka. Itedkonto met daytoy a daga kadagiti kaputotam. ");
INSERT INTO iloulb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ket pinanawan isuna ti Dios idiay lugar a nakisaritaanna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nangbangon ni Jacob iti adigi iti lugar a nakisaritaan kenkuana ti Dios, maysa nga adigi a bato. Binuyatanna daytoy iti arak ken lana a kas datonna. ");
INSERT INTO iloulb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Pinanagananan ni Jacob ti lugar a nakisaritaan ti Dios kenkuana iti Betel. ");
INSERT INTO iloulb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Intuloyda ti nagdaliasat manipud Betel. Idi adayoda pay laeng manipud Efrata, nagpasikal ni Raquel. Nagpasikal isuna iti nakaro. ");
INSERT INTO iloulb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kabayatan iti nakaro a panagpasikalna, kinuna ti mangpapaanak kenkuana “Saan ka nga agbuteng, ta ita maaddaanka iti maysa pay nga anak a lalaki. ” ");
INSERT INTO iloulb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Idi matmatayen isuna, iti kamaudianan nga angesna, pinanagananna ti anakna iti Benoni ngem inawagan isuna ti amana iti Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Natay ni Raquel ket naitabon iti dalan nga agturong idiay Efrata (dayta ket Betlehem). ");
INSERT INTO iloulb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nangikabil ni Jacob iti adigi a bato iti tanemna. Daytoy ti pagilasinan iti tanem ni Raquel agingga ita nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Intultuloy ni Israel ti panagdaliasatna ken impatakderna ti toldana iti labes ti Migdal Eder. ");
INSERT INTO iloulb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Kabayatan nga agnanaedni Israel iti dayta a daga, kinaidda ni Ruben ni Bilha a maysa kadagiti inkabbalay ti amana ket naammoan daytoy ni Israel. Ita, addaan ni Jacob iti sangapulo ket dua a putot a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Dagiti putotna a lallaki kenni Lea ket ni Ruben, nga inauna a putot ni Jacob, ken da Simeon, Levi, Juda, Issacar ken Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Dagiti putotna a lallaki kenni Raquel ket ni Jose ken ni Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Dagiti anakna kenni Bilha, nga adipen ni Raquel, ket ni Dan ken ni Neftali. ");
INSERT INTO iloulb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dagiti annak a lallaki ni Zilpa, nga adipen ni Lea, ket ni Gad ken ni Aser. Amin dagitoy ket lallaki a putot ni Jacob a naipasngay idiay Paddan-aram. ");
INSERT INTO iloulb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Dimteng ni Jacob iti ayan ni Isaac nga amana idiay Mamre iti Kiriat Arba (a maawagan met laeng iti Hebron) a nagnaedan da Abraham ken Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Nagbiag ni Isaac iti sangagasut ket walopulo a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Inyanges ni Isaac ti maudi nga angesna ket natay, pimmusay a lakay unayen. Ni Esau ken ni Jacob a lallaki a putotna ti nangitabon kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dagitoy dagiti kaputotan ni Esau (a maawagan met laeng iti Edom). ");
INSERT INTO iloulb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nangala ni Esau iti assawana manipud kadagiti Canaanita. Dagitoy dagiti assawana: ni Ada a putot ni Elon a Heteo; ni Oholibama a putot ni Ana ken apoko ni Zibeon a Heteo; ");
INSERT INTO iloulb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ken ni Basemat a putot ni Ismael ken kabsat ni Nebayot. ");
INSERT INTO iloulb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Impasngay ni Ada ni Elifaz kenni Esau, ken impasngay ni Basemat ni Reuel. ");
INSERT INTO iloulb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Impasngay ni Oholibamah da Jeus, Jaalam, ken Kora. Dagitoy dagiti lallaki a putot ni Esau a naipasngay idiay Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Innala ni Esau dagiti assawana, dagiti putotna a lallaki ken babbai ken amin a kameng ti sangkabalayanna, dagiti tarakenna –amin nga ayupna ken amin a sanikuana a naurnongna idiay daga ti Canaan ket napanda iti lugar nga adayo manipud iti kabsatna a ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Inaramidna daytoy gapu ta adu unay ti sanikuada no agtalinaeda a dua sadiay. Saan nga umanay kadakuada ti daga a nagnaedanda gapu kadagiti tarakenda. ");
INSERT INTO iloulb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Isu a ni Esau a maawagan met laeng iti Edom ket nagnaed iti katurturodan a pagilian iti Seir. ");
INSERT INTO iloulb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dagiti sumaganad ket dagiti kaputotan ni Esau, a kapuonan dagiti Edomita iti katurturodan a pagilian ti Seir. ");
INSERT INTO iloulb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Dagitoy dagiti nagan dagiti lallaki a putot ni Esau: ni Elifaz nga anak a lalaki ni Ada nga asawa ni Esau; ni Reuel nga anak a lallaki ni Basemat nga asawa ni Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dagitoy met dagiti lallaki a putot ni Elifaz: da Teman, Omar, Zepo, Gatam ken Kenaz. ");
INSERT INTO iloulb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Impasngay met ni Timna a maysa nga inkabbalay ni Elifaz a putot ni Esau ni Amalek. Appoko dagitoy ni Ada nga asawa ni Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Dagitoy dagiti lallaki a putot ni Reuel: da Nahat, Zera, Samma ken Mizza. Appoko dagitoy ni Basemat nga asawa ni Esau. ");
INSERT INTO iloulb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dagitoy met dagiti annak a lallaki da Esau ken Oholibama nga asawana. Ni Oholibama ket putot ni Ana ken apoko ni Zibeon. Impasngayna kenni Esau da Jeus, Jaalam ken Kora. ");
INSERT INTO iloulb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dagitoy dagiti puli manipud iti kaputotan ni Esau: dagiti kaputotan ni Elifaz nga inauna a lalaki a putot ni Esau: da Teman, Omar, Zepo, Kenaz, ");
INSERT INTO iloulb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam ken Amalek. Dagitoy ket puli a nagtaud kenni Elifaz idiay daga ti Edom. Isuda ket lallaki nga appoko ni Ada. ");
INSERT INTO iloulb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Dagitoy dagiti puli a nagtaud kenni Reuel, a lalaki a putot ni Esau: da Nahat, Zera, Samma ken Mizza. Dagitoy dagiti puli a nagtaud kenni Reuel iti daga ti Edom. Isuda dagiti appoko a lallaki ni Basemat nga asawa ni Esau. Dagitoy dagiti puli ni Oholibama nga asawa ni Esau: da Jeus, Jaalam ken Kora. ");
INSERT INTO iloulb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dagitoy dagiti puli a nagtaud kenni Oholibama nga asawa ni Esau, a putot ni Ana. ");
INSERT INTO iloulb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dagitoy dagiti putot a lallaki ni Esau, ken dagitoy dagiti pulida. ");
INSERT INTO iloulb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Dagitoy dagiti a lallaki a putot ni Seir a Horeo nga agnanaed iti daga: da Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO iloulb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer ken Disan. Dagitoy dagiti puli dagiti Horeo, dagiti agnanaed idiay Seir iti daga ti Edom. ");
INSERT INTO iloulb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Dagiti lallaki a putot ni Lotan ket da Hori ken Heman. Ni Timna ket kabsat a babai ni Lotan. ");
INSERT INTO iloulb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Dagitoy dagiti lallaki a putot ni Sobal: da Alban, Manahat, Ebal, Sefo ken Onam. ");
INSERT INTO iloulb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Dagitoy dagiti lallaki a putot ni Zibeon, da Aya ken Ana. Isu daytoy ni Ana a nakasarak iti napudot nga ubbog iti let-ang kabayatan nga ipaspastorna dagiti asno ni Zibeon nga amana. ");
INSERT INTO iloulb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Dagitoy dagiti putot ni Ana: ni Dison ken ni Oholibama a putot a babai ni Ana. ");
INSERT INTO iloulb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dagitoy dagiti lallaki a putot ni Dison: da Hemdan, Esban, Itran, ken Keran. ");
INSERT INTO iloulb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dagitoy dagiti lallaki a putot ni Ezer: da Bilhan, Zaavan ken Akan. ");
INSERT INTO iloulb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dagitoy dagiti lallaki a putot ni Disan: ni Uz ken ni Aran. ");
INSERT INTO iloulb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dagitoy dagiti puli dagiti Horeo: da Lotan, Sobal, Zibeon, ken Ana, ");
INSERT INTO iloulb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ezer, Disan: Dagitoy dagiti puli dagiti Horeo segun iti listaan dagiti pulida iti daga ti Seir. ");
INSERT INTO iloulb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Dagitoy dagiti ari a nagturay idiay Edom sakbay nga adda nagturay nga ari kadagiti Israelita: ");
INSERT INTO iloulb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Nagturay ni Bela a lalaki a putot ni Beor idiay Edom ken ti nagan ti siudadna ket Dinhaba. ");
INSERT INTO iloulb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Idi natay ni Bela, simmukat kas ari ni Jobab a lalaki a putot ni Zera a taga-Bozra. ");
INSERT INTO iloulb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Idi natay ni Jobab, naisukat a nagari ni Husam a nagtaud iti daga dagiti Temanita. ");
INSERT INTO iloulb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Idi natay ni Husam, naisukat a nagari ni Hadad a lalaki a putot ni Bedad. Isuna ti nangparmek kadagiti Midianita iti daga ti Moab. Ti nagan ti siudadna ket Avit. ");
INSERT INTO iloulb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Idi natay ni Hadad, naisukat a nagari ni Samla a taga-Masrecca. ");
INSERT INTO iloulb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Idi natay ni Samla, naisukat a nagari ni Saul a a nagtaud idiay Rehobot nga asideg iti karayan Eufrates. ");
INSERT INTO iloulb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Idi natay ni Saul, naisukat a nagari ni Baal Hanan a lalaki a putot ni Akbor. ");
INSERT INTO iloulb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Idi natay ni Baal Hanan a putot ni Akbor, naisukat a nagari ni Hadar. Ti nagan ti siudadna ket Pau. Ti nagan ti asawana ket ni Mehetabel a babai a putot ni Matred ken apoko a babai ni Me Zahab. ");
INSERT INTO iloulb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dagitoy dagiti nagan dagiti panguloen dagiti puli manipud iti kaputotan ni Esau, segun iti pulida ken kadagiti rehionda, ken segun kadagiti nagnaganda: da Timna, Alva, Jetet, ");
INSERT INTO iloulb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO iloulb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO iloulb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel ken Iram. Dagitoy dagiti panguloen dagiti puli ni Edom segun iti pannakaurnosda iti daga a tinagikuada. Daytoy ni Esau nga ama dagiti Edomita. ");
INSERT INTO iloulb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nagnaed ni Jacob iti daga a pagnanaedan ti amana, iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dagitoy dagiti pasamak maipanggep kenni Jacob. Ti barito a ni Jose nga agtawen iti sangapulo ket pito, ket ay-aywananna dagiti arban a kaduana dagiti kakabsatna a lallaki. Kaduana dagiti annak ni Bilha ken dagiti annak ni Zilpa, nga assawa ti amana. Adda impadamag ni Jose a saan a nasayaat a banag maipanggep kadakuada iti amada. ");
INSERT INTO iloulb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ita, ad-adda ti panangipateg ni Israel kenni Jose ngem kadagiti amin a putotna gapu ta naiyanak daytoy idi lakayen ni Israel. Inyaramidanna isuna iti napintas a kawes. ");
INSERT INTO iloulb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nadlaw dagiti kakabsatna nga ad-adda ti panagayat ti amada kenkuana ngem kadakuada amin a kakabsatna. Ginurada ken saan a nasayaat iti panakisaritada kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nagtagtagainep ni Jose, ket imbagana ti maipapan iti daytoy kadagiti kakabsatna. Ad-adda pay a ginurada isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kinunana kadakuada, “Pangngaasiyo ta denggenyo daytoy a natagtagainepko. ");
INSERT INTO iloulb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mangrepreppettayo kampay idi kadagiti trigo idiay talon, pagammoan ket bimmangon ti rineppetko ken timmakder, ket pagammoan, pinalikmutan ken nagrukob dagiti rineppetyo iti rineppetko.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kinuna dagiti kakabsatna kenkuana, “Ibagbagam kadi nga idaulloannakaminto? Mapasamakto aya met nga iturayannakami?” Ad-adda a ginurada isuna gapu kadagiti tagtagainepna ken gapu kadagiti sasaona. ");
INSERT INTO iloulb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nagtagtagainep manen isuna iti maysa pay, ket imbagana daytoy kadagiti kakabsatna. Kinunana, “Ammoyo kadi, adda manen natagtagainepko: Nagrukob kano kaniak ti init, ti bulan, ken dagiti sangapulo ket maysa a bituen.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Imbagana met daytoy iti amana a kas met kadagiti kakabsatna, ket tinubngar isuna ti amana. Kinunana kenkuana, “Ania met daytoy a natagtagainepmo? Ibagbagam kadi nga agrukobak kasta met ti inam ken uray pay dagiti kakabsatmo kenka? ");
INSERT INTO iloulb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Umapal dagiti kakabsatna kenkuana, ngem ti amana ket pinanpanunotna daytoy a banag. ");
INSERT INTO iloulb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Napan idiay Sikem dagiti kakabsatna tapno aywananda dagiti arban ti amada. ");
INSERT INTO iloulb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kinuna ni Israel kenni Jose, “Di met adda dagiti kakabsatmo idiay Sikem a mangay-aywan kadagiti arban? Umayka ta ibaonka kadakuada.” Kinuna ni Jose kenkuana, “Nakasaganaak.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kinunana kenkuana, “Mapankan, kitaem no nasayaat met laeng ti kasasaad dagiti kakabsatmo ken dagiti arban, ket umaymo ipakaammo kaniak.” Imbaon ngarud ni Jacob ni Jose manipud iti tanap ti Hebron ket napan isuna idiay Sikem. ");
INSERT INTO iloulb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Nakita ti maysa a lalaki ni Jose. Agalla-alla idi ni Jose iti tay-ak. Sinaludsod ti lalaki kenkuana, “Ania ti birbirukem?” ");
INSERT INTO iloulb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kinuna ni Jose, “Birbirukek dagiti kakabsatko. Ibagam koma kaniak no sadino ti pangay-aywananda kadagiti arban.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kinuna ti lalaki, “Pimmanawda iti daytoy a lugar ta nangngegko a kinunada, 'Mapantayo idiay Dotan.”' Sinurot ngarud ni Jose dagiti kakabsatna ket nasarakanna ida idiay Dotan. ");
INSERT INTO iloulb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nakitada isuna iti saan unay nga adayo, ken sakbay a nakaasideg isuna kadakuada, pinanggepda a patayen isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Kinuna dagiti kakabsatna iti tunggal maysa, “Kitaenyo, um-umay daytoy a managtagtagainep. ");
INSERT INTO iloulb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Umaykayo ngaruden, patayentayo isuna ken itinnagtayo iti maysa kadagiti abut. Ibagatayonto, “Inalun-on isuna ti narungsot nga ayup.' Kitaentayo man no anianto ti pagbanagan dagiti tagtagainepna.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Nangngeg ni Ruben daytoy ket inispalna isuna manipud kadagiti imada. Kinunana, “Saantayo a pukawne ti biagna.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kinuna ni Ruben kadakuada, “Saanyo a pagayusen ti dara. Ibillengyo isuna iti abut nga adda iti daytoy a let-ang ngem saanyo a dangran isuna”- tapno maispalna isuna manipud kadagiti imada ket maisublina isuna iti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ket napasamak nga idi nakadanunen ni Jose iti ayan dagiti kakabsatna, inallada ti napintas a kawesna. ");
INSERT INTO iloulb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Innalada isuna ket intinnagda iti abut. Awan naggian ti abut ket awan danum iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nagtugawda a mangan iti tinapay. Timman-awda ket adda nakitada a bunggoy dagiti Ismaelita a sumungsungad a naggapu idiay Galaad, ket awit dagiti kamelioda dagiti rekado, bangbanglo ken mirra. Agdaldaliasatda tapno iyapanda dagitoy idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kinuna ni Juda kadagiti kakabsatna, “Ania ti maganabtayo no patayentayo ti kabsattayo ken agulbodtayo gapu iti pannakatayna? ");
INSERT INTO iloulb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Umaykayo, ilakotayo ketdi isuna kadagiti Ismaelita a saan ket a dangran. Ta kabsattayo isuna, kadaraantayo a mismo.” Dimngeg dagiti kakabsatna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Limmabas dagiti agtagtagilako a Midianita. Inyaon dagiti kakabsat ni Jose isuna ket inruarda isuna iti abut. Inlakoda ni Jose kadagiti Ismaelita iti duapulo a pirak. Intugot dagiti Ismaelita ni Jose idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nagsubli ni Ruben idiay ayan ti abut ket idi kitaenna, awan met ni Jose iti abut. Rinay-ab ni Ruben ti kawesna. ");
INSERT INTO iloulb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nagsubli isuna kadagiti kakabsatna ket kinunana, “Ayanna ngayen ti ubing? Ket siak, papanakon ngay?” ");
INSERT INTO iloulb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nangpatayda iti kalding ken innalada ti kawes ni Jose ket insawsawda iti dara. ");
INSERT INTO iloulb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kalpasanna, inyapanda daytoy iti amada ket kinunada, “Nasarakanmi daytoy. Pangngaasim ta kitaem no kawes daytoy ti anakmo wenno saan.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nabigbig ni Jacob daytoy ket kinunana, “Kawes daytoy ti anakko. Inalun-on isuna ti narungsot nga ayup. Awan duadua a napirsapirsayen ni Jose.” ");
INSERT INTO iloulb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Rinay-ab ni Jacob dagiti kawesna ket nagkawes isuna iti nakersang a lupot. Nagdung-aw isuna para iti putotna iti adu nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Immay dagiti amin a putotna a lallaki ken babbai tapno liwliwaenda isuna ngem saanna a kayat a maliwliwa. Kinunana, “Mapanakto idiay sheol a silaladingit gapu iti anakko.” Sinangsangitan ni Jacob ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Inlako isuna dagiti Midianita idiay Egipto, kenni Potifar, maysa nga opisial ti Faraon, ken isu iti mangidadaulo kadagiti guardia ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Napamak nga iti dayta a tiempo ket pinanawan ni Juda dagiti kakabsatna ket nakipagnaed iti maysa nga Adullamita nga agnagan ti Hira. ");
INSERT INTO iloulb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Naam-ammona idiay ti anak ni Sua a maysa a Canaanita. Inasawana ket kinaiddana daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nagsikog isuna ket nagpasngay iti lalaki. Napanaganan daytoy iti Er. ");
INSERT INTO iloulb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nagsikog manen isuna ket nagpasngay manen iti lalaki. Pinanagananna daytoy iti Onan. ");
INSERT INTO iloulb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Naaddaan manen isuna iti anak a lalaki ket pinanagananna daytoy iti Sela. Idiay Kezib ti nangipasngayanna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nakasarak ni Juda iti iyasawana kenni Er nga inauna a putotna. Ti naganna ket Tamar. ");
INSERT INTO iloulb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nadangkes ni Er nga inauna a putot ni Juda iti imatang ni Yahweh. Isu a pinatay isuna ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kinuna ni Juda kenni Onan, “Kaiddaem ti asawa ti kabsatmo. Aramidem ti pagrebbengan ti maysa a bayaw ket mangpadakkelka iti anak para iti kabsatmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ammo ni Onan a saannanto a kukua ti ubing. Tunggal kaiddaenna ti asawa ti kabsatna, ibelbellengna ti kissitna iti daga tapno saan isuna a maaddaan ti anak para iti kabsatna. ");
INSERT INTO iloulb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Dakes ti inaramidna iti imatang ni Yahweh. Pinatay ngarud met laeng isuna ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ket kinuna ni Juda kenni Tamar a manugangna, “Agtalinaedka a balo iti balay ti amam agingga a dumakkel ti anakko a ni Sela.” Ta napanunotna, “Nalabit a matayto met laeng daytoy a kas kadagiti kakabsatna.” Pimmanaw ni Tamar ket nagnaed iti balay ti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kalpasan ti nabayag a tiempo, natay ti putot ni Sua nga asawa ni Juda. Naliwliwa ni Juda ket napan isuna kadagiti mangpukpukis kadagiti karnerona idiay Timna, kaduana ti gayyemna nga Adullamita a ni Hiran. ");
INSERT INTO iloulb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Naibaga kenni Tamar, “Ammom, mapan ti katugangam idiay Timna tapno papukisanna dagiti karnerona.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Inikkatna ngarud ti kawes ti kinabalona ket inabbunganna ti bagina iti naingpis a lupot ken binalkotna ti bagina. Nagtugaw isuna iti ruangan ti Enaim, nga adda iti igid ti dalan nga agturong idiay Timna. Ta nakitana a dimmakelen ni Sela ngem saan a naiyasawa ni Tamar kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Idi nakita ni Juda isuna, impagarupna a maysa isuna a balangkantis gapu ta inabbunganna ti rupana. ");
INSERT INTO iloulb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Inasetganna isuna iti igid ti dalan ket kinunana, “Umayka, pangngaasim ta bay-am a kaiddaenka”- ta saanna nga ammo nga isuna ti manugangna- ket kinuna ni Tamar, “Ania ti itedmo kaniak tapno mabalinnak a kaiddaen?” ");
INSERT INTO iloulb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kinunana, “Mangipatuludak kenka iti urbon a kalding manipud iti arban.” Kinuna ni Tamar, ''Ikkannak kadi iti pakakitaan a mangtedkanto agingga nga ipatulodmo daytoy?” ");
INSERT INTO iloulb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kinunana, “Ania a pakakitaan ti mabalinko nga ited kenka?” Ket kinuna ni Tamar, “Ti selio, ti tali ken ti sarukod nga adda iti imam.” Intedna dagitoy kenkuana ket nakikaidda kenkuana. Ket nagsikog ni Tamar babaen kekuana. ");
INSERT INTO iloulb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Bimmangon isuna ket pimmanaw. Inikkatna ti abbongna ket inkawesna ti kawes ti kinabalona. ");
INSERT INTO iloulb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Impatulod ni Juda ti urbon a kalding iti Adullamita a gayyemna tapno alaenna manipud iti babai ti intedna a pakakitaan a tungpalenna ti karina iti babai, ngem saanna a nasarakan daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ket dinamag ti Adulamita kadagiti tattao iti lugar, “Ayan ti balangkantis nga agserserbi iti templo nga adda iti igid ti dalan ti Enaim?” Kinunada, “Awan iti balangkantis nga agserserbi iti templo ditoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nagsubli ngarud isuna kenni Juda ket kinunana, “Saanko a nasarakan isuna. Kinuna pay dagiti tattao idiay, 'Awan met iti balangkantis nga agserserbi iti templo ditoy.”' ");
INSERT INTO iloulb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kinuna ni Juda, “Bay-am nga idulinna dagiti banbanag nga intedko, maibabainta laeng. Pudno met nga impatulodko daytoy nga urbon a kalding, ngem saanmo isuna a nasarakan.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Napasamak a kalpasan iti tallo a bulan, naipadamag kenni Juda, “Nagbalin a balangkantis ni Tamar a manugangmo, ket nagsikog isuna gapu iti daytoy.” Kinuna ni Juda, “Iyegyo isuna ditoy ket puoranyo isuna.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Idi naiyegdan ni Tamar, nangipatulod isuna iti mensahe iti katuganganna, “Babaen iti tao nga akinkukua kadagitoy a masikogak.” Kinuna ni Tamar, “Pangngaasim ta bigbigem no siasino ti akin kukua kadagitoy, ti selio, ti tali ken ti sarukod.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nabigbig ni Juda dagitoy ket kinunana, “Ad-adda a nalinteg isuna ngem siak, gapu ta saanko isuna nga impaasawa iti anakko a ni Sela.” Ket saannan a kinaidda pay daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Idi dimteng ti tiempo nga aganaken daytoy, singin gayam ti adda iti aanakanna. ");
INSERT INTO iloulb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Napasamak nga idi agan-anaken isuna, inruar ti maysa ti imana, ket nangala ti agpapaanak iti nalabbaga a sinulid, inggalotna iti ima ti ubing ket kinunana, “Daytoy ti immuna a rimmuar.” ");
INSERT INTO iloulb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Idi insublina ti imana, ti met immuna a rimuar ket ti kabsatna. Kinuna ti agpapaanak, ''Kasano a nakiinnunaka a rimmuar!” ");
INSERT INTO iloulb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ket napanaganan daytoy iti Perez. Kalpasanna, rimmuar ti kabsatna nga addaan iti nalabbaga a sinulid iti imana, ket napanagan isuna iti Zera. ");
INSERT INTO iloulb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Naipan ni Jose iti Egipto. Ti Egipcio a ni Potifar, a maysa nga opisial iti Faraon ta isu ket kapitan dagiti guardia, ginatangna ni Jose manipud kadagiti Ismaelita a nangipan kenkuana sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Adda ni Yahweh kenni Jose. Isuna ket narang-ay a tao. Adda isuna iti balay ti amona nga Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Nakita ti apona nga adda ni Yahweh kenkuana ken pinarang-ay ni Yahweh ti tunggal banag nga inaramidna. ");
INSERT INTO iloulb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nagbalin ngarud ni Jose a makaay-ayo iti imatang ti apona. Nagserbianna ni Potifar. Pinagbalin ni Potifar ni Jose a mangimaton iti isuamin nga adda iti balayna, ket amin a sanikuana, impaaywanna kenni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Napasamak a manipud iti tiempo a pinagbalin ni Potifar ni Jose a mangimaton iti balayna ken iti amin a sanikuana, a binendisionan ni Yahweh ti balay ti Egipcio gapu kenni Jose. Ti bendision ni Yahweh ket adda kadagiti amin nga adda iti balay ken taltalon ni Potifar. ");
INSERT INTO iloulb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Impaaywan ni Potifar dagiti amin nga adda kenkuana kenni Jose. Saannan a masapul a panunoten pay ti maipapan iti aniaman a banag malaksid ti taraon a kanenna. Ita, ni Jose ket nataer ken nabaked. ");
INSERT INTO iloulb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Napasamak kalpasan daytoy, a ni Jose ket pinaggarteman ti asawa ti apona. Kinunana, “Kaiddaennak.” ");
INSERT INTO iloulb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ngem nagkedked isuna ket kinunana iti asawa ti apona, “Kitaem, saan a pakibibbiangan ti apok no ania ti aramidek iti balay, ken amin a sanikuana ket impaaywanna kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Awan ti siasinoman a nangatngato kaniak iti daytoy a balay. Awan iti aniaman a saanna nga intalek kaniak malaksid kenka, gapu ta sika ket asawana. Apay ketdin nga aramidek daytoy a nakaro a kinadakes a pakabasulak iti Dios?” ");
INSERT INTO iloulb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Inaldaw a makikisao isuna kenni Jose, ngem nagkedked isuna a makikaidda wenno makikaddua kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Napasamak iti maysa nga aldaw a simrek isuna iti balay tapno aramidenna ti trabahona. Awan kadagiti lallaki iti balay ti adda iti balay. ");
INSERT INTO iloulb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ginammatanna isuna babaen kadagiti kawesna ket kinunana, “Kaidddaennak.” Timmaray ni Jose a napan iti ruar, ket nabatina ti kawesna iti ima ti babai. ");
INSERT INTO iloulb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Napasamak nga idi nakita ti asawa ni Potifar a nabati ni Jose ti kawesna iti ima daytoy ken timmaray iti ruar, ");
INSERT INTO iloulb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","immawag isuna kadagiti lallaki iti balayna ket imbagana kadakuada, “Kitaenyo, nangiserrek ditoy ni Potifar iti Hebreo a manglais kadatayo. Sinerreknak tapno kaiddaenak, ket nagikkisak. ");
INSERT INTO iloulb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Napasamak nga idi nangngegna a nagikkisak, timmaray iti ruwar ket nabatina ti kawesna kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Inkabilna ti kawesna iti sibayna agingga a nagawid ti apona. ");
INSERT INTO iloulb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Imbagana kenkuana daytoy a palawag, “Ti adipen a Hebreo nga inyegmo kadakami, sinerreknak tapno gundawayannak. ");
INSERT INTO iloulb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ket napamasak nga idi nagikkisak, timmaray iti ruar ket nabatina ti kawesna kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Napasamak nga idi nangngeg ni Potifar ti palawag nga imbaga ti asawana kenkuana a kunana, “Kastoy ti inaramid kaniak ti adipenmo,” nakapungtot iti kasta unay ni Potifar. ");
INSERT INTO iloulb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Innala ni Potifar ni Jose ket pinaibaludna, iti lugar a nakaibaludan dagiti balud ti ari. Ket adda ngarud isunan iti pagbaludan. ");
INSERT INTO iloulb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngem adda ni Yahweh kenni Jose ken impakitana kenkuana a napudno isuna iti tulagna. Nagtignay ni Yahweh iti agbanbantay iti pagbaludan isu a nakasarak ni Jose iti pabor iti imatang daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Intalek ti agbanbantay iti pagbaludan dagiti amin a balud nga adda iti pagbaludan kenni Jose. Aniaman nga ar-aramidenda idiay, naitalek kenni Jose dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Awan ti pagdanagan ti agbanbantay iti pagbaludan maipapan iti aniaman a banag a naitalek kenni Jose, gapu ta adda ni Yahweh kenkuana. Pinarang-ay ni Yahweh ti aniaman nga inaramidna. ");
INSERT INTO iloulb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Napasamak a kalpasan dagitoy a banbanag, nakaaramid iti saan a nasayaat ti agiserserbi iti arak ken ti agisagsagana iti kanen ti ari ti Egipto iti amoda, nga isu ti ari ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nakapungtot ti Faraon kadagiti dua nga opisialna, ti panguloen dagiti agiserserbi iti arak ken ti panguloen dagiti agisagsagana iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Pinaibaludna dagitoy iti pagbaludan ti kapitan ti guardia, a nakaipupokan met laeng ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Intalek ida ti kapitan ti guardia kenni Jose. Inasikasuna ida. Nagtalinaedda iti pagbaludan iti nabayag met bassit a tiempo. ");
INSERT INTO iloulb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nagtagtagainepda nga agpada, tunggal maysa kadagitoy ket nagtagtagainep iti isu met laeng a rabii, ket adda iti pakaitarusan ti tagtagainep ti tunggal maysa, ti panguloen dagiti agiserserbi iti arak ken ti panguloen dagiti agisagsagana iti taraon ti ari ti Egipto. Dagitoy a dua ket naipupok iti pagbaludan. ");
INSERT INTO iloulb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Napan ni Jose kadakuada iti kabigatanna ket nakitana ida. Ket nadlawna a nalidayda. ");
INSERT INTO iloulb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Sinaludsodna kadagiti opisial ti Faraon a kaduana a nakabalud iti balay ti apona, a kunana, “Apay a nalidaykayo ita nga aldaw?” ");
INSERT INTO iloulb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kinunada kenkuana, “Nagtagtagainepkami nga agpada ket awan ti makailawlawag iti daytoy.” Kinuna ni Jose kadakuada, “Saanyo kadi nga ammo a ti Dios ti pagtaudan iti pannakailawlawag? Ibagayo koma kaniak ti natagtagainepyo.” ");
INSERT INTO iloulb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Imbaga ti panguloen dagiti agiserserbi iti inumen ti tagtaginepna kenni Jose. Kinunana kenkuana, “Iti tagtagainepko, nakakitaak iti maysa a lanut. ");
INSERT INTO iloulb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ti lanut ket addaan iti tallo a sanga. Idi nagsaringit daytoy, nagsabong ket dagiti raay ti ubas a bungana ket naluom. ");
INSERT INTO iloulb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ig-iggamak kampay idi ti kopa ti Faraon, pinurosko dagiti ubas ken pinespesko dagitoy iti kopa ti Faraon, ket inyawatko ti kopa iti ima ti Faraon.” ");
INSERT INTO iloulb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kinuna ni Jose kenkuana, “Kastoy ti kaipapananna dayta. Dagiti tallo a sanga ket tallo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tallo nga aldaw manipud ita, patangadennakanto ti Faraon ket isublinakanto iti saadmo. Iyawatmonto ti kopa iti Faraon, a kas iti sigud nga ar-aramidem kas agiserserbi iti inumenna. ");
INSERT INTO iloulb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ngem laglagipennakto inton sumayaat ti kasasaadmo, ket subadannak koma met iti kinaimbag. Dakamatennak koma iti Faraon ken iruarnak manipud iti daytoy a pagbaludan. ");
INSERT INTO iloulb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ta pudno a naipanawak manipud iti daga dagiti Hebreo. Kasta met ditoy, awan ti inaramidko a rumbeng a pakaipupokak iti daytoy a pagbaludan.” ");
INSERT INTO iloulb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Idi nakita ti panguloen dagiti agisagsagana iti taraon ti ari a makaay-ayo ti kaipapananna, kinunana kenni Jose, “Nagtagtagainepak met iti kastoy, adda kampay idi iti tallo a basket a tinapay a susuonek. ");
INSERT INTO iloulb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Iti akinrabaw a basket ket adda amin a kita dagiti naluto a taraon a maipaay iti Faraon, ngem kinnan daytoy dagiti billit manipud iti basket a susuonek.” ");
INSERT INTO iloulb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Simmungbat ni Jose a kinunana, “Kastoy ti kaipapananna. Dagiti tallo a basket ket tallo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Iti uneg ti tallo nga aldaw, ingatonto ti Faraon ti ulom ken paibitinnakanto iti kayo. Kanento dagiti billit ti lasagmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Napasamak nga iti maikatlo nga aldaw ket isu ti panagkasangay ti Faraon. Nangangay isuna iti padaya para kadagiti amin nga adipenna. Inikanna iti naisangsangayan a panangibilang ti panguloen dagiti agiserserbi iti inumen ken ti panguloen dagiti agisagsagana iti taraon, ngem kadagiti amin a dadduma nga adipenna. ");
INSERT INTO iloulb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Insublina ti panguloen dagiti agiserserbi iti inumenna iti pagrebbenganna, ket isuna manen ti agiserserbi iti kopa iti ima ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ngem pinaibitinna ti panguloen dagiti agiserserbi iti taraon, a kas iti imbaga ni Jose kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ngem saanen a nalagip ti panguloen dagiti agiserserbi iti inumen ti ari a tulungan ni Jose. Ngem ketdi, nalipatanna ti maipapan kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Napasamak nga idi napalabas ti dua a tawen, nagtagtagainep ti Faraon. Kampay idi, nakatakder isuna iti igid ti Karayan Nile. ");
INSERT INTO iloulb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Pagammoan, adda pito a baka a timmakdang manipud iti Karayan Nile, napipintas ken nalulukmeg dagitoy, ket nagarabda kadagiti runo. ");
INSERT INTO iloulb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pagammoan, adda met sabali pay a pito a baka a timmakdang a simmaruno kadakuada manipud iti Karayan Nile, kasla la adda sakit dagitoy ken nakukuttongda. Nagtakderda iti asideg dagiti sabali pay a baka iti igid ti karayan. ");
INSERT INTO iloulb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kalpasanna kinnan dagiti kasla adda sakitna ken nakukuttong a baka dagiti pito a napipintas ken nalulukmeg a baka. Kalpasanna, nakariing ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ket naturog manen isuna ket nagtagtagainep iti maikadua a daras. Adda kampay idi iti pito a dawa a nagrusing manipud iti maymaysa nga ungkay, nabagas ken napintas daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Pagammoan, pito met a dawa nga eppes ken nalanet gapu iti angin ti daya iti nagrusing kalpasan dagiti immuna. ");
INSERT INTO iloulb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Inalun-on dagiti eppes a dawa dagiti napintas ken nabagas a dawa. Nakariing ti Faraon, ket naamirisna a tagtagainep laeng gayam daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Napasamak nga iti kabigatanna, mariribukan unay ti espirituna. Nangibaon isuna kadagiti adipenna a mangayab kadagiti amin a salamangkero ken mamasirib a lallaki iti Egipto. Imbaga ti Faraon kadakuada dagiti tagtagainepna, ngem awan iti uray maysa kadakuada a makaibaga iti kaipapanan dagitoy a tagtagainep iti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ket kinuna ti panguloen nga agiserserbi iti inumen iti Faraon, “Ita, panpanunutek ti maipapan kadagiti nakabasolak. ");
INSERT INTO iloulb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nakaunget ti Faraon kadagiti adipenna ket pinaibaludnak iti balay ti kapitan dagiti guardia, siak ken ti panguloen nga agisagsagana iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nagtagtagainepkami a dua iti maysa a rabii. Nagtagtagainep ti tunggal maysa kadakami ket saan nga agpada ti kaipapanan dagiti tinagtagainepmi. ");
INSERT INTO iloulb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Adda kaduami sadiay a maysa nga agtutubo a lalaki a Hebreo, nga adipen ti kapitan dagiti guardia. Imbagami kenkuana ket inlawlawagna ti kaipapanan dagiti tagtagainepmi. Imbagana ti kaipapanan ti tagtagainep ti tunggal maysa kadakami. ");
INSERT INTO iloulb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Napasamak a no ania iti imbagana a kaipapanan ti tagtagainepmi ket isu ti napasamak. Insublinak ti Faraon iti akemko, ngem binitayna ti kaduak.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kalpasanna, pinaayaban ti Faraon ni Jose. Dagus nga inruarda isuna iti pagbaludan. Nagibarbas, sinukatanna ti kawesna, ket napan iti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kinuna ti Faraon kenni Jose, “Adda natagtagainepak, ngem awan iti makailawlawag iti daytoy. Ngem nangngegko ti maipapan kenka, a no mangngegmo ti maysa a tagtagainep, mailawlawagmo daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Simmungbat ni Jose iti Faraon, a kunana, “Saan nga iti bukodko. Sungbatan ti Dios ti Faraon nga addaan iti pabor.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Nagsao ti Faraon kenni Jose, “Iti tagtagainepko, nagtakderak kampay idi iti igid ti Karayan Nile. ");
INSERT INTO iloulb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Pagammoan, adda pito a baka a timmakdang manipud iti Karayan Nile, nalulukmeg ken napipintas dagitoy, ket nagarabda kadagiti runo.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Pagammoan, adda pito a sabali pay a baka a timmakdang a simmaruno kadakuada, nakapuy, saan a makaay-ayo a kitaen ken nakukuttong dagitoy. Saanak pay a nakakita iti kasta kakuttong iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kinnan dagiti nakuttong ken saan a makaay-ayo a baka dagiti immuna a pito a nalukmeg a baka. ");
INSERT INTO iloulb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Idi nakandan dagitoy, saan a makita a kinnanda ida, ta saanda latta a makaay-ayo a kitaen a kas iti sigud a langada. Kalpasanna, nakariingak. ");
INSERT INTO iloulb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Iti tagtagainepko, kimmitaak kampay idi, ket pagammoan, adda pito a dawa a rimmuar manipud iti maysa nga ungkay, nabagas ken napintas dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Pagammoan, adda pay pito a dawa nga eppes, nakuttong, ken nalanet gapu iti angin ti daya ti nagrusing a simmaruno kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Inalun-on dagiti eppes a dawa dagiti pito a napipintas a dawa. Imbagak dagitoy a tagtagainep kadagiti salamangkero, ngem awan pulos ti makaipalawag kaniak iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kinuna ni Jose iti Faraon, “Agpada ti tagtagainep ti Faraon. Impakaammo ti Dios iti Faraon ti aramidennanto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dagiti pito a napipintas a baka ket pito a tawen, ken dagiti pito a napipintas a dawa ket pito a tawen. Agpada dagiti tagtagainep. ");
INSERT INTO iloulb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ken dagiti pito a nakuttong ken saan a makaay-ayo a kitaen a baka a timmakdang a simmaruno kadagitoy ket pito a tawen, ken kasta met a dagiti pito nga eppes a dawa a nalanet gapu iti angin ti daya ket piton a tawen ti panagbisin iti kaipapananda. ");
INSERT INTO iloulb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Dayta ti banag nga imbagak iti Faraon. Impaltiing ti Dios iti Faraon ti aramidennanto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kastoy ti mapasamak, addanto pito a tawen a nawadwad ti apit iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kalpasan dagitoy, umayto ti pito a tawen ti panagbisin, ket malipatanto ti amin a kinawadwad iti daga ti Egipto, ken dadaelento ti panagbisin ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Saanto a malagip ti kinawadwad iti daga gapu iti panagbisin a sumaruno, ta nakaronto unay daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Naulit dayta a tagtagainep ti Faraon gapu ta inkeddengen ti Dios dayta a banag, ken ipatungpalto daytoy ti Dios iti mabiit. ");
INSERT INTO iloulb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ita, masapul a mangbiruk ti Faraon iti tao a nasaririt ken masirib, ket isaadna daytoy a mangimaton iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kastoy koma ti aramiden ti Faraon: Mangdutok koma isuna iti mangimaton iti daga. Alaen koma dagitoy ti apagkalima dagiti apit ti Egipto iti pito a tawen ti kinawadwad. ");
INSERT INTO iloulb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Urnungenda koma amin dagiti taraon kadagiti nasayaat a tawtawen nga umay. Ikan koma ida ti Faraon iti kalintegan nga agidulin kadagiti bukbukel kadagiti siudad. Pabantayanna koma kadakuada daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dagiti taraon ket agbalinto nga abasto ti daga kabayatan iti pito a tawen a panagbisin a mapasamakto iti daga ti Egipto. Iti kastoy a wagas, saanto a mapukaw dagiti adda iti daga gapu iti panagbisin. ");
INSERT INTO iloulb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nasayaat daytoy a pammagbaga iti imatang ti Faraon ken iti imatang dagiti amin nga adipenna. ");
INSERT INTO iloulb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kinuna ti Faraon kadagiti adipenna, “Makasaraktayo kadi pay iti kas iti daytoy a tao, nga addaan iti Espiritu ti Dios?” ");
INSERT INTO iloulb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Isu a kinuna ti Faraon kenni Jose, “Agsipud ta impakita ti Dios kenka amin daytoy, awanen iti kas kenka iti kinasaririt ken kinasirib. ");
INSERT INTO iloulb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iturayamto ti balayko, ket agtungpalto kenka dagiti amin a tattaok. Iti laeng trono a nabilbilegak ngem sika.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kinuna ti Faraon kenni Jose, “Kitaem, isaadka iti entero a daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inikkat ti Faraon iti imana ti singsingna a nakitikitan iti marka ti pagarian ket inkabilna daytoy iti ramay ni Jose. Kinawesanna daytoy iti nalamuyot a lupot a lino, ken inukkoranna iti balitok a kuentas. ");
INSERT INTO iloulb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pinagluganna isuna iti maikadua a karwahena. Adda lallaki a nagpukkkaw iti sangoananna, “Agparintumengkayo.” Insaad isuna ti Faraon a mangituray iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kinuna ti Faraon kenni Jose, “Siak ti Faraon, ket malaksid kenka, awan ti siasinoman a tao a mangituray iti amin a daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pinanaganan ti Faraon ni Jose a “Zafenat Panea.” Intedna kenkuana ni Asenat a kas asawana, ti putot a babai ni Potifera a padi ti On. Inturayan ni Jose ti entero nga Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tallopulo ti tawen ni Jose idi nagtakder isuna iti sangoanan ti Faraon, nga ari ti Egipto. Rimmuar ni Jose manipud iti ayan ti Faraon, ket napan iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Iti uneg ti pito a tawen ti kinawadwad, adu ti naapit iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Inurnongna amin dagiti taraon iti uneg ti pito a tawen nga adda iti daga ti Egipto ket indulinna dagiti taraon kadagiti siudad. Indulinna iti tunggal siudad ti taraon a naapit kadagiti talon nga adda iti aglawlaw daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nagidulin ni Jose kadagiti bukbukel a kasla darat iti baybay ti kaaduna, kasta unay ti kaaduna ket urayna la insardeng iti panangbilbilang kadagitoy, gapu ta saanen a mabilang daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sakbay a dimteng dagiti tawen ti panagbisin, adda dua nga annak ni Jose, nga inyanak kenkuana ni Asenat, nga anak a babai ni Potifera a padi ti On. ");
INSERT INTO iloulb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Pinanaganan ni Jose ti inauna a putotna iti Manases, ta kinunana, tinulongannak ti Dios a nanglipat iti amin a pakariribukak ken amin a sangkabalayan ti amak. ");
INSERT INTO iloulb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Pinanagananna iti Efraim ti maikadua a putotna, ta kinunana, “Pinagbalinnak ti Dios a nabunga iti daga a nakaparigatak.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nagpatingga ti pito a tawen ti kinawadwad iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Nangrugi ti pito a tawen ti panagbisin, kas iti kinuna ni Jose. Adda panagbisin iti amin a daga, ngem adda taraon iti amin a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Idi adda panagbisin iti amin a daga ti Egipto, nagpakaasi dagiti tattao iti Faraon para iti taraon. Kinuna ti Faraon kadagiti amin a taga-Egipto, “Mapankayo kenni Jose ket aramidenyo ti ibagana.” ");
INSERT INTO iloulb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Adda panagbisin iti amin a paset ti entero a daga. Linukatan ni Jose dagiti amin a pagipenpenan ket inlakona kadagiti Egipcio. Nakaro ti panagbisin iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Um-umay ti amin a paset ti daga iti Egipto tapno gumatang iti bukbukel kenni Jose, gapu ta nakaro ti panagbisin iti amin a daga. ");
INSERT INTO iloulb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ita, naammoan ni Jacob nga adda bukel idiay Egipto. Kinunana kadagiti putotna a lallaki. “Apay ta agkikinnitakayo?” ");
INSERT INTO iloulb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kinunana, “Dumngegkayo, nangngegko nga adda bukel idiay Egipto. Sumalogkayo sadiay ket gumatangkayo iti agpaay kadatayo manipud sadiay tapno agbiagtayo a saan ket a matay.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Simmalog ngarud dagiti sangapulo a kakabsat ni Jose tapno gumatang iti bukel manipud iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ngem ni Benjamin a kabsat ni Jose ket saanna a pinasurot kadagiti kakabsatna, ta kinunana, “Amangan no adda dakes a mapasamak kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Immay met dagiti annak ni Israel tapno gumatang malaksid pay kadagiti immay, ta adda met panagbisin iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ita, ni Jose ti gobernador iti entero a daga. Isuna ti aglaklako kadagiti amin a tattao ti daga. Immay dagiti kakabsat ni Jose ket nagpaklebda iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Nakita ni Jose dagiti kakabsatna ket nabigbigna ida, ngem nagpammarang isuna kadakuada ken nagsao isuna iti nagubsang kadakuada. Kinunana kadakuada, “Sadinno ti naggapuanyo?” Kinunada, “Naggapukkami iti daga ti Canaan tapno gumatang iti taraon.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nabigbig ni Jose dagiti kakabsatna ngem saanda a nabigbig isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nalagip ni Jose dagiti tagtagainepna maipapan kadakuada. Kinunana kadakuada, “Espiakayo. Immaykayo tapno kitaenyo ti saan a naguardia-an a paset ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kinunada kenkuana, “Saan, apo. Immay dagitoy nga adipenmo a gumatang ti taraon. ");
INSERT INTO iloulb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Putotnakami amin ti maymaysa a tao. Mapagtalkankami a lallaki. Saan nga espia dagitoy adipenmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kinunana kadakuada, “Saan, ngem immaykayo tapno kitaenyo ti saan a naguardia-an a paset ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kinunada, “Sangapulo ket dua nga agkakabsat dagitoy adipenmo, putotnakami ti maysa a tao idiay daga ti Canaan. Kitaem, kadua ita ti amami ti inaudi a kabsatmi, ket awanen iti daytoy a biag ti maysa pay a kabsatmi.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kinuna ni Jose kadakuada, “Kas nakunakon; espiakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Babaen iti daytoy masubokkayo. Isapatak iti nagan ti Faraon a saankayo a pumanaw ditoy, malaksid no umay ditoy ti inaudi a kabsatyo. ");
INSERT INTO iloulb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mangibaonkayo iti maysa kadakayo ket mapanna alaen ti kabsatyo. Maibaludkayo tapno masubok dagiti imbagayo, no adda met laeng kinapudno kadakayo, ta no saan, isapatak iti nagan ti Faraon, awan duadua nga espiakayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ket imbaludna amin ida iti tallo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Iti maikatlo nga aldaw, kinuna ni Jose kadakuada, “Aramidenyo daytoy ket agbiagkayo, ta adda panagbutengko iti Dios. ");
INSERT INTO iloulb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","No mapagtalkankayo a lallaki, mabati ngarud ti maysa kadakayo iti daytoy a pagbaludan, ngem mapankayo, mangawitkayo kadagiti bukel para iti panagbisin kadagiti balbalayyo. ");
INSERT INTO iloulb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Iyegyo ti inaudi a kabsatyo kaniak iti kasta ket mapaneknekan dagiti imbagayo ket saankayo a matay.” Kasta ngarud ti inaramidda. ");
INSERT INTO iloulb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kinunada iti tunggal maysa, “Pudno a nagbidduttayo maipapan iti inaramidtayo iti kabsattayo ta nakitatayo ti ladingit ti kararuana idi nagpakaasi kadatayo ngem saantayo a dimngeg. Ngarud naisubli kadatayo daytoy a ladingit. ");
INSERT INTO iloulb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Simmungbat ni Ruben kadakuada, “Saan kadi nga imbagak kadakayo, 'Saankayo nga agaramid iti basol maibusor iti ubing,' ngem saankayonto met gamin a dimngeg? Ita kitaenyo, maisidsidirenkadatayo ti darana.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Saanda nga ammo a naawatan ida ni Jose, ta adda mangipatpatarus iti nagbabaetanda. ");
INSERT INTO iloulb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Pinanawanna ida ket nagsangit. Kalpsanna, nagsubli isuna iti ayanda ket nagsao kadakuada. Innalana ni Simeon kadakuada ket pinaibaludna iti imatangda. ");
INSERT INTO iloulb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ket binilin ni Jose dagiti adipenna a punoenda iti bukbukel dagiti sako dagiti kakabsatna, ken isublida ti kuarta ti tunggal maysa a lalaki iti sakona, ken ipaayanda ida iti kasapulanda iti panagdaliasatda. Kasta ngarud ti naaramid para kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Inkarga dagiti agkakabsat dagiti awitda a bukel kadagiti asnoda ket pimmanawda manipud sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Iti lugar a naginanaanda, maysa kadakuada ti nanglukat iti sakona tapno pakanenna ti asnona ket nakitana ti kuartana. Adda daytoy iti ngarab ti sakona. ");
INSERT INTO iloulb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kinunana kadagiti kakabsatna, “Naisubli ti kuartak. Kitaenyo daytoy; adda daytoy iti sakok.” Ket uray la agkibbakibbayo ti pusoda ken agpigpigergerda a nagkikinnita. Kinunada, “Ania daytoy nga inaramid ti Dios kadatayo?” ");
INSERT INTO iloulb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Napanda kenni Jacob nga amada nga adda iti daga ti Canaan ket imbagada kenkuana ti amin a napasamak kadakuada. Kinunada, ");
INSERT INTO iloulb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ti lalaki, nga apo ti daga ket sigugubsang a nakisarita kadakami ken impagarupna nga espiakami iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Imbagami kenkuana, 'Mapagtalkankami a lallaki. saankami nga espia. ");
INSERT INTO iloulb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sangapulo ket dua kami nga agkakabsat, putotnakami ti amami. Natayen ti maysa kadakami ken ti inaudi a kabsatmi ket adda ita iti ayan ti amami idiay daga ti Canaan.' ");
INSERT INTO iloulb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ti lalaki nga apo ti daga, kinunana kadakami, 'Babaen iti daytoy ket maammoak no mapagtalkankayo a lallaki. Ibatiyo ti maysa a kabsatyo kaniak, mangalakayo iti bukel para iti panagbisin kadagiti balayyo, ket mapankayo. ");
INSERT INTO iloulb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Iyegyo ti inaudi a kabsatyo kaniak. Iti kasta ket mapaneknekak a saankayo nga espia, ngem ketdi, mapagtalkankayo a lallaki. Ket wayawayaakto ti kabsatyo ket mabalinkayo a gumatang ken aglako iti daytoy a daga.”' ");
INSERT INTO iloulb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Napasamak nga idi imbukbokda dagiti sakoda ket adtoy, adda iti sako ti tunggal maysa ti nakasupot a kuartada. Idi nakitada ken ti amada dagiti nakasupot a kuartada, nagbutengda. ");
INSERT INTO iloulb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kinuna ti amada a ni Jacob, kadakuada, “Pinagladingitdak kadagiti putotko. Natayen ni Jose, awanen ni Simeon ken iyadayoyo ni Benjamin. Maibusor kaniak amin dagitoy a banbanag.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nagsao ni Ruben iti amana, a kunana, “Uray patayemto dagiti dua a putotko a lallaki no saanko a maisubli ni Benjamin kenka. Italekmo isuna kaniak ket isublikto isuna kenka.” ");
INSERT INTO iloulb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kinuna ni Jacob, “Saan a sumurot a sumalog kadakayo ti anakko. Ta natayen ti kabsatna ket isuna laengen ti nabati. No adda dakes a mapasamak kenkuana iti dalanyo, ipandakto, siak a purawen ti buokna, iti sheol gapu iti ladingit.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nakaro ti panagbisin iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Napasamak nga idi nakandan ti bukbukel nga insangpetda manipud idiay Egipto, ket kinuna ti amada kadakuada, “Mapankayo manen; gumatangkayo iti taraontayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Imbaga ni Juda kenkuana, “Nainget iti panangballaag kadakami ti lalaki, 'Saanyonto a makita ti rupak malaksid no kaduayo ti kabsatyo.' ");
INSERT INTO iloulb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","No paikuyogmo kadakami ti kabsatmi, sumalogkami ket igatangandaka iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ngem no saanmo a kayat nga isurotmi isuna, saankami a sumalog. Ta imbaga ti lalaki kadakami, “Saanyonto a makita ti rupak malaksid no kaduayo ti kabsatyo.”' ");
INSERT INTO iloulb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kinuna ni Israel, “Apay a pinagaramidandak iti saan a nasayaat babaen iti panangibagayo iti lalaki nga adda pay sabali a kabsatyo? ");
INSERT INTO iloulb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kinunada, “Nagsaludsod ti lalaki maipanggep kadakami ken iti pamiliatayo. Kinunana, 'Sibibiag pay kadi ti Amayo? Adda pay kadi sabali a kabsatyo?' Sinungbatanmi isuna segun kadagitoy a salsaludsod. Ammomi aya ngarud met nga ibagana nga, 'Itugotyo ditoy ti kabsatyo?'” ");
INSERT INTO iloulb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kinuna ni Juda kenni Israel nga amana, “Italekmo kaniak ti ubing. Agrubbuatkamin a mapan tapno agbiagtayo a saan ket a matay, datayo, sika ken kasta met dagiti annaktayo. ");
INSERT INTO iloulb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Siak ti makaammo kenkuana. No saanko isuna a maisubli kenka ken maidatag iti sangoanam, uray siak lattan ti mangawit iti pammabasol iti agnanayon. ");
INSERT INTO iloulb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ta no saankami koma a nataktak, awan dua-dua a kapaminduami koman ita a nagsubli ditoy. ");
INSERT INTO iloulb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kinuna ti amada a ni Israel kadakuada, “No kasta ngarud, ita, kastoy ti aramidenyo.” Mangalakayo kadagiti kasayaatan a napataud iti daga ket ikabilyo kadagiti sakoyo. Mangitugotkayo iti sagut para iti lalaki: sangkabassit a resina ken diro, kadagiti rekado ken mira, piniones ken almendras. ");
INSERT INTO iloulb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Paminduaenyo ti gatad ti kuarta nga itugotyo. Itugotyo manen ti kuarta a naisubli kadagiti sakoyo. Nalabit a biddut laeng daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Isurotyo pay ti kabsatyo. Agrubbuatkayo ket mapankayo manen iti lalaki. ");
INSERT INTO iloulb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sapay koma ta ited ti Dios a Mannakabalin amin ti asi kadakayo iti sangoanan ti Lalaki, tapno wayawyaanna kadakayo ti sabali pay a kabsatyo ken kasta met ni Benjamin. No mapukawko dagiti annakko. Mapukawanak ngarud.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Innala dagiti lallaki dayta a sagut. Nangalada iti mamindua a kaadu ti kuartada ken insurotda ni Benjamin. Nagrubbuatda, simmalogda idiay Egipto, ket dimmatagda iti sangoanan ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Idi nakita ni Jose a kaduada ni Benjamin, kinunana iti agay-aywan iti balayna, “Ikuyogmo dagiti lallaki idiay balay, mangpartika iti ayup ket isaganam daytoy, ta makipangan kaniak dagiti lallaki iti pangaldaw.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Inaramid ngarud ti mangay-aywan ti imbaga ni Jose. Impanna ngarud dagiti lallaki iti balay ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nagbuteng dagiti lallaki gapu ta naipanda iti balay ni Jose. Kinunada, “Gapu daytoy iti kuarta a naisubli kadagiti sakotayo idi immuna nga immaytayo, tapno mangbirok isuna iti gundaway a maibusor kadatayo. Mabalin a tiliwennatayo ken pagbalinennatayo a tagabu, ken alaenna dagiti asnotayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Immasidegda iti mangay-aywan iti balay ni Jose, ket kinatungtongda isuna iti ruangan ti balay, ");
INSERT INTO iloulb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","a kunada, “Apo, simmalogkami idi damdamo tapno gumatang iti makan. ");
INSERT INTO iloulb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ket napasamak nga idi nakadanonkami iti disso a paginanaan ket linuktanmi dagiti sakomi, ket, nakitami nga adda ti kuarta ti tunggal maysa iti ngarab iti sakona, awan iti naksay iti kuartami. Intugotmi daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nangitugotkami pay iti sabali a kuarta a paggatangmi iti taraon. Saanmi nga ammo no siasino iti nangikabil iti kuartami kadagiti sakomi.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kinuna ti mangay-aywan, “Kapia koma iti maadda kadakayo, saankayo nga agbuteng. Ti Diosyo ken ti Dios ti amayo siguro ti nangikabil iti kuarta kadagiti sakoyo. Naawatko dagiti kuartayo.” Impan ngarud ti mangay-aywan ni Simeon kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Pinastrek ti mangay-aywan dagiti lallaki iti uneg ti balay ni Jose, “Inikkanna ida iti danum, ket binuggoanda dagiti saksakada. Inikkanna iti makan dagiti asnoda. ");
INSERT INTO iloulb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Insaganada dagiti sagut a maipaay iti isasangpet ni Jose iti aldaw, ta nangngegda a manganda sadiay ");
INSERT INTO iloulb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Idi simmangpet ni Jose iti balayna, intugotda dagiti sagut nga adda kadakuada iti balay, ken nagrukobda iti daga iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Dinamagna ti kasasaadda a kinunana, “Nasalun-at kadi ti amayo, ti lakay nga ibagbagayo? Sibibiag pay kadi isuna?” ");
INSERT INTO iloulb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kinunada, “Nasalun-at ti amami nga adipenmo. Sibibiag pay isuna.” Nagparintumeng ken nagdumogda. ");
INSERT INTO iloulb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Timmangad isuna ket nakitana ni Benjamin a kabsatna, ti anak ti inana, kinunana,” Daytoy kadi iti inaudi a kabsatyo nga ibagbagayo kaniak?” Kinunana, “Paraburannaka koma ti Dios, anakko.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nagdardaras a rimmuar ni Jose iti siled ta kasta unay a natignay isuna maipanggep iti kabsatna. Nangsapul isuna iti lugar a pagsangitanna. Napan isuna iti siledna ket nagsangit sadiay. ");
INSERT INTO iloulb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nagdiram-us isuna sa rimmuar. Tinengngelna ti riknana, kinunana, “Idasaryo ti taraon.” ");
INSERT INTO iloulb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nagserbian dagiti adipen ni Jose nga is-isuna ken dagiti agkakabsat nga is-isuda. Nakipangan dagiti Egipcio sadiay nga is-isuda laeng gapu ta saan a mabalin a makipangan dagiti Egipcio iti tinapay kadagiti Hebreo, ta makarimon dayta kadagiti Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nagtugaw dagiti agkakabsat iti sangoananna, ti inauna segun iti pannakaiyanakna, ken iti inaudi segun iti kinaubingna. Nasdaaw dagiti lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nangted ni Jose iti taraon nga adda iti sangoananna. Ngem iti paset ni Benjamin ket maminlima ti kaaduna ngem iti naited kadagiti kakabsatna. Naginomda ken nakipagragsakda kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Binilin ni Jose ti mangay-aywan iti balayna, a kunana, “Kargaam dagiti sako dagiti lallaki iti taraon, segun iti kabaelanda nga awiten, ken ikabilmo ti kuarta ti tunggal maysa a lalaki iti ngarab dagiti sakoda. ");
INSERT INTO iloulb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ikabilmo ti kopak, ti pirak a kopa, iti ngarab ti sako ti inaudi, ken kasta met ti kuartana a bayad ti bukel.” Inaramid ngarud ti mangay-aywan ti imbaga ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Lumawlawagen iti bigat, ket napalubosan a pumanaw dagiti lallaki, isuda ken dagiti asnoda. ");
INSERT INTO iloulb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Idi nakaruardan iti siudad ngem saanda pay a nakaadayo, imbaga ni Jose iti mangay-aywan, “Tumakderka, kamatem dagiti lallaki, ket no makamatam ida, ibagam kadakuada, “ Apay a sinubadanyo iti dakes ti naimbag? ");
INSERT INTO iloulb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Apay a tinakawyo ti kopa a pagin-inuman ti apok, nga ar-aramatenna metlaeng nga agbuyon? Nakaaramidkayo iti dakes, gapu iti daytoy a banag a naaramidanyo.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Nakamatan ida ti mangay-aywan ket insaona dagitoy a sasao kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kinunada kenkuana, “Apay ta agsasao ti apok iti nalabes a sasao a kas kadagitoy? Adayo nga aramiden dagiti adipenmo daytoy a banag. ");
INSERT INTO iloulb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kitaem, ti kuarta a nasarakanmi kadagiti ngarab ti saksakomi, inyegmi manen kadakayo manipud iti daga ti Canaan. Kasano ngarud nga agtakawkami ti pirak ken balitok iti balay ni amom? ");
INSERT INTO iloulb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","No siasino kadagiti adipenmo iti pakasarakanna, uray matay isuna, ken dakami met ket agbalin a tagabu iti apok.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Imbaga ti mangay-aywan, “Ita ngarud, mapasamak koma a kas kadagiti imbagam. No siasino iti pakasarakan ti kopa, agbalin isuna a tagabuk, ket dakayo a dadduma, saankayo a mairaman.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kalpasanna, pinartakan ti tunggal maysa nga imbaba dagiti sakoda, ket linukatan ti tunggal maysa dagiti sakoda. ");
INSERT INTO iloulb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nagbiruk ti mangay-aywan. Rinuggianna iti kalakayan ket lineppasna iti kaubingan, ket nasarakanna ti kopa iti sako ni Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Rinay-abda dagiti kawesda. Nagsakay ti tunggal lalaki iti asnona ket nagsublida iti siudad. ");
INSERT INTO iloulb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Immay ni Juda ken dagiti kakabsatna iti balay ni Jose, adda pay laeng isuna sadiay, ket nagpaklebda iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kinuna ni Jose kadakuada, “Ania daytoy a naaramidyo? Saanyo kadi nga ammo nga iti lalaki a kas kaniak ket agbuybuyon?” ");
INSERT INTO iloulb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kinuna ni Juda, “Ania iti maibagami kenka apo? Ania iti isaomi? Wenno kasanomi nga ikalintegan dagiti bagbagimi? Naduktalan ti Dios ti basol dagiti adipenmo. Kitaenyo, dakami ket tagabum apo, dakami amin agraman ti nakasarakan iti kopa.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kinuna ni Jose, “Adayo a maaramidko ti kasta. Ti laeng lalaki a nakasarakan ti kopa ti agbalin a tagabuk, ngem dakayo a dadduma, sumang-atkayo a sitatalna iti ayan ti amayo.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ket immasideg ni Juda kenkuana ket kinunana, “Apo, pangngaasim, bay-am koma nga agsao daytoy adipenmo ket denggem koma, ken saanka koma a makaunget iti adipenmo, ta sika ket kas iti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nagsaludsod ti apok kadagiti adipenna, kunana, 'Adda kadi amayo wenno kabsatyo a lalaki?' ");
INSERT INTO iloulb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ket kinunami kenka apo, “Addaan pay iti amami, lakayen isuna, ken adda maysa a putotna iti kinalakayna, maysa nga ubing. Ket natayen ti kabsatna a lalaki, ken is-isuna laengen iti nabati nga anak ti inana, ket ay-ayaten unay isuna iti amana.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ket imbagam kadagiti adipenmo, 'Iyegyo isuna kaniak tapno makitak isuna.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ket kinunami kenka apo, 'Saan a mabalin a panawan ti ubing ti amana. Ta no panawanna ti amana, matay ti amana.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ket kinunam kadagiti adipenmo, 'Malaksid a kaduayo a sumalog ti kabsatyo a lalaki, saanyonto a makita manen ti rupak.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ket napasamak nga idi napankami iti adipenmo nga amak, imbagami kenkuana ti insaom apo. ");
INSERT INTO iloulb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ket kinuna ti amami, 'Mapankayo manen gumatang iti taraontayo.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ket kinunami, 'Saankami a makapan. Mapankami no kaduami ti inaudi a kabsatmi, ta saankami a mabalin a sumango iti lalaki malaksid no kaduami ti inaudi a kabsatmi.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kinuna kadakami ti adipenmo nga amak, 'Ammoyo met nga inikkannak laeng iti dua nga annak a lallaki ti asawak. ");
INSERT INTO iloulb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ket napukaw ti maysa kaniak ket kinunak, “Sigurado a narangkarangkayen isuna, ket saankon a nakita pay isuna manipud idi.” ");
INSERT INTO iloulb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ket no alaenyo pay daytoy maysa kaniak ket adda iti saan a nasayaat a mapasamak kenkuana, ipandakto, siak a purawen ti buokna, iti sheol gapu iti ladingit. ");
INSERT INTO iloulb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ita, ngarud, no mapanak iti adipenmo nga amak, ket saanmi a kadua ti barito, agsipud ta ti biagna ket naisinggalut iti biag ti ubing, ");
INSERT INTO iloulb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","mapasamakto nga inton makitana a saanmi a kadua ti ubing, ket matayto isuna. Ket dakaminto nga adipenmo ti pakaigapuan iti panagladingitna a mangipan kenkuana iti sheol.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ta nagkari daytoy adipenmo iti amami maipapan iti ubing, a kinunana, 'No saanko a maisubli isuna kenka, uray siakton ti mangawit iti pammabasol ti amak iti agnanayon.' ");
INSERT INTO iloulb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Isu nga ita, pangngaasim ta ipalubosmo koma a daytoy nga adipenmo ti mabati a kas tagabu kenka apo, a saan ket a ti ubing, ket ipalubosmo koma a sumang-at ti ubing a kaduana dagiti kakabsatna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ta ania ngay ti rupak a mapan iti amak no saanko a kadua ti ubing? Mabutengak a makita ti dakes a mabalin a mapasamak iti amak.” ");
INSERT INTO iloulb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ket saan a nalapdan ni Jose ti bagina iti sangoanan dagiti amin nga adipen a nakatakder iti abayna. Kinunana iti napigsa, “Panawandak, dakayo amin.” Awan iti adipen a nagtalinaed a nakatakder iti abay ni Jose idi inyam-ammona ti bagina kadagiti kakabsatna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nagsangit iti napigsa, nangngeg dagiti Egipcio daytoy, ken nangngeg iti balay ti Faraon daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kinuna ni Jose kadagiti kakabsatna, “Siak ni Jose. Sibibiag pay kadi ti amak?” Saan a masungbatan dagiti kakabsatna isuna, ta naklaatda iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ket kinunana ni Jose kadagiti kakabsatna, “Pangngaasiyo ta umasidegkayo kaniak.” Immasidegda. Kinunana, “Siak ni Jose a kabsatyo, nga inlakoyo ditoy Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ket ita, saankayo nga agladingit wenno makaunget kadagiti bagbagiyo iti panangilakoyo kaniak ditoy, ta imbaonnak ti Dios nga immuna kadakayo tapno maisalbar ti biag. ");
INSERT INTO iloulb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ta iti daytoy dua a tawen, adda panagbisin iti daga, ket adda pay lima a tawen nga awanto iti agarado wenno agapit. ");
INSERT INTO iloulb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Imbaonnak ti Dios nga immuna kadakayo tapno maisalakankayo ken dagiti kaputotanyo, ken tapno maisalbarkayo ket adu kadakayo iti makalasat. ");
INSERT INTO iloulb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ita ngarud, saan a dakayo iti nangibaon kaniak ditoy no di ket ti Dios, ken pinagbalinnak a kasla ama iti Faraon, apo ti amin a balayna, ken mangituray iti amin a daga iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Agalistokayo a mapan iti ayan ti amak ket ibagayo kenkuana, 'Daytoy ti imbaga ti anakyo a ni Jose, Pinagbalinnak ti Dios nga apo iti amin nga Egipto. Umayka kaniak, saanka nga agtaktak. ");
INSERT INTO iloulb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Agnaedkanto iti daga ti Gosen, ket asidegkanto kaniak, sika ken dagiti annakmo ken dagiti annak dagiti annakmo, ken dagiti arbanyo, ken amin nga adda kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ipaaykonto amin a kasapulanyo sadiay, ta adda pay lima a tawen ti panagbisin, tapno saanka nga agbisin, sika, ti sangakabalayam, ken amin nga adda kenka.' ");
INSERT INTO iloulb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kitaenyo, makita dagiti matayo, ken iti mata ti kabsatko a ni Benjamin, a ngiwatko ti agsasao kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ibagayo iti amak ti amin maipanggep iti kinaturayko iti Egipto, ken amin a nakitayo, Agalistokayo a mangiyeg iti amak ditoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Inarakopna ti tengnged ti kabsatna a ni Benjamin ken nagsangit, ket nagsangit met ni Benjamin iti tengngedna. ");
INSERT INTO iloulb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Inagkanna amin dagiti kakabsatna ket nagsangit kadakuada. Kalpasan dayta, nakisarita dagiti kakabsatna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Naipadamag dayta a banag iti balay ti Faraon: “Immay dagiti kakabsat ni Jose.” Naragsakan ti Faraon ken dagiti adipen iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kinuna ti Faraon kenni Jose, “Ibagam kadagiti kakabsatmo, 'Kastoy ti aramidenyo: Paawitanyo dagiti ayupyo ket mapankayo iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Alaenyo ti amayo ken dagiti sangkabalayanyo ket umaykayo kaniak. itedkonto kadakayo ti kasayaatan a daga ti Egipto, ket mangankayonto iti patauden ti daga.' ");
INSERT INTO iloulb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ita ibilinko pay kenka nga ibagam ti kastoy, 'Aramidenyo daytoy, mangiruarkayo kadagiti kariton manipud iti daga ti Egipto para kadagiti annakyo ken para kadagiti assawayo. Alaenyo ti amayo ket umaykayo. ");
INSERT INTO iloulb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Saanyo a pakaseknan ti maipanggep kadagiti sanikuayo, ta kukuayo ti kasayaatan iti amin a daga iti Egipto.'” ");
INSERT INTO iloulb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kasta ngarud ti inaramid dagiti putot a lallaki ni Israel. Inikkan ida ni Jose kadagiti kariton, segun iti bilin ti Faraon, ken inikkanna ida iti balon a para iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Kadakuada amin, nangted isuna iti tunggal lalaki iti pagsukatan a bado, ngem kenni Benjamin, nangted isuna iti tallo gasut a pidaso ti pirak ken lima a pagsukatan a bado. ");
INSERT INTO iloulb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Para iti amana, impatulodna dagitoy: Sangapulo nga asno a napaawitan kadagiti kasayaatan a banbanag iti Egipto; ken sangapulo a kabaian nga asno a napaawitan iti bukbukel, tinapay, ken dadduma a kasapulan a maipaay iti amana, iti panagdaliasatna. ");
INSERT INTO iloulb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Imbaonna ngarud dagiti kakabsatna ket pimmanawda. Kinunana kadakuada, “Kitaenyo ta amangan no agaapakayo iti panagdaliasatyo.” ");
INSERT INTO iloulb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Rimmuarda iti Egipto ket dimtengda iti daga ti Canaan, kenni Jacob nga amada. ");
INSERT INTO iloulb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Imbagada kenkuana a kunada, “Sibibiag pay ni Jose, ken isuna ti mangiturturay iti amin a daga iti Egipto.” Ket kasta unay ti siddaaw ti pusona, ta saan a mamati kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Imbagada kenkuana amin dagiti sasao nga imbaga ni Jose kadakuada. Idi nakita ni Jacob kadagiti kariton nga impatulod ni Jose a mangilugan kenkuana, naparegta ti espiritu ti amada a ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kinuna ni Israel, “Naan-anayen. Sibibiag pay ti anakko a ni Jose. Mapanko kitaen isuna sakbay a matayak.” ");
INSERT INTO iloulb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nagdaliasat ni Israel a kaduana amin nga adda kenkuana ket napan idiay Beersheba. Sadiay, nangidaton isuna kadagiti datdaton iti Dios ti amana a ni Isaac. ");
INSERT INTO iloulb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nagsao ti Dios kenni Israel iti maysa a sirmata iti karabianna, a kunana, “Jacob, Jacob.” ");
INSERT INTO iloulb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kinunana, “Adtoyak.” Kinuna met ti Dios, “Siak ti Dios, ti Dios ti amam. Saanka nga agbuteng a sumalog idiay Egipto, ta sadiay, pagbalinenkanto a dakkel a nasion. ");
INSERT INTO iloulb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kumuyogakto kenka a mapan idiay Egipto, ket siguradoek kenka nga isublikanto metlaeng. Ket pakidimento ni Jose dagiti matam iti bukodna nga ima.” ");
INSERT INTO iloulb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Nagrubwat manipud Beersheba ni Jacob. Indaliasat dagiti annak ni Israel ni Jacob nga amada, dagiti annakda, ken dagiti assawada, kadagiti kariton nga impatulod ti Faraon a mangilugan kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Innalada dagiti tarakenda ken dagiti sanikuada a napaaduda iti daga ti Canaan. Dimtengda idiay Egipto, ni Jacob ken dagiti amin a kaputotanna a kimmuyog kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Intugotna idiay Egipto dagiti putotna a lallaki ken dagiti putot a lallaki dagiti putotna ken dagiti putotna a babbai, ken dagiti putot a babbai dagiti putotna a lallaki, ken dagiti amin a kaputotanna. ");
INSERT INTO iloulb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dagitoy dagiti nagnagan dagiti annak ni Israel a dimteng idiay Egipto, ni Jacob ken dagiti putotna: Ni Ruben nga inauna a putot ni Jacob; ");
INSERT INTO iloulb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","dagiti putot a lallaki ni Ruben a da Hanoc, Pallu, Hezron ken Carmi; ");
INSERT INTO iloulb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","dagiti lallaki a putot ni Simeon, a da Jemuel, Jamin, Ohad, Jakin, Zohar ken Saul nga anak ti maysa a babai a taga-Canaan, ");
INSERT INTO iloulb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","dagiti putot a lallaki ni Levi, a da Gerson, Cohat, ken Merari; ");
INSERT INTO iloulb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","dagiti lallaki a putot ni Juda: da Er, Onan, Selah, Perez kenni Zera (ngem natay ni Er kenni Onan idiay daga ti Canaan. Ken dagiti putot a lallaki ni Perez ket da Hezron ken Hamul); ");
INSERT INTO iloulb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","dagiti lallaki a putot ni Issacar: da Tola, Pua, Yob ken Simron; ");
INSERT INTO iloulb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Dagiti lallaki a putot ni Zabulon: Da Sered, Elon ken Jaleel ");
INSERT INTO iloulb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(dagitoy dagiti annak a lallaki ni Lea nga inyanakna kenni Jacob idiay Padan-aram, ken ti anakna a babai a ni Dina. Tallo pulo ket tallo amin dagiti putotna a lallaki ken babbai); ");
INSERT INTO iloulb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","dagiti lallaki a putot ni Gad ket da Zifion, Aggi, Suni, Ezbon, Eri, Arodi ken Areli; ");
INSERT INTO iloulb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","dagiti lallaki a putot ni Aser ket da Imma, Isva, Isvi, ken Beria, ken ni Sera a kabsatda a babai; ken dagiti putot a lallaki ni Bereiah ket da Heber ken Malkiel ");
INSERT INTO iloulb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(dagitoy dagiti annak a lallaki ken appoko ni Zilpa a babaonen nga inted ni Laban ken ni Lea nga anakna. Dagitoy dagiti inyanak ni Zilpa kenni Jacob, sangapulo ket innem a tattao amin); ");
INSERT INTO iloulb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","dagiti annak a lallaki ni Raquel nga asawa ni Jacob—ni Jose ken ni Benjamin; ");
INSERT INTO iloulb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","(pinutot ni Jose iti daga ti Egipto ni Manases ken ni Efraim, nga inyanak ni Asenat, a putot a babai ni Potifera a padi ti On,); ");
INSERT INTO iloulb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","dagiti putot a lallaki ni Benjamin ket da Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros Muppin, Huppin ken Ard ");
INSERT INTO iloulb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(dagitoy dagiti annak a lallaki ni Raquel a naiyanakna ken ni Jacob kasta met dagiti appokona. Sangapulo ket uppatda amin); ");
INSERT INTO iloulb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ti lalaki a putot ni Dan ket ni Husim; ");
INSERT INTO iloulb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","dagiti lallaki a putot ni Neftali ket da Jazeel, Guni, Jeser ken Sillem ");
INSERT INTO iloulb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(dagitoy dagiti annak a lallaki ni Bilha nga adipen, nga inted ni Laban kenni Raquel nga a babai putotna. Dagitoy dagiti inyanakna kenni Jacob ken dagiti appokona. Pito amin ti bilang dagitoy a tattao). ");
INSERT INTO iloulb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Amin dagiti tattao a simmurot kenni Jacob idiay Egipto, a kaputotanna, malaksid kadagiti assawa dagiti lallaki a putot ni Jacob—innem a pulo ket innem ti bilang amin dagitoy a tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Dagiti lallaki a putot ni Jose a pinutotna idiay Egipto ket dua ti bilangna. Pito pulo amin ti bilang dagiti tattao iti balay ni Jacob a napan idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Pinauna ni Jacob ni Juda a mapan kenni Jose tapno isurona kadakuada ti dalan nga agturong idiay Gosen, ket dimtengda iti daga ti Gosen. ");
INSERT INTO iloulb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Insagana ni Jose ti karwahena ket napanna sinabat ni Israel nga amana idiay Gosen. Nakitana isuna, inarakupna ti tengngedna, ket nagsangit iti tengngedna iti nabayag. ");
INSERT INTO iloulb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kinuna ni Israel kenni Jose, “Ita, uray matayakon, agsipud ta nakitakon ti rupam, a sibibiag ka pay.” ");
INSERT INTO iloulb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kinuna ni Jose kadagiti kakabsatna a lallaki ken iti balay ti amana, “Mapanak ket ibagak iti Faraon, a kunak, 'Dagiti kakabsatko ken ti balay ni amak, nga adda iti daga ti Canaan ket immay kaniak. ");
INSERT INTO iloulb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Agpaspastor dagiti lallaki, ta isuda ket agtartaraken kadagiti ayup. Intugotda dagiti arbanda, ken amin nga adda kadakuada.' ");
INSERT INTO iloulb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mapasamakto nga inton paayabannakayo ti Faraon ket damagenna, 'Ania ti trabahoyo?' ");
INSERT INTO iloulb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ibagayonto, 'Agay-aywan dagitoy nga adipenmo kadagiti arban manipud pay kinaubingmi aginggana ita, dakami, ken dagiti kapuonanmi.' Aramidenyo daytoy tapno mabalinyo ti agnaed iti daga ti Gosen, ta tunggal agpaspastor ket makarimon kadagiti Egipcio.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Kalpasanna, napan ni Jose ket imbagana iti Faraon, “Simmangpet ti amak, ken dagiti kakabsatko, dagiti arbanda ken amin a kukuada manipud iti daga ti Canaan. Addada ita idiay daga ti Gosen.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Insurotna ti lima kadagiti kakabsatna ket inyam-ammona ida iti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kinuna ti Faraon kadagiti kakabsatna, “Ania ti trabahoyo?” Kinunada iti Faraon, “Agpaspastor dagiti adipenmo, kas kadagiti kapuonanmi.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ket kinunada iti Faraon, “Immaykami kas saan nga agpaut nga agnaed iti daga. Awan ti pagpastoran para kadagiti arban dagiti adipenmo, gapu ta nakaro unay ti panagbisin iti daga ti Canaan. Isu nga ita, pangaasim ta palubosam nga agnaed dagiti adipenmo iti daga ti Gosen.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kalpasanna, nagsao ti Faraon kenni Jose, kunana, “Immay ti amam ken dagiti kakabsatmo kenka. ");
INSERT INTO iloulb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Adda iti sangoanam ti daga ti Egipto. Pagnaedem ti amam ken dagiti kakabsatmo a lallaki iti kasayaatan a rehion, ti daga ti Gosen. No adda ammom a siasinoman a lallaki nga addaan iti kabaelan kadakuada, isaadmo ida nga agaywan kadagiti dingwenko.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kalpasanna, intugot ni Jose ni Jacob nga amana ket imparangna iti Faraon. Binendisionan ni Jacob ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kinuna ti Faraon kenni Jacob, “Kasanon kaatiddug ti panagbiagmo?” ");
INSERT INTO iloulb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kinuna ni Jacob iti Faraon, “130 dagiti tawen a panagdaldaliasatko. Bassit laeng ken nakas-ang dagiti tawen ti panagbiagko. Saan nga atiddug a kas iti kaatiddug ti panagbiag dagiti kapuonak.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kalpasanna, binendisionan ni Jacob ti Faraon ket pimmanaw iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kalpasanna, inaywanan ni Jose ti amana ken dagiti kakabsatna. Inikkanna ida ti masakupan iti daga ti Egipto, ti kasasayaatan iti daga, iti daga ti Rameses, kas imbilin ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nangipaay ni Jose iti taraon a maipaay iti amana, kadagiti kakabsatna, ken amin a sangkabalayan ti amana, segun iti bilang dagiti bibiagenda. ");
INSERT INTO iloulb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ita, awan taraon iti amin a daga; ta nakaro unay ti panagbisin. Nakakaasi ti daga ti Egipto ken ti daga ti Canaan gapu iti panagbisin. ");
INSERT INTO iloulb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Inurnong ni Jose ti amin a kuarta nga adda iti daga ti Egipto ken iti daga ti Canaan, babaen ti panaglaklakona iti trigo kadagiti agnanaed. Ket impan ni Jose ti kuarta iti palasio ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Idi naibusen ti amin a kuarta dagiti daga ti Egipto ken Canaan, immay amin a taga-Egipto kenni Jose a kunkunada, “Ikkandakami iti taraon! Rumbeng kadi a mataykami lattan iti imatangmo gapu ta naibusen ti kuartami?” ");
INSERT INTO iloulb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kinuna ni Jose, “No naibusen ti kuartayo, iyegyo dagiti tarakenyo ket ikkankayonto iti taraon a kas sukat dagiti tarakenyo.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Inyegda ngarud kenni Jose dagiti tarakenda. Inikkan ida ni Jose iti taraon a kas sukat dagiti kabalio, dagiti arban, ken dagiti asno. Pinakanna ida iti tinapay a kas sukat ti amin a tarakenda iti dayta a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Idi agleppasen dayta a tawen, napanda kenkuana iti sumaruno a tawen ket kinunada kenkuana, “ Saanmi nga ilimed iti apomi a naibusen ti kuartami, ken kukuan ti apomi dagiti tarakenmi. Awanen a pulos ti nabati iti imatang ti apomi, malaksid kadagiti bagimi ken dagami. ");
INSERT INTO iloulb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Rumbeng kadi a mataykami lattan iti sangoanam, dakami ken ti dagami? Gatangendakami ken ti dagami a kas kasukat iti taraon, ket agbalinkaminto nga adipen ti Faraon, dakami ken ti dagami. Ikkandakami iti bukel tapno agbiagkami a saan ket a matay, ken tapno saan koma nga agbalin a langalang ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ginatang ngarud amin ni Jose ti amin a daga iti Egipto para iti Faraon. Ta inlako ti tunggal Egipcio ti talonna, gapu ta nakaro unay ti panagbisin. Iti kastoy a wagas, nagbalin a kukua ti Faraon ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","No maipanggep met kadagiti tattao, pinagbalinna ida a tagabu manipud iti pagpatinggaan ti beddeng ti Egipto agingga iti kasumbangir a pagpatinggaan. ");
INSERT INTO iloulb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ti laeng daga dagiti papadi ti saan a ginatang ni Jose, gapu ta naikkan dagiti papadi iti abasto. Nanganda manipud iti bingay nga it-ited ti Faraon kadakuada. Isu a saanda nga inlako ti dagada. ");
INSERT INTO iloulb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kalpasanna, kinuna ni Jose kadagiti tattao, “Kitaenyo, ginatangkayo ken ti dagayo ita para iti Faraon. Ita, adtoy ti bukel para kadakayo, ket mulaanyonto ti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Iti panagaapit, masapul nga itedyo ti apagkalima iti Faraon ket kukuayonto ti uppat a paset, mausar daytoy kas bin-i para iti talon ken taraon dagiti sangkabalayanyo ken dagiti annakyo.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kinunada, “Inispalmo dagiti biagmi. Makasarakkami koma iti pabor kadagiti matam. Agbalinkami nga ad-adipen ti Faraon.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Inaramid ngarud daytoy ni Jose a linteg a maipatpatungpal iti daga ti Egipto agingga kadagitoy nga aldaw, a kukua ti Faraon ti apagkalima. Ti laeng daga dagiti papadi ti saan a nagbalin a kukua ti Faraon. ");
INSERT INTO iloulb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nagnaed ngarud ni Israel iti daga ti Egipto, iti daga ti Gosen. Nakagun-od dagiti tattaona kadagiti sanikua sadiay. Nagbunga ken immaduda iti kasta unay. ");
INSERT INTO iloulb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nagnaed ni Jacob iti daga ti Egipto iti sangapulo ket pito a tawen, isu a sangagasut uppat a pulo ket pito ti tawen ti panagbiag ni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Idi umadanin ti tiempo nga ipapatay ni Israel, inayabanna ni Jose nga anakna ket kinunana kenkuana, “No nakasarakak ita ti pabor iti imatangmo, ikabilmo ta imam iti sirok ti luppok, ket ipakitam kaniak iti kinapudno ken kinamapagtalkan. Pangaasim ta saannak nga itabon ditoy Egipto. ");
INSERT INTO iloulb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Inton pumusayak, ipanawnakto iti Egipto ket itabonnak iti disso a nakaitaneman dagiti ammak.” Kinuna ni Jose, “Aramidekto ti kas iti imbagam.” ");
INSERT INTO iloulb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kinuna ni Israel, “Agsapataka kaniak,” ket nagsapata ni Jose kenkuana. Kalpasanna, nagdumog ni Israel iti uloanan ti pagiddaanna. ");
INSERT INTO iloulb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ket napasamak a kalpasan dagitoy a banbanag, nga adda maysa a nangibaga kenni Jose, “Kitaem, masakit ti amam.” Isu nga intugotna dagiti dua nga annakna, a da Manases ken Efraim. ");
INSERT INTO iloulb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Idi nabagaan ni Jacob, “Kitaem, simmangpet ni Jose a putotmo a mangsarungkar kenka,” Pimmigsa ni Israel ket nagtugaw iti pagiddaan. ");
INSERT INTO iloulb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Kinuna ni Jacob kenni Jose, “Nagparang kaniak ti Dios a Mannakabalin-amin idiay Luz iti daga ti Canaan. Binendisionannak ");
INSERT INTO iloulb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","a kinunana kaniak, 'Kitaem, pagbalinenkanto a nabunga, ken paaduenkanto. Pagbalinenkanto a pagtaudan dagiti nasnasion. Itedkonto daytoy a daga kadagiti kaputotam kas agnanayon a sanikuada.’ ");
INSERT INTO iloulb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ket ita, dagiti dua a putotmo, a naiyanak kenka iti daga ti Egipto sakbay nga immayak kenka iti Egipto, ket kukuak. Kukuakto da Efraim ken Manases, a kas kada Ruben ken Simeon a kukuak metlaeng. ");
INSERT INTO iloulb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kukuamto dagiti annak a maadda kenka kalpasanda; mailistadanto kadagiti nagan dagiti kakabsatda iti tawidda. ");
INSERT INTO iloulb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ngem no maipapan kaniak, bayat nga agdaldaliasatak manipud idiay Padan, nagladingitak gapu iti pannakatay ni Raquel iti dalan iti daga ti Canaan, kabayatan nga adayokami pay laeng iti Efrata. Intabonko isuna sadiay iti dalan a mapan ti Efrata (dayta ket Betlehem).” ");
INSERT INTO iloulb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Idi nakita ni Israel dagiti annak ni Jose, kinunana, “Siasino dagitoy?” ");
INSERT INTO iloulb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kinuna ni Jose iti amana, “Putotko ida, inted ida ti Dios kaniak ditoy.” Kinuna ni Israel, “Iyegmo ida kaniak, tapno mabendisionak ida.” ");
INSERT INTO iloulb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ita, kumapuyen dagiti mata ni Israel gapu iti kinalakayna, isu a saanen a makakita. Isu nga inyasideg ida ni Jose kenkuana, ket inagkan ken inarakupna ida. ");
INSERT INTO iloulb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Kinuna ni Israel kenni Jose, “Saanko a pulos a ninamnama a makitak manen ti rupam, ngem impalubos pay kaniak ti Dios a makitak dagiti annakmo.” ");
INSERT INTO iloulb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Impan ida ni Jose iti nagbaetan dagiti tumeng ni Israel, ket kalpasanna nagparintumeng nga indumogna ti rupana iti daga. ");
INSERT INTO iloulb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Innala ni Jose dagiti dua, ni Efraim iti makannawanna a makannigid ni Israel, ken ni Manases iti makannigidna a makannawan ni Israel, ket inyasidegna ida kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Inggaw-at ni Israel ti kannawan nga imana ken impatayna iti ulo ni Efraim, nga inaudi, ken ti kannigid nga imana iti ulo ni Manases. Pinagkurosna dagiti imana, ta ni Manases ti inauna. ");
INSERT INTO iloulb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Binendisionan ni Israel ni Jose, a kunana, “Ti Dios a nagtultulnogan dagiti ammak a ni Abraham ken ni Isaac, ti Dios a nangay-aywan kaniak inggana ita nga aldaw, ");
INSERT INTO iloulb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ti anghel a nangsalsalaknib kaniak manipud iti amin a peggad, bendisionanna koma dagitoy nga ubbing. Maipanagan koma ti naganko kadakuada, ken ti nagan dagiti ammak a da Abraham ken Isaac. Umaduda koma iti rabaw ti daga.” ");
INSERT INTO iloulb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Idi nakita ni Jose nga impatay ti amana ti kannawan nga imana iti ulo ni Efraim, saanna a nagustuan daytoy. Innalana ti ima ti amana tapno iyakarna manipud iti ulo ni Efraim ket inturongna iti ulo ni Manases. ");
INSERT INTO iloulb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kinuna ni Jose iti amana, “Saan a kasta, amak; ta daytoy ti inauna. Ipataymo ti kannawan nga imam iti ulona.” ");
INSERT INTO iloulb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nagkedked ti amana a kinunana, “Ammok, anakko, ammok. Agbalinto met isuna nga adu a tattao, ken agbalinto met a natan-ok. Ngem natantan-okto ti inaudi a kabsatna ngem isuna, ken agbalinto nga adu a nasion dagiti kaputotanna.” ");
INSERT INTO iloulb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Binendisionan ida ni Israel iti dayta nga aldaw babaen kadagitoy a sasao, “Iwaragawagto dagiti tattao ti Israel dagiti bendision babaen kadagiti naganyo a kunada, “Pagbalinennakayo koma ti Dios a kas kenni Efraim, ken kas kenni Manases'.” Iti kastoy a wagas, pinagbalin ni Israel nga imun-una ni Efraim ngem ni Manases. ");
INSERT INTO iloulb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kinuna ni Israel kenni Jose, “Kitaem, dandaniakon matay, ngem addanto ti Dios kenka, ket isublinakanto iti daga dagiti amam. ");
INSERT INTO iloulb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kenka, kas nangatngato ngem kadagiti kakabsatmo, itedko ti naanduyas a bantay nga innalak manipud kadagiti Amorreo babaen iti kampilan ken pana.” ");
INSERT INTO iloulb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ket inayaban ni Jacob dagiti putotna a lallaki ket kinunana, “Aguummongkayo, tapno maibagak kadakayo ti mapasamakto kadakayo iti masakbayan. ");
INSERT INTO iloulb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Aguummong ken dumngegkayo, dakayo nga annak a lallaki ni Jacob. Denggenyo ni Israel nga amayo. ");
INSERT INTO iloulb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, sika ti inauna a putotko, ti pigsak ken ti nangrugian ti kinapigsak, naisangsangayan iti kinatan-ok ken naisangsangayan iti kinabileg. ");
INSERT INTO iloulb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Saan a matengngel a kas iti napigsa ti ayusna a danum, saanto a sika ti kangrunaan, gapu ta simmagpatka iti pagiddaan ti amam. Ket rinugitam daytoy; simmagpatka iti pagtugawak. ");
INSERT INTO iloulb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Agkabsat da Simeon ken Levi. Armas ti kinaranggas dagiti kampilanda. ");
INSERT INTO iloulb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O kararuak, saanka a mapan iti taripnongda; saanka a makiraman kadagiti saritaanda, gapu ta saan a maiparbeng ti kasta iti pusok. Ta gapu iti pungtotda ket nakapatayda kadagiti lallaki. Para iti pakaragsakanda ti panangpilayda kadagiti bulog a baka. ");
INSERT INTO iloulb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mailunod koma ti pungtotda, ta nakaro unay— ken ti nalaus a pungtotda, ta naulpit daytoy. Bingayekto ida iti Jacob ken iwaraskonto ida iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, dayawendakanto dagiti kakabsatmo. Ti imam ket addanto iti tengnged dagiti kabusormo. Agrukobto iti sangoanam dagiti putot ti amam. ");
INSERT INTO iloulb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Maiyarig ni Juda iti anak ti leon. Anakko, nagsublika manipud kadagiti tinukmaam. Nagrukob isuna, nagkukot a kasla leon, a kasla babai a leon. Adda kadi makaitured a mangriing kenkuana? ");
INSERT INTO iloulb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Saanto a maisina ti setro manipud kenni Juda, wenno ti sarukod ti mangiturturay manipud iti nagbaetan dagiti sakana, agingga nga umay ti Silo. Agtulnogto dagiti nasion kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Inggalutna ti urbon a kabalyona iti lanut ti ubas, ken ti urbon nga asnona iti napintas a lanut ti ubas, linabaanna dagiti kawesna iti arak, ken ti pagan-anayna iti dara dagiti ubas. ");
INSERT INTO iloulb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Lumabbaganto dagiti matana a kas iti arak, ken dagiti ngipenna a kas kapuraw ti gatas. ");
INSERT INTO iloulb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Agnaedto ni Zabulon iti igid ti baybay. Pagsangladanto isuna dagiti barko, ken dumanonto iti Sidon ti keteganna. ");
INSERT INTO iloulb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ni Issacar ket maysa a napigsa nga asno, agid-idda iti baet ti pagapunan dagiti karnero. ");
INSERT INTO iloulb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Makitana ti nasayaat a lugar a paginanaan ken ti nadam-eg a daga. Irukobna ti abagana iti dadagsen ken agbalin nga adipen iti trabaho. ");
INSERT INTO iloulb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ukomento ni Dan dagiti tattaona a kas maysa kadagiti tribu ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Maiyarigto ni Dan iti uleg nga adda iti igid ti dalan, maysa a nagita nga uleg iti pagnaan a mangkagat kadagiti mukod ti kabalio, a pakaigapuan iti pannakatnag ti nakasakay iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ur-urayek ti panangisalakanmo, Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ni Gad—darupento isuna dagiti mangraraut, ngem darupennanto ida kadagiti mukodda. ");
INSERT INTO iloulb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Nabaknangto iti taraon ni Aser, ket mangipaayto isuna kadagiti taraon a maipaay iti ari. ");
INSERT INTO iloulb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ugsa a siwawaya iti kaiyarigan ni Neftali; maaddaanto isuna kadagiti napipintas nga annak. ");
INSERT INTO iloulb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Nabunga a sanga iti kaiyarigan ni Jose, nabunga a sanga nga asideg iti ubbog, a kimmalay-at iti pader dagiti sangana. ");
INSERT INTO iloulb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Darupento isuna dagiti pumapana ket panaendanto ken riribukenda isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ngem agtalinaedto a nalagda ti bai ti panana ken nabilegto dagiti imana gapu kadagiti ima ti Mannakabalin a Dios ni Jacob, gapu iti nagan ti Agpaspastor, ti Bato ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Gapu iti Dios ti Amam, a tumulongto kenka, ken gapu iti Mannakabalin a Dios, a mangbendisionto kenka kadagiti bendision iti tangatang, kadagiti bendision ti danum nga aggapu iti uneg ti daga, kadagiti bendision dagiti barukong ken aanakan. ");
INSERT INTO iloulb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Dagiti bendision ti amam ket dakdakkelto ngem dagiti nagkakauna a banbantay wenno kadagiti makaay-ayo a banbanag kadagiti agnanayon a turturod. Addanto dagitoy iti ulo ni Jose, dagiti bendision a mangkorona iti ulo ti nagbalin a prinsipe a nangidaulo kadagiti kakabsatna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ni Benjamin ket maysa a mabisin a lobo. Iti agsapa, alun-onenna ti natiliwna, ken iti rabii, bingayenna ti nasamsamda.” ");
INSERT INTO iloulb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dagitoy dagiti sangapulo ket dua a tribu ti Israel. Kastoy ti imbaga ti amada kadakuada idi binendisionanna ida. Binendisionanna ti tunggal maysa iti maitutop a bendision. ");
INSERT INTO iloulb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kalpasanna, binilinna ida a kinunana kadakuada, “Dandanin ti ipupusayko. Itabondak iti nakaitaneman dagiti kapuonak iti rukib nga adda idiay talon ni Efron a Heteo, ");
INSERT INTO iloulb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","iti rukib nga adda iti talon idiay Macpela, nga asideg iti Mamre iti daga ti Canaan, ti talon a ginatang ni Abraham a mausar a pagitaneman manipud kenni Efron a Heteo. ");
INSERT INTO iloulb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Intabonda sadiay ni Abraham ken ni Sara nga asawana; intabonda sadiay ni Isaac ken ni Rebeca nga asawana; ken intabonko sadiay ni Lea. ");
INSERT INTO iloulb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ti talon ken ti rukib nga adda idiay ket nagatang manipud kadagiti tattao a Heteo. ");
INSERT INTO iloulb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Idi nalpasen ni Jacob dagitoy a bilbilinna kadagiti putotna a lallaki, inyunnatna dagiti sakana iti pagiddaan ket inyangesna ti maudi nga angesna, ket pimmusayen. ");
INSERT INTO iloulb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ket inarakup ni Jose ti rupa ti amana, sinangitanna ken inagkanna isuna. ");
INSERT INTO iloulb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Binilin ni Jose dagiti adipenna a mangngagas a balsamoenda ti amana. Isu a binalsamo dagiti mangngagas ni Israel. ");
INSERT INTO iloulb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Inaramidda daytoy iti uppat a pulo nga aldaw, ta dayta iti naan-anay a bilang ti aldaw a panangbalsamo. Sinangitan isuna dagiti Egipcio iti pitopulo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Idi nalpasen dagiti aldaw ti panagsangsangit, nakisarita ni Jose kadagiti opisial ti Faraon a kunana, “No nakasarakak ita iti pabor iti imatangyo, pangngaasiyo koma ta ibagayo iti Faraon, a kunaenyo, ");
INSERT INTO iloulb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","'Pinagsapatanak ti amak, a kunana, “Kitaem, dandanin ti ipapatayko. Itabondak iti tanem a kinalik para iti bagik iti daga ti Canaan. Idiaydakto nga itabon.” Ita palubosandak koma a mapan mangitabon iti amak, kalpasanna ket agsubliak.'” ");
INSERT INTO iloulb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Simmungbat ti Faraon, “Mapanmo itabon ti amam kas insapatam kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Simmang-at ni Jose ket napanna intabon ti amana. Kimmuyog kenkuana a napan dagiti amin nga opisial ti Faraon, dagiti mammagbaga iti sangakabalayanna, ken dagiti amin a panglakayen nga opisial iti daga ti Egipto, ");
INSERT INTO iloulb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","dagiti amin a sangakabalayan ni Jose ken dagiti kakabsatna, ken dagiti sangakabalayan ti amana. Ngem pinanawanda dagiti babassit nga annakda, dagiti arbanda, iti daga ti Gosen. ");
INSERT INTO iloulb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kimmuyog met kenkuana a napan dagiti nakakarwahe ken dagiti nakakabalio a soldado. Nakadakdakkel unay daytoy a bunggoy dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Idi dimtengda iti pagirikan ti Atad iti bangir ti Jordan, nagladingitda iti kasta unay. Nangipaay ni Jose sadiay ti pito nga aldaw a panagladladingit a para iti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Idi nakita dagiti agnanaed iti daga, a Canaanita ti panagladladingit idiay pagirikan ti Atad, kinunada, “Daytoy ket maysa a naliday unay a pasamak kadagiti Egipcio.” Dayta ti gapuna a naawagan ti lugar iti Abel Mizraim. Daytoy ket adda iti labes ti Jordan. ");
INSERT INTO iloulb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tinungpal ngarud dagiti lallaki a putot ni Jacob ti imbilinna nga aramidenda para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Impan isuna dagiti lallaki a putotna idiay daga ti Canaan ket intabonda isuna iti rukib idiay talon ti Macpela, nga asideg iti Mamre. Ginatang ni Abraham ti rukib agraman ti talon a mausar a pagitaneman. Ginatangna daytoy manipud kenni Efron a Heteo. ");
INSERT INTO iloulb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kalpasan a naitabonna ti amana, nagsubli ni Jose idiay Egipto, isuna, kaduana dagiti kakabsatna, ken dagiti amin a kimmuyog kenkuana a nangitabon iti amana. ");
INSERT INTO iloulb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Idi nakita dagiti kakabsat ni Jose a natayen ti amada, kinunada, “Kasano ngay no nasakit pay laeng ti nakem ni Jose ket kayatnatayo a balsen kadagiti amin a dakes nga inaramidtayo kenkuana?” ");
INSERT INTO iloulb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Isu a nangipatulodda iti mensahe kenni Jose, a kunada, “Nangted iti bilin ti amam sakbay a natay, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","'Ibagayo kenni Jose daytoy, “Pakawanem koma dagiti kakabsatmo iti biddut nga inaramidda idi pinagaramidandaka iti saan a nasayaat.'” Ita, pangngaasim ta pakawanem dagiti adipen ti Dios ti amam.” Nagsangit ni Jose idi naiyeg iti mensahe kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Napan met dagiti kakabsatna ket nagpaklebda iti sangoananna. Kinunada, “Kitaem, adipennakami.” ");
INSERT INTO iloulb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ngem simmungbat ni Jose kadakuada, “Saankayo nga agbuteng. Addaak kadi iti lugar ti Dios? ");
INSERT INTO iloulb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ket no maipapan met kadakayo, panangdangran ti pinanggepyo nga aramiden kaniak, ngem pinagbalin ti Dios daytoy a naimbag, tapno maisalbar ti biag ti adu a tattao, a kas makitayo ita. ");
INSERT INTO iloulb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ita ngarud, saankayo nga agbuteng. Ipaaykonto ti kasapulanyo ken kasta met kadagiti annakyo.” Liniwliwana ida iti kastoy a wagas ken nagsao a sisasayaat kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nagnaed ni Jose idiay Egipto, kaduana ti pamilia ti amana. Nagbiag isuna ti sangagasut ket sangapulo a tawen. ");
INSERT INTO iloulb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nakita ni Jose dagiti putot ni Efraim agingga iti maikatlo a henerasyon. Nakitana met dagiti putot ni Makir a putot ni Manases. Imbilangna ida a kameng iti pamiliana. ");
INSERT INTO iloulb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kinuna ni Jose kadagiti kakabsatna, “Dandanin ti ipapatayko; ngem awan duadua nga umayto ti Dios kadakayo ken ipanawnakayo iti daytoy a daga ken iturongnakayo iti daga nga insapatana nga ited kada Abraham, Isaac, ken Jacob.” ");
INSERT INTO iloulb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ket pinagsapata ni Jose dagiti tattao ti Israel iti maysa a kari. Kinunana, “Awan duadua nga umayto ti Dios kadakayo. Iti dayta a tiempo masapul nga awitenyo dagiti tulangko manipud ditoy.” ");
INSERT INTO iloulb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Natay ngarud ni Jose, sangagasut ket sangapulo ti tawenna. Kalpasan a binalsamoda isuna, inkabilda isuna iti maysa a lungon idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Dagitoy dagiti nagan dagiti annak ti Israel a kimmuyog kenni Jacob a napan idiay Egipto, kadua ti tunggal maysa ti sangkabalayanna: ");
INSERT INTO iloulb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi ken Juda, ");
INSERT INTO iloulb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulon ken Benjamin, ");
INSERT INTO iloulb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad ken Aser. ");
INSERT INTO iloulb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Pitopulo amin ti bilang dagiti kaputotan ni Jacob. Adda idin ni Jose idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ket natay ni Jose, dagiti amin a kakabsatna, ken amin dayta a henerasion. ");
INSERT INTO iloulb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nabunga dagiti Israelita, immadu ken pimmigsada iti kasta unay; napunno ti daga kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ket nagturay ti maysa a baro nga ari iti entero nga Egipto, a saan a mangbigbigbig iti pakasaritaan ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kinunana kadagiti tattaona, “Kitaenyo dagiti Israelita; ad-adu ken napigpigsada ngem datayo. ");
INSERT INTO iloulb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Umaykayo, tratoentayo ida a sisisirib. Ta no saan, ad-adda nga umaduda, ket no adda iti gubat, tumiponndanto kadagiti kabusortayo, a lumaban kadatayo, ket pumanawda iti daga.” ");
INSERT INTO iloulb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Isu a nangisaadda kadagiti kapatas a mangparigat kadakuada iti nadagsen a trabaho. Nangipatakder dagiti Israelita iti pagipenpenan a siudad para kenni Faraon: ti Pitom ken Rameses. ");
INSERT INTO iloulb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ngem kas ad-adda a parparigaten dagiti Egipcio ida, ad-adda met nga umad-adu ken agwar-waras dagiti Israelita. Isu a nangrugi nga agbuteng dagiti Egipcio kadagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Pinagtrabaho dagiti Egipcio dagiti Israelita iti nakaro. ");
INSERT INTO iloulb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Pinagbalinda a nasaem ti panagbiagda babaen iti nadagsen a panagtrabaho iti alketran ken ladrilio, ken iti amin a kita ti trabaho iti talon. Amin a trabaho nga impaaramidda kadakuada ket narigat. ");
INSERT INTO iloulb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ket nakisarita ti ari iti Egipto kadagiti partera a Hebreo; ti nagan ti maysa ket Zifra ken ti maysa ket Pua. ");
INSERT INTO iloulb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Kinunana, “No tulonganyo dagiti Hebreo a babbai iti paganakan, siputanyo no aganakda. No lalaki ti maladaga, masapul a patayenyo isuna; ngem no babai daytoy, bay-anyo nga agbiag.” ");
INSERT INTO iloulb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ngem adda panagbuteng dagiti partera iti Dios ket saanda nga inaramid ti imbilin ti ari iti Egipto kadakuada; ngem ketdi, binay-anda nga agbiag dagiti lallaki a maladaga. ");
INSERT INTO iloulb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Pinaayaban ti ari ti Egipto dagiti partera ket kinunana kadakuada, “Apay a binay-anyo nga agbiag dagiti lallaki a maladaga?” ");
INSERT INTO iloulb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Simmungbat dagiti partera kenni Faraon, “Dagiti babbai a Hebreo ket saan a kasla kadagiti babbai nga Egipcio; napigsada ken nakaanakdan sakbay a sumangpet ti partera kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Sinalakniban ti Dios dagitoy a partera. Immadu ti dagiti tattao ken pimmigsada iti kasta unay. ");
INSERT INTO iloulb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Gapu ta managbuteng iti Dios dagiti partera, inikkanna ida iti pamilia. ");
INSERT INTO iloulb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Binilin ni Faraon dagiti amin a tattaona, “Masapul nga ibellengyo iti karayan ti tunggal lalaki a maiyanak, ngem mabalinyo a bay-an nga agbiag ti tunggal babai.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ita, maysa a lalaki iti tribu ni Levi ti nangasawa iti maysa a babai a kaputotan ni Levi. ");
INSERT INTO iloulb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nagsikog ti babai ket naganak iti maysa a lalaki. Idi nakitana a nasalun-at isuna nga ubing, inlemmengna isuna iti las-ud iti tallo a bulan. ");
INSERT INTO iloulb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ngem idi saannan a mailemmeng isuna, nangala iti maysa a basket a naaramid iti runo ket sineraanna daytoy iti pitak ken betun. Kalpasanna, inkargana ti ubing iti daytoy ket inkabilna iti ayan dagiti runo iti danum iti igid ti karayan. ");
INSERT INTO iloulb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nagtakder ti kabsatna a babai iti saan unay nga adayo tapno makitana no ania ti mapasamak kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Simmalog ti anak a babai ni Faraon tapno agdigos iti karayan kabayatan nga agpagnapagna dagiti agserserbi kenkuana iti igid ti karayan. Nakitana ti basket iti karunoan ket imbaonna ti agserserbi kenkuana a mangala iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Idi linukatanna daytoy, nakitana ti ubing. Adtoy, agsangsangit ti maladaga. Naasian isuna kenkuana ket kinunana, “Awan duadua a maysa kadagiti annak dagiti Hebreo daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ket kinuna ti kabsat ti maladaga iti anak a babai ni Faraon, “Mapanak kadi ket ibirukanka ti Hebreo a babai a mangpasuso iti ubing para kenka?” ");
INSERT INTO iloulb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kinuna ti anak a babai ni Faraon kenkuana, “Mapanka.” Isu a napan ti balasitang ket inayabanna ti ina ti ubing. ");
INSERT INTO iloulb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kinuna ti anak a babai ni Faraon iti ina ti maladaga, “Alaem daytoy nga ubing ket pasusoem isuna para kaniak ket tangdanankanto.” Isu nga innala ti babai ti ubing ket pinasusona. ");
INSERT INTO iloulb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Idi dimmakkelen ti ubing, impanna daytoy iti anak ni Faraon, ket nagbalin isuna nga anakna a lalaki. Pinanagananna daytoy iti Moises ket kinunana, “Gapu ta innalak isuna manipud iti danum.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Idi dimmakkelen ni Moises, napan isuna kadagiti tattaona ket pinaliiwna ti narigat a trabahoda. Nakitana ti maysa nga Egipcio a dangdangranna ti maysa a Hebreo, maysa kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Timmaliaw iti agsinnumbangir, ket idi nakitana nga awan ti tao sadiay, pinatayna ti Egipcio ket inlemmengna ti bagina iti kadaratan. ");
INSERT INTO iloulb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Rimmuar isuna iti simmaruno nga aldaw, ket, adtoy, dua a lallaki a Hebreo ti aglablaban. Kinunana iti maysa a nagbiddut, “Apay a kabkabilem ti kaduam?” ");
INSERT INTO iloulb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ngem kinuna ti lalaki, “Siasino ti nangaramid kenka a mangidaulo ken mangukom kadakami? Pangpanggepennak kadi a patayen a kas ti panangpataymo iti dayta nga Egipcio?” Nagbuteng ni Moises ket kinunana, “Awan duadua a naammuanen dagiti sabali ti inaramidko.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ita, idi nangngeg ni Faraon daytoy, pinadasna a patayen ni Moises. Ngem naglibas ni Moises manipud kenni Faraon ket nagnaed idiay daga ti Midian. Nagtugaw isuna sadiay iti igid ti maysa a bubon. ");
INSERT INTO iloulb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ita, addaan ti pito nga annak a babbai ti padi ti Midian. Immayda nagsakdo iti danum, ket pinunnoda dagiti pagkargaan ti danum tapno painumenda ti arban ti amada. ");
INSERT INTO iloulb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Immay dagiti agpaspastor ket pinadasda a papanawen ida, ngem tinulongan ni Moises ida. Kalpasanna, pinainomna dagiti arbanda. ");
INSERT INTO iloulb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Idi nagawid dagiti babbai iti amada a ni Reuel kinunana, “Apay a nasapakayo a nagawid ita?” ");
INSERT INTO iloulb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kinunada, “Maysa nga Egipcio ti nangispal kadakami manipud kadagiti agpaspastor. Insakduannakami pay iti danum ken pinainomna ti arban.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kinunana kadagiti annakna, “Sadino ti ayanna? Apay a pinanawanyo ti lalaki? Ayabanyo isuna tapno makipangan isuna kadatayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Immannugot ni Moises a makipagnaed iti lalaki, a nangited pay kenkuana iti anakna a ni Sefora nga agbalin nga asawana. ");
INSERT INTO iloulb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Naganak isuna iti maysa a lalaki ket pinananaganan ni Moises ti Gersom; kinunana, “Nagnanaedak iti daga ti gangannaet.” ");
INSERT INTO iloulb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kalpasan ti nabayag a tiempo, natay ti ari iti Egipto. Nagasug dagiti Israelita gapu iti pannakaadipenda. Nagsangitda iti napigsa para iti tulong ket dimmanon iti Dios dagiti pakaasida gapu iti pannakabaludda. ");
INSERT INTO iloulb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Idi nangngeg ti Dios dagiti as-asugda, nalagip ti Dios ti tulagna kenni Abraham, kenni Isaac ken kenni Jacob. ");
INSERT INTO iloulb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nakita ti Dios dagiti Israelita, ket naawatanna ti kasasaadda. ");
INSERT INTO iloulb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ita, agpaspastor pay laeng ni Moises kadagiti arban ni Jetro a katuganganna, ti padi ti Midian. Inturong ni Moises dagiti arban iti labes ti let-ang ket nakadanon idiay Horeb, ti bantay ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nagparang kenkuana ti anghel ni Yahweh sadiay a iti maysa a gil-ayab ti apuy iti bassit a kayo. Kimmita ni Moises, ket adtoy, sumsumged, ngem saan a mapupuoran ti bassit a kayo. ");
INSERT INTO iloulb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kinuna ni Moises, “Umasidegak ket kitaek daytoy nakaskasdaaw a banag, apay a saan a mapupuoran ti kayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Idi nakita ni Yahweh nga umasideg isuna tapno kitaenna daytoy, inawagan ti Dios isuna manipud iti kayo ket kinunana, “Moises, Moises.” Kinuna ni Moises, “Adtoyak.” ");
INSERT INTO iloulb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kinuna ti Dios, “Saankan nga umas-asideg! Ikkatem ti sapatosmo, ta ti pagtaktakderam a lugar ket daga a naidaton kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Innayonna, “Siak ti Dios ti amam, ti Dios ni Abraham, ti Dios ni Isaac ken ti Dios ni Jacob. Ket inabbongan ni Moises ti rupana, ta mabuteng isuna a kumita iti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kinuna ni Yahweh, “Awan duadua a nakitak ti panagsagsagaba dagiti tattaok nga adda idiay Egipto. Nangngegko dagiti pukkawda gapu kadagiti kapatasda, ta ammok dagiti pannakaparigatda. ");
INSERT INTO iloulb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Bimmabaak tapno wayawayaak ida manipud iti pannakabalin dagiti Egipcio ken ipanawko ida manipud iti dayta a daga ket ipanko ida iti nadam-eg ken nalawa a daga, iti maysa a daga nga agay-ayus ti gatas ken diro; iti rehion dagiti Cananeo, Heteo, Amorreo, Perezeo, Heveo ken Jebuseo. ");
INSERT INTO iloulb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ket ita, nakadanon kaniak dagiti pukkaw dagiti tattao ti Israel. Maysa pay, nakitak ti pannakaparparigatda nga inaramid dagiti Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ita ngarud, ibaonka kenni Faraon tapno mairuarmo dagiti tattaok, dagiti Israelita, manipud idiay Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ngem kinuna ni Moises iti Dios, “Siasinoak, a rumbeng a mapanak kenni Faraon ken iruar dagiti Israelita manipud idiay Egipto?” ");
INSERT INTO iloulb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Simmungbat ti Dios, “Awan duadua nga addaakto kenka. Daytoyto ti pagilasinan nga imbaonka. Inton mairuarmo dagiti tattao manipud iti Egipto, dayawendakto iti daytoy a bantay.” ");
INSERT INTO iloulb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kinuna ni Moises iti Dios, “No mapanak kadagiti Israelita ket ibagak kadakuada, 'Imbaonnak ti Dios dagiti kapuonanyo kadakayo,' ket no kunada kaniak, 'Ania ti naganna?' Ania ti rumbeng nga ibagak kadakuada?” ");
INSERT INTO iloulb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kinuna ti Dios kenni Moises, “SIAK TI SIAK.” Kinuna ti Dios. “Masapul nga ibagam kadagiti Israelita, 'Imbaonnak ni SIAK kadakayo.”' ");
INSERT INTO iloulb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kinuna pay ti Dios kenni Moises, “Masapul nga ibagam kadagiti Israelita, 'Imbaonnak ni Yahweh, ti Dios dagiti kapuonanyo, ti Dios ni Abraham, ti Dios ni Isaac ken ti Dios ni Jacob kadakayo. Daytoy ti naganko iti agnanayon, ken kastoyto ti pananglagip kaniak dagiti amin a henerasion.' ");
INSERT INTO iloulb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Mapanka ket ummongem dagiti panglakayen ti Israel. Ibagam kadakuada, 'Ni Yahweh, ti Dios dagiti kapuonanyo, ti Dios ni Abraham, ni Isaac kenni Jacob ket nagparang kaniak ket kinunana, “Pudno a napaliiwko ken nakitak ti napasamak kadakayo idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Inkarik nga ipanawkayo manipud iti pannakaparigatyo idiay Egipto ket ipankayo iti daga dagiti Cananeo, Heteo, Amorreo, Perezeo, Heveo ken Jebuseo, maysa a daga nga agay-ayus ti gatas ken diro.”' ");
INSERT INTO iloulb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Dumngegdanto kenka. Masapul a mapankayo iti ari ti Egipto, Sika ken dagiti panglakayen ti Israel, ket masapul nga ibagam kenkuana, 'Ni Yahweh, ti Dios dagiti Hebreo, ket nakisinnarak kadakami. Isu nga ita, palubosannakami nga agdaliasat iti tallo nga aldaw a mapan idiay let-ang, tapno makaidatonkami kenni Yahweh, a Diosmi.' ");
INSERT INTO iloulb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ngem ammok a saannakayonto a palubosan ti ari ti Egipto, malaksid no mapilit a matignay ti imana. ");
INSERT INTO iloulb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Iyunnatkonto dagiti imak ket dusaekto dagiti Egipcio babaen kadagiti amin a milagro nga aramidekto kadakuada. Kalpasan dayta, palubosannakayonto. ");
INSERT INTO iloulb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ikkakto dagiti tattao iti pabor manipud kadagiti Egipcio, isu nga inton pumanawkayo, saankayo a mapan nga ima-ima. ");
INSERT INTO iloulb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Dumawatto ti tunggal babai iti pirak ken balitok nga alahas ken pagan-anay kadagiti kaarrubana nga Egipcio ken iti siasinoman a babai nga agnanaed iti balay ti kaarrubana. Ikabilyonto dagitoy kadagiti annakyo a lallaki ken babbai. Iti daytoy a wagas, alaenyonto amin a kinabaknang dagiti Egipcio.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Simmungbat ni Moises, “Ngem kasano no saanda a mamati kaniak wenno dumngeg kaniak ngem ibagada ketdi, 'Saan a nagparang ni Yahweh kenka'?” ");
INSERT INTO iloulb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kinuna ni Yahweh kenkuana, “Ania dayta adda dita imam?” Kinuna ni Moises, “Maysa a baston.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kinuna ni Yahweh, “Ipuruakmo daytoy iti daga.” Impuruak daytoy ni Moises iti daga, ket nagbalin daytoy nga uleg. Nagsanud ni Moises manipud iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kinuna ni Yahweh kenni Moises, “Pidutem ken alaem daytoy babaen iti ipusna.” Isu a pinidutna ken ineggamanna ti uleg. Nagbalin manen daytoy a baston iti imana. ");
INSERT INTO iloulb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Daytoy ket tapno mamatida a ni Yahweh, ti Dios dagiti kapuonanda, ti Dios ni Abraham, ti Dios ni Isaac, ken ti Dios ni Jacob, ket nagparang kenka.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kinuna pay ni Yahweh kenkuana, “ Ita iyunegmo ta imam iti pagan-anaymo.” Inyuneg ngarud ni Moises ti imana iti pagan-anayna. Idi inruarna daytoy, adtoy, adda ketong ti imana, a kas kapuraw ti niebe. ");
INSERT INTO iloulb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kinuna ni Yahweh, “Iyunegmo manen ta imam iti pagan-anaymo.” Isu nga inyuneg ni Moises ti imana iti pagan-anayna, ket idi inruarna daytoy, nakitana a nagsubli manen ti kinasalun-atna, a kas kadagiti dadduma a lasagna. ");
INSERT INTO iloulb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Kinuna ni Yahweh, “No saandaka a patien—no saanda nga ipangag ti umuna a pagilasinan ti pannakabalinko wenno mamati iti daytoy, ket mamatidanto iti maikadua a pagilasinan. ");
INSERT INTO iloulb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ket no saanda a mamati uray kadagitoy a dua a pagilasinan ti pannakabalinko, wenno dumngeg kenka, ket mangalaka iti danum manipud ti karayan ket ibukbokmo daytoy iti namaga a daga. Ti alaem a danum ket agbalinto a dara iti namaga a daga.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kalpasanna, kinuna ni Moises kenni Yahweh, “Apo, saanak a pulos a nalaing nga agsao, uray pay iti napalabas wenno manipud idi nagsaoka iti adipenmo. Nabannayatak nga agsao ken natabbed ti dilak.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kinuna ni Yahweh kenkuana, “Siasino ti nangaramid iti ngiwat iti tao? Siasino ti mangar-aramid nga umel wenno tuleng wenno makakita wenno bulsek ti maysa a tao? Saan kadi a Siak, ni Yahweh? ");
INSERT INTO iloulb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Isu nga ita mapanka, ket addaakto iti ngiwatmo ken isurokto kenka ti ibagam.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ngem kinuna ni Moises,” Apo, pangngaasim mangibaonka laengen iti sabali, siasinoman a kayatmo nga ibaon.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ket nakaunget ni Yahweh kenni Moises. Kinunana, “Ni ngay Aaron, a kabsatmo, ti Levita? Ammok a nalaing isuna nga agsao. Maysa pay, um-umayen isuna a mangsabat kenka, ket no makitanaka, maragsakanto ti pusona. ");
INSERT INTO iloulb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Makisaritakanto kenkuana ket ibagam dagiti sawenna. Tulongankayonto nga agsao, ket ipakitakto kadakayo a dua ti aramidenyo. ");
INSERT INTO iloulb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Agsaonto isuna kadagiti tattao para kenka. Isunanto ti pannakangiwatmo, ken addakanto kenkuana a kas kaniak, ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Itugotmonto daytoy a baston. Babaen iti daytoy, agaramidkanto kadagiti pagilasinan.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Isu a nagsubli ni Moises kenni Jetro a katuganganna ket kinunana kenkuana, “Palubosannak a mapan tapno makasubliak kadagiti kakabaggiak nga adda idiay Egipto ket kitaek no sibibiagda pay.” Kinuna ni Jetro kenni Moises, “Mapanka nga addaan iti kapia.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kinuna ni Yahweh kenni Moises diay Midian, “Mapanka, agsublika idiay Egipto, gapu ta natayen dagiti amin a tattao a mangpangpanggep a mangpatay kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Intugot ni Moises ti asawana ken dagiti annakna ket insakayna ida iti asno. Nagsubli isuna iti daga iti Egipto. Ket intugotna ti baston ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kinuna ni Yahweh kenni Moises, “Inton agsublika idiay Egipto, kitaem a maaramidmo iti sangoanan ni Faraon dagiti amin a nakakaskasdaaw nga inkabilko iti pannakabalinmo. Ngem patangkenekto ti pusona, ket saannanto a palubosan a mapan dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Masapul nga ibagam kenni Faraon, 'Daytoy ti ibagbaga ni Yahweh: Anakko ni Israel, ti inauna nga anakko, ");
INSERT INTO iloulb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ket ibagak kenka, “Palubosam a mapan ti anakko, tapno maidaydayawnak.” Ngem agsipud ta nagkedkedka a mangpalubos kenkuana, papatayekto ti anakmo, ti inauna nga anakmo.”' ");
INSERT INTO iloulb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ita, iti dalan, idi nagsardengda iti rabii, sinabat ni Yahweh ni Moises ket dandanina pinatay isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kalpasanna, nangala ni Sefora iti natadem a bato ket kinugitna ti anakna, ken insagidna daytoy iti saka ni Moises. Ket kinunana, “Awan dua-dua a sika ti asawak babaen ti dara.” ");
INSERT INTO iloulb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Isu a binaybay-anen ni Yahweh isuna nga agmaymaysa. Kinunana, “Asawaka iti dara” gapu iti pannakakugit. ");
INSERT INTO iloulb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kinuna ni Yahweh kenni Aaron, “Mapanka idiay let-ang a makisinnabat kenni Moises.” Napan ni Aaron, nakitana isuna idiay bantay ti Dios, ket inagkanna isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Imbaga ni Moises kenni Aaron dagiti amin a sasao nga imbaga ni Yahweh kenkuana nga ibagana ken maipanggep kadagiti amin a pagilasinan ti pannakabalin ni Yahweh nga imbilinna kenkuana nga aramidenna. ");
INSERT INTO iloulb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kalpasanna, inummong ni Moises ken Aaron dagiti amin a panglakayen dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Insao ni Aaron dagiti amin a sasao nga imbaga ni Yahweh kenni Moises. Impakitana pay dagiti pagilasinan ti pannakabalin ni Yahweh iti imatang dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Namati dagiti tattao. Idi nangngegda a pinaliiw ni Yahweh dagiti Israelita ken nakitana dagiti pannakaparparigatda, ket nagdumogda ken nagrukbabda kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kalpasan a napasamak dagitoy a banbanag, napan da Moisen ken Aaron kenni Faraon ket kinunada, “Daytoy ti imbaga ni Yahweh, ti Dios iti Israel: 'Palubosam a pumanaw dagiti tattaok, tapno agfiestada para kaniak idiay let-ang.”' ");
INSERT INTO iloulb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kinuna ni Faraon, “Siasino ni Yahweh? Apay koma a dumngegak iti timekna ken palubosak a pumanaw ti Israel? Saanko nga am-ammo ni Yahweh; maysa pay, saankonto a palubosan a pumanaw ti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Kinunada, “Nakisinnarak kadakami ti Dios dagiti Hebreo. Palubosannakami nga agdaliasat iti tallo-nga aldaw a mapan idiay let-ang ken agidaton kenni Yahweh a Diosmi tapno saan isuna a mangipatulod iti didigra wenno kampilan.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ngem kinuna ti ari iti Egipto kadakuada, “Moises ken Aaron, apay nga al-alaenyo dagiti tattao manipud kadagiti trabahoda? Agsublikayo kadagiti trabahoyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kinunana pay, “Adu itan dagiti Hebreo iti dagatayo, ket paspasardengenyo ida kadagiti trabahoda.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Iti dayta met laeng nga aldaw, nangted ni Faraon iti bilin kadagiti kapatas ken mangiturturay kadagiti tattao. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Saan a kasla idi, masapul a saanyon a pulos nga ikkan dagiti tattao iti garami a pagaramidda kadagiti ladrilio. Bay-anyo ida a mapan ken agurnong iti garami para kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Nupay kasta, sapulenyo latta kadakuada iti isu met laeng a bilang dagiti ladrilio kas iti sigud nga inaramidda. Saanyo nga awaten ti basbassit, gapu ta nasadutda. Isu nga umaw-awag ken ibagbagada a, 'Palubosannakami a mapan agidaton iti Diosmi.' ");
INSERT INTO iloulb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Nayunanyo pay ti trabaho dagiti lallaki tapno ituloyda daytoy ken saanda a dumngeg kadagiti makaallilaw a sasao.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ket rimmuar ngarud dagiti kapatas ken mangiturturay kadagiti tattao ket pinakaamoanda dagiti tattao. Kinunada, “Daytoy ti imbaga ni Faraon: 'Saanakon a pulos a mangted kadakayo iti garami. ");
INSERT INTO iloulb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Masapul a dakayo ti mapan ken mangala iti garami iti sadinoman a pakabirukanyo iti daytoy, ngem saanto a makissayan ti trabahoyo.'” ");
INSERT INTO iloulb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Isu a nagwaras dagiti tattao iti entero a daga ti Egipto tapno agurnong iti garami. ");
INSERT INTO iloulb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Agtultuloy a dagdagdagen dagiti kapatas ida ket kunkunada, “Leppasenyo dagiti trabahoyo, kas idi mait-ited kadakayo ti garami.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Kinabil dagiti kapatas ni Faraon dagiti mangiturturay nga Israelita, dagiti isu met laeng a tattao nga inkabilda a mangimaton kadagiti trabahador. Intultuloy dagiti kapatas a nagsalsaludsod kadakuada, “Apay a saanyo pay a naaramid dagiti amin a ladrilio a naipaaramid kadakayo, uray idi kalman ken ita, kas ti ar-aramidenyo iti napalabas?” ");
INSERT INTO iloulb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Isu a napan dagiti kapatas nga Israelita kenni Faraon ket nagpakaasida kenkuana, kinunada, “Apay a tratratoem iti kastoy a wagas dagiti adipenmo? ");
INSERT INTO iloulb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Awanen a pulos ti garami a mait-ited kadagiti adipenmo, ngem ibagbagada latta kadakami nga, 'Agaramid iti ladrilio!' Dakami, dagiti adipenmo, ket makabkabil payen ita, ngem basol met laeng dagiti tattaom.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ngem kinuna ni Faraon, “Nasadutkayo! Nasadutkayo! Ibagayo, 'Palubosannakami a mapan agidaton kenni Yahweh.' ");
INSERT INTO iloulb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Isu nga ita agsublikayo kadagiti trabahoyo. Awanen ti maited kadakayo a garami, ngem masapul nga agaramidkayo latta iti isu met laeng a bilang dagiti ladrilio.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nakita dagiti kapatas nga Israelita nga adda dakkel a parikutda idi naibaga kadakuada, “Masapul a saanyo a kissayan ti bilang dagiti ladrilio.” ");
INSERT INTO iloulb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nasabatda ni Moises ken Aaron, nga agtaktakder iti ruar ti palasio, bayat ti ipapanawda manipud kenni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Kinunada kenni Moises ken ni Aaron, “Makitanakayo koma ni Yahweh ket dusaennakayo, ta dakayo ti gapuna a kinaguranakami Faraon ken dagiti adipenna. Nangikabilkayo iti kampilan kadagiti imada tapno patayendakami” ");
INSERT INTO iloulb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Nagsubli ni Moises kenni Yahweh ket kinunana, “Apo, apay a parparigatem dagitoy a tattao? Apay nga imbaonnak? ");
INSERT INTO iloulb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nanipud idi napanak nakisao kenni Faraon iti naganmo, pinarigatna dagitoy a tattao, ket saanmo pulos a winaya-wayaan dagiti tattaom.” ");
INSERT INTO iloulb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kalpasanna, kinuna ni Yahweh kenni Moises, “Ita, makitamto ti aramidek kenni Faraon. Makitamto daytoy, ta palubosannanto ida a mapan gapu iti mannakabalin nga imak. Gapu iti mannakabalin nga imak, papanawennanto ida manipud iti dagana.” ");
INSERT INTO iloulb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nagsao ti Dios kenni Moises ket kinunana kenkuana, “Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nagparangak kada Abraham, Isaac, ken Jacob a kas Dios a Mannakabalin-amin; ngem babaen iti naganko, a Yahweh, saandak nga am-ammo. ");
INSERT INTO iloulb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nangaramidak met iti tulag kadakuada, tapno maited kadakuada ti daga ti Canaan, ti daga a nagnaedanda a kas saan nga umili, ti daga a nagalla-allaanda. ");
INSERT INTO iloulb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Maysa pay, nangngegko ti panagas-asug dagiti Israelita a tinagabu dagiti Egipcio, ket nalagipko ti tulagko. ");
INSERT INTO iloulb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ngarud, ibagam kadagiti Israelita, 'Siak ni Yahweh. Iruarkayonto manipud iti pannakatagabu kadagiti Egipcio, ken wayawayaankayto manipud kadagiti pannakabalinda. Ispalenkayonto babaen iti panangipakitak iti pannakabalinko, ken kadagiti nabileg nga aramid iti panangukom. ");
INSERT INTO iloulb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Pagbalinenkayto a tattaok, ken agbalinakto a Diosyo. Maammoanyonto a siak ni Yahweh, ti Diosyo, a nangiruar kadakayo manipud iti pannakatagabu kadagiti Egipcio ");
INSERT INTO iloulb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ipankayonto iti daga nga insapatak nga ited kada Abraham, Isaac, ken Jacob. Itedkonto daytoy kadakayo kas maysa a sanikua. Siak ni Yahweh.”' ");
INSERT INTO iloulb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Idi imbaga ni Moises daytoy kadagiti Israelita, saanda a dimngeg kenkuana gapu iti pannakaupayda maipanggep iti napalalo a pannakatagabuda. ");
INSERT INTO iloulb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ket nagsao ni Yahweh kenni Moises ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Mapanmo ibaga kenni Faraon, ti ari ti Egipto, a palubosanna a pumanaw dagiti tattao iti Israel manipud iti dagana.” ");
INSERT INTO iloulb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kinuna ni Moises kenni Yahweh, “No saan a dimngeg kaniak dagiti Israelita, apay koma a dumngeg kaniak ni Faraon, idinto ta saanak a nalaing nga agsao?” ");
INSERT INTO iloulb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Nagsao ni Yahweh kenni Moises ken Aaron. Nangted isuna kadakuada iti bilin para kadagiti Israelita ken para kenni Faraon, ti ari ti Egipto, tapno mairuar dagiti Israelita manipud iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Dagitoy dagiti mangidadaulo kadagiti babbalay iti am-ammada: dagiti putot a lallaki ni Ruben, ti inauna nga anak ni Israel, ket da Hanoc, Pallu, Hezron, ken Carmi. Dagitoy dagiti kapuonan ti puli ni Ruben. ");
INSERT INTO iloulb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Dagiti putot a lallaki ni Simeon ket da Jemuel, Jamin, Ohad, Jakin, Zohar, ken Saul—ti anak a lalaki iti maysa a Cananea. Dagitoy dagiti kapuonan ti puli ni Simeon. ");
INSERT INTO iloulb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Nailista ditoy dagiti nagan dagiti putot a lallaki ni Levi, agraman dagiti kaputotanda. Isuda ket da Gerson, Cohat, ken Merari. Nagbiag ni Levi iti 137 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Dagiti putot a lallaki ni Gerson ket da Libni ken Simei. ");
INSERT INTO iloulb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Dagiti putot a lallaki ni Cohat ket da Amram, Isar, Hebron, ken Uzziel. Nagbiag ni Cohat iti 133 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Dagiti putot a lallaki ni Merari ket da Mali ken Musi. Nagbalin dagitoy a kapuonan a puli dagiti Levita, agraman dagiti kaputotanda. ");
INSERT INTO iloulb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Inasawa ni Amram ni Jocabed, ti babai a kabsat ti amana. Inyanakna da Aaron ken Moises. Nagbiag ni Amram iti 137 a tawen ken kalpasanna ket natay. ");
INSERT INTO iloulb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Dagiti putot a lallaki ni Isar ket da Kora, Nefeg, ken Zikri. ");
INSERT INTO iloulb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Dagiti putot a lallaki ni Uzziel ket da Misael, Elsafan, ken Sitri. ");
INSERT INTO iloulb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Inasawa ni Aaron ni Eliseba, putot a babai ni Aminadab, ti kabsat a babai ni Naason. Inyanakna da Nadab ken Abihu, Eleazar ken Itamar. ");
INSERT INTO iloulb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Dagiti putot a lallaki ni Kora ket da Asir, Elkana, ken Abiasaf. Dagitoy dagiti kapuonan dagiti Korahita. ");
INSERT INTO iloulb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ni Eleazar, ti putot a lalaki ni Aaron, ket inasawana ti maysa kadagiti putot a babbai ni Putiel. Inyanakna ni Fineas. Dagitoy dagiti mangidadaulo kadagiti babbalay ti amma dagiti Levita, agraman dagiti kaputotanda. ");
INSERT INTO iloulb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Dagitoy dua a lallaki ket da Aaron ken ni Moises a nangibagaan ni Yahweh iti, “Iruaryo dagiti Israelita manipud iti daga ti Egipto, babaen kadagiti bunggoy dagiti mannakigubat a lallaki.” ");
INSERT INTO iloulb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Nagsao da Aaron ken Moises iti Faraon, ari ti Egipto, tapno palubosanna ida nga ipanaw dagiti Israelita manipud iti Egipto. Isu met laeng dagitoy a Moises ken Aaron. ");
INSERT INTO iloulb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Idi nagsao ni Yahweh kenni Moises iti daga ti Egipto, ");
INSERT INTO iloulb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kinunana kenkuana, “Siak ni Yahweh. Ibagam kenni Faraon, ari iti Egipto, dagiti amin a banbanag nga ibagak kenka.” ");
INSERT INTO iloulb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ngem kinuna ni Moises kenni Yahweh, “Saanak a nalaing nga agsao, isu nga apay a dumngeg kaniak ni Faraon?” ");
INSERT INTO iloulb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kinuna ni Yahweh kenni Moises, “Kitaem, pinagbalinka a kasla maysa a dios kenni Faraon. Ni Aaron a kabsatmo ti agbalin a profetam. ");
INSERT INTO iloulb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ibagamto amin nga ibilinko kenka nga ibagam. Ni Aaron a kabsatmo ti agsao kenni Faraon tapno palubosanna dagiti tattao iti Israel a pumanaw manipud iti dagana. ");
INSERT INTO iloulb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ngem patangkenekto ti puso ni Faraon, ken ipakitakto dagiti adu a pagilasinan iti pannakabalinko, adu a nakaskasdaaw iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ngem saanto a dumngeg kenka ni Faraon, isu nga iturongko ti imak iti Egipto ket iruarkonto dagiti bunggoy ti mannakigubatko, dagiti tattaok, dagiti kaputotan ni Israel manipud iti daga ti Egipto babaen iti panangiramid ti dakkel a pannakadusa. ");
INSERT INTO iloulb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Maammoanto dagiti Egipcio a siak ni Yahweh inton iyunnatko ti imak iti Egipto ken inton iruarko dagiti Israelita manipud kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Inaramid ngarud da Moises ken Aaron daytoy; inaramidda daytoy kas imbilin ni Yahweh kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Walo pulo ti tawen ni Moises ken walo pulo ket tallo ti tawen ni Aaron idi nakisaoda kenni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kinuna ni Yahweh kada Moises ken Aaron, ");
INSERT INTO iloulb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“No ibaga ni Faraon kadakayo, 'Agaramidkayo iti milagro,' ket ibagamto kenni Aaron, 'Alaem ti bastonmo ket ipuruakmo iti sangoanan ni Faraon, tapno agbalin daytoy nga uleg.'” ");
INSERT INTO iloulb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ket napan da Moises ken Aaron kenni Faraon, ket inaramidda kas imbilin ni Yahweh. Impuruak ni Aaron ti bastonna iti sangoanan ni Faraon ken dagiti adipenna, ket nagbalin daytoy nga uleg. ");
INSERT INTO iloulb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kalpasanna, nangayab met ni Faraon kadagiti masirib a lallaki ken kadagiti manggagamud. Inaramidda ti isu met laeng a banag babaen iti panagsalamangkada. ");
INSERT INTO iloulb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Impuruak ti tunggal lalaki ti bastonna, ket nagbalin nga uleg dagiti baston. Ngem inalun-on ti baston ni Aaron dagiti ulegda. ");
INSERT INTO iloulb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Napatangken ti puso ni Faraon, ket saan a dimngeg, kas imbaga ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kinuna ni Yahweh kenni Moises, “Natangken ti puso ni Faraon, ket agkedked isuna a mangpalubos kadagiti tattao a pumanaw. ");
INSERT INTO iloulb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Mapanka kenni Faraon iti agsapa inton rummuar isuna a mapan ti danum. Agtakderka iti igid ti karayan a mangsabat kenkuana, ket alaem ti baston a nagbalin nga uleg. ");
INSERT INTO iloulb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ibagam kenkuana, 'Ni Yahweh, ti Dios dagiti Hebreo ket imbaonnak a mangibaga kenka, “Palubosam dagiti tattaok a pumanaw, tapno makapagdayawda kaniak idiay let-ang. Agingga ita saanka a dimngeg.” ");
INSERT INTO iloulb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Imbaga ni Yahweh daytoy: “Babaen iti daytoy ket maamoam a siak ni Yahweh. Abblatakto ti danum iti Karayan Nilo babaen iti baston nga ig-iggamak, ket agbalinto a dara ti karayan. ");
INSERT INTO iloulb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Matayto dagiti lames nga adda iti karayan, ket bumangsitto ti karayan. Saanto a mabalin nga inumen dagiti Egipcio ti danum manipud iti karayan.”” ");
INSERT INTO iloulb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kalpasanna, kinuna ni Yahweh kenni Moises, “Ibagam kenni Aaron, 'Alaem ti bastonmo ket iyunnatmo ta imam kadagiti danum ti Egipto, ken kadagiti karayanda, waig, pagdigusan ken amin a lugnakda, tapno agbalin a dara dagiti danumda. Aramidem daytoy tapno addanto dara iti entero a daga ti Egipto, uray pay kadagiti pagkargaan a kayo ken bato.'” ");
INSERT INTO iloulb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Inaramid da Moises ken Aaron ti imbilin ni Yahweh. Ingngato ni Aaron ti baston ket inablatanna ti danum ti karayan, iti imatang ni Faraon ken dagiti adipenna. Nagbalin a dara ti amin a danum iti karayan. ");
INSERT INTO iloulb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Natay dagiti lames iti karayan, ken nangrugi a bimmangsit ti karayan. Saanen a makainum manipud iti karayan dagiti Egipcio, ken adda dara iti sadinnoman iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ngem inaramid dagiti salamangkero ti Egipto ti isu met laeng a banag babaen iti panagsalamangkada. Isu a napatangken ti puso ni Faraon, ket nagkedked isuna a dumngeg kada Moises ken Aaron, kas imbaga ni Yahweh a mapasamak. ");
INSERT INTO iloulb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kalpasanna, timmalikod ni Faraon ket napan iti balayna. Saanna pay nga impangag daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nagkali dagiti amin nga Egipcio iti aglawlaw ti karayan para iti danum a mainum, ngem saanda a mainum ti mismo a danum ti karayan. ");
INSERT INTO iloulb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pito nga aldaw ti naglabas kalpasan a dinidigra ni Yahweh ti karayan. ");
INSERT INTO iloulb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kalpasanna, nakisao ni Yahweh kenni Moises, “Mapanka kenni Faraon ket ibagam kenkuana, 'Kinuna ni Yahweh daytoy: “Palubosam a pumanaw dagiti tattaok tapno makapagdayawda kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","No agkedkedka a mangpalubos kadakuada, parigatekto amin a pagiliam babaen kadagiti tukak. ");
INSERT INTO iloulb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mapunnonto kadagiti tukak ti karayan. Sumrek ken umulidanto iti balaymo, iti silidmo, ken iti pagiddaam. Mapandanto kadagiti balay dagiti adipenmo. Mapandanto kadagiti tattaom, kadagiti paglutoam, ken kadagiti pagmasaam. ");
INSERT INTO iloulb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Darupennakanto dagiti tukak, dagiti tattaom ken dagiti amin nga adipenmo.\"”' ");
INSERT INTO iloulb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kinuna ni Yahweh kenni Moises, “Ibagam kenni Aaron, 'Iyunnatmo ta imam ken ta bastonmo kadagiti karayan, kadagiti waig, kadagiti lugnak, tapno sumang-at dagiti tukak nga agsaknap iti daga ti Egipto.'” ");
INSERT INTO iloulb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Inyunnat ni Aaron ti imana kadagiti danum iti Egipto, ket simmang-at dagiti tukak a nangsaknap iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ngem inaramid dagiti salamangkero iti isu met laeng a banag: nangparuarda kadagiti tukak iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kalpasanna, pinaayaban ni Faraon da Moises ken Aaron ket kinunana, “Agkararagkayo kenni Yahweh nga ikkatenna dagiti tukak manipud kaniak ken kadagiti tattaok. Ket palubosakto dagiti tattao a mapan, tapno makaidatonda kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kinuna ni Moises kenni Faraon, “Adda kenka ti gundaway a mangibaga kaniak no kaanoak a rumbeng nga agkararag para kenka, kadagiti adipenmo, ken kadagiti tattaom, tapno maikkat dagiti tukak kenka ken kadagiti balaymo ket agtalinaedda laeng iti karayan.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kinuna ni Faraon, “Inton bigat.” Kinuna ni Moises, “Maaramid ngarud dayta kas kinunam, tapno maamoam nga awan ti siasinoman a kas kenni Yahweh, a Diosmi. ");
INSERT INTO iloulb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Pumanawto dagiti tukak kenka, kadagiti balaymo, kadagiti adipenmo, ken kadagiti tattaom. Agtalinaeddanto laeng iti karayan.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Pinanawan da Moises ken Aaron ni Faraon. Kalpasanna, immawag ni Moises kenni Yahweh maipapan kadagiti tukak nga impanna kenni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Inaramid ni Yahweh kas dinawat ni Moises: natay dagiti tukak kadagiti balay, paraangan ken kataltalonan. ");
INSERT INTO iloulb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Inummong dagiti tattao dagitoy a sangsangkamaysa kadagiti gabsuon, ket bimmangsit ti daga. ");
INSERT INTO iloulb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ngem idi makita ni Faraon a nasayaat manen ti kasasaadda, pinatangkenna ti pusona ken saan a dimngeg kada Moises ken Aaron, kas kinuna ni Yahweh nga aramidenna. ");
INSERT INTO iloulb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kinuna ni Yahweh kenni Moises, “Ibagam kenni Aaron, 'Iyunnatmo ta bastonmo ket ablatam ti tapok iti daga, tapno agbalin daytoy a timel iti entero a daga ti Egipto.'” ");
INSERT INTO iloulb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Inaramidda ngarud daytoy: Inyunnat ni Aaron ti imana ken ti bastonna. Inablatanna ti tapok iti daga. Kimpet dagiti timel kadagiti tattao ken kadagiti nauyong nga ayup. Nagbalin a timel dagiti amin a tapok iti entero a daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pinadas dagiti salamangkero babaen iti salamangkada a mangpataud kadagiti timel, ngem saanda nabaelan. Tinimel amin a tattao ken dagiti nauyong nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kalpasanna, kinuna dagiti salamangkero kenni Faraon, “Ramay ti Dios daytoy.” Ngem napatangken ti puso ni Faraon, isu a nagkedked isuna a dumngeg kadakuada. Kas ti kinuna ni Yahweh nga aramiden ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kinuna ni Yahweh kenni Moises, “Bumangonka a masapa inton bigat ket agtakderka iti sangoanan ni Faraon kabayatan a sumalsalog isuna iti karayan. Ibagam kenkuana, 'Kinuna ni Yahweh daytoy: Palubosam a mapan dagiti tattaok tapno makapagdayawda kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ngem no saanmo a palubosan dagiti tattaok, mangibaonnakto kadagiti pangen ti ngilaw kenka, kadagiti adipenmo, ken kadagiti tattaom, ken kadagiti balaymo. Mapunnonto kadagiti pangen ti ngilaw dagiti balay dagiti Egipcio, ken mapunnonto iti ngilaw uray ti daga a pagtaktakderanda. ");
INSERT INTO iloulb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ngem iti dayta nga aldaw tratoek iti naidumduma ti daga iti Gosen, ti daga a pagnanaedan dagiti tattaok, tapno awanto ti pangen ti ngilaw sadiay. Mapasamakto daytoy tapno maammoam a Siak ni Yahweh nga adda iti tengnga iti daytoy a daga. ");
INSERT INTO iloulb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mangaramidakto ti naggidiatan iti nagbaetan dagiti tattaok ken dagiti tattaom. Daytoy a pagilasinan ti pannakabalinko ket mapasamak inton bigat.\"”' ");
INSERT INTO iloulb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Inaramid ngarud ni Yahweh, ket napuskol a pangen ti ngilaw ti napan iti balay ni Faraon ken kadagiti balay dagiti adipenna. Iti entero a daga ti Egipto, nadadael ti daga gapu kadagiti pangen dagiti ngilaw. ");
INSERT INTO iloulb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pinaayaban ni Faraon da Moises ken Aaron ket kinuna, “Mapankayo, agidatonkayo iti Diosyo iti bukodmi a daga.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Kinuna ni Moises, “Saan a rumbeng nga aramidenmi dayta, ta dagiti daton nga aramidenmi para kenni Yahweh ket makarimon kadagiti Egipcio. No agidatonkami iti sangoananda iti makarimon kadagiti Egipcio, saandakami kadi a batoen? ");
INSERT INTO iloulb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Saan, tallo nga aldaw a panagdaliasat iti let-ang ti masapul nga aramidenmi tapno agidaton kenni Yahweh a Diosmi, kas imbilinna kadakami.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kinuna ni Faraon, “Palubosankayo a mapan ken agidaton kenni Yahweh a Diosyo idiay let-ang. Saankayo laeng nga umadayo unay. Ken ikararagandak.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Kinuna ni Moises, “Apaman a rumuarak ditoy, Agkararagakto kenni Yahweh a panawannaka dagiti pangen dagiti ngilaw, sika Faraon, ken dagiti adipenmo ken tattaom inton bigat. Ngem masapul a saannakami manen nga allilawen babaen iti saanmo a panangpalubos kadagiti tattaomi a mapan agidaton kenni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Rimmuar ni Moises iti ayan ni Faraon ket nagkararag kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Inaramid ni Yahweh daytoy kas dinawat ni Moises: inikkatna dagiti pangen dagiti ngilaw manipud kenni Faraon, kadagiti adipenna, ken kadagiti tattaona. Awan ti uray maysa a nabati. ");
INSERT INTO iloulb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ngem iti daytoy a tiempo pinatangken manen ni Faraon ti pusona, ket saanna a pinalubosan dagiti tattao a mapan. ");
INSERT INTO iloulb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kalpasanna, kinuna ni Yahweh kenni Moises, “Mapanka kenni Faraon ket ibagam kenkuana, ‘Ibagbaga daytoy ni Yahweh, ti Dios dagiti Hebreo: “Palubosam dagiti tattaok a mapan tapno dayawendak.” ");
INSERT INTO iloulb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ngem no saanmo ida a palubosan, no pagtalinaedem latta ida, ");
INSERT INTO iloulb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ket iyunnatto ni Yahweh ti imana kadagiti tarakenmo nga ayup idiay kataltalonan, kas kadagiti kabalio, kadagiti asno, kadagiti kamelio, kadagiti pangen ken arbanmo ket mangiyeg daytoy iti nakaro a sakit. ");
INSERT INTO iloulb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Agdumanto ti panangtrato ni Yahweh kadagiti taraken nga ayup dagiti Israelita ken taraken nga ayup dagiti Egipcio: awanto ti matay nga ayup a kukua dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nangituding ni Yahweh iti tiempo; kinunana, “Aramidekto daytoy a banag iti daga inton bigat.\"”' ");
INSERT INTO iloulb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Inaramid ni Yahweh daytoy iti sumaruno nga aldaw: natay amin a taraken nga ayup iti Egipto. Ngem awan ti uray maysa a natay kadagiti ayup dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nagdamag-damag ni Faraon no ania ti napasamak, ket adtoy, awan ti natay nga uray maysa nga ayup dagiti Israelita. Ngem natangken ti pusona, isu a saanna a pinalubosan dagiti tattao a mapan. ");
INSERT INTO iloulb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kalpasanna, kinuna ni Yahweh kada Moises ken Aaron, “Mangrakemkayo iti dapu manipud iti orno. Sika, Moises, masapul nga ipuruakmo ti dapu iti angin kabayatan nga agbuybuya ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Agbalindanto a napino a tapuk iti entero a daga ti Egipto. Mangpataudto dagitoy kadagiti kapuyo ken sugat a mangdidigra kadagiti tattao ken kadagiti ayup iti entero a daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Isu a nangala da Moises ken Aaron iti dapu manipud iti orno ket nagtakderda iti sangoanan ni Faraon. Kalpasanna, impuruak ni Moises ti dapu iti angin. Nangpataud dagiti dapu kadagiti a kapuyo ken sugat kadagiti tattao ken ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Saan a nabaelan a supringen dagiti salamangkero ni Moises gapu kadagiti kapuyo; gapu ta nagkappuyoda ken dagti amin a dadduma pay nga Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pinatangken ni Yahweh ti puso ni Faraon, isu a saan a dimngeg isuna kada Moises ken Aaron. Daytoy ket kas ti imbaga ni Yahweh kenni Moises nga aramiden ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kalpasanna, kinuna ni Yahweh kenni Moises, “Bumangonka a masapa inton bigat, agtakderka iti sangoanan ni Faraon, ket ibagam kenkuana, ‘Kinuna daytoy ni Yahweh, ti Dios dagiti Hebreo: “Palubosam a mapan dagiti tattaok tapno makapagdayawda kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ta iti daytoy a tiempo ibaonko amin a didigrak kenka, kadagiti adipenmo ken kadagiti tattaom. Aramidek daytoy tapno maamoanyo nga awan ti siasinoman a kas kaniak iti entero a lubong. ");
INSERT INTO iloulb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ita, inyunnatko koman ti imak ket dinusaka ken dagiti tattaom iti sakit, ket napukawkayo koman manipud iti daga. ");
INSERT INTO iloulb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ngem daytoy iti makagapu a pinalubosankayo nga agbiag: tapno maipakitak ti pannakabalinko kadakayo, tapno maiwaragawag ti naganko iti entero a lubong. ");
INSERT INTO iloulb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ipanpannakkelmo latta ti bagim maibusor kadagiti tattaok babaen iti saanmo a panangpalubos kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Dumngegka! Inton bigat iti kastoy nga oras mangiyegak iti nakapigpigsa a bagyo ti uraro, a saan pay a nakita iti Egipto manipud iti aldaw a nangrugi daytoy agingga ita. ");
INSERT INTO iloulb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ita ngarud, mangibaonka kadagiti lallaki ket alaenda dagiti tarakenyo nga ayup ken amin a banbanag nga adda iti kataltalonan ket ipanyo iti natalged a lugar. Agtupakto ti uraro kadagiti tattao ken ayup nga adda iti taltalon a saan a naiyawid, ket mataydanto.”'” ");
INSERT INTO iloulb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ket nagdardaras dagiti adipen ni Faraon a namati iti mensahe ni Yahweh a nangiyawid kadagiti tagabu ken tarakenda nga ayup kadagiti balayda. ");
INSERT INTO iloulb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ngem binaybayaan dagiti saan a nangipangag iti mensahe ni Yahweh dagiti tagabu ken dagiti tarakenda nga ayup iti kataltalonan. ");
INSERT INTO iloulb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kalpasanna, kinuna ni Yahweh kenni Moises, “Iyunnatmo ta imam nga agturong iti tangatang tapno agtudo iti uraro iti amin a daga ti Egipto, kadagiti tattao, kadagiti ayup, ken kadagiti amin a mulmula iti kataltalonan iti entero a daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Inyunnat ni Moises ti bastonna nga agturong iti tangatang, ket nangibaon ni Yahweh iti gurruod, uraro, ken kimat iti daga. Pinagtudona pay iti uraro iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Isu a nagtudo ti uraro ken napakuyogan iti kimat, nakaro unay, a saan pay a napadpadasan iti entero a daga ti Egipto manipud idi nagbalin a nasion daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Iti entero a daga ti Egipto, tinupakan ti uraro dagiti amin nga adda iti kataltalonan, dagiti tattao ken dagiti ayup. Dinadael daytoy ti tunggal mula iti kataltalonan ken tinukkol daytoy ti tunggal kayo. ");
INSERT INTO iloulb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Iti laeng daga ti Gosen, a pagnanaedan dagiti Israelita, ti awan urarona. ");
INSERT INTO iloulb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ket nangibaon ni Faraon kadagiti lallaki a mangayab kada Moises ken Aaron. Kinunana kadakuada, “Nagbasolak ita. Nalinteg ni Yahweh, ket managdakdakesak ken dagiti tattaok. ");
INSERT INTO iloulb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Agkararagkayo kenni Yahweh, gapu ta napigsa unay ti gurruod ken adu-unay ti uraro. Palubosankayon, ken saankayonton nga agnaed ditoy.” ");
INSERT INTO iloulb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kinuna ni Moises kenkuana, “Apaman a panawak ti siudad, iyunnatkonto dagiti imak kenni Yahweh. Agsardengto ti gurruod, ken awanton ti uraro. Iti daytoy a wagas maammoanyonto a kukua ni Yahweh ti lubong. ");
INSERT INTO iloulb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ngem kenka ken kadagiti adipenmo, ammok a saanyo pay laeng a pudpudno a daydayawen ni Yahweh a Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ita, nadadael dagiti lino ken dagiti sebada, ta natangkenen dagiti dawa ti sebada, ken nakabuselen dagiti lino. ");
INSERT INTO iloulb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ngem saan a nadadael dagiti trigo ken senteno gapu ta maud-udi ti panagdawada. ");
INSERT INTO iloulb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Idi pinanawan ni Moises ni Faraon ken ti siudad, inyunnatna dagiti imana kenni Yahweh; nagsardeng ti gurruod ken dagiti uraro, ken nagsardengen ti tudo. ");
INSERT INTO iloulb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Idi nakita ni Faraon a nagsardengen ti tudo, uraro, ken gurruod, nagbasol manen isuna ken pinatangkenna ti pusona, ken uray pay dagiti adipenna. ");
INSERT INTO iloulb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Napatangken ti puso ni Faraon, isu a saanna a pinalubosan a mapan dagiti tattao ti Israel. Kastoy ti wagas nga imbaga ni Yahweh kenni Moises nga aramiden ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kinuna ni Yahweh kenni Moises, “Mapanka kenni Faraon, gapu ta pinatangkenko ti pusona ken dagiti puso dagiti adipenna. Inaramidko daytoy tapno ipakitak dagitoy a pagilasinan ti pannakabalinko kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Inaramidko pay daytoy tapno maibagam kadagiti annak ken appokom dagiti banbanag nga inaramidko, no kasano kagubsang ti panangtratok iti Egipto, ken no kasano ti panangitedko kadagiti nadumaduma a pagilasinan ti pannakabalinko kadakuada. Iti daytoy a wagas, maammoanyonto a Siak ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Isu a napan da Moises ken Aaron kenni Faraon ket kinunada kenkuana, “Ni Yahweh, ti Dios dagiti Hebreo, imbagana daytoy: 'Kasano pay kabayag iti panagkedkedmo nga agpakumbaba iti sangoanak? Palubosam a mapan dagiti tattaok tapno makapagdayawda kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ngem no agkedkedka a mangpalubos kadagiti tattaok, dumngegka, inton bigat, mangiyegakto kadagiti dudon iti dagam. ");
INSERT INTO iloulb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Abbongandanto ti rabaw ti daga tapno awanto ti siasinoman a makakita iti daga. Kanendanto dagiti aniaman a nabati a nakalasat manipud ti uraro. Kanendanto pay iti tunggal kayo a dimmakkel para kadakayo kadagiti talon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Punoendanto dagiti balayyo, dagiti balay dagiti amin nga adipenyo, ken dagiti amin nga Egipcio—maysa a banag a saan pay a pulos a nakita ti amayo wenno apongyo, nga awan pay a pulos ti nakakita sipud pay ti aldaw nga addada iti rabaw ti daga agingga iti agdama nga aldaw.” Ket pinanawan ni Moises ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kinuna ti adipen ni Faraon kenkuana, “Kasano pay kabayag nga agbalin a peggad daytoy a tao kadatayo? Palubosam dagiti Israelita a mapan tapno makapagdayawda kenni Yahweh a Diosda. Saanmo pay kadi a maamiris a nadadaelen ti Egipto?” ");
INSERT INTO iloulb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Naayaban manen da Moises ken Aaron kenni Faraon, a nagkuna kadakuada,” Inkayo dayawen ni Yahweh a Diosyo. Ngem siasinonto dagiti tattao a mapan?” ");
INSERT INTO iloulb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Kinuna ni Moises, “Mapankaminto a kaduami dagiti ubbingmi ken agraman dagiti nataenganmi, dagiti annakmi a lallaki ken babbai. Mapankaminto agraman dagiti arbanmi, ken dagiti tarakenmi ta masapul a mangaramidkami iti fiesta para kenni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kinuna ni Faraon kadakuada, “Pudno koma nga adda ni Yahweh kadakayo, no palubosankayo ken dagiti annakyo. Kitaenyo, adda sumagmamano a kinadakes iti panunotyo. ");
INSERT INTO iloulb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Saan! Dakayo laeng a lallaki ti mapan, ken agdayaw kenni Yahweh, ta dayta ti kayatyo.” Ket napapanaw da Moises ken Aaron iti imatang ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kalpasanna, kinuna ni Yahweh kenni Moises, “Iyunnatmo ta imam nga agturong ti daga iti Egipto kadagiti dudon, tapno mapanda iti daga ti Egipto ket kanenda ti tunggal mula iti daytoy, amin a banag nga imbati ti uraro.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Inyunnat ni Moises ti sarukodna nga agturong iti daga ti Egipto, ket nangiyeg ni Yahweh iti angin ti daya nga agturong iti entero a daga iti agmalem ken agpatnag. Kabigatanna, inyeg ti angin ti daya dagiti dudon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Napan dagiti dudon iti entero a daga ti Egipto ket dinadaelda amin a paset daytoy. Adu unay a dudon a saan pay a pulos a dimteng iti daga ken saanton a pulos a makita manen. ");
INSERT INTO iloulb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Inabbonganda ti rabaw iti entero a daga isu a simmipnget. Kinnanda ti tunggal mula iti daga ken amin a bunga dagiti kayo nga imbati ti uraro. Iti entero a daga iti Egipto, awan ti nabati a nalangto a mula, wenno aniaman a kayo wenno mula kadagiti talon. ");
INSERT INTO iloulb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kalpasanna, dagus a pinaayaban ni Faraon da Moises ken ni Aaron ket kinunana, “Nagbasolak kenni Yahweh a Diosyo ken kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ita ngarud, pakawanenyo ti basolko iti daytoy a tiempo, ken agkararagkayo kenni Yahweh a Diosyo tapno iyadayona daytoy nga ipapatay kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Pinanawan ngarud ni Moises ni Faraon ken nagkararag kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nangiyeg ni Yahweh ti nakapigpigsa nga angin ti laud a nangikkat kadagiti dudon ken inturongna ida iti Baybay dagiti Runo; awan ti uray maysa a dudon ti nabati iti amin a masakupan iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ngem pinatangken ni Yahweh ti puso ni Faraon, ket saan a pinalubosan ni Faraon a mapan dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kalpasanna, kinuna ni Yahweh kenni Moises, “Iyunnatmo ta imam nga agturong iti tangatang, tapno maaddaan iti kinasipnget ti entero a daga iti Egipto, kinasipnget a mariknada.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Inyunnat ni Moises ti imana nga agturong iti tangatang, ket nagsipnget ti entero a daga ti Egipto iti tallo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Saanda a makapagkikinnita; awan ti pimmanaw iti balayna iti tallo nga aldaw. Nu pay kasta, adda lawag iti lugar a pagnanaedan dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pinaayaban ni Faraon ni Moises ket kinunana, “Inkayo dayawen ni Yahweh. Mabalin a kumuyog kadakayo a mapan uray dagiti pamiliayo, ngem masapul a mabati dagiti arban ken tarakenyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ngem kinuna ni Moises, “Masapul nga ikkanakami met kadagiti ayup para kadagiti daton ken daton a mapuoran tapno makaidatonkami kenni Yahweh a Diosmi. ");
INSERT INTO iloulb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Masapul nga ikuyogmi met dagiti tarakenmi nga ay-ayup; awan ti uray maysa a mabati kadakuada, ta masapul nga alaenmi dagitoy nga agdayaw kenni Yahweh a Diosmi. Ta saanmi pay nga ammo ti masapul a pangdayawmi kenni Yahweh agingga a makasangpetkami sadiay.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ngem pinatangken ni Yahweh ti puso ni Faraon, ken saanna ida a palubosan a mapan. ");
INSERT INTO iloulb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Kinuna ni Faraon kenni Moises, “Adaywannak! Agannadka maipanggep iti maysa a banag, a saanka nga agpakita manen kaniak, ta ti aldaw a makitam ti rupak, mataykanto.” ");
INSERT INTO iloulb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Kinuna ni Moises, “Sika a mismo ti nagsao. Saankonto a makita manen ti rupam.” ");
INSERT INTO iloulb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Kalpasanna, kinuna ni Yahweh kenni Moises, “Adda pay ti maysa a didigra nga iyegko kenni Faraon ken iti Egipto. Kalpasan dayta, palubosannakayonto a pumanaw manipud ditoy. Inton palubosannakayo, papanawennakayonton a naan-anay. ");
INSERT INTO iloulb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Bilinem dagiti tattao a dumawat ti tunggal lalaki ken babai iti alahas a pirak ken balitok iti kaarrubada. ");
INSERT INTO iloulb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ita, inaramid ti Dios a nagagar dagiti Egipcio a mangay-ayo kadagiti Israelita. Maysa pay, nakaay-ayo unay ti lalaki a ni Moises iti imatang dagiti adipen ni Faraon ken kadagiti tattao iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kinuna ni Moises, “Kinuna ni Yahweh daytoy: “Inton tengnga ti rabii, mapanakto iti entero nga Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Matayto amin nga inauna nga annak iti daga ti Egipto, manipud iti inauna nga anak ni Faraon, nga agtugtugaw iti tronona, agingga iti inauna nga anak ti tagabu a babai nga adda iti likudan ti paggilingan nga aggilgiling, ken dagiti amin nga inauna nga annak dagiti taraken nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ket addanto ti napigsa a panagdung-aw iti entero a daga ti Egipto, a saan pay a napamasak wenno saanto a pulos a mapasamak manen. ");
INSERT INTO iloulb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ngem awanto ti uray aso nga agtaul iti aniaman kadagiti tattao ti Israel, iti tao man wenno narungsot nga ayup. Iti daytoy a wagas, maammoanyonto nga agduma ti panangtratok kadakayo nga Egipcio ken kadakayo nga Israelita.' ");
INSERT INTO iloulb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Amin dagitoy nga adipenmo, Faraon, umaydanto ket agrukbabda kaniak. Ibagadanto, “Inkayo, sika ken amin a tattao a sumursurot kenka!” Kalpasan dayta pumanawakto.” Ket pinanawanna ni Faraon a kasta unay ti pungtotna. ");
INSERT INTO iloulb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kinuna ni Yahweh kenni Moises, “Saanto a dumngeg kenka ni Faraon. Mapasamak daytoy tapno agaramidakto kadagiti adu a nakakaskasdaaw a banbanag iti daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Inaramid amin da Moises ken Aaron dagitoy a nakakaskasdaaw a banbanag iti sangoanan ni Faraon. Ngem pinatangken ni Yahweh ti puso ni Faraon, ket saan a pinalubosan ni Faraon a rummuar iti dagana dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nagsao ni Yahweh kada Moises ken Aaron idiay daga ti Egipto. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Daytoy a bulan ket ti rugi dagiti bulan para kadakayo, ti umuna a bulan ti tawen kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ibagayo iti taripnong ti Israel, 'Iti maika-sangapulo nga aldaw iti daytoy a bulan, masapul a mangala ti tunggal maysa kadakuada iti karnero wenno urbon a kalding para kadakuada, aramiden daytoy iti tunggal pamilya, maysa a karnero para iti tunggal sangkabalayan. ");
INSERT INTO iloulb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","No ti bumalay ket bassit unay para iti karnero, mangala ti lalaki ken ti kaarrubana iti karne ti karneno wenno urbon a kalding nga umdas para iti bilang dagiti tattao. Masapul nga umanay daytoy a kanen ti tunggal maysa, isu a nasken nga alaenda ti karne nga umanay a kanenda amin. ");
INSERT INTO iloulb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Masapul nga awan ti tulaw ti karnero wenno ubing a kaldingyo, maysa ti tawenna a kalakian. Mabalinkayo a mangala iti maysa kadagiti karnero wenno kalding. ");
INSERT INTO iloulb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Masapul nga aywananyo daytoy agingga iti maika-sangapulo ket uppat nga aldaw iti dayta a bulan. Kalpasanna, masapul a patayen ti sibubukel a taripnong ti Israel dagitoy nga ayup iti sumipnget. ");
INSERT INTO iloulb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Masapul a mangalakayo iti dara ket ikabilyo daytoy kadagiti dua a poste ti ridaw ken iti ngatoen ti hamba ti ridaw dagiti babbalay a pangananyonto iti karne. ");
INSERT INTO iloulb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Masapul a kanenyo ti karne iti dayta a rabii, kalpasan a maitunoyo nga umuna daytoy iti apuy. Ikaanyo daytoy iti tinapay nga awan lebadurana, ken ikaanyo daytoy iti napait a mulmula. ");
INSERT INTO iloulb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Saanyo a kanen daytoy a saan a naluto wenno naipaburek iti danum. Ngem ketdi, itunoyo daytoy iti apuy nga adda ti ulo, saksaka ken dagiti nagunegna. ");
INSERT INTO iloulb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Masapul nga awan ti aniaman nga itiddayo agingga iti bigat. Masapul a puoranyo ti aniaman a natiddayo iti bigat. ");
INSERT INTO iloulb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kastoy ti masapul a pannanganyo: nakabarikeskayo, nakasapatos ken iggemyo ti sarrukodyo. Masapul a darasenyo daytoy a kanen. Ilalabas daytoy ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ibagbaga ni Yahweh daytoy: Mapanakto iti entero a daga ti Egipto iti dayta a rabii ket rautek amin nga inauna nga anak ti tao ken ayup iti daga ti Egipto. Iyegkonto ti pannakadusa kadagiti amin a dios ti Egipto. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Agbalinto a pagilasinan kadagiti babbalayyo ti dara para iti iyuumayko kadakayo. Inton makitak ti dara, labsankayonto inton rautek ti daga ti Egipto. Saanto nga umay kadakayo daytoy a didigra ket saannakayonto a madadael. ");
INSERT INTO iloulb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Agbalinto daytoy nga aldaw a pakalaglagipan para kadakayo, a masapul a ngilinenyo a kas fiesta para kenni Yahweh. Paglinteganto daytoy a kankanayon kadakayo, kadagiti amin a henerasion dagiti tattaoyo, a masapul a ngilinenyo daytoy nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mangankayonto iti tinapay nga awan lebadurana bayat iti pito nga aldaw. Iti umuna nga aldaw, ikkatenyonto ti lebadura manipud kadagiti babbalayyo. Ti siasinoman a mangan iti tinapay nga adda lebadurana manipud iti umuna nga aldaw agingga iti maika-pito nga aldaw, dayta a tao ket masapul a maikkat manipud iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Addanto iti gimong a maipaay kaniak iti umuna nga aldaw ken addanto manen iti kasta met laeng a panagtitipon iti maika-pito nga aldaw. Awanto ti trabaho a maaramid kadagitoy nga al-aldaw malaksid iti panagluto para iti kanen ti tunggal maysa. Masapul a dayta laeng ti trabaho nga aramidenyo. ");
INSERT INTO iloulb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Masapul a ngilinenyo daytoy a Fiesta ti Tinapay nga Awan Lebadurana gapu ta daytoy ti aldaw nga impanawko dagiti tattaoyo, dagiti buybuyot, manipud iti daga ti Egipto. Isu a masapul a ngilinenyo daytoy nga aldaw iti entero a henerasion dagiti tattaoyo. Paglinteganto daytoy a kankanayon para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Masapul a mangankayo iti tinapay nga awan lebadurana manipud iti sumipnget iti maika-sangapulo ket uppat nga aldaw iti umuna a bulan ti tawen agingga iti sumipnget iti maika-duapulo ket maysa nga aldaw iti dayta a bulan. ");
INSERT INTO iloulb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Kabayatan dagitoy a pito nga aldaw, masapul nga awan ti masarakan a lebadura kadagiti babbalayyo. Ti siasinoman a mangan iti tinapay nga adda lebadurana ket masapul a maikkat manipud kadagiti tattao ti Israel, gan-gannaet man dayta a tao wenno maysa a tao a naiyanak iti dagayo. ");
INSERT INTO iloulb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Masapul nga awan ti kanenyo nga adda lebadurana. Sadinoman ti pagnaedanyo, masapul a mangankayo iti tinapay nga awan lebadurana.'” ");
INSERT INTO iloulb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Inayaban ngarud ni Moises dagiti amin a panglakayen ti Israel ket kinunana kadakuada, “Mapankayo ket mangpilikayo kadagiti karnero wenno urbon a kalding nga umanay a kanen dagiti pamilyayo ket patayenyo ti karnero a maipaay iti Ilalabas. ");
INSERT INTO iloulb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kalpasanna mangalakayo iti sangareppet a hisopo ket isawsawyo daytoy iti dara nga adda iti palanggana. Ipunasyo ti dara nga adda iti palanggana iti ngatoen ti hamba ti ridaw ken kadagiti dua a postena. Masapul nga awan ti rumuar kadakayo iti ridaw agingga iti bigat. ");
INSERT INTO iloulb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ta lumabasto ni Yahweh a mangraut kadagiti Egipcio. Inton makitana ti dara iti ngatoen ti hamba ti ridaw ken kadagiti dua a poste ti ridaw, labsannanto ti ridawyo ket saanna a palubusan ti mangdaddadael a sumrek kadagiti babbalayyo a mangraut kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Masapul a ngilinenyo daytoy a pasamak. Paglinteganto daytoy a kankanayon kadakayo ken kadagiti kaputotanyo. ");
INSERT INTO iloulb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Inton sumrekkayo iti daga nga itedto ni Yahweh kadakayo, kas inkarina nga aramiden, masapul a ngilinenyo daytoy nga aramid iti panagdayaw. ");
INSERT INTO iloulb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Inton saludsudendakayo dagiti annakyo, 'Ania ti kayat a sawen daytoy nga aramid iti panagdayaw?' ");
INSERT INTO iloulb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ket masapul nga ibagayo, 'Daytoy ti daton ti Ilalabas ni Yahweh, gapu ta linabsan ni Yahweh dagiti babbalay dagiti Israelita idiay Egipto idi rinautna dagiti Egipcio. Winayawayaanna dagiti bumalaymi.'” Kalpasanna, nagdumog dagiti tattao ket dinaydayawda ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Napan dagiti Israelita ket inaramidda nga apag-isu kas imbilin ni Yahweh kada Moises ken Aaron. ");
INSERT INTO iloulb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Napasamak iti tengnga ti rabii a rinaut ni Yahweh dagiti amin nga inauna idiay daga ti Egipto, manipud iti inauna nga anak ni Faraon, a nagtugaw iti tronona, aginggana iti inauna nga anak ti tao nga adda iti pagbaludan ken amin nga inauna nga anak dagiti dingwen. ");
INSERT INTO iloulb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Bimmangon ni Faraon iti rabii - isuna, dagiti adipenna, ken amin nga Egipcio. Adda iti napigsa a panagan-anug-og idiay Egipto gapu ta awan ti balay idiay nga awan natayna. ");
INSERT INTO iloulb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Inayaban ni Faraon ni Moises ken ni Aaron iti rabii ket kinunana, “Inkayo, pumanawkayon manipud kadagiti tattaok, dakayo ken dagiti Israelita. Mapankayo ket dayawenyo ni Yahweh, a kas imbagayo a kayatyo nga aramiden. ");
INSERT INTO iloulb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Alaenyo dagiti arban ken pangenyo, a kas kunayo, ket mapankayo, ken bendisionandak met.” ");
INSERT INTO iloulb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Agdardaras unay dagiti Egipcio a mangpapanaw kadakuada manipud iti dagada, ta kinunada, “Mataykami aminen.” ");
INSERT INTO iloulb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Innala ngarud dagiti tattao dagiti masada nga awan laukna a lebadura. Nakagaluten dagiti pagmasaan a mallukong kadagiti kawesda ken kadagiti abagada. ");
INSERT INTO iloulb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ita, inaramid dagiti tattao ti Israel ti imbaga ni Moises kadakuada. Dinawatanda dagiti Egipcio kadagiti pirak, balitok ken kawkawes. ");
INSERT INTO iloulb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Pinagagar ni Yahweh dagiti Egipcio a mangay-ayo kadagiti Israelita. Isu nga inted dagiti Egipcio ti aniaman a dinawatda. Iti daytoy a wagas, sinamsam dagiti Israelita dagiti aniaman nga adda kadagiti Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nagdaliasat dagiti Israelita manipud Rameses agingga iti Sucot. Agarup 600, 000 a lallaki ti bilangda, a mainayon pay dagiti babbai ken ubbing. ");
INSERT INTO iloulb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Kimmuyog pay kadakuada ti nadumaduma a saan nga Israelita, a tugotda dagiti arban ken pangen, adu unay a bilang dagiti dingwen. ");
INSERT INTO iloulb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Naglutoda iti tinapay nga awan lebadurana iti masa nga intugotda manipud Egipto. Awan lebadurana gapu ta napapanawda manipud Egipto ket saanda a mabalin nga itantan tapno mangisagana iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nagnaed dagiti Israelita idiay Egipto iti 430 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Iti ileleppas iti 430 a tawen, iti dayta a mismo nga aldaw, rimuar amin dagiti buyot ni Yahweh manipud iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Daytoy ti rabii a masapul nga agtalinaed a siririing, para kenni panangipanaw ni Yahweh kadakuada iti daga ti Egipto. Daytoy ket rabii ni Yahweh a masapul a ngilinen ti amin nga Israelita iti entero a henerasion dagiti tattaoda. ");
INSERT INTO iloulb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kinuna ni Yahweh kada Moises ken Aaron, “Adtoy ti annuruten para iti Ilalabas: awan ti gan-gannaet a mabalin a makibingay a mangan iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nupay kasta, tunggal tagabo dagiti Israelita, a nagatang, mabalinna a mangan iti daytoy kalpasan a makugityo isuna.” ");
INSERT INTO iloulb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Masapul a saan a mangan dagiti gan-gannaet ken dagiti matangtangdanan nga adipen iti uray ania iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Masapul a kanen ti taraon iti maymaysa a balay. Masapul a saanyo nga iruar iti balay ti aniaman kadagiti karne, ken masapul a saanyo a tuktukkulen ti aniaman a tulangna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Masapul a ngilinen dagiti amin a tattao ti Israel ti fiesta. ");
INSERT INTO iloulb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","No adda ti makipagnanaed kadakayo a gan-gannaet ket kayatna a ngilinen ti Ilalabas para kenni Yahweh, masapul a makugit dagiti amin a lallaki a kabagianna. Ket mabalinto isunan nga umay ket ngilinenna daytoy. Agbalinto isuna a kasla kadagiti tattao a naiyanak iti daga. Nupay kasta, saan a mabalin a mangan ti saan a nakugit a tao iti aniaman iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Daytoy a linteg ket maipakat met laeng para kadagiti naipasngay iti dayta a daga ken kadagiti gan-gannaet a makipagnanaed kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Inaramid ngarud dagiti amin nga Israelita ti imbilin ni Yahweh kada Moises ken Aaron. ");
INSERT INTO iloulb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Napasamak iti dayta nga aldaw nga impanaw ni Yahweh dagiti buyot ti Israel manipud iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nagsao ni Yahweh kenni Moises ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Idatonmo kaniak dagiti amin nga inauna nga anak, tunggal inauna nga anak a lalaki kadagiti Israelita, tattao ken ayup. Kukuak dagiti inauna.” ");
INSERT INTO iloulb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kinuna ni Moises kadagiti tattao, “Imulayo daytoy nga aldaw kadagiti panunotyo, ti aldaw a pimmanawkayo manipud Egipto, manipud iti balay ti pannakatagabu, ta impanawnakayo ni Yahweh manipud iti daytoy a lugar babaen iti napigsa nga imana. Awan ti tinapay nga adda lebadurana ti mabalin a kanen. ");
INSERT INTO iloulb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Rumuarkayo manipud Egipto iti daytoy nga aldaw, iti bulan ti Abib. ");
INSERT INTO iloulb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Inton ipannakayo ni Yahweh iti daga dagiti Cananeo, Heteo, Amorreo, Hebeo, ken dagiti Jebuseo, ti daga nga inkarina kadagiti kapuonanyo nga itedna kadakayo, daga a kasla agay-ayus ti gatas ken diro - ket masapul a ngilinenyo daytoy nga aramid a panagdayaw iti daytoy a bulan. ");
INSERT INTO iloulb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Iti pito nga aldaw, masapul a mangankayo iti tinapay nga awan lebadurana; iti maika-pito nga aldaw, addanto iti padaya a pammadayaw kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ti tinapay nga awan lebadurana ti masapul a kanen bayat iti pito nga aldaw; masapul nga awan ti makita a tinapay nga adda lebadurana kadakayo. Masapul nga awan ti makita a lebadura kadakayo iti uray sadinoman iti uneg dagiti beddengyo. ");
INSERT INTO iloulb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Iti dayta nga aldaw, ibagayonto kadagiti annakyo, ‘Daytoy ket gapu iti inaramid ni Yahweh kaniak idi pimmanawak manipud Egipto. ’ ");
INSERT INTO iloulb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Agbalinto daytoy a palagip kadakayo dita imayo, ken palagip kadakayo dita mugingyo. Daytoy ket tapno ti linteg ni Yahweh ket adda koma dita ngiwatyo, ta impanawnakayo ni Yahweh manipud Egipto babaen iti napigsa nga imana. ");
INSERT INTO iloulb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ngarud, masapul a tinawenyo nga aramiden daytoy a paglintegan iti naituding a tiempona. ");
INSERT INTO iloulb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Inton iyegnakayo ni Yahweh iti daga dagiti Cananeo, kas insapatana kadakayo ken kadagiti kapuonanyo, ken inton itedna ti daga kadakayo, ");
INSERT INTO iloulb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","masapul nga ilasinyo para kenkuana ti tunggal inauna nga anak ken ti umuna nga anak dagiti ayupyo. Kukuanto ni Yahweh dagiti lallaki. ");
INSERT INTO iloulb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tunggal inauna nga asno ket masapul a masukatan iti karnero. Ngem no saanyo a kayat daytoy a sukatan, masapul ngarud a tukkolenyo ti tengngedna. Ngem iti tunggal inauna nga anak a lalaki kadagiti annakyo a lalaki - masapul a subbotenyo ida. ");
INSERT INTO iloulb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Inton saludsudennakayo ti anakyo a lalaki, 'Ania ti kayatna a sawen daytoy?' ket masapul nga ibagayo kenkuana, 'Babaen iti napigsa nga ima nga impanawnakami ni Yahweh iti Egipto, manipud iti balay ti pannakatagabu. ");
INSERT INTO iloulb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Idi sipapatangken a nagkedked ni Faraon a mangpalubos kadakami, pinatay ni Yahweh amin nga inauna nga annak idiay daga ti Egipto, dagiti inauna nga anak dagiti tattao ken dagiti ayup. Dayta ti gapuna nga idatonko kenni Yahweh amin nga inauna nga anak a lalaki dagiti ayup, ken no apay a subbotek dagiti inauna kadagiti annakko a lalaki.' ");
INSERT INTO iloulb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Agbalinto daytoy a palagip dita imayo, ken palagip dita mugingyo, ta impanawnakayo ni Yahweh iti Egipto babaen iti napigsa nga imana.'' ");
INSERT INTO iloulb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Idi pinalubosan ni Faraon dagiti tattao, saan ida nga inturong ti Dios iti dalan a mapan iti daga dagiti Filisteo, uray no asideg dayta a daga. Ta kinuna ti Dios, “Amangan no agbaliw ti panunot dagiti tattao inton mapadasanda ti makigubat ket agsublida idiay Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Inlikaw ngarud nga inturong ti Dios dagiti tattao idiay let-ang a mapan idiay Baybay dagiti Runo. Simmang-at dagiti Israelita manipud Egipto a nakasagana a makigubat. ");
INSERT INTO iloulb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Intugot ni Moises dagiti tulang ni Jose, ta siiinget a pinagsapata ni Jose dagiti Israelita ket kinunana, “Awan duadua nga ispalennakayo ti Dios, ket masapul nga itugotyo dagiti tulangko.” ");
INSERT INTO iloulb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nagdaliasat dagiti Israelita manipud Succot ket nagkampoda idiay Etam idiay pungto ti let-ang. ");
INSERT INTO iloulb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Adda ni Yahweh iti sangoananda iti aldaw babaen iti kasla adigi nga ulep a mangiturong kadakuada iti dalan. Iti rabii, adda isuna babaen iti kasla adigi nga apuy a manglawag kadakuada. Iti daytoy a wagas, makapagdaliasatda iti aldaw ken iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Saan nga inikkat ni Yahweh kadagiti tattao ti kasla adigi nga ulep iti aldaw ken kasla adigi nga apuy iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nakisarita ni Yahweh kenni Moises: ");
INSERT INTO iloulb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ibagam kadagiti Israelita a masapul nga agsublida ken agkampoda sakbay iti Pi Hahirot, ti nagbaetan ti Migdol ken iti baybay, sakbay iti Baal Zefon. Masapul nga agkampokayo iti abay ti baybay iti bangir iti Pi Hahirot. ");
INSERT INTO iloulb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ibaganto ni Faraon maipanggep kadagiti Israelita, 'Agalla-allada iti daga. Linappedan ida ti let-ang.' ");
INSERT INTO iloulb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Patangkenekto ti puso ni Faraon, ket kamatennanto ida. Maidaydayawakto gapu kenni Faraon ken kadagiti amin nga armadana. Maammoanto dagiti Egipcio a siak ni Yahweh.” Isu a nagkampo dagiti Israelita a kas naibilin kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Idi naibaga iti ari ti Egipto a nakapanawen dagiti Israelita, nagbaliw ti panunot ni Faraon ken dagiti adipenna maibusor kadagiti tattao. Kinunada, “Ania ti inaramidtayo a pinalubosantayo dagiti Israelita a mawayawayaan iti panagtrabahoda para kadatayo?” ");
INSERT INTO iloulb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ket impaisagana ni Faraon dagiti karwahena ket inkuyogna dagiti armadana. ");
INSERT INTO iloulb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Inkuyogna dagiti innem a gasut a napili a karwahe ken dagiti dadduma a karwahe ti Egipto, nga addaan amin kadagiti opisial. ");
INSERT INTO iloulb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pinatangken ni Yahweh ti puso ni Faraon, ti ari ti Egipto, ket kinamatna dagiti Israelita. Ita, nagballigi a nakapanaw dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ngem kinamat ida dagiti Egipcio a kaduada dagiti amin a kabalyo ken karwahena, dagiti kumakabalyo ken dagiti armadana. Naabutanda dagiti Israelita a nagkampo iti igid ti baybay iti asideg ti Pi Hahirot, sakbay iti Baal Zefon. ");
INSERT INTO iloulb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Idi umas-asidegen ni Faraon, kimmita dagiti Israelita ket nakigtotda. Magmagna dagiti Egipcio a sumarsaruno kadakuada, ket nagbutengda. Immawag dagiti Israelita kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Imbagada kenni Moises, “Gapu kadi ta awan iti pangitaneman idiay Egipto, isu nga inkuyognakami nga umadayo tapno matay iti let-ang? Apay a kastoy ti panangtratom kadakami, nga impanawdakami idiay Egipto? ");
INSERT INTO iloulb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Saan aya a daytoy ti imbagami idiay Egipto? Imbagami kenka, 'Panawandakami, tapno makapagtrabahokami para kadagiti Egipcio. Nasaysayaat pay koma para kadakami nga agtrabaho kadakuada ngem ti matay iti let-ang.”' ");
INSERT INTO iloulb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kinuna ni Moises kadagiti tattao, “Saankayo nga agbuteng. Agtakderkayo laeng ket kitaenyo ti panangispal ni Yahweh kadakayo iti daytoy nga aldaw. Ta saanyonton pulos a makita pay dagiti Egipcio a makitkitayo iti daytoy nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ni Yahweh ti makiranget para kadakayo, ket agtakderkayo laeng.” ");
INSERT INTO iloulb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ket kinuna ni Yahweh kenni Moises, “Apay a sika, Moises kanayonka nga umaw-awag kaniak? Ibagam kadagiti Israelita nga ituloyda iti magna. ");
INSERT INTO iloulb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ingatom ti sarrukodmo, iyunnatmo dayta imam iti baybay ken guduaem daytoy iti dua, tapno makapagna dagiti tattao iti Israel a mapan iti baybay babaen iti namaga a daga. ");
INSERT INTO iloulb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Agsiputkayo ta patangkenekto ti puso dagiti Egipcio tapno sumarunoda kadakayo. Maidaydayawakto gapu kenni Faraon ken kadagiti amin nga armadana, kadagiti karwahena, ken kadagiti kumakabalyo a tattaona. ");
INSERT INTO iloulb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ket maamoanto dagiti Egipcio a siak ni Yahweh inton magun-odko ti dayaw gapu kenni Faraon, kadagiti karwahena, ken kadagiti kumakabalyona.” ");
INSERT INTO iloulb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ti anghel ti Dios, nga agdaldaliasat iti sangoanan dagiti Israelita, ket immakar ken napan iti likudanda. Ti adigi nga ulep ket immakar manipud kadakuada ket napan nagtakder iti likudanda. ");
INSERT INTO iloulb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Napan ti ulep iti nagbaetan iti kampo ti Egipto ken ti kampo iti Israel. Daytoy ket nasipnget nga ulep kadagiti Egipcio, ngem nanglawag kadagiti Israelita iti rabii, isu a saan a makainnasideg iti agsinnumbangir iti nagpatnag. ");
INSERT INTO iloulb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Inyunnat ni Moises ti imana iti baybay. Induron ni Yahweh ti baybay babaen iti napigsa nga angin nga aggapu iti daya iti agpatnag ket nagbalin ti baybay a namaga a daga. Iti daytoy a wagas naggudua ti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Napan dagiti Israelita iti tengnga iti baybay iti namaga a daga. Nagporma a pader ti danum para kadakuada iti makannawan nga imada ken makannigid nga imada. ");
INSERT INTO iloulb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Kinamat ida dagiti Egipcio. Simmarunoda kadakuada iti tengnga ti baybay—amin a kabalyo ni Faraon, karawahe ken kumakabalyo. ");
INSERT INTO iloulb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ngem iti agsapa, kimmita ni Yahweh kadagiti armada ti Egipcio babaen iti adigi nga apuy ken ulep. Pinagkakaribusona dagiti Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Naikkat dagiti dalig ti karwahe, ken dagiti kumakabalyo ket narigatanda a nangiturong. Isu a kinuna dagiti Egipcio, “Masapul nga umadayotayo manipud iti Israel, ta makirangranget ni Yahweh para kadakuada maibusor kadatayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kinuna ni Yahweh kenni Moises, “Iyunnatmo dayta imam iti baybay tapno agsubli ti danum kadagiti Egipcio, kadagiti karwaheda, ken kadagiti kumakabalyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ngarud, inyunnat ni Moises ti imana iti baybay, ket nagsubli iti kasisigud a langana idi nagparang iti agsapa. Naglibas dagiti Egipcio iti baybay, ket inturong ni Yahweh dagiti Egipcio iti tengngana daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nagsubli ti danum ket nalapunos dagiti karwahe ni Faraon, kumakabalyo, ken ti entero nga armada a simmaruno iti karwahe iti baybay. Awan ti siasinoman a nakalasat. ");
INSERT INTO iloulb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Nupay kasta, nagna dagiti Israelita iti namaga a daga iti tengnga ti baybay. Ti danum ti nagbalin a paderda iti makannawan ken iti makannigid nga imada. ");
INSERT INTO iloulb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Isu nga insalakan ni Yahweh ti Israel iti dayta nga aldaw manipud iti ima dagiti Egipcio, ken nakita ti Israel dagiti natay nga Egipcio iti igid ti baybay. ");
INSERT INTO iloulb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Idi nakita ti Israel ti naindaklan a pannakabalin nga inaramat ni Yahweh maibusor kadagiti Egipcio, pinadayawan dagiti tattao ni Yahweh, ken nagtalekda kenni Yahweh ken iti adipenna a ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Kalpasanna, kinanta ni Moises ken dagiti tattao ti Israel daytoy para kenni Yahweh. Kinantada, “Agkantaak para kenni Yahweh, ta nagballigi isuna a sidadayag: ti kabalyo ken ti nakasakay ket impuruakna iti baybay. ");
INSERT INTO iloulb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ni Yahweh ti pigsak ken kantak, ket isuna ti nagbalin a manangisalakanko. Daytoy ti Diosko, ket dayawek isuna, ti Dios ti amak, ket itag-ayko isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ni Yahweh ket mannakigubat; Yahweh ti naganna. ");
INSERT INTO iloulb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Intappuakna dagiti karwahe ken ti armada ni Faraon idiay baybay. Nalmes idiay baybay ti Runruno dagiti napili nga opisial ni Faraon. ");
INSERT INTO iloulb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Linipus ida ti danum; limnedda a kasla bato. ");
INSERT INTO iloulb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ti makannawan nga imam, Yahweh, ket nadayag ti pannakabalinna; ti makannawan nga imam, Yahweh, ket dinadaelna dagiti kabusor. ");
INSERT INTO iloulb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Iti naindaklan a kinatan-okmo, impurruakmo dagiti bimmusor kenka. Imbaonmo ti pungtotmo; inibusna ida a kas iti pananguram ti apuy iti garami. ");
INSERT INTO iloulb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Babaen ti bang-es iti agongmo, naipangato ti danum; ti agay-ayus a danum ket nagtakder a nalinteg a kasla bunton; ti nauneg a danum ket nagbalay iti katengngaan ti baybay. ");
INSERT INTO iloulb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kinuna ti kabusor, 'Kamatekto, kamakamekto, bingayekto ti nasamsam; mapnekto kadakuada ti tarigagayko; asutekto ti kampilak; dadaelento ti imak ida.' ");
INSERT INTO iloulb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ngem impuyupuymo ti anginmo, ket linapunos ida ti baybay; limnedda a kasla buli kadagiti napipigsa a danum. ");
INSERT INTO iloulb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Siasino ti kas kenka, Yahweh, kadagiti didiosen? Siasino ti kas kenka, nakaskasdaaw iti kinasantom, maidaydayaw kadagiti pammadayaw, agar-aramid kadagiti milagro? ");
INSERT INTO iloulb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Inyunnatmo ti makannawan nga imam ket inalun-on ida ti daga. ");
INSERT INTO iloulb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Iti kinapudnom iti katulagan, indalanmo dagiti tattao nga inispalmo. Iti pigsam, indalanmo isuda iti nasantoan a disso a pagnanaedam. ");
INSERT INTO iloulb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mangegto dagiti tattao, ket agpigergerdanto; panagbutengto ti mangtengngel kadagiti agnanaed iti Filistia. ");
INSERT INTO iloulb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ket agbutengto dagiti panguloen ti Edom; agpigergerto dagiti soldado iti Moab; marunawto dagiti amin nga agnanaed iti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kintayeg ken alliawto ti agdissuor kadakuada. Gapu iti pannakabalin ti takkiagmo, tumangkendanto a kasla bato agingga a makalabas dagiti tattaom, Yahweh—agingga a makalabas dagiti tattao nga inispalmo. ");
INSERT INTO iloulb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ipanmunto ida ket imulamto ida iti bantay iti tawidmo, ti lugar, Yahweh, nga inaramidmo a pagnaedam, ti santuario, Apomi, nga impatakder dagiti imam. ");
INSERT INTO iloulb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Agturay ni Yahweh iti agnanayon ken awan patinggana.” ");
INSERT INTO iloulb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ta napan dagiti kabalyo ni Faraon ken dagiti karwahena ken kumakabalyo idiay baybay. Insubli ni Yahweh kadakuada ti danum ti baybay. Ngem nagna dagiti Israelita iti namaga a daga iti tengnga ti baybay. ");
INSERT INTO iloulb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ni Miriam, ti propeta a kabsat ni Aaron, ket nangala iti pandareta, ket rimmuar dagiti amin a babbai nga addaan iti pandareta, a kaduana a nagsalsala. ");
INSERT INTO iloulb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Kinantaan ni Miriam isuda: “Agkanta para kenni Yahweh, ta sidadayag isuna a nagballigi. Ti kabalyo ken ti nakasakay iti daytoy ket intappuakna idiay baybay.” ");
INSERT INTO iloulb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ket indauloan ni Moises ti Israel manipud iti baybay dagiti Runo. Napanda iti let-ang ti Sur. Nagdalliasatda iti tallo nga aldaw iti let-ang ket awan nasarakanda a danum. ");
INSERT INTO iloulb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ket nakadanunda idiay Mara, ngem saanda a makainum iti danum sadiay gapu ta napait daytoy. Isu nga inawaganda dayta a lugar a Mara. ");
INSERT INTO iloulb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Isu a nagreklamo dagiti tattao kenni Moises ket kinunada, “Ania ti inumenmi?” ");
INSERT INTO iloulb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Isu nga immawag ni Moises kenni Yahweh, ket nangipakita ni Yahweh iti kayo kenkuana. Impurruak ni Moises ti kayo iti danum, ket nagbalin ti danum a nasam-it nga inumen. Sadiay a nangted ni Yahweh kadakuada iti nainget a linteg, ken sadiay ti nangsuotanna kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kinunana, “No dumngegkayo a naimbag iti timekko, Siak, ni Yahweh a Diosyo, ken aramidenyo no ania ti umno iti imatangko—ken no indenganyo dagiti bilinko ken agtulnogkayo kadagiti amin a lintegko, saankayonto nga ikkan iti sakit a kas iti intedko kadagiti Egipcio; ta siak ni Yahweh, ti mangpapaimbag kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kalpasanna, napan dagiti tattao idiay Elim, a sadiay ket adda sangapulo ket dua nga ubbog ken pitupulo a kayo ti palma. Nagkampoda sadiay iti abay ti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nagtuloy a nagdaliasat dagiti amin a tattao manipud idiay Elim, ket napan dagiti amin nga Israelita iti let-ang ti Sin, nga adda iti nagbaetan ti Elim ken Sinai, idi maikasangapulo ket lima nga aldaw iti maikadua a bulan kalpasan ti ipapanawda manipud iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nagreklamo dagiti amin nga Israelita maibusor kenni Moises ken Aaron idiay let-ang. ");
INSERT INTO iloulb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kinuna dagiti Israelita kadakuada, “No laeng koma pinataynakami ti ima ni Yahweh idiay daga ti Egipto idi agtugtugawkami iti abay dagiti banga ti karne ken mangmangankami iti tinapay agingga a mapnekkami. Ta inyegdakami iti daytoy a let-ang tapno patayenyo iti bisin dagiti amin nga Israelita.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ket kinuna ni Yahweh kenni Moises, “Agpatudoakto iti tinapay manipud iti langit a maipaay kadakayo. Rummuarto dagiti tattao ket mangurnongda iti umdas a kanenda iti tunggal aldaw tapno masuotko ida tapno makitak no magnada iti lintegko wenno saan. ");
INSERT INTO iloulb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mapasamak iti maikainnem nga aldaw, agurnongdanto iti mamindua ti kaaduna ti inurnongda iti naglabas nga aldaw, ket lutuendanto ti naalada.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ket kinuna da Moises ken Aaron kadagiti amin a tattao ti Israel, “Inton rabii, maammoanyonto a ni Yahweh ti nangiruar kadakayo manipud iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Iti agsapa, makitayonto ti dayag ni Yahweh, ta mangmangngegna ti panagrekreklamoyo maibusor kenkuana. Siasinokami kadakayo nga agreklamokayo maibusor kadakami?” ");
INSERT INTO iloulb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kinuna pay ni Moises, “Maamoanyonto daytoy inton ikkannakayo ni Yahweh iti karne iti rabii ken tinapay iti bigat a pakapnekanyo—ta nangegna dagiti reklamoyo maibusor kenkuana. Siosinokami koma kenni Aaron? Ti reklamoyo ket saan a maibusor kadakami; maibusor dagitoy kenni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kinuna ni Moises kenni Aaron, “Ibagam kadagiti amin a tattao ti Israel, 'Umasidegkayo iti sangoanan ni Yahweh, ta nangngegna dagiti reklamoyo,”' ");
INSERT INTO iloulb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Napasamak nga idi agsasao ni Aaron kadagiti amin a tattao ti Israel, a napatalliawda iti let-ang, ket pagammoan, nagparang ti dayag ni Yahweh iti ulep. ");
INSERT INTO iloulb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ket nagsao ni Yahweh kenni Moises ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nangngegko dagiti reklamo dagiti tattao ti Israel. Agsaoka kadakuada ket ibagam, 'Iti rabii mangankayonto iti karne, ken ti agsapa mapnekkayonto iti tinapay. Ket maamoanyonto a siak ni Yahweh, a Diosyo.”' ");
INSERT INTO iloulb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Napasamak nga iti rabii ket immay dagiti pugo ket pinunnoda ti kampo. Iti agsapa, linikmut ti linnaaw ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Idi awanen ti linnaaw, adtoy, iti daga ti let-ang ket adda bassit a banag a nagbukel a kas kaingpis iti nagbalay a linnaaw iti daga. ");
INSERT INTO iloulb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Idi nakita dagiti tattao ti Israel daytoy, kinunada iti tunggal maysa, “Ania daytoy?” Saanda nga ammo no ania daydiay. Kinuna ni Moises kadakuada, “Dayta ti tinapay nga inted ni Yahweh kadakayo a kanenyo. ");
INSERT INTO iloulb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Daytoy ti bilin nga inted ni Yahweh: 'Masapul nga agurnong ti tunggal maysa kadakayo, ti kaadu iti kasapulanyo a kanen, maysa nga omer para iti tunggal tao a maitutop iti bilang dagiti tattaoyo. Kastoy ti panagurnongyo iti daytoy: Urnungenyo ti umdas a kanen ti tunggal tao nga agnanaed iti toldayo.”' ");
INSERT INTO iloulb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Inaramid ngarud dagiti tattao ti Israel daytoy. Nagurnong dagiti dadduma iti adu, nagurnong dagiti dadduma iti bassit. ");
INSERT INTO iloulb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Idi sinukatda daytoy iti omer, dagiti nangurnong iti adu ket awan natiddada, ken dagiti nangurnong iti bassit ket saan a naibusan. Nagurnong ti tunggal maysa iti umdas a mangsabet iti kasapulanda. ");
INSERT INTO iloulb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ket kinuna ni Moises kadakuada, “Awan ti rumbeng nga agibati iti aniaman kadagitoy agingga iti bigat.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nupay kasta, saanda a dimngeg kenni Moises. Nangibati dagiti dadduma kadakuada iti sumagmamano agingga iti bigat ngem naigges ken nabangles dagitoy. Ket nakaunget ni Moises kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Inurnongda dagitoy iti tunggal agsapa. Nangurnong ti tunggal maysa iti umdas a kanenna iti dayta nga aldaw. No dumarangen ti init, narunaw dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Napasamak nga iti maikainnem nga aldaw, nagurnongda iti namindua ti kaaduna a tinapay, dua nga omer para iti tunggal tao. Napan amin dagiti mangidadaulo ti Israel ket imbagada daytoy kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kinunana kadakuada, “Daytoy ti kinuna ni Yahweh; 'Inton bigat ket napasnek a panaginana, maysa a nasantoan a Panaginana para iti pakaidayawan ni Yahweh. Ilutoyo ti kayatyo nga iluto, ipaburekyo ti kayatyo nga ipaburek. Amin a mabati, ilasinyo para kadakayo para inton bigat. ’” ");
INSERT INTO iloulb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Indulinda ngarud dagitoy agingga iti kabigatanna, a kas imbilin ni Moises. Saan a nabangles dagitoy, wenno inigges. ");
INSERT INTO iloulb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kinuna ni Moises, “Kanenyo dayta a taraon ita nga aldaw, ta ita nga aldaw ket aldaw a maipaay kas Panaginana tapno padayawan ni Yahweh. Ita nga aldaw, saanyo a masarakan dagitoy kadagiti taltalon. ");
INSERT INTO iloulb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Urnungenyo dagitoy iti innem nga aldaw, ngem ti maikapito nga aldaw ket Aldaw ti Panaginana. Awanto ti mana iti Aldaw ti Panaginana.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Napasamak nga iti maikapito nga aldaw, adda sumagmamano kadagiti tattao ti napan agurnong iti mana ngem awan nasarakanda. ");
INSERT INTO iloulb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ket kinuna ni Yahweh kenni Moises, “Kasano kabayag ti panangkedkedyo a mangsalimetmet kadagiti bilin ken lintegko? ");
INSERT INTO iloulb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kitaenyo, Siak, ni Yahweh ket intedko kadakayo iti Aldaw a Panaginana. Isu nga iti maikainnem nga aldaw ipapaayankayo iti tinapay para iti dua nga aldaw. Masapul nga agtalinaed ti tunggal maysa kadakayo iti bukodna a lugar; masapul nga awan ti rummuar manipud iti lugarna iti maikapito nga aldaw.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Isu a naginana dagiti tattao iti maikapito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Inawagan dagiti tattao ti Israel dayta a makan a “mana.” Puraw daytoy a kas iti bukel ti kulantro, ken ti ramanna ket kasla tinapay a naingpis a naaramid manipud iti diro. ");
INSERT INTO iloulb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kinuna ni Moises, “Daytoy ti imbilin ni Yahweh: 'Masapul nga adda maysa omer a mana a maidulin para iti amin a henerasion dagiti tattao tapno makitanto dagiti kaputotanyo ti tinapay nga inpakanko kadakayo iti let-ang, kalpasan nga impanawkayo iti daga ti Egipto.'” ");
INSERT INTO iloulb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kinuna ni Moises kenni Aaron, “Mangalaka iti banga ket mangikabilka ditoy iti maysa nga omer a mana. Idulinyo daytoy iti sangoanan ni Yahweh tapno masalimetmetan iti amin a henerasion dagiti tattao.” ");
INSERT INTO iloulb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kas iti imbilin ni Yahweh kenni Moises, inkabil ni Aaron daytoy iti abay ti Lakasa ti Tulag. ");
INSERT INTO iloulb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Nangan dagiti tattao ti Israel iti mana iti uppat a pulo a tawen agingga a nakadanunda iti daga nga adda agnanaed. Kinnanda daytoy agingga a nakadanonda kadagiti beddeng iti daga ti Canaan. ");
INSERT INTO iloulb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ita ti maysa nga omer ket apagkapullo ti maysa nga efa. ");
INSERT INTO iloulb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nagdaliasat ti sibubukel a bunggoy ti Israel manipud iti let-ang ti Sin, kas panangsurot iti bilin ni Yahweh. Nagkampoda idiay Refidim, ngem awan danum nga inumen dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Isu a pinabasol dagiti tattao ni Moises para iti kasasaadda ket kinunada, “Ikkannakami iti danum nga inumenmi. “ Kinuna ni Moises, “Apay a makiapakayo kaniak? Apay a susuotenyo ni Yahweh?” ");
INSERT INTO iloulb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mawaw unay dagiti tattao, ket nagreklamoda maibusor kenni Moises. Kinunada, “Apay nga impanawnakami idiay Egipto? Tapno kadi patayennakami ken dagiti annakmi ken dagiti dingwenmi babaen iti pannakawaw?” ");
INSERT INTO iloulb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ket immawag ni Moises kenni Yahweh, “Ania ti rumbeng nga aramidek kadagitoy a tattao? Nakasaganadan a mangbato kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kinuna ni Yahweh kenni Moises, “Iyun-unam ti mapan ngem dagiti tattao, ken mangikuyogka iti sumagmamano a panglakayen ti Israel. Itugotmo ti sarukod a pinangbautmo iti karayan ket mapanka. ");
INSERT INTO iloulb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Agtakderakto iti sangoanam sadiay, iti bato idiay Horeb, ket bautemto ti bato. Addanto danum a rummuar manipud iti daytoy nga inumen dagiti tattao.” Ket isu ngarud ti inaramid ni Moises iti imatang dagiti panglakayen ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Pinanagananna dayta a lugar a Massa ken Meriba gapu iti panagreklamo dagiti Israelita, ken gapu ta sinuotda ti Apo babaen iti panangibagada nga, “Adda kadi kadatayo ni Yahweh wenno awan?” ");
INSERT INTO iloulb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kalpasana, adda immay nga armada dagiti Amalekita ket rinautda ti Israel idiay Refidim. ");
INSERT INTO iloulb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Isu a kinuna ni Moises kenni Josue, “Mangpilika iti sumagmamano a lallaki ket rummuarkayo. Makirangetkayo kadagiti Amalekita. Inton bigat, agtakderakto iti tapaw ti turod nga iggemko ti sarukod ti Dios.” ");
INSERT INTO iloulb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Isu a nakiranget ni Josue kadagiti Amalekita a kas imbilin ni Moises, kabayatan a da Moises, Aaron, ken Hur ket napan iti tapaw ti turod. ");
INSERT INTO iloulb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kabayatan a nakangato dagiti ima ni Moises, mangab-abak ti Israel; no bay-anna a nakababa dagiti imana, mangrugi met a mangabak ti Amalek. ");
INSERT INTO iloulb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Idi naktangan dagiti ima ni Moises, nangala da Aaron ken Hur iti bato ket inkabilda iti babaenna tapno pagtugawanna. Iti dayta met laeng a kanito, ingngato da Hur ken Aaron dagiti imana, ni Hur iti maysa nga imana, ken ni Aaron iti bangir nga imana. Isu a nagtalinaed a nakangato dagiti ima ni Moises agingga a limnek ti init. ");
INSERT INTO iloulb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Isu a babaen iti kampilan, inabak ni Josue dagiti tattao ti Amalek. ");
INSERT INTO iloulb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kinuna ni Yahweh kenni Moises, “Isuratmo daytoy iti maysa a libro ken ibasam daytoy kenni Josue, gapu ta punasekto a naan-anay ti pakalaglagipan ti Amalek iti babaen ti tangatang.” ");
INSERT INTO iloulb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ket nangbangon ni Moises iti altar ken inawaganna daytoy a “Ni Yahweh ti banderak.” ");
INSERT INTO iloulb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Inaramidna daytoy gapu ta kinunana, “Inkari ni Yahweh a makigubat isuna iti Amalek iti amin a henerasion.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ni Jetro a padi dagiti Midian, a katugangan a lalaki ni Moises ket nangngegna amin nga inaramid ti Dios para kenni Moises ken para iti Israel a tattaona. Nangngegna nga inruar ni Yahweh ti Israel manipud iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Inkuyog ni Jetro, a katugangan ni Moises, ni Sipora nga asawa ni Moises, kalpasan nga imbaonna isuna idiay balayda, ");
INSERT INTO iloulb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ken dagiti dua nga annakna a lallaki; ti nagan ti maysa ket Gersom, ta kinuna ni Moises, “Nagbalinak a ganggannaet iti sabali a daga.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ti nagan ti maysa ket Eliezer, ta kinuna ni Moises, “Ti Dios dagiti kapuonak ti katulongak. Inispalnak manipud iti kampilan ni Faraon.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Napan kenni Moises ni Jetro a katuganganna, kaduana dagiti putot a lallaki ni Moises ken ti asawana idiay let-ang a nagkampoanna idiay bantay ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kinunana kenni Moises, “Siak, ti katugangam a ni Jetro, ket umayak kenka a kaduak ti asawam ken dagiti dua a putotmo a lallaki.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Rimmuar ni Moises a nangsabat iti katuganganna, nagdumog ken inagkanna isuna. Nagkinnomustada maipanggep iti kasasaad ti tunggal maysa ket sada simrek iti tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Imbaga ni Moises iti katuganganna ti amin nga inaramid ni Yahweh kenni Faraon ken kadagiti Egipcio para iti pagimbagan ti Israel, maipanggep kadagiti amin a rigrigat a napadtengda kabayatan ti kaaddada iti dalan, ken no kasano nga inispal ida ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nagrag-o ni Jetro iti amin a nasayaat nga inaramid ni Yahweh iti Israel, iti panangispalna kadakuada manipud iti ima dagiti Egipcio. ");
INSERT INTO iloulb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Kinuna ni Jetro, “Maidaydayaw koma ni Yahweh, ta inispalnakayo manipud iti ima dagiti Egipcio ken iti ima ni Faraon, ken winayawayaanna dagiti tattao manipud iti panangtengngelda. ");
INSERT INTO iloulb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ita, ammok a nain-indaklan ni Yahweh ngem dagiti amin a didiosen, gapu ta idi trinato dagiti Egipcio dagiti Israelita a sitatangsit, inispal ti Dios dagiti tattaona.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nangiyeg ni Jetro, a katugangan ni Moises iti daton a maipuor amin ken datdaton a maipaay iti Dios. Immay ni Aaron ken dagiti amin a panglakayen ti Israel a mangan iti sangoanan ni Yahweh a kaduada ti katugangan ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Iti simmaruno nga aldaw, nagtugaw ni Moises tapno mangukom kadagiti tattao. Nagtakder dagiti tattao iti aglawlawna manipud bigat agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Idi nakita ti katugangan ni Moises amin nga inaramidna para kadagiti tattao, kinunana, “Ania daytoy nga ar-aramidem kadagiti tattao? Apay nga agtugtugawka nga agmaymaysa ket agtaktakder iti aglawlawmo dagiti amin a tattao manipud iti bigat agingga iti rabii?” ");
INSERT INTO iloulb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Kinuna ni Moises iti katuganganna, “Umay kaniak dagiti tattao a dumawat iti panangiwanwan ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","No addaanda iti saan a pagkikinnaawatan, umayda kaniak. Mangngeddengak iti nagbaetan dagiti tattao, ken isursurok kadakuada ti maipanggep kadagiti alagaden ken linteg ti Dios.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kinuna ti katugangan ni Moises kenkuana, “Saan a nasayaat ti ar-aramidem. ");
INSERT INTO iloulb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Awan dua-dua a maibusto ti pigsam ken dagiti tattao nga umay kenka, gapu ta nadagsen unay a trabaho daytoy para kenka. Saanmo a maaramid daytoy a siksika. ");
INSERT INTO iloulb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Dinggennak. Balakadanka ket makikaaddanto ti Dios kenka gapu ta sika ti mangibagbagi kadagiti tattao ti Dios, ken sika ti mangiyum-uman kenkuana kadagiti saanda a pagkikinnaawatan. ");
INSERT INTO iloulb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Masapul nga isurom kadakuada dagiti alagaden ken lintegna. Masapul nga ipakitam kadakuada ti dalan a surotenda iti panagbiagda ken ti trabaho nga aramidenda. ");
INSERT INTO iloulb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Maysa pay, nasken a mangpilika kadagiti makabael a lallaki manipud kadagiti amin a tattao, lallaki a mangraraem iti Dios, lallaki a napudno ken manggurgura iti saan a nalinteg a panangtagikua. Masapul a pagturayem ida kadagiti tattao, nga agbalin a mangidaulo a mangimaton kadagiti sagsasangaribu, sagsasangagasut, saglilimapulo ken sagsasangapulo. ");
INSERT INTO iloulb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Isuda ti mangukom kadagiti tattao iti amin a kadawyan a parikut, ngem iyegda kenka dagiti naririgat a parikut. No maipapan kadagiti amin a babassit a parikut, mabalinda nga ukomen dagidiay nga is-isuda. Iti dayta a wagas, nalaklakanto para kenka, ken makipag-baklaydanto kenka iti dadagsen. ");
INSERT INTO iloulb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","No aramidem daytoy, ken no isu't bilin ti Dios nga aramidem, ket maibturamto, ken makaawidto dagiti amin a tattao a napnapnek.” ");
INSERT INTO iloulb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Dimngeg ngarud ni Moises kadagiti sao ti katuganganna a lalaki ken inaramidna ti amin nga imbaga daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Nangpili ni Moises kadagiti makabael a lallaki manipud iti amin nga Israel ket pinagbalinna ida a mangidadaulo kadagiti amin a tattao, mangidadaulo kadagiti sagsasangaribu, sagsasangagasut, saglilimapulo, ken sagsasangapulo. ");
INSERT INTO iloulb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Inukomda dagiti tattao kadagiti gagangay a pasamak. Inyegda kenni Moises dagiti naririgat a parikut, ngem rinisutda nga is-isuda dagiti amin a babassit a parikut. ");
INSERT INTO iloulb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kalpasanna, pinalubosan ni Moises a pumanaw ti katuganganna a lalaki, ket nagsubli ni Jetro iti bukodna a daga. ");
INSERT INTO iloulb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Iti maikatlo a bulan kalpasan a pimmanaw dagiti tattao ti Israel iti daga ti Egipto, iti isu met laeng nga aldaw, dimmanonda iti let-ang ti Sinai. ");
INSERT INTO iloulb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Kalpasan a pimmanawda idiay Refidim ken dimmanonda iti let-ang ti Sinai, nagkampoda iti let-ang iti sangoanan ti bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Simmang-at ni Moises iti ayan ti Dios. Immawag ni Yahweh kenkuana manipud iti bantay ket kinunana, “Masapul nga ibagam iti balay ni Jacob, kadagiti tattao ti Israel: ");
INSERT INTO iloulb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Nakitayo ti inaramidko kadagiti Egipcio, no kasano ti panangawitko kadakayo babaen kadagiti payyak ti agila ket inyegkayo iti ayanko. ");
INSERT INTO iloulb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ita ngarud, no situtulnogkayo a dumngeg iti timekko ken salimetmetanyo ti katulagak, ket agbalinkayonto a naisangsangayan a sanikuak manipud kadagiti amin a tattao, ta kukuak ti entero a daga. ");
INSERT INTO iloulb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Agbalinkayonto a pagarian dagiti papadi ken nasantoan a nasion a maipaay kaniak. Dagitoy dagiti sasao a masapul nga ibagam kadagiti tattao ti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Napan ngarud ni Moises ket pinaayabanna dagiti panglakayen dagiti tattao. Indatagna kadakuada dagitoy amin a sasao nga imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Sangsangkamaysa a simmungbat dagiti tattao ket kinunada, “Aramidenmi amin nga imbaga ni Yahweh.” Kalpasanna, napan ni Moises a mangipadamag kenni Yahweh iti imbaga dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kinuna ni Yahweh kenni Moises, “Umayakto kenka babaen iti napuskol nga ulep tapno mangngeg dagiti tattao inton makisaritaak kenka ket mamatida met kenka iti agnanayon.” Ket imbaga ni Moises kenni Yahweh dagiti sasao dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kinuna ni Yahweh kenni Moises, “Mapanka iti ayan dagiti tattao. Masapul nga ilasinmo ida para kaniak ita ken inton bigat, ken ipalabam kadakuada dagiti lupotda. ");
INSERT INTO iloulb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Agsaganakayo para iti maikatlo nga aldaw, ta iti maikatlo nga aldaw, Siak, ni Yahweh, ket bumabanto iti Bantay Sinai. ");
INSERT INTO iloulb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Masapul a mangikabilka iti beddeng iti aglawlaw ti bantay para kadagiti tattao. Ibagam kadakuada, 'Aluadanyo a saankayo a sumangsang-at iti bantay wenno sagiden ti beddengna. Siasinoman a mangsagid iti bantay ket sigurado a mapapatay.' ");
INSERT INTO iloulb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Masapul nga awan ti aniaman nga ima a mangsagid iti dayta a tao. Ngem ketdi, masapul a batoen wenno panaen isuna. Tao man dayta wenno ayup, masapul isuna a mapapatay. Inton aguni ti trumpeta iti nabayag ken napigsa, mabalindan nga umay iti sakaanan ti bantay.” ");
INSERT INTO iloulb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ket simmalog ni Moises iti ayan dagiti tattao manipud iti bantay. Inlasinna dagiti tattao para kenni Yahweh, ken linabaanda dagiti lupotda. ");
INSERT INTO iloulb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kinunana kadagiti tattao, “Agsaganakayo iti maikatlo nga aldaw; saankayo a dumenna kadagiti assawayo a babbai.” ");
INSERT INTO iloulb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Iti bigat iti maikatlo nga aldaw, adda gurruod ken kimat ken adda napuskol nga ulep iti bantay, ken adda napigsa unay nga uni ti trumpeta. Nagpigerger dagiti amin a tattao iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Pinaruar ni Moises dagiti tattao manipud iti kampo tapno sabtenda ti Dios, ket nagtakderda iti sakaanan ti bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Naabbongan ti entero a Bantay Sinai iti asuk gapu ta bimmaba ni Yahweh iti daytoy babaen iti apuy ken asuk. Nagpangato ti asuk a kasla asuk ti orno, ken naggun-gon iti napalalo ti entero a bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Idi pumigpigsa ti uni ti trumpeta, nagsao ni Moises ket sinungbatan isuna ti Dios babaen iti timek. ");
INSERT INTO iloulb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bimmaba ni Yahweh iti Bantay Sinai, iti tapaw ti bantay, ket pinasang-atna ni Moises iti tapaw. Simmang-at ngarud ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kinuna ni Yahweh kenni Moises, “Sumalogka ket ballaagam dagiti tattao a saanda a lumabes kadagiti beddeng nga umay mangkita kaniak, ta no saan adu ti matay kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ibagam met kadagiti papadi nga umasideg kaniak a dalusanda dagiti bagbagida-isaganada dagiti bagbagida iti iyuumayko tapno saanko ida a dangran.” ");
INSERT INTO iloulb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kinuna ni Moises kenni Yahweh, “Saan a mabalin a sumang-at dagiti tattao iti bantay, ta imbilinmo kadakami, 'Mangikabilka iti beddeng iti aglawlaw ti bantay ket ilasinmo a para kenni Yahweh.'” ");
INSERT INTO iloulb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kinuna ni Yahweh kenkuana, “Mapanka, bumabaka iti bantay, ket ikuyogmo ditoy ni Aaron, ngem saanmo nga ipalubos a lumabes iti beddeng dagiti papadi ken dagiti tattao nga umay kaniak, ta no saan dangrak ida.” ");
INSERT INTO iloulb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Simmalog ngarud ni Moises iti ayan dagiti tattao ket kinasaritana ida. ");
INSERT INTO iloulb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Imbaga ti Dios amin dagitoy a sasao: ");
INSERT INTO iloulb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Siak ni Yahweh a Diosyo, a nangiruar kadakayo manipud iti daga ti Egipto, manipud iti balay ti pannakatagabu. ");
INSERT INTO iloulb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Masapul nga awanen iti sabali a diosyo malaksid kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Dika agaramid iti kinitikitan a ladawan wenno kapada ti aniaman a banag nga adda iti langit, wenno adda iti uneg ti daga, wenno adda iti uneg ti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Dika agrukbab kadagitoy wenno agdayaw kadagitoy, ta siak, ni Yahweh a Diosmo ket managimonak a Dios. Dusaek dagiti kinadakes dagiti kapuonan babaen iti panangiyegko iti dusa kadagiti kaputotan, inggana iti maikatlo ken iti maikauppat a henerasion dagiti manggurgura kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ngem ipakitak ti kinapudnok iti katulagan kadagiti rinibu a mangay-ayat kaniak ken mangsalsalimetmet kadagiti bilinko. ");
INSERT INTO iloulb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Dimo aramaten ti naganko, ni Yahweh a Diosmo, iti awan kapaypay-anna ta saankonto a palabsen ti siasinoman a mangaramat iti naganko iti awan kapaypay-anna. ");
INSERT INTO iloulb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Lagipem ti Aldaw a Panaginana, nga idatonmo daytoy kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Masapul a trabahoem ken aramidem dagiti amin a trabahom iti innem nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ngem ti maikapito nga aldaw ket Aldaw a Panaginana a maipaay kaniak, ni Yahweh a Diosmo. Dika agtrabaho iti uray ania a trabaho iti dayta nga aldaw, sika, wenno ti anakmo a lalaki, wenno ti anakmo a babai, wenno ti adipenmo a lalaki, wenno ti adipenmo a babai, wenno dagiti bakam, wenno ti ganggannaet nga adda iti ruanganmo. ");
INSERT INTO iloulb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ta iti las-ud ti innem nga aldaw, siak, ni Yahweh, ket inaramidko ti langit, daga, ken baybay, ken amin a linaonda, ken kalpasanna, naginana iti maikapito nga aldaw. Ngarud, siak a ni Yahweh, ket binendisionak ti Aldaw a Panaginana ken insagotko daytoy iti bagik. ");
INSERT INTO iloulb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Dayawem ti amam ken ti inam tapno agbiagka iti nabayag iti daga a siak, ni Yahweh a Diosmo, ket itedko kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Dika mamapatay iti siasinoman. ");
INSERT INTO iloulb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Dika makikamalala. ");
INSERT INTO iloulb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Dimo takawan ti siasinoman. ");
INSERT INTO iloulb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Dika mangted iti parbo a pammaneknek maibusor iti kaarrubam. ");
INSERT INTO iloulb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Dimo aguman ti balay ti kaarrubam; dimo aguman ti asawa a babai ti kaarrubam, ti lalaki a tagabuna, ti babai a tagabuna, ti bakana, dagiti asnona, wenno aniaman a banag a kukua ti kaarrubam.” ");
INSERT INTO iloulb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nakita dagiti amin a tattao ti panaggurruod ken ti panagkimat, ken nangngegda ti uni ti trumpeta, ken nakitada ti umas-asuk a bantay. Idi nakita dagiti tattao daytoy, nagpigergerda ket nagtakderda iti adayo. ");
INSERT INTO iloulb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Kinunada kenni Moises, “Agsaoka kadakami ket dumngegkami; ngem saanmo nga ipalubos a ti Dios ti agsao kadakami, ta amangan no mataykami.” ");
INSERT INTO iloulb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kinuna ni Moises kadagiti tattao, “Saankayo nga agbuteng, ta immay ti Dios tapno suotennakayo tapno ti panagdayaw kenkuana ket maadda koma kadakayo, ken tapno saankayo nga agbasol.” ");
INSERT INTO iloulb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Isu a nagtakder latta dagiti tattao iti adayo, ket immasideg ni Moises iti napuskol a kinasipnget nga ayan ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kinuna ni Yahweh kenni Moises, “Daytoy ti rumbeng nga ibagam kadagiti Israelita: 'Nakitayo a mismo a nagsaoak kadakayo manipud iti langit. ");
INSERT INTO iloulb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Saankayo nga agaramid ti sabali a didiosen malaksid kaniak, didiosen a pirak wenno didiosen a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Masapul nga iyaramidannak iti altar a daga, ken rumbeng nga idatonmo sadiay dagiti datonmo a mapuoran, daton ti pannakilangen-langen, karnero, ken baka. Iti tunggal lugar a pangipadayawak iti naganko, umayakto kenka ket bendisionankanto. ");
INSERT INTO iloulb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","No iyaramidandak iti altar a bato, rumbeng a diyo ipatakder daytoy kadagiti nagudua a batbato, ta no usarenyo dagiti alikamenyo iti daytoy, matulawanyonto daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Masapul a dikay umuli babaen iti agdan iti altarko; daytoy ket tapno masaluadan ti pannakaipakita ti nakalemmeng a paset ti bagiyo. ");
INSERT INTO iloulb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ita, dagitoy dagiti bilin a rumbeng nga ipaulogmo para kadakuada: ");
INSERT INTO iloulb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","'No gumatangkayo iti adipen a Hebreo, agserbi isuna iti innem a tawen, ken iti maikapito a tawen ket mawayawayaanto isuna nga awan iti uray ania a bayadanna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","No immay nga is-isuna, rumbeng isuna a mawaya-wayaan nga is-isuna; no naasawaan isuna, ket masapul a mawayawayaan isuna a kaduana ti asawana. ");
INSERT INTO iloulb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","No inikkan isuna ti amongna iti asawa a babai ket naganak ti asawana iti annak a lallaki ken annak a babbai, kukuanto ti amongna ti asawa ken annakna, ket rumbeng isuna a mawaya-wayaan nga is-isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ngem no silalawag a kunaen ti adipen nga, “Ay-ayatek ti amongko, ti asawak ken dagiti annakko; saanak a pumanaw a siwaya-waya,” ");
INSERT INTO iloulb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ket masapul nga ipan isuna ti amongna iti Dios. Masapul nga ipan isuna ti amongna iti ruangan wenno iti poste ti ridaw, ken masapul nga abutan ti amongna ti lapayagna babaen iti kulukul. Ket pagserbianto ti adipen isuna iti amin a panagbiagna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","No ilako ti maysa a tao ti anakna a babai a kas adipen, masapul a saan isuna a pumanaa a nawayawayaan a kas iti ar-aramiden dagiti adipen a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","No saanna a maay-ayo ti amongna, a nangisaad kenkuana para iti bagina, rumbeng ngarud a palubosanna isuna a masaka. Awan karbenganna a mangilako kenkuana kadagiti gangganaet a tattao. Awan karbenganna, agsipud ta inallilawna ti babai. ");
INSERT INTO iloulb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","No isaad isuna ti amongna a kas asawa ti anakna a lalaki, masapul a tratoenna isuna a kasla anakna isuna a babai. ");
INSERT INTO iloulb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","No mangala isuna iti sabali nga asawaenna, masapul a saanna a kissayan ti taraonna, badbadu, wenno dagiti kalintegan ti babai a kas asawa. ");
INSERT INTO iloulb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ngem no saanna nga ipaay dagitoy a tallo a banbanag kenkuana, mabalinna ngarud a mawayawayaan nga awan ti bayadanna nga aniaman a kuarta. ");
INSERT INTO iloulb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Siasinoman a mangdangran iti maysa a tao nga isu ti pakatayanna, awan duadua a masapul a mapapatay dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","No saan a pinanggep ti tao ti inaramidna, no di ket nairana laeng, ket mangitudingak iti lugar a mabalinna a papanan. ");
INSERT INTO iloulb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","No pagayatan ti maysa a tao ti mangraut iti kaarrubana tapno patayenna isuna a siaallilaw, ket masapul nga alaenyo isuna, uray no adda isuna iti altar ti Dios, tapno matay isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Siasinoman a mangdangran iti ama wenno inana ket awan dua-dua a masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Siasinoman a mangala iti maysa a tao sana ilako, wenno masarakan ti tao iti poderna, dayta a nangtakaw iti tao ket masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Siasinoman a mangilunod iti ama wenno inana ket awan duadua a masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","No agapa dagiti lallaki ket dinangran ti maysa ti sabali babaen iti bato wenno gemgemna, ken saan a natay dayta a tao, ngem naidalit iti pagiddaanna; ");
INSERT INTO iloulb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ket no umimbag isuna ken makapagnan babaen iti panagusarna ti sarukodna, masapul a bayadan ti tao a nangdangran kenkuana ti nasayang a panawenna; masapul pay nga agbayad isuna para iti naan-anay a pannakaimbagna. Ngem dayta a tao ket saan a nakabasol iti panangpapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","No dinangran ti maysa a tao ti adipenna a lalaki wenno adipenna a babai babaen iti sarukod, ket no matay ti adipen a kas ti banag ti pannakadangranna, dayta a tao ket awan duadua a masapul a madusa. ");
INSERT INTO iloulb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nu pay kasta, no agbiag ti adipen iti maysa wenno dua nga aldaw, saan a rumbeng a madusa ti amo, ta masagabana ti pannakapukaw ti adipen. ");
INSERT INTO iloulb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","No agaapa dagiti lalaki ket madangranda ti maysa a masikug a pakaigapuan a maalisan isuna, ngem awanen ti sabali a dunorna, ket awan duadua a rumbeng nga agmulta ti nakabasol a lalaki, no dawaten ti asawa ti babai dayta kenkuana, ken masapul nga agbayad isuna kas maiyannurot iti ikeddeng dagiti ukom. ");
INSERT INTO iloulb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ngem no adda ti nakaro a dunor, ket masapul nga itedmo ti biag para iti biag, mata para iti mata, ngipen para iti ngipen, ");
INSERT INTO iloulb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ima para iti ima, saka para iti saka, ");
INSERT INTO iloulb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","puor para iti puor, sugat para iti sugat, wenno dunor para iti dunor. ");
INSERT INTO iloulb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","No kabilen ti tao ti mata ti adipenna a lalaki wenno ti adipenna a babai ket nabulsek daytoy, ket rebbengna a waya-wayaan ti adipen kas bayad ti matana. ");
INSERT INTO iloulb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","No natuppolanna ti ngipen ti adipenna a lalaki wenno adipenna a babai, ket rebbengna a waya-wayaan ti adipenna a kas bayad ti ngipenna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","No sangdoen ti maysa a baka ti maysa a lalaki wenno ti maysa a babai ket matay, awan duadua a rumbeng a maubor ti baka, ken saan a rumbeng a kanen ti lasagna; ngem saan a mapabasol ti akinbaka. ");
INSERT INTO iloulb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ngem no siguden nga adda aramid ti baka a panagdangran, ken naballaagan ti akinkukua ngem di na inaywanan daytoy, ket nangpatay ti baka iti lalaki wenno babai, masapul a maubor dayta a baka, ken rumbeng met a mapapatay ti akinkukua. ");
INSERT INTO iloulb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","No kasapulan ti bayad para iti biagna, rumbeng nga agbayad isuna ti aniaman a masapul a bayadanna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","No sinangdo ti baka ti anak a lalaki wenno ti anak a babai ti maysa a tao, rumbeng nga aramiden ti akinbaka ti ibagbaga ti linteg nga aramidenna. ");
INSERT INTO iloulb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","No sangdoen ti baka ti adipen a lalaki wenno adipen a babai, rumbeng nga agbayad ti akinbaka ti tallo pulo a siklo ti pirak, ken rumbeng a maubor ti baka. ");
INSERT INTO iloulb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","No lukatan ti maysa a tao ti abot, wenno agkali ti maysa a tao iti abot ken saanna a kinaluban daytoy, ket adda natnag a baka wenno asno iti daytoy, ");
INSERT INTO iloulb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","rumbeng a bayadan ti akinkukua iti abot ti napukaw. Rumbeng a mangted isuna iti kuarta iti akinkukua iti natay nga ayup, ket baginanto ti natay nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","No madangran ti baka ti maysa a tao ti baka ti sabali a tao a pakaigapuan ti pannakatay ti baka, ket masapul nga ilakoda ti nabiag a baka ket paggudduaanda ti bayadna, ken masapul a paggudduaanda pay ti natay a baka. ");
INSERT INTO iloulb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ngem no nalataken nga ugali ti baka ti mangsangdo iti napalabas a panawen, ken saan nga impupok ti akinkukua daytoy, rumbeng a bayadanna ti baka iti baka, ken kukuananto ti natay nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","No agtakaw ti maysa a tao ti maysa a baka wenno karnero ket patayenna wenno ilakona daytoy, ket masapul nga agbayad isuna iti lima a baka para iti maysa a baka, ken uppat a karnero para iti maysa a karnero. ");
INSERT INTO iloulb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","No adda mannanakaw a natiliw nga umun-uneg iti maysa a balay, ken no nadangran isuna ket matay, awan ti siasinoman a mapabasol iti pammapatay gapu kenkuana iti dayta a pasamak. ");
INSERT INTO iloulb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ngem no simmingisingen ti init sakbay nga agtakaw isuna, mapabasolto iti pammapatay ti tao a mangpatay kenkuana. Masapul a bayadan ti mannanakaw ti tinakawna. No awanan isuna, rumbeng ngarud a mailako isuna gapu iti panagtakawna. ");
INSERT INTO iloulb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","No ti natakaw nga ayup ket nasarakan a sibibiag iti aywanna, daytoy man ket baka, asno, wenno karnero, masapul nga agbayad isuna iti doble. ");
INSERT INTO iloulb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","No paaraben ti maysa a tao dagiti dingwenna iti maysa a taltalon wenno kaubasan ket pabulosanna ti ayupna, ket nagarabda iti taltalon ti sabali a tao, rumbeng nga agbayad isuna manipud kadagiti kasasayaatan iti bukodna a taltalon ken manipud kadagiti kasasayaatan iti bukodna a kaubasan. ");
INSERT INTO iloulb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","No adda puor ket agkayamkam kadagiti sisiit ket mauram dagiti penpen a dawa, wenno dagiti saan pay a naapit a trigo, wenno ti taltalon, rumbeng nga agbayad ti nangirugi iti puor. ");
INSERT INTO iloulb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","No ipadulin ti maysa a tao iti kaarrubana dagiti kuartana wenno dagiti banbanag a kukuana, ket no matakaw daytoy manipud iti balay ti dayta a kaarrubana, no natiliw ti mannanakaw, rumbeng a doble ti ibayad dayta a mannanakaw. ");
INSERT INTO iloulb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ngem no saan a natiliw ti mannanakaw, rumbeng a mapan ti akinbalay kadagiti ukom tapno makita no kinamkamna ti sanikua ti kaarrubana. ");
INSERT INTO iloulb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ta iti tunggal riri maipanggep iti maysa a banag, daytoy man ket baka, asno, karnero, badbadu, wenno uray ania a banag a mapukpukaw nga ibaga ti maysa a, “Kukuak daytoy,” masapul a dumanon kadagiti ukom ti ibagbaga dagiti maseknan a kukuada. Masapul a doble ti ibayad ti tao a maduktalan dagiti ukom a nakabasol iti kaarubana. ");
INSERT INTO iloulb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","No ipaaywan ti maysa a tao iti kaarrubana ti asnona, bakana, karnerona, wenno aniaman nga ayup, ket no daytoy ket matay wenno madangran wenno natakaw nga awan ti nakakita, ");
INSERT INTO iloulb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","rumbeng nga agsapatada a dua kenni Yahweh, no adda wenno awan ti nangkamkam iti sanikua ti kaarrubana. Masapul nga awaten ti akinkukua daytoy, ket saanto nga agbayad ti nangipaaywananna. ");
INSERT INTO iloulb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ngem no natakaw daytoy manipud kenkuana, masapul nga agbayad isuna iti akinkukua para iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","No narangrangkay ti ayup, masapul nga iyeg dayta a tao ti ayup a kas pammaneknek. Saannanto a masapul a bayadan ti narangrangkay nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","No bumulod ti maysa a tao ti aniaman nga ayup manipud iti kaarrubana ket madangran ti ayup wenno matay nga awan idiay ti akinkukua, ti tao a nangbulod ket masapul nga agbayad. ");
INSERT INTO iloulb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ngem no adda idiay ti akinkukua, saan a masapul nga agbayad ti nangbulod; no naabangan ti ayup, mabayadanto daytoy babaen iti bayad ti abangna. ");
INSERT INTO iloulb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","No sulisogen ti maysa a lalaki ti maysa a birhen a saan pay a naituding a maiyasawa, ken no nakikaidda isuna kenkuana, awan duadua a masapul nga asawaenna ti babai babaen iti panangbayadna iti sab-ong para iti nobia. ");
INSERT INTO iloulb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ngem no naan-anay a nagkedked ti ama a mangited iti anakna kenkuana, rumbeng nga agbayad isuna iti sab-ong a naituding a gatad kadagiti birhen a nobia. ");
INSERT INTO iloulb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Rumbeng a saanyo a palubosan nga agbiag dagiti manggagamud. ");
INSERT INTO iloulb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Siasinoman a makikaidda kadagiti ayup ket awan duadua a masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Rumbeng a naan-anay a madadael ti siasinoman nga agidaton kadagiti aniaman a didiosen malaksid kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Rumbeng a diyo ranggasan ti ganggannaet wenno irurumen isuna, ta nagbalinkayo met a ganggannaet idiay daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Masapul a diyo idadanes ti siasinoman a balo wenno awanan-ama nga ubing. ");
INSERT INTO iloulb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","No parigatenyo ida iti aniaman a wagas, ket no immawagda kaniak, a ni Yahweh, awan duadua a denggek dagiti awagda. ");
INSERT INTO iloulb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Sumgedto ti pungtotko, ket papatayenkayonto babaen iti kampilan; agbalinto a balo dagiti assawayo a babbai ken agbalinto nga awanan-ama dagiti annakyo. ");
INSERT INTO iloulb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","No agpabulodkayo iti kuarta iti siasinoman kadagiti tattaok kadakayo a nakurapay, rumbeng a saankayo nga agbalin a kas ti agpapautang kenkuana wenno saanyo a paanakan ti impautangyo. ");
INSERT INTO iloulb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","No alaenyo ti kawes iti kaarrubayo a kas pammatalgedyo, masapul nga isubliyo daytoy kenkuana sakbay a lumnek ti init, ");
INSERT INTO iloulb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ta dayta laeng ti pangkalubna; daytoy ket kawesna para iti bagina. Ania pay ngarud ti mabalinna a pagturogan? Inton umawag isuna kaniak, denggekto isuna, agsipud ta manangngaasi-ak. ");
INSERT INTO iloulb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Didak tabtabbaawan, a Dios, wenno ilunod ti mangiturturay kadagiti tattaoyo. ");
INSERT INTO iloulb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Masapul a saanyo nga ipaidam dagiti datonyo manipud kadagiti apityo wenno ti pagpespesan ti ubasyo. Masapul nga idatonyo kaniak ti inauna nga anakyo a lalaki. ");
INSERT INTO iloulb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Masapul nga aramidenyo met laeng daytoy kadagiti baka wenno karneroyo. Iti pito nga aldaw ket agtalinaedda kadagiti inada, ngem iti maikawalo nga aldaw, masapul nga idatonyo ida kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Agbalinkayonto a tattao a nailasin para kaniak. Isu a masapul a saankayo a mangan iti aniaman a karne a rinangrangkay dagiti ayup idiay taltalon. Ngem ketdi, masapul nga ipuruakyo dagitoy kadagiti aso. ");
INSERT INTO iloulb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Masapul a saankayo nga agipadamag iti palso maipanggep iti siasinoman. Saankayo a makikaddua iti nadangkes a tao tapno agbalinkayo nga ulbod a saksi. ");
INSERT INTO iloulb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Masapul a saankayo a sumurot iti kaadduan nga agaramid iti dakes wenno agsaksi kabayatan nga ay-ayunanyo ti kaaduan tapno mangballikug iti hustisia. ");
INSERT INTO iloulb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Masapul a saanyo nga ayunan ti nakurapay a tao iti kasona. ");
INSERT INTO iloulb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","No masabatyo ti baka wenno asno ti kabusoryo a maiyaw-aw-awan, masapul nga isubliyo daytoy kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","No makitayo a nakusbo iti daga ti asno ti tao a gumurgura kadakayo iti kinadagsen ti awitna, masapul a saanyo a panawan dayta a tao. Masapul a tulunganyo isuna ken ti asnona. ");
INSERT INTO iloulb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Masapul a saanyo a ballikugen ti hustisia no daytoy ket umayon kadagiti napanglaw a tattao iti kaso iti napanglaw a tao. ");
INSERT INTO iloulb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Saankayo a makikaddua kadagiti dadduma iti panagaramid iti palso a pammabasol, ken saanyo a patayen dagiti awan basolna wenno nalinteg, ta saankonto a palabsen dagiti nadangkes. ");
INSERT INTO iloulb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Saankayo a pulos nga umawat iti pasuksok, ta bulseken ti pasuksok dagiti makakita ken ballikugenna dagiti sao dagiti napudno a tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Masapul a saankayo a mangidadanes iti ganggannaet, agsipud ta ammoyo ti biag ti maysa a gangannaet, ta ganggannaetkayo met idi iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Iti las-ud iti innem a tawen, agmulakayo ti bukel kadagiti dagayo ken apitenyo dagiti ipaayna a bunga. ");
INSERT INTO iloulb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ngem iti maikapito a tawen, bay-anyo a saan a naarado ken paginanaenyo daytoy, tapno makapangan dagiti nakurapay a tattao kadakayo. Ti ibatida, kanento dagiti atap nga ayup. Kasta met ti aramidenyo kadagiti kaubusanyo ken kadagiti kaoliboanyo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Agtrabahokayo bayat iti innem nga aldaw, ngem iti maikapito nga aldaw masapul nga aginanakayo. Aramidenyo daytoy tapno makainana dagiti baka ken asnoyo, ken tapno makainana ken mabang-aran dagiti annak a lallaki dagiti tagabuyo a babbai ken ti siasinoman a gangannaet. ");
INSERT INTO iloulb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Endenganyo ti amin nga imbagak kadakayo. Saanyo a dakdakamaten ti nagan dagiti sabali a dios, wenno saanyo nga ipalubos a mangngeg dagiti naganda manipud iti ngiwatyo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Masapul nga agdaliasatkayo tapno makaangaykayo iti fiesta a maipaay kaniak iti mamintallo a daras iti makatawen. ");
INSERT INTO iloulb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Masapul a ngilinenyo ti Fiesta ti Tinapay nga Awan Lebadurana. Kas imbilinko kadakayo, mangankayo iti tinapay nga awan lebadurana iti las-ud ti pito nga aldaw. Iti dayta a tiempo, sumangokayonto kaniak iti bulan ti Abib, a naituding para iti daytoy a panggep. Iti daytoy a bulan a rimuarkayo idi manipud idiay Egipto. Ngem masapul a saankayo nga agpakita iti sangoanak nga ima-ima. ");
INSERT INTO iloulb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Masapul a ngilinenyo ti Fiesta ti Panagapit, ti umuna a bunga dagiti nagbannoganyo idi immulayo dagiti bukbukel kadagiti taltalonyo. Kasta met a masapul a ngilinenyo ti Fiesta ti Panagummong iti ileleppas ti tawen, inton agapitkayo manipud kadagiti taltalonyo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Masapul nga agparang iti sangoanak, a ni Yahweh, dagiti amin a lallaki iti mamintallo a daras iti tunggal tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Masapul a saanyo nga idaton ti dara dagiti naidaton para kaniak a kaddua ti tinapay nga adda lebadurana. Dagiti taba manipud kadagiti naidaton iti fiestak ket masapul a saan nga agtalinaed iti agpatnag agingga iti bigat. ");
INSERT INTO iloulb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Masapul nga iyegyo iti uneg ti balayko, ti balay ni Yahweh a Diosyo ti umuna a kasayaatan a bunga manipud kadagiti dagayo. Masapul a saanyo a paburekan ti urbon a kalding iti gatas ti inana. ");
INSERT INTO iloulb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Mangibaonakto iti anghel nga umun-una kadakayo a mangsalaknib kadakayo iti dalan, ken mangiyeg kadakayo iti lugar nga insaganak. ");
INSERT INTO iloulb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Dumngeg ken agtulnogkayo kenkuana. Saanyo a pagpungtoten isuna, ta saannanto a pakawanen dagiti pagkuranganyo. Adda kenkuana ti naganko. ");
INSERT INTO iloulb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","No pudno nga agtulnogkayo iti timekna ken aramidenyo amin dagiti ibagak kadakayo, ket agbalinakto a kabusor kadagiti kabusoryo ken sumuppiat kadagiti sumupsuppiat kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Umun-unanto kadakayo ti anghelko ket iyegnakayo kadagiti Amorreo, Heteo, Perezeo, Cananeo, Heveo ken kadagiti Jebuseo. Dadaelekto ida. ");
INSERT INTO iloulb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Masapul a saankayo nga agrukbab kadagiti diosda, dayawen dagitoy, wenno tuladen dagiti ar-aramidenda. Ngem ketdi, masapul a naan-anay a dadaelenyo ida ken burakburakenyo dagiti nasagradoan a bato nga adigida. ");
INSERT INTO iloulb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Masapul a dayawendak, ni Yahweh a Diosyo. No aramidenyo, bendisionak dagiti tinapay ken danumyo. Ikkatekto dagiti saksakit kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Awanto ti babai nga agbalin a lupes wenno maalisan iti dagayo. Ikkankayonto iti napaut a panagbiag. ");
INSERT INTO iloulb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Pagbutngekto kaniak dagiti agnanaed iti daga a papananyo. Papatayekto dagiti amin a tattao a masabatyo. Pagtallikodekto dagiti amin a kabusoryo gapu iti buteng. ");
INSERT INTO iloulb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mangibaonakto kadagiti ayukan iti sangoananyo a mangpapanaw kadagiti Heveo, Cananeo, ken Heteo inton sumungadkayo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Saanko ida a papanawen iti sangoananyo iti las-ud iti maysa a tawen, wenno saan, agbalin a nagtalawan ti daga, ket umado iti kasta unay dagiti atap nga ayup. ");
INSERT INTO iloulb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ngem ketdi, in-inutekto a papanawen ida iti sangoananyo agingga nga umadukayo ket tagikuaenyo ti daga. ");
INSERT INTO iloulb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Irugikto ti beddengyo manipud iti baybay dagiti Runo agingga iti baybay dagiti Filisteo, ken manipud iti let-ang agingga iti karayan ti Eufrates. Pagballigienkayo kadagiti agnanaed iti entero a daga. Papanawenyonto ida iti sangoananyo. ");
INSERT INTO iloulb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Masapul a saankayo a makitulag kadakuada wenno kadagiti diosda. ");
INSERT INTO iloulb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Masapul a saanda nga agnaed iti dagayo, ta no saan pagaramidendakayo iti basol a maibusor kaniak. No agdayawkayo kadagiti diosda, sigurado nga agbalinto daytoy a palab-og kadakayo.”” ");
INSERT INTO iloulb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ket kinuna ni Yahweh kenni Moises, “Sumang-atka kaniak—sika, ni Aaron, ni Nadab, ni Abiu, ken ti pitopulo kadagiti panglakayen dagiti Israel, ket agdayawkayo kaniak iti adayo. ");
INSERT INTO iloulb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ni Moises laeng ti mabalin nga umasideg kaniak. Masapul a saan nga umasideg dagiti dadduma, ken masapul a sumang-at dagiti tattao iti ayanko a kaduada isuna.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Napan imbaga ni Moises kadagiti tattao dagiti amin a sasao ken dagiti bilbilin ni Yahweh. Simmungbat dagiti amin a tattao iti maymaysa a timek ket kinunada, “Aramidenmi dagiti amin nga imbaga ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kalpasanna, insurat ni Moises dagiti amin a sasao ni Yahweh. Iti agsapa, nangipatakder ni Moises iti altar iti sakaanan ti bantay ken nangurnos iti sangapulo ket dua nga adigi a bato, tapno dagiti bato ti mangibagi kadagiti sangapulo ket dua a tribu iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Imbaonna dagiti sumagmamano nga agtutubo a lallaki nga Israelita nga agidatag kadagiti daton a maipuor ken mangidatag iti bakan a kas daton a pannakilangen-langen kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Innala ni Moises ti kagudua iti dara ket inkabilna daytoy kadagiti palanggana; insuyatna ti kagudua iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Innalana ti Libro ti Tulag ket imbasana daytoy iti napigsa kadagiti tattao. Kinunada, “Aramidenmi amin dayta nga imbaga ni Yahweh. Agtulnogkami.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kalpasanna, innala ni Moises ti dara ket insuyatna daytoy kadagiti tattao. Kinunana, “Daytoy ti dara ti tulag nga inaramid ni Yahweh kadakayo babaen iti panangitedna iti daytoy a kari kadakayo babaen kadagitoy amin a sasao.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kalpasanna, simmang-at da Moises, Aaron, Nadab, Abiu ken dagiti pitopulo a panglakayen ti Israel iti bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Nakitada ti Dios iti Israel. Iti babaen ti sakana ket adda iti pagnaan a naaramid iti bato a safiro, a kas kalawag ti tangatang. ");
INSERT INTO iloulb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Saan a dinangran ti Dios iti pungtotna dagiti mangidadaulo nga Israelita. Nakitada ti Dios, ket nangan ken imminomda. ");
INSERT INTO iloulb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kinuna ni Yahweh kenni Moises, “Sumang-atka kaniak idiay bantay ket agtalinaedka sadiay. Itedkonto kenka dagiti tapi ti bato ken ti linteg ken dagiti bilbilin nga insuratko, tapno isurom kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Nagsagana ngarud ni Moises ken ti katulonganna a ni Josue ket simmang-atda iti bantay ti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kinuna ni Moises kadagiti panglakayen, “Agtalinaedkayo ditoy ken urayendakami agingga nga agsublikami kadakayo. Adda ni Aaron ken Hur a kaduayo. No adda riri ti siasinoman, mapan koma isuna kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Simmang-at ngarud ni Moises iti bantay, ket linengdan daytoy iti ulep. ");
INSERT INTO iloulb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Bimmaba ti dayag ni Yahweh iti tapaw ti Bantay Sinai, ket kinalluban daytoy iti ulep iti las-ud ti innem nga aldaw. Iti maikapito nga aldaw, inawagan ni Yahweh ni Moises manipud iti ulep. ");
INSERT INTO iloulb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ti panagparang ti dayag ni Yahweh ket kasla iti makauram nga apuy iti tapaw ti bantay iti imatang dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Simrek ni Moises iti ulep ket simmang-at iti bantay. Adda isuna idiay ngato iti bantay iti las-ud iti uppat a pulo nga aldaw ken rabii. ");
INSERT INTO iloulb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Kinuna ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ibagam kadagiti Israelita a mangalada iti daton para kaniak manipud iti tunggal tao a matignay nga agited babaen iti situtulok a puso. Masapul nga awatenyo dagitoy a daton para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Dagitoy dagiti daton a masapul nga awatem manipud kadakuada. balitok, pirak, bronse, ");
INSERT INTO iloulb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","maris asul, maris ube, ken tumayengteng ti labbagana a buok ti karnero ken ti napino a lino; buok ti kalding; ");
INSERT INTO iloulb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dagiti napalabbaga a lalat ti kalakian a karnero ken dagiti lalat ti dugong; kayo ti akasia, ");
INSERT INTO iloulb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lana para iti pagsilawan iti santuario, rekrekado a mailaok iti lana a pangpulot ken ti nabanglo nga insenso, ");
INSERT INTO iloulb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","dagiti bato nga onyx ken dagiti dadduma a napapateg a batbato a maikabil iti efod ken iti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Pagaramidem ida iti santuario a para kaniak tapno makapagnaedak kaduada. ");
INSERT INTO iloulb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Masapul nga aramidenyo daytoy nga apag-isu kas iti ipakitak kenka iti plano para iti tabernakulo ken para iti amin nga alikamenna. ");
INSERT INTO iloulb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Masapul a mangaramidda iti lakasa manipud iti kayo ti akasia. Masapul a dua ket kagudua a cubico ti kaatiddugna; ti kaakabana ket maysa ket kagudua a cubico; ken ti kangatona ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Masapul a kalupkopanyo ti uneg ken ruarna daytoy iti puro a balitok, ken masapul a paikingam iti balitok ti aglikmot iti rabawna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Masapul a mangpandaykayo iti uppat a pangiyusokan a balitok para iti daytoy ket ikabilyo dagitoy iti uppat a saka ti lakasa, dua a pangiyusokan iti maysa a sikiganna ken dua a pangiyusokan iti bangir a sikigan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Masapul a mangaramidkayo iti assiw manipud iti kayo ti akasia ket kalupkopanyo dagitoy iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Masapul nga iyusokyo ti assiw kadagiti pangiyusokan nga adda iti sikigan ti lakasa, tapno maawit ti lakasa. ");
INSERT INTO iloulb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Masapul nga agtalinaed dagiti assiw iti pangiyusokan ti lakasa ti tulag; masapul a saanda a maik-ikkat manipud iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Masapul nga ikabilmo iti uneg iti lakasa ti dagiti bilin ti katulagan nga itedkonto kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Masapul a mangaramidkayo iti kalub a pakapakawanan manipud iti puro a balitok. Masapul a ti kaatiddogna ket maysa ket kagudua a cubico, ken masapul a ti kalapadna ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Masapul a mangaramidkayo iti dua a sinan kerubim manipud iti pinitpit a balitok para iti agsinnumbangir a murdong ti kalub a mangipakita iti pannakakalub iti basol. ");
INSERT INTO iloulb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Mangaramidkayo iti maysa a sinan kerubim para iti maysa a murdong ti kalub a pakapakawanan, ken ti maysa a sinan kerubim para iti bangir a murdong. Masapul maaramidda a kas maymaysa iti kalub a pakapakawanan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Masapul a nakaukrad a pangato ti payyak dagiti sinan kerubim ket malingedan ti kalub a pakapakawanan babaen kadagitoy. Masapul nga agsinnango dagiti sinan kerubim ken kumitada iti tengnga ti kalub a pakapakawanan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Masapul nga ikabil mo ti kalub a pakapakawanan iti rabaw ti lakasa, ken masapul nga ikabilyo iti uneg ti lakasa dagiti bilin ti katulagan nga itedko kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Iti ayanto ti lakasa ti pakisinnarakak kenka. Agsaoakto kenka manipud iti ayanko iti ngatoen ti kalub a pakapakawanan. Makisaritaakto kenka maipanggep kadagiti amin a bilin nga itedko kenka para kadagiti Israelita idiay nagbaetan dagiti dua a sinan kerubim nga adda iti ngatoen ti lakasa ti bilin ti katulagan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Masapul a mangaramidkayo iti lamisaan manipud iti kayo ti akasia. Masapul a ti kaatiddogna ket dua a cubico; masapul a maysa a cubico ti kalapadna ken maysa ket kagudua a cubico ti kangatona. ");
INSERT INTO iloulb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Masapul a kalupkopanyo daytoy iti puro a balitok ken paikinganyo iti balitok ti aglikmot ti rabawna. ");
INSERT INTO iloulb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Masapul a mangaramidkayo iti paigidna daytoy a maysa a dakulap ti kalapadna, nga addaan iti paigid a napaikingan iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Masapul nga iyaramidanyo daytoy iti uppat a pangiyusokan a balitok ken ikapetyo dagiti pangiyusokan kadagiti uppat a suli, nga ayan dagiti uppat a sakana. ");
INSERT INTO iloulb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Masapul a naikapet dagiti pangiyusokan iti paigidna tapno adda pangisuluopan kadagiti assiw, tapno mabalin a maawit ti lamisaan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Masapul nga aramidenyo ti assiw manipud iti kayo ti akasia ken kalupkopanyo dagitoy iti balitok tapno maawit ti lamisaan babaen kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Masapul nga agaramidkayo kadagiti pinggan, kutsara, burnay ken mallukong a mausar a pangibukbokan kadagiti daton a mainom. Masapul nga aramidenyo dagitoy manipud iti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Masapul a kanayonyo nga ikabil ti tinapay ti presensiak iti rabaw ti lamisaan iti sangoanak. ");
INSERT INTO iloulb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Masapul a mangaramidka iti kandelero manipud iti napitpit a puro a balitok. Ti kandelero ket maaramid nga addaan iti puonna ken ungkayna. Dagiti kopana, dagiti nakortean iti sinan bulong a puonna, ken dagiti sabongna ket masapul a maaramid a maymaysa iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Masapul nga innem a sanga ti aguyauy manipud iti sikiganna—tallo a sanga ti masapul nga aguyauy iti maysa a sikigan, ken tallo a sanga ti kandelero iti bangir a sikigan. ");
INSERT INTO iloulb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ti umuna a sanga ket masapul nga addaan iti tallo a kopa a naaramid a kasla sabong ti almendras, nga addaan iti sinanbulong a puon ken sabong, ken tallo a kopa a naaramid a kasla sabong ti almendras iti bangir a sanga, nga addaan iti sinanbulong a puon ken sabong. Masapul nga agpapada dagiti innem a sanga nga aguy-uyauy iti kandelero. ");
INSERT INTO iloulb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Iti mismo a kandelero, ti makintengnga nga ungkay, masapul nga addaan daytoy iti uppat a kopa a naaramid a kasla sabong ti almendras, nga addaan kadagiti sinanbulong a puon ken sabong. ");
INSERT INTO iloulb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Masapul nga adda sinanbulong a puon iti sirok ti umuna a pares dagiti sanga— a naikamang iti daytoy, ken maysa a sinanbulong a puon iti sirok ti maikadua a pares dagiti sanga—a naikamang met laeng iti daytoy. Iti isu met laeng a wagas, masapul nga adda sinanbulong a puon iti sirok ti maikatlo a pares dagiti sanga, a naikamang met laeng iti kandelero. Masapul nga agpapada dagiti innem a sangsanga nga agdawadaw iti kandelero. ");
INSERT INTO iloulb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Dagiti sinanbulong a puonna ken dagiti sangana ket masapul a maaramid a sangsangkamaysa iti kandelero, maysa a napanday a puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Masapul nga aramidenyo ti kandelero ken ti pito a pagsilawanna, ken simpaem ti tunggal pagsilawan tapno makaipaayda iti lawag. ");
INSERT INTO iloulb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Dagiti pagipit ken pagarsangan ket masapul a maaramid iti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Mangaramatka iti maysa a talento ti puro a balitok a mangaramid iti kandelero ken kadagiti aruatenna. ");
INSERT INTO iloulb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Siguradoem nga aramidem dagitoy segun iti pagtuladan a naipakita kenka idiay bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Masapul nga aramidenyo ti tabernakulo manipud iti sangapulo a kurtina a naaramid iti kasasayaatan a lino, ken asul, maris ube, ken nalabaga a de lana nga addaan kadagiti burda a kerubim. Aramidento daytoy iti nalaing a bumuburda. ");
INSERT INTO iloulb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ti kaatiddog iti tunggal kurtina ket masapul a duapulo ket walo a cubico, ti kaakabana ket uppat a cubico. Masapul nga agpapada ti rukod dagiti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Masapul a mapagsasaep dagiti lima a kurtina, ken dagiti sabali a lima a kurtina ket masapul nga mapagsasaep met laeng iti tunggal maysa. ");
INSERT INTO iloulb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Masapul a mangaramidkayo kadagiti asul a pangyusokan para iti akinruar a pingir ti akin-udi a kurtina iti maysa a beddeng. Iti isu met laeng a wagas, masapul a kasta met laeng ti aramidenyo iti akinruar a pingir ti maudi a kurtina iti maikaddua a beddeng. ");
INSERT INTO iloulb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Masapul a mangaramidkayo iti limapulo a pagiyusokan iti umuna a kurtina, ken masapul a mangaramidkayo iti lima pulo a pagiyusokan iti maudi a kurtina iti maikaddua a beddeng. Aramidenyo daytoy tapno dagiti pagiyusokan ket agbabatogdanto iti tunggal maysa. ");
INSERT INTO iloulb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Masapul a mangaramidkayo iti limapulo a kawit a balitok ken pagkakamangenyo dagiti kurtina kadagitoy tapno agbalin a maymaysa ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Masapul a mangaramidkayo kadagiti kurtina manipud iti buok ti kalding a pangabbong iti ngato ti tabernakulo a kasla tolda. Masapul a mangaramidkayo iti sangapulo ket maysa kadagitoy a kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ti kaatiddog iti tunggal kurtina ket masapul a tallopulo a cubico, ken ti kaakaba iti tunggal kurtina ket masapul nga uppat a cubico. Tunggal maysa kadagiti sangapulo ket maysa a kurtina ket masapul nga agpapada iti rukodda. ");
INSERT INTO iloulb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Masapul a pagsasaepenyo dagiti lima a kurtina ken kasta met dagiti innem a kurtina. Masapul a kulpienyo ti maikanem a kurtina iti sangoanan ti tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Masapul a mangaramidkayo iti limapulo a pagiyusokan iti pingir ti maudi a kurtina iti umuna a beddeng, ken limapulo a pagiyusokan iti pingir ti maudi a kurtina a nagsaepan ti maikadua a beddeng. ");
INSERT INTO iloulb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Masapul a mangaramidka iti lima pulo a bronse a kaw-it ket ikabilmo dagitoy kadagiti pagiyusokan. Kalpasanna, masapul a pagsasaepenyo ti pangabbong a kasla tolda tapno agbalin daytoy a maymaysa. ");
INSERT INTO iloulb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ti nabati a kagudua ti kurtina, ti nakadawadaw a paset manipud kadagiti kurtina ti tolda ket masapul a nakabitin iti likudan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Masapul nga adda maysa a cubico a kurtina iti maysa a sikigan, ken maysa a cubico ti kurtina iti maysa pay a sikigan— dayta a nabati iti atiddog a kurtina ti tolda ket masapul a nakabitin iti maysa a sikigan ti tabernakulo ken iti sabali pay a sikiganna, tapno maabbonganna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Masapul a mangaramidkayo iti pangabbong para iti tabernakulo a lalat iti kalakian a karnero a namarisan iti nalabaga ken maysa pay a pangabbong a naaramid manipud iti kasayaatan a lalat tapno maikabil iti ngatoenna dayta. ");
INSERT INTO iloulb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Masapul a mangaramidkayo kadagiti tabla manipud iti kayo ti akasia a maipatakder para iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ti kaatiddog iti tunggal tabla ket masapul a sangapulo a cubico, ken iti kaakabana ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Masapul nga adda dua a nakadawadaw iti tunggal tabla para iti panangisilpo kadagiti tabla iti tunggal maysa. Masapul nga aramidenyo amin dagiti tabla ti tabernakulo iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Inton aramidenyo dagiti tabla para iti tabernakulo, masapul a mangaramidkayo iti duapulo a tabla para iti abagatan a paset. ");
INSERT INTO iloulb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Masapul a mangaramidkayo iti uppat a pulo a pirak a pagbatayan a maipasiruk kadagiti duapulo a tabla. Masapul nga adda ti dua a pagbatayan iti sirok ti umuna a tabla nga isu iti dua a pagbatayanna, ken kasta met a dua a pagbatayan iti sirok ti dagiti amin a tabla para iti dua a pakaipabatayanda. ");
INSERT INTO iloulb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Para iti maikaddua a paset ti tabernakulo, iti amianan a paset, masapul a mangaramidkayo iti duapulo a tabla, ");
INSERT INTO iloulb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ken dagiti uppat a pulo a pirak a pagbatayanda. Masapul nga adda dua a pagbatayan iti sirok ti umuna a tabla, dua a pagbatayan iti sirok ti sumaruno a tabla, ken kasta met kadagiti dadduma a tabla. ");
INSERT INTO iloulb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Para iti likudan ti tabernakulo iti laud a paset, masapul a mangaramidkayo iti innem a tabla. ");
INSERT INTO iloulb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Masapul a mangaramidkayo iti dua a tabla para iti akin likud a suli ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Dagitoy a tabla ket masapul nga agsina iti baba, ngem agtiponda iti ngato iti agpada a singsing. Masapul a kastoy a wagas para kadagiti amin a suli iti likudan. ");
INSERT INTO iloulb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Masapul nga adda iti walo a tabla agraman dagiti pagbatayanda a pirak. Masapul nga adda ti sangapulo ket innem a pagbatayan, dua a pagbatayan iti sirok ti umuna a tabla, dua a pagbatayan iti sirok ti sumaruno a tabla, ken kasta met kadagiti dadduma pay. ");
INSERT INTO iloulb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Masapul a mangaramidkayo kadagiti balunet a kayo iti acasia—lima para kadagiti tabla iti maysa a paset ti tabernakulo, ");
INSERT INTO iloulb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","lima a balunet para kadagiti tabla iti sabali a paset ti tabernakulo, ken lima a balunet para kadagiti tabla iti likudan a paset ti tabernakulo agingga iti laud. ");
INSERT INTO iloulb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ti balunet iti tenga dagiti tabla, dayta ket, maingato a kagudua, ket masapul a dumanun manipud iti murdong agingga iti bangir a murdong. ");
INSERT INTO iloulb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Masapul a kalupkopanyo iti balitok dagiti tabla. Masapul a balitok ti aramidem a singsingda, ta agserbi dagitoy a kas mangtengel kadagiti balunet ken masapul a kalupkopanyo iti balitok dagiti balunet. ");
INSERT INTO iloulb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Masapul a bangonem ti tabernakulo babaen ti panangsurotmo iti plano a naipakita kenka idiay bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Masapul a mangaramidkayo iti kurtina nga asul, maris ube, ken nalabaga a de lana, ken napino a lino, nga addaan kadagiti disenio a kerubim, aramiden daytoy iti nalaing a trabahador. ");
INSERT INTO iloulb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Masapul nga ibitinyo dagitoy kadagiti uppat nga adigi a kayo iti acasia a nakalupkopan iti balitok. Dagitoy nga adigi ket masapul nga addaan kadagiti kaw-it a balitok a naisaad kadagiti uppat a pirak a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Masapul nga ibitinmo ti kurtina iti babaen ti pagsab-itan, ket masapul nga iyunegmo ti lakasa ti tulag. Ti kurtina ket isu ti mangisina iti nasantoan a disso manipud iti kasasantoan a disso. ");
INSERT INTO iloulb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Masapul nga ikabilmo ti kalub a pakapakawanan iti rabaw iti lakasa ti tulag, nga adda idiay kasasantoan a lugar. ");
INSERT INTO iloulb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Masapul nga ikabilmo ti lamisaan iti ruar iti kurtina. Masapul nga ikabilmo ti kandelero a kasango ti lamisaan idiay abagatan a paset ti tabernakulo. Ti lamisaan ket masapul nga addanto iti abagatan a paset. ");
INSERT INTO iloulb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Masapul a mangaramidkayo iti maibitin a para iti pagserkan ti tolda. Masapul nga aramidenyo daytoy manipud iti asul, maris ube, ken nalabaga a de lana, usarem ti tinali a kasasayaatan a lino, aramiden daytoy ti bumuburda. ");
INSERT INTO iloulb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Para iti kurtina, masapul a mangaramidkayo iti lima nga adigi nga acasia ken kalupkupanyo dagitoy iti balitok. Dagiti kaw-itanda ket masapul a naaramid iti balitok, ken masapul a mangaramidkayo iti lima a bronse a pagbatayan para kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Masapul nga aramidenyo iti altar a manipud iti kayo ti akasia, lima a cubico ti kaatiddogna ken lima a cubico iti kaakabana. Ti altar ket masapul a kuadrado ken tallo a cubico iti kangatona. ");
INSERT INTO iloulb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Masapul a mangaramidka iti dawadaw a nasukog a kasla kadagiti sara ti kalakian a baka a maipadawadaw kadagiti uppat a sulina. Maaramidto dagiti sara a kas maymaysa iti altar, ken masapul a kalupkopanyo dagitoy iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Masapul a mangaramidkayo kadagiti alikamen a para iti altar: dagiti banga a pagikabilan iti dapo, ken uray pay dagiti pala, dagiti palanggana, dagiti salungkay a pagadaw iti karne, ken dagiti banga a pagekkan iti beggang. Masapul nga aramideyo amin dagitoy nga alikamen babaen iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Masapul a mangaramidkayo iti barandilias a nalaga iti bronse a para iti altar. Mangaramidkayo iti singsing a bronse para iti uppat a suli dagiti tunggal barandilias. ");
INSERT INTO iloulb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Masapul nga ikabilyo ti barandilias iti sirok ti ngarab ti altar, a maipababa iti kagudua. ");
INSERT INTO iloulb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Masapul a mangaramidkayo kadagiti assiw a para iti altar, assiw a naaramid iti kayo nga akasia, ken masapul a kalupkopanyo dagitoy iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Masapul a maikabilto dagiti assiw kadagiti singsing a pagiyusokan, ken dagiti assiw ket masapul nga addanto iti dua a sikigan ti altar tapno maawit daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Masapul nga aramidenyo ti altar nga awan naggianna, a naaramid iti napuskol a tabla. Masapul nga aramidenyo daytoy iti wagas a naipakita kenka idiay bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Masapul a mangaramidkayo iti paraangan para iti tabernakulo. Masapul nga adda iti nakabitin a kurtina iti abagatan a paset ti paraangan, maibitin a kurtina a tinali a napino a lino a sangagasut a cubico iti kaatiddogna. ");
INSERT INTO iloulb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Dagiti maibitin a kurtina ket masapul nga addaan iti duapulo a poste, nga addaan kadagiti duapulo a bronse a pagbatayan. Masapul nga adda pay iti kawit a naikapet kadagiti poste, kasta met kadagiti pangubon a pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kasta met, iti abagatan a paset, masapul nga addanto maibitin a sangagasut a cubico iti kaatiddogna nga addaan iti duapulo a poste, duapulo a batay a bronse, ken dagiti kawit a maikapet kadagiti poste, ken kadagiti pangubon a pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Iti paraangan iti laud a paset ket masapul nga addanto iti kurtina a lima pulo a cubico iti kaatiddogna. Masapul nga addanto iti sangapulo a poste ken sangapulo a batay. ");
INSERT INTO iloulb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ti paraangan ket masapul met a lima pulo a cubico iti kaatiddogna iti daya a pasetna. ");
INSERT INTO iloulb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Dagiti maibitin iti maysa a paset iti pagserkan ket masapul a sangapulo ket lima a cubico iti kaatiddogna. Masapul nga addaan dagitoy iti tallo a poste ken tallo a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ti bangir a paset ket masapul nga addaanto met kadagiti maibitin a sangapulo ket lima a cubico iti kaatiddogna. Masapul nga addaan dagitoy iti tallo a poste ken tallo a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ti ruangan ti paraangan ket masapul a maysa a kurtina a duapulo a cubico iti kaatiddogna. Masapul a maaramidto ti kurtina iti asul, maris ube, ken nalabaga a lino, tinali a napino a lino, aramiden daytoy iti bumurburda. Masapul nga addaan dagitoy iti uppat a poste ken uppat a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dagiti amin a poste iti paraangan ket masapul nga addaan kadagiti pagubon a pirak, kawit a pirak, ken pagbatayan a bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ti kaatiddog ti paraangan ket masapul a sangagasut a cubico, lima pulo a cubico iti kaakabana, ken lima a cubico iti kangatona nga addaan iti nakabitin a tinali a napino a lino iti amin nga aglawlawna, ken pagbatayan a bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Amin nga alikamen a mausar iti tabernakulo, ken amin dagiti pasok ti tolda a para iti tabernakulo ken ti paraangan ket masapul a maaramid manipud iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Masapul a bilinem dagiti Israelita a mangiyegda iti napespes a puro a lana ti olibo para kadagiti pagsilawan tapno agtultuloy dagitoy a sumsumged. ");
INSERT INTO iloulb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Idiay tolda a paguommongan, iti ruar ti kurtina nga adda iti sango ti lakasa ti tulag, masapul nga aywanan ni Aaron ken dagiti annakna a lallaki dagiti pagsilawan manipud iti rabii agingga iti bigat iti sangoanan ni Yahweh. Daytoy ket paglinteganto iti agnanayon kadagiti amin a kaputotan iti nasion nga Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ayabam ni Aaron a kabsatmo ken dagiti annakna a lallaki— da Nadab, Abiu, Eleasar, ken Itamar, — manipud kadagiti Israelita tapno makapagserbida kaniak a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Masapul nga iyaramidanyo ni Aaron a kabsatmo kadagiti pagan-anay a naidaton kaniak. Dagitoy a pagan-anay ket para iti dayaw ken rangrangna. ");
INSERT INTO iloulb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Masapul a kasaom dagiti amin tattao a naisangsangayan ti kinalaingda, kadagiti pinunnok iti espiritu iti kinasisrib, tapno maaramidda dagiti pagan-anay ni Aaron tapno mailasin isuna nga agserbi kaniak a kas padi. ");
INSERT INTO iloulb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Dagiti pagan-anay a masapul nga aramidenda ket ti pektoral, ti efod, ti kagay, ti naabel a pagan-anay, ti turbante, ken ti barekes. Masapul nga aramidenda dagitoy a pagan-anay a naidaton kaniak. Maipaayto dagitoy iti kabsatmo a ni Aaron ken kadagiti annakna a lallaki tapno makapagserbida kaniak a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Masapul a mangusar dagiti dumidesenio iti napino a lino a balitok, asul, maris ube, ken nalabaga. ");
INSERT INTO iloulb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Masapul nga aramidenda ti efod iti balitok, iti asul, maris ube, ken nalabaga a de lana ken iti napino a tinali a lino. Masapul nga aramidento daytoy iti nalaing a dumidesenio. ");
INSERT INTO iloulb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Masapul nga adda dua a terante a maikapet iti dua nga akin ngato a sulina. ");
INSERT INTO iloulb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ti nasayaat iti pannakaabelna a barikes ket masapul a kasla iti efod. Masapul a maaramidto daytoy a maysa a pidaso a kapaset iti epod, a maaramid manipud iti tinali a napino a lino a balitok, asul, maris ube, ken nalabaga. ");
INSERT INTO iloulb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Masapul a mangalaka iti dua a bato nga onyx ket ikitikitmo kadagitoy ti nagnagan dagiti sangapulo ket dua nga annak a lallaki ni Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Innem kadagiti nagnaganda ti masapul a maikabil iti maysa a bato, ken innem a nagnagan ti masapul nga adda iti maysa pay a bato, a segun iti urnos ti pannakaiyanak dagiti annak a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Babaen ti panangaramid iti kumikitikit iti bato, a kasla iti pannakaikitikit ti pangtimbre, masapul nga ikitikitmo kadagiti dua a bato ti nagan dagiti sangapulo ket dua nga annak a lallaki ni Israel. Masapul nga isaadmo dagiti bato kadagiti pagsaadan a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Masapul nga ikabilmo dagiti dua a bato kadagiti dua a terante ti epod, tapno agbalin a batbato a mangipalagip kenni Yahweh kadagiti annak a lallaki ni Israel. Awitento ni Aaron dagiti naganda kadagiti dua nga abagana iti sangoanan ni Yahweh a kas mangipalagip kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Masapul a mangaramidka kadagiti pagsaadan a balitok, ");
INSERT INTO iloulb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ken dua a nasallapid a kawar a puro a balitok a kasla tali, ken masapul nga ikapetmo dagiti kawar kadagiti pagsaadan. ");
INSERT INTO iloulb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Masapul a mangaramidka iti pectoral a para iti pangeddeng, nga aramiden iti nalaing a trabahador, a maipada iti epod. Maaramid daytoy iti balitok, iti asul, maris ube, ken nalabaga a de lana, ken napino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Daytoy ket masapul a kuadrado. Masapul nga ikulpem iti mamindua ti pectoral. Masapul a maysa a dangan iti kaatiddogna ken maysa a dangan iti kalawana. ");
INSERT INTO iloulb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Masapul a kabilanyo daytoy iti uppat nga intar iti napapateg a batbato. Ti umuna nga intar ket masapul nga adda ti maysa a rubi, maysa a topasio ken maysa a garnet. ");
INSERT INTO iloulb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ti maikadua nga intar ket masapul nga adda ti maysa nga esmeralda, maysa a safiro, ken maysa a diamante. ");
INSERT INTO iloulb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ti maikatlo nga intar ket masapul nga adda ti maysa a jacinto, maysa nga agate ken maysa nga amatista, ");
INSERT INTO iloulb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ti maikapat nga intar ket masapul nga adda ti maysa a berilio, maysa nga onyx, ken maysa a jasper. Masapul a maimontar dagitoy kadagiti pagsaadan a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Masapul a maiyurnos dagiti batbato segun kadagiti nagan dagiti sangapulo ket dua nga annak a lallaki ni Israel, tunggal maysa segun iti urnos ti nagan. Masapul a dagitoy ket kasla iti naikitikit iti singsing a pangselio, itaktakder ti tunggal nagan ti maysa kadagiti sangapulo ket dua a tribu. ");
INSERT INTO iloulb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Masapul a mangaramidka iti rabaw ti pektoral iti kawar a kasla kadagiti tali, a nasallapid a puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Masapul a mangaramidka iti dua a singsing a balitok ken ikapetmo dagitoy kadagiti dua nga igid ti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Masapul nga ikapetmo ti dua a kawar a balitok kadagiti dua a suli ti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Masapul nga ikapetmo dagiti bangir a murdong ti dua a nasallapid a kawar iti dua a pagsaadan. Kalpasanna, masapul nga ikapetmo dagitoy iti terante iti abaga ti efod iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Masapul a mangaramidka iti dua a singsing a balitok, ken ikabilmo dagitoy kadagiti dua a suli ti pektoral, iti pingir iti abay ti akin uneg nga igidna. ");
INSERT INTO iloulb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Masapul a mangaramidka iti dua pay a singsing a balitok, ken masapul nga ikapetmo dagitoy iti baba dagiti dua a terante iti abaga ti sangoanan ti efod, nga asideg iti nakaidaitanna, iti ngato ti nasayaat iti pannakaabelna a barikes ti efod. ");
INSERT INTO iloulb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Masapul nga igalutda ti pektoral babaen kadagiti singsingna iti asul a tali kadagiti singsing ti efod, tapno maikapet daytoy iti ngatoen ti naabel a barikes ti efod. Daytoy ket, tapno saan a maikkat ti pektoral manipud iti efod. ");
INSERT INTO iloulb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Inton umuneg ni Aaron iti nasantoan a disso, masapul nga awitenna dagiti nagan dagiti sangapulo ket dua nga annak a lallaki ni Israel iti pektoral nga adda iti rabaw ti pusona para iti panangikeddeng. Agserbinto daytoy a kas kankanayon a palagip kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Masapul nga ikabilmo ti Urim ken ti Tummim iti pektoral para iti panagaramid iti pangeddeng. Masapul nga adda dagitoy iti barukong ni Aaron inton mapan isuna iti sangoanan ni Yahweh, ken masapul a kankanayon nga awiten ni Aaron iti barukongna ti panangaramid ti pangeddeng para kadagiti Israelita iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Masapul nga aramidem ti kagay ti efod manipud laeng iti maris ube a lupot. ");
INSERT INTO iloulb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Masapul nga adda pangiyusokan iti ulo iti tengngana. Masapul a maabel ti aglawlaw iti igid ti pangiyusokan tapno saan a mapigis daytoy. Masapul nga aramidento daytoy ti umaabel. ");
INSERT INTO iloulb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Iti akinbaba a gayadan, masapul a mangaramidka kadagiti granada nga asul, maris ube, ken nalabaga a pagdait iti amin nga aglawlawna. Masapul nga adda iti kampanilia a balitok kadagiti nagbabaetanda. ");
INSERT INTO iloulb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Masapul nga adda iti kampanilia a balitok ken granada, maysa a kampanilia a balitok ken granada— inggana a maikkan amin —iti amin a gayadan ti kagay. ");
INSERT INTO iloulb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ti kagay ket masapul a nakasuot kenni Aaron inton agserbi isuna, tapno ti unina ket mangngeg no umuneg ken no pumanaw isuna iti nasantoan a disso iti sangoanan ni Yahweh. Daytoy ket tapno saan isuna a matay. ");
INSERT INTO iloulb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Masapul a mangaramidka iti pinitpit a puro a balitok ken ikitikitmo iti rabawna daytoy, a kapada kadagiti naikitikit iti pangtimbre, NAIDATON KENNI YAHWEH. ");
INSERT INTO iloulb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Masapul nga ikapetmo daytoy a pinitpit a puro a balitok babaen iti asul a tali iti sango ti turbante. ");
INSERT INTO iloulb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Masapul nga adda daytoy iti muging ni Aaron; masapul nga awitenna a kanayon ti aniaman a basol a mabalin a maipasurot iti pannakaidaton dagiti nasantoan a sagsagut dagiti Israelita kenni Yahweh. Ti turbante ket masapul nga adda a kanayon iti muging ni Aaron tapno awaten ni Yahweh dagiti sagsagutda. ");
INSERT INTO iloulb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Masapul nga aramidenyo ti kagay manipud iti napino a lino, ken masapul nga aramidenyo ti turbante manipud iti napino a lino. Masapul a mangaramidkayo pay iti barikes, aramiden iti maysa a bumuburda. ");
INSERT INTO iloulb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Para kadagiti annak a lallaki ni Aaron, masapul a mangaramidkayo kadagiti nagayad a kagay, kadagiti barekes ken kadagiti baredbed dagiti uloda para iti dayawda ken rangrangda. ");
INSERT INTO iloulb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Masapul a kawesam ni Aaron a kabsatmo ken dagiti annakna a lallaki a kadduana. Masapul a pulotam ida, konsagraram ida, ken idatonmo ida kaniak, tapno makapagserbida kaniak a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Masapul nga iyaramidanyo ida iti lino a pagan-anay a pang-uneg tapno maabbongan dagiti nakalemmeng a paset iti bagida, pagan-anay a pang-uneg a mangabbong kadakuada manipud iti siket inggana iti luppoda. ");
INSERT INTO iloulb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Masapul nga usaren da Aaron ken dagiti annakna a lallaki dagitoy no umunegda iti tabernakulo wenno no umasidegda iti altar tapno agserbida iti nasantoan a disso. Masapul nga aramidenda dagitoy tapno awan iti awitenda a basol ken saanda a matay. Daytoy ket agnanayon a linteg kada Aaron ken kadagiti kaputotanna a sumarsaruno kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ita, kastoy ti aramidem a panangkonsagrar kadakuada tapno makapagserbida kaniak a kas papadi. Mangalaka iti maysa a bumaro a baka ken dua a kalakian a karnero nga awan mulitna, ");
INSERT INTO iloulb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tinapay nga awan lebadurana, ken dagiti bibingka nga awan lebadurana a nalaokan iti lana. Mangalaka pay kadagiti ostia nga awan lebadurana a napulagidan iti lana. Aramidem dagiti ostia babaen iti panangaramat ti kasayaatan nga arina. ");
INSERT INTO iloulb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Masapul nga ikabilmo dagitoy iti maysa a basket, iyegmo dagitoy a nakabasket, ken idatagmo dagitoy a kadua ti baka ken ti dua a kalakian a karnero. ");
INSERT INTO iloulb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Masapul nga idatagmo ni Aaron ken dagiti annakna a lallaki iti pagserkan ti tabernakulo. Masapul a buggoam ni Aaron ken dagiti annakna a lallaki iti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Masapul nga alaem dagiti pagan-anay ket ikawesmo kenni Aaron ti nagayad a bado, ti kagay ti efod, ti efod, ken ti pektoral, ibarekesmo kenkuana ti naabel a barikes ti efod. ");
INSERT INTO iloulb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Masapul nga iyurnosmo ti turban iti ulona ken ikabilmo ti nasagradoan a korona iti rabaw ti turban. ");
INSERT INTO iloulb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kalpasanna, alaem ti pangkonsagrar a lana ken ibukbokmo daytoy iti ulona, ket iti kastoy a wagas konsagraram isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Masapul nga iyegmo dagiti annakna a lallaki ken ikawesmo kadakuada dagiti nagayad a bado. ");
INSERT INTO iloulb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Masapul a kawesam ni Aaron ken dagiti annakna a lallaki kadagiti barikes ken ikabilmo dagiti pangbedbed iti ulo kadakuada. Maited kadakuada ti trabaho ti maysa a padi babaen iti linteg nga agnanayon. Konsagraram ni Aaron ken dagiti annakna a lallaki iti kastoy a wagas tapno agserbida kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Masapul nga ipanmo ti sibubukel a baka iti pagserkan ti tabernakulo, ken masapul nga ipatay ni Aaron ken dagiti annakna a lallaki dagiti imada iti ulona daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Masapul a papatayem ti kalakian a baka iti pagserkan ti tabernakulo iti sangoanak, ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Masapul a mangalaka iti bassit a dara iti baka ket ipunasmo daytoy kadagiti sara ti altar babaen kadagiti ramaymo, ken ibukbokmo ti nabati a dara iti sakaanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Masapul nga alaem dagiti amin a taba a nangbalkot kadagiti lalaem, ken alaem met ti nangbalkot iti dalem ken ti dua a bekkel agraman dagiti tabana; puoram amin dagitoy iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ngem ti lasag ti kalakian a baka, agraman ti lalat ken naguneg a nagyanan iti rugit, masapul a puoram dagitoy iti ruar ti kampo. Daytoy ket daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Masapul nga alaem pay iti maysa a kalakian a karnero, ken masapul nga ipatay ni Aaron ken dagiti annakna a lallaki ti imada iti ulona daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Masapul a papatayem ti kalakian a karnero. Kalpasanna, alaem ti darana ket ibuyatmo iti tunggal sikigan ti altar ken iti rabawna. ");
INSERT INTO iloulb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Masapul nga iwa-waem ti kalakian a karnero iti pidapidaso ket buggoam dagiti lalaem ken dagiti sakana, ken masapul nga ikabilmo dagiti lalaem agraman dagiti naranggrangkay a pidaso ken ti ulona, ");
INSERT INTO iloulb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","iti rabaw ti altar. Kalpasanna, puoram ti sibubukel a kalakian a karnero. Daytoy ket daton a maipuor amin a para kaniak, ni Yahweh. Mangipaay daytoy iti nabanglo nga ayamuom kaniak; daytoy ti daton a maipuor para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Masapul nga alaem ti sabali pay a kalakian a karnero, ken masapul nga ipatay ni Aaron ken dagiti annakna a lallaki ti imada iti ulona daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ket masapul a papatayem ti kalakian a karnero ken mangala iti bassit a darana. Ipulagidmo daytoy kadagiti piditpidit iti makannawan a lapayag ni Aaron ken kadagiti piditpidit ti makannawan a lapayag dagiti annakna lallaki, iti makannawan a tangan dagiti ima ken sakada. Kalpasanna, masapul nga ibuyatmo ti dara iti tunggal sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Masapul a, angalaka iti bassit a dara nga adda iti altar ken bassit a lana a pangkonsagrar, ket iwarsim amin dagitoy kenni Aaron ken iti pagan-anayna, ken kasta met kadagiti annakna a lallaki ken kadagiti pagan-anayda. Mailasinto ni Aaron ken dagiti annakna a lallaki para kaniak, agraman dagiti pagan-anayda. ");
INSERT INTO iloulb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Alaem ti taba ti kalakian a karnero, ti nataba nga ipus, ti taba a nangbalkot kadagiti lalaem, ti nangbalkot iti dalem, ti dua a bekkel ken ti tabana, ken ti makannawan a luppo—ta daytoy a karnero ket para iti pannakakonsagrar dagiti padi kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Mangalaka iti maysa nga iwa ti tinapay, maysa a bibingka nga adda lanana, ken maysa nga ostia manipud iti basket ti tinapay nga awan lebadurana a maidatag iti sangoanak, ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Masapul nga ipaiggemmo dagitoy kenni Aaron ken kadagiti annakna a lallaki. Masapul nga itag-ayda dagitoy kaniak, ni Yahweh, ken idatagda dagitoy kas daton kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kalpasanna, alaem ti makan manipud kadagiti imada ket puoram daytoy iti rabaw ti altar a kadua ti daton a maipuor amin. Mangipaay daytoy iti nabanglo nga ayamuom kaniak; daytoy ti daton a maipuor a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Masapul nga alaem ti barukong ti kalakian a karnero a daton para iti pannakakonsagrar ni Aaron ket itag-aymo ken idatagmo daytoy a kas daton para kaniak, ni Yahweh. Ket daytoy iti paset a mabalinmo a kanen. ");
INSERT INTO iloulb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Masapul nga idatonmo kaniak ti barukong a daton a naitag-ay ken ti luppo a daton a naidatag—ti barukong a naitag-ay ken ti luppo a naidatag, agpapada a naggapu iti kalakian a karnero para iti pannakapatalged ni Aaron ken dagiti annakna a lallaki kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Dagitoy a paset ti karne, nga inted dagiti Israelita, masapul nga agnanayon a maipaay kenni Aaron ken kadagiti kaputotanna. Babaen kadagiti annuroten para kadagiti daton para iti panagkakadua, dagitoy ket daton para kadagiti padi a naggapu kadagiti daton dagiti Israelita a naidatag kaniak, ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ti nasantoan a pagan-anay ni Aaron ket masapul met a maisagana para kadagiti annakna a lallaki a sumaruno kenkuana kas padi. Masapul a mapulotanda a naikawes dagitoy ken ordinaram ida kaniak a naikawes dagitoy kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ti sumaruno a padi kenkuana manipud kadagiti annakna a lallaki, a mapan iti tabernakulo tapno agserbi kaniak idiay nasantoan a disso, ket masapul nga isuotna dagidiay a pagan-anay iti las-ud iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Masapul nga alaem ti kalakian a karnero para iti pannakakonsagrar dagiti padi kaniak ken angrem ti karnena iti nasantoan a lugar. ");
INSERT INTO iloulb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Masapul a kanen ni Aaron ken dagiti annakna a lallaki ti karne ti karnero ken ti tinapay nga adda iti basket iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Masapul a kanenda ti karne ken ti tinapay a naited a mangdalus kadakuada ken tapno maordenaranda, a maidaton kaniak. Awan ti sabali a mabalin a mangan iti dayta a makan, gapu ta ibilangda daytoy a nakonsagraran kaniak, naisagana a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ti aniaman a karne a naordinaran a daton, wenno aniaman a tinapay a matda iti sumaruno nga aldaw ket masapul a puoram. Saan a mabalin a kanen gapu ta naidaton daytoy kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Iti kastoy a wagas, taripatoem ni Aaron ken dagiti annakna a lallaki babaen ti panangtungpalmo iti amin nga imbilinko kenka nga aramidem. Masapul nga idatonmo ida kaniak iti uneg ti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Masapul a mangisagutka iti maysa a kalakian a baka iti inaldaw kas daton gapu iti basol para iti pannakapakawan. Masapul a dalusam ti altar babaen iti seremonia a mangdalus iti daytoy, ken masapul a pulotam daytoy tapno maidaton kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Masapul nga aramidem ti seremonia a mangdalus ti altar iti uneg ti pito nga aldaw ken idatonmo daytoy kenni Yahweh. Kalpasanna, naan-anayto ti pannakaidaton ti altar kaniak. Aniaman a mangsagid ti altar ket mailasin para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Masapul a kanayon a mangidatonka iti rabaw ti altar iti inaldaw iti dua a karnero nga agtawen iti maysa. ");
INSERT INTO iloulb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Idatonmo ti maysa iti bigat, ken ti maysa iti sumipnget. ");
INSERT INTO iloulb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kadua ti umuna a karnero, idatonmo ti apagkapullo ti maysa nga efa a kasayaatan nga arina a nalaokan iti kakapat a paset ti maysa a hin a lana manipud iti napespes nga olibo, ken kakapat ti maysa a hin nga arak kas daton a mainom. ");
INSERT INTO iloulb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Idatonmo ti maikadua a karnero iti sumipnget. Masapul nga idatonmo ti isu met laeng a bukel a daton kas iti bigbigat, ken ti daton nga arak. Makaipaay dagitoy iti nabanglo nga ayamuom kaninak; daytoy ti daton a maipuor a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Masapul a dagitoy ket kanayon a maidaton a kas daton a maipuor iti amin a kaputotan dagiti tattaom. masapul nga aramidem dagitoy iti pagserkan ti tabernakulo iti sangoanak, ni Yahweh, ti pakisinnarakakto a makisarita kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Dita ti pangsarakak kadagiti Israelita; ti tolda ket mailasin nga agpaay kaniak babaen iti dayagko. ");
INSERT INTO iloulb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Idatonko ti tabernakulo ken ti altar ta dagitoy ket agpaay laeng kaniak. Idatonkonto pay ni Aaron ken dagiti annakna a lallaki tapno agserbida kaniak a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Agnaedakto kadagiti Israelita ken siakto ti Diosda. ");
INSERT INTO iloulb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Maammoandanto a siak ni Yahweh, a Diosda, a nangiruar kadakuada manipud iti daga ti Egipto tapno makapagnaedakto kadakuada. Siak ni Yahweh a Diosda. ");
INSERT INTO iloulb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Masapul a mangaramidkayo iti altar a pagpuoran ti insenso. Masapul nga aramidenyo daytoy manipud iti kayo ti akasia. ");
INSERT INTO iloulb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Masapul a maysa a cubico ti kaatiddog ken kaakabana. Masapul a kuadrado daytoy, ken dua a cubico ti kangatona. Dagiti sarana ket masapul a naisilpo a kapaset iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Masapul a kalupkopam ti altar ti insenso iti puro a balitok—ti ngatona, dagiti sikiganna ken dagiti sarana. Masapul nga iyaramidam iti iking a balitok ti aglikmotna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Masapul a mangaramidka iti dua a balitok a singsing a maikapet iti daytoy nga iti sirok ti ikingna iti dua nga agsumbangir a sikiganna. Dagiti singsing ket isu iti mangtengngel kadagiti assiw tapno maaawit ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Aramidem dagiti assiw manipud iti kayo ti akasia ken masapul a kalupkopam dagitoy iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Masapul nga ikabilmo ti altar ti insenso iti sangoanan ti kurtina nga ayan iti Lakasa ti Tulag. Maikabil daytoy iti sangoanan ti kalub a mangipakita iti pannakakalub ti basol nakaparabaw iti Lakasa ti Tulag, a pakisinnarakakto kenka. ");
INSERT INTO iloulb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Masapul a mangpuor ni Aaron iti nabanglo nga insenso iti binigat. Masapul a puoranna daytoy inton estimarenna dagiti pagsilawan. ");
INSERT INTO iloulb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Inton sindian manen ni Aaron dagiti pagsilawan iti rabii, masapul a mangpuor isuna iti insenso iti altar ti insenso. Masapul a kanayon ti panangpuor iti insenso iti sangoanak, ni Yahweh, iti amin a kaputotan dagiti tattaom. ");
INSERT INTO iloulb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ngem masapul a saankayo nga agidaton iti dadduma nga insenso iti altar ti insenso uray ania a daton a maipuor amin wenno daton a bukbukel. Saanyo a bukbokan daytoy iti daton a mainom. ");
INSERT INTO iloulb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Masapul a mangisayangkat ni Aaron ti seremonia iti pannakadalus kadagiti sara ti altar ti insenso iti maminsan iti makatawen. Aramidenna daytoy babaen iti dara a daton a mangabbong iti basol. Masapul nga aramiden daytoy iti kangatoan a padi iti amin a kaputotan dagiti tattaom. Daytoy a sagot ket naan-nayto ti pannakaidatonna kaniak, ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nagsao ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Inton alaem ti sensus dagiti Israelita, masapul a tunggal tao ket mangted iti pangsubbotda ti biagda kenni Yahweh. Masapul nga aramidem daytoy kalpasan a mabilangmo ida, tapno awan ti didigra kadakuada no bilangem ida. ");
INSERT INTO iloulb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tunggal maysa a naibilang iti sensus ket masapul nga agbayad iti kagudua a siklo ti pirak, sigun ti timbangan iti siklo iti santuario (ti maysa siklo ket aggatad iti duapulo a gera). Daytoy kagudua a siklo ket daton nga agpaayto kaniak, ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tunggal maysa a naibilang, manipud kadagiti agtawen iti duapulo agpangato, masapul nga itedda daytoy a daton nga agpaay kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Inton ited kaniak dagiti tattao dagitoy a daton a mangsubbot kadagiti biagda, dagiti nabaknang ket masapul a saan a mangited iti nasursurok ngem kagudua a siklo, ken ti nakurapay ket masapul a saan a mangited iti basbassit. ");
INSERT INTO iloulb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Masapul nga awatem dagitoy a pangsubbot a kuarta manipud kadagiti Israelita ket masapul nga bingayem daytoy para iti trabaho nga agpaay iti tabernakulo. Mangpalagip daytoy kadagiti Israelita iti sangoanak, a mangsubbot iti biagyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nagsao ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Masapul pay a mangaramidkayo iti dakkel a bronse a palanggana a pagbuggoan nga adda pagbatayanna a bronse. Masapul nga ikabilmo ti palanggana iti nagbaetan ti tabernakulo ken ti altar, ken kargaam daytoy iti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Masapul a buggoan ni Aaron ken dagiti annakna a lallaki dagiti ima ken sakada babaen iti danum nga adda iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Inton umunegda iti tabernakulo wenno inton umasidegda iti altar nga agserbi kaniak babaen iti panagpuorda iti daton, masapul nga agbuggoda tapno saanda a matay. ");
INSERT INTO iloulb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Masapul a buguanda dagiti ima ken sakada tapno saanda a matay. Agnanayonto daytoy a linteg para kenni Aaron ken kadagiti kaputotanna iti amin a henerasion dagiti tattaoda.” ");
INSERT INTO iloulb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nagsao ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Alaem dagitoy nasasayaat a rekado: limagasut a siklo a tubbog ti mirra, 250 a siklo a nabanglo a sinamon, 250 a siklo a nabanglo nga unas, ");
INSERT INTO iloulb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","limagasut a siklo ti kasia, a narukod segun ti pagtimbangan iti siklo ti santuario, ken maysa a hin iti lana nga olibo. ");
INSERT INTO iloulb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Masapul a mangaramidka iti sagrado a lana a pangkonsagrar babaen kadagitoy a rekado, a trabahoen iti maysa nga agar-aramid iti bangbanglo. Daytoy ti sagrado a lana a pangkonsagrar a naisagana para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Masapul a pulotam ti tabernakulo iti daytoy a lana, kasta met ti Lakasa ti Tulag, ");
INSERT INTO iloulb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ti lamisaan ken amin nga alikamenna, ti kandelero ken ti alikamenna, ti altar ti insenso, ");
INSERT INTO iloulb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ti altar para kadagiti daton a mapuoran ken amin nga alikamenna, ken ti palanggana agraman ti pagbatayanna. ");
INSERT INTO iloulb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Masapul nga idatonmo dagitoy kaniak tapno naan-anay ti pannakaisagutda kaniak. Aniaman a mangsagid kadagitoy ket mailasin met a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Masapul a pulotam ni Aaron ken dagiti annakna a lallaki ken idatonmo ida kaniak tapno makapagserbida kaniak a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ibagam kadagiti Israelita, 'Daytoy ti lana a pangkonsagrar a naidaton kenni Yahwen iti amin a kaputotan dagiti tattaom. ");
INSERT INTO iloulb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Saan a rumbeng a maisapsapo daytoy iti kudil dagiti tattao, wenno agaramid iti kas iti daytoy a lana gapu ta nakonsagraran daytoy nga agpaay kenni Yahweh. Masapul nga ibilangyo daytoy iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Siasinoman nga agaramid iti kas iti daytoy a bangbanglo, wenno siasinoman a mangisapsapo daytoy iti maysa a tao, dayta a tao ket masapul a maisina manipud kadagiti tattaona.”' ");
INSERT INTO iloulb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kinuna ni Yahweh kenni Moises, “Mangalaka kadagiti rekado—estakte, onitsa, ken galbanum—dagiti nabanglo a rekado a nailaok iti puro nga insenso, nga agpapada ti kaaduna. ");
INSERT INTO iloulb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Aramidem daytoy a kas iti insenso, a pinaglalaok ti agar-aramid iti bangbanglo, natimplaan iti asin, puro ken naidaton nga agpaay kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Gilingem daytoy inggana a pumino. Ikabilmo ti daddumana daytoy iti sangoanan iti Lakasa ti Tulag, nga adda iti tabernakulo, a pakisarakakto kadakayo. Ibilangyo daytoy kas maysa a naan-anay a naidaton nga agpaay kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Para iti daytoy nga insenso nga aramidenyo, masapul a di kayo agaramid iti aniaman a kapadpadana para kadagiti bagbagiyo. Masapul nga ibilangyo a nasagradoan unay daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Siasinoman a mangaramid iti kas iti daytoy a maaramat a kas bangbanglo ket masapul a maisina manipud kadagiti tattaona.” ");
INSERT INTO iloulb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nagsao ni Yahwen kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Kitaem, inayabak babaen iti naganna ni Bezalel, ti anak a lalaki ni Uri, nga anak ni Hur manipud iti tribu ti Juda. ");
INSERT INTO iloulb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Pinunnok ni Bezalel iti espirituk tapno maikkan isuna iti kinasirib, pannakaawat, ken pannakaammo, para iti amin a kita ti batido a panagdesenio, ");
INSERT INTO iloulb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","a mangkorte iti balitok, pirak, ken bronse; ");
INSERT INTO iloulb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kasta met a mangtabas ken mangurnos kadagiti batbato ken mangkitikit iti kayo—a mangaramid kadagiti amin a kita iti batido a panagdesenio. ");
INSERT INTO iloulb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mainayon a kaduana, dinutokak ni Oholiab nga anak a lalaki ni Ahisamac, manipud iti tribu ti Dan. Inikkak iti kabaelan dagiti puso ti amin a masirib tapno maaramidda amin nga imbilinko kenka. Karaman ditoy ");
INSERT INTO iloulb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ti tabernakulo, ti Lakasa ti Tulag ken ti kalub a mangipakita iti pannakakalub ti basol a nakaparabaw iti Lakasa, ken amin nga alikamen ti tolda— ");
INSERT INTO iloulb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ti lamisaan ken dagiti alikamenna, ti puro a kandelero ken dagiti alikamenna, ti altar ti insenso, ");
INSERT INTO iloulb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ti altar para kadagiti daton a maipuor amin ken dagiti amin nga alikamenna, ken ti dakkel a palanggana ken ti batayna. ");
INSERT INTO iloulb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Mainayon pay ditoy dagiti pagan-anay a nasayaat ti pannakabelna—dagiti sagrado a pagan-anay a para kenni Aaron a padi ken kadagiti annakna a lallaki, isaganam para kaniak tapno agserbida a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Mainayon pay ditoy ti lana a pangkonsagrar ken ti nabanglo nga insenso a para iti nasantoan a disso. Masapul nga aramiden dagitoy a lallaki a batido a dumidesenio dagitoy amin a banbanag kas imbilinko kenka.” ");
INSERT INTO iloulb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Nagsao ni Yahweh kenni Moises: ");
INSERT INTO iloulb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ibagam kadagiti Israelita: “Masapul a ngilinenyo ti Aldaw a Panaginana ni Yahweh, ta daytoyto ti pagilasinan iti nagbaetanyo kenni Yahweh iti amin a kaputotan dagiti tattaom tapno maammoanyo nga isuna ni Yahweh, ti nangilasin kadakayo nga agpaay kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Isu a masapul a ngilinenyo ti Aldaw a Panaginana, ta masapul nga ibilangyo daytoy a nasantoan, a naisagana a para kenkuana. Ti siasinoman a mangtulaw iti daytoy ket rumbeng a mapapatay. Ti siasinoman nga agtrabaho iti Aldaw a Panaginana, dayta a tao ket sigurado a maisina manipud kadagiti amin a tattaona. ");
INSERT INTO iloulb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ti panagtrabaho ket maaramid iti uneg ti innem nga aldaw, ngem iti maikapito nga aldaw ket isu ti Aldaw a Panaginana, nasantoan ken naisagana a para iti pannakaidayaw ni Yahweh. Ti siasinoman nga agtrabaho iti uray ania iti Aldaw a Panaginana ket rumbeng a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Masapul ngarud a salimetmetan dagiti Israelita ti Aldaw a Panaginana. Masapul a ngilinenda daytoy iti amin a kaputotan dagiti tattaoda a kas maysa nga agnanayon a linteg. ");
INSERT INTO iloulb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ti Aldaw ti Panaginana ket agnanayon a pagilasinan iti nagbaetan ni Yahweh ken dagiti Isarelita, ta iti innem nga aldaw inaramid ni Yahweh ti langit ken daga, ken iti maikapito nga aldaw naginana isuna ken nabang-aran.”' ");
INSERT INTO iloulb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kalpasan a nakisarita ti Dios kenni Moises idiay Bantay Sinai, intedna kenkuana ti dua a tapi a bato- ti sangapulo a bilin, naaramid babaen iti bato nga insurat iti mismo nga imana. ");
INSERT INTO iloulb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Idi nakita dagiti tattao a nabayagan ni Moises iti isasalogna manipud iti bantay, nagu-ummongda iti aglawlaw ni Aaron ket kinunada kenkuana, “Umayka, mangaramidka iti maysa a didiosen a mangidaulo kadakami. Ta daytoy a Moises, ti lalaki a nangirruar kadakami manipud iti daga ti Egipto, saanmi nga ammo ti napasamak kenkuana.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Isu a kinuna ni Aaron kadakuada, “Ikkatenyo dagiti singsing a balitok nga adda kadagiti lapayag dagiti assawayo a babbai, annakyo a lallaki ken dagiti annakyo a babbai ket iyegyo dagitoy kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Inikkat dagiti amin a tattao dagiti singsing a balitok nga adda kadagiti lapayagda ket impanda dagitoy kenni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Inawatna dagiti balitok manipud kadakuada, ket hinormana daytoy iti paghormaan ket pinormana daytoy a sinan-baka. Kalpasanna, kinuna dagiti tattao, “Israel, daytoy ti diosyo a nangirruar kadakayo iti daga ti Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Idi nakita ni Aaron daytoy, nangaramid isuna iti maysa nga altar iti sangoanan ti sinan-baka ket inwaragawagna; kinunana, “Inton bigat ket maysa a piesta a panagdayaw kenni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nasapa a bimmangon dagiti tattao iti kinabigatanna ket nangisagutda kadagiti daton a mapuoran ken nangiyegda kadagiti daton iti panagkakadua. Kalpasanna, nagtugawda tapno mangan ken uminom ket kalpasanna timmakderda tapno agbabartekda iti nalabes a panagrambak. ");
INSERT INTO iloulb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ket nagsao ni Yahweh kenni Moises, “Mapanka a dagus ta dagiti tattaom, nga indauloam nga inruar iti daga ti Egipto ket dinadaelda dagiti bagbagida. ");
INSERT INTO iloulb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Pinanawanda a dagus ti dalan nga imbilinko kadakuada. Nangpormada para iti bagida iti sinan-baka ket nagrukbab ken nangidatonda iti daytoy. Kinunada, 'Israel, daytoy ti diosyo a nangiruar kadakayo manipud iti daga ti Egipto.'” ");
INSERT INTO iloulb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ket kinuna ni Yahweh kenni Moises, “Nakitakon dagitoy a tattao. Kitaem, natangken ti uloda a tattao. ");
INSERT INTO iloulb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ita ngarud, saannak a lapdan. Gumilgil-ayab ti pungtotko kadakuada isu a dadaelek ida. Ket mangaramidak iti dakkel a nasion manipud kenka.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ngem dinawat ni Moises kenni Yahweh a Diosna a saan nga agpungtot. Kinunana, “Yahweh, apay a bumara ti pungtotmo kadagiti tattaom nga inruarmo manipud iti daga ti Egipto nga addaan iti naindaklan a pannakabalin ken nabileg nga ima? ");
INSERT INTO iloulb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Apay a nasken nga ibaga dagiti Egipcio, 'Indalanna ida a rimuar manipud iti Egipto nga addaan iti dakes a panggep, tapno papatayenna ida iti kabanbantayan ken tapno dadaelenna ida iti rabaw ti daga?' Ibaw-ingmo ti gumilgil-ayab a pungtotmo ket ibabawim ti panangdusam kadagiti tattaom. ");
INSERT INTO iloulb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Lagipem dagiti adipenmo nga Abraham, Isaac ken ni Israel, a mismo a nagikariam ken kinunam kadakuada, “Paadduekto dagiti kaputotanyo a kas kaadu dagiti bituen idiay langit, ken itedkonto kadagiti kaputotanyo amin daytoy a daga nga imbagak. Tawidendanto daytoy iti agnanayon.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ket imbabawi ni Yahweh ti kinunana a pannusa nga ipalak-amna kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kalpasanna, timmallikod ni Moises ket simmalog manipud iti bantay nga awit-awitna ti dua a tapi a bato nga ayan dagiti tulag. Agsinnumbangir a nasuratan dagiti tapi a bato, iti sangoanan ken iti likudan. ");
INSERT INTO iloulb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mismo a ti Dios ti nangaramid kadagiti tapi a bato, ken dagiti suratna ket mismo a ti Dios ti nangisurat iti naikitikit kadagiti tapi a bato. ");
INSERT INTO iloulb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Idi nangngeg ni Josue ti ariwawa dagiti tattao nga agpupukkaw, kinunana kenni Moises, “Adda ti ariwawa ti aggugubat iti kampo.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ngem kinuna ni Moises, “Saan nga ariwawa iti panagballigi, ken saan met nga ariwawa ti naabak a tattao ngem ti timek ti agkakanta ti mangngegko.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Idi asidegen ni Moises iti kampo, nakitana ti sinan-baka ken dagiti agsasala a tattao. Nakapungtot isuna iti kasta unay. Imbarsakna dagiti tapi a bato ken binurakburakna dagitoy iti sakaanan ti bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Innalana ti sinan-baka nga inaramid dagiti tattao, pinuoranna ken binurakburakna agingga a nagbalin daytoy a pulbos ket imbukbokna daytoy iti danum. Ket impainumna daytoy kadagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kalpasanna, kinuna ni Moises kenni Aaron, “Ania ti inaramid dagitoy a tattao kenka, a nangiyegka iti kasta kadakkel a basol kadakuada?” ");
INSERT INTO iloulb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kinuna ni Aaron, “Saanka koma nga agpungtot iti kasta unay, apok. Am-ammom dagitoy a tattao, no kasanoda a nairuam nga agaramid iti kinadakes. ");
INSERT INTO iloulb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Kinunada kaniak, ''Iyaramidannakami iti dios a mangidaulo kadakami. Maipanggep iti daytoy a Moises, ti tao a nangidaulo kadakami a rimmuar manipud iti daga ti Egipto, saanmi nga ammo ti napasamak kenkuana.' ");
INSERT INTO iloulb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Isu a kinunak kadakuada, 'Siasinoman nga addaan iti aniaman a balitok, ikkatenna koma daytoy. Intedda kaniak dagiti balitok ket impuruakko iti apuy ket nagbanag a sinan-baka.'” ");
INSERT INTO iloulb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Nakita ni Moises nga agkakaribuso dagiti tattao, ta binay-an ida ni Aaron nga aglablabes, tapno laisen ida dagiti kabusorda. ");
INSERT INTO iloulb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kalpasanna, nagtakder ni Moises iti pagserkan ti kampo ket kinunana, “Siasinoman nga agtulnog kenni Yahweh, umay kaniak.” Nagummong dagiti amin a Levita iti aglawlawna. ");
INSERT INTO iloulb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kinunana kadakuada, “Ni Yahweh a Dios ti Israel, imbagana daytoy, 'Ikabil koma ti tunggal maysa dagiti kampilan iti sikiganda ket mapan ken agsubli iti tunggal pagserkan iti entero a kampo ket papatayenna ti kabsatna, ti kaduana ken ti kaarrubana.'” ");
INSERT INTO iloulb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Inaramid dagiti Levita ti imbilin ni Moises. Agarup tallo ribu a lallaki manipud kadagiti tattao ti natay iti dayta nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kinuna ni Moises kadagiti Levita, “Ita nga aldaw, naisaadkayon nga agserbi kenni Yahweh, ta tunggal maysa kadakayo ket binusorna ti kabsatna, isu nga inikkannakayo ni Yahweh iti bendision ita nga aldaw.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Iti simmaruno nga aldaw kinuna ni Moises kadagiti tattao, “Nakaaramidkayo iti dakkel unay a basol. Ita sumang-atak kenni Yahweh. Nalabit a mabalin a mangaramidak iti pakapakawanan dagiti basolyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nagsubli ngarud ni Moises kenni Yahweh ket kinunana, “Nakaaramid dagitoy a tattao iti dakkel a basol ken nangaramidda iti didiosen a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ngem ita, pangngaasim ta pakawanem dagiti basolda; ngem no saan, ikkatennak iti libro nga insuratmo.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Kinuna ni Yahweh kenni Moises, “Siasinoman a nakabasol kaniak, dayta a tao ti ikkatek iti librok. ");
INSERT INTO iloulb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Isu nga ita, mapanka ket idauloam dagiti tattao iti lugar nga imbagak kenka. Kitaem, umun-unanto kenka ti anghelko. Ngem iti aldaw a dusaek ida, dusaekto ida gapu iti basolda.” ");
INSERT INTO iloulb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ket nangibaon ni Yahweh iti didigra kadagiti tattao gapu ta nangaramidda iti sinan-baka, ti inaramid ni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nakisao ni Yahweh kenni Moises, “Pumanawkayo manipud ditoy, sika ken dagiti tattao nga inruarmo manipud iti daga ti Egipto. Mapankayo iti daga nga inkarik kada Abraham, Isaac ken Jacob, idi kinunak, 'Itedkonto daytoy kadagiti kaputotanyo.' ");
INSERT INTO iloulb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mangibaonakto iti anghel iti sangoanam, ket papanawekto dagiti Cananeo, Amoreo, Heteo, Perezeo, Heveo ken dagiti Jebuseo. ");
INSERT INTO iloulb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mapankayo iti dayta a daga nga aglaplapusanan iti gatas ken diro, ngem saanak a kumuyog kadakayo, gapu ta natangken ti uloyo a tattao. Amangan no dadaelenkayo iti dalan.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Idi nangngeg dagiti tattao dagitoy a makariribuk a sasao, nagleddaangda ket awan ti uray maysa a nangisuot iti aniaman nga alahas. ");
INSERT INTO iloulb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kinuna ni Yahweh kenni Moises, “Ibagam kadagiti Israelita, 'Natangken ti uloyo a tattao. No makikuyogak kadakayo uray iti apagbiit laeng a kanito, dadaelenkayo. Isu nga ita, ikkatenyo dagiti alahasyo tapno makapangngeddengak iti aramidek kadakayo.'” ");
INSERT INTO iloulb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Isu a manipud iti Bantay Horeb nagtultuloy nga awan alahas a suot dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nangala ni Moises iti tolda ket impatakderna daytoy iti ruar ti kampo, nga adayo bassit manipud iti kampo. Inawaganna daytoy iti tolda a pakiumanan. Tunggal maysa nga agkiddaw iti aniaman a banag kenni Yahweh ket rumuar iti kampo a sumrek iti tolda a pakiumanan nga adda iti ruar ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Apaman a rumuar ni Moises a mapan iti tolda, tumakder amin dagiti tattao iti pagserkan dagiti kampoda ket kitaenda ni Moises agingga a makauneg isuna. ");
INSERT INTO iloulb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ket inton makastreken ni Moises iti tolda, bumaba ti adigi nga ulep ket agtalinaed iti pagserkan ti tolda, ket makisaonton ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tunggal makita dagiti amin a tattao ti adigi nga ulep nga agtakder iti pagserkan ti tolda, tumakderda ket agrukbabda, tunggal tao iti pagserkan ti toldana. ");
INSERT INTO iloulb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Makisao ni Yahweh iti rupan-rupa kenni Moises, a kas iti pannakisao ti maysa a tao iti gayyemna. Ket agsublinto metten ni Moises iti kampo, ngem ti agtutubo a lalaki nga adipenna nga anak ni Nun a ni Josue ket agtalinaed iti ayan ti tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kinuna ni Moises kenni Yahweh, “Kitaem, ibagbagam kaniak, 'Idauloam dagitoy a tattao iti panagdaliasatda,' ngem saanmo pay nga imbaga kaniak no asino ti ibaonmo a kaduak. Kinunam, 'Am-ammoka babaen iti naganmo ken nasarakam pay ti pabor iti imatangko.' ");
INSERT INTO iloulb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ita no nasarakak iti pabor iti imatangmo, ipakitam kaniak dagiti wagasmo tapno maam-ammoka iti kasta agtultuloy a masarakak ti pabor iti imatangmo. Laglagipem a daytoy a nasion ket tattaom.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Simmungbat ni Yahweh, “Kumuyogto kenka ti presensiak, ket ikkankanto iti inana.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kinuna ni Moises kenkuana, “No saanka a kumuyog ti presensiam kadakami, saannakami nga iyadayo manipud ditoy.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ta no saan, kasanonto a maammoan a nakasarakak iti pabor iti imatangmo, siak ken dagiti tattaom? Saan kadi nga iti laeng pannakikuyogmo kadakami ti pakaammoan a siak ken dagiti tattaom ket agbalin a naidumduma manipud kadagiti amin a tattao nga adda iti rabaw ti daga?” ");
INSERT INTO iloulb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kinuna ni Yahweh kenni Moises, “Aramidek met daytoy a banag a kiniddawmo, ta nasarakam ti pabor iti imatangko ket am-ammoka babaen iti naganmo.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kinuna ni Moises, “Pangngaasim, ipakitam kaniak ti dayagmo.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kinuna ni Yahweh, “Aramidekto amin a kinaimbagko iti sangoanam, ket iwaragawagkonto ti naganko a 'Yahweh' iti sangoanam. Managparaburakto kadagiti paraburak ken kaasiakto dagiti kaasiak.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ngem kinuna ni Yahweh, “Saanmo a mabalin a kitaen ti rupak, ta awan ti nakakita kaniak ket nagbiag.” ");
INSERT INTO iloulb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kinuna ni Yahweh, “Kitaem, adtoy ti lugar nga asideg kaniak; agtakderkanto iti daytoy a dakkel a bato. ");
INSERT INTO iloulb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kabayatan a lumablabas ti dayagko, ikabilkanto iti rengngat ti bato ket akkobankanto babaen iti imak agingga a makalabasak. ");
INSERT INTO iloulb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kalpasanna, ikkatekto ti imak ket makitamto ti likudak ngem saanto a makita ti rupak.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kinuna ni Yahweh kenni Moises, “Mangtabaska iti dua a tapi a bato a kas kadagiti immuna. Isuratkonto kadagitoy a tapi a bato dagiti sao nga adda kadagiti immuna a tapi a bato a binurakmo. ");
INSERT INTO iloulb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Agsaganaka inton bigat ket sumang-atka iti Bantay Sinai ket iparangmo ti bagim kaniak iti tuktok ti bantay. ");
INSERT INTO iloulb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Awan ti siasinoman a kumuyog kenka a sumang-at. Saanmo nga ipalubos nga adda ti siasinoman a makita iti sadinoman a paset ti bantay. Awan uray arban ti ayup wenno pangen nga agarab iti sango ti bantay.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nangtabas ngarud ni Moises iti dua a tapi a bato kas iti immuna, ket nasapa a bimmangon iti kabigatanna ket simmang-at isuna iti Bantay Sinai, a kas imbilin ni Yahweh kenkuana. Inawit ni Moises ti dua a tapi a bato. ");
INSERT INTO iloulb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Bimmaba ni Yahweh iti ulep ket nakipagtakder kenni Moises sadiay, ket imabalikasna ti nagan a “Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Limmabas ni Yahweh iti sangonanna ket inwaragawagna, “Yahweh, Yahweh, ti Dios a manangngaasi ken managparabur, saan a nalaka nga agpungtot, ken saan a marukod ti kinapudnona ken kinamapagtalkanna iti tulag, ");
INSERT INTO iloulb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","mangpatpatalinaed iti kinapudno ti tulag iti rinibribu a kaputotan, mangpakpakawan iti kinadakes, panagsalungasing, ken basbasol. Ngem iti uray ania a wagas saanna a kanunongan ti nagbiddut. Iyegnanto ti pannusa ti basol dagiti amma kadagiti annakda ken kadagiti annak ti annakda agingga kadagiti iti maikatlo ken maikapat a kaputotan.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Dagdagus nga indumog ni Moises ti ulona iti daga ket nagrukbab. ");
INSERT INTO iloulb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ket kinunana, “No ita ket nakasarakak ti pabor iti imatangmo, Apok, pangngaasim ta kumuyogka kadakami, ta natangken ti ulo dagitoy a tattao. Pakawanem ti kinadakesmi ken ti basolmi, ket alaennakami akas tawidmo.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kinuna ni Yahweh, “Kitaem, mangaramidakon iti tulag. Iti sangoanan dagiti amin a tattaom, mangaramidak kadagiti nakaskasdaaw a kas kadagiti saan pay a naimatangan iti entero a daga wenno iti sadinoman a nasion. Amin a tattao kadakayo ket makitadanto dagiti aramidek, ta nakabutbuteng daytoy a banag nga aramidek kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tungpalenyo ti ibilinko kadakayo ita nga aldaw. Dandanikon papanawen iti sangoananyo dagiti Amoreo, Cananeo, Heteo, Perezeo, Heveo ken dagiti Jebuseo. ");
INSERT INTO iloulb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Agannadkayo a saankayo a makitulag kadagiti agnanaed iti daga a papananyo, ta no saan agbalindanto a palab-og kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ngem ketdi, masapul a ribbaenyo dagiti altarda, rumekenyo dagiti nasagradoan a bato nga adigida, ken putdenyo dagiti poste ti Aserada. ");
INSERT INTO iloulb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ta masapul nga awan ti sabali a dios a pagrukbabanyo, ta siak ni Yahweh a ti naganna ket 'Naimun,' naimunak a Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Agannadkayo a saankayo a makitulag kadagiti agnanaed iti daga, tunggal makimalalada kadagiti diosda ken mangidatonda kadagiti diosda, ken awisennakayo ti maysa a tao ken mangan iti indatonna. ");
INSERT INTO iloulb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Mangalakayo pay kadagiti annakda a babbai para kadagiti annakyo a lallaki, ken makikamalala dagiti annakda a babbai iti diosda, ket allukoyenda dagiti annakyo a lallaki a makikamalala iti diosda. ");
INSERT INTO iloulb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Saankayo a mangaramid kadagiti diosyo manipud iti nairunaw a landok. ");
INSERT INTO iloulb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Masapul a salimetmetanyo ti Fiesta iti Tinapay nga awan Lebadurana. Kas imbilinko kadakayo, masapul a mangankayo iti tinapay nga awan lebadurana iti uneg ti pito nga aldaw iti naituding a tiempo iti bulan iti Abib, ta iti bulan ti Abib a rimmuarkayo manipud iti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Kukuak amin nga inauna nga anak, uray ti tunggal inauna a kalakian nga anak ti bakayo, agpada a bakbaka ken karnero. ");
INSERT INTO iloulb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Masapul a subbotenyo dagiti inauna nga anak ti asno babaen iti maysa a kordero, ngem no saanyo a subboten daytoy, ket masapul a rung-oenyo ti tengngedna daytoy. Masapul a subbotenyo amin nga inauna nga anak kadagiti annakyo a lallaki. Awan ti siasinoman a mabalin nga agparang kaniak nga ima-ima. ");
INSERT INTO iloulb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Mabalinyo ti agtrabaho iti innem nga aldaw, ngem iti maikapito nga aldaw ket masapul nga aginanakayo. Uray iti tiempo ti panagarado ken iti panagapit, masapul nga aginanakayo. ");
INSERT INTO iloulb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Masapul a ngilinenyo ti Fiesta dagiti Lawas iti umuna a bunga dagiti maapit a trigo, ken masapul a ngilinenyo ti Fiesta iti Panagapit iti panaggibus ti tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Masapul a mamitlo a daras iti tunggal tawen nga agparang amin a lallaki kaniak, ni Yahweh, ti Dios ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ta papanawekto dagiti nasion iti sangoananyo ken palawaek dagiti nagbeddenganyo. Awanto ti siasinoman a mangtarigagay a mangserrek iti dagayo ken mangala iti daytoy inton sumang-atkayo nga agparang kaniak, ni Yahweh a Diosyo, iti mamitlo a daras iti tunggal tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Masapul a saanyo a pakuyogan iti tinapay nga adda lebadurana ti dara a maidaton kaniak, wenno adda matda a karne agingga iti kabigatanna manipud iti naidaton iti Fiesta ti Ilalabas. ");
INSERT INTO iloulb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Masapul nga iyegyo iti balayko ti kasasayaatan kadagiti umuna a bunga manipud iti taltalonyo. Masapul a saanyo a lutoen ti urbon a kalding iti gatas ti inana.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kinuna ni Yahweh kenni Moises, “Isuratmo dagitoy a sasao, ta ikarik iti bagik kadagitoy a naisaokon ken nakitulagakon kenka ken iti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Nakipagtalinaed ni Moises kenni Yahweh sadiay iti las-ud ti uppat a pulo nga aldaw ken rabii; saan isuna a nangan iti aniaman a taraon wenno imminum iti danum. Insuratna kadagiti tapi ti bato dagiti tulag, ti sangapulo a bilin. ");
INSERT INTO iloulb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Idi simmalog ni Moises iti Bantay Sinai nga awitna ti dua a tapi ti bato a nakaisuratan ti sangapulo a bilin, saanna nga ammo a rimmaniag ti kudil ti rupana bayat ti pannakisarsaritana iti Dios. ");
INSERT INTO iloulb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Idi nakita ni Aaron ken dagiti Israelita ti kudil ti rupa ni Moises nga agranraniag ket nagbutengda nga umasideg kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ngem inayaban ni Moises ida, ket immasideg kenkuana ni Aaron ken dagiti amin a mangidadaulo iti komunidad. Ket nakisarita ni Moises kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kalpasan daytoy, immasideg amin dagiti tattao kenni Moises, ket imbagana kadakuada dagiti amin a bilin nga inted ni Yahweh kenkuana iti Bantay Sinai. ");
INSERT INTO iloulb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Idi nalpas a nakisarita ni Moises kadakuada, nangikabil isuna iti abbong iti rupana. ");
INSERT INTO iloulb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tunggal mapan makisarita ni Moises kenni Yahweh, ikkatenna ti abbong. Ket isublinanto manen ti abbong no makaadayo isuna. Rumuar isuna iti tolda ket ibagana kadagiti Israelita ti naibilin kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Nakita dagiti Israelita ti rupa ni Moises nga agranraniag. Ngem kalpasanna, ikabilnna manen ti abbong iti rupana agingga nga agsubli isuna a makisarita kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Inummong ni Moises dagiti amin a tattao nga Israelita ket kinunana kadakuada, “Dagitoy dagiti banbanag nga imbilin ni Yahweh nga aramidenyo. ");
INSERT INTO iloulb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mabalin a leppasen ti trabaho iti innem nga aldaw, ngem para kadakayo, masapul a nasagradoan ti maikapito nga aldaw, naan-anay nga inana ti Aldaw a Panaginana, ta nasantoan kenni Yahweh. Siasinoman nga agtrabaho iti dayta nga aldaw ket masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Saankayo a mangaron iti aniaman kadagiti balbalayyo iti Aldaw a Panaginana.” ");
INSERT INTO iloulb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nagsao ni Moises kadagiti amin nga Israelita a kunana, “Daytoy ti banag nga imbilin ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mangalakayo iti daton para kenni Yahweh, dakayo a siaayat a mangted. Mangiyegkayo iti daton kenni Yahweh—balitok, pirak, bronse, ");
INSERT INTO iloulb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","asul, maris ube, ken nalabbaga a de lana ken kasayaatan a lino; dutdot iti kalding; ");
INSERT INTO iloulb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","napalabbaga a lalat ti kalakian a karnero ken kudil ti dugong; kayo ti akasia; ");
INSERT INTO iloulb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lana para iti pagsilawan iti santuario, rekado para iti pangkonsagrar a lana ken ti nabanglo nga insenso, ");
INSERT INTO iloulb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","bato nga onyx ken dadduma a napateg a batbato a maikabil para iti efod ken pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Tunggal batido a lallaki kadakayo nga addaan iti kabaelan ket umay agaramid iti amin a banag nga imbilin ni Yahweh- ");
INSERT INTO iloulb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ti tabernakulo nga adda toldana, ti abbongna, dagiti kaw-itna, dagiti tabla, dagiti balunet, dagiti poste, ken dagiti pagbatayan; ");
INSERT INTO iloulb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kasta met ti lakasa nga adda assiwna, ti kalub a mangipakita iti pannakakalub iti basol ti lakasa, ken kurtina a pangabbong iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Nangiyegda iti lamisaan nga adda assiwna, amin nga alikamenna, ken ti tinapay ti presensia; ");
INSERT INTO iloulb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ti kandelero para kadagiti silaw, karaman dagiti arkusna, dagiti pagsilawanna, ken ti lana para kadagiti pagsilawan; ");
INSERT INTO iloulb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ti altar ti insenso ken dagiti assiwna, ti pangkonsagrar a lana ket ti nabanglo nga insenso; ti maibitin para iti pagserkan ti tabernakulo; ");
INSERT INTO iloulb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ti altar para kadagiti mapuoran a daton nga adda bronse a barandiliasna ken dagiti assiwna, dagiti alikamenna; ken ti dakkel a palanggana nga adda pagbatayanna. ");
INSERT INTO iloulb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Inyegda dagiti maibitin nga adda poste ken batayna para iti paraangan, ken ti kurtina para iti pagserkan iti paraangan; ");
INSERT INTO iloulb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ken dagiti pasok ti tolda para iti tabernakulo ken paraangan, a karaman dagiti talida. ");
INSERT INTO iloulb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Nangiyegda iti pagan-anay a nasayaat ti pannakabelna para iti panagserbi iti nasantoan a disso, dagiti sagrado a pagan-anay para kenni Aaron a padi ken kadagiti annakna a lallaki, para kadakuada nga agserbi a kas papadi.” ");
INSERT INTO iloulb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kalpasanna pimmanaw dagiti amin a tribu ti Israel ket immadayoda manipud iti imatang ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Tunggal maysa a natignay ti pusona ken nagbalin a siaayat ti espirituna ket immay ken nangitugot iti maysa a daton kenni Yahweh para iti pannakaipatakder ti tabernakulo, para iti amin a banag a panagserbi iti uneg, ken para kadagiti nasagradoan a pagan-anay. ");
INSERT INTO iloulb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Immayda, dagiti lallaki ken babbai, amin a siaayat ti pusona. Nangiyegda iti al-alahas, ar-aritos, dagiti singsing, ken dagiti pulseras, amin a kita iti alahas a balitok. Indatagda dagiti amin a daton a balitok kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tunggal maysa nga addaan iti asul, maris ube ken nalabbaga a de lana, nafino a lino, dutdot ti kalding, napalabbaga a lalat ti kalakian a karnero ken lalat ti dugong ket nangiyegda. ");
INSERT INTO iloulb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tunggal maysa nga agar-aramid iti pirak a daton wenno bronse ket inyegna daytoy a kas daton kenni Yahweh, ken nangiyeg ti tunggal maysa nga addaan iti kayo nga akasia para iti aniaman a pakausaran iti trabaho. ");
INSERT INTO iloulb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tunggal babbai a kabaelanna ti agtibbi iti de lana babaen kadagiti imana ket nangiyeg kadagiti tinibbina nga asul, maris ube, wenno nalabbaga a de lana, wenno nafino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Amin dagiti babbai a natignay ti pusona ken kabaelanna ket nagtibbi iti dutdot ti kalding. ");
INSERT INTO iloulb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Nangiyeg dagiti mangidadaulo iti batbato nga onyx ken dadduma pay a napapateg a bato a maikabil iti efod ken pektoral; ");
INSERT INTO iloulb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","nangiyegda kadagiti rekado ken lana para kadagiti pagsilawan, para iti pangkonsagrar a lana, ken para iti nabanglo nga insenso. ");
INSERT INTO iloulb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nangiyeg dagiti Israelita kenni Yahweh iti daton a nagtaud iti kaungganda; tunggal lallaki ken babbai a siaayat ti pusoda ket nangiyeg kadagiti alikamen para iti amin a trabaho nga imbilin ti Dios kenni Moises a maaramid. ");
INSERT INTO iloulb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kinuna ni Moises kadagiti Israelita, “Kitaenyo, inayaban ni Yahweh babaen iti nagan ni Bezalel ti anak a lalaki ni Uri nga anak a lalaki ni Hur, manipud iti tribu ti Juda. ");
INSERT INTO iloulb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Pinunnona ni Bezalel iti espirituna tapno ikkanna iti kinasirib, pannakaawat, ken pannakaammo, para iti amin a kita ti kinabatido, ");
INSERT INTO iloulb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","nga agaramid kadagiti nasasayaat a disenio babaen iti balitok, pirak, ken bronse; ");
INSERT INTO iloulb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ken agtabas pay ken mangiyurnos kadagiti bato ken agkitikit ti kayo-tapno agaramid iti amin a kita iti disenio ken kinabatido. ");
INSERT INTO iloulb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Inkabilna iti pusona ti mangisuro, isuna ken ni Oholiab nga anak a lalaki ni Ahisamak, manipud iti tribu ti Dan. ");
INSERT INTO iloulb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Pinunnona ida iti kabaelan nga agaramid kadagiti amin a kita ti trabaho, a kas dumidisenio, a kas kumikitikit, a kas bumumurda iti asul, maris ube, ken nalabbaga a de lana, ken kasayaatan a lino, ken kas umaabael. Isuda dagiti batido a tao iti amin a kita ti trabaho, ken isuda dagiti agdisdisenio iti nasayaat. ");
INSERT INTO iloulb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Agtrabahonto ngarud da Bezalel ken Oholiab, kasta met ti tunggal nasirib ti pusona a tao nga inikkan ni Yahweh iti kabaelan ken pannakaawat a mangammo no kasano ti mangipatakder iti nasantoan a disso, a suroten dagiti alagaden nga intedna nga aramidenyo.” ");
INSERT INTO iloulb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Pinaayaban ni Moises da Bezalel, Oholiab, ken tunggal nalaing a tao nga inikkan ni Yahweh iti laing ti kapanunotanna, ken ti natignay ti pusona nga umay ken agtrabaho. ");
INSERT INTO iloulb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Inawatda manipud kenni Moises dagiti amin a sagut nga inyeg dagiti Israelita para iti pannakaipatakder ti nasantoan a disso. Agtultuloy latta a mangip-ipan dagiti tattao kenni Moises iti binigat kadagiti sagut nga agtaud iti kaungan. ");
INSERT INTO iloulb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Isu nga immay amin dagiti batido a tattao nga agtartrabaho idiay nasantoan a disso manipud iti sigud nga ar-aramidenda a trabaho. ");
INSERT INTO iloulb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Kinunada kenni Moises, “Mangiyum-umay dagiti tattao iti ad-adu ngem iti kasapulan para iti panagaramid iti trabaho nga imbilin ni Yahweh nga aramidentayo.” ");
INSERT INTO iloulb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Isu nga imbilin ni Moses nga awanen ti mangiyeg manipud iti kampo ti aniaman kadagiti daton para iti pannakaipatakder ti nasantoan a disso. Insardeng ngarud dagiti tattao ti mangiyeg kadagitoy a sagsagut. ");
INSERT INTO iloulb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Addaandan iti ad-adu pay ngem iti kasapulanda para iti amin a trabaho. ");
INSERT INTO iloulb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Impatakder ngarud dagiti amin a batido a tattao kadakuada ti tabernakulo nga addaan iti sangapulo a kurtina a naaramid manipud iti kasayaatan a lino ken asul, maris-ube, ken nalabbaga a de lana, a nadisenyoan iti kerubim. Daytoy ket trabaho ni Bezalel, ti batido unay nga agdisenio. ");
INSERT INTO iloulb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ti kaatiddog ti tunggal kurtina ket duapulo ket walo a cubico, ti kaakabana ket uppat a cubico. Agpapada amin ti rukod dagiti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pinagsasaep ni Bezalel dagiti lima a kurtina, ken pinagsasaepna pay dagiti sabali a lima a kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Nangaramid isuna iti asul a pangiyusokan iti akinruar nga igid iti murdong a kurtina iti maysa a beddeng, ken kasta met ti inaramidna iti akinruar nga igid iti murdong a kurtina oti maikadua a beddeng. ");
INSERT INTO iloulb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Nangaramid isuna iti limapulo a pangiyusokan iti umuna a kurtina ken limapulo a pangiyusokan iti igid ti murdong a kurtina iti maikadua a beddeng. Isu a nagbibinnatug dagiti pangiyusokan. ");
INSERT INTO iloulb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Nangaramid isuna iti limapulo a kaw-it a balitok ken pinagsasaepna dagiti kurtina ket nagbalin a sangsangkamaysa ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nangaramid ni Bezalel kadagiti kurtina babaen iti dutdot ti kalding para iti kasla tolda a pangabbong iti ngatoen ti tabernakulo; nangaramid isuna iti sangapulo ket maysa kadagitoy a kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ti kaatiddog ti tunggal kurtina ket tallopulo a cubico, ken ti kaakaba ti tunggal kurtina ket uppat a cubico. Tunggal pidaso kadagiti sangapulo ket maysa a kurtina ket agpapada ti rukodna. ");
INSERT INTO iloulb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pinagsasaepna ti lima a kurtina ken dagiti dadduma nga innem a kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Nangaramid isuna iti limapulo a pangiyusokan iti igid ti murdong a kurtina iti umuna a beddeng, ken limapulo a pangiyusokan iti igid ti murdong a kurtina a nakasilpoan ti maikadua a beddeng ti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nangaramid ni Bezalel iti limapulo a kaw-it a bronse a mangisaip iti pangabbong a kasla tolda tapno agbalin daytoy a maymaysa. ");
INSERT INTO iloulb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nangaramid isuna iti pangabbong a para iti tabernakulo babaen iti napalabbaga a lalat ti kalakian a karnero, sabali pay a pangabbong a naaramid iti kasayaatan a lalat a maiyabbong iti ngatoenna dayta. ");
INSERT INTO iloulb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Nangaramid ni Bezalel iti nakapatakder a tabla manipud iti kayo nga akasia para iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ti kaatiddog ti tunggal tabla ket sangapulo a cubico, ken ti kaakabana ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Adda dua a nakadawadaw iti tunggal tabla para iti panagkikinnamang dagiti tabla. Inaramidna amin dagiti tabla ti tabernakulo iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Iti kastoy a wagas nga inaramidna dagiti tabla para iti tabernakulo. Nangaramid isuna iti duapulo a tabla para iti akin-abagatan a paset. ");
INSERT INTO iloulb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Nangaramid ni Bezalel iti uppat a pulo a pagbatayan a pirak a maipasirok kadagiti duapulo a tabla. Adda dua a pagbatayan iti sirok ti umuna a tabla nga isu ti agbalin a dua a pagbatayanna, kasta met a dua a pagbatayan iti sirok ti tunggal dadduma pay a tabla para iti dua a pagbatayanda. ");
INSERT INTO iloulb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Para iti maikadua a paset ti tabernakulo, iti akin-amianan a paset, nangaramid isuna iti duapulo a tabla, ");
INSERT INTO iloulb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ken dagiti uppat a pulo a pirak a pagbatayanda. Adda dua a pagbatayan iti sirok ti umuna a tabla, dua a pagbatayan iti sirok ti sumaruno a tabla, ken dadduma pay. ");
INSERT INTO iloulb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Para iti likod ti tabernakulo nga adda iti laud, nangaramid ni Bezalel iti innem a tabla. ");
INSERT INTO iloulb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Nangaramid isuna iti dua a tabla para iti akinlikod a suli ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Dagitoy a tabla ket nagsinnina ti akinbaba, ngem nagkinnamang ti ngatoen dagitoy babaen iti isu met laeng a singsing. Kastoy ti pannakaaramid dagiti dua nga akinlikod a suli. ");
INSERT INTO iloulb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Adda iti walo a tabla, agraman dagiti pabatayanda a pirak. Sangapulo ket innem amin dagiti pagbatayan, dua a pagbatayan iti sirok ti umuna a tabla, dua a pagbatayan iti sirok ti sumaruno pay a tabla, ken dadduma pay. ");
INSERT INTO iloulb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Nangaramid ni Bezalel kadagiti balunet babaen iti kayo ti akasia-lima para kadagiti tabla nga adda iti maysa a sikigan ti tabernakulo, ");
INSERT INTO iloulb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lima a balunet para kadagiti tabla iti sabali pay a sikigan ti tabernakulo, ken lima a balunet para kadagiti tabla nga adda iti likod ti tabernakulo iti laud. ");
INSERT INTO iloulb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Inkabilna ti balunet idiay tengnga dagiti tabla, dayta ket, kagudua nga agpangato, a dumanon manipud pungto inggana pungto. ");
INSERT INTO iloulb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kinalupkopanna dagiti tabla iti balitok. Inaramidna dagiti singsingda manipud iti balitok, a mangtenggel kadagiti balunet, ken kinalupkopanna dagiti balunet iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Nangaramid ni Bezalel iti kurtina nga asul, maris-ube, ken nalabbaga a de lana, ken ti nafino a lino, a nadisenioan iti kerubim, ti aramid iti batido a trabahador. ");
INSERT INTO iloulb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Nangaramid isuna iti uppat nga adigi a kayo ti akasia para iti kurtina, ken kinalupkopanna dagitoy iti balitok. Nangaramid pay isuna iti balitok a pangikaw-itan para kadagiti adigi, ken inyaramidanna dagitoy iti uppat a pagbatayan a pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nangaramid isuna kadagiti maibitin para iti pagserkan ti tolda. Naaramid daytoy babaen iti panangaramat iti nafino a lino nga asul, maris-ube, nalabbaga a de lana, ti trabaho iti maysa a bumuburda. ");
INSERT INTO iloulb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Inaramidanna pay dagiti lima nga adigi nga adda kaw-itna. Kinalupkopanna iti balitok dagiti murdongda ken dagiti pagubonda. Naaramid manipud iti bronse dagiti lima a batayda. ");
INSERT INTO iloulb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Inaramid ni Bezalel ti lakasa babaen iti kayo ti akasia. Ti kaatiddogna ket dua ket kagudua a cubico; ti kaakabana ket maysa ket kagudua a cubico ken ti kangatona ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kinalupkopanna daytoy iti uneg ken ruar iti puro a balitok ken inyaramidanna daytoy iti iking a balitok iti aglawlaw ti rabawna. ");
INSERT INTO iloulb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nangaramid isuna kadagiti uppat a singsing a balitok para iti uppat a sakana, nga adda dua a singsing iti maysa a sikiganna, ken dua a singsing iti bangirna. ");
INSERT INTO iloulb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nangaramid isuna kadagiti assiw babaen iti kayo ti akasia ken kinalupkopanna dagitoy iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Inyusokna dagiti assiw kadagiti singsing nga adda iti sikigan ti lakasa, tapno maawit daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Nangaramid isuna iti kalub a mangipakita iti pannakakalub ti basol ti lakasa manipud iti puro a balitok. Ti kaatiddogna ket dua ket kagudua a cubico, ken ti kaakabana ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nangaramid ni Bezalel iti dua a kerubim manipud iti pinitpit a balitok a para kadagiti dua a pungto iti kalub a mangipakitaiti pannakakalub ti basol ti lakasa. ");
INSERT INTO iloulb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ti maysa a kerubim ket para iti maysa a pungto iti kalub a mangipakitaiti pannakakalub ti basol ti lakasa, ken ti maysa a kerubim ket para iti sabali pay a pungto. Naaramid dagitoy a sangsangkamaysa iti kalub a mangipakitaiti pannakakalub ti basol ti lakasa. ");
INSERT INTO iloulb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nakaukrad a pangato dagiti payyak ti kerubim ket lininonganda ti kalub a mangipakitaiti pannakakalub ti basol ti lakasa. Dagiti kerubim ket nagsinnango a nakaturong dagiti matada iti tengnga ti kalub ti lakasa. ");
INSERT INTO iloulb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nangaramid ni Bezalel iti lamisaan manipud iti kayo ti akasia, ti kaatiddogna ket dua a cubico, ti kalawana ket maysa a cubico ken ti kangatona ket maysa ket kagudua a cubico. ");
INSERT INTO iloulb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kinalupkopanna daytoy iti puro a balitok ken pinaikinganna ti aglawlaw ti rabawna iti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Pinalikmutanna daytoy iti paigid a sangadakulap ti kalawana, nga addaan iti paiking iti aglawlawna a balitok para iti paigid. ");
INSERT INTO iloulb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Inyaramidanna daytoy iti uppat a singsing a balitok sana inkapet kadagiti uppat a suli, nga ayan iti uppat a sakana. ");
INSERT INTO iloulb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Naikapet dagiti singsing iti paigid a pangiyusokan kadagiti assiw, tapno maawit ti lamisaan. ");
INSERT INTO iloulb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Inaramidna dagiti assiw babaen iti kayo ti akasia ken kinalupkopanna dagitoy iti balitok, tapno maawit ti lamisaan. ");
INSERT INTO iloulb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Inaramidna dagiti banag a maiparabaw ti lamisaan-dagiti pinggan, dagiti kutsara, dagiti mallukong, ken dagiti pitser a mausar a pangibukbokan kadagiti daton. Inaramidna dagitoy manipud iti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Inaramidna ti kandelero manipud iti pinitpit a puro a balitok. Inaramidna ti kandelero nga adda batayna ken puonna. Dagiti kopana, dagiti nakaikapetanna a nakortean iti sinan-bulong, ken dagiti sabongna ket naaramid a sangsangkamaysa iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Innem a sanga ti nakadawadaw kadagiti sikigan daytoy-nakadawadaw dagiti tallo a sanga iti maysa a sikigan, ken nakadawadaw met dagiti tallo a sanga iti bangir a sikigan ti kandelero. ");
INSERT INTO iloulb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ti umuna a sanga ket addaan iti tallo a kopa a kasla sabong ti almendra ti pannakaaramidna, a nakortean iti sinan-bulong ti nakaikapetanna ken sinan-sabong, ken tallo a kopa a kasla sabong ti almendra ti pannakaaramidna iti sabali pay a sanga, a nakortean iti sinan-bulong ti nakaikapetanna ken sinan-sabong. Agpapada dagitoy nga innem a sanga a nakadawdaw manipud iti kandelero. ");
INSERT INTO iloulb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Iti mismo a kandelero, ti sentro a puonna ket adda iti uppat a kopa a kasla sabong ti almendra ti pannakaaramidna, a nakortean ti sinan-bulong ken sabsabong ti nakaikapetanna. ");
INSERT INTO iloulb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Adda maysa a nakortean iti sinan-bulong iti sirok ti umuna a pares dagit sanga a naaramid a sangsangkamaysa iti daytoy, ken nakortean iti sinan-bulong iti sirok ti maikadua a pares dagiti sanga-naaramid a sangsangkamaysa iti dagitoy. Kasta met nga adda naikorte a sinan-bulong iti sirok ti maikatlo a pares dagiti sanga, a naaramid a sangsangkamaysa iti daytoy. Agpapada para kadagiti innem a sanga nga agdawdawadaw iti kandelero. ");
INSERT INTO iloulb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Dagiti naikorte a sinan-bulong a nakaikapetan ken sangada ket sangsangkamaysa amin iti daytoy, maysa a napanday a pidaso ti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Inaramid ni Bezalel ti kandelero ken ti pito a pagsilawanna, dagiti pagarsang ken dagiti pagarsangan manipud iti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Inaramidna ti kandelero ken dagiti alikamenna manipud iti maysa a talento ti puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Inaramid ni Bezalel ti altar ti insenso. Inaramidna daytoy manipud iti kayo ti akasia. Maysa a cubico ti kaatiddogna, ken maysa a cubico ti kaakabana. Kuadrado daytoy, ken dua a cubico ti kangatona. Naaramid dagiti kasla sarana a sangsangkamaysa iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kinalupkopanna ti altar iti insenso iti puro a balitok-ti rabawna, kadagiti sikiganna, ken kadagiti kasla sarana. Nangaramid pay isuna iti ikingna a balitok para iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Nangaramid isuna iti dua a balitok a singsing a maikapet iti sirok ti ikingna iti nagsinnumbangir a sikiganna. Dagiti singsing ti mangtengngel kadagiti assiw a pangawit ti altar. ");
INSERT INTO iloulb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Inaramidna dagiti assiw manipud iti kayo ti akasia, ken kinalupkopanna dagitoy iti balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Inaramidna ti nasagradoan a pangkonsagrar a lana ken ti puro a bangbanglo nga insenso, trabaho ti maysa nga umaaramid iti bangbanglo. ");
INSERT INTO iloulb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Inaramid ni Bezalel ti altar a kayo ti akasia para kadagiti daton a mapuoran. Lima a cubico ti kaatiddogna ken lima a cubico ti kalawana—maysa a kuadrado—ken tallo a cubico ti kangatona. ");
INSERT INTO iloulb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Sinilpoanna dagiti uppat a sulina iti nasukog a kas kadagiti sara ti bulog a baka. Naaramid dagiti sara a sangsangkamaysa iti altar ken kinalupkopanna dagitoy iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Inaramidna amin dagiti alikamen para iti altar— dagiti banga para kadagiti dapu, dagiti pala, dagiti palanggana, dagiti salukay iti karne ken pagikkan kadagiti beggang. Inaramidna amin daytoy nga alikamen babaen iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Inaramidna ti barandilias para iti altar, nagkikinnamang a bronse a maikabil manipud sirok ti pasamano nga agpababa a dumanon iti tengnga. ");
INSERT INTO iloulb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Nangaramid isuna iti uppat a singsing para iti uppat a suli iti bronse a barandillas, a pakaiyusokan dagiti assiw. ");
INSERT INTO iloulb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Nangaramid ni Bezalel kadagiti assiw a kayo ti akasia ken kinalupkopanna dagitoy iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Inyusokna dagiti assiw kadagiti singsing nga adda kadagiti sikigan ti altar, tapno maawit daytoy. Inaramidna ti altar nga awan nagyan ti unegna manipud iti napuskol a tabla. ");
INSERT INTO iloulb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Inaramid ni Bezalel ti dakkel a palanggana a bronse nga adda pakaiparabawanna a bronse. Inaramidna ti palanggana manipud kadagiti sarming a kukua dagiti babbai nga agserserbi idiay pagserkan ti sagrado a tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Inaramidna pay ti paraangan. Dagiti naibitin iti abagatan a paset iti paraangan ket naaramid iti kasayaatan a lino, a sangagasut a cubico ti kaatiddogna. ");
INSERT INTO iloulb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Dagiti naibitin ket addaan iti duapulo a poste nga addaan iti duapulo a bronse a batayna. Adda dagiti kaw-it a naikapet kadagiti poste ken kasta met kadagiti pagubon a pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kasta met iti akin-amianan, adda dagiti nakabitin a sangagasut a cubico ti kaatiddogda nga addaan iti duapulo a poste, duapulo a bronse a batayda, dagiti kaw-it a naikapet kadagiti poste ken dagiti pagubon a pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dagiti naibitin iti akin-laud ket limapulo a cubico ti kaatiddogda, nga addaan iti sangapulo a postena ken pagbatayan. Dagiti kaw-it ken dagiti pagubon dagiti poste ket pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ti akin-daya a paraangan ket limapulo a cubico met iti kaatiddogna. ");
INSERT INTO iloulb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dagiti naibitin iti maysa a paset iti pagserkan ket sangapulo ket lima a cubico ti kaatiddogda. Addaanda iti tallo a poste nga addaan iti tallo a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Iti sabali a paset iti pagserkan ti paraangan ket adda pay ti naibitin a sangapulo ket lima a cubico ti kaatiddogda, nga addaan iti tallo a poste ken iti tallo a pagbatayan. ");
INSERT INTO iloulb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Amin dagiti nakabitin iti aglawlaw ti paraangan ket naaramid iti kasayaatan a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Dagiti pagbatayan para kadagiti poste ket naaramid manipud iti bronse. Dagiti kaw-it ken pagubon para kadagiti poste ket naaramid manipud iti pirak, ken dagiti naikalupkop kadagiti tuktok dagiti poste ket naaramid pay babaen iti pirak. Amin dagiti poste ti paraangan ket nakalupkopan iti pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ti kurtina iti ruangan ti paraangan ket duapulo a cubico ti kaatidogna. Ti kurtina ket naaramid kadagiti asul, maris ube ken nalabaga a lino, tinali a kasayaatan a lino ken duapulo a cubico ti kaatiddogna. Duapulo a cubico ti kaakabana ken lima a cubico ti kangatona, a kasla kadagiti kurtina iti paraangan. ");
INSERT INTO iloulb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Addaan daytoy kadagiti uppat a batay a bronse ken kadagiti kaw-it a naaramid babaen iti pirak. Dagiti nakakalupkop kadagiti tuktokda ken dagiti pagubonda ket naaramid babaen iti pirak. ");
INSERT INTO iloulb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Amin dagiti pasok ti tolda para iti tabernakulo ken paraangan ket naaramid iti bronse. ");
INSERT INTO iloulb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Daytoy ti listaan ti tabernakulo, ti tabernakulo iti sangapulo a bilin, naala daytoy a kas panangsurot kadagiti bilin ni Moises. Trabaho daytoy dagiti Levita babaen ti panangimaton ni Itamar nga anak a lalaki ni Aaron a padi. ");
INSERT INTO iloulb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ni Bezalel, ti anak a lalaki ni Uri nga anak a lalaki ni Hur, manipud iti tribu ti Juda, inaramidna amin a banbanag nga imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ni Oholiab nga anak a lalaki ni Ahisamac manipud iti tribu ti Dan ket kaddua ni Bezalel a nagtrabaho a kas kumikitikit, a kas batido a trabahador, ken kas bumuborda iti asul, maris ube ken nalabbaga a de lana, ken napino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Amin a balitok a nausar para iti trabaho, iti amin a trabaho a mainaig iti nasantoan a disso—ti balitok manipud iti pannakaidatag ti daton— ket duapulo ket siam a talento ken 730 a siklo, narukod babaen iti naituyang a pagtimbangan iti siklo ti santuario. ");
INSERT INTO iloulb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ti pirak nga inted dagiti tattao ket agdagsen iti sangagasut a talento ken 1, 775 a siklo, segun iti naituyang a pagtimbangan iti siklo ti santuario, ");
INSERT INTO iloulb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","wenno maysa a beka kada tao, a kagudua ti maysa a siklo, narukod segun iti pagtimbangan iti siklo ti santuario. Daytoy a bilang ket naibasar iti tunggal tao a naibilang iti sensus, dagiti agtawen iti duapulo nga agpangato—603, 550 amin a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Sangagasut a talento iti pirak ti naaramid para kadagiti batay iti nasantoan a disso ken batay dagiti kurtina: iti sangagasut a batay, maysa a talento para iti tunggal batay. ");
INSERT INTO iloulb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Inaramid ni Bezalel dagiti nabati a 1, 775 a siklo iti pirak a kaw-it para kadagiti poste, panangkalupkop kadagiti tuktok ti poste, ken naaramid a pagubon para kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ti bronse manipud kadagiti daton ket agdagsen iti pitopulo a talento ken 2, 400 a siklo. ");
INSERT INTO iloulb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Inaramidna babaen kadagitoy dagiti batay para iti pagserkan nga agturong iti sagrado a tolda, ti bronse nga altar, ti bronse a barandiliasna, amin dagiti alikamen a para iti altar, ");
INSERT INTO iloulb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","dagiti batay para iti paraangan, dagiti batay iti pagserkan ti paraangan, amin dagiti pasok ti tolda a para iti tabernakulo ken amin dagiti pasok ti tolda a para iti paraangan. ");
INSERT INTO iloulb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Babaen iti asul, maris ube ken nalabbaga a de lana ket nangaramidda iti kasayaatan ti pannakaabelna a pagan-anay para iti panagserbi iti nasantoan a disso. Inaramidda ti pagan-anay ni Aaron para iti nasantoan a disso, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Inaramid ni Bezalel ti efod iti balitok, iti asul, maris ube ken nalabbaga a de lana, ken iti tinali a napino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nangpitpida kadagiti pidaso iti balitok ket rinagasda a pinagbalin a kasla kaingpis ti sinulid tapno mainayon dagitoy kadagiti asul, maris ube ken nalabbaga a de lana, ken iti napino a lino, ti aramid iti maysa a batido a trabahador. ");
INSERT INTO iloulb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Nangaramidda kadagiti terante para iti efod, a naikapet iti dua nga akinngato a sulina. ");
INSERT INTO iloulb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ti napintas ti pannakaabelna a barikes ket kasla met laeng iti efod; naaramid daytoy a sangsangkamaysa a karaman ti efod, naaramid iti tinali a napino a lino a balitok, asul, maris ube ken nalabbaga, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Tinabasda dagiti onyx a bato sada impabugas iti balitok a pagsaadanna, naisaad nga addaan naikitikit a kas pangselio, ken naikitikit dagiti nagan dagiti sangapulo ket dua nga annak a lallaki ni Israel. ");
INSERT INTO iloulb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Inkabil ni Bezalel dagitoy iti terante ti efod, a kas batbato a mangipalagip kenni Yahweh kadagiti sangapulo ket dua nga annak a lallaki ni Israel, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Inaramidna ti pektoral, ti aramid ti maysa a batido a trabahador, naaramid a kas iti efod. Inaramidna daytoy manipud iti balitok, iti asul, maris ube ken nalabbaga a de lana, ken napino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kuadrado daytoy. Inkulpida ti pektoral iti namindua. Maysa a dangan ti kaatiddogna ken maysa a dangan ti kalawana. ");
INSERT INTO iloulb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Nangaramidda iti daytoy iti uppat nga intar dagiti napapateg a bato. Ti umuna nga intar ket addaan iti maysa a rubi, maysa a topasio ken maysa a granate. ");
INSERT INTO iloulb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ti maikadua nga intar ket addaan iti maysa nga esmeralda, maysa a safiro ken maysa a diamante. ");
INSERT INTO iloulb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ti maikatlo nga intar ket addaan iti maysa a jasinto, maysa nga agata ken maysa nga amatista. ");
INSERT INTO iloulb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ti maikapat nga intar ket addaan iti maysa a berrilio, maysa nga onyx ken maysa a jaspe. Naimontar dagiti bato kadagiti balitok a pagsaadan. ");
INSERT INTO iloulb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Naiyurnos dagiti bato babaen kadagiti nagan dagiti sangapulo ket dua nga annak a lallaki ni Israel, babaen iti panagsisinnaruno ti nagan. Maipada dagitoy kadagiti naikitikit iti singsing a pangselio, itaktakder ti tunggal nagan ti maysa kadagiti sangapulo ket dua a tribu. ");
INSERT INTO iloulb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Iti pektoral nangaramidda iti kawar a kasla tali, a nasallapid a puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nangaramidda iti dua a balitok a pagimontaran ken dua a balitok a singsing, ket inkapetda dagiti dua a singsing iti dua a suli ti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Inkabilda dagiti dua a nasallapid a kawar a balitok iti dua a singsing kadagiti suli ti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Inkapetda dagiti sabali a dua a murdong ti nasallapid a kawar iti dua a pagimontaran. Inkapetda dagitoy iti terante ti efod iti sangoananna. ");
INSERT INTO iloulb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Nangaramidda iti dua a singsing a balitok ken inkapetda dagitoy iti dua a sabali pay a suli ti pektoral, iti akinbaba nga igid ti akin-uneg a gayadanna. ");
INSERT INTO iloulb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nangaramidda pay iti dua a balitok a singsing ken inkapetda dagitoy iti akinbaba iti dua a terante iti sangoanan ti efod, nga asideg iti nagdaitan iti ngatoen ti nasayaat ti pannakaabelna a barikes ti efod. ");
INSERT INTO iloulb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Inggalotda ti pektoral babaen kadagiti singsingna kadagiti singsing ti efod iti asul a tali, tapno mabalin a maikapet daytoy iti ngatoen laeng ti nasayaat ti pannakaabelna a barikes ti efod. Daytoy ket tapno ti pektoral ket saan a maikkat manipud iti efod. Naaramid daytoy a kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Inaramid ni Bezalel ti kagay ti efod a pasig a maris ube a lupot, ti aramid iti maysa nga umaabel. ");
INSERT INTO iloulb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Addaan daytoy iti pangiyusokan ti ulo iti tengngana. Naabel ti igid ti pangiyusokan tapno saan a mapigis. ");
INSERT INTO iloulb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Iti gayadan, nangaramidda kadagiti sinan granada babaen iti asul, maris ube ken nalabbaga a sinulid, ken iti napino a lino. ");
INSERT INTO iloulb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nangaramidda kadagiti kampanilia a puro a balitok, ken inkabilda dagiti kampanilia iti nagbaetan dagiti sinan-granada iti amin nga aglawlaw ti gayadan ti kagay, iti nagbaetan dagiti sinan-granada— ");
INSERT INTO iloulb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","maysa a kampanilia ken maysa a sinan-granada, maysa a kampanilia ken maysa a sinan-granada—iti igid ti kagay tapno makapagserbi ni Aaron. Daytoy ket kas iti imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Inaramidda dagiti tunika manipud iti napino a lino para kenni Aaron ken para kadagiti annakna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Inaramidda ti turban manipud iti napino a lino, ti naarkusan a baredbed ti ulo manipud iti napino a lino, ti akin-uneg a pagan-anay manipud iti napino a lino, ");
INSERT INTO iloulb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ken ti barikes iti napino a lino ken asul, maris ube, ken nalabbaga a sinulid, ti aramid ti maysa a bumuborda. Daytoy ket kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Inaramidda ti insignia ti nasantoan a korona iti puro a balitok; inkitikitda iti daytoy, kasla iti naikitikit iti singsing nga adda timbrena, NAIDATON KENNI YAHWEH. ");
INSERT INTO iloulb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Inkapetda iti turban ti maysa nga asul a tali iti rabaw ti turban. Daytoy ket kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Isu a ti trabaho iti tabernakulo, nga isu ti sagrado a tolda ket nalpas. Inaramid dagiti Israelita dagiti amin a banag. Sinurotda dagiti amin a bilin nga inted ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Impanda ti tabernakulo kenni Moises—ti tolda ken amin dagiti alikamenna, dagiti pagsab-itanna, dagiti tabla, dagiti balunet, dagiti poste, ken dagiti batay; ");
INSERT INTO iloulb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ti pangabbong a lalat ti kalakian a karnero a namarisan iti nalabbaga, ti pangabbong a lalat ti dugong ken dagiti kurtina a panglinged ");
INSERT INTO iloulb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","iti lakasa ti tulag, kasta met dagiti assiw ken ti kalub a mangipakita iti pannakakalub iti basol. ");
INSERT INTO iloulb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Impanda ti lamisaan, dagiti amin nga alikamenna, ken ti tinapay iti presensia; ");
INSERT INTO iloulb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ti kandelero a puro a balitok ken dagiti pagsilawanna a nakaintar, agraman dagiti alikamenna ken ti lana para kadagiti pagsilawan; ");
INSERT INTO iloulb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ti altar a balitok, ti pangpulot a lana ken ti nabanglo nga insenso; ti maibitin para iti pagserkan ti tabernakulo; ");
INSERT INTO iloulb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ti bronse nga altar agraman dagiti barandiliasna a bronse, dagiti assiwna ken dagiti alikamenna, ken ti dakkel a palanggana agraman ti batayna. ");
INSERT INTO iloulb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Impanda dagiti maibitin para iti paraangan ken dagiti poste ken dagiti batayna, ken ti kurtina para iti pagserkan ti paraangan; dagiti talina ken dagiti pasok ti tolda; ken dagiti amin nga alikamen para iti panagserbi iti tabernakulo, ti sagrado a tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Impanda dagiti nasayaat a naabel a pagan-anay para iti panagserbi iti nasantoan a disso, dagiti nasantoan a pagan-anay ni Aaron a padi ken dagiti annakna a lallaki, tapno makapagserbida a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Inaramid ngarud dagiti Israelita ti amin a trabaho kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Sinukimat ni Moises ti amin a trabaho, ket, adtoy, naaramidda daytoy. Kas imbilin ni Yahweh, iti dayta a wagas ket naaramidda daytoy. Kalpasanna, binendisionan ida ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kalpasanna, nagsao ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Iti umuna nga aldaw ti umuna a bulan ti baro a tawen, masapul nga ibangonmo ti tabernakulo, ti sagrado a tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Masapul nga ikabilmo ti lakasa ti tulag iti daytoy, ken masapul a lingedam ti lakasa iti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Masapul nga ipanmo ti lamisaan ken iyurnosmo dagiti banag a karaman iti daytoy. Ken masapul nga iyunegmo ti kandelero ket iyurnosmo dagiti pagsilawanna. ");
INSERT INTO iloulb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Masapul nga ikabilmo ti balitok nga altar ti insenso iti sango ti lakasa ti tulag, ken masapul nga ibitinmo ti kurtina iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Masapul nga ikabilmo ti altar para kadagiti daton a mapuoran idiay sangoanan iti pagserkan ti tabernakulo, ti sagrado a tolda. ");
INSERT INTO iloulb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Masapul nga ikabilmo ti dakkel a palanggana iti nagbaetan ti sagrado a tolda ken ti altar, ken masapul a kargaam iti danum daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Masapul nga isimpam ti paraangan iti aglawlawna daytoy, ken masapul nga ibitinmo ti kurtina iti pagserkan ti paraangan. ");
INSERT INTO iloulb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Masapul nga alaem ti lana a pangpulot ket konsagraram ti tabernakulo ken amin a banag nga adda iti daytoy. Masapul nga idatonmo daytoy ken dagiti amin nga alikamenna kaniak, ket agbalinto a nasantoan daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Masapul konsagraram ti altar para kadagiti daton a mapuoran ken amin dagiti alikamenna. Masapul nga idatonmo ti altar kaniak, ket naan-anayto ti pannakaidatonna kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Masapul a konsagraram ti bronse a palanggana ken ti batayna ken idatonmo dagitoy kaniak. ");
INSERT INTO iloulb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Masapul nga ipanmonto ni Aaron ken dagiti annakna a lallaki iti pagserkan ti sagrado a tolda, ken masapul a buggoam ida iti danum. ");
INSERT INTO iloulb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Masapul a kawesam ni Aaron kadagiti pagan-anay a naidaton kaniak, pulotam ken idatonmo isuna kaniak tapno agserbi isuna a kas padik. ");
INSERT INTO iloulb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Masapul nga ipanmonto dagiti annakna a lallaki ket kawesam ida kadagiti kagay. ");
INSERT INTO iloulb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Masapul a pulotam ida kas iti panangpulotmo iti amada tapno makapagserbida kaniak a kas papadi. Ti pannakapulotda ket isu ti mamagbalin kadakuada iti agnanayon a kinapadida iti amin a kaputotan dagiti tattaoda.” ");
INSERT INTO iloulb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Daytoy ti inaramid ni Moises; tinungpalna amin nga imbilin ni Yahweh kenkuana. Inaramidna amin dagitoy a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Isu a naibangon ti tabernakulo iti umuna nga aldaw ti umuna a bulan iti maikadua a tawen. ");
INSERT INTO iloulb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Imbangon ni Moises ti tabernakulo, inkabilna dagiti batay iti pagsaadanna, insimpana dagiti bastidorna ken inkapetna dagiti balunet ken impatakderna dagiti postena. ");
INSERT INTO iloulb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Inyukradna ti abbong iti rabaw ti tabernakulo ken inkabilna ti kasla tolda a pannakakalob ti rabaw daytoy, kas imbilin ni Yaweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Innalana ti sangapulo a bilin ket inkabilna dagitoy iti Lakasa. Inkabilna pay dagiti assiw iti Lakasa. Ken inkabilna iti daytoy ti kalub a mangipakita iti pannakakalub iti basol. ");
INSERT INTO iloulb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Inyapanna ti Lakasa iti tabernakulo. Insimpana ti kurtina para iti daytoy a manglinged iti Lakasa ti Tulag, kas imbillin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Inkabilna ti lamisaan iti uneg ti sagrado a tolda, iti akin-amianan a paset ti tabernakulo, iti ruar ti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Inyurnosna ti tinapay iti rabaw ti lamisaan iti sangoanan ni Yahweh, kas imbilin ni Yaweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Inkabilna ti kandelero iti uneg ti sagrado a tolda, a naibatog iti lamisaan, iti akin-abagatan a paset ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Sinindianna dagiti pagsilawan iti sangoanan ni Yahweh, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Inkabilna ti balitok nga altar iti uneg ti sagrado a tolda iti sangoanan ti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Nangpuor isuna iti nabanglo nga insenso iti rabaw daytoy, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Imbitinna ti kurtina iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inkabilna ti altar para iti daton a mapuoran iti pagserkan ti tabernakulo, ti sagrado a tolda. Nangidaton isuna iti rabaw daytoy ti daton a mapuoran ken ti bukbukel a daton, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inkabilna ti palanggana iti nagbaetan ti sagrado a tolda ken ti altar ket kinargaanna daytoy iti danum a pagbuggoan. ");
INSERT INTO iloulb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Bugbuguan ni Moises, Aaron ken dagiti annakna a lallaki dagiti ima ken sakada iti palanggana ");
INSERT INTO iloulb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","tunggal mapanda iti sagrado a tolda ken tunggal sumagpatda iti altar. Buggoanda dagiti bagbagida, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Insimpa ni Moises ti paraangan iti aglawlaw ti tabernakulo ken ti altar. Insimpana ti kurtina idiay pagserkan ti paraangan. Iti kastoy a wagas, nalpas ni Moises ti trabaho. ");
INSERT INTO iloulb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ket inabbongan ti ulep ti sagrado a tolda, ken napno iti dayag ni Yahweh ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Saan a makastrek ni Moises iti sagrado a tolda gapu ta nagtalinaed ti ulep iti daytoy, ken gapu ta napno iti dayag ni Yahweh ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tunggal agpangato ti ulep iti ngatoen ti tabernakulo, agrubbuat dagiti Israelita iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ngem no saan nga agpangato ti ulep manipud iti tabernakulo, ket saan nga agdaliasat dagiti tattao. Agtalinaedda agingga iti aldaw nga agpangato daytoy. ");
INSERT INTO iloulb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ta ti ulep ni Yahweh ket adda iti ngatoen ti tabernakulo iti aldaw, ken ti apuyna ket adda iti ngatoen daytoy iti rabii, a makita amin dagiti Israelita bayat ti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Immawag ni Yahweh kenni Moises ken nakisarita isuna kenkuana manipud iti tabernakulo, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Makisaritaka kadagiti Israelita ken ibagam kadakuada, 'No ti siasinoman a tao kadakayo ket mangiyeg iti daton kenni Yahweh, iyegyo ti maysa kadagiti tarakenyo a kas datonyo, manipud man daytoy iti pangen wenno iti arban. ");
INSERT INTO iloulb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","No ti datonna ket daton a maipuor amin manipud iti pangen, masapul a mangidaton isuna iti kalakian nga awan ti mulitna. Masapul nga idatonna daytoy iti pagserkan ti tabernakulo, tapno maawat daytoy iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Masapul nga ipatayna ti imana iti ulo ti daton a maipuor amin ket maawatto daytoy iti biangna a kas daton a mangabbong kadagiti basbasolna. ");
INSERT INTO iloulb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kalpasanna, masapul a patayenna ti bulog a baka iti sangoanan ni Yahweh. Idatag dagiti padi nga annak ni Aaron ti dara ken ibuyatda daytoy iti altar nga adda iti pagserkan iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Kalpasanna, masapul a lalatanna ti daton a maipuor amin ken rangrangkayenna daytoy iti pidapidaso. ");
INSERT INTO iloulb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kalpasanna, mangpasged dagiti annak ni Aaron a padi iti rabaw ti altar ken sungrudanda tapno agapuy. ");
INSERT INTO iloulb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ikabil dagiti padi nga annak ni Aaron dagiti paset ti daton a bulog a baka, ti ulo ken ti taba nga agsasaruno iti rabaw ti sumsumged a kayo nga adda iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ngem dagiti lalaem ken dagiti saka, masapul a buguanna iti danum. Kalpasanna, ipuor ti padi dagiti amin a banbanag iti rabaw ti altar a kas daton a maipuor amin. Mangparnuay daytoy iti nabanglo nga ayamuom a para kaniak; datonto daytoy a maipuor a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","No ti idatonna para iti daton a maipuor amin ket manipud iti arban, maysa kadagiti karnero wenno maysa kadagiti kalding, masapul a mangidaton isuna iti kalakian nga awan mulitna. ");
INSERT INTO iloulb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Masapul a patayenna daytoy iti amianan a sikigan ti altar iti sangoanan ni Yahweh. Ibuyat dagiti padi nga annak ni Aaron ti dara kadagiti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ket masapul a rangrangkayenna daytoy iti pidapidaso, agraman ti ulo ken ti taba, ken iparabaw ti padi dagitoy nga agsasaruno iti sumsumged a kayo nga adda iti altar, ");
INSERT INTO iloulb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ngem dagiti lalaem ken dagiti saka, masapul a bugguanna iti danum. Kalpasanna, idaton ti padi ti sibubukel ken ipuorna daytoy iti rabaw ti altar. Daytoy ket daton a maipuor amin, ken mangparnuay daytoy iti nabanglo nga ayamuom para kenni Yahweh; daytoy ket daton a maipuor a para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","No ti idatonna kenni Yahweh ket billit para iti daton a maipuor amin, masapul ngarud a mangiyeg isuna iti kalapati wenno sibong a pagaw a kas datonna. ");
INSERT INTO iloulb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Masapul nga ipan ti padi daytoy iti altar, tiritirenna sana pulsoten ti ulona ken ipuorna iti rabaw ti altar. Kalpasanna, masapul a maipaaruyot ti darana iti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Masapul nga ikkatenna ti kinarakaranna ken dagiti nagyanna ken ibellengna daytoy iti abay ti altar iti akin daya a sikigan, iti disso a pakaikabilan iti dapu. ");
INSERT INTO iloulb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Masapul a pisangenna daytoy iti payakna, ngem masapul a saanna a bingayen daytoy iti dua a paset. Kalpasanna, ipuor ti padi daytoy iti rabaw ti altar, iti sumsumged a kayo. Daytoy ket daton a maipuor amin, ken mangparnuay iti nabanglo nga ayamuom para kenni Yahweh; daytoy ket daton a maipuor a para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","No mangiyeg ti siasinoman iti daton a bukbukel kenni Yahweh, ti idatonna ket masapul a napino nga arina, ken bukbukanna daytoy iti lana ken ikkanna iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Masapul nga ipanna ti daton kadagiti padi nga annak ni Aaron, ken sadiay, mangrakem ti padi iti napino nga arina nga addaan iti lana ken insenso. Ket puoran ti padi ti daton iti rabaw ti altar kas siyayaman isuna a mangpanpanunot iti kinaimbag ni Yahweh. Mangparnuay daytoy iti nabanglo nga ayamuom para kenni Yahweh; daytoy ket daton a maipuor a para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Aniaman a matda iti daton a bukbukel ket kukua ni Aaron ken dagiti annakna a lallaki. Naan-anay a naidaton daytoy kenni Yahweh manipud kadagiti daton a maipuor a para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","No mangidatonkayo iti daton a bukbukel nga awan ti lebadurana a nailuto iti pugon, masapul a nalukneng a tinapay daytoy a naaramid iti napino nga arina a nalaokan iti lana, wenno natangken a tinapay nga awan ti lebadurana, a napuligadan iti lana. ");
INSERT INTO iloulb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","No ti datonyo a bukbukel ket nailuto iti paryok, masapul a naaramid daytoy iti napino nga arina nga awan ti lebadurana a nalaokan iti lana. ");
INSERT INTO iloulb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Masapul a pisipisienyo daytoy iti babassit ken bukbukanyo iti lana. Daytoy ket daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","No ti datonyo a bukbukel ket nailuto iti paryok, masapul a naaramid daytoy iti napino nga arina ken lana. ");
INSERT INTO iloulb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Masapul nga ipanyo kenni Yahweh ti daton a bukbukel a naaramid kadagitoy a banbanag, ken maidatagto daytoy iti padi a mangipan iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kalpasanna, mangala ti padi kadagiti daton a bukbukel kas siyayaman isuna a mangpanpanunot iti kinaimbag ni Yahweh, ken puoranna daytoy iti rabaw ti altar. Daytoy ket daton a maipuor a para kenkuana, ken mangparnuay daytoy iti nabanglo nga ayamuom para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ti matda manipud iti daton a bukbukel ket kukua ni Aaron ken dagiti annakna a lallaki. Naan-anay a naidaton daytoy kenni Yahweh manipud kadagiti daton a maipuor a para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Masapul nga awan ti idatonyo kenni Yahweh a daton a bukbukel a naaramid iti lebadura, ta masapul a saankayo a mangpuor iti lebadura, wenno aniaman a diro a kas daton a maipuor a para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Idatonyo dagitoy kenni Yahweh a kas daton dagiti umuna a bunga, ngem saanda a mausar a mangparnuay iti nabanglo nga ayamuom iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Masapul a laokanyo iti asin dagiti tunggal datonyo a bukbukel. Masapul a saanyo nga itulok a ti asin ti katulagan iti Diosyo ket mapukaw manipud iti datonyo a bukbukel. Iti amin kadagiti datonyo masapul a mangidatonkayo iti asin. ");
INSERT INTO iloulb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","No mangidatonkayo iti bukbukel iti umuna a bunga kenni Yahweh, mangidatonkayo iti kaap-apit a bukbukel a naikirog ken nabayo. ");
INSERT INTO iloulb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kalpasanna, masapul nga ikkanyo daytoy iti lana ken insenso. Daytoy ket daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ket mangpuor ti padi iti paset iti nabayo a bukbukel ken lana ken insenso kas siyayaman isuna a mangpanpanunot iti kinaimbag ni Yahweh. Daytoy ket daton a maipuor a para kenni Yawheh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","No mangidatag ti siasinoman iti ayup a kas daton a para iti panagkakadua manipud kadagiti pangen, kalakian man wenno kabaian, masapul a mangidaton isuna ti ayup nga awan ti mulitna iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ipatayna ti imana iti ulo ti datonna ken patayenna daytoy iti ruangan ti tabernakulo. Kalpasanna, iwarsi dagiti padi nga annak ni Aaron ti darana kadagiti sikigan iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Idaton ti tao ti daton para iti panagkakadua babaen iti apuy kenni Yahweh. Ti taba a nangbalkot wenno naisilpo kadagiti lalaem, ");
INSERT INTO iloulb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ken dagiti dua a bekkel ken ti taba a kimpet kadagiti lumo, ken ti kasayaatan a paset ti dalem, ken dagiti bekkel— ikkatenna amin dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Puoran dagiti annak a lallaki ni Aaron dagitoy iti rabaw ti altar agraman dagiti daton a maipuor amin nga adda kadagiti sumsumged a kayo. Mangparnuay daytoy iti nabanglo nga ayamuom a para kenni Yahweh; daton daytoy a maipuor para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","No ti daton ti tao para iti daton a panakikadua kenni Yahweh ket manipud kadagiti arban; kalakian wenno kabaian, masapul a mangidaton isuna iti daton nga awan ti mulitna. ");
INSERT INTO iloulb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","No urbon a karnero ti idatonna, ket masapul nga idatonna daytoy iti sangngoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ipatayna ti imana iti ulo ti datonna ket patayenna daytoy iti sangoanan ti tabernakulo. Kalpasanna, iwarsi dagiti annak a lallaki ni Aaron dagiti darana kadagiti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Idaton ti tao dagiti daton para iti panagkakadua a kas daton a maipuor para kenni Yahweh. Ti taba, ti entero a nataba nga ipus a naputed iti asideg iti duri, ken ti taba a nangbalkot kadagiti lalaem ken amin dagiti taba nga asideg kadagiti lalaem, ");
INSERT INTO iloulb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ken dagiti dua a bekkel ken dagiti kimpet a taba nga adda kadagitoy nga adda iti lumo ken ti kasasayaatan a paset ti dalem, ken dagiti bekkel-ikatenna amin dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ket puoran ti padi amin dagitoy iti rabaw ti altar a kas taraon a daton a maipuor para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ket no kalding ti idaton ti tao, ket masapul nga idatonna daytoy iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Masapul nga ipatayna ti imana iti ulo ti kalding ket patayenna iti sangoanan ti tabernakulo. Kalpasanna, iwarsi dagiti annak a lallaki ni Aaron dagiti darana kadagiti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Idaton ti tao ti datonna a maipuor para kenni Yahweh. Ikkatenna ti taba a nangbalkot kadagiti lalaem ken amin a taba nga adda iti asideg dagiti lalaem. ");
INSERT INTO iloulb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Ikkatenna pay dagiti dua a bekkel ken ti kimpet a taba nga adda kadagiti lumo ken ti kasayaatan a paset ti dalem ken dagiti bekkel. ");
INSERT INTO iloulb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Puoran amin ti padi dagita iti rabaw ti altar a kas taraon a daton a maipuor a mangipaay iti nabanglo nga ayamuom. Amin a taba ket kukua ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Agnanayon daytoy a linteg kadagiti amin a henerasion dagiti tattaom iti amin a lugar a pagnaedanyo, a masapul a saankayo a mangan iti taba wenno dara.”' ");
INSERT INTO iloulb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nagsao ni Yahweh kenni Moises, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ibagam kadagiti tattao ti Israel, 'No agbasol ti siasinoman a saanna nga inggagara, a nangaramid iti aniaman kadagiti banbanag nga imbilin ni Yahweh a saana rumbeng nga aramiden, ken no nangaramid isuna ti aniaman a maiparit, masapul a maaramid dagiti sumaganad. ");
INSERT INTO iloulb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","No ti kangatoan a padi ti nagbasol ket mangiyeg iti biddut kadagiti tattao, ket bay-anyo isuna a mangidaton iti maysa a bumaro a baka nga awan mulitna kenni Yahweh a kas daton gapu iti basol a naaramidna. ");
INSERT INTO iloulb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Masapul nga ipanna ti bumaro a baka iti pagserkan ti tabernakulo iti sangoanan ni Yahweh, ipatayna ti imana iti ulo ti bumaro a baka, sana patayenna iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Mangala ti napulotan a padi iti dara ti bumaro a baka ket ipanna daytoy iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Isawsaw ti padi ti ramayna iti dara ket iwarsina iti maminpito a daras iti sangoanan ti kurtina ti kasasantoan a lugar, iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ket mangikabil ti padi iti dara kadagiti sinan-sara ti altar iti nabanglo nga insenso iti sangoanan ni Yahweh, nga adda iti tabernakulo, ken ibuyatna amin a natda a dara ti bumaro a baka iti sakaanan ti altar para kadagiti daton a maipuor amin, nga adda iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Putdenna amin a taba ti baka a daton a gapu iti basol, ti taba a nangbalkot kadagiti lalaem, amin a taba a nakakapet kadagiti lalaem, ");
INSERT INTO iloulb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","dagiti dua a bekkel ken ti nakakapet a taba kadagitoy, nga adda kadagiti lumo, ken ti kasayaatan a paset ti dalem, agraman dagiti bekkel—putdenna amin dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Putdenna amin dagitoy, a kas iti panangputedna manipud iti bumaro a baka a daton a pakikappia. Kalpasanna, puoran ti padi dagitoy a paset iti rabaw ti altar para kadagiti daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ti lalat ti bumaro a baka ken dagiti dadduma pay a nabati a karne, agraman ti ulona, dagiti luppona, dagiti lalaem, ti rugitna, ");
INSERT INTO iloulb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ken amin a natda a paset ti bumaro a baka—awitenna amin dagitoy a paset iti ruar ti kampo iti lugar a dinalusanda para kaniak, ti pangibukbukbokanda kadagiti dapo; puoranda dagitoy a paset idiay iti kayo. Masapul a puoranda dagitoy a paset idiay pangibukbbukokanda kadagiti dapo. ");
INSERT INTO iloulb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","No nagbasol ti sangkagimongan ti Israel a saanda nga inggagara, ken saan nga ammo ti sangkagimongan a nakabasolda ken nakaaramidda iti aniaman kadagiti banbanag nga imbilin ni Yahweh a saan koma a maaramid, ken no nagbiddutda, ");
INSERT INTO iloulb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ket, no maduktalan ti basol a naaramidda, masapul a mangidaton ti bumaro a baka ti sangkagimongan para iti daton a gapu iti basol ken ipanda daytoy iti sangoanan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Ipatay dagiti panglakayen ti sangkagimongan dagiti imada iti ulo ti bumaro a baka iti sangoanan ni Yahweh, ket patayenda ti baka iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ti napulotan a padi ket mangala iti dara ti bumaro a baka iti tabernakulo, ");
INSERT INTO iloulb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ket isawsaw ti padi ti ramayna iti dara ket iwarsina daytoy ti maminpito a daras iti sangoanan ti kurtina, iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Mangikabil isuna iti dara iti sinan-sara ti altar iti sangoanan ni Yahweh, nga adda iti tabernakulo, ket ibuyatna amin a dara iti sakaanan ti altar a para kadagiti daton a maipuor amin, nga adda iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Putdenna amin a taba manipud iti daytoy ken puoranna daytoy iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Dayta ti masapul nga aramidenna iti bumaro a baka. Kas iti inaramidna iti bumaro a baka a daton gapu iti basol, kasta met ti aramidenna iti daytoy a bumaro a baka, ket agaramid ti padi iti pangabbong para kadagiti tattao, ket mapakawandanto. ");
INSERT INTO iloulb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ipanna ti bumaro a baka iti ruar ti kampo ket puoranna daytoy a kas iti panangpuorna iti immuna a bumaro a baka. Daytoy ti daton a gapu iti basol para iti sangkagimongan. ");
INSERT INTO iloulb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","No agbasol ti maysa a mangiturturay a saanna nga inggagara, a nangaramid ti maysa kadagiti banbannag nga imbilin ni Yahweh a Diosna a saan rumbeng a maaramid, ken no nagbiddut isuna, ");
INSERT INTO iloulb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ket, no maamirisna ti naaramidna a basol, masapul a mangiyeg isuna iti maysa a kalakian a kalding nga awan ti mulitna para iti datonna. ");
INSERT INTO iloulb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ipatayna ti imana iti ulo ti kalding sana patayenna daytoy iti lugar a pangpatpatayanda iti daton a maipuor amin iti sangoanan ni Yahweh. Daytoy ket daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Alaen ti padi ti dara ti daton a gapu iti basol babaen kadagiti ramayna ket ikabilna daytoy kadagiti sinan-sara ti altar a para kadagiti daton a maipuor amin, ket ibuyatna ti dara daytoy iti sakaanan ti altar ti daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Puoranna amin a taba iti rabaw ti altar, a kas iti taba dagiti daton a pakikappia. Agaramid ti padi iti pangabbong para ti mangiturturay maipapan iti basolna, ket mapakawanto ti mangiturturay. ");
INSERT INTO iloulb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","No maysa kadagiti kadawyan a tao ti nagbasol a saanna nga inggagara, a nangaramid iti aniaman kadagiti banbannag nga imbilin ni Yahweh a saan nga aramiden, ket no nagbiddut isuna, ");
INSERT INTO iloulb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ket no maamirisna ti naaaramidna a basol, masapul a mangala isuna ti maysa a kalding para iti datonna, maysa a kabaian a kalding nga awan mulitna, para iti basol a naaramidna. ");
INSERT INTO iloulb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ipatayna ti imana iti ulo ti daton a gapu iti basol ket patayenna daytoy iti lugar ti daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mangala ti padi iti dara babaen ti ramayna ket ikabilna daytoy kadagiti sinan-sara ti altar para kadagiti daton a maipuor amin. Ibuyatna amin a natda a dara iti sakaanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Putdenna amin a taba, a kas iti pannakaputed dagiti taba kadagiti daton a pakikappia. Puoran daytoy ti padi iti rabaw ti altar a mangipaay ti nabanglo nga ayamuom para kenni Yahweh. Mangaramid ti padi iti pangabbong para iti dayta a tao, ket mapakawanto isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","No mangiyeg ti tao iti urbon a karnero a kas datonna para iti basol, mangiyeg isuna iti kabaian nga awan mulitna. ");
INSERT INTO iloulb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ipatayna ti imana iti ulo ti daton a gapu iti basol ket patayenna daytoy para iti daton a gapu iti basol iti lugar a pangpatpatayanda iti daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Mangala ti padi iti dara ti daton a gapu iti basol babaen iti ramayna ket ikabilna daytoy kadagiti sinan-sara ti altar a para kadagiti daton a maipuor amin, ket ibuyatna amin a natda a dara iti sakaanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Putdenna amin a taba, a kas iti pannakaputed dagiti taba ti urbon a karnero manipud iti daton a pakikappia, ket puoran daytoy ti padi iti altar iti rabaw dagiti daton a maipuor para kenni Yahweh. Agaramid ti padi iti pangabbong para kenkuana iti naaramidna a basol, ket mapakawanto dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","No agbasol ti siasinoman gapu ta saanna a paneknekan ti maipanggep iti maysa a banag a nasaksianna a kasapulan a paneknekanna, nakitana man daytoy wenno nangngeganna, pagrebbengannanto daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Wenno, no makasagid ti siasinoman iti aniaman nga imbilang ti Dios a kas narugit, natay man a bagi daytoy ti narugit nga atap nga ayup wenno natay a bagi iti aniaman kadagiti dingwen, wenno agkarkarayam nga ayup, uray no saan nga inggagara ti tao a sagiden daytoy, narugit isuna ken nagbiddut. ");
INSERT INTO iloulb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Wenno, no masagidna ti kinarugit ti maysa a tao, aniaman dayta a kinarugit, ken no saanna nga ammo daytoy, ket makabasolto isuna inton maammoanna ti maipanggep iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Wenno, no dagdagus nga agkari ti siasinoman kadagiti bibigna nga agaramid iti dakes wenno naimbag, aniaman daytoy a dagdagus nga ikarkari ti tao babaen iti maysa a sapata, uray no saanna nga ammo daytoy, inton maammoanna ti maipanggep iti daytoy, ket makabasolto isuna iti aniaman kadagitoy a banbanag. ");
INSERT INTO iloulb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","No ti maysa a tao ket nakabasol iti aniaman kadagitoy a banbanag, masapul nga ipudnona ti aniaman a nagbasolanna. ");
INSERT INTO iloulb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ket masapul nga iyegna ti daton a pangsupapak ti biddutna kenni Yahweh gapu iti nagbasolanna, maysa a kabaian nga ayup manipud iti arban, karnero man wenno kalding, para iti daton a gapu iti basol, ket mangaramidto ti padi iti pangabbong para kenkuana maipapan iti basolna. ");
INSERT INTO iloulb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","No saanna a kabaelan ti gumatang iti kordero, ket mabalinna ti mangiyeg iti dua a kalapati wenno dua a sibong a pagaw a kas daton a pangsupapak ti biddutna kenni Yahweh, maysa para iti daton a gapu iti basol ken ti maysa para iti daton a mapuoran. ");
INSERT INTO iloulb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Masapul nga iyegna dagitoy iti padi, nga isu ti mangidaton iti daton a gapu iti basol nga umuna - tiritirenna ti ulo daytoy manipud iti tengnged ngem saanna nga ikkaten a naan-anay manipud iti bagi. ");
INSERT INTO iloulb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kalpasanna, iwarsina dagiti dadduma a dara iti daton a gapu iti basol iti sikigan ti altar, ken ipaaruyotna ti nabati a dara iti sakaanan ti altar. Daytoy ket daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Kalpasanna, masapul nga idatonna ti maikadua a billit a kas daton a mapuoran amin, a kas nailadawan kadagiti bilbilin, ken mangaramid ti padi ti pangabbong para kenkuana gapu iti nagbasolanna, ket mapakawanto ti tao. ");
INSERT INTO iloulb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ngem no saanna a kabaelan ti gumatang iti dua a kalapati wenno dua a sibong a pagaw, ket masapul a mangiyeg isuna a kas maisagot para iti basolna iti apagkapullo ti maysa nga efa iti napino nga arina para iti daton a gapu iti basolna. Masapul a saanna daytoy a laokan iti lana wenno aniaman nga insenso, gapu ta daytoy ket daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Masapul nga iyegna daytoy iti padi, ket mangala ti padi iti sangarakem iti daytoy kas siyayaman isuna a mangpanpanunot iti kinaimbag ni Yahweh ket kalpasanna, puoranna daytoy iti rabaw ti altar, iti rabaw dagiti datdaton a mapuoran a para kenni Yahweh. Daytoy ket maysa a daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Mangaramid ti padi iti pangabbong para iti aniaman a basol a naaramid dayta a tao, ket mapakawanto dayta a tao. Dagiti matda manipud iti daton ket kukua ti padi, a kas iti daton a bukbukel.” ");
INSERT INTO iloulb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ket nagsao ni Yahweh kenni Moises a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“No aglabsing ti siasinoman iti bilin ken agbasol maibusor kadagiti banbanag a kukua ni Yahweh, ngem saanna nga inggagara nga inaramid, ket masapul nga iyegna ti datonna a pangsupapak iti biddut kenni Yahweh. Daytoy a daton ket masapul a maysa a kalakian a karnero nga awan ti mulitna manipud iti arban; ti gatadna ket masapul a maikeddeng babaen kadagiti siklo ti pirak - ti siklo iti santuario - a kas daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Masapul a maay-ayona ni Yahweh gapu ti naaramidna a saan a nasayaat maipanggep iti aniaman a nasantoan, ken masapul a nayunanna daytoy ti apagkalima ket itedna daytoy iti padi. Kalpasanna, mangaramid ti padi iti pangabbong para kenkuana babaen iti panangidaton iti kalakian a karnero a daton a pangsupapak iti biddut, ket mapakawanto dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","No agbasol ti siasinoman ken agaramid iti aniaman a banag nga imbilin ni Yahweh a saan a rumbeng nga aramiden, uray no saanna nga ammo daytoy, nagbiddut latta isuna ket masapul a baklayenna ti nagbiddutanna. ");
INSERT INTO iloulb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Masapul a mangiyeg isuna iti ayan ti padi iti kalakian a karnero nga awan mulitna manipud iti arban, a magatadan iti agdama a gatad, a kas daton a pangsupapak iti biddut. Ket mangaramidto ti padi iti pangabbong para kenkuana maipapan iti basol a naaramidna, a saanna nga ammo, ket mapakawanto isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Daytoy ket daton a pangsupapak iti biddut, ken pudno a nagbiddut isuna iti sangoanan ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Nagsao ni Yahweh kenni Moises, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“No agbasol ti siasinoman ken aglabsing iti linteg a maibusor kenni Yahweh, kas iti panaglibak iti kaarubana maipapan iti maysa a banag a naitalek kenkuana, wenno no kaurenna wenno takawanna isuna, wenno indadanesna ti kaarubana, ");
INSERT INTO iloulb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","wenno nakabirok iti maysa a banag a napukaw ti kaarubana ken ilibakna ti maipanggep iti daytoy, ket pagsapataanna ti inuulbod, wenno kadagiti kastoy a banbanag a pagbasolan dagiti tattao, ");
INSERT INTO iloulb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ket mapasamakto, no nagbasol isuna ken nagbiddut, a masapul nga isublina ti aniaman nga innalana babaen iti panagtakaw wenno panangidadanes wenno panangtagikua iti naitalek kenkuana wenno ti nabirukanna a banag a napukaw. ");
INSERT INTO iloulb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Wenno no nagulbod isuna iti maipanggep iti aniaman a banag, masapul nga isublina a naan-anay daytoy ken masapul a nayunanna pay ti apagkalima tapno ibayadna iti akinkukua, iti aldaw a natakuatan a nagbiddut isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ket masapul nga iyegna ti datonna a pangsupapak iti biddut kenni Yahweh: maysa a kalakian a karnero nga awan mulitna manipud iti arban a magatadan ti agdama a gatad, a kas maysa a daton a pangsupapak iti biddut iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mangaramidto ti padi ti pangdabbong para kenkuana iti sangoanan ni Yahweh, ket mapakawanto isuna maipapan iti aniaman a nagbiddutanna nga inaramid. ");
INSERT INTO iloulb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ket nagsao ni Yahweh kenni Moises, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Bilinem ni Aaron ken dagiti annakna a lallaki, a kunaem, 'Daytoy ti linteg iti daton a maipuor amin: 'Ti daton a maipuor amin ket masapul nga adda iti pagapuyan ti altar iti agpatnag agingga iti agsapa, ket agtalinaedto a sumsumged ti apuy ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ikawesto ti padi dagiti lino a pagan-anayna ken kasta met nga ikawesnanto dagiti pang-uneg a lino a pagan-anayna. Akupennanto dagiti dapo kalpasan nga inuram ti apuy ti daton a maipuor amin iti rabaw ti altar, ket ikabilnanto dagiti dapo iti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ussubennanto dagiti pagan-anayna ket mangikawes isuna iti sabali a pagan-anay a mangiruar iti dapo iti kampo iti maysa a nadalus a lugar. ");
INSERT INTO iloulb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Agtalinaedto a sumsumged ti apuy iti altar. Masapul a saan a maiddep daytoy, ken sungrodan ti padi ti apuy iti tunggal agsapa. Simpaennanto ti daton a maipuor amin iti rabawna a kas kasapulan iti daytoy, ket ipuornanto iti daytoy ti taba dagiti daton a pakikappia. ");
INSERT INTO iloulb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Masapul a mapagtalinaed a sumsumged ti apuy iti rabaw ti altar. Masapul a saan a maiddep daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Daytoy ti linteg iti daton a bukbukel. Idatonto daytoy dagiti annak a lallaki ni Aaron iti sangoanan ni Yahweh iti sangoanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mangalanto ti padi iti sangarakem iti napino nga arina iti daton a bukbukel ken iti lana ken ti insenso a nakaparabaw iti daton a bukbukel, ket puorannanto daytoy iti rabaw ti altar tapno mangparnuay iti nabanglo nga ayamuom kas siyayaman isuna a mangpanpanunot iti kinaimbag ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kanento ni Aaron ken dagiti annakna a lallaki ti aniaman a matda iti daton. Masapul a kanenda nga awan lebadurana daytoy iti nasantoan a disso. Kanendanto daytoy iti paraangan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Masapul a saan a mailuto daytoy nga adda iti lebadurana. Intedko daytoy a kas bingayda kadagiti datonko a mapuoran. Daytoy ket kasasantoan, a kas iti daton gapu iti basol ken iti daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Iti amin a tiempo nga umay iti entero a henerasion dagiti tattaoyo, siasinoman a lalaki nga agtaud kenni Aaron ket mabalin a mangan iti daytoy a kas bingayna, a naala manipud kadagiti daton a mapuoran kenni Yahweh. Siasinoman a mangsagid kadagitoy ket agbalinto a nasantoan.'” ");
INSERT INTO iloulb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Isu a nagsao manen ni Yahweh kenni Moises, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Daytoy ti daton ni Aaron ken dagiti annakna a lallaki, nga idatondanto kenni Yahweh iti aldaw a mapulotan ti tunggal putotna a lalaki: apagkapullo a paset ti maysa nga efa ti kasayaatan nga arina a kas kadawyan a daton a bukbukel, kagudua iti daytoy iti agsapa ken kagudua iti daytoy iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Mailutonto daytoy iti pariok nga adda ti lanana. Inton naan-anayen a nabasa daytoy, ipanmonto daytoy iti uneg. Iti napidapidaso a naluto a daton a bukbukel ket idantonmonto daytoy tapno mangparnuay ti nabanglo nga ayamuom a para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ti anak a lalaki ti kangatoan a padi nga agbalinto a barbaro a kangatoan a padi manipud kadagiti putotna a lallaki ti mangidatonto iti daytoy. Kas naibilin iti agnanayon, amin dagitoy ket mapuoranto a maipaay kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ti tunggal daton a bukbukel iti padi ket mapuoranto a naan-anay. Masapul a saan a kanen daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Nagsao manen ni Yahweh kenni Moises, a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Agsaoka kenni Aaron ken kadagiti annakna a lallaki, a kunaem, “Daytoy ti linteg iti daton a gapu iti basol. Masapul a mapapatay ti daton a gapu iti basol iti lugar a pangpatpatayan ti daton a mapuoran iti sangoanan ni Yahweh. Daytoy ket kasasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ti padi a mangidaton iti daytoy a para iti basol ket kanennanto daytoy. Masapul a makan daytoy iti nasantoan a disso iti paraangan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Aniaman a maisagid iti karnena ket agbalinto a nasantoan, ken no maiparsiak ti dara iti aniaman a lupot, masapul a labaanyo daytoy, ti paset a naparsiakan, iti nasantoan a disso. ");
INSERT INTO iloulb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ngem ti dinamili a banga a nakaipaburekanna ket masapul a maburak. No naipaburek daytoy iti bronse a banga, masapul a marasrasan ken mabuggoan daytoy iti nadalus a danum. ");
INSERT INTO iloulb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Siasinoman a lalaki kadagiti papadi ket mabalin a mangan iti daytoy gapu ta daytoy ket kasasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ken awan ti daton a gapu iti basol ti mabalin a kanen a ti darana ket naiserrek iti tabernakulo a mangaramid iti seremonia ti pannakadalus iti nasantoan a disso. Masapul a mapuoran daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Daytoy ti linteg iti daton a pangsupapak iti biddut. Kasasantoan daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Masapul a papatayenda ti daton a pangsupapak ti biddut iti disso a pangpatpatayanda iti daytoy, ken masapul nga iwarsida ti darana iti tunggal sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Amin a taba iti daytoy ket maidatonto; ti nalukmeg nga ipus, ti taba a nangbalkot kadagiti lalaem, ");
INSERT INTO iloulb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ti dua a bekkel ken ti taba nga adda kadakuada, a kaabay ti lumo, ken ti mangbalbalkot ti dalem, agraman kadagiti bekkel - masapul a maikkatto amin daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Masapul a puoran ti padi dagitoy a paset iti rabaw ti altar a kas maysa a daton a mapuoran para kenni Yahweh. Daytoy ti daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tunggal lalaki kadagiti papadi ket mabalin a mangan iti daytoy a daton. Masapul a kanenda daytoy iti nasantoan a disso gapu ta kasasantoan daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ti daton a gapu iti basol ket kas met laeng iti daton a pangsupapak iti biddut. Agpada a linteg ti maaramat kadagitoy a dua. Kukua ida ti padi a mangar-aramid iti seremonia ti panangabbong kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ti padi a mangidaton iti daton a maipuor amin a kukua ti maysa a tao ket mabalinna nga alaen ti lalat dayta daton a para iti bagina. ");
INSERT INTO iloulb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tunggal daton a bukbukel a nailuto iti horno, ken tunggal kasta a daton a nailuto iti pariok wenno iti bandeha ti horno ket kukuanto ti padi a mangidaton iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tunggal daton a bukbukel, namaga man wenno nalaokan iti lana, ket agpapadanto a kukua dagiti amin a kaputotan ni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Daytoy ti linteg iti daton a pakikapia nga idatonto dagiti tattao kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","No idaton ti siasinoman daytoy tapno agyaman, masapul ngarud nga idatonna daytoy a buyugen ti sakripisio a tinapay a naaramid nga awan lebadurana, ngem nalaokan iti lana, ti tinapay a naaramid nga awan lebadurana, ngem napulagidan iti lana, ken ti tinapay a naaramid manipud iti kasasayaatan nga arina a nalaokan iti lana. ");
INSERT INTO iloulb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kasta met, maipaay iti panagyaman, masapul nga idatonna a kadua ti datonna a pakikapia ti tinapay a naaramid nga adda ti lebadurana. ");
INSERT INTO iloulb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Masapul a mangidaton isuna iti maysa ti tunggal kita dagitoy a sakripisio a kas daton a maidatag kenni Yahweh. Kukuanto daytoy dagiti papadi a nangiwarsi iti dara dagiti daton a pakikapia iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ti tao a mangidatag iti daton a pakikapia a maipaay iti panagyaman ket masapul a kanenna ti karne ti datonna iti aldaw ti panangidatonna. Masapul a saan isuna a mangibati iti aniaman iti daytoy agingga iti sumaruno a bigat. ");
INSERT INTO iloulb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ngem no ti datonna ket para iti panangtungpalna iti maysa a sapata, wenno daton a nagtaud iti bukodna a nakem, ti karne ket masapul a makan iti aldaw iti panangidatonna, ngem aniaman a matda iti daytoy ket mabalinto a kanen iti sumaruno nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nupay kasta, aniaman a karne a mabati iti daton iti maikatlo nga aldaw ket masapul a mapuoran. ");
INSERT INTO iloulb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","No ti aniaman a karne iti daton a pakikappia ti maysa a tao ket nakan iti maikatlo nga aldaw, saanto a maawat daytoy, wenno saanto a maibilang daytoy iti nangidaton. Makarimonto daytoy a banag, ket ti tao a nangan iti daytoy ket ikaronanto ti nagbasolanna. ");
INSERT INTO iloulb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Aniaman a karne a maisagid iti narugit a banag ket masapul a saan a kanen. Masapul a mapuoran daytoy. Maipanggep kadagiti dadduma a karne, ti siasinoman a nadalus ket mabalin a mangan iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nupay kasta, ti maysa a tao a narugit a mangan iti aniaman a karne manipud iti daton a pakikapia a kukua ni Yahweh - dayta a tao ket masapul a mailaksid manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","No masagid ti siasinoman ti aniaman a narugit a banag - kinarugit man daytoy ti tao, wenno ti narugit nga ayup, wenno iti aniaman a narugit ken makarimon a banag, ket no mangan isuna iti karne iti daton a pakikapia a kukua ni Yahweh, dayta a tao ket masapul a mailaksid manipud kadagiti tattaona.” ");
INSERT INTO iloulb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ket nagsao ni Yahweh kenni Moises a kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Kasaritam dagiti tattao ti Israel ket ibagam, 'Masapul a saankayo a mangan iti taba ti baka wenno karnero wenno kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ti taba ti maysa nga ayup a natay a saan a naisakripisio, wenno ti taba ti ayup a rinangrangkay dagiti naaatap nga ayup, ket mabalin a maaramat para iti sabali a pakaipaayanna, ngem masapul a saanyonto pulos a kanen daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ti siasinoman a mangan iti taba ti maysa nga ayup a mabalin nga idaton dagiti tattao kenni Yahweh a kas daton a maipuor, dayta a tao ket masapul a mailaksid kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Masapul a saankayo a mangan iti aniaman a dara iti sadinoman iti balayyo, nagtaud man daytoy iti billit wenno ayup. ");
INSERT INTO iloulb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ti siasinoman a mangan iti aniaman a dara, dayta a tao ket masapul a mailaksid manipud kadagiti tattaona.”' ");
INSERT INTO iloulb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Isu a nagsao ni Yahweh kenni Moises ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Kasaritam dagiti tattao ti Israel ket ibagam, 'Ti mangidatag iti daton a pakikapia kenni Yahweh ket masapul a mangiyeg iti paset iti sakripisiona kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ti daton a mapuoran a para kenni Yahweh ket masapul nga iyegna babaen kadagiti bukodna nga ima. Masapul nga iyegna ti taba agraman ti barukong, tapno ti barukong ket agabalinto a daton a maitag-ay iti sangoanan ni Yahweh ken maidatag kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Masapul a puoran ti padi ti taba iti rabaw ti altar, ngem ti barukong ket kukuanto ni Aaron ken dagiti kaputotanna. ");
INSERT INTO iloulb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Masapul nga itedyo iti padi ti makannawan a luppo a kas maysa a daton a maidatag manipud kadagiti datonyo a pakikapia. ");
INSERT INTO iloulb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ti padi, a maysa kadagiti kaputotan ni Aaron, a mangidaton ti dara dagiti daton a pakikapia ken ti taba - maitedto kenkuana ti makannawan a luppo a kas bingayna manipud iti daton. ");
INSERT INTO iloulb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ta innalak ti daton a barukong ken luppo a naitag-ay ken naidatag kaniak, ket intedko dagitoy kenni Aaron, ti kangatoan a padi, ken kadagiti kaputonanna; kankanayonto a daytoy ti bingayda manipud kadagiti daton a pakikapia nga aramiden dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Daytoy ti bingay a para kenni Aaron ken dagiti kaputotanna manipud kadagiti daton a maipuor a para kenni Yahweh, iti aldaw nga indatag ni Moises ida nga agserbi kenni Yahweh iti saad a kinapadi. ");
INSERT INTO iloulb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Daytoy ti bingay nga imbilin ni Yahweh a maited kadakuada a naggapu kadagiti tattao ti Israel, iti aldaw a pinulotanna dagiti papadi. Kankanayonto daytoy a bingayda iti amin a henerasion. ");
INSERT INTO iloulb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Daytoy ti linteg ti daton a maipuor amin, ti daton a bukbukel, ti daton a gapu iti basol, ti daton a pangsupapak iti biddut, ti daton a para iti panakakonsagrar, ken dagiti daton a pakikapia, ");
INSERT INTO iloulb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","nga imbilin ni Yahweh kenni Moises iti Bantay Sinai iti aldaw nga imbilinna kadagiti tattao ti Israel nga idatonda dagiti sakripisoda kenni Yahweh iti let-ang ti Sinai.”' ");
INSERT INTO iloulb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nagsao ni Yahweh kenni Moises, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ikuyogmo ni Aaron a kaduana dagiti annakna, dagiti kawes ken ti pangpulot a lana, ti kalakian a baka a daton a gapu iti basol, dagiti dua a kalakian a karnero, ken ti basket ti tinapay nga awan lebadurana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ummongem ti amin a sangkagimongan iti pagserkan iti tabernakulo.” ");
INSERT INTO iloulb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Inaramid ngarud ni Moises kas imbilin ni Yahweh kenkuana, ket immay a sangsangkamaysa ti sangkagimongan iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Kalpasanna, kinuna ni Moises iti sangkagimongan, “Daytoy ti imbilin ni Yahweh a rumbeng a maaramid.” ");
INSERT INTO iloulb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Intugot ni Moises ni Aaron ken dagiti annakna ken binuggoanna isuda iti danum. ");
INSERT INTO iloulb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Inkabilna kenni Aaron ti tunika ken inggalotna ti barikes iti siketna, kinawesanna isuna iti kagay ken insuotna ti efod kenkuana, ken kalpasanna, pinairutanna ti efod babaen iti barikes a nasayaat iti pannakaabelna ken inbedbedna kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Inkabilna ti pektoral kenkuana, ken inkapetna ti Urim ken Tummim iti pektoral. ");
INSERT INTO iloulb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Inkabilna ti turban iti ulona, ken iti sango ti turban, inkabilna ti balitok a plato, ti nasantoan a korona, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Innala ni Moises ti pangpulot a lana, ket pinulotanna ti tabernakulo ken amin a banag nga adda iti unegna, ket indatonna dagitoy kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Winarsianna ti lana ti altar iti naminpito a daras, ken pinulotanna ti altar ken amin nga alikamenna, ken ti pagbuggoan a palanggana ken ti pagbatayanna, tapno idatonna dagitoy kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Imbukbokna ti dadduma a pangpulot a lana iti ulo ni Aaron ken pinulotanna isuna tapno maidaton isuna kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Inyeg ni Moises dagiti putot a lallaki ni Aaron ken kinawesanna isuda kadagiti tunika; binarikesanna isuda ken pinutipotanna iti lino a lupot dagiti uloda, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Innala ni Moises ti kalakian a baka a maidaton a gapu iti basol, ken impatay ni Aaron ken dagiti putotna a lallaki dagiti imada iti ulo ti kalakian a baka nga inyegda a maidaton para iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Pinatayna daytoy, ket innalana ti dara ken impulagidna daytoy iti sinan-sara iti altar babaen iti ramayna, dinalusanna ti altar, imbukbokna ti dara iti puon ti altar, ket inlasinna daytoy para iti Dios a pangaramidan iti pangabbong iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Innalana dagiti amin a taba nga adda kadagiti lalaem, ti balkot iti dalem, ken dagiti dua a bekkel ken dagiti tabada, ket pinuoran amin ni Moises dagitoy iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ngem ti bulog a baka, ti lalatna, ti karnena ken dagiti rugitna ket pinuoranna iti ruar ti kampo, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Indatag ni Moises ti kalakian a karnero a para iti daton a mapuoran amin, ket impatay ni Aaron ken dagiti putotna a lallaki dagiti imada iti ulo ti kalakian a karnero. ");
INSERT INTO iloulb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Pinatayna daytoy ket imbuyatna ti dara kadagiti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Rinangrangkayna ti kalakian a karnero ken pinuoranna ti ulo ken dagiti narangkay ken ti taba. ");
INSERT INTO iloulb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Binuggoanna iti danum dagiti lalaem ken saksaka, ket pinuoranna ti sibubukel a kalakian a karnero iti rabaw ti altar. Daytoy ket daton a maipuor amin ken nangparnuay iti nabanglo nga ayamuom, maysa a daton a mapuoran para kenni Yahweh kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kalpasanna, indatag ni Moises ti maysa pay a kalakian a karnero, ti kalakian a karnero a para iti pannakakonsagrar, ket impatay ni Aaron ken dagiti putotna a lallaki dagiti imada iti ulo iti kalakian a karnero. ");
INSERT INTO iloulb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Pinatay ni Aaron daytoy, nangala ni Moises iti darana ket impulagidna iti murdong iti makannawan a lapayag ni Aaron, iti makannawan a tangan iti imana, ken iti dakkel a ramay ti makannawan a sakana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Innalana dagiti putot a lallaki ni Aaron, ket impulagidna ti dara kadagiti murdong ti makannawan a lapayagda, iti tangan ti makannawan nga ima ken sakada. Kalpasanna, imbuyat ni Moises ti dara kadagiti sikigan iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Innalana ti taba, ti nataba nga ipus, dagiti amin a taba nga adda kadagiti lalaem, ti balkot iti dalem, ti dua a bekkel ken ti tabada, ken ti makannawan a luppo. ");
INSERT INTO iloulb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Manipud iti basket ti tinapay nga awan ti lebadurana a naidaton iti sangoanan ni Yahweh, nangala isuna iti maysa a tinapay nga awan lebadurana, ken maysa a tinapay a nalanaan, ken maysa a naingpis a tinapay, ket imparabawna dagitoy iti taba ken iti makannawan a luppo. ");
INSERT INTO iloulb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Inkabilna amin dagitoy iti ima ni Aaron ken kadagiti ima dagiti putotna a lallaki, intag-ayda dagitoy a kas daton iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kalpasanna, innala ni Moises dagitoy manipud kadagiti imada ket pinuoranna dagitoy iti rabaw ti altar para iti daton a maipuor amin. Dagitoy ket daton ti pannakakonsagrar ken nangparnuay iti nabanglo nga ayamu-om. Daytoy ket daton a maipuor kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Innala ni Moises ti barukong ti ayup ket intag-ayna daytoy a kas daton kenni Yahweh. Daytoy ti bingay ni Moises iti kalakian a karnero para iti pannakadutok dagiti papadi, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Nangala ni Moises iti bassit a pangpulot a lana ken dara nga adda iti rabaw ti altar; inwarsina dagitoy kenni Aaron, kadagiti kawesna, kadagiti putotna, ken kadagiti kawes dagiti putotna a kaduana. Iti kastoy a wagas, indatonna ni Aaron ken dagiti kawesna, ken dagiti putotna ken dagiti kawkawesda kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Isu a kinuna ni Moises kenni Aaron ken kadagti annakna a lallaki, “Angerenyo ti karne iti pagserkan ti tabernakulo, ket kanenyo sadiay dagitoy agraman ti tinapay nga adda iti basket iti pannakakonsagrar, kas imbilinko, kinunana, 'Kanen daytoy ni Aaron ken dagiti putotna.' ");
INSERT INTO iloulb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ti aniaman a matda iti karne ken iti tinapay ket masapul a puoranyo. ");
INSERT INTO iloulb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ken masapul a saankayo a pumanaw iti pagserkan ti tabernakulo iti pito nga aldaw, inggana iti aldaw a malpas ti pannakakonsagraryo. Ta konsagrarannakayo ni Yahweh iti uneg iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ti naaramid ita nga aldaw - ket imbilin ni Yahweh a maaramid tapno maabbongan dagiti basbasolyo. ");
INSERT INTO iloulb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Agtalinaedkayo iti aldaw ken rabii iti las-ud iti pito nga aldaw idiay pagserkan ti tabernakulo, ken salimetmetanyo ti bilin ni Yahweh, tapno saankayo a matay, gapu ta daytoy ti naibilin kaniak.” ");
INSERT INTO iloulb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Inaramid ngarud ni Aaron ken dagiti putotna a lallaki dagiti amin a banag nga imbilin ni Yahweh kadakuada babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Iti maikawalo nga aldaw, inayaban ni Moises ni Aaron ken dagiti putotna a lallaki ken dagiti panglakayen iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Kinunana kenni Aaron, “Mangalaka iti urbon a baka manipud iti arban nga agpaay a kas daton a gapu iti basol, ken maysa a kalakian a karnero nga awan mulitna para iti daton a maipuor amin, ket idatonmo dagitoy iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Masapul a makisaritaka kadagiti tattao ti Israel ket ibagam, 'Mangalakayo iti kalakian a kalding para iti daton a gapu iti basol ken maysa nga urbon a baka ken maysa a karnero, agpada a maysa ti tawenna ken awan iti mulitna, a para iti daton a maipuor amin; ");
INSERT INTO iloulb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","mangalakayo pay iti kalakian a baka ken kalakian a karnero para ti daton a pakikapia a maidaton iti sangoanan ni Yahweh, ken daton a bukbukel a nailaok iti lana, gapu ta agparang ni Yahweh kadakayo ita nga aldaw.'” ");
INSERT INTO iloulb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Inyegda ngarud dagiti amin nga imbilin ni Moises iti uneg ti tabernakulo, ken immasideg ti sangkagimongan ti Israel ken nagtakderda iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kalpasanna, kinuna ni Moises “Kastoy ti imbilin ni Yahweh nga aramidenyo tapno agparang ti dayagna kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kinuna ni Moises kenni Aaron, “Umasidegka iti altar ket idatonmo ti daton a gapu iti basolmo ken ti daton a maipuor amin, ket mangaramidka iti pangabbong iti basolmo ken kadagiti basbasol dagiti tattao, ken idatonmo ti daton a para kadagiti tattao tapno maabbongan dagiti basolda, a kas imbilin ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Isu nga immasideg ni Aaron iti altar ket pinatayna ti urbon a baka a para iti daton a gapu iti basol, a para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Indatag dagiti putot ni Aaron kenkuana ti dara ti ayup, ket insawsawna ti ramayna iti daytoy ket impulagidna kadagiti sinan-sara iti altar; ken imbukbokna ti dara iti sakaanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nupay kasta, pinuoranna ti taba, dagiti bekkel, ken ti nangbalkot iti dalem iti rabaw ti altar a kas daton gapu iti basol, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ken pinuoranna dagiti karne ken ti lalat iti ruar iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Pinatay ni Aaron ti daton a maipuor amin, ket inted dagiti putotna a lallaki ti dara kenkuana, nga imbuyatna kadagiti sikigan iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Kalpasanna, intedda kenkuana ti daton a mapuoran, a pidapidaso, agraman ti ulo, ket pinuoranna dagitoy iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Binuggoanna dagiti lalaem ken dagiti luppo ken pinuoranna dagitoy iti rabaw ti daton a maipuor amin iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Indatag ni Aaron ti daton dagiti tattao-maysa a kalding, kalpasanna, innalana daytoy ken pinatayna a kas daton para kadagiti basbasolda; indatonna daytoy gapu iti basol, kas iti inaramidna iti umuna a kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Indatagna ti daton a maipuor amin ket indatonna daytoy kas imbilin ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Indatagna ti daton a bukbukel; nangrakem isuna iti daytoy ken pinuoranna daytoy iti rabaw ti altar, a nainayon iti daton a maipuor amin iti agsapa. ");
INSERT INTO iloulb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pinatayna pay ti kalakian a baka ken ti kalakian a karnero, ti daton ti pakikapia, a para kadagiti tattao. Inted dagiti putot a lallaki ni Aaron ti dara kenkuana, nga imbuyatna kadagiti sikigan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Nupay kasta, ti taba ti kalakian a baka ken ti kalakian a karnero, ti nataba nga ipus, ti taba a nangbalkot iti lalaem, dagiti bekkel, ken ti nangbalkot iti dalem- ");
INSERT INTO iloulb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","imparabawda dagitoy kadagiti barukong ti ayup, ket kalpasanna, pinuoran ni Aaron ti taba iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Intag-ay ni Aaron ti barukong ti ayup ken ti makannawan a luppo a kas daton iti sangoanan ni Yahweh, ken indatagna dagitoy kenkuana, a kas imbilin ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kalpasanna, intag-ay ni Aaron dagiti imana nga agturong kadagiti tattao ket binendissionanna ida; kalpasanna, bimmaba isuna manipud iti nangidatonanna ti daton a gapu iti basol, iti daton a maipuor amin, ken iti daton iti pakikapia. ");
INSERT INTO iloulb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Napan da Moises ken Aaron iti tabernakulo, kalapasanna, rimmuarda met laeng ken binendissionanda dagiti tattao, ket nagparang ti dayag ni Yahweh kadagiti amin a tattao. ");
INSERT INTO iloulb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Adda apuy a nagtaud kenni Yahweh ket pinuoranna a naan-anay ti daton a maipuror amin ken ti taba iti rabaw ti altar. Idi nakita dagiti amin a tattao daytoy, nagpukkawda ken nagpaklebda iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Innala ni Nadab ken Abiu, a putot a lallaki ni Aaron, ti saggaysada a pagpuoran ti insenso, nangpasgedda iti apuy iti daytoy, ken inikkanda daytoy iti insenso. Kalpasanna, nangidatonda iti apuy a saan a naanamongan iti sangoanan ni Yahweh, a saanna nga imbilin kadakuada nga idatonda. ");
INSERT INTO iloulb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Isu nga adda timmaud nga apuy manipud iti sangoanan ni Yahweh ket pinuoranna ida, ket natayda iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ket kinuna ni Moises kenni Aaron, “Daytoy ti sarsaritaen ni Yahweh idi imbagana, “Ipakitakto ti kinasantok kadagiti umasideg kaniak. Maitan-okakto iti sangoanan dagiti amin a tattao.'” Awan a pulos ti imbaga ni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Inayaban ni Moises ni Misael ken ni Elisafan, dagiti putot a lallaki ni Uzziel nga uliteg ni Aaron, ket kinunana kadakuada, “Umaykayo ditoy ket iruaryo dagiti kakabsatyo a lallaki iti kampo manipud iti sangoanan ti tabernakulo.” ");
INSERT INTO iloulb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Isu nga immasidegda ket inawit ken inruarda ida iti kampo, a nakakawes pay laeng iti tunika ti kinapadi, a kas imbilin ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kalpasanna, kinuna ni Moises kenni Aaron ken kadagiti putotna a lallaki a da Eleazar ken Itamar, “Saanyo nga iwakray dagiti buok dagiti uloyo, ken saanyo a pigisen dagiti badoyo, tapno saankayo a matay, ken tapno saan a makaunget ni Yahweh iti sangkagimongan. Ngem palubosanyo dagiti kakabagianyo, dagiti amin nga agnanaed iti Israel, nga agladingit para kadagidiay a pinuoran ti apuy ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Masapul a saankayo a rumuar iti pagserkan ti tabernakulo, ta no aramidenyo dayta ket mataykayo, ta adda kadakayo ti pangpulot a lana ni Yahweh.” Inaramidda ngarud dagiti imbilin ni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nakisao ni Yahweh kenni Aaron, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Saanka nga uminom ti arak wenno iti naingel a mainom, sika, ken dagiti annakmo a lallaki a nabati a kaduam no sumrekkayo iti tabernakulo tapno saankayo a matay. Agnanayonto daytoy nga alagaden iti amin a henerasion dagiti tattaom, ");
INSERT INTO iloulb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","tapno mailasin ti nagdumaan ti nasantoan ken ti kadawyan, ken ti nagdumaan ti narugit ken nadalus, ");
INSERT INTO iloulb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","tapno maisurom kadagiti tattao ti Israel dagiti amin nga alagaden nga imbilin ni Yahweh babaen kenni Moises.” ");
INSERT INTO iloulb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Nakisao ni Moises kenni Aaron, ken kadagiti nabati nga putotna a lallaki a da Eleazar ken Itamar, “Alaenyo dagiti natda a daton a bukbukel manipud kadagiti daton kenni Yahweh a naipuor, ken kanenyo daytoy nga awan ti lebadurana iti abay ti altar, gapu ta daytoy ket kasasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Masapul a kanenyo daytoy iti nasantoan a lugar, gapu ta daytoy ti bingaymo ken dagiti putotmo a lallaki manipud iti daton kenni Yahweh a naipuor, ta daytoy ti naibilin kaniak nga ibagak kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ti barukong ti ayup a naitag-ay a kas daton ken ti luppo a naidatag kenni Yahweh - masapul a kanenyo dagitoy iti nadalus a lugar a makaay-ayo iti Dios. Sika ken dagiti putotmo a lallaki ken babbai a kaduam ket masapul a kanenyo dagitoy a paset, ta naited dagitoy a kas bingaymo ken dagiti putotmo a lallaki manipud kadagiti daton ti panagkakadua dagiti tattao iti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ti luppo a daton a naidatag kenni Yahweh ken ti barukong ti ayup a naitag-ay a kas daton—masapul a maiyegda amin dagitoy agraman dagiti daton a taba a naipuor, a maitag-ay ken maidatag a kas daton para kenni Yahweh. Kukuayo dagitoy ken dagiti putotmo a lallaki a kaduam a kas bingayyo iti agnanayon, kas imbilin ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kalpasanna, sinaludsod ni Moises ti maipapan iti kalding a daton para iti basol, ket naduktalanna a napuoranen daytoy. Isu a nakaunget isuna kenni Eleazar ken Itamar, dagiti nabati nga annak a lallaki ni Aaron; kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Apay a saanyo a kinnan ti daton a para iti basol iti disso ti tabernakulo, agsipud ta daytoy ket kasasantoan, ken agsipud ta inted ni Yahweh daytoy kadakayo a mangikkat ti nadagsen a basol ti sangkagimongan, a mangaramid iti pangabbong kadagiti basbasolda iti sangoananna? ");
INSERT INTO iloulb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kitaenyo, saan a naiyeg ti dara ti kalding iti uneg ti tabernakulo, isu a rumbeng koma a kinnanyo daytoy iti disso ti tabernakulo, kas imbilinko.” ");
INSERT INTO iloulb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Kalpasanna, simmungbat ni Aaron kenni Moises, “Kitaem, ita nga aldaw, inaramidda ti daton para iti basolda ken ti daton a maipuor amin iti sangoanan ni Yahweh, ket napasamak daytoy a banag kaniak ita nga aldaw. No kinnanko ti daton para iti basol ita nga aldaw, nakaay-ayo ngata daytoy iti imatang ni Yahweh?” ");
INSERT INTO iloulb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Idi nangngeg ni Moises dayta, napnek isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nagsao ni Yahweh kada Moises kenni Aaron, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Makisaritakayo kadagiti tattao iti Israel, ibagayo, 'Dagitoy dagiti sibibiag a banbanag a mabalinyo a kanen kadagiti amin nga ay-ayup nga adda iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mabalinyo a kanen ti aniaman nga ayup nga addaan iti napisi a kuko ken agngatngatingat. ");
INSERT INTO iloulb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nupay kasta, adda dagiti dadduma nga ayup a mabalin nga agngatngatingat wenno addaan iti napisi a kuko, ket masapul a saanyo a kanen dagitoy, dagiti ayup a kas iti kamelio, gapu ta agngatngatingat daytoy ngem saan a napisi ti kukona. Isu a narugit ti kamelio para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Uray met ti babassit nga ayup nga agnanaed kadagiti nabato a lugar: gapu ta agngatngatingat daytoy ngem saan a napisi ti kukona, narugit met laeng daytoy para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ken ti kuneho: gapu ta agngatngatingat daytoy ngem saan a napisi ti kukona, narugit daytoy para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ken ti baboy: uray no napisi ti kukona, saan nga agngatngatingat daytoy, isu a narugit daytoy para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Masapul a saanyo a kanen iti aniaman a karneda wenno sagiden dagiti natay a bagida. Narugit dagitoy para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Dagiti ayup nga agnanaed iti danum a mabalinyo a kanen ket dagiti amin nga addaan iti pigar ken siksik, iti baybay man wenno kadagiti karayan. ");
INSERT INTO iloulb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ngem amin a sibibiag a parsua nga awanan iti pigar ken siksik nga adda iti baybay wenno kadagiti karayan, agraman dagiti amin nga agkutkuti iti danum ken amin nga sibibiag a parsua nga adda iti danum - masapul a karugityo dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Agsipud ta masapul a karugit dagitoy, masapul a saankayo a mangan kadagiti karneda, ken masapul a karugityo dagiti natay a bagida. ");
INSERT INTO iloulb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Aniaman nga adda iti danum nga awanan iti pigar ken siksik ket masapul a karugityo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Dagiti billit a masapul a karugityo ken saanyo a kanen ket dagitoy; ti agila, ti buitre, ");
INSERT INTO iloulb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ti kullaaw, aniaman a kita ti pelikano, ");
INSERT INTO iloulb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","amin a kita ti uwak, ");
INSERT INTO iloulb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ti saraan a puwek ken ti agariwawa a puwek, ti agila ti taaw, ken amin nga kita ti kali. ");
INSERT INTO iloulb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Masapul pay a karugityo ti bassit a puwek ken ti dakkel a puwek, ti kalamon, ");
INSERT INTO iloulb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ti puraw a puwek ken ti puwek ti kamalig, dagiti dadduma pay a puwek, ");
INSERT INTO iloulb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ti tikbaboy, aniaman a kita ti kannaway, ti abublia ken uray ti paniki. ");
INSERT INTO iloulb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Amin a tumatayab nga insekto a magmagna babaen kadagiti sakada ket masapul a karugityo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ngem mabalinyo a kanen ti aniaman kadagiti tumatayab nga insekto a magmagna met laeng babaen kadagiti sakada no adda ti luppoda, nga isu ti us-usarenda nga aglagto iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ken mabalinyo met a kanen ti aniaman a kita ti dudon ken kuriat wenno pandudon. ");
INSERT INTO iloulb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ngem masapul a karugityo dagiti amin a tumatayab nga insekto nga addaan iti uppat a saka. ");
INSERT INTO iloulb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Pagbalinen dakayo a narugit dagitoy nga ayup agingga iti rabii no sagidenyo ti natay a bagi ti maysa kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ken ti siasinoman a mangpidut iti maysa kadagiti natay a bagida ket masapul a labaanna dagiti kawesna ken agtalinaed a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Amin nga ayup nga addaan iti napisi a kuko a saan a naan-anay ti pannakapisina wenno saan nga agngatngatingat ket narugit para kadakayo. Agbalin a narugit ti tunggal maysa a mangsagid kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Aniaman a magmagna babaen iti sakada nga adda pangkaramutna kadagiti amin nga ayup a magmagna iti uppat a saka, narugit dagitoy para kadakayo. Siasinoman a mangsagid iti kasta a natay a bagi ket agtalinaed a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ken ti siasinoman a mangpidot iti kasta a natay a bagi ket masapul a labaanna dagiti kawesna ken agtalinaed a narugit agingga iti rabii. Narugit dagitoy nga ay-ayup para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Kadagiti ayup nga agkarkarayam iti daga, dagitoy dagiti ayup a narugit para kadakayo; ti sangyo, ti utot, amin a kita ti banias, ");
INSERT INTO iloulb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ti tuko, ti alibut, ti alutiit, ti alutiit ti darat, ken ti bannagaw. ");
INSERT INTO iloulb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kadagiti amin nga ayup nga agkarkarayam, dagitoy dagiti ayup a narugit para kadakayo. Siasinoman a mangsagid kadagitoy no natayda ket agbalin a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ken no matay ti aniaman kadakuada ket matinnag daytoy iti aniaman a banag, dayta a banag ket agbalin a narugit, naaramid man dayta iti kayo, lupot, lalat wenno nakirsang a lupot. Aniaman dayta ken aniaman ti pakaus-usaranna, masapul maikabil iti danum; agbalin a narugit daytoy agingga iti rabii. Kalpasanna, agbalinton daytoy a nadalus. ");
INSERT INTO iloulb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ta iti tunggal banga a matinnagan iti aniaman a narugit nga ayup, aniaman nga adda iti banga ket agbalin a narugit, ken masapul a burakenyo dayta a banga. ");
INSERT INTO iloulb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Amin a makan a nadalus ken mapalubosan a kanen, ngem no natedtedan dagitoy iti danum manipud iti narugit a banga, agbalinton a narugit. Ken amin a mabalin nga inumen nga adda iti kasta a banga ket agbalin a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Amin a banag a matinnagan iti paset ti natay a bagi ti narugit nga ayup ket agbalinton a narugit, iti urnu man wenno kadagiti paglutuan a banga. Masapul a buraken dagitoy. Narugit dagitoy ken masapul a narugit para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ti ubbog wenno dakkel a burnay a pagal-alaan iti mainum a danum ket agtalinaed a nadalus no adda ti kasta a parsua a matinnag iti daytoy. Ngem no adda ti siasinoman a mangsagid iti natay a bagi ti narugit nga ayup nga adda iti danum, agbalin isuna a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","No matinnag ti aniaman a paset ti narugit a natay a bagi kadagiti bukel a maimula, dagitoy a bukbukel ket nadalus latta. ");
INSERT INTO iloulb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ngem no naikkan iti danum dagiti bukel, ken no aniaman a paset ti narugit a natay a bagi ti matinnag kadakuada, ket agbalindanton a narugit para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","No matay ti aniaman nga ayup a mabalinyo a kanen, ket ti mangsagid iti natay a bagi ti ayup ket agbalin a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ken no siasinoman ti mangan iti dayta a natay a bagi ket masapul a labaanna dagiti kawesna ken agtalinaed a narugit agingga iti rabii. Ken siasinoman a mangpidut iti kasta a bangkay ket labaanna dagiti kawesna ken agtalinaed a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Amin nga ayup nga agkarkarayam iti daga ket masapul a karugityo, masapul a saan a makan dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Aniaman nga agkarayam iti buksitna, ken aniaman a magna babaen kadagiti uppat a saka, wenno aniaman nga addaan iti adu a saka - amin nga ayup nga agkarkarayam iti daga, masapul a saanyo a kanen dagitoy, ta masapul a karugit dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Masapul a saanyo nga aramiden a narugit dagiti bagbagiyo kadagiti aniaman a sibibiag a parsua nga agkarkarayam; masapul a saanyo nga aramiden a narugit dagiti bagbagiyo babaen kadagitoy, nga agbalinka a saan a nasin-aw babaen kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ta Siak, ni Yahweh a Diosyo. Ngarud idatonyo dagiti bagbagiyo kaniak ken agbalinkayo a nasatoan gapu ta nasantoanak. Saanyo koma a rugitan dagiti bagbagiyo babaen kadagiti amin a kita ti ayup nga agkutkuti ditoy daga. ");
INSERT INTO iloulb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ta siak ni Yahweh, a nangiruar kadakayo manipud iti daga ti Egypto, nga agbalin a Diosyo. Masapul ngarud nga agbalin kayo a nasantoan, ta nasantoanak. ");
INSERT INTO iloulb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Daytoy ti linteg maipapan kadagiti ayup, kadagiti billit, kadagiti amin a sibibiag a parsua nga agkutkuti kadagiti danum ken kadagiti amin a parsua nga agkakarayam iti daga, ");
INSERT INTO iloulb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ta kadagitoy ket maaramid ti pagiddiatan iti nagbaetan ti narugit ken nadalus, ken ti nagbaetan dagiti sibibiag a parsua a mabalin a kanen ken dagiti sibibiag a parsua a saan a mabalin a kanen.'” ");
INSERT INTO iloulb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kinuna ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Makisaritaka kadagiti tattao iti Israel, ibagam, 'No ti maysa a babai ket agsikog ken aganak iti ubing a lalaki, ket agbalinto isuna a narugit iti pito nga aldaw, kas iti kinarugitna kabayatan dagiti aldaw ti panagreglana iti binulan. ");
INSERT INTO iloulb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Iti maikawalo nga aldaw, masapul a makugit ti lasag iti akinruar a kudil ti maladaga a lalaki. ");
INSERT INTO iloulb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ket ti pannakadalus ti ina manipud iti panagpadarana ket agtultuloy aginggana iti tallopulo ket tallo nga aldaw. Masapul a saanna a sagiden ti aniaman a banbanag a nasantoan wenno mapan iti ayan ti tabernakulo agingga a malpas ti aldaw iti pannakadalusna. ");
INSERT INTO iloulb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ngem no aganak isuna iti ubing a babai, ket agbalin isuna a narugit iti dua a lawas, kas iti panagreglana. Ken agtultuloy ti pannakadalus ti ina aginggana iti 66 nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Inton nalpasen dagiti aldaw ti pannakadalusna para iti anak a babai wenno anak a lalaki, masapul a mangiyeg isuna iti maysa ti tawenna a karnero a kas daton a maipuor amin, ken sibong a pagaw wenno kalapati a kas daton gapu iti basol, iti pagserrekan iti tabernakulo, iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kalpasanna, idatonna daytoy iti sangoanan ni Yahweh ken mangaramid iti pangabbong para kenkuana ket madalusan isuna manipud iti panagayus ti darana. Daytoy ti linteg maipapan iti babai nga aganak iti ubing a lalaki wenno ubing a babai. ");
INSERT INTO iloulb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","No saanna a kabaelan ti mangiyeg iti karnero, ket masapul a mangala isuna iti dua a kalapati wenno dua a sibong a pagaw, maysa para iti daton a mapuoran ken ti maysa para iti daton a gapu iti basol, ken mangaramid ti padi iti pangabbong para kenkuana, ket agbalinton isuna a nadalus.'” ");
INSERT INTO iloulb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Nagsao ni Yahweh kada Moises ken Aaron, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“No ti maysa a tao ket adda lumlumteg iti kudilna, wenno aggadgaddil, wenno adda nasileng a kabiteg ket nagbalin a makaakar, ken adda ti sakit ti kudilna, ket masapul a maipan isuna kenni Aaron, ti nangato a padi wenno iti maysa kadagiti putotna a lallaki a padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ket kitaen ti padi ti sakit ti kudilna. No pimmuraw ti buok iti masakit a paset ti kudilna, ken no naun-uneg ti masakit a paset ngem ti kudil, ket makaakar daytoy a sakit. Kalpasan a kinita isuna ti padi, masapul nga ipakaammona a narugit isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","No ti nasileng a kabiteg iti kudilna ket puraw, ken saan a naun-uneg ti langana ngem ti kudil, ken no saan a pimmuraw ti buok iti masakit a paset, ket masapul nga ilasin ti padi dayta a tao nga addaan iti sakit iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Iti maikapito nga aldaw, masapul a kitaen ti padi isuna tapno makitana a no iti kapanunotanna ket saan a kimmaro ti sakit ken no saan a nagwaras daytoy iti kudil. No saan a nagwaras daytoy, ket masapul nga ilasin ti padi isuna iti pito pay nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kitaen manen isuna ti padi iti maikapito nga aldaw tapno makitana no simmayaaten ti sakit ken saan nga ad-adda a nagwaras iti kudil. No saan a nagwaras daytoy, ket ipakaammo ti padi a nadalus isuna. Gagatel daytoy. Masapul a labaanna dagiti kawesna ket nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ngem no nagwaras ti gagatel iti kudil kalpasan nga imparangna ti bagina iti padi para iti pannakadalusna, masapul nga iparangna manen ti bagina iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kitaen ti padi isuna tapno makitana no ad-adda pay a nagwaras ti gagatel iti kudil. No nagwaras daytoy, ket masapul nga ipakaammo ti padi a narugit isuna. Makaakar daytoy a sakit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","No ti makaakar a sakit ket adda iti maysa a tao, ket masapul a maipan isuna iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kitaen ti padi isuna tapno makitana no adda ti puraw a lumlumteg iti kudilna, no pimmuraw ti buok, wenno no adda ti saan pay nga naimbag a lasag iti lumlumteg a kudilna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","No adda, ket nakaro unay a sakit ti kudil daytoy, ket masapul nga ipakaammo ti padi a narugit isuna. Saanna nga ilasin isuna gapu ta narugiten isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","No nagwaras ti sakit ket kinallubanna ti amin a kudil ti masakit a tao manipud iti ulona agingga iti sakana, a kas makita ti padi, ");
INSERT INTO iloulb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ket masapul a kitaen isuna ti padi tapno makitana no nagwaras ti sakit ti intero a bagina. No nagwaras daytoy, masapul nga ipakaammo ti padi a nadalus ti masakit a tao. No pimmuraw amin dagitoy, ket nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ngem no adda ti agparparang a saan pay a naimbag a lasag kenkuana, narugit isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Masapul a kitaen ti padi ti saan pay a naimbag a lasag ken ipakaammona a narugit isuna gapu ta narugit ti saan pay a naimbag a lasag. Makaakar daytoy a sakit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ngem no pimmuraw manen ti saan pay a naimbag a lasag, ket masapul a mapan dayta a tao iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kitaen ti padi isuna tapno makitana no pimmuraw ti lasag. No pimmuraw daytoy, ipakaammo ti padi a nadalus dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","No ti maysa a tao ket adda ti litteg iti kudilna ken naimbaganen, ");
INSERT INTO iloulb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ken iti ayan ti litteg ket adda iti lumlumteg a pumuraw wenno nasileng a kabiteg, a lumabaga a puraw, ket masapul a maipakita daytoy iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kitaen ti padi daytoy tapno makita no naun-uneg ti langana ngem ti kudil ken no nagbalin a puraw ti buokna idiay. No kasta, ket masapul nga ipakaammo ti padi a narugit isuna. Makaakar daytoy a sakit, no nagtubo daytoy iti sigud nga ayan ti litteg. ");
INSERT INTO iloulb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ngem no kinita ti padi daytoy ket nakitana nga awan iti puraw a buokna, ken saan a naun-uneg ngem ti kudil ket umim-imbagen, ket masapul nga ilasin isuna ti padi iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","No nagwaras daytoy iti kudil, masapul nga ipakaammo ti padi a narugit isuna. Makaakar daytoy a sakit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ngem no nagtalinaed ti nasileng a kabiteg iti ayanna ken saan a nagwaras, ngarud, piglat daytoy ti litteg ket masapul nga ipakaammo ti padi a nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","No nasinit ti kudil ken ti saan pay a naimbag a lasag ti paset a nasinit ket nagbalin a lumabaga a puraw wenno pimmuraw, ");
INSERT INTO iloulb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ket masapul a kitaen ti padi daytoy tapno makitana no pimmuraw ti buok iti dayta a paset ken no agparang a naun-uneg ngem ti kudil. No kasta, makaakar ngarud daytoy a sakit. Timmubo daytoy iti nasinit a paset ket masapul nga ipakaammo ti padi a narugit isuna. Makaakar daytoy a sakit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ngem no kinita ti padi daytoy ket naduktalanna nga awan ti puraw a buok iti nasinit a paset, ken saan a naun-uneg ngem ti kudil ket umim-imbagen, masapul nga ilasin isuna ti padi iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kalpasanna, masapul a kitaen ti padi isuna iti maikapito nga aldaw. No nagwaras daytoy iti kudil, ket masapul nga ipakaammo ti padi a narugit isuna. Makaakar daytoy a sakit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","No nagtalinaed laeng ti nasinit a paset iti ayanna ken saan a nagwaras iti kudil ket umim-imbagen, ngarud, lumlumteg laeng daytoy gapu iti pannakasinitna ket masapul nga ipakaammo ti padi a nadalus isuna, ta piglat laeng daytoy gapu ti pannakasinit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","No ti maysa a lalaki wenno babai ket addaan iti makaakar a sakit iti ulo wenno timid, ");
INSERT INTO iloulb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ket masapul a kitaen ti padi dayta a tao para iti makaakar a sakit tapno kitaenna no agparparang daytoy a naun-uneg ngem ti kudil, ken no adda ti duyaw a naingpis a buokna daytoy. No adda, masapul nga ipakaammo ti padi a narugit isuna. Gagatel daytoy, maysa a makaakar a sakit iti ulo wenno timid. ");
INSERT INTO iloulb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","No kinita ti padi ti gagatel ket nakitana a saan daytoy a naun-uneg ngem ti kudil, ken no awan ti nangisit a buokna daytoy, ket ilasin ti padi ti tao nga addaan ti gagatel iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Iti maikapito nga aldaw, masapul a kitaen ti padi ti sakit tapno makitana no nagwaras daytoy. No awan ti duyaw a buokna, ken no agparparang a narabaw laeng ti sakit, ");
INSERT INTO iloulb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","masapul a makuskusan isuna, ngem masapul a saan a makuskusan ti masakit a paset, ket masapul nga ilasin ti padi ti tao nga addaan iti gagatel iti pito pay nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Iti maikapito nga aldaw kitaen ti padi ti sakit tapno makitana no nagsardengen ti panagwarasna iti kudil. No saan a naun-uneg ti langana daytoy ngem ti kudil, ket masapul nga ipakaammo ti padi a nadalus isuna. Masapul a labaan dayta a tao dagiti kawesna ket agbalinton isuna a nadalus. ");
INSERT INTO iloulb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ngem no nagwaras ti sakit a gagatel iti kudil kalpasan nga imbaga ti padi a nadalus isuna, ");
INSERT INTO iloulb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ket masapul a kitaen manen isuna ti padi. No nagwaras ti sakit iti kudil, saanen a kasapulan ti padi a mangsapul iti duyaw a buok. Ti tao ket narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ngem no iti panagkita ti padi ket nagsardengen nga agwaras ti gagatel ken addan ti nagtubo a nangisit a buok iti masakit a paset, naimbagen ngarud ti gagatel. Nadalus isuna ken masapul nga ipakaammo ti padi a nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","No ti maysa a lalaki wenno babai ket addaan kadagiti puraw a labang ti kudil, ");
INSERT INTO iloulb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","masapul a kitaen ti padi dayta a tao tapno makitana no dagiti labang ket nalitem a puraw, a maysa laeng a gagatel a nagtubo iti kudil. Nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","No nagregreg ti buok ti tao manipud iti ulona, makalkalbo isuna, ngem nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ken no nagregreg ti buok iti sangoanan ti ulona, ken no kalbo ti mugingna, nadalus isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ngem no adda ti gaddil a lumabaga a puraw iti kalbo nga ulona wenno mugingna, makaakar daytoy a sakit a nagtubo. ");
INSERT INTO iloulb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ket masapul a kitaen isuna ti padi tapno makitana no ti lumlumteg iti masakit a paset iti kalbo nga ulona wenno iti mugingna ket lumabaga a puraw, kas iti langa ti makaakar a sakit iti kudil. ");
INSERT INTO iloulb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","No kastoy, ket addaan isuna ti makaakar a sakit ket narugit isuna. Masapul a siguraduen ti padi nga ipakaammo a narugit isuna gapu iti sakit nga adda iti ulona. ");
INSERT INTO iloulb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ti tao nga addaan iti makaakar a sakit ket masapul nga agisuot kadagiti napigis a kawkawes, masapul a nakawakray ti buokna, ken masapul a kallubanna ti rupana agingga iti agungna ket ipukkawna ti 'Narugit, narugit.' ");
INSERT INTO iloulb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kadagiti amin nga aldaw nga addaan isuna iti makaakar a sakit ket narugit isuna. Gapu ta narugit isuna nga addaan iti makaakar a sakit, masapul nga agbiag isuna nga agmaymaysa. Masapul nga agnaed isuna iti ruar ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ti lupot a nagbuot, naaramid man daytoy iti dutdut ti ayup wenno lino a lupot, ");
INSERT INTO iloulb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","wenno aniaman a nalaga wenno nagansilyo a dutdut ti ayup wenno lino, wenno lalat wenno aniaman a banag a naaramid ti lalat— ");
INSERT INTO iloulb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","no adda ti kasla maris bulong wenno lumabaga a buot iti lupot, ti lalat, ti nalaga wenno nagansilyo a banag, wenno aniaman a banag a naaramid iti lalat, ket buot daytoy a nagwaras; masapul a maipakita daytoy iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Masapul a kitaen ti padi daytoy a banag para iti buot; masapul nga ilasinna ti aniaman a banag nga addaan iti buot iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Masapul a kitaenna manen ti buot iti maikapito nga aldaw. No nagwaras daytoy iti lupot wenno aniaman a banag a nalaga wenno nagansilio a dutdut ti ayup wenno lino, wenno lalat wenno aniaman a banag a nakaaramatan ti lalat, ngarud makadadael daytoy a buot, ket dayta a banag ket narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Masapul a puoranna ti lupot, wenno aniaman a banag a nalaga wenno nagansilio a dutdut ti ayup wenno lino, wenno lalat wenno aniaman a banag a naaramid iti lalat, aniaman a banag a nakasakaran iti makadadael a buot, ta mabalin a pagrugian daytoy iti sakit. Masapul a mapuoran a naan-anay daytoy a banag. ");
INSERT INTO iloulb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","No kinita ti padi daytoy a banag ket nakitana a saan a nagwaras ti buot iti lupot wenno iti banag a nalaga wenno nagansilio a dutdut ti ayup wenno lino, wenno kadagiti banag a naaramid iti lalat, ");
INSERT INTO iloulb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ket bilinenna ida a labaanda ti banag a nakasarakan iti buot, ken masapul nga ilasinna daytoy iti pito pay nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Kalpasanna, kitaen ti padi dayta a banag kalpasan a nalabaan daytoy. No saan a nagbaliw ti maris ti buot uray no daytoy ket saan a nagwaras, daytoy ket narugit. Masapul a puoranyo dayta a banag, uray no sadinoman a paset ti nagbuot. ");
INSERT INTO iloulb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","No kinita ti padi dayta a banag, ken no napukaw ti buot kalpasan a nalabaan daytoy, ket masapul a pigisenna ti nagbuot a paset ti lupot wenno ti lalat, wenno ti nalaga wenno nagansilio a banag. ");
INSERT INTO iloulb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","No adda pay laeng ti buot iti lupot, iti nalaga man wenno nagansilio a banag, wenno iti aniaman a banag a naaramid iti lalat, agwarwaras daytoy. Masapul a puoranyo ti aniaman a banag nga addaan iti buot. ");
INSERT INTO iloulb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ti lupot wenno aniaman a banag a nalaga wenno nagansilio a dutdut ti ayup wenno linen, wenno lalat wenno aniaman a banag a naaramid ti lalat- no nilabaanyo daytoy a banag ket napukaw ti buot, ket masapul a malabaan daytoy iti maikadua a daras, ket agbalinto daytoy a nadalus. ");
INSERT INTO iloulb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Daytoy ti linteg a maipapan iti buot iti lupot a dutdut ti ayup wenno lino, wenno aniaman a banag a nalaga wenno nagansilio a dutdut ti ayup wenno lino, wenno lalat wenno aniaman a banag a naaramid iti lalat, tapno maipakaamoyo daytoy a nadalus wenno narugit.” ");
INSERT INTO iloulb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Nagsao ni Yahweh kenni Moises, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Daytoyto ti linteg para iti agsakit a tao iti aldaw ti pannakadalusna. Masapul a maipan isuna iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Rummuarto ti padi iti kampo tapno sukimatenna ti tao tapno makitana no naimbagen ti makaakar a sakit ti kudil. ");
INSERT INTO iloulb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Ket bilinento ti padi a ti madalusan ket masapul a mangala iti dua a sibibiag, nadalus a billit, kayo a sedro, nalabaga a sinulid, ken hisopo. ");
INSERT INTO iloulb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Bilinento ti padi isuna a patayenna ti maysa kadagiti billit iti ngatoen iti nalinis a danum nga adda iti maysa a banga. ");
INSERT INTO iloulb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ket alaento ti padi ti sibibiag a billit ken ti kayo a sedro, ken ti nalabaga a sinulid ken ti hisopo, ket isawsawnanto amin dagitoy a banbanag, agraman ti sibibiag a billit, iti dara ti billit a napapatay iti ngatoen iti nalinis a danum. ");
INSERT INTO iloulb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ket iwarsinto ti padi daytoy a danum iti maminpito iti tao a madalusan manipud iti sakit, ket kalpasanna ipablaakto ti padi a nadalusen isuna. Ket waya-wayaanto ti padi ti sibibiag a billit iti kataltalonan. ");
INSERT INTO iloulb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ti tao a nadalusan ket labaanna ti pagan-anayna, kuskosanna amin a buokna ken digosenna ti bagina iti danum, ket kalpasanna nadaluston isuna. Kalpasan dayta masapul a mapan isuna idiay kampo, ngem agnaedto isuna iti ruar ti toldana iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Iti maikapito nga aldaw masapul a kuskosanna amin a buok iti ulona, ken masapul met a kuskosanna ti barbas ken dagiti kidayna. Masapul a kuskosanna amin a buokna, ken masapul a labaanna dagiti pagan-anayna ken digosenna ti bagina iti danum; ket nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Iti maikawalo nga aldaw, masapul a mangala isuna iti dua a kalakian a karnero nga awan mulitna, maysa a babai a karnero a natawenan nga awan mulitna, ken tallo nga apagkapullo ti maysa nga efa iti napino nga arina a nailaok iti lana kas daton a bukbukel, ken maysa a kakatlo ti litro a lana. ");
INSERT INTO iloulb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ti mangdalus a padi kenkuana ket itakderannanto ti tao a madalusan, a kadua dagidiay a banbanag, iti sangoanan ni Yahweh iti pagserrekan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Alaento ti padi ti maysa kadagiti kalakian a karnero ket idatonna daytoy kas maysa a daton a pangsupapak iti biddut, a kadua iti kakatlo a litro ti lana; itag-aynanto dagitoy a kas maysa a daton iti sangoanan ni Yahweh ken idatagna dagitoy kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Masapul a patayenna ti kalakian a karnero iti lugar a pangpatpatayanda kadagiti daton a gapu iti basol ken ti daton a maipuor amin, iti disso iti tabernakulo, ta ti daton a gapu iti basol ket kukua ti padi, kas iti daton a pangsupapak iti biddut, gapu ta daytoy ket kasasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mangalanto ti padi iti dara iti daton a pangsupapak iti biddut ket ikabilna daytoy iti murdong iti makannawan a lapayag iti tao a madalusan, iti tangan ti makannawan nga imana, ken iti tangan ti makannawan a sakana. ");
INSERT INTO iloulb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kalpasanna, mangalanto ti padi iti lana manipud iti kakatlo a litro ket ibukbokna daytoy iti dakulap iti makannigid nga imana, ");
INSERT INTO iloulb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ket isawsawna ti makannawan a ramayna iti lana nga adda iti makannigid nga imana, ket iwarsina ti dadduma a lana babaen iti ramayna iti maminpito iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ikabilto ti padi ti nabati a lana iti imana idiay murdong ti makannawan a lapayag ti tao a madalusan, iti tangan ti makannawan nga imana, ken iti tangan ti makannawan a sakana. Masapul nga ikabilna daytoy a lana iti rabaw ti dara manipud iti daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Para iti nabati a lana iti ima ti padi, ikabilnanto daytoy iti ulo ti tao a madalusan, ket mangaramidto ti padi iti pangabbong para kenkuana iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ket idatonto ti padi ti daton a gapu iti basol ken mangaramid iti pangabbong para kenkuana a madalusan gapu iti kinarugitna, ket kalpasanna patayennanto ti daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ket idatonto ti padi ti daton a maipuor amin ken ti daton a bukbukel iti altar. Mangaramidto ti padi ti seremonia ti pannakapakawan para iti tao, ket kalpasanna, nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nupay kasta, no nakurapay ti tao ken saanna a kabaelan ti gumatang kadagitoy a daton, ket mabalinna ti mangala iti maysa a kalakian a karnero a kas maysa a daton a pangsupapak iti biddut a maitag-ay ken maidatagto kenni Yahweh a mangaramid ti pangabbong para iti bagina, ken apagkapullo ti maysa nga efa a napino nga arina a nailaok iti lana kas maysa a daton a bukbukel, ken kakatlo a litro ti lana, ");
INSERT INTO iloulb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","a kadua dagiti dua a kalapati wenno dua a sibong a pagaw, kas kabaelanna nga alaen; ti maysa a billit ket agbalinto a daton a gapu iti basol ken ti maysa ket agbalinto a daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Iti maikawalo nga aldaw masapul nga ipanna dagitoy iti padi para iti pannakadalusna, iti pagserrekan ti tabernakulo, iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ket alaento ti padi ti karnero a para iti daton a pangsupapak iti biddut ken ti kakatlo a litro ti lana, ket itag-ayna dagitoy a kas maysa a daton kenni Yahweh ket idatagna dagitoy kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Patayennanto ti karnero a para iti daton a pangsupapak iti biddut, ket mangalanto isuna iti dara ti daton a pangsupapak iti biddut ket ikabilna daytoy iti murdong iti makannawan a lapayag iti tao madalusan, iti tangan ti makannawan nga imana, ken iti tangan ti makannawan a sakana. ");
INSERT INTO iloulb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ket ibukbokto ti padi ti dadduma a lana iti dakulap ti makannigid nga imana, ");
INSERT INTO iloulb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ket iwarsinanto babaen ti makannawan a ramayna ti dadduma a lana nga adda iti makannigid nga imana iti maminpito iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ket ikabilto ti padi ti dadduma a lana nga adda iti imana iti murdong ti makannawan a lapayag ti tao a madalusan, iti tangan ti makannawan nga imana, ken iti tangan ti makannawan a sakana, kadagiti isu met laeng a lugar a nangikabilanna iti dara ti daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ikabilnanto ti nabati a lana nga adda iti imana iti ulo ti tao a madalusan, tapno mangaramid ti pangabbong para kenkuana iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Masapul nga idatonna ti maysa kadagiti kalapati wenno sibong a pagaw, kas kabaelan ti tao nga alaen— ");
INSERT INTO iloulb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","maysa a kas daton a gapu iti basol ket ti maysa ket kas daton a maipuor amin, a kadua ti daton a bukbukel. Ket mangaramidto ti padi ti pangabbong para iti tao a madalusan iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Daytoy ti linteg para iti tao nga addaan iti makaakar a sakit iti kudil, a saan a makabael a gumatang iti umno a daton para iti pannakadalusna.” ");
INSERT INTO iloulb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Nagsao ni Yahweh kada Moises ken Aaron, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Inton makadanonkayo idiay daga ti Canaan nga intedko kadakayo a kas sanikua, ket no mangikabilak iti buot nga agwaras iti balay idiay daga a sanikuayo, ");
INSERT INTO iloulb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ket masapul a mapan ti akinkukua iti balay ken ibagana iti padi. Masapul nga ibagana, 'Panag kunak ket kasla adda maysa a banag a kasla buot idiay balayko.' ");
INSERT INTO iloulb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ket ibilinto ti padi nga ikkatenda ti adda iti uneg ti balay sakbay a sumrek isuna a mangkita iti pakailasinan iti buot, tapno awanto ti agbalin a narugit idiay balay. Kalpasanna, masapul a sumrek ti padi a mangkita iti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Masapul a sukimatenna ti buot tapno makitana no adda daytoy kadagiti diding ti balay, ken tapno makitana no aglanglanga daytoy a berde wenno lumabaga idiay likkaong dagiti diding. ");
INSERT INTO iloulb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","No pudno nga addaan iti buot ti balay, ket rummuarto ti padi iti balay ket iserrana ti ruangan ti balay iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ket agsublinto manen ti padi iti maikapito nga aldaw ket sukimatenna daytoy tapno kitaenna no nagwaras ti buot kadagiti diding ti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","No nagwaras daytoy, ibilinto ti padi nga ikkatenda dagiti bato a pakasarakan iti buot ket ibillengda dagitoy iti narugit a lugar iti ruar ti siudad. ");
INSERT INTO iloulb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Dawatennanto a makuskusan dagiti amin nga akin uneg a diding ti balay, ket masapul nga ipanda ti nakuskusda a banbanag nga adda buotna iti ruar ti siudad ket ibellengda daytoy idiay narugit a disso. ");
INSERT INTO iloulb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Masapul a mangalada kadagiti sabali a bato ket ikabilda dagitoy iti ayan dagiti bato a nalikkab, ket masapul nga agusarda iti baro a pitak a pangpalitadada iti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","No agsubli manen ti buot ket nagwaras iti balay a nakaikkatan dagiti bato ken dagiti diding a nakuskusan ken naulit a napalitadaan, ");
INSERT INTO iloulb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ket masapul nga umuneg ti padi ket sukimatenna ti balay tapno kitaenna no ti buot ket nagwaras iti balay. No nagwaras daytoy, makadadael ngarud daytoy a buot, ket narugit ti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Masapul a marebba ti balay. Dagiti bato, kayo, ken amin a palitada iti balay ket masapul a maiyadayo a mairuar iti siudad a maipan iti narugit a disso. ");
INSERT INTO iloulb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kanayonna pay, siasinoman nga umuneg iti balay kabayatan ti tiempo a nakaserra daytoy ket agbalinto a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Siasinoman a maturog iti balay ket masapul a labaanna dagiti pagan-anayna, ken siasinoman a mangan iti dayta a balay ket masapul a labaanna ti pagan-anayna. ");
INSERT INTO iloulb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","No sumrek ti padi iti balay tapno kitaenna no ti buot ket nagwaras iti balay kalpasan napalitadaan daytoy, ket, no awanen ti buot, ipablaaknanto a nadalus ti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ket masapul a mangala ti padi ti dua a billit tapno dalusanna ti balay, ken kayo a sedro, ken nalabaga a sinulid, ken hisopo. ");
INSERT INTO iloulb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Patayennanto ti maysa kadagiti billit iti ngatoen ti nalinis a danum nga adda iti maysa a banga. ");
INSERT INTO iloulb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Alaennanto ti kayo a sedro, ti hisopo, ti nalabaga a sinulid, ken ti sibibiag a billit, ket isawsawna dagitoy iti dara ti natay a billit, iti nalinis a danum, ket warsianna ti balay iti maminpito a daras. ");
INSERT INTO iloulb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Dalusannanto ti balay babaen iti dara ti billit ken babaen ti nilinis a danum, babaen iti sibibiag a billit, ti kayo a sedro, ti hisopo, ken ti nalabaga a sinulid. ");
INSERT INTO iloulb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ngem palubosannanto ti sibibiag a billit a rummuar iti siudad a mapan iti kataltalonan. Iti daytoy a wagas mangaramid isuna ti seremonia ti pannakadalus para iti balay, ket nadaluston daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Daytoy ti linteg para iti amin a kita iti makaakar a sakit ti kudil ken kadagiti banbanag a pakaigapuan iti kastoy a sakit, ken para iti gagatel, ");
INSERT INTO iloulb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ken para iti buot iti pagan-anay ken iti balay, ");
INSERT INTO iloulb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","para iti lumlumteg, para iti gaddil, ken para iti letteg, ");
INSERT INTO iloulb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","tapno maammoan no ania kadagitoy ti narugit wenno no kaano a nadalus daytoy. Daytoy ti linteg para kadagiti makaakar a saksakit ti kudil ken buot.” ");
INSERT INTO iloulb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Nagsao ni Yahweh kada Moises ken Aaron, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Agsaokayo kadagiti tattao ti Israel, ket ibagayo kadakuada, 'No adda man ti tao nga addaan iti narugit a likido a rumrumuar iti bagina, maibilang isuna a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ti kinarugitna ket gapu iti daytoy a narugit a likido. Agaruyot man ti likido iti bagina wenno nagsardeng, daytoy ket narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Tunggal pagiddaan a pagiddaanna ket agbalin a narugit, ket amin a banag a pagtugawanna ket agbalin a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Siasinoman a mangsagid iti pagiddaanna ket masapul a labaanna dagiti pagan-anayna ken digosenna ti bagina iti danum, ket agbalin a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Siasinoman nga agtugaw iti aniaman a nagtugawan ti tao nga adda iti rumrumuar a narugit a likido iti bagina, masapul a labaan dayta a tao dagiti pagan-anayna ken digosenna ti bagina iti danum, ket maibilang isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ken ti siasinoman a mangsagid iti bagi ti tao nga adda iti rumrumuar a narugit a likido iti bagina ket masapul a labaanna dagiti pagan-anayna ken digosenna ti bagina iti danum, ket maibilang isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","No ti tao nga adda iti rumrumuar a kasta a likido iti bagina ket matupraanna ti maysa a nadalus a tao, ket masapul labaan dayta a tao ti pagan-anayna ken digusenna ti bagina iti danum, ket maibilang isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Aniaman a naiyap-ap iti bukot ti kabalyo a pagluganan ti tao nga adda rumrumuar a likido iti bagina ket agbalin a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Siasinoman a mangsagid iti aniaman a banag nga nagsaadan dayta a tao ket agbalin a narugit agingga iti rabii, ken ti siasinoman a mangawit kadagidiay a banbanag ket masapul a labaanna dagiti pagan-anayna ken digusenna ti bagina iti danum; maibilang isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Siasinoman a masagid iti addaan iti kasta a panagruar a saanna a binugguan nga immun-una dagiti imana iti danum, ti tao a nasagid ket masapul a labaanna dagiti pagan-anayna ken digosenna ti bagina iti danum, ket agbalin isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Aniaman a banga a sagiden ti maysa nga addaan iti rumrummuar a kasta a likido ti bagina ket masapul a maburak, ken tunggal pagkargaan a kayo ket masapul a mabuggoan iti danum. ");
INSERT INTO iloulb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Inton isuna nga addaan iti panagruar ti likido ket madalusan, ket masapul nga agpalabas isuna iti pito nga aldaw para iti pannakadalusna; ket masapul a labaanna dagiti pagan-anayna ken digusenna ti bagina iti agay-ayos a danum. Ket nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Iti maikawalo nga aldaw, masapul a mangala isuna ti dua a kalapati wenno dua a sibong a pagaw ket mapan iti sangoanan ni Yahweh idiay pagserrekan ti tabernakulo; sadiay ket masapul nga itedna iti padi dagiti billit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Masapul nga idaton ti padi dagitoy, maysa a kas daton a gapu ti basol ken ti maysa a kas daton a maipuor amin, ken masapul a mangaramid ti padi iti pangabbong para kenkuana iti sangoanan ni Yahweh para iti panagpatedtedna. ");
INSERT INTO iloulb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","No ti kissit ti siasinoman a lalaki ket agtultuloy a rummuar manipud kenkuana, ket masapul a digusenna ti entero a bagina iti danum; agbalin isuna a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Tunggal lupot wenno lalat nga addaan iti kissit ket masapul a malabaan babaen iti danum; agbalin a narugit daytoy agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ket no nagkaidda ti maysa a babai ken maysa a lalaki ket naiyalis ti kissit kenkuana, masapul a digusenda a dua ti bagida iti danum; narugitda agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","No agregla ti babai, ti kinarugitna ket agtultuloy iti pito nga aldaw, ken siasinoman a mangsagid kenkuana ket maibilang a narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Amin a banag a pagiddaanna kabayatan iti panagreglana ket agbalin a narugit; amin a banag a pagtugawanna ket agbalin met a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Siasinoman a mangsagid iti pagiddaan ti babai ket masapul a labaanna dagiti pagan-anayna ken digusenna ti bagina iti danum; dayta a tao ket narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Siasinoman a mangsagid iti aniaman a pagtugawan ti babai ket masapul a labaanna dagiti pagan-anayna ken digusenna ti bagina iti danum, dayta a tao ket narugit agingga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Uray no daytoy ket adda iti pagiddaan wenno adda iti aniaman a nagtugawan ti babai, no sagidenna daytoy, dayta a tao ket maibilang a narugit aginga iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","No makikaidda ti siasiniman iti babai, ket no masagid isuna ti narugit a panagpabulosna, maibilang isuna a narugit iti pito nga aldaw. Tunggal pagiddaan a pagiddaan ti lalaki ket agbalin a narugit. ");
INSERT INTO iloulb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","No agpadara ti babai iti adu nga aldaw a saan a tiempo iti panagreglana, wenno bo adda ti panagpadarana a nabaybayag ngem iti tiempo ti panagreglana, kabayatan iti amin nga aldaw iti panagpadara iti kinarugitna, agbalin isuna a kasla adda isuna kadagiti aldaw ti panagreglana. Narugit isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Amin a pagiddaan a pagiddaanna kabayatan ti panagpadarana ket agbalin a kasla ti pagiddaan a nagiddaanna kabayatan iti panagreglana, ken amin a banag a pagtugawanna ket agbalin a narugit, kas iti kinarugit ti panagreglana. ");
INSERT INTO iloulb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ken siasinoman a mangsagid iti aniaman kadagidiay a banbanag ket agbalin a narugit; masapul a labaanna dagiti pagan-anayna ken digusenna ti bagina iti danum, ket agbalin isuna a narugit agingga iti rabii ");
INSERT INTO iloulb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ngem no nadalusan isuna manipud iti panagpadarana, ket agpalabas isuna iti pito nga aldaw, ket kalpasan dayta nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Iti maikawalo nga aldaw, mangalanto isuna iti dua a kalapati wenno dua a sibong a pagaw ket iyegna dagitoy iti padi idiay pagserrekan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Idatonto ti padi ti maysa a billit kas daton a gapu iti basol ken ti maysa a kas daton a maipuor amin, ket mangaramidtoisuna pangabbong para kenkuana iti sangoanan ni Yahweh para iti kinarugit iti panagpadarana. ");
INSERT INTO iloulb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kastoy ti masapul a panangisinayo kadagiti tattao ti Israel manipud kadagiti kinarugitda, tapno saanda a matay gapu iti kinarugitda, babaen iti panangtulawda iti tabernakulok, a pagnanaedak iti nagtetengngaanda. ");
INSERT INTO iloulb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dagitoy dagiti alagaden para iti siasinoman nga addaan iti panagruar ti likido iti bagina, para iti siasinoman a lalaki a nagparuar iti kissitna a mangaramid a narugit kenkuana, ");
INSERT INTO iloulb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","para iti siasinoman a babai nga agregla, para iti siasinoman nga addaan iti panagruar ti likido iti bagina, lalaki man wenno babai, ken para iti siasinoman a lalaki a nakikaidda iti maysa a narugit a babai.''' ");
INSERT INTO iloulb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nagsao ni Yahweh kenni Moises—daytoy ket kalpasan ti pannakatay dagiti dua a putot a lallaki ni Aaron, idi immasidegda kenni Yahweh ket natayda. ");
INSERT INTO iloulb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Kinuna ni Yahweh kenni Moises, “Makisaritaka kenni Aaron a kabsatmo ket ibagam kenkuana a saan a mapan iti aniaman a tiempo idiay kasasantoan a lugar iti likudan ti kurtina, iti sangoanan ti kalub a pakakitaan iti pannakaabbong ti basol nga adda iti rabaw ti lakasa ti tulag. No aramidenna dayta, matay isuna, gapu ta agparangak babaen iti ulep iti ngatoen ti kalub a pakakitaan iti pannakabbong ti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Isu kastoy ti masapul nga iseserrek ni Aaron iti kasasantoan a disso. Masapul a sumrek isuna nga adda tugotna a bumaro a bulog a baka a kas daton a gapu iti basol, ken kalakian a karnero kas daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Masapul nga ikawesna ti nasantoan a lino a tunika, ken masapul nga isuotna ti lino a makin-uneg a pagan-anay, ken masapul nga isuotna ti lino a barikes ken lino a turban. Dagitoy dagiti nasantoan a lupot. Masapul nga agdigus isuna iti danum ket kalpasanna ikawesna dagitoy a pagan-anay. ");
INSERT INTO iloulb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Masapul a mangala isuna iti dua a kalakian a kalding manipud iti gimong dagiti tattao iti Israel kas daton gapu iti basol ken maysa a kalakian a karnero kas daton a maipuor amin. ");
INSERT INTO iloulb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ket masapul nga idatag ni Aaron ti bulog a baka a kas daton a gapu iti basol, nga agbalinto a para iti bagina, tapno mangaramid iti pangabbong para kenkuana ken ti pamiliana. ");
INSERT INTO iloulb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ket masapul a mangala isuna iti dua a kalding ket idatagna dagitoy iti sangoanan ni Yahweh idiay pagserrekan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ket masapul nga agbunot ni Aaron para kadagiti dua a kalding, maysa a bunot a para kenni Yahweh, ken ti maysa ket para iti mapapanaw a kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Masapul nga idatag ni Aaron ti kalding a nabunot a para kenni Yahweh, ket idatonna dayta a kalding kas daton a gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ngem ti kalding a nabunot a para iti kalding a mapapanaw ket masapul a maipan a sibibiag iti sangoanan ni Yahweh, tapno mangaramid ti pangabbong babaen iti panangibaonna iti daytoy idiay let-ang a kas kalding a mapapanaw. ");
INSERT INTO iloulb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Kalpasanna, masapul nga idatag ni Aaron ti bulog a baka para iti daton a gapu iti basol, nga agpaayto a para iti bagina. Masapul a mangaramid isuna iti pangabbong para iti bagina ken para iti pamiliana, isu a masapul a patayenna ti bulog a baka a kas daton a gapu iti basol para iti bagina. ");
INSERT INTO iloulb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Masapul a mangala ni Aaron iti insensario a napno iti beggang a naggapu manipud iti altar iti sangoanan ni Yahweh, a napno dagiti imana iti napino a nagiling a nabanglo nga insenso, ket ipanna dagitoy a banbanag idiay likudan iti kurtina. ");
INSERT INTO iloulb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Sadiay ket masapul nga ikabilna ti insenso iti apoy iti sangoanan ni Yahweh tapno ti asuk manipud iti insenso ket maabbonganna ti kalub a pakakitaan iti pannakabbong ti basol iti rabaw ti pammaneknek iti tulag. Masapul nga aramidenna daytoy tapno saan isuna a matay. ");
INSERT INTO iloulb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kalpasanna, masapul a mangala isuna iti dara ti bulog a baka ket iwarsina daytoy babaen iti ramayna idiay sangoanan iti kalub a pakakitaan iti pannakabbong ti basol. Masapul nga iwarsina ti dara babaen iti ramayna iti maminpito iti sangoanan ti kalub a pakakitaan iti pannakabbong ti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Kalpasanna, masapul a patayenna ti kalding a para iti daton a gapu iti basol a para kadagiti tattao ken ipanna ti darana iti likudan ti kurtina. Sadiay ket masapul nga aramidenna iti dara ti kas iti inaramidna iti dara ti bulog a baka: masapul nga iwarsina daytoy iti kalub a pakakitaan iti pannakabbong ti basol ket kalpasanna iti sango iti kalub a pakakitaan iti pannakabbong ti basol. ");
INSERT INTO iloulb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Masapul a mangaramid isuna iti seremonia ti pannakadalus para iti nasantoan a lugar gapu kadagiti narugit nga aramid dagiti Israelita, ken gapu iti panagsalungasingda ken ti amin a basbasolda. Masapul met nga aramidenna daytoy para iti tabernakulo, a pagigianan ni Yahweh iti nagtetengngaanda, iti imatang dagiti narugit nga aramidda. ");
INSERT INTO iloulb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Masapul nga awan ti siasinoman iti uneg iti tabernakulo no sumrek ni Aaron tapno mangaramid iti seremonia ti pannakadalus iti kasasantoan a lugar, ken agingga a rummuar isuna ken malpas a nangaramid iti seremonia ti pannakapakawan para iti bagina ken iti pamiliana, ken para iti entero a gimong ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Masapul a rummuar isuna iti altar nga adda iti sangoanan ni Yahweh ken mangaramid iti seremonia ti pannakadalus para iti daytoy, ken masapul a mangala isuna iti dara ti bulog a baka ken dara ti kalding ket ikabilna daytoy kadagiti sara iti aglawlaw iti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Masapul a mangiwarsi isuna iti dara iti daytoy babaen iti ramayna iti maminpito tapno dalusanna daytoy ken tapno idatonna daytoy kenni Yahweh, manipud iti narugit nga ar-aramid dagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Inton malpasnan a maaramid ti seremonia ti pannakadalus para iti kasasantoan a lugar, ti tabernakulo, ti altar, masapul nga idatagna ti sibibiag a kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Masapul nga ipatay ni Aaron dagiti dua nga imana iti ulo ti sibibiag a kalding ken ipudnona iti kalding dagiti amin a kinadakes dagiti tattao ti Israel, amin a panagsalungasingda, ken amin a basbasolda. Kalpasanna, masapul nga ikabilna dayta a kinamanagbasol iti ulo ti kalding ket palubosanna ti kalding babaen iti panangaywan iti maysa a tao a nakasagana a mangiturong iti kalding idiay let-ang. ");
INSERT INTO iloulb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Masapul nga awiten ti kalding ti amin a kinadakes dagiti tattao idiay awan matataona a lugar. Idiay let-ang, masapul a palubosan ti lalaki ti kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Kalpasanna, masapul nga agsubli ni Aaron iti uneg ti tabernakulo ket ikkatenna ti lino a lupot nga inkawesna sakbay a simmrek iti kasasantoan a lugar, ken masapul nga ibatina dagitoy a lupot idiay. ");
INSERT INTO iloulb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Masapul nga agdigus isuna iti danum idiay nasantoan a lugar, ken ikawesna dagiti gagangay a lupotna; ket masapul a rummuar isuna ken idatonna ti datonna a maipuor amin ken ti daton a maipuor amin a para kadagiti tattao, ken iti daytoy a wagas, mangaramid isuna iti pangabbong para iti bagina ken para kadagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Masapul a puoranna ti taba ti daton a gapu iti basol iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ti nangpalubos a lalaki iti kalding a mapapanaw ket masapul a labaanna dagiti pagan-anayna ken agdigus iti danum; kalpasan dayta, mabalinnan ti agsubli iti uneg ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ti bulog a baka a para iti daton a gapu iti basol ken ti kalding a para iti daton a gapu iti basol, a makindara iti naiyuneg a naaramat iti panangaramid iti seremonia ti pannakadalus iti nasantoan a lugar, ket masapul a mairuar iti kampo. Sadiay ket masapul a puoranda dagiti lalat, lasag, ken bagis. ");
INSERT INTO iloulb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ti mangpuor a lalaki kadagidiay a paset ket masapul a labaanna dagiti pagan-anayna ken agdigus iti danum; kalpasan dayta, mabalinnan ti agsubli iti uneg ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Agnanayonto nga annuroten daytoy para kadakayo nga iti maikapito a bulan, iti maikasangapulo nga aldaw ti bulan, masapul nga agpakumbabakayo ken saankayo nga agtrabaho, naiyanakman ditoy wenno ganggannaet a makipagnanaed kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Daytoy ket gapu ta iti daytoy nga aldaw ti seremonia ti pannakadalus ket naaramid para kadakayo, a mangdalus kadakayo manipud kadagiti amin a basbasolyo tapno agbalinkayo a nadalus iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Daytoy ket napasnek nga Aldaw a Panaginana a para kadakayo, ket masapul nga agpakumbabakayo ken saankayo nga agtrabaho. Agnanayonto nga annuroten daytoy para kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ti kangatoan a padi, ti mapulotan ken madutokan nga agbalin a kangatoan a padi a kasukat ti amana, ket masapul nga aramidenna daytoy a seremonia ti pannakadalus ken ikawesna dagiti lino a lupot, dayta ket, dagiti nasantoan a lupot. ");
INSERT INTO iloulb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Masapul a mangaramid isuna iti seremonia ti pannakadalus para iti kasasantoan a lugar; masapul a mangaramid isuna iti seremonia ti pannakadalus para iti tabernakulo ken para iti altar, ken masapul a mangaramid isuna iti seremonia ti pannakadalus para kadagiti papadi ken para iti amin a tattao iti sangkagimongan. ");
INSERT INTO iloulb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Agnanayonto nga annoruten daytoy para kadakayo, a mangaramid iti seremonia ti pannakadalus para kadagiti tattao ti Israel gapu kadagiti amin a basbasolda, maminsan iti makatawen.” Ket naaramid daytoy kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Nagsao ni Yahweh kenni Moises a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Agsaoka kenni Aaron ken kadagiti putotna a lallaki, ken kadagiti amin a tattao ti Israel. Ibagam kadakuada ti imbilin ni Yahweh: ");
INSERT INTO iloulb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","'Siasinoman a tao manipud iti Israel a mangpapatay iti baka, karnero, wenno kalding iti uneg ti kampo, wenno mangpapatay kadagitoy iti ruar ti kampo, tapno idatonna— ");
INSERT INTO iloulb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","no saanna nga ipan daytoy iti pagserkan iti tabernakulo tapno idatonna a kas daton kenni Yahweh iti sangoanan ti tabernakulona, dayta a tao ket nakabasol iti panangpapatay. Nangpapatay isuna, ket masapul a mailaksid dayta a tao manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ti panggep daytoy a bilin ket tapno ipan dagiti tattao ti Israel dagiti datonda kenni Yahweh idiay pagserkan iti tabernakulo, iti padi tapno maidaton a kas datdaton para iti panagkakadua kenni Yahweh, imbes nga idaton dagiti daton iti away. ");
INSERT INTO iloulb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Iwarsi ti padi ti dara iti rabaw ti altar ni Yahweh nga adda iti ruangan ti tabernakulo; puoranna ti taba tapno mangipaay daytoy iti nabanglo nga ayamuom para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Masapul a saanen nga idaton dagiti tattao dagiti datonda kadagiti sinankalding a didiosen, a pagtigtignayanda a kasla balangkantis. Agbalinto daytoy nga agnanayon nga alagaden para kadakuada iti amin a henerasion dagiti tattaoda.' ");
INSERT INTO iloulb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Masapul nga ibagam kadakuada, 'Siasinoman a tao ti Israel, wenno siasinoman a ganggannaet a makipagnaed kadakuada, a mangisagut iti daton a maipuor amin wenno sakrifisio ");
INSERT INTO iloulb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ken saanna nga ipan daytoy iti ruangan ti tabernakulo tapno idatonna kenni Yahweh, dayta a tao ket masapul a mailaksid manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Ken siasinoman iti Israel, wenno siasinoman a ganggannaet a makipagnanaed kadakuada, a mangan iti aniaman a dara, busorekto dayta a tao, siasinoman a mangan iti dara; ilaksidkonto isuna manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ta ti biag ti ayup ket adda iti darana. Intedko ti darana kadakayo tapno mangaramid iti pangabbong iti rabaw ti altar para kadagiti bibiagyo, gapu ta ti dara ti maaramid a pangdalus, ta ti dara ti mangpakawan para iti biag. ");
INSERT INTO iloulb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ngarud, ibagak kadagiti tattao ti Israel a masapul nga awan ti uray maysa kadakayo a mangan iti dara, wenno awan uray siasinoman kadagiti ganggannaet a makipagnaed kadakayo ti mabalin a mangan iti dara. ");
INSERT INTO iloulb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Siasinoman kadagiti tattao ti Israel wenno siasinoman kadagiti ganggannaet a makipagnaed kadakuada a mang-anup ken mangpapatay iti ayup wenno billit a mabalin a makan, masapul nga ibukbok dayta a tao ti dara ti ayup ket gaburanna ti dara iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ta ti biag ti tunggal parsua ket ti darana. Isu nga ibagak kadagiti tattao ti Israel, “Masapul a diyo kanen ti dara ti aniaman a parsua, ta ti biag ti tunggal sibibiag a parsua ket ti darana. Siasinoman a mangan iti daytoy ket masapul a mailaksid.” ");
INSERT INTO iloulb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Tunggal tao a mangan iti ayup a natay wenno rinangrangkay dagiti atap nga ayup, dayta man a tao ket nayanak nga umili wenno maysa a ganggannaet a makipagnanaed kadakayo, masapul a labaanna dagiti pagan-anayna ken agdigos iti danum, ket maibilang isuna a narugit agingga iti rabii. Kalpasanna ket nadaluston isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ngem no saanna a labaan dagiti pagan-anayna wenno digusen ti bagina, ket masapul nga ikarona ti basolna.'” ");
INSERT INTO iloulb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Nagsao ni Yahweh kenni Moises, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Agsaoka kadagiti tattao ti Israel ket ibagam kadakuada, 'Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Masapul a diyo aramiden dagiti banbanag nga ar-aramiden dagiti tattao idiay Egipto a nagnaedanyo idi. Ken masapul a diyo aramiden dagiti banbanag nga ar-aramiden dagiti tattao idiay Canaan, ti daga a pangipanak kadakayo. Diyo suroten dagiti kaugalianda. ");
INSERT INTO iloulb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Dagiti lintegko dagiti masapul nga aramidenyo ken dagiti bilbilinko ti masapul a salimetmetanyo, tapno makapagnakayo kadagitoy, gapu ta Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ngarud, masapul a salimetmetanyo dagiti alagadek ken dagiti lintegko. No agtulnog ti maysa a tao kadagitoy, agbiagto isuna gapu kadagitoy. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Masapul nga awan ti uray maysa a makikaidda iti siasinoman nga asideg a kabagianna. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Dimo ibabain ti amam babaen iti pannakikaiddam iti inam. Inam isuna! Masapul a dimo ibabain isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Dimo kaiddaen ti siasinoman kadagiti assawa ti amam; masapul a dimo ibabain iti kasta ti amam. ");
INSERT INTO iloulb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Dimo kaiddaen ti siasinoman kadagiti kakabsatmo a babbai, anak man a babai isuna ti amam wenno anak a babai ti inam, napadakkel man isuna iti pagtaenganyo wenno iti adayo manipud kadakayo. Masapul a dimo kaiddaen dagiti kakabsatmo a babbai. ");
INSERT INTO iloulb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Dimo kaiddaen ti anak a babai ti anakmo a lalaki wenno ti anak a babai ti anakmo a babai. Bukodmo a pakaibabainan dayta. ");
INSERT INTO iloulb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Dimo kaiddaen ti anak a babai ti asawa ti amam, a putot ti amam. Kabsatmo isuna, ket rumbeng a dimo kaiddaen isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Dimo kaiddaen ti babai a kabsat ti amam. Asideg isuna a kabagian ti amam. ");
INSERT INTO iloulb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Dimo kaiddaen ti babai a kabsat ti inam. Asideg isuna a kabagian ti inam. ");
INSERT INTO iloulb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Dimo ibabain ti lalaki a kabsat ti amam babaen iti pannakikaiddam iti asawana. Dika umasideg kenkuana para iti dayta a panggep; ikitmo isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Dimo kaiddaen ti manugangmo a babai. Asawa isuna ti anakmo a lalaki; dimo kaiddaen isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Dimo kaiddaen ti asawa ti kabsatmo a lalaki; dimo ibabain isuna iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Dimo kaiddaen ti babai ken ti anakna a babai, wenno ti anak a babai ti anakna a lalaki wenno ti anak a babai ti anakna a babai. Asidegda a kabagianna, ket kinadangkes ti pannakikaidda kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Dimo asawaen ti kabsat a babai ti asawam a kas maikadua nga asawam ken kaiddaen isuna kabayatan a sibibiag pay ti umuna nga asawam. ");
INSERT INTO iloulb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Dimo kaiddaen ti babai kabayatan ti panagreglana. Narugit isuna kabayatan dayta a tiempo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Dimo kaiddaen ti asawa a babai ti kaarrubam ken tulawan ti bagim babaen kenkuana iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Dimo ited ti siasinoman kadagiti annakmo a mapuoran, tapno idatonmo ida kenni Moloc, gapu ta masapul a dimo ibabain ti nagan ti Diosmo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Dimo kaiddaen ti padam a lalaki a kasla iti pannakikaiddam iti babai. Daytoy ket kinadangkes. ");
INSERT INTO iloulb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Dimo kaiddaen ti aniaman nga ayup ken tulawan ti bagim iti daytoy. Masapul nga awan ti babai a mangpanunot a makikaidda iti aniaman nga ayup. Daytoy ket kinaderrep. ");
INSERT INTO iloulb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Diyo rugitan dagiti bagiyo iti aniaman kadagitoy a wagas, ta kadagitoy amin a wagas ket natulawan dagiti nasion, dagiti nasion a paksiatekto iti imatangyo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Natulawan ti daga, isu a dinusak dagiti basolda ket pinapanaw ti daga dagiti agnanaed kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Dakayo, ngarud, masapul a salimetmetanyo dagiti bilbilinko ken dagiti alagadek ken masapul a diyo aramiden ti aniaman kadagitoy a makarimon a banbanag, Israelita man a naiyanak nga umili wenno ganggannaet a makipagnanaed kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ta daytoy ti kinadangkes nga inaramid dagiti tattao iti daga, dagiti nagnaed ditoy sakbay kadakayo ket ita natulawanen ti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Agannadkayo ngarud tapno dinakay met isarua ti daga kalpasan a tinulawanyo daytoy a kas iti panangisaruana kadagiti tattao nga immun-una kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Siasinoman a mangaramid kadagitoy a makarimon a banbanag, dagiti tattao a mangaramid iti kasta a banbanag ket mailaksid manipud kadagiti tattaoda. ");
INSERT INTO iloulb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ngarud, salimetmetanyo dagiti bilinko a diyo aramiden ti aniaman kadagitoy a makarimon a kaugalian a naaramid ditoy sakbay kadakayo, tapno diyo matulawan dagiti bagiyo babaen kadagitoy. Siak ni Yahweh a Diosyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Nagsao ni Yahweh kenni Moises a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Agsaoka iti sangkagimongan dagiti tattao ti Israel ket ibagam kadakuada, 'Masapul a nasantoankayo, ta Siak ni Yahweh a Diosyo ket nasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Masapul a raemen ti tunggal maysa ti ina ken amana ken masapul a salimetmetanyo dagiti Aldaw a Panaginana. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Dikay agsubli kadagiti awan pategna a didiosen wenno agaramid kadagiti didiosen a landok para kadagiti bagiyo. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Inton mangidatonkayo iti daton para iti panagkakadua kenni Yahweh, masapul nga idatonyo daytoy tapno mabalinto a maawatkayo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Masapul a kanenyo daytoy iti isu met laeng nga aldaw nga idatonyo daytoy wenno iti sumaruno nga aldaw. No adda man ti mabati agingga iti maikatlo nga aldaw, masapul a mapuoran daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","No makanyo daytoy iti maikatlo nga aldaw, narugit daytoy. Masapul a saan a maawat daytoy, ");
INSERT INTO iloulb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ngem tunggal maysa a mangan iti daytoy ket rumbeng nga ikarona ti nagbiddutanna gapu ta rinugitanna ti naidaton kenni Yahweh. Dayta a tao ket masapul a mailaksid manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Inton apitenyo ti apit ti dagayo, masapul a diyo apiten a naan-anay dagiti adda kadagiti suli ti talonyo wenno urnongen amin a mapataud ti apityo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Masapul a diyo urnongen amin nga ubas manipud iti kaubasanyo wenno urnongen dagiti ubas a naregreg iti daga ti kaubasanyo. Masapul nga ibatiyo dagitoy para kadagiti napanglaw ken para kadagiti ganggannaet. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Dikay agtakaw. Dikay agulbod. Diyo allilawen ti tunggal maysa. ");
INSERT INTO iloulb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Dikay agsapata a siuulbod babaen iti naganko ken tulawan ti nagan ti Diosyo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Diyo idadanes ti kaarrubayo wenno takawan isuna. Masapul a saan nga agtalinaed kadakayo iti agpatnag agingga iti agsapa dagiti tangdan ti mangmangged nga adipen. ");
INSERT INTO iloulb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Diyo ilunod ti tuleng wenno mangikabil iti pakaitibkolan iti sangoanan ti bulsek. Ngem ketdi, masapul nga agbutengkayo iti Diosyo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Diyo pagbalinen a palso ti pannakaukom. Masapul a dikay mangipakita iti panangidumduma iti maysa a tao gapu ta isuna ket napanglaw ken masapul a dikay mangipakita iti panangidumduma iti maysa a tao gapu ta isuna ket napateg. Ngem ketdi, ukomenyo a sililinteg ti kaarrubayo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Dikay agpagnapagna iti aglawlaw a mangiwarwaras iti palso a damag kadagiti tattaoyo ngem aramidenyo ti kabaelanyo a mangsaluad iti biag ti kaarrubayo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Diyo guraen ti kabsatyo dita pusoyo. Masapul a tubngarenyo a sipupudno ti kaarrubayo tapno dikay makabasol gapu kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Dikay agibales wenno agipempen iti gura a maibusor iti siasinoman kadagiti tattaoyo, ngem ketdi, ayatenyo ti kaarrubayo a kas iti bagiyo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Masapul a salimetmetanyo dagiti bilinko. Diyo padasen nga ipamanada dagiti ayupyo kadagiti sabali a kita dagiti ayup. Diyo paglaoken ti dua nga agduma a kita dagiti bukel no agmulmulakayo iti talonyo. Dikay agisuot iti pagan-anay a naaramid manipud iti dua a kita ti naglaok a materiales. ");
INSERT INTO iloulb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Siasinoman a makikaidda iti tagabu a babai a naikari a maiyasawa ngem saan pay laeng a nasubbot wenno nawayawayaan, masapul a madusada. Masapul a dida mapapatay gapu ta saan isuna a nawayawayaan. ");
INSERT INTO iloulb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Masapul nga ipan ti lalaki kenni Yahweh ti datonna a pangsupapak iti nagbiddutanna iti pagserkan ti tabernakulo — maysa a kalakian a karnero a kas daton a pangsupapak iti biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ket aramidento ti padi ti seremonia ti pangabbong iti basol para kenkuana babaen iti kalakian a karnero a para iti daton a pangsupapak iti biddut iti sangoanan ni Yahweh para iti basol a naaramidna. Ket mapakawanton ti basol a naaramidna. ");
INSERT INTO iloulb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Inton mapankayo iti daga ket nagimulakayo kadagiti amin a kita dagiti kayo para iti taraon ket masapul nga ibilangyo dagiti bungada a maiparit a kanen. Masapul a maiparit ti bunga kadakayo iti las-ud ti tallo a tawen. Masapul a saan a kanen daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ngem iti maikapat a tawen ket agbalinto a nasantoan dagiti amin a bunga, maysa a daton a panangidayaw kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Iti maikalima ket mabalinyon a kanen ti bunga nga inurayyo tapno dagiti kayo ket agbunga pay iti ad-adu. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Dikay mangan iti aniaman a karne nga adda pay laeng darana. Dikay makiuman kadagiti espiritu maipanggep iti masakbayan ken diyo tarigagayan a tenglen ti dadduma babaen kadagiti saan a gagangay a pannakabalin. ");
INSERT INTO iloulb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Diyo tuladen dagiti aramid dagiti pagano a kas iti panangkuskusyo iti sikigan ti uloyo wenno panangputed iti barbasyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Diyo sugaten ti bagiyo gapu iti natay wenno mangikabil kadagiti marka iti bagiyo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Diyo ibabain ti anakyo a babai babaen iti panangaramidyo kenkuana a balangkantis, ta no saan, agtinnag ti nasion iti panagbalangkantis ket mapnoan ti daga iti kinadangkes. ");
INSERT INTO iloulb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Masapul a salimetmetanyo dagiti Aldaw a Panaginana ken dayawen ti santuario ti tabernakulok. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Dikay mapan kadagiti makisarsarita iti natay wenno kadagiti espiritu. Diyo biruken ida, ta rugitan dakayo. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Masapul a tumakderkayo iti sangoanan ti ubanan a tao ken padayawanyo ti presensia ti nataengan a tao. Masapul nga agbutengkayo iti Diosyo. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","No adda ganggannaet a makipagnaed kadakayo iti dagayo, masapul a diyo pagaramidan isuna iti aniaman a biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ti ganggannaet a makipagnaed kadakayo ket masapul a kaslada Israelita a nayanak nga umili nga agnaed kadakayo ken masapul nga ayatenyo isuna a kas iti bagiyo, gapu ta ganggannaetkayo met idi iti daga ti Egipto. Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Dikay agusar kadagiti saan a husto a pagrukod no agrukodkayo iti kaatiddog, kadagsen, wenno kaadu. ");
INSERT INTO iloulb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Masapul nga agusarkayo kadagiti husto a pagrukod, husto a pagtimbangan, husto nga efa, ken husto a hin. Siak ni Yahweh a Diosyo a nangiruar kadakayo iti daga ti Egipto. ");
INSERT INTO iloulb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Masapul a tungpalenyo dagiti amin nga alagadek ken amin a lintegko ken aramidenyo dagitoy. Siak ni Yahweh.'” ");
INSERT INTO iloulb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nagsao ni Yahweh kenni Moises, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Ibagam kadagiti Israelita, 'Siasinoman kadagiti tattao ti Israel, wenno siasinoman a ganggannaet nga agnanaed iti Israel a mangted iti siasinoman kadagiti annakna kenni Moloc, ket masapul a mapapatay. Masapul a batuen isuna dagiti tattao iti dayta a daga. ");
INSERT INTO iloulb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ilisikto met ti rupak iti dayta a tao ken ilaksidkonto isuna manipud kadagiti tattaona gapu ta intedna ti anakna kenni Moloc, tapno laeng marugitan ti nasantoan a lugarko ken saan a maraem ti nasantoan a naganko. ");
INSERT INTO iloulb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","No ikidem dagiti tattao iti dayta a daga dagiti matada iti dayta a tao inton intedna ti siasinoman kadagiti anakna kenni Moloc, no saanda isuna a papatayen, ");
INSERT INTO iloulb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ket ibaw-ingkonto ngarud ti rupak a maibusor iti dayta a tao ken iti pulina, ket ilaksidkonto isuna ken dagiti isuamin a nangaramat iti bagina iti dakes tapno agbalin a balangkantis para kenni Moloc. ");
INSERT INTO iloulb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Ti tao a mapan kadagiti makisasao kadagiti natay, wenno kadagiti makisasao kadagiti espiritu tapno aramatenda dagiti bagida kadakuada iti dakes, Ibaw-ingkonto ti rupak a maibusor iti dayta a tao; ilaksidkonto isuna manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ngarud, idatonyo dagiti bagiyo kenni Yahweh ket agbalinkayo a nasantoan, gapu ta siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Masapul a salimetmetanyo dagiti bilbilinko ken masapul a tungpalenyo dagitoy. Siak ni Yahweh, ti nangilasin kadakayo a maipaay kaniak. ");
INSERT INTO iloulb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Dagiti amin a mangilunod iti amana wenno iti inana ket awan duadua a masapul a mapapatay. Inlunodna ti amana wenno inana, isu a nagbasol isuna ket maikari a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ti lalaki a makikamalala iti asawa iti sabali a lalaki, dayta ket, siasinoman a makikamalala iti asawa ti kaarubana—ti nakikamalala a lalaki ken ti nakikamalala a babai ket awan duadua a masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ti lalaki a makikaidda iti asawa ti amana ket imbabainna ti bukodna nga ama. Ti anak a lalaki ken ti asawa ti amana ket agpada a masapul a mapapatay. Nagbasolda ket maikarida a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","No makikaiddda ti maysa a lalaki iti manugangna a babai, isuda a dua ket awan duadua a masapul a mapapatay. Nakaaramidda iti kinaderrrep. Nagbasolda ket maikarida a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","No ti maysa a lalaki ket makikaidda iti sabali a lalaki, kasta met iti babai, agpadada a nakaaramid iti maysa a banag a makarimon. Awan duadua a masapul a mapapatayda. Nakabasolda ket maikarida a matay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","No ti maysa a lalaki ket mangasawa iti babai ken inasawana met laeng ti inana, daytoy ket kinadangkes. Masapul a mapuoranda, isuna ken iti babai, tapno awanen ti kinadangkes kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","No ti maysa a lalaki ket makikaidda iti maysa nga ayup, awan duadua a masapul a mapapatay isuna, ken masapul a patayenyo ti ayup. ");
INSERT INTO iloulb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","No ti maysa a babai ket umasideg ti aniaman nga ayup tapno kaiddaenna daytoy, masapul a papatayenyo ti babai ken ti ayup. Awan dua dua a masapul a mapapatayda. Nagbasolda ket maikarida a matay. ");
INSERT INTO iloulb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","No makikaidda ti maysa a lalaki iti kabsatna a babai, anakman a babai ti amana wenno iti anak a babai ti inana— no makikaidda isuna kenkuana ken ti babai ket makikaidda met kenkuana, nakababain daytoy a banag. Masapul a mailaksidda iti imatang dagiti tattaoda, gapu ta nakikaidda isuna iti kabsatna a babai. Masapul nga ikarona ti basolna. ");
INSERT INTO iloulb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","No makikaidda ti maysa a lalaki iti maysa a babai kabayatan iti panagreglana ket nakikaidda kenkuana, inikkatna ti abbong ti pagayusan ti darana, ti pagtataudan ti darana. Agpada a masapul a mailaksid ti babai ken lalaki kadagiti tattaoda. ");
INSERT INTO iloulb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Masapul a dika makikaidda iti babai a kabsat ti inam wenno amam, gapu ta ibabainmonto ti asideg a kabagiam. Masapul nga ikarom ti bukodmo a basol. ");
INSERT INTO iloulb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","No ti maysa a lalaki ket makikaidda iti asawa ti ulitegna, imbabainna ti ulitegna. Masapul nga ikaroda iti nagbasolanda ket matayda nga awanan iti anak. ");
INSERT INTO iloulb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","No ti maysa a lalaki ket asawaenna ti asawa ti kabsatna a lalaki, daytoy ket kinarugit gapu ta naaddaan isuna iti pakainaigan a mangsalungasing ti panangasawa ti kabsatna a lalaki, ket saandanto a maaddaan iti anak. ");
INSERT INTO iloulb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Masapul ngarud a salimetmetanyo dagiti amin nga alagadek ken dagiti amin a lintegko; masapul a tungpalenyo dagitoy tapno saanakayo nga isarwa iti daga a pangipanak kadakayo a pagnaedanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Masapul a saanyo a suroten iti kaugalian dagiti nasion a paksiatekto iti sangoananyo, gapu ta inaramidda amin dagitoy a banbanag, ket karimonko ida. ");
INSERT INTO iloulb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Imbagak kadakayo, “Tawidenyonto ti dagada; itedkonto kadayo tapno tagikuaenyo, maysa a daga nga addaan ti agay-ayus a gatas ken diro. Siak ni Yahweh a Diosyo, a nangisina kadakayo manipud kadagiti dadduma a tattao. ");
INSERT INTO iloulb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Masapul ngarud nga mailasinyo ti nadalus ken narugit nga ayup ken ti nadalus a billit ken saan a nadalus. Masapul a saanyo a rugitan dagiti bagbagiyo babaen kadagiti narugit nga ayup wenno billit wenno aniaman nga agkarkarayam iti daga, nga inlasinko a kas narugit manipud kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Masapul a nasantoankayo, ta siak, a ni Yahweh, ket nasantoan, ken inlasinakayo manipud kadagiti sabali a tattao, gapu ta kukua kayo. ");
INSERT INTO iloulb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Ti lalaki wenno babai a makitungtong iti natay wenno makitungtong kadagiti espiritu ket awan duadua a masapul a mapapatayda. Masapul a batoen ida dagiti tattao. Nagbasolda ket maikarida a matay.” ");
INSERT INTO iloulb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kinuna ni Yahweh kenni Moises: “Makisaritaka kadagiti papadi, dagiti annak ni Aaron ket ibagam kadakuada, “Awan ti siasinoman kadakayo ti rumbeng a mangrugit iti bagina gapu kadagiti natay manipud kadagiti tattaona, ");
INSERT INTO iloulb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","malaksid iti asideg a kabagianna—para iti ina ken amana, para iti anakna a lalaki ken anakna a babai, wenno para iti kabsatna a lalaki ");
INSERT INTO iloulb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","wenno para iti birhen a kabsatna a babai nga adda iti balayna ken awan pay ti asawana. Mabalinna a rugitan ti bagina para kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ngem masapul a saanna a rugitan ti bagina para kadagiti sabali a kakabagianna, tapno marugitan ti bagina. ");
INSERT INTO iloulb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Masapul a saan a kuskosan dagiti padi ti uloda wenno kuskusan ti igid dagiti barbasda, kasta met a saanda a sugaten dagiti bag- bagida. ");
INSERT INTO iloulb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Masapul a maisinada para iti Diosda, ken saanda nga ibabain ti nagan ti Diosda, gapu ta idaton dagiti padi dagiti daton kenni Yahweh babaen iti apuy, ti “taraon” ti Diosda. Ngarud, masapul a maisinada. ");
INSERT INTO iloulb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Masapul a saanda a mangasawa iti siasinoman a balangkantis a babai, ken narugit, ken masapul a saanda a mangasawa iti babai a nakisina iti asawana, gapu ta naisinada para iti Diosda. ");
INSERT INTO iloulb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Masapul nga idatonyo isuna ta idatonna ti “taraon” manipud iti Diosyo. Masapul a nasantoan isuna iti imatangyo, gapu ta Siak, a ni Yahweh, a nangilasin kadakayo para kaniak, ket nasantoanak met. ");
INSERT INTO iloulb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Siasinoman nga anak a babai ti siasinoman a padi a mangrugit iti bagina babaen iti panagbalinna a balangkantis ket ibabainna ti amana. Masapul a mapuoran isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Isuna a kangatoan a padi kadagiti kakabsatna a lallaki, nga ti ulona ket isu ti nakaibukbokan ti pammulot a lana, ken nakonsagraran a mangikawes iti naisangsangayan a pagan-anay ti kangatoan a padi, ket masapul a saanna nga iwakray ti buokna ken pigisen ti badona. ");
INSERT INTO iloulb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Masapul a saan a mapan isuna iti sadinoman nga ayan ti natay ket rugitanna ti bagina, uray no ti amana wenno ti inana ti natay. ");
INSERT INTO iloulb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Masapul a saan a panawan ti kangatoan a padi ti nasantoan a disso iti tabernakulo wenno saanna a raemen ti santuario ti Diosna, gapu ta nakonsagraran isuna a kas kangatoan a padi babaen iti pammulot a lana ti Diosna. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ti kangatoan a padi ket masapul a mangasawa ti maysa a birhen. ");
INSERT INTO iloulb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Masapul a saan isuna a mangasawa iti balo, wenno babai a nakisina iti asawana, wenno balangkantis a babai. Masapul a saanna nga asawaen dagiti kakastoy a kita dagiti babai. Mabalinna laeng ti mangasawa iti maysa a birhen manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Masapul nga agtulnog isuna kadagitoy nga annuroten, tapno saanna a marugitan dagiti annakna kadagiti tattaona, ta siak ni Yahweh, a nangilasin kenkuana para kaniak.''' ");
INSERT INTO iloulb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Nagsao ni Yahweh kenni Moises, a kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Makisaritaka kenni Aaron ket ibagam kenkuana, 'Siasinoman kadagiti kaputotam iti amin a henerasyonda nga addaan iti pakapilawan ti bagina, masapul a saan isuna nga umasideg a mangidaton ti 'taraon' iti Diosna. ");
INSERT INTO iloulb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Siasinoman a tao nga addaan iti pakapilawan iti bagina ket masapul a saan nga umasideg kenni Yahweh, kas iti maysa a bulsek a tao, pilay a tao, maysa a nadadael ti porma ti bagina wenno adda kurang ti bagina, ");
INSERT INTO iloulb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","tao a paralitiko ti ima wenno sakana, ");
INSERT INTO iloulb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kubbo wenno pandek a tao, wenno maysa atao nga adda dadael ti matana, wenno addaan ti sakit ti kudil, sugat, gaddil, wenno nadadael ti nailimmeng a parte ti bagina. ");
INSERT INTO iloulb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Awan ti siasinoman a tao kadagiti kaputotan ti padi a ni Aaron nga adda depekto ti bagina ti mabalin nga umasideg tapno mangidatag iti daton a mapuoran a para kenni Yahweh. Ti kasta a tao nga adda depekto ti bagina; masapul a saan isuna nga umasideg a mangidaton iti 'taraon' ti Diosna. ");
INSERT INTO iloulb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mabalinna a kanen ti taraon ti Diosna, dagiti kasasantoan man wenno sumagmamano kadagiti nasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nupay kasta, masapul a saan isuna a sumrek iti nalengdan ti kurtina wenno umasideg iti altar, gapu ta adda depekto ti bagina, tapno saanna a rugitan ti nasantoan a lugarko, gapu ta siak ni Yahweh, a nangidaton kadakuada kaniak.”' ");
INSERT INTO iloulb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Imbaga ngarud ni Moises dagitoy a sasao kenni Aaron, kadagiti annakna ken kadagiti amin a tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Nagsao ni Yahweh kenni Moses, kunana, ");
INSERT INTO iloulb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","''Makisaritaka kenni Aaron, ken kadagiti annakna a lallaki ket ibagam kadakuada nga umadayoda kadagiti nasantoan a bambanag dagiti Israelita, nga idatonda kaniak. Masapul a saanda a rugitan ti nasantoan a naganko. Siak ni Yahweh ");
INSERT INTO iloulb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ibagam kadakuada, 'Siasinoman kadagiti amin a kaputotanyo iti entero a henerasion dagiti tattaoyo a narugit inton asetganna dagiti nasantoan a bambanag nga idaton dagiti Israelita kenni Yahweh, dayta a tao ket masapul a mailaksid manipud iti sangoanak. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Awan kadagiti kaputotan ni Aaron nga addaan iti makaakar a sakit ti kudil, wenno makaakar nga agtedtedted manipud iti bagina, ti mabalin a mangan iti aniaman a daton a naaramid para kenni Yahweh agingga nga agbalin isuna a nadalus. Siasinoman a mangsagid iti aniaman a narugit babaen ti panangsagid iti natay, wenno babaen iti panangsagid iti lalaki nga addaan ti agtedtedted a kissit, ");
INSERT INTO iloulb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","wenno siasinoman a mangsagid iti aniaman nga ayup nga agkarkarkarayam a mamagbalin kenkuana a narugit, wenno siasinoman a tao a mamagbalin kenkuana a narugit, aniaman a kita ti kinarugit daytoy— ");
INSERT INTO iloulb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ngarud, ti padi a mangsagid iti aniaman a narugit a banag ket agbalin a narugit aginggana iti rabii. Masapul a saan isuna a mangan kadagiti aniaman a nasantoan a bambanag malaksid no agdigus isuna iti danum. ");
INSERT INTO iloulb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","No limneken ti init, naduluston isuna. No limneken ti init mabalinnan ti mangan manipud kadagiti nasantoan a bambanag, gapu ta taraonna dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Masapul a saan isuna a mangan iti aniaman a nasarakan a natay wenno pinatay dagiti narungsot nga ayup, a babaen kadagitoy ket rugitanna ti bagina. Siak ni Yawhweh. ");
INSERT INTO iloulb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Masapul a suroten dagiti papadi dagiti bilinko, ta no saan agbasolda ket mabalin a matayda gapu iti saanda a panangraem kaniak. Siak ni Yahweh, a nangidaton kadakuada para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Awan ti siasinoman a saan a kameng ti pamilia ti padi, karaman dagiti sangaili ti padi wenno dagiti natangdanan nga dipenna, ti mabalin a mangan iti aniaman a nasantoan. ");
INSERT INTO iloulb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ngem no gumatang ti padi ti siasinoman a tagabo iti bukodna a kuarta, mabalin a mangan dayta a tagabo kadagiti bambanag a nailasin para kenni Yahweh. Ken dagiti kamkameng iti pamilia ti padi ken dagiti tagabo a naiyanak iti balayna, mabalinda met a makipangan kenkuana manipud kadagidiay a bambanag. ");
INSERT INTO iloulb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","No ti anak a a babai ti padi ket nakiasawa iti saan a padi, saanna a mabalin ti mangan iti aniaman kadagiti nasantoan a daton. ");
INSERT INTO iloulb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ngem no ti anak a babai ti padi ket maysa a balo, wenno nakisina iti asawana, ken no awan ti anakna, ken no agsubli isuna nga agnaed iti balay ti amana kas idi agtutubo isuna, mabalinna ti mangan manipud iti taraon ti amana. Ngem awan ti siasinoman a saan a kameng ti pamilia ti padi iti mabalin a mangan manipud iti taraon ti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","No makapangan ti maysa a tao iti nasantoan a taraon a saanna nga ammo daytoy, ket masapul a bayadanna ti padi gapu iti daytoy; masapul a nayunanna daytoy ti apagkalima ket isublina daytoy iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Masapul a saan nga ibabain dagiti Israelita dagiti nasantoan a bambanag nga intag-ay ken indatagda kenni Yahweh, ");
INSERT INTO iloulb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ken pakaigapuan nga awitenda ti basol a mamagbalin kadakuada nga makabasol iti pannanganda iti nasantoan a taraon, ta siak ni Yahweh, a nangilasin kadakuada para kaniak.''' ");
INSERT INTO iloulb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Nagsao ni Yahweh kenni Moses, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Makisaritaka kenni Aaron ken kadagiti putotna a lallaki, ken kadagiti amin nga Israelita. Ibagam kadakuada, 'Siasinoman nga Israelita, wenno ganggannaet nga agnanaed iti Israel, inton mangidatagda iti daton— daytoy man ket pangtungpal ti sapata, wenno daytoy man ket daton a nagtaud iti bukod a nakem, wenno mangidatag kenni Yahweh ti daton a maipuor amin, ");
INSERT INTO iloulb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","no daytoy ket tapno maawat, masapul nga agidatonda iti kalakian nga ayup nga awan mulitna manipud iti baka, karnero, wenno kadagiti kalding. ");
INSERT INTO iloulb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ngem masapul a saankayo a mangidaton iti aniaman nga adda iti mulitna. Saankonto nga awaten daytoy para iti biangyo. ");
INSERT INTO iloulb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ti siasinoman a mangidatag kenni Yahweh iti daton para iti panagkakadua manipud iti aniaman a kita ti arban kenni Yahweh a mangtungpal iti sapata, wenno kas daton a nagtaud iti bukod a nakem, masapul nga awan ti pakapilawanna tapno maawat daytoy. Masapul nga awan iti mulitna ti ayup. ");
INSERT INTO iloulb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Masapul a saankayo nga agidaton kadagiti ayup a bulsek, baldado wenno pilay, wenno adda ritingna, sug-sugat, wenno gud-gudna. Masapul a saanyo nga idaton dagitoy kenni Yahweh a kas daton a mapuoran iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Mabalinyo nga idatag a kas daton a nagtaud iti bukod a nakem ti maysa a bassit a bulog a baka wenno karnero wenno saan a nasayaat ti panagdakkelna, ngem ti kasta a daton ket saan a maawat a para iti maysa a sapata. ");
INSERT INTO iloulb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Saankayo nga agidaton kenni Yahweh kadagiti ayup nga adda sugatna, natumek, narangrangkay wenno nakapon. Saanyo nga idaton dagitoy iti dagayo, ");
INSERT INTO iloulb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ken saanyo nga awaten dagitoy manipud kadagiti ima ti gangannaet a kas taraon a maidatag iti Dios, gapu ta dagitoy ket addaan iti depekto wenno mulitna. Saanko nga awaten dagitoy para iti biangyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Nagsao ni Yahweh kenni Moses ket kinunana, “ ");
INSERT INTO iloulb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","No maiyanak ti kalakian a baka wenno karnero wenno kalding, masapul nga agtalinaed daytoy iti denna ti inana iti pito nga aldaw. Ket manipud iti maikawalo nga aldaw, mabalinen nga awaten daytoy a kas daton a mapuoran kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Saankayo a mangpatay iti baka wenno kabaian a karnero agraman dagiti urbonda, iti isu met laeng nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","No mangipaaykayo iti daton a panagyaman kenni Yahweh, masapul nga idatonyo daytoy iti makaay-ayo a wagas. ");
INSERT INTO iloulb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Masapul a makan daytoy iti isu met laeng nga aldaw a naidaton daytoy. Masapul nga awan ti ibatiyo agingga iti sumaruno a bigat. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Masapul ngarud a salimetmetanyo dagiti bilbilinko ket tungpalenyo dagitoy. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Masapul a saanyo nga ibabain ti nasantoan a naganko. Masapul a bigbigendak dagiti Israelita a kas nasantoan. Siak ni Yahweh a nangilasin kadakayo para kaniak, ");
INSERT INTO iloulb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","a nangiruar kadakayo manipud iti daga ti Egipto, tapno agbalin a Diosyo. Siak ni Yahweh.'' ");
INSERT INTO iloulb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Nagsao ni Yahweh kenni Moises: ");
INSERT INTO iloulb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Agsaoka kadagiti Israelita, ket ibagam kadakuada, 'Dagiti naituding a fiesta a maipaay kenni Yahweh, a masapul nga iwaragawagyo a kas nasantoan a panagtitipon, ket dagiti kadawyan a fiestak. ");
INSERT INTO iloulb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Mabalinkayo nga agtrabaho iti innem nga aldaw, ngem ti maikapito nga aldaw ket naan-anay nga Aldaw a Panaginana, maysa a nasantoan a panagtitipon. Masapul a saankayo nga agtrabaho gapu ta Aldaw a Panaginana daytoy para kenni Yahweh iti amin a lugar a pagnaedanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Dagitoy dagiti naituding a fiesta ni Yahweh, dagiti nasantoan a panagtitipon a masapul nga ipablaakyo kadagiti naituding a tiempoda: ");
INSERT INTO iloulb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Iti umuna a bulan, iti maika-sangapulo ket uppat nga aldaw ti bulan iti sumipnget ket ti Fiesta ti Ilalabas ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ti maika-sangapulo ket lima nga aldaw iti isu met laeng a bulan ket ti Fiesta ti Tinapay nga Awan Lebadurana. Masapul a mangankayo iti tinapay nga awan lebadurana iti las-ud iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Iti umuna nga aldaw, adda iti panagtitiponyo a maipaay kenni Yahweh, masapul a saanyo nga aramiden ti kadawyan a trabahoyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Masapul nga agidatonkayo kenni Yahweh iti daton a maipuor iti las-ud iti pito nga aldaw. Ti maikapito nga aldaw ket maysa a panagtitipon a maipaay kenni Yahweh a masapul a saankayo nga agaramid iti kadawyan a trabahoyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Nagsao ni Yahweh kenni Moises, kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Agsaoka kadagiti Israelita ket ibagam kadakuada, 'Inton mapankayo iti daga nga itedkonto kadakayo, ken inton agapitkayo, ket nga ipanyo iti padi ti sangkareppet kadagiti umuna a bunga. ");
INSERT INTO iloulb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Itag-aynanto ti sangkareppet iti sangoanan ni Yahweh ket idatagnanto daytoy kenkuana, tapno maawat daytoy iti biangyo. Itag-ay ken idatagto ti padi daytoy kaniak iti aldaw a kalpasan ti Aldaw a Panaginana. ");
INSERT INTO iloulb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Iti aldaw nga itag-ayyo ti sangkareppet ken idatagyo daytoy kaniak, masapul nga agidatonkayo iti kalakian nga urbon a karnero nga agtawen iti maysa ken awan iti mulitna a kas daton a maipuor amin kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Masapul a dua nga apagkapullo iti efa iti napino nga arina ti daton a bukbukel a nalaokan iti lana, maysa a daton a mapuoran para kenni Yahweh a mangparnuay iti nabanglo nga ayamuom, ket kakuyog daytoy ti daton a mainum nga arak, a kakapat iti hin (3. 70 a litro). ");
INSERT INTO iloulb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Masapul a saankayo a mangan iti tinapay, inuruban man wenno kaan-ani a bukel, agingga iti isu met laeng nga aldaw nga impanyo daytoy a daton iti Diosyo. Agnanayonto daytoy a bilin kadagiti henerasion dagiti tattaoyo, iti tunggal lugar a pagnaedanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Masapul a bilangenyo manipud iti aldaw kalpasan dayta nga Aldaw a Panaginana, manipud iti aldaw nga inyegyo ti sangkareppet iti daton tapno maitag-ay ken maidatag, pito a lawas, pito nga Aldaw a Panaginana, ");
INSERT INTO iloulb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","agingga iti aldaw kalpasan iti maikapito nga Aldaw a Panaginana. Dayta ket, masapul nga agbilangkayo iti limapulo nga aldaw. Ket masapul nga agidatonkayo kenni Yahweh iti daton a baro a bukel. ");
INSERT INTO iloulb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Masapul nga irruaryo manipud iti babbalayyo ti dua a tinapay a naaramid iti dua nga apagkapullo iti efa. Masapul a naaramid dagitoy manipud iti napino nga arina ken naluto nga addaan iti lebadura; agbalindanto a daton manipud kadagiti umuna a bunga a maitag-ay ken maidatag kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Masapul nga idatagyo ti tinapay a kakuyog dagiti pito nga urbon a karnero nga agtawen iti maysa ken awan mulitda, maysa a bumaro a baka, ken dua a kalakian a karnero. Masapul a daton a maipuor dagitoy para kenni Yahweh, a kakuyog dagiti datonda a bukbukel ken dagiti datonda a mainum, maysa a daton a maipuor ken mangparnuay iti nabanglo nga ayamuom para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Masapul nga agidatonkayo iti maysa a kalakian a kalding para iti daton gapu iti basol, ken dua a kalakian nga urbon a karnero nga agtawen iti maysa a kas daton para iti panagkakadua. ");
INSERT INTO iloulb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Masapul nga itag-ay ti padi dagitoy iti sangoanan ni Yahweh, a kakuyog ti tinapay manipud kadagiti umuna a bunga, ken idatagna dagitoy kenkuana a kas daton a kakuyog dagiti dua nga urbon a karnero. Agbalinto dagitoy a nasantoan a daton kenni Yahweh para iti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Masapul nga agiwaragawagkayo iti dayta met laeng nga aldaw. Addanto iti nasantoan a panagtitipon, ket masapul a saanyo nga aramiden ti gagangay a trabahoyo. Agnanayonto daytoy a bilin kadagiti henerasion dagiti tattaoyo, iti tunggal lugar a pagnaedanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Inton apitenyo dagiti maapit iti dagayo, masapul a saanyo nga apiten a naan-anay dagiti adda iti suli dagiti taltalonyo, ket masapul a saanyo nga urnongen dagiti nabati iti apityo. Masapul nga ibatiyo dagitoy para kadagiti marigrigat ken para kadagiti ganggannaet. Siak ni Yahweh a Diosyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Nagsao ni Yahweh kenni Moises, imbagana, ");
INSERT INTO iloulb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Agsaoka kadagiti Israelita ken ibagam, 'Iti maikapito a bulan, ti umuna nga aldaw iti dayta a bulan ket napasnek a panaginana para kadakayo, maysa a pananglaglagip a mabuyogan iti panagpuyot kadagiti trumpeta, ken maysa a nasantoan a panagtitipon. ");
INSERT INTO iloulb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Masapul a saanyo nga aramiden ti gagangay a trabahoyo, ken masapul nga agidatonkayo iti daton a maipuor para kenni Yahweh.'” ");
INSERT INTO iloulb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Kalpasanna, nagsao ni Yahweh kenni Moises, imbagana, ");
INSERT INTO iloulb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ita, ti maikasangapulo nga aldaw iti maikapito a bulan ket agbalinto nga Aldaw ti Pannakapakawan ti basol. Masapul a panagtitipon daytoy a maipaay kenni Yahweh, masapul nga ipakumbabayo dagiti bagbagiyo ken mangidatonkayo iti daton mapuoran para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Masapul a saankayo nga agtrabaho iti dayta nga aldaw gapu ta dayta ti Aldaw ti Pannakapakawan ti basol, tapno mangaramidkayo iti seremonia ti pannakpakawan para iti bagbagiyo iti sangoanan ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Masapul a mailaksid manipud kadagiti tattaona ti siasinoman a saan a mangipakumbaba iti bagina iti dayta nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Siasinoman nga agtrabaho iti dayta nga aldaw, Siak ni Yahweh, dadaelekto isuna manipud kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Masapul a saankayo nga agaramid iti aniaman a kita ti trabaho iti dayta nga aldaw. Agnanayonto daytoy a bilin kadagiti henerasion dagiti tattaoyo kadagiti amin a lugar a pagnaedanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Masapul a natalna nga Aldaw a Panaginana para kadakayo daytoy nga aldaw, ken ipakumbabayo dagiti bagbagiyo iti maikasiam nga aldaw ti bulan. Masapul a ngilinenyo ti Aldaw a Panaginana manipud iti rabii agingga iti rabii.” ");
INSERT INTO iloulb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Nagsao ni Yahweh kenni Moises, imbagana ");
INSERT INTO iloulb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Agsaoka kadagiti Israelita, ibagam, 'Fiesta dagiti Abong-abong para kenni Yahweh ti maika-15 nga aldaw iti maikapito a bulan. Agpaut daytoy iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Iti umuna nga aldaw, masapul nga adda iti nasantoan a panagtitipon. Masapul a saanyo nga aramiden dagiti gagangay a trabahoyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Iti las-ud iti pito nga aldaw ket agidatonkayo kenni Yahweh iti daton a mapuoran. Iti maikawalo nga aldaw, masapul nga adda iti nasantoan a panagtitipon, ket masapul nga agidatonkayo kenni Yahweh iti daton a maipuor. Napasnek daytoy a panagtitipon, ken masapul a saanyo nga aramiden dagiti gagangay a trabahoyo. ");
INSERT INTO iloulb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Dagitoy dagiti naituding a fiesta para kenni Yahweh, a masapul nga iwaragawagyo a kas nasantoan a panagtitipon tapno agidaton kenni Yahweh iti daton mapuoran, daton a maipuor amin ken daton a bukbukel, dagiti sakripisio ken dagiti daton a mainum, iti tunggal bukod dagitoy nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mainayonto dagitoy a fiesta iti Aldaw a Panaginana ni Yahweh ken dagiti sagutyo, dagiti amin a kariyo, ken amin dagiti daton a situtulokyo nga ited kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Maipapan iti Fiesta dagiti Abong-abong, iti maika-15 nga aldaw iti maikapito a bulan, inton naurnongyon dagiti umuna a bunga ti daga, masapul a ngilinenyo daytoy a Fiesta ni Yahweh iti las-ud iti pito nga aldaw. Agbalinto a napasnek a panaginana ti umuna nga aldaw, ken agbalinto met a napasnek a panaginana ti maikawalo nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Iti umuna nga aldaw, masapul nga alaenyo ti kasasayaatan a bunga manipud kadagiti kaykayo, dagiti palatang dagiti palma a kaykayo, ken dagiti nabulong a sanga dagiti narukbos a kaykayo, ken wilow kadagiti waig, ket agrag-okayo iti sangoanan ni Yahweh a Diosyo iti las-ud iti pito nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Iti pito nga aldaw iti tunggal tawen, masapul a rambakanyo daytoy a fiesta ni Yahweh. Agnanayonto daytoy a bilin kadagiti henerasion dagiti tattaoyo kadagiti amin a lugar a pagnaedanyo. Masapul a rambakanyo daytoy a fiesta iti maikapito a bulan. ");
INSERT INTO iloulb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Masapul nga agnaedkayo kadagiti babassit nga abong-abong iti las-ud iti pito nga aldaw. Masapul nga agnaed dagiti amin a naiyanak nga umili nga Israelita kadagiti babassit nga abong-abong iti las-ud iti pito nga aldaw, ");
INSERT INTO iloulb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","tapno dagiti kaputotanyo, dagiti henerasyon, ket maammoanda no kasanok a pinagnaed dagiti Israelita kadagiti kasta nga abong-abong idi inruarko ida manipud iti daga ti Egipto. Siak ni Yahweh a Diosyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Iti kastoy a wagas, impablaak ni Moises kadagiti Israelita dagiti naituding a fiesta para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Nagsao ni Yahweh kenni Moises, imbagana, ");
INSERT INTO iloulb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Bilinem dagiti Israelita a mangiyegda kenka iti puro a lana manipud iti olibo para kadagiti pagsilawanyo, tapno kanayon dagitoy a sigagangat ken mangted iti silaw. ");
INSERT INTO iloulb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Iti ruar ti kurtina iti sangoanan ti pammaneknek iti tulagmo iti uneg ti tabernakulo, masapul nga agtultuloy ni Aaron, iti agpatpatnag, a pagtalinaedenna a sigagangat ti pagsilawan iti sangoanan ni Yahweh. Agnanayonto daytoy a bilin kadagiti henerasion dagiti tattaoyo. ");
INSERT INTO iloulb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Masapul a pagtalinaeden a kanayon ti kangatoan a padi a sigagangat dagiti pagsilawan iti sangoanan ni Yahweh, ti pagsilawan iti rabaw ti kandelero a puro a balitok. ");
INSERT INTO iloulb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Masapul a mangalakayo iti napino nga arina ken aglutokayo iti 12 a tinapay manipud iti daytoy. Masapul nga adda iti dua nga apagkapullo iti maysa nga efa iti tunggal tinapay. ");
INSERT INTO iloulb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ket masapul nga idasaryo dagitoy iti dua nga intar, innem iti maysa nga intar, iti rabaw ti lamisaan a puro a balitok iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Masapul a mangikabilkayo iti puro nga insenso iti tunggal intar dagiti tinapay a kas simbolo dagiti tinapay. Maipuorto daytoy nga insenso para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Tunggal Aldaw a Panaginana, masapul a kanayon a mangidasar nangato a padi iti tinapay iti sangoanan ni Yahweh iti biang dagiti Israelita, a kas pagilasinan iti agnanayon a katulagan. ");
INSERT INTO iloulb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Daytoy a daton ket para kenni Aaron ken kadagiti annakna a lallaki. Masapul a kanenda daytoy iti lugar a nasantoan, ta naan-anay a naidaton daytoy kenkuana, agsipud ta naala daytoy manipud kadagiti daton a mapuoran para kenni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ita, napasamak a ti anak a lalaki ti maysa nga Israelita a babai, a ti amana ket maysa nga Egipcio, ket napan kadagiti Israelita. Daytoy nga anak a lalaki ti maysa Israelita a babai ket nakiapa iti maysa nga Israelita a lalaki idiay kampo. ");
INSERT INTO iloulb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ti anak a lalaki ti Israelita a babai ket tinabbaawanna ti nagan ni Yahweh ken inlunodna ti Dios, isu nga impan isuna dagiti tattao kenni Moises. Selomit ti nagan ti inana, ti anak a babai ni Dibri, manipud iti tribu ti Dan. ");
INSERT INTO iloulb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Impupokda isuna agingga nga ipakaammo ni Yahweh ti pagayatanna kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ket nagsao ni Yahweh kenni Moises, imbagana, ");
INSERT INTO iloulb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Irruaryo iti kampo ti lalaki a nangilunod iti Dios. Amin a nakangngeg kenkuana ket masapul nga ipatayda dagiti imada iti ulona, ket kalpasanna, masapul a batoen isuna iti sangkagimongan. ");
INSERT INTO iloulb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Masapul nga ilawlawagmo kadagiti Israelita ket ibagam, “Siasinoman a mangilunod iti Diosna ket masapul a sagabaenna ti bukodna a biddut. ");
INSERT INTO iloulb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Siasinoman a mangtabbaaw iti nagan ni Yahweh ket awan duadua a mapapatay. Masapul a batoen isuna iti sangkagimongan, ganggannaet man isuna wenno naiyanak nga umili nga Israelita. No tabbaawan ti siasinoman ti nagan ni Yahweh, masapul a mapapatay isuna. ");
INSERT INTO iloulb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ket ti siasinoman a pumatay iti sabali a tao ket pudno a masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Siasinoman a mangpatay iti ayup iti sabali a tao ket masapul a bayadanna daytoy, biag para iti biag. ");
INSERT INTO iloulb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","No madangran ti maysa a tao ti kaarrubana, masapul a maaramid met kenkuana a kas iti inaramidna iti kaarrubana: ");
INSERT INTO iloulb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","tukkol para iti tukkol, mata para iti mata, ken ngipen para iti ngipen. Kas nangdangran isuna iti maysa a tao, masapul a kasta met ti maaramid kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Siasinoman a mangpatay iti ayup ket masapul a bayadanna daytoy, ken siasinoman a pumatay iti maysa a tao ket masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Masapul nga agpada a lintegyo para kadagiti ganggannaet ken kadagiti naiyanak nga umili nga Israelita, ta Siak ni Yahweh a Diosyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Isu a nakisarita ni Moises kadagiti Israelita, ket inruar dagiti tattao ti lalaki iti kampo, ti nangilunod kenni Yahweh. Binato dagiti tattao isuna. Tinungpal dagiti Israelita ti imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Nagsao ni Yahweh kenni Moises idiay Bantay Sinai, imbagana, ");
INSERT INTO iloulb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Agsaoka kadagiti Israelita ket ibagam kadakuada, 'Inton mapankayo iti daga nga itedko kadakayo, ket masapul nga paginanaen ti daga tapno ngilinen ti Aldaw a Panaginana para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Masapul a mulaanyo ti taltalonyo iti las-ud iti innem a tawen, ken iti las-ud iti innem a tawen ket masapul nga arbasanyo ti kaubasanyo ken apitenyo ti bungada. ");
INSERT INTO iloulb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ngem iti maikapito a tawen, masapul a mangilin ti natalna a Panaginana ti daga, maysa a Panaginana para kenni Yahweh. Masapul a saanyo a mulaan dagiti taltalonyo wenno arbasan ti kaubasanyo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Masapul a saanyo nga ipaapit dagiti aniaman a nagtubo lattan, ket masapul a saanyo nga ipaapit dagiti aniaman nga ubas a nagtubo kadagiti saanyo a naarbasan a lanut. Tawen daytoy iti natalna a panaginana para iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Aniaman nga agtubo iti saan a nataripato a daga kabayatan ti Tawen a Panaginana ket taraon para kadakayo. Dakayo, dagiti lallaki ken babbai nga adipenyo, dagiti matangtangdanan nga adipenyo ken dagiti ganggannaet a makipagnanaed kadakayo ket mabalin nga agapit iti taraon. ");
INSERT INTO iloulb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ken dagiti dingwenyo ken dagiti atap nga ayup ket mabalin a mangan iti aniaman kadagiti ibunga iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Masapul a mangbilangkayo iti pito a Tawen a Panaginana, dayta ket, mamimpito a sagpipito a tawen, tapno addanto iti pito a tawen a Panaginana, nga agdagup iti 49 a tawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kalpasanna, masapul a puyotanyo iti napigsa ti trumpeta iti sadinoman iti maikasangapulo nga aldaw iti maikapito a bulan. Iti Aldaw ti Pannakapakawan ti basol ket masapul a puyotanyo ti trumpeta iti entero a dagayo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Masapul nga idatonyo ti maikalimapulo a tawen kenni Yahweh ken iwaragawagyo ti pannakawayawaya iti entero a daga kadagiti amin nga agnanaed iti daytoy. Daytoy ket Tawen ti Panagisubli para kadakayo, a dagiti sanikua ken dagiti tagabu ket masapul a maisubli kadagiti pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ti maikalimapulo a tawen ket Tawen ti Panagisubli para kadakayo. Masapul a saankayo nga agmula wenno agapit. Kanenyo ti aniaman a nagtubo lattan, ken apitenyo dagiti ubas a nagtubo kadagiti saan a naarbasan a lanut. ");
INSERT INTO iloulb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ta Tawen ti Panagisubli daytoy, nga agbalinto a nasantoan para kadakayo. Masapul a kanenyo dagiti bunga dagiti nagtubo lattan kadagiti taltalonyo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Masapul nga isubliyo iti tunggal maysa ti bukodna a sanikua iti daytoy a Tawen ti Panagisubli. ");
INSERT INTO iloulb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","No aglakokayo iti aniaman a daga iti kaarrubayo wenno gumatangkayo iti daga iti kaarrubayo, saanyo a sauren wenno pagaramidan iti dakes ti tunggal maysa. ");
INSERT INTO iloulb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","No gumatangkayo iti daga iti kaarrubayo, bilangenyo dagiti tawen ken dagiti mula a mabalin a maapit agingga iti sumaruno a Tawen ti Panagisubli. Masapul a panunoten met dayta ti kaarrubayo nga agilaklako iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ti ad-adu a bilang iti tawen agingga iti sumaruno a Tawen ti Panagisubli ket panginaenna ti gatad ti daga, ken ti basbassit a bilang dagiti tawen agingga iti sumaruno a Tawen ti Panagisubli ket palakaenna ti gatad daytoy, gapu ta ti bilang dagiti maapit manipud iti daga para iti baro nga akinkukua ket mainaig iti bilang dagiti tawen sakbay iti sumaruno a Tawen ti Panagisubli. ");
INSERT INTO iloulb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Masapul a saanyo a sauren wenno pagaramidan iti dakes ti tunggal maysa; ngem ketdi, masapul a raemenyo ti Diosyo, ta Siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ngarud, masapul nga agtulnogkayo kadagiti bilbilinko, salimetmetanyo dagiti lintegko, ken tungpalenyo dagitoy. Ket agbiagkayonto a sitatalged iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Pataudento ti daga dagiti bungana, ken mapnekayonto a mangen ket agbiagkayo sadiay a sitatalged. ");
INSERT INTO iloulb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nalabit nga ibagayo, “Anianto ti kanenmi iti maikapito a tawen? Kitaem, saankami a makamula wenno makaapit.” ");
INSERT INTO iloulb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ibaonkonto ti bendissionko kadakayo iti maikanem a tawen, ket mangipaayto daytoy iti umdas nga apit para iti tallo a tawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Agmulakayonto iti maikawalo a tawen ket agtultuloykayonto a mangan manipud kadagiti bunga iti napalabas a tawen ken ti naipenpen a taraon. Agingga a dumteng ti panagaapit iti maikasiam a tawen, mabalinkayonto a mangan manipud kadagiti taraon a naipenpen kadagiti napalabas a tawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Masapul a saan a mailako ti daga iti baro a mangtagikua iti daytoy nga agnanayon, gapu ta kukuak ti daga. Ganggannaetkayo amin ken saankayo nga agnanayon nga agnaed iti dagak. ");
INSERT INTO iloulb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Masapul a bigbigenyo ti kalintegan ti panangsubbot iti amin a daga a magun-odyo; masapul nga palubosanyo ti daga a gatangen met laeng ti pamilia a nanggatanganyo iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","No pimmanglaw ti padayo nga Israelita, ket gapu iti dayta, inlakona ti sumagmamano a sanikuana, ket mabalin nga umay ti kaasetgan a kabagianna ket gatangenna met laeng ti sanikua nga inlakona kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","No awan ti kabagian ti maysa a tao a mangsubbot iti sanikuana, ngem no rimmang-ay isuna ket kabaelannan a subboten daytoy, ");
INSERT INTO iloulb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","mabalinna ngarud a bilangen dagiti tawen manipud idi nailako ti daga ket bayadanna ti udina iti tao a nangilakoanna iti daytoy. Ket mabalinnan ti agsubli iti bukodna a sanikua. ");
INSERT INTO iloulb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ngem no saanna a kabaelan a sublien ti dagana, ket agtalinaed ti daga nga inlakona a kukua ti gimmatang agingga iti Tawen ti Panagisubli. Iti Tawen ti Panagisubli, maisublinto ti daga iti tao a nangilako iti daytoy, ket agsublinto ti sigud nga akinkukua iti sanikuana. ");
INSERT INTO iloulb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","No ilako ti maysa a tao ti balay nga adda iti napaderan a siudad, ket mabalinna met laeng a gatangen daytoy iti las-ud iti maysa a tawen kalpasan a nailako daytoy. Adda karbenganna a mangsubbot iti daytoy iti las-ud iti makatawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","No saan a masubbot ti balay iti las-ud iti makatawen, ti balay nga adda iti napaderan a siudad ket agbalinto nga agnanayon a sanikua ti tao a gimmatang iti daytoy, agingga iti henerasion dagiti kaputotanna. Saanto a maisubli dayta a balay iti Tawen ti Panagisubli. ");
INSERT INTO iloulb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ngem dagiti babbalay kadagiti barbarrio nga awan iti pader iti aglawlawda ket maibilang a sanikua a kasla kadagiti taltalon iti pagilian. Mabalin met laeng a gatangen dagitoy, ken masapul a maisubli dagitoy iti tawen ti panagisubli. ");
INSERT INTO iloulb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Nupay kasta, dagiti babbalay a kukua dagiti Levita kadagiti siudadda ket mabalin a subboten iti aniaman a tiempo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","No saan a subboten ti maysa a Levita ti balay nga inlakona, ket masapul a maisubli ti balay a nailako a masarakan iti siudad iti Tawen ti Panagisubli, ta dagiti babbalay kadagiti siudad dagiti Levita ket sanikuada manipud kadagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ngem dagiti taltalon iti aglawlaw dagiti siudadda ket saan a mabalin a mailako gapu ta agnanayon a sanikua dagiti Levita dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","No pumanglaw ti padayo nga umili, ket saannan a kabaelan a biagen ti bagina, ket masapul a tulonganyo isuna a kas iti panangtulongyo iti maysa a ganggannaet wenno siasinoman a makipagnanaed kadakayo a kas ganggannaet. ");
INSERT INTO iloulb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Saanyo a paanakan ti impabulodyo kenkuana wenno padasen a pagganansiaan isuna iti aniaman a wagas, ngem raemenyo ti Diosyo tapno makapagtultuloy a makipagnaed ti kabsatyo kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Saanyo isuna a pautangan iti kuarta ken paanakanyo daytoy, wenno lakoan isuna iti taraonyo tapno agganansiakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Siak ni Yahweh a Diosyo, a nangiruar kadakayo iti daga ti Egipto, tapno maitedko kadakayo ti daga ti Canaan, ken tapno agbalinak a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","No pumanglaw ti padayo nga umili ket ilakona ti bagina kadakayo, masapul a saanyo isuna a pagtrabahoen a kasla maysa a tagabu. ");
INSERT INTO iloulb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Tratoenyo isuna a kas maysa a matangtangdanan nga adipen. Masapul a kasla maysa isuna a tao a saan nga agnanayon a makipagnanaed kadakayo. Agserbinto isuna kadakayo agingga iti Tawen ti Panagisubli. ");
INSERT INTO iloulb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ket panawannakayonto, a kaduana dagiti annakna, ket agsublinto isuna iti bukodna a pamilia ken iti sanikua dagiti ammana. ");
INSERT INTO iloulb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ta isuda dagiti adipenko nga inruarko iti daga ti Egipto. Saanda a mailako a kas kadagiti tagabu. ");
INSERT INTO iloulb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Masapul a saankayo nga agturay kadakuada a siraranggas, ngem masapul a raemenyo ti Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Para kadagiti tagabuyo a lallaki ken babbai, a mabalinyo nga alaen manipud kadagiti nasion nga agnanaed iti aglawlawyo, mabalinyo ti gumatang kadagiti tagabu manipud kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mabalinyo met ti gumatang kadagiti tagabu manipud kadagiti ganggannaet a makipagnanaed kadakayo, dayta ket manipud kadagiti pamiliada nga adda kadakayo, dagiti ubbing a naiyanak iti dagayo. Mabalinyo ida a tagikuaen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mabalinyo iti mangipaay kadagiti kasta a tagabu a kas tawid para kadagiti annakyo a tagikuaenda inton mataykayo. Mabalinyo ti gumatang a kanayon manipud kadakuada kadagiti tagabuyo, ngem masapul a saankayo nga agturay a siraranggas kadagiti kakabsatyo nga Israelita. ");
INSERT INTO iloulb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","No bumaknang ti ganggannaet wenno ti maysa a tao a saan nga agnanayon a makipagnanaed kadakayo, ken no pumanglaw ti maysa kadagiti padayo nga Israelita ket ilakona ti bagina iti dayta a ganggannaet, wenno iti maysa iti kameng ti pamilia ti ganggannaet, ");
INSERT INTO iloulb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","kalpasan a nagatang ti padayo nga Israelita, mabalin met laeng isuna a gatangen. Mabalin isuna a subboten ti maysa kadagiti kameng iti pamiliana. ");
INSERT INTO iloulb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Mabalin a ti ulitegna, wenno ti anak a lalaki ti ulitegna, ti mangsubbot kenkuana, wenno siasinoman nga asideg a kabagianna manipud iti pamiliana. Wenno, no rimmamng-ay isuna, mabalinna a subboten ti bagina. ");
INSERT INTO iloulb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Masapul a makiuman isuna iti tao a gimmatang kenkuana; masapul a bilangenda dagiti tawen manipud iti tawen nga inlakona ti bagina iti gimmatang kenkuana agingga iti Tawen ti Panagisubli. Ti gatad iti pannakasubbotna ket masapul a mabilang segun iti tangdan ti matangtangdanan nga adipen, para iti bilang dagiti tawen a mabalin nga ituloyna ti panagtrabahona iti gimmatang kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","No adu pay ti tawen agingga iti Tawen ti Panagisubli, masapul nga agbayad isuna para iti pannakasubbotna iti gatad iti kuarta a kaibatugan iti bilang dagidiay a tawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","No adda laeng iti bassit a tawtawen agingga iti Tawen ti Panagisubli, masapul ngarud a makiuman isuna iti gimmatang kenkuana tapno bilangenda dagiti nabati a tawtawen sakbay iti Tawen ti Panagisubli, ket masapul a bayadanna ti pannakasubbotna segun iti bilang dagiti tawen. ");
INSERT INTO iloulb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Masapul a matrato isuna a kasla maysa a matangtangdanan a tao iti tunggal tawen. Masapul a siguraduenyo a saan a naranggas ti pannakatratona. ");
INSERT INTO iloulb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","No saan a masubbot isuna babaen kadagitoy a wagas, ket masapul ngarud nga agserbi isuna agingga iti Tawen ti Panagisubli, isuna ken dagiti annakna a kaduana. ");
INSERT INTO iloulb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Para kaniak, dagiti Israelita ket adipen. Isuda dagiti adipenko nga inruarko manipud iti daga ti Egipto. Siak ni Yahweh a Diosyo.'” ");
INSERT INTO iloulb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Masapul a saankayo nga agaramid kadagiti didiosen, wenno mangipatakder iti nakitikitan a ladawan wenno maysa a nasagradoan nga adigi a bato, ken masapul a saankayo a mangikabil iti aniaman a nakitikitan a ladawan a bato iti dagayo a pagrukbabanyo, ta siak ni Yahweh a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Masapul a salimetmetanyo dagiti Aldaw a Panaginanak ken raemenyo ti santuariok. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","No agbiagkayo kadagiti lintegko ken salimetmetanyo dagiti bilbilinko ken tungpalenyo dagitoy, ");
INSERT INTO iloulb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ket pagtudoekto iti naitutop a tiempona; pataudento ti daga ti bungana, ken agbunganto dagiti kaykayo kadagiti taltalon. ");
INSERT INTO iloulb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Agtultuloyto ti panagirikyo inggana iti tiempo ti panagaapit iti ubas, ken dumanonto ti panagapityo iti ubas inggana iti tiempo iti panagmumula. Kanenyonto ti tinapayyo inggana a mapnekkayo ket agbiagkayo a sitatalged iti sadinoman a pagtaenganyo iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Itedkonto ti kapia iti daga; agiddakayonto nga awan iti aniaman a pagbutnganyo. Iyadayokto dagiti narungsot nga ayup manipud iti daga, ket saanto a lumabas ti kampilan iti dagayo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kamatenyonto dagiti kabusoryo, ket mapasagdanto iti sangoananyo babaen iti kampilan. ");
INSERT INTO iloulb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Kamatento ti lima kadakayo ti sangagasut, ket kamatento ti sangagasut kadakayo ti sangapulo a ribu; mapasagto dagiti kabusoryo iti sangoananyo babaen iti kampilan. ");
INSERT INTO iloulb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Paraburankayonto ket pagbalinenkayo a nabunga ken paaduenkayonto; patalgedakto ti katulagak kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mangankayonto iti taraon a naipenpen iti nabayagen a tiempo. Masapul nga irruaryonto dagiti taraon a naipenpen iti nabayag gapu ta masapulyo ti siled para kadagiti baro nga apit. ");
INSERT INTO iloulb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ikabilkonto ti tabernakulok kadakayo, ket saankayonto a guraen. ");
INSERT INTO iloulb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Makipagnaakto kadakayo ket siakto ti Diosyo, ket dakayonto dagiti tattaok. ");
INSERT INTO iloulb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Siak ni Yahweh a Diosyo, a nangiruar kadakayo manipud iti daga ti Egipto, tapno saankayo nga agbalin a tagabuda. Dinadaelkon dagiti sangolyo ket pinapagnakayo a nakatakder iti nalinteg. ");
INSERT INTO iloulb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ngem no saankayo a dumngeg kaniak, ken saanyo a tungpalen amin dagitoy a bilbilin, ");
INSERT INTO iloulb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ken no laksidenyo dagiti pagalagadak ken guraenyo dagiti lintegko, tapno saanyo a tungpalen dagiti amin a bilbilinko, ngem dadaelenyo ti katulagak - ");
INSERT INTO iloulb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","- no aramidenyo dagitoy a banbanag, ket aramidekto daytoy kadakayo: dusaenkayto iti nakabutbuteng, saksakit ken gurigor a mangdadael kadagiti mata a mangpukaw ti biagyo. Imulayonto dagiti bukbukelyo iti awan kaes-eskanna, gapu ta kanento dagiti kabusoryo dagiti bungada. ");
INSERT INTO iloulb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Itallikudkonto ti rupak kadakayo ket parmekendakayonto dagiti kabusoryo. Iturayandakayonto dagiti tattao a gumurgura kadakayo, ket agtaraykayonto nga umadayo, uray no awan iti mangkamkamat kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","No saankayo a dumngeg kadagiti bilbilinko, ket dusaenkayonto iti mamin-pito daras iti kinakarona para kadagiti basolyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Dadaelekto ti kinatangsityo iti bilegyo. Aramidekto a kasla landok ti tangatang iti ngatoenyo ken dagiti dagayo a kasla tanso. ");
INSERT INTO iloulb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Maibusto dagiti pigsayo iti awan kaes-eskanna, gapu ta saanto nga agpataud ti dagayo iti apitna, ken dagiti kaykayoyo iti daga ket saanto nga agbunga. ");
INSERT INTO iloulb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","No magnakayo a maibusor kaniak ken saankayo a dumngeg kaniak, dusaenkayto iti mamin-pito iti kadagsenna a maiyannatop kadagiti basbasolyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Mangipatulodakto kadagiti narungsot nga ay-ayup a maibusor kadakayo, a mangtakaw kadagiti annakyo, mangdadael kadagiti bakayo, ken mangpabassit iti bilangyo. Isu nga agbalinto dagiti kalsadayo nga awan ti matataona. ");
INSERT INTO iloulb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","No iti laksid amin dagitoy ket saanyo latta nga awaten dagiti panursurok ngem itultuloyyo iti magna a maibusor kaniak, ");
INSERT INTO iloulb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ket magnaakto met a maibusor kadakayo. Saplitankayonto pay iti maminpito a daras para kadagiti basbasolyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mangyegakto iti kampilan kadakayo a mangipatungpal iti panagibales para iti panangdadaelyo iti katulagan. Maurnongkayonto iti uneg iti siudadyo, ket mangyegakto iti sakit kadakayo sadiay, ket kalpasanna, maparmekkayonto babaen iti bileg dagiti kabusoryo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Inton saankayon nga ikkan iti kanenyo, sangapulo a babbai iti manglutonto iti kanenyo iti maymaysa a pugon, ket iwarasdanto ti tinapayyo segun iti kadagsen. Mangankayonto ngem saankayo a mapnek. ");
INSERT INTO iloulb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","No saankayo a dumngeg kaniak iti laksid dagitoy a banbanag, ngem itultuloyyo ti magna a maibisor kaniak, ");
INSERT INTO iloulb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ket magnaakto a maibusor kadakayo nga addaan iti pungtot, ket dusaenkayto iti maminpito pay a kas kadagsen dagiti basbasolyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Kanenyonto dagiti lasag dagiti annakyo a lallaki; kanenyonto dagiti lasag dagiti annakyo a babbai. ");
INSERT INTO iloulb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Dadaelekto dagiti altaryo, rebbaekto dagiti altaryo a pangpupuoranyo iti insenso, ken ipurwakkonto dagiti bangkayyo kadagiti bangkay dagiti didiosenyo, ket guraenkayonto. ");
INSERT INTO iloulb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Pagbalinekto a dadael dagiti siudadyo ken dadaelekto dagiti santuarioyo. Saanakto a maay-ayo iti ayamuom dagiti datonyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Dadaelekto ti daga. Makigtutto dagiti kabusoryo nga agnaed sadiay iti pannakadadaelna. ");
INSERT INTO iloulb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Iwarawarakayonto kadagiti pagilian, ket asutekto ti kampilanko ket surutenkayo. Mapanawanto ti dagayo, ket madadaelto dagiti siudadyo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ket ragragsakento ti daga dagiti Aldaw ti Panaginanana, inggana a napanawan daytoy ken addakayo kadagiti daga dagiti kabusoryo. Kabayatan dayta a tiempo, aginana ti daga ket ragragsakenna dagiti Aldaw ti Panaginana. ");
INSERT INTO iloulb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Inggana a napanawan daytoy, aginana daytoy iti inana a saanna a napadasan kadagiti Aldaw a Panaginanayo, idi nagnaedkayo iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Para kadakayo a nabati kadagiti daga dagiti kabusoryo, mangyegakto iti buteng kadagiti puspusoyo tapno uray ti karasakas ti maiyang-angin a bulong ket mabutbutengkayto, ket tumaraykayonto a kasla itartarayanyo ti kampilan. Maitublakkayonto, uray awan iti mangkamkamat kadakayo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Agdidinnungparkayonto a kasla itartarayanyo ti kampilan, uray no awan met ti mangkamkamat kadakayo. Awanto ti bilegyo a tumakder iti sangoanan dagiti kabusoryo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mapukawkayonto kadagiti pagilian, ket alun-unennakayonto ti daga dagiti kabusoryo. ");
INSERT INTO iloulb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Madadaelto dagiti mabatikadakayo kadagiti basbasolda idiay daga dagiti kabusoryo, ken gapu kadagiti basbasol dagiti ammada, madadaeldanto met. ");
INSERT INTO iloulb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ngem no ipudnoda dagiti basolda ken dagiti basol dagiti ammada, ken ti panagsalungasingda a namagbalin kadakuada a saan a napudno kaniak, ken kasta met iti pannagnada a maibusor kaniak - ");
INSERT INTO iloulb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","a nangtallikudak kadakuada ken panangtedko kadakuada iti daga dagiti kabusorda - no dagiti natangken a puspusoda ket agbalin a napakumbaba, ken no awatenda ti pannusa para kadagiti basbasolda, ");
INSERT INTO iloulb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ket lagipekto ti katulagak kenni Jacob, ti katulagak kenni Isaac, ken ti katulagak kenni Abraham; kasta met a, lagipekto ti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Panawandanto ti daga, ket maragsakanto daytoy kadagiti Aldaw a Panaginanana kabayatan a napanawan iti kaawanda. Masapul a bayadanda ti pannusa para kadagiti basbasolda gapu ta linaksidda dagiti pagalagadak ken ginurada dagiti lintegko. ");
INSERT INTO iloulb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ngem iti laksid amin dagitoy, no addada iti daga dagiti kabusorda, saanko nga ilaksid ida, wenno guraen ida tapno dadaelen ida a naan-anay ken saanko nga dadaelen ti katulagak kadakuada, ta siak ni Yahweh a Diosda. ");
INSERT INTO iloulb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ngem para iti pagsayaatanda, lagipekto ti katulagan kadagiti kapuonanda, nga inruarko iti daga ti Egipto iti imatang dagiti pagilian, tapno siakto ti agbalin a Diosda. Siak ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Dagitoy dagiti bilbilin, pagalagadan, ken linlinteg nga inaramid ni Yahweh iti nagbaetanna ken dagiti tattao ti Israel idiay Bantay Sinai babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Nagsao ni Yahweh kenni Moises ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Makisaritaka kadagiti tattao ti Israel ket ibagam kadakuada, 'No ti maysa a tao ket agsapata iti naisangsangayan a kasapulan a bayadanna ti gatad iti tao nga idatonna kenni Yahweh, usarenyo dagiti sumaganad a gatad. ");
INSERT INTO iloulb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Ti ibayadyo a gatad para iti lalaki nga agtawen iti duapulo inggana ti innem a pulo ket limapulo a siklo ti pirak kas iti siklo ti santuario. ");
INSERT INTO iloulb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Para iti babai nga isu met laeng ti tawenna, ti ibayadyo a gatad ket masapul a tallopulo a siklo. ");
INSERT INTO iloulb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Dagiti agtawen ti lima inggana iti duapulo, ti ibayadyo a gatad para iti lalaki ket duapulo a siklo, ket sangapulo a siklo para iti babai. ");
INSERT INTO iloulb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ti maladaga a lalaki a nabulanan inggana kadagiti ubbing a lallaki nga agtawen iti lima, ti ibayadyo a gatad ket lima a siklo ti pirak, ken para iti babai ket tallo a siklo ti pirak. ");
INSERT INTO iloulb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kadagiti lallaki nga agtawen iti innem a pulo nga agpangato, ti ibayadyo a gatad ket sangapulo ket lima a siklo, ken para iti babai ket sangapulo a siklo. ");
INSERT INTO iloulb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ngem no ti tao a mangar-aramid ti sapata ket saanna a kabaelan a bayadan ti gatad, ngarud ti tao a mait-ited ket masapul a maiparang iti padi, ket gatadan ti padi dayta a tao segun iti gatad a kabaelan iti mangar-armid ti sapata. ");
INSERT INTO iloulb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","No kayat ti maysa a tao ti mangidaton ti ayup kenni Yahweh, ken no awaten ni Yahweh daytoy, ket maidaton ngarud dayta nga ayup kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Masapul a saan a baliwan wenno suktan ti tao daytoy nga ayup, ti napintas para iti naalas wenno ti naalas para iti napintas. No suktanna ti maysa nga ayup iti sabali, ket agpada nga agbalin a nasantoan ti ayup a nangsukat ken ti nasukatan. ");
INSERT INTO iloulb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nupay kasta, no ti insapata ti tao nga itedna kenni Yahweh ket narugit, ket saan nga awaten ni Yahweh daytoy, masapul nga iyeg ti tao ti ayup iti maysa a padi. ");
INSERT INTO iloulb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Gatadan daytoy ti padi, segun iti gatad ti ayup idiay pagtagilakoan. Aniaman ti igatad ti padi iti ayup, dayta ti agbalin a gatadna. ");
INSERT INTO iloulb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ket no tarigagayan ti akinkukua a subbuten daytoy, ket masapul a manayunan iti apagkalima iti sigud a gatadna iti pangsubbot a bayad. ");
INSERT INTO iloulb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","No tarigagayan ti maysa a tao nga idaton ti balayna tapno mailasin a para kenni Yahweh, ket patta-pattaen ti padi ti gatadna. Aniaman ti panggatad ti padi iti daytoy ket daytanto ti gatadna. ");
INSERT INTO iloulb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ngem no idaton ti akinkukua ti balayna ngem kalpasanna ket tarigagayanna a subboten daytoy, ket ti apagkalima ti sigud a gatadna ket mainayun iti pangsubbot a bayad, kalpasanna ket kukuana manen ti balay. ");
INSERT INTO iloulb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","No tarigagayan ti maysa a tao nga idaton ti sumagmamano kadagiti dagana kenni Yahweh, ngarud ti pannakapatta-patta ti gatad daytoy ket maibasar iti gatad ti bukel a masapul a maimula iti daytoy. Ti maysa nga omer ti sebada ket magatadan iti limapulo a siklo ti pirak. ");
INSERT INTO iloulb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","No idatonna ti talonna kabayatan iti Tawen ti Panagisubli, ti napatta-patta a gatadna ket agtalinaed. ");
INSERT INTO iloulb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ngem no idatonna ti talonna kalpasan ti Tawen ti Panagisubli, ket masapul a patta-pattaen ti padi ti gatad ti talon segun iti bilang dagiti nabati a tawen inggana ti sumaruno a Tawen ti Panagisubli, ket masapul a makissayan ti napatta-patta a gatadna. ");
INSERT INTO iloulb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","No tarigagayan ti tao a nangidaton ti talon a subboten daytoy, ket masapul a nayunanna ti apagkalima ti napatta-patta a gatad, ket agbalin manen a kukuana daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","No saanna a subboten ti talon, wenno no inlakona ti talon iti sabali a tao, saanen a mabalin a subboten pay daytoy. ");
INSERT INTO iloulb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ngem ketdi, no ti talon ket naisubli iti Tawen ti Panagisubli, ket agbalinto daytoy a nasantoan a sagut para kenni Yahweh, kas iti talon a naan-anay a naited kenni Yahweh. Kukuanto daytoy ti padi. ");
INSERT INTO iloulb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","No mangidaton ti maysa a tao kenni Yahweh iti talon a ginatangna, ngem dayta a talon ket saan a paset ti daga ti pamiliana, ");
INSERT INTO iloulb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ngarud, patta-pattaen ti padi ti gatadna inggana iti Tawen ti Panagisubli, ket masapul a bayadan ti tao ti gatadna iti dayta nga aldaw a kas nasantoan a sagut kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Iti Tawen ti Panagisubli, maisubli ti talon iti tao a nakagatangan daytoy, iti akinkukua iti daga. ");
INSERT INTO iloulb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Amin a napatta-patta a gatad ket masapul a maikeddeng segun iti kadagsen ti siklo ti santuario. Ti duapulo a “gerahs” ti masapul a kapada ti maysa a siklo. ");
INSERT INTO iloulb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Ngem ti inauna kadagiti ay-ayup ket siguden a kukua ni Yahweh ket awan ti siasinoman a mabalin a mangidaton iti daytoy - baka man wenno karnero- ta kukuan daytoy ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","No narugit daytoy nga ayup, ket mabalin a gatangen manen ti akinkukua daytoy iti napatta-patta a gatad, ken ti apagkalima ket masapul a mainayun iti dayta a gatad. No saan a nasubbot ti ayup, ket masapul a mailako daytoy iti naikeddeng a gatad. ");
INSERT INTO iloulb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nupay kasta, awan kadagiti idaton ti maysa a tao kenni Yahweh manipud iti aniaman nga adda kenkuana, tao man wenno ayup, wenno ti daga ti pamiliana, ti mabalin a mailako wenno masubbot. Tunggal banag a naidaton ket nasantoan kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Awan ti mabalin a pangsubbot a pangbayad para iti tao a mailasin a madadael. Dayta a tao ket masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Amin dagiti apagkapullo ti daga, dimmakkel man a bukel iti daga wenno bunga manipud kadagiti kaykayo, ket kukua ni Yahweh. Nasantoan daytoy kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","No subboten ti tao ti aniaman kadagiti apagkapullona, masapul a nayunanna iti apagkalima ti sigud a gatadna. ");
INSERT INTO iloulb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Maipapan kadagiti amin nga apagkapullo kadagiti arban wenno dingwen, aniaman a lumabas iti sarukod ti agpaspastor, ti apagkapullona ket masapul a maidaton kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Masapul a saan nga biruken ti agpaspastor ti nasaysayaat wenno ti naal-alas nga ay-ayup, ken masapul a sanna a pagsisinnukaten dagitoy. No pagsisinnukatenna dagitoy, ket agbalin a nasantoan ti nangsukat ken nasukatan nga ayup. Saanen a mabalin a subboten dagitoy.'” ");
INSERT INTO iloulb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Dagitoy dagiti bilbilin nga inted ni Yahweh kenni Moises idiay Bantay Sinai para kadagiti Israelita. ");
INSERT INTO iloulb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nagsao ni Yahweh kenni Moises idiay tabernakulo idiay let-ang ti Sinai. Napasamak daytoy iti umuna nga aldaw ti maikadua a bulan bayat ti maikadua a tawen kalpasan ti iruruar dagiti tattao ti Israel iti daga ti Egipto. Kinuna ni Yahweh, ");
INSERT INTO iloulb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Alaenyo ti bilang ti dagup dagiti amin a lallaki ti Israel iti tunggal puli, kadagiti pamilia ti ammada. Bilangenyo ida segun iti naganda. Bilangenyo ti tunggal lalaki ");
INSERT INTO iloulb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","nga agtawen iti duapulo wenno nasursurok pay. Bilangenyo amin a makabael a makiranget a kas soldado para iti Israel. Masapul a sika ken ni Aaron ti mangilista kadagiti bilang dagiti lallaki kadagiti bunggoy dagiti armadada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Ti lalaki manipud iti tunggal tribu, a panguloen ti puli, ket masapul nga agserbi a kaduam a kas mangidaulo iti tribuna. Masapul nga idauloan ti tunggal mangidaulo dagiti lallaki a makiranget para iti tribuna. ");
INSERT INTO iloulb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Dagitoy dagiti nagnagan dagiti mangidadaulo a rumbeng a kaduam a makiranget: Manipud iti tribu ti Ruben, ni Elizur nga anak a lalaki ni Sedeur; ");
INSERT INTO iloulb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","manipud iti tribu ti Simeon, ni Selumiel nga anak a lalaki ni Zurisadai; ");
INSERT INTO iloulb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","manipud iti tribu ti Juda, ni Naason nga anak a lalaki ni Aminadab; ");
INSERT INTO iloulb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","manipud iti tribu ti Issacar, ni Netanel nga anak a lalaki ni Suar; ");
INSERT INTO iloulb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","manipud iti tribu ti Zabulon, ni Eliab nga anak a lalaki ni Helon; ");
INSERT INTO iloulb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","manipud iti tribu ti Efraim nga anak a lalaki ni Jose, ni Elisama nga anak a lalaki ni Amiud; manipud iti tribu ti Manases, ni Gamaliel nga anak a lalaki ni Pedasur; ");
INSERT INTO iloulb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","manipud iti tribu ti Benjamin nga anak a lalaki ni Jose, ni Abidan nga anak a lalaki ni Gideoni; ");
INSERT INTO iloulb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","manipud iti tribu ti Dan, ni Ahiezer nga anak a lalaki ni Amisadai; ");
INSERT INTO iloulb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","manipud iti tribu ti Aser, ni Pagiel nga anak a lalaki ni Okran; ");
INSERT INTO iloulb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","manipud iti tribu ti Gad, ni Eliasaf nga anak a lalaki ni Deuel; ");
INSERT INTO iloulb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ken manipud iti tribu ti Neftali, ni Ahira nga anak a lalaki ni Enan. ");
INSERT INTO iloulb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Dagitoy dagiti lallaki a nadutokan manipud kadagiti tattao. Indauloanda dagiti tribu dagiti kapuonanda. Isuda dagiti mangidadaulo kadagiti puli idiay Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Innala ni Moises ken Aaron dagitoy a lallaki, a nailista segun iti naganda, ");
INSERT INTO iloulb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ken inummong dagitoy a lallaki ti amin a lallaki ti Israel iti umuna nga aldaw ti maikadua a bulan. Ket impalawag ti tunggal lalaki nga agtawen iti duapulo ken nasursurok pay ti kauponanda. Masapul a nagananna dagiti puli ken dagiti pamilia a nagtaud manipud iti kapuonanna. ");
INSERT INTO iloulb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ket inlista ni Moises dagiti bilangda idiay let-ang ti Sinai, a kas imbilin ni Yahweh nga aramidenna. ");
INSERT INTO iloulb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Nabilang amin manipud iti kaputotan ni Ruben, nga inauna nga anak ni Israel, dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Nabilangda ti 46, 500 a lallaki manipud iti tribu ti Ruben. ");
INSERT INTO iloulb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Nabilang amin manipud iti kaputotan ni Simeon dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Nabilangda ti 59, 300 a lallaki manipud iti tribu ti Simeon. ");
INSERT INTO iloulb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Nabilang amin manipud iti kaputotan ni Gad dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Nabilangda ti 45, 650 a lallaki manipud iti tribu ti Gad. ");
INSERT INTO iloulb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Nabilang amin manipud iti kaputotan ni Juda dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Nabilangda ti 74, 600 a lallaki manipud iti tribu ti Juda. ");
INSERT INTO iloulb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Nabilang amin manipud iti kaputotan ni Issacar dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Nabilangda ti 54, 400 a lallaki manipud iti tribu ti Issacar. ");
INSERT INTO iloulb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Nabilang amin manipud iti kaputotan ni Zabulon dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Nabilangda ti 57, 400 a lallaki manipud iti tribu ti Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Nabilang amin manipud iti kaputotan ni Efraim nga anak a lalaki ni Jose dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Nabilangda ti 40, 500 a lallaki manipud iti tribu ti Efraim. ");
INSERT INTO iloulb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Nabilang amin manipud iti kaputotan ni Manases nga anak a lalaki ni Jose dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Nabilangda ti 32, 200 a lallaki manipud iti tribu ti Manases. ");
INSERT INTO iloulb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Nabilang amin manipud iti kaputotan ni Benjamin dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Nabilangda ti 35, 400 a lallaki manipud iti tribu ti Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Nabilang amin manipud iti kaputotan ni Dan dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Nabilangda ti 62, 700 a lallaki manipud iti tribu ti Dan. ");
INSERT INTO iloulb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Nabilang amin manipud iti kaputotan ni Aser dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Nabilangda ti 41, 500 a lallaki manipud iti tribu ti Aser. ");
INSERT INTO iloulb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nabilang amin manipud iti kaputotan ni Neftali dagiti nagan ti tunggal lallaki nga agtawen ti duapulo wenno nasursurok a makabael a mapan makigubat, manipud iti listaan dagiti puli ti kapuonanda ken pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nabilangda ti 53, 400 a lallaki manipud iti tribu ti Neftali. ");
INSERT INTO iloulb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Binilang amin ni Moises ken Aaron dagitoy a lallaki, a kadua dagiti sangapulo ket dua a mangidadaulo iti sangapulo ket dua a tribu ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Isu nga amin a lallaki ti Israel manipud iti agtawen iti duapulo ken nasursurok, amin a makabael a makigubat ket nabilang iti tunggal pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Nabilangda ti 603, 550 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ngem saan a nabilang dagiti lallaki a nagtaud manipud kenni Levi, ");
INSERT INTO iloulb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","gapu ta kinuna ni Yahweh kenni Moises, ");
INSERT INTO iloulb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Saanmo a masapul a bilangen ti tribu ti Levi wenno iraman isuda iti pakadagupan dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ngem ketdi, dutokam dagiti Levita nga agaywan iti tabernakulo a pammaneknek iti tulag, ken agaywan kadagiti amin nga alikamen idiay tabernakulo ken amin nga adda iti daytoy. Masapul a bagkaten dagiti Levita ti tabernakulo, ken dagiti al-alikamenna. Masapul nga aywananda ti tabernakulo ken aramidenda ti kampoda iti aglawlaw daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","No maiyakar ti tabernakulo iti sabali a disso, dagiti Levita ti masapul a mangakas daytoy. No ipatakderda ti tabernakulo, dagiti Levita ti masapul a mangipatakder daytoy. Ken masapul a mapapatay ti siasinoman a gangannaet nga umasideg iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","No agkampo dagiti tattao ti Israel, masapul nga aramiden daytoy ti tunggal lallaki iti asideg ti wagayway a kukua ti bunggoy ti armadana. ");
INSERT INTO iloulb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Nupay kasta, masapul nga ipatakder dagiti Levita dagiti toldada iti aglawlaw ti tabernakulo a pammaneknek iti tulag tapno saan nga agdissuor ti ungetko kadagiti tattao ti Israel. Masapul nga aywanan dagiti Levita ti tabernakulo a pammaneknek iti tulag.” ");
INSERT INTO iloulb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Inaramid amin dagiti Israelita dagitoy a banbanag. Inaramidda amin nga imbilin ni Yahweh babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nagsao manen ni Yahweh kada Moises ken Aaron. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Masapul nga agkampo ti tunggal kaputotan ti Israel iti aglawlaw iti wagayway iti bunggoy iti armada a kukua dagiti soldado, ken iti aglawlaw ti basbassit a wagayway a mangipakpakita iti tribuna. Masapul a sumango dagiti kampoda iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Masapul nga agkampo dagiti lallaki a naibilang iti kampo ti Juda ken dagiti bunggoy ti armadada iti aglawlaw ti wagayway ti Juda, iti daya ti tabernakulo, iti paset a pagsingsingisingan ti init. Masapul nga idauloan ni Naason nga anak a lalaki ni Aminadab ti armada ti Juda. ");
INSERT INTO iloulb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Addaan ti armada ti Juda iti 74, 600 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Masapul nga agkampo dagiti tribu ti Issacar a sumaruno iti Juda. Masapul nga idauloan ni Netanel nga anak a lalaki ni Suar ti armada ti Issacar. ");
INSERT INTO iloulb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Addaan ti armada ti Netanel iti 54, 400 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Masapul nga agkampo dagiti tribu ti Zabulon a sumaruno iti Issacar. Masapul nga idauloan ni Eliab nga anak a lalaki ni Helon ti armada ti Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Addaan ti armada ti Zabulon iti 57, 400 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ti bilang dagiti amin nga armada a nagkampo a kadua ti Juda ket 186, 400 a lallaki. Masapul nga isuda ti umuna a rummuar iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Dagiti armada iti abagatan a paset ket masapul nga agkampo iti aglawlaw ti wagayway ti Ruben. Masapul nga idauloan ni Elizur nga anak a lalaki ni Sedeur ti armada ti Ruben. ");
INSERT INTO iloulb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Addaan ti armada ti Ruben iti 46, 500 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Masapul nga agkampo dagiti tribu ti Simeon a sumaruno iti Ruben. Masapul nga idauloan ni Selumiel nga anak a lalaki ni Zurisadai ti armada ti Simeon. ");
INSERT INTO iloulb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Addaan ti armada ti Simeon iti 59, 300 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ti tribu ti Gad ti sumaruno. Masapul nga idauloan ni Eliasaf nga anak a lalaki ni Deuel ti armada ti Gad. ");
INSERT INTO iloulb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Addaan ti armada ti Gad iti 45, 650 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Ti bilang dagiti amin nga armada a nagkampo a kadua ti Ruben ket 151, 450 a lallaki. Masapul nga isuda ti maikadua a rummuar iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sumaruno, masapul a rummuar ti tabernakulo manipud iti kampo, nga adda iti tengnga dagiti kampo dagiti Levita. Masapul a rummuarda iti kampo iti isu met laeng nga urnos a kas mapanda iti uneg ti kampo. Masapul nga adda ti tunggal lalaki iti lugarna, segun iti wagaywayna. ");
INSERT INTO iloulb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Masapul nga agkampo dagiti armada ti Efraim iti laud a paset ti tabernakulo. Masapul nga idauloan ni Elisama nga anak a lalaki ni Amiud ti armada ti Efraim. ");
INSERT INTO iloulb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Addaan ti armada ti Efraim iti 40, 500 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Masapul nga agkampo ti tribu ti Manases a sumaruno iti Efraim. Masapul nga idauloan ni Gamaliel nga anak a lalaki ni Pedasur ti armada ti Manases. ");
INSERT INTO iloulb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Addaan ti armada ti Manases iti 32, 200 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ti tribu ti Benjamin ti sumaruno. Masapul nga idauloan ni Abidan nga anak a lalaki ni Gideoni ti armada ti Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Addaan ti armada ti Manases iti 35, 400 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ti bilang amin dagiti armada a nagkampo a kadua ti Efraim ket 108, 100 a lallaki. Masapul nga isuda ti maikatlo a rummuar iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Masapul nga agkampo dagiti armada ti Dan iti aglawlaw iti wagayway iti laud a paset ti tabernakulo. Masapul nga idauloan ni Ahiezer nga anak a lalaki ni Amisadai dagiti kaputotan ni Dan. ");
INSERT INTO iloulb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Addaan ti armada ti Dan iti 62, 700 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Masapul nga agkampo dagiti tattao ti tribu ti Aser a sumaruno iti Dan. Masapul nga idauloan ni Pagiel nga anak a lalaki ni Okran dagiti kaputotan ni Aser. ");
INSERT INTO iloulb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Addaan ti armada ti Aser iti 41, 500 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ti tribu ti Neftali ti sumaruno. Masapul nga idauloan ni Ahira nga anak a lalaki ni Enan dagiti kaputotan ni Neftali. ");
INSERT INTO iloulb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Addaan ti armada ti Neftali iti 53, 400 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Ti bilang dagiti amin nga armada a nagkampo a kadua ti Dan ket 157, 600 a lallaki. Masapul nga isuda ti maudi a rummuar iti kampo a bitbit ti wagaywayda.” ");
INSERT INTO iloulb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Nabilang da Moises ken Aaron segun ti puli dagiti kapuonanda ti 603, 550 a lallaki kadagiti armada dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ngem saan nga inbilang da Moises ken Aaron dagiti Levita kadagiti tattao iti Israel. Daytoy ket kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Inaramid amin dagiti tattao ti Israel dagiti amin nga imbilin ni Yahweh kenni Moises. Nagkampoda segun kadagiti wagaywayda. Rimmuarda iti kampo segun iti pulida, iti panagsasaruno dagiti kapuonan dagiti pamiliada. ");
INSERT INTO iloulb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ita, daytoy ti pakasaritaan dagiti kaputotan da Aaron ken Moises idi nagsao ni Yahweh kenni Moises idiay Bantay Sinai. ");
INSERT INTO iloulb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Dagiti nagan dagiti annak a lallaki ni Aaron ket Nadab ti inauna, ni Abiu, Eleazar ken Itamar. ");
INSERT INTO iloulb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Dagitoy dagiti nagan dagiti annak a lallaki ni Aaron, dagiti papadi a napulotan ken nakonsagraran nga agserbi a kas papadi. ");
INSERT INTO iloulb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ngem natay da Nadab ken Abiu iti sangoanan ni Yahweh idi nangidatonda iti apuy a saan a maikari idiay let-ang ti Sinai. Awan ti annak da Nadab ken Abiu, isu a ni Eleazar ken Itamar laeng ti nagserbi a kas papadi a kadua ni Aaron nga amada. ");
INSERT INTO iloulb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Iyegmo ti tribu ni Levi ket idatag mo ida kenni Aaron a padi tapno tulonganda isuna. ");
INSERT INTO iloulb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Masapul nga aramidenda dagiti annongen iti biang ni Aaron ken dagiti amin a tattao iti sangoanan ti tabernakulo. Masapul nga agserbida iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Masapul nga aywananda dagiti amin nga alikamen idiay tabernakulo, ken masapul a tulonganda dagiti tribu ti Israel a mangaramid iti trabaho ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Masapul nga itedmo dagiti Levita kenni Aaron ken kadagiti annakna a lallaki. Maitedda amin a tumulong kenkuana nga agserbi kadagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Masapul a dutokam da Aaron ken dagiti annakna a lallaki a kas papadi, ngem masapul a mapapatay ti siasinoman a gangannaet nga umasideg.” ");
INSERT INTO iloulb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Adtoy, innalak dagiti Levita manipud kadagiti tattao ti Israel. Inaramidko daytoy imbes nga alaek iti tunggal inauna nga annak a lallaki a maiyanak manipud kadagiti tattao ti Israel. Kukuak dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Kukuak dagiti amin nga inauna nga annak. Idi aldaw a dinarupko dagiti amin nga inauna nga annak iti daga ti Egipto, inlasinko para iti bagik dagiti amin nga inauna nga annak ti Israel, dagiti tattao ken ay-ayup. Kukuak ida. Siak ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Nagsao ni Yahweh kenni Moises idiay let-ang ti Sinai. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Bilangem dagiti kaputotan ni Levi iti tunggal pamilia, kadagiti babbalay dagiti kapuonanda. Bilangem dagiti tunggal lalaki nga addan iti maysa a bulanna ken agpangato.” ");
INSERT INTO iloulb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Binilang ida ni Moises, mayannurot kadagiti bilin a naited kadakuada babaen kadagiti sasao ni Yahweh, kas imbilin ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Dagiti nagan dagiti annak a lallaki ni Levi ket da Gerson, Coat ken Merari. ");
INSERT INTO iloulb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Dagiti puli a nagtaud kadagiti annak a lallaki ni Gerson ket da Libni ken Simei. ");
INSERT INTO iloulb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Dagiti puli a nagtaud kadagiti annak a lallaki ni Coat ket da Amram, Izhar, Hebron ken Uzziel. ");
INSERT INTO iloulb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Dagiti puli a nagtaud kadagiti annak a lallaki ni Merari ket da Mali ken Musi. Dagitoy dagiti puli dagiti Levita a nailista babaen kadagiti pulida. ");
INSERT INTO iloulb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Dagiti puli dagiti Libnitas ken dagiti Semitas ket nagtaud kenni Gerson. Dagitoy dagiti puli dagiti Gersonitas. ");
INSERT INTO iloulb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Nabilang dagiti amin a lallaki manipud maysa bulan ti tawenna ken agpangato, a ti dagupna ket 7, 500. ");
INSERT INTO iloulb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Masapul nga agkampo dagiti puli dagiti Gersonitas iti lauden ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Masapul nga idauloan ni Eliasaf nga anak a lalaki ni Lael dagiti puli dagiti kaputotan dagiti Gersonitas. ");
INSERT INTO iloulb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Masapul nga aywanan ti pamilia ni Gerson dagiti kurtina dagiti akinruar nga abbong ti tabernakulo. Masapul nga aywananda ti tolda, ti kasla tolda nga abbongna, ken ti kurtina para iti pagserrekan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Masapul nga aywananda dagiti bengbeng ti paraangan, ti kurtina nga adda iti pagserrekan ti paraangan —ti paraangan a nakapalikmut iti santuario ken iti altar. Masapul nga aywananda dagiti tali ti tabernakulo ken amin a banag nga adda iti unegna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Nagtaud kenni Coat dagitoy a puli: ti puli dagiti Amramitas, ti puli dagiti Izeharitas, ti puli dagiti Hebronitas, ken ti puli dagiti Ozielitas. Puli dagiti Coatitas dagitoy. ");
INSERT INTO iloulb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Nabilang nga 8, 600 dagiti lallaki nga addan makabulanna ken agpangato, a mangaywan kadagiti banbanag a kukua ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Masapul nga agkampo dagiti pamila dagiti kaputotan ni Coat iti abagatan a paset ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Masapul nga idauloan ni Elizaphan nga anak a lalaki ni Uzziel dagiti puli dagiti Coatitas. ");
INSERT INTO iloulb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Masapul nga aywananda ti lakasa ti tulag, ti lamisaan, ti kandelero, dagiti altar, dagiti nasantoan a banbanag a maus-usar iti panagserbida, dagiti kurtina ken amin a trabaho iti aglalawna daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Masapul nga idauloan ni Eleazar nga anak a lalaki ni Aaron a padi dagiti lallaki a mangidadaulo kadagiti Levita. Masapul nga imatonanna dagiti lallaki a mangay-aywan iti nasantoan a lugar. ");
INSERT INTO iloulb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Dua a puli ti nagtaud kenni Merari: ti puli dagiti Malita ken ti puli dagiti Musita. Nagtaud kenni Merari dagitoy a puli. ");
INSERT INTO iloulb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Nabilang a 6, 200 dagiti lallaki nga addan makabulanna ken agpangato. ");
INSERT INTO iloulb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Masapul nga idauloan ni Zuriel nga anak a lalaki ni Abihail dagiti puli ni Merari. Masapul nga agkampoda iti amianan a paset ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Masapul nga aywanan dagiti kaputotan ni Merari dagiti tabtabla ti tabernakulo, dagiti balunetna, dagiti adigi, dagiti pagbatayan, dagiti amin nga aruatenna daytoy, ken amin a banag a mainaig kadagitoy, agraman ");
INSERT INTO iloulb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","dagiti adigi ken poste ti paarangan a nakapalikmut iti tabernakulo, dagiti nagsisilpoanda, dagiti pasok ken dagiti talida. ");
INSERT INTO iloulb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Masapul nga agkampo da Moises, Aaron ken dagiti annakna a lallaki iti dayaen ti tabernakulo, iti sangoanan ti tabernakulo, nga agturong iti pagsingisingan ti init. Isuda ti makinrebbeng ti pannakaipatungpal dagiti annongen ti santuario ken dagiti annongen dagiti tattao ti Israel. Siasinoman a gangannaet nga umasideg iti santuario ket masapul a mapapatay. ");
INSERT INTO iloulb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Binilang da Moises ken Aaron dagiti amin a lallaki iti puli ni Levi nga agtawen iti maysa bulan ken agpangato, kas imbilin ni Yahweh. Nabilangda ti 22, 000 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Kinuna ni Yahweh kenni Moises, “Bilangem dagiti amin nga inauna nga annak a lallaki dagiti Israelita nga addan ti makabulanna ken agpangato. Ilistam dagiti naganda. ");
INSERT INTO iloulb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Masapul nga alaem dagiti Levita para kaniak imbes a dagiti amin nga inauna nga annak dagiti tattao ti Israel. Siak ni Yahweh. Ken masapul nga alaem dagiti dingwen dagiti Levita imbes a dagiti amin nga inauna nga annak dagiti dingwen dagiti kaputotan ti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Binilang ni Moises dagiti amin nga inauna nga annak dagiti tattao ti Israel kas imbilin ni Yahweh nga aramidenna. ");
INSERT INTO iloulb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Binilangna amin nga inauna nga annak a lallaki babaen iti naganda, dagiti addan makabulanna ken agpangato. Nabilangna ti 22, 273 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Alaem dagiti Levita imbes a dagiti inauna nga annak dagiti tattao ti Israel. Ken alaem dagiti taraken dagiti Levita imbes a dagiti taraken dagiti tattao. Kukuak dagiti Levita. Siak ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Masapul a mangsingirka iti lima a siklo para iti pannakasubbot ti tunggal maysa kadagiti 273 nga inauna nga annak dagiti tattao ti Israel a limmabes iti bilang dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Masapul nga usarem ti siklo ti santuario a kas pagbasaram a timbang. Ti maysa a siklo ket kapada ti duapulo a gerahs. ");
INSERT INTO iloulb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Masapul nga itedmo ti gatad ti pannakasubbot a binayadam kenni Aaron ken kadagiti annakna a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Isu a nangsingir ni Moises ti bayad ti pannakasubbot manipud kadagiti limmabes iti bilang dagiti sinubbot dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Siningir ni Moises iti kuarta kadagiti inauna nga annak dagiti tattao ti Israel. Nakasingir isuna iti 1, 365 a siklo, a katimtimbang ti siklo ti santuario. ");
INSERT INTO iloulb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Inted ni Moises ti pangsubbot a kuarta kenni Aaron ken kadagiti annakna a lallaki. Inaramid ni Moises dagiti amin a banag a naibaga kenkuana nga aramidenna babaen iti sao ni Yahweh, kas imbilin ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nagsao ni Yahweh kada Moises ken Aaron. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Alaenyo ti dagup dagiti lallaki a kaputotan ni Coat kadagiti tribu ti Levita, segun kadagiti pulida ken kadagiti pamilia ti kapuonanda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Bilangenyo dagiti amin a lallaki nga agtawen iti tallopulo agingga iti limapulo. Masapul a makikadua dagitoy a lallaki iti bunggoy dagiti agserbi iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Masapul nga aywanan dagiti kaputotan ni Coat dagiti kasasantoan a banbanag a nakalasin para kaniak idiay tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","No agsagsagana nga agtuloy nga agdaliasat dagiti tattao, masapul nga umuneg iti tolda ni Aaron ken dagiti annakna a lallaki, ikkatenda ti kurtina a mangisinsina iti kasasantoan a lugar manipud iti nasantoan a lugar ken iyabbongda daytoy iti lakasa ti tulag a pammaneknek. ");
INSERT INTO iloulb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Masapul nga abbonganda ti lakasa kadagiti lalat ti foca. Masapul nga aplaganda ti rabawna iti asul a lupot. Masapul nga iyusokda ti assiw a pangawit iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Masapul nga agiyaplagda iti asul a lupot iti rabaw ti lamisaan ti tinapay ti presensia ti Dios. Masapul nga iparabawda iti daytoy dagiti pinggan, kutsara, mallukong ken burnay a pangbukbok. Masapul a kankanayon nga adda tinapay iti rabaw ti lamisaan. ");
INSERT INTO iloulb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Masapul nga abbonganda dagitoy iti nalabbaga a lupot sada manen abbongan kadagiti lalat ti foca. Masapul nga agiyusokda kadagiti assiw a pangawit iti lamisaan. ");
INSERT INTO iloulb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Masapul a mangalada iti asul a lupot ken abbonganda ti kandelero agraman dagiti pagsilawanna, dagiti pagipit, dagiti bandeha ken dagiti amin a burnay ti lana para iti pagsilawan. ");
INSERT INTO iloulb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Masapul nga ikabilda ti kandelero ken dagiti amin nga alikamenna iti pangabbong a lalat ti foca, ken masapul nga ikabilda daytoy iti nasangal a pagawitan. ");
INSERT INTO iloulb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Masapul a mangiyaplagda iti asul a lupot iti rabaw ti balitok nga altar. Masapul nga abbonganda daytoy iti pangabbong a lalat ti foca, ken kalpasanna, iyusokda dagiti assiw a pangbagkat. ");
INSERT INTO iloulb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Masapul nga alaenda dagiti amin nga alikamen para iti trabaho iti nasantoan a lugar ken balkotenda daytoy iti asul a lupot. Masapul nga abbonganda daytoy kadagiti lalat ti foca ken ikabilda dagiti alikamen iti nasangal a pagawitan. ");
INSERT INTO iloulb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Masapul nga ikkatenda dagiti dapo manipud iti altar ken iyaplagda ti lila a lupot iti rabaw ti altar. ");
INSERT INTO iloulb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Masapul nga ikabilda iti nasangal a pagawitan dagiti amin nga alikamen nga us-usarenda iti trabaho ti altar. Dagitoy a banbanag ket dagiti pagikkan iti beggang, dagiti tinidor, dagiti pala, dagiti mallukong, ken dagiti amin a dadduma nga alikamen para iti altar. Masapul nga abbonganda ti altar kadagiti lalat ti foca sada iyusok dagiti assiw a pangbagkat. ");
INSERT INTO iloulb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Inton naan-anayen a naabbongan ni Aaron ken dagiti annakna a lallaki ti nasantoan a lugar ken dagiti amin nga alikamenna daytoy, ken inton umakaren ti kampo ket masapul nga umay dagiti kaputotan ni Coat a mangawit iti nasantoan a lugar. No masagidda ti nasantoan a banbanag, masapul a matayda. Daytoy ti trabaho dagiti kaputotan ni Coat, ti mangawit kadagiti alikamen nga adda iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ni Eleazar nga anak a lalaki ni Aaron a padi ti masapul a mangaywan iti lana para iti silaw. Masapul nga imatonanna ti panangaywan kadagiti nabanglo nga insenso, ti inaldaw a sagut a bukbukel, ti lana a pangpulot, ken ti entero a tabernakulo ken dagiti amin nga adda iti unegna daytoy, dagiti nasantoan nga alikamen ken banbanag.” ");
INSERT INTO iloulb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Nagsao ni Yahweh kada Moises ken Aaron. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Saanyo nga ipalubos a maikkat dagiti puli ti tribu a Coatita manipud kadagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Salaknibanyo ida, tapno agbiagda ket saanda a matay, babaen ti panangaramidda iti daytoy. No umasidegda kadagiti kasasantoan a banbanag, ");
INSERT INTO iloulb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","masapul a saanda nga umuneg a mangkita iti nasantoan a lugar uray iti apagbiit, ta no saan ket matayda. Masapul nga umuneg ni Aaron ken dagiti annakna a lallaki, ket kalpasanna, masapul nga isaad ni Aaron ken dagiti annakna a lallaki iti tunggal Coatita iti trabahona, kadagiti naisangsangayan nga aramidenna.” ");
INSERT INTO iloulb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Alaem pay ti dagup dagiti kaputotan ni Gerson, segun kadagiti pamilia dagiti kapuonanda, segun kadagiti pulida. ");
INSERT INTO iloulb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bilangem dagiti agtawen ti tallopulo agingga iti limapulo a tawen. Bilangem amin dagiti makikadua nga agserbi idiay tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Daytoy ti trabaho dagiti puli dagiti Gersonita, no agserbida ken no ania ti awitenda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Masapul nga awitenda dagiti kurtina ti tabernakulo, ti nasagradoan a tolda, dagiti abbongna, ti abbong a lalat ti foca nga adda iti rabaw daytoy, ken dagiti kurtina iti pagserrekan iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Masapul nga awitenda dagiti kurtina ti paraangan, ti kurtina a nagbalin a pannakaridaw iti ruangan ti paraangan nga adda iti asideg ti tabernakulo ken ti altar, dagiti talida ken amin nga alikamen para iti panagserbida. Aniaman ti rumbeng a maaramid kadagitoy a banbanag, masapul nga aramidenda daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Masapul nga imatonan ni Aaron ken dagiti annakna a lallaki dagiti amin a panagserbi dagiti kaputotan dagiti Gersonita, kadagiti amin a banbanag nga awitenda ken kadagiti amin a panagserbida. Masapul nga isaadmo ida kadagiti amin a pagrebbenganda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Daytoy ti panagserbi dagiti puli dagiti kaputotan dagiti Gersonita para iti tabernakulo. Ni Itamar nga anak a lalaki ni Aaron a padi ti masapul a mangidaulo kadakuada iti panagserbida. ");
INSERT INTO iloulb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Masapul a bilangem dagiti kaputotan ni Merari segun kadagiti pulida ken urnosem ida segun kadagiti pamilia dagiti kapuonanda, ");
INSERT INTO iloulb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","manipud agtawen ti tallopulo agingga iti limapulo. Bilangem ti amin a makikadua iti bunggoy ken agserbi ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Daytoy ti pagrebbengan ken trabahoda iti amin a panagserbida para iti tabernakulo. Masapul nga aywananda dagiti tabtabla ti tabernakulo, dagiti balunet, dagiti adigi ken dagiti batbatayda, ");
INSERT INTO iloulb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","agraman dagiti ad-adigi ti paraangan iti aglawlaw ti tabernakulo, dagiti batbatayda, paspasok ken dagiti talida, ken dagiti amin nga aruatenda. Ilistam ti nagan dagiti banbanag a masapul nga awitenda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Daytoy ti panagserbi dagiti puli dagiti kaputotan ni Merari, ti masapul nga aramidenda para iti tabernakulo, babaen ti panangiturong ni Itamar nga anak a lalaki ni Aaron a padi.” ");
INSERT INTO iloulb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Binilang da Moises ken Aaron ken dagiti amin a mangidadaulo kadagiti amin a tattao dagiti amin a kaputotan dagiti Coatita, segun kadagiti puli dagiti pamilia ti kapuonanda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Binilangda ida manipud iti agtawen ti tallopulo ken agpangato agingga iti agtawen iti limapulo. Binilangda dagiti amin a makikadua iti bunggoy nga agserbi iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Nabilangda ti 2, 750 a lallaki segun kadagiti pulida. ");
INSERT INTO iloulb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Binilang ni Moises ken Aaron dagiti amin a lallaki kadagiti puli ken pamilia dagiti Coatita nga agserserbi iti tabernakulo. Iti panangaramidda iti daytoy, tinungpalda iti imbilin ni Yahweh kadakuada nga aramidenda babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Nabilang dagiti kaputotan ti Gerson kadagiti pulida, segun kadagiti pamilia dagiti kapuonanda, ");
INSERT INTO iloulb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","manipud iti agtawen iti tallopulo agingga iti limapulo, amin a makikadua kadagiti agserbi iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Dagiti amin a lallaki a nabilang segun kadagiti pulida ken kadagiti pamilia dagiti kapuonanda ket 2, 630 ti bilangda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Binilang ni Moises ken ni Aaron dagiti puli dagiti kaputotan ni Gerson nga agserbi iti tabernakulo. Iti panangaramidda iti daytoy, tinungpalda iti imbilin kadakuada ni Yahweh nga aramidenda babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Nabilang dagiti kaputotan ni Merari kadagiti pulida, segun kadagiti pamilia dagiti kapuonanda, ");
INSERT INTO iloulb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","manipud iti agtawen ti tallopulo agingga iti limapulo, ti tunggal maysa a makikadua iti bunggoy nga agserbi iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Dagiti amin a lallaki a nabilang segun kadagiti pulida ken kadagiti pamilia dagiti kapuonanda ket 3, 200 ti bilangda. ");
INSERT INTO iloulb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Binilang da Aaron ken Moises dagitoy amin a lallaki a kaputotan ni Merari. Iti panangaramidda iti daytoy, tinungpalda iti imbilin ni Yahweh kadakuada nga aramidenda babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Binilang ngarud ni Moises, ni Aaron ken dagiti mangidadaulo iti Israel dagiti amin a Levita segun kadagiti pulida iti pamilia dagiti kapuonanda ");
INSERT INTO iloulb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","manipud agtawen iti tallopulo agingga iti limapulo. Binilangda dagiti amin nga agtrabaho iti tabernakulo ken dagiti agawit ken mangaywan kadagiti banbanag iti uneg ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Nabilangda ti 8, 580 a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Babaen iti bilin ni Yahweh, binilang ni Moises ti tunggal lalaki, binilangna ti tunggal maysa segun iti kita ti trabaho a naidutok nga aramidenda. Binilangna ti tunggal lallaki segun iti kita ti pagrebbengan a masapul a baklayenna. Iti panangaramidda iti daytoy, tinungpalda iti imbilin kadakuada ni Yahweh nga aramidenda babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Bilinem dagiti tattao ti Israel a papanawenda manipud iti kampo dagiti amin nga addaan iti makaakar a sakit ti kudil, ken dagiti amin nga addaan iti agnannana a sugat ken ti siasinoman a narugit babaen iti panangsagidda iti bangkay. ");
INSERT INTO iloulb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Lalaki man wenno babai, masapul a paruarenyo ida iti kampo. Masapul a saanda a tulawan ti kampo gapu ta agnanaedak iti daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Inaramid ngarud dayta dagiti tattao ti Israel. Pinapanawda ida iti kampo, kas imbilin ni Yahweh kenni Moises. Nagtulnog dagiti tattao ti Israel kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Agsaoka kadagiti tattao ti Israel. No agbasol ti maysa a lalaki wenno babai a kas ti ar-aramiden dagiti tattao iti tunggal maysa, ken saanda a napudno kaniak, nagbasol dayta a tao. ");
INSERT INTO iloulb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ket masapul nga ipudnona ti basol nga inaramidna. Masapul a bayadanna a naan-anay ti gatad ti basolna ken nayonanna pay ti gatadna iti apagkalima. Masapul nga itedna daytoy iti nakabasolanna. ");
INSERT INTO iloulb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ngem no awan ti asideg a kabagian ti tao a nakabasolan a mangawat iti bayad, masapul a bayadanna kaniak ti gatad ti basolna babaen iti padi, a pakuyoganna ti maysa a kalakian a kalding para iti pannakapakawanna. ");
INSERT INTO iloulb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Tunggal daton a maidatag iti padi manipud kadagiti amin a nasantoan a banbanag, kukua dayta a padi dagiti banbanag nga inlasin dagiti tattao ti Israel a para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kukua ti padi dagiti nasantoan a banbanag ti tunggal tao. Kukua dayta a padi ti aniaman nga ited ti tao iti padi.” ");
INSERT INTO iloulb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Agsaoka kadagiti tattao ti Israel. Ibagam kadakuada, 'Kas pangarigan, immadayo ti babai ken nagbasol iti asawana. ");
INSERT INTO iloulb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Ket kas pangarigan a kinaidda ti sabali a lalaki isuna. Iti dayta a pasamak, natulawan isuna. Uray no saan a makitkita ti asawana a lalaki ken saanna nga ammo ti maipapan iti daytoy ken uray no awan ti makatiliw kenkuana a mangar-aramid iti daytoy ken awan ti mangpaneknek a maibusor kenkuana, ");
INSERT INTO iloulb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","nupay kasta, mabalin nga ipakaammo ti espiritu ti imon iti asawana a lalaki a natulawan ti asawana. Uray pay no kasta, mabalin a marikna iti lalaki iti imon nga awan gapgapuna no saan a natulawan ti asawana. ");
INSERT INTO iloulb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Iti kasta a paspasamak, masapul nga ipan ti lalaki ti asawana iti padi. Masapul a mangala ti asawa a lalaki iti sagut a mainom para iti asawana. Masapul a mangiyeg isuna iti apagkapullo nga efa iti arina a sebada. Masapul a saanna a bukbokan daytoy iti lana wenno insenso gapu ta maysa daytoy a daton iti bukbukel iti panagimon, daton a bubukkel a mabalin a pagilasinan iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Masapul nga iyasideg ti padi ti babai ken ipanna isuna iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Masapul a mangala ti padi iti burnay ti nasantoan a danum ken mangala isuna iti tapok manipud iti datar iti tabernakulo. Masapul nga ikabilna ti tapok iti danum. ");
INSERT INTO iloulb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Masapul nga ikabil ti padi ti babai iti sangoanan ni Yahweh. Masapul nga ikkaten ti babai ti abbong ti ulona ken ti punggos ti buokna. Masapul nga ikabil ti padi ti daton a bukbukel iti ima ti babai a kas pagilasinan. Daton a bukbukel daytoy ti panagimon. Masapul nga iggaman ti padi ti napait a danum nga adda tapokna a mabalin a makaited iti lunod kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Masapul a pagsapataen ti padi isuna. Masapul nga ibagana iti babai, 'No awan ti lalaki a nakikaidda kenka, ken no saanka a naiyaw-awan ken nagaramid iti kinarugit, ket awan duadua a mawayawayaanka manipud iti daytoy a napait a danum a makaited ti lunod. ");
INSERT INTO iloulb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ngem no sika, babai nga adda iti turay ti asawana ket naiyaw-awan, no natulawanka ken no adda sabali a lalaki a nakikaidda kenka...” ");
INSERT INTO iloulb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Ket masapul a pagsapataen ti padi ti babai iti sapata a makaited ti lunod kenkuana, ken masapul nga itultuloyna ti agsao iti babai, “... ket pagbalinennaka ni Yahweh a lunod a maiparang kadagiti tattaom a kasta. Mapasamak daytoy no pagkebbeten ni Yahweh dagiti luppom ken pabussogenna ti buksitmo. ");
INSERT INTO iloulb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Umuneg iti tiyanmo daytoy a danum a makaited iti lunod, pabussogenna ti buksitmo ken pakebbetenna dagiti luppom.” Isungbatto ti babai, “Wen, mapasamak koma dayta no nagbasolak.” ");
INSERT INTO iloulb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Masapul nga isurat ti padi dagitoy a lunod iti nalukot a pagbasaan ket kalpasanna masapul a buggoanna dagiti naisurat a lunod iti napait a danum. ");
INSERT INTO iloulb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Masapul a painumen ti padi ti babai iti napait a danum a makaited iti lunod. Umuneg kenkuana ti danum a makaited iti lunod ket agbalin a napait daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Masapul nga alaen ti padi ti daton a bukbukel ti panagimon manipud iti ima ti babai. Masapul nga ipangatona ti daton a bukbukel iti sangoanan ni Yahweh ken ikabilna daytoy iti altar. ");
INSERT INTO iloulb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Masapul a mangala ti padi iti sangarakem iti daton a bukbukel, iti pasetna daytoy, ket puoranna daytoy iti rabaw ti altar. Kalpasanna, masapul nga itedna iti babai ti napait a danum nga inumenna. ");
INSERT INTO iloulb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Inton itedna iti babai ti danum nga inumenna, no natulawan isuna gapu ta nagbasol isuna iti asawana a lalaki, ket umuneg kenkuana ti danum a makaited ti lunod ket agbalin a napait. Bumsogto ti buksitna ken kumbetto dagiti luppona. Mailunodto ti babai kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ngem no saan a natulawan ti babai ken no nadalus isuna, ket rumbeng a mawaya-wayaan isuna. Mabalinto nga agsikog isuna. ");
INSERT INTO iloulb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Daytoy ti linteg ti panagimon. Linteg daytoy para iti babai nga umadayo iti asawana ken natulawan. ");
INSERT INTO iloulb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Daytoy ti linteg para iti lalaki nga addaan iti espiritu ti imon no agim-imon isuna iti asawana. Masapul nga ipanna ti babai iti sangoanan ni Yahweh, ken masapul nga aramiden ti padi kenkuana dagiti amin nga iladladawan daytoy a linteg ti panagimon. ");
INSERT INTO iloulb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Nawayanto ti lalaki manipud iti basol gapu iti panangipanna iti asawana iti padi. Masapul a baklayen ti babai ti aniaman a biddut a mabalin nga adda kenkuana.'” ");
INSERT INTO iloulb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nagsao ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Kinunana, “Agsaoka kadagiti tattao ti Israel. Ibagam kadakuada, 'No isina ti maysa a lalaki wenno babai ti bagina para kenni Yahweh nga addaan iti naisangsangayan a sapata iti maysa a Nazireo, ");
INSERT INTO iloulb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","masapul nga adaywanna iti arak ken naingel a mainom. Masapul a saan isuna nga uminom iti suka a naaramid iti arak wenno naingel a mainom. Masapul a saan isuna nga uminom iti tubbog ti ubas wenno mangan kadagiti kaburburas nga ubas wenno pasas. ");
INSERT INTO iloulb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Iti amin nga aldaw a naisina isuna para kaniak, masapul a saan isuna a mangan iti naaramid manipud iti ubas, agraman iti amin a banbanag a naaramid kadagiti bukbukel agingga kadagiti ukis. ");
INSERT INTO iloulb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Kabayatan iti amin a tiempo ti panagsapatana iti pannakaisina, awan ti mabalin a mausar a pagpukis iti ulona agingga a matungpal dagiti aldaw iti pannakaisinana para kenni Yahweh. Masapul a maidaton isuna kenni Yahweh. Masapul a paatiddogenna ti buok iti ulona. ");
INSERT INTO iloulb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kabayatan ti amin a tiempo nga isinsinana ti bagina nga agpaay kenni Yahweh, masapul a saan isuna nga umasideg iti bangkay. ");
INSERT INTO iloulb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Masapul a saanna a rugitan ti bagina uray no matay ti amana, inana, kabsatna a babai wenno kabsatna a lalaki. Daytoy ket gapu ta naisina isuna nga agpaay iti Dios, a kas makita ti amin a tattao babaen iti atiddog a buokna. ");
INSERT INTO iloulb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kabayatan ti amin a tiempo ti pannakaisinana, nasantoan isuna nga agpaay kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","No adda kellaat a natay iti abayna ken rugitanna ti tao a naisina, masapul ngarud a kalboenna ti ulona iti aldaw iti pannakadalusna, a masapul a kalpasan ti pito nga aldaw. Dayta ti tiempo a masapul a kalboenna ti ulona. ");
INSERT INTO iloulb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Iti maikawalo nga aldaw, masapul a mangiyeg isuna iti padi kadagiti dua a kalapati wenno dua a sibong a pagaw iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Masapul nga agidaton ti padi ti maysa a billit a kas daton gapu iti basol ken ti sabali a kas daton a maipuor. Daytoyto ti mangdalus kenkuana gapu ta nagbasol isuna babaen iti iyaasidegna iti bangkay. Masapul nga idatonna manen ti bagina kenni Yahweh iti dayta met laeng nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Masapul nga idatonna manen ti bagina kenni Yahweh para iti tiempo ti pannakaisinana. Masapul a mangiyeg isuna iti urbon a kalakian a karnero a maysa ti tawenna a kas daton a pangsupapak iti basol. Masapul a saan a maibilang dagiti aldaw sakbay a natulawan ti bagina, gapu ta natulawan isuna kabayatan a naisina isuna nga agpaay iti Dios. ");
INSERT INTO iloulb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Daytoy ti linteg maipapan iti Nazireo iti panagleppas ti tiempo ti pannakaisinana. Masapul a maipan isuna iti pagserkan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Masapul nga idatagna ti datonna kenni Yahweh. Masapul nga idatagna a kas daton a mapuoran ti urbon a kalakian a karnero a maysa ti tawenna ken awan ti mulitna. Masapul a mangiyeg isuna iti maysa tawenna a kabaian a karnero a kas daton gapu iti basol ken awan ti mulitna. Masapul a mangiyeg isuna iti kalakian a karnero a kas daton a pakikapia nga awan mulitna. ");
INSERT INTO iloulb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Masapul pay a mangiyeg isuna iti sangabasket a tinapay nga awan lebadurana, napuskol a tinapay a naaramid iti napino nga arina a nailaok iti lana, kadagiti naingpis a tinapay nga awan lebadurana ken napulagidan iti lana, karaman iti datonda a bukbukel ken mainom. ");
INSERT INTO iloulb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Masapul nga idatag ti padi dagitoy iti sangoanan ni Yahweh. Masapul nga idatagna ti datonna a gapu iti basol ken daton a maipuor. ");
INSERT INTO iloulb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Maikuyog iti sangabasket a tinapay nga awan lebadurana, masapul nga idatagna ti kalakian a karnero a kas daton, ti daton a pakikapia kenni Yahweh. Masapul nga idatag met ti padi ti daton a bukbukel ken ti daton a mainom. ");
INSERT INTO iloulb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Masapul a kalboen ti Nazireo ti ulona a mangipakpakita ti pannakaisinana para iti Dios iti pagserkan ti tabernakulo. Masapul nga alaenna ti buok manipud iti ulona ket ipuorna daytoy iti sirok ti daton a pakikapia. ");
INSERT INTO iloulb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Masapul nga alaen ti padi ti nailambong nga abaga ti kalakian a karnero, maysa a napuskol a tinapay nga awan lebadurana manipud iti basket, ken maysa a naingpis a tinapay nga awan lebadurana. Masapul nga ikabilna dagitoy kadagiti ima ti Nazireo kalpasan makalbona ti ulona a mangipakpakita ti pannakaisina. ");
INSERT INTO iloulb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Masapul nga itag-ay dagitoy ti padi a kas daton iti sangoanan ni Yahweh ken idatagna dagitoy kenkuana. Nasantoan daytoy a taraon, nailasin para iti padi, agraman ti barukong ken luppo a naitag-ay. Kalpasan dayta, mabalinen nga uminom iti arak ti Nazireo. ");
INSERT INTO iloulb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Daytoy ti linteg para iti Nazireo nga agisapsapata iti datonna kenni Yahweh para iti pannakaisinana. Aniaman pay a mabalinna a maited, masapul a salimetmetanna dagiti pagrebbengan a sinapataanna, tapno masalimetmetan ti kari a naibaga babaen iti linteg para iti Nazireo.'” ");
INSERT INTO iloulb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Kasaritam ni Aaron ken dagiti annakna a lallaki. Ibagam, 'Masapul a bendisionanyo dagiti tattao iti Israel iti kastoy a wagas. Masapul nga ibagayo kadakuada, ");
INSERT INTO iloulb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Bendisionan ken saluadannaka koma ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Pagraniagen koma ni Yahweh ti silawna kenka, kumita kenka, ken paraburannaka. ");
INSERT INTO iloulb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Kumita koma ni Yahweh kenka nga addaan ti pabor ken ikkannnaka iti kapia.'” ");
INSERT INTO iloulb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Iti kastoy a wagas ti masapul a panangitedda ti naganko kadagiti tattao ti Israel. Ket bendissionakto ida.” ");
INSERT INTO iloulb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Iti aldaw a nalpas ni Moises ti tabernakulo, pinulotanna daytoy agraman dagiti amin nga alikamenna ken indatonna daytoy kenni Yahweh. Isu met laeng ti inaramidna iti altar ken kadagiti amin nga alikamenna daytoy. Pinulotanna ken indatonna dagitoy kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Iti dayta nga aldaw, nagidaton dagiti mangidadaulo iti Israel ken dagiti pangulo dagiti pamilia dagiti kapuonanda. Dagitoy a lallaki ti mangidadaulo kadagiti tribu. Isuda dagiti nagaywan iti panagbilang kadagiti lallaki iti sensus. ");
INSERT INTO iloulb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Impanda dagiti datonda iti sangoanan ni Yahweh. Nangiyegda ti innem a kariton a naabbongan ken 12 a baka. Nangiyegda ti maysa a lugan para iti tunggal dua a mangidadaulo ken nangiyeg iti saggaysa a baka ti tunggal mangidadaulo. Indatagda dagitoy a banbanag iti sangoanan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ket nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Awatem dagiti daton manipud kadakuada ket usarem dagiti daton para iti trabaho idiay tabernakulo. Itedmo dagiti daton kadagiti Levita, iti tunggal maysa a kas kasapulan ti trabahoda.” ");
INSERT INTO iloulb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Innala ni Moises dagiti kariton ken dagiti baka, ket intedna dagitoy kadagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Nangted ti dua a kariton ken uppat a baka kadagiti kaputotan ni Gerson, gapu ta isu ti kasapulan ti trabahoda. ");
INSERT INTO iloulb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Nangted ti uppat a kariton ken walo a baka kadagiti kaputotan ni Merari, iti panangaywan ni Itamar nga anak a lalaki ni Aaron a padi. Inaramidna daytoy gapu ta isu ti kasapulan ti trabahoda. ");
INSERT INTO iloulb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ngem awan kadagitoy a banbanag ti intedna kadagiti kaputotan ni Coat, agsipud ta ti trabahoda ket mainaig kadagiti banbanag a kukua ni Yahweh a masapul a baklayenda. ");
INSERT INTO iloulb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Indaton dagiti mangidadaulo dagiti adda kadakuada para ti pannakaidaton ti altar iti aldaw a pinulotan ni Moises ti altar. Indaton dagiti mangidadaulo dagiti datonda iti sangoanan ti altar. ");
INSERT INTO iloulb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kinuna ni Yahweh kenni Moises, “Masapul nga idaton ti tunggal mangidadaulo iti bukodna nga aldaw ti datonna para iti pannakaidaton ti altar.” ");
INSERT INTO iloulb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Iti umuna nga aldaw, nangidaton ni Naason nga anak a lalaki ni Aminadab, ti tribu ni Juda. ");
INSERT INTO iloulb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga ubing a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Naason nga anak ni Aminadab. ");
INSERT INTO iloulb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Iti maikadua nga aldaw, nangidaton ni Natanael nga anak a lalaki ni Suar, a mangidadaulo iti Isacar. ");
INSERT INTO iloulb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nangidaton isuna ti maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo iti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Nangted pay isuna iti maysa balitok a pinggan nga agdagsen iti 10 a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Natanael nga anak a lalaki ni Suar. ");
INSERT INTO iloulb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Iti maikatlo nga aldaw, nagidaton ni Eliab nga anak a lalaki ni Helon, a mangidadaulo kadagiti kaputotan ti Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Nangted isuna ti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Eliab nga anak a lalaki ni Helon. ");
INSERT INTO iloulb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Iti maikapat nga aldaw, nagidaton ni Elisur nga anak a lalaki ni Sedeur, a mangidadaulo kadagiti kaputotan ni Ruben. ");
INSERT INTO iloulb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Elisur nga anak a lalaki ni Sedeur. ");
INSERT INTO iloulb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Iti maikalima nga aldaw, nagidaton ni Salumiel nga anak a lalaki ni Zurisaddai, a mangidadaulo kadagiti kaputotan ni Simeon. ");
INSERT INTO iloulb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Salumiel nga anak a lalaki ni Zurisaddai. ");
INSERT INTO iloulb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Iti maikanem nga aldaw, nagidaton ni Eliasaf nga anak a lalaki ni Deuel, a mangidadaulo kadagiti kaputotan ni Gad. ");
INSERT INTO iloulb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Nangted isuna ti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Eliasaf nga anak a lalaki ni Deuel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Iti maikapito nga aldaw, nagidaton ni Elisama nga anak a lalaki ni Ammiud, a mangidadaulo kadagiti kaputotan ni Efraim. ");
INSERT INTO iloulb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Elisama nga anak a lalaki ni Ammiud. ");
INSERT INTO iloulb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Iti maikawalo nga aldaw, nagidaton ni Gamaliel nga anak a lalaki ni Pedasur, a mangidadaulo iti kaputotan ni Manases. ");
INSERT INTO iloulb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Gamaliel nga anak a lalaki ni Pedasur. ");
INSERT INTO iloulb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Iti maikasiam nga aldaw, nagidaton ni Abidan nga anak ni Gedeon, a mangidadaulo kadagiti kaputotan ni Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Abidan nga anak a lalaki ni Gedeon. ");
INSERT INTO iloulb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Iti maikasangapulo nga aldaw, nagidaton ni Ahiezer nga anak a lalaki ni Ammisaddai, a mangidadaulo kadagiti kaputotan ni Dan. ");
INSERT INTO iloulb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Ahiezer nga anak a lalaki ni Ammisaddai. ");
INSERT INTO iloulb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Iti maikasangapulo ket maysa nga aldaw, nagidaton ni Pagiel nga anak a lalaki ni Ocran, a mangidadaulo kadagiti kaputotan ni Aser. ");
INSERT INTO iloulb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Pagiel nga anak a lalaki ni Ocran. ");
INSERT INTO iloulb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Iti maikasangapulo ket dua nga aldaw, nagidaton ni Ahira nga anak a lalaki ni Enan, a mangidadaulo kadagiti kaputotan ni Naftali. ");
INSERT INTO iloulb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ti datonna ket maysa a pinggan a pirak nga agdagsen iti 130 a siklo ken maysa a pirak a malukong nga agdagsen iti 70 a siklo, babaen iti naituyang a pagtimbangan ti siklo ti santuario. Agpada a napno dagitoy a banbanag iti napino nga arina a nalaokan iti lana a maipaay iti daton a bukbukel. ");
INSERT INTO iloulb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Nangted pay isuna iti maysa a balitok a pinggan nga agdagsen iti sangapulo a siklo, napno daytoy iti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Intedna a kas daton a maipuor ti maysa nga urbon a kalakian a baka, maysa a kalakian a karnero, ken maysa nga urbon a kalakian a karnero a maysa ti tawenna. ");
INSERT INTO iloulb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Nangted isuna iti maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Nangted isuna iti dua a baka, lima a kalakian a karnero, lima a kalakian a kalding, ken lima nga urbon a kalakian a karnero a saggaysa ti tawenda, a kas daton iti pannakikappia. Daytoy ti daton ni Ahira nga anak a lalaki ni Enan. ");
INSERT INTO iloulb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Indaton amin dagitoy dagiti mangidadaulo iti Israel iti aldaw a pinulotan ni Moises ti altar. Indatonda dagiti 12 a pirak a pingpinggan, 12 a pirak a mallukong ken 12 a balitok a pinggan. ");
INSERT INTO iloulb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Tunggal pirak a pinggan ket agdagsen iti 130 a siklo ken tunggal pirak a malukong ket agdagsen iti 70 a siklo. Agdagsen iti 2, 400 a siklo dagiti amin a pirak nga alikamen, babaen iti naituyang a pagtimbangan iti siklo ti santuario. ");
INSERT INTO iloulb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tunggal maysa kadagiti 12 a balitok a pinggan a napno iti insenso ket agdagsen ti 10 a siklo babaen iti naituyang a pagtimbangan iti siklo ti santuario. Agdagsen ti 120 a siklo dagiti amin a balitok a pinggan. ");
INSERT INTO iloulb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Indatonda a kas daton a maipuor iti 12 a kalakian nga urbon a baka, 12 a kalakian a karnero, ken 12 nga ubbing a kalakian a karnero a saggaysa ti tawenda. Intedda ti datonda a bukbukel. Intedda ti 12 a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Manipud kadagiti amin a tarakenda, nangtedda iti 24 a kalakian nga urbon a baka, 60 a kalakian a karnero, 60 a kalakian a kalding, ken 60 nga urbon a kalakian a karnero a saggaysa iti tawenda, a kas daton ti pannakikappia. Daytoy ti maipaay iti pannakaidaton ti altar, idi napulotan daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Idi napan ni Moises iti tabernakulo tapno makisarita kenni Yahweh, nangngegna ti timek ni Yahweh a makisarsarita kenkuana. Nagsao ni Yahweh kenkuana iti ngatoen ti akkob ti pakapawanan iti rabaw ti lakasa a pakakitaan ti pammaneknek ti tulag, manipud iti nagbaetan ti dua a kerubin. Nagsao ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kasaom ni Aaron. Ibagam kenkuana, 'Masapul a dagiti pito a pagsilawan ket lawaganda ti sangoanan iti kandelero no sindiam dagitoy.'” ");
INSERT INTO iloulb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Inaramid ni Aaron daytoy. Sinindianna dagiti pagsilawan iti kandelero a manglawag ti sangoanan daytoy, kas imbilin ni Yahweh kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Naaramid ti kandelero iti kastoy a wagas: impakita ni Yahweh ti pagtuladan iti daytoy kenni Moises: napitpit a balitok manipud iti puonna inggana iti tuktokna, nga addaan kadagiti napitpit a kopa a kasla sabsabong. ");
INSERT INTO iloulb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Alaem dagiti Levita manipud kadagiti tattao ti Israel ket dalusam ida. ");
INSERT INTO iloulb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Aramidem daytoy a kas panangdalus kadakuada: Iwarsim kadakuada ti danum a pangdalus. Pakuskosam kadakuada ti entero a bagida, labaanda dagiti pagan-anayda, ket iti kastoy a wagas madalusan ti bagbagida. ");
INSERT INTO iloulb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kalpasanna, pangalaem ida iti kalakian a baka ken daton a trigo a naaramid nga arina a nagamay iti lana. Pangalaem ida iti sabali a kalakian a baka a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Idatagmo dagiti Levita iti sangoanan iti tabernakulo, ken ummongem ti sibubukel a gimong dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Idatagmo dagiti Levita iti sangoanak, Siak ni Yahweh. Masapul nga ipatay dagiti tattao ti Israel dagiti im-imada kadagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Masapul nga idaton ni Aaron dagiti Levita iti sangoanak, idatagna ida a kasla nakatag-ayda ti nangato iti sangoananna, iti biang dagiti tattao ti Israel. Masapul nga aramidenna daytoy tapno mapagserbiandak dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Masapul nga ikabil dagiti Levita dagiti imada kadagiti ulo dagiti kalakian a baka. Masapul a mangidatonka iti maysa a kalakian a baka para iti daton gapu iti basol ken ti sabali a kalakian a baka para iti daton a maipuor a para kaniak, a pangabbong ti basol dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Idatagmo dagiti Levita iti imatang ni Aaron ken kadagiti annakna a lallaki, ken itag-aymo ida a kas daton kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Iti daytoy a wagas, masapul nga isinam dagiti Levita manipud kadagiti tattao ti Israel. Kukuakto dagiti Levita. ");
INSERT INTO iloulb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Kalpasan dayta, masapul a sumrek dagiti Levita nga agserbi iti uneg ti tabernakulo. Masapul a dalusam ida. Masapul nga itag-aymo ida kaniak a kas daton. ");
INSERT INTO iloulb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Aramidem daytoy, gapu ta kukuak laeng ida manipud kadagiti tattao iti Israel. Isuda ti mangsukat iti tunggal anak a lalaki a manglukat ti aanakan, dagiti inauna dagiti amin a kaputotan ti Israel. Innalak dagiti Levita para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kukuak amin nga inauna manipud kadagiti tattao iti Israel, dagiti tattao ken dagiti ay-ayup. Iti aldaw nga innalak dagiti bibiag dagiti inauna nga annak idiay daga ti Egipto, inlasinko ida para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Innalak dagiti Levita kadagiti tattao ti Israel imbes a dagiti amin nga inauna nga annak. ");
INSERT INTO iloulb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Intedko dagiti Levita a kas sagut kenni Aaron ken kadagiti annakna a lallaki. Innalak ida kadagiti tattao iti Israel a mangaramid ti trabaho dagiti tattao ti Israel iti uneg ti tabernakulo. Intedko ida a mangsubbot kadagiti basbasol dagiti tattao ti Israel tapno awan ti dididgra a mangdangran kadagiti tattao no umasidegda iti nasantoan a disso.” ");
INSERT INTO iloulb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Inaramid daytoy da Moises, Aaron ken ti sibubukel a gimong dagiti tattao iti Israel kadagiti Levita. Inaramidda amin nga imbilin ni Yahweh kenni Moises maipapan kadagiti Levita. Inaramid daytoy dagiti tattao iti Israel kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Dinalusan dagiti Levita dagiti bagbagida manipud iti basol babaen iti pananglabada kadagiti pagan-anayda. Indatag ida ni Aaron a kas daton kenni Yahweh ken inaramidna ti pannakaabbong a maipaay kadakuada, tapno madalusanna ida. ");
INSERT INTO iloulb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Kalpasan dayta, simrek dagiti Levita tapno agtrabahoda iti uneg ti tabernakulo iti imatang da Aaron ken dagiti annakna a lallaki. Sigun daytoy iti imbilin ni Yahweh kenni Moises maipanggep kadagiti Levita. Trinatoda amin dagiti Levita iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Nagsao manen ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Amin dagitoy ket para kadagiti Levita nga agtawen iti duapulo ket lima nga agpangato. Masapul a makitiponda kadagiti dadduma a kakaduada nga agserbi iti uneg iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Masapul a sumardengdan nga agserserbi iti kastoy a wagas iti tawen a lima pulo. Iti dayta a tawen, saandan a masapul nga agserbi pay. ");
INSERT INTO iloulb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Mabalinda a tulongan dagiti kakabsatda nga agtultuloy nga agtrabaho iti uneg iti tabernakulo, ngem saandan a rumbeng nga agserbi pay. Masapul nga idalanmo dagiti Levita kadagitoy amin a banbanag.” ");
INSERT INTO iloulb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Iti umuna a bulan iti maikadua a tawen kalpasan ti iruruarda manipud iti daga ti Egipto, nagsao ni Yahweh kenni Moises idiay let-ang iti Sinai, “Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ibagam a rambakan dagiti tattao ti Israel ti Fiesta ti Ilalabas iti naikeddeng a tiempona iti tawen. ");
INSERT INTO iloulb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Iti maika-sangapulo ket uppat nga aldaw iti daytoy a bulan, iti rabii, masapul a rambakanyo ti Fiesta ti Ilalabas iti naikeddeng a tiempona iti tawen. Masapul a rambakanyo daytoy, surotenyo amin dagiti pagalagadan, ken tungpalenyo amin dagiti paglintegan a mainaig iti daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Isu nga imbaga ni Moises kadagiti tattao ti Israel a masapul a rambakanda ti Fiesta ti Ilalabas. ");
INSERT INTO iloulb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Isu a rinambakanda ti Fiesta ti Ilalabas iti umuna a bulan, iti maikasangapulo ket uppat nga aldaw ti bulan, iti rabii, iti let-ang iti Sinai. Tinungpal dagiti tattao ti Israel dagiti amin nga imbilin ni Yahweh kenni Moises nga aramidenda. ");
INSERT INTO iloulb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Adda dagiti lallaki a narugit gapu iti bangkay ti maysa a tao. Saanda a mabalin a rambakan ti Fiesta ti Ilalabas iti dayta nga aldaw. Napanda iti sangoanan ni Moises ken ni Aaron iti dayta met laeng nga aldaw. ");
INSERT INTO iloulb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Kinuna dagitoy a lallaki kenni Moises, “Narugitkami gapu iti bangkay ti maysa a tao. Apay a pawilandakami nga agidaton kenni Yahweh iti naikeddeng a tiempo iti tawen a kadua dagiti tattao iti Israel?” Kinuna ni Moises kadakuada, ");
INSERT INTO iloulb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","“Urayendak a dumngeg iti ibilin ni Yahweh maipanggep kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Agsaoka kadagiti tattao ti Israel. Ibagam, 'No siasinoman kadakayo wenno kadagiti kaputotanyo ti narugit gapu iti bangkay, wenno agdaldalliasat iti nabayag, mabalinna latta a rambakan ti Fiesta ti Ilalabas para kenni Yahweh.' ");
INSERT INTO iloulb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Masapul a rambakanda ti Fiesta ti Ilalabas iti maikadua a bulan iti rabii iti maikasangapulo ket uppat nga aldaw. Masapul a kanenda daytoy agraman ti tinapay nga awan ti lebadurana ken kadagiti napait a makaagas a bulbulong. ");
INSERT INTO iloulb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Masapul nga awan ti ibatida kadagitoy inggana ti agsapa, wenno saan a rumbeng a mangtukkolda ti tulang dagiti ay-ayup. Masapul a tungpalenda dagiti amin a pagalagadan ti Fiesta ti Ilalabas. ");
INSERT INTO iloulb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ngem siasinoman a nadalus a tao ken saan a nagdaliasat, ngem saan a nakapagrambak iti Ilalabas, masapul a mailaksid dayta a tao kadagiti tattaona gapu ta saanna nga indaton ti sapsapulen ni Yahweh iti naikeddeng a tiempo iti tawen. Masapul a baklayen dayta a tao ti basolna. ");
INSERT INTO iloulb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","No makipagnanaed iti maysa a ganggannaet kadakayo ket ramrambakanna ti Fiesta ti Ilalabas para iti dayaw ni Yahweh, masapul a rambakanna daytoy ken aramidenna dagiti amin nga ibilbilinna, ar-aramidenna dagiti pagalagadan iti Fiesta ti Ilalabas, ken agtungtungpal kadagiti linteg para iti daytoy. Masapul nga addaankayo iti agpadpada a linteg para iti gangannaet ken para kadagiti amin a naiyanak iti daga.” ");
INSERT INTO iloulb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Iti aldaw a naibangon ti tabenakulo, inabbongan ti ulep ti tabernakulo, ti tolda ti pammaneknek iti tulag. Iti rabii, adda ti ulep iti ngatoen ti tabernakulo. Nagparang daytoy a kasla apoy inggana iti agsapa. ");
INSERT INTO iloulb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nagtuloy daytoy iti kasta a wagas. Inabbongan ti ulep ti tabernakulo ken nagparang a kasla apuy iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","No nagpangato ti ulep manipud iti ngatoen ti tolda, masapul nga agrubbuat dagiti tattao iti Israel iti panagdaliasatda. Sadinoman iti pagsardengan ti ulep, agkampo dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","No ibilin ni Yahweh, agdaliasat dagiti tattao ti Israel, ken no ibilinna, agkampoda. Kabayatan a nakasardeng ti ulep iti ngatoen ti tabernakulo, agtalinaedda iti kampoda. ");
INSERT INTO iloulb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","No nagtalinaed ti ulep iti ngatoen ti tabernakulo iti adu nga aldaw, ket rumbeng a tungpalen dagiti tattao iti Israel dagiti bilbilin ni Yahweh ken saanda nga agdaliasat. ");
INSERT INTO iloulb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","No dadduma, agtalinaed ti ulep iti sumagmamano nga aldaw iti ngatoen iti tabernakulo. Iti kasta, tungpalenda ti bilin ni Yahweh — agkampoda ket kalpasanna agdaliasatda manen no ibilinna. ");
INSERT INTO iloulb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","No dadduma, adda ti ulep iti kampo manipud iti rabii agingga iti agsapa. No ngimmato ti ulep iti agsapa, agdaliasatda. No nagtuloy daytoy iti maysa nga aldaw ken maysa a rabii, agdaliasatda laeng no ngimmaton ti ulep. ");
INSERT INTO iloulb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Uray agtalinaed ti ulep iti ngatoen ti tabernakulo iti dua nga aldaw, maysa a bulan, wenno makatawen, ngem inggana nga adda daytoy sadiay, agtalinaed dagiti tattao iti Israel iti kampoda ket saanda nga agdaliasat. Ngem no nagpangaton ti ulep, agrubuatdan iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Agkampoda segun iti bilin ni Yahweh, ken agdaliasatda no ibilinna. Tinungpalda ti inted ni Yahweh a bilinna babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Mangaramidka iti dua a trumpeta a pirak. Pitpitem ti pirak a mangaramid kadagitoy. Masapul nga aramatenyo dagiti trumpeta a pangayab kadagiti tattao a sangsangkamaysa ken pangayab kadagiti tattao a mangiyakar kadagiti kampoda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Masapul a puyotan dagiti papadi dagiti trumpeta a mangayab kadagiti amin a tattao a sangsangkamaysa iti sangoanam iti pagserkan iti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","No maysa laeng a trumpeta ti puyotan dagiti papadi, masapul nga aguummong dagiti mangidadaulo ken dagiti panguloen dagiti puli ti Israel ti ayanmo. ");
INSERT INTO iloulb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","No agpuyotka ti napigsa a pagilasinan, masapul a rugian dagiti agkamkampo iti daya iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","No agpuyotka iti napigsa a pagilasinan iti maikadua a daras, masapul a mangrugi nga agdaliasat dagiti agkamkampo iti abagatan. Masapul nga agpuyotda iti napigsa a pagilasinan para kadagiti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","No aguummongen dagiti tattao, puyotanyo dagiti trumpeta, ngem saan a napigsa. ");
INSERT INTO iloulb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Masapul a puyotan dagiti annak a lallaki ni Aaron ken dagiti papadi dagiti trumpeta. Agnanayon daytoy a pagalagadanyo ti entero a kaputotan dagiti tattaoyo. ");
INSERT INTO iloulb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","No makigubatkayo iti dagayo a maibusor kadagiti mangidaddadanes kadakayo, ket masapul nga agpaunikayo iti pangpadaras babaen kadagiti trumpeta. Siak ni Yahweh a Diosyo ti manglagip ken mangisalakan kadakayo kadagiti kabusoryo. ");
INSERT INTO iloulb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Uray met kadagiti tiempo dagiti panagrambak, kadagiti kadawyan a fiestayo ken kadagiti rugrugi dagiti bulbulan, masapul a puyotanyo dagiti trumpeta a kas pammadayaw kadagiti datonyo a maipuor ken kadagiti datonyo para iti pannakikapia. Dagitoy dagiti mangipalagip kadakayo kaniak, a Diosyo. Siak ni Yahweh, a Diosyo.” ");
INSERT INTO iloulb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Iti maikadua a tawen, iti maikadua a bulan, iti maikaduapulo nga aldaw ti bulan, naipangato ti ulep manipud iti tabernakulo iti pammaneknek iti tulag. ");
INSERT INTO iloulb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Nagdaliasat ngarud dagiti tattao ti Israel manipud iti let-ang ti Sinai. Simmardeng ti ulep iti let-ang ti Paran. ");
INSERT INTO iloulb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Rinugianda ti umuna a panagdaliasatda, a sursurotenda ti bilin ni Yahweh nga intedna babaen kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Immuna a rimmuar ti kampo nga adda iti babaen ti wagayway ti kaputotan ni Juda, saggaysa a rimmuar dagiti armadada. Indauloan ni Naason nga anak a lalaki ni Aminadab ti armada ni Juda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Indauloan ni Netanel nga anak a lalaki ni Suar ti armada ti tribu ti kaputotan ni Issacar. ");
INSERT INTO iloulb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Indauloan ni Eliab nga anak a lalaki ni Helon ti armada ti tribu dagiti kaputotan ni Zabulon. ");
INSERT INTO iloulb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Imbaba dagiti kaputotan ni Gerson ken Merari nga agay-aywan iti tabernakulo ti tabernakulo kalpasanna, nagrubbuatda iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Simmaruno a nagrubbuat iti panagdaliasat dagiti armada nga adda iti babaen ti wagayway ti kampo ni Ruben. Indauloan ni Elizur nga anak ni Sedeur ti armada ni Ruben. ");
INSERT INTO iloulb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Indauloan ni Selumiel nga anak a lalaki ni Zurisadai ti armada dagiti kaputotan ni Simeon. ");
INSERT INTO iloulb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Indauloan ni Eliasaf nga anak a lalaki ni Deuel ti armada ti tribu dagiti kaputotan ni Gad. ");
INSERT INTO iloulb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Nagrubbuat dagiti Coatita. Inawitda dagiti nasagradoan nga al-alikamen. Bangonen dagiti dadduma ti tabernakulo sakbay a dimteng dagiti Coatita iti sumaruno a kampoanda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Simmaruno a nagrubbuat dagiti armada nga adda iti babaen iti wagayway dagiti kaputotan ni Efraim. Indauloan ni Elisama nga anak a lalaki ni Amiud ti armada ni Efraim. ");
INSERT INTO iloulb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Indauloan ni Gamaliel nga anak a lalaki ni Pedasur ti armada ti tribu dagiti kaputotan ni Manases. ");
INSERT INTO iloulb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Indauloan ni Abidan nga anak a lalaki ni Gideoni ti armada ti tribu dagiti kaputotan ni Benjamin. ");
INSERT INTO iloulb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Naudi a nagrubbuat dagiti armada a nagkampo iti babaen iti wagayway dagiti kaputotan ni Dan. Indauloan ni Ahieser nga anak a lalaki ni Amisadai ti armada ni Dan. ");
INSERT INTO iloulb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Indauloan ni Pagiel nga anak a lalaki ni Okran ti armada ti tribu dagiti kaputotan ni Aser. ");
INSERT INTO iloulb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Indauloan ni Ahira nga anak a lalaki ni Enan ti armada ti tribu dagiti kaputotan ni Neftali. ");
INSERT INTO iloulb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Kastoy ti wagas ti panagrubbuat dagiti armada dagiti tattao iti Israel iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Nagsao ni Moises kenni Hobab nga anak a lalaki ni Reuel a Midianita. Ni Reuel ti ama ti asawa ni Moises. Nagsao ni Moises kenni Hobab ket kinunana, “Agdaliasatkami iti lugar nga inkari ni Yahweh. Kinuna ni Yahweh, 'Itedkonto daytoy kadakayo.' Sumurotka kadakami ket tratoendaka a nasayaat. Inkari ni Yahweh nga agaramid iti nasayaat para iti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ngem kinuna ni Hobab kenni Moises, “Saanak a sumurot kadakayo. Mapanak iti bukodko a daga ken kadagiti bukodko a tattao.” ");
INSERT INTO iloulb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ket simmungbat ni Moises, “Pangaasim ta saannakami a panawan. Ammom no kasano ti agkampo idiay let-ang. Masapul nga iwanwannakami. ");
INSERT INTO iloulb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","No kumyogka kadakami, aramidenminto met kenka iti nasayaat a kas iti ar-aramiden ni Yahweh kadakami.” ");
INSERT INTO iloulb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nagdaliasatda iti tallo nga aldaw manipud iti bantay ni Yahweh. Immuna kadakuada iti tallo nga aldaw ti lakasa ti tulag ni Yahweh tapno mangbiruk iti disso a paginanaanda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Adda iti ngatoenda ti ulep ni Yahweh iti aldaw kabayatan iti panagdaliasatda. ");
INSERT INTO iloulb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","No mairubbuat ti lakasa ti tulag, kunaen ni Moises, “Bumangonka Yahweh. Warawaraem dagiti kabusormo. Paadaywem dagiti gumurgura kenka.” ");
INSERT INTO iloulb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","No sumardeng ti lakasa ti tulag, kunaen ni Moises, “Agsublika Yahweh, kadagiti adu a rinibribu iti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ita, nagreklamo dagiti tattao maipapan kadagiti pakarikutanda bayat nga agdengdengngeg ni Yahweh. Nangngeg ni Yahweh dagiti tattao ket nakaunget isuna. Pinuoran ida ti apuy a nagtaud kenni Yahweh ket inuramna ti dadduma a kampo agingga kadagiti pungtona. ");
INSERT INTO iloulb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ket immawag dagiti tattao kenni Moises, isu a nagkararag ni Moises kenni Yahweh ket simmardeng ti apuy. ");
INSERT INTO iloulb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Napanaganan dayta a lugar iti Tabera gapu ta inuram ida ti apuy ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nangrugi a nakikampo dagiti sumagmamano a ganggannaet a tattao kadagiti kaputotan ni Israel. Kayatda ti mangan kadagiti nasaysayaat a taraon. Ket nagrugi a nagladingit dagiti tattao ti Israel ket kinunada, “Siasino ti mangted kadakami iti karne a kanenmi? ");
INSERT INTO iloulb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Malaglagipmi dagiti lames a kinkinanmi nga awan bayadna idiay Egipto, dagiti pipino, dagiti sandia, dagiti sibuyas, dagiti lasona ken dagiti bawang. ");
INSERT INTO iloulb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ita, agkakapsutkami. Awan makitami a makan no di laeng mana.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ti mana ket kasla bukel ti kulantro. Kasla puraw a dumuyaw ti maris daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Nagpagnapagna dagiti tattao iti aglawlaw ket inurnongda dagitoy. Ginilingda dagitoy kadagiti paggilingan, binayoda kadagiti alsong, inlutoda kadagiti banga sada pinagbalin daytoy a bibingka. Kasla kaar-aramid a lana ti olibo ti raman daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tunggal agtinnag ti linnaaw iti kampo iti rabii, matnag met dagiti mana. ");
INSERT INTO iloulb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Nangngeg ni Moises nga agsangsangit dagiti tattao kadagiti pamiliada, ken adda dagiti tattao iti pagserkan iti toldana. Nakaunget ni Yahweh iti kasta unay, ken iti panagkita ni Moises ket saan a rumbeng ti panagreklamoda. ");
INSERT INTO iloulb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Kinuna ni Moises kenni Yahweh, “Apay a trinatom ti adipenmo iti saan a nasayaat? Apay a saanka a maay-ayo kaniak? Ipabpabaklaymo kaniak dagiti awit dagitoy amin a tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Siak kadi ti nangisikog kadagitoy amin a tattao? Siak kadi ti nangipasngay kadakuada tapno rumbeng nga ibagam kaniak nga, 'Ubbaem ida a kas iti panagubba ti ama iti anakna?' Rumbeng kadi a baklayek ida nga ipan iti daga nga inkarim kadagiti kapuonanda nga itedmo kadakuada? ");
INSERT INTO iloulb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Sadino ti pakasarakak iti karne nga itedko kadagitoy a tattao? Agsangsangitda iti sangoanak ken ibagbagada nga, 'Ikkannakami iti karne a kanenmi.' ");
INSERT INTO iloulb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Saanko a kabaelan a baklayen nga agmaymaysa dagitoy a tattao. Aduda unay para kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Agsipud ta tatratoenak iti kastoy a wagas, patayennakon ita, no naimbagka kaniak ken ikkatem ti rigrigatko.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Kinuna ni Yahweh kenni Moises, “Mangiyegka kaniak iti pitopulo a panglakayen ti Israel. Siguradoem a panglakayenda, ken opisyales ida dagiti tattao. Ipanmo ida iti tabernakulo tapno makipagtakderda kenka sadiay. ");
INSERT INTO iloulb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Bumabaak ket makisaritaak kenka sadiay. Mangalaak iti dadduma nga Espiritu nga adda kenka ket ikabilko kadakuada. Makipagbaklayda kenka iti dadagsen dagiti tattao. Saanton a masapul a sika laeng ti agmaymaysa a mangbaklay kadagitoy. ");
INSERT INTO iloulb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ibagam kadagiti tattao, 'Idatonyo dagiti bagbagiyo kenni Yahweh para inton bigat. Sigurado a mangankayonto iti karne, ta nagsangitkayo iti panagdengngeg ni Yahweh. Kinunayo, “Siasino ti mangted kadakami iti karne a kanenmi? Nasayaat para kadakami idiay Egipto.” Isu nga ikkannakayo ni Yahweh iti karne ket kanenyo daytoy. ");
INSERT INTO iloulb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Saankayo a mangan iti karne, iti maysa laeng nga aldaw, dua nga aldaw, lima nga aldaw, sangapulo nga aldaw wenno duapulo nga aldaw, ");
INSERT INTO iloulb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ngem mangankayo iti karne iti makabulan agingga a rummuar dagitoy kadagiti agongyo. Maumakayo iti daytoy gapu ta linaksidyo ni Yahweh, nga adda kadakayo. Nagsangitkayo iti sangoananna. Kinunayo, “Apay a pinanawanmi ti Egipto?''''' ");
INSERT INTO iloulb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ket kinuna ni Moises, “Kaduak dagiti 600, 000 a tattao, ket kinunam, 'ikkak ida iti karne a kanenda iti makabulan.' ");
INSERT INTO iloulb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Mangpataykami kadi kadagiti arban ken pangen a mangpennek kadakuada?” Tiliwenmi kadi dagiti amin a lames iti baybay a mangpennek kadakuada?” ");
INSERT INTO iloulb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Kinuna ni Yahweh kenni Moises, “Ababa kadi ti imak? Makitam ita no pudno wenno saan dagiti ibagbagak.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Rimmuar ni Moises ket imbagana kadagiti tattao dagiti sasao ni Yahweh. Inummongna dagiti pitopulo a panglakayen dagiti tattao ket pinatakderna ida iti aglawlaw ti tolda. ");
INSERT INTO iloulb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Bimmaba ni Yahweh iti ulep ket kinasaona ni Moises. Innala ni Yahweh ti dadduma nga Espiritu nga adda kenni Moises ket inyalisna dagitoy kadagiti pitopulo a panglakayen. Idi simrek ti Espiritu kadakuada, nagipadtoda, ngem iti dayta laeng a gundaway ken saanen a naulit. ");
INSERT INTO iloulb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Dua a lallaki ti nagtalinaed iti kampo, isuda Eldad ken Medad. Nagtaeng met kadakuada ti Espiritu. Naisurat dagiti naganda iti listaan, ngem saanda a rimmuar iti tolda. Nupay kasta, nagipadtoda iti uneg ti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Maysa a bumarito ti nagtaray iti kampo ket imbagana kenni Moises, “Agipadpadto da Eldad ken Medad iti uneg ti kampo.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ni Josue nga anak a lalaki ni Nun, maysa a katulongan ni Moises, maysa kadagiti tattao a pinilina, kinunana kenni Moises, “Apok a Moises, pasardengem ida.” ");
INSERT INTO iloulb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Kinuna ni Moises kenkuana, “Agimonka kadi para kaniak? Amin koma a tattao ni Yahweh ket propeta ken ikabilna koma ti Espirituna kadakuada amin!” ");
INSERT INTO iloulb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ket nagsubli ni Moises ken dagiti panglakayen ti Israel iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ket adda angin nga immay manipud kenni Yahweh ket nangiyeg iti pugo manipud iti baybay. Natinnagda iti asideg ti kampo, agarup maysa aldaw ti panagdaliasat iti maysa a bangir ken agarup maysa nga aldaw a panagdaliasat iti sabali a bangir. Pinalikmutan dagiti pugo ti kampo ket agarup dua a kubiko a kangatoda manipud iti daga. ");
INSERT INTO iloulb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nagmalmalem, nagpatpatnag a nagtiltiliw dagiti tattao iti pugo agingga iti simmaruno nga aldaw. Awan uray maysa a nakaurnong iti nabababa ngem sangapulo nga omer ti pugo. Biningayda dagiti pugo iti entero a kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kabayatan a kankanenda pay laeng dagiti karne nga adda iti nagbaetan dagiti ngipenda, kabayatan a ngalngalngalenda dagitoy, nakaunget ni Yahweh kadakuada. Dinarupna dagiti tattao babaen iti nakaro unay a sakit. ");
INSERT INTO iloulb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Napanaganan dayta a lugar iti Kibrot Hattava, gapu ta inkalida idiay dagiti tattao a nagtarigagay a mangan iti karne. ");
INSERT INTO iloulb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Manipud Kibrot Hattava nagdaliasat dagiti tattao idiay Hazerot, sadiay ti nagnaedanda. ");
INSERT INTO iloulb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Kalpasanna, nagsao da Miriam ken Aaron maibusor kenni Moises gapu iti maysa a Cusita nga inasawana. ");
INSERT INTO iloulb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kinunada, “Ni Moises laeng kadi ti kinasao ni Yahweh? Saan kadi a nakisao met isuna kadata?” Nangngeg ita ni Yahweh ti imbagada. ");
INSERT INTO iloulb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ita, ti tao a ni Moises ket napakumbaba unay, napakpakumbaba ngem iti siasinoman iti daga. ");
INSERT INTO iloulb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Kinasao a dagus ni Yahweh da Moises, Aaron ken Miriam: “Rummuarkayo, dakayo a tallo, inkayo iti tabernakulo.” Isu a rimmuarda a tallo. ");
INSERT INTO iloulb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ket bimmaba ni Yahweh babaen iti kasla adigi ti ulep. Nagtakder isuna iti pagserkan ti tolda ket inayabanna da Aaron ken Miriam. Nagpasango dagiti dua. ");
INSERT INTO iloulb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kinuna ni Yahweh, “Ita denggenyo dagiti sasaok. No adda kadakayo ti propetak, agparangak kenkuana babaen kadagiti sirmata ken makisaritaak kenkuana babaen iti tagtagainep. ");
INSERT INTO iloulb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Saan a kasta ti adipenko a ni Moises. Napudno isuna iti entero a balayko. ");
INSERT INTO iloulb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Makisarsaritaak kenkuana a sangon-sango, saan nga iti sirmata wenno burburtia. Makitkitana ti langak. Isu nga apay a saankayo a mabuteng nga agsao iti maibusor iti adipenko, maibusor kenni Moises?” ");
INSERT INTO iloulb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nakaunget unay ni Yahweh kadakuada, ken kalpasanna, pinanawanna ida. ");
INSERT INTO iloulb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nagpangato ti ulep manipud iti ngatoen ti tolda, ket dagus a nagketong ni Miriam—pimmurpuraw isuna a kas iti niebe. Idi simmango ni Aaron kenni Miriam, nakitana nga adda ketong ni Miriam. ");
INSERT INTO iloulb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kinuna ni Aaron kenni Moises, “O, apok, pangaasim ta saanmo nga ibilang daytoy a basol a maibusor kadakami. Minamaag dagiti imbagbagami ket nakabasolkami. ");
INSERT INTO iloulb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Pangaasim ta saanmo nga ipalubos nga agbalin isuna a kasla natay a maladaga a narunot ti kagudua ti bagina idi rimmuar iti aanakan ti inana.” ");
INSERT INTO iloulb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Isu nga immawag ni Moises kenni Yahweh. Kinunana, “Pangaasim ta paimbagem isuna, O Dios pangaasim.” ");
INSERT INTO iloulb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Kinuna ni Yahweh kenni Moises, “No tinupraan ti amana ti rupana, maibabain isuna iti pito nga aldaw. Iserraanyo isuna iti ruar ti kampo iti pito nga aldaw. Kalpasan dayta, pastrekenyo manen isuna.” ");
INSERT INTO iloulb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Isu a naserraan ni Miriam iti ruar ti kampo iti las-ud ti pito nga aldaw. Saan a nagdaliasat dagiti tattao agingga a nagsubli ni Miriam iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Kalpasan dayta, nagdaliasat dagiti tattao manipud Hazerot ket nagkampoda iti let-ang ti Paran. ");
INSERT INTO iloulb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ket nagsao ni Yahweh Kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Mangibaonka kadagiti lallaki a mangsukimat iti daga ti Canaan, nga intedko kadagiti tattao ti Israel. Mangibaonka iti maysa tao manipud iti tunggal tribu dagiti kapuonanda. Masapul a ti tunggal lalaki ket panguloen iti tribuna.” ");
INSERT INTO iloulb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Imbaon ida ni Moises manipud iti let-ang ti Paran, tapno agtulnogda iti bilin ni Yahweh. Aminda ket panguloen dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Dagitoy dagiti naganda: manipud iti tribu ni Ruben, ni Sammua nga anak a lalaki ni Zakkur. ");
INSERT INTO iloulb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Manipud iti tribu ni Simeon, ni Safat nga anak a lalaki ni Hori. ");
INSERT INTO iloulb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Manipud iti tribu ni Juda, ni Caleb nga anak a lalaki ni Jefone. ");
INSERT INTO iloulb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Manipud iti tribu ni Issacar, ni Igal nga anak a lalaki ni Jose. ");
INSERT INTO iloulb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Manipud iti tribu ni Efraim, ni Oseas nga anak a lalaki ni Nun. ");
INSERT INTO iloulb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Manipud iti tribu ni Benjamin, ni Palti nga anak a lalaki ni Rafu. ");
INSERT INTO iloulb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Manipud iti tribu ni Zabulon, ni Gaddiel nga anak a lalaki ni Sodi. ");
INSERT INTO iloulb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manipud kadagiti kaputotan ni Jose, dagiti naganda, manipud iti tribu ni Manases, ni Gaddi nga anak a lalaki ni Susi. ");
INSERT INTO iloulb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Manipud iti tribu ni Dan, ni Ammiel nga anak a lalaki ni Gemalli. ");
INSERT INTO iloulb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Manipud iti tribu ni Aser, ni Setur nga anak a lalaki ni Micael. ");
INSERT INTO iloulb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Manipud iti tribu ni Neftali, ni Nabi nga anak a lalaki ni Vopsi. ");
INSERT INTO iloulb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Manipud iti tribu ni Gad, ni Geuel nga anak a lalaki ni Maki. ");
INSERT INTO iloulb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Dagitoy dagiti nagan dagiti lallaki nga imbaon ni Moises a mangsukimat iti daga. Inawagan ni Moises iti Josue ni Oseas nga anak a lalaki ni Nun. ");
INSERT INTO iloulb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Imbaon ida ni Moises a mangsukimat iti daga ti Canaan. Kinunana kadakuada, “Magnakayo manipud Negeb ken sumang-atkayo iti katurturodan a pagilian. ");
INSERT INTO iloulb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Sukimatenyo ti daga tapno makitayo ti langana. Paliiwenyo dagiti tattao nga agnanaed sadiay, no napigsa wenno nakapuyda, ken no bassit wenno aduda. ");
INSERT INTO iloulb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kitaenyo ti langa ti daga a pagnanaedanda. Nasayaat kadi daytoy wenno saan? Ania dagiti siudad sadiay? Kasla da kadi kampo, wenno nabilegda kadi a siudad? ");
INSERT INTO iloulb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kitaenyo no ti langa ti daga, no nasayaat daytoy a pagtuboan dagiti mula wenno saan, ken no adda kaykayo idiay wenno awan. Tumuredkayo ket mangalakayo kadagiti bunga ti mula ti daga.” Ita ti tiempo iti umuna a bunga dagiti panagluom dagiti ubas. ");
INSERT INTO iloulb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Napan ngarud dagiti lallaki ket sinukimatda ti daga manipud iti let-ang ti Sin agingga iti Rehob, iti asideg ti Lebo Hamat. ");
INSERT INTO iloulb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Simmang-atda manipud Negeb ket nakadanonda idiay Hebron. Adda sadiay da Ahiman, Sesai ken Talmai dagiti puli a nagtaud kenni Anak. Ita, naipatakder ti Hebron iti las-ud ti pito a tawen sakbay iti Zoan idiay Egipto. ");
INSERT INTO iloulb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Idi nakadanonda idiay tanap ti Escol, nangputedda iti sanga nga addaan iti raay dagiti ubas. Iniyassiwda daytoy iti sarukod iti nagbaetan dagiti dua a tao iti bunggoyda. Nangalada pay kadagiti granada ken igos. ");
INSERT INTO iloulb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Napanaganan dayta a lugar iti tanap ti Escol, gapu kadagiti raay ti ubas a pinuted sadiay dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kalpasan iti uppat a pulo nga aldaw, nagsublida manipud iti panangsukimat iti daga. ");
INSERT INTO iloulb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nagsublida kada Moises, Aaron, ken kadagiti amin a tattao ti Israel nga adda iti let-ang ti Paran, idiay Kades. Nangipadamagda kadakuada ken iti amin a tattao iti bunggoy ti Israel, ken impakitada kadakuada dagiti bunga manipud iti daga. ");
INSERT INTO iloulb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kinunada kenni Moises, “Nadanonmi ti daga a nangibaonam kadakami. Pudno unay nga agay-ayus daytoy iti gatas ken diro. Adtoy ti sumagmamano a bunga manipud iti lugar. ");
INSERT INTO iloulb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nupay kasta, napipigsa dagiti tattao nga agar-aramid kadagiti balayda idiay. Nabakudan ken nalawa unay dagiti siudad. Nakitami pay sadiay dagiti kaputotan ni Anak. ");
INSERT INTO iloulb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Agnanaed dagiti Amalekita idiay Negeb. Adda dagiti pagtaengan dagiti Heteo, Jebuseo, ken Amoreo iti katurturodan. Agnanaed dagiti Cananeo iti igid ti baybay ken iti igid ti karayan Jordan.” ");
INSERT INTO iloulb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalpasanna, pinadas nga allukoyen ni Caleb dagiti tattao a naummong iti aglawlaw ni Moises. Kinunana, “Darrupentayo a maminpinsan ket alaentayo daytoy, gapu ta kabaelantayo unay a parmeken daytoy.” ");
INSERT INTO iloulb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ngem kinuna dagiti dadduma a lallaki a napan a kaduana, “Saantayo kabaelan a darupen dagiti tattao gapu ta napigpigsada ngem datayo.” ");
INSERT INTO iloulb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Isu nga inwarasda ti makapaupay a damag kadagiti tattao ti Israel maipanggep iti daga a sinukimatda. Kinunada, “Ti daga a pinaliiwmi ket daga a mangmangan kadagiti agnanaed iti daytoy. Nagtatayag dagiti amin a tattao a nakitami sadiay. ");
INSERT INTO iloulb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nakakitakami sadiay kadagiti higante, dagiti kaputotan ni Anak a nagtaud kadagiti higante. Iti panangkitami kasla kami la dudon a maiasping kadakuada, ken kastoykami met iti imatangda.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Iti dayta a rabii, nagsangit iti napigsa dagiti amin a tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Inuyaw dagiti amin a tattao ti Israel da Moises ken Aaron. Kinuna dagiti tattao kadakuada, “Nataykami la koman idiay daga iti Egipto, wenno iti daytoy a let-ang! ");
INSERT INTO iloulb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Apay nga impannakami ni Yahweh iti daytoy a daga a matay babaen iti kampilan? Agbalin a biktima dagiti assawa ken dagiti annakmi. Saan kadi a nasaysayaat nga agsublikami idiay Egipto?” ");
INSERT INTO iloulb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kinunada iti tunggal maysa, “Mangpilitayo iti sabali a pangulo, ket agsublitayo idiay Egipto.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ket nagpakleb da Moises ken Aaron iti sangoanan dagiti amin a gimong dagiti tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ni Josue nga anak a lalaki ni Nun ken ni Caleb nga anak a lalaki ni Jefone, a dadduma kadagiti naibaon a mangsukimat iti daga, ket rinay-abda dagiti badoda. ");
INSERT INTO iloulb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nagsaoda kadagiti amin a tattao ti Israel. Kinunada, “Ti daga a napananmi ken sinukimatmi ket nasayaat unay. ");
INSERT INTO iloulb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","No maay-ayo ni Yahweh kadatayo, ipannatayo ngarud iti daytoy a daga ket itedna daytoy kadatayo. Ti daga nga agay-ayus iti gatas ken diro. ");
INSERT INTO iloulb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ngem saankayo nga agsukir kenni Yahweh, ken saankayo nga agbuteng kadagiti tattao iti daga. Ibusentayo ida a kas kalaka ti pannangan iti taraon. Maikkatto kadakuada ti salaknibda, gapu ta adda kadatayo ni Yahweh. Saankayo nga agbuteng kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ngem binutbuteng ida dagiti amin a tattao a batoenda ida agingga a matayda. Ket nagparang ti dayag ni Yahweh idiay tabernakulo kadagiti amin a tattao ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kinuna ni Yahweh kenni Moises, “Kasano pay kabayag ti panangumsi dagitoy a tattao kaniak? Kasano pay kabayag ti saanda a panagtalek kaniak, iti laksid dagiti amin nga inaramidko kadakuada a pagilasinan iti pannakabalinko? ");
INSERT INTO iloulb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Darupek ida babaen kadagiti didigra, ikkatek dagiti tawidda, ken manipud iti pulim mangaramidak iti maysa a nasion a dakdakkel ken nabilbileg ngem isuda.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Kinuna ni Moises kenni Yahweh, “No aramidem daytoy, ket mangeg dagiti Egipcio ti maipanggep iti daytoy, gapu ta insalakanmo dagitoy a tattao manipud kadakuada babaen iti pannakabalinmo. ");
INSERT INTO iloulb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ibagadanto kadagiti agnanaed iti daytoy a daga. Nangngegda a sika, O Yahweh ket adda kadagitoy a tattao, gapu ta nakitadaka iti rupan-rupa. Agtalinaed ti ulepmo iti ngatoen dagiti tattaomi. Umun-unaka ngem isuda babaen iti adigi nga ulep iti aldaw ken iti adigi nga apuy iti rabii. ");
INSERT INTO iloulb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ita no patayem dagitoy a tattao a kas maysa a tao, ket agsao ken ibaga dagiti nasion a nakangngeg iti kinalatakmo a, ");
INSERT INTO iloulb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","'Gapu ta saan a maipan ni Yahweh dagitoy a tattao iti daga nga inkarina nga itedna kadakuada, pinatayna ida idiay let-ang.' ");
INSERT INTO iloulb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ita, agpakpakaasiak kenka, usarem ti naindaklan a pannakabalinmo. Ta kinunam, ");
INSERT INTO iloulb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Saan a nalaka nga agunget ni Yahweh ken aglaplapusanan ti kinapudnona iti tulagna. Pakpakawanenna ti pagkurkurangan ken pagbasbasolan. Ikkatenna dagiti nagbasol inton iyegna kadagiti kaputotanda ti dusa ti basol dagiti kapuonanda, kadagiti maikatlo ken maika-uppat a henerasion.' ");
INSERT INTO iloulb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Agpakaasiak kenka a pakawanem ti basol dagitoy a tattao gapu iti naindaklan a kinapudnom iti tulagmo, kas iti kanayon a panangpakawanmo kadagitoy a tattao manipud idi addada pay laeng idiay Egipto agingga ita.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Kinuna ni Yahweh, “Pinakawanko ida kas iti dinawatmo, ");
INSERT INTO iloulb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ngem iti kinapudnona, iti panagbibiagko, ken kas mapunno iti dayagko ti entero a daga, ");
INSERT INTO iloulb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","amin dagiti tattao a nakakita ti dayagko ken dagiti pagilasinan iti pannakabalin nga inaramidko idiay Egipto ken idiay let-ang—sinuotdak latta dagitoy iti naminsangapulo ken saanda a dimngeg iti timekko. ");
INSERT INTO iloulb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Isu nga ibagak a sigurado a saandanto a makita ti daga nga inkarik kadagiti kapuonanda. Awan ti uray maysa kadakuada a nangumsi kaniak ti makakita iti daytoy, ");
INSERT INTO iloulb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","malaksid kenni Caleb nga adipenko, gapu ta adda sabali nga espirituna. Naan-anay a sinurotnak; ipankonto isuna iti daga a napanna sinukimat. Tagikuaento daytoy dagiti kaputotanna. ");
INSERT INTO iloulb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Ita, agnanaed dagiti Amalekita ken Canaaneo idiay tanap.) Agsublikayo inton bigat ket mapankayo idiay let-ang babaen iti dalan nga agturong iti baybay dagiti Runo.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nagsao ni Yahweh kada Moises ken Aaron. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Kasano pay kabayag ti panangib-ibturko kadagitoy a nadangkes a tattao a manguy-uyaw kaniak? Nangngegko dagiti panagrekreklamo dagiti tattao ti Israel kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ibagam kadakuada, kinuna ni Yahweh, ‘Iti panagbibiagko,' 'kas insaoyo iti panagdengngegko, Aramidek daytoy kadakayo: ");
INSERT INTO iloulb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mataykayonto iti daytoy a let-ang, aminkayo a nagreklamo maibusor kaniak, dakayo a nabilang iti sensus, ti sibubukel a bilang dagiti amin a tattao manipud iti agtawen iti duapulo ken agpangato. ");
INSERT INTO iloulb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Awan duadua a saankayo a makastrek iti daga nga inkarik a pagnaedanyo, malaksid kenni Caleb nga anak a lalaki ni Jefone ken ni Josue nga anak a lalaki ni Nun. ");
INSERT INTO iloulb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ngem ipankonto iti dayta a daga dagiti annakyo a kinunayo nga agbalin a biktima. Mapadasandanto ti daga a linaksidyo! ");
INSERT INTO iloulb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","No maipapan kadakayo, mataykayonto iti daytoy a let-ang. ");
INSERT INTO iloulb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Agalla-allanto dagiti annakyo iti let-ang iti uppat a pulo a tawen. Rumbeng a lak-amenda dagiti supapak dagiti panagsukiryo agingga a patayen ti let-ang dagiti bagbagiyo. ");
INSERT INTO iloulb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kas iti bilang dagiti aldaw idi sinukimatyo ti daga iti uppat a pulo nga aldaw, kasta met ti masapul a pananglak-amyo kadagiti supapak dagiti basolyo iti uppat a pulo a tawen—maysa a tawen para iti maysa nga aldaw, ken masapul a maammoanyo ti pagbanagan ti agbalin a kabusorko. ");
INSERT INTO iloulb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Siak, ni Yahweh, ti nagsao. Awan duadua nga aramidek daytoy kadagiti amin a nadangkes a tattao a nagtitipon a sangsangkamaysa a maibusor kaniak. Maibusdanto iti daytoy a let-ang. Ditoydanto a matay.'” ");
INSERT INTO iloulb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","- ");
INSERT INTO iloulb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Isu a natay iti sangoanan ni Yahweh dagiti amin a lallaki nga imbaon ni Moises a mangkita iti daga babaen ti didigra. Dagitoy dagiti lallaki a nagsubli ken nangipadamag iti saan a nasayaat maipanggep iti daga. Daytoy ti gapuna a nagreklamo amin a tattao maibusor kenni Moises. ");
INSERT INTO iloulb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Kadagiti lallaki a napan nangkita iti daga, ni laeng Josue nga anak a lalaki ni Nun ken ni Caleb nga anak a lalaki ni Jefone ti nagtalinaed a sibibiag. ");
INSERT INTO iloulb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Idi impadamag ni Moises dagitoy a sasao kadagiti amin a tattao ti Israel, nagladingitda iti kasta unay. ");
INSERT INTO iloulb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nasapada a bimmangon iti bigbigat ket napanda iti tuktok ti bantay ket kinunada, “Kitaenyo, addatayo ditoy, ket mapantayo iti lugar nga inkari ni Yahweh, ta nagbasoltayo.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ngem kinuna ni Moises, “Apay a salsalangusingenyon ita dagiti bilin ni Yahweh? Saankayo nga agballigi. ");
INSERT INTO iloulb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Saankayo a mapan, gapu ta awan kadakayo ni Yahweh a manglapped iti pannakaparmekyo kadagiti kabusoryo. ");
INSERT INTO iloulb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Adda sadiay dagiti Amalekita ken Cananeo, ket mataykayonto babaen kadagiti kampilan gapu ta timmalikodkayo manipud iti panangsursurotyo kenni Yahweh. Isu nga awanto isuna kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ngem pinilitda latta iti sumang-at iti katurturodan a pagilian; nupay kasta, saan a pimmanaw ni Moises wenno ti lakasa ti tulag ni Yahweh iti kampo. ");
INSERT INTO iloulb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ket simmalog dagiti Amalekita, kasta met dagiti Cananeo nga agnanaed kadagitoy a turturod. Rinautda dagiti Israelita ket pinarmekda ida agingga idiay Horma. ");
INSERT INTO iloulb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kalpasanna, nagsao ni Yahweh kenni Moses. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Agsaoka kadagiti tattao ti Israel ket ibagam kadakuada, 'Inton mapankayo iti daga a pagnaedanyonto, nga itedto ni Yahweh kadakayo— ");
INSERT INTO iloulb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ken inton mangidatonkayo kenkuana iti daton a maipuor—daton a maipuor man wenno daton a pangtungpal iti kari wenno daton nga agtaud iti bukod a nakem, wenno maysa a panangidaton kadagiti piestayo, a mangpataud iti nabanglo nga ayamuom para kenni Yahweh manipud kadagiti arban— ");
INSERT INTO iloulb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ket ti mangiyap-apan ti daton ket masapul a mangidaton kenni Yahweh iti sagut a bukel iti apagkapullo ti maysa nga efa ti napino nga arina a nalaokan iti apagkapat ti maysa a hin ti lana. ");
INSERT INTO iloulb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Masapul a mangisaganakayo met iti apagkapat ti maysa a hin ti arak a kas sagut a mainom. Aramidenyo daytoy a karaman iti daton a maipuor wenno iti panagidaton ti tunggal urbon a karnero. ");
INSERT INTO iloulb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","No mangidatdatonkayo iti kalakian a karnero, masapul a mangisaganakayo iti dua nga apagkapullo ti maysa nga efa ti napino nga arina a nalaokan iti apagkatlo a hin ti lana a kas sagut a bukel. ");
INSERT INTO iloulb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Para iti sagut a mainom, masapul a mangidatonkayo iti apagkatlo ti maysa a hin nga arak. Mangpataud daytoy iti nabanglo nga ayamuom para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Inton mangisaganakayo iti kalakian a baka a kas daton a maipuor wenno a kas daton a pangtungpal iti sapata, wenno a kas daton a pakikappia kenni Yahweh, ");
INSERT INTO iloulb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ket masapul a mangidatonkayo iti kalakian a baka a mapakuyogan iti sagut a bukel iti tallo nga apagkapullo iti maysa nga efa ti napino nga arina a nalaokan iti kaguddua a hin ti lana. ");
INSERT INTO iloulb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Masapul a mangidatonnkayo iti sagut a mainom a kaguddua a hin nga arak, a kas maysa a daton a maipuor, a mangpataud iti nabanglo nga ayamuom para kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Masapul a maaramid daytoy iti kastoy a wagas iti tunggal kalakian a baka, iti tunggal kalakian a karnero ken iti tunggal kalakian nga urbon a karnero wenno kadagiti urbon a kalding. ");
INSERT INTO iloulb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Tunggal daton ken sagut nga isaganayo ket masapul a maaramid a kas nailadawan ditoy. ");
INSERT INTO iloulb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Masapul nga aramiden dagiti amin nga Israelita dagitoy a banbanag iti kastoy a wagas, no adda mangiyeg iti daton a maipuor, a mangpataud iti ayamuom a makaay-ayo kenni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","No makipagnanaed kadakayo ti maysa a ganggannaet, wenno siasinoman a makipagnaed kadakayo kadagiti amin a henerasion ti tattaoyo, masapul a mangaramid isuna iti daton a maipuor, a mangpataud iti nabanglo nga ayamuom para kenni Yahweh. Masapul nga agtignay a kas iti panagtignayyo. ");
INSERT INTO iloulb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Masapul nga adda agpada a linteg para kadagiti tattao ken ti ganggannaet a makipagnanaed kadakayo, agnanayon a linteg kadagiti amin a henerasion iti tattaoyo. Kas kadakayo ken kasta met koma iti agdaldaliasat a makipagnanaed kadakayo. Masapul nga agtignay isuna kas iti panagtignayyo iti sangoanan ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Agpada a linteg ken bilin ti masapul nga annurotenyo ken iti ganggannaet a makipagnanaed kadakayo.'” ");
INSERT INTO iloulb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Nagsao manen ni Yahweh kenni Moses. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Agsaoka kadagiti tattao ti Israel ket ibagam kadakuada, 'Inton makadanonkayo iti daga a pangipanak kadakayo, ");
INSERT INTO iloulb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","no mangankayo iti taraon a napataud iti daga, masapul a mangidatonkayo ken idatagyo kaniak. ");
INSERT INTO iloulb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Manipud iti umuna a namasayo nga arina, masapul a mangidatagkayo iti napuskol a tinapay a maitag-ay a kas maysa a naitag-ay a sagut manipud iti pagir-irikan. Masapul nga itag-ayyo iti kastoy a wagas. ");
INSERT INTO iloulb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Kadagiti amin a henersion ti tattaoyo, masapul a mangtedkayo kaniak iti naitag-ay a sagut manipud iti umuna a namasayo. ");
INSERT INTO iloulb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Adda dagiti tiempo nga agbasolkayo a saanyo nga inggaggagara nga aramiden, no saankayo nga agtulnog kadagiti amin a bilbilin nga imbagak kenni Moses— ");
INSERT INTO iloulb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","amin nga imbilinko kadakayo babaen kenni Moses manipud iti aldaw a panangitedko kadakayo kadagiti bilin ken agingga kadagiti amin a henerasion dagiti tattaoyo. ");
INSERT INTO iloulb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","No nakaaramidda iti saan a naigagara a basol nga awan ti pannaka-ammo dagiti tattao, masapul ngarud a mangidaton dagiti amin a tattao iti maysa a kalakian nga urbon a baka a kas daton a maipuor a mangpataud iti nabanglo nga ayamuom para kenni Yahweh. Inayonyo pay ditoy ti sagut a bukel ken sagut a mainom, a kas naipaulog a bilin, ken maysa a kalakian a kalding a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Masapul a mangaramid ti padi iti pakapakawanan ti basol dagiti amin a tattao ti Israel. Mapakawandanto gapu ta ti basol ket maysa a biddut. Inyegda dagiti datonda, maysa a daton a maipuor para kaniak. Inyegda ti daton gapu ti basolda iti sangoanak para iti biddutda. ");
INSERT INTO iloulb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ket mapakawanto dagiti amin a tattao ti Israel ken kasta met kadagiti ganggannaet a makipagnanaed kadakuada, gapu ta nakaaramid dagiti amin tattao ti basol a saan a naigagara. ");
INSERT INTO iloulb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","No agbasbasol ti maysa a tao a saan a naigagara, masapul ngarud a mangidatag iti maysa a kabaian a kalding a maysa iti tawenna a kas daton gapu iti basol. ");
INSERT INTO iloulb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Masapul a mangaramid ti padi iti pakapakawanan ti basol iti sangoanan ni Yahweh para iti tao nga agbasbasol a saan a naigagara. Mapakawanto dayta a tao inton naaramiden dayta a seremonia iti pakapakawanan. ");
INSERT INTO iloulb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Masapul a maaddaankayo iti isu met laeng a linteg para iti agar-aramid iti banag a saan a naigagara, isu met laeng a linteg ti para iti puro nga Israelita kadagiti amin tattao ti Israel ken kadagiti ganggannaet a makipagnanaed kadakuada. ");
INSERT INTO iloulb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ngem ti tao nga agar-aramid iti banag a panagsukir, puro nga Israelita man wenno ganggannaet, ket tabtabbaawannak. Masapul a maisina dayta a tao kadagiti tattaona. ");
INSERT INTO iloulb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Gapu ta inumsina ti saok ken sinalungasingna ti bilinko, masapul a naan-anay a maisina dayta a tao. Addanto kenkuana ti basolna.'” ");
INSERT INTO iloulb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Kabayatan iti kaadda dagiti tattao ti Israel idiay let-ang, nakasarakda iti lalaki nga agur-urnong ti kayo iti Aldaw ti Panaginana. ");
INSERT INTO iloulb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Dagiti nakasarak kenkuana ket impanda isuna kada Moses, Aaron ken kadagiti amin a tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ket imbaludda gapu ta saan pay a naipakaammo ti rumbeng nga aramidenda kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ket kinuna ni Yahweh kenni Moses, “Masapul nga awan duadua a mapapatay ti lalaki. Masapul a batoen isuna dagiti amin a tattao iti ruar ti kampo.” ");
INSERT INTO iloulb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Isu nga inruar isuna dagiti amin a tattao iti kampo ket binatoda isuna agingga a natay a kas imbilin ni Yahweh kenni Moses. ");
INSERT INTO iloulb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Nagsao manen ni Yahweh kenni Moses. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Agsaoka kadagiti kaputotan ti Israel ket bilinem ida nga agaramidda ti baruyboy a maikabil iti gayadan dagiti pagan-anayda, nga ibitin dagitoy iti tunggal gayadan iti pagan-anayda babaen it asul a lubid. Masapul nga aramidenda daytoy agingga kadagiti amin a henerasion ti tattaoda. ");
INSERT INTO iloulb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Agbalin daytoy a naisangsangayan a palagip kadakayo, no kitaenyo daytoy, ipalagipna amin a bilbilinko, a tungpalenyo dagitoy tapno saanyo a suroten ti pusoyo ken ti matayo, a sigud a tignayyo a kasla naespirituan a balangkantis. ");
INSERT INTO iloulb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Aramidenyo daytoy tapno malagipyo koma ken tungpalenyo dagiti amin a bilbilinko, ken tapno agbalinkayo koma a nasantoan a nailasin kaniak a Diosyo. Siak ni Yahweh a Diosyo, a nangiruar kadakayo iti daga ti Egipto, nga agbalin a Diosyo. ");
INSERT INTO iloulb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Siak ni Yahweh a Diosyo.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ita, Ni Kora nga anak ni Izar nga anak ni Coat nga anak ni Levi, kaduana da Datan ken Abiram nga annak ni Eliab, ken ni On nga anak ni Pelet, dagiti kaputotan ni Ruben, ket inurnongna dagiti sumagmamano a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Timmakderda a bumusor kenni Moses, a kaduada dagiti dadduma a lallaki kadagiti tattao ti Israel, dua gasut ken lima pulo a mangidadaulo a mabigbigbig a kameng ti bunggoy dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Naguummongda a mangbabalaw kada Moses ken Aaron. Kinunada, “Aglablabeskayon. Nasantoan amin dagiti tattao, nailasin para kenni Yahweh, tunggal maysa kadakuada, ken adda ni Yahweh kadakuada. Apay nga isaadyo ti bagbagiyo a nangatngato kadagiti amin a tattao ni Yahweh?” ");
INSERT INTO iloulb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Idi nangngeg ni Moses dayta, nagpakleb isuna. ");
INSERT INTO iloulb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Nagsao isuna kenni Kora ken kadagiti amin a bunggoyna; kinunana, “Inton bigat, ipakitanto ni Yahweh no siasino ti kukuana ken dagiti naidaton kenkuana. Iyasidegna kenkuana ti tao a pinilina. Iyasidegto isuna ni Yahweh kenkuana. ");
INSERT INTO iloulb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Aramidenyo daytoy, Kora ken dagiti amin a bunggoyyo. Mangalakayo kadagiti insensario ");
INSERT INTO iloulb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","inton bigat ket kargaanyo dagitoy iti beggang ken insenso iti sangoanan ni Yahweh. Ti tao a pinili ni Yahweh, maidatonto dayta a tao kenkuana. Aglablabeskayon, dakayo a kaputotan ni Levi.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kinuna pay ni Moses kenni Kora, “Ita dumngegkayo, dakayo a kaputotan ni Levi: ");
INSERT INTO iloulb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","bassit kadi daytoy a banag kadakayo nga inlasinnakayo ti Dios ti Israel manipud kadagiti tattao ti Israel tapno iyasidegnakayo kenkuana, nga agtrabaho iti tabernakulo ni Yahweh ken tapno agtakder iti sangoanan dagiti tattao nga agserbi kadakuda? ");
INSERT INTO iloulb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Inyasidegnakayo ken dagiti annakyo, a kaputotan ni Levi, ita kayatyo pay ti agbalin a padi! ");
INSERT INTO iloulb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Dayta ti makagapu a naguummongkayo tapno bumusor kenni Yahweh. Apay ngarud nga agrekreklamokayo maipanggep kenni Aaron, nga agtultulnog kenni Yahweh?” ");
INSERT INTO iloulb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ket inayaban ni Moses da Datan ken Abiram, dagiti annak ni Eliab, ngem kinunada, “Saankami nga umay. ");
INSERT INTO iloulb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bassit kadi pay laeng a banag kenka iti panangiruarmo kadakami iti daga nga agay-ayus iti gatas ken diro, tapno papatayennakami iti let-ang? Ita kayatmo iti mangituray kadakami! ");
INSERT INTO iloulb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Maysa pay, saannakami nga impan iti daga nga agay-ayus ti gatas ken diro, wenno inikkan kadagiti taltalon ken kaubasan a pannakatawidmi. Ita, kayatnakami a bulseken kadagiti ubbaw a kari? Saankami nga umay kenka.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Kasta unay ti unget ni Moises ket kinunana kenni Yahweh, “Saanmo a raemen dagiti datonda. Awan ti innalak nga uray maysa nga asno kadakuada ken awan ti dinangrak uray maysa kadakuada.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ket kinuna ni Moises kenni Kora, “ Inton bigat, sika ken dagiti kakaduayo ket masapul a mapan iti sangoanan ni Yahweh, sika, isuda ken ni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Tunggal maysa kadakayo ket masapul a mangitugot iti insenserio ken kargaanyo daytoy iti insenso. Ket tunggal maysa, masapul a mangitugot iti insenseriona iti sangoanan ni Yahweh, dua gasut ken lima pulo nga insenserio. Mangitugotkayo met a dua ken Aaaron iti saggaysa nga isenserio.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Isu nga innala ti tunggal maysa ti insenseriona, kinargaanda iti beggang ken pinarabawanda daytoy iti insenso ken nagtakderda iti pagserkan ti tabernakulo a kaduada da Moises ken Aaron. ");
INSERT INTO iloulb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Inummong ni Kora dagiti amin a tattao a bumusbusor kada Moises ken Aaron iti pagserkan ti tabernakulo ken nagparang ti dayag ni Yahweh kadagiti amin a tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ket nagsao ni Yahweh kada Moises ken Aaron: ");
INSERT INTO iloulb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Adaywanyo dagitoy a tattao tapno maibusko ida iti apagdarikmat. ” ");
INSERT INTO iloulb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nagpakleb da Aaron ken Moises ket kinunada, “O Dios, ti Dios dagiti espiritu dagiti amin a tattao, no agbasol ti maysa a tao, masapul kadi a makaungetka kadagiti amin a tattao?” ");
INSERT INTO iloulb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Simmungbat ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Agsaoka kadagiti tattao. Ibagam, 'Adaywanyo dagiti tolda da Kora, Datan ken Abiram.'” ");
INSERT INTO iloulb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Timmakder ngarud ni Moises ket napan iti ayan da Datan ken Abiram; simmurot kenkuana dagiti panglakayen ti Israel. ");
INSERT INTO iloulb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nagsao isuna kadagiti tattao ket kinunana, “Ita, panawanyo dagiti tolda dagitoy a nadangkes a lallaki ken awan ti sagidenyo kadagiti kukuada, ta no saan maibuskayonto gapu kadagiti amin a basbasolda. ");
INSERT INTO iloulb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Isu a pimmanaw dagiti tattao nga adda kadagiti sikigan ti tolda da Kora, Datan, ken Abiram. Rimmuar ken nagtakder da Datan ken Abiram iti pagserkan dagiti toldada, a kaduada dagiti assawada, annakda a lallaki ken dagiti babassit nga annakda. ");
INSERT INTO iloulb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ket kinuna ni Moises, “Babaen iti daytoy, maammoanyo nga imbaonnak ni Yahweh a mangaramid kadagitoy a trabaho, ta saanko nga inaramid dagitoy iti bukodko a pagayatan. ");
INSERT INTO iloulb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","No matay dagitoy a lallaki iti kadawyan nga ipapatay a kas iti gagangay a mapaspasamak, saannak ngarud nga imbaon ni Yahweh. ");
INSERT INTO iloulb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ngem no agaramid ni Yahweh ti ringngat iti daga a mangalun-on kadakuada a kasla dakkel a ngiwat, a kaduada dagiti pamiliada, ken no bumabada a sibibiag idiay sheol, masapul ngarud a maawatanyo nga inlaksid dagitoy a lallaki ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Apaman a nalpas ti panagsasao ni Moises, nagungap ti daga iti batog dagitoy a lallaki. ");
INSERT INTO iloulb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Nagungap ti daga ket inalun-onna ida, agraman dagiti pamiliada ken dagiti amin a tattao a pasurot ni Kora ken kasta met dagiti amin a sanikuada. ");
INSERT INTO iloulb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Isuda ken amin a pamiliada ket nagpababa a sibibiag idiay sheol. Nagkaem ti daga a nangalun-on kadakuada ket iti kastoy a wagas, nagpukawda iti nagtetengngaan dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nagtataray amin nga Israel nga adda iti aglawlawda nga agiikkis. Impukpukkawda, “Amangan no alun-unennatayo met ti daga!” ");
INSERT INTO iloulb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Kalpasanna, simgiab ti apuy manipud kenni Yahweh ket inuramna ti 250 a lallaki a nagidaton kadagiti insenso. ");
INSERT INTO iloulb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Nagsao manen ni Yahweh kenni Moses ket kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kasaritam ni Eleazar nga anak ni Aaron a padi ket ibagam kenkuana nga alaenna dagiti insenserio iti ayan dagiti agbegbeggang a bangkay, ta naidaton kaniak dagiti insenserio. Ket masapul nga iwarawarada dagiti beggang. ");
INSERT INTO iloulb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Alaenyo dagiti insenserio dagiti natay gapu kadagiti basolda. Maaramid koma dagitoy a napitpit a pangkalub iti altar. Indaton idi dagiti lallaki dagitoy iti sangoanak, isu a naidaton dagitoy kaniak. Pagilasinanto dagitoy iti presensiak kadagiti tattao ti Israel.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","- ");
INSERT INTO iloulb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Innala ni Eleazar a padi ti tanso nga insenserio nga inaramat dagiti lallaki a nauram. Pinitpitna dagitoy a kas pangkalub iti altar, a kas imbaga ni Yahweh kenkuana babaen kenni Moses. Agbalinto dagitoy a palagip kadagiti tattao ti Israel, tapno awan ti tao a saan a nagtaud iti kaputotan ni Aaron ti umay tapno mangipuor iti insenso iti sangoanan ni Yahweh. Iti kastoy a wagas, awanto ti tao nga agbalin a kasla kenni Kora ken kadagiti bunggoyna. ");
INSERT INTO iloulb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ngem iti sumaruno nga agsapa, nagsasao iti maibusor kada Moises ken Aaron dagiti amin a tattao ti Israel. Kinunada, “Pinatayyo dagiti tattao ni Yahweh.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ket napasamak daytoy, idi naguummong dagiti tattao a bimmusor kada Moses ken Aaron, idi kimmitada iti tabernakulo ket pagammoan, naimatanganda a salsallukuban ti ulep daytoy. Nagparang ti dayag ni Yahweh ");
INSERT INTO iloulb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ket napan da Moises ken Aaron iti sangoanan ti tabernakulo. ");
INSERT INTO iloulb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Kalpasanna, nagsao ni Yahweh kenni Moises, Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Umadayokayo iti sangoanan dagitoy a tattao tapno maibusko ida iti apagdarikmat. Ket nagpakleb da Moises ken Aaron. ");
INSERT INTO iloulb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kinuna ni Moises kenni Aaron, “Alaem ti insenserio, kargaam daytoy iti beggang manipud iti altar, kargaam daytoy iti insenso, iyapuram dagitoy nga ipan iti ayan dagiti tattao ket mangaramidka iti pakapakawanan dagiti basolda, gapu ta umayen ti pungtot ni Yahweh. Nangrugin ti didigra.” ");
INSERT INTO iloulb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Inaramid ngarud ni Aaron ti imbilin ni Moises. Nagtaray isuna iti tengnga dagiti tattao. Nagwarasen a dagus ti didigra kadagiti tattao, isu nga ingkargana ti insenso ket inaramidna ti seremonia a pakapakawanan ti basol dagiti tattao. ");
INSERT INTO iloulb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Nagtakder ni Aaron iti nagbaetan dagiti natay ken dagiti sibibiag; iti kastoy a wagas napasardeng ti didigra. ");
INSERT INTO iloulb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Agdagup iti 14, 700 ti bilang dagiti natay iti didigra, malaksid kadagiti natay a kadua ni Kora. ");
INSERT INTO iloulb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Nagsubli ni Aaron iti ayan ni Moises iti pagserkan ti tabernakulo ket nagsardengen ti didigra. ");
INSERT INTO iloulb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Nagsao ni Yahweh kenni Moises. Kinunana, ");
INSERT INTO iloulb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Agsaoka kadagiti tattao ti Israel. Mangalaka kadagiti sarukod manipud kadakuada, maysa iti tunggal tribu dagiti kapuonan. Mangalaka iti sangapulo ket dua a sarukod, maysa iti tunggal mangidadaulo iti tunggal tribu. Isuratmo ti nagan ti tunggal tao iti sarukodna. ");
INSERT INTO iloulb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Masapul nga isuratmo ti nagan ni Aaron iti sarukod ni Levi. Masapul nga adda maysa a sarukod iti tunggal mangidadaulo manipud iti tribu ti kapuonanna. ");
INSERT INTO iloulb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Masapul nga ikabilmo dagiti sarukod iti tabernakulo iti sangoanan ti pammaneknek ti tulag, a pakisarakak kenka. ");
INSERT INTO iloulb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Agsaringitto ti sarukod ti mapilik a tao. Pagsardengekto dagiti reklamo dagiti tattao ti Israel nga ibagbagada a maibusor kadakayo.” ");
INSERT INTO iloulb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nagsao ni Moises kadagiti tattao ti Israel. Amin dagiti mangidadaulo ti tribu ket nangted kadagiti sarukod kenkuana, maysa a sarukod manipud iti tunggal mangidadaulo, a napili manipud iti tunggal tribu ti kapuonan, sangapulo ket dua amin a sarukod. Maysa kadagitoy ti sarukod ni Aaron. ");
INSERT INTO iloulb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ket inkabil ni Moises dagiti sarukod iti sangoanan ni Yahweh iti tolda ti pammaneknek ti tulag. ");
INSERT INTO iloulb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Iti simmaruno nga aldaw, napan ni Moises iti tolda ti pammaneknek iti tulag ket pagammoan, nagsaringit ti sarukod ni Aaron iti tribu ni Levi. Dimmakkel dagiti saringitna, nagsabong ken nagbunga iti naluom nga almendras! ");
INSERT INTO iloulb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Innala ni Moises dagiti sarukod manipud iti sangoanan ni Yahweh ket imparangna kadagiti tattao ti Israel. Nasarakan ti tunggal maysa ti sarukodna ket innalana daytoy. ");
INSERT INTO il