﻿USE sofia;
DROP TABLE IF EXISTS sofia.ikz_vpl;
CREATE TABLE ikz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ikz_vpl WRITE;
INSERT INTO ikz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ganʉ nego amariina gi ikishoko kɨnʉ Yɨɨsu Kiriisitʉ aaruuriirɨ. Yɨɨsu Kiriisitʉ akarwɨra murwibhʉrʉ rwʉ ʉmʉtɨmi Daudi ni ikishoko cha Abhurahaamu. ");
INSERT INTO ikz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abhurahaamu akiibhʉra Iisaka, Iisaka akiibhʉra Yaakobho, Yaakobho akiibhʉra Yuuda na abhahiiri bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda akiibhʉra Pɨrɨɨsi na Zeera kwa Tamaari, Pɨrɨɨsi akiibhʉra Hɨzirʉʉni, Hɨzirʉʉni akiibhʉra Araamu, ");
INSERT INTO ikz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamu akiibhʉra Aminadaabhu, Aminadaabhu akiibhʉra Nashʉni, Nashʉni akiibhʉra Sarimʉʉni, ");
INSERT INTO ikz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarimʉʉni akiibhʉra Bhoowazi kwa Rahaabhu, Bhoowazi akiibhʉra Ʉbhɨɨdi kwa Ruutu, Ʉbhɨɨdi akiibhʉra Yeese, ");
INSERT INTO ikz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Yeese akiibhʉra ʉmʉtɨmi Daudi. Daudi akiibhʉra Sɨrɨmaani kʉmʉkari wʉnʉ aarɨ kʉbha ʉmʉkari wa Uriya, ");
INSERT INTO ikz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɨrɨmaani akiibhʉra Rehobhowamu, Rehobhowamu akiibhʉra Abhiya, Abhiya akiibhʉra Asa, ");
INSERT INTO ikz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa akiibhʉra Yehoshafaati, Yehoshafaati akiibhʉra Yoraamu, Yoraamu akiibhʉra Uziya, ");
INSERT INTO ikz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya akiibhʉra Yosamu, Yosamu akiibhʉra Ahaazi, Ahaazi akiibhʉra Hɨzɨkiya, ");
INSERT INTO ikz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɨzɨkiya akiibhʉra Manaasɨ, Manaasɨ akiibhʉra Amʉni, Amʉni akiibhʉra Yʉsiya, ");
INSERT INTO ikz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Yʉsiya akiibhʉra Yɨkʉniya na bhaumwabhʉ. Ribhaga rɨkahɨta, Abhiiziraɨri bhakagwatwa, bhakahirwa mobhohocha mucharʉ cha Bhaabhɨɨri. ");
INSERT INTO ikz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hanʉ Abhiiziraɨri bhaamarirɨ kʉsaamibhwa iyo, Yɨkʉniya akiibhʉra Sheyaritiyɨri, Sheyaritiyɨri akiibhʉra Zɨrubhabhɨɨri, ");
INSERT INTO ikz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zɨrubhabhɨɨri akiibhʉra Abhihudi, Abhihudi akiibhʉra Ɨriyakimu, Ɨriyakimu akiibhʉra Azʉri, ");
INSERT INTO ikz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azʉri akiibhʉra Zadʉki, Zadʉki akiibhʉra Akimu, Akimu akiibhʉra Ɨriudi, ");
INSERT INTO ikz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɨriudi akiibhʉra Ɨrɨazaari, Ɨrɨazaari akiibhʉra Matani, Matani akiibhʉra Yaakobho, ");
INSERT INTO ikz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakobho akiibhʉra Yuusufu, umusubhɨ wa Mariyamu, na Mariyamu akiibhʉra Yɨɨsu wʉnʉ akubhirikirwa Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mmbe, kurwa kwa Abhurahaamu kuhikɨra ukwibhurwa kʉ ʉmʉtɨmi Daudi kwarɨ na zinyibhʉrʉ ikumi ni inyɨ. Na kurwa kwa Daudi kuhikɨra ribhaga rɨnʉ Abhiiziraɨri bhaasaamiibhwɨ mobhohocha mucharʉ cha Bhaabhɨɨri, kwarɨ na zinyibhʉrʉ ɨzɨndɨ ikumi ni inyɨ. Na kurwa ribhaga rɨnʉ bhasaamiibhwɨ iyo kuhikɨra ukwibhurwa kwa Kiriisitʉ, kwarɨ na zinyibhʉrʉ ɨzɨndɨ ikumi ni inyɨ. ");
INSERT INTO ikz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ganʉ nego amangʼana gu ukwibhurwa kwa Yɨɨsu Kiriisitʉ. Mariyamu unina Yɨɨsu, aarɨ arunjibhwɨ na Yuusufu. Nawe hanʉ aarɨ akɨɨrɨ kuryakara, Mariyamu akagega ɨnda kʉbhʉnaja bhwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yuusufu umusubhɨ waazɨ, aarɨ ʉmʉʉtʉ we eheene mʉbhʉtangɨ bhwa Mungu. Atɨɨndirɨ asuuchɨ Mariyamu, kʉgayo akeenda amwangɨ kimbisi. ");
INSERT INTO ikz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nawe, hanʉ Yuusufu aarɨ ariiseega gayo, rogendo rʉmwɨ maraika wʉ Ʉmʉkʉrʉ Mungu akamuhwarʉkɨra mokerooto, akamʉbhʉʉrɨra, “Yuusufu, umwana wʉ ʉmʉtɨmi Daudi, ʉtʉʉbhaha kukwɨra Mariyamu, kʉ kʉbha ɨnda yaazɨ ayibhwɨnɨ kʉbhʉnaja bhwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ariibhʉra umwana wi ikisubhɨ, naawɨ ʉmʉrʉkɨ Yɨɨsu, kʉ kʉbha wuyo newe araasabhʉrɨ abhaatʉ bhaazɨ kurwa mʉbhʉbhɨ bhwabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gayo gʉʉsi gaakʉriibhwɨ, korereke rɨbhɨ ringʼana rɨnʉ Ʉmʉkʉrʉ Mungu aagambirɨ kʉnzɨra yʉ ʉmʉrʉʉtɨrɨri kʉbha, ");
INSERT INTO ikz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Rora, umusiiti aragega ɨnda, neewe ariibhʉra umwana wi ikisubhɨ. Ararukwa Ɨmaanwɨri.” Enzobhooro yaku, Mungu hamwɨmwɨ na niitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hanʉ Yuusufu aabhuukirɨ, akakora chɨmbu maraika wʉ Ʉmʉkʉrʉ Mungu aamubhuuriirɨ. Akakwɨra Mariyamu, ");
INSERT INTO ikz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","nawe atarɨɨrɨ neewe kuhika hanʉ Mariyamu iitʉʉrɨɨnʼyɨ. Akamʉrʉka umwana wuyo, Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yɨɨsu akiibhurwa mʉrʉbhɨri rwa Bhɨtɨrɨhɨɨmu mucharʉ cha Yudeya, ribhaga rɨnʉ Heroode aarɨ ʉmʉtɨmi. Ribhaga riyo, abhamɨnyi bha zenzota bhanʉ bhaaruurɨ rʉgʉrʉ, bhakahika mʉrʉbhɨri rwa Yɨrusarɨɨmu. Bhakabhuurya, ");
INSERT INTO ikz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Arɨ hayi umwana wʉnʉ ibhwirwɨ abhɨ ʉmʉtɨmi wa Abhayaahudi? Tʉmɨnyirɨ ibhwirwɨ, kʉ kʉbha enzota yaazɨ ɨkarorekana kwa niitwɨ rʉgʉrʉ, twizirɨ komosengera.” ");
INSERT INTO ikz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hanʉ ʉmʉtɨmi Heroode iigwirɨ amangʼana gaabhʉ, akahaha, hamwɨmwɨ na abhaatʉ bhʉʉsi bha Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Neho Heroode akabhiringa abhakʉrʉ bhʉʉsi bha abhakuhaani na abhiija bhi imigirʉ ja Musa, akabhabhuurya, “Kiriisitʉ ariibhurwa hayi?” ");
INSERT INTO ikz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhakamʉgarukirya, “Ariibhurwa mʉrʉbhɨri rwa Bhɨtɨrɨhɨɨmu mucharʉ cha Yudeya. Tʉmɨnyirɨ riyo, kʉ kʉbha Mungu akagamba kʉhɨtɨra ʉmʉrʉʉtɨrɨri kʉbha, ");
INSERT INTO ikz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Imwɨ abhaatʉ bha Bhɨtɨrɨhɨɨmu mucharʉ cha Yuuda, mʉtarɨ bha koregwa mʉbhʉkangati bhwi icharʉ cha Yuuda, kʉ kʉbha kurwa kwa niimwɨ arahʉrʉka ʉmʉkangati wʉnʉ akʉkangata abhaatʉ bhaanɨ bha Iziraɨri, nchu umuriisha akuriisha zɨngʼʉndu zaazɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Neho Heroode akabhɨrɨkɨra abhamɨnyi bha zenzota bhayo kwa mbisi, korereke bhaazɨ bhamʉbhʉʉrɨrɨ bhwaheene ribhaga rɨnʉ bhaarʉʉzɨ enzota. ");
INSERT INTO ikz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Akʉmara, akabhatʉma Bhɨtɨrɨhɨɨmu, akabhabhʉʉrɨra, “Mujɨ mubhuuririryɨ bhwaheene, kuhika momenye hanʉ umwana wuyo arɨ. Hanʉ mʉraamobhone mondeetere amangʼana bhwangʉ korereke na niinyɨ nijɨ komosengera.” ");
INSERT INTO ikz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hanʉ abhamɨnyi bha zenzota bhiigwirɨ amangʼana gʉ ʉmʉtɨmi, bhakabhʉʉka. Rogendo rʉmwɨ, enzota yɨnʉ bhaarʉʉzɨ rʉgʉrʉ ɨkabhakangatɨra, ikiimɨɨrɨra hanʉ umwana aarɨ. ");
INSERT INTO ikz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hanʉ bhaarʉʉzɨ enzota yiyo, bhakazomerwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhakasikɨra munyumba, bhakarora umwana na Mariyamu unina, bhakahigama kosengera umwana. Bhakatazʉra imirigʉ jabhʉ, bhakaha umwana ʉmʉbhanʉ gwɨ ɨzahaabhu, umurumbasʉ na manɨmanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mmbe, Mungu akabhahama mobherooto kʉbha, bhatagarʉka kwikɨ kwa Heroode. Bhakahʉrʉkɨra ɨnzɨra yɨndɨ kʉgarʉka ɨwaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hanʉ abhamɨnyi bha zenzota bhayo bhaagiirɨ, maraika wʉ Ʉmʉkʉrʉ Mungu akahwarʉkɨra Yuusufu mokerooto. Akamʉbhʉʉrɨra, “Bhʉʉka! Ogege umwana na unina, ongʼosere mucharʉ cha Miisiri. Mʉsaagɨ iyo kuhika hanʉ nɨraakʉbhʉʉrɨrɨ ʉgarʉkɨ, kʉ kʉbha Heroode aramohya umwana areenda amwitɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mmbe, Yuusufu akabhʉʉka ubhutikʉ bhuyobhuyo, akagega mʉkaazɨ nu umwana, akangʼosera Miisiri. ");
INSERT INTO ikz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bhakahika Miisiri, bhakiikara iyo kuhika hanʉ Heroode aakuurɨ. Amangʼana gayo gakakʉribhwa, korereke rɨbhɨ ringʼana rɨnʉ Ʉmʉkʉrʉ Mungu aagambirɨ kʉnzɨra yʉ ʉmʉrʉʉtɨrɨri waazɨ, “Nɨkamʉbhɨrɨkɨra umwana waanɨ kurwa Miisiri.” ");
INSERT INTO ikz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hanʉ Heroode aamɨnyirɨ kʉbha abhamɨnyi bha zenzota bharya bhamʉkangiriiryɨ, akiigatana bhʉkʉngʼu. Neho akatʉma abhasirikarɨ bhaazɨ Bhɨtɨrɨhɨɨmu hamwɨmwɨ na ahagero hʉʉsi ha haguhɨ, akabhaswaja kʉbha bhiitɨ abhaana bhi ikisubhɨ bhʉʉsi bhi imyaka ɨbhɨrɨ kʉgarʉka iyaasɨ. Akakorabhu kʉrɨngʼaana na ribhaga rɨnʉ aabhuuriirwɨ na abhamɨnyi bha zenzota. ");
INSERT INTO ikz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Neho rɨkabha ringʼana rɨnʉ ʉmʉrʉʉtɨrɨri Yɨrɨmiya aagambirɨ, ");
INSERT INTO ikz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ɨkɨrɨrʉ kɨkabhoneka mʉrʉbhɨri rwa Raama, ɨkɨrɨrʉ nu ukwarama kwaru. Rahɨɨri ararɨrɨra abhaana bhaazɨ, ɨnʉ atakwenda kʉhʉnibhwa, kʉ kʉbha abhaana bhaazɨ bhatareeho.” ");
INSERT INTO ikz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hanʉ Heroode aamarirɨ kukwa, maraika wʉ Ʉmʉkʉrʉ Mungu akamuhwarʉkɨra Yuusufu mokerooto Miisiri, ");
INSERT INTO ikz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamʉbhʉʉrɨra, “Bhʉʉka! Ogege umwana na unina, mʉgarʉkɨ mucharʉ cha Iziraɨri, kʉ kʉbha bhanʉ bhaarɨ bhareenda kwita umwana wuyo, bhakuurɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mmbe, Yuusufu akabhʉʉka, akagega umwana na unina, akagarʉka mucharʉ cha Iziraɨri. ");
INSERT INTO ikz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nawe hanʉ iigwirɨ kʉbha Arikɨraʉ umwana wa Heroode aarɨ arakangata Yudeya, akʉʉbhaha kujayʉ. Hanʉ Mungu aamubhuuriirɨ mokerooto ataja iyo naatu, akaja mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bhakahika mʉrʉbhɨri rwa Nazarɨɨti, bhakiikara iyo. Neho ringʼana rɨkabha rɨnʉ ryagambirwɨ igʉrʉ wa Yɨɨsu kʉnzɨra ya abharʉʉtɨrɨri, “Arabhirikirwa Mʉnazarɨɨti.” ");
INSERT INTO ikz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Zisikʉ nzaru zɨnʉ zihitirɨ, aareho ʉmʉʉtʉ wʉmwɨ wʉnʉ akubhirikirwa Yoohana Ʉmʉbhatiizi. Aarɨ ararwaza mwitɨrɨgʉ rya Yudeya arabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mutigɨ ʉbhʉbhɨ bhwanyu, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ bhʉraariirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Newe aagambirwɨ nʉ ʉmʉrʉʉtɨrɨri Isaaya, “Riraka ryʉ ʉmʉʉtʉ wʉnʉ akʉraganʼya mwitɨrɨgʉ, ‘Mokonze ɨnzɨra yʉ Ʉmʉkʉrʉ, mogorore ɨbhɨhɨtʉ bhyazɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoohana aarɨ ibhʉhirɨ ʉbhʉzʉʉkɨ bhwɨ ɨngamiya no omokena gwa riseero mukiribhizi. Ibhyakurya bhyazɨ bhyarɨ zingigɨ nu ubhwʉkɨ bhwa mwitɨrɨgʉ. ");
INSERT INTO ikz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abhaatʉ kurwa ʉrʉbhɨri rwa Yɨrusarɨɨmu, icharʉ cha Yudeya chʉsi, na zɨmbaara zʉʉsi zɨ ɨkɨtaarʉ cha Yorodaani, bhakabha bharamujaku. ");
INSERT INTO ikz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhakatiga ʉbhʉbhɨ bhwabhʉ, akabhabhatiiza mʉkɨtaarʉ cha Yorodaani. ");
INSERT INTO ikz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nawe hanʉ Yoohana aarʉʉzɨ Abhafarisaayo na Abhasadukaayo bhaaru bharamujaku korereke abhabhatiizɨ, akabhabhʉʉrɨra, “Imwɨ urwibhʉrʉ rwe enzoka! Wɨɨwɨ abhabhuuriirɨ mʉratʉra kongʼosa ɨtɨnɨrʉ ya Mungu yɨnʉ ikuuza? ");
INSERT INTO ikz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mmbe, mokore amahocha ganʉ gakwerekenʼya kʉbha mutigirɨ ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mutiikangirirya naatu mʉrabhuga, ‘Sʉʉkʉrʉ wɨɨtʉ, nɨ‑Abhurahaamu!’ Nɨrabhabhʉʉrɨra kʉbha, Mungu aratʉra kuchʉra amabhwɨ ganʉ gabhɨ abhaana bha Abhurahaamu! ");
INSERT INTO ikz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nangʉ ɨtɨnɨrʉ ya Mungu iri igʉrʉ waanyu nchɨ ɨhaazi iri igʉrʉ wa amatina gɨ ɨmɨtɨ. Na bhanʉ bhatakokora amahocha amazʉmu bharatinirwa, chɨmbu ɨmɨtɨ jʉsi gɨnʉ gɨtakwibhʉra imisumʉ ɨmɨzʉmu gɨhaatinwa na kʉtaashwa momorero. ");
INSERT INTO ikz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Inyɨ nɨrabhabhatiiza na amanzi kwerecha kʉbha mwichuriirɨ Mungu. Nawe araaza ʉmʉʉtʉ wʉ ʉbhʉnaja kʉnkɨra. Nɨtakwenderwa nʉʉrʉ kʉtazʉra zisiri zi ibhikwɨra bhyazɨ. Ewe arabhabhatiiza kwe Ekoro Ɨndɨndu na komorero. ");
INSERT INTO ikz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na agwatiriirɨ ʉrʉhʉngʉ mʉmabhoko gaazɨ, korereke aseese ɨnganʉ. Ɨnganʉ yiyo arayikumɨngɨra mʉkɨtara chazɨ. Nawe ʉmʉkʉʉnyʉ, aragwocha momorero gʉnʉ gʉtakurima zee.” ");
INSERT INTO ikz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mmbe, ribhaga riyo, Yɨɨsu akarwa Gariraaya, akaja mʉkɨtaarʉ cha Yorodaani korereke Yoohana amʉbhatiizɨ. ");
INSERT INTO ikz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nawe Yoohana akagema komorecha, aramʉbhʉʉrɨra, “Niinyɨ nikwenderwa kʉbhatiizwa na naawɨ, ndora ʉraaza kwa niinyɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yɨɨsu akamʉgarukirya, “Awɨ wiisiriryɨ onyoje ʉbhʉbhɨ nangwɨnʉ, kʉ kʉbha toreenderwa tokore eheene yʉʉsi yɨnʉ Mungu akwenda.” Neho Yoohana akiisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hanʉ Yɨɨsu aabhatiizirwɨ na kurwa mʉmanzi, rogendo rʉmwɨ risaarʉ rikiigʉka, akarora Ekoro ya Mungu iriika nchi ikiguuti na kwikara igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Neho, riraka rɨkarwa mwisaarʉ rɨrabhuga, “Wʉnʉ ni‑Mwana waanɨ ʉmʉsɨɨgwa, nɨzʉmɨrɨɨrwɨ nawe.” ");
INSERT INTO ikz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Akʉmara, Yɨɨsu akakangatwa ne Ekoro Ɨndɨndu kuja mwitɨrɨgʉ korereke agemwe na Shɨtaani. ");
INSERT INTO ikz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akamara iyo sikʉ merongo ene, ubhutikʉ nu umwise ariiyima kurya ibhyakurya. Ɨtɨnɨrʉ, akiigwa ɨnzara. ");
INSERT INTO ikz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Neho Shɨtaani akaaza komogema. Akamʉbhʉʉrɨra, “Arɨɨbhɨ awɨ ni‑Mwana wa Mungu, swaja amabhwɨ ganʉ gabhɨ ɨmɨkaatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nawe Yɨɨsu akabhuga, “Yandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Ʉmʉʉtʉ atakwikara kwa bhyakurya ibhyene, nawe kwa amangʼana ganʉ gakurwa kwa Mungu.’” ");
INSERT INTO ikz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Akʉmara Shɨtaani akamuhira mʉrʉbhɨri ʉrʉrɨndu rwa Yɨrusarɨɨmu, akamwimiirirya kʉkɨkʉngʉ cha rihekaaru, ");
INSERT INTO ikz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamʉbhʉʉrɨra, “Arɨɨbhɨ awɨ ni‑Mwana wa Mungu, irekera haasɨ, kʉ kʉbha yandikirwɨ, ‘Mungu araswaja bhamaraika bhaazɨ igʉrʉ waazʉ, ebho bharakugwatɨrɨra, korereke amagʉrʉ gaazʉ gataaza kwitema kwibhwɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nawe Yɨɨsu akamʉbhʉʉrɨra, “Yandikirwɨ, ‘Ʉtagema Ʉmʉkʉrʉ Mungu waazʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Akʉmara, Shɨtaani akamuhira kosonga yɨ ɨkɨgʉrʉ ɨkɨrɨɨhu. Akamwerecha ʉbhʉtɨmi bhwa zɨɨsɨ zʉʉsi nu ubhuniibhi bhwazʉ, ");
INSERT INTO ikz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akamʉbhʉʉrɨra, “Ʉraanhigamɨrɨ na konsengera, nɨrakoha bhyʉsi bhɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nawe Yɨɨsu akamʉbhʉʉrɨra, “Nuurwɨ hanʉ, Shɨtaani! Yandikirwɨ, ‘Osengere Ʉmʉkʉrʉ Mungu waazʉ, na omohokerye ewe umwene.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Neho Shɨtaani akamutiga hayo. Hayohayo bhamaraika bhakaaza kumwangarɨra. ");
INSERT INTO ikz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hanʉ Yɨɨsu iigwirɨ kʉbha Yoohana Ʉmʉbhatiizi abhʉhirwɨ mokebhoho, akaja mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gariraaya iyo, akasaama Nazarɨɨti, akaja kwikara mʉrʉbhɨri rwa Kapɨrinaumu. Kapɨrinaumu iri rusizʉ wɨ ɨnyanza ya Gariraaya, ʉrʉbhaara rwɨ ɨbhɨgambʉ bhya Zabhurʉʉni na Naafutaari. ");
INSERT INTO ikz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɨkabhabhu, korereke rɨbhɨ ringʼana rɨnʉ Mungu aagambirɨ kʉhɨtɨra kwʉ ʉmʉrʉʉtɨrɨri Isaaya, ");
INSERT INTO ikz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mwitegeerere abhaatʉ bhi icharʉ cha Zabhurʉʉni na Naafutaari, ahagero hanʉ harɨ kʉnzɨra yu ukwerekera kʉnyanza, ni imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani, mucharʉ cha Gariraaya ɨnʉ bhakwikara abhaatʉ bhi ibhyarʉ ɨbhɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abhaatʉ bhayo bhiikɨɨrɨ mukiirimya, bharʉʉzɨ ubhwɨrʉ ʉbhʉkʉrʉ, na bhanʉ bhi ikɨɨrɨ mukikiriiri chu uruku, bhahwarukiirwɨ nu ubhwɨrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kwɨma ribhaga riyo, Yɨɨsu akatanga kurwazɨra abhaatʉ, “Mutigɨ ʉbhʉbhɨ bhwanyu, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ bhʉraariirɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hanʉ Yɨɨsu aarɨ aragenda rusizʉ wɨ ɨnyanza ya Gariraaya, akarora abhahiiri bhabhɨrɨ, Simʉʉni wʉnʉ aabhirikiirwɨ Peetero na Andureya. Bhaarɨ bhararekera zenzero mʉnyanza kʉ kʉbha bhaarɨ abhawɨsɨni. ");
INSERT INTO ikz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yɨɨsu akabhabhʉʉrɨra, “Muntunɨ na niinyɨ nɨrabhakora kʉbha abhawɨsɨni bha abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rogendo rʉmwɨ, bhakatiga zenzero zaabhʉ, bhakamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hanʉ iisukirɨ embere hasuuhu, akarora abhaatʉ abhandɨ bhabhɨrɨ, Yaakobho na Yoohana umunyi waazɨ, abhaana bha Zebhedaayo. Bhaarɨ mubhwatʉ hamwɨmwɨ na wiisɨ, bharazomya zenzero zaabhʉ, akabhabhɨrɨkɨra. ");
INSERT INTO ikz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hayohayo bhakatiga wiisɨ nu ubhwatʉ, bhakamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yɨɨsu aarɨ ariiruguura mucharʉ chʉsi cha Gariraaya. Aarɨ arasikɨra mʉmarwazɨrʉ na kwija abhaatʉ. Aarɨ ararwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu igʉrʉ wʉ ʉbhʉtɨmi bhwa mwisaarʉ na kohorya amarwɨrɨ gaabhʉ gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɨngʼana igʉrʉ wa Yɨɨsu ɨkanyaragana bhʉkʉngʼu kuhika mucharʉ chʉsi cha Siiriya. Abhaatʉ bhakahira abharwɨrɨ bhaabhʉ bhʉʉsi bha amarwɨrɨ ga zeteemwa zʉzʉʉsi bhaarɨ bharanyaakibhwa. Gatɨ waabhʉ, bhaarɨmu bha amasambwa amabhɨ, bha ririmu na bhanʉ bhakuurɨ ibhiimʉ, akabhahorya bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mmbe, abhaatʉ bhaaru bhakabha bharamutuna kurwa Gariraaya, Dɨkapʉʉri, Yɨrusarɨɨmu, Yudeya ni imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani. ");
INSERT INTO ikz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mmbe, hanʉ Yɨɨsu aarʉʉzɨ amaribhita ga abhaatʉ, akatiira kʉkɨgʉrʉ, akiikara, abhɨɨga bhaazɨ bhakaja kwawe. ");
INSERT INTO ikz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Neho akatanga kubhiija, ");
INSERT INTO ikz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hakɨrɨku bhanʉ bhiiyɨzɨ kʉbha bhanu ubhwɨndi na Mungu, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ ubhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hakɨrɨku bhanʉ bharumikirɨ, kʉ kʉbha Mungu arabhiibhisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hakɨrɨku abhanyʉʉhu, kʉ kʉbha bharagabha ɨɨsɨ yʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hakɨrɨku bhɨ ɨnzara ne enyoota yo okokora ge eheene, kʉ kʉbha Mungu arabhiigutya. ");
INSERT INTO ikz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hakɨrɨku bhɨ ɨbhɨgʉngi, kʉ kʉbha ebho bhararorerwa ɨbhɨgʉngi. ");
INSERT INTO ikz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hakɨrɨku bhu umwʉyʉ umwɨrʉ, kʉ kʉbha bhararora Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hakɨrɨku abhiigwanʼya bha abhaatʉ, kʉ kʉbha bharabhirikirwa abhaana bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hakɨrɨku bhanʉ bhakʉnyaakibhwa igʉrʉ we eheene, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ nu‑bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hakɨrɨku imwɨ hanʉ abhaatʉ bhakʉbhatʉka, bhakʉbhanyaacha na kʉbhasaayɨra ʉbhʉbhɨ bhwa zeteemwa zʉʉsi igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhiitɨ kʉbha ɨbhu nɨmbu abhaatʉ bhaarɨ bhakʉnyaacha abharʉʉtɨrɨri bhanʉ bhaareho ɨkarɨ. Mozomerwe na kuriiryata bhʉkʉngʼu, kʉ kʉbha Mungu abhatɨɨrɨɨrɨ ʉmʉbhanʉ mʉkʉrʉ mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imwɨ nɨ‑mʉʉnyʉ kʉʉsɨ. Nawe guriibhuryɨ ʉbhʉsambaruku bhwagwɨ, gʉratuurirwa kɨgʉrʉkɨ korereke gozome naatu? Gʉtakwenderwa kʉrʉnga kegero chʉchʉsi, kʉgayo gʉrataashwa igʉtʉ na kʉtazwa na abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imwɨ ni‑bhwɨrʉ kʉʉsɨ. Ʉrʉbhɨri rʉnʉ rwʉmbakirwɨ kʉkɨgʉrʉ, rʉtakʉtʉra kubhisa ubhwɨrʉ bhwaku. ");
INSERT INTO ikz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naatu, abhaatʉ bhatakwacha ɨkɨmʉrɨ bhakikundikiryɨ na rihʉʉzʉ. Nawe bhahaakɨtʉʉra igʉrʉ wɨ ɨkɨkʉngʉ, korereke kɨmʉrɨkɨ bhʉʉsi bhanʉ bhari munyumba. ");
INSERT INTO ikz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɨbhuɨbhu, ubhwɨrʉ bhwanyu bhoreenderwa bhʉmʉrɨkɨ kʉbhaatʉ, korereke bharore amahocha gaanyu amazʉmu, bhagʉngɨ Wuusʉ wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mʉtakina kʉbha niizirɨ kuruushaho imigirʉ ja Musa, hamwɨ ganʉ gaagambirwɨ na abharʉʉtɨrɨri. Nitiizirɨ kuruushaho, nawe kokora na kuhicha amaheene gaaku. ");
INSERT INTO ikz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nɨrabhabhʉʉrɨra amaheene, kuhika hanʉ risaarʉ ni icharʉ bhikurweho, katareeho kangʼana hamwɨ kaandɨkʉ kasuuhu ki imigirʉ kanʉ kakuruusibhwaho kuhika gʉʉsi gahikɨ. ");
INSERT INTO ikz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araangɨ nʉʉrʉ umugirʉ gʉmwɨ umusuuhu kʉkɨra ɨgɨndɨ, na kwija abhandɨ bhakorebhu, wuyo atakʉbha na bhwera mʉbhʉtɨmi bhwa mwisaarʉ. Nawe wʉwʉʉsi wʉnʉ akugigwata na kwija abhandɨ bhakorebhu, wuyo arabha ʉmʉkʉrʉ mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mmbe, nɨrabhabhʉʉrɨra, arɨɨbhɨ eheene yaanyu ɨtakʉkɨra ya Abhafarisaayo na ya abhiija bhi imigirʉ ja Musa, mʉtakusikɨra zee mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwigwirɨ umugirʉ, chɨmbu abhaatʉ bhɨ ɨkarɨ bhaabhuuriirwɨ, ‘Utiita! Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwita ʉmʉkɨndichazɨ, areenderwa atinirwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nawe inyɨ nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwigatanɨra ʉmʉkɨndichazɨ, areenderwa kutinirwa. Wʉwʉʉsi wʉnʉ akʉtʉka ʉmʉkɨndichazɨ na komorega, areenderwa atinirwɨ ni ichandarʉ. Na wʉwʉʉsi wʉnʉ akʉbhʉʉrɨra ʉmʉkɨndichazɨ mogeege, areenderwa korekerwa momorero gwa nyaari! ");
INSERT INTO ikz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mmbe, ʉraahuruchɨ ikimweso ahagero hu ukuhurukirya ikimweso, akʉmara ʉkahiita kʉbha ʉtaamɨɨnʼyɨ nʉ ʉmʉkɨndichazʉ, ");
INSERT INTO ikz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tiga ikimweso chazʉ mʉbhʉtangɨ bhwa ahagero hu ukuhurukirya ikimweso, nuujɨ hinga wiigwanɨ nawe. Neho ʉgarʉkɨ uhuruchɨ ikimweso chazʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na arɨɨbhɨ ʉmʉkʉgambi arakuhira kumutiniri, wiigwanɨ nawe bhwangʉ mʉkɨɨrɨ mʉnzɨra. Ɨrɨɨtamɨbhu, arakuhicha kumutiniri. Nu umutiniri wuyo arakuhira kumusirikarɨ, korereke akusikiryɨ mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nɨrakʉbhʉʉrɨra amaheene, ʉtakurwa muyo kuhika hanʉ ʉkʉmara kʉrɨha isiirɨ yʉʉsi! ");
INSERT INTO ikz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwigwirɨ umugirʉ gʉnʉ gwagambirwɨ kʉbha, ‘Ʉtasebheeta!’ ");
INSERT INTO ikz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nawe inyɨ nɨrabhabhʉʉrɨra, umusubhɨ wʉnʉ akorora ʉmʉkari kwa kumwigomba, amarirɨ kosebheeta nawe mumwʉyʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mmbe, arɨɨbhɨ iriisʉ ryazʉ ryu ubhuryʉ rɨragirya okore ʉbhʉbhɨ, ryihɨ ʉrɨtaashɨ kore. Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano na riisʉ rɨmwɨ, kʉkɨra kʉbha ni ibhiimʉ bhyʉsi na ʉkataashwa momorero gwa nyaari. ");
INSERT INTO ikz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No okobhoko kwazʉ ku ubhuryʉ kʉragirya okore ʉbhʉbhɨ, ʉkʉtɨnɨ ʉkʉtaashɨ kore. Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano no okobhoko kʉmwɨ, kʉkɨra kʉbha na amabhoko abhɨrɨ na ʉkarekerwa momorero gwa nyaari. ");
INSERT INTO ikz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na mwigwirɨ umugirʉ gʉnʉ gwagambirwɨ kʉbha, ‘Ʉmʉʉtʉ wʉnʉ akʉtaana na mʉkaazɨ, amohe ɨnyarʉbha yʉ ʉkʉtaana.’ ");
INSERT INTO ikz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nawe inyɨ nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉnʉ akutiga mʉkaazɨ, ɨtarɨ igʉrʉ wɨ ɨtaarʉ, arakora ʉmʉkari waazɨ kʉbha musimbɨ. Na wʉwʉʉsi wʉnʉ araakwɨrɨ ʉmʉkari wʉnʉ atigirwɨ, wʉʉsi nɨ‑mʉsɨbhɨɨti. ");
INSERT INTO ikz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mwigwirɨ umugirʉ, chɨmbu abhaatʉ bhɨ ɨkarɨ bhaabhuuriirwɨ, ‘Mutiirahɨra ʉrʉrɨmɨ, nawe mokorere Ʉmʉkʉrʉ gʉʉsi ganʉ mwirahiirɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nawe inyɨ nɨrabhabhʉʉrɨra, mʉtagema kwirahɨra! Mutiirahɨra nʉʉrʉ kwa risaarʉ, kʉ kʉbha necho ikitumbɨ chɨ ɨkɨtɨmi cha Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Hamwɨ mutiirahɨra kʉʉsɨ yɨnʉ, kʉ kʉbha neho hʉ ʉkʉtʉʉra amagʉrʉ gaazɨ. Mutiirahɨra nʉʉrʉ kʉrʉbhɨri rwa Yɨrusarɨɨmu, kʉ kʉbha nerwe ʉrʉbhɨri rwʉ Ʉmʉtɨmi ʉmʉkʉrʉ, Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naabha mutiirahɨra kumitwɨ janyu, kʉ kʉbha mʉtakʉtʉra kuchʉra nʉʉrʉ uruzwɨrɨ rʉmwɨ rʉbhɨ rwɨrʉ hamwɨ rwirabhuru. ");
INSERT INTO ikz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Arɨɨbhɨ muriisirirya ‘Hee,’ ɨbhɨ amaheeneheene, arɨɨbhɨ mʉraanga ‘Zɨyi,’ ɨbhɨ maheene zɨyi. Amangʼana agandɨ ganʉ mukwongera, gararwa kʉmʉbhɨ, Shɨtaani. ");
INSERT INTO ikz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwigwirɨ umugirʉ gʉnʉ gwagambirwɨ kʉbha, ‘Iriisʉ kwi iriisʉ, ni iriinʉ kwi iriinʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nawe inyɨ nɨrabhabhʉʉrɨra, mʉtarɨhanʼya amabhɨ ʉmʉʉtʉ wʉnʉ abhakʉrɨɨrɨ amabhɨ. Nawe ʉmʉʉtʉ areekoteme kʉʉrʉsa rwu ubhuryʉ, muchʉrɨrɨ nʉ ʉrʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nʉ ʉmʉʉtʉ arɨɨkʉgambɨ korereke agege ɨshadi yaazʉ, mutigɨrɨ nɨ ɨkabhuuti. ");
INSERT INTO ikz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Arɨɨbhɨ ʉmʉʉtʉ arɨɨkʉhatɨkɨ kogega umurigʉ gwazɨ kuhika kogenda matambʉka kɨkwɨ kɨmwɨ, awɨ nuujɨ nawe matambʉka bhɨkwɨ bhɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ʉmʉʉtʉ araakʉsabhɨ ekegero, mohe. Nʉ ʉmʉʉtʉ arɨɨsabhɨ omokopeshe, ʉtamwima. ");
INSERT INTO ikz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwigwirɨ yagambirwɨ kʉbha, ‘Ʉmʉsɨɨgɨ nyarʉbhɨri waazʉ, na ubhiihirirwɨ umubhisa waazʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nawe inyɨ nɨrabhabhʉʉrɨra, mʉbhasɨɨgɨ abhabhisa bhaanyu, na mʉbhɨ mʉrasabhɨra bhanʉ bhakʉbhanyaacha. ");
INSERT INTO ikz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mmbe, mokorebhu, korereke mʉbhɨ ncha Wuusʉ wa mwisaarʉ. Ewe ahaabhanzɨra iryʉbha abhaatʉ abhazʉmu na abhabhɨ. Na ahaatwekerya imbura abhaatʉ bhe eheene na bhanʉ bhataana eheene. ");
INSERT INTO ikz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nangʉ mʉraasɨɨgɨ bhanʉ bhabhasɨɨgirɨ abheene, mʉrabhona bhwerakɨ? Nʉʉrʉ abhabhɨ ncha abharihya bha rigʉʉti bhʉʉsi bhahaakorabhu. ");
INSERT INTO ikz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na arɨɨbhɨ mʉrakeerya abhakɨndichanyu abheene, mʉrabha mʉrakora ingʼanakɨ rɨnʉ rɨkʉkɨra abhandɨ? Nʉʉrʉ abhaatʉ bhanʉ bhatɨɨzɨ Mungu, bhʉʉsi bhahaabhakeerya abhakɨndichabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mmbe, mʉbhɨ bharonge, chɨmbu Wuusʉ wa mwisaarʉ arɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwangarɨrɨ! Mʉtakora amahocha amazʉmu korereke abhaatʉ bhabharore. Nawe mʉraakorebhu, mʉtakʉsʉngʼaana ʉmʉbhanʉ gwʉgwʉsi kurwa kwa Wuusʉ wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mmbe, hanʉ ʉkʉsakirya ʉmʉhabhɨ, ʉtaraarɨka kɨnʉ okokora. Ʉtakora chɨmbu abhabhɨɨhi bhahaakora mʉmarwazɨrʉ na kʉnzɨra korereke abhaatʉ bhabhagʉngɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nɨrabhabhʉʉrɨra amaheene, ebho bhamarirɨ kʉsʉngʼaana ʉmʉbhanʉ gwabhʉ. Nawe hanʉ ʉkʉsakirya ʉmʉʉtʉ, okobhoko kwazʉ kwʉ ʉbhʉmʉsi kʉtamenya ganʉ okobhoko ku ubhuryʉ kokokora, ");
INSERT INTO ikz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","korereke ʉbhʉsakirya bhwazʉ bhʉbhɨ bhwa mbisi. Oreekorebhu, Wuusʉ wʉnʉ ahaarora ganʉ giibhisirɨ, arakʉsamba. ");
INSERT INTO ikz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na hanʉ mʉkʉsabha, mʉtabha ncha abhabhɨɨhi. Ebho bhahaasɨɨga kʉsabha bhiimiiriirɨ mʉmarwazɨrʉ na rusizʉ wɨ ɨnzɨra korereke abhaatʉ bhabharore. Nɨrabhabhʉʉrɨra amaheene, bhamarirɨ kʉsʉngʼaana ʉmʉbhanʉ gwabhʉ gwʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nawe awɨ hanʉ ʉkʉsabha, usikɨrɨ ɨgatɨ na wiigarɨ ikisikʉ. Akʉmara ʉsabhɨ kwa Wuusʉ wʉnʉ atakororekana. Na Wuusʉ wʉnʉ ahaarora ganʉ giibhisirɨ, arakutuha. ");
INSERT INTO ikz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hanʉ mʉkʉsabha, mʉtabha mʉraparʉkaparʉka ncha abhaatʉ bhanʉ bhatɨɨzɨ Mungu. Ebho bhahiiseega kʉbha bhariigwa igʉrʉ wa amangʼana amaaru. ");
INSERT INTO ikz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mʉtatuubhana na bhayo, kʉ kʉbha Wuusʉ amɨnyirɨ ganʉ mukwenda, nʉʉrʉ mʉkɨɨrɨ kʉmʉsabha. ");
INSERT INTO ikz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mmbe imwɨ mʉsabhɨbhu: ‘Bhaabha wɨɨtʉ wʉnʉ uri mwisaarʉ, iriina ryazʉ rikumibhwɨ. Ʉbhʉtɨmi bhwazʉ bhuuzɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ubhwɨndi bhwazʉ bhokorwe mʉʉsɨ hanʉ, chɨmbu mwisaarʉ iyo. ");
INSERT INTO ikz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Otohe reero ibhyakurya bhyɨtʉ bhya kɨrakabhu. ");
INSERT INTO ikz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Otobheerere ʉbhʉbhɨ bhwɨtʉ, chɨmbu na niitwɨ tʉkʉbhabheerera bhanʉ bhatʉsaririiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ʉtatusikirya mubhitiimotiimo, nawe ʉtʉsabhʉrɨ nʉ ʉmʉbhɨ wurya, kʉ kʉbha ʉbhʉtɨmi, na zinguru, nu ubhukumibhwa, ni‑bhyazʉ kemerano. Garamɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yɨɨsu akangʼeha kʉgamba, “Arɨɨbhɨ mʉrabheerera abhaatʉ ʉbhʉbhɨ bhwabhʉ, imwʉsi Wuusʉ wa mwisaarʉ arabhabheerera. ");
INSERT INTO ikz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nawe mʉraatamɨ kobheerera abhaatʉ amabhɨ gaabhʉ, na niimwɨ Wuusʉ wa mwisaarʉ atakʉbhabheerera amabhɨ gaanyu. ");
INSERT INTO ikz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hanʉ mukwiyima kurya, ubhushʉ bhwanyu bhoteerekanʼya kurumɨka chɨmbu abhabhɨɨhi bhahaakora. Ebho bhahaakikinyara ubhushʉ bhwabhʉ korereke abhaatʉ bharore kʉbha bhiiyimirɨ kurya. Nɨrabhabhʉʉrɨra amaheene, bhamarirɨ kʉsʉngʼaana ʉmʉbhanʉ gwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nawe awɨ hanʉ ukwiyima ukurya, wiisaabhɨ ubhushʉ na wisisityɨ amaguta mumutwɨ, ");
INSERT INTO ikz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","korereke abhaatʉ bhatamenya kʉbha wiiyimirɨ kurya. Wuusʉ wʉnʉ atakororekana, wʉnʉ ahaarora ganʉ giibhisirɨ, arakʉsamba. ");
INSERT INTO ikz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mutiibhɨɨkɨra ikibhumbɨkʉ mʉʉsɨ, hanʉ amasɨrɨbhɨ ni ikutu bhɨhaasarya, na abhiibhi bharaasha zinyumba korereke bhiibhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nawe mwibhɨɨkɨrɨ ikibhumbɨkʉ mwisaarʉ, ɨnʉ amasɨrɨbhɨ ni ikutu bhɨtakʉsarya na hanʉ abhiibhi bhatakwasha nʉʉrʉ kwibha. ");
INSERT INTO ikz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hʉhʉʉsi hanʉ ikibhumbɨkʉ chazʉ kɨrɨ, neho ne ekoro yaazʉ ɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amɨɨsʉ nego ɨkɨmʉrɨ chʉ ʉmʉbhɨrɨ. Arɨɨbhɨ mahʉru, ʉmʉbhɨrɨ gwazʉ gwʉsi gʉrabha nu ubhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nawe arɨɨbhɨ amɨɨsʉ gaazʉ marwɨrɨ, ʉmʉbhɨrɨ gwazʉ gwʉsi gʉrabha kiirimya. Mmbe, ubhwɨrʉ bhʉnʉ bhʉrɨ mʉmʉbhɨrɨ bhuriichʉrɨ kʉbha ikiirimya, kɨrabha kiirimya kɨhaari bhʉkʉngʼu! ");
INSERT INTO ikz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kohokerya abhakʉrʉ bhabhɨrɨ, kʉ kʉbha aratʉra kubhiihirirwa ʉwʉmwɨ na kʉsɨɨga ʉwʉndɨ, hamwɨ kugwatana nʉ ʉwʉmwɨ na korega ʉwʉndɨ. Na niimwɨ, mʉtakʉtʉra kohokerya Mungu ne ebhegero hamwɨmwɨ! ");
INSERT INTO ikz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mmbe nɨrabhabhʉʉrɨra, mʉtanyaakɨra ubhwikari bhwanyu kʉbha mʉraryakɨ, hamwɨ mʉranywakɨ, hamwɨ muriibhohakɨ. Awɨɨ, ubhwikari bhʉtakʉkɨra ibhyakurya, nʉ ʉmʉbhɨrɨ gʉtakʉkɨra zengebho? ");
INSERT INTO ikz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Morore ibhinyunyi. Bhɨtakʉhamba na bhɨtakogesa na kʉbhɨɨka mʉkɨtara. Nawe, Wuusʉ wa mwisaarʉ, ahaabhiriisha. Awɨɨ, imwɨ mʉtaana ubhwera bhʉkʉrʉ kʉkɨra ibhinyunyi bhiyo? ");
INSERT INTO ikz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wɨɨwɨ gatɨ waanyu aratʉra kwiyongera nʉʉrʉ ɨɨsa yɨmwɨ mubhwikari bhwazɨ kukwinyaacha kwazɨ? ");
INSERT INTO ikz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwakɨ muriinyaacha igʉrʉ wa zengebho? Morore chɨmbu ɨbhɨbharyʉ bhekomera. Bhɨtakokora meremo nʉʉrʉ bhɨtakutuma. ");
INSERT INTO ikz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nawe nɨrabhabhʉʉrɨra, nʉʉrʉ ʉmʉtɨmi Sɨrɨmaani nu ubhuniibhi bhwazɨ bhwʉsi, atiibhʉhirɨ bhwaheene nchɨ ɨbhɨbharyʉ bhiyo! ");
INSERT INTO ikz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Arɨɨbhɨ Mungu ariibhohya bhwaheenebhu ɨbhɨbharyʉ bhya mwitɨrɨgʉ bhɨnʉ reero bhereho na tabhʉʉri bhɨrataashwa momorero, nangʉ aratamabhwɨ kubhiibhohya imwɨ, abhaatʉ bhu ubhwisirirya ubhusuuhu? ");
INSERT INTO ikz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mmbe mʉtabha na makɨbhwɨ muriibhuurya, ‘Tʉraryakɨ? Tʉranywakɨ?’ hamwɨ ‘Turiibhohakɨ?’ ");
INSERT INTO ikz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Amangʼana gayo gʉʉsi, bharaganyaakɨra abhaatʉ bhanʉ bhatɨɨzɨ Mungu. Wuusʉ wa mwisaarʉ ɨɨzɨ kʉbha moreenda gʉʉsi gayo. ");
INSERT INTO ikz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nawe momohye hinga ʉbhʉtɨmi bhwa Mungu na kokora amangʼana ge eheene, na agandɨ gayo gʉʉsi arabhoongereererya. ");
INSERT INTO ikz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mmbe, mutiinyaacha igʉrʉ wa tabhʉʉri, kʉ kʉbha tabhʉʉri iriinyaakɨra iyeene. Zɨnyaakʉ za reero ziriisa kwa reero. ");
INSERT INTO ikz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mʉtatɨnɨra abhandɨ, korereke mʉtaaza kutinirwa na Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chɨmbu mʉkʉtɨnɨra abhandɨ, nɨmbu imwʉsi mʉraatinirwɨ. Ne ekerengo kɨnʉ mokorengera abhandɨ, necho mʉraarengerwe. ");
INSERT INTO ikz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ndora ʉrarora ekebhereera kɨnʉ kiri muriisʉ ryʉ ʉmʉkɨndichazʉ, nawe ʉtakorora ɨkɨtɨnɨka kɨnʉ kiri muriisʉ ryazʉ? ");
INSERT INTO ikz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kisha ʉratʉrabhwɨ kʉbhʉʉrɨra ʉmʉkɨndichazʉ, ‘Tiga nikuruushɨ ekebhereera muriisʉ ryazʉ,’ nawe ʉtakorora ɨkɨtɨnɨka muriisʉ ryazʉ? ");
INSERT INTO ikz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ʉmʉbhɨɨhi awɨ! Ruusha hinga ɨkɨtɨnɨka muriisʉ ryazʉ. Neho ʉkʉtʉra korora bhwaheene na kuruusha ekebhereera muriisʉ ryʉ ʉmʉkɨndichazʉ. ");
INSERT INTO ikz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mʉtaha zimbwa ebhegero ɨbhɨrɨndu, korereke zɨtaaza kwichʉra zɨbhanyamʉrɨ. Na mʉtataashirya zingurubhɨ ebhegero bhyu ubhwera, zɨtaaza kʉbhɨtazataza. ");
INSERT INTO ikz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mʉsabhɨ Mungu, na niimwɨ mʉrahaabhwa. Momohye, na niimwɨ mʉrabhona. Muhunɨ ikisikʉ, na niimwɨ muriigurirwa. ");
INSERT INTO ikz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wʉwʉʉsi wʉnʉ akʉsabha, arahaabhwa. Wʉnʉ akomohya, arabhona, na wʉnʉ akuhuna ikisikʉ, ariigurirwa. ");
INSERT INTO ikz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nangʉ, wɨɨwɨ gatɨ waanyu, wʉnʉ umwana waazɨ araasabhɨ ʉmʉkaatɨ, aramoha riibhwɨ? ");
INSERT INTO ikz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hamwɨ araasabhɨ iiswɨ, aramoha enzoka? ");
INSERT INTO ikz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Arɨɨbhɨ imwɨ abhabhɨ, mwɨzɨ kʉbhaha abhaana bhaanyu ebhegero ɨbhɨzʉmu. Wuusʉ wa mwisaarʉ atakʉtʉra kʉbhaha amazʉmu kʉkɨraho, bhanʉ bhakʉmʉsabha? ");
INSERT INTO ikz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mmbe, mokorere abhandɨ ganʉ mukwenda mokorerwe. Yiyo neyo enzobhooro yi imigirʉ ja Musa na amiija ga abharʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Musikɨrɨ kʉhɨtɨra ikisikʉ ikigutɨ. Ikishoko ɨkɨgarɨ nɨ ɨnzɨra ɨngarɨ bhiyo bhɨrahira ʉmʉʉtʉ kurichwa. Abhaatʉ bhanʉ bhakʉhɨtɨra iyo, nɨ‑bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nawe ikishoko kɨnʉ kikwerekera kʉbhʉhʉru, ni‑kigutɨ, nɨ ɨnzɨra yu ukwerekera iyo, ni‑ngutɨ. Na bhanʉ bhakoyerora, nɨ‑bhasuuhu. ");
INSERT INTO ikz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwiyangarɨrɨ na abharʉʉtɨrɨri bhʉ ʉrʉrɨmɨ. Hanʉ bhakubhaazaku, bhararorekana ncha zɨngʼʉndu, nawe nɨ‑bhahaari ncha zisuuzɨ. ");
INSERT INTO ikz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mʉrabhamenya kumisumʉ jabhʉ. Awɨɨ abhaatʉ bhahaatwa zɨzabhiibhu kʉmɨtɨ ja amahwa, hamwɨ imisumʉ ju umutiini komesonkoma? ");
INSERT INTO ikz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ʉmʉtɨ ʉmʉzʉmu gwahiibhʉra imisumʉ ɨmɨzʉmu, nawe ʉmʉtɨ ʉmʉbhɨ guhiibhʉra imisumʉ ɨmɨbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ʉmʉtɨ ʉmʉzʉmu gʉtakʉtʉra kwibhʉra imisumʉ ɨmɨbhɨ, nʉ ʉmʉtɨ ʉmʉbhɨ gʉtakʉtʉra kwibhʉra imisumʉ ɨmɨzʉmu. ");
INSERT INTO ikz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɨmɨtɨ jʉsi gɨnʉ gɨtakwibhʉra imisumʉ ɨmɨzʉmu, gɨhaatinwa na kʉtaashwa momorero. ");
INSERT INTO ikz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ɨbhuɨbhu na abharʉʉtɨrɨri bhʉ ʉrʉrɨmɨ, mʉrabhamenya kʉmahocha gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ɨtarɨ bhaatʉ bhʉʉsi bhanʉ bhakʉmbʉʉrɨra, ‘Ʉmʉkʉrʉ, Ʉmʉkʉrʉ,’ bharasikɨra mʉbhʉtɨmi bhwa mwisaarʉ. Nawe nɨ‑bhanʉ bhakokora ubhwɨndi bhwa Bhaabha waanɨ wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Urusikʉ rwɨ ɨtɨnɨrʉ rʉraahikɨ, bhaaru bharaaza kʉmbʉʉrɨra, ‘Ʉmʉkʉrʉ, Ʉmʉkʉrʉ! Tʉkarootorera kuriina ryazʉ, tʉkaheebha amasambwa kuriina ryazʉ, na tʉkakora ɨbhɨsɨgʉ bhyaru kuriina ryazʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Neho nɨraabhabhʉʉrɨrɨ, ‘Nɨtabhɨɨzɨ nʉʉrʉ hasuuhu! Mundwɨrɨ hanʉ, imwɨ abhakʉri bhʉ ʉbhʉbhɨ!’ ");
INSERT INTO ikz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mmbe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwigwa amangʼana gaanɨ na kʉgakora, aangɨ ʉmʉʉtʉ wa amangʼɨɨni wʉnʉ ʉmbakirɨ inyumba yaazɨ kwitarɨ. ");
INSERT INTO ikz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Rusikʉ rʉmwɨ, imbura ikatweka, amanzi gakarembeera igʉrʉ, nʉ ʉmʉkama ʉmʉhaari gʉkahuuta na kusukuma inyumba yaazɨ. Nawe ɨtaagwirɨ, kʉ kʉbha ʉbhʉrʉsa bhwaku bhʉkʉʉmbakwa kwitarɨ. ");
INSERT INTO ikz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nawe wʉwʉʉsi wʉnʉ akwigwa amangʼana gaanɨ na atigɨ kʉgakora, wuyo aangɨ ʉmʉʉtʉ omogeege wʉnʉ ʉmbakirɨ inyumba yaazɨ komosekeenya. ");
INSERT INTO ikz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hanʉ imbura yatwɨkirɨ, amanzi gakarembeera igʉrʉ, nʉ ʉmʉkama ʉmʉhaari gʉkahuuta na kusukuma inyumba yiyo, ɨkahingʉka, ɨkarika.” ");
INSERT INTO ikz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo, riribhita rya abhaatʉ rɨkarʉgʉʉra bhʉkʉngʼu igʉrʉ wa amiija gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Abhaatʉ bhakarʉgʉʉra kʉ kʉbha amiija gaazɨ gataarɨ ncha garya abhiija bhaabhʉ bhi imigirʉ ja Musa bhahiija, nawe akiija nchʉ ʉmʉʉtʉ wʉ ʉbhʉnaja. ");
INSERT INTO ikz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hanʉ Yɨɨsu iikirɨ kurwa kʉkɨgʉrʉ, amaribhita amakʉrʉ ga abhaatʉ gakamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Akaaza ʉmʉʉtʉ wʉmwɨ we ebhegenge akahigama mʉbhʉtangɨ bhwazɨ, arabhuga, “Ʉmʉkʉrʉ, ʉraasɨɨgɨ, ʉratʉra kʉmbɨngukya!” ");
INSERT INTO ikz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yɨɨsu akagorora okobhoko kwazɨ, akamukunʼyaku, arabhuga, “Nɨsɨɨgirɨ. Bhɨngukibhwa!” Hayohayo, akahora ebhegenge bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Akʉmara, Yɨɨsu akamʉbhʉʉrɨra, “Yangarɨra, ʉtabhʉʉrɨra ʉmʉʉtʉ igʉrʉ wa rɨnʉ nɨkʉrirɨ. Nawe wiiyeerekenʼye kwa kuhaani, uhuruchɨ ikimweso chɨmbu Musa aaswajiryɨ, kwerecha abhaatʉ kʉbha ʉbhɨngukiibhwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hanʉ Yɨɨsu aarɨ arasikɨra mʉrʉbhɨri rwa Kapɨrinaumu, ʉmʉkʉrʉ wʉmwɨ wa abhasirikarɨ bhi Ikiruumi akaaza kwawe kʉmʉsabha amʉsakiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, omohocha waanɨ ari yɨɨka murwɨrɨ, akuurɨ ibhiimʉ, ariiyigwa kɨbhɨ bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yɨɨsu akamʉgarukirya, “Nɨraaza komohorya.” ");
INSERT INTO ikz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ʉmʉkʉrʉ wa abhasirikarɨ wuyo akabhuga, “Ʉmʉkʉrʉ, ɨtakwenderwa usikɨrɨ ɨwaanɨ. Nawe gamba ingʼana rɨmwɨbhu, omohocha waanɨ arahora. ");
INSERT INTO ikz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Inyɨ niri iyaasɨ wʉ ʉbhʉnaja bhwa abhandɨ, na nɨna abhasirikarɨ bhanʉ bhari iyaasɨ waanɨ. Nɨraabhʉʉrɨrɨ wʉmwɨ, ‘Nuujɨ,’ ahaaja. Nɨraabhʉʉrɨrɨ ʉwʉndɨ, ‘Nauzɨ,’ ahaaza. Na nɨraabhʉʉrɨrɨ mbʉʉsa waanɨ, ‘Kora omoremo gʉnʉ,’ ahaakora.” ");
INSERT INTO ikz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hanʉ Yɨɨsu iigwirɨ amangʼana gayo, akarʉgʉʉra bhʉkʉngʼu. Akabhabhʉʉrɨra bhanʉ bhaarɨ bharamutuna, “Nɨrabhabhʉʉrɨra amaheene, nʉʉrʉ gatɨ wa Abhiiziraɨri bhʉʉsi, nɨkɨɨrɨ korora ʉmʉʉtʉ wʉwʉʉsi wu ubhwisirirya ʉbhʉkʉrʉ ncha bhʉnʉ! ");
INSERT INTO ikz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nɨrabhabhʉʉrɨra, abhaatʉ bhaaru bharaaza kurwa mbaara zʉʉsi zɨ ɨɨsɨ. Bharaaza kurya ɨnyangi hamwɨmwɨ na bhasʉʉkʉrʉ bhɨɨtʉ Abhurahaamu, Iisaka na Yaakobho mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nawe abhagabhi bhanʉ bhɨɨndirwɨ kʉbha mʉbhʉtɨmi bhuyo, bhararekerwa igʉtʉ mukiirimya, iyo bhararɨra na kokepeha.” ");
INSERT INTO ikz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mmbe, Yɨɨsu akabhʉʉrɨra ʉmʉkʉrʉ wuyo, “Nuujɨ yɨɨka. Ɨrabha chɨmbu wiisiriiryɨ.” Hayohayo omohocha waazɨ akahora. ");
INSERT INTO ikz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Akʉmara Yɨɨsu akahika wa Peetero. Hanʉ aasikiirɨ munyumba, akabhona uninabhyara Peetero ahindiirɨ kʉbhʉrɨrɨ, ane ehooma haari. ");
INSERT INTO ikz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yɨɨsu akamukunʼyaku kokobhoko, hayohayo akahora. Akabhʉʉka, akatanga komohokerya ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hanʉ ryahikirɨ rigoroobha, Yɨɨsu akareeterwa abhaatʉ bhaaru bha amasambwa. Akaruusha amasambwa gayo kwa kʉgamba, na akahorya abharwɨrɨ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neho rɨkabha ringʼana rɨnʉ ryagambirwɨ igʉrʉ waazɨ nʉ ʉmʉrʉʉtɨrɨri Isaaya, “Akagega ʉbhʉnyʉʉhɨrɨru bhwɨtʉ umwene, na akagega amarwɨrɨ gɨɨtʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hanʉ Yɨɨsu aarʉʉzɨ abhaatʉ bhaaru bhamwinaarirɨ, akaswaja abhɨɨga bhaazɨ, bhaambʉkɨ ɨnyanza bhajɨ imwambʉkʉ. ");
INSERT INTO ikz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Umwija wʉmwɨ wi imigirʉ ja Musa akamujaku, akamʉbhʉʉrɨra, “Umwija, hʉhʉʉsi hanʉ ʉraajɨ, nɨrakutuna.” ");
INSERT INTO ikz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yɨɨsu akamʉgarukirya, “Bhanyamubhwɨ bhaana amabhigi ni ibhinyunyi bhini ibhinyumba. Nawe, Umwana wʉ Ʉmʉʉtʉ, ataana nʉʉrʉ hʉ ʉkʉtʉʉra ʉrʉbharu rwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nu umwɨga ʉwʉndɨ akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, nyiisiririrya hinga nijɨ kʉbhɨɨka bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nawe Yɨɨsu akamʉbhʉʉrɨra, “Ntuna, tiga abhaku bha zekoro bhabhɨɨkɨ abhaku abhakɨndichabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Neho Yɨɨsu akatiira mubhwatʉ hamwɨmwɨ na abhɨɨga bhaazɨ, bhakabhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hanʉ bhaahikirɨ gatɨgatɨ wɨ ɨnyanza, kɨtʉkɨrʉ kʉkabha nʉ ʉmʉkama ʉmʉhaari bhʉkʉngʼu na amakunda gakatanga kukundikirya ubhwatʉ. Yɨɨsu zaarɨ zimuhirirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abhɨɨga bhaazɨ bhakamubhuucha, bhakarɨgɨsa bharabhuga, “Ʉmʉkʉrʉ, tʉsabhʉrɨ! Tʉrarika!” ");
INSERT INTO ikz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yɨɨsu akabhabhʉʉrɨra, “Kwakɨ mʉrʉʉbhaha, imwɨ bhu ubhwisirirya ubhusuuhu?” Neho akiimɨɨrɨra, akahama ʉmʉkama na amakunda, kʉkabha bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abhɨɨga bhaazɨ bhakarʉgʉʉra, bhakabhuga, “Ʉmʉʉtʉ wʉnʉ nɨ‑wa teemwakɨ? Nʉʉrʉ ʉmʉkama na amakunda bhɨramwigwa!” ");
INSERT INTO ikz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hanʉ Yɨɨsu aambukirɨ ɨnyanza, akahika mucharʉ cha Abhagadara. Akarumana na abhaatʉ bhabhɨrɨ bha amasambwa, bhararwa mʉmabhigi ganʉ gaarɨ zimbihɨra.Abhaatʉ bhayo bhaarɨ bhahaari bhʉkʉngʼu na atareeho ʉmʉʉtʉ wʉnʉ aagɨmirɨ kʉhɨta kʉnzɨra yiyo. ");
INSERT INTO ikz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mmbe, amasambwa gakarɨgɨsa garabhuga, “Umwana wa Mungu, ʉnakɨ na niitwɨ? Nangʉ, wiizirɨ kuturicha ribhaga ryɨtʉ rɨkɨɨrɨ kuhika?” ");
INSERT INTO ikz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Haguhɨ hayo, ryareho rihizʉ ikʉrʉ rya zingurubhɨ rɨrariisha. ");
INSERT INTO ikz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Amasambwa gayo gakiisasaama Yɨɨsu, “Arɨɨbhɨ ʉratoheebha, utwisiririryɨ tusikɨrɨ mwihizʉ rya zingurubhɨ rirya.” ");
INSERT INTO ikz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yɨɨsu akagabhʉʉrɨra, “Mujɨ!” Gakabharwɨku, gakasikɨra muzingurubhɨ. Hayohayo, rihizʉ ryʉsi rɨkahiringita mwega ikihiringitʉ ɨkɨhaari, rɨkagwa mʉnyanza, rɨkarika. ");
INSERT INTO ikz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hanʉ abhariisha bha zingurubhɨ bhaarʉʉzɨ gayo, bhakaryarɨra mʉrʉbhɨri, bhakabhʉʉrɨra abhaatʉ gʉʉsi ganʉ gakʉriibhwɨ na kɨnʉ chabhɨɨrɨ kʉbhanʉ bhaarɨ na amasambwa. ");
INSERT INTO ikz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abhaatʉ bhʉʉsi bha mʉrʉbhɨri muyo, bhakaryara kuja korora Yɨɨsu. Hanʉ bhaamʉrʉʉzɨ, bhakamʉsabha arwɨ mucharʉ chabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yɨɨsu akatiira mubhwatʉ, akaambʉka ɨnyanza ya Gariraaya, akagarʉka Kapɨrinaumu, mʉrʉbhɨri rʉnʉ iikɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hanʉ aahikirɨ, abhaatʉ abhandɨ bhakamoreeta ʉmʉʉtʉ akuurɨ ibhiimʉ, ahindiirɨ kʉkɨragʉ. Hanʉ Yɨɨsu aarʉʉzɨ ubhwisirirya bhwabhʉ, akabhʉʉrɨra umurwɨrɨ, “Ihaana umwʉyʉ, mwana waanɨ! Ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Neho abhiija abhandɨ bhi imigirʉ ja Musa, bhakiigambɨra mumyʉyʉ jabhʉ, “Ʉmʉʉtʉ wʉnʉ ararega Mungu!” ");
INSERT INTO ikz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nawe Yɨɨsu akamenya ganʉ bhaarɨ bhakwiseega, akabhuga, “Kwakɨ muriiseega amabhɨ mumyʉyʉ janyu? ");
INSERT INTO ikz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Rinyʉʉhu ni‑ryahe, ukubhuga, ‘Ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ,’ kisha ukubhuga, ‘Imɨɨrɨra, ogende?’ ");
INSERT INTO ikz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nereenda momenye kʉbha, Umwana wʉ Ʉmʉʉtʉ ahɨɨrwɨ ʉbhʉnaja bhwo okobheerera ʉbhʉbhɨ kʉʉsɨ.” Neho akabhʉʉrɨra ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ, “Imɨɨrɨra! Gega ɨkɨragʉ chazʉ, ujɨ yɨɨka.” ");
INSERT INTO ikz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hayohayo ʉmʉʉtʉ wuyo akiimɨɨrɨra, akaja yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hanʉ abhaatʉ bhaarʉʉzɨ gayo, bhakarʉgʉʉra na kwʉbhaha bhʉkʉngʼu. Bhakagʉnga Mungu kʉ kʉbha akabhaha abhaatʉ ʉbhʉnaja ncha bhuyo. ");
INSERT INTO ikz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hanʉ Yɨɨsu aaruurɨ hayo, mʉnzɨra akarora ʉmʉʉtʉ wʉmwɨ wʉnʉ akubhirikirwa Mataayo, iikɨɨrɨ mwibhuru ryʉ ʉkʉtɨnɨra rigʉʉti. Yɨɨsu akamʉbhʉʉrɨra, “Ntuna.” Mataayo akiimɨɨrɨra, akamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yɨɨsu akaja kurya ibhyakurya wa Mataayo hamwɨmwɨ na abhɨɨga bhaazɨ. Hanʉ bhaarɨ kwigari bhararya, bhakasikɨra abharihya bha rigʉʉti bhaaru na abhandɨ bhʉ ʉbhʉbhɨ, bhakiikara na kurya hamwɨmwɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hanʉ Abhafarisaayo bhaarʉʉzɨ riyo, bhakabhuurya abhɨɨga bha Yɨɨsu, “Ndora, umwija waanyu ararya hamwɨmwɨ na abharihya bha rigʉʉti na abhakʉri bhʉ ʉbhʉbhɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hanʉ Yɨɨsu iigwirɨbhu, akabhabhʉʉrɨra, “Abhaatʉ abhahʉru bhatakwenda ʉmʉgabhʉ, nawe abharwɨrɨ nebho bhakumwenda! ");
INSERT INTO ikz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nangʉ mwɨgɨ enzobhooro ya Amaandɨkʉ Amarɨndu ganʉ gakubhuga, ‘Nereenda mʉbhɨ nɨ ɨbhɨgʉngi kʉkɨra kuhurucha ikimweso.’ Inyɨ nitiizirɨ kʉbhɨrɨkɨra bhe eheene, nawe bhʉ ʉbhʉbhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Neho abhɨɨga bha Yoohana Ʉmʉbhatiizi bhakamujaku Yɨɨsu, bhakabhuurya, “Nɨkɨ itwɨ na Abhafarisaayo tuhiiyima kurya, nawe abhɨɨga bhaazʉ bhatakwiyima kurya?” ");
INSERT INTO ikz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yɨɨsu akabhagarukirya, “Abhahɨrɨɨkɨrɨri bhu umukwɨri, bharatʉrabhwɨ kwitiimaata hanʉ bhakʉbha hamwɨmwɨ nu umukwɨri? Nawe urusikʉ rʉraaza umukwɨri araruusibhwa gatɨ wa abhagini bhaazɨ. Hayo neho, bhariiyimɨ kurya. ");
INSERT INTO ikz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Atareeho ʉmʉʉtʉ wʉnʉ akogega ɨkɨraka ikihya akitumɨrɨ kongebho ikungu. Areekorebhu, ɨkɨraka ikihya kɨranyarya engebho yiyo na kwongera hanʉ hanyarirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na atareeho wʉnʉ akʉtʉʉra idivaayi iihya mʉbhɨgʉzi bhya amaseero amakungu. Areekorebhu, ɨbhɨgʉzi bhɨrabhaarʉka, idivaayi iriitɨka nɨ ɨbhɨgʉzi bhɨrasarɨka. Nawe, abhaatʉ bhahaatʉʉra idivaayi yɨnʉ ɨtatunduurirɨ mʉbhɨgʉzi ibhihya, ɨbhɨgʉzi ibhihya ni idivaayi yɨnʉ ɨtatunduurirɨ bhyʉsi bhɨrabha bhwaheene.” ");
INSERT INTO ikz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hanʉ Yɨɨsu aarɨ achagamba, akaaza ʉmʉkangati wʉmwɨ wi inyumba ya rirwazɨrʉ, akahigama mʉbhʉtangɨ bhwazɨ, akamʉbhʉʉrɨra, “Umuucha waanɨ akuurɨ nangwɨnʉbhu! Nangabha akuurɨ, tujɨ ʉtʉʉrɨ okobhoko kwazʉ igʉrʉ waazɨ, arahora.” ");
INSERT INTO ikz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yɨɨsu akabhʉʉka hamwɨmwɨ na abhɨɨga bhaazɨ, bhakatuna ʉmʉkangati wuyo. ");
INSERT INTO ikz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mmbe, ribhaga riyoriyo ʉmʉkari wʉmwɨ wʉnʉ aarɨ akʉnyaakibhwa nu ubhurwɨrɨ bhwɨ ɨngɨzi kwi imyaka ikumi nɨ ɨbhɨrɨ, akaaza inyuma wa Yɨɨsu, akakunʼyaku ripindʉ rye engebho yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akakorabhu, kʉ kʉbha akiigambɨra, “Nirikunʼyɨku engebho yaazɨ, nɨrahora.” ");
INSERT INTO ikz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hanʉ aakuniryɨkubhu, Yɨɨsu akiichʉra. Akamorora, akamʉbhʉʉrɨra, “Muucha, ihaana umwʉyʉ! Ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ.” Hayohayo, ʉmʉkari wuyo akahora. ");
INSERT INTO ikz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mmbe, hanʉ Yɨɨsu aahikirɨ munyumba yʉ ʉmʉkangati wa rirwazɨrʉ wuyo, akabhona abhaatʉ bhaaru bhiibhiringirɨ muruku hayo, ɨnʉ bhararɨra bhʉkʉngʼu na abhandɨ bharatema ebhereere. ");
INSERT INTO ikz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yɨɨsu akabhabhʉʉrɨra, “Murwɨ hanʉ! Umuucha wʉnʉ akɨɨrɨ kukwa, nawe ahindiirɨ.” Hanʉ bhiigwirɨbhu, bhakamoseka. ");
INSERT INTO ikz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mmbe hanʉ abhaatʉ bhaahurukiibhwɨ igʉtʉ, Yɨɨsu akasikɨra ɨgatɨ, akamugwata okobhoko umuucha wuyo, akiimɨɨrɨra! ");
INSERT INTO ikz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Amangʼana gayo gakanyaragana mucharʉ kirya chʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hanʉ Yɨɨsu aabhuukirɨ hayo, abhahʉku bhabhɨrɨ bhakamutuna, bhakabhɨrɨkɨra kwiraka ikʉrʉ, “Ʉmʉkʉrʉ, Umwana wʉ ʉmʉtɨmi Daudi, otororere ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hanʉ aasikiirɨ munyumba, abhahʉku bhayo bhakamutunamu. Yɨɨsu akabhabhuurya, “Muriisirirya kʉbha nɨranaja kʉbhahorya?” Bhakamʉgarukirya, “Hee, Ʉmʉkʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Neho akakunʼyaku amɨɨsʉ gaabhʉ, akabhabhʉʉrɨra, “Ɨbhɨ kwa niimwɨ chɨmbu mwisiriiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hayohayo, amɨɨsʉ gakarora. Yɨɨsu akakandikija kwa amanaga, “Mʉtabhʉʉrɨra ʉmʉʉtʉ wʉwʉʉsi amangʼana ganʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nawe bhakaja, kʉraarɨka amangʼana gaazɨ mucharʉ kirya chʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hanʉ abhahʉku bhayo bhaarɨ bhakurweho, abhandɨ bhakareetera Yɨɨsu ʉmʉʉtʉ wʉnʉ aarɨ na risambwa, wʉnʉ rɨmʉkʉrirɨ abhɨ imuumu. ");
INSERT INTO ikz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hanʉ Yɨɨsu aahɨɨbhirɨ risambwa riyo, ʉmʉʉtʉ wuyo akatanga kʉgamba. Abhaatʉ bhanʉ bhaarɨ hayo bhakarʉgʉʉra bhʉkʉngʼu, bhakabhuga, “Mucharʉ cha Iziraɨri rɨkɨɨrɨ kobhoneka ingʼana ncha rɨnʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nawe Abhafarisaayo bhakabhuga, “Araheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, ʉmʉkʉrʉ wa amasambwa!” ");
INSERT INTO ikz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mmbe, Yɨɨsu akabha ariiruguura mumijɨ na mʉzɨmbɨri zʉʉsi. Hʉhʉʉsi hanʉ aarɨ akʉhɨta, akasikɨra mʉmarwazɨrʉ kwija abhaatʉ. Aarɨ ararwaza Ɨngʼana Ɨnzʉmu igʉrʉ wʉ ʉbhʉtɨmi bhwa mwisaarʉ na aarɨ arahorya amarwɨrɨ gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hanʉ Yɨɨsu aarʉʉzɨ amaribhita ga abhaatʉ, akabharorera ɨbhɨgʉngi, kʉ kʉbha bhaarɨ bharanyaaka na bhataarɨ nʉ ʉmʉʉtʉ wʉ ʉkʉbhasakirya. Bhaarɨ ncha zɨngʼʉndu zɨnʉ zɨtaana umuriisha. ");
INSERT INTO ikz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Neho akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Amagesa maaru, nawe abhahocha, nɨ‑bhasuuhu. ");
INSERT INTO ikz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mmbe mʉsabhɨ Mungu newe umwene mʉgʉndʉ, korereke atʉmɨ abhahocha mʉmʉgʉndʉ gwazɨ, bhagese.” ");
INSERT INTO ikz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yɨɨsu akabhɨrɨkɨra abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akabhaha ʉbhʉnaja bhu ukuruusha amasambwa amabhɨ na bhwo okohorya amarwɨrɨ gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amariina ga abhɨɨga ikumi na bhabhɨrɨ bhayo, nɨ‑ganʉ: We embere ni‑Simʉʉni wʉnʉ akubhirikirwa Peetero, na Andureya umuhiiri waazɨ, Yaakobho umwana wa Zebhedaayo, na Yoohana umuhiiri waazɨ, ");
INSERT INTO ikz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firipʉ, Bhatoromayo, Tomaaso, Mataayo wʉnʉ aarɨ umurihya wa rigʉʉti, Yaakobho umwana wa Arifaayʉ, Tadaayo, ");
INSERT INTO ikz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simʉʉni Ʉmʉkananayʉ, enzobhooro yaku ni‑mwitaniri wi icharʉ chazɨ, na Yuuda Isikariyʉʉti wʉnʉ iichurirɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yɨɨsu akatʉma abhɨɨga ikumi na bhabhɨrɨ bhayo, akabharaganʼya, “Mʉtaja kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi, na mʉtasikɨra rʉbhɨri rwʉrwʉsi rwa Samaariya. ");
INSERT INTO ikz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nawe mujɨ kuBhiiziraɨri, bhayo nɨ‑zɨngʼʉndu zɨnʉ zibhurirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hanʉ mukuja kwebho, murwazɨ, ‘Ʉbhʉtɨmi bhwa mwisaarʉ bhʉraariirɨ!’ ");
INSERT INTO ikz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mohorye abharwɨrɨ, muryʉrɨ abhaku, mohorye bhe ebhegenge na moheebhe amasambwa. Mubhwɨnɨ ʉbhʉnaja bhuyo bhʉʉha, na niimwɨ muhuruchɨ bhʉʉha. ");
INSERT INTO ikz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na morogendo rwanyu mʉtagega ɨzahaabhu nʉʉrʉ mpirya nʉʉrʉ zishabha mʉbhɨgʉzi bhyanyu. ");
INSERT INTO ikz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mʉtabhanʉra ɨsakwa, hamwɨ ɨshadi ya kʉgarʉra, hamwɨ ibhikwɨra, hamwɨ ihimbʉ, kʉ kʉbha omohocha wʉʉsi areenderwa kʉhaabhwa amarihi. ");
INSERT INTO ikz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ʉrʉbhɨri rwʉrwʉsi rʉnʉ mʉraasikɨrɨ, momohye ʉmʉʉtʉ wʉnʉ akwisirirya kʉbhaginihya ɨwaazɨ. Mwikarɨ kwawɨ kuhika hanʉ mʉkʉbhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hanʉ mukusikɨra muwaazɨ, mʉsabhɨrɨ abhaatʉ bhaazɨ omorembe. ");
INSERT INTO ikz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Arɨɨbhɨ bharimu abhaatʉ bhanʉ bhakwenderwa, amakeerenʼya gaanyu garabhaha omorembe. Nawe arɨɨbhɨ bhatakwenderwa kʉsʉngʼaana, omorembe guyo gʉbhagarʉkɨrɨ imwɨ abheene. ");
INSERT INTO ikz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉraahikɨ munyumba hamwɨ ʉrʉbhɨri rwʉrwʉsi, na abhaatʉ bhakaanga kʉbhaginihya na kubhiitegeerera, hanʉ mukurwa ahagero hayo, mʉkʉngʼʉtɨ urutu kʉmagʉrʉ gaanyu, kobheerecha kʉbha Mungu arabhaanga. ");
INSERT INTO ikz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nɨrabhabhʉʉrɨra amaheene, urusikʉ rwɨ ɨtɨnɨrʉ, Mungu arabhaha ɨnyaakʉ bhʉkʉngʼu abhaatʉ bhʉ ʉrʉbhɨri ruyo, kʉkɨra abhaatʉ bha zɨmbɨri za Sodoma na Gomora! ");
INSERT INTO ikz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Rora, nɨrabhatʉma ncha zɨngʼʉndu gatɨ wa zisuuzɨ. Nangʉ, mʉbhɨ bhangʼɨɨni nche enzoka, na abhanyʉʉhu nchi ikiguuti. ");
INSERT INTO ikz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwiyangarɨrɨ na abhaatʉ, kʉ kʉbha bharabhahira kuchandarʉ, na bharabhatema ɨmɨzariti mʉmarwazɨrʉ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bharabhahira mʉbhʉtangɨ bhwa abhakangati na abhatɨmi igʉrʉ waanɨ. Moreenderwa kʉbha abhamɨnyɨɨkɨrɨri bhaanɨ mʉbhʉtangɨ bhwabhʉ na mʉbhʉtangɨ bhwa abhaatʉ bhanʉ bhatarɨ Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hanʉ bharaabhagwatɨ, mʉtabha na makɨbhwɨ kʉbha mʉragambakɨ hamwɨ mʉragambabhwɨ. Mungu arabhaha amangʼana gʉ ʉkʉgamba kwibhaga riyo. ");
INSERT INTO ikz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɨtarɨ kʉbha imwɨ mʉragamba, nawe ne‑Koro ya Wuusʉ neyo ɨraagambɨ kʉhɨtɨra kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ribhaga riyo, umuhiiri ariichʉra umuhiiri waazɨ korereke iitwɨ. Wiisɨ ariichʉra umwana waazɨ, na abhaana bhariitanʼya abhiibhuri bhaabhʉ na kugirya bhiitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abhaatʉ bhʉʉsi bharabhabhiihirirwa igʉrʉ waanɨ. Nawe wʉnʉ ariigumiriryɨ kuhika ɨtɨnɨrʉ, newe araasabhʉkɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mʉraakorwe kɨbhɨ mʉrʉbhɨri ororebhe, muryarɨrɨ mʉrʉbhɨri ʉrʉndɨ. Nɨrabhabhʉʉrɨra amaheene, mʉtakʉmara emeremo janyu mʉzɨmbɨri zʉʉsi za Iziraɨri, Umwana wʉ Ʉmʉʉtʉ akɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Umwɨga atakʉkɨra umwija waazɨ, na mbʉʉsa atakʉkɨra umuniibhi waazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umwɨga areenderwa abhɨ nchu umwija waazɨ, na mbʉʉsa abhɨ nchu umuniibhi waazɨ. Arɨɨbhɨ inyɨ ni‑muniibhi waanyu na bharambɨrɨkɨra Bhɨɨrizɨbhuri, nangʉ imwɨ, mʉrabhirikirwa amariina amabhɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mʉtʉʉbhaha abhaatʉ bhayo, kʉ kʉbha kɨtareeho kɨnʉ kikundikiriibhwɨ, kɨkatama kuhumburwa, na kɨnʉ kibhisirwɨ, kɨkatama kororekana. ");
INSERT INTO ikz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gʉʉsi ganʉ nɨkʉbhabhʉʉrɨra imwɨ mukiirimya, mʉgagambɨ habhwɨrʉ, na gʉʉsi ganʉ mukwigwa kwa mbisi, mʉgarwazɨ kʉbhaatʉ habhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉtʉʉbhaha bhanʉ bhakʉtʉra kwita ʉmʉbhɨrɨ, nawe bhatakʉnaja kwita ekoro yaanyu. Nawe mwʉbhahɨ Mungu, kʉ kʉbha newe akʉtʉra kuricha ʉmʉbhɨrɨ hamwɨmwɨ ne ekoro momorero gwa nyaari. ");
INSERT INTO ikz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Awɨɨ! Zɨsanzɨ ibhɨrɨ zɨtakuguribhwa ubhuguri ubhusuuhu? Nawe ɨtareeho naabha yɨmwɨ yɨnʉ ikugwa haasɨ iyeene, Wuusʉ atasɨɨgirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na niimwɨ, Mungu amɨnyirɨ endengo ya zinzwɨrɨ za kumitwɨ janyu. ");
INSERT INTO ikz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mmbe, mʉtʉʉbhaha, kʉ kʉbha imwɨ munu ubhwera kʉkɨra zɨsanzɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araanyiisiriryɨ mʉbhʉtangɨ bhwa abhaatʉ, na niinyɨ nɨramwisirirya mʉbhʉtangɨ bhwa Bhaabha wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nawe, wʉwʉʉsi wʉnʉ akʉnyanga mʉbhʉtangɨ bhwa abhaatʉ, na niinyɨ nɨramwanga mʉbhʉtangɨ bhwa Bhaabha wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mutiiseega kʉbha niizirɨ mʉʉsɨ koreeta omorembe. Nitiizirɨ koreeta omorembe, nawe ʉbhʉtaamanʼya. ");
INSERT INTO ikz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niizirɨ koreeta ʉbhʉtaamanʼya gatɨ wu umwana na wiisɨ, umuucha na unina, na gatɨ wʉ ʉmʉkamwana na uninabhyara. ");
INSERT INTO ikz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Abhabhisa bhʉ ʉmʉʉtʉ ni‑bhu uwaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wʉwʉʉsi wʉnʉ asɨɨgirɨ wiisɨ hamwɨ unina kʉkɨra chɨmbu ansɨɨgirɨ, atakwenderwa kʉbha mʉhɨmba waanɨ. Na wʉwʉʉsi wʉnʉ asɨɨgirɨ umwana waazɨ hamwɨ umuucha waazɨ kʉkɨra chɨmbu ansɨɨgirɨ, wʉʉsi atakwenderwa kʉbha mʉhɨmba waanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ʉmʉʉtʉ wʉnʉ atakogega ʉmʉsarabha gwazɨ na kuntuna, wuyo atakwenderwa kʉbha mʉhɨmba waanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ʉmʉʉtʉ wʉnʉ akwenda kohonʼya ʉbhʉhʉru bhwazɨ umwene, arabhurimirya. Nawe ʉmʉʉtʉ wʉnʉ akurimirya ʉbhʉhʉru bhwazɨ igʉrʉ waanɨ, arabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ʉmʉʉtʉ wʉnʉ akʉbhaginihya imwɨ, aranginihya na niinyɨ. Na wʉnʉ araanginihyɨ, araginihya na wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wʉnʉ akuginihya ʉmʉrʉʉtɨrɨri kʉ kʉbha nɨ‑mʉrʉʉtɨrɨri, Mungu aramʉbhanʉra ʉmʉbhanʉ ncha gwʉ ʉmʉrʉʉtɨrɨri. Na wʉnʉ akuginihya ʉmʉʉtʉ we eheene kʉ kʉbha ne‑we eheene, aramʉbhanʉra ʉmʉbhanʉ ncha gwa we eheene. ");
INSERT INTO ikz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wʉnʉ araamohe wʉmwɨ wa abhasuuhu bhanʉ ekekombe cha amanzi amamɨɨzu kʉ kʉbha nɨ‑mʉhɨmba waanɨ, nɨrabhabhʉʉrɨra amaheene, atakubhurwa ʉmʉbhanʉ gwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hanʉ Yɨɨsu aamarirɨ kuswaja abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akatanʉra kuja mʉzɨmbɨri ɨzɨndɨ za Gariraaya kwija na kurwazɨra abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ribhaga riyo, Yoohana Ʉmʉbhatiizi aarɨ mokebhoho. Hanʉ iigwirɨ ganʉ Kiriisitʉ akokora, akatʉma abhɨɨga bhaazɨ abhamwɨ bhamubhuuryɨ, ");
INSERT INTO ikz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Awɨ naawɨ Kiriisitʉ wʉnʉ akuuza, kisha tʉrɨndɨ ʉwʉndɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yɨɨsu akabhagarukirya, “Mujɨ mʉbhʉʉrɨrɨ Yoohana ganʉ gʉʉsi mukwigwa na korora. ");
INSERT INTO ikz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abhahʉku bhararora, abharema bharagenda, abhagenge bharahora, abharibhi bha amatwɨ bhariigwa, abhaku bhararyʉka na abhahabhɨ bhararwazirwa Ɨngʼana Ɨnzʉmu. ");
INSERT INTO ikz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hakɨrɨku ʉmʉʉtʉ wʉnʉ ataana makɨbhwɨ igʉrʉ waanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hanʉ abhɨɨga bha Yoohana bhaabhuukirɨ, Yɨɨsu akatanga kʉbhʉʉrɨra riribhita amangʼana igʉrʉ wa Yoohana. Akabhabhuurya, “Mʉkaja mwitɨrɨgʉ kororakɨ? Korora ʉmʉʉtʉ wʉnʉ akwisirirya amangʼana gʉʉsi ncha rikʉrɨ rɨnʉ rɨhaasingishwa nʉ ʉmʉkama? ");
INSERT INTO ikz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mʉkaja kororakɨ? Mʉkaja korora ʉmʉʉtʉ wʉnʉ iibhʉhirɨ zengebho zɨnzʉmu za riguri? Zɨyi! Abhaatʉ bhanʉ bhahiibhoha zengebho zɨnzʉmu za riguri, bhahiikara muzinyumba za abhatɨmi. ");
INSERT INTO ikz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nawe mʉkaja kororakɨ? Ʉmʉrʉʉtɨrɨri? Hee, nɨrabhabhʉʉrɨra, Yoohana nɨ‑mʉkʉrʉ kʉkɨra ʉmʉrʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wuyo newe wʉnʉ Amaandɨkʉ Amarɨndu gaagambirɨ igʉrʉ waazɨ, ‘Rora, nɨratʉma umutumwa waanɨ mʉbhʉtangɨ bhwazʉ, wʉnʉ araakokonzere ɨnzɨra.’ ");
INSERT INTO ikz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nɨrabhabhʉʉrɨra amaheene, mʉbhaatʉ bhʉʉsi bhanʉ bhiibhwirɨ kʉʉsɨ, akɨɨrɨ kobhoneka ʉmʉkʉrʉ kʉkɨra Yoohana Ʉmʉbhatiizi. Nawe, ʉmʉʉtʉ umusuuhu kʉkɨra bhʉʉsi mʉbhʉtɨmi bhwa mwisaarʉ, newe ʉmʉkʉrʉ kʉkɨra Yoohana. ");
INSERT INTO ikz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwɨma hanʉ Yoohana Ʉmʉbhatiizi aarɨ ararwaza kuhika reero yɨnʉ, abhaatʉ bhakɨɨrɨ bhariitanʼya ʉbhʉtɨmi bhwa mwisaarʉ, na abhaatʉ abhakararu bhareenda kobhogega kwa nguru. ");
INSERT INTO ikz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Amiija gʉʉsi ga abharʉʉtɨrɨri ni imigirʉ ja Musa bhɨkarootorera kuhika ribhaga rya Yoohana. ");
INSERT INTO ikz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Arɨɨbhɨ muriisirirya ʉbhʉrʉʉti bhwabhʉ, Yoohana newe Ɨɨriya, wʉnʉ aagambirwɨ kʉbha araaza. ");
INSERT INTO ikz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wʉ ʉkʉtwɨ, iitegeerere. ");
INSERT INTO ikz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nawe, urwibhʉrʉ rʉnʉ nirutuubhanʼyɨ nakɨ? Rutuubhɨɨnɨ na abhaana bhanʉ bhakwikara momoteera bharabhɨrɨkɨra abhakɨndichabhʉ, bharabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tʉkabhatemera ekereere, nawe mʉtaabhinirɨ! Tʉkɨɨmba amɨɨmbʉ gu ukwarama, nawe mʉtaaririrɨ!’ ");
INSERT INTO ikz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɨbhuɨbhu hanʉ Yoohana iizirɨ, aarɨ atakurya ibhyakurya bhya amanarʉ na atakunywa idivaayi, bhakabhuga, ‘Wʉnʉ ana amasambwa!’ ");
INSERT INTO ikz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Umwana wʉ Ʉmʉʉtʉ akaaza, ararya ibhyakurya bhya amanarʉ na kunywa idivaayi, bhakabhuga, ‘Rora! Nɨ‑mʉsʉʉhʉ, munywi, mʉsaani wa abharihya bha rigʉʉti na bhʉ ʉbhʉbhɨ!’ Nawe nʉʉrʉbhu, ubhwʉbhʉʉri bhwa Mungu bhʉhaamenyeekererya ga amaheene kʉnzɨra ya amahocha ga abhaatʉ bhaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Neho Yɨɨsu akatanga kʉhama zɨmbɨri zɨnʉ aakʉrirɨmu ɨbhɨsɨgʉ bhyaru, kʉ kʉbha zɨkaanga kutiga ʉbhʉbhɨ bhwazʉ. ");
INSERT INTO ikz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akabhuga, “Horeera imwɨ abhaatʉ bha Korazini! Horeera imwɨ, abhaatʉ bha Bhɨtɨsaida! Angabhɨɨrɨ ɨbhɨsɨgʉ bhɨnʉ bhyakʉriibhwɨ kwa niimwɨ, bhyangakʉrirwɨ mʉzɨmbɨri za abhasarya bha Tiiro na Sidʉʉni, bhaarɨ bharatiga ʉbhʉbhɨ bhwabhʉ kukwibhoha amagonera na kwihaka riibhu. ");
INSERT INTO ikz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nawe nɨrabhabhʉʉrɨra, urusikʉ rwɨ ɨtɨnɨrʉ, Mungu arabhaha imwɨ ɨnyaakʉ kʉkɨra abhaatʉ bha Tiiro na Sidʉʉni. ");
INSERT INTO ikz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na niimwɨ, abhaatʉ bha Kapɨrinaumu, muriiseega mʉratiiribhwa kuhika mwisaarʉ? Zɨyi! Muriikibhwa kuhika momorero gwa nyaari. Angabhɨɨrɨ ɨbhɨsɨgʉ bhɨnʉ bhɨkʉrirwɨ kwa niimwɨ bhyangakʉrirwɨ mʉrʉbhɨri rwa Sodoma, ʉrʉbhɨri ruyo rwarɨ rʉrabhaho kuhika reero yɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nawe nɨrabhabhʉʉrɨra, urusikʉ rwɨ ɨtɨnɨrʉ, Mungu arabhanyaacha bhʉkʉngʼu kʉkɨra ɨnyaakʉ yʉ ʉrʉbhɨri rwa Sodoma.” ");
INSERT INTO ikz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ribhaga riyo Yɨɨsu akabhuga, “Bhaabha, Ʉmʉkʉrʉ wa risaarʉ nɨ ɨɨsɨ, ʉzʉmiryɨ, kʉ kʉbha amangʼana ganʉ ʉbhabhisirɨ bha amangʼɨɨni na abhasʉmi, ʉgatɨɨrɨ habhwɨrʉ kʉbhanʉ, bhanu ubhwisirirya ncha abhaana abhasuuhu. ");
INSERT INTO ikz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɨbhu nɨmbu, yakʉzʉmɨɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Akʉmara Yɨɨsu akabhuga, “Bhaabha angʼɨɨrɨ bhyʉsi. Atareeho wʉnʉ ɨɨzɨ Umwana, kuruushaku Bhaabha umwene. Na atareeho wʉnʉ ɨɨzɨ Bhaabha, kuruushaku Umwana, na wʉwʉʉsi wʉnʉ Umwana areende kumwerecha. ");
INSERT INTO ikz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Muuzɨ kwa niinyɨ bhʉʉsi bhanʉ mʉkʉnyaaka na kuritoherwa ni imirigʉ, na niinyɨ nɨrabhooyeerya. ");
INSERT INTO ikz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwibhohe ijʉki yaanɨ, mwɨgɨ kurwa kwa niinyɨ, kʉ kʉbha inyɨ, nɨ‑mʉnyʉʉhu na mwikʉʉmu wu umwʉyʉ. Neho mʉkʉbha no omorembe mumyʉyʉ janyu, ");
INSERT INTO ikz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kʉ kʉbha ijʉki yaanɨ nɨ‑hʉhʉ kogega, nu umurigʉ gwanɨ mʉhʉhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Rusikʉ rʉmwɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu na abhɨɨga bhaazɨ bhaarɨ bharahɨta mʉmɨgʉndʉ jɨ ɨnganʉ. Hanʉ abhɨɨga bhaazɨ bhiigwirɨ ɨnzara, bhakatɨna ɨbhɨgara bhyɨ ɨnganʉ, bhakarya. ");
INSERT INTO ikz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hanʉ Abhafarisaayo bhaarʉʉzɨ gayo, bhakabhʉʉrɨra Yɨɨsu, “Rora, abhɨɨga bhaazʉ bharahocha emeremo gɨnʉ gɨtakwenderwa kokorwa urusikʉ rwʉ ʉbhʉtʉʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yɨɨsu akabhabhʉʉrɨra, “Mʉtasʉmirɨ mʉMaandɨkʉ Amarɨndu chɨmbu Daudi na abhakɨndichazɨ bhaakʉrirɨ, hanʉ bhaarɨ nɨ ɨnzara? ");
INSERT INTO ikz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akasikɨra mwibhuru rirɨndu rya Mungu, akʉmara ewe na abhakɨndichazɨ bhakarya ɨmɨkaatɨ gɨnʉ jatɨɨrwɨ mʉbhʉtangɨ bhwa Mungu. Ɨmɨkaatɨ gɨnʉ kumigirʉ ja Musa gɨtakwenderwa kuriibhwa na abhaatʉ, kuruushaku bhakuhaani abheene. ");
INSERT INTO ikz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kisha mʉkɨɨrɨ kosoma kɨnʉ imigirʉ ja Musa gikubhuga, igʉrʉ wa abhakuhaani bhanʉ bhakohocha mwihekaaru urusikʉ rwʉ ʉbhʉtʉʉrʉ? Bharasarya imigirʉ jʉ ʉbhʉtʉʉrʉ, nawe Mungu atakʉbhabharɨra kʉbha bharasarya. ");
INSERT INTO ikz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nawe nɨrabhabhʉʉrɨra kʉbha, hanʉ areho ʉmʉkʉrʉ kʉkɨra rihekaaru. ");
INSERT INTO ikz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mungu arabhuga, ‘Nereenda mʉbhɨ nɨ ɨbhɨgʉngi kʉkɨra kuhurucha ikimweso.’ Nawe mwangamɨnyirɨ enzobhooro ya amangʼana gayo, mʉtaarɨ mʉratema amasoro abhaatʉ bhanʉ bhataana ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Umwana wʉ Ʉmʉʉtʉ, newe Ʉmʉkʉrʉ wu urusikʉ rwʉ ʉbhʉtʉʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yɨɨsu akabhʉʉka, akaja mwirwazɨrʉ ryabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mwirwazɨrʉ muyo, aarɨmu ʉmʉʉtʉ wʉmwɨ wʉnʉ aarɨ akuurɨ okobhoko. Bhaarɨmu na Abhafarisaayo bhanʉ bhaarɨ bhareenda komogema Yɨɨsu, korereke bhamwinatiriryɨku. Bhakamubhuurya, “Nɨ‑bhwaheene kohorya ʉmʉʉtʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Akabhagarukirya, “Nɨ‑wɨɨwɨ gatɨ waanyu, wʉnʉ arɨɨbhɨ ɨngʼʉndu yaazɨ igwirɨ mwirʉʉma urusikʉ rwʉ ʉbhʉtʉʉrʉ, atamɨ kʉyɨsabhʉramu? ");
INSERT INTO ikz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nawe omenye ʉmʉʉtʉ anu ubhwera kʉkɨra ɨngʼʉndu! Mmbe, nangʉ nɨ‑bhwaheene kokora amazʉmu urusikʉ rwʉ ʉbhʉtʉʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Akʉmara Yɨɨsu akabhʉʉrɨra ʉmʉʉtʉ wʉnʉ akuurɨ okobhoko, “Gorora okobhoko kwazʉ.” Akakogorora, na hayohayo kʉkahora, kʉkabha nchʉ ʉkʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nawe Abhafarisaayo bhakahʉrʉka igʉtʉ, bhakagambana chɨmbu bharaamurichɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hanʉ Yɨɨsu aamɨnyirɨ ɨsɨɨmi ya Abhafarisaayo bhayo, akarwa hayo. Abhaatʉ bhaaru bhakamutuna, akahorya abharwɨrɨ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nawe akabharecha bhatakumucha kʉbhaatʉ kʉbha ewe nɨ‑wɨɨwɨ, ");
INSERT INTO ikz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","korereke gakorwe amangʼana ganʉ Mungu aagambirɨ kʉnzɨra yʉ ʉmʉrʉʉtɨrɨri Isaaya, ");
INSERT INTO ikz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Rora, omohocha waanɨ wʉnʉ nɨrʉbhwɨrɨ, ʉmʉsɨɨgwa waanɨ, wʉnʉ akongongeerya umwʉyʉ gwanɨ. Nɨramoha Ekoro yaanɨ, korereke araganʼyɨ ubhutuurya kʉbhaatʉ bhi ibhyarʉ bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Atakʉhakaana naabha kʉrɨgɨsa, na mʉʉtʉ atakwigwa iraka ryazɨ kʉnzɨra. ");
INSERT INTO ikz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Atakuricha kɨnyʉʉhɨrɨru chʉchʉsi ncha ritete, naabha kurimya ʉrʉtambɨ rʉnʉ rukuzunzazunza, kuhika hanʉ araareete ubhutuurya kuhiza ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ni ibhyarʉ bhyʉsi bhɨramwisega ewe umwene.” ");
INSERT INTO ikz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Akʉmara bhakamoreetera Yɨɨsu ʉmʉʉtʉ wʉnʉ aarɨ na risambwa. Ʉmʉʉtʉ wuyo aarɨ ʉmʉhʉku ɨnʉ imuumu. Yɨɨsu akamohorya, akatanga kʉgamba na korora. ");
INSERT INTO ikz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Abhaatʉ bhʉʉsi bhanʉ bhaarɨ hayo bhakarʉgʉʉra bhʉkʉngʼu, bhakabhuga, “Ɨratʉra kʉbha wʉnʉ newe Umwana wʉ ʉmʉtɨmi Daudi?” ");
INSERT INTO ikz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nawe hanʉ Abhafarisaayo bhiigwirɨ gayo, bhakabhuga, “Araheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, ʉmʉkʉrʉ wa amasambwa!” ");
INSERT INTO ikz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yɨɨsu akamenya amiisɨɨgi gaabhʉ, akabhabhʉʉrɨra, “Arɨɨbhɨ abhaatʉ bhʉ ʉbhʉtɨmi bhʉmwɨ bhariitana, ʉbhʉtɨmi bhuyo bhʉhaagwa. Na arɨɨbhɨ abhaatʉ bhʉ ʉrʉbhɨri rʉmwɨ hamwɨ inyumba yɨmwɨ bhariitana, mmbe abhaatʉ bhayo bharataana. ");
INSERT INTO ikz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Na Shɨtaani araaheebhe Shɨtaani, arabha ariiyiitanʼya umwene. Ʉbhʉtɨmi bhwazɨ bhʉranagabhwɨ? ");
INSERT INTO ikz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Arɨɨbhɨ nɨraheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, abhahɨmba bhaanyu ebho bhahaagaheebha kʉbhʉnaja bhwa wɨɨwɨ? Igʉrʉ wa gayo, bhayo nebho bhareereche kʉbha ganʉ mʉkʉgamba gatarɨ maheene. ");
INSERT INTO ikz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nawe arɨɨbhɨ nɨraheebha amasambwa kʉbhʉnaja bhwe Ekoro ya Mungu, mmbe momenye kʉbha ʉbhʉtɨmi bhwa Mungu bhuhikirɨ kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ʉmʉʉtʉ aratʉrabhwɨ kusikɨra munyumba yʉ ʉmʉʉtʉ wa amanaga na kumuruusha ebhegero bhyazɨ, akɨɨrɨ komobhoha? Areemobhohe, hayo aratʉra kumuruusha ebhegero bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ʉmʉʉtʉ wʉnʉ atarɨ hamwɨmwɨ na niinyɨ, arɨ mbarɨka. Na wʉnʉ atakubhiringa abhaatʉ bha Mungu hamwɨmwɨ na niinyɨ, arabhasanja. ");
INSERT INTO ikz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kʉgayo nɨrabhabhʉʉrɨra, Mungu aratʉra kobheerera abhaatʉ ʉbhʉbhɨ bhwabhʉ bhwʉsi, nʉʉrʉ bhaarɨ bhamʉrɨgirɨ. Nawe Mungu atakʉtʉra kobheerera abhaatʉ arɨɨbhɨ bhararega Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na Mungu aratʉra kobheerera ʉmʉʉtʉ wʉnʉ akʉgamba kɨbhɨ igʉrʉ wu Umwana wʉ Ʉmʉʉtʉ. Nawe atakobheerera ʉmʉʉtʉ wʉnʉ akʉgamba kɨbhɨ igʉrʉ we Ekoro Ɨndɨndu, ɨbhɨ kwibhaga rɨnʉ hamwɨ rɨnʉ rikuuza. ");
INSERT INTO ikz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ʉmʉtɨ gʉhaamenyekana kumisumʉ jaku. Ʉmʉtɨ ʉmʉzʉmu guhiibhʉra imisumʉ ɨmɨzʉmu, nʉ ʉmʉtɨ ʉmʉbhɨ guhiibhʉra imisumʉ ɨmɨbhɨ. Ʉratʉra komenya ʉmʉtɨ chɨmbu gʉrɨ kumisumʉ jaku. ");
INSERT INTO ikz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imwɨ urwibhʉrʉ rwe enzoka! Mʉratʉrabhwɨ kʉgamba amangʼana amazʉmu ɨnʉ imwɨ, nɨ‑bhabhɨ? Ʉmʉʉtʉ ahaagamba ganʉ gizwirɨ mumwʉyʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ʉmʉʉtʉ ʉmʉzʉmu ahaahurucha amangʼana amazʉmu kurwa kʉmazʉmu ganʉ gabhiikirwɨ mumwʉyʉ gwazɨ, nawe ʉmʉʉtʉ ʉmʉbhɨ ahaahurucha amangʼana amabhɨ kurwa kʉmabhɨ ganʉ gabhiikirwɨ mumwʉyʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mmbe, nɨrabhabhʉʉrɨra, urusikʉ rwɨ ɨtɨnɨrʉ, ringʼana ryʉsi rɨnʉ abhaatʉ bhakʉbha bhaagambirɨ rɨtakʉbha na bhwera, bhareenderwa kuhurucha ekerengo cha ringʼana riyo. ");
INSERT INTO ikz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kʉmangʼana gaazʉ amazʉmu ʉrabharirwa eheene, na kʉmangʼana amabhɨ ʉrabharirwa ʉbhʉbhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Akʉmara Abhafarisaayo obhorebhe na abhiija bhi imigirʉ ja Musa bhakabhʉʉrɨra Yɨɨsu, “Umwija, toreenda okore ichɨrɨkɨnʼyʉ kwerecha kʉbha uruurɨ kwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Akabhagarukirya, “Imwɨ urwibhʉrʉ ʉrʉbhɨ na rʉnʉ rʉtarɨ oroheene! Moreenda ichɨrɨkɨnʼyʉ, nawe mʉtakwerechwa ichɨrɨkɨnʼyʉ chʉchʉsi, kuruushaku kɨmwɨ kɨnʉ changɨ chʉ ʉmʉrʉʉtɨrɨri Yoona. ");
INSERT INTO ikz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chɨmbu Yoona iikɨɨrɨ mʉnda yi iiswɨ sikʉ isatʉ ubhutikʉ nu umwise, ɨbhu nɨmbu Umwana wʉ Ʉmʉʉtʉ ariikarɨ mumbihɨra sikʉ isatʉ ubhutikʉ nu umwise. ");
INSERT INTO ikz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Urusikʉ rwɨ ɨtɨnɨrʉ, abhaatʉ bhʉ ʉrʉbhɨri rwa Ninaawi bhariimɨɨrɨra mʉbhʉtangɨ bhwa Mungu hamwɨmwɨ na abhaatʉ bhu urwibhʉrʉ rwa nangwɨnʉ na kʉrʉtɨnɨra. Abhaatʉ bha Ninaawi bhakatiga ʉbhʉbhɨ bhwabhʉ igʉrʉ wu ukwigwa ubhurwazi bhwa Yoona. Nangʉ nɨrabhabhʉʉrɨra, hanʉ areho ʉmʉkʉrʉ kʉkɨra Yoona. ");
INSERT INTO ikz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ribhaga ryʉ ʉmʉtɨmi Sɨrɨmaani, aareho marikiya wʉmwɨ wʉnʉ aarɨ aratema ʉrʉbhaara rwa rangɨ. Marikiya wuyo ariimɨɨrɨra mʉbhʉtangɨ bhwa Mungu na kʉtɨnɨra abhaatʉ bhu urwibhʉrʉ rʉnʉ, kʉ kʉbha bhasariryɨ. Ewe akarwa mucharʉ cha kore korereke aazɨ iitegeerere amangʼana gu ubhwʉbhʉʉri bhwʉ ʉmʉtɨmi Sɨrɨmaani. Nangʉ nɨrabhabhʉʉrɨra, hanʉ areho mʉkʉrʉ kʉkɨra Sɨrɨmaani.” ");
INSERT INTO ikz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yɨɨsu akangʼeha kʉgamba, “Hanʉ risambwa rikurwa kʉmʉʉtʉ, rɨhaaja kʉkɨbhara ɨnʉ rɨramohya ahagero hu ukwoyeera. Nawe rɨraatamwɨ kʉhabhona, ");
INSERT INTO ikz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","rɨhaabhuga, ‘Nɨragarʉka uwaanɨ hanʉ naruurɨ.’ Hanʉ rɨkʉgarʉka, rɨrabhona aangɨ inyumba yɨnʉ ɨrɨ bhʉʉha, ɨtarikiibhwɨ na ɨkʉrirwɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Akʉmara rɨhaaja koreeta amasambwa agandɨ muhungatɨ amabhɨ kʉrɨkɨra, gʉʉsi gahaasikɨra kʉmʉʉtʉ wuyo, na kwikara kwawɨ. Neho ubhwikari bhwʉ ʉmʉʉtʉ wuyo bhʉhaabha bhʉbhɨ kʉkɨra chɨmbu bhwarɨ. Ɨbhu nɨmbu ɨkʉbha kwa niimwɨ, urwibhʉrʉ ʉrʉbhɨ rʉnʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hanʉ Yɨɨsu aarɨ achagambana na riribhita rya abhaatʉ bhayo, unina na abhahiiri bhaazɨ bhakaaza, bhakiimɨɨrɨra igʉtʉ, bhareenda kʉgambana nawe. ");
INSERT INTO ikz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ʉmʉʉtʉ wʉmwɨ akabhʉʉrɨra Yɨɨsu, “Onyoko na bhaumwanyu bhiimiiriirɨ igʉtʉ, bhareenda kʉgambana na naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yɨɨsu akamʉgarukirya, “Yiiya, nɨ‑wɨɨwɨ? Na bhaumwɨtʉ, nɨ‑bha wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Akʉmara akoorota abhɨɨga bhaazɨ, akabhuga, “Rora, bhanʉ nebho bha yiiya na bhaumwɨtʉ! ");
INSERT INTO ikz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akokora ubhwɨndi bhwa Mungu, wuyo newe umwɨtʉ, umusubhaati na yiiya.” ");
INSERT INTO ikz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Urusikʉ ruyoruyo, Yɨɨsu akarwa munyumba yiyo, akaja kwikara rusizʉ wɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Riribhita ikʉrʉ rya abhaatʉ rɨkaaza, rikiibhiringa hanʉ Yɨɨsu aarɨ. Akasikɨra mubhwatʉ, akiikara, abhaatʉ bhakabha bhiimiiriirɨ rusizʉ wɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yɨɨsu akabhabhʉʉrɨra amangʼana maaru kobherenjo. Akabhuga, “Mwitegeerere! Umubhusuri akaja kubhusura imbusurʉ yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hanʉ aarɨ akubhusura, zimbusurʉ ɨzɨndɨ zɨkagwa kʉnzɨra, ibhinyunyi bhɨkaaza, bhɨkazirya. ");
INSERT INTO ikz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɨzɨndɨ zɨkagwa kukurungutarɨ, zɨkamera bhwangʉ, kʉ kʉbha rirobha ryarɨ isuuhu. ");
INSERT INTO ikz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hanʉ ʉmwɨ gwabharirɨ, zɨkanyaara na kwʉma, kʉ kʉbha imiri jaku jarɨ igʉrʉgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɨzɨndɨ zɨkagwa mʉmahwa. Amahwa gayo gakakʉra, gakazihiza kuhika zɨkakwa. ");
INSERT INTO ikz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɨzɨndɨ zɨkagwa kwirobha rizʉmu, zɨkakʉra. Zikiibhʉra imisumʉ, ɨzɨndɨ igana rɨmwɨ, ɨzɨndɨ merongo ɨsaasabha nɨ ɨzɨndɨ merongo ɨtatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhɨɨga bhaazɨ bhakamujaku na kumubhuurya, “Kwakɨ ʉragambana na abhaatʉ kwe ebherenjo?” ");
INSERT INTO ikz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Akabhagarukirya, “Imwɨ mʉhɨɨrwɨ ʉbhʉnaja bhwo okomenya zimbisi zʉ ʉbhʉtɨmi bhwa mwisaarʉ, nawe ebho zɨyi. ");
INSERT INTO ikz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wʉnʉ akwitegeerera ɨngʼana ya Mungu na koyemenya, Mungu aramʉsakirya na kumwongerya koyemenya kʉkɨraho. Nawe arɨɨbhɨ ʉmʉʉtʉ atakwitegeerera ɨngʼana ya Mungu, nʉʉrʉ isuuhu yɨnʉ amɨnyirɨ araruusibhwa. ");
INSERT INTO ikz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kiyo necho kikugirya, nɨragambana nabhʉ kwe ebherenjo, kʉ kʉbha bhararora, nawe bhatakʉnaama. Na bhariitegeerera, nawe bhatakwigwa nʉʉrʉ bhatakwobhoora. ");
INSERT INTO ikz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwabhʉ gabhɨɨrɨ ganʉ ʉmʉrʉʉtɨrɨri Isaaya aabhugirɨ, ‘Ukwigwa muriigwa, nawe mʉtakwobhoora. Okorora mʉrarora, nawe mʉtakʉnaama, ");
INSERT INTO ikz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kʉ kʉbha abhaatʉ bhanʉ zekoro zaabhʉ zɨbhɨɨrɨ kʉngʼu, amatwɨ gaabhʉ gatakwigwa, amɨɨsʉ gaabhʉ gatakorora. Bhatakwenda korora kwa amɨɨsʉ gaabhʉ, kwigwa kwa amatwɨ gaabhʉ, nʉʉrʉ kwobhoora kwa zekoro zaabhʉ, bhataaza kunyiichʉrɨra na niinyɨ nɨbhahorye.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Neho Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Nawe hakɨrɨku imwɨ, kʉ kʉbha amɨɨsʉ gaanyu gararora na amatwɨ gaanyu gariigwa. ");
INSERT INTO ikz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nɨrabhabhʉʉrɨra amaheene, abharʉʉtɨrɨri na abhaatʉ bhe eheene bhaaru, bhaarɨ bhariigomba korora ganʉ mokorora, nawe bhatagarʉʉzɨ, na kwigwa ganʉ mukwigwa, nawe bhataagiigwirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mmbe, mwitegeerere enzobhooro ye ekerenjo chu umubhusuri wa zimbusurʉ kiyo. ");
INSERT INTO ikz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwigwa ɨngʼana yʉ ʉbhʉtɨmi bhwa mwisaarʉ, nawe atakwobhoora, ʉmʉʉtʉ wuyo atuubhɨɨnɨ na zimbusurʉ zɨnʉ zaagwirɨ kʉnzɨra. Shɨtaani ahaaza na kʉsaakʉra kɨnʉ kɨhambirwɨ mokoro yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Zimbusurʉ zɨnʉ zaagwirɨ kukurungutarɨ, zɨratuubhanibhwa nʉ ʉmʉʉtʉ wʉnʉ akwigwa ɨngʼana yʉ ʉbhʉtɨmi bhwa mwisaarʉ, na hayohayo arayigwata kobhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nawe kʉ kʉbha ubhwisirirya bhwazɨ bhʉtaana imiri, aragwata kwibhaga isuuhubhu. Hanʉ ɨnyaakʉ hamwɨ amakʉngʼu gakomobhona igʉrʉ wɨ ɨngʼana yʉ ʉbhʉtɨmi bhwa mwisaarʉ, rogendo rʉmwɨ aratiga ubhwisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Zimbusurʉ zɨnʉ zaagwirɨ mʉmahwa, zɨratuubhanibhwa nʉ ʉmʉʉtʉ wʉnʉ akwigwa ɨngʼana yʉ ʉbhʉtɨmi bhwa mwisaarʉ, nawe arakangiribhwa na amahocha ga kʉʉsɨ nu umwʉyʉ gwu ubhuniibhi. Gayo gahaahɨga ɨngʼana ya Mungu na kugirya ɨtamɨ kwibhʉra imisumʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nawe zimbusurʉ zɨnʉ zaagwirɨ kwirobha rizʉmu, zɨratuubhanibhwa nʉ ʉmʉʉtʉ wʉnʉ akwigwa ɨngʼana yʉ ʉbhʉtɨmi bhwa mwisaarʉ na koyobhoora. Ʉmʉʉtʉ wuyo newe akwibhʉra imisumʉ, ɨgɨndɨ igana rɨmwɨ, ɨgɨndɨ merongo ɨsaasabha nɨ ɨgɨndɨ merongo ɨtatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yɨɨsu akabhabhʉʉrɨra ekerenjo ɨkɨndɨ, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nʉ ʉmʉʉtʉ wʉnʉ aahambirɨ zimbusurʉ zɨnzʉmu mʉmʉgʉndʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nawe hanʉ abhaatʉ bhaahindiirɨ, umubhisa akaaza, akahamba ɨkɨtʉki mʉnganʉ, akʉmara akaja. ");
INSERT INTO ikz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hanʉ ɨnganʉ yaamɨrirɨ na kʉtanga kʉbharya, ɨkɨtʉki chʉsi kɨkarorekana. ");
INSERT INTO ikz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bhambʉʉsa bha wʉ ʉmʉgʉndʉ bhakaaza, bhakamubhuurya, ‘Ʉmʉkʉrʉ, tʉmɨnyirɨ ʉkahamba zendetere zɨnzʉmu mʉmʉgʉndʉ gwazʉ. Nangʉ, ɨkɨtʉki kiruurɨ hayi?’ ");
INSERT INTO ikz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Akabhagarukirya, ‘Umubhisa newe akʉrirɨbhu.’ “Bhambʉʉsa bhaazɨ bhakamubhuurya, ‘Nangʉ tujɨ twihɨ ɨkɨtʉki?’ ");
INSERT INTO ikz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nawe akabhuga, ‘Zɨyi, mʉtachiha, kʉ kʉbha muriihɨ, mʉratʉra kwiha nɨ ɨnganʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mutigɨ bhyʉsi bhɨkʉrɨ hamwɨmwɨ, kuhika ribhaga ryo okogesa. Ribhaga riyo, nɨrabhʉʉrɨra abhagɨsi bhabhiringɨ hinga ɨkɨtʉki zituumʉ korereke bhachoche. Neho bhatʉrɨ kogesa ɨnganʉ na kʉyɨbhɨɨka mʉkɨtara chanɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yɨɨsu akabhabhʉʉrɨra ekerenjo ɨkɨndɨ, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ ne endetere isuuhu yɨ ɨharadaari, yɨnʉ ʉmʉʉtʉ aagɨgirɨ na kʉhamba mʉmʉgʉndʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Endetere yiyo ni‑suuhu kʉkɨra zendetere ɨzɨndɨ zʉʉsi, nawe ɨraamere ɨhaakʉra kʉkɨra ibhyakurya bhyʉsi bhɨnʉ bhɨrɨ mʉmʉgʉndʉ. Na ɨhaabha mʉtɨ mʉkʉrʉ, ni ibhinyunyi bhɨhaaza na kwikara kubhisha bhyaku.” ");
INSERT INTO ikz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yɨɨsu akabhabhʉʉrɨra ekerenjo ɨkɨndɨ, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nu ubhutunduuru bhʉnʉ ʉmʉkari akogega na kʉsanginʼya nu ubhutu bhwɨ ɨnganʉ mʉbhɨgʉzi bhɨtatʉ. Ubhutunduuru bhuyo bhʉragirya ubhutu bhwɨ ɨnganʉ bhwʉsi bhʉtʉndʉʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yɨɨsu aarɨ arabhʉʉrɨra amaribhita ga abhaatʉ amiija gayo kwe ebherenjo. Atabhiijiryɨ chʉchʉsi ataana kerenjo. ");
INSERT INTO ikz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gayo gakʉriibhwɨbhu, korereke rɨbhɨ ringʼana rɨnʉ Mungu aagambirɨ kʉnzɨra yʉ ʉmʉrʉʉtɨrɨri waazɨ arabhuga, “Nɨragambana na abhaatʉ kobherenjo. Nɨragahumbura amangʼana ganʉ gaarɨ giibhisirɨ kwɨma okoteemwa kwɨ ɨɨsɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mmbe, Yɨɨsu akaraga amaribhita ga abhaatʉ, akasikɨra munyumba. Abhɨɨga bhaazɨ bhakamujaku, bhakamʉbhʉʉrɨra, “Tʉgarʉrɨrɨ enzobhooro ye ekerenjo chɨ ɨkɨtʉki mʉmʉgʉndʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yɨɨsu akabhagarukirya, “Ʉmʉʉtʉ wʉnʉ aahambirɨ zendetere zɨnzʉmu, ni‑Mwana wʉ Ʉmʉʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ʉmʉgʉndʉ gʉratuubhanibhwa nɨ‑ɨsɨ, zendetere zɨnzʉmu nɨ‑bhaatʉ bhʉ ʉbhʉtɨmi bhwa mwisaarʉ, nɨ ɨkɨtʉki, nɨ‑bhaatʉ bha Shɨtaani. ");
INSERT INTO ikz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Umubhisa wʉnʉ aahambirɨ ɨkɨtʉki nɨ‑Shɨtaani. Amagesa nɨ‑tɨnɨrʉ yɨ ɨɨsɨ, na bhamaraika bha Mungu nebho abhagɨsi. ");
INSERT INTO ikz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Chɨmburya ɨkɨtʉki kikwihwa na kwochwa momorero, nɨmbu ɨkʉbha urusikʉ rwɨ ɨtɨnɨrʉ yɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Umwana wʉ Ʉmʉʉtʉ aratʉma bhamaraika bhaazɨ, korereke bhabhiringɨ abhakʉri bhʉ ʉbhʉbhɨ bhʉʉsi kurwa mʉbhʉtɨmi bhwazɨ, hamwɨmwɨ na bhʉʉsi bhanʉ bhagiriryɨ ʉbhʉbhɨ, ");
INSERT INTO ikz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kʉbharekera mwibhɨbhɨ ryo omorero. Iyo bhararɨra na kokepeha. ");
INSERT INTO ikz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Neho bhe eheene bharaabharyɨ nchi iryʉbha mʉbhʉtɨmi bhwa Wiisɨ. Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Akʉmara Yɨɨsu akahurucha ekerenjo ɨkɨndɨ, akabhuga, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ ne ekegero chu ubhwera ʉbhʉkʉrʉ kɨnʉ charɨ kibhisirwɨ mʉmʉgʉndʉ. Urusikʉ rʉmwɨ, ʉmʉʉtʉ akakebhona, akakibhisa naatu. Akazomerwa bhʉkʉngʼu, akaja akagurya ebhegero bhyazɨ bhyʉsi bhɨnʉ aarɨ nabhyʉ, akagʉra ʉmʉgʉndʉ guyo. ");
INSERT INTO ikz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nʉ ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nu umusuruja wʉnʉ akomohya iruuru yu ubhwera ʉbhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hanʉ aarʉʉzɨ iruuru yɨmwɨ yu ubhwera ʉbhʉkʉrʉ, akaja akagurya ebhegero bhyazɨ bhyʉsi bhɨnʉ aarɨ nabhyʉ, akagʉra iruuru yiyo.” ");
INSERT INTO ikz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yɨɨsu akahurucha ekerenjo ɨkɨndɨ, akabhuga, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ ne enzero yɨnʉ yataashirwɨ mʉnyanza, ɨkagwata ziiswɨ ze eteemwa nzaru. ");
INSERT INTO ikz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hanʉ enzero yiizwirɨ, abhatɨgi bhakarutɨra rusizʉ wɨ ɨnyanza. Akʉmara, bhakiikara, bhakabhiringa ziiswɨ zɨnzʉmu, bhakatʉʉra mobhegero. Nawe bhakataasha ziiswɨ zɨmbɨ. ");
INSERT INTO ikz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɨbhu nɨmbu ɨkʉbha, urusikʉ rwɨ ɨtɨnɨrʉ yɨ ɨɨsɨ. Bhamaraika bharaaza na kʉtaanʼya abhakʉri bhʉ ʉbhʉbhɨ na bhe eheene. ");
INSERT INTO ikz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Akʉmara bhararekera abhakʉri bhʉ ʉbhʉbhɨ mwibhɨbhɨ ryo omorero. Iyo bhararɨra na kokepeha.” ");
INSERT INTO ikz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yɨɨsu akabhuurya abhɨɨga bhaazɨ, “Nangʉ, mwʉbhʉʉrirɨ gʉʉsi ganʉ nɨbhabhuuriirɨ?” Bhakamʉgarukirya, “Hee.” ");
INSERT INTO ikz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Akabhabhʉʉrɨra, “Umwija wʉwʉʉsi wi imigirʉ ja Musa wʉnʉ iijibhwɨ igʉrʉ wʉ ʉbhʉtɨmi bhwa mwisaarʉ, atuubhɨɨnɨ nu umwene nyumba wʉnʉ akuhurucha mobhegero bhyazɨ ebhegero ibhihya na bhyɨ ɨkarɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hanʉ Yɨɨsu aamarirɨ kuhurucha ebherenjo bhiyo, akabhʉʉka hayo, ");
INSERT INTO ikz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akaja mʉrʉbhɨri rwabhʉ rwa Nazarɨɨti. Iyo, akatanga kwija abhaatʉ mwirwazɨrʉ ryabhʉ. Bhakarʉgʉʉra bhʉkʉngʼu, bhakiibhuurya, “Ʉmʉʉtʉ wʉnʉ abhwɨnɨ hayi ubhwʉbhʉʉri bhʉnʉ? Na abhwɨnɨ hayi ʉbhʉnaja bhwo okokora ɨbhɨsɨgʉ bhɨnʉ? ");
INSERT INTO ikz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wʉnʉ atarɨ umwana wʉ ʉmʉsɨrɨmara wurya? Unina tɨ Mariyamu? Abhasuuhu bhaazɨ tɨ Yaakobho, Yuusufu, Simʉʉni na Yuuda? ");
INSERT INTO ikz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na abhasubhaati bhaazɨ tebho bhanʉ tukwikara nabhʉ hanʉ? Nangʉ, abhwɨnɨ hayi amangʼana gʉʉsi ganʉ?” ");
INSERT INTO ikz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Abhaatʉ bhayo bhakiigatana, bhakaanga kumwisirirya. Nawe Yɨɨsu akabhabhʉʉrɨra, “Ʉmʉrʉʉtɨrɨri ahaasuukwa ahandɨ hʉʉsi, kuruushaku mʉrʉbhɨri rwazɨ nu uwaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yɨɨsu ataakʉrirɨ ɨbhɨsɨgʉ bhyaru iyo, kʉ kʉbha bhatamwisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ribhaga riyo, ʉmʉtɨmi Heroode Antipaasi aarɨ ʉmʉkangati wi icharʉ cha Gariraaya. Hanʉ iigwirɨ igʉrʉ wa amahocha ganʉ Yɨɨsu aarɨ arakora, ");
INSERT INTO ikz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","akabhʉʉrɨra abhahocha bhaazɨ, “Ʉmʉʉtʉ wuyo, ne‑Yoohana Ʉmʉbhatiizi! Hamwɨ aryukirɨ mʉbhaku, necho anʉ ʉbhʉnaja bhwo okokora ɨbhɨsɨgʉ ɨbhɨkʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroode akagambabhu, kʉ kʉbha ewe newe aarɨ agwatirɨ Yoohana. Akamobhoha mokebhoho, igʉrʉ wa amangʼana gu ubhukwɨri bhwa Heroode na Hɨrʉʉdiya. Hɨrʉʉdiya wuyo, aarɨ ʉmʉkari wa Firipʉ, umwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kereeta ndeewa charɨ, Yoohana akabhʉʉrɨra Heroode, “Ni‑mugirʉ kukwɨra ʉmʉkari wa umwabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroode aarɨ aramohya ɨnzɨra yu ukwita Yoohana, nawe aarɨ arʉʉbhaha abhaatʉ kʉ kʉbha bhiisiriiryɨ Yoohana kʉbha nɨ‑mʉrʉʉtɨrɨri wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hanʉ ɨnyangi yu ukwibhurwa kwa Heroode yaahikirɨ, umuucha wa Hɨrʉʉdiya akabhina embere wa abhagini. Heroode akazomerwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Neho akamwirahɨra komoha chʉchʉsi kɨnʉ araamʉsabhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Umuucha wuyo akasiigiriribhwa na unina, akabhʉʉrɨra Heroode, “Nongʼe kʉrʉhʉngʉ umutwɨ gwa Yoohana Ʉmʉbhatiizi.” ");
INSERT INTO ikz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ʉmʉtɨmi Heroode akarumɨka bhʉkʉngʼu, nawe igʉrʉ wu ubhwirahiri bhwazɨ mʉbhʉtangɨ bhwa abhagini, akaswaja umuucha ahaabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mmbe, Heroode akatʉma ʉmʉʉtʉ ajɨ mokebhoho, atɨnɨ Yoohana umutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Akʉmara akareeta umutwɨ gwa Yoohana kʉrʉhʉngʉ, akaha umuucha wuyo, wʉʉsi akahirɨra unina. ");
INSERT INTO ikz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hanʉ abhɨɨga bha Yoohana bhiigwirɨ amangʼana gayo, bhakaaza bhakagega ɨkɨtʉndʉ bhakabhɨɨka. Akʉmara, bhakaja bhakabhʉʉrɨra Yɨɨsu amangʼana gayo. ");
INSERT INTO ikz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hanʉ Yɨɨsu iigwirɨ gayo, akabhʉʉka hayo nu ubhwatʉ, akaja ahagero hanʉ hataana abhaatʉ. Nawe abhaatʉ bhakiigwa ɨnʉ aagiirɨ, bhakamutuna magʉrʉ kurwa mʉzɨmbɨri zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hanʉ Yɨɨsu iikirɨ mubhwatʉ, akarora riribhita ikʉrʉ rya abhaatʉ. Akabharorera ɨbhɨgʉngi na kohorya abharwɨrɨ bhaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hanʉ ryahikirɨ rigoroobha, abhɨɨga bhaazɨ bhakamujaku bhakamʉbhʉʉrɨra, “Hanʉ tʉrɨ ni‑mwitɨrɨgʉ na bhʉraariirɨ kwira. Ʉbharagɨ abhaatʉ bhanʉ, bhajɨ mʉzɨmbɨri kwigʉrɨra ibhyakurya.” ");
INSERT INTO ikz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yɨɨsu akabhabhʉʉrɨra, “Bhatakwenderwa kuja. Imwɨ, mʉbhahɨ ibhyakurya.” ");
INSERT INTO ikz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ebho bhakamʉgarukirya, “Tʉtaana kegero! Tʉnɨ ɨmɨkaatɨ ɨtaanʉbhu na ziiswɨ ibhɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Akabhabhʉʉrɨra, “Mondeetere hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akabhaswaja abhaatʉ bharya bhiikarɨ haasɨ kʉbhʉnyaaki. Akagega ɨmɨkaatɨ ɨtaanʉ na ziiswɨ ibhɨrɨ zirya, akarangamɨra kwisaarʉ akabhʉʉrɨra Mungu, azʉmiryɨ. Akʉmara akasunyuraku ɨmɨkaatɨ, akabhaha abhɨɨga bhaazɨ hamwɨmwɨ na ziiswɨ, bhʉʉsi bhakabhasondya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhʉʉsi bhakarya, bhakiigʉta. Akʉmara, abhɨɨga bhaazɨ bhakabhiringa amasaajʉ, bhakiizurya bhɨhʉʉzʉ ikumi na bhɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abhaatʉ bhanʉ bhaariirɨ ibhyakurya bhirya, bhaarɨ abhasubhɨ bhɨkwɨ bhɨtaanʉ, kuruushaku abhakari na abhaana. ");
INSERT INTO ikz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hayohayo, Yɨɨsu akaswaja abhɨɨga bhaazɨ bhasikɨrɨ mubhwatʉ, bhakangatɨ kuja imwambʉkʉ wɨ ɨnyanza, ribhaga riyo ewe aarɨ araraga riribhita rya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hanʉ aamarirɨ kʉraga riribhita rirya, akatiira kʉkɨgʉrʉ umwene kʉsabha Mungu. Hanʉ ikiirimya chasikiirɨ, aarɨ akɨɨrɨ kʉkɨgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ribhaga riyo, ubhwatʉ bhurya bhwarɨ bhuhikirɨ kore nɨ ɨɨsɨ ɨnyʉmu, na amakunda gaarɨ garabhotema, kʉ kʉbha ʉmʉkama gwarɨ gʉrahuuta. ");
INSERT INTO ikz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mmbe hanʉ ryahikirɨ mʉmacha, Yɨɨsu akahika hanʉ abhɨɨga bhaazɨ bhaarɨ, aragenda kʉmanzi. ");
INSERT INTO ikz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hanʉ abhɨɨga bhaazɨ bhaarʉʉzɨ aragenda kʉmanzi, bhakʉʉbhaha bhʉkʉngʼu, na kʉrɨgɨsa bharabhuga, “Kɨnʉ nɨ‑kɨhwɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hayohayo, Yɨɨsu akagamba, “Mohoreere, mʉtʉʉbhaha! Niinyɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peetero akamʉgarukirya, “Ʉmʉkʉrʉ, arɨɨbhɨ naawɨ, mbʉʉrɨra niizɨ kwa naawɨ, nɨragenda kʉmanzi.” ");
INSERT INTO ikz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Akabhuga, “Nauzɨ!” Mmbe, Peetero akiika mubhwatʉ, akatanga kogenda igʉrʉ wa amanzi kuja kwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nawe hanʉ aarʉʉzɨ ʉmʉkama mʉhaari, Peetero akʉʉbhaha bhʉkʉngʼu, akatanga kʉtʉbhɨra mʉmanzi, akakuura kwiraka, “Ʉmʉkʉrʉ, nsabhʉra!” ");
INSERT INTO ikz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hayohayo, Yɨɨsu akagorora okobhoko, akamugwata, akamʉbhʉʉrɨra, “Awɨ wu ubhwisirirya ubhusuuhu, kwakɨ ʉkabha nʉ ʉrʉhaho?” ");
INSERT INTO ikz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hanʉ bhaatiirirɨ mubhwatʉ, ʉmʉkama gʉkatureera. ");
INSERT INTO ikz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mmbe, abhɨɨga bhanʉ bhaarɨ mubhwatʉ, bhakamosengera. Bhakabhuga, “Maheene, awɨ ni‑Mwana wa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaambukirɨ ɨnyanza, bhakahika mucharʉ cha Genezarɨti. ");
INSERT INTO ikz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hanʉ abhaatʉ bha ahagero hayo bhʉʉbhʉʉrirɨ nɨ‑Yɨɨsu, bhakatʉma abhaatʉ kʉraganʼya amangʼana gaazɨ mʉzɨɨsɨ zʉʉsi za haguhɨ. Bhakamoreetera abharwɨrɨ bhaabhʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhakamʉsabha abhiisiririryɨ abharwɨrɨ bhakunʼyɨ naabha ripindʉ rye engebho yaazɨ. Bhʉʉsi bhanʉ bhaamukuniryɨku, bhakahora amarwɨrɨ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Neho Abhafarisaayo na abhiija bhi imigirʉ ja Musa obhorebhe bhakarwa Yɨrusarɨɨmu bhakaaza kwa Yɨɨsu, bhakamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwakɨ abhɨɨga bhaazʉ bhatigirɨ isimʉka yɨnʉ abhakaruka bhɨɨtʉ bhaatutigiirɨ? Bhararya ibhyakurya, ɨnʉ bhatiisaabhirɨ amabhoko gaabhʉ chɨmbu ikwenderwa!” ");
INSERT INTO ikz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Akabhagarukirya, “Ndora imwɨ mutigirɨ imigirʉ ja Mungu, kwa kutuna zisimʉka zaanyu? ");
INSERT INTO ikz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mungu abhugirɨ, ‘Ʉsʉʉkɨ wuusʉ na onyoko,’ naatu akabhuga, ‘Wʉwʉʉsi wʉnʉ akʉtʉka wiisɨ hamwɨ unina, areenderwa akwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nawe imwɨ mʉhaabhuga, ʉmʉʉtʉ wʉnʉ araabhʉʉrɨrɨ wiisɨ hamwɨ unina, ‘Ebhegero bhɨnʉ nangaturirɨ kʉkʉsakirya, nihuruchiryɨ kwa Mungu ikimweso,’ ");
INSERT INTO ikz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","angʉ ʉmʉʉtʉ wuyo atakwenderwa kʉsʉʉka wiisɨ hamwɨ unina. Nawe kuyo nekwe okorega ɨngʼana ya Mungu igʉrʉ wu kutuna zisimʉka zaanyu. ");
INSERT INTO ikz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Abhabhɨɨhi imwɨ, Mungu akagamba amaheene igʉrʉ waanyu kʉhɨtɨra kʉmʉrʉʉtɨrɨri Isaaya chɨmbu yandikirwɨ kʉbha, ");
INSERT INTO ikz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abhaatʉ bhanʉ bhahaansʉʉka kwa mangʼana ageene, nawe zekoro zaabhʉ zere kore na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Okosengera kwabhʉ kʉtaana bhwera, kʉ kʉbha bhariija amiija ga abhaatʉ kina nɨ‑ga Mungu.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mmbe, Yɨɨsu akabhɨrɨkɨra riribhita rya abhaatʉ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Mwitegeerere bhwaheene, na mwobhoore! Ɨtarɨ kɨnʉ kikusikɨra mumunywa necho kekokora ʉmʉʉtʉ kobhenga. Nawe, amangʼana ganʉ gakurwa mumunywa, nego gakugirya ʉmʉʉtʉ abhenge.” ");
INSERT INTO ikz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Neho abhɨɨga bhakamujaku, bhakamubhuurya, “Ʉmɨnyirɨ kʉbha hanʉ Abhafarisaayo bhiigwirɨ amangʼana garya bhakiigatana bhʉkʉngʼu?” ");
INSERT INTO ikz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Akagarukirya, “Ɨbhɨtʉʉtʉ bhyʉsi bhɨnʉ bhɨtaahambirwɨ na Bhaabha wa mwisaarʉ, bhiriihwa. ");
INSERT INTO ikz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mʉbhatigɨ! Bhayo nɨ‑bhakangati abhahʉku bhanʉ bhahaakangata abhahʉku. Ʉmʉhʉku arɨɨkangatɨ ʉmʉhʉku ʉmʉkɨndichazɨ, bhʉʉsi bharagwa mwirʉʉma.” ");
INSERT INTO ikz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peetero akabhuga, “Tʉgarʉrɨrɨ ekerenjo kiyo.” ");
INSERT INTO ikz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yɨɨsu akamʉgarukirya, “Na niimwɨ mʉkɨɨrɨ komenya? ");
INSERT INTO ikz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mʉtɨɨzɨ kʉbha chʉchʉsi kɨnʉ kikusikɨra mumunywa, kɨhaaja mʉnda, akʉmara kɨhaahuruchibhwa igʉtʉ wʉ ʉmʉbhɨrɨ? ");
INSERT INTO ikz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nawe ganʉ gakurwa mumunywa, gararwa mokoro yaazɨ, nego gakugirya abhenge. ");
INSERT INTO ikz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mokoro yʉ ʉmʉʉtʉ nɨmu gahaarwa amiisɨɨgi amabhɨ, ubhwiti, ʉbhʉsɨbhɨɨti, ɨtaarʉ, ubhwibhi, ʉrʉrɨmɨ na amatuki. ");
INSERT INTO ikz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gʉʉsi gayo, nego gahaakora ʉmʉʉtʉ abhenge. Nawe kurya utiisaabhirɨ amabhoko chɨmbu ikwenderwa kʉtakugirya obhenge.” ");
INSERT INTO ikz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mmbe, Yɨɨsu akabhʉʉka harya, akaja ʉrʉbhaara rwa zɨmbɨri za Tiiro na Sidʉʉni. ");
INSERT INTO ikz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Neho akarumana nʉ ʉmʉkari wʉmwɨ, aarɨ Mʉkanaani. Ʉmʉkari wuyo akaja kwawe aragamba kwiraka, “Ʉmʉkʉrʉ, Umwana wʉ ʉmʉtɨmi Daudi, ondorere ɨbhɨgʉngi! Umuucha waanɨ ana risambwa rɨramʉnyaacha bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nawe atamʉgarukiiryɨ ingʼana ryʉryʉsi. Neho, abhɨɨga bhaazɨ bhakamujaku na kʉmʉsabha bharabhuga, “Mutigɨ ajɨ, kʉ kʉbha angʼɨhirɨ kʉtʉrɨgɨsɨra ɨnʉ araturwa inyuma.” ");
INSERT INTO ikz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Akagarukirya, “Nitumirwɨ igʉrʉ wa Abhiiziraɨri, bhaangɨ zɨngʼʉndu zɨnʉ zibhurirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ʉmʉkari wuyo akiisuka kwa Yɨɨsu, akahigama mʉbhʉtangɨ bhwazɨ, akabhuga, “Ʉmʉkʉrʉ, nsakirya!” ");
INSERT INTO ikz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akamʉgarukirya, “Ɨtarɨ bhwaheene kogega ibhyakurya bhya abhaana na kʉtaashirya zimbwa.” ");
INSERT INTO ikz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ʉmʉkari wuyo akabhuga, “Nɨmbu ɨrɨ Ʉmʉkʉrʉ, nawe nʉʉrʉ zimbwa zʉʉsi zɨhaatoora amasaajʉ ganʉ gakotorobhoka haasɨ kurwa kwigari rya abhakʉrʉ bhaabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yɨɨsu akamʉgarukirya, “Ʉmʉkari wʉnʉ, ubhwisirirya bhwazʉ, nɨ‑bhʉkʉrʉ! Ekorwe kwa naawɨ chɨmbu ukwenda.” Hayohayo, umuucha waazɨ akahora. ");
INSERT INTO ikz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yɨɨsu akabhʉʉka hayo, akahɨta rusizʉ wɨ ɨnyanza ya Gariraaya. Akatiira kʉkɨgʉrʉ, akiikara iyo. ");
INSERT INTO ikz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abhaatʉ bhaaru bhakamujaku, bhakamoreetera amagata, abhahʉku, abharema, amamuumu na abharwɨrɨ abhandɨ bhaaru, bhakabhatʉʉra haguhɨ na amagʉrʉ gaazɨ, akabhahorya. ");
INSERT INTO ikz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abhaatʉ bhakarʉgʉʉra bhʉkʉngʼu hanʉ bhaarʉʉzɨ amamuumu garagamba, abharema bharahora, amagata garagenda na abhahʉku bhararora. Bhakagʉnga Mungu wa Iziraɨri. ");
INSERT INTO ikz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yɨɨsu akabhabhɨrɨkɨra abhɨɨga bhaazɨ, akabhuga, “Nɨrabharorera ɨbhɨgʉngi abhaatʉ bhanʉ, kʉ kʉbha twikɨɨrɨ nabhʉ zisikʉ isatʉ, nangwɨnʉ bhataana ibhyakurya. Nɨtakwenda nɨbharagɨ bhajɨ mʉzɨmbɨri zaabhʉ bhanɨ ɨnzara, kʉ kʉbha abhandɨ bharatʉra kugwa ubhwesa.” ");
INSERT INTO ikz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abhɨɨga bhaazɨ bhakamubhuurya, “Nangʉ, turi mwitɨrɨgʉ, na abhaatʉ, nɨ‑bhaaru. Tʉratʉra kobhona hayi ɨmɨkaatɨ ju ukwisa kubhiigutya bhʉʉsi?” ");
INSERT INTO ikz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yɨɨsu akabhabhuurya, “Mʉnɨ ɨmɨkaatɨ ɨrɨnga?” Bhakamʉgarukirya, “Tʉnajʉ muhungatɨ ni ibhiswɨ bhisuuhubhu.” ");
INSERT INTO ikz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mmbe, Yɨɨsu akaswaja abhaatʉ bhiikarɨ haasɨ. ");
INSERT INTO ikz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akagega ɨmɨkaatɨ muhungatɨ na ziiswɨ zirya akabhʉʉrɨra Mungu, azʉmiryɨ. Akʉmara akasunyura, akabhaha abhɨɨga bhaazɨ, bhakasondya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abhaatʉ bhʉʉsi bhakarya, bhakiigʉta. Akʉmara abhɨɨga bhakabhiringa amasaajʉ, bhakiizurya ɨbhɨhʉʉzʉ muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abhaatʉ bhanʉ bhaariirɨ bhaarɨ abhasubhɨ bhɨkwɨ bhene, kuruushaku abhakari na abhaana. ");
INSERT INTO ikz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Akʉmara Yɨɨsu akaraga abhaatʉ bhayo, akasikɨra mubhwatʉ, akaja ʉrʉbhaara rwa Magadaani. ");
INSERT INTO ikz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Akʉmara Abhafarisaayo na Abhasadukaayo bhakaja kwa Yɨɨsu komogema. Bhakamʉsabha akore ichɨrɨkɨnʼyʉ kwerecha kʉbha aaruurɨ kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yɨɨsu akabhagarukirya, “Hanʉ ikuhika ubhutikʉ, imwɨ mʉrabhuga, ‘Tabhʉʉri amasaarʉ garabha bhwaheene, kʉ kʉbha risaarʉ rere kore zenzota zɨbhanzirɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na ritabhʉʉri mʉrabhuga, ‘Reero ɨratweka imbura yʉ ʉmʉkama, kʉ kʉbha risaarʉ irabhuru na amasaarʉ gabhuukirɨ.’ Kanɨ, mwɨzɨ kwobhoora ibhyɨrɨkɨnʼyʉ bhya amasaarʉ, nawe mʉtakʉtʉra kwobhoora ibhyɨrɨkɨnʼyʉ bhya ribhaga rɨnʉ! ");
INSERT INTO ikz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Imwɨ urwibhʉrʉ ʉrʉbhɨ na rʉnʉ rʉtarɨ oroheene! Moreenda ichɨrɨkɨnʼyʉ, nawe mʉtakwerechwa ichɨrɨkɨnʼyʉ chʉchʉsi, kuruushaku kɨmwɨ kɨnʉ changɨ chʉ ʉmʉrʉʉtɨrɨri Yoona.” Neho Yɨɨsu akarwa hayo, akabhatiga. ");
INSERT INTO ikz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mmbe, abhɨɨga bha Yɨɨsu bhakaambʉka ɨnyanza, nawe bhaarɨ bhɨɨbhirɨ kogega ɨmɨkaatɨ. ");
INSERT INTO ikz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yɨɨsu akabhabhʉʉrɨra, “Mwiyangarɨrɨ nu ubhutunduuru bhwa Abhafarisaayo na Abhasadukaayo.” ");
INSERT INTO ikz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhɨɨga bhakatanga kʉgambana abheene kobheene, bharabhuga, “Arabhugabhu, kʉ kʉbha tʉtaagɨgirɨ ɨmɨkaatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yɨɨsu akamenya gʉʉsi ganʉ bhaarɨ bhakʉgambana, akabhabhuurya, “Imwɨ abhaatʉ bhu ubhwisirirya ubhusuuhu! Kwakɨ muriimonyerera kʉbha mʉtaana ɨmɨkaatɨ? ");
INSERT INTO ikz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kuhika nangʉ, mʉkɨɨrɨ komenya? Mʉtakuhiita chɨmbu abhaatʉ bhɨkwɨ bhɨtaanʉ bhiigutirɨ kwa mɨkaatɨ ɨtaanʉ girya? Mukiizurya ɨbhɨhʉʉzʉ bhɨrɨnga bhya amasaajʉ? ");
INSERT INTO ikz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hamwɨ mʉtakuhiita ɨmɨkaatɨ muhungatɨ girya, kʉbhaatʉ bhɨkwɨ bhene? Mukiizurya ɨbhɨhʉʉzʉ bhɨrɨnga bhya amasaajʉ? ");
INSERT INTO ikz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndora mʉtakwobhoora ganʉ nagambirɨ, ɨtarɨ igʉrʉ wɨ ɨmɨkaatɨ? Mmbe, nɨrabhuga, mwiyangarɨrɨ nu ubhutunduuru bhwa Abhafarisaayo na Abhasadukaayo.” ");
INSERT INTO ikz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Neho, abhɨɨga bhʉʉbhʉʉrirɨ kʉbha ataarɨ aragamba igʉrʉ wu kwiyangarɨra nu ubhutunduuru bhwo okokora ɨmɨkaatɨ, nawe igʉrʉ wa amiija gʉ ʉrʉrɨmɨ rwa Abhafarisaayo na Abhasadukaayo. ");
INSERT INTO ikz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hanʉ Yɨɨsu aahikirɨ ʉrʉbhaara rwa Kaisaariya‑Firipi, akabhabhuurya abhɨɨga bhaazɨ, “Abhaatʉ bharabhuga, Umwana wʉ Ʉmʉʉtʉ nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakamʉgarukirya, “Abhandɨ bharabhuga, naawɨ Yoohana Ʉmʉbhatiizi, abhandɨ bharabhuga awɨ, nɨ‑Ɨɨriya na abhandɨ bharabhuga awɨ, nɨ‑Yɨrɨmiya hamwɨ nɨ‑wʉmwɨ waho wa abharʉʉtɨrɨri bha Mungu abhandɨ bhɨ ɨkarɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yɨɨsu akabhabhuurya, “Na niimwɨ mʉrabhuga inyɨ, nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simʉʉni Peetero akamʉgarukirya, “Awɨ, ni‑Kiriisitʉ, Umwana wa Mungu wʉ ʉbhʉhʉru.” ");
INSERT INTO ikz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yɨɨsu akabhuga, “Hakɨrɨku awɨ Simʉʉni umwana wa Yoona, ʉhakirwɨ, kʉ kʉbha atareeho ʉmʉʉtʉ wʉnʉ akuhumburiirɨ amaheene ganʉ, nawe nɨ‑Bhaabha wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inyɨ nɨrakʉbhʉʉrɨra, awɨ Peetero, awɨ ni‑ritarɨ, ni igʉrʉ wa ritarɨ rɨnʉ, nɨrʉʉmbaka risengerero ryanɨ, na zinguru zu uruku zɨtakurihiza. ");
INSERT INTO ikz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Inyɨ nɨrakoha zihunguru zʉ ʉbhʉtɨmi bhwa mwisaarʉ. Amangʼana gʉʉsi ganʉ ʉkʉbha waangirɨ kʉʉsɨ, garabha gaangirwɨ mwisaarʉ. Na ganʉ uriisiriryɨ kʉʉsɨ, garabha giisiririibhwɨ mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Neho akabhahama abhɨɨga bhaazɨ kʉbha, bhatabhʉʉrɨra ʉmʉʉtʉ wʉwʉʉsi kʉbha ewe newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kʉtangɨra ribhaga riyo, Yɨɨsu akatanga kʉragɨrɨra abhɨɨga bhaazɨ habhwɨrʉ kʉbha areenderwa ajɨ Yɨrusarɨɨmu, na anyaakibhwɨ bhʉkʉngʼu. Akabhabhʉʉrɨra, aranyaakibhwa na abhakaruka bha Abhayaahudi, na abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa, kuhika kwitwa. Nawe urusikʉ rwa katatʉ kwɨma ukukwa kwazɨ, araryʉka. ");
INSERT INTO ikz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Neho Peetero akamuhira Yɨɨsu rusizʉ, akatanga komorecha arabhuga, “Ʉmʉkʉrʉ, Mungu agahityɨ gayo kore! Gataaza kokobhona!” ");
INSERT INTO ikz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nawe Yɨɨsu akiichʉra, akabhʉʉrɨra Peetero, “Shɨtaani, nuurwɨ inyuma waanɨ! Ʉragema kundibhɨra kokora chɨmbu Mungu akwenda! Amiisɨɨgi gaazʉ gatarɨ ga Mungu, nawe ga abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mmbe, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ areende kuntuna, areenderwa iyangɨ umwene, agege ʉmʉsarabha gwazɨ, antunɨ. ");
INSERT INTO ikz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ʉmʉʉtʉ wʉnʉ akwenda kohonʼya ʉbhʉhʉru bhwazɨ umwene, arabhurimirya. Nawe ʉmʉʉtʉ wʉnʉ akurimirya ʉbhʉhʉru bhwazɨ igʉrʉ waanɨ, arabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ʉmʉʉtʉ arabhona bhwerakɨ, areebhone ebhegero ubhuniibhi bhwʉsi mʉʉsɨ yɨnʉ, nawe arimiryɨ ʉbhʉhʉru bhwa kemerano? Nangʉ, ʉmʉʉtʉ aratʉra kuhuruchakɨ kobhona ʉbhʉhʉru bhwa kemerano? Kɨtareeho ekegero chʉchʉsi! ");
INSERT INTO ikz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Umwana wʉ Ʉmʉʉtʉ araaza hamwɨmwɨ na bhamaraika bhaazɨ mʉbhʉkʉrʉ bhwa Wiisɨ. Neho araarɨhɨ abhaatʉ bhʉʉsi kʉrɨngʼaana na amahocha gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nɨrabhabhʉʉrɨra amaheene, bhareho abhaatʉ gatɨ waanyu hanʉ, bhanʉ bhatakukwa bhakɨɨrɨ korora Umwana wʉ Ʉmʉʉtʉ araaza mʉbhʉtɨmi bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hanʉ zaahitirɨ sikʉ isaasabha, Yɨɨsu akagega Peetero, Yaakobho na Yoohana umuhiiri wa Yaakobho, akatiira nabhʉ igʉrʉ kʉkɨgʉrʉ ɨkɨrɨɨhu, bhakaja kekoro. ");
INSERT INTO ikz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hanʉ bhaarɨ hayo, Yɨɨsu akiichʉra mʉbhʉtangɨ bhwabhʉ. Ubhushʉ bhwazɨ bhʉkabharya nchi iryʉbha na amiibhoho gaazɨ gakabha mɨɨrʉ bhʉkʉngʼu nchu ubhwɨrʉ bhwi iryʉbha. ");
INSERT INTO ikz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hayohayo, bhakahwarʉka abharʉʉtɨrɨri Musa na Ɨɨriya bharagambana nawe. ");
INSERT INTO ikz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Neho Peetero akabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ, nɨ‑bhwaheene itwɨ tʉbhɨ hanʉ. Arɨɨbhɨ uriisirirya, nɨrʉʉmbaka hanʉ ibhituku bhɨtatʉ. Ɨkɨmwɨ ichazʉ, ɨkɨndɨ cha Musa nɨ ɨkɨndɨ cha Ɨɨriya.” ");
INSERT INTO ikz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hanʉ Peetero aarɨ achagamba, hayohayo, rɨkaaza risaarʉ iryɨrʉ rya pee na kʉbhakundikirya. Akʉmara bhakiigwa riraka kurwa mwisaarʉ riyo rɨrabhuga, “Wʉnʉ ni‑Mwana waanɨ ʉmʉsɨɨgwa, nɨzʉmɨrɨɨrwɨ nawe. Mumwitegeerere!” ");
INSERT INTO ikz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hanʉ abhɨɨga bhaazɨ bhiigwirɨ gayo, bhakʉʉbhaha bhʉkʉngʼu, bhakagwa haasɨ kibhumɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yɨɨsu akiisuka haguhɨ nabhʉ, akabhakunʼyaku, akabhabhʉʉrɨra, “Mwimɨɨrɨrɨ, mʉtʉʉbhaha!” ");
INSERT INTO ikz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hanʉ bhaanungirɨ amɨɨsʉ gaabhʉ, bhakarora Yɨɨsu asaagirɨ umwene. ");
INSERT INTO ikz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hanʉ bhaarɨ bhakwika kʉkɨgʉrʉ hayo, Yɨɨsu akabhaswaja akabhuga, “Mʉtaaza mʉbhʉʉrɨrɨ ʉmʉʉtʉ wʉwʉʉsi ganʉ mʉrʉʉzɨ kuhika hanʉ Umwana wʉ Ʉmʉʉtʉ akuryʉka kurwa mʉbhaku.” ");
INSERT INTO ikz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhɨɨga bhaazɨ bhakamubhuurya, “Ndora abhiija bhi imigirʉ ja Musa bhahaabhuga, ereenderwa Ɨɨriya akangatɨrɨ Kiriisitʉ kuuza?” ");
INSERT INTO ikz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yɨɨsu akabhagarukirya, “Maheene, Ɨɨriya areenderwa kuuza hinga korereke atʉʉrɨ bhwaheene amangʼana gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nɨrabhabhʉʉrɨra kʉbha Ɨɨriya amarirɨ kuuza, nawe abhaatʉ bhataamʉmɨnyirɨ, bhʉʉsi bhakamokorera amabhɨ gʉʉsi ganʉ bhɨɨndirɨ. Ɨbhuɨbhu nu Umwana wʉ Ʉmʉʉtʉ, aranyaakibhwa mʉmabhoko gaabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Neho abhɨɨga bhaazɨ bhakoobhoora kʉbha Yɨɨsu aarɨ aragamba igʉrʉ wa Yoohana Ʉmʉbhatiizi. ");
INSERT INTO ikz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaahikirɨ kwiribhita rya abhaatʉ rɨnʉ ryarɨ ryibhiringirɨ, ʉmʉʉtʉ wʉmwɨ akaaza kwa Yɨɨsu, akahigama mʉbhʉtangɨ bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Akabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ, nɨrasabha omororere ɨbhɨgʉngi umwana waanɨ! Anu ubhurwɨrɨ bhwa ririmu, nu ubhurwɨrɨ bhuyo bhʉhaamʉnyaacha bhʉkʉngʼu. Manga kaaru ahaagwa momorero hamwɨ mʉmanzi. ");
INSERT INTO ikz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɨkamuhira kʉbhɨɨga bhaazʉ korereke bhamohorye, nawe bhataaturirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yɨɨsu akabhuga, “Imwɨ urwibhʉrʉ rʉnʉ rʉtakwisirirya, rʉnʉ rurimiirɨ! Niriikara na niimwɨ na kubhiigumirirya kuhika ryʉrɨ? Momoreete hanʉ umwana wuyo.” ");
INSERT INTO ikz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hanʉ bhiizirɨ nawe, Yɨɨsu akahaarɨra risambwa riyo, rɨkamurwɨku. Hayohayo, umwana akahora. ");
INSERT INTO ikz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Akʉmara abhɨɨga bha Yɨɨsu bhakamuuzaku rusizʉ, bhakamubhuurya, “Kwakɨ itwɨ tʉkatamwa kumuruusha risambwa?” ");
INSERT INTO ikz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ewe akabhagarukirya, “Nɨ‑kʉ kʉbha yu ubhwisirirya bhwanyu bhʉtakwisa. Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ munu ubhwisirirya nche ekerengo che endetere isuuhu yɨ ɨharadaari, mʉrabhʉʉrɨra ɨkɨgʉrʉ kɨnʉ, ‘Ihɨka hanʉ, ujɨ harya,’ chʉsi charweho. Na kɨtakʉbhaho ekegero kɨnʉ kɨtakʉtʉrɨkana kwa niimwɨ.  ");
INSERT INTO ikz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hamwɨmwɨ na gayo, mʉtakʉtʉra koheebha risambwa ncha riyo, nawe nɨ‑kʉnzɨra yʉ ʉkʉsabha Mungu na kwiyima kurya.” ");
INSERT INTO ikz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hanʉ Yɨɨsu aarɨ hamwɨmwɨ na abhɨɨga bhaazɨ mucharʉ cha Gariraaya, akabhabhʉʉrɨra, “Umwana wʉ Ʉmʉʉtʉ, araja kuhurukibhwa mʉmabhoko ga abhaatʉ na bharamwita. Nawe urusikʉ rwa katatʉ, Mungu aramuryʉra.” ");
INSERT INTO ikz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hanʉ abhɨɨga bhaazɨ bhiigwirɨ gayo, bhakarumɨka bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaahikirɨ Kapɨrinaumu, abhaatʉ obhorebhe bhanʉ bhaarɨ bhararihya rigʉʉti igʉrʉ wa rihekaaru rya Mungu, bhakaaza kwa Peetero. Bhakamubhuurya, “Umwija waanyu wʉʉsi ahaahurucha rigʉʉti rya rihekaaru rya Mungu?” ");
INSERT INTO ikz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peetero akabhagarukirya, “Nɨmbu ɨrɨ, ahaahurucha.” Neho akasikɨra munyumba. Nawe Peetero aarɨ akɨɨrɨ kʉgamba ringʼana ryʉryʉsi, Yɨɨsu akatanga kubhuurya, “Simʉʉni, awɨ ʉrarorabhwɨ? Abhatɨmi bha mʉʉsɨ yɨnʉ bharatobha rigʉʉti kʉbhaana bhaabhʉ hamwɨ kʉbhandɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peetero akamʉgarukirya, “Bharatobha kʉbhandɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Arɨɨbhɨ nɨmbu ɨrɨ, mmbe abhaana bhaabhʉ bhabhɨɨrɨɨrwɨ kotobha rigʉʉti. ");
INSERT INTO ikz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nawe tʉtaaza kwigatanʼya abhaatʉ, awɨ nuujɨ mʉnyanza, uhunjɨ riirobho. Gega iiswɨ ye embere yɨnʉ ikwihatya, yaasamyɨ umunywa, ʉrabhonamu zimpirya. Akʉmara ozegege zimpirya ziyo, ujɨ ʉrɨhɨ rigʉʉti ryanɨ ni iryazʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ribhaga riyo, abhɨɨga bha Yɨɨsu bhakamuuzaku, bhakamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","“Nɨ‑wɨɨwɨ ʉmʉkʉrʉ kʉkɨra abhandɨ mʉbhʉtɨmi bhwa mwisaarʉ?” Yɨɨsu akabhɨrɨkɨra umwana wʉmwɨ, akamwimiirirya mʉbhʉtangɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Akabhuga, “Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ mʉtakwichʉra na kʉbha ncha abhaana abhasuuhu, mʉtakusikɨra zee mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mmbe wʉwʉʉsi wʉnʉ akwiyicha na kʉbha nchu umwana umusuuhu wʉnʉ, wuyo newe ʉmʉkʉrʉ mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na wʉwʉʉsi wʉnʉ araaginihyɨ umwana umusuuhu ncha wʉnʉ kuriina ryanɨ, aranginihya inyɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nawe wʉnʉ araahabhyɨ wʉmwɨ gatɨ wa abhasuuhu bhanʉ bhakunyiisirirya akore ʉbhʉbhɨ, ɨnyaakʉ yaazɨ ɨrabha kʉrʉ bhʉkʉngʼu. Hakɨrɨku abhoherwe ʉrʉbhwɨ mwigʉti na korekerwa mubhwina bhwɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Horeera imwɨ bhɨ ɨɨsɨ yɨnʉ, kʉ kʉbha yo okokora amangʼana ganʉ gakugirya abhaatʉ bhakore ʉbhʉbhɨ! Ebhegemo bhereenderwa kʉbhaho, nawe horeera kʉmʉʉtʉ wʉnʉ araagiryɨ ibhitimotimo bhiyo! ");
INSERT INTO ikz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arɨɨbhɨ okobhoko kwazʉ hamwɨ ʉkʉgʉrʉ kwazʉ kʉragirya okore ʉbhʉbhɨ, ʉkʉtɨnɨ na kʉtaasha kore. Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano no obhorema, kʉkɨra kʉbha na amagʉrʉ gʉʉsi abhɨrɨ hamwɨ amabhoko gʉʉsi abhɨrɨ nawe ʉkarekerwa momorero gwa nyaari. ");
INSERT INTO ikz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naatu, arɨɨbhɨ iriisʉ ryazʉ rɨraagiryɨ okore ʉbhʉbhɨ, ryihɨ na korerekera kore! Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano ne esongo, kʉkɨra kʉbha na amɨɨsʉ gʉʉsi abhɨrɨ na korekerwa momorero gwa nyaari.” ");
INSERT INTO ikz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Mʉbhɨ mɨɨsʉ, mʉtarega wʉmwɨ mʉbhasuuhu bhanʉ! Nɨrabhabhʉʉrɨrabhu, kʉ kʉbha bhamaraika bhaabhʉ mwisaarʉ, ribhaga ryʉsi bharɨ mʉbhʉtangɨ bhwa Bhaabha waanɨ wa mwisaarʉ.  ");
INSERT INTO ikz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Umwana wʉ Ʉmʉʉtʉ, izirɨ mʉʉsɨ korereke asabhʉrɨ abhaatʉ bhanʉ bhabhurirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mʉrarorabhwɨ, arɨɨbhɨ ʉmʉʉtʉ na zɨngʼʉndu igana rɨmwɨ, yɨmwɨ ɨkabhʉra, arakorabhwɨ? Ahaatiga hinga merongo kenda na kenda mʉkɨgʉrʉ, na kuja komohya yɨmwɨ yɨnʉ ibhurirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nɨrabhabhʉʉrɨra amaheene, araayebhone, arazomerwa bhʉkʉngʼu igʉrʉ wɨ ɨngʼʉndu yɨmwɨ yiyo, kʉkɨra zɨngʼʉndu zirya merongo kenda na kenda zɨnʉ zɨtaabhurirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Ɨbhuɨbhu, Bhaabha waanyu wa mwisaarʉ, atakwenda nʉʉrʉ wʉmwɨ mʉbhasuuhu bhanʉ arimɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Arɨɨbhɨ umwisirirya ʉmʉkɨndichazʉ akʉsaririiryɨ, nuujɨ omoreche imubheene bhabhɨrɨ. Ariikwigwɨ, ʉrabha ubhwɨnɨ umwisirirya ʉmʉkɨndichazʉ. ");
INSERT INTO ikz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nawe arɨɨbhɨ akɨɨrɨ kukwigwa, nuujɨ ogege ʉmʉʉtʉ ʉwʉndɨ wʉmwɨ hamwɨ bhabhɨrɨ korereke ‘bhabheho abhamɨnyɨɨkɨrɨri bhabhɨrɨ hamwɨ bhatatʉ bho okomenyeekererya amangʼana gayo.’ ");
INSERT INTO ikz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na araangɨ kwigwa na bhayo, nuujɨ ʉbhʉʉrɨrɨ risengerero. Araatamɨ kwigwa na risengerero, mʉmʉbharɨrɨ ncha abhaatʉ bhanʉ bhatɨɨzɨ Mungu hamwɨ umurihya wa rigʉʉti. ");
INSERT INTO ikz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nɨrabhabhʉʉrɨra amaheene, amangʼana gʉʉsi ganʉ ʉkʉbha waangirɨ kʉʉsɨ, garabha gaangirwɨ mwisaarʉ. Na ganʉ ʉraagiisiriryɨ kʉʉsɨ, garabha giisiririibhwɨ mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nɨrabhabhʉʉrɨra naatu, arɨɨbhɨ bhabhɨrɨ gatɨ waanyu bhariisiriranʼyɨ kʉʉsɨ yɨnʉ kʉsabha ringʼana obhorebhe, Bhaabha waanɨ wa mwisaarʉ arabhakorera ringʼana riyo. ");
INSERT INTO ikz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kʉ kʉbha arɨɨbhɨ bhareho nʉʉrʉ bhabhɨrɨ hamwɨ bhatatʉ bhanʉ bhiibhiringirɨ kuriina ryanɨ, na niinyɨ nɨrabha hamwɨmwɨ nabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Neho Peetero akaaza kwa Yɨɨsu, akamubhuurya, “Ʉmʉkʉrʉ, arɨɨbhɨ umwisirirya ʉmʉkɨndichanɨ ansaririiryɨ, nereenderwa nemobheerere manga karɨnga? Manga muhungatɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yɨɨsu akamʉgarukirya, “Nɨkʉbhʉʉrɨrɨ, ɨtarɨ manga muhungatɨbhu, nawe omobheerere ʉmʉkɨndichazʉ muhungatɨ manga merongo muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nɨrabhabhʉʉrɨrabhu, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nʉ ʉmʉtɨmi wʉmwɨ wʉnʉ ɨɨndirɨ kokora ʉbhʉbhari na abhahocha bhɨ ɨsɨrɨkaarɨ yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hanʉ ʉmʉtɨmi aatangirɨ kʉrʉʉha ɨbhɨtabhʉ, akareeterwa omohocha wʉmwɨ wʉnʉ aarɨ ani isiirɨ ya zimpirya nzaru bhʉkʉngʼu, zɨtaranta bhɨkwɨ ikumi. ");
INSERT INTO ikz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Omohocha wuyo ataaturirɨ kʉrɨha isiirɨ yɨnʉ aarɨ nayo. Neho ʉmʉtɨmi akaswaja kʉbha ʉmʉʉtʉ wuyo aguribhwɨ ewe, mʉkaazɨ, abhaana bhaazɨ ne ebhegero bhyazɨ bhyʉsi, korereke arɨhɨ isiirɨ yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Omohocha wuyo akahigama mʉbhʉtangɨ bhwʉ ʉmʉtɨmi, akamwisasaama, ‘Nɨrasabha unyiigumiriryɨ, nɨrarɨha isiirɨ yaanɨ yʉʉsi!’ ");
INSERT INTO ikz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Neho, ʉmʉtɨmi akamororera ɨbhɨgʉngi omohocha waazɨ, akamobheerera isiirɨ yaazɨ yʉʉsi, akamutiga ajɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Hanʉ omohocha wuyo aahurukirɨ igʉtʉ, akabhona omohocha ʉmʉkɨndichazɨ wʉnʉ aarɨ amʉhɨɨrɨ ekerengo kisuuhu bhʉkʉngʼu cha zidinaari igana rɨmwɨ. Hayohayo, akamugwata mwimero, akamʉbhʉʉrɨra, ‘Ndɨha isiirɨ yaanɨ!’ ");
INSERT INTO ikz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Omohocha ʉmʉkɨndichazɨ akahigama mʉbhʉtangɨ bhwazɨ, akamwisasaama, ‘Nɨrasabha unyiigumiriryɨ, nɨrakʉrɨha isiirɨ yaazʉ yʉʉsi!’ ");
INSERT INTO ikz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nawe akaanga, akaja komobhoha ʉmʉkɨndichazɨ mokebhoho, kuhika ribhaga rɨnʉ araarɨhɨ isiirɨ yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Hanʉ abhahocha abhakɨndichazɨ bhaarʉʉzɨ ringʼana riyo, bhakanyahaarɨka mozekoro zaabhʉ. Bhakaja kʉmʉtɨmi waabhʉ na kʉmʉbhʉʉrɨra gʉʉsi ganʉ gakʉrirwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Neho ʉmʉtɨmi akabhɨrɨkɨra omohocha wʉnʉ aabhɨɨrɨɨrɨ isiirɨ yaazɨ, akamʉbhʉʉrɨra, ‘Awɨ ne‑mohocha mʉbhɨ! Rora, hanʉ wansabhirɨ kʉbha nekobheerere isiirɨ yaazʉ, nɨkakobheerera yʉʉsi! ");
INSERT INTO ikz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Awɨ ʉtamirwɨ komororera ɨbhɨgʉngi omohocha ʉmʉkɨndichazʉ, chɨmbu inyɨ nakʉrʉrɨɨrɨ ɨbhɨgʉngi?’ ");
INSERT INTO ikz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Mmbe, ʉmʉtɨmi akiigatana bhʉkʉngʼu, akaswaja abhasirikarɨ bhaazɨ, bhamʉgwatɨ na kʉmʉtʉʉra mokebhoho, bhamʉnyaachɨmu, kuhika hanʉ araamʉrɨhɨ isiirɨ yʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Akʉmara, Yɨɨsu akamara kwa kʉgamba, “Momenye kʉbha nʉʉrʉ Bhaabha waanɨ wa mwisaarʉ, arabhakorera na niimwɨ ɨbhuɨbhu, arɨɨbhɨ mʉraanga kobheerera ʉmʉkɨndichanyu kumyʉyʉ janyu jʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo, akabhʉʉka Gariraaya, akahɨta rusizʉ, mucharʉ kɨnʉ kiri imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani kuja mucharʉ cha Yudeya. ");
INSERT INTO ikz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Abhaatʉ bhaaru bhakabha bharamutuna iyo, nawe akahorya abharwɨrɨ bhanʉ bhaarɨ gatɨ waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Neho Abhafarisaayo obhorebhe bhakaaza kwa Yɨɨsu korereke bhamogeme. Bhakabhuurya, “Awɨɨ, nɨ‑bhwaheene umusubhɨ kʉtaana na mʉkaazɨ igʉrʉ wa ryʉryʉsi rirya?” ");
INSERT INTO ikz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yɨɨsu akabhagarukirya, “Imwɨ mʉkɨɨrɨ kosoma mʉMaandɨkʉ Amarɨndu kʉbha kwɨma ubhubhumbi ‘Mungu akabhʉmba umusubhɨ nʉ ʉmʉkari’? ");
INSERT INTO ikz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Akabhuga, ‘Igʉrʉ wa gayo, umusubhɨ aratiga wiisɨ na unina, aragwatana na mʉkaazɨ. Bhabhɨrɨ bhayo bharabha mʉbhɨrɨ gʉmwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na bhatakʉbha bhabhɨrɨ kwikɨ, nawe nɨ‑mʉbhɨrɨ gʉmwɨ. Mmbe, kɨnʉ kɨgwataniibhwɨ na Mungu, mʉʉtʉ atakɨtaanʼya.” ");
INSERT INTO ikz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nawe, Abhafarisaayo bhakamubhuurya, “Arɨɨbhɨ ganʉ nɨ‑maheene, nɨkɨ Musa akaraganʼya umusubhɨ amohe ʉmʉkari waazɨ ɨnyarʉbha yʉ ʉkʉtaana na komoheebha?” ");
INSERT INTO ikz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yɨɨsu akabhagarukirya, “Musa akabhiisirirya moheebhe abhakari bhaanyu, kʉ kʉbha yʉ ʉbhʉkʉngʼu bhwi imyʉyʉ janyu, nawe kwɨma ʉbhʉtangɨ bhwu ubhubhumbi, bhʉtaarɨ ubhwɨndi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araatigɨ mʉkaazɨ, ɨtarɨ igʉrʉ wu ubhusiihya, na kukwɨra ʉmʉkari ʉwʉndɨ, wuyo arasebheeta. Nu umusubhɨ wʉnʉ akukwera ʉmʉkari wʉnʉ atigirwɨ, wʉʉsi arasebheeta.” ");
INSERT INTO ikz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Neho abhɨɨga bhaazɨ bhakamʉbhʉʉrɨra, “Arɨɨbhɨ nɨmbu kumusubhɨ nʉ ʉmʉkari, nɨ‑hakɨrɨku ʉmʉʉtʉ atakwɨra!” ");
INSERT INTO ikz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yɨɨsu akabhagarukirya, “Ɨtarɨ bhʉʉsi bharatʉra kʉrɨsʉngʼaana ringʼana rɨnʉ, nawe bhanʉ Mungu abhanagiryɨ kʉtama kukwɨra. ");
INSERT INTO ikz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nɨrabhugabhu, kʉ kʉbha bhareho abhandɨ bhanʉ bhatakukwɨra kʉ kʉbha bhakiibhurwa bhazigaru. Abhandɨ bhatakukwɨra kʉ kʉbha abhaatʉ bhabhasʉrʉʉrirɨ korereke bhatabha bhariibhʉra. Na bhareho na abhandɨ bhanʉ bhatakukwɨra kʉ kʉbha yʉ ʉbhʉtɨmi bhwa mwisaarʉ. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akʉtʉra kʉsʉngʼaana ringʼana riyo, arɨsʉngʼaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mmbe, abhiibhuri obhorebhe bhakareeta abhaana abhasuuhu kwa Yɨɨsu korereke abhahakɨ kʉbhatʉʉrɨra amabhoko na kʉbhasabhɨra. Nawe abhɨɨga bhaazɨ bhakabhahaarɨra. ");
INSERT INTO ikz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Neho Yɨɨsu akabhabhʉʉrɨra, “Mutigɨ abhaana abhasuuhu bhaazɨ kwa niinyɨ! Mʉtabharecha, kʉ kʉbha ʉbhʉtɨmi bhwa mwisaarʉ nɨ‑bhwa abhaatʉ bhanʉ bhaangɨ ncha abhaana.” ");
INSERT INTO ikz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yɨɨsu akahaka abhaana bhayo, akʉmara akabhʉʉka ahagero hayo. ");
INSERT INTO ikz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Akʉmara ʉmʉʉtʉ wʉmwɨ akaaza kwa Yɨɨsu, akamubhuurya, “Umwija, nekore ingʼanakɨ rizʉmu korereke nebhone ʉbhʉhʉru bhwa kemerano?” ");
INSERT INTO ikz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yɨɨsu akamʉgarukirya, “Kwakɨ ʉrambuurya inyɨ igʉrʉ wa ringʼana rizʉmu? Rora, Mungu umwene newe ʉmʉzʉmu! Nawe arɨɨbhɨ oreenda kusikɨra kʉbhʉhʉru bhwa kemerano, ugwatɨ imigirʉ ja Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Umumura wuyo akamubhuurya, “Migirʉkɨ?” Yɨɨsu akamʉgarukirya, “Utiita, ʉtasebheeta, utiibha, ʉtagobha mʉʉtʉ, ");
INSERT INTO ikz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ʉsʉʉkɨ wuusʉ na onyoko, ʉmʉsɨɨgɨ nyarʉbhɨri waazʉ chɨmbu wisɨɨgirɨ aumwene.” ");
INSERT INTO ikz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umumura wuyo akabhuga, “Imigirʉ jʉsi giyo nigigwatirɨ. Nekorekɨ ɨkɨndɨ kɨnʉ kisuuhirɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yɨɨsu akamʉbhʉʉrɨra, “Arɨɨbhɨ oreenda kʉbha ʉmʉʉtʉ wʉnʉ ataana isoro, nuujɨ uguryɨ ebhegero bhyʉsi bhɨnʉ ʉnabhyʉ, zimpirya ziyo ʉbhahɨ abhahabhɨ, na ʉrabha ni ikibhumbɨkʉ kwa Mungu. Akʉmara uuzɨ untunɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hanʉ umumura wuyo iigwirɨ gayo, akaja arumikirɨ bhʉkʉngʼu, kʉ kʉbha aarɨ ne ebhegero bhyaru. ");
INSERT INTO ikz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Neho Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ akabhuga, “Nɨrabhabhʉʉrɨra amaheene, ɨrabha kʉkʉngʼu kumuniibhi kusikɨra mʉbhʉtɨmi bhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nɨrabhabhʉʉrɨra naatu, nɨ‑kʉnyʉʉhu ɨngamiya kʉhɨta mwibhanga ryi isindanʉ, kʉkɨra umuniibhi kusikɨra mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hanʉ abhɨɨga bhaazɨ bhiigwirɨ ɨbhu, bhakarʉgʉʉra bhʉkʉngʼu, bhakamubhuurya, “Nangʉ, nɨ‑wɨɨwɨ wʉnʉ akʉtʉra kʉsabhurwa?” ");
INSERT INTO ikz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yɨɨsu akabhamogorera, akabhabhʉʉrɨra, “Kʉbhaatʉ gatakʉtʉrɨkana, nawe kwa Mungu gʉʉsi garatʉrɨkana.” ");
INSERT INTO ikz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peetero akamʉbhʉʉrɨra, “Rora, itwɨ tutigirɨ ebhegero bhyʉsi, tukutunirɨ! Mmbe, na niitwɨ tʉrabhonakɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yɨɨsu akabhagarukirya, “Nɨrabhabhʉʉrɨra amaheene, Umwana wʉ Ʉmʉʉtʉ arabha ikɨɨrɨ nchʉ ʉmʉtɨmi kukitumbɨ chazɨ, mʉʉsɨ iihya. Mmbe, ribhaga riyo na niimwɨ bhanʉ muntunirɨ, muriikara kubhitumbɨ bhyɨ ɨkɨtɨmi ikumi na bhɨbhɨrɨ, ɨnʉ mʉratɨnɨra ɨbhɨgambʉ ikumi na bhɨbhɨrɨ bhya Iziraɨri. ");
INSERT INTO ikz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mmbe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ atigirɨ inyumba, umwabhʉ, umusubhaati, wiisɨ, unina, abhaana hamwɨ ɨmɨgʉndʉ igʉrʉ waanɨ, arasʉngʼaana bhyʉsi kubhwaru bhʉkʉngʼu. Hamwɨmwɨ na gayo, arabhona ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nawe, abhaatʉ bhaaru bhanʉ bhakusuukwa ribhaga rɨnʉ, bhatakusuukwa ribhaga rɨnʉ rikuuza. Na bhanʉ bhatakusuukwa ribhaga rɨnʉ, bharasuukwa ribhaga rɨnʉ rikuuza.” ");
INSERT INTO ikz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yɨɨsu akangʼeha kʉgamba, “Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ na wʉ ʉmʉgʉndʉ, wʉnʉ aahurukirɨ ritabhʉʉri ziri kuja koha abhaatʉ emeremo mʉmʉgʉndʉ gwazɨ gwɨ ɨmɨzabhiibhu. ");
INSERT INTO ikz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hanʉ aamarirɨ kwigwana nabhʉ kʉbha abharɨhɨ wʉmwɨ wʉmwɨ amarihi gu urusikʉ rʉmwɨ, akabhatʉma mʉmʉgʉndʉ. ");
INSERT INTO ikz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Hanʉ yaahikirɨ zɨɨsa isatʉ ritabhʉʉri, akahʉrʉka kuja mwisoko, akarora abhaatʉ abhandɨ bhiimiiriirɨ bhataana moremo. ");
INSERT INTO ikz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akabhabhʉʉrɨra, ‘Na niimwɨ mujɨ mohoche mʉmʉgʉndʉ gwanɨ gwɨ ɨmɨzabhiibhu, nɨrabharɨha ichanyu.’ ");
INSERT INTO ikz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bhʉʉsi bhakaja. “Mmbe hanʉ yaahikirɨ mumwise, akahʉrʉka kuja kʉbhaha abhandɨ emeremo mʉmʉgʉndʉ gwazɨ. Na zɨkahɨta zɨɨsa isatʉ, akakorabhu naatu. ");
INSERT INTO ikz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hanʉ yaahikirɨ ɨsa ikumi na yɨmwɨ rigoroobha, akahʉrʉka naatu kuja mwisoko, akabhona abhandɨ bhiimiiriirɨ. Akabhabhuurya, ‘Ndora mwimiiriirɨ hanʉ urusikʉ rugima mʉtaana moremo?’ ");
INSERT INTO ikz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Bhakamʉgarukirya, ‘Nɨ‑kʉ kʉbha atareeho wʉnʉ atʉhɨɨrɨ emeremo.’ “Akabhabhʉʉrɨra, ‘Na niimwɨ mujɨ mokore emeremo mʉmʉgʉndʉ gwɨ ɨmɨzabhiibhu.’ ");
INSERT INTO ikz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mʉkabhuribhuri, umwene mʉgʉndʉ akabhʉʉrɨra umwimiiririri we emeremo, ‘Bhɨrɨkɨra abhahocha bhʉʉsi, ʉbharɨhɨ amarihi gaabhʉ, ʉtangɨ na bhanʉ bhaarumusiirɨ na kʉmariirya na bhanʉ bhaakangatirɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Neho abhahocha bhanʉ bhaatangirɨ emeremo rigoroobha, bhakaaza bhakahaabhwa amarihi gu urusikʉ rʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hanʉ abhahocha bhanʉ bhaatangirɨ emeremo ritabhʉʉri bhiizirɨ, bhakakina bhararihwa nzaru kʉkɨra abhakɨndichabhʉ bhanʉ bhaarumusiirɨ. Nawe wʉmwɨwʉmwɨ akarihwa zimpirya ziryazirya za amarihi gu urusikʉ rʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hanʉ bhaarihirwɨ amarihi gaabhʉ, bhakatanga kwibheerya kwa wʉ ʉmʉgʉndʉ ");
INSERT INTO ikz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bharabhuga, ‘Abhaatʉ bharya bhaarumusiirɨ, bhakʉrirɨ emeremo kwɨ ɨɨsa yɨmwɨbhu! Ɨbhɨɨrɨbhwɨ uturihirɨ kɨrɨngʼɨɨnɨ nabhʉ, ɨnʉ itwɨ tʉkʉrirɨ emeremo ɨmɨkʉngʼu bhʉkʉngʼu ne endekeera itusiriirɨku ryʉbha nyangima?’ ");
INSERT INTO ikz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wʉ ʉmʉgʉndʉ akagarukirya wʉmwɨ mʉbhahocha bhayo, ‘Mʉsaani waanɨ, nɨkɨɨrɨ kʉkʉkangirirya chʉchʉsi. Awɨɨ, tutiisirirɨɨnʼyɨ kʉbha ʉrakora emeremo kʉmarihi gu urusikʉ rʉmwɨ? ");
INSERT INTO ikz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gega zimpirya zaazʉ ujɨ. Inyɨ nɨsɨɨgirɨ kʉmʉrɨha ʉmʉʉtʉ wa mʉtɨnɨrʉ amarihi kɨrɨngʼɨɨnɨ na gaazʉ. ");
INSERT INTO ikz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nangʉ, nɨtakwisiriribhwa kokorera zimpirya zaanɨ chɨmbu nikwenda? Hamwɨ ʉna rihari kʉ kʉbha inyɨ muhurucha bhʉkʉngʼu kʉbhandɨ?’ ” ");
INSERT INTO ikz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yɨɨsu akamariirya kwa kʉgamba, “Nawe, abhaatʉ bhaaru bhanʉ bhakusuukwa ribhaga rɨnʉ, bhatakusuukwa ribhaga rɨnʉ rikuuza. Na bhanʉ bhatakusuukwa ribhaga rɨnʉ, bharasuukwa ribhaga rɨnʉ rikuuza.” ");
INSERT INTO ikz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hanʉ Yɨɨsu aarɨ mʉnzɨra araja Yɨrusarɨɨmu, akagega abhɨɨga bhaazɨ ikumi na bhabhɨrɨ rusizʉ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Rora, tʉraja Yɨrusarɨɨmu. Iyo, Umwana wʉ Ʉmʉʉtʉ aragwatwa na kuhirwa kʉbhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa. Bhayo bharatɨnɨra iitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Akʉmara, bharamuhira kʉBharuumi korereke bhamorege, bhamoteme ɨmɨzariti na komotemerera kʉmʉsarabha. Nawe urusikʉ rwa katatʉ, Mungu aramuryʉra.” ");
INSERT INTO ikz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Neho, ʉmʉkari wa Zebhedaayo akaaza kwa Yɨɨsu hamwɨmwɨ na abhaana bhaazɨ bhabhɨrɨbhu, akahigama mʉbhʉtangɨ bhwazɨ, akamʉsabha amokorere kegero kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yɨɨsu akamubhuurya, “Oreenda nekokorerekɨ?” Wʉʉsi akamʉgarukirya, “Nɨrasabha ubhiisiririryɨ abhaana bhaanɨ bhanʉ bhabhɨrɨ, bhiikarɨ hamwɨmwɨ na naawɨ mʉbhʉtɨmi bhwazʉ, wʉmwɨ ʉrʉbhaara rwu ubhuryʉ nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yɨɨsu akamʉgarukirya, “Mʉtɨɨzɨ kɨnʉ mʉkʉsabha. Nangʉ, mʉratʉra kunywa ekekombe chɨ ɨnyaakʉ kɨnʉ nikunywa?” Bhakamʉgarukirya, “Tʉratʉra.” ");
INSERT INTO ikz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yɨɨsu akabhabhʉʉrɨra, “Maheene mʉrakinywɨra ekekombe chɨ ɨnyaakʉ yɨnʉ inyɨ nɨkʉnyaaka, nawe kwikara ʉrʉbhaara rwanɨ rwu ubhuryʉ hamwɨ rwʉ ʉbhʉmʉsi gɨtarɨ emeremo janɨ kubhiisiririrya. Umweya guyo nɨ‑kʉbhanʉ Bhaabha amarirɨ kokonzera.” ");
INSERT INTO ikz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hanʉ abhɨɨga abhandɨ ikumi bhiigwirɨ gayo, bhakiigatanɨra abhakɨndichabhʉ bhabhɨrɨ bhayo. ");
INSERT INTO ikz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Neho Yɨɨsu akabhabhɨrɨkɨra bhʉʉsi hamwɨmwɨ, akabhabhʉʉrɨra, “Mwɨzɨ kʉbha abhakangati bhi ibhyarʉ bharakangata abhaatʉ bhaabhʉ kwa amanaga, na abhakʉrʉ bhaabhʉ bharabhahocha emeremo. ");
INSERT INTO ikz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nawe ɨtaaza ɨkabhabhu kwa niimwɨ. Ʉmʉʉtʉ wʉnʉ akwenda kʉbha ʉmʉkʉrʉ waanyu, areenderwa kʉbha omohocha waanyu. ");
INSERT INTO ikz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Naatu, ʉmʉʉtʉ wʉnʉ akwenda kʉbha we embere gatɨ waanyu, areenderwa kʉbha mbʉʉsa waanyu. ");
INSERT INTO ikz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chɨmburya, Umwana wʉ Ʉmʉʉtʉ atiizirɨ kʉhʉkɨribhwa, nawe akaaza kohokerya abhaatʉ na kuhurucha ʉbhʉhʉru bhwazɨ bhʉbhɨ ubhutuurya kʉbhaatʉ abhaaru.” ");
INSERT INTO ikz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bharuurɨ mʉrʉbhɨri rwa Yɨriko, riribhita ikʉrʉ rya abhaatʉ rɨkamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Rusizʉ wɨ ɨnzɨra yɨnʉ Yɨɨsu aarɨ akʉhɨta, bhaareho abhahʉku bhabhɨrɨ. Hanʉ bhiigwirɨ kʉbha Yɨɨsu arahɨta hayo, bhakabhɨrɨkɨra kwiraka ikʉrʉ, “Ʉmʉkʉrʉ, Umwana wʉ ʉmʉtɨmi Daudi, otororere ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Riribhita rya abhaatʉ rɨkabhahaarɨra kʉbha bhakirɨ, nawe ebho bhakakaja kʉbhɨrɨkɨra kwiraka ikʉrʉ, “Ʉmʉkʉrʉ, Umwana wʉ ʉmʉtɨmi Daudi, otororere ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yɨɨsu akiimɨɨrɨra, akabhabhɨrɨkɨra, akabhabhuurya, “Moreenda nɨbhakorerekɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Abhahʉku bhayo bhakamʉgarukirya, “Ʉmʉkʉrʉ, toreenda torore!” ");
INSERT INTO ikz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Neho Yɨɨsu akabharorera ɨbhɨgʉngi, akabhakunʼyaku amɨɨsʉ gaabhʉ. Hayohayo, bhakarora, nabhʉ bhakamutuna. ");
INSERT INTO ikz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhiisɨmɨɨrɨ Yɨrusarɨɨmu, bhakahika mʉrʉbhɨri rwa Bhɨtifagɨ kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. Neho Yɨɨsu akatʉma abhɨɨga bhaazɨ bhabhɨrɨ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Mujɨ mʉrʉbhɨri rʉnʉ rore embere waanyu. Hanʉ mukusikɨramu, mʉrarora ɨtɨkɨrɨ nu umwana wayʉ zɨbhʉhirwɨ. Mʉzɨtazʉrɨ, mondeetere hanʉ. ");
INSERT INTO ikz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nʉ ʉmʉʉtʉ wʉwʉʉsi araabhabhuuryɨ, mʉmʉgarukiryɨ, ‘Ʉmʉkʉrʉ arazeenda,’ hayohayo wʉʉsi arabhiisiririrya muuzɨ nazʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gayo gaakʉriibhwɨ, korereke gabhɨ amangʼana ganʉ Mungu aagambirɨ kʉhɨtɨra ʉmʉrʉʉtɨrɨri waazɨ, ");
INSERT INTO ikz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ʉbhʉʉrɨrɨ abhaatʉ bha Sayuuni, ‘Rora, ʉmʉtɨmi waanyu araaza kwa niimwɨ, nɨ‑mʉnyʉʉhu, araaza iikɨɨrɨ kʉtɨkɨrɨ, nɨ ɨkɨmʉʉri chayʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mmbe, abhɨɨga bhaazɨ bhakaja, bhakakora chɨmbu Yɨɨsu aabhatumirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hanʉ bhaagarukirɨ kwa Yɨɨsu nɨ ɨtɨkɨrɨ yirya nu umwana wayʉ, bhakaara zengebho igʉrʉ waazɨ, na Yɨɨsu akiikara igʉrʉ wayʉ. ");
INSERT INTO ikz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Abhaatʉ bhaaru kwiribhita riyo, bhakaara zengebho zaabhʉ kʉnzɨra. Abhandɨ bhakatɨna ibhisha bhyɨ ɨmɨtɨ na kwara kʉnzɨra igʉrʉ wʉ ʉkʉsʉʉka Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abhaatʉ bhanʉ bhaakangatirɨ embere na bhanʉ bhaarɨ inyuma, bhakatiirya riraka bharabhuga, “Akumibhwɨ Umwana wʉ ʉmʉtɨmi Daudi! Anʉ ʉrʉbhangʉ wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ! Akumibhwɨ Mungu wa mwisaarʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hanʉ Yɨɨsu aasikiirɨ mʉrʉbhɨri rwa Yɨrusarɨɨmu, ʉrʉbhɨri rwʉsi rukiitiimaata. Abhaatʉ bhakiibhuurya, “Nɨ‑wɨɨwɨ wuyo?” ");
INSERT INTO ikz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Abhaatʉ kwiribhita riyo bhakagarukirya, “Wʉnʉ nɨ‑Yɨɨsu! Nɨ‑mʉrʉʉtɨrɨri wa Nazarɨɨti mucharʉ cha Gariraaya!” ");
INSERT INTO ikz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yɨɨsu akasikɨra mwihekaaru. Akaheebhera igʉtʉ abhaatʉ bhanʉ bhaarɨ bhakugurya na kʉgʉra ebhegero. Akabharingʉra zemeeza za bhanʉ bhaarɨ bhakʉkɨranʼya zimpirya ni ibhitumbɨ bhya bhanʉ bhaarɨ bhakugurya ibhiguuti. ");
INSERT INTO ikz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akabhabhʉʉrɨra, “Yandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Inyumba yaanɨ ɨrabha inyumba ya amasabhi.’ Nawe imwɨ mʉyɨkʉrirɨ kʉbha ribhigi rya abhasaakuri.” ");
INSERT INTO ikz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mmbe, hanʉ Yɨɨsu aarɨ akɨɨrɨ mwihekaaru, abhahʉku na amagata bhakaja kwawɨ, wʉʉsi akabhahorya. ");
INSERT INTO ikz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nawe hanʉ abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa bhaarʉʉzɨ ɨbhɨsɨgʉ bhɨnʉ Yɨɨsu aarɨ akokora, na kwigwa ganʉ abhaana bhaarɨ bhakʉgamba kwiraka mwihekaaru, “Akumibhwɨ Umwana wʉ ʉmʉtɨmi Daudi,” bhakiigatana bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakamubhuurya, “Nangʉ, uriigwa chɨmbu abhaana bhayo bhakubhuga?” Yɨɨsu akabhagarukirya, “Hee niriigwa. Awɨɨ mʉkɨɨrɨ kosoma amangʼana ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Wikʉrɨɨrɨ ubhukumya, kʉhɨtɨra iminywa ja abhaana abhasuuhu na abhabhataarɨ’?” ");
INSERT INTO ikz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yɨɨsu akabhatiga hayo, akarwa Yɨrusarɨɨmu, akaja kuhindɨra mʉrʉbhɨri rwa Bhɨtaniya. ");
INSERT INTO ikz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ritabhʉʉri ryaho, hanʉ aarɨ aragarʉka Yɨrusarɨɨmu, ɨnzara ɨkamurya. ");
INSERT INTO ikz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akarora umutiini rusizʉ wɨ ɨnzɨra. Akagwisukɨra, akabhona gʉtaana imisumʉ, nawe gʉna amatʉʉtʉ ageene. Akagʉbhʉʉrɨra, “Awɨ ʉtakwibhʉra imisumʉ naatu kemerano!” Hayohayo, umutiini gʉkʉʉma. ");
INSERT INTO ikz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hanʉ abhɨɨga bha Yɨɨsu bhaarʉʉzɨbhu, bhakarʉgʉʉra bhʉkʉngʼu. Bhakamubhuurya, “Ɨbhɨɨrɨbhwɨ rogendo rʉmwɨ ʉmʉtɨ gʉnʉ gwumirɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yɨɨsu akabhagarukirya, “Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ munu ubhwisirirya bhʉnʉ bhʉtaana makɨbhwɨ, mʉratʉra kʉgakora. Ɨtarɨ ryu umutiini guyo iryene, nawe nʉʉrʉ mʉraabhʉʉrɨrɨ ɨkɨgʉrʉ kɨnʉ, ‘Ihɨka wiitaashɨ mʉnyanza,’ rɨrabha. ");
INSERT INTO ikz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Arɨɨbhɨ munu ubhwisirirya, chʉchʉsi kɨnʉ mʉkʉsabha kwa Mungu, mʉrabhona.” ");
INSERT INTO ikz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yɨɨsu akasikɨra naatu mwihekaaru. Hanʉ aarɨ ariija, abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi bhakamujaku kumubhuurya, “Ganʉ okokora, ʉrakora kwa bhʉnajakɨ? Nɨ‑wɨɨwɨ wʉnʉ akʉhɨɨrɨ ʉbhʉnaja bhuyo?” ");
INSERT INTO ikz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yɨɨsu akabhagarukirya, “Na niinyɨ nɨrabhabhuurya ringʼana rɨmwɨ. Mʉraangaruchiryɨ riyo, na niinyɨ nɨrabhabhʉʉrɨra, nɨrakora gayo kʉbhʉnaja bhwa wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Awɨɨ, ʉbhʉnaja bhwa Yoohana bhwʉ ʉkʉbhatiiza, bhʉkarwa hayi? Bhʉkarwa kwa Mungu kisha kʉbhaatʉ?” Bhakiibhuurya abheene kobheene bharabhuga, “Tʉraabhugɨ, ‘Bhʉkarwa mwisaarʉ,’ aratubhuurya, ‘Ndora mʉtamwisiriiryɨ?’ ");
INSERT INTO ikz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na tʉraabhugɨ, ‘Bhʉkarwa kʉbhaatʉ,’ tʉrʉʉbhaha riribhita rya abhaatʉ bhanʉ, kʉ kʉbha bhʉʉsi bhariisirirya kʉbha Yoohana aarɨ ʉmʉrʉʉtɨrɨri.” ");
INSERT INTO ikz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Neho bhakamʉgarukirya, “Tʉtɨɨzɨ.” Wʉʉsi akabhabhʉʉrɨra, “Na niinyɨ nɨtakʉbhabhʉʉrɨra nɨrakora amangʼana ganʉ kwa bhʉnajakɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yɨɨsu akangʼeha kʉgamba, “Nangʉ, mʉrarorabhwɨ igʉrʉ we ekerenjo kɨnʉ? Aareho ʉmʉʉtʉ wʉmwɨ wʉnʉ aarɨ na abhaana bhabhɨrɨ. Akaja kumwana we embere, akamʉbhʉʉrɨra, ‘Mwana waanɨ, reero nuujɨ okore emeremo mʉmʉgʉndʉ gwɨ ɨmɨzabhiibhu.’ ");
INSERT INTO ikz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Umwana wuyo akamʉgarukirya, ‘Nɨtakuja!’ Nawe hanʉ aachurirɨ amiisɨɨgi gaazɨ, akaja. ");
INSERT INTO ikz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Neho wiisɨ akaja kumwana wa kabhɨrɨ na kʉmʉbhʉʉrɨra chɨmbu aabhuuriirɨ ʉwʉndɨ wurya. Wʉʉsi akamʉgarukirya, ‘Nɨraja bhaabha!’ Nawe atagiirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Nangʉ, kwa bhabhɨrɨ bhayo, nɨ‑wɨɨwɨ wʉnʉ aakʉrirɨ chɨmbu wiisɨ ɨɨndirɨ?” Bhakamʉgarukirya, “Ne‑we embere wurya.” Neho Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra amaheene, abharihya bha rigʉʉti na abhasimbɨ rikʉʉrɨɨra bharabhakangatɨra kusikɨra mʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoohana akaaza kwa niimwɨ korereke abheerekeereye ɨnzɨra ye eheene, na niimwɨ mutiisiriiryɨ. Nawe abharihya bha rigʉʉti na abhasimbɨ rikʉʉrɨɨra nebho bhaamwisiriiryɨ. Nʉʉrʉ imwɨ hanʉ mwarʉʉzɨ gʉʉsi gayo, mʉkaanga kuchʉra amiisɨɨgi gaanyu na kumwisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mwitegeerere ekerenjo ɨkɨndɨ. Aareho ʉmʉʉtʉ wʉmwɨ wʉnʉ aarɨ nʉ ʉmʉgʉndʉ. Mʉmʉgʉndʉ muyo, akahamba ɨmɨzabhiibhu, akagwinaarya ʉrʉbhagʉ akatuka rirʉʉma gatɨgatɨ ryʉ ʉkʉkamɨra amanzi ga zɨzabhiibhu, naatu akʉʉmbaka ɨkɨkʉngʉ ɨkɨrɨɨhu cha abhariibhi mʉmʉgʉndʉ. Akakʉʉdishirya abharimi. Ewe akaja icharʉ ɨkɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Hanʉ ribhaga ryo okogesa ryahikirɨ, umwene ʉmʉgʉndʉ akatʉma bhambʉʉsa bhaazɨ kwa abharimi, korereke bhamogegere imisumʉ jazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nawe hanʉ bhambʉʉsa bhaazɨ bhaahikirɨ, abharimi bhayo bhakabhagwata, ʉwʉmwɨ bhakamotema, ʉwʉndɨ bhakamwita nʉ ʉwʉndɨ bhakamotema na amabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Umwene ʉmʉgʉndʉ akatʉma naatu bhambʉʉsa abhandɨ, bhaaru kʉkɨra bhanʉ aatumirɨ embere. Abharimi bhayo bhakabhakorera muryamurya, chɨmbu bhaabhakʉrɨɨrɨ bhe embere. ");
INSERT INTO ikz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ɨtɨnɨrʉ, akatʉma umwana waazɨ, akiiseega, ‘Bharasʉʉka umwana waanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nawe hanʉ abharimi bharya bhaarʉʉzɨ umwana wuyo, bhakiibhʉʉrɨra, ‘Wʉnʉ newe ʉmʉgabhi wʉ ʉmʉgʉndʉ gʉnʉ. Tumwitɨ korereke togogege.’ ");
INSERT INTO ikz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mmbe, bhakamugwata, bhakamuhira igʉtʉ wʉ ʉmʉgʉndʉ, bhakamwita.” ");
INSERT INTO ikz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yɨɨsu akabhabhuurya, “Nangʉ, hanʉ wʉ ʉmʉgʉndʉ araagarʉkɨ kurwa orogendo rwazɨ, arakorabhwɨ abharimi bharya?” ");
INSERT INTO ikz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhakamʉgarukirya, “Arabharicha kɨbhɨ abhabhɨ bhayo, nʉ ʉmʉgʉndʉ arabhaha abharimi abhandɨ, bhanʉ bhakomoha imisumʉ jazɨ kwa ribhaga.” ");
INSERT INTO ikz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Neho Yɨɨsu akabhabhʉʉrɨra, “Mʉkɨɨrɨ kosoma ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu? ‘Riibhwɨ rɨnʉ abhʉʉmbaki bhaangirɨ, neryo rɨbhɨɨrɨ riibhwɨ rikʉrʉ rya rusizʉ. Ʉmʉkʉrʉ newe akʉrirɨ riyo, naryʉ ni‑ringʼana ryʉ ʉkʉrʉgʉʉra mʉmɨɨsʉ gɨɨtʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Akoongera, “Nɨrabhabhʉʉrɨra, Mungu araruusha ʉbhʉtɨmi bhwazɨ kwa niimwɨ na kʉbhaha abhaatʉ bhi ibhyarʉ ɨbhɨndɨ bhanʉ bhakuhurucha imisumʉ igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mmbe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akʉbha agwiriirɨ riibhwɨ riyo, arabhunɨkabhunɨka. Na wʉwʉʉsi wʉnʉ riibhwɨ riyo rɨraamugwɨrɨ, rɨramusha bhoseeseka.” ");
INSERT INTO ikz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hanʉ abhakʉrʉ bha abhakuhaani na Abhafarisaayo bhiigwirɨ ebherenjo bhyazɨ, bhakoobhoora kʉbha nebho bhakʉgambirwa. ");
INSERT INTO ikz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bhakamohya ɨnzɨra yu ukumugwata, nawe bhakʉʉbhaha riribhita rya abhaatʉ, kʉ kʉbha ebho bhakamenya Yɨɨsu nɨ‑mʉrʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yɨɨsu akangʼeha kwija Abhafarisaayo na abhakʉrʉ bha abhakuhaani kokerenjo ɨkɨndɨ akabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nʉ ʉmʉtɨmi wʉnʉ akʉrirɨ ubhuryakari bhu umwana waazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akatʉma bhambʉʉsa bhaazɨ bhajɨ kʉbhɨrɨkɨra bhanʉ aarɨ araarikirɨ kubhuryakari, nawe bhʉʉsi bhakaanga kuuza. ");
INSERT INTO ikz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Neho akatʉma bhambʉʉsa abhandɨ, akabhabhʉʉrɨra, ‘Mujɨ mʉbhʉʉrɨrɨ bhanʉ naraarikirɨ, “Nɨkʉrirɨ ubhuryakari bhwanɨ. Nisinzirɨ zengʼombe zaanɨ zinuru hamwɨmwɨ ni imitugʉ ɨgɨndɨ iminuru. Na bhyʉsi bhɨbhɨɨrɨ, muuzɨ kubhuryakari!”’ ");
INSERT INTO ikz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nawe abhaatʉ bhanʉ bharaarikirwɨ, bhakaregana. Bhakaja komeremo jabhʉ, abhandɨ bhakaja mʉmʉgʉndʉ, na abhandɨ bhakaja kusuruja. ");
INSERT INTO ikz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abhandɨ bhakagwata bhambʉʉsa bhʉ ʉmʉtɨmi, bhakabhatema na kubhiita. ");
INSERT INTO ikz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mmbe, hanʉ ʉmʉtɨmi iigwirɨ ganʉ gakʉriibhwɨ kwa abhahocha bhaazɨ, akiigatana bhʉkʉngʼu. Akatʉma abhasirikarɨ bhaazɨ bharichɨ abhiiti bharya na kwocha ʉrʉbhɨri rwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Akʉmara ʉmʉtɨmi wuyo akabhʉʉrɨra bhambʉʉsa bhaazɨ, ‘Ebhegero bhyʉsi bhyu ubhuryakari bhɨmarirɨ kokorwa, nawe abharaarikwa bhataarɨ bhareenderwa kuuza. ");
INSERT INTO ikz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mmbe nangʉ, mujɨ kʉnzɨra ya amahʉkana, mʉbhʉʉrɨrɨ bhʉbhʉʉsi bhanʉ mukurumana nabhʉ, bhaazɨ kubhuryakari.’ ");
INSERT INTO ikz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bhambʉʉsa bhayo bhakaja kʉnzɨra, bhakagarʉka na abhaatʉ bhanʉ bhaabharʉʉzɨ, abhabhɨ na abhazʉmu. Bhakasikɨra mwibhuru ryu ubhuryakari kuhika rikiizʉra. ");
INSERT INTO ikz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nawe hanʉ ʉmʉtɨmi aasikiirɨ mwibhuru ryi isigukuru korereke arore abhagini, akarora ʉmʉʉtʉ wʉmwɨ wʉnʉ atiibhʉhirɨ engebho yu ubhuryakari. ");
INSERT INTO ikz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akamubhuurya, ‘Mʉsaani waanɨ, ʉkasikɨrabhwɨ mʉnʉ, ɨnʉ utiibhʉhirɨ engebho yu ubhuryakari?’ Nawe ʉmʉʉtʉ wuyo akakira. ");
INSERT INTO ikz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mmbe, ʉmʉtɨmi akabhʉʉrɨra abhahocha bhaazɨ, ‘Momobhohe amagʉrʉ na amabhoko, morekere igʉtʉ mukiirimya. Iyo bhararɨra na kokepeha.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yɨɨsu akamariirya kwa kʉgamba, “Abhaatʉ bhanʉ bhakubhirikirwa kusikɨra mʉbhʉtɨmi bhwa mwisaarʉ, nɨ‑bhaaru, nawe bhanʉ bharʉbhwɨrwɨ kusikɨra, nɨ‑bhasuuhu.” ");
INSERT INTO ikz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mmbe, Abhafarisaayo bhakiibhiringa kʉgambana chɨmbu bharaahaatyɨ Yɨɨsu kwa amangʼana gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Akʉmara bhakatʉma abhɨɨga bhaabhʉ hamwɨmwɨ na abhasakirya bha riribhita ryʉ ʉmʉtɨmi Heroode Antipaasi kwa Yɨɨsu. Hanʉ bhaahikirɨ bhakabhuurya Yɨɨsu, “Umwija, tʉmɨnyirɨ kʉbha awɨ nɨ‑mʉʉtʉ we eheene na uriija amaheene igʉrʉ wa amangʼana ga Mungu. Ʉtakwʉbhaha wʉwʉʉsi, nʉʉrʉ abhɨ nu umweya gwi igʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nangʉ ʉtʉbhʉʉrɨrɨ awɨ ʉrarorabhwɨ. Kʉrɨngʼaana ni imigirʉ ja Musa, toreenderwa kʉrɨha rigʉʉti kwa Kaisaari, kisha zɨyi?” ");
INSERT INTO ikz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nawe Yɨɨsu akamenya ʉbhʉbhɨ bhwabhʉ, akabhagarukirya, “Abhabhɨɨhi imwɨ, kwakɨ mʉrangema? ");
INSERT INTO ikz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Monyeereche rizenzere rɨnʉ mʉkʉrɨhɨra rigʉʉti.” Bhʉʉsi bhakamoha rizenzere rɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yɨɨsu akabhabhuurya, “Ipicha yɨnʉ ni riina rɨnʉ, ni‑bhya wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakamʉgarukirya, “Bhya Kaisaari.” Yɨɨsu akabhabhʉʉrɨra, “Bhya Kaisaari mohe Kaisaari, na bhya Mungu mohe Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hanʉ bhiigwirɨbhu, bhakarʉgʉʉra bhʉkʉngʼu. Bhakamutiga, bhakabhʉʉka bhakaja. ");
INSERT INTO ikz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Urusikʉ ruyoruyo, Abhasadukaayo obhorebhe bhakaaza kwa Yɨɨsu. Abhasadukaayo bhahiija kʉbha Mungu atahaaryʉra abhaatʉ kurwa muruku. Neho bhakabhuurya Yɨɨsu, ");
INSERT INTO ikz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Umwija, Musa akabhuga mumigirʉ jazɨ, arɨɨbhɨ ʉmʉʉtʉ akuurɨ akɨɨrɨ kwibhʉra umwana, ereenderwa umuhiiri waazɨ agabhɨ ʉmʉkari wu umuku wuyo, korereke amwibhʉrɨrɨ abhaana. ");
INSERT INTO ikz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mmbe, bhaareho abhahiiri muhungatɨ. We embere akakwɨra ʉmʉkari, akakwa akɨɨrɨ kwibhʉra. Umuhiiri waazɨ wa kabhɨrɨ akamʉgabha umukwirwa wuyo. ");
INSERT INTO ikz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Umunyi waazɨ wuyo na wa katatʉ bhʉʉsi bhakakwa bhakɨɨrɨ kwibhʉra umwana nu umukwirwa wuyo. Ɨkabha ɨbhuɨbhu kʉbhahiiri muhungatɨ bhayo bhʉʉsi, bhakakwa bhakɨɨrɨ kwibhʉra. ");
INSERT INTO ikz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ɨtɨnɨrʉ, ʉmʉkari wuyo wʉʉsi akakwa. ");
INSERT INTO ikz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mmbe tʉbhʉʉrɨrɨ, urusikʉ rʉnʉ rʉkʉgambwa kʉbha abhaatʉ bhʉʉsi bhararyʉka, umukwirwa wuyo arabha mʉka wɨɨwɨ? Muhungatɨ bhayo bhʉʉsi bhaarɨ bhamukwɨrirɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yɨɨsu akabhagarukirya, “Imwɨ mʉrarimɨra bhʉkʉngʼu, kʉ kʉbha mʉtɨɨzɨ Amaandɨkʉ Amarɨndu naabha ʉbhʉnaja bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Urusikʉ rʉnʉ abhaatʉ bhakuryʉka, bharabha ncha bhamaraika bha mwisaarʉ, bhatakukwɨra naabha kukwɨrwa. ");
INSERT INTO ikz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nawe igʉrʉ wu ukuryʉka kwa abhaku, mʉkɨɨrɨ kosoma mʉMaandɨkʉ Amarɨndu chɨmbu Mungu aabhabhuuriirɨ? Akabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Inyɨ ni‑Mungu wa Abhurahaamu, Iisaka na Yaakobho.’ ” Yɨɨsu akangʼeha kʉgamba, “Mmbe, Mungu nɨ‑wa abhahʉru, atarɨ Mungu wa abhaku.” ");
INSERT INTO ikz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hanʉ riribhita rya abhaatʉ bhiigwirɨ gayo, bhakarʉgʉʉra bhʉkʉngʼu kwa amiija gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hanʉ Abhafarisaayo bhiigwirɨ kʉbha Yɨɨsu aarɨ ahizirɨ Abhasadukaayo kʉbhʉgambi bhwazɨ, bhakiibhiringa hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Akʉmara, bhakaja kwa Yɨɨsu, na wʉmwɨ waabhʉ wʉnʉ aarɨ umwija wi imigirʉ ja Musa, akagema komotega. Akamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Umwija, ni‑iswajakɨ rikʉrʉ kʉkɨra amaswaja agandɨ gʉʉsi ga Mungu?” ");
INSERT INTO ikz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yɨɨsu akamʉgarukirya, “‘Ʉmʉsɨɨgɨ Ʉmʉkʉrʉ Mungu waazʉ kumwʉyʉ gwazʉ gwʉsi, kokoro yaazʉ yʉʉsi na kʉmangʼɨɨni gaazʉ gʉʉsi.’ ");
INSERT INTO ikz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Riswaja rɨnʉ neryo rikʉrʉ kʉkɨra amaswaja agandɨ gʉʉsi, naatu nego ganu ubhwɨndi kʉkɨra gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ubhuswaja bhwa kabhɨrɨ bhutuubhɨɨnɨ na bhuyo, nabhwɨ bhʉrabhuga, ‘Ʉmʉsɨɨgɨ nyarʉbhɨri waazʉ chɨmbu wisɨɨgirɨ aumwene.’ ");
INSERT INTO ikz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Imigirʉ jʉsi ja Musa na amiija ga abharʉʉtɨrɨri bhiriisega amaswaja abhɨrɨ gayo.” ");
INSERT INTO ikz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hanʉ Abhafarisaayo bhayo bhaarɨ bhakɨɨrɨ bhiibhiringirɨ hamwɨmwɨ hayo, Yɨɨsu akabhabhuurya, ");
INSERT INTO ikz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Muriiseegabhwɨ igʉrʉ wa Kiriisitʉ, ni‑mwana wa wɨɨwɨ?” Bhakamʉgarukirya, “Ni‑mwana wʉ ʉmʉtɨmi Daudi.” ");
INSERT INTO ikz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yɨɨsu akabhabhuurya, “Arɨɨbhɨ gayo nɨ‑ga amaheene, kwakɨ Daudi, hanʉ akʉkangatwa ne Ekoro ya Mungu, aramʉbhɨrɨkɨra Kiriisitʉ, ‘Ʉmʉkʉrʉ’? Akabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ʉmʉkʉrʉ Mungu akabhʉʉrɨra Ʉmʉkʉrʉ waanɨ, “Ikara ʉrʉbhaara rwanɨ rwu ubhuryʉ, hanʉ nɨkʉtʉʉra abhabhisa bhaazʉ iyaasɨ wa amagʉrʉ gaazʉ.” ’ ");
INSERT INTO ikz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Arɨɨbhɨ Daudi aramʉbhɨrɨkɨra Kiriisitʉ, ‘Ʉmʉkʉrʉ,’ nangʉ Kiriisitʉ aratʉrabhwɨ kʉbha umwana waazɨ naatu?” ");
INSERT INTO ikz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mmbe, atareeho ʉmʉʉtʉ wʉnʉ aaturirɨ kʉmʉgarukirya ryʉryʉsi. Naatu kʉtangɨra hayo, atareeho ʉmʉʉtʉ wʉnʉ aagɨmirɨ kubhuurya Yɨɨsu amabhuurya agandɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mmbe, Yɨɨsu akabhʉʉrɨra riribhita rya abhaatʉ na abhɨɨga bhaazɨ kʉbha, ");
INSERT INTO ikz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abhiija bhi imigirʉ ja Musa na Abhafarisaayo bhanʉ ʉbhʉnaja bhu ukwija abhaatʉ imigirʉ ja Musa. ");
INSERT INTO ikz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kʉgayo, mugwatɨ na mokore bhwaheene gʉʉsi ganʉ bhakwija. Nawe mʉtabha mʉratuna amahocha gaabhʉ, kʉ kʉbha ebho bhatakokora ganʉ bhakwija. ");
INSERT INTO ikz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ebho bhahaabhoha imirigʉ imiritʉ na kʉbhagegya abhaatʉ kʉmabhega, nawe abheene bhatakwenda kogorora nʉʉrʉ ichara korereke bhasakiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na amahocha gaabhʉ gʉʉsi bhahaakora korereke bhiiyeerekenʼye kʉbhaatʉ. Bhahoongera ɨbhɨtɨnɨka bhya amaseero ga amaandɨkʉ gi imigirʉ kwibhoha kʉmabhoko na kubhushʉ bhwabhʉ, na kwongera ripindʉ rya zengebho zaabhʉ za amasabhi zɨbhɨ ndɨɨhu kʉkɨra za abhandɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Zisikʉ zɨ ɨnyangi, bhahaasɨɨga kwikara kubhitumbɨ bhye embere bhya abhagini. Na mʉmarwazɨrʉ gaabhʉ, bhahaasɨɨga kwikara hanʉ abhakangati bhiikɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Naatu, bhahaasɨɨga bhʉkʉngʼu bhakɨɨribhwɨ momoteera kwa bhusuuku, na kubhirikirwa na abhaatʉ, ‘Umwija.’ ");
INSERT INTO ikz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nawe imwɨ, mutiisirirya kubhirikirwa ‘Umwija,’ kʉ kʉbha Umwija waanyu nɨ‑wʉmwɨbhu, na niimwɨ bhʉʉsi, nɨ‑bhamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naatu, mʉtabhɨrɨkɨra ʉmʉʉtʉ wʉwʉʉsi mʉʉsɨ yɨnʉ ‘Bhaabha,’ kʉ kʉbha Wuusʉ nɨ‑wʉmwɨbhu, wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naatu, mutiisirirya kubhirikirwa ‘Ʉmʉkangati,’ kʉ kʉbha Ʉmʉkangati waanyu nɨ‑wʉmwɨbhu, ewe newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwenda kʉbha ʉmʉkʉrʉ gatɨ waanyu, areenderwa kʉbha omohocha waanyu. ");
INSERT INTO ikz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na wʉwʉʉsi wʉnʉ akwigungya umwene, Mungu aramwicha. Nawe wʉwʉʉsi wʉnʉ akwiyicha, Mungu aramʉgʉnga. ");
INSERT INTO ikz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Mʉrabharecha abhaatʉ kusikɨra mʉbhʉtɨmi bhwa mwisaarʉ kwa amiija gaanyu. Imwɨ abheene mʉtakusikɨramu, naatu mʉtakubhiisiririrya bhanʉ bhakwenda bhasikɨrɨ.  ");
INSERT INTO ikz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Mʉrasabha amasabhi marɨɨhu bhʉkʉngʼu korereke mwiyeerekenʼye kwa abhaatʉ, nawe ɨnʉ mʉraruusha abhakwirwa ebhegero bhyabhʉ. Mmbe, momenye kʉbha urusikʉ rwɨ ɨtɨnɨrʉ, maheene mʉrahaabhwa ɨtɨnɨrʉ kʉrʉ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Muriiruguura mucharʉ kigima nɨ ɨnyanza, korereke mokorokombe ʉmʉʉtʉ wʉnʉ atarɨ Ʉmʉyaahudi kʉbha ʉmʉhɨmba wɨ ɨnyangi yaanyu. Nawe hanʉ mʉkʉmara komobhona, mʉramokora kʉbha ʉmʉʉtʉ wʉnʉ akwenderwa omorero gwa nyaari manga kabhɨrɨ kʉkɨra imwɨ! ");
INSERT INTO ikz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Horeera imwɨ, abhakangati abhahʉku! Muriija abhaatʉ, ‘Arɨɨbhɨ ʉmʉʉtʉ ariirahɨra igʉrʉ wa rihekaaru rya Mungu, ukwirahɨra kwazɨ kʉtarɨ kegero. Nawe arɨɨbhɨ ariirahɨra igʉrʉ wɨ ɨzahaabhu yɨnʉ ihurukiibhwɨ mwihekaaru, ibhʉhirɨ nu ubhwirahiri bhwazɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bhageege imwɨ, na bhahʉku! Kɨgʉrʉkɨ kinu ubhwera ʉbhʉkʉrʉ kʉkɨra ɨkɨndɨ, nɨ‑zahaabhu yɨnʉ ihurukiibhwɨ mwihekaaru, kisha ni‑rihekaaru rɨnʉ rekokora ɨzahaabhu kʉbha ndɨndu? ");
INSERT INTO ikz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Naatu muriija, ‘Arɨɨbhɨ ʉmʉʉtʉ ariirahɨrɨ igʉrʉ wa ahagero hu ukuhurukirya ikimweso mwihekaaru, ukwirahɨra kwazɨ kʉtarɨ kegero. Nawe ariirahɨrɨ igʉrʉ wi ibhimweso bhɨnʉ bhɨrɨ ahagero hu ukuhurukirya ikimweso, abhʉhirwɨ nu ubhwirahiri bhwazɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Abhahʉku imwɨ! Kɨgʉrʉkɨ kinu ubhwera ʉbhʉkʉrʉ kʉkɨra ɨkɨndɨ, ni ikimweso kisha ahagero hu ukuhurukirya ikimweso hanʉ hakokora ikimweso kʉbha kɨrɨndu? ");
INSERT INTO ikz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mmbe, wʉnʉ akwirahɨra igʉrʉ wa ahagero hu ukuhurukirya ikimweso, ariirahɨra ni‑gʉrʉ wi ibhimweso bhɨnʉ bhɨrɨ ahagero hu ukuhurukirya ikimweso. ");
INSERT INTO ikz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na wʉnʉ akwirahɨra igʉrʉ wa rihekaaru, ariirahɨra igʉrʉ wa rihekaaru na wʉnʉ akwikaramu. ");
INSERT INTO ikz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naatu, arɨɨbhɨ ʉmʉʉtʉ ariirahɨra igʉrʉ wa risaarʉ, ariirahɨra igʉrʉ wi ikitumbɨ chɨ ɨkɨtɨmi cha Mungu nu umwene wʉnʉ akwikaraku. ");
INSERT INTO ikz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Mʉragwata imigirʉ ju ukuhurucha yɨmwɨ yi ikumi nʉʉrʉ kwe ebhegero bhyu ubhwera ubhusuuhu bhʉkʉngʼu, ncha zendetere za amareke, ibhizaari na jira. Nawe, mʉratiga amangʼana amakʉrʉ gu ubhwera kumigirʉ ja Musa. Mʉratiga eheene, ɨbhɨgʉngi, na kʉbha umwisirirya kwa Mungu na kʉbhaatʉ abhandɨ. Nawe moreenderwa kʉgakora gʉʉsi amakʉrʉ na amasuuhu hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imwɨ nɨ‑bhakangati abhahʉku, kʉ kʉbha mʉrasuuza ɨsʉna, nawe mʉramɨra ɨngamiya! ");
INSERT INTO ikz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Muriikorya kʉbha, nɨ‑bhaatʉ bhazʉmu mʉbhʉtangɨ bhwa Mungu. Morooja igʉtʉ we ekekombe nɨ ɨsahaani, nawe mʉratiga kwoja mʉʉsi, ɨnʉ hiizwirɨ ebhegero bhɨnʉ mubhwɨnɨ kwa kwibha na kʉtama kʉbha ne ekerengo. ");
INSERT INTO ikz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imwɨ Abhafarisaayo abhahʉku! Mutigɨ hinga ʉbhʉbhɨ bhʉnʉ bhʉrɨ mʉʉsi waanyu, chɨmbu ukwoja hinga mʉʉsi we ekekombe. Amahocha gaanyu gʉʉsi garabha mazʉmu, chɨmbu ekekombe kɨrabha chɨrʉ igʉtʉ kɨrɨɨbhɨ kɨzʉmiibhwɨ mʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Mwangɨ zimbihɨra zɨnʉ zɨhakirwɨ iswakara. Kwi igʉtʉ zɨrarorekana nzʉmu, nawe mʉʉsi ziizwirɨ amaguha ga abhaku nu ubhubhuruuru bhwa zeteemwa zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɨbhuɨbhu na niimwɨ, kwi igʉtʉ mʉrarorekana kʉbhaatʉ kʉbha bhe eheene mʉbhʉtangɨ bhwa Mungu, nawe mumyʉyʉ janyu mwizwirɨ engʼeera na amabhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Horeera imwɨ, abhiija bhi imigirʉ ja Musa na Abhafarisaayo, abhabhɨɨhi! Mʉrʉʉmbaka zimbihɨra za abharʉʉtɨrɨri na kotonera bhwaheene zimbihɨra za abhaatʉ abhandɨ bhanʉ bhaarɨ bhe eheene mʉbhʉtangɨ bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Neho mʉrabhuga, ‘Itwɨ twangabhɨɨrɨho ribhaga rɨnʉ bhasʉʉkʉrʉ bhɨɨtʉ bhaarɨ bhahʉru, tʉtaarɨ twagwatana nabhʉ kwita abharʉʉtɨrɨri bha Mungu.’ ");
INSERT INTO ikz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kʉ kʉgambabhu, mʉramenyeekererya kʉbha na niimwɨ, nɨ‑bhaana bha bhasʉʉkʉrʉ bhaanyu bhanʉ bhiitirɨ abharʉʉtɨrɨri bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mmbe, mukunaanʼyɨ ʉbhʉbhɨ bhʉnʉ bhasʉʉkʉrʉ waanyu bhaatangirɨ! ");
INSERT INTO ikz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Imwɨ urwibhʉrʉ rwe enzoka! Mʉratʉrabhwɨ kwibheza ɨtɨnɨrʉ ya Mungu yo okorekerwa momorero gwa nyaari? ");
INSERT INTO ikz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Igʉrʉ wa riyo, rora, nɨratʉma kwa niimwɨ abharʉʉtɨrɨri bha Mungu, abhaatʉ bha abhamɨnyi bha Amaandɨkʉ Amarɨndu, na abhiija bhi imigirʉ ja Mungu. Nawe obhorebhe bhaabhʉ, mʉrabhiita na kʉbhabhamba kʉmʉsarabha. Abhandɨ mʉrabhatema ɨmɨzariti mʉmarwazɨrʉ gaanyu, na abhandɨ mʉrabhatuna hʉhʉʉsi harya mʉzɨmbɨri na kʉbhanyaacha. ");
INSERT INTO ikz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kʉgayo, Mungu arabhatɨnɨra imwɨ kʉ kʉbha yu ukwita bhe eheene bhʉʉsi. Mʉkakorabhu, kwɨma hanʉ Kaɨni iitirɨ Abhɨɨri wʉnʉ ataarɨ nʉ ʉbhʉbhɨ bhwʉbhwʉsi, kuhika kwitwa kwa Zaakariya, umwana wa Bharakiya, wʉnʉ iitirwɨ mwihekaaru gatɨ wa Ahagero Aharɨndu na hu ukuhurukirya ikimweso. ");
INSERT INTO ikz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nɨrabhabhʉʉrɨra amaheene, Mungu aratɨnɨra abhaatʉ bhu urwibhʉrʉ rʉnʉ kwa amabhɨ gayo gʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Neho Yɨɨsu akabhuga, “Awɨ Yɨrusarɨɨmu, Yɨrusarɨɨmu! Uriita abharʉʉtɨrɨri na kʉbhatema amabhwɨ bhanʉ bhaatumirwɨ kwa niimwɨ. Niigʉmbirɨ manga kaaru kʉbhakumɨnga hamwɨmwɨ abhaana bhaazʉ, chɨmbu engoko ɨhaakumɨnga ibhizuri bhyayo mʉmapapa, nawe mʉtɨɨndirɨ! ");
INSERT INTO ikz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rora, Mungu aratiga umujɨ gwanyu itongo. ");
INSERT INTO ikz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Inyɨ nɨrabhabhʉʉrɨra, mʉtakondora kwikɨ kuhika ribhaga rɨnʉ mʉraabhugɨ, ‘Anʉ ʉrʉbhangʉ wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ Mungu!’ ” ");
INSERT INTO ikz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yɨɨsu akabhʉʉka mwihekaaru. Hanʉ aarɨ arahʉrʉkamu, abhɨɨga bhaazɨ bhakamutuna korereke bhamwereche chɨmbu amakindasi ga rihekaaru gazʉmirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nawe Yɨɨsu akabhabhʉʉrɨra, “Mʉrʉʉzɨ bhwaheene amakindasi ganʉ gʉʉsi? Nɨrabhabhʉʉrɨra amaheene, rɨtareeho ibhwɨ rɨnʉ rɨkʉsaaga igʉrʉ wɨ ɨrɨndɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mmbe, Yɨɨsu akaja kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni akiikara. Abhɨɨga bhaazɨ bhakamutuna kekoro, bhakamubhuurya, “Tʉbhʉʉrɨrɨ, amangʼana gayo garahʉrʉka ryʉrɨ? Na ni‑chɨrɨkɨnʼyʉkɨ kɨnʉ kiriitwereche ʉkʉgarʉka kwazʉ nu ukuhika mʉtɨnɨrʉ wɨ ɨɨsɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yɨɨsu akabhagarukirya, “Mwangarɨrɨ, ʉmʉʉtʉ wʉwʉʉsi ataaza kʉbhakangirirya! ");
INSERT INTO ikz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abhaatʉ bhaaru bharaaza kuriina ryanɨ, bharabhuga, ‘Inyɨ ni‑Kiriisitʉ,’ na bharakangirirya abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Ribhaga riyo, mʉrabha muriigwa igʉrʉ wa riihɨ na amangʼana ga riihɨ. Mʉtakangwa, kʉ kʉbha gayo gareenderwa gakorwe, nawe ɨtɨnɨrʉ yɨ ɨɨsɨ ɨrabha ɨkɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Icharʉ kɨmwɨ kiriitana nɨ ɨkɨndɨ, nʉ ʉbhʉtɨmi bhʉmwɨ bhuriitana nʉ ʉbhʉndɨ. Ɨnzara ni ibhirigitʉ bhyɨ ɨɨsɨ bhɨrahʉrʉka ahagero hʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gayo gʉʉsi garabha chɨmbu ʉbhʉtangɨ bhwʉ ʉbhʉsʉngʉ bhwʉ ʉmʉkari wʉnʉ akwenda kwibhʉra. ");
INSERT INTO ikz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ribhaga riyo, abhaatʉ bharabhiichʉra korereke mʉnyaakɨ na kubhiita, na abhaatʉ bhi ibhyarʉ bhyʉsi bharabhabhiihirirwa igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Neho abhaatʉ bhaaru bharatiga kuntuna. Bharabha bhariiyanga na kwiyigatanɨra abheene kobheene. ");
INSERT INTO ikz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Na bharabhoneka abharʉʉtɨrɨri bhaaru bhʉ ʉrʉrɨmɨ, bhanʉ bharaakangiriryɨ abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nʉ ʉbhʉsɨɨgi bhwa abhaatʉ bhaaru bhʉrasuuha, kʉ kʉbha ʉbhʉbhɨ bhʉraaruha. ");
INSERT INTO ikz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nawe wʉnʉ ariigumiriryɨ kuhika ɨtɨnɨrʉ, newe araasabhʉkɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ɨtɨnɨrʉ, Ɨngʼana Ɨnzʉmu igʉrʉ wʉ ʉbhʉtɨmi bhwa mwisaarʉ bhɨrarwazibhwa mʉzɨɨsɨ zʉʉsi. Kwa ribhaga rɨnʉ abhaatʉ bhʉʉsi bharabha bhabhwɨnɨ umweya gu ukwigwa ʉbhʉmɨnyɨɨkɨrɨri bhuyo, neho ɨtɨnɨrʉ yɨ ɨɨsɨ ɨrahika. ");
INSERT INTO ikz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ribhaga riyo, mʉrarora ʉbhʉrʉrʉ bhʉnʉ ʉmʉrʉʉtɨrɨri Danyɨri aabhugirɨ ʉbhʉsarya. Mʉrarora bhwimiiriirɨ Ahagero Aharɨndu ha rihekaaru. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akosoma amangʼana ganʉ, amenye enzobhooro yaku. ");
INSERT INTO ikz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Neho abhaatʉ bhanʉ bharɨ Yudeya, bhangʼosere mʉbhɨgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ʉmʉʉtʉ wʉnʉ ari igʉrʉ kʉkɨsara chi inyumba, atiika korereke agege ebhegero bhɨnʉ bhiri munyumba, angʼose. ");
INSERT INTO ikz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na wʉnʉ akʉbha mʉmʉgʉndʉ angʼose, atiichʉra inyuma kogega zengebho zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tʉrabharorera ɨbhɨgʉngi abhakari bhanʉ bharɨnda na bhanʉ bhakʉbha bharakoocha zisikʉ ziyo. ");
INSERT INTO ikz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mmbe, mʉsabhɨ Mungu kʉbha kuryara kwanyu kʉtaaza kʉbha ribhaga rye embeho ɨhaari hamwɨ kurusikʉ rwʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maheene, zisikʉ ziyo, abhaatʉ bharabhona ɨnyaakʉ kʉrʉ bhʉkʉngʼu. Ɨnyaakʉ yɨnʉ, ɨkɨɨrɨ kʉhʉrʉka kwɨma ʉbhʉtangɨ bhwɨ ɨɨsɨ kuhika reero yɨnʉ. Na ɨtakobhoneka kwikɨ yɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Angabhɨɨrɨ Mungu atasuuhya zisikʉ ziyo, ataarɨ areho ʉmʉʉtʉ wʉwʉʉsi wʉnʉ aarɨ akʉsabhʉka. Nawe arasuuhya zisikʉ ziyo, igʉrʉ wa abharobhorwa bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mmbe, ribhaga riyo, ʉmʉʉtʉ wʉwʉʉsi araabhabhʉʉrɨrɨ, ‘Rora, Kiriisitʉ arɨ hanʉ!’ hamwɨ, ‘Ari irya!’ mutiisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bharabhaho abharʉʉtɨrɨri bhʉ ʉrʉrɨmɨ na abhaatʉ bhanʉ bhakwibhɨrɨkɨra Kiriisitʉ. Bhareerekenʼya ibhyɨrɨkɨnʼyʉ bhyaru na amateemo korereke bhageme kurimirya abhaatʉ, ɨrɨɨtʉrɨkanɨ nʉʉrʉ abharobhorwa bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mʉbhɨ mɨɨsʉ! Nɨbhabhuuriirɨ bhwangʉ gʉʉsi gayo gakɨɨrɨ kʉhʉrʉka. ");
INSERT INTO ikz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mmbe abhaatʉ bharaabhabhʉʉrɨrɨ, ‘Rora, Kiriisitʉ ari mwitɨrɨgʉ irya!’ mʉtajayu. Hamwɨ bharaabhabhʉʉrɨrɨ, ‘Rora, yiibhisirɨ munyumba muyo!’ mʉtaaza kubhiisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Momenye kʉbha ukuuza ku Umwana wʉ Ʉmʉʉtʉ, kʉrabha kwa kʉtacha. Ɨrabha chɨmbu ʉrʉkʉbha rʉhaarorekana rogendo rʉmwɨ rʉgʉrʉ na nyanza. ");
INSERT INTO ikz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ahagero hɨ ɨkɨtʉndʉ, neho zɨmatʉʉnyi zikwibhiringa. ");
INSERT INTO ikz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mmbe, hanʉ ɨnyaakʉ ya ribhaga riyo ɨraahɨtɨbhu, iryʉbha rɨrabha ni ikiirimya, umwɨri gʉtakuhurucha ubhwɨrʉ naatu, na zenzota zʉʉsi zɨragwa haasɨ kurwa mwisaarʉ. Ebhegero bhyʉsi bhya mwisaarʉ bhɨrasingisa. ");
INSERT INTO ikz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Neho, ichɨrɨkɨnʼyʉ chu Umwana wʉ Ʉmʉʉtʉ kɨraarorekanɨ mwisaarʉ, ni ibhyarʉ bhyʉsi bhɨratanga kʉrɨra kubhwʉbha. Hanʉ nikuuza, abhaatʉ bhʉʉsi bharandora mʉmasaarʉ na zinguru nʉ ʉbhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Neho aratʉma bhamaraika bhaazɨ. Bharatema rihembe bhʉkʉngʼu, korereke bhabhiringɨ abharobhorwa bhʉʉsi bha Mungu kurwa mbaara zʉʉsi inyɨ zɨ ɨɨsɨ. Nabhʉ bharaaza kurwa mʉtɨnɨrʉ yʉ ʉrʉbhaara rʉmwɨ rwɨ ɨɨsɨ kuhika mʉtɨnɨrʉ yʉ ʉrʉbhaara ʉrʉndɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yɨɨsu akangʼeha kʉgamba, “Mwɨgɨ kurwa kʉmʉtɨ gwu umutiini. Hanʉ mokorora ibhisha bhɨrasɨbhʉka na amatʉʉtʉ gabhariryɨ, mʉramenya kʉbha ribhaga rya rigesa rɨrariirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɨbhuɨbhu, hanʉ mʉraarore gayo gʉʉsi gatangirɨ, momenye kʉbha arɨ haguhɨ kuuza. ");
INSERT INTO ikz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nɨrabhabhʉʉrɨra amaheene, ribhaga ryu urwibhʉrʉ rʉnʉ rɨtakʉhɨta kuhika gayo gʉʉsi gakorwe. ");
INSERT INTO ikz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Risaarʉ nɨ ɨɨsɨ bhɨrahɨta, nawe ɨngʼana yaanɨ ɨtakʉhɨta kemerano. ");
INSERT INTO ikz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nawe, igʉrʉ wu urusikʉ na ribhaga ryu ukuuza, atareeho ʉmʉʉtʉ wʉnʉ yɨɨzɨ. Naabha bhamaraika bha mwisaarʉ hamwɨ Umwana bhʉʉsi bhatɨɨzɨ, nawe Bhaabha umwenebhu. ");
INSERT INTO ikz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kuriyo, ukuuza ku Umwana wʉ Ʉmʉʉtʉ kʉrabha chɨmbu yaarɨ zisikʉ za Nuuhu. ");
INSERT INTO ikz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ribhaga rɨnʉ imbura ya riteemo yaarɨ ɨkɨɨrɨ kuuza, abhaatʉ bhaarɨ bhararya na kunywa, bharakwɨra na kukwɨrwa, kuhika urusikʉ rʉnʉ Nuuhu aasikiirɨ mʉsafina. ");
INSERT INTO ikz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abhaatʉ bhayo bhataamɨnyirɨ nɨkɨ kɨkʉbha, kuhika hanʉ riteemo rya amanzi ryizirɨ na kubhiita bhʉʉsi. Ɨbhu nɨmbu ɨrɨɨbhɨ hanʉ Umwana wʉ Ʉmʉʉtʉ ariizɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ribhaga riyo, abhaatʉ bhabhɨrɨ bharɨɨbhɨ mʉmʉgʉndʉ, Umwana wʉ Ʉmʉʉtʉ aragegaho ʉwʉmwɨ na kutiga ʉwʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na abhakari bhabhɨrɨ arɨɨbhɨ bharasha hamwɨmwɨ kʉrʉbhwɨ, Umwana wʉ Ʉmʉʉtʉ aragegaho ʉwʉmwɨ na kutiga ʉwʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mmbe motengeeze, kʉ kʉbha mʉtɨɨzɨ ni‑rusikʉkɨ rʉnʉ Ʉmʉkʉrʉ waanyu ariizɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Nawe momenye bhwaheene ringʼana rɨnʉ, wi inyumba angamɨnyirɨ ribhaga rɨnʉ umwibhi akuuza, aarɨ aratengeeza, na ataarɨ arahindɨra korereke umwibhi ataaza kohomora inyumba na kwibha. ");
INSERT INTO ikz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nangʉ, na niimwɨ mʉbhɨ bhwaheene ibhaga ryʉsi, kʉ kʉbha Umwana wʉ Ʉmʉʉtʉ araaza ribhaga rɨnʉ mʉtakwisega.” ");
INSERT INTO ikz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yɨɨsu akabhabhuurya abhɨɨga bhaazɨ, “Mmbe, nɨ‑wɨɨwɨ mbʉʉsa omoheene na wa amangʼɨɨni? Nɨ‑mbʉʉsa wʉnʉ ʉmʉkʉrʉ waazɨ amʉtɨɨrɨ kʉbha umwimiiririri wa bhambʉʉsa abhandɨ munyumba yaazɨ, korereke abhɨ arabhaha ibhyakurya kwibhaga ryazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hakɨrɨku mbʉʉsa wʉnʉ hanʉ ʉmʉkʉrʉ waazɨ araagarʉkɨ kurwa orogendo arabhona arakora chɨmbu aamuswajiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nɨrabhabhʉʉrɨra amaheene, ʉmʉkʉrʉ waazɨ aratʉʉra omohocha wuyo abhɨ umwimiiririri we ebhegero bhyazɨ bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Nawe mbʉʉsa ʉmʉbhɨ nɨ‑wʉnʉ ahiigambɨra mokoro yaazɨ, ‘Ʉmʉkʉrʉ waanɨ arakeezera kʉgarʉka,’ ");
INSERT INTO ikz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ahaatanga kotema bhambʉʉsa abhakɨndichazɨ, na kurya na kunywa amarwa hamwɨmwɨ na abhanywi. ");
INSERT INTO ikz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ʉmʉkʉrʉ waazɨ aragarʉka urusikʉ nɨ ɨɨsa yɨnʉ mbʉʉsa atakwiseega. ");
INSERT INTO ikz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aramotema kɨbhɨ na kʉmʉtʉʉra iribhita imwɨmwɨ na abhabhɨɨhi. Iyo bhararɨra na kokepeha.” ");
INSERT INTO ikz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Neho Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ ekerenjo ɨkɨndɨ, “Ribhaga riyo, ʉbhʉtɨmi bhwa mwisaarʉ bhʉratuubhana na abhaacha ikumi, bhanʉ bhaagɨgirɨ ɨbhɨmʉrɨ bhyabhʉ kuja kʉsʉngʼaana umukwɨri. ");
INSERT INTO ikz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bhataanʉ mwikumi bhayo, bhaarɨ abhageege na bhataanʉ abhandɨ bhaarɨ bha amangʼɨɨni. ");
INSERT INTO ikz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhageege bhayo, bhakagega ɨbhɨmʉrɨ bhyabhʉ, nawe bhataagɨgirɨ na amaguta gu ukwongera. ");
INSERT INTO ikz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nawe bha amangʼɨɨni bhakagega ɨbhɨmʉrɨ bhyabhʉ, hamwɨmwɨ na amaguta gu ukwongera mʉbhɨmʉrɨ bhyabhʉ mobhegero. ");
INSERT INTO ikz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Hanʉ umukwɨri aakɨzɨɨrɨ kuuza, abhaacha bhayo bhʉʉsi bhakasundagɨra, bhakahindɨra zendooro za turu. ");
INSERT INTO ikz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nawe ubhutikʉ gatɨgatɨ, abhaatʉ bhakarɨgɨsa, ‘Rora, umukwɨri araaza! Muuzɨ, mʉhʉrʉkɨ mujɨ kʉmʉsʉngʼaana!’ ");
INSERT INTO ikz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Rogendo rʉmwɨ, abhaacha bhayo bhʉʉsi bhakabhʉʉka, bhakatenga ɨbhɨmʉrɨ bhyabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abhaacha abhageege bhakabhʉʉrɨra bha amangʼɨɨni, ‘Tʉrasabha mʉtʉsakiryɨ amaguta gaanyu hasuuhu, kʉ kʉbha ɨbhɨmʉrɨ bhyɨtʉ bhɨrarima.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nawe bha amangʼɨɨni bhakabhagarukirya, ‘Zɨyi, tʉtakʉtʉra kʉbhasakirya, kʉ kʉbha amaguta ganʉ tʉnagʉ, gatakʉtʉra kutwisa itwɨ na niimwɨ. Mujɨ kʉbhanʉ bhakugurya amaguta, mwigʉrɨrɨ imubheene.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Hanʉ abhaacha abhageege bhaagiirɨ kʉgʉra amaguta, umukwɨri akahika. Abhaacha bha amangʼɨɨni bhaarɨ bhabhanwirɨ, bhakasikɨra hamwɨmwɨ nawe mubhuryakari, ikisikʉ kikiigarwa. ");
INSERT INTO ikz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Akʉmara abhaacha abhageege bharya bhakagarʉka, bhakabhona ikisikʉ chigɨɨrwɨ. Neho bhakiimɨɨrɨra igʉtʉ bhakabhɨrɨkɨra, ‘Ʉmʉkʉrʉ! Ʉmʉkʉrʉ! Twigʉrɨrɨ!’ ");
INSERT INTO ikz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nawe umukwɨri akabhagarukirya, ‘Nɨrabhabhʉʉrɨra amaheene, nɨtabhɨɨzɨ imwɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yɨɨsu akamara kwa kubhuga, “Mmbe motengeeze, kʉ kʉbha mʉtɨɨzɨ urusikʉ nʉʉrʉ ɨɨsa yɨnʉ nɨkʉgarʉka.” ");
INSERT INTO ikz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yɨɨsu akangʼeha kuhurucha ekerenjo ɨkɨndɨ, akabhuga, “Nʉ ʉbhʉtɨmi bhwa mwisaarʉ bhutuubhɨɨnɨ nʉ ʉmʉʉtʉ wʉnʉ ɨɨndirɨ kuja orogendo. Hanʉ aarɨ akɨɨrɨ kʉtanga orogendo rwazɨ, akabhabhɨrɨkɨra bhambʉʉsa bhaazɨ, akabhaha ebhegero bhyazɨ korereke bhabhyimɨɨrɨrɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akabhaha bhambʉʉsa bhʉʉsi kʉrɨngʼaana nʉ ʉbhʉnaja bhwabhʉ. Akamoha we embere zɨtaranta isaanʉ, wa kabhɨrɨ zɨtaranta ibhɨrɨ na wa katatʉ ɨtaranta yɨmwɨ. Akʉmara akabhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Hayohayo, wʉnʉ ahɨɨrwɨ zɨtaranta isaanʉ, akaja nazʉ kusuruja na akobhona zɨtaranta ɨzɨndɨ isaanʉ. ");
INSERT INTO ikz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ɨbhuɨbhu, wʉnʉ aahɨɨrwɨ zɨtaranta ibhɨrɨ, akaja nazʉ kusuruja na kobhona zɨtaranta ɨzɨndɨ ibhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nawe wʉnʉ aahɨɨrwɨ ɨtaranta yɨmwɨ, ewe akaja akatuka umwobho na kurindɨra ɨtaranta yʉ ʉmʉkʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hanʉ zaahitirɨ sikʉ nzaru, ʉmʉkʉrʉ waabhʉ akagarʉka. Akabhabhɨrɨkɨra bhambʉʉsa bhaazɨ, korereke ahɨtɨrɨ nabhʉ chɨmbu bhaakʉrɨɨrɨ ebhegero bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mbʉʉsa wʉnʉ aahɨɨrwɨ zɨtaranta isaanʉ, akaaza na zɨtaranta ɨzɨndɨ isaanʉ, akamʉbhʉʉrɨra ʉmʉkʉrʉ waazɨ, ‘Ʉmʉkʉrʉ, ʉkangʼa zɨtaranta isaanʉ korereke nezekorere emeremo. Rora, nibhwɨnɨ zɨtaranta ɨzɨndɨ isaanʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ʉmʉkʉrʉ waazɨ akamʉbhʉʉrɨra, ‘Ʉkʉrirɨ bhwaheene bhʉkʉngʼu. Awɨ nɨ‑mbʉʉsa mʉzʉmu na moheene! Waarɨ moheene kubhisuuhu bhɨnʉ nakʉhɨɨrɨ, nangʉ nɨrakʉtʉʉra kʉbha umwimiiririri we ebhegero ibhyaru. Nauzɨ tozomerwe hamwɨmwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mbʉʉsa wʉnʉ ahɨɨrwɨ zɨtaranta ibhɨrɨ, nawe akaaza na zɨtaranta ibhɨrɨ ɨzɨndɨ, akabhʉʉrɨra ʉmʉkʉrʉ waazɨ, ‘Ʉmʉkʉrʉ, ʉkangʼa zɨtaranta ibhɨrɨ korereke nezekorere emeremo. Rora, nibhwɨnɨ zɨtaranta ɨzɨndɨ ibhɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ʉmʉkʉrʉ waazɨ akamʉbhʉʉrɨra, ‘Ʉkʉrirɨ bhwaheene bhʉkʉngʼu. Awɨ nɨ‑mbʉʉsa mʉzʉmu na moheene! Waarɨ moheene kubhisuuhu bhɨnʉ nakʉhɨɨrɨ, nangʉ nɨrakʉtʉʉra kʉbha umwimiiririri we ebhegero ibhyaru. Nauzɨ tozomerwe hamwɨmwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nawe mbʉʉsa wʉnʉ ahɨɨrwɨ ɨtaranta yɨmwɨ, akaaza na kʉmʉbhʉʉrɨra ʉmʉkʉrʉ waazɨ, ‘Ʉmʉkʉrʉ, nɨkamenya kʉbha awɨ nɨ‑mʉʉtʉ mʉkʉngʼu bhʉkʉngʼu. Wahaagesa hanʉ ʉtaahambirɨ, na kubhiringa hanʉ ʉtaanyaragɨɨnʼyɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nɨkʉʉbhaha kurimirya ɨtaranta yaazʉ, nɨkayitukɨra haasɨ. Nangʉ gega ɨtaranta yaazʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ʉmʉkʉrʉ waazɨ akamʉgarukirya, ‘Awɨ, nɨ‑mbʉʉsa mʉbhɨ na mʉtʉbhu! Arɨɨbhɨ ʉkamenya kʉbha inyɨ nɨhaagesa hanʉ nɨtaahambirɨ na kubhiringa hanʉ nɨtaanyaragɨɨnʼyɨ, ");
INSERT INTO ikz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mmbe kwakɨ ʉtantɨɨrɨɨrɨ ɨtaranta yaanɨ kʉbhasuruja? Sumba zibhwirɨ, hanʉ naarɨ nɨkʉgarʉka ɨwaanɨ, naarɨ nɨragega nzaru kʉkɨraho.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Neho ʉmʉkʉrʉ waazɨ akaswaja abhandɨ, ‘Mogege ɨtaranta yiyo, mohe mbʉʉsa wʉnʉ ana zɨtaranta ikumi. ");
INSERT INTO ikz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akokorera emeremo rɨnʉ nɨmʉhɨɨrɨ, nɨramwongereerera maaru. Nawe ʉmʉʉtʉ wʉwʉʉsi wʉnʉ atakokora emeremo amasuuhu ganʉ nɨmʉhɨɨrɨ, nʉʉrʉ ikisuuhu kɨnʉ anachʉ, nɨramuruusha. ");
INSERT INTO ikz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mbʉʉsa wʉnʉ ataana bhwera. Momorekere igʉtʉ mukiirimya iyo kʉrabha nɨ ɨkɨrɨrʉ na kokepeha.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yɨɨsu akangʼeha kʉgambana na abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Hanʉ Umwana wʉ Ʉmʉʉtʉ ariizɨ nʉ ʉbhʉkʉrʉ bhwazɨ, hamwɨmwɨ na bhamaraika bhʉʉsi abharɨndu, neho ariikarɨ nchʉ ʉmʉtɨmi kukitumbɨ chazɨ, mʉʉsɨ iihya. ");
INSERT INTO ikz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abhaatʉ bhi ibhyarʉ bhyʉsi bhariibhiringa mʉbhʉtangɨ bhwazɨ. Arabhaahʉra nchu umuriisha akwahʉra zɨngʼʉndu kurwa muzimburi. ");
INSERT INTO ikz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Chɨmbu umuriisha ahaatʉʉra zɨngʼʉndu ʉrʉbhaara rwazɨ rwu ubhuryʉ na zimburi ʉrʉbhaara rwazɨ rwʉ ʉbhʉmʉsi, ɨbhuɨbhu, wʉʉsi arabhatʉʉra abhaatʉ abhandɨ ʉrʉbhaara rwazɨ rwu ubhuryʉ na abhandɨ ʉrʉbhaara rwazɨ rwʉ ʉbhʉmʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Neho Ʉmʉtɨmi araabhabhʉʉrɨrɨ bhanʉ bharɨ ʉrʉbhaara rwazɨ rwu ubhuryʉ, ‘Muuzɨ, bhanʉ mʉhɨɨrwɨ ʉrʉbhangʉ na Bhaabha. Musikɨrɨ mʉbhʉtɨmi bhʉnʉ mwakʉrɨɨrwɨ kwɨma okoteemwa kwi icharʉ. ");
INSERT INTO ikz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hanʉ naarɨ nɨ ɨnzara, mʉkangʼa ibhyakurya. Hanʉ naarɨ ne enyoota, mʉkangʼa amanzi gu ukunywa. Hanʉ naarɨ umugini, mʉkanginihya. ");
INSERT INTO ikz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hanʉ naarɨ tʉʉhʉ, mʉkanyiibhohya. Hanʉ naarɨ murwɨrɨ, mʉkandwarya. Na hanʉ naarɨ mokebhoho, mʉkaaza kondora.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ɨbhu, abhaatʉ bhayo bhe eheene mʉbhʉtangɨ bhwa Mungu bharangarukirya kʉbha, ‘Ʉmʉkʉrʉ, ni‑ryʉrɨ twakʉrʉʉzɨ ʉnɨ ɨnzara tʉkakoha ibhyakurya? Hamwɨ one enyoota tʉkakoha amanzi gu ukunywa? ");
INSERT INTO ikz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na ni‑ryʉrɨ twakʉrʉʉzɨ umugini tʉkakuginihya? Hamwɨ ʉrɨ tʉʉhʉ tʉkakwibhohya? ");
INSERT INTO ikz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ni‑ryʉrɨ umurwɨrɨ tʉkakurwarya? Hamwɨ ʉrɨ mokebhoho tʉkaaza kokorora?’ ");
INSERT INTO ikz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Neho Ʉmʉtɨmi araabhagarukiryɨ, ‘Nɨrabhabhʉʉrɨra amaheene kʉbha, ryʉryʉsi rɨnʉ mwakʉrɨɨrɨ wʉwʉʉsi gatɨ wa abhahiiri bhanʉ bhataana ubhwɨndi, mʉkankorera inyɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Akʉmara, arabhabhʉʉrɨra bhanʉ bharɨ ʉrʉbhaara rwazɨ rwʉ ʉbhʉmʉsi, ‘Murwɨ hanʉ, imwɨ bhanʉ mwihiimirwɨ! Mujɨ momorero gwa kemerano gʉnʉ aakʉrɨɨrwɨ Shɨtaani na bhamaraika bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Murwɨ hanʉ, kʉ kʉbha hanʉ naarɨ nɨ ɨnzara, mʉtaangʼɨɨrɨ ibhyakurya. Hanʉ naarɨ ne enyoota, mʉtaangʼɨɨrɨ amanzi gu ukunywa. ");
INSERT INTO ikz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hanʉ naarɨ umugini, mʉtanginihiryɨ. Hanʉ naarɨ tʉʉhʉ, mʉtanyiibhʉhiryɨ. Hanʉ naarɨ murwɨrɨ, mutiizirɨ kundwarya. Na hanʉ naarɨ mokebhoho, mutiizirɨ kondora.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Neho abhaatʉ bhayo bhʉʉsi bharaangarukiryɨ, ‘Ʉmʉkʉrʉ, ni‑ryʉrɨ twakʉrʉʉzɨ ʉnɨ ɨnzara, hamwɨ one enyoota, hamwɨ waarɨ umugini, hamwɨ waarɨ tʉʉhʉ, hamwɨ waarɨ murwɨrɨ, hamwɨ waarɨ mokebhoho, na tʉtakʉsakiiryɨ?’ ");
INSERT INTO ikz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Neho arabhagarukirya, ‘Nɨrabhabhʉʉrɨra amaheene kʉbha, ryʉryʉsi rɨnʉ mʉtakʉrɨɨrɨ wʉwʉʉsi gatɨ wa abhiisirirya wʉnʉ ataana ubhwɨndi, mʉtankʉrɨɨrɨ inyɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mmbe, abhakʉri bhʉ ʉbhʉbhɨ bhayo, bharaja kusikɨra mʉnyaakʉ ya kemerano. Nawe bhe eheene, bharaja mʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo gʉʉsi, akabhʉʉrɨra abhɨɨga bhaazɨ, ");
INSERT INTO ikz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Chɨmbu mwɨzɨ, zɨraahɨtɨ sikʉ ibhɨrɨ, tʉrabha ni isigukuru yɨ Ɨpasaka. Urusikʉ ruyo, Umwana wʉ Ʉmʉʉtʉ arahurukibhwa, korereke iitwɨ kʉmʉsarabha.” ");
INSERT INTO ikz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mmbe, ribhaga riyo, abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi bhakiibhiringa munyumba ya kuhaani ʉmʉkʉrʉ, iriina ryazɨ Kayaafa. ");
INSERT INTO ikz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Muyo, bhakagambana chɨmbu bharaamugwatɨ Yɨɨsu kwa mbisi, korereke bhamwitɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nawe bhakabhuga, “Tʉtaaza kokora ganʉ ribhaga ryi isigukuru yɨ Ɨpasaka, abhaatʉ bhataaza kokora ɨkɨmpʉgɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Neho Yɨɨsu akaja mʉrʉbhɨri rwa Bhɨtaniya, akiikara munyumba ya Simʉʉni wʉnʉ aarɨ ne ebhegenge. ");
INSERT INTO ikz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hanʉ Yɨɨsu aarɨ kwigari, akaaza ʉmʉkari wʉmwɨ kwewe ani ichupa ɨnzʉmu ya amaguta ganʉ gaarɨ gi iguri ikʉrʉ na garareetya bhwaheene. Ʉmʉkari wuyo akamwitʉrʉrɨra Yɨɨsu kumutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hanʉ abhɨɨga bhaazɨ bhaarʉʉzɨ gayo, bhakiigatana. Bhakabhuga, “Ndora ʉmʉkari wʉnʉ arasarya amaguta ga riguri ikʉrʉbhu? ");
INSERT INTO ikz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yaarɨ bhwaheene amaguta ganʉ gangaguriibhwɨ kuzimpirya nzaru bhʉkʉngʼu, na kʉhaabhwa abhahabhɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yɨɨsu akoobhoora ganʉ bhaarɨ bhakwiseega, akabhabhʉʉrɨra, “Ndora mʉranyaacha ʉmʉkari wʉnʉ? Ewe ankʉrɨɨrɨ ringʼana rizʉmu bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abhahabhɨ mʉnabhʉ sikʉ zʉʉsi, nawe inyɨ nɨtakʉbha hamwɨmwɨ na niimwɨ ibhaga ryʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ʉmʉkari wʉnʉ anyiitiriirɨ amaguta, korereke akonze ʉmʉbhɨrɨ gwanɨ ku kubhiikwa kwanɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nɨrabhabhʉʉrɨra amaheene, hʉhʉʉsi mubhyarʉ hanʉ abhaatʉ bhakʉbha bhararwaza Ɨngʼana Ɨnzʉmu, bharabha bharagamba rɨnʉ ʉmʉkari wʉnʉ aakʉrirɨ, kumuhiita.” ");
INSERT INTO ikz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mmbe Yuuda Isikariyʉʉti, wʉmwɨ wa abhɨɨga bha Yɨɨsu ikumi na bhabhɨrɨ, akaja kʉbhakʉrʉ bha abhakuhaani, ");
INSERT INTO ikz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akabhabhuurya, “Mʉrandɨhakɨ nɨraamugwatyɨ Yɨɨsu mʉmabhoko gaanyu?” Akʉmara bhakamʉrɨha zimpirya merongo ɨtatʉ. ");
INSERT INTO ikz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kʉtangɨra ribhaga riyo, Yuuda Isikariyʉʉti akatanga komohya umweya ʉmʉzʉmu gu ukumwichʉra. ");
INSERT INTO ikz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kurusikʉ rwʉ ʉbhʉtangɨ rwi isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru, abhɨɨga bha Yɨɨsu bhakaja kwawɨ, bhakamubhuurya, “Oreenda tujɨ hayi tokokorere ahagero hʉ ʉkʉrɨɨra Ɨpasaka?” ");
INSERT INTO ikz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yɨɨsu akabhaha iriina ryʉ ʉmʉʉtʉ omorebhe akabhuga, “Mujɨ mʉrʉbhɨri rwa Yɨrusarɨɨmu kʉmʉʉtʉ wuyo, mʉmʉbhʉʉrɨrɨ, ‘Umwija atutumirɨ na arabhuga, “Ribhaga ryanɨ rɨrɨ haguhɨ. Inyɨ na abhɨɨga bhaanɨ tʉrarya Ɨpasaka munyumba yaazʉ.”’” ");
INSERT INTO ikz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abhɨɨga bhaazɨ bhakakora gʉʉsi chɨmbu Yɨɨsu aabhatumirɨ, bhakatenga ibhyakurya bhyɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hanʉ ryahikirɨ rigoroobha, Yɨɨsu na abhɨɨga bhaazɨ ikumi na bhabhɨrɨ bhakiikara kurya ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hanʉ bhaarɨ bhararya, akabhabhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, wʉmwɨ waanyu aranyiichʉra.” ");
INSERT INTO ikz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abhɨɨga bhaazɨ bhakarumɨka bhʉkʉngʼu, bhakatanga kumubhuurya wʉmwɨ wʉmwɨ, “Ʉmʉkʉrʉ, nangʉ niinyɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yɨɨsu akagarukirya, “Nɨ‑wʉnʉ akokorya hamwɨmwɨ na niinyɨ mʉbhakuri, newe araanyiichʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Maheene Umwana wʉ Ʉmʉʉtʉ araja kukwa, chɨmbu Amaandɨkʉ Amarɨndu gakubhuga igʉrʉ waazɨ. Nawe, horeera kʉmʉʉtʉ wʉnʉ ariichʉrɨ Umwana wʉ Ʉmʉʉtʉ! Yaarɨ hakɨrɨku kwewe atangibhwirwɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mmbe, Yuuda wʉnʉ aatɨɨrɨ Yɨɨsu mʉmabhoko ga abhabhisa, wʉʉsi akamubhuurya, “Umwija, nangʉ niinyɨ?” Yɨɨsu akamʉgarukirya, “Naawɨ ubhugirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hanʉ bhaarɨ bhararya, Yɨɨsu akagega ʉmʉkaatɨ, akabhʉʉrɨra Mungu, azʉmiryɨ. Akagusunyura, akabhaha abhɨɨga bhaazɨ, akabhuga, “Mogege muryɨ, gʉnʉ negwe ʉmʉbhɨrɨ gwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akʉmara, akagega ekekombe chi idivaayi, akabhʉʉrɨra Mungu, azʉmiryɨ, akabhaha arabhuga, “Mogege, munywɨ imwʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ganʉ nego amasaahɨ gaanɨ gʉ ʉbhʉragɨ, ganʉ gakwitɨka igʉrʉ wa abhaatʉ bhaaru ku kuruushwa ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɨrabhabhʉʉrɨra, nɨtakunywa naatu idivaayi kuhika hanʉ nikunywa bhuhya hamwɨmwɨ na niimwɨ mʉbhʉtɨmi bhwa Bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Akʉmara bhakɨɨmba iryɨmbʉ ryu ukukumya Mungu. Bhakabhʉʉka hayo, bhakaja kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. ");
INSERT INTO ikz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mmbe, Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Ubhutikʉ bhwa reero, imwɨ bhʉʉsi mʉrangʼosa na kuntiga. Ɨrabhabhu, chɨmbu Mungu aagambirɨ mʉMaandɨkʉ Amarɨndu, ‘Nɨramwita umuriisha, na riribhita rya zɨngʼʉndu zaazɨ rɨranyaragana.’ ");
INSERT INTO ikz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nawe hanʉ nikuryʉka, nɨrabhakangatɨra kuja Gariraaya.” ");
INSERT INTO ikz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peetero akamʉbhʉʉrɨra, “Nangabha bhʉʉsi bharakutiga, inyɨ nɨtakukutiga zee!” ");
INSERT INTO ikz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yɨɨsu akamʉgarukirya, “Nɨrakʉbhʉʉrɨra amaheene, ubhutikʉ bhwa reero, ekorokoome ɨkɨɨrɨ kʉgamba, ʉrabha ʉnyangirɨ manga katatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peetero akamʉgarukirya, “Nangabha kukwa, nikwɨ hamwɨmwɨ na naawɨ, nɨtakukwanga zee!” Abhɨɨga abhandɨ bhʉʉsi, bhakabhuga ɨbhuɨbhu. ");
INSERT INTO ikz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mmbe, Yɨɨsu akaja na abhɨɨga bhaazɨ mubhusitaani yɨnʉ ikubhirikirwa Gɨtisɨmanɨ. Akabhabhʉʉrɨra, “Mwikarɨ hinga hanʉ, nijɨ kʉsabha Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akagega Peetero hamwɨmwɨ na abhaana bhabhɨrɨ bha Zebhedaayo. Akatanga kurumɨka na kʉnyaaka bhʉkʉngʼu mokoro yaazɨ, ");
INSERT INTO ikz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","akabhabhʉʉrɨra, “Ekoro yaanɨ irumikirɨ bhʉkʉngʼu ekerengo chu ukukwa. Mwikarɨ hanʉ, motengeeze hamwɨmwɨ na niinyɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akiisuka embere hasuuhu, akagwa kibhumɨɨrɨ, akasabha Mungu arabhuga, “Bhaabha, arɨɨbhɨ ɨratʉrɨkana, nɨrakʉsabha unduushiryɨ ekekombe chɨ ɨnyaakʉ kɨnʉ! Ɨtarɨ chɨmbu inyɨ nikwenda, nawe gakorwe chɨmbu awɨ ukwenda.” ");
INSERT INTO ikz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mmbe, Yɨɨsu akagarʉka kʉbhɨɨga bhaazɨ, akabhabhona bhahindiirɨ. Akabhuurya Peetero, “Nangʉ, mʉtamirwɨ kotengeeza hamwɨmwɨ na niinyɨ nʉʉrʉ kwɨ ɨɨsa yɨmwɨ? ");
INSERT INTO ikz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Motengeeze na kʉsabha, mʉtaaza kusikɨra mubhitiimotiimo. Ekoro iriisirirya, nawe ʉmʉbhɨrɨ nɨ‑mʉnyʉʉhɨrɨru.” ");
INSERT INTO ikz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yɨɨsu akabhatiga, akaja iyo rwa kabhɨrɨ, akasabha arabhuga, “Bhaabha, arɨɨbhɨ ɨnyaakʉ yɨnʉ ɨtakʉtʉrɨkana kurwa kwa niinyɨ, gakorwe chɨmbu ukwenda.” ");
INSERT INTO ikz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mmbe, hanʉ aagarukirɨ kwabhʉ, akabhona kwikɨ bhahindiirɨ, kʉ kʉbha amɨɨsʉ gaabhʉ gaarɨ maritʉ. ");
INSERT INTO ikz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akabhatiga, akaja kʉsabha rwa katatʉ, akagarʉkɨra kʉgamba amangʼana garyagarya. ");
INSERT INTO ikz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Akʉmara akagarʉka naatu kwa abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Nangʉ muhindɨrɨ mwoyeere, rora! Ribhaga rihikirɨ rɨnʉ Umwana wʉ Ʉmʉʉtʉ aragwatwa na kuhirwa mʉmabhoko ga abhakʉri bhʉ ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mʉbhʉʉkɨ, tujɨ. Rora, wʉnʉ akunyiichʉra arɨ haguhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hanʉ Yɨɨsu aarɨ akɨɨrɨ aragamba gayo, hayohayo Yuuda, wʉmwɨ wa abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akaaza hamwɨmwɨ na riribhita ikʉrʉ rya abhaatʉ bha amasabha na amarungu. Riribhita riyo rɨkatumwa na abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuuda wʉnʉ aamwichurirɨ Yɨɨsu, aarɨ akangatirɨ kʉragɨrɨra abhaatʉ bhayo ichɨrɨkɨnʼyʉ. Akabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ nɨraahumbatɨ, newe mugwatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hayohayo Yuuda akaja kwa Yɨɨsu, akamʉbhʉʉrɨra, “Umwija, morembe!” Akʉmara akamuhumbata. ");
INSERT INTO ikz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yɨɨsu akamʉgarukirya, “Mʉsaani waanɨ, kora kɨnʉ kɨkʉrɨɨtirɨ.” Mmbe abhaatʉ bhayo bhakiisuka, bhakamugwata Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Neho wʉmwɨ mʉbhanʉ bhaarɨ hamwɨmwɨ na Yɨɨsu, akasohora risabha ryazɨ, akatɨna ʉkʉtwɨ kwa mbʉʉsa wa kuhaani ʉmʉkʉrʉ kutu. ");
INSERT INTO ikz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nawe Yɨɨsu akamʉbhʉʉrɨra, “Garucha risabha ahagero haaho, kʉ kʉbha bhʉʉsi bhanʉ bhakugwata risabha korereke bhiitɨ, bharakwa kwa risabha! ");
INSERT INTO ikz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nangʉ, ʉtɨɨzɨ kʉbha nɨranaja kʉsabha ʉbhʉsakirya kwa Bhaabha, nawe aratʉra kʉntʉmɨra bhamaraika kʉkɨra amaribhita amakʉrʉ ikumi na abhɨrɨ? ");
INSERT INTO ikz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hanʉ nangakʉrirɨbhu, garahikabhwɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu kʉbha, nɨmbu gakwenderwa kʉhʉrʉka?” ");
INSERT INTO ikz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Neho Yɨɨsu akabhʉʉrɨra riribhita riyo, “Ndora mwizirɨ na amasabha na amarungu kungwata, nkina inyɨ nɨ‑mʉsaakuri? Zisikʉ zʉʉsi naarɨ niriija mwihekaaru, nawe mʉtaangwatirɨ! ");
INSERT INTO ikz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nawe gʉʉsi gakʉrirwɨ, korereke gahikɨ ganʉ abharʉʉtɨrɨri bhaandikirɨ mʉMaandɨkʉ Amarɨndu.” Mmbe, abhɨɨga bhaazɨ bhʉʉsi bhakaryara, bhakamutiga. ");
INSERT INTO ikz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mmbe, bhanʉ bhaamugwatirɨ Yɨɨsu, bhakamuhira kwa Kayaafa, kuhaani ʉmʉkʉrʉ. Munyumba yaazɨ, ɨnʉ bhaarɨ bhiibhiringirɨ abhiija bhi imigirʉ ja Musa na abhakaruka bha Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peetero aarɨ aramutuna Yɨɨsu kwa kore, kuhika mukisikʉ chi inyumba ya kuhaani ʉmʉkʉrʉ. Akasikɨra mʉʉsi, akiikara hamwɨmwɨ na abhariibhi korereke arore chɨmbu ikiina cha Yɨɨsu kɨkʉbha. ");
INSERT INTO ikz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abhakʉrʉ bha abhakuhaani ni ichandarʉ chʉsi, bhakamohya obhomenyeekererya bhwʉ ʉrʉrɨmɨ korereke bhabhone ɨnzɨra yu ukwita Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bhakaaza abhamɨnyɨɨkɨrɨri bhʉ ʉrʉrɨmɨ bhaaru, nawe bhatabhwɨnɨ. ");
INSERT INTO ikz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Akʉmara bhakaaza abhamɨnyɨɨkɨrɨri bhabhɨrɨ, bhakabhuga, “Ʉmʉʉtʉ wʉnʉ akabhuga, ‘Nɨranaja kwasha rihekaaru rya Mungu na kuryʉmbaka kwa sikʉ isatʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Akʉmara kuhaani ʉmʉkʉrʉ akiimɨɨrɨra, akabhuurya Yɨɨsu, “Awɨɨ, ʉtakʉgarukirya ingʼana ryʉryʉsi? Amangʼana ganʉ abhaatʉ bhanʉ bhakʉkʉgamba?” ");
INSERT INTO ikz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nawe Yɨɨsu akakira kiri. Kuhaani ʉmʉkʉrʉ wuyo akamʉbhʉʉrɨra, “Nɨrakwirahirya kuriina rya Mungu wʉ ʉbhʉhʉru, ʉtʉbhʉʉrɨrɨ arɨɨbhɨ awɨ naawɨ Kiriisitʉ, Umwana wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yɨɨsu akamʉgarukirya, “Naawɨ ʉgambirɨ. Nawe nɨrabhabhʉʉrɨra, kʉtangɨra nangʉ, mʉrarora Umwana wʉ Ʉmʉʉtʉ ikɨɨrɨ ʉrʉbhaara rwu ubhuryʉ rwa Mungu wa Amanaga. Na mʉramorora araaza mʉmasaarʉ kurwa mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mmbe, hanʉ kuhaani ʉmʉkʉrʉ iigwirɨ amangʼana gayo, akatarandʉra amiibhoho gaazɨ, akabhuga, “Arɨgirɨ Mungu! Nɨ‑bhamenyeekereryakɨ bhanʉ tukwenda? Mwigwirɨ abheene chɨmbu akorega Mungu! ");
INSERT INTO ikz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imwɨ mʉrabhugabhwɨ?” Bhakamʉgarukirya, “Areenderwa iitwɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Akʉmara, bhakamutwɨra amatɨ mubhushʉ, bhakamotema ibhikundi. Abhandɨ bhakamotema amagʉʉhu, ");
INSERT INTO ikz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na kʉmʉbhʉʉrɨra, “Awɨ Kiriisitʉ, orootorere, nɨ‑wɨɨwɨ wʉnʉ akʉtɨmirɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mmbe, ribhaga riyoriyo, Peetero aarɨ iikɨɨrɨ igʉtʉ mukisikʉ hayo. Neho omohocha wʉmwɨ wɨ ɨkɨkari akamujaku, akamʉbhʉʉrɨra, “Na naawɨ waarɨ hamwɨmwɨ na Yɨɨsu wa Gariraaya.” ");
INSERT INTO ikz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peetero akaanga mʉbhʉtangɨ bhwa abhaatʉ bhʉʉsi, akabhuga, “Nɨtɨɨzɨ ganʉ ukubhuga!” ");
INSERT INTO ikz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hanʉ aarɨ akurwa mukisikʉ, omohocha ʉwʉndɨ wɨ ɨkɨkari akamorora, akabhabhʉʉrɨra bhanʉ bhaareho hayo, “Ʉmʉʉtʉ wʉnʉ aarɨ hamwɨmwɨ na Yɨɨsu wa Nazarɨɨti.” ");
INSERT INTO ikz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peetero akaanga kwa kwirahɨra, “Nɨtamwɨzɨ ʉmʉʉtʉ wuyo!” ");
INSERT INTO ikz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ibhaga isuuhu rɨkahɨta, abhaatʉ bhanʉ bhaarɨ bhiimiiriirɨ hayo, bhakabhʉʉrɨra Peetero, “Maheene, awɨ nɨ‑wʉmwɨ wa bhanʉ bharɨ hamwɨmwɨ na Yɨɨsu. Nʉʉrʉ ʉkʉgamba kwazʉ koreerekenʼya kʉbha ʉrarwa Gariraaya!” ");
INSERT INTO ikz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peetero akatanga kwihiima bhʉkʉngʼu, akiirahɨra, “Nɨtamwɨzɨ ʉmʉʉtʉ wuyo!” Hayohayo, ekorokoome ɨkagamba. ");
INSERT INTO ikz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Neho Peetero akahiita amangʼana ganʉ Yɨɨsu aamubhuuriirɨ, “Ekorokoome ɨkɨɨrɨ kʉgamba, ʉrabha ʉnyangirɨ manga katatʉ.” Akʉmara, akahʉrʉka igʉtʉ, akatanga kʉrɨra kwi isʉngʉ ihaari. ");
INSERT INTO ikz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hanʉ bhwakɨɨrɨ, abhakʉrʉ bhʉʉsi bha abhakuhaani hamwɨmwɨ na abhakaruka bha Abhayaahudi bhakiisiriranʼya kʉbha bhamwitɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Akʉmara bhakamobhoha, bhakaja nawe kʉmʉkangati wi Ikiruumi wʉnʉ aarɨ arabhirikirwa Piraato. ");
INSERT INTO ikz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mmbe Yuuda, wʉnʉ aamwichurirɨ Yɨɨsu, hanʉ aarʉʉzɨ Yɨɨsu atiniirwɨ iitwɨ, akiiyigwa kɨbhɨ bhʉkʉngʼu. Akagega zimpirya zirya merongo ɨtatʉ na kʉzɨgarucha kʉbhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi. Akabhabhʉʉrɨra, “Nɨkʉrirɨ ʉbhʉbhɨ kʉmʉtʉʉra mʉmabhoko gaanyu ʉmʉʉtʉ wʉnʉ ataana bhʉbhɨ bhwʉbhwʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nawe ebho bhakabhuga, “Gayo garatutunʼyakɨ itwɨ? Nɨ‑nyaakʉ yaazʉ aumwene.” ");
INSERT INTO ikz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Neho Yuuda akataasha zimpirya ziyo mukisikʉ cha rihekaaru, akaja, akiingʼeeta. ");
INSERT INTO ikz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abhakʉrʉ bha abhakuhaani bhakatoora zimpirya ziyo, bhakabhuga, “Ni‑mugirʉ kʉsanja zimpirya ziyo na zimpirya za rihekaaru, kʉ kʉbha zirihirwɨ ku kwitɨra amasaahɨ gʉ ʉmʉʉtʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mmbe, bhakagambana na kuhitya kogega zimpirya ziyo na kʉgʉra ʉmʉgʉndʉ gwe ekesemo igʉrʉ wʉ ʉkʉbhɨɨka abhagini. ");
INSERT INTO ikz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Necho ʉmʉgʉndʉ guyo gukubhirikirwa Ʉmʉgʉndʉ gwa Amasaahɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Neho rɨkabha ringʼana rɨnʉ ʉmʉrʉʉtɨrɨri Yɨrɨmiya aandikirɨ, “Bhakagega zimpirya merongo ɨtatʉ, ubhuguri obhorebhe bhʉnʉ Abhiiziraɨri bhiisirirɨɨnʼyɨ igʉrʉ wabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bhakagʉra ʉmʉgʉndʉ gwe ekesemo, chɨmbu Ʉmʉkʉrʉ answajiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Neho Yɨɨsu akiimɨɨrɨra mʉbhʉtangɨ bhwʉ ʉmʉkangati wi Ikiruumi. Ʉmʉkangati wuyo akamubhuurya, “Awɨ naawɨ ʉmʉtɨmi wa Abhayaahudi?” Yɨɨsu akamʉgarukirya, “Awɨ ʉgambirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nawe hanʉ aagambirwɨ na abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi, ewe atabhagarukiiryɨ ryʉryʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Neho Piraato akamubhuurya, “Nangʉ, ʉtakwigwa gʉʉsi ganʉ bhakʉgamba igʉrʉ waazʉ?” ");
INSERT INTO ikz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nawe Yɨɨsu atagarukiiryɨ nʉʉrʉ ringʼana rɨmwɨ. Umwanangwa akarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Imyaka jʉsi ji isigukuru yɨ Ɨpasaka, umwanangwa wi Ikiruumi aarɨ ni isimʉka yu ukutigʉrʉkɨra omobhohwa wʉmwɨ wʉnʉ abhaatʉ bhɨɨndirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mmbe, ribhaga riyo, aareho omobhohwa wʉmwɨ wʉnʉ aarɨ arabhirikirwa Bharaabha. Omobhohwa wuyo akamenyekana bhʉkʉngʼu igʉrʉ wa amabhɨ ganʉ aarɨ arakora. ");
INSERT INTO ikz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hanʉ abhaatʉ bhiibhiringirɨ, Piraato akabhabhuurya, “Nɨ‑wɨɨwɨ wʉnʉ mukwenda nɨbhatazʉrɨrɨ gatɨ wa abhabhohwa bhabhɨrɨ bhanʉ? Bharaabha, hamwɨ Yɨɨsu wʉnʉ abhaatʉ bhakʉbhɨrɨkɨra Kiriisitʉ?” ");
INSERT INTO ikz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piraato akabhabhuuryabhu, kʉ kʉbha akamenya abhakʉrʉ bha Abhayaahudi bhakahira Yɨɨsu kwewe igʉrʉ we engʼeera yaabhʉbhu. ");
INSERT INTO ikz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mmbe, hanʉ Piraato iikɨɨrɨ kukitumbɨ chazɨ chɨ ɨtɨnɨrʉ, mʉkaazɨ akamʉtʉmɨra amangʼana, “Ʉtaaza komokorera ibhɨ ryʉryʉsi ʉmʉʉtʉ wuyo ataana bhʉbhɨ, kʉ kʉbha nɨnyaakirɨ bhʉkʉngʼu ubhutikʉ mokerooto igʉrʉ waazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nawe abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi bhakakorokomba abhaatʉ bhasabhɨ Piraato abhatazʉrɨrɨ Bharaabha na kʉtɨnɨra Yɨɨsu korereke iitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Piraato akabhabhuurya naatu, “Nɨ‑wɨɨwɨ wʉnʉ mukwenda nɨbhatazʉrɨrɨ gatɨ wa abhabhohwa bhabhɨrɨ bhanʉ?” Bhakamʉgarukirya, “Bharaabha!” ");
INSERT INTO ikz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piraato akabhabhuurya naatu, “Mmbe nekorebhwɨ Yɨɨsu wʉnʉ akubhirikirwa Kiriisitʉ?” Abhaatʉ bhʉʉsi bhakarɨgɨsa bharabhuga, “Mʉmʉbhambɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Piraato akabhabhuurya naatu, “Asariryɨkɨ?” Nawe ebho bhakoongera kʉrɨgɨsa bharabhuga, “Mʉmʉbhambɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hanʉ Piraato ʉbhʉʉrirɨ kʉbha atakʉtʉra kuchʉra amiisɨɨgi ga abhaatʉ bharya na kʉbha bhatangirɨ rirɨgɨ, akagega amanzi na kwisaabha amabhoko gaazɨ mʉbhʉtangɨ bhwabhʉ. Akakorabhu kwerecha kʉbha ataana isoro ryʉryʉsi. Neho akabhabhʉʉrɨra, “Inyɨ nɨtaana bhʉbhɨ bhwʉbhwʉsi ku uruku rwʉ ʉmʉʉtʉ wʉnʉ we eheene. Ringʼana rɨnʉ ni‑gʉrʉ waanyu imubheene!” ");
INSERT INTO ikz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abhaatʉ bhʉʉsi bhakamʉgarukirya, “Risaahɨ ryu uruku rwa Yɨɨsu rɨbhɨ igʉrʉ wɨɨtʉ na abhaana bhɨɨtʉ!” ");
INSERT INTO ikz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Akʉmara Piraato akatazʉra Bharaabha, na akaswaja abhasirikarɨ korereke bhateme Yɨɨsu ɨmɨzariti na kʉmʉbhamba kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Neho abhasirikarɨ bhu umwanangwa wi Ikiruumi bhakagega Yɨɨsu, bhakaja nawe mwikʉrʉ ryu umwanangwa. Bhakabhiringa riribhita ikʉrʉ rya abhasirikarɨ, bhakamwiruguura. ");
INSERT INTO ikz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakamuruusha zengebho zaazɨ, bhakamwibhohya ɨkanzʉ imbiriiri. ");
INSERT INTO ikz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bhakagisa ɨkɨrʉngʉ cha amahwa, bhakamwibhohya kumutwɨ na rikʉrɨ kokobhoko kwazɨ ku ubhuryʉ korereke arorekanɨ nchʉ ʉmʉtɨmi. Bhakahigama mʉbhʉtangɨ bhwazɨ, akʉmara bhakatanga komorega bharabhuga, “Morembe, ʉmʉtɨmi wa Abhayaahudi!” ");
INSERT INTO ikz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Akʉmara bhakamutwɨra amatɨ, bhakagega rikʉrɨ rirya bhakamotema naryʉ kumutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hanʉ abhasirikarɨ bhayo bhaamarirɨ kumusiihya, bhakamuruusha ɨkanzʉ yirya na kumwibhohya zengebho zaazɨ. Akʉmara, bhakaja nawe kʉmʉbhamba kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hanʉ bhaarɨ bhararwa mʉrʉbhɨri rwa Yɨrusarɨɨmu, bhakabhona ʉmʉʉtʉ wʉmwɨ Mukireene, wʉnʉ akubhirikirwa Simʉʉni. Abhasirikarɨ bhayo bhakamʉhatɨka kogega ʉmʉsarabha gwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Akʉmara, bhakahika ahagero hanʉ haabhirikiirwɨ Gʉrigʉʉta, enzobhooro yaku nɨ‑kʉKɨhanga chu Umutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bhakaha Yɨɨsu idivaayi yɨnʉ bhaarɨ bhasangiryɨ nɨ ɨndʉrʉ. Nawe hanʉ aabhʉnjiryɨ, akaanga kunywa. ");
INSERT INTO ikz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bhakamʉbhamba kʉmʉsarabha, akʉmara bhakatwana zengebho zaazɨ kwa kokora ubhwitʉʉri. Neho rɨkabha ringʼana rɨnʉ ryagambirwɨ nʉ ʉmʉrʉʉtɨrɨri igʉrʉ wa Yɨɨsu kʉbha “Bhakatwana zengebho zaanɨ na bhakakora ubhwitʉʉri igʉrʉ wa amiibhoho gaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bhakiikara hayo korereke bhamuriibhɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bhakatʉʉra ʉrʉbhao igʉrʉ wu umutwɨ gwazɨ. Ʉrʉbhao ruyo rwarɨ rwandikirwɨ amangʼana gʉ ʉkʉmʉgamba kʉbha, “Wʉnʉ nɨ‑Yɨɨsu, Ʉmʉtɨmi wa Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ahagero hayo, bhaareho abhasaakuri bhabhɨrɨ, bhakabhambwa hamwɨmwɨ na Yɨɨsu, ʉwʉmwɨ ʉrʉbhaara rwu ubhuryʉ nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abhaatʉ bhanʉ bhaarɨ bhakʉhɨta kʉnzɨra hayo, bhakamʉtʉka, bharasingisha imitwɨ jabhʉ bharabhuga, ");
INSERT INTO ikz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nangʉ, ʉtarɨ naawɨ wabhugirɨ ʉraasha rihekaaru rya Mungu na kuryʉmbaka kwa sikʉ isatʉ? Nangʉ, arɨɨbhɨ awɨ ni‑Mwana wa Mungu, wiituuryɨ aumwene, wiikɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɨbhuɨbhu, abhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ ja Musa hamwɨmwɨ na abhakaruka bha Abhayaahudi bhakamorega bharabhuga, “Akasabhʉra abhandɨ, nawe atakʉtʉra kwisabhʉra umwene! ");
INSERT INTO ikz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Arɨɨbhɨ nɨ‑mʉtɨmi wa Abhiiziraɨri, mmbe iikɨ kʉmʉsarabha, neho na niitwɨ tukumwisirirya. ");
INSERT INTO ikz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ewe aramwisega Mungu, na abhugirɨ, ‘Inyɨ ni‑Mwana wa Mungu.’ Mmbe, nangʉ arɨɨbhɨ heene Mungu amʉsɨɨgirɨ, amʉsabhʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abhasaakuri bhanʉ bhaabhambirwɨ hamwɨmwɨ nawe, bhʉʉsi bhakamʉtʉka. ");
INSERT INTO ikz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mmbe, kwɨma ribhaga rya zɨɨsa isaasabha umwise kuhika zɨɨsa kenda, ɨkabha ikiirimya kucharʉ chʉsi. ");
INSERT INTO ikz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Zɨɨsa kenda, Yɨɨsu akarɨra kwiraka ikʉrʉ arabhuga, “Ɨrʉʉyi, Ɨrʉʉyi! Raama sabhakitaani?” Enzobhooro yaku, “Mungu waanɨ, Mungu waanɨ! Ndora untigirɨ?” ");
INSERT INTO ikz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hanʉ abhaatʉ bhanʉ bhaarɨ hayo bhiigwirɨ amangʼana gayo, abhandɨ bhakabhuga, “Wʉnʉ arabhɨrɨkɨra Ɨɨriya ʉmʉrʉʉtɨrɨri wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hayohayo, wʉmwɨ waabhʉ akaryara mwega, akagega ripuupya, akakorya mʉmarwa amarʉrʉ gi idivaayi, akatʉʉra ripuupya kwikʉrɨ, akamoha Yɨɨsu anywɨ. ");
INSERT INTO ikz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nawe abhandɨ bhakabhuga, “Tiga torore arɨɨbhɨ Ɨɨriya araaza kʉmʉsabhʉra!” ");
INSERT INTO ikz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Neho Yɨɨsu akarɨra kwikɨ kwiraka ikʉrʉ, akatinʼya. ");
INSERT INTO ikz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hayohayo, ripaziya ryu ukusikɨra Aharɨndu ha Aharɨndu mwihekaaru rɨkabhaarʉka mbaara ibhɨrɨ kurwa igʉrʉ kuhika iyaasɨ. Ɨɨsɨ ɨkarigita, zikurungutarɨ zɨkabhaarʉka. ");
INSERT INTO ikz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Zimbihɨra zikiigʉka nɨ ɨmɨbhɨrɨ myaru ja abharɨndu bha Mungu gɨkaryʉka. ");
INSERT INTO ikz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hanʉ Yɨɨsu aaryukirɨ bhakarwa muzimbihɨra zaabhʉ, bhakasikɨra Yɨrusarɨɨmu, bhakarorwa na abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hanʉ ʉmʉkʉrʉ wa abhasirikarɨ hamwɨmwɨ na bhanʉ bhaarɨ bhakuriibha Yɨɨsu bhaarʉʉzɨ ikirigitʉ chɨ ɨɨsɨ na agandɨ gʉʉsi ganʉ gakʉriibhwɨ, bhakʉʉbhaha bhʉkʉngʼu, bhakabhuga, “Heene, ʉmʉʉtʉ wʉnʉ aarɨ Umwana wa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hayo bhaareho na abhakari bhaaru bhanʉ bhaarɨ bhakutuna Yɨɨsu kurwa Gariraaya na komohokerya. Abhakari bhayo bhiimiiriirɨ kwa kore bhararora gʉʉsi ganʉ gaarɨ gakokorebhwa. ");
INSERT INTO ikz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mʉbhakari bhayo, bhaarɨmu Mariyamu wa Magidarena, Mariyamu unina Yaakobho na Yuusufu, na unina wa abhaana bha Zebhedaayo. ");
INSERT INTO ikz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hanʉ ryahikirɨ rigoroobha, akaaza umwɨga wʉmwɨ wa Yɨɨsu iriina ryazɨ Yuusufu. Yuusufu wuyo aarɨ muniibhi kurwa ʉrʉbhɨri rwa Arimataaya. ");
INSERT INTO ikz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yuusufu akaja kwa Piraato, akamʉsabha ɨkɨtʉndʉ cha Yɨɨsu. Piraato akaswaja abhasirikarɨ bhaazɨ bhamohe ɨkɨtʉndʉ kiyo. ");
INSERT INTO ikz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Akaja, akagega ɨkɨtʉndʉ, akakiringɨra mʉsanda. ");
INSERT INTO ikz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Akatʉʉra ɨkɨtʉndʉ mumbihɨra yaazɨ iihya ya ribhigi rɨnʉ ryarɨ ritukirwɨ kwitarɨ. Akʉmara akahiringitya riibhwɨ ikʉrʉ akakundikirya ikisikʉ chi imbihɨra, akarweho. ");
INSERT INTO ikz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ribhaga riyo, Mariyamu wa Magidarena na Mariyamu ʉwʉndɨ wurya, bhaarɨ bhiikɨɨrɨ bhɨɨrɨkɨɨrɨ imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Urusikʉ rwa kabhɨrɨ, rʉnʉ rwarɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ, abhakʉrʉ bha abhakuhaani na Abhafarisaayo bhakiibhiringa kwa Piraato. ");
INSERT INTO ikz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bhakabhʉʉrɨra Piraato, “Ʉmʉkʉrʉ, tʉrahiita kʉbha hanʉ ʉmʉbhɨɨhi wurya aarɨ akɨɨrɨ mʉhʉru, akabhuga, ‘Urusikʉ rwa katatʉ, nɨraryʉka.’ ");
INSERT INTO ikz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nangʉ tʉrasabha ʉbhatʉmɨ abhasirikarɨ bhariibhɨ imbihɨra kuhika urusikʉ rwa katatʉ. Arɨɨbhɨ ʉtakʉtʉʉra abhariibhi, abhɨɨga bhaazɨ bharatʉra bhakaaza kwibha ɨkɨtʉndʉ chazɨ na kʉkangirirya abhaatʉ kʉbha aryukirɨ kurwa mʉbhaku. Bharaakorebhu, ʉrʉrɨmɨ ruyo rʉrabha rʉbhɨ bhʉkʉngʼu kʉkɨra rʉnʉ rwakangatirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Piraato akabhagarukirya, “Mogege abhasirikarɨ, mujɨ muriibhɨ kwa amanaga gaanyu gʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Neho bhakaja kumbihɨra, bhakatʉʉra ʉrʉkaamʉ kwibhwɨ, korereke rihiringitibhwɨ, bhamenye. Bhakabhatiga abhasirikarɨ hayo korereke bhariibhɨ imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hanʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ rwahitirɨ, mʉmacha urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma, Mariyamu wa Magidarena hamwɨmwɨ na Mariyamu ʉwʉndɨ wurya, bhakaja korora imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rogendo rʉmwɨ, kɨkabhaho ikirigitʉ kɨkʉrʉ chɨ ɨɨsɨ, kʉ kʉbha maraika wʉ Ʉmʉkʉrʉ Mungu akiika kurwa mwisaarʉ. Maraika wuyo akiisuka kumbihɨra, akahiringitya riibhwɨ rirya rusizʉ, akaryikarɨra. ");
INSERT INTO ikz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aarɨ arabharya nchʉ ʉrʉkʉbha, na zengebho zaazɨ zaarɨ nzɨrʉ pee ncho omosoke. ");
INSERT INTO ikz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hanʉ abhasirikarɨ bharya bhaarʉʉzɨ gayo, bhakʉʉbhaha bhʉkʉngʼu, bhakabha nkina bhakuurɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hayo, maraika wuyo akabhʉʉrɨra abhakari bharya, “Mʉtʉʉbhaha! Nɨɨzɨ mʉramohya Yɨɨsu wa Nazarɨɨti, wʉnʉ aabhambirwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Atarɨ hanʉ! Aryukirɨ, chɨmbu aabhugirɨ. Muuzɨ morore hanʉ bhaarɨ bhamʉtɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mujɨ bhwangʉ, mʉbhabhʉʉrɨrɨ abhɨɨga bhaazɨ, ‘Aryukirɨ kurwa kʉbhaku, na arabhakangatɨra kuja mucharʉ cha Gariraaya. Iyo nɨyu mokomobhona!’ Nangʉ nɨmarirɨ kʉbhabhʉʉrɨra kɨnʉ charɨ kɨndɨɨtirɨ!” ");
INSERT INTO ikz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Neho abhakari bhayo bhakabhʉʉka bhwangʉ kurwa mumbihɨra hayo, bhanu ubhwʉbha no obhozomerwa bhʉkʉrʉ. Bhakaryara kuja kʉbhabhʉʉrɨra abhɨɨga ganʉ maraika aabhabhuuriirɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mmbe, hanʉ bhaarɨ bharaja, Yɨɨsu akarumana nabhʉ, akabhakeerya, “Morembe!” Bhakamwisukɨra, bhakamugwata amagʉrʉ gaazɨ, bhakamosengera. ");
INSERT INTO ikz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Neho Yɨɨsu akabhabhʉʉrɨra, “Mʉtʉʉbhaha. Mujɨ mʉbhabhʉʉrɨrɨ abhahiiri bhaanɨ bhajɨ Gariraaya, iyo nɨyu bharaambone.” ");
INSERT INTO ikz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hanʉ abhakari bhayo bhaarɨ bhakuja, abhasirikarɨ obhorebhe abhariibhi bhi imbihɨra ya Yɨɨsu bhakaja mʉrʉbhɨri rwa Yɨrusarɨɨmu. Hanʉ bhaahikirɨ, bhakaragɨrɨra abhakʉrʉ bha abhakuhaani gʉʉsi ganʉ gaakʉriibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Akʉmara abhakʉrʉ bha abhakuhaani bhayo bhakarumana na abhakaruka bha Abhayaahudi, bhakagambana na kuhitya kʉbhaha abhasirikarɨ bharyɨ amasooya ga zimpirya nzaru. ");
INSERT INTO ikz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bhakabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉwʉʉsi araabhabhuuryɨ igʉrʉ wa ganʉ gakʉrirwɨ, mubhugɨ, ‘Ubhutikʉ twarɨ tuhindiirɨ zendooro, abhɨɨga bhakaaza bhakamwibha.’ ");
INSERT INTO ikz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hanʉ Piraato ariigwɨ gayo, itwɨ tʉragambana nawe korereke mʉtaaza kusikɨra mʉnyaakʉ.” ");
INSERT INTO ikz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mmbe abhasirikarɨ bhakagega zimpirya na bhakakora chɨmbu bhaabhuuriirwɨ na abhakʉrʉ bha Abhayaahudi. Amangʼana gaabhʉ gʉ ʉrʉrɨmɨ gakanyaragana bhʉkʉngʼu gatɨ wa Abhayaahudi kuhika reero yɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abhɨɨga bha Yɨɨsu ikumi na wʉmwɨ bhakaja Gariraaya mʉkɨgʉrʉ kɨnʉ Yɨɨsu aabhɨɨrɨkiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hanʉ bhaamʉrʉʉzɨ, bhakamosengera, nangabha abhandɨ bhaarɨ na amakɨbhwɨ kʉbha nɨ‑Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yɨɨsu akabhiisukɨra, akabhabhʉʉrɨra, “Nɨhɨɨrwɨ ʉbhʉnaja bhwʉsi bhwa mwisaarʉ na mʉʉsɨ. ");
INSERT INTO ikz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nangʉ mujɨ kʉbhaatʉ bhi ibhyarʉ bhyʉsi na kʉbhakora kʉbha abhɨɨga bhaanɨ. Mʉbhabhatiizɨ kuriina rya Bhaabha, na ryu Umwana na rye Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mubhiijɨ kugwata gʉʉsi ganʉ nabhaswajiryɨ imwɨ. Rora, na niinyɨ nɨrɨ hamwɨmwɨ na niimwɨ ribhaga ryʉsi, kuhika mʉtɨnɨrʉ yɨ ɨɨsɨ.”");
INSERT INTO ikz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bhʉnʉ nebhwe ʉbhʉtangɨ bhwɨ Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu Kiriisitʉ, Umwana wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chɨmbu yandikirwɨ nʉ ʉmʉrʉʉtɨrɨri Isaaya mʉkɨtabhʉ chazɨ kʉbha, Mungu akabhuga, “Rora, nɨratʉma umutumwa waanɨ mʉbhʉtangɨ bhwazʉ, wʉnʉ araakokonzere ɨnzɨra. ");
INSERT INTO ikz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Umutumwa wʉnʉ nɨ‑wʉnʉ akʉraganʼya mwitɨrɨgʉ, ‘Mokore ɨnzɨra yʉ Ʉmʉkʉrʉ, mogorore ɨbhɨhɨtʉ bhyazɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Umutumwa wuyo aarɨ arabhirikirwa Yoohana. Aarɨ mwitɨrɨgʉ ararwazɨra abhaatʉ kʉbha, bhatigɨ ʉbhʉbhɨ nʉ ʉkʉbhatiizwa, korereke Mungu abhabheerere ʉbhʉbhɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abhaatʉ bhaaru kurwa kʉrʉbhɨri rwa Yɨrusarɨɨmu na mucharʉ chʉsi cha Yudeya, bhaarɨ bharaja kwa Yoohana. Bhakatiga ʉbhʉbhɨ bhwabhʉ, akabhabhatiiza mʉkɨtaarʉ cha Yorodaani. ");
INSERT INTO ikz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoohana aarɨ ibhʉhirɨ ʉbhʉzʉʉkɨ bhwɨ ɨngamiya, no omokena gwa riseero mukiribhizi. Ibhyakurya bhyazɨ bhyarɨ zingigɨ nu ubhwʉkɨ bhwa mwitɨrɨgʉ. ");
INSERT INTO ikz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aarɨ ararwaza arabhuga, “Hanʉ nɨkʉmara inyɨ, araaza ʉmʉʉtʉ wʉ ʉbhʉnaja kʉnkɨra. Nɨtakwenderwa nʉʉrʉ kwihiinya kʉtazʉra zisiri zi ibhikwɨra bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inyɨ nɨrabhabhatiiza kwa amanzi, nawe ewe arabhabhatiiza kwe Ekoro Ɨndɨndu.” ");
INSERT INTO ikz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ribhaga riyo, Yɨɨsu akaaza kurwa mʉrʉbhɨri rwa Nazarɨɨti, mucharʉ cha Gariraaya. Wʉʉsi Yoohana akamʉbhatiiza mʉkɨtaarʉ cha Yorodaani. ");
INSERT INTO ikz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hanʉ Yɨɨsu aarɨ aratiira kurwa mʉmanzi, akarora risaarʉ ririigʉka, ne Ekoro Ɨndɨndu iriika kwewe nchi ikiguuti. ");
INSERT INTO ikz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Riraka kurwa mwisaarʉ rɨkabhuga, “Awɨ ni‑Mwana waanɨ ʉmʉsɨɨgwa, nɨzʉmɨrɨɨrwɨ na naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hayohayo Ekoro Ɨndɨndu ɨkamʉkangata Yɨɨsu kuja mwitɨrɨgʉ. ");
INSERT INTO ikz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akiikara iyo sikʉ merongo ene, aragemwa na Shɨtaani. Aarɨ hamwɨmwɨ ni ibhityɨnyi bhya mwitɨrɨgʉ, na bhamaraika bha Mungu bhaarɨ bharamwangarɨra. ");
INSERT INTO ikz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Zɨkahɨta sikʉ nzaru, Yoohana akabhohwa. Hanʉ aarɨ mokebhoho, Yɨɨsu akaja mucharʉ cha Gariraaya, aarɨ ararwaza Ɨngʼana Ɨnzʉmu ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aarɨ arabhuga, “Ribhaga rɨnʉ ryarʉʉtʉrɨɨrwɨ rihikirɨ, nʉ ʉbhʉtɨmi bhwa Mungu bhʉraariirɨ. Mmbe, mutigɨ ʉbhʉbhɨ bhwanyu, mwisiriryɨ Ɨngʼana Ɨnzʉmu yiyo.” ");
INSERT INTO ikz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Rusikʉ rʉmwɨ, hanʉ Yɨɨsu aarɨ akʉhɨta rusizʉ wɨ ɨnyanza ya Gariraaya, akarora Simʉʉni nu umunyi waazɨ Andureya. Bhaarɨ bhararekera zenzero mʉnyanza, kʉ kʉbha bhaarɨ abhawɨsɨni. ");
INSERT INTO ikz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yɨɨsu akabhabhʉʉrɨra, “Muntunɨ na niinyɨ nɨrabhakora kʉbha abhawɨsɨni bha abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hayohayo, bhakazitiga zenzero zaabhʉ, bhakatuna Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yɨɨsu akaja embere hamwɨmwɨ na abhɨɨga bhaazɨ bhabhɨrɨ. Akarora Yaakobho nu umunyi waazɨ Yoohana abhaana bha Zebhedaayo, bhaarɨ mubhwatʉ bharazomya zenzero zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ribhaga riyoriyo, akabhabhɨrɨkɨra bhamutunɨ, bhabhɨ abhɨɨga bhaazɨ. Bhakatiga wiisɨ hamwɨmwɨ na abhahocha bhaazɨ mubhwatʉ, bhakatuna Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Neho Yɨɨsu na abhɨɨga bhaazɨ bhane, bhakaja mʉrʉbhɨri rwa Kapɨrinaumu. Hanʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ rwahikirɨ, bhakasikɨra mwirwazɨrʉ, Yɨɨsu akatanga kwija. ");
INSERT INTO ikz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Amiija gaazɨ gakabharuguurya abhaatʉ bhʉʉsi bhanʉ bhaarɨ bharamwitegeerera. Aarɨ ariija nchʉ ʉmʉʉtʉ wʉ ʉbhʉnaja, na ɨtaarɨ chɨmbu abhiija bhaabhʉ bhi imigirʉ ja Musa bhahiija. ");
INSERT INTO ikz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mwirwazɨrʉ ryabhʉ, mwarɨ nʉ ʉmʉʉtʉ wʉnʉ aarɨ na risambwa. Akatiirya riraka, ");
INSERT INTO ikz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","arabhuga, “Awɨ Yɨɨsu wa Nazarɨɨti, ʉtatʉnyaacha! Nangʉ, wiizirɨ kuturicha? Nikwɨzɨ awɨ nɨ‑wɨɨwɨ, awɨ nɨ‑Mʉrɨndu wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yɨɨsu akarɨhaarɨra risambwa riyo akabhuga, “Kira! Nuurwɨ kʉmʉʉtʉ wʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Risambwa rɨkasingisha ʉmʉʉtʉ wuyo bhʉkʉngʼu, rɨkarɨra kwiraka na kumurwɨku. ");
INSERT INTO ikz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abhaatʉ bhʉʉsi bhakarʉgʉʉra bhʉkʉngʼu, bhakiibhuurya, “Nɨ‑kɨ kɨnʉ? Ni‑miija mahya, ganʉ ʉbhʉnaja! Rora, ana amanaga gʉ ʉkʉhaarɨra na amasambwa, gʉʉsi garamwigwa.” ");
INSERT INTO ikz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɨtaagɨgirɨ ibhaga irɨɨhu, abhaatʉ kurwa mucharʉ chʉsi cha Gariraaya, bhakabha bhiigwirɨ amangʼana ga Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Hanʉ bhaaruurɨ mwirwazɨrʉ, bhakaja hamwɨmwɨ na Yaakobho na Yoohana kuhika wa Simʉʉni na Andureya. ");
INSERT INTO ikz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hanʉ bhaahikirɨbhu, Yɨɨsu akabhuurirwa kʉbha, uninabhyara Simʉʉni ari munyumba ahindiirɨ, murwɨrɨ we ehooma. ");
INSERT INTO ikz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Neho Yɨɨsu akiisuka hanʉ aarɨ, akamugwata okobhoko, akamʉnʉnga. Ribhaga riyoriyo uninabhyara Simʉʉni akahora, akatanga kʉbhahokerya ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Urusikʉ ruyo rigoroobha, hanʉ ʉbhʉtʉʉrʉ bhwasirirɨ, abhaatʉ bhʉ ʉrʉbhɨri ruyo bhaarɨ bharareetera Yɨɨsu abharwɨrɨ, na bhanʉ bhaarɨ na amasambwa. ");
INSERT INTO ikz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Abhaatʉ bhaaru kurwa mʉrʉbhɨri rurya, bhakarumana kʉrʉkʉngʉ rwi inyumba ya Simʉʉni na Andureya. ");
INSERT INTO ikz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yɨɨsu akahorya abhaatʉ bhaaru bhanʉ bhaarɨ na amarwɨrɨ gʉgʉʉsi. Na akaruusha amasambwa maaru, nawe ataarɨ aragatiga amasambwa kʉbha gagambɨ, kʉ kʉbha gakamenya kʉbha ewe ni‑Mwana wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mozengoko, Yɨɨsu akabhʉʉka, akaja ahagero hanʉ hataarɨ na abhaatʉ, akatanga kʉsabha. ");
INSERT INTO ikz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hanʉ Simʉʉni na abhakɨndichazɨ bhaabhwɨnɨ atarɨ munyumba, bhakaja komomohya. ");
INSERT INTO ikz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hanʉ bhaamubhwɨnɨ, bhakamʉbhʉʉrɨra, “Abhaatʉ bhʉʉsi bharakomohya!” ");
INSERT INTO ikz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Akabhagarukirya, “Tujɨ mʉzɨmbɨri ɨzɨndɨ za haguhɨ na rʉnʉ, korereke nirwazɨyʉ, kʉ kʉbha niizirɨ komeremo giyo.” ");
INSERT INTO ikz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Neho akahɨta mucharʉ chʉsi cha Gariraaya na kurwaza mʉmarwazɨrʉ gaabhʉ, na kuruusha abhaatʉ amasambwa. ");
INSERT INTO ikz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Rusikʉ rʉmwɨ ʉmʉʉtʉ we ebhegenge akaja kwa Yɨɨsu. Akahigama, akamwisasaama, “Ʉraasɨɨgɨ, ʉratʉra kʉmbɨngukya!” ");
INSERT INTO ikz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yɨɨsu akamororera ɨbhɨgʉngi, akagorora okobhoko kwazɨ na kumukunʼyaku umurwɨrɨ, akamʉbhʉʉrɨra akabhuga, “Nɨsɨɨgirɨ. Bhɨngukibhwa!” ");
INSERT INTO ikz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rogendo rʉmwɨ ebhegenge bhɨkamurwɨku, akabhɨngʉka. ");
INSERT INTO ikz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yɨɨsu akamorecha kwa kumuruushaho bhwangʉ, ");
INSERT INTO ikz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","akamʉbhʉʉrɨra, “Ʉtagema kʉbhʉʉrɨra mʉʉtʉ ingʼana ryʉryʉsi. Nawe, nuujɨ wiiyeerekenʼye kwa kuhaani, na uhuruchɨ ikimweso chʉ ʉkʉbhɨngukibhwa kwazʉ, chɨmbu Musa aaswajiryɨ, kwerecha abhaatʉ kʉbha ʉbhɨngukiibhwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nawe, ʉmʉʉtʉ wurya akabhʉʉka harya, akatanga kʉraarɨka habhwɨrʉ ringʼana ryʉ ʉkʉhʉribhwa kwazɨ. Igʉrʉ wa gayo, Yɨɨsu akatamwa kusikɨra habhwɨrʉ mʉzɨmbɨri zʉzʉʉsi zirya. Akiikara umwene hagarɨ igʉtʉ wa zɨmbɨri, nʉʉrʉbhu abhaatʉ kurwa mbaara zʉʉsi bhaarɨ bharamujaku. ");
INSERT INTO ikz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yɨɨsu akagarʉka naatu Kapɨrinaumu. Zɨkahɨta sikʉ suuhu, abhaatʉ bhakiigwa kʉbha arɨ yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bhakiibhiringa bhaaru munyumba murya, kuhika kukisikʉ hataarɨ na hakʉhɨta. Yɨɨsu aarɨ arabharwazɨra abhaatʉ ɨngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hanʉ aarɨ ararwaza, bhakaaza abhaatʉ bhane, bhagɨgirɨ ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ kʉkɨragʉ. ");
INSERT INTO ikz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bhakatamwa kumusikirya hanʉ Yɨɨsu aarɨ, kʉ kʉbha ya riribhita ikʉrʉ. Bhakatiira kwirengo ryi inyumba, bhakahobhora rirengo igʉrʉ wa hanʉ Yɨɨsu aarɨ, bhakiicha ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ arɨ kʉkɨragʉ. ");
INSERT INTO ikz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hanʉ Yɨɨsu aarʉʉzɨ ubhwisirirya bhwabhʉ, akabhʉʉrɨra ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ, “Mwana waanɨ, ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nawe, bhakiikara hayo abhiija obhorebhe bhi imigirʉ ja Musa. Bhaarɨ bhariiseega mumyʉyʉ jabhʉ, ");
INSERT INTO ikz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ndora ʉmʉʉtʉ wʉnʉ aragambabhu? Ararega Mungu! Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kobheerera ʉbhʉbhɨ, nawe Mungu umwene!” ");
INSERT INTO ikz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Rogendo rʉmwɨ Yɨɨsu akamenya amiisɨɨgi gaabhʉ, akabhabhʉʉrɨra, “Kwakɨ muriiseegabhu mumyʉyʉ janyu? ");
INSERT INTO ikz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Awɨɨ, ni‑ryahe rinyʉʉhu, kʉbhʉʉrɨra ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ, ‘Ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ,’ kisha kʉmʉbhʉʉrɨra, ‘Imɨɨrɨra, ogege ɨkɨragʉ chazʉ ujɨ’? ");
INSERT INTO ikz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nangʉ nereenda momenye kʉbha, Umwana wʉ Ʉmʉʉtʉ ahɨɨrwɨ ʉbhʉnaja bhwo okobheerera abhaatʉ ʉbhʉbhɨ kʉʉsɨ.” Neho Yɨɨsu akabhʉʉrɨra ʉmʉʉtʉ wʉnʉ akuurɨ ibhiimʉ, ");
INSERT INTO ikz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nɨrakʉbhʉʉrɨra, imɨɨrɨra! Gega ɨkɨragʉ chazʉ, ujɨ yɨɨka.” ");
INSERT INTO ikz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hayohayo, bhʉʉsi bhakarora ʉmʉʉtʉ wuyo akiimɨɨrɨra, akiitwɨka ɨkɨragʉ chazɨ, akahʉrʉka igʉtʉ. Abhaatʉ bhayo bhakarʉgʉʉra na kʉgʉnga Mungu, bhakabhuga, “Tʉkɨɨrɨ korora kɨsɨgʉ ncha kɨnʉ kɨkʉrirwɨ reero!” ");
INSERT INTO ikz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yɨɨsu akaja naatu rusizʉ wɨ ɨnyanza ya Gariraaya. Abhaatʉ bhaaru bhakamutuna, akabhiija. ");
INSERT INTO ikz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Akʉmara akabhʉʉka, hanʉ aarɨ araja, akarora Raawi umwana wa Arifaayʉ. Aarɨ ikɨɨrɨ mwibhuru ryazɨ ryʉ ʉkʉtɨnɨra rigʉʉti. Yɨɨsu akamʉbhʉʉrɨra, “Ntuna.” Raawi akabhʉʉka, akamutuna. ");
INSERT INTO ikz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yɨɨsu akaja kurya ibhyakurya munyumba ya Raawi hamwɨmwɨ na abhɨɨga bhaazɨ. Abharihya bha rigʉʉti na abhandɨ bhʉ ʉbhʉbhɨ bhaarɨ bhararya ibhyakurya hamwɨmwɨ nabhʉ, kʉ kʉbha bhaaru bhe eteemwa yɨnʉ bhaarɨ bharamutuna. ");
INSERT INTO ikz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mmbe abhiija bhi imigirʉ bhanʉ bhaarɨ Abhafarisaayo, hanʉ bhaarʉʉzɨ Yɨɨsu ararya hamwɨmwɨ na abharihya bha rigʉʉti na abhakʉri bhʉ ʉbhʉbhɨ, bhakabhuurya abhɨɨga bhaazɨ, “Ndora ararya hamwɨmwɨ na abharihya bha rigʉʉti na abhakʉri bhʉ ʉbhʉbhɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hanʉ Yɨɨsu iigwirɨbhu, akabhabhʉʉrɨra, “Abhaatʉ abhahʉru bhatakwenda ʉmʉgabhʉ, nawe abharwɨrɨ nebho bhakumwenda! Inyɨ nitiizirɨ kʉbhɨrɨkɨra bhe eheene, nawe bhʉ ʉbhʉbhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ibhaga irebhe, abhɨɨga bha Yoohana Ʉmʉbhatiizi hamwɨmwɨ na Abhafarisaayo, bhaarɨ bhariiyima kurya. Rusikʉ rʉmwɨ abhaatʉ obhorebhe bhakaja kwa Yɨɨsu, bhakabhuurya, “Ndora abhɨɨga bha Yoohana na abhɨɨga bha Abhafarisaayo bhatakurya, nawe abhɨɨga bhaazʉ bhatakwiyima kurya?” ");
INSERT INTO ikz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yɨɨsu akagarukirya, “Abhahɨrɨɨkɨrɨri bhu umukwɨri bhariiyimabhwɨ kurya, bharɨ hamwɨmwɨ nu umukwɨri? Ribhaga ryʉsi bharɨ hamwɨmwɨ, bhatakʉtʉra kwiyima kurya! ");
INSERT INTO ikz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nawe urusikʉ rʉraaza umukwɨri araruusibhwa gatɨ wa abhagini bhaazɨ. Hayo neho, bhariiyimɨ kurya. ");
INSERT INTO ikz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ʉkʉsanja amiija gaanɨ amahya na zisimʉka zaanyu kʉratuubhana nʉ ʉkʉtʉʉra ɨkɨraka che engebho iihya kongebho ikungu. Ɨkɨraka kirya kɨranyarya engebho yiyo na kwongera hanʉ hanyarirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ekerenjo ɨkɨndɨ ni‑ncha abhaatʉ kutiga kʉtʉʉra idivaayi yɨnʉ ɨtatunduurirɨ mʉbhɨgʉzi bhya amaseero amakungu. Hanʉ ɨkʉtʉndʉʉra na kutiira, ɨkɨgʉzi kɨratamwa kubhimba, akʉmara kɨrabhaarʉka idivaayi iriitɨka. Idivaayi yɨnʉ ɨtatunduurirɨ ereenderwa kutuurwa mʉkɨgʉzi ikihya.” ");
INSERT INTO ikz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Rusikʉ rʉmwɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu na abhɨɨga bhaazɨ bhaarɨ bharahɨta kʉnzɨra yɨnʉ yaarɨ mʉmɨgʉndʉ jɨ ɨnganʉ. Abhɨɨga bhaazɨ bhakatanga kʉtɨna ɨbhɨgara bhyɨ ɨnganʉ na kurya. ");
INSERT INTO ikz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Neho Abhafarisaayo bhakabhʉʉrɨra Yɨɨsu, “Rora, abhɨɨga bhaazʉ bharahocha emeremo gɨnʉ gɨtakwenderwa kokorwa urusikʉ rwʉ ʉbhʉtʉʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yɨɨsu akabhagarukirya, “Mʉtasʉmirɨ mʉMaandɨkʉ Amarɨndu chɨmbu Daudi aakʉrirɨ hanʉ ɨnzara yamuriirɨ na abhakɨndichazɨ? ");
INSERT INTO ikz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Akasikɨra mwibhuru rirɨndu rya Mungu, ribhaga rɨnʉ Abhiyatari aarɨ kuhaani ʉmʉkʉrʉ wa Mungu, akarya ɨmɨkaatɨ gɨnʉ jatɨɨrwɨ mʉbhʉtangɨ bhwa Mungu. Ɨmɨkaatɨ gɨnʉ kumigirʉ ja Musa gɨtakwenderwa kuriibhwa na abhaatʉ, kuruushaku bhakuhaani abheene. Nawe Daudi akarya, na akabhaha na abhakɨndichazɨ, bhʉʉsi bhakarya.” ");
INSERT INTO ikz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Neho Yɨɨsu akabhabhʉʉrɨra, “Urusikʉ rwʉ ʉbhʉtʉʉrʉ rwatɨɨrwɨ igʉrʉ wa abhaatʉ, ɨtarɨ abhaatʉ igʉrʉ wʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na momenye kʉbha, Umwana wʉ Ʉmʉʉtʉ nɨ‑Mʉkʉrʉ nʉʉrʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Urusikʉ ʉrʉndɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu akasikɨra mwirwazɨrʉ rya Kapɨrinaumu, aareho ʉmʉʉtʉ wʉnʉ arɨmɨɨrɨ okobhoko. ");
INSERT INTO ikz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abhafarisaayo bhaarɨ bhiitɨgirɨ Yɨɨsu, bharore arɨɨbhɨ arahorya ʉmʉʉtʉ wuyo urusikʉ rwʉ ʉbhʉtʉʉrʉ. Areemohorye bhabhone ɨnzɨra yu ukumwinatiriryaku. ");
INSERT INTO ikz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yɨɨsu akabhʉʉrɨra omorema wo okobhoko, “Nauzɨ, wiimɨɨrɨrɨ gatɨgatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Neho Yɨɨsu akabhabhuurya, “Nangʉ, nɨ‑bhwaheene kurusikʉ rwʉ ʉbhʉtʉʉrʉ, kokora amazʉmu kisha kokora amabhɨ, kohorya kisha kwita?” Ebho bhakakira. ");
INSERT INTO ikz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yɨɨsu akabharora kʉbhʉrʉrʉ, akarumɨka mumwʉyʉ gwazɨ igʉrʉ wʉ ʉbhʉkʉngʼu bhwi imyʉyʉ jabhʉ. Neho Yɨɨsu akabhʉʉrɨra ʉmʉʉtʉ wurya, “Gorora okobhoko kwazʉ.” Ʉmʉʉtʉ wurya akagorora okobhoko kwazɨ, rogendo rʉmwɨ kʉkahora! ");
INSERT INTO ikz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hayohayo Abhafarisaayo bharya bhakahʉrʉka igʉtʉ, bhakarumana na kʉgambana na abhasakirya bha riribhita ryʉ ʉmʉtɨmi Heroode Antipaasi. Bhakagambana chɨmbu bharaarichɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yɨɨsu akabhʉʉka hayo, akaja kʉnyanza ya Gariraaya hamwɨmwɨ na abhɨɨga bhaazɨ. Riribhita ikʉrʉ rya abhaatʉ rɨkamutuna kurwa mubhyarʉ bhya Gariraaya na Yudeya, ");
INSERT INTO ikz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ʉrʉbhɨri rwa Yɨrusarɨɨmu, na Idumaaya, imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani na haguhɨ na zɨmbɨri za Tiiro na Sidʉʉni. Abhaatʉ bhayo bhakamujaku, kʉ kʉbha bhaarɨ bhiigwirɨ igʉrʉ wɨ ɨbhɨsɨgʉ bhɨnʉ aarɨ akʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ bhakonze ubhwatʉ, kʉ kʉbha riribhita rirya ryarɨ ikʉrʉ bhʉkʉngʼu, hanʉ rɨraamʉhɨgɨ asikɨrɨ mubhwatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Abharwɨrɨ bhaarɨ bharahɨgana korereke bhamukunʼyɨku, kʉ kʉbha aarɨ ahʉriryɨ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Abhaatʉ bhanʉ bhaarɨ na amasambwa hanʉ bhaamʉrʉʉzɨbhu, bhaarɨ bharagwa kʉmagʉrʉ gaazɨ na kʉrɨra kwiraka ɨkʉrʉ, “Awɨ ni‑Mwana wa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Neho akagarecha amasambwa kwa bhʉhaari, gatamukumucha kʉbhaatʉ kʉbha ewe nɨ‑wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yɨɨsu akatiira kʉkɨgʉrʉ. Akabhabhɨrɨkɨra abhaatʉ bhanʉ ɨɨndirɨ, bhakamujaku. ");
INSERT INTO ikz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akarobhora abhaatʉ ikumi na bhabhɨrɨ bhanʉ aabhabhirikiirɨ abhatumwa, korereke bhabhɨ hamwɨmwɨ nawe, abhatʉmɨ kurwaza, ");
INSERT INTO ikz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na abhahɨ ʉbhʉnaja bhwu ukuruusha amasambwa kʉbhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ganʉ nego amariina ga abhaatʉ ikumi na bhabhɨrɨ bhanʉ aarʉbhwɨrɨ: Simʉʉni, wʉnʉ Yɨɨsu aamʉhɨɨrɨ iriina ɨrɨndɨ, Peetero, ");
INSERT INTO ikz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaakobho na Yoohana abhaana bha Zebhedaayo, Yɨɨsu akabhaha iriina rya Bhowanɨrigɨ, enzobhooro yaku abhaana bhu umurumo, ");
INSERT INTO ikz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andureya, Firipʉ, Bhatoromayo, Mataayo, Tomaaso, Yaakobho umwana wa Arifaayʉ, Tadaayo, Simʉʉni Ʉmʉkananayʉ, enzobhooro yaku ni‑mwitaniri wi icharʉ chazɨ, ");
INSERT INTO ikz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuuda Isikariyʉʉti, wʉnʉ iichurirɨ Yɨɨsu. Akʉmara Yɨɨsu akagarʉka yɨɨka, akasikɨra munyumba. ");
INSERT INTO ikz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Riribhita rya abhaatʉ rikiibhiringa harya kwikɨ, kuhika Yɨɨsu na abhɨɨga bhaazɨ bhakatama nʉʉrʉ kurya ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hanʉ unina na abhahiiri bhaazɨ bhiigwirɨ amangʼana gayo, bhakaja komogega, bhaarɨ bharabhuga amangʼɨɨni gatarɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abhiija bhi imigirʉ ja Musa, bhanʉ bhaaruurɨ mʉrʉbhɨri rwa Yɨrusarɨɨmu bhaarɨ bharabhuga, “Atiirirwɨ na Bhɨɨrizɨbhuri. Araheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, ʉmʉkʉrʉ wa amasambwa!” ");
INSERT INTO ikz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mmbe, Yɨɨsu akabhabhɨrɨkɨra, akatanga kʉbhabhʉʉrɨra kobherenjo, “Shɨtaani aratʉrabhwɨ kwiruusha umwene? ");
INSERT INTO ikz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Arɨɨbhɨ abhaatʉ bhʉ ʉbhʉtɨmi bhʉmwɨ bhariitana abheene kobheene, ʉbhʉtɨmi bhuyo bhʉragwa. ");
INSERT INTO ikz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na abhaatʉ bhi inyumba yɨmwɨ arɨɨbhɨ bharatanga kwitana abheene kobheene, ikishoko kiyo kɨtakʉrama nʉʉrʉ hasuuhu. ");
INSERT INTO ikz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Arɨɨbhɨ Shɨtaani ariitana na amasambwa amakɨndichazɨ, ʉbhʉtɨmi bhwazɨ bhʉtwanɨkɨɨnɨ, bhʉratʉra kwimɨɨrɨrabhwɨ? Bhʉtakʉtʉra kwimɨɨrɨra nʉʉrʉ hasuuhu, maheene bhugwirɨ kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kusikɨra munyumba yʉ ʉmʉʉtʉ wa amanaga, na kumuruusha ebhegero bhyazɨ, akɨɨrɨ komobhoha. Areemobhohe, hayo aratʉra kumuruusha ebhegero bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nɨrabhabhʉʉrɨra amaheene, abhaatʉ bharabheererwa ʉbhʉbhɨ bhwabhʉ bhwʉsi. Na bharabheererwa ekerege chabhʉ chʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nawe, arɨɨbhɨ ʉmʉʉtʉ ararega Ekoro Ɨndɨndu, atakobheererwa nʉʉrʉ hasuuhu. Wuyo arabha ni isoro ryʉ ʉbhʉbhɨ bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yɨɨsu akabhabhʉʉrɨrabhu, kʉ kʉbha ebho bhaarɨ bharabhuga, “Ana risambwa.” ");
INSERT INTO ikz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Neho unina Yɨɨsu na abhahiiri bhaazɨ bhakahika, bhakiimɨɨrɨra igʉtʉ wi inyumba yɨnʉ aarɨmu. Bhakatʉma ʉmʉʉtʉ abhɨrɨkɨrɨ Yɨɨsu, bhagambanɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Riribhita ikʉrʉ rya abhaatʉ ryarɨ ryikɨɨrɨ, rimwinaarirɨ. Bhakamʉbhʉʉrɨra Yɨɨsu, “Rora, onyoko na bhaumwanyu bhari igʉtʉ, bharakwenda.” ");
INSERT INTO ikz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yɨɨsu akabhagarukirya, “Yiiya na bhaumwɨtʉ, nɨ‑bha wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akabharora abhaatʉ bhanʉ bhiikɨɨrɨ bhamwinaarirɨ, akabhuga, “Morore, bhanʉ nebho bha yiiya na bhaumwɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akokora ubhwɨndi bhwa Mungu, wuyo newe umwɨtʉ, umusubhaati na yiiya.” ");
INSERT INTO ikz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yɨɨsu akatanga kwija kwikɨ abhaatʉ, rusizʉ wɨ ɨnyanza. Riribhita ikʉrʉ rya abhaatʉ rikiibhiringa kwawɨ. Akasikɨra mubhwatʉ, akiikara muyo korereke bhatamurimbya. Abhaatʉ bhakasaaga rusizʉ wɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aarɨ arabhiija amangʼana maaru kobherenjo. Mumiija gaazɨ aarɨ arabhuga, ");
INSERT INTO ikz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mwitegeerere! Umubhusuri akaja kubhusura zimbusurʉ zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hanʉ aarɨ arabhusura, zimbusurʉ ɨzɨndɨ zɨkagwa kʉnzɨra, ibhinyunyi bhɨkaaza, bhɨkazirya. ");
INSERT INTO ikz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɨzɨndɨ zɨkagwa kukurungutarɨ, zɨkamera bhwangʉ, kʉ kʉbha rirobha ryarɨ isuuhu. ");
INSERT INTO ikz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hanʉ ʉmwɨ gwabharirɨ, gukuumya rirobha rirya, zimbusurʉ zɨkanyaara na kwʉma, kʉ kʉbha imiri jaku jarɨ igʉrʉgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zimbusurʉ ɨzɨndɨ zɨkagwa mʉmahwa. Amahwa gayo gakakʉra, gakazihiza, zɨkatama kokongʼa. ");
INSERT INTO ikz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nawe, zimbusurʉ ɨzɨndɨ zɨkagwa kwirobha rizʉmu, zɨkamera, zɨkakʉra na kwibhʉra. Yɨmwɨ ikiibhʉra merongo ɨtatʉ, ɨyɨndɨ ikiibhʉra merongo ɨsaasabha, nɨ ɨyɨndɨ ikiibhʉra igana rɨmwɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Akʉmara akabhabhʉʉrɨra, “Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hanʉ abhaatʉ bha riribhita bhaabhuukirɨ, Yɨɨsu akasaaga na abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, na abhahɨmba abhandɨ. Neho bhakabhuurya igʉrʉ we enzobhooro ye ebherenjo bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akabhagarukirya, “Imwɨ mubhwɨnɨ iryʉbha ryo okomenya imbisi yʉ ʉbhʉtɨmi bhwa Mungu. Nawe abhaatʉ bhanʉ bhatakuntuna, nɨrabhabhʉʉrɨra gʉʉsi kobherenjo, ");
INSERT INTO ikz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","korereke, ‘Bharaarore, bhatamenya ryʉryʉsi. Na bhariigwɨ, bhatoobhoora ryʉryʉsi. Bhataaza kwichʉra, bhakatiga ʉbhʉbhɨ, bhakabheererwa.’ ” ");
INSERT INTO ikz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Neho Yɨɨsu akabhuga, “Nangʉ, mʉtamirwɨ kwobhoora ekerenjo kɨnʉ, ɨrabhabhwɨ kʉbhɨndɨ? ");
INSERT INTO ikz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Umubhusuri nɨ‑wʉnʉ akoreetera abhandɨ ɨngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abhaatʉ abhandɨ bhatuubhɨɨnɨ na zimbusurʉ zɨnʉ zaagwirɨ kʉnzɨra. Hanʉ bhakwigwabhu ɨngʼana ya Mungu, Shɨtaani ahaaza, na kuruushaho ɨngʼana yirya mozekoro zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abhandɨ, bhatuubhɨɨnɨ na zimbusurʉ zɨnʉ zaagwirɨ kukurungutarɨ. Hanʉ bhakwigwa ɨngʼana ya Mungu, bharayɨsʉngʼaana bhwangʉ kobhozomerwa bhwʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nawe kʉ kʉbha bhaangɨ nchɨ ɨkɨtʉʉtʉ kɨnʉ kɨtaana imiri, bhahaagwata ibhaga isuuhu, zɨnyaakʉ hamwɨ amakʉngʼu garaabhabhone igʉrʉ wɨ ɨngʼana yiyo, hayohayo bharatiga ubhwisirirya. ");
INSERT INTO ikz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abhandɨ bhatuubhɨɨnɨ na zimbusurʉ zɨnʉ zaagwirɨ mʉmahwa. Bhariigwa ɨngʼana ya Mungu, ");
INSERT INTO ikz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nawe, amahocha ga kʉʉsɨ, umwʉyʉ gwu ubhuniibhi, nu umwʉyʉ gwa amangʼana agandɨ guriisikɨrɨ. Gayo gahaahɨga ɨngʼana ya Mungu na kugirya ɨtamɨ kwibhʉra imisumʉ. ");
INSERT INTO ikz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na abhandɨ bhatuubhɨɨnɨ na zimbusurʉ zɨnʉ zaagwirɨ kwirobha rizʉmu. Bhariigwa ɨngʼana ya Mungu na kʉyɨsʉngʼaana na kwibhʉra imisumʉ, ʉgʉmwɨ merongo ɨtatʉ, ʉgʉndɨ merongo ɨsaasabha nʉ ʉgʉndɨ igana rɨmwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na Yɨɨsu akabhabhʉʉrɨra, “Awɨɨ kʉnʉ ʉmʉʉtʉ wʉnʉ ahaacha ɨkɨmʉrɨ na kʉtʉʉra mwirungu ryʉ ʉbhʉrɨrɨ, hamwɨ kukundikirya na rihʉʉzʉ? Atahaatʉʉra igʉrʉ wɨ ɨkɨkʉngʉ kɨbhɨ kɨramʉrɨka hʉʉsi? ");
INSERT INTO ikz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ɨbhu nɨmbu ryʉryʉsi rɨnʉ ribhisirwɨ, ribhisirwɨ korereke rihumburwɨ na kʉbha habhwɨrʉ. Na ryʉryʉsi rɨnʉ rikundikiriibhwɨ, rikundikiriibhwɨ korereke rihumburwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Mwitegeerere bhwaheene! Muryamurya chɨmbu ukwihurucha kwitegeerera ringʼana, ɨbhu nɨmbu Mungu wʉʉsi akokoha ubhwʉbhʉʉri, na arakwongereererya koremenya bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wʉnʉ akwitegeerera ɨngʼana ya Mungu na koyemenya, Mungu aramʉsakirya na kumwongerya koyemenya. Nawe arɨɨbhɨ ʉmʉʉtʉ atakwitegeerera ɨngʼana ya Mungu, nʉʉrʉ isuuhu yɨnʉ amɨnyirɨ araruusibhwa.” ");
INSERT INTO ikz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yɨɨsu akoongera kʉbhabhʉʉrɨra, “Nɨbhabhʉʉrɨrɨ ekerenjo ɨkɨndɨ, korereke nibhiijɨ ʉbhʉtɨmi bhwa Mungu chɨmbu bhʉrɨ. Ʉmʉʉtʉ wʉmwɨ akahamba zendetere mʉmʉgʉndʉ. ");
INSERT INTO ikz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ubhutikʉ ahaahɨndɨra, nu umwise arɨ mɨɨsʉ, ribhaga riyo zendetere ziyo zɨramera na kʉkʉra, ɨnʉ umurimi atɨɨzɨ chɨmbu ɨkʉbha. ");
INSERT INTO ikz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Rirobha riyoriyo, rɨrakurya zendetere zirya na kwibhʉra. Hinga zɨrahurucha amatʉʉtʉ, garatanga kʉsagata, mʉtɨnɨrʉ zɨrahurucha ɨbhɨgara bhɨnʉ bhɨna zeeheke. ");
INSERT INTO ikz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Imisumʉ gɨraakongʼe na gɨrʉʉmɨ, umurimi aratanga kogesa.” ");
INSERT INTO ikz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Awɨɨ ʉbhʉtɨmi bhwa Mungu tubhutuubhanʼyɨ nakɨ? Tubhutuubhanʼyɨ na kerenjokɨ? ");
INSERT INTO ikz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bhutuubhɨɨnɨ chɨmbu endetere yʉ ʉmʉharadaari ɨrɨ hanʉ ɨkʉhambwa na kʉkʉra mʉmʉgʉndʉ. Neyo isuuhu kʉkɨra zendetere zʉʉsi zɨnʉ zɨhaahambwa. ");
INSERT INTO ikz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ɨraamere, ɨhaabha kɨtʉʉtʉ kɨkʉrʉ kʉkɨra ɨbhɨtʉʉtʉ bhyʉsi bhya zinyinyi mʉmʉgʉndʉ. Kɨrabha ni ibhisha bhya amatʉʉtʉ amakʉrʉ, ni ibhinyunyi bhɨhaaza na kwikara kubhisha bhyaku.” ");
INSERT INTO ikz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yɨɨsu akabharwazɨra ɨngʼana ya Mungu kwe ebherenjo bhiyo nɨ ɨbhɨndɨ bhyaru, chɨmbu bhanagiryɨ koyemenya. ");
INSERT INTO ikz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Atagambɨnɨ nebho ataana kerenjo. Nawe, hanʉ aarɨ umwene na abhɨɨga bhaazɨ, akabhagorera gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Urusikʉ ruyo rigoroobha, Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Twambʉkɨ ɨnyanza, tujɨ imwambʉkʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhakatiga riribhita rya abhaatʉ, bhakatiira mubhwatʉ mʉnʉ Yɨɨsu aarɨ, bhakabhʉʉka hamwɨmwɨ. Haarɨ nu ubhwatʉ ʉbhʉndɨ bhʉnʉ bhakangatɨɨnʼyɨ nabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ʉmʉkama ʉmʉhaari bhʉkʉngʼu gʉkatanga kuhuuta mʉnyanza. Amakunda gaarɨ garahuna ubhwatʉ, amanzi gakatanga kusikɨra mubhwatʉ bhokeenda kwizʉra. ");
INSERT INTO ikz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ribhaga riyo, Yɨɨsu zaarɨ zimuhirirɨ inyuma mubhwatʉ, ahɨgɨkirɨ umutwɨ kʉmʉsagʉ. Abhɨɨga bhaazɨ bhakamubhuucha, bhakabhuga, “Umwija, ʉtakʉdɨɨrɨɨra kʉbha itwɨ tʉrarika?” ");
INSERT INTO ikz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Neho Yɨɨsu akiimɨɨrɨra, akahama ʉmʉkama gurya, akabhʉʉrɨra ɨnyanza, “Ukirɨ! Horeera!” Ʉmʉkama gurya gʉkatiga kuhuuta, kʉkabha bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mmbe Yɨɨsu akabhabhuurya abhɨɨga bhaazɨ, “Kwakɨ mʉrʉʉbhaha? Nangʉ mʉkɨɨrɨ kʉbha nu ubhwisirirya?” ");
INSERT INTO ikz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bhakʉʉbhaha bhʉkʉngʼu, bhakatanga kwibhuurya, “Wʉnʉ nɨ‑wɨɨwɨ, ʉmʉkama na amakunda bhyʉsi bhɨramwigwa?” ");
INSERT INTO ikz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yɨɨsu na abhɨɨga bhaazɨ bhakahika imwambʉkʉ wɨ ɨnyanza ya Gariraaya, mucharʉ cha Abhagɨraasi. ");
INSERT INTO ikz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hanʉ Yɨɨsu iikirɨ mubhwatʉ, ʉmʉʉtʉ wʉnʉ aarɨ na amasambwa akarwa mʉmabhigi ganʉ gaarɨ zimbihɨra, akamuryarɨra Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ʉmʉʉtʉ wuyo aarɨ ariikara mʉmabhigi ganʉ gaarɨ zimbihɨra. Aarɨ na amanaga, ataarɨ areho wʉwʉʉsi wʉnʉ aaturirɨ komobhoha nʉʉrʉ kwe emenyororo. ");
INSERT INTO ikz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bhaarɨ bhamʉbhʉhirɨ manga kaaru ne emenyororo kʉmagʉrʉ nɨ ɨbhɨrangʼani kʉmabhoko, nawe akabhɨtɨna bhyʉsi. Ataarɨ areho ʉmʉʉtʉ wʉnʉ akʉtʉra kumuhiza. ");
INSERT INTO ikz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ibhaga ryʉsi ubhutikʉ nu umwise aarɨ aragendagenda kuzimbihɨra na mʉbhɨgʉrʉ, ararɨgɨsa na kwingʼerangʼera na amabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hanʉ ʉmʉʉtʉ wuyo aarʉʉzɨ Yɨɨsu kwa kore na kumuryarɨra, akamuhigamɨra. ");
INSERT INTO ikz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akarɨgɨsa kwiraka ikʉrʉ akabhuga, “Nɨ‑nakɨ na naawɨ, Yɨɨsu Umwana wa Mungu wi Igʉrʉ wa Bhyʉsi? Nɨrakwisasaama kuriina rya Mungu ʉtanyaacha.” ");
INSERT INTO ikz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akagambabhu kʉ kʉbha Yɨɨsu aarɨ aribhuuriirɨ, “Risambwa, nuurwɨ kʉmʉʉtʉ wʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yɨɨsu akaribhuurya, “Iriina ryazʉ wɨɨwɨ?” Rɨkamʉgarukirya, “Iriina ryanɨ, nɨ‑Bhasirikarɨ, kʉ kʉbha itwɨ, nɨ‑bhaaru kʉmʉʉtʉ wʉnʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Risambwa rirya rɨkamwisasaama manga kaaru kʉbha atagaheebha mucharʉ kirya. ");
INSERT INTO ikz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwarɨ na rihizʉ ikʉrʉ rya zingurubhɨ, rɨrariisha rusizʉ wɨ ɨkɨgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Neho amasambwa garya gakabhuga, “Tʉrasabha utwisiririryɨ, tusikɨrɨ muzingurubhɨ zirya.” ");
INSERT INTO ikz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yɨɨsu akagiisiririrya. Amasambwa gayo gakarwɨku ʉmʉʉtʉ wurya, gakaja muzingurubhɨ. Rihizʉ ryʉsi rya zingurubhɨ rɨkahiringita mwega ikihiringitʉ ɨkɨhaari, zɨkagwa mʉnyanza na kukwa. Zingurubhɨ ziyo zaarɨ zɨrahika bhɨkwɨ bhɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abhariisha bha zingurubhɨ bharya bhakaryara, bhakaraganʼya amangʼana gayo mʉzɨmbɨri. Abhaatʉ bhakaaza, korereke bhiirorere abheene ganʉ gakʉrirwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hanʉ bhaahikirɨ kwa Yɨɨsu, bhakʉʉbhaha bhʉkʉngʼu korora wʉnʉ aarɨ na riribhita rya amasambwa ikɨɨrɨ, ibhʉhirɨ zengebho na ana amangʼɨɨni gakunaanirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bharya bhaarʉʉzɨ ganʉ gaamubhwɨnɨ wʉnʉ aarɨ na amasambwa na zingurubhɨ, bhakabha bharabhʉʉrɨra abhaatʉ abhandɨ amangʼana gayo. ");
INSERT INTO ikz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Neho abhaatʉ bhakatanga kʉsabha Yɨɨsu arwɨ mucharʉ chabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hanʉ Yɨɨsu aarɨ akusikɨra mubhwatʉ, ʉmʉʉtʉ wʉnʉ aarɨ na amasambwa akasabha Yɨɨsu kʉbha amwisiririryɨ bhahiranɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nawe Yɨɨsu atamwisiririiryɨ, akamʉbhʉʉrɨra, “Nuujɨ ɨwaanyu, ʉbhabhʉʉrɨrɨ amangʼana amakʉrʉ gɨ ɨbhɨgʉngi ganʉ Ʉmʉkʉrʉ akʉkʉrɨɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ʉmʉʉtʉ wuyo akabhʉʉka akaja, akatanga kʉnyaraganʼya amangʼana Dɨkapʉʉri, amangʼana amakʉrʉ ganʉ Yɨɨsu aamʉkʉrɨɨrɨ. Abhaatʉ bhʉʉsi bhakarʉgʉʉra. ");
INSERT INTO ikz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yɨɨsu na abhɨɨga bhaazɨ bhakaambʉka ɨnyanza nu ubhwatʉ kʉgarʉka imwambʉkʉ. Hanʉ bhaahikirɨ, riribhita ikʉrʉ rya abhaatʉ rikiibhiringɨra rusizʉ wɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hayo akaaza ʉmʉkangati wʉmwɨ mwirwazɨrʉ, iriina ryazɨ Yairʉ. Hanʉ aarʉʉzɨ Yɨɨsu, akamujaku, akagwa mʉmagʉrʉ gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akamwisasaama arabhuga, “Umuucha waanɨ murwɨrɨ, areenda kutinʼya. Nɨrasabha tujɨ omoteere amabhoko gaazʉ kʉmʉbhɨrɨ gwazɨ, korereke ahone.” ");
INSERT INTO ikz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yɨɨsu akahirana nawe. Riribhita rirya rɨkabha rɨramutuna, rimwirugutiriiryɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mwiribhita rirya, kwarɨ nʉ ʉmʉkari wʉnʉ aarɨ nu ubhurwɨrɨ bhwɨ ɨngɨzi kwi imyaka ikumi nɨ ɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʉmʉkari wuyo aarɨ anyaakirɨ bhʉkʉngʼu kuja kʉbhagabhʉ. Akamara ebhegero bhyazɨ bhyʉsi arahira kʉbhagabhʉ, atabhwɨnɨ hakɨrɨku, nawe bhokoongera kʉhaara. ");
INSERT INTO ikz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hanʉ ʉmʉkari wuyo iigwirɨ ganʉ Yɨɨsu aakʉrirɨ, akahɨta mwiribhita rya abhaatʉ kwi inyuma, akakunʼyaku engebho ya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Akakorabhu kʉ kʉbha akiigambɨra, “Nɨraakunʼyɨkubhu engebho yaazɨ, nɨrahora.” ");
INSERT INTO ikz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hayohayo ɨngɨzi ɨkatɨnɨka, akiiyigwa mʉmʉbhɨrɨ kʉbha ahʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Rogendo rʉmwɨ Yɨɨsu akamenya kʉbha amanaga gaazɨ gakʉrirɨ emeremo. Akiichʉra, akabhuurya abhaatʉ bha riribhita, “Nɨ‑wɨɨwɨ wʉnʉ akuniryɨku zengebho zaanɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abhɨɨga bhaazɨ bhakamʉbhʉʉrɨra, “Ʉrarora chɨmbu abhaatʉ bhaaru bhakʉhɨgana kukwisukaku! Na naawɨ ʉrabhuurya, ‘Nɨ‑wɨɨwɨ ankuniryɨku?’ ” ");
INSERT INTO ikz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nawe akarora ɨnʉ nɨ ɨnʉ, korereke amorore wʉnʉ aamukuniryɨku. ");
INSERT INTO ikz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Neho ʉmʉkari wurya akʉʉbhaha, akaaza akamugwaku mʉmagʉrʉ, ɨnʉ ararigita, kʉ kʉbha akamenya ganʉ gakʉriibhwɨ kwewe. Akamʉbhʉʉrɨra amaheene gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yɨɨsu akamʉbhʉʉrɨra, “Muucha, ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ. Ujɨ no omorembe, nangʉ ʉhʉriibhwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hanʉ Yɨɨsu aarɨ akɨɨrɨ aragambana nʉ ʉmʉkari wuyo, abhaatʉ bhakaaza kurwa munyumba ya Yairʉ, ʉmʉkangati wi inyumba ya rirwazɨrʉ, bhakabhuga, “Yairʉ, tiga kʉnyaacha umwija, kʉ kʉbha umuucha waazʉ amarirɨ kukwa.” ");
INSERT INTO ikz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nawe hanʉ Yɨɨsu iigwirɨ amangʼana gayo, akabhʉʉrɨra Yairʉ, “Ʉtʉʉbhaha, isirirya.” ");
INSERT INTO ikz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yɨɨsu akagarucha abhaatʉ abhandɨ bhʉʉsi kʉbha bhatakangatanʼya nawe. Akaja na Peetero, Yaakobho na Yoohana umunyi wa Yaakobho. ");
INSERT INTO ikz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hanʉ bhaahikirɨ kunyumba ya Yairʉ, Yɨɨsu akabhona abhaatʉ bhararɨra na kwarama. ");
INSERT INTO ikz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Akasikɨra munyumba, akabhuga, “Mʉrarɨrɨrakɨ? Umuucha wʉnʉ akɨɨrɨ kukwa, nawe ahindiirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Riribhita rya abhaatʉ rikamoseka kwa kerege, nawe Yɨɨsu akabhahurucha bhʉʉsi igʉtʉ. Akagega wiisɨ, unina umwana na abhɨɨga bhaazɨ bhatatʉ, bhakaja ɨgatɨ ɨnʉ bhahindiryɨ umuucha. ");
INSERT INTO ikz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akagwata umuucha wurya kokobhoko, akamʉbhʉʉrɨra, “Tariita, ikumi!” enzobhooro yaku, “Umuucha, nɨrakʉbhʉʉrɨra, bhʉʉka!” ");
INSERT INTO ikz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hayohayo, umuucha wuyo akiimɨɨrɨra, akatanga kogenda. Aarɨ ni imyaka ikumi nɨ ɨbhɨrɨ. Bhakarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yɨɨsu akabharecha bhatabhʉʉrɨra wʉwʉʉsi ganʉ gakʉrirwɨ. Akabhabhʉʉrɨra abhiibhuri bhu umuucha wuyo bhamohe ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Neho Yɨɨsu akarwɨyʉ, akagarʉka kʉrʉbhɨri rwabhʉ rwa Nazarɨɨti hamwɨmwɨ na abhɨɨga bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hanʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ rwahikirɨ, akatanga kwija mwirwazɨrʉ. Abhaaru bhanʉ bhamwigwirɨ bhakarʉgʉʉra. Bhaarɨ bhariibhuurya, “Wʉnʉ abhwɨnɨ hayi ganʉ gʉʉsi? Ni‑bhwʉbhʉʉrikɨ bhʉnʉ aahɨɨrwɨ nʉ ʉbhʉnaja bhwo okokora ɨbhɨsɨgʉ ncha bhiyo? ");
INSERT INTO ikz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wʉnʉ atarɨ ʉmʉsɨrɨmara wurya, mura wa Mariyamu, na bhaumwabhʉ nɨ‑Yaakobho, Yoose, Yuuda na Simʉʉni? Na abhasubhaati bhaazɨ tʉtaanabhʉ hanʉ?” Bhakiigatana igʉrʉ waazɨ, bhakaanga kumwisirirya. ");
INSERT INTO ikz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yɨɨsu akabhabhʉʉrɨra, “Ʉmʉrʉʉtɨrɨri ahaasuukwa ahandɨ hʉʉsi, kuruushaku mʉrʉbhɨri rwazɨ, kʉbhahiiri bhaazɨ nu uwaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na ataturirɨ kokora iyo ɨbhɨsɨgʉ bhyaru, nawe akabhatʉʉrɨra amabhoko abharwɨrɨ bhasuuhu na kʉbhahorya. ");
INSERT INTO ikz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akarʉgʉʉra bhʉkʉngʼu kʉ kʉbha bhatamwisiriiryɨ. Akʉmara Yɨɨsu akiiruguura mʉzɨmbɨri za haguhɨ kubhiija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akabhɨrɨkɨra abhɨɨga bhaazɨ ikumi na bhabhɨrɨ. Akabhaha ʉbhʉnaja bhu ukuruusha amasambwa, akabhatʉma bhabhɨrɨ bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akabhaswaja, “Mʉtagega kegero chʉchʉsi igʉrʉ wo orogendo rwanyu kuruushaku ihimbʉ. Mʉtagega ɨsakwa, nʉʉrʉ ibhyakurya, nʉʉrʉ mpirya. ");
INSERT INTO ikz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mwibhohe ibhikwɨra, nawe mʉtagega ɨshadi ya kʉgarʉra.” ");
INSERT INTO ikz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akangʼeha kʉbhabhʉʉrɨra, “Munyumba yʉyʉʉsi yɨnʉ bharaabhasʉngʼaanɨ, mwikarɨ muyomuyo, kuhika hanʉ mʉkʉbhʉʉka mʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na hʉhʉʉsi hanʉ bhatakʉbhasʉngʼaana hamwɨ kubhiitegeerera, hanʉ mʉkʉbhʉʉka, mʉkʉngʼʉtɨ urutu kʉmagʉrʉ gaanyu, kobheerecha kʉbha Mungu arabhaanga.” ");
INSERT INTO ikz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Abhɨɨga bharya bhakabhʉʉka, bhakatanga kʉbharwazɨra abhaatʉ kʉbha, bhatigɨ ʉbhʉbhɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhakaruusha amasambwa maaru na kohorya abharwɨrɨ bhaaru kwa kʉbhahaka amaguta. ");
INSERT INTO ikz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ʉmʉtɨmi wi icharʉ kirya, iriina ryazɨ Heroode Antipaasi, akiigwa amangʼana ga Yɨɨsu, kʉ kʉbha aarɨ aramenyekana hʉʉsi. Abhandɨ bhaarɨ bharabhuga, “Ne‑Yoohana Ʉmʉbhatiizi aryukirɨ mʉbhaku, necho anʉ ʉbhʉnaja bhwo okokora ɨbhɨsɨgʉ ɨbhɨkʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abhandɨ bhaarɨ bharabhuga, “Nɨ‑Ɨɨriya.” Abhandɨ bhaarɨ bharabhuga, “Ewe nɨ‑mʉrʉʉtɨrɨri wa Mungu ncha abharʉʉtɨrɨri abhandɨ bhɨ ɨkarɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nawe hanʉ Heroode Antipaasi igwirɨ amangʼana gayo, akabhuga, “Wʉnʉ, ne‑Yoohana, wʉnʉ natinirɨ umutwɨ. Aryukirɨ mʉbhaku!” ");
INSERT INTO ikz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Heroode umwene aarɨ aswajiryɨ Yoohana Ʉmʉbhatiizi agwatwɨ na atuurwɨ mokebhoho. Akakorabhu igʉrʉ wa Hɨrʉʉdiya ʉmʉkari wa Firipʉ wʉnʉ aarɨ akwɨrirwɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yoohana aarɨ abhuuriirɨ Heroode, “Ni‑mugirʉ kwa naawɨ kukwɨra ʉmʉkari wa umwanyu.” ");
INSERT INTO ikz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mmbe, Hɨrʉʉdiya akabhiihirirwa bhʉkʉngʼu Yoohana, akeenda kumwita nawe akatamwa. ");
INSERT INTO ikz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heroode akʉʉbhaha Yoohana, kʉ kʉbha akamenya kʉbha ewe nɨ‑mʉʉtʉ we eheene na mʉrɨndu, akabha aramuriibha. Hanʉ Heroode aarɨ akwitegeerera Yoohana, aarɨ ararumɨka bhʉkʉngʼu, nawe akasɨɨga kumwitegeerera. ");
INSERT INTO ikz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ribhaga rɨkahɨta, urusikʉ rʉmwɨ Heroode akabhona ɨnzɨra yu ukwita Yoohana. Kuhiita ɨnyangi yu ukwibhurwa kwazɨ, akabhaginihya abhatiniri bhaazɨ, abhakʉrʉ bha abhasirikarɨ, na abhakangati bhi icharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hanʉ abhagini bhiikɨɨrɨ, umuucha waazɨ Hɨrʉʉdiya akasikɨra, akabhina, Heroode na abhagini bhaazɨ bhakazomerwa. Ʉmʉtɨmi akabhʉʉrɨra umuucha wuyo, “Nsabha chʉchʉsi kɨnʉ ukwenda, inyɨ nɨrakoha.” ");
INSERT INTO ikz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akiirahɨra, “Nɨrakoha chʉchʉsi kɨnʉ ukwenda, nʉʉrʉ ritɨnɨka ryʉ ʉbhʉtɨmi bhwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Neho umuucha wurya akahʉrʉka igʉtʉ, akabhuurya unina, “Yiiya, nɨsabhɨkɨ?” Unina akamʉbhʉʉrɨra, “Sabha umutwɨ gwa Yoohana Ʉmʉbhatiizi.” ");
INSERT INTO ikz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mmbe umuucha wurya akagarʉka bhwangʉ kʉmʉtɨmi, akamʉbhʉʉrɨra, “Nereenda ongʼe nangwɨnʉ umutwɨ gwa Yoohana Ʉmʉbhatiizi kʉrʉhʉngʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ʉmʉtɨmi akarumɨka bhʉkʉngʼu, nawe igʉrʉ wu ubhwirahiri bhwazɨ mʉbhʉtangɨ bhwa abhagini, atɨɨndirɨ kumwangɨra. ");
INSERT INTO ikz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Akatʉma umusirikarɨ ajɨ kʉtɨna Yoohana umutwɨ. Umusirikarɨ akaja mokebhoho, akatɨna Yoohana umutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akareeta umutwɨ guyo kʉrʉhʉngʉ, akaha umuucha wuyo, akahirɨra unina. ");
INSERT INTO ikz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hanʉ abhɨɨga bha Yoohana bhiigwirɨ gayo, bhakaja, bhakagega ɨkɨtʉndʉ chazɨ, bhakakɨbhɨɨka. ");
INSERT INTO ikz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hanʉ abhatumwa bhaagarukirɨ, bhakiibhiringa mʉbhʉtangɨ bhwa Yɨɨsu, bhakamʉbhʉʉrɨra gʉʉsi ganʉ bhaakʉrirɨ na kubhiija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kʉrɨngʼaana na abhaatʉ bhaaru bhʉkʉngʼu bhanʉ bhaareho, abhandɨ bhaarɨ bharaaza, abhandɨ bhaarɨ bharabhʉʉka, Yɨɨsu na abhɨɨga bhaazɨ bhakatamwa kurya. Akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Muuzɨ, tujɨ hanʉ hataana abhaatʉ, twoyeere hasuuhu.” ");
INSERT INTO ikz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bhakabhʉʉka abheene mubhwatʉ, bhakaja ahagero hanʉ hataana abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nawe hanʉ bhaabhuukirɨ abhaatʉ bhakabharora, bhakabhamenya. Abhaatʉ bharya hamwɨmwɨ na abhandɨ kurwa zɨmbɨri nzaru bhakabharyarɨra, bhakabhakangatɨra kuhika ɨnʉ bhaarɨ bhakuja. ");
INSERT INTO ikz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hanʉ Yɨɨsu iikirɨ mubhwatʉ, akarora riribhita ikʉrʉ rya abhaatʉ. Akabharorera ɨbhɨgʉngi, kʉ kʉbha bhaarɨ ncha zɨngʼʉndu zɨnʉ zɨtaana umuriisha. Akatanga kubhiija amangʼana maaru. ");
INSERT INTO ikz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hanʉ zaahitirɨ ɨsa nzaru zu umwise, abhɨɨga bhaazɨ bhakamujaku, bhakamʉbhʉʉrɨra, “Hanʉ tʉrɨ ni‑mwitɨrɨgʉ na bhʉraariirɨ kwira. ");
INSERT INTO ikz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ʉbharagɨ abhaatʉ bhanʉ, bhajɨ mʉzɨmbɨri zɨnʉ zɨrɨ haguhɨ, korereke bhiigʉrɨrɨ ibhyakurya.” ");
INSERT INTO ikz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nawe, Yɨɨsu akabhagarukirya, “Imwɨ mʉbhahɨ ibhyakurya.” Bhakamubhuurya, “Oreenda itwɨ tujɨ tʉbhagʉrɨrɨ ɨmɨkaatɨ kwa zidinaari magana abhɨrɨ, korereke tʉbhahɨ bharyɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wʉʉsi akabhabhuurya, “Mʉnɨ ɨmɨkaatɨ ɨrɨnga? Mujɨ morore.” Bhakaja korora, bhakagarʉka, bhakamʉbhʉʉrɨra, “Tʉnɨ ɨmɨkaatɨ ɨtaanʉbhu na ziiswɨ ibhɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yɨɨsu akabhabhʉʉrɨra kʉbha, bhiikaryɨ abhaatʉ bhʉʉsi kʉmagari kʉbhʉnyaaki ʉbhʉbhɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bhakiikara amagari, abhandɨ igana igana, abhandɨ merongo ɨtaanʉ ɨtaanʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yɨɨsu akagega ɨmɨkaatɨ ɨtaanʉ na ziiswɨ ibhɨrɨ, akarangamɨra kwisaarʉ, akabhʉʉrɨra Mungu, azʉmiryɨ. Akasunyura ɨmɨkaatɨ girya, akabhaha abhɨɨga bhaazɨ bhabhasondye abhaatʉ. Na akabhasondya bhʉʉsi ziiswɨ ibhɨrɨ zirya. ");
INSERT INTO ikz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhʉʉsi bhakarya, bhakiigʉta. ");
INSERT INTO ikz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abhɨɨga bhaazɨ bhakabhiringa amasaajʉ gɨ ɨmɨkaatɨ na ziiswɨ, bhakiizurya bhɨhʉʉzʉ ikumi na bhɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bhanʉ bhaariirɨ ibhyakurya bhirya bhaarɨ bhaaru, abhasubhɨ abheene bhaarɨ bhɨkwɨ bhɨtaanʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Neho Yɨɨsu akabhaswaja abhɨɨga bhaazɨ bhasikɨrɨ mubhwatʉ, bhakangatɨ kwambʉka ɨnyanza kuja kʉrʉbhɨri rwa Bhɨtɨsaida, ewe aarɨ araraga riribhita rya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na hanʉ bhaataanirɨ, akatiira kʉkɨgʉrʉ kʉsabha. ");
INSERT INTO ikz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hanʉ yaahikirɨ mʉkabhuribhuri, abhɨɨga bhaarɨ mubhwatʉ gatɨgatɨ wɨ ɨnyanza, na Yɨɨsu aarɨ umwene kʉkɨgʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Akabharora bharanyaaka kʉgʉha ubhwatʉ, kʉ kʉbha ʉmʉkama gwarɨ gʉrahuuta. Mmbe hanʉ ryahikirɨ mʉmacha, akabhajaku aragenda kʉmanzi, akeenda kʉbhahɨtɨɨra. ");
INSERT INTO ikz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nawe hanʉ bhaamʉrʉʉzɨ aragenda kʉmanzi, bhakakina nɨ‑kɨhwɨ, bhakarɨgɨsa. ");
INSERT INTO ikz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Hanʉ bhaarʉʉzɨ newe bhʉʉsi bhakʉʉbhaha bhʉkʉngʼu. Yɨɨsu akabhuga, “Mohoreere, mʉtʉʉbhaha! Niinyɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yɨɨsu akatiira mubhwatʉ bhwabhʉ, ʉmʉkama gʉkatureera. Bhakarʉgʉʉra bhʉkʉngʼu, ");
INSERT INTO ikz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kʉ kʉbha bhatʉʉbhʉʉrirɨ nʉʉrʉ ɨkɨrʉgʉʉrʉ chɨ ɨmɨkaatɨ. Zekoro zaabhʉ zaarɨ kʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaambukirɨ ɨnyanza, bhakahika mucharʉ cha Genezarɨti. Bhakiimiirirya ubhwatʉ imwambʉkʉ. ");
INSERT INTO ikz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hanʉ bhiikirɨ mubhwatʉ, abhaatʉ bha harya bhakamenya Yɨɨsu bhwangʉ, ");
INSERT INTO ikz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bhakiiruguura kʉʉsɨ yirya yʉʉsi. Bharagega abharwɨrɨ kʉbhɨragʉ kuja hʉhʉʉsi hanʉ bhiigwirɨ Yɨɨsu arɨ. ");
INSERT INTO ikz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hʉhʉʉsi harya aagiirɨ, ɨbhɨ mʉzɨmbɨri hamwɨ mʉʉsɨ, bhakamoreetera abharwɨrɨ kʉrʉbhʉʉga. Bhakamʉsabha abhiisiririryɨ abharwɨrɨ bhakunʼyɨ nʉʉrʉ ripindʉ rye engebho yaazɨ. Bhʉʉsi bhanʉ bhaamukuniryɨku, bhakahora amarwɨrɨ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Rusikʉ rʉmwɨ Abhafarisaayo na abhiija bhi imigirʉ ja Musa obhorebhe bhakaaza kurwa mʉrʉbhɨri rwa Yɨrusarɨɨmu, bhakiibhiringa kwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakarora abhɨɨga obhorebhe bha Yɨɨsu bhararya ibhyakurya bhatiisaabhirɨ amabhoko chɨmbu yaarɨ ikwenderwa isimʉka yaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Zisikʉ zirya, Abhafarisaayo na Abhayaahudi bhʉʉsi bhataarɨ kurya bhatiisaabhirɨ amabhoko kuhika kozengokora, kuhiita isimʉka ya abhakaruka bhaabhʉ chɨmbu yaarɨ. ");
INSERT INTO ikz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hanʉ bhakurwa mwisoko, bhariisaabha hinga amabhoko chɨmbu ikwenderwa, neho bharyɨ. Na bharahiita zisimʉka zaabhʉ nzaru ɨzɨndɨ zɨ ɨkarɨ, nchu ukwoja ebhekombe, ibhihurɨra ne ebhegero. ");
INSERT INTO ikz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Neho Abhafarisaayo na abhiija bhi imigirʉ ja Musa bhakabhuurya Yɨɨsu, “Kwakɨ abhɨɨga bhaazʉ bhatakutuna isimʉka ya abhakaruka bhɨɨtʉ? Ebho bhararya bhabhɨngirɨ ɨnʉ bhatiisaabhirɨ amabhoko.” ");
INSERT INTO ikz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yɨɨsu akabhagarukirya, “Imwɨ nɨ‑bhabhɨɨhi. Mungu akagamba amaheene igʉrʉ waanyu kʉhɨtɨra kʉmʉrʉʉtɨrɨri Isaaya chɨmbu yandikirwɨ kʉbha, ‘Abhaatʉ bhanʉ bhahaansʉʉka kwa mangʼana ageene, nawe zekoro zaabhʉ zere kore na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Okosengera kwabhʉ kʉtaana bhwera, kʉ kʉbha bhariija amiija ga abhaatʉ kina nɨ‑ga Mungu.’ ” ");
INSERT INTO ikz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Imwɨ mʉratiga imigirʉ ja Mungu, mʉragwata isimʉka ya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Mʉna zɨnzɨra nzʉmu zu ukwanga imigirʉ ja Mungu, korereke mobhone kugwata isimʉka yanyu! ");
INSERT INTO ikz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa akabhuga, ‘Ʉsʉʉkɨ wuusʉ na onyoko,’ naatu akabhuga, ‘Wʉwʉʉsi wʉnʉ akʉtʉka wiisɨ hamwɨ unina, areenderwa akwɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nawe imwɨ, muriija mʉrabhuga, nɨ‑bhwaheene arɨɨbhɨ ʉmʉʉtʉ arabhʉʉrɨra wiisɨ hamwɨ unina kʉbha, ‘Ebhegero bhɨnʉ nangaturirɨ kʉkʉsakirya, bhɨbhɨɨrɨ Kʉribhani,’ enzobhooro yaku, nɨ‑mʉbhanʉ kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ukwija kwanyu kuyo, kʉragirya atasakirya abhiibhuri bhaazɨ kegero. ");
INSERT INTO ikz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɨbhu mʉrachʉra imigirʉ ja Mungu, korereke mʉnajɨ kuhiita zisimʉka zaanyu abheene. Na mʉrakora maaru ganʉ gatuubhɨɨnɨ na ganʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yɨɨsu akabhɨrɨkɨra naatu riribhita rya abhaatʉ, akabhabhʉʉrɨra, “Imwɨ, munyiitegeerere, bhʉʉsi mogoobhoore amangʼana gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kɨtareeho ekegero kɨnʉ kikusikɨra ʉmʉʉtʉ na kugirya abhenge. Nawe, ganʉ gakurwa mokoro yʉ ʉmʉʉtʉ nego gahaagirya abhenge.  ");
INSERT INTO ikz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hanʉ aatigirɨ riribhita rya abhaatʉ na kusikɨra munyumba, abhɨɨga bhaazɨ bhakamubhuurya igʉrʉ we ekerenjo kiyo. ");
INSERT INTO ikz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Akabhabhʉʉrɨra, “Na niimwɨ mʉkɨɨrɨ komenya? Mʉtɨɨzɨ kʉbha ekegero kɨnʉ kikusikɨra ʉmʉʉtʉ kɨtakʉtʉra kugirya abhenge? ");
INSERT INTO ikz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ibhyakurya bhɨtakurumana ne ekoro, bhɨrahɨta mʉnda aheene, bhɨtakwikara mʉmʉbhɨrɨ.” Kʉ kʉgambabhu, Yɨɨsu akeerecha kʉbha, ibhyakurya bhyʉsi bhyisiririibhwɨ kuriibhwa. ");
INSERT INTO ikz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akangʼeha kʉgamba, “Ganʉ gakurwa mokoro yʉ ʉmʉʉtʉ, nego gakugirya abhenge. ");
INSERT INTO ikz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mokoro yʉ ʉmʉʉtʉ nɨmu gahaarwa amiisɨɨgi amabhɨ, ɨtaarʉ, ");
INSERT INTO ikz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ubhwibhi, ubhwiti, ʉbhʉsɨbhɨɨti, ubhwimani, ʉbhʉbhɨ, ʉbhʉkangirirya, amangʼana ga zɨsʉni, rihari, amatuki, ikisiraani no obhogeege. ");
INSERT INTO ikz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amabhɨ gʉʉsi gayo gararwa mokoro yʉ ʉmʉʉtʉ na garagirya abhenge.” ");
INSERT INTO ikz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yɨɨsu na abhɨɨga bhaazɨ bhakabhʉʉka mucharʉ cha Gariraaya, bhakaja mʉrʉbhɨri rwa Tiiro na Sidʉʉni. Akiibhisa iyo munyumba, atɨɨndirɨ emenyekanɨ kʉmʉʉtʉ wʉwʉʉsi kʉbha areho. Nawe atanagiryɨ kwibhisa. ");
INSERT INTO ikz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kwarɨ nʉ ʉmʉkari wʉmwɨ wʉnʉ umuucha waazɨ aarɨ na risambwa, hanʉ iigwirɨ amangʼana ga Yɨɨsu, akaja akamugwɨra mʉmagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ʉmʉkari wuyo ataarɨ Mʉyaahudi, aarɨ wa Siiriya‑Fʉinikɨ, akamwisasaama Yɨɨsu aruushɨ umuucha waazɨ risambwa. ");
INSERT INTO ikz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yɨɨsu akamʉbhʉʉrɨra, “Ɨtarɨ bhwaheene kogega ibhyakurya bhya abhaana na kʉtaashirya zimbwa.” ");
INSERT INTO ikz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nawe ʉmʉkari wurya akamʉgarukirya, “Ʉmʉkʉrʉ, amangʼana gaazʉ nɨ‑maheene. Nawe, hanʉ abhaana bhahaarya, zimbwa zɨhaatoora amasaajʉ ganʉ gakotorobhoka.” ");
INSERT INTO ikz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yɨɨsu akamʉgarukirya, “Hayo ʉgambirɨ bhwaheene. Mmbe, bhʉʉka, risambwa riruurɨku umuucha waazʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ʉmʉkari wurya akagarʉka yɨɨka, akabhona umwana waazɨ ahʉrirɨ, irambikirɨ kʉbhʉrɨrɨ na risambwa rimuruurɨku. ");
INSERT INTO ikz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Neho Yɨɨsu akabhʉʉka na abhɨɨga bhaazɨ mucharʉ cha Tiiro, akahɨta Sidʉʉni, akagarʉka mʉnyanza ya Gariraaya, mucharʉ cha Dɨkapʉʉri. ");
INSERT INTO ikz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ iyo, wʉnʉ aarɨ umuribhi wa amatwɨ ni imuumu. Abhaatʉ obhorebhe bhakamoreeta kwa Yɨɨsu, bhakasabha Yɨɨsu amʉtʉʉrɨrɨ amabhoko, amohorye. ");
INSERT INTO ikz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yɨɨsu akamuruusha mwiribhita rya abhaatʉ, akaja nawe umwene rusizʉ. Akatʉʉra ibhyara bhyazɨ mʉmatwɨ gʉ ʉmʉʉtʉ wurya. Akatwɨra amatɨ kuchara, akamʉhaka kʉrʉrɨmɨ. ");
INSERT INTO ikz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akarora kwisaarʉ, akiicha ibhiikoohe, akamʉbhʉʉrɨra, “Ɨfata,” enzobhooro yaku, “Igʉka.” ");
INSERT INTO ikz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hayohayo, ʉmʉʉtʉ wurya akaribhʉka amatwɨ akiigwa, akatanga kʉgamba bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yɨɨsu akakandikija riribhita rya abhaatʉ kʉbha, bhatabhʉʉrɨra mʉʉtʉ wʉwʉʉsi ganʉ akʉrirɨ. Nawe chɨmbu angʼɨhirɨ kʉbharecha, nɨmbu bhaangʼɨhirɨ bhʉkʉngʼu kʉnyaraganʼya ɨngʼana yiyo. ");
INSERT INTO ikz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhakarʉgʉʉra bhʉkʉngʼu, bhakabhuga, “Gʉʉsi ganʉ akʉrirɨ nɨ‑mazʉmu. Arahorya abharibhi bha amatwɨ bhiigwɨ, na amamuumu gagambɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kwibhaga riyo, riribhita ɨrɨndɨ ikʉrʉ rya abhaatʉ rikiibhiringa, na ribhaga rɨkahɨta bhakasirirwa ibhyakurya. Neho Yɨɨsu akabhabhɨrɨkɨra abhɨɨga bhaazɨ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nɨrabharorera ɨbhɨgʉngi abhaatʉ bhanʉ, kʉ kʉbha twikɨɨrɨ nabhʉ zisikʉ isatʉ, nangwɨnʉ bhataana ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɨraabhugɨ nibhatigɨ bhajɨ ɨwaabhʉ nɨ ɨnzara, bharatʉra koseezekera mʉnzɨra, na abhandɨ bharuurɨ kore.” ");
INSERT INTO ikz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abhɨɨga bhaazɨ bhakamʉgarukirya, “Hanʉ ni‑mwitɨrɨgʉ, atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kobhona ɨmɨkaatɨ ju ukwisa abhaatʉ bhʉʉsi bhanʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yɨɨsu akabhabhuurya, “Mʉnɨ ɨmɨkaatɨ ɨrɨnga?” Bhakamʉbhʉʉrɨra, “Tʉnajʉ muhungatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yɨɨsu akaswaja abhaatʉ bhiikarɨ haasɨ. Akagega ɨmɨkaatɨ muhungatɨ girya akabhʉʉrɨra, Mungu, azʉmiryɨ. Akʉmara akasunyura, akabhaha abhɨɨga bhaazɨ, bhasondye abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kwikɨ, bhaarɨ ni ibhiswɨ bhisuuhu. Yɨɨsu akabhʉʉrɨra Mungu, azʉmiryɨ, akaswaja abhɨɨga bhaazɨ bhabhahɨ abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abhaatʉ bhakarya, bhakiigʉta. Abhɨɨga bhakabhiringa amasaajʉ, bhakiizurya ɨbhɨhʉʉzʉ muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Abhaatʉ bhanʉ bhaariirɨ ibhyakurya bhaarɨ bharatʉra kʉbha bhɨkwɨ bhene. Yɨɨsu akabharaga abhaatʉ bharya. ");
INSERT INTO ikz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rogendo rʉmwɨ akasikɨra na abhɨɨga bhaazɨ mubhwatʉ, bhakaja mucharʉ cha Darimanuta. ");
INSERT INTO ikz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaahikirɨ Darimanuta, Abhafarisaayo bhakaaza kwa Yɨɨsu. Bhakatanga kʉhakaana nawe korereke bhamʉhaatyɨ. Bhakamʉsabha akore ichɨrɨkɨnʼyʉ kwerecha kʉbha aaruurɨ kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yɨɨsu akarumɨka mokoro. Akabhabhʉʉrɨra, “Kwakɨ urwibhʉrʉ rʉnʉ, moreenda ichɨrɨkɨnʼyʉ? Nɨrabhabhʉʉrɨra amaheene, urwibhʉrʉ rʉnʉ rʉtakwerechwa ichɨrɨkɨnʼyʉ chʉchʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akabhatiga, akasikɨra kwikɨ mubhwatʉ na abhɨɨga bhaazɨ. Bhakatanga orogendo bhakaambʉka. ");
INSERT INTO ikz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abhɨɨga bha Yɨɨsu bhaarɨ bhɨɨbhirɨ kogega ɨmɨkaatɨ. Bhaarɨ nʉ ʉmʉkaatɨ gʉmwɨbhu mubhwatʉ. ");
INSERT INTO ikz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yɨɨsu akabhahama, “Mwiyangarɨrɨ na kʉbha mɨɨsʉ nu ubhutunduuru bhwa Abhafarisaayo na bhwʉ ʉmʉtɨmi Heroode Antipaasi.” ");
INSERT INTO ikz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abhɨɨga bhaazɨ bhakatanga kʉgambana abheene kobheene, bharabhuga, “Agambirɨbhu, kʉ kʉbha tʉtaagɨgirɨ ɨmɨkaatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yɨɨsu akamenya gʉʉsi ganʉ bhaarɨ bharagambana, akabhabhuurya, “Kwakɨ imwɨ muriimonyerera kʉbha, mʉtaana ɨmɨkaatɨ? Mʉkɨɨrɨ komenya nʉʉrʉ kwobhoora kegero? Ndora zekoro zaanyu zɨbhɨɨrɨ kʉngʼu? ");
INSERT INTO ikz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kwakɨ mʉna amɨɨsʉ, mʉtakorora? Mʉna amatwɨ, nawe mʉtakwigwa? Nangʉ, ndora mʉtakuhiita? ");
INSERT INTO ikz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ribhaga rirya hanʉ nasunywirɨ ɨmɨkaatɨ ɨtaanʉ girya na kʉbhaha abhaatʉ bhɨkwɨ bhɨtaanʉ, mʉkabhiringa ɨbhɨhʉʉzʉ bhɨrɨnga bhya amasaajʉ?” Bhakabhuga, “Tʉkabhiringa ɨbhɨhʉʉzʉ ikumi na bhɨbhɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na hanʉ nasunywirɨ ɨmɨkaatɨ muhungatɨ na kʉbhaha abhaatʉ bhɨkwɨ bhene, mʉkabhiringa ɨbhɨhʉʉzʉ bhɨrɨnga bhya amasaajʉ?” Bhakabhuga, “Ɨbhɨhʉʉzʉ muhungatɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Akʉmara akabhabhuurya, “Mʉkɨɨrɨ kwobhoora?” ");
INSERT INTO ikz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yɨɨsu na abhɨɨga bhaazɨ bhakahika mʉrʉbhɨri rwa Bhɨtɨsaida. Abhaatʉ obhorebhe bhakareeta ʉmʉhʉku wʉmwɨ. Bhakasabha amukunʼyɨku na komohorya. ");
INSERT INTO ikz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yɨɨsu akamugwata okobhoko ʉmʉhʉku wurya, akaja nawe igʉtʉ wʉ ʉrʉbhɨri rurya. Akamutwɨra amatɨ kʉmɨɨsʉ, akamʉtʉʉrɨra amabhoko, akamubhuurya, “Nangʉ, ʉtangirɨ korora chʉchʉsi?” ");
INSERT INTO ikz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ʉmʉʉtʉ wurya akaramucha, akabhuga, “Nɨrarora abhaatʉ, nawe bhararorekana nchɨ ɨmɨtɨ gɨnʉ gekogenda.” ");
INSERT INTO ikz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yɨɨsu akatʉʉra amabhoko naatu kʉmɨɨsʉ, ʉmʉʉtʉ wurya akakaja korora. Akatʉra korora ebhegero bhyʉsi bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yɨɨsu akamʉbhʉʉrɨra, “Nuujɨ yɨɨka, ʉtahɨta mʉrʉbhɨri.” ");
INSERT INTO ikz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yɨɨsu na abhɨɨga bhaazɨ bhakabhʉʉka Bhɨtɨsaida, bhakaja zɨmbɨri za haguhɨ na Kaisaariya‑Firipi. Hanʉ bhaarɨ bharagenda kʉnzɨra, Yɨɨsu akabhabhuurya, “Abhaatʉ bharabhuga inyɨ nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakagarukirya, “Abhandɨ bharabhuga awɨ, ne‑Yoohana Ʉmʉbhatiizi, abhandɨ bharabhuga awɨ, nɨ‑Ɨɨriya, abhandɨ bharabhuga nɨ‑wʉmwɨ waho wa abharʉʉtɨrɨri bha Mungu abhandɨ bhɨ ɨkarɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ewe akabhabhuurya, “Na niimwɨ mʉrabhuga inyɨ, nɨ‑wɨɨwɨ?” Peetero akamʉgarukirya, “Awɨ, ni‑Kiriisitʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yɨɨsu akabhahama bhatagema kʉbhʉʉrɨra ʉmʉʉtʉ wʉwʉʉsi ewe nɨ‑wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Akʉmara Yɨɨsu akatanga kubhiija abhɨɨga bhaazɨ kʉbha, areenderwa Umwana wʉ Ʉmʉʉtʉ abhone ɨnyaakʉ kʉrʉ, angwɨ na abhakaruka, na abhakʉrʉ bha abhakuhaani, na abhiija bhi imigirʉ ja Musa, na iitwɨ. Nawe urusikʉ rwa katatʉ kwɨma ukukwa kwazɨ, araryʉka. ");
INSERT INTO ikz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yɨɨsu aarɨ arabhʉʉrɨra abhɨɨga bhaazɨ ringʼana riyo habhwɨrʉ. Nawe Peetero akamuhira rusizʉ, akatanga komorecha. ");
INSERT INTO ikz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yɨɨsu akiichʉra, akarora abhɨɨga bhaazɨ. Akahaarɨra Peetero, “Shɨtaani, nuurwɨ mʉbhʉtangɨ bhwanɨ! Amiisɨɨgi gaazʉ gatarɨ ga Mungu, nawe ga abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akabhɨrɨkɨra riribhita rya abhaatʉ hamwɨmwɨ na abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ areende kuntuna, areenderwa iyangɨ umwene, agege ʉmʉsarabha gwazɨ, antunɨ. ");
INSERT INTO ikz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ʉmʉʉtʉ wʉnʉ akwenda kohonʼya ʉbhʉhʉru bhwazɨ umwene, arabhurimirya. Nawe ʉmʉʉtʉ wʉnʉ akurimirya ʉbhʉhʉru bhwazɨ igʉrʉ waanɨ ni igʉrʉ wɨ Ɨngʼana Ɨnzʉmu, arabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ʉmʉʉtʉ arabhonakɨ, areebhone ubhuniibhi bhwʉsi mʉʉsɨ yɨnʉ, nawe arimiryɨ ʉbhʉhʉru bhwazɨ bhwa kemerano? ");
INSERT INTO ikz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nangʉ, ʉmʉʉtʉ aratʉra kuhuruchakɨ kobhona ʉbhʉhʉru bhwa kemerano? Kɨtareeho ekegero chʉchʉsi! ");
INSERT INTO ikz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hanʉ Umwana wʉ Ʉmʉʉtʉ ariikɨ na bhamaraika abharɨndu nʉ ʉbhʉkʉrʉ bhwa Wiisɨ, aramororera zɨsʉni ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akondorera inyɨ zɨsʉni na amiija gaanɨ, ribhaga rɨnʉ urwibhʉrʉ rʉnʉ rokokora ʉbhʉsarya na kwɨbha Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, bhareho abhaatʉ gatɨ waanyu hanʉ, bhanʉ bhatakukwa bhakɨɨrɨ korora Umwana wʉ Ʉmʉʉtʉ araaza mʉbhʉtɨmi bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hanʉ zaahitirɨ sikʉ isaasabha, Yɨɨsu akagega Peetero, Yaakobho na Yoohana, akaja hamwɨmwɨ nabhʉ kʉkɨgʉrʉ ɨkɨrɨɨhu bhakaja kekoro. Bhakarora Yɨɨsu ariichʉra ubhushʉ bhwazɨ mʉbhʉtangɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amiibhoho gaazɨ gakatanga kʉbharya bhʉkʉngʼu. Gakabha mɨɨrʉ ga pee, kʉkɨra chɨmbu umuhuri wʉwʉʉsi kʉʉsɨ kʉnʉ angahurirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bhakahwarʉka Ɨɨriya na Musa, abharʉʉtɨrɨri bhɨ ɨkarɨ, bharagambana na Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peetero ewe akabhʉʉrɨra Yɨɨsu, “Umwija, nɨ‑bhwaheene itwɨ tʉbhɨ hanʉ. Twʉmbakɨ ibhituku bhɨtatʉ, ɨkɨmwɨ ichazʉ, ɨkɨndɨ cha Musa nɨ ɨkɨndɨ cha Ɨɨriya.” ");
INSERT INTO ikz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ataamɨnyirɨ ryʉ ʉkʉgamba, kʉ kʉbha ewe na abhakɨndichazɨ bhakʉʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Neho bhakarora risaarʉ, rɨkabhakundikirya. Riraka rya Mungu rɨkarwa mwisaarʉ, rɨkabhuga, “Wʉnʉ ni‑Mwana waanɨ ʉmʉsɨɨgwa, mumwitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hanʉ abhɨɨga bharya bhaarʉʉzɨbhu ɨnʉ nɨ ɨnʉ, bhatarʉʉzɨ ʉmʉʉtʉ wʉndɨ, nawe Yɨɨsu umwene. ");
INSERT INTO ikz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hanʉ bhaarɨ bhakwika kʉkɨgʉrʉ kirya, Yɨɨsu akabharecha bhatabhʉʉrɨra ʉmʉʉtʉ wʉwʉʉsi ganʉ bhaarʉʉzɨ, kuhika hanʉ Umwana wʉ Ʉmʉʉtʉ akʉbha aryukirɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abhɨɨga bharya bhakarigwata ringʼana riyo, nawe bhakabha bhariibhuurya abheene kobheene, “Kuryʉka kwazɨ mʉbhaku, enzobhooro yaku nɨkɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakabhuurya Yɨɨsu, “Ndora abhiija bhi imigirʉ ja Musa bhahaabhuga, ereenderwa Ɨɨriya akangatɨrɨ Kiriisitʉ kuuza?” ");
INSERT INTO ikz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ewe akabhagarukirya, “Maheene Ɨɨriya areenderwa kuuza hinga korereke atʉʉrɨ bhwaheene amangʼana gʉʉsi. Nangabhabhu, kwakɨ yandikirwɨ mʉMaandɨkʉ Amarɨndu kʉbha, Umwana wʉ Ʉmʉʉtʉ aranyaaka bhʉkʉngʼu na koregwa? ");
INSERT INTO ikz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nawe nɨrabhabhʉʉrɨra kʉbha, Ɨɨriya izirɨ, bhʉʉsi bhakamokorera amabhɨ gʉʉsi ganʉ bhɨɨndirɨ, chɨmbu yandikirwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hanʉ Yɨɨsu, Peetero, Yoohana na Yaakobho bhaahikirɨ kʉbhɨɨga abhandɨ, bhakarora riribhita ikʉrʉ rya abhaatʉ ribhiiruguurirɨ. Abhiija bhi imigirʉ ja Musa bhaarɨ bharahakaana na abhɨɨga. ");
INSERT INTO ikz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hanʉ riribhita rirya ryarʉʉzɨ Yɨɨsu, bhʉʉsi bhakarʉgʉʉra. Rogendo rʉmwɨ bhakamuryarɨra, bhakamokeerya. ");
INSERT INTO ikz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yɨɨsu akabhabhuurya, “Mʉrahakaanɨrakɨ nabhʉ?” ");
INSERT INTO ikz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ʉmʉʉtʉ wʉmwɨ mwiribhita rirya akagarukirya, “Umwija, nɨmʉrɨɨtirɨ umwana waanɨ kwa naawɨ. Ana risambwa rɨnʉ rikugirya abhɨ imuumu. ");
INSERT INTO ikz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ibhaga ryʉsi hanʉ rɨhaamugwata, rɨramugwisha haasɨ. Ahaahurucha rihuru mumunywa, na kusha amɨɨnʉ na kʉhangarara ʉmʉbhɨrɨ. Nɨsabhirɨ abhɨɨga bhaazʉ bhamuruushɨ, nawe bhataaturirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yɨɨsu akabhuga, “Imwɨ urwibhʉrʉ rʉnʉ rʉtakwisirirya, rʉnʉ rurimiirɨ! Niriikara na niimwɨ na kubhiigumirirya kuhika ryʉrɨ? Niriikara na niimwɨ na kubhiigumirirya kuhika ryʉrɨ? Momoreete hanʉ umwana wuyo.” ");
INSERT INTO ikz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhakamuhira kwa Yɨɨsu. Nawe hanʉ risambwa ryarʉʉzɨ Yɨɨsu, hayohayo rɨkamoteemerya umwana wurya ririmu. Akagwa haasɨ, akiibharingʉrabharingʉra na kuhurucha rihuru. ");
INSERT INTO ikz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yɨɨsu akabhuurya wiisɨ umwana, “Ɨnyaakʉ yɨnʉ ɨtangirɨ kwɨma ryʉrɨ?” Wiisɨ akabhuga, “Kwɨma mubhwana bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Manga kaaru risambwa riyo rimugwishiryɨ momorero hamwɨ mʉmanzi korereke rimwitɨ. Nawe arɨɨbhɨ ʉranaja kokora ryʉryʉsi, tororere ɨbhɨgʉngi, ʉtʉsakiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yɨɨsu akamʉgarukirya, “Ʉrɨɨtʉrɨ! Gʉʉsi garatʉrɨkana kwa wʉnʉ akwisirirya.” ");
INSERT INTO ikz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rogendo rʉmwɨ wiisɨ umwana wurya akarɨra kwa nguru, arabhuga, “Niriisirirya! Nawe ubhwisirirya bhwanɨ bhʉtakwisa, nsakirya.” ");
INSERT INTO ikz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hanʉ Yɨɨsu aarʉʉzɨ riribhita rya abhaatʉ rɨraaruha kumwiruguura, akarɨhaarɨra risambwa rirya, akabhuga, “Awɨ risambwa! Ʉrakora umwana wʉnʉ kʉbha imuumu nu umuribhi wa amatwɨ. Nangʉ nɨrakʉbhʉʉrɨra, nuurwɨ kumwana wʉnʉ, na ʉtagema kumujaku kwikɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Neho risambwa rirya rɨkarɨgɨsa bhʉkʉngʼu, ririmu rɨkatiira, rɨkamurwɨku. Umwana akabha nkina akuurɨ, bhaaru harya bhakabhuga, “Akuurɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nawe, Yɨɨsu akamugwata okobhoko akamʉnʉnga, neewe akiimɨɨrɨra. ");
INSERT INTO ikz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mmbe hanʉ Yɨɨsu aasikiirɨ munyumba, abhɨɨga bhaazɨ bhakamubhuurya kwa rusizʉ, “Kwakɨ itwɨ tʉkatamwa kumuruusha risambwa?” ");
INSERT INTO ikz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yɨɨsu akabhabhʉʉrɨra, “Risambwa ncha rɨnʉ rɨtakʉtʉra koheebhwa taabhɨ kʉmasabhi.” ");
INSERT INTO ikz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yɨɨsu na abhɨɨga bhaazɨ bhakabhʉʉka iyo, bhakahɨtɨra gatɨgatɨ wi icharʉ cha Gariraaya. Yɨɨsu ataasɨɨgirɨ abhaatʉ bhamenye kʉbha ari iyo, ");
INSERT INTO ikz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kʉ kʉbha aarɨ arabhiija abhɨɨga bhaazɨ. Akabhabhʉʉrɨra, “Umwana wʉ Ʉmʉʉtʉ araja kuhurukibhwa mʉmabhoko ga abhaatʉ na bharamwita. Nawe urusikʉ rwa katatʉ kwɨma ukukwa kwazɨ, araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nawe, bhatʉʉbhʉʉrirɨ kɨnʉ Yɨɨsu aabhabhuuriirɨ, bhakʉʉbhaha kumubhuurya. ");
INSERT INTO ikz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yɨɨsu na abhɨɨga bhaazɨ bhakahika mʉrʉbhɨri rwa Kapɨrinaumu. Hanʉ bhaasikiirɨ munyumba, Yɨɨsu akabhabhuurya, “Mwarɨ mʉrahakaanɨrakɨ mʉnzɨra?” ");
INSERT INTO ikz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Neho abhɨɨga bhaazɨ bhakakira, kʉ kʉbha bhaarɨ bharahakaana abheene kobheene kʉnzɨra, wɨɨwɨ gatɨ waabhʉ ʉmʉkʉrʉ kʉkɨra abhakɨndichazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yɨɨsu akiikara haasɨ, akabhabhɨrɨkɨra abhɨɨga bhaazɨ ikumi na bhabhɨrɨ. Akabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ akwenda kʉbha ʉmʉkʉrʉ kwa bhʉʉsi areenderwa kwiyicha iyaasɨ, na kʉbha omohocha kwa bhʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akagega umwana, akamwimiirirya mʉbhʉtangɨ bhwabhʉ. Akamuhumbata, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araaginihyɨ umwana ncha wʉnʉ kuriina ryanɨ, aranginihya inyɨ. Nʉ ʉmʉʉtʉ wʉnʉ araanginihyɨ inyɨ, atakunginihya inyimwene. Amaheene araginihya Mungu wʉnʉ antumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoohana akamʉbhʉʉrɨra, “Umwija, tʉkamorora ʉmʉʉtʉ araruusha amasambwa kuriina ryazʉ. Itwɨ tʉkagema komorecha, kʉ kʉbha atarɨ hamwɨmwɨ na niitwɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yɨɨsu akabhuga, “Mʉtamorecha, kʉ kʉbha atareeho ʉmʉʉtʉ wʉnʉ areekore ɨkɨsɨgʉ kuriina ryanɨ, naatu hasuuhubhu kʉngamba inyɨ kɨbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ʉmʉʉtʉ wʉnʉ atakutwanga, arɨ hamwɨmwɨ na niitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ arɨɨbhahɨ amanzi nʉʉrʉ masuuhu gu ukunywa, kʉ kʉbha imwɨ, nɨ‑bhaatʉ bha Kiriisitʉ, nɨrabhabhʉʉrɨra amaheene, atakubhurwa ʉmʉbhanʉ gwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yɨɨsu akangʼeha kʉgamba, “Nawe wʉnʉ araahabhyɨ wʉmwɨ gatɨ wa abhasuuhu bhanʉ bhakunyiisirirya akore ʉbhʉbhɨ, ɨnyaakʉ yaazɨ ɨrabha kʉrʉ bhʉkʉngʼu. Hakɨrɨku abhoherwe ʉrʉbhwɨ mwigʉti na korekerwa mʉnyanza. ");
INSERT INTO ikz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Okobhoko kwazʉ kʉraagiryɨ okore ʉbhʉbhɨ, ʉkʉtɨnɨ. Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano no okobhoko kʉmwɨ, kʉkɨra kʉbha na amabhoko abhɨrɨ na kuja nyaari, momorero gʉnʉ gʉtakurima.  ");
INSERT INTO ikz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Iyo neyo zenyende zɨtakukwa, no omorero gwayo gʉtakurima. ");
INSERT INTO ikz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ʉkʉgʉrʉ kwazʉ kʉraagiryɨ okore ʉbhʉbhɨ, ʉkʉtɨnɨ. Nɨ‑hakɨrɨku usikɨrɨ mʉbhʉhʉru bhwa kemerano no obhorema bhwʉ ʉkʉgʉrʉ kʉmwɨ, kʉkɨra kʉbha na amagʉrʉ abhɨrɨ na korekerwa nyaari.  ");
INSERT INTO ikz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Iyo neyo zenyende zɨtakukwa, no omorero gwayo gʉtakurima. ");
INSERT INTO ikz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iriisʉ ryazʉ rɨraagiryɨ okore ʉbhʉbhɨ, ryihɨ. Nɨ‑hakɨrɨku usikɨrɨ ne esongo mʉbhʉtɨmi bhwa Mungu, kʉkɨra kʉbha na amɨɨsʉ abhɨrɨ na korekerwa momorero gwa nyaari. ");
INSERT INTO ikz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iyo neyo zenyende zɨtakukwa, no omorero gwayo gʉtakurima. ");
INSERT INTO ikz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mungu arahitya abhaatʉ bhʉʉsi mʉzɨnyaakʉ zɨnʉ zituubhɨɨnɨ no omorero, ncha abhaatʉ bhakʉhaka ʉmʉʉnyʉ kʉnyama yi ikimweso yɨnʉ ɨkɨɨrɨ kurichwa. ");
INSERT INTO ikz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ʉmʉʉnyʉ nɨ‑mʉzʉmu, nawe guriibhuryɨ ʉbhʉsambaruku bhwagwɨ, mʉragʉtʉʉrɨra kɨgʉrʉkɨ korereke gozome naatu? Na niimwɨ mʉbhɨ nchʉ ʉmʉʉnyʉ gʉnʉ gugwatirɨ, mʉbhɨ nu ubhwigwani abheene kobheene.” ");
INSERT INTO ikz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Neho Yɨɨsu na abhɨɨga bhaazɨ bhakabhʉʉka Kapɨrinaumu, bhakaja mucharʉ cha Yudeya. Bhakahɨta bhakaambʉka ɨkɨtaarʉ cha Yorodaani. Iyo amaribhita makʉrʉ ga abhaatʉ bhaarɨ bharamwiruguura naatu, na aarɨ arabhiija chɨmbu aanarirɨ kokora. ");
INSERT INTO ikz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mmbe, Abhafarisaayo bhakamujaku komogema. Bhakamubhuurya, “Awɨɨ, nɨ‑bhwaheene umusubhɨ kʉtaana na mʉkaazɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wʉʉsi akabhagarukirya, “Musa akabhaswaja migirʉkɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhakamʉgarukirya, bhakabhuga, “Musa akiisirirya umusubhɨ amwandɨkɨrɨ mʉkaazɨ ɨnyarʉbha yʉ ʉkʉtaana.” ");
INSERT INTO ikz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yɨɨsu akabhabhʉʉrɨra, “Musa akabhaandɨkɨra riswaja riyo kʉ kʉbha yʉ ʉbhʉkʉngʼu bhwi imyʉyʉ janyu. ");
INSERT INTO ikz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nawe, kwɨma ʉbhʉtangɨ bhwo okoteemwa ɨɨsɨ, ‘Mungu akabhʉmba umusubhɨ nʉ ʉmʉkari.’ ");
INSERT INTO ikz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Igʉrʉ wa gayo, umusubhɨ aratiga wiisɨ na unina, aragwatana na mʉkaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bhabhɨrɨ bhayo bharabha mʉbhɨrɨ gʉmwɨ.’ Na bhatakʉbha bhabhɨrɨ kwikɨ, nawe nɨ‑mʉbhɨrɨ gʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mmbe, kɨnʉ kɨgwataniibhwɨ na Mungu, mʉʉtʉ atakɨtaanʼya.” ");
INSERT INTO ikz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hanʉ bhaasikiirɨ naatu munyumba, abhɨɨga bhaazɨ bhakamubhuurya igʉrʉ wɨ ɨngʼana yiyo. ");
INSERT INTO ikz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Akabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ araatigɨ mʉkaazɨ na kukwɨra ʉwʉndɨ, arasebheeta kʉmʉkari we embere. ");
INSERT INTO ikz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nʉ ʉmʉkari wʉnʉ araatigɨ umusubhɨ waazɨ na kukwɨrwa nu umusubhɨ ʉwʉndɨ, arasimbɨha kumusubhɨ we embere.” ");
INSERT INTO ikz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Abhaatʉ bhaarɨ bharareetera Yɨɨsu abhaana abhasuuhu abhatʉʉrɨrɨ amabhoko. Nawe abhɨɨga bhaazɨ bhakabhahaarɨra. ");
INSERT INTO ikz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hanʉ Yɨɨsu aabharʉʉzɨ abhɨɨga bhaazɨ bharakorabhu, akiigatana. Akabhabhʉʉrɨra, “Mʉbhatigɨ abhaana abhasuuhu bhaazɨ kwa niinyɨ, mʉtabharecha, kʉ kʉbha ʉbhʉtɨmi bhwa Mungu ni‑bhwa bhanʉ bhaangɨ ncha abhaana. ");
INSERT INTO ikz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nɨrabhabhʉʉrɨra amaheene, wʉwʉʉsi wʉnʉ atakwisirirya ʉbhʉtɨmi bhwa Mungu nchu umwana umusuuhu, atakusikɨra zee mʉbhʉtɨmi bhuyo.” ");
INSERT INTO ikz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Neho akabhahumbata abhaana bhayo, akabhatʉʉrɨra amabhoko, akabhahaka. ");
INSERT INTO ikz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hanʉ Yɨɨsu aatangirɨ kuja, ʉmʉʉtʉ wʉmwɨ akamuryarɨra, akamuhigamɨra. Akamubhuurya, “Umwija ʉmʉzʉmu, nekorebhwɨ, korereke nɨgabhɨ ʉbhʉhʉru bhwa kemerano?” ");
INSERT INTO ikz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yɨɨsu akamʉgarukirya, “Kwakɨ ʉrambɨrɨkɨra ʉmʉzʉmu? Atareeho ʉmʉʉtʉ ʉmʉzʉmu, kuruushaku Mungu umwene. ");
INSERT INTO ikz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nawe nangʉ, ʉjɨzɨ imigirʉ ja Mungu gɨnʉ gikubhuga, ‘Utiita, ʉtasebheeta, utiibha, ʉtagobha mʉʉtʉ, ʉtakangirirya, ʉsʉʉkɨ wuusʉ na onyoko.’” ");
INSERT INTO ikz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ʉmʉʉtʉ wurya akabhuga, “Umwija, giyo jʉsi nɨgɨgwatirɨ kwɨma mubhwana bhwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yɨɨsu akamorora, akamʉsɨɨga, akamʉbhʉʉrɨra, “Usuuhiirwɨ ekegero kɨmwɨ. Nuujɨ uguryɨ ebhegero bhyʉsi bhɨnʉ ʉnabhyʉ, zimpirya ziyo ʉbhahɨ abhahabhɨ, na ʉrabha ni ikibhumbɨkʉ kwa Mungu. Akʉmara uuzɨ untunɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nawe, hanʉ iigwirɨbhu, akarʉgʉʉra. Akaja arumikirɨ bhʉkʉngʼu, kʉ kʉbha aarɨ ne ebhegero bhyaru. ");
INSERT INTO ikz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yɨɨsu akarora mbaara zʉʉsi, akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Kʉrabha kʉkʉngʼu kʉbhaniibhi kusikɨra mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abhɨɨga bhaazɨ bhakarʉgʉʉra kʉmangʼana gaazɨ. Akabhabhʉʉrɨra naatu, “Abhaana bhaanɨ, morore chɨmbu nɨ‑kʉkʉngʼu kusikɨra mʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nɨ‑kʉnyʉʉhu ɨngamiya kʉhɨta mwibhanga ryi isindanʉ, kʉkɨra umuniibhi kusikɨra mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abhɨɨga bhaazɨ bhakarʉgʉʉra bhʉkʉngʼu kwa ringʼana riyo. Bhaarɨ bhariibhuurya abheene kobheene, “Nangʉ, nɨ‑wɨɨwɨ wʉnʉ akʉtʉra kʉsabhurwa?” ");
INSERT INTO ikz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yɨɨsu akabharora, akabhabhʉʉrɨra, “Kʉbhaatʉ gatakʉtʉrɨkana, nawe kwa Mungu gʉʉsi garatʉrɨkana.” ");
INSERT INTO ikz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peetero akamʉbhʉʉrɨra, “Rora, itwɨ tutigirɨ ebhegero bhyʉsi, tukutunirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉnʉ atigirɨ inyumba, umwabhʉ, umusubhaati, unina, wiisɨ, abhaana, hamwɨ ɨmɨgʉndʉ, igʉrʉ waanɨ ni igʉrʉ wɨ Ɨngʼana Ɨnzʉmu, ");
INSERT INTO ikz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Mungu aramoha bhyaru bhʉkʉngʼu kʉkɨra bhirya. Nangʉ kwibhaga rɨnʉ, arasʉngʼaana zinyumba, bhaumwabhʉ, abhasubhaati, bhaunina, abhaana nɨ ɨmɨgʉndʉ. Hamwɨmwɨ na gayo gʉʉsi, arabha nɨ ɨnyaakʉ. Nɨ ɨɨsɨ yɨnʉ ikuuza, arasʉngʼaana ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nawe, abhaatʉ bhaaru bhanʉ bhakusuukwa ribhaga rɨnʉ, bhatakusuukwa ribhaga rɨnʉ rikuuza. Na bhanʉ bhatakusuukwa ribhaga rɨnʉ, bharasuukwa ribhaga rɨnʉ rikuuza.” ");
INSERT INTO ikz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaarɨ kʉnzɨra kuja mʉrʉbhɨri rwa Yɨrusarɨɨmu, Yɨɨsu aarɨ arakangata mʉbhʉtangɨ bhwabhʉ. Abhɨɨga bha Yɨɨsu bhakarʉgʉʉra, na abhaatʉ abhandɨ bhanʉ bhaarɨ bharamutuna, bhaarɨ nu ubhwʉbha. Yɨɨsu akabhabhɨrɨkɨra naatu rusizʉ abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akatanga kʉbhabhʉʉrɨra ganʉ gareemobhone. ");
INSERT INTO ikz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akabhuga, “Rora, tʉraja Yɨrusarɨɨmu. Iyo, Umwana wʉ Ʉmʉʉtʉ aragwatwa na kuhirwa kʉbhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa. Bhayo bharatɨnɨra iitwɨ, na bharamuhira kʉBharuumi. ");
INSERT INTO ikz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Abhaatʉ bhayo bharamorega na kumutwɨra amatɨ. Bharamotema ɨmɨzariti na kumwita. Nawe, urusikʉ rwa katatʉ, araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yaakobho na Yoohana, abhaana bha Zebhedaayo, bhakiisukɨra Yɨɨsu, bhakamʉbhʉʉrɨra, “Umwija, tʉrasabha otokorere ryʉryʉsi rɨnʉ tʉrɨɨkʉsabhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yɨɨsu akabhabhuurya, “Moreenda nɨbhakorerekɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakamʉbhʉʉrɨra, “Utwisiririryɨ kwikara hamwɨmwɨ na naawɨ mʉbhʉgʉngʉ bhwazʉ, wʉmwɨ ʉrʉbhaara rwu ubhuryʉ nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi.” ");
INSERT INTO ikz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yɨɨsu akabhabhʉʉrɨra, “Mʉtɨɨzɨ kɨnʉ mʉkʉsabha. Nangʉ, mʉratʉra kunywa ekekombe chɨ ɨnyaakʉ kɨnʉ nikunywa, kisha mʉratʉra kʉbhatiizwa ʉbhʉbhatiizi bhu ukukwa bhʉnʉ nɨraabhatiizwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakamʉgarukirya, “Tʉratʉra.” Yɨɨsu akabhabhʉʉrɨra, “Maheene, mʉrakinywɨra ekekombe chɨ ɨnyaakʉ yɨnʉ inyɨ nɨkʉnyaaka, na kʉbha ni ibhaga ikʉngʼu nchi iryanɨ. ");
INSERT INTO ikz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nawe kwikara ʉrʉbhaara rwanɨ rwu ubhuryʉ hamwɨ rwʉ ʉbhʉmʉsi gɨtarɨ emeremo janɨ kubhiisiririrya. Umweya guyo nɨ‑kʉ bhanʉ Mungu amarirɨ kokonzera.” ");
INSERT INTO ikz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hanʉ abhɨɨga abhakɨndichabhʉ ikumi bhiigwirɨ gayo, bhakatanga kubhiigatanɨra Yaakobho na Yoohana. ");
INSERT INTO ikz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Neho Yɨɨsu akabhɨrɨkɨra abhɨɨga bhʉʉsi, bhiisukɨ kwawɨ. Akabhabhʉʉrɨra, “Mwɨzɨ kʉbha abhakangati bhi ibhyarʉ bharakangata abhaatʉ bhaabhʉ kwa amanaga, na abhakʉrʉ bhaabhʉ bharabhahocha emeremo. ");
INSERT INTO ikz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nawe kwa niimwɨ, ɨtakʉbhabhu. Ʉmʉʉtʉ wʉnʉ akwenda kʉbha ʉmʉkʉrʉ waanyu, areenderwa kʉbha omohocha waanyu. ");
INSERT INTO ikz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nʉ ʉmʉʉtʉ wʉnʉ akwenda kʉbha we embere gatɨ waanyu, areenderwa kʉbha mbʉʉsa waanyu. ");
INSERT INTO ikz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nu Umwana wʉ Ʉmʉʉtʉ atiizirɨ kʉhʉkɨribhwa, nawe akaaza kohokerya abhaatʉ na kuhurucha ʉbhʉhʉru bhwazɨ bhʉbhɨ ubhutuurya kʉbhaatʉ abhaaru.” ");
INSERT INTO ikz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mmbe bhakahika kʉrʉbhɨri rwa Yɨriko, na hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaabhuukirɨ Yɨriko, riribhita ikʉrʉ rya abhaatʉ rɨkabhatuna. Mʉnzɨra iyo bhakabhona ʉmʉʉtʉ wʉmwɨ iriina ryazɨ Bharitimaayʉ, umwana wa Timaayʉ. Ʉmʉʉtʉ wuyo aarɨ mʉhʉku. Akiikara rusizʉ wɨ ɨnzɨra arasabha zimpirya. ");
INSERT INTO ikz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hanʉ iigwirɨ kʉbha Yɨɨsu wa Nazarɨɨti arahɨta harya, akatanga kʉrɨra kwiraka ikʉrʉ, “Yɨɨsu, Umwana wʉ ʉmʉtɨmi Daudi, ndorera ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abhaatʉ bhaaru bhakamʉhaarɨra kʉbha akirɨ. Nawe ewe akangʼeha kʉrɨra kwiraka ikʉrʉ bhʉkʉngʼu, “Umwana wʉ ʉmʉtɨmi Daudi, ndorera ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Neho Yɨɨsu akiimɨɨrɨra, akabhuga, “Mʉmʉbhɨrɨkɨrɨ aazɨ hanʉ.” Bhakamʉbhɨrɨkɨra, bhakamʉbhʉʉrɨra, “Ihaana umwʉyʉ, imɨɨrɨra! Arakʉbhɨrɨkɨra.” ");
INSERT INTO ikz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Akataasha engebho yaazɨ haasɨ, akabhʉʉka bhwangʉ, akaja kwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yɨɨsu akamubhuurya, “Oreenda nekokorerekɨ?” Ʉmʉhʉku wurya akamʉbhʉʉrɨra, “Umwija, nereenda nerore.” ");
INSERT INTO ikz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yɨɨsu akabhuga, “Nuujɨ, ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ.” Hayohayo, akatanga korora, akatuna Yɨɨsu kʉnzɨra. ");
INSERT INTO ikz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhiisɨmɨɨrɨ ʉrʉbhɨri rwa Yɨrusarɨɨmu, bhakahika haguhɨ kʉzɨmbɨri za Bhɨtifagɨ na Bhɨtaniya, kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. Yɨɨsu akatʉma bhabhɨrɨ mʉbhɨɨga bhaazɨ, ");
INSERT INTO ikz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akabhuga, “Mujɨ mʉrʉbhɨri rʉnʉ rore embere waanyu. Hanʉ mukusikɨra iyo, mʉrabhona umwana wɨ ɨtɨkɨrɨ, wʉnʉ akɨɨrɨ kogega mʉʉtʉ, abhʉhirwɨ. Mʉmʉtazʉrɨ, momoreete hanʉ. ");
INSERT INTO ikz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nʉ ʉmʉʉtʉ wʉwʉʉsi araabhabhuuryɨ, ‘Kwakɨ mʉrakorabhu?’ mʉmʉbhʉʉrɨrɨ, ‘Ʉmʉkʉrʉ aramwenda, aramʉgarucha nangwɨnʉbhu.’ ” ");
INSERT INTO ikz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mmbe bhakaja, bhakabhona umwana wɨ ɨtɨkɨrɨ abhʉhirwɨ igʉtʉ wi ikisikʉ kʉnzɨra ɨkʉrʉ, bhakamʉtazʉra. ");
INSERT INTO ikz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abhaatʉ obhorebhe kʉbhanʉ bhaarɨ bhiimiiriirɨ harya, bhakabhabhuurya, “Imwɨ! Kwakɨ mʉratazʉra umwana wɨ ɨtɨkɨrɨ wuyo?” ");
INSERT INTO ikz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Abhɨɨga bharya bhakagarukirya chɨmbu Yɨɨsu aarɨ abhabhuuriirɨ bhabhugɨ. Mmbe abhaatʉ bhayo bhakabhiisiririrya. ");
INSERT INTO ikz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakahira umwana wɨ ɨtɨkɨrɨ kwa Yɨɨsu, na kwara zengebho zaabhʉ igʉrʉ wɨ ɨtɨkɨrɨ yiyo. Yɨɨsu akiikara igʉrʉ wayʉ. ");
INSERT INTO ikz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abhaatʉ bhaaru bhakaara zengebho zaabhʉ kʉnzɨra, abhandɨ bhakatɨna amatʉʉtʉ mʉmɨgʉndʉ na kwara kʉnzɨra igʉrʉ wʉ ʉkʉsʉʉka Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abhaatʉ obhorebhe bhaarɨ bharakangatɨra Yɨɨsu, abhandɨ bhaarɨ bharamutuna inyuma. Bhʉʉsi bhaarɨ bharatiirya riraka bharabhuga, “Akumibhwɨ! Anʉ ʉrʉbhangʉ wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ! ");
INSERT INTO ikz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anʉ ʉrʉbhangʉ Ʉmʉtɨmi wʉ ʉbhʉtɨmi bhwa sʉʉkʉrʉ wɨɨtʉ Daudi bhʉnʉ bhukuuza! Akumibhwɨ Mungu wa mwisaarʉ!” ");
INSERT INTO ikz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yɨɨsu akasikɨra Yɨrusarɨɨmu, akaja, akasikɨra mwihekaaru. Akabherora bhwaheene ebhegero bhyʉsi bhɨnʉ bhyarɨ bhirimu. Nawe kʉ kʉbha yaarɨ rigoroobha, akabhʉʉka, akaja hamwɨmwɨ na abhɨɨga bhaazɨ ikumi na bhabhɨrɨ Bhɨtaniya. ");
INSERT INTO ikz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hanʉ tabhʉʉri waho Yɨɨsu na abhɨɨga bhaazɨ bhaarɨ bhararwa Bhɨtaniya, kʉgarʉka Yɨrusarɨɨmu, ɨnzara ɨkamurya. ");
INSERT INTO ikz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akarora umutiini kwa kore, gʉnʉ gwarɨ guguutirɨ. Akagwisukɨra arore arɨɨbhɨ guni imisumʉ. Hanʉ aahikirɨ harya, akabhona gʉtaana imisumʉ, gwizwirɨ amatʉʉtʉ ageene, kʉ kʉbha ribhaga ryu ukutwara ryarɨ rɨkɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mmbe akagʉbhʉʉrɨra ʉmʉtɨ gurya, “Kwɨma reero utiibhʉra misumʉ, kemerano.” Abhɨɨga bhaazɨ bhakiigwa amangʼana garya. ");
INSERT INTO ikz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hanʉ bhaahikirɨ Yɨrusarɨɨmu, Yɨɨsu akasikɨra mwihekaaru. Akatanga koheebha abhaatʉ bhanʉ bhaarɨ bhakugurya, na kʉgʉra ebhegero. Akabharingʉra zemeeza za bhanʉ bhaarɨ bhakʉkɨranʼya zimpirya, ni ibhitumbɨ bhya bhanʉ bhaarɨ bhakugurya ibhiguuti. ");
INSERT INTO ikz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na atamwisiririiryɨ ʉmʉʉtʉ wʉwʉʉsi kogega ekegero chʉchʉsi chu ukugurya kʉhɨta mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Akʉmara Yɨɨsu akabhiija, akabhuga, “Ɨtaandikirwɨ mʉMaandɨkʉ Amarɨndu kʉbha, ‘Inyumba yaanɨ ɨrabha ya amasabhi kʉbhaatʉ bhi ibhyarʉ bhyʉsi?’ Nawe imwɨ, mʉyɨkʉrirɨ kʉbha ribhigi rya abhasaakuri!” ");
INSERT INTO ikz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hanʉ abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa bhiigwirɨ gayo gʉʉsi, bhakatanga komohya ɨnzɨra yu kumwita kʉ kʉbha bhaarɨ bharamʉhaha. Na bhakamwʉbhaha, kʉ kʉbha abhaatʉ bhʉʉsi bhaarɨ bhararuguuribhwa na amiija gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hanʉ rigoroobha ryahikirɨ, Yɨɨsu na abhɨɨga bhaazɨ bhakabhʉʉka mʉrʉbhɨri. ");
INSERT INTO ikz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hanʉ ritabhʉʉri ryaho bhaarɨ bhakʉgarʉka mʉrʉbhɨri rwa Yɨrusarɨɨmu, bhakabhona ʉmʉtɨ gurya gwu umutiini gwumirɨ gwʉsi kwɨmɨra kumiri jaku. ");
INSERT INTO ikz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peetero akahiita amangʼana ganʉ Yɨɨsu aagambirɨ, akamʉbhʉʉrɨra, “Umwija, rora! Ʉmʉtɨ gwu umutiini gʉnʉ wihiimirɨ, gwumirɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yɨɨsu akabhabhʉʉrɨra, “Mwisiriryɨ Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ ʉmʉʉtʉ ariisirirya na ataana makɨbhwɨ mumwʉyʉ gwazɨ, rɨnʉ araabhugɨ rɨrakorwa. Aratʉra kʉbhʉʉrɨra ɨkɨgʉrʉ kɨnʉ, ‘Ihɨka witaashɨ mʉnyanza,’ na gayo garakorwa. ");
INSERT INTO ikz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Igʉrʉ wa gayo nɨrabhabhʉʉrɨra kʉbha, hanʉ mokosengera na kʉsabha chʉchʉsi, mʉbhɨ nu ubhwisirirya kʉbha mʉsʉngʼaanirɨ, na niimwɨ mʉrabhona. ");
INSERT INTO ikz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na hanʉ mʉkʉsabha, mobheerere wʉwʉʉsi wʉnʉ abhasaririiryɨ. Neho Bhaabha waanyu wa mwisaarʉ arabhabheerera amabhɨ gaanyu.  ");
INSERT INTO ikz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nawe arɨɨbhɨ imwɨ mʉtakobheerera abhandɨ, na Wuusʉ wa mwisaarʉ atakʉbhabheerera ʉbhʉbhɨ bhwanyu.” ");
INSERT INTO ikz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yɨɨsu na abhɨɨga bhaazɨ bhakahika naatu Yɨrusarɨɨmu. Hanʉ bhaarɨ bharagenda mwihekaaru, abhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ ja Musa na abhakaruka bhakamujaku ");
INSERT INTO ikz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kumubhuurya, “Ganʉ okokora, ʉrakora kwa bhʉnajakɨ? Nɨ‑wɨɨwɨ wʉnʉ akʉhɨɨrɨ ʉbhʉnaja bhwo okokora gayo?” ");
INSERT INTO ikz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yɨɨsu akabhuga, “Na niinyɨ nɨrabhabhuurya ringʼana rɨmwɨ, mʉngarukiryɨ, akʉmara nɨrabhabhʉʉrɨra, nɨrakora gayo kʉbhʉnaja bhwa wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mʉmbʉʉrɨrɨ, ʉbhʉnaja bhwa Yoohana bhwʉ ʉkʉbhatiiza, bhʉkarwa hayi? Bhʉkarwa kwa Mungu wa mwisaarʉ kisha kʉbhaatʉ?” ");
INSERT INTO ikz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhakatanga kʉgambana abheene kobheene, “Tʉraabhugɨ, ‘Bhʉkarwa mwisaarʉ,’ aratubhuurya, ‘Nangʉ, ndora mʉtamwisiriiryɨ?’ ");
INSERT INTO ikz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nawe, tʉraabhugɨ, ‘Bhʉkarwa kʉbhaatʉ,’ abhaatʉ bharatwigatanɨra.” Bhaarɨ bharʉʉbhaha abhaatʉ, kʉ kʉbha abhaatʉ bhʉʉsi bhakamwisirirya Yoohana aarɨ ʉmʉrʉʉtɨrɨri wa amaheeneheene. ");
INSERT INTO ikz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Neho bhakamʉgarukirya, “Tʉtɨɨzɨ.” Wʉʉsi akabhabhʉʉrɨra, “Na niinyɨ nɨtakʉbhabhʉʉrɨra nɨrakora amangʼana ganʉ kwa bhʉnajakɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yɨɨsu akatanga kʉgambana na abhakangati bha Abhayaahudi bharya kobherenjo. Akabhuga, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ wʉnʉ aarimirɨ ʉmʉgʉndʉ gwɨ ɨmɨzabhiibhu. Akagʉbhagɨra, akatuka ikisima chu ukugundɨkɨra ɨmɨzabhiibhu girya. Akʉʉmbaka ɨkɨkʉngʉ ɨkɨrɨɨhu cha abhariibhi mʉmʉgʉndʉ. Akakʉʉdishirya abharimi. Ewe akaja icharʉ ɨkɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ribhaga ryu ukutwa zɨzabhiibhu rɨkahika, akamʉtʉma wʉmwɨ wa bhambʉʉsa bhaazɨ kʉbharimi bharya, bhamohe esondo yaazɨ ya zɨzabhiibhu kurwa mʉmʉgʉndʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nawe, abharimi bhakagwata mbʉʉsa, bhakamotema, bhakamuhurucha mabhoko bhʉʉha. ");
INSERT INTO ikz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wʉ ʉmʉgʉndʉ akatʉma mbʉʉsa ʉwʉndɨ kʉbharimi. Wʉʉsi bhakamotema na kʉmʉnyahaara kumutwɨ, na komokorera kɨbhɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akatʉma mbʉʉsa waazɨ ʉwʉndɨ, wʉʉsi abharimi bhakamwita. Akabhatʉma bhambʉʉsa bhaazɨ abhandɨ bhaaru. Abharimi bharya bhakabhatema, abhandɨ bhakabhiita. ");
INSERT INTO ikz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wʉ ʉmʉgʉndʉ akasaaga na wʉmwɨ, umwana waazɨ ʉmʉsɨɨgwa. Ɨtɨnɨrʉ akamʉtʉma kʉbharimi bharya, akiiseega, ‘Bharamʉsʉʉka umwana waanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nawe, hanʉ aahikirɨ, abharimi bharya bhakiibhʉʉrɨra, ‘Wʉnʉ newe ʉmʉgabhi wʉ ʉmʉgʉndʉ gʉnʉ. Nangʉ, tumwitɨ. Ɨgabhʉ yaazɨ yɨnʉ ɨrabha iyɨɨtʉ.’ ");
INSERT INTO ikz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bhakamugwata, bhakamwita, bhakamorekera igʉtʉ wʉ ʉmʉgʉndʉ gurya. ");
INSERT INTO ikz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Nangʉ wʉ ʉmʉgʉndʉ wuyo arakorabhwɨ? Araaza na kubhiita abharimi bharya, nʉ ʉmʉgʉndʉ guyo, arabhaha abhaatʉ abhandɨ. ");
INSERT INTO ikz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nangʉ, mʉkɨɨrɨ kosoma Amaandɨkʉ ganʉ? ‘Riibhwɨ rɨnʉ abhʉʉmbaki bhaangirɨ, neryo rɨbhɨɨrɨ riibhwɨ rikʉrʉ rya rusizʉ. ");
INSERT INTO ikz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ʉmʉkʉrʉ umwene akʉrirɨ ganʉ, nego gararuguurya kwa niitwɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ ja Musa na abhakʉrʉ, bhakoobhoora kʉbha ekerenjo kiyo nebho kɨkʉgambɨra. Neho bhakeenda kumugwata, nawe kʉ kʉbha bhakʉʉbhaha riribhita rya abhaatʉ, bhakamutiga, bhakabhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Neho abhakʉrʉ bha Abhayaahudi, bhakatʉma Abhafarisaayo obhorebhe na abhasakirya bha riribhita ryʉ ʉmʉtɨmi Heroode Antipaasi, bhahaatyɨ Yɨɨsu kʉrɨngʼaana na amangʼana gaazɨ umwene. ");
INSERT INTO ikz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhakamujaku, bhakamʉbhʉʉrɨra, “Umwija, tʉmɨnyirɨ kʉbha, gʉʉsi ganʉ ukubhuga, nɨ‑ga amaheene. Ʉtakwʉbhaha wʉwʉʉsi, nʉʉrʉ abhɨ nu umweya gwi igʉrʉ. Uriija ɨnzɨra ya Mungu kʉmaheene. Nangʉ, kʉrɨngʼaana ni imigirʉ ja Musa, toreenderwa kʉrɨha rigʉʉti kwa Kaisaari, kisha zɨyi?” ");
INSERT INTO ikz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nawe Yɨɨsu akoobhoora engʼeera yaabhʉ, akabhabhʉʉrɨra, “Kwakɨ mʉrangema? Mondeetere rizenzere nerore.” ");
INSERT INTO ikz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhakamuhirɨra, akabhabhuurya, “Ipicha yɨnʉ ni riina rɨnʉ, ni‑bhya wɨɨwɨ?” Bhakamʉgarukirya, “Bhya Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yɨɨsu akabhabhʉʉrɨra, “Bhya Kaisaari mohe Kaisaari, na bhya Mungu mohe Mungu.” Bhʉʉsi bhakarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kwarɨ na riribhita rɨmwɨ rya Abhayaahudi rɨnʉ rikubhirikirwa Abhasadukaayo. Ebho bhaarɨ bharabhuga kuryʉka kwa abhaku kʉtareeho. Urusikʉ rʉmwɨ, obhorebhe bhwabhʉ bhakaja kwa Yɨɨsu, bhakamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Umwija, Musa akatʉtʉma, ‘Arɨɨbhɨ ʉmʉʉtʉ akuurɨ, na atigirɨ ʉmʉkari waazɨ ataana umwana, umuhiiri waazɨ agabhɨ umukwirwa wuyo, amwibhʉrɨrɨ abhaana umwabhʉ wʉnʉ akuurɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nangʉ, tubhugɨ bhaareho abhahiiri muhungatɨ. We embere akakwɨra ʉmʉkari, nawe akakwa aarɨ akɨɨrɨ kwibhʉra mwana. ");
INSERT INTO ikz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Umunyi waazɨ akagabha ʉmʉkari wuyo, nawe wʉʉsi akakwa, ataatigirɨ mwana. Na wa katatʉ ɨkabhabhu. ");
INSERT INTO ikz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bhʉʉsi bhasaasabha bhanʉ bhaamʉgabhirɨ na wurya aamukwɨrirɨ, bhakakwa, bhataatigirɨ mwana. Ɨtɨnɨrʉ, ʉmʉkari wuyo wʉʉsi akakwa. ");
INSERT INTO ikz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nangʉ tʉbhʉʉrɨrɨ, hanʉ abhaku bhakuryʉka, ʉmʉkari wuyo arabha mʉka wɨɨwɨ? Muhungatɨ bhayo bhʉʉsi bhaarɨ bhamukwɨrirɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yɨɨsu akabhabhʉʉrɨra, “Imwɨ mubhurirɨ, kʉ kʉbha mʉtɨɨzɨ Amaandɨkʉ Amarɨndu naabha ʉbhʉnaja bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hanʉ abhaku bhakuryʉka, bharabha ncha bhamaraika bha mwisaarʉ bhatakukwɨra naabha kukwɨrwa. ");
INSERT INTO ikz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ni igʉrʉ wa abhaku kuryʉka, nɨ‑maheene. Nangʉ, mʉkɨɨrɨ kosoma mʉkɨtabhʉ cha Musa, chɨmbu Mungu aagambirɨ kʉkɨsaka kɨnʉ kikwaka omorero? Hanʉ Mungu aamubhuuriirɨ Musa, ‘Inyɨ ni‑Mungu wa Abhurahaamu, Iisaka na Yaakobho.’ ");
INSERT INTO ikz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mungu nɨ‑wa abhahʉru, atarɨ Mungu wa abhaku. Imwɨ mubhurirɨ bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hanʉ Yɨɨsu aarɨ arahakaana na Abhasadukaayo, umwija wʉmwɨ wi imigirʉ ja Musa akahika, akiigwa kɨnʉ bhakʉhakaana. Hanʉ igwirɨ kʉbha Yɨɨsu abhagarukiiryɨ bhwaheene, akamubhuurya, “Mʉmaswaja gʉʉsi, ryʉ ʉbhʉtangɨ ni‑ryahe?” ");
INSERT INTO ikz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yɨɨsu akamʉgarukirya, “Ryʉ ʉbhʉtangɨ nɨ‑rɨnʉ, ‘Mwitegeerere imwɨ Abhiiziraɨri! Ʉmʉkʉrʉ Mungu wɨɨtʉ, newe Ʉmʉkʉrʉ umwene. ");
INSERT INTO ikz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ʉmʉsɨɨgɨ Ʉmʉkʉrʉ Mungu waazʉ kumwʉyʉ gwazʉ gwʉsi, kokoro yaazʉ yʉʉsi, kʉmangʼɨɨni gaazʉ gʉʉsi na kʉmanaga gaazʉ gʉʉsi.’ ");
INSERT INTO ikz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na rya kabhɨrɨ nɨ‑rɨnʉ, ‘Ʉmʉsɨɨgɨ nyarʉbhɨri waazʉ chɨmbu wisɨɨgirɨ aumwene.’ Rɨtareeho iswaja rɨndɨ ikʉrʉ kʉkɨra abhɨrɨ gayo.” ");
INSERT INTO ikz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Umwija wi imigirʉ wuyo akabhʉʉrɨra Yɨɨsu, “Umwija, ʉgambirɨ amaheene kʉbha Mungu nɨ‑wʉmwɨbhu, atareeho wʉndɨ, nawe ewe umwene. ");
INSERT INTO ikz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Naatu nɨɨzɨ kʉbha ereenderwa kʉmʉsɨɨga Mungu kumwʉyʉ gwʉsi, kʉmangʼɨɨni gʉʉsi na kʉmanaga gʉʉsi, na kʉsɨɨga nyarʉbhɨri waazʉ chɨmbu wisɨɨgirɨ aumwene. Gayo nego amaswaja amakʉrʉ bhʉkʉngʼu. Amangʼana gayo nɨ‑makʉrʉ kokora kʉkɨra kuhurucha ibhimweso bhyʉsi bhyu ukurichwa ni ibhimweso ɨbhɨndɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hanʉ Yɨɨsu aarʉʉzɨ kʉbha ʉmʉʉtʉ wuyo agarukiiryɨ kwa amangʼɨɨni, akamʉbhʉʉrɨra, “Nangʉ awɨ ʉtangirɨ kwobhoora chɨmbu ikwenderwa kusikɨra mʉbhʉtɨmi bhwa Mungu.” Kwɨma hayo, ataabhʉnɨkirɨ kwikɨ ʉmʉʉtʉ wʉndɨ wa komogema kumubhuurya. ");
INSERT INTO ikz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hanʉ Yɨɨsu aarɨ ariija abhaatʉ mwihekaaru, akabhabhʉʉrɨra, “Kwakɨ abhiija bhi imigirʉ ja Musa bhahaabhuga Kiriisitʉ ni‑mwana wʉ ʉmʉtɨmi Daudi? ");
INSERT INTO ikz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hanʉ Daudi umwene aakangatirwɨ ne Ekoro Ɨndɨndu, akabhuga, ‘Ʉmʉkʉrʉ Mungu akabhʉʉrɨra Ʉmʉkʉrʉ waanɨ, “Ikara ʉrʉbhaara rwanɨ rwu ubhuryʉ, kuhika hanʉ nɨkʉtʉʉra abhabhisa bhaazʉ iyaasɨ wa amagʉrʉ gaazʉ.” ’ ");
INSERT INTO ikz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Mmbe, Daudi umwene arabhuga Kiriisitʉ nɨ‑Mʉkʉrʉ, kʉgayo Kiriisitʉ arabhabhwɨ mwana waazɨ?” Riribhita ikʉrʉ rya abhaatʉ ryarɨ ririitegeerera Yɨɨsu kobhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mumiija gaazɨ, Yɨɨsu akabhuga, “Mwiyangarɨrɨ na abhiija bhi imigirʉ ja Musa. Bhanʉ bhasɨɨgirɨ kogenda kʉnzɨra bhiibhʉhirɨ zɨkanzʉ zaabhʉ na kʉkɨɨribhwa kubhusuuku mometeera. ");
INSERT INTO ikz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na mʉmarwazɨrʉ, bhahaasɨɨga kwikara kubhitumbɨ bhye embere. Na arɨɨbhɨ bharaarikirwɨ kʉzɨnyangi, bhahaasɨɨga kwikara hanʉ abhakangati bhiikɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bhahaaruusha abhakwirwa ebhegero bhyabhʉ. Na bhariikorya nɨ‑bhaatʉ bhagʉrʉrʉku kʉ kʉsabha amasabhi marɨɨhu bhʉkʉngʼu korereke bhiiyeerekenʼye kwa abhaatʉ. Kurusikʉ rwɨ ɨtɨnɨrʉ, abhaatʉ bhayo bharahaabhwa ɨtɨnɨrʉ kʉrʉ bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yɨɨsu akiikara haguhɨ ne ekegero chu ukuhurukirya ikimweso mwihekaaru. Aarɨ ararora abhaatʉ bharatʉʉra ikimweso mʉkɨhʉʉzʉ kirya. Abhaniibhi bhaaru bhakahurucha zimpirya nzaru. ");
INSERT INTO ikz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Akaaza ʉmʉkari wʉmwɨ umukwirwa ʉmʉhabhɨ, ewe akahurucha mazenzere abhɨrɨ masuuhu. ");
INSERT INTO ikz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hanʉ Yɨɨsu aarʉʉzɨ gayo, akabhabhɨrɨkɨra abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, ʉmʉkari umukwirwa ʉmʉhabhɨ wuyo, ahurukiryɨ zimpirya nzaru mʉkɨhʉʉzʉ kʉkɨra bhʉʉsi bhanʉ bhahurukiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nɨragambabhu kʉ kʉbha abhaatʉ abhandɨ bhʉʉsi bhahurukiryɨ amasaajʉ gu ubhwaru bhwe ebhegero bhyabhʉ. Nawe ʉmʉkari wʉnʉ, nʉ ʉbhʉhabhɨ bhwazɨ, ahurukiryɨ bhyʉsi bhɨnʉ anabhyʉ mubhwikari bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hanʉ Yɨɨsu aarɨ ararwa mwihekaaru hamwɨmwɨ na abhɨɨga bhaazɨ, wʉmwɨ wa abhɨɨga bhaazɨ akabhuga, “Umwija, rora amabhwɨ amakʉrʉ na amakindasi amakʉrʉ ganʉ gararuguurya!” ");
INSERT INTO ikz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yɨɨsu akamʉbhʉʉrɨra, “Ʉrarʉgʉʉra amanyumba amakʉrʉ ganʉ? Gʉʉsi gayo garaashwa, rɨtareeho ibhwɨ rɨnʉ rɨkʉsaaga igʉrʉ wɨ ɨrɨndɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hanʉ Yɨɨsu aarɨ iikɨɨrɨ kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni, aarɨ ararora ʉbhʉsɨ bhwa rihekaaru. Peetero, Yaakobho, Yoohana na Andureya hanʉ bhaarɨ abheene hagarɨ, bhakamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tʉrasabha ʉtʉbhʉʉrɨrɨ, gayo ʉkʉgamba garahʉrʉka ryʉrɨ? Ni‑chɨrɨkɨnʼyʉkɨ kɨnʉ kereerekenʼye kʉbha, gayo garɨ haguhɨ kʉhʉrʉka?” ");
INSERT INTO ikz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Neho Yɨɨsu akatanga kʉbhabhʉʉrɨra, “Mwangarɨrɨ, ʉmʉʉtʉ wʉwʉʉsi ataaza kʉbhakangirirya! ");
INSERT INTO ikz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abhaatʉ bhaaru bharaaza kuriina ryanɨ, bharabhuga, ‘Inyɨ ni‑Kiriisitʉ,’ na bharakangirirya abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hanʉ muriigwɨ igʉrʉ wa riihɨ na amangʼana ga riihɨ, mʉtakangwa. Gayo gareenderwa gakorwe, nawe ɨtɨnɨrʉ yɨ ɨɨsɨ ɨrabha ɨkɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Icharʉ kɨmwɨ kiriitana ni icharʉ ɨkɨndɨ, ʉbhʉtɨmi bhʉmwɨ bhuriitana nʉ ʉbhʉtɨmi ʉbhʉndɨ. Kʉrabha ni ibhirigitʉ bhyɨ ɨɨsɨ bhya hanʉ na harya nɨ ɨnzara hagero haaru kʉʉsɨ. Gayo gʉʉsi garabha chɨmbu ʉbhʉtangɨ bhwʉ ʉbhʉsʉngʉ bhwʉ ʉmʉkari wʉnʉ akwenda kwibhʉra. ");
INSERT INTO ikz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nawe imwɨ, mwiyangarɨrɨ bhʉkʉngʼu. Abhaatʉ bharabhahira kʉbhakangati na abhatɨmi mʉmarwazɨrʉ. Bharabhahira mʉbhʉtangɨ bhwa abhakangati na abhatɨmi igʉrʉ waanɨ. Moreenderwa kʉbha abhamɨnyɨɨkɨrɨri bhaanɨ mʉbhʉtangɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɨngʼana Ɨnzʉmu ereenderwa irwazwɨ mubhyarʉ bhyʉsi ɨtɨnɨrʉ ɨkɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hanʉ abhaatʉ bhayo bhakʉbhakwesa na kʉbhahira kubhyandarʉ na kʉbhatɨnɨra, mʉtanyaaka ga kʉgamba, nawe mʉgambɨ ganʉ Mungu arɨɨbhahɨ ribhaga riyoriyo. Ɨtarɨ niimwɨ imubheene mʉrɨgambɨ, amaheene ne‑Koro Ɨndɨndu yɨnʉ ɨrɨ mʉʉsi waanyu neyo ɨkʉbhasakirya kʉgamba. ");
INSERT INTO ikz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Umuhiiri ariichʉra umuhiiri waazɨ korereke iitwɨ. Wiisɨ ariichʉra umwana waazɨ, na abhaana bhariitanʼya abhiibhuri bhaabhʉ na kugirya bhiitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abhaatʉ bhʉʉsi bharabhabhiihirirwa igʉrʉ waanɨ. Nawe wʉnʉ ariigumiriryɨ kuhika ɨtɨnɨrʉ, newe araasabhʉkɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wʉnʉ akosoma amaandɨkʉ ganʉ, obhoore enzobhooro ya amaangirijʉ ga Yɨɨsu ganʉ, “Ribhaga irebhe mʉrarora ʉbhʉrʉrʉ bhʉnʉ ʉmʉrʉʉtɨrɨri Danyɨri aabhugirɨ ʉbhʉsarya. Neho abhaatʉ bhanʉ bharɨ Yudeya, bhangʼosere mʉbhɨgʉrʉ! ");
INSERT INTO ikz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ʉmʉʉtʉ wʉnʉ ari igʉrʉ kʉkɨsara chi inyumba, atiika korereke agege ebhegero bhɨnʉ bhiri munyumba, angʼose. ");
INSERT INTO ikz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na wʉnʉ akʉbha mʉmʉgʉndʉ angʼose, atiichʉra inyuma kogega zengebho zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tʉrabharorera ɨbhɨgʉngi abhakari bhanʉ bharɨnda na bhanʉ bhakʉbha bharakoocha zisikʉ ziyo. ");
INSERT INTO ikz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mʉsabhɨ kʉbha, zisikʉ ziyo zɨtabhoneka ribhaga rye embeho. ");
INSERT INTO ikz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Zisikʉ ziyo zɨrabha zɨ ɨnyaakʉ kʉrʉ, yɨnʉ ɨkɨɨrɨ kʉhʉrʉka nʉʉrʉ hasuuhu, kwɨma hanʉ Mungu aatɨɨmirɨ icharʉ, kuhika ribhaga riyo. Na ɨtakobhoneka kwikɨ yɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Angabhɨɨrɨ Ʉmʉkʉrʉ atasuuhya zisikʉ ziyo, ataarɨ areho ʉmʉʉtʉ wʉwʉʉsi wʉnʉ aarɨ akʉsabhʉka. Nawe, Mungu arasuuhya zisikʉ ziyo, kʉ kʉbha aradɨɨrɨɨra abhaatʉ bhanʉ aarʉbhwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na ribhaga riyo, ʉmʉʉtʉ wʉwʉʉsi araabhabhʉʉrɨrɨ, ‘Rora, Kiriisitʉ arɨ hanʉ!’ hamwɨ, ‘Ari irya!’ mutiisirirya. ");
INSERT INTO ikz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bharabhaho abharʉʉtɨrɨri bhʉ ʉrʉrɨmɨ na abhaatʉ bhanʉ bhakwibhɨrɨkɨra Kiriisitʉ. Bhareerekenʼya ibhyɨrɨkɨnʼyʉ na amateemo, korereke bhageme kurimirya abhaatʉ, ɨrɨɨtʉrɨkanɨ nʉʉrʉ abharobhorwa bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mmbe imwɨ, mwiyangarɨrɨ! Inyɨ nɨkangatirɨ hinga kʉbharecha gʉʉsi gayo gakɨɨrɨ kʉhʉrʉka. ");
INSERT INTO ikz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nawe, zisikʉ ziyo, hanʉ ɨnyaakʉ yiyo ɨraahɨtɨ, iryʉbha rɨratuurwa ikiirimya nu umwɨri gwʉsi gʉtakuhurucha ubhwɨrʉ bhwagwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Zenzota zʉʉsi zɨragwa haasɨ kurwa mwisaarʉ. Ebhegero bhyʉsi bhya mwisaarʉ bhɨrasingisa. ");
INSERT INTO ikz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Neho abhaatʉ bhʉʉsi bharaarore Umwana wʉ Ʉmʉʉtʉ araaza mʉmasaarʉ kwa nguru nzaru nʉ ʉbhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aratʉma bhamaraika bhaazɨ bhabhiringɨ abharobhorwa bhaazɨ kurwa mbaara zʉʉsi inyɨ zɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mwɨgɨ kurwa kʉmʉtɨ gwu umutiini. Hanʉ mokorora ibhisha bhɨrasɨbhʉka na amatʉʉtʉ gabhariryɨ, mʉramenya kʉbha ribhaga rya rigesa rɨrariirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɨbhuɨbhu, hanʉ mʉraarore gayo gatangirɨ, momenye kʉbha arɨ haguhɨ kuuza. ");
INSERT INTO ikz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nɨrabhabhʉʉrɨra amaheene, ribhaga ryu urwibhʉrʉ rʉnʉ rɨtakʉhɨta kuhika gayo gʉʉsi gakorwe. ");
INSERT INTO ikz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Risaarʉ nɨ ɨɨsɨ bhɨrahɨta, nawe ɨngʼana yaanɨ ɨtakʉhɨta kemerano. ");
INSERT INTO ikz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nawe, igʉrʉ wu urusikʉ na ribhaga ryu ukuuza, atareeho ʉmʉʉtʉ wʉnʉ yɨɨzɨ. Naabha bhamaraika bha mwisaarʉ hamwɨ Umwana, bhʉʉsi bhatɨɨzɨ, nawe Bhaabha Mungu umwene newe yɨɨzɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwangarɨrɨ! Motengeeze, mʉsabhɨ, kʉ kʉbha mʉtɨɨzɨ ribhaga riyo rɨrahika ryʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Amangʼana gayo garabha nchʉ ʉmʉʉtʉ wʉnʉ akuja orogendo kurwa munyumba yaazɨ. Akabhatigɨra bhambʉʉsa bhaazɨ bhariibhɨ inyumba. Akabhasondya bhʉʉsi emeremo jabhʉ jo okokora, akaswaja umuriibhi wi ikisikʉ wʉʉsi, atengeeze.” ");
INSERT INTO ikz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Mmbe imwʉsi motengeeze, kʉ kʉbha mʉtɨɨzɨ kʉbha wi inyumba aragarʉka ryʉrɨ. Mʉtɨɨzɨ arɨɨbhɨ aragarʉka rigoroobha, hamwɨ ubhutikʉ gatɨ, hamwɨ mozengoko, hamwɨ ritabhʉʉri. ");
INSERT INTO ikz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Motengeeze, korereke araabhahumbukijɨ, atabhona zɨbhahirirɨ. ");
INSERT INTO ikz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Rɨnʉ nɨkʉbhabhʉʉrɨra imwɨ, nɨrabhʉʉrɨra abhaatʉ bhʉʉsi, bhatengeeze.” ");
INSERT INTO ikz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zɨkasaaga sikʉ ibhɨrɨbhu, ihikɨ isigukuru yɨ Ɨpasaka, nɨ yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru. Abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa, bhaarɨ bharamohya ɨnzɨra yu kugwata Yɨɨsu kwa mbisi, bhamʉtɨnɨrɨ na kumwita. ");
INSERT INTO ikz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nawe bhakabhuga, “Tutigɨ hinga isigukuru ɨhɨtɨ, neho tumugwatɨ, abhaatʉ bhataaza kokora ɨkɨmpʉgɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ribhaga riyo Yɨɨsu aarɨ Bhɨtaniya, wa Simʉʉni wʉnʉ aarɨ ne ebhegenge. Hanʉ aarɨ kwigari, akaaza ʉmʉkari wʉmwɨ ani ichupa ɨnzʉmu ya amaguta ga naridʉ. Amaguta gayo gaarɨ gi iguri ikʉrʉ, na garareetya bhwaheene. Akatɨna umunywa gwi ichupa, akiitʉrʉrɨra Yɨɨsu kumutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abhaatʉ obhorebhe bhanʉ bhaarɨ munyumba yirya, bhakiigatana. Bhakatanga kʉgamba abheene kobheene, “Ndora arasarya amaguta amazʉmu ganʉ? ");
INSERT INTO ikz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Amaguta ganʉ gakeenderwa kuguribhwa zidinaari magana atatʉ, na kʉhaabhwa abhahabhɨ.” Bhakahaarɨra ʉmʉkari wurya. ");
INSERT INTO ikz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nawe Yɨɨsu akabhuga, “Mumutigɨ. Ndora mʉramʉnyaacha? Rɨnʉ ʉmʉkari wʉnʉ ankʉrɨɨrɨ ni‑zʉmu. ");
INSERT INTO ikz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abhahabhɨ mʉnabhʉ sikʉ zʉʉsi. Mʉratʉra kʉbhakorera amazʉmu ribhaga ryʉryʉsi rɨnʉ mʉsɨɨgirɨ. Nawe inyɨ nɨtakʉbha na niimwɨ sikʉ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʉmʉkari wʉnʉ akʉrirɨ rɨnʉ akʉtʉra. Akangatirɨ kʉhaka ʉmʉbhɨrɨ gwanɨ amaguta igʉrʉ wa amabhɨɨka gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nɨrabhabhʉʉrɨra amaheene, hʉhʉʉsi mubhyarʉ hanʉ abhaatʉ bhakʉbha bhararwaza Ɨngʼana Ɨnzʉmu, bharabha bharagamba rɨnʉ ʉmʉkari wʉnʉ aakʉrirɨ, kumuhiita.” ");
INSERT INTO ikz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Neho Yuuda Isikariyʉʉti, wʉmwɨ wa abhɨɨga ikumi na bhabhɨrɨ bha Yɨɨsu bharya, akaja kumwichʉra kʉbhakʉrʉ bha abhakuhaani, abheereche ɨnzɨra yu ukugwata Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hanʉ bhiigwirɨ amangʼana gayo, bhakazomerwa bhʉkʉngʼu. Bhakiisiriranʼya nawe kʉbha bharamoha zimpirya. Neho Yuuda akatanga komohya umweya ʉmʉzʉmu gu ukumwichʉra. ");
INSERT INTO ikz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Rwarɨ urusikʉ rwe embere rwi isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru, urusikʉ rʉnʉ abhaatʉ bhaarɨ bhariita ɨkɨngʼʉndu chɨ Ɨpasaka. Abhɨɨga bha Yɨɨsu bhakamubhuurya, “Oreenda tujɨ hayi tokokorere ahagero hʉ ʉkʉrɨɨra Ɨpasaka?” ");
INSERT INTO ikz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Neho Yɨɨsu akatʉma abhɨɨga bhabhɨrɨ, akabhabhʉʉrɨra, “Mujɨ mʉrʉbhɨri rwa Yɨrusarɨɨmu, iyo mʉrahunana nu umusubhɨ wʉmwɨ agɨgirɨ inywa, mumutunɨ. ");
INSERT INTO ikz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Munyumba yɨnʉ ariisikɨrɨ, mujɨ mʉmʉbhʉʉrɨrɨ umwene nyumba, ‘Umwija arasabha utwereche ɨgatɨ hanʉ araarɨɨrɨ Ɨpasaka hamwɨmwɨ na abhɨɨga bhaazɨ.’ ");
INSERT INTO ikz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Neho umwene nyumba arabheerecha ɨgatɨ ahakʉrʉ mogorofa, hakʉnzirwɨ kɨmwɨ. Mototengere muyo, tʉrɨɨrɨ Ɨpasaka.” ");
INSERT INTO ikz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abhɨɨga bharya bhakabhʉʉka, bhakaja mʉrʉbhɨri rwa Yɨrusarɨɨmu. Bhakabhona gʉʉsi garɨ chɨmbu Yɨɨsu aabhabhuuriirɨ, bhakatenga ibhyakurya bhyɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hanʉ ryahikirɨ rigoroobha, Yɨɨsu akahika munyumba yirya hamwɨmwɨ na abhɨɨga bhaazɨ ikumi na bhabhɨrɨ bharya. ");
INSERT INTO ikz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hanʉ bhaarɨ bhararya, Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra amaheene, wʉmwɨ waanyu, wʉʉsi ararya hamwɨmwɨ na niinyɨ, aranyiichʉra.” ");
INSERT INTO ikz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abhɨɨga bhaazɨ bhakatanga kurumɨka. Bhakamubhuurya wʉmwɨ wʉmwɨ, “Nangʉ niinyɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Akabhabhʉʉrɨra, “Nɨ‑wʉmwɨ waanyu gatɨ wi ikumi na bhabhɨrɨ, wʉnʉ akokorya hamwɨmwɨ na niinyɨ mʉbhakuri. ");
INSERT INTO ikz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Maheene Umwana wʉ Ʉmʉʉtʉ araja kukwa, chɨmbu Amaandɨkʉ Amarɨndu gakubhuga igʉrʉ waazɨ. Nawe, horeera kʉmʉʉtʉ wʉnʉ ariichʉrɨ Umwana wʉ Ʉmʉʉtʉ! Yaarɨ hakɨrɨku kwewe atangibhwirwɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hanʉ bhaarɨ bhararya, Yɨɨsu akagega ʉmʉkaatɨ, akabhʉʉrɨra Mungu, azʉmiryɨ. Akagusunyura, akabhaha abhɨɨga bhaazɨ, akabhuga, “Mogege, muryɨ, gʉnʉ negwe ʉmʉbhɨrɨ gwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akʉmara, akagega ekekombe chi idivaayi, akabhʉʉrɨra Mungu, azʉmiryɨ, akabhaha arabhuga, “Mogege, munywɨ imwɨ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ganʉ nego amasaahɨ gaanɨ gʉ ʉbhʉragɨ, ganʉ gakwitɨka igʉrʉ wa abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɨrabhabhʉʉrɨra amaheene kʉbha, nɨtakunywa naatu idivaayi kuhika hanʉ nikunywa bhuhya mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Akʉmara bhakɨɨmba iryɨmbʉ ryu ukukumya Mungu. Bhakabhʉʉka hayo, bhakaja kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. ");
INSERT INTO ikz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hanʉ bhaarɨ kʉnzɨra, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Imwʉsi mʉraangʼosa kʉganʉ gakʉhʉrʉka. Garabha chɨmbu Mungu aagambirɨ mʉMaandɨkʉ Amarɨndu, ‘Nɨramwita umuriisha, na zɨngʼʉndu zaazɨ zɨranyaragana.’ ");
INSERT INTO ikz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nawe hanʉ nikuryʉka, nɨrabhakangatɨra kuja Gariraaya.” ");
INSERT INTO ikz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Neho Peetero akamʉbhʉʉrɨra, “Nangabha abhakɨndichanɨ bhʉʉsi bharakutiga, inyɨ nɨtakukutiga.” ");
INSERT INTO ikz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yɨɨsu akamʉbhʉʉrɨra, “Nɨrakʉbhʉʉrɨra amaheene, ubhutikʉ bhwa reero, ekorokoome ɨtakuhiita kʉgamba kabhɨrɨ, ʉrabha ʉnyangirɨ katatʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nawe Peetero akoongera kʉkandikija kʉbha, “Nangabha kukwa, nikwɨ hamwɨmwɨ na naawɨ, nɨtakukwanga zee!” Na abhɨɨga bhʉʉsi abhakɨndichazɨ bhakabhuga muyomuyo. ");
INSERT INTO ikz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hanʉ bhaahikirɨ kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni, bhakaja mubhusitaani yɨnʉ ikubhirikirwa Gɨtisɨmanɨ. Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Mwikarɨ hanʉ, ribhaga rɨnʉ inyɨ nɨkʉsabha.” ");
INSERT INTO ikz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akagega Peetero, Yaakobho na Yoohana, akaja nabhʉ kore hasuuhu, akatanga kwitiimaata na kʉnyaaka bhʉkʉngʼu mokoro. ");
INSERT INTO ikz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akabhabhʉʉrɨra, “Ekoro yaanɨ irumikirɨ bhʉkʉngʼu, ekerengo chu ukukwa. Mwikarɨ hanʉ, motengeeze.” ");
INSERT INTO ikz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yɨɨsu akiisuka embere hasuuhu, akagwa haasɨ. Akasabha, “Ɨrɨɨtʉrɨkanɨ, nɨtahɨtɨra ribhaga ryɨ ɨnyaakʉ rɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akabhuga, “Bhaabha, kwa naawɨ gʉʉsi garatʉrɨkana. Nɨrakʉsabha unduushiryɨ ekekombe chɨ ɨnyaakʉ kɨnʉ. Ɨtarɨ chɨmbu inyɨ nikwenda, nawe gakorwe chɨmbu awɨ ukwenda.” ");
INSERT INTO ikz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hanʉ aagarukirɨ kʉbhɨɨga bhaazɨ bhatatʉ bharya, akabhona bhahindiirɨ. Akabhuurya Simʉʉni Peetero, “Simʉʉni, zihirirɨ? Ʉtamirwɨ kotengeeza nʉʉrʉ kwɨ ɨɨsa yɨmwɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Neho akabhabhʉʉrɨra, “Motengeeze na kʉsabha, mʉtaaza kusikɨra mubhitiimotiimo. Ekoro iriisirirya, nawe ʉmʉbhɨrɨ nɨ‑mʉnyʉʉhɨrɨru.” ");
INSERT INTO ikz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yɨɨsu akabhʉʉka, akaja kʉsabha rusizʉ, akagarʉkɨra kʉgamba amangʼana garyagarya. ");
INSERT INTO ikz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Hanʉ aagarukirɨ rwa kabhɨrɨ kʉbhɨɨga bhaazɨ, akabhona bhahindiirɨ, akabhabhuucha, kʉ kʉbha bhakarwa mozendooro. Bhataarɨ na rya kʉmʉgarukirya. ");
INSERT INTO ikz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yɨɨsu akarwa kwikɨ kʉsabha rwa katatʉ, akabhabhʉʉrɨra, “Nangʉ muhindɨrɨ mwoyeere, yiisirɨ. Ribhaga ryɨ ɨnyaakʉ yaanɨ rihikirɨ. Umwana wʉ Ʉmʉʉtʉ aragwatwa na kuhirwa mʉmabhoko ga abhakʉri bhʉ ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mʉbhʉʉkɨ, tujɨ. Rora, wʉnʉ akunyiichʉra arɨ haguhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Hanʉ Yɨɨsu aarɨ akɨɨrɨ aragamba gayo, hayohayo Yuuda, wʉmwɨ wa abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akahika na abhaatʉ bhaaru, bhanʉ bhagwatiriirɨ amasabha na amarungu mʉmabhoko. Abhaatʉ bhayo bhakarwa kʉbhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ ja Musa na abhakaruka. ");
INSERT INTO ikz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuuda wʉnʉ iichurirɨ Yɨɨsu, aarɨ abhahɨɨrɨ ichɨrɨkɨnʼyʉ, arabhuga, “Ʉmʉʉtʉ wʉnʉ nɨraahumbatɨ, momenye, newe. Mumugwatɨ na kʉbhʉʉka nawe, mʉmʉtʉʉrɨ mozemboko.” ");
INSERT INTO ikz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hanʉ Yuuda aahikirɨ harya, akaja bhwɨma kwa Yɨɨsu, akabhuga, “Umwija!” Akamuhumbata. ");
INSERT INTO ikz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Abhaatʉ bharya bhakagwata Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Neho, ʉmʉʉtʉ wʉmwɨ mʉbharya bhanʉ bhiimiiriirɨ harya hamwɨmwɨ na Yɨɨsu, akasohora risabha ryazɨ, akatɨna ʉkʉtwɨ kwa mbʉʉsa wa kuhaani ʉmʉkʉrʉ kutu. ");
INSERT INTO ikz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yɨɨsu akabhʉʉrɨra abhaatʉ bharya, “Ndora mwizirɨ na amasabha na amarungu, mungwatɨ inyɨ, ncha abhaatʉ bhanʉ bhakuja kugwata ʉmʉsaakuri? ");
INSERT INTO ikz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kɨrakabhu naarɨ hamwɨmwɨ na niimwɨ, niriija mwihekaaru, mʉtaangwatirɨ. Nawe ganʉ gʉʉsi gakʉrirwɨ korereke ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, gakorwe.” ");
INSERT INTO ikz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Neho abhɨɨga bhaazɨ bhʉʉsi bhakaryara, bhakamutiga. ");
INSERT INTO ikz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwarɨ nu umumura wʉmwɨ wʉnʉ ifɨɨriryɨ engebho, aarɨ aratuna Yɨɨsu. Bhakagema kumugwata, ");
INSERT INTO ikz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nawe akasʉsʉbhʉka mʉmabhoko, akatiga umwenda gwazɨ, akaryara mwega arɨ tʉʉhʉ. ");
INSERT INTO ikz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Neho abhaatʉ bharya bhakahira Yɨɨsu kwa kuhaani ʉmʉkʉrʉ. Bhakiibhiringa harya abhakʉrʉ bhʉʉsi bha abhakuhaani, abhakaruka na abhiija bhi imigirʉ ja Musa. ");
INSERT INTO ikz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peetero akabha aratuna Yɨɨsu kwa kore. Akaja, akasikɨra mwigoobhe rya kuhaani ʉmʉkʉrʉ. Akiikara murya hamwɨmwɨ na abhariibhi bha kuhaani ʉmʉkʉrʉ, akabha aroota omorero. ");
INSERT INTO ikz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abhakʉrʉ bha abhakuhaani ni ichandarʉ chʉsi bhakatanga komohya obhomenyeekererya bhwʉ ʉkʉgamba Yɨɨsu, korereke bhamʉtɨnɨrɨ na kumwita. Nawe, bhataarɨ bharabhona obhomenyeekererya bhwʉbhwʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abhaatʉ bhaaru bhaarɨ bharahurucha obhomenyeekererya bhwʉ ʉrʉrɨmɨ kʉgamba Yɨɨsu, nawe obhomenyeekererya bhwabhʉ bhʉtaarɨ bhuriigwana. ");
INSERT INTO ikz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Akʉmara, abhaatʉ abhandɨ obhorebhe bhakiimɨɨrɨra, bhakahurucha obhomenyeekererya bhwʉ ʉrʉrɨmɨ. Bhaarɨ bharabhuga, ");
INSERT INTO ikz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Itwɨ abheene tukiigwa ʉmʉʉtʉ wʉnʉ arabhuga, ‘Inyɨ nɨragwisha rihekaaru rya Mungu rɨnʉ abhaatʉ bhʉʉmbakirɨ. Na nɨrʉʉmbaka ɨrɨndɨ kwa sikʉ isatʉbhu. Rihekaaru riyo rɨtakʉʉmbakwa na abhaatʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nʉʉrʉbhu, obhomenyeekererya bhwabhʉ bhʉtaarɨ bhuriigwana. ");
INSERT INTO ikz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Akʉmara kuhaani ʉmʉkʉrʉ akiimɨɨrɨra embere wi ichandarʉ. Akabhuurya Yɨɨsu, “Awɨɨ, ʉtakʉgarukirya ingʼana ryʉryʉsi, rɨnʉ abhaatʉ bhanʉ bhakʉkʉgamba?” ");
INSERT INTO ikz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nawe Yɨɨsu akakira kiri, ataagambirɨ ingʼana ryʉryʉsi. Kuhaani ʉmʉkʉrʉ akangʼeha kumubhuurya, “Awɨ ni‑Kiriisitʉ, Umwana wa Mungu wʉnʉ akukumibhwa?” ");
INSERT INTO ikz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yɨɨsu akagarukirya, “Inyɨ newe. Na niimwɨ mʉrarora Umwana wʉ Ʉmʉʉtʉ ikɨɨrɨ ʉrʉbhaara rwu ubhuryʉ rwa Mungu wa Amanaga. Na mʉramorora araaza mʉmasaarʉ kurwa mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Neho kuhaani ʉmʉkʉrʉ akatarandʉra zengebho zaazɨ kwerecha asaayirɨ bhʉkʉngʼu, akabhuga, “Nɨ‑bhamenyeekereryakɨ bhanʉ tukwenda? ");
INSERT INTO ikz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwigwirɨ abheene chɨmbu akorega Mungu! Nangʉ imwɨ, mʉrabhugabhwɨ?” Ichandarʉ chʉsi kɨkabhuga areenderwa iitwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Abhandɨ bhakatanga kumutwɨra amatɨ, komobhoha mubhushʉ na komotema ibhikundi, ɨnʉ bharamʉbhʉʉrɨra, “Rootorera nɨ‑wɨɨwɨ wʉnʉ akʉtɨmirɨ!” Na abhariibhi bhanʉ bhaarɨ harya, bhakamogega, bhakamotema. ");
INSERT INTO ikz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ribhaga riyo ryʉsi, Peetero aarɨ mwigoobhe, iyaasɨ wi ichumba hanʉ Yɨɨsu aarɨ arabhuuribhwa. Akaaza omohocha wʉmwɨ wɨ ɨkɨkari wa kuhaani ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Akarora Peetero aroota omorero, akamomogorera. Akamʉbhʉʉrɨra, “Na naawɨ waarɨ hamwɨmwɨ na Yɨɨsu, Ʉmʉnazarɨɨti.” ");
INSERT INTO ikz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nawe Peetero akaanga arabhuga, “Nɨtɨɨzɨ na nɨtakwigwa ganʉ ʉkʉgamba!” Akaja kukishoko cha rigoobhe. Ribhaga riryarirya, ekorokoome ɨkagamba. ");
INSERT INTO ikz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ʉmʉkari wuyo akarora Peetero, akatanga kʉbhʉʉrɨra abhaatʉ bhanʉ bhiimiiriirɨ harya, “Ʉmʉʉtʉ wʉnʉ wʉʉsi arɨ hamwɨmwɨ nabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nawe Peetero akaanga kwikɨ. Rɨkahɨta ibhaga isuuhu, abhaatʉ bhanʉ bhiimiiriirɨ harya, bhakamʉbhʉʉrɨra, “Amaheene awɨ nɨ‑wʉmwɨ waabhʉ, kʉ kʉbha na naawɨ Mʉgariraaya ʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nawe, Peetero akatanga kwihiimirirya na kwirahɨra, “Ʉmʉʉtʉ wʉnʉ mʉkʉgamba, inyɨ nɨtamwɨzɨ!” ");
INSERT INTO ikz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hayohayobhu, ekorokoome ɨkagamba rwa kabhɨrɨ. Ribhaga riyo, Peetero akahiita ringʼana rya Yɨɨsu rɨnʉ aamubhuuriirɨ, “Ekorokoome ɨkɨɨrɨ kʉgamba manga kabhɨrɨ, ʉrabha ʉnyangirɨ katatʉ.” Peetero hanʉ isɨɨgirɨ gayo, akarɨra. ");
INSERT INTO ikz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hanʉ bhwɨrirɨbhu, ichandarʉ chʉsi cha abhakʉrʉ bha abhakuhaani, abhakaruka na abhiija bhi imigirʉ ja Musa, bhakiisiriranʼya. Bhakabhoha Yɨɨsu, bhakamuhira kwa Piraato. ");
INSERT INTO ikz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Piraato akamubhuurya, “Awɨ naawɨ ʉmʉtɨmi wa Abhayaahudi?” Yɨɨsu akamʉgarukirya, “Awɨ ʉgambirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abhakʉrʉ bha abhakuhaani bhaarɨ bharamʉgamba kʉbha akʉrirɨ amabhɨ maaru. ");
INSERT INTO ikz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piraato akamubhuurya naatu, akabhuga, “Ʉtakʉgarukirya ingʼana ryʉryʉsi? Rora chɨmbu bhakʉkʉgamba awɨ amabhɨ amaaru.” ");
INSERT INTO ikz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nawe Yɨɨsu atamʉgarukiiryɨ chʉchʉsi. Neho Piraato akarʉgʉʉra! ");
INSERT INTO ikz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Musigukuru yɨ Ɨpasaka, Piraato aarɨ ni isimʉka yu ukumutigʉrʉkɨra omobhohwa wʉmwɨ, wʉnʉ abhaatʉ bhaarɨ bhakʉsabha atazurwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ribhaga riyo mokebhoho bhaarɨmu abhaatʉ bhanʉ bhiichurirɨ na kokora ubhwiti mubhwangi bhwabhʉ. Wʉmwɨ wa abhiiti bhayo aarɨ arabhirikirwa Bharaabha. ");
INSERT INTO ikz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Riribhita ikʉrʉ rya abhaatʉ bhakaja kwa Piraato, bhakamʉsabha abhatazʉrɨrɨ omobhohwa wʉmwɨ, chɨmbu aanarirɨ kokora. ");
INSERT INTO ikz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Piraato akabhabhuurya, “Nangʉ, moreenda nɨbhatazʉrɨrɨ ʉmʉtɨmi wa Abhayaahudi?” ");
INSERT INTO ikz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akagambabhu kʉ kʉbha akamenya kʉbha abhakʉrʉ bha abhakuhaani bhakamuhira Yɨɨsu kwewe igʉrʉ we engʼeera yaabhʉbhu. ");
INSERT INTO ikz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nawe abhakʉrʉ bha abhakuhaani bhakasiigirirya riribhita rya abhaatʉ rirya, rɨkasabha Piraato abhatazʉrɨrɨ Bharaabha. ");
INSERT INTO ikz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piraato akabhabhuurya naatu, “Mmbe, moreenda nekorebhwɨ ʉmʉʉtʉ wʉnʉ mukubhuga nɨ‑mʉtɨmi wa Abhayaahudi?” ");
INSERT INTO ikz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Abhaatʉ bhʉʉsi bhakarɨgɨsa bharabhuga, “Mʉmʉbhambɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piraato akabhabhuurya, “Asariryɨkɨ?” Neho ebho bhakangʼeha kʉrɨgɨsa bhʉkʉngʼu, bharabhuga, “Mʉmʉbhambɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Piraato kwa kʉsɨɨga kʉsambarucha riribhita rya abhaatʉ riyo, akabhatazʉrɨra Bharaabha. Akaswaja abhasirikarɨ korereke bhateme Yɨɨsu ɨmɨzariti, bhakamotema. Akʉmara akamuhurucha bhamʉbhambɨ kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abhasirikarɨ bhakagega Yɨɨsu, bhakaja nawe mwikʉrʉ rya Piraato. Bhakabhiringa riribhita ikʉrʉ rya abhasirikarɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakamwibhohya engebho ya zambaraawɨ. Bhakagisa ɨkɨrʉngʉ cha amahwa, bhakamwibhohya kumutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakatanga komokeerya kwa kusiihya, “Morembe, ʉmʉtɨmi wa Abhayaahudi!” ");
INSERT INTO ikz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhaarɨ bharamotema kumutwɨ na rikʉrɨ na kumutwɨra amatɨ, bhakamuhigamɨra kwa kumukumya. ");
INSERT INTO ikz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hanʉ bhaamarirɨ kumusiihya, bhakamuruusha engebho ya zambaraawɨ yirya, na kumwibhohya naatu zengebho zaazɨ. Bhakamuhira bhamʉbhambɨ kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kʉnzɨra, bhakarumana nʉ ʉmʉʉtʉ wʉnʉ aarɨ akʉhɨta kʉrʉbhɨri kurwa mʉmʉgʉndʉ, iriina ryazɨ Simʉʉni kurwa Kireene. Ʉmʉʉtʉ wuyo aarɨ wiisɨ Arɨkizanda na Ruufʉ. Abhasirikarɨ bhakamʉhatɨka agege ʉmʉsarabha gwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bhakahira Yɨɨsu hanʉ haabhirikiirwɨ Gʉrigʉʉta, enzobhooro yaku nɨ‑kʉKɨhanga chu Umutwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhakaha Yɨɨsu idivaayi yɨnʉ bhaasangɨɨnʼyɨ nʉ ʉmʉtɨ, nawe ewe akaanga kunywa. ");
INSERT INTO ikz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Neho bhakamʉbhamba kʉmʉsarabha, na bhakatwana zengebho zaazɨ. Bhakakora ubhwitʉʉri kuhitya wɨɨwɨ aragega engebhokɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ribhaga rɨnʉ bhaamʉbhambirɨ, yaarɨ ɨsa isatʉ ritabhʉʉri. ");
INSERT INTO ikz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhakatʉʉra igʉrʉ wʉ ʉmʉsarabha amaandɨkʉ gʉ ʉbhʉbhɨ bhwazɨ, gaarɨ garabhuga, “Ʉmʉtɨmi wa Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhakamʉbhamba na abhasaakuri bhabhɨrɨ kʉmɨsarabha, ʉwʉmwɨ ʉrʉbhaara rwazɨ rwu ubhuryʉ nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi.  ");
INSERT INTO ikz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Neho gakakunana Amaandɨkʉ Amarɨndu ganʉ gakubhuga, “Akabharwa hamwɨmwɨ na abhakʉri bha amabhɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abhaatʉ bhanʉ bhaarɨ bhakʉhɨta kʉnzɨra hayo, bhakamʉtʉka, bharasingisha imitwɨ jabhʉ bharabhuga, “Aa! Awɨ, wʉnʉ akwasha rihekaaru na kuryʉmbaka kuzisikʉ isatʉ, ");
INSERT INTO ikz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nangʉ, wiituuryɨ aumwene, wiikɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ ja Musa bhʉʉsi hamwɨmwɨ, bhakamorega bharabhuga, “Akasabhʉra abhandɨ, nawe atakʉtʉra kwisabhʉra umwene! ");
INSERT INTO ikz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Angʉ, abhugirɨ kʉbha newe Kiriisitʉ, ʉmʉtɨmi wa Abhiiziraɨri. Nangʉ iikɨ kʉmʉsarabha, korereke tomorore nu ukumwisirirya.” Na abhaatʉ bhanʉ bhaabhambirwɨ hamwɨmwɨ nawe, bhʉʉsi bhakamʉtʉka. ");
INSERT INTO ikz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kʉtangɨra zɨɨsa isaasabha umwise kuhika zɨɨsa kenda, ɨkabha ikiirimya kucharʉ chʉsi. ");
INSERT INTO ikz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Neho zɨɨsa kenda, Yɨɨsu akarɨra kwiraka ikʉrʉ arabhuga, “Ɨrʉʉyi! Ɨrʉʉyi! Raama sabhakitaani?” Enzobhooro yaku ni‑“Mungu waanɨ, Mungu waanɨ, ndora untigirɨ?” ");
INSERT INTO ikz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abhaatʉ obhorebhe gatɨ wa bhanʉ bhiimiiriirɨ harya, hanʉ bhiigwirɨ ganʉ akʉgamba, bhakabhuga, “Mwigwɨ bhamura, arabhɨrɨkɨra Ɨɨriya ʉmʉrʉʉtɨrɨri wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ʉmʉʉtʉ wʉmwɨ akaryara bhwangʉ kotobheka ripuupya mʉmarwa amarʉrʉ gi idivaayi, akabhohera kwikʉrɨ rirɨɨhu. Akarɨnʉnga igʉrʉ, akaha Yɨɨsu anywɨ. Ʉmʉʉtʉ wuyo akabhuga, “Mutigɨ torore arɨɨbhɨ Ɨɨriya araaza kumwicha kʉmʉsarabha hayo!” ");
INSERT INTO ikz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yɨɨsu akarɨra kwiraka ikʉrʉ, akatinʼya. ");
INSERT INTO ikz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ripaziya ryu ukusikɨra Aharɨndu ha Aharɨndu mwihekaaru rɨkabhaarʉka, mbaara ibhɨrɨ kuhika iyaasɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ʉmʉkʉrʉ wa abhasirikarɨ wʉnʉ aarɨ imiiriirɨ embere wa Yɨɨsu, hanʉ aarʉʉzɨ chɨmbu Yɨɨsu akukwa, akabhuga, “Heene ʉmʉʉtʉ wʉnʉ aarɨ Umwana wa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhaareho abhakari bhanʉ bhaarʉʉzɨ kwa kore. Gatɨ waabhʉ aareho Mariyamu wa Magidarena, Saroome na Mariyamu unina Yaakobho umusuuhu na Yoose. ");
INSERT INTO ikz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abhakari bhayo bhaarɨ bhamutunirɨ na kohokerya Yɨɨsu hanʉ aarɨ mucharʉ cha Gariraaya. Bhaareho na abhakari abhandɨ bhaaru bhanʉ bhagiirɨ hamwɨmwɨ nawe Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hanʉ ryahikirɨ rigoroobha, kʉ kʉbha urusikʉ ruyo rwarɨ rwu ukwitʉʉra bhwaheene, igʉrʉ wu urusikʉ rwʉ ʉbhʉtʉʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","akaaza ʉmʉʉtʉ wʉmwɨ wʉnʉ akubhirikirwa Yuusufu, umwibhurwa wʉ ʉrʉbhɨri rwa Arimataaya. Aarɨ wu ubhusuuku bhʉkʉngʼu, wa muchandarʉ ɨkɨkʉrʉ cha Abhayaahudi, na aarɨ ariisega ʉbhʉtɨmi bhwa Mungu bhʉnʉ bhukuuza. Akaja kwa Piraato kwa bhʉkaari kʉmʉsabha amwisiririryɨ ajɨ agege ɨkɨtʉndʉ cha Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hanʉ Piraato iigwirɨ kʉbha bhwangʉbhu Yɨɨsu akuurɨ, akarʉgʉʉra! Akamʉbhɨrɨkɨra ʉmʉkʉrʉ wa abhasirikarɨ wurya korereke amenyeekererye arɨɨbhɨ maheene Yɨɨsu akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hanʉ aamɨnyɨɨkɨrɨɨryɨ kʉbha Yɨɨsu akuurɨ, Piraato akiisiririrya Yuusufu agege ɨkɨtʉndʉ. ");
INSERT INTO ikz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Neho Yuusufu wʉʉsi akagʉra ɨsanda ya zimpirya nzaru. Akiicha ɨkɨtʉndʉ kurwa kʉmʉsarabha, akakiringɨra nɨ ɨsanda. Akabhɨɨka ɨkɨtʉndʉ kirya mumbihɨra yɨnʉ yaakɨrɨsirwɨ kwitarɨ, akahiringitya riibhwɨ ikʉrʉ na kuribha kukisikʉ chi imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Mariyamu wa Magidarena na Mariyamu unina Yaakobho musuuhu na Yoose, bhakarora hanʉ aabhiikirwɨ. ");
INSERT INTO ikz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hanʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ rwahitirɨ, Mariyamu wa Magidarena, Saroome na Mariyamu unina Yaakobho, bhakagʉra amaguta go okoreetya, bhajɨ bhahakɨ ɨkɨtʉndʉ. ");
INSERT INTO ikz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma ritabhʉʉri, hanʉ iryʉbha ryatangirɨ kosomoka, bhakaja kumbihɨra ya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hanʉ bhaarɨ mʉnzɨra, bhakatanga kwibhuurya, “Nɨ‑wɨɨwɨ wʉnʉ akuturuushirya riibhwɨ rirya kukisikʉ chi imbihɨra?” ");
INSERT INTO ikz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nawe hanʉ bhaahikirɨ, bhakarora riibhwɨ rirya rihiringitiibhwɨ, riri rusizʉ, na ryarɨ ikʉrʉ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hanʉ bhaasikiirɨ mumbihɨra, bhakiitacha korora mumura wʉmwɨ ibhʉhirɨ engebho nzɨrʉ. Iikɨɨrɨ ʉrʉbhaara rwu ubhuryʉ rwi imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Neho akabhabhʉʉrɨra, “Mʉtʉʉbhaha! Nɨɨzɨ mʉramohya Yɨɨsu wa Nazarɨɨti, wʉnʉ aabhambirwɨ. Atarɨ hanʉ! Aryukirɨ, morore hanʉ bhaamʉtɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mujɨ mʉbhʉʉrɨrɨ abhɨɨga bhaazɨ, kɨnda Peetero kʉbha, Yɨɨsu arabhakangatɨra kuja Gariraaya. Iyo neyo mʉraamorore chɨmbu aabhabhuuriirɨ.” ");
INSERT INTO ikz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hanʉ bhiigwirɨbhu, bhakatanga kurigita kwa bhwʉbha na kʉrʉgʉʉra. Bhakarwa mumbihɨra hayo mwega. Bhataabhuuriirɨ mʉʉtʉ wʉwʉʉsi, kʉ kʉbha bhakʉʉbhaha.  ");
INSERT INTO ikz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hanʉ Yɨɨsu aaryukirɨ ritabhʉʉri urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma, akamuhwarʉkɨra hinga Mariyamu wa Magidarena, wʉnʉ aarɨ amuruushiryɨ amasambwa muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyamu akaja, akabhabhʉʉrɨra bhanʉ bhaarɨ hamwɨmwɨ na Yɨɨsu, na ribhaga riyo bhaarɨ bhararɨra na kwarama. ");
INSERT INTO ikz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nawe hanʉ bhiigwirɨ kʉbha Mariyamu akamorora mʉhʉru, bhatiisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Urusikʉ ruyoruyo, Yɨɨsu akahwarʉkɨra abhɨɨga bhaazɨ bhabhɨrɨ, aarɨ ni ikisisi kɨndɨ. Abhɨɨga bharya bhaarɨ kʉnzɨra bhararwa Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bhʉʉsi bhakagarʉka kʉbhabhʉʉrɨra abhakɨndichabhʉ, nawe abhɨɨga bhayo bhatiisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mʉtɨnɨrʉ, Yɨɨsu akahwarʉkɨra abhɨɨga bhaazɨ ikumi na wʉmwɨ, hanʉ bhaarɨ kwigari bhararya. Akabharecha kʉbhʉkʉngʼu bhwi imyʉyʉ jabhʉ, kʉ kʉbha bhaangirɨ kwisirirya ga abhakɨndichabhʉ bhanʉ bhaarʉʉzɨ Yɨɨsu hanʉ aaryukirɨ mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Neho akabhabhʉʉrɨra, “Mujɨ mubhyarʉ bhyʉsi, mʉbharwazɨrɨ abhaatʉ bhʉʉsi Ɨngʼana yaanɨ Ɨnzʉmu. ");
INSERT INTO ikz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wʉnʉ wʉʉsi ariisiriryɨ na kʉbhatiizwa, arasabhurwa. Nawe, wʉnʉ araangɨ kwisirirya, aratinirwa. ");
INSERT INTO ikz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abhaatʉ bhanʉ bhariisiriryɨ, bharakora ibhyɨrɨkɨnʼyʉ bhɨnʉ, ukuruusha amasambwa kʉbhaatʉ kuriina ryanɨ, ʉkʉgamba ɨbhɨgambʉ ibhihya, ");
INSERT INTO ikz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bhangagwata nzoka hamwɨ bhanganywa kegero cha kwita, kɨtakʉbhanyahaara. Bharabha bharatʉʉra amabhoko gaabhʉ kʉbharwɨrɨ, bhʉʉsi bharahora.” ");
INSERT INTO ikz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hanʉ Ʉmʉkʉrʉ Yɨɨsu aamarirɨ kʉgambana nabhʉ, Mungu akamogega kuja mwisaarʉ. Akiikara ʉrʉbhaara rwu ubhuryʉ rwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abhɨɨga bhaazɨ bharya bhakabhʉʉka, bhakaja kurwaza Ɨngʼana Ɨnzʉmu hagero hʉʉsi. Ʉmʉkʉrʉ Yɨɨsu aarɨ arabhaha amanaga go okokora ibhyɨrɨkɨnʼyʉ. Nɨmbu aarɨ aramenyeekererya amangʼana gayo kʉbha nɨ‑ga amaheene.");
INSERT INTO ikz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Umugungwa Tɨʉfirʉ, garya gaakʉrirwɨ gatɨ wɨɨtʉ, abhaatʉ bhaaru bhakʉrirɨ umucha gu ukwandɨka igʉrʉ wa amangʼana gayo. ");
INSERT INTO ikz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bhakaandɨka amangʼana bhwaheene chɨmbu abhaatʉ bhaagarʉʉzɨ kwɨma ʉbhʉtangɨ chɨmbu bhaatubhuuriirɨ, na bhanʉ bhaarɨ bharanyaraganʼya ɨngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hanʉ na niinyɨ namarirɨ kwisʉnza amangʼana gʉʉsi chɨmburya garɨ kwɨma ʉbhʉtangɨ, nɨkarora, nɨ‑bhwaheene nikwandɨkɨrɨ igʉrʉ wa gayo, ");
INSERT INTO ikz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","korereke omenye amaheene kwa ganʉ wiigiibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hanʉ Heroode aarɨ ʉmʉtɨmi wa Yudeya, aareho kuhaani wʉmwɨ, iriina ryazɨ Zaakariya, wi ikishoko cha abhakuhaani chabhirikirwa Abhiya. Na mʉkaazɨ Zaabhɨti, aarɨ wʉ ʉrʉganda rwa Haruuni. ");
INSERT INTO ikz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bhabhɨrɨ bhayo, bhakiisiriribhwa mʉbhʉtangɨ bhwa Mungu, bhakagwata imigirʉ na amaswaja gʉ Ʉmʉkʉrʉ gʉʉsi, bhakatuna zɨnzɨra zaazɨ, bhataana isoro. ");
INSERT INTO ikz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bhataarɨ na mwana, kʉ kʉbha Zaabhɨti aarɨ mʉgʉmba na bhaarɨ bhakunguhirɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Rusikʉ rʉmwɨ, riribhita rya kuhaani Zaakariya ryarɨ rɨrakora emeremo mʉbhʉtangɨ bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kʉmanarʉ ga abhakuhaani, Zaakariya akabhona umweya kusikɨra Aharɨndu ha Aharɨndu mwihekaaru, korereke amwocherye umurumbasʉ. ");
INSERT INTO ikz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na ribhaga ryu ukwocha umurumbasʉ, abhaatʉ bhaaru bhakiibhiringa igʉtʉ bharasabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rogendo rʉmwɨ, Zaakariya akahwarukirwa na maraika wʉ Ʉmʉkʉrʉ Mungu, akiimɨɨrɨra ʉrʉbhaara rwu ubhuryʉ rwa ahagero hu ukugundirirya umurumbasʉ. ");
INSERT INTO ikz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hanʉ Zaakariya aamʉrʉʉzɨ, akʉʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nawe maraika akamʉbhʉʉrɨra, “Zaakariya, ʉtʉʉbhaha! Mungu igwirɨ amasabhi gaazʉ. Mʉkaazʉ Zaabhɨti, arakwibhʉrɨra umwana wi ikisubhɨ, ʉmʉrʉkɨ Yoohana. ");
INSERT INTO ikz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Umwana wuyo arabha ne‑bhozomerwa kwa naawɨ, na bhaatʉ bhaaru bharazomerwa ukwibhurwa kwazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Arabha mʉkʉrʉ mʉbhʉtangɨ bhwʉ Ʉmʉkʉrʉ Mungu. Atakunywa amarwa gʉgʉʉsi garya, na kwɨma mʉnda ya unina arabha izuriibhwɨ Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na aragarucha Abhiiziraɨri bhaaru kʉMʉkʉrʉ Mungu waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Arakangatɨra Ʉmʉkʉrʉ ɨnʉ ane ekoro nʉ ʉbhʉnaja nchʉ ʉmʉrʉʉtɨrɨri Ɨɨriya, ariigwanʼya abhaana na bhawiisɨ, na kʉbhakora bhanʉ bhatakʉsʉʉka Mungu bhamʉsʉʉkɨ, bhiisiriribhwɨ mʉbhʉtangɨ bhwazɨ, na arabhatʉʉra bhwaheene abhaatʉ igʉrʉ wʉ Ʉmʉkʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zaakariya akabhʉʉrɨra maraika, “Inyɨ na mʉkaanɨ tukunguhirɨ! Tʉramenyabhwɨ riyo?” ");
INSERT INTO ikz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maraika akabhuga, “Inyɨ nɨ‑Gabhuryɨri, wʉnʉ nikwimɨɨrɨra mʉbhʉtangɨ bhwa Mungu. Newe antumirɨ niizɨ kʉkʉbhʉʉrɨra amangʼana amazʉmu ganʉ nikubhuuriirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kwɨma nangwɨnʉ ʉrabha imuumu, kʉ kʉbha utiisiriiryɨ amangʼana gaanɨ, na ʉtakʉtʉra kʉgamba kuhika gayo gakorwe kwibhaga ryaku.” ");
INSERT INTO ikz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Abhaatʉ bhanʉ bhaarɨ bhararɨnda Zaakariya ahʉrʉkɨ igʉtʉ bhakarʉgʉʉra korora akɨzɨɨrɨ mwihekaaru muyo. ");
INSERT INTO ikz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hanʉ aahurukirɨ, ataaturirɨ kʉgambana nabhʉ, akatanga kobheerekeererya na amabhoko kʉ kʉbha aarɨ akɨɨrɨ imuumu. Bhakamenya kʉbha arʉʉzɨ ʉbhʉrʉri mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zisikʉ zaazɨ zo okohocha emeremo mwihekaaru zɨkasira, akaja yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Akʉmara, mʉkaazɨ Zaabhɨti akagega ɨnda, akamara imyɨri ɨtaanʉ ariibhisa, ");
INSERT INTO ikz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","akabhuga, “Ʉmʉkʉrʉ Mungu, newe ankʉrɨɨrɨbhu! Anduushiryɨ zɨsʉni kʉbhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hanʉ ɨnda ya Zaabhɨti yaahichiryɨ imyɨri ɨsaasabha, Mungu akatʉma maraika Gabhuryɨri mʉrʉbhɨri rwa Nazarɨɨti, mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Akatumwa kumuucha wʉmwɨ umusiiti, arabhirikirwa Mariyamu, aarɨ arunjibhwɨ nu umumura wʉmwɨ iriina ryazɨ Yuusufu, wi ikishoko chʉ ʉmʉtɨmi Daudi. ");
INSERT INTO ikz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maraika wuyo akaja kwa Mariyamu, akamʉbhʉʉrɨra, “Nɨrakokeerya, awɨ wʉnʉ ʉhɨɨrwɨ ʉrʉbhangʉ! Ʉmʉkʉrʉ Mungu arɨ hamwɨmwɨ na naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hanʉ Mariyamu iigwirɨ amangʼana ga maraika, akiiyigwa kɨbhɨ bhʉkʉngʼu, akiibhuurya, “Makeerenʼyakɨ ganʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maraika akamʉbhʉʉrɨra, “Mariyamu ʉtʉʉbhaha! Mungu akʉrʉrɨɨrɨ ɨbhɨgʉngi. ");
INSERT INTO ikz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ʉragega ɨnda, na uriibhʉra umwana wi ikisubhɨ, ʉmʉrʉkɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Arabha mʉkʉrʉ, na arabhirikirwa Umwana wa Wʉnʉ Ari Igʉrʉ wa Bhyʉsi. Ʉmʉkʉrʉ Mungu ariimiirirya ʉbhʉtɨmi bhwa Daudi wisɨɨkʉrʉ, na komoha umwana wuyo. ");
INSERT INTO ikz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Arakangata ikishoko cha Abhiiziraɨri kemerano. Ʉbhʉtɨmi bhwazɨ bhʉtaana tɨnɨrʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyamu akabhuurya maraika, “Ɨrabhabhwɨ, inyɨ ni‑musiiti?” ");
INSERT INTO ikz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maraika akamʉgarukirya, “Ekoro Ɨndɨndu ɨrakwikɨra, na zinguru za Mungu wi Igʉrʉ wa Bhyʉsi zɨrabha kwa naawɨ. Necho umwana wʉnʉ uriibhʉrɨ, arabha mʉrɨndu, na arabhirikirwa Umwana wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hamwɨmwɨ na gayo, umuhiiri waazʉ Zaabhɨti agɨgirɨ ɨnda yu umwana wi ikisubhɨ nangabha mʉkɨɨkʉrʉ. Akagambwa na abhaatʉ kʉbha mʉgʉmba, nangwɨnʉ ana myɨri ɨsaasabha. ");
INSERT INTO ikz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gayo gabhɨɨrɨ kʉ kʉbha kwa Mungu rɨtareeho rɨnʉ rɨtakʉtʉrɨkana.” ");
INSERT INTO ikz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Akagarukirya, “Inyɨ omohocha wʉ Ʉmʉkʉrʉ Mungu, ɨbhɨ kwa niinyɨ chɨmbu ubhugirɨ.” Rogendo rʉmwɨ maraika akaja. ");
INSERT INTO ikz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Zisikʉ ziyo, Mariyamu akabhʉʉka akaja wa Zaabhɨti, mʉrʉbhɨri rʉmwɨ rwa mʉbhɨgʉrʉ bhya Yuuda. ");
INSERT INTO ikz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akasikɨra wa Zaakariya akakeerya Zaabhɨti. ");
INSERT INTO ikz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hanʉ Zaabhɨti igwirɨ amakeerenʼya gayo, umwana akabhina mʉnda yaazɨ. Neho Ekoro Ɨndɨndu ikiikɨra Zabhɨɨti, ");
INSERT INTO ikz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","rogendo rʉmwɨ, akagamba kwiraka ikʉrʉ, “Mʉbhakari bhʉʉsi, awɨ ʉhakirwɨ! Nu umwana wʉnʉ uriibhʉrɨ ahɨɨrwɨ ʉrʉbhangʉ! ");
INSERT INTO ikz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Inyɨ nɨ‑wɨɨwɨ, kuhika unina Ʉmʉkʉrʉ wɨɨtʉ iizirɨ konkeerya? ");
INSERT INTO ikz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hanʉ niigwirɨ amakeerenʼya gaazʉ, umwana akabharaana mʉnda yaanɨ kwa bhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hakɨrɨku awɨ kʉ kʉbha wiisiriiryɨ ganʉ Ʉmʉkʉrʉ Mungu aakubhuuriirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyamu akabhuga, “Ekoro yaanɨ, ɨrakumya Ʉmʉkʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɨrazomerwa Mungu, Ʉmʉsabhuri waanɨ, ");
INSERT INTO ikz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kʉ kʉbha arʉʉzɨ ʉbhʉnyʉʉhɨrɨru bhwo omohocha waazɨ. Kwɨma nangwɨnʉ, zinyibhʉrʉ zʉʉsi zɨrambɨrɨkɨra, wʉ ʉrʉbhangʉ, ");
INSERT INTO ikz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kʉ kʉbha Mungu wa zinguru, ankʉrɨɨrɨ amangʼana amakʉrʉ, iriina ryazɨ irɨndu. ");
INSERT INTO ikz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nɨ ɨbhɨgʉngi bhyazɨ, bhyahaaja kuzinyibhʉrʉ zʉʉsi zɨnʉ zekomosengera. ");
INSERT INTO ikz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akʉrirɨ amangʼana makʉrʉ kuzinguru zaazɨ. Abhanyaragɨɨnʼyɨ bhanʉ bhakwiyigwa mozekoro zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Agwishiryɨ abhakʉrʉ kurwa kubhitumbɨ bhyabhʉ bhyɨ ɨkɨtɨmi, na kʉbhakurya abhaatʉ bhi iyaasɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bhɨ ɨnzara, abhiigutiryɨ amazʉmu, nawe abhaniibhi abhahɨɨbhirɨ mabhoko bhʉʉha. ");
INSERT INTO ikz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Asakiiryɨ Abhiiziraɨri, abhahocha bhaazɨ, korereke kuhiita ɨbhɨgʉngi bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akakora chɨmbu aabhuuriirɨ Abhurahaamu na bhasʉʉkʉrʉ, na abhaatʉ bhu urwibhʉrʉ rwazɨ kemerano.” ");
INSERT INTO ikz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hanʉ Mariyamu aamarirɨ imyɨri ɨtatʉ wa Zaabhɨti, akagarʉka yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hanʉ zisikʉ zu ukwibhʉra kwa Zaabhɨti zaahikirɨ, akiibhʉra umwana wi ikisubhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bhanyarʉbhɨri na abhahiiri bhaazɨ, bhakiigwa chɨmbu Ʉmʉkʉrʉ Mungu arʉrɨɨrɨ Zaabhɨti ɨbhɨgʉngi bhʉkʉngʼu, bhakazomerwa hamwɨmwɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hanʉ umwana aahikiryɨ urusikʉ rwa kanaanɨ, bhakamʉsaara, bhakeenda komotoga iriina rya wiisɨ, Zaakariya. ");
INSERT INTO ikz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nawe unina akaanga, akabhuga, “Zɨyi! Abhirikirwɨ Yoohana.” ");
INSERT INTO ikz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhakamʉbhʉʉrɨra, “Ndora mukishoko chanyu, atariimu wi iriina riyo!” ");
INSERT INTO ikz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bhakabhuurya wiisɨ kwa kumusimya na amabhoko, abhabhʉʉrɨrɨ iriina rɨnʉ akwenda kotoga umwana waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Akabhasabha ritɨnɨka ryʉ ʉrʉbhao akaandɨka, “Iriina ryazɨ, newe Yoohana.” Bhʉʉsi bhakarʉgʉʉra. ");
INSERT INTO ikz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Rogendo rʉmwɨ umunywa nʉ ʉrʉrɨmɨ rwazɨ bhɨkatiguurukirwa, akatanga kʉgamba, akakumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bhanyarʉbhɨri bhʉʉsi bhakahaha, na amangʼana gayo gakanyaragana mbaara zʉʉsi mʉbhɨgʉrʉ bhya Yudeya. ");
INSERT INTO ikz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Abhaatʉ bhanʉ bhiigwirɨ, bhakiibhuurya, “Umwana wʉnʉ arabha mʉʉtʉkɨ?” kʉ kʉbha ʉbhʉnaja bhwʉ Ʉmʉkʉrʉ Mungu bhwarɨ hamwɨmwɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zaakariya, wiisɨ umwana wuyo, akiizuribhwa ne Ekoro Ɨndɨndu, akahurucha ʉbhʉrʉʉti, ");
INSERT INTO ikz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Akumibhwɨ Ʉmʉkʉrʉ Mungu wa Abhiiziraɨri, kʉ kʉbha iizirɨ kʉbhaatʉ bhaazɨ, kʉbhasabhʉra. ");
INSERT INTO ikz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atʉhɨɨrɨ Ʉmʉsabhuri wa zinguru, wi ikishoko cho omohocha waazɨ Daudi, ");
INSERT INTO ikz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","chɨmbu aagambirɨ kwɨma ɨkarɨ kʉnzɨra ya abharʉʉtɨrɨri bhaazɨ abharɨndu. ");
INSERT INTO ikz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Akaraga kʉtʉsabhʉra mʉmabhoko ga abhabhisa na abhabhiihirirwa bhɨɨtʉ, ");
INSERT INTO ikz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","na kuhiita ʉbhʉragɨ bhwazɨ bhʉrɨndu kʉbharorera ɨbhɨgʉngi bhasʉʉkʉrʉ bhɨɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ʉbhʉragɨ bhuyo, nebhwe irahiirɨ na sʉʉkʉrʉ wɨɨtʉ Abhurahaamu. ");
INSERT INTO ikz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tʉsabhurwɨ kurwa mʉmabhoko ga abhabhisa bhɨɨtʉ, korereke tomohokerye tʉtaana bhwʉbha, ");
INSERT INTO ikz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tʉbhɨ bharonge na bhaheene, sikʉ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na naawɨ mwana waanɨ, ʉrabhirikirwa ʉmʉrʉʉtɨrɨri wa Mungu wi Igʉrʉ wa Bhyʉsi, ʉrakangatɨra Ʉmʉkʉrʉ, komokonzera ɨnzɨra yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na ʉbhʉʉrɨrɨ abhaatʉ bhaazɨ igʉrʉ wʉ ʉbhʉsabhurwa, kʉnzɨra yo okobheererwa ʉbhʉbhɨ bhwabhʉ, ");
INSERT INTO ikz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","igʉrʉ wɨ ɨbhɨgʉngi bhya Mungu wɨɨtʉ, ʉbhʉsabhurwa bhuyo, bhʉraaza nchu ubhwɨrʉ kurwa mwisaarʉ, ");
INSERT INTO ikz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na bhʉrabhanzɨra bhanʉ bhakwikara mukiirimya, na mukikiriiri chu uruku. Na kʉtʉkangatɨra, kuhika kogenda kʉnzɨra yo omorembe.” ");
INSERT INTO ikz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Umwana akakʉra, akabha na zinguru mokoro yaazɨ, akaja kwikara mwitɨrɨgʉ, kuhika hanʉ aarʉrɨkɨɨnɨ kuBhiiziraɨri. ");
INSERT INTO ikz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Zisikʉ ziyo, Kaisaari Agusitʉ ʉmʉtɨmi ʉmʉkʉrʉ wa Ruumi, akaswaja abhaatʉ bhʉʉsi bha zɨɨsɨ zʉ ʉbhʉtɨmi bhwazɨ bhabharwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ʉkʉbharwa kwarɨ kwe embere, kʉkakorwa hanʉ Kurɨɨniyo aarɨ ʉmʉkangati wa Siiriya. ");
INSERT INTO ikz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Abhaatʉ bhʉʉsi bhakaja kʉbharwa, mʉzɨmbɨri zi ibhishoko bhyabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufu wʉʉsi akarwa mʉrʉbhɨri rwa Nazarɨɨti, mucharʉ cha Gariraaya, akatiira kuja Yudeya, mʉrʉbhɨri rwa Bhɨtɨrɨhɨɨmu, kʉ kʉbha nerwe ʉrʉbhɨri rwa Daudi, na aarɨ wi ikishoko chazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akaja kwandɨkwa hamwɨmwɨ na Mariyamu umurunjibhwa waazɨ, ɨnʉ Mariyamu aritʉhirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bhakɨɨrɨ iyo, ribhaga ryu ukwitʉʉranʼya kwa Mariyamu rɨkahika, ");
INSERT INTO ikz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","akiitʉʉranʼya mʉtangi wi ikisubhɨ mwibhanza ryi imitugʉ. Akamwibhisha ɨbhɨtambaara bhya abhaana, akamuhindirya mwitʉrɨ ryu ukuriishirya imitugʉ. Akiitʉʉranirya hayo kʉ kʉbha bhatabhwɨnɨ umweya munyumba ya abhagini. ");
INSERT INTO ikz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ubhutikʉ bhu urusikʉ ruyo, bhaareho abhariisha bharariibha imitugʉ jabhʉ mumwarʉ. ");
INSERT INTO ikz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Maraika wʉ Ʉmʉkʉrʉ Mungu, akabhahwarʉkɨra, ubhwɨrʉ bhwʉ Ʉmʉkʉrʉ Mungu bhʉkabhanza mbaara zʉʉsi pee! Bhakahaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nawe maraika akabhabhʉʉrɨra, “Mʉtʉʉbhaha! Nɨbharɨɨtɨɨrɨ ɨngʼana ɨnzʉmu yɨnʉ ekozomera abhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Reero yɨnʉ, mʉrʉbhɨri rwa Daudi ibhwirwɨ Ʉmʉsabhuri waanyu, newe Kiriisitʉ Ʉmʉkʉrʉ! ");
INSERT INTO ikz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ichɨrɨkɨnʼyʉ cho okobheerekenʼya gayo nɨ‑kɨnʉ, mʉrabhona umwana ʉmʉbhataarɨ, bhamuhindiiryɨ mwitʉrɨ ryʉ ʉkʉrɨɨra imitugʉ, bhamwibhishiryɨ ɨbhɨtambaara bhya abhaana.” ");
INSERT INTO ikz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Rogendo rʉmwɨ, bhakabhaho ɨbhɨkwɨ bhya bhamaraika abhakɨndichazɨ kurwa mwisaarʉ, bharakumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Akumibhwɨ Mungu wa mwisaarʉ. Na kʉʉsɨ, omorembe gʉbhɨ kʉbhaatʉ bhanʉ asɨɨgirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hanʉ bhamaraika bhayo bhaagarukirɨ mwisaarʉ, abhariisha bhakabhuga, “Tujɨ Bhɨtɨrɨhɨɨmu, twirorere gayo gakʉrirwɨ chɨmbu Ʉmʉkʉrʉ Mungu aatubhuuriirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bhakaja mwega, bhakabhona Mariyamu na Yuusufu, nu umwana ʉmʉbhataarɨ bhamuhindiiryɨ mwitʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Abhariisha bhayo hanʉ bhaamʉrʉʉzɨ umwana wuyo, bhakabhʉʉrɨra abhaatʉ amangʼana gayo chɨmbu bhiigwirɨ igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bhʉʉsi bhanʉ bhiigwirɨ amangʼana ga abhariisha, bhakarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nawe Mariyamu akagatʉʉra gʉʉsi mokoro yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Abhariisha bharya bhakagarʉka, bharagʉnga Mungu, na koheema kwa gʉʉsi ganʉ bhiigwirɨ na kʉgarora, na gʉʉsi gakabha chɨmbu bhaabhuuriirwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hanʉ umwana wuyo aahichiryɨ sikʉ inyanyɨ, bhakamʉsaara, bhakamʉrʉka Yɨɨsu. Neryo iriina maraika aamʉhɨɨrɨ, hanʉ unina aarɨ akɨɨrɨ kogega ɨnda. ");
INSERT INTO ikz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yuusufu na Mariyamu, bhakamara zisikʉ zaabhʉ zʉ ʉkʉbhɨngukibhwa, chɨmburya imigirʉ ja Musa gɨrɨ. Bhakahira Yɨɨsu Yɨrusarɨɨmu, korereke bhamʉtʉʉrɨ mʉbhʉtangɨ bhwʉ Ʉmʉkʉrʉ Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bhakeenderwa kokorabhu, kʉ kʉbha yandikirwɨ mumigirʉ jʉ Ʉmʉkʉrʉ Mungu kʉbha, “Abhaana bhʉʉsi bhamʉtangi bhi ikisubhɨ, bhareenderwa bhatuurwɨ kʉMʉkʉrʉ Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hamwɨmwɨ na gayo, bhakeenda bhahuruchɨ ikimweso chɨmbu ɨkʉgambwa mumigirʉ jʉ Ʉmʉkʉrʉ, “Bhahuruchɨ ibhiguuti bhɨbhɨrɨ, hamwɨ amakunɨ abhɨrɨ gi ibhiguuti.” ");
INSERT INTO ikz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mʉrʉbhɨri rwa Yɨrusarɨɨmu, aarɨ areho ʉmʉʉtʉ wʉmwɨ, iriina ryazɨ Simiyʉʉni. Akabha moheene, moronge mʉbhʉtangɨ bhwa Mungu, aarɨ ararɨnda korora kʉsabhurwa kwa Abhiiziraɨri, ne Ekoro Ɨndɨndu yaarɨ hamwɨmwɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ekoro Ɨndɨndu yaarɨ ɨmarirɨ kumwerecha kʉbha, atakukwa akɨɨrɨ korora Kiriisitʉ wʉ Ʉmʉkʉrʉ Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ekoro Ɨndɨndu ɨkakangata Simiyʉʉni akasikɨra mwihekaaru, na abhiibhuri bha Yɨɨsu bhakareeta Yɨɨsu muyo, bhamokorere chɨmbu amanarʉ gi imigirʉ gaarɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyʉʉni akagega Yɨɨsu mʉmabhoko gaazɨ, akakumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Akabhuga, “Awɨ Ʉmʉkʉrʉ, nɨrʉʉzɨ uhikiryɨ ʉbhʉragɨ bhwazʉ, nangʉ nyiisiririrya inyɨ omohocha waazʉ, nijɨ no omorembe, ");
INSERT INTO ikz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kʉ kʉbha kʉmɨɨsʉ gaanɨ, niirʉrɨɨrɨ ubhutuurya bhʉnʉ ʉrɨɨtirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ʉbhʉkʉnzirɨ bhororwe na abhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ubhutuurya bhuyo ni‑bhwɨrʉ bhukwerecha ɨnzɨra yaazʉ kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi, kuhika na abhaatʉ bhaazʉ Abhiiziraɨri bhʉʉsi bhakumibhwɨ igʉrʉ wu ubhutuurya bhuyo.” ");
INSERT INTO ikz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Amangʼana ganʉ Simiyʉʉni aagambirɨ igʉrʉ wu umwana wuyo, gakaruguurya abhiibhuri bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyʉʉni akabhaha ʉrʉbhangʉ, akabhʉʉrɨra Mariyamu unina umwana akabhuga, “Rora! Umwana wʉnʉ arʉbhwɨrwɨ na Mungu kʉbha abharimiryɨ Abhiiziraɨri nu ukutuurya Abhiiziraɨri abhandɨ bhaaru. Na arabha ichɨrɨkɨnʼyʉ cha Mungu kɨnʉ kɨkwangwa na abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Abhaatʉ bhayo amiisɨɨgi ganʉ gabhisirwɨ mozekoro zaabhʉ garorekanɨ habhwɨrʉ. Na naawɨ mokoro yaazʉ ʉranyahaarɨka bhʉkʉngʼu, kina ʉsʉmirwɨ na risabha.” ");
INSERT INTO ikz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na aareho ʉmʉrʉʉtɨrɨri wʉmwɨ, mʉkari mʉkɨɨkʉrʉ bhʉkʉngʼu, iriina ryazɨ Ana, muucha wa Fanwɨri, wɨ ɨkɨgambʉ cha Ashɨri. Ana akiikara nu umusubhɨ waazɨ imyaka muhungatɨ, umusubhɨ waazɨ akakwa, ");
INSERT INTO ikz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","akabha umukwirwa kuhika akahicha imyaka merongo ɨnaanɨ ne ene. Ribhaga ryʉsi akasaaga mwihekaaru, ɨnʉ arasabha Mungu ubhutikʉ nu umwise, na sikʉ nzaru aarɨ ariiyima kurya. ");
INSERT INTO ikz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ribhaga riyoriyo Yɨɨsu akareetwa, Ana akamorora, akatanga kukumya Mungu, akagamba ingʼana igʉrʉ wu umwana wuyo, kwa abhaatʉ bhʉʉsi bhanʉ bhaarɨ bhararɨnda Mungu asabhʉrɨ Abhiiziraɨri. ");
INSERT INTO ikz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hanʉ Yuusufu na Mariyamu bhaamarirɨ kokora gʉʉsi, chɨmburya yaarɨ ikwenderwa mumigirʉ jʉ Ʉmʉkʉrʉ Mungu, bhakagarʉka mʉrʉbhɨri rwabhʉ rwa Nazarɨɨti, mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Umwana akakʉra, akoongera amanaga, akiizuribhwa ubhwʉbhʉʉri, nɨ ɨbhɨgʉngi bhya Mungu bhyarɨ igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Abhiibhuri bha Yɨɨsu, bhahaaja Yɨrusarɨɨmu imyaka jʉsi, isigukuru yɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hanʉ Yɨɨsu aabhɨɨrɨ ni imyaka ikumi nɨ ɨbhɨrɨ, abhiibhuri bhaazɨ bhakaja nawe, kʉrɨngʼaana na amanarʉ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zisigukuru zɨkasira, abhiibhuri bha Yɨɨsu bhakatanga orogendo kʉgarʉka ɨwaabhʉ, nawe ewe akasaaga Yɨrusarɨɨmu abhiibhuri bhataamɨnyirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhakakina aarɨ hamwɨmwɨ na abhakɨndichabhʉ morogendo. Bhakahooya umwise nyangima mʉnzɨra, bharamomohya gatɨ wa abhahiiri na abhasaani, ");
INSERT INTO ikz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","bhatamubhwɨnɨ, neho bhakagarʉka Yɨrusarɨɨmu komomohya. ");
INSERT INTO ikz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Urusikʉ rwa katatʉ, bhakamobhona mwihekaaru, iikɨɨrɨ gatɨgatɨ wa abhiija arabhiitegeerera na kʉbhabhuurya. ");
INSERT INTO ikz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abhaatʉ bhʉʉsi bhanʉ bhiigwirɨ chɨmbu akubhuga, bhakarʉgʉʉra bhʉkʉngʼu igʉrʉ wa amangʼɨɨni na amagarukirya gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hanʉ abhiibhuri bhaazɨ bhaamʉrʉʉzɨ, bhakarʉgʉʉra bhʉkʉngʼu. Unina akamʉbhʉʉrɨra, “Mwana waanɨ, nɨkɨ ʉtʉkʉrirɨbhu? Ndora inyɨ na wuusʉ, twarɨ twʉbhahirɨ bhʉkʉngʼu tʉrakomohya!” ");
INSERT INTO ikz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akamʉgarukirya, “Kwakɨ mwarɨ mʉramonhya? Mʉtɨɨzɨ nereenderwa kʉbha munyumba ya Bhaabha waanɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nawe abhiibhuri bhaazɨ bhataamɨnyirɨ rigarukirya riyo. ");
INSERT INTO ikz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Akʉmara, bhakaja nawe yɨɨka waabhʉ Nazarɨɨti, akabha arabhasʉʉka. Gayo gʉʉsi gaakʉrirwɨ, unina waazɨ akagatʉʉra mokoro yaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yɨɨsu akakʉra, akabha nu ubhwʉbhʉʉri ni ikihiko, arazomera Mungu na abhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Gwarɨ umwaka gwi ikumi na kataanʉ, gwʉ ʉbhʉtɨmi bhwʉ ʉmʉtɨmi ʉmʉkʉrʉ Tibhɨriyo. Ʉmʉkʉrʉ wa mucharʉ cha Yudeya aarɨ Pʉntiyʉ Piraato, na wʉnʉ aarɨ aratema mucharʉ cha Gariraaya aarɨ Heroode. Wʉnʉ aarɨ aratema mucharʉ cha Itureya na cha Tarakoniti aarɨ Firipʉ, umwabhʉ Heroode, na wʉnʉ aarɨ aratema mucharʉ cha Abhirene aarɨ Risania. ");
INSERT INTO ikz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ribhaga rɨnʉ Anaasi na Kayaafa bhaarɨ abhakʉrʉ bha abhakuhaani. Kwibhaga riyo, ɨngʼana ya Mungu ɨkamuhikɨra Yoohana, umwana wa Zaakariya mwitɨrɨgʉ. ");
INSERT INTO ikz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yoohana akaja akagenda mucharʉ chʉsi rusizʉ wɨ ɨkɨtaarʉ cha Yorodaani, ɨnʉ ararwazɨra abhaatʉ, bhatigɨ ʉbhʉbhɨ, bhabhatiizwɨ, korereke Mungu abhabheerere. ");
INSERT INTO ikz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɨngʼana yiyo ɨkahikɨra Yoohana, chɨmbu yandikirwɨ nʉ ʉmʉrʉʉtɨrɨri Isaaya mʉkɨtabhʉ chazɨ: “Riraka ryʉ ʉmʉʉtʉ wʉnʉ akʉraganʼya mwitɨrɨgʉ, ‘Mokonze ɨnzɨra yʉ Ʉmʉkʉrʉ, mogorore ɨbhɨhɨtʉ bhyazɨ! ");
INSERT INTO ikz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amarʉʉma gʉʉsi gararindwa, ɨbhɨgʉrʉ nɨ ɨhɨgʉrʉ bhɨranyaraganibhwa. Hanʉ hiisisirɨ, haragororwa. Zɨnzɨra zɨmbɨ zɨrakonzwa. ");
INSERT INTO ikz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Neho abhaatʉ bhʉʉsi bharaarore ubhutuurya bhwa Mungu.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abhaatʉ bhaaru bhakabha bharaaza kwa Yoohana abhabhatiizɨ, nawe akabhabhʉʉrɨra, “Imwɨ urwibhʉrʉ rwe enzoka! Wɨɨwɨ abhabhuuriirɨ mʉratʉra kongʼosa ɨtɨnɨrʉ ya Mungu yɨnʉ ikuuza? ");
INSERT INTO ikz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mokore amangʼana ganʉ gakwerekenʼya kʉbha mutigirɨ ʉbhʉbhɨ! Mutiikangirirya naatu mʉrabhuga, ‘Sʉʉkʉrʉ wɨɨtʉ, nɨ‑Abhurahaamu.’ Nɨrabhabhʉʉrɨra, Mungu aratʉra kuchʉra amabhwɨ ganʉ gabhɨ abhaana bha Abhurahaamu! ");
INSERT INTO ikz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nangʉ ɨtɨnɨrʉ ya Mungu iri igʉrʉ waanyu nchɨ ɨhaazi iri igʉrʉ wa amatina gɨ ɨmɨtɨ. Na bhanʉ bhatakokora amahocha amazʉmu bharatinirwa, chɨmbu ɨmɨtɨ jʉsi gɨnʉ gɨtakwibhʉra imisumʉ ɨmɨzʉmu gɨhaatinwa na kʉtaashwa momorero.” ");
INSERT INTO ikz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Neho riribhita rya abhaatʉ rɨkabhuurya Yoohana, “Nangʉ tokorebhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akabhagarukirya, “Wʉnʉ ana shadi ibhɨrɨ, ahuruchɨ ɨyɨmwɨ kwa wʉnʉ ataanayʉ na wʉnʉ ani ibhyakurya, wʉʉsi amosondere wʉnʉ ataanabhyʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kwiribhita riyo bhaareho abharihya bha rigʉʉti, bhʉʉsi bhakiizɨra Yoohana abhabhatiizɨ. Bhakamubhuurya, “Umwija, na niitwɨ tokorebhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akabhagarukirya, “Moreegege rigʉʉti, mʉtagega kʉkɨra rɨnʉ mubhuuriirwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bhaareho abhasirikarɨ, bhʉʉsi bhakamubhuurya, “Na niitwɨ, tokorebhwɨ?” Akabhagarukirya, “Mʉtagega bhegero bhya mʉʉtʉ wʉwʉʉsi kwa nguru, hamwɨ komogobha ingʼana korereke mobhone zimpirya! Nawe mwisiriranʼyɨ na amarihi gaanyu.” ");
INSERT INTO ikz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Abhaatʉ bhʉʉsi, bhakabha bhariibhuurya mozekoro zaabhʉ igʉrʉ wa Yoohana, kʉ kʉbha bhaarɨ bhariiseega kʉbha, hamwɨ newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nawe, akabhabhʉʉrɨra bhʉʉsi, “Inyɨ, nɨrabhabhatiiza na amanzi, nawe araaza inyuma waanɨ, ʉmʉʉtʉ wʉnʉ akʉnkɨra ʉbhʉnaja. Nɨtakwenderwa nʉʉrʉ kʉtazʉra zisiri zi ibhikwɨra bhyazɨ! Ewe arabhabhatiiza kwe Ekoro Ɨndɨndu, na komorero. ");
INSERT INTO ikz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ewe anʉ ʉrʉhʉngʉ mʉmabhoko gaazɨ, korereke aseese ɨnganʉ. Arakumɨngɨra ɨnganʉ mʉkɨtara chazɨ, nawe ʉmʉkʉʉnyʉ, aragwocha momorero gʉnʉ gʉtakurima zee.” ");
INSERT INTO ikz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kʉmangʼana maaru gayo na agandɨ, Yoohana aarɨ arabheerekeererya abhaatʉ bhayo Ɨngʼana Ɨnzʉmu kurwa kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nawe, hanʉ Yoohana aamʉhaariirɨ ʉmʉtɨmi Heroode, igʉrʉ wo okogega Hɨrʉʉdiya, ʉmʉkari wu umunyi waazɨ, na kʉmabhɨ agandɨ gʉʉsi ganʉ aakʉrirɨ, ");
INSERT INTO ikz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroode akoongera ʉbhʉbhɨ bhuyo, ko komobhoha Yoohana mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hanʉ Yoohana aarɨ akɨɨrɨ kobhohwa, abhaatʉ bhaaru bhaarɨ bharabhatiizwa neewe, Yɨɨsu wʉʉsi akaaza akabhatiizwa. Hanʉ aarɨ arasabha, risaarʉ rikiigʉka. ");
INSERT INTO ikz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ekoro Ɨndɨndu ikiika igʉrʉ waazɨ nchi ikiguuti, na riraka rɨkarwa mwisaarʉ, rɨrabhuga, “Awɨ ni‑Mwana waanɨ ʉmʉsɨɨgwa, nɨzʉmɨrɨɨrwɨ na naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Hanʉ Yɨɨsu aatangirɨ emeremo jazɨ, aarɨ ni imyaka merongo ɨtatʉ. Abhaatʉ bhaarɨ bharakina ni‑mwana wa Yuusufu. ");
INSERT INTO ikz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Na Yuusufu wuyo, aarɨ mwana wa Hɨri. Na Hɨri, aarɨ mwana wa Matati. Matati, aarɨ mwana wa Raawi. Raawi, aarɨ mwana wa Mɨriki. Mɨriki, aarɨ mwana wa Yana. Yana, aarɨ mwana wa Yuusufu. ");
INSERT INTO ikz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yuusufu, aarɨ mwana wa Matatia. Matatia, aarɨ mwana wa Amʉʉsi. Amʉʉsi, aarɨ mwana wa Nahuumu. Nahuumu, aarɨ mwana wa Ɨsiri. Ɨsiri, aarɨ mwana wa Nagayi. ");
INSERT INTO ikz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi, aarɨ mwana wa Maati. Maati, aarɨ mwana wa Matatia. Matatia, aarɨ mwana wa Sɨmɨyi. Sɨmɨyi, aarɨ mwana wa Yʉsɨki. Yʉsɨki, aarɨ mwana wa Yoda. ");
INSERT INTO ikz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda, aarɨ mwana wa Yoohanani. Yoohanani, aarɨ mwana wa Resa. Resa, aarɨ mwana wa Zɨrubhabhɨɨri. Zɨrubhabhɨɨri, aarɨ mwana wa Sheyaritiyɨri. Sheyaritiyɨri, aarɨ mwana wa Nɨri. ");
INSERT INTO ikz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɨri, aarɨ mwana wa Mɨriki. Mɨriki, aarɨ mwana wa Adi. Adi, aarɨ mwana wa Kosamu. Kosamu, aarɨ mwana wa Ɨrimadamu. Ɨrimadamu, aarɨ mwana wa Ɨri. ");
INSERT INTO ikz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɨri, aarɨ mwana wa Yʉʉshwa. Yʉʉshwa, aarɨ mwana wa Ɨriyɨɨzɨri. Ɨriyɨɨzɨri, aarɨ mwana wa Yʉrimu. Yʉrimu, aarɨ mwana wa Matati. Matati, aarɨ mwana wa Raawi. ");
INSERT INTO ikz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Raawi, aarɨ mwana wa Simiyʉʉni. Simiyʉʉni, aarɨ mwana wa Yuuda. Yuuda, aarɨ mwana wa Yuusufu. Yuusufu, aarɨ mwana wa Yoonamu. Yoonamu, aarɨ mwana wa Ɨriyakimu. ");
INSERT INTO ikz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɨriyakimu, aarɨ mwana wa Mereya. Mereya, aarɨ mwana wa Mena. Mena, aarɨ mwana wa Matata. Matata, aarɨ mwana wa Natani. Natani, aarɨ mwana wa Daudi. ");
INSERT INTO ikz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi, aarɨ mwana wa Yeese. Yeese, aarɨ mwana wa Ʉbhɨɨdi. Ʉbhɨɨdi, aarɨ mwana wa Bhoowazi. Bhoowazi, aarɨ mwana wa Sarimʉʉni. Sarimʉʉni, aarɨ mwana wa Nashʉni. ");
INSERT INTO ikz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashʉni, aarɨ mwana wa Aminadaabhu. Aminadaabhu, aarɨ mwana wa Adimini. Adimini, aarɨ mwana wa Arini. Arini, aarɨ mwana wa Hɨzirʉʉni. Hɨzirʉʉni, aarɨ mwana wa Pɨrɨɨsi. Pɨrɨɨsi, aarɨ mwana wa Yuuda. ");
INSERT INTO ikz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuuda, aarɨ mwana wa Yaakobho. Yaakobho, aarɨ mwana wa Iisaka. Iisaka, aarɨ mwana wa Abhurahaamu. Abhurahaamu, aarɨ mwana wa Teera. Teera, aarɨ mwana wa Nahʉʉri. ");
INSERT INTO ikz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahʉʉri, aarɨ mwana wa Sɨrugi. Sɨrugi, aarɨ mwana wa Rɨɨhu. Rɨɨhu, aarɨ mwana wa Pɨrɨɨgi. Pɨrɨɨgi, aarɨ mwana wa Ɨbhɨɨri. Ɨbhɨɨri, aarɨ mwana wa Saara. ");
INSERT INTO ikz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saara, aarɨ mwana wa Kɨnani. Kɨnani, aarɨ mwana wa Arufakisadi. Arufakisadi, aarɨ mwana wa Shɨmu. Shɨmu, aarɨ mwana wa Nuuhu. Nuuhu, aarɨ mwana wa Raamɨki. ");
INSERT INTO ikz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Raamɨki, aarɨ mwana wa Mɨtuseera. Mɨtuseera, aarɨ mwana wa Ɨnʉki. Ɨnʉki, aarɨ mwana wa Yarɨɨdi. Yarɨɨdi, aarɨ mwana wa Mahararɨɨri. Mahararɨɨri, aarɨ mwana wa Kɨnani. ");
INSERT INTO ikz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kɨnani, aarɨ mwana wa Ɨnʉshi. Ɨnʉshi, aarɨ mwana wa Sɨɨti. Sɨɨti, aarɨ mwana wa Adaamu. Na Adaamu ewe, aarɨ umwana wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yɨɨsu akarwa ahagero hɨ ɨkɨtaarʉ cha Yorodaani, yizwirɨ Ekoro Ɨndɨndu. Ekoro Ɨndɨndu ɨkabha ɨramʉkangatya mwitɨrɨgʉ, akamara sikʉ merongo ene ");
INSERT INTO ikz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ɨnʉ Shɨtaani akabha aramogema. Ribhaga riyo ataarɨ ariirɨ kegero chʉchʉsi, ɨnzara ɨkamurya bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Neho Shɨtaani akamʉbhʉʉrɨra, “Arɨɨbhɨ awɨ ni‑Mwana wa Mungu, rɨbhʉʉrɨrɨ riibhwɨ rɨnʉ rɨbhɨ ʉmʉkaatɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Akamʉgarukirya, “Yandikirwɨ, ‘Ʉmʉʉtʉ atakwikara kwa bhyakurya ibhyene.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Akʉmara, Shɨtaani akahira Yɨɨsu igʉrʉ bhʉkʉngʼu, akamwerecha ʉbhʉtɨmi bhwa zɨɨsɨ zʉʉsi kwa rogendo rʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Akamʉbhʉʉrɨra, “Nɨrakoha ʉbhʉnaja igʉrʉ wʉ ʉbhʉtɨmi bhwa zɨɨsɨ ziyo, bhʉmbɨ nu ubhuniibhi bhwa bhyʉsi bhɨnʉ, kʉ kʉbha niinyɨ nɨhɨɨrwɨ bhyʉsi, na nɨraha ʉmʉʉtʉ wʉwʉʉsi wʉnʉ nikwenda. ");
INSERT INTO ikz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nangʉ, ʉraansengere nɨrakoha bhyʉsi bhɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Akamʉgarukirya, “Yandikirwɨ, ‘Osengere Ʉmʉkʉrʉ Mungu waazʉ na omohokerye ewe umwene.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Akʉmara Shɨtaani akahira Yɨɨsu Yɨrusarɨɨmu, akamwimiirirya igʉrʉ wɨ ɨkɨkʉngʉ cha rihekaaru, akamʉbhʉʉrɨra, “Arɨɨbhɨ awɨ ni‑Mwana wa Mungu, irekera haasɨ, ");
INSERT INTO ikz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kʉ kʉbha yandikirwɨ, ‘Mungu araswaja bhamaraika bhaazɨ bhakuriibhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bharakugwatɨrɨra, korereke amagʉrʉ gaazʉ gataaza kwitema kwibhwɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Akamʉgarukirya, “Yandikirwɨ, ‘Ʉtagema Ʉmʉkʉrʉ Mungu waazʉ.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hanʉ Shɨtaani aamarirɨ komogema, akamutiga kwibhaga irebhe. ");
INSERT INTO ikz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Akʉmara, Yɨɨsu akagarʉka Gariraaya, izwirɨ amanaga ge Ekoro Ɨndɨndu. Na amangʼana igʉrʉ waazɨ gakanyaragana bhʉkʉngʼu mucharʉ kiyo chʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Akaja ariija abhaatʉ mʉmarwazɨrʉ gaabhʉ, bhʉʉsi bhakabha bharamukumya. ");
INSERT INTO ikz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Neho akagarʉka Nazarɨɨti, mʉrʉbhɨri rʉnʉ aarɨrirwɨ. Urusikʉ rwʉ ʉbhʉtʉʉrʉ, akasikɨra mwirwazɨrʉ, chɨmbu gaarɨ amanarʉ gaazɨ, akiimɨɨrɨra kosoma ɨngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akahaabhwa ɨkɨtabhʉ kɨnʉ chandikirwɨ nʉ ʉmʉrʉʉtɨrɨri Isaaya, akakihumbura, akabhona ahagero hanʉ haandikirwɨ, ");
INSERT INTO ikz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ekoro yʉ Ʉmʉkʉrʉ Mungu, ɨrɨ hamwɨ na niinyɨ. Amarirɨ kondobhora nɨbharwazɨrɨ abhahabhɨ Ɨngʼana Ɨnzʉmu. Antumirɨ kʉbhabhʉʉrɨra abhabhohwa, ʉkʉtazurwa kwabhʉ, na abhahʉku, bhararora naatu, na bhanʉ bhakʉnyaakibhwa, bharasabhurwa. ");
INSERT INTO ikz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na antumirɨ nɨbharwazɨrɨ abhaatʉ ribhaga ryɨ ɨbhɨgʉngi bhyʉ Ʉmʉkʉrʉ Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hanʉ aamarirɨ kosoma amangʼana gayo, Yɨɨsu akakundikirya ɨkɨtabhʉ, akagarukirya omohocha, akiikara atangɨ kwija. Abhaatʉ bhʉʉsi bhanʉ bhaarɨ mwirwazɨrʉ muyo, bhaarɨ bhamʉkandikijiryɨ amɨɨsʉ. ");
INSERT INTO ikz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akabhuga, “Amaandɨkʉ Amarɨndu ganʉ mwigwirɨ garasomwa, reero yɨnʉ gakʉrirwɨ mʉbhʉtangɨ bhwanyu.” ");
INSERT INTO ikz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Amangʼana gaazɨ amazʉmu, gakagirya abhaatʉ bhʉʉsi bhamukumyɨ, bhakarʉgʉʉra. Bhakatanga kwibhuurya, “Wʉnʉ atarɨ mwana wa Yuusufu?” ");
INSERT INTO ikz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yɨɨsu akabhabhʉʉrɨra, “Mʉtaana makɨbhwɨ mʉrambʉʉrɨra rɨnʉ, ‘Ʉmʉgabhʉ, wihorye aumwene. Gʉʉsi ganʉ twigwirɨ ʉragakora mʉrʉbhɨri rwa Kapɨrinaumu, ʉgakore nʉ ʉwɨɨtʉ hanʉ!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akangʼeha kubhuga, “Nɨrabhabhʉʉrɨra amaheene, atareeho ʉmʉrʉʉtɨrɨri wʉnʉ akwisiriribhwa mʉrʉbhɨri rwazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nawe amaheene nɨrabhabhʉʉrɨra, ribhaga rya Ɨɨriya, imbura ɨtaatwɨkirɨ myaka ɨtatʉ na myɨri ɨsaasabha, kuhika ɨnzara ɨkasikɨra mucharʉ chʉsi cha Iziraɨri. Na momenye, bhaareho abhakwirwa bhaaru mucharʉ ribhaga riyo. ");
INSERT INTO ikz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nʉʉrʉbhu, Ɨɨriya ataatumirwɨ naabha kwa wʉmwɨ waabhʉ, nawe, akatumwa kumukwirwa wʉmwɨ wʉ ʉrʉbhɨri rwa Sarɨɨputa, mucharʉ cha Sidʉʉni, igʉtʉ wa Iziraɨri! ");
INSERT INTO ikz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Ribhaga ryʉ ʉmʉrʉʉtɨrɨri Ɨrisha, bhaarɨ bhareho abhagenge bhaaru mucharʉ cha Iziraɨri. Nʉʉrʉbhu, ataarɨ areho nʉʉrʉ wʉmwɨ waabhʉ wʉnʉ aahʉriibhwɨ, kurushaku Naamani umwene, ʉmʉʉtʉ kurwa mucharʉ cha Siiriya!” ");
INSERT INTO ikz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Abhaatʉ bhʉʉsi bhanʉ bhiibhiringiirɨ mwirwazɨrʉ riyo, hanʉ bhiigwirɨ amangʼana ga Yɨɨsu, bhakiigatana bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bhakabhʉʉka, bhakamuhira kuhika kumuhiringitʉ ʉmʉhaari gwɨ ɨkɨgʉrʉ kɨnʉ ʉrʉbhɨri rwabhʉ rʉkʉʉmbakwa, korereke bhamusukumɨ. ");
INSERT INTO ikz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nawe, akahɨta gatɨgatɨ ya abhaatʉ bhayo, akaja izaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Akʉmara, Yɨɨsu akabhʉʉka akaja mʉrʉbhɨri rwa Kapɨrinaumu, mucharʉ cha Gariraaya. Urusikʉ rwʉ ʉbhʉtʉʉrʉ, akasikɨra mwirwazɨrʉ, akatanga kwija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Amiija gaazɨ, gakabharuguurya bhʉkʉngʼu, kʉ kʉbha gaarɨ nʉ ʉbhʉnaja. ");
INSERT INTO ikz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mwirwazɨrʉ muyo, kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ aarɨ na risambwa. Risambwa riyo, rɨkarɨra kwiraka, rɨrabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Awɨ Yɨɨsu wa Nazarɨɨti, ʉtatʉnyaacha! Nangʉ, wiizirɨ kuturicha? Nikwɨzɨ awɨ nɨ‑wɨɨwɨ, awɨ nɨ‑Mʉrɨndu wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yɨɨsu akarɨhaarɨra risambwa riyo akabhuga, “Kira! Nuurwɨ kʉmʉʉtʉ wʉnʉ!” Rogendo rʉmwɨ, risambwa riyo rɨkagwisha ʉmʉʉtʉ wuyo haasɨ, mʉbhʉtangɨ bhwa abhaatʉ bhayo bhʉʉsi, rɨkahʉrʉka bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abhaatʉ bhʉʉsi bhakarʉgʉʉra bhʉkʉngʼu, bhakiibhuurya, “Mangʼanakɨ ganʉ? Ndora ʉmʉʉtʉ wʉnʉ kʉbhʉnaja na amanaga, araheebha amasambwa, rogendo rʉmwɨ, garahʉrʉka!” ");
INSERT INTO ikz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Amangʼana igʉrʉ wa amahocha ga Yɨɨsu, gakanyaragana bhʉkʉngʼu mucharʉ chʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yɨɨsu akarwa mwirwazɨrʉ, akasikɨra munyumba ya Simʉʉni. Uninabhyara Simʉʉni, aarɨ ne ehooma haari, bhakasabha Yɨɨsu amohorye. ");
INSERT INTO ikz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Neho akiimɨɨrɨra haguhɨ nawe, akarecha ubhurwɨrɨ bhuyo, rogendo rʉmwɨ akahora. Neho ʉmʉkari wuyo akabhʉʉka, akatanga kʉbhatengera ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hanʉ iryʉbha ryarɨ rɨratʉbhɨra, abhaatʉ bhaaru bhakareetera Yɨɨsu abharwɨrɨ bhaabhʉ, bhanʉ bhaarɨ na amarwɨrɨ gʉgʉʉsi. Yɨɨsu akabhateera bhʉʉsi amabhoko gaazɨ, akabhahorya. ");
INSERT INTO ikz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hamwɨmwɨ na gayo, Yɨɨsu akaheebha amasambwa kʉbhaatʉ bhaaru ɨnʉ gararɨgɨsa, “Awɨ ni‑Mwana wa Mungu!” Kʉ kʉbha amasambwa gayo gakamenya Yɨɨsu newe Kiriisitʉ, akagarecha gatagamba naatu. ");
INSERT INTO ikz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tabhʉʉri waho, hanʉ bhwɨrirɨ, Yɨɨsu akarwa hayo, akaja ahagero hanʉ hataarɨ na abhaatʉ. Nawe, abhaatʉ bhaarɨ bharamomohya na hanʉ bhaamʉrʉʉzɨ, bhakagema komorecha, atabhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nawe, Yɨɨsu akabhabhʉʉrɨra, “Ɨranyenda nijɨ mumijɨ ɨgɨndɨ, nɨbharwazɨrɨ abhaatʉ Ɨngʼana Ɨnzʉmu yʉ ʉbhʉtɨmi bhwa Mungu, kʉ kʉbha nɨkatumwa igʉrʉ wa riyo.” ");
INSERT INTO ikz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Neho Yɨɨsu akatanʉra kʉhɨtɨra Yudeya, ararwazɨra abhaatʉ mʉmarwazɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rusikʉ rʉmwɨ, Yɨɨsu aarɨ imiiriirɨ rusizʉ wɨ ɨnyanza ya Genezarɨti, ɨnʉ ariija riribhita rya abhaatʉ ɨngʼana ya Mungu. Bhakabha bharamwisukɨra, korereke bhamwigwɨ, kuhika bhakamurimbya. ");
INSERT INTO ikz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na rusizʉ wɨ ɨnyanza hayo, Yɨɨsu akarora ubhwatʉ abhɨrɨ, abhawɨsɨni bhaarɨ bharuurɨ mubhwatʉ, bharooja zenzero zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Akatiira mubhwatʉ bhʉmwɨ, bhʉnʉ bhwarɨ bhwa Simʉʉni, akasabha Simʉʉni abhuhirɨ kore hasuuhu mʉnyanza. Yɨɨsu aarɨ achamariirya kʉbharagɨrɨra abhaatʉ, ɨnʉ iikɨɨrɨ mubhwatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hanʉ aamarirɨ kʉbharagɨrɨra, akabhʉʉrɨra Simʉʉni na abhakɨndichazɨ, “Mʉgʉhɨ ubhwatʉ, tujɨ gatɨ wɨ ɨnyanza, mwichɨ zenzero zaanyu, motege ziiswɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simʉʉni akagarukirya, “Ʉmʉkʉrʉ, tʉkʉrirɨ emeremo ubhutikʉ nyangima, tʉtabhwɨnɨ kegero! Nawe, kʉ kʉbha naawɨ umbuuriirɨ, niriicha zenzero.” ");
INSERT INTO ikz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mmbe, hanʉ Simʉʉni na abhakɨndichazɨ bhiichiryɨ zenzero zaabhʉ mʉmanzi, bhakahaatya ziiswɨ nzaru bhʉkʉngʼu, kuhika zenzero zaabhʉ zɨkatanga kʉbhaarʉka. ");
INSERT INTO ikz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɨkagirya bhanʉngɨ amabhoko kʉbhabhɨrɨkɨra abhakɨndichabhʉ, bhanʉ bhaarɨ mubhwatʉ ʉbhʉndɨ, bhaazɨ kʉbhasakirya. Bhakaaza, bhakiizurya ubhwatʉ bhʉbhɨrɨ ziiswɨ, kuhika bhokeenda kʉtʉbhɨra. ");
INSERT INTO ikz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simʉʉni Peetero, hanʉ aarʉʉzɨ gayo, akagwɨra Yɨɨsu mʉmagʉrʉ, akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ ʉtasaaga na niinyɨ, kʉ kʉbha, inyɨ nɨ‑wʉ ʉbhʉbhɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simʉʉni akagamba amangʼana gayo, kʉ kʉbha ewe na abhakɨndichazɨ, bhakarʉgʉʉra bhʉkʉngʼu kubhwaru bhwa ziiswɨ zɨnʉ bhahaatiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kwarɨ na abhaana bha Zebhedaayo, Yaakobho na Yoohana, bharatega hamwɨmwɨ na Simʉʉni, bhʉʉsi bhakarʉgʉʉra. Neho Yɨɨsu akabhʉʉrɨra Simʉʉni, “Ʉtʉʉbhaha! Kwɨma reero yɨnʉ, ʉrabha ʉrawesena abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Neho Simʉʉni na abhakɨndichazɨ bhakagarucha ubhwatʉ kukihuukʉ, bhakatiga ebhegero bhyabhʉ bhyʉsi, bhakatuna Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hanʉ Yɨɨsu aarɨ mʉrʉbhɨri rʉmwɨ, akaaza ʉmʉʉtʉ wʉmwɨ wʉnʉ aarɨ ne ebhegenge mʉbhɨrɨ gwʉsi. Hanʉ ʉmʉʉtʉ wuyo aarʉʉzɨ Yɨɨsu, akamugwɨra mʉmagʉrʉ, akiisasaama, “Ʉmʉkʉrʉ, ʉraasɨɨgɨ, ʉratʉra kʉmbɨngukya.” ");
INSERT INTO ikz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yɨɨsu akagorora okobhoko kwazɨ, akamukunʼyaku, akamʉbhʉʉrɨra, “Nɨsɨɨgirɨ. Bhɨngukibhwa!” Hayohayo, akahora ebhegenge bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yɨɨsu akamorecha, “Ʉtabhʉʉrɨra mʉʉtʉ wʉwʉʉsi! Nawe, nuujɨ wiiyeerekenʼye kwa kuhaani, uhuruchɨ ikimweso chʉ ʉkʉbhɨngukibhwa kwazʉ, chɨmbu Musa aaswajiryɨ, kwerecha abhaatʉ kʉbha ʉbhɨngukiibhwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nawe, ɨngʼana ya Yɨɨsu ɨkangʼeha komenyekana bhʉkʉngʼu kʉbhaatʉ. Bhaarɨ bharamujaku maribhita maaru, bhabhone kwitegeerera imigirʉ jazɨ, na kʉhʉribhwa amarwɨrɨ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nawe, Yɨɨsu aarɨ arabhatiga na kuja ahagero hanʉ hataana abhaatʉ kʉsabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rusikʉ rʉmwɨ, Yɨɨsu aarɨ ariija abhaatʉ, na gatɨ waabhʉ bhaarɨ bhiikɨɨrɨ Abhafarisaayo, hamwɨmwɨ na abhiija bhi imigirʉ. Bhaarɨ bharuurɨ mʉzɨmbɨri za Gariraaya, Yudeya, na abhandɨ Yɨrusarɨɨmu. Yɨɨsu aarɨ nʉ ʉbhʉnaja bhwʉ Ʉmʉkʉrʉ Mungu bhwo okohorya abharwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Neho bhakaaza abhaatʉ bhagɨgirɨ ʉmʉʉtʉ wʉnʉ aarɨ akuurɨ ibhiimʉ, ahindiirɨ kʉkɨragʉ. Bhakeenda kumusikirya munyumba, korereke bhamʉtʉʉrɨ mʉbhʉtangɨ bhwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nawe ɨtatʉrɨkɨɨnɨ, kʉ kʉbha ya riribhita ikʉrʉ. Neho bhakatiira kwitiirɨrʉ, bhakahika kwirengo ryi inyumba, bhagɨgirɨ ʉmʉʉtʉ wuyo. Hanʉ bhaarɨ igʉrʉ, bhakahobhora ɨkɨbhanga kɨkʉrʉ, bhakaruusha ʉbhʉnyaaki kʉkɨsara, bhakamwicha mʉbhʉtangɨ bhwa Yɨɨsu, gatɨ wa abhaatʉ bhayo bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hanʉ Yɨɨsu aarʉʉzɨ ubhwisirirya bhwabhʉ, akamʉbhʉʉrɨra, “Mʉsaani waanɨ, ihaana umwʉyʉ, ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abhiija bhi imigirʉ na Abhafarisaayo bhayo, rogendo rʉmwɨ bhakatanga kʉrɨrɨɨrɨra mumyʉyʉ, “Nɨ‑wɨɨwɨ wuyo? Ndora aragamba amangʼana go okorega Mungu? Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kobheerera ʉbhʉbhɨ, nawe Mungu umwene!” ");
INSERT INTO ikz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yɨɨsu akamenya ganʉ bhaarɨ bhakwiseega, akabhabhuurya, “Kwakɨ muriiseegabhu mumyʉyʉ janyu? ");
INSERT INTO ikz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Awɨ, ni‑ryahe rinyʉʉhu, kʉmʉbhʉʉrɨra, ‘Ʉbhʉbhɨ bhwazʉ bhʉbhɨɨrɨɨrwɨ,’ kisha kʉmʉbhʉʉrɨra, ‘Imɨɨrɨra, ogende’? ");
INSERT INTO ikz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Inyɨ nereenda momenye bhwaheene kʉbha, Umwana wʉ Ʉmʉʉtʉ ahɨɨrwɨ ʉbhʉnaja bhwo okobheerera ʉbhʉbhɨ kʉʉsɨ.” Akʉmara Yɨɨsu akabhʉʉrɨra ʉmʉʉtʉ wuyo, “Nɨrakʉbhʉʉrɨra, imɨɨrɨra! Gega ɨkɨragʉ chazʉ, ogende yɨɨka.” ");
INSERT INTO ikz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hayohayo, ʉmʉʉtʉ wuyo akiimɨɨrɨra mʉbhʉtangɨ bhwa abhaatʉ bhayo. Akiitwɨka ɨkɨragʉ chazɨ kɨnʉ aarɨ ahindiriirɨ, akaja munyumba, ɨnʉ aragʉnga Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Abhaatʉ bhʉʉsi bhayo, bhakarʉgʉʉra bhʉkʉngʼu na kugwatwa nu ubhwʉbha. Hamwɨmwɨ na gayo, bhaarɨ bharagʉnga Mungu, bharabhuga, “Bhamura! Reero, tʉrʉʉzɨ amahyoro!” ");
INSERT INTO ikz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hanʉ gayo gaasirirɨ, Yɨɨsu akarwa munyumba, akarora umurihya wa rigʉʉti wʉmwɨ, iriina ryazɨ Raawi, aarɨ ikɨɨrɨ mwibhuru ryu ukurihya rigʉʉti. Yɨɨsu akamʉbhʉʉrɨra, “Ntuna!” ");
INSERT INTO ikz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rogendo rʉmwɨ akiimɨɨrɨra, akatiga bhyʉsi, akamutuna. ");
INSERT INTO ikz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Akʉmara, Raawi akakorera Yɨɨsu ɨnyangi kʉrʉ munyumba yaazɨ. Munyumba muyo, bhakiibhiringa abharihya bha rigʉʉti bhaaru, na abhaatʉ abhandɨ bhanʉ bhaarɨ bhararya igari rɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ɨkagirya Abhafarisaayo, na abhiija bhaabhʉ bhi imigirʉ, bhakaja kwibheerya kʉbhɨɨga bha Yɨɨsu, bhakabhuga, “Ndora mʉrarya na kunywa hamwɨmwɨ na abharihya bha rigʉʉti na abhakʉri bhʉ ʉbhʉbhɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yɨɨsu akabhagarukirya, “Abhaatʉ abhahʉru bhatakwenda ʉmʉgabhʉ, nawe abharwɨrɨ nebho bhakumwenda! ");
INSERT INTO ikz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inyɨ nitiizirɨ kʉbhɨrɨkɨra bhe eheene, nawe bhʉ ʉbhʉbhɨ, bhiichʉrɨrɨ Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Abhafarisaayo na abhiija bhi migirʉ, bhakabhʉʉrɨra Yɨɨsu, “Abhɨɨga bha Yoohana Ʉmʉbhatiizi bhariiyima kurya manga kaaru na kʉsabha Mungu. Na abhɨɨga bha Abhafarisaayo, bhʉʉsi bhahaakorabhu. Nawe abhɨɨga bhaazʉ, bhatakwiyima, bhararya na kunywa!” ");
INSERT INTO ikz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yɨɨsu akabhagarukirya, “Abhahɨrɨɨkɨrɨri bhu umukwɨri bhaheenderwa kwiyima kurya, bharɨ hamwɨmwɨ nu umukwɨri? ");
INSERT INTO ikz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nawe urusikʉ rʉraaza umukwɨri araruusibhwa gatɨ wa abhagini bhaazɨ. Muzisikʉ ziyo, neho bhakʉbha bhariiyima kurya.” ");
INSERT INTO ikz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yɨɨsu akabhabhʉʉrɨra ekerenjo ɨkɨndɨ, “Ʉkʉsanja amiija gaanɨ amahya na zisimʉka zaanyu kʉratuubhana nʉ ʉkʉtʉʉra ɨkɨraka che engebho iihya kongebho ikungu. Nʉ ʉmʉʉtʉ araakorebhu, arabha atarandwirɨ engebho yaazɨ bhʉʉha. Nɨ ɨkɨraka kirya che engebho iihya kɨtakwisiriranʼya ne engebho ikungu. ");
INSERT INTO ikz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Na atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kʉtʉʉra idivaayi iihya mʉbhɨgʉzi bhya amaseero amakungu. Na araakorebhu, idivaayi iihya ɨraatya ɨbhɨgʉzi bhiyo, iriitɨka, nɨ ɨbhɨgʉzi bhiyo bhɨrasarɨka. ");
INSERT INTO ikz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nawe idivaayi iihya, ereenderwa ʉtʉʉrɨ mʉbhɨgʉzi bhya riseero riihya! ");
INSERT INTO ikz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Nʉ ʉmʉʉtʉ wʉnʉ anarirɨ idivaayi yɨ ɨkarɨ, atahiigomba idivaayi iihya. Arabhuga, ‘Idivaayi yɨ ɨkarɨ neyo ɨnzʉmu.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Rusikʉ rʉmwɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu na abhɨɨga bhaazɨ, bhaarɨ bharahɨta mʉmɨgʉndʉ jɨ ɨnganʉ. Abhɨɨga bhaazɨ, bhakabha bharatɨna ɨbhɨgara bhyɨ ɨnganʉ, bhakaruushaku zeeheke, bhakarya. ");
INSERT INTO ikz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Neho Abhafarisaayo abhandɨ bhakabhabhuurya, “Ndora mʉrakora emeremo gɨnʉ gɨtakwenderwa kokorwa urusikʉ rwʉ ʉbhʉtʉʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yɨɨsu akabhagarukirya, “Mʉtasʉmirɨ mʉMaandɨkʉ Amarɨndu chɨmbu Daudi na abhakɨndichazɨ bhaakʉrirɨ, hanʉ bhaarɨ nɨ ɨnzara? ");
INSERT INTO ikz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akasikɨra mwibhuru rirɨndu rya Mungu, akagega ɨmɨkaatɨ gɨnʉ jatɨɨrwɨ mʉbhʉtangɨ bhwa Mungu akarya akabhaha na abhakɨndichazɨ bhʉʉsi bhakarya. Nawe ɨmɨkaatɨ gɨnʉ kumigirʉ ja Musa gɨtakwenderwa kuriibhwa na abhaatʉ, kuruushaku bhakuhaani abheene.” ");
INSERT INTO ikz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Akoongera kubhuga, “Umwana wʉ Ʉmʉʉtʉ, newe Ʉmʉkʉrʉ wu urusikʉ rwʉ ʉbhʉtʉʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Urusikʉ ʉrʉndɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu akasikɨra mwirwazɨrʉ, akiija abhaatʉ. Muyo, aarɨmu ʉmʉʉtʉ wʉmwɨ, wʉnʉ aarɨ akuurɨ okobhoko ku ubhuryʉ. ");
INSERT INTO ikz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abhiija bhi imigirʉ na Abhafarisaayo, bhakabha bhararɨnda bharore arɨɨbhɨ arahorya ʉmʉʉtʉ wuyo, urusikʉ rwʉ ʉbhʉtʉʉrʉ, kʉ kʉbha bhaarɨ bharamohya ɨnzɨra yu ukumwinatiriryaku. ");
INSERT INTO ikz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nawe, Yɨɨsu akamenya eseemyo yaabhʉ, akabhʉʉrɨra omorema wo okobhoko, “Nauzɨ, wiimɨɨrɨrɨ gatɨgatɨ.” Ʉmʉʉtʉ wuyo akaaza, akiimɨɨrɨra. ");
INSERT INTO ikz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Akʉmara Yɨɨsu akabhʉʉrɨra Abhafarisaayo na abhiija bhi imigirʉ bhayo, “Mmbe, nɨbhabhuuryɨ! Urusikʉ rwʉ ʉbhʉtʉʉrʉ, nɨ‑bhwaheene kokora Amazʉmu, kisha amabhɨ? Urusikʉ ruyo tohorye, kisha twitɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yɨɨsu akarora abhaatʉ bhayo bhʉʉsi, akʉmara akabhʉʉrɨra ʉmʉʉtʉ wuyo, “Gorora okobhoko kwazʉ.” Akakogorora, rogendo rʉmwɨ kʉkahora! ");
INSERT INTO ikz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Abhaatʉ bhayo, bhakiigatana bhʉkʉngʼu, bhakatanga kwibhisirya chɨmbu bharaakorere Yɨɨsu amabhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Rusikʉ rʉmwɨ, Yɨɨsu akaja kʉkɨgʉrʉ kʉsabha, akatengeeza arasabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tabhʉʉri waho, akabhabhɨrɨkɨra abhɨɨga bhaazɨ, gatɨ waabhʉ akarobhora ikumi na bhabhɨrɨ, akabhaha iriina rya abhatumwa. Na abhatumwa bhayo, nebho bhanʉ: ");
INSERT INTO ikz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simʉʉni, wʉnʉ Yɨɨsu aahɨɨrɨ iriina rya Peetero, Andureya umwabhʉ Simʉʉni, Yaakobho, Yoohana, Firipʉ, Bhatoromayo, ");
INSERT INTO ikz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataayo, Tomaaso, Yaakobho umwana wa Arifaayʉ, Simʉʉni wʉnʉ akubhirikirwa Ʉmʉzɨrʉʉti, ");
INSERT INTO ikz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda umwana wa Yaakobho, na Yuuda Isikariyʉʉti, wʉnʉ iichurirɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yɨɨsu akiika kʉkɨgʉrʉ, hamwɨmwɨ nabhʉ, akiimɨɨrɨra mʉtandaari. Hayo, bhakiibhiringa abhɨɨga bhaazɨ na riribhita rya abhaatʉ abhandɨ bhanʉ bharuurɨ mucharʉ chʉsi cha Yudeya, mʉrʉbhɨri rwa Yɨrusarɨɨmu, na kukihuukʉ cha Tiiro na Sidʉʉni. Abhaatʉ bhayo, bhakaaza kwitegeerera Yɨɨsu na kʉhʉribhwa amarwɨrɨ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na bhanʉ bhaarɨ bhakʉnyaakibhwa na amasambwa, bhakahʉribhwa. ");
INSERT INTO ikz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Abhaatʉ bhʉʉsi, Bhakeenda kukunʼyaku Yɨɨsu, kʉ kʉbha zinguru zaarɨ zɨramʉhʉrʉka na zɨrabhahorya bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yɨɨsu akabharora abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Hakɨrɨku imwɨ abhahabhɨ, kʉ kʉbha ʉbhʉtɨmi bhwa Mungu ubhwanyu. ");
INSERT INTO ikz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hakɨrɨku bhanʉ mukwigwa ɨnzara nangwɨnʉ, kʉ kʉbha mʉraaza kwigutibhwa. Hakɨrɨku bhanʉ mʉkʉrɨra nangwɨnʉ, kʉ kʉbha mʉraaza koseka. ");
INSERT INTO ikz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hakɨrɨku imwɨ hanʉ abhaatʉ bhakʉbhabhiihirirwa, bhakʉbhaahʉra, bhakʉbhatʉka na kʉbhagambɨra imwɨ amabhɨ igʉrʉ wu Umwana wʉ Ʉmʉʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Gayo garaabhabhone, mozomerwe na kubhina bhʉkʉngʼu, kʉ kʉbha ʉmʉbhanʉ gwanyu nɨ‑mʉkʉrʉ mwisaarʉ. Nɨmbu bhawɨsɨɨkʉrʉ, bhaarɨ bhakʉnyaacha abharʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nawe horeera imwɨ abhaniibhi, kʉ kʉbha obhozomerwa bhwanyu, mʉmarirɨ kobhobhona. ");
INSERT INTO ikz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Horeera imwɨ bhanʉ mukwigʉta nangwɨnʉ, kʉ kʉbha mʉraaza kwigwa ɨnzara. Horeera imwɨ bhanʉ mokoseka kwa bhozomerwa nangwɨnʉ, kʉ kʉbha mʉrarɨra na kwarama bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Horeera imwɨ, hanʉ abhaatʉ bhʉʉsi bhakʉbhakumya, kʉ kʉbha, bhawɨsɨɨkʉrʉ nɨmbu bhaarɨ bhakʉbhakorera abharʉʉtɨrɨri bhʉ ʉrʉrɨmɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nawe nɨrabhabhʉʉrɨra imwɨ bhanʉ mukunyiitegeerera, mʉbhasɨɨgɨ abhabhisa bhaanyu, na bhanʉ bhakʉbhabhiihirirwa, mʉbhakorere amazʉmu. ");
INSERT INTO ikz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉbhahɨ ʉrʉbhangʉ, bhanʉ bhakubhiihiima, na kʉbhasabhɨra amazʉmu kwa Mungu bhanʉ bhakʉbhakorera amabhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Ʉmʉʉtʉ araakʉbhaatʉrɨ ʉrʉsa rwu ubhuryʉ, muchʉrɨrɨ nʉ ʉrʉndɨ. Na wʉnʉ araakuruushɨ ɨkabhuuti yaazʉ, umutigɨrɨ nɨ ɨshadi. ");
INSERT INTO ikz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wʉwʉʉsi wʉnʉ araakʉsabhɨ ekegero, mohe, nʉ ʉmʉʉtʉ araakogegere bhegero bhyazʉ, ʉtamʉsabha akʉgarukiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mokorere abhandɨ ganʉ mukwenda mokorerwe. ");
INSERT INTO ikz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nangʉ, mʉraabhasɨɨgɨ bhanʉ bhabhasɨɨgirɨ abheene, mʉrabhona bhwerakɨ? Naabha bhʉ ʉbhʉbhɨ, bhabhasɨɨgirɨ abhaatʉ bhanʉ bhabhasɨɨgirɨ! ");
INSERT INTO ikz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naatu, mʉraasakiryɨ bhanʉ bhakʉbhasakirya abheene, mʉrabhona bhwerakɨ? Naabha bhʉ ʉbhʉbhɨ bhahaakora ɨbhuɨbhu! ");
INSERT INTO ikz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na mʉraabhakopeshe bhanʉ mukwisega kʉbha bharabhagarukirya, mʉrabhona bhwerakɨ? Naabha bhʉ ʉbhʉbhɨ, bhahaabhakopesha abhakɨndichabhʉ, korereke bhaazɨ bhabhagarukiryɨ bhyʉsi! ");
INSERT INTO ikz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Nawe imwɨ, mʉbhasɨɨgɨ abhabhisa bhaanyu, mʉbhakorere amazʉmu. Mʉbhakopeshe ɨtabha kwa kwisega bharabhagarukirya, neho mʉraabhone ʉmʉbhanʉ ʉmʉkʉrʉ. Hayo neho mʉraabhɨ abhaana bha Mungu wi Igʉrʉ wa Bhyʉsi, kʉ kʉbha, ewe ahaabhasakirya bhanʉ bhatakubhuga, ‘Ʉzʉmiryɨ,’ na abhakʉri bha amabhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mʉbhɨ bhɨ ɨbhɨgʉngi kʉbhaatʉ, chɨmbu Wuusʉ akʉbharorera rigʉngi. ");
INSERT INTO ikz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mʉtatɨnɨra abhandɨ, na niimwɨ mʉtaaza kutinirwa na Mungu. Mʉtatema amasoro, na niimwɨ mʉtakotemwa amasoro. Mʉbhabheerere bhanʉ bhakʉbhasariirya, na niimwɨ mʉrabheererwa. ");
INSERT INTO ikz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mʉbhahɨ abhaatʉ ebhegero na niimwɨ mʉrahaabhwa na Mungu. Mʉrahaabhwa ekerengo kɨnʉ chizwirɨ zabhi, kichimirwɨ na kusingiswa kiriitɨkɨra. Ekerengo kɨnʉ mokorengera abhandɨ necho na niimwɨ mʉraarengerwe na Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Akabhabhʉʉrɨra kobherenjo, “Heene, ʉmʉhʉku aratʉra kʉkangata ʉmʉhʉku ʉmʉkɨndichazɨ? Bhʉʉsi bhabhɨrɨ bharagwa mwirʉʉma! ");
INSERT INTO ikz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umwɨga atakʉkɨra umwija waazɨ. Nawe, araamarɨ kʉragirirwa na kwɨrɨkibhwa gʉʉsi, ahaabha nchu umwija waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndora ʉrarora ekebhereera kɨnʉ kiri muriisʉ ryʉ ʉmʉkɨndichazʉ, nawe ʉtakorora ɨkɨtɨnɨka kɨnʉ kiri muriisʉ ryazʉ? ");
INSERT INTO ikz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kisha ʉratʉrabhwɨ kʉbhʉʉrɨra ʉmʉkɨndichazʉ, ‘Tiga nikuruushɨ ekebhereera muriisʉ ryazʉ,’ nawe ʉtakorora ɨkɨtɨnɨka muriisʉ ryazʉ? Ʉmʉbhɨɨhi awɨ! Ruusha hinga ɨkɨtɨnɨka muriisʉ ryazʉ. Neho ʉkʉtʉra korora bhwaheene na kuruusha ekebhereera muriisʉ ryʉ ʉmʉkɨndichazʉ. ");
INSERT INTO ikz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gʉtareeho ʉmʉtɨ ʉmʉzʉmu gʉnʉ gwahiibhʉra imisumʉ ɨmɨbhɨ, nʉ ʉmʉtɨ ʉmʉbhɨ, gʉnʉ gukwibhʉra imisumʉ ɨmɨzʉmu. ");
INSERT INTO ikz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abhaatʉ bhatakutwa imisumʉ ju umutiini kʉmɨtɨ ja amahwa, na bhatakutwa imisumʉ jɨ ɨmɨzabhiibhu kʉmɨtɨ je emesonkoma. Nawe kʉmɨtɨ jʉsi, gɨramenyekana kumisumʉ jaku. ");
INSERT INTO ikz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɨbhuɨbhu ʉmʉʉtʉ ʉmʉzʉmu, ahaamenyekana kʉmangʼana amazʉmu, ganʉ gari mumwʉyʉ gwazɨ. Nawe ʉmʉʉtʉ ʉmʉbhɨ muyomuyo, ahaagamba amangʼana amabhɨ, ganʉ gari mumwʉyʉ gwazɨ. Amangʼana ganʉ ʉmʉʉtʉ akʉgamba, gararwa mʉganʉ gizwirɨ mumwʉyʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kwakɨ mʉrambɨrɨkɨra, ‘Ʉmʉkʉrʉ, Ʉmʉkʉrʉ,’ nawe mʉtakokora amangʼana gaanɨ? ");
INSERT INTO ikz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nɨrabhabhʉʉrɨra ekerenjo chʉ ʉmʉʉtʉ wʉnʉ akwigwa amangʼana gaanɨ na kʉgakora. ");
INSERT INTO ikz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wuyo, atuubhɨɨnɨ nu umwʉmbaki wi inyumba, wʉnʉ aatukirɨ rirʉʉma akahooza ritarɨ, akʉʉmbaka ʉbhʉrʉsa. Mumbura, ɨkɨtaarʉ kikiizʉra, amanzi gakatema inyumba yiyo, nawe gatayisingishiryɨ, kʉ kʉbha yaarɨ yʉmbakirwɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nawe, wʉwʉʉsi wʉnʉ akwigwa amangʼana gaanɨ na atakʉgakora, wuyo, atuubhɨɨnɨ nʉ ʉmʉʉtʉ wʉnʉ ʉmbakirɨ inyumba yaazɨ komosekeenya, na atatɨɨrɨ amabhwɨ iyaasɨ hinga. Ribhaga ryi imbura amanzi gakahera, gakatema inyumba yiyo. Rogendo rʉmwɨ ɨkagwa haasɨ, ɨkarika yʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hanʉ Yɨɨsu aamarirɨ kʉbhʉʉrɨra abhaatʉ amangʼana gayo gʉʉsi, akasikɨra mʉrʉbhɨri rwa Kapɨrinaumu. ");
INSERT INTO ikz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mʉrʉbhɨri ruyo, aareho ʉmʉkʉrʉ wa abhasirikarɨ bhi Ikiruumi. Ʉmʉkʉrʉ wuyo, aarɨ na mbʉʉsa wʉnʉ aarɨ amʉsɨɨgirɨ bhʉkʉngʼu. Nawe mbʉʉsa wuyo aarɨ murwɨrɨ, haguhɨ kutinʼya. ");
INSERT INTO ikz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nangʉ, ʉmʉkʉrʉ wuyo, aaza kwigwa ɨngʼana igʉrʉ wa Yɨɨsu, akatʉma abhakaruka abhandɨ bha Abhayaahudi kwa Yɨɨsu, bhamʉsabhɨ aazɨ komohorya mbʉʉsa waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abhakaruka bhayo, bhaaza kuhika kwa Yɨɨsu, bhakamwisasaama bhʉkʉngʼu, bharabhuga, “Ʉmʉʉtʉ wuyo, areenderwa omokorere ringʼana yɨnʉ, ");
INSERT INTO ikz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kʉ kʉbha asɨɨgirɨ icharʉ chɨtʉ, na newe atwʉmbakiirɨ rirwazɨrʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Neho Yɨɨsu akarweho hamwɨmwɨ na abhakaruka bhayo, kuja yɨɨka wʉ ʉmʉkʉrʉ wuyo. Na hanʉ bhaahiisɨmɨɨrɨ, ʉmʉkʉrʉ wuyo akatʉma abhasaani bhaazɨ. Bhakahira amangʼana gaazɨ kwa Yɨɨsu, bhakamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, utiinyaacha bhʉkʉngʼu, kʉ kʉbha ɨtakwenderwa usikɨrɨ ɨwaanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Necho naarɨ niriirora nɨtakwenderwa kuuza kwa naawɨ. Nawe, gamba ingʼana rɨmwɨbhu, omohocha waanɨ arahora. ");
INSERT INTO ikz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Nɨrabhugabhu kʉ kʉbha, inyʉʉsi niri iyaasɨ wʉ ʉbhʉnaja bhwa abhandɨ, na nɨna abhasirikarɨ bhanʉ bhari iyaasɨ waanɨ. Nɨraabhʉʉrɨrɨ wʉmwɨ, ‘Nuujɨ,’ ahaaja. Nɨraabhʉʉrɨrɨ ʉwʉndɨ, ‘Nauzɨ,’ ahaaza. Na nɨraabhʉʉrɨrɨ mbʉʉsa waanɨ, ‘Kora omoremo gʉnʉ,’ ahaakora.” ");
INSERT INTO ikz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hanʉ Yɨɨsu iigwirɨ gayo, akarʉgʉʉra bhʉkʉngʼu. Akiichʉrɨra riribhita rya abhaatʉ, bhanʉ bhaarɨ bharamutuna, akabhuga, “Nɨrabhabhʉʉrɨra, nʉʉrʉ gatɨ wa Abhiiziraɨri bhʉʉsi, nɨkɨɨrɨ korora ʉmʉʉtʉ wʉwʉʉsi wu ubhwisirirya ʉbhʉkʉrʉ ncha bhʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na abhaatʉ bhanʉ bhaatumirwɨ bhakagarʉka munyumba yʉ ʉmʉkʉrʉ wuyo, bhakabhona mbʉʉsa amarirɨ kohora. ");
INSERT INTO ikz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Akʉmara, Yɨɨsu akaja mʉrʉbhɨri rwa Naini, na abhɨɨga bhaazɨ na abhaatʉ abhandɨ bhaaru, bhakamutuna. ");
INSERT INTO ikz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na hanʉ iisɨmɨɨrɨ ikishoko chʉ ʉrʉbhɨri, akarumana na abhaatʉ, bhanʉ bhaarɨ bhagɨgirɨ ɨkɨtʉndʉ chu umumura, bharahʉrʉka igʉtʉ wʉ ʉrʉbhɨri. Umumura wuyo, aarɨ umwana umumwɨmwɨ, na unina aarɨ umukwirwa. Unina wuyo, akahirana na abhaatʉ bhaaru bhʉ ʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hanʉ Ʉmʉkʉrʉ aarʉʉzɨ umukwirwa wuyo, akamororera ɨbhɨgʉngi, akamʉbhʉʉrɨra, “Ʉtarɨra.” ");
INSERT INTO ikz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Akiisuka kʉkɨragʉ kɨnʉ ɨkɨtʉndʉ charɨ, akakikunʼya. Na abhaatʉ bhanʉ bhaakɨgɨgirɨ, bhakiimɨɨrɨra. Yɨɨsu akabhuga, “Mura, nɨrakʉbhʉʉrɨra, bhʉʉka!” ");
INSERT INTO ikz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Umumura wʉnʉ aarɨ akuurɨ, rogendo rʉmwɨ akabhʉʉka, akiikara, akatanga kʉgamba. Neho Yɨɨsu akamugwatya unina. ");
INSERT INTO ikz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abhaatʉ bhayo bhʉʉsi, bhakagwatwa nu ubhwʉbha, bhakatanga kukumya Mungu, bharabhuga, “Ʉmʉrʉʉtɨrɨri ʉmʉkʉrʉ, ahurukiirɨ gatɨ wɨɨtʉ!” Na, “Mungu, iizirɨ kʉsakirya abhaatʉ bhaazɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Amangʼana gayo, gakanyaragana bhʉkʉngʼu Yudeya yʉʉsi, na mucharʉ ɨkɨndɨ cha mʉrʉbhɨri. ");
INSERT INTO ikz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hanʉ Yɨɨsu aarɨ arakora gʉʉsi gayo, Yoohana akareeterwa ɨngʼana ya Yɨɨsu na abhɨɨga bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yoohana akabhabhɨrɨkɨra abhɨɨga bhabhɨrɨ, akabhatʉma bhajɨ kubhuurya Ʉmʉkʉrʉ, “Awɨ naawɨ Kiriisitʉ wʉnʉ akuuza, kisha tʉrɨndɨ ʉwʉndɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bhaaza kuhika bhakamʉbhʉʉrɨra, “Yoohana Ʉmʉbhatiizi atutumirɨ kwa nawe, tukubhuuryɨ, ‘Awɨ naawɨ Kiriisitʉ wʉnʉ akuuza, kisha tʉrɨndɨ ʉwʉndɨ?’ ” ");
INSERT INTO ikz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kwibhaga riyoriyo, Yɨɨsu aarɨ arahorya abhaatʉ bhaaru amarwɨrɨ gaabhʉ. Aarɨ arasakirya bhanʉ bhakʉnyaakibhwa na amasambwa na abhahʉku bhaaru bhatʉrɨ korora. ");
INSERT INTO ikz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Neho Yɨɨsu akabhagarukirya, “Mujɨ mʉbhʉʉrɨrɨ Yoohana gʉʉsi ganʉ mʉrʉʉzɨ, na gʉʉsi ganʉ mwigwirɨ. Abhahʉku bhararora, abharema bharagenda, abhagenge bharahora, abharibhi bha amatwɨ bhariigwa, abhaku bhararyʉka, na abhahabhɨ bhararwazirwa Ɨngʼana Ɨnzʉmu. ");
INSERT INTO ikz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hakɨrɨku ʉmʉʉtʉ wʉnʉ ataana makɨbhwɨ igʉrʉ waanɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hanʉ bhabhɨrɨ bhayo bhaagiirɨ, Yɨɨsu akatanga kʉgamba na riribhita rya abhaatʉ igʉrʉ wa Yoohana, “Mʉkaja mwitɨrɨgʉ kororakɨ? Korora ʉmʉʉtʉ wʉnʉ akwisirirya amangʼana gʉʉsi ncha rikʉrɨ rɨnʉ rɨhaasingishwa nʉ ʉmʉkama? ");
INSERT INTO ikz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mʉkaja kororakɨ? Mʉkaja korora ʉmʉʉtʉ wʉnʉ iibhʉhirɨ zengebho zɨnzʉmu za riguri? Zɨyi! Abhaatʉ bhanʉ bhahiibhoha amiibhoho amazʉmu bhʉkʉngʼu nu ukwizomya igʉrʉ wu ubhuniibhi bhwe ebhegero bhɨnʉ bhaanabhyʉ, bhahiikara muzinyumba za abhatɨmi! ");
INSERT INTO ikz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nawe mʉkaja kororakɨ? Ʉmʉrʉʉtɨrɨri? Hee, nɨrabhabhʉʉrɨra, Yoohana nɨ‑mʉkʉrʉ kʉkɨra ʉmʉrʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wuyo newe wʉnʉ Amaandɨkʉ Amarɨndu gaagambirɨ igʉrʉ waazɨ, ‘Rora, nɨratʉma umutumwa waanɨ mʉbhʉtangɨ bhwazʉ, wʉnʉ araakokonzere ɨnzɨra.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yɨɨsu akabhuga naatu, “Nɨrabhabhʉʉrɨra, mʉbhaatʉ bhʉʉsi bhanʉ bhiibhwirɨ kʉʉsɨ, atareeho ʉmʉkʉrʉ kʉkɨra Yoohana. Nawe, ʉmʉʉtʉ umusuuhu kʉkɨra bhʉʉsi mʉbhʉtɨmi bhwa Mungu, newe ʉmʉkʉrʉ kʉkɨra Yoohana.” ");
INSERT INTO ikz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Abhaatʉ bhʉʉsi, hamwɨmwɨ na abharihya bha rigʉʉti, hanʉ bhiigwirɨ amangʼana ga Yɨɨsu gayo, bhakiisirirya kʉbha ɨsɨɨmi ya Mungu yaarɨ nzʉmu, kʉ kʉbha abhaatʉ bhayo nebho bharya Yoohana amarirɨ kʉbhatiiza. ");
INSERT INTO ikz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nawe, Abhafarisaayo na abhiija bhi imigirʉ bhataabhatiizirwɨ na Yoohana, kʉ kʉbha bhakaanga amiisɨɨgi ga Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yɨɨsu akabhuga naatu, “Abhaatʉ bhu urwibhʉrʉ rʉnʉ, nɨbhatuubhanʼyɨ nakɨ? Nɨ‑bha teemwakɨ? ");
INSERT INTO ikz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhatuubhɨɨnɨ na abhaana bhanʉ bhiikɨɨrɨ momoteera, bhakwibhɨrɨkɨra abheene kobheene bharabhuga, ‘Tʉkabhatemera ekereere, nawe mʉtaabhinirɨ! Tʉkɨɨmba amɨɨmbʉ gu ukwarama, nawe mʉtaaririrɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Nɨmbu na niimwɨ mʉrɨ, kʉ kʉbha hanʉ Yoohana Ʉmʉbhatiizi iizirɨ, ataarɨ ararya mɨkaatɨ na kunywa idivaayi, na niimwɨ mʉkabhuga ‘Wʉnʉ ana amasambwa!’ ");
INSERT INTO ikz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Umwana wʉ Ʉmʉʉtʉ akaaza, ararya ibhyakurya bhya amanarʉ na kunywa idivaayi, bhakabhuga, ‘Rora! Nɨ‑mʉsʉʉhʉ munywi, mʉsaani wa abharihya bha rigʉʉti, na bhʉ ʉbhʉbhɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nawe nʉʉrʉbhu ubhwʉbhʉʉri bhwa Mungu bhʉhaamenyeekererya kʉbha nɨ‑maheene kʉbhaatʉ bhaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aarɨ areho Ʉmʉfarisaayo wʉmwɨ mʉrʉbhɨri ororebhe. Rusikʉ rʉmwɨ akaraarɨka Yɨɨsu kurya ɨwaazɨ. Neho Yɨɨsu akasikɨra munyumba yʉ Ʉmʉfarisaayo wuyo, akiikara kwigari. ");
INSERT INTO ikz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na mʉrʉbhɨri ruyo, kwarɨ nʉ ʉmʉkari wʉmwɨ, wʉnʉ aamɨnyɨkɨɨnɨ wʉ ʉbhʉbhɨ. Hanʉ ʉmʉkari wuyo, iigwirɨ kʉbha Yɨɨsu ararya wʉ Ʉmʉfarisaayo, akasikɨra muyo ani ichupa ɨnzʉmu ya amaguta ganʉ gakoreetya bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akahigama haguhɨ na amagʉrʉ ga Yɨɨsu, akatanga kʉrɨra. Zingusuri zaazɨ zɨragerera kʉmagʉrʉ ga Yɨɨsu, aarɨ arazihuta na zinzwɨrɨ zaazɨ, akahumbata amagʉrʉ ga Yɨɨsu, na kʉgahaka amaguta gayo. ");
INSERT INTO ikz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hanʉ Ʉmʉfarisaayo aarʉʉzɨ gayo, akiiseega mumwʉyʉ gwazɨ, “Ʉmʉʉtʉ wʉnʉ, angabhɨɨrɨ ʉmʉrʉʉtɨrɨri, aarɨ aramenya, ʉmʉkari wʉnʉ akumukunʼyaku, nɨ‑mʉʉtʉ wa teemwakɨ. Aarɨ aramenya, ewe ariikara ubhwikari bhʉ ʉbhʉbhɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yɨɨsu akamʉbhʉʉrɨra, “Simʉʉni, nɨnɨ ɨngʼana yʉ ʉkʉkʉbhʉʉrɨra.” Newe akamʉgarukirya, “Umwija, mbʉʉrɨra.” Neho Yɨɨsu akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Haareho na abhaatʉ bhabhɨrɨ, bhani isiirɨ yʉ ʉmʉʉtʉ wʉmwɨ. Ʉwʉmwɨ, aarɨ ani isiirɨ ya zidinaari magana ataanʉ. Ʉmʉkɨndichazɨ, aarɨ ani isiirɨ ya zidinaari merongo ɨtaanʉ. ");
INSERT INTO ikz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhʉʉsi bhakabhurwa zimpirya zʉ ʉkʉrɨha zisiirɨ zaabhʉ, wʉnʉ abhahɨɨrɨ isiirɨ akabhabheerera, bhatarɨha. Nangʉ, gatɨ wa bhabhɨrɨ bhayo, nɨ‑wahɨ wʉnʉ akʉmʉsɨɨga bhʉkʉngʼu?” ");
INSERT INTO ikz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simʉʉni akamʉgarukirya, “Nɨrakina nɨ‑wʉnʉ aabhɨɨrɨɨrwɨ isiirɨ ɨkʉrʉ.” Yɨɨsu akamʉbhʉʉrɨra, “Ʉgarukiiryɨ bhwaheene.” ");
INSERT INTO ikz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hayo, Yɨɨsu akiichʉrɨra ʉmʉkari wuyo, akabhʉʉrɨra Simʉʉni, “Ʉrarora ʉmʉkari wʉnʉ? Nisikiirɨ munyumba yaazʉ, nawe ʉtansʉngʼaanirɨ kwa kongʼa amanzi gu ukwoja amagʉrʉ gaanɨ. Nawe ewe, azaziryɨ amagʉrʉ gaanɨ na zingusuri zaazɨ, na kʉgataricha na zinzwɨrɨ zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Awɨ ʉtankɨɨriryɨ kwa kunhumbata, nawe, kwɨma ribhaga nasikiirɨ mʉnʉ, akɨɨrɨ kuniha kunhumbata amagʉrʉ gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ʉtansuukirɨ kwa kʉhaka amaguta mumutwɨ gwanɨ. Nawe ewe, ahakirɨ amagʉrʉ gaanɨ amaguta go okoreetya! ");
INSERT INTO ikz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kʉgayo nɨrakʉbhʉʉrɨra, kʉ kʉbha ʉbhʉbhɨ bhwazɨ bhwaru bhʉmarirɨ kobheererwa, akeerecha ʉbhʉsɨɨgi bhwaru. Nɨmbu wʉwʉʉsi wʉnʉ abhɨɨrɨɨrwɨ ʉbhʉbhɨ hasuuhu, areerekenʼya ʉbhʉsɨɨgi bhusuuhu.” ");
INSERT INTO ikz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yɨɨsu akabhʉʉrɨra ʉmʉkari wuyo, “Ʉbhʉbhɨ bhwazʉ, bhʉbhɨɨrɨɨrwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bhaareho abhagini abhandɨ kwigari, bhakatanga kwibhuurya, “Nɨ‑wɨɨwɨ wʉnʉ, akʉtʉra kobheerera ʉbhʉbhɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yɨɨsu akabhʉʉrɨra ʉmʉkari wuyo, “Ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ! Ujɨ no omorembe.” ");
INSERT INTO ikz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akʉmara, Yɨɨsu akahɨta mumijɨ na mʉzɨmbɨri, ararwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu yʉ ʉbhʉtɨmi bhwa Mungu. Abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, ");
INSERT INTO ikz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bhʉmbɨ na abhakari bhanʉ abhahʉriryɨ amarwɨrɨ, na kʉbharuusha amasambwa, bhakahirana nawe. Gatɨ wa abhakari bhayo aareho Mariyamu wa Magidarena, wʉnʉ Yɨɨsu amuruushiryɨ amasambwa muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na aareho Yowana, ʉmʉkari wa Kuza. Kuza wuyo, newe imiiririirɨ ebhegero bhyʉ ʉmʉtɨmi Heroode. Na bhaareho abhakari abhandɨ bhaaru na Suzaana. Bhʉʉsi bhayo, bhaarɨ bharahurucha ebhegero bhyabhʉ, kʉbhasakirya Yɨɨsu na abhɨɨga bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Rusikʉ rʉmwɨ, riribhita rya abhaatʉ bha mumijɨ myaru, rikiibhiringa, abhaatʉ bhayo bhaarɨ bhiiziirɨ Yɨɨsu. Neho Yɨɨsu akabhabhʉʉrɨra ekerenjo kɨnʉ: ");
INSERT INTO ikz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kwarɨ nu umubhusuri wʉmwɨ. Rusikʉ rʉmwɨ akaja kubhusura zimbusurʉ zaazɨ mʉmʉgʉndʉ. Hanʉ aarɨ akubhusura zimbusurʉ ziyo, ɨzɨndɨ zɨkagwa kʉnzɨra, zɨkatazwatazwa, ni ibhinyunyi bhɨkaaza bhɨkazirya. ");
INSERT INTO ikz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɨzɨndɨ, zɨkagwa kukurungutarɨ, hanʉ zaamɨrirɨ, zɨkabhurwa amanzi, zɨkanyaara. ");
INSERT INTO ikz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɨzɨndɨ zɨkagwa mʉmahwa. Hanʉ zimbusurʉ ziyo zaamɨrirɨ zɨkatanga kʉkʉra, amahwa gayo gakakʉra, gakazihiza. ");
INSERT INTO ikz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɨzɨndɨ zɨkagwa kwirobha rizʉmu, zɨkamera, zʉʉsi zikiibhʉra igana igana!” Yɨɨsu hanʉ aamarirɨ kʉgamba gayo, akanʉnga riraka akabhuga, “Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abhɨɨga bhaazɨ bhakamubhuurya, “Ekerenjo kiyo, enzobhooro yaku nɨkɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akabhagarukirya, “Amangʼana gʉ ʉbhʉtɨmi bhwa Mungu ganʉ giibhisirɨ, Mungu abhahumburiirɨ imwɨ mobhone kʉgamenya. Nawe abhandɨ nɨrabhabhʉʉrɨra kobherenjo chɨmbu ʉmʉrʉʉtɨrɨri Isaaya aabhugirɨ, ‘Nʉʉrʉ bhararora, bhatanaama, na nʉʉrʉ bhariigwɨ, bhatoobhoora.’ ");
INSERT INTO ikz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ne ekerenjo kiyo, enzobhooro yaku nɨ yɨnʉ: imbusurʉ nɨ‑ngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Zimbusurʉ zɨnʉ zaagwirɨ kʉnzɨra, zereerecha abhaatʉ bhanʉ bhakwigwa ɨngʼana ya Mungu, hayohayo Shɨtaani ahaaza na kuruushaho ɨngʼana yiyo mozekoro zaabhʉ, korereke bhataaza kwisirirya, bhakasabhurwa. ");
INSERT INTO ikz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Zɨnʉ zaagwirɨ kukurungutarɨ zereerecha abhaatʉ bhanʉ, bhakwigwa ɨngʼana ya Mungu, bharayigwata kwa bhozomerwa na kuyiisirirya kwibhaga iguhɨ, nawe bharaagemwe, bhararitiga kʉ kʉbha bhataana imiri. ");
INSERT INTO ikz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zɨnʉ zaagwirɨ mʉmahwa, zereerecha abhaatʉ bhanʉ bhakwigwa ɨngʼana ya Mungu, akʉmara bharahigwa nu ubhwʉbha, ɨnamba yu ubhuniibhi, ne eteemwa yu ubhuniibhi bhwa kʉʉsɨ. Gayo garagirya ubhwikari bhwabhʉ kʉbha chɨ ɨmɨtɨ gɨnʉ gɨtakwibhʉra imisumʉ mɨzʉmu. ");
INSERT INTO ikz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na zimbusurʉ zɨnʉ zaagwirɨ kwirobha rizʉmu, zereerecha abhaatʉ bhanʉ bhakwigwa ɨngʼana ya Mungu, na kuyigwata kwa mwʉyʉ mwɨrʉ, na kwigumirirya kuhika kwibhʉra imisumʉ. ");
INSERT INTO ikz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Abhaatʉ bhatahaagwatya ɨkɨmʉrɨ, na kukikundikirya na rihʉʉzʉ, hamwɨ kʉkɨtʉʉra mwirungu ryʉ ʉbhʉrɨrɨ. Nawe, bhahaakɨtʉʉra igʉrʉ wɨ ɨkɨkʉngʉ, korereke hanʉ abhaatʉ bhakusikɨra, bharore ubhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chʉchʉsi kɨnʉ kibhisirwɨ, kɨrabha habhwɨrʉ, na bhɨnʉ bhikundikiriibhwɨ, bhɨrahumburwa, na komenyekana. ");
INSERT INTO ikz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nangʉ, mwitegeerere bhwaheene! Kʉ kʉbha, wʉnʉ akwitegeerera ɨngʼana ya Mungu na koyemenya, Mungu aramʉsakirya na kumwongerya koyemenya. Nawe arɨɨbhɨ ʉmʉʉtʉ atakwitegeerera ɨngʼana ya Mungu, nʉʉrʉ isuuhu yɨnʉ akwiseega amɨnyirɨ araruusibhwa.” ");
INSERT INTO ikz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Neho unina na abhahiiri bhaazɨ bhakamwizɨra, nawe bhataaturirɨ kumuhikɨra, kʉ kʉbha abhaatʉ bhaaru bhaarɨ bhamwinaarirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Abhaatʉ bhakamʉbhʉʉrɨra, “Yiiya waazʉ na bhaumwanyu, bhiimiiriirɨ igʉtʉ, bhareenda kokorora.” ");
INSERT INTO ikz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yɨɨsu akabhagarukirya, “Yiiya na abhahiiri bhaanɨ, nɨ‑bhanʉ bhakwigwa ɨngʼana ya Mungu na kuyigwata.” ");
INSERT INTO ikz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rusikʉ rʉmwɨ, Yɨɨsu akatiira mubhwatʉ, hamwɨmwɨ na abhɨɨga bhaazɨ. Akabhabhʉʉrɨra, “Nangʉ, twambʉkɨ ɨnyanza, tujɨ imwambʉkʉ.” Bhakatanga orogendo. ");
INSERT INTO ikz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hanʉ bhaarɨ bhakuja, Yɨɨsu akasundagɨra. Rogendo rʉmwɨ gʉkahuuta ʉmʉkama mʉhaari bhʉkʉngʼu! Ubhwatʉ bhʉkatanga kwizʉra amanzi, bhʉʉsi bhakabha mʉnyaakʉ. ");
INSERT INTO ikz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Abhɨɨga, bhakaja kwa Yɨɨsu, bhakamubhuucha, bharabhuga, “Ʉmʉkʉrʉ, Ʉmʉkʉrʉ, tʉrarika!” Yɨɨsu akabhʉʉka, rogendo rʉmwɨ akahama ʉmʉkama guyo na amakunda, bhɨkatureera, kʉkabha bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Akʉmara akabhabhuurya, “Bhʉrɨ hayi ubhwisirirya bhwanyu?” Abhɨɨga bhayo bhakʉʉbhaha bhʉkʉngʼu na kʉrʉgʉʉra, bhariibhuurya, “Nɨ‑wɨɨwɨ wʉnʉ? Akorecha nʉʉrʉ ʉmʉkama ʉmʉhaari na amakunda, rogendo rʉmwɨ bhɨramwigwa!” ");
INSERT INTO ikz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yɨɨsu na abhɨɨga bhaazɨ, hanʉ bhaamarirɨ kwambʉka ɨnyanza, bhakahika mucharʉ cha Abhagɨraasi, imwambʉkʉ wa kabhɨrɨ wi icharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yɨɨsu hanʉ iikirɨ mubhwatʉ, akarumana nu umusubhɨ wʉmwɨ wʉ ʉrʉbhɨri rurya, wa amasambwa. Ʉmʉʉtʉ wuyo aarɨ na sikʉ nzaru bhʉkʉngʼu akɨɨrɨ kwikara yɨɨka, nawe aarɨ ariikara mʉmabhigi ganʉ gaarɨ zimbihɨra, na kogenda tʉʉhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hanʉ aarʉʉzɨ Yɨɨsu, akarɨgɨsa, akamugwɨra embere waazɨ aragamba kwiraka ikʉrʉ, “Nɨ‑nakɨ na naawɨ, Yɨɨsu Umwana wa Mungu wi Igʉrʉ wa Bhyʉsi? Nɨrakwisasaama kuriina rya Mungu ʉtanyaacha.” ");
INSERT INTO ikz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Akagambabhu kʉ kʉbha Yɨɨsu aarɨ abhuuriirɨ risambwa riyo rirwɨ kʉmʉʉtʉ wuyo. Risambwa riyo ryarɨ rɨramugwata manga kaaru, na abhaatʉ bhaarɨ bharamuriibha kwa komobhoha ne emenyororo, nawe aarɨ aratɨna. Na amasambwa gakamuhira ahagero hanʉ hataana abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yɨɨsu akamubhuurya, “Iriina ryazʉ wɨɨwɨ?” Akamʉgarukirya, “Iriina ryanɨ, nɨ‑Bhasirikarɨ.” Akagambabhu, kʉ kʉbha amasambwa maaru gaarɨ gamusikiriirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Amasambwa gayo, gakatanga kwisasaama Yɨɨsu atagaswaja kuja mwirʉʉma rya nyaari. ");
INSERT INTO ikz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ahagero hayo kwarɨ nɨ ɨkɨgʉrʉ, na rusizʉ wɨ ɨkɨgʉrʉ, ryareho rihizʉ ikʉrʉ rya zingurubhɨ rɨrariisha. Neho amasambwa gayo gakiisasaama Yɨɨsu, agiisiririryɨ gasikɨrɨrɨ zingurubhɨ. Yɨɨsu akagiisiririrya. ");
INSERT INTO ikz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Amasambwa gayo gakarwɨku ʉmʉʉtʉ wuyo, gakaja muzingurubhɨ. Rihizʉ riyo rɨkahiringita mwega ikihiringintʉ ɨkɨhaari zɨkagwa mʉmanzi zɨkakwa. ");
INSERT INTO ikz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kwareho na abhariisha bha zingurubhɨ ziyo. Abhariisha bhayo, bhaaza korora gʉʉsi ganʉ gahurukirɨ, bhakaryara, bhakaraganʼya amangʼana gayo mʉzɨmbɨri. ");
INSERT INTO ikz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Neho abhaatʉ bhayo bhakabhʉʉka kuja korora amangʼana gayo chɨmbu garɨ. Bhakahikɨra Yɨɨsu, bhakarora ʉmʉʉtʉ wʉnʉ aruusiibhwɨ amasambwa, ikɨɨrɨ haguhɨ na amagʉrʉ ga Yɨɨsu, ibhʉhirɨ zengebho, ana amangʼɨɨni gakunaanirɨ. Abhaatʉ bhayo bhakʉʉbhaha. ");
INSERT INTO ikz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akʉmara abhaatʉ bhanʉ bhiirʉrɨɨrɨ ɨbhɨsɨgʉ bhiyo, bhakatanga kʉbhʉʉrɨra abhakɨndichabhʉ, chɨmbu Yɨɨsu aahʉriryɨ ʉmʉʉtʉ wʉnʉ aarɨ na amasambwa. ");
INSERT INTO ikz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abhaatʉ bhʉʉsi bhanʉ bhaarɨ bhiibhiringirɨ kurwa mucharʉ cha Abhagɨraasi bhakʉʉbhaha bhʉkʉngʼu, bhakasabha Yɨɨsu arwɨ mucharʉ chabhʉ. Neho Yɨɨsu akatiira mubhwatʉ kʉgarʉka Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ʉmʉʉtʉ wʉnʉ aaruusiibhwɨ amasambwa, akiisasaama Yɨɨsu ajɨ nawe. Nawe Yɨɨsu akaanga, akamʉbhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Garʉka ɨwaanyu, ʉbhʉʉrɨrɨ abhaatʉ amangʼana ganʉ Mungu akʉkʉrɨɨrɨ.” Neho ʉmʉʉtʉ wuyo akarwa hayo, akaja, akabha ararwazɨra abhaatʉ ahagero hʉʉsi mʉrʉbhɨri amangʼana amazʉmu ganʉ Yɨɨsu aamʉkʉrɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hanʉ Yɨɨsu aahikirɨ Gariraaya, riribhita rya abhaatʉ rɨkamʉsʉngʼaana kwo obhozomerwa, kʉ kʉbha bhaarɨ bharamʉrɨnda. ");
INSERT INTO ikz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Neho akaaza ʉmʉʉtʉ wʉmwɨ, arabhirikirwa Yairʉ, ʉmʉkʉrʉ wa rirwazɨrʉ. Akahigama mʉbhʉtangɨ bhwa Yɨɨsu, akamwisasaama ajɨ yɨɨka waazɨ, ");
INSERT INTO ikz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kʉ kʉbha umuucha waazɨ umumwɨmwɨ, wʉnʉ aarɨ ni imyaka ikumi nɨ ɨbhɨrɨ, aarɨ haguhɨ kukwa. Hanʉ Yɨɨsu aarɨ akuja, riribhita rya bhaatʉ rɨkabha rɨramurimbya mbaara zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gatɨgatɨ wa abhaatʉ bhayo kwarɨ nʉ ʉmʉkari, wʉnʉ anu ubhurwɨrɨ bhwɨ ɨngɨzi kwibhaga ryi imyaka ikumi nɨ ɨbhɨrɨ. Wʉnʉ aarɨ ahurukiryɨ ebhegero bhyazɨ bhyaru kʉrɨha abhagabhʉ, ataabhʉnɨkirɨ wʉnʉ aaturirɨ komohorya. ");
INSERT INTO ikz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ʉmʉkari wuyo akaja inyuma wa Yɨɨsu, akakunʼyaku ripindʉ rye engebho yaazɨ. Hayohayo ɨngɨzi ɨkatɨnɨka, akahora. ");
INSERT INTO ikz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yɨɨsu akabhuurya, “Nɨ‑wɨɨwɨ wʉnʉ ankuniryɨku?” Abhaatʉ bhʉʉsi bhakabhuga, atareeho wʉnʉ amukuniryɨku. Peetero wʉʉsi akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, nɨ‑bhaatʉ bhaaru bhakwinaarirɨ, nebho bhakukuniryɨku!” ");
INSERT INTO ikz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nawe, Yɨɨsu akabhuga, “Nɨɨzɨ ʉmʉʉtʉ ankuniryɨ, kʉ kʉbha niriiyigwa zinguru zinduurɨku.” ");
INSERT INTO ikz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ʉmʉkari wuyo, akarora ɨtakʉtʉrɨkana kwibhisa, akaaza akagwɨra Yɨɨsu mʉmagʉrʉ, ɨnʉ ararigita. Akamʉbhʉʉrɨra mʉbhʉtangɨ bhwa bhaatʉ bhʉʉsi, kɨnʉ kigiriryɨ kumukunʼyaku, na chɨmbu ahʉrirɨ rogendo rʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yɨɨsu akamʉbhʉʉrɨra, “Muucha, ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ! Nuujɨ no omorembe.” ");
INSERT INTO ikz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hanʉ Yɨɨsu aarɨ akɨɨrɨ aragamba, akaaza ʉmʉʉtʉ kurwa wʉ ʉmʉkʉrʉ Yairʉ. Akabhʉʉrɨra Yairʉ, “Muucha waazʉ, akuurɨ. Ʉtanyaacha Umwija.” ");
INSERT INTO ikz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hanʉ Yɨɨsu iigwirɨ amangʼana gayo, akabhʉʉrɨra Yairʉ, “Ʉtʉʉbhaha! Ʉbhɨ nu ubhwisirirya, nu umuucha waazʉ arahora.” ");
INSERT INTO ikz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hanʉ Yɨɨsu aahikirɨ mumujɨ gwa Yairʉ, akarecha abhaatʉ abhandɨ kusikɨra hamwɨmwɨ nawe, kuruushaku Peetero, Yoohana, Yaakobho, na abhiibhuri bhu umuucha wuyo. ");
INSERT INTO ikz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abhaatʉ bhʉʉsi mʉrʉbhɨri ruyo, bhaarɨ bhararɨra na kwarama igʉrʉ wu umuucha wuyo. Nawe, Yɨɨsu akabhabhʉʉrɨra, “Mutigɨ kʉrɨra! Umuucha wʉnʉ akɨɨrɨ kukwa, nawe ahindiirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Abhaatʉ bhayo bhakatanga komoseka, kʉ kʉbha bhakamenya maheene umuucha wuyo akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yɨɨsu, akagwata okobhoko kwu umuucha wuyo, akamʉbhʉʉrɨra, “Umuucha, bhʉʉka!” ");
INSERT INTO ikz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Rogendo rʉmwɨ, umuucha wuyo akatindʉka, akiimɨɨrɨra. Yɨɨsu akabhabhʉʉrɨra abhiibhuri bhaazɨ bhamohe ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hanʉ abhiibhuri bhaazɨ bhaarʉʉzɨ gayo, bhakarʉgʉʉra bhʉkʉngʼu, nawe Yɨɨsu akabharecha bhatabhʉʉrɨra ʉmʉʉtʉ wʉwʉʉsi ganʉ gakʉrirwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Rusikʉ rʉmwɨ Yɨɨsu akabhabhɨrɨkɨra abhɨɨga bhaazɨ ikumi na bhabhɨrɨ. Akabhaha ʉbhʉnaja bhu ukuruusha amasambwa na bhwo okohorya amarwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akabhatʉma, bhajɨ kurwazɨra abhaatʉ ɨngʼana yʉ ʉbhʉtɨmi bhwa Mungu, na bhahorye abharwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akabhabhʉʉrɨra, “Mʉtagega kegero chʉchʉsi korogendo rwanyu: ihimbʉ, ɨsakwa, ibhyakurya, zimpirya, nʉʉrʉ ɨshadi ya kʉgarʉra. ");
INSERT INTO ikz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Munyumba yʉyʉʉsi yɨnʉ bharaabhasʉngʼaanɨ, mwikarɨ muyomuyo, kuhika hanʉ mʉkʉbhʉʉka mʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na abhaatʉ bhʉ ʉrʉbhɨri rwʉrwʉsi bharaatamɨ kʉbhasʉngʼaana, hanʉ mʉkʉbhʉʉka, mʉkʉngʼʉtɨ urutu kʉmagʉrʉ gaanyu, kobheerecha kʉbha Mungu arabhaanga.” ");
INSERT INTO ikz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Neho abhɨɨga bhayo, bhakaja bhakahɨta mʉzɨmbɨri, bhararwaza Ɨngʼana Ɨnzʉmu na kohorya abharwɨrɨ hʉhʉʉsi hanʉ bhaahitirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gʉʉsi ganʉ Yɨɨsu aarɨ akokora, ʉmʉtɨmi Heroode Antipaasi aarɨ ariigwa amangʼana gaazɨ, gakamoha ubhwʉbha. Akʉʉbhaha kʉ kʉbha abhaatʉ abhandɨ bhaarɨ bharabhuga kʉbha, Yɨɨsu newe Yoohana Ʉmʉbhatiizi aryukirɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abhandɨ bhaarɨ bharabhuga kʉbha, newe ʉmʉrʉʉtɨrɨri Ɨɨriya iizirɨ naatu. Kwarɨ na abhandɨ, bhaarɨ bharabhuga, wʉmwɨ waho wa abharʉʉtɨrɨri bhɨ ɨkarɨ newe aryukirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nawe, Heroode akabhuga, “Yoohana, nɨkamʉtɨna umutwɨ! Nangʉ, nɨ‑wɨɨwɨ wuyo, niriigwa amangʼana gaazɨ?” Akiigomba arumanɨ na Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hanʉ abhatumwa bhaagarukirɨ kwa Yɨɨsu, bhakamʉbhʉʉrɨra gʉʉsi ganʉ bhaakʉrirɨ. Akabhakangatya bhakaja mʉrʉbhɨri rwa Bhɨtɨsaida. ");
INSERT INTO ikz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hanʉ abhaatʉ bhaabhwɨnɨ amangʼana kʉbha agiirɨ harya, bhaarɨ bharamutuna. Akabhasʉngʼaana bhwaheene, akatanga kubhiija igʉrʉ wʉ ʉbhʉtɨmi bhwa Mungu. Na gatɨ waabhʉ, aarɨ arabhahorya abharwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hanʉ ryahikirɨ rigoroobha, abhatumwa ikumi na bhabhɨrɨ bhakamujaku bhakamʉbhʉʉrɨra, “Hanʉ tʉrɨ, ni‑mwitɨrɨgʉ. Ʉbharagɨ abhaatʉ bhanʉ, bhajɨ mʉzɨmbɨri za haguhɨ na zinyumba nɨ ɨmɨgʉndʉ, korereke bhiibhonere hu ukuhindɨra ni ibhyakurya.” ");
INSERT INTO ikz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yɨɨsu akabhagarukirya, “Mʉbhahɨ imwɨ ibhyakurya.” Bhakamʉgarukirya, “Itwɨ tʉtaana ibhyakurya, nawe ɨmɨkaatɨ ɨtaanʉ na ziiswɨ ibhɨrɨ. Oreenda tujɨ tʉbhagʉrɨrɨ abhaatʉ bhanʉ bhʉʉsi ibhyakurya?” ");
INSERT INTO ikz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abhaatʉ bhanʉ bhaarɨ hayo, abhasubhɨ bhaarɨ bharatʉra kuhika bhɨkwɨ bhɨtaanʉ. Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Mʉbhabhʉʉrɨrɨ abhaatʉ bhiikarɨ kobhegoto, ebhegoto bhɨbhɨ na abhaatʉ merongo ɨtaanʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Neho bhakakora chɨmbu aabharagiriirɨ, kuhika bhakabhiikarya bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Akagega ɨmɨkaatɨ ɨtaanʉ na ziiswɨ ibhɨrɨ zirya, akarangamɨra kwisaarʉ akabhʉʉrɨra Mungu, azʉmiryɨ. Neho akagisunyura, akabhaha abhɨɨga bhaazɨ bhabhasondye abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhʉʉsi bhakarya, bhakiigʉta. Bhakabhiringa amasaajʉ gi ibhyakurya, bhakiizurya bhɨhʉʉzʉ ikumi na bhɨbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Rusikʉ rʉmwɨ, Yɨɨsu aarɨ arasabha Mungu haawɨɨsi na abhɨɨga bhaazɨ bhaarɨ haguhɨ nawe. Akʉmara, akabhabhuurya, “Abhaatʉ bharabhuga inyɨ nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhakamʉgarukirya, “Abhandɨ bharabhuga, awɨ ne‑Yoohana Ʉmʉbhatiizi. Na abhandɨ awɨ, nɨ‑Ɨɨriya. Nʉʉrʉ abhandɨ kʉbha awɨ, nɨ‑mʉrʉʉtɨrɨri wɨ ɨkarɨ aryukirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yɨɨsu akabhabhuurya naatu, “Nawe imwɨ, mʉrabhuga inyɨ nɨ‑wɨɨwɨ?” Peetero akamʉgarukirya, “Awɨ naawɨ Kiriisitʉ kurwa kwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yɨɨsu akabhahama bhatabhʉʉrɨra mʉʉtʉ ingʼana riyo. ");
INSERT INTO ikz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akabhabhʉʉrɨra, “Umwana wʉ Ʉmʉʉtʉ, areenderwa abhone ɨnyaakʉ kʉrʉ, angwɨ na abhakaruka bha Abhayaahudi, na abhakʉrʉ bha abhakuhaani, na abhiija bhi imigirʉ, kuhika iitwɨ. Nawe urusikʉ rwa katatʉ kwɨma ukukwa kwazɨ araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Akʉmara, Yɨɨsu akabhabhʉʉrɨra bhʉʉsi, “Ʉmʉʉtʉ wʉwʉʉsi areende kuntuna, areenderwa iyangɨ umwene, agege ʉmʉsarabha gwazɨ, antunɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ʉmʉʉtʉ wʉnʉ akwenda kohonʼya ʉbhʉhʉru bhwazɨ umwene, arabhurimirya. Nawe ʉmʉʉtʉ wʉnʉ akurimirya ʉbhʉhʉru bhwazɨ igʉrʉ waanɨ, arabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kʉna bhwerakɨ, ʉmʉʉtʉ areebhone ubhuniibhi bhwʉsi mʉʉsɨ yɨnʉ, nawe arimiryɨ hamwɨ kuricha ʉbhʉhʉru bhwazɨ umwene? ");
INSERT INTO ikz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Wʉwʉʉsi wʉnʉ akondorera zɨsʉni inyɨ na amiija gaanɨ, Umwana wʉ Ʉmʉʉtʉ wʉʉsi aramororera zɨsʉni, hanʉ araazɨ nʉ ʉbhʉkʉrʉ bhwazɨ, nʉ ʉbhʉkʉrʉ bhwa Wiisɨ, na bhwa bhamaraika bhaazɨ abharɨndu. ");
INSERT INTO ikz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Nɨrabhabhʉʉrɨra amaheene, bhareho abhaatʉ gatɨ waanyu hanʉ, bhanʉ bhatakukwa, bhakɨɨrɨ korora ʉbhʉtɨmi bhwa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sikʉ inyanyɨ zɨkahɨta, hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo, akagega Peetero, Yoohana na Yaakobho, akatiira nabhʉ kʉkɨgʉrʉ, kʉsabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hanʉ aahikirɨ mʉkɨgʉrʉ, akatanga kʉsabha Mungu. Rogendo rʉmwɨ, akiichʉra ubhushʉ. Amiibhoho gaazɨ, gakabha mɨɨrʉ ga pee, gakabharya bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hayohayo, bhakarorekana abhaatʉ bhabhɨrɨ, bharagambana na Yɨɨsu, nabhʉ ni‑Musa na Ɨɨriya. ");
INSERT INTO ikz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bhakarorekana mʉbhʉgʉngʉ, bharagambɨra chɨmbu arɨɨmarɨ emeremo jazɨ kwa kukwa Yɨrusarɨɨmu iyo. ");
INSERT INTO ikz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kwibhaga riyo, Peetero na abhakɨndichazɨ bhaarɨ bhahindiirɨ zendooro za turu. Na hanʉ bhaabhuukirɨ, bhakarora ubhwɨrʉ bhwazɨ, na abhasubhɨ bhabhɨrɨ, bhiimiiriirɨ haguhɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hanʉ bhabhɨrɨ bhayo bhaarɨ bhakurwa kwa Yɨɨsu, Peetero akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ wɨɨtʉ, nɨ‑bhwaheene itwɨ kʉbhaho hanʉ. Twʉmbakɨ ibhituku bhɨtatʉ, ɨkɨmwɨ ichazʉ, ɨkɨndɨ cha Musa nɨ ɨkɨndɨ cha Ɨɨriya.” Nawe Peetero ataarɨ yɨɨzɨ kɨnʉ akʉgamba. ");
INSERT INTO ikz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hanʉ Peetero aarɨ aragamba gayo, rɨkahwarʉka risaarʉ igʉrʉ waabhʉ, rɨkabhakundikirya. Abhɨɨga bhayo, bhakʉʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Riraka rɨkarwa mwisaarʉ, rɨrabhuga, “Wʉnʉ ni‑Mwana waanɨ omorobhorwa, mumwitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hanʉ riraka riyo ryasirirɨ, abhɨɨga bhayo bhakarora Yɨɨsu aru umwene. Muzisikʉ ziyo abhɨɨga bhayo bhakiikara bhukiri, bhataabhuuriirɨ mʉʉtʉ wʉwʉʉsi ganʉ bhaarʉʉzɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hanʉ bhwɨrirɨ, Yɨɨsu na abhɨɨga bhayo bhatatʉ bhakiika kʉkɨgʉrʉ iyo, bhakarumana na riribhita ikʉrʉ rya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na gatɨ wa abhaatʉ bhayo, kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ, akatiirya riraka, akabhuga, “Umwija, nɨrakʉsabha, ondorere umwana wʉnʉ, kʉ kʉbha ewe ni‑mwana waanɨ umumwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Risambwa rɨhaamutiira na komokora arɨgɨsɨ. Rɨhaamoteemerya ririmu, kuhika rihuru rɨrarʉmba mumunywa. Ryahaamʉnyaacha bhʉkʉngʼu, na rɨtakumutiga bhwangʉ. ");
INSERT INTO ikz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɨmarirɨ kubhiisasaama abhɨɨga bhaazʉ kʉbha bhamuruushɨ, nawe bhataaturirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yɨɨsu akabhuga, “Imwɨ urwibhʉrʉ rʉnʉ rʉtakwisirirya, rʉnʉ rurimiirɨ! Niriikara na niimwɨ na kubhiigumirirya kuhika ryʉrɨ? Momoreete hanʉ umwana wuyo.” ");
INSERT INTO ikz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hanʉ umwana wuyo aarɨ akuja kwa Yɨɨsu, risambwa riyo rɨkamugwisha haasɨ na komoteemerya ririmu. Nawe, Yɨɨsu akarɨhaarɨra, akamohorya umwana wuyo, akamʉgarucha kwa wiisɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hanʉ abhaatʉ bhʉʉsi bhaarʉʉzɨ ʉbhʉnaja ʉbhʉkʉrʉ bhwa Mungu, bhakarʉgʉʉra bhʉkʉngʼu. Hanʉ abhaatʉ bhayo bhʉʉsi bhaarɨ bhakɨɨrɨ bhararʉgʉʉra amahocha ga Yɨɨsu, ewe akabhabhʉʉrɨra abhɨɨga bhaazɨ, ");
INSERT INTO ikz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mwitegeerere bhwaheene amangʼana ganʉ nɨkʉbhabhʉʉrɨra. Umwana wʉ Ʉmʉʉtʉ, araja kuhurukibhwa mʉmabhoko ga abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nawe, bhatʉʉbhʉʉrirɨ kɨnʉ Yɨɨsu aabhabhuuriirɨ, kʉ kʉbha ɨngʼana yiyo yaarɨ ibhisirwɨ kwebho, bhatamenya. Na bhaarɨ bharʉʉbhaha kumubhuurya igʉrʉ wa amangʼana gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Gatɨ wa abhɨɨga bha Yɨɨsu, kʉkatuumuka iryʉmana igʉrʉ wa wɨɨwɨ gatɨ waabhʉ nɨ‑mʉkʉrʉ kʉkɨra abhakɨndichabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kʉ kʉbha Yɨɨsu akamenya amiisɨɨgi gaabhʉ, akagega umwana, akamwimiirirya haguhɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Akabhabhʉʉrɨra, “Ʉmʉʉtʉ araaginihyɨ ʉmʉʉtʉ wa haasɨ chɨmbu umwana wʉnʉ kuriina ryanɨ, niinyɨ aginihiryɨ. Nʉ ʉmʉʉtʉ araanginihyɨ, neho aginihiryɨ na wʉnʉ antumirɨ. Ʉmʉʉtʉ umusuuhu gatɨ waanyu imwʉsi, newe ʉmʉkʉrʉ kʉkɨra bhʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoohana akabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ, tʉkarora ʉmʉʉtʉ wʉnʉ aarɨ araruusha amasambwa kuriina ryazʉ. Itwɨ tʉkagema komorecha, kʉ kʉbha atarɨ hamwɨmwɨ na niitwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Mʉtamorecha, kʉ kʉbha ʉmʉʉtʉ wʉnʉ atakʉbhaanga imwɨ, arɨ ʉrʉbhaara rwanyu.” ");
INSERT INTO ikz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ribhaga rya Yɨɨsu ryʉ ʉkʉgarʉka mwisaarʉ ryarɨ rɨrariirɨ, neho akeenda ajɨ Yɨrusarɨɨmu, akabhʉʉka. ");
INSERT INTO ikz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akatʉma abhaatʉ bhamʉkangatɨrɨ. Bhakaja, bhakasikɨra mʉrʉbhɨri rʉmwɨ rwa Abhasamaariya, korereke bhamokonzere ebhegero bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nawe, abhaatʉ bhayo bhakaanga kʉmʉsʉngʼaana, kʉ kʉbha aarɨ araja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hanʉ abhɨɨga bhaazɨ Yaakobho na Yoohana, bhaarʉʉzɨ gayo, bhakamubhuurya, “Ʉmʉkʉrʉ, oreenda tʉsabhɨ omorero gwikɨ kurwa mwisaarʉ gʉbharichɨ, chɨmbu ʉmʉrʉʉtɨrɨri Ɨɨriya aakʉrirɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nawe Yɨɨsu, akabhiichʉrɨra, akabharecha, akabhuga, “Mʉtɨɨzɨ ne‑koro ya teemwakɨ mʉnayo. ");
INSERT INTO ikz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umwana wa Adaamu atiizirɨ kuricha abhaatʉ, nawe kʉbhasabhʉra.” Bhakaja mʉrʉbhɨri ʉrʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hanʉ Yɨɨsu na abhɨɨga bhaazɨ bhaarɨ bharagenda kʉnzɨra, ʉmʉʉtʉ wʉmwɨ akamʉbhʉʉrɨra, “Hʉhʉʉsi hanʉ ʉraajɨ, nɨrakutuna.” ");
INSERT INTO ikz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yɨɨsu akamʉgarukirya, “Bhanyamubhwɨ bhaana amabhigi ni ibhinyunyi bhini ibhinyumba. Nawe, Umwana wʉ Ʉmʉʉtʉ, ataana nʉʉrʉ hʉ ʉkʉtʉʉra ʉrʉbharu rwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yɨɨsu akabhʉʉrɨra ʉmʉʉtʉ ʉwʉndɨ, “Ntuna.” Ʉmʉʉtʉ wuyo akamʉgarukirya, “Ʉmʉkʉrʉ, nyiisiririrya hinga nijɨ kʉbhɨɨka bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nawe Yɨɨsu akamʉgarukirya, “Tiga abhaku bha zekoro bhabhɨɨkɨ abhaku abhakɨndichabhʉ, nawe, awɨ nuujɨ ʉraarɨkɨ ɨngʼana yʉ ʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ʉmʉʉtʉ ʉwʉndɨ, akabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ, nɨrakutuna. Nawe hinga, unyiisiririryɨ nijɨ nɨbharagɨ abhaatʉ bha yɨɨka.” ");
INSERT INTO ikz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yɨɨsu akamʉbhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ atangirɨ kʉrɨma, ɨnʉ ariichʉra na korora inyuma, wuyo atakwenderwa kʉbha omohocha wa Mungu mʉbhʉtɨmi bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mmbe, akʉmara Ʉmʉkʉrʉ Yɨɨsu akarobhora abhɨɨga abhandɨ merongo muhungatɨ na bhabhɨrɨ. Akabhatʉma bhabhɨrɨ bhabhɨrɨ, bhamʉkangatɨrɨ kuja zɨmbɨri zʉʉsi na ahagero hʉʉsi, hanʉ ɨɨndirɨ kuhika umwene. ");
INSERT INTO ikz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yɨɨsu akabhabhʉʉrɨra, “Amagesa maaru, nawe abhahocha, nɨ‑bhasuuhu. Mmbe mʉsabhɨ Mungu newe umwene mʉgʉndʉ, korereke atʉmɨ abhahocha mʉmʉgʉndʉ gwazɨ, bhagese. ");
INSERT INTO ikz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Imwɨ mujɨ, nawe, nɨrabhatʉma ncha zɨngʼʉndu gatɨ wa zisuuzɨ. ");
INSERT INTO ikz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mʉtagega ɨkɨgʉzi cha zimpirya, ɨsakwa, hamwɨ ibhikwɨra, na mʉrɨɨbhɨ mʉnzɨra, mʉtakeerya mʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Hanʉ mʉraasikɨrɨ munyumba mokeerye abhaatʉ bhaamu, ‘Mʉbhɨ no omorembe!’ ");
INSERT INTO ikz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Arɨɨbhɨ ʉmʉʉtʉ wʉnʉ amɨnyirɨ muyo, nɨ‑mʉsɨɨgi wo omorembe, omorembe gʉrasaaga hamwɨmwɨ neewe. Nawe, arɨɨbhɨ atariimu ʉmʉʉtʉ wo omorembe, omorembe gwanyu gʉrabhagarʉkɨra. ");
INSERT INTO ikz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mʉtabha mʉraja kuhindɨra nyumba yɨndɨ, mwikarɨ mumujɨ gʉnʉ mwasikiirɨ, muryɨ na kunywa bhɨnʉ bhakʉbhaha, kʉ kʉbha omohocha areenderwa kurihwa amarihi gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Hanʉ mʉraasikɨrɨ mumujɨ na bhaamu bhabhaginihyɨ, muryɨ ibhyakurya bhɨnʉ bharɨɨbhahɨ. ");
INSERT INTO ikz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mohorye abharwɨrɨ bhaamu, mʉbhabhʉʉrɨrɨ, ‘Ʉbhʉtɨmi bhwa Mungu bhʉraariirɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nawe, mʉraasikɨrɨ mumujɨ na bhaamu bhatabhaginihya, mʉhɨtɨ mʉzɨmbɨri, mʉrabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Naabha urutu rwʉ ʉrʉbhɨri rwanyu rʉnʉ rugwatirɨ kʉmagʉrʉ gɨɨtʉ, tʉrakʉngʼʉta, ɨbhɨ ekerenjo kʉbhaniimwɨ.’ Nawe, momenye, ʉbhʉtɨmi bhwa Mungu bhʉraariirɨ! ");
INSERT INTO ikz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɨrabhabhʉʉrɨra, urusikʉ rʉnʉ Mungu akʉtɨnɨra abhaatʉ bha kʉʉsɨ, aratɨnɨra abhaatʉ bhʉ ʉrʉbhɨri ruyo kʉkɨra chɨmbu aabhatiniirɨ abhaatʉ bha Sodoma! ");
INSERT INTO ikz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Horeera imwɨ abhaatʉ bha Korazini! Horeera imwɨ bha Bhɨtɨsaida! Angabhɨɨrɨ ɨbhɨsɨgʉ bhɨnʉ bhyakʉriibhwɨ kwa niimwɨ, bhyangakʉrirwɨ mʉzɨmbɨri za abhasarya bha Tiiro na Sidʉʉni, bhaarɨ bharatiga ʉbhʉbhɨ bhwabhʉ kukwibhoha amagonera na kwihaka riibhu. ");
INSERT INTO ikz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nawe urusikʉ rwɨ ɨtɨnɨrʉ, Mungu arabhatɨnɨra imwɨ kʉkɨra abhaatʉ bha Tiiro na Sidʉʉni! ");
INSERT INTO ikz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Na niimwɨ, abhaatʉ bha Kapɨrinaumu, muriiseega mʉratiiribhwa kuhika mwisaarʉ? Zɨyi! Nawe muriikibhwa kuhika nyaari!” ");
INSERT INTO ikz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Akʉmara, Yɨɨsu akabhabhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ araabhiitegeerere imwɨ, anyiitegeerere inyɨ, nʉ ʉmʉʉtʉ wʉnʉ araabhaangɨ imwɨ, anyangirɨ inyɨ, na wʉnʉ araanyangɨ, amwangirɨ wʉnʉ antumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Akʉmara, abhɨɨga bhayo merongo muhungatɨ na bhabhɨrɨ bhakagarʉka, bhazʉmɨɨrwɨ. Bhakabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ wɨɨtʉ, nʉʉrʉ amasambwa gatusuukirɨ, hanʉ twarɨ tʉragaheebha kuriina ryazʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Akabhagarukirya, “Nɨkarora Shɨtaani ariika kurwa mwisaarʉ chʉ ʉrʉkʉbha. ");
INSERT INTO ikz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nangʉ momenye kʉbha, nɨbhahɨɨrɨ ʉbhʉnaja igʉrʉ wa zinguru zʉʉsi zu umubhisa wuyo, na mʉranaja kogenda gatɨ wa zenzoka nɨ ɨbhɨtʉngʉʉri na kʉbhɨtaza. Kɨtareeho kegero chʉchʉsi kɨnʉ kɨkʉbhanyahaara. ");
INSERT INTO ikz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Nʉʉrʉbhu mʉtazomerwa, kʉ kʉbha amasambwa garabhasʉʉka, nawe mozomerwe kʉbha amariina gaanyu gaandikirwɨ mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ribhaga riyo, Yɨɨsu akazomerwa bhʉkʉngʼu kʉbhʉnaja bhwe Ekoro Ɨndɨndu, akabhuga, “Bhaabha, Ʉmʉkʉrʉ wa risaarʉ nɨ ɨɨsɨ, ʉzʉmiryɨ, kʉ kʉbha amangʼana ganʉ, ʉbhabhisirɨ bha amangʼɨɨni na abhasʉmi, ʉkagatʉʉra habhwɨrʉ kʉbhanʉ bhanu ubhwisirirya ncha abhaana abhasuuhu. Ɨbhu nɨmbu yakʉzʉmɨɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Akʉmara akabhabhʉʉrɨra, “Bhaabha angʼɨɨrɨ bhyʉsi. Atareeho wʉnʉ ɨɨzɨ Umwana, kuruushaku Bhaabha umwene. Na atareeho wʉnʉ ɨɨzɨ Bhaabha, kuruushaku Umwana, na wʉwʉʉsi wʉnʉ Umwana areende kumwerecha.” ");
INSERT INTO ikz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Neho Yɨɨsu akarora abhɨɨga bhaazɨ, akabhabhʉʉrɨra abheene, “Hakɨrɨku imwɨ, kʉ kʉbha mʉrarora amangʼana ganʉ na amɨɨsʉ gaanyu! ");
INSERT INTO ikz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nɨrabhabhʉʉrɨra, abharʉʉtɨrɨri bhaaru na abhatɨmi bhaarɨ bhariigomba korora ganʉ mokorora, nawe bhataagarʉʉzɨ, na kwigwa ganʉ imwɨ mukwigwa, nawe bhataagigwirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Rusikʉ rʉmwɨ, umwija wʉmwɨ wi imigirʉ ja Musa akiimɨɨrɨra, akabhuurya Yɨɨsu ribhuurya ryo okomogema, akabhuga, “Umwija, nekore ingʼanakɨ korereke nɨgabhɨ ʉbhʉhʉru bhwa kemerano?” ");
INSERT INTO ikz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yɨɨsu akamʉgarukirya, “Yandikirwɨbhwɨ mumigirʉ? Orobhoorabhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akamʉgarukirya, “Jandikirwɨ, ‘Ʉmʉsɨɨgɨ Ʉmʉkʉrʉ Mungu waazʉ kumwʉyʉ gwazʉ gwʉsi, kokoro yaazʉ yʉʉsi, kʉmanaga gaazʉ gʉʉsi, na kʉmangʼɨɨni gaazʉ gʉʉsi.’ Na ‘Ʉmʉsɨɨgɨ nyarʉbhɨri waazʉ chɨmbu wisɨɨgirɨ aumwene.’” ");
INSERT INTO ikz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yɨɨsu akamʉbhʉʉrɨra, “Ʉgarukiiryɨ bhwaheene! Korabhu, ʉrabhona ʉbhʉhʉru.” ");
INSERT INTO ikz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nawe, umwija wi imigirʉ wuyo, aarɨ areenda kwerecha ne‑we eheene mʉbhʉtangɨ bhwa Mungu, necho chagiriryɨ akabhuurya Yɨɨsu, “Na nyarʉbhɨri waanɨ, nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Akamʉgarukirya, “Ʉmʉʉtʉ wʉmwɨ, aarɨ ararwa Yɨrusarɨɨmu, araja Yɨriko. Mʉnzɨra, akarumana na abhiibhi. Abhiibhi bhayo, bhakamotema bhʉkʉngʼu, bhakamʉnyahaara, bhakamwibhɨra amiibhoho, bhakamutiga areenda kutinʼya. ");
INSERT INTO ikz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Mmbe, ʉbhʉzʉmu kʉnzɨra yiyo, kuhaani wʉmwɨ aarɨ arahɨta. Hanʉ aamʉrʉʉzɨ ʉmʉʉtʉ wuyo, akahɨta rusizʉ wɨ ɨnzɨra. ");
INSERT INTO ikz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Akʉmara akahɨta Ʉmʉraawi wʉmwɨ, hanʉ aamʉrʉʉzɨ, wʉʉsi akahɨta rusizʉ wɨ ɨnzɨra. ");
INSERT INTO ikz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Akʉmara akaaza Ʉmʉsamaariya wʉmwɨ, wʉnʉ aarɨ morogendo. Hanʉ aamʉrʉʉzɨ, akamororera ɨbhɨgʉngi. ");
INSERT INTO ikz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akamujaku, akamʉragʉra amagaati gaazɨ kwa kʉgatʉʉrɨra idivaayi na amaguta, akagabhoha. Akʉmara akamutiirya kʉtɨkɨrɨ yaazɨ, akamuhira munyumba ya abhagini, akamurwarya muyo. ");
INSERT INTO ikz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Tabhʉʉri waho, akahurucha zidinaari ibhɨrɨ, akamoha wi inyumba, akamʉbhʉʉrɨra, ‘Murwaryɨ ʉmʉʉtʉ wʉnʉ, na amarihi ganʉ gareenderwe igʉrʉ waazɨ, hanʉ nɨraagarʉkɨ nɨrakʉrɨha.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Neho Yɨɨsu akabhuurya umwija wi migirʉ wuyo, “Ʉrakina nɨ‑wahɨ gatɨ wa bhatatʉ bhayo, nɨ‑nyarʉbhɨri wʉ ʉmʉʉtʉ wʉnʉ aatɨmirwɨ na abhiibhi?” ");
INSERT INTO ikz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Akamʉgarukirya, “Wʉnʉ aamʉrʉrɨɨrɨ ɨbhɨgʉngi.” Yɨɨsu akamʉbhʉʉrɨra, “Nuujɨ, ʉbhɨ ne eteemwa yiyoyiyo!” ");
INSERT INTO ikz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yɨɨsu na abhɨɨga bhaazɨ, bhaarɨ morogendo, bhakasikɨra mʉrʉbhɨri rʉmwɨ. Mʉrʉbhɨri muyo, kwarɨ nʉ ʉmʉkari wʉmwɨ, iriina ryazɨ Maarita, akabhaginihya yɨɨka waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ʉmʉkari wuyo, aarɨ na umwabhʉ, arabhirikirwa Mariyamu. Ewe akiikara haguhɨ na amagʉrʉ ga Yɨɨsu, aramwitegeerera. ");
INSERT INTO ikz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maarita, akabha aranyaaka ne emeremo myaru, neho akaja kwa Yɨɨsu, akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ wɨɨtʉ, ʉtakʉdɨɨrɨɨra korora umwɨtʉ antigiire emeremo inyimwene? Nɨrasabha ʉmʉbhʉʉrɨrɨ ansakiryɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yɨɨsu akamʉgarukirya, “Maarita, Maarita. Ʉranyaaka igʉrʉ wa amangʼana maaru. ");
INSERT INTO ikz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nawe rereenderwa rɨmwɨbhu, na Mariyamu arʉbhwɨrɨ ingʼana izʉmu, rɨnʉ atareeho wa kumuruusha.” ");
INSERT INTO ikz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Rusikʉ rʉmwɨ, Yɨɨsu aarɨ ahagero harebhe, arasabha Mungu. Hanʉ aamarirɨ, wʉmwɨ wa abhɨɨga bhaazɨ akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, utwijɨ kʉsabha Mungu, chɨmbu Yoohana Ʉmʉbhatiizi abhiijiryɨ abhɨɨga bhaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yɨɨsu akabhabhʉʉrɨra, “Hanʉ mʉkʉsabha Mungu, mubhugɨbhu, ‘Bhaabha wɨɨtʉ wʉnʉ uri mwisaarʉ, iriina ryazʉ rikumibhwɨ. Ʉbhʉtɨmi bhwazʉ, bhuuzɨ. Ubhwɨndi bhwazʉ bhokorwe mʉʉsɨ hanʉ chɨmbu mwisaarʉ iyo. ");
INSERT INTO ikz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otohe ibhyakurya bhyɨtʉ bhya kɨrakabhu. ");
INSERT INTO ikz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na otobheerere ʉbhʉbhɨ bhwɨtʉ, kʉ kʉbha na niitwɨ tʉrabhabheerera bhʉʉsi bhanʉ bhatʉsaririiryɨ. Na ʉtatusikirya mubhitiimotiimo nawe ʉtʉsabhʉrɨ nʉ ʉmʉbhɨ wurya.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Akʉmara Yɨɨsu akabhabhʉʉrɨra, “Tubhugɨ wʉmwɨ waanyu anʉ ʉmʉsaani, akaja wʉ ʉmʉsaani wuyo ubhutikʉ bhwa gatɨ, akamʉbhʉʉrɨra, ‘Mʉsaani waanɨ! Nɨrasabha ɨmɨkaatɨ ɨtatʉ, ");
INSERT INTO ikz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kʉ kʉbha, ʉmʉsaani waanɨ aarɨ morogendo, ahikirɨ ɨwaanɨ, nɨtaana ibhyakurya bhyo okomoha.’ ");
INSERT INTO ikz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nawe, ʉmʉsaani wuyo akamʉgarukirya, ‘Ʉtanyaacha! Nɨmarirɨ kwigara ikisikʉ, inyɨ na abhaana bhaanɨ tuhindiirɨ, na nɨtakʉtʉra kʉbhʉʉka kokoha!’ ");
INSERT INTO ikz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Nɨrabhabhʉʉrɨra, nʉʉrʉ arɨɨbhɨ ʉmʉʉtʉ wuyo atakʉbhʉʉka na komoha ʉmʉkɨndichazɨ ʉmʉkaatɨ kʉ kʉbha ewe nɨ‑mʉsaani waazɨ, nawe arabhʉʉka na komoha ekegero kɨnʉ akwenda, kʉ kʉbha ʉmʉkɨndichazɨ akʉʉmɨraku kʉmʉsabha. ");
INSERT INTO ikz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kʉgayo nɨrabhabhʉʉrɨra, mʉsabhɨ na niimwɨ mʉrahaabhwa, momohye na niimwɨ mʉrabhona. Muhunɨ ikisikʉ na niimwɨ muriigurirwa. ");
INSERT INTO ikz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wʉwʉʉsi wʉnʉ akʉsabha, arahaabhwa. Wʉnʉ akomohya, arabhona, na wʉnʉ akuhuna ikisikʉ, ariigurirwa. ");
INSERT INTO ikz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Awɨɨ ni‑mwibhurikɨ gatɨ waanyu wʉnʉ umwana araamʉsabhɨ ʉmʉkaatɨ, aramoha riibhwɨ, hamwɨ araamʉsabhɨ iiswɨ aramoha enzoka? ");
INSERT INTO ikz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kisha umwana araamʉsabhɨ riigɨ, heene aramoha ɨkɨtʉngʉʉri? ");
INSERT INTO ikz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Arɨɨbhɨ imwɨ abhabhɨ, mwɨzɨ kʉbhaha abhaana bhaanyu ebhegero ɨbhɨzʉmu. Wuusʉ wa mwisaarʉ atakʉtʉra kʉbhaha Ekoro Ɨndɨndu kʉkɨraho, bhanʉ bhakʉmʉsabha?” ");
INSERT INTO ikz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Rusikʉ rʉmwɨ, Yɨɨsu aarɨ araheebha risambwa kʉmʉʉtʉ wʉnʉ aarɨ imuumu. Hanʉ risambwa ryamuruurɨku, ʉmʉʉtʉ wuyo akatanga kʉgamba. Abhaatʉ bhanʉ bhaarɨ hayo bhakarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nawe, abhandɨ bhakabhuga, “Araheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, ʉmʉkʉrʉ wa amasambwa!” ");
INSERT INTO ikz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abhandɨ bhakeenda kogema Yɨɨsu, bhakamʉsabha abheereche ichɨrɨkɨnʼyʉ kurwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nawe, kʉ kʉbha Yɨɨsu akamenya amiisɨɨgi gaabhʉ, akabhabhʉʉrɨra, “Arɨɨbhɨ abhaatʉ bhʉ ʉbhʉtɨmi bhʉmwɨ bhariitana, ʉbhʉtɨmi bhuyo bhʉhaagwa. Ni muyo, umujɨ gwʉgwʉsi, gʉnʉ abhaatʉ bhaamu bhatakwigwana, gʉranyaragana. ");
INSERT INTO ikz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nangʉ, arɨɨbhɨ Shɨtaani ariiyanga umwene, ʉbhʉtɨmi bhwazɨ bhuriimɨɨrɨrabhwɨ? Nɨbhabhuuriryɨ ribhuurya riyo, kʉ kʉbha mʉrabhuga nɨraheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri. ");
INSERT INTO ikz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Arɨɨbhɨ mʉrabhuga inyɨ nɨraheebha amasambwa kʉbhʉnaja bhwa Bhɨɨrizɨbhuri, abhahɨmba bhaanyu ebho bhahaagaheebha kʉbhʉnaja bhwa wɨɨwɨ? Igʉrʉ wa gayo, bhayo nebho bhareereche kʉbha ganʉ mʉkʉgamba gatarɨ maheene. ");
INSERT INTO ikz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nawe, arɨɨbhɨ inyɨ nɨraheebha amasambwa kʉbhʉnaja bhwa Mungu, mmbe ʉbhʉtɨmi bhwa Mungu bhuhikirɨ kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mwitegeerere ekerenjo kɨnʉ! Ʉmʉʉtʉ wa amanaga ne ebheseme, araariibhɨ ebhegero bhya yɨɨka waazɨ, bhɨtakwibhwa. ");
INSERT INTO ikz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nawe, ʉmʉʉtʉ ʉwʉndɨ wa zinguru kʉmʉkɨra, araazɨ kumwitanʼya na kumuhiza, aramuruusha ebheseme bhyazɨ bhɨnʉ akwisega, aragega bhyʉsi, na kʉbhasondya abhandɨ. ");
INSERT INTO ikz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ʉmʉʉtʉ wʉnʉ atarɨ hamwɨmwɨ na niinyɨ, arɨ mbarɨka. Na wʉnʉ atakubhiringa abhaatʉ bha Mungu hamwɨmwɨ na niinyɨ, arabhasanja. ");
INSERT INTO ikz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Hanʉ risambwa rikurwa kʉmʉʉtʉ, rɨhaaja kʉkɨbhara ɨnʉ rɨramohya ahagero hu ukwoyeera. Nawe rɨraatamwɨ kʉhabhona, rɨhaabhuga, ‘Nɨragarʉka uwaanɨ hanʉ naruurɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hanʉ rɨkʉgarʉka, rɨrabhona aangɨ inyumba yɨnʉ ɨtarikiibhwɨ na ɨkʉrirwɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Akʉmara rɨhaaja koreeta amasambwa agandɨ muhungatɨ amabhɨ kʉrɨkɨra, gʉʉsi gahaasikɨra kʉmʉʉtʉ wuyo, na kwikara kwawɨ. Neho ubhwikari bhwʉ ʉmʉʉtʉ wuyo bhʉhaabha bhʉbhɨ kʉkɨra chɨmbu bhwarɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hanʉ Yɨɨsu aarɨ aragamba gayo, kwarɨ nʉ ʉmʉkari wʉmwɨ, mwiribhita rya abhaatʉ, akatiirya riraka ryazɨ, akabhuga, “Hakɨrɨku ʉmʉkari wʉnʉ aakwibhwirɨ no okokokoocha!” ");
INSERT INTO ikz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yɨɨsu akabhuga, “Nawe hakɨrɨku bhʉkʉngʼu bhanʉ bhakwigwa ɨngʼana ya Mungu na kʉyɨsʉʉka!” ");
INSERT INTO ikz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hanʉ abhaatʉ bhaarɨ bhakwaruha, Yɨɨsu akabhuga, “Abhaatʉ bhu urwibhʉrʉ rʉnʉ nɨ‑bhabhɨ bhʉkʉngʼu! Bhareenda ichɨrɨkɨnʼyʉ, nawe bhatakwerechwa ichɨrɨkɨnʼyʉ chʉchʉsi, kuruushaku kɨmwɨ kɨnʉ changɨ chʉ ʉmʉrʉʉtɨrɨri Yoona. ");
INSERT INTO ikz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kʉ kʉbha, arɨɨbhɨ Yoona aarɨ ichɨrɨkɨnʼyʉ kʉbhaatʉ bhʉ ʉrʉbhɨri rwa Ninaawi, nɨmbu Umwana wʉ Ʉmʉʉtʉ, wʉʉsi araabhɨ ichɨrɨkɨnʼyʉ kʉbhaatʉ bhu urwibhʉrʉ rʉnʉ. ");
INSERT INTO ikz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Ribhaga ryʉ ʉmʉtɨmi Sɨrɨmaani, aareho marikiya wʉmwɨ wʉnʉ aarɨ aratema ʉrʉbhaara rwa rangɨ. Marikiya wuyo ariimɨɨrɨra mʉbhʉtangɨ bhwa Mungu na kʉtɨnɨra abhaatʉ bhu urwibhʉrʉ rʉnʉ, kʉ kʉbha bhasariryɨ. Ewe akarwa mucharʉ cha kore korereke aazɨ iitegeerere amangʼana gu ubhwʉbhʉʉri bhwʉ ʉmʉtɨmi Sɨrɨmaani. Nangʉ nɨrabhabhʉʉrɨra, hanʉ areho ʉmʉkʉrʉ kʉkɨra Sɨrɨmaani.” ");
INSERT INTO ikz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Urusikʉ rwɨ ɨtɨnɨrʉ, abhaatʉ bhʉ ʉrʉbhɨri rwa Ninaawi bhariimɨɨrɨra mʉbhʉtangɨ bhwa Mungu hamwɨmwɨ na abhaatʉ bhu urwibhʉrʉ rwa nangwɨnʉ na kʉrʉtɨnɨra. Abhaatʉ bha Ninaawi bhakatiga ʉbhʉbhɨ bhwabhʉ igʉrʉ wu ukwigwa ubhurwazi bhwa Yoona. Nangʉ nɨrabhabhʉʉrɨra, hanʉ areho ʉmʉkʉrʉ kʉkɨra Yoona. ");
INSERT INTO ikz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Atareeho ʉmʉʉtʉ wʉnʉ akugwatya ɨkɨmʉrɨ, akʉmara akakikundikirya na rihʉʉzʉ. Nawe ahaakɨtʉʉra igʉrʉ wɨ ɨkɨkʉngʉ, korereke hanʉ abhaatʉ bhakusikɨra, bharore ubhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Amɨɨsʉ nego ɨkɨmʉrɨ chʉ ʉmʉbhɨrɨ. Arɨɨbhɨ mahʉru, ʉmʉbhɨrɨ gwazʉ gwʉsi gʉrabha nu ubhwɨrʉ. Nawe, amɨɨsʉ gaazʉ garɨɨbhɨ marwɨrɨ, ʉmʉbhɨrɨ gwazʉ gwʉsi gʉrabha kiirimya. ");
INSERT INTO ikz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wiyangarɨrɨ ubhwɨrʉ bhʉnʉ ʉnabhwɨ mʉmʉbhɨrɨ gwazʉ, bhʉtaaza kʉbha kiirimya! ");
INSERT INTO ikz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mmbe arɨɨbhɨ ʉmʉbhɨrɨ gwazʉ mugima gunu ubhwɨrʉ, gʉtaana kiirimya hagero hʉhʉʉsi, ʉmʉbhɨrɨ guyo gʉrabharya, chɨmbu ɨkɨmʉrɨ kɨkʉkʉmʉrɨka.” ");
INSERT INTO ikz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo, Ʉmʉfarisaayo wʉmwɨ akamuginihya yɨɨka waazɨ kurya. Yɨɨsu akasikɨra, akiikara kwigari. ");
INSERT INTO ikz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ʉmʉfarisaayo wuyo akarʉgʉʉra bhʉkʉngʼu, korora Yɨɨsu ararya akɨɨrɨ kwisaabha amabhoko chɨmbu imigirʉ jabhʉ gikwenderwa. ");
INSERT INTO ikz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nawe, Ʉmʉkʉrʉ akamʉbhʉʉrɨra, “Imwɨ Abhafarisaayo, mohooja ekekombe nɨ ɨsahaani kwigʉtʉ, nawe mʉʉsi waanyu, zekoro ziizwirɨ ubhwibhi nʉ ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imwɨ abhabhɨsɨ! Wʉnʉ aabhumbirɨ igʉtʉ, atarɨ newe aabhumbirɨ na mʉʉsi? ");
INSERT INTO ikz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mʉbhasakiryɨ abhahabhɨ ebhegero bhyanyu na zekoro zaanyu zʉʉsi, neho bhyʉsi bhɨrabha bhɨbhɨngukiibhwɨ kʉbhaniimwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Horeera imwɨ Abhafarisaayo! Mʉrahurukirya Mungu yɨmwɨ yi ikumi nʉʉrʉ kwe ebhegero bhyu ubhwera ubhusuuhu bhʉkʉngʼu, nchʉ ʉmʉʉnyʉ, ibhitunguru, nɨ ɨbhɨndɨ, nawe mʉtakʉdɨɨrɨɨra eheene yaazɨ, mʉtamʉsɨɨgirɨ ewe! Moreenderwa kuhurukirya ikimweso, nawe mʉtɨɨbha kokora agandɨ gayo. ");
INSERT INTO ikz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Horeera, imwɨ Abhafarisaayo! Mʉhaasɨɨga kwikara kubhitumbɨ bhye embere mʉmarwazɨrʉ, na mʉhaasɨɨga kʉkɨɨribhwa momoteera kwa bhusuuku. ");
INSERT INTO ikz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Horeera! Imwɨ mutuubhɨɨnɨ na zimbihɨra zɨnʉ zɨtakororekana, abhaatʉ bhahaazɨtaza bhatɨɨzɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umwija wʉmwɨ wi imigirʉ akabhʉʉrɨra Yɨɨsu, “Umwija, hanʉ waarɨ ʉkʉgamba amangʼana gayo, ʉtʉtɨɨrɨmu na niitwɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yɨɨsu akamʉgarukirya, “Na niimwɨ abhiija bhi imigirʉ, horeera! Mʉrabhiitwicha abhaatʉ imirigʉ miritʉ ji imigirʉ. Na niimwɨ, mʉtakʉbhasakirya kogega nʉʉrʉ hasuuhu! ");
INSERT INTO ikz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Horeera, kʉ kʉbha mʉrʉʉmbaka zimbihɨra nzʉmu kʉbharʉʉtɨrɨri, nawe abhaatʉ bhanʉ bhaabhiitirɨ abharʉʉtɨrɨri bhayo, nɨ‑bhasʉʉkʉrʉ bhaanyu! ");
INSERT INTO ikz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ku riyo, mʉramenyeekererya kʉbha muriisirirya ganʉ bhasʉʉkʉrʉ bhaanyu bhaakʉrirɨ, kʉ kʉbha ebho bhakiita abharʉʉtɨrɨri bhayo, na niimwɨ mʉrʉʉmbaka zimbihɨra zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Necho chagiriryɨ Mungu akabhuga, kubhwʉbhʉʉri bhwazɨ, ‘Nɨratʉmɨra abharʉʉtɨrɨri na abhatumwa. Nawe, bharabhiita abhamwɨ bhaabhʉ, na kʉbhanyaacha abhandɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kuriyo, abhaatʉ bhu urwibhʉrʉ rʉnʉ bharatinirwa igʉrʉ wa amasaahɨ ga abharʉʉtɨrɨri bhʉʉsi bhanʉ bhiitirwɨ, kwɨma ʉbhʉtangɨ bhwɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Gayo, garatangɨra kʉmasaahɨ ga Abhɨɨri kuhika kʉmasaahɨ ga Zaakariya, wʉnʉ iitirwɨ mwihekaaru rya Mungu gatɨ wa Ahagero Aharɨndu na hu ukuhurukirya ikimweso. Nɨrabhabhʉʉrɨra amaheene, abhaatʉ bhu urwibhʉrʉ rʉnʉ bharatinirwa igʉrʉ wa gayo gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Horeera, imwɨ abhiija bhi imigirʉ! Mwigɨɨrɨ ikisikʉ kɨnʉ abhaatʉ bhangahitiirɨ, kobhona amangʼɨɨni komenya Mungu, nawe na niimwɨ abheene, mʉtaasikiirɨ. Na bhanʉ bhakwenda kusikɨra, mʉbharɨkiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hanʉ Yɨɨsu aaruurɨ hayo, Abhafarisaayo na abhiija bhi imigirʉ bhakatanga kʉbha bhahaari bhʉkʉngʼu kwewe. Bhaarɨ bharamubhuurya amabhuurya igʉrʉ wa amangʼana maaru, ");
INSERT INTO ikz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","korereke bhabhone kʉmʉhaatya kʉmangʼana gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ribhaga riyo, ɨbhɨkwɨ bhya abhaatʉ bhakiibhiringa kwa Yɨɨsu, kuhikɨra bhakiitaza. Yɨɨsu akatanga kʉbhabhʉʉrɨra abhɨɨga bhaazɨ, “Mwiyangarɨrɨ ne engʼeera ya Abhafarisaayo, kʉ kʉbha engʼeera yiyo ɨranyaragana nchu ubhutunduuru. ");
INSERT INTO ikz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nawe kɨtareeho kɨnʉ kikundikiriibhwɨ, kɨkatama kuhumburwa, na kɨnʉ kibhisirwɨ, kɨkatama kororekana. ");
INSERT INTO ikz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gʉʉsi ganʉ mʉkʉgamba mukiirimya, bharagiigwa habhwɨrʉ. Na gʉʉsi ganʉ mukwimonyerera gararwazwa kʉbhaatʉ habhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nɨrabhabhʉʉrɨra imwɨ abhasaani bhaanɨ, mʉtʉʉbhaha bhanʉ bhakʉtʉra kwita ʉmʉbhɨrɨ. Hanʉ bhakʉmara, bhatakʉtʉra kokora kɨndɨ chʉchʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nawe, nɨrabhabhʉʉrɨra wʉnʉ mukwenderwa kwʉbhaha, mwʉbhahɨ Mungu! Kʉ kʉbha hanʉ ewe akʉmara kwita ʉmʉʉtʉ, anʉ ʉbhʉnaja bhwo okomorekera momorero gwa nyaari. Maheene nɨrabhabhʉʉrɨra, wuyo newe, mukwenderwa kwʉbhaha umwene! ");
INSERT INTO ikz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mʉmɨnyirɨ kʉbha zɨsanzɨ isaanʉ zɨraguribhwa kwiguri isuuhu bhʉkʉngʼu. Nawe Mungu atakwɨbha nʉʉrʉ yɨmwɨ yazʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na niimwɨ, Mungu amɨnyirɨ endengo ya zinzwɨrɨ za kumitwɨ janyu. Mmbe, mʉtʉʉbhaha, kʉ kʉbha imwɨ munu ubhwera kʉkɨra zɨsanzɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉnʉ araanyiisiriryɨ mʉbhʉtangɨ bhwa abhaatʉ, Umwana wʉ Ʉmʉʉtʉ wʉʉsi aramwisirirya mʉbhʉtangɨ bhwa bhamaraika bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nawe, wʉwʉʉsi wʉnʉ akʉnyanga mʉbhʉtangɨ bhwa abhaatʉ, na niinyɨ nɨramwanga mʉbhʉtangɨ bhwa bhamaraika bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araagambɨ amangʼana amabhɨ igʉrʉ wu Umwana wʉ Ʉmʉʉtʉ, arabheererwa. Nawe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araarege Ekoro Ɨndɨndu, wuyo atakobheererwa. ");
INSERT INTO ikz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Hanʉ bhakʉbhahira kutinirwa mʉmarwazɨrʉ, mʉbhʉtangɨ bhwa abhatɨmi na mʉbhʉtangɨ bhwa abhakangati, mʉtabha na makɨbhwɨ. Mʉtahaha igʉrʉ wa amangʼana ganʉ mʉkʉgarukirya, ");
INSERT INTO ikz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kʉ kʉbha, ɨɨsa yiyoyiyo, Ekoro Ɨndɨndu ɨrabharagɨrɨra amangʼana ganʉ mukwenderwa kʉgamba.” ");
INSERT INTO ikz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kwiribhita rya abhaatʉ riyo, ʉmʉʉtʉ wʉmwɨ akabhʉʉrɨra Yɨɨsu, “Umwija, ʉbhʉʉrɨrɨ umuhiiri waanɨ, tosonde ɨgabhʉ yɨnʉ bhaabha aatutigiirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yɨɨsu akamʉgarukirya, “Wɨɨwɨ akantʉʉra nɨbhɨ ʉmʉtaanʼya waanyu?” ");
INSERT INTO ikz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Akʉmara akabhabhʉʉrɨra, “Mwiyangarɨrɨ ne eteemwa yu ubhwimani, kʉ kʉbha, ʉbhʉhʉru bhwʉ ʉmʉʉtʉ, bhʉtarɨ mubhwaru bhwe ebhegero bhyazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Akʉmara Yɨɨsu akabhabhʉʉrɨra ekerenjo, arabhuga, “Kwarɨ nu umuniibhi wʉmwɨ, wʉnʉ ʉmʉgʉndʉ gwazɨ gwapʉnirɨ ibhyakurya bhyaru bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akiibhuurya mokoro yaazɨ, ‘Nangʉ nɨrakorabhwɨ? Ibhyakurya bhyanɨ bhɨnʉ bhyʉsi, nɨtaana hagero ha kʉbhɨbhɨɨka!’ ");
INSERT INTO ikz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Neho akabhuga, ‘Nɨrakorabhu, nɨrasarya ɨbhɨtara bhyanɨ, na kwʉmbaka ɨbhɨndɨ ɨbhɨkʉrʉ kʉkɨraho. Muyo nɨratɨɨmu ibhyakurya bhyanɨ bhyʉsi, ne ebhegero bhyanɨ ɨbhɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akʉmara niriibhʉʉrɨra mokoro yaanɨ, “Nangʉ witɨɨrɨɨrɨ ikibhumbɨkʉ che ebhegero bhyaru ɨbhɨzʉmu. Bhɨrakwisa kumyaka myaru! Nangʉ, yoyeera, uryɨ, unywɨ na ozomerwe!” ’ ");
INSERT INTO ikz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Nawe Mungu akamʉbhʉʉrɨra, ‘Omogeege awɨ! Ubhutikʉ bhwa reero yɨnʉ, ʉrakwa! Ne ebhegero bhɨnʉ bhyʉsi wibhiringiirɨ, bhɨrabha bhya wɨɨwɨ?’ ” ");
INSERT INTO ikz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yɨɨsu akabhuga, “Ni‑muyo ɨraabhɨ, kʉmʉʉtʉ wʉnʉ akwibhiringɨra ebhegero bhyaru igʉrʉ waazɨ umwene, nawe atarɨ muniibhi mʉbhʉtangɨ bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Akʉmara, Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Kʉgayo, mʉtanyaakɨra ubhwikari bhwanyu, kʉbha mʉraryakɨ, hamwɨ muriibhohakɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ubhwikari bhunu ubhwera kʉkɨra ibhyakurya nʉ ʉmʉbhɨrɨ gunu ubhwera kʉkɨra zengebho. ");
INSERT INTO ikz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Mwitegeerere ekerenjo cha bhanyamoko. Bhatakʉhamba, na bhatakogesa, bhataana kibhumbɨkʉ naabha ɨkɨtara, nawe Mungu arabhariisha. Hakɨrɨku imwɨ munu ubhwera bhʉkʉngʼu kʉkɨra ibhinyunyi! ");
INSERT INTO ikz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wɨɨwɨ gatɨ waanyu, kukwinyaacha kwazɨ aratʉra kwiyongera nʉʉrʉ ɨɨsa yɨmwɨ yu ubhwikari bhwazɨ? ");
INSERT INTO ikz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nangʉ, arɨɨbhɨ mʉtakʉtʉra kokora nʉʉrʉ ingʼana isuuhu ncha riyo, kwakɨ muriinyaacha igʉrʉ wa agandɨ? ");
INSERT INTO ikz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kokerenjo ɨkɨndɨ morore ɨbhɨbharyʉ, chɨmbu bhɨkʉkʉra. Bhɨtakokora meremo nʉʉrʉ bhɨtakutuma. Nawe nɨrabhabhʉʉrɨra, nʉʉrʉ ʉmʉtɨmi Sɨrɨmaani nu ubhuniibhi bhwazɨ bhwʉsi, atiibhʉhirɨ bhwaheene nchɨ ɨbhɨbharyʉ bhiyo! ");
INSERT INTO ikz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Muyo nɨmbu, Mungu ahiibhohya bhwaheenebhu ɨbhɨbharyʉ bhya mwitɨrɨgʉ bhɨnʉ reero bhereho na tabhʉʉri bhɨrataashwa momorero. Nangʉ, nɨ‑maheene kɨmwɨkɨmwɨ kʉbha arabhiibhohya imwɨ, abhaatʉ bhu ubhwisirirya ubhusuuhu! ");
INSERT INTO ikz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mmbe, mʉtanyaaka mʉraryakɨ, hamwɨ mʉranywakɨ. Mʉtabha na bhwʉbha. ");
INSERT INTO ikz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Amangʼana gayo gʉʉsi, bharaganyaakɨra abhaatʉ bhanʉ bhatɨɨzɨ Mungu. Wuusʉ wa mwisaarʉ ɨɨzɨ kʉbha moreenda gʉʉsi gayo. ");
INSERT INTO ikz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nawe momohye hinga ʉbhʉtɨmi bhwa Mungu, na agandɨ gayo, arabhoongereererya. ");
INSERT INTO ikz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mʉtʉʉbhaha, imwɨ riribhita risuuhu, kʉ kʉbha Wuusʉ asɨɨgirɨ kʉbhaha ʉbhʉtɨmi bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muguryɨ ebhegero bhyanyu, mujɨ mʉbhahɨ abhahabhɨ bhɨnʉ mokobhona. Mwikorere ɨbhɨgʉzi bhɨnʉ bhɨtakʉsarɨka, mʉbhɨ ni ikibhumbɨkʉ mwisaarʉ kɨnʉ kɨtakusuuha. Iyo, atariiyo mwibhi wu ukwibha, naabha amasɨrɨbhɨ kʉsarya. ");
INSERT INTO ikz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hʉhʉʉsi hanʉ ibhibhumbɨkʉ bhyanyu bhɨrɨ, neho na zekoro zaanyu zɨrɨɨbhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Sikʉ zʉʉsi, mʉbhɨ bhwaheene kohocha, umwise nu ubhutikʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mʉbhɨ chɨmbu abhahocha bhanʉ bhakʉrɨnda ʉmʉkʉrʉ waabhʉ agarʉkɨ kurwa mubhuryakari, korereke araahunɨ ikisikʉ, bhabhɨ bhwaheene rogendo rʉmwɨ kumwigʉrɨra. ");
INSERT INTO ikz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hakɨrɨku abhahocha bhanʉ ʉmʉkʉrʉ waabhʉ arɨɨbhabhone bharamʉrɨnda aazɨ. Nɨrabhabhʉʉrɨra amaheene, ariikonza, arabhiikarya kubhyakurya, na kʉbhahocherya! ");
INSERT INTO ikz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Naabha ʉmʉkʉrʉ arɨɨgarʉkɨ ɨɨsa inyanyɨ ubhutikʉ, hamwɨ ritabhʉʉri rya ziri, na kʉbhabhona bharɨ bhwaheene, hakɨrɨku abhahocha bhayo! ");
INSERT INTO ikz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Momenye bhwaheene ringʼana rɨnʉ, wi inyumba, angamɨnyirɨ ɨɨsa yɨnʉ umwibhi akuuza, aarɨ ariikonza, nu umwibhi ataarɨ arasikɨra yɨɨka waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na niimwɨ, mʉbhɨ bhwaheene ibhaga ryʉsi, kʉ kʉbha Umwana wʉ Ʉmʉʉtʉ, araaza ribhaga rɨnʉ mʉtakwisega.” ");
INSERT INTO ikz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Akʉmara, Peetero akabhuurya Yɨɨsu, “Ʉmʉkʉrʉ, ekerenjo kɨnʉ utubhuuriirɨ itwɨ abheene, hamwɨ nɨ‑kʉ bhaatʉ bhʉʉsi?” ");
INSERT INTO ikz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ʉmʉkʉrʉ akamʉgarukirya, “Omohocha omoheene na wu ubhwʉbhʉʉri nɨ‑wahɨ? Ne‑mohocha we eteemwa yɨnʉ, ʉmʉkʉrʉ waazɨ akʉmʉtʉʉra igʉrʉ wa abhahocha abhakɨndichazɨ, korereke abhahɨ ibhyakurya bhyabhʉ kwibhaga ryazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hakɨrɨku omohocha wʉnʉ hanʉ ʉmʉkʉrʉ waazɨ araagarʉkɨ kurwa orogendo arabhona arakora chɨmbu aamuswajiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨrabhabhʉʉrɨra amaheene, ʉmʉkʉrʉ waazɨ aratʉʉra omohocha wuyo abhɨ umwimiiririri we ebhegero bhyazɨ bhyʉsi! ");
INSERT INTO ikz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Nawe omohocha ʉmʉbhɨ nɨ‑wʉnʉ ahiigambɨra mokoro yaazɨ, ‘Ʉmʉkʉrʉ waanɨ arakeezera kʉgarʉka,’ ahaatanga kotema bhambʉʉsa abhakɨndichazɨ, na kurya na kunywa amarwa, kuhika aragwatwa. ");
INSERT INTO ikz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ʉmʉkʉrʉ waazɨ aragarʉka urusikʉ nɨ ɨɨsa yɨnʉ omohocha atakwiseega. Aramotema kɨbhɨ, na kʉmʉtʉʉra iribhita imwɨmwɨ na abhaatʉ bhanʉ bhatarɨ abhaheene. ");
INSERT INTO ikz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Omohocha wʉnʉ yɨɨzɨ amiisɨɨgi gʉ ʉmʉkʉrʉ waazɨ, nawe atɨɨndirɨ kʉmʉsʉngʼaana, naabha ataasuukirɨ amaragɨrɨra gʉ ʉmʉkʉrʉ waazɨ, aratemwa zihimbʉ nzaru. ");
INSERT INTO ikz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nawe, omohocha wʉnʉ atamɨnyirɨ amiisɨɨgi gʉ ʉmʉkʉrʉ, akakora ɨngʼana yɨnʉ ikwenderwa anyaakibhwɨ, ewe aratemwa zihimbʉ suuhu. Ʉmʉʉtʉ wʉnʉ aahɨɨrwɨ bhyaru, bhereenderwa bhyaru, ʉmʉʉtʉ wʉnʉ aahɨɨrwɨ bhyaru bhʉkʉngʼu, bhereenderwa bhyaru bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Inyɨ niizirɨ mʉʉsɨ kwacha omorero. Naarɨ nereenda gʉbhɨ gʉmarirɨ kwaka! ");
INSERT INTO ikz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nʉʉrʉ inyɨ, nɨnʉ ʉbhʉbhatiizi bhʉnʉ bhukwenderwa nɨbhʉsʉngʼaanɨ, na kuhika bhʉrakorwa, nɨnayʉ ɨnyaakʉ kʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Awɨɨ, mʉrakina niizirɨ mʉʉsɨ koreeta omorembe? Nɨrabhabhʉʉrɨra, niizirɨ kʉtaanʼya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kwɨma nangʉ, munyumba ya abhaatʉ bhataanʉ, bhatatʉ bharataana na bhabhɨrɨ. Bhabhɨrɨ bhʉʉsi, bharataana na bhatatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bhaabha arasaarʉkanʼya nu umwana waazɨ, nu umwana waazɨ wʉʉsi, arasaarʉkanʼya na wiisɨ. Yiiya arabha igʉrʉ wu umuucha waazɨ, umuucha wʉʉsi igʉrʉ wa unina. Uninabhyara aramʉhakaanʼya ʉmʉkamwana, ʉmʉkamwana wʉʉsi, aramʉhakaanʼya uninabhyara.” ");
INSERT INTO ikz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Akʉmara Yɨɨsu akabhabhʉʉrɨra abhaatʉ bha kwiribhita riyo, “Mʉraarore risaarʉ rɨratiira ʉrʉbhaara rwa nyanza, rogendo rʉmwɨ mʉrabhuga, ‘Rɨtarɨ ibhaga irɨɨhu imbura ɨratweka,’ na ɨkatweka. ");
INSERT INTO ikz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na mʉraarore ʉmʉkama gʉrarwa ʉrʉbhaara rwa rangɨ, rogendo rʉmwɨ mʉrabhuga, ‘Iryʉya rɨrabhaho,’ na nɨmbu ɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imwɨ abhabhɨɨhi! Mwɨzɨ kwobhoora ichɨrɨkɨnʼyʉ chɨ ɨɨsɨ na risaarʉ. Ndora mʉratamwa komenya enzobhooro ya amangʼana ganʉ gakʉhʉrʉka zisikʉ zɨnʉ? ");
INSERT INTO ikz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na kwakɨ mʉtakwisirirya imubheene kokora ganʉ gakwenderwa? ");
INSERT INTO ikz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Arɨɨbhɨ ʉmʉkʉgambi arakuhira kumutiniri, mwigwanɨ nawe mʉkɨɨrɨ mʉnzɨra. Ɨrɨɨtamɨbhu, arakuhicha kumutiniri. Nu umutiniri wuyo, arakuhira kumusirikarɨ, korereke akusikiryɨ mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","“Nɨrakʉbhʉʉrɨra amaheene, ʉtakurwa muyo kuhika hanʉ ʉkʉmara kʉrɨha isiirɨ yʉʉsi!” ");
INSERT INTO ikz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ribhaga riyo, abhaatʉ bhakabhʉʉrɨra Yɨɨsu, Piraato akiita Abhagariraaya abhandɨ, ribhaga rɨnʉ bhaarɨ bharɨɨtirɨ imitugʉ jabhʉ gɨsɨnzwɨ, gihurukibhwɨ ikimweso kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yɨɨsu akabhabhʉʉrɨra, “Mʉrakina Abhagariraaya bhayo bhakakwabhu kʉ kʉbha bhaarɨ bhʉ ʉbhʉbhɨ kʉkɨra Abhagariraaya abhandɨ bhʉʉsi? ");
INSERT INTO ikz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɨrabhabhʉʉrɨra ɨtarɨbhu! Mʉraatamɨ kutiga ʉbhʉbhɨ bhwanyu na niimwɨ mʉrarika imwʉsi! ");
INSERT INTO ikz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kasha ikumi na bhanaanɨ bharya bhaagwiriirwɨ nɨ ɨkɨkʉngʉ kirya Sirʉamu, mʉrakina ebho nebho bhʉ ʉbhʉbhɨ kʉkɨra abhiikari abhandɨ bhʉʉsi bha Yɨrusarɨɨmu? ");
INSERT INTO ikz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nɨrabhabhʉʉrɨra ɨtarɨbhu! Mʉraatamɨ kutiga ʉbhʉbhɨ bhwanyu, na niimwɨ mʉrarika imwʉsi!” ");
INSERT INTO ikz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Akʉmara Yɨɨsu akabhabhʉʉrɨra abhaatʉ bhayo ekerenjo, akabhuga, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ, akahamba ʉmʉtɨ gu umutiini mʉmʉgʉndʉ gwazɨ. Rusikʉ rʉmwɨ, akaaza komohya imisumʉ, nawe atagibhwɨnɨ. ");
INSERT INTO ikz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Neho akabhʉʉrɨra omohocha waazɨ wa mʉmʉgʉndʉ, ‘Rora! Nɨbhɨɨrɨ nɨraaza komohya imisumʉ kʉmʉtɨ gu umutiini gʉnʉ, kwibhaga ryi imyaka ɨtatʉ, nɨkɨɨrɨ kobhona chʉchʉsi! Nangʉ gʉtɨnɨ, gʉtakaja kʉsarya ɨɨsɨ bhʉʉha!’ ");
INSERT INTO ikz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Nawe, omohocha wuyo akamʉgarukirya, ‘Ʉmʉkʉrʉ, ugutigɨ umwaka gʉnʉ, niguzubhɨrɨ na kogoteera emboreera. ");
INSERT INTO ikz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gʉraatwarɨ imisumʉ ɨrabha bhwaheene, nawe gʉraatamɨ neho ʉgʉtɨnɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Rusikʉ rʉmwɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu aarɨ mwirwazɨrʉ, na aarɨ ariija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Muyo, kwarɨ nʉ ʉmʉkari wʉmwɨ, na aarɨ agwatirwɨ na risambwa kwi imyaka ikumi nɨ ɨnaanɨ. Akiibherereka omogongo, na atanagiryɨ kwimɨɨrɨra bhwɨma. ");
INSERT INTO ikz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hanʉ Yɨɨsu aamʉrʉʉzɨ, akamʉbhɨrɨkɨra, akamʉbhʉʉrɨra, “Yiiya, ubhurwɨrɨ bhwazʉ bhʉhʉriibhwɨ, ʉbhɨɨrɨ bhwaheene!” ");
INSERT INTO ikz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akamʉtʉʉrɨra amabhoko, na rogendo rʉmwɨ akiimɨɨrɨra bhwɨma, akatanga kukumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Urusikʉ rʉnʉ Yɨɨsu aahʉriryɨ ʉmʉʉtʉ rwarɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ, igʉrʉ wa riyo, ʉmʉkangati wa rirwazɨrʉ akiigatana. Akabhabhʉʉrɨra abhaatʉ bhanʉ bhaarɨ mwirwazɨrʉ, “Zinyuma zʉʉsi, zisikʉ zo okokora emeremo ni‑saasabha. Nangʉ! Muuzɨ mʉhʉribhwɨ muzisikʉ ziyo, nawe mʉtaaza kʉhʉribhwa urusikʉ rwʉ ʉbhʉtʉʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nawe Ʉmʉkʉrʉ akamʉgarukirya, “Imwɨ abhabhɨɨhi! Nɨ‑wɨɨwɨ wʉnʉ atahaazɨtazʉra zengʼombe zaazɨ hamwɨ zɨtɨkɨrɨ zaazɨ kurwa mwibhanza, kuzihira kunywa amanzi, yangabha ni‑rusikʉ rwʉ ʉbhʉtʉʉrʉ? ");
INSERT INTO ikz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndora ʉmʉkari wʉnʉ, wi ikishoko cha Abhurahaamu, amarirɨ imyaka ikumi nɨ ɨnaanɨ abhʉhirwɨ na Shɨtaani. Nangʉ wʉʉsi atakwenderwa kwigurirwa urusikʉ rwʉ ʉbhʉtʉʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hanʉ Yɨɨsu aagambirɨ gayo, abhabhisa bhaazɨ bhʉʉsi bhakarora zɨsʉni. Nawe abhandɨ bhakazomerwa bhʉkʉngʼu, igʉrʉ wa amahocha amazʉmu gu ukuruguurya ganʉ Yɨɨsu aarɨ arakora. ");
INSERT INTO ikz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Akʉmara Yɨɨsu akabhuurya, “Ʉbhʉtɨmi bhwa Mungu nɨ‑bhwa teemwakɨ? Nɨrabhutuubhanʼya nakɨ? ");
INSERT INTO ikz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bhutuubhɨɨnɨ ne endetere isuuhu yɨ ɨharadaari, yɨnʉ ʉmʉʉtʉ aahambirɨ mʉmʉgʉndʉ gwazɨ. Endetere yiyo ɨkamera na kʉbha mʉtɨ mʉkʉrʉ, ni ibhinyunyi bhɨhaaza na kwikara kubhisha bhyaku.” ");
INSERT INTO ikz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yɨɨsu akabhuurya naatu, “Nɨrabhutuubhanʼya ʉbhʉtɨmi bhwa Mungu nakɨ? ");
INSERT INTO ikz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bhutuubhɨɨnɨ nu ubhutunduuru bhʉnʉ ʉmʉkari akogega na kʉsanginʼya nu ubhutu bhwɨ ɨnganʉ mʉbhɨgʉzi bhɨtatʉ. Ubhutunduuru bhuyo bhʉragirya ubhutu bhwɨ ɨnganʉ bhwʉsi bhʉtʉndʉʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yɨɨsu aarɨ morogendo kuja Yɨrusarɨɨmu. Mʉnzɨra, aarɨ ariija abhaatʉ bhi imijɨ ɨmɨkʉrʉ ni imisuuhu. ");
INSERT INTO ikz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Rusikʉ rʉmwɨ, ʉmʉʉtʉ akamubhuurya, “Ʉmʉkʉrʉ, abhaatʉ bhanʉ bhakʉsabhurwa, bharabha nɨ‑bharenge?” Yɨɨsu akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mwikongʼeererye kusikɨra kwa kʉhɨtɨra ikisikʉ ikigutɨ. Nɨrabhabhʉʉrɨra kʉbha, bhaaru bharagema kusikɨra, nawe bharatamwa. ");
INSERT INTO ikz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Hanʉ wi inyumba araamarɨ kwigara ikisikʉ, muriimɨɨrɨra igʉtʉ, imwɨ muriimɨɨrɨra na kuhuna ikisikʉ na kubhuga, ‘Tʉrasabha, utwigʉrɨrɨ!’ “Nawe arabhagarukirya, ‘Nɨtabhɨɨzɨ! Na nɨtɨɨzɨ muruuriirɨ hayi!’ ");
INSERT INTO ikz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Niimwɨ mʉrabhuga, ‘Tʉkarya na kunywa hamwɨmwɨ na naawɨ! Na ʉkatwija mʉzɨmbɨri zɨɨtʉ!’ ");
INSERT INTO ikz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Newe arabhabhʉʉrɨra, ‘Nɨmarirɨ kʉbhabhʉʉrɨra, nɨtabhɨɨzɨ na nɨtɨɨzɨ muruurɨ hayi! Murwɨ kwa niinyɨ, imwɨ abhakʉri bha amabhɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Neho mʉkʉrɨra na kokepeha, kʉ kʉbha, mʉrarora Abhurahaamu, Iisaka na Yaakobho, na abharʉʉtɨrɨri bhʉʉsi bharɨ mʉbhʉtɨmi bhwa Mungu, nawe imwɨ mʉrabha mʉrɨkɨɨrwɨ igʉtʉ! ");
INSERT INTO ikz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Abhaatʉ bharaaza kurwa rʉgʉrʉ na nyanza, kurwa maamu na rangɨ, bharyɨ ɨnyangi mʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Mwitegeerere! Abhaatʉ bhaaru bhanʉ bhakusuukwa ribhaga rɨnʉ, bhatakusuukwa ribhaga rɨnʉ rikuuza. Na bhanʉ bhatakusuukwa ribhaga rɨnʉ, bharasuukwa ribhaga rɨnʉ rikuuza.” ");
INSERT INTO ikz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ribhaga riyoriyo, Abhafarisaayo abharebhe bhakatuna Yɨɨsu bhakamʉbhʉʉrɨra, “Nuurwɨ hanʉ, ujɨ ahagero ahandɨ, kʉ kʉbha Heroode areenda kukwita.” ");
INSERT INTO ikz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yɨɨsu akabhagarukirya, “Heroode aangɨ nyamubhwɨ mʉhaari! Mujɨ mʉmʉbhʉʉrɨrɨ, ‘Reero na tabhʉʉri, nɨraheebha amasambwa kurwa kʉbhaatʉ, na kʉbhahorya abharwɨrɨ, nu urusikʉ rwa katatʉ, nɨramara emeremo janɨ gɨnʉ niizirɨ kokora.’ ");
INSERT INTO ikz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na ɨranyenda nengʼehe no orogendo rwanɨ rwu ukuja Yɨrusarɨɨmu reero, tabhʉʉri, na bhasiirya kuhika nihikɨ, kʉ kʉbha ereenderwa abharʉʉtɨrɨri bhʉʉsi bhakwɨrɨ Yɨrusarɨɨmu, ɨtarɨ hagero handɨ! ");
INSERT INTO ikz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Awɨ Yɨrusarɨɨmu, Yɨrusarɨɨmu! Uriita abharʉʉtɨrɨri na kʉbhatema amabhwɨ bhanʉ bhaatumirwɨ kwa niimwɨ. Niigʉmbirɨ manga kaaru kukumɨnga abhaatʉ bhaazʉ, chɨmbu engoko ɨhaakumɨnga ibhizuri bhyayo mʉmapapa, nawe mʉtɨɨndirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mwangarɨrɨ! Nangʉ Mungu aratiga umujɨ gwanyu! Nɨrabhabhʉʉrɨra, mʉtakondora naatu, kuhika hanʉ mukubhuga, ‘Anʉ ʉrʉbhangʉ wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ Mungu!’” ");
INSERT INTO ikz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Rusikʉ rʉmwɨ rwʉ ʉbhʉtʉʉrʉ, Yɨɨsu akaja kurya ibhyakurya yɨɨka wʉ ʉmʉkangati wʉmwɨ wa Abhafarisaayo. Na abhaatʉ bhanʉ bhaarɨ hayo, bhakabha bharamubhuuririrya bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na mʉbhʉtangɨ bhwazɨ hayo, haareho ʉmʉʉtʉ wʉmwɨ, anu ubhurwɨrɨ bhwu kubhimba ʉmʉbhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yɨɨsu akabhabhuurya Abhafarisaayo na abhiija bhi imigirʉ, “Awɨɨ, turiisiriribhwa ni imigirʉ jɨtʉ kohorya abhaatʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ, kisha tʉtakwisiriribhwa?” ");
INSERT INTO ikz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nawe, bhakiikara bhukiri. Yɨɨsu akagwata umurwɨrɨ wuyo, akamohorya, akamʉbhʉʉrɨra ajɨ yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Akʉmara Yɨɨsu akabhabhuurya, “Nɨ‑wɨɨwɨ gatɨ waanyu wʉnʉ umwana waazɨ hamwɨ engʼombe yaazɨ ɨraatʉbhɨrɨ mukisima urusikʉ rwʉ ʉbhʉtʉʉrʉ, ataarɨ aramʉsabhʉramu, nʉʉrʉ arɨɨbhɨ ni‑rusikʉ rwʉ ʉbhʉtʉʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abhaatʉ bhayo, bhataarɨ na ryʉ ʉkʉgamba. ");
INSERT INTO ikz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hanʉ Yɨɨsu aarʉʉzɨ chɨmbu abhagini bhakwitoorera ibhitumbɨ bhye embere, akabhaha ekerenjo. Akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Hanʉ ʉraararikwɨ kubhuryakari, utiikara ahagero ha abhagini, kʉ kʉbha ɨratʉrɨkana araarikirwɨ ʉwʉndɨ ʉmʉkʉrʉ kʉkʉkɨra. ");
INSERT INTO ikz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na wʉnʉ abharaarikirɨ imwɨ araazɨ kʉkʉbhʉʉrɨra, ‘Mutigɨrɨ wʉnʉ umweya.’ Neho ʉraasʉʉkɨ bhʉkʉngʼu, kʉ kʉbha ʉrahatikwa kuja kwikara kumweya gwʉ ʉmʉʉtʉ wi iyaasɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Nawe, hanʉ ʉkʉraarikwa kʉnyangi, nuujɨ wiikarɨ kumweya gwʉ ʉmʉʉtʉ wi iyaasɨ, kʉ kʉbha hanʉ wurya aakʉraarikirɨ akuuza, akʉbhʉʉrɨrɨ, ‘Mʉsaani waanɨ, nauzɨ mʉbhʉtangɨ hanʉ, neho ahazʉmu.’ Hayo ʉrabhona ubhusuuku mʉbhʉtangɨ bhwa abhagini bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wʉwʉʉsi wʉnʉ akwigungya umwene, Mungu aramwicha. Nawe wʉwʉʉsi wʉnʉ akwiyicha, Mungu aramʉgʉnga.” ");
INSERT INTO ikz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yɨɨsu akabhʉʉrɨra wurya aamʉraarikirɨ, “Hanʉ ʉkʉbhatengera abhaatʉ ibhyakurya bhya amiigagʉra hamwɨ bhyʉ ʉkʉrɨɨgɨra, ʉtaraarɨka abhasaani bhaazʉ, hamwɨ bhahiiri bhaazʉ, hamwɨ abhaatʉ bha abhahiiri bhaazʉ, hamwɨ bhanyarʉbhɨri bhaazʉ abhaniibhi. Ʉraakorebhu, bhʉʉsi bharakʉraarɨka ɨwaabhʉ, na ʉrabha ʉrarihwa kʉgarya wabhahɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Nawe, hanʉ ʉraabhakonzere abhaatʉ ɨnyangi, ʉraarɨkɨ abhahabhɨ, abharema, amagata, na abhahʉku. ");
INSERT INTO ikz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Neho ʉraabhone ʉrʉbhangʉ, kʉ kʉbha, ebho bhataana ekegero chʉ ʉkʉkʉrɨha. Nawe Mungu newe araakʉrɨhɨ, hanʉ akuryʉra abhaatʉ bhe heene mʉbhʉtangɨ bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ribhaga riyo umugini wʉmwɨ kwigari akiigwa amangʼana gayo, akabhʉʉrɨra Yɨɨsu, “Arɨ hakɨrɨku, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ araaryɨ ɨnyangi kʉbhʉtɨmi bhwa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nawe Yɨɨsu akamʉgarukirya, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ, wʉnʉ aakʉnzirɨ ɨnyangi kʉrʉ na akaraarɨka abhaatʉ bhaaru. ");
INSERT INTO ikz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ribhaga ryɨ ɨnyangi rɨkahika, akatʉma mbʉʉsa waazɨ kʉbharaarikwa bhʉʉsi, ajɨ abhabhʉʉrɨrɨ, ‘Muuzɨ! Ebhegero bhyʉsi bhɨbhɨɨrɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Nawe, abharaarikwa bhʉʉsi, bhakabha bharasabha kwabhirwa. We embere, akamʉbhʉʉrɨra, ‘Nigurirɨ ʉmʉgʉndʉ, ereenderwa nijɨ kʉgʉrabha, nɨrakʉsabha ʉnyaabhɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ʉwʉndɨ akabhuga, ‘Nigurirɨ zengʼombe ikumi zʉ ʉkʉrɨmɨra, na nangʉ, nɨraja kuziija, nɨrakʉsabha ʉnyaabhɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nʉ ʉwʉndɨ akabhuga, ‘Neho nakwɨra ʉmʉkari, igʉrʉ wa riyo nɨtakʉtʉra kuuza.’ ");
INSERT INTO ikz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Neho mbʉʉsa wuyo akagarʉka, akabhʉʉrɨra ʉmʉkʉrʉ waazɨ gayo gʉʉsi. Ʉmʉkʉrʉ waazɨ akiigatana, akamuswaja mbʉʉsa waazɨ, ‘Nuujɨ bhwangʉ kʉzɨnzɨra zɨkʉrʉ ne ebhebheyo bhyʉ ʉrʉbhɨri rʉnʉ, ʉbhareete abhahabhɨ, abharema, abhahʉku, na amagata.’ ");
INSERT INTO ikz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Akʉmara, mbʉʉsa wuyo akagarʉka, akamʉbhʉʉrɨra, ‘Ʉmʉkʉrʉ, garya wanswajiryɨ nɨgakʉrirɨ. Nʉʉrʉbhu, gʉkɨɨrɨ goreho umweya kʉbhandɨ kwikara.’ ");
INSERT INTO ikz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ʉmʉkʉrʉ akamʉbhʉʉrɨra, ‘Nangʉ! Ujɨ igʉtʉ wʉ ʉrʉbhɨri, kʉzɨnzɨra zɨnʉ zikuja mʉzɨmbɨri na mʉmɨgʉndʉ, ʉbhahatɨkɨ abhaatʉ bhaazɨ bhasikɨrɨ yɨɨka hanʉ, kuhika hiizʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nawe nɨrabhabhʉʉrɨra, bhanʉ bhʉʉsi nabharaarikirɨ, atareeho nʉʉrʉ wʉmwɨ waabhʉ, wʉnʉ araasamɨ ɨnyangi yaanɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yɨɨsu aarɨ arahirana na amaribhita ga abhaatʉ. Akabhiichʉrɨra, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ʉmʉʉtʉ wʉwʉʉsi araazɨ kwa niinyɨ, atakʉtʉra kʉbha umwɨga waanɨ, arɨɨbhɨ akɨɨrɨ kʉnsɨɨga kʉkɨra wiisɨ, unina, ʉmʉkari waazɨ, abhaana bhaazɨ, abhahiiri bhaazɨ, na abhasubhaati bhaazɨ, nʉʉrʉ ewe umwene. ");
INSERT INTO ikz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nʉ ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akɨɨrɨ kogega ʉmʉsarabha gwazɨ antunɨ, atakʉtʉra kʉbha umwɨga waanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wʉmwɨ waanyu areende kwʉmbaka inyumba yɨ ɨkɨkʉngʉ. Ni wɨɨwɨ atakwikara hinga haasɨ na kwiseega riguri rye ebhegero bhɨnʉ araahokerye kuryʉmbaka, atʉrɨ korora arɨɨbhɨ ana zimpirya zu ukwisa kʉmara kwʉmbaka? ");
INSERT INTO ikz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Araatamɨ kokorabhu, aratʉra kwʉmbaka ʉbhʉrʉsa, nawe atamwɨ kʉyɨmariirya. Hanʉ abhaatʉ bharaarore bharamorega, ");
INSERT INTO ikz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bharabhuga, ‘Ʉmʉʉtʉ wʉnʉ akatanga iryʉmbaka, nawe atamirwɨ kʉmariirya inyumba!’ ");
INSERT INTO ikz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nihuruchɨ ekerenjo ɨkɨndɨ. Abhatɨmi bhabhɨrɨ bhakeenda kuja mwihɨ. We embere ana abhasirikarɨ bhɨkwɨ ikumi, ʉwʉndɨ bhɨkwɨ merongo ɨbhɨrɨ. Heene we embere wuyo, araja mwihɨ akɨɨrɨ kwikara na kwiseega arɨɨbhɨ aratʉra kwitana na wa abhasirikarɨ bhɨkwɨ merongo ɨbhɨrɨ? ");
INSERT INTO ikz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Araarore kʉbha aratamwa, rogendo rʉmwɨ arabhatʉma abhahocha bhaazɨ, bhajɨ bhwangʉ kʉmʉtɨmi ʉwʉndɨ akɨɨrɨ kore, bhiigwanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Muyomuyo na niimwɨ, atareeho wʉmwɨ waanyu aratʉra kʉbha umwɨga waanɨ, arɨɨbhɨ akɨɨrɨ kutiga bhyʉsi bhɨnʉ anabhyʉ. ");
INSERT INTO ikz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ʉmʉʉnyʉ, ne‑kegero kɨzʉmu, nawe guriibhuryɨ ʉbhʉsambaruku bhwagwɨ, gʉratuurirwa kɨgʉrʉkɨ korereke gozome naatu? ");
INSERT INTO ikz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ʉmʉʉnyʉ gwe eteemwa yɨnʉ, gʉtakwenderwa mokegero, mobhototo, naabha komboreeya, abhaatʉ bharagorekera. Wʉ ʉkʉtwɨ, iitegeerere.” ");
INSERT INTO ikz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Rusikʉ rʉmwɨ, abharihya bha rigʉʉti na bhʉ ʉbhʉbhɨ, bhaarɨ bhariisukɨra Yɨɨsu, bhamwitegeerere. ");
INSERT INTO ikz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ɨkagirya Abhafarisaayo na abhiija bhi imigirʉ, bhakiibheerya bharabhuga, “Ʉmʉʉtʉ wʉnʉ, ndora arabhaginihya bhʉ ʉbhʉbhɨ! Naatu ararya nabhʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Neho Yɨɨsu akabhaha ekerenjo, akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Awɨɨ, wʉmwɨ waanyu ana zɨngʼʉndu igana rɨmwɨ. Araangʼurɨ ɨyɨmwɨ yaho ibhurirɨ, arakorabhwɨ? Atakuzitiga merongo kenda na kenda mukiriishʉ, na kuja komohya yɨnʉ ibhurirɨ, kuhika ayebhone? ");
INSERT INTO ikz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hanʉ araayebhone, arayegega kʉmabhega kwa bhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hanʉ araahikɨ yɨɨka, arabhabhɨrɨkɨra abhasaani bhaazɨ na bhanyarʉbhɨri na kʉbhabhʉʉrɨra, ‘Tozomerwe hamwɨmwɨ, kʉ kʉbha ɨngʼʉndu yaanɨ yɨnʉ yaabhurirɨ, niyibhwɨnɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Nɨrabhabhʉʉrɨra, muyo nɨmbu kʉraabhɨ no obhozomerwa bhwaru mwisaarʉ, hanʉ ʉmʉkʉri wʉ ʉbhʉbhɨ wʉmwɨ araatigɨ ʉbhʉbhɨ bhwazɨ. Obhozomerwa bhuyo bhʉrabha bhʉkʉrʉ kʉkɨra bhwa abhaatʉ abhazʉmu merongo kenda na kenda bhanʉ bhataana ebhoono yu ukwichʉra. ");
INSERT INTO ikz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mwitegeerere ekerenjo ɨkɨndɨ. Ʉmʉkari wʉmwɨ ana amazenzere ikumi, na araabhuryɨ rɨmwɨ arakorabhwɨ? Atakugwatya ɨkɨmʉrɨ, na kʉtaricha inyumba yʉʉsi na komohya kwa managa kuhika ayebhone? ");
INSERT INTO ikz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hanʉ araayebhone, arabhabhɨrɨkɨra abhasaani bhaazɨ na bhanyarʉbhɨri, na kʉbhabhʉʉrɨra, ‘Tozomerwe hamwɨmwɨ, kʉ kʉbha impirya yaanɨ, yɨnʉ yaabhurirɨ, niyibhwɨnɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Nɨrabhabhʉʉrɨra, nɨmbu Mungu akozomerwa mʉbhʉtangɨ bhwa bhamaraika, igʉrʉ wa wʉ ʉbhʉbhɨ wʉmwɨ araatigɨ ʉbhʉbhɨ bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yɨɨsu akangʼeha kʉgamba, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ, aarɨ na abhaana bhabhɨrɨ bhi ikisubhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Umusuuhu, akabhʉʉrɨra wiisɨ, ‘Bhaabha, ongʼe ɨgabhʉ yaanɨ.’ Wiisɨ akabhasondya ebhegero bhyazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Zɨkahɨta sikʉ suuhu, umusuuhu wuyo akakumɨnga ebhegero bhyazɨ bhyʉsi, akakora orogendo akaja icharʉ cha kore. Hanʉ aahikirɨ iyo, akarya ebhegero bhyazɨ kɨbhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hanʉ aamarirɨ ebhegero bhyazɨ bhyʉsi, ɨnzara ɨhaari ɨkahʉrʉka mucharʉ kirya, akatanga kʉnyaaka. ");
INSERT INTO ikz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Neho akaja kʉmʉʉtʉ wʉmwɨ wa mʉʉsɨ yirya, akamʉsabha abhɨ omohocha waazɨ. Ʉmʉʉtʉ wurya akamʉtʉma mʉmʉgʉndʉ kuriisha zingurubhɨ zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hanʉ zingurubhɨ zaarɨ zɨrarya amakoko, akabha ariigomba wʉʉsi kʉgarya. Nawe atareeho ʉmʉʉtʉ wʉnʉ aamʉhɨɨrɨ chʉchʉsi chu ukurya. ");
INSERT INTO ikz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ɨtɨnɨrʉ, akatanga kobhona amangʼɨɨni, akiigambɨra, ‘Ndora abhahocha bha bhaabha, bhʉʉsi bhararya, kuhika bhariigʉta na kʉsaaja. Nawe inyɨ, nɨrakwa nɨ ɨnzara. ");
INSERT INTO ikz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nɨragarʉka kwa bhaabha na kʉmʉbhʉʉrɨra, “Bhaabha, nɨsariryɨ igʉrʉ wa Mungu, na nɨkʉsaririiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɨtakwenderwa naatu kubhirikirwa umwana waazʉ. Onkore nɨbhɨ wʉmwɨ wa abhahocha bhaazʉ.” ’ ");
INSERT INTO ikz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Akʉmara umumura wuyo, akarwa hayo, akagarʉka kwa wiisɨ. Hanʉ aarɨ akɨɨrɨ kore ni inyumba, wiisɨ akamorora, umwʉyʉ gwazɨ gukiizʉra ɨbhɨgʉngi. Rogendo rʉmwɨ akaryarɨra umwana waazɨ, akamugwɨra kukikubha na kumuhumbata. ");
INSERT INTO ikz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Umumura wuyo, akabhʉʉrɨra wiisɨ, ‘Bhaabha, nɨsariiryɨ Mungu, na nɨkʉsaririiryɨ. Nɨtakwenderwa kubhirikirwa mwana waazʉ naatu.’ ");
INSERT INTO ikz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Nawe, wiisɨ akabhʉʉrɨra abhahocha bhaazɨ, ‘Moreete bhwangʉ, zengebho zɨnzʉmu, mumwibhohyɨ! Mumwibhohyɨ epete kuchara chazɨ, ni ibhikwɨra kʉmagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Moreete ikihiiri ikinuru kirya, mʉsɨnzɨ. Tokore ɨnyangi, tozomerwe hamwɨmwɨ, ");
INSERT INTO ikz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kʉ kʉbha umwana waanɨ, aarɨ abhurirɨ, nawe nangʉ abhʉnɨkirɨ, aarɨ nkina akuurɨ, nawe nangʉ mʉhʉru naatu!’ Neho bhayo bhʉʉsi bhakatanga kozomerwa. ");
INSERT INTO ikz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ribhaga riyo, umwana waazɨ ʉmʉkʉrʉ aarɨ mʉmʉgʉndʉ. Hanʉ aarɨ akʉgarʉka na akwisemera yɨɨka, akiigwa abhaatʉ bharɨɨmba na kubhina. ");
INSERT INTO ikz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akabhɨrɨkɨra omohocha wʉmwɨ, akamubhuurya, ‘Kʉnakɨ?’ ");
INSERT INTO ikz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Akamʉbhʉʉrɨra, ‘Umusuuhu waazʉ iizirɨ, na bhaabha amusinziirɨ ikihiiri ikinuru, kʉ kʉbha amubhwɨnɨ umwana waazɨ, akɨɨrɨ mʉhʉru.’ ");
INSERT INTO ikz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Umwana ʉmʉkʉrʉ akiigatana, akaanga kusikɨra yɨɨka. Wiisɨ akahʉrʉka igʉtʉ, akabha aramwisasaama asikɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nawe, akamʉgarukirya, ‘Itegeerera! Imyaka myaru nɨbhɨɨrɨ nɨrakohokerya, na nɨkɨɨrɨ kutiga kwitegeerera amaragɨrɨra gaazʉ nʉʉrʉ rogendo rʉmwɨ! Nawe, inyɨ ʉkɨɨrɨ kongʼa nʉʉrʉ ekenena chi imburi, nekore ɨnyangi hamwɨmwɨ na abhasaani bhaanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nawe umwana waazʉ wʉnʉ ariirɨ ebhegero bhyazʉ na abhasimbɨ, hanʉ ahikirɨbhu, umusinziirɨ ikihiiri!’ ");
INSERT INTO ikz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wiisɨ akamʉbhʉʉrɨra, ‘Mwana waanɨ, awɨ ʉrɨ hamwɨmwɨ na niinyɨ sikʉ zʉʉsi, ne ebhegero bhyʉsi bhɨnʉ nɨnabhyʉ ni‑bhyazʉ. ");
INSERT INTO ikz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nawe umusuuhu waazʉ, itwɨndirɨ tomokorere ɨnyangi na kozomerwa hamwɨmwɨ, kʉ kʉbha aarɨ abhurirɨ, nawe nangʉ abhʉnɨkirɨ, na aarɨ nkina akuurɨ, nawe nangʉ mʉhʉru!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Kwarɨ nu umuniibhi wʉmwɨ nu umwimiiririri waazɨ. Umwimiiririri wuyo, akagambwa kʉbha aarɨ arasarya ebhegero bhyʉ ʉmʉkʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɨkagirya umuniibhi akabhɨrɨkɨra umwimiiririri waazɨ, akabhuga, ‘Awɨɨ, nɨ‑mangʼanakɨ ganʉ niigwirɨ igʉrʉ waazʉ? Onyeereche endengo na amahocha gaazʉ ge ebhegero bhyanɨ, kʉ kʉbha ʉtakʉtʉra kongʼeha kʉbha umwimiiririri waanɨ!’ ");
INSERT INTO ikz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Umwimiiririri wuyo akiibhuurya, ‘Nekorebhwɨ nangʉ? Ʉmʉkʉrʉ waanɨ aranduusha momeremo. Kʉrɨma nɨtakʉtʉra, na nɨrarora sʉni kʉsabhasabha. ");
INSERT INTO ikz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nangʉ! Nɨraatigibhwɨ emeremo gɨnʉ, nɨramenya ryo okokora, korereke abhaatʉ bhansʉngʼaanɨ yɨɨka waabhʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Neho umwimiiririri akabhɨrɨkɨra abhasiirɨ bhʉʉsi bhʉ ʉmʉkʉrʉ waazɨ, wʉmwɨ wʉmwɨ. Akabhuurya we embere, ‘Isiirɨ yaazʉ kʉmʉkʉrʉ waanɨ ne‑ndengokɨ?’ ");
INSERT INTO ikz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Akamʉgarukirya, ‘Isiirɨ yaanɨ, nɨ‑madaraamu igana ga amaguta gɨ ɨmɨzɨyituuni.’ “Umwimiiririri akabhuga, ‘Gega ripapʉra rɨnʉ, ryandikirwɨ isiirɨ yaazʉ. Ikara hanʉ, ʉrɨkɨranʼyɨ bhwangʉ, yaandɨka merongo ɨtaanʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Akʉmara akabhuurya umusiirɨ ʉwʉndɨ, ‘Awɨ, isiirɨ yaazʉ, ne‑ndengokɨ?’ “Akamʉgarukirya, ‘Magonera igana gɨ ɨnganʉ.’ “Umwimiiririri wurya akabhuga, ‘Gega ripapʉra ryi isiirɨ yaazʉ, yaandɨka bhwangʉ merongo ɨnaanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Neho umuniibhi akakumya umwimiiririri kʉbhʉngʼɨɨni bhwazɨ.” Yɨɨsu akangʼeha kubhuga, “Abhaatʉ bhɨ ɨɨsɨ yɨnʉ bhanʉ ʉbhʉngʼɨɨni bhariihokerya na abhakɨndichazɨ, kʉkɨra abhaatʉ bhu ubhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na niinyɨ nɨrabhabhʉʉrɨra, mohokerye ubhuniibhi bhwɨ ɨɨsɨ yɨnʉ kobhona abhasaani, korereke hanʉ mukusirirwa ebhegero, mʉsʉngʼaanwɨ mubhwikari bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ʉmʉʉtʉ omoronge kʉmangʼana amasuuhu, newe omoronge nʉʉrʉ kʉmakʉrʉ. Ɨbhu nɨmbu, ʉmʉʉtʉ wa amangʼɨɨni kʉmangʼana amasuuhu, newe ʉmʉngʼɨɨni nʉʉrʉ kʉmakʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arɨɨbhɨ ʉtabhɨɨrɨ moronge kohokerya ebhegero bhyɨ ɨɨsɨ yɨnʉ, ɨtakʉtʉrɨkana ʉhaabhwɨ ebhegero bhya amaheene mwisaarʉ! ");
INSERT INTO ikz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Arɨɨbhɨ mʉtabhɨɨrɨ bharonge kʉ kʉbhɨɨka ebhegero bhyʉ ʉwʉndɨ, ɨtakʉtʉrɨkana mʉhaabhwɨ ebhegero bhyanyu imubheene! ");
INSERT INTO ikz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kohokerya abhakʉrʉ bhabhɨrɨ, kʉ kʉbha aratʉra kubhiihirirwa ʉwʉmwɨ na kʉsɨɨga ʉwʉndɨ, hamwɨ kugwatana nʉ ʉwʉmwɨ na korega ʉwʉndɨ. Na niimwɨ, mʉtakʉtʉra kohokerya Mungu ne ebhegero hamwɨmwɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hanʉ Abhafarisaayo bhiigwirɨ amangʼana gayo ga Yɨɨsu, bhakatanga komoseka kwa kerege, kʉ kʉbha bhakasɨɨga bhʉkʉngʼu zimpirya. ");
INSERT INTO ikz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yɨɨsu akabhabhʉʉrɨra, “Imwɨ, muriikorya mʉbhʉtangɨ bhwa abhaatʉ kʉbha mone eheene. Nawe, Mungu amɨnyirɨ amangʼana ganʉ garɨ mozekoro zaanyu. Amangʼana ganʉ abhaatʉ bhahaasɨɨga bhʉkʉngʼu, gariigatanʼya Mungu! ");
INSERT INTO ikz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Imigirʉ ja Musa, na amaandɨkʉ ga abharʉʉtɨrɨri, gaarɨ garatunwa na abhaatʉ kuhika ribhaga rya Yoohana. Kwɨma ribhaga riyo, Ɨngʼana Ɨnzʉmu yʉ ʉbhʉtɨmi bhwa Mungu ɨkabha ɨragambwa, na abhaatʉ bhʉʉsi bhahiisikirya kwa nguru. ");
INSERT INTO ikz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nawe nɨ‑kʉnyʉʉhu bhʉkʉngʼu kwa risaarʉ ni icharʉ kurweho, kʉkɨra kaandɨkʉ kasuuhu ki imigirʉ kuhutwa. ");
INSERT INTO ikz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Umusubhɨ, wʉnʉ akutiga mʉkaazɨ nu ukukwɨra ʉwʉndɨ, arasebheeta. Nu umusubhɨ araakwɨrɨ ʉmʉkari wʉnʉ ahɨɨbhirwɨ nu umusubhɨ waazɨ, arasebheeta. ");
INSERT INTO ikz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kwarɨ nu umuniibhi wʉmwɨ, wʉnʉ aarɨ akokora ɨnyangi kɨrakabhu na kwibhoha amiibhoho amazʉmu ga zambaraawɨ gi guri ikʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na mukisikʉ chu umuniibhi wuyo, haareho nʉ ʉmʉhabhɨ wʉmwɨ, iriina ryazɨ Razaarʉ. Razaarʉ wuyo, ʉmʉbhɨrɨ gwazɨ gwʉsi gwarɨ gwizwirɨ ebhedonda, ");
INSERT INTO ikz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","na zimbwa zaarɨ zɨraaza komeesa ebhedonda bhyazɨ. Hanʉ amasaajʉ gaarɨ gakugwa kurwa kwigari, Razaarʉ akabha ariigomba ahaabhwɨ, kʉ kʉbha aarɨ ariigwa ɨnzara. ");
INSERT INTO ikz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Mmbe ʉmʉhabhɨ Razaarʉ akakwa. Maraika akamuhira haguhɨ na Abhurahaamu. Umuniibhi wʉʉsi akakwa, akabhiikwa. ");
INSERT INTO ikz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hanʉ umuniibhi aarɨ aranyaaka bhʉkʉngʼu nyaari, akanʉnga amɨɨsʉ, akarora Abhurahaamu kwa kore na Razaarʉ haguhɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akamʉbhɨrɨkɨra kwiraka, ‘Bhaabha Abhurahaamu, ondorere ɨbhɨgʉngi! Nɨranyaaka momorero gʉnʉ! Mʉtʉmɨ Razaarʉ aazɨ kwa niinyɨ, akorye esonga yi ichara mʉmanzi, atoonye kʉrʉrɨmɨ rwanɨ korereke ruzirɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nawe, Abhurahaamu akamʉgarukirya, ‘Mwana waanɨ, uhiitɨ kʉbha ʉkabhona amangʼana amazʉmu mubhwikari bhwazʉ, na Razaarʉ, akabhona amabhɨ. Nawe nangʉ, ewe arabhona amazʉmu, na naawɨ ʉranyaaka. ");
INSERT INTO ikz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hamwɨmwɨ na gayo, gatɨ wɨɨtʉ na niimwɨ, kʉtɨɨrwɨhʉ rirʉʉma ikʉrʉ bhʉkʉngʼu, korereke bhanʉ bhakwenda kurwa ɨnʉ kuuza kwa niimwɨ, bhatanaja kwambʉka, na bhanʉ bhakwenda kurwa iyo kuuza kwa niitwɨ, bhatanaja.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Neho umuniibhi akabhuga, ‘Nangʉ bhaabha, nɨrakʉsabha ʉtʉmɨ Razaarʉ ajɨ yɨɨka kwa bhaabha, ");
INSERT INTO ikz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","abhareche abhahiiri bhaanɨ bhataanʉ, bhataaza kuuza ɨnʉ ahagero hɨ ɨnyaakʉ bhʉkʉngʼu.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nawe, Abhurahaamu akamʉgarukirya, ‘Abhahiiri bhaazʉ, bhaana Musa na abharʉʉtɨrɨri, bhabhiitegeerere bhayo!’ ");
INSERT INTO ikz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Umuniibhi akamʉgarukirya, ‘Zɨyi, bhaabha Abhurahaamu! Nawe, ʉmʉʉtʉ araajɨ kwebho kurwa mʉbhaku, bharatiga ʉbhʉbhɨ bhwabhʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abhurahaamu akamʉgarukirya, ‘Abhahiiri bhaazʉ bhayo, bharɨɨtamɨ kwitegeerera Musa na abharʉʉtɨrɨri, bhatakʉdɨɨrɨɨra nʉʉrʉ ʉmʉʉtʉ ariiryʉkɨ kurwa mʉbhaku.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Ibhitimotimo bhɨnʉ bhɨragirya abhaatʉ bhakore ʉbhʉbhɨ, bhɨrabhaho kemerano. Nawe, horeera kʉmʉʉtʉ wʉnʉ araagiryɨ ibhitimotimo bhiyo! ");
INSERT INTO ikz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yangabhɨɨrɨ hakɨrɨku kwewe abhoherwe ʉrʉbhwɨ mwigʉti, na arekerwe mʉnyanza, kʉkɨra kʉhabhya wʉmwɨ wa abhasuuhu akore ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kʉgayo, mwiyangarɨrɨ mʉtaaza kokorabhu! “Arɨɨbhɨ umuhiiri waazʉ araakʉsariiryɨ, omoreche, na araatigɨ ʉbhʉbhɨ bhwazɨ, omobheerere. ");
INSERT INTO ikz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nʉʉrʉ araakʉsariiryɨ manga muhungatɨ kurusikʉ rʉmwɨ, na manga zʉʉsi araaza kʉkʉsabha arabhuga, ‘Nitigirɨ ʉbhʉbhɨ, mbeerera,’ mobheerere!” ");
INSERT INTO ikz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Neho abhatumwa bhayo bhakabhʉʉrɨra Ʉmʉkʉrʉ, “Utwongereere ubhwisirirya bhwɨtʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ʉmʉkʉrʉ akabhagarukirya, “Angabhɨɨrɨ mwarɨ nu ubhwisirirya nche ekerengo che endetere isuuhu yɨ ɨharadaari, mwarɨ mʉrabhʉʉrɨra omoko gʉnʉ, ‘Ihɨka ujɨ omere mʉnyanza,’ gwʉsi gwarɨ gʉrabhiigwa. ");
INSERT INTO ikz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nawe arɨɨbhɨ wʉmwɨ waanyu ana mbʉʉsa wʉnʉ akʉrɨma, hamwɨ arariisha zɨngʼʉndu, mbʉʉsa wuyo araagarʉkɨ yɨɨka, ʉmʉkʉrʉ waazɨ aratʉra kʉmʉbhʉʉrɨra, ‘Rogendo rʉmwɨ, haguhɨ ibhyakurya’? ");
INSERT INTO ikz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Zɨyi! Aramʉbhʉʉrɨra, ‘Ntengera ibhyakurya, ongʼehe kʉnyangarɨra kuhika hanʉ nɨraamarɨ kurya na kunywa. Neho awʉʉsi uryɨ na kunywa.’ ");
INSERT INTO ikz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nangʉ! Mbʉʉsa araakore chɨmbu ʉmʉkʉrʉ waazɨ aamuswajiryɨ, ʉmʉkʉrʉ wuyo aramukumya kʉkʉgakora? Zɨyi! ");
INSERT INTO ikz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Ɨbhu nɨmbu na niimwɨ, mʉraamarɨ kokora gʉʉsi ganʉ mubhuuriirwɨ, mubhugɨ, ‘Itwɨ nɨ‑bhambʉʉsabhu. Tʉkʉrirɨ ganʉ twɨndirwɨ kokora.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hanʉ Yɨɨsu aarɨ araja Yɨrusarɨɨmu, akahɨtɨra gatɨ wi ibhyarʉ bhya Samaariya na Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na hanʉ aasikiirɨ mʉrʉbhɨri rʉmwɨ, akarumana na abhaatʉ ikumi bhe ebhegenge. Bhakiimɨɨrɨra kore neewe, ");
INSERT INTO ikz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakatiirya riraka bharabhuga, “Yɨɨsu, Ʉmʉkʉrʉ, otororere ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yɨɨsu akabharora, akabhabhʉʉrɨra, “Mogende mwiyeerekenʼye kʉbhakuhaani.” Bhakaja, na hanʉ bhaarɨ mʉnzɨra, bhakahʉribhwa. ");
INSERT INTO ikz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hanʉ wʉmwɨ waabhʉ aarʉʉzɨ kʉbha amarirɨ kʉhʉribhwa, rogendo rʉmwɨ akagarʉka kwa Yɨɨsu, akagʉnga Mungu kwiraka ikʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hanʉ aahikirɨ, akiirekera kibhumɨɨrɨ mʉbhʉtangɨ bhwa amagʉrʉ ga Yɨɨsu, akabhuga ʉzʉmiryɨ. Nʉ ʉmʉʉtʉ wuyo, aarɨ Mʉsamaariya. ");
INSERT INTO ikz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yɨɨsu akabhuurya, “Bhatahʉriibhwɨ abhaatʉ ikumi! Nangʉ, abhandɨ kenda bhayo bharɨ hayi? ");
INSERT INTO ikz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bhatareeho abhandɨ bhanʉ bhaagarukirɨ kukumya Mungu, kuruushaku Ʉmʉsamaariya wʉnʉ umwene?” ");
INSERT INTO ikz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Akʉmara Yɨɨsu akamʉbhʉʉrɨra, “Imɨɨrɨra, ujɨ ɨwaazʉ, ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Rusikʉ rʉmwɨ, Abhafarisaayo bhakabhuurya Yɨɨsu, “Ʉbhʉtɨmi bhwa Mungu, bhʉraaza ryʉrɨ?” Yɨɨsu akabhagarukirya, “Ukuuza kwʉ ʉbhʉtɨmi bhwa Mungu, ɨtarɨ ekegero kɨnʉ kɨkʉtʉra kororekana. ");
INSERT INTO ikz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Atareeho wʉnʉ akʉtʉra kubhuga, ‘Morore! Bhʉrɨ hanʉ!’ hamwɨ, ‘Morore bhʉrɨ harya!’ Mwitegeerere, ʉbhʉtɨmi bhwa Mungu bhʉrɨ gatɨ waanyu.” ");
INSERT INTO ikz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Akʉmara, Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, “Kuzisikʉ zɨnʉ zikuuza, muriigomba korora nʉʉrʉ rusikʉ rʉmwɨ rʉnʉ Umwana wʉ Ʉmʉʉtʉ akotema mʉʉsɨ, nawe mʉtakororora. ");
INSERT INTO ikz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abhaatʉ bharaabhabhʉʉrɨrɨ, ‘Morore! Ngurya harya!’ hamwɨ ‘Morore! Ngʉnʉ hanʉ!’ Mʉtarwa hanʉ mʉrɨ na mʉtabharyarɨra. ");
INSERT INTO ikz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gayo nɨbhabhuuriirɨ kʉ kʉbha, hanʉ Umwana wʉ Ʉmʉʉtʉ akʉgarʉka, araaza chɨmbu ʉrʉkʉbha, rʉhaabharya rogendo rʉmwɨ, mbaara zʉʉsi kwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nawe hinga, ereenderwa Umwana wʉ Ʉmʉʉtʉ abhone ɨnyaakʉ nzaru na kwangwa na abhaatʉ bhu urwibhʉrʉ rʉnʉ. ");
INSERT INTO ikz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Chɨmbu gabhɨɨrɨ muzisikʉ za Nuuhu, nɨmbu zɨkʉhʉrʉkɨra zisikʉ zʉ ʉkʉgarʉka ku Umwana wʉ Ʉmʉʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Zisikʉ za Nuuhu, abhaatʉ bhaarɨ bhararya na kunywa, bharakwɨra na kukwɨrwa, kuhika urusikʉ rʉnʉ Nuuhu aasikiirɨ mʉsafina. Riteemo rya amanzi rɨkaaza, rɨkabharicha bhayo bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nɨmbu na kuzisikʉ za Rʉʉti amangʼana gaarɨ kʉbha. Abhaatʉ bhaarɨ bhararya na kunywa, bharagʉra na kugurya, bhararɨma na kʉhamba zimbusurʉ, na bhaarɨ bharʉʉmbaka. ");
INSERT INTO ikz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nawe, urusikʉ rʉnʉ Rʉʉti aaruurɨ Sodoma, omorero ʉmʉhaari nchi imbura nʉ ʉbhʉbhʉrʉgʉtɨ kurwa mwisaarʉ bhɨkabharicha bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nangʉ nɨmbu ɨraabhɨ urusikʉ rʉnʉ Umwana wʉ Ʉmʉʉtʉ ariihumburwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Urusikʉ ruyo, ʉmʉʉtʉ arɨɨbhɨ igʉrʉ kʉkɨsara chi inyumba yaazɨ, ne ebhegero bhyazɨ bhiri munyumba, atiika abhegege, angʼose. Nʉ ʉmʉʉtʉ arɨɨbhɨ mʉmʉgʉndʉ, muryamurya, atiichʉra inyuma kogega chʉchʉsi, angʼose. ");
INSERT INTO ikz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muhiitɨ garya gaabhwɨnɨ ʉmʉkari wa Rʉʉti! ");
INSERT INTO ikz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ʉmʉʉtʉ wʉnʉ akuriibha ʉbhʉhʉru bhwazɨ, newe akubhurimirya. Ʉmʉʉtʉ wʉnʉ akurimirya ʉbhʉhʉru bhwazɨ, arabhuriibha. ");
INSERT INTO ikz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nɨrabhabhʉʉrɨra, ubhutikʉ bhu urusikʉ ruyo, abhaatʉ bhabhɨrɨ bharabha bhahindiirɨ bhʉrɨrɨ bhʉmwɨ, ʉwʉmwɨ Mungu aramogega, nʉ ʉwʉndɨ aramutiga. ");
INSERT INTO ikz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Urusikʉ ruyo, abhakari bhabhɨrɨ bharabha bharasha hamwɨmwɨ, ʉwʉmwɨ Mungu aramogega, nʉ ʉwʉndɨ aramutiga.  ");
INSERT INTO ikz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abhaatʉ bhabhɨrɨ bharabha mʉmʉgʉndʉ, ʉwʉmwɨ Mungu aramogega, nʉ ʉwʉndɨ aramutiga.” ");
INSERT INTO ikz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abhɨɨga bhakamubhuurya, “Ʉmʉkʉrʉ, gayo garakorwa hayi?” Akabhagarukirya, “Ahagero hɨ ɨkɨtʉndʉ, neho zɨmatʉʉnyi zikwibhiringa.” ");
INSERT INTO ikz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ ekerenjo, kobheerecha kʉbha bhareenderwa kʉsabha Mungu sikʉ zʉʉsi, bhatakwa umwʉyʉ. ");
INSERT INTO ikz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akabhabhʉʉrɨra, “Mʉrʉbhɨri rʉmwɨ, haareho na umutiniri wʉmwɨ. Umutiniri wuyo, atʉʉbhahirɨ Mungu, hamwɨ kʉdɨɨrɨɨra mʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mʉrʉbhɨri ruyo, aarɨmu umukwirwa wʉmwɨ. Aarɨ araja kumutiniri wuyo manga kaaru kumwisasaama, arabhuga, ‘Nɨrasabha ombonere eheene gatɨ waanɨ nu umubhisa waanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kwibhaga irɨɨhu umutiniri wuyo akaanga kwibhagɨra umukwirwa wuyo. Nawe, ɨtɨnɨrʉ akiigambɨra mumwʉyʉ gwazɨ, ‘Inyɨ nɨtakwʉbhaha Mungu, na nɨtakʉdɨɨrɨɨra ʉmʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nawe, kʉ kʉbha umukwirwa wʉnʉ aranyaacha bhʉkʉngʼu, nangʉ nɨramoha eheene yaazɨ, korereke ataaza kunihya ku kunyizaku!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Akʉmara, Ʉmʉkʉrʉ akabhuga, “Twɨgɨ bhwaheene ekerenjo chu umutiniri ʉmʉbhɨ wuyo. ");
INSERT INTO ikz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Arɨɨbhɨ nɨmbu, ɨrabhabhwɨ kwa Mungu, atakʉbhasakirya abharobhorwa bhaazɨ bhanʉ bhakʉmʉrɨrɨra umwise nu ubhutikʉ? Heene arakeezera kʉbhasakirya? ");
INSERT INTO ikz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nɨrabhabhʉʉrɨra, arabhaha eheene yaabhʉ bhwangʉ. Nawe, hanʉ Umwana wʉ Ʉmʉʉtʉ araagarʉkɨ mʉʉsɨ, arabhona abhaatʉ bhakɨɨrɨ nu ubhwisirirya?” ");
INSERT INTO ikz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Naatu Yɨɨsu akabhabhʉʉrɨra ekerenjo abhaatʉ abhandɨ, bhanʉ bhaarɨ bhakwirora nebho bhe eheene mʉbhʉtangɨ bhwa Mungu na kʉbharega abhandɨ. Akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kwarɨ na abhaatʉ bhabhɨrɨ, bhanʉ bhaatiirirɨ kuja mwihekaaru kʉsabha Mungu. Wʉmwɨ aarɨ Ʉmʉfarisaayo, nʉ ʉwʉndɨ aarɨ umurihya wa rigʉʉti. ");
INSERT INTO ikz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Neho Ʉmʉfarisaayo akiimɨɨrɨra, akasabha Mungu igʉrʉ wa amangʼana gaazɨ umwene, ‘Mungu, nɨrabhuga ʉzʉmiryɨ, kʉ kʉbha inyɨ nɨtarɨ mʉbhɨ chɨmbu abhandɨ, abhakʉri bha amabhɨ, abhasaakuri bha abhaatʉ bhe ebhegero na abhasɨbhɨɨti, hamwɨ nʉʉrʉ chɨmbu umurihya wa rigʉʉti wuyo. ");
INSERT INTO ikz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Niriiyima kurya manga kabhɨrɨ kunyuma, na nɨrakuhurukirya ikimweso yɨmwɨ yi ikumi ye ebhegero bhyanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nawe umurihya wa rigʉʉti, akasaaga kore hasuuhu. Na atɨɨndirɨ nʉʉrʉ kʉnʉnga amɨɨsʉ gaazɨ mwisaarʉ, akabha ariitematema ikikubha chazɨ, arabhuga, ‘Mungu, ombeerere, inyɨ wʉ ʉbhʉbhɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Akʉmara Yɨɨsu akoongerya amangʼana gayo, “Nɨrabhabhʉʉrɨra, umurihya wa rigʉʉti wuyo akagarʉka yɨɨka, amarirɨ kobheererwa na Mungu. Nawe ʉwʉndɨ wuyo zɨyi! Wʉwʉʉsi wʉnʉ akwigungya umwene, Mungu aramwicha. Nawe wʉwʉʉsi wʉnʉ akwiyicha, Mungu aramʉgʉnga.” ");
INSERT INTO ikz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Rusikʉ rʉmwɨ, abhiibhuri bhaarɨ bharareetera Yɨɨsu abhaana nʉʉrʉ ɨbhɨbhataarɨ, korereke abhatʉʉrɨrɨ amabhoko. Hanʉ abhɨɨga bhaazɨ bhaarʉʉzɨbhu, bhakabhahaarɨra abhaatʉ bhayo. ");
INSERT INTO ikz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nawe, Yɨɨsu akabhabhɨrɨkɨra abhaana bhayo, akabhuga, “Mʉbhatigɨ abhaana abhasuuhu bhaazɨ kwa niinyɨ, mʉtabharecha, kʉ kʉbha ʉbhʉtɨmi bhwa Mungu ni‑bhwa bhanʉ bhaangɨ ncha abhaana. ");
INSERT INTO ikz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nɨrabhabhʉʉrɨra amaheene, wʉwʉʉsi wʉnʉ atakwisirirya ʉbhʉtɨmi bhwa Mungu nchu umwana umusuuhu, atakusikɨra zee mʉbhʉtɨmi bhuyo.” ");
INSERT INTO ikz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Neho ʉmʉkangati wʉmwɨ, akabhuurya Yɨɨsu, “Umwija ʉmʉzʉmu, nekorebhwɨ, korereke nɨgabhɨ ʉbhʉhʉru bhwa kemerano?” ");
INSERT INTO ikz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yɨɨsu akamʉgarukirya, “Kwakɨ ʉrambɨrɨkɨra ʉmʉzʉmu? Atareeho ʉmʉʉtʉ ʉmʉzʉmu, kuruushaku Mungu umwene. ");
INSERT INTO ikz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awɨ, ʉgɨmɨnyirɨ bhwaheene imigirʉ ja Mungu: ‘Ʉtasebheeta, utiita, utiibha, ʉtagobha mʉʉtʉ, ʉsʉʉkɨ wuusʉ na onyoko.’” ");
INSERT INTO ikz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ʉmʉkangati akamʉgarukirya, “Imigirʉ gɨnʉ jʉsi, nigigwatirɨ kwɨma mubhwana bhwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hanʉ Yɨɨsu iigwirɨ gayo, akamʉbhʉʉrɨra, “Oreenderwa kokora ingʼana rɨmwɨ. Nuujɨ uguryɨ ebhegero bhyʉsi bhɨnʉ ʉnabhyʉ, zimpirya ziyo ʉbhahɨ abhahabhɨ, na ʉrabha ni ikibhumbɨkʉ kwa Mungu. Akʉmara uuzɨ untunɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hanʉ ʉmʉkangati wuyo iigwirɨ gayo, akiitiimaata bhʉkʉngʼu, kʉ kʉbha aarɨ muniibhi. ");
INSERT INTO ikz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yɨɨsu akamorora itiimaatirɨ, akabhuga, “Nɨ‑kʉkʉngʼu kumuniibhi, kusikɨra mʉbhʉtɨmi bhwa Mungu! ");
INSERT INTO ikz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nɨ‑kʉnyʉʉhu ɨngamiya kʉhɨta mwibhanga ryi isindanʉ, kʉkɨra umuniibhi kusikɨra mʉbhʉtɨmi bhwa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abhaatʉ bhanʉ bhiigwirɨ gayo, bhakabhuga, “Nangʉ, nɨ‑wɨɨwɨ wʉnʉ akʉtʉra kʉsabhurwa?” ");
INSERT INTO ikz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yɨɨsu akabhabhʉʉrɨra, “Ganʉ gatakʉtʉrɨkana kʉbhaatʉ, kwa Mungu garatʉrɨkana.” ");
INSERT INTO ikz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peetero akabhʉʉrɨra Yɨɨsu, “Rora, itwɨ tʉmarirɨ kutiga ebhegero bhyɨtʉ bhyʉsi, tukutunirɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Neho Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉnʉ atigirɨ inyumba yaazɨ, ʉmʉkari waazɨ, abhahiiri bhaazɨ, abhiibhuri bhaazɨ, abhaana bhaazɨ, igʉrʉ wʉ ʉbhʉtɨmi bhwa Mungu, ");
INSERT INTO ikz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","amaheene arasʉngʼaana maaru bhʉkʉngʼu ribhaga rya nangwɨnʉ kʉkɨra bhɨnʉ aatigirɨ. Na mʉʉsɨ yɨnʉ ikuuza, arabhona ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yɨɨsu akabhagega rusizʉ abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, akabhabhʉʉrɨra, “Rora, tʉraja Yɨrusarɨɨmu. Iyo, gʉʉsi ganʉ abharʉʉtɨrɨri bhaandikirɨ igʉrʉ wu Umwana wʉ Ʉmʉʉtʉ, garakorwa. ");
INSERT INTO ikz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aragwatwa na kuhirwa kʉBharuumi, bharamorega na kʉmʉtʉka, bharamutwɨra amatɨ. ");
INSERT INTO ikz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bharamotema ɨmɨzariti na kumwita, nawe urusikʉ rwa katatʉ, araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nawe amangʼana gayo Yɨɨsu aabhabhuuriirɨ abhɨɨga bhaazɨ, bhataamɨnyirɨ enzobhooro yaku, kʉ kʉbha bhaarɨ bhabhisirwɨ, na bhataamɨnyirɨ aragambɨrakɨ. ");
INSERT INTO ikz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hanʉ Yɨɨsu aarɨ ariisemera mʉrʉbhɨri rwa Yɨriko, rusizʉ wɨ ɨnzɨra, kwarɨ nʉ ʉmʉhʉku wʉmwɨ, wʉnʉ aarɨ ikɨɨrɨ arasabha. ");
INSERT INTO ikz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ʉmʉhʉku wuyo hanʉ iigwirɨ abhaatʉ bhaaru bharahɨta hayo, akabhuurya, “Kʉnakɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakamʉbhʉʉrɨra, “Yɨɨsu wa Nazarɨɨti arahɨta.” ");
INSERT INTO ikz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Rogendo rʉmwɨ, akanʉnga riraka, arabhuga, “Yɨɨsu, Umwana wʉ ʉmʉtɨmi Daudi, ondorere ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abhaatʉ bhanʉ bhaarɨ bhakangatirɨ, bhakamʉhaarɨra akirɨ. Nawe ewe, akoongera riraka arabhɨrɨkɨra, “Umwana wʉ ʉmʉtɨmi Daudi, ndorera ɨbhɨgʉngi!” ");
INSERT INTO ikz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yɨɨsu akiimɨɨrɨra, akaswaja ʉmʉhʉku wuyo areetwe kwewe. Hanʉ aahikirɨ haguhɨ, Yɨɨsu akamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oreenda nekokorerekɨ?” Akabhuga, “Ʉmʉkʉrʉ, nɨrasabha nerore.” ");
INSERT INTO ikz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yɨɨsu akamʉbhʉʉrɨra, “Rora! Ubhwisirirya bhwazʉ bhʉkʉhʉriryɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Rogendo rʉmwɨ, akarora, akatuna Yɨɨsu, arakumya Mungu. Hanʉ abhaatʉ bhʉʉsi bhaarʉʉzɨ gayo, bhakatanga kukumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Neho Yɨɨsu akasikɨra mʉrʉbhɨri rwa Yɨriko, akabha arahɨta kʉzɨnzɨra zʉ ʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mʉrʉbhɨri muyo, kwarɨ nu umuniibhi wʉmwɨ, iriina ryazɨ Zaakayo, aarɨ ʉmʉkʉrʉ wa abharihya bha rigʉʉti. ");
INSERT INTO ikz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aarɨ areenda korora Yɨɨsu nɨ‑mʉʉtʉ wa teemwakɨ, nawe ataaturirɨ komorora, kʉ kʉbha kwarɨ ni iribhita ikʉrʉ rya abhaatʉ, na aarɨ muguhɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kʉgayo akaryara mwega, embere wa riribhita riyo, akatiira kʉmʉtɨ gwo omoko, korereke atʉrɨ korora Yɨɨsu aarɨ arahɨta kʉnzɨra yiyo. ");
INSERT INTO ikz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hanʉ Yɨɨsu aahikirɨ hayo, akarora kʉmʉtɨ igʉrʉ, akamʉbhʉʉrɨra, “Zaakayo, ika bhwangʉ! Ɨranyenda nɨbhɨ umugini yɨɨka waazʉ reero.” ");
INSERT INTO ikz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rogendo rʉmwɨ Zaakayo akiika, akaginihya Yɨɨsu yɨɨka waazɨ kwa bhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hanʉ abhaatʉ bhʉʉsi bhaarʉʉzɨ gayo, bhakatanga kwibheerya, bharabhuga, “Ndora agiirɨ kurya na wʉ ʉbhʉbhɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nawe, Zaakayo akiimɨɨrɨra, akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, itegeerera! Nangʉ ritɨnɨka rye ebhegero bhyanɨ nɨrabhaha abhahabhɨ. Na arɨɨbhɨ niruushiryɨ mʉʉtʉ wʉwʉʉsi, nɨramʉgarukirya manga kane.” ");
INSERT INTO ikz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yɨɨsu akabhuga, “Reero yɨnʉ, ubhutuuribhwa bhuhikirɨ munyumba yɨnʉ. Ʉmʉʉtʉ wʉnʉ wʉʉsi, ni‑wi ikishoko cha Abhurahaamu, ");
INSERT INTO ikz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","kʉ kʉbha Umwana wʉ Ʉmʉʉtʉ izirɨ komohya na kʉsabhʉra abhaatʉ bhanʉ bhabhurirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hanʉ abhaatʉ bhaarɨ bhakɨɨrɨ bhariitegeerera amangʼana gayo, Yɨɨsu akangʼeha kʉbhabhʉʉrɨra ekerenjo kɨmwɨ, kʉ kʉbha aarɨ ariisemera Yɨrusarɨɨmu, na abhaatʉ bhayo bhakakina kʉbha ʉbhʉtɨmi bhwa Mungu bhʉrarorekana ribhaga riyo. ");
INSERT INTO ikz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kʉgayo, akabhabhʉʉrɨra, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ wi ikishoko chɨ ɨkɨtɨmi. Ʉmʉʉtʉ wuyo, akakora orogendo kuja icharʉ cha kore, korereke asʉngʼaanɨ ʉbhʉkʉrʉ bhwʉ ʉkʉbha ʉmʉtɨmi, akʉmara agarʉkɨ kotema mucharʉ chazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Hanʉ aarɨ akɨɨrɨ kuja, akabhabhɨrɨkɨra bhambʉʉsa ikumi gatɨ wa bhambʉʉsa bhaazɨ, akabhaha bhʉʉsi endengo kʉrʉ ya zimpirya za mina, akabhabhʉʉrɨra, ‘Mokore ubhusuruja na zimpirya zɨnʉ kuhika ribhaga nɨraagarʉkɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Nawe abhaatʉ bhi icharʉ chazɨ bhakamwigatanɨra bhʉkʉngʼu ʉmʉʉtʉ wuyo. Bhakatʉma abhaatʉ bhajɨ bhabhabhʉʉrɨrɨ, ‘Tʉtakwenda ʉmʉʉtʉ wʉnʉ, abhɨ mʉtɨmi wɨɨtʉ!’ ");
INSERT INTO ikz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nʉʉrʉbhu, akahaabhwa ʉbhʉkʉrʉ bhwʉ ʉbhʉtɨmi. Akʉmara akagarʉka, akabhabhɨrɨkɨra bhambʉʉsa bhanʉ aahɨɨrɨ zimpirya, korereke bhambʉʉsa bhʉʉsi bhabhʉʉrɨrɨ ʉmʉtɨmi abhwɨnɨ bhwerakɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Mbʉʉsa we embere akahika, akamʉbhʉʉrɨra, ‘Ʉmʉkʉrʉ, kuzimpirya zɨnʉ wantigiirɨ, nibhwɨnɨ omoheero manga ikumi.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ʉmʉtɨmi wuyo akamʉbhʉʉrɨra, ‘Mbʉʉsa waanɨ ʉmʉzʉmu, ʉkʉrirɨ bhwaheene! Kʉ kʉbha waarɨ moheene kʉmahocha amasuuhu, nɨrakoha ʉbhʉkʉrʉ igʉrʉ wi imijɨ ikumi.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Mbʉʉsa wa kabhɨrɨ wʉʉsi akahika, akamʉbhʉʉrɨra, ‘Ʉmʉkʉrʉ, kuzimpirya zɨnʉ wantigiirɨ, nibhwɨnɨ omoheero manga kataanʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ʉmʉtɨmi akamʉbhʉʉrɨra, ‘Na naawɨ, nɨrakoha ʉbhʉkʉrʉ igʉrʉ wi imijɨ ɨtaanʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mbʉʉsa ʉwʉndɨ akahika, akabhuga, ‘Ʉmʉkʉrʉ, zimpirya zaazʉ nzɨnʉ hanʉ. Nɨkazibhisa mʉkɨtambaara, korereke zɨtabhʉra. ");
INSERT INTO ikz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɨkakorabhu kʉ kʉbha nɨkakwʉbhaha, awɨ nɨ‑mʉʉtʉ mʉhaari. Ʉhaagega bhɨnʉ ʉtatɨɨrɨ, na ʉhaagesa bhɨnʉ ʉtahambirɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ʉmʉtɨmi akamʉbhʉʉrɨra, ‘Awɨ, nɨ‑mbʉʉsa mʉbhɨ! Nangʉ nɨrakʉtɨnɨra kʉrɨngʼaana na amangʼana gaazʉ aumwene. Ʉkabhuga wɨɨzɨ inyɨ nɨ‑mʉʉtʉ mʉhaari, nɨhaagega bhɨnʉ nɨtatɨɨrɨ, na nɨhaagesa bhɨnʉ nɨtaahambirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Angabhɨɨrɨ nɨmbu nɨrɨ, kwakɨ ʉtantɨɨrɨɨrɨ zimpirya zaanɨ kʉbhasuruja, korereke hanʉ naarɨ nɨkʉgarʉka ɨwaanɨ, naarɨ nɨragega nzaru kʉkɨraho?’ ");
INSERT INTO ikz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Rogendo rʉmwɨ, akabhabhʉʉrɨra abhaatʉ bhanʉ bhaarɨ bhiimiiriirɨ hayo, ‘Gega zimpirya za wuyo, momohe wʉnʉ abhwɨnɨ omoheero manga ikumi.’ ");
INSERT INTO ikz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Bhakamʉbhʉʉrɨra, ‘Nawe ʉmʉkʉrʉ, wʉnʉ amarirɨ kobhona omoheero gwa manga ikumi!’ ");
INSERT INTO ikz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Akabhuga, ‘Nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akokorera emeremo rɨnʉ nɨmʉhɨɨrɨ, nɨramwongereerera. Nawe ʉmʉʉtʉ wʉwʉʉsi wʉnʉ atakokora emeremo amasuuhu ganʉ nɨmʉhɨɨrɨ, nʉʉrʉ ikisuuhu kɨnʉ anachʉ, nɨramuruusha. ");
INSERT INTO ikz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hamwɨmwɨ na gayo, abhabhisa bhaanɨ bhanʉ bhatɨɨndirɨ inyɨ nɨbhɨ ʉmʉtɨmi waabhʉ, mʉbhareete hanʉ, mubhiitɨ mʉbhʉtangɨ bhwanɨ!’ ” ");
INSERT INTO ikz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo, akakangatɨra riribhita kuja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hanʉ iisɨmɨɨrɨ mʉzɨmbɨri za Bhɨtifagɨ na Bhɨtaniya, kʉkɨgʉrʉ kɨnʉ kikubhirikirwa Ɨmɨzɨyituuni, akabhatʉma abhɨɨga bhaazɨ bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Akabhabhʉʉrɨra, “Mujɨ mʉrʉbhɨri rʉnʉ rore embere waanyu. Hanʉ mʉraasikɨra muyo, mʉrabhona umwana wɨ ɨtɨkɨrɨ abhʉhirwɨ wʉnʉ akɨɨrɨ kogega mʉʉtʉ. Mʉmʉtazʉrɨ, momoreete hanʉ. ");
INSERT INTO ikz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ʉmʉʉtʉ wʉwʉʉsi araabhabhuuryɨ, ‘Ndora mʉramʉtazʉra?’ Mʉmʉbhʉʉrɨrɨ, ‘Ʉmʉkʉrʉ wɨɨtʉ aramwenda.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Akʉmara, abhɨɨga bhayo bhakaja, bhakabhona bhyʉsi bhyarɨ chɨmbu Yɨɨsu aabhabhuuriirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hanʉ bhaarɨ bharatazʉra umwana wɨ ɨtɨkɨrɨ, abheene bhakabhuurya, “Ndora mʉratazʉra umwana wɨ ɨtɨkɨrɨ wuyo?” ");
INSERT INTO ikz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhakabhabhʉʉrɨra, “Ʉmʉkʉrʉ aramwenda.” ");
INSERT INTO ikz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhakahirɨra Yɨɨsu, bhakaara zengebho zaabhʉ igʉrʉ waazɨ, bhakatiirya Yɨɨsu kʉtɨkɨrɨ akaja. ");
INSERT INTO ikz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hanʉ Yɨɨsu aarɨ araja, abhaatʉ bhakabha bharaara zengebho zaabhʉ kʉnzɨra kwa kʉmʉsʉʉka. ");
INSERT INTO ikz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na hanʉ iisɨmɨɨrɨ umuhiringitʉ gwɨ ɨkɨgʉrʉ chɨ Ɨmɨzɨyituuni, riribhita ryʉsi rya bhɨɨga bhaazɨ bhakatanga kukumya Mungu kwa bhozomerwa, igʉrʉ wɨ ɨbhɨsɨgʉ bhyʉsi bhɨnʉ bhaarʉʉzɨ. Bhakatiirya amaraka gaabhʉ, ");
INSERT INTO ikz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","bharabhuga, “Anʉ ʉrʉbhangʉ ʉmʉtɨmi wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ! Kʉbhɨ no omorembe gatɨ wa Mungu na abhaatʉ bhaazɨ! Tʉrakumya Mungu wa mwisaarʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kwiribhita riyo, bhaarɨmu Abhafarisaayo. Bhakabhʉʉrɨra Yɨɨsu, “Umwija, ʉbhakiryɨ abhɨɨga bhaazʉ!” ");
INSERT INTO ikz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra, bhanʉ bharaakirɨ, amabhwɨ garatiirya riraka!” ");
INSERT INTO ikz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hanʉ Yɨɨsu iisɨmɨɨrɨ ʉrʉbhɨri rwa Yɨrusarɨɨmu na kororora, akarʉrɨrɨra. ");
INSERT INTO ikz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akabhuga, “Angabhɨɨrɨ omenye reero nʉʉrʉ amangʼana ganʉ gakoreeta omorembe! Nawe nangʉ gabhisirwɨ ʉtakʉtʉra kʉgarora. ");
INSERT INTO ikz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kuzisikʉ zɨnʉ zikuuza, abhabhisa bhaazʉ bhariinaarya inyiki, bhatʉrɨ kʉbhanyahaara mbaara zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Akʉmara, bharakuricha awɨ na abhaatʉ bhaazʉ bhʉʉsi. Rɨtareeho ibhwɨ rɨnʉ rɨkʉsaaga igʉrʉ wɨ ɨrɨndɨ, kʉ kʉbha ʉtaamɨnyirɨ ribhaga rɨnʉ Mungu akuuza kʉkʉsabhʉra!” ");
INSERT INTO ikz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yɨɨsu akasikɨra mwihekaaru, akatanga koheebha abhaatʉ bhanʉ bhaarɨ bhakugurya ebhegero muyo. ");
INSERT INTO ikz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akabhabhʉʉrɨra, “Yandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Inyumba yaanɨ, ɨrabha inyumba ya amasabhi.’ Nawe imwɨ, mʉyɨkʉrirɨ kʉbha ribhigi rya abhasaakuri.” ");
INSERT INTO ikz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sikʉ zʉʉsi, Yɨɨsu aarɨ arabhiija abhaatʉ mwihekaaru. Abhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ na abhakaruka bha Abhayaahudi, bhaarɨ bharamohya ɨnzɨra yu ukumwita, ");
INSERT INTO ikz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nawe bhatabhwɨnɨ umweya, kʉ kʉbha abhaatʉ bhʉʉsi bhaarɨ bhariitegeerera amangʼana gaazɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Rusikʉ rʉmwɨ Yɨɨsu aarɨ mwihekaaru ariija abhaatʉ igʉrʉ wɨ Ɨngʼana Ɨnzʉmu ya Mungu. Neho abhakʉrʉ bha abhakuhaani, abhiija bhi imigirʉ, na abhakaruka bha Abhayaahudi bhakamwizɨra, ");
INSERT INTO ikz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bhakamubhuurya, “Ganʉ okokora, ʉrakora kwa bhʉnajakɨ? Nɨ‑wɨɨwɨ akʉhɨɨrɨ ʉbhʉnaja bhʉnʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Akabhabhʉʉrɨra, “Na niinyɨ nɨrabhabhuurya ringʼana rɨmwɨ. Mʉmbʉʉrɨrɨ, ");
INSERT INTO ikz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ʉbhʉnaja bhwa Yoohana bhwʉ ʉkʉbhatiiza bhʉkarwa kwa Mungu kisha kʉbhaatʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bhakiibhuurya abheene kobheene bharabhuga, “Tʉraabhugɨ, ‘Bhʉkarwa mwisaarʉ,’ aratubhuurya, ‘Ndora mʉtamwisiriiryɨ?’ ");
INSERT INTO ikz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tʉraabhugɨ, ‘Bhʉkarwa kʉbhaatʉ,’ abhaatʉ bhʉʉsi bharatotema amabhwɨ, kʉ kʉbha bhʉʉsi bhariisirirya kʉbha Yoohana aarɨ ʉmʉrʉʉtɨrɨri.” ");
INSERT INTO ikz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Akʉmara, bhakamʉgarukirya, “Tʉtɨɨzɨ ʉbhʉnaja bhwazɨ bhʉkarwa hayi.” ");
INSERT INTO ikz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yɨɨsu akabhabhʉʉrɨra, “Na niinyɨ nɨtakʉbhabhʉʉrɨra nɨrakora amangʼana ganʉ kwa bhʉnajakɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yɨɨsu akangʼeha kʉbhʉʉrɨra abhaatʉ ekerenjo. Akabhuga, “Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ, wʉnʉ aahambirɨ ɨmɨzabhiibhu mʉmʉgʉndʉ gwazɨ, akakʉʉdishirya abharimi. Ewe akaja icharʉ ɨkɨndɨ, akamara iyo sikʉ nzaru. ");
INSERT INTO ikz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na hanʉ zisikʉ zo okogesa zaahikirɨ, akatʉma mbʉʉsa waazɨ kʉbharimi bhayo, korereke bhamohe ribhaara ryazɨ ryi ibhyakurya, agarʉkɨ naryʉ kʉmʉkʉrʉ waazɨ. Nawe, hanʉ mbʉʉsa aahikirɨ, abharimi bhayo bhakamotema na bhakamoheebha mabhoko bhʉʉha. ");
INSERT INTO ikz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Wʉ ʉmʉgʉndʉ, akatʉma mbʉʉsa ʉwʉndɨ. Nawe wʉʉsi bhakamotema na komokora kɨbhɨ bhʉkʉngʼu, akʉmara bhakamoheebha mabhoko bhʉʉha. ");
INSERT INTO ikz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akatʉma mbʉʉsa wa katatʉ. Wuyo wʉʉsi bhakamʉnyahaara, bhakamoheebha. ");
INSERT INTO ikz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ɨtɨnɨrʉ, wʉ ʉmʉgʉndʉ akabhuga, ‘Nangʉ, nekorebhwɨ? Orogendo rʉnʉ, nɨratʉma umwana waanɨ ʉmʉsɨɨgwa, hamwɨ ewe bharamʉsʉʉka.’ ");
INSERT INTO ikz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nawe, hanʉ abharimi bharya bhaamʉrʉʉzɨ, bhakarwaza abheene kobheene bharabhuga, ‘Wʉnʉ newe ʉmʉgabhi wʉ ʉmʉgʉndʉ gʉnʉ. Tumwitɨ, korereke ɨgabhʉ yaazɨ ɨbhɨ iyɨɨtʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhakamuhurucha igʉtʉ wʉ ʉmʉgʉndʉ, bhakamwita.” Neho Yɨɨsu akabhabhuurya, “Nangʉ, wʉ ʉmʉgʉndʉ arabhakorabhwɨ abharimi bhayo? ");
INSERT INTO ikz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Araaza na kubhiita abharimi bhayo, na kʉbhaha abharimi abhandɨ ʉmʉgʉndʉ guyo!” Hanʉ abhaatʉ bhiigwirɨ amangʼana gayo, bhakabhuga, “Gayo gatakʉtʉrɨkana ze!” ");
INSERT INTO ikz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yɨɨsu akabhakandikija amɨɨsʉ, akabhabhuurya, “Nangʉ! Amaandɨkʉ ganʉ gana nzobhoorokɨ? ‘Riibhwɨ rɨnʉ abhʉʉmbaki bhaangirɨ, neryo rɨbhɨɨrɨ riibhwɨ rikʉrʉ rya rusizʉ.’ ");
INSERT INTO ikz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akʉbha agwiriirɨ riibhwɨ riyo, arabhunɨkabhunɨka. Na wʉwʉʉsi wʉnʉ riibhwɨ riyo rɨraamugwɨrɨ, rɨramusha bhoseeseka.” ");
INSERT INTO ikz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abhiija bhi imigirʉ bhayo na abhakʉrʉ bha abhakuhaani, bhakamenya kʉbha, ekerenjo kiyo nebho kɨkʉgambɨra. Bhakeenda kumugwata hayohayo, nawe bhakʉʉbhaha riribhita rya abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kʉgayo, abhakʉrʉ bha Abhayaahudi, bhakabha bharabhuuririrya Yɨɨsu. Bhakatʉma abhaatʉ bhanʉ bhiikʉriryɨ nɨ‑bha amaheene korereke bhagwatyɨ Yɨɨsu kʉmangʼana ganʉ akʉgamba, na kumuhira kumwanangwa wi Ikiruumi. ");
INSERT INTO ikz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nangʉ, abhaatʉ bhayo bhakamubhuurya, “Umwija, tʉmɨnyirɨ ʉragamba na kutwija amaragɨrɨra ga amaheene. Ʉtakʉdɨɨrɨɨra ʉbhʉnaja bhwʉ ʉmʉʉtʉ, nawe uriija kwa bhʉʉsi, ɨnzɨra ya Mungu ku kutuna eheene. ");
INSERT INTO ikz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kʉrɨngʼaana ni imigirʉ ja Musa, toreenderwa kʉrɨha rigʉʉti kwa Kaisaari, kisha zɨyi?” ");
INSERT INTO ikz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nawe Yɨɨsu akamenya omotego gwabhʉ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Monyeereche rizenzere. Ipicha yɨnʉ ni iriina rɨnʉ, ni‑bhya wɨɨwɨ?” Bhakamʉbhʉʉrɨra, “Nɨ‑bhya Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yɨɨsu akabhabhʉʉrɨra, “Nangʉ, bhya Kaisaari, mohe Kaisaari, na bhya Mungu, mohe Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rigarukirya riyo, rɨkabharuguurya bhʉkʉngʼu, rɨkagirya bhakirɨ. Bhakatamwa kʉmʉhaatya kʉmangʼana ganʉ aagambirɨ mʉbhʉtangɨ bhwa abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Akʉmara Abhasadukaayo bhanʉ bhahaabhuga abhaku bhatakuryʉka, bhakaaza kwa Yɨɨsu. Bhakabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Umwija, mumigirʉ Musa akatwandɨkɨra kʉbha, arɨɨbhɨ ʉmʉʉtʉ akuurɨ, na atigirɨ ʉmʉkari waazɨ ataana umwana, umuhiiri waazɨ agabhɨ umukwirwa wuyo, amwibhʉrɨrɨ abhaana umwabhʉ wʉnʉ akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mmbe, bhaareho abhahiiri muhungatɨ bhanʉ bhiibhwirwɨ ɨnda yɨmwɨ. Umwana we embere akakwɨra ʉmʉkari, akakwa aarɨ akɨɨrɨ kwibhʉra mwana. ");
INSERT INTO ikz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Umunyi waazɨ wa kabhɨrɨ, akagabha umukwirwa wuyo, akʉmara akakwa, atamwibhwiryɨ umwana. ");
INSERT INTO ikz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wa katatʉ wʉʉsi akamʉgabha, akakwa. Ɨkabhabhu kwa bhʉʉsi muhungatɨ, bhakakwɨra ʉmʉkari wuyo, bhakakwa bhakɨɨrɨ kumwibhurya abhaana. ");
INSERT INTO ikz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɨtɨnɨrʉ, ʉmʉkari wuyo wʉʉsi akakwa. ");
INSERT INTO ikz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mmbe tʉbhʉʉrɨrɨ, urusikʉ rʉnʉ rʉkʉgambwa kʉbha abhaatʉ bhʉʉsi bhararyʉka, umukwirwa wuyo arabha mʉka wɨɨwɨ? Muhungatɨ bhayo bhʉʉsi bhaarɨ bhamukwɨrirɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yɨɨsu akabhabhʉʉrɨra, “Abhaatʉ bha ribhaga rɨnʉ bharakwɨra na kukwɨrwa. ");
INSERT INTO ikz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nawe, bhanʉ Mungu arʉʉzɨ bhareenderwa kuryukurwa mʉbhaku na kwikara kʉʉsɨ iihya, bhayo bhatakukwɨra naabha kukwɨrwa. ");
INSERT INTO ikz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na bhatakʉtʉra kukwa naatu, kʉ kʉbha bharabha chɨmbu bhamaraika. Bharabha abhaana bha Mungu, kʉ kʉbha bharyukwirwɨ mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Nʉʉrʉ Musa akahiitya abhaatʉ kʉbha abhaku bhararyʉka mʉmaandɨkʉ ganʉ aandikirɨ igʉrʉ wi ikitutuuna kɨnʉ chakirɨ omorero, akabhuga kʉbha Ʉmʉkʉrʉ Mungu ‘Newe Mungu wa Abhurahaamu, Iisaka na Yaakobho.’ ");
INSERT INTO ikz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kʉgayo, nʉʉrʉ bhatatʉ bhayo bhaarɨ bhakuurɨ sikʉ nzaru, Mungu akabhuga ebho nɨ‑bhahʉru kwewe! Abhaku na abhahʉru, bhʉʉsi nɨ‑bhahʉru mʉmɨɨsʉ gaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Abhiija abhandɨ bhi imigirʉ bhakabhuga, “Umwija, ʉgambirɨ bhwaheene!” ");
INSERT INTO ikz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kwɨma ribhaga riyo, bhakʉʉbhaha kubhuurya Yɨɨsu amabhuurya agandɨ. ");
INSERT INTO ikz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nawe, Yɨɨsu akabhabhuurya abhiija bhayo, “Kwakɨ abhaatʉ bhahaabhuga, Kiriisitʉ ni‑mwana wʉ ʉmʉtɨmi Daudi? ");
INSERT INTO ikz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi umwene, mʉkɨtabhʉ cha Zabhuri, akabhuga, ‘Ʉmʉkʉrʉ Mungu akabhʉʉrɨra Ʉmʉkʉrʉ waanɨ, “Ikara ʉrʉbhaara rwanɨ rwu ubhuryʉ, ");
INSERT INTO ikz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuhika hanʉ nɨkʉtʉʉra abhabhisa bhaazʉ iyaasɨ wa amagʉrʉ gaazʉ.” ’ ");
INSERT INTO ikz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Arɨɨbhɨ Daudi arabhɨrɨkɨra Kiriisitʉ, ‘Ʉmʉkʉrʉ,’ nangʉ Kiriisitʉ aratʉrabhwɨ kʉbha umwana waazɨ naatu?” ");
INSERT INTO ikz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hanʉ abhaatʉ bha riribhita bhaarɨ bhariitegeerera, Yɨɨsu akabhabhʉʉrɨra abhɨɨga bhaazɨ, ");
INSERT INTO ikz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mwiyangarɨrɨ na abhiija bhi imigirʉ ja Musa. Bhanʉ bhasɨɨgirɨ kogenda kʉnzɨra bhiibhʉhirɨ zɨkanzʉ zaabhʉ na kʉkɨɨribhwa kubhusuuku mometeera. Na mʉmarwazɨrʉ, bhahaasɨɨga kwikara kubhitumbɨ bhye embere. Na arɨɨbhɨ bharaarikirwɨ kʉzɨnyangi, bhahaasɨɨga kwikara hanʉ abhakangati bhiikɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bhahaaruusha abhakwirwa ebhegero bhyabhʉ. Na bhariikorya nɨ‑bhaatʉ bhagʉrʉrʉku kʉ kʉsabha amasabhi marɨɨhu bhʉkʉngʼu korereke bhiiyeerekenʼye kwa abhaatʉ. Kurusikʉ rwɨ ɨtɨnɨrʉ, abhaatʉ bhayo bharahaabhwa ɨtɨnɨrʉ kʉrʉ bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hanʉ Yɨɨsu aarɨ mwihekaaru, akabharora abhaniibhi bharatʉʉra ikimweso chabhʉ mokegero chu ukuhurukirya ikimweso. ");
INSERT INTO ikz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naatu akarora umukwirwa wʉmwɨ ʉmʉhabhɨ, aratʉʉra amazenzere abhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yɨɨsu akabhuga, “Nɨrabhabhʉʉrɨra nɨ‑maheene, umukwirwa ʉmʉhabhɨ wʉnʉ, newe ahurukiryɨ zimpirya nzaru kʉkɨra bhʉʉsi bhanʉ bhahurukiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nɨrabhugabhu, kʉ kʉbha bhanʉ bhʉʉsi bhahurukiryɨ, ikimweso kɨnʉ bhahurukiryɨ, nɨ‑hagero hasuuhu he ebhegero bhyabhʉ ibhyaru. Nawe umukwirwa wʉnʉ ʉmʉhabhɨ, ahurukiryɨ bhyʉsi bhɨnʉ aarɨ anabhyʉ mubhwikari bhwazɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abhɨɨga abhandɨ, bhaarɨ bharagambɨra rihekaaru, chɨmbu ryarɨ rɨkʉnzirwɨ na amabhwɨ amazʉmu, ne ebhegero bhya riguri ryi igʉrʉ bhɨnʉ abhaatʉ bhaahurukiiryɨ Mungu. Nawe Yɨɨsu akabhuga, ");
INSERT INTO ikz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ganʉ gʉʉsi mokorora nangwɨnʉ, ribhaga rɨrahika hanʉ rɨtareeho nʉʉrʉ riibhwɨ rɨnʉ rɨkʉsaaga igʉrʉ wɨ ɨrɨndɨ. Gʉʉsi garasaribhwa!” ");
INSERT INTO ikz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abhaatʉ bhayo bhakamubhuurya, “Umwija, amangʼana gayo garahʉrʉka ryʉrɨ? Na ni‑chɨrɨkɨnʼyʉkɨ kɨnʉ kiriitwereche kʉbha garaariirɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Akabhabhʉʉrɨra, “Mwangarɨrɨ, ʉmʉʉtʉ wʉwʉʉsi ataaza kʉbhakangirirya! Abhaatʉ bhaaru bharaaza kuriina ryanɨ, bharabhuga, ‘Inyɨ ni‑Kiriisitʉ.’ Naatu, bharabhuga, ‘Ribhaga rirya rɨraariirɨ!’ Nawe mʉtabhatuna! ");
INSERT INTO ikz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na hanʉ muriigwɨ ɨngʼana ya riihɨ nɨ ɨnyaakʉ, mʉtʉʉbhaha, kʉ kʉbha gayo gareenderwa gakorwe hinga, nawe ɨtɨnɨrʉ yɨ ɨɨsɨ ɨrabha ɨkɨɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yɨɨsu akabhabhʉʉrɨra, “Icharʉ kɨmwɨ kiriitana nɨ ɨkɨndɨ, nʉ ʉbhʉtɨmi bhʉmwɨ bhuriitana nʉ ʉbhʉndɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kʉrabhaho ibhirigitʉ bhɨkʉrʉ bhyɨ ɨɨsɨ, na ahagero ahandɨ ɨnzara haari na amarwɨrɨ amabhɨ bhʉkʉngʼu. Na kurwa mwisaarʉ kʉrabha ni ichɨrɨkɨnʼyʉ kɨkʉrʉ, na abhaatʉ bhararora ɨbhɨsɨgʉ bhɨnʉ bhɨkʉbhakanga bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nawe, gayo gʉʉsi gakɨɨrɨ kokorwa, bharabhahira mʉmarwazɨrʉ na kʉbhabhoha mokebhoho na kʉbhanyaacha. Mʉrahirwa mʉbhʉtangɨ bhwa abhatɨmi na abhakangati, igʉrʉ wi riina ryanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Neho mʉraabhone umweya gwʉ ʉkʉgamba igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Nawe mʉtʉʉbhaha kwa kwiseega, nɨkɨ mʉraagambɨ ɨtɨnɨrʉ ɨkɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inyɨ, nɨrabhaha ubhwʉbhʉʉri, na amangʼana ganʉ mʉraagambɨ, kuhika abhabhisa bhaanyu bhanʉ bharaatʉrɨ kwanga hamwɨ kʉhakaana. ");
INSERT INTO ikz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ribhaga ryu ukuhurukibhwa kwa abhatɨmi, bharabhiichʉra nʉʉrʉ abhiibhuri bhaanyu, abhahiiri bhaanyu, abhaatʉ bhi ikishoko chanyu na abhasaani bhaanyu. Na abhamwɨ muriitwa. ");
INSERT INTO ikz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abhaatʉ bhʉʉsi bharabhabhiihirirwa igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nawe, rʉtakʉbhʉra nʉʉrʉ uruzwɨrɨ rʉmwɨ kumitwɨ janyu! ");
INSERT INTO ikz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na muriigumiriryɨ, ubhwikari bhwanyu bhʉrasabhurwa. ");
INSERT INTO ikz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hanʉ mʉraarore ʉrʉbhɨri rwa Yɨrusarɨɨmu rwinaarirwɨ na amaribhita ga abhasirikarɨ, momenye kʉbha ribhaga ryʉ ʉkʉsaribhwa rɨraariirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ribhaga riyo bhanʉ bharɨ Yudeya, bhangʼosere mʉbhɨgʉrʉ. Bhanʉ bharɨ mʉrʉbhɨri rwa Yɨrusarɨɨmu, bharwɨmu bhwangʉ, na bhanʉ bharɨ mʉmɨgʉndʉ, bhatagarʉka mʉrʉbhɨri. ");
INSERT INTO ikz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Zisikʉ ziyo zɨrabha zɨ ɨnyaakʉ, korereke amangʼana gʉʉsi ganʉ gaandikirwɨ gahikɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tʉrabharorera ɨbhɨgʉngi abhakari bhanʉ bharɨnda na bhanʉ bhakʉbha bharakoocha zisikʉ ziyo. Ɨrabha bhʉkʉngʼu, kʉ kʉbha mucharʉ kiyo, kʉrabha nɨ ɨnyaakʉ haari, naatu ɨtɨnɨrʉ ya Mungu ɨraaza kʉbhaatʉ bhi icharʉ kiyo. ");
INSERT INTO ikz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abhaatʉ abhandɨ, bhariitwa kwa risabha, na abhandɨ, bharagwatwa na kuhirwa mubhyarʉ ɨbhɨndɨ bhyʉsi. Nʉ ʉrʉbhɨri rwa Yɨrusarɨɨmu, abhaatʉ bhi ibhyarʉ ɨbhɨndɨ bhararʉtaza, kuhika zisikʉ zaabhʉ zɨraasirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kʉrabhaho ichɨrɨkɨnʼyʉ kuryʉbha, umwɨri, na zenzota. Na mʉʉsɨ hanʉ, abhaatʉ bha mubhyarʉ bharabha nɨ ɨnyaakʉ nu ubhwʉbha kʉ kʉbha ya amakunda maaru ganʉ gakuruma mʉnyanza. ");
INSERT INTO ikz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abhaatʉ bharaseezeka igʉrʉ wu ubhwʉbha, kʉ kʉbha bhararɨndɨɨra amangʼana amabhɨ ganʉ garaabhone ɨɨsɨ, kʉ kʉbha ebhegero bhyʉsi bhya mwisaarʉ bhɨrasingisa. ");
INSERT INTO ikz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Ribhaga riyo, neho abhaatʉ bharaarore Umwana wʉ Ʉmʉʉtʉ, araaza mʉmasaarʉ na zinguru nʉ ʉbhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gayo gʉʉsi, hanʉ gakʉtanga kokorwa, mwimɨɨrɨrɨ kandikija, kʉ kʉbha ribhaga ryʉ ʉkʉsabhurwa kwanyu rɨraariirɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Akʉmara, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ ekerenjo, arabhuga, “Morore ʉmʉtɨ gwu umutiini nɨ ɨmɨtɨ ɨgɨndɨ jʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hanʉ mʉraarore kʉbha gɨtangirɨ kʉsɨbhʉka amatʉʉtʉ, rogendo rʉmwɨ mʉramenya kʉbha ribhaga rya rigesa rɨrariirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Ɨbhuɨbhu, hanʉ mʉraarore gayo gʉʉsi gatangirɨ, momenye kʉbha ʉbhʉtɨmi bhwa Mungu bhʉraariirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nɨrabhabhʉʉrɨra amaheene, ribhaga ryu urwibhʉrʉ rʉnʉ rɨtakʉhɨta kuhika gayo gʉʉsi gakorwe. ");
INSERT INTO ikz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Risaarʉ nɨ ɨɨsɨ bhɨrahɨta, nawe ɨngʼana yaanɨ ɨtakʉhɨta kemerano. ");
INSERT INTO ikz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mwiyangarɨrɨ, mʉtaaza kuhizwa ne esebheeto, ubhunywi nu ubhwʉbha bhu ubhwikari. Mʉbhɨ bhwaheene, kʉ kʉbha urusikʉ rwɨ ɨtɨnɨrʉ rʉraaza mʉtɨɨzɨ. ");
INSERT INTO ikz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nɨmbu rukuuza kʉbhaatʉ bhʉʉsi bha kʉʉsɨ! ");
INSERT INTO ikz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kʉgayo, mʉbhɨ mɨɨsʉ ibhaga ryʉsi! Mongʼehe kʉsabha Mungu mʉnajɨ kugiisiza gʉʉsi ganʉ gakʉhʉrʉka, na kwimɨɨrɨra mʉbhʉtangɨ bhu Umwana wʉ Ʉmʉʉtʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kuzisikʉ ziyo umwise, Yɨɨsu aarɨ ariija abhaatʉ mwihekaaru nu ubhutikʉ aarɨ araja mʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. ");
INSERT INTO ikz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sikʉ zʉʉsi, abhaatʉ bhʉʉsi bhahaaja ritabhʉʉri rya ziri mwihekaaru kumwitegeerera. ");
INSERT INTO ikz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru ɨkabha ɨrɨ haguhɨ yɨnʉ ikubhirikirwa Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abhakʉrʉ bha abhakuhaani, hamwɨmwɨ na abhiija bhi imigirʉ, bhaarɨ bharamohya ɨnzɨra yu ukwita Yɨɨsu, nawe bhakabha bharʉʉbhaha abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Neho Shɨtaani akasikɨra Yuuda, wʉnʉ akubhirikirwa Isikariyʉʉti, wʉmwɨ wa abhɨɨga bha Yɨɨsu ikumi na bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Akaja kʉbhakʉrʉ bha abhakuhaani, na kʉbhakʉrʉ bha abhariibhi bha rihekaaru, akarwaza nabhʉ chɨmbu arɨɨbhagwatyɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bhakazomerwa bhʉkʉngʼu, bhakiisirirya komoha zimpirya. ");
INSERT INTO ikz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuuda akiisirirya, akatanga komohya umweya gu ukwichʉra Yɨɨsu, hanʉ abhaatʉ bhatarɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Urusikʉ rwi isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru rʉkahika, nerwe ɨbhɨngʼʉndu bhyɨ Ɨpasaka bhɨhaasinzwa. ");
INSERT INTO ikz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Neho Yɨɨsu akatʉma Peetero na Yoohana, akabhabhʉʉrɨra, “Mujɨ motokonzere ibhyakurya bhyɨ Ɨpasaka, tuuzɨ turyɨ hamwɨmwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhakabhuurya “Oreenda tokokorere hayi?” ");
INSERT INTO ikz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akabhagarukirya, “Mwitegeerere, hanʉ mukusikɨra mʉrʉbhɨri, mʉrarumana nu umusubhɨ wʉmwɨ, agɨgirɨ inywa. Mumutunɨ kuhika munyumba yɨnʉ araasikɨrɨ, ");
INSERT INTO ikz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mʉmʉbhʉʉrɨrɨ wi inyumba, ‘Umwija arasabha utwereche ɨgatɨ hanʉ araarɨɨrɨ Ɨpasaka hamwɨmwɨ na abhɨɨga bhaazɨ. ’ ");
INSERT INTO ikz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hayo, arabhahira mogorofa, arabheerecha ɨgatɨ, muyo mʉrabhona ebhegero bhyʉsi bhirimu. Mototengere muyo, tʉrɨɨrɨ Ɨpasaka.” ");
INSERT INTO ikz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Abhɨɨga bhakiigwa amangʼana gayo, bhakahʉrʉka bhakaja, bhakabhona gʉʉsi, chɨmbu Yɨɨsu aabhabhuuriirɨ, bhakatenga ibhyakurya bhyɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ribhaga ryu ukurya rɨkahika, Yɨɨsu akiikara kurya ibhyakurya hamwɨmwɨ na abhatumwa bhaazɨ ikumi na bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akabhabhʉʉrɨra, “Niigʉmbirɨ bhʉkʉngʼu kurya ibhyakurya bhyɨ Ɨpasaka, hamwɨmwɨ na niimwɨ nɨkɨɨrɨ kʉnyahaarwa. ");
INSERT INTO ikz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɨrabhabhʉʉrɨra, nɨtakurya naatu ibhyakurya bhɨnʉ, kuhika gʉʉsi gakorwe mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yɨɨsu akagega ekekombe, akabhʉʉrɨra Mungu, azʉmiryɨ. Akabhaha, akabhuga, “Mogege idivaayi yɨnʉ, munywɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nɨrabhabhʉʉrɨra, nɨtakunywa naatu idivaayi, kuhika ʉbhʉtɨmi bhwa Mungu bhʉraazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Akʉmara Yɨɨsu akagega ʉmʉkaatɨ, akabhʉʉrɨra Mungu, azʉmiryɨ, akagusunyura, akabhaha abhɨɨga bhaazɨ, akabhabhʉʉrɨra, “Gʉnʉ negwe ʉmʉbhɨrɨ gwanɨ gʉnʉ gukuhurukibhwa igʉrʉ waanyu. Mʉbhɨ mʉrakorabhu, ku kunhiita.” ");
INSERT INTO ikz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yɨɨsu akagega naatu ekekombe kirya, akabhuga, “Idivaayi yɨnʉ ni‑chɨrɨkɨnʼyʉ chʉ ʉbhʉragɨ ubhuhya bhwa amasaahɨ gaanɨ ganʉ gakwitɨka igʉrʉ waanyu. ");
INSERT INTO ikz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nawe, ʉmʉkɨndichanyu aranyiichʉra, na wʉnʉ akunyiichʉra tʉrakorya nawe kɨbhakuri kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maheene Umwana wʉ Ʉmʉʉtʉ araja kwitwa, chɨmbu ubhwɨndi bhwa Mungu bhʉrɨ, nawe horeera wʉnʉ akumwichʉra!” ");
INSERT INTO ikz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hayo, abhɨɨga bha Yɨɨsu bhakatanga kwibhuurya, wɨɨwɨ gatɨ waabhʉ wʉnʉ areekore gayo. ");
INSERT INTO ikz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kʉkahʉrʉka zɨhaka gatɨ wa abhɨɨga bha Yɨɨsu, kʉbha wɨɨwɨ gatɨ waabhʉ wʉnʉ akwiseegerwa kʉbha ʉmʉkʉrʉ kʉkɨra abhakɨndichazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yɨɨsu akabhabhʉʉrɨra, “Abhatɨmi bhanʉ bhatɨɨzɨ Mungu, bhahaakangata abhaatʉ kwa nguru na bharabhirikirwa kʉbha, nɨ‑bhasakirya. ");
INSERT INTO ikz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Nawe imwɨ mʉtabhabhu, gatɨ waanyu ʉmʉʉtʉ arɨɨbhɨ mʉkʉrʉ kʉkɨra abhandɨ, abhɨ chu umusuuhu, nʉ ʉmʉtɨmi abhɨ ncho omohocha. ");
INSERT INTO ikz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mmbe! Wahɨ nɨ‑mʉkʉrʉ bhʉkʉngʼu? Umwikari wa mwigari kurya, kisha ʉmʉtɨngi wi ibhyakurya? Atarɨ umwikari wa mwigari kurya? Nawe, inyɨ nɨrɨ gatɨ waanyu nangɨ ʉmʉtɨngi.” ");
INSERT INTO ikz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Hanʉ naarɨ nɨnɨ ɨnyaakʉ, imwɨ mwarɨ hamwɨmwɨ na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nangʉ, nɨrabhakora mʉbhɨ abhatɨmi mʉbhʉtɨmi bhwanɨ, chɨmbu Bhaabha aamarirɨ kongʼa ʉbhʉnaja bhuyo. ");
INSERT INTO ikz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mʉrarya nu ukunywa hamwɨmwɨ na niinyɨ, muriikara kubhitumbɨ bhyɨ ɨkɨtɨmi ikumi na bhɨbhɨrɨ, ɨnʉ mʉratɨnɨra ɨbhɨgambʉ ikumi na bhɨbhɨrɨ bhya Iziraɨri.” ");
INSERT INTO ikz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yɨɨsu akabhuga, “Simʉʉni, Simʉʉni! Itegeerera, Shɨtaani amarirɨ kwisiriribhwa kʉbhagema imwʉsi, arabhaseesa chɨmbu abhaatʉ bhakoseesa ɨnganʉ. ");
INSERT INTO ikz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nawe, nɨmarirɨ kʉkʉsabhɨra kwa Mungu, ʉtaaza kʉtamwa mubhwisirirya bhwazʉ. Nawe ʉraangarʉkɨrɨ, ʉbhahɨ zinguru abhakɨndichazʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Akamʉgarukirya, “Ʉmʉkʉrʉ wɨɨtʉ, inyɨ nisiriiryɨ kuja kobhohwa hamwɨmwɨ na naawɨ, nʉʉrʉ kwitwa!” ");
INSERT INTO ikz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yɨɨsu akamʉgarukirya, “Peetero, amaheene nɨrakʉbhʉʉrɨra, reero ekorokoome ɨkɨɨrɨ kʉgamba, ʉrabha ʉnyangirɨ manga katatʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Akʉmara Yɨɨsu akabhuurya abhɨɨga bhaazɨ, “Hanʉ nabhatumirɨ mʉtaarɨ na kɨgʉzi cha mpirya, ɨsakwa naabha ibhikwɨra, mʉkasuuhirwa na kegero chʉchʉsi?” Bhakamʉgarukirya, “Zɨyi.” ");
INSERT INTO ikz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yɨɨsu akabhabhʉʉrɨra, “Nawe nangʉ, wɨ ɨkɨgʉzi cha zimpirya agege, na wɨ ɨsakwa, agege, na wʉnʉ ataana risabha, aguryɨ ɨkabhuuti yaazɨ, korereke agʉrɨ risabha. ");
INSERT INTO ikz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mokorebhu kʉ kʉbha ribhaga rɨraariirɨ, amangʼana ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu gakorwe, kʉbha ‘Akabharwa hamwɨmwɨ na abhakʉri bha amabhɨ.’ Amaheene amangʼana ganʉ gaandikirwɨ igʉrʉ waanɨ gareenderwa gakorwe.” ");
INSERT INTO ikz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhakamʉbhʉʉrɨra, “Ʉmʉkʉrʉ! Rora! Hanʉ gareho amasabha abhɨrɨ.” Akabhuga, “Yiisirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ribhaga riyo Yɨɨsu akarwa hayo, akaja kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni chɨmbu amanarʉ gaazɨ, na abhɨɨga bhaazɨ bhakamutuna. ");
INSERT INTO ikz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akahika kʉkɨgʉrʉ kiyo akabhabhʉʉrɨra, “Mʉsabhɨ Mungu mʉtaaza kusikɨra mubhitiimotiimo.” ");
INSERT INTO ikz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Akabhatiga hayo, akiisuka embere hasuuhu, chɨmbu obhokore bhwʉ ʉkʉtaasha riibhwɨ, akahigama akasabha Mungu, ");
INSERT INTO ikz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bhaabha! Arɨɨbhɨ ʉsɨɨgirɨ, nɨrakʉsabha unduushiryɨ ekekombe chɨ ɨnyaakʉ kɨnʉ. Ɨtarɨ chɨmbu inyɨ nikwenda, nawe gakorwe chɨmbu awɨ ukwenda.”  ");
INSERT INTO ikz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hayo, maraika kurwa mwisaarʉ akahʉrʉkɨra Yɨɨsu, akamoha zinguru. ");
INSERT INTO ikz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yɨɨsu akabha nʉ ʉbhʉsʉngʉ bhʉhaari bhʉkʉngʼu, akangʼeha kʉsabha Mungu. Ɨkɨtʉgʉta chazɨ, kɨkatoonya haasɨ kituubhɨɨnɨ na amasaahɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hanʉ aamarirɨ kʉsabha, akiimɨɨrɨra, akagarʉkɨra abhɨɨga bhaazɨ, akabhona bhahindiirɨ kʉ kʉbha bhaarɨ bharumikirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akabhabhuurya, “Heene! Kwakɨ muhindiirɨ? Mʉbhʉʉkɨ mʉsabhɨ, mʉtaaza kusikɨra mubhitiimotiimo.” ");
INSERT INTO ikz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hanʉ Yɨɨsu akɨɨrɨ aragamba gayo, akiizirwa na abhaatʉ bhaaru, bhakangatiibhwɨ na Yuuda, wʉmwɨ wa abhɨɨga bhaazɨ ikumi na bhabhɨrɨ. Neho Yuuda akiisukɨra Yɨɨsu korereke amokeerye kwa kumuhumbata. ");
INSERT INTO ikz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yɨɨsu akamubhuurya, “Yuuda, heene, uriichʉra Umwana wʉ Ʉmʉʉtʉ kwa kumuhumbata?” ");
INSERT INTO ikz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hanʉ abhɨɨga bha Yɨɨsu bhaarʉʉzɨ gayo, bhakamubhuurya, “Ʉmʉkʉrʉ, tʉbhangʼere na risabha?” ");
INSERT INTO ikz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hayohayo, wʉmwɨ waabhʉ, akatɨna ʉkʉtwɨ ku ubhuryʉ kwa mbʉʉsa wa kuhaani ʉmʉkʉrʉ kutu. ");
INSERT INTO ikz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yɨɨsu akabhuga, “Mutigɨ! Yɨnʉ yiisirɨ.” Akakunʼyaku ʉkʉtwɨ kwa mbʉʉsa wuyo, akamohorya. ");
INSERT INTO ikz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yɨɨsu akabhuurya abhaatʉ bhanʉ bhiizirɨ kumugwata, abhakʉrʉ bha abhakuhaani, abhakʉrʉ bha abhariibhi bha rihekaaru, hamwɨmwɨ na abhakaruka bha Abhayaahudi, “Ndora mwizirɨ na amasabha na amarungu kungwata, nkina inyɨ nɨ‑mʉsaakuri? ");
INSERT INTO ikz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Zisikʉ zʉʉsi naarɨ hamwɨmwɨ na niimwɨ mwihekaaru, nawe mʉtaangwatirɨ! Nawe, nangʉ ni‑ribhaga ryanyu nʉ ʉbhʉkangati bhwi ikiirimya.” ");
INSERT INTO ikz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Neho abhaatʉ bhayo bhakagwata Yɨɨsu, bhakaja nawe kuhika munyumba ya kuhaani ʉmʉkʉrʉ. Peetero aarɨ aratuna Yɨɨsu kwa kore. ");
INSERT INTO ikz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hanʉ bhaahikirɨ kʉrʉbhʉʉga rwi inyumba omorero gʉkaakibhwa, bhakiikara. Peetero wʉʉsi, akaaza kwikara rusizʉ waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Omohocha wʉmwɨ wɨ ɨkɨkari akamomogorera, akabhuga, “Ʉmʉʉtʉ wʉnʉ, aarɨ hamwɨmwɨ na Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nawe Peetero akaanga, “Awɨ ʉmʉkari! Nɨtamwɨzɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hasuuhu, ʉmʉʉtʉ wʉndɨ akarora Peetero, akamʉbhʉʉrɨra, “Na naawɨ nɨ‑mʉkɨndichabhʉ.” Nawe Peetero akamʉgarukirya, “Awɨ musubhɨ! Ʉrantuubhanʼya!” ");
INSERT INTO ikz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Rɨkahɨta ibhaga ryɨ ɨsa yɨmwɨ, ʉmʉʉtʉ wʉndɨ akakandikija kʉgamba, “Maheene, ʉmʉʉtʉ wʉnʉ aarɨ hamwɨmwɨ na Yɨɨsu, ndora ewe wʉʉsi nɨ‑Mʉgariraaya!” ");
INSERT INTO ikz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nawe Peetero akagarukirya, “Awɨ musubhɨ! Nɨtɨɨzɨ gayo ʉkʉgamba.” Akɨɨrɨ achagamba gayo, rogendo rʉmwɨ ekorokoome ɨkagamba. ");
INSERT INTO ikz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ʉmʉkʉrʉ akiichʉra, akarora Peetero, hayohayo Peetero akahiita amangʼana ganʉ Yɨɨsu aamubhuuriirɨ, “Reero, ekorokoome ɨkɨɨrɨ kʉgamba, ʉrabha ʉnyangirɨ manga katatʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peetero akahʉrʉka igʉtʉ, akatanga kʉrɨra kwi isʉngʉ ihaari. ");
INSERT INTO ikz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Akʉmara abhasubhɨ bhanʉ bhaarɨ bhakuriibha Yɨɨsu, bhakabha bharamʉkaara. Hamwɨmwɨ na gayo, bhakamotema bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakamuribha amɨɨsʉ, bharamʉbhʉʉrɨra, “Rootorera, nɨ‑wɨɨwɨ wʉnʉ akʉtɨmirɨ?” ");
INSERT INTO ikz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bhakabha bharamuhuruchirya amangʼana agandɨ maaru gʉ ʉkʉmʉtʉka. ");
INSERT INTO ikz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bhʉkacha, bhakakora ikiikarʉ cha abhakaruka bha Abhayaahudi, abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ. Yɨɨsu akareetwa muchandarʉ chabhʉ, bhakamubhuurya, ");
INSERT INTO ikz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Arɨɨbhɨ awɨ naawɨ Kiriisitʉ, tʉbhʉʉrɨrɨ.” Akabhagarukirya, “Nʉʉrʉ nɨraabhabhʉʉrɨrɨ, mʉtakwisirirya, ");
INSERT INTO ikz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na nɨrabhabhuuryɨ, mʉtakʉngarukirya. ");
INSERT INTO ikz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nawe kwɨma nangʉ, Umwana wʉ Ʉmʉʉtʉ arabha ikɨɨrɨ ʉrʉbhaara rwu ubhuryʉ rwa Mungu wa zinguru.” ");
INSERT INTO ikz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhʉʉsi bhakamubhuurya, “Heene awɨ ni‑Mwana wa Mungu?” Yɨɨsu akabhagarukirya, “Ndora imubheene mʉmarirɨ kʉgamba kʉbha inyɨ newe!” ");
INSERT INTO ikz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Rogendo rʉmwɨ, abhakʉrʉ bhayo bhakabhuga, “Nɨ‑bhamenyeekereryakɨ bhanʉ tukwenda? Itwɨ tʉmarirɨ kwigwa amangʼana ganʉ agambirɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Akʉmara, abhakʉrʉ bhʉʉsi bha Abhayaahudi bhakiimɨɨrɨra, bhakahira Yɨɨsu kwa Piraato. ");
INSERT INTO ikz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhakatanga kʉmʉgamba kwa bhʉhaari, bharabhuga, “Tʉrʉʉzɨ ʉmʉʉtʉ wʉnʉ, ararimirya icharʉ chɨtʉ, kwa kʉbharecha abhaatʉ bhatarɨha rigʉʉti kwa Kaisaari. Akʉmara arabhuga kʉbha ewe newe Kiriisitʉ, ʉmʉtɨmi.” ");
INSERT INTO ikz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Neho Piraato akabhuurya Yɨɨsu, “Awɨ naawɨ ʉmʉtɨmi wa Abhayaahudi?” Akabhuga, “Awɨ ʉgambirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Piraato akabhʉʉrɨra abhakʉrʉ bha abhakuhaani, hamwɨmwɨ na riribhita rya abhaatʉ, “Ʉmʉʉtʉ wʉnʉ, rɨtareeho isoro ryʉryʉsi rɨnʉ nɨrʉʉzɨ kwawe.” ");
INSERT INTO ikz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abhaatʉ bhayo, bhakakandikija kʉgamba, “Ndora amaragɨrɨra gaazɨ, garareeta rirɨgɨ kʉbhaatʉ bha mucharʉ chʉsi cha Yudeya! Akatangɨra Gariraaya, na amarirɨ kʉganyaraganʼya kuhika hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piraato akagiigwa gayo, akabhuurya, “Ʉmʉʉtʉ wʉnʉ nɨ‑Mʉgariraaya?” ");
INSERT INTO ikz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hanʉ aamɨnyirɨ ewe nɨ‑Mʉgariraaya wʉ ʉbhʉtɨmi bhwa Heroode, akamʉtʉma kwawe kʉ kʉbha, zisikʉ ziyo Heroode wʉʉsi aarɨ Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hanʉ Heroode aarʉʉzɨ Yɨɨsu, akazomerwa bhʉkʉngʼu, kʉ kʉbha akiigwa amangʼana gaazɨ kwa sikʉ nzaru. Akabha areenda korora ɨkɨsɨgʉ kɨnʉ Yɨɨsu akokora. ");
INSERT INTO ikz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroode akabhuurya amangʼana maaru, nawe Yɨɨsu atamʉgarukiiryɨ ingʼana. ");
INSERT INTO ikz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abhakʉrʉ bha abhakuhaani na abhiija bhi imigirʉ, bhakahɨta embere kʉgamba Yɨɨsu kwa bhʉhaari. ");
INSERT INTO ikz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroode wʉʉsi na abhasirikarɨ bhaazɨ bhakatanga komorega, bhakamoseka, bhakamwibhohya zengebho zɨnzʉmu. Akʉmara bhakamʉgarucha kwa Piraato. ");
INSERT INTO ikz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kwɨma urusikʉ ruyo, Heroode na Piraato bhakabha bhasaani, nʉʉrʉ bhaarɨ bhatakwigwana. ");
INSERT INTO ikz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Akʉmara, Piraato akabhiringa abhakʉrʉ bha abhakuhaani, abhiimiiririri bha Abhayaahudi, hamwɨmwɨ na abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akabhabhʉʉrɨra, “Heene! Mʉndɨɨtɨɨrɨ ʉmʉʉtʉ wʉnʉ, mʉrabhuga arasiigirirya abhaatʉ. Momenye bhwaheene nɨmarirɨ kumubhuurya mʉbhʉtangɨ bhwanyu. Kʉmagamba gaanyu gʉʉsi, rɨtareeho ingʼana ryʉryʉsi rɨnʉ nɨrʉʉzɨ kwawe. ");
INSERT INTO ikz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroode wʉʉsi, atarʉʉzɨ isoro kwawe. Necho amʉgarukiryɨ kwa niitwɨ. Momenye bhwaheene kʉbha ʉmʉʉtʉ wʉnʉ, rɨtareeho isoro rɨnʉ akʉrirɨ, rɨnʉ rekokora iitwɨ! ");
INSERT INTO ikz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nangʉ nɨramotema zihimbʉ, akʉmara nimutigʉrʉkɨrɨ.”  ");
INSERT INTO ikz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ribhaga ryɨ Ɨpasaka, Piraato akeenderwa atigʉrʉkɨrɨ omobhohwa wʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Abhaatʉ bhayo bhʉʉsi, bhakarɨgɨsa kwa hamwɨmwɨ bharabhuga, “Zɨyi! Muruushɨho wʉnʉ, ʉtʉtazʉrɨrɨ Bharaabha!” ");
INSERT INTO ikz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na Bharaabha akabhohwa mokebhoho kʉ kʉbha akareeta rirɨgɨ ryaru mʉrʉbhɨri na kwita. ");
INSERT INTO ikz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piraato akeenda kutigʉrʉka Yɨɨsu, naatu akagambana nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nawe, bhakangʼeha kʉrɨgɨsa, “Mʉmʉbhambɨ kʉmʉsarabha, mʉmʉbhambɨ kʉmʉsarabha!” ");
INSERT INTO ikz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Akagamba nabhʉ rwa katatʉ, “Asariryɨkɨ? Ndora rɨtareeho isoro rɨnʉ nɨrʉʉzɨ kwawe rikugirya iitwɨ! Nangʉ nɨramotema zihimbʉ, akʉmara nimutigʉrʉkɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nawe, abhaatʉ bhayo bhakangʼeha kʉrɨgɨsa bhʉkʉngʼu kʉbha Yɨɨsu abhambwɨ kʉmʉsarabha. Ɨtɨnɨrʉ, rirɨgɨ ryabhʉ rɨkahiza. ");
INSERT INTO ikz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Neho Piraato akabhiisiririrya Abhayaahudi bhayo kokora chɨmbu bhakwenda. ");
INSERT INTO ikz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akatazʉra ʉmʉsarya wʉnʉ aarɨ abhʉhirwɨ, igʉrʉ wo okoreeta rirɨgɨ ryaru na kwita. Akabhaha Yɨɨsu, korereke bhamokore chɨmbu bhakwenda. ");
INSERT INTO ikz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hanʉ abhasirikarɨ bhaarɨ bharahira Yɨɨsu kumwita, bhakarumana nʉ ʉmʉʉtʉ wʉmwɨ, iriina ryazɨ Simʉʉni, wʉ ʉrʉbhɨri rwa Kireene, ararwa mʉmʉgʉndʉ. Bhakamugwata kwa nguru, bhakamoseserya ʉmʉsarabha, akabha ararwa Yɨɨsu inyuma. ");
INSERT INTO ikz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Abhaatʉ bhaaru bhakatuna Yɨɨsu, gatɨ waabhʉ, abhakari bhaarɨ bharamʉrɨrɨra kwi isʉngʉ ihaari. ");
INSERT INTO ikz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yɨɨsu akabhiichʉrɨra akabhabhʉʉrɨra, “Imwɨ abhakari bha Yɨrusarɨɨmu, mʉtandɨrɨra! Nawe mwirɨrɨrɨ imubheene na abhaana bhaanyu. ");
INSERT INTO ikz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kʉ kʉbha kuzisikʉ zɨnʉ zikuuza abhaatʉ bharabhuga, hakɨrɨku abhakari abhagʉmba, na bhanʉ bhatakʉchiryɨ abhaana. ");
INSERT INTO ikz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Akʉmara, neho bharaabhugɨ, ‘Ɨbhɨgʉrʉ mutugwɨrɨ, nɨ ɨhɨgʉrʉ mutubhumbikiryɨ.’ ");
INSERT INTO ikz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Arɨɨbhɨ ganʉ garakorwa kʉmʉtɨ ʉmʉbhɨsɨ, ɨrabhabhwɨ kʉmʉtɨ umwʉmu?” ");
INSERT INTO ikz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ribhaga riyo, abhasirikarɨ bhakahira Yɨɨsu na abhasarya bhabhɨrɨ kwitwa. ");
INSERT INTO ikz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bhakahika ahagero hanʉ haabhirikiirwɨ Ɨkɨhanga chu Umutwɨ, bhakamʉbhamba kʉmʉsarabha, na abhasarya bhayo, ʉwʉmwɨ ʉrʉbhaara rwazɨ rwu ubhuryʉ, nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yɨɨsu akabhuga, “Bhaabha! Ʉbhabheerere, kʉ kʉbha bhatɨɨzɨ rɨnʉ bhakokora.” Na bhakatwana amiibhoho gaazɨ kwa kokora ubhwitʉʉri. ");
INSERT INTO ikz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abhaatʉ bhakiimɨɨrɨra bhararora, na abhakʉrʉ bha Abhayaahudi, bhakatanga komorega, bharabhuga, “Akabhasabhʉra abhandɨ. Arɨɨbhɨ newe Kiriisitʉ wʉnʉ arʉbhwɨrwɨ na Mungu, isabhʉrɨ umwene!” ");
INSERT INTO ikz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abhasirikarɨ bhʉʉsi bhakamorega kwo okomoha amarwa amarʉrʉ gi idivaayi. ");
INSERT INTO ikz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bhakamʉbhʉʉrɨra, “Arɨɨbhɨ awɨ nɨ‑mʉtɨmi wa Abhayaahudi, isabhʉra aumwene!” ");
INSERT INTO ikz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Gakatuurwa igʉrʉ waazɨ amaandɨkʉ garabhuga, “Wʉnʉ newe ʉmʉtɨmi wa Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gatɨ wa abhasarya bhabhɨrɨ bhayo, ʉwʉmwɨ akatʉka Yɨɨsu arabhuga, “Awɨ ʉtarɨ Kiriisitʉ? Isabhʉra aumwene! Na niitwɨ, ʉtʉsabhʉrɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nawe, ʉmʉkɨndichazɨ akamorecha, akabhuga, “Awɨ ʉtakwʉbhaha Mungu nʉʉrʉ hasuuhu? Awɨ nʉ ʉmʉʉtʉ wuyo ɨtɨnɨrʉ yaanyu nɨ‑mwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Itwɨ tutiniirwɨ koheene, kʉrɨngʼaana na amahocha gɨɨtʉ, wʉnʉ, rɨtareeho isoro rɨnʉ akʉrirɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Akʉmara, akabhuga, “Yɨɨsu! Hanʉ ʉraasikɨrɨ mʉbhʉtɨmi bhwazʉ, unhiitɨ!” ");
INSERT INTO ikz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Akamʉgarukirya, “Nɨrakʉbhʉʉrɨra amaheene, reero tʉrabha hamwɨmwɨ mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ribhaga ryɨ ɨsa isaasabha umwise, kʉkabha ni ikiirimya mucharʉ chʉsi kuhika zɨɨsa kenda umwise, ");
INSERT INTO ikz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kʉ kʉbha iryʉbha rɨkarima. Na ripaziya ryu ukusikɨra Aharɨndu ha Aharɨndu mwihekaaru, rogendo rʉmwɨ rɨkabhaarʉka mbaara ibhɨrɨ! ");
INSERT INTO ikz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yɨɨsu akarɨra kwiraka ikʉrʉ, “Bhaabha! Mʉmabhoko gaazʉ, nɨratʉʉra ekoro yaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hanʉ aamarirɨ kʉgamba gayo, akatinʼya. Hanʉ ʉmʉkʉrʉ wa abhasirikarɨ aarʉʉzɨ gayo, akakumya Mungu akubhuga, “Amaheene, ʉmʉʉtʉ wʉnʉ ataakʉrirɨ isoro ryʉryʉsi mʉbhʉtangɨ bhwa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abhaatʉ bhanʉ bhaarɨ bhiibhiringirɨ korora amangʼana gayo, bhakagarʉka mumijɨ jabhʉ, bhariitema ibhikubha bhyabhʉ kwa kurumɨka. ");
INSERT INTO ikz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bhʉʉsi bhanʉ bhaamɨnyirɨ Yɨɨsu, bhakiikara kore hasuuhu, bhakarora ganʉ gakokorwa. Gatɨ waabhʉ, kwarɨ na abhakari bhanʉ bhaamutunirɨ kwɨma Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwarɨ nʉ ʉmʉʉtʉ wʉmwɨ ʉmʉzʉmu na we eheene, iriina ryazɨ Yuusufu, wʉmwɨ wi ichandarʉ ɨkɨkʉrʉ cha Abhayaahudi, ");
INSERT INTO ikz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","nawe atiisirirɨɨnʼyɨ nabhʉ igʉrʉ wa amangʼana gaabhʉ. Ʉmʉʉtʉ wuyo aarɨ wi icharʉ cha Arimataaya na aarɨ ararɨnda kwa bhoono kʉrʉ ukuuza kwʉ ʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Neho Yuusufu akaja kwa Piraato, akamʉsabha ahaabhwɨ ɨkɨtʉndʉ cha Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Piraato akiisirirya, Yuusufu akaja, akiicha ɨkɨtʉndʉ kurwa kʉmʉsarabha, akakiringɨra mʉsanda. Akʉmara, akakihindirya mumbiihɨra yɨnʉ ɨkɨrɨɨsirwɨ kwitarɨ, na mumbiihɨra muyo, atareeho mʉʉtʉ wʉnʉ abhiikirwɨmu. ");
INSERT INTO ikz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Urusikʉ ruyo, rwarɨ urusikʉ rwa Abhayaahudi kwikonza kwʉ ʉbhʉtʉʉrʉ. Urusikʉ rwʉ ʉbhʉtʉʉrʉ rwarɨ rʉraariirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abhakari bhanʉ bhiizirɨ hamwɨmwɨ na Yɨɨsu kurwa Gariraaya, bhakatuna Yuusufu. Bhakarora imbihɨra yiyo, na chɨmbu ɨkɨtʉndʉ kɨtɨɨrwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Neho bhakagarʉka munyumba, bhakakora amaguta go okoreetya. Nawe bhakoyeera urusikʉ rwʉ ʉbhʉtʉʉrʉ, chɨmbu yaswajibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ribhaga rya mʉmacha urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma, abhakari bhayo bhakaja kumbihɨra, bhabhanwirɨ amaguta ganʉ bhaakʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nawe riibhwɨ ikʉrʉ rɨnʉ ryarɨ riribhirɨ imbihɨra, bhakarebhona rihiringitiibhwɨ rusizʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Neho bhakasikɨra mʉʉsi, bhakabhona ɨkɨtʉndʉ chʉ Ʉmʉkʉrʉ Yɨɨsu kɨtariimu. ");
INSERT INTO ikz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hanʉ bhaarɨ bhakɨɨrɨ bhararʉgʉʉra igʉrʉ wɨ ɨngʼana yiyo, hayohayo rusizʉ waabhʉ, bhakiimɨɨrɨra abhasubhɨ bhabhɨrɨ, bhiibhʉhirɨ zengebho zɨnzɨrʉ za pee! ");
INSERT INTO ikz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abhakari bhayo bhakabharora bhakagwatwa nu ubhwʉbha bhʉkʉngʼu, bhakiihiinya kuhika haasɨ. Neho abhasubhɨ bhayo bhakabhabhʉʉrɨra, “Ndora mʉramohya ʉmʉhʉru mʉbhaku? ");
INSERT INTO ikz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Atarɨ hanʉ! Aryukirɨ! Muhiitɨ amangʼana ganʉ aabhabhuuriirɨ hanʉ aarɨ akɨɨrɨ Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akabhuga, ‘Umwana wʉ Ʉmʉʉtʉ, areenderwa ahurukibhwɨ mʉmabhoko ga bhʉ ʉbhʉbhɨ, na bharamʉbhamba kʉmʉsarabha nu urusikʉ rwa katatʉ araryʉka.’ ” ");
INSERT INTO ikz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abhakari bhayo bhakahiita amangʼana ga Yɨɨsu, ");
INSERT INTO ikz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bhakahʉrʉka mumbihɨra, bhakaja kʉbhʉʉrɨra abhatumwa bha Yɨɨsu ikumi na wʉmwɨ, hamwɨmwɨ na abhandɨ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abhakari bhayo, nɨ‑Mariyamu wa Magidarena, Yowana, Mariyamu unina Yaakobho, hamwɨmwɨ na abhakari abhandɨ bhanʉ bhaarɨ hamwɨmwɨ neebho. ");
INSERT INTO ikz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nawe, bhakabhʉʉrɨra abhatumwa bha Yɨɨsu, bhakagarora kina gataana bhwera, bhatagiisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peetero akiimɨɨrɨra rogendo rʉmwɨ, akaryara mwega kuja kumbihɨra. Hanʉ aahikirɨ, akiihiinya na kwisʉnza mumbihɨra, akarora ɨsanda. Akarwa hayo, ariibhuurya bhʉkʉngʼu ganʉ arʉʉzɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Urusikʉ ruyoruyo, bhabhɨrɨ bha abhɨɨga bha Yɨɨsu bhakabha morogendo kuja ʉrʉbhɨri rwa Ɨmau. Ʉrʉbhɨri ruyo, rwarɨ kina matambʉka bhɨkwɨ ikumi na kɨmwɨ kurwa Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhabhɨrɨ bhayo bhakaja bharagamba igʉrʉ wa amangʼana ganʉ gakʉrirwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na hanʉ bhaarɨ bhakɨɨrɨ bharagamba, Yɨɨsu akaaza, akagenda hamwɨmwɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nawe bhakabha bharibhirwɨ amɨɨsʉ gaabhʉ, bhataamʉmɨnyirɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Akabhabhuurya, “Mʉragambakɨ ɨnʉ mʉragenda?” Bhakiimɨɨrɨra, ubhushʉ bhwabhʉ bharingirɨ ekomo. ");
INSERT INTO ikz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wʉmwɨ waabhʉ, iriina ryazɨ Kireopa, akamʉgarukirya, “Mʉbhagini bhʉʉsi bha Yɨrusarɨɨmu, naawɨ aumwene ʉkɨɨrɨ kwigwa ganʉ gakʉrirwɨ zisikʉ zɨnʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Akabhabhuurya, “Mangʼanakɨ gayo?” Bhakamʉgarukirya, “Itwɨ tʉragamba igʉrʉ wa Yɨɨsu wa Nazarɨɨti. Abhaatʉ bhʉʉsi na Mungu, bhakarora kʉbha aarɨ ʉmʉrʉʉtɨrɨri, amangʼana na amahocha gaazɨ gaarɨ na zinguru bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nawe abhakʉrʉ bha abhakuhaani na abhiimiiririri bhɨɨtʉ bhamuhurukiryɨ atinirwɨ kukwa, bhakamʉbhamba kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na newe twisɨgirɨ kʉbha aratuurya Abhiiziraɨri. Kwɨma gayo gʉʉsi gakʉrirwɨ, reero ni‑rusikʉ rwa katatʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Hamwɨmwɨ na gayo, abhamwɨ bha abhakari gatɨ wɨɨtʉ bhatʉtachiryɨ. Reero mʉmacha bhakaja mumbiihɨra, ");
INSERT INTO ikz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bhakabhona ɨkɨtʉndʉ cha Yɨɨsu kɨtariimu. Bhakagarʉka na kʉtʉbhʉʉrɨra kʉbha, bhakarora ʉbhʉrʉri bhwa maraika, bhanʉ bhaabhugirɨ Yɨɨsu nɨ‑mʉhʉru. ");
INSERT INTO ikz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Akʉmara, abhandɨ bhanʉ bhaarɨ na niitwɨ bhakaja kumbihɨra, bhakabhona gʉʉsi chɨmbu abhakari bhayo bhaatubhuuriirɨ, bhʉʉsi bhatarʉʉzɨ ɨkɨtʉndʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yɨɨsu akabhabhʉʉrɨra, “Ndora imwɨ bhageegebhu, Kwakɨ bhakʉngʼu mʉrɨ kwisirirya amangʼana ganʉ abharʉʉtɨrɨri bhaagambirɨ? ");
INSERT INTO ikz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nangʉ Kiriisitʉ atɨɨndirwɨ kʉhɨtɨra ɨnyaakʉ yiyo, na kusikɨra mʉbhʉgʉngʉ bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Neho Yɨɨsu akabheerekeererya amangʼana gʉʉsi ganʉ gaandikirwɨ igʉrʉ waazɨ kwɨma mʉbhɨtabhʉ bhya Musa, kuhika ɨbhɨtabhʉ bhyʉsi bhya abharʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hanʉ bhiisukirɨ ʉrʉbhɨri rʉnʉ bhaarɨ bhakuja, Yɨɨsu akabha nkina arangʼeha no rogendo. ");
INSERT INTO ikz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nawe, bhakamwisasaama bhʉkʉngʼu, “Wiikarɨ hamwɨmwɨ na niitwɨ hanʉ, kʉ kʉbha nangwɨnʉ igoroobha ni ikiirimya kisikiirɨ.” Neho Yɨɨsu akasikɨra munyumba bhakiikara hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bhakiikara kubhyakurya, Yɨɨsu akagega ʉmʉkaatɨ akagʉsabhɨra, akagusunyura, akabhasondya. ");
INSERT INTO ikz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hayohayo, bhakaramuchwa amɨɨsʉ gaabhʉ, bhakamenya kʉbha nɨ‑Yɨɨsu. Wʉʉsi rogendo rʉmwɨ akabhʉra. ");
INSERT INTO ikz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhakiibhuurya, “Awɨɨ! Hanʉ aarɨ akʉgamba na niitwɨ kʉnzɨra na kʉtʉbhʉʉrɨra igʉrʉ wa Amaandɨkʉ Amarɨndu, nangʉ tutiigwirɨ nkina omorero gʉraaka mozekoro zɨɨtʉ?” ");
INSERT INTO ikz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ribhaga riyoriyo bhakabhʉʉka, bhakagarʉka Yɨrusarɨɨmu. Bhakarumana na abhɨɨga bha Yɨɨsu ikumi na wʉmwɨ bhiibhiringirɨ hamwɨmwɨ na abhakɨndichabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hanʉ bhabhɨrɨ bhayo bhaahikirɨ, abhɨɨga bha Yɨɨsu bhakabhabhʉʉrɨra, “Nɨ‑maheene kʉbha Ʉmʉkʉrʉ wɨɨtʉ aryukirɨ, na ahwarukiirɨ Simʉʉni!” ");
INSERT INTO ikz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Neho bhakabhʉʉrɨra abhakɨndichabhʉ gʉʉsi ganʉ gakʉrirwɨ mʉnzɨra. Bhakabhabhʉʉrɨra na chɨmbu bhaamɨnyirɨ Yɨɨsu, hanʉ aabhasunyuriirɨ ʉmʉkaatɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hanʉ abhɨɨga bha Yɨɨsu bhaarɨ bhachagamba igʉrʉ wa gayo, rogendo rʉmwɨ Yɨɨsu akiimɨɨrɨra gatɨ waabhʉ, akabhabhʉʉrɨra, “Omorembe gʉbhɨ na niimwɨ.” ");
INSERT INTO ikz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhakiitacha, bhakʉʉbhaha bhʉkʉngʼu kʉ kʉbha bhakakina bhararora ɨkɨhwɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nawe, Yɨɨsu akabhabhʉʉrɨra, “Kwakɨ zekoro zaanyu ziitiimaatirɨ? Mʉna amakɨbhwɨ bhʉkʉngʼu mozekoro zaanyu? ");
INSERT INTO ikz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Morore amabhoko na amagʉrʉ gaanɨ, kʉbha niinyɨ. Mʉmbatɨbhatɨ morore! Ɨkɨhwɨ kɨtaana mʉbhɨrɨ na amaguha, chɨmbu mokorora inyɨ nɨnago.” ");
INSERT INTO ikz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hanʉ Yɨɨsu aamarirɨ kʉbhabhʉʉrɨra gayo, akabheerecha amabhoko na amagʉrʉ gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abhɨɨga bhaazɨ, bhakazomerwa bhʉkʉngʼu kuhika bhatiisiriiryɨ arɨɨbhɨ gʉʉsi nɨ‑maheene. Neho Yɨɨsu akabhabhuurya, “Hanʉ kʉna bhyakurya bhyʉbhyʉsi?” ");
INSERT INTO ikz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakamoha ritɨnɨka ryi iiswɨ ɨnyʉchu, ");
INSERT INTO ikz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akagega, akarya embere waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Akabhabhʉʉrɨra, “Garya nabhabhuuriirɨ ribhaga nɨkɨɨrɨ hamwɨmwɨ na niimwɨ, kʉbha gʉʉsi gaandikirwɨ igʉrʉ waanɨ mumigirʉ ja Musa, mʉbhɨtabhʉ bhya abharʉʉtɨrɨri, na mʉbhɨtabhʉ bhya Zabhuri gareenderwa kokorwa.” ");
INSERT INTO ikz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Neho Yɨɨsu akabharimʉʉrʉra amangʼɨɨni gaabhʉ bhamenye Amaandɨkʉ Amarɨndu. ");
INSERT INTO ikz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akabhabhʉʉrɨra, “Nɨmbu yandikirwɨ, Kiriisitʉ aranyaakibhwa, nu urusikʉ rwa katatʉ, araryʉka kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Abhaatʉ bha mubhyarʉ bhyʉsi, kwɨma Yɨrusarɨɨmu hanʉ, bharwazirwɨ kuriina ryazɨ bhatigɨ ʉbhʉbhɨ bhwabhʉ, korereke bhabheererwe. ");
INSERT INTO ikz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amangʼana gayo gamarirɨ kokorwa, na niimwɨ nɨ‑bhamɨnyɨɨkɨrɨri bha gayo. ");
INSERT INTO ikz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Mwangarɨrɨ! Nɨrabhareetera Ekoro Ɨndɨndu, chɨmbu Bhaabha aamarirɨ kʉbharaga. Nawe, mʉrɨndɨ mʉrʉbhɨri hanʉ, kuhika Ekoro Ɨndɨndu ɨraazɨ, mʉrahaabhwa ʉbhʉnaja kurwa mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Akʉmara Yɨɨsu akabhahira abhɨɨga bhaazɨ haguhɨ nʉ ʉrʉbhɨri rwa Bhɨtaniya, bhakahika harya, akanʉnga amabhoko gaazɨ igʉrʉ, akabhaha ʉrʉbhangʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Akɨɨrɨ arabhaha ʉrʉbhangʉ, akabhatiga, akagegwa kuja mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bhakamosengera, akʉmara bhakagarʉka Yɨrusarɨɨmu, bhazʉmɨɨrwɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bhakiikara mwihekaaru, bharakumya Mungu.");
INSERT INTO ikz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kʉbhʉtangɨ, yaareho Ɨngʼana. Ɨngʼana yiyo yaarɨ kwa Mungu, Ɨngʼana yaarɨ Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kwɨma ʉbhʉtangɨ, Ɨngʼana yaarɨ na Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ebhegero bhyʉsi bhɨkateemwa kʉhɨtɨra Ɨngʼana yiyo. Kɨtareeho kɨnʉ chatɨɨmirwɨ Ɨngʼana ɨtareeho. ");
INSERT INTO ikz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɨngʼana yaarɨ isimʉka yʉ ʉbhʉhʉru, nʉ ʉbhʉhʉru bhuyo nebhwe bhokoreeta ubhwɨrʉ kʉbhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ubhwɨrʉ bhuyo bhʉhaamʉrɨka mukiirimya, ni ikiirimya kɨtakʉtʉra kubhurimya. ");
INSERT INTO ikz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akaaza ʉmʉʉtʉ wʉmwɨ wʉnʉ aatumirwɨ na Mungu. Ʉmʉʉtʉ wuyo aarɨ arabhirikirwa Yoohana. ");
INSERT INTO ikz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yoohana akaaza komenyeekererya ubhwɨrʉ bhuyo, korereke abhaatʉ bhʉʉsi bhatʉrɨ kwisirirya kʉhɨtɨra ʉbhʉmɨnyɨɨkɨrɨri bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yoohana umwene ataarɨ ubhwɨrʉ bhuyo, nawe akaaza kobhomenyeekererya. ");
INSERT INTO ikz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ubhwɨrʉ bhwe eheene bhuyo, bhʉhaamʉrɨka abhaatʉ bhʉʉsi, bhwarɨ bhʉraaza kʉʉsɨ kʉnʉ. ");
INSERT INTO ikz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɨngʼana neyo yaarɨ kʉʉsɨ kʉnʉ, na Mungu akateema ɨɨsɨ kʉhɨtɨra kwayo. Nawe, abhaatʉ bhɨ ɨɨsɨ bhataayɨmɨnyirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɨkaaza kʉbhaatʉ bhaazɨ, nawe abhaatʉ bhaazɨ bhataayɨsʉngʼaanirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nawe abhaatʉ bhʉʉsi bhanʉ bhaayɨsʉngʼaanirɨ na kuyiisirirya, bhayo bhakahaabhwa ʉbhʉnaja bhwa kʉbha abhaana bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abhaana bha Mungu bhayo, bhatiibhwirwɨ kumbusurʉ ya abhaatʉ, hamwɨ kʉbhʉsɨɨgi bhwʉ ʉmʉʉtʉ, hamwɨ kubhwɨndi bhwʉ ʉmʉʉtʉ, nawe Mungu umwene akabhakora kʉbha abhaana bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mmbe, Ɨngʼana yiyo ɨkabha ʉmʉʉtʉ, akiikara hamwɨmwɨ na niitwɨ. Na niitwɨ tʉkarora ʉbhʉkʉrʉ bhwazɨ, ʉbhʉkʉrʉ bhu Umwana umumwɨmwɨ wa Bhaabha Mungu. Aarɨ nɨ ɨbhɨgʉngi ɨbhɨkʉrʉ na amaheene gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoohana akamomenyeekererya, akoongera riraka arabhuga, “Wʉnʉ newe naarɨ nɨkʉbhabhʉʉrɨra, ‘Hanʉ nɨkʉmara araaza ʉmʉʉtʉ wʉmwɨ ʉmʉkʉrʉ kʉnkɨra, kʉ kʉbha aareho inyɨ nɨkɨɨrɨ kwibhurwa.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Igʉrʉ wʉ ʉbhʉnagu bhwazɨ bhwɨ ɨbhɨgʉngi na amaheene gaazɨ, Mungu atʉrʉrɨɨrɨ itwʉsi ɨbhɨgʉngi na atwʉngɨɨrɨ ʉrʉndɨ kʉkɨra rwe embere. ");
INSERT INTO ikz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mmbe, ɨkarɨ Mungu akahurucha imigirʉ jazɨ kʉhɨtɨra Musa, ɨbhɨgʉngi na amaheene gaazɨ bhyizirɨ kʉhɨtɨra Yɨɨsu Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Atareeho ʉmʉʉtʉ nʉʉrʉ wʉmwɨ wʉnʉ arʉʉzɨ Mungu. Nawe Umwana umumwɨmwɨ, wʉʉsi ni‑Mungu, na arɨ haguhɨ na Bhaabha Mungu, ewe newe aagiriryɨ tʉkamenya Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Rusikʉ rʉmwɨ, abhakangati bha Abhayaahudi bhakatʉma abhakuhaani na Abharaawi kurwa Yɨrusarɨɨmu, bhabhuuryɨ Yoohana, “Awɨ nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yoohana akagarukirya, ataabhisirɨ amaheene, “Inyɨ nɨtarɨ Kiriisitʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakamubhuurya, “Nangʉ awɨ nɨ‑wɨɨwɨ? Awɨ ʉmʉrʉʉtɨrɨri Ɨɨriya?” Yoohana akabhagarukirya, “Zɨyi, inyɨ nɨtarɨ Ɨɨriya.” Ebho bhakamubhuurya, “Awɨ naawɨ ʉmʉrʉʉtɨrɨri wʉnʉ tʉkʉrɨnda kurwa kwa Mungu?” Yoohana akabhagarukirya, “Zɨyi, nɨtarɨ inyɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhakamubhuurya naatu, “Mmbe, awɨ nɨ‑wɨɨwɨ? Ʉtʉbhʉʉrɨrɨ korereke tujɨ tʉbhabhʉʉrɨrɨ bhanʉ bhatutumirɨ. Awɨ ʉrabhugabhwɨ igʉrʉ waazʉ aumwene?” ");
INSERT INTO ikz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoohana akabhagarukirya kʉrɨngʼaana na amangʼana ganʉ ʉmʉrʉʉtɨrɨri Isaaya aagambirɨ, “Inyɨ ni‑wurya ‘ʉmʉʉtʉ wʉnʉ akutiirya riraka kʉkɨbhara: Mogorore ɨbhɨhɨtʉ bhyʉ Ʉmʉkʉrʉ!’” ");
INSERT INTO ikz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gatɨ wa abhaatʉ bhanʉ bhaatumirwɨ bhajɨ kwa Yoohana, bhaarɨ bharuurɨ kʉBhafarisaayo. ");
INSERT INTO ikz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bhayo bhakamubhuurya, “Arɨɨbhɨ awɨ ʉtarɨ Kiriisitʉ, hamwɨ ʉmʉrʉʉtɨrɨri Ɨɨriya, hamwɨ ʉmʉrʉʉtɨrɨri wʉnʉ tʉkʉrɨnda kurwa kwa Mungu, nɨ‑kwakɨ ʉrabhatiiza abhaatʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yoohana akabhagarukirya, “Inyɨ nɨrabhatiiza abhaatʉ kʉmanzi, nawe gatɨ waanyu areho ʉmʉʉtʉ wʉnʉ imwɨ mʉtɨɨzɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wuyo newe araazɨ inyuma waanɨ. Inyɨ nɨtakwenderwa nʉʉrʉ kʉtazʉra zisiri zi ibhikwɨra bhyazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amangʼana gayo gʉʉsi gakakorebhwa mʉrʉbhɨri rwa Bhɨtaniya, ʉrʉbhaara rwa rʉgʉrʉ wɨ ɨkɨtaarʉ cha Yorodaani, hanʉ Yoohana aarɨ arabhatiiza abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tabhʉʉri waho, Yoohana akarora Yɨɨsu araaza kwawe. Akabhʉʉrɨra abhaatʉ bhanʉ bhaareho hayo, “Rora, wuyo newe Ɨkɨngʼʉndu cha Mungu, wʉnʉ akuruusha ʉbhʉbhɨ bhwa abhaatʉ bhʉʉsi bhɨ ɨɨsɨ yɨnʉ! ");
INSERT INTO ikz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wʉnʉ newe naarɨ nɨkʉbhabhʉʉrɨra, ‘Hanʉ nɨkʉmara araaza ʉmʉʉtʉ wʉmwɨ ʉmʉkʉrʉ kʉnkɨra, kʉ kʉbha aareho inyɨ nɨkɨɨrɨ kwibhurwa.’ ");
INSERT INTO ikz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nʉʉrʉ inyɨ nɨtaamɨnyirɨ kʉbha ewe nɨ‑wɨɨwɨ, nawe niizirɨ kʉbhatiiza abhaatʉ kʉmanzi korereke ahumburwɨ kʉbhaatʉ bha Iziraɨri.” ");
INSERT INTO ikz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Neho Yoohana akabhamenyeekererya ganʉ aarɨ arʉʉzɨ, arabhuga, “Nɨkarora Ekoro Ɨndɨndu iriika kurwa mwisaarʉ nchi ikiguuti na kwikara igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nawe na niinyɨ nɨtaamʉmɨnyirɨ kʉbha nɨ‑wɨɨwɨ, nawe Mungu wʉnʉ antumirɨ kʉbhatiiza kwa amanzi aarɨ aambuuriirɨ, ‘Ʉmʉʉtʉ wʉnʉ ʉraarore Ekoro yaanɨ iriika igʉrʉ waazɨ na kʉsaaga nawe, wuyo newe araabhatiizɨ abhaatʉ kwe Ekoro Ɨndɨndu.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hayo Yoohana akabhuga, “Na niinyɨ nɨrʉʉzɨ gayo gʉʉsi, na nɨramenyeekererya kʉbha, wuyo newe Umwana wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tabhʉʉri waho, Yoohana aarɨ imiiriirɨ hayo naatu, hamwɨmwɨ na bhabhɨrɨ wa abhɨɨga bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Neho akarora Yɨɨsu aragenda haguhɨ nabhʉ. Akabhʉʉrɨra abhɨɨga bhaazɨ, “Rora, wuyo newe Ɨkɨngʼʉndu cha Mungu!” ");
INSERT INTO ikz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hanʉ abhɨɨga bhabhɨrɨ bhayo bhiigwirɨ amangʼana gayo, bhakatuna Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yɨɨsu akiichʉra, akarora abhɨɨga bhayo bharamutuna. Akabhabhuurya, “Nangʉ, moreendakɨ?” Ebho bhakamʉgarukirya, “Raabhi, uriikara hayi?” Enzobhooro ya ringʼana Raabhi ni‑Mwija. ");
INSERT INTO ikz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yɨɨsu akabhuga, “Muuzɨ, mʉraharora.” Neho bhakamutuna, bhakaja hanʉ aarɨ ariikara. Hanʉ bhaahikirɨ hayo, yaarɨ ɨsa ikumi ya rigoroobha, bhakasaaga nawe kurusikʉ ruyo. ");
INSERT INTO ikz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wʉmwɨ gatɨ wa abhɨɨga bhabhɨrɨ bhanʉ bhiigwirɨ amangʼana ga Yoohana na kutuna Yɨɨsu, aarɨ arabhirikirwa Andureya, umuhiiri wa Simʉʉni Peetero. ");
INSERT INTO ikz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Rogendo rʉmwɨ akaja komohya Simʉʉni, umuhiiri waazɨ. Hanʉ aamubhwɨnɨ, akamʉbhʉʉrɨra, “Tʉrʉʉzɨ Masiya!” Masiya, newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Neho Andureya akamuhira Simʉʉni kwa Yɨɨsu. Yɨɨsu akamogorera Simʉʉni, akamʉbhʉʉrɨra, “Awɨ ni‑Simʉʉni, umwana wa Yoohana. Nawe kʉtangɨra nangʉ, iriina ryazʉ rɨrabha Keefa.” Enzobhooro yaku ne‑Peetero, hamwɨ ritarɨ. ");
INSERT INTO ikz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tabhʉʉri waho, Yɨɨsu akatɨnɨra kuja mucharʉ cha Gariraaya. Neho akabhona Firipʉ, akamʉbhʉʉrɨra, “Ntuna.” ");
INSERT INTO ikz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firipʉ aarɨ ʉmʉʉtʉ kurwa ʉrʉbhɨri rwa Bhɨtɨsaida, mʉnʉ Andureya na Peetero bhaarɨ bhakwikara. ");
INSERT INTO ikz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mmbe, Firipʉ akabhona Natanaɨri, akamʉbhʉʉrɨra, “Tʉrʉʉzɨ ʉmʉʉtʉ wʉnʉ Musa aandikirɨ amangʼana igʉrʉ waazɨ mʉkɨtabhʉ chi imigirʉ, naatu newe abharʉʉtɨrɨri bhaandikirɨ amangʼana igʉrʉ waazɨ. Iriina ryazɨ nɨ‑Yɨɨsu, umwana wa Yuusufu, kurwa Nazarɨɨti.” ");
INSERT INTO ikz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nawe Natanaɨri akabhuurya Firipʉ, “Awɨɨ, ekegero chʉchʉsi ɨkɨzʉmu kɨratʉra kurwa mʉrʉbhɨri urusuuhu rwa Nazarɨɨti?” Firipʉ akamʉgarukirya, “Nauzɨ, orore.” ");
INSERT INTO ikz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hanʉ Yɨɨsu aarʉʉzɨ Natanaɨri araaza kwewe, akabhuga, “Rora, ʉmʉʉtʉ wuyo ni‑Mwiziraɨri we eheene, ataana ngʼeera yʉyʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaɨri akabhuurya Yɨɨsu, “Ʉmɨnyirɨbhwɨ?” Yɨɨsu akamʉgarukirya, “Nʉʉrʉ hanʉ Firipʉ aarɨ akɨɨrɨ kʉkʉbhɨrɨkɨra, inyɨ nɨkakorora wiikɨɨrɨ iyaasɨ wʉ ʉmʉtɨ gu umutiini.” ");
INSERT INTO ikz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaɨri akamʉgarukirya, “Umwija, awɨ ni‑Mwana wa Mungu! Awɨ nɨ‑Mʉtɨmi wa Iziraɨri!” ");
INSERT INTO ikz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yɨɨsu akamubhuurya, “Nangʉ, uriisirirya kʉ kʉbha nikubhuuriirɨ kʉbha nɨkʉrʉʉzɨ hanʉ waarɨ wiikɨɨrɨ iyaasɨ wu umutiini? Ʉrarora amangʼana agandɨ amakʉrʉ kʉkɨra ganʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Neho akamʉbhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, mʉrarora mwisaarʉ hiigukirɨ, na mʉrarora bhamaraika bha Mungu bharatiira na kwika kwa niinyɨ, Umwana wʉ Ʉmʉʉtʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mmbe, urusikʉ rwa katatʉ bhʉkakorwa ubhuryakari mʉrʉbhɨri rwa Kana, mucharʉ cha Gariraaya. Mubhuryakari bhuyo, unina Yɨɨsu aareho. ");
INSERT INTO ikz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yɨɨsu na abhɨɨga bhaazɨ bhʉʉsi bhaarɨ bharaarikirwɨ mʉnyangi yiyo. ");
INSERT INTO ikz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hanʉ abhagini bhaamarirɨ idivaayi, unina Yɨɨsu akamʉbhʉʉrɨra, “Idivaayi isirirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yɨɨsu akabhuga, “Yiiya, kwakɨ ʉrambʉʉrɨrabhu? Ribhaga ryo okohocha emeremo janɨ rɨkɨɨrɨ kuhika.” ");
INSERT INTO ikz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Neho unina akabhʉʉrɨra abhahocha, “Gʉgʉʉsi ganʉ araabhabhʉʉrɨrɨ, mokore.” ");
INSERT INTO ikz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Mmbe, zaareho ziinywa isaasabha za amanzi zɨnʉ zabhumbirwɨ na amabhwɨ. Abhayaahudi bhaarɨ bharatɨɨmu amanzi gʉ ʉkʉbhɨngukya. Inywa yɨmwɨ yaarɨ iriizuribhwa na amadebhe ataanʉ hamwɨ asaasabha. ");
INSERT INTO ikz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Neho Yɨɨsu akabhabhʉʉrɨra abhahocha, “Mwizuryɨ amanzi muziinywa ziyo.” Bhʉʉsi bhakiizurya amanzi ziinywa ziyo kuhika igʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Akʉmara, Yɨɨsu akabhabhʉʉrɨra, “Nangʉ, mʉtahɨ, momohe umwimiiririri wɨ ɨnyangi.” Bhʉʉsi bhakakorabhu. ");
INSERT INTO ikz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Umwimiiririri wɨ ɨnyangi akasama amanzi ganʉ gaarɨ giichurirɨ gabhɨɨrɨ idivaayi. Ewe ataamɨnyirɨ hanʉ yaruurɨ, nawe abhahocha bhanʉ bhaatahirɨ amanzi muunywa bhakamenya. Neho akabhɨrɨkɨra umukwɨri. ");
INSERT INTO ikz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Akamʉbhʉʉrɨra, “Abhakʉri bhɨ ɨnyangi bhahaabhaha abhagini idivaayi ɨnzʉmu hinga. Akʉmara, hanʉ bhakwigʉta, neho bhahaareeta umunziryʉngʉ gwi idivaayi. Nawe awɨ ʉrɨɨtirɨ idivaayi ɨnzʉmu mʉtɨnɨrʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yɨɨsu akakora ɨkɨsɨgʉ kɨnʉ mʉrʉbhɨri rwa Kana mucharʉ cha Gariraaya. Ɨkɨsɨgʉ kiyo charɨ che embere kwerecha ʉbhʉkʉrʉ bhwazɨ, na abhɨɨga bhaazɨ bhakamwisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hanʉ ɨnyangi yu ubhuryakari yaasirirɨ, Yɨɨsu akaja mʉrʉbhɨri rwa Kapɨrinaumu hamwɨmwɨ na unina, abhasuuhu bhaazɨ na abhɨɨga bhaazɨ. Bhakiikara iyo sikʉ suuhu. ");
INSERT INTO ikz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hanʉ isigukuru yɨ Ɨpasaka ya Abhayaahudi yaarɨ ɨrariirɨ, Yɨɨsu akaja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hanʉ aahikirɨ, akasikɨra mwihekaaru rya Mungu, akabhona abhaatʉ bharagurya zengʼombe, zɨngʼʉndu ni ibhiguuti, na bhanʉ bhaarɨ bhiikɨɨrɨ kozeemeeza bhakʉkɨranʼya zimpirya. ");
INSERT INTO ikz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hanʉ Yɨɨsu aarʉʉzɨ gayo, akakora ʉmʉzariti, akaheebha zɨngʼʉndu na zengʼombe hamwɨmwɨ na bhʉʉsi bhanʉ bhaarɨ bhakugurya mwihekaaru. Na akabharingʉra zemeeza za bhanʉ bhaarɨ bhakʉkɨranʼya zimpirya, na kʉnyaraganʼya zimpirya zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Neho akabhabhʉʉrɨra bhanʉ bhaarɨ bhakugurya ibhiguuti, “Muruushɨ ibhiguuti bhɨnʉ hanʉ! Mʉtakora inyumba ya Bhaabha kʉbha isoko!” ");
INSERT INTO ikz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hanʉ abhɨɨga bhaazɨ bhiigwirɨ gayo, bhakahiita amangʼana ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, “Ʉbhʉsɨɨgi bhwanɨ kunyumba yaazʉ bhʉraamara.” ");
INSERT INTO ikz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hanʉ abhakangati bha Abhayaahudi bharʉʉzɨ ganʉ Yɨɨsu akʉrirɨ, bhakamubhuurya, “Ʉrakora chɨrɨkɨnʼyʉkɨ kwerecha kʉbha ʉnʉ ʉbhʉnaja bhwo okokora amangʼana gayo?” ");
INSERT INTO ikz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yɨɨsu akabhagarukirya, “Mugwishɨ rihekaaru rɨnʉ, inyɨ nɨraryʉmbaka kwa sikʉ isatʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Neho bhakabhuga, “Rihekaaru rɨnʉ ryʉmbakirwɨ kumyaka merongo ene nɨ ɨsaasabha! Awɨ ʉratʉrabhwɨ kuryʉmbaka kwa sikʉ isatʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nawe Yɨɨsu ataagambirɨ igʉrʉ wa rihekaaru, aarɨ aragamba igʉrʉ wʉ ʉmʉbhɨrɨ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hanʉ aaryukirɨ kurwa mʉbhaku, abhɨɨga bhaazɨ bhakahiita amangʼana ganʉ aagambirɨ, bhakiisirirya Amaandɨkʉ Amarɨndu na amangʼana ganʉ Yɨɨsu aagambirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hanʉ Yɨɨsu aarɨ Yɨrusarɨɨmu kusigukuru yɨ Ɨpasaka, abhaatʉ bhaaru bhakatanga kumwisirirya, kʉ kʉbha bhakarora ibhyɨrɨkɨnʼyʉ bhɨnʉ aarɨ arakora. ");
INSERT INTO ikz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nawe Yɨɨsu akamenya kʉbha bhatarɨ bha kwisega, kʉ kʉbha akabhamenya bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Atɨɨndirɨ kwitegeerera ganʉ abhaatʉ bhakwiseega, kʉ kʉbha akamenya gʉʉsi ganʉ gari mumyʉyʉ ja abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aareho ʉmʉkangati wʉmwɨ wa Abhayaahudi wa riribhita rya Abhafarisaayo, iriina ryazɨ Nikʉdɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rusikʉ rʉmwɨ ubhutikʉ, akaja kwa Yɨɨsu, akamʉbhʉʉrɨra, “Umwija, tʉmɨnyirɨ kʉbha awɨ ni‑mwija wʉnʉ utumirwɨ na Mungu, kʉ kʉbha atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kokora ɨbhɨsɨgʉ bhɨnʉ awɨ okokora, arɨɨbhɨ Mungu atarɨ hamwɨmwɨ nawe.” ");
INSERT INTO ikz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yɨɨsu akabhuga, “Nɨrakʉbhʉʉrɨra amaheene, atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kusikɨra mʉbhʉtɨmi bhwa Mungu arɨɨbhɨ akɨɨrɨ kwibhurwa rwa kabhɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikʉdɨɨmu akabhuurya Yɨɨsu, “Ʉmʉʉtʉ aratʉrabhwɨ kwibhurwa rwa kabhɨrɨ mʉkaruka? Aratʉra kʉgarʉka mʉnda ya unina korereke iibhurwɨ naatu?” ");
INSERT INTO ikz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yɨɨsu akamʉgarukirya, “Nɨrakʉbhʉʉrɨra amaheene, atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kusikɨra mʉbhʉtɨmi bhwa Mungu arɨɨbhɨ akɨɨrɨ kwibhurwa kʉmanzi na kwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ʉmʉʉtʉ ahiibhurwa na abhiibhuri bhaazɨ, kʉnzɨra yʉ ʉmʉbhɨrɨ, nawe ʉbhʉhʉru ubhuhya bhwahaarwa kwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ʉtarʉgʉʉra kʉ kʉbha nikubhuuriirɨ, ‘Moreenderwa mwibhurwɨ rwa kabhɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ekoro Ɨndɨndu ituubhɨɨnɨ nʉ ʉmʉkama gʉnʉ gukuhuuta kwerekera ɨnʉ gukwenda. Ʉratʉra kwigwa kuhuuta kwaku, nawe ʉtɨɨzɨ ɨnʉ gukurwɨra nɨ ɨnʉ gukuja. Nɨmbu ɨrɨ kʉmʉʉtʉ wʉwʉʉsi wʉnʉ iibhwirwɨ ne Ekoro Ɨndɨndu.” ");
INSERT INTO ikz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikʉdɨɨmu akabhuurya Yɨɨsu, “Nangʉ, ʉmʉʉtʉ aratʉrabhwɨ kwibhurwabhu?” ");
INSERT INTO ikz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yɨɨsu akamʉgarukirya, “Awɨ ni‑mwija wʉnʉ ukusuukwa bhʉkʉngʼu mucharʉ cha Iziraɨri, ʉtɨɨzɨ amangʼana gayo? ");
INSERT INTO ikz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nɨrakʉbhʉʉrɨra amaheene, itwɨ tʉragamba ganʉ tʉmɨnyirɨ, na tʉramenyeekererya ganʉ tʉrʉʉzɨ. Nawe imwɨ mʉtakwisirirya ʉbhʉmɨnyɨɨkɨrɨri bhwɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɨbhabhuuriirɨ amangʼana ganʉ gakokorwa kʉʉsɨ kʉnʉ, nawe imwɨ mʉtakwisirirya. Nangʉ mʉranyiisiriryabhwɨ hanʉ nɨkʉbhabhʉʉrɨra ɨngʼana ya amangʼana ganʉ gakokorwa mwisaarʉ? ");
INSERT INTO ikz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atareeho ʉmʉʉtʉ wʉwʉʉsi wʉnʉ agiirɨ mwisaarʉ. Nawe Umwana wʉ Ʉmʉʉtʉ newe iizirɨ kurwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Hanʉ Abhiiziraɨri bhaarɨ kʉkɨbhara, Musa akakora risambwa rye enzoka yɨ ɨshabha na kuritiirya kʉkɨtɨ korereke bhahore. Ɨbhuɨbhu nu Umwana wʉ Ʉmʉʉtʉ, areenderwa kutiiribhwa, ");
INSERT INTO ikz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","korereke abhaatʉ bhʉʉsi bhanʉ bhakumwisirirya bhabhɨ nʉ ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mmbe, Mungu akasɨɨga ɨɨsɨ, kuhika akahurucha umwana waazɨ umumwɨmwɨ aazɨ mʉʉsɨ, korereke abhaatʉ bhʉʉsi bhanʉ bhakumwisirirya bhatarimɨra, nawe bhabhɨ nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mungu ataatumirɨ Umwana waazɨ kʉʉsɨ kʉnʉ korereke atɨnɨrɨ abhaatʉ, nawe abhasabhʉrɨ kʉhɨtɨra kwewe. ");
INSERT INTO ikz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ʉmʉʉtʉ wʉnʉ akwisirirya atakutinirwa. Nawe ʉmʉʉtʉ wʉnʉ atakumwisirirya, amarirɨ kutinirwa kʉ kʉbha akɨɨrɨ kwisirirya Umwana waazɨ umumwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ɨtɨnɨrʉ nɨ‑yɨnʉ, Umwana wa Mungu arɨɨtirɨ ubhwɨrʉ mʉʉsɨ mʉnʉ, nawe abhaatʉ bhasɨɨgirɨ kʉbha mukiirimya kʉkɨra kʉbha mubhwɨrʉ, kʉ kʉbha amahocha gaabhʉ nɨ‑mabhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abhaatʉ bhʉʉsi bhanʉ bhahaakora amahocha amabhɨ, ebho bhahaabhiihirirwa ubhwɨrʉ bhuyo. Bhatakwenda kuuza mubhwɨrʉ, korereke amahocha gaabhʉ amabhɨ gataaza komenyekana. ");
INSERT INTO ikz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nawe abhaatʉ bhʉʉsi bhanʉ bhahaakora amahocha ga maheene, ebho bhahaamohya kʉbha mubhwɨrʉ bhuyo, korereke emenyekanɨ kʉbha Mungu newe akʉbhaha ʉbhʉnaja bhwʉ ʉkʉgakora. ");
INSERT INTO ikz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mmbe, hanʉ gayo gaahitirɨ, Yɨɨsu na abhɨɨga bhaazɨ bhakaja mucharʉ cha Yudeya. Akiikara iyo kwibhaga irebhe, akabha arabhatiiza abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoohana wʉʉsi aarɨ arabhatiiza abhaatʉ Ainʉʉni, haguhɨ nʉ ʉrʉbhɨri rwa Sarɨmu. Gaareho amanzi maaru iyo, na abhaatʉ bhakaja kwa Yoohana korereke abhabhatiizɨ. ");
INSERT INTO ikz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kwibhaga riyo, Yoohana aarɨ akɨɨrɨ kugwatwa na kutuurwa mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rusikʉ rʉmwɨ, abhɨɨga bha Yoohana bhakatanga kʉhakaana nʉ Ʉmʉyaahudi wʉmwɨ igʉrʉ wi isimʉka yʉ ʉkʉbhɨngukya. ");
INSERT INTO ikz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Neho bhakaja kwa Yoohana, bhakamʉbhʉʉrɨra, “Umwija, ʉrahiita ʉmʉʉtʉ wʉnʉ aarɨ na naawɨ imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani na ʉkamenyeekererya amangʼana gaazɨ? Nangwɨnʉ wʉʉsi arabhatiiza, na abhaatʉ bhʉʉsi bharaja kwewe!” ");
INSERT INTO ikz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoohana akabhuga, “Ʉmʉʉtʉ atakʉtʉra kobhona ekegero chʉchʉsi, arɨɨbhɨ Mungu akɨɨrɨ komoha. ");
INSERT INTO ikz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imwɨ nɨ‑bhamɨnyɨɨkɨrɨri bhaanɨ, nɨkabhuga, ‘Inyɨ nɨtarɨ Kiriisitʉ, nawe Mungu antumirɨ korereke nɨmʉkangatɨrɨ Kiriisitʉ.’ ");
INSERT INTO ikz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Umuryakari aheenderwa kuja kumukwɨri. Inyɨ nangɨ omobheja wu umukwɨri, nimiiriirɨ rusizʉ waazɨ na nɨrazomerwa kwigwa riraka ryazɨ. Maheene ne‑meremo gɨnʉ gɨnzʉmɨɨrɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ereenderwa Yɨɨsu abhɨ ʉmʉkʉrʉ kʉnkɨra, na niinyɨ nɨbhɨ umunyi.” ");
INSERT INTO ikz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ewe wʉnʉ aruurɨ mwisaarʉ, anʉ ʉbhʉnaja igʉrʉ wa bhyʉsi. Wʉwʉʉsi wʉnʉ akurwa kʉʉsɨ, aragamba amangʼana ga mʉʉsɨ mʉnʉ. Nawe wʉnʉ aruurɨ mwisaarʉ, anʉ ʉbhʉnaja igʉrʉ wa bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ewe aramenyeekererya ganʉ aarʉʉzɨ na kwigwa, nawe atareeho ʉmʉʉtʉ wʉnʉ akwisirirya ʉbhʉmɨnyɨɨkɨrɨri bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwisirirya ʉbhʉmɨnyɨɨkɨrɨri bhwazɨ, areerekeererya kʉbha Mungu nɨ‑wa amaheene, ");
INSERT INTO ikz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","kʉ kʉbha wʉnʉ atumirwɨ na Mungu, ahaagamba amangʼana gaazɨ, kʉ kʉbha Mungu amʉhɨɨrɨ Ekoro Ɨndɨndu ɨtaana ekerengo. ");
INSERT INTO ikz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bhaabha Mungu amʉsɨɨgirɨ Umwana waazɨ, na amʉhɨɨrɨ ʉbhʉnaja igʉrʉ we ebhegero bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwisirirya Umwana wa Mungu, wuyo anʉ ʉbhʉhʉru bhwa kemerano. Nawe ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akumwanga, wuyo ataana ʉbhʉhʉru bhwa kemerano, kʉ kʉbha ʉbhʉrʉrʉ bhwa Mungu bhʉrakaja kʉbha igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mmbe, Yɨɨsu akiigwa kʉbha Abhafarisaayo bhakabhuurirwa kʉbha, arabhatiiza na kobhona abhɨɨga bhaaru kʉkɨra Yoohana. ");
INSERT INTO ikz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nʉʉrʉbhu, amaheene nɨ‑kʉbha, Yɨɨsu umwene ataabhatiizirɨ, nawe abhɨɨga bhaazɨ nebho bhaarɨ bhakʉbhatiiza. ");
INSERT INTO ikz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hanʉ Yɨɨsu iigwirɨbhu, akabhʉʉka mucharʉ cha Yudeya hamwɨmwɨ na abhɨɨga bhaazɨ, bhakagarʉka mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hanʉ bhaarɨ bhakuja Gariraaya, bhakeenderwa kʉhʉrʉkɨra icharʉ cha Samaariya. ");
INSERT INTO ikz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mmbe, bhakahika mʉrʉbhɨri rʉmwɨ rwa Samaariya rʉnʉ rwarɨ rʉrabhirikirwa Sikaari. Ʉrʉbhɨri ruyo, rwarɨ haguhɨ nʉ ʉmʉgʉndʉ gʉnʉ Yaakobho aagabhiryɨ umwana waazɨ Yuusufu. ");
INSERT INTO ikz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ahagero hayo kwarɨ ni ikisima cha Yaakobho. Na Yɨɨsu, kʉ kʉbha aarɨ anihirɨ no orogendo, akiikara rusizʉ wi ikisima. Yaarɨ nyamunga ɨsa isaasabha mumwise. ");
INSERT INTO ikz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Akʉmara, ʉmʉkari wʉmwɨ Ʉmʉsamaariya akaaza kʉtaha amanzi mukisima hayo. Yɨɨsu akamʉbhʉʉrɨra, “Yiiya, nongʼe amanzi ninywɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ribhaga riyo, abhɨɨga bhaazɨ bhaarɨ bhagiirɨ mʉrʉbhɨri kʉgʉra ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ʉmʉkari wuyo akabhuga, “Awɨ nɨ‑Mʉyaahudi, na niinyɨ nɨ‑Mʉsamaariya. Kwakɨ ʉransabha inyɨ nekohe amanzi gu ukunywa?” Akagambabhu, kʉ kʉbha Abhayaahudi bhatakwisanganʼya na Abhasamaariya. ");
INSERT INTO ikz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yɨɨsu akamʉgarukirya, “Angabhɨɨrɨ omenye kɨnʉ Mungu akwenda kokoha, na kʉbha nɨ‑wɨɨwɨ wʉnʉ akʉkʉsabha amanzi, waarɨ ʉramʉsabha, neewe aarɨ arakoha amanzi gʉ ʉbhʉhʉru.” ");
INSERT INTO ikz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ʉmʉkari wuyo akabhuga, “Ʉmʉkʉrʉ, awɨ ʉtaana ekegero chʉ ʉkʉtahɨra amanzi, ni ikisima kɨnʉ nɨ‑kɨrɨɨhu. Nangʉ ʉrabhona hayi amanzi gʉ ʉbhʉhʉru gayo? ");
INSERT INTO ikz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sʉʉkʉrʉ wɨɨtʉ Yaakobho umwene akatoha ikisima kɨnʉ, neewe aarɨ aranywa amanzi hanʉ hamwɨmwɨ na abhaana bhaazɨ ni imitugʉ jazɨ. Nangʉ, uriirora kʉbha awɨ nɨ‑mʉkʉrʉ kʉmʉkɨra ewe?” ");
INSERT INTO ikz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Neho Yɨɨsu akamʉgarukirya, “Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akunywa amanzi ga mukisima kɨnʉ, ariigwa enyoota naatu. ");
INSERT INTO ikz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nawe ʉmʉʉtʉ wʉnʉ akunywa amanzi ganʉ inyɨ nekomoha, atakwigwa enyoota kwikɨ, kemerano. Amanzi ganʉ nekomoha, garabha nchɨ ɨkɨsɨɨzɨ cha amanzi kwewe, kɨrabha kɨrahurucha ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Neho ʉmʉkari wuyo akabhʉʉrɨra Yɨɨsu, “Ʉmʉkʉrʉ, nongʼe amanzi gayo, korereke nitiigwa enyoota naatu, na nɨtaaza kʉtaha amanzi naatu mukisima kɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yɨɨsu akabhuga, “Nuujɨ ʉbhɨrɨkɨrɨ umusubhɨ waazʉ, uuzɨ nawe hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Akabhuga, “Inyɨ nɨtaana musubhɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Ʉgambirɨ bhwaheene ʉtaana musubhɨ, ");
INSERT INTO ikz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kʉ kʉbha ʉmarirɨ kʉbha na abhasubhɨ bhataanʉ, na wʉnʉ ukwikara nawe nangwɨnʉ, atarɨ waazʉ. Ʉgambirɨ amaheene.” ");
INSERT INTO ikz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ʉmʉkari wuyo akamʉgarukirya, “Ʉmʉkʉrʉ, nangʉ nɨrarora awɨ nɨ‑mʉrʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bhasʉʉkʉrʉ bhɨɨtʉ bhaarɨ bharasengera Mungu kʉkɨgʉrʉ cha Gɨrazimu kɨnʉ, nawe imwɨ Abhayaahudi mʉrabhuga tujɨ kosengera Mungu Yɨrusarɨɨmu.” ");
INSERT INTO ikz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yɨɨsu akamʉgarukirya, “Yiiya nyiisirirya, ribhaga rɨraaza rɨnʉ mʉtakosengera Bhaabha Mungu kʉkɨgʉrʉ kɨnʉ hamwɨ Yɨrusarɨɨmu iyo. ");
INSERT INTO ikz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imwɨ Abhasamaariya mʉrasengera Mungu wʉnʉ mʉtɨɨzɨ. Nawe itwɨ Abhayaahudi tʉrasengera Mungu wʉnʉ twɨzɨ, kʉ kʉbha Mungu arasabhʉra abhaatʉ kʉ kʉhɨtɨra Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ribhaga rɨraaza, naatu rɨmarirɨ kuhika, hanʉ abhaatʉ bhanʉ bhakwenda kosengera Bhaabha Mungu koheene, bharabha bharamosengera kwe Koro na koheene. Bhaabha Mungu ahaamohya abhaatʉ bhanʉ bhakomosengera kʉnzɨra yiyo. ");
INSERT INTO ikz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mungu ne‑Koro. Abhaatʉ bhanʉ bhakomosengera, bhareenderwa bhabhɨ bharamosengera kwe Ekoro na kwa amaheene.” ");
INSERT INTO ikz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ʉmʉkari wuyo akabhʉʉrɨra Yɨɨsu, “Nɨɨzɨ kʉbha Masiya araaza, wʉnʉ akubhirikirwa Kiriisitʉ. Na nɨɨzɨ kʉbha, ribhaga rɨnʉ akuuza, aratʉbhʉʉrɨra amangʼana gʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Neho Yɨɨsu akamʉgarukirya, “Inyɨ, wʉnʉ nɨkʉgambana na naawɨ, newe.” ");
INSERT INTO ikz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mmbe, ribhaga riyo, abhɨɨga bhaazɨ bhakagarʉka. Bhakarʉgʉʉra bhʉkʉngʼu korora Yɨɨsu aarɨ aragamba nʉ ʉmʉkari. Nawe atareeho nʉʉrʉ wʉmwɨ wʉnʉ aabhuuriryɨ Yɨɨsu, “Oreendakɨ kwawe?” hamwɨ, “Kwakɨ ʉragamba nawe?” ");
INSERT INTO ikz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mmbe, ʉmʉkari wuyo akatiga inywa yaazɨ ya amanzi hayo, akaja mʉrʉbhɨri. Hanʉ aahikirɨ, akabhʉʉrɨra abhaatʉ, ");
INSERT INTO ikz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Muuzɨ, morore ʉmʉʉtʉ wʉnʉ aambuuriirɨ amangʼana gʉʉsi ganʉ nɨmarirɨ kokora! Nangʉ, ɨratʉrɨkana kʉbha wuyo newe Kiriisitʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hanʉ abhaatʉ bhiigwirɨ gayo, bhakarwa mʉrʉbhɨri muyo, bhakaja kwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hanʉ abhaatʉ bhayo bhaarɨ bhakɨɨrɨ kuhika kwa Yɨɨsu, abhɨɨga bhaazɨ bhakamʉsabha bharabhuga, “Umwija, uryɨ ibhyakurya.” ");
INSERT INTO ikz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nawe ewe akabhagarukirya, “Inyɨ nini ibhyakurya bhɨnʉ imwɨ mʉtɨɨzɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Neho abhɨɨga bhaazɨ bhakatanga kwibhuurya, “Kʉnʉ ʉmʉʉtʉ wʉnʉ amʉrɨɨtɨɨrɨ ibhyakurya?” ");
INSERT INTO ikz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yɨɨsu akabhabhʉʉrɨra, “Ibhyakurya bhyanɨ ne‑kokora ganʉ akwenda wʉnʉ antumirɨ, na kuhicha emeremo jazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Imwɨ mʉnarirɨ kʉgamba, ‘Gɨsaagirɨ imyɨri enebhu rigesa rihikɨ.’ Nawe inyɨ nɨrabhabhʉʉrɨra, morore ɨmɨgʉndʉ chɨmbu gɨrɨ, amagesa gamarirɨ kokongʼa, gareenderwa gageswe. ");
INSERT INTO ikz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ʉmʉgɨsi arabhona amarihi gaazɨ, na arabhiringa amagesa igʉrʉ yʉ ʉbhʉhʉru bhwa kemerano. Igʉrʉ wa riyo, ʉmʉhambi nʉ ʉmʉgɨsi, bhʉʉsi bharazomerwa hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kereho ekerenjo cha amaheene kɨnʉ kikubhuga, ‘Ʉmʉʉtʉ wʉmwɨ arahamba, nʉ ʉwʉndɨ aragesa.’ ");
INSERT INTO ikz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɨkabhatʉma imwɨ kogesa bhɨnʉ mʉtaanyaakiirɨ. Abhaatʉ abhandɨ bhaakʉrirɨ emeremo jʉsi ɨmɨkʉngʼu, na niimwɨ mʉrabhona ubhwera bhwe emeremo jabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mmbe, Abhasamaariya bhaaru bha mʉrʉbhɨri ruyo, bhakiisirirya Yɨɨsu, kʉ kʉbha bhiigwirɨ ʉbhʉmɨnyɨɨkɨrɨri bhwʉ ʉmʉkari wuyo, “Ʉmʉʉtʉ wuyo aambuuriirɨ amangʼana gʉʉsi ganʉ niizirɨ kokora.” ");
INSERT INTO ikz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hanʉ Abhasamaariya bhaahikirɨ kwa Yɨɨsu, bhakamʉsabha iikarɨ hamwɨmwɨ nabhʉ. Neho akiikara mʉrʉbhɨri ruyo sikʉ ibhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abhaatʉ bhaaru bhʉkʉngʼu bhakiisirirya Yɨɨsu igʉrʉ wa ganʉ aarɨ aragamba. ");
INSERT INTO ikz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhakabhʉʉrɨra ʉmʉkari wuyo, “Twisiriiryɨ ʉmʉʉtʉ wʉnʉ ɨtarɨ igʉrʉ wa ganʉ utubhuuriirɨ awɨ, nawe tʉramwisirirya kʉ kʉbha twigwirɨ itubheene ganʉ akʉgamba. Nangʉ tʉmɨnyirɨ kobhoheene kʉbha, ʉmʉʉtʉ wʉnʉ newe Ʉmʉsabhuri wi icharʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hanʉ sikʉ ibhɨrɨ zaahitirɨ, Yɨɨsu akarwa iyo, akangʼeha kuja icharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yɨɨsu umwene akabhuga, “Ʉmʉrʉʉtɨrɨri tahaasuukwa mʉrʉbhɨri rwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hanʉ aahikirɨ Gariraaya iyo, abhaatʉ bhakamuginihya. Bhaarɨ bharʉʉzɨ gʉʉsi ganʉ aarɨ akʉrirɨ Yɨrusarɨɨmu kusigukuru yɨ Ɨpasaka, kʉ kʉbha ebho abheene bhaarɨyu. ");
INSERT INTO ikz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yɨɨsu akaja naatu mʉrʉbhɨri rwa Kana ya Gariraaya, hanʉ aarɨ achurirɨ amanzi kʉbha idivaayi. Mmbe, aareho ʉmʉkʉrʉ wʉmwɨ kurwa ʉrʉbhɨri rwa Kapɨrinaumu. Aarɨ nu umwana wi ikisubhɨ murwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Akiigwa kʉbha Yɨɨsu aruurɨ Yudeya iizirɨ Gariraaya. Kʉgayo, akaja kwa Yɨɨsu na kʉmʉsabha aazɨ Kapɨrinaumu, ahorye mumura waazɨ, kʉ kʉbha aarɨ murwɨrɨ arikiriirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yɨɨsu akabhuga, “Imwɨ, mʉraatamɨ korora ibhyɨrɨkɨnʼyʉ na amateemo, mʉtakogema kwisirirya!” ");
INSERT INTO ikz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ʉmʉkʉrʉ wuyo akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, nɨrakʉsabha, tujɨ kumumura waanɨ, akɨɨrɨ kukwa.” ");
INSERT INTO ikz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nawe Yɨɨsu akamʉgarukirya, “Nuujɨ, umumura waazʉ ahʉrirɨ.” Ʉmʉkʉrʉ wuyo akiisirirya amangʼana ganʉ Yɨɨsu aamubhuuriirɨ, akabhʉʉka kuja ɨwaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tabhʉʉri waho, hanʉ aarɨ mʉnzɨra, akarumana na abhahocha bhaazɨ, bhʉʉsi bhakamʉbhʉʉrɨra, umumura waazɨ ahʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Neho akabhabhuurya ɨsa yɨnʉ aatangirɨ kohora. Bhakamʉgarukirya, “Ehooma ɨkaamʉka kwɨma izʉ, ɨsa muhungatɨ umwise.” ");
INSERT INTO ikz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mmbe, wiisɨ umwana wuyo akamenya kʉbha, ahʉrirɨ kwɨma ribhaga riryarirya Yɨɨsu aagambirɨ, “Umumura waazʉ ahʉrirɨ.” Ʉmʉkʉrʉ wuyo hamwɨmwɨ na abhaatʉ bhʉʉsi bha yɨɨka waazɨ, bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kɨnʉ charɨ ichɨrɨkɨnʼyʉ cha kabhɨrɨ kɨnʉ Yɨɨsu aakʉrirɨ mucharʉ cha Gariraaya, hanʉ aruurɨ mucharʉ cha Yudeya. ");
INSERT INTO ikz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mmbe, hanʉ gayo gaasirirɨ, Yɨɨsu akaja Yɨrusarɨɨmu kurya isigukuru endebhe ya Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yɨrusarɨɨmu muyo, chareho ikishoko kɨkʉrʉ kɨnʉ kikubhirikirwa Ikishoko cha Zɨngʼʉndu. Haguhɨ ni ikishoko kiyo, kwarɨ na ritabha rɨnʉ rikubhirikirwa mʉKɨɨbhuraaniya Bhɨtizaata. Ritabha riyo riinaarirwɨ na amabhuru ataanʉ ganʉ gaarɨ nɨ ɨkɨkʉngʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mʉmabhuru gayo, bhaarɨ bharahindɨramu abharwɨrɨ bhaaru, abhahʉku, abharema na bhanʉ bhakuurɨ ibhiimʉ. Bhaarɨ bhararɨnda amanzi gabhuswɨ, ");
INSERT INTO ikz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kʉ kʉbha maraika wa Mungu aarɨ araaza kubhusa amanzi mwitabha muyo. Umurwɨrɨ wʉnʉ aarɨ we embere kusikɨra mʉmanzi, wuyo aarɨ arahora ubhurwɨrɨ bhʉnʉ aarɨ nabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gatɨ waabhʉ, aarɨmu umusubhɨ wʉmwɨ wʉnʉ aarɨ umurwɨrɨ kwibhaga ryi imyaka merongo ɨtatʉ nɨ ɨnaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Neho Yɨɨsu akamorora ahindiirɨ hayo, akamenya kʉbha ʉmʉʉtʉ wuyo arwarirɨ kwibhaga irɨɨhu. Akamubhuurya, “Oreenda kohora?” ");
INSERT INTO ikz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Umurwɨrɨ wuyo akagarukirya Yɨɨsu, “Ʉmʉkʉrʉ, nɨtaana ʉmʉʉtʉ wʉ ʉkʉntʉʉra mwitabha hanʉ amanzi gakubhuswa. Hanʉ nikwenda kusikɨra mʉmanzi, ʉmʉʉtʉ ʉwʉndɨ ahaankangatɨra kusikɨra muyo.” ");
INSERT INTO ikz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Neho Yɨɨsu akamʉbhʉʉrɨra, “Imɨɨrɨra! Gega ɨkɨragʉ chazʉ, ujɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hayohayo, ʉmʉʉtʉ wuyo akahora, akiitwɨka ɨkɨragʉ chazɨ, akatanga kogenda. Rʉnʉ ringʼana rɨnʉ ryakʉrirwɨ rwarɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kʉgayo, abhakangati bha Abhayaahudi bhakabhʉʉrɨra ʉmʉʉtʉ wʉnʉ aahʉriibhwɨ, “Reero ni‑rusikʉ rwʉ ʉbhʉtʉʉrʉ. Imigirʉ jɨtʉ gɨtakwisirirya kogega ɨkɨragʉ chazʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nawe akabhuga, “Ʉmʉʉtʉ wʉnʉ aahʉriryɨ, newe aambuuriirɨ, ‘Gega ɨkɨragʉ chazʉ, ujɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Abhakangati bhayo bhakamubhuurya, “Nɨ‑wɨɨwɨ wʉnʉ akubhuuriirɨ kokorabhu?” ");
INSERT INTO ikz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nawe ataamʉmɨnyirɨ wʉnʉ aamʉhʉriryɨ, kʉ kʉbha Yɨɨsu atarʉrɨkɨɨnɨ kwikɨ mwiribhita ikʉrʉ rya abhaatʉ bhanʉ bhaareho. ");
INSERT INTO ikz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hanʉ gayo gaasirirɨ, Yɨɨsu akabhona ʉmʉʉtʉ wuyo mwihekaaru, akamʉbhʉʉrɨra, “Itegeerera, nangʉ ʉhʉrirɨ. Ʉtagarʉkɨra kokora ʉbhʉbhɨ, ʉtaaza kʉnyaaka kʉkɨra chɨmbu waarɨ kʉnyaaka.” ");
INSERT INTO ikz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Rogendo rʉmwɨ, ʉmʉʉtʉ wuyo akaja kʉbhakangati bha Abhayaahudi, akabhabhʉʉrɨra, Yɨɨsu newe aamʉhʉriryɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Neho abhakangati bha Abhayaahudi bhakatanga kʉnyaacha Yɨɨsu, kʉ kʉbha aarɨ arahorya abhaatʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nawe Yɨɨsu akabhabhʉʉrɨra, “Bhaabha arahocha emeremo sikʉ zʉʉsi, na niinyɨ nɨrakora ɨbhuɨbhu.” ");
INSERT INTO ikz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mmbe, igʉrʉ wa amangʼana gayo, abhakangati bha Abhayaahudi bhakatanga komohya ɨnzɨra yu ukwita Yɨɨsu. Bhaarɨ bhareenda kokorabhu, kʉ kʉbha Yɨɨsu aarɨ arasarya imigirʉ jʉ ʉbhʉtʉʉrʉ, nawe ɨkɨbhɨ bhʉkʉngʼu nɨ‑kʉ kʉbha aarɨ arabhuga, Mungu ni‑Wiisɨ. Kʉ kʉgambabhu, aarɨ ariikorya kʉbha angɨ Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yɨɨsu akabhʉʉrɨra abhakangati bhayo, “Nɨrabhabhʉʉrɨra amaheene, Umwana wa Mungu atakʉtʉra kokora ryʉryʉsi, nawe arakora ganʉ akorora Wiisɨ arakora. Ganʉ Wiisɨ akokora, nego Umwana akokora. ");
INSERT INTO ikz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wiisɨ asɨɨgirɨ Umwana waazɨ, na aramwerecha emeremo jʉsi gɨnʉ akokora. Na aramwerecha chɨmbu araakore amangʼana amakʉrʉ kʉkɨra ganʉ aarɨ akʉrirɨ, na niimwɨ mʉrarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chɨmbu Wiisɨ akuryʉra abhaku na kʉbhaha ʉbhʉhʉru, ɨbhuɨbhu Umwana wʉʉsi arabhaha ʉbhʉhʉru abhaatʉ bhanʉ akwenda kʉbhaha. ");
INSERT INTO ikz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wiisɨ atakʉtɨnɨra ʉmʉʉtʉ wʉwʉʉsi, nawe amʉhɨɨrɨ Umwana waazɨ ʉbhʉnaja bhwʉsi bhwʉ ʉkʉtɨnɨra abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kʉnzɨra yiyo, abhaatʉ bhʉʉsi bharasʉʉka Umwana chɨmbu bhakʉsʉʉka Wiisɨ. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ atakʉsʉʉka Umwana, wuyo atakʉsʉʉka Wiisɨ wʉnʉ aamutumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwigwa amangʼana gaanɨ na kwisirirya Mungu wʉnʉ antumirɨ, wuyo anʉ ʉbhʉhʉru bhwa kemerano. Ʉmʉʉtʉ wuyo atakutinirwa, nawe amarirɨ kwambʉka kurwa muruku na kusikɨra mʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nɨrabhabhʉʉrɨra amaheene, ribhaga rɨraaza, na ribhaga riyo rɨmarirɨ kuhika, abhaku bhariigwa riraka ryu Umwana wa Mungu. Neho abhaatʉ bhanʉ bhakʉbha bharamwitegeerera, bharabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chɨmbu Wiisɨ arɨ isimʉka yʉ ʉbhʉhʉru bhwa kemerano, ɨbhuɨbhu amʉhɨɨrɨ Umwana waazɨ kʉbha isimʉka yʉ ʉbhʉhʉru bhuyo. ");
INSERT INTO ikz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na amʉhɨɨrɨ Umwana waazɨ ʉbhʉnaja bhwʉ ʉkʉtɨnɨra abhaatʉ, kʉ kʉbha ewe newe Umwana wʉ Ʉmʉʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mʉtarʉgʉʉra amangʼana gayo! Rɨraaza ribhaga rɨnʉ abhaku bhʉʉsi bhakwigwa riraka ryu Umwana wʉ Ʉmʉʉtʉ, ");
INSERT INTO ikz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bhʉʉsi bhararyʉka na kurwa muzimbihɨra. Abhaatʉ bhanʉ bhaarɨ bharakora amazʉmu, bharahaabhwa ʉbhʉhʉru bhwa kemerano, nawe bhanʉ bhaarɨ bharakora amabhɨ, bharatinirwa. ");
INSERT INTO ikz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kɨtareeho kegero chʉchʉsi kɨnʉ nɨkʉtʉra kokora. Nɨratɨnɨra abhaatʉ chɨmbu Bhaabha akʉmbʉʉrɨra. Ɨtɨnɨrʉ yaanɨ ne‑ye eheene, kʉ kʉbha nɨtakokora chɨmbu inyimwene nikwenda, nawe nɨrakora chɨmbu akwenda Bhaabha wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nɨraabhamenyeekererye amangʼana gaanɨ inyimwene, mʉtakʉtʉra kwisirirya ʉbhʉmɨnyɨɨkɨrɨri bhwanɨ kʉbha bhwa amaheene. ");
INSERT INTO ikz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nawe areho ʉwʉndɨ wʉnʉ akomenyeekererya amangʼana gaanɨ kwa niimwɨ, na niinyɨ nɨɨzɨ kʉbha, ʉbhʉmɨnyɨɨkɨrɨri bhwazɨ nɨ‑bhwa maheene. ");
INSERT INTO ikz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Imwɨ mʉkatʉma abhahiri kwa Yoohana Ʉmʉbhatiizi, wʉʉsi akagamba amaheene igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Inyɨ nɨtakwisega ʉbhʉmɨnyɨɨkɨrɨri bhwa abhaatʉ, nawe nɨrabhabhʉʉrɨra gʉʉsi gayo, korereke mʉsabhurwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoohana Ʉmʉbhatiizi aarɨ nchɨ ɨkɨmʉrɨ kɨnʉ kikwaka na kʉmʉrɨka mukiirimya, na niimwɨ mʉkazomererwa ubhwɨrʉ bhuyo kwibhaga isuuhu. ");
INSERT INTO ikz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nawe inyɨ nɨnʉ ʉbhʉmɨnyɨɨkɨrɨri bhʉkʉrʉ kʉkɨra bhwa Yoohana bhurya, nejo emeremo gɨnʉ Bhaabha angʼɨɨrɨ kuhicha. Emeremo janɨ gereerecha kʉbha, Bhaabha newe antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nawe Bhaabha wʉnʉ antumirɨ, umwene amɨnyɨɨkɨrɨɨryɨ kwa niimwɨ. Imwɨ mʉkɨɨrɨ kwigwa riraka ryazɨ, nʉʉrʉ korora chɨmbu arɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Amangʼana gaazɨ, gatakwikara kwa niimwɨ, kʉ kʉbha mʉtakwisirirya wʉnʉ aatumirwɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Mʉrakora umucha komohya Amaandɨkʉ Amarɨndu, kʉ kʉbha mʉrakina mʉratʉra kobhonamu ʉbhʉhʉru bhwa kemerano. Mmbe nangʉ, Amaandɨkʉ gayo nego gakomenyeekererya inyɨ! ");
INSERT INTO ikz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nawe mʉraanga kuuza kwa niinyɨ, korereke mobhone ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Inyɨ nɨtakwisega ubhukumya kurwa kʉbhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nawe nɨɨzɨ chɨmbu imwɨ mʉrɨ, mʉtaana ʉbhʉsɨɨgi bhwa Mungu mozekoro zaanyu. ");
INSERT INTO ikz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inyɨ niizirɨ kʉbhʉnaja bhwa Bhaabha, nawe mʉraanga kʉnsʉngʼaana. Nawe ʉmʉʉtʉ ʉwʉndɨ araazɨ kʉbhʉnaja bhwazɨ umwene, ewe mʉramʉsʉngʼaana. ");
INSERT INTO ikz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imwɨ mʉsɨɨgirɨ kukumibhwa na abhakɨndichanyu, nawe mʉtakomohya ubhukumya bhʉnʉ bhukurwa kwa Mungu umwene. Nangʉ, mʉratʉrabhwɨ kunyiisirirya inyɨ? ");
INSERT INTO ikz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉtakina kʉbha, inyɨ nɨrabhagamba kwa Bhaabha. Musa newe akʉbhagamba, kʉ kʉbha wuyo newe mukwisega. ");
INSERT INTO ikz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arɨɨbhɨ heene mwangiisiriiryɨ amangʼana ga Musa, mmbe, inyʉʉsi mwarɨ mʉranyiisirirya, kʉ kʉbha Musa akaandɨka amangʼana igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nawe arɨɨbhɨ mʉtakwisirirya amangʼana ganʉ gaandikirwɨ na Musa, mʉratʉrabhwɨ kwisirirya amangʼana gaanɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Akʉmara Yɨɨsu akaambʉka ɨnyanza ya Gariraaya, yɨnʉ iriina ɨrɨndɨ ɨnyanza ya Tibhɨɨriya. ");
INSERT INTO ikz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Riribhita ikʉrʉ rya abhaatʉ bhaarɨ bharatuna Yɨɨsu, kʉ kʉbha bhaarɨ bharʉʉzɨ ibhyɨrɨkɨnʼyʉ bhɨnʉ aakʉrirɨ kʉbharwɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Neho Yɨɨsu akatiira kʉkɨgʉrʉ hamwɨmwɨ na abhɨɨga bhaazɨ, akiikara nabhʉ iyo. ");
INSERT INTO ikz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ribhaga riyo, isigukuru yɨ Ɨpasaka ya Abhayaahudi, yaarɨ haguhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hanʉ Yɨɨsu aanungirɨ amɨɨsʉ, akarora riribhita ikʉrʉ rya abhaatʉ bhanʉ bhaarɨ bharaaza kwewe. Neho akabhuurya Firipʉ, “Nangʉ, tʉratʉra kʉgʉra hayi ibhyakurya bhyu kuriisha abhaatʉ bhanʉ bhʉʉsi?” ");
INSERT INTO ikz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yɨɨsu akabhuurya Firipʉ kwa komogema, nangabha aarɨ amɨnyirɨ kɨnʉ araakore. ");
INSERT INTO ikz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Firipʉ akamʉgarukirya, “Nʉʉrʉ twangagurirɨ ibhyakurya bhya zidinaari magana abhɨrɨ, tʉbhasondye bhisuuhu bhisuuhu bhɨtaarɨ bhɨrabhiisa.” ");
INSERT INTO ikz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Neho Andureya, wʉnʉ aarɨ umwɨga ʉwʉndɨ wa Yɨɨsu, nu umuhiiri wa Simʉʉni Peetero, akabhʉʉrɨra Yɨɨsu, ");
INSERT INTO ikz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Areho hanʉ mumura wʉmwɨ anɨ ɨmɨkaatɨ ɨtaanʉ jɨ ɨshayiri na ziiswɨ ibhɨrɨ. Nawe ibhyakurya bhɨnʉ bhɨratʉra kwisa riribhita ryʉsi rɨnʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mmbe, Yɨɨsu akaswaja abhɨɨga bhaazɨ, “Mʉbhabhʉʉrɨrɨ abhaatʉ bhiikarɨ haasɨ.” Ahagero hayo, haarɨ nʉ ʉbhʉnyaaki bhwaru. Neho abhaatʉ bhʉʉsi, bhakiikara haasɨ. Gatɨ waabhʉ, bhaarɨmu abhasubhɨ bhɨkwɨ bhɨtaanʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Akʉmara, Yɨɨsu akagega ɨmɨkaatɨ giyo, akabhʉʉrɨra Mungu azʉmiryɨ, akasondya abhaatʉ bhʉʉsi bhanʉ bhaarɨ bhiikɨɨrɨ. Akakora ɨbhuɨbhu na ziiswɨ zʉʉsi, akabhasondya. Abhaatʉ bhʉʉsi bhakarya chɨmbu bhɨɨndirɨ kurya. ");
INSERT INTO ikz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hanʉ abhaatʉ bhʉʉsi bhiigutirɨ, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Mubhiringɨ ibhyakurya bhyʉsi bhɨnʉ bhɨsaagirɨ, korereke bhɨtaaza kʉsarɨka.” ");
INSERT INTO ikz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mmbe, bhakabhiringa ebhekenyeka bhyʉsi, na bhakiizurya bhɨhʉʉzʉ ikumi na bhɨbhɨrɨ kwa bhekenyeka bhyɨ ɨmɨkaatɨ bhɨtaanʉ bhyɨ ɨshayiri bhɨnʉ bhyasaagirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hanʉ abhaatʉ bhayo bharʉʉzɨ ɨkɨsɨgʉ kɨnʉ Yɨɨsu aakʉrirɨ, bhakabhuga, “Maheene ʉmʉʉtʉ wʉnʉ newe ʉmʉrʉʉtɨrɨri wa Mungu wʉnʉ tukwisega kʉbha araaza kʉʉsɨ kʉnʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yɨɨsu akamenya kʉbha abhaatʉ bhayo bhareenda kumugwata kwa amanaga, korereke abhɨ ʉmʉtɨmi waabhʉ. Nawe akarwa hayo, akaja naatu kʉkɨgʉrʉ umwene haawɨɨsi. ");
INSERT INTO ikz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rigoroobha, abhɨɨga bha Yɨɨsu bhakahiringita kuja kʉnyanza ya Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhakasikɨra mubhwatʉ, na kʉtanga kwambʉka ɨnyanza kuja ʉrʉbhɨri rwa Kapɨrinaumu. Ribhaga riyo, yaarɨ ikiirimya, nawe Yɨɨsu aarɨ akɨɨrɨ kuhika kugwatana nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mmbe, ʉmʉkama ʉmʉhaari gwarɨ gʉrahuuta, ɨnyanza ɨkabhuusuka. ");
INSERT INTO ikz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hanʉ abhɨɨga bha Yɨɨsu bhaahikirɨ obhokore bhwa bhikubha bhɨtaanʉ hamwɨ bhɨsaasabha, bhakarora Yɨɨsu aragenda kʉmanzi na kwisukɨra ubhwatʉ bhwabhʉ. Bhakʉʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Neho, Yɨɨsu akabhabhʉʉrɨra, “Mʉtʉʉbhaha! Niinyɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mmbe, ebho bhakeenda atiirɨ mubhwatʉ. Hayohayo, ubhwatʉ bhʉkahika imwambʉkʉ hanʉ bhaarɨ bhakuja. ");
INSERT INTO ikz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tabhʉʉri waho, riribhita rya abhaatʉ bhanʉ bhasaagirɨ imwambʉkʉ wɨ ɨnyanza, bhakangʼura kwarɨ nu ubhwatʉ bhʉmwɨbhu hayo. Bhakamenya kʉbha Yɨɨsu atagiirɨ mubhwatʉ hamwɨmwɨ na abhɨɨga bhaazɨ, nawe abhɨɨga bhaazɨ bhakaja abheene. ");
INSERT INTO ikz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Akʉmara, abhaatʉ abhandɨ bhakaaza nu ubhwatʉ kurwa mʉrʉbhɨri rwa Tibhɨɨriya, bhakahika hanʉ riribhita rya abhaatʉ bhaariirɨ ɨmɨkaatɨ, hanʉ Ʉmʉkʉrʉ Yɨɨsu aarɨ akumiryɨ Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hanʉ riribhita rya abhaatʉ bhayo bharʉʉzɨ Yɨɨsu ataareho hayo, na abhɨɨga bhaazɨ bhʉʉsi bhataareho, bhakasikɨra mubhwatʉ bhuyo, bhakaja Kapɨrinaumu komohya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hanʉ abhaatʉ bhayo bhaahikirɨ imwambʉkʉ wɨ ɨnyanza, bhakabhona Yɨɨsu, bhakamubhuurya, “Umwija, ʉkaaza ɨnʉ ryʉrɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yɨɨsu akabhagarukirya, “Nɨrabhabhʉʉrɨra amaheene, mʉramonhya kʉ kʉbha nɨkabhaha ɨmɨkaatɨ, mʉkarya mukiigʉta, ɨtarɨ kʉ kʉbha moreenda ukwobhoora ibhyɨrɨkɨnʼyʉ bhɨnʉ naakʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉtakora emeremo igʉrʉ wo kobhona ibhyakurya bhɨnʉ bhɨkʉsarɨka, nawe mʉbhɨ mʉrakora emeremo igʉrʉ wo okobhona ibhyakurya bhɨnʉ bhɨtakʉsarɨka, na bhɨnʉ bhɨkʉbhaha ʉbhʉhʉru bhwa kemerano. Umwana wʉ Ʉmʉʉtʉ arabhaha ibhyakurya bhiyo, kʉ kʉbha Bhaabha Mungu amʉhɨɨrɨ ʉbhʉnaja bhwo okokorabhu.” ");
INSERT INTO ikz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Neho ebho bhakamubhuurya, “Nangʉ, tokorekɨ korereke tobhone kokora amangʼana ganʉ Mungu akwenda?” ");
INSERT INTO ikz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yɨɨsu akabhagarukirya, “Ringʼana rɨnʉ Mungu akwenda mokore, ni‑kwisirirya wʉnʉ aamutumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhakamubhuurya, “Ʉrakora chɨrɨkɨnʼyʉkɨ, korereke torore tʉtʉrɨ kukwisirirya? Ʉrakora kɨgʉrʉkɨ? ");
INSERT INTO ikz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hanʉ bhasʉʉkʉrʉ bhɨɨtʉ, bhaarɨ kʉkɨbhara, bhakarya ibhyakurya bhya mana. Yandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Akabhaha ichakurya cha kurwa mwisaarʉ bharyɨ.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mmbe, Yɨɨsu akabhabhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, atarɨ Musa wʉnʉ abhahɨɨrɨ bhawʉsʉʉkʉrʉ ibhyakurya bhiyo kurwa mwisaarʉ, nawe nɨ‑Bhaabha waanɨ. Ewe newe akʉbhaha ibhyakurya bhye eheene kurwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ibhyakurya bhya Mungu nɨ‑bhɨnʉ bhikwika kurwa mwisaarʉ, korereke abhahɨ abhaatʉ bhʉʉsi bhɨ ɨɨsɨ yɨnʉ ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Neho bhakamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, otohe ibhyakurya bhiyo sikʉ zʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yɨɨsu akabhuga, “Inyɨ niinyɨ ibhyakurya bhɨnʉ bhekoha abhaatʉ ʉbhʉhʉru bhwa kemerano. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akuuza kwa niinyɨ na kunyiisirirya, atakwigwa ɨnzara, nʉʉrʉ kwigwa enyoota kwikɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Nawe inyɨ nɨkabhabhʉʉrɨra, mʉndʉʉzɨ, nawe mʉtakunyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abhaatʉ bhʉʉsi bhanʉ Bhaabha akongʼa, bharaaza kwa niinyɨ na kunyiisirirya. Inyɨ nɨtakwanga nʉʉrʉ wʉmwɨ wʉnʉ akuuza kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Inyɨ nitiizirɨ kurwa mwisaarʉ korereke nekore chɨmbu nikwenda, nawe korereke nɨbhɨ nɨrakora chɨmbu Bhaabha wʉnʉ antumirɨ akwenda. ");
INSERT INTO ikz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bhaabha waanɨ wʉnʉ antumirɨ areenda, nɨtarimirya nʉʉrʉ ʉmʉʉtʉ wʉmwɨ mʉbhanʉ angʼɨɨrɨ, nawe nɨbharyʉrɨ bhʉʉsi urusikʉ rwɨ ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kɨnʉ Bhaabha waanɨ akwenda nɨ‑kʉbha, abhaatʉ bhʉʉsi bhanʉ bhamɨnyirɨ kʉbha, inyɨ ni‑Mwana waazɨ na kunyiisirirya, bhabhɨ nʉ ʉbhʉhʉru bhwa kemerano. Inyɨ nɨrabharyʉra urusikʉ rwɨ ɨtɨnɨrʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mmbe, Abhayaahudi bha hayo, bhakatanga kʉrɨrɨɨrɨra kʉ kʉbha Yɨɨsu akiikoonʼya, “Inyɨ niinyɨ ibhyakurya bhɨnʉ bhyikirɨ kurwa mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakiibhuurya, “Nangʉ, ʉmʉʉtʉ wʉnʉ atarɨ Yɨɨsu, umwana wa Yuusufu? Na abhiibhuri bhaazɨ tʉbhɨɨzɨ! Nangʉ, aratʉrabhwɨ kubhuga iikirɨ kurwa mwisaarʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yɨɨsu akabhagarukirya, “Mutigɨ kʉrɨrɨɨrɨra abheene kobheene. ");
INSERT INTO ikz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kuuza kwa niinyɨ, arɨɨbhɨ akɨɨrɨ kʉkangatwa na Bhaabha wʉnʉ antumirɨ. Na niinyɨ nɨrabharyʉra urusikʉ rwɨ ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yandikirwɨ mʉMaandɨkʉ Amarɨndu ga abharʉʉtɨrɨri kʉbha, ‘Abhaatʉ bhʉʉsi bhariigibhwa na Mungu.’ Mmbe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwitegeerera na kwɨga kurwa kwa Bhaabha, araaza kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Atareeho ʉmʉʉtʉ wʉnʉ amʉrʉʉzɨ Bhaabha Mungu, kuruushaku inyimwene niinyɨ nɨmʉrʉʉzɨ, kʉ kʉbha nɨkarwa kwewe. ");
INSERT INTO ikz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwisirirya, arabha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inyɨ niinyɨ ibhyakurya bhɨnʉ bhekoha abhaatʉ ʉbhʉhʉru bhuyo. ");
INSERT INTO ikz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nangabha bhawʉsʉʉkʉrʉ bhariirɨ ibhyakurya bhya mana kʉkɨbhara, nawe bhakakwa. ");
INSERT INTO ikz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nawe hanʉ bhereho ibhyakurya bhɨnʉ bhyikirɨ kurwa mwisaarʉ. Ʉmʉʉtʉ araaryɨ ibhyakurya bhiyo, atakukwa. ");
INSERT INTO ikz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inyɨ niinyɨ ibhyakurya bhɨnʉ bhyiikirɨ kurwa mwisaarʉ, bhɨnʉ bhekoha abhaatʉ ʉbhʉhʉru bhwa kemerano. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akurya ibhyakurya bhiyo, arabha nʉ ʉbhʉhʉru bhwa kemerano. Ibhyakurya bhiyo nɨ‑mʉbhɨrɨ gwanɨ gʉnʉ niriihuruchɨ igʉrʉ wa abhaatʉ bhʉʉsi bhɨ ɨɨsɨ yɨnʉ, korereke bhabhɨ nʉ ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mmbe, Abhayaahudi bhayo bhakatanga kʉhakaana bhʉkʉngʼu, bhariibhuurya, “Ʉmʉʉtʉ wʉnʉ, aratʉrabhwɨ kotoha ʉmʉbhɨrɨ gwazɨ, korereke turyɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kʉgayo, Yɨɨsu akabhabhʉʉrɨra, “Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ mʉtakurya ʉmʉbhɨrɨ gu Umwana wʉ Ʉmʉʉtʉ, na kunywa amasaahɨ gaazɨ, mʉtakʉbha nʉ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akurya ʉmʉbhɨrɨ gwanɨ na kunywa amasaahɨ gaanɨ, wuyo anʉ ʉbhʉhʉru bhwa kemerano, na niinyɨ nɨramuryʉra urusikʉ rwɨ ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Momenye kʉbha, ʉmʉbhɨrɨ gwanɨ negwe ibhyakurya bhye eheene, na amasaahɨ gaanɨ nego chukunywa cha amaheene. ");
INSERT INTO ikz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akurya ʉmʉbhɨrɨ gwanɨ na kunywa amasaahɨ gaanɨ, wuyo arasaaga kwa niinyɨ, na niinyɨ nɨrasaaga kwewe. ");
INSERT INTO ikz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bhaabha wʉnʉ antumirɨ nɨ‑mʉhʉru, na niinyɨ nɨrabhona ʉbhʉhʉru kurwa kwewe. Ɨbhuɨbhu, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akundya inyɨ, arabhona ʉbhʉhʉru kurwa kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mmbe, bhiyo nebhyo ibhyakurya bhɨnʉ bhiikirɨ kurwa mwisaarʉ. Ibhyakurya bhiyo bhɨtatuubhɨɨnɨ ni ibhyakurya bhɨnʉ bhawʉsʉʉkʉrʉ bhariirɨ. Ebho bhakakwa. Nawe ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akurya ibhyakurya bhɨnʉ, arabha nʉ ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yɨɨsu akagamba amangʼana gayo, hanʉ aarɨ ariija mwirwazɨrʉ rya Kapɨrinaumu. ");
INSERT INTO ikz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hanʉ abhaatʉ bhaaru gatɨ wa abhɨɨga bhaazɨ bhiigwirɨ amangʼana gayo, bhakabhuga, “Amiija ganʉ nɨ‑makʉngʼu bhʉkʉngʼu! Wɨɨwɨ aratʉra kugiisirirya?” ");
INSERT INTO ikz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yɨɨsu akamenya, abhɨɨga bhaazɨ bhararɨrɨɨrɨra igʉrʉ wa amangʼana ganʉ aarɨ agambirɨ, kʉgayo akabhabhuurya, “Nangʉ, ringʼana rɨnʉ ribhiigatɨɨnʼyɨ? ");
INSERT INTO ikz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɨrabhabhwɨ hanʉ mokorora Umwana wʉ Ʉmʉʉtʉ, aratiira kuja mwisaarʉ ɨnʉ aarɨ? ");
INSERT INTO ikz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ekoro ya Mungu neyo ɨkʉbhaha abhaatʉ ʉbhʉhʉru bhwa kemerano. Ʉmʉʉtʉ atakʉtʉra kokora chʉchʉsi kʉmanaga gaazɨ umwene haawɨɨsi. Amangʼana ganʉ nɨbhabhuuriirɨ ne‑ge Ekoro ya Mungu, na garareeta ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nawe bhareho abhandɨ gatɨ waanyu bhanʉ bhakɨɨrɨ kwisirirya.” Yɨɨsu akagambabhu, kʉ kʉbha akamenya kwɨma ʉbhʉtangɨ, nɨ‑bha wɨɨwɨ bhanʉ bhatakumwisirirya, na kʉbha nɨ‑wɨɨwɨ wʉnʉ araamwichʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mmbe, akangʼeha kʉbhabhʉʉrɨra, “Kiyo necho kigiriryɨ nɨbhabhuuriirɨ, atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kuuza ɨwaanɨ, arɨɨbhɨ akɨɨrɨ kʉkangatwa na Bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwɨma hanʉ bhiigwirɨ amangʼana gayo, bhaaru gatɨ wa abhɨɨga bhaazɨ, bhakamutiga, bhataagɨndirɨ nawe kwikɨ. ");
INSERT INTO ikz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Neho Yɨɨsu akabhuurya abhɨɨga bhaazɨ ikumi na bhabhɨrɨ, “Nangʉ, na niimwɨ moreenda kuntiga?” ");
INSERT INTO ikz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simʉʉni Peetero akamʉgarukirya, “Ʉmʉkʉrʉ, tujɨ kwa wɨɨwɨ? Awɨ ʉna amangʼana ganʉ gakotoha ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Itwɨ tʉrakwisirirya na tʉmɨnyirɨ kʉbha, awɨ naawɨ Ʉmʉrɨndu kurwa kwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Neho Yɨɨsu akabhabhʉʉrɨra, “Nɨrʉbhwɨrɨ imwɨ ikumi na bhabhɨrɨ kʉbha abhɨɨga bhaanɨ, nawe wʉmwɨ gatɨ waanyu nɨ‑wa Shɨtaani.” ");
INSERT INTO ikz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hayo Yɨɨsu aarɨ aragambɨra Yuuda, umwana wa Simʉʉni Isikariyʉʉti. Yuuda wuyo newe iichurirɨ Yɨɨsu, nangabha aarɨ wʉmwɨ gatɨ wa abhɨɨga bhaazɨ ikumi na bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Akʉmara Yɨɨsu akatanga kwiruguura mucharʉ cha Gariraaya. Atɨɨndirɨ kwiruguura mucharʉ cha Yudeya, kʉ kʉbha abhakangati bha Abhayaahudi bhaarɨ bhareenda kumwita. ");
INSERT INTO ikz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ribhaga riyo, isigukuru ya Amabhuru ya Abhayaahudi yaarɨ ɨrariirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Neho abhanyi bha Yɨɨsu bhakamʉbhʉʉrɨra, “Ʉtasaaga hanʉ, ujɨ Yudeya, korereke abhɨɨga bhaazʉ bharore ɨbhɨsɨgʉ bhɨnʉ okokora. ");
INSERT INTO ikz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Arɨɨbhɨ ʉmʉʉtʉ areenda akumukɨ kʉbhaatʉ, atahocha emeremo jazɨ kwa mbisi. Mmbe, arɨɨbhɨ awɨ ʉratʉra kokora amangʼana gayo, nuujɨ wiiyeerekenʼye kʉbhaatʉ bhʉʉsi, korereke bhakomenye.” ");
INSERT INTO ikz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abhanyi bhaazɨ bhakabhugabhu, kʉ kʉbha nʉʉrʉ ebho abheene bhatiisiriiryɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Neho Yɨɨsu akabhabhʉʉrɨra, “Ribhaga ryanɨ ryu ukuja iyo, rɨkɨɨrɨ kuhika, nawe imwɨ mʉratʉra kuja ribhaga ryʉryʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abhaatʉ bhɨ ɨɨsɨ yɨnʉ, bhataana cha kʉbhabhiihirirwa imwɨ. Nawe bharambiihirirwa inyɨ, kʉ kʉbha nɨrabhabhʉʉrɨra, amahocha gaabhʉ nɨ‑mabhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imwɨ abheene, mujɨ Yɨrusarɨɨmu kurya isigukuru. Inyɨ nɨtakuja, kʉ kʉbha ribhaga ryanɨ rɨkɨɨrɨ kuhika.” ");
INSERT INTO ikz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo, akasaaga Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nawe hanʉ abhanyi bhaazɨ bhaagiirɨ Yɨrusarɨɨmu kurya isigukuru yiyo, Yɨɨsu wʉʉsi akaja iyo, nawe kwa mbisi, atiiyɨrɨkiryɨ habhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mmbe, ribhaga ryi isigukuru, abhakangati bha Abhayaahudi bhakatanga komohya Yɨɨsu, bhakabhuurya abhaatʉ, “Arɨ hayi ʉmʉʉtʉ wurya?” ");
INSERT INTO ikz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Abhaatʉ bhaaru bhakabha bharahakaana igʉrʉ wa Yɨɨsu. Abhandɨ bhakabhuga, “Yɨɨsu nɨ‑mʉʉtʉ mʉzʉmu,” nawe abhandɨ bhakabhuga, “Zɨyi, arakangirirya abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nawe ataarɨ areho ʉmʉʉtʉ wʉnʉ aarɨ mʉkararu kʉgamba Yɨɨsu habhwɨrʉ, kʉ kʉbha bhakʉʉbhaha abhakangati bha Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hanʉ zisikʉ zi isigukuru zaahikirɨ gatɨgatɨ, Yɨɨsu akaja, akasikɨra mwihekaaru, akatanga kwija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Neho abhakangati bha Abhayaahudi bhakarʉgʉʉra kumiija gaazɨ, bhakabhuga, “Nangʉ, ʉmʉʉtʉ wʉnʉ aratʉrabhwɨ komenya gʉʉsi ganʉ, neewe ataarɨ mʉsʉmi bhʉkʉngʼu?” ");
INSERT INTO ikz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mmbe, Yɨɨsu akabhabhʉʉrɨra, “Amiija ganʉ nikwija, gatarɨ gaanɨ, nawe garuurɨ kwa wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwenda kokora chɨmbu Mungu akwenda, aramenya kʉbha, amiija gaanɨ garuurɨ kwa Mungu, hamwɨ nɨragamba kʉbhʉnaja bhwanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akʉgamba kʉbhʉnaja bhwazɨ umwene, wuyo ariimooherya ubhukumya kwewe umwene. Nawe wʉnʉ akomohya ubhukumya kwa wʉnʉ aamutumirɨ, wuyo aragamba amaheene, atakʉgamba ʉrʉrɨmɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yɨɨsu akangʼeha kʉgamba, “Mwɨzɨ kʉbha, Musa akabhaha imigirʉ ja Mungu. Nawe atareeho ʉmʉʉtʉ gatɨ waanyu wʉnʉ akugwata imigirʉ giyo. Kwakɨ moreenda kunyita?” ");
INSERT INTO ikz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Abhaatʉ bhayo bhakamʉgarukirya, “Ʉna risambwa awɨ! Nɨ‑wɨɨwɨ wʉnʉ akwenda kukwita?” ");
INSERT INTO ikz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yɨɨsu akabhagarukirya, “Nɨkakora ɨkɨsɨgʉ kɨmwɨ hanʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ, na niimwɨ imwʉsi mʉkarʉgʉʉra. ");
INSERT INTO ikz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Rora, Musa akabhaswaja kʉsaara abhaana bhaanyu bhiikisubhɨ. Ɨtarɨ kʉbha simʉka yiyo ɨkarwa kwa Musa, nawe ɨkarwɨra kʉbhawʉsʉʉkʉrʉ bhe embere. Nangʉ imwɨ mʉrasaara abhaana bhaanyu nʉʉrʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mmbe arɨɨbhɨ mʉrasaara abhaana bhaanyu bhiikisubhɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ korereke mongʼehe kugwata imigirʉ ja Musa, ndora mʉranyiigatanɨra nɨraahorye ʉmʉʉtʉ urusikʉ rwʉ ʉbhʉtʉʉrʉ? ");
INSERT INTO ikz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʉtatɨnɨra ʉmʉʉtʉ kurwa kʉmangʼana ganʉ gakororekana igʉtʉ, nawe mʉtɨnɨrɨ ʉmʉʉtʉ koheene.” ");
INSERT INTO ikz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mmbe, abhaatʉ abhandɨ bha Yɨrusarɨɨmu hayo, bhakabha bhariibhuurya, “Ʉmʉʉtʉ wʉnʉ atarɨ wʉnʉ abhakangati bhɨɨtʉ bhakwenda kwita? ");
INSERT INTO ikz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Rora, nangʉ aragamba habhwɨrʉ, nawe ebho bhatakʉmʉbhʉʉrɨra chʉchʉsi! Nangʉ, ɨratʉrɨkana, abhakangati bhɨɨtʉ bhɨɨzɨ, wuyo newe Kiriisitʉ? ");
INSERT INTO ikz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ʉmʉʉtʉ wʉnʉ, tʉmɨnyirɨ hanʉ aruurɨ. Nawe hanʉ Kiriisitʉ umwene araazɨ, atareeho ʉmʉʉtʉ wʉnʉ akomenya hanʉ aruurɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hanʉ Yɨɨsu aarɨ ariija mwihekaaru, akatiirya riraka arabhuga, “Maheene mʉnyɨzɨ, na mwɨzɨ hanʉ niruurɨ. Inyɨ nitiizirɨ kʉbhʉnaja bhwanɨ, nawe antumirɨ nɨ‑wa amaheene. Imwɨ mʉtamwɨzɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inyɨ nimwɨzɨ, kʉ kʉbha niruurɨ kwewe na newe antumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Neho abhaatʉ bhakeenda kumugwata, nawe ataareho ʉmʉʉtʉ wʉnʉ aamugwatirɨ, kʉ kʉbha ribhaga ryazɨ rɨkɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nawe, gatɨ wa abhaatʉ bhanʉ bhaarɨ hayo abhaaru bhakiisirirya Yɨɨsu. Abhaatʉ bhayo bhakabhuga, “Hanʉ Kiriisitʉ akuuza, arakora ɨbhɨsɨgʉ bhyaru kʉkɨra bhɨnʉ ʉmʉʉtʉ wʉnʉ akʉrirɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mmbe, Abhafarisaayo bhakiigwa chɨmbu riribhita rya abhaatʉ bhakumumuuza igʉrʉ wa Yɨɨsu. Kʉgayo, Abhafarisaayo bhayo, hamwɨmwɨ na abhakʉrʉ bha abhakuhaani, bhakatʉma abhasirikarɨ korereke bhagwatɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Neho Yɨɨsu akabhʉʉrɨra abhaatʉ bhayo, “Nɨrabha na niimwɨ kwibhaga isuuhubhu. Akʉmara nɨragarʉka kwa wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mʉramonhya, nawe mʉtakombona. Na hanʉ nɨkʉbha inyɨ, imwɨ mʉtakʉtʉra kuuza.” ");
INSERT INTO ikz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Neho Abhayaahudi bhakiibhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ araja hayi hanʉ itwɨ tʉtakʉtʉra komobhona? Nangʉ, areenda kuja kʉBhayaahudi bhanʉ bhanyaragɨɨnɨ icharʉ ɨkɨndɨ, na kwija abhaatʉ bhanʉ bhatarɨ Abhayaahudi? ");
INSERT INTO ikz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nangʉ, ana nzobhoorokɨ hanʉ akʉgamba kʉbha, ‘Mʉramonhya, nawe mʉtakombona. Na hanʉ nɨkʉbha inyɨ, imwɨ mʉtakʉtʉra kuuza’?” ");
INSERT INTO ikz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Urusikʉ rwʉ ʉkʉmariirya isigukuru ya Amabhuru, rwarɨ rusikʉ rʉkʉrʉ. Mmbe, Yɨɨsu akiimɨɨrɨra, akagamba kwiraka ikʉrʉ, “Ʉmʉʉtʉ ariigwɨ enyoota, aazɨ kwa niinyɨ, anywɨ amanzi! ");
INSERT INTO ikz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Amaandɨkʉ Amarɨndu garabhuga, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akunyiisirirya inyɨ, ‘Zesoromonyo za amanzi gʉ ʉbhʉhʉru zɨragera kurwa kwawe.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yɨɨsu aarɨ aragambɨra Ekoro Ɨndɨndu, yɨnʉ bhakʉhaabhwa abhaatʉ bhanʉ bhakwisirirya Yɨɨsu. Ribhaga riyo, Mungu aarɨ akɨɨrɨ kʉtʉma Ekoro yaazɨ kwebho, kʉ kʉbha aarɨ akɨɨrɨ kʉgʉnga Yɨɨsu habhwɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hanʉ abhaatʉ abhandɨ bha mwiribhita riyo bhiigwirɨ amangʼana gayo, bhakabhuga, “Maheene, ʉmʉʉtʉ wʉnʉ newe ʉmʉrʉʉtɨrɨri wʉnʉ tʉkʉrɨnda kurwa kwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abhaatʉ abhandɨ bhakabhuga, “Ʉmʉʉtʉ wʉnʉ newe Kiriisitʉ.” Nawe abhandɨ bhakabhuga, “Zɨyi, Kiriisitʉ atakʉtʉra kurwa mucharʉ cha Gariraaya. ");
INSERT INTO ikz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nangʉ, Amaandɨkʉ Amarɨndu gatakubhuga, Kiriisitʉ ararwa murwibhʉrʉ rwʉ ʉmʉtɨmi Daudi? Na ariibhurwa Bhɨtɨrɨhɨɨmu, mʉrʉbhɨri rʉnʉ Daudi iibhwirwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mmbe abhaatʉ bhakatwanɨkana igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Neho abhaatʉ bhakeenda kumugwata, nawe ataareho ʉmʉʉtʉ wʉnʉ aamugwatirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mmbe, abhasirikarɨ bhayo bhakagarʉka kʉbhakʉrʉ bha abhakuhaani na Abhafarisaayo. Abhakangati bhayo bhakabhabhuurya, “Kwakɨ mʉtagwatirɨ Yɨɨsu na komoreeta hanʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abhasirikarɨ bhayo bhakagarukirya, “Tʉkɨɨrɨ kwigwa ʉmʉʉtʉ ʉwʉndɨ wʉnʉ akʉtʉra kʉgamba nchewe.” ");
INSERT INTO ikz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Akʉmara abhakangati bhakabhabhuurya, “Nangʉ, na niimwɨ mʉmarirɨ kʉkangiriribhwa neewe? ");
INSERT INTO ikz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Areho ʉmʉkangati wʉwʉʉsi hamwɨ Ʉmʉfarisaayo nʉʉrʉ wʉmwɨ wʉnʉ akumwisirirya? ");
INSERT INTO ikz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nawe abhaatʉ bhanʉ bhakumwisirirya, ni‑ribhita rya abhaatʉ bhanʉ bhatɨɨzɨ imigirʉ ja Musa. Bhiihiimirwɨ na Mungu!” ");
INSERT INTO ikz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Neho Nikʉdɨɨmu, wʉmwɨ wa abhakangati bha Abhafarisaayo wʉnʉ aagiirɨ kwa Yɨɨsu rusikʉ rʉmwɨ ubhutikʉ, akabhuurya abhakɨndichazɨ, ");
INSERT INTO ikz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nangʉ, imigirʉ jɨtʉ giriisirirya kʉtɨnɨra ʉmʉʉtʉ tʉkɨɨrɨ kumwitegeerera na kwobhoora ganʉ akʉrirɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ebho bhakagarukirya Nikʉdɨɨmu, “Na naawɨ uruurɨ Gariraaya? Nuujɨ wiisʉnzɨ bhwaheene Amaandɨkʉ Amarɨndu, na ʉramenya kʉbha, atareeho ʉmʉrʉʉtɨrɨri wʉnʉ akurwa Gariraaya.” ");
INSERT INTO ikz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Neho bhayo bhʉʉsi bhakabhʉʉka iyo, bhakagarʉka yɨɨka. Yɨɨsu wʉʉsi akaja kʉkɨgʉrʉ chɨ Ɨmɨzɨyituuni. ");
INSERT INTO ikz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hanʉ bhwakɨɨrɨ, Yɨɨsu akaja, akasikɨra mwihekaaru. Abhaatʉ bhʉʉsi bhakaaza kwewe, akiikara, akatanga kubhiija. ");
INSERT INTO ikz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abhiija bhi imigirʉ ja Musa na Abhafarisaayo, bhakahirɨra ʉmʉkari wʉnʉ aagwatirwɨ ubhusiihya, bhakamʉtʉʉra gatɨgatɨ wa riribhita rya abhaatʉ bhayo. ");
INSERT INTO ikz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bhakabhʉʉrɨra Yɨɨsu, “Umwija, ʉmʉkari wʉnʉ, agwatirwɨ ubhusiihya. ");
INSERT INTO ikz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nangʉ, kʉrɨngʼaana ni imigirʉ ja Musa ʉmʉkari ncha wʉnʉ akatuswaja kwita, ko komotema amabhwɨ. Awɨ ʉrabhugabhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ebho bhakabhuuryabhu kwa komogema, korereke bhabhone chu ukugirya bhamʉgambɨ. Nawe Yɨɨsu akiihiinya, akatanga kwandɨka haasɨ komosekeenya ni ichara chazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hanʉ bhaangʼɨhirɨ kubhuurya, Yɨɨsu akiimɨɨrɨra, akabhagarukirya, “Arɨɨbhɨ areho wʉmwɨ gatɨ waanyu wʉnʉ akɨɨrɨ kokora ʉbhʉbhɨ nʉʉrʉ rʉmwɨ, akangatɨ komotema riibhwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mmbe, Yɨɨsu akiihiinya naatu haasɨ, akangʼeha kwandɨka komosekeenya. ");
INSERT INTO ikz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hanʉ bhiigwirɨ gayo, bhakasʉʉka. Bhakatanga kʉbhʉʉka wʉmwɨ wʉmwɨ, kwɨma abhakaruka kuhika abhamura. Mʉtɨnɨrʉ, Yɨɨsu akasaaga umwene haawɨɨsi nʉ ʉmʉkari wʉnʉ aarɨ imiiriirɨ mʉbhʉtangɨ bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Neho Yɨɨsu akiimɨɨrɨra, akamubhuurya, “Bharɨ hayi bhanʉ bhakʉkʉgamba? Atareeho wʉwʉʉsi wʉnʉ asaagirɨ korereke akʉtɨnɨrɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akamʉgarukirya, “Ʉmʉkʉrʉ, atareeho nʉʉrʉ wʉmwɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Na niinyɨ nɨtakʉkʉtɨnɨra. Nuujɨ, nawe kʉtangɨra reero, ʉtakora ʉbhʉbhɨ kwikɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yɨɨsu akangʼeha kʉgamba, “Inyɨ niinyɨ ubhwɨrʉ bhwi icharʉ. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akuntuna, atakogenda mukiirimya nangabha hasuuhu, nawe arabha nu ubhwɨrʉ bhʉnʉ bhʉkʉmʉkangata mʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abhafarisaayo bhakabhʉʉrɨra Yɨɨsu, “Awɨ uriimenyeekererya aumwene. Ʉbhʉmɨnyɨɨkɨrɨri bhwazʉ bhʉtarɨ bhwa maheene!” ");
INSERT INTO ikz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yɨɨsu akabhagarukirya, “Nʉʉrʉ niriimenyeekererya inyimwene, ʉbhʉmɨnyɨɨkɨrɨri bhwanɨ nɨ‑bhwa amaheene. Inyɨ nɨɨzɨ hanʉ niruurɨ, na nɨɨzɨ hanʉ nikuja. Nawe imwɨ mʉtɨɨzɨ hanʉ niruurɨ na hanʉ nikuja. ");
INSERT INTO ikz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imwɨ mʉrantɨnɨra kʉrɨngʼaana na amiisɨɨgi ga abhaatʉ, nawe inyɨ nɨtakʉtɨnɨra ʉmʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nawe, arɨɨbhɨ inyɨ nɨratɨnɨra ʉmʉʉtʉ, nɨramʉtɨnɨra koheene, kʉ kʉbha inyɨ nɨtarɨ inyimwene, nawe nɨrɨ hamwɨmwɨ na Bhaabha wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mumigirʉ janyu yandikirwɨ kʉbha, ʉbhʉmɨnyɨɨkɨrɨri bhwa abhaatʉ bhabhɨrɨ bhuriisegwa kʉbha bhwa maheene. ");
INSERT INTO ikz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mmbe, inyɨ niinyɨ nikwimenyeekererya inyimwene, na Bhaabha wʉnʉ antumirɨ wʉʉsi araamenyeekererya.” ");
INSERT INTO ikz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Neho Abhafarisaayo bhakamubhuurya, “Nangʉ, Wuusʉ arɨ hayi?” Yɨɨsu akabhagarukirya, “Imwɨ mʉtaanyɨzɨ inyɨ, nʉʉrʉ Bhaabha waanɨ mʉtamwɨzɨ. Arɨɨbhɨ mwangamɨnyirɨ inyɨ, mwarɨ mʉramenya na Bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yɨɨsu akagamba gayo gʉʉsi, ribhaga rɨnʉ aarɨ ariija muchumba cha zimpirya kɨnʉ charɨ mwihekaaru. Nawe ataareho ʉmʉʉtʉ wʉnʉ aamugwatirɨ, kʉ kʉbha ribhaga ryazɨ ryarɨ rɨkɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mmbe, Yɨɨsu akabhʉʉrɨra Abhafarisaayo bhayo naatu, “Inyɨ nɨraja, na niimwɨ mʉramonhya, imwɨ mʉrakwa igʉrʉ wʉ ʉbhʉbhɨ bhwanyu. Hanʉ nɨraajɨ inyɨ, imwɨ mʉtakʉtʉra kuuza.” ");
INSERT INTO ikz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Neho abhakangati bha Abhayaahudi bhakatanga kwibhuurya, “Kwakɨ arabhuga, tʉtakʉtʉra kumutuna hanʉ akuja? Araja kwiyita?” ");
INSERT INTO ikz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yɨɨsu akangʼeha kʉbhabhʉʉrɨra, “Imwɨ muruurɨ iyaasɨ hanʉ, nawe inyɨ niruurɨ igʉrʉ mwisaarʉ. Imwɨ nɨ‑bha kʉʉsɨ kʉnʉ, nawe inyɨ nɨtarɨ wa kʉʉsɨ kʉnʉ. ");
INSERT INTO ikz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kiyo necho chagiriryɨ nɨkabhabhʉʉrɨra, mʉrakwa igʉrʉ wʉ ʉbhʉbhɨ bhwanyu. Mmbe, arɨɨbhɨ mʉtakwisirirya kʉbha ‘Inyɨ Niinyɨ,’ mʉrakwa igʉrʉ wʉ ʉbhʉbhɨ bhwanyu.” ");
INSERT INTO ikz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bhʉʉsi bhakamubhuurya, “Ʉtʉbhʉʉrɨrɨ, awɨ nɨ‑wɨɨwɨ?” Yɨɨsu akabhagarukirya, “Nɨbhabhuuriirɨ kwɨma ʉbhʉtangɨ kʉbha inyɨ nɨ‑wɨɨwɨ! ");
INSERT INTO ikz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nɨna amangʼana maaru ganʉ nangaturirɨ kʉgamba igʉrʉ waanyu na kʉbhatɨnɨra, nawe nɨtakokorabhu. Nawe wʉnʉ antumirɨ nɨ‑wa amaheene, na niinyɨ nɨrabhʉʉrɨra abhaatʉ amangʼana ganʉ niigwirɨ kurwa kwewe.” ");
INSERT INTO ikz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hanʉ bhiigwirɨ gayo, bhatʉʉbhʉʉrirɨ kʉbha aarɨ aragamba neebho igʉrʉ wa Wiisɨ wa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mmbe, Yɨɨsu akabhabhʉʉrɨra, “Hanʉ mʉkʉnʉnga Umwana wʉ Ʉmʉʉtʉ korereke mumwitɨ, hayo neho mokomenya kʉbha inyɨ newe. Na mʉramenya kʉbha gʉʉsi ganʉ nekokora, nɨtakokora kʉbhʉnaja bhwanɨ, nawe nɨragagamba chɨmbu Bhaabha waanɨ aanyiijiryɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wʉnʉ antumirɨ arɨ hamwɨmwɨ na niinyɨ. Akɨɨrɨ kuntiga inyimwene, kʉ kʉbha ribhaga ryʉsi nɨrakora ganʉ gakomozomera.” ");
INSERT INTO ikz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hanʉ Yɨɨsu aarɨ akʉgamba amangʼana gayo, abhaatʉ bhaaru bhakamwisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mmbe, Yɨɨsu akabhʉʉrɨra Abhayaahudi bhanʉ bhamwisiriiryɨ kʉbha, “Arɨɨbhɨ mʉrakaja kutuna amiija gaanɨ, hayo neho mʉbhɨɨrɨ abhɨɨga bhaanɨ bha amaheene. ");
INSERT INTO ikz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na mʉramenya amaheene, na amaheene gayo, garabhaha ubhwiyagaaruri.” ");
INSERT INTO ikz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ebho bhakamubhuurya, “Itwɨ ni‑bhiibhurwa bha Abhurahaamu. Tʉkɨɨrɨ kokorwa nʉ ʉmʉʉtʉ wʉwʉʉsi kʉbha bhambʉʉsa. Kwakɨ ʉrabhuga itwɨ tʉrahaanwa ubhwiyagaaruri?” ");
INSERT INTO ikz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yɨɨsu akabhagarukirya, “Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akongʼeha kokora ʉbhʉbhɨ, wuyo nɨ‑mbʉʉsa wʉ ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mbʉʉsa atakwikara munyumba yʉ ʉmʉkʉrʉ waazɨ sikʉ zʉʉsi, nawe umwana newe akʉsaaga munyumba sikʉ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Arɨɨbhɨ Umwana wa Mungu abhatazwirɨ kurwa mʉbhʉbhɨ bhwanyu, mʉtakʉbha bhambʉʉsa naatu, nawe mʉrabha abhaatʉ bhu ubhwiyagaaruri heeneheene. ");
INSERT INTO ikz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nɨɨzɨ kʉbha, imwɨ ni‑bhiibhurwa bha Abhurahaamu. Nawe moreenda kunyita, kʉ kʉbha mʉraanga kwisirirya ganʉ nikubhiija. ");
INSERT INTO ikz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inyɨ nɨrabhabhʉʉrɨra ganʉ nɨrʉʉzɨ kwa Bhaabha waanɨ, nawe imwɨ mʉrakora ganʉ wuusʉ abhiijiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ebho bhakamʉgarukirya, “Abhurahaamu newe bhaabha wɨɨtʉ!” Yɨɨsu akabhabhʉʉrɨra, “Arɨɨbhɨ maheene ni‑rwibhʉrʉ rwa Abhurahaamu, mwangakʉrirɨ ganʉ Abhurahaamu aarɨ arakora. ");
INSERT INTO ikz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nawe nangʉ mʉramohya ɨnzɨra yu kunyita, nangabha nɨbhabhuuriirɨ amaheene ganʉ niigwirɨ kurwa kwa Mungu. Abhurahaamu ataakʉrirɨbhu. ");
INSERT INTO ikz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amahocha ganʉ mokokora, gararwa kwa wuusʉ wʉndɨ.” Neho bhakamʉgarukirya, “Itwɨ tʉtarɨ bhigwa ibhanza. Mungu newe Bhaabha wɨɨtʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yɨɨsu akabhagarukirya, “Angabhɨɨrɨ Mungu newe Wuusʉ, mwarɨ mʉransɨɨga, kʉ kʉbha niruurɨ kwa Mungu, na nangʉ nɨrɨ hanʉ. Inyɨ nitiizirɨ kʉbhʉnaja bhwanɨ, nawe Mungu newe antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwakɨ mʉtɨɨzɨ ganʉ nɨkʉgamba? Nɨ‑kʉ kʉbha mʉtakwenda kwitegeerera amangʼana ganʉ nɨkʉbhabhʉʉrɨra. ");
INSERT INTO ikz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imwɨ nɨ‑bha Shɨtaani, wuyo newe wuusʉ! Nangʉ moreenda kokora ganʉ wuusʉ akwigomba. Shɨtaani ni‑mwiti kwɨma ʉbhʉtangɨ. Atasɨɨgirɨ amaheene, kʉ kʉbha amaheene gatariimu mumwʉyʉ gwazɨ. Shɨtaani ahaagamba ʉrʉrɨmɨ, neyo eteemwa yaazɨ, kʉ kʉbha umwene nɨ‑mʉbhɨɨhi, na newe bhaabha wʉ ʉrʉrɨmɨ rwʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nawe kʉ kʉbha inyɨ nɨrabhabhʉʉrɨra amaheene, mʉtakunyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɨ‑wɨɨwɨ gatɨ waanyu wʉnʉ akʉtʉra komenyeekererya kʉbha inyɨ nɨkʉrirɨ ʉbhʉbhɨ? Arɨɨbhɨ nɨrabhabhʉʉrɨra amaheene, kwakɨ mʉtakunyiisirirya? ");
INSERT INTO ikz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ʉmʉʉtʉ wʉwʉʉsi wa Mungu, ahiigwa amangʼana gaazɨ. Imwɨ mʉtakwigwa ganʉ Mungu akʉgamba, kʉ kʉbha mʉtarɨ abhaatʉ bhaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Abhayaahudi bhakabhuurya Yɨɨsu, “Nangʉ, tʉtakʉgamba amaheene tʉraabhugɨ, awɨ nɨ‑Mʉsamaariya, na ʉna risambwa?” ");
INSERT INTO ikz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yɨɨsu akabhagarukirya, “Inyɨ nɨtaana risambwa. Inyɨ nɨrasʉʉka Bhaabha waanɨ, nawe imwɨ mʉtakʉnsʉʉka. ");
INSERT INTO ikz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inyɨ nɨtakwimoherya kwigʉnga, nawe areho ʉwʉndɨ wʉnʉ akomohya kʉngʉnga, na newe akʉbha umutiniri wa amaheene. ");
INSERT INTO ikz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akugwata amiija gaanɨ, atakukwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mmbe, Abhayaahudi bhayo bhakabhʉʉrɨra Yɨɨsu, “Nangʉ tʉmɨnyirɨ kʉbha, awɨ ʉna risambwa! Abhurahaamu akakwa, na abharʉʉtɨrɨri bhʉʉsi bhakakwa. Nawe awɨ ʉrabhuga, ‘Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akugwata amiija gaanɨ, atakukwa kemerano.’ ");
INSERT INTO ikz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nangʉ, uriikorya kʉbha mʉkʉrʉ kʉkɨra sʉʉkʉrʉ wɨɨtʉ Abhurahaamu? Ewe akakwa, na abharʉʉtɨrɨri bhʉʉsi bhakakwa. Nangʉ, awɨ uriikora kʉbha nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yɨɨsu akabhagarukirya, “Nangabha niriigʉnga inyimwene, ukwigʉnga kwanɨ kʉtaana enzobhooro yʉyʉʉsi. Nawe Bhaabha wʉnʉ imwɨ mukubhuga Mungu waanyu, newe akʉngʉnga. ");
INSERT INTO ikz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Imwɨ mʉtɨɨzɨ Mungu, nawe inyɨ nimwɨzɨ. Angabhɨɨrɨ nibhugɨ nɨtamwɨzɨ, naarɨ nɨrabha mʉbhɨɨhi ncha niimwɨ. Nawe inyɨ nimwɨzɨ, naatu nɨragwata ganʉ akʉgamba. ");
INSERT INTO ikz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wʉsʉʉkʉrʉ Abhurahaamu, akazomerwa bhʉkʉngʼu korora urusikʉ rwu ukuuza kwanɨ. Hanʉ aarʉrʉʉzi, akazomerwa bhʉkʉngʼu.” ");
INSERT INTO ikz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mmbe, Abhayaahudi bhakabhʉʉrɨra Yɨɨsu, “Awɨ ʉkɨɨrɨ kuhicha imyaka merongo ɨtaanʉ. Ʉkamororabhwɨ Abhurahaamu?” ");
INSERT INTO ikz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yɨɨsu akabhagarukirya, “Nɨrabhabhʉʉrɨra amaheene, Abhurahaamu akɨɨrɨ kwibhurwa, inyɨ nereho.” ");
INSERT INTO ikz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hanʉ Abhayaahudi bhiigwirɨ gayo, bhakatoora amabhwɨ korereke bhamoteme nagʉ bhamwitɨ. Nawe Yɨɨsu akiibhisa, akarwa mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Urusikʉ rʉmwɨ, hanʉ Yɨɨsu aarɨ aragenda kʉnzɨra, akarora ʉmʉʉtʉ wʉmwɨ wʉnʉ iibhwirwɨ mʉhʉku. ");
INSERT INTO ikz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abhɨɨga bhaazɨ bhakamubhuurya, “Umwija, ʉmʉʉtʉ wʉnʉ akiibhurwa ʉmʉhʉku kʉ kʉbha yʉ ʉbhʉbhɨ bhwa wɨɨwɨ? Nɨ‑bhwʉ ʉmʉʉtʉ wʉnʉ umwene, hamwɨ bhwa abhiibhuri bhaazɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yɨɨsu akabhagarukirya, “Wʉnʉ atarɨ ʉmʉhʉku kʉ kʉbha yʉ ʉbhʉbhɨ bhwazɨ, hamwɨ ʉbhʉbhɨ bhwa abhiibhuri bhaazɨ. Nawe akiibhurwa ʉmʉhʉku, korereke ʉbhʉnaja bhwa Mungu bhororekanɨ kʉbhaatʉ mubhwikari bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Toreenderwa kohocha emeremo ja Mungu wʉnʉ aantumirɨ, kʉkɨɨrɨ umwise. Ubhutikʉ bhʉraaza, bhʉnʉ tʉtakʉtʉra kokora emeremo giyo. ");
INSERT INTO ikz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ribhaga rɨnʉ nɨkɨɨrɨ kʉʉsɨ kʉnʉ, inyɨ ni‑bhwɨrʉ kʉbhaatʉ bhʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hanʉ Yɨɨsu aamarirɨ kʉgamba amangʼana gayo, akatwa amatɨ kobhototo, akabhanda obhototo na amatɨ, akahaka kʉmɨɨsʉ gʉ ʉmʉhʉku wuyo. ");
INSERT INTO ikz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akʉmara akamʉbhʉʉrɨra, “Nuujɨ wiisaabhɨ ubhushʉ mwitabha rya Sirʉamu.” Sirʉamu, enzobhooro yaku nɨ‑wʉnʉ atumirwɨ. Neho ʉmʉhʉku wuyo akaja, akiisaabha ubhushʉ, akagarʉka yɨɨka waazɨ ararora. ");
INSERT INTO ikz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mmbe, bhanyarʉbhɨri bhaazɨ na abhandɨ bhanʉ bhaarɨ bhanarirɨ komorora arasabhasabha, bhakiibhuurya, “Ʉmʉʉtʉ wʉnʉ atarɨ ni‑wurya aarɨ ariikara na kʉsabhasabha?” ");
INSERT INTO ikz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abhandɨ bhakabhuga, “Newe.” Abhandɨ bhakabhuga, “Atarɨ newe, nawe atuubhɨɨnɨ neewe bhʉkʉngʼu.” Nawe umwene akabhabhʉʉrɨra, “Maheene, niinyɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Neho bhakamubhuurya, “Arɨɨbhɨ maheene naawɨ, amɨɨsʉ gaazʉ gaturirɨbhwɨ korora?” ");
INSERT INTO ikz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akabhagarukirya, “Ʉmʉʉtʉ wʉmwɨ wʉnʉ akubhirikirwa Yɨɨsu, akakora obhototo akatwaku amatɨ, akahaka kʉmɨɨsʉ gaanɨ. Akʉmara akambʉʉrɨra, ‘Nuujɨ wiisaabhɨ ubhushʉ mwitabha rya Sirʉamu.’ Mmbe nɨkaja, nikiisaabha, nɨkarora.” ");
INSERT INTO ikz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhakamubhuurya, “Ʉmʉʉtʉ wuyo arɨ hayi?” Akabhagarukirya, “Inyɨ nɨtɨɨzɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mmbe, bhakahira wʉnʉ aarɨ ʉmʉhʉku kʉBhafarisaayo. ");
INSERT INTO ikz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Urusikʉ rʉnʉ Yɨɨsu aakʉrirɨ obhototo na kohorya ʉmʉhʉku wuyo, yaarɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mmbe, Abhafarisaayo bhʉʉsi bhakabhuurya ʉmʉʉtʉ wuyo chɨmbu aaturirɨ korora. Akabhagarukirya, “Akanhaka obhototo kʉmɨɨsʉ, nikiisaabha, na nangʉ nɨrarora.” ");
INSERT INTO ikz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Neho Abhafarisaayo abhandɨ bhakabhuga, “Ʉmʉʉtʉ wʉnʉ aakʉrirɨbhu, ataruurɨ kwa Mungu, kʉ kʉbha arasarya imigirʉ ju urusikʉ rwʉ ʉbhʉtʉʉrʉ.” Nawe abhandɨ bhakabhuga, “Nangʉ, ʉmʉkʉri wʉ ʉbhʉbhɨ aratʉrabhwɨ kokora ichɨrɨkɨnʼyʉ ncha kiyo?” Kʉgayo, bhakataamanʼya abheene kobheene. ");
INSERT INTO ikz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Neho, Abhafarisaayo bhakamubhuurya naatu, “Ʉmʉʉtʉ wʉnʉ ahʉriryɨ amɨɨsʉ gaazʉ, ʉrabhugabhwɨ igʉrʉ waazɨ?” Ewe akabhagarukirya, “Inyɨ nɨrarora ʉmʉʉtʉ wuyo nɨ‑mʉrʉʉtɨrɨri wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nawe abhakangati bha Abhayaahudi bhayo bhatiisiriiryɨ kʉbha, ʉmʉʉtʉ wʉnʉ akorora nangwɨnʉ, aarɨ iibhwirwɨ mʉhʉku. Kʉgayo, bhakabhɨrɨkɨra abhiibhuri bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhakabhabhuurya, “Angʉ, ʉmʉʉtʉ wʉnʉ ni‑mwana waanyu? Nɨ‑maheene akiibhurwa ʉmʉhʉku? Arɨɨbhɨ nɨmbu, aratʉrabhwɨ korora nangʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Neho abhiibhuri bhaazɨ bhakabhagarukirya, “Itwɨ tʉmɨnyirɨ kʉbha wʉnʉ ni‑mwana wɨɨtʉ, na akiibhurwa mʉhʉku. ");
INSERT INTO ikz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nawe tʉtɨɨzɨ chɨmbu aturirɨ korora, na tʉtɨɨzɨ ʉmʉʉtʉ wʉnʉ aahʉriryɨ amɨɨsʉ gaazɨ. Mumubhuuryɨ umwene, kʉ kʉbha nɨ‑mʉʉtʉ mugima, aratʉra kʉgamba umwene.” ");
INSERT INTO ikz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abhiibhuri bhaazɨ bhakabhugabhu, kʉ kʉbha bhaarɨ bharʉʉbhaha abhakangati bhayo. Abhakangati bha Abhayaahudi bhayo bhaarɨ bhiisirirɨɨnʼyɨ kʉbha, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwisirirya Yɨɨsu newe Kiriisitʉ, araheebhwa kurwa mʉmarwazɨrʉ gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Necho chagiriryɨ abhiibhuri bhakabhuga, “Mumubhuuryɨ umwene, kʉ kʉbha nɨ‑mʉʉtʉ mugima.” ");
INSERT INTO ikz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mmbe, abhakangati bha Abhayaahudi bhakamʉbhɨrɨkɨra naatu ʉmʉʉtʉ wʉnʉ aarɨ ʉmʉhʉku, bhakamʉbhʉʉrɨra, “Wiirahɨrɨ kwa Mungu kʉbha, ʉragamba amaheene. Itwɨ tʉmɨnyirɨ kʉbha ʉmʉʉtʉ wʉnʉ aakʉhʉriryɨ, nɨ‑mʉkʉri wʉ ʉbhʉbhɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ewe akabhagarukirya, “Inyɨ nɨtɨɨzɨ arɨɨbhɨ ʉmʉʉtʉ wuyo nɨ‑mʉkʉri wʉ ʉbhʉbhɨ, nawe nɨɨzɨ ekegero kɨmwɨbhu. Naarɨ ʉmʉhʉku, nawe nangʉ nɨrarora.” ");
INSERT INTO ikz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Akʉmara bhakamubhuurya, “Nangʉ, ʉmʉʉtʉ wuyo akakokorerakɨ? Akakohoryabhwɨ amɨɨsʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ewe akabhagarukirya, “Nɨmarirɨ kʉbhabhʉʉrɨra amangʼana gayo, nawe mutiitɨgɨrɨɨrɨ. Kwakɨ moreenda nɨbhabhʉʉrɨrɨ kwikɨ? Awɨɨ na niimwɨ moreenda kʉbha abhɨɨga bhaazɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Neho ebho bhakamʉtʉka, “Awɨ naawɨ umwɨga waazɨ! Nawe itwɨ bhɨɨga bha Musa tʉrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tʉmɨnyirɨ kʉbha Mungu aagambirɨ na Musa, nawe ʉmʉʉtʉ wuyo tʉtɨɨzɨ hanʉ aruurɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wʉʉsi akabhagarukirya, “Inyɨ nɨrarʉgʉʉra bhʉkʉngʼu! Mʉtɨɨzɨ hanʉ aruurɨ, nawe wuyo newe aahʉriryɨ amɨɨsʉ gaanɨ! ");
INSERT INTO ikz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tʉmɨnyirɨ Mungu atakwigwa amasabhi ga abhakʉri bhʉ ʉbhʉbhɨ, nawe ariigwa ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akumwigwa na kokora ganʉ Mungu akwenda. ");
INSERT INTO ikz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kwɨma ɨkarɨ, tʉkɨɨrɨ kwigwa nʉʉrʉ rʉmwɨ kʉbha, ʉmʉʉtʉ ahʉriryɨ ʉmʉʉtʉ wʉnʉ iibhwirwɨ mʉhʉku. ");
INSERT INTO ikz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Arɨɨbhɨ ʉmʉʉtʉ wuyo ataruurɨ kwa Mungu, atangaturirɨ kokora gayo.” ");
INSERT INTO ikz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ebho bhakamʉgarukirya, “Awɨ ukiibhurwa na korerwa nchʉ ʉmʉkʉri wʉ ʉbhʉbhɨ. Nangʉ awɨ ʉna bhʉnajakɨ bhwu ukutwija itwɨ?” Bhakamoheebha muyo. ");
INSERT INTO ikz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hanʉ Yɨɨsu iigwirɨ kʉbha bhakaheebha ʉmʉʉtʉ wuyo, akaja komomohya. Hanʉ aamubhwɨnɨ, akamubhuurya, “Nangʉ, uriisirirya Umwana wʉ Ʉmʉʉtʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ʉmʉʉtʉ wuyo akamʉgarukirya, “Ʉmʉkʉrʉ, ʉmbʉʉrɨrɨ Umwana wʉ Ʉmʉʉtʉ nɨ‑wɨɨwɨ, korereke nɨbhɨ nɨramwisirirya.” ");
INSERT INTO ikz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yɨɨsu akamʉbhʉʉrɨra, “Awɨ ʉmarirɨ komorora, na newe wʉnʉ akʉgambana na naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ʉmʉʉtʉ wuyo akabhuga, “Nɨrakwisirirya, Ʉmʉkʉrʉ.” Neho akamosengera. ");
INSERT INTO ikz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Mmbe, Yɨɨsu akabhuga, “Inyɨ nɨkaaza kʉʉsɨ kʉnʉ kʉtɨnɨra, korereke abhahʉku bharore, na bhanʉ bhakorora, bhabhɨ abhahʉku.” ");
INSERT INTO ikz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Neho, Abhafarisaayo abhandɨ bhanʉ bhaareho hayo, hanʉ bhiigwirɨ amangʼana gayo, bhakamubhuurya, “Nangʉ, ʉrabhuga kʉbha nʉʉrʉ itwɨ bhahʉku tʉrɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yɨɨsu akabhagarukirya, “Mwangabhɨɨrɨ abhahʉku, mʉtaarɨ mʉrabha abhakʉri bhʉ ʉbhʉbhɨ. Nawe mʉrabhuga kʉbha mʉrarora bhwaheene, kʉgayo mʉrasaaga nʉ ʉbhʉbhɨ bhwanyu.” ");
INSERT INTO ikz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yɨɨsu akangʼeha kʉgamba, “Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉnʉ atakusikɨra kʉhɨtɨra mukishoko cha ribhanza rya zɨngʼʉndu, nawe arasikɨrɨra ahandɨ, wuyo ni‑mwibhi na mʉsaakuri. ");
INSERT INTO ikz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nawe wʉnʉ akusikɨra kʉhɨtɨra mukishoko cha ribhanza, wuyo ni‑muriisha wa zɨngʼʉndu. ");
INSERT INTO ikz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Umuriibhi wa ribhanza aramushʉkʉrɨra ikishoko, na zɨngʼʉndu zihiigwa riraka ryu umuriisha. Ahaabhɨrɨkɨra ɨngʼʉndu yɨmwɨ yɨmwɨ iriina ryazɨ na kʉzɨkangata kuja igʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hanʉ ahaamara kuhurucha zɨngʼʉndu zaazɨ igʉtʉ, ahaakangata mʉbhʉtangɨ, zʉʉsi zɨhaamutuna, kʉ kʉbha zɨɨzɨ riraka ryazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Zɨngʼʉndu zɨtakʉtʉra kutuna umugini, nawe zɨhaamuryara, kʉ kʉbha zɨtɨɨzɨ riraka ryazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yɨɨsu akabhabhʉʉrɨra Abhafarisaayo ekerenjo kɨnʉ, nawe ebho bhatʉʉbhʉʉrirɨ ganʉ aarɨ akʉbhabhʉʉrɨra. ");
INSERT INTO ikz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mmbe, Yɨɨsu akabhabhʉʉrɨra naatu, “Nɨrabhabhʉʉrɨra amaheene, inyɨ niinyɨ ikishoko kɨnʉ zɨngʼʉndu zɨhaahɨtɨra kusikɨra mwibhanza. ");
INSERT INTO ikz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhʉʉsi bhanʉ bhankangatiirɨ kʉbha abhariisha bha zɨngʼʉndu, bhaarɨ abhiibhi na abhasaakuri, nawe zɨngʼʉndu zɨtabhiitɨgɨɨrɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inyɨ niinyɨ ikishoko kiyo. Wʉwʉʉsi wʉnʉ akusikɨra mwibhanza kʉhɨtɨra kwa niinyɨ arasabhurwa, na arabha nu umweya kusikɨra na kʉhʉrʉka, na kuja kuriisha mukiriishʉ ɨkɨzʉmu. ");
INSERT INTO ikz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umwibhi ahaaza mwibhanza korereke iibhɨ zɨngʼʉndu na kuziita na kʉsarya. Nawe inyɨ niizirɨ korereke zɨbhɨ nʉ ʉbhʉhʉru, na zɨbhɨ nabhwɨ bhwaru. ");
INSERT INTO ikz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Inyɨ niinyɨ umuriisha ʉmʉzʉmu. Umuriisha ʉmʉzʉmu ahaahurucha ʉbhʉhʉru bhwazɨ igʉrʉ wa zɨngʼʉndu zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Omohocha wʉnʉ atarɨ umuriisha wa zɨngʼʉndu na zɨngʼʉndu zɨtarɨ zaazɨ, araarore isuuzɨ ɨraaza, ahaaryara na kutiga zɨngʼʉndu izeene. Kʉgayo, isuuzɨ ɨraryarɨra zɨngʼʉndu na kʉzɨnyaraganʼya. ");
INSERT INTO ikz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Omohocha ahaaryara, kʉ kʉbha atakʉdɨɨrɨɨra zɨngʼʉndu ziyo. ");
INSERT INTO ikz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Inyɨ niinyɨ umuriisha ʉmʉzʉmu. Nɨɨzɨ bhwaheene zɨngʼʉndu zaanɨ, zʉʉsi zɨɨnyɨzɨ, ");
INSERT INTO ikz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","chɨmburya Bhaabha anyɨzɨ inyɨ, na niinyɨ nimwɨzɨ. Inyɨ nɨrahurucha ʉbhʉhʉru bhwanɨ igʉrʉ wa zɨngʼʉndu zaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Inyɨ nɨna zɨngʼʉndu ɨzɨndɨ zɨnʉ zɨtarɨ za mwibhanza rɨnʉ, zʉʉsi nereenderwa niziriishɨ. Zɨngʼʉndu ziyo zʉʉsi, zɨramenya riraka ryanɨ. Akʉmara rɨrabha riribhita rɨmwɨ, nu umuriisha wʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Bhaabha ansɨɨgirɨ, kʉ kʉbha nɨrahurucha ʉbhʉhʉru bhwanɨ, korereke nebhogege naatu. ");
INSERT INTO ikz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kunduusha ʉbhʉhʉru bhwanɨ. Niinyɨ inyimwene nikuhurucha ʉbhʉhʉru bhwanɨ. Nɨnʉ ʉbhʉnaja bhwu kuhurucha ʉbhʉhʉru bhwanɨ, na nɨnʉ ʉbhʉnaja bhwo okogega ʉbhʉhʉru kwikɨ. Nɨ‑Bhaabha umwene wʉnʉ answajiryɨ kokorabhu.” ");
INSERT INTO ikz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hanʉ bhiigwirɨ amangʼana gayo, Abhayaahudi bhakataamanʼya abheene kobheene. ");
INSERT INTO ikz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bhaaru gatɨ waabhʉ bhakabhuga, “Wʉnʉ ana risambwa! Na nɨ‑mʉsazi! Kwakɨ mʉramwitegeerera?” ");
INSERT INTO ikz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nawe abhandɨ bhakabhuga, “Amangʼana gayo gatakurwa kʉmʉʉtʉ wʉnʉ ana risambwa. Nangʉ, risambwa rɨratʉra kokora ʉmʉhʉku arore?” ");
INSERT INTO ikz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mmbe, Yɨrusarɨɨmu iyo, kwarɨ ni isigukuru ya Abhayaahudi yu ukuhiita kʉbha rihekaaru rya Mungu rɨkabhɨngukibhwa na kwigurwa naatu. Ribhaga riyo, ryarɨ rye embeho. ");
INSERT INTO ikz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yɨɨsu aarɨ aragenda mwihekaaru, ʉrʉbhaara rʉnʉ rukubhirikirwa, Rigoobhe rya Sɨrɨmaani. ");
INSERT INTO ikz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Abhayaahudi abhandɨ bhakamwiruguura, bhakamubhuurya, “Nangʉ, ʉratʉnyaacha mozekoro zɨɨtʉ kuhika ryʉrɨ? Arɨɨbhɨ naawɨ Kiriisitʉ, ʉtʉbhʉʉrɨrɨ habhwɨrʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nawe Yɨɨsu akabhagarukirya, “Inyɨ nɨmarirɨ kʉbhabhʉʉrɨrabhu, nawe imwɨ mʉtakwisirirya. Emeremo gɨnʉ nɨrakora kʉbhʉnaja bhwa Bhaabha, nejo gekomenyeekererya kʉbha inyɨ nɨ‑wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nawe mʉtakwenda kunyiisirirya, kʉ kʉbha imwɨ mʉtarɨ zɨngʼʉndu zaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Zɨngʼʉndu zaanɨ zihiigwa riraka ryanɨ. Inyɨ nɨzɨɨzɨ, zʉʉsi zɨhaantuna. ");
INSERT INTO ikz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inyɨ nɨrazeha ʉbhʉhʉru bhwa kemerano, na zɨtakurimɨra. Na atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kʉzɨsaakʉra kurwa mʉmabhoko gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bhaabha waanɨ angʼɨɨrɨ zɨngʼʉndu ziyo, ewe newe ʉmʉkʉrʉ kʉkɨra bhʉʉsi. Na atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kʉzɨsaakʉra mʉmabhoko gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inyɨ na Bhaabha kegero kɨmwɨ tʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hayo neho Abhayaahudi bhaatʉʉrirɨ amabhwɨ naatu, korereke bhamoteme nagʉ na kumwita. ");
INSERT INTO ikz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nawe Yɨɨsu akabhabhʉʉrɨra, “Nɨbhɨɨrɨkiryɨ emeremo ɨmɨzʉmu gɨnʉ nakʉrirɨ kʉmanaga ga Bhaabha. Ni‑ngʼanakɨ rɨnʉ rɨkʉbhakora imwɨ mwende kontema na amabhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Abhayaahudi bhakagarukirya, “Tʉtakwenda kokotema amabhwɨ igʉrʉ wo okokora emeremo ɨmɨzʉmu, nawe kʉ kʉbha ʉrarega Mungu, kwa kwikorya kʉbha awɨ ni‑Mungu, ɨnʉ awɨ nɨ‑mʉʉtʉbhu ncha abhandɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yɨɨsu akabhabhuurya, “Nangʉ, ɨkɨɨrɨ kwandɨkwa mʉMaandɨkʉ gaanyu gi imigirʉ kʉbha Mungu aagambirɨ, ‘Imwɨ nɨ‑mɨsambwa’? ");
INSERT INTO ikz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Amaandɨkʉ Amarɨndu gatakʉtʉra kwichʉra. Arɨɨbhɨ Mungu akabhɨrɨkɨra abhaatʉ bhanʉ bhasʉngʼaanirɨ ɨngʼana yaazɨ nɨ‑mɨsambwa, ");
INSERT INTO ikz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nangʉ, kwakɨ mʉrabhuga, nɨratʉka Mungu hanʉ nikubhuga, ‘Inyɨ ni‑Mwana wa Mungu’? Inyɨ wʉnʉ Bhaabha aambɨngukiryɨ na kʉntʉma kʉʉsɨ kʉnʉ. ");
INSERT INTO ikz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Arɨɨbhɨ nɨtakokora emeremo ja Bhaabha, mʉtanyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nawe arɨɨbhɨ nɨrakora emeremo ja Bhaabha, nangabha mʉtakunyiisirirya inyɨ, mmbe mwisiriryɨ emeremo giyo. Neho mokomenya, Bhaabha arɨ kwa niinyɨ, na niinyɨ nɨrɨ kwa Bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hanʉ Abhayaahudi bhiigwirɨ amangʼana gayo, bhakeenda kumugwata kwikɨ, nawe Yɨɨsu akasʉsʉbhʉka mʉmabhoko gaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mmbe, Yɨɨsu akaja imwambʉkʉ wɨ ɨkɨtaarʉ cha Yorodaani, akahika hanʉ Yoohana aarɨ arabhatiiza abhaatʉ. Akiikara iyo sikʉ suuhu. ");
INSERT INTO ikz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abhaatʉ bhaaru bhakamuuzaku, bhakabhuga, “Yoohana ataakʉrirɨ ichɨrɨkɨnʼyʉ nʉʉrʉ kɨmwɨ, nawe amangʼana gʉʉsi ganʉ aarɨ aragamba igʉrʉ wa Yɨɨsu, gaarɨ ga amaheene.” ");
INSERT INTO ikz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Abhaatʉ bhaaru bhanʉ bhaareho, bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mmbe aareho ʉmʉʉtʉ wʉmwɨ iriina ryazɨ Razaarʉ, aarɨ murwɨrɨ. Aarɨ ariikara mʉrʉbhɨri rwa Bhɨtaniya hamwɨmwɨ na abhasubhaati bhaazɨ, Mariyamu na Maarita. ");
INSERT INTO ikz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyamu wuyo aarɨ musubhaati wa Razaarʉ umurwɨrɨ, newe aamʉhakirɨ Ʉmʉkʉrʉ Yɨɨsu amaguta go okoreetya, na kʉmʉtaricha amagʉrʉ na zinzwɨrɨ zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mmbe, Mariyamu na Maarita bhakatʉma amangʼana kwa Yɨɨsu kʉbha, “Ʉmʉkʉrʉ, mʉsaani waazʉ murwɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hanʉ Yɨɨsu iigwirɨ amangʼana gayo, akabhuga, “Ubhurwɨrɨ bhuyo bhʉtarɨ bhwa kumwita, nawe nɨ‑bhwa kwerecha ʉbhʉgʉngʉ bhwa Mungu, korereke bhagungyɨ Umwana wa Mungu kʉhɨtɨra ubhurwɨrɨ bhuyo.” ");
INSERT INTO ikz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yɨɨsu akasɨɨga Maarita, Mariyamu na Razaarʉ. ");
INSERT INTO ikz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nawe hanʉ abhwɨnɨ amangʼana kʉbha Razaarʉ murwɨrɨ, akakaja kwikara iyo aarɨ kwa zisikʉ ibhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mmbe, hanʉ zaahitirɨ sikʉ ibhɨrɨ, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ kʉbha, “Tʉgarʉkɨ Yudeya.” ");
INSERT INTO ikz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abhɨɨga bhaazɨ bhakamʉbhʉʉrɨra, “Umwija, nɨ‑bhasiryasiryabhu Abhayaahudi bhakeenda kokotema na amabhwɨ korereke bhakwitɨ. Kwakɨ oreenda kujayʉ naatu?” ");
INSERT INTO ikz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yɨɨsu akabhagarukirya, “Nangʉ, umwise gʉtaana zɨɨsa ikumi ni ibhɨrɨ? Ʉmʉʉtʉ wʉnʉ akogenda umwise, atakʉtʉra kwitema ʉkʉgʉrʉ kwazɨ, kʉ kʉbha ararora ubhwɨrʉ bhwɨ ɨɨsɨ yɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nawe wʉnʉ akogenda ubhutikʉ, ariihuna, kʉ kʉbha ubhwɨrʉ bhwʉ ʉkʉmʉmʉrɨka bhʉtareeho.” ");
INSERT INTO ikz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hanʉ Yɨɨsu agambirɨ gayo, akangʼeha kʉbhʉʉrɨra abhɨɨga bhaazɨ, “Mʉsaani wɨɨtʉ Razaarʉ ahindiirɨ, nawe nɨraja kumubhuucha.” ");
INSERT INTO ikz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Neho abhɨɨga bhaazɨ bhakamʉgarukirya, “Ʉmʉkʉrʉ, nangabha ahindiirɨ, arahora.” ");
INSERT INTO ikz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abhɨɨga bhaazɨ bhakiiseega kʉbha aragambɨra Razaarʉ ahindiirɨ zendooro, nawe Yɨɨsu aarɨ arabhuga akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mmbe, Yɨɨsu akabhabhʉʉrɨra habhwɨrʉ, “Razaarʉ akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nawe inyɨ nɨrazomerwa kʉbha nɨtaarɨ nereho hanʉ Razaarʉ akukwa, korereke imwɨ mobhone kunyiisirirya. Mmbe, tujɨ kwawe.” ");
INSERT INTO ikz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Neho umwɨga wʉmwɨ iriina ryazɨ Tomaaso wʉnʉ akubhirikirwa Mbasa, akabhʉʉrɨra abhɨɨga abhakɨndichazɨ, “Na niitwɨ tujɨ, korereke tukwɨ hamwɨmwɨ nawe.” ");
INSERT INTO ikz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mmbe, hanʉ Yɨɨsu aahikirɨ Yudeya mʉrʉbhɨri rwa Bhɨtaniya, akabhona Razaarʉ amarirɨ sikʉ inyɨ mumbihɨra. ");
INSERT INTO ikz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ʉrʉbhɨri rwa Bhɨtaniya rwarɨ nkina matambʉka bhɨkwɨ bhɨtatʉ kurwa Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abhayaahudi bhaaru bhakaaza Bhɨtaniya kwibhisirirya Maarita na Mariyamu, igʉrʉ yu uruku rwa umwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mmbe, hanʉ Maarita igwirɨ kʉbha Yɨɨsu araaza, akahʉrʉka igʉtʉ, akaja kʉmʉsʉngʼaana. Nawe Mariyamu akasaaga munyumba. ");
INSERT INTO ikz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maarita akabhʉʉrɨra Yɨɨsu kʉbha, “Ʉmʉkʉrʉ, wangabhɨɨrɨho, umwɨtʉ ataarɨ arakwa. ");
INSERT INTO ikz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nawe nʉʉrʉ nangwɨnʉ nɨɨzɨ kʉbha, chʉchʉsi kɨnʉ ʉraasabhɨ Mungu, arakoha.” ");
INSERT INTO ikz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yɨɨsu akamʉgarukirya, “Umwanyu araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maarita akabhuga, “Nɨɨzɨ kʉbha urusikʉ rwɨ ɨtɨnɨrʉ yu ukuryʉka kwa abhaatʉ, wʉʉsi araryʉka.” ");
INSERT INTO ikz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yɨɨsu akamʉgarukirya, “Inyɨ niinyɨ ubhuryuku nʉ ʉbhʉhʉru. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akunyiisirirya inyɨ, nʉʉrʉ angakwa, arabha mʉhʉru. ");
INSERT INTO ikz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na wʉwʉʉsi wʉnʉ akwikara na anyiisiriiryɨ inyɨ, atakukwa. Nangʉ, uriisirirya gayo?” ");
INSERT INTO ikz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maarita akamʉgarukirya, “Hee Ʉmʉkʉrʉ, niriisirirya kʉbha awɨ ni‑Kiriisitʉ, Umwana wa Mungu, wʉnʉ akuuza kʉʉsɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hanʉ Maarita aamarirɨ kʉgamba gayo, akaja kʉbhɨrɨkɨra Mariyamu umwabhʉ rusizʉ, akamʉbhʉʉrɨra, “Umwija arɨ hanʉ, arakʉbhɨrɨkɨra.” ");
INSERT INTO ikz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hanʉ Mariyamu iigwirɨ riyo, akabhʉʉka bhwangʉ, akaja kwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ribhaga riyo, Yɨɨsu aarɨ akɨɨrɨ kusikɨra mʉrʉbhɨri ruyo, nawe aarɨ hanʉ Maarita aagiirɨ kʉmʉsʉngʼaana. ");
INSERT INTO ikz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Abhayaahudi bhanʉ bhaarɨ bhagiirɨ kwibhisirirya Mariyamu, bhakarora arabhʉʉka bhwangʉ na kʉhʉrʉka igʉtʉ. Bhakamutuna, kʉ kʉbha bhakiiseega kʉbha araja kumbihɨra kʉrɨra. ");
INSERT INTO ikz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hanʉ Mariyamu aahikirɨ hanʉ Yɨɨsu aarɨ, akamorora, akahigama mʉbhʉtangɨ bhwazɨ, akabhʉʉrɨra Yɨɨsu kʉbha, “Ʉmʉkʉrʉ, wangabhɨɨrɨho, umwɨtʉ ataarɨ arakwa.” ");
INSERT INTO ikz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hanʉ Yɨɨsu aamʉrʉʉzɨ Mariyamu ararɨra, na Abhayaahudi bhanʉ bhiizirɨ nabhʉ bhʉʉsi bhararɨra akiigwa ʉbhʉsʉngʉ, akarumɨka bhʉkʉngʼu mumwʉyʉ gwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Akabhabhuurya, “Mumubhiikirɨ hayi?” Bhakamʉgarukirya, “Ʉmʉkʉrʉ, tujɨ tukwereche.” ");
INSERT INTO ikz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yɨɨsu akarɨra. ");
INSERT INTO ikz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Neho Abhayaahudi bhanʉ bhaarɨ muruku bhakabhuga, “Rora chɨmbu asɨɨgirɨ Razaarʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nawe abhandɨ gatɨ waabhʉ bhakabhuga, “Ʉmʉʉtʉ wʉnʉ newe aahʉriryɨ ʉmʉhʉku wurya, kwakɨ atakʉrirɨ chʉchʉsi kwa Razaarʉ atakwa?” ");
INSERT INTO ikz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Neho Yɨɨsu akiigwa naatu ʉbhʉsʉngʉ bhʉkʉngʼu mumwʉyʉ gwazɨ, akahika kumbihɨra. Imbihɨra yiyo yaarɨ ribhigi rɨnʉ rikundikiriibhwɨ na riibhwɨ ikʉrʉ kukisikʉ. ");
INSERT INTO ikz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yɨɨsu akabhʉʉrɨra abhaatʉ bhanʉ bhaareho hayo, “Muruushɨho riibhwɨ riyo.” Nawe Maarita, umwabhʉ Razaarʉ, akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, atangirɨ kuhuza, kʉ kʉbha zihitirɨ sikʉ inyɨ ari mumbihɨra.” ");
INSERT INTO ikz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yɨɨsu akamʉbhʉʉrɨra, “Nɨtaakubhuuriirɨ kʉbha, arɨɨbhɨ uriisirirya, ʉrarora ʉbhʉkʉrʉ bhwa Mungu?” ");
INSERT INTO ikz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mmbe, bhakaruushaho riibhwɨ riyo. Yɨɨsu akarora kwisaarʉ, akasabha kwa Mungu, “Bhaabha, nɨrabhuga ʉzʉmiryɨ kʉ kʉbha wiigwirɨ amasabhi gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɨɨzɨ kʉbha ʉhaanyiigwa ribhaga ryʉsi, nawe nɨragamba amangʼana ganʉ igʉrʉ wa riribhita rya abhaatʉ bhanʉ, korereke bhiisiriryɨ kʉbha awɨ naawɨ wantumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo, akoongera riraka ikʉrʉ arabhuga, “Razaarʉ, hʉrʉka igʉtʉ ɨnʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mmbe, akahʉrʉka igʉtʉ. Amagʉrʉ na amabhoko gaazɨ garingirwɨ nɨ ɨsanda, naatu ubhushʉ bhwazɨ bhuringirwɨ nɨ ɨkɨtambaara. Neho Yɨɨsu akabhʉʉrɨra abhaatʉ bhanʉ bhaarɨ bhiimiiriirɨ hayo, “Mʉmʉtazʉrɨ zengebho ziyo, mumutigɨ ajɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mmbe, Abhayaahudi bhaaru bhanʉ bhiizirɨ kwa Mariyamu, hanʉ bharʉʉzɨ ganʉ Yɨɨsu aakʉrirɨ, bhakamwisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nawe Abhayaahudi abhandɨ bhakaja kwa Abhafarisaayo, bhakabhabhʉʉrɨra ganʉ Yɨɨsu aakʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mmbe, abhakʉrʉ bha abhakuhaani na Abhafarisaayo bhakabhɨrɨkɨra ichandarʉ cha Abhayaahudi, bhakiibhuurya, “Tokorebhwɨ? Ʉmʉʉtʉ wʉnʉ arakora ibhyɨrɨkɨnʼyʉ bhyaru. ");
INSERT INTO ikz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tʉraamutigɨ angʼehe kokorabhu, abhaatʉ bhʉʉsi bharamwisirirya. Abharuumi bharaaza na kʉsarya icharʉ chɨtʉ hamwɨmwɨ na rihekaaru ryɨtʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mmbe, wʉmwɨ mʉbhakʉrʉ bhayo iriina ryazɨ Kayaafa, wʉnʉ aarɨ kuhaani ʉmʉkʉrʉ wu umwaka guyo, akabhabhʉʉrɨra, “Imwɨ mʉtɨɨzɨ chʉchʉsi! ");
INSERT INTO ikz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nangʉ, mʉtɨɨzɨ, nɨ‑hakɨrɨku kwa niimwɨ kʉbha ʉmʉʉtʉ wʉmwɨ akwɨ igʉrʉ wa abhaatʉ bhʉʉsi, kʉkɨra icharʉ chʉsi kirichwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayaafa ataagambirɨ gayo kwa amiisɨɨgi gaazɨ umwene, nawe kʉ kʉbha aarɨ kuhaani ʉmʉkʉrʉ wu umwaka guyo. Ɨbhu aarɨ ararora kʉbha Yɨɨsu arakwa igʉrʉ wa Abhayaahudi, ");
INSERT INTO ikz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na ɨtarɨ igʉrʉ waabhʉ abheene, nawe igʉrʉ wu ukubhiringa abhaana bha Mungu bhanʉ bhanyaragɨɨnɨ, korereke bhabhɨ hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwɨma urusikʉ ruyo, abhakangati bha Abhayaahudi bhakiiseemerya komohya ɨnzɨra yu ukwita Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kʉgayo, Yɨɨsu akatiga kogenda habhwɨrʉ gatɨ wa Abhayaahudi. Akabhʉʉka hayo na kuja haguhɨ nɨ ɨkɨbhara, mʉrʉbhɨri rʉnʉ rwabhirikiirwɨ Ɨfurahiimu, akiikara iyo hamwɨmwɨ na abhɨɨga bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ribhaga riyo, isigukuru yɨ Ɨpasaka ya Abhayaahudi yaarɨ haguhɨ. Kʉgayo, abhaatʉ bhaaru bhakabhʉʉka kurwa mʉzɨmbɨri zaabhʉ kuja Yɨrusarɨɨmu, korereke bhiibhɨngukyɨ isigukuru ɨkɨɨrɨ kuhika. ");
INSERT INTO ikz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Abhaatʉ bhakakaja komohya Yɨɨsu. Hanʉ bhaarɨ bhiimiiriirɨ mwihekaaru, bhakiibhuurya kʉbha, “Imwɨ mʉrarorabhwɨ? Ʉmʉʉtʉ wuyo atakuhika kusigukuru yɨnʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abhakʉrʉ bha abhakuhaani na Abhafarisaayo bhaarɨ bhaswajiryɨ kʉbha, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ amɨnyirɨ hanʉ Yɨɨsu arɨ ahirɨ amangʼana kwebho, korereke bhamugwatɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hanʉ zasaagirɨ sikʉ isaasabha kuhika isigukuru yɨ Ɨpasaka, Yɨɨsu akahika naatu Bhɨtaniya, ɨnʉ aaryurirɨ Razaarʉ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mmbe, abhaatʉ bha ahagero hayo bhakamokorera ɨnyangi. Maarita akamohokerya, na Razaarʉ aarɨ wʉmwɨ wa bhanʉ bhaarɨ komeeza hamwɨmwɨ na Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Neho Mariyamu akagega ichupa ya amaguta ga naridʉ. Amaguta gayo gaarɨ gi iguri ikʉrʉ na garareetya bhwaheene. Akahaka Yɨɨsu kʉmagʉrʉ, akamʉtaricha na zinzwɨrɨ zaazɨ. Inyumba ngima ikiizʉra uruhuzu rwa amaguta gayo. ");
INSERT INTO ikz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nawe wʉmwɨ wa abhɨɨga bhaazɨ iriina ryazɨ Yuuda Isikariyʉʉti, na newe ariichʉrɨ Yɨɨsu, akabhuga, ");
INSERT INTO ikz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwakɨ amaguta gayo gataguriibhwɨ zidinaari magana atatʉ na kʉhaabhwa abhahabhɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuuda ataagambirɨbhu igʉrʉ wo okororera abhahabhɨ ɨbhɨgʉngi, nawe nɨ‑kʉ kʉbha aarɨ mwibhi. Newe aarɨ akʉbhɨɨka ɨkɨgʉzi cha zimpirya, na aarɨ ariibha zimpirya zɨnʉ zatɨɨrwɨ mʉkɨgʉzi kiyo. ");
INSERT INTO ikz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mmbe, Yɨɨsu akabhuga, “Mutigɨ, kʉ kʉbha anhakirɨ amaguta igʉrʉ yu urusikʉ rʉnʉ bhakʉmbɨɨka. ");
INSERT INTO ikz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abhahabhɨ mʉnabhʉ sikʉ zʉʉsi, nawe inyɨ nɨtakʉbha na niimwɨ sikʉ zʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mmbe, Abhayaahudi bhaaru bhakiigwa kʉbha Yɨɨsu aarɨ iyo, bhakaja komorora, ɨtarɨ ewe umwene, nawe na Razaarʉ wʉnʉ Yɨɨsu aaryurirɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Neho abhakʉrʉ bha abhakuhaani bhakakora ɨsɨɨmi yu ukwita Razaarʉ wʉʉsi, ");
INSERT INTO ikz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kʉ kʉbha igʉrʉ waazɨ, Abhayaahudi bhaaru bhaarɨ bhariiyaahʉra na abhakangati bhaabhʉ, bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tabhʉʉri waho, riribhita ikʉrʉ rya abhaatʉ bhanʉ bhiizirɨ kurya isigukuru yɨ Ɨpasaka, bhakiigwa kʉbha Yɨɨsu arɨ mʉnzɨra kuuza Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mmbe, bhakagega ibhisha bhye emetende, bhakaja kʉmʉsʉngʼaana Yɨɨsu. Bhakatiirya riraka bharabhuga, “Akumibhwɨ! Anʉ ʉrʉbhangʉ wʉnʉ akuuza kuriina ryʉ Ʉmʉkʉrʉ! Anʉ ʉrʉbhangʉ Ʉmʉtɨmi wa Abhiiziraɨri.” ");
INSERT INTO ikz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mmbe, Yɨɨsu akabhona umwana wɨ ɨtɨkɨrɨ, akiikara igʉrʉ wayʉ chɨmbu yandikirwɨ mʉMaandɨkʉ Amarɨndu, ");
INSERT INTO ikz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Abhaatʉ bha Sayuuni, mʉtʉʉbhaha! Rora, ʉmʉtɨmi waanyu araaza, ikɨɨrɨ kumwana wɨ ɨtɨkɨrɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ribhaga riyo, abhɨɨga bha Yɨɨsu bhataagamɨnyirɨ amangʼana gayo. Nawe hanʉ Yɨɨsu aaryukirɨ neho bhaahiitirɨ kʉbha amangʼana gayo nɨmbu gaandikirwɨ na nɨmbu bhaamʉkʉrɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abhaatʉ bhanʉ bhaarɨ na Yɨɨsu ribhaga rɨnʉ aabhirikiirɨ Razaarʉ kurwa mumbihɨra na kumuryʉra kurwa kʉbhaku, bhakabha bharanyaraganʼya ɨngʼana yiyo kʉbhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kʉgayo, abhaatʉ bhaaru bhaarɨ bhiigwirɨ igʉrʉ wi ichɨrɨkɨnʼyʉ kɨnʉ Yɨɨsu aakʉrirɨ, ɨkagirya abhaatʉ bhakarwa Yɨrusarɨɨmu kuja kʉmʉsʉngʼaana. ");
INSERT INTO ikz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nawe Abhafarisaayo bhakiibhʉʉrɨra, “Mʉrarora, tʉtakʉtʉra kokora chʉchʉsi! Rora, abhaatʉ bhʉʉsi bharamutuna.” ");
INSERT INTO ikz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwarɨ na abhaatʉ bhanʉ bhatarɨ Abhayaahudi gatɨ wa abhaatʉ bhanʉ bhaagiirɨ Yɨrusarɨɨmu kusigukuru yɨ Ɨpasaka kosengera Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mmbe, abhaatʉ bhayo bhakaja kwa Firipʉ wa Bhɨtɨsaida mucharʉ cha Gariraaya, bhakamʉsabha, “Ʉmʉkʉrʉ, tʉrasabha turumanɨ na Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Firipʉ akaja kʉbhʉʉrɨra Andureya amangʼana gayo, akʉmara bhʉʉsi bhabhɨrɨ bhakaja kʉbhʉʉrɨra Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yɨɨsu akabhuga, “Ribhaga rihikirɨ ryu Umwana wʉ Ʉmʉʉtʉ kugungibhwa. ");
INSERT INTO ikz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨrabhabhʉʉrɨra amaheene, arɨɨbhɨ endetere yɨ ɨnganʉ ɨkɨɨrɨ kugwa mwirobha na kukwa, ɨtakʉtʉra komera. Nawe arɨɨbhɨ igwirɨ na kukwa, neho ekomera na kwibhʉra imisumʉ. ");
INSERT INTO ikz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ʉmʉʉtʉ wʉnʉ asɨɨgirɨ ʉbhʉhʉru bhwazɨ umwene, arabhurimirya. Nawe ʉmʉʉtʉ wʉnʉ akubhiihirirwa ʉbhʉhʉru bhwazɨ mʉʉsɨ yɨnʉ, wuyo arahonʼya nʉʉrʉ ʉbhʉhʉru bhwazɨ kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ʉmʉʉtʉ wʉnʉ akonhokerya, ereenderwa antunɨ. Hʉhʉʉsi hanʉ nɨrɨ, hayo neho no omohocha waanɨ akʉbha. Bhaabha arasʉʉka ʉmʉʉtʉ wʉnʉ akonhokerya.” ");
INSERT INTO ikz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yɨɨsu akabhuga, “Nangʉ ekoro yaanɨ irumikirɨ bhʉkʉngʼu. Nibhugɨbhwɨ? Nibhugɨ, ‘Bhaabha, nɨrakʉsabha ʉnsabhʉrɨ kwibhaga ryɨ ɨnyaakʉ rɨnʉ?’ Nɨtakʉtʉra kʉmʉsabhabhu, kʉ kʉbha niizirɨ mʉʉsɨ yɨnʉ korereke nebhone ɨnyaakʉ yiyo. ");
INSERT INTO ikz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bhaabha Mungu, werekenʼye ʉbhʉgʉngʉ bhwi iriina ryazʉ.” Neho riraka rɨkarwa mwisaarʉ rɨrabhuga, “Nɨrɨkɨɨnʼyɨ ʉbhʉgʉngʉ bhwanɨ, na kwikɨ nereerekanʼya.” ");
INSERT INTO ikz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hanʉ riribhita rya abhaatʉ bhanʉ bhiimiiriirɨ hayo bhiigwirɨ, abhandɨ bhakabhuga, “Ʉrʉkʉbha rʉparukirɨ,” na abhandɨ bhakabhuga, “Maraika agambɨɨnɨ nawe.” ");
INSERT INTO ikz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yɨɨsu akabhabhʉʉrɨra, “Riraka rɨnʉ mwigwirɨ rɨtarɨ igʉrʉ waanɨ, nawe igʉrʉ waanyu. ");
INSERT INTO ikz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nangʉ rihikirɨ ribhaga ryʉ ʉkʉtɨnɨra ɨɨsɨ yɨnʉ. Na rihikirɨ ribhaga ryo okoheebha Shɨtaani ʉmʉkʉrʉ wɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hanʉ inyɨ nikutiiribhwa igʉrʉ, nɨraruta bhʉʉsi, bhaazɨ kwa niinyɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yɨɨsu akagambabhu, kwerecha uruku rwazɨ kʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mmbe, abhaatʉ bhayo bhakagarukirya, “Tʉsʉmirɨ mʉMaandɨkʉ Amarɨndu, Kiriisitʉ arabha ariikara kemerano. Nangʉ, kwakɨ ʉrabhuga, ereenderwa Umwana wʉ Ʉmʉʉtʉ atiiribhwɨ igʉrʉ? Umwana wʉ Ʉmʉʉtʉ nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yɨɨsu akabhabhʉʉrɨra, “Ubhwɨrʉ bhʉrabha hamwɨmwɨ na niimwɨ kwibhaga isuuhubhu. Mʉkajɨ kogenda mubhwɨrʉ bhʉnʉ mʉnabhwɨ, korereke ikiirimya kɨtaaza kʉbhahiza, kʉ kʉbha ʉmʉʉtʉ wʉnʉ akogenda mukiirimya, atɨɨzɨ hanʉ akuja. ");
INSERT INTO ikz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kwa ribhaga rɨnʉ munu ubhwɨrʉ, mwisiriryɨ ubhwɨrʉ bhuyo, korereke mʉbhɨ abhaana bhu ubhwɨrʉ.” Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo, akatiga riribhita rya abhaatʉ bhayo, akiibhisa. ");
INSERT INTO ikz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nangabha Yɨɨsu akakora ibhyɨrɨkɨnʼyʉ bhyaru mʉbhʉtangɨ bhwabhʉ, abhaatʉ bhaaru bhatamwisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɨkabhabhu korereke gahikɨ amangʼana ganʉ ʉmʉrʉʉtɨrɨri Isaaya aagambirɨ, “Ʉmʉkʉrʉ, nɨ‑wɨɨwɨ wʉnʉ isiriiryɨ amangʼana gɨɨtʉ? Na, nɨ‑wɨɨwɨ wʉnʉ Ʉmʉkʉrʉ aamwɨrɨchiryɨ amanaga gaazɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bhatamwisiriiryɨ kʉ kʉbha Mungu akagamba naatu kʉhɨtɨra kwa Isaaya, ");
INSERT INTO ikz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nɨbhahukwiryɨ amɨɨsʉ, nɨkʉrirɨ zekoro zaabhʉ zɨbhɨ kʉngʼu, korereke bhatarora kwa amɨɨsʉ gaabhʉ, bhatamenya kozekoro zaabhʉ, bhataaza kwichʉra, na niinyɨ nɨbhasabhʉrɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaaya akarora ʉbhʉkʉrʉ bhwa Yɨɨsu, akagamba amangʼana gayo igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nʉʉrʉbhu abhakangati bhaaru bha Abhayaahudi bhakiisirirya Yɨɨsu, nawe bhataagambirɨ habhwɨrʉ kʉbha bhamwisiriiryɨ, kʉ kʉbha bhaarɨ bharʉʉbhaha koheebhwa na Abhafarisaayo mwirwazɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abhakangati bhayo bhakasɨɨga bhʉkʉngʼu kukumibhwa na abhaatʉ, kʉkɨra kukumibhwa na Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mmbe, Yɨɨsu akagamba kwiraka ikʉrʉ, “Ʉmʉʉtʉ wʉnʉ akunyiisirirya inyɨ, atakunyiisirirya inyimwene, nawe ariisirirya na wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wʉnʉ akondora inyɨ, arʉʉzɨ na wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inyɨ niinyɨ ubhwɨrʉ, niizirɨ kʉʉsɨ kʉnʉ korereke bhʉʉsi bhanʉ bhakunyiisirirya bhatigɨ kʉbha mukiirimya. ");
INSERT INTO ikz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ʉmʉʉtʉ wʉnʉ akwigwa amangʼana gaanɨ, nawe atamɨ kʉgagwata, inyɨ nɨtakʉmʉtɨnɨra, kʉ kʉbha nitiizirɨ mʉʉsɨ kʉtɨnɨra abhaatʉ, nawe kʉbhasabhʉra. ");
INSERT INTO ikz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɨbhuɨbhu, ʉmʉʉtʉ wʉnʉ akʉnyanga inyɨ na amangʼana gaanɨ, araaza ukutinirwa. Amangʼana ganʉ nɨgambirɨ nego gakuuza kʉmʉtɨnɨra urusikʉ rwɨ ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Inyɨ nɨtagambirɨ kʉbhʉnaja bhwanɨbhu, nawe Bhaabha wʉnʉ antumirɨ, newe ambuuriirɨ gʉ ʉkʉgamba na chɨmbu nɨraagambɨ. ");
INSERT INTO ikz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Inyʉʉsi, nɨɨzɨ kʉbha ubhuswaja bhwazɨ bhwahaareeta ʉbhʉhʉru bhwa kemerano. Mmbe, inyɨ nɨragamba ganʉ Bhaabha antumirɨ kʉgamba ageene.” ");
INSERT INTO ikz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mmbe hanʉ isigukuru yɨ Ɨpasaka yaarɨ ɨkɨɨrɨ kuhika, Yɨɨsu akamenya ribhaga ryazɨ ryu ukurwa kʉʉsɨ kuja kwa Wiisɨ rihikirɨ. Yɨɨsu aarɨ abhasɨɨgirɨ abhaatʉ bhaazɨ bhanʉ bhaarɨ kʉʉsɨ, na akabhasɨɨga kuhika ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yɨɨsu na abhɨɨga bhaazɨ bhakiikara kurya ibhyakurya bhya rigoroobha. Ribhaga riyo, Shɨtaani aarɨ amarirɨ kokorokomba Yuuda, umwana wa Simʉʉni Isikariyʉʉti, korereke ichʉrɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yɨɨsu akamenya Wiisɨ akamoha ʉbhʉnaja bhwʉ ʉkʉkangata ebhegero bhyʉsi. Na akamenya kʉbha ewe akarwa kwa Mungu, na aragarʉka kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mmbe, Yɨɨsu akarwa kubhyakurya, akiimɨɨrɨra, akaruusha ɨkanzʉ yaazɨ yi igʉrʉ, akagega ɨkɨsagi akiibhoha mukiribhizi. ");
INSERT INTO ikz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akʉmara akatʉʉra amanzi mʉbhakuri. Akatanga kwoja abhɨɨga bhaazɨ amagʉrʉ na kʉbhataricha nɨ ɨkɨsagi kɨnʉ aarɨ ibhʉhirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hanʉ aamuhikiirɨ Simʉʉni Peetero, Peetero akamubhuurya, “Ʉmʉkʉrʉ, oreenda konyoja inyɨ amagʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yɨɨsu akamʉgarukirya, “Awɨ ʉtakʉtʉra kwobhoora ganʉ nekokora nangwɨnʉ, nawe ʉragoobhoora ribhaga rɨnʉ rikuuza.” ");
INSERT INTO ikz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peetero akabhuga, “Ʉtakonyoja amagʉrʉ gaanɨ!” Yɨɨsu akamʉbhʉʉrɨra, “Arɨɨbhɨ nɨtakukwoja, ʉtakʉtʉra kʉbha hamwɨmwɨ na niinyɨ zee.” ");
INSERT INTO ikz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simʉʉni Peetero akabhuga, “Ʉmʉkʉrʉ, nangʉ ʉtanyoja amagʉrʉ ageene, nawe na amabhoko hamwɨmwɨ nu umutwɨ gwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yɨɨsu akamʉgarukirya, “Ʉmʉʉtʉ wʉnʉ isaabhirɨ, atakwenderwa kwisaabha kwikɨ, nawe kwoja amagʉrʉ ageene, kʉ kʉbha ni mwɨrʉ. Na niimwɨ nɨ‑bhɨɨrʉ, nawe mʉtarɨ imwʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yɨɨsu aarɨ amwɨzɨ wʉnʉ araamwichʉrɨ, necho chagiriryɨ akabhuga, “Nawe ɨtarɨ imwʉsi.” ");
INSERT INTO ikz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hanʉ Yɨɨsu aamarirɨ kobhooja amagʉrʉ, akiibhoha ɨkanzʉ yaazɨ, akiikara naatu hanʉ aarɨ, akabhabhuurya, “Nangʉ, mwʉbhʉʉrirɨ ganʉ nɨbhakʉrɨɨrɨ? ");
INSERT INTO ikz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imwɨ mʉrambɨrɨkɨra, ‘Umwija,’ na mʉrambɨrɨkɨra, ‘Ʉmʉkʉrʉ.’ Mʉragamba amaheene, kʉ kʉbha inyɨ nɨmbu nɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arɨɨbhɨ inyɨ Umwija nʉ Ʉmʉkʉrʉ waanyu, nɨbhʉʉjiryɨ amagʉrʉ gaanyu, ereenderwa na niimwɨ mʉbhɨ muriiyoja amagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nɨbhɨɨrɨkiryɨ ekerenjo, korereke na niimwɨ mʉbhɨ muriikorera chɨmbu inyɨ nɨbhakʉrɨɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nɨrabhabhʉʉrɨra amaheene, mbʉʉsa atarɨ mʉkʉrʉ kʉkɨra umuniibhi waazɨ, na wʉnʉ akutumwa atarɨ mʉkʉrʉ kʉkɨra wʉnʉ akʉmʉtʉma. ");
INSERT INTO ikz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mʉraagamenye gayo, nɨ‑hakɨrɨku hanʉ mʉraagakore. ");
INSERT INTO ikz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nɨtakʉgambɨra ganʉ igʉrʉ waanyu imwʉsi. Nɨbhɨɨzɨ abhaatʉ bhanʉ nɨrʉbhwɨrɨ kʉbha abhɨɨga bhaanɨ. Nawe nɨgambirɨ ganʉ korereke gabhɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, ‘Mʉsaani waanɨ wʉnʉ aarɨ ararya ibhyakurya hamwɨmwɨ na niinyɨ, ichurirɨ kʉbha umubhisa waanɨ.’ ");
INSERT INTO ikz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nɨrabhabhʉʉrɨra gʉʉsi ganʉ gakɨɨrɨ kʉhʉrʉka, korereke hanʉ gakʉhʉrʉka, mwisiriryɨ inyɨ newe. ");
INSERT INTO ikz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉnʉ ariisiriryɨ wʉnʉ nitumirɨ, anyiisiriiryɨ inyɨ. Ɨbhuɨbhu, wʉnʉ akunyiisirirya, isiriiryɨ Bhaabha wʉnʉ antumirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Hanʉ Yɨɨsu aagambirɨ gayo, akarumɨka bhʉkʉngʼu mumwʉyʉ, akabhuga, “Nɨrabhabhʉʉrɨra amaheene, wʉmwɨ waanyu aranyiichʉra.” ");
INSERT INTO ikz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Abhɨɨga bhaazɨ bhakatanga kwirorarora, kʉ kʉbha bhataamɨnyirɨ aragamba wɨɨwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aareho umwɨga wʉmwɨ, wʉnʉ Yɨɨsu aasɨɨgirɨ bhʉkʉngʼu. Ewe aarɨ iikɨɨrɨ haguhɨ na Yɨɨsu ribhaga ryu kurya. ");
INSERT INTO ikz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mmbe, Simʉʉni Peetero akasimya umwɨga wuyo, akamʉbhʉʉrɨra, “Mubhuuryɨ arabhuga wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mmbe, umwɨga wʉnʉ aarɨ ihɨgɨkirɨku Yɨɨsu, akabhuurya, “Ʉmʉkʉrʉ, nɨ‑wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yɨɨsu akagarukirya, “Nɨ‑wʉnʉ nekoha ɨkɨtɨnɨka chʉ ʉmʉkaatɨ kɨnʉ nekokorya.” Mmbe, akagega ɨkɨtɨnɨka chʉ ʉmʉkaatɨ akakorya mʉbhakuri, akaha Yuuda, umwana wa Simʉʉni Isikariyʉʉti. ");
INSERT INTO ikz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hanʉ Yuuda aamarirɨ kogega ɨkɨtɨnɨka kiyo, Shɨtaani akamusikɨra. Neho Yɨɨsu akamʉbhʉʉrɨra, “Ganʉ ukwenda kokora, gakore bhwangʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nawe atareeho nʉʉrʉ wʉmwɨ wa bhanʉ bhaarɨ bhararya wʉnʉ aamɨnyirɨ kwakɨ Yɨɨsu akagambabhu. ");
INSERT INTO ikz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Abhandɨ bhakakina Yɨɨsu amubhuuriirɨ agʉrɨ bhɨnʉ bhikwenderwa kusigukuru, hamwɨ abhahɨ abhahabhɨ zimpirya ekerengo ekerebhe, kʉ kʉbha newe aarɨ umugwatiriri wɨ ɨkɨgʉzi cha zimpirya. ");
INSERT INTO ikz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mmbe, hanʉ Yuuda aagɨgirɨ ɨkɨtɨnɨka kirya, hayohayo akahʉrʉka igʉtʉ. Ribhaga riyo ryarɨ bhutikʉ. ");
INSERT INTO ikz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mmbe hanʉ Yuuda aahurukirɨ igʉtʉ, Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Nangʉ ukugungibhwa ku Umwana wʉ Ʉmʉʉtʉ kʉraariirɨ kororekana habhwɨrʉ. Nu ukugungibhwa kwa Mungu kʉrarorekana habhwɨrʉ kʉhɨtɨra kwawɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Arɨɨbhɨ ʉbhʉkʉrʉ bhwazɨ bhʉrarorekana kʉhɨtɨra Umwana wʉ Ʉmʉʉtʉ, mmbe Mungu wʉʉsi arabheerecha abhaatʉ ʉbhʉkʉrʉ bhu Umwana wʉ Ʉmʉʉtʉ, na arakorabhu bhwangʉ. ");
INSERT INTO ikz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Imwɨ abhaana bhaanɨ, nɨrabha na niimwɨ kwi ibhaga isuuhubhu. Mʉramonhya, nawe chɨmbu nabhuuriirɨ Abhayaahudi, ɨnʉ nikuja imwɨ mʉtakʉtʉra kuuza, nɨmbu nɨkʉbhabhʉʉrɨra na niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nɨrabhaha ubhuswaja ubhuhya, mʉsɨɨganɨ. Chɨmbu inyɨ nɨbhasɨɨgirɨ, na niimwɨ mʉsɨɨganɨ ɨbhuɨbhu. ");
INSERT INTO ikz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉraasɨɨganɨ, abhaatʉ bhʉʉsi bharamenya kʉbha, imwɨ nɨ‑bhɨɨga bhaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mmbe, Simʉʉni Peetero akabhuurya, “Ʉmʉkʉrʉ, ʉraja hayi?” Yɨɨsu akamʉgarukirya, “Nɨraja hanʉ awɨ ʉtakʉtʉra kuntuna nangwɨnʉ, nawe ʉrantuna ibhaga rɨndɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peetero akamubhuurya, “Ʉmʉkʉrʉ, kwakɨ nitigɨ kukutuna nangwɨnʉ? Inyɨ nɨrakwa igʉrʉ waazʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yɨɨsu akamʉgarukirya, “Peetero, maheene uriisirirya kukwa igʉrʉ waanɨ? Nɨrakʉbhʉʉrɨra amaheene, ekorokoome ɨkɨɨrɨ kʉgamba, ʉrabha ʉnyangirɨ manga katatʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yɨɨsu akangʼeha kwija abhɨɨga bhaazɨ arabhuga, “Mʉtarumɨka mozekoro zaanyu, mwisiriryɨ Mungu, munyiisiriryɨ na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mumujɨ gwa Bhaabha hu ukwikara nɨ‑haaru. Angabhɨɨrɨ ɨtarɨbhu, naarɨ nɨrabhabhʉʉrɨra. Nangʉ nɨraja kʉbhakonzera ahagero. ");
INSERT INTO ikz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Hanʉ nɨkʉmara kʉbhakonzera, nɨraaza naatu kʉbhagega korereke ahagero hanʉ nɨkʉbha, na niimwɨ mʉbhɨhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Imwɨ mwɨzɨ ɨnzɨra yu ukuhika hanʉ nikuja.” ");
INSERT INTO ikz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Neho Tomaaso akabhuga, “Ʉmʉkʉrʉ, tʉtɨɨzɨ hanʉ ukuja. Nangʉ, tʉratʉrabhwɨ komenya ɨnzɨra?” ");
INSERT INTO ikz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yɨɨsu akamʉbhʉʉrɨra, “Inyɨ niinyɨ ɨnzɨra, amaheene nʉ ʉbhʉhʉru. Atareeho wʉnʉ akʉtʉra kuuza kwa Bhaabha arɨɨbhɨ akɨɨrɨ kʉhɨtɨra kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mwangamɨnyirɨ inyɨ, mwarɨ mʉramenya na Bhaabha. Kwɨma nangwɨnʉ, mumwɨzɨ na mʉmʉrʉʉzɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Firipʉ akamʉbhʉʉrɨra, “Ʉmʉkʉrʉ, tʉrakʉsabha utwereche Bhaabha, riyo iryene ririisa.” ");
INSERT INTO ikz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yɨɨsu akamʉgarukirya, “Firipʉ, nɨbhɨɨrɨ hamwɨmwɨ na niimwɨ ibhaga rɨnʉ ryʉsi, ʉkɨɨrɨ komenya? Ʉmʉʉtʉ wʉnʉ andʉʉzɨ inyɨ, amʉrʉʉzɨ Bhaabha. Kwakɨ ʉrambuurya, ‘Twereche Bhaabha?’ ");
INSERT INTO ikz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nangʉ, ʉtakwisirirya inyɨ nɨrɨ kwa Bhaabha, na Bhaabha arɨ kwa niinyɨ? Amangʼana ganʉ nɨkʉbhabhʉʉrɨra gatakurwa mumiisɨɨgi gaanɨ, nawe Bhaabha wʉnʉ arɨ kwa niinyɨ, arakora emeremo jazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwisiriryɨ ganʉ nɨkʉgamba kʉbha, nɨrɨ kwa Bhaabha, neewe arɨ kwa niinyɨ. Nawe arɨɨbhɨ mʉtakwisirirya gayo, ambe mwisiriryɨ igʉrʉ we emeremo gɨnʉ nekokora. ");
INSERT INTO ikz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nɨrabhabhʉʉrɨra amaheene, ʉmʉʉtʉ wʉnʉ akunyiisirirya, arakora emeremo gɨnʉ inyɨ nekokora. Na arakora mɨkʉrʉ kʉkɨra gɨnʉ nekokora, kʉ kʉbha inyɨ nɨraja kwa Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hanʉ mʉkʉsabha chʉchʉsi kuriina ryanɨ, inyɨ nɨrakora, korereke kʉhɨtɨra Umwana ukugungibhwa kwa Bhaabha kororekanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na mʉransabhɨ ekegero chʉchʉsi kuriina ryanɨ, nɨrakora. ");
INSERT INTO ikz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Arɨɨbhɨ mʉnsɨɨgirɨ, mʉragwata amaswaja gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mmbe, na niinyɨ nɨrasabha Bhaabha abhahɨ Ʉmʉsakirya ʉwʉndɨ, korereke abhɨ na niimwɨ kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ewe newe Ekoro ya Amaheene. Abhaatʉ bhanʉ bhakwanga Mungu bhatakʉtʉra kʉyɨsʉngʼaana, kʉ kʉbha bhatakoyerora, na bhatayɨɨzɨ. Nawe imwɨ muyɨɨzɨ Ekoro yiyo, kʉ kʉbha iriikara kwa niimwɨ, na ɨrabha kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nɨtakʉbhatiga imubheene ncha abhahabhɨ, naatu nɨragarʉka kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Rɨkɨɨrɨ ibhaga isuuhu ɨɨsɨ ɨtakondora. Nawe imwɨ mʉrandora, na kʉ kʉbha inyɨ mʉhʉru, na niimwɨ mʉrabha bhahʉru. ");
INSERT INTO ikz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Urusikʉ ruyo, mʉramenya kʉbha inyɨ nɨrɨ kwa Bhaabha, na niimwɨ mʉrɨ kwa niinyɨ, na niinyɨ nɨrɨ kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ʉmʉʉtʉ wʉnʉ ɨɨzɨ amaswaja gaanɨ na kʉgagwata, wuyo newe ansɨɨgirɨ. Nʉ ʉmʉʉtʉ wʉnʉ ansɨɨgirɨ, Bhaabha aramʉsɨɨga. Na niinyɨ nɨramʉsɨɨga na kwiyeerecha kwawɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mmbe, umwɨga wʉmwɨ iriina ryazɨ Yuuda, atarɨ Yuuda Isikariyʉʉti, akabhuurya Yɨɨsu, “Ʉmʉkʉrʉ, ɨratʉrɨkanabhwɨ oreenda kwiyeerekanʼya kwa niitwɨ, nawe ʉtakwiyeerekanʼya kʉʉsɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yɨɨsu akamʉgarukirya, “Ʉmʉʉtʉ aransɨɨgɨ, aragwata amangʼana gaanɨ, na Bhaabha aramʉsɨɨga. Inyɨ na Bhaabha tʉraaza kwawɨ na kwikara hamwɨmwɨ nawe. ");
INSERT INTO ikz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nawe ʉmʉʉtʉ wʉnʉ atansɨɨgirɨ, atakugwata amangʼana gaanɨ. Na ganʉ mukwigwa gatarɨ gaanɨ, nawe gararwa kwa Bhaabha wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nɨbhabhuuriirɨ gʉʉsi gayo nɨkɨɨrɨ hamwɨmwɨ na niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nawe Ʉmʉsakirya wuyo, newe Ekoro Ɨndɨndu, Bhaabha aramʉtʉma kwa niimwɨ kuriina ryanɨ, arabhiija na kʉbhahiitya gʉʉsi ganʉ naarɨ nɨbhabhuuriirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Hanʉ nɨkʉbhʉʉka, nɨrabhatigɨra omorembe, omorembe gwanɨ nɨrabhaha. Nawe gʉnʉ nɨkʉbhaha gʉtangɨ gʉnʉ abhaatʉ bhahaabhaha. Mutiitiimaata mozekoro zaanyu, na mʉtʉʉbhaha. ");
INSERT INTO ikz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwigwirɨ ganʉ nabhabhuuriirɨ, ‘Nɨraja, akʉmara nɨragarʉka naatu kwa niimwɨ.’ Angabhɨɨrɨ mʉnsɨɨgirɨ, mwarɨ mʉrazomerwa kwigwa nɨraja kwa Bhaabha, kʉ kʉbha Bhaabha nɨ‑mʉkʉrʉ kʉkɨra inyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nɨbhabhuuriirɨ amangʼana gayo, gakɨɨrɨ kororekana, korereke hanʉ gakororekana mʉtʉrɨ kunyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nɨtakʉtʉra kʉgamba na niimwɨ ibhaga irɨɨhu, kʉ kʉbha ʉmʉkʉrʉ wɨ ɨɨsɨ yɨnʉ araaza. Nawe ataana ʉbhʉnaja igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ganʉ nekokora nɨ‑ganʉ Bhaabha answajiryɨ kokora, korereke abhaatʉ bhʉʉsi bhamenye kʉbha nɨmʉsɨɨgirɨ. “Nangʉ, mʉbhʉʉkɨ tujɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yɨɨsu akangʼeha kubhiija, “Inyɨ nɨ‑mʉzabhiibhu gwa amaheene, na Bhaabha waanɨ ni‑murimi. ");
INSERT INTO ikz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ikisha chʉchʉsi kɨnʉ kɨrɨ kwa niinyɨ na kɨtakwibhʉra imisumʉ, Bhaabha arakiruushaho. Nawe ikisha kɨnʉ kikwibhʉra imisumʉ, Bhaabha ahaakɨtagʉrɨra korereke chibhʉrɨ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Imwɨ mʉmarirɨ kʉbhɨngukibhwa, kʉ kʉbha mwisiriiryɨ amiija gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mʉsaagɨ kwa niinyɨ, na niinyɨ nɨsaagɨ kwa niimwɨ. Chɨmburya ikisha kɨtakʉtʉra kwibhʉra imisumʉ ichene arɨɨbhɨ kɨtakʉsaaga kʉmʉzabhiibhu, ɨbhuɨbhu mʉtakʉtʉra kokora ʉbhʉsɨɨgi bhwa Mungu arɨɨbhɨ mʉtasaagirɨ kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Inyɨ nɨ‑mʉzabhiibhu, na niimwɨ ni‑bhisha. Ʉmʉʉtʉ wʉnʉ akʉsaaga kwa niinyɨ, na niinyɨ nɨrasaaga kwawɨ, wuyo arabha ariibhʉra imisumʉ myaru, kʉ kʉbha kutiga inyɨ mʉtakʉtʉra kokora ryʉryʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ atakʉsaaga mʉʉsi waanɨ atuubhɨɨnɨ ni ikisha kɨnʉ kɨkʉtaashwa na kwʉma. Mmbe, abhaatʉ bharaketoora na kʉkɨtaasha momorero, kɨrarʉngʉra. ");
INSERT INTO ikz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Arɨɨbhɨ mʉrasaaga mʉʉsi waanɨ na amangʼana gaanɨ garasaaga mʉʉsi waanyu, mʉsabhɨ chʉchʉsi kɨnʉ mukwenda, mʉrahaabhwa. ");
INSERT INTO ikz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arɨɨbhɨ muriibhʉra imisumʉ myaru na kʉbha abhɨɨga bhaanɨ bha amaheene, mʉrabha mʉragʉnga habhwɨrʉ Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Chɨmburya Bhaabha ansɨɨgirɨ inyɨ, nɨmbu na niinyɨ nɨbhasɨɨgirɨ. Mmbe mʉsaagɨ mʉbhʉsɨɨgi bhwanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Arɨɨbhɨ mʉragwata amaswaja gaanɨ, mʉrakaja kʉsaaga mʉbhʉsɨɨgi bhwanɨ, chɨmburya inyɨ nigwatirɨ ganʉ Bhaabha answajiryɨ na kʉsaaga mʉbhʉsɨɨgi bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nɨbhabhuuriirɨ ganʉ korereke obhozomerwa bhwanɨ bhʉbhɨ mʉʉsi waanyu, no obhozomerwa bhwanyu bhuhikɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Riswaja ryanɨ nɨ‑rɨnʉ, mʉsɨɨganɨ, chɨmburya inyɨ nɨbhasɨɨgirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Atareeho ʉmʉʉtʉ wʉnʉ anʉ ʉbhʉsɨɨgi ʉbhʉkʉrʉ kʉkɨra wʉnʉ akuhurucha ʉbhʉhʉru bhwazɨ igʉrʉ wa abhasaani bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Arɨɨbhɨ mʉrakora ganʉ nɨbhaswajiryɨ, imwɨ nɨ‑bhasaani bhaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kwɨma nangwɨnʉ, nɨtakʉbha nɨrabhabhɨrɨkɨra naatu abhahocha bhaanɨ, kʉ kʉbha omohocha atɨɨzɨ kɨnʉ ʉmʉkʉrʉ waazɨ akokora. Nawe imwɨ nɨbhahumburiirɨ gʉʉsi ganʉ niigwirɨ kurwa kwa Bhaabha, mmbe ɨbhu nɨrabha nɨrabhabhɨrɨkɨra abhasaani bhaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Imwɨ mʉkɨɨrɨ kondobhora inyɨ, nawe niinyɨ nɨbharʉbhwɨrɨ imwɨ. Nɨkabharobhora korereke mujɨ mwibhʉrɨ imisumʉ gɨnʉ gɨtakusira. Moreekorebhu, gʉʉsi ganʉ mʉkʉsabha kʉhɨtɨra kuriina ryanɨ, Bhaabha arabhaha. ");
INSERT INTO ikz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mmbe, riswaja ryanɨ kwa niimwɨ nɨ rɨnʉ, mʉsɨɨganɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yɨɨsu akangʼeha kubhiija, “Arɨɨbhɨ abhaatʉ bha kʉʉsɨ bharaabhabhiihirirwɨ, mʉbhɨ mʉrahiita kʉbha bhakakangata kumbiihirirwa inyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mwangabhɨɨrɨ abhaatʉ bha kʉʉsɨ yɨnʉ, bhayo bhaarɨ bharabhasɨɨga chɨmburya bhabhasɨɨgirɨ abhaatʉ bhaabhʉ. Nawe kʉ kʉbha imwɨ mʉtarɨ bha kʉʉsɨ yɨnʉ na nɨbharʉbhwɨrɨ kurwa kʉʉsɨ yɨnʉ, igʉrʉ wa riyo, abhaatʉ bha kʉʉsɨ bharabhabhiihirirwa. ");
INSERT INTO ikz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muhiitɨ ganʉ nabhabhuuriirɨ, ‘Mbʉʉsa atarɨ mʉkʉrʉ kʉkɨra umuniibhi waazɨ.’ Mmbe, arɨɨbhɨ bhakanyaacha inyɨ, bharabhanyaacha na niimwɨ kwikɨ. Nawe arɨɨbhɨ bhakiisirirya amiija gaanɨ, bhariisirirya na agaanyu. ");
INSERT INTO ikz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nawe bharabhakorera gʉʉsi gayo kʉ kʉbha mʉrantuna inyɨ, na kʉ kʉbha bhatɨɨzɨ wʉnʉ antumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Arɨɨbhɨ nangatamirɨ kuuza kwebho na kʉgamba nabhʉ, mmbe bhataarɨ bharabha nʉ ʉbhʉbhɨ. Nawe nangʉ, bhatakʉtʉra kwibhagɨra kʉbha bhataana ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akumbiihirirwa inyɨ, wʉʉsi arabhiihirirwa na Bhaabha waanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nɨkʉrirɨ ɨbhɨsɨgʉ ɨbhɨkʉrʉ bhɨnʉ ʉwʉndɨ akɨɨrɨ kokora. Angabhɨɨrɨ bhatabhɨrʉʉzɨ, bhangabhɨɨrɨ bhataana ʉbhʉbhɨ. Nawe nangʉ, bharʉʉzɨ ganʉ gʉʉsi nakʉrirɨ, bhakɨɨrɨ bhambiihiriirwɨ na bhabhiihiriirwɨ Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nawe ganʉ gakʉrirwɨ korereke kuhicha amangʼana ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu kʉbha, ‘Bhakambiihirirwa bhʉʉha.’ ");
INSERT INTO ikz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nɨratʉma kwa niimwɨ Ʉmʉsakirya, ʉmʉsakirya wuyo ne‑Koro Ɨndɨndu, newe ahaahumburɨra abhaatʉ bhʉʉsi amaheene. Ararwa kwa Bhaabha, na hanʉ akuhika kwa niimwɨ, arabhamenyeekererya amaheene gaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na niimwɨ imwʉsi mʉramenyeekererya amangʼana gaanɨ, kʉ kʉbha mwarɨ hamwɨmwɨ na niinyɨ kwɨma ʉbhʉtangɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nɨbhabhuuriirɨ gʉʉsi ganʉ korereke mʉtatiga kunyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nawe abhaatʉ bharabha bharabhaahʉra imwɨ mʉmarwazɨrʉ gaabhʉ. Rɨraaza ribhaga rɨnʉ ʉmʉʉtʉ wʉwʉʉsi arabhiita, ariiseega kʉbha arakora emeremo ja Mungu. ");
INSERT INTO ikz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bharabhakorerabhu, kʉ kʉbha bhatɨɨzɨ Bhaabha, nʉʉrʉ inyɨ, bhatanyɨzɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nawe nɨbhabhuuriirɨ gayo, korereke ribhaga ryabhʉ ryo okokora gayo hanʉ rikuhika, muhiitɨ kʉbha nɨkabhabhʉʉrɨra. “Nɨtabhabhuuriirɨ gayo gʉʉsi mʉbhʉtangɨ, kʉ kʉbha naarɨ hamwɨmwɨ na niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mmbe, nangʉ nɨraja kwa Bhaabha wʉnʉ antumirɨ kwa niimwɨ. Nawe atareeho wʉwʉʉsi gatɨgatɨ waanyu wʉnʉ akumbuurya, ‘Nangʉ, ʉraja hayi?’ ");
INSERT INTO ikz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Murumikirɨ bhʉkʉngʼu mozekoro zaanyu kʉ kʉbha nɨrabhabhʉʉrɨra nɨraja kwa Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Nɨrabhabhʉʉrɨra amaheene kʉbha, nɨraja kwa Bhaabha. Arɨɨbhɨ nɨtakuja, Ʉmʉsakirya wurya atakʉtʉra kuuza kwa niimwɨ. Nawe inyɨ niriijɨ, nɨramʉtʉma kwa niimwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hanʉ akuuza, arabha arabheerecha abhaatʉ bha kʉʉsɨ kʉnʉ amangʼana igʉrʉ wʉ ʉbhʉbhɨ, eheene nɨ ɨtɨnɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Arabha arabheerecha ebho kʉbha nɨ‑bhakʉri bhʉ ʉbhʉbhɨ, kʉ kʉbha bhatakunyiisirirya. ");
INSERT INTO ikz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Areerecha kʉbha inyɨ ne‑we eheene kʉ kʉbha nɨraja kwa Bhaabha na mʉtakondora kwikɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Arabha arabheerecha habhwɨrʉ kʉbha Mungu arabhatɨnɨra, kʉ kʉbha amutiniirɨ Shɨtaani ʉmʉkangati wɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nɨkɨɨrɨ nɨnago maaru gʉ ʉkʉbhabhʉʉrɨra, nawe ribhaga rɨnʉ mʉtakʉtʉra kogoobhoora. ");
INSERT INTO ikz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ekoro ya amaheene yiyo, hanʉ ikuuza kwa niimwɨ, ɨrabhakangata komenya amaheene gʉʉsi. Ɨtakʉgamba kʉbhʉnaja bhwazɨ umwene, nawe ɨragamba ganʉ igwirɨ na kʉbhabhʉʉrɨra ganʉ gareerorekanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ekoro yiyo ɨrabha ɨrangʉnga, kʉ kʉbha ɨrabhabhʉʉrɨra gʉʉsi ganʉ ibhwɨnɨ kurwa kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ebhegero bhyʉsi bhɨnʉ Bhaabha anabhyʉ ibhyanɨ. Necho nɨgambirɨ kʉbha Ekoro yiyo ɨrabhabhʉʉrɨra gʉʉsi ganʉ ɨkʉbha ibhwɨnɨ kurwa kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Rɨkɨɨrɨ ibhaga isuuhu mʉtakondora, akʉmara ibhaga isuuhu naatu mʉrandora.” ");
INSERT INTO ikz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Mmbe, abhɨɨga bhaazɨ obhorebhe bhakiibhuurya, “Ana nzobhoorokɨ hanʉ akubhuga, ‘Rɨkɨɨrɨ ibhaga isuuhu mʉtakondora, akʉmara ibhaga isuuhu naatu mʉrandora,’ na ‘Nɨraja kwa Bhaabha’?” ");
INSERT INTO ikz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mmbe, bhakangʼeha kwibhuurya, “Enzobhooro yaku nɨkɨ, ‘Rɨkɨɨrɨ ibhaga isuuhu?’ Tʉtakwobhoora ganʉ akʉgamba.” ");
INSERT INTO ikz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yɨɨsu akamenya kʉbha bhareenda kumubhuurya ganʉ agambirɨ, mmbe akabhabhuurya, “Nangʉ, muriibhuurya ganʉ nɨgambirɨ, ‘Rɨkɨɨrɨ ibhaga isuuhu na niimwɨ mʉtakondora, akʉmara ibhaga isuuhu naatu mʉrandora’? ");
INSERT INTO ikz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nɨrabhabhʉʉrɨra amaheene, imwɨ mʉrarɨra na kurumɨka, nawe abhaatʉ bhɨ ɨɨsɨ yɨnʉ bharazomerwa. Mʉrarumɨka, nawe ɨbhɨgʉngi bhyanyu bhiriichʉra kʉbha obhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Arɨɨbhɨ ʉmʉkari araja kwibhʉra umwana, ararumɨka kʉ kʉbha ribhaga ryɨ ɨnyaakʉ yaazɨ rihikirɨ. Nawe hanʉ akʉmara kwibhʉra, atakuhiita naatu ɨnyaakʉ yiyo kʉ kʉbha yo obhozomerwa bhu ukwibhurwa umwana. ");
INSERT INTO ikz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mmbe imwʉsi mʉrarumɨka ribhaga rɨnʉ. Nawe nɨraaza naatu kwa niimwɨ, na niimwɨ mʉrabha no obhozomerwa mozekoro zaanyu. Atareeho wʉnʉ akuruusha obhozomerwa bhuyo mozekoro zaanyu. ");
INSERT INTO ikz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hanʉ ribhaga riyo rikuhika, mʉtakumbuurya ingʼana ryʉryʉsi. “Nɨrabhabhʉʉrɨra amaheene, gʉʉsi ganʉ mʉkʉsabha kuriina ryanɨ, Bhaabha arabhaha. ");
INSERT INTO ikz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kuhika nangwɨnʉ, mʉkɨɨrɨ kʉsabha chʉchʉsi kʉhɨtɨra iriina ryanɨ. Mʉsabhɨ, na niimwɨ mʉrabhona, korereke obhozomerwa bhwanyu bhuhikɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nɨbhabhuuriirɨ gʉʉsi gayo kʉnzɨra ye ebherenjo. Nawe ribhaga rɨrahika nɨtakʉgamba na niimwɨ kʉnzɨra ye ebherenjo, nawe nɨrabhabhʉʉrɨra habhwɨrʉ igʉrʉ wa Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kwibhaga riyo, mʉrasabha kʉhɨtɨra iriina ryanɨ. Na nɨtakʉbhabhʉʉrɨra kʉbha inyɨ nɨrabhasabhɨra kwa Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ewe umwene abhasɨɨgirɨ imwɨ, kʉ kʉbha imwɨ mʉnsɨɨgirɨ inyɨ, na mwisiriiryɨ kʉbha nɨkarwa kwa Bhaabha. ");
INSERT INTO ikz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nɨkaaza kʉʉsɨ kʉnʉ kurwa kwa Bhaabha, nawe nangʉ nɨrarwa kʉʉsɨ kʉnʉ, nɨraja kwa Bhaabha.” ");
INSERT INTO ikz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Neho abhɨɨga bhaazɨ bhakamʉbhʉʉrɨra, “Nangʉ ʉtangirɨ kʉgamba na niitwɨ habhwɨrʉ ɨtarɨ kʉnzɨra ye ebherenjo. ");
INSERT INTO ikz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nangʉ twʉbhʉʉrirɨ kʉbha ʉmɨnyirɨ gʉʉsi, na ʉtakwenda mʉʉtʉ akubhuuryɨ ryʉryʉsi. Gayo nego gagiriryɨ kwisirirya kʉbha ʉkarwa kwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yɨɨsu akabhabhuurya, “Nangʉ mwisiriiryɨ? ");
INSERT INTO ikz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ribhaga rɨraariirɨ, naatu rihikirɨ, hanʉ bhʉʉsi mʉraanyaraganɨ na kuja ɨwaanyu na kuntiga inyimwene. Nawe nɨtakʉbha inyimwene, kʉ kʉbha Bhaabha arɨ hamwɨmwɨ na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nɨbhabhuuriirɨ gayo gʉʉsi korereke mʉbhɨ no omorembe mozekoro zaanyu, kʉ kʉbha mʉrɨ kwa niinyɨ. Kʉʉsɨ hanʉ mʉrabhona zɨnyaakʉ nzaru, nawe mʉtʉʉbhaha kʉ kʉbha inyɨ nihizirɨ ɨɨsɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo, akarangamɨra kwisaarʉ, akasabha, “Bhaabha, ribhaga rihikirɨ. Ʉgʉngyɨ Umwana waazʉ, korereke Umwana wʉʉsi akʉgʉngyɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ʉmʉhɨɨrɨ ʉbhʉnaja bhwʉ ʉkʉkangata abhaatʉ, korereke bhʉʉsi bhanʉ ʉmʉhɨɨrɨ abhahɨ ʉbhʉhʉru bhwa kemerano. ");
INSERT INTO ikz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ʉbhʉhʉru bhwa kemerano nebhwe bhʉnʉ, abhaatʉ bhakomenye awɨ, Mungu umwenebhu wa amaheene, na bhamenye Yɨɨsu Kiriisitʉ, wʉnʉ watumirɨ kwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inyɨ nikugungiryɨ kʉbhaatʉ bhʉʉsi kʉʉsɨ, kʉhɨtɨra momeremo gɨnʉ wangʼɨɨrɨ kokora. ");
INSERT INTO ikz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bhaabha, nɨrasabha ungungyɨ, ʉbhʉgʉngʉ bhʉnʉ naarɨ nabhwɨ hanʉ twarɨ hamwɨmwɨ, ribhaga ɨɨsɨ ɨkɨɨrɨ kubhumbwa. ");
INSERT INTO ikz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Bhaabha, nɨkʉrirɨ omenyekanɨ chɨmbu awɨ ʉrɨ kʉbhaatʉ bhanʉ wangʼɨɨrɨ kʉʉsɨ kʉnʉ. Bhaarɨ abhaazʉ, ʉkangʼa inyɨ. Na bhagwatirɨ ɨngʼana yaazʉ. ");
INSERT INTO ikz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nangʉ bhʉʉbhʉʉrirɨ kʉbha, ebhegero bhyʉsi bhɨnʉ wangʼɨɨrɨ, bhiruurɨ kwa naawɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nɨbhabhuuriirɨ ganʉ wambuuriirɨ, bhʉʉsi bhagasʉngʼaanirɨ. Bhɨɨzɨ amaheene kʉbha nɨkarwa kwa naawɨ, na bhiisiriiryɨ kʉbha, naawɨ wantumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nɨrabhasabhɨra bhayo abheene. Nɨtakʉsabhɨra abhaatʉ bhʉʉsi, nawe nɨrabhasabhɨra bhanʉ wangʼɨɨrɨ, kʉ kʉbha nebho abhaazʉ. ");
INSERT INTO ikz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abhaatʉ abhaanɨ bhʉʉsi na abhaazʉ, na abhaazʉ nɨ‑bhaanɨ. Ʉbhʉgʉngʉ bhwanɨ bhuhumbwirwɨ kʉbhaatʉ kʉhɨtɨra kwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Inyɨ nɨraaza kwa naawɨ, nɨtakʉbha naatu mʉʉsɨ mʉnʉ. Nawe ebho bharabha mʉʉsɨ mʉnʉ. Bhaabha Ʉmʉrɨndu, nɨrakʉsabha ʉbhariibhɨ kʉhɨtɨra ʉbhʉnaja bhwi iriina ryazʉ rɨnʉ ʉngʼɨɨrɨ, korereke bhabhɨ kegero kɨmwɨ chɨmbu inyɨ na naawɨ tʉrɨ kegero kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hanʉ naarɨ hamwɨmwɨ nabhʉ nɨkabhariibha kʉbhʉnaja bhwi iriina ryazʉ rɨnʉ wangʼɨɨrɨ. Nɨbhaangariirɨ bhwaheene na atareeho nʉʉrʉ wʉmwɨ wʉnʉ aarimiirɨ, kuruushaku wʉnʉ akwenderwa kurichwa, korereke gabhɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu. ");
INSERT INTO ikz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Mmbe, nangʉ nɨraaza kwa naawɨ. Nɨragamba gʉʉsi gayo kwa abhɨɨga bhaanɨ nɨkɨɨrɨ nɨrɨ kʉʉsɨ, korereke obhozomerwa bhwanɨ bhuhikɨ mozekoro zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nɨbhabhuuriirɨ Ɨngʼana yaazʉ. Nawe abhaatʉ bha kʉʉsɨ bharabhabhiihirirwa, kʉ kʉbha ebho bhatarɨ bha kʉʉsɨ, chɨmbu inyɨ nɨtarɨ wa kʉʉsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inyɨ nɨtakʉsabha ʉbharuushɨ mʉʉsɨ mʉnʉ, nawe ʉbhasabhʉrɨ kurwa kwa Shɨtaani. ");
INSERT INTO ikz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bhatarɨ bhɨ ɨɨsɨ chɨmbu inyɨ nɨtarɨ wɨ ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ʉbhakore kʉbha abhaatʉ bhaazʉ kɨmwɨkɨmwɨ koheene yaazʉ, kʉ kʉbha ringʼana ryazʉ neryo eheene. ");
INSERT INTO ikz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chɨmbu wantumirɨ inyɨ kʉʉsɨ, ɨbhuɨbhu na niinyɨ nɨbhatumirɨ ebho kʉʉsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Niihuruchiryɨ kokohokerya awɨ igʉrʉ waabhʉ, korereke bhʉʉsi bhabhɨ kwa naawɨ heeneheene. ");
INSERT INTO ikz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nɨtakʉbhasabhɨra abheenebhu, nawe nɨrabhasabhɨra na bhʉʉsi bhanʉ bhakuuza kunyiisirirya, igʉrʉ wa ganʉ abhɨɨga bhaanɨ bhakwija. ");
INSERT INTO ikz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nɨrasabha bhayo bhabhɨ kegero kɨmwɨ. Bhaabha, nɨrasabha bhabhɨ kwa niitwɨ, chɨmburya awɨ ʉrɨ kwa niinyɨ, na niinyɨ nɨrɨ kwa naawɨ. Bhʉʉsi bhabhɨ kwa niitwɨ, korereke abhaatʉ bhɨ ɨɨsɨ bhiisiriryɨ kʉbha naawɨ wantumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ʉbhʉgʉngʉ bhʉnʉ wangʼɨɨrɨ, nɨbhahɨɨrɨ abhɨɨga bhaanɨ, korereke bhabhɨ kegero kɨmwɨ, chɨmbu inyɨ na naawɨ tʉrɨ kegero kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inyɨ nɨrɨ kwebho, na naawɨ ʉrɨ kwa niinyɨ, korereke bhanagɨ mukigwatani chabhʉ. Abhaatʉ bha kʉʉsɨ bhamenye kʉbha naawɨ wantumirɨ, na bhamenye kʉbha ʉbhasɨɨgirɨ chɨmbu ʉnsɨɨgirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Bhaabha, nereenda bhanʉ ʉngʼɨɨrɨ bhabhɨ hamwɨmwɨ na niinyɨ hʉhʉʉsi hanʉ nɨkʉbha, korereke bhabhorore ʉbhʉgʉngʉ bhwanɨ bhʉnʉ wangʼɨɨrɨ, kʉ kʉbha ʉkansɨɨga ʉkɨɨrɨ kʉbhʉmba ɨɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bhaabha we eheene, abhaatʉ bhɨ ɨɨsɨ yɨnʉ bhatakwɨzɨ. Nawe inyɨ nikwɨzɨ, na abhɨɨga bhaanɨ bhɨɨzɨ kʉbha naawɨ wantumirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inyɨ nibhiijiryɨ chɨmbu awɨ ʉrɨ, na nɨrakaja kokorabhu, korereke ʉbhʉsɨɨgi bhʉnʉ ʉnabhwɨ kwa niinyɨ, bhʉbhɨ kwabhʉ, na niinyɨ nɨbhɨ kwabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hanʉ Yɨɨsu aamarirɨ kʉsabha, akabhʉʉka na abhɨɨga bhaazɨ, akaambʉka ɨtandaari ya Kɨdurʉni. Hayo gwareho ʉmʉgʉndʉ gwɨ ɨmɨzɨyituuni. Ewe na abhiija bhaazɨ bhakasikɨramu. ");
INSERT INTO ikz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuuda wʉnʉ iichurirɨ Yɨɨsu, akamenya ʉmʉgʉndʉ guyo, kʉ kʉbha Yɨɨsu aarɨ anarirɨ kujamu na abhɨɨga bhaazɨ manga kaaru. ");
INSERT INTO ikz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mmbe, Yuuda akagega riribhita rya abhasirikarɨ, hamwɨmwɨ na abhahocha abhandɨ kurwa kʉbhakʉrʉ bha abhakuhaani na Abhafarisaayo. Bhakaja mʉmʉgʉndʉ gurya, bhanɨ ɨkɨmʉrɨ ne ebheseme. ");
INSERT INTO ikz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yɨɨsu akamenya gʉʉsi ganʉ gaarɨ gakuja komobhona, kʉgayo akiimɨɨrɨra, akabhabhuurya, “Mʉramohya wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bhakamʉgarukirya, “Tʉramohya Yɨɨsu Ʉmʉnazarɨɨti.” Yɨɨsu akabhagarukirya, “Niinyɨ.” Yuuda wʉnʉ aamwichurirɨ Yɨɨsu aarɨ imiiriirɨ hamwɨmwɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Mmbe, hanʉ abhabhuuriirɨ, “Niinyɨ,” bhakagarʉka inyuma na kugwa haasɨ. ");
INSERT INTO ikz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yɨɨsu akabhabhuurya naatu, “Mʉramohya wɨɨwɨ?” Ebho bhakamʉgarukirya, “Tʉramohya Yɨɨsu Ʉmʉnazarɨɨti.” ");
INSERT INTO ikz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yɨɨsu akabhabhʉʉrɨra, “Nɨbhabhuuriirɨ niinyɨ. Arɨɨbhɨ mʉramonhya inyɨ, mmbe mʉbhatigɨ abhandɨ bhanʉ bhajɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kʉhɨtɨra ɨnzɨra yiyo gakabha ganʉ aagambirɨ kʉbha, “Bhanʉ wangʼɨɨrɨ, nɨtarimiiryɨ nʉʉrʉ wʉmwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simʉʉni Peetero akasohora risabha rɨnʉ aarɨ naryʉ, akatɨna ʉkʉtwɨ ku ubhuryʉ kwa mbʉʉsa wa kuhaani ʉmʉkʉrʉ kutu. Mbʉʉsa wuyo aarɨ arabhirikirwa Maaroko. ");
INSERT INTO ikz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nawe Yɨɨsu akabhʉʉrɨra Peetero, “Garucha risabha muchobho chazʉ. Nangʉ, ʉtɨɨzɨ nereenderwa kʉnyaakibhwa chɨmbu Bhaabha ɨɨndirɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mmbe, ʉmʉkʉrʉ wa abhasirikarɨ, hamwɨmwɨ na riribhita ryazɨ, na abhahocha bha abhakangati bha Abhayaahudi, bhakagwata Yɨɨsu, bhakamobhoha. ");
INSERT INTO ikz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bhakamuhira hinga kwa Anaasi, umukwɨrɨma wa Kayaafa wʉnʉ aarɨ kuhaani ʉmʉkʉrʉ ribhaga riyo. ");
INSERT INTO ikz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kwa zisikʉ zi inyuma, Kayaafa newe aabhatʉngɨɨrɨ abhakangati bha Abhayaahudi kʉbha, nɨ‑hakɨrɨku ʉmʉʉtʉ wʉmwɨ akwɨ igʉrʉ wa abhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simʉʉni Peetero nu umwɨga ʉwʉndɨ bhaarɨ bhararwa Yɨɨsu inyuma. Umwɨga wuyo, kuhaani ʉmʉkʉrʉ aarɨ amwɨzɨ, kʉgayo akasikɨra na Yɨɨsu mwigoobhe ryi inyumba ya kuhaani ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nawe Peetero akiimɨɨrɨra kukisikʉ igʉtʉ. Neho umwɨga wʉnʉ aarɨ amɨnyɨkɨɨnɨ na kuhaani ʉmʉkʉrʉ, akahʉrʉka igʉtʉ. Akagambana nu umuucha wʉnʉ aarɨ akuriibha kukisikʉ, akiisirirya Peetero kusikɨra mwigoobhe. ");
INSERT INTO ikz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mmbe, omohocha wʉmwɨ wɨ ɨkɨkari, akabhuurya Peetero, “Awɨɨ, na naawɨ awʉʉsi ʉtarɨ wʉmwɨ wa abhɨɨga bhʉ ʉmʉʉtʉ wʉnʉ?” Peetero akamʉgarukirya, “Zɨyi, nɨtarɨ inyɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Abhahocha na abhariibhi bhaarɨ bhiimiiriirɨ hanʉ ryarɨ rinota ryo omorero, kʉ kʉbha embeho yaareho, bhakabha bharoota. Peetero wʉʉsi aarɨ imiiriirɨ hamwɨmwɨ nabhʉ, aroota omorero. ");
INSERT INTO ikz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mmbe kuhaani ʉmʉkʉrʉ, akabhuurya Yɨɨsu amangʼana ga abhɨɨga bhaazɨ na amiija gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yɨɨsu akamʉgarukirya, “Ribhaga ryʉsi naarɨ nɨragamba habhwɨrʉ mʉbhʉtangɨ bhwa abhaatʉ. Sikʉ zʉʉsi naarɨ niriija mʉmarwazɨrʉ na mwihekaaru mʉnʉ Abhayaahudi bhahiibhiringa bhʉʉsi. Nɨtagambirɨ ingʼana ryʉryʉsi kwa mbisi. ");
INSERT INTO ikz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nangʉ kwakɨ ʉrambuurya inyɨ? Bhabhuuryɨ bhanʉ bhiigwirɨ ganʉ nabhabhuuriirɨ. Ebho bhagɨɨzɨ ganʉ nagambirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hanʉ Yɨɨsu aagambirɨ gayo, umusirikarɨ wʉmwɨ wʉnʉ aarɨ imiiriirɨ haguhɨ nawe akamotema rigʉʉhu, akamubhuurya, “Ɨbhu nɨmbu ʉkʉgarukirya kuhaani ʉmʉkʉrʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yɨɨsu akamʉgarukirya, “Arɨɨbhɨ nɨgambirɨ kɨbhɨ, gamba ʉbhʉbhɨ bhwanɨ. Nawe arɨɨbhɨ nɨgambirɨ amaheene, kwakɨ ʉrantema?” ");
INSERT INTO ikz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mmbe, Anaasi akaswaja Yɨɨsu ahirwɨ kwa Kayaafa, kuhaani ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mmbe, hanʉ Simʉʉni Peetero aarɨ akɨɨrɨ aroota omorero, abhaatʉ obhorebhe bhakamubhuurya, “Awɨɨ, na naawɨ ʉtarɨ wʉmwɨ wa abhɨɨga bhaazɨ?” Peetero akaanga, “Zɨyi, nɨtarɨ inyɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nawe wʉmwɨ wa bhambʉʉsa bha kuhaani ʉmʉkʉrʉ, umuhiiri wʉ ʉmʉʉtʉ wurya Peetero aangʼɨrirɨ ʉkʉtwɨ, akamubhuurya, “Nangʉ, inyɨ nɨtakʉrʉʉzɨ hanʉ waarɨ hamwɨmwɨ nawe mʉmʉgʉndʉ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peetero akaanga kwikɨ, “Nɨtarɨ inyɨ.” Hayohayo, ekorokoome ɨkagamba. ");
INSERT INTO ikz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mmbe, hanʉ bhwakɨɨrɨ, abhakangati bha Abhayaahudi bhakagega Yɨɨsu kurwa kwa Kayaafa kuhika mwikʉrʉ ryu umwanangwa bhwi Ikiruumi. Nawe ebho bhataasikiirɨ mwikʉrʉ muyo, korereke bhatabhenga na kʉtama kurya ibhyakurya bhyi isigukuru yɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mmbe Piraato ʉmʉkangati wa Abharuumi, akahʉrʉka igʉtʉ na kubhajaku, akabhabhuurya, “Ʉmʉʉtʉ wʉnʉ akʉrirɨ bhʉbhɨkɨ bhʉnʉ mʉkʉmʉgamba?” ");
INSERT INTO ikz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bhakamʉgarukirya, “Ʉmʉʉtʉ wʉnʉ angabhɨɨrɨ ataana isoro, tʉtaarɨ tʉramoreeta kwa naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Piraato akabhabhʉʉrɨra, “Mmbe momogege imubheene, mʉmʉtɨnɨrɨ kʉrɨngʼaana ni imigirʉ janyu.” Nawe Abhayaahudi bhakamʉgarukirya, “Tʉtaana ʉbhʉnaja bhwʉ ʉkʉtɨnɨra ʉmʉʉtʉ akwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gayo gakakorebhwabhu, korereke amangʼana ganʉ Yɨɨsu aagambirɨ gabhɨ, kwerecha chɨmbu ariikwɨ. ");
INSERT INTO ikz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mmbe, Piraato akasikɨra naatu mwikʉrʉ ryu umwanangwa, akabhɨrɨkɨra Yɨɨsu, akamubhuurya, “Awɨ naawɨ ʉmʉtɨmi wa Abhayaahudi?” ");
INSERT INTO ikz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yɨɨsu akamʉgarukirya, “Awɨɨ ganʉ ukubhuurya gararwa kwa naawɨ kisha abhaatʉ bhakubhuuriirɨ amangʼana gaanɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piraato akagarukirya, “Nangʉ, inyɨ nɨ‑Mʉyaahudi? Abhaatʉ bhɨ ɨkɨgambʉ chazʉ hamwɨmwɨ na abhakʉrʉ bha abhakuhaani nebho bhakʉrɨɨtirɨ kwa niinyɨ. Ʉkʉrirɨbhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yɨɨsu akamʉgarukirya, “Ʉbhʉtɨmi bhwanɨ bhʉtarɨ bhwɨ ɨɨsɨ yɨnʉ. Bhwangabhɨɨrɨ bhwa kʉʉsɨ kʉnʉ, mmbe abhɨɨga bhaanɨ bhaarɨ bharanyiitanɨra korereke nɨtagwatwa na Abhayaahudi. Nawe ʉbhʉtɨmi bhwanɨ bhʉtarɨ bhwa kʉnʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mmbe, Piraato akamubhuurya, “Nangʉ, awɨ nɨ‑mʉtɨmi?” Yɨɨsu akamʉgarukirya, “Awɨ ʉgambirɨ, inyɨ nɨ‑mʉtɨmi. Inyɨ nikiibhurwa kʉʉsɨ kʉnʉ igʉrʉ wa ganʉ, ni igʉrʉ wa ganʉ nɨkaaza korereke nemenyeekererye abhaatʉ amaheene. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akutuna amaheene, ariigwa amangʼana gaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piraato akamubhuurya, “Amaheene nɨkɨ?” Hanʉ aamarirɨ kʉgamba gayo, akahʉrʉka igʉtʉ, akabhʉʉrɨra Abhayaahudi, “Inyɨ nɨtakorora ʉbhʉsarya bhwa kʉmʉgamba. ");
INSERT INTO ikz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nawe muni isimʉka ya niinyɨ kʉbhatazʉrɨra omobhohwa wʉmwɨ ribhaga ryi isigukuru yɨ Ɨpasaka. Nangʉ moreenda nɨbhatazʉrɨrɨ ʉmʉtɨmi wa Abhayaahudi?” ");
INSERT INTO ikz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nawe bhakarɨgɨsa bharabhuga, “Zɨyi! Atarɨ wuyo. Tʉtazʉrɨrɨ Bharaabha.” Bharaabha aarɨ abhʉhirwɨ mokebhoho kʉ kʉbha yu ukwanga ɨsɨrɨkaarɨ ya Abharuumi. ");
INSERT INTO ikz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mmbe, Piraato akahaanikija Yɨɨsu kʉbhasirikarɨ, bhamoteme ɨmɨzariti. ");
INSERT INTO ikz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abhasirikarɨ bhakagisa ɨkɨrʉngʉ cha amahwa, bhakamwibhohya kumutwɨ. Na bhakamwibhohya engebho ya zambaraawɨ. ");
INSERT INTO ikz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakabha bharamujaku, bharamokeerya kwa kusiihya, “Morembe, ʉmʉtɨmi wa Abhayaahudi!” Bhakamotema amagʉʉhu. ");
INSERT INTO ikz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Piraato akahʉrʉka igʉtʉ, akabhʉʉrɨra riribhita rya abhaatʉ bharya, “Mwitegeerere, ʉmʉʉtʉ wʉnʉ nɨramoreeta igʉtʉ kwa niimwɨ, korereke momenye kʉbha nɨkɨɨrɨ korora ʉbhʉsarya bhwʉbhwʉsi kwawɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mmbe, bhakahurucha Yɨɨsu igʉtʉ ibhʉhirɨ ɨkɨrʉngʉ cha amahwa ne engebho ya zambaraawɨ. Piraato akabhabhʉʉrɨra, “Morore, ʉmʉʉtʉ umwene ngʉnʉ hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hanʉ abhakʉrʉ bha abhakuhaani na abhariibhi bha rihekaaru bhaamʉrʉʉzɨ, bhakarɨgɨsa bharabhuga, “Mʉmʉbhambɨ kʉmʉsarabha, mʉmʉbhambɨ kʉmʉsarabha!” Piraato akabhabhʉʉrɨra, “Momogege imwɨ abheene mʉmʉbhambɨ kʉmʉsarabha, kʉ kʉbha nɨkɨɨrɨ korora ʉbhʉsarya bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abhayaahudi bhakamʉgarukirya, “Itwɨ tʉnajʉ imigirʉ. Kʉrɨngʼaana ni imigirʉ giyo, areenderwa kwitwa, kʉ kʉbha ariibhɨrɨkɨra Mwana wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hanʉ Piraato iigwirɨ amangʼana gayo, akangʼeha kwʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akasikɨra naatu munyumba, akabhuurya Yɨɨsu, “Awɨ uruurɨ hayi?” Nawe Yɨɨsu atamʉgarukiiryɨ ryʉryʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Piraato akamubhuurya, “Kwakɨ ʉtakʉngarukirya? Ʉtɨɨzɨ kʉbha nɨnʉ ʉbhʉnaja bhwu ukukutigʉrʉkɨra, na bhwʉ ʉkʉkʉbhamba kʉmʉsarabha?” ");
INSERT INTO ikz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yɨɨsu akamʉgarukirya, “Ʉtaarɨ ʉrabha nʉ ʉbhʉnaja bhwʉbhwʉsi igʉrʉ waanɨ wangatamirwɨ kʉhaabhwa na Mungu. Kʉgayo ʉmʉʉtʉ wʉnʉ antɨɨrɨ mʉmabhoko gaazʉ anʉ ʉbhʉbhɨ bhʉkʉrʉ kʉkɨra ʉbhʉbhɨ bhwazʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kwɨma hayo, Piraato akagema komohya ɨnzɨra yʉ ʉkʉmʉtazʉra, nawe Abhayaahudi bhakangʼeha kʉrɨgɨsa bharabhuga, “Ʉrɨmʉtazʉrɨ, awɨ ʉtarɨ mʉsaani wa Kaisaari. Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akwikorya kʉbha ʉmʉtɨmi, ahaanga Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hanʉ Piraato igwirɨ amangʼana gayo, akahurucha Yɨɨsu igʉtʉ, akaja kwikara kukitumbɨ chɨ ɨtɨnɨrʉ, ahagero hanʉ hakubhirikirwa Isimiti ya Amabhwɨ. Kʉkɨgambʉ chɨ Ɨkɨɨbhuraaniya bharabhuga Gabhasa. ");
INSERT INTO ikz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaarɨ ɨsa isaasabha urusikʉ rwo okokonza igʉrʉ wi isigukuru yɨ Ɨpasaka. Piraato akabhʉʉrɨra Abhayaahudi, “Rora, ʉmʉtɨmi waanyu nɨ‑wʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ebho bhakarɨgɨsa bharabhuga, “Mumwitɨ, mumwitɨ! Mʉmʉbhambɨ kʉmʉsarabha!” Piraato akabhabhuurya, “Nangʉ moreenda nɨmʉbhambɨ kʉmʉsarabha ʉmʉtɨmi waanyu?” Abhakʉrʉ bha abhakuhaani bhakamʉgarukirya, “Itwɨ tʉtaana mʉtɨmi wʉndɨ kuruushaku Kaisaari!” ");
INSERT INTO ikz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Neho Piraato akaswaja abhasirikarɨ bhagege Yɨɨsu, korereke bhamʉbhambɨ kʉmʉsarabha. Mmbe, abhasirikarɨ bhakagega Yɨɨsu na kuja nawe. ");
INSERT INTO ikz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yɨɨsu akagega ʉmʉsarabha gwazɨ, akabhʉʉka kuja ahagero hanʉ haabhirikiirwɨ Ɨkɨhanga chu Umutwɨ, kʉKɨɨbhuraaniya nɨ‑Gʉrigʉʉta. ");
INSERT INTO ikz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hanʉ bhaahikirɨ harya, bhakamʉbhamba kʉmʉsarabha. Hayohayo bhakabhamba na abhandɨ bhabhɨrɨ kʉmɨsarabha, ʉwʉmwɨ ʉrʉbhaara rwu ubhuryʉ nʉ ʉwʉndɨ ʉrʉbhaara rwʉ ʉbhʉmʉsi na Yɨɨsu akabha gatɨgatɨ waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Piraato akaswaja kʉbha, gaandɨkwɨ amangʼana na kʉmaamɨka amaandɨkʉ kʉmʉsarabha gwa Yɨɨsu, ganʉ gakubhuga, “Yɨɨsu Ʉmʉnazarɨɨti, Ʉmʉtɨmi wa Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amaandɨkʉ gayo gaandikirwɨ kʉkɨgambʉ chɨ Ɨkɨɨbhuraaniya, Ikiruumi ni Ikigiriki. Abhayaahudi bhaaru bhakagasoma, kʉ kʉbha ahagero hanʉ bhaamʉbhambirɨ haarɨ haguhɨ na Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mmbe, abhakʉrʉ bha abhakuhaani bhakabhʉʉrɨra Piraato, “Ʉtaandɨka, ‘Ʉmʉtɨmi wa Abhayaahudi,’ nawe waandɨkɨ, ‘Ewe akabhuga, Inyɨ nɨ‑Mʉtɨmi wa Abhayaahudi.’ ” ");
INSERT INTO ikz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piraato akabhagarukirya, “Inyɨ nɨmarirɨ kwandɨka.” ");
INSERT INTO ikz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hanʉ abhasirikarɨ bhaamarirɨ kʉbhamba Yɨɨsu kʉmʉsarabha, bhakagega zengebho zaazɨ, bhakataanʼya bhɨtɨnɨka bhene. Abhasirikarɨ bhʉʉsi bhakagega ɨbhɨtɨnɨka bhyabhʉ. Bhakagega nɨ ɨkanzʉ yaazɨ. Ɨkanzʉ yaarɨ ɨbhʉhirwɨ yʉʉsi kwɨma igʉrʉ, yaarɨ igwatɨɨnɨ yɨmwɨbhu, ɨtaarɨ na mutumʉ gwʉgwʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bhakiibhʉʉrɨra, “Tʉtatarandʉra ɨkanzʉ yɨnʉ, nawe twitoore, torore, ɨrabha ya wɨɨwɨ.” Gayo gakakorebhwa korereke gabhɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, “Bhakasonda zengebho zaanɨ, na kwitoora igʉrʉ wɨ ɨkanzʉ yaanɨ.” Nego ganʉ bhaakʉrirɨ abhasirikarɨ. ");
INSERT INTO ikz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Haguhɨ nʉ ʉmʉsarabha gwa Yɨɨsu bhaarɨ bhiimiiriirɨ unina Yɨɨsu, umwabhʉ unina Yɨɨsu wɨ ɨkɨkari, Mariyamu ʉmʉkari wa Kireopa, na Mariyamu wa Magidarena. ");
INSERT INTO ikz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Hanʉ Yɨɨsu aarʉʉzɨ unina nu umwɨga wʉnʉ aarɨ asɨɨgirɨ bhʉkʉngʼu imiiriirɨ haguhɨ na unina, akabhuga, “Yiiya, morore wuyo newe umwana waazʉ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na akabhʉʉrɨra umwɨga wurya, “Morore wuyo newe yiiya waazʉ.” Mmbe, kwɨma ribhaga riryarirya umwɨga wurya akagega unina Yɨɨsu, akaja kwikara nawe ɨwaazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Akʉmara Yɨɨsu akamenya kʉbha amarirɨ kohocha emeremo jazɨ. Neho akagamba, “Niriigwa enyoota.” Gayo gakakorwa korereke gabhɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu. ");
INSERT INTO ikz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ahagero harya kwarɨ ne ekegero cha amarwa amarʉrʉ. Mmbe, bhakagega ripuupya, bhakakorya mʉmarwa amarʉrʉ gi idivaayi, bhakatʉʉra kwikʉrɨ, bhakahirɨra Yɨɨsu kumunywa. ");
INSERT INTO ikz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hanʉ Yɨɨsu abhʉnjiryɨ amarwa gayo, akabhuga, “Emeremo janɨ gisirirɨ!” Akahiinya umutwɨ, akatinʼya. ");
INSERT INTO ikz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yaarɨ urusikʉ rʉnʉ rʉkʉkangatɨra urusikʉ rwʉ ʉbhʉtʉʉrʉ, naatu ʉbhʉtʉʉrʉ bhuyo bhwarɨ rusikʉ rʉkʉrʉ. Igʉrʉ wa riyo abhakangati bha Abhayaahudi bhatɨɨndirɨ ɨkɨtʉndʉ kɨsaagɨ igʉrʉ wʉ ʉmʉsarabha kurusikʉ rwʉ ʉbhʉtʉʉrʉ. Mmbe bhakaja kwa Piraato, bhakamʉsabha kʉbha abhasirikarɨ bhajɨ bhabhunɨ amagʉrʉ abhaatʉ bhanʉ bhabhambirwɨ kʉmʉsarabha, na ukuruushaho ɨkɨtʉndʉ chabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mmbe, abhasirikarɨ bhakaja, bhakamubhuna amagʉrʉ we embere na wa kabhɨrɨ bhanʉ bhaabhambirwɨ hamwɨmwɨ na Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nawe hanʉ bhaahikirɨ kwa Yɨɨsu, bhakabhona akuurɨ, bhataamubhunirɨ amagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nawe umusirikarɨ wʉmwɨ akasoma Yɨɨsu na ritimʉ kʉrʉbharu. Amasaahɨ na amanzi bhɨkarwa. ");
INSERT INTO ikz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Amangʼana ganʉ gandikirwɨ nʉ ʉmʉʉtʉ wʉnʉ aarɨ aragarora ganʉ gaarɨ garakorwa. Ganʉ akubhuga nɨ‑ga amaheene, wʉʉsi amɨnyirɨ kʉbha ganʉ akubhuga nɨ‑ga amaheene, korereke na niimwɨ mwisiriryɨ. ");
INSERT INTO ikz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gayo gakʉriibhwɨ korereke gabhɨ ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu, “Rɨtareeho riguha ryazɨ rɨnʉ rikubhunɨka.” ");
INSERT INTO ikz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na Amaandɨkʉ Amarɨndu garabhuga, “Bharaaza komorora wʉnʉ bhaasʉmirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hanʉ gayo gaasirirɨ, akaaza ʉmʉʉtʉ wʉmwɨ iriina ryazɨ Yuusufu, wʉnʉ aruurɨ Arimataaya. Ʉmʉʉtʉ wuyo aarɨ umwɨga wa Yɨɨsu, nawe kwa mbisi, kʉ kʉbha aarɨ arabhʉʉbhaha abhakangati bha Abhayaahudi. Mmbe, ʉmʉʉtʉ wuyo akaja kwa Piraato, akamʉsabha agege ɨkɨtʉndʉ cha Yɨɨsu, akɨbhɨɨkɨ. Piraato akamwisiririrya. Yuusufu akaja, akaruushaho ɨkɨtʉndʉ cha Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nawe Nikʉdɨɨmu wʉnʉ ribhaga rɨmwɨ agiirɨ kwa Yɨɨsu ubhutikʉ, akaaza na amaguta gu uruhuzu ʉrʉzʉmu gasangiryɨ manɨmanɨ, gaarɨ kirʉ merongo ɨtatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mmbe, bhabhɨrɨ bhayo bhakagega ɨkɨtʉndʉ cha Yɨɨsu, bhakakiringɨra mʉsanda, bhakahaka amaguta gayo kʉrɨngʼaana ni isimʉka ya Abhayaahudi yʉ ʉkʉbhɨɨka abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ahagero hanʉ bhaabhambirɨ Yɨɨsu gwareho ʉmʉgʉndʉ. Mʉmʉgʉndʉ guyo yaarɨmu imbihɨra iihya yɨnʉ bhaarɨ bhakɨɨrɨ kʉbhɨɨka ʉmʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Urusikʉ ruyo, rwarɨ urusikʉ rwa Abhayaahudi kwikonza kwʉ ʉbhʉtʉʉrʉ. Igʉrʉ wa riyo bhakabhɨɨka Yɨɨsu mumbihɨra yiyo, kʉ kʉbha yaarɨ haguhɨ. ");
INSERT INTO ikz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma, ritabhʉʉri ziri, Mariyamu wa Magidarena akaja kumbihɨra ya Yɨɨsu. Akabhona riibhwɨ rirya rihiringitiibhwɨ kurwa kukisikʉ chi imbihɨra. ");
INSERT INTO ikz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mmbe, akaryara kʉhʉrʉka harya, akaja kwa Simʉʉni Peetero na kumwɨga ʉwʉndɨ wʉnʉ Yɨɨsu aasɨɨgirɨ. Akabhabhʉʉrɨra, “Abhaatʉ bharuushiryɨ ɨkɨtʉndʉ chʉ Ʉmʉkʉrʉ wɨɨtʉ mumbihɨra, na tʉtɨɨzɨ hanʉ bhakɨtɨɨrɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peetero nu umwɨga ʉwʉndɨ wurya bhakeerekera kumbihɨra. ");
INSERT INTO ikz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhʉʉsi bhabhɨrɨ bhaarɨ bhararyara, nawe umwɨga wurya akaryara kʉkɨra Peetero na kʉkangata kuhika kumbihɨra. ");
INSERT INTO ikz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akiihiinya na kwisʉnza mumbihɨra, akarora ɨsanda, nawe ataasikiirɨ mumbiihɨra. ");
INSERT INTO ikz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mmbe, Simʉʉni Peetero akamutuna, akahika harya, akasikɨra mumbihɨra na korora ɨsanda. ");
INSERT INTO ikz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Naatu akabhona nɨ ɨkɨtambaara kɨnʉ bhaabhʉhɨɨrɨ Yɨɨsu kumutwɨ, kɨtarɨ hamwɨmwɨ nɨ ɨsanda, nawe kɨkaringwa na kutuurwa rusizʉ. ");
INSERT INTO ikz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mmbe, umwɨga ʉwʉndɨ wʉnʉ akangatirɨ kuhika harya, wʉʉsi akasikɨra mumbihɨra. Akarora, akiisirirya ganʉ arʉʉzɨ, ");
INSERT INTO ikz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","nangabha bhaarɨ bhakɨɨrɨ kwobhoora Amaandɨkʉ Amarɨndu ganʉ gakubhuga, Yɨɨsu areenderwa aryʉkɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mmbe, abhɨɨga bharya bhakaja ɨwaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nawe Mariyamu wa Magidarena akasaaga imiiriirɨ igʉtʉ wi imbihɨra, ɨnʉ ararɨra. Hanʉ aarɨ ararɨra, akiihiinya na kwisʉnza mumbihɨra, ");
INSERT INTO ikz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akabharora bhamaraika bhabhɨrɨ bhanʉ bhiibhʉhirɨ zengebho zɨnzɨrʉ. Bhakiikara hanʉ bhaarɨ bhahindiiryɨ ɨkɨtʉndʉ cha Yɨɨsu. Maraika wʉmwɨ akiikara kumutwɨ, ʉwʉndɨ akiikara kʉmagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhamaraika bharya bhakamubhuurya, “Yiiya, kwakɨ ʉrarɨra?” Akabhagarukirya, “Abhaatʉ bharuushiryeho ɨkɨtʉndʉ chʉ Ʉmʉkʉrʉ waanɨ, na nɨtɨɨzɨ hanʉ bhakɨtɨɨrɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hanʉ Mariyamu amarirɨ kʉgamba amangʼana gayo, akiichʉra, akarora Yɨɨsu imiiriirɨ haryaharya, nawe Mariyamu ataamʉmɨnyirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yɨɨsu akamubhuurya, “Yiiya, kwakɨ ʉrarɨra? Nangʉ, ʉramohya wɨɨwɨ?” Mariyamu akiiseega kʉbha ʉmʉʉtʉ wurya aarɨ omohocha wʉ ʉmʉgʉndʉ, akamʉgarukirya, “Bhaabha, arɨɨbhɨ naawɨ uruushiryɨ ɨkɨtʉndʉ chazɨ, mbʉʉrɨra hanʉ ʉkɨtɨɨrɨ, na niinyɨ nɨraja kokegega.” ");
INSERT INTO ikz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yɨɨsu akamʉbhɨrɨkɨra, “Mariyamu!” Mariyamu akiichʉra, akarora Yɨɨsu, akagamba kʉKɨɨbhuraaniya, “Rabhʉni!” Rabhʉni, enzobhooro yaku ni‑Mwija. ");
INSERT INTO ikz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yɨɨsu akamʉbhʉʉrɨra, “Ʉtangwata, kʉ kʉbha nɨkɨɨrɨ kuja mwisaarʉ kwa Bhaabha. Mmbe, nuujɨ ʉbhabhʉʉrɨrɨ abhahiiri bhaanɨ, nɨraja mwisaarʉ kwa Bhaabha, ewe ni‑Wuusʉ, na ni‑Mungu waanɨ, wʉʉsi ni‑Mungu waanyu.” ");
INSERT INTO ikz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mmbe Mariyamu wa Magidarena akaja kwa abhɨɨga bha Yɨɨsu, akabhabhʉʉrɨra amangʼana gayo, arabhuga, “Nɨmʉrʉʉzɨ Ʉmʉkʉrʉ!” Na amubhuuriirɨ amangʼana gayo gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hanʉ ryahikirɨ rigoroobha urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma, abhɨɨga bha Yɨɨsu bhaarɨ bhiibhiringirɨ munyumba na kwigara ibhisikʉ, kʉ kʉbha bhaarɨ bharʉʉbhaha abhakangati bha Abhayaahudi. Yɨɨsu akabhahwarʉkɨra na kwimɨɨrɨra gatɨ waabhʉ, akabhabhʉʉrɨra, “Omorembe gʉbhɨ na niimwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Akʉmara akabheerecha amabhoko gaazɨ nʉ ʉrʉbharu rwazɨ. Hanʉ abhɨɨga bhaarʉʉzɨ Ʉmʉkʉrʉ, bhakazomerwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yɨɨsu akabhʉʉrɨra naatu, “Omorembe gʉbhɨ na niimwɨ. Chɨmbu Bhaabha antumirɨ inyɨ, ɨbhuɨbhu na niinyɨ nɨrabhatʉma imwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hanʉ aamarirɨ kʉgambabhu, akabhahumbutɨra umwika, akabhabhʉʉrɨra, “Mʉsʉngʼaanɨ Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mʉraabhabheerere abhaatʉ ʉbhʉbhɨ bhwabhʉ, Mungu wʉʉsi arabhabheerera. Arɨɨbhɨ mʉtakʉbhabheerera, Mungu wʉʉsi atakʉbhabheerera.” ");
INSERT INTO ikz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Umwɨga wʉmwɨ mʉbhɨɨga bha Yɨɨsu, iriina ryazɨ Tomaaso, wʉnʉ bhaamubhirikiirɨ Mbasa, ataarɨ hamwɨmwɨ na abhɨɨga abhandɨ hanʉ Yɨɨsu aabhahwarukiirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mmbe, abhɨɨga abhandɨ bharya bhakamʉbhʉʉrɨra, “Itwɨ tʉrʉʉzɨ Ʉmʉkʉrʉ.” Nawe ewe akabhagarukirya, “Inyɨ nɨtakʉtʉra kwisirirya gayo, arɨɨbhɨ nɨkɨɨrɨ korora ɨbhɨrasʉ bhyi imisumaari na kumukunʼyaku ni ibhyara bhyanɨ kʉmabhoko gaazɨ na kʉrʉbharu rwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hanʉ yaahitirɨ nyuma yɨmwɨ, abhɨɨga bha Yɨɨsu bhakiibhiringa hamwɨmwɨ naatu munyumba. Urusikʉ ruyo Tomaaso aareho hamwɨmwɨ nabhʉ. Bhakiigara ibhisikʉ, kɨtʉkɨrʉ Yɨɨsu akarorekana habhwɨrʉ, akiimɨɨrɨra gatɨgatɨ waabhʉ, akabhuga, “Omorembe gʉbhɨ na niimwɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mmbe, Yɨɨsu akabhʉʉrɨra Tomaaso, “Tomaaso, nauzɨ unkunʼyɨku ni ichara orore amabhoko gaanɨ. Naatu, unkunʼyɨku no okobhoko kwazʉ kʉrʉbharu rwanɨ. Ʉtangʼeha kʉtama kwisirirya, nawe wiisiriryɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaaso akagarukirya, “Ʉmʉkʉrʉ waanɨ na Mungu waanɨ!” ");
INSERT INTO ikz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yɨɨsu akagarukirya, “Wiisiriiryɨ kʉ kʉbha ʉndʉʉzɨ. Hakɨrɨku bhanʉ bhanyiisiriiryɨ nʉʉrʉ bhakɨɨrɨ kondora.” ");
INSERT INTO ikz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yɨɨsu akakora ibhyɨrɨkɨnʼyʉ ɨbhɨndɨ bhyaru bhɨnʉ abhɨɨga bhaazɨ bhaarʉʉzɨ, bhɨnʉ bhɨkɨɨrɨ kwandɨkwa mʉkɨtabhʉ kɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nawe ibhyɨrɨkɨnʼyʉ bhɨnʉ bhirimu mʉkɨtabhʉ kɨnʉ bhyandikirwɨ korereke mwisiriryɨ Yɨɨsu newe Kiriisitʉ, Umwana wa Mungu, na korereke ku kumwisirirya, mobhone ʉbhʉhʉru bhwa kemerano kuriina ryazɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hanʉ gayo gaahitirɨ, Yɨɨsu akahwarʉkɨra naatu abhɨɨga bhaazɨ rusizʉ wɨ ɨnyanza ya Tibhɨɨriya. ");
INSERT INTO ikz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Bhaareho Simʉʉni Peetero, Tomaaso wʉnʉ iriina ryazɨ ɨrɨndɨ nɨ‑Mbasa, Natanaɨri wa Kana ya Gariraaya, abhaana bhabhɨrɨ bha Zebhedaayo na abhɨɨga abhandɨ bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simʉʉni Peetero akabhʉʉrɨra abhakɨndichazɨ, “Nɨraja mʉnyanza kuwesena ziiswɨ.” Ebho bhakamʉgarukirya, “Na niitwɨ tʉraja hamwɨmwɨ na naawɨ.” Mmbe bhakaja, bhakatiira mubhwatʉ, bhakawesena ubhutikʉ nyangima, nawe bhatabhwɨnɨ ziiswɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ritabhʉʉri, Yɨɨsu akiimɨɨrɨra rusizʉ wɨ ɨnyanza, nawe abhɨɨga bhaazɨ bhataamɨnyirɨ kʉbha nɨ‑Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yɨɨsu akabhabhɨrɨkɨra, “Bhasaani bhaanɨ, nangʉ, mubhwɨnɨ ziiswɨ zʉzʉʉsi?” Ebho bhakamʉgarukirya “Zɨyi.” ");
INSERT INTO ikz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yɨɨsu akabhabhʉʉrɨra, “Mʉtaashɨ enzero ʉrʉbhaara rwu ubhuryʉ rwu ubhwatʉ, mʉrabhona ziiswɨ.” Mmbe, bhakataasha enzero mʉnyanza, nawe bhakatamwa kuyiruta kʉ kʉbha bhakabhona ziiswɨ nzaru bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Umwɨga wʉnʉ Yɨɨsu aasɨɨgirɨ bhʉkʉngʼu, akabhʉʉrɨra Peetero, “Nɨ‑Mʉkʉrʉ!” Hanʉ Simʉʉni Peetero igwirɨ kʉbha nɨ‑Mʉkʉrʉ, akiibhoha engebho yaazɨ yɨnʉ aaruushiryɨ hanʉ aatangirɨ kuwesena, akiirekera mʉnyanza. ");
INSERT INTO ikz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abhɨɨga abhandɨ bhakaja rusizʉ wɨ ɨnyanza nu ubhwatʉ, kʉ kʉbha bhataarɨ kore, nawe bhaarɨ matambʉka igana rɨmwɨbhu. Bhakaruta enzero yɨnʉ yiizwirɨ ziiswɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hanʉ bhaahikirɨ rusizʉ wɨ ɨnyanza, bhakarora ʉmʉkaatɨ na rinota ryo omorero rɨnʉ ziiswɨ zaarɨ zɨrakarwaku. ");
INSERT INTO ikz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Muuzɨ, moreete hanʉ ziiswɨ obhorebhe zɨnʉ mʉwɨsɨnirɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mmbe Simʉʉni Peetero akasikɨra mubhwatʉ, akaruta enzero yɨnʉ yiizwirɨ ziiswɨ. Monzero yiyo zaarɨmu ziiswɨ zɨkʉrʉ igana rɨmwɨ merongo ɨtaanʉ ni isatʉ. Nangabha zaarɨmu ziiswɨ nzaru bhʉkʉngʼu, enzero ɨtaatarandukirɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yɨɨsu akabhʉʉrɨra abhɨɨga bhaazɨ, “Muuzɨ muryɨ ibhyakurya.” Ataareho umwɨga wʉnʉ aagɨmirɨ kubhuurya, “Awɨ nɨ‑wɨɨwɨ?” kʉ kʉbha bhakamenya kʉbha nɨ‑Mʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mmbe Yɨɨsu akaaza, akagega ʉmʉkaatɨ, akabhaha abhɨɨga bhaazɨ. Na akagega na ziiswɨ, akakora ɨbhuɨbhu. ");
INSERT INTO ikz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ruyo rwarɨ rogendo rwa katatʉ Yɨɨsu kʉhwarʉkɨra abhɨɨga bhaazɨ, kwɨma hanʉ Mungu aamuryurirɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hanʉ bhaamarirɨ kurya, Yɨɨsu akabhuurya Simʉʉni Peetero, “Simʉʉni umwana wa Yoohana, ʉnsɨɨgirɨ kʉkɨra chɨmbu abhakɨndichazʉ bhansɨɨgirɨ?” Peetero akamʉgarukirya, “Heene, Ʉmʉkʉrʉ, ʉmɨnyirɨ kʉbha nɨkʉsɨɨgirɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Riisha ɨbhɨngʼʉndu bhyanɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yɨɨsu akabhuurya Peetero rwa kabhɨrɨ, “Simʉʉni, umwana wa Yoohana, ʉnsɨɨgirɨ?” Peetero akamʉgarukirya, “Heene, Ʉmʉkʉrʉ, ʉmɨnyirɨ kʉbha nɨkʉsɨɨgirɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Riisha zɨngʼʉndu zaanɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamubhuurya rwa katatʉ, “Simʉʉni, umwana wa Yoohana, ʉnsɨɨgirɨ?” Mmbe, Peetero akarumɨka kʉ kʉbha akamubhuurya rwa katatʉ, “Ʉnsɨɨgirɨ?” Akamʉgarukirya, “Ʉmʉkʉrʉ, ʉmɨnyirɨ gʉʉsi. Ʉmɨnyirɨ kʉbha nɨkʉsɨɨgirɨ.” Yɨɨsu akamʉbhʉʉrɨra, “Riisha zɨngʼʉndu zaanɨ. ");
INSERT INTO ikz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nɨrakʉbhʉʉrɨra amaheene, hanʉ waarɨ mumura, ʉkanara kwibhoha zengebho zaazʉ aumwene, na kuja hʉhʉʉsi hanʉ ukwenda. Nawe hanʉ ukukunguha, ʉragorora amabhoko gaazʉ nʉ ʉmʉʉtʉ ʉwʉndɨ arakwibhohya zengebho zaazʉ na kukuhira ɨnʉ ʉtakwenda kuja.” ");
INSERT INTO ikz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yɨɨsu akagambabhu kwerecha chɨmbu Peetero ariikwɨ, korereke Mungu agungibhwɨ. Mmbe, Yɨɨsu akabhʉʉrɨra Peetero, “Ntuna.” ");
INSERT INTO ikz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mmbe, Peetero akiichʉra, akarora umwɨga wʉnʉ Yɨɨsu aasɨɨgirɨ bhʉkʉngʼu, aarɨ arabhatuna. Umwɨga wuyo ni‑wurya aarɨ ihɨgɨkirɨ kwa Yɨɨsu hanʉ bhaarɨ bhararya, na kumubhuurya, “Ʉmʉkʉrʉ, nɨ‑wɨɨwɨ akukwichʉra?” ");
INSERT INTO ikz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mmbe, hanʉ Peetero aarʉʉzɨ umwɨga wurya, akabhuurya Yɨɨsu, “Ʉmʉkʉrʉ, nangʉ, kɨgʉrʉkɨ kɨraaza komobhona wuyo?” ");
INSERT INTO ikz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yɨɨsu akamʉgarukirya, “Arɨɨbhɨ nereenda abhɨ mʉhʉru kuhika hanʉ nɨkʉgarʉka, kwakɨ gayo garakʉnyaacha? Awɨ untunɨ.” ");
INSERT INTO ikz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mmbe amangʼana gayo gakanyaragana kʉbhakɨndichazɨ bhaaru kʉbha umwɨga wuyo atakukwa. Nawe Yɨɨsu ataabhugirɨ umwɨga wuyo atakukwa, akabhuga, “Arɨɨbhɨ nereenda abhɨ mʉhʉru kuhika hanʉ nɨkʉgarʉka, kwakɨ gayo garakʉnyaacha?” ");
INSERT INTO ikz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Umwɨga wuyo newe wʉnʉ akomenyeekererya ganʉ na kʉgandɨka. Itwɨ tʉmɨnyirɨ kʉbha ganʉ akʉgamba nɨ‑ga amaheene. ");
INSERT INTO ikz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gareho amangʼana agandɨ maaru ganʉ Yɨɨsu aakʉrirɨ. Angabhɨɨrɨ gʉʉsi gayo gangandikirwɨ, nɨrarora kʉʉsɨ hʉʉsi hataarɨ hariisa ʉkʉtʉʉra ɨbhɨtabhʉ bhɨnʉ bhyangandikirwɨ.");
INSERT INTO ikz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Umugungwa Tɨʉfirʉ, nɨkakwandɨkɨra mʉkɨtabhʉ chanɨ chʉ ʉbhʉtangɨ, igʉrʉ wa amangʼana gʉʉsi ganʉ Yɨɨsu aatangirɨ kokora nu ukwija, kwɨma kʉbhʉtangɨ bhwe emeremo jazɨ, ");
INSERT INTO ikz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kuhika urusikʉ rurya aagɨgirwɨ kuja mwisaarʉ. Hanʉ aarɨ akɨɨrɨ kogegwa, akabharagɨrɨra kʉnzɨra ye Ekoro Ɨndɨndu, abhatumwa bhaazɨ bhanʉ aarʉbhwɨrɨ, igʉrʉ we emeremo gɨnʉ bhakuuza kohocha. ");
INSERT INTO ikz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Hanʉ aamarirɨ kukwa na kuryʉka kwazɨ, Yɨɨsu aarɨ arabhakandikija abhatumwa bhaazɨ, manga kaaru na kwa nzɨra nzaru kʉbha, maheene nɨ‑mʉhʉru. Kwibhaga rya sikʉ merongo ene, aarɨ ariiyeerecha na kwija ɨngʼana igʉrʉ wʉ ʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Rusikʉ rʉmwɨ, hanʉ Yɨɨsu aahunɨɨnɨ na abhatumwa bhayo, akabhaswaja, “Mʉtarwa Yɨrusarɨɨmu hanʉ, nawe mʉrɨndɨ ʉbhʉragɨ, kuhika hanʉ mʉraasʉngʼaanɨ ʉbhʉragɨ bhwa Bhaabha, chɨmbu mwigwirɨ amangʼana gaazɨ kurwa kwa niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoohana Ʉmʉbhatiizi, akabhatiiza abhaatʉ kwa amanzi, nawe imwɨ sikʉ suuhu zɨnʉ zikuuza, mʉrabhatiizwa kwe Ekoro Ɨndɨndu.” ");
INSERT INTO ikz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hanʉ abhatumwa bhayo bhaahunɨɨnɨ na Yɨɨsu, bhakamubhuurya, “Ʉmʉkʉrʉ, ribhaga rɨnʉ neryo ʉkʉgarukirya Abhiiziraɨri ʉbhʉtɨmi?” ");
INSERT INTO ikz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Akabhabhʉʉrɨra, “Gɨtarɨ meremo janyu komenya ribhaga nu urusikʉ rʉnʉ Bhaabha umwene aabhɨtɨɨrɨho kʉbhʉnaja bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nawe mʉrabhona zinguru, hanʉ Ekoro Ɨndɨndu ɨraazɨ kwa niimwɨ. Mʉrabha abhamɨnyɨɨkɨrɨri bhaanɨ Yɨrusarɨɨmu na mbaara zʉʉsi za mucharʉ cha Yudeya, Samaariya nu ukuhika mʉtɨnɨrʉ yɨ ɨɨsɨ yʉʉsi.” ");
INSERT INTO ikz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hanʉ Yɨɨsu aamarirɨ kʉgamba gayo kʉbhatumwa bhaazɨ, bhaarɨ bhakɨɨrɨ bhachirora akagegwa kuja mwisaarʉ, risaarʉ rɨkamukundikirya, bhatamʉrʉʉzɨ kwikɨ. ");
INSERT INTO ikz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hanʉ bhaarɨ bhacharangamiirɨ kwisaarʉ, abhaatʉ bhabhɨrɨ bhanʉ bhaarɨ bhiibhʉhirɨ zengebho zɨnzɨrʉ za pee, bhakiimɨɨrɨra haguhɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bhakabhuga, “Imwɨ abhaatʉ bha Gariraaya, kwakɨ mwimiiriirɨ hanʉ ɨnʉ mʉrangamiirɨ kwisaarʉ? Yɨɨsu wʉnʉ agɨgirwɨ kurwa kwa niimwɨ kuja mwisaarʉ, aragarʉka naatu, chɨmbu mwamʉrʉʉzɨ araja mwisaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Akʉmara abhatumwa bhakarwa kʉkɨgʉrʉ kɨnʉ kikubhirikirwa Ɨmɨzɨyituuni, bhakagarʉka kʉrʉbhɨri rwa Yɨrusarɨɨmu. Yaarɨ rogendo rwu ukwisa urusikʉ rwʉ ʉbhʉtʉʉrʉ rwa matambʉka kɨkwɨ kɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hanʉ bhaahikirɨ Yɨrusarɨɨmu, bhakatiira muchumba che egorofa, mʉnʉ bhaarɨ bhakwikara. Bhaareho Peetero, Yoohana, Yaakobho, Andureya, Firipʉ, Tomaaso, Bhatoromayo, Mataayo, Yaakobho umwana wa Arifaayʉ, Simʉʉni wʉnʉ aarɨ Ʉmʉzɨrʉʉti, na Yuuda umwana wa Yaakobho. ");
INSERT INTO ikz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhanʉ bhʉʉsi bhakiibhiringa hamwɨmwɨ na kʉsabha Mungu kwa mwʉyʉ gʉmwɨ. Hamwɨmwɨ na bhayo, bhaareho abhakari abhandɨ na Mariyamu unina Yɨɨsu na bhaumwabhʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ribhaga riyo, abhiisirirya bha Yɨɨsu bhakiibhiringa, endengo yaabhʉ yaarɨ igana rɨmwɨ na merongo ɨbhɨrɨ. Neho Peetero akiimɨɨrɨra gatɨ waabhʉ, ");
INSERT INTO ikz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akabhabhʉʉrɨra, “Abhahiiri bhaanɨ, amangʼana ganʉ gaandikirwɨ mʉMaandɨkʉ Amarɨndu igʉrʉ wa Yuuda, yaarɨ ereenderwa gakorwe. Gayo gakagambwa ne Ekoro Ɨndɨndu kʉhɨtɨra mumunywa gwʉ ʉmʉtɨmi Daudi igʉrʉ wa Yuuda, wʉnʉ aabhakangatirɨ bhanʉ bhaagwatirɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kwikɨ aarɨ umutumwa ʉmʉkɨndichɨtʉ, akahaabhwa emeremo gɨnʉ hamwɨmwɨ na niitwɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kʉrɨngʼaana na amangʼana gaazɨ amabhɨ, Yuuda akabhona zimpirya akagʉra ʉmʉgʉndʉ. Mʉmʉgʉndʉ iyo, akagwa haasɨ kibhumɨɨrɨ, ɨnda yaazɨ ikabhaarʉka na bhya mʉnda bhyʉsi bhɨkazenzeera igʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ringʼana ryu uruku rwazɨ rɨkakumuka kubhiikari bhʉʉsi bha Yɨrusarɨɨmu, kʉgayo bhakagʉbhɨrɨkɨra ʉmʉgʉndʉ guyo Akɨɨridaama, kʉkɨgambʉ chabhʉ nɨ‑Mʉgʉndʉ gwa Amasaahɨ. ");
INSERT INTO ikz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peetero akangʼeha kʉgamba, “Yandikirwɨ mʉkɨtabhʉ cha Zabhuri, ‘Yɨɨka waazɨ habhɨ ni ikiibhuurʉ, atabhaho ʉmʉʉtʉ wʉnʉ akʉsaaga hayo.’ Naatu, yandikirwɨ, ‘Ʉmʉʉtʉ ʉwʉndɨ ahaabhwɨ emeremo jazɨ jʉ ʉkʉkangata.’ ");
INSERT INTO ikz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Mmbe, torobhore mʉbhanʉ bhaahirɨɨnɨ na niitwɨ ibhaga ryʉsi rɨnʉ Ʉmʉkʉrʉ Yɨɨsu aarɨ akusikɨra nʉ ʉkʉhʉrʉka kwa niitwɨ, ");
INSERT INTO ikz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kwɨma ribhaga rɨnʉ Yɨɨsu aabhatiizirwɨ na Yoohana, kuhika urusikʉ rʉnʉ agɨgirwɨ kuja mwisaarʉ. Wʉnʉ araazɨ korobhorwa, ɨramwenda agwatanɨ na niitwɨ abhɨ mʉmɨnyɨɨkɨrɨri wu ukuryʉka kwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bhakahitya amariina ga abhaatʉ bhabhɨrɨ. Ʉwʉmwɨ aarɨ Yuusufu wʉnʉ aabhirikiirwɨ Bharisaabha, iriina ryazɨ ɨrɨndɨ ryarɨ Yuusitʉ. Na wa kabhɨrɨ, akabhirikirwa Matiya. ");
INSERT INTO ikz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bhaaza kʉmara bhakasabha Mungu bhakabhuga, “Ʉmʉkʉrʉ, naawɨ ʉmɨnyirɨ mozekoro za abhaatʉ bhʉʉsi. Tʉrakʉsabha utwereche nɨ‑wahɨ gatɨ wa bhabhɨrɨ bhanʉ, wʉnʉ ʉrʉbhwɨrɨ, ");
INSERT INTO ikz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","agege umweya gwe emeremo ju ubhutumwa gɨnʉ Yuuda aatigirɨ, na kuja ʉrʉbhaara rwazɨ umwene.” ");
INSERT INTO ikz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bhakakora ubhwitʉʉri, ubhwitʉʉri bhʉkagwɨra Matiya, wʉʉsi akabharwa kʉbha hamwɨmwɨ na abhatumwa ikumi na wʉmwɨ bharya. ");
INSERT INTO ikz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hanʉ rwahikirɨ urusikʉ rwa Pɨntɨkʉsitɨ, abhaatʉ bhʉʉsi bhanʉ bhiisiriiryɨ Yɨɨsu bhaarɨ bhiibhiringirɨ hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kɨtʉkɨrʉ, rɨkahʉrʉka riraka ncha ryʉ ʉmʉkama ʉmʉhaari kurwa mwisaarʉ, rikiizurya inyumba yʉʉsi yɨnʉ bhaarɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bhakarora ebhegero bhɨnʉ bhyarɨ ncha zɨndɨmɨ zo omorero, bhɨkanyaragana na kwikara igʉrʉ wa bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abhaatʉ bhayo bhʉʉsi bhakiizuribhwa Ekoro Ɨndɨndu, bhakatanga kʉgamba kʉbhɨgambʉ ɨbhɨndɨ, chɨmbu Ekoro Ɨndɨndu yabhanagiryɨ kʉgamba. ");
INSERT INTO ikz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yɨrusarɨɨmu hayo, bhaareho Abhayaahudi bhanʉ bhaarɨ bharasengera Mungu, kurwa mʉzɨɨsɨ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hanʉ bhiigwirɨ riraka riyo, riribhita ikʉrʉ rya abhaatʉ rikiibhiringa. Bhʉʉsi bhakabha bharuguurirɨ bhʉkʉngʼu, kʉ kʉbha bhakiigwa bharagamba ɨbhɨgambʉ bhyabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hanʉ bhaarɨ bhacharuguurirɨ na kʉtangaara, bhakiibhʉʉrɨra, “Heene, bhanʉ bhʉʉsi bhakʉgamba, bhatarɨ abhiikari bha Gariraaya? ");
INSERT INTO ikz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nangʉ! Ɨbhɨɨrɨbhwɨ itubhʉʉsi turiigwa bharagamba ɨbhɨgambʉ bhyɨtʉ bhya yɨɨka? ");
INSERT INTO ikz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Gatɨgatɨ wɨɨtʉ, bhareho abhaatʉ kurwa ɨɨsɨ ya Abhaparisi, Abhamɨɨdi na ya Abhɨɨramu. Bhaareho abhandɨ kurwa ɨɨsɨ ya Mesopotaamiya, Yudeya, Kapadʉʉkiya, Ponto, na Asiya, ");
INSERT INTO ikz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Furigiya, Pamufiiriya na Miisiri. Bhaareho abhandɨ kurwa mbaara za mucharʉ cha Riibhiya haguhɨ nʉ ʉrʉbhɨri rwa Kireene na abhagini bhanʉ bhakarwa kʉrʉbhɨri rwa Ruumi, Abhayaahudi na abhandɨ bhanʉ bhiisiriiryɨ ɨnyangi yɨ Ɨkɨyaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bhareho abhandɨ bhanʉ nɨ‑Bhakireete na abhandɨ Abhaarabhu. Itubhʉʉsi turiigwa bharakumya Mungu kʉmangʼana gaazɨ amakʉrʉ, kwɨ ɨbhɨgambʉ bhyɨtʉ itubheene!” ");
INSERT INTO ikz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abhaatʉ bhʉʉsi bhakarʉgʉʉra na bhakiitiimaata, bhakabha bhariibhuurya kʉbha, “Rɨnʉ rɨna nzobhoorokɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nawe abhaatʉ abhandɨ bhakabha bharabhakaara, bharabhuga, “Bhagwatirwɨ idivaayi!” ");
INSERT INTO ikz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Neho Peetero akiimɨɨrɨra hamwɨmwɨ na abhatumwa abhakɨndichazɨ bharya ikumi na wʉmwɨ, akabhabhʉʉrɨra abhaatʉ bhayo kwiraka ikʉrʉ kʉbha, “Imwɨ Abhayaahudi abhakɨndichanɨ na Abhayaahudi bhanʉ mukwikara Yɨrusarɨɨmu hanʉ, munyiitegeerere bhwaheene, nɨbhabhʉʉrɨrɨ amangʼana ganʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abhaatʉ bhanʉ bhatanywɨrɨ chɨmbu mukwiseega, kʉ kʉbha nangwɨnʉ nɨ‑zɨɨsa isatʉ za ritabhʉʉri. ");
INSERT INTO ikz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nawe ringʼana rɨnʉ nɨ‑rɨnʉ ʉmʉrʉʉtɨrɨri Yʉwɨɨri aagambirɨ, ");
INSERT INTO ikz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mungu arabhuga, kuzisikʉ za mʉtɨnɨrʉ, nɨrabhiitɨrɨra abhaatʉ bhʉʉsi Ekoro yaanɨ. Abhaana bhaanyu bhi ikisubhɨ na bhɨ ɨkɨkari bhararootorera, abhamura bhaanyu bhararora ʉbhʉrʉri na abhakaruka bhaanyu bhararoota ebherooto. ");
INSERT INTO ikz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kuzisikʉ ziyo niriicha Ekoro yaanɨ, nʉʉrʉ igʉrʉ wa bhambʉʉsa bhaanɨ abhasubhɨ na abhakari, bhʉʉsi bhararootorera. ");
INSERT INTO ikz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɨrakora amateemo kwisaarʉ, ni ibhyɨrɨkɨnʼyʉ kʉʉsɨ. Kʉrabha na amasaahɨ, omorero, ni iryʉki riritʉ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Iryʉbha ririichʉra kʉbha ikiirimya, nu umwɨri gʉrabha mubhiriiri ncha amasaahɨ, gayo gʉʉsi garakorwa, rʉkɨɨrɨ kuhika urusikʉ rurya ʉrʉkʉrʉ rwu ubhukumya bhwʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wʉwʉʉsi wʉnʉ akʉsabha kuriina ryʉ Ʉmʉkʉrʉ, arasabhurwa.’” ");
INSERT INTO ikz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peetero akangʼeha kʉgamba, “Imwɨ abhaatʉ bha Iziraɨri, mwitegeerere bhwaheene! Mungu umwene akeerecha ʉbhʉkʉrʉ bhwa Yɨɨsu wa Nazarɨɨti kʉbhaniimwɨ, kʉnzɨra yɨ ɨbhɨsɨgʉ, ɨbhɨrʉgʉʉrʉ ni ibhyɨrɨkɨnʼyʉ bhya teemwa nzaru, zɨnʉ Mungu aamʉhɨɨrɨ kokora gatɨ waanyu. Gayo imwʉsi mʉgɨɨzɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Akʉmara Yɨɨsu akatuurwa mʉmabhoko gaanyu, chɨmbu Mungu ɨɨndirɨ kʉrɨngʼaana no okomenya kwazɨ kwɨma ɨkarɨ. Imwɨ mʉkamʉhanikija mʉmabhoko ga abhaatʉ abhabhɨ, bhakamwita igʉrʉ wʉ ʉmʉsarabha. ");
INSERT INTO ikz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nawe Mungu akamuryʉra kurwa mʉbhaku, akamutuurya mʉbhʉrʉrʉ bhwu uruku, kʉ kʉbha ɨtatʉrɨkɨɨnɨ agwatwɨ na zinguru zu uruku. ");
INSERT INTO ikz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ʉmʉtɨmi Daudi akagamba igʉrʉ wa Yɨɨsu, ‘Nɨkarora Ʉmʉkʉrʉ mʉbhʉtangɨ bhwanɨ sikʉ zʉʉsi. Nɨtakusingisa, kʉ kʉbha arɨ ʉrʉbhaara rwo okobhoko kwanɨ ku ubhuryʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kʉgayo umwʉyʉ gwanɨ gʉkazomererwa, nʉ ʉrʉrɨmɨ rwanɨ rʉrariiryata. Nʉ ʉmʉbhɨrɨ gwanɨ, guriikara kubhwisɨgi, ");
INSERT INTO ikz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kʉ kʉbha ʉtakuntiga nyaari, na ʉtakwisirirya Ʉmʉrɨndu waazʉ asarɨkɨ. ");
INSERT INTO ikz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ʉnyɨɨrɨkiryɨ ɨnzɨra yʉ ʉbhʉhʉru, ʉranyiizurya obhozomerwa kʉ kʉbha ʉrɨ haguhɨ na niinyɨ.’” ");
INSERT INTO ikz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peetero akangʼeha kʉgamba, “Abhahiiri bhaanɨ mombeerere, nɨgambɨ kwa bhʉkararu mʉbhʉtangɨ bhwanyu kʉbha zaazi Daudi akakwa, akabhiikwa, ni imbihɨra yaazɨ ɨrɨ ɨwɨɨtʉ hanʉ na reero ɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nawe Daudi aarɨ ʉmʉrʉʉtɨrɨri, akamenya kʉbha, Mungu akaraganʼya kubhwirahiri kʉbha, aratʉʉra ʉmʉʉtʉ wu ubhwibhurwa bhwazɨ kukitumbɨ chazɨ chɨ ɨkɨtɨmi. ");
INSERT INTO ikz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi akarora amangʼana ganʉ gakuuza kokorwa, akagamba igʉrʉ wu ukuryʉka kwa Kiriisitʉ, kʉbha, ataatigirwɨ nyaari nʉ ʉmʉbhɨrɨ gwazɨ gʉtaasarikirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Mungu akaryʉra Yɨɨsu kurwa mʉbhaku, na niitwɨ bhʉʉsi nɨ‑bhamɨnyɨɨkɨrɨri bha ringʼana riyo. ");
INSERT INTO ikz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Akatiiribhwa igʉrʉ, kuhika ʉrʉbhaara rwu ubhuryʉ rwa Mungu, na kʉsʉngʼaana kwewe ʉbhʉragɨ bhwe Ekoro Ɨndɨndu, wʉʉsi atwitiriirɨ ekegero kɨnʉ mokorora na kwigwa. ");
INSERT INTO ikz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daudi umwene ataatiirirɨ mwisaarʉ, nawe akabhuga, ‘Ʉmʉkʉrʉ Mungu akabhʉʉrɨra Ʉmʉkʉrʉ waanɨ, “Ikara ʉrʉbhaara rwanɨ rwu ubhuryʉ, ");
INSERT INTO ikz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kuhika hanʉ nɨkʉtʉʉra abhabhisa bhaazʉ iyaasɨ wa amagʉrʉ gaazʉ.” ’  ” ");
INSERT INTO ikz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peetero akamariirya kʉgamba, “Ereenderwa Abhiiziraɨri bhʉʉsi momenye amaheene kʉbha, Yɨɨsu wuyo mwanyaakiryɨ mʉkamwita, newe Mungu akʉrirɨ kʉbha Ʉmʉkʉrʉ na Kiriisitʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hanʉ abhaatʉ bhayo bhiigwirɨ amangʼana gayo, gakabhasikɨra mumyʉyʉ jabhʉ. Bhakabhuurya Peetero na abhatumwa abhakɨndichazɨ kʉbha, “Bhahiiri bhɨɨtʉ, nangʉ tokorebhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peetero akabhagarukirya, “Bhʉʉsibhu mutigɨ ʉbhʉbhɨ bhwanyu na mʉbhatiizwɨ kuriina rya Yɨɨsu Kiriisitʉ, korereke mobheererwe ʉbhʉbhɨ bhwanyu na niimwɨ mʉrasʉngʼaana ʉmʉbhanʉ gwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ʉbhʉragɨ bhʉnʉ ni igʉrʉ waanyu na abhaana bhaanyu, kʉbhaatʉ bhʉʉsi bhanʉ bharɨ mubhyarʉ ɨbhɨndɨ, bhʉʉsi bhayo Ʉmʉkʉrʉ Mungu arabhabhɨrɨkɨra bhabhɨ abhaatʉ bhaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peetero akangʼeha kʉbhʉʉrɨra abhaatʉ bhayo amangʼana maaru na kʉbhahama, arabhuga, “Mwituuryɨ murwɨ murwibhʉrʉ rwʉ ʉbhʉbhɨ rʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abhaatʉ bhɨkwɨ bhɨtatʉ bhakiisirirya amangʼana ga Peetero, bhakabhatiizwa, bhakagwatana na abhahɨmba abhandɨ bha Yɨɨsu urusikʉ ruyo. ");
INSERT INTO ikz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abhahɨmba bha Yɨɨsu bhakakongʼera kwɨga amiija ga abhatumwa bha Yɨɨsu, bhakagwatana hamwɨmwɨ, kusunyura ʉmʉkaatɨ na kosengera Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abhatumwa bhayo bhaarɨ bharakora amateemo ni ibhyɨrɨkɨnʼyʉ bhyaru, kuhika abhaatʉ bhʉʉsi bhakasikirwa nʉ ʉrʉhaho nu ubhusuuku bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abhiisirirya bhʉʉsi bhaarɨ nu ubhumwɨmwɨ, bhakasangɨra na kwihaana ebhegero bhyabhʉ kʉbhʉsɨɨgi. ");
INSERT INTO ikz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bhaarɨ bharagurya emenyo ne ebhegero bhyabhʉ, zimpirya zɨnʉ bhaarɨ bhakobhona, bharazesondya kʉrɨngʼaana nu ubhwɨndi bhwʉ ʉmʉʉtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zisikʉ zʉʉsi, bhaarɨ bharahunana hamwɨmwɨ mwihekaaru. Bhaarɨ bhararya ibhyakurya zinyumba zʉʉsi kwa kozomerwa hamwɨmwɨ ne ekoro nzɨrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ɨnʉ bharakumya Mungu nʉ ʉkʉsɨɨgwa na abhaatʉ bhʉʉsi. Kɨrakabhu Ʉmʉkʉrʉ akangʼeha kutuurya abhandɨ, abhiisirirya bhakoongera kwaruha. ");
INSERT INTO ikz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Rusikʉ rʉmwɨ zɨɨsa kenda umwise, ribhaga ryo okosengera, Peetero na Yoohana bhaarɨ bharaja mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mwihekaaru hayo, chareho ikishoko kɨnʉ kikubhirikirwa Ikisikʉ Ɨkɨzʉmu. Rusizʉ wi ikishoko kiyo, aarɨ areho omorema wa kwɨma ubhwibhurwa bhwazɨ. Sikʉ zʉʉsi aarɨ aragegwa na abhaatʉ na kutuurwa haguhɨ ni ikishoko kiyo, korereke asabhɨ ikimweso kʉbhaatʉ bhanʉ bhaarɨ bharahɨta kusikɨra mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hanʉ ʉmʉʉtʉ wuyo aabharʉʉzɨ Peetero na Yoohana bharɨ haguhɨ kusikɨra mwihekaaru, akabhasabha bhamohe ikimweso. ");
INSERT INTO ikz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peetero na Yoohana bhakamorora bhʉkʉngʼu, akʉmara Peetero akamʉbhʉʉrɨra, “Torore iitwɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Akabharora, ɨnʉ aarɨ ararɨnda arɨɨbhɨ bhane ekegero cho okomoha. ");
INSERT INTO ikz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nawe Peetero akamʉbhʉʉrɨra, “Nɨtaana mpirya nʉʉrʉ ɨzahaabhu, nawe ekegero kɨnʉ nɨnachʉ necho nekokoha, kuriina rya Yɨɨsu Kiriisitʉ Ʉmʉnazarɨɨti, imɨɨrɨra ogende!” ");
INSERT INTO ikz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peetero akagwata ʉmʉʉtʉ wurya okobhoko ku ubhuryʉ, akamwimiirirya. Rogendo rʉmwɨ ɨbhɨtʉgʉrʉ bhɨkabhona zinguru. ");
INSERT INTO ikz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akabhururuka, akiimɨɨrɨra, akatanga kogenda umwene, akasikɨra mwihekaaru hamwɨmwɨ na Peetero na Yoohana, ɨnʉ arabhururukabhururuka na kukumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abhaatʉ bhʉʉsi bhakamorora aragenda ɨnʉ arakumya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhakamomenya kʉbha newe wurya ahiikara kuKisikʉ Ɨkɨzʉmu cha rihekaaru, kʉsabha ikimweso. Bhʉʉsi bhakarʉgʉʉra bhʉkʉngʼu, kʉmangʼana ganʉ gaamubhwɨnɨ. ");
INSERT INTO ikz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hanʉ aarɨ akuhirana na Peetero na Yoohana, abhaatʉ bhʉʉsi bhakabharyarɨra ɨnʉ bharuguurirɨ, kuhika ahagero hanʉ Peetero na Yoohana bhaarɨ. Ahagero hayo hakabhirikirwa Rigoobhe rya Sɨrɨmaani. ");
INSERT INTO ikz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hanʉ Peetero aarʉʉzɨ abhaatʉ bhiibhiringirɨ, akabhabhʉʉrɨra, “Imwɨ Abhiiziraɨri, kwakɨ amangʼana gayo garabhatangarya? Ndora mʉratomogorera, kina ʉmʉʉtʉ wʉnʉ ahʉriibhwɨ kʉbhʉnaja bhwɨtʉ itubheene, hamwɨ kʉbhʉrɨndu bhwɨtʉ tʉkʉrirɨ ʉmʉʉtʉ wʉnʉ agende? ");
INSERT INTO ikz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mungu wa Abhurahaamu, Iisaka na Yaakobho, newe Mungu wa bhasʉʉkʉrʉ, agungiryɨ Yɨɨsu omohocha waazɨ newe imwɨ mwamʉtɨɨrɨ mʉmabhoko ga abhakangati, na kumwanga mʉbhʉtangɨ bhwa Piraato, nangabha Piraato akeenda amutigʉrʉkɨrɨ! ");
INSERT INTO ikz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mʉkamwanga ʉmʉrɨndu na we eheene, mʉkasabha Piraato abhatazʉrɨrɨ umwiti. ");
INSERT INTO ikz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mʉkamwita Yɨɨsu wʉnʉ akoha abhaatʉ ʉbhʉhʉru, nawe Mungu akamuryʉra kurwa mʉbhaku! Na niitwɨ nɨ‑bhamɨnyɨɨkɨrɨri bhu ukuryʉka kwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ʉmʉʉtʉ wʉnʉ mokorora hanʉ mumwɨzɨ, umwene ahʉriibhwɨ kʉbhʉnaja bhwi iriina rya Yɨɨsu nu ubhwisirirya bhwi iriina riyo, bhɨmʉhɨɨrɨ zinguru na bhɨmʉhɨɨrɨ ʉbhʉhʉru bhʉnʉ mʉbhʉtangɨ bhwanyu. ");
INSERT INTO ikz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nangʉ abhahiiri bhɨɨtʉ, gʉʉsi ganʉ mwakʉrɨɨrɨ Yɨɨsu, imwɨ na abhakʉrʉ bhaanyu, nɨmɨnyirɨ kʉbha, mʉkagakora kʉ ʉkʉtama komenya. ");
INSERT INTO ikz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nawe gakakorebhwa, korereke Mungu amarɨ amangʼana ganʉ aaragɨɨnʼyɨ kʉhɨtɨra kʉbharʉʉtɨrɨri bhaazɨ bhʉʉsi kʉbha, Kiriisitʉ waazɨ araaza anyaakibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nangʉ mutigɨ ʉbhʉbhɨ bhwanyu mwichʉrɨrɨ Mungu korereke abhabheerere, rɨbhɨhʉ ribhaga ryo obhozomerwa kʉ kʉbhaho Ʉmʉkʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","korereke atʉmɨ Yɨɨsu kwa niimwɨ. Ewe newe Kiriisitʉ, Ʉmʉsabhuri wʉnʉ Mungu iitʉʉrirɨ kwɨma mʉbhʉtangɨ. ");
INSERT INTO ikz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ereenderwa Yɨɨsu asaagɨ mwisaarʉ, kuhika ribhaga rɨnʉ Mungu araakore ebhegero bhyʉsi bhuhya, chɨmbu Mungu aabhugirɨ kwɨma ɨkarɨ kʉhɨtɨra abharʉʉtɨrɨri bhaazɨ abharɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Musa akabhuga, ‘Mʉbhahiiri bhaanyu, Ʉmʉkʉrʉ Mungu waanyu ariimiirirya ʉmʉrʉʉtɨrɨri ncha niinyɨ. Mumwitegeerere kʉganʉ gʉʉsi araabhabhʉʉrɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ʉmʉʉtʉ wʉwʉʉsi wʉnʉ arɨɨtamɨ kwigwa ʉmʉrʉʉtɨrɨri wuyo, araahurwa kemerano kurwa mʉbharɨndu bha Mungu na kurichwa.’ ");
INSERT INTO ikz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Abharʉʉtɨrɨri bhʉʉsi, kwɨma kwa Samwɨri na abhandɨ bhanʉ bhaamutunirɨ, bhakaraganʼya amangʼana ga zisikʉ zɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Imwɨ mʉbhɨɨrɨ abhaana bha abharʉʉtɨrɨri, na bhʉ ʉbhʉragɨ bhʉnʉ Mungu aakʉrirɨ na bhawʉsʉʉkʉrʉ. Mungu akaraganʼya Abhurahaamu kʉbha, ‘Kurwibhʉrʉ rwazʉ, abhaatʉ bhɨ ɨbhɨgambʉ bhyʉsi bharahaabhwa ʉrʉbhangʉ.’ ");
INSERT INTO ikz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hanʉ Mungu aamarirɨ kuryʉra Yɨɨsu omohocha waazɨ, akamʉtʉma kwa niimwɨ, korereke abhahɨ ʉrʉbhangʉ na abhaatʉ bhʉʉsi bhataanɨ nʉ ʉbhʉbhɨ bhwabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hanʉ Peetero na Yoohana bhaarɨ bhakɨɨrɨ bharabharaganʼya abhaatʉ bharya ɨngʼana ya Mungu, abhakuhaani na abhariibhi bha rihekaaru na Abhasadukaayo bhanʉ bhaarɨ hayo, bhakahika. ");
INSERT INTO ikz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Abhakʉrʉ bhayo bhakiigatana bhʉkʉngʼu, kʉ kʉbha Peetero na Yoohana bhaarɨ bhariija abhaatʉ na kʉbharwazɨra kʉbha, kʉrɨngʼaana nu ukuryʉka kwa Yɨɨsu, abhaku bhararyʉka. ");
INSERT INTO ikz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bhakagwata Peetero na Yoohana, bhakatuurwa mokebhoho kuhika tabhʉʉri waho, kʉ kʉbha yaarɨ rigoroobha. ");
INSERT INTO ikz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nawe abhaaru bhanʉ bhiigwirɨ amangʼana ga Peetero na Yoohana bhakiisirirya, ne endengo ya abhasubhɨ abheene bhaarɨ bhariisemera ɨbhɨkwɨ bhɨtaanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tabhʉʉri waho, abhakangati, abhakaruka na abhiija bhi imigirʉ, nebho bhiibhiringirɨ Yɨrusarɨɨmu hayo. ");
INSERT INTO ikz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kwiribhita riyo, bhaarɨmu Anaasi wʉnʉ aarɨ kuhaani ʉmʉkʉrʉ, hamwɨmwɨ na Kayaafa, Yoohana, Arɨkizanda na abhandɨ bhanʉ bhaarɨ abhahiiri bha Anaasi. ");
INSERT INTO ikz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bhakatʉmanʼya Peetero na Yoohana bhareetwe, bhakabhiimiirirya mʉbhʉtangɨ bhwabhʉ kuchandarʉ, bhakabhabhuurya, “Ganʉ mʉgakʉrirɨ kwa ngurukɨ na kuriina rya wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hayo Peetero aarɨ izwirwɨ Ekoro Ɨndɨndu, akabhabhʉʉrɨra, “Abhakangati na abhakaruka bha abhaatʉ bha Iziraɨri, ");
INSERT INTO ikz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","reero mʉratubhuurya igʉrʉ wa amangʼana amazʉmu ganʉ twakʉrɨɨrɨ omorema na chɨmbu aahʉriibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Imwɨ na Abhiiziraɨri abhandɨ bhʉʉsi, nereenda emenyekanɨ kʉbha, ʉmʉʉtʉ wʉnʉ ariimɨɨrɨra mʉbhʉtangɨ bhwanyu reero, nɨ‑mʉhʉru kʉbhʉnaja bhwi iriina rya Yɨɨsu Kiriisitʉ wa Nazarɨɨti. Newe wʉnʉ imwɨ mwitirɨ kʉmʉsarabha, nawe Mungu akamuryʉra kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wʉnʉ newe Amaandɨkʉ Amarɨndu garagamba igʉrʉ waazɨ, ‘Riibhwɨ rɨnʉ abhʉʉmbaki mwangirɨ, neryo rɨbhɨɨrɨ riibhwɨ rikʉrʉ rya rusizʉ.’ ");
INSERT INTO ikz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bhʉtareeho bhutuurya kurwa kwa wʉndɨ wʉwʉʉsi, kʉ kʉbha rɨtareeho iriina ɨrɨndɨ mʉʉsɨ mʉnʉ ryʉ ʉbhʉnaja bhu ukututuurya itwɨ kʉhɨtɨra kwaryo!” ");
INSERT INTO ikz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Abhakʉrʉ bhayo bhaaza korora kʉbha, Peetero na Yoohana bhagambirɨ kwa bhʉkararu, no okomenya kʉbha bhayo, nɨ‑bhaatʉ bhanʉ bhaarɨ bhataasʉmirɨ, bhakarʉgʉʉra bhʉkʉngʼu. Bhakoobhoora kʉbha Peetero na Yoohana bhaarɨ hamwɨmwɨ na Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Abhakʉrʉ bhayo bhataarɨ ni‑ngʼana ryʉryʉsi ryʉ ʉkʉgamba, kʉ kʉbha bhakarora umusubhɨ wʉnʉ ahʉriibhwɨ imiiriirɨ hamwɨmwɨ na Peetero na Yoohana. ");
INSERT INTO ikz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bhakabhaswaja Peetero na Yoohana bhahʉrʉkɨ muchandarʉ murya. Ebho bhakasaaga bharagambana abheene, ");
INSERT INTO ikz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bharabhuga, “Tokorebhwɨ na abhaatʉ bhanʉ? Abhiikari bhʉʉsi bha Yɨrusarɨɨmu hanʉ, bhɨɨzɨ kʉbha bhakʉrirɨ ikitiika ɨkɨkʉrʉ kɨnʉ tʉtakʉtʉra kʉchanga. ");
INSERT INTO ikz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kuriribhɨra ringʼana rɨnʉ rɨtasanza kʉbhaatʉ, tʉbhareche bhatigɨ kʉgambana nʉ ʉmʉʉtʉ wʉwʉʉsi igʉrʉ wa Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Akʉmara abhakʉrʉ bhayo bhakabhabhɨrɨkɨra naatu muchandarʉ Peetero na Yoohana. Bhakabhahama kwa bhʉhaari, bhatiija nʉʉrʉ kʉgamba naatu kuriina riyo. ");
INSERT INTO ikz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nawe Peetero na Yoohana bhakabhagarukirya, “Mʉrarora imubheene, arɨɨbhɨ nɨ‑bhwaheene mʉbhʉtangɨ bhwa Mungu, kubhiitegeerera imwɨ kʉkɨra kwitegeerera Mungu umwene. ");
INSERT INTO ikz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nawe itwɨ tʉtakʉtʉra kutiga kʉgamba igʉrʉ wa amangʼana ganʉ twarʉʉzɨ nu ukwigwa!” ");
INSERT INTO ikz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hanʉ abhakʉrʉ bhayo bhaamarirɨ kʉbhakanga Peetero na Yoohana kwa bhʉhaari, bhakabhatigʉrʉkɨra. Bhataabhwɨnɨ nzɨra yʉ ʉkʉbhatema, kʉ kʉbha abhaatʉ bhʉʉsi bhaarɨ bharakumya Mungu bhʉkʉngʼu igʉrʉ wi ikitiika kiyo. ");
INSERT INTO ikz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ʉmʉʉtʉ wʉnʉ ahʉriibhwɨ, aarɨ morema kwɨma kwibhurwa kwazɨ ni imyaka jazɨ jarɨ gihitiiriirɨ merongo ene. ");
INSERT INTO ikz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hanʉ Peetero na Yoohana bhaatigurukiirwɨ, bhakagarʉka kubhiisirirya abhakɨndichabhʉ. Bhakabhaha ikiina chʉsi kɨnʉ bhaabhuuriirwɨ na abhakʉrʉ bha abhakuhaani na abhakaruka bha Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hanʉ bhiigwirɨ amangʼana gayo, bhʉʉsi bhakoongera riraka kʉsabha Mungu, “Ʉmʉkʉrʉ wʉ Ʉbhʉnaja, awɨ naawɨ Mungu, naawɨ watɨɨmirɨ risaarʉ, ɨɨsɨ, ɨnyanza na bhyʉsi bhɨnʉ bhirimu. ");
INSERT INTO ikz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Awɨ ʉkagamba kʉhɨtɨra umunywa gwa sʉʉkʉrʉ wɨɨtʉ Daudi omohocha waazʉ, na koKoro Ɨndɨndu ʉkabhuga, ‘Ndora abhaatʉ bha mubhyarʉ ɨbhɨndɨ bhiigatɨɨnɨ? Kwakɨ abhaatʉ bhariiseega kokora amangʼana ganʉ gataana bhwera? ");
INSERT INTO ikz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhatɨmi bhɨ ɨɨsɨ na abhakangati, bhariibhiringa hamwɨmwɨ, igʉrʉ wu ukumwanga Ʉmʉkʉrʉ Mungu na Kiriisitʉ waazɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ganʉ nɨ‑maheene, kʉ kʉbha Heroode Antipaasi na Pʉntiyʉ Piraato na abhaatʉ bha mubhyarʉ ɨbhɨndɨ na Abhiiziraɨri, bhakahunana hamwɨmwɨ mʉrʉbhɨri rʉnʉ korereke bhaangɨ Yɨɨsu, omohocha waazʉ ʉmʉrɨndu wʉnʉ wamʉhakirɨ amaguta. ");
INSERT INTO ikz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ganʉ bhakʉrirɨ bhayo, nego ganʉ wɨɨndirɨ gakorwe kwɨma ʉbhʉtangɨ na gakakorwa kumiisɨɨgi gaazʉ. ");
INSERT INTO ikz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nangʉ Ʉmʉkʉrʉ, rora amakango gaabhʉ, tohe ʉbhʉnaja itwɨ abhahocha bhaazʉ, tʉraganʼyɨ ɨngʼana yaazʉ kwa bhʉkararu bhwʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ʉraagorore okobhoko kwazʉ, kohorya abhaatʉ, ibhyɨrɨkɨnʼyʉ na amateemo bhekorwe kʉnzɨra yi iriina rya Yɨɨsu, omohocha waazʉ ʉmʉrɨndu!” ");
INSERT INTO ikz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hanʉ bhaamarirɨ kʉsabha Mungu, ahagero hanʉ bhaarɨ bhiibhiringiirɨ, hakasingishwa. Bhʉʉsi bhayo bhakiizuribhwa ne Ekoro Ɨndɨndu, bhakarwaza ɨngʼana ya Mungu kwa bhʉkararu. ");
INSERT INTO ikz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abhiisirirya bhʉʉsi bhaarɨ nu umwʉyʉ gʉmwɨ nʉ ʉbhʉkararu bhʉmwɨ. Ataarɨ areho mʉʉtʉ wʉwʉʉsi we ebhegero bhyazɨ, wʉnʉ akʉrirɨ kʉbha ibhyazɨ umwene, nawe bhaarɨ bhariimɨɨrɨrɨra ebhegero bhyʉsi kwa hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Neho abhatumwa bha Yɨɨsu bhakamenyeekererya abhaatʉ kʉmanaga gu ukuryʉka kʉMʉkʉrʉ Yɨɨsu, Mungu wʉʉsi akabhaha ʉrʉbhangʉ. ");
INSERT INTO ikz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ataareho ʉmʉʉtʉ wʉwʉʉsi gatɨ waabhʉ wʉnʉ akwenda, kʉ kʉbha abhaatʉ bhanʉ bhaarɨ kʉbha nɨ ɨmɨgʉndʉ hamwɨ zinyumba, bhakabhigurya na koreeta zimpirya ziyo. ");
INSERT INTO ikz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Bhakazereeta, bhakazɨhaana kʉbhatumwa, bhʉʉsi bhakasondya abhaatʉ kʉrɨngʼaana nu ubhwɨndi bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aarɨ areho Ʉmʉraawi wʉmwɨ, arabhirikirwa Yuusufu, umwibhurwa wa mucharʉ cha Kipurʉ, wʉnʉ abhatumwa bha Yɨɨsu bhaamʉhɨɨrɨ iriina Bharinaabha, enzobhooro yaku ni mwana wʉ ʉmʉhaani wu umwʉyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aarɨ nʉ ʉmʉgʉndʉ, akagugurya, akareeta zimpirya akazɨhaana kʉbhatumwa. ");
INSERT INTO ikz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Aarɨ areho ʉmʉʉtʉ wʉmwɨ iriina ryazɨ Ananiya, nʉ ʉmʉkari waazɨ aarɨ arabhirikirwa Safiira. Bhakagurya emenyo yaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Gatɨ wa zimpirya zɨnʉ bhaabhwɨnɨ, Ananiya akabhisa ɨzɨndɨ, ʉmʉkari waazɨ aarɨ isirirɨɨnʼyɨ neewe kokorabhu. Zimpirya zɨnʉ zasaagirɨ, Ananiya akazereeta akabhaha abhatumwa bha Yɨɨsu, ataagambirɨ amaheene kʉbha bhagɨgirɨku ɨzɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peetero akamubhuurya, “Ananiya! Kwakɨ Shɨtaani asikiirɨ mumwʉyʉ gwazʉ na akʉrirɨ ʉbhʉʉrɨrɨ Ekoro Ɨndɨndu ʉrʉrɨmɨ na kubhisa zimpirya ɨzɨndɨ zɨnʉ wabhwɨnɨ ku kugurya emenyo yaazʉ? ");
INSERT INTO ikz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hanʉ waarɨ ʉkɨɨrɨ kugurya ɨtaarɨ yaazʉ? Hanʉ yaarɨ ɨmarirɨ kuguribhwa kɨnʉ wabhwɨnɨ kɨtaarɨ mʉmabhoko gaazʉ? Ɨkabhabhwɨ kuhika ʉkatʉʉra ringʼana ncha rɨnʉ mumwʉyʉ gwazʉ? Ʉtabhuuriirɨ ʉmʉʉtʉ rʉrɨmɨ, nawe ni‑Mungu ubhuuriirɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hanʉ Ananiya iigwirɨ amangʼana gayo, bhwangʉ bhu akagwa haasɨ, akakwa. Abhaatʉ bhʉʉsi bhanʉ bhiigwirɨ ringʼana riyo, bhakʉʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Neho abhamura bhakabhʉʉka, bhakakundikirya ɨkɨtʉndʉ chazɨ ɨsanda, bhakamuhurucha igʉtʉ wʉ ʉrʉbhɨri, bhakamʉbhɨɨka. ");
INSERT INTO ikz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hanʉ zaahitirɨ zɨɨsa isatʉ, ʉmʉkari wa Ananiya wʉʉsi akasikɨra ɨgatɨ muyo, atɨɨzɨ amangʼana ganʉ gakʉriibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peetero akamubhuurya, “Mbʉʉrɨra, mʉkagurya emenyo yanyu kuzimpirya zɨnʉ?” Ewe akabhuga, “Hee, tʉkagurya kwe ekerengo kiyo.” ");
INSERT INTO ikz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peetero akamʉbhʉʉrɨra, “Ndora awɨ nu umusubhɨ waazʉ mwisirirɨɨnʼyɨ kogema Ekoro Ɨndɨndu yʉ Ʉmʉkʉrʉ? Rora! Amagʉrʉ ga bhanʉ bhaarɨ bhagiirɨ kʉbhɨɨka umusubhɨ waazʉ garɨ kukisikʉ, bhamarirɨ kʉgarʉka, bharaaza kusikɨra bhakuhuruchɨ igʉtʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Rogendo rʉmwɨ Safiira wʉʉsi akagwa haasɨ mʉbhʉtangɨ bhwa amagʉrʉ ga Peetero, akakwa. Neho abhamura bhakasikɨra, bhakabhona Safiira wʉʉsi akuurɨ, bhakamuhurucha igʉtʉ, bhakamʉbhɨɨka haguhɨ nu umusubhɨ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gayo gakakora risengerero igima, hamwɨmwɨ na abhandɨ bhʉʉsi bhanʉ bhiigwirɨ amangʼana gayo, kwʉbhaha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abhatumwa bha Yɨɨsu bhaarɨ bharakora ibhyɨrɨkɨnʼyʉ na amateemo bhyaru kʉbhaatʉ. Abhiisirirya bhʉʉsi bha Yɨɨsu, bhaarɨ bhanarirɨ kwibhiringa hamwɨmwɨ Mwigoobhe rya Sɨrɨmaani rɨnʉ ryarɨ mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Abhaatʉ bhanʉ bhaarɨ bhakɨɨrɨ kwisirirya Yɨɨsu, bhakʉʉbhaha kʉbha hamwɨmwɨ nebho, nangabha abhaatʉ bharabhasʉʉka bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nawe abhaatʉ abhandɨ, abhasubhɨ na abhakari, bhakiisirirya Ʉmʉkʉrʉ, kuriyo endengo ya abhiisirirya yaarɨ iriiyoongera bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kʉrɨngʼaana na amateemo gayo, abhaatʉ bhaarɨ bharabhahira abharwɨrɨ na kʉbhatʉʉra rusizʉ wɨ ɨnzɨra. Mʉnzɨra hayo, bhaarɨ bharabhahindirya kʉbhʉrɨrɨ na kʉbhɨragʉ, korereke Peetero araahɨtɨ, ikiiriiri chazɨ kɨbhakunʼyɨku abhaatʉ bhorebhe bhahore. ");
INSERT INTO ikz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Abhaatʉ bhaaru bhaarɨ kurwa mʉzɨmbɨri za rusizʉ wa Yɨrusarɨɨmu, bhakabha bharareeta abharwɨrɨ bhaabhʉ na bhanʉ bhaarɨ bhakʉnyaakibhwa na amasambwa, bhʉʉsi bhakahʉribhwa. ");
INSERT INTO ikz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Neho kuhaani ʉmʉkʉrʉ na abhakɨndichabhʉ bhʉʉsi, bhanʉ bhaarɨ bha riribhita rya Abhasadukaayo, bhakabharorera ikiriiso abhatumwa bha Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bhakagwata abhatumwa bhayo, bhakabhatʉʉra mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nawe ubhutikʉ bhurya, maraika wʉ Ʉmʉkʉrʉ akaaza, akiigʉra ibhisikʉ bhyi inyumba yiyo, akabhahurucha igʉtʉ. Hanʉ aamarirɨ, akabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mogende mwimɨɨrɨrɨ mwihekaaru, mʉbhabhʉʉrɨrɨ abhaatʉ amangʼana gʉʉsi igʉrʉ wʉ ʉbhʉhʉru ubhuhya bhʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hanʉ abhatumwa bhayo bhiigwirɨ, bhakamweza ritabhʉʉri bhakaja mwihekaaru, bhakatanga kwija abhaatʉ. Hanʉ kuhaani ʉmʉkʉrʉ hamwɨmwɨ na abhakɨndichazɨ bhaahikirɨ, bhakabhɨrɨkɨra abhakʉrʉ bhʉʉsi bha Abhiiziraɨri, bhahunanɨ kuchandarʉ. Bhakatʉma abhariibhi mokebhoho, korereke bhareete abhatumwa. ");
INSERT INTO ikz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nawe hanʉ abhariibhi bhayo bhaasikiirɨ, bhataabhwɨnɨ abhatumwa bhayo mokebhoho. Bhakagarʉka kʉbhakʉrʉ, bhakabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hanʉ twahikirɨ kunyumba ye ekebhoho, tʉkabhona ibhisikʉ bhyigɨɨrɨ bhwaheene, abhariibhi bhiimiiriirɨ igʉtʉ wi ibhisikʉ, hanʉ twigwirɨ ibhisikʉ, tʉtabhwɨnɨ mʉʉtʉ wʉwʉʉsi mokebhoho muyo!” ");
INSERT INTO ikz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ʉmʉkʉrʉ wa abhariibhi bha rihekaaru na abhakʉrʉ bha abhakuhaani hanʉ bhiigwirɨ gayo, bhakatama kwobhoora, bhakiibhuurya, “Ringʼana riyo rɨrabhabhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Akaaza ʉmʉʉtʉ wʉmwɨ, akabhabhʉʉrɨra, “Munyiitegeerere! Abhaatʉ bhanʉ mwigariirɨ mokebhoho, nangwɨnʉ bhari mwihekaaru! Bhariija abhaatʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Neho ʉmʉkʉrʉ wa abhariibhi wuyo, hamwɨmwɨ na abhariibhi bhaazɨ, bhakaja kʉbhatumwa bhayo, bhakabhareeta. Nawe bhataabhagwatirɨ kwa nguru, kʉ kʉbha bhakʉʉbhaha kotemwa amabhwɨ na abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hanʉ bhabharɨɨtirɨ kuchandarʉ cha abhakʉrʉ bhayo, kuhaani ʉmʉkʉrʉ akabhabhuurya, ");
INSERT INTO ikz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tʉmarirɨ kʉbharecha kwa nguru kʉbha mutigɨ kwija abhaatʉ igʉrʉ wi iriina ryʉ ʉmʉʉtʉ wuyo! Nawe imwɨ mʉrangʼeha kwija abhaatʉ amangʼana gaanyu mbaara zʉʉsi za Yɨrusarɨɨmu, naatu moreenda koreeta ɨkɨsaahɨ chʉ ʉmʉʉtʉ wuyo igʉrʉ wɨɨtʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peetero na abhatumwa abhandɨ bhakamʉgarukirya, “Toreenderwa kʉsʉʉka Mungu, kʉkɨra abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Imwɨ mukiita Yɨɨsu kʉ kʉmʉbhamba kʉmʉsarabha, nawe Mungu wa abhasʉʉkʉrʉ akamuryʉra. ");
INSERT INTO ikz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mungu akamʉgʉnga nʉ ʉkʉmʉtʉʉra ʉrʉbhaara rwazɨ rwu ubhuryʉ, abhɨ Ʉmʉkangati nʉ Ʉmʉsabhuri, abhahɨ Abhiiziraɨri korereke bhatigɨ ʉbhʉbhɨ bhwabhʉ, bhabheererwe. ");
INSERT INTO ikz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Itwɨ nɨ‑bhamɨnyɨɨkɨrɨri bha gayo gʉʉsi, hamwɨmwɨ ne Ekoro Ɨndɨndu, yɨnʉ Mungu abhahɨɨrɨ bhanʉ bhakumwigwa.” ");
INSERT INTO ikz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abhakʉrʉ bhayo hanʉ bhiigwirɨ gayo, bhakiigatana bhʉkʉngʼu, bhakiiseemerya kwita abhatumwa bhayo. ");
INSERT INTO ikz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nawe muchandarʉ hayo, aarɨ areho Ʉmʉfarisaayo wʉmwɨ, iriina ryazɨ Gamariɨri. Gamariɨri wuyo aarɨ umwija wi imigirʉ na aarɨ arasuukwa na abhaatʉ bhʉʉsi. Akiimɨɨrɨra, akaswaja kʉbha, abhatumwa bhahurukibhwɨ igʉtʉ kwibhaga iguhɨ. ");
INSERT INTO ikz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Akʉmara akabhabhʉʉrɨra abhakʉrʉ abhakɨndichabhʉ, “Abhahiiri bhaanɨ Abhiiziraɨri, hinga mwiyangarɨrɨ, kʉrɨnʉ mukwenda kokora kʉbhaatʉ bhanʉ! ");
INSERT INTO ikz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mwiseege zisikʉ zɨnʉ zaahitirɨ, akabhoneka ʉmʉʉtʉ wʉmwɨ, iriina ryazɨ Tɨuda, aarɨ ariikora kʉbha nɨ‑mʉʉtʉ mʉkʉrʉ, akabhona abhahɨmba magana ane, bhakagwatana neewe. Nawe mʉtɨnɨrʉ akiitwa, na abhahɨmba bhaazɨ bhʉʉsi bhakanyaragana na kʉbhʉra. ");
INSERT INTO ikz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ribhaga rɨkahɨta, abhaatʉ bhaarɨ bharabharwa endengo yaabhʉ, akabhoneka Yuuda Ʉmʉgariraaya, wʉʉsi akabharuta abhaatʉ bhakamutuna. Nawe wʉʉsi akiitwa, abhahɨmba bhaazɨ bhakanyaragana. ");
INSERT INTO ikz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Mmbe nɨrabhabhʉʉrɨra, mutiganɨ na abhaatʉ bhanʉ. Mutigɨ kʉbhakorera ryʉryʉsi ibhɨ, kʉ kʉbha arɨɨbhɨ emeremo jabhʉ gɨnʉ gɨtangirwɨ na abhaatʉ, gɨrasira ijene. ");
INSERT INTO ikz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nawe arɨɨbhɨ ne‑meremo ja Mungu, mʉtakʉtʉra kʉbharecha, mʉrabhona muriitana na Mungu umwene.” ");
INSERT INTO ikz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bhakiisirirya amangʼana gaazɨ, bhakabhabhɨrɨkɨra abhatumwa muchandarʉ. Bhakatemwa zihimbʉ nzaru, akʉmara bhakabharecha bhatigɨ kʉbhabhʉʉrɨra abhaatʉ kuriina rya Yɨɨsu, bhakabhatigʉrʉkɨra. ");
INSERT INTO ikz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abhatumwa bhayo bhakarwa kuchandarʉ kiyo bhazʉmɨɨrwɨ, kʉ kʉbha Mungu akabhaha ubhusuuku kukusuukibhwa kuriina rya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bhakakaja kwija na kurwazɨra mwihekaaru na muzinyumba za abhaatʉ sikʉ zʉʉsi amangʼana amazʉmu kʉbha, Yɨɨsu newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kuzisikʉ ziyo, endengo ya abhɨɨga bha Yɨɨsu yaarɨ ɨrakaja kwaruha. Gatɨ waabhʉ bhaarɨ bharimu Abhayaahudi bhanʉ bhaarɨ bhakʉgamba Ikigiriki, na Abhayaahudi bhanʉ bhaarɨ bhakʉgamba Ɨkɨɨbhuraaniya. Bharya bhaarɨ bhakʉgamba Ikigiriki bhakiibheerya kʉbha, abhakwirwa bhaabhʉ bhahɨɨbhwa kosondo yi ibhyakurya bhya kɨrakabhu. ");
INSERT INTO ikz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kʉgayo, abhatumwa ikumi na bhabhɨrɨ bhakabhiringa abhɨɨga bhʉʉsi, bhakabhabhʉʉrɨra, “Ɨtarɨ bhwaheene itwɨ tutigɨ kwija ɨngʼana ya Mungu, kʉ kʉbha yo okosondya abhaatʉ ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nangʉ abhahiiri bhɨɨtʉ, morobhore abhasubhɨ muhungatɨ kʉbhaniimwɨ, bhanʉ bhamɨnyɨkɨɨnɨ kʉbha bhaana ubhukumya ʉbhʉzʉmu, bhiizwirwɨ Ekoro Ɨndɨndu nu ubhwʉbhʉʉri, tʉbhahɨ emeremo giyo. ");
INSERT INTO ikz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Itwɨ tʉrahocha kwa kʉsabha Mungu na kwija abhaatʉ ɨngʼana yaazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ringʼana riyo rɨkabhazomera abhiisirirya bhayo bhʉʉsi. Bhakarobhora Sitɨfaanʉ, ʉmʉʉtʉ wʉnʉ iizwirɨ Ekoro Ɨndɨndu nu ubhwisirirya ʉbhʉkʉrʉ, bhakarobhora Firipʉ, Pʉrʉkʉʉrʉ, Nɨkanʉʉri, Tiimʉni, Parimeena, na Nikorao wa Antiyʉkiya, wʉnʉ isiriiryɨ ɨnyangi yɨ Ɨkɨyaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhakabhareeta abhaatʉ bhayo mʉbhʉtangɨ bhwa abhatumwa. Abhatumwa bhakabhasabhɨra na kʉbhateera amabhoko kʉbhaha ʉrʉbhangʉ. ");
INSERT INTO ikz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ɨngʼana ya Mungu ɨkakaja kʉnyaragana kʉbhaatʉ. Ne endengo ya abhɨɨga bha Yɨɨsu ɨkaaruha bhʉkʉngʼu Yɨrusarɨɨmu na abhakuhaani bhaaru bhakiigwa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitɨfaanʉ aarɨ arakora amateemo ni ibhyɨrɨkɨnʼyʉ kʉbhaatʉ, kʉ kʉbha aarɨ nɨ ɨbhɨgʉngi bhyaru na zinguru nzaru kurwa kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nawe bhakabhoneka abhaatʉ korereke bhahakaanɨ na Sitɨfaanʉ. Abhaatʉ bhayo ni bha rirwazɨrʉ yɨnʉ ikubhirikirwa Rirwazɨrʉ ya Abhaatʉ Bhanʉ Bhatigurukiirwɨ, bhayo bhakarwa Kireene, Arɨkizandiriya, Kirikiya na Asiya. ");
INSERT INTO ikz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nawe akabha arabhahiza kʉ kʉbha akagamba amangʼana gu ubhwʉbhʉʉri, kʉbhʉnaja bhwe Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Neho bhakakorokomba abhaatʉ abhandɨ, bhagambɨ ʉrʉrɨmɨ kʉbha, “Twigwirɨ Sitɨfaanʉ aragamba amangʼana amabhɨ igʉrʉ wa Musa na Mungu.” ");
INSERT INTO ikz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kʉmagamba gaabhʉ gayo bhakasiigirirya abhaatʉ, abhakaruka bha Abhayaahudi na abhiija bhi imigirʉ. Bhakagɨɨra Sitɨfaanʉ, bhakamugwata, bhakamuhira kuchandarʉ cha abhakʉrʉ bha Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bhakareeta abhamɨnyɨɨkɨrɨri bhʉ ʉrʉrɨmɨ, bhakagamba amangʼana gʉ ʉrʉrɨmɨ igʉrʉ wa Sitɨfaanʉ, “Zisikʉ zʉʉsi ʉmʉʉtʉ wʉnʉ aragamba amangʼana amabhɨ igʉrʉ wa rihekaaru rirɨndu rɨnʉ ni igʉrʉ wi imigirʉ ja Musa! ");
INSERT INTO ikz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tumwigwirɨ arabhuga, Yɨɨsu Ʉmʉnazarɨɨti arasarya ahagero hanʉ na arachʉra amanarʉ gɨɨtʉ garya Musa aatʉhɨɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abhaatʉ bhʉʉsi kuchandarʉ ɨkɨkʉrʉ kiyo, bhakamogorera Sitɨfaanʉ bhʉkʉngʼu, bhakarora ubhushʉ bhwazɨ bhutuubhɨɨnɨ nu ubhushʉ bhwa maraika. ");
INSERT INTO ikz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Neho kuhaani ʉmʉkʉrʉ akabhuurya Sitɨfaanʉ, “Gʉʉsi ganʉ bhagambirɨ, heene nɨmbu garɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitɨfaanʉ akabhuga, “Bhabhaabha na abhahiiri bhɨɨtʉ, munyiitegeerere! Mungu umugungwa akahwarʉkɨra sʉʉkʉrʉ Abhurahaamu mucharʉ cha Mesopotaamiya, hanʉ aarɨ akɨɨrɨ kʉsaamɨra kʉrʉbhɨri rwa Haraani. ");
INSERT INTO ikz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mungu akamʉbhʉʉrɨra, ‘Urwɨ mucharʉ chazʉ, utigɨ abhahiiri bhaazʉ, ujɨ mucharʉ kɨnʉ nɨraakwereche.’ ");
INSERT INTO ikz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Neho Abhurahaamu akasaama mucharʉ chazɨ cha Abhakaridaayʉ, akaja kwikara Haraani. Hanʉ wiisɨ aakuurɨ, Mungu akamʉsaamya, akamoreeta mucharʉ kɨnʉ mukwikaramu nangwɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Mungu ataagabhiryɨ Abhurahaamu nʉʉrʉ kɨtɨnɨka kisuuhu cha ahagero kucharʉ kʉnʉ. Nawe akamʉraganʼya, aramoha ahagero habhɨ ahaazɨ na hu urwibhʉrʉ rwazɨ, nangabha ribhaga riyo ataarɨ na mwana. ");
INSERT INTO ikz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mungu akabhʉʉrɨra Abhurahaamu, ‘Abhaatʉ bhu urwibhʉrʉ rwazʉ bhariikara mubhugini kucharʉ cha abhandɨ, abhaatʉ bhi icharʉ kiyo bharabhakora kʉbha bhambʉʉsa. Na bharanyaakibhwa kwi imyaka magana ane. ");
INSERT INTO ikz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nawe abhaatʉ bhi icharʉ kiyo, bhanʉ bharaabhakore abhaatʉ bhayo abhahocha, nɨrabhatɨnɨra, urwibhʉrʉ rwazʉ bhararwa mucharʉ kiyo, bharaaza hanʉ konsengera.’ ");
INSERT INTO ikz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Akʉmara Mungu akakora ʉbhʉragɨ na Abhurahaamu bhwʉ ʉkʉsaara abhaana bhʉʉsi bhi ikisubhɨ. Abhurahaamu akiibhʉra Iisaka, akamʉsaara urusikʉ rwa kanaanɨ rwu ukwibhurwa kwazɨ. Na Iisaka wʉʉsi akiibhʉra Yaakobho akamʉsaara, Yaakobho wʉʉsi akiibhʉra abhamura ikumi na bhabhɨrɨ akabhasaara, nebho abhakaruka bhɨɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abhakaruka bhɨɨtʉ bhayo bhakarorera Yuusufu engʼeera, bhakamugurya abhɨ omohocha, mucharʉ cha Miisiri. Nawe Mungu aarɨ hamwɨmwɨ na Yuusufu, ");
INSERT INTO ikz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akamʉsabhʉra kurwa mʉnyaakʉ yaazɨ yʉʉsi. Akamoha ubhwʉbhʉʉri nʉ ʉkʉsɨɨgwa mʉbhʉtangɨ bhwa Farao, ʉmʉtɨmi wa Miisiri, ewe akamoha ʉbhʉkangati ʉbhʉkʉrʉ mucharʉ cha Miisiri nu umwimiiririri wi inyumba yaazɨ yʉʉsi yɨ ɨkɨtɨmi. ");
INSERT INTO ikz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Akʉmara ɨkabhoneka ɨnzara haari mʉʉsɨ yʉʉsi ya Miisiri na Kanaani, yɨnʉ yagiriryɨ ɨnyaakʉ ɨnzaru, bhabhaabha bhɨɨtʉ bhataabhwɨnɨ ibhyakurya bhya kwisa. ");
INSERT INTO ikz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hanʉ Yaakobho iigwirɨ Miisiri ini ibhyakurya, akatʉma abhaana bhaazɨ kujayʉ. Rwarɨ rogendo rwe embere kʉbhabhaabha bhɨɨtʉ kuhikayo. ");
INSERT INTO ikz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Korogendo rwabhʉ rwa kabhɨrɨ, Yuusufu akiitonda kʉbhahiiri bhaazɨ, abhahiiri bhaazɨ bhʉʉsi bhakamenyekana kwa Farao. ");
INSERT INTO ikz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yuusufu akatʉma amangʼana kwa wiisɨ, aazɨ Miisiri, hamwɨmwɨ na abhaatʉ bhaazɨ bhʉʉsi, bhaarɨ nɨ‑bhaatʉ merongo muhungatɨ na bhataanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Akʉmara Yaakobho akaja Miisiri, akarikɨrayu, na bhasʉʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɨmɨbhɨrɨ jabhʉ gɨkareetwa ɨwaabhʉ kʉrʉbhɨri rwa Shɨkɨmu, gɨkabhiikwa muzimbihɨra, zɨnʉ Abhurahaamu aagurirɨ kondengo ya zimpirya bhorebhe Shɨkɨmu iyo, kʉbhaana bha Hamʉʉri. ");
INSERT INTO ikz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ribhaga rɨnʉ Mungu aaragɨɨnʼyɨ Abhurahaamu hanʉ ryarɨ rɨraariirɨ kuhika, endengo ya Abhiiziraɨri ɨkakaja kohera bhʉkʉngʼu Miisiri. ");
INSERT INTO ikz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nawe ʉmʉtɨmi ʉwʉndɨ wʉnʉ ataarɨ amwɨzɨ Yuusufu, akatanga kugwatɨrɨra Miisiri. ");
INSERT INTO ikz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ʉmʉtɨmi wuyo akabhakorera amabhɨ kʉ ʉkʉbhakangirirya abhaatʉ bhɨɨtʉ, naatu akabhanyaacha na kʉbhanyahaara kwa kobheenda bhabharekere abhaana bhaabhʉ abhabhataarɨ, korereke bhakwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ribhaga riyo Musa akiibhurwa, ewe aarɨ mʉzʉmu bhʉkʉngʼu, akarerwa kwibhaga rya myɨri ɨtatʉ munyumba ya wiisɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Akʉmara, abhiibhuri bhaazɨ bhakatamwa kongʼeha kumubhisa munyumba, bhakamʉtʉʉra igʉtʉ. Neho umuucha wʉ ʉmʉtɨmi Farao akamotoora, akamorera nchu umwana waazɨ wi ikisubhɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa akiijibhwa ubhwʉbhʉʉri bhwʉsi bhwa Abhamiisiri, akabha wʉ ʉbhʉnaja kʉmangʼana nɨ ɨbhɨsɨgʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hanʉ Musa aahikiryɨ imyaka merongo ene, akakarara kuja kuhunana na abhahiiri bhaazɨ Abhiiziraɨri. ");
INSERT INTO ikz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akarora Umwiziraɨri wʉmwɨ arakorerwa amabhɨ nu Umumiisiri, akiibhagɨra Umwiziraɨri wuyo, akamʉrɨhɨra isiirɨ ku kumwita Umumiisiri wuyo. ");
INSERT INTO ikz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa aarɨ arakina kʉbha, abhahiiri bhaazɨ bharamenya kʉbha, kʉnzɨra yaazɨ, Mungu arabhatuurya, nawe bhataamɨnyirɨ riyo. ");
INSERT INTO ikz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tabhʉʉri waho, akabhona Abhiiziraɨri bhabhɨrɨ bhariitana, akagema kʉbhataanʼya arabhabhʉʉrɨra kʉbha, ‘Imwɨ nɨ‑bhahiiri! Ndora muriinyahaara?’ ");
INSERT INTO ikz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Nawe wʉnʉ aarɨ aratema ʉmʉkɨndichazɨ, akasukumɨra Musa rusizʉ, akabhuurya, ‘Nɨ‑wɨɨwɨ wʉnʉ akʉtɨɨrɨ ʉbhɨ ʉmʉkangati wɨɨtʉ nu umutiniri wɨɨtʉ? ");
INSERT INTO ikz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Awɨɨ, oreenda kunyita chɨmbu izʉ wiitirɨ Umumiisiri?’ ");
INSERT INTO ikz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hanʉ Musa iigwirɨ amangʼana gayo, akaryarɨra mucharʉ cha Midiyani, akiikara mubhugini iyo, akiibhʉrɨrayu abhaana bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Imyaka emerongo ene gɨnʉ gihitirɨ Musa aarɨ Midiyani, akahwarukirwa na maraika wʉ Ʉmʉkʉrʉ, aarɨ kʉkɨbhara haguhɨ nɨ ɨkɨgʉrʉ cha Sinayi. Maraika wuyo aarɨ mʉkɨsaka kɨnʉ charɨ kɨraaka omorero. ");
INSERT INTO ikz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Hanʉ Musa aakɨrʉʉzɨ ɨkɨsaka kiyo, akarʉgʉʉra bhʉkʉngʼu. Akakiisukɨra akerore bhwaheene, akiigwa riraka ryʉ Ʉmʉkʉrʉ Mungu, rɨrabhuga, ");
INSERT INTO ikz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Inyɨ niinyɨ Mungu wa bhasʉʉkʉrʉ bhaanyu, Mungu wa Abhurahaamu, Iisaka na Yaakobho!’ Hanʉ Musa iigwirɨ gayo, akatanga kurigita, akʉʉbhaha korora ɨkɨsaka kiyo. ");
INSERT INTO ikz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ʉmʉkʉrʉ Mungu akamʉbhʉʉrɨra, ‘Ruusha ibhikwɨra bhyazʉ, kʉ kʉbha hanʉ ukwimɨɨrɨra nɨ‑harɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Amaheene nɨrʉʉzɨ ɨnyaakʉ ya abhaatʉ bhaanɨ bhanʉ bharɨ Miisiri, niigwirɨ ɨkɨrɨrʉ chabhʉ, niikirɨ kurwa mwisaarʉ kʉbhatuurya. Nangʉ nɨrakʉtʉma Miisiri.’ ");
INSERT INTO ikz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa wuyo newe abhaatʉ bha Iziraɨri bhaangirɨ bharamʉbhʉʉrɨra, ‘Nɨ‑wɨɨwɨ wʉnʉ akʉtɨɨrɨ ʉbhɨ ʉmʉkangati wɨɨtʉ nu umutiniri wɨɨtʉ?’ Mungu atumirɨ Musa abhɨ ʉmʉkangati waabhʉ nʉ ʉmʉsabhuri waabhʉ, kʉnzɨra ya maraika wʉnʉ aamuhwarukiirɨ mʉkɨsaka kirya! ");
INSERT INTO ikz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Akʉmara Musa akabhakangata bharwɨ ɨɨsɨ ya Miisiri, kwa kokora amateemo ni ibhyɨrɨkɨnʼyʉ bhyaru kʉʉsɨ ya Miisiri, mʉnyanza ya Shamu, na kʉkɨbhara, kwibhaga ryi imyaka merongo ene. ");
INSERT INTO ikz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Musa wuyo newe aabhuuriirɨ Abhiiziraɨri, ‘Mʉbhahiiri bhaanyu Mungu ariimiirirya ʉmʉrʉʉtɨrɨri ncha niinyɨ. Mumwitegeerere kʉganʉ gʉʉsi araabhabhʉʉrɨrɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa newe aarɨ hamwɨmwɨ na bhasʉʉkʉrʉ kʉkɨbhara na newe wʉnʉ aagambirɨ na maraika wa Mungu kʉkɨgʉrʉ cha Sinayi, newe akasʉngʼaana amangʼana gʉ ʉbhʉhʉru, korereke atʉbhʉʉrɨrɨ itwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nawe bhasʉʉkʉrʉ bhayo, bhakaanga kumwisirirya Musa, bhakamʉtʉʉra rusizʉ na bhakiigomba kʉgarʉka Miisiri. ");
INSERT INTO ikz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhakabhʉʉrɨra Haruuni, ‘Tokorere amasambwa ganʉ gakʉtʉkangata mʉnzɨra. Musa wuyo akatʉkangata kurwa Miisiri, tʉtɨɨzɨ amangʼana ganʉ gamubhwɨnɨ!’ ");
INSERT INTO ikz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zisikʉ ziyo, bhakakora ribhirʉbhirʉ rɨnʉ rituubhɨɨnɨ nɨ ɨkɨmʉʉri che engʼombe, bhakarihurukirya ikimweso bhazʉmɨɨrwɨ, kokegero kɨnʉ bhaakʉrirɨ kʉmabhoko gaabhʉ abheene! ");
INSERT INTO ikz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nawe Mungu akiichʉra, akatiga bhasengere umwɨri, iryʉbha na zenzota za mwisaarʉ, chɨmbu yandikirwɨ mʉkɨtabhʉ cha abharʉʉtɨrɨri, ‘Imwɨ Abhiiziraɨri, ribhaga rɨnʉ mwikɨɨrɨ kʉkɨbhara imyaka merongo ene, heene mwarɨ mʉransɨnzɨra imitugʉ korereke munhurukiryɨ ikimweso? ");
INSERT INTO ikz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mʉkagega ribhuru rya risambwa Mʉrɨɨki, na zenzota za risambwa ryanyu rikʉrʉ Rɨfaani, mwikʉrɨɨrɨ amasambwa korereke mʉgasengere. Kʉgayo, nɨrabhakora mʉbhɨ abhahocha, nɨrabhahira mucharʉ cha kore bhʉkʉngʼu, nʉʉrʉ kʉkɨra Bhaabhɨɨri.’ ” ");
INSERT INTO ikz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitɨfaanʉ akangʼeha kʉgamba, “Kʉkɨbhara iyo, bhasʉʉkʉrʉ bhɨɨtʉ bhayo bhaarɨ na ribhuru ryo okosengera Mungu. Ryarɨ rɨkʉrirwɨ chɨmbu Mungu ɨrɨkɨɨnʼyɨ hanʉ aagambɨɨnɨ na Musa, kʉbha aryʉmbakɨ kʉrɨngʼaana ne ekerenjo kɨnʉ aarʉʉzɨ. ");
INSERT INTO ikz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Akʉmara bhasʉʉkʉrʉ, bhakiibharɨɨra ribhuru kuhika ribhaga rya Yoosho hanʉ bhaayɨsaakwirɨ ɨɨsɨ yirya kurwa kʉbhaatʉ bhi ikishoko ɨkɨndɨ, bhanʉ Mungu abhahɨɨbhirɨ. Ribhuru rɨkasaaga kʉʉsɨ yaabhʉ kuhika ribhaga ryʉ ʉmʉtɨmi Daudi. ");
INSERT INTO ikz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi akasɨɨgwa na Mungu, wʉʉsi akamʉsabha amwʉmbakɨrɨ Mungu wa Yaakobho rihekaaru. ");
INSERT INTO ikz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nawe Sɨrɨmaani newe aamwʉmbakiirɨ inyumba. ");
INSERT INTO ikz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nawe Mungu wi Igʉrʉ wa Bhyʉsi, atakwikara muzinyumba zɨnʉ zikwʉmbakwa na amabhoko ga abhaatʉ abheene, chɨmbu ʉmʉrʉʉtɨrɨri Isaaya aagambirɨ, ");
INSERT INTO ikz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ʉmʉkʉrʉ akabhuga, Risaarʉ necho ikitumbɨ chanɨ chɨ ɨkɨtɨmi, nɨ ɨɨsɨ neyo ʉrʉbhaara rwanɨ rwʉ ʉkʉtʉʉra amagʉrʉ gaanɨ. Nangʉ ni‑nyumbakɨ, yɨnʉ mʉkʉtʉra kunyumbakɨra? Ahagero haanɨ hu ukwoyeera harabha hayi? ");
INSERT INTO ikz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nɨtarɨ niinyɨ nɨkʉrirɨ ebhegero bhɨnʉ bhyʉsi?’ ” ");
INSERT INTO ikz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitɨfaanʉ akangʼeha kʉgamba, “Imwɨ zɨntama kwigwa! Mozekoro zaanyu mʉtakosengera Mungu, na amatwɨ gaanyu gatakʉtʉra kwigwa amangʼana gaazɨ. Sikʉ zʉʉsi mʉraanga Ekoro Ɨndɨndu, chɨmbu bhawʉsʉʉkʉrʉ bhʉʉsi bhaamwangirɨ! ");
INSERT INTO ikz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Heene areho ʉmʉrʉʉtɨrɨri nʉʉrʉ wʉmwɨ wʉnʉ bhawʉsʉʉkʉrʉ bhatamʉnyaakiryɨ? Bhakiita na abharʉʉtɨrɨri bhanʉ ɨkarɨ bhaarɨ bhareerekeererya ukuuza kwa We Eheene wa Mungu! Na wuyo newe imwɨ mwamwichurirɨ, mʉkamwita! ");
INSERT INTO ikz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imwɨ mʉmarirɨ kʉsʉngʼaana imigirʉ ja Mungu, gɨnʉ jarusiibhwɨ kʉnzɨra ya bhamaraika bhaazɨ, nawe mʉtagisiriiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hanʉ abhakʉrʉ bha Abhayaahudi bhayo bhiigwirɨ amangʼana ga Sitɨfaanʉ, bhakiigatana bhʉkʉngʼu, bhakarʉma ichara kwa bhʉrʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nawe Sitɨfaanʉ akabha izuriibhwɨ Ekoro Ɨndɨndu, akarora igʉrʉ mwisaarʉ, akarora ubhwɨrʉ bhwa Mungu na Yɨɨsu imiiriirɨ ʉrʉbhaara rwu ubhuryʉ rwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Akabhuga, “Morore! Nɨrarora risaarʉ ryigukirɨ, Umwana wʉ Ʉmʉʉtʉ imiiriirɨ ʉrʉbhaara rwu ubhuryʉ rwa Mungu!” ");
INSERT INTO ikz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nawe abhakʉrʉ bha Abhayaahudi bhayo bhakarɨgɨsa bhʉkʉngʼu, bhakaribha amatwɨ gaabhʉ na amabhoko. Bhakahurumukɨra Sitɨfaanʉ kwa hamwɨmwɨ, bhakamugwata, ");
INSERT INTO ikz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bhakamuhurucha igʉtʉ wi ichandarʉ na kumuhira igʉtʉ wʉ ʉrʉbhɨri, bhakamotema amabhwɨ. Abhamenyeekererya bhayo bhakatʉʉra zengebho zaabhʉ haguhɨ nu umumura wʉmwɨ iriina ryazɨ Sauri. ");
INSERT INTO ikz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hanʉ bhaarɨ bharakomera Sitɨfaanʉ na amabhwɨ, akasabha arabhuga, “Ʉmʉkʉrʉ Yɨɨsu, sʉngʼaana ekoro yaanɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akʉmara akahigama, akarɨra kwiraka ikʉrʉ arabhuga, “Ʉmʉkʉrʉ, ʉtabhabharɨra ʉbhʉbhɨ bhʉnʉ igʉrʉ waabhʉ abhaatʉ bhanʉ!” Hanʉ aamarirɨ kʉgamba gayo akatinʼya. Sauri wʉʉsi aareho, akiisirirya ukwitwa kwa Sitɨfaanʉ kwarɨ bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Urusikʉ ruyo, risengerero rya Yɨrusarɨɨmu rɨkatanga kobhona ɨnyaakʉ. Bhʉʉsi bhakanyaragana na kuja mucharʉ cha Yudeya na Samaariya, kuruushaku abhatumwa bha Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Abhaatʉ bhanʉ bhakʉsabha Mungu, bhakamʉbhɨɨka Sitɨfaanʉ na kumwikarɨra ubhwʉyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nawe Sauri akagema kʉsarya risengerero rya Yɨɨsu, aarɨ arasikɨra nyumba yɨmwɨ yɨmwɨ, arabhagwata abhiisirirya, abhakari na abhasubhɨ, na kʉbharekera mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abhiisirirya bharya bhaanyaragɨɨnɨ, ɨnʉ hʉʉsi bhaagiirɨ, bhaarɨ bhararwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Firipʉ akaja kʉrʉbhɨri rʉmwɨ rwaho rwa Samaariya, akatanga kʉbharaganʼya abhaatʉ bhi iyo amangʼana ga Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abhaatʉ bhaaru hanʉ bhaamwitɨgɨɨrɨɨrɨ na korora ibhyɨrɨkɨnʼyʉ bhɨnʉ aarɨ arakora, bhakamwitegeerera bhwaheene kʉganʉ aarɨ aragamba. ");
INSERT INTO ikz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Aarɨ araruusha amasambwa kurwa kʉbhaatʉ na bhaarɨ bharakuura kwiraka ikʉrʉ, aarɨ arahorya amagata na bhanʉ bhakuurɨ ibhiimʉ. ");
INSERT INTO ikz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Abhaatʉ bha kʉrʉbhɨri ruyo bhakazomerwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kʉrʉbhɨri rʉmwɨ rwa Samaariya ruyo, aareho ʉmʉrʉgi wʉmwɨ, iriina ryazɨ Simʉʉni. Kwibhaga irɨɨhu, Simʉʉni aarɨ araruguurya abhaatʉ bha kʉrʉbhɨri ruyo, ko kokora ɨbhɨrʉgʉʉrʉ, kwiheema kʉbha ewe nɨ‑mʉʉtʉ wʉ ʉbhʉnaja bhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abhaatʉ bhʉʉsi, abhasuuhu na abhakʉrʉ, bhaarɨ bharamwitegeerera bhwaheene bhʉkʉngʼu, bhakabhuga, “Wʉnʉ newe ʉbhʉnaja bhwa Mungu, bhʉnʉ bhukubhirikirwa Ʉbhʉnaja Ʉbhʉkʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Abhaatʉ bhayo bhakangʼeha kumwitegeerera, kʉ kʉbha akabharuguurya kwibhaga irɨɨhu kʉbhʉrʉgi bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nawe hanʉ Firipʉ aabharwaziirɨ Ɨngʼana Ɨnzʉmu igʉrʉ wʉ ʉbhʉtɨmi bhwa Mungu ni iriina rya Yɨɨsu Kiriisitʉ, abhaatʉ bhakiisirirya amangʼana gaazɨ, abhasubhɨ na abhakari bhakabhatiizwa. ");
INSERT INTO ikz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simʉʉni wʉʉsi akiisirirya akabhatiizwa, akahirana na Firipʉ ahagero hʉʉsi. Hanʉ aarʉʉzɨ ibhyɨrɨkɨnʼyʉ nɨ ɨbhɨsɨgʉ ɨbhɨkʉrʉ bhɨnʉ Firipʉ aarɨ arakora, akarʉgʉʉra. ");
INSERT INTO ikz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hanʉ abhatumwa bhiigwirɨ kʉbha abhaatʉ bha Samaariya bhiisiriiryɨ ɨngʼana ya Mungu, bhakatʉma Peetero na Yoohana bhajɨyu. ");
INSERT INTO ikz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hanʉ bhaahikirɨ, bhakabhasabhɨra abhaatʉ bhayo korereke bhabhone Ekoro Ɨndɨndu, ");
INSERT INTO ikz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kʉ kʉbha atareeho nʉʉrʉ wʉmwɨ gatɨ waabhʉ wʉnʉ aarɨ ikiirwɨ Ekoro Ɨndɨndu. Bhaarɨ bhabhatiizirwɨ kuriina ryʉ Ʉmʉkʉrʉ Yɨɨsu iryene. ");
INSERT INTO ikz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Neho Peetero na Yoohana bhakatʉʉra amabhoko gaabhʉ kubhiisirirya bhayo, bhakasʉngʼaana Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hanʉ Simʉʉni aarʉʉzɨ kʉbha abhaatʉ bharasʉngʼaana Ekoro Ɨndɨndu, ku kutuurirwa amabhoko ga abhatumwa, akeenda koha Peetero na Yoohana zimpirya, arabhabhʉʉrɨra, ");
INSERT INTO ikz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mongʼe na niinyɨ ʉbhʉnaja, korereke ʉmʉʉtʉ wʉwʉʉsi wʉnʉ nɨraamoteere amabhoko gaanɨ, asʉngʼaanɨ Ekoro Ɨndɨndu.” ");
INSERT INTO ikz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nawe Peetero akamʉgarukirya, “Urikɨ awɨ na zimpirya zaazʉ, kʉ kʉbha ʉrakina, ʉmʉbhanʉ gwa Mungu gʉrabhoneka ku kugurwa na zimpirya! ");
INSERT INTO ikz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Awɨ ʉtaana chʉchʉsi komeremo ja Mungu gɨnʉ, kʉ kʉbha umwʉyʉ gwazʉ gʉtarɨ mʉgʉrʉrʉku mʉmɨɨsʉ ga Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Utigɨ ʉbhʉbhɨ bhwazʉ bhʉnʉ na ʉsabhɨ Ʉmʉkʉrʉ, hamwɨ aratʉra kokobheerera amiisɨɨgi gaazʉ amabhɨ ga mokoro yaazʉ. ");
INSERT INTO ikz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nɨrakorora awɨ wiizuriibhwɨ ʉbhʉrʉrʉ nchɨ ɨndʉrʉ, nʉ ʉbhʉbhɨ bhwazʉ bhʉkʉbhʉhirɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simʉʉni akagarukirya, “Imwɨ mʉnsabhɨrɨ kʉMʉkʉrʉ korereke gatɨ wa gayo mʉgambirɨ, rɨtaaza kombona ingʼana!” ");
INSERT INTO ikz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bhakamara kobheerekeererya na kubhiija abhaatʉ bha kʉrʉbhɨri ruyo ɨngʼana yʉ Ʉmʉkʉrʉ, bhakatanga orogendo rwabhʉ kʉgarʉka Yɨrusarɨɨmu. Hanʉ bhaarɨ bharagarʉka, bhakahɨta zɨmbɨri nzaru za Abhasamaariya, bharabharwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu. ");
INSERT INTO ikz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Rusikʉ rʉmwɨ, maraika wʉ Ʉmʉkʉrʉ akabhʉʉrɨra Firipʉ, “Bhʉʉka ujɨ ʉrʉbhaara rwa maamu, uhirɨ ɨnzɨra yɨnʉ ɨkʉhɨta kʉkɨbhara, yɨnʉ ikurwa Yɨrusarɨɨmu na kuhiringita kuhika Gaaza.” ");
INSERT INTO ikz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Firipʉ akaja, mʉnzɨra akarumana nʉ ʉmʉʉtʉ wʉmwɨ ʉmʉkʉrʉ wi icharʉ cha Isiyʉpiya, muzigaru. Ʉmʉʉtʉ wuyo newe aarɨ nʉ ʉbhʉnaja igʉrʉ we ebhegero bhyʉsi bhya Kaandakɨ, marikiya wa Isiyʉpiya. Ʉmʉkʉrʉ wʉnʉ aarɨ agiirɨ Yɨrusarɨɨmu kosengera Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Hanʉ aarɨ akʉgarʉka yɨɨka, aarɨ ikɨɨrɨ mʉtʉrʉʉri yaazɨ yu ukurutwa na zɨfaraasi, arasoma ɨkɨtabhʉ chʉ ʉmʉrʉʉtɨrɨri Isaaya. ");
INSERT INTO ikz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ekoro Ɨndɨndu ya Mungu ɨkabhʉʉrɨra Firipʉ, “Nuujɨ bhwangʉ, ʉbhɨ haguhɨ nɨ ɨtʉrʉʉri yirya.” ");
INSERT INTO ikz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Neho Firipʉ akayiryarɨra. Hanʉ ayihikiirɨ, akamwigwa ʉmʉkʉrʉ wuyo arasoma mʉkɨtabhʉ chʉ ʉmʉrʉʉtɨrɨri Isaaya, akamubhuurya, “Amangʼana gayo okosoma, ʉragoobhoora?” ");
INSERT INTO ikz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Akagarukirya, “Nɨratʉrabhwɨ kogoobhoora, arɨɨbhɨ atareeho ʉmʉʉtʉ wo okonyerekeererya?” Akiisasaama Firipʉ atiirɨ mʉtʉrʉʉri, iikarɨ hamwɨmwɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Amaandɨkʉ ganʉ ʉmʉkʉrʉ wuyo aarɨ akosoma, nɨ‑ganʉ, “Akakangatibhwa nchɨ ɨngʼʉndu yɨnʉ ikuja kusinzwa. Akakira chɨmbu ɨkɨngʼʉndu kɨhaakira, ribhaga ryu ukutinwa amabhuri, atahurukiryɨ iraka. ");
INSERT INTO ikz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Akasukibhwa na abhaatʉ nu ukwimwa eheene yaazɨ ribhaga ryu ukutinirwa. Atareeho wʉnʉ araatʉrɨ kʉgambɨra amangʼana gu urwibhʉrʉ rwazɨ, kʉ kʉbha akiitwa kʉʉsɨ yɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ʉmʉkʉrʉ wuyo akabhuurya Firipʉ, “Nɨrasabha ʉmbʉʉrɨrɨ, amangʼana gʉ ʉmʉrʉʉtɨrɨri ganʉ garagambɨra igʉrʉ wa wɨɨwɨ? Igʉrʉ waazɨ umwene, hamwɨ ni‑igʉrʉ wʉ ʉmʉʉtʉ wʉndɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Firipʉ, kwa kʉtanga na amangʼana gayo, akamurwazɨra Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hanʉ bhaarɨ bharaja, bhakahika ahagero hanʉ hana amanzi. Ʉmʉkʉrʉ wuyo akabhʉʉrɨra Firipʉ, “Rora hanʉ amanzi gareho! Kɨgʉrʉkɨ kekondecha kʉbhatiizwa?”  ");
INSERT INTO ikz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Firipʉ akamʉbhʉʉrɨra, “Ʉraamwisiriryɨ Yɨɨsu Kiriisitʉ kumwʉyʉ gwazʉ gwʉsi, ʉratʉra kʉbhatiizwa.” Akamʉbhʉʉrɨra, “Niriisirirya kʉbha Yɨɨsu Kiriisitʉ newe Umwana wa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Akaswaja omonderebha imiiriryɨ ɨtʉrʉʉri, bhʉʉsi bhabhɨrɨ bhakiika kurwa mʉtʉrʉʉri, bhakasikɨra mʉmanzi gayo, Firipʉ akamʉbhatiiza. ");
INSERT INTO ikz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hanʉ bhaahurukirɨ kurwa mʉmanzi, Ekoro Ɨndɨndu yʉ Ʉmʉkʉrʉ ɨkagega Firipʉ. Ʉmʉkʉrʉ wuyo atamʉrʉʉzɨ naatu, akaja azʉmɨɨrwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nawe Firipʉ akiibhona arɨ kʉrʉbhɨri rwa Azʉʉtʉ, akatanga orogendo rwu ukuja kʉrʉbhɨri rwa Kaisaariya, akahɨta kʉzɨmbɨri ararwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ribhaga riyo, Sauri aarɨ arangʼeha na amakango gaazɨ gu ukwita abhɨɨga bhʉ Ʉmʉkʉrʉ Yɨɨsu. Akaja kwa kuhaani ʉmʉkʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akamʉsabha amohe zɨnyarʉbha zu ukumwerekenʼya, ajɨ nazʉ mʉmarwazɨrʉ kʉrʉbhɨri rwa Damɨɨsikʉ, korereke areebhone abhahɨmba bhɨ ɨnzɨra ya Yɨɨsu, bhabhɨ abhasubhɨ hamwɨ abhakari, abhagwatɨ na kʉbhareeta Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Neho Sauri akatanga orogendo rwazɨ rwu ukuja Damɨɨsikʉ. Hanʉ aarɨ ariisemera ʉrʉbhɨri ruyo, ubhwɨrʉ bhʉkabhanza kurwa mwisaarʉ, bhʉkamʉmʉrɨka mbaara zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akagwa haasɨ, akiigwa riraka rɨramʉbhʉʉrɨra, “Sauri! Sauri! Ndora ʉranyaacha?” ");
INSERT INTO ikz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauri akabhuurya, “Ʉmʉkʉrʉ, awɨ nɨ‑wɨɨwɨ?” Akamʉgarukirya, “Inyɨ nɨ‑Yɨɨsu, wʉnʉ ʉkʉnyaacha. ");
INSERT INTO ikz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nawe imɨɨrɨra! Ujɨ usikɨrɨ mʉrʉbhɨri, muyo ʉrabhuurirwa ganʉ ukwenderwa okore.” ");
INSERT INTO ikz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abhaatʉ bhanʉ bhaarɨ na Sauri bhakiimɨɨrɨra na kukira kiri, bhakabha bhararʉgʉʉra, kʉ kʉbha ebho bhʉʉsi bhiigwirɨ riraka riyo, nawe bhatarʉʉzɨ mʉʉtʉ wʉwʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauri akabhʉʉka kurwa haasɨ, nawe hanʉ aagɨmirɨ kʉramucha amɨɨsʉ, ataarʉʉzɨ kegero. Abhakɨndichazɨ bhayo bhakamugwata okobhoko na kʉmʉkangatya kuhika Damɨɨsikʉ. ");
INSERT INTO ikz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Akiikara zisikʉ isatʉ mʉhʉku, ribhaga riyo ataariirɨ naabha kunywa chʉchʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damɨɨsikʉ iyo, aareho umwɨga wʉmwɨ wa Yɨɨsu, iriina ryazɨ Ananiya. Ʉmʉkʉrʉ akamʉbhɨrɨkɨra Ananiya kʉbhʉrʉri. Akabhɨrɨkɨra, “Ananiya!” Ananiya akamʉgarukirya, “Inyɨ nɨrɨ hanʉ, Ʉmʉkʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ʉmʉkʉrʉ akamʉbhʉʉrɨra, “Bhʉʉka ujɨ kʉnzɨra yɨnʉ ikubhirikirwa Ɨngʉrʉrʉku, omohyɨ inyumba ya Yuuda hanʉ ɨrɨ. Ubhuuririryɨ muyo ʉmʉʉtʉ wʉnʉ aruuriirɨ kʉrʉbhɨri rwa Tarisʉ, iriina ryazɨ Sauri. Nɨrakʉbhʉʉrɨrabhu kʉ kʉbha nangwɨnʉ Sauri arasabha Mungu, ");
INSERT INTO ikz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wʉʉsi arʉʉzɨ ʉmʉʉtʉ wʉmwɨ iriina ryazɨ Ananiya, arasikɨra na kʉmʉtʉʉrɨra amabhoko, korereke atʉrɨ korora naatu.” ");
INSERT INTO ikz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nawe Ananiya akamʉgarukirya, “Ʉmʉkʉrʉ, abhaatʉ bhaaru bhambuuriirɨ chɨmbu Sauri wuyo aabhakʉrɨɨrɨ amabhɨ abharɨndu bhaazʉ Yɨrusarɨɨmu! ");
INSERT INTO ikz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na nangʉ arɨ hanʉ, anʉ ʉbhʉnaja kurwa kʉbhakʉrʉ bha abhakuhaani, abhagwatɨ bhʉʉsi bhanʉ bhakʉsabha kuriina ryazʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nawe Ʉmʉkʉrʉ akamʉbhʉʉrɨra Ananiya, “Nuujɨ! Ʉmʉʉtʉ wuyo nɨmʉrʉbhwɨrɨ abhɨ omohocha waanɨ, korereke araganʼyɨ iriina ryanɨ kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi, kʉbhatɨmi bhaabhʉ, na kuBhiiziraɨri. ");
INSERT INTO ikz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Inyimwene nɨramwerecha chɨmbu araanyaakɨ bhʉkʉngʼu, igʉrʉ wi iriina ryanɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya akaja, akasikɨra munyumba yiyo, akamʉtʉʉrɨra amabhoko, akabhuga, “Umuhiiri waanɨ Sauri, Ʉmʉkʉrʉ Yɨɨsu wʉnʉ aakuhwarukiirɨ kʉnzɨra, hanʉ waarɨ ʉraaza ɨnʉ, antumirɨ kwa naawɨ, korereke ʉtʉrɨ korora kwikɨ na wiizuribhwɨ Ekoro Ɨndɨndu.” ");
INSERT INTO ikz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hayohayo ebhegero ncha amagʉnzʉ bhɨkatorobhoka kurwa mʉmɨɨsʉ ga Sauri, akarora naatu, neho akiimɨɨrɨra, akabhatiizwa. ");
INSERT INTO ikz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Akʉmara akarya ibhyakurya, akabhona amanaga. Kuzisikʉ zendebhe, Sauri akiikara hamwɨmwɨ na abhɨɨga bha Yɨɨsu Damɨɨsikʉ iyo. ");
INSERT INTO ikz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Hayohayo akatanga kuja mʉmarwazɨrʉ, akabha arabheerekeererya kʉbha, Yɨɨsu ni‑Mwana wa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abhaatʉ bhʉʉsi bhanʉ bhiitɨgɨɨrɨɨrɨ Sauri, bhakarʉgʉʉra bhʉkʉngʼu, bhakiibhuurya, “Ʉmʉʉtʉ wʉnʉ tɨ newe aarɨ aranyaacha na kwita abhaatʉ bha Yɨɨsu Yɨrusarɨɨmu iyo? Ɨtarɨ kʉbha iizirɨ hanʉ abhagwatɨ korereke abhahirɨ kʉbhakʉrʉ bha abhakuhaani?” ");
INSERT INTO ikz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nawe Sauri akakaja kobhona ʉbhʉnaja na kʉbharuguurya Abhayaahudi bhanʉ bhaarɨ bhariikara Damɨɨsikʉ, kʉbhakandikija kʉ kʉbhabhʉʉrɨra Amaandɨkʉ Amarɨndu kʉbha, Yɨɨsu newe Kiriisitʉ, na bhataaturirɨ kʉmʉgarukirya. ");
INSERT INTO ikz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Zisikʉ hɨru zɨkahɨta, Abhayaahudi bhakaseemya kumwita Sauri. ");
INSERT INTO ikz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nawe Sauri akabhuurirwa igʉrʉ we eseemyo yiyo. Abhayaahudi bhakabha bhararata mukisikʉ chʉ ʉrʉbhɨri ruyo ubhutikʉ nu umwise, korereke araahʉrʉkɨ bhamwitɨ. ");
INSERT INTO ikz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ubhutikʉ bhʉmwɨ, abhɨɨga bhaazɨ bhakamogega bhakamʉtʉʉra murwero ʉrʉkʉrʉ na kumuhiringitya kʉhɨtɨra mwibhanga ryi inyiki yʉ ʉrʉbhɨri. ");
INSERT INTO ikz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Neho Sauri akaja Yɨrusarɨɨmu. Hanʉ aahikirɨ iyo, akabha aragema kʉbha hamwɨmwɨ na abhɨɨga bha Yɨɨsu, nawe bhʉʉsi bhaarɨ bharamwʉbhaha, kʉ kʉbha bhataarɨ bhariisirirya kʉbha ewe wʉʉsi abhɨɨrɨ umwɨga wʉ Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nawe Bharinaabha akamogega, akamuhira kʉbhatumwa bha Yɨɨsu. Akabhabhʉʉrɨra chɨmbu Sauri aarʉʉzɨ Ʉmʉkʉrʉ mʉnzɨra, chɨmbu Ʉmʉkʉrʉ aagambɨɨnɨ newe na chɨmbu Sauri aabhiijiryɨ abhaatʉ bhi iyo kuriina rya Yɨɨsu kwa bhʉkararu. ");
INSERT INTO ikz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Mmbe Sauri wʉʉsi akabha hamwɨmwɨ nabhʉ Yɨrusarɨɨmu, aarɨ arabhiija abhaatʉ igʉrʉ wʉ Ʉmʉkʉrʉ Yɨɨsu kwa bhʉkararu. ");
INSERT INTO ikz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aarɨ aragamba na kʉhakaana na Abhayaahudi bhanʉ bhaarɨ bharagamba Ikigiriki, nawe bhayo bhakagema kumwita. ");
INSERT INTO ikz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hanʉ abhiisirirya abhandɨ bhaamɨnyirɨ ringʼana riyo, bhakamohereekerera bhakamuhicha kʉrʉbhɨri rwa Kaisaariya, bhakamʉtʉma ajɨ Tarisʉ. ");
INSERT INTO ikz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Risengerero rɨkabha no omorembe mbaara zʉʉsi za Yudeya, Gariraaya, Samaariya na mbaara zʉʉsi bhakangʼeha kʉnaga na kʉhaabhwa zinguru ne Ekoro Ɨndɨndu. Abhiisirirya bhakabha bharamʉsʉʉka na kwitegeerera Ʉmʉkʉrʉ Yɨɨsu, endengo yaabhʉ ɨkangʼeha kwaruha. ");
INSERT INTO ikz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hanʉ Peetero aarɨ ariiruguuraruguura mbaara zʉʉsi, korogendo rwazɨ, akahika kʉrʉbhɨri rwa Riida kʉbhataarɨra abharɨndu bha Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kʉrʉbhɨri ruyo, akarumana nʉ ʉmʉʉtʉ, iriina ryazɨ Aineya, aarɨ akuurɨ ibhiimʉ, ahindiirɨ kʉbhʉrɨrɨ kwibhaga ryi imyaka ɨnaanɨ. ");
INSERT INTO ikz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peetero akamʉbhʉʉrɨra, “Aineya, Yɨɨsu Kiriisitʉ arakohorya, bhʉʉka waarɨ ɨkɨragʉ chazʉ.” Hayohayo Aineya akiimɨɨrɨra! ");
INSERT INTO ikz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hanʉ abhaatʉ bhʉʉsi bhanʉ bhaarɨ bhariikara Riida na Sharʉʉni, bhaarʉʉzɨ Aineya aragenda, bhakiisirirya Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kʉrʉbhɨri rwa Yoopa, aarɨmu umwɨga wʉmwɨ wʉ Ʉmʉkʉrʉ Yɨɨsu, iriina ryazɨ Tabhiiza, kʉkɨgambʉ chi Ikigiriki, Dʉrikaasi, enzobhooro yaku ɨngabhi. Aarɨ arasakirya abhahabhɨ na kokora amangʼana amazʉmu kemerano. ");
INSERT INTO ikz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Zisikʉ ziyo Tabhiiza akarwara, ɨtɨnɨrʉ akakwa. Abhaatʉ bhakooja ʉmʉbhɨrɨ gwazɨ, bhakamuhindirya ɨgatɨ mogorofa. ");
INSERT INTO ikz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kʉ kʉbha ʉrʉbhɨri rwabhʉ rwa Yoopa rwarɨ haguhɨ nʉ ʉrʉbhɨri rwa Ruuda, hanʉ abhɨɨga bhiigwirɨ kʉbha Peetero aarɨ Riida, bhakatʉma abhaatʉ bhabhɨrɨ kwa Peetero, kʉmʉsabha na kubhuga, “Nauzɨ ɨwɨɨtʉ nangwɨnʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peetero akabhʉʉka, akahirana hamwɨmwɨ nabhʉ. Hanʉ bhaahikirɨ Yoopa, bhakamuhira ɨgatɨ igʉrʉ mogorofa. Abhakwirwa bhaaru bhakamwiruguura bhakabha haguhɨ neewe, bhararɨra na kumwerecha zɨshadi na zengebho ɨzɨndɨ zɨnʉ Dʉrikaasi aarɨ kubhatumɨra ribhaga ryʉ ʉbhʉhʉru bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peetero akabhahurucha abhaatʉ bhʉʉsi igʉtʉ, akahigama, akasabha Mungu. Akʉmara akeerekera ɨkɨtʉndʉ, akabhuga, “Tabhiiza imɨɨrɨra!” Tabhiiza akaramucha, hanʉ aamʉrʉʉzɨ Peetero, akagororoka akiikara. ");
INSERT INTO ikz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peetero akamugwata okobhoko, akamwimiirirya, akabhɨrɨkɨra abhakwirwa bharya na abharɨndu bha Mungu abhandɨ, akamʉtʉʉra mʉbhʉtangɨ bhwabhʉ, mʉhʉru. ");
INSERT INTO ikz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Amangʼana gɨ ɨkɨsɨgʉ kiyo gakanyaragana bhʉkʉngʼu kʉrʉbhɨri rwʉsi rwa Yoopa, abhaatʉ bhaaru bhakiisirirya Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peetero akiikara sikʉ nzaru Yoopa kʉmʉkʉri wa amaseero, iriina ryazɨ Simʉʉni. ");
INSERT INTO ikz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kʉrʉbhɨri rwa Kaisaariya, aarɨmu ʉmʉkʉrʉ wa riribhita rya abhasirikarɨ, iriina ryazɨ Kʉrʉnɨriyʉ. Aarɨ imiiririirɨ riribhita rya abhasirikarɨ igana rɨmwɨ, kurwa mwiribhita rikʉrʉ rya abhasirikarɨ rɨnʉ rikubhirikirwa Riribhita ryi Ikiitaariya. ");
INSERT INTO ikz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aarɨ moronge na arasengera Mungu, hamwɨmwɨ na abhaatʉ bhʉʉsi bha yɨɨka waazɨ, aarɨ arasabha Mungu ibhaga ryʉsi. Hamwɨmwɨ na gayo, aarɨ arasakirya abhahabhɨ bhɨ Ɨkɨyaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rusikʉ rʉmwɨ zɨɨsa kenda umwise, Kʉrʉnɨriyʉ akarora ʉbhʉrʉri. Kʉbhʉrʉri bhuyo, akarora habhwɨrʉ maraika wa Mungu aramuhwarʉkɨra na kʉmʉbhɨrɨkɨra, “Kʉrʉnɨriyʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kʉrʉnɨriyʉ akarora maraika wuyo akʉʉbhaha, akamubhuurya, “Kɨgʉrʉkɨ, ʉmʉkʉrʉ waanɨ?” Maraika wuyo akamʉbhʉʉrɨra, “Mungu igwirɨ amasabhi gaazʉ ni ibhimweso bhyazʉ, bhyʉsi bhihikirɨ kwa Mungu na bhɨrabha ubhuhiiti bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nangʉ tʉma abhaatʉ kʉrʉbhɨri rwa Yoopa, bhabhɨrɨkɨrɨ ʉmʉʉtʉ wʉmwɨ, iriina ryazɨ Simʉʉni, iriina ɨrɨndɨ, arabhirikirwa Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ariikara wa Simʉʉni yɨɨka, ʉmʉkʉri wa amaseero, inyumba yaazɨ ɨrɨ haguhɨ nɨ ɨnyanza.” ");
INSERT INTO ikz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hanʉ maraika aamarirɨ kʉgambana na Kʉrʉnɨriyʉ gayo, akarweho. Kʉrʉnɨriyʉ akabhɨrɨkɨra abhahocha bhabhɨrɨ bha yɨɨka, nu umusirikarɨ wʉmwɨ, wʉnʉ aarɨ ʉmʉsakirya, wʉʉsi aarɨ ariigwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kʉrʉnɨriyʉ akabhabhʉʉrɨra gʉʉsi ganʉ gakʉriibhwɨ, akʉmara akabhatʉma bhajɨ Yoopa. ");
INSERT INTO ikz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Urusikʉ rwa kabhɨrɨ ɨsa isaasabha umwise, hanʉ abhaatʉ bhatatʉ bhayo bhaarɨ haguhɨ nʉ ʉrʉbhɨri rwa Yoopa, Peetero akatiira kʉkɨsara chi inyumba kosengera Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ribhaga riyo akiigwa ɨnzara, akiigomba kurya. Ribhaga rɨnʉ ibhyakurya bhyarɨ bhɨraterekwa, akarora ʉbhʉrʉri. ");
INSERT INTO ikz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kʉbhʉrʉri bhuyo, akarora risaarʉ ryarɨ ryigukirɨ, ne ekegero nchu umwenda ʉmʉkʉrʉ gugwatirwɨ zesonga zaku inyɨ, zɨkahiringitibhwa haasɨ. ");
INSERT INTO ikz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mumwenda guyo, bhyarɨ bhirimu ibhityɨnyi bhya teemwa zʉʉsi, ibhityɨnyi bhya amagʉrʉ ane, ibhityɨnyi bhɨnʉ bhekogendera zɨnda ni ibhinyunyi bhyi igʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Akʉmara Peetero akiigwa riraka, rɨramʉbhʉʉrɨra, “Peetero, imɨɨrɨra, ʉsɨnzɨ, uryɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peetero akamʉgarukirya, “Zɨyi, Ʉmʉkʉrʉ! Nɨkɨɨrɨ kurya ibhyakurya bhyʉbhyʉsi bhyi imigirʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Peetero akiigwa riraka riyo rwa kabhɨrɨ, “Ʉtabhɨbhɨrɨkɨra kʉbha bhya kobhengya, ebhegero bhɨnʉ Mungu abhɨngukiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ringʼana riyo rɨkakorwa manga atatʉ, neho umwenda gurya gʉkagarukibhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hanʉ Peetero aarɨ ariibhuurya igʉrʉ we enzobhooro yʉ ʉbhʉrʉri bhuyo, abhaatʉ bhatatʉ bhanʉ bhaatumirwɨ na Kʉrʉnɨriyʉ bhakahika kunyumba ya Simʉʉni ʉmʉkʉri wa amaseero, bhakiimɨɨrɨra kukisikʉ. ");
INSERT INTO ikz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhakabhɨrɨkɨra na kubhuurya, arɨɨbhɨ kʉna mugini wʉnʉ akubhirikirwa Simʉʉni, iriina ɨrɨndɨ Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Hanʉ Peetero aarɨ akɨɨrɨ arakaja kwiseega igʉrʉ wʉ ʉbhʉrʉri bhuyo, Ekoro Ɨndɨndu ɨkamʉbhʉʉrɨra, “Itegeerera! Bharɨ hanʉ abhaatʉ bhatatʉ bharakomohya. ");
INSERT INTO ikz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hiringita uhiranɨ nabhʉ, ʉtabha na rʉhaho, kʉ kʉbha inyɨ niinyɨ nɨbhatumirɨ kwa naawɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peetero akiika haasɨ, hanʉ aabhahikiirɨ, akabhʉʉrɨra abhaatʉ bhayo, “Inyɨ niinyɨ mokomohya. Nɨ kwakɨ mwizirɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhakamʉgarukirya, “Tutumirwɨ nʉ ʉmʉkʉrʉ wa abhasirikarɨ, iriina ryazɨ Kʉrʉnɨriyʉ. Ewe nɨ‑mʉʉtʉ we eheene na arasengera Mungu, wʉʉsi arakumibhwa na Abhayaahudi bhʉʉsi kʉbha nɨ‑mʉʉtʉ mʉzʉmu. Akabhuurirwa na maraika ʉmʉrɨndu, akuginihyɨ ɨwaazɨ korereke iitegeerere amangʼana ganʉ ʉraamʉbhʉʉrɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Akʉmara Peetero akabhasikirya munyumba, bhabhɨ abhagini bhaazɨ. Tabhʉʉri waho, Peetero na abhaatʉ bhatatʉ bharya bhakatanga orogendo rwabhʉ, hamwɨmwɨ na abhiisirirya bhorebhe kurwa Yoopa. ");
INSERT INTO ikz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Urusikʉ rwa kabhɨrɨ, bhakahika kʉrʉbhɨri rwa Kaisaariya, bhakaja wa Kʉrʉnɨriyʉ yɨɨka. Ribhaga riyo Kʉrʉnɨriyʉ aarɨ abhiringirɨ abhahiiri bhaazɨ, hamwɨmwɨ na abhasaani bhaazɨ, bharamʉrɨnda Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hanʉ Peetero aarɨ arasikɨra, Kʉrʉnɨriyʉ akamʉsʉngʼaana, akahigama mʉbhʉtangɨ bhwazɨ na kwihiinya haasɨ korereke amosengere. ");
INSERT INTO ikz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nawe Peetero akamogororocha, akamʉbhʉʉrɨra, “Imɨɨrɨra! Inyʉʉsi nɨ‑mʉʉtʉ ncha naawɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Akʉmara Peetero na Kʉrʉnɨriyʉ bhakasikɨra munyumba, bharagambana, bhakabhona abhaatʉ bhaaru bhiibhiringirɨ muyo. ");
INSERT INTO ikz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peetero akabhabhʉʉrɨra, “Imwɨ mwɨzɨ bhwaheene kʉbha, imigirʉ jɨtʉ Abhayaahudi gɨratorecha kwisanja na abhaatʉ bha mubhyarʉ ɨbhɨndɨ nʉʉrʉ kʉbhataarɨra. Nawe Mungu andɨkiryɨ kʉbha, nitiiseega kʉbha, ʉmʉʉtʉ wʉwʉʉsi nɨ‑wa migirʉ na atakwenderwa. ");
INSERT INTO ikz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Riyo neryo rigiriryɨ niizirɨ, hanʉ mumbirikiirɨ nɨtatitiikɨɨnɨ. Mmbe! Nɨrabhabhuurya ni‑ngʼanakɨ rɨnʉ mumbirikiriirɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kʉrʉnɨriyʉ akamʉbhʉʉrɨra, “Zisikʉ isatʉ zɨnʉ zihitirɨ zɨɨsa ncha zɨnʉzɨnʉ zɨɨsa kenda umwise, naarɨ munyumba nɨrasabha Mungu. Rogendo rʉmwɨ, nɨkarora ʉmʉʉtʉ imiiriirɨ mʉbhʉtangɨ bhwanɨ, ibhʉhirɨ zengebho zɨnʉ zɨkʉbharya. ");
INSERT INTO ikz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akambʉʉrɨra, ‘Kʉrʉnɨriyʉ, amasabhi gaazʉ ni ibhimweso bhyazʉ bhyʉsi bhihikirɨ kwa Mungu na bhɨrabha Ubhuhiiti bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nangʉ tʉma abhaatʉ bhajɨ kʉrʉbhɨri rwa Yoopa, bhabhɨrɨkɨrɨ Simʉʉni wʉnʉ akubhirikirwa Peetero. Ariikara wa Simʉʉni ʉmʉkʉri wa amaseero, wʉnʉ inyumba yaazɨ ɨrɨ haguhɨ nɨ ɨnyanza.’ ");
INSERT INTO ikz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nɨkatʉma abhaatʉ bhaazɨ bhakʉbhɨrɨkɨrɨ, ʉkʉrirɨ bhwaheene kuuza. Nangʉ itwʉsi tʉrɨ hanʉ mʉbhʉtangɨ bhwa Mungu, korereke twitegeerere ɨngʼana yʉʉsi yɨnʉ Ʉmʉkʉrʉ akutumirɨ ʉtʉbhʉʉrɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Neho Peetero akatanga kʉgamba, “Nangʉ nʉbhʉʉrirɨ kʉbha nɨ‑maheene, Mungu ataana kɨmbʉrʉʉri kʉbhaatʉ! ");
INSERT INTO ikz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nawe abhaatʉ bhi ibhyarʉ bhyʉsi bhanʉ bhakomosengera na kokora eheene mʉbhʉtangɨ bhwazɨ, bhahiisiriribhwa neewe. ");
INSERT INTO ikz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Imubheene mwɨzɨ amangʼana ganʉ Mungu abhahiriirɨ Abhiiziraɨri. Akabharwazɨra Ɨngʼana Ɨnzʉmu korereke bhabhɨ no omorembe na Mungu kʉnzɨra ya Yɨɨsu Kiriisitʉ. Yɨɨsu wuyo newe Ʉmʉkʉrʉ wa abhaatʉ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwɨzɨ amangʼana ganʉ gakʉriibhwɨ kʉʉsɨ yʉʉsi ya Yudeya, kwɨma Gariraaya hanʉ Yoohana aamarirɨ kurwazɨra abhaatʉ kʉbha bhabhatiizwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Naatu mwɨzɨ kʉbha, Mungu akarobhora Yɨɨsu wa Nazarɨɨti kwa komoha Ekoro Ɨndɨndu nʉ ʉbhʉnaja. Yɨɨsu akaja ɨnʉ ni irya, arakora amazʉmu na kohorya bhanʉ bhʉʉsi bhaarɨ bharanyaakibhwa na zinguru za Shɨtaani, kʉ kʉbha Mungu aarɨ hamwɨmwɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Itwɨ nɨ‑bhamɨnyɨɨkɨrɨri bha amangʼana gʉʉsi ganʉ Yɨɨsu aakʉrirɨ kʉʉsɨ ya Abhayaahudi na Yɨrusarɨɨmu. Abhaatʉ bhakamwita kʉ kʉmʉbhamba kʉmʉsarabha, ");
INSERT INTO ikz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nawe urusikʉ rwa katatʉ, Mungu akamuryʉra, akamwerekenʼya kʉbhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Atarʉrɨkɨɨnɨ kʉbhaatʉ bhʉʉsi, kuruushaku kʉbhanʉ Mungu aarɨ amarirɨ korobhora kʉbha abhamɨnyɨɨkɨrɨri. Abhamɨnyɨɨkɨrɨri bhayo ni‑twɨ, tʉkamorora, tʉkarya na kunywa hamwɨmwɨ neewe hanʉ aryukirɨ kurwa mʉbhaku. ");
INSERT INTO ikz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akatuswaja kurwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu, na komenyeekererya kʉbha, umwene newe arʉbhwɨrwɨ na Mungu, abhɨ ɨtɨnɨrʉ ya abhahʉru na abhaku. ");
INSERT INTO ikz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Igʉrʉ waazɨ, abharʉʉtɨrɨri bhʉʉsi bhakagamba kʉbha, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ ariimwisiriryɨ arabheererwa ʉbhʉbhɨ bhwazɨ kʉnzɨra yi iriina ryazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Hanʉ Peetero aarɨ aragamba amangʼana gayo, Ekoro Ɨndɨndu ɨkabhiikɨra bhʉʉsi bhanʉ bhaarɨ bharamwitegeerera. ");
INSERT INTO ikz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abhayaahudi abhiisirirya bhakaaza na Peetero, bhakarʉgʉʉra bhʉkʉngʼu, korora kʉbha Mungu abhiitiriirɨ abhaatʉ bhanʉ bhatarɨ Abhayaahudi Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bhakamenya kʉ kʉbha bhakiigwa abhaatʉ bhayo bharagamba kʉbhɨgambʉ bhyaru bhyaru, bharamukumya Mungu. Neho Peetero akabhuga, ");
INSERT INTO ikz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abhaatʉ bhayo bhabhwɨnɨ Ekoro Ɨndɨndu, chɨmbu itwɨ twabhwɨnɨ. Heene areho ʉmʉʉtʉ wʉnʉ akʉtʉra kʉbharecha abhaatʉ bhayo bhatabhatiizwa kwa amanzi?” ");
INSERT INTO ikz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Akʉmara Peetero akabhaswaja bhabhatiizwɨ kuriina rya Yɨɨsu Kiriisitʉ. Neho bhakasabha Peetero kwikara kwa sikʉ bhorebhe. ");
INSERT INTO ikz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abhatumwa bha Yɨɨsu na abhiisirirya abhandɨ bhanʉ bhaarɨ Yudeya, bhakiigwa kʉbha, abhaatʉ bhanʉ bhatarɨ Abhayaahudi, bhiisiriiryɨ ɨngʼana ya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hanʉ Peetero aagarukirɨ Yɨrusarɨɨmu, Abhayaahudi abhiisirirya bhakatanga kʉhakaana neewe, ");
INSERT INTO ikz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bharabhuga, “Awɨ ʉkasikɨra munyumba ya abhaatʉ bhanʉ bhatarɨ Abhayaahudi na kurya nabhʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Peetero akatanga kʉbhabhʉʉrɨra rɨmwɨrɨmwɨ chɨmbu gʉʉsi gaakʉrirwɨ, akabhuga, ");
INSERT INTO ikz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Rusikʉ rʉmwɨ naarɨ kʉrʉbhɨri rwa Yoopa. Hanʉ naarɨ nɨrasabha Mungu, nɨkarora ʉbhʉrʉri. Kʉbhʉrʉri bhuyo, nɨkarora ekegero nchu umwenda ʉmʉkʉrʉ gugwatirwɨ zesonga zʉʉsi inyɨ. Ekegero kiyo charɨ kiriikibhwa kurwa mwisaarʉ, kikiika haguhɨ na niinyɨ. ");
INSERT INTO ikz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Hanʉ nakɨrʉʉzɨ bhwaheene, nɨkarora ibhityɨnyi bhya teemwa zʉʉsi. Nɨkarora ibhityɨnyi bhya amagʉrʉ ane, ibhityɨnyi bhya mwitɨrɨgʉ, ibhityɨnyi bhɨnʉ bhekogendera zɨnda ni ibhinyunyi bhyi igʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Neho nikiigwa riraka, rirambʉʉrɨra kʉbha, ‘Peetero, imɨɨrɨra, ʉsɨnzɨ, uryɨ!’ ");
INSERT INTO ikz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nawe inyɨ nɨkabhuga, ‘Zɨyi, Ʉmʉkʉrʉ! Nɨkɨɨrɨ kʉtʉʉra ibhyakurya bhyʉbhyʉsi bhyi imigirʉ mumunywa gwanɨ!’ ");
INSERT INTO ikz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nawe nikiigwa naatu riraka riyo kurwa mwisaarʉ, rɨrambʉʉrɨra, ‘Ʉtabhɨbhɨrɨkɨra kʉbha bhya kobhengya, ebhegero bhɨnʉ Mungu abhɨngukiryɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ringʼana riyo rɨkakorwa manga atatʉ, mʉtɨnɨrʉ ebhegero bhiyo bhyʉsi bhɨkagarukibhwa mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ribhaga riryarirya, abhaatʉ bhatatʉ bhanʉ bhaatumirwɨ kwa niinyɨ kurwa Kaisaariya bhakahika mʉbhʉtangɨ bhwi inyumba yɨnʉ naarɨ niriikara. ");
INSERT INTO ikz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ekoro Ɨndɨndu ɨkambʉʉrɨra, nijɨ hamwɨmwɨ nabhʉ, nɨtabha na rʉhaho. Nɨkaja na abhakɨndichanɨ bhasaasabha. Tʉkasikɨra yɨɨka wa Kʉrʉnɨriyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ewe akatʉbhʉʉrɨra chɨmbu maraika aamuhwarukiirɨ yɨɨka waazɨ, akamʉbhʉʉrɨra, ‘Ʉbhatʉmɨ abhaatʉ bhajɨ Yoopa, bhamʉbhɨrɨkɨrɨ Simʉʉni wʉnʉ akubhirikirwa Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wuyo newe araakʉbhʉʉrɨrɨ amangʼana, kʉ kʉhɨtɨra amangʼana gayo, awɨ na abhaatʉ bha munyumba yaazʉ mʉrasabhurwa.’ ");
INSERT INTO ikz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Hanʉ natangirɨ kʉgamba, Ekoro Ɨndɨndu ɨkabhiikɨra, chɨmbu yaatwikiirɨ mʉbhʉtangɨ. ");
INSERT INTO ikz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Neho nɨkahiita ɨngʼana yɨnʉ Ʉmʉkʉrʉ Yɨɨsu aagambirɨ, kʉbha, ‘Yoohana akabhatiiza abhaatʉ kʉmanzi, nawe imwɨ mʉrabhatiizwa kwe Ekoro Ɨndɨndu.’ ");
INSERT INTO ikz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Arɨɨbhɨ Mungu abhahɨɨrɨ ʉbhʉnaja bhuryabhurya aatʉhɨɨrɨ itwɨ bhanʉ twamwisiriiryɨ Ʉmʉkʉrʉ Yɨɨsu Kiriisitʉ, nangʉ inyɨ nɨ‑wɨɨwɨ nɨnajɨ kwanga Mungu?” ");
INSERT INTO ikz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hanʉ Abhayaahudi bhayo bhiigwirɨ gayo, bhakatiga kʉhakaana neewe. Bhakakumya Mungu bhakubhuga, “Mungu abhahɨɨrɨ abhaatʉ bhanʉ bhatarɨ Abhayaahudi umweya gwu ukutiga ʉbhʉbhɨ bhwabhʉ, bhabhone ʉbhʉhʉru bhwa kemerano.” ");
INSERT INTO ikz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kʉrɨngʼaana nɨ ɨnyaakʉ yɨnʉ yaabhʉnɨkirɨ hanʉ Sitɨfaanʉ aakuurɨ, abhiisirirya bhakanyaragana, bhakaryarɨra mucharʉ cha Fʉinikɨ, Kipurʉ na kʉrʉbhɨri rwa Antiyʉkiya. Bhakatanga kwija ɨngʼana ya Mungu kʉBhayaahudi abheene. ");
INSERT INTO ikz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nawe abhandɨ bhanʉ bhaaruurɨ Kipurʉ na Kireene, hanʉ bhaahikirɨ Antiyʉkiya bhakatanga kurwaza Ɨngʼana Ɨnzʉmu yʉ Ʉmʉkʉrʉ Yɨɨsu, kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ʉbhʉnaja bhwʉ Ʉmʉkʉrʉ bhwarɨ hamwɨmwɨ nabhʉ, abhaatʉ bhaaru bhakiisirirya, bhakiichʉrɨra Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Hanʉ abhaatʉ bha risengerero rya Yɨrusarɨɨmu bhiigwirɨ amangʼana gayo, bhakatʉma Bharinaabha ajɨ Antiyʉkiya. ");
INSERT INTO ikz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hanʉ Bharinaabha aahikirɨ iyo, akarora chɨmbu Mungu abhahɨɨrɨ abhaatʉ bhayo ɨbhɨgʉngi, akazomerwa bhʉkʉngʼu, akabhakandikija bhakajɨ kʉmʉsʉʉka Ʉmʉkʉrʉ Yɨɨsu mumyʉyʉ jabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bharinaabha aarɨ umwerya koro, izwirɨ Ekoro Ɨndɨndu nu ubhwisirirya ʉbhʉkʉrʉ. Na abhaatʉ bhakaaruha kʉMʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Akʉmara Bharinaabha akaja kʉrʉbhɨri rwa Tarisʉ komohya Sauri. ");
INSERT INTO ikz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hanʉ amubhwɨnɨ, akamoreeta Antiyʉkiya. Bharinaabha na Sauri bhakiikara na risengerero rirya umwaka mugima, bhariija abhaatʉ bhaaru bhʉkʉngʼu. Antiyʉkiya hayo, neho abhɨɨga bha Yɨɨsu bhaatangirɨ kubhirikirwa Abhakiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kuzisikʉ ziyoziyo, abharʉʉtɨrɨri bhakahiringita kurwa Yɨrusarɨɨmu, bhakaaza Antiyʉkiya. ");
INSERT INTO ikz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wʉmwɨ waabhʉ, iriina ryazɨ Agabhʉ, akiimɨɨrɨra kwiribhita rya abhaatʉ, akahurucha ʉbhʉrʉʉti kʉbhʉnaja bhwe Ekoro Ɨndɨndu kʉbha, ɨnzara ɨhaari ɨraaza kʉnyaragana ɨɨsɨ yʉʉsi. Heene ɨnzara yiyo ɨkahʉrʉka ribhaga ryʉ ʉbhʉkʉrʉ bhwa Kiraudiyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kʉrɨngʼaana nʉ ʉbhʉrʉʉti bhuyo, abhɨɨga bhʉʉsibhu bha Antiyʉkiya, kʉrɨngʼaana nʉ ʉbhʉnaja bhwabhʉ, bhakeenda bhasakiryɨ abhiisirirya abhakɨndichabhʉ bhanʉ bhaarɨ bhariikara Yudeya. ");
INSERT INTO ikz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhakakorabhu, bhakaha Bharinaabha na Sauri ʉmʉbhanʉ gwabhʉ, korereke bhahirɨ kubhiimiiririri bha risengerero rya Yudeya. ");
INSERT INTO ikz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kuzisikʉ ziyo, ʉmʉtɨmi Heroode Agiripa akatanga kʉbhanyaacha abhiisirirya obhorebhe bha risengerero rya Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akaswaja Yaakobho umuhiiri waazɨ Yoohana, iitwɨ kwɨ ɨpanga. ");
INSERT INTO ikz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hanʉ aarʉʉzɨ kʉbha ɨngʼana yiyo ɨbhazʉmɨɨrɨ Abhayaahudi, akaswaja Peetero wʉʉsi agwatwɨ. Gayo gakakorebhwa ribhaga ryi isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru. ");
INSERT INTO ikz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hanʉ bhaamarirɨ kugwata Peetero, Heroode akaswaja atuurwɨ mokebhoho. Akamʉtʉʉra mʉmabhoko ga amaribhita ane ga abhasirikarɨ bhane bhane, korereke bhamuriibhɨ bhwaheene. Akeenda kʉmʉtɨnɨra mʉbhʉtangɨ bhwa abhaatʉ, hanʉ ɨraahɨtɨ isigukuru yɨ Ɨpasaka. ");
INSERT INTO ikz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Peetero aarɨ abhʉhirwɨ mokebhoho, nawe risengerero ryarɨ rɨramʉsabhɨra bhʉkʉngʼu kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ubhutikʉ bhwu urusikʉ rʉnʉ Heroode aarɨ ɨndirɨ kuhurucha Peetero bhʉkahika. Ewe aarɨ ahindiirɨ gatɨgatɨ wa abhasirikarɨ bhabhɨrɨ, naatu aarɨ asibhikirwɨ ne emenyororo ɨbhɨrɨ. Abhasirikarɨ abhandɨ bhaarɨ igʉtʉ wi ikisikʉ bharariibha. ");
INSERT INTO ikz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Hayohayo, maraika wʉ Ʉmʉkʉrʉ akiimɨɨrɨra ʉrʉbhaara rʉnʉ Peetero aarɨ, ubhwɨrʉ bhʉkabhanza ɨgatɨ muyo. Maraika wuyo akabhaatʉra Peetero mʉrʉbharu, akamʉpambʉra, aramʉbhʉʉrɨra, “Gororoka bhwangʉ!” Ibhaga riyoriyo emenyororo ja kʉmabhoko gaazɨ gɨkatɨnɨka, gɨkagwa haasɨ. ");
INSERT INTO ikz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Neho maraika akamʉbhʉʉrɨra, “Ibhoha zengebho zaazʉ ni ibhikwɨra bhyazʉ.” Peetero akakora chɨmbu maraika aamubhuuriirɨ. Akʉmara maraika akamʉbhʉʉrɨra, “Wiibhohe nɨ ɨkanzʉ yaazʉ, untunɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peetero akamutuna maraika wurya, bhakarwa mokebhoho, nawe Peetero ataamɨnyirɨ kʉbha ɨbhɨsɨgʉ bhiyo bhyʉsi bhya maraika bhyarɨ bhya amaheene, akakina kʉbha araroota. ");
INSERT INTO ikz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Peetero na maraika wuyo bhakahɨta kumuriibhi we embere na wa kabhɨrɨ, bhakahika kukisikʉ chi ichʉma chu ukusikɨrɨra kʉrʉbhɨri. Ikisikʉ kiyo kikiigʉka ichene, bhakarwa mokebhoho na kusikɨra mʉrʉbhɨri. Bhakahɨta kwipanda rɨmwɨ, neho maraika wuyo akataana na Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Neho Peetero akoobhoora kwa ganʉ gaamuhurukiirɨ, akabhuga, “Nangʉ nʉbhʉʉrirɨ obhoheene kʉbha, Ʉmʉkʉrʉ atumirɨ maraika waazɨ, akantuurya kurwa mʉmabhoko ga Heroode na kurwa kʉmabhɨ gʉʉsi ganʉ Abhayaahudi bhaasɨɨmiryɨ bhankorere!” ");
INSERT INTO ikz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hanʉ Peetero ʉʉbhʉʉrirɨbhu, akaja wa Mariyamu unina Yoohana, wʉnʉ aarɨ arabhirikirwa Maaroko. Mumujɨ hayo, neho abhiisirirya bhaaru bhaarɨ bhiibhiringirɨ, bharasabhɨra Peetero kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peetero akahuna ikisikʉ, muucha wʉmwɨ omohocha, iriina ryazɨ Rooda, akaaza kwigʉra ikisikʉ. ");
INSERT INTO ikz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hanʉ ʉbhʉʉrirɨ kʉbha ni‑raka rya Peetero, akazomerwa bhʉkʉngʼu, akɨɨbha kumwigʉrɨra, akaryara kʉgarʉka mʉʉsi. Akabhabhʉʉrɨra bhʉʉsi kʉbha, “Peetero imiiriirɨ kukisikʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bhakamʉbhʉʉrɨra, “Awɨ ʉsarirɨ?” Nawe umuucha wuyo akakandikija kʉgamba nɨmbu ɨrɨ. Bhakabhuga, “Wuyo nɨ‑maraika waazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ribhaga riyo Peetero aarɨ arakaja kuhuna ikisikʉ. Hanʉ bhiigwirɨ ikisikʉ, bhakamorora, bhakarʉgʉʉra bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peetero akabhanʉngɨra okobhoko bhakirɨ, akabhaganɨra chɨmbu Ʉmʉkʉrʉ Yɨɨsu amuruushiryɨ mokebhoho. Neho akabhabhʉʉrɨra, “Amangʼana gayo, mʉbhʉʉrɨrɨ Yaakobho na abhiisirirya abhandɨ.” Akʉmara Peetero akarwa hayo, akaja ahandɨ. ");
INSERT INTO ikz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hanʉ bhwakɨɨrɨ, abhasirikarɨ bhi inyumba ye ekebhoho bhakʉʉbhaha bhʉkʉngʼu igʉrʉ wa amangʼana ganʉ gaamubhwɨnɨ Peetero. ");
INSERT INTO ikz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroode akaswaja abhasirikarɨ bhaazɨ bhamohye Peetero, nawe atarʉrɨkɨɨnɨ. Akabhabhuurya abhasirikarɨ bhanʉ bhaarɨ bhakumuriibha, neho akaswaja bhiitwɨ. Akʉmara Heroode akarwa Yudeya hayo, akaja kʉrʉbhɨri rwa Kaisaariya, akiikarayo kwibhaga. ");
INSERT INTO ikz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ʉmʉtɨmi Heroode aarɨ abhiigataniirɨ bhʉkʉngʼu abhaatʉ bhʉ ʉrʉbhɨri rwa Tiiro na Sidʉʉni. Abhaatʉ bhayo bhakiisiriranʼya hamwɨmwɨ, bhakatʉma abhaatʉ kwa Heroode kʉmʉsabha, bhiigwanɨ bhabhɨ no omorembe, kʉ kʉbha zɨmbɨri zaabhʉ zaarɨ zɨrabhona ibhyakurya kurwa ɨɨsɨ ya Heroode. Abhaatʉ bhayo bhakiisasaama Bhurasito, wʉnʉ aarɨ umwimiiririri wi inyumba yʉ ʉmʉtɨmi Heroode, iisiriranʼyɨ nabhʉ mʉbhʉtangɨ bhwa Heroode. ");
INSERT INTO ikz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Urusikʉ rʉnʉ rwarɨ rʉrʉbhwɨrwɨ, ʉmʉtɨmi Heroode akiibhoha zengebho zaazɨ zɨ ɨkɨtɨmi, akiikara kukitumbɨ chazɨ chɨ ɨkɨtɨmi, akarwaza mʉbhʉtangɨ bhwa abhaatʉ bhayo. ");
INSERT INTO ikz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Neho abhaatʉ bhayo bhakazomerwa na kʉrɨgɨsa bharabhuga, “Rɨnʉ rɨtarɨ iraka rya mʉʉtʉ! Rɨnʉ ni‑raka rya mungu!” ");
INSERT INTO ikz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Rogendo rʉmwɨ maraika wʉ Ʉmʉkʉrʉ akatema Heroode kubhurwɨrɨ bhwa rikʉʉrimʉ, kʉ kʉbha atamukumiryɨ Mungu, akakwa. ");
INSERT INTO ikz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nawe ɨngʼana ya Mungu ɨkakaja kʉnyaragana gatɨ wa abhaatʉ, abhiisirirya bhakaaruha bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hanʉ Bharinaabha na Sauri bhaamarirɨ emeremo jabhʉ jʉ ʉkʉbhasakirya abhiisirirya bha mʉrʉbhɨri rwa Yɨrusarɨɨmu, bhakagega Yoohana wʉnʉ aarɨ arabhirikirwa Maaroko, bhakagarʉka neewe Antiyʉkiya. ");
INSERT INTO ikz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mʉrʉbhɨri rwa Antiyʉkiya haarɨ na risengerero rɨnʉ ryarɨ na abharʉʉtɨrɨri na abhiija. Gatɨ ya bhayo bhaarɨ, Bharinaabha, Simiyʉʉni wʉnʉ aarɨ arabhirikirwa Nigɨɨri, enzobhooro yaku ʉmʉʉtʉ umwirabhuru, Rukiyʉ kurwa Kireene, Sauri na Manaɨni wʉnʉ aarɨrirwɨ nʉ ʉmʉtɨmi Heroode Antipaasi. ");
INSERT INTO ikz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Rusikʉ rʉmwɨ bhaarɨ bharakumya Ʉmʉkʉrʉ na kwiyima kurya, Ekoro Ɨndɨndu ɨkabhabhʉʉrɨra, “Mondobhorere Bharinaabha na Sauri komeremo gɨnʉ nɨbhabhirikiriirɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hanʉ bhaamarirɨ kʉmʉsabha Mungu na kwiyima kurya, bhakatʉʉra amabhoko gaabhʉ kumutwɨ gwa Bharinaabha na Sauri kʉbhasabhɨra, bhakabhatiga bhajɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mmbe Bharinaabha na Sauri bhaarɨ bhatumirwɨ ne Ekoro Ɨndɨndu. Bhakahiringita kʉrʉbhɨri rwa Sɨrɨkiya, kurwa hayo bhakatiira ubhwatʉ, bhakaja kwiginga rya Kipurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hanʉ bhaahikirɨ kwiginga riyo, kʉrʉbhɨri rwa Saraami, bhakatanga kurwazɨra abhaatʉ ɨngʼana ya Mungu mʉmarwazɨrʉ ga Abhayaahudi. Bhaarɨ na Yoohana wʉnʉ aarɨ arabhirikirwa Maaroko, ʉmʉsakirya waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hanʉ bhaamarirɨ kʉhɨta gatɨgatɨ ya Kipurʉ, bhakahika kʉrʉbhɨri rwa Paafʉ, bhakarumana nʉ Ʉmʉyaahudi wʉmwɨ ʉmʉrʉgi, wʉnʉ aarɨ ʉmʉrʉʉtɨrɨri wʉ ʉrʉrɨmɨ, iriina ryazɨ Bhaari‑Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ʉmʉʉtʉ wuyo aarɨ ʉmʉsakirya wu umwanangwa wa riginga, Sɨrigiyʉ Paaurʉ, ʉmʉʉtʉ wa amangʼɨɨni bhʉkʉngʼu. Umwanangwa wa riginga wuyo akabhɨrɨkɨra Bharinaabha na Sauri bhajɨ kwawe, akeenda iitegeerere ɨngʼana ya Mungu kurwa kwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nawe Bhaari‑Yɨɨsu ʉmʉrʉgi wuyo, muKigiriki aarɨ arabhirikirwa Ɨrima, aarɨ arahakaana na Bharinaabha na Sauri, korereke umwanangwa wa riginga wuyo atigɨ kwisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Neho Sauri wʉnʉ akubhirikirwa Paaurʉ, izwirwɨ Ekoro Ɨndɨndu, akamogorera ʉmʉrʉgi wuyo bhʉkʉngʼu, ");
INSERT INTO ikz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","akabhuga, “Omongʼeera awɨ, wizwirɨ amabhɨ, umwana wa Shɨtaani! Umubhisa wa amaheene! Ʉtakutiga kuchʉra amangʼana ga amaheene gʉ Ʉmʉkʉrʉ? ");
INSERT INTO ikz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nangʉ itegeerera! Okobhoko kʉ Ʉmʉkʉrʉ kuri igʉrʉ waazʉ, ʉrabha mʉhʉku, ʉtakorora nʉʉrʉ ubhwɨrʉ bhwi iryʉbha kwibhaga.” Hayohayo ikitu kɨkamuhukurya amɨɨsʉ, akabha mukiirimya. Akiiruguuraruguura korereke abhone ʉmʉʉtʉ wʉnʉ araatʉrɨ kumugwata okobhoko amʉkangatɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Hanʉ umwanangwa wuyo aarʉʉzɨ ɨkɨsɨgʉ kiyo, akamwisirirya Ʉmʉkʉrʉ, akaruguuribhwa bhʉkʉngʼu na amiija ganʉ gaarɨ gariijwa igʉrʉ wʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paaurʉ na abhakɨndichazɨ bhakarwa Paafʉ. Bhakatiira mubhwatʉ bhakaja, bhakahika mʉrʉbhɨri rwa Perege mucharʉ cha Pamufiiriya. Yoohana akabhatiga hayo, akagarʉka Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nawe Paaurʉ na Bharinaabha bhakarwa Perege, bhakaja kʉrʉbhɨri rwa Antiyʉkiya, mucharʉ cha Piisidiya. Urusikʉ rwʉ ʉbhʉtʉʉrʉ, bhakasikɨra mwirwazɨrʉ rya Abhayaahudi, bhakiikara. ");
INSERT INTO ikz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hanʉ abhakangati bhi inyumba yiyo bhaamarirɨ kosoma kumigirʉ ja Musa na kʉbhɨtabhʉ bhya abharʉʉtɨrɨri, bhakatʉma ʉmʉʉtʉ kwa Paaurʉ na Bharinaabha, akabhabhʉʉrɨra, “Abhahiiri bhɨɨtʉ, arɨɨbhɨ mʉna ringʼana ryʉ ʉkʉgamba na abhaatʉ kʉbhaha umwʉyʉ, mʉrɨgambɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paaurʉ akiimɨɨrɨra, akabheerekeererya kokobhoko korereke bhamwitegeerere, akabhuga, “Abhiiziraɨri imwɨ, na niimwɨ bhanʉ mokosengera Mungu, munyiitegeerere! ");
INSERT INTO ikz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mungu wa abhaatʉ bha Iziraɨri, newe abharʉbhwɨrɨ bhasʉʉkʉrʉ. Hanʉ bhaarɨ bhariikara mubhugini mʉʉsɨ ya Miisiri, akabhakora kʉbha icharʉ kɨkʉrʉ bhʉkʉngʼu na cha managa. Akʉmara akabhakangata, akabharuusha Miisiri kwa nguru zaazɨ, ");
INSERT INTO ikz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","kwibhaga ryi imyaka merongo ene akabhiigumirirya kʉkɨbhara. ");
INSERT INTO ikz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akʉmara, akaricha ibhyarʉ muhungatɨ kʉʉsɨ ya Kanaani, akabhaha Abhiiziraɨri ɨɨsɨ yiyo, ɨbhɨ ɨgabhʉ yaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gayo gʉʉsi gakakorebhwa kwibhaga ryi imyaka magana ane na merongo ɨtaanʉ. “Hanʉ gayo gaasirirɨ, Mungu akabhaha bhasʉʉkʉrʉ abhatiniri kʉbhakangata, kuhika ribhaga ryʉ ʉmʉrʉʉtɨrɨri Samwɨri. ");
INSERT INTO ikz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Neho bhakasabha bhabhɨ nʉ ʉmʉtɨmi. Mungu akabhaha Sauri, umwana wa Kiishi wɨ ɨkɨgambʉ cha Bhenjamɨɨni, akabha ʉmʉtɨmi kwi imyaka merongo ene. ");
INSERT INTO ikz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nawe Mungu akamuruusha Sauri kʉbhʉtɨmi, akamʉtʉʉra Daudi kʉbha ʉmʉtɨmi waabhʉ. Mungu akagamba amazʉmu igʉrʉ wa Daudi, ‘Nɨmʉrʉʉzɨ Daudi umwana wa Yeese, wʉnʉ akozomera umwʉyʉ gwanɨ, newe araakore ganʉ gʉʉsi naarɨ nɨramwendera kokora.’ ");
INSERT INTO ikz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kurwa kurwibhʉrʉ rwʉ ʉmʉtɨmi Daudi, Mungu akabhareetera Abhiiziraɨri Ʉmʉsabhuri chɨmbu aarɨ abharagɨɨnʼyɨ, Ʉmʉsabhuri wuyo nɨ‑Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hanʉ Yɨɨsu aarɨ akɨɨrɨ kʉtanga emeremo jazɨ, Yoohana aarɨ arabharaganʼya Abhiiziraɨri bhʉʉsi, bhatigɨ ʉbhʉbhɨ bhwabhʉ na kʉbhatiizwa. ");
INSERT INTO ikz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yoohana aarɨ haguhɨ kʉmara emeremo jazɨ, akagamba, ‘Mʉrarora kʉbha inyɨ nɨ‑wɨɨwɨ? Inyɨ nɨtarɨ Kiriisitʉ wʉnʉ mʉkʉrɨndɨɨra! Nawe wʉnʉ akuuza inyuma waanɨ, inyɨ nɨtakwenderwa nʉʉrʉ kwihiinya kʉtazʉra orokobha rwi ibhikwɨra bhyazɨ!’ ");
INSERT INTO ikz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abhahiiri bhaanɨ, abhaatʉ bhu ubhwibhurwa bhwa Abhurahaamu, na abhandɨ bhanʉ mokosengera Mungu, amangʼana gu ubhutuurya bhʉnʉ, bhʉrɨɨtirwɨ kwa niitwɨ kurwa kwa Mungu! ");
INSERT INTO ikz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Abhaatʉ bha Yɨrusarɨɨmu na abhakʉrʉ bhaabhʉ bhataamɨnyirɨ kʉbha Yɨɨsu newe Ʉmʉsabhuri, bhakamʉtɨnɨra iitwɨ. Ko kokorabhu neho bhakamara amangʼana ganʉ gaarɨ gaandikirwɨ igʉrʉ waazɨ mʉbhɨtabhʉ bhya abharʉʉtɨrɨri ebho bhataamɨnyirɨ, na nego garya gakosomwa zisikʉ zʉʉsi zʉ ʉbhʉtʉʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Abhaatʉ bhayo bhatabhwɨnɨ chʉchʉsi che eheene, kɨnʉ chagiriryɨ kʉtɨnɨra Yɨɨsu iitwɨ, nʉʉrʉbhu, bhakasabha Piraato, iitwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Hanʉ bhaamarirɨ gʉʉsi ganʉ gaandikirwɨ igʉrʉ wa Yɨɨsu, bhakamʉbhambʉra kʉmʉsarabha, bhakamʉtʉʉra mumbiihɨra. ");
INSERT INTO ikz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nawe Mungu akamuryʉra kurwa mʉbhaku! ");
INSERT INTO ikz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwa sikʉ nzaru Yɨɨsu akarorekana kʉbhaatʉ bhanʉ bhaarɨ kogendanʼya hamwɨmwɨ, kurwa Gariraaya kuja Yɨrusarɨɨmu. Nangʉ, bhayo nebho abhamɨnyɨɨkɨrɨri bhaazɨ kʉbhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Itwɨ tʉrabharwazɨra imwɨ Ɨngʼana Ɨnzʉmu, kʉbha, ganʉ nego garya Mungu aaragɨɨnʼyɨ bhasʉʉkʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","agamarirɨ kwa niitwɨ, abhaana bhaabhʉ, ku kuryʉra Yɨɨsu. Nɨmbu yaarɨ yandikirwɨ kʉZabhuri ya kabhɨrɨ, ‘Awɨ ni‑Mwana waanɨ, reero nɨbhɨɨrɨ Wuusʉ.’ ");
INSERT INTO ikz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Naatu Mungu akamuryʉra kurwa mʉbhaku, korereke atagarʉkɨra ʉbhʉsarya, akabhuga, ‘Nɨrakoha ʉrʉbhangʉ ʉrʉrɨndu na rwa amaheene, ʉrʉbhangʉ rʉnʉ naragɨɨnʼyɨ Daudi.’ ");
INSERT INTO ikz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yandikirwɨ ʉrʉbhaara ʉrʉndɨ kʉZabhuri kʉbha, ‘Ʉtakutiga Ʉmʉrɨndu waazʉ asarɨkɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Hanʉ Daudi amarirɨ gʉʉsi ganʉ Mungu aarɨ amwɨndirɨ akore, ribhaga ryu urwibhʉrʉ rwazɨ, akakwa, akabhiikwa mumbiihɨra na wiisɨ, ʉmʉbhɨrɨ gwazɨ gʉkabhora. ");
INSERT INTO ikz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nawe, wʉnʉ Mungu aaryurirɨ, ataabhʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nangʉ abhahiiri bhaanɨ, munyiitegeerere bhwaheene! Tʉrabharaganʼya kʉbha, kʉhɨtɨra Yɨɨsu Kiriisitʉ, kʉna kobheererwa ʉbhʉbhɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kʉhɨtɨra kwewe, ʉmʉʉtʉ wʉwʉʉsi wʉnʉ akumwisirirya arabharirwa eheene kwa Mungu, ɨngʼana yɨnʉ ɨtakʉtʉrɨkana kwa niimwɨ ku kutuna imigirʉ ja Musa. ");
INSERT INTO ikz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mwiyangarɨrɨ bhwaheene korereke mʉtagwatwa na amangʼana ganʉ gaagambirwɨ na abharʉʉtɨrɨri, ");
INSERT INTO ikz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Morore imwɨ bhanʉ mokoregana, Mʉrʉgʉʉrɨ, murikɨ, kʉ kʉbha nɨrakora emeremo zisikʉ zaanyu omoremo gʉnʉ mʉtakugwisirirya, nʉʉrʉ ʉmʉʉtʉ angabhabhʉʉrɨra!’ ” ");
INSERT INTO ikz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hanʉ Paaurʉ na Bharinaabha bhaarɨ bhararwa mwirwazɨrʉ rya Abhayaahudi, abhaatʉ bhakabhiisasaama bhagarʉkɨ urusikʉ rwʉ ʉbhʉtʉʉrʉ bhʉnʉ bhʉkʉbhata, korereke bhangʼehe kʉgamba igʉrʉ wa amangʼana gayo. ");
INSERT INTO ikz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hanʉ abhaatʉ bhayo bhaanyaragɨɨnɨ mwirwazɨrʉ. Abhayaahudi bhaaru, hamwɨmwɨ na abhaatʉ bha mubhyarʉ ɨbhɨndɨ, bhanʉ bhiisiriiryɨ ɨnyangi yɨ Ɨkɨyaahudi, bhakatuna Paaurʉ na Bharinaabha. Abheene bhakagamba na abhaatʉ bhanʉ bhaabhatunirɨ na bhakabhaha umwʉyʉ bhiikarɨ kʉbhɨgʉngi bhya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Urusikʉ rwʉ ʉbhʉtʉʉrʉ bhʉnʉ bhwabhatirɨ, nyamunga abhaatʉ bhʉʉsi bhʉ ʉrʉbhɨri ruyo bhakaaza kwitegeerera ɨngʼana yʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nawe hanʉ Abhayaahudi bhaarʉʉzɨ riribhita rɨnʉ ikʉrʉ rya abhaatʉ, bhakabha ni ikiriiso bhʉkʉngʼu. Neho bhakaanga ganʉ gaagambirwɨ na Paaurʉ na kʉmʉtʉka. ");
INSERT INTO ikz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paaurʉ na Bharinaabha bhakabhagarukirya kwa bhʉkararu bhakubhuga, “Yaarɨ ereenderwa ɨngʼana ya Mungu ɨraganibhwɨ kwa niimwɨ Abhayaahudi, hinga. Nawe kʉ kʉbha muryangirɨ na kwitɨnɨra imubheene kʉbha mʉtakwenderwa ʉbhʉhʉru bhwa kemerano, tʉrabhatiga, tʉraja kurwazɨra abhaatʉ bha mubhyarʉ ɨbhɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kʉ kʉbha nɨmbu Ʉmʉkʉrʉ Mungu aatuswajirɨ kʉbha, ‘Nɨkʉtɨɨrɨ ʉbhɨ ubhwɨrʉ kʉbhaatʉ bha mubhyarʉ ɨbhɨndɨ, korereke oreete ubhutuurya kʉbhaatʉ ɨɨsɨ yʉʉsi.’ ” ");
INSERT INTO ikz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hanʉ abhaatʉ bha mubhyarʉ ɨbhɨndɨ bhiigwirɨ amangʼana gayo, bhakazomerwa na bhakakumya kʉngʼana yʉ Ʉmʉkʉrʉ. Bhʉʉsi bhanʉ bhaarɨ bhɨɨndirwɨ kʉbhʉhʉru bhwa kemerano, bhakiisirirya Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ɨngʼana yʉ Ʉmʉkʉrʉ ɨkanyaragana icharʉ kiyo chʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nawe Abhayaahudi bhakasiigirirya abhakari bhu ubhusuuku bha mubhyarʉ ɨbhɨndɨ bhanʉ bhaarɨ abhiisirirya bha Mungu na abhasubhɨ bhi imyeya ɨmɨkʉrʉ kʉrʉbhɨri ruyo. Bhakakangata abhaatʉ kʉnyaacha Paaurʉ na Bharinaabha, na kʉbhaheebha kurwa mumijɨ jabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paaurʉ na Bharinaabha bhakakʉngʼʉta urutu kʉmagʉrʉ gaabhʉ kwerecha kʉbha ganʉ bhakʉrɨɨrwɨ nɨ‑mabhɨ. Neho bhakabhʉʉka, bhakaja kʉrʉbhɨri rwa Ikʉʉniyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nawe abhɨɨga bha Antiyʉkiya ya Piisidiya bhaarɨ bhazʉmɨɨrwɨ, bhiizwirɨ Ekoro Ɨndɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hanʉ Paaurʉ na Bharinaabha bhaarɨ Ikʉʉniyʉ, bhakasikɨra mwirwazɨrʉ rya Abhayaahudi, chɨmbu amanarʉ gaabhʉ gaarɨ. Bhakiija abhaatʉ kwa bhʉkaari igʉrʉ wa Yɨɨsu, ɨkagirya Abhayaahudi bhaaru hamwɨmwɨ na Abhagiriki bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nawe Abhayaahudi abhandɨ bhanʉ bhaangirɨ Yɨɨsu, bhakatanga kusiigirirya bha mubhyarʉ ɨbhɨndɨ korereke bhiigatanɨrɨ abhiisirirya bhayo. ");
INSERT INTO ikz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paaurʉ na Bharinaabha bhakakaja kwikara zisikʉ nzaru Ikʉʉniyʉ hayo, bhakabhabhʉʉrɨra abhaatʉ kwa bhʉkararu igʉrʉ wʉ Ʉmʉkʉrʉ Yɨɨsu. Ʉmʉkʉrʉ umwene wʉʉsi akeerekenʼya kʉbha, ɨngʼana yaazɨ yɨ ɨbhɨgʉngi nɨ‑ya amaheene, kʉ kʉbhaha ʉbhʉnaja bhwo okokora ibhyɨrɨkɨnʼyʉ na amateemo maaru. ");
INSERT INTO ikz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nawe abhaatʉ bhʉ ʉrʉbhɨri ruyo, bhakataana amaribhita abhɨrɨ. Riribhita ɨrɨmwɨ rɨkabha ʉrʉbhaara rwa Abhayaahudi abhatama kwisirirya, riribhita ɨrɨndɨ rɨkabha ʉrʉbhaara rwa abhatumwa. ");
INSERT INTO ikz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Akʉmara abhaatʉ bha mubhyarʉ ɨbhɨndɨ na Abhayaahudi hamwɨmwɨ na abhakangati bhaabhʉ, bhakakora amangʼɨɨni go okokorera Paaurʉ na Bharinaabha kɨbhɨ na kʉbhatema na amabhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nawe hanʉ abhatumwa bhaangʼurirɨ amangʼana gayo, bhakangʼosera Rikaʉniya, kʉzɨmbɨri za Riisitira na Dɨribhɨ na ahagero ahandɨ haguhɨ ya zɨmbɨri ziyo. ");
INSERT INTO ikz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Zɨmbaara zʉʉsi bhaarɨ bhararwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kʉrʉbhɨri rwa Riisitira, arɨ areho ʉmʉʉtʉ wʉmwɨ wʉnʉ aarɨ morema kwɨma kwibhurwa kwazɨ, aarɨ atakʉtʉra kogenda. ");
INSERT INTO ikz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ribhaga rɨnʉ Paaurʉ aarɨ akʉgamba, ʉmʉʉtʉ wuyo wʉʉsi aarɨ aramwitegeerera. Paaurʉ akamorora bhʉkʉngʼu, akarora kʉbha aarɨ nu ubhwisirirya bhwʉ ʉkʉhʉribhwa. ");
INSERT INTO ikz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paaurʉ akamʉbhʉʉrɨra kwiraka ikʉrʉ, “Imɨɨrɨra na amagʉrʉ gaazʉ.” Hayohayo ʉmʉʉtʉ wuyo akiimɨɨrɨra bhwangʉ, akatanga kogenda umwene! ");
INSERT INTO ikz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hanʉ riribhita rya abhaatʉ bhayo ryarʉʉzɨ chɨmbu Paaurʉ aahʉriryɨ ʉmʉʉtʉ wuyo, bhakatanga kwongera riraka muKirikaʉniya bharabhuga, “Amasambwa giizirɨ kʉsasɨɨra ya abhaatʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhakarʉka Bharinaabha iriina rya Zɨɨwu, risambwa ryabhʉ rikʉrʉ. Na Paaurʉ, bhakamoha iriina rya risambwa ryabhʉ ɨrɨndɨ Hɨrimɨ, kʉ kʉbha Paaurʉ newe aarɨ ʉmʉgambi ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Rusizʉ wʉ ʉrʉbhɨri ruyo, ryareho rihekaaru rya Zɨɨwu. Neho kuhaani wa Zɨɨwu akareeta kukishoko chʉ ʉrʉbhɨri ruyo, ihiiri ye engʼombe nɨ ɨbhɨrʉngʉ bhyɨ ɨbhɨbharyʉ. Ewe na riribhita rya abhaatʉ riyo, bhaarɨ bhareenda kwitɨra Paaurʉ na Bharinaabha ikimweso cha zengʼombe. ");
INSERT INTO ikz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nawe Bharinaabha na Paaurʉ hanʉ bhaabhwɨnɨ amangʼana gayo, bhakatarandʉra zengebho zaabhʉ kwa bhʉrʉrʉ. Bhakaryara na kusikɨra kwiribhita riyo, bharagamba kwiraka ikʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Abhaatʉ bhanʉ! Kwakɨ mʉrakora ganʉ? Itwʉsi nɨ‑bhaatʉ twangɨ imwɨ! Tʉrɨ hanʉ kʉbharwazɨra Ɨngʼana Ɨnzʉmu, korereke mutigɨ amasambwa gataana bhwera, mʉtangɨ kʉbha abharɨndu bha Mungu wʉ ʉbhʉhʉru! Ewe newe aatɨɨmirɨ risaarʉ, ɨɨsɨ, ɨnyanza na bhyʉsi bhɨnʉ bhirimu. ");
INSERT INTO ikz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ɨkarɨ Mungu akatiga abhaatʉ bhanʉ bhatarɨ Abhayaahudi, bhiikarɨ chɨmbu bhakwenda. ");
INSERT INTO ikz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nawe, ataatigirɨ kwerecha ibhyɨrɨkɨnʼyʉ bhyʉ ʉbhʉnaja bhwazɨ. Aarɨ arakora amazʉmu kʉ kʉbhareetera imbura kurwa mwisaarʉ, korereke mobhone amagesa gi ibhyakurya bhyaru nu ukwizurya obhozomerwa mozekoro zaanyu.” ");
INSERT INTO ikz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kʉ kʉgambabhu Paaurʉ na Bharinaabha bhakatʉra kwangirija abhaatʉ bhayo kwa nyaakʉ bhatabhahurukirya ikimweso. ");
INSERT INTO ikz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nawe bhakaaza Abhayaahudi abhandɨ kurwa Antiyʉkiya ya Piisidiya na Ikʉʉniyʉ, bhakakangirirya abhaatʉ korereke bhagwatanɨ. Bhakatema Paaurʉ amabhwɨ, bhakamukwesa, bhakamuhira imwambʉkʉ wʉ ʉrʉbhɨri bharakina kʉbha akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nawe abhɨɨga bhakiibhiringa na kumwirʉmbɨrɨra, akiimɨɨrɨra, akagarʉka mʉrʉbhɨri. Tabhʉʉri waho, akarwa hayo, akaja hamwɨmwɨ na Bharinaabha kʉrʉbhɨri rwa Dɨribhɨ. ");
INSERT INTO ikz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paaurʉ na Bharinaabha bhakarwazɨra abhaatʉ Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu Dɨribhɨ iyo, na kobhona abhiisirirya bhaaru. Akʉmara bhakaja, bhakahʉrʉkɨra Riisitira, Ikʉʉniyʉ na Antiyʉkiya ya Piisidiya. ");
INSERT INTO ikz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bhaarɨ bharabhaha umwʉyʉ abhɨɨga mbaara zʉʉsi bhakajɨ kwikara kubhwisirirya bhwabhʉ. Bhakabhabhʉʉrɨra, “Toreenderwa tʉhɨtɨrɨ zɨnyaakʉ nzaru korereke tusikɨrɨ mʉbhʉtɨmi bhwa Mungu.” ");
INSERT INTO ikz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paaurʉ na Bharinaabha bhakarobhora abhiimiiririri kurwa mʉmasengerero gʉʉsi. Kʉ kʉsabha na kwiyima kurya, bhakabhatiga mʉmabhoko gʉ Ʉmʉkʉrʉ Yɨɨsu wʉnʉ bhiisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Akʉmara Paaurʉ na Bharinaabha bhakahɨtɨra mucharʉ cha Piisidiya, bhakasikɨra Pamufiiriya, ");
INSERT INTO ikz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","bhakahika kʉrʉbhɨri rwa Perege. Bhakaraganʼya ɨngʼana ya Mungu, akʉmara bhakahiringitɨra kʉrʉbhɨri rwa Ataariya. ");
INSERT INTO ikz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kurwa Ataariya hayo bhakatiira mubhwatʉ, bhakagarʉka Antiyʉkiya ya Siiriya. Hayo neho bhaarɨ bhasabhiirwɨ na abhiisirirya bha risengerero, bhabhɨ nɨ ɨbhɨgʉngi bhya Mungu komeremo gɨnʉ bhaarɨ bhamarirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiyʉkiya hayo bhakabhiringa abhaatʉ bha risengerero, bhakabhabhʉʉrɨra ganʉ gʉʉsi Mungu aakʉriirɨ kʉhɨtɨra ebho, na chɨmbu iigwirɨ ikisikʉ kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi kwisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakiikara Antiyʉkiya hayo hamwɨmwɨ na abhɨɨga bhayo kwibhaga irɨɨhu. ");
INSERT INTO ikz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abhaatʉ obhorebhe bhakarwa Yudeya, bhakahiringitɨra kʉrʉbhɨri rwa Antiyʉkiya ya Siiriya. Bhakiija abhiisirirya bharabhuga, “Mʉrɨɨtamɨ kʉsaarwa kʉrɨngʼaana na amanarʉ ganʉ twatigiirwɨ na Musa, mʉtakʉtʉra kʉsabhʉka.” ");
INSERT INTO ikz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ringʼana riyo rɨkagirya Paaurʉ na Bharinaabha bhaangɨ abhaatʉ bhayo, na kʉgambana nabhʉ kʉbhʉhaari bhʉkʉngʼu. Abhaatʉ bha risengerero rya Antiyʉkiya, bhakeenda kʉtʉma Paaurʉ na Bharinaabha hamwɨmwɨ na abhaatʉ obhorebhe gatɨ waabhʉ, bhajɨ Yɨrusarɨɨmu kʉgambɨra ringʼana riyo kʉbhatumwa bha Yɨɨsu na abhiimiiririri bha risengerero rya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abhaatʉ bha risengerero bhayo bhakabharaga, neho bhakahɨta kubhyarʉ bhya Fʉinikɨ na Samaariya, bhakabha bhararaganʼya abhaatʉ chɨmbu abhaatʉ bhanʉ bhatarɨ Abhayaahudi bhiisiriiryɨ Yɨɨsu. Ɨngʼana yiyo ɨkabhazomera bhʉkʉngʼu abhiisirirya abhakɨndichabhʉ bhʉʉsi bhi iyo. ");
INSERT INTO ikz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paaurʉ na abhakɨndichazɨ bhayo, hanʉ bhaahikirɨ Yɨrusarɨɨmu, bhakasʉngʼaanwa bhwaheene na abhatumwa bha Yɨɨsu, abhiimiiririri na Abhakiriisitʉ abhandɨ bha risengerero rya Mungu. Paaurʉ na abhakɨndichazɨ bhakabhabhʉʉrɨra gʉʉsi ganʉ Mungu akʉrirɨ kʉ kʉhɨtɨra ebho. ");
INSERT INTO ikz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nawe abhiisirirya obhorebhe bha riribhita rya Abhafarisaayo bhakiimɨɨrɨra, bhakabhuga, “Bhanʉ bhatarɨ Abhayaahudi bhʉʉsi ereenderwa bhasaarwɨ, na kugwata imigirʉ ja Musa.” ");
INSERT INTO ikz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abhatumwa bha Yɨɨsu na abhiimiiririri bhayo, bhakakora ichandarʉ korereke bhiiseege bhwaheene ringʼana riyo. ");
INSERT INTO ikz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hanʉ bhaagɨgirɨ ibhaga irɨɨhu kʉhakaana neebho, Peetero akiimɨɨrɨra, akabhabhʉʉrɨra, “Imwɨ abhahiiri bhɨɨtʉ, mwɨzɨ kʉbha kwɨma ɨkarɨ Mungu akandobhora kʉbhaniimwɨ, korereke abhaatʉ bhanʉ bhatarɨ Abhayaahudi bhabhone kubhuurirwa Ɨngʼana Ɨnzʉmu igʉrʉ wa Yɨɨsu kʉhɨtɨra kwa niinyɨ, kuhika bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mungu newe yɨɨzɨ mozekoro za abhaatʉ, akeerekenʼya kʉbha, bhanʉ bhatarɨ Abhayaahudi arabhiisirirya kʉ kʉbhaha Ekoro Ɨndɨndu, chɨmbu atʉhɨɨrɨ itwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ataakʉrirɨ kɨmbʉrʉʉri chʉchʉsi gatɨ yɨɨtʉ neebho, kʉ kʉbha ebho bhʉʉsi bhiisiriiryɨ Yɨɨsu, na akabhɨngukya zekoro zaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ndora nangʉ moreenda kogema Mungu, ko kogegya abhɨɨga bhanʉ bhatarɨ Abhayaahudi bhayo imirigʉ gɨnʉ gikʉtʉtama itubheene, na bhasʉʉkʉrʉ bhɨɨtʉ gikabhatama kogega. ");
INSERT INTO ikz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Itwɨ turiisirirya kʉbha, ɨbhɨgʉngi bhyʉ Ʉmʉkʉrʉ wɨɨtʉ Yɨɨsu Kiriisitʉ tʉrasabhurwa, chɨmbu ebho bhaasabhwirwɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Neho abhaatʉ bhʉʉsi bhakakira kiri, Bharinaabha na Paaurʉ bhakagamba chɨmbu Mungu aarɨ areerekenʼya ibhyɨrɨkɨnʼyʉ na amateemo maaru gatɨ wa abhaatʉ bhanʉ bhatarɨ Abhayaahudi kʉhɨtɨra ebho. ");
INSERT INTO ikz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hanʉ bhaamarirɨ kʉgamba, Yaakobho wʉʉsi akabhuga, “Imwɨ abhahiiri bhaanɨ, munyiitegeerere! ");
INSERT INTO ikz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Peetero atubhuuriirɨ chɨmbu Mungu abhasakiiryɨ abhaatʉ bhi ibhyarʉ ɨbhɨndɨ, korobhora abhaatʉ abhandɨ mʉbhayo, bhabhɨ abhaatʉ bhaazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Amangʼana ganʉ nɨ‑mamwɨmwɨ na ganʉ gaandikirwɨ na abharʉʉtɨrɨri mʉMaandɨkʉ Amarɨndu kʉbha, ");
INSERT INTO ikz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ʉmʉkʉrʉ aagambirɨ, “Ganʉ garɨɨhɨtɨ, nɨragarʉka, nɨrʉʉmbaka inyumba ya Daudi yɨnʉ igwirɨ. Nɨrʉʉmbaka naatu amatuturi gaazɨ ganʉ garikiibhwɨ, nɨragiimiirirya bhuhya, ");
INSERT INTO ikz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","korereke abhaatʉ bhanʉ bhatarɨ Abhayaahudi bhaamonhyɨ, bhʉʉsi bhanʉ nabhabhirikiirɨ bhabhɨ abhaatʉ bhaanɨ. Amangʼana ganʉ, inyɨ nɨragakora.” ");
INSERT INTO ikz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nɨmbu akubhuga Ʉmʉkʉrʉ wʉnʉ akomenyeekererya gayo kwɨma ɨkarɨ.’” ");
INSERT INTO ikz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yaakobho akangʼeha kʉgamba, “Igʉrʉ wa gayo, inyɨ nɨrarora kʉbha tʉtanyaacha bhanʉ bhakwichʉrɨra Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nawe tʉbhaandɨkɨrɨ amaandɨkʉ kʉbhabhʉʉrɨra bhatarya ibhyakurya bhɨnʉ bhɨsɨngɨɨrwɨ amasambwa, bhatakora ɨtaarʉ, bhatarya ɨnyama yi ikityɨnyi kɨnʉ kɨngʼɨɨtirwɨ, bhatarya na bhatanywa amasaahɨ. ");
INSERT INTO ikz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tʉkabhabhʉʉrɨra kʉ kʉbha kwɨma ɨkarɨ imigirʉ ja Musa jarɨ giriijibhwa zɨmbɨri zʉʉsi, na jarɨ gɨrasomwa mʉmarwazɨrʉ zisikʉ zʉʉsi zʉ ʉbhʉtʉʉrʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abhatumwa bhayo, abhiimiiririri, hamwɨmwɨ na risengerero igima rya Yɨrusarɨɨmu hayo, bhakiisiriranʼya bhakatɨna ikiina kʉbha, bharobhore abhaatʉ obhorebhe gatɨ waabhʉ bhanʉ bhakuja hamwɨmwɨ na Paaurʉ na Bharinaabha kʉrʉbhɨri rwa Antiyʉkiya ya Siiriya. Gatɨ waabhʉ, bhakarobhora bhasubhɨ bhabhɨrɨ bhanʉ bhakusuukwa bhʉkʉngʼu. We embere aarɨ ni‑Yuuda wʉnʉ aabhirikiirwɨ Bharisaabha, wa kabhɨrɨ aarɨ ni‑Siira. Bhakatumwa na amaandɨkʉ ganʉ: ");
INSERT INTO ikz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","“Itwɨ abhatumwa na abhiimiiririri bha risengerero ni‑bhiisirirya abhakɨndichanyu, tʉrabhakeerya imwɨ bhanʉ mʉtarɨ Abhayaahudi, bhanʉ mʉrɨ kʉrʉbhɨri rwa Antiyʉkiya, na kʉʉsɨ ya Siiriya, na kʉʉsɨ ya Kirikiya. ");
INSERT INTO ikz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Twigwirɨ kʉbha, abhakɨndichɨtʉ bhakabhabhʉʉrɨra amangʼana gʉ ʉkʉbhahabhya, naatu gʉ ʉkʉnyaacha zekoro zaanyu. Nawe itwɨ tʉtaabhatumirɨ, bhakabhʉʉka abheene. ");
INSERT INTO ikz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kʉrɨngʼaana na gayo, itwɨ twisirirɨɨnʼyɨ kʉbha, torobhore abhaatʉ bhanʉ tʉraazɨ kʉbhatʉma iyo, bhaazɨ hamwɨmwɨ na abhasɨɨgwa bhɨɨtʉ Bharinaabha na Paaurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bhakatʉʉra ubhwikari bhwabhʉ ahabhɨ igʉrʉ wi iriina ryʉ Ʉmʉkʉrʉ wɨɨtʉ Yɨɨsu Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Tʉratʉma Yuuda na Siira kwa niimwɨ, bhanʉ nebho bharaabhabhʉʉrɨrɨ amangʼana ganʉ tʉbhaandikiirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ɨkatozomera itwɨ ne Ekoro Ɨndɨndu, tʉtabhiitwicha umurigʉ ʉgʉndɨ kʉkɨra imigirʉ gɨnʉ gikwenderwa. ");
INSERT INTO ikz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mʉtarya ibhyakurya bhɨnʉ bhɨsɨngɨɨrwɨ amasambwa, mʉtanywa amasaahɨ, mʉtarya ɨnyama yi ikityɨnyi kɨnʉ kɨngʼɨɨtirwɨ, na mʉtakora ɨtaarʉ. Hanʉ muriitigɨ gayo, neho mʉkʉbha mʉkʉrirɨ bhwaheene. Mʉbhɨ no omorembe.” ");
INSERT INTO ikz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hanʉ abhatumwa bhayo bhaaragirwɨ na abhakɨndichabhʉ, bhakahiringitɨra Antiyʉkiya. Bhakabhiringa abhaatʉ bha risengerero rya Antiyʉkiya, bhakabhaha amaandɨkʉ garya. ");
INSERT INTO ikz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hanʉ abhaatʉ bhayo bhaamarirɨ kʉgasoma, bhakazomerwa igʉrʉ wʉ ʉkʉbhaha umwʉyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuuda wuyo hamwɨmwɨ na Siira bhaarɨ abharʉʉtɨrɨri. Bhakabhʉʉrɨra abhiisirirya abhakɨndichabhʉ amangʼana maaru gʉ ʉkʉhaana umwʉyʉ no okobhona zinguru. ");
INSERT INTO ikz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Rɨkahɨta ibhaga irebhe, abhiisirirya bhayo bhakabhiisiririrya kʉbha bhagarʉkɨ Yɨrusarɨɨmu komorembe kʉbhaatʉ bhanʉ bhaabhatumirɨ.  ");
INSERT INTO ikz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nawe Siira umwene akarora kʉbha, nɨ‑bhwaheene asaagɨ haryaharya. ");
INSERT INTO ikz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na Paaurʉ na Bharinaabha bhʉʉsi bhakasaagayo, hamwɨmwɨ na abhaatʉ abhandɨ bhi iyo, bhakabha bhariija na kurwazɨra abhaatʉ ɨngʼana yʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Zɨkahɨta sikʉ suuhu, Paaurʉ akabhʉʉrɨra Bharinaabha, “Tʉgarʉkɨ kʉzɨmbɨri zɨnʉ twijiryɨ ɨngʼana yʉ Ʉmʉkʉrʉ, tʉbhataarɨrɨ abhiisirirya abhakɨndichɨtʉ, korereke torore amagenderero gaabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Korogendo ruyo, Bharinaabha aarɨ areenda bhagege Yoohana wʉnʉ aarɨ arabhirikirwa Maaroko, ajɨ hamwɨmwɨ neebho. ");
INSERT INTO ikz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nawe Paaurʉ akarora kʉbha, ɨtarɨ bhwaheene bhajɨ hamwɨmwɨ neewe, kʉ kʉbha ewe aarɨ abhatigirɨ kʉʉsɨ ya Pamufiiriya, akaanga kokora emeremo hamwɨmwɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gayo gakagirya Paaurʉ na Bharinaabha bhʉʉmanɨ bhʉkʉngʼu, kuhikɨra bhakataana. Bharinaabha akagega Maaroko, bhakaja kubhwatʉ hamwɨmwɨ bhakahika kwiginga rya Kipurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paaurʉ akarobhora Siira, hanʉ abhiisirirya abhakɨndichabhʉ bhaamarirɨ kʉmʉsabhɨra abhɨ nɨ ɨbhɨgʉngi bhyʉ Ʉmʉkʉrʉ, akabhʉʉka kuja. ");
INSERT INTO ikz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Akaja kʉʉsɨ ya Siiriya na Kirikiya, akabha arakandikija amasengerero. ");
INSERT INTO ikz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paaurʉ akaja kʉrʉbhɨri rwa Dɨribhɨ na rwa Riisitira, iyo aareho umwɨga wʉmwɨ wa Yɨɨsu, iriina ryazɨ Timoseo. Unina aarɨ Mʉyaahudi wʉnʉ isiriiryɨ Yɨɨsu, nawe wiisɨ aarɨ Mugiriki. ");
INSERT INTO ikz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoseo aarɨ nu ubhukumuka ʉbhʉzʉmu gatɨgatɨ wa abhiisirirya abhakɨndichazɨ bha Riisitira na Ikʉʉniyʉ. ");
INSERT INTO ikz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paaurʉ akeenda Timoseo ajɨ hamwɨmwɨ nawe morogendo, ɨkagirya akamʉsaara, kʉ kʉbha Abhayaahudi bhʉʉsi bhi iyo bhaarɨ bhɨɨzɨ kʉbha wiisɨ Timoseo aarɨ Mugiriki. ");
INSERT INTO ikz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hanʉ Paaurʉ na abhakɨndichazɨ bhaarɨ bharahɨta mʉzɨmbɨri ziyo, bhakabhaha abhiisirirya amiija ganʉ gaarɨ gatɨɨrwɨ na abhatumwa na abhiimiiririri bha risengerero rya Yɨrusarɨɨmu, korereke bhagagwatɨ. ");
INSERT INTO ikz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nɨmbu abhaatʉ bha amasengerero gangʼɨhirɨ kobhona zinguru kubhwisirirya. Endengo ya abhiisirirya yaarɨ ɨraaruha sikʉ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paaurʉ na abhakɨndichazɨ bhayo, bhaarɨ bharɨkiibhwɨ ne Ekoro Ɨndɨndu kʉbha, bhatiija ɨngʼana ya Mungu mucharʉ cha Asiya. Bhaaza kʉrɨchibhwa, bhakahɨta kʉʉsɨ ya Furigiya nɨ ɨɨsɨ ya Garaatiya. ");
INSERT INTO ikz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hanʉ bhaahikirɨ kʉbhʉtaanɨrʉ bhu ukusikɨra ɨɨsɨ ya Miisiya, bhakagema kusikɨra kʉʉsɨ ya Bhisiniya, nawe Ekoro ya Yɨɨsu ɨtabhiisiririiryɨ. ");
INSERT INTO ikz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bhakarora bhahɨtɨ kʉʉsɨ ya Miisiya, bhakahiringita kuja kʉrʉbhɨri rwa Turowa. ");
INSERT INTO ikz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ubhutikʉ Paaurʉ akarora ʉbhʉrʉri. Akarora ʉmʉʉtʉ wʉmwɨ wi icharʉ cha Makɨdʉniya imiiriirɨ, akamwisasaama bhʉkʉngʼu akubhuga, “Yambʉka ɨnyanza uuzɨ Makɨdʉniya, ʉtʉsakiryɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Hanʉ Paaurʉ aamarirɨ korora ʉbhʉrʉri, tʉkarora heene Mungu atubhirikiirɨ korereke tʉbharwazɨrɨ abhaatʉ Ɨngʼana Ɨnzʉmu. Hayohayo, tʉkamohya ubhwatʉ tujɨ Makɨdʉniya. ");
INSERT INTO ikz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mmbe, tʉkarwa Turowa nu ubhwatʉ tʉkahika mwiginga rya Samʉtiraakɨ. Hanʉ bhwɨrirɨ, tʉkaja Nɨyapʉʉri. ");
INSERT INTO ikz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kurwa hayo tokeerekera Firipi mucharʉ cha Makɨdʉniya, hanʉ bhaarɨ bhakwikara Abharuumi. Itwʉsi tukiikara kʉrʉbhɨri ruyo kuzisikʉ obhorebhe. ");
INSERT INTO ikz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Urusikʉ rwʉ ʉbhʉtʉʉrʉ tʉkahʉrʉka igʉtʉ wʉ ʉrʉbhɨri tʉkaja rusizʉ wɨ ɨkɨtaarʉ, tukiiseega kʉbha neho twangabhwɨnɨ abhaatʉ bharasabha Mungu. Tʉkabhona abhakari obhorebhe bhiibhiringirɨ, tʉkagambana nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gatɨ wa bhanʉ bhaarɨ bhakutwitegeerera, aarɨ arimu ʉmʉkari kurwa ʉrʉbhɨri rwa Tiyatiira, iriina ryazɨ Riidiya. Riidiya wuyo, aarɨ ni‑mugurya wa zengebho zɨnzʉmu za zambaraawɨ na aarɨ arasengera Mungu. Hanʉ Paaurʉ aagambirɨ amangʼana amazʉmu, Ʉmʉkʉrʉ akiigʉra umwʉyʉ gwa Riidiya, akiisirirya ɨngʼana yɨnʉ Paaurʉ aarɨ akʉgamba. ");
INSERT INTO ikz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Neho Ʉmʉkari wuyo akabhatiizwa na abhaatʉ bhɨ ɨwaazɨ, hanʉ bhaamarirɨ, akatukandikija arabhuga, “Arɨɨbhɨ amaheene mʉrʉʉzɨ kʉbha inyʉʉsi nimwisiriiryɨ Ʉmʉkʉrʉ, nɨrabhaginihya ɨwaanɨ.” Akatʉhatɨka bhʉkʉngʼu tujɨ ɨwaazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Rusikʉ rʉmwɨ hanʉ twarɨ tʉraja ahagero hanʉ bhahaasengera Mungu, tʉkahunana nu umuucha wʉmwɨ mbʉʉsa. Umuucha wuyo aarɨ ana risambwa ryʉ ʉkʉragʉra korora amangʼana ganʉ gakuuza. Kʉnzɨra yʉ ʉbhʉgabhʉ, abhakʉrʉ bhaazɨ bhaarɨ bharabhona zimpirya nzaru. ");
INSERT INTO ikz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Umuucha wuyo akabha aratutunɨɨrɨra itwɨ na Paaurʉ, ararɨgɨsa arabhuga, “Bhanʉ nɨ‑bhahocha bha Mungu wi Igʉrʉ wa Bhyʉsi, bharɨ hanʉ kʉbharagɨrɨra ɨnzɨra yu ubhutuuribhwa.” ");
INSERT INTO ikz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akabha aragarʉkɨra amangʼana gayo sikʉ nzaru. Ɨtɨnɨrʉ Paaurʉ akiigatana, akiichʉra inyuma akarɨbhʉʉrɨra risambwa, “Nikuswajiryɨ kuriina rya Yɨɨsu Kiriisitʉ, nuurwɨ kumuucha wʉnʉ!” Hayohayo risambwa riyo rɨkamurwɨku. ");
INSERT INTO ikz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hanʉ abhakʉrʉ bhu umuucha wuyo bhaarʉʉzɨ kʉbha, ɨtareeho nzɨra yɨndɨ yo okobhona zimpirya, bhakatuumɨra Paaurʉ na Siira, bhakabhakwesa kuhika momoteera mʉbhʉtangɨ bhwa abhakʉrʉ bhʉ ʉrʉbhɨri. ");
INSERT INTO ikz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bhakabhagamba kʉbhakʉrʉ bhayo bharabhuga, “Abhaatʉ bhanʉ, nɨ‑Bhayaahudi, bharakora ʉrʉbhɨri rwɨtʉ rʉbhɨ na rirɨgɨ. ");
INSERT INTO ikz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhariija kʉbha tutunɨ ganʉ gatarɨ amazʉmu kokorwa, ni imigirʉ jɨtʉ Abharuumi gɨratʉbhʉʉrɨra kʉbha tʉtagiisirirya na kʉgatunɨɨrɨra.” ");
INSERT INTO ikz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Riribhita rya abhaatʉ bhanʉ bhaarɨ bhiibhiringirɨ, bhakaja kubhiitanʼya. Abhakʉrʉ bhayo bhakabharuusha zengebho kwa nguru na kuswaja kʉbha, Paaurʉ na Siira bhatemwe zihimbʉ bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hanʉ bhaamarirɨ kotemwa, bhakatuurwa mokebhoho, umuriibhi wa munyumba ye ekebhoho, akaswajibhwa kʉbha abhariibhɨ kandikija. ");
INSERT INTO ikz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kʉrɨngʼaana na amaswaja gayo, umuriibhi wuyo akabhasikirya ɨgatɨ, akabhabhoha amagʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hanʉ yaahikirɨ ubhutikʉ gatɨ, Paaurʉ na Siira bhaarɨ bharasabha na kwɨmbɨra Mungu amɨɨmbʉ gu ukumukumya, ɨnʉ abhabhohwa abhakɨndichabhʉ bharabhiitegeerera. ");
INSERT INTO ikz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Rogendo rʉmwɨ kʉkabha ni ikirigitʉ kɨkʉrʉ bhʉkʉngʼu, ɨɨsɨ ɨkasingisha ɨtangɨ yi inyumba ye ekebhoho. Hayohayo ibhisikʉ bhyʉsi bhikiigʉka ibhyɨnɨbhu, ne emenyororo gɨnʉ bhaarɨ bhabhabhʉhɨɨrɨ gɨkatazʉka. ");
INSERT INTO ikz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Umuriibhi wi inyumba ye ekebhoho wuyo akabhʉʉka. Hanʉ aarʉʉzɨ kʉbha ibhisikʉ bhyigukirɨ, akakina kʉbha abhabhohwa bhʉʉsi bhangʼʉsirɨ. Akasohora ɨpanga yaazɨ kwenda kwiyita. ");
INSERT INTO ikz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nawe Paaurʉ akahurucha riraka akamʉbhʉʉrɨra, “Utiiyita! Turimu itwʉsi!” ");
INSERT INTO ikz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Umuriibhi wuyo akatʉmanʼya ɨkɨmʉrɨ kereetwe. Akasikɨra munyumba, akagwa mʉbhʉtangɨ bhwa Paaurʉ na Siira ɨnʉ ararigita. ");
INSERT INTO ikz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ibhaga isuuhu umuriibhi wurya akahʉrʉka na Paaurʉ na Siira kurwa mokebhoho, akabhabhuurya, “Abhakʉrʉ bhaanɨ, nekorebhwɨ korereke nɨsabhʉkɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhakamʉgarukirya, “Mwisiriryɨ Ʉmʉkʉrʉ Yɨɨsu, awɨ na abhaatʉ bhɨ ɨwaazʉ, neho mʉraasabhʉkɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Paaurʉ na Siira bhakiija umuriibhi wuyo hamwɨmwɨ na abhaatʉ bhɨ ɨwaazɨ igʉrʉ wɨ ɨngʼana yʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ribhaga ryu ubhutikʉ riyoriyo, umuriibhi akagega Paaurʉ na Siira, akooja ɨbhɨrasʉ bhyabhʉ. Akʉmara akabhatiizwa hayohayo hamwɨmwɨ na abhaatʉ bhaazɨ bhʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Akabhaginihya Paaurʉ na Siira ɨwaazɨ, akabhaha ibhyakurya. Akazomerwa bhʉkʉngʼu hamwɨmwɨ na abhaatʉ bhaazɨ bhʉʉsi, kʉ kʉbha bhiisiriiryɨ Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hanʉ bhwakɨɨrɨ, abhakʉrʉ bhakatʉma abhakʉrʉ bha abhasirikarɨ bhi inyumba ye ekebhoho, bhakamʉbhʉʉrɨra, “Bhiigʉrɨrɨ abhaatʉ bharya.” ");
INSERT INTO ikz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Neho umuriibhi wuyo akabhʉʉrɨra Paaurʉ, “Abhakʉrʉ bhatumirɨ amangʼana kʉbha mʉtazurwɨ, nangʉ mʉhʉrʉkɨ igʉtʉ, mujɨ no omorembe.” ");
INSERT INTO ikz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nawe Paaurʉ akagarukirya abhasirikarɨ bhayo akabhuga, “Bhakatotema zihimbʉ habhwɨrʉ mʉbhʉtangɨ bhwa abhaatʉ, bhatatubhuuriryɨ na kutuhira mʉtɨnɨrʉ ɨnʉ itwɨ, nɨ‑Bharuumi! Bhakatʉtʉʉra mokebhoho, na nangʉ bhareenda kuturuushamu kwa mbisi? Ɨtakʉtʉrɨkana! Na ereenderwa ebho nebho bhaazɨ hanʉ bhaturuushɨmu.” ");
INSERT INTO ikz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abhasirikarɨ bharya bhakaja kʉbhabhʉʉrɨra abhakʉrʉ bhayo gayo gʉʉsi. Hanʉ abhakʉrʉ bhayo bhiigwirɨ kʉbha Paaurʉ na Siira, nɨ‑Bharuumi, bhakʉʉbhaha. ");
INSERT INTO ikz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bhakaaza kubhiisasaama, bhakabharuusha mokebhoho, bhakabhasabha bharwɨ kʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hanʉ Paaurʉ na Siira bhaaruurɨ mokebhoho, bhakaja wa Riidiya. Bhakahunana na abhiisirirya abhakɨndichabhʉ, bhakabhaha umwʉyʉ, akʉmara bhakabhʉʉka bhakaja ɨnʉ bhaarɨ bhakuja. ");
INSERT INTO ikz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paaurʉ na Siira bhakahɨta kʉrʉbhɨri rwa Amufipʉʉri, na rwa Apʉrʉʉniya, bhakahika kʉrʉbhɨri rwa Tɨsarʉʉnikɨ, hanʉ inyumba ya rirwazɨrʉ rya Abhayaahudi yaarɨ. ");
INSERT INTO ikz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paaurʉ akasikɨra munyumba yiyo, kʉrɨngʼaana na amanarʉ gaazɨ chɨmbu gaarɨ. Kuzisikʉ isatʉ zʉ ʉbhʉtʉʉrʉ, akagambana na abhaatʉ amangʼana ganʉ garɨ mʉMaandɨkʉ Amarɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Akagahumbura na kʉbhabhʉʉrɨra kʉbha, Kiriisitʉ aarɨ areenderwa anyaakibhwɨ na kwitwa na aryʉkɨ kurwa mʉbhaku. Na kʉbha “Kiriisitʉ wʉnʉ nɨkʉbhabhʉʉrɨra amangʼana gaazɨ, newe Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ganʉ Paaurʉ aagambirɨ, Abhayaahudi abhamwɨ bhakagiisirirya, na Abhagiriki bhanʉ bhaarɨ bharasʉʉka Mungu, na abhakari bhaaru bha amangʼɨɨni bhakiisirirya. Bhʉʉsibhu bhakagwatana na Paaurʉ na Siira. ");
INSERT INTO ikz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nawe gayo gakagirya Abhayaahudi abhandɨ bhakarora rihari. Bhakaja momoteera, bhakagega abhaatʉ abhasɨɨgʉ. Bhakatanga kʉrɨgɨsa kʉrʉbhɨri ruyo. Bhakaja wa Yasʉʉni bharamohya Paaurʉ na Siira, korereke bhabhareete kwiribhita riyo. ");
INSERT INTO ikz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hanʉ bhaabhurirwɨ, bhakagega Yasʉʉni hamwɨmwɨ na abhiisirirya obhorebhe. Bhakabhahira mʉbhʉtangɨ bhwa abhakʉrʉ bhʉ ʉrʉbhɨri, bhakagamba kwiraka ikʉrʉ, “Abhaatʉ bhanʉ bhagaribhwirɨ icharʉ chʉsi nebho bhanʉ bhamarirɨ kuhika kʉrʉbhɨri rwɨtʉ hanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasʉʉni newe abhaginihiryɨ ɨwaazɨ. Hamwɨmwɨ na gayo, bhanʉ bhʉʉsi bhararega imigirʉ gɨnʉ jatɨɨrwɨ na Kaisaari, bharabhuga angʉ, areho ʉmʉtɨmi ʉwʉndɨ arabhirikirwa Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kʉmangʼana gayo, abhakʉrʉ bhʉ ʉrʉbhɨri ruyo hamwɨmwɨ na riribhita riyo bhakarɨgɨsa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yasʉʉni na abhakɨndichazɨ bhayo bhakasingʼiiriribhwa kuhurucha ɨnzagʉ. Hanʉ bhaamarirɨ kuhurucha, abhakʉrʉ bhayo bhakabhiisiririrya bhagarʉkɨ yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ribhaga ryu ubhutikʉ bhurya, abhiisirirya bhakatʉma Paaurʉ na Siira kʉrʉbhɨri rwa Bherooya. Hanʉ bhaahikirɨ iyo, bhakasikɨra mwirwazɨrʉ rya Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abhaatʉ bha Bherooya, bhaarɨ bhazʉmu kʉkɨra bha Tɨsarʉʉnikɨ. Bhakagirya Paaurʉ abhabhʉʉrɨrɨ ɨngʼana ya Mungu, bhakiisirirya kwitegeerera. Bhakabha bhararora Amaandɨkʉ Amarɨndu kɨrakabhu, korereke bhamenye kʉbha gayo Paaurʉ aarɨ akʉgamba, nɨ‑ga amaheene. ");
INSERT INTO ikz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abhayaahudi bhaaru gatɨ waabhʉ na abhaatʉ abhamwɨ mubhyarʉ ɨbhɨndɨ, abhakari na abhasubhɨ bhaaru bhakiisirirya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Hanʉ Abhayaahudi bha Tɨsarʉʉnikɨ bhʉʉbhʉʉrirɨ kʉbha Paaurʉ ariija ɨngʼana ya Mungu Bherooya iyo, bhakajayʉ, bhakatanga kusiigirirya amaribhita na kokora rirɨgɨ ikʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Abhiisirirya abhakɨndichazɨ, bhakahira Paaurʉ kukihuukʉ. Nawe Siira na Timoseo abheene bhakasaaga Bherooya. ");
INSERT INTO ikz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na bhanʉ bhaarɨ bhakohereekerera Paaurʉ, bhakamuhicha kʉrʉbhɨri rwa Asɨnɨ. Hanʉ bhaarɨ bhakwenda kʉgarʉka, Paaurʉ akabhatʉma, bhariihikɨ bhabhabhʉʉrɨrɨ Timoseo na Siira kʉbha bhamutunɨ bhwangʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Hanʉ Paaurʉ aarɨ ararɨnda Siira na Timoseo kʉrʉbhɨri rwa Asɨnɨ, akarora ʉrʉbhɨri ruyo rwʉsi rwizwirɨ amabhirʉbhirʉ. Umwʉyʉ gwazɨ gʉkabhiihirirwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Akagambana na Abhayaahudi hamwɨmwɨ na abhandɨ bhanʉ bhakosengera Mungu, na sikʉ zʉʉsi akaja momoteera na kʉgambana na bhanʉ aahunɨɨnɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Neho abhaatʉ obhorebhe bhu ubhwʉbhʉʉri bhanʉ bhakubhirikirwa Abhɨɨpikuuriyo, na Abhasitʉikʉ, bhakahunana na Paaurʉ. Hanʉ aarɨ akʉbharwazɨra igʉrʉ wa Yɨɨsu nu ukuryʉka kwazɨ, bhakabhuga, “Nɨ‑mangʼanakɨ ganʉ ʉmʉparuki wʉnʉ areenda kʉgamba?” Abhandɨ bhakabhuga, “Ɨrarorekana aragambɨra igʉrʉ wa amasambwa gɨ ɨɨsɨ ɨyɨndɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bhakagwata Paaurʉ, bhakamuhira mʉbhʉtangɨ bhwi ichandarʉ ɨkɨkʉrʉ kɨnʉ kikubhirikirwa Areopaago, ichandarʉ kɨkamʉbhʉʉrɨra, “Toreenda kwigwa amiija amahya ganʉ ukwija abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Awɨ ʉrareeta amangʼana amagini mʉmatwɨ gɨɨtʉ, nangʉ toreenda komenya enzobhooro yaku.” ");
INSERT INTO ikz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ribhaga riyo abhaatʉ bha Asɨnɨ, hamwɨmwɨ na abhagini bhanʉ bhaarɨ bhariikara iyo, bhaarɨ bhataana mweya gwi ingʼana ryʉryʉsi kuruushaku ukwitegeerera, na kwibhisirirya amangʼana amahya. ");
INSERT INTO ikz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mmbe Paaurʉ akiimɨɨrɨra kuchandarʉ cha Areopaago, akabhuga, “Imwɨ abhaatʉ bha Asɨnɨ, nɨrarora kʉmangʼana gʉʉsi, nɨ‑bhaatʉ bha kwiseega bhʉkʉngʼu amangʼana go okosengera. ");
INSERT INTO ikz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Hanʉ naarɨ nɨragenda kʉrʉbhɨri rʉnʉ, nɨkarora amangʼana gʉ ʉbhʉsɨngɨri bhwanyu. Nɨkarora na ahagero hu ukuhurukirya ikimweso, haandikirwɨ, Kwa Mungu wʉnʉ atamɨnyɨkɨɨnɨ. Mungu wʉnʉ imwɨ mokosengera mʉtamwɨzɨ, newe nɨkʉbharwazɨra. ");
INSERT INTO ikz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Newe Mungu wʉnʉ atɨɨmirɨ risaarʉ nɨ ɨɨsɨ na bhyʉsi bhɨnʉ bhirimu, newe Ʉmʉkʉrʉ wɨ ɨɨsɨ na risaarʉ, atakwikara mʉmahekaaru ganʉ gʉʉmbakirwɨ kʉmabhoko ga abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Atakohocherwa na abhaatʉ nkina akwenda kegero chʉchʉsi, kʉ kʉbha ewe newe akʉbhaha abhaatʉ bhʉʉsi ubhwikari, ʉbhʉhʉru ne ebhegero bhyʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Akabhʉmba abhaatʉ bha mubhyarʉ bhyʉsi kurwa kʉmʉʉtʉ wʉmwɨ korereke bhiikarɨ kʉʉsɨ yʉʉsi. Akabhatʉʉrɨra na ribhaga ryu ukwikara, nʉ ʉbhʉtaanɨrʉ bhwa ahagero haabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mungu akʉrirɨ gayo gʉʉsi korereke abhaatʉ bhamomohye. Yangabha kwa kʉbhabhaatabhabhaata kuhika bhamorore, nangabha atarɨ kore na niitwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ku ukugwatana neewe turiikara bhahʉru na tʉragenda, chɨmbu abhaatʉ bhaanyu bhamashairi bhaamarirɨ kʉgamba, ‘Itwɨ nɨ‑bhaana bhaazɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Mmbe arɨɨbhɨ itwɨ nɨ‑bhaana bha Mungu, tʉtakwenderwa kwiseega kʉbha Mungu atuubhɨɨnɨ nɨ ɨzahaabhu hamwɨ zimpirya, hamwɨ riibhwɨ hamwɨ ebhegero bhɨnʉ bhɨbhaazirwɨ nʉ ʉbhʉkʉnzi bhwa abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ɨkarɨ ribhaga ryo obhogeege, Mungu akiikorya nkina atakorora. Nawe nangʉ, arabhabhʉʉrɨra abhaatʉ bhʉʉsi bha mbaara zʉʉsi, bhatigɨ ʉbhʉbhɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Igʉrʉ wa riyo atɨɨrɨ urusikʉ rʉnʉ arɨɨtɨnɨrɨ abhaatʉ bhʉʉsi koheene, kʉnzɨra yo omorobhorwa waazɨ. Akabheerecha abhaatʉ bhʉʉsi amaheene ga gayo ku kuryʉra ʉmʉʉtʉ wuyo kurwa mʉbhaku.” ");
INSERT INTO ikz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hanʉ abhakʉrʉ bhayo bhiigwirɨ kʉbha Paaurʉ agambirɨ igʉrʉ wu ukuryʉka kwa abhaku, abhamwɨ bhakamorega. Nawe abhandɨ bhakamʉbhʉʉrɨra, “Tʉraaza kukwitegeerera naatu, igʉrʉ wa amangʼana gayo.” ");
INSERT INTO ikz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mmbe Paaurʉ akarwa muchandarʉ cha abhakʉrʉ kiyo. ");
INSERT INTO ikz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nawe abhaatʉ abhandɨ bhakagwatana nawe, bhakiisirirya Yɨɨsu. Gatɨ waabhʉ aarɨ areho Diyʉniisiyʉ, wʉmwɨ wi ichandarʉ cha Areopaago, nʉ ʉmʉkari wʉmwɨ iriina ryazɨ Damaari, hamwɨmwɨ na abhaatʉ abhandɨ. ");
INSERT INTO ikz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hanʉ amangʼana gayo gaasirirɨ, Paaurʉ akarwa Asɨnɨ, akaja kʉrʉbhɨri rwa Kʉrintʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akarumana nʉ Ʉmʉyaahudi wʉmwɨ arabhirikirwa Akiira, umwibhurwa wi icharʉ cha Ponto. Akiira hamwɨmwɨ na mʉkaazɨ Pirisiira, bhaarɨ bharuurɨ kʉrʉbhɨri rwa Ruumi kʉʉsɨ ya Itaariya, kʉ kʉbha Kaisaari Kiraudiyʉ aarɨ aswajiryɨ Abhayaahudi bhʉʉsi bhaheebhwe kʉrʉbhɨri ruyo. Paaurʉ akaja kʉbharora, ");
INSERT INTO ikz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kʉ kʉbha aarɨ arakora emeremo ju ukutuma ritundubhaari nche ebho, akasaaga ɨwaabhʉ hayo na kokora emeremo hamwɨmwɨ nabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sikʉ zʉʉsi zʉ ʉbhʉtʉʉrʉ, Paaurʉ aarɨ kuja mwirwazɨrʉ rya Abhayaahudi, na kurwaza nabhʉ igʉrʉ wa Yɨɨsu. Aarɨ aragema kʉbharuta Abhayaahudi na Abhagiriki korereke bhiisiriryɨ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Hanʉ Siira na Timoseo bhaahikirɨ kurwa Makɨdʉniya, Paaurʉ akahurucha ribhaga ryazɨ ryʉsi kwija ɨngʼana ya Mungu kʉBhayaahudi, akabhamenyeekererya kʉbha Yɨɨsu newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Abhayaahudi bhayo bhakatanga kʉhakaana neewe na kʉmʉtʉka bhʉkʉngʼu, akakʉngʼʉta zengebho zaazɨ, akabhabhʉʉrɨra, “Amasaahɨ gaanyu gabhɨ igʉrʉ waanyu imubheene! Inyɨ, nɨtaana bhʉbhɨ, nɨmarirɨ kokora ganʉ naarɨ nereenderwa kokora. Kwɨma nangwɨnʉ, nɨraja kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Akʉmara Paaurʉ akarwa mwirwazɨrʉ rya Abhayaahudi, akasikɨra munyumba ya Tiitʉ Yuusitʉ, ʉmʉsɨngɨri wa Mungu. Inyumba yaazɨ yaarɨ haguhɨ na rirwazɨrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ʉmʉkangati wa rirwazɨrʉ riyo, iriina ryazɨ Kiriisipʉ, akiisirirya Ʉmʉkʉrʉ Yɨɨsu, hamwɨmwɨ na abhaatʉ bhʉʉsi bhɨ ɨwaazɨ. Abhakʉrintʉ bhaaru bhanʉ bhiitɨgɨɨrɨɨrɨ Paaurʉ, bhakiisirirya na kʉbhatiizwa. ");
INSERT INTO ikz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ubhutikʉ bhʉmwɨ Ʉmʉkʉrʉ akamʉbhʉʉrɨra Paaurʉ kʉbhʉrʉri akabhuga, “Ʉtʉʉbhaha, ʉkajɨ kʉbharwazɨra, ʉtakira. ");
INSERT INTO ikz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Inyɨ nɨrɨ hamwɨmwɨ na naawɨ, atareeho ʉmʉʉtʉ wʉwʉʉsi wʉnʉ arakwitanʼyɨ korereke akʉnyahaarɨ, kʉ kʉbha kʉrʉbhɨri rʉnʉ abhaatʉ bhaaru bharɨ ʉrʉbhaara rwanɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paaurʉ akiikara Kʉrintʉ, ariija ɨngʼana ya Mungu umwaka gʉmwɨ ni imyɨri ɨsaasabha. ");
INSERT INTO ikz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nawe ribhaga ryʉ ʉbhʉkʉrʉ bhwa Gariiyʉ, umwanangwa wi Ikiruumi mucharʉ cha Akaaya, Abhayaahudi bhakaseeta Paaurʉ, bhakamugwata na kumuhira mwibharaza. ");
INSERT INTO ikz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bhakamʉgamba bharabhuga, “Ʉmʉʉtʉ wʉnʉ ahaakorokomba abhaatʉ korereke bhasengere Mungu kʉnzɨra yɨnʉ ɨtakwenderwa ni imigirʉ jɨtʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Hanʉ Paaurʉ ɨɨndirɨ kʉgamba, Gariiyʉ akabhʉʉrɨra Abhayaahudi, “Mwangabhɨɨrɨ mwarɨrɨɨrɨra igʉrʉ wʉ ʉkʉsarya imigirʉ ji Ikiruumi hamwɨ ʉbhʉbhɨ, yaarɨ bhwaheene kubhiitegeerera. ");
INSERT INTO ikz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nawe kʉ kʉbha ni‑gʉrʉ wa amangʼana, amariina ni imigirʉ janyu, mʉgamarɨ imwɨ abheene. Nɨtakwenda kʉbha umutiniri wa amangʼana gayo.” ");
INSERT INTO ikz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Akabhaheebha kurwa mwibharaza. ");
INSERT INTO ikz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Neho bhʉʉsi bhakagwata Sʉsitɨɨnɨ, ʉmʉkangati wa rirwazɨrʉ, bhakamotema hayohayo mʉbhʉtangɨ bhwa ichandarʉ. Nawe Gariiyʉ ataagiirɨ nagʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Hanʉ gayo gaahitirɨ Paaurʉ akangʼeha kwikara Kʉrintʉ kwibhaga, akaragana na abhiisirirya abhakɨndichazɨ. Akaja kʉrʉbhɨri rwa Kɨnkireya, akamwa zinzwɨrɨ zaazɨ, kʉ kʉbha aarɨ atɨɨrɨ ʉbhʉragɨ. Neho Paaurʉ, Pirisiira na Akiira, bhakatiira ubhwatʉ bhakaambʉka mʉnyanza bhakeerekera ɨɨsɨ ya Siiriya. ");
INSERT INTO ikz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Hanʉ bhaahikirɨ Efeeso, Paaurʉ akatiga abhakɨndichazɨ iyo. Ewe akasikɨra mwirwazɨrʉ akagambana na Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Abhayaahudi bhayo bhakasabha Paaurʉ ongere zisikʉ zʉ ʉkʉbha nabhʉ, atiisiriiryɨ. ");
INSERT INTO ikz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Hanʉ aarɨ akurweho akabhabhʉʉrɨra, “Hanʉ Mungu araasɨɨgɨ, nɨragarʉka kʉbhaniimwɨ naatu.” Akʉmara akagega ubhwatʉ akarwa Efeeso. ");
INSERT INTO ikz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hanʉ aahikirɨ kʉrʉbhɨri rwa Kaisaariya, akaja Yɨrusarɨɨmu, akakeerya abhaatʉ bha risengerero, akʉmara akaja kʉrʉbhɨri rwa Antiyʉkiya. ");
INSERT INTO ikz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Hanʉ aamarirɨ sikʉ suuhu, akarwa hayo, akahʉrʉkɨra icharʉ cha Garaatiya na kucharʉ cha Furigiya, kʉbhataarɨra na kʉbhaha umwʉyʉ abhɨɨga bhʉʉsi bha Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kwibhaga riyo akaaza Mʉyaahudi wʉmwɨ kʉrʉbhɨri rwa Efeeso, iriina ryazɨ Apooro, umwibhurwa wa Arɨkizandiriya. Aarɨ wʉ ʉbhʉnaja ʉbhʉkʉrʉ bhʉ ʉkʉgamba, nu ukwobhoora bhwaheene Amaandɨkʉ Amarɨndu. ");
INSERT INTO ikz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aarɨ ijibhwɨ ɨnzɨra yʉ Ʉmʉkʉrʉ, na aarɨ nu umucha mokoro yaazɨ. Akiija kwa bhʉkararu na kwe eheene igʉrʉ wa Yɨɨsu, nangabha aarɨ yɨɨzɨ igʉrʉ wʉ ʉbhʉbhatiizi bhwa Yoohana ubhwene. ");
INSERT INTO ikz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apooro akatanga kʉgambana kwa bhʉkararu mwirwazɨrʉ rya Abhayaahudi. Hanʉ Pirisiira na Akiira bhaamwitɨgɨɨrɨɨrɨ bhakamuginihya ɨwaabhʉ, bhakamʉragɨrɨra amangʼana gɨ ɨnzɨra ya Mungu chɨmbu ɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Hanʉ Apooro ɨɨndirɨ kuja kʉʉsɨ ya Akaaya, abhiisirirya bha Efeeso bhakamoha umwʉyʉ, bhakamwandɨkɨra ɨnyarʉbha yo okomomenyeekererya kʉbhɨɨga bhi iyo. Hanʉ aahikirɨ iyo, akabhasakirya bhʉkʉngʼu abhaatʉ bhanʉ bhaarɨ bhiisiriiryɨ kʉbhɨgʉngi bhya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apooro akahiza Abhayaahudi bhanʉ bhaarɨ bharahakaana neewe mʉbhʉtangɨ bhwa abhaatʉ bhʉʉsi habhwɨrʉ, arabheerecha kʉMaandɨkʉ Amarɨndu kʉbha Yɨɨsu newe Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ribhaga rɨnʉ Apooro aarɨ Kʉrintʉ, Paaurʉ akahɨta kʉzɨmbɨri za mʉbhɨgʉrʉ, akahika kʉrʉbhɨri rwa Efeeso. Iyo akabhabhona abhɨɨga obhorebhe, ");
INSERT INTO ikz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","akabhabhuurya, “Heene mʉkasʉngʼaana Ekoro Ɨndɨndu hanʉ mwisiriiryɨ Yɨɨsu?” Bhakamʉgarukirya, “Zɨyi, nʉʉrʉ kwigwa kʉna Ekoro Ɨndɨndu tutiigwirɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Akabhabhuurya, “Mʉkabhatiizwa bhʉbhatiizikɨ?” Bhakamʉbhʉʉrɨra, “Tʉkabhatiizwa ʉbhʉbhatiizi bhwa Yoohana.” ");
INSERT INTO ikz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Neho Paaurʉ akabhabhʉʉrɨra, “Yoohana aarɨ arabhatiiza abhaatʉ bhanʉ bhaarɨ bharatiga ʉbhʉbhɨ bhwabhʉ. Ewe akabhiija kʉbha, bhiisiriryɨ wʉnʉ akuuza inyuma waazɨ, Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hanʉ bhiigwirɨ amangʼana gayo, bhakabhatiizwa kuriina ryʉ Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Hanʉ Paaurʉ aamarirɨ kʉbhatʉʉrɨra amabhoko gaazɨ igʉrʉ waabhʉ, Ekoro Ɨndɨndu ɨkabhiikɨra, bhakatanga kʉgamba kʉkɨgambʉ ikihya na korootorera. ");
INSERT INTO ikz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Abhaatʉ bhayo bhaarɨ bhariisemera kuhika abhasubhɨ ikumi na bhabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwibhaga ryi imyɨri ɨtatʉ Paaurʉ aarɨ arasikɨra mwirwazɨrʉ na kʉgambana nabhʉ kwa bhʉkararu. Aarɨ aragambana na abhaatʉ na kʉkandikija bhiisiriryɨ amangʼana gʉ ʉbhʉtɨmi bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nawe abhaatʉ abhandɨ gatɨ waabhʉ bhakabha na zekoro kʉngʼu, bhakaanga kwisirirya amangʼana ga Yɨɨsu. Bhakatanga kʉyɨtʉka ɨnzɨra ya Yɨɨsu mʉbhʉtangɨ bhwa abhaatʉ. Paaurʉ akabhatiga, akaahʉra abhɨɨga, akaja nabhʉ munyumba yu ukwɨgɨra yʉ ʉmʉʉtʉ wʉmwɨ arabhirikirwa Tiraanʉ. Sikʉ zʉʉsi aarɨ aragambana na abhaatʉ igʉrʉ wa Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Akangʼeha kokorabhu kwibhaga ryi imyaka ɨbhɨrɨ, na abhaatʉ bhʉʉsi bhi icharʉ cha Asiya, Abhayaahudi hamwɨmwɨ na Abhagiriki, bhakiigwa ɨngʼana yʉ Ʉmʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kʉhɨtɨra amabhoko ga Paaurʉ, Mungu akakora ɨbhɨsɨgʉ bhyu ukuruguurya. ");
INSERT INTO ikz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Abharwɨrɨ bhakahirirwa ɨbhɨtambaara na zengebho zɨnʉ Paaurʉ aazikuniryɨ, neho bhakahora na amasambwa gʉʉsi gakabharwɨku. ");
INSERT INTO ikz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bhaareho Abhayaahudi abhandɨ bhanʉ bhaarɨ bharataamataama ɨnʉ ni irya bharaheebha amasambwa kʉbhaatʉ. Bhayo bhakagema kokorera iriina ryʉ Ʉmʉkʉrʉ Yɨɨsu kʉbhʉʉrɨra amasambwa, “Nɨrabhaswaja kuriina rya Yɨɨsu wʉnʉ Paaurʉ akurwaza, murwɨ kʉmʉʉtʉ wʉnʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gatɨ wa bhanʉ bhaarɨ bharakorabhu, bhaarɨ abhaana muhungatɨ bhʉ Ʉmʉyaahudi wʉmwɨ arabhirikirwa Sikɨwa, wʉnʉ aarɨ ʉmʉkʉrʉ wʉmwɨ wa abhakuhaani. ");
INSERT INTO ikz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nawe risambwa rɨkabhagarukirya, “Yɨɨsu nɨmʉmɨnyirɨ, Paaurʉ wʉʉsi nɨmʉmɨnyirɨ, nawe imwɨ, nɨ‑bha wɨɨwɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Neho ʉmʉʉtʉ wurya risambwa ryarɨ ritiirirɨ, akabhabhururukɨra abhaatʉ bhayo, akabhahiza zinguru. Akabhatema, kuhika bhakaryarɨra igʉtʉ bharɨ tʉʉhʉ na bhanyahaarikirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Amangʼana gayo gakanyaragana bhʉkʉngʼu Efeeso hayo, kʉBhayaahudi na Abhagiriki. Bhayo bhʉʉsi bhakagwatwa nu ubhwʉbha, bhakagʉnga iriina ryʉ Ʉmʉkʉrʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abhaatʉ bhaaru bhanʉ bhaarɨ bhiisiriiryɨ Yɨɨsu bhakiisasaama mʉbhʉtangɨ bhwa abhaatʉ amangʼana gaabhʉ amabhɨ ganʉ bhaarɨ bhakʉrirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bhanʉ bhaarɨ bharakora amangʼana gʉ ʉbhʉgabhʉ bhakareeta ɨbhɨtabhʉ bhyabhʉ, akabhyʉcha no omorero mʉbhʉtangɨ bhwa abhaatʉ bhʉʉsi. Bhakakora ubhuguri bhwɨ ɨbhɨtabhʉ, bhʉkahika bhɨkwɨ merongo ɨtaanʉ bhya zimpirya. ");
INSERT INTO ikz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ɨbhu nɨmbu ɨngʼana yʉ Ʉmʉkʉrʉ yaarɨ ɨranyaragana na kʉbha na zinguru gatɨ wa abhaatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hanʉ amangʼana gayo gʉʉsi gaasirirɨ, Paaurʉ akabha na amiisɨɨgi gʉ ʉkʉhɨta mucharʉ cha Makɨdʉniya na cha Akaaya ajɨ Yɨrusarɨɨmu. Akabhuga, “Nɨrɨɨmarɨ kuhika Yɨrusarɨɨmu, ereenderwa nihikɨ nʉ ʉrʉbhɨri rwa Ruumi.” ");
INSERT INTO ikz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Akatʉma abhasakirya bhaazɨ bhabhɨrɨ, Timoseo na Ɨraasitʉ, bhajɨ Makɨdʉniya, ribhaga riyo ewe akasaaga kʉʉsɨ ya Asiya. ");
INSERT INTO ikz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ribhaga riyo Efeeso hayo, kʉkakorebhwa rirɨgɨ ikʉrʉ bhʉkʉngʼu igʉrʉ wa riribhita rya abhahɨmba bhɨ ɨnzɨra ya Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kʉrʉbhɨri ruyo, areho ʉmʉʉtʉ wʉmwɨ umuturi wa zimpirya, iriina ryazɨ arabhirikirwa Dɨmɨtiriyʉ. Aarɨ arabhaaza amasambwa ganʉ gatuubhɨɨnɨ ni inyumba ya risambwa ryabhʉ ryɨ ɨkɨkari, rɨnʉ ryabhirikiirwɨ Aritɨɨmi. Na bhaarɨ bharakora emeremo neewe, emeremo giyo gɨkabhaha abhaturi ubhwera bhʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Rusikʉ rʉmwɨ Dɨmɨtiriyʉ akabhiringa abhaturi abhakɨndichazɨ, hamwɨmwɨ na abhaatʉ abhandɨ bhanʉ bhaarɨ bharakora emeremo giyo. Akabhabhʉʉrɨra, “Imwɨ abhaatʉ bhɨɨtʉ, mwɨzɨ bhwaheene kʉbha ubhuniibhi bhwɨtʉ bhʉhaabhoneka komeremo gɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nawe nangʉ mwigwirɨ na mʉrʉʉzɨ Paaurʉ wuyo chɨmbu akuruta abhaatʉ bhaaru bha Efeeso hanʉ, hamwɨmwɨ na bhanʉ bharɨ mbaara zʉʉsi zɨ ɨɨsɨ ya Asiya. Abhachurirɨ abhaatʉ bhaaru ubhwɨndi bhwabhʉ kwa kubhuga kʉbha, gayo gakokorwa kwa amabhoko nɨ‑masambwa ganʉ gataana nguru. ");
INSERT INTO ikz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nangʉ, nɨrʉʉbhaha kʉbha, emeremo jɨtʉ gɨnʉ gɨraregwa bhʉkʉngʼu. Inyumba ya risambwa ryɨtʉ rikʉrʉ Aritɨɨmi yʉʉsi ɨrarorwa kʉbha ɨtaana nzobhooro. Na Aritɨɨmi wʉnʉ ahaasengerwa Asiya ni ibhyarʉ bhyʉsi, araruusibhwa ʉbhʉkʉrʉ bhwazɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Amangʼana ga Dɨmɨtiriyʉ gayo gakabhabhiihya imitwɨ bhʉkʉngʼu abhaturi abhakɨndichazɨ bhayo. Bhakarɨgɨsa, “Aritɨɨmi wa Abheefeeso newe ʉmʉkʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ʉrʉbhɨri rwʉsi rwa Efeeso rukiizʉra rirɨgɨ. Abhaatʉ bhakagwata Gaayo na Arisitʉʉrikʉ, abhaatʉ bha Makɨdʉniya bhanʉ bhaarɨ bharagenda hamwɨmwɨ na Paaurʉ, bhakasikɨra neebho bhwangʉ mwigoobhe rya amabharaana. ");
INSERT INTO ikz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paaurʉ akeenda imɨɨrɨrɨ gatɨgatɨ wa abhaatʉ bhayo, nawe abhɨɨga abhakɨndichazɨ bhatamwisiririiryɨ. ");
INSERT INTO ikz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na abhasaani bhaazɨ obhorebhe abhakʉrʉ bha Asiya hayo, bhakamuhirɨra amangʼana gu ukumwisasaama kʉbha atasikɨra mwigoobhe rya ribharaana kʉbhaatʉ bhayo. ");
INSERT INTO ikz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ribhaga riyo abhaatʉ bhakakora rirɨgɨ bhʉkʉngʼu, abhandɨ ringʼana rɨnʉ, abhandɨ ringʼana rirya, kʉ kʉbha ikiikarʉ charɨ kibhuruurirɨ na bhaaru gatɨ waabhʉ bhataamɨnyirɨ kɨnʉ kigiriryɨ bhiibhiringirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Abhayaahudi bhakasukuma Arɨkizanda mʉbhʉtangɨ bhwa abhaatʉ bhayo, kwɨbhu abhandɨ bhakakina kʉbha rirɨgɨ riyo ryarɨ igʉrʉ waazɨ. Neho Arɨkizanda akabhanʉngɨra amabhoko abhaatʉ bhayo bhʉʉsi kʉbha bhakirɨ, kʉ kʉbha aarɨ areenda kwibhagɨra mʉbhʉtangɨ bhwabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nawe hanʉ bhʉʉbhʉʉrirɨ kʉbha nɨ‑Mʉyaahudi, bhʉʉsi bhakangʼeha kʉrɨgɨsa kwiraka rɨmwɨ kwɨ ɨsa ibhɨrɨ bharabhuga, “Aritɨɨmi wa Abheefeeso newe ʉmʉkʉrʉ!” ");
INSERT INTO ikz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mʉtɨnɨrʉ umwandiki wʉ ʉrʉbhɨri ruyo akakirya abhaatʉ akabhabhʉʉrɨra, “Imwɨ abhaatʉ bha Efeeso, nɨ‑wɨɨwɨ wʉnʉ atɨɨzɨ ʉrʉbhɨri rwa Efeeso, negwe gukuriibha risengerero rya risambwa rikʉrʉ Aritɨɨmi, hamwɨmwɨ na risambwa ryazɨ ryʉ ʉkʉbhaaza, rɨnʉ ryagwirɨ kurwa mwisaarʉ? ");
INSERT INTO ikz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mmbe kʉ kʉbha atareeho ʉmʉʉtʉ wʉnʉ akʉtʉra kwanga amangʼana ganʉ, kwɨbhu moreendebhwa mukirɨ, naatu mʉtakora ingʼana ryʉryʉsi kwa bhwangʉ bhwangʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nɨrabhugabhu kʉ kʉbha abhaatʉ bhanʉ mwarɨɨtirɨ hanʉ, bhatiibhirɨ ekegero munyumba ya amasambwa nʉʉrʉ kʉmʉtʉka risambwa ryɨtʉ, Aritɨɨmi. ");
INSERT INTO ikz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","“Arɨɨbhɨ Dɨmɨtiriyʉ na abhaturi abhakɨndichazɨ bhaana ɨngʼana igʉrʉ wʉ ʉmʉʉtʉ wʉwʉʉsi, tuni ichandarʉ na abhatiniri bhi imigirʉ bhʉʉsi bhareho. Hayo neho Dɨmɨtiriyʉ na abhaturi abhakɨndichazɨ bhareenderwa kʉgamba abhaatʉ bhanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Arɨɨbhɨ mʉna amangʼana agandɨ, mʉgahirɨ kuchandarʉ kɨnʉ kikwisiriribhwa ni imigirʉ jɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ganʉ tʉkʉrirɨ reero garatʉra kugirya tʉgambwɨ kʉbha tʉkʉrirɨ rirɨgɨ. Tʉrɨɨgambwɨ tʉtaana ingʼana rɨnʉ rɨkʉtʉra kʉtʉbhagɨra, kʉ kʉbha rirɨgɨ rɨnʉ rɨtaana nzobhooro.” ");
INSERT INTO ikz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hanʉ umwandiki aamarirɨ kʉbhʉʉrɨra abhaatʉ bhayo, akabhanyaraganʼya bhajɨ yɨɨka. ");
INSERT INTO ikz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hanʉ rirɨgɨ rya Efeeso hayo ryasirirɨ, Paaurʉ akabhabhɨrɨkɨra abhɨɨga, akabhaha umwʉyʉ, akabharaga, akaja mucharʉ cha Makɨdʉniya. ");
INSERT INTO ikz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akahɨta kʉʉsɨ yiyo, arabhabhʉʉrɨra Abhakiriisitʉ amangʼana maaru gʉ ʉkʉbhaha umwʉyʉ, akʉmara akahika Ugiriki. ");
INSERT INTO ikz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Akamara iyo myɨri ɨtatʉ, akabhanʉra kuja kʉʉsɨ ya Siiriya kubhwatʉ. Nawe akabhona amangʼana kʉbha, Abhayaahudi bhaarɨ bhariiseemerya komokorera amabhɨ, ɨkagirya akahʉrʉkɨra Makɨdʉniya. ");
INSERT INTO ikz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Korogendo rʉnʉ Paaurʉ akahirana na Sʉpatiirʉ umwana wa Piirʉ kurwa Bherooya, hamwɨmwɨ na Sɨkundʉ na Arisitʉʉrikʉ kurwa Tɨsarʉʉnikɨ, Gaayo kurwa Dɨribhɨ, Timoseo, na Tikikʉ na Tʉrʉfimʉ kurwa Asiya. ");
INSERT INTO ikz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Abhaatʉ bhayo bhakakangata bhakaja kʉtʉrɨnda kʉrʉbhɨri rwa Turowa. ");
INSERT INTO ikz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Hanʉ isigukuru yɨ Ɨmɨkaatɨ Gɨnʉ Gɨtarɨ Mitunduuru yaahitirɨ, tʉkarwa kʉrʉbhɨri rwa Firipi. Tʉkaja orogendo rwa sikʉ isaanʉ, tʉkahika kʉrʉbhɨri rwa Turowa, hayo neho tʉkahunana na abhakɨndichɨtʉ bhayo. Tukiikara hayo sikʉ muhungatɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hanʉ urusikʉ rwʉ ʉbhʉtangɨ rwi inyuma rwahikirɨ, tukiibhiringa hamwɨmwɨ, korereke tusunyurɨ ʉmʉkaatɨ. Paaurʉ akabhʉʉrɨra abhaatʉ ɨngʼana ya Mungu, kuhika ubhutikʉ gatɨ, kʉ kʉbha aarɨ akarɨɨrɨ kurwa hayo tabhʉʉri waho. ");
INSERT INTO ikz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Muchumba che egorofa mʉnʉ twarɨ, kwarɨ nɨ ɨbhɨmʉrɨ bhyaru bhɨraaka. ");
INSERT INTO ikz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kwidirisha rya muchumba kiyo aarɨ ikɨɨrɨ umumura wʉmwɨ, iriina ryazɨ Ɨutikʉ. Ɨutikʉ akatanga kusundagɨra kuhika zɨkahira, ɨnʉ Paaurʉ aarɨ arakaja kwija kwi ibhaga irɨɨhu. Hanʉ aarɨ mozendooro za turu, akagwa kurwa muchumba che egorofa ya katatʉ, akiitema haasɨ puu! Hanʉ bhaamunungirɨ, bhakabhona akuurɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paaurʉ wʉʉsi akiika haasɨ, akahindɨra igʉrʉ wa Ɨutikʉ, akamuhumbata, akabhʉʉrɨra abhaatʉ bhayo, “Mʉtʉʉbhaha! Wʉnʉ nɨ‑mʉhʉru!” ");
INSERT INTO ikz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Akʉmara Paaurʉ akatiira mogorofa, akasunyura ʉmʉkaatɨ akarya. Akangʼeha kwija kwi ibhaga irɨɨhu kuhika ritabhʉʉri, neho akarweho. ");
INSERT INTO ikz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Abhaatʉ bhayo bhakamohereekerera Ɨutikʉ, bhakamuhicha yɨɨka mʉhʉru, bhakazomerwa bhʉkʉngʼu. ");
INSERT INTO ikz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paaurʉ akagenda na amagʉrʉ kuja kʉrʉbhɨri rwa Aaso. Itwɨ tʉkajayo kubhwatʉ, korereke tuhunanɨ, kʉ kʉbha tukiisiriranʼya neewe kʉbha tʉramogega. ");
INSERT INTO ikz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Hanʉ aatubhwɨnɨ Aaso, tʉkamogega kubhwatʉ, tʉkaja hamwɨmwɨ kuhika kʉrʉbhɨri rwa Mitureene. ");
INSERT INTO ikz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hanʉ bhwɨrirɨ, tokangʼeha no orogendo rwa mʉnyanza, tʉkahika rusizʉ wa riginga rya Kiyʉ. Tabhʉʉri waho, tʉkaambʉka ɨnyanza tʉkahika kwiginga rya Saamo, tukiikara Turʉgiriyʉ. Urusikʉ rʉnʉ rwabhatirɨ, tʉkahika kʉrʉbhɨri rwa Mireeto. ");
INSERT INTO ikz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paaurʉ atɨɨndirɨ tʉhʉrʉkɨrɨ kʉrʉbhɨri rwa Efeeso, ataaza kokeezera kʉʉsɨ ya Asiya hayo. Aarɨ areenda kuhika Yɨrusarɨɨmu bhwangʉ, korereke angʉhɨ urusikʉ rwa Pɨntɨkʉsitɨ, arɨɨbhɨ ɨratʉrɨkana. ");
INSERT INTO ikz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ribhaga rɨnʉ Paaurʉ aarɨ Mireeto hayo, akatʉmanʼya abhiimiiririri bha risengerero rya Efeeso bhahunanɨ neewe. ");
INSERT INTO ikz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Hanʉ bhaarɨ bhamuhikiirɨ akabhabhʉʉrɨra, “Imwɨ abheene mwɨzɨ chɨmbu niikɨɨrɨ gatɨgatɨ waanyu ribhaga ryʉsi, kwɨma urusikʉ rwe embere rurya nahikirɨ Asiya hanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Naarɨ nɨrahokerya Ʉmʉkʉrʉ kʉbhʉnyʉʉhu bhwʉsi, kuzingusuri, na kubhitiimotiimo kurwɨra koseemyo za Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mwɨzɨ kʉbha nɨtaatigirɨ kʉbharaganʼya ingʼana ryʉryʉsi ryʉ ʉkʉbhasakirya. Nɨkabhiija gayo habhwɨrʉ na muzinyumba zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nɨhaabhʉʉrɨra Abhayaahudi hamwɨmwɨ na abhaatʉ bhanʉ bhatarɨ Abhayaahudi, bhatigɨ ʉbhʉbhɨ bhwabhʉ, bhiichʉrɨrɨ Mungu na kwisirirya Ʉmʉkʉrʉ wɨɨtʉ Yɨɨsu. ");
INSERT INTO ikz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nangʉ, mwitegeerere! Inyɨ nɨrasʉʉka Ekoro Ɨndɨndu. Nɨraja Yɨrusarɨɨmu nʉʉrʉ nɨtɨɨzɨ ganʉ garaambone iyo. ");
INSERT INTO ikz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nɨmɨnyirɨ kʉbha ʉrʉbhɨri rwʉrwʉsi rʉnʉ nɨrɨɨhɨtɨ, Ekoro Ɨndɨndu ɨranyerecha kʉbha nɨrarekerwa mokebhoho na nɨrabhona ɨnyaakʉ. ");
INSERT INTO ikz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nawe nɨtakʉbhara ubhwikari bhwanɨ kʉbha ne‑kegero cha nzobhooro kwa niinyɨ, arɨɨbhɨ nɨtamarirɨ emeremo gɨnʉ Ʉmʉkʉrʉ Yɨɨsu antɨɨrɨ nekore. Emeremo giyo nɨ‑kʉragɨrɨra abhaatʉ Ɨngʼana Ɨnzʉmu yɨ ɨbhɨgʉngi bhya Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mwɨzɨ naarɨ nɨrahɨta gatɨ waanyu kurwaza igʉrʉ wʉ ʉbhʉtɨmi bhwa Mungu. Nawe nangʉ nɨmɨnyirɨ kʉbha, imwʉsi mʉtakondora naatu. ");
INSERT INTO ikz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nangʉ, nɨrabhabhʉʉrɨra, ʉmʉʉtʉ wʉwʉʉsi arɨɨbhʉrɨ mokoro, nɨtaana bhʉbhɨ igʉrʉ waazɨ, ");
INSERT INTO ikz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kʉ kʉbha rɨnʉ ryʉsi Mungu ɨndirɨ, naarɨ nɨbhabhuuriirɨ nɨtaahahirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ekoro Ɨndɨndu ɨbhatɨɨrɨ imwɨ mʉbhɨ abhiimiiririri. Nangʉ mʉbhɨ muriiyangarɨra, na muriibhɨ risengerero rya Mungu, kʉ kʉbha Mungu akarɨgʉra kʉmasaahɨ gu umwana waazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Nɨmɨnyirɨ kʉbha hanʉ rɨnʉ nɨraataanɨ na niimwɨ, abhaatʉ abhahaari bhariisikirya kwa niimwɨ, ncha zisuuzɨ zɨhaari mʉzɨngʼʉndu, bhatakʉbhabheerera. ");
INSERT INTO ikz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nʉʉrʉ gatɨ waanyu imubheene, bharabhʉʉka abhaatʉ bhanʉ bhakʉgamba amangʼana ganʉ gatarɨ ga amaheene, korereke bharutɨ abhɨɨga bhabhatunɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mwiyangarɨrɨ! Muhiitɨ kʉbha, nɨkamara imyaka ɨtatʉ nɨrabhahama imwʉsi, ubhutikʉ nu umwise kwa ngusuri nzaru. ");
INSERT INTO ikz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nangʉ nɨrabhatʉʉra mʉmabhoko ga Mungu, na kʉmangʼana gɨ ɨbhɨgʉngi bhyazɨ. Ewe aratʉra kʉbhakongʼya na kʉbhaha ɨgabhʉ hamwɨmwɨ na bhanʉ bhabhɨngukiibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Nɨtɨɨndirɨ mpirya za mʉʉtʉ wʉwʉʉsi, nʉʉrʉ ɨzahaabhu yaazɨ, nʉʉrʉ ngebho zaazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Imwɨ abheene mwɨzɨ bhwaheene, naarɨ nɨrakora emeremo kʉmabhoko gaanɨ, kobhona zimpirya zʉ ʉkʉgʉra ebhegero bhyʉsi hamwɨmwɨ na bhya abhakɨndichanɨ. ");
INSERT INTO ikz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kwa gʉʉsi gayo nakʉrirɨ, naarɨ nɨrabheerecha kʉbha toreenderwa kohocha emeremo, korereke tobhone ebhegero bhyʉ ʉkʉsakirya abhaatʉ bhanʉ bhataana ʉbhʉnaja. Toreenderwa naatu tuhiitɨ amangʼana ganʉ Ʉmʉkʉrʉ Yɨɨsu umwene aagambirɨ, ‘Ʉrʉbhangʉ ʉrʉkʉrʉ rʉrɨ ku kuhurucha kʉkɨra kʉ kʉsʉngʼaana.’ ” ");
INSERT INTO ikz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hanʉ Paaurʉ aamarirɨ kʉgamba amangʼana gayo, akahigama hamwɨmwɨ nabhʉ, akasabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Akʉmara bhʉʉsi bhakahumbata Paaurʉ na kʉrɨra kwa ngusuri nzaru. ");
INSERT INTO ikz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bhakarumɨka bhʉkʉngʼu hanʉ Paaurʉ aabhabhuuriirɨ kʉbha, bhatakomorora kwikɨ. Akʉmara bhakamohereekerera bhakamuhicha kubhwatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hanʉ twamarirɨ kʉragana na abhiimiiririri bha Efeeso bhayo, tʉkatiira mubhwatʉ tʉkaja kuriginga rya Kʉʉsi. Tabhʉʉri waho, tʉkaja kuriginga rya Roodo, na kurwa hayo, tʉkaja kʉrʉbhɨri rwa Pataara, ɨɨsɨ ya Asiya. ");
INSERT INTO ikz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tʉkabhona iyo ubhwatʉ ʉbhʉndɨ bhʉnʉ bhwarɨ bhukuja kʉʉsɨ ya Fʉinikɨ, tʉkatiira. ");
INSERT INTO ikz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Hanʉ twisukiirɨ riginga rya Kipurʉ na korerora, tʉkahɨta tʉkaretemera ʉrʉbhaara rwʉ ʉbhʉmʉsi, tokeerekera ɨɨsɨ ya Siiriya. Hanʉ twahikirɨ kʉrʉbhɨri rwa Tiiro, tukiika mubhwatʉ bhuyo, kʉ kʉbha hayo neho yaarɨ ereenderwa bhwichɨ imirigʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tʉkamohya abhɨɨga bha hayo tʉkabhabhona, tukiikara nabhʉ sikʉ muhungatɨ. Abhɨɨga bhayo kʉ kʉkangatwa ne Ekoro Ɨndɨndu, bhakabhʉʉrɨra Paaurʉ, atigɨ kuja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Hanʉ ribhaga ryɨtʉ ryʉ ʉkʉbha hayo ryasirirɨ tʉkabhʉʉka, abhɨɨga bhayo abhasubhɨ, abhakari na abhaana bhaabhʉ bhʉʉsi, bhakatohereekerera, bhakatuhicha igʉtʉ wʉ ʉrʉbhɨri. Itwʉsi tʉkahigama kukihuukʉ hayo, tʉkasabha Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Akʉmara tʉkaragana, tʉkatiira mubhwatʉ, bhʉʉsi bhakagarʉka ɨwaabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mmbe tʉkarwa Tiiro hayo, tʉkakaja orogendo rwɨtʉ, tʉkahika kʉrʉbhɨri rwa Tʉrɨmaayi. Tʉkabhakeerya abhiisirirya, tukiikara nabhʉ rusikʉ rʉmwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tabhʉʉri waho, tʉkarwa hayo, tʉkahika kʉrʉbhɨri rwa Kaisaariya. Tʉkaja wa Firipʉ, umurwazi wɨ Ɨngʼana Ɨnzʉmu ya Yɨɨsu, na aarɨ wʉmwɨ wa abhasubhɨ muhungatɨ bhanʉ bharʉbhwɨrwɨ kosondya abhaatʉ ibhyakurya. ");
INSERT INTO ikz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Firipʉ wuyo aarɨ na abhaacha bhane bhasiiti, na bhaarɨ bhanʉ ʉbhʉnaja bhwo okorootorera. ");
INSERT INTO ikz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Hanʉ twikɨɨrɨ zisikʉ nzaru, akaaza ʉmʉrʉʉtɨrɨri kurwa Yudeya, iriina ryazɨ Agabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Akaaza kwa niitwɨ, akagega umusipɨ gwa Paaurʉ, akiibhoha amagʉrʉ na amabhoko, akabhuga, “Ekoro Ɨndɨndu ɨrabhuga, ‘Nɨmbu Abhayaahudi bha Yɨrusarɨɨmu bhareebhohe ʉmʉʉtʉ wu umusipɨ gʉnʉ, na bharamʉtʉʉra mʉmabhoko ga abhaatʉ bhi ibhyarʉ ɨbhɨndɨ.’” ");
INSERT INTO ikz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hanʉ twigwirɨbhu, hamwɨmwɨ na abhakɨndichɨtʉ bha Kaisaariya, tukiisasaama Paaurʉ, ataja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nawe akagarukirya, “Mʉrakorabhwɨ kʉndɨrɨra na kunyita umwʉyʉ? Inyɨ niisiriiryɨ gʉʉsi, okobhohwa nʉʉrʉ ukwitwa Yɨrusarɨɨmu hayo, igʉrʉ wi iriina ryʉ Ʉmʉkʉrʉ Yɨɨsu.” ");
INSERT INTO ikz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Hanʉ aangirɨ agɨɨtʉ, tʉkamutiga tʉkabhuga, “Ʉbhʉsɨɨgi bhwʉ Ʉmʉkʉrʉ bhokorwe.” ");
INSERT INTO ikz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Akʉmara tʉkabhoha imirigʉ jɨtʉ, tʉkatanga orogendo rwu ukuja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Abhɨɨga obhorebhe bha Kaisaariya hayo, bhakatohereekerera bhakatuhicha wa Mʉnasʉmi, wʉnʉ twikɨɨrɨ nawe. Ʉmʉʉtʉ wuyo aarɨ ʉmʉʉtʉ wa riginga rya Kipurʉ na aarɨ wʉmwɨ wa abhɨɨga bhe embere. ");
INSERT INTO ikz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hanʉ twahikirɨ Yɨrusarɨɨmu hayo, abhiisirirya abhakɨndichɨtʉ bha hayo, bhakatuginihya bhwaheene. ");
INSERT INTO ikz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tabhʉʉri waho, tʉkaja na Paaurʉ, tʉkataarɨra Yaakobho na abhiimiiririri bha risengerero, bhʉʉsi bhaareho. ");
INSERT INTO ikz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paaurʉ akabhakeerya, aaza kʉmara akabhabhʉʉrɨra amangʼana gʉʉsi ganʉ Mungu aakʉrirɨ kʉbharya bhatarɨ Abhayaahudi, kʉrɨngʼaana na amahocha gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hanʉ Yaakobho na abhiimiiririri bha risengerero bhiigwirɨ gayo, bhakakumya Mungu. Bhakabhʉʉrɨra Paaurʉ, “Umuhiiri wɨɨtʉ, ʉrarora ɨbhɨkwɨ nɨ ɨbhɨkwɨ bhya Abhayaahudi bhiisiriiryɨ Yɨɨsu, na bhʉʉsi bharaangarɨra bhʉkʉngʼu imigirʉ ja Musa. ");
INSERT INTO ikz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nawe bhabhuuriirwɨ kʉbha, ʉrabhiija Abhayaahudi bhʉʉsi bhanʉ bhakwikara kʉzɨɨsɨ ɨzɨndɨ, bhatigɨ kutuna imigirʉ ja Musa. Bharabhuga ʉkabhaangirija kʉsaara abhaana bhaabhʉ, na bhatatuna amanarʉ gɨ Ɨkɨyaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nangʉ, tokorebhwɨ? Amaheene Abhayaahudi bhayo bharabhona amangʼana kʉbha ʉrɨ hanʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nangʉ kora chɨmbu tʉkʉkʉbhʉʉrɨrɨ. Gatɨgatɨ wɨɨtʉ bhareho abhasubhɨ bhane, bhanʉ bhatɨɨrɨ ubhwirahiri mʉbhʉtangɨ bhwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Muhiranɨ wiibhɨngukyɨ hamwɨmwɨ nabhʉ. Ʉbharɨhɨrɨ zimpirya, korereke bhamwebhwe zinzwɨrɨ kutuna imigirʉ. Abhaatʉ bhʉʉsi bharamenya kʉbha, gayo gʉʉsi bhakʉgamba igʉrʉ waazʉ, gatarɨ ga amaheene na bharamenya kʉbha naawɨ aumwene okongʼeha kwigwa imigirʉ ja Musa. ");
INSERT INTO ikz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Nawe kʉrʉbhaara rwa abhaatʉ bhanʉ bhatarɨ Abhayaahudi bhanʉ bhakwisirirya Yɨɨsu, tʉkabhaandɨkɨra ɨnyarʉbha ya amangʼana ganʉ twatiniirɨ: bhatarya ibhyakurya bhɨnʉ bhɨsɨngɨɨrwɨ amasambwa, bhatanywa amasaahɨ, bhatarya ɨnyama yi ikityɨnyi kɨnʉ kɨngʼɨɨtirwɨ na bhatakora ɨtaarʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tabhʉʉri waho, Paaurʉ akaja na abhaatʉ bhane bharya, akiibhɨngukya hamwɨmwɨ nabhʉ. Akʉmara akasikɨra mwihekaaru, korereke abhabhʉʉrɨrɨ bhakuhaani urusikʉ rʉnʉ bharɨɨmarɨ kwibhɨngukya ɨwaabhʉ, ni ikimweso kɨraruusibhwa igʉrʉ wa bhʉʉsi bhayo. ");
INSERT INTO ikz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Zisikʉ muhungatɨ zu ukwibhɨngukya zaarɨ haguhɨ kusira, Abhayaahudi bhanʉ bhaaruurɨ mucharʉ cha Asiya bhakarora Paaurʉ mwihekaaru. Bhakasiigirirya abhaatʉ kokora rirɨgɨ, neho abhaatʉ bhayo bhakagwata Paaurʉ ");
INSERT INTO ikz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bharabhuga, “Imwɨ abhasubhɨ bha Iziraɨri! Mʉtʉsakiryɨ! Ndora ʉmʉʉtʉ wʉnʉ newe wuryawurya, wʉnʉ akwija abhaatʉ bha ahagero hʉʉsi kʉbha bharege imigirʉ ja Musa na rihekaaru rɨnʉ. Na bhabhuruuriryɨ rihekaaru rɨnʉ, kʉ kʉbhasikirya mwihekaaru abhaatʉ bhanʉ bhatarɨ Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bhakagambabhu, kʉ kʉbha bhaarɨ bharʉʉzɨ Paaurʉ mʉrʉbhɨri hayo hamwɨmwɨ na Tʉrʉfimʉ Umwefeeso. Kʉ kʉtama komenya bhakakina kʉbha asikiiryɨ Tʉrʉfimʉ mwihekaaru. ");
INSERT INTO ikz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Abhaatʉ bhakatanga kokora rirɨgɨ ʉrʉbhɨri rwʉsi rwa Yɨrusarɨɨmu. Kurwa mbaara zʉʉsi abhaatʉ bhayo bhakaryarɨra Paaurʉ mwihekaaru, bhakamuruta, bhakamuhurucha igʉtʉ ni ibhisikʉ bhikiigarwa. ");
INSERT INTO ikz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Hanʉ abhaatʉ bhayo bhaarɨ bhareenda kwita Paaurʉ, amangʼana gakahikɨra ʉmʉkʉrʉ wa abhasirikarɨ bhi Ikiruumi kʉbha, abhaatʉ bharakora rirɨgɨ Yɨrusarɨɨmu yʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hayohayo akagega abhasirikarɨ hamwɨmwɨ na abhakʉrʉ bhaabhʉ, bhakaryara kuja kʉbhaatʉ bhayo. Hanʉ abhaatʉ bhayo bhaarʉʉzɨ abhasirikarɨ bharɨ hamwɨmwɨ nʉ ʉmʉkʉrʉ waabhʉ, bhakatiga kotema Paaurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ʉmʉkʉrʉ wa abhasirikarɨ wuyo akabhajaku, akagwata Paaurʉ, akaswaja abhohwe ne emenyororo ɨbhɨrɨ. Akʉmara akabhuurya riribhita rirya, “Wʉnʉ nɨ‑wɨɨwɨ? Na akʉrirɨkɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Abhaatʉ bhayo bhakarɨgɨsa bhʉkʉngʼu, bharagamba amangʼana bhʉndɨ nʉ ʉmʉkɨndichazɨ. Rirɨgɨ riyo rɨkakora ʉmʉkʉrʉ wuyo atamwɨ komenya ganʉ gakʉriibhwɨ. Akaswaja Paaurʉ areetwe mwigoobhe rya abhasirikarɨ. ");
INSERT INTO ikz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Hanʉ Paaurʉ aahikirɨ kwitiirɨrʉ rya rigoobhe riyo, abhaatʉ bhakangʼeha kokora rirɨgɨ, bhʉkʉngʼu. Rirɨgɨ riyo rɨkagirya abhasirikarɨ bhamogege igʉrʉgʉrʉ korereke bhamutuuryɨ. ");
INSERT INTO ikz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Abhaatʉ bhayo bhaarɨ bharatunɨɨrɨra Paaurʉ bhararɨgɨsa bharabhuga, “Arichwɨ, arichwɨ!” ");
INSERT INTO ikz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Hanʉ abhasirikarɨ bhayo bhaarɨ bhakusikirya Paaurʉ mwigoobhe ryabhʉ, Paaurʉ akabhʉʉrɨra ʉmʉkʉrʉ waabhʉ wuyo, “Ʉranyiisiririrya nɨgambɨ na naawɨ?” Akamʉbhʉʉrɨra, “Kanɨ, ʉmɨnyirɨ kʉgamba Ikigiriki. ");
INSERT INTO ikz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Awɨ ʉtarɨ Mumiisiri wʉnʉ aarɨɨtirɨ ʉbhʉtaamanʼya bhasiiryasiirya hanʉ, na kʉkangata abhiiti bhɨkwɨ bhene kʉkɨbhara?” ");
INSERT INTO ikz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paaurʉ akamʉbhʉʉrɨra, “Zɨyi, inyɨ nɨ‑Mʉyaahudi, umwibhurwa wʉ ʉrʉbhɨri rwa Tarisʉ, kʉʉsɨ ya Kirikiya. Ʉrʉbhɨri ruyo rʉmɨnyɨkɨɨnɨ bhʉkʉngʼu. Nɨrakʉsabha unyiisiririryɨ niibhisiryɨ na abhaatʉ bhanʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Neho ʉmʉkʉrʉ wa abhasirikarɨ wuyo akamwisiririrya, Paaurʉ akiimɨɨrɨra kwitiirɨrʉ kuyo, akanʉngɨra okobhoko abhaatʉ bhayo kʉbha bhakirɨ. Hanʉ bhaakirirɨ bhʉʉsi, akagambana nabhʉ kʉkɨgambʉ chabhʉ chɨ Ɨkɨɨbhuraaniya. ");
INSERT INTO ikz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Paaurʉ akabhabhʉʉrɨra akabhuga, “Imwɨ bhabhaabha na abhahiiri bhaanɨ bhʉʉsi, nɨrabhasabha nangʉ munyiitegeerere niibhagɨrɨ embere waanyu!” ");
INSERT INTO ikz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hanʉ abhaatʉ bhayo bhiigwirɨ Paaurʉ aragambana nabhʉ kʉkɨgambʉ chabhʉ chɨ Ɨkɨɨbhuraaniya, bhakakira kiri. Neho Paaurʉ akangʼeha kʉgamba, ");
INSERT INTO ikz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Inyɨ nɨ‑Mʉyaahudi, umwibhurwa wʉ ʉrʉbhɨri rwa Tarisʉ kʉʉsɨ ya Kirikiya. Nawe nɨkarererwa Yɨrusarɨɨmu hanʉ, Gamariɨri newe aanyiijiryɨ imigirʉ gɨnʉ twatigiirwɨ na bhasʉʉkʉrʉ. Naarɨ nu umucha bhʉkʉngʼu kwa Mungu, ncha gʉnʉ imwɨ mʉnagwɨ reero yɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naarɨ nɨranyaacha bhʉkʉngʼu abhahɨmba bhɨ ɨnzɨra ya Yɨɨsu kuhika kukwa. Naarɨ nɨragwata abhasubhɨ na abhakari na kʉbharekera mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Gayo nɨkʉbhabhʉʉrɨra imwɨ, nʉʉrʉ kuhaani ʉmʉkʉrʉ hamwɨmwɨ na abhakaruka bhʉʉsi bhi ichandarʉ, bharatʉra kugiisirirya kʉbha nɨ‑ga amaheene. Ebho bhʉʉsi nebho bhangʼɨɨrɨ zɨnyarʉbha zu ukuhirɨra Abhayaahudi abhakɨndichɨtʉ, bhanʉ bhaarɨ kʉrʉbhɨri rwa Damɨɨsikʉ. Nɨkabhʉʉka nɨkaja iyo, korereke nebhohe abhahɨmba bhi iyo, nɨbhareete Yɨrusarɨɨmu hanʉ bhanyaakibhwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Hanʉ naarɨ haguhɨ kuhika Damɨɨsikʉ, ribhaga ryu umwise ubhwɨrʉ ʉbhʉkʉrʉ bhʉkabhanza kurwa mwisaarʉ, bhʉkamʉrɨka mbaara zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nɨkagwa haasɨ, nikiigwa riraka rɨrambʉʉrɨra, ‘Sauri! Sauri! Ndora ʉranyaacha?’ ");
INSERT INTO ikz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nɨkabhuurya, ‘Ʉmʉkʉrʉ, awɨ nɨ‑wɨɨwɨ?’ “Akambʉʉrɨra, ‘Inyɨ nɨ‑Yɨɨsu wa Nazarɨɨti, wʉnʉ ʉkʉnyaacha.’ ");
INSERT INTO ikz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abhakɨndichanɨ bhanʉ twarɨ hamwɨmwɨ bhakarora ubhwɨrʉ, nawe bhatiigwirɨ riraka riyo. ");
INSERT INTO ikz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nɨkabhuurya, ‘Nekorebhwɨ, Ʉmʉkʉrʉ?’ “Neho Ʉmʉkʉrʉ akambʉʉrɨra, ‘Imɨɨrɨra, usikɨrɨ mʉrʉbhɨri rwa Damɨɨsikʉ, muyo nɨmu ukubhuurirwa amangʼana gʉʉsi ganʉ ukwenderwa okore.’ ");
INSERT INTO ikz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nɨkahukura, kʉ kʉbha yu ubhwɨrʉ bhuyo. Abhakɨndichanɨ bhayo bhakangwata okobhoko, bhakankangata bhakahicha kʉrʉbhɨri rwa Damɨɨsikʉ. ");
INSERT INTO ikz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Damɨɨsikʉ hayo aareho ʉmʉʉtʉ wʉmwɨ, iriina ryazɨ Ananiya. Ananiya wuyo aarɨ nu umucha bhʉkʉngʼu gwʉ ʉkʉsʉʉka imigirʉ jɨtʉ, na aarɨ arakumibhwa na Abhayaahudi bhaaru bhi iyo kʉbha, aarɨ ʉmʉʉtʉ ʉmʉzʉmu. ");
INSERT INTO ikz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mmbe akanyiizɨra, akiimɨɨrɨra haguhɨ na niinyɨ, akambʉʉrɨra, ‘Umuhiiri waanɨ Sauri, rora naatu!’ Hayohayo amɨɨsʉ gaanɨ gakaramucha, nɨkamorora. ");
INSERT INTO ikz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Akambʉʉrɨra, ‘Mungu wa bhasʉʉkʉrʉ akʉrʉbhwɨrɨ, korereke omenye ubhwɨndi bhwazɨ, omorore We Eheene na kwigwa riraka ryazɨ umwene. ");
INSERT INTO ikz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gʉʉsi ganʉ ʉrʉʉzɨ na ganʉ wigwirɨ, ʉrabha ʉragagamba kʉbhaatʉ bhʉʉsi, kʉ kʉbha ʉrabha ekemenyeekereryo chazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nangʉ ʉrarɨndakɨ? Imɨɨrɨra! Ʉbhatiizwɨ, ʉbhɨngukiibhwɨ ʉbhʉbhɨ na ʉsabhɨ ʉbhʉsakirya kwa Mungu.’ ");
INSERT INTO ikz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mmbe nɨkagarʉka Yɨrusarɨɨmu. Hanʉ naarɨ nɨkʉsabha Mungu mwihekaaru, nɨkarora ʉbhʉrʉri. ");
INSERT INTO ikz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Kʉbhʉrʉri bhuyo, nɨkarora Ʉmʉkʉrʉ arambʉʉrɨra, ‘Kora bhwangʉ urwɨ Yɨrusarɨɨmu, kʉ kʉbha obhomenyeekererya bhwazʉ bhʉnʉ ukuhurucha igʉrʉ waanɨ, abhaatʉ bhʉ ʉrʉbhɨri rʉnʉ bhatakubhwisirirya.’ ");
INSERT INTO ikz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nawe nɨkagarukirya, ‘Ʉmʉkʉrʉ, ndora bhɨɨzɨ kʉbha, naarɨ kʉhɨta mʉmarwazɨrʉ ga Abhayaahudi kubhyɨma bhanʉ bhakukwisirirya! Naarɨ nɨrabhabhoha na kʉbhatema kɨbhɨ. ");
INSERT INTO ikz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Hanʉ amasaahɨ gʉ ʉmʉmɨnyɨɨkɨrɨri waazʉ Sitɨfaanʉ giitikirɨ, inyɨ inyimwene naarɨ nimiiriirɨ rusizʉ, nikiisirirya kʉbha iitwɨ, na zengebho za bhanʉ bhaamwitirɨ, inyɨ niinyɨ nazangariirɨ.’ ");
INSERT INTO ikz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ʉmʉkʉrʉ wʉʉsi akambʉʉrɨra, ‘Nuujɨ! Nɨrakʉtʉma ujɨ kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi.’” ");
INSERT INTO ikz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Abhaatʉ bhayo bhaarɨ bhariitegeerera bhwaheene amangʼana ga Paaurʉ. Nawe hanʉ aagambirɨ ringʼana riyo, hayohayo bhakatanga kʉrɨgɨsa kwiraka bharabhuga, “Ʉmʉʉtʉ wʉnʉ aruusiibhwɨ kʉʉsɨ! Atakwenderwa kororekana kʉbhaho mʉhʉru!” ");
INSERT INTO ikz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Abhaatʉ bhayo bhakarɨgɨsa na bharakukumura zengebho zaabhʉ, bharagundya urutu. ");
INSERT INTO ikz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ʉmʉkʉrʉ wa abhasirikarɨ wuyo, akaswaja abhasirikarɨ bhaazɨ, bhasikiryɨ Paaurʉ mwigoobhe ryabhʉ na bhamoteme, bhamenye kɨnʉ kikugirya abhaatʉ bhayo bharɨgɨsɨ. ");
INSERT INTO ikz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nawe hanʉ abhasirikarɨ bhayo bhaamarirɨ kobhoha Paaurʉ korereke bhamoteme, akabhuurya ʉmʉkʉrʉ wʉnʉ aarɨ imiiriirɨ hayo kʉbha, “Heene muriisiriribhwa ni imigirʉ kotema Umuruumi, ɨnʉ akɨɨrɨ kutinirwa?” ");
INSERT INTO ikz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Hanʉ ʉmʉkʉrʉ wuyo iigwirɨbhu, akaja akabhʉʉrɨra ʉmʉkʉrʉ wa abhasirikarɨ, “Kanɨ, ʉmʉʉtʉ wuyo ni‑Muruumi! Nangʉ oreenda kokorabhwɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Neho ʉmʉkʉrʉ waabhʉ wuyo akaja kwa Paaurʉ, akamubhuurya, “Awɨ ni‑Muruumi?” Paaurʉ akamʉbhʉʉrɨra, “Hee, inyɨ Muruumi nɨrɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ʉmʉkʉrʉ wuyo akamʉbhʉʉrɨra, “Inyɨ naarɨ Muruumi ku kuhurucha ebhegero bhyaru bhʉkʉngʼu.” Paaurʉ akabhuga, “Inyɨ Muruumi wa kwibhurwa.” ");
INSERT INTO ikz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hayohayo abhasirikarɨ bhanʉ bhaarɨ bhiitɨgirɨ kubhuurya Paaurʉ bhakarweho. Ʉmʉkʉrʉ waabhʉ wuyo wʉʉsi akʉʉbhaha bhʉkʉngʼu kwigwa kʉbha Paaurʉ ni‑Muruumi, kʉ kʉbha aarɨ amʉbhʉhirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Hanʉ bhwɨrirɨ, ʉmʉkʉrʉ wa abhasirikarɨ wuyo akeenda komenya kɨnʉ kigiryɨ Paaurʉ agambwɨ na Abhayaahudi bhayo. Akamʉtazʉra arabhuga, abhakʉrʉ bha abhakuhaani bhiibhiringɨ hamwɨmwɨ ni ichandarʉ chʉsi. Rɨkahɨta ibhaga isuuhu akareeta Paaurʉ, na kumwimiirirya gatɨgatɨ waabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Neho Paaurʉ akamogorera bhʉkʉngʼu abhakʉrʉ bhi ichandarʉ, arabhuga, “Abhahiiri bhaanɨ imwɨ, nɨmarirɨ emeremo janɨ kwa Mungu, ekoro yaanɨ nzɨrʉ ya pee kuhika reero yɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hanʉ kuhaani ʉmʉkʉrʉ Ananiya iigwirɨ ɨngʼana yiyo, akabhabhʉʉrɨra bhanʉ bhaarɨ bhiimiiriirɨ haguhɨ na Paaurʉ bhamoteme nyaasasɨ kumunywa. ");
INSERT INTO ikz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Neho Paaurʉ akabhʉʉrɨra Ananiya, “Mungu arakotema awɨ, wʉnʉ wanga inyiki yɨnʉ ɨhakirwɨ iswakara! Awɨ wiikɨɨrɨ hayo korereke ʉntɨnɨrɨ ku kutuna imigirʉ, nawe aumwene ʉragɨsarya ku kuswaja abhaatʉ bhanteme ɨnʉ imigirʉ gɨraanga!” ");
INSERT INTO ikz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Neho abhaatʉ bhanʉ bhaarɨ bhiimiiriirɨ haguhɨ na Paaurʉ bhakamʉbhʉʉrɨra, “Ʉtakwenderwa kʉtʉka kuhaani ʉmʉkʉrʉ wʉnʉ atɨɨrwɨ na Mungu.” ");
INSERT INTO ikz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paaurʉ akabhabhʉʉrɨra, “Abhahiiri bhaanɨ, naarɨ nɨtɨɨzɨ kʉbha ewe newe kuhaani ʉmʉkʉrʉ, kʉ kʉbha yandikirwɨ kʉMaandɨkʉ kʉbha ‘Ʉtamʉgamba kɨbhɨ ʉmʉtɨmi waanyu.’ ” ");
INSERT INTO ikz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Hanʉ Paaurʉ aamɨnyirɨ kʉbha gatɨgatɨ wa abhakʉrʉ bhayo bhaareho Abhasadukaayo hamwɨmwɨ na Abhafarisaayo, akatiirya riraka ryazɨ mʉbhʉtangɨ bhwi ichandarʉ, arabhuga, “Abhahiiri bhaanɨ, inyɨ Mʉfarisaayo nɨrɨ, umwana wʉ Ʉmʉfarisaayo. Nɨratinirwa hanʉ igʉrʉ wu ukwisega kʉbha abhaku bhararyʉka.” ");
INSERT INTO ikz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Hanʉ aamarirɨ kʉgamba gayo, kʉkabhaho rirɨgɨ gatɨ ya Abhafarisaayo na Abhasadukaayo ni ichandarʉ chʉsi kɨkatwanɨkana kabhɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bhakatwanɨkana kʉ kʉbha Abhasadukaayo bharaanga kʉbha bhʉtareeho bhuryuku, naabha bhamaraika, naabha amasambwa. Nawe Abhafarisaayo abheene bhariisirirya gayo gʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kʉkabhaho na rirɨgɨ ikʉrʉ gatɨ wa abhakʉrʉ bhayo. Abhiija obhorebhe bhi imigirʉ bhanʉ bhaarɨ Abhafarisaayo, bhakiimɨɨrɨra bhakagamba kuzinguru bharabhuga, “Tʉtakorora bhʉbhɨ bhwʉbhwʉsi bhwʉ ʉmʉʉtʉ wʉnʉ! Ɨratʉra kʉbha agambɨɨnɨ nɨ ɨkɨhwɨ hamwɨ maraika.” ");
INSERT INTO ikz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Rirɨgɨ rɨkabha ikʉrʉ kuhika ʉmʉkʉrʉ wa abhasirikarɨ wurya, akʉʉbhaha na kukina kʉbha bhiisirɨ kokenyakenya Paaurʉ. Akatʉma abhasirikarɨ bhajɨ bhamuruushɨ gatɨgatɨ wa abhaatʉ bharya kwa nguru na kumusikirya mwigoobhe rya abhasirikarɨ. ");
INSERT INTO ikz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ubhutikʉ bhu urusikʉ ruyoruyo, Ʉmʉkʉrʉ akiimɨɨrɨra haguhɨ na Paaurʉ, akamʉbhʉʉrɨra, “Ihaana umwʉyʉ! Chɨmbu wahurukiryɨ obhomenyeekererya Yɨrusarɨɨmu hanʉ, nɨmbu oreenderwa unhurukiryɨ obhomenyeekererya kʉrʉbhɨri rwa Ruumi rwʉsi.” ");
INSERT INTO ikz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Hanʉ bhwakɨɨrɨ, Abhayaahudi abhandɨ bhakakora amangʼɨɨni na bhakiirahɨra kʉbha, bhatakurya naabha kunywa kuhika hanʉ bhariitɨ Paaurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Abhaatʉ bhanʉ bhaakʉrirɨ amangʼɨɨni gayo bhaarɨ bharakɨra merongo ene. ");
INSERT INTO ikz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhakatuna abhakʉrʉ bha abhakuhaani na abhakaruka bhakabhabhʉʉrɨra, “Twirahiirɨ itwʉsi kʉbha, tʉtakurya naabha kunywa kuhika twitɨ Paaurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mmbe nangʉ, imwɨ hamwɨmwɨ ni ichandarʉ ɨkɨkʉrʉ, moreenderwa mʉsabhɨ ʉmʉkʉrʉ wa abhasirikarɨ korereke areete Paaurʉ kwa niimwɨ. Mwikʉryɨ nkina moreenda kumubhuuririrya bhwaheene igʉrʉ wa amangʼana gaazɨ, na niitwɨ tʉmʉratɨ mʉnzɨra tumwitɨ, akɨɨrɨ kuhika hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nawe umwihwa wa Paaurʉ akiigwa igʉrʉ wa mangʼɨɨni gayo, akʉmara akaja mwigoobhe rya abhasirikarɨ irya na kʉbhʉʉrɨra Paaurʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Neho Paaurʉ akabhɨrɨkɨra ʉmʉkʉrʉ wʉmwɨ wa abhasirikarɨ, akamʉbhʉʉrɨra, “Muhirɨ umumura wʉnʉ kʉmʉkʉrʉ waanyu, ana kɨsɨgʉ chʉ ʉkʉmʉbhʉʉrɨra.” ");
INSERT INTO ikz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mmbe umusirikarɨ wurya akamuhira umumura wurya kʉmʉkʉrʉ waabhʉ na kʉgamba, “Paaurʉ omobhohwa, akambɨrɨkɨra na kʉnsabha nereete umumura wʉnʉ kwa naawɨ, kʉ kʉbha anɨ ɨngʼana yʉ ʉkʉkʉbhʉʉrɨra.” ");
INSERT INTO ikz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ʉmʉkʉrʉ wa abhasirikarɨ wuyo, akagwata umumura wuyo okobhoko, akamuhira rusizʉ na kumubhuurya, “Oreenda kʉmbʉʉrɨrakɨ?” ");
INSERT INTO ikz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Umumura wurya akamʉbhʉʉrɨra, “Abhayaahudi bhiisirirɨɨnʼyɨ bhakʉsabhɨ, umuhirɨ Paaurʉ kuchandarʉ ɨkɨkʉrʉ chabhʉ tabhʉʉri. Bhakʉkangiriryɨ kʉbha bhareenda kumubhuuririrya bhwaheene igʉrʉ wa amangʼana gaazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nawe ʉtaaza kubhiisiririrya, kʉ kʉbha abhaatʉ bhanʉ bhamʉratiirɨ bharakɨra merongo ene. Bhiirahiirɨ kʉbha, bhatakurya naabha kunywa kuhika hanʉ bhakumwita. Nangʉ bhamarirɨ kʉbhanʉra, bhararɨnda ubhiisiririryɨ amasabhi gaabhʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mmbe ʉmʉkʉrʉ wa abhasirikarɨ wurya akabhʉʉrɨra umumura wuyo kʉbha ajɨ, nawe akamuhiitya, arabhuga, “Ʉtabhʉʉrɨra mʉʉtʉ wʉwʉʉsi kʉbha umbuuriirɨ amangʼana ganʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Akʉmara ʉmʉkʉrʉ wa abhasirikarɨ wurya, akabhɨrɨkɨra abhaangariri bhabhɨrɨ bha abhasirikarɨ bhaazɨ, akabhabhʉʉrɨra, “Mʉbhɨ bhwaheene kʉbhʉʉka hanʉ zɨɨsa isatʉ ubhutikʉ, kuja kʉrʉbhɨri Kaisaariya hamwɨmwɨ na abhasirikarɨ magana abhɨrɨ, abhasirikarɨ merongo muhungatɨ bha zɨfaraasi na abhandɨ magana abhɨrɨ bha amatimʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mʉtʉʉrɨ zɨfaraasi bhwaheene, mutiiryɨ Paaurʉ igʉrʉ na kumuhira komorembe kumwanangwa Fɨriiki.” ");
INSERT INTO ikz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akʉmara akaandɨka ɨnyarʉbha kwa Fɨriiki ɨrabhuga: ");
INSERT INTO ikz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kiraudiyʉ Risiya kumugungibhwa umwanangwa Fɨriiki, nɨrakokeerya. ");
INSERT INTO ikz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ʉmʉʉtʉ wʉnʉ akagwatwa na Abhayaahudi, bhakabha haguhɨ kumwita. Hanʉ namɨnyirɨ kʉbha ni‑Muruumi, nɨkaja hamwɨmwɨ na amaribhita ga abhasirikarɨ nɨkamutuurya. ");
INSERT INTO ikz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nekeenda kwobhoora kwakɨ bhaarɨ bharamʉgamba, nɨkamuhira mʉbhʉtangɨ bhwi ichandarʉ chabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Neho nɨkamenya kʉbha aarɨ aragambwa kʉmangʼana gi imigirʉ jabhʉ, nawe ataagambirwɨ kwingʼana ryʉryʉsi rɨnʉ rikugirya iitwɨ hamwɨ kobhohwa. ");
INSERT INTO ikz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Hanʉ nabhuuriirwɨ kʉbha gareho amangʼɨɨni gu ukwita ʉmʉʉtʉ wʉnʉ, nɨkamʉtʉma bhwangʉ kwa naawɨ. Nɨkabhatʉma abhagambi bhaazɨ, bhagambɨ amangʼana gaazɨ mʉbhʉtangɨ bhwazʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mmbe, abhasirikarɨ bhayo bhakagega Paaurʉ chɨmbu bhaabhuuriirwɨ, bhakamuhira ubhutikʉ bhuyobhuyo kuhika ʉrʉbhɨri rwa Antipatiiri. ");
INSERT INTO ikz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Hanʉ bhwakɨɨrɨ, bhakatiga abhasirikarɨ bha zɨfaraasi bhakakaja orogendo hamwɨmwɨ na Paaurʉ. Ribhaga riyo abhasirikarɨ bha amagʉrʉ bhakagarʉka mwigoobhe ryabhʉ rya abhasirikarɨ. ");
INSERT INTO ikz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hanʉ abhasirikarɨ bha zɨfaraasi bhaahikirɨ Kaisaariya, bhakaha umwanangwa ɨnyarʉbha yirya, bhakatʉʉra Paaurʉ wʉʉsi mʉmabhoko gu umwanangwa wuyo. ");
INSERT INTO ikz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Hanʉ umwanangwa aamarirɨ kosoma ɨnyarʉbha yirya, akabhuurya Paaurʉ, “Awɨ nɨ‑mʉʉtʉ wɨ ɨɨsɨkɨ?” Umwanangwa kwigwa kʉbha ararwa kʉʉsɨ ya Kirikiya, ");
INSERT INTO ikz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akamʉbhʉʉrɨra, “Nɨrakwitegeerera amangʼana gaazʉ, hanʉ abhagambi bhaazʉ bharaahikɨ.” Akʉmara akaswaja kʉbha, Paaurʉ ariibhwɨ mwikʉrʉ ryʉ ʉmʉtɨmi Heroode. ");
INSERT INTO ikz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Hanʉ zaahitirɨ zisikʉ isaanʉ, kuhaani ʉmʉkʉrʉ Ananiya akahiringita kuja kʉrʉbhɨri rwa Kaisaariya. Aarɨ hamwɨmwɨ na abhakaruka bhorebhe bha Abhayaahudi, nu umwimiiririri wʉmwɨ wa abhaatʉ ni imigirʉ, arabhirikirwa Tɨrituurʉ. Bhakaja kʉgamba Paaurʉ kumwanangwa Fɨriiki. ");
INSERT INTO ikz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Hanʉ Paaurʉ aabhirikiirwɨ, Tɨrituurʉ akatanga kʉgamba amangʼana gʉkʉmʉgamba, akabhuga, “Umugungwa Fɨriiki, kwibhaga irɨɨhu tʉzʉmɨrɨɨrwɨ omorembe, na kʉbhʉkangati bhwazʉ amangʼana maaru mabhɨ garazʉmibhwa mucharʉ kɨnʉ. ");
INSERT INTO ikz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tʉragiisirirya ibhaga ryʉsi, hagero hʉhʉʉsi, na kwa bhusuuku bhwʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nangʉ nɨtaaza kokora unihɨ, nɨrakʉsabha utwitegeerere hasuuhu. ");
INSERT INTO ikz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Tʉrʉʉzɨ kʉbha ʉmʉʉtʉ wʉnʉ nɨ‑mʉsɨɨgʉ, arasiigirirya Abhayaahudi bhakore rirɨgɨ abheene kobheene kʉzɨɨsɨ ɨzɨndɨ zʉʉsi. Ewe newe ʉmʉkangati ʉmʉkʉrʉ wɨ ɨnyangi ya Abhanazarɨɨti. ");
INSERT INTO ikz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Naatu akagema kubhuruurya rihekaaru, tʉkamugwata, tokeenda kʉmʉtɨnɨra kʉrɨngʼaana ni imigirʉ jɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nawe ʉmʉkʉrʉ wa abhasirikarɨ Rusiya, akaaza akamuruusha kwa niitwɨ kwa nguru. ");
INSERT INTO ikz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Akabhaswaja bhanʉ bhakʉmʉgamba, bhaazɨ mʉbhʉtangɨ bhwazʉ, bhamʉgambɨ kwa naawɨ. Hanʉ aumwene ukumubhuurya ʉratʉra kwobhoora kurwa kwawe amangʼana ganʉ gakugirya tʉmʉgambɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Abhayaahudi abhandɨ bhʉʉsi bhakiisirirya, amangʼana gʉʉsi ga Tɨrituurʉ, nɨ‑ga amaheene. ");
INSERT INTO ikz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Hanʉ umwanangwa Fɨriiki ʉrʉtirɨ Paaurʉ ichara korereke yiibhagɨrɨ, ewe akabhuga, “Nɨmɨnyirɨ kʉbha awɨ waarɨ umutiniri kucharʉ kɨnʉ kumyaka myaru, nangʉ niriibhagɨra inyimwene mʉbhʉtangɨ bhwazʉ kobhozomerwa. ");
INSERT INTO ikz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Aumwene ʉratʉra komenya kʉbha, zɨkɨɨrɨ kʉhɨta zisikʉ ikumi ni ibhɨrɨ kwɨma nijɨ Yɨrusarɨɨmu kosengera Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bhanʉ bhakʉngamba bhatambwɨnɨ nɨrahakaana na mʉʉtʉ wʉwʉʉsi mwihekaaru. Bhatambwɨnɨ nɨrasiigirirya iribhita rya abhaatʉ mʉmarwazɨrʉ ga Abhayaahudi hamwɨ ʉrʉbhaara rwʉrwʉsi rurya rwʉ ʉrʉbhɨri ruyo. ");
INSERT INTO ikz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bhatakʉtʉra nʉʉrʉ kuhurucha amaheene ga amangʼana ganʉ gakugirya bhangambɨ. ");
INSERT INTO ikz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Nawe niriisirirya, inyɨ nɨrasengera Mungu wʉnʉ bhasʉʉkʉrʉ bhaasɨngɨɨrɨ, kʉnzɨra ya Yɨɨsu, yɨnʉ ebho bhakʉbhɨrɨkɨra, ɨnyangi yʉ ʉrʉrɨmɨ. Niriisirirya ebhegero bhyʉsi bhɨnʉ bhikwisiriranʼya ni imigirʉ ja Musa na kɨnʉ chandikirwɨ mʉbhɨtabhʉ bhya Abharʉʉtɨrɨri. ");
INSERT INTO ikz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Inyɨ ninu ubhwisɨgi kwa Mungu, bhʉnʉ bhʉʉsi bhakwisega kʉbha, araryʉra abhaku bhʉʉsi, bhe eheene na bhanʉ bhatarɨ bhe eheene. ");
INSERT INTO ikz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kʉgayo niriinarya kʉbha ne ekoro ɨnzɨrʉ mʉbhʉtangɨ bhwa Mungu na mʉbhʉtangɨ bhwa abhaatʉ sikʉ zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Imyaka myaru gihitirɨ nɨtaarɨ Yɨrusarɨɨmu, nɨkagarʉka hayo korereke koreeta ʉbhʉsakirya kʉbhaatʉ bhi icharʉ chanɨ na kuhurucha ikimweso kwa Mungu. ");
INSERT INTO ikz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Hanʉ bhambwɨnɨ mwihekaaru nɨrakora ʉbhʉsɨngɨri bhuyo, naarɨ nɨmarirɨ kwibhɨngukya, na nɨtaarɨ nɨrasikɨra muyo na abhaatʉ bhaaru, na nɨtaakʉrirɨ irɨgɨ ryʉryʉsi. Nawe bhaarɨ bhareho Abhayaahudi obhorebhe kurwa icharʉ cha Asiya. ");
INSERT INTO ikz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nebho bhɨɨndirwɨ bhagambɨ ringʼana ryʉryʉsi rɨnʉ bhanaryʉ igʉrʉ waanɨ. ");
INSERT INTO ikz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hamwɨ abhaatʉ bhanʉ bharɨ hanʉ, bhagambɨ, nɨ‑bhʉbhɨkɨ bhʉnʉ bhaabhubhwɨnɨ kwa niinyɨ hanʉ bhaanyimiiriiryɨ mʉbhʉtangɨ bhwi ichandarʉ chabhʉ. ");
INSERT INTO ikz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Hamwɨ bhakarora kɨbhɨ hanʉ nagambirɨ kwiraka ikʉrʉ mʉbhʉtangɨ bhwabhʉ kʉbha, ‘Inyɨ nɨratinirwa mʉbhʉtangɨ bhwazʉ reero kʉ kʉbha niriisirirya kʉbha abhaku bhararyʉka.’ ” ");
INSERT INTO ikz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Neho Fɨriiki, wʉnʉ aarɨ amɨnyirɨ bhwaheene amangʼana gɨ ɨnzɨra ya Yɨɨsu, akakubhya ikiina, akabhuga, “Nɨratɨnɨra ikiina chanyu, hanʉ ʉmʉkʉrʉ wa abhasirikarɨ Risiya araahikɨ hanʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Fɨriiki akatʉma ʉmʉkʉrʉ wa abhasirikarɨ ʉwʉndɨ amuriibhɨ Paaurʉ, nawe amohe umweya, na abhasaani bhaazɨ bhiisiriribhwɨ kʉmʉsakirya. ");
INSERT INTO ikz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Hanʉ zaahitirɨ zisikʉ suuhu, Fɨriiki akaaza hamwɨmwɨ na Durusiira, ʉmʉkari waazɨ wɨ Ɨkɨyaahudi. Akatʉma abhaatʉ bhabhɨrɨkɨrɨ Paaurʉ, korereke amwitegeerere ribhaga rɨnʉ akʉgamba igʉrʉ wu ubhwisirirya kwa Yɨɨsu Kiriisitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Hanʉ Paaurʉ aarɨ akongʼeha kʉgamba igʉrʉ we eheene nʉ ʉkʉbha ne ekerengo, nɨ ɨtɨnɨrʉ yɨnʉ ikuuza, Fɨriiki akʉʉbhaha na kʉgamba, “Gayo giisirɨ nangʉ! Ʉratʉra kuja, nɨraabhone ribhaga nɨrakʉbhɨrɨkɨra naatu.” ");
INSERT INTO ikz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Hamwɨmwɨ na gayo, Fɨriiki akiisega kʉbha arahaabhwa zimpirya na Paaurʉ, akamʉbhɨrɨkɨra manga kaaru kʉgambana neewe. ");
INSERT INTO ikz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Hanʉ jahitirɨ imyaka ɨbhɨrɨ, Pʉriikiyʉ Fɨsitʉ akagwata ikitumbɨ chʉ ʉbhʉkʉrʉ cha Fɨriiki. Na kʉ kʉbha Fɨriiki aarɨ areenda kwikomba Abhayaahudi, akatiga Paaurʉ arɨ mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Hanʉ Fɨsitʉ aamarirɨ sikʉ isatʉ zʉ ʉbhʉkangati bhwɨ ɨɨsɨ yiyo, akarwa Kaisaariya, akatiira kuja Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Abhakʉrʉ bha abhakuhaani na abhakʉrʉ abhandɨ bha Abhayaahudi bhakaaza hanʉ aarɨ, korereke bhamʉbhʉʉrɨrɨ gʉʉsi ganʉ bhaarɨ bhagambirɨ Paaurʉ. Bhakamʉkandikija bhʉkʉngʼu ");
INSERT INTO ikz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","kʉbha, abhasakiryɨ abhagarukiryɨ Paaurʉ Yɨrusarɨɨmu hayo. Bhaarɨ bharamʉkandikija kʉ kʉbha bhakʉrirɨ amangʼɨɨni gu ukwita Paaurʉ mʉnzɨra. ");
INSERT INTO ikz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nawe Fɨsitʉ akabhabhʉʉrɨra, “Paaurʉ atɨɨrwɨ mokebhoho Kaisaariya, inyimwene sikʉ zɨtarɨ nzaru nɨraja iyo. ");
INSERT INTO ikz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Abhakʉrʉ bhaanyu bhaazɨ nihiranɨ nabhʉ, arɨɨbhɨ rereho ringʼana ibhɨ rɨnʉ akʉrirɨ, bhamʉgambɨ tomenye amaheene.” ");
INSERT INTO ikz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɨsitʉ akamara sikʉ ɨzɨndɨ inyanyɨ hamwɨ ikumi, arɨ hamwɨmwɨ na abhaatʉ bhayo, akagarʉka Kaisaariya hayo. Hanʉ bhwakɨɨrɨ, akiikara igʉrʉ wi ikitumbɨ chazɨ kɨnʉ aarɨ akʉtɨnɨra. Akaswaja Paaurʉ areetwe mʉbhʉtangɨ bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Hanʉ Paaurʉ aahikirɨ hayo, Abhayaahudi bhanʉ bhiizirɨ kurwa Yɨrusarɨɨmu bhakamwiruguura, bhakatanga kʉmʉgamba kʉmabhɨ maaru gʉ ʉkʉrʉgʉʉra. Nawe bhakatama kwerecha amaheene ga gayo. ");
INSERT INTO ikz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paaurʉ akatanga kwibhagɨra arabhuga, “Nɨtasariryɨ kegero chʉchʉsi igʉrʉ wi imigirʉ ja Abhayaahudi, nɨtasariryɨ igʉrʉ wa rihekaaru nʉʉrʉ kwa Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɨsitʉ akeenda kwikomba kʉBhayaahudi, ɨkamokora abhuuryɨ Paaurʉ, “Heene wiisiriiryɨ kuja Yɨrusarɨɨmu, iyo neyo utinirwɨ kumigirʉ mʉbhʉtangɨ bhwanɨ, kʉmangʼana ganʉ?” ");
INSERT INTO ikz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paaurʉ akamʉgarukirya, “Niriimɨɨrɨra mʉbhʉtangɨ bhwa abhatiniri bhi imigirʉ bhanʉ bhatɨɨrwɨ na Kaisaari, neho nereenderwa kutinirwa. Rɨtareeho ingʼana rɨnʉ nɨsariryɨ kʉBhayaahudi, chɨmbu aumwene ʉmɨnyirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Arɨɨbhɨ nɨkʉrirɨ ʉbhʉbhɨ bhʉnʉ bhukwenderwa kwitwa, nɨtakʉtʉra kwanga kwitwa. Nawe arɨɨbhɨ amagamba ganʉ gahurukiibhwɨ igʉrʉ waanɨ na Abhayaahudi bhanʉ, nɨ‑ga kɨbhɨɨhi, atareeho wʉwʉʉsi wʉnʉ anʉ ʉbhʉnaja bhwʉ ʉkʉntʉʉra mʉmabhoko gaabhʉ. Inyɨ nɨrasabha kʉbha ikiina chanɨ kitinirwɨ na Kaisaari!” ");
INSERT INTO ikz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hanʉ Fɨsitʉ aamarirɨ kʉgambana na abhaatʉ bha muchandarʉ, akabhʉʉrɨra Paaurʉ, “Ʉsabhirɨ ikiina chazʉ kitinirwɨ na Kaisaari, mmbe ʉrahirwa kwa Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Hanʉ zaahitirɨ sikʉ suuhu, ʉmʉtɨmi Agiripa hamwɨmwɨ nu umusubhaati Bhɨrinikɨ, bhakaaza Kaisaariya hayo, korereke bhakeerye Fɨsitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bhakamara hayo sikʉ nzaru. Fɨsitʉ akabhʉʉrɨra ʉmʉtɨmi ikiina cha Paaurʉ, akabhuga, “Arɨ hanʉ ʉmʉʉtʉ wʉmwɨ wʉnʉ Fɨriiki aamutigirɨ mokebhoho. ");
INSERT INTO ikz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Hanʉ naarɨ nɨrɨ Yɨrusarɨɨmu, abhakʉrʉ bha abhakuhaani hamwɨmwɨ na abhakaruka bha Abhayaahudi, bhakambʉʉrɨra amangʼana ganʉ bhaarɨ bharamʉgamba, na bhakasabha kʉbha nɨmʉtɨnɨrɨ. ");
INSERT INTO ikz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nɨkabhabhʉʉrɨra, itwɨ Abharuumi tʉtakʉtɨnɨra ʉmʉʉtʉ akɨɨrɨ kwibhagɨra mʉbhʉtangɨ bhwa bhanʉ bhakʉmʉgamba. ");
INSERT INTO ikz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Hanʉ bhiibhiringirɨ, nɨtakɨzɨɨrɨ, nawe urusikʉ rwa kabhɨrɨ nikiikara kukitumbɨ chʉ ʉkʉtɨnɨra, nɨkaswaja ʉmʉʉtʉ wuyo areetwe. ");
INSERT INTO ikz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Hanʉ bhaamʉrɨɨtirɨ, bhanʉ bhaarɨ bharamʉgamba bhakiimɨɨrɨra, bhakatanga kʉmʉgamba. Nawe amangʼana ganʉ bhaarɨ bhakʉmʉgamba gataarɨ mabhɨ bhʉkʉngʼu, chɨmbu naarɨ nikwiseega. ");
INSERT INTO ikz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bhaarɨ bharahakaana neewe igʉrʉ wa amabhuurya gɨ ɨnyangi yaabhʉ ni igʉrʉ wʉ ʉmʉʉtʉ wʉmwɨ wʉnʉ akuurɨ, iriina ryazɨ Yɨɨsu, nawe Paaurʉ akʉʉmɨraku kʉbha nɨ‑mʉhʉru. ");
INSERT INTO ikz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Naarɨ nɨtɨɨzɨ chɨmbu nɨraakore kobhona amaheene ga ringʼana riyo, nɨkabhuurya Paaurʉ arɨɨbhɨ ariisirirya kuja Yɨrusarɨɨmu, korereke atinirwɨ iyo igʉrʉ wa amangʼana ganʉ. ");
INSERT INTO ikz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nawe hanʉ Paaurʉ aasabhirɨ kʉbha, ikiina chazɨ kitinirwɨ na Kaisaari, nɨkaswaja ariibhwɨ kuhikɨra hanʉ nɨraamʉtʉmanʼyɨ kwa Kaisaari.” ");
INSERT INTO ikz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agiripa akabhʉʉrɨra Fɨsitʉ kʉbha, “Inyʉʉsi nɨsɨɨgirɨ kwitegeerera ʉmʉʉtʉ wuyo inyimwene.” Fɨsitʉ akamʉbhʉʉrɨra, “Ʉramwitegeerera tabhʉʉri.” ");
INSERT INTO ikz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hanʉ bhwakɨɨrɨ, Agiripa hamwɨmwɨ na Bhɨrinikɨ wuyo, bhakaaza bhakangatɨɨnʼyɨ, bharagenda kwa bhwaheene. Bhakasikɨra hanʉ abhakʉrʉ bhaarɨ bharasʉngʼaanibhwa, bharatunwa na abhakʉrʉ bha abhasirikarɨ na abhakʉrʉ abhandɨ bhʉ ʉrʉbhɨri. Fɨsitʉ akaswaja Paaurʉ areetwe. ");
INSERT INTO ikz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɨsitʉ akatanga kʉgamba, “Ʉmʉtɨmi Agiripa, na niimwɨ bhanʉ mwibhiringirɨ hanʉ, ʉmʉʉtʉ wʉnʉ mokorora hanʉ, Abhayaahudi bhʉʉsi bhamʉgambirɨ Yɨrusarɨɨmu iyo na mʉbhʉtangɨ bhwanɨ hanʉ. Bhaarɨ bharakora rirɨgɨ, bharabhuga, ʉmʉʉtʉ wʉnʉ atakwenderwa kʉsaaga mʉhʉru. ");
INSERT INTO ikz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","“Inyimwene nɨrʉʉzɨ kʉbha, rɨtareeho ingʼana rɨnʉ rikugirya iitwɨ. Akasabha kʉbha ɨtɨnɨrʉ yaazɨ ekorwe Ruumi, kʉmʉtɨmi wɨɨtʉ ʉmʉkʉrʉ, riyo rɨkagirya nɨmʉtʉmanʼyɨ kwa naawɨ. ");
INSERT INTO ikz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Hamwɨmwɨ na gayo, nɨtaana ingʼana rya amaheene igʉrʉ waazɨ ryu ukumwandɨkɨra ʉmʉtɨmi wɨɨtʉ ʉmʉkʉrʉ. Necho nɨmʉrɨɨtirɨ mʉbhʉtangɨ bhwanyu hanʉ na mʉbhʉtangɨ bhwazʉ ʉmʉtɨmi Agiripa, korereke hanʉ tʉraamarɨ kumubhuurya neho nebhone ryu ukwandɨka igʉrʉ waazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nɨrarora ni‑ngʼana rɨnʉ rɨtaana bhwera kʉtʉmanʼya omobhohwa, ʉtɨɨrɨkɨɨnʼyɨ amabhɨ ganʉ agambirwɨ.” ");
INSERT INTO ikz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiripa akabhʉʉrɨra Paaurʉ, “Uriisiriribhwa kwibhagɨra.” Paaurʉ akagorora okobhoko, akatanga kwibhagɨra arabhuga, ");
INSERT INTO ikz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ʉmʉtɨmi Agiripa, reero niriiyigwa kʉbha nɨnʉ ʉrʉbhangʉ kwimɨɨrɨra mʉbhʉtangɨ bhwazʉ, korereke nisasaamɨ igʉrʉ wa gʉʉsi ganʉ Abhayaahudi bhangambirɨ. ");
INSERT INTO ikz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kɨnda awɨ, kʉ kʉbha ʉmɨnyirɨ bhwaheene zeteemwa zʉʉsi za Abhayaahudi, na ganʉ gʉʉsi bhaarɨ bhakʉhakaana, nɨrakʉsabha unyiitegeerere kwa bhwigumirirya. ");
INSERT INTO ikz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Abhayaahudi bhʉʉsi bhɨɨzɨ bhwaheene eteemwa yɨnʉ naarɨ kʉbha nayo mucharʉ chanɨ, kwɨma mubhwana bhwanɨ, kuhikɨra ribhaga rɨnʉ niikɨɨrɨ Yɨrusarɨɨmu. ");
INSERT INTO ikz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bhaanyɨzɨ bhwaheene kumyaka myaru, bharaasɨɨgɨ bharatʉra kuhurucha obhomenyeekererya, naarɨ nɨrakora amanarʉ gʉʉsi ga Abhafarisaayo. Abhafarisaayo nebho abhahɨmba bhi imigirʉ ja Mungu kʉkɨra abhandɨ bhʉʉsi bhɨ ɨnyangi yɨɨtʉ. ");
INSERT INTO ikz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nangʉ kɨnʉ kekokora nitinirwɨ kumigirʉ reero, nɨ‑kʉ kʉbha yu ubhwisɨgi bhwanɨ kʉbhʉragɨ bhʉnʉ Mungu akaraganʼya bhasʉʉkʉrʉ. ");
INSERT INTO ikz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ʉbhʉragɨ bhuyo nebhwe bhuryabhurya bhʉnʉ bhukwisegwa nɨ ɨbhɨgambʉ ikumi na bhɨbhɨrɨ bhi icharʉ chɨtʉ, bharasengera Mungu koheene ubhutikʉ nu umwise. Ʉmʉtɨmi, bhuyo nebhwe bhukugirya Abhayaahudi bharantɨnɨra! ");
INSERT INTO ikz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwakɨ mʉraanga kʉbha ɨtakʉtʉrɨkana Mungu kuryʉra abhaku? ");
INSERT INTO ikz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Inyimwene nɨkarora mokoro yaanɨ kʉbha ɨrazomera nekore gʉʉsi ganʉ gakwanga iriina rya Yɨɨsu wa Nazarɨɨti. ");
INSERT INTO ikz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Gayo nego nakʉrirɨ Yɨrusarɨɨmu. Kʉbhʉkʉrʉ bhwa abhakʉrʉ bha abhakuhaani, naarɨ nɨratʉʉra abharɨndu bha Mungu mokebhoho, na hanʉ bhaarɨ bhakwitwa, naarɨ niisiriiryɨ bhiitwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Naarɨ nɨrabhanyaacha mʉmarwazɨrʉ ga Abhayaahudi, korereke bhamwangɨ Yɨɨsu. Naarɨ nibhiigataniirɨ bhʉkʉngʼu, kuhika naarɨ nɨrabhabhyɨma mʉzɨmbɨri zɨkʉrʉ mʉzɨɨsɨ ɨzɨndɨ. ");
INSERT INTO ikz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Rusikʉ rʉmwɨ naarɨ mʉnzɨra kuja kʉbhanyaacha kʉrʉbhɨri rwa Damɨɨsikʉ, chɨmbu naarɨ nʉ ʉbhʉnaja nu ubhuswajibhwa bhwa abhakʉrʉ bha abhakuhaani. ");
INSERT INTO ikz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ʉmʉtɨmi, ribhaga ryu umwise hanʉ naarɨ kʉnzɨra, nɨkarora ubhwɨrʉ bhʉkabhanza kurwa mwisaarʉ kʉkɨra iryʉbha, bhʉkanyiiruguutirirya inyɨ na abhakɨndichanɨ mbaara zʉʉsi. ");
INSERT INTO ikz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tʉkagwa haasɨ itwʉsi, nikiigwa riraka rɨrambʉʉrɨra kʉkɨgambʉ chanɨ chɨ Ɨkɨɨbhuraaniya rɨrabhuga, ‘Sauri! Sauri! Ndora ʉranyaacha? Uriinyahaara bhwene nchɨ ɨtɨkɨrɨ yɨnʉ ekotema omosegere ihimbʉ yʉ ʉmʉkʉrʉ wayʉ!’ ");
INSERT INTO ikz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nɨkabhuurya, ‘Ʉmʉkʉrʉ, awɨ nɨ‑wɨɨwɨ?’ “Akagarukirya, ‘Inyɨ nɨ‑Yɨɨsu, wʉnʉ ʉkʉnyaacha. ");
INSERT INTO ikz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nangʉ gororoka wiimɨɨrɨrɨ! Nikuhwarukiirɨ, korereke ʉbhɨ omohocha waanɨ. Uhuruchɨ obhomenyeekererya kʉganʉ ʉrʉʉzɨ, na kwa gʉʉsi ganʉ nɨraakwereche. ");
INSERT INTO ikz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nɨrakutuurya mʉmabhoko ga Abhayaahudi na mʉmabhoko ga abhaatʉ bha mubhyarʉ ɨbhɨndɨ. Nɨrakʉtʉma kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi, ");
INSERT INTO ikz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ʉbharamuchɨ amɨɨsʉ, kuhika bharwɨ mukiirimya na kʉbhʉnaja bhwa Shɨtaani bhiikarɨ kubhwɨrʉ bhwa Mungu. Neho bhabheererwe ʉbhʉbhɨ bhwabhʉ, bhabhɨ hamwɨmwɨ na abhandɨ bhʉʉsi bhanʉ bhabhɨngukiibhwɨ kʉnzɨra yu ukunyiisirirya.’ ");
INSERT INTO ikz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ʉmʉtɨmi Agiripa, kwɨbhu nɨtaatigirɨ kʉsʉʉka ʉbhʉrʉri bhʉnʉ bhuruurɨ mwisaarʉ. ");
INSERT INTO ikz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nɨkatanga kurwazɨra abhaatʉ bha Damɨɨsikʉ, bhatigɨ ʉbhʉbhɨ bhwabhʉ, bhabhɨ abharɨndu bha Mungu. Bhakore amangʼana gu ukutiga ʉbhʉbhɨ bhwabhʉ, korereke bheereche ukwichʉra kwabhʉ. Akʉmara nikiija amangʼana gayogayo na kʉbhaatʉ bha Yɨrusarɨɨmu, bhi icharʉ chʉsi cha Yudeya na abhaatʉ bhanʉ bhatarɨ Abhayaahudi. ");
INSERT INTO ikz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Gayo nego gaagiriryɨ Abhayaahudi bhangwatɨ hanʉ bhambwɨnɨ mwihekaaru, bhakeenda kunyita. ");
INSERT INTO ikz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kuhika reero Mungu ansakiiryɨ, akʉrirɨ nimiiriirɨ nereerekeererya abhaatʉ bhʉʉsi abhasuuhu na abhakʉrʉ. Nɨtakʉbhɨraku amangʼana agandɨ, nawe ganʉ nɨkʉgamba nɨ‑ganʉ Musa na abharʉʉtɨrɨri abhandɨ bhagambirɨ kʉbha garakorwa. ");
INSERT INTO ikz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bhʉʉsi bhakabhuga, areenderwa Kiriisitʉ anyaakibhwɨ na kʉbha we embere kuryʉka mʉbhaku, korereke areete ubhwɨrʉ bhwʉ ʉbhʉtɨmi bhwa Mungu kʉBhayaahudi na kʉbhaatʉ bhanʉ bhatarɨ Abhayaahudi.” ");
INSERT INTO ikz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Hanʉ Paaurʉ aarɨ ariibhagɨra, Fɨsitʉ akamutiniirirya kwiraka ikʉrʉ, “Paaurʉ! Awɨɨ ʉsarirɨ! Okosoma kwazʉ bhʉkʉngʼu kukuchurirɨ amangʼɨɨni!” ");
INSERT INTO ikz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nawe Paaurʉ akabhuga, “Umugungwa Fɨsitʉ, inyɨ nɨtarɨ mʉsazi. Amangʼana ganʉ nɨkʉgamba, nɨ‑ga amaheene na ga amangʼɨɨni tʉrʉ, ");
INSERT INTO ikz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","nʉ ʉmʉtɨmi agɨɨzɨ bhwaheene. Nɨratʉra kʉgambana nawe kwa bhʉkararu. Nɨmɨnyirɨ bhwaheene kʉbha rɨtareeho nʉʉrʉ ingʼana rɨmwɨ rɨnʉ atɨɨzɨ, kʉ kʉbha gataarɨ garakorwa kwa mbisi. ");
INSERT INTO ikz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ʉmʉtɨmi Agiripa, uriisirirya ganʉ gaagambirwɨ na abharʉʉtɨrɨri? Inyɨ nɨmɨnyirɨ kʉbha ʉragiisirirya.” ");
INSERT INTO ikz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiripa akamʉbhʉʉrɨra Paaurʉ, “Kʉmangʼana gaazʉ amasuuhu ganʉ, oreenda kunchʉra nɨbhɨ Mukiriisitʉ?” ");
INSERT INTO ikz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paaurʉ akamʉgarukirya, “Nɨrasabha Mungu, arɨɨbhɨ nɨ‑kwa amasuuhu nʉʉrʉ kwa maaru, ɨtarɨ kwa naawɨ aumwene nawe na bhanʉ bhʉʉsi bhakunyiitegeerera reero bhabhɨ ncha niinyɨ, nawe mutigɨ kobhohwa na zisiri zɨnʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ʉmʉtɨmi akiimɨɨrɨra, hamwɨmwɨ nu umwanangwa Fɨsitʉ na Bhɨrinikɨ na abhandɨ bhanʉ bhaarɨ bhiikɨɨrɨ hamwɨmwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Hanʉ bhaarwirɨ hayo, bhakiibhʉʉrɨra, “Ʉmʉʉtʉ wʉnʉ, ataakʉrirɨ ryʉryʉsi rɨnʉ rikugirya iitwɨ nʉʉrʉ kobhohwa.” ");
INSERT INTO ikz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiripa akabhʉʉrɨra Fɨsitʉ, “Ʉmʉʉtʉ wʉnʉ angatamirɨ kʉbha asabhirɨ ikiina chazɨ kitinirwɨ na Kaisaari, aarɨ aratigurukirwa.” ");
INSERT INTO ikz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Hanʉ yaswajibhwɨ kʉbha tujɨ nu ubhwatʉ ɨɨsɨ ya Itaariya, Paaurʉ na abhabhohwa abhandɨ bhakatuurwa mʉmabhoko gʉ ʉmʉkʉrʉ wa abhasirikarɨ. Ʉmʉkʉrʉ wuyo iriina ryazɨ Yuuriyo, wa riribhita rya abhasirikarɨ rɨnʉ ryarɨ rɨrabhirikirwa Riribhita rya Kaisaari Agusitʉ. ");
INSERT INTO ikz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tʉkatiira mubhwatʉ bhʉnʉ bhwarɨ bhukurwa ʉrʉbhɨri rwa Aduramitiiyʉ, bhwarɨ bhʉraja kubhihuukʉ bhya Asiya. Tʉkarwa hayo, tʉrɨ hamwɨmwɨ na Arisitʉʉrikʉ, wa kʉrʉbhɨri rwa Tɨsarʉʉnikɨ mucharʉ cha Makɨdʉniya. ");
INSERT INTO ikz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Hanʉ bhwɨrirɨ, tʉkahika kʉrʉbhɨri rwa Sidʉʉni. Yuuriyo akakorera Paaurʉ bhwaheene ku kumwisirirya iirore na abhasaani bhaazɨ, korereke bhaazɨ kʉmʉsakirya kubhwɨndi bhwazɨ. ");
INSERT INTO ikz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tʉkakaja no orogendo kurwa iyo, nawe tʉkahɨta rusizʉ wa riginga rya Kipurʉ korereke tutigɨ kotemwa bhʉkʉngʼu nʉ ʉmʉkama. ");
INSERT INTO ikz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tʉkaambʉka ɨnyanza yiyo, tʉkahɨta ʉrʉbhaara rwa Kirikiya na rwa Pamufiiriya, tʉkahika Miira ʉrʉbhɨri rwa Riikiya. ");
INSERT INTO ikz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ʉmʉkʉrʉ wa abhasirikarɨ akabhona ubhwatʉ bhwʉ ʉrʉbhɨri rwa Arɨkizandiriya, bhʉnʉ bhwarɨ bhʉraja mʉʉsɨ ya Itaariya, akatutiiryamu. ");
INSERT INTO ikz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tʉkamara zisikʉ nzaru, tʉkabha tʉraja hanyʉʉhuhanyʉʉhu nu ubhwatʉ kwa nyaakʉ, tʉkahika haguhɨ nʉ ʉrʉbhɨri rwa Niidʉ. Ʉmʉkama ʉmʉhaari gʉkatorecha kʉhɨta ɨnʉ twarɨ toreenda kʉhɨta, gʉkagirya tʉhɨtɨ inyuma ya riginga rya Kireete, ʉrʉbhaara rwa Sarimʉʉnɨ. ");
INSERT INTO ikz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tʉkahɨta rusizʉ kwa nyaakʉ, tʉkahika hanʉ hakubhirikirwa Ikihuukʉ Ɨkɨzʉmu, haguhɨ na kʉrʉbhɨri rwa Raseeya. ");
INSERT INTO ikz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twarɨ tuhikiryɨ sikʉ nzaru morogendo, na zisikʉ zu ukwiyima kurya zaarɨ zihitirɨ. Kʉ gayo ɨkarorekana tʉraangʼehe no orogendo ruyo, turiku kobhona ɨnyaakʉ. Neho Paaurʉ akabhatongera abhakɨndichazɨ, ");
INSERT INTO ikz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Imwɨ, inyɨ nɨrarora kʉbha orogendo rwɨtʉ rʉnʉ, rʉraaza kotoreetera ɨnyaakʉ. Ubhwatʉ bhʉnʉ hamwɨmwɨ ni imirigʉ jaku, bhyʉsi bhɨratʉra kurikɨra mʉnyanza. Ɨtarɨ kubhwatʉ ni imirigʉ ibhyene, nawe nu ubhwikari bhwɨtʉ.” ");
INSERT INTO ikz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ʉmʉkʉrʉ wa abhasirikarɨ wuyo, atiisiriiryɨ amangʼana ga Paaurʉ, akiisirirya amangʼana gʉ ʉmʉkangati wu ubhwatʉ nu umwene bhwatʉ. ");
INSERT INTO ikz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Hamwɨmwɨ na gayo, ikihuukʉ kiyo bhaarɨ, charɨ kɨtarɨ kɨzʉmu kʉbhaho ribhaga rye embeho. Ɨkagirya abhaatʉ bhaaru mubhwatʉ bhagambɨ amangʼana kʉbha, bharwɨ hayo bhajɨ mubhiribhʉkʉ ɨbhɨndɨ kwiginga rya Kireete, rɨnʉ rikubhirikirwa Fʉinikɨ, neho bhabhɨ hayo ribhaga rye embeho. Ikiribhʉkʉ cha Fʉinikɨ kɨrarora ɨnʉ iryʉbha rikugwa. ");
INSERT INTO ikz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ʉmʉkama ʉmʉzʉmu gʉkatanga kuhuuta hanyʉʉhu kurwa rangɨ. Ɨkagirya bhu ubhwatʉ bharore kʉbha bhabhwɨnɨ ɨnzɨra yʉ ʉkʉkaja orogendo rwabhʉ, chɨmbu bhaarɨ bhakwenda. Bhakiiha ikitimbʉ chu ubhwatʉ, bhakarwa hayo, bhakahɨta rusizʉ wa riginga rya Kireete. ");
INSERT INTO ikz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ribhaga rɨnʉ twarɨ tʉrarwa mʉbhɨgʉrʉ bhya riginga riyo, ʉmʉkama ʉmʉhaari gʉkahuuta bhʉkʉngʼu, gʉnʉ gwarɨ gukubhirikirwa Eurakiro. ");
INSERT INTO ikz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ʉmʉkama guyo gwarɨ gʉratema kʉrʉbharu rwu ubhwatʉ bhuyo. Nʉʉrʉ tʉkanyaaka nagwɨ, nawe gʉkatuhiza, gʉkatuhira gatɨgatɨ wɨ ɨnyanza. ");
INSERT INTO ikz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tʉkahɨta inyuma ya akaginga kasuuhu kanʉ kaarɨ karabhirikirwa Kauda, kakaturibhɨra hasuuhu ʉmʉkama ʉmʉhaari guyo. Hayo tʉkanaja kwa nyaakʉ, kʉsabhʉra ubhwatʉ bhwʉ ʉkʉsabhʉra abhaatʉ, bhʉnʉ bhwarɨ bhʉrahirwa na amanzi. ");
INSERT INTO ikz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ribhaga rɨnʉ twarɨ tukubhuruta muyo, abhahocha bha mubhwatʉ bhayo bhakagaja ubhwatʉ bhuyo zisiri, korereke bhutigɨ kʉbhaarʉka. Bhakʉʉbhaha bhataaza kwangɨra momosekeenya gwɨ ɨnyanza, yɨ ɨɨsɨ ya Riibhiya. Ɨkagirya bhakiicha amabharu gu ubhwatʉ bhuyo, bhakabhutiga bhurutwɨ. ");
INSERT INTO ikz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Amakunda gakangʼeha kotema ubhwatʉ bhuyo, hanʉ bhwɨrirɨ abhahocha bhu ubhwatʉ bhayo bhakatanga korekera imirigʉ mʉnyanza. ");
INSERT INTO ikz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Hanʉ bhwɨrirɨ urusikʉ rwa katatʉ, bhakatanga korekera ebhegero bhyu ubhwatʉ mʉnyanza kʉmabhoko gaabhʉ abheene. ");
INSERT INTO ikz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Zɨkahɨta zisikʉ nzaru iryʉbha na zenzota bhɨtakororekana, ɨnyanza ɨkangʼeha kubhuusuka. Ɨkagirya twiseege kʉbha tʉtakohona. ");
INSERT INTO ikz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Hanʉ abhaatʉ bhayo bhaamarirɨ sikʉ nzaru bhatakurya, Paaurʉ akiimɨɨrɨra gatɨgatɨ waabhʉ, akabhabhʉʉrɨra, “Nɨkabhabhʉʉrɨra ribhaga rɨnʉ twarɨ Kireete kʉbha tʉtarweho, yaarɨ